﻿USE sofia;
DROP TABLE IF EXISTS sofia.tvk_vpl;
CREATE TABLE tvk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tvk_vpl WRITE;
INSERT INTO tvk_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Tetiamu, Iahova tesa vat xil mei latetutou ni mol‑Isrel xil, vengan xa suv toto nae tehe tovuol tamu tengan valaxat xil mu valepis rin nae xil. E melele nen ak, mae kekaten tei xa eilep tekapis e tan xa mol‑Isrel lateti en. Reitin, us tamus ti aveti xil holu e misak ni anien tovuol e mae di nggat moletin xil. Misak ni, moletin tei te metimal te hal Betlehem e tan na mol‑Sudah xil, xi tehe kantri te hal Moab, hisen Elimelek, e xi texo vatimol xa mahulong na Efrat. Xi teha tetel atou nan, hisen Noume, e tetel horamue lu nalu, hisealu Malon xal Kilion. E xil ba lateti e tan na mol‑Moab xil huram vahis. ");
INSERT INTO tvk_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","E melele xa lateti rute ak, Elimelek temat, ma Noume teta tasen tang tetel horamue nan xalu. ");
INSERT INTO tvk_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Di, horamue nan xalu ak luteteli mi atou lu te hal Moab, hisealu Oripa e Rut. Melele xa huram he xalu (10) mei tetavi, ");
INSERT INTO tvk_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malon xal Kilion mun lutelel. Ma, Noume tetat temak tang, tiramue nan e horamue nan xalu mun latehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Aveti vahis mei mitavi, e Noume milongeong ni xa Hi di duxol xat moletin nan xil nggo rin xa di misak ni anien sae xil di meul bos rilomun. Misak ni, Noume bue xat xi tengan ihe reling kantri te hal Moab itel havnahin xalu. ");
INSERT INTO tvk_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Xatel vus latobituei latoba tengan latotilomun latohe tan na mol‑Sudah xil. E melele xa di latoba, ");
INSERT INTO tvk_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Noume biteni mi xalu bit, “Multilomun mun tang mulihe visal ninemil xati xalu e multit itel xalu. Inou nasis tengan Hi ipisen hosien mi xamil ixoni ngan taxa mutepisen ni minou tetel horamue navan xalu xa lulel tuei. ");
INSERT INTO tvk_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Nasisi mun xa Hi ipol ni xamil mulkila muliteli rilomun e mulikamet hosien itel tiramue hu namil xalu.” Di, Noume po xat xalu tengan istokovein xalu laliha. E xalu di lumuis ");
INSERT INTO tvk_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","e lubiteni mi Noume lubit, “!Masakras li malhe relinguk! Xamel malhusiluk, ratiha ratti vituei itel moletin nam xil.” ");
INSERT INTO tvk_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","E Noume bit rilomun ni mi xalu bit, “Havuxahin xalu, bos mak mu xa multilomun muliha. ?Veneh ma mubit mulhusil inou? ?Munemi mubit inou nikila niling horamue lu mun tengan muliteli mun itel xalu? ");
INSERT INTO tvk_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","!E‑e! !Muliha! Inou nabe tovolih pupu tengan nateli rilomun. ?Tave ti neta xosxa inou nanemi namit nakila niteli mun xosali tang, e niling horamue lu mun, ");
INSERT INTO tvk_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","xamil mukila multatil xalu ha vuma … lalimatu lalipin ni tetelien? E‑e, ngan ak misakras vastal vamak. Havuxahin xalu, xos mukila mulikamet hosien mu e meulien namil, e inou nasakras. Mulnahusil nou ti. E meulien navan, napus longpangasien holu vengan xa he Iahova di nggeih da xat inou.” ");
INSERT INTO tvk_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Xalu lumuis vatei mun. Di, Oripa maheah xat avu sasa nan, misep lingi, e ba tengan vatilomun vahe visal vatimol nan xil. E Rut, xi miteli en nggeih, ien ti tavei vahe reling Noume. ");
INSERT INTO tvk_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ma Noume biteni mini bit, “?Rut, pus ti? Tumahin di dilomun tengan vahe visal moletin nan xil e hi nan xil. Xouk mun uhusili muliha ha upus vatimol nam xil.” ");
INSERT INTO tvk_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","E Rut bit rilomun ni mini bit, “!Onasil nou ti tengan name relinguk! Umaen nou li nihusiluk. !Rute xave xa uha en, inou mun niha en! !Rute xave xa uta en, inou mun nita en! Moletin nam xil, lihe moletin navan xil mun. E Hi nam, ihe Hi navan mun. ");
INSERT INTO tvk_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Rute xave xa umat en, inou mun nimat en, e litihin nou e rute ak. Nasakras namaen neta tova vahur rat nou ra xouk ha vuma … tei ralu imat. !Ngan ak be hitxatien navan e Iahova isa pangasien te xeih mei iti xat nou xosxa nihur xotehi!” ");
INSERT INTO tvk_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Melele xa Noume pus kila xa Rut, nenemien nan nggeih tengan ihusili, xi tasak ti mun tengan vasila vahe relingi. ");
INSERT INTO tvk_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ma xalu lukakao vuma … ba luduxoh metimal te hal Betlehem. E melele xa be lustal en, moletin xil vus te rute ak latemanin ni xalu. E atou xil lamesep pupu labit, “?Noume mak xiak?” ");
INSERT INTO tvk_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","E Noume bit rilomun ni mi xil bit, “Munakes nou ti mun ni ‘Noume’ e mukes nou ni ‘Mara’ vengan xa Iahova pol ni meulien navan mei mikon ni longpangasien. ");
INSERT INTO tvk_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Melele xa natehe reling rute ak, heok xalu tepolu ni hosien, e taxeak, Hi nggur rilomun ni nou mei nabe heok hon tang. ?Veneh ma mukes nou ni Noume vengan xa Hi te Xeihen tepol ni texeih pupu minou e tesa longpangasien minou?” ");
INSERT INTO tvk_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nggo sexien ak, Noume nggo kantri te hal Moab e dilomun bemei e tan te hal Isrel del havnahin Rut, xa be ate‑Moab. E melele xa mei lustal e metimal te hal Betlehem, bale mun tehe temetu e naho sa mol‑Isrel xil. ");
INSERT INTO tvk_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","E metimal te hal Betlehem, eilep tei da en xa holesok nan holu, hisen Boas. Xi nggo vatimol xati na Elimelek, tiramue na Noume. ");
INSERT INTO tvk_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Vatei, Rut misis Noume bit, “Umaen nou nihe naho tova tengan nileh viton bale xil xa moletin te polien xil laki rasi di nga tengan mei ihe anien aralu. Xos nikila nikamet moletin tova xa imaen nou nipol e naho san.” Ma Noume maen ni bit, “Havuxahin, bos tang, ha upol ni.” ");
INSERT INTO tvk_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ma Rut ba be naho tei e di pol dutou ni moletin te polien xil e di mileh viton bale xil. Rut ba mileh rut bale xa xil laki rasi di nga. E Rut, xi takil ti xa naho xa di pol en sa Boas xa nggo vatimol xati na Elimelek, tiramue na Noume. ");
INSERT INTO tvk_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Tavehi ti, Boas nggo metimal te hal Betlehem e mei mistal mi moletin te polien nan xil e mikei ba ni xil bit, “!Iahova iti mi xamim!” Ma xil labit rilomun ni mini labit, “!Iahova ituxol xatuk mun!” ");
INSERT INTO tvk_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Di, Boas misis vat te polien nan bit, “?Atul maxoe xai be na visi?” ");
INSERT INTO tvk_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ma vat ak bit rilomun ni mini bit, “Atou xai be te hal Moab, e be xal Noume iaxa lumei. ");
INSERT INTO tvk_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Xi misis nou tengan nimaen ni iha ti ihusil moletin te polien xil e ti ileh viton bale xil xa laki rasi di nga. Xi temei makoe roroh tamu e di ni polien duxoh taxeak. Xi ba mingel vuteili tang pe horao iaxor.” ");
INSERT INTO tvk_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Di, Boas ba misepin del Rut bit, “Ei, atuli. Uteong ni nou, ieok bei tengan upol e naho savan sangas visal atou te polien navan xil. Onaha ti mun naho na mosav tengan oleh viton bale en. ");
INSERT INTO tvk_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Rute xave xa xil ti lipol en, xouk mun utat visal xil. Nasep xol moletin navan xil tuei tengan linapol ti nasa minuk. E xosxa meruru iatuk, ma uha umu ti oei e valoei xa langgutihi tuei di.” ");
INSERT INTO tvk_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Melele xa Rut milonge mak, mitingeiril e valnaon ba duxoh tan. Xi bit rilomun ni mini bit, “?Veneh ma di onexo ve nou? ?Veneh ma di opol ni bos minou xa nabe ngan halesav tei tang?” ");
INSERT INTO tvk_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas bit rilomun ni mini bit, “Inou nalongeong ni sexien hos xil xa otepisen ni mi avu sasa nam melele xa tiramue nam temat. Nakila xa xouk otehe reling tamom e ninom e kantri xati nam tengan mei odi mi moletin xil xa otnakil ti xil tetiamu. ");
INSERT INTO tvk_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nasis mi Iahova tengan isa xoles hosien xa otepisen ni mini. Reitin, Iahova, Hi na mol‑Isrel xil, isa sanien tei xa ihos pupu minuk vengan xa xouk oteling nenesien nam en tengan ilaxatuk e isikoe xol meulien nam.” ");
INSERT INTO tvk_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Di, Rut bit rilomun ni mini bit, “O eilep navan, xouk opol ni bos pupu minou li. Neta sav xa inou natapin ti tengan name atou te polien tei nam, xouk osepin kuhi minou e odal rat nenemien navan.” ");
INSERT INTO tvk_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","E piniae, melele xa moletin te polien xil di langganien, Boas biteni mi Rut bit, “Amei visal xamem, a ti beret e usa ni ihe uaen xa mikon xiak.” Ma xi dotan del moletin te polien xil, e Boas misa rut bale xa ladin ni meses mini. Xi ngganien pipin e miserev kuh anien an xa ngga lingi ba di. ");
INSERT INTO tvk_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Melele xa Rut dilomun ba tengan vapol, Boas misel xat moletin te polien nan xil bit, “Mumaen ni ileh viton bale e rute xil vus xa ien bei. Tave ti neta xosxa ileh rerati ra vanute xil xa mubar viton ni ngamu di, munasep xole ti. ");
INSERT INTO tvk_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","E tei mun, bos xa muleh rerat ti bale ra vanute xil e muso ni ihe tan tengan atou ak mei ti ilehi.” ");
INSERT INTO tvk_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ma Rut mileh viton bale e naho ak ba duxoh mahis. E melele xa bas rerat utute, mikameti xa utut bale xil vus xa milehi, kilo nen be lu e le tei (12 kg). ");
INSERT INTO tvk_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Mileh utut bale xil ak dilomun be tim e ba pisen ni mi avu sasa nan. Di, rut anien xa teserev kuhi, ngan ak mun, Rut misa ni mini. ");
INSERT INTO tvk_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Melele xa Noume pusi, mitemanin e misisi bit, “?Xosali, oleh viton utut bale xil ak ingga xave? ?Naho sasi vari iaxa xouk otepol en? Tuxolxatien na Hi iti mi moletin xa pusuk e pol bos minuk mak.” Ma Rut biteni mi Noume bit, “Natepol e naho sa moletin tei xa hisen Boas.” ");
INSERT INTO tvk_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Noume mikei nggeih bit, “!Tuxolxatien na Iahova iti mini! Iahova di pisen hosien nan mi ralu xa rumeul rudi e mi tiramue naralu xalu xa lulel ngamu. Moletin xai nggo vatimol xati na tiramue naralu xalu. E nggusil sexien na mol‑Isrel xil, xi iaxa ilaxat kuh rin naralu.” ");
INSERT INTO tvk_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ma Rut bit, “E ngan bos mak mu, xi biteni minou bit tit nileh viton bale itel moletin te polien nan xil ha ituxoh melele xa lileh vuol ni bale ra naho san xil.” ");
INSERT INTO tvk_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Noume biteni mi Rut bit, “O havuxahin, bos mak mu xa xouk tit upol itel atou xil xa di lapol e naho sa Boas. Vengan xosxa upol e naho sa mosav, vahit moletin tova vapol vasa minuk.” ");
INSERT INTO tvk_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ma Rut pol del xat atou te polien xil na Boas ba vuma … duxoh melele xa laleh vuol ni bale, e dutou, laleh uit mun ra naho san xil vus. E Rut nggulehi dat visal tova nan. ");
INSERT INTO tvk_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Vatei, Noume biteni mi Rut bit, “Havuxahin, bos xa nikamet tiramue tova tengan muliteli e ilaxat kuh xouk. ");
INSERT INTO tvk_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","?Onem xat Boas, moletin xa di otepol tetel atou te polien nan xil? Xi nggo vatimol na tiramue naralu xalu. Ma uteong kuhi ni sepinien navan. Xosali mahis, xi iha ihas rerat utut bale ra valite. ");
INSERT INTO tvk_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ma xouk uha uxul, using ihos, e uhas ti vokon e xouk. Ti, uhe von polien nan, e onapol ni ti xa xi nakila xa xouk ode rute ak. Utatil melele xa xi ianien e imu ti uaen ivus ");
INSERT INTO tvk_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","e upus xat kuh rute xa xi ha ipat en. Melele xa xi ipor vovong, uha ulat kutei man e ha upat uting xat kaelen tengan ipisen ni xa usisi tengan ilaxat kuh rin nam xil. Ti, xi sung ihit naha xa xouk upol ni.” ");
INSERT INTO tvk_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut bit rilomun ni mini bit, “Inou nipol vuol ni neta xil vus xa obiteni minou tengan nipol ni.” ");
INSERT INTO tvk_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ma Rut be von polien na Boas, e pol ni nggoni ngan xa tova nan tehiteni mini. ");
INSERT INTO tvk_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Melele xa Boas ngganien e mu uaen bus, xi milonge bos. Di, be visal seri tatit bale xa mitihu di e ba pat. Melele xa xi por vovong, Rut mika merou ba, milat kutei man e ba pat miting xat kaelen. ");
INSERT INTO tvk_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","E hilaep te vongien, Boas mitemanin ni neta tei. E melele xa mea biles, pusi xa atou tei di pat e di miting xat kaelen. ");
INSERT INTO tvk_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ma misisi bit, “?Ei, xouk visi xiak?” E Rut bit rilomun ni mini bit, “Inou Rut li tang, atou te polien nam. Suv, xouk obe tei e vatimol na tiramue navan xa mat tuei. Misak ni, nggusil sexien namim xil, xouk iaxa ulaxat kuh rin xil navan, e ukila uhur nou mei nihe atou nam.” ");
INSERT INTO tvk_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","E Boas bit rilomun ni mini bit, “Rut, Iahova ituxol xatuk. Di opisen sexien xa bos mi vatimol namem xil xa be eilep mak mu mili naha xa di opisen ni mi tova nam xa be tunau namem. Xouk, vongite xa ova olang ni tiram maxoe sav tova ngamu, ngan xa holesok nan holu mu ngan xa holesok nan tovuol, e xouk otapol ni ti. ");
INSERT INTO tvk_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ma xouk onanem ti nahe holu usil naha xa istal. Inou nipol vuol ni holesok xil xa otesis nou ven tengan nilaxat rin nam xil vengan xa xouk obe atou tei xa moletin xil vus lapus kil hosien nam. ");
INSERT INTO tvk_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Reitin mak xa inou nabe ngan xa ilaxat kuh rin nam xil vengan xa nabe vatimol xati na tiramue nam xa temat e nakila nihuruk e nilaxatuk. E moletin tei mun de vatimol namem xa xi mak mu be sangas ni tiramue nam, e xi mikila itiamu ni nou tengan ihuruk e ilaxat rin xil nam. E xos ien ti navei, ma inou sung nipol ni. ");
INSERT INTO tvk_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","E vongien ak, bos xa uta tak. Ti, sangas ut ilan, ma ralikameti e ralikila xa xi ien ihei tengan ilaxatuk mu ien ti navei. Xos ien ihei, ma bos, e xos ien ti navei, ma inou nabiteni reitin pe met Iahova xa inou sung, nihuruk e ti nilaxatuk. E xosali vongien, upat uta tak ituxoh makoe.” ");
INSERT INTO tvk_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ma Rut pat miting xat kaelen duxoh makoe. E makoe roroh tamu, xi mitamea tengan vaha, vengan xa Boas ien ti tavei tengan moletin xil lakila xa atou tei temei tepat e von polien nan. ");
INSERT INTO tvk_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","E diamu xa bit vaha, Boas biteni mini bit, “Hur rat kot nam e uten ni itak.” Melele xa Rut miten ni, Boas mirang utut bale xa kilo nen duxoh hanutap tei e he xalu mun (30 kg) ba en. Di, dutou ni po rati de vatuvun e Rut poe dilomun be tim. E Boas, xi be metimal. ");
INSERT INTO tvk_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Melele xa Rut duxoh tim, tova nan misisi bit, “?Havuxahin midep?” Ma Rut bit vuol ni holesok xil xa Boas biteni mini. ");
INSERT INTO tvk_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","E Rut biteni mun mini bit, “E xi ien ti tavei xa heok vaka hon melele xa nadilomun namei tim mei napusuk, ma misa utut bale xil ak xa kilo nen be hanutap tei e he xalu mun (30 kg) minou.” ");
INSERT INTO tvk_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Noume bit rilomun ni mini bit, “Onanexo ti. Utatili tengan upus ti xa rin ak istal itep, vengan xa Boas misakras vangel ha vuma … imal ni rin xil vus nam.” ");
INSERT INTO tvk_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","E makoe ak, Boas ba dotan e von totanen xa de sangas visal puiteh te vioh te metimal te hal Betlehem. Di, Boas pus moletin xa di tesep usili bit xi be sangas mu ni tiramue na Rut. Melele xa Boas pusi xa di mikakao tengan vali, mikesi bit, “Tua navan, amei mu, totan ti inggaxalei.” Ma moletin ak bemei dotan visali. ");
INSERT INTO tvk_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Di, Boas ba mikamet eilep xil labe he xalu (10) tengan limei liteong ni rin nalu. Melele xa xil vus lamei vituei, ");
INSERT INTO tvk_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boas biteni mi tua nan ak bit, “Noume xa dilomun nggo kantri te hal Moab bemei, xi ien bei tengan vapos ni tan xil na tiramue nan Elimelek iha mi vatimol tei nan xa tehe vatimol naralu. ");
INSERT INTO tvk_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","E inou nanemi momal xa nisep kila minuk. Ma xosxa xouk iem ihei, ma ukila uxale pe met ngan xil xa ladotan ladi xiak. E xosxa iem ti navei, ma uhiteni, vengan xa xouk obe sangas mu mi tiramue na Noume mili nou e ukila uxal rat tan ak itiamu. E xosxa onaxale ti, ma inou sung nixale.” E moletin ak bit, “E‑e, inou nixale.” ");
INSERT INTO tvk_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Di, Boas biteni mini bit, “Bos pupu. E melengien xa uxal rat tan ak ra Noume, uhur tunau Rut mun xa be ate‑Moab. Ixo suse ak, ma muimol namil ikila ihur tan e holesok sav xil na tiramue na Rut xa mat tuei tengan vatimol nan navop ti.” ");
INSERT INTO tvk_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Melele xa moletin ak milonge mak, bit rilomun ni mini bit, “Ve rin ak, inou ninaxal ti tan ak, vengan xa inou nasakras nasa rati mi horamue xati navan xil vahe nae. Itep, ma xouk tang uxale, inou ieok ti tavei mun.” ");
INSERT INTO tvk_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(E melele nen ak, sexien na moletin xil mak: melele xa labit lapos ni tan tei mu neta sav tova, ma moletin xa tan nan ileh rerat sandel tei nan, e isa ni mi ngan xa ixale. Sexien ak ipisen ni xa lasep maen ni ngamu tengan lixal rat tan ak.) ");
INSERT INTO tvk_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ma melele xa moletin ak maen tan ak mi Boas tengan vaxale, xi mileh rat sandel nan e misa ni mini. ");
INSERT INTO tvk_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Di, Boas di bithiteni mi eilep xil e ngan tesav xil mun bit, “Xamim vus mupus rin xa mistal xosali xa inou nanggal rat holesok xil vus ra he Noume xa tehe na Elimelek del horamue nan xalu xa hisealu tehe Kilion e Malon. ");
INSERT INTO tvk_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","E rin tei mun, nihur Rut mun, ate‑Moab xa teteli tetel Malon tetiamu, mei ihe atou navan. Nggoni sexien nar, muimol namel xa ihe malohos ikila ihur xat holesok xil vus xa vahe na Malon. Ngan ak isak ni vatimol xil na Elimelek navop ti, xil lixulehi liti visal xir e melengien xil xa ti imei. Xamim vus mupus naha xa mistal taxeak.” ");
INSERT INTO tvk_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Eilep xil e moletin sav xil mun labiteni mini labit, “Io, xamem mapus holesok xil xa mistal xosali. Xamem musis mi Iahova tengan ipol ni atou ak xa mei iti e tim sam mei ixoni Resel xal Leah, xa lutepes horamue xil holu na avu Siekob xa mei labe vatimol xil xa mahulong te hal Isrel. E, e rin nam, musis mun tengan Iahova ipol ni xouk uhe eilep tei xa moletin xil xa langgo vatimol na Efrat limerere ni. Reitin, xi isa his tei minuk xa ihe eilep e metimal nar te hal Betlehem. ");
INSERT INTO tvk_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Musis xa Iahova isa horamue xil minuk ixo ate maxoe ak xa lisak ni vatimol nam mei ihe mahulong ixoni vatimol na Peres, nat Sudah xa Tamar telingi.” ");
INSERT INTO tvk_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ma Boas nggur Rut mei be atou nan e Iahova duxol xati. Ma xi di ni tuvava tei, e milingi be malohos. ");
INSERT INTO tvk_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Atou xil labiteni mi Noume labit, “!Rapet rat his Iahova! Xosali, xi misa havmali tei tengan ti ilaxat kuh xouk. Masis tengan horamue ak mei ihe eilep tei e kantri te hal Isrel. ");
INSERT INTO tvk_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Havmahin, eheien nan eilep pupu e xouk. Holesok xil vus xa pol ni minuk bos mak mu mili xosxa natumali xil latehe lu e he sav (7). Horamue xa Rut tehuri xiak isak ni meulien nam ihe neta hu rilomun, vengan xa melele xa umei uhe tovolih kuhi, xi ikila ilaxatuk.” ");
INSERT INTO tvk_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ma Noume po rat tuvava ak, bulu xati e di milaxati. ");
INSERT INTO tvk_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Atou xil xa ladi sangas mi xil mei laling his tuvava ak be ‘Obed.’ Labiteni mi moletin xil vus labit, “Tutut horamue tei, Noume nggur xao ni be nan.” Melele xa mei matu, Obed mei be tame Tiese, xa mei be tame suv toto Deved. ");
INSERT INTO tvk_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","E ngan ak be vatimol xa testal texo Peres: Peres tehe tame Hesron. ");
INSERT INTO tvk_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron tehe tame Ram xa tehe tame Aminatap. ");
INSERT INTO tvk_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminatap tehe tame Nason xa tehe tame Salmon. ");
INSERT INTO tvk_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon tehe tame Boas xa tehe tame Obed. ");
INSERT INTO tvk_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","E Obed tehe tame Tiese xa tehe tame suv toto Deved. ");
INSERT INTO tvk_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","E tan te hal Isrel, provet tei da en, hisen Siona, nat Amitai. Vatei, Iahova misa sepinien tei mini bit, ");
INSERT INTO tvk_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Utemanon uhe taon xa mahulong te hal Nineva, e usel xat moletin xil xa ladi en. Uhiteni mi xil xa sexien nae xil pupuru pupu pe metok.” ");
INSERT INTO tvk_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","E Siona, ien ti tavei vahusil suse xa be ist tengan ha vasa sepinien na Iahova mi mol‑Nineva xil xa ladi e kantri tei xa de ist. Mak, ma xi biles be wes e suse sav tengan valesae rani. Siona ba duxoh pasis e taon te hal Siopa, e mikamet tuturil tei xa di labue xat xi tengan vahe Spen, kantri tei xa be sotin pilei mak e rin xa wes. Ma xi minggal suse nan e be tuturil ak del boskru xil teni. Di, tuturil ak miloh tengan vahe Spen del Siona xa di milesae ra Iahova. ");
INSERT INTO tvk_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Melele xa tuturil ak di miloh ba, Iahova pol ni votiang mu e tas misa xa misa, e sangas tuturil ak vamahoe lel. ");
INSERT INTO tvk_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Boskru xil ulixil mikan pupu, e xil kekes di ladakes hi nae xil tengan lasa tutouen mi xil. Di, laleh rat holesok xil xa ladi vangit tuturil e laso ni be tas tengan vapol ni tuturil ak vameit mu. E melele xa holesok xil ak di mistal, Siona dit por sae e vangit tuturil ak. ");
INSERT INTO tvk_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","E melele xa vatihos te tuturil ak be vangit, mikamet Siona e biteni mini bit, “!Ei! ?Veneh ma di opat mak? !Utamea, e usis mi hi nam ve tutouen! Xos xi iaxa mikila ien isae e xir e iteh meulien e xir.” ");
INSERT INTO tvk_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Di, boskru xil lamei vituei e laling nenemien nae tengan lilihi hisexil tengan lakameti xa visi e xil di milihi an tesa ak ba xat xil. E melele xa lapol ni, lalihi his Siona. ");
INSERT INTO tvk_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ma ba lasepin mini labit, “?Ei, uhiteni mi xamem, veneh ma an tesa ak di bas xir? ?Polien eah iaxa xouk di opol ni? ?Xouk onggo kantri xave e moletin nam xil labe hisit moletin eah?” ");
INSERT INTO tvk_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ma Siona biteni mi xil bit, “Inou nabe ngan Isrel tei e di namot mi Iahova, Hi te ut nesao xa tepol ni tan e tas.” ");
INSERT INTO tvk_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Di, Siona bit rat xi mi xil bit xi di milesae ra Iahova. Melele xa boskru xil lalonge mak, ulixil mikan pupu ma lasel mini labit, “?Veneh ma otepol ni tesaen ak?” ");
INSERT INTO tvk_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","E melele xa lapusi xa votiang di bemei nggeih pilei mu, lasis Siona labit, “?Uhiteni mi xamem, mupol ni itep tengan isak ni an tesa ak ihe tan?” ");
INSERT INTO tvk_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ma Siona bit rilomun ni mi xil bit, “Mupo nou e muso nou nihe tas. Melele xa mupol ni imak, ma tas mei ihos rilomun. Nakila xa votiang ak bas xir mak venou vari.” ");
INSERT INTO tvk_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","E boskru xil iexil ti tavei tengan laso Siona vahe tas. Misak ni xil lasak tengan lavalis ni tuturil ak vahe ut, e lasakras vengan xa tahe xil mei labe tellep mu e votiang mei nggeih pilei sung. ");
INSERT INTO tvk_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ma di, xil ladakes Iahova labit, “O Iahova, masis minuk li xa onasa pangasien ti mi xamem ve maten na moletin xai. Reitin, onahas xamem ti li vengan xa xouk, Iahova, otepol ni holesok xil ak testal texo hem e tehusil lingxatien nam kestang.” ");
INSERT INTO tvk_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Di, lapo rat Siona e laso ni be tas. E vatakes, tas mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Melele xa boskru xil lapusi mak, lamerere ni Iahova himetu. Ma lasa sanien eo tei te memesien mini e xil kekes lapol ni hitxatien nae xil dela. ");
INSERT INTO tvk_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","E Siona tamat ti. Iahova misil meseo tei xa mahulong mei miromi e Siona meul tang de vang meseo ak melengien tol. ");
INSERT INTO tvk_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Melele xa Siona de vang meseo ak, xi misis mi Iahova, Hi nan, bit, ");
INSERT INTO tvk_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“O Iahova, melele xa longpangasien navan mei mahulong pupu natekei tehat minuk li, e xouk oteteong ni nou e otetutou ni nou. Melele xa natenemi natehit di nabe von maten, natetakesuk, e xouk oteteong ni nou li. ");
INSERT INTO tvk_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Xouk oteso nou natehe mesavuol e natemerir natehe huinep te tas. E inggak, tas teta xol nou e tahe xil mun latekilkiles ni nou. ");
INSERT INTO tvk_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Natenemi natehit otesil rat nou natehe relinguk, e ninapus ti mun Nim Eo nam. ");
INSERT INTO tvk_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Tas teta xol nou, natemerir natehe tan e lulum te tas tevar xat vatuk. ");
INSERT INTO tvk_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Natehe tan teha vuma … natetuxoh vatit hu xil xa ladi pe tas, e natelonge lehit ngan xa natetuxoh von maten e nateta tuok. E xouk Iahova, Hi navan, otemei sung otehur rat nou ra pe tas ak tengan nameul rilomun. ");
INSERT INTO tvk_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","O Iahova, melele xa natelonge texoni ngan xa meulien navan sangas vavus, natenem rilomun ni xouk. Natesis tehat minuk, e otelong nou e Nim Eo nam. ");
INSERT INTO tvk_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ngan xil xa di lamot mi nanao votei xil, xil di lastokovein xouk xa obe vatit hosien nae. ");
INSERT INTO tvk_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","E inou, ti nikikei minuk itel memesien, e nisa sanien eo tei ihat minuk. Naha xa natehit xati minuk tengan nipol ni, nipol sen ni. O Iahova, xouk kestang di oteh meulien e moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Melele xa Siona misis bus, Iahova misemae ni meseo ak tengan vahe ut. Ma meseo ak ba, miluh rat Siona be suhon. ");
INSERT INTO tvk_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Iahova misepin vatei mun mi Siona bit, ");
INSERT INTO tvk_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Uhe taon xa mahulong te hal Nineva, e uhit mesen sepinien xa nisa ni minuk mi xil.” ");
INSERT INTO tvk_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Ma Siona milong xat Iahova e ba be Nineva. Taon te hal Nineva be mahulong pupu. Xosxa moletin de rin tei e minemi bit vahe rin sav, xi ikakao melengien ihe tol vari. ");
INSERT INTO tvk_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ma Siona ba be taon ak e mikakao en melengien tei. Di, melele xa de hilaep te taon ak, Siona mikei be nesao ba mi moletin xil bit, “Melengien be hanutap lu (40) sutang di tengan Hi ihu len vari ni taon ak te hal Nineva.” ");
INSERT INTO tvk_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Melele xa moletin xil te hal Nineva lalonge mak, lake reitin e sepinien na Iahova. Ma labithiteni mi moletin xil vus, ngan xil xa latellep ba latuxoh ngan xil xa latereli, tengan lihal ni anien e lising ni talmusu xil tengan lipisen ni xa lalonge misa ve tesaen nae xil. ");
INSERT INTO tvk_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Melele xa suv toto te hal Nineva milongeong ni usil naha xa Siona tehithiteni, xi mun milonge misa pupu. Ma mitamea ra hor nan e mileh rat eising hos nan xil. Di, mising ni talmusu xil tang e ba dotan de husupang xil. ");
INSERT INTO tvk_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Di, misemae ni tengan latis mesen rae nan ak iha mi mol‑Nineva xil vus tengan ti lihusili. Rae xa bit: “Ngan ak be rae na suv toto del eilep nan xil. Moletin xil vus itel vongoro sae xil mun linakar pis ti anien e linamu ti oei. ");
INSERT INTO tvk_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Moletin xil vus itel vongoro sae xil mun lising ni talmusu xil e ti litakes Hi ve esaeen nan. Xil lihiles ra tutuen nae xil e sexien tesa nae xil mun. ");
INSERT INTO tvk_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Melele xa ripol ni imak, ma xos Hi nasa ti mun pangasien namei xat xir. Xos xi ikila ihiles nenemien nan e nahas vin xir ti natel ekaten nan xa nggeih pupu.” ");
INSERT INTO tvk_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Melele xa Hi pus naha xa latepol ni, e pusi xa latehiles ra sexien tesa nae xil, xi biles nenemien nan e tasa pangasien ti mun mi xil vaxoni ngan xa tehiteni. ");
INSERT INTO tvk_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Melele xa Siona pusi xa Iahova ien misae e moletin xil te hal Nineva, xi milonge misa e ien mikat pupu. ");
INSERT INTO tvk_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ma misis mi Iahova bit, “O Iahova, melele xa nada tamu e tim savan, nakila ngamu xa xouk upol ni imak. Ve rin ak vari iaxa natelesae natehe Spen. Natekila xa xouk obe hisit Hi tei xa di opisen eheien e esaeen mi moletin xil. Xouk di onggur xat ekaten nam e di opisen hosien nam mi moletin xil. Vehakut di obiles nenemien nam tengan onasa pangasien ti mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","!O Iahova, taxeak, uhur rat meulien navan! !Vahit namat vahos mak mu vali ngan taxa nameul nada xiak!” ");
INSERT INTO tvk_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","E Iahova bit rilomun ni mini bit, “?Onemi obit momal tang tengan ti iem vakat vamak?” E Siona tavit rilomun ni ti sepinien mini. ");
INSERT INTO tvk_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Di, Siona be reling taon ak e ba dotan e rute tei xa be ist xa mikila vapus taon te hal Nineva. E inggak, xi pet horao tei e dotan de paen vengan xa bit vapus ti mu naha iaxa vaxul taon ak. ");
INSERT INTO tvk_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Di, Iahova misak ni uval tei meul katen nggusil horao xa Siona tepeti tengan vasak ni ut vamerir vuteili tengan vatutou ni Siona. E melele xa Siona pusi, besi xi pupu ven. ");
INSERT INTO tvk_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","E visuvong nen, melele xa ut milan, Hi misa vueang tei mei mingas uval ak xa misak ni mei bue e mat. ");
INSERT INTO tvk_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","E melele xa eai bemei nesao, Hi misa votiang tei nggo ist xa mitin pupu. Eai minggasil xat vat Siona ma ven memel. Misak ni, ien bei maten e biteni bit, “!Vahit namat vahos mak mu vali ngan xa nameul nada xiak!” ");
INSERT INTO tvk_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","E Hi biteni mini bit, “?Onemi obit momal tang tengan ti iem vakat vamak ve uval ak?” E Siona bit rilomun ni bit, “!Io! Momal tang tengan nalonge mak. !Ieok mikat pupu ve rin ak! !E vahit namat, vahos mak mu!” ");
INSERT INTO tvk_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ma Iahova biteni mini bit, “Uval ak meul bemei nesao e vongien tei tang, di, mat e vongien sav. Xouk otapol ni ti neta ven, e tave xouk ti iaxa opol ni vameul. Tave ti neta xa mak, e xouk di odesi e odang ve maten nan. ");
INSERT INTO tvk_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","?Ma midep? ?!Tamal ti tengan inou nipisen esaeen navan mi moletin xil te hal Nineva!? !Ngan xil xa di lameul e taon ak lali taosen be handred tei e hanutap tei mun (120,000) xa latakil ti vari neta xa bos e neta xa misa! E vongoro xil mun xa ladi en labe holu xa labe holu pupu. Siona, momal tevi tengan ieok isae ve meulien na moletin xil ak.” ");
INSERT INTO tvk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ngan ak be vatimol xil na Iesu Kristo, xa tehe tei e vatimol na suv toto Deved tetiamu, xa tehe tei e vatimol na Ebraham tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham, xi tehe tame Aesak, xa tehe tame Siekob, xa tehe tame Sudah tetel tuneli xil. ");
INSERT INTO tvk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sudah, xi tehe tame Peres xal Siera, xa ninexalu Tamar. E Peres, xi tehe tame Hesron, xa tehe tame Ram. ");
INSERT INTO tvk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, xi tehe tame Aminatap, xa tehe tame Nashon, xa tehe tame Salmon. ");
INSERT INTO tvk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, xi tehe tame Boas, e ninen Rehab. E Boas tehe tame Obed, e ninen Rut. E Obed tehe tame Tiese, ");
INSERT INTO tvk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","xa tehe tame suv toto Deved. Suv toto Deved, xi tehe tame Solomon, e ninen tehe tunau na Uraea. ");
INSERT INTO tvk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, xi tehe tame Rehoboam, xa tehe tame Abitsa, xa tehe tame Asa. ");
INSERT INTO tvk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, xi tehe tame Sehosavat, xa tehe tame Sehoram, xa tehe tame Usaea. ");
INSERT INTO tvk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaea, xi tehe tame Siotam, xa tehe tame Ehas, xa tehe tame Hesekaea. ");
INSERT INTO tvk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaea, xi tehe tame Manase, xa tehe tame Amon xa tehe tame Sosaea. ");
INSERT INTO tvk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","E Sosaea, xi tehe tame Sekonaea e tuneli xil. E melele nen ak, mol‑Babilon xil mei latehas tan ni mol‑Isrel xil e lateleh rerat xil latehe kantri te hal Babilon. ");
INSERT INTO tvk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngan xil sung ak, xil labe avu xil xa latemei tetutou ni melele xa mol‑Isrel xil latehe reling kantri te hal Babilon: Sekonaea, xi tehe tame Seltiel, xa tehe tame Serubabel. ");
INSERT INTO tvk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel, xi tehe tame Apiut, xa tehe tame Eliakim, xa tehe tame Asor. ");
INSERT INTO tvk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor, xi tehe tame Sadok, xa tehe tame Akim, xa tehe tame Eliud. ");
INSERT INTO tvk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, xi tehe tame Eliesar, xa tehe tame Matan, xa tehe tame Siekob. ");
INSERT INTO tvk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Siekob, xi tehe tame Siosep, xa tehe tiramue na Meri, xa tehe nine Iesu, xa latekesi ni Mesaea xa Hi tehit xati tehit isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mak, ma melele xa labuli vatit avu xil xa lateti e vatimol na Iesu, Ebraham tetuxoh suv toto Deved, lakameti xa latehe hat e le tei (14). E lakameti xa Deved tetuxoh melele xa mol‑Isrel xil latehe kantri te hal Babilon, vatit avu xil ak latehe hat e le tei (14). E melele xa mol‑Isrel latehe reling hal Babilon tetuxoh melele xa Mesaea tepot e ut etan, vatit avu xil ak mun latehe hat e le tei (14). ");
INSERT INTO tvk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ngan ak be tumulen usil naha xa testal tetiamu ni poten na Iesu xa tehe Mesaea na Hi. Meri xa ihe nine Iesu, latesikoe xole ngamu tengan mei ihe atou na Siosep. E melele xa lutnati vituei ti mu, latekameti xa Meri teti tuei ni tuvava texo xeihen na Ninin Eo. ");
INSERT INTO tvk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Vengan xa Siosep, tiramue na Meri, sexien nan xil momal pe met Hi, xi tenemi tehit isil rati. E xi ien ti tavei vapol ni Meri vahe unoun pe met moletin xil. Ma xi bit xalu lalitasil e suse xa moletin xil linakil ti. ");
INSERT INTO tvk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E melele xa Siosep di tamu minem usil rin ak, masxaxa tei na Hi Suv mei mistal mini e metuveen tei e biteni mini bit, “Siosep, vatimol na suv toto Deved tetiamu, ulum nakan ti tengan uhur Meri ihe atou nam, vengan xa tuvava xa di ni nggo xeihen na Ninin Eo. ");
INSERT INTO tvk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meri iling horamue ak, e xouk uling hisen ihe ‘Iesu’ xa koute teni be ‘Iahova di miteh meulien,’ vengan xa xi iteh meulien e moletin nan xil ra tesaen nae xil.” ");
INSERT INTO tvk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Holesok xil ak mei mistal tengan vapol ni sepinien xa Hi Suv tehit lelen ni texo provet nan mei vahe reitin xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“!Muteong kuhi! Atul maxoe tei xa takil ti mu tiramue, xi di ni tuvava tei. Ti, ilingi ihe malohos e liling hisen ihe ‘Imanuel’ xa koute teni be ‘Hi di mi xir.’” ");
INSERT INTO tvk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Melele xa Siosep milale, xi pol nggusil naha xa masxaxa na Hi Suv tesemae ni mini. Ma xi nggur Meri mei be atou nan e ludi vituei. ");
INSERT INTO tvk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","E xi tapat ti vatela ba duxoh melele xa Meri miling horamue nan. E melele xa miling horamue ak, Siosep miling hisen be Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu tepot e metimal te hal Betlehem xa de provins te hal Sudea, e melele xa Herod xa Mahulong tehe suv toto te provins ak. E dutou ni poten na Iesu, rut eilep xil langgo ist e lamei e taon te hal Serusalem. Eilep xil ak langgur kilakilen tengan lipus kil naha xa istal e ut etan nggo suse na hitu xil. ");
INSERT INTO tvk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","E melele xa lastal e hal Serusalem, lasis moletin xil labit, “?Tuvava xa tepot be suv toto na Siu xil da xave? Vengan melele xa mateti tamu e ut samem e ist, matepus kokot ni xa hitu nan testal. Ve rin ak, mamei taxeak tengan masa merereen mini.” ");
INSERT INTO tvk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Melele xa suv toto Herod xa Mahulong milongeong ni, xi minexo pupu del moletin xil vus te hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma Herod mikes viton vat xil na pris xil del titsa xil te rae na Mosis e misis xil bit, “?Mesaea xa Hi tehit xati mi Siu xil, ipot ingga xave?” ");
INSERT INTO tvk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xil labit rilomun ni mini labit, “Ipot e metimal te hal Betlehem e provins te hal Sudea, vengan xa Hi tesepin texo tisen na provet tei nan tehit, ");
INSERT INTO tvk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tave ti neta xa metimal te hal Betlehem be hokorong mak mu ni metimal savsav xil vus na mol‑Sudah xil, e nisak ni suv toto tei mei istal ixo en. Xi ilaxat kuh mol‑Isrel xil vus ixoni moletin tei xa di milaxat kuh sipsip san xil.’” ");
INSERT INTO tvk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Melele xa suv toto Herod xa Mahulong milonge mak, mikes xuxus ni eilep xil ak tengan lamei visali. Di, misis pilei xil tengan lihiteni mini melengien xati vari xa xil latepus rohon ni xa hitu ak testal. ");
INSERT INTO tvk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Di, Herod misil xil labe Betlehem e biteni mi xil bit, “Muha mulang kuhi ni horamue ak. E melele xa mukameti, mutilomun mei muhiteni minou tengan xa inou mun niha nimot mini.” ");
INSERT INTO tvk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Melele xa eilep xil ak lalong sepinien na suv toto, laba tengan lalang ni horamue ak. E melele xa di langgusil suse nae laba, hitu xa latepusi tetiamu melele xa lateti tamu e ist mistal rilomun. E melele xa lapus hitu ak, labesi xil pupu. Hitu ak diamu ni xil e ba da kat e rute vari xa horamue ak da en. ");
INSERT INTO tvk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ma melele xa labe nim, lapus horamue del ninen Meri ludi. E melele xa lapus horamue ak, latingeiril e lasa merereen nae mini. Di, laleh rerat sanien hos nae xil e lasa ni mini. Xil lasa gol, forangkansen, e mir. ");
INSERT INTO tvk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E vongien, Hi misep xol xil nggo metuveen tei xa linatilomun ti mun linave visal Herod. Ma xil langgusil suse sav ladilomun labe tim sae. ");
INSERT INTO tvk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Melele xa eilep xil ak ladilomun laba, masxaxa tei na Hi Suv mei mistal mi Siosep nggo metuveen tei e biteni mini bit, “!Tamea! !Temanon, hur horamue xal ninen, e mutilesae mutihe Isip! Mutiti rute ak ituxol melele xa inou nihit mutilomun en. Upol ni imak vengan xa, navehi ti, Herod ilang ves horamue ak tengan vahas vini.” ");
INSERT INTO tvk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Misak ni, e vongien nen tak, Siosep mea po xat horamue e, del ninen, latlesae latbe kantri te hal Isip. ");
INSERT INTO tvk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Latodi rute ak ba duxoh melele xa suv toto Herod xa Mahulong mat. Ngan ak mistal tengan vapol ni sepinien na Hi Suv xa tehit lelen ni texo provet Hosea mei mistal be reitin xa tehit, “Nakes natuxoli tengan imea ra hal Isip.” ");
INSERT INTO tvk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Melele xa Herod minem kila xa eilep xil te hal ist lateluvosi, ien mikat pupu. Ma, misemae ni moletin te vaeen nan xil tengan lihe metimal te hal Betlehem e ut xil mun xa di sangas tengan ha lihas malohos xil ngasen xa huram nae lu e be tan. Herod pol ni mak nggusil melele xati xa eilep xil te hal ist latehiteni mini xa latepus rohon ni hitu ak testal. ");
INSERT INTO tvk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngan ak mistal tengan vapol ni sepinien xa Hi Suv tehiteni texo provet Seremaea mei mistal be reitin xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Moletin xil te hal Rama lalong neta tei, lalong tangen tei xa nggeih di mistal. Resel di muis pupu ve horamue nan xil xa lalel. Ien ti tave tengan moletin ti napet rat nenemien nan, vengan xa horamue nan xil latovuol mun.” ");
INSERT INTO tvk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Melele xa xatel latodi tamu e kantri te hal Isip, Herod xa Mahulong mat. Ma masxaxa tei mei mistal mi Siosep nggo metuveen tei ");
INSERT INTO tvk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e biteni mini bit, “!Tamea! Utel horamue xal ninen muttilomun mutihe tan na mol‑Isrel xil, vengan xa ngan xil xa latehit lihas vin horamue ak, lalel tuei.” ");
INSERT INTO tvk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma, Siosep mitamea, del horamue xal ninen latdilomun latbe Isrel. ");
INSERT INTO tvk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","E melele xa Siosep milongeong ni xa Arkelaos nggur vonine tamen, Herod xa Mahulong, mei be suv toto te provins te hal Sudea, xi ulin mikan tengan latohe rute ak. E Hi mun mike xati nggo metuveen tei tengan latnava ti Sudea. Ma latbe provins te hal Kaleli ");
INSERT INTO tvk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","e latdi rute ak e taon te hal Nasaret. Ngan ak misak ni naha xa Hi Suv tehit lelen ni texo provet xil mei mistal be reitin xa tehit, “Likesi ni ngan Nasaret tei.” ");
INSERT INTO tvk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huram xil holu mei mitavi, e moletin tei ba de uruvuol e provins te hal Sudea, hisen Sion. Xi di baptaes ni moletin xil e di bithiteni bit, ");
INSERT INTO tvk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“!Muhiles ra tesaen namim xil, vengan xa Hi Suv dat sangas visal xamim e bit mei vahe suv toto e meulien namim!” ");
INSERT INTO tvk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Xi vari be ngan xa Hi tesep usili texo provet Aesea melele xa tehit, “Lalong rae tei di mikei e uruvuol xa bit, ‘!Musak mesen suse na Suv! !Mupol ni suse nan imal!’” ");
INSERT INTO tvk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sion, eising nan lapol ni ni hili kamel e mituatu ni mavulut hilbe buluk. Anien an be kelmenamen xil del hani. ");
INSERT INTO tvk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Moletin xil hao di lateha tengan lateong ni. Rute langgo taon te hal Serusalem e rute sav xil mun langgo ut sav xil e provins te hal Sudea. E ngan tesav xil mun, langgo rute xil sangas ni Oeisal Sodan. ");
INSERT INTO tvk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","E melele xa lapusi, labit rerat tesaen nae xil mini, e Sion baptaes ni xil e Oeisal Sodan. ");
INSERT INTO tvk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farasi e Satusi xil holu mun lamei visal Sion tengan vabaptaes ni xil. E melele xa Sion pus xil, misepin nggeih mi xil bit, “!Xamim munggoni vanut tetal sasa xil xa di langas vin moletin xil ni vulongexil! ?Visi misel xat xamim tengan mulesae ra longpangasien xa Hi isa ni mi moletin xil te ut etan? ");
INSERT INTO tvk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bos mak mu xa itiamu, mupol ni sexien xil xa ipisen ni xa mubiles ra tesaen namim xil ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","E munanemi ti munahit mutit ihos vengan xa Ebraham be vatit avu namim. !E‑e! Nabiteni reitin mi xamim, Hi ikila isak ni hat xil ak mei lihe moletin xil xa labe vatimol na avu Ebraham. ");
INSERT INTO tvk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Taxeak, akis mese tuei ve vatit vatiei xil vus. E ngan xil xa latahur huit hosien ti, lite rat xil e liso ni ihe upang. ");
INSERT INTO tvk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Inou nabaptaes ni xamim ni oei tang tengan vapisen ni xa mubiles ra tesaen namim, e ngan xa itutou ni nou, xi ibaptaes ni xamim itel xat Ninin Eo e upang. Xeihen nan mili navan, e natapin ti tengan name slev nan e naleh rat sandel nan. ");
INSERT INTO tvk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xi bue xat xi ngamu tengan vaseti moletin xil vus. Xi ipol ni ixoni moletin tei xa po savel nan e di miso rerat utut uit ra valite. Utut uit xil xa labos, ileh viton ni ha ilingi e nim nen, e valite xa misa, itin ni ni upang tei xa mahulong xa misakras vamat.” ");
INSERT INTO tvk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","E melele nen ak, Iesu nggo provins te hal Kaleli e xi mun bemei e Oeisal Sodan tengan Sion vabaptaes ni. ");
INSERT INTO tvk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","E melele xa Sion pusi, misak pisi tengan vahiles nenemien na Iesu, ma biteni bit, “!E‑e! ?Xouk di omei visal nou veneh? Momal tengan xouk ubaptaes ni nou vengan xouk obe eilep mak mu oli nou.” ");
INSERT INTO tvk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","E Iesu bit rilomun ni mini bit, “Bos xa ubaptaes ni nou taxeak. Vengan xa, imak, ti ralipol ni holesok xil vus xa imal pe met Hi.” Misak ni, Sion maen ni, e baptaes ni Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","E melele xa Sion baptaes ni Iesu bus, Iesu mea ra oei. Vatei takes, tilang hat misaha, e xi pus Ninin na Hi mingga merou nggoni mae e mei dotan en. ");
INSERT INTO tvk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","E rae tei mistal nggo ut nesao bit, “Ngan ak be Natuxoli reitin xa eheien navan di en. Inou nabesi nou pupu ven.” ");
INSERT INTO tvk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Melele xa Iesu baptaes bus, Ninin Eo dela be uruvuol tengan vahur sakpisien vaxo he Temat. ");
INSERT INTO tvk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ba de uruvuol e di bal ni anien. Melengien hanutap lu (40) mei mitavi, e mae nggati tova tang. ");
INSERT INTO tvk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Di, Temat xa di misak pis moletin xil bemei visali. Xi biteni mi Iesu bit, “Xosxa reitin xa obe Nat Hi, ma usemae ni hat xil ak tengan lihiles mei lihe beret am.” ");
INSERT INTO tvk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E Iesu bit rilomun ni mini bit, “!E‑e! Ninapol ni ti, vengan xa Vanuvei Eo biteni bit, ‘Moletin misakras vameul e anien kestang. Xi di meul e sepinien xil vus xa mistal nggo vulonge Hi.’” ");
INSERT INTO tvk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Di, Temat nggur Iesu lube Serusalem, taon eo na Hi. Xi miling Iesu misoh e ramut Nim Eo xa be nesao pupu. ");
INSERT INTO tvk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","E melele xa ludi nesao, Temat biteni mini bit, “Xosxa obe nat Hi reitin, hut he tan. Vengan xa Vanuvei Eo na Hi biteni bit, ‘Iahova isemae ni masxaxa nan xil tengan lilaxat kuh xouk. Xil lipo xatuk ni hexil, tengan xouk onatun lem ti e hat.’” ");
INSERT INTO tvk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","E Iesu bit rilomun ni mini bit, “!E‑e, ninapol ni ti! Vengan xa Vanuvei Eo biteni mun bit, ‘Munasak pis Iahova ti xa be Hi namim tengan mukameti xa xi di mi xamim.’” ");
INSERT INTO tvk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Di, Temat nggur Iesu lube vathu tei xa be nesao xa be nesao. E rute ak, pisen kantri xil vus te ut etan mini e neta xil xa bos di en. ");
INSERT INTO tvk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xi biteni mini bit, “Holesok xil vus ak, nisa lelaxatien te xil minuk xosxa utingeiril tang e umot minou.” ");
INSERT INTO tvk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","E Iesu bit rilomun ni mini bit, “!Setan, he reling nou! Ninapol ni ti vengan xa Vanuvei Eo biteni bit, ‘!Mumot mi Iahova xa be Hi namim e muteong xat xi kestang!’” ");
INSERT INTO tvk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Di, Temat be relingi, e masxaxa xil mei ladutou ni. ");
INSERT INTO tvk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Melele xa Iesu di tamu e uruvuol, milongeong ni xa Herod Antipas, xa be suv toto te provins te hal Kaleli, xi tetal xat Sion Baptis e teso ni tehe nim te xeih. Ma, Iesu dilomun be provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","E xi tava ti mun e metimal te hal Nasaret, xi ba sung di taon te hal Kapaniam xa be sangas ni Oei Kaleli. Taon ak de tan na vatimol na Sebiulon xal Navtali tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngan ak mistal tengan vapol ni naha xa Hi tehit lelen ni texo provet Aesea mei mistal be reitin xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nanggur longeongen tei ba mi moletin xil xa ladi e tan na vatimol xil na Sebiulon e tan na vatimol xil na Navtali. Longeongen ak iha mi ngan xil xa ladi sangas ni Oei Kaleli xa de ist ni Oeisal Sodan. Reitin, iha mi moletin xil te hal Kaleli, e rute xil xa ngan xil xa latave Siu ti lapolu en. ");
INSERT INTO tvk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ngan xil xa ladi e maluxoluken te tesaen, xil lipus miehen na Hi xa mahulong. Reitin, moletin xil xa lalonge, tetiamu lateti pe mamel te maten, e taxeak, xil lipusi xa ut milan sung xiak.” ");
INSERT INTO tvk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","E melele nen ak ba, Iesu ba di bithiteni mi moletin xil bit, “!Muhiles ra tesaen namim xil, vengan xa Hi Suv dat sangas visal xamim e bit mei vahe suv toto e meulien namim!” ");
INSERT INTO tvk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Vatei, Iesu mikakao nggusil seri Oei Kaleli. E melele xa mikakao ba, pus timue lu xa di luso net nalu be oei. Hisealu Saemon (xa laling hisen tei mun be Pita) e Andru (xa be tunali), e lube moletin te sar meseo en. ");
INSERT INTO tvk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","E Iesu biteni mi xalu bit, “Lumei luhusil nou. Xosali di mulihi meseo xil tang, e inou nisak ni xamil ti mulihi moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Vatei takes, lustokovein net xil nalu e lunggusili. ");
INSERT INTO tvk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E melele xa latkakao latoba, Iesu pus timue lu mun, hisealu Temis xal Sion, xa lube nat Sepeti. Ludi bot del tamealu e di latdil pilei net natel xil. E melele xa Iesu mikes xalu, ");
INSERT INTO tvk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","vatei takes, lube reling bot e tamealu, e lunggusil Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Melele xa Iesu mikes moletin hat (4) ak, xatel latnggusili e labe rute xil holu e provins te hal Kaleli. E rute xil vus xa laba en, Iesu pispisi mi moletin xil e nim te pispisienna Siu xil. Xi di bithiten longeongen hos xa Hi di bemei tengan vahe suv toto na moletin nan xil, e di dal rerat moletin xil ra mesien nae xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","E longeongen usili mikapis e provins te hal Siria mun. Misak ni, moletin xil te rute ak laleh ngenexil xa lamesei ni mesien savsav xil: ngan xil xa tenbexil pangas, ngan xil xa ninin tesa xil ladi e xil, ngan xil xa di lamemat, e ngan xil mun xa rut tenbexil mat. Laleh xil lamei visal Iesu e xi midal rerat xil vus ra mesien nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","E melele xa Iesu di mikakao, vanut moletin xil holu di langgusili. Xil langgo provins te hal Kaleli e provins te hal Sudea. Langgo taon te hal Serusalem, e provins te hal Dekapolis. E langgo ut xil mun xa ladi ist te Oeisal Sodan. ");
INSERT INTO tvk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Melele xa Iesu pus tatit moletin xil xa eilep xiak, xi be nesao e hu tei del moletin nan xil e dotan tengan vapispisi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Iesu biteni mi xil bit, “Tuxolxatien iti mi ngan xil xa lamei visal Hi be he hon tang, vengan xa xi mei ihe suv toto nae e ilaxat kuh hisit moletin xil xa lamak. ");
INSERT INTO tvk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tuxolxatien iti mi ngan xil xa di ladang, vengan xa Hi ipet rat nenemien na hisit moletin xil xa lamak. ");
INSERT INTO tvk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tuxolxatien iti mi ngan xil xa labe hanmerou e nenemien nae be tan, vengan xa Hi isa rute xil vus e ut etan ihe na hisit moletin xil xa lamak. ");
INSERT INTO tvk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tuxolxatien iti mi ngan xil xa iexil bei pupu ni tengan limal pe met Hi, vengan xa xosxa imak, ma xi ipol ni mei ihe reitin e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tuxolxatien iti mi ngan xil xa esaeen nae di e mosav xil, vengan Hi ipisen sexien te esaeen mi hisit moletin xil xa lamak. ");
INSERT INTO tvk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tuxolxatien iti mi ngan xil xa langgusil xat Hi del nenemien xa memese, vengan xa hisit moletin xil xa lamak lipus kuh Hi sung ni metexil. ");
INSERT INTO tvk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tuxolxatien iti mi ngan xil xa di laling tomat di mi moletin xil, vengan xa likes hisit moletin xil xa lamak ni horamue xil na Hi. ");
INSERT INTO tvk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tuxolxatien iti mi ngan xil xa di langgur longpangasien vengan xa di lapol ni naha xa momal pe met Hi, vengan xa Hi mei ihe suv toto na hisit moletin xil xa lamak e ilaxat kuh xil. ");
INSERT INTO tvk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tuxolxatien iti mi xamim melele xa moletin xil di lasep xar ba ni xamim, di lasa pangasien mi xamim, e di lasep usil xamim ni luvosen xil hao xa misa pupu vengan xa di munggusil xat nou. ");
INSERT INTO tvk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Reitin, texo sexien nen xil tak, latesa pangasien teha mi provet xil xa lateti tetiamu ni xamim. E muhesi xamim tang vengan muhur huite teni sung xa ihe eilep e ut nesao.” ");
INSERT INTO tvk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iesu misepin rilomun bit, “Xamim munggoni sol xa lalingi del xat moletin xil te ut etan. ?E xosxa neta xa di misak ni sol ak bos be relingi, ma lipol ni mei ihos rilomun itep? !Lasakras lapol ni vamak! Sol xa tavos ti, lasakras lapol ni ti neta ni. Bos tengan liso ni iha e moletin xil ti lihes tan tang en. ");
INSERT INTO tvk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Xamim munggoni laet tei xa di mileluv ba mi moletin xil e ut etan. E nggoni ngan taxa taon tei xa de nesao e hu tei misakras vaxus, neketen namim mun, moletin xil ti lipus kila. ");
INSERT INTO tvk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Moletin tovuol xa vasahan laet, ti, vaha vaso xati ni pesin tova. !E‑e! Xi di misoxolen ni de nesao tengan ti ileluv kuhi e vangit nim ve moletin xil xa ladi en. ");
INSERT INTO tvk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nggusil sexien nen tak, laet te neketen namim ileluv kuhi iha mi moletin xil. Imak, ma melele xa moletin xil lipus sexien hos xil namim, xil ti lipet rat his Hi Tamemim xa de ut nesao.” ");
INSERT INTO tvk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesu pispisi mi moletin xil bit, “Munanemi ti munahit inou namei tengan naso rerat rae xil na Mosis del pispisien xil na provet xil vaha. !E‑e, tamak ti! Natamei ti tengan naso rerat xil. E inou namei tengan nisak ni naha xa rae xil ak di lasep usili mei istal ihe reitin. ");
INSERT INTO tvk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","E nabiteni reitin mi xamim xa holesok xil vus xa di e rae xil na Hi, mavulut sepinien xil vus xa latetisi teti en misakras vakesae. Vatova, ut nesao e ut etan lalikesae, e sepinien xil na Hi misakras vakesae ituxoh melele vari xa ipol vuol ni polien xil teni. ");
INSERT INTO tvk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mak, ma ngan xil xa di langgur xoteh rae tei takes na Hi xa hokorong tang e lapispisi ni mi moletin sav xil tengan lipol ihusili, ma, e melele xa Hi te ut nesao mei ihe suv toto na moletin xil, xil mei lihe neta sav tang. E ngan xil xa di lalong xat rae xil na Hi e di lapispisi ni mi moletin sav xil tengan lipol ihusili, xil mei lihe eilep mak mu e moletin xil na Hi Suv. ");
INSERT INTO tvk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Vengan nabiteni mi xamim, xosxa momalen namim pe met Hi nali ti momalen na titsa xil te rae na Mosis e momalen na Farasi xil mun, ma musakras mupus ti rute xa Hi be suv toto en.” ");
INSERT INTO tvk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iesu biteni mun mi xil bit, “Xamim mutelonge xa Mosis tesa rae ak mi avu namim xil tetiamu tehit, ‘Munahas vin ti moletin,’ e moletin xa ipol ni imak ha lilepisi e lisa pangasien mini. ");
INSERT INTO tvk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","E inou nabiteni mi xamim xa moletin xil vus xa ti iexil iat tua nae xil, Hi ilepis xil e isa pangasien mi xil. Reitin, xosxa moletin tei biteni mi tuneli bit, ‘vatum tovuol,’ lihur moletin ak ha lilepisi e koten na Siu xil e lisa pangasien mini. E xosxa moletin tei biteni mi tuneli bit, ‘otalang,’ xi di nggusil suse tengan ha ihe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mak, ma xosxa xouk uha tengan osa sanien eo nam mi Hi e hor te sanien, e, e rute ak, onem rilomun ni neta tei xa moletin sav bit otepol ni mini xa tenamal ti, ");
INSERT INTO tvk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ustokovein sanien nam iti nga e rute ak sangas ni hor te sanien eo. Ti, uha mu userev rin nam itela. E melele xa userev xamil ivus, utilomun uha e usa sanien nam sung mi Hi. ");
INSERT INTO tvk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“E xosxa moletin tei bit vahuruk ove kot ve neta ngan xa xi bit otepol ni mini, ma utemanon ha userev rin nam itela melele xa di tamu munggusil suse tengan mulihe von koten. Maxani, xosxa onapol ni ti, melele xa multuxoh kot, xi ilinguk e he moletin te lepisien. Ma moletin ak mikila ilinguk e he polis, e polis mikila ilinguk e nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Reitin li nabiteni minuk, xouk utat rute ak e osakras ovaha vem vamase vatuxoh melele xa uxal rat vuol ni faen xa lalingi di xatuk.” ");
INSERT INTO tvk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","E Iesu pispisi mun mi xil bit, “Xamim mutelonge xa Mosis tesa rae ak mi avu namim xil tetiamu tehit, ‘Munakan ni atou mu tiramue na mosav ti.’ ");
INSERT INTO tvk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","E inou nabiteni mi xamim xa melele xa moletin tei xa miteli ngamu pus atou tei e ngguri e nenemien nan tang, e pe met Hi, nggoni ngan xa mikan ni ngamu vengan pol misa tuei dela e nenemien nan. ");
INSERT INTO tvk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Xosxa metom metu isak ni xouk umot e tesaen, ukis rati e uso ni iha. Ihos mak mu xa rut tenbom tang ikesae, ili ngan xa liso sen tenbom xil vus ha ikesae e Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E xosxa hem metu isak ni xouk umot e tesaen, uta xotehi e uso ni iha. Ihos mak mu xa rut tenbom tang ikesae, ili ngan xa liso sen tenbom xil vus ha ikesae e Upang xa misakras vamat.” ");
INSERT INTO tvk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesu pispisi mun mi moletin xil bit, “Xamim mutelonge xa Mosis tesa rae tei mi avu nar xil tetiamu tehit, ‘Moletin xa bit vastokovein atou nan, ha ipus moletin te lepisien xa ipol kuh Setifiket te Silaen nalu. Ti, mikila istokovein ni sung.’ ");
INSERT INTO tvk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","E inou nabiteni mi xamim xa melele xa tiramue tei miteli del atou tei lunastokovein xalu ti pe met Hi. E xosxa tiramue tei mistokovein atou nan, xa tamaen xi ti mi tiramue sav, tiramue ak di pol ni tesaen pe met Hi. Vengan naha xa tiramue ak di pol ni isak ni atou ak ha ihur moletin sav xa be tesaen pe met Hi. E moletin xa nggur atou ak, pe met Hi nggoni ngan taxa di mikan ni atou na tiramue ak.” ");
INSERT INTO tvk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iesu pispisi mun mi moletin xil bit, “Xamim mutelonge xa Mosis tesa rae tei mi avu nar xil tetiamu tehit, ‘Munaluvos ni his Hi ti e sepinien xil namim, e mupol vuol ni naha xa mutehit xati pe met Hi tengan mupol ni.’ ");
INSERT INTO tvk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","E inou nabiteni mi xamim xa munasuv xat hitxatien namim xil ti natel his ut nesao, vengan xa rute ak be vontoen na Hi. ");
INSERT INTO tvk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","E munasuv xati ti mun natel his ut etan vengan xa be von kaele Hi. E munasuv xati ti mun ni his Serusalem, vengan be taon na Hi xa be suv toto. ");
INSERT INTO tvk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","E munasuv xati ti mun ni vatumim vengan musakras muviles hilimim tei takes mei vamieh mu vamaluxoluk. ");
INSERT INTO tvk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mak, ma melele xa mubit neta tei, muhiteni tang muhit, ‘Io, be reitin,’ mu, ‘E‑e, tave reitin ti.’ Vengan xosxa musuv xat sepinien namim ni neta tei, ma sexien ak nggo Temat vari tang.” ");
INSERT INTO tvk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesu pispisi mun mi moletin xil bit, “Xamim mutelonge xa Mosis tesa rae tei mi avu nar xil tetiamu tehit, ‘Xosxa moletin tei purun met moletin sav, ma ngan xil te lepisien lipurun meten. E xosxa moletin tei diroh luh moletin sav, ma xi mun, litiroh luhon.’ ");
INSERT INTO tvk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","E inou nabiteni mi xamim xa munasa rilomun ni ti sexien tesa mi moletin tei xa pol misa mi xamim. Mak, ma xosxa moletin tei mei mileves vim metu, umaen ni mun ileves vim meil. ");
INSERT INTO tvk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","E xosxa moletin tei milinguk e kot ve kaon nam, e nggeih xatuk tengan usa eising nam mini ixo kaon nam, ma umaen ni ihur kot nam te masoh mun. ");
INSERT INTO tvk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Xosxa moletin tei te vaeen nggeih xatuk tengan upo ateli nan ha ituxoh kilomita tei, xouk upoe sung ha ituxoh kilomita ihe lu. ");
INSERT INTO tvk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","E xosxa moletin tei dakesuk ve neta ngan, usa ni mini. E melele xa moletin tei ien bei tengan vahur neta tei nam vahe vuteili tang, onakenin ni ti, e umaen ni tang mini.” ");
INSERT INTO tvk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iesu pispisi mun mi xil bit, “Xamim mutelonge xa Mosis tesa rae ak mi avu namim xil tetiamu tehit, ‘Iemim ihei tuemim xil.’ E, ‘Iemim iat elu namim xil.’ ");
INSERT INTO tvk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","E inou nabiteni mi xamim xa iemim ti ihei elu namim xil e ti musis ve ngan xil xa di lapurun xamim. ");
INSERT INTO tvk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ixo sexien ak, mupisen ni xa mube horamue xil na Tamemim xa de ut nesao. Vengan xa xi iaxa di pol ni eai misinasin xat moletin tesa xil del ngan xil mun xa labos. E misak ni us mus tengan vakas naho sa ngan xil xa lamal pe meten e ngan xil mun xa latamal ti. ");
INSERT INTO tvk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","?Xosxa eheien nam di mi ngan xil kestang xa eheien nae di e xouk, onemi obit Hi isa sanien tova minuk ven? !E‑e, tamak ti! !Vengan ngan xil mun xa di laleh takis xil di lapisen eheien mi tua nae xil! ");
INSERT INTO tvk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","?E xosxa di onggur pilei tumali xil kestang, sexien ak ihos ili sexien na mosav xil itep? Vengan ngan xil mun xa latakil ti Hi di lapol ni sexien ak. ");
INSERT INTO tvk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“E xamim, bos xa mumal tevi ixoni ngan taxa Tamemim xa de ut nesao momal tevi.” ");
INSERT INTO tvk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu pispisi mi moletin xil bit, “Melele xa mupol ni sexien xil xa Hi di biteni bit lamal pe meten, mulaxat kuh xamim tengan munapol ni ti pe met moletin xil tengan limerere ni xamim ven. Vengan xa xosxa mupol ni imak, ma Tamemim xa de ut nesao nasa ti huite teni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mak, ma melele xa musa neta ngan mi hoeo tei, munapol ni ti naxoni ngan xil xa lamese nggo hilbexil tang. Vengan melele xa di lasak mesen xil tengan lasa neta tei, xil labe nim te pispisienmu labe suse xil xa mahulong, e di lapol ni moletin te polien nae xil labui amaru tengan likes viton moletin xil limei e mei lipus naha xa xil lipol ni e lisa merereen mi xil. Nabiteni reitin mi xamim, xil di tuei langgur huite ve naha xa lapol ni xiak, e linahur ti mun huite teni e ut nesao. ");
INSERT INTO tvk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E melele xa mututou ni hoeo xil, mupol xuxus ni tang e suse xa tua hos namim xil linakil ti vari. ");
INSERT INTO tvk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Imak, ma moletin xil linakil ti tutouen xa di musa ni mi mosav xil. E Tamemim xa di pus naha xa moletin xil di lapol xuxus ni, xi vari iaxa isa huite teni mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iesu pispisi mi moletin xil mun bit, “Melele xa musis, munapol ni ti naxoni ngan xil xa di lapol ni nggo hilbexil tang. Vengan iexil bei tang tengan lasoh e lasis e nim te pispisien xil mu e seri suse xil xa mahulong tengan moletin xil holu lipus naha xa di lapol ni. Nabiteni reitin mi xamim, xil di tuei langgur huite ve naha xa lapol ni xiak. ");
INSERT INTO tvk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E melele xa musis mi Hi, ihos mak mu tengan muhe nim, mukoe xol puiteh, e musis mi Hi Tamemim xa moletin xil lasakras lapusi. E Tamemim xa di pus naha xa moletin xil di lapol xuxus ni, xi vari isa huite teni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“E melele xa di musis, munasepin ni sepinien xil ti nahe holu xa be neta sav tang naxoni ngan xil xa latakil ti Hi reitin. Vengan xa ngan xil ak di lanemi labit hi nae xil liteong ni sisen nae xil melele xa limangang eilep ni sepinien xil holu. ");
INSERT INTO tvk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Reitin, munapol ni ti naxoni xil, vengan melele xa mutasis ti mu, e Tamemim mikil vuol ni ngamu naha xa mube tamure ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mak, ma melele xa musis, muhiteni imak, ‘Hi Tamemem xa ode ut nesao, hisom be eo e momal tengan musa merereen minuk. ");
INSERT INTO tvk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Masis tengan mei uhe suv toto namem e ulaxat kuh xamem. E nenemien xil vus nam istal ihe reitin e ut etan ixoni ngan xa testal ngamu e ut nesao. ");
INSERT INTO tvk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Usa anien li mi xamem ipin te melengien xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Onaketeh ti mun nasa mi xamem ve holesok xil xa di mapol ni xa tamal ti. Upol ni ixoni ngan xa xamem mun di maketeh bos rilomun mi ngan xil xa di lapol misa mi xamem. ");
INSERT INTO tvk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Onamaen sakpisien xil te xeih ti namei e xamem, e usikoe xol xamem ra he Temat.’ ");
INSERT INTO tvk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Xosxa mosav tei pol misa mi xamim e muketeh bos rilomun mini, ma Hi Tamemim mun xa de ut nesao iketeh ihos ni xamim ve naha xa mupol ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","E xosxa munaketeh ti navos mi mosav xil, ma Hi Tamemim mun naketeh ti navos mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iesu pispisi mi moletin xil mun bit, “Melele xa mubal ni anien ve sisen, munapol ni ti naxoni ngan xil xa di lapol ni nggo hilbexil tang. Vengan xa melele xa labal ni anien, xil di lapol ni valnaoxil mikenu tengan moletin xil lipus kila xa mae nggat pangas xil. Inou nabiteni reitin mi xamim xa xil langgur huite teni ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","E melele xa mubal ni anien ve sisen, bos mak mu tengan mukas valnaomim e musak kuh hilemim ixoni ngan taxa di mupol vehakut ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Imak, ma mosav xil linapus kil ti xa di mubal ni anien. E Hi Tamemim xa moletin xil lasakras lapusi, xi kestang ipus kila. Reitin, Hi Tamemim xa di pus kil naha xa moletin xil di lapol xuxus ni, xi vari iaxa isa huite teni mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iesu pispisi mi moletin xil mun bit, “Munaserev holesok namim xil ti nahe holu e ut etan. Vengan holesok xil te ut etan ak, pipei xil e turara likila lipangei, e moletin te kanen mun mikila ihe nim e ha ikan ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","E ihos mak mu tengan muserev holesok namim xil ihe holu e ut nesao. Vengan xa, e rute ak, pipei xil e turara lasakras lapangei, e moletin te kanen mun misakras vahe nim e ha vakan ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vengan nenemien namim iti e rute xa di muserev holesok namim xil iti en. ");
INSERT INTO tvk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Metemim nggoni laet te tenbemim. Xosxa metemim bos, ma muti e miehen e tenbemim mikila ipol ni sexien xil xa bos. ");
INSERT INTO tvk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","E xosxa metemim isa, ma muti e maluxoluken e ti mupol ni sexien tesa xil. E xosxa miehen xa vate xouk ihe tovuol, ma maluxoluken xa ite meulien nam ihe eilep pupu.” ");
INSERT INTO tvk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","E Iesu biteni bit, “Moletin tei misakras vapol mi masta vahe lu (2). Maxani, ien iat tei e ien ihei ngan tesav; mu nenemien nan iti tei ixeih, e isin ni ngan tesav. Ve rin ak, musakras muhusil xat Hi vatel mani. ");
INSERT INTO tvk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ma vengan rin ak be reitin, bos tengan munanexo ti ve naha xa mua ni mu naha xa mumu ni, mu naha xa musing xol tenbemim ni. ?Midep, meulien nar be te anien en tang? ?Mu tenbexir be tengan taxa ti rasing xole? !E‑e, tamak ti! Meulien xa di e xamim bos mili anien e naha xa di musing ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mupus pis tuman xil xa di langga xolol. Xil latalih ti neta, e lataserev ti anien ae vati e povah mae xil. E tave ti neta xa latapol ni ti, e Tamemim xa de ut nesao iaxa di bangan xil. E pe met Hi, xamim mubos mak mu muleli tuman xil ak. Ma mukil kuhi xa xi ilaxat kuh xamim. ");
INSERT INTO tvk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nenexoen ve neta ngan misakras vaso rin ni haoa tei mun vate meulien namim. ");
INSERT INTO tvk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?Mak, ma veneh iaxa di munexo ve rin te eising? Munem pis hungovae xil xa di lameul. Xil latapol ti e latatil ti eising nae. ");
INSERT INTO tvk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","E nabiteni mi xamim xa suv toto Solomon tetiamu, eising nan xil tehos xa tehos, e hungovae xil ak, lasing xol xil bos mak mu laleli. ");
INSERT INTO tvk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hi mising xol hungovae xil ak bos xa bos, tave ti neta xa di lameul usil suse melengien tei takes, di, e melengien sav nen, lameles e lakiri. Di, ladaveas viton ni e laso ni be upang. ?E xosxa Hi di mising xol xil mak, ma munemi mubit misakras vasing xol xamim vamak? !Ei, neketen namim hokorong tova tang! ");
INSERT INTO tvk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ma munanexo ti ve naha xa mua ni, ve naha xa mumu ni, mu ve naha xa musing ni. ");
INSERT INTO tvk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vengan hisit nenexoen xil xa mak be na ngan xil xa latakil ti Hi reitin. Vengan Hi Tamemim mikil vuol ni holesok xil vus xa mube tamure ni e meulien namim. ");
INSERT INTO tvk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E ngan xa eilep mak mu iaxa mumaen Hi mei ihe suv toto e meulien namim e mupol ni naha xa momal pe meten. Melele xa mupol ni imak, holesok xil mun te meulien, Hi isa ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ma munanexo ti mun ve neta xil xa mulehi visuvong, vengan mukila munem usili sung visuvong. Vengan melele te xeih xil xa di mubisu ni xosali, pipin te xosali tang. Munaleh nenexoen xil te visuvong ti namei nave te xosali.” ");
INSERT INTO tvk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu pispisi mun mi moletin xil bit, “Onalepis moletin sav ti tengan opisen tesaen nan xil. Vengan xosxa upol ni imak, ma Hi mun ilepis xouk tengan ipisen tesaen nam xil. ");
INSERT INTO tvk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vengan Hi ilepis xouk ixo hisit sexien taxa xouk di opol ni mi moletin sav. Ixo sexien xa di olepis mosav xil, Hi iaxa ilepis xouk ihusili. ");
INSERT INTO tvk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“?Veneh ma di opus kil saxut liei tei xa hokorong tang xa de met tumali, e otapus kil ti vari merut liei xa mahulong xa da xat metom? ");
INSERT INTO tvk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Veneh ma di osis tumali obit, ‘Tua li, maen nou namur rat saxut liei xai ra metom,’ melele xa merut liei tei xa mahulong dat e metom? ");
INSERT INTO tvk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xouk di opol ni sexien hos xil nggo hilbom tang. Bos mak mu tengan upo rat merut liei xa da xat metom, ti, uketeh kuhi sung tengan ukila uhur rat saxut liei ra met tumali. ");
INSERT INTO tvk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Holesok eo na Hi, munasa ni ti mi kuli xil, maxani, lihiles e lingas rilomun ni xamim. Reitin, munaso holesok xil ti xa bos mi vueili xil vengan lihe tan tang en.” ");
INSERT INTO tvk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iesu pispisi mi moletin xil mun bit, “Xosxa iem ihei neta ra Hi, usisi, ma isa ni minuk. Reitin, xosxa ulang vesi, ma ukameti. Sisen nam ixoni ngan taxa ti urei puiteh na Hi, ma xi isaha minuk. ");
INSERT INTO tvk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vengan moletin xil vus xa di lasisi ve neta ngan, xil di langguri; ngan xil xa di lalang ves neta ngan, lakameti; e puiteh di misaha mi ngan xil xa di larei. ");
INSERT INTO tvk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“?Visi e xamim tata xil mikila vasa meralihat tei mi horamue nan melele xa misisi ve anien? ");
INSERT INTO tvk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?Mu vasa tetal sasa tei mini melele xa misisi ve meseo? ");
INSERT INTO tvk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ma, tave ti neta xa mube moletin tesa xil, e mukil kuh sexien mak xa ti musa sanien xa bos mi horamue namim xil. ?E midep ni sexien na Hi Tamemim xa bos pupu xa de ut nesao? Sexien nan bos mili sexien namim, e isa holesok xil xa bos mi ngan xil xa ti lisisi.” ");
INSERT INTO tvk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","E Iesu biteni mun mi moletin xil bit, “E holesok xil vus xa di mupol ni, mupol ni mi moletin sav xil ixoni ngan taxa iemim bei tengan xil lipol rilomun ni mi xamim. Vengan xa nenemien ak be vatite te rae xil na Mosis e Tisen na provet xil tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Di, Iesu biteni bit, “Xamim, suse tengan muve ut nesao tave temale ti. Bos tengan muxo puiteh te suse xa hokorong tang. Vengan puiteh tei mun xalu xa eilep da, e moletin xil holu iaxa di langgo en e di langgusil suse nen xa be temale tang. E e hoxalit suse ak, xil likamet longpangasien xa mahulong pupu. ");
INSERT INTO tvk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","E puiteh xa be te suse xa nggeih xa hoxalite teni be meulien sal, puiteh ak hokorong tang. Moletin xil di lalang vesi, e vahis tang likameti e lixo en.” ");
INSERT INTO tvk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesu misel xat moletin xil bit, “Mulaxat kuh xamim tengan provet xil te luvosen mei linaluvos xamim ti. Vengan xil langgoni sipsip xil xa labos e lamerou nggo hilbexil tang. E e tinexil, xil langgoni kuli reran xil xa lasa xa di langas purun moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Xamim mupus kil xil ixo huite te meulien nae. Moletin misakras valeh huit tavu ra vatit ai, mu huit manggo ra vatit vilu. ");
INSERT INTO tvk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Usil rin ak, vatiei xil vus xa bos di laso huite xil xa bos, e vatiei xil xa misa di laso huite xil xa misa. ");
INSERT INTO tvk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Vatiei xil xa bos, lasakras laso huite xil xa misa, e vatiei xa misa lasakras laso huite xil xa bos. ");
INSERT INTO tvk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","E vatiei xil vus xa lataso huite ti vahos, lite rat xil e ha liso xil lihe upang. ");
INSERT INTO tvk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Usil sexien ak vari, mupus kil provet te luvosen xil ak ixo huite te meulien nae. ");
INSERT INTO tvk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Moletin xil hao xa, taxeak, di lakes nou ni ‘suv,’ xil linava ti rute xa Hi te ut nesao be suv toto en. Ngan xil kestang xa di lapol ni naha xa Tata navan e ut nesao ien bei tengan xil ti lipol ni, xil iaxa ha liti visali. ");
INSERT INTO tvk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E Melengien te Lepisien, moletin xil hao limei visal nou e ti lisepin e rin nae lihit, ‘!Suv, Suv! ?Midep? E hisom matehit rat sepinien na Hi, matehol rerat ninin tesa xil, e matepol ni merekel xil holu.’ ");
INSERT INTO tvk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ti, inou nihiteni mi xil kekes nihit, ‘!Muhe reling nou xamim xa di mupol misa! !Natakil ti vari xamim!’” ");
INSERT INTO tvk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Di, Iesu misepin kor mi moletin xil nggo vole tei bit, “Xosxa xamim mulong sepinien navan xil ak e ha mupol ihusili, ma xamim munggoni moletin tei xa be metisou xa mikili ni nim man de tan tei xa nggeih. ");
INSERT INTO tvk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Us mus, oei mileh be eilep, e votiang bas nim ak, e tameru ti vengan misoh e tan xa nggeih. ");
INSERT INTO tvk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","E xamim xa di mulong sepinien navan xil ak e di mutahusili ti, munggoni unu tei xa mikili ni nim man dat suhon tang. ");
INSERT INTO tvk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Us mus, oei mileh be eilep, e votiang bas nim ak. !Ma nim man meru e mikiri lel vari tang!” ");
INSERT INTO tvk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Melele xa Iesu pispisi mi tatit moletin xil ak bus, xil lamesep pupu ve pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vengan xa xi pispisi mi xil nggoni ngan xa pispisien nan xil nggo vulonge Hi vari tang. Pispisien nan xil taxoni na titsa xil te rae na Mosis ti xa dit labit rilomun ni sepinien na titsa sav xil tang. ");
INSERT INTO tvk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Melele xa Iesu pispisi mi moletin xil bus, xi bemei etan ra hu ak, e tatit moletin xil langgusili. ");
INSERT INTO tvk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Di, latemanin e moletin tei xa mesien leporsi da en bemei e hilaep te xil, mitingeiril pe met Iesu, e biteni mini bit, “Suv, xosxa iem bei li, xouk ukila upol ni hilbeok mei imese rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma, Iesu mite hen duxoli e biteni mini bit, “Bos, ieok bei tengan napol ni. !Umese rilomun!” Vatei takes, moletin ak, mesien nan be relingi e hilben mei memese rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Di, Iesu biteni mini bit, “!Uteong ni nou! Onahiteni ti mi moletin tova naha xa mistal ni xouk. Uha upisen xouk mi pris tova e Nim Eo, e usa ni mi Hi sanien xa Mosis tesemae ni moletin xil tengan lisa ni. Sexien nam xil ak ipisen ni mi xil xa tenbom bos ngamu e omese rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu mikakao be taon te hal Kapaniam. E melele xa mistal en, vat na moletin xil te vaeen te hal Rom bemei visali e misis tutouen mini bit, ");
INSERT INTO tvk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Suv li, slev tei navan de tim e di milong pangas xi holu. Rin tei mat e da nga voninen.” ");
INSERT INTO tvk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma Iesu biteni mini bit, “Niha nihur rat mesien nan ihe relingi.” ");
INSERT INTO tvk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","E vat ak bit rilomun ni mini bit, “O suv, onanexo pupu ti venou vengan xa natapin ti tengan mei ove tim savan. E nakila xa xosxa usepin tang, ma slev navan ilonge ihos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vengan xa eilep navan da, e inou mun nabe vat na moletin xil te vaeen. Misak ni, melele xa nabiteni mi tei e xil nabit, ‘He inggaxor,’ ma xi ba. E melele xa nabit, ‘Amei,’ xi bemei. E melele nabiteni mi slev navan nabit, ‘Upol ni netak,’ ma pol ni.” ");
INSERT INTO tvk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Melele xa Iesu milong sepinien nan, mitemanin ni e biteni mi ngan xil xa di langgusili bit, “Reitin mak, nabiteni mi xamim xa, e rin na mol‑Isrel xil, natakameti mu moletin tova xa neketen nan nggeih nggoni ngan Rom ak. ");
INSERT INTO tvk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","E rute xa Hi be suv toto en, xi ipol ni anien tei xa mahulong itel moletin nan xil. E melele nen ak, moletin xil holu xa latave Siu ti mei lianien vituei itel Ebraham, Aesak e Siekob, avu nar xatel tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","E holu e mol‑Isrel xil xa Hi tehosei moletin nae xil tengan mei lave nan, xi iso rerat xil lihe hale e rute tei xa maluxoluk, e xil ti limuis, e ti lingas luhexil ve longpangasien nae xil.” ");
INSERT INTO tvk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Di, Iesu biles e biteni mi vat ak bit, “Utilomun uhe tim sam. Holesok xil istal ixoni ngan taxa di oneket en.” E melele nen ak vari, slev na vat ak, tenben bemei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Melele xa Iesu duxoh tim sa Pita, be nim e pusi xa avu kokon nan di pat de voninen, ven nggan. ");
INSERT INTO tvk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Melele xa pusi mak, Iesu mite hen duxol he tovolih ak. E melele xa duxoli, mesien nan be relingi e mitamea. Di, tovolih ak nggur rut anien tei e misa ni mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Melele xa meteneai be tan, moletin xil laleh ngan xil xa ninin tesa xil di xat xil, e Iesu nggol rerat ninin tesa xil ak labe reling xil nggo sepinien nan kestang. E ngan xil xa lamesei, xi dal rat xil vus ra mesien nae. ");
INSERT INTO tvk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iesu pol ni mak tengan vasak ni naha xa Hi tehiteni texo provet Aesea mei ihe reitin xa tehit, “Xi mileh rerat mesien nar xil e po rat longpangasien nar xil mun.” ");
INSERT INTO tvk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","E melele xa Iesu pusi xa tatit moletin xa mahulong ladi xorelisi, xi misemae ni moletin nan xil tengan livue xat bot tei tengan lihe ri Oei Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","E melele xa Iesu e moletin nan xil di laba, titsa tei te rae na Mosis bemei visali e bit, “Titsa, ut xave xa uha en, inou nihusiluk.” ");
INSERT INTO tvk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","E Iesu bit rilomun ni mini bit, “Asu xil, vale mae xil di, e tuman xil mun, nunu mae xil di. E Nat Moletin, tim san xati te pat en tovuol.” ");
INSERT INTO tvk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E moletin tei mun xa di nggusil Iesu biteni mini bit, “Suv, ieok bei tengan namusiluk. E itiamu, umaen nou nitilomun nihe tim savan e nilaxat tata navan ituxoh melele xa imat e nitihin ni.” ");
INSERT INTO tvk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","E Iesu biteni mini bit, “Xouk uhusil xat nou xosali, e uling ngan xil xa lamat tengan ti litihin ngenexil xa lamat.” ");
INSERT INTO tvk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Melele xa Iesu misepin bus, xi be bot e moletin nan xil langgusil xati tengan lave ri Oei Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E melele xa di lalis laba, Iesu por sae. E tavehi ti, latemanin ni votiang tei xa mea e mu nggeih. Ngan ak misak ni oei nggelial holu, e tahe bemei e bot, sangas vamerir. E Iesu, xi por vovong. ");
INSERT INTO tvk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","E moletin nan xil laba lasiasi ni labit, “!Suv, ututou ni xamem li! !Ramat xi tak!” ");
INSERT INTO tvk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu bit rilomun ni mi xil bit, “?Ulimim di mikan veneh? !Neketen namim hokorong tova tang!” Di, mitamea e misemae ni votiang e oei bit, “!Luhe tan!” E vatei takes, xalu lube tan e an mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Melele xa moletin nan xil lapusi mak, latemanin e lasis pilei xil mun tang labit, “?Moletin ak be hisit moletin eah? !Neta sav xa votiang e oei, xalu mun di lulong xat raen!” ");
INSERT INTO tvk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Melele xa lamei ut e ri oei, Iesu del moletin nan xil laduxoh tan te hal Kadara. Vatei takes, moletin lu lunggo vangihat xil xa be von tehinen e lumei visal Iesu. Moletin xalu ak, ninin tesa xil ladi e xalu e lasak ni xalu di lubas purun moletin xil vus xa lamei sangas e rute ak. Misak ni moletin xil lasakras laka pas rute xa ludi en. ");
INSERT INTO tvk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Melele xa lamei sangas, lukei nggeih ba ni Iesu lubit, “!Nat Hi! ?!Upol ni naha mi xamem!? ?Omei inggak tengan osa pangasien mi xamem? ?Onatatil ti melengien xati teni xa ti imei?” ");
INSERT INTO tvk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tave sotin ti ra rute xa ladi en, tatit vueili xil holu di lasu. ");
INSERT INTO tvk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma ninin tesa xil ak ladakes Iesu labit, “Xosxa uhit uhol rerat xamem, ma umaen xamem muhe vueili xil xor.” ");
INSERT INTO tvk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Iesu biteni mi xil bit, “!Muha!” Ma ninin tesa xil ak labe xat vueili xil. E vatei takes, tatit vueili xil ak laloh ba lakiri labe meteh etan, e ba lamerir e Oei Kaleli, e xil vus lalel. ");
INSERT INTO tvk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngan xil xa di lalaxat vueili xil ak, ulixil mikan, ma laloh labe taon. E taon, latumul usil naha xil xa latepusi e naha xa testal mi moletin xalu xa ninin tesa xil lateti xat xalu. ");
INSERT INTO tvk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Misak ni moletin xil vus te taon ak laba tengan lapus ti Iesu. E melele xa lapusi, ladakesi tengan vahe reling ut sae. ");
INSERT INTO tvk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu del moletin nan xil labe bot e langgur xoteh Oei Kaleli ladilomun labe Kapaniam, taon xati nan. ");
INSERT INTO tvk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Melele xa laduxoh taon, rut moletin xil lapo moletin tei del vet man tang e lamei ve Iesu vengan xa ri moletin ak mat. E melele xa Iesu pus kila xa neketen nae di, xi biteni mi moletin xa rin tei mat bit, “Natuxoli, umaal. Ninaketeh ti mun nasa minuk ve tesaen nam xil.” ");
INSERT INTO tvk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Rut titsa xil te rae na Mosis ladi sangas e lalonge. Ma labiteni mi xil mun tang labit, “!Ei, moletin ak di misep xar ni Hi, vengan xa di misepin nggoni ngan taxa lehit xi be Hi vari tang!” ");
INSERT INTO tvk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","E Iesu mikil naha xa di lanem usili. Ma biteni mi xil bit, “?Veneh ma munggur xat nenemien tesa xil ak di e tinemim? ");
INSERT INTO tvk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","?Midep, sepinien eah iaxa be temale mak mu tengan namiteni: namit, ‘Ninaketeh ti mun nasa minuk ve tesaen nam xil,’ mu namit, ‘Utamea e ukakao’? ");
INSERT INTO tvk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","E tengan xamim mupus kila xa Nat Moletin nggur xeihen e ut etan tengan vaketeh vahos rilomun mi moletin xil, mupus ngan ak …” E Iesu biles, pus moletin xa rin tei mat e biteni mini bit, “!Utamea, uvulun vet mam, e upoe utilomun uhe tim sam!” ");
INSERT INTO tvk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Vatei takes, moletin ak mea e mikakao rilomun be tim san. ");
INSERT INTO tvk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Melele xa moletin xil lapusi mak, latemanin ni e ulixil mikan. Xil lapet rat his Hi xa misa hisit xeihen ak mi moletin tei tengan vapol ni sexien xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E melele xa Iesu be reling rute ak e mikakao ba, xi pus moletin tei di dotan de nim te polien nan xa hokorong, hisen Matiu. Xi di mileh takis ra Siu xil tengan vasa ni vaha mi kavmen te hal Rom. E melele xa Iesu pusi, mikesi bit, “!Amei! !Uhusil xat nou e mei uhe moletin tei navan!” Ma Matiu mea, mistokovein polien nan xil, e nggusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma Matiu del Iesu e moletin nan xil labe tim san. Xi pol ni anien tei e melele xa ladotan e di langganien, moletin hau te takis e moletin sav xil mun xa lasa pe met Siu xil lamei e langganien vituei del Iesu e moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Melele xa Farasi xil lapusi mak, lasis moletin xil na Iesu labit, “?Veneh ma titsa namim di ngganien vituei del moletin xil te takis e moletin tesa xil mun?” ");
INSERT INTO tvk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E melele xa Iesu milonge, biteni mi xil bit, “Moletin xil xa latamesei ti labit linakil ti tokta. E ngan xil kestang xa lamesei iexil bei tengan lapus tokta. ");
INSERT INTO tvk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","E xamim, muha mulang ves koute te sepinien ak xa de Vanuvei Eo na Hi xa bit, ‘Ieok ti tavei sanien eo xil kestang namim, e ieok bei mak mu tengan iemim isae e moletin sav xil.’ Vengan xa natamei ti tengan nakes moletin xil xa lamal ngamu pe met Hi tengan lihiles lihusil nou. E‑e, namei tengan nakes ngan xil xa lapol ni tesaen tengan mei lihiles ra tesaen nae xil e lihusil nou.” ");
INSERT INTO tvk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Di, moletin xil na Sion Baptis lamei visal Iesu e lasisi labit, “Melengien xil holu, xamem del Farasi xil mun di mabal ni anien tengan masis e mapisen ni xa malonge misa ve tesaen namem xil. E mapusi xa moletin nam xil latapol ni ti sexien ak. ?Veneh vari?” ");
INSERT INTO tvk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu dei vole ak mi xil bit, “Melele xa moletin tei miteli, ngan xil xa lamei ve anien nen ak, labesi xil. ?Xamim munemi xa lilonge isa e lipol ni sexien xil te tangen melele xa moletin ak di tamu visal xil? !E‑e, lasakras! E melengien tei di bemei xa moletin xil mei lihur rat moletin nen ak ra xil. E melengien ak vari, xil lilonge isa e lihal ni anien.” ");
INSERT INTO tvk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Di, Iesu dei vole tei mun mi xil bit, “Moletin tovuol xa vatil xol eising matu tei vatel saxut kaliko tei xa be neta hu. Vengan xa melele xa ikasi, kaliko xa be neta hu mei ileten pupu, ma ital papas eising matu ak e mei imeseh mak mu. ");
INSERT INTO tvk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Nggusil suse nen tak, moletin tovuol xa vateh uaen hu vahe valite matu tei xa lapol ni ni hilbe sipsip vengan nggeih ngamu. Vengan xa xosxa ipol ni, ma uaen hu ak ikaio e valite teni imeseh. Maxani, valite ak isa e uaen imie ihe tan. Misak ni, moletin xil ti liteh uaen hu ihe valite xa be neta hu vengan memerou tamu, mikila ikaio. Imak, ma valite teni ihos e uaen mun xa di en ihos.” ");
INSERT INTO tvk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Melele xa Iesu di tamu misepin usil holesok xil ak, vat tei na Siu xil bemei visali, mitingeiril mini e biteni mini bit, “Natuxahin mat taxeak tang. Amei li, mei uling hem en, ma imeul rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma Iesu mea e nggusil vat ak del moletin nan xil laba. ");
INSERT INTO tvk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Melele xa di lakakao laba, atou tei nggo pe tou Iesu bemei e duxol seri eising nan. Atou ak, mesien na atou xil basi huram lu e le tei (12) e misakras vavus. ");
INSERT INTO tvk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Xi duxoli vengan minemi bit, “Xosxa nituxol seri eising nan tang, ma nilonge ihos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Melele xa atou ak duxol eising nan, Iesu biles, pusi e biteni mini bit, “Atou li, umaal. Nggo neketen nam, mesien nam be relinguk ngamu.” E melele nen ak vari, mesien be relingi. ");
INSERT INTO tvk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Di, lakakao laba e laduxoh tim sa vat ak. E melele xa labe nim, Iesu pus rut moletin xil di lapol ni kikeien tei te maten, e vanut moletin tei xa mahulong lase vangit nim e di ladang ve atuli ak. ");
INSERT INTO tvk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","E Iesu biteni mi xil bit, “!Mustal! Atuli ak tamat ti, xi di pat tang.” E moletin xil lamen pepamen ni. ");
INSERT INTO tvk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","E melele xa lasil rerat moletin xil labe hale, Iesu be vangit nim. Xi ba pus atuli, e dal xat hen. Melele xa dal xati, atuli ak meul mun, milale e mitamea. ");
INSERT INTO tvk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Longeongen usil naha xa Iesu tepol ni mikapis e ut xil vus e rute ak. ");
INSERT INTO tvk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","E melele xa Iesu be reling tim sa vat ak e di nggusil suse ba, metevar lu lumei visali e lunggusili. Xalu lukei nggeih ba ni lubit, “!Ei, xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae li e xamel!” ");
INSERT INTO tvk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lunggusili duxoh melele xa Iesu be nim tei. Metevar xalu ak mun lunggusili lube vangit nim ak e Iesu misis xalu bit, “?Midep? ?Xamil muke reitin xa inou nikila nisak ni xamil muliketeh rilomun?” E lubit rilomun ni mini lubit, “O suv, make reitin xa ukila upol ni.” ");
INSERT INTO tvk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Di, Iesu mite hen duxoh metealu e biteni bit, “Holesok xil istal ixoni ngan taxa di muneket en.” ");
INSERT INTO tvk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E metealu mei bos e luketeh rilomun. E Iesu misep xol xalu nggeih bit, “!Mulnahit naha ti xa napol ni mi xamil xiak mi moletin ti!” ");
INSERT INTO tvk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","E melele xa lube relingi, ba lubithiten naha xa Iesu tepol ni mi xalu, ma longeongen teni mikapis e ut xil vus e rute ak. ");
INSERT INTO tvk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Melele xa moletin xalu ak lube hale, rut moletin xil lamei visal Iesu e ladel moletin tei xa be vut. Moletin ak misakras vasepin vengan xa ninin tesa tei da en. ");
INSERT INTO tvk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E melele xa Iesu nggol rat ninin tesa ak be relingi, moletin ak misepin rilomun. Melele xa rut moletin xil ak lapusi mak, latemanin ni e labiteni mi xil mun tang labit, “!Ei termali, xir mol‑Isrel xil ratapus ti mu neta tova vamak!” ");
INSERT INTO tvk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","E Farasi xil labit, “Moletin ak nggur xeihen nan nggo Temat tengan vahol rerat ninin tesa xil vengan Temat be suv nae.” ");
INSERT INTO tvk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Dutou ni ngan ak, Iesu mikakao mikapis e taon e metimal xil vus mun e rute ak. Melele xa be rute tei, xi pispisi mi moletin xil e nim te pispisienna Siu xil, di bithiten longeongen hos xa Hi mei ihe suv toto na moletin xil, e di midal rerat mesien ra moletin xil vus xa lamesei. ");
INSERT INTO tvk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Melele xa xi pus tatit moletin xil ak xa labe holu pupu, xi polu ni esaeen vengan xa pusi xa nenemien nae milangalu holu e latakil ti xa likamet tutouen ixo xave. Iesu pus xil langgoni sipsip xil xa moletin xa valaxat xil tovuol. ");
INSERT INTO tvk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Misak ni, xi biteni mi moletin nan xil bit, “Anien holu temetu di tuei e naho, e moletin xil te polien labe vuteili tang tengan ha lalehi vamei. ");
INSERT INTO tvk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ma musis Suv te naho tengan isa ti moletin xil te polien lihe holu mu mei lileh anien xa di naho nan.” ");
INSERT INTO tvk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu mikes viton moletin nan xil xa labe lu e le tei (12). Melele xa lamei visali, misa xeihen mi xil tengan likila lihol rerat ninin tesa xil e lital rerat mesien ihe reling ngan xil xa lamesei ni mesien savsav xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","E ngan ak be his na eloheoh xil xa labe lu e le tei (12) na Iesu: Ngan xa diamu, Saemon (xa hisen tei mun be Pita) e Andru (xa tuneli Pita). Temis (nat Sepeti) e Sion (xa tuneli Temis). ");
INSERT INTO tvk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Batalomiu, Tomas, Matiu (xa teleh takis), Temis (nat Alveas), e Tatios. ");
INSERT INTO tvk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saemon (xa temos e vanut moletin tei xa iexil bei pupu tengan lameluv ra he mol‑Rom xil), e Sudas Eskariot (xa tesa rat Iesu tehe he moletin tesa xil). ");
INSERT INTO tvk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Moletin lu e le tei (12) nen ak, Iesu misil lelen xil tengan ha lipol itel xat sepinien ak xa bit, “Xamim munava ti visal ngan xil xa latave Siu ti, mu ngan xil xa ladi taon xil na mol‑Sameria xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Muha visal mol‑Isrel xil kestang xa langgoni sipsip xil xa lakesae. ");
INSERT INTO tvk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E melele xa di muba, muhithiten longeongen hos ak mi xil muhit, ‘!Hi di bemei tengan mei vahe suv toto na moletin xil!’ ");
INSERT INTO tvk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muleh rerat mesien xil ihe reling moletin xil xa lamesei, e ngan xil xa lamat, mutal rerat xil ra maten. Ngan xil xa langgur mesien leporsi, mupol ni hilbexil mei imese rilomun, e muhol rerat ninin tesa ihe reling moletin xil. E melele xa ti mututou ni moletin xil, xil linaxal xamim ti, vengan xa holesok xil vus xa xamim mungguri, mutaxale ti ra Hi. ");
INSERT INTO tvk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","E kakaoen namim, munahur ti mani ");
INSERT INTO tvk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mu ateli. Munahur ti mun eising, sandel mu eitingil. Nabiteni mak vengan xa momal tengan moletin te polien xil lianien ixo he ngan xil xa lapol mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Melele xa mumei e taon mu metimal tei, mukamet moletin tei xa momal pe met Hi tengan vahur pilei xamim. Muti kat mutit tim san ituxoh melele xa muhe reling rute ak. ");
INSERT INTO tvk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","E melele xa muba tengan muti e tim tei, itiamu, musa tuxolxatien tei mi ngan xil xa ladi en muhit, ‘Tomat na Hi iti mi xamim.’ ");
INSERT INTO tvk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Xosxa moletin xil te tim ak lamal pe met Hi, ma mupus kila xa tomat namim iti mi xil. E xosxa xil mupus kila xa latamal ti pe met Hi, ma tomat namim itilomun imei mi xamim, e muhe reling xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","E xosxa moletin tovuol xa ien vahei tengan vahur pilei xamim mu valong sepinien namim, muhe reling xil. E melele xa mumea ra tim sae mu taon nae, muhas rerat meas te rute ak ra lemim pe met xil. Ngan ak ipisen ni mi xil xa lapol misa pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Reitin mak nabiteni mi xamim, e Melengien te Lepisien, pangasien xa Hi isa ni mi moletin xil xa ladi e taon ak ixeih mak mu ili ngan xa isa ni mi ngan xil xa lateti e taon te hal Sodom e Komorah tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesu misel xat moletin nan xil bit, “!Muteong ni nou! Inou di nasil lelen xamim tengan muha e muxoni sipsip xil xa di mube hilaep te kuli reran xil. Ma xamim muxuxou kuhi tengan sexien namim imese kuhi. ");
INSERT INTO tvk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Reitin, muxuxou kuhi ve xamim vengan xa vat xil na Siu xil lital xat xamim e liling xamim musoh e von lepisien nae. E xil limeas pangas xamim ni ao te xeih xil e nim te pispisiennae xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E vengan xa di munggusil xat nou, lipol ni xamim ha musoh pe met vat xil te kavmen, e pe met suv toto xil mun. Imak, ma mukila muhithiten longeongen hos mi xil e mi ngan xil mun xa latave Siu ti. ");
INSERT INTO tvk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","E melele xa xil lital xat xamim, munanexo ti ve naha xa ti muviteni mi xil mu ti musa sepinien mi xil itep. Vengan xa, e melele nen ak, Ninin Eo iaxa isa naha xa mukila muhithiteni. ");
INSERT INTO tvk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Reitin, nave xamim ti xa ti musepin, e ihe Ninin Eo na Tamemim iaxa isepin ixo xamim. ");
INSERT INTO tvk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Moletin xil limaen tuexil tengan ha lihas vin xil, e tata xil mun ti lipol ni imak tang mi horamue nae xil. E horamue xil mun lihiles ni tamexil e ninexil mun, e limaen xil lihe he ngan xil xa lihas vin xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Moletin xil vus iexil iat xamim vengan di munggusil xat nou. E xamim xa musoh ixeih ituxoh hoxalite te sakpurunien xil ak, ma Hi iteh meulien e xamim. ");
INSERT INTO tvk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Melele xa moletin xil ti lipurun xamim e metimal tei, ha mulesae muhe metimal sav. Reitin mak nabiteni mi xamim xa munahe taon xil vus ti mu te hal Isrel, e Nat Moletin itilomun imei. ");
INSERT INTO tvk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Moletin tei xa nggur pispisien nggo titsa tei, xi nanemi ti nahit xi be eilep mak mu mili titsa nan. E suse nen ak, slev tei nanemi ti nahit xi be eilep mak mu mili suv nan. ");
INSERT INTO tvk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma xamim xa di munggur pispisien xil navan, muhesi xamim tengan mumei muxoni inou, titsa namim. Reitin, xamim xa munggoni slev navan, mumaal tengan mei muxoni nou, suv namim. E xosxa lakes inou, suv namim, ni ‘Belsepul,’ his tei xa misa, ma mukila xa likes xamim ni his xil mun xa isa mak mu vengan xa mube navan. ");
INSERT INTO tvk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Misak ni, ulimim nakan ni xil ti. Holesok xil xa moletin tei bit vakutaxole, Hi isak ni mei iti kesao. Reitin, neta ngan xa miling xuxus ni, Hi ileh rerati imei e valkesao tengan moletin xil lipus kila. ");
INSERT INTO tvk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Holesok xil xa inou di nabiteni mi xamim melele xa ut maluxoluk, xamim ti muhit lelen ni mi moletin xil e miehen. E neta xa di nabit xuxus ni mi xamim, ha muhithiteni pe met moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ulimim nakan ni ngan xil ti xa lakila lavas vin tiei namim e lasakras lavas vin ninin namim. Ulimim ikan ni Hi kestang, vengan xa xi mikila ihas vin moletin tei, e nggo xeihen mun tengan iso ninin nan mun ihe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Munem usil tutut tuman xil ak. Mukila muxal lu ni mani tei xa be hokorong tang. E xosxa Hi Tamemim namaen ni ti, ma ti e xil misakras vamot vamat. ");
INSERT INTO tvk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","E xamim, Hi buli sen hilumim xil vus xa di e vatumim. ");
INSERT INTO tvk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Misak ni, ulimim nakan ti vengan xa, pe met Hi, meulien namim be eilep mak mu mili meulien na tutut tuman xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Moletin xa bit rati xa xi be moletin navan pe met moletin sav xil, ma inou mun, nihit rati xa xi be moletin navan pe met Tata navan xa de ut nesao. ");
INSERT INTO tvk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","E ngan xa di bit rati pe met moletin xil xa xi misin nou, inou mun, nihit rati pe met Tata navan xa de ut nesao xa nasin moletin ak. ");
INSERT INTO tvk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Munanemi ti munahit inou namei tengan niling tomat e ut etan. E‑e. Natamei ti tengan niling tomat, e namei tengan nisak ni moletin xil ti livae mi xil mun tang. ");
INSERT INTO tvk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nggoni ngan taxa Vanuvei Eo na Hi di biteni, inou namei tengan nisak ni … ‘tiramue xil lihiles livae itel tamexil, atuli xil lihiles livae itel ninexil, e havnahin xil lihiles livae itel avu sasa atou nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Reitin, moletin ihe elu mi ngan xil xa ladi vituei dela e tim san xati.’ ");
INSERT INTO tvk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ngan xil xa eheien nae di e tamexil mu ninexil mak mu mili nou, ma latapin ti tengan mei lave moletin navan xil. E ngan xil xa eheien nae di e horamue mu atuli nae xil mak mu mili nou, ma xil mun latapin ti tengan mei lave moletin navan xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngan xil xa latapo eivave te longpangasien nae ti tengan lavusil xat nou, xil latapin ti tengan mei lave moletin navan xil. ");
INSERT INTO tvk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ngan xil xa di lasak pisi tengan lakenin meulien nae ve xil tang, ma meulien nae ikesae reling xil. E ngan xil xa ti limaen meulien nae ikesae vengan di langgusil xat nou, ma, e ut nesao, xil likamet meulien sal. ");
INSERT INTO tvk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“E kakaoen namim, ngan xil xa ti lihur pilei xamim, ixoni ngan taxa ti lihur pilei nou. E ngan xil xa ti lihur pilei nou, ixoni ngan xa ti lihur pilei Tata navan xa misil nou namei. ");
INSERT INTO tvk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Reitin, moletin xa ihur pilei provet tei na Hi vengan xa mikila xa be provet tei, Hi isa huite teni mini ixoni ngan xa xi mun be provet tei nan. E moletin xa ihur pilei moletin xa momal vengan mikila xi momal pe met Hi, Hi isa huite teni mini ixoni ngan xa xi mun momal pe meten. ");
INSERT INTO tvk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E moletin xa misa tutouen mi moletin tei navan xa be hokorong tang pe met moletin sav xil vengan mikila xi di nggusil xat inou, tave ti neta xosxa be oei te merir tang, reitin li nabiteni mi xamim, e ut nesao, moletin ak ihur sen huite teni.” ");
INSERT INTO tvk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Melele xa Iesu misel xat moletin nan xil xa labe lu e le tei (12) bus, xi misil rerat xil laba. E xi mun be reling rute ak e ba be taon sav xil e provins te hal Kaleli. E melele xa di mikakao ba, di pispisi mi moletin xil e di bithiten longeongen hos na Hi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E melele nen ak, Sion Baptis teta tamu e nim te xeih. Xi milongeong usil holesok xil xa Iesu di pol ni. Ma misil rut moletin nan xil tengan liha visal Iesu e lisis pilei usil polien nan. ");
INSERT INTO tvk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Misak ni, xil lamei visal Iesu e lasisi labit, “?Xouk iaxa obe Mesaea xa Hi tehit xat xa isila imei, mu mutatil tova tesav?” ");
INSERT INTO tvk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","E Iesu bit rilomun ni mi xil bit, “Mutilomun muha e muhiteni mi Sion naha xa di mulonge e di mupusi. ");
INSERT INTO tvk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngan xil xa mete tevar, di laketeh; ngan xil xa latesakras lakakao, di lakakao; ngan xil latehur mesien leporsi, hilbexil mei bos; ngan xil vurangexil tevon, vurangexil metal; ngan xil latemat, lameul rilomun; e ngan xil xa latehe hoeo di langgur longeongen hos na Hi. ");
INSERT INTO tvk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","E Hi ituxol xat ngan xil xa tine nasoh ti ve pispisien mu sexien xil navan.” ");
INSERT INTO tvk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Melele xa moletin xil na Sion Baptis di laba, Iesu misep usili mi vanut moletin xil bit, “?Melele xa mutehe uruvuol tengan mupus Sion Baptis, mutenemi mutehit ti mupus hisit moletin eah? ?Muteha tengan mupus moletin tei xa taxeih ti nggoni husmunae tei xa teviei xa misakras vasomal melele xa votiang di buhi? E‑e. ");
INSERT INTO tvk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Ma muteha tengan mupus naha? ?Moletin tova xa mising ni eising xil xa bos pupu? E‑e. Vengan xa moletin xil xa di lasing mak ladi e nim xil xa mahulong ma suv toto xil. ");
INSERT INTO tvk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Muhiteni minou, muteha tengan mupus naha vari? ?Provet tova? !Reitin! Nabiteni mi xamim xa moletin ak be eilep mak mu mili provet sav xil. ");
INSERT INTO tvk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vengan Sion be xi xa Vanuvei Eo na Hi di misep usili bit, ‘Upusi. Inou nisil eloheoh navan itiamu ni xouk. Xi iaxa iha tengan isak mesen suse ve meien nam.’ ");
INSERT INTO tvk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Reitin li nabiteni mi xamim, moletin sav tovuol xa latepesi e ut etan xa be eilep mak mu mili Sion. E xosxa moletin votei tei imaen Hi te ut nesao mei ihe suv toto nan, ma xi ihe eilep mak mu ili Sion pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","E melele xa Sion di tehithiten sepinien na Hi duxoh xosali, Hi di pol nggeih tengan vasak ni haxot te lelaxatien nan mei vahe eilep mu, e ngan xil xa nenemien nae nggeih di lamos en. ");
INSERT INTO tvk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Vengan xa tisen xil na provet xil vus tetiamu tetel rae xil na Mosis teha tetuxoh Sion latesep usil melele xa Hi mei ihe suv toto na moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E xosxa xamim mubesi xamim tengan muke reitin en, ma Sion be Ilaetsa xa Hi tehit xati tehit isila imei. ");
INSERT INTO tvk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xosxa vurangemim di, muteong kuhi ni naha xa di nabiteni. ");
INSERT INTO tvk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Xamim, moletin xil te xosali, munggoni naha? Xamim munggoni tutut horamue xil xa di ladotan sangas ni von posen e di lake xat xil mun tang labit, ");
INSERT INTO tvk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Melele xa xamem di mapol ni nggoni ngan xa di mabas kitar e sien, iemim ti tavei tengan muvol vatel xamem. E melele xa di mapol ni nggoni ngan xa di madang, iemim ti tavei tengan mutang vatel xamem.’ ");
INSERT INTO tvk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xamim munggoni tutut xil ak vengan xa iemim ti tavei nou mu Sion mun. Melele xa Sion Baptis bemei, xi di bal ni anien ve sisen e tamu ti uaen, e xamim iemim ti tavei mubit, ‘!Sion, ninin tesa tei da en!’ ");
INSERT INTO tvk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Di, melele xa inou, Nat Moletin, namei, nangganien e namu uaen. E xamim iemim ti tavei nou mubit, ‘!Pus ti moletin ak! Xi di ngga vin xi ni anien e di mumun tova tang. E xi di mikes moletin xil te takis e moletin tesa sav xil ni timue.’ E sexien nar kekes ipisen ni xa visi e xir di nggusil metisouen na Hi.” ");
INSERT INTO tvk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Di, Iesu misepin nggeih xat moletin xil te taon xil xa xi teha tepol ni merekel xil holu en. Vengan neta sav xa latepusi, latnaviles ti ra sexien tesa xil nae. ");
INSERT INTO tvk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Xi biteni bit, “!Aue li! !Isa pupu mi xamim, Siu xil te hal Korasin! !E isa pupu mun mi xamim, Siu xil te hal Betsaeta! Vengan xamim mutesin merekel xil xa natepol ni pe metemim, Hi isa pangasien ihe holu mi xamim. Vengan xa vahit moletin xil te hal Taer e Saedon xa latave Siu ti, lapus hisit merekel xil vaxoni ngan xa mistal mi xamim, ma xil laviles ra tesaen nae xil nousav ngamu. Io, xil lapisen ni xa lalonge vasa vamak: lasing ni talmusu xil e laxul ni vulmeas. ");
INSERT INTO tvk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Reitin li nabiteni mi xamim xa, e Melengien te Lepisien, longpangasien xa Hi isa ni mi xamim ixeih mak mu ili ngan xa isa ni mi ngan xil xa lateti e taon xalu te hal Taer e Saedon. ");
INSERT INTO tvk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","?E xamim, Siu xil te hal Kapaniam, munemi xa Hi ipet rat xamim muhe ut nesao? !E‑e! !Xi iso xamim muhe etan e Upang xa misakras vamat! Vengan xa vahit moletin xil te hal Sodom lapus merekel xil vaxoni ngan xa natepol ni tetel xeihen pe metemim, taon ak vata tang vatuxoh xosali. ");
INSERT INTO tvk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Reitin li nabiteni mi xamim xa, e Melengien te Lepisien, longpangasien xa Hi isa ni mi xamim ixeih mak mu ili ngan xa isa ni mi ngan xil xa lateti e taon te hal Sodom ili xamim.” ");
INSERT INTO tvk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","E melele nen ak, Iesu misis bit, “Tata, xouk obe Suv te ut nesao e ut etan. Namesuk holu vengan xa di oling xuxus ni holesok xil ak ra ngan xil xa labe metisou e lakilakil kuhi. E di opisen koute teni mi ngan xil xa langgoni tutut horamue xil xa latasukul kuhi ti. ");
INSERT INTO tvk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata, ngan ak be reitin vengan xa nggusil naha xa xouk iem bei tengan vastal. Reitin.” ");
INSERT INTO tvk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Di, Iesu misepin mi moletin xil bit, “Tata navan miling holesok xil vus di e heok. E moletin xil latapus kil ti Nat Hi vengan xa Tamen kestang di pus kila. E moletin xil latakil ti Hi vengan xa Natneli kestang mikila del ngan xil mun xa Natneli bosei xil tengan ipisen ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mumei visal nou, xamim xa di mulong pangas xamim ve holesok xil xa meas xa di mupoe e meulien namim, e inou nisa ngengelen mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muteong ni nou e muhusil xat nou, vengan xa inou nabe hanmerou e nenemien navan be tan. Imak, ma mukamet ngengelen e meulien namim. ");
INSERT INTO tvk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ve pispisien navan xil taxeih ti e holesok xil xa nilingi e xamim tengan mupol ni memeit tang.” ");
INSERT INTO tvk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vatei, e Sabat, Iesu e moletin nan xil di lakakao langgur xoteh naho tei te uit. E melele xa di lakakao laba, moletin nan xil, mae nggat xil, ma laki xoteh utut uit xil e di langga ni. ");
INSERT INTO tvk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","E melele xa Farasi xil lapusi, lasepin mi Iesu labit, “Pus ti mu. Naha xa moletin nam xil di lapol ni di langgur xoteh rae na Mosis usil Sabat.” ");
INSERT INTO tvk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E Iesu bit rilomun ni mi xil bit, “?Midep? ?Xamim mutavuli ti naha xa suv toto Deved e moletin nan xil latepol ni melele xa mae teat xil? ");
INSERT INTO tvk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deved tehe vangit Nim Tavolin na Hi e tehur beret eo xa pris xil kestang lakila lava ni. E Deved del moletin nan xil latea beret ak, neta sav xa latehur xoteh rae tei na Mosis. ");
INSERT INTO tvk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Midep? ?E ut sav, mutavuli ti xa e Sabat xil vus, pris xil xa di lapol e Nim Eo di langgur xoteh rae na Mosis usil Sabat, e pe met Hi, latapol ni ti tesaen? ");
INSERT INTO tvk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","E xosali, moletin tei mistal xa be eilep mak mu mili Nim Eo na Hi. ");
INSERT INTO tvk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Vanuvei Eo na Hi di biteni bit, ‘Ieok ti tavei sanien eo namim xil kestang, e ieok bei mak mu tengan iemim isae e moletin sav xil.’ Xosxa mukil koute te sepinien ak, ma munasa ti sepinien te xeih ak mi ngan xil xa latapol ni ti neta vasa. ");
INSERT INTO tvk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Moletin navan xil latapol ni ti neta vasa vengan xa xil di langgusil xat nou, Nat Moletin. E inou nabe eilep mak mu nali Sabat.” ");
INSERT INTO tvk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Di, Iesu e moletin nan xil labe reling rute ak e labe nim te pispisienna Farasi xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","E moletin tei xa hen mikavui da. E rut moletin xil mun ladi xa iexil bei tengan liso sepinien tova iha xat Iesu ve neta ngan. Misak ni, xil lasisi labit, “Hiteni mi xamem. ?Rae xil na Mosis maen ni tengan lapol ni moletin tei mei bos rilomun e Sabat?” ");
INSERT INTO tvk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu bit rilomun ni mi xil bit, “?Midep? ?Xosxa tei e xamim, sipsip tei san mot be vul e Sabat, ma ipol ni naha mini? Xi ha ipo rati ra vul ak. ");
INSERT INTO tvk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E moletin tei bos mak mu mili sipsip tei. Ma rae nar xil maen xir ti ripol ni sexien hos xil e Sabat.” ");
INSERT INTO tvk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Di, xi biteni mi moletin xa hen mikavui bit, “Te momal ni hem.” Ma melele xa miso hen momal, mei bos rilomun nggoni hen tei mun tesav. ");
INSERT INTO tvk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","E Farasi xil lastal e di lasep ves suse tova tengan lihas vin Iesu ixo en. ");
INSERT INTO tvk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E Iesu mikila xa Farasi xil ak iexil bei tengan lihas vini, ma xi be reling rute ak. E tatit moletin xil holu langgusil Iesu e xi midal rerat mesien ra ngan xil vus xa lamesei. ");
INSERT INTO tvk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","E melele xa di pol ni, di misep xol xil tengan linavit ti mi moletin sav usil naha xa xi di tepol ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","E holesok xil ak testal tengan vasak ni naha xa Hi tesep lelen ni texo provet Aesea mei ihe reitin xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ngan ak be moletin te polien navan xa natehosei, eheien navan di en e nabesi nou ven. Nise xati ni Ninin navan, e xi ihithiteni mi moletin xil te ut etan xa latave Siu ti xa Hi ipol ni naha xa momal mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xi nangor ti natel mosav xil e nameun votei ti. Io, moletin ti nalong raen nave nesao usil suse xil. ");
INSERT INTO tvk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ve esaeen nan di e ngan xil xa lataxeih ti, xi napol ni ti neta naxeih mi xil. E ngan xil xa lamerou tang, xi napangei xil ti. Xi ipol ni imak ituxoh melele xa isak ni sexien xil xa momal pe meten mei ili sexien xil xa tamal ti. ");
INSERT INTO tvk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E moletin xil te ut etan mei liling nenesien nae e hisen.” ");
INSERT INTO tvk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Di, rut moletin xil ladel moletin tei bemei visal Iesu. Moletin ak, meten bar e misakras vasepin vengan ninin tesa tei da en. Ma Iesu misak ni moletin ak mei miketeh e misepin rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ngan xil xa lapusi, latemanin ni labit, “?Midep? ?Moletin ak be ngan xa istal ixo vatimol na suv toto Deved xa Hi tehit xati tengan isa ni imei?” ");
INSERT INTO tvk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","E melele xa Farasi xil lalong sepinien na moletin xil ak, labiteni mi xil labit, “!E‑e! Moletin ak mikila vahol rerat ninin tesa xil tang vengan di pol del xeihen xa Belsepul, suv toto na ninin tesa xil, di misa ni mini.” ");
INSERT INTO tvk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","E Iesu mikil nenemien nae, ma biteni mi xil bit, “Xosxa moletin xil na suv toto tei di labae mi xil mun tang, ma xeihen na suv toto ak mei ihe neta sav tang. E xosxa moletin xil xa ladi vituei e metimal mu vatimol tei di labae mi xil mun tang, ma his metimal mu vatimol ak ikesae. ");
INSERT INTO tvk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma xosxa Belsepul di minggol rerat ninin tesa nan xil, ma xi di bae mi xi mun tang. Xosxa imak, ma xeihen te lelaxatien nan ilesae relingi. ");
INSERT INTO tvk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","?E xosxa Belsepul di misa xeihen minou tengan nahol rerat ninin tesa nan xil, ma midep mi moletin namim xil? ?Xil langgol rerat ninin tesa xil ra moletin xil del xeihen na visi? Xil iaxa di lapisen ni xa neta xa di musep usili tamal ti. ");
INSERT INTO tvk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","E xosxa inou di nanggol rerat ninin tesa xil ra moletin xil nggo xeihen xa Ninin na Hi di misa ni minou, ma ngan ak di pisen ni xa lelaxatien na Hi xa be suv toto di mistal tuei mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nihit kila mi xamim ixo vole tei. Moletin tei misakras vahe nim ma silixin tei tengan vakan ni holesok nan xil melele xa xi da tamu e tim san. Itiamu, ha ivar xat silixin ak. Ti, ikila ihe nim man e ileh vuol ni holesok nan xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ngan xil xa latamos ti vatel nou, xil di labae del nou. E ngan xil xa latatutou ni nou ti tengan maleh viton moletin xil vaxoni sipsip xil, xil di langgol rerat xil e di laloh tetasil. ");
INSERT INTO tvk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","E nabiteni mi xamim, Hi mikila vaketeh vamal rilomun mi ngan xil xa lapol ni hisit tesaen savsav xil mu lasep purun his Hi mu his moletin sav. E moletin xa misep purun his Ninin Eo, Hi misakras vaketeh vahos rilomun mini. ");
INSERT INTO tvk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Reitin, ngan xil xa di lasepin misa minou, Nat Moletin, Hi mikila vaketeh vahos rilomun mi xil. E ngan xil xa lasepin misa mi Ninin Eo, Hi naketeh ti navos rilomun mi xil, xosali mu melele xa ti imei. ");
INSERT INTO tvk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Xosxa vatiei tei bos, ma huite teni mun ihos. E xosxa vatiei tei misa, ma huite teni mun isa. Huiei iaxa di pisen ni xa vatiei tei bos mu misa. ");
INSERT INTO tvk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!E xamim munggoni vanut tetal sasa xil xa di langas vin moletin xil ni vulongexil! ?Xamim mukila musep usil holesok xil xa bos itep? !Musakras! Vengan xa moletin xil di lasep usil naha xa di e iexil, e xamim mube moletin tesa xil. ");
INSERT INTO tvk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Moletin hos tei, ien polu ni nenemien hos xil, ma di misepin usil holesok xil xa bos. E moletin tesa tei, ien polu ni nenemien tesa xil, ma xi di misepin usil holesok xil xa misa. ");
INSERT INTO tvk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nabiteni mi xamim, e Melengien te Lepisien, Hi ilepis sepinien talang namim xil vus xa di muso ni, e isa pangasien mi xamim ven. ");
INSERT INTO tvk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Reitin, itel sepinien namim xil tang, Hi ipus kila xa mumal mu mukavui, e isa naha xa imal mi xamim vus ihusili.” ");
INSERT INTO tvk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Di, rut titsa xil te rae na Mosis del Farasi xil mun lamei visal Iesu e labiteni mini labit, “Titsa, iemem bei tengan upol ni neta tova xa eilep tengan mapus kila xa be reitin xa xouk onggo visal Hi.” ");
INSERT INTO tvk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","E Iesu bit rilomun ni mi xil bit, “Xamim, moletin xil te xosali ak, mukavui e mustokovein Hi nggoni atou xa mistokovein tiramue xati nan tengan vahur tiramue sav tova. Ve rin ak, iemim bei tengan mupus neta tova xa eilep tengan muke reitin xa natexo visal Hi namei. E ninapol ni ti neta xa eilep ve xamim. Mupus neta tei takes xa ixoni ngan xa testal mi provet Siona tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vengan provet Siona tete vang meseo melengien e vongien tol (3). Nggusil sexien nen tak, inou mun, Nat Moletin, nite pe huitan te maten melengien e vongien ihe tol (3). ");
INSERT INTO tvk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","E Melengien te Lepisien, mol‑Nineva xil lisoh e lisepin iha xat sexien na moletin xil te xosali. Reitin, xil lisepin iha xat xamim vengan xa melele xa xil latehe elu mi Siu xil, latelong sepinien na Hi xa provet Siona tehithiteni mi xil, xil latehiles ra sexien tesa nae xil. E xosali, tei xa be eilep mak mu mili Siona dak ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Reitin, e Melengien te Lepisien, suv toto te hal Seba tetiamu xa tehe atou, xi isoh e isepin iha xat moletin xil te xosali. Vengan xi texo sotin pupu tengan mei valong metisouen na suv toto Solomon. E xosali, tei xa be eilep mak mu mili Solomon dak ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Melele xa ninin tesa tei be reling moletin tei ba, di mikapis e uruvuol tengan vakamet ut tova xa bos te ngengelen. E melele xa takameti, ");
INSERT INTO tvk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ihiteni mi xi mun tang ihit, ‘Nitilomun nihe nim mavan xa natehe relingi natemei.’ E melele xa itilomun imei, ma ikameti xa ladaveas tuei e nim ak, laling pilei holesok xil, e ninin tesav tovuol en. ");
INSERT INTO tvk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Isak ni, xi iha e ileh ninin lu e he sav (7) xa lasa mak mu lali xi. E xil lihe nim, ha liti en. Nim ak be moletin tei, e lisak ni meulien na moletin ak isa mak mu ili ngan xa teti en tetiamu. Ngan istal mi xamim, moletin tesa xil te xosali ak.” ");
INSERT INTO tvk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Melele xa Iesu di tamu misepin mi vanut moletin xa mahulong xiak, ninen e tuneli xil lamei. Lamei lasoh ladi nga e hale e labit lisepin mini. ");
INSERT INTO tvk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma moletin tei bemei visal Iesu e bit mesen ni mini bit, “Ninom e tumali xil lasoh ladi nga hale iaxor, e labit lasepin minuk.” ");
INSERT INTO tvk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","E Iesu bit rilomun ni mini bit, “?Visi iaxa be nana navan? ?Visi iaxa be tua navan xil?” ");
INSERT INTO tvk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Di, miti mikapis e moletin nan xil e biteni bit, “?Mupusi? Ngan xil ak labe nana navan xil e tua navan xil. ");
INSERT INTO tvk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vengan ngan xil xa di lapol ni naha xa Tata navan xa de ut nesao ien bei tengan ti lipol ni, xil iaxa labe nana navan xil, tuxoli xil, e hinoxoli xil mun.” ");
INSERT INTO tvk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E melengien nen tak, Iesu be reling nim ak e ba dotan de seri Oei Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","E vengan xa vanut moletin xil labe holu pupu xa di lakapis xole, Iesu but be bot tei e ba dotan da en. E moletin xil lasoh ladi nga ut. ");
INSERT INTO tvk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Di, xi dei vole xil holu mi xil bit, “!Muteong kuhi! Vatei, moletin tei be naho tengan vaso utiei en. ");
INSERT INTO tvk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E melele xa miso ni, rut utiei xil lakiri e suse xa tan nen nggeih, e tuman xil mei lada rerati. ");
INSERT INTO tvk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Rut utiei xil lakiri e tan xa hat xil holu di en e tan nen mahin tang. E inggak, utiei xil ak lateh manon vengan xa tan nen mahin. ");
INSERT INTO tvk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","E melele xa eai bemei nesao, ngga vin ngan xil xa lateteh, e lameles lamat. Lamat vengan xa amulite xil tave tan pupu ti. ");
INSERT INTO tvk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Rut utiei xil mun lamot e tan xa munae tesa di meul en. E melele xa lateh, munae tesa xil ak lameul xol vin xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","E rut utiei xil ak, lamot e tan xa bos. Ma xil lameul bos, e laba ni huite xil. Ngan xil, laba ni huite xil holu; ngan xil mun laba ni huite xil holu mak mu; e ngan tesav xil mun, xil iaxa ladaxao xa ladaxao ni huite xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","!Xosxa vurangemim di, muteong kuhi ni naha xa di nabiteni!” ");
INSERT INTO tvk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Melele xa Iesu misepin bus, moletin nan xil lamei visali e lasisi labit, “?Veneh ma xouk di odei vole xil mi moletin xil?” ");
INSERT INTO tvk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E Iesu bit rilomun ni mi xil bit, “Xamim iaxa Hi tehosei xamim tengan mukil kuh koute te sepinien xuxus usil itep iaxa xi mei ihe suv toto na moletin nan xil. E moletin sav xil, Hi tenahosei xil ti tengan lakila. ");
INSERT INTO tvk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngan xil xa lakil kuh koute te sepinien xil ak, ma Hi isak ni xil likilakil pilei mak mu ha vuma … lipolu ni kilakilen nan. E ngan xil xa latakil ti koute xil teni, ma hokorong xa di langguri, Hi ihur rati ra xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inou di nasepin mi xil nggo vole xil tengan, tave ti neta xa di lapus neta ngan, e xil latapus kil ti koute teni. Reitin, tave ti neta xa di lalong neta ngan, e xil latalong kil ti. ");
INSERT INTO tvk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sexien nae di misak ni sepinien na provet Aesea tetiamu mei be reitin xa bit, ‘Xamim muteong vuma … e munalong kil ti neta. Muketeh vuma … e munapus kil ti neta. ");
INSERT INTO tvk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tine moletin xil ak xa nggeih mei nggeih pilei sung, e di laki xol vurangexil e di label xat metexil. Xil lapol ni mak vengan iexil ti tavei tengan lapus kil neta ngan ni metexil, mu lalong kil neta ngan ni vurangexil. Vengan xosxa linamak ti, ma xil likil kuh koute te sepinien navan, tinexil mei imerou e lihiles meulien nae, e inou mei nital rat xil ra mesien nae xil.’ ");
INSERT INTO tvk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“E tuxolxatien na Hi di tuei e xamim, moletin navan xil, vengan melele xa mupus neta tei ni metemim, mupus kila. E melele xa mulong neta ngan ni vurangemim, mulong kila. ");
INSERT INTO tvk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Reitin li nabiteni mi xamim, tetiamu, provet xil holu e moletin sav xil xa latemal pe met Hi, iexil tehei mak mu tengan lapus naha xa xamim di mupusi xiak, e xil latnapus ti. Io, iexil tehei tengan lalong naha xa xamim di mulonge xiak, e xil latnalong ti. ");
INSERT INTO tvk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Muteong kuhi ni koute te vole xa natehiteni usil moletin xa milih kon e hisit tan tesav xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Utut kon ngan xil xa lakiri e suse xa tan nen nggeih, xil langgoni moletin tei xa milong sepinien usil rin xa Hi mei ihe suv toto e meulien na moletin xil. E melele xa milonge, xi talong kil ti koute teni. E Temat mitemanon bemei, nggur rat sepinien xa mot de tinen. ");
INSERT INTO tvk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Utut kon ngan xil xa lakiri e tan xa hat xil holu di en, xil langgoni moletin xa milong sepinien na Hi e, vatei takes, ngguri del sien. ");
INSERT INTO tvk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","E vengan xa amulite xil te neketen nan tameul ti mu, moletin ak misoh e neketen nan be terume tang. E melele xa sakpurunien xil e melengien te xeih xil bemei ni ve sepinien ak, vatei takes, xi mot e neketen nan. ");
INSERT INTO tvk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","E utut kon ngan xil xa lakiri e tan xa munae tesa di meul en, xil langgoni moletin tei xa milong sepinien na Hi e minexo pupu ve holesok xil te ut etan e eheien nan di e mani mak mu holu. Ma holesok xil ak lameul xol vin sepinien na Hi xa ngguri, ma tava ni ti huite e meulien nan. ");
INSERT INTO tvk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","E utut kon xil xa lakiri e tan xa bos, xil langgoni moletin xa milong sepinien na Hi e milong kila. E meulien nan, sepinien nen ak ba ni huite. E meulien na rut moletin xil, ba ni huite xil holu; e ngan tesav xil, ba ni huite xil holu mak mu; e ngan tesav xil mun, sepinien ak daxao xa daxao ni huite xil e meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E Iesu dei vole tei mun mi vanut moletin xil bit, “Suse xa Hi mei ihe suv toto te meulien na moletin xil ixoni moletin tei xa milih utut uit e naho san. ");
INSERT INTO tvk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","E melele xa moletin xil vus ba lapat, elu tei na moletin ak bemei e naho san e miso utut munae tesa xil mun ba lamosos del uit xil ak. Di, milesae ba. ");
INSERT INTO tvk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Misak ni, melele xa uit xil ak lateh, lameul lamei nesao e langgur vei, munae tesa xil mun lameul vituei tang del xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Melele xa moletin xil te polien laba tengan lapus naho sa masta nae, lapus kil munae tesa xil en. Ma ladilomun ba labiteni mini labit, ‘!Masta! ?Midep? ?Utut uit xil xa oteso xil e naho sam latehos mu latesa tang? ?Vengan xosxa latehos, ma munae tesa xil ak latexo xave latemei?’ ");
INSERT INTO tvk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“E masta nae bit rilomun ni mi xil bit, ‘!E‑e! Elu tei navan iaxa tepol ni.’ “Ma moletin te polien nan xil lasisi labit, ‘?Ma midep? ?Iem bei tengan mava maput rerat munae tesa xil ak?’ ");
INSERT INTO tvk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“E masta nae bit rilomun ni mi xil bit, ‘E‑e. Muling xil limeul liti nga, maxani mutnaput rerat uit xil xa labos melele xa di muput rerat munae tesa xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muling uit e munae tesa xil tit lalimeul vituei tang ituxoh melele te leh anien en. E melele xa moletin xil ti limei tengan lileh anien, nihiteni mi xil tengan ha lileh rerat munae tesa xil ak itiamu, e livar viton xil lihe vanute xil. Ti, nimei niso munae tesa xil ak lihe upang. Ti, moletin xil ak litilomun ha lileh uit xil e ha liserev kuh xil liti e povah navan.’” ");
INSERT INTO tvk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E Iesu dei vole tei mun mi vanut moletin xil bit, “Suse xa Hi mei ihe suv toto e meulien na moletin xil ixoni utut mastad xa moletin tei ngguri e ba milihi e naho nan. ");
INSERT INTO tvk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tave ti neta xa utut mastad hokorong mak mu ni utiei sav xil, e melele xa meul, di meul tepiei be nesao ba vuma … mei mahulong pupu mili holesok sav xil xa di lalih xil e naho. E melele xa matu, xi mei be holiei tei xa mahulong xa pipin tengan tuman xil limei lipol ni nunu mae xil e halite xil.” ");
INSERT INTO tvk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu dei vole tei mun tesav mi xil bit, “Suse xa Hi mei ihe suv toto e meulien na moletin xil ixoni is vutei xa atou tei milehi e bilesi del pulaoa xa mahulong. E tave ti neta xa miso is be hokorong tang en, is ak pol ni pulaoa mikaio ba vuma … mei be mahulong xa mahulong.” ");
INSERT INTO tvk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E holesok xil xa Iesu misep usili mi vanut moletin xil, xi di misa ni mi xil nggo vole kestang. Xi tenavit kil ti koute nen mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iesu pol ni mak tengan vasak ni sepinien xa Hi tesa ni mi provet tei mei vahe reitin xa bit, “Inou nitei vole xil. Reitin, nggo vole xil, nihithiten usil holesok xil xa di texus e melele xa Hi tepeas ni ut etan, e minggus duxoh xosali.” ");
INSERT INTO tvk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Melele xa Iesu misepin mi vanut moletin xil bus, be reling xil e dilomun be nim xa da en. Moletin nan xil langgusili lamei visali, e lasisi labit, “?Vole usil munae tesa xil, ukila uhit kil koute teni mi xamem?” ");
INSERT INTO tvk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma Iesu biteni mi xil bit, “Koute teni mak. Inou, Nat Moletin, nabe moletin xa naso utut uit xa bos. ");
INSERT INTO tvk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Naho ak be ut etan, e utut uit xil xa lameul bos labe moletin xil xa Hi be suv toto nae. E munae tesa xil labe moletin xil xa Temat be suv toto nae. ");
INSERT INTO tvk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Elu na moletin xa teso xil be Temat. Melele te leh anien en be hoxalite te melengien xil xa radi en. E moletin xil xa mei lileh anien labe masxaxa xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nggoni ngan xa laput rerat munae tesa xil e laso xil labe upang, lipol ni imak e hoxalite te melengien xil xa radi en. ");
INSERT INTO tvk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Reitin, e melele nen ak, inou, Nat Moletin, nisil masxaxa navan xil tengan ha lihe ut xil vus xa di nalaxati, e liput rerat ngan xil xa di lapol misa e holesok sav xil mun xa di misak ni moletin xil di lamot e tesaen. ");
INSERT INTO tvk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ti, masxaxa xil ha liso moletin tesa xil ak lihe upang xa mahulong, e, e rute ak, xil ti limuis e ti lingas luhexil ve longpangasien nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ti, ngan xil xa lamal pe met Hi, liminehin ixoni eai e rute xa Tamexil be suv toto en. !Xosxa vurangemim di, muteong kuhi ni naha xa di nabiteni!” ");
INSERT INTO tvk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesu misepin rilomun mi moletin nan xil bit, “?Melele xa Hi mei be suv toto e meulien na moletin tei, ngan ak nggoni naha? Ixoni bokis tei xa holesok holu xa bos di en xa moletin tei teling xuxus ni tete naho tei. Bokis ak da vuma … moletin sav tei ba mikameti. E melele xa pusi, milonge bos xa bos ven. Ma miling xuxus rilomun ni da ngga. Di, dilomun be tim san e pos ni holesok xil vus nan e mileh mani nen ba nggal rat tan xa bokis ak da en be nan. ");
INSERT INTO tvk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“?Reitin, melele xa Hi mei be suv toto e meulien na moletin tei, ngan ak nggoni naha? Ixoni moletin tei te bisnis xa di milang ves valit vatiei hos xil te tas. ");
INSERT INTO tvk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E melele xa mikamet valit vatiei hos tei te tas xa mani teni mahulong, xi mitemanin. Ma dilomun be tim san, e pos ni holesok nan xil vus. Di, mileh mani nen e ba nggal valit vatiei te tas ak be nan. ");
INSERT INTO tvk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“?Vatei mun, melele xa Hi mei be suv toto e meulien na moletin tei nggoni naha? Ixoni melele xa laso net tengan laleh meseo xil. Melele xa laso ni be tas, laleh hisit meseo sav xil holu. ");
INSERT INTO tvk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Melele xa net polu ni meseo xil, lalihi be ut. Di, moletin xil te meseo ladotan xorelisi e laso viton kuh meseo xil xa bos labe valeat xil. E meseo xil xa lasa, laso xil laba. ");
INSERT INTO tvk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Imak vari e hoxalite te melengien xil xa radi en. Masxaxa xil mei lilepis moletin xil te ut etan ihusil suse nen tak. Xil lileh rerat moletin xil xa lasa ra ngan xil xa lamal pe met Hi, ");
INSERT INTO tvk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","e ha liso moletin xil ak lihe upang xa mahulong. E rute ak, xil ti limuis e ti liat luhexil ve longpangasien nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“?Midep, xamim mukil kuh koute te holesok xil ak, mu …?” E moletin nan xil labit rilomun ni mini labit, “Io, makila.” ");
INSERT INTO tvk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iesu biteni mi xil bit, “Nggusil nenemien ak, titsa xil vus te rae na Mosis xa lamaen Hi mei be suv toto e meulien nae tengan lihusil kuh pispisien nan xil, xil langgoni eilep tei xa holesok nan xil holu. Ma xi mikila ihe nim man e ileh rerat holesok xil xa bos pupu, ngan xil xa be te nousav, e ngan xil mun xa be neta hu.” ");
INSERT INTO tvk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Melele xa Iesu dei vole xil ak bus, xi be reling rute ak ");
INSERT INTO tvk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","e ba be Nasaret, metimal xati nan. E rute ak, Iesu be nim te pispisien, dotan e di pispisi mi moletin xil. E melele xa lalong pispisien nan xil, latemanin ni e labiteni mi xil mun tang labit, “?Moletin ak nggur kilakilen e xeihen ak nggo xave? ");
INSERT INTO tvk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","?Tave nat moletin ti taxa di tepol ni nim xil tang? Nana nan be Meri. E tuneli xil labe Temis, Sioses, Saemon e Sudas tang. ");
INSERT INTO tvk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hineli xil vus ladi visal xir e rute ak. !Moletin ak be tei e xir tang! ?Mak, ma xi nggur holesok xil ak nggo xave?” ");
INSERT INTO tvk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ve rin ak, moletin xil tine misoh e lanem male ni Iesu. E Iesu biteni mi xil bit, “Moletin xil vus di lamerere ni provet tei na Hi. E moletin xil te metimal xati nan e vatimol xati nan mun, xil tit lanem male ni.” ");
INSERT INTO tvk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Misak ni, e rute ak, Iesu tapol ni ti merekel xil vahe holu vengan xa neketen nae tovuol en. ");
INSERT INTO tvk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E melele nen ak, suv toto Herod Antipas xa milaxat provins te hal Kaleli milongeong ni holesok xil xa Iesu di pol ni. ");
INSERT INTO tvk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma Herod biteni mi moletin te polien nan xil bit, “Iesu ak be Sion Baptis vari. Tave ti neta xa xi mat, e temea rilomun ra maten. Ve rin ak iaxa nggur xeihen tengan vapol ni merekel xil.” ");
INSERT INTO tvk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Suv toto Herod Antipas minexo pupu mak vengan xi vari tesa raen tengan moletin te vaeen nan xil ha lital xat Sion, livar xati, e liso ni ihe nim te xeih. Xi tepol ni temak vengan xa Sion tesepin texeih teha xati tehit, “Herod, sexien nam xil tamal ti vengan oteli del Herodias, atou na tumali Pilip. Naha xa di opol ni nggur xoteh rae na Hi.” ");
INSERT INTO tvk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","E tave ti neta xa Herod bit vahas Sion vamat, xi tenapol ni ti vengan ulin tekan ni ekaten na moletin xil vengan xil di latenemi latehit Sion Baptis tehe provet tei. ");
INSERT INTO tvk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Di, vatei, latepol ni anien ve melengien xa latepes suv toto Herod en. E melengien ak, atuli na Herodias tehol pe met moletin xil vus e tesak ni Herod tehesi xi pupu ven. ");
INSERT INTO tvk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Misak ni, xi pol ni hitxatien tei te xeih mi atuli ak xa isa naha vari xa xi ien bei mini. ");
INSERT INTO tvk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ma atuli ak be visal ninen e misepin mini. Di, dilomun ba pus suv toto Herod e biteni mini bit, “Taxeak, ieok bei tengan uhas vin Sion Baptis, uta xoteh vatin, e usa ni minou ite tre tova.” ");
INSERT INTO tvk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Melele Herod milonge mak, xi milonge misa pupu. E neta sav xa milonge mak, xi misemae ni moletin nan xil tengan ha lipol ni, vengan ien ti tavei vahur xoteh hitxatien nan pe met moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma moletin te vaeen nan xil labe nim te xeih, e lada xoteh vat Sion ra tiei nan. ");
INSERT INTO tvk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Di, laling vatin de tre tei e lapoe ba lasa ni mi atuli ak. E xi sung, ngguri ba misa ni mi ninen. ");
INSERT INTO tvk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Melele xa moletin xil na Sion lalongeong ni xa xi mat, lamei e lapo tiei nan, ba ladihin ni. Di, ba labit mesen ni mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Melele xa Iesu milongeong ni xa Sion mat, xi but be bot del moletin nan xil e labalis labe ri oei e rute xa moletin xil latovuol en. E melele xa moletin xil lalonge, xil langgo taon nae xil e ba langgusili. ");
INSERT INTO tvk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma melele xa Iesu but be reling bot, xi pus vanut moletin xil xa mahulong di ladatili tuei. E melele xa pus xil, ien misae e xil e midal rat ngan xil xa lamesei ra mesien nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","E melele xa eai minu, moletin nan xil lamei visali e labiteni mini labit, “Rute ak be toun ut e da be vongien tuei xiak. Bos xa usil rerat vanut moletin xil ak liha tengan ha lihe metimal xil e lixal ti anien ae.” ");
INSERT INTO tvk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","E Iesu biteni mi moletin nan xil bit, “Rinasil rerat xil ti linaha. Xamim tang musa anien mi xil tengan lia ni.” ");
INSERT INTO tvk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","E xil labit rilomun ni mini labit, “!Ei! ?Mupol ni itep, vengan xa anien ar tapin ti? Pusi xiak, beret be lim e meseo mun be lu tang.” ");
INSERT INTO tvk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu biteni mi xil bit, “Musa ni vamei minou.” ");
INSERT INTO tvk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Di, xi biteni mi vanut moletin xil tengan litotan e rute tei xa bos xa husmunae di en. Melele xa ladotan bus, mileh beret lim (5) del meseo lu (2), miketeh be nesao e misa memesien ba mi Hi ven. Di, bul papas beret xil e misa ni mi moletin nan xil tengan liseti beret ak itel meseo mun mi vanut moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Moletin xil vus langganien kuhi e vange polu. E melele xa moletin xil na Iesu laba mun tengan laleh saxut anien xil, lase ni be valeat lu e le tei (12) ba vuma … xil vus lapolu. ");
INSERT INTO tvk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","E melele nen ak, tiramue xil xa langganien duxoh taosen lim (5000). E atou e horamue xil, latavuli xil ti. ");
INSERT INTO tvk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Melele xa langganien bus, Iesu biteni mi moletin nan xil tengan litiamu ni lihe ri Oei Kaleli. E xi kestang ita tengan isil rerat vanut moletin xil lihaha. ");
INSERT INTO tvk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Melele xa misil rerat moletin xil bus, xi mika sen tang be nesao e vathu tei tengan ha vasis. E inggak Iesu da tasen ba duxoh vongien. ");
INSERT INTO tvk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","E melele nen ak, moletin xil na Iesu ladi e bot nae e Oei Kaleli, sotin ra ut. E xil di lakameti nggeih tengan lavalis vengan labisu ni votiang tei xa nggeih e tahe xil mun mei di bas bot nae. ");
INSERT INTO tvk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","E makoe roroh, ut taluv pilei ti mu, Iesu bemei visal xil e di mikakao e ramut oei nggoni ngan taxa di mikakao e tan tang. ");
INSERT INTO tvk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E melele xa moletin nan xil lapusi xa di mikakao e ramut oei, ulixil mikan tova tang e lameun be nesao labit, “!Aue li! !Ninin tei!” ");
INSERT INTO tvk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","E vatei takes, Iesu misepin mi xil bit, “!Ulimim nakan ti! !Inou tang! Tinemim namulul ti.” ");
INSERT INTO tvk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E Pita bit rilomun ni mini bit, “!Suv, xosxa be xouk reitin, usemae ni tengan nikila nikakao e ramut oei e nihat visaluk!” ");
INSERT INTO tvk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Iesu biteni mini bit, “!Amei!” Misak ni Pita but reling bot e di mikakao e ramut oei ba ni Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","E melele xa Pita pusi xa votiang di bemei nggeih, ulin mikan, ma da merir be tan e oei. Melele xa pusi mak, mikei be nesao bit, “!O suv, ututou ni nou li!” ");
INSERT INTO tvk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Vatei takes, Iesu misa hen e dal xati bit, “!Neketen nam hokorong pupu! ?Veneh ma otanesi ti e nou?” ");
INSERT INTO tvk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E melele taxa lube bot, votiang be tan. ");
INSERT INTO tvk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Melele xa lapusi mak, moletin xil xa ladi e bot lamot mi Iesu e labiteni mini labit, “!O reitin mak, xouk vari iaxa obe Nat Hi!” ");
INSERT INTO tvk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Di, langgur xoteh Oei Kaleli ba vuma … laduxoh ut e tan te hal Kenesaret. ");
INSERT INTO tvk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","E melele xa moletin xil te rute ak lapus kila xa be Iesu, lasa sepinien ba mikapis rute xil vus xa di sangas. Misak ni, moletin xil holu laleh ngenexil xa di lamesei lamei lapus Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","E ladakesi tengan imaen xil lituxol seri eising nan tang. E xil vus xa laduxoli, mesien nae be reling xil. ");
INSERT INTO tvk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Vatei, Farasi xil e titsa xil te rae na Mosis langgo Serusalem, lamei visal Iesu e lasisi labit, ");
INSERT INTO tvk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Veneh ma moletin nam xil latahusil xat ti sexien xil xa elda nar xil tetiamu latesa ni mi xir? Vengan moletin nam xil di latakas he xil ti mu vamese, ti, lavanien sung.” ");
INSERT INTO tvk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu bit rilomun ni mi xil bit, “?E veneh vari xamim di munggur xoteh rae xil na Hi tengan muhusil kuh pispisien namim xil tang? ");
INSERT INTO tvk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vengan Hi biteni bit, ‘Mumerere ni tamemim e ninemim xil.’ E biteni mun bit, ‘Xosxa moletin tei isuhol tamen mu ninen, ma lihasi imat.’ ");
INSERT INTO tvk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","E xamim di mupispisi mi moletin xil xa likila lihiteni mi tamexil e ninexil lihit, ‘Holesok xil navan xa nakila nitutou ni xamil ni, ngan xil ak nasikoe xole ngamu tengan nisa ni mi Hi kestang.’ ");
INSERT INTO tvk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nggo rin ak, di mupispisi mi moletin xil xa linamerere ti mun ni tamexil e ninexil natel holesok nae xil. Ma pispisien namim xil di pol ni sepinien xil na Hi mei be neta sav tang. ");
INSERT INTO tvk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Xamim mumese nggot hilbemim tang! Naha xa Hi tehit lelen ni usil xamim texo provet Aesea momal xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Moletin xil ak di lamerere ni nou del sepinien nae xil kestang, e tine di sotin ra nou. ");
INSERT INTO tvk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tave ti neta xa di lamot minou, inou nabit ninakil ti. Vengan xil di lasa pispisien xil xa be na moletin xil tang, e di labiteni xa inou iaxa ieok bei tengan lihusili.’” ");
INSERT INTO tvk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Di, Iesu biles e mikes vanut moletin xil lamei visali e biteni mi xil bit, “!Muteong kuhi tengan mukila! ");
INSERT INTO tvk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tave holesok xil ti xa moletin tei ngguri nggo vulongen be tinen iaxa di misak ni mei tamese ti pe met Hi. !E‑e, tamak ti! E sepinien xa mistal nggo vulongen iaxa mikila vasak ni moletin ak mei namese ti pe meten.” ");
INSERT INTO tvk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Melele xa Iesu be reling vanut moletin xil, moletin nan xil labiteni mini labit, “?Xouk okila xa Farasi xil tine tesoh melele xa latelong sepinien nam?” ");
INSERT INTO tvk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E Iesu bit rilomun ni mi xil bit, “Farasi xil ak langgoni vatiei xil xa Tata navan xa de ut nesao tenalih xil ti. E limei liput rat xil itel lite xil. ");
INSERT INTO tvk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mustokovein xil liti nga. Xil labe metevar, e di lasak pisi tengan ti litiamu ni metevar sav xil mun. E xosxa metevar tei di diamu ni metevar tei mun, ma xalu vus lalikiri lalihe vul tei.” ");
INSERT INTO tvk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E Pita biteni mini bit, “Hit kil koute te vole ak mi xamem li.” ");
INSERT INTO tvk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Di, Iesu misis xil bit, “?!Midep, xamim mutakil ti mu!? ");
INSERT INTO tvk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Mutakil ti xa holesok xil xa mungga ni nggo vulongomim ba be vangemim tang? Ma di, mistal be reling tiei namim, e ba be tisok tang. ");
INSERT INTO tvk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","E holesok xil xa di tinemim e musepin ni nggo vulongomim, xi vari iaxa di pol ni xamim mutamese ti pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vengan melele xa tine moletin tei misa, xi di pol ni hisit sexien tesa xil ak: minem usil holesok xil xa misa, bas vin moletin xil, mikan ni atou na mosav xil, di pat vituei del mosav melele xa lutateli ti mu, di mikan ni neta na mosav xil, di miluvos ni his mosav xil e kot, e di misep purun his mosav xil mun. ");
INSERT INTO tvk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sexien xil ak di lapol ni moletin xil latamese ti pe met Hi. E xosxa moletin tei takas hen ti mu vamese, ti, vanien sung, ngan ak misakras vapol ni xa moletin tei namese ti.” ");
INSERT INTO tvk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Di, Iesu be reling rute ak e ba be rute sav tei xa be sangas ni metimal xalu te hal Taer e Saedon. ");
INSERT INTO tvk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","E ate‑Kenan tei xa de rute ak bemei visal Iesu e dakesi bit, “!O suv li, xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae e nou li! Ninin tesa tei da xat atuli navan e di pangei tova tang.” ");
INSERT INTO tvk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","E Iesu tasa ti sepinien tova mini. Ma moletin nan xil lamei visal Iesu e labiteni mini labit, “Usil rat atou ak iha vengan di mikei nggeih bemei mi xir.” ");
INSERT INTO tvk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Misak ni, xi biles e biteni mi atou ak bit, “Hi misil nou tengan namei ve mol‑Isrel xil kestang xa langgoni sipsip xil san xa lakesae.” ");
INSERT INTO tvk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","E ate‑Kenan ak bemei e mitingeiril pe meten e dakesi nggeih bit, “!O suv! !Tutou ni nou li!” ");
INSERT INTO tvk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E xi bit rilomun ni mini bit, “Tamal ti xa namur anien ae e naso ni tang vaha mi kuli xil.” ");
INSERT INTO tvk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","E atou bit rilomun ni mini bit, “Suv, ngan ak be reitin. E kuli xil mun xa ladi xorelis von anien en lakila lava saxut anien xil xa suv nae di ngga lingi.” ");
INSERT INTO tvk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Di, Iesu biteni mini bit, “!Atou li, neketen nam mahulong tova tang! Naha xa di osis nou ni mei istal ihe reitin.” E vatei takes, atuli nan mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Melele xa Iesu be reling tan te hal Kenesaret, xi del moletin nan xil langgusil seri Oei Kaleli. Di, labe hu tei e ba ladotan ladi en. ");
INSERT INTO tvk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Di, vanut moletin xil holu lamei tengan lapus Iesu e laleh ngan nae xil xa lamesei: ngan xil xa lasakras lakakao, ngan xil xa mete bar, ngan xil xa le mikavui, ngan xil xa labe vut, e holu mun xa langgur hisit mesien savsav xil. Laling kekes ni xil pe met Iesu, e xi pol ni xil vus mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","E melele xa moletin xil lapus naha xa Iesu pol ni, latemanin pupu vengan xa ngan xil xa labe vut, di lasepin; ngan xil xa le xil mikavui, le mei momal; ngan xil xa lasakras lakakao, di lakakao; e ngan xil xa labe metevar, di laketeh. Melele xa lapusi mak, lapet rat his Hi na mol‑Isrel xil ven. ");
INSERT INTO tvk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Di, Iesu mikes viton moletin nan xil e biteni mi xil bit, “Ieok misae li e moletin xil ak vengan ladi visal xir melengien tol ngamu e anien ae tovuol. Ieok ti tave tengan nasil rerat xil latilomun lave tim sae xil melele xa mae dit nggat xil. Maxani, vexil namal e mete xil namaluxoluk e suse.” ");
INSERT INTO tvk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E moletin nan xil lasisi labit, “!Inggak be uruvuol! ?Rikamet anien e rute xave tengan rakila risa ni mi vanut moletin xil xa mahulong xiak?” ");
INSERT INTO tvk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","E Iesu misi xil bit, “?Beret vahis mungguri?” Labit rilomun ni mini labit, “Beret lu e he sav (7) tang e tutut meseo vahis.” ");
INSERT INTO tvk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma Iesu misemae mi vanut moletin xil tengan litotan e tan. ");
INSERT INTO tvk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Melele xa ladotan bus, Iesu nggur beret lu e he sav (7) e meseo vahis e misa memesien ba mi Hi ven. Di, bul papasi e misa ni mi moletin nan xil tengan ha liseti mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Moletin xil vus langganien e vange polu. E melele xa moletin xil na Iesu laba mun tengan laleh viton saxut anien xil, lase valeat lu e he sav (7) ba vuma … xil vus polu. ");
INSERT INTO tvk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tiramue xil xa langganien e melengien ak laduxoh taosen hat (4000). E atou xil del horamue nae xil latavuli xil ti. ");
INSERT INTO tvk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","E melele xa Iesu misil rerat vanut moletin xil ak labaha, xi del moletin nan xil labe bot e ba labe rute tei xa lakesi ni Makatan. ");
INSERT INTO tvk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Vatei, Farasi e Satusi xil lamei visal Iesu tengan lasak pisi. Ma lasisi tengan vapol ni neta tova xa eilep xa vapisen ni xa xi texo visal Hi reitin. ");
INSERT INTO tvk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E Iesu bit rilomun ni mi xil bit, “Melele xa eai minu, xamim mubiteni mubit, ‘?Mupusi? Tilang hat pili. Ngan ak pisen ni xa an ihos visuvong.’ ");
INSERT INTO tvk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E melele xa ut milan, mubiteni mubit, ‘Tilang hat pili. Ngan ak pisen ni xa an isa xosali.’ Xamim mupus kil naha xa di mistal e tilang hat, e musakras mupus kil naha xa eilep xa Hi di pol ni xosali. ");
INSERT INTO tvk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xamim moletin xil te xosali ak, mubit mupus ti neta tova xa eilep xa vapisen ni xa natexo visal Hi reitin. Di mubit mupusi vengan xa meulien namim mikavui e munggoni atou tei xa be na Hi, e di maen xi mi ngan tesav xil mun. E ninapol ni ti neta tova xa eilep tengan mupusi. Ti mupus neta tei takes xa ixoni ngan xa testal mi provet Siona tetiamu.” Di, Iesu biles e be reling xil. ");
INSERT INTO tvk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Di, Iesu del moletin nan xil langgur xoteh Oei Kaleli. E melele xa laduxoh rin, moletin nan xil lanem rilomun ni xa iexil bovorong ni beret ae. ");
INSERT INTO tvk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E melele xa laba, Iesu biteni mi xil bit, “Muketeh kuhi ve ‘is’ na Farasi e Satusi xil.” ");
INSERT INTO tvk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Melele xa lalong sepinien nan, lasep usili del xil mun tang labit, “Xi misepin mak mi xir vengan xa rataleh ti beret ar.” ");
INSERT INTO tvk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","E Iesu milong kil naha xa di lasep usili. Ma ba biteni mi xil bit, “!Neketen namim hokorong pupu! ?Veneh ma di musep usil beret xa ar tovuol? ");
INSERT INTO tvk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?!Mutakil ti mu!? ?Iemim bovorong ni ngamu xa natehangan tiramue xil latehe taosen lim (5000) tetel beret lim (5) tang? ?E valeat vahis polu ni rut anien xil xa muteleh viton ni? ");
INSERT INTO tvk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E munem usil melele xa natehangan moletin latehe taosen hat (4000) tetel beret lu e he sav (7) tang. ?E valeat vahis polu ni rut anien xil xa muteleh viton ni? ");
INSERT INTO tvk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Ma veneh ma mutakil ti mu xa inou natasep usil beret ti? E muketeh kuhi ve ‘is’ na Farasi e Satusi xil.” ");
INSERT INTO tvk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma xil lanem kila sung xa xi taviteni ti tengan liketeh kuhi ve is te beret, e ve pispisien xil na Farasi e Satusi xil. ");
INSERT INTO tvk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu e moletin nan xil lakakao laba, laduxoh rute tei sangas ni taon te hal Seseria‑Filipae. E inggak, xi misis moletin nan xil bit, “?Moletin xil labiteni xa inou, Nat Moletin, nabe visi vari?” ");
INSERT INTO tvk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","E labit rilomun ni mini labit, “Rut moletin xil labit obe Sion Baptis. E rute ngan xil labit obe provet Ilaetsa. E rute sav xil mun labit xouk obe provet Seremaea tetiamu mu provet sav tei.” ");
INSERT INTO tvk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E xi misis xil bit, “?E xamim, ma midep? ?Mubit inou nabe visi vari?” ");
INSERT INTO tvk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","E Saemon Pita mitamea bit, “Xouk obe Mesaea. Reitin, obe Nat Hi xa meul da.” ");
INSERT INTO tvk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","E Iesu biteni mini bit, “Saemon, nat Siona, tuxolxatien na Hi di minuk ngamu. Vengan xa tave moletin ti xa vahit rat ngan ak minuk. Tata navan xa de ut nesao, xi vari bit rati minuk. ");
INSERT INTO tvk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","E nabiteni minuk xa obe ‘Pita’ xa koute teni be ‘vatihat.’ E vatihat ak, nikili ni Sias navan. E xeihen xil vus na Temat e maten lasakras mei lapurun ni. ");
INSERT INTO tvk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nisak ni xouk mei uhe vat na moletin navan xil. Ve rin ak, naha xa uhit xole e ut etan ak, Hi mun ihit xole. E naha xa umaen ni e ut etan, Hi mun imaen ni.” ");
INSERT INTO tvk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Di, Iesu misep xol moletin nan xil tengan linavit rati ti mi moletin tova xa xi be Mesaea xa Hi tehit xati tengan imei. ");
INSERT INTO tvk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","E melele nen ak ba, Iesu misep kila mi moletin nan xil xa ihe Serusalem. E melele xa ituxoh Serusalem, xi ihur longpangasien ihe holu ixo he elda xil, vat xil na pris xil, e titsa xil te rae na Mosis. Xi bit mesen ni xa xil lihas vini. Ti, e melengien tol nen, imea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Melele xa Iesu biteni mak, Pita dela be rin, e misepin nggeih xati bit, “!Suv, onasepin ti namak! !Holesok xil ak misakras vastal minuk!” ");
INSERT INTO tvk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","E Iesu biles, pus Pita e biteni mini bit, “!Temat, he reling nou! Nenemien ak be neta tei xa di misak pisi tengan ipol ni nou nisavut e suse navan. Vengan xouk di onggusil xat nenemien na moletin xil te ut etan, e otahusil nenemien na Hi ti.” ");
INSERT INTO tvk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Di, Iesu biteni mi moletin nan xil bit, “Xosxa moletin tova ien bei tengan ihusil nou, ma istokovein holesok xil te meulien nan, ti, ipo eivave te maten nan e ihusil xat nou. ");
INSERT INTO tvk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vengan xa ngan xil xa di lasak pisi tengan likenin meulien nae ve xil tang, ma meulien nae ikesae reling xil. E ngan xil xa lamaen meulien nae ikesae vengan di langgusil xat nou, ma, e ut nesao, xil likamet meulien sal. ");
INSERT INTO tvk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","?Naha tova bos mi moletin xa di mileh holesok xil vus te ut etan ak, e di misa rat meulien nan tengan valehi? !Neta tovuol vari! Vengan xi misakras vasa neta tova tengan vahur rilomun ni meulien nan. ");
INSERT INTO tvk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Nave nousav ti, inou, Nat Moletin, nitilomun itel xeihen xa tellep xa Tata navan isa ni minou e itel masxaxa nan xil. E melele nen ak, nisa kekes ni huit polien mi moletin xil vus ihusil naha xa xil di latepol ni. ");
INSERT INTO tvk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Reitin nabiteni mi xamim, rut xamim xa di lasoh del nou xosali, linamat ti mu e lipus melele xa inou, Nat Moletin, nimei tengan mei nihe suv toto na moletin xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Melele xa melengien tei e he sav (6) mei mitavi, Iesu nggur Pita, Temis del Sion (xa be tua na Temis) e del xatel latobe nesao e vathu tei tengan xatel ak kestang latiti vituei en. ");
INSERT INTO tvk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","E inggak, latopus tenbe Iesu biles. Valnaon mihinehin nggoni eai, e eising nan xil mei mieh pupu e mihinehin nggoni laet. ");
INSERT INTO tvk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vatei takes, latpus Mosis e Ilaetsa lustal e ba lusepin del Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Melele xa Pita pus xalu, biteni mi Iesu bit, “!Suv, bos xa xametel matodi inggak! Xosxa iem bei, ma matikili ni horao ihe tol: tei ihe mam, tei ihe ma Mosis, e tei ihe ma Ilaetsa.” ");
INSERT INTO tvk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Melele xa di tamu misepin, momah tei xa mihinehin pupu mei mikutaxol xatel. E latlong rae tei mistal nggo en xa bit, “Ngan ak be Natuxoli reitin xa eheien navan di en. Inou nabesi nou pupu ven. !Muteong xati!” ");
INSERT INTO tvk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Melele xa Pita xatel latlong rae ak, uli xatel mikan pupu, e latomot latobe tan. ");
INSERT INTO tvk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Melele xa ladi tamu e tan, Iesu bemei e duxol xatel bit, “Totamea. Ulimitel nakan ti mun.” ");
INSERT INTO tvk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E melele xa latpet rat metexatel, lattapus ti mun moletin xalu ak, Iesu kestang de visal xatel. ");
INSERT INTO tvk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Melele xa di latsuvul ra vathu ak, Iesu misep xol xatel bit, “Mutnahiteni ti mi moletin tova usil naha xa mutepusi ituxoh melele xa inou, Nat Moletin, nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","E moletin nan xatel latsisi latbit, “?Veneh ma titsa xil te rae na Mosis labiteni xa Ilaetsa imei itiamu ni Mesaea xa Hi tehit xati?” ");
INSERT INTO tvk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E Iesu bit rilomun ni bit, “Reitin xa Ilaetsa imei tengan ipol ni holesok xil vus mei imal rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","E nabiteni mi xamitel xa Ilaetsa temei ngamu e moletin xil latnapus kil ti. Xil latepol tesa mini texoni ngan xa iexil tehei. E ixo suse nen tak, nave nousav ti, inou mun, Nat Moletin, nihur longpangasien ixo hexil.” ");
INSERT INTO tvk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Melele xa Iesu biteni mak, ma latlong kila sung xa xi di bit usil Sion Baptis. ");
INSERT INTO tvk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Melele xa Iesu xatel latsuvul ra vathu ak, latbisu mi vanut moletin xil. E moletin tei bemei visal Iesu, mitingeiril pe meten, ");
INSERT INTO tvk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","e biteni mini bit, “O suv, iem isae li e natuxoli, vengan xa xi di memat e milong pangas xi pupu ven. Melengien holu, xi di mot be upang mu oei. ");
INSERT INTO tvk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Natehuri temei visal moletin nam xil, e xil lasakras lapol ni mei vahos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Melele xa Iesu milonge mak, biteni bit, “!Iva! !Xamim moletin xil te xosali ak, mukavui e neketen namim tovuol vari! ?Niti visal xamim ituxoh vilieh? Veok buol ni xamim xa neketen namim tovuol. Muhur horamue ak vamei visal nou inggak.” ");
INSERT INTO tvk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E melele xa Iesu pus horamue ak, minggol rat ninin tesa be relingi, e vatei takes, horamue ak mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Dutou ni melele nen ak, melele xa Iesu ba da sen tang, moletin nan xil lamei visali e lasisi labit, “?Veneh ma xamem matesakras mavol rerat ninin tesa ak?” ");
INSERT INTO tvk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E Iesu bit rilomun ni mi xil bit, “Vengan xa neketen namim hokorong pupu. Reitin nabiteni mi xamim, xosxa munggur neketen xa hokorong nggoni utut mastad, mukila muviteni mi vathu ak muvit, ‘Umea ra rute ak, e uha xor,’ ma iha xor. Xosxa neketen namim di, ma neta tovuol vaxeih tengan mupol ni.” ");
INSERT INTO tvk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Di, lamea reling rute ak e lakakao labe provins te hal Kaleli. E melele xa di lakakao laba, Iesu biteni mi xil bit, “Nave nousav ti, inou, Nat Moletin, limaen ni nou ihe he moletin xil te ut etan. ");
INSERT INTO tvk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xil lihas vin nou. E, e melengien tol nen, nimea rilomun ra maten.” Melele xa moletin nan xil lalonge mak, lanexo pupu. ");
INSERT INTO tvk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Vatei, Iesu del moletin nan xil di lakakao e lamei e taon te hal Kapaniam. Inggak, moletin xil xa laleh mani te takis te Nim Eo lamei visal Pita e lasisi labit, “?Midep? ?Titsa nam di nggal takis te Nim Eo, mu taxali ti?” ");
INSERT INTO tvk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E Pita bit rilomun ni mi xil bit, “Io, xi di nggale.” Di, Pita dilomun be tim. Xi tasepin ti mu, e Iesu misis bit, “?Saemon Pita, onemi midep? ?Suv toto xil te ut etan di laleh takis e duti ra moletin si xil? ?Lalehi ra horamue nae xati, mu ra moletin sav xil tang?” ");
INSERT INTO tvk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","E Pita bit rilomun ni mini bit, “Lalehi ra moletin sav xil.” Iesu biteni mini bit, “Imak, ma horamue nae xati xil linaxal ti takis. ");
INSERT INTO tvk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","E tave ti neta xa Hi xa be suv toto te holesok xil vus be Tata naralu, ralixal takis te Nim Eo nan vengan xa tavos ti xa ralosak ni moletin xil ak tine vasoh xat ralu. Ma ha, uhe Oei Kaleli e uso huk. Meseo xa usare itiamu, usah vulongen, e ukamet mani tei xa ipin tengan uxal rat takis naralu ni. Ti, uhuri e ha usa ni mi moletin xil ak.” ");
INSERT INTO tvk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E melele nen ak, moletin xil na Iesu lamei visali e lasisi labit, “?Visi iaxa be eilep mak mu e ngan xil xa Hi be suv toto nae?” ");
INSERT INTO tvk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu mikes tutut horamue tei e pol ni mei misoh pe metexil. ");
INSERT INTO tvk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Di, biteni mi xil bit, “Reitin li nabiteni mi xamim, xosxa munaviles nenemien namim ti tengan mei muxoni horamue ak, ma musakras muve rute xa Hi be suv toto en. ");
INSERT INTO tvk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Misak ni, ngan xil xa lapol ni nenemien nae be tan nggoni horamue ak, xil lihe eilep mak mu e rute xa Hi be suv toto en. ");
INSERT INTO tvk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","E moletin tei xa nggur pilei horamue tei nggoni ngan ak e hisok, ma nggoni ngan xa di nggur pilei nou. ");
INSERT INTO tvk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“E xosxa moletin tova isak ni moletin tei xa nggusil xat nou nggoni horamue ak tengan imot e tesaen, ma Hi isa pangasien xa isa mak mu mini. Bos mak mu xosxa lavar xat hat tova xa mahulong pupu vate huraen, e laso ni ha vamerir e huinep te tas. ");
INSERT INTO tvk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Reitin xa holesok xil xa di lasak pis moletin tei tengan vamot e tesaen di bemei. !E isa mak mu mi ngan xil xa labe suse te tesaen xil ak! ");
INSERT INTO tvk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“!Nggusil nenemien ak, xosxa hem mu lem misak ni xouk di omot e tesaen, ma uta xotehi e uso ni iha! Ihos mak mu xa rut tenbom tang isa e uhur meulien sal, ili ngan xa hem xalu e lem xalu lihos tang laliti e liso xouk uhe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Xosxa metom tei misak ni xouk di omot e tesaen, ukis rati e uso ni iha. Ihos mak mu xa metom tei ikesae e uhur meulien sal, ili ngan xa metom xalu vus laliti tang e liso xouk uhe Upang xa misakras vamat.” ");
INSERT INTO tvk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Melele xa horamue ak di tamu misomal pe metexil, Iesu biteni mi moletin nan xil bit, “Muxuxou kuhi tengan munanem male ni moletin xil ti xa di langgusil xat nou nggoni horamue ak. Reitin li nabiteni mi xamim xa masxaxa nae xil ladit pe met Tata navan e ut nesao. E xil lihit mesen ni xosxa moletin tei di pangei xil. ");
INSERT INTO tvk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“?Xamim munemi midep? ?Xosxa moletin tei, sipsip san xil duxoh handred tei (100) e tei e xil mikesae, ma xi ipol ni itep? ?Munemi mubit xi ihe reling sipsip sav san xil xa labe hanutap hat e hat e le tei mun (99) liti e seri hu tei tengan ha ilang ves ngan xa mikesae? !Io! ");
INSERT INTO tvk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E reitin li nabiteni mi xamim xa, xosxa ikameti, ma ihesi xi pupu ven, ili sipsip sav san xil xa latakesae ti. ");
INSERT INTO tvk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nggusil rin ak, Tamemim xa de ut nesao ien ti tavei tengan moletin ti xa di nggusil xat nou nggoni horamue ak vakesae.” ");
INSERT INTO tvk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu dit ni ngan taxa di misepin mi moletin nan xil usil ngan xil xa di lapol misa mi mosav xil bit, “Xosxa tumali tei pol misa minuk, xouk tasom uhe visali e upisen naha xa xi tepol ni xa tenamal ti minuk. Xosxa iteong kuhi ni xouk e mulimal ni xamil, ma uhesi xouk vengan muliti ihos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","E xosxa xi nateong ni sepinien nam ti, utilomun uhe visali itel moletin sav tei mu lu mun. Xalu mun lalipusi e lalisepin mini e rin nam xa be reitin xa otesak pisi tengan umal ni xamil. ");
INSERT INTO tvk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E xosxa tumali ien ti tavei tengan vateong ni xamitel, ma ha mutihit mesen ni pe met vanut moletin xil te Sias na Hi. E xosxa moletin ak ien ti tavei tengan vateong ni ngan xil te Sias mun, ma mupusi ixoni ngan taxa xi takil ti Hi mu be moletin tesa tei nggoni ngan xil xa di laleh takis. ");
INSERT INTO tvk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Reitin li nabiteni mi xamim, naha xa xamim di musep xole e ut etan, ixoni ngan xa Hi mun xa de ut nesao di misep xole. E naha xa di mumaen ni e ut etan, ma ixoni ngan xa Hi mun xa de ut nesao di maen ni. ");
INSERT INTO tvk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Reitin li nabiteni mi xamim xa xosxa xamil lu xa mudi e ut etan ak mulimei e nenemien tei usil neta ngan e mulisis ven, ma Tata navan xa de ut nesao isa huit sisen namil. ");
INSERT INTO tvk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vengan xa melele xa moletin lu mu tol latomei vituei e hisok, inou mun nite visal xatel e rute ak.” ");
INSERT INTO tvk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Di, Pita bemei visal Iesu e misisi bit, “?Suv, xosxa tua navan pol misa minou, niketeh ihos rilomun mini ihe vahis? ?Ituxoh lu e he sav (7)?” ");
INSERT INTO tvk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu bit rilomun ni mini bit, “E‑e, tave lu e he sav (7) ti. Uketeh ihos rilomun mini ihe valu e he sav (7), ti, upol ni ihe valu e he sav (7) mun, ti, upol ni ihe valu e he sav mun (7) ha vuma … osakras ovuli mun. ");
INSERT INTO tvk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nihit kil sexien ak ni vole tei. Melele xa Hi mei ihe suv toto e meulien na moletin xil, ngan ak ixoni suv toto tei xa ien bei tengan imal ni kaon xa moletin te polien nan xil latepol ni tetela. ");
INSERT INTO tvk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","E melele xa xi di momal ni kaon xil ak, ladel moletin tei xa kaon nan mili gol mani xa be milian he xalu (10,000,000). ");
INSERT INTO tvk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","E vengan xa suse tovuol tengan moletin ak vaxal rat kaon nan, suv toto nan misemae ni tengan lipos ni xi, atou nan, e horamue nalu xil vus mei lihe slev xil, e lipos ni holesok xil vus nan mun. Ixo suse ak, suv toto bit mani nen mei ixal rat kaon xil vus nan. ");
INSERT INTO tvk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Melele xa moletin ak milonge mak, mitingeiril pe met suv toto e dakesi bit, ‘!Aue li! !Usa mesal tova mun xa hokorong minou li, e nixal rat holesok xil vus xa di kaon navan!’ ");
INSERT INTO tvk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Melele xa suv toto ak milonge mak, ien misae en. Ma misil len kaon nan e maen ni ba ven mase. ");
INSERT INTO tvk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“E melele xa moletin ak mistal, mikamet moletin te polien sav tei xa kaon nan dela be gol mani vahis tang. E melele xa pusi, miki xat huraen e biteni mini bit, ‘!Uxal rat mani xil vus xa otehuri ranou!’ ");
INSERT INTO tvk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“E moletin te polien ak mitingeiril pe meten e dakesi bit, ‘!Aue li! !Usa mesal tova mun xa hokorong minou li, e nixal rat holesok xil vus xa di kaon navan!’ ");
INSERT INTO tvk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“E moletin ak ien ti tavei vasa mesal mini. E ba sung, miso moletin ak be nim te xeih tengan ita en ituxoh melele xa ixal rat kaon nan xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","E melele xa moletin te polien sav xil lapus naha xa testal, xil lalonge misa pupu e ba labit mesen ni mi suv toto nae. ");
INSERT INTO tvk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Di, suv toto mikes moletin ak bemei visali e misepin nggeih mini bit, ‘!Xouk xa obe moletin tei navan di opol misa xa misa! Melele xa otetakes nou tengan ieok isae e xouk, ma natesil len kaon nam e natemaen xouk ba vem temase. ");
INSERT INTO tvk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Misak ni, veneh ma xouk iem tasae ti moletin te polien sav navan vaxoni ngan xa inou natepol ni minuk?’ ");
INSERT INTO tvk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Suv toto ien mikat, ma misa rat moletin nan ak ba tengan ihur pangasien ixo he moletin xil e nim te xeih ituxoh melele xa ixal rat kaon nan xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“E Tata navan xa de ut nesao mun ipol ni imak tang mi xamim vus xosxa munaketeh ti navos rilomun mi tua namim xil ixo tinemim tevi.” ");
INSERT INTO tvk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Melele xa Iesu misepin usil rin xil ak bus, xi be reling provins te hal Kaleli del moletin nan xil. Ma xil labe rute tei xa mili Oeisal Sodan e provins te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Vanut moletin xil holu langgusili labe rute ak, e xi pol ni xil vus mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E melele nen ak, rut Farasi xil lamei visali tengan ti lisak pisi. Misak ni, lasisi labit, “Uhit pisi mi xamem. ?Rae nar xil di maen ni tengan moletin tei ikila istokovein atou nan ve nenemien xil vus tang?” ");
INSERT INTO tvk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","E Iesu bit rilomun ni mi xil bit, “?Midep? ?Xamim mutavuli ti Vanuvei Eo na Hi? Vengan xi di biteni xa, tetiamu, e melele xa Hi tepol ni holesok xil e ut etan, ‘Hi pol ni moletin, tei pol ni be malohos, e tei mun, pol ni be atou.’ ");
INSERT INTO tvk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E biteni mun bit, ‘Ve rin ak, tiramue imea reling tamen xal ninen, e ihisti itel atou nan, e xalu mei lalihe tei takes.’ ");
INSERT INTO tvk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Misak ni xalu lutave lu ti mu, e mei lube tei takes. Ma naha xa Hi tehistin ni, moletin tovuol mikila vaseti xalu mun.” ");
INSERT INTO tvk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E Farasi xil lasisi labit, “Vahit vamak, veneh ma Mosis ma tesemae ni xir tehit, ‘Moletin xa bit vastokovein atou nan, isa Setifiket te Silaen mini. Ti, mikila istokovein ni sung.’” ");
INSERT INTO tvk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","E Iesu bit rilomun ni bit, “Mosis temaen xamim tengan mustokovein atou namim xil vengan xa vatumim nggeih pupu. E sexien ak tovuol e melele xa Hi tepol kokot ni holesok xil. ");
INSERT INTO tvk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E nabiteni mi xamim xa xosxa moletin tei mistokovein atou nan e melele xa atou ak tapol ni ti vasa vatel tiramue sav, xi di pol ni neta xa misa pe met Hi. E xosxa, moletin ak mea e miteli rilomun del atou sav, pe met Hi, nggoni ngan xa xi di pol misa del atou ak.” ");
INSERT INTO tvk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Melele xa misepin mi xil bus, moletin nan xil mei labiteni mini labit, “Vahit vamak mi tiramue del atou nan, ma bos mak mu tengan tiramue tei ita tasen tang e nateli ti.” ");
INSERT INTO tvk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","E Iesu bit rilomun ni mi xil bit, “Tave moletin xil vus ti iaxa lakila lavusil pispisien ak. E rut moletin ngan xil, Hi di misa xeihen mi xil tengan lihusili. ");
INSERT INTO tvk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vengan rut moletin xil lasakras lateli vengan ut eo nae misa melele xa latepes xil. E ngan tesav xil lasakras lateli vengan xa moletin sav tepangei ut eo nae. E rute moletin sav xil mun lapol ni nenemien nae xa linateli ti tengan lipol mi Hi xa be suv toto nae. Ngan xil xa lakila lavusil sexien ak, ma bos tengan lihusili.” ");
INSERT INTO tvk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Di, moletin xil laleh tutut horamue nae xil lamei visal Iesu tengan xi valing hen e xil e vatuxol xat xil. E melele xa moletin nan xil lapus xil, labul xat xil. ");
INSERT INTO tvk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","E Iesu misepin mi xil bit, “Mumaen tutut horamue xil ak lamei visal nou, e munasikoe xol xil ti. Vengan xa Hi be suv toto na hisit moletin xil mun xa langgoni xil.” ");
INSERT INTO tvk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma melele xa lamei visali, Iesu miling hen e xil e misa tuxolxatien mi xil. Di, Iesu del moletin nan xil labe reling rute ak. ");
INSERT INTO tvk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Melele xa Iesu nggusil suse ba, moletin tei bemei visali e misisi bit, “?Titsa, nipol ni naha xa bos tengan nikila nihur meulien sal?” ");
INSERT INTO tvk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu bit rilomun ni mini bit, “?Veneh ma di osis nou usil naha xa bos? Hi kestang bos. E xosxa iem bei ovur meulien sal, ma uteong xat rae nan xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Di, moletin ak misisi bit, “?E rae xave vari e xil tengan nihusili?” E Iesu bit rilomun ni mini bit, “‘Munahas vin ti moletin. Munakan ni atou mu tiramue na mosav ti. Munakan ni ti neta na mosav xil. Munaluvos ni his mosav xil ti. ");
INSERT INTO tvk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mumerere ni tamemim e ninemim xil.’ E, ‘Iemim ihei moletin sav xil ixoni ngan taxa xamim vus di iemim bei xamim mun tang.’” ");
INSERT INTO tvk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","E tiram maxoe ak bit rilomun ni mi Iesu bit, “Inou di nanggusil xat rae xil vus ak. ?Naha mun iaxa natapol ni ti?” ");
INSERT INTO tvk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Iesu biteni mini bit, “Xosxa xouk iem bei tengan mei omal tevi, ma ha upos ni holesok xil vus nam e usa mani nen mi ngan xil xa holesok nae tovuol. E xosxa upol ni imak, ma holesok nam xil e ut nesao ihe holu. Ti, utilomun e uhusil xat nou.” ");
INSERT INTO tvk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","E melele xa tiram maxoe ak milong sepinien nan, xi milonge misa e be relingi vengan xa holesok nan xil labe holu e ien ti tave tengan vastokovein ni. ");
INSERT INTO tvk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Di, Iesu biteni mi moletin nan xil bit, “Reitin li nabiteni mi xamim, nggeih tova tang tengan moletin xa holesok nan holu vamaen Hi mei vahe suv toto e meulien nan. ");
INSERT INTO tvk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","?Munemi xa kamel tei xa be mahulong mikila vakital vaxo met nitil tei xa hokorong xa hokorong pupu? E‑e, misakras. E moletin tei xa holesok nan xil holu, nggeih mak mu mili ngan ak tengan imaen Hi mei ihe suv toto e meulien nan.” ");
INSERT INTO tvk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Melele xa moletin xil na Iesu lalonge mak, latemanin pupu e lasisi labit, “?Imak, ma Hi mikila vateh meulien e visi vari?” ");
INSERT INTO tvk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu miketeh kapis e xil e bit, “!Iaxai vari! Moletin misakras vapol ni, e Hi kestang mikila ipol ni holesok xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Di, Pita biteni mini bit, “?Opusi? Xamem mastokovein holesok xil vus namem tengan mavusiluk. ?Xos imak, ma Hi isa naha mi xamem?” ");
INSERT INTO tvk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E Iesu biteni mi xil bit, “Reitin li nabiteni mi xamim, e melele xa Hi ipol pilei ni holesok xil vus te ut etan mei ihe neta hu, inou, Nat Moletin, nitotan e von lelaxatien navan itel minehinen te xeihen navan. E melele nen ak, xamim kekes mun ti mutotan itel nou e von xeihen namim xa ihe lu e le tei (12). Ti, mulepis mol‑Isrel xil vus xa langgo vatimol lu e le tei (12) xa mahulong nae. ");
INSERT INTO tvk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E moletin xil vus xa di lastokovein tim sae, mu tua nae xil, mu hinexil, mu tamexil, mu ninexil, mu horamue nae xil, mu naho sae xil venou, ma Hi isa rilomun ni mi xil huite teni xa ihe handred tei (100) ili ngan xa latestokovein ni. E xil lihur meulien sal mun. ");
INSERT INTO tvk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E moletin holu xa labe eilep xil xosali ak, xil mei lihe neta sav tang. E holu xa labe movotei xil xosali, xil mei lihe eilep xil sung.” ");
INSERT INTO tvk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Melele xa Iesu di misepin del moletin nan xil, xi dei vole ak mi xil bit, “Suse xa Hi mei ihe suv toto e meulien na moletin xil ixoni hortan tei xa ba makoe roroh tamu tengan valeh viton moletin te polien xil tengan mei lapol e urvatiei san. ");
INSERT INTO tvk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Melele xa ba misepin mi xil, xil lamaen ni tengan lipol mini ve mani tei xa imal te melengien tei. Di, misil xil laba tengan lava lapol e urvatiei san. ");
INSERT INTO tvk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Melele xa meteneai bemei nesao vuteili, hortan ak dilomun ba, e pus moletin sav xil xa dit laborang votei tang e von posen, e latapol ni ti neta. ");
INSERT INTO tvk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma xi biteni mi xil bit, ‘Ei, xamim mun ha mupol e urvatiei savan, e nixal xamim ni naha xa imal.’ ");
INSERT INTO tvk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma xil mun laba lapol. “E piniae, xi dilomun ba, e pol ni nggoni ngan taxa tepol ni ngamu. Di, ba pol ni mun e melele xa meteneai da be tan vuteili. ");
INSERT INTO tvk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","E melele xa meteneai ba sangas tengan vanu, xi dilomun ba e pus rut moletin xil mun dit lasoh votei tang. Ma xi misis xil bit, ‘?Veneh ma di musoh votei mak, e mutapol ni ti neta e makoe mei duxoh mahis xiak?’ ");
INSERT INTO tvk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma xil labit rilomun ni mini labit, ‘Vengan moletin ti tamei tengan valeh xamem mava mapol mini.’ “Ma hortan ak biteni mi xil bit, ‘Xamim mun muha mupol e urvatiei savan.’ ");
INSERT INTO tvk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Melele xa meteneai ba minu, hortan te urvatiei ak ba biteni mi vat na moletin te polien xil bit, ‘Ukes viton moletin xil te polien limei, e usa huit polien nae mi xil. Itiamu, usa ni mi ngan xil xa lamei dutou iha vuma … ituxoh ngan xil xa latemei tetiamu.’ ");
INSERT INTO tvk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ma, ngan xil xa lamei e melele xa meteneai ba sangas tengan vanu, vat te polien misa huit polien nae momal ni ngan te melengien tevi tei. ");
INSERT INTO tvk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Misak ni, melele xa ngan xil xa latemei tetiamu lapusi mak, xil di lanemi labit xil lihuri ihe eilep mak mu. E melele xa lamei, xil mun langgur huit polien nae momal ni ngan te melengien tevi tei tang. ");
INSERT INTO tvk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","E melele xa langguri, xil laseputut ba xat hortan ak ");
INSERT INTO tvk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","labit, ‘Ngan xil xa lamei dutou tang, e melele xa meteneai ba sangas tengan vanu, xil lapol haoa tei takes, e onggal xil nggoni xamem tang xa makon ni polien, mapo vetin, e eai ngga pangas tenbemem.’ ");
INSERT INTO tvk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“E hortan ak bit rilomun ni mi xil bit, ‘Tua navan xil, inou natapol ti vasa mi xamim. Xamim mumaen ni tengan mupol minou ve huit polien xa momal te melengien tevi tei. ");
INSERT INTO tvk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma muleh mani namim muha. Inou ieok bei tengan nixal ngan xil xa latemei tetutou ipin ni ngan taxa xamim mungguri. ");
INSERT INTO tvk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngan ak be mani navan, e nikila nipol ni ixoni ngan xa ieok bei ni. ?Mu midep? ?Xamim di munem misa ni xil vengan di nasa tutouen mi xil?’ ");
INSERT INTO tvk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ma, usil sexien xil ak vari, moletin holu xa labe movotei xil tang xosali ak, xil mei lihe eilep xil. E holu e ngan xil xa labe eilep xil xosali ak, xil mei lihe neta sav tang.” ");
INSERT INTO tvk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Melele xa Iesu di mikakao ba tengan vahe Serusalem, xi mileh moletin nan xil xa labe lu e le tei (12) ba laka se xil vuteili e biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“?Mupusi? Taxeak di raba ve Serusalem xiak. E rute ak, xil limaen nou, Nat Moletin, ha nihe he vat xil na pris xil e titsa xil te rae na Mosis. Ivus ti, xil lihur nou nihe kot e limaen rat meulien navan tengan ha nimat. ");
INSERT INTO tvk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ti, lisa rat nou ha nihe he moletin xil xa latave Siu ti, e xil lipol pepamen ni nou, limeas pangas nou ni ao te xeih xil xa sanute di en, e liti xat nou e eivave. E melele xa melengien tol mei itavi, inou nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Di, nine Temis xal Sion, nat Sepeti xalu, del xalu latomei tengan latopus Iesu. Xi mitingeiril pe meten tengan vasis neta tova mini. ");
INSERT INTO tvk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu misisi bit, “?Atou li, iem bei neh?” Ma xi bit rilomun ni mini bit, “Ieok bei li tengan umaen horamue navan xalu ak ha lalitotan sangas visaluk e melele xa mei uhe suv toto. Tei ite rim metu, e tei ite rim meil.” ");
INSERT INTO tvk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Iesu biles miketeh pus natneli xalu e misis xalu bit, “Xamil mutakil ti naha xa di musis nou ni. ?Midep? ?Xamil mukila tamak mulihur sakpurunien xil e pangasien xil ixoni ngan taxa inou ha nihuri?” E lubit rilomun ni mini lubit, “!Io, makila!” ");
INSERT INTO tvk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Di, Iesu biteni mi xalu bit, “Reitin, xamil mulihur sakpurunien xil e pangasien xil ixoni ngan xa inou nihuri. E tave ti neta xa imak, nave nou ti iaxa nihosei visi tengan mei itotan e riuk metu mu e riuk meil. Vontoen xalu ak xa tellep xiak be na ngan xalu xa Tata navan bosei xalu ngamu tengan lalihuri.” ");
INSERT INTO tvk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","E melele xa moletin sav xil na Iesu xa labe he xalu (10) lalongeong usili, iexil nggat xalu. ");
INSERT INTO tvk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma Iesu mikes viton xil vus lamei visali e biteni mi xil bit, “Mukila xa vat na moletin xil xa latave Siu ti iexil bei mak mu tengan lisak ni moletin nae xil lipus kila xa xil mak mu labe tellep lali xil. E suv nae xil mun di lapol ni nggeih mi ngan xil xa ladi pe hexil. ");
INSERT INTO tvk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","E xamim, sexien namim namak ti. Xosxa tei e xamim ihit mei ihe eilep mak mu ili xamim, xi mei ipol mi xamim ixoni moletin te polien tei namim. ");
INSERT INTO tvk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E xosxa tei e xamim ien bei tengan vatiamu ni xamim, xi mei ihe moletin te tutouen namim ixoni slev tei. ");
INSERT INTO tvk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Vengan inou mun xa nabe Nat Moletin, natamei ti tengan moletin xil ti latutou ni nou. !E‑e! Inou namei tengan nitutou ni mosav xil e nisa meulien navan tengan nixal rat moletin xil holu mei limeluv ra xeihen te tesaen.” ");
INSERT INTO tvk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu del moletin nan xil ba laka pas taon te hal Seriko. E melele xa di laba, vanut moletin tei xa eilep di langgusili. ");
INSERT INTO tvk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E rute ak, moletin lu xa metealu bar ludotan ludi seri suse e lulonge xa Iesu mikakao mei mitavi ba. Ma xalu lukei ba ni lubit, “!Suv! !Xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae li e xamel!” ");
INSERT INTO tvk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","E vanut moletin xil ak labul xat xalu tengan lalotit votei. E tave ti neta xa mak, xalu lukei nggeih pilei sung lubit, “!Suv! !Xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae li e xamel!” ");
INSERT INTO tvk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Melele xa Iesu milonge, misoh e mikes xalu tengan lalomei visali. Di, misis xalu bit, “?Iemil bei tengan napol ni naha mi xamil?” ");
INSERT INTO tvk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma xalu lubit rilomun ni mini lubit, “Suv li, iemel bei tengan upol ni metemel ihos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E melele xa Iesu pus xalu, ien polu ni esaeen ve xalu. Ma misasa duxol metealu, e vatei takes, xalu vus luketeh rilomun e lunggusil Iesu luba. ");
INSERT INTO tvk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Melele xa Iesu del moletin nan xil lamei sangas ni Serusalem, xil mei lastal e metimal te hal Betfas xa de sangas ni Vathu te Urvatiei te Olip. E rute ak, Iesu misil moletin nan lu ");
INSERT INTO tvk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","del sepinien ak bit, “Mulihe metimal xa da iaxor. E melele xa ha mulistal en, mulikamet dongki tei xa labar xati del tuten. Mullal rat xalu e mulitel xalu lalimei visal nou. ");
INSERT INTO tvk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","E xosxa moletin tei isak pisi tengan vasikoe xol xamil, mulhiteni mini mulihit, ‘Suv iaxa ien bei xalu,’ ma vatei takes, xi imaen xalu mi xamil.” ");
INSERT INTO tvk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngan ak testal tengan vasak ni naha xa Hi tehit lelen ni texo provet nan mei ihe reitin xa tehit, ");
INSERT INTO tvk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Uhiteni mi moletin xil xa ladi e taon te hal Serusalem uhit, ‘!Mupus ti! Suv toto namim bemei tengan valaxat xamim. Xi be hanmerou tang e di miloh nggo dongki tei tang di bemei. Reitin, xi dotan de sulut dongki tei tang e di bemei.’” ");
INSERT INTO tvk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma moletin na Iesu xalu ak luba e lupol ni nggoni ngan taxa xi tehiteni mi xalu. ");
INSERT INTO tvk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xalu ludel dongki ak del tuten latomei. Di, luden kot nalu da xol tei xalu e Iesu dotan en. ");
INSERT INTO tvk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Vanut moletin xil xa mahulong mei lasak mesen suse tengan Iesu mei iloh ixo en. Laden kot nae xil e suse nan, e rute ngan xil ladei anguit liei xil xa ute di en e laling kuhi di suse. ");
INSERT INTO tvk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Holu e vanut moletin xil ak xa di ladiamu ni Iesu del ngan xil xa di langgusili ladutou di lakei nggeih labit, “!Ripet rat xi xa mistal nggo vatimol na suv toto Deved! ‘!Tuxolxatien iti mi ngan xa di bemei e his Iahova!’ !Ripet rat his Hi xa de ut nesao!” ");
INSERT INTO tvk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","E melele xa Iesu ba duxoh Serusalem, longeongen usili ba mikapis e ut xil vus e taon, e mol‑Serusalem xil latemanin e di latumul usili labit, “?Visi iaxa bemei xiak?” ");
INSERT INTO tvk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E vanut moletin xil labit rilomun ni labit, “Ngan ak be Iesu, provet tei te hal Nasaret xa de provins te hal Kaleli.” ");
INSERT INTO tvk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Melele xa laduxoh Serusalem, Iesu be vangit vioh te Nim Eo na Hi. Melele xa pusi xa moletin xil di lapos ni holesok xil holu en, ien mikat e nggol rerat xil. Xi midivin rerat tep na ngan xil xa di laso papas mani e von totanen na ngan xil xa di lapos ni mae xil te sanien eo na Hi. ");
INSERT INTO tvk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","E melele xa di pol ni mak, xi bul xat xil bit, “E Vanuvei Eo na Hi, latetisi latehit, ‘Lakes nim mavan ni nim te sisen.’ E xamim mupol ni sung mei be ‘Nim ma vati kanen xil.’” ");
INSERT INTO tvk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","E melele xa Iesu da tamu e vangit vioh te Nim Eo, moletin xil xa metexil bar del ngan xil xa lasakras lakakao lamei visali, e xi pol ni xil mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","E melele nen mun tak, tutut horamue xil di lakekei e vangit vioh te Nim Eo labit, “!Ripet rat xi xa mistal nggo vatimol na suv toto Deved!” E melele xa vat xil na pris xil del titsa xil te rae na Mosis lapus merekel xil e holesok sav xil xa tellep xa Iesu di pol ni e lalong naha xa horamue xil di lakekei ni, iexil mikat xa mikat. ");
INSERT INTO tvk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma lasis Iesu labit, “?Di olong naha xa tutut horamue xil di lakekei ni iaxai?” E Iesu bit rilomun ni mi xil bit, “Io, nalonge. ?E midep? ?Xamim di mutavuli ti e Vanuvei Eo na Hi? Vengan misepin ni bit, ‘Hi, xouk osak mesen suse tengan uteong ni memesien xil xa ihat visaluk, ixo tutut horamue xil e tuvava xil mun.’” ");
INSERT INTO tvk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Di, Iesu mistokovein xil e be reling taon te hal Serusalem. Xi be taon te hal Betani del moletin nan xil, e ba lapat en. ");
INSERT INTO tvk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","E makoe roroh, melele xa Iesu di mikakao tengan vatilomun vahe Serusalem, mae nggati e suse. ");
INSERT INTO tvk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma miketeh e pus vatit fik tei xa dat seri suse. E melele xa be sangas visali, xi mikameti xa huite tovuol, e be ute xil tang. Misak ni, Iesu biteni mi vatit fik ak bit, “!Onataxao ti mun!” Vatei takes, ut fik xil ak mei lameles e vatite mingguxu. ");
INSERT INTO tvk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Melele xa moletin nan xil lapusi, latemanin e lasisi labit, “?Vatit fik ak mei meles e mingguxu vari nga tang midep?” ");
INSERT INTO tvk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","E Iesu bit rilomun ni mi xil bit, “Reitin li nabiteni mi xamim, xosxa neketen namim di e mutanem male ni ti naha xa di musisi, xamim mun mukila mupol ni naha xa inou napol ni mi vatit fik ak. E tave ngan ak ti kestang, mukila mun musemae ni vathu ak muhit, ‘Umea uhe reling voninom e uha uso xouk uhe tas,’ ma istal ihe reitin. ");
INSERT INTO tvk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Xosxa uke reitin xa neta tei mei istal, neta xil vus xa usis Hi ven imei istal ihe reitin.” ");
INSERT INTO tvk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Melele xa laduxoh Serusalem, Iesu be vangit vioh te Nim Eo. E melele xa di pispisi mi moletin xil, vat xil na pris xil del elda xil na Siu xil lamei visali e lasisi labit, “?Xouk di opol ni holesok xil ak e his visi? ?Visi vari maen xouk tengan opol ni?” ");
INSERT INTO tvk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Iesu bit rilomun ni mi xil bit, “Inou mun nisis xamim ni neta tei. Xosxa muhit rilomun ni minou, ma inou mun nihit kila mi xamim xa di napol ni holesok xil ak e his visi. ");
INSERT INTO tvk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","?Muhit pisi minou, Sion tebaptaes ni moletin xil e di tepol ni e his visi? ?Hi mu moletin tova tang?” Xil laba, di lasep usili mi xil mun tang labit, “?Rihit naha? Xosxa rihiteni rihit, ‘Sion di tepol e his Hi,’ ma xi ihiteni mi xir ihit, ‘?Xosxa temak, veneh ma mutnake reitin ti e sepinien nan?’ ");
INSERT INTO tvk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","E xosxa rihiteni rihit, ‘xi di tepol e his moletin tang,’ ulixir mikan ni vanut moletin xil xa eilep xiak vengan xa xil vus lanemi labit Sion Baptis tehe provet tei na Hi.” ");
INSERT INTO tvk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma xil labit rilomun ni mi Iesu labit, “Xamem matakil ti xa xi di tepol e his visi.” Ma Iesu biteni mi xil bit, “Xosxa imak, ma inou mun ninaviteni ti xa inou di napol ni holesok xil ak e his visi.” ");
INSERT INTO tvk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Di, Iesu dei vole ak mi vat xil na Siu xil bit, “?Xamim munemi midep? Moletin tei, natneli lube lu. Vatei, moletin ak ba pus ngan xa be muimol e biteni mini bit, ‘Natuxoli, xosali, ha upol e urvatiei saratel.’ ");
INSERT INTO tvk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“E horamue ak bit rilomun ni mini bit, ‘Ieok ti tavei nama.’ E dutou ni, xi biles nenemien nan e ba pol. ");
INSERT INTO tvk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Di, tamealu ba pus ngan xa dutou e bit sepinien taxa tehiteni tetiamu mi muimol nan. Ma horamue ak bit rilomun ni mi tamen bit, ‘Bos ngamu tata, niha.’ E xi tava ti. ");
INSERT INTO tvk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“?Visi e xalu iaxa pol ni naha xa tamealu ien bei?” E xil labit, “Ngan xa diamu.” Ma Iesu biteni mi xil bit, “Reitin nabiteni mi xamim xa ngan xil xa di laleh viton mani te takis del hoeaso xil, Hi mei ihe suv toto e meulien nae itiamu ni xamim. ");
INSERT INTO tvk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vengan Sion temei tengan vapisen suse xa momal pe met Hi mi xamim tengan ti muvusili. E xamim mutake reitin ti e sepinien nan. E ngan xil xa laleh mani te takis e hoeaso xil lalonge e lake reitin e sepinien nan. E tave ti neta xa mupus holesok xil xa lapol ni, mutaviles ti ra tesaen namim e mutake reitin ti e sepinien nan.” ");
INSERT INTO tvk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Di, Iesu dei vole tei mun mi vat xil na Siu xil bit, “Vatei, hortan tei milihi urvatiei te grep tei san. Xi pol ni vioh mikapis xole, e minggil vul tei da en xa ti lipel kikis huit grep xil en tengan lihur rat sute. Di, mikili ni vet tei xa be nesao tengan ti liketeh xole en. Melele xa pol vuol ni holesok xil ak, xi maen moletin sav xil tengan mei lilaxati. E xil labit xati mini xa lisa ti huit grep mini melele xa limen. Di, hortan ak mikakao ba de kantri sav tei. ");
INSERT INTO tvk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Melengien hao mei mitavi, huit grep xil ak mei men. Ma hortan ak misil rut slev nan xil tengan ha lisis ngan xil xa di lalaxat urvatiei te grep san e lisa ti huite san xil mini. ");
INSERT INTO tvk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","E melele xa laduxoh urvatiei ak, moletin xil xa di lalaxati ladal xat slev nan xil ak: labas purun tei; tei mun, lamu vini; tei mun xatel, langgove. ");
INSERT INTO tvk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Di, hortan ak misil rut slev xil mun xa lali ngan xil xa tesil xil tetiamu. E moletin xil xa lalaxat urvatiei ak lapol ni mi xil nggoni ngan taxa latepol ni tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma di, hortan ak misil natneli xati be visal xil vengan minemi bit, ‘Xil limerere ni natuxoli xati.’ ");
INSERT INTO tvk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“E melele xa ngan xil xa di lalaxat urvatiei ak lapus natneli bemei, labiteni mi xil mun tang labit, ‘!Ei, nat hortan xati iaxa di bemei iaxor! Xi vari ihur urvatiei ak melele xa tamen imat. !Mumei, rava ravas vini! !Imak, ma holesok nan xil mei ihe nar sung!’ ");
INSERT INTO tvk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma xil laba, ladal xati, lakuvun rati ra urvatiei ak, e labas vini.” ");
INSERT INTO tvk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Di, Iesu misis vat xil na Siu xil xa di lateong ni vole ak bit, “?Ma midep? ?Melele xa hortan te urvatiei itilomun imei, ma ipol ni naha mi moletin xil ak?” ");
INSERT INTO tvk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma xil labit rilomun ni mini labit, “Xi isa rilomun ni maten xa isa pupu mi moletin tesa xil ak. Ti, imaen urvatiei san mi moletin sav xil xa ti lisa rut huit grep xil mini e melele xa limen kuhi.” ");
INSERT INTO tvk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Di, Iesu biteni mi xil bit, “?Midep? ?Xamim di mutavuli ti Vanuvei Eo? Vengan xa xi biteni bit, ‘Pos xa moletin te polien xil di lasin ni, xi vari iaxa mei be seteman xati te nim e mili sen pos nen xil vus. Ngan ak, Hi vari pol ni, e rapusi xa naha xa xi tepol ni bos pupu.’ ");
INSERT INTO tvk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma, nabiteni mi xamim, hosien na Hi xa be suv toto xa di e xamim taxeak, Hi ileh rerati reling xamim Siu xil. E isa ni sung mi moletin xil te kantri sav xil xa likila lilong xat raen e lipisen huit hosien teni e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngan xil xa lasin seteman ak, xosxa imot ita xat tei e xil, sin xil imavul ivus. E xosxa seteman ak imot ita xat tei e xil, ita xat kikisi.” ");
INSERT INTO tvk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Melele xa vat xil na pris xil del Farasi xil lalong vole xil xa Iesu dei, lakila sung xa di misep usil xil. ");
INSERT INTO tvk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ma di lalang ni suse tengan lital xati. E ulixil mikan ni vanut moletin xil xa eilep xiak xa di lanemi labit Iesu be provet tei. ");
INSERT INTO tvk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Melele xa Iesu da tamu e vangit vioh te Nim Eo, xi dei vole ak mun mi moletin xil bit, ");
INSERT INTO tvk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hi xa be suv toto e meulien na moletin nan xil nggoni suv toto tei xa, vatei, misak mesen anien te tetelien tei na natneli. ");
INSERT INTO tvk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xi misil slev nan xil laba tengan lakes ngan xil xa suv toto ak tesilasil ve xil ngamu tengan limei e anien ak. E moletin xil ak labit linamei ti. ");
INSERT INTO tvk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ma suv toto ak misil slev sav nan xil e biteni mi xil bit, ‘Ha muhiteni mi ngan xil xa natesilasil ve xil muhit, “!Mumei! Inou nasak mesen anien holu ngamu. Labas buluk savan xil e sulut buluk xil mun xa lakaio kuhi be te anien ak. Reitin, holesok xil vus te anien te tetelien ak mese tuei di. Ma mutemanon mumei.”’ ");
INSERT INTO tvk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“E moletin xil ak lanem male ni raen tang, e laba sung di lapol ni polien nae xil. Tei be naho nan, e tei mun ba pol e sitoa nan. ");
INSERT INTO tvk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","E moletin tesav xil ladal xat slev nan xil ak, labas purun xil e lamu vin xil. ");
INSERT INTO tvk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","E melele xa suv toto ak milongeong usili, ien mikat xa mikat. Misak ni, misil moletin te vaeen nan xil laba lamu vuol ni ngan xil xa latehas vin slev nan xil, e ladin taon nae. ");
INSERT INTO tvk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Di, suv toto ak biteni mi slev sav nan xil bit, ‘Anien te tetelien meses tuei di. E ngan xil xa natesilasil ve xil, meulien nae tapin ti tengan lamei lava ni. ");
INSERT INTO tvk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ma ha muhe suse xil te taon e musilasil ni moletin xil vus xa mukamet xil tengan mei lia anien te tetelien ak.’ ");
INSERT INTO tvk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Misak ni xil labe suse xil e lakes viton moletin xil vus xa lakamet xil, ngan xil xa labos e ngan xil xa lasa. E nim xa anien te tetelien da en polu kuhi ni moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ngan xil xa lamei e tetelien ak, lasing kuhi ni eising xil te tetelien. E melele xa suv toto bemei tengan vapus ti ngan xil xa lamei, xi miketeh e mikamet moletin tei xa tasing ni ti eising te tetelien. ");
INSERT INTO tvk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma suv toto ak be visali e misisi bit, ‘?Tuxoli, omei e nim ak midep vari xa otasing ni ti eising te tetelien?’ E moletin ak dat votei, e takil ti naha xa ihiteni. ");
INSERT INTO tvk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Misak ni, suv toto biles e misemae ni moletin te polien nan xil bit, ‘Muvar viton hen e len xil, e mukuvun rati ihe hale e ha ita nga e ut te maluxoluk. E rute ak moletin xil ti limuis e ti lingas luhexil ve longpangasien nae xil.’” ");
INSERT INTO tvk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Di, Iesu misep kor usil vole ak bit, “Reitin, Hi misilasil ve moletin xil holu tengan lamei visali, e xil vahis tang iaxa bosei xil tengan liti visali.” ");
INSERT INTO tvk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Melele xa Farasi xil lalong vole xil xa Iesu di biteni ba xat xil, xil laba di lalang ni mesal tova xa likila lital xati ixo en ve sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Misak ni, lasil rut moletin nae xil del rut Siu sav xil mun xa ladi rin na suv toto Herod Antipas laba. Xil labe visal Iesu e labiteni mini labit, “Titsa, xamem makila xa xouk obe hisit moletin tei xa moletin sav xil likila liling nenesien nae iti en. E makila mun xa xouk di opispisi mi moletin xil ni suse te reitinen xa Hi ien bei tengan moletin nan xil lihusili. Xouk di osepin mi moletin xil vus nggoni ngan xa xil vus lapin tang, tave ti neta xa labe eilep xil mu movotei xil tang. ");
INSERT INTO tvk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ma, usa ti nenemien nam mi xamem usil rin ak. ?Rae na Mosis maen ni tengan Siu xil ti lixal takis iha mi suv toto te hal Rom, mu tamaen ni ti?” ");
INSERT INTO tvk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","E Iesu pus kil nenemien tesa nae e bit rilomun ni mi xil bit, “!Xamim mubos nggot hilbemim tang! ?Veneh ma di musak pis nou? ");
INSERT INTO tvk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Musa mani tova xa di langgal takis ni.” Melele xa lasa ni mini ");
INSERT INTO tvk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","xi misis xil bit, “?Valnao visi vari iaxa da en? ?E his visi iaxa de mani ak?” ");
INSERT INTO tvk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Xil labit rilomun ni mini labit, “Neta xalu vus xa ludi en be na Sisa, suv toto xa mahulong te hal Rom.” Ma Iesu biteni mi xil bit, “Xosxa mak, ma momal tang tengan musa naha xa be na Sisa mini, e naha xa be na Hi, musa ni mini.” ");
INSERT INTO tvk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","E melele xa lalong sepinien nan, latemanin pupu ni. Ma, labe relingi e laba. ");
INSERT INTO tvk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E melengien xati nen tak, Satusi xil xa labit moletin misakras vamea rilomun ra maten labe visal Iesu, e lasisi labit, ");
INSERT INTO tvk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Titsa, Mosis tetis rae ak tehe nar xa tehit, ‘Xosxa moletin tei mat e mistokovein atou nan e horamue nalu tovuol, ma tunali sav ihur mei iteli itel tunau nan. Imak, ma isa horamue mini xa ihur his tunali xa mat ngamu.’ ");
INSERT INTO tvk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma vatei, tua tatei xil latehe lu e he sav (7) lateti visal xamem. Ngan xa tehe muimol teteli tetel atou tei. Di, xi temat e horamue nalu tehe tovuol. Misak ni, tuneli xa tetutou ni mei tehur tunau nan. E xi mun temat, e tuvava nalu tehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Di, sexien nen tak testal mun mi tuneli xa tetutou ni. Ma di, testal mun mi ngan xa tehe tol nen e dit temak tang teha vuma … tetuxoh ngan xa tehe tasite e tua xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E tetutou ni holesok xil ak, atou ak mun temat. ");
INSERT INTO tvk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Ma xosxa mea rilomunen be reitin, melele xa moletin xil vus limea rilomun ra maten, ngan xave e tua xil xa labe lu e he sav (7) xiak iaxa ihur atou ak ihe nan xati, vengan xil vus lateteli tetela?” ");
INSERT INTO tvk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu bit rilomun ni mi xil bit, “Xamim di mule ras suse namim vengan xa mutakil kuh ti Vanuvei Eo na Hi mu xeihen nan. ");
INSERT INTO tvk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vengan e melele xa moletin xil limea rilomun ra maten, xil mei lixoni masxaxa xil xa ladi ut nesao, e sexien te tetelien ihe tovuol mun. ");
INSERT INTO tvk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","?E veneh ma mutake reitin ti xa moletin xil likila limea rilomun ra maten? ?Mutavuli ti mu naha xa Hi tesepin ni mi xamim? Vengan xi tehit, ");
INSERT INTO tvk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Inou nabe Hi na Ebraham, Hi na Aesak, e Hi na Siekob.’ ?Mulonge? Xi be Hi na ngan xil xa lameul tamu ladi, e tave na ngan xil ti xa labe tovuol ngamu.” ");
INSERT INTO tvk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","E melele xa vanut moletin xil xa eilep xiak lalong pispisien nan xil, xil latemanin ni. ");
INSERT INTO tvk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Melele xa Farasi xil lalongeong ni xa Iesu bas vin upang na Satusi xil, xil mei labe vituei e laba lapus Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tei e xil xa be titsa tei te rae na Mosis bemei tengan vasak pis Iesu ni sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Misak ni, xi misisi bit, “?Titsa, rae xave vari iaxa be eilep mak mu mili sen rae xil vus?” ");
INSERT INTO tvk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E Iesu bit rilomun ni mini bit, “‘Iemim ihei Iahova xa be Hi namim ixo tinemim tevi, ixo meulien tevi namim, e ixo nenemien tevi namim.’ ");
INSERT INTO tvk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Rae ak iaxa be eilep mak mu mili sen rae sav xil. ");
INSERT INTO tvk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","E tei mun xa nggoni tang xa be lu nen di biteni bit, ‘Eheien namim iti e moletin sav xil ixoni ngan taxa eheien namim di e xamim mun tang.’ ");
INSERT INTO tvk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Holesok xil vus xa di e rae xil na Mosis del Tisen xil na provet xil tetiamu di ngamu e rae xalu ak.” ");
INSERT INTO tvk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","E melele xa Farasi xil ladi vituei tamu dela, Iesu misis xil sung bit, ");
INSERT INTO tvk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Xamim munemi midep usil Mesaea? ?Xi istal ixo vatimol na visi?” E xil labit rilomun ni mini labit, “Xi istal ixo vatimol na suv toto Deved tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma Iesu biteni mi xil bit, “?Xosxa ngan ak be reitin, veneh ma Ninin na Hi tesa nenemien mi Deved tengan ikes Mesaea ak ni ‘Suv’? Vengan xa xi tehiteni tehit, ");
INSERT INTO tvk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iahova biteni mi Suv navan bit, “Utotan inggak e riuk metu, ituxoh melele xa niling elu nam xil e hem.”’ ");
INSERT INTO tvk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Suv toto Deved vari tekes Mesaea ni ‘Suv nan.’ ?E vengan xa tata tei misakras vakes natneli ni ‘suv,’ Mesaea istal ixo vatimol na Deved itep?” ");
INSERT INTO tvk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","E moletin xil lasakras lasa rilomun ni sepinien nan. Ma e melele nen ak ba, moletin xil ulixil mikan tengan lasis ti mun neta mini. ");
INSERT INTO tvk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Melele xa Iesu da tamu e vangit vioh te Nim Eo na Hi, misepin mi vanut moletin xil del moletin nan xil mun bit, ");
INSERT INTO tvk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Titsa xil te rae na Mosis del Farasi xil ladi tengan laxoles Mosis e lavit kil rae xil na Hi mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ma bos xa xamim mulong xat xil e muhusil holesok xil vus xa di labiteni mi xamim tengan mupol ni. E xamim, munapol ni ti sexien xil naxoni ngan xa xil di lapol ni, vengan xil latahusil kuh ti pispisien xil xa di lapispisi ni mi mosav xil. ");
INSERT INTO tvk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xil di laling rae xil hao xa meas da xat mar moletin xil. E xil, iexil ti tavei tengan lasa hexil vatutou ni xil tengan lapoe. ");
INSERT INTO tvk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ngan xil ak, holesok xil vus xa di lapol ni, lapol ni tengan taxa moletin xil ti lapusi e ti lasa merereen mi xil ven. Xosxa mosav xil di labar xat tutut bokis tei di he xa sepinien na Hi da en, ma xil sung lapol ni nae eilep mak mu mili. Xosxa mosav xil di laling ao xil xa tepepiei di murur e kusut eising nae, xil sung di lapol ni ao nae xil latepiei pilei mu mili. ");
INSERT INTO tvk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","E anien xil xa tellep, e nim te pispisienxil mun, xil di lalepis vontoen xil xa bos xa be na ngan xil kestang xa lapo his xil xa latellep. ");
INSERT INTO tvk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","E von posen xil mun, xil iexil bei pupu tengan moletin xil lisemin xil itel merereen e likes xil ni ‘titsa.’ ");
INSERT INTO tvk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“E xamim, linakes xamim ni titsa xil ti vengan titsa namim tei takes, e xamim vus mube tua xil tang. ");
INSERT INTO tvk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E munakes ti moletin e ut etan ak ni ‘tata’ vengan Tata namim tei takes tang, ngan xa de ut nesao. ");
INSERT INTO tvk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","E linakes ti mun xamim ni ‘suv’ vengan suv namim tei takes, xi be Mesaea. ");
INSERT INTO tvk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngan xa di misa tutouen mi xamim nggoni slev namim, xi iaxa mei ihe eilep mak mu ni xamim. ");
INSERT INTO tvk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vengan ngan xil xa di lapol ni nenemien nae be nesao, Hi ipol ni xil lihe tan. E ngan xil xa di lapol ni nenemien nae be tan, Hi ipet rat hisexil ihe nesao. ");
INSERT INTO tvk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Hi isa pangasien mi xamim vengan xamim iemim ti tavei tengan mupol ni Hi mei vahe suv toto e meulien namim. E melele xa mosav xil iexil bei tengan Hi mei vahe suv toto nae, xamim di musikoe xol xil. ");
INSERT INTO tvk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Hi isa pangasien mi xamim vengan di munggur xoteh tas e tan tengan taxa mukamet moletin ngan e muviles nenemien nan tengan vahusil xamim. E melele xa biles e nggusil pispisien xil namim, xamim mupol ni mei misa pilei sung mili xamim. E momal tang tengan xi mun ihur pangasien itel xamim e Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Isa pupu mi xamim xa di musak tengan ti mutiamu ni moletin xil, tave ti neta xa metemim xil bar! Pangasien xa muhuri ihe eilep pupu vengan di mupispisi mi moletin xil mubit, ‘Xosxa moletin tei pol ni hitxatien tei nan e his Nim Eo, hitxatien nan be neta sav tang. E xosxa xi pol ni hitxatien nen e his gol xa di Nim Eo, ma ihur xat hitxatien ak ixeih.’ ");
INSERT INTO tvk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!Metemim bar e mutalang tova tang! ?Ngan xave be eilep mak mu, gol te Nim Eo, mu Nim Eo na Hi vari xa di misak ni gol ak be eo? ");
INSERT INTO tvk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","E di mupispisi mi moletin xil mun mubit, ‘Xosxa moletin tei pol ni hitxatien tei nan e his hor te sanien, hitxatien nan be neta sav tang. E xosxa xi pol ni e his sanien xa lalingi di xati, ma ihur xat hitxatien ak ixeih.’ ");
INSERT INTO tvk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!O, metemim li bar tova tang! ?Ngan xave be eilep mak mu, sanien mu hor te sanien xa di misak ni sanien ak mei be eo? ");
INSERT INTO tvk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma moletin xa di pol ni hitxatien nan e his hor te sanien di pol ni mun e his holesok xil vus xa di xati. ");
INSERT INTO tvk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","E moletin xa pol ni hitxatien nan e his Nim Eo, xi di pol ni e his Hi xa da en. ");
INSERT INTO tvk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","E moletin xa di pol ni hitxatien nan e his ut nesao, xi di pol ni e his vontoen te xeihen na Hi e e his ngan xa di dotan da en. ");
INSERT INTO tvk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Hi isa pangasien mi xamim vengan di muteong xat tutut rae xil nggoni sexien xa musa taet ni tutut uvei xil te kuken ba mi Hi. E rae xil xa latellep nggoni ngan xil xa di labit mupisen sexien xil te esaeen, te neketen, e mupol ni naha xa momal pe met Hi, xamim mutateong xati ti. Vahos mak mu vahit muteong xat rae xil xa latellep vatel ngan xil xa labe tereli mun. ");
INSERT INTO tvk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","!Tave ti neta xa metemim bar, e di musak tengan mutiamu ni mosav xil! Xamim di musev kuh oei mamim tengan munamu ti tutut anon tova xa tamese ti, e mutamea sung murom tevi kamel tei xa mahulong xa misa mak mu mili. ");
INSERT INTO tvk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Hi isa pangasien mi xamim vengan munggoni kap e pelet xa di lakas moten ni e hale tang, e vangite mumu nggoni tinemim xa polu ni nenemien te hokanen e holesok sav xil xa lasa. ");
INSERT INTO tvk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","!Metemim bar tova tang! Itiamu, mukas moten vangit meulien namim. Imak, ma hale mun imese. ");
INSERT INTO tvk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Xamim munggoni von tehinen xil xa lapol kuhi ni e lapen kuhi ni mieh. Ut xa hale, lapusi bos xa bos. E vangite xil polu ni si moletin xil e neta sav xil mun xa misa xa misa pupu. ");
INSERT INTO tvk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Usil sexien ak, xamim mumal nggot hilbemim tang, e tinemim, mupolu ni luvosen e sexien tesa xil. ");
INSERT INTO tvk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Isa pupu mi xamim, titsa xil te rae na Mosis del Farasi xil xa di munggusil Hi nggot hilbemim tang! Pangasien namim isa mak mu vengan xa mupol pilei ni von tehinen na provet xil e di mupilas kuhi ni von tehinen na ngan xil xa lamal pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E di mubiteni mubit, ‘Vahit mateti e melengien na avu namem xil tetiamu, xamem manamos ti natel xil e melele xa latehas vin provet xil ak.’ ");
INSERT INTO tvk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","!Iaxai vari! Nggo sepinien xati namim, di mubiteni reitin xa mube vatimol xati na ngan xil xa latehas vin provet xil. ");
INSERT INTO tvk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","E melele xil namim sung, xamim ti mupol vuol ni naha xa avu namim xil tetiamu latepol kokot ni. ");
INSERT INTO tvk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“!Xamim mube tetal sasa xil! Reitin, mube vanut tetal sosomen xil xa di mungas vin moletin xil ni vulongomim. ?Mulesae reling pangasien te Upang xa misakras vamat itep vari? !Musakras! ");
INSERT INTO tvk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Misak ni, nisil provet xil, ngan xil xa lakilakil kuhi, e titsa xil mun ha lisel xat xamim tengan muhiles ra tesaen xil namim. E xamim, muhas vin rute xil e muti xat xil e eivave xil. E rute ngan xil mun, mumeas purun xil ni ao te xeih xil xa sanute di en e nim te pispisien xil namim. Muhol xil ha mutal xat xil e taon namim xil e e taon sav xil mun. ");
INSERT INTO tvk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isak ni, pangasien ve maten na moletin xil vus xa lamal pe met Hi iti e hemim. Reitin, maten na Ebel xa temal pe met Hi xa avu namim tetiamu tehas rohon ni temat teloh teha tetuxoh maten na provet Sakaraea, nat Berekae, xa avu namim xil latehov vini e hilaep te Nim Eo e hor te sanien, maten nae xil vus iti xat xamim. ");
INSERT INTO tvk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Reitin li nabiteni mi xamim, Hi isa pangasien ve maten xil ak iha xat xamim te xosali ak. ");
INSERT INTO tvk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“!O moletin xil te hal Serusalem! Xamim iaxa mutehas vin provet xil e mutehov vin eloheoh xil xa Hi tesil xil latemei ve xamim. Melengien xil holu, ieok bei pupu tengan nakes viton xamim e nasikoe xol xamim vaxoni toatou tei xa mikes viton tuten xil e muhin xol xil ni aveoun. E xamim iemim ti tavei. ");
INSERT INTO tvk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","!Ma xamim mupus ti sung! Hi nasikoe xol xamim ti mun, e imaen Nim Eo namim mei ita hon tang, moletin ti mun nava en. ");
INSERT INTO tvk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nabiteni mi xamim, taxeak iha, munapus ti mun nou ituxoh melele xa muhiteni muhit, ‘!Tuxolxatien iti mi ngan xa di bemei e his Iahova!’” ");
INSERT INTO tvk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Melele xa Iesu del moletin nan xil di labe reling vangit vioh te Nim Eo, moletin nan xil di lati nim xil xa bos te Nim Eo mini. ");
INSERT INTO tvk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Iesu biteni mi xil bit, “?Xamim di mupus holesok xil vus ak? Reitin li nabiteni mi xamim, melengien tei di bemei xa hat xil ak xa latepol ni Nim Eo ak ni navistin xil ti mun. Moletin xil mei lihu lelen xil vus ihe tan.” ");
INSERT INTO tvk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Di, Iesu be nesao e Vathu te Urvatiei te Olip del moletin nan xil. E melele xa ba dotan, xil kestang lamei visali e lasisi labit, “?Uhiteni mi xamem, holesok xil ak usil Nim Eo istal vilieh vari? ?E naha vari ipisen ni xa xouk umei, e hoxalite te melengien xil xa radi en di bemei sangas?” ");
INSERT INTO tvk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu bit rilomun ni mi xil bit, “Muxuxou kuhi ve xamim, e munamaen ti moletin mei naluvos xamim. ");
INSERT INTO tvk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vengan moletin xil holu limei e hisok e lihiteni lihit, ‘!Inou nabe Mesaea!’ Ma liluvos moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mulongeong ni xa vaeen xil xa tellep di bemei, e muhur longeongen mun usil vaeen xil xa di rute xil xa be sotin. E munatemanin ni ti. Holesok xil ak iaxa mei istal itiamu, e nave hoxalite te ut etan ti mu. ");
INSERT INTO tvk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ut tei ivae itel ut tei mun, e kantri xil lihas tan ni kantri sav xil. Ut xil hao e ut etan, mae kekaten ihas moletin xil e lul holu ilil. ");
INSERT INTO tvk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","E tave ti neta xa holesok xil ak mei isa itiamu ni melele xa Hi mei ihe suv toto na moletin xil, ngan ak nave hoxalite ti mu. Ixoni melele xa atou tei milong rohon ni mar pangasien xa di pisen ni xa, nave nousav ti, iling tuvava nan. ");
INSERT INTO tvk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ti, xil mei lital xat xamim e lisa rat xamim muha tengan ha lisa pangasien mi xamim e lihas vin xamim. Moletin xil te kantri xil vus iexil iat pangas xamim vengan di munggusil xat nou. ");
INSERT INTO tvk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E melele nen ak, moletin xil hao likavitou ra neketen nae e limaen rat tua nae xil lihe he elu nae xil e iexil ti iat xil mun tang. ");
INSERT INTO tvk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","E provet te luvosen xil hao mei listal e liluvos moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","E vengan sexien te tesaen mei ihe holu mak mu, eheien na moletin xil holu nati ti mun e mosav. ");
INSERT INTO tvk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","E ngan xil xa lisoh ixeih e neketen nae ituxoh hoxalite te holesok xil vus ak, Hi iteh meulien e xil. ");
INSERT INTO tvk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","E melele xa longeongen usil Hi xa mei ihe suv toto na moletin xil ha ituxoh rute xil vus e ut etan tengan moletin xil vus lakilakil ni, e melele nen ak vari, ihe hoxalite te holesok xil vus. ");
INSERT INTO tvk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Xamim mupus sepinien na Hi xa texo provet Daniel mei istal ihe reitin xa bit, ‘Xil liso neta tei xa be muis pupu ite vangit Nim Eo xa isak ni namese ti mun pe met Hi.’ (Xouk xa di obuli sepinien ak, bos tengan ukil kuh koute teni.) ");
INSERT INTO tvk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","E melele xa mupusi, ngan xil xa ladi Sudea litemanon lilesae ha lixus liti e vathu xil. ");
INSERT INTO tvk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Xosxa moletin tova di mingel e hale, mesal ihe tovuol tengan vatilomun vahe nim e vahur neta tova nan. ");
INSERT INTO tvk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","E xosxa moletin tei di pol e naho, xi nava ti mun tim tengan vahur eising tova nan. ");
INSERT INTO tvk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","E melele nen xil ak, isa pupu mi atou xil xa ladi ni tuvava xil e ngan xil mun xa di latunat ni tuvava xil. ");
INSERT INTO tvk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Musis mi Hi tengan melengien xa ti mulesae en nave an tesa ti mu nave Sabat ti, ");
INSERT INTO tvk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","vengan longpangasien xil te melengien tesa xil ak isa ili melengien sav xil vus te ut etan: e melele xa Hi tepeas ni ut etan miloh mei duxoh xosali. E hisit melengien xil ak ihe tovuol mun e melengien xil mun xa ti imei itutou. ");
INSERT INTO tvk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","E Hi teta xoteh melengien tesa xil ak mei be tamure mu vengan xi di minem usil ngan xil xa tehosei xil labe nan. Vengan vahit napol ni ti namak, moletin ti mun nameul. ");
INSERT INTO tvk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“E melele nen ak, xil lihiteni lihit, ‘!Mupus ti! !Ngan ak be Mesaea xa Hi tehosei!’ Mu lihiteni lihit, ‘!Mupus ti mu! !Xi iaxa da iaxor!’ E xamim, munake reitin ti e sepinien xil ak. ");
INSERT INTO tvk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vengan Mesaea te luvosen xil e provet te luvosen xil mun limei. E melele xa limei, lipol ni merekel xil e holesok xil xa tellep xa isak ni moletin xil limesep pupu ven. Xil lipol ni tengan liluvos moletin xil holu lihusil xil. Nahe di lisak tengan lalihi rerat ngan xil mun xa Hi tehosei xil labe nan. ");
INSERT INTO tvk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma muteong kuhi ni sepinien xil ak, vengan, inou, nabit usil holesok xil hao ngamu mi xamim xa mei istal. ");
INSERT INTO tvk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ma xosxa moletin tei mei ihiteni mi xamim ihit, ‘Mesaea da nga xor e uruvuol,’ munaha ti rute ak. E xosxa lihiteni mi xamim lihit, ‘Mesaea xi tak, dat vangit nim ak,’ munake reitin ti en. ");
INSERT INTO tvk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vengan, melele xa inou, Nat Moletin, nitilomun nimei, moletin xil vus lipus kila ixoni melele xa lapus an milangas e miehen teni nggur vuol ni tilang hat nggo rin tei e ist ba duxoh rin mun e wes. ");
INSERT INTO tvk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Moletin xil vus lipus kil rute xa Nat Moletin itilomun en vengan xa imei itel pangasien holu. Reitin, lipus kila ixo hisit sexien xa di lale kil rute xa neta tei mat da en e melele xa lapus vanut angelu xil ladi ut tei. ");
INSERT INTO tvk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“E melele xati xa melengien tesa xil ak ivus, ‘Eai imei imaluxoluk e aveti namem ti mun.’ ‘Hitu xil likiri ra tilang hat, e holesok xil mun xa di nesao, Hi imulul ni xil.’ ");
INSERT INTO tvk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Reitin, e melele xati nen ak, neta tei istal e tilang hat xa ipisen ni xa inou, Nat Moletin, di namei. E moletin xil vus te ut etan ti lites xil mun tang melele xa lipusi. Xil lipus ‘Nat Moletin imei etan itel momah xil te tilang hat.’ Xi imei itel xeihen, e minehinen te xeihen nan ihe eilep. ");
INSERT INTO tvk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xi ihui amaru nan ixeih tengan vasa rerat masxaxa nan xil. E xil lihe rute xil vus e ut etan, lixo rin tei ha lihe rin tei mun, e lileh viton moletin xil vus xa Hi tehosei xil labe nan. ");
INSERT INTO tvk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Xamim muhur pispisien ixo vatit fik. Melele xa lite xil miso rohon ni ute xil xa be neta hu, xamim mukila xa melele te an te tin di bemei. ");
INSERT INTO tvk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Usil sexien nen tak, melele xa mupus holesok xil ak mei istal, mukila xa mei rilomunen navan di bemei sangas. Reitin, da ngamu e puiteh. ");
INSERT INTO tvk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Reitin li nabiteni mi xamim, holesok xil ak mei istal e melele xa moletin xil te xosali ak limeul tamu liti. ");
INSERT INTO tvk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nabiteni reitin vengan xa neta sav xa ut etan itel tilang hat mun lalikesae e melengien tei, sepinien navan misakras vakesae vatova.” ");
INSERT INTO tvk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iesu biteni mi moletin nan xil bit, “Moletin tovuol xa vakil melengien xati xa inou, Nat Moletin, nitilomun en. Reitin, masxaxa xil xa ladi ut nesao, e inou mun, Nat Moletin, matakil ti. Hi Tamer kestang mikil haoa xati teni. ");
INSERT INTO tvk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mei rilomunen navan, Nat Moletin, ixoni melengien xil na Noah tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vengan, e melele nen xil ak, tetiamu ni ngan xa oei xa mahulong temei, moletin xil di lateanien e di latemun, tiramue xil e atou xil di lateteli ba tetuxoh melele xa Noah tehe vangit tuturil. ");
INSERT INTO tvk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Xil latnakil ti vari naha xa mei istal ba tetuxoh melele xati xa oei xa eilep temei e mei tehas xil vus latelel. Ixo rin tak, moletin xil litemanin ni mei rilomunen navan, Nat Moletin. ");
INSERT INTO tvk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","E melele nen ak, moletin lu ti lalipol e naho tei takes, e Hi mei ihur rat tei xalu ihe visali e ut nesao, e teimun isin ni e ilingi ita. ");
INSERT INTO tvk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Reitin, atou lu ti lalipol ni anien, e Hi ihur rat tei xalu iha visali e ut nesao, e teimun isin ni e ilingi ita. ");
INSERT INTO tvk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ma, muxuxou kuhi ve xamim, vengan mutakil ti melengien eah iaxa Suv namim itilomun en. ");
INSERT INTO tvk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","E mukila xa xosxa moletin tei, xa nim man da, mikil melele xati xa moletin te kanen imei en, xi mikila ita nga e iketeh xole tengan moletin te kanen namei ti e nim man. ");
INSERT INTO tvk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ma muvue xat xamim. Vengan, usil sexien nen tak, inou, Nat Moletin, nitilomun nimei e melele tei xa moletin xil linakil ti ixoni moletin te kanen. ");
INSERT INTO tvk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“?Visi iaxa be moletin te polien xa be metisou kuhi e di miteong xat rae na suv nan? Xi be ngan xa suv nan milingi be vat na moletin te polien sav xil e tim san tengan ti isa anien mi xil e melele xati teni. ");
INSERT INTO tvk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tuxolxatien iti mi moletin te polien xa, melele xa suv nan itilomun imei, ikameti xa xi di pol ni polien nan xil. ");
INSERT INTO tvk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Reitin li nabiteni mi xamim xa suv nan ipet rat moletin te polien ak ihe nesao tengan ti ilaxat holesok sav nan xil mun. ");
INSERT INTO tvk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“E xosxa moletin te polien ak, vatin isa, ma ti ihiteni mi xi mun tang ihit, ‘Suv navan namei ti mok.’ ");
INSERT INTO tvk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma iha ti ihas pangas moletin te polien sav xil mun, e ti ianien e ti imun itel vat munien xil. ");
INSERT INTO tvk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","E suv nan itilomun imei e melele tei xa moletin te polien ak nakil ti. ");
INSERT INTO tvk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","E melele xa suv nan imei, ihas pangasi, e ikuvun rati ha ite von longpangasien itel ngan xil xa di langgusil Hi nggot hilbexil tang. E xil ti limuis e ti lingas luhexil ve longpangasien nae xil.” ");
INSERT INTO tvk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Melele xa Iesu di tamu misepin mi moletin nan xil usil rin xa ti livue xat xil ve meien nan, xi dei vole ak mi xil bit, “Melele xa Hi mei ihe suv toto na moletin xil imak: Vatei, atul maxoe he xalu (10) laba tengan lapus tetelien tei. E melele xa ut da maluxoluk, laleh laet nae xil e laba tengan lavisu mi tiramue xa iteli e lihusili lihe rute xa tetelien ita en. ");
INSERT INTO tvk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Xil lim (5), vatixil tovuol, e xil lim (5) iaxa langgur vati. ");
INSERT INTO tvk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ngan xil xa vatixil tovuol laleh laet nae, e latahur ti mun oel vatel xat xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","E ngan xil xa langgur vatixil, xil vus lapin e valihe xil xa oel di en del xat laet nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","E vengan xa tiramue xa iteli tamei ti mu vamanon, atul maxoe xil ak, vexil memel, ma lapat. ");
INSERT INTO tvk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Maxani, e hilaep te vongien, xil lalong moletin xil di lakekei ni labit, ‘!Xi bemei! !Ngan xa iteli di bemei! !Mei rava ravisu mini e rihusili riha! ");
INSERT INTO tvk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Melele xa atul maxoe xil ak lalonge, latamea e lapol kuhi ni laet nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","E ngan xil xa vatixil tovuol labiles lasis ngan xil xa langgur vatixil labit, ‘Musa ti oel li mi xamem, vengan laet namem sangas vamat xiak.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“E ngan xil xa langgur vatixil labit, ‘E‑e, masakras li. Vengan xa oel namem tapin ti tengan vahe laet namim, ti, e vahe namem mun. Muha tang e sitoa nen, e ha muxal ti namim.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“E melele xa rut atul maxoe xil ak laba tengan laxal ti oel nae, tiramue xa iteli mei mistal. Ma atul maxoe xil xa latevue xat kuh xil langgusili ba labe nim xa anien te tetelien da en. Di, lakoe xol puiteh teni. ");
INSERT INTO tvk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“E dutou ni, atul maxoe sav xil ak mun mei lastal. Xil lamei visal nim te tetelien e lakei be nesao labit, ‘!Suv, suv! !Sah puiteh li mi xamem!’ ");
INSERT INTO tvk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“E tiramue xa miteli bemei e bit rilomun ni mi xil bit, ‘Nabiteni reitin li, inou natakil ti vari xamim.’” ");
INSERT INTO tvk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Di, Iesu misepin kor e vole ak bit, “Ma, muvue xat kuh xamim e munapat ti, vengan mutakil ti melele xati xa inou nitilomun en.” ");
INSERT INTO tvk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu de vole te mun mi moletin nan xil bit, “Melele xa Hi mei ihe suv toto na moletin xil imak: Vatei, eilep tei misak xat holesok nan xil tengan vahe rute tei xa be sotin. Di, mikes viton moletin te polien nan tol (3) e miling xatel tengan latilaxat holesok nan xil ");
INSERT INTO tvk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","pipin ni metisouen natel. Mi tei, eilep ak miling gol mani be taosen lim (5000) di e hen. Mi tei mun, miling gol mani be taosen lu (2000) di e hen. E mi ngan xa be tol nen, miling gol mani be taosen tei (1000) di e hen. Bus di, eilep ak ba sung. ");
INSERT INTO tvk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Melele xa eilep ak ba, vatei takes, ngan xa nggur gol mani be taosen lim (5000) ba pol sorin ni mani ak ba vuma … bas xoles gol mani taosen lim (5000) mun mei del xat ngan xa da ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Usil sexien tak, ngan xa tehur gol mani tehe taosen lu (2000), xi mun ba pol sorin ni e bas xoles gol mani be taosen lu (2000) mun. ");
INSERT INTO tvk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","E moletin te polien xa tehur gol mani xa tehe taosen tei (1000), xi ba, minggil vul, e midihin soson mani na suv nan di en. ");
INSERT INTO tvk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Melengien xil hao mei mitavi, e eilep natel dilomun e mikes viton xatel tengan valong kuhi xa latepol ni naha tetel mani xil xa telingi teti heatel. ");
INSERT INTO tvk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Moletin te polien nan xa tehur gol mani tehe taosen lim (5000) bemei del xat taosen lim (5000) mun e biteni bit, ‘Suv, oteling gol mani tehe taosen lim (5000) teti e heok. E taxeak, pus ti. Natepol sorin ni e natehas xoles taosen lim (5000) mun mei del xati.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Melele xa suv nan pusi, biteni mini bit, ‘!Bos pupu! Xouk obe moletin tei te polien xa bos e nenesien navan di e xouk. E vengan xa di olaxat kuh holesok xil xa tereli xa natelingi teti e hem, nilinguk sung mei ulaxat holesok navan xil xa holu. Amei pus hosien itel suv nam.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Di, moletin te polien nan xa tehur gol mani tehe taosen lu (2000) bemei e biteni bit, ‘Suv, oteling gol mani tehe taosen lu (2000) teti e heok. E taxeak, pus ti. Natepol sorin ni e natehas xoles taosen lu (2000) mun mei del xati.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Melele xa suv nan pusi, biteni mini bit, ‘!Bos pupu! Xouk obe moletin te polien tei xa bos e nenesien navan di e xouk. E vengan xa di olaxat kuh holesok xil xa tereli xa natelingi teti e hem, nilinguk sung mei ulaxat holesok navan xil xa holu. Amei pus hosien itel suv nam.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Di, moletin te polien nan xa tehur gol mani tehe taosen tei bemei visali e biteni mini bit, ‘Suv, inou nakila li xa xouk obe moletin te xeih tei xa di oleh huiei xil ra vatiei xil xa tave xouk ti olihi, e di oleh anien mun xa mosav xil tang latelihi teti e naho sam xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Uluk mikan ni xouk, ma ba nadihin mani nam de vul tei. Pus ti mu, mani xil vus nam xiak.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Melele xa suv nan pusi mak, misepin nggeih mini bit, ‘!Xouk obe moletin te polien tesa tei xa obe mah tova tang! Xouk okil kuhi xa inou nabe moletin te xeih tei xa di naleh huiei xil ra vatiei xil xa tave nou ti nalihi, e di naleh anien mun xa mosav xil tang latelihi teti e naho savan xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ma, vahit vahos mak mu xa ova oling mani navan vate bangk tova tengan, melele xa natilomun namei, nakila ma namur rat rilomun ni e vatin vata xati.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Di, eilep ak biles pus moletin te polien sav nan e biteni mini bit, ‘Hur rat gol mani ra moletin te polien xai, e ha ulingi ite he ngan xa nggur gol mani taosen he xalu (10,000) ngamu. ");
INSERT INTO tvk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vengan ngan xil xa di lapol del xat naha xa de hexil ngamu, lisa ti mun mi xil tengan isak ni hexil mei ipolu mu. E ngan xil xa latapol ni ti neta ni ngan xa de hexil ngamu, tave ti neta xa holesok nae tereli tang, lileh rerati ihe reling xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma ha mukuvun rat moletin te polien tesa ak ihe hale, ha ite rute xa maluxoluk itel xat ngan xil xa ti limuis e ti lingas luhexil ve longpangasien nae xil.’” ");
INSERT INTO tvk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesu biteni mun mi moletin nan xil bit, “Melele xa Nat Moletin itilomun en, minehinen te xeihen istal en e imei itel xat masxaxa xil vus. Ti, itotan e voninen te xeihen e ilepis moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","E melele nen ak, moletin xil te kantri xil vus mei lihe vituei e rute tei takes. Xil mei lisoh pe meten, e xi iseti xil lihe vanute lu. Xi ipol ni ixoni moletin tei xa di milaxat sipsip xil xa di miseti nani xil reling sipsip san xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngan xil xa langgoni sipsip xil, iling xil liti e rin metu. E ngan xil xa langgoni nani xil ha liti e rin meil. ");
INSERT INTO tvk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ti, xi isepin mi xil nggoni suv toto nae. Ihiteni mi ngan xil xa ladi e rin metu ihit, ‘!Mumei, xamim xa tuxolxatien na Tata navan di e xamim! Mei muleh holesok xil xa xi tesak mesen ni ve xamim melele xa tepeas ni ut etan. ");
INSERT INTO tvk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vengan xa melele xa mae teat nou, mutesa anien minou; melele xa meruru teat nou, mutesa oei minou natemu ni; e melele xa natemei natexoni ngan halesav tei, mutehur pilei nou natemei e tim samim xil. ");
INSERT INTO tvk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Reitin, melele xa eising navan tehe tovuol, xamim mutesing xol nou; melele xa natemesei, xamim mutelaxat kuh nou; e melele xa natete nim te xeih, xamim mei mutesao ni nou.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ti, ngan xil xa lamal pe met Hi xa liti e rin metu lihit rilomun ni mini lihit, ‘?Suv, vilieh vari iaxa matepusuk xa mae teatuk e matesa anien minuk; mu meruru teatuk e matesa oei minuk tengan omu ni? ");
INSERT INTO tvk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Vilieh vari iaxa matepusuk otexoni ngan halesav tei e matehur pilei xouk otemei e tim samem; mu eising nam tehe tovuol e matesing xolok? ");
INSERT INTO tvk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?E vilieh mun iaxa matepusuk otemesei e matelaxatuk; mu otete nim te xeih e matehat matesao ni xouk?’ ");
INSERT INTO tvk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma, suv toto ak ihiteni mi xil ihit, ‘Reitin li nabiteni mi xamim, holesok xil vus xa mutepol ni mi tuak xil ak, tave ti neta xa xi tehe movotei tei tang, e pe metok, lehit ngan xa mutepol ni minou vari tang.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ti, ihiteni mi ngan xil xa liti e rin meil ihit, ‘!Xamim, ngan xil xa Hi tesa halesil mi xamim, muhe reling nou! !Ha muhe Upang xa misakras vamat vatova xa Hi tesak mesen ni ngamu tengan ihe vonine Temat itel masxaxa nan xil! ");
INSERT INTO tvk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vengan melele xa mae teat nou, mutnasa ti anien minou; melele xa meruru teat nou, mutnasa ti oei minou namu ni; ");
INSERT INTO tvk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","e melele xa natemei natexoni ngan halesav tei, mutnahur pilei nou ti namat e tim samim xil. E melele xa eising navan tehe tovuol, mutnasing xol nou ti; melele xa natemesei, xamim mutnalaxat kuh nou ti; e melele xa natete nim te xeih, xamim mutnasao ni nou ti.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ti, moletin xil ak lisisi lihit, ‘?Suv, vilieh vari iaxa matepusuk xa mae mu meruru teatuk, mu otemei texoni ngan halesav tei, mu eising nam tehe tovuol, mu otemesei, mu otete nim te xeih e matnatutou ni xouk ti?’ ");
INSERT INTO tvk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma, xi ihiteni mi xil ihit, ‘Reitin li nabiteni mi xamim, holesok xil vus ak, xosxa mutnapol ni ti mi tuak xil ak, tave ti neta xa xi tehe movotei tei tang, e pe metok, lehit ngan xa mutnapol ni ti minou vari tang.’ ");
INSERT INTO tvk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ma xil vus xa latamal ti pe meten, Nat Moletin iso rerat xil vus ha liti rute xa longpangasien nae xil misakras vavus vatova. E ngan xil xa lamal pe meten ha lihur meulien sal.” ");
INSERT INTO tvk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Melele xa Iesu pispisi ni holesok xil ak mi moletin nan xil bus, xi biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nggoni ngan taxa mukila ngamu, melengien lu sutang di, ti, ripol ni Anien te Tavien. E melele nen ak vari, limaen nou, Nat Moletin, nihe he elu navan xil tengan ha liti xat nou e eivave.” ");
INSERT INTO tvk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E melele taxa Iesu di misepin, e tim xa eilep sa Kaeafas xa be vatixar na pris xil, vat xil na pris xil del elda na Siu xil lamei vituei. ");
INSERT INTO tvk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xil di lalang ves suse tengan latal xat xuxus ni Iesu e lavasi vamat vaxo en. ");
INSERT INTO tvk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma labiteni labit, “Rinapol ni ti e melengien te Anien te Tavien vengan, maxani, moletin xil linavae mi xil mun tang.” ");
INSERT INTO tvk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E melele xa Iesu da tamu e metimal te hal Betani, xi ba di ngganien e tim sa Saemon xa, tetiamu, mesien leporsi teat tenben. ");
INSERT INTO tvk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Di, atou tei bemei nim e nggur valit vokon tei xa lapol ni valite ni hat hos tei xa lakesi ni alabasta. Vokon ak, von bos xa bos e mani teni mun nggeih. E xi bemei visal Iesu e rute xa dotan da en, e mideh vokon ak ba xat vatin tengan vapisen merereen nan mini. ");
INSERT INTO tvk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","E melele xa moletin na Iesu xil lapusi, iexil nggati e laseputut ni labit, “?!Veneh ma di purun vokon ak mak!? ");
INSERT INTO tvk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vahos mak mu vahit vaha vapos ni ni mani tova xa eilep. Ti, mani nen mikila vatutou ni hoeo xil.” ");
INSERT INTO tvk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E Iesu mikil naha xa di lasep usili, ma biteni mi xil bit, “?Xamim di mubul xat atou ak veneh? Xi pol ni neta tei xa bos pupu minou. ");
INSERT INTO tvk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vengan hoeo xil liti visal xamim vehakut, e inou, nasakras nate visal xamim vahehi. ");
INSERT INTO tvk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Melele xa mideh vokon ak ba xat tiei navan, xi di misak mesen nou ve tehinen navan. ");
INSERT INTO tvk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Reitin li nabiteni mi xamim, e rute xil vus xa lihithiten longeongen hos usil nou en, xil lihit usil naha xa atou ak tepol ni minou. E isak ni moletin xil linem xati ven.” ");
INSERT INTO tvk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Di, Sudas Eskariot, xa be tei e xil xa labe lu e le tei (12) na Iesu, ba pus vat xil na pris xil. ");
INSERT INTO tvk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xi misis xil bit, “?Xosxa nisa rat Iesu mei ite hemim, ma musa naha minou?” Ma xil labuli silva mani ba duxoh hanutap tei e he xalu mun (30) tengan lisa ni mini. ");
INSERT INTO tvk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ma Sudas maen ni. Di, e melele nen ak ba, xi milang ves suse tengan isa rat Iesu ha ihe hexil ixo en. ");
INSERT INTO tvk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E melengien kokot te Melengien xil te Beret xa Is Tovuol En, moletin na Iesu xil lamei visali e lasisi labit, “?Rute xave iaxa iem bei tengan masak mesen Anien te Tavien en?” ");
INSERT INTO tvk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iesu bit rilomun ni mi xil bit, “Muhe taon te hal Serusalem xa da iaxor, e mukamet moletin tei e rute ak. Muhiteni mini muhit, ‘Titsa bit, “Melengien navan bemei sangas. E inou mei nia Anien te Tavien e tim sam itel moletin navan xil.”’” ");
INSERT INTO tvk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma moletin nan xil laba e lapol ni nggoni ngan taxa Iesu tehiteni mi xil. E rute ak, xil lasak mesen Anien te Tavien en. ");
INSERT INTO tvk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","E melele xa meteneai ba minu, Iesu bemei e dotan e von anien en del moletin nan xil xa labe lu e le tei (12). ");
INSERT INTO tvk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E melele xa di langganien, Iesu bit lelen ni mi xil bit, “Reitin li nabiteni mi xamim, tei e xamim iaxa isa rat nou nihe he elu navan xil.” ");
INSERT INTO tvk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Melele xa lalonge mak, xil lalonge misa pupu, ma xil kekes di lasis Iesu labit, “?Suv midep li, onemi obit inou?” ");
INSERT INTO tvk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu bit rilomun ni mi xil bit, “Reitin, tei e xamim vari xa di mungganien vituei del nou iaxa isa rat nou niha. ");
INSERT INTO tvk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","E be reitin xa inou, Nat Moletin, nimat ixoni ngan xa Vanuvei Eo di misepin ni. !E isa pupu mi ngan xa isa rat nou! Moletin ak, vahos mak mu vahit linapesi ti vengan pangasien xa Hi isa ni mini ihe eilep pupu.” ");
INSERT INTO tvk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Di, Sudas xa isa rati iha misisi bit, “?Titsa midep, onemi obit inou?” Ma Iesu bit rilomun ni mini bit, “Ixoni ngan taxa xouk obiteni.” ");
INSERT INTO tvk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","E melele xa di langganien, Iesu nggur beret e memes Hi ven. Di, bul pasi, e melele xa di miseti mi moletin nan xil, xi biteni bit, “Muhuri mua ni. Ngan ak be tiei navan.” ");
INSERT INTO tvk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Di, Iesu nggur kap xa uaen ba en, memes Hi ven, e melele xa misa ni mi xil, xi biteni bit, “Xamim vus mumu ni. ");
INSERT INTO tvk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Uaen ak be ra navan xa isak ni hitxatien hu te xeih na Hi mei istal e ihe reitin. Reok xa ileh ve moletin xil holu ihe sanien tei iha mi Hi tengan naketeh ti mun nasa mi xil ve tesaen nae xil. ");
INSERT INTO tvk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nabiteni mi xamim, ninamu ti mun uaen ak ituxoh melele xa nimu uaen hu itel xamim e rute xa Tata navan be suv toto en.” ");
INSERT INTO tvk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Melele xa langganien e lakikei ni sisien tei bus, xil lastal e ba labe Vathu te Urvatiei te Olip. ");
INSERT INTO tvk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Melele xa laduxoh Vathu te Urvatiei te Olip, Iesu biteni mi moletin nan xil bit, “E vongien tak, xamim vus mulesae reling nou ixoni ngan xa Hi tesepin ni e Vanuvei Eo xa bit, ‘Inou nihas moletin xa di milaxat sipsip xil, e sipsip san xil liletasil relingi.’ ");
INSERT INTO tvk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","E melele xa nimea rilomun ra maten, inou nitiamu ni xamim ha nite Kaleli.” ");
INSERT INTO tvk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","E Pita mitamea e biteni mini bit, “!Tave ti neta xa moletin sav xil lilesae relinguk, inou ninave relinguk ti vatova!” ");
INSERT INTO tvk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Iesu bit rilomun ni mini bit, “Reitin li nabiteni minuk, e vongien tak, melele xa ut nalan ti mu e tuto xil linakorat ti mu, e xouk uhiteni ihe vatol ngamu xa otakil ti nou.” ");
INSERT INTO tvk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","E Pita biteni nggeih pilei sung bit, “!E‑e, namak ti! !Tave ti neta xa nimat itelak, inou nisakras namiteni xa natakil ti xouk!” E ngan tesav xil mun labiteni nggoni tang. ");
INSERT INTO tvk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Di, Iesu be rute tei xa lakesi ni Ketsemani del moletin nan xil. Melele xa laduxoh rute ak, xi biteni mi xil bit, “Mutotan muti tak e ti mutatil nou. Inou nitiamu niha nisis inggaxor.” ");
INSERT INTO tvk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xi nggur Pita del nat Sepeti xalu latonggusili. E melele xa latoba, nenemien na Iesu basi holu e milonge misa pupu. ");
INSERT INTO tvk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma xi biteni mi xatel bit, “Tinok li polu ni nenexoen, e nalonge lehit ngan xa bit vahas vin nou. Muti tak, e ti mutiketeh itel nou.” ");
INSERT INTO tvk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Di, Iesu mikakao reling xatel vuteili tang, mitingeiril be tan e misis mi Hi bit, “Tata li, xosxa suse sav tova mun da tamu, uhur rat longpangasien ak ihe reling nou li. E onapol ni ti naxoni ngan xa ieok bei, e upol ni ixoni ngan kestang xa xouk iem bei.” ");
INSERT INTO tvk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Di, xi dilomun be visal xatel e mikameti xa di latopat. Ma xi biteni mi Pita bit, “?Midep xiak? ?Mutsakras mutketeh vatel nou vahe haoa tei takes? ");
INSERT INTO tvk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mutketeh e ti mutisis tengan mutnamot ti e melele xa sakpisien xil imei e xamitel. E tinemitel, iemitel bei tengan mutipol ni neta tei xa momal, e vemitel memel.” ");
INSERT INTO tvk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Di, Iesu dilomun ba e misis bit, “Tata li, xosxa suse sav tovuol e be tengan xa nihur vuol ni longpangasien xil ak, ma upol ni ixoni ngan kestang xa xouk iem bei.” ");
INSERT INTO tvk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E melele xa Iesu dilomun, mikameti xa termali latopat mun vengan lasakras latohur xat metenoh natel. ");
INSERT INTO tvk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma xi be reling termali mun, e ba misis be vatol nen ni sisen nan xati tang. ");
INSERT INTO tvk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E melele xa Iesu dilomun bemei visal termali, biteni mi xatel bit, “?Di tamu mutopat? ?Di tamu mutongel? !Topus ti! Taxeak be melele xati xa lisa rat nou, Nat Moletin, nihe he moletin tesa xil. ");
INSERT INTO tvk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","!Tomea, ratoha! Moletin xa isa rat nou, xi tu xa di bemei iaxor.” ");
INSERT INTO tvk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Melele xa Iesu di tamu misepin, Sudas, tei e xil xa labe lu e le (12) nan, mistal. Xi bemei del xat vanut moletin xil xa di laleh xat tiei del homenda xil te vaeen. Xil lamei langgusil nenemien na vat xil na pris xil del elda xil na Siu xil. ");
INSERT INTO tvk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sudas xa tehein xati tengan isa rat Iesu teling xati tehit, “Moletin xa nipesum ni vin, xi vari iaxa be ngan xa iemim bei. Mumei mutal xati.” ");
INSERT INTO tvk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma Sudas mika mal be visal Iesu, pesum ni vin e bit, “Titsa, bos vongien li.” ");
INSERT INTO tvk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","E Iesu bit rilomun ni mini bit, “Tuxoli, pol ni tang vaxoni ngan xa xouk omei ven.” Di, vanut moletin xil ak lamei ladal xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","E moletin tei na Iesu milihi rat tiei te vaeen nan e da xoteh vurang slev tei na vatixar na pris xil. ");
INSERT INTO tvk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","E Iesu misel mini bit, “Singin xat tiei nam mun vate voninen, vengan ngan xil xa di labae del tiei, tiei na mosav xil lihas vini. ");
INSERT INTO tvk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Vahit ngan xa ieok vahei, inou nakila nasis Tata navan, ma vatei takes, vasa vanut masxaxa te vaeen xil lali lu e le (12) xa mahulong tengan mei livae e rin navan. ");
INSERT INTO tvk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","?E vahit napol ni, ma Vanuvei Eo xa bit xati xa holesok xil ak istal imak mei ihe reitin itep?” ");
INSERT INTO tvk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Di, Iesu biles pus vanut moletin xil ak e biteni mi xil bit, “?Veneh ma di muleh tiei e homenda xil te vaeen tengan mei mutal xat nou? ?Munemi mubit inou di nadiamu ni moletin xil tengan ha mavae vatel kavmen nar? !E‑e! Melengien xil ngasen nadotan nade vangit vioh te Nim Eo e di napispisi mi moletin xil e mutamei ti tengan mutal xat nou. ");
INSERT INTO tvk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","E holesok xil vus ak mei mistal tengan vasak ni naha xa provet tetis usili e Vanuvei Eo mei vastal vahe reitin.” E melele xa ladal xati, moletin nan xil vus lalesae relingi. ");
INSERT INTO tvk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ngan xil xa ladal xat Iesu ladela labe tim sa Kaeafas, xa be vatixar na pris xil. E rute ak, titsa xil te rae na Mosis del elda xil na Siu xil labe vituei ngamu ladi. ");
INSERT INTO tvk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E Pita di mika xus e di nggusil vanut moletin xil xa di ladel Iesu laba vuma … laduxoh vioh te tim sa vatixar ak. E rute ak, Pita be vangit vioh e ba dotan del mereketeh xil te nim ak tengan vapus ti xa lipol ni naha mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Vat xil na pris xil del eilep sav xil mun na Siu xil di lalang ni moletin tova xa mei iluvos xa Iesu pol ni tesaen tei xa likila lihasi imat ven. ");
INSERT INTO tvk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","E tave ti neta xa moletin holu lapol ni luvosen ba xat Iesu, latakamet ti neta xa lakila lasa rati ha vamat ven. Di, moletin lu mei lusoh ");
INSERT INTO tvk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","e lusepin mi kaonsel ak lubit, “Xamel matelonge xa moletin ak tehit, ‘Inou nikila nihu len Nim Eo na Hi. Ti, nikili ni mun e melengien tol tang.’” ");
INSERT INTO tvk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma vatixar mitamea e misis Iesu bit, “?Ma midep? Xouk di olong sepinien xa di laso ni ba xatuk. ?Neta tovuol xa obit oviteni?” ");
INSERT INTO tvk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","E Iesu dat votei tang. Ma vatixar misisi mun bit, “E pe met Hi xa meul, inou nasemae ni xouk tengan usepin ni reitinen. ?Reitin xa xouk obe Mesaea, Nat Hi?” ");
INSERT INTO tvk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu bit rilomun ni mini bit, “Nggoni ngan xa di obiteni. E nabiteni mi xamim xa taxeak iha, mupus … ‘Nat Moletin itotan ite ri metu na Hi Suv te Xeihen. !E mupusi imei e ut etan ixo momah xil te tilang hat!’” ");
INSERT INTO tvk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Melele xa vatixar milong sepinien nan, ien mikat xa mikat, dal papas eising nan e mikei nggeih bit, “?!Mulonge!? !Xi misep purun his Hi vari! ?Veneh ma di ralang ni sepinien tova mun tengan vaha xati? !Xamim vus mulonge xa di misep purun his Hi! ");
INSERT INTO tvk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Munemi midep vari?” Xil vus labit rilomun ni labit, “!Momal tang tengan imat!” ");
INSERT INTO tvk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Di, xil lakusah ba xat valnaon e ladi. E rute ngan xil mun lalevesi ");
INSERT INTO tvk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e labit, “?!Xosxa obit obe Mesaea xati, uhit pisi, visi iaxa diuk!?” ");
INSERT INTO tvk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Melele xa Pita di tamu dotan e vangit vioh te nim ma vatixar na pris xil, atuli tei te polien bemei visali e biteni mini bit, “Xouk mun di otehusil Iesu te hal Kaleli.” ");
INSERT INTO tvk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","E Pita muun xole pe met moletin xil bit, “!Tave reitin ti! Inou natakil ti naha xa di obiteni iaxai.” ");
INSERT INTO tvk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Di, Pita mitamea e mikakao ba ve puiteh te vioh. E rute ak, atuli te polien tei mun pusi, ma biteni mi moletin xil bit, “!Moletin ak mun be tei e xil xa di latehusil Iesu te hal Nasaret!” ");
INSERT INTO tvk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma vatei mun, Pita muun xole e bit, “!Pe met Hi, nabiteni reitin xa natakil ti moletin ak vari!” ");
INSERT INTO tvk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tavehi, moletin xil xa dit lasoh lamei visal Pita e labiteni mini labit, “Xouk vari obe moletin tei nan vengan sepinien nam nggoni ngan Kaleli xil tang.” ");
INSERT INTO tvk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E Pita misepin nggeih bit, “!Natakil ti moletin xai vari xa di musep usili iaxai! !Hi isa halesil iha xat nou xosxa sepinien navan be luvosen!” Vatei takes, tuto tei mikorat. ");
INSERT INTO tvk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","E melele xa milonge, Pita minem rilomun ni naha xa Iesu tehiteni mini tehit, “Ut nalan ti mu e tuto xil linakorat ti mu, e xouk uhiteni ihe vatol xa xouk otakil ti inou.” Ma milonge misa xa misa e be reling vangit vioh ak, ba di muis nggeih. ");
INSERT INTO tvk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","E makoe roroh, vat xil na pris xil del elda xil na Siu xil lamei e nenemien tei takes tengan lakin maten mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ma labar xati e ladela be visal Paelet xa be vat te kavmen te rute ak tengan lasa rati vaha mini. ");
INSERT INTO tvk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Melele xa Sudas xa tesa rat Iesu pusi xa lamaen ni tengan Iesu vaha vamat, xi biles nenemien nan e misak tengan vasa rilomun ni silva mani xa be hanutap tei e he xalu mun (30) vaha mi vat xil na pris xil del elda xil. ");
INSERT INTO tvk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xi bit rati bit, “Inou napol misa pupu, vengan natesa rat moletin ak xa tenapol ni ti neta vasa tengan ha vamat ven.” E xil labit rilomun ni mini labit, “Xamem mabit munakil ti. Ngan xai be nam sung.” ");
INSERT INTO tvk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma Sudas mirang lelen mani ak be tan e vangit vioh te Nim Eo, e milesae. Di, ba nggur ao tei e misar xoteh hiraen ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Melele xa ba, vat xil na pris xil ba lale viton silva mani xil ak e labiteni labit, “Mani ak tamese ti vengan xa latexal rat meulien na moletin tei ni. Ma usil rae nar xil, tamal ti tengan raso ni vahe ateli te Nim Eo.” ");
INSERT INTO tvk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Lasep usili, ma lamae e nenemien tei. Ma laleh mani xil ak e ba lapus moletin tei xa di pol ni holesok xil ni tan te pili. Del mani ak, xil langgal rat mavulut tan tei rani tengan mei ihe von tehinen tova xa ti litihin ngan halesav xil en. ");
INSERT INTO tvk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ve rin ak, lakes rute ak ni ‘Tan te Ra’ duxoh xosali. ");
INSERT INTO tvk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma naha xa Hi tehit lelen ni texo provet Seremaea mei be reitin xa bit, “Xil laleh silva mani hanutap tei e he xalu mun (30), xa momal ni mani xa mol‑Isrel xil lateling xati tengan lixal rat meulien nan ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","E del mani ak, xil langgal rat mavulut tan tei ra moletin tei xa di pol ni holesok xil ni tan te pili, nggoni ngan xa Hi Suv tesemae ni minou.” ");
INSERT INTO tvk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E melele xati xa Sudas di misar hiraen, Iesu ba misoh pe met suv Paelet xa be vat te kavmen tete hal Sudea. Di, Paelet misisi bit, “?Midep? ?Be reitin xa xouk obe suv toto na Siu xil?” Iesu bit rilomun ni mini bit, “Nggoni ngan taxa xouk obiteni.” ");
INSERT INTO tvk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","E melele xa vat xil na pris xil del elda xil na Siu xil lasepin ba xati, xi tavit ti neta tengan vatutou ni rin nan. ");
INSERT INTO tvk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma Paelet misisi bit, “?Otalong ti sepinien xil xa di labiteni ba xatuk iaxai?” ");
INSERT INTO tvk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","E Iesu dat votei tang, e tavit rilomun ni ti sepinien nae. Melele xa suv Paelet pus sexien nan, mesep pupu ven. ");
INSERT INTO tvk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Be sexien matu tei na suv Paelet xa, e melengien xati te Anien te Tavien, xi di maen moletin tei xa moletin xil labosei tengan ha ven imase ra nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E melele nen ak, vatxeih tei tete nim te xeih, hisen Barabas xa moletin xil lakil kuhi mak ve sexien tesa xil xa xi di tepol ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ma melele xa suv Paelet pusi xa vanut moletin xil ak mei ladi vituei, misis xil bit, “?Ngan xave iaxa iemim bei tengan nimaen ni ha ven imase: Barabas mu Iesu xa lakesi ni Mesaea?” ");
INSERT INTO tvk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Xi misis xil mak vengan xa pus kila xa vat xil na pris xil latesa rat Iesu mini vengan di lanem misa ni tang. ");
INSERT INTO tvk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","E melele xa suv Paelet di tamu dotan e von koten nan, atou nan misa sepinien tei mini bit, “Onapol ni ti neta naha xat moletin ak, vengan xi momal tevi. Xosali, nanexo pupu ve metuveen tei xa natepusi usili.” ");
INSERT INTO tvk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","E vat xil na pris xil del elda xil na Siu xil lasi petine vanut moletin xil ak tengan lasis Paelet vamaen Barabas ha ven imase e ihas Iesu imat. ");
INSERT INTO tvk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelet ba misis vanut moletin xil ak vatei mun bit, “?Ngan xave e xalu iaxa iemim bei tengan nimaen ni ha ven imase?” Ma xil vus lakei ba ni labit, “!Barabas!” ");
INSERT INTO tvk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Paelet misis xil mun bit, “?Xosxa imaxai, ma nipol ni naha mi Iesu xa lakesi ni Mesaea?” E xil vus lakei be nesao labit, “!Ti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Di, Paelet misis xil mun bit, “?Veneh? ?Xi pol ni naha misa?” E lakei nggeih pilei sung labit, “!Ti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Melele xa Paelet pusi xa misakras vahiles nenemien nae e sangas lapol ni vaeen, xi po oei e mikas hen pe met moletin xil vus. E melele xa di pol ni, xi biteni mi xil bit, “Taxeak, nakas rat ra te maten na moletin ak ra heok, vengan napusi xa xi tapol ni ti neta vasa tengan ha vamat ven. !Ma xosxa imat, ren iti e hemim sung!” ");
INSERT INTO tvk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E vanut moletin xil ak labit rilomun ni mini labit, “!Bos tang, ren iti e hemem itel horamue namem xil mun!” ");
INSERT INTO tvk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma, nggusil eheien nae, Paelet maen Barabas ba ven mase. E mi Iesu, xi misemae ni tengan moletin te vaeen nan xil ha limeas pangasi ni ao te xeih xa sanute di en, ti, litela ha liti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Melele xa lameas pangas Iesu bus, moletin te vaeen xil na Paelet ladela labe vangit vioh te nim mae xa mahulong e lakes viton moletin te vaeen sav xil vus xa ladi vituei tengan lamei. ");
INSERT INTO tvk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xil ladal rat eising na Iesu e lasing xole ni kaliko tei xa pili nggoni ngan na suv toto xil. ");
INSERT INTO tvk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Di, lapol pepamen ni nggoni ngan xa be suv toto tei. Langgil xat vatluvoluv tei ni ao tei xa sanute xil tepiei di en, e lasili xol vatin. Laling liei tei de hen metu, e di latingeiril pepamen pe meten nggoni ngan xa di lasa merereen nae mini. E melele xa di lapol ni, labiteni mini labit, “!O suv toto na Siu xil, xamem di mamerere ni xouk!” ");
INSERT INTO tvk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Di, lakusah ba xati, lalihi rat eitingil ak rani, e labas vatin ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Melele xa lapol pepamen ni bus, langgur rat kaliko te pili ak be relingi, e lasing xole ni eising nan mun. Di, ladela ba tengan ha liti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Melele xa moletin te vaeen xil ladel Iesu laba, xil labisu ni moletin tei e suse, hisen Saemon te hal Saerin. Lamei visali e langgeih xati tengan vapo eivave na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Di, ladel Iesu ba labe nesao e Vathu Kolkota, xa koute teni be ‘Valvat Moletin.’ ");
INSERT INTO tvk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","E rute ak, lasa uaen mi Iesu xa labilesi del neta tei xa mikon. E melele xa Iesu mu pisi, misin ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Di, moletin te vaeen xil ak ladi xati e eivave. E melele xa murur da en, xil di laso daes tengan vapisen ni xa visi e xil iaxa ileh mavulut eising xil na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E rute ak, xil ladotan e di laketeh xole. ");
INSERT INTO tvk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","E eivave nan, ladi xat tisen tei de nesao ni vatin xa bit mesen rin xa ladi xati ven. Tisen ak ladisi labit, ‘Ngan ak be Iesu, suv toto na Siu xil.’ ");
INSERT INTO tvk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","E melele nen ak, lateti xat moletin lu xa lutepol tesa luteti e eivave lu mun. Tei tete rin metu, e tei tete rin meil. ");
INSERT INTO tvk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Melele xa Iesu murur de eivave, moletin xil xa di lakakao langgo visali di lakuvun vatixil e di langue xati ");
INSERT INTO tvk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","labit, “!Ei, xouk xa otehiteni otehit uhu len Nim Eo na Hi, ti, ukili ni mun e melengien tol tang, bos mak mu tengan uteh meulien e xouk mun tang! !Xosxa obe Nat Hi reitin, amei etan reling eivave xai!” ");
INSERT INTO tvk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Usil sexien nen xil tak, vat xil na pris xil, titsa xil te rae na Mosis, del elda na Siu xil mun lapol pepamen ni Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xil labiteni mini labit, “!Mupus ti mu! Xi di teteh meulien e moletin sav xil, e misakras vateh meulien e xi mun tang. !Xosxa be reitin xa xi be suv toto na mol‑Isrel xil, bos xa, taxeak tang, imei etan ra eivave ak! Xosxa imak, ma xamem muke reitin en sung. ");
INSERT INTO tvk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xi miling nenesien nan e Hi e tehiteni tehit, ‘Inou nabe Nat Hi.’ Ma bos, xosxa Hi ien bei moletin xai, ma mei ihur rati.” ");
INSERT INTO tvk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E usil sexien nen tak, moletin tesa xalu xa lateti xat xalu luteti e rin, xalu mun lusep pepamen ba ni. ");
INSERT INTO tvk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E piniae, maluxoluken mei da xol ut xil ngasen e dat mak duxoh haoa tol (3). ");
INSERT INTO tvk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","E melele xa haoa xatel ak mei lattavi, Iesu mikei nggeih nggo sepinien xati nan xa be Arameak bit, “!Ilae! !Ilae! ?Lama sabaktani?” Koute te sepinien ak be, ‘!Hi navan! !Hi navan! ?!Veneh ma ostokovein nou!?’ ");
INSERT INTO tvk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Melele xa rut moletin xil xa lasoh ladi lalonge, xil labit, “?Mulonge? Xi di mikes provet Ilaetsa iaxai.” ");
INSERT INTO tvk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Vatei takes, tei e xil miloh ba, nggur mavulut kaliko tei, e miterir ni be uaen xa mikon. Di, milingi de kusut liei tei e mei misa ni be nesao tengan Iesu vavisi. ");
INSERT INTO tvk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","E rute ngan xil mun labiteni labit, “Veter mu, ratiluvoluv tamu e rapus ti. ?Ilaetsa imei etan mei iteh meulien en, mu namei ti?” ");
INSERT INTO tvk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Di, Iesu mikei nggeih vatei mun, milihi kor ni votiang, di, mat. ");
INSERT INTO tvk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","E melele nen ak vari, kaliko xa mettel xa lalihi dakoe xol ut eo tei e Nim Eo, mesel be rin lu, nggo kusute nesao bemei duxoh kusute etan. E lul tei milil, hat xil mahoe ");
INSERT INTO tvk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","e misak ni von tehinen xil lamahoe e mangang dit mak. E moletin na Hi xil holu xa latelel lateti en, xil lamea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xil labe reling von tehinen nae xil e lakakao. (E melele xa Iesu temea rilomun ra maten, moletin xil holu latepus moletin xil ak e hal Serusalem xa be taon eo na Hi.) ");
INSERT INTO tvk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Melele xa vat na moletin xil te vaeen del moletin nan xil xa di lateketeh xol Iesu lalong lul ak e lapus holesok xil ak testal, ulixil mikan pupu. Xil labiteni labit, “!Reitin li, ngan ak tehe Nat Hi vari tang!” ");
INSERT INTO tvk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E tatit atou vutei xil lasoh ladi nga sotin vuteili ra eivave, e di lapus holesok xil xa di mistal. Tatit atou xil ak di latetutou ni Iesu e Kaleli e latehusili mun latemei e Serusalem. ");
INSERT INTO tvk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E xatel tol xa latemos e atou xil ak tehe Meri te hal Makdela; Meri, nine Temis xal Siosep; e nine horamue na Sepeti xalu. ");
INSERT INTO tvk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sangas ut vamaluxoluk e Sabat mun di bemei sangas. Ma moletin tei be visal suv Paelet, hisen Siosep. Xi te metimal te hal Aramatea e holesok nan holu. Xi mun be tei e xil xa di tehusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Melele xa ba misoh pe met Paelet, xi misisi tengan vamaen tiei na Iesu mini. Ma Paelet misemae ni moletin nan xil te vaeen tengan ha lipo rati e lisa ni mini. ");
INSERT INTO tvk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma Siosep ba poe e pis xole ni kaliko te mieh tei xa memese. ");
INSERT INTO tvk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Di, poe e ba milingi de vangihat te tehinen nan xati xa lateseh moten rohon ni tang. Di, midivin hat tei xa eilep mei dakoe xol puiteh te vangihat ak e be relingi ba. ");
INSERT INTO tvk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri te hal Makdela del Meri tei mun ludotan ludi nga sotin vuteili ra rute ak, momal ni puiteh te vangihat ak. ");
INSERT INTO tvk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Melele xa ut milan e Sabat, vat xil na pris xil del Farasi xil ba lapus suv Paelet. ");
INSERT INTO tvk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xil lamei visali e labiteni mini labit, “Suv, manem xati xa melele xa vat luvosen ak temeul tamu teta, xi tehiteni tehit, ‘Melengien tol mei itavi, e inou nimea rilomun ra maten.’ ");
INSERT INTO tvk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ma usemae ni moletin te vaeen nam xil ha liketeh xol kuh vangihat te tehinen nan ha ituxoh melele xa melengien tol ak mei itavi. Vengan xosxa onapol ni ti, moletin nan xil likila ha likan ni tiei nan. Ti, likila lihithiteni xa xi mea rilomun ra maten. E xosxa holesok xil ak mei istal, ma luvosen kor ak mei isa pilei sung ili luvosen xa tetiamu melele xa xi tehit xi be Mesaea na Hi.” ");
INSERT INTO tvk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Melele xa Paelet milonge mak, xi maen ni e biteni bit, “Bos ngamu. Muleh tatit moletin tova te vaeen, e ha liketeh xol vangihat ak ihusil sexien xa xamim iemim bei.” ");
INSERT INTO tvk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma laba vituei del moletin te vaeen xil ak, e labilit xol hat xa mahulong xa dakoe xol puiteh teni ni tan tepili. Di, laling tatit moletin te vaeen xil ak tengan xil liketeh xole. ");
INSERT INTO tvk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat bus. Di, ut milan e Sande, Meri te hal Makdela del Meri sav mun luba tengan ha lalosao ni vangihat te tehinen na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vatei takes, lul tei milil nggeih vengan masxaxa tei na Hi Suv nggo ut nesao bemei etan. Xi mei midivin rat hat xa tetakoe xol puiteh, e dotan da en. ");
INSERT INTO tvk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Masxaxa ak, tenben minehin pupu nggoni an xa milangas, e eising nan xil mieh xa mieh. ");
INSERT INTO tvk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Melele xa moletin te vaeen xil lapusi, ulixil mikan pupu e lexil malili. Lakiri labe tan e iexil bon pupu, lasakras mun lapol ni ti neta. ");
INSERT INTO tvk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","E masxaxa ak biteni mi atou xalu ak bit, “!Ulimil nakan ti! Nakila xa di mullang ni Iesu xa lateti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E xi tara ti mun inggak. Reitin, xi temea rilomun ngamu ra maten nggoni ngan taxa tehiteni. Lumei ha lupus ti rute xa lateling tiei nan teta en. ");
INSERT INTO tvk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Taxeak tang, multemanon ha mulhiteni mi moletin nan xil mulhit, ‘Iesu mea rilomun tuei ra maten e xi itiamu ni xamim ha ite Kaleli. Xamim ha mupusi e rute ak.’ Ngan ak be sepinien xa Hi misil nou tengan mei nihiteni mi xamil.” ");
INSERT INTO tvk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma rumali lube reling vangihat e luloh temanon luba tengan ha lalihithiteni mi moletin xil na Iesu. Ulixalu mikan, e tave ti neta xa mak, iexalu polu ni sien. ");
INSERT INTO tvk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Melele xa di tamu luba, vatakes, Iesu bisu mi xalu e biteni mi xalu bit, “!Bos makoe! Tomat na Hi iti mi xamil.” Melele xa lupusi, lumei visali, lumot ludal xat len xalu, e lusa merereen nalu mini. ");
INSERT INTO tvk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Di, Iesu biteni mi xalu bit, “Ulimil nakan ti. Ha mulhiteni mi tua navan xil e neketen tengan lihe Kaleli, e ha lipus nou en.” ");
INSERT INTO tvk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Melele xa atou xalu ak di tamu luba, rut moletin te vaeen xil xa di lateketeh xol vangihat ak ladilomun labe Serusalem e ba labit vuol ni holesok xil xa testal mi vat xil na pris xil. ");
INSERT INTO tvk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma vat xil na pris xil lasepin del elda xil na Siu xil e lamei e nenemien tei. Ma langgal moletin te vaeen xil ak ni mani tei xa eilep ");
INSERT INTO tvk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","e labiteni mi xil labit, “Xamim ha muhithiteni muhit, ‘Melele xa matepat vovong, moletin na Iesu xil latemei e hilaep te vongien, e mei latekan ni tiei nan.’ ");
INSERT INTO tvk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma xosxa longeongen teni ituxoh suv Paelet, xamem iaxa musepin e rin namim tengan musikoe xol xamim e xi nasa ti pangasien mi xamim ven.” ");
INSERT INTO tvk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma moletin te vaeen xil ak laleh mani e ba lapol ni nggoni ngan xa xil latehiteni mi xil. Ma longeongen ak mikapis e rute xil vus xa Siu xil ladi en e miloh bemei duxoh xosali. ");
INSERT INTO tvk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma moletin na Iesu xil xa labe tei e le tei (11) xa lateti, xil labe Kaleli e ba labe vathu tei xa Iesu tehiteni ngamu mi xil. ");
INSERT INTO tvk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","E rute ak, iaxa xil lapus Iesu. E melele xa lapusi, lamot mini. E rut moletin nan xil latake reitin kuhi ti mu en. ");
INSERT INTO tvk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Di, Iesu bemei visal xil e biteni mi xil bit, “Tata navan miling holesok xil vus xa di ut nesao e ut etan di e heok. ");
INSERT INTO tvk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ma muha ve moletin xil te kantri xil vus e mupol ni xil mun mei lihe moletin navan xil. E melele xa mei lihusil nou, xamim mubaptaes ni xil e his Hi Tamer, e his Hi Natneli, e his Hi Ninin Eo. ");
INSERT INTO tvk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","E mupispisi mi xil tengan lilong xat holesok xil vus xa natesemae ni mi xamim. E inou, nite visal xamim vehakut ha ituxoh hoxalite te melengien xil xa radi en.” ");
INSERT INTO tvk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngan ak be longeongen hos na Iesu Kristo, Nat Hi. ");
INSERT INTO tvk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Longeongen ak temei rohon mi xir texoni ngan xa tisen na provet Aesea tehiteni melele xa Hi tesepin mi Mesaea tehit, “!Uteong kuhi! Inou nisa eloheoh tei navan tengan isak mesen suse nam. ");
INSERT INTO tvk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lalong rae tei xa di mikei e uruvuol xa bit, ‘!Musak mesen suse na Suv! !Mupol ni suse nan imal!’” ");
INSERT INTO tvk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eloheoh xa Aesea di tehit usili, hisen Sion. Moletin ak tete uruvuol e latekesi ni Sion Baptis vengan tebaptaes ni moletin xil holu tehit, “!Muhiles ra tesaen namim xil! Ti, mumei minou e nibaptaes ni xamim tengan vapisen xa Hi di miketeh bos rilomun mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma moletin xil holu xa holu pupu latexo provins te hal Sudea tetel taon te hal Serusalem latemei visal Sion. Labit rerat tesaen nae xil mini e Sion baptaes ni xil e Oeisal Sodan. ");
INSERT INTO tvk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xi tesing ni eising xa latepol ni ni hili kamel e tetuatu ni mavulut hilbe buluk. Anien an tehe kelmenamen del hani xa di mikameti e uruvuol. ");
INSERT INTO tvk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E xi biteni mi moletin xil bit, “Itutou ni nou, moletin tei xa eilep pupu imei. Xi be eilep mak mu mili nou e natapin ti tengan name slev nan xa ti valeh rat sandel nan. ");
INSERT INTO tvk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inou di nabaptaes ni xamim ni oei tang, e xi ibaptaes ni xamim ni Ninin Eo.” ");
INSERT INTO tvk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E melele xa Sion di baptaes ni moletin xil mak, Iesu nggo Nasaret e provins te hal Kaleli e bemei visali. Di, Sion baptaes ni Iesu e Oeisal Sodan. ");
INSERT INTO tvk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","E melele xa Iesu mea ra oei, miketeh be nesao e pus tilang hat misaha, e Ninin Eo mei dotan en nggoni mae tei. ");
INSERT INTO tvk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","E Hi misepin mini nggo ut nesao bit, “Xouk obe Natuxoli, ngan xa eheien navan da en. E nabesi nou pupu ve xouk.” ");
INSERT INTO tvk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Di, e melele nen ak vari, Ninin Eo misak ni Iesu ba be uruvuol. ");
INSERT INTO tvk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu de rute ak melengien hanutap lu (40) del vuran xil e di nggur sakpisien xil nggo he Temat. E melele xa melengien xil ak bus, masxaxa xil mei ladutou ni. ");
INSERT INTO tvk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dutou ni ngan ak, Iesu milongeong ni xa lateso Sion tehe nim te xeih. Di, Iesu dilomun be provins te hal Kaleli e bithiten longeongen hos na Hi mi moletin xil bit, ");
INSERT INTO tvk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“!Taxeak be melengien xa momal tengan lelaxatien na Hi imei iti visal xir! !Misak ni muhiles meulien namim ra tesaen xil namim, e muling neketen namim iti e longeongen hos nan!” ");
INSERT INTO tvk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Vatei, melele xa Iesu mikakao nggusil seri Oei Kaleli, pus moletin lu te sar meseo en, hisealu Saemon xal Andru xa be tuneli. Pusi xa di luso net nalu be oei. ");
INSERT INTO tvk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","E Iesu mei biteni mi xalu bit, “Lumei luhusil inou. Xosali di mulihi meseo xil tang, e inou nisak ni xamil mulihi moletin xil sung.” ");
INSERT INTO tvk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vatei takes, lustokovein net xil nalu di, e lunggusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E melele xa latkakao latoba vuteili, Iesu pus timue lu mun, hisealu Temis xal Sion, xa lube nat Sepeti. Ludi bot del tamealu e di latdil pilei net natel xil. ");
INSERT INTO tvk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Melele xa pus xalu, vatakes, Iesu mikes xalu tengan lalohusili. Ma, lube reling tamealu e bot del moletin te polien sav xil, e lunggusil Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu mikakao del moletin nan xil labe taon te hal Kapaniam. E Sabat, labe nim te pispisienna Siu xil e Iesu di pispisi mi moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xil vus xa lalong sepinien nan lamesep, vengan xa sexien te pispisien nan misav ni titsa xil te rae na Mosis. Vengan xa melele xa misetu, biteni momal ni xil del xeihen. ");
INSERT INTO tvk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","E melele xa Iesu di tamu pispisi, moletin tei xa ninin tesa da en be vangit nim te pispisien ak. Xi mikei nggeih xat Iesu bit, ");
INSERT INTO tvk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“!Iesu te hal Nasaret! ?!Usak ni naha mi xamem!? ?Omei inggak tengan umu vin xamem? !Inou nakilak, xouk obe Moletin Eo na Hi!” ");
INSERT INTO tvk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu mike xat ninin tesa ak bit, “!Utat votei, e uhe reling moletin ak!” ");
INSERT INTO tvk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Di, ninin tesa ak bas tan ni moletin ak, muis kei, di, be relingi. ");
INSERT INTO tvk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngan xil vus xa lapusi lamesep pupu ni. E di labiteni mi xil mun tang labit, “?Hisit pispisien eah xiak? Moletin ak di misepin del xeihen. E melele xa misemae ni ninin tesa xil tengan lave reling moletin xil, vatakes lalong xati.” ");
INSERT INTO tvk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","E tave nousav ti, longeongen usil naha xa Iesu di pol ni mikapis ba duxoh rute xil vus e provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","E melele xa Iesu be reling nim te pispisien, del Temis xal Sion, latobe tim sa Saemon Pita xal Andru. ");
INSERT INTO tvk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Melele xa laduxoh tim, labit mesen ni mi Iesu xa avu atou kokon na Saemon Pita, mesei dat vet man, ven minggan pupu. ");
INSERT INTO tvk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma Iesu be visali, dal xat hen e dutou ni mitamea. Vatakes, mesien nan be relingi, milonge bos, e ba pol ni anien ae. ");
INSERT INTO tvk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","E vongien nen ak, melele xa eai minu e Sabat bus, moletin xil holu laleh ngan xil xa lamesei del ngan xil xa ninin tesa di e xil lamei visal Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lamei, lamei ba vuma … moletin xil vus te metimal ak mei langgonaxon pupu e puiteh te nim xa xi da en. ");
INSERT INTO tvk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","E Iesu dal rat moletin xil holu ra mesien nae xil, e ngan tesav xil mun, nggol rerat ninin tesa ra xil. E tamaen ninin tesa xil ti tengan lasepin vengan xa lakila xa xi be Mesaea xa Hi tehosei. ");
INSERT INTO tvk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","E makoe roroh, melele xa ut bovoli tamu, Iesu mitamea e be rute tei xa mikila vatasen en e di misis. ");
INSERT INTO tvk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E melele xa Saemon Pita del ngan tesav xil lamea, di lalang ves Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lalang vesi ba vuma … lakameti e labiteni mini labit, “!Moletin xil vus te metimal ak di lalang vesuk!” ");
INSERT INTO tvk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","E Iesu biteni mi xil bit, “Rave metimal sav xil mun xa ladi sangas ni rute ak, vengan namei vari tengan niha nisetu ni longeongen hos na Hi mi moletin xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma, lakapis e rute xil vus e provins te hal Kaleli. E xi di misetu mi moletin xil e nim te pispisien na Siu xil e di nggol rerat ninin tesa xil ra moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Melele xa Iesu di tamu mikapis e provins te hal Kaleli, moletin tei xa mesien leporsi di bas purun tenben xil mei mitingeiril pe met Iesu e dakesi bit, “Xosxa iem bei li, ma ukila upol ni tenbeok mei imese rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Melele xa Iesu pusi, ien misae en. Ma misa hen ba duxoli e biteni mini bit, “Namaen ni. !Nasak ni tenbom mei memese ngamu!” ");
INSERT INTO tvk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","E melele nen ak vari tang, mesien ak be relingi e tenben mei memese rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Di, Iesu misemae mini bit, ");
INSERT INTO tvk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Onahit rat naha ti xa natepol ni minuk mi moletin tova. E uhe Nim Eo kestang tengan uhit rat rin nam mi pris tei, e usa sanien eo nam mi Hi ixoni ngan xa Mosis tehiteni. Imak, ma ngan xil xa lilepis tenbom lipus kila xa xouk omese tevi.” Di, Iesu misil moletin ak ba. ");
INSERT INTO tvk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","E melele xa moletin ak be reling Iesu, xi mikapis e rute xil vus e buhu raen holu bit usil naha xa Iesu tepol ni mini. Mak, ma vengan xa vanut moletin xil mei labe mahulong pupu, Iesu misakras mun vahe metimal xil. E neta sav xa Iesu da nga ut xil xa labe sotin ra metimal xil, moletin xil lakakao langgo rute xil vus tengan mei lapusi. ");
INSERT INTO tvk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Melengien vahis mei mitavi, e Iesu dilomun be taon te hal Kapaniam. E moletin xil te rute ak lalongeong ni xa de tim. ");
INSERT INTO tvk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma moletin xil holu mei lapolu e nim ak, e moletin xil holu mun dit lasoh e hale. E Iesu di misetu ni sepinien na Hi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Melele xa Iesu di tamu misetu, moletin hat (4) lamei e lapo moletin tei xa misakras vakakao de suon man tengan lalingi pe met Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","E vengan xa moletin xil langgonaxon pupu, lapusi xa lasakras lave sangas visal Iesu. Ve rin ak, xil lapeou labe hilim nesao, ladal rerat rut hilim ak momal ni rute xa Iesu da en, e lapol ni mei be mesal tei. Di, lasae ni moletin ak de suon man be tan e rute xa Iesu da en. ");
INSERT INTO tvk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","E melele xa Iesu pus naha xa xil lapol ni, pus kil neketen nae e biteni mi moletin ak bit, “Tuxoli, xosali, inou naserev rin nam ra tesaen nam xil pe met Hi.” ");
INSERT INTO tvk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E melele xa titsa xil te rae na Mosis xa ladotan inggak lalong sepinien xa Iesu biteni, laseputut ni nggo nenemien nae labit, ");
INSERT INTO tvk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“?Veneh ma moletin xai di misa hisit sepinien ak ba xat Hi? !Xi di pet rat tasen ni xi bit xi pipin ni Hi vari! Vengan xa Hi kestang mikila vaserev rin na moletin xil ra tesaen nae xil pe meten.” ");
INSERT INTO tvk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Melele xa di lanem usil holesok xil ak, Iesu mikil nenemien nae, ma biteni mi xil bit, “?Veneh ma di munem mak? ");
INSERT INTO tvk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Temale tang tengan namiteni mi moletin ak xa misakras vakakao namit, ‘Naserev rin nam ra tesaen nam xil pe met Hi’ vengan xa musakras mupusi xosxa nanggur xeihen tengan nipol ni. E nggeih tengan namiteni mini namit, ‘Utamea, uvulun suon mam, e ukakao uha,’ vengan xa xamim ti mupus kila xosxa nanggur xeihen tengan nipol ni. ");
INSERT INTO tvk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","E tengan xamim mupus kila xa Nat Moletin nggur xeihen e ut etan tengan vaserev rin na moletin xil ra tesaen nae xil e tengan vasak ni moletin xil mei vahos rilomun, mupus ngan ak …” Di, Iesu biles, pus moletin xa misakras vakakao e biteni mini bit, ");
INSERT INTO tvk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“!Nabiteni minuk, utamea, uvulun suon mam, e utilomun uhe tim!” ");
INSERT INTO tvk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vatakes, pe met moletin xil, moletin ak mitamea, bulun suon man e poe ba be reling xil. Melele xa moletin xil lapusi mak, latemanin e lapet rat his Hi labit, “!Ueee la la li! !Ratapus ti mu neta tova xa vamak!” ");
INSERT INTO tvk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Di, Iesu be reling rute ak e mikakao ba be seri Oei Kaleli. Moletin holu mei lakapis xole e xi di pispisi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","E melele xa Iesu di mikakao ba, xi pus moletin tei xa dotan de nim te polien nan xa hokorong, hisen Matiu Livae, nat Alveas. Xi di mileh takis ra Siu xil tengan vasa ni sung vaha mi kavmen te hal Rom. E melele xa Iesu pusi, mikesi bit, “!Amei! !Uhusil xat inou e mei uhe moletin tei navan!” Ma Matiu Livae mea, mistokovein polien nan xil, e nggusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dutou ni, Iesu del moletin nan xil labe tim sa Matiu Livae e ladotan del moletin hao te takis e moletin sav xil mun xa lasa pe met Siu xil xa latehusil Iesu latehe nim ak. E melele xa Iesu del moletin nan xil ladotan e di langganien vituei, rut moletin tesa sav xil ak di langganien vituei del xil. ");
INSERT INTO tvk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Rut titsa xil te rae na Mosis, xa labe Farasi xil mun, lapusi xa Iesu di ngganien del moletin xil te takis del moletin tesa sav xil. Misak ni, xil lasis moletin xil na Iesu labit, “?Veneh ma titsa namim di ngganien del hisit moletin tesa xil xa lamak?” ");
INSERT INTO tvk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","E melele xa Iesu milonge, biteni mi xil bit, “Moletin xil xa lanemi labit lamal ngamu iexil ti tavei tengan lava lapus tokta. E ngan xil kestang xa lakila xa lamesei iexil bei tengan lapus tokta. Ma inou natamei ti tengan nakes moletin xil xa lanemi labit lamal ngamu tengan lihiles e lihusil inou. E‑e, namei tengan nakes ngan xil xa lapus kil mesien te tesaen nae xil tengan lihiles meulien nae e lihusil nou.” ");
INSERT INTO tvk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vatei, e melele xa moletin xil na Sion Baptis del Farasi xil di labal ni anien, rut moletin xil mei lasis Iesu labit, “Moletin na Sion xil del Farasi xil di labal ni anien tengan lasis. E mapusi xa moletin nam xil latapol ni ti sexien ak. ?Veneh vari?” ");
INSERT INTO tvk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma, Iesu dei vole ak mi xil bit, “Melele xa moletin tei miteli, ngan xil xa lamei ve anien nen ak, labesi xil, ma lasakras laval ni anien e melele xa xi da tamu visal xil. ");
INSERT INTO tvk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","E melengien xil ti imei xa moletin xil mei lihur rat ngan xa miteli ihe reling xil. E melengien ak vari, xil lilonge isa ven e lihal ni anien sung.” ");
INSERT INTO tvk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Di, Iesu dei vole tei mun mi xil bit, “Moletin tovuol xa vatil xol eising matu tei vatel saxut kaliko tei xa be neta hu. Vengan melele xa ikasi, kaliko xa be neta hu mei ileten pupu, ma ital papas eising matu ak e mei imeseh mak mu. ");
INSERT INTO tvk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","E suse nen ak, moletin tovuol vateh uaen hu vahe valite matu tei xa lapol ni ni hilbe sipsip vengan nggeih ngamu. Vengan xa xosxa ipol ni, ma uaen hu ak isak ni valite teni ikaio e imahoe. Maxani, valite ak isa, e uaen imie ihe tan. Misak ni, moletin xil ti liteh uaen hu ihe valite xa be neta hu vengan xa memerou tamu e mikila ikaio. Imak, ma valite teni ihos e uaen mun xa di en ihos.” ");
INSERT INTO tvk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","E Sabat tei, Iesu del moletin nan xil langgur xoteh naho tei te uit. E melele xa di lakakao laba, mae nggat moletin nan xil, ma di laki xoteh utut uit xil e di langga ni. ");
INSERT INTO tvk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","E melele xa Farasi xil lapusi, lasepin mi Iesu labit, “Pus ti mu. Moletin nam xil di lapol ni polien tei xa nggur xoteh rae na Mosis usil Sabat.” ");
INSERT INTO tvk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","E Iesu bit rilomun ni mi xil bit, “?Midep? ?Xamim mutavuli ti naha xa suv toto Deved e moletin nan xil latepol ni melele xa mae teat xil e iexil tehei pupu tengan lavanien ti? ");
INSERT INTO tvk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Deved tehe vangit Nim Tavolin na Hi e tehur beret eo teni. Ngan ak testal e melele xa Abiatar tehe vatixar na pris xil. E xi temaen suv toto Deved tengan vahur beret ak, neta sav xa pris xil kestang lakila lava ni, e Deved tesa ni sung mi moletin nan xil tengan lava ni.” ");
INSERT INTO tvk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Di, Iesu bit kil koute te sepinien nan mi xil bit, “Hi tepol ni Sabat tengan vatutou ni moletin xil. Tenapol ni moletin xil ti tengan latutou ni Sabat. ");
INSERT INTO tvk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mak iaxa, Nat Moletin be Suv te holesok xil vus, e te Sabat mun.” ");
INSERT INTO tvk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu dilomun be nim te pispisien. E moletin tei de rute ak xa hen misa. ");
INSERT INTO tvk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","E rut moletin xil mun ladi xa iexil bei tengan lalang ves neta tova xa misa xa Iesu pol ni. Ma, di lale mah xat Iesu tengan lapus pisi xos ipol ni he moletin ak mei ihos rilomun e Sabat. ");
INSERT INTO tvk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Misak ni, Iesu mikes moletin ak tengan mei vasoh pe met moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Di, misis moletin sav xil bit, “?Rae na Mosis di maen xir tengan rakila rapol ni naha e Sabat? ?Tengan ritutou ni moletin, mu ripurun ni? ?Tengan riteh meulien en, mu rihas vini?” E xil latavit ti neta mini. ");
INSERT INTO tvk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E melele xa Iesu miketeh mikapis xol xil, ien nggat xil. E melele nen mun tak, ien misae e xil vengan xa nenemien nae bon pupu. Di, Iesu biles biteni mi moletin xa hen misa bit, “!Tei momal ni hem!” E melele xa dei momal ni, hen mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","E melele xa Farasi xil lapusi, lastal e, vatakes, ba lamos del rut Siu xil xa di lasuv xat lelaxatien na suv toto Herod, e lasep ves suse tova tengan lavas vin Iesu vaxo en. ");
INSERT INTO tvk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu del moletin nan xil labe Oei Kaleli, e moletin holu mun langgusili: ngan xil te provins te hal Kaleli, Sudea, ");
INSERT INTO tvk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","e Itumea; e ngan xil te taon te hal Serusalem, Taer e Saedon; e ngan xil mun xa langgo rin sav te Oeisal Sodan. Moletin xil vus ak lamei visal Iesu vengan xa lalongeong ni naha xa xi di pol ni. ");
INSERT INTO tvk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","E vengan xa xil labe holu mak e di langgonaxon pupu, Iesu biteni mi moletin nan xil bit ha lisak mesen bot tei xa ikila itotan en tengan moletin xil linating xati ti. ");
INSERT INTO tvk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngan xil xa lamesei lating mak vengan xa lapusi xa Iesu di pol ni moletin xil holu ngamu mei labos rilomun, e labit lituxoli tengan xi isak ni mesien nae ihe reling xil. ");
INSERT INTO tvk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","E melele xa ngan xil xa ninin tesa di e xil lapusi, xil mei latingeiril mini, e lamuis kei labit, “!Xouk obe Nat Hi!” ");
INSERT INTO tvk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","E Iesu mike xat ninin tesa xil ak nggeih bit linavit rati ti mun xa xi be visi. ");
INSERT INTO tvk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Di, Iesu be nesao e hu tei e mikes viton moletin xil xa ien bei tengan lihusili, e lamei visali. ");
INSERT INTO tvk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Di, bosei lu e le tei (12) e xil tengan mei lihe eloheoh nan xil, lihusil xati, e ha lihithiten longeongen hos mi mosav xil, ");
INSERT INTO tvk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","e lihol rerat ninin tesa xil ra moletin xil ixo xeihen te hisen. ");
INSERT INTO tvk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E ngan ak be his na eloheoh xil xa labe lu e le tei (12) xa Iesu bosei xil: Saemon (xa Iesu miling hisen tei mun be Pita); ");
INSERT INTO tvk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Temis del tuneli Sion xa Iesu tekes xalu ni ‘nat veta xalu’ (xa tamealu Sepeti); ");
INSERT INTO tvk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Batalomiu, Matiu, Tomas, Temis (nat Alveas), Tatios, Saemon (xa temos e vanut moletin tei xa iexil bei pupu tengan lameluv ra he mol‑Rom xil); ");
INSERT INTO tvk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Sudas Eskariot xa tesa rat Iesu tehe he moletin tesa xil. ");
INSERT INTO tvk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Melele xa Iesu bosei eloheoh nan xil bus, labe nim tei e taon te hal Kapaniam, e moletin xil holu lamei tengan lapusi. Misak ni, mesal tovuol mun tengan Iesu e moletin nan xil lavanien. ");
INSERT INTO tvk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","E melele xa ninen e tua na Iesu xil lalongeong ni xa moletin xil di labiteni xa Iesu di pol talang, xil laba tengan lasep xole e ladal xati. ");
INSERT INTO tvk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","E titsa xil te rae na Mosis latexo Serusalem, e mei laso sepinien ba xat Iesu labit, “Belsepul di mise xat moletin ak. Vengan xi be suv toto na ninin tesa xil, e di misa xeihen mini tengan vahol rerat ninin tesa xil ra moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Misak ni, Iesu mikes Farasi xil lamei visali e misepin mi xil nggo vole xil ak bit, “?Temat mikila ihol rat xi mun tang itep? ");
INSERT INTO tvk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xosxa moletin xil na suv toto tei di labae mi xil mun tang, ma xeihen na suv toto ak mei ihe neta sav tang. ");
INSERT INTO tvk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","E xosxa vatimol tei di labae del xil mun tang, ma his vatimol ak ikesae. ");
INSERT INTO tvk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma xosxa Temat di minggol rerat ninin tesa nan xil, ma xi di bae mi xi mun tang. Xosxa imak, ma xeihen nan ihe relingi mei ihe neta sav tang. ");
INSERT INTO tvk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nihit kila mi xamim ixo vole tei. Moletin tei misakras vahe nim ma silixin tei tengan valeh rerat holesok nan xil melele xa xi di tamu miketeh xole. Itiamu, ha ivar xat silixin ak. Ti, ikila ihe nim man e ileh vuol ni holesok nan xil vus. ");
INSERT INTO tvk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Reitin li nabiteni mi xamim, Hi mikila iketeh ihos rilomun mi ngan xil xa lapol ni hisit tesaen xil holu, mu lasep purun his Hi mun tang. ");
INSERT INTO tvk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","E moletin xil xa lasep purun Ninin Eo e polien nan, Hi misakras vaketeh vahos rilomun mi xil. Tesaen ak iti xat rin nae iha vuma … hoxalite teni ihe tovuol.” ");
INSERT INTO tvk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu biteni mak vengan xa Farasi xil latehit xi di pol nggo xeihen na ninin tesa tei xa da en. ");
INSERT INTO tvk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma di, nine Iesu del tuneli xil lamei, e lasoh ladinga hale e nim xa da en. E lasa sepinien be nim tengan Iesu mei vapus xil. ");
INSERT INTO tvk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E melele nen ak, moletin holu di ladotan lakapis xol Iesu, e xil labiteni mini labit, “Pus ti mu. Ninom e tumali xil ladi nga hale, e labit lapusuk.” ");
INSERT INTO tvk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","E Iesu misis xil bit, “?Ninok be visi? ?E tuxoli xil labe visi?” ");
INSERT INTO tvk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Di, miketeh mikapis xol moletin xil xa di ladotan xorelisi e biteni mi xil bit, “Mupus ti, ngan xil ak labe nana navan xil e ngan xil ak labe tuxoli xil. ");
INSERT INTO tvk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngan xil xa di lapol ni naha xa Hi ien bei, xil labe nana navan xil del tuxoli e hinoxoli xil.” ");
INSERT INTO tvk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Di, Iesu ba mun e seri Oei Kaleli, e pispisi mi moletin xil inggak. E vengan xa vanut moletin xil holu pupu lakapis xole, Iesu be bot tei e ladivin rati vuteili ra ut. E vanut moletin xil lasoh ladi nga ut. ");
INSERT INTO tvk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Di, Iesu dei vole xil holu mi xil tengan vapispisi mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“!Muteong kuhi! Vatei, moletin tei be naho tengan vaso utiei xil en. ");
INSERT INTO tvk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E melele xa di miso ni, rut utiei xil lamot e suse xa tan nen nggeih, e tuman xil mei langga ni. ");
INSERT INTO tvk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Rut utiei xil lamot e tan xa hat xil holu di en e tan nen mehin tang. E inggak, utiei xil ak lateh manon vengan xa tan mehin. ");
INSERT INTO tvk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","E melele xa eai bemei nesao, ngga vin ngan xil xa lateteh, e lameles lamat. Lamat vengan xa amulite xil tave tan pupu ti. ");
INSERT INTO tvk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Rut utiei xil mun lamot e tan xa munae tesa xil di lameul en. E melele xa lateh, munae tesa xil ak lameul xol vin xil. Misak ni, lataso huite ti. ");
INSERT INTO tvk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","E rut utiei xil ak lamot e tan xa bos. Ma xil lameul bos, e laba ni huite xil. Ngan xil, laba ni huite xil holu; ngan xil mun laba ni huite xil holu mak mu; e ngan tesav xil mun, xil iaxa ladaxao xa ladaxao ni huite xil.” ");
INSERT INTO tvk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Di, Iesu biteni mi xil bit, “!Xosxa vurangemim di, muteong kuhi ni naha xa di nabiteni!” ");
INSERT INTO tvk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Melele xa Iesu ba da tasen, rut moletin xil del moletin lu e le tei (12) nan lamei visali e lasisi tengan ihit kil koute te vole xil ak mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma, xi biteni mi xil bit, “Xamim iaxa Hi tehosei xamim tengan mukil koute te sepinien xuxus usil itep xa xi mei ihe suv toto na moletin nan xil. E moletin sav xil xa Hi tave suv toto nae ti, xil lalong sepinien nan nggo vole xil kestang xa latalong kil ti. ");
INSERT INTO tvk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hi tesep usili tehit, ‘Xil liteong vuma … e linalong kil ti neta. Liketeh vuma … e linapus kil ti neta. Vengan xosxa linamak ti, ma lihiles meulien nae, e Hi iketeh ihos rilomun mi xil.’” ");
INSERT INTO tvk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Di, Iesu biteni mi xil bit, “?Reitin xa xamim mutakil ti koute te vole ak? ?Imak, ma mikila mukil koute te vole sav xil itep? ");
INSERT INTO tvk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ma, vole ak, moletin ak miso utiei xil xa be sepinien na Hi. ");
INSERT INTO tvk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rut moletin xil, tinexil nggoni suse xa tan nen nggeih xa utiei xil ak lakiri en. E melele xa lalong sepinien na Hi, Temat mitemanon bemei e nggur rat sepinien xa mot de tinexil. ");
INSERT INTO tvk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","E rute sav xil, tinexil nggoni tan xa hat xil holu di en. E melele xa lalong sepinien na Hi, vatakes, langguri del sien. ");
INSERT INTO tvk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","E vengan xa amulit neketen nae tameul ti mu, lasoh vuteili e neketen nae. E melele xa labisu ni sakpurunien mu melengien xil te xeih ve sepinien ak, vatei takes, lamot e neketen nae. ");
INSERT INTO tvk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Moletin sav xil, tinexil nggoni tan xa munae tesa xil di lameul en. Lalong sepinien na Hi, ");
INSERT INTO tvk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","e lanexo pupu ve holesok xil te ut etan e eheien nae di e mani mak mu mili. Ma holesok xil ak di lameul xol vin sepinien na Hi xa langguri, ma tava ni ti huite e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","E moletin sav xil mun, tinexil nggoni tan xa bos. E melele xa lalong sepinien na Hi, lalong kila e langgur xati be nae. Ma, e meulien nae, sepinien nen ak ba ni huite. E meulien na rut moletin xil, ba ni huite xil holu; e ngan tesav xil, ba ni huite xil holu mak mu; e ngan tesav xil mun, sepinien ak daxao xa daxao ni huite xil e meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu dei vole tei mun mi xil bit, “Moletin tovuol tamu xa vasahan laet nan, ti, vaha vaso xati ni pesin mu vaha valingi vate pe vet man. E‑e. Vehakut, melele xa moletin tei misahan laet bus, misoxolen ni de nesao e voninen. ");
INSERT INTO tvk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nggo rin ak, holesok xil xa di minggus mu di lasepin xuxus ni, Hi isak ni imei kesao tengan moletin xil vus likila. ");
INSERT INTO tvk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xosxa vurangemim di, muteong kuhi ni naha xa di nabiteni.” ");
INSERT INTO tvk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Di Iesu biteni mun mi xil bit, “Muteong kuhi ni neta xil vus xa nabiteni mi xamim. Vengan Hi isa kilakilen teni mi xamim ipin ni longxatien namim. Ma xosxa mulong xati, ma isa kilakilen te sepinien nan mak mu mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma ngan xil xa langgur sepinien navan xil e langgusili, Hi ipol ni xil likilakil kuhi mu. E ngan xil xa latahusil ti neta xa langguri, hokorong xa langguri ngamu, Hi ileh rat sen ni ra xil.” ");
INSERT INTO tvk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma di, Iesu dei vole teimun mi xil bit, “Lelaxatien na Hi nggoni utiei xil xa moletin tei miso ni e naho san. ");
INSERT INTO tvk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","E tave ti neta xa moletin ak di pat e vongien, e di bovarang e melengien, utiei xil ak di lateh e lameul. E moletin ak takil ti xa di lameul midep. ");
INSERT INTO tvk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Be tan tang iaxa di pol ni utiei xil lameul. Reitin, lateh, lameul labe nesao, e mei laso huite xil. ");
INSERT INTO tvk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","E melele xa huite xil men, moletin te naho ba midei e milehi be tim.” ");
INSERT INTO tvk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E Iesu misis moletin xil bit, “?Lelaxatien na Hi nggoni naha vari? ?Nihit kila mi xamim ixo vole eah? ");
INSERT INTO tvk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lelaxatien nan nggoni utut vaak tei xa be hokorong mak mu ni utiei sav xil xa di lameul e tan. ");
INSERT INTO tvk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","E melele xa matu, xi mei be vatiei tei xa eilep mak mu mili vatiei savsav xil xa halite xil mahulong pupu, pipin tengan tuman xil mei lipol ni nunum mae xil en.” ");
INSERT INTO tvk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nggo vole xil xa lamak, Iesu misa sepinien na Hi mi moletin xil, pipin ni naha xa lakila lavuri. ");
INSERT INTO tvk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mi vanut moletin xil, Iesu misepin nggo vole xil kestang. E melele xa da tasen del eloheoh nan xil, ma misep kil koute te vole xil ak mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","E melengien nen ak, melele xa ut mei maluxoluk, Iesu biteni mi moletin nan xil bit, “Rava ravur xoteh Oei Kaleli ak.” ");
INSERT INTO tvk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Misak ni, labe reling moletin sav xil ladi, e eloheoh xil labe bot xa Iesu di dotan en. Di, langgur xoteh Oei Kaleli e rut moletin sav xil mun langgusil Iesu langgo bot nae xil. ");
INSERT INTO tvk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","E melele xa di lalis laba, Iesu por sae e vangit bot. E tavehi ti, latemanin, votiang te xeih tei mea. Ngan ak misak ni oei nggelial holu, e tahe xil bemei e bot e di mise vangite. E Iesu milung de pilo tei e por vovong. Melele xa moletin nan xil lapus naha xa mistal, ulixil mikan pupu e ba lasiasi ni labit, “!Titsa, sangas mamat xiak! ?!Otanem ti xamem!?” ");
INSERT INTO tvk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma Iesu mitamea, e mike xat votiang xal oei bit, “!Luhe tan!” Vatakes, xalu vus lube tan, e an mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Di, biteni mi moletin nan xil bit, “?Veneh ma ulimim mikan mak? ?Neketen namim tovuol tamu?” ");
INSERT INTO tvk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Melele xa moletin nan xil lapusi mak, latemanin e lasis pilei xil mun tang labit, “?Moletin ak be hisit moletin eah? Neta sav xa votiang e oei, xalu mun di lulong xat raen.” ");
INSERT INTO tvk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu del moletin nan xil lamei ut e ri Oei Kaleli, e tan na moletin xil te metimal te hal Kerasa. ");
INSERT INTO tvk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","E melele xa Iesu mea reling bot, moletin tei xa ninin tesa da en nggo vangihat xil xa be von tehinen bemei visali. ");
INSERT INTO tvk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Moletin ak di pat e vangihat te tehinen xil ak. Moletin xil latesak pisi tengan lavar xati ni sen xil te xeih, e lasakrasi. ");
INSERT INTO tvk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vengan xa melele xil vus xa latevar xat hen e len, xi tetal xoteh sen xil xa latevar xat hen xalu ni, e teti xoteh aean xa di dakoe xol len xalu. E moletin ti taxeih vapin tengan vatal xati. ");
INSERT INTO tvk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Melengien e vongien xil, moletin ak di mikapis e von tehinen e hu xil xa di sangas. E vehakut, di muis kei nggeih e di dapas tenben ni hat xil xa mikan. ");
INSERT INTO tvk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Melele xa moletin ak pus Iesu da tamu sotin, miloh ba ni e mitingeiril pe valnaon. ");
INSERT INTO tvk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Di, muis kei bit, “?Iesu, Nat Hi xa be eilep mak mu mili, obit upol ni naha minou? !Uhit xati minou li e his Hi xa onasa longpangasien minou ti!” ");
INSERT INTO tvk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Biteni mak vengan xa Iesu tesemae ni ninin tesa ngamu tengan ihe reling moletin ak. ");
INSERT INTO tvk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Misak ni, Iesu misisi bit, “?Hisom visi?” E moletin ak bit rilomun ni mini bit, “!Hisok Vanute! Vengan xa mabe vanut ninin tesa xil holu iaxa madi xat moletin ak.” ");
INSERT INTO tvk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Xi midakes Iesu tengan nasil rerat xil ti linave reling tan xa ladi en. ");
INSERT INTO tvk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sangas ni rute ak, vueili xil holu di langganien e seri hu. ");
INSERT INTO tvk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Misak ni, ninin tesa xil ak ladakes Iesu labit, “Maen xamem mava xat vueili xil xa iaxor.” ");
INSERT INTO tvk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma Iesu maen ni tengan lava. Ma ninin tesa xil ak, labe reling moletin ak, e laba xat vueili xil ak sung. E vueili xil xa sangas lave taosen lu (2000) laloh laba lakiri langgo meteh labe oei. E xil vus lamerir lalel. ");
INSERT INTO tvk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Melele xa moletin xil xa di lalaxat vueili xil ak lapus neta xa mistal, latemanon laba, labithiteni e taon e rute sav xil mun xa ladi sangas. Di, moletin xil xa lalongeong ni laba labit lapus ti naha xa testal xiak. ");
INSERT INTO tvk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma laba labe visal Iesu, e lapus moletin xa vanut ninin tesa xil latehe relingi. Nenemien nan mei bos ngamu, mising ni eising, e di dotan visal Iesu. Ma melele xa lapus kila xa be xi xa vanut ninin tesa xil lateti en, moletin xil ak ulixil mikan pupu. ");
INSERT INTO tvk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","E ngan xil xa latepus naha xa testal e rin te moletin xa ninin tesa xil lateti en, e rin te maten na vueili xil mun, xil di latumul usili mi moletin sav xil. ");
INSERT INTO tvk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Misak ni, moletin xil ladakes Iesu tengan vahe reling tan nae. ");
INSERT INTO tvk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Misak ni, Iesu ba mun be bot tengan vahe reling xil. E moletin xa ninin tesa xil lateti xati be visal Iesu e dakesi tengan vahusili. ");
INSERT INTO tvk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","E Iesu tamaen ni ti. E biteni mini bit, “Utilomun uhe tim sam e upus timue nam xil. Ti, uhithiteni mi xil naha xa Hi Suv tepol ni e meulien nam, e tetep iaxa tepisen esaeen nan minuk.” ");
INSERT INTO tvk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma moletin ak ba mikapis e rute xil vus te taon he xalu (10) xa lakes xil ni Dekapolis e di misep usil sexien hos xa Iesu tepol ni mini. E ngan xil vus xa lalonge lamesep pupu. ");
INSERT INTO tvk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Melele xa Iesu nggur xoteh Oei Kaleli vatei mun, vanut moletin tei xa mahulong ladatili ladi e ut, e mei lakapis xole. ");
INSERT INTO tvk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Di, moletin tei bemei e mitingeiril pe le Iesu, hisen Saeros. Xi be vat tei te nim te pispisienna Siu xil. ");
INSERT INTO tvk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","E mei di dakes Iesu tengan vatutou ni bit, “Atuli navan sangas li vamat xiak. Ieok bei mei uling hem en tengan mei ihos rilomun e imeul.” ");
INSERT INTO tvk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Misak ni, Iesu nggusili luba. E melele xa Iesu di ba, moletin xil labe holu pupu xa di langgusili e langgonaxon e rin xil vus. ");
INSERT INTO tvk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Di, latakil ti, e atou tei xa temos e vanut moletin xil ak bemei sangas visali. Xi temesei huram lu e le tei (12) ni mesien na atou xil xa misakras vavus. ");
INSERT INTO tvk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atou ak teha tepus tokta xil holu xa latepol ni holesok hao mini tengan vatal rati ra mesien nan, e latesakrasi. Xi tesa sen mani nan xil mi tokta xil ak, e talonge ti vahos. Mesien nan mei misa pilei sung. ");
INSERT INTO tvk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Atou ak telongeong usil Iesu, ma bemei pe tou Iesu del vanut moletin sav xil, misa hen e duxoh eising nan. ");
INSERT INTO tvk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Atou ak pol ni mak vengan xa minemi bit, “Xos xa nituxoh eising nan tang, ma nilonge ihos vari.” ");
INSERT INTO tvk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E melele xa duxoli, vatakes, mesien nan bus relingi. E milong kila xa tenben mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E melele nen tak, Iesu mikila xa xeihen xa di en tepol ni neta ngan mi moletin. Ma biles, pus vanut moletin xil ak e misis xil bit, “?Visi iaxa duxoh eising navan?” ");
INSERT INTO tvk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eloheoh nan xil labiteni mini labit, “?Opusi? Vanut moletin xil ak di langgonaxon pupu e di laduxoluk e rim xil vus. ?Misak ni, veneh ma di olang ves moletin xa duxoluk?” ");
INSERT INTO tvk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","E neta sav xa mak, Iesu nggulehi di milang ves ngan xa duxoli. ");
INSERT INTO tvk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Atou ak milong kila xa tenben mei bos rilomun, ma bemei visal Iesu, len mulul, e mitingeiril pe valnaon. Di, bit rat sen tumulen te mesien nan mini. ");
INSERT INTO tvk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","E Iesu biteni mini bit, “Hinoxoli, neketen nam misak ni mei olonge bos e omese ra mesien nam. !Bos! Uha, e tomat iti minuk.” ");
INSERT INTO tvk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Melele xa Iesu di tamu misepin, rut moletin xil langgo tim sa Saeros lamei, e labiteni mini labit, “Atuli nam mikesae ngamu. Ma onasis ti mun titsa xai tengan nakon namei.” ");
INSERT INTO tvk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu milong naha xa xil labiteni e xi biteni mi Saeros bit, “Ulum nakan ti. Uneket tang.” ");
INSERT INTO tvk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Xi nggur Pita, Temis del Sion (xa be tuneli Temis) e tamaen ti mun mosav xil tengan lavusili. ");
INSERT INTO tvk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Melele xa laduxoh tim sa Saeros, lapus moletin xil di latangal pupu. Di lamuis e di ladang ve atuli ak. ");
INSERT INTO tvk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Di, Iesu be vioh te nim ak e biteni mi xil bit, “?Veneh ma di mutangal e di mudang mak? Atuli ak tamat ti, di pat tang.” ");
INSERT INTO tvk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","E moletin xil langue xati. Misak ni, Iesu misil rat xil ra vangit nim, e nggur tame atuli ak xal ninen kestang del moletin nan tol labe rute xa laling atuli ak da en. ");
INSERT INTO tvk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Di, Iesu misasa dal xat hen e biteni mini nggo sepinien nae bit, “!Talita koum!” xa koute teni bit, “!Tutut atuli, tamea!” ");
INSERT INTO tvk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Vatakes, atuli ak mitamea e mikakao (huram nan tehe lu e le tei (12) ngamu). Ngan xil xa lapusi xa meul mak, iexil bon. ");
INSERT INTO tvk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","E Iesu mike xat xatel tengan latnavit rat ti naha xa xi tepol ni mi moletin sav xil. Di, biteni mi tamen e ninen ak tengan lalisa ti anien mi atuli nalu. ");
INSERT INTO tvk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu be reling rute ak e dilomun be metimal nan xati te hal Nasaret, del xat eloheoh nan xil. ");
INSERT INTO tvk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","E Sabat, Iesu be nim te pispisientengan vapispisi ni sepinien na Hi en. Moletin holu lamei, e melele xa lalonge pispisien nan xil latemanin ni. E lasis xil mun tang labit, “?Moletin ak nggur kilakilen e metisouen ak nggo xave? ?E mupus merekel eah xil iaxa di mistal nggo hen xalu?” ");
INSERT INTO tvk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Di, labiteni labit, “?E tave moletin xai ti iaxa di tepol pilei ni holesok xil te nim? Ngan xai nat Meri tang. E tuneli xil labe Temis, Sioses, Sudas e Saemon. Tunehin xil vus ladi visal xir e rute ak. !Moletin ak be tei e xir tang!” Ve rin ak, moletin xil tine misoh e lanem male ni Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E Iesu biteni mi xil bit, “Moletin xil vus lamerere ni provet tei na Hi. E moletin xil te metimal xati nan e vatimol xati nan mun, xil lanem male ni vari.” ");
INSERT INTO tvk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Misak ni, e rute ak, Iesu tapol ni ti merekel xil vahe holu. Miling hen e rut moletin xil tang e dal rat xil ra mesien nae xil. ");
INSERT INTO tvk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E mesep pupu xa moletin nan xati xil lataling ti neketen nae en. Di, Iesu ba mikapis e metimal xil xa ladi rute ak, e pispisi mi moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Di, mikes viton eloheoh lu e le tei (12) nan tengan vasil lelen xil lave lulu. Melele xa lamei visali, misa xeihen mi xil tengan lakila lihol rerat ninin tesa xil ra moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","E misemae ni mi xil bit, “E kakaoen namim, munaleh ti neta natel xat xamim, muleh eitingil namim kestang. Reitin, munaleh ti anien, mu ateli, mu mani. ");
INSERT INTO tvk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muhes sandel namim tang, e munaleh ti mun eising.” ");
INSERT INTO tvk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Di, biteni mun mi xil bit, “Melele xa mumei e rute tei, xosxa moletin tei nggur pilei xamim e nim man, ma muti kat en ituxoh melele xa muling rute ak. ");
INSERT INTO tvk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","E xosxa moletin xil latahur pilei xamim ti e rute tei mu iexil ti tavei tengan lalong sepinien namim, ma melele xa muheling rute ak, muhas rerat meas te rute ak ra lemim pe metexil. Ngan ak ihe selxatien mi xil xa Hi pus sexien nae e isa rilomun ni mi xil.” ");
INSERT INTO tvk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Misak ni, eloheoh nan xil laba e labithiteni mi moletin xil xa momal tengan lihiles ra tesaen nae xil e limei visal Hi. ");
INSERT INTO tvk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Langgol rerat ninin tesa xil holu ra moletin xil. E mi ngan xil xa lamesei, laduxol xil ni oel te olip e xil mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E melele nen ak, suv toto Herod Antipas nggur longeongen usil holesok xil xa Iesu di pol ni. Milonge xa rut moletin xil di labiteni labit, “Xos xi be Sion Baptis xa temea rilomun ra maten. Ve rin ak iaxa nggur xeihen tengan vapol ni merekel xil.” ");
INSERT INTO tvk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Rut moletin xil mun labit, “Ngan ak be provet Ilaetsa.” E rute sav xil labit, “Xi be provet hu tei, e nggoni provet xil tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","E melele xa suv toto Herod milong usil Iesu, xi minemi bit, “!Ngan ak be Sion Baptis vari! !Tave ti neta xa inou natesemae ni tengan lita xoteh vatin, e xi temea rilomun ra maten!” ");
INSERT INTO tvk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Suv toto Herod Antipas minexo pupu mak vengan xa xi vari tesa raen tengan moletin te vaeen nan xil ha lital xat Sion, livar xati, e liso ni ihe nim te xeih. Xi tepol ni temak vengan xa Sion tesepin texeih teha xati tehit, “Herod, sexien nam xil tamal ti vengan di onggur Herodias xa tehe atou na tumali Pilip mei be atou nam. Naha xa di opol ni nggur xoteh rae na Hi.” ");
INSERT INTO tvk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ve rin ak, Herodias ien teat Sion, e ien tehei tengan lavas vini, e Herod tenamaen ni ti. ");
INSERT INTO tvk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod tesikoe xol Sion vengan xa temerere ni e tekila xa xi tehe moletin eo na Hi xa momal pe meten. E Herod ien bei tengan vaha valong sepinien na Sion, tave ti neta xa tesak ni nenemien nan tehas pupu ni. ");
INSERT INTO tvk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Di, vatei, Herodias pus mesal tengan vahas vin Sion. E melele nen ak, di latepol ni anien ve melengien xa latepes suv toto Herod en. Ma, latekes viton eilep xil vus te kavmen, vat xil na moletin te vaeen xil, e moletin sav xil mun te provins te hal Kaleli xa latellep tengan limei. ");
INSERT INTO tvk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E melengien ak, atuli na Herodias tehol pe met Herod tetel moletin xil e tesak ni xil vus latehesi xil tehe holu ven. Misak ni, Herod tehiteni mi atuli ak tehit, “!Naha xa iem bei tengan ovuri, inou nisa vari ni minuk!” ");
INSERT INTO tvk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Di, tepol ni hitxatien te xeih mini pe met moletin xil tehit, “Nabiteni reitin xa neta tova xa usisi, nisa ni minuk. Ninakenin ni ti.” ");
INSERT INTO tvk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Misak ni, atuli ak tetamea, ba tesis ninen tehit, “?Nisisi ni naha vari?” E ninen tehiteni mini tehit, “Ha usisi tengan isa vat Sion Baptis minuk.” ");
INSERT INTO tvk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma, atuli ak teloh temanon tetilomun tehe visal Herod e tesisi tehit, “Taxeak tang, ieok bei tengan usa vat Sion Baptis minou ite tre tova.” ");
INSERT INTO tvk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Melele xa Herod milonge mak, xi milonge misa pupu. E vengan xa tepol ni hitxatien te xeih tei mini pe met eilep xil ak, misakras vasin raen. ");
INSERT INTO tvk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Misak ni, tesemae ni mereketeh nan tei tengan iha e itilomun itel vat Sion. Ma, tehe nim te xeih e teta xoteh vatin ra tiei nan. ");
INSERT INTO tvk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Di, teling vatin tete tre tei e tehuri ba tesa ni mi atuli ak. E atuli ak sung, tehuri ba tesa ni mi ninen. ");
INSERT INTO tvk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Melele xa moletin xil na Sion latelongeong ni xa xi mat, latemei e latepo tiei nan, ba latetihin ni. ");
INSERT INTO tvk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Melele xa moletin xil na Iesu lapol bus, ladilomun lamei visal Iesu. Di, latumul mini usil holesok xil xa latepol ni e latepispisi ni. ");
INSERT INTO tvk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","E Iesu pusi xa moletin xil holu lamei visali, e di misak ni xi del moletin nan xil lasakras lavanien mu langel vuteili. Misak ni, Iesu biteni mi xil bit, “Riha rihe rute tova xa moletin xil latovuol en tengan xir rikila ringel en vuteili.” ");
INSERT INTO tvk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma, labe bien ba labe bot tei. Di, labe ri oei e rute tei xa moletin xil latovuol en. ");
INSERT INTO tvk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","E melele xa laba, moletin xil holu lapus xil e bot e lale kil xil. Misak ni, langgo metimal nae xil e ba langgusil xil. Laloh ladiamu ba laduxoh rute xa Iesu del moletin nan xil di laba ven. ");
INSERT INTO tvk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma, melele xa Iesu be ut, pus vanut moletin xil xa mahulong di ladatili tuei. Pus xil langgoni sipsip xil xa moletin tovuol valaxat xil, e ien misae e xil. Misak ni, nggur pilei xil e pispisi mi xil ni holesok xil holu. ");
INSERT INTO tvk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","E melele xa eai ba minu, eloheoh nan xil lamei visal Iesu e labiteni mini labit, “Rute ak be toun ut tei e be vongien tuei xiak. ");
INSERT INTO tvk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bos xa usil rerat vanut moletin xil ak liha tengan ha lihe metimal xil e rute sav xil xa ladi sangas e lixal ti anien ae.” ");
INSERT INTO tvk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E Iesu biteni mi moletin nan xil bit, “E‑e, xamim tang musa anien mi xil lia ni.” E labit rilomun ni mini labit, “!Ei! Vahit mavur mani vapin ni melengien handred lu (200) te polien, ma ngan ak napin ti mu tengan maxal beret a moletin xil ak.” ");
INSERT INTO tvk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","E Iesu misis xil bit, “?Beret vahis iaxa mulehi? Ha mupus pisi mu.” E melele xa lakameti, labiteni mini labit, “Beret lim tang del meseo lu mun.” ");
INSERT INTO tvk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Di, Iesu biteni mi eloheoh nan xil tengan lihiteni mi moletin xil litotan e rute tei xa bos xa husmunae di en. ");
INSERT INTO tvk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Misak ni, laseti moletin xil ladotan e vanute xil xa moletin xil labe hanutap lu e he xalu mun (50) e vanute xil xa moletin handred tei (100) ladi en. ");
INSERT INTO tvk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Melele xa ladotan, Iesu mileh beret xa be lim xiak del meseo lu, miketeh be nesao e memes Hi ven. Di, bul pas beret ak e misa ni mi eloheoh nan xil tengan laseti mi moletin xil. E lapol ni mun del meseo. ");
INSERT INTO tvk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Moletin xil vus langganien e vange polu kuhi. ");
INSERT INTO tvk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","E melele xa eloheoh xil laba mun tengan laleh saxut beret e meseo xil, lase ni be valeat lu e le tei (12) ba vuma … xil vus lapolu. ");
INSERT INTO tvk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","E melele nen ak, tiramue xil xa langganien laduxoh taosen lim (5000). ");
INSERT INTO tvk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Melele xa langganien bus, vatakes Iesu misemae ni eloheoh nan xil tengan lave bot e litiamu ni lihe Betsaeta, xa de ri Oei Kaleli. E xi kestang ita tengan isil rerat vanut moletin xil lihaha. ");
INSERT INTO tvk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma melele xa laba, Iesu misep ling moletin xil e be nesao e vathu tei tengan vasis. ");
INSERT INTO tvk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Di, e hilaep te vongien, Iesu mika sen be seri oei e miketeh pus bot xa de hilaep te Oei Kaleli. ");
INSERT INTO tvk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","E pusi xa eloheoh nan xil di lakameti nggeih tengan lavalis vengan xa di labisu ni votiang tei xa nggeih. Ma, e makoe roroh, ut taluv pilei ti mu, Iesu bemei visal xil e di mikakao e ramut oei nggoni ngan taxa di mikakao e tan tang. E pol ni nggoni ngan xa itavi e xil iha. ");
INSERT INTO tvk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","E melele xa moletin nan xil lapus Iesu di mikakao e ramut oei mak, ulixil mikan tova tang e lameun be nesao labit, “!Aue li! !Temat tei!” E vatakes, Iesu misepin mi xil bit, “!Ulimim nakan ti! !Inou tang! Tinemim namulul ti.” ");
INSERT INTO tvk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Di, Iesu ba be bot del xil. E melele taxa be bot, votiang be tan e moletin nan xil latemanin pupu ni. ");
INSERT INTO tvk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Latemanin ni vengan latanem kil ti xeihen nan, tave ti neta xa latepusi tetep iaxa tesa anien mi moletin xil xa lateli taosen lim (5000). Nenemien nae bon tamu e latanem kil ti koute te merekel ak. ");
INSERT INTO tvk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Melele xa langgur xoteh Oei Kaleli e mei laduxoh tan na mol‑Kenesaret xil, labe ut e labar bot nae. ");
INSERT INTO tvk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Melele xa labe reling bot nae, vatakes, moletin xil lapus xil e lapus kil Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma, moletin xil laloh ba lakapis e rute xil vus xa di sangas tengan lavit usil meien nan. Misak ni, moletin xil holu laleh ngenexil xa di lamesei ladi suon mae xil labe rute xa lalongeong ni xa Iesu da en. ");
INSERT INTO tvk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E rute xil vus xa Iesu ba en, neta sav xos be metimal xil, mu taon xil, mu rute xa moletin vahis tova ladi en, moletin xil laleh ngan xil xa lamesei e labe von vitueien nae xil. E ladakes Iesu tengan ital rat ngan xil xa lamesei ra mesien nae xil mu imaen ngan xil xa lamesei tengan lituxol kusut eising nan. E xil vus xa laduxoli, mesien nae be reling xil. ");
INSERT INTO tvk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Vatei, Farasi xil e titsa xil te rae na Mosis langgo Serusalem, lamei visal Iesu e lakapis xole. ");
INSERT INTO tvk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xil lapusi xa eloheoh nan xil di langganien del hexil xa tamese ti vahusil sexien te kekasen na Siu xil. ");
INSERT INTO tvk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Vengan xa Farasi xil del Siu xil vus mun di langgusil kuh sexien metu te kekasen xa bit, e melele te anien en, itiamu, moletin xil likas kuh hexil. Avu nae xil tetiamu latepispisi ni sexien ak mi xil tengan linave muis ti pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","E melele xa langgal anien e ut te posen, xil lakas moten ni mu, ma di, langga ni. E langgusil hisit sexien sav xil holu na Siu xil, nggoni hisit sexien tei takes xa di lakas kap e sospen nae xil en del ketel nae xil mun xa lapol ni ni aean xa be brons. ");
INSERT INTO tvk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Misak ni, Farasi xil del titsa xil te rae na Mosis lasis Iesu labit, “?Veneh ma moletin nam xil latahusil xat ti sexien xil xa avu nar xil tetiamu latepispisi ni mi xir? Vengan moletin nam xil latakas hexil ti mu vaxo sexien nar, e di langganien tang.” ");
INSERT INTO tvk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu bit rilomun ni mi xil bit, “Naha xa Hi tehiteni texo provet Aesea usil xamim xa di munggusil Hi nggo hilbemim tang momal xa bit, ‘Moletin xil ak di lamerere ni nou del sepinien nae xil kestang, e tinexil di sotin ra nou. ");
INSERT INTO tvk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tave ti neta xa di lamot minou, nabit ninakil ti. Vengan xil di lasa pispisien xil xa be na moletin xil tang, e di labiteni xa inou iaxa natehiteni natehit xil lihusili.’ ");
INSERT INTO tvk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Xamim di munggur xoteh rae xil na Hi tengan muhusil kuh pispisien namim xil tang.” ");
INSERT INTO tvk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Di, Iesu misepin rilomun mi xil bit, “Reitin, xamim mube metisou tova tang e rin xa di muling rae xil na Hi di nga tengan mukila muvusil pispisien namim xil tang. ");
INSERT INTO tvk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Vengan Mosis tesemae ni tehit, ‘Mumerere ni tamemim e ninemim xil.’ E biteni mun bit, ‘Xosxa moletin tei isuhol tamen mu ninen, ma lihasi imat.’ ");
INSERT INTO tvk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","E xamim di mupispisi mi moletin xil xa likila lihiteni mi tamexil e ninexil lihit, ‘Holesok navan xil xa nakila nitutou ni xamil ni, di nakenin ni vengan xa nate pol ni hitxatien tei tuei tengan nisikoe xole ihe na Hi kestang.’ ");
INSERT INTO tvk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nggo sexien ak, di mupispisi mi moletin xil ni suse xa likila lisikoe xol holesok nae xil ixo en tengan linatutou ni ti mun tamexil e ninexil ni. ");
INSERT INTO tvk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mak, ma pispisien namim xil di pol ni sepinien xil na Hi mei be neta sav tang. E di mupol ni holesok xil holu xa lamak.” ");
INSERT INTO tvk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Di, Iesu biles e mikes rilomun ni vanut moletin xil tengan lamei visali e biteni mi xil bit, “!Xamim vus muteong kuhi ni sepinien navan tengan mukila! ");
INSERT INTO tvk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tave holesok xil ti xa moletin tei ngguri nggo vulongen be tinen iaxa di misak ni mei tamese ti pe met Hi. !E‑e, tamak ti! E sepinien xa mistal nggo vulongen iaxa mikila vasak ni moletin ak mei namese ti pe meten.” ");
INSERT INTO tvk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Melele xa be reling vanut moletin xil e be nim, eloheoh nan xil lasisi tengan vahit kil koute te sepinien nan mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma Iesu biteni bit, “?!Midep, xamim mutakil ti mu!? ?Mutakil ti xa holesok xil xa mungguri nggo vulongomim misakras vapol ni xamim mei munamese ti pe met Hi? ");
INSERT INTO tvk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vengan xa be vangemim tang e, di, mistal be reling tenbemim, ba be tisok tang.” Nggo sepinien ak, Iesu misep kila xa anien xil vus bos te anien en. ");
INSERT INTO tvk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Di, biteni mun bit, “Be holesok xil xa di tine moletin, xa di misepin ni nggo vulongen, iaxa di pol ni moletin mei tamese ti pe met Hi. Holesok xil kestang xa mistal nggo xouk iaxa pol ni xouk otamese ti. ");
INSERT INTO tvk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vengan melele xa tine moletin tei misa, xi di pol ni hisit sexien tesa xil ak: di pat vituei del mosav melele xa lutateli ti mu, di mikan ni neta na mosav xil, e di bas vin moletin xil. ");
INSERT INTO tvk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Xi di mikan ni atou na mosav, be hokan, di minem usil holesok xil xa misa, di miluvos ni mosav xil, e di minem usil sexien xil holu te suse. Di minem misa ni mosav xil, di misep usil mosav xil, be koai, e di nggusil sexien na unu xil tang. ");
INSERT INTO tvk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Reitin, sexien xil vus ak vari langgo tine moletin, e xil iaxa di lapol ni moletin tei mei tamese ti pe met Hi.” ");
INSERT INTO tvk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Di, Iesu be reling rute ak e ba be rute sav tei xa be sangas ni taon te hal Taer. Xi be vangit nim tei e ien ti tavei tengan moletin tova vakil rute xa xi da en. E misakras vaxus. ");
INSERT INTO tvk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","E melele nen ak, atou tei da xa ninin tesa tei ba de tutut atuli nan. E melele xa milongeong ni xa Iesu de sangas, vatakes, bemei visal Iesu e mitingeiril mini. ");
INSERT INTO tvk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Atou ak tave Siu ti, xi be ate‑Siria tei te provins te hal Fonesia. Xi dakes Iesu tengan vahol rat ninin tesa vahe reling atuli nan. ");
INSERT INTO tvk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","E Iesu biteni mini bit, “Namei tengan nilaxat horamue navan xil mu xa labe Siu. Vengan tamal ti xa namur anien ae e naso ni tang vaha mi kuli xil.” ");
INSERT INTO tvk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","E atou ak bit rilomun ni mini bit, “Suv, ngan ak be reitin. E kuli xil mun xa ladi xorelis von anien en lakila lava saxut anien xil xa horamue xil di langga lingi.” ");
INSERT INTO tvk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Di, Iesu biteni mini bit, “!Reitin li, sepinien nam di pisen ni xa neketen nam mahulong! Misak ni, ve rin ak, utilomun uhe tim vengan xa ninin tesa be reling atuli nam ngamu.” ");
INSERT INTO tvk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","E melele xa atou ak duxoh tim, mikameti xa atuli nan de vet man, e ninin tesa tehe relingi ngamu. ");
INSERT INTO tvk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Melele xa Iesu be reling tan te hal Taer, ba mika pas tan te hal Saedon e be rute tei sangas visal Oei Kaleli xa lakesi ni Dekapolis. ");
INSERT INTO tvk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","E rute ak, moletin xil ladel tiramue tei xa vurangen bon e misakras vasepin kuhi bemei visali e ladakes Iesu tengan valing hen en tengan mei vahos rilomun. ");
INSERT INTO tvk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma, Iesu dela be sotin vuteili ra vanut moletin xil. Di, miling vakuhen de vurang moletin ak. E dutou ni, mikusah, e miduxol me tiramue ak. ");
INSERT INTO tvk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Di, Iesu miketeh be nesao, misehseh, e biteni mi tiramue ak e sepinien na Siu xil bit, “Epapata,” xa koute teni be ‘metal.’ ");
INSERT INTO tvk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vatakes, vurang tiramue ak metal, e mikila valong holesok xil vaxo en. E men mei bos e mei misepin kuhi sung. ");
INSERT INTO tvk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Di, Iesu misep xol moletin xil tengan linaviteni ti mi moletin tova naha xa tepol ni. E tave ti neta xa biteni vatei mun mi xil, xil ba labithiteni mi mosav xil. ");
INSERT INTO tvk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","E moletin xil vus xa lalong usili lamesep labit, “Holesok xil vus xa Iesu di pol ni bos xa bos. Tave ti neta xos vurang moletin bon, xi misak ni mei milongeong kuhi; mu moletin xa misakras vasepin, ma misak ni mei misepin.” ");
INSERT INTO tvk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E melele sav mun, vanut moletin xil holu lamei vituei tengan lapus Iesu. E melele xa anien ae bus, Iesu mikes eloheoh nan xil lamei visali e biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ieok di misae e moletin xil ak vengan xa ladi visal nou melengien tol (3) ngamu e anien ae tovuol mun. ");
INSERT INTO tvk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ieok ti tavei tengan nasil rerat xil latilomun lave tim sae xil melele xa mae dit nggat xil. Maxani, vexil namal e metexil namaluxoluk e suse, vengan rute xil langgo sotin lamei.” ");
INSERT INTO tvk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E eloheoh nan xil lasisi labit, “!Inggak be uruvuol! ?Rikamet anien e rute xave tengan rakila risa anien mi vanut moletin xil xa mahulong xiak?” ");
INSERT INTO tvk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Iesu misi xil bit, “?Beret vahis iaxa mulehi?” Labit rilomun ni mini labit, “Beret lu e he sav (7) tang.” ");
INSERT INTO tvk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Di, Iesu biteni mi vanut moletin xil tengan latotan e tan. Melele xa ladotan bus, Iesu nggur beret lu e he sav (7) e misa memesien ba mi Hi ven. Di, bul papasi e misa ni mi eloheoh nan xil tengan ha liseti mi moletin xil, ma xil lapol ni. ");
INSERT INTO tvk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","E laleh meseo vahis mun bemei mi Iesu. E melele xa memes Hi ven bus, misemae ni moletin nan xil tengan ha laseti. ");
INSERT INTO tvk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Moletin xil vus langganien e vange polu. E melele xa moletin xil na Iesu laba mun tengan laleh saxut anien xil, lase valeat lu e he sav (7) ba vuma … xil vus lapolu. ");
INSERT INTO tvk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Moletin xil xa langganien e melengien ak laduxoh taosen hat (4000). Melele xa langganien bus, Iesu misil rerat xil ladilomun labe tim sae xil. ");
INSERT INTO tvk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E melele xa Iesu misil rerat vanut moletin xil ak labaha bus, vatakes, xi del moletin nan xil labe bot e labe rute tei xa lakesi ni Dalmanuta. ");
INSERT INTO tvk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vatei, Farasi xil lamei visal Iesu tengan lasak pisi. Ma, mei langor dela e lasisi tengan vapol ni neta tova xa eilep vaxo ut nesao tengan vapisen ni xa xi texo visal Hi reitin. ");
INSERT INTO tvk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Melele xa lasisi mak, Iesu milonge misa e biteni mi xil bit, “?Veneh ma xamim, moletin xil te xosali ak, mubit mupus ti neta tova xa eilep tengan vapisen ni xa natexo visal Hi reitin? !E nabiteni reitin mi xamim xa ninapol ni ti neta tengan mupus reitinen usil inou vaxo en!” ");
INSERT INTO tvk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Di, Iesu mea, be reling xil, e ba be bot. Di, del moletin nan xil, langgur xoteh Oei Kaleli labe rin. ");
INSERT INTO tvk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Melele xa Iesu del moletin nan xil ladi tamu e bot, moletin nan xil lanem rilomun ni xa iexil bovorong ni tengan laleh beret ae vapin ni xil. Latehur beret tei takes temei e bot nae. ");
INSERT INTO tvk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","E melele xa laba, Iesu misel xat xil bit, “Muxuxou kuhi ve ‘is’ na Farasi xil e ‘is’ na suv toto Herod.” ");
INSERT INTO tvk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Melele xa lalong sepinien nan, lasep usili del xil mun tang labit, “Xos xi di bit usil is vengan xa xir rataleh ti beret ar.” ");
INSERT INTO tvk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E Iesu minem kil naha xa di lasep usili. Ma misis xil bit, “?Veneh ma di musep usil beret ar xa tovuol? ?!Mutakil ti mu!? ?Be reitin xa nenemien namim bon? ");
INSERT INTO tvk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Metemim di, e mutapus kil ti neta. Vurangemim di, e mutalong kil ti neta. ?Iemim bovorong ni ");
INSERT INTO tvk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","melele xa natehul papas beret lim (5) tang tengan nasa ni mi moletin taosen lim (5000)? ?E valeat vahis iaxa polu ni rut anien xil xa muteleh viton ni?” Labit, “Valeat lu e le tei (12).” ");
INSERT INTO tvk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","E Iesu bit rilomun ni bit, “?E melele xa natehul papas beret lu e he sav (7) tang tengan nasa ni mi moletin taosen hat (4000), valeat vahis iaxa polu ni rut anien xil xa muteleh viton ni?” Labit, “Valeat lu e he sav (7).” ");
INSERT INTO tvk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Di, misis xil bit, “?Ma, veneh ma xamim mutakil ti mu koute te holesok xil ak?” ");
INSERT INTO tvk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Melele xa Iesu bemei e metimal te hal Betsaeta del moletin nan xil, rute moletin xil ladel moletin tei xa meten bar bemei visal Iesu e ladakesi tengan vatuxoli. ");
INSERT INTO tvk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu dal xat he moletin ak e dela be reling metimal. Di, Iesu miling kusahen nan e met moletin ak, e miling hen en. Di, misisi bit, “?Taxeak, mikila opus kil neta tova?” ");
INSERT INTO tvk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma moletin ak miketeh xorelis xi e biteni bit, “Napus kil moletin xil, e napusi xa langgoni vatiei xil xa di lakakao.” ");
INSERT INTO tvk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Di, Iesu miling hen e meten xalu vatei mun. Di, melele xa moletin ak miketeh pisi mun, meten xalu mei bos e pus kil holesok xil vus. ");
INSERT INTO tvk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Di, Iesu misemae ni bit, “Onaha ti mun e metimal, e uhe tim vari.” ");
INSERT INTO tvk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Melele xa Iesu e moletin nan xil lakakao laba, laduxoh rute tei sangas visal taon te hal Seseria‑Filipae. E inggak, xi misis moletin nan xil bit, “?Moletin xil labit inou nabe visi vari?” ");
INSERT INTO tvk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xil labit rilomun ni labit, “Rut moletin xil labit obe Sion Baptis. E rute ngan xil labit xouk obe provet Ilaetsa. E rute sav xil mun labit xouk obe tei e provet sav xil tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","E xi misis xil bit, “?E xamim, ma midep? ?Mubit inou nabe visi vari?” E Pita mitamea e bit rilomun ni mini bit, “Xouk obe Mesaea xa Hi tehit xati tengan isa ni imei.” ");
INSERT INTO tvk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Di, Iesu misep xol moletin nan xil tengan linaviteni ti mi moletin tova xa xi be Mesaea. ");
INSERT INTO tvk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E melele nen ak ba, Iesu bit lelen ni mi moletin nan xil xa xi, Nat Moletin, iha ihur longpangasien holu, e elda xil, vat xil na pris xil, e titsa xil te rae na Mosis lisin ni. Ti, lihas vini. E melele xa melengien tol (3) mei itavi, xi imea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu bit kil holesok xil vus ak mei memese kuhi mi xil. E Pita dela be rin e misepin nggeih xati tengan nasepin ti namak. ");
INSERT INTO tvk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","E melele xa Iesu biles pus moletin nan xil, xi misepin nggeih mi Pita bit, “!Temat, uhe reling nou! Nenemien nam ak di nggusil xat nenemien na moletin xil te ut etan, e tahusil nenemien na Hi ti.” ");
INSERT INTO tvk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Di, Iesu mikes viton eloheoh nan xil del vanut moletin xil xa ladi sotin vuteili tengan lamei visali. Di, biteni mi xil bit, “Xosxa moletin tova ien bei tengan ihusil nou, ma istokovein holesok xil te meulien nan, ti, ipo eivave te maten nan e ihusil xat nou. ");
INSERT INTO tvk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vengan xa ngan xil xa lasak pisi tengan likenin meulien nae ve xil tang, ma meulien nae ikesae ra xil. E ngan xil xa lamaen meulien nae ikesae vengan di langgusil xat inou del longeongen hos, ma, e ut nesao, xil likamet meulien sal. ");
INSERT INTO tvk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","?Naha ihos xosxa moletin tei ileh holesok xil vus te ut etan ak, e istokovein meulien sal nan tengan ileh holesok xil ak? !Navos ti vari! ");
INSERT INTO tvk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Vengan xa xi misakras vasa neta ngan tengan vahur rilomun ni meulien sal nan. ");
INSERT INTO tvk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Moletin xil te xosali ak, sexien nae mikavui tang e latave reitin ti mi Hi. Langgoni atou tei xa mikila be na tiramue tei, e ba, di maen xi mi ngan tesav mun. E ngan xil xa labe unoun tengan lavit rati xa di langgusil inou mu sepinien navan pe met moletin xil ak, inou mun, Nat Moletin, nihe unoun tengan nihit rati xa labe moletin navan xil melele xa nitilomun nimei itel masxaxa xil na Tata navan e itel minehinen te xeihen xa xi isa ni minou.” ");
INSERT INTO tvk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Di, Iesu biteni bit, “Nabiteni reitin mi xamim xa rut xamim xa di lasoh del nou xosali, ti lipus neta tei mei istal e melele xa lameul tamu ladi xa ipisen ni xa xeihen te lelaxatien na Hi bemei ngamu.” ");
INSERT INTO tvk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Melele xa melengien tei e he sav (6) mei mitavi, Iesu nggur Pita, Temis del Sion e del xatel latobe nesao e vathu tei tengan xatel ak kestang latoti vituei en. E melele xa latodi rute ak, latpus tenbe Iesu biles. ");
INSERT INTO tvk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eising nan xil mei mieh xa mieh nggoni laet. ");
INSERT INTO tvk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","E di, latpus Mosis e provet Ilaetsa lustal e ba lusepin del Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Melele xa Pita pus xalu, biteni mi Iesu bit, “!Titsa, bos xa matdi inggak! Xosxa iem bei, ma matikili ni horao ihe tol: tei ihe mam, tei ihe ma Mosis, e tei ihe ma Ilaetsa.” ");
INSERT INTO tvk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Xi del rumali ulixatel mikan pupu, misak ni xi takil ti xa ihit neh. ");
INSERT INTO tvk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Di, momah tei mei mikutaxol xatel, e latlong rae tei mistal nggo en xa biteni bit, “Ngan ak be Natuxoli, ngan xa eheien navan di en. !Muteong xat raen!” ");
INSERT INTO tvk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E vatakes, melele xa latketeh be nesao, lattapus ti mun moletin xalu ak, Iesu kestang de visal xatel. ");
INSERT INTO tvk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Melele xa di latsuvul ra vathu ak, Iesu misep xol xatel bit, “Mutnahiteni ti mi moletin tova usil naha xa mutepusi ha ituxoh melele xa inou, Nat Moletin, nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xatel latlong xat sepinien nan, e latsis xatel mun tang usil koute te sepinien nan xa bit, ‘nimea rilomun ra maten.’ ");
INSERT INTO tvk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Di, latsisi latbit, “?Veneh ma titsa xil te rae na Mosis labiteni xa provet Ilaetsa imei itiamu ni Mesaea xa Hi tehit xati?” ");
INSERT INTO tvk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","E Iesu bit rilomun ni bit, “Reitin xa latetisi e sepinien na Hi tehit Ilaetsa imei tengan ivue xat holesok xil vus mei imese. E nabiteni mi xamitel xa Ilaetsa temei ngamu e moletin xil latnapus kil ti. Xil latepol tesa mini texoni ngan xa iexil tehei. E suse nen tak, nggusil sepinien na Hi, inou mun, Nat Moletin, nihur longpangasien holu e moletin xil lisin nou.” ");
INSERT INTO tvk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Melele xa Iesu xatel latsuvul ra vathu ak, latbe rute xa eloheoh sav xil ladi en. E melele xa latduxoh xil, latpus vanut moletin xil holu di lasoh lakapis xol xil, e rut titsa te rae na Mosis di langor del xil. ");
INSERT INTO tvk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Melele xa moletin xil lapus Iesu mei mistal, latemanin e laloh tengan lavur pilei. ");
INSERT INTO tvk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Di, Iesu misis eloheoh nan xil bit, “?Di mungor del xil usil naha?” ");
INSERT INTO tvk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma, tei e vanut moletin xil ak biteni mini bit, “Titsa, inou nanggur horamue navan bemei visaluk vengan xa ninin tesa tei da en xa misak ni misakras vasepin. ");
INSERT INTO tvk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","E melele xa ninin tesa ak dal xati, bas tan ni e misak ni mingas luhon, rurungon misol nggo vulongen, e tenben mei nggeih pupu. Natesis moletin nam xil tengan lavol rati, e lasakras lapol ni.” ");
INSERT INTO tvk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Melele xa Iesu milonge mak, biteni bit, “!Iva! !Xamim moletin xil te xosali ak, neketen namim tovuol vari! ?Niti visal xamim ituxoh vilieh? Veok buol ni xamim xa neketen namim tovuol. Muhur horamue xai vamei visal nou.” ");
INSERT INTO tvk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma ladel horamue ak ba mi Iesu. E melele xa ninin tesa ak pus Iesu, dal xat horamue ak e bas tan ni. Misak ni mikilkile e rurungon misol nggo vulongen. ");
INSERT INTO tvk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Di, Iesu misis tame horamue ak bit, “?Xi di pol ni mak huram vahis tuok?” E tamen bit rilomun ni bit, “Melele xa tehe hokorong tamu. ");
INSERT INTO tvk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Melengien holu, ninin tesa ak misak pisi tengan vahas vini vaxo suse xa misak ni di mot be upang mu oei. !E xosxa okila upol ni, ma iem isae li e xamel e ututou ni xamel!” ");
INSERT INTO tvk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","E Iesu bit, “?Veneh ma di obiteni obit ‘xosxa okila opol ni’? Vengan Hi mikila vapol ni neta xil vus e rin na moletin tei xa neketen nan da.” ");
INSERT INTO tvk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Vatakes, tame horamue dakesi bit, “Neketen navan da, e tapin ti. !Tutou ni nou li tengan namur ti mun!” ");
INSERT INTO tvk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","E melele xa Iesu pusi xa vanut moletin xil laloh lamei visal xalu, xi biteni mi ninin tesa ak bit, “!Nabiteni minuk ninin tesa, xouk xa di osikoe xol horamue ak tengan misakras vateong mu vasepin, uhe relingi e onamei ti mun en!” ");
INSERT INTO tvk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Melele xa biteni mak, ninin tesa ak meun be nesao ra horamue ak e misak ni mot be tan e mulul nggeih. Di, be relingi. Melele xa moletin xil lamei visal horamue ak, lapusi dat mak tang nggoni tiei votei tei e labiteni labit, “Xi mat tuei.” ");
INSERT INTO tvk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","E Iesu dal xat hen e dutou ni mei misoh. Di, Iesu be reling xil. ");
INSERT INTO tvk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dutou sung, melele xa Iesu be vangit nim xa da en e moletin nan xil lapusi xa be xil tang, lamei visali e lasisi labit, “?Veneh ma xamem matesakras mavol rat ninin tesa ak?” ");
INSERT INTO tvk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E Iesu bit rilomun ni mi xil bit, “Hi di misa xeihen tengan vahol rerat hisit ninin tesa ak nggo sexien te sisen.” ");
INSERT INTO tvk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Di, lamea reling taon te hal Seseria‑Filipae ak e lakakao labe rute sav e provins te hal Kaleli xa moletin xil tovuol en vengan ien ti tavei moletin ti vakil rute xa ladi en. ");
INSERT INTO tvk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Iesu pol ni mak vengan xa ien bei tengan vapispisi mi moletin nan xil. Ma, biteni mi xil bit, “Nave nousav ti, moletin tei isa rat inou, Nat Moletin, nihe he moletin xil te ut etan e lihas vin inou. E, e melengien tol nen, nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","E xil latakil ti koute te pispisien nan ak, e ulixil mikan tengan lasisi ni. ");
INSERT INTO tvk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iesu bemei e taon te hal Kapaniam del xat eloheoh nan xil e labe tim. Melele xa labe nim, Iesu misis xil bit, “?E suse, xamim di mutesep usil naha?” ");
INSERT INTO tvk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","E xil ladit votei vengan xa di latengor e suse usil visi e xil iaxa eilep mak mu mili. ");
INSERT INTO tvk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Misak ni, Iesu dotan e mikes viton moletin lu e le tei (12) nan. Di, biteni mi xil bit, “Xosxa moletin tei ien bei tengan mei vahe eilep mak mu vali mosav xil, ma iling xi ihe tan. Imak, ma mei ihe moletin te polien na moletin xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Di, Iesu midel tutut horamue tei bemei visal xil. Miso hen ngga xole pe metexil, e biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Moletin tei xa nggur pilei movotei tei xa nggoni horamue ak vengan xa xi di nggusil inou, nggoni ngan xa moletin ak di nggur pilei inou. E tei xa di nggur pilei nou, nggoni ngan xa di nggur pilei ngan xa tesil inou namei.” ");
INSERT INTO tvk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sion Sepeti biteni mi Iesu bit, “Titsa, xamem mapus moletin tei di nggol rerat ninin tesa xil e hisom, ma masep xole tengan napol ni ti mun vengan xa xi tamos ti e xamem.” ");
INSERT INTO tvk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","E Iesu biteni mi xil bit, “Munasep xole ti vengan xa ngan xa di pol ni merekel xil nggo hisok misakras vamea sung e vasepin vasa vaha xat inou. ");
INSERT INTO tvk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vengan xa moletin xa di tavae ti vatel xir di mos e rin nar. ");
INSERT INTO tvk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Reitin li nabiteni mi xamim xa xosxa moletin tei isa oei tang mi xamim vengan xa mupol nggo hisok, Hi isa huite teni mini ven.” ");
INSERT INTO tvk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","E Iesu biteni mun bit, “E, e rin sav nen, xosxa moletin tova isak ni moletin tei xa nggusil xat nou nggoni horamue ak tengan imot e tesaen, ma Hi isa pangasien xa isa mak mu mini. Bos mak mu xa lavar xat hat tova xa mahulong pupu vate huraen, e laso ni vamerir e huinep te tas. ");
INSERT INTO tvk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“!Nggusil nenemien ak, xosxa hem misak ni xouk di omot e tesaen, ma uta xotehi iha! Ihos mak mu xa rut tenbom isa e uhur meulien sal, ili ngan xa hem xalu lubos tang ludi e liso xouk uhe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","!E xosxa lem misak ni xouk di omot e tesaen, ma uta xotehi iha! Ihos mak mu xa rut tenbom isa e uhur meulien sal, ili ngan xa lem xalu lubos tang ludi e liso xouk uhe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","!E xosxa metom tei misak ni xouk di omot e tesaen, ukis rati iha! Ihos mak mu xa metom tei ikesae e uhur meulien sal, ili ngan xa metom xalu vus ludi tang e liso xouk uhe Upang xa misakras vamat. ");
INSERT INTO tvk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","E rute ak, xouk ulong pangasuk vehakut xa vehakut. Tomasis xil tit lia sal ni xouk, e upang teni ia pangasuk e namat ti vatova. ");
INSERT INTO tvk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Hi di maen ni xir rihisu ni melele te xeih xil tengan vasak ni xir ramese pe meten nggoni ngan xa sol e upang di misak ni sanien eo tei mei memese. ");
INSERT INTO tvk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol bos. ?E xosxa neta xa misak ni sol ak bos be relingi, ma lipol ni mei ihos rilomun itep? !Lasakras! Ma, bos xa sexien namim ixoni sol xa ti isak ni vitueien namim mei ihos mak mu e muti vituei e tomat.” ");
INSERT INTO tvk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Melele xa Iesu misepin mi moletin nan xil bus, xi be reling provins te hal Kaleli del moletin nan xil. E labe rute tei xa mili Oeisal Sodan e provins te hal Sudea. Vanut moletin xil holu lamei visal Iesu e, nggusil sexien metu nan, xi pispisi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","E melele nen ak, rut Farasi xil lamei visali tengan lasak pisi. Misak ni, lasisi labit, “?Uhit pisi mi xamem, rae nar xil di maen ni tengan moletin tei istokovein atou nan?” ");
INSERT INTO tvk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E Iesu bit rilomun ni mi xil bit, “?Midep? ?Mosis tesa rae eah mi xamim?” ");
INSERT INTO tvk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xil labiteni mini labit, “Mosis temaen ni tengan tiramue tei istokovein atou nan tehit, ‘Moletin xa bit vastokovein atou nan, isa Setifiket te Silaen mini. Ti, mikila istokovein ni sung.’” ");
INSERT INTO tvk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E Iesu bit rilomun ni bit, “Mosis tetis rae ak ve xamim vengan xa vatumim nggeih pupu. ");
INSERT INTO tvk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","E sexien ak tehe tovuol e melele xa Hi tepol kokot ni holesok xil e ut etan. Ralonge xa, ‘Hi pol ni moletin, tei be malohos, e tei mun be atou.’ ");
INSERT INTO tvk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E biteni mun bit, ‘Ve rin ak, tiramue imea reling tamen xal ninen, e ihisti itel atou nan, ");
INSERT INTO tvk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","e xalu mei lalihe tei takes.’ Misak ni xalu lutave lu ti mu, e mei lube tei takes. ");
INSERT INTO tvk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ma naha xa Hi tehistin ni, moletin ti mun naseti.” ");
INSERT INTO tvk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dutou sung, melele xa ladilomun labe tim, moletin nan xil lasisi usil rin ak. ");
INSERT INTO tvk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma, biteni mi xil bit, “Xosxa moletin tei mistokovein atou nan e, di, miteli del atou sav tei, pe met Hi nggoni ngan taxa di pol misa dela e di purun atou nan xa diamu. ");
INSERT INTO tvk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E nggo suse nen tak, atou xa mistokovein tiramue nan e ba miteli del tiramue sav, pe met Hi nggoni ngan xa xi pol misa dela.” ");
INSERT INTO tvk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Di, moletin xil laleh tutut horamue nae xil lamei visal Iesu tengan xi valing hen e xil e vasa tuxolxatien mi xil. E melele xa moletin nan xil lapus xil, labul xat xil. ");
INSERT INTO tvk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","E melele xa Iesu pus kil naha xa di lapol ni, ien mikat e misepin mi xil bit, “Mumaen tutut horamue xil ak lamei visal nou, e munasikoe xol xil ti. Vengan xa Hi be suv toto na hisit moletin xil xa langgoni xil tang. ");
INSERT INTO tvk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Reitin li nabiteni mi xamim, ngan xil xa lataling xil ti pe lelaxatien na Hi vaxoni tutut horamue tei, Hi nave suv toto te meulien nae ti.” ");
INSERT INTO tvk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Di, miso hen nggaxol horamue xil ak, miling hen e xil, e misa tuxolxatien ba mi xil kekes. ");
INSERT INTO tvk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Melele xa Iesu di nggusil suse ba, moletin tei miloh bemei visali, mitingeiril mini e misisi bit, “?Titsa hos, nipol ni naha tengan nikila nihur meulien sal?” ");
INSERT INTO tvk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu bit rilomun ni mini bit, “?Veneh ma okes inou obit nabos? Moletin tovuol vahos, Hi kestang bos. ");
INSERT INTO tvk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xouk okil naha xa rae xil labiteni. ‘Munahas vin ti moletin. Munakan ni atou mu tiramue na mosav ti. Munakan ni ti neta na mosav xil. Munaluvos ni his mosav xil ti. Munaluvos mosav xil ti tengan muvur neta tova nae. Mumerere ni tamemim e ninemim xil.’” ");
INSERT INTO tvk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","E tiram maxoe ak bit rilomun ni mi Iesu bit, “Inou di nanggusil xat rae xil vus ak melele xa natehe tutut horamue tamu mei duxoh xosali ak.” ");
INSERT INTO tvk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Di, Iesu miketeh momal ni tiram maxoe ak e eheien nan di en. Ma, biteni mini bit, “Neta tei takes iaxa otapol ni ti mu. Uha, upos ni holesok xil vus nam e usa mani nen mi ngan xil xa holesok nae tovuol. E xosxa upol ni imak, ma holesok nam xil e ut nesao ihe holu. Ti, utilomun e uhusil xat inou.” ");
INSERT INTO tvk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","E melele xa tiram maxoe ak milong sepinien nan, xi milonge misa e be reling Iesu, vengan xa holesok nan xil labe holu e ien ti tavei tengan vastokovein ni. ");
INSERT INTO tvk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu miketeh mikapis e moletin nan xil e biteni mi xil bit, “Nggeih tova tang tengan moletin xa holesok nan holu vamaen Hi mei vahe suv toto e meulien nan.” ");
INSERT INTO tvk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Moletin nan xil latemanin ni sepinien nan. E Iesu biteni mun mi xil bit, “Reitin li, nggeih tova tang tengan moletin xil lamaen Hi mei vahe suv toto e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","?Munemi xa kamel tei xa be mahulong mikila vakital vaxo met nitil tei xa hokorong xa hokorong pupu? E‑e, misakras. E moletin tei xa holesok nan xil holu, nggeih mak mu mili ngan ak tengan imaen Hi mei ihe suv toto e meulien nan.” ");
INSERT INTO tvk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Melele xa moletin xil na Iesu lalonge mak, latemanin pupu e lasis xil mun tang labit, “?Imak, ma Hi mikila vateh meulien e visi vari?” ");
INSERT INTO tvk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu miketeh mikapis e xil e bit, “!Iaxai vari! Moletin misakras vapol ni, e Hi kestang mikila ipol ni, vengan xi mikila vapol ni holesok xil vus.” ");
INSERT INTO tvk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Di, Pita biteni mini bit, “?Imak, ma itep mi xamem? Xamem matestokovein holesok xil vus namem tengan mavusiluk.” ");
INSERT INTO tvk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E Iesu bit rilomun ni bit, “Reitin li nabiteni mi xamim, moletin xil vus xa di lastokovein tim sae, mu tua nae xil, mu hinexil, mu tamexil, mu ninexil, mu horamue nae xil, mu naho sae xil venou e ve longeongen hos, ");
INSERT INTO tvk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ma, e ut etan ak, Hi isa rilomun ni mi xil huite teni xa ihe handred tei (100) ili ngan xa latestokovein ni. Reitin, lihur rilomun ni nim xil, tua xil, hinexil, ninexil, horamue xil, naho xil, itel sakpurunien xil mun. E, e ut nesao, xil lihur meulien sal. ");
INSERT INTO tvk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E moletin holu xa labe eilep xil xosali ak, xil mei lihe neta sav tang. E holu xa labe movotei xil xosali ak, xil mei lihe eilep xil sung.” ");
INSERT INTO tvk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Melengien vahis mei mitavi, e Iesu del moletin nan xil laduxoh suse xa be Serusalem. Di, Iesu ba di mikakao diamu ni xil. E melele xa moletin nan xil lapusi mak, latemanin holu, e ngan tesav xil xa ladutou, ulixil di mikan pupu. Vatei mun, Iesu mileh eloheoh nan xil laka se xil vuteili, e bit lelen naha xa mei istal mini mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Xi biteni bit, “?Mupusi? Taxeak di raba ve Serusalem xiak. E rute ak, xil limaen nou, Nat Moletin, ha nihe he vat xil na pris xil e titsa xil te rae na Mosis. Ivus ti, xil lihur nou nihe kot e limaen rat meulien navan tengan ha nimat. Ti, lisa rat nou ha nihe he moletin xil xa latave Siu ti. ");
INSERT INTO tvk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xil lipol pepamen ni nou, likusah iha xat inou, limeas pangas nou ni ao te xeih xil xa sanute di en, e lihas vin nou. E melele xa melengien tol mei itavi, inou nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Di, Temis xal Sion, nat Sepeti xalu, lumei lupus Iesu, e lusisi lubit, “Titsa, xamel iemel bei tengan opol ni neta tei e rin namel.” ");
INSERT INTO tvk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu misis xalu bit, “?Naha vari?” ");
INSERT INTO tvk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma lubit rilomun ni lubit, “Melele xa mei uhe suv toto e uhur xeihen nam, ma umaen xamel tengan malitotan visaluk, tei ite rim metu, e tei ite rim meil.” ");
INSERT INTO tvk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","E Iesu miketeh pus xalu e misis xalu bit, “Xamil mutakil ti naha xa di musis nou ni. ?Midep? ?Xamil mukila tamak mulihur hisit sakpurunien xil e longpangasien xil ixoni ngan taxa inou ha nihuri?” ");
INSERT INTO tvk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","E lubit rilomun ni mini lubit, “!Io, makila!” Di, Iesu biteni mi xalu bit, “Reitin, xamil mulihur hisit sakpurunien e longpangasien xil ixoni ngan xa inou nihuri. ");
INSERT INTO tvk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","E tave ti neta xa imak, nave nou ti xa nihosei visi iaxa mei itotan e riuk metu mu e riuk meil. Von xeihen xalu ak be na ngan xalu xa Tata navan bosei xalu ngamu tengan lalihuri.” ");
INSERT INTO tvk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","E melele xa moletin sav xil na Iesu xa labe he xalu (10) lalongeong usili, iexil nggat Temis xal Sion. ");
INSERT INTO tvk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Iesu mikes viton xil vus lamei visali e biteni mi xil bit, “Mukila xa suv na ngan xil xa latave Siu ti di lapet rat xil tang mei labe nesao mili ngan xil xa di lalaxat xil, e vat nae xil mun di pol ni nggeih mi ngan xil xa ladi pe he xil. ");
INSERT INTO tvk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","E xamim, sexien namim namak ti. Xosxa tei e xamim ihit mei ihe eilep mak mu ili xamim, xi mei ipol mi xamim ixoni moletin te polien tei namim. ");
INSERT INTO tvk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","E xosxa tei e xamim ien bei tengan vatiamu ni xamim, xi mei ihe moletin te tutouen namim ixoni slev tei. ");
INSERT INTO tvk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vengan inou mun xa nabe Nat Moletin, natamei ti tengan moletin xil ti latutou ni nou. !E‑e! Inou namei tengan nitutou ni mosav xil e nisa meulien navan tengan nixal rat moletin xil holu mei limeluv ra pangasien te tesaen nae xil.” ");
INSERT INTO tvk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu del moletin nan xil ba laka pas taon te hal Seriko, e vanut moletin tei xa eilep di langgusili. E melele xa di labe reling Seriko, e seri suse ak, moletin tei xa meten bar di dotan, hisen Batimeas, nat Timaes. Xi di miram ni moletin xil ve mani. ");
INSERT INTO tvk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","E melele xa milongeong ni xa be Iesu te hal Nasaret iaxa di mikakao mei mitavi ba, mikei ba ni bit, “!Iesu! !Xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae li e nou!” ");
INSERT INTO tvk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Moletin xil holu labul xati tengan vatat votei. E tave ti neta xa mak, xi mikei nggeih pilei sung bit, “!Xouk xa ostal onggo vatimol na suv toto Deved! !Iem isae li e nou!” ");
INSERT INTO tvk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Melele xa Iesu milonge, misoh kat e mikesi tengan imei visali. Ma, rut moletin xil lakes moletin xa meten bar labit, “Uhesi xouk. Mea soh. Xi di mikesuk.” ");
INSERT INTO tvk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma xi mistokovein kot nan, mitamea, e bemei visal Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Di, Iesu misisi bit, “?Xouk iem bei tengan napol ni naha minuk?” E ngan xa meten bar bit rilomun mini ni bit, “Titsa, ieok bei tengan upol ni nou niketeh rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma, Iesu biteni mini bit, “Neketen nam pol ni metom mei bos rilomun. Ha mun tim.” E vatakes, moletin ak miketeh rilomun e nggusil Iesu e suse nan luba. ");
INSERT INTO tvk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Melele xa Iesu del moletin nan xil lamei sangas ni Serusalem, xil mei lastal e metimal xalu te hal Betfas e Betani xa ludi sangas ni Vathu te Urvatiei te Olip. E rute ak, Iesu misil moletin nan lu ");
INSERT INTO tvk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","del sepinien ak bit, “Mulihe metimal xa da iaxor. E melele xa ha mulistal en, mulkamet sulut dongki tei xa labar xati xa moletin tovuol tamu vatotan e marin. Mullal rati e multela imei visal nou inggak. ");
INSERT INTO tvk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","E xosxa moletin tei isis xamil ihit, ‘?Veneh ma di mulopol ni mak?’ ma mulhiteni mini mulhit, ‘Suv iaxa ien bei tengan vapol ni neta tei vatela, e navehi ti, isa rilomun ni imei.’” ");
INSERT INTO tvk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma, rumali luba e lukamet sulut dongki tei xa de hale e ri suse, lasare de sangas visal puiteh te nim tei. E melele xa di lulal rat ao nen, ");
INSERT INTO tvk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","rut moletin xil xa di lasoh sangas lapus naha xa di lupol ni e mei lasis xalu labit, “?Veneh ma di mulal rat ao ra sulut dongki xai?” ");
INSERT INTO tvk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma eloheoh xalu lubit rilomun ni mi xil nggoni ngan xa Iesu tehiteni mi xalu, ma moletin xil ak lamaen xalu tengan lalihur dongki ak laliha. ");
INSERT INTO tvk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma, ludel sulut dongki ak be visal Iesu, xalu luden kot nalu da xol mar dongki ak e Iesu dotan en. ");
INSERT INTO tvk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Melele xa Iesu di nggo dongki ba, moletin xil holu mei lasak mesen suse nan. Laden kot nae xil e suse nan, e rute ngan xil ladei anguit liei xil xa ute di en e laling pilei di suse. ");
INSERT INTO tvk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Holu e vanut moletin xil ak xa di ladiamu ni Iesu del ngan xil xa di langgusili ladutou, xil di lakei nggeih labit, “!Ripet rat his Hi! !Tuxolxatien iti mi ngan xa di bemei e his Iahova! ");
INSERT INTO tvk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!Hi Suv ituxol xat xi xa di bemei tengan ilaxat xir ixoni ngan xa suv toto Deved tetiamu tepol ni! !Ripet rat his Hi xa de ut nesao!” ");
INSERT INTO tvk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E melele xa Iesu ba duxoh Serusalem, ba be Nim Eo na Hi e miketeh mikapis e holesok xil vus. Di, vengan xa ut sangas vamaluxoluk, mistal mun e dilomun be metimal te hal Betani del eloheoh lu e le tei (12) nan xil e lapat en. ");
INSERT INTO tvk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ut milan, melele xa di lakakao langgo Betani tengan latilomun lave Serusalem, mae nggat Iesu e suse. ");
INSERT INTO tvk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma miketeh be sotin vuteili e pus vatit fik tei da xa ute holu. Ma be sangas visali tengan valang vesi xos huit fik ti ladi en. E mikameti xa huite tovuol, be ute xil tang, vengan xa tave melele xati teni ti tengan vaso huite. ");
INSERT INTO tvk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Misak ni, Iesu biteni mi vatit fik ak bit, “!Moletin ti mun naxa huit xouk vatova!” E eloheoh nan xil lalong sepinien nan. ");
INSERT INTO tvk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Melele xa laduxoh Serusalem, Iesu be vioh te Nim Eo na Hi. Melele xa pusi xa rut moletin xil holu di lapos e di langgal holesok xil holu en, ien mikat, ma nggol rerat xil. Xi midivin rerat tep na ngan xil xa di laso papas mani e von totanen na ngan xil xa di lapos ni mae xil xa be sanien eo xil mi Hi. ");
INSERT INTO tvk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","E tamaen ti vari moletin vapo neta tova e vahur xoteh vioh te Nim Eo vatela. ");
INSERT INTO tvk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iesu pispisi mi moletin xil bit, “E Vanuvei Eo na Hi, latetisi latehit, ‘Likes nim mavan ni nim te sisen na moletin xil te kantri xil vus.’ E xamim mupol ni sung mei be ‘nim ma vati kanen xil.’” ");
INSERT INTO tvk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","E melele xa vat xil na pris xil del titsa xil te rae na Mosis lalong sepinien nan, lalang ves suse tengan lavas vin Iesu vaxo en. Vengan ulixil mikan ni Iesu e sexien xa moletin xil vus di latemanin ni xeihen te pispisien nan xil e di langgusili. ");
INSERT INTO tvk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Di, melele xa ut sangas vamaluxoluk, Iesu be reling Serusalem del eloheoh nan xil, e labe Betani tengan lapat en. ");
INSERT INTO tvk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ut milan, melele xa di langgusil suse labe Serusalem, eloheoh xil lapus vatit fik, e lakameti xa ut fik ak nesao meles e vatite etan mat tuei. ");
INSERT INTO tvk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","E Pita minem rilomun ni naha xa testal e biles biteni mi Iesu bit, “!Titsa, pus ti mu! Vatit fik xa otesa halesil teha xati mingguxu ngamu.” ");
INSERT INTO tvk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu bit rilomun ni mi xil bit, “Muling neketen namim e Hi. ");
INSERT INTO tvk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Reitin li nabiteni mi xamim, xosxa tei e xamim isemae ni vathu ak ihit, ‘Umea uhe reling voninom e ha uhe tas,’ e mutanem male ni ti naha xa di musisi, ma istal ihe reitin. Hi ipol ni e rin namim. ");
INSERT INTO tvk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Misak ni, nabiteni mi xamim xa melele xa musis ve neta ngan e muneket en xa mei muhuri reitin, ma Hi isa ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“E melele xa tei e xamim di misoh e misis, e minem neta tei xa misa xa moletin sav pol ni mini, iling ekaten nan iti e iketeh ihos rilomun mi moletin ak. Imak, ma Hi Tamemim mun xa de ut nesao iketeh ihos mini ve neta tesa xa xi pol ni.” ");
INSERT INTO tvk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesu dilomun be Serusalem del eloheoh nan xil. E melele xa labe vioh te Nim Eo, vat xil na pris xil, titsa xil te rae na Mosis, del elda xil na Siu xil lamei visal Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xil lasisi labit, “?Xouk di opol ni holesok xil ak e his visi? ?Visi vari maen xouk tengan opol ni?” ");
INSERT INTO tvk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Iesu bit rilomun ni mi xil bit, “Inou mun nisis xamim ni neta tei. Xosxa muhit rilomun ni minou, ma inou mun nihiteni mi xamim xa di napol ni holesok xil ak e his visi. ");
INSERT INTO tvk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","?Xamim muhit pisi minou, Sion Baptis tebaptaes ni moletin xil e di tepol e his visi? ?Hi mu moletin tova tang?” ");
INSERT INTO tvk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma xil laba, di langor mi xil mun tang labit, “?Rihit naha? Xosxa rihiteni rihit, ‘Sion di tepol e his Hi,’ ma xi ihiteni mi xir ihit, ‘?Xosxa temak, veneh ma mutnake reitin ti e sepinien nan?’ ");
INSERT INTO tvk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","E xosxa rihiteni rihit, ‘Xi di tepol e his moletin tang,’ ulixir mikan ni vanut moletin xil xa eilep xiak vengan xa xil vus lake reitin xa Sion Baptis tehe provet tei na Hi vari.” ");
INSERT INTO tvk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma xil mei labit rilomun ni mi Iesu labit, “Xamem matakil ti xa xi di tepol e his visi.” Ma Iesu biteni mi xil bit, “Xosxa imak, ma inou mun ninaviteni ti xa inou di napol ni holesok xil ak e his visi.” ");
INSERT INTO tvk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Di, Iesu dei vole tei mi vat xil na Siu xil bit, “Vatei, moletin tei milih urvatiei te grep tei san. Hortan ak pol ni vioh mikapis xole, e minggil vul tei da en xa ti lipel kikis huit grep xil en tengan sute teni ileh. Di, mikili ni vet tei xa be nesao tengan ti liketeh xole en. Melele xa pol vuol ni holesok xil ak, hortan ak maen moletin sav xil tengan mei lilaxati. E xil labit xati mini xa lisa ti huit grep mini melele xa limen. Di, xi mikakao ba de kantri sav tei. ");
INSERT INTO tvk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Huram vahis mei mitavi, e huit grep xil ak mei men. Ma hortan ak misil slev nan tei tengan ihe visal ngan xil xa di lalaxat urvatiei te grep san e ileh ti huite e itilomun mei isa ni mini. ");
INSERT INTO tvk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","E melele xa duxoh urvatiei ak, moletin xil xa di lalaxati ladal xat slev ak, labas purun ni, e lasil rati ba e taleh ti neta. ");
INSERT INTO tvk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ma, hortan ak misil slev nan teimun ba mi xil, e moletin xil xa lalaxat urvatiei ak labas vatin, lasak purun ni, e lasil rati ba. ");
INSERT INTO tvk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Di, hortan ak misil slev nan teimun tengan ha vapus xil, e labas vini sung. Misil slev nan holu mun e moletin xil ak lapol ni mi xil nggoni ngan taxa latepol ni tetiamu: rut slev xil labas purun xil, e rute xil mun labas vin xil vari. ");
INSERT INTO tvk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hortan ak pol ni mak ba vuma … natneli sutang da xa be siskes nan, ngan xa eheien nan di en. Ma di, hortan ak misil natneli xati be visal xil vengan minemi bit, ‘Xil limerere ni natuxoli xati sung.’ ");
INSERT INTO tvk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“E melele xa ngan xil xa di lalaxat urvatiei ak lapus natneli bemei, labiteni mi xil mun tang labit, ‘!Ei, nat hortan xati iaxa di bemei iaxor! Xi vari ihur urvatiei ak melele xa tata nan imat. !Mumei, rava ravas vini! !Imak, ma holesok nan xil mei ihe nar sung!’ ");
INSERT INTO tvk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma xil laba, ladal xati, e labasi mat. Di, lakuvun rat tiei nan ra urvatiei ak.” ");
INSERT INTO tvk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Di, Iesu misis vat xil na Siu xil xa di lateong ni vole ak bit, “?Ma midep? ?Hortan te urvatiei ak mei ipol ni naha mi moletin xil ak? Xi, itilomun e ihas lelen ngan xil xa latelaxat urvatiei san. Ti, imaen urvatiei san mi moletin sav xil tengan ti lilaxati. ");
INSERT INTO tvk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","?Midep? ?Xamim di mutavuli ti Vanuvei Eo? Vengan di misep usili bit, ‘Pos te nim xa moletin te polien xil di lasin ni, xi vari iaxa mei be seteman xati te nim xa mili sen pos nen xil vus. ");
INSERT INTO tvk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ngan ak, Iahova vari pol ni, e rapusi xa naha xa xi tepol ni tellep pupu.’” ");
INSERT INTO tvk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Melele xa Iesu misepin bus, vat xil na Siu xil lalong kila xa Iesu di dei vole ak ba xat rin nae. Ma iexil bei tengan latal xati, e ulixil mikan ni vanut moletin xil xa mahulong xiak xa di lamerere ni. Misak ni, labe relingi laba. ");
INSERT INTO tvk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Di, vat xil na Siu xil iexil bei tengan lalang ni mesal tova xa likila lital xat Iesu ixo en ve sepinien nan. Misak ni, lasil rut Farasi xil del rut Siu sav xil mun xa lasuv xat lelaxatien na suv toto Herod Antipas ba lapus Iesu tengan lasisi ni rin savsav xil. ");
INSERT INTO tvk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ma, xil labe visal Iesu e labiteni mini labit, “Titsa, xamem makila xa xouk obe hisit moletin tei xa, vehakut, di osepin ni neta xa be reitin, e otapet rat ti moletin tova vali moletin sav. Xouk di osepin mi moletin xil vus nggoni ngan xa xil vus lapin tang, e di opispisi mi xil vus ni sexien xa lakila lavusil xat suse na Hi vaxo rin xa be reitin. Ma, usa ti nenemien nam mi xamem usil rin ak. ?Rae na Mosis maen ni tengan xir, Siu xil, ti rixal takis iha mi suv toto te hal Rom, mu tamaen ni ti?” ");
INSERT INTO tvk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","E Iesu pus kila xa di lapol bos mini nggo hilbexil tang, e nenemien nae misa xati. Ma, bit rilomun ni mi xil bit, “?Veneh ma di musak pisi tengan muvoh xol inou? Musa mani tova xa di langgal takis ni mei nipus ti.” ");
INSERT INTO tvk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Melele xa lasa ni mini, misis xil bit, “?Valnao visi vari iaxa da en? ?E his visi iaxa de mani ak?” E labit rilomun ni mini labit, “Neta xalu vus xa ludi en be na suv toto te hal Rom.” ");
INSERT INTO tvk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma Iesu biteni mi xil bit, “Xosxa mak, ma momal tang tengan musa naha xa be na suv toto te hal Rom mini, e naha xa be na Hi, musa ni mini.” E melele xa lalong sepinien nan, latemanin pupu ni. ");
INSERT INTO tvk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","E melele nen ak, rut Satusi xil xa labit moletin misakras vamea rilomun ra maten labe visal Iesu, e lasisi labit, ");
INSERT INTO tvk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Titsa, Mosis tetisi tehit xosxa moletin tei imat reling atou nan e horamue nalu tovuol, ma tuneli sung iteli itel tunau ak. Imak, ma melele xa lalihur horamue tei nalu, lipusi ixoni ngan xa be na tiramue xa mat. ");
INSERT INTO tvk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vatei, tua tatei xil latehe lu e he sav (7) lateti vituei. Ngan xa tehe muimol teteli tetel atou tei. Di, xi temat e horamue nalu tehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Misak ni, tuneli xa tetutou ni mei tehur tunau nan. Luteti vituei teha vuma … xi temat e horamue nalu tehe tovuol. Di, sexien nen tak testal mun mi tuneli xa tetutou ni. Ma di, testal mun mi ngan xa tehe hat nen ");
INSERT INTO tvk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","e dit mak tang teha vuma … tetuxoh ngan xa tehe tasite e tua xil ak, e xi mun temat. E tua lu e he sav (7) ak, horamue nae tehe tovuol. E tetutou ni holesok xil ak, atou ak mun temat. ");
INSERT INTO tvk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","?Ma xosxa mea rilomunen be reitin, melele xa moletin xil vus limea rilomun ra maten, ngan xave e tua xil xa labe lu e he sav (7) xiak iaxa ihur atou ak ihe nan xati, vengan xil vus lateteli tetela?” ");
INSERT INTO tvk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu bit rilomun ni mi xil bit, “Xamim di mule ras suse namim vengan xa mutakil kuh ti Vanuvei Eo na Hi mu xeihen nan. ");
INSERT INTO tvk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vengan e melele xa moletin xil limea rilomun ra maten, xil mei lixoni masxaxa xil xa ladi ut nesao, e sexien te tetelien ihe tovuol mun. ");
INSERT INTO tvk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","?E veneh ma mutake reitin ti xa moletin xil likila limea rilomun ra maten? ?Mutavuli ti mu tisen na Mosis e melele xa Hi tesepin mini texo holiei tei? Vengan Hi tehit, ‘Inou nabe Hi na Ebraham, Hi na Aesak, e Hi na Siekob.’ ");
INSERT INTO tvk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","?Mulonge? Xi be Hi na ngan xil xa lameul tamu ladi, e tave na ngan xil ti xa lamat. Ngan ak di pisen ni xa nenemien namim tamal ti vari.” ");
INSERT INTO tvk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Titsa tei te rae na Mosis di miteong ni naha xa Satusi xil latesis Iesu ni e tetep xa Iesu tehit rilomun ni sepinien xa tehos mi xil. Ma xi mea, be visal Iesu e misisi bit, “?Rae xave vari iaxa be eilep mak mu mili sen rae xil vus?” ");
INSERT INTO tvk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","E Iesu bit rilomun ni mini bit, “Rae xa be eilep mak mu mili sen rae sav xil, xiak, ‘!Mol‑Isrel xil, muteong! Iahova xa di ramot mini, xi kestang be Hi. ");
INSERT INTO tvk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Iemim ihei Iahova xa be Hi namim ixo tinemim tevi, ixo meulien tevi namim, ixo nenemien tevi namim, e ixo xeihen tevi namim.’ ");
INSERT INTO tvk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","E teimun xa nggoni tang e be lu nen di biteni bit, ‘Eheien namim iti e moletin sav xil ixoni ngan taxa eheien namim di e xamim mun tang.’ E rae sav xil mun tovuol xa vahe eilep mak mu vali rae xalu ak.” ");
INSERT INTO tvk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Titsa te rae na Mosis biteni mini bit, “Titsa, sepinien nam momal tevi. Reitin mak xa Iahova kestang be Hi, e hi sav tovuol, nggoni ngan xa obiteni. ");
INSERT INTO tvk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E reitin mun xa iexir ihei Iahova xa be Hi nar ixo tinexir tevi, ixo nenemien tevi nar, e ixo xeihen tevi nar. E reitin mun xa eheien nar iti e mosav xil ixoni ngan xa eheien nar di xir mun tang. Rae xalu ak lube eilep mak mu luli sanien eo xil vus xa rakila rasa ni vaha mi Hi.” ");
INSERT INTO tvk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Melele xa Iesu miteong ni xa moletin ak misepin del metisouen, biteni mini bit, “Sangas tang tengan Hi mei vahe suv toto e meulien nam.” Ma, e melele nen ak ba, moletin xil ulixil mikan xa lasis ti mun neta mini. ");
INSERT INTO tvk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Melele xa Iesu di pispisi mi moletin xil e vioh te Nim Eo, misis xil bit, “?Veneh ma titsa xil te rae na Mosis di labiteni labit Mesaea mei istal ixo vatimol na suv toto Deved? ");
INSERT INTO tvk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vengan Deved iaxa tekesi ni ‘Suv’ e melele xa Ninin Eo tesa nenemien ak mini tengan ihit, ‘Iahova biteni mi Suv navan bit, “Utotan inggak e riuk metu, ituxoh melele xa niling elu nam xil e hem.”’ ");
INSERT INTO tvk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Suv toto Deved vari tekes Mesaea ni ‘Suv nan.’ ?E vengan xa rakila xa tata tei misakras vakes natneli ni ‘suv,’ Mesaea istal ixo vatimol na Deved itep?” Moletin xil holu di lateong ni sepinien na Iesu, di labesi xil tova tang ve pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Melele xa Iesu di tamu pispisi mi moletin xil e vioh te Nim Eo, biteni mi xil bit, “Muxuxou kuhi ve sexien na titsa xil te rae na Mosis. Vengan xa di lapol ni sexien xil taxa mosav xil ti lipus xil e ti lisa merereen mi xil ven. Iexil bei tengan lasing ni eising hos xil xa tepiei na eilep xil, e likakao e von posen xil tengan moletin xil lipus kil xil e lisemin xil itel merereen. ");
INSERT INTO tvk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","E melele xa labe nim te pispisienxil mu anien xil xa tellep, xil di lalepis vontoen xil xa bos xa be na ngan xil kestang xa lapo his xil xa latellep. ");
INSERT INTO tvk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","E, ve hokanen nae, titsa xil ak di laleh xuxus ni holesok xil holu ra tunau xil. E pe met moletin xil, di lapol ni sisen xil xa tepiei. !Ve rin ak, Hi isa pangasien xil xa isa pupu iha xat xil ili ngan tesav xil!” ");
INSERT INTO tvk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Melele xa Iesu da tamu e vioh te Nim Eo na Hi, miketeh e pus moletin xil xa di lasa mani tengan vatutou ni polien te Nim Eo. Moletin holu lamei xa holesok nae xil holu, e xil di laso mani holu. ");
INSERT INTO tvk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Di, miketeh mun e pus tunau tei xa be hoeo bemei, e xi miso selen lu (2) tang. ");
INSERT INTO tvk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Iesu mikes viton eloheoh nan xil e biteni mi xil bit, “Reitin li nabiteni mi xamim, tunau xa be hoeo iaxai misa sanien nan mili sen ngan tesav xil xa laso mani tengan vatutou ni Nim Eo. ");
INSERT INTO tvk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vengan xa ngan tesav xil di lasa sanien nae xa be rute tang te holesok nae xil, e eilep be nae. E tunau ak xa be hoeo tang, xi di misa vuol ni mani xa vahe te anien an.” ");
INSERT INTO tvk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Melele xa Iesu be reling vioh te Nim Eo del eloheoh nan xil, tei e xil biteni bit, “Titsa, pus ti mu nim xil xa mahulong xiak te Nim Eo xa latepol kuhi ni ni hat xil xa mahulong iaxai.” ");
INSERT INTO tvk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Iesu biteni mi xil bit, “?Xamim di mupus nim hos xil ak xa mahulong mak? Reitin li nabiteni mi xamim, melengien tei di bemei xa hat xil ak navistin xil ti mun. Moletin xil mei lihu lelen xil vus ihe tan.” ");
INSERT INTO tvk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Di, Iesu be Vathu te Urvatiei te Olip e ba dotan e seri hu e di miketeh pus Nim Eo de rin. Ma, Pita, Temis, Sion, e Andru labe visali, e xatel latsisi tengan vahit kil sepinien nan latbit, ");
INSERT INTO tvk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“?Uhiteni mi xametel li, lihu lelen Nim Eo vilieh vari? ?E naha vari ipisen ni xa holesok xil ak di bemei sangas?” ");
INSERT INTO tvk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Di, Iesu bit rilomun ni mi xil bit, “Muxuxou kuhi ve xamim, e munamaen ti moletin mei naluvos xamim. ");
INSERT INTO tvk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vengan moletin xil holu limei e hisok e lihiteni lihit, ‘!Inou nabe Mesaea!’ Ma liluvos moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ti mulongeong ni xa vaeen xil xa tellep di bemei, e muhur longeongen mun usil vaeen xil xa di rute xil xa be sotin. E munatemanin ti ven. Holesok xil ak iaxa mei istal itiamu, e nave hoxalite te ut etan ti mu. ");
INSERT INTO tvk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vengan xa ut tei ivae itel ut tei mun, e kantri xil lihas tan ni kantri sav xil. E ut xil hao e ut etan, lul holu ilil e mae kekaten ihas moletin xil holu. E ngan ak nave hoxalite ti mu. Holesok xil ak mei istal ixoni melele xa atou tei xa milong rohon ni mar pangasien xa di pisen ni xa, nave nousav ti, iling tuvava nan. ");
INSERT INTO tvk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Muketeh kuhi ve xamim. Melengien tei imei xa moletin xil mei lital xat xamim e lilepis xamim e kot nae xil e lihas purun xamim e nim te pispisiennae xil. E vengan xa munggusil inou, lileh xamim ha musoh pe met vat e suv toto na moletin xil. Melele ihe mesal tengan muhithiten longeongen hos na Hi mi xil. ");
INSERT INTO tvk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vengan, itiamu, longeongen hos na Hi ha ituxoh rute xil vus e ut etan tengan moletin xil vus likila, ti, hoxalite te holesok xil vus mei istal sung. ");
INSERT INTO tvk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“E melele xa xil lital xat xamim e lileh xamim muhe kot nae, munanexo ti ve naha xa ti muviteni mi xil. Vengan xa, e melele nen ak, Ninin Eo isa naha xa mukila muhithiteni. Reitin, nave xamim ti xa ti musepin, e ihe Ninin Eo iaxa ti isepin ixo xamim. ");
INSERT INTO tvk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“E melele nen ak, moletin xil ti limaen tuexil tengan ha lihas vin xil, e tata xil mun ti lipol ni imak tang mi horamue nae xil. E horamue xil mun lihiles ni tamexil e ninexil e limaen xil lihe he ngan xil xa lihas vin xil. ");
INSERT INTO tvk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Moletin xil vus iexil iat xamim vengan xa di munggusil xat nou. E xamim xa ti musoh ixeih ituxoh hoxalite te sakpurunien xil ak, ma Hi iteh meulien e xamim. ");
INSERT INTO tvk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“E melele xa mupus ‘neta tei xa be muis pupu pe met Hi’ ite ut eo xa tamal ti tengan vata en, ma momal tengan ngan xil xa ladi e provins te hal Sudea litemanon lilesae ha lixus liti e vathu xil. (Xouk xa di obuli sepinien ak, bos tengan ukil kuh koute teni.) ");
INSERT INTO tvk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Xosxa moletin tova di mingel e hale, mesal ihe tovuol tengan vatilomun vahe nim e vahur neta tova nan. ");
INSERT INTO tvk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","E xosxa moletin tei di pol e naho, xi nava ti mun tim tengan vahur eising tova nan. ");
INSERT INTO tvk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","E melele nen xil ak, isa pupu mi atou xil xa ladi ni tuvava xil e ngan xil mun xa di latunat ni tuvava xil. ");
INSERT INTO tvk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Musis mi Hi ve holesok xil ak, tengan mei natuxoh xamim ti e melengien te an tesa. ");
INSERT INTO tvk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vengan longpangasien xil te melengien tesa xil ak isa ili melengien sav xil vus te ut etan, e melele xa Hi tepeas ni ut etan mei duxoh xosali, mu e melengien xil mun xa ti imei. ");
INSERT INTO tvk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","E Hi Suv teta xoteh melengien tesa xil ak mei ihe tamure mu vengan xa xi di minem usil ngan xil xa tehosei xil labe nan. Vengan vahit napol ni ti namak, ma moletin ti mun nameul. ");
INSERT INTO tvk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“E melele nen ak, xil lihiteni lihit, ‘!Mupus ti! !Ngan ak be Mesaea xa Hi tehosei!’ Mu lihiteni lihit, ‘!Mupus ti mu! !Xi iaxa da iaxor!’ E xamim, munake reitin ti e sepinien xil ak. ");
INSERT INTO tvk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vengan mesaea te luvosen xil e provet te luvosen xil mun limei. E melele xa limei, lipol ni merekel xil e holesok xil xa tellep xa isak ni moletin xil limesep pupu ven. Xil lipol ni tengan liluvos moletin xil holu tengan mei lihusil xil. E lisak pisi tengan lilihi rerat ngan xil mun xa Hi tehosei xil labe nan xosxa lakila lapol ni. ");
INSERT INTO tvk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma muxuxou kuhi, e munem xati xa natehit lelen ni ngamu mi xamim holesok xil ak xa mei istal. ");
INSERT INTO tvk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“E melele xa melengien tesa xil ak ivus, ‘Eai ihiles mei imaluxoluk e aveti namem ti mun.’ ");
INSERT INTO tvk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","‘Hitu xil likiri ra tilang hat, e holesok xil mun xa di nesao, Hi imulul ni xil.’ ");
INSERT INTO tvk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti, moletin xil lipus ‘Nat Moletin imei etan itel momah xil te tilang hat.’ Xi imei itel minehinen te xeihen nan xa ihe mahulong pupu. ");
INSERT INTO tvk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Xi isil masxaxa nan xil lihe rute xil vus e ut etan, lixo rin tei ha ituxoh rin tei mun, tengan lileh viton moletin xil vus xa Hi tehosei xil labe nan.” ");
INSERT INTO tvk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesu biteni mun mi Pita xatel bit, “Momal tengan xamim muhur pispisien ixo vatit fik. Melele xa lite xil miso rohon ni ute xil xa be neta hu, xamim mukila xa melele te an te tin di bemei. ");
INSERT INTO tvk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Usil sexien nen tak, melele xa mupus holesok xil ak mei istal, mukila xa mei rilomunen navan, Nat Moletin, di bemei sangas. Reitin, da ngamu e puiteh. ");
INSERT INTO tvk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Reitin li nabiteni mi xamim, holesok xil ak mei istal e melele xa moletin xil te xosali ak limeul tamu liti. ");
INSERT INTO tvk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nabiteni reitin, vengan xa neta sav xa ut etan itel tilang hat mun lalikesae e melengien tei, sepinien navan misakras vakesae vatova. Ma mukila muke reitin en.” ");
INSERT INTO tvk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Di, Iesu biteni mun bit, “Moletin tovuol xa vakil melengien xati xa inou, Nat Moletin, nitilomun en. Reitin, masxaxa xil xa ladi ut nesao, e inou mun, Nat Hi, matakil ti. Hi Tamer kestang mikil haoa xati teni. ");
INSERT INTO tvk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ma, muketeh kuhi e ti muvue xat xamim, vengan xa mutakil ti melengien xa nitilomun en. ");
INSERT INTO tvk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ixoni ngan xa vahit eilep tei vahe reling tim san tengan vahe rute sav tei. Ma, iling moletin te polien nan xil tengan lilaxat kuh holesok nan xil, ti lipol ni polien savsav xil xa miseti mi xil, e ngan xa be mereketeh tengan iketeh kuhi ve mei rilomunen nan. ");
INSERT INTO tvk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","!Mak, ma muketeh kuhi! Vengan mutakil ti xa inou, eilep namim, nitilomun vilieh. Xos nimei e mahis, mu e hilaep te vongien, mu ut nalan ti mu, mu e makoe. ");
INSERT INTO tvk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","E melele xa nistal en, munatemanin ni ti. Isa xosxa nikameti xa di mupat. ");
INSERT INTO tvk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mak, ma sepinien xa di nabiteni mi xamim taxeak, nabiteni mun mi moletin xil vus, ‘!Muketeh kuhi!’” ");
INSERT INTO tvk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Melengien vahis mei mitavi, e melengien lu sutang di e ihe Melengien xil te Beret xa Is Tovuol En. E melengien kokot teni vari, xil lapol ni Anien te Tavien. E vat xil na pris xil del titsa xil te rae na Mosis di lalang ves suse tengan latal xat xuxus ni Iesu e lavasi vamat vaxo en. ");
INSERT INTO tvk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","E labiteni labit, “Rinapol ni ti e melengien te Anien te Tavien vengan, maxani, moletin xil linavae mi xil mun tang.” ");
INSERT INTO tvk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E melele xa Iesu da tamu e metimal te hal Betani, xi ba di ngganien e tim sa Saemon xa, tetiamu, mesien leporsi tepurun tenben. Di, atou tei bemei nim e nggur valit vokon tei xa lapol ni valite ni hat hos tei xa lakesi ni alabasta. Vokon ak, mani teni nggeih. E xi bemei visal Iesu e rute xa dotan da en, e mideh vokon ak ba xat vatin tengan vapisen merereen nan mini. ");
INSERT INTO tvk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E melele xa rut moletin xil lapusi, iexil nggati e laseputut ni labit, “?!Veneh ma di purun vokon ak mak!?” ");
INSERT INTO tvk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma labul xati labit, “Vahos mak mu vahit ha vapos ni vokon ak ni mani tova xa eilep. Ti, mani nen mikila vatutou ni hoeo xil.” ");
INSERT INTO tvk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","E Iesu biles e biteni mi xil bit, “!Ei, mustokovein ni! ?Veneh ma xamim di mubul xat atou ak? Xi pol ni neta tei xa bos pupu minou. ");
INSERT INTO tvk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vengan hoeo xil liti visal xamim vehakut, e mukila musa tutouen mi xil e melengien xil vus. E inou, nasakras nate visal xamim vahehi. ");
INSERT INTO tvk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Atou ak di pol ni naha xa xi mikila vapol ni e rin navan. Vengan xa melele xa mideh vokon ak ba xat tenbeok, xi di misak mesen nou ve tehinen navan. ");
INSERT INTO tvk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Reitin li nabiteni mi xamim, e rute xil vus xa lihithiten longeongen hos usil nou en, xil lihit usil naha xa atou ak tepol ni minou. E isak ni moletin xil linem xati ven.” ");
INSERT INTO tvk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Di, Sudas Eskariot, xa be tei e xil xa labe lu e le tei (12) na Iesu, ba pus vat xil na pris xil tengan vapol ni suse xa vasa rat Iesu mi xil vaxo en. ");
INSERT INTO tvk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","E melele xa lalong sepinien nan, lamaal pupu e labit xati xa lixale ven. Mak, ma Sudas ba di milang ni mesal xa bos tengan isa rat Iesu ihe hexil ixo en. ");
INSERT INTO tvk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","E melengien kokot te Melengien xil te Beret xa Is Tovuol En, e melele xa di labas sulut sipsip xil ve Anien te Tavien, moletin na Iesu xil lamei visali e lasisi labit, “?Rute xave iaxa iem bei tengan masak mesen Anien te Tavien en?” ");
INSERT INTO tvk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma Iesu misil moletin nan lu del sepkilaen ak bit, “Luha. Mulhe taon te hal Serusalem, e moletin tei xa di po valoei tei xa mahulong mei ihisu mi xamil. Mulhusili ");
INSERT INTO tvk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","e mulihe nim xa xi iha en. Ti, mulsis moletin xa nim ak be man mulihit, ‘Titsa bit, “?Vontoen xave iaxa nitel moletin navan xil mei mua Anien te Tavien en?”’ ");
INSERT INTO tvk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Xi itel xamil mulhe von toen nesao e nim man e ipisen rute tei xa mahulong xa lasak xati ngamu datil xamil. Rute ak vari iaxa mulsak mesen holesok xil vus en.” ");
INSERT INTO tvk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma xalu lube Serusalem, e lupus holesok xil vus nggoni ngan taxa Iesu tehiteni mi xalu. E lusak mesen Anien te Tavien en. ");
INSERT INTO tvk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","E melele xa eai ba minu, Iesu bemei e dotan e von anien en del moletin lu e le tei (12) nan. ");
INSERT INTO tvk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E melele xa di langganien, Iesu bit lelen ni mi xil bit, “Reitin li nabiteni mi xamim, tei e xamim xa di ngganien vituei del inou taxeak, xi iaxa isa rat nou nihe he elu navan xil.” ");
INSERT INTO tvk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Melele xa lalonge mak, xil lalonge misa pupu, ma xil kekes di lasis Iesu labit, “?Suv midep li, onemi obit inou?” ");
INSERT INTO tvk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","E Iesu bit rilomun ni mi xil bit, “Reitin, tei e xamim vari xa di ngganien vituei del inou iaxa isa rat nou niha. ");
INSERT INTO tvk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Be reitin xa inou, Nat Moletin, nimat ixoni ngan xa Vanuvei Eo di misepin ni. !E isa pupu mi ngan xa isa rat nou! Moletin ak, vahos mak mu vahit linapesi ti vengan xa pangasien xa Hi isa ni mini ihe eilep pupu.” ");
INSERT INTO tvk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Melele xa di langganien, Iesu nggur beret tei e memes Hi ven. Di, bul pasi, e melele xa di miseti mi moletin nan xil, xi biteni bit, “Muhuri mua ni. Ngan ak be tenbeok.” ");
INSERT INTO tvk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Di, nggur kap xa uaen di en, memes Hi ven, e melele xa misa ni mi xil, xil vus lamu ni vuteili. ");
INSERT INTO tvk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Di, biteni mi xil bit, “Uaen ak be ra navan xa isak ni hitxatien hu te xeih na Hi mei istal e ihe reitin. Reok ileh ve moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Reitin li nabiteni mi xamim, ninamu ti mun uaen ak ituxoh melele xa nimu uaen hu e rute xa Tata navan be suv toto en.” ");
INSERT INTO tvk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","E melele xa langganien bus, lakikei ni sisien tei e lastal labe Vathu te Urvatiei te Olip. ");
INSERT INTO tvk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Melele xa laduxoh Vathu te Urvatiei te Olip, Iesu biteni mi moletin nan xil bit, “Xamim vus mulesae reling nou ixoni ngan xa Hi tehiteni e Vanuvei Eo xa tehit, ‘Inou nihas moletin xa di milaxat sipsip xil, e sipsip san xil liletasil relingi.’ ");
INSERT INTO tvk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","E melele xa nimea rilomun ra maten, inou nitiamu ni xamim ha nite Kaleli.” ");
INSERT INTO tvk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","E Pita mitamea e biteni mini bit, “!Tave ti neta xa moletin sav xil vus lilesae relinguk, inou ninave relinguk ti vatova!” ");
INSERT INTO tvk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Iesu bit rilomun ni mini bit, “Reitin li nabiteni minuk, e vongien tak, melele xa ut nalan ti mu e tuto xil linakorat ti mu nave valu, e xouk uhiteni ihe vatol xa otakil ti nou.” ");
INSERT INTO tvk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","E Pita biteni nggeih pilei sung bit, “!E‑e, namak ti! !Tave ti neta xa nimat itelak, inou nasakras namiteni xa natakil ti xouk!” E ngan tesav xil mun labiteni mak tang. ");
INSERT INTO tvk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Di, Iesu be rute tei xa lakesi ni Ketsemani del moletin nan xil. Melele xa laduxoh rute ak, xi biteni mi xil bit, “Mutotan muti tak e ti mutatil nou. Inou niha nisis inggaxor.” ");
INSERT INTO tvk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xi nggur Pita, Temis e Sion latnggusili. E melele xa latoba, nenemien na Iesu basi holu e milonge misa pupu. ");
INSERT INTO tvk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma xi biteni mi xatel bit, “Tinok li meas pupu, e nalonge lehit ngan xa bit vahas vin nou. Mutti tak, e ti mutiketeh itel nou.” ");
INSERT INTO tvk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Di, Iesu mikakao reling xatel vuteili tang, mitingeiril be tan e misis mi Hi tengan vahur rat longpangasien te melele te xeih ak xa di bisu ni vahe relingi nggusil nenemien nan. ");
INSERT INTO tvk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Misak ni, xi misis bit, “Tata navan li, xosxa suse sav tova mun da tamu, uhur rat longpangasien ak ihe reling nou li. E onapol ni ti naxoni ngan xa inou ieok bei, e upol ni ixoni ngan xa xouk kestang iem bei.” ");
INSERT INTO tvk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Di, xi dilomun be visal xatel e mikameti xa di latopat. Ma xi biteni mi Pita bit, “?Saemon Pita, veneh ma di opat mak? ?Mutsakras mutoketeh vatel inou vahe haoa tei takes? ");
INSERT INTO tvk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mutiketeh e ti mutisis tengan mutnamot ti e melele xa sakpisien xil imei e xamitel. E tinemitel, iemitel bei tengan mutopol ni neta tei xa momal, e tenbemitel memel.” ");
INSERT INTO tvk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Di, Iesu dilomun ba e misis ni sisen taxa tesis ni tuei. ");
INSERT INTO tvk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","E melele xa Iesu dilomun, mikameti xa termali latopat mun vengan latsakras latohur xat metxeih natel. E melele xa latlale, latbe unoun, e lattakil ti naha xa lathiteni mini. Di, Iesu be reling xatel vatei mun ba. ");
INSERT INTO tvk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","E melele xa Iesu dilomun bemei visal termali vatol nen, bul xat xatel bit, “?Di tamu mutopat? ?Di tamu mutongel? !Mutopat pipin! !Topus ti! Taxeak be melele xati xa lisa rat nou, Nat Moletin, nihe he moletin tesa xil. ");
INSERT INTO tvk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","!Tomea, ratoha! ?Mutpusi? Moletin xa isa rat inou, xi tuei xa di bemei iaxor.” ");
INSERT INTO tvk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Melele xa Iesu di tamu misepin, Sudas xa be tei e eloheoh lu e le tei (12) nan mistal. Xi bemei del xat vanut moletin xil xa di laleh xat tiei del homenda xil te vaeen. Xil lamei langgusil nenemien na vat xil na pris xil del titsa xil te rae na Mosis e elda xil na Siu xil. ");
INSERT INTO tvk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","E be Sudas iaxa teling nenemien nan tengan isa rat Iesu mi elu nan xil. E tehit kil suse xa ipisen Iesu mi xil ixo en tehit, “Moletin xa nipesum ni vin, ma xi vari xiak. Mumei mutal xati e mereketeh namim xil litela iha.” ");
INSERT INTO tvk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E melele xa lamei, Sudas mika mal be visal Iesu e bit, “Titsa, bos vongien li.” Di, mei po xati e pesum ni vin. ");
INSERT INTO tvk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Di, vanut moletin xil ak lamei ladal xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","E moletin tei xa misoh visal Iesu milihi rat tiei te vaeen nan e da xoteh vurang slev tei na vatixar na pris xil. ");
INSERT INTO tvk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","E Iesu misepin mi xil bit, “?Veneh ma di muleh tiei e homenda xil te vaeen tengan mei mutal xat nou? ?Munemi mubit inou iaxa di nadiamu ni moletin xil tengan mavae vaha xat kavmen nar? !E‑e! ");
INSERT INTO tvk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Melengien xil ngasen nateti vangit vioh te Nim Eo e di natepispisi mi moletin xil, e xamim mutnamei ti tengan mutal xat nou. E holesok xil vus ak mei mistal tengan vasak ni naha xa latetisi e Vanuvei Eo mei vastal vahe reitin.” ");
INSERT INTO tvk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E melele xa ladal xati, moletin nan xil vus lalesae relingi. ");
INSERT INTO tvk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","E tei xil tehe horam maxoe xa tepis xol xi ni kaliko tang. Melele xa lapo xat pisi, ");
INSERT INTO tvk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","xi be reling eising nan e miloh hon tang ba. ");
INSERT INTO tvk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ngan xil xa ladal xat Iesu ladela labe tim sa vatixar na pris xil. E rute ak, vat xil na pris xil, titsa xil te rae na Mosis del elda xil na Siu xil di lamei vituei. ");
INSERT INTO tvk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","E Pita di mika xus e di nggusil vanut moletin xil xa di ladel Iesu laba vuma … laduxoh vioh te tim sa vatixar ak. E rute ak, Pita be vangit vioh e ba dotan del mereketeh xil sangas visal upang nae tengan vatali. ");
INSERT INTO tvk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vat xil na pris xil del eilep sav xil mun na Siu xil di lalang ni moletin tova xa mei ihit rat neta tova xa misa xa Iesu tepol ni tengan likila lihasi imat ven. E lasakras. ");
INSERT INTO tvk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vengan xa, tave ti neta xa moletin holu lamei e lapol ni luvosen ba xat Iesu, sepinien nae xil vus misav ni xil. ");
INSERT INTO tvk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Di, moletin vahis mei lasoh e laluvos ni sepinien nae ba xat Iesu mi ngan xil e kot labit, ");
INSERT INTO tvk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Xamem matelonge xa moletin ak tehit, ‘Inou nihu len Nim Eo na Hi xa moletin xil tang latepol ni. Ti, nikili ni teimun e melengien tol tang xa nave moletin ti napol ni.’” ");
INSERT INTO tvk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","E sepinien ak mun, sepinien nae tamal ti. ");
INSERT INTO tvk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma vatixar mitamea pe met moletin xil vus e misis Iesu bit, “?Ma midep? Xouk di olong sepinien xa di lasepin ni ba xatuk. ?Neta tovuol xa obit oviteni?” ");
INSERT INTO tvk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","E Iesu dat votei, tavit ti sepinien vari. Ma vatixar misisi mun bit, “?Reitin xa xouk obe Mesaea xa Hi tehit xati xa isa ni imei? ?Xouk obe Nat Xi xa di rapet rat Hisen?” ");
INSERT INTO tvk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu bit rilomun ni bit, “Inou vari. E navehi ti, xamim mupus … ‘Nat Moletin itotan ite ri metu na Hi Suv te Xeihen. !E mupusi imei e ut etan ixo momah xil te tilang hat!’” ");
INSERT INTO tvk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Melele xa vatixar milong sepinien nan, ien mikat xa mikat, dal papas eising nan e mikei nggeih bit, “?!Mulonge!? ?Veneh ma di ralang ni sepinien tova mun tengan vaha xati? ");
INSERT INTO tvk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","!Xamim vus mulonge xa di misep purun his Hi! ?Munemi xa ti ripol ni naha mini?” E xil vus lamae e nenemien tei takes xa momal tang tengan imat. ");
INSERT INTO tvk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Di, rute ngan xil lakusah ba xati e labar xat meten. Di, lalevesi e labit, “?!Hit lelen neta tova mi xamem, visi iaxa diuk!?” E mereketeh xil mun labas purun ni. ");
INSERT INTO tvk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Melele xa Pita di tamu dotan e vangit vioh te nim ma vatixar na pris xil, atuli tei te polien nan bemei sangas visali. ");
INSERT INTO tvk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Melele xa pus Pita di dal upang, miketeh momal ni e biteni bit, “!Xouk mun di otehusil Iesu te hal Nasaret!” ");
INSERT INTO tvk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","E Pita muun xole bit, “!Tave reitin ti! Inou natakil ti naha xa di obiteni iaxai.” Di, Pita mitamea e mikakao ba ve puiteh te vioh. E tuto tei mikorat. ");
INSERT INTO tvk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Atuli te polien ak bemei e pus rilomun ni Pita. Ma, biteni vatei mun mi moletin xil xa di lasoh sangas visali bit, “!Moletin ak mun be tei e xil!” ");
INSERT INTO tvk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E, vatei mun, Pita muun xole. Tavehi ti, e moletin xil xa lasoh ladi visal Pita labiteni mini labit, “Xouk vari obe tei e xil vengan sepinien nam nggoni ngan Kaleli xil tang.” ");
INSERT INTO tvk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","E Pita misepin nggeih bit, “!Natakil ti moletin xai vari xa di musep usili iaxai! !Hi isa halesil iha xat nou xosxa sepinien navan be luvosen!” ");
INSERT INTO tvk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vatei takes, tuto mikorat be valu nen. E melele xa Pita milonge, minem rilomun ni naha xa Iesu tehiteni mini tehit, “Ut nalan ti mu e tuto xil linakorat ti mu nave valu, e xouk uhiteni ihe vatol xa otakil ti nou.” Ma tinen pangas e di muis nggeih. ");
INSERT INTO tvk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","E makoe roroh, vat xil na pris xil latemanon lamei vituei del elda xil na Siu xil, titsa xil te rae na Mosis, e ngan xil vus xa ladi e kaonsel na Siu xil. Lasep usil rin na Iesu e lamei e nenemien tei takes tengan ha imat. Ma, labar xati e ladela be visal Paelet xa be vat te kavmen te rute ak tengan lasa rati vaha mini. ");
INSERT INTO tvk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Melele xa suv Paelet pusi, misisi bit, “?Midep? ?Be reitin xa xouk obe suv toto na Siu xil?” Iesu bit rilomun ni mini bit, “Nggoni ngan taxa xouk di obiteni.” ");
INSERT INTO tvk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Di, vat xil na pris xil lamei e labit rat holesok holu xa misa xa labit Iesu di tepol ni. ");
INSERT INTO tvk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma Paelet misis Iesu bit, “?Otalong ti sepinien xil xa di labiteni ba xatuk xiak? ?Sepinien nam tovuol tengan ovit rilomun ni mi xil?” ");
INSERT INTO tvk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","E Iesu dat votei tang. Melele xa Paelet pus sexien nan, mesep pupu ven. ");
INSERT INTO tvk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Be sexien matu tei na suv Paelet xa, e melengien xati te Anien te Tavien, xi di maen moletin tei xa moletin xil labosei tengan ha ven imase ra nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","E melele nen ak, vatxeih tei de nim te xeih del vat vaeen sav xil, hisen Barabas. Xil latehas vin moletin tei e melele xa latevae tetel kavmen te hal Rom. ");
INSERT INTO tvk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma melele xa Paelet pusi xa vanut moletin xil ak di lamei visali tengan lasisi vamaen moletin tova ha ven vamase vahusil sexien matu nan, ");
INSERT INTO tvk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","misis xil bit, “?Midep, iemim bei tengan nimaen suv toto na Siu xil ha ven imase?” ");
INSERT INTO tvk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paelet misis xil mak vengan xa pus kila xa vat xil na pris xil di lasa rat Iesu mini vengan xa di lanem misa ni tang. ");
INSERT INTO tvk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","E vat xil na pris xil lasi petine vanut moletin xil ak tengan lisis Paelet imaen Barabas ha ven imase, e nave Iesu ti. ");
INSERT INTO tvk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma, Paelet misis xil vatei mun bit, “?Xosxa imaxai, ma nipol ni naha mi Iesu xa xamim mukesi ni suv toto na Siu xil?” ");
INSERT INTO tvk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E lakei be nesao labit, “!Ti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paelet misis xil bit, “?Veneh? ?Xi pol ni naha xa misa?” E lakei nggeih pilei sung labit, “!Ti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paelet ien bei tengan vasak ni nenemien na vanut moletin xil ak vahe tan, ma nggusil eheien nae, xi maen Barabas ba ven mase. E mi Iesu, xi misemae ni tengan moletin te vaeen nan xil ha limeas pangasi ni ao te xeih xa sanute xil di en, ti, litela iha tengan liti xati e eivave tei. ");
INSERT INTO tvk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Melele xa lameas pangas Iesu bus, moletin te vaeen xil ladela labe vangit vioh te nim xa eilep ma Paelet xa be vat te kavmen te rute ak. Di, lakes viton moletin te vaeen sav xil vus xa ladi en tengan lamei vituei. ");
INSERT INTO tvk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xil lasing xol Iesu ni kaliko tei xa pili nggoni ngan na suv toto xil. Di, langgil xat vatluvoluv tei ni ao tei xa sanute xil tepiei di en, e lasili xol vatin. ");
INSERT INTO tvk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Di, lapol pepamen ni nggoni ngan xa xi be suv toto tei e labiteni mini labit, “!O suv toto na Siu xil, xamem di mamerere ni xouk!” ");
INSERT INTO tvk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Di, labasi ni liei tei di vatin e lakusah ba xati. Di, latingeiril pepamen pe meten nggoni ngan xa di lasa merereen nae mini. ");
INSERT INTO tvk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Melele xa lapol pepamen ni bus, langgur rat kaliko te pili ak be relingi, e lasing xole ni eising nan mun. Di, ladela ba tengan ha liti xati e eivave tei. ");
INSERT INTO tvk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Melele xa moletin te vaeen xil di ladel Iesu laba, xil labisu ni moletin tei e suse xa nggo rute sav e di bemei be Serusalem, hisen Saemon te hal Saerin, tame Aleksanda xal Rufas. Ma moletin te vaeen xil lamei visali e langgeih xati tengan vapo eivave na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Di, ladel Iesu ba labe nesao e Vathu Kolkota, xa koute teni be ‘Von Valvat Moletin.’ ");
INSERT INTO tvk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","E rute ak, lasa uaen mi Iesu xa labilesi del ut mir xil tengan vahas tan ni pangasien nan. E xi misin ni. ");
INSERT INTO tvk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Di, moletin te vaeen xil ak ladi xati e eivave. E melele xa murur da en, xil di laso daes tengan vapisen hisit eising eah na Iesu ihuri. ");
INSERT INTO tvk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Melele xa lateti xati e eivave tehe naen klok makoe. ");
INSERT INTO tvk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","E lateling tisen tei xa bit mesen rin xa ladi xati ven bit, “Ngan ak suv toto na Siu xil.” ");
INSERT INTO tvk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","E melele nen ak, lateti xat moletin lu xa lutepol tesa luteti e eivave lu mun. Tei tete rin metu, e tei tete rin meil. ");
INSERT INTO tvk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Melele xa Iesu di murur de eivave, moletin xil xa di lakakao langgo visali lakuvun vatixil e di langue xati labit, “Ei, xouk iaxa otehiteni otehit uhu len Nim Eo na Hi, ti, ukili ni mun e melengien tol tang. ");
INSERT INTO tvk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","!Bos mak mu tengan uteh meulien e xouk mun tang, e umei etan reling eivave xai!” ");
INSERT INTO tvk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Usil sexien nen xil tak, vat xil na pris xil del titsa xil te rae na Mosis mun lasep pepamen ni Iesu mi xil mun tang labit, “!Mupus ti mu! Xi di teteh meulien e moletin sav xil, e misakras vateh meulien e xi mun tang. ");
INSERT INTO tvk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","!Xosxa be reitin xa xi be Mesaea, suv toto na mol‑Isrel xil, bos xa, taxeak tang, imei etan ra eivave ak! Xosxa xamem mupusi imak, ma muke reitin en sung.” E moletin tesa xalu xa lateti xat xalu luteti rin, xalu mun lusep pepamen ni. ");
INSERT INTO tvk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","E piniae xati, maluxoluken mei da xol ut xil ngasen e dat mak duxoh haoa tol (3). ");
INSERT INTO tvk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","E melele xa haoa xatel ak mei latavi, Iesu mikei nggeih nggo sepinien xati nan xa be Arameak bit, “!Ilae! !Ilae! ?Lama sabaktani?” Koute te sepinien ak be, ‘!Hi navan! !Hi navan! ?Veneh ma ostokovein nou?’ ");
INSERT INTO tvk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Melele xa rut moletin xil xa lasoh ladi lalonge, xil labit, “?Mulonge? Xi di mikes provet Ilaetsa iaxai.” ");
INSERT INTO tvk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma, tei e xil miloh ba, nggur neta tei xa nggoni mavulut kaliko tei, e miterir ni be uaen xa mikon. Di, milingi de kusut liei tei e mei misa ni be nesao tengan Iesu vavisi. Di, biteni bit, “Veter mu e ti ripus pisi. ?Ilaetsa imei etan e ihur rati tamak ra eivave?” ");
INSERT INTO tvk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Di, Iesu mikei nggeih, milihi kor ni votiang, di, mat. ");
INSERT INTO tvk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","E melele nen tak vari, kaliko xa mettel xa lalihi dakoe xol ut eo te Nim Eo mesel be rin lu, nggo kusute nesao bemei duxoh kusute etan. ");
INSERT INTO tvk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Vat tei na moletin te vaeen xil tesoh temal ni Iesu e xi pusi midep iaxa Iesu telihi kor ni votiang nan e mat. Ma, biteni bit, “!Reitin li, ngan ak tehe Nat Hi vari tang!” ");
INSERT INTO tvk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","E tatit atou vutei xil mun lasoh ladi nga sotin vuteili ra eivave, e di lapus holesok xil xa di mistal. Tatit atou xil ak di latehusil Iesu e latetutou ni e Kaleli e latehusili mun melele xa Iesu tehe Serusalem. E xatel tol xa latemos e atou xil ak tehe Meri te hal Makdela; Meri, nine Sioses xal Temis; del Salome. ");
INSERT INTO tvk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sangas ut ba tengan vamaluxoluk. Ma moletin xil di labue xat kuh xil vengan xa Sabat mun da bemei sangas. ");
INSERT INTO tvk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","E moletin tei be visal suv Paelet, hisen Siosep te hal Aramatea. Xi tehe vat tei na Siu xil xa di tetotan e kot na Siu xil, e Siu xil lamerere ni. E xi mun di datil melengien xa Hi imei istal ihe suv toto na moletin xil. E melele xa ba misoh pe met Paelet, ulin takan ti e misisi tengan vamaen tiei na Iesu mini. ");
INSERT INTO tvk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelet mitemanin melele xa milonge xa Iesu mat ngamu. Ma mikes vat na moletin te vaeen nan xil tengan vamei. Misisi tengan vakil ti xa Iesu mat reitin mu tamat ti mu. ");
INSERT INTO tvk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","E melele xa vat ak bit mesen ni xa Iesu mat reitin, Paelet maen tiei nan mi Siosep. ");
INSERT INTO tvk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma Siosep ba, minggal kaliko tei xa mieh. Di, ba po rat tiei na Iesu ra eivave. Xi pis xole ni kaliko te mieh tei. Di, poe ba, milingi de vangihat te tehinen tei xa lateseh moten rohon ni tang. Di, midivin hat tei xa eilep mei dakoe xol puiteh te vangihat ak e be relingi ba. ");
INSERT INTO tvk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E Meri te hal Makdela del Meri, nine Sioses xal Temes, lunggusili e lupus rute xa miling tiei na Iesu da en. ");
INSERT INTO tvk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Melele xa eai ba minu e Sabat bus, Meri te hal Makdela, Meri nine Sioses xal Temis, xatel Salome latoba latnggal vokon tatei xil tengan ha latitehi iha xat tiei na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Di, e Sande makoe roroh, melele xa ut di milan vuteili, atou xatel ak latkakao latoba tengan latosao ni vangihat te tehinen na Iesu. ");
INSERT INTO tvk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","E melele xa di latoba, di latsis xatel latobit, “?Visi iaxa itivin rat hat xa mahulong xa dakoe xol puiteh te vangihat?” ");
INSERT INTO tvk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","E melele xa latomei sangas, latketeh ba e latpus hat xa mahulong xiak, ladivin rati ngamu be reling puiteh. ");
INSERT INTO tvk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","E melele xa latbe vangite, uliatel mikan pupu vengan xa latpus horam maxoe tei dotan de riatel metu, e eising nan xil mieh xa mieh. ");
INSERT INTO tvk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Xi biteni mi xatel bit, “Ulimitel nakan ti. Nakila xa di mutlang ni Iesu te hal Nasaret, xa lateti xati tete eivave. Xi tara ti mun inggak. Xi mea rilomun tuei ra maten. Toketeh topus ti rute xa lateling tiei nan teta en. ");
INSERT INTO tvk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma taxeak, mutiha muthit mesen ni mi moletin nan xil, e mutihit xati mi Pita mak mutihit, ‘Iesu itiamu ni xamim ha ite provins te hal Kaleli. Xamim ha mupusi e rute ak ixoni ngan taxa tehiteni tuei mi xamim.’” ");
INSERT INTO tvk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma atou xatel ak latobe reling vangihat e latoloh temanon latoba vengan xa uliatel mikan pupu e tineatel mulul. E vengan xa uliatel mikan mak, melele xa latoba latbe vut, ma latasepin ti mi moletin tova. ");
INSERT INTO tvk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","E makoe roroh e Sande, melele xa Iesu mea rilomun ra maten, xi mistal kokot mi Meri te hal Makdela, ngan xa tehol rerat ninin tesa lu e he sav (7) latehe relingi. ");
INSERT INTO tvk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Di, Meri ba bit mesen ni mi moletin xil na Iesu xa di ladang e di lamuis. ");
INSERT INTO tvk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","E melele xa lalonge xa Meri bit pus Iesu xa mea rilomun ra maten, xil latake reitin ti en. ");
INSERT INTO tvk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dutou ni, Iesu ba mistal mi moletin nan lu e melele xa di lukakao lube reling taon te hal Serusalem. E lutapus kil ti vengan xa valnaon biles. ");
INSERT INTO tvk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","E melele xa ludilomun e lubit rati mi rut moletin na Iesu xil mun, xil latake reitin ti en. ");
INSERT INTO tvk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Di, Iesu mei mistal mi moletin tei e le tei (11) nan e melele xa xil ladotan e di langganien, e bul xat xil vengan xa vatixil nggeih pupu. Reitin, bul xat xil vengan xa neketen nae tapin ti e latake reitin ti e sepinien na ngan xil xa latehiteni xa latepusi temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Di, Iesu biteni mi xil bit, “Ha muhe rute xil vus e ut etan e muhithiten longeongen hos na Hi mi moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ngan xil vus xa laling neketen nae en e ba labaptaes ni xil tengan vapisen reitinen te neketen nae, ma Hi iteh meulien e xil. E ngan xil xa lataneket ti, ma Hi ihit rati xa xil lapin tengan lihur longpangasien ve tesaen nae xil. ");
INSERT INTO tvk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E ngan xil xa laneket e nou likila lipol ni merekel xil xa lamak: e hisok, lihol rerat ninin tesa xil, e lisepin ni sepinien hu xil xa latnakil ti mu tetiamu. ");
INSERT INTO tvk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tave ti neta xa xil lileh tetal xil mu limu hangan, linamonout ti. E xosxa xil liling hexil e ngan xil xa lamesei, ma lital rat xil ra mesien nae e xil mei lihos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Melele xa Suv Iesu bit sepinien ak bus, e xil dit tamu lapusi, Hi nggur rat Iesu be ut nesao, e ba dotan de ri metu na Hi. ");
INSERT INTO tvk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E eloheoh nan xil, laba e labithiten longeongen hos na Hi e rute xil vus. E Suv Iesu dutou ni xil e misak ni merekel xil di mistal. Merekel xil ak lasak ni moletin xil mei lake reitin e sepinien nae. Ngan ak be hoxalite te longeongen hos usil Iesu Kristo xa Mak tetisi. Reitin. ");
INSERT INTO tvk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Bos makoe bat minuk Teopolis, eilep navan. Melele xa Iesu di tamu temeul e ut etan, moletin xil holu latepus holesok xil xa xi tepol ni e latehusili. Rut moletin xil mei latehe eloheoh nan xil e latesep usil holesok xil xa latepus Iesu tepol ni. E moletin xil holu xa latelonge latetis xat kuhi. ");
INSERT INTO tvk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","E inou, Luk, natehusil kuh holesok xil vus ak, e rin te polien nan e ut etan teha tetuxoh melele xa tetilomun tehe ut nesao. Misak ni, nanemi nabit bos tengan inou mun nitis mesen holesok xil ihusil sexien xa testal en. Ve rin ak, xouk, Teopolis, eilep navan, ");
INSERT INTO tvk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ukila uke reitin e holesok xil xa mosav xil latepispisi minuk usili. ");
INSERT INTO tvk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","E melele xa Herod xa mahulong tehe suv toto te hal Sudea, pris tei teta, hisen Sakaraea. Xi tehe tei e vanut pris na Abitsa. Atou nan, hisen Elsavet, e xi mun tehe vatimol tei na pris Eron tetiamu. ");
INSERT INTO tvk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaraea xal atou nan lumal pe met Hi e lunggusil vuol ni rae nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sakaraea be momatu ngamu e horamue nalu tovuol vengan xa tovolih nan be lumalum. ");
INSERT INTO tvk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vatei, vanut pris xil xa Sakaraea mos e xil laba tengan lapol ni polien savsav nae xil e Nim Eo na Hi. ");
INSERT INTO tvk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nggusil sexien matu na pris xil, xil lalihi his tengan vapisen ni xa visi e xil iaxa ihe Nim Eo e itin vokon e hor eo iha mi Hi. E melele xa lalihi, lalihi his Sakaraea. ");
INSERT INTO tvk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","E melele xa Sakaraea de nim, ngan xil xa lamei tengan lamot mi Hi ladi nga hale e di lasis. ");
INSERT INTO tvk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Vatei takes, masxaxa tei na Hi Suv mei mistal mi Sakaraea e misoh de ri matu te hor eo xa xi di din vokon xil en. ");
INSERT INTO tvk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","E melele xa Sakaraea pus masxaxa ak, mitemanin e ulin mikan xa mikan. ");
INSERT INTO tvk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","E masxaxa biteni mini bit, “!Sakaraea, ulum nakan ti! Hi milong sisen nam ngamu. Atou nam, Elsavet, nave nousav ti iling natumali tei, e uling hisen ihe ‘Sion.’ ");
INSERT INTO tvk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Poten nan isak ni xamil mulihesi xamil, e moletin sav xil mun lihesi xil ven. ");
INSERT INTO tvk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Natumali ihe eilep tei pe met Iahova. Ihe eo e meulien tevi nan e namu ti vari uaen mu oei te xeih. Melele xa ita tamu e vang ninen, Ninin Eo mei ipolu en. ");
INSERT INTO tvk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","E isak ni mol‑Isrel xil holu lihiles ra tesaen nae xil e ha lihusil Iahova, Hi nae. ");
INSERT INTO tvk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Xeihen na Ninin Eo ita en ixoni ngan xa tete provet Ilaetsa tetiamu. Xi iha itiamu ni Hi Suv tengan ileh viton tata xil itel horamue nae xil liti e tomat, e isak ni ngan xil xa latalong xat Hi ti lihiles ra tesaen nae xil e lihusil metisouen na ngan xil xa lamal pe meten. Xi isak ni moletin na Hi xil livue xat xil ve meien na Suv nae.” ");
INSERT INTO tvk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma Sakaraea biteni mi masxaxa ak bit, “Inou nabe momatu ngamu e atou navan be tovolih pupu. ?Ma, inou nikila nihur horamue itep? ?Upol ni naha tengan nikila nike reitin e sepinien nam?” ");
INSERT INTO tvk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","E masxaxa bit rilomun ni mini bit, “Inou Kavriel, vatixar na masxaxa xil, xa di nasoh pe met Hi vehakut. Xi vari tesil nou tengan mei nihit mesen longeongen hos ak minuk. ");
INSERT INTO tvk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","E vengan xa otake reitin ti e neta xa natehiteni, xouk uhe vut. Osakras osepin ha ituxoh melengien xa holesok xil ak mei istal en.” ");
INSERT INTO tvk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E melele xa Sakaraea da tamu e Nim Eo, vanut moletin xil xa di ladatili lanemi labit, “?Veneh ma ba da be nousav?” ");
INSERT INTO tvk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","E melele xa Sakaraea mistal, misakras vasepin. Dit misak tengan vasepin vaxo hen vengan xa be vut. Misak ni, lapus kila xa Hi tepisen neta tei mini. ");
INSERT INTO tvk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Di, Sakaraea pol ni polien sav xil e Nim Eo ba duxoh melele xa polien na vanut pris nan xil bus. Pol bus e dilomun be tim. ");
INSERT INTO tvk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E melele xa Sakaraea ba pus atou nan, Elsavet mei di ni tuvava. E Elsavet dat tim ba duxoh melele xa aveti nan be lim (5). ");
INSERT INTO tvk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","E melele xa dat tim, biteni mi xi tasen bit, “Iahova ien misae e nou xa nabe lumalum. Xi duxol xat nou e maen ni nou nadi ni tuvava. Reitin, xi teleh rat unounen navan pe met moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Melele xa aveti na Elsavet be tei e he sav (6), Hi misil masxaxa Kavriel be taon te hal Nasaret xa de provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kavriel nggur sepinien tei tengan ha ihit mesen ni mi ate maxoe tei, hisen Meri. Meri, latesikoe xole tuei tengan vateli vatel moletin tei, hisen Siosep, xa nggo vatimol na suv toto Deved tetiamu. ");
INSERT INTO tvk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Melele xa masxaxa ak mei mistal mi Meri, biteni mini bit, “!Tomat iti minuk! Iahova memaal ve xouk e di minuk.” ");
INSERT INTO tvk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","E melele xa Meri milonge mak, minexo pupu e di minem ves koute te sepinien ak. ");
INSERT INTO tvk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Di, masxaxa biteni mi Meri bit, “Meri, ulum nakan ti. Hi besi xi pupu ve xouk. ");
INSERT INTO tvk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xouk uti ni tuvava tei e ulingi ihe horamue. Ti, uling hisen ihe ‘Iesu’ xa koute teni be ‘Hi di miteh meulien e moletin xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Xi ihe eilep tei xa likesi ni ‘Nat Hi xa de ut nesao.’ E Hi Suv ipol ni mei ihe suv toto ixoni avu nan tetiamu, suv toto Deved. ");
INSERT INTO tvk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Xi ilaxat kuh mol‑Isrel xil vehakut, xa latexo ra na avu Siekob tetiamu. E lelaxatien nan, hoxalite teni ihe tovuol.” ");
INSERT INTO tvk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri bit rilomun ni mi masxaxa bit, “?Inou niti ni tuvava itep, vengan xa natakil ti mu tiramue?” ");
INSERT INTO tvk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma masxaxa biteni mi Meri bit, “Ninin Eo imei visal xouk, e xeihen na Hi isak ni xouk uti ni tuvava. Ve rin ak, horamue xa ulingi ihe eo, e likesi ni ‘Nat Hi.’ ");
INSERT INTO tvk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","?Okil tumahin Elsavet? Xi mun iling natneli, tave ti neta xa xi be tovolih ngamu. !Reitin mak! Elsavet xa moletin xil labit be lumalum, taxeak, aveti nan be tei e he sav (6). ");
INSERT INTO tvk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mak, ma neta tovuol xa Hi misakras vapol ni.” ");
INSERT INTO tvk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Melele xa Meri milonge mak, biteni mi masxaxa bit, “Bos tang. Meulien navan de he Hi, e xi ikila ipol ni naha xa ien bei. Ipol ni minou ixoni ngan taxa xouk di obiteni.” Di, masxaxa be relingi ba. ");
INSERT INTO tvk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dutou ni melele nen ak, Meri mea e mitemanon be metimal xa Elsavet da en xa de vathu xil te provins te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Melele xa duxoh metimal ak, be vangit nim ma Sakaraea xalu e mikes Elsavet. ");
INSERT INTO tvk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","E melele xa Elsavet milong rae Meri, tuvava nan nggelial e vangen. Di, Ninin Eo mei mise xat Elsavet ");
INSERT INTO tvk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","xa mikei be nesao bit, “!Tuxolxatien na Hi di minuk mili atou sav xil, e tuxolxatien nan di mi tuvava xa de vangom! ");
INSERT INTO tvk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Inou natapin ti tengan nine Suv navan mei vasao ni nou. ");
INSERT INTO tvk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nalong kil holesok xil ak vengan melele xa natelong xouk otekes nou, tuvava xa de nou besi xi e nggelial. ");
INSERT INTO tvk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tuxolxatien na Hi di minuk vengan xa oteneket xa sepinien nan xa holesok xil ak mei istal minuk ixoni ngan xa tehiteni minuk.” ");
INSERT INTO tvk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Meri biteni bit, “E nenemien navan, di napet rat his Iahova. ");
INSERT INTO tvk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Namaal pupu ve Hi navan xa di miteh meulien e nou. ");
INSERT INTO tvk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xi ien tabong ni nou ti, neta sav xa nabe atou votei te polien nan tang. Xosali iha, moletin xil vus ti lihithiteni xa Hi tetuxol xat nou. ");
INSERT INTO tvk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hi te xeihen tepol ni holesok xil xa tellep minou, e hisen be eo. ");
INSERT INTO tvk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Xi ien isae e ngan xil xa di lamerere ni, ngan xil xa ladi taxeak, e ngan xil xa ti limei itutou. ");
INSERT INTO tvk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nggo xeihen nan, Hi tepol ni holesok xil xa latellep, e di nggol rerat valkoai xil xa nenemien nae be nesao. ");
INSERT INTO tvk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xi mileh rerat suv toto xil ra von xeihen nae, e di pet rat moletin votei xil sung. ");
INSERT INTO tvk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Melele xa moletin xil xa di mae nggat xil lamei visal Hi, di misa anien hos xil mi xil. E melele xa ngan xil xa holesok nae holu lamei visali, misil rerat xil laba hon tang. ");
INSERT INTO tvk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xi bemei misa tutouen mi mol‑Isrel xil xa langgo vatit vatimol na avu Siekob tetiamu, xa tehe moletin te polien nan. Xi di dutou ni xil vengan xa di minem xat hitxatien nae tengan ipisen esaeen mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xi di pol nggusil hitxatien xil xa tepol ni mi avu nar xil, mi Ebraham e mi vatimol nan xil xa labe mol‑Isrel xil. Hitxatien nan ak misakras vavus.” ");
INSERT INTO tvk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","E Meri de visal Elsavet aveti tol (3). Di, dilomun be tim san. ");
INSERT INTO tvk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Melengien bemei pipin tengan Elsavet valing horamue nan, ma milingi be malohos. ");
INSERT INTO tvk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Melele xa vatimol nan xil e moletin sav xil xa ladi sangas visali lalonge xa Iahova pol ni bos pupu mini e rin xa temaen ni tehur natneli, xil labesi xil pupu. ");
INSERT INTO tvk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","E melele xa melengien na tuvava ak be tol e he sav (8), nggusil sexien na Siu xil, langguri be vexahu. Ngan xil xa lamei tengan lapusi iexil bei tengan laling his tamen vata en xa be ‘Sakaraea.’ ");
INSERT INTO tvk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","E Elsavet bit, “!E‑e! Hisen ihe ‘Sion.’” ");
INSERT INTO tvk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","E labit rilomun ni mini labit, “!Moletin tovuol tamu e vatimol nalu xa tehur his ak! !Sexien ak tamal ti!” ");
INSERT INTO tvk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Misak ni, ba lasis pis tame tuvava ak nggo hexil tengan vahiteni xa ien bei tengan laling hisen vahe visi. ");
INSERT INTO tvk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma Sakaraea misis xil tengan lasa neta te tisen mini. E midisi bit, “Hisen be Sion.” Melele xa labuli, lamesep pupu ven. ");
INSERT INTO tvk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","E melele nen tak, Sakaraea mikila vasepin rilomun, e pet rat his Hi del sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Melele xa vatimol nalu e ngan xil xa ladi sangas visal xalu lapus merekel xa mistal, latemanin ni. Misak ni, longeongen usil holesok xil xa testal mi Sakaraea, Elsavet e tuvava nalu mikapis e metimal xil xa ladi e hu xil e provins te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngan xil xa lalong usili lakila xa xeihen na Hi di e meulien na tuvava ak e lanemi labit, “?Melele xa imeul ihe eilep, mei ihur polien eah vari?” ");
INSERT INTO tvk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","E melele nen ak, Ninin Eo bemei mise xat Sakaraea ma xi bit lelen ni usil naha xa imei bit, ");
INSERT INTO tvk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Rimes Iahova, Hi na moletin xil te hal Isrel, vengan xa xi mei misao ni moletin nan xil e di miteh meulien e xil. ");
INSERT INTO tvk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hi di misa moletin teteh meulien mi xir. Xi nggur xeihen e nggo vatimol na suv toto Deved xa tehe moletin te polien na Hi. ");
INSERT INTO tvk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hi tehit xati texo provet eo xil tetiamu ");
INSERT INTO tvk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","xa moletin ak mei iteh meulien e xir ra he elu nar xil, e ra xeihen na ngan xil xa di laketeh misa mi xir. ");
INSERT INTO tvk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Xi tehit xati mun xa ipisen esaeen nan mi avu nar xil tetiamu, e inem xat hitxatien te xeih nan ");
INSERT INTO tvk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","xa tepol ni tetel avu nar Ebraham tetel sepinien tei xa texeih. ");
INSERT INTO tvk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Hi tehit xati xa ileh rerat xir ra he elu nar xil tengan rakila rimot mini e rihusil xati ixo sexien xa ulixir nakan ti mun. ");
INSERT INTO tvk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Reitin, rakila rimot mini e melengien xil vus e meulien nae itel meulien tei xa ihe eo e imal pe meten.” ");
INSERT INTO tvk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Di, Sakaraea biteni mi tuvava nan bit, “E xouk, natuxoli, likesuk lihit obe provet tei na Hi te ut nesao. E xouk utiamu ni Suv tengan ha usak mesen suse nan. ");
INSERT INTO tvk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Upisen ni mi moletin nan xil xa Hi iteh meulien e xil e naketeh ti mun nasa mi xil ve tesaen nae xil. ");
INSERT INTO tvk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hi polu ni eheien e esaeen. Isa ‘moletin te teh meulien en’ mei istal mi xir, ixoni ngan xa eai di mistal e di misa miehen mi xir. ");
INSERT INTO tvk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Reitin, sepinien nan ixoni miehen xa ileluv xol ngan xil xa ladi e maluxoluken e ulikanen vengan xa ladi pe xeihen te maten. Ileluv mun tengan ipisen suse te tomat mi xir tengan rihusili.” Melele xa misepin bus, Sakaraea xatel ladilomun labe tim. ");
INSERT INTO tvk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huram xil mei mitavi, e tuvava ak meul mei be horam maxoe tei. E xeihen na Ninin Eo polu en. E melele xa mei be tiramue, ba da tasen e uruvuol ba duxoh melele xa mistal mi mol‑Isrel xil e pol kokot ni polien nan. ");
INSERT INTO tvk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E melengien xil ak xa Sion tepot en, Okastas tehe Sisa te hal Rom. Xi tesa rae nan teha mi eilep nan xil te kavmen tehit ha litis xat his moletin xil ngasen te ut xil vus tengan ");
INSERT INTO tvk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ngan ak tehe pupuluen kokot vari xa latepol ni e melele xa Karinias tehe eilep te kavmen te hal Siria xa provins te hal Sudea da en. ");
INSERT INTO tvk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Misak ni, moletin xil ngasen latetilomun latehe metimal xati na vatimol nae tengan ngan xil te kavmen lakila livuli kuh xil e lihur hisexil. ");
INSERT INTO tvk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Misak ni, e melele nen ak, Siosep mea, be reling metimal te hal Nasaret xa de provins te hal Kaleli. Di, nggusil suse xa teviei ba be Betlehem xa de provins te hal Sudea. Be Betlehem vengan xa be metimal xati na suv toto Deved, e Siosep be vatimol tei nan. ");
INSERT INTO tvk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Siosep nggur Meri lukakao lube Betlehem, vengan xa tesikoe xole ngamu tengan ihuri mei ihe atou nan. Meri, navehi ti iling tuvava. ");
INSERT INTO tvk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","E melele xa ludi tamu e metimal te hal Betlehem, melengien nan pipin tengan valing tuvava. ");
INSERT INTO tvk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Xalu luba ludi e nim ma vongoro xil vengan xa ut sav tovuol e nim tengan laloti en. E inggak, Meri miling muimol nan xa be malohos. Pis xole ni kaliko tei, di milingi pat e rute xa di laling husmunae a vongoro xil en. ");
INSERT INTO tvk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E vongien nen tak, moletin tatei xil di lalaxat sipsip xil e valkesao tei sangas visal metimal te hal Betlehem. ");
INSERT INTO tvk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Vatei takes, masxaxa tei na Iahova bemei mistal mi xil, e minehinen te xeihen na Hi mileluv xol moletin xil ak. Xil latemanin e uli mikan pupu. ");
INSERT INTO tvk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","E masxaxa biteni mi xil bit, “!Ulimim nakan ti! Namei del longeongen hos tei xa isak ni moletin xil ngasen mei lipolu ni sien. ");
INSERT INTO tvk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Taxeak, e hal Betlehem, metimal na suv toto Deved tetiamu, moletin te teh meulien en pot tuei ve xamim. Xi be Mesaea xa Iahova tehit xati xa isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Suse xa mupus kila en imak: mukamet tuvava tei xa lapis xole ni kaliko tei e lalingi pat de rute xa di laling husmunae a vongoro xil en.” ");
INSERT INTO tvk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Melele xa masxaxa di tamu misepin, vatei takes, vanut masxaxa tei xa mahulong pupu langgo ut nesao e mei lastal. E pe met moletin xil ak, lames Hi nggo kikeien labit, ");
INSERT INTO tvk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Merereen mi Hi xa de ut nesao, e ut etan tomat iti mi moletin xil ngasen xa Hi memaal ve xil.” ");
INSERT INTO tvk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Melele xa lakikei bus, masxaxa xil labe reling xil e ladilomun labe ut nesao. Di, moletin xil xa di lalaxat sipsip xil lasem xil labit, “Rave Betlehem, rava rapus ti neta xa Iahova tehiteni mi xir.” ");
INSERT INTO tvk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma xil latemanon laba e lakamet rute xa Meri xal Siosep ludi en. E lapus tuvava nalu di pat de rute xa di laling husmunae a vongoro xil di en. ");
INSERT INTO tvk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Melele xa moletin xil ak lapus tuvava Iesu, labit mesen sepinien xa masxaxa tehiteni mi xil usil tuvava ak mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","E ngan xil vus xa lalong tumulen nae lamesep pupu ni. ");
INSERT INTO tvk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","E melele xa Meri milong sepinien xil ak, miling xat kuhi e nenemien nan, e di minem usili vehakut. ");
INSERT INTO tvk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","E melele xa moletin te sipsip xil ladilomun, xil lames Hi e lapet rat hisen ve holesok xil xa latelonge e latepusi. Vengan xa holesok xil ak testal texoni ngan xa masxaxa tehiteni mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Melele xa melengien na tuvava Iesu be tol e he sav (8), nggusil sexien na Siu xil, tamen xal ninen lungguri be vexahu. E melele nen ak, luling hisen be ‘Iesu’ nggoni ngan xa masxaxa tehiteni mi Meri melele xa tenati ni tuvava ti mu. ");
INSERT INTO tvk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Melengien hanutap lu (40) dutou ni melele xa Iesu tepot en, Siosep xal Meri lunggur tuvava Iesu latobe Serusalem tengan lalopol ni sanien eo tei e rin na Meri tengan mei vamese rilomun vaxoni ngan xa rae na Mosis tehiteni. Ma, xalu luleh mae lu be Nim Eo e lasa mae xalu ak lube sanien eo nalu mi Hi. E melele nen ak mun, lunggur tuvava Iesu tengan ha lalipisen ni mi Iahova tengan pris tei ituxol xati ixoni ngan xa rae nan biteni xa bit, “Muimol xil ngasen xa labe horamue, lihe horamue eo na Iahova.” ");
INSERT INTO tvk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Melele xa Meri, Siosep del Iesu latdi tamu e Nim Eo, moletin tei de rute ak, hisen Simeon. Sexien nan xil momal e eheien nan di e Hi. Di datil melengien xa Hi isa Mesaea imei isak ni mol‑Isrel xil limeluv ra he kavmen sav xil. Ninin Eo di mi Simeon ");
INSERT INTO tvk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","e tehiteni mini xa namat ti mu ituxoh melele xa ipus Mesaea xa Iahova tehit xati tengan isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E melele xa Meri xal Siosep lunggur Iesu be vioh te Nim Eo tengan lalikamet pris tova tengan vatuxol xat tuvava nalu vaxoni ngan xa rae na Hi biteni, Ninin Eo tehiteni mi Simeon tengan ihe rute ak. ");
INSERT INTO tvk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","E melele xa Simeon pus xatel, po xat tuvava Iesu. E melele xa di poe, xi memes Hi bit, ");
INSERT INTO tvk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Suv, inou nabe moletin te polien nam. E taxeak, ukila umaen ni nou nimat e tomat, vengan naha xa otehit xati minou mistal ngamu. ");
INSERT INTO tvk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Inou napus horamue ak tuei ni metok, ngan xa iteh meulien e moletin nam xil. ");
INSERT INTO tvk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","E upol ni moletin xil vus e ut etan lipusi. ");
INSERT INTO tvk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Xi isak ni ngan xil xa latave Siu ti liti e miehen nam, tengan xil lipus kil xouk e limerere ni xouk. E ipet rat his mol‑Isrel xil xa labe moletin nam xil.” ");
INSERT INTO tvk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Melele xa tame Iesu xal ninen lulong naha xa Simeon tehiteni, lumesep pupu. ");
INSERT INTO tvk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Di, Simeon misa tuxolxatien tei mi xatel e biteni mun mi Meri bit, “Tuvava nam isak ni moletin holu te hal Isrel lihusil xat Hi, e isak ni rute e xil lihiles ra ni. Tuvava ak mei ihe simeleleen tei na Hi xa moletin holu lisin ni. ");
INSERT INTO tvk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Isak ni nenemien xuxus xil na moletin xil limei kesao. E naha xa istal mini isak ni xouk mun ulonge isa, ixoni ngan xa tiei tei di misal vinuk.” ");
INSERT INTO tvk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","E melele nen tak, provet tei de vioh te Nim Eo, hisen Anna. Xi be tovolih ngamu, e tamen be pris Vanuel xa nggo vatimol na pris Aser. Melele xa Anna di tamu tehe ate maxoe, teteli. E melele xa huram lu e he sav (7) tang mei tetavi, tiramue nan temat. ");
INSERT INTO tvk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Misak ni, tehe tunau teha vuma … huram nan mei be hanutap hat e hat e he tei mun (84). E melengien xil ngasen, makoe ba duxoh vongien, xi di mot mi Hi e vioh te Nim Eo, e melengien hao di bal ni anien e di misis. ");
INSERT INTO tvk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E melele xa Siosep xal Meri ludi tamu e Nim Eo del tuvava Iesu, Anna bemei visal xatel e memes Hi ve tuvava ak. E dutou ni, ba di mitumul usil tuvava ak mi moletin xil ngasen xa di ladatil melele xa Hi isa Mesaea nan imei tengan isak ni Serusalem itel moletin nan xil limeluv ra xeihen na kantri sav xil. ");
INSERT INTO tvk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Melele xa Siosep xal Meri lupol sen naha xa rae na Iahova biteni, xatel latdilomun latbe Nasaret, metimal natel xati xa de provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","E tuvava Iesu di matu, e ven mei nggeih. E melele xa di matu mak, moletin xil lapus kila xa polu ni metisouen e tuxolxatien na Hi di en. ");
INSERT INTO tvk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E huram xil vus, tame Iesu xal ninen lube Serusalem tengan lalopol ni Anien te Tavien en. ");
INSERT INTO tvk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma, melele xa huram na Iesu be lu e le tei (12), lube anien ak nggoni ngan xa di lupol vehakut ni, e lunggur Iesu latoba. ");
INSERT INTO tvk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Melele xa Anien te Tavien mei mitavi, tame Iesu xal ninen lunggur suse tengan laltilomun lalihe tim, e lutakil ti xa Iesu da tamu e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ma xalu lukakao melengien tevi tei del vanut moletin xil vengan lunemi xa Iesu di nggusil timue tei mu moletin sav tei e vatimol nae. E melele xa ut maluxoluk, lulang vesi sung. ");
INSERT INTO tvk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","E melele xa lutakameti ti e vanut moletin xil xa ludi en, xalu ludilomun lube Serusalem tengan lalolang vesi e rute ak. ");
INSERT INTO tvk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lulang ves Iesu melengien tol (3), di lukameti sung xa dotan de vioh te Nim Eo. Xi di miteong ni pispisien na titsa xil na Siu xil e di misis pilei xil usili. ");
INSERT INTO tvk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xil vus xa lalong sepinien na horamue Iesu lamesep ve kilakilen xa di pisen ni melele xa misa rilomun ni sepinien mi titsa xil. ");
INSERT INTO tvk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Melele xa Siosep xal Meri lukameti, lutemanin pupu. E ninen biteni mini bit, “?Natuxoli, veneh ma opol ni mak mi xamel? Opol ni xamel manexo pupu e di malang vesuk e ut ngasen.” ");
INSERT INTO tvk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","E Iesu bit rilomun ni mi xalu bit, “?Mullang ves nou veneh? ?Mutakil ti xa inou ti nite nim ma Tata navan?” ");
INSERT INTO tvk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","E xalu lutakil ti koute te sepinien nan. ");
INSERT INTO tvk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","E nine Iesu miling kuh naha xa mistal de nenemien nan, e di minem usili vehakut. Di, horamue Iesu dilomun be Nasaret del xalu, e milong xat xalu. ");
INSERT INTO tvk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xi matu, e mei be moletin xa polu ni metisouen. E Hi del moletin xil mun lamaal ven. ");
INSERT INTO tvk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","E melele xa Taeberias tehe Sisa te hal Rom huram lim e le tei (15), moletin hat (4) iaxa di latetutou ni lelaxatien nan: Herod Antipas tehe suv toto te hal Kaleli; tunali Pilip, tehe suv toto te hal Ituria tetel Trakonaetas; Lisanias tehe suv toto te hal Abilin; e Pontias Paelet tehe vat te kavmen te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","E melele nen ak, Anas xal Kaeafas lunggur polien te vatixar na pris xil. E melele ak, Hi misa sepinien tei mi Sion, nat Sakaraea, e uruvuol. ");
INSERT INTO tvk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma Sion mikakao e ut xil ngasen xa ladi sangas visal Oeisal Sodan e di bithiten sepinien na Hi mi moletin xil bit, “!Muhiles ra tesaen namim xil! Ti, mumei minou e nibaptaes ni xamim tengan vapisen ni xa Hi di miketeh bos rilomun mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Provet Aesea tetis usil Sion tetiamu tehit, “Lalong rae tei xa di mikei e uruvuol xa bit, ‘!Musak mesen suse na Hi Suv! !Mupol ni suse nan imal! ");
INSERT INTO tvk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mutihin sesale xil, e muhil lelen hu xil mei lihe motan. Suse xil xa lakavui, mupol ni mei limal tevi, e mutihin suse xil xa misa. ");
INSERT INTO tvk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ti, moletin xil vus lipusi xa Hi ti iteh meulien e xil itep.’” ");
INSERT INTO tvk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Vanut moletin xil holu lamei tengan Sion vabaptaes ni xil. E Sion mea e misepin nggeih mi vat xil na Siu xil xa lamei mini bit, “!Ei, xamim mube vanut tetal tesa xil xa di langas vin moletin xil ni vulongomim! ?Visi iaxa tesel xat xamim tengan mulesae ra pangasien xa Hi isa ni mi xamim? ");
INSERT INTO tvk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ihos mak mu xa, itiamu, mupol ni sexien xil xa ipisen ni xa mubiles ra tesaen namim xil reitin. E munahiteni ti munahit, ‘Xamem munahur ti pangasien vengan xa Ebraham be avu namem e Hi tehosei xamem mabe nan.’ E nabiteni mi xamim xa ngan ak tave reitin ti, vengan xa Hi mikila vahosei hat xil ak tengan mei lave havneli xil e mei lave moletin nan xil xati. ");
INSERT INTO tvk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Taxeak tang, Hi bue xat akis nan ngamu tengan itei vatiei xil ngasen xa latataxao ni ti huite xil xa bos. Reitin, itei xoteh xil e iso xil lihe upang.” ");
INSERT INTO tvk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","E vanut moletin xil ak lasis Sion labit, “?Ma xamem mupol ni naha vari?” ");
INSERT INTO tvk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sion biteni mi xil bit, “Xosxa tei e xamim, eising nan lu, ma isa tei mi mosav xa nan tovuol. Xosxa anien amim di, ma musa rute mi mosav xa an tovuol.” ");
INSERT INTO tvk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Di, moletin xil te takis lamei tengan Sion vabaptaes ni xil, e xil lasisi labit, “?Titsa, xamem mupol ni naha vari tengan mei mumal pe met Hi?” ");
INSERT INTO tvk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma Sion biteni mi xil bit, “Munaleh mani te takis ti nali naha xa rae te kavmen di biteni.” ");
INSERT INTO tvk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","E moletin xil te vaeen mun lamei lasisi labit, “?E itep mi xamem? ?Xamem mupol ni naha tengan mei mumal pe met Hi?” Ma Sion biteni mi xil bit, “Munaxeih xat moletin xil ti tengan lasa mani mi xamim. E munahur ti mani naxo suse xa muluvos mosav e kot en. Mulonge ihos tang ve mani xa di mungguri.” ");
INSERT INTO tvk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Melele xa moletin xil lalong naha xa Sion di biteni, lanem holu usili del sien e labiteni mi xil mun tang labit, “Xos Sion vari iaxa be Mesaea xa Hi tehit xati tehit isa ni imei.” ");
INSERT INTO tvk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Melele xa Sion milonge mak, bit rilomun ni mi xil bit, “Inou natave Mesaea ti. Inou di nabaptaes ni xamim ni oei tang. E tei xa imei itutou ni nou, xi iaxa ihe eilep mak mu ili nou, e inou natapin ti tengan nalal rat sandel nan. Xi vari ibaptaes ni xamim ni Ninin Eo e ni upang. ");
INSERT INTO tvk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xi bue xat xi tengan vaseti moletin xil ngasen ixoni moletin xa di po savel tengan vaseti utut uit ra valite. Utut uit xa bos, ileh xati ha ihe nim man; e valite xil teni, iso ni ihe upang xa misakras vamat.” ");
INSERT INTO tvk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E sexien nen tak, Sion misel xat moletin xil e bithiten longeongen hos na Hi mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E melele xa Sion di pol ni polien nan, di misepin nggeih ba xat suv toto Herod vengan xa tehur atou na tunali tehe atou nan, hisen Herodias. E Sion di misepin ba xat Herod mun ve holesok xil vus xa di pol ni xa tamal ti. ");
INSERT INTO tvk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Misak ni, Herod pol ni neta tei xa misa pupu mili sexien sav nan xil. Xi misemae ni tengan moletin te vaeen nan xil iha ital xat Sion e liso ni ihe nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Melele xa Sion di tamu tebaptaes ni moletin xil, Iesu mun temei mini tengan Sion vabaptaes ni. E melele xa Iesu di tesis, tilang hat tesaha ");
INSERT INTO tvk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","e Ninin Eo temei e tan texoni mae e mei tetotan en. E rae tei tekei texo ut nesao tehit, “Xouk obe natuxoli reitin xa eheien navan di e xouk, e nabesi nou pupu ve xouk.” ");
INSERT INTO tvk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Melele xa Iesu tepol kokot ni polien nan, huram nan tehe hanutap tei e he xalu mun (30). Moletin xil vus lanemi labit xi be nat Siosep. E avu na vatimol na Siosep xil, hisexil temak: Siosep tehe nat Heli. ");
INSERT INTO tvk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","E Heli tehe nat Matat, xa tehe nat Livae, xa tehe nat Melki, xa tehe nat Sanae, xa tehe nat Siosep. ");
INSERT INTO tvk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Siosep tehe nat Matataeas, xa tehe nat Amos, xa tehe nat Neham, xa tehe nat Esli, xa tehe nat Nanggae. ");
INSERT INTO tvk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nanggae tehe nat Mahat, xa tehe nat Matataeas, xa tehe nat Semein, xa tehe nat Sosek, xa tehe nat Soda. ");
INSERT INTO tvk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Soda tehe nat Soanan, xa tehe nat Resa, xa tehe nat Serubabel, xa tehe nat Seltiel, xa tehe nat Neri. ");
INSERT INTO tvk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tehe nat Melki, xa tehe nat Adi, xa tehe nat Kosam, xa tehe nat Elmadam, xa tehe nat Er. ");
INSERT INTO tvk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tehe nat Sosua, xa tehe nat Eliesar, xa tehe nat Sorim, xa tehe nat Matat, xa tehe nat Livae. ");
INSERT INTO tvk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae tehe nat Simeon, xa tehe nat Sudah, xa tehe nat Siosep, xa tehe nat Sonam, xa tehe nat Eliakim. ");
INSERT INTO tvk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim tehe nat Melea, xa tehe nat Mena, xa tehe nat Matataha, xa tehe nat Netan, xa tehe nat Deved. ");
INSERT INTO tvk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","E Deved tehe nat Tiese, xa tehe nat Obed, xa tehe nat Boas, xa tehe nat Salmon, xa tehe nat Nason. ");
INSERT INTO tvk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason tehe nat Aminatap, xa tehe nat Atmin, xa tehe nat Ani, xa tehe nat Hesron, xa tehe nat Peres, xa tehe nat Sudah. ");
INSERT INTO tvk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sudah tehe nat Siekob, xa tehe nat Aesak, xa tehe nat Ebraham, xa tehe nat Terah, xa tehe nat Nahor. ");
INSERT INTO tvk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor tehe nat Seruk, xa tehe nat Rehu, xa tehe nat Pelek, xa tehe nat Eber, xa tehe nat Sela. ");
INSERT INTO tvk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela tehe nat Kenan, xa tehe nat Arpaksat, xa tehe nat Sem, xa tehe nat Noah, xa tehe nat Lamek. ");
INSERT INTO tvk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek tehe nat Metuselah, xa tehe nat Inok, xa tehe nat Saret, xa tehe nat Mahalalil, xa tehe nat Kenan. ");
INSERT INTO tvk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan tehe nat Inos, xa tehe nat Set, xa tehe nat Adam. E Adam tehe nat Hi. ");
INSERT INTO tvk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Melele xa Iesu be reling Oeisal Sodan, Ninin Eo xa da en midela be uruvuol. ");
INSERT INTO tvk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","E rute ak, Temat di misak pis Iesu melengien be hanutap lu (40). E melele nen ak, Iesu taxanien ti. Ma, e hoxalite te melengien xil ak, mae nggat pupu ni. ");
INSERT INTO tvk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ve rin ak, Temat mei misak pisi bit, “Xosxa obe Nat Hi reitin, ma usemae ni hat xil ak lihiles mei lihe beret am.” ");
INSERT INTO tvk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","E Iesu bit rilomun ni mini bit, “!E‑e! Ninapol ni ti namak vengan xa Vanuvei Eo na Hi biteni bit, ‘Moletin misakras vameul e anien kestang.’” ");
INSERT INTO tvk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Di, Temat del Iesu be nesao e vathu tei, e vatei takes, pisen kantri xil vus te ut etan mini. ");
INSERT INTO tvk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","E misak pisi bit, “Xeihen te kantri xil vus ak de heok. E inou nakila nasa rati mi moletin eah xa ieok bei tengan nasa ni mini. Misak ni, nakila nasa rat lelaxatien te xil itel holesok xil vus xa di en minuk. ");
INSERT INTO tvk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Misak ni, xosxa umot minou tang, ma nisa sen holesok xil ak minuk.” ");
INSERT INTO tvk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","E Iesu bit rilomun ni mini bit, “Inou ninapol ni ti vengan xa Vanuvei Eo na Hi biteni bit, ‘!Mumot mi Iahova xa be Hi namim, e mulong xat xi kestang!’” ");
INSERT INTO tvk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Di, Temat nggur Iesu be Serusalem e milingi misoh e rute tei xa be nesao pupu e taep te Nim Eo na Hi. E rute ak, Temat misak pisi bit, “Xosxa obe Nat Hi reitin, uhut uhe tan. ");
INSERT INTO tvk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Vengan xa Vanuvei Eo di biteni bit, ‘Hi isemae ni masxaxa nan xil tengan mei lisikoe xolok.’ ");
INSERT INTO tvk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","E, ‘Xil lipo xatuk itel hexil tengan onasip hat ti ni lem.’” ");
INSERT INTO tvk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","E Iesu bit rilomun ni mini bit, “!E‑e! Ninapol ni ti, vengan xa Vanuvei Eo biteni mun bit, ‘Munasak pis Iahova ti xa be Hi namim tengan mukameti xa xi di mi xamim.’” ");
INSERT INTO tvk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Melele xa Temat misak pis Iesu e rin xil vus, be relingi ha ituxoh melele sav xil xa pus mesal tengan vasak pisi. ");
INSERT INTO tvk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Melele xa Iesu be reling uruvuol, xi polu ni xeihen na Ninin Eo, e dilomun be provins te hal Kaleli. Longeongen usili mikapis e ut ngasen xa di sangas visal rute ak. ");
INSERT INTO tvk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xi ba be nim te pispisien na Siu xil e di pispisi mi moletin xil en. E ngan xil vus xa lalonge lapet rat hisen. ");
INSERT INTO tvk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu mikakao ba duxoh taon te hal Nasaret, rute xa tematu en. E Sabat, Iesu be nim te pispisien nggoni ngan taxa di pol vehakut ni. E melele xa mea misoh tengan vavuli Vanuvei Eo na Hi, ");
INSERT INTO tvk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","xil lasa vanuvei na provet Aesea mini e xi buli bit, ");
INSERT INTO tvk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ninin Eo na Hi Suv di mise xat nou, vengan xi tehosei nou tengan nihit longeongen hos nan mi ngan xil xa labe hoeo. Xi tesil inou namei tengan namiteni mi moletin xil xa ladi e nim te xeih ha vexil vamase. E nihiteni mi ngan xil xa metexil bar mei liketeh rilomun. E nihiteni mi ngan xil xa ladi pe he mosav xil xa limeluv liha. ");
INSERT INTO tvk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xi tesil inou tengan nihithiteni xa Iahova tehosei melele nen ak tengan itutou ni moletin nan xil en.” ");
INSERT INTO tvk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Melele xa Iesu buli bus, boh xol vanuvei ak, di, misa rilomun ni ba mi moletin te tutouen, e dotan tengan vapispisi mi moletin xil. Melele xa met moletin xil vus xa lateti e nim ak da en, ");
INSERT INTO tvk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesu biteni mi xil bit, “Vanuvei Eo na Hi xa mutelong nou natevuli, taxeak tang, sepinien xil teni mei be reitin.” ");
INSERT INTO tvk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moletin xil xa lalong pispisien hos xil xa di misa ni mi xil lamesep ven e lapet rati ve sepinien nan xil. E di, rute e xil lanem male ni labit, “!Ei! Xi be nat Siosep tang.” ");
INSERT INTO tvk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu bit rilomun ni mi xil bit, “Nakila xa muhiteni minou sepinien matu xa bit, ‘Tokta, upol ni ngenom xil mu mei lilonge ihos rilomun,’ vengan xa iemim bei tengan nipol inggak, e metimal xati navan, holesok xil vus xa mutelonge xa natepol ni e taon te hal Kapaniam tengan muke reitin e nou ixo en. ");
INSERT INTO tvk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","E nabiteni reitin mi xamim, provet tovuol tamu xa ngenen xil latehur pilei e metimal nan xati. ");
INSERT INTO tvk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tetiamu, e melengien xil na provet Ilaetsa, us tenamus ti huram tehe tol e rute, e moletin xil vus, mae teat xil. E, e mol‑Isrel xil, tunau xil latehe holu. ");
INSERT INTO tvk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","E Hi tesil Ilaetsa teha mi tunau tei xa tave te hal Isrel ti. Xi de metimal te hal Sarevat sangas visal taon te hal Saedon. ");
INSERT INTO tvk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Teimun, e melengien xil na provet Elisa, moletin holu te hal Isrel latehur mesien leporsi. E Elisa tenapol ni ti tenbexil vamese, xi tepol ni Neman te hal Siria kestang xa tenave te hal Isrel ti tenben mei temese rilomun.” ");
INSERT INTO tvk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Melele xa moletin xil xa ladi nim te pispisien lalong sepinien nan, xil vus iexil mikati ven. ");
INSERT INTO tvk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma latamea, lameru xati be reling metimal nae, e ladela labe seri meteh xa de haxot te metimal nae vengan xa labit lativin rat Iesu vamot vaha en. ");
INSERT INTO tvk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","E Iesu, xi biles, e mikakao nggo hilaep te vanut moletin xil ak. Di, be reling xil e nggusil suse nan ba. ");
INSERT INTO tvk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Di, Iesu be metimal te hal Kapaniam xa de provins te hal Kaleli. E Sabat, Iesu di pispisi mi moletin xil inggak. ");
INSERT INTO tvk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Moletin xil lamesep ni pispisien nan xil vengan xa di bit kil koute teni mi xil nggoni ngan xa nggo Hi vari. ");
INSERT INTO tvk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","E melele nen ak, moletin tei xa ninin tesa da en de vangit nim te pispisien. Xi mikei nggeih xat Iesu bit, ");
INSERT INTO tvk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“!Ei, Iesu, ngan Nasaret! ?!Obit upol ni naha mi xamem!? ?Omei inggak tengan omu vin xamem? !Inou nakilak, xouk obe Moletin Eo na Hi vari!” ");
INSERT INTO tvk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu mike xat ninin tesa ak bit, “!Utat votei! !E uhe reling moletin ak!” Ninin tesa bas tan ni moletin ak pe met moletin xil vus. Di, be reling moletin ak e neta ti taxula. ");
INSERT INTO tvk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Moletin xil vus lamesep e di lasis xil mun tang labit, “?Hisit pispisien eah xiak? !Moletin ak di misepin del xeihen, e melele xa misepin nggeih mi ninin tesa xil, lalong xati e labe reling moletin xil!” ");
INSERT INTO tvk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma longeongen usil Iesu mikapis ut ngasen xa de sangas visal metimal te hal Kapaniam. ");
INSERT INTO tvk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Melele xa Iesu be reling nim te pispisien te hal Kapaniam, be tim sa moletin tei, hisen Saemon Pita. Melele xa duxoh tim san, milonge xa avu atou kokon na Saemon Pita, ven minggan pupu. Ma lasis Iesu tengan vatal rati ra mesien nan. ");
INSERT INTO tvk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma Iesu be visali e misemae ni mesien ak bit, “!Uhe relingi!” E, vatei takes, atou ak milonge bos, mitamea, e ba pol ni anien ae. ");
INSERT INTO tvk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","E melele xa eai minu e Sabat bus, moletin xil lakila lapol ni neta. Ma moletin xil holu laleh tua nae xil xa lamesei lamei visal Iesu. Xi miling hen e xil kekes e pol ni ngan xil vus ak mei labos. ");
INSERT INTO tvk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E melele xa Iesu nggol rerat ninin tesa xil ra moletin xil holu, lamuis kei ba mini labit, “!Xouk obe Nat Hi reitin!” E xi misep xol xil tengan linasepin ti vengan lakila xa xi be Mesaea xa Hi tehosei. ");
INSERT INTO tvk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","E visuvong nen, e makoe roroh, Iesu mika sen be uruvuol. E melele xa moletin xil latapus ti, laba tengan lalang ni. Melele xa lakameti, lasak pisi tengan ladak kesi nave reling xil ti. ");
INSERT INTO tvk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","E Iesu biteni mi xil bit, “Niha nihithiten longeongen hos usil lelaxatien na Hi mi moletin xil e rute sav xil mun. Vengan xa Hi tesil inou namei tengan napol ni hisit polien xil ak.” ");
INSERT INTO tvk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma Iesu be metimal xil na Siu xil e dit bithiten longeongen hos na Hi e nim te pispisien nae xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vatei, Iesu misoh de suhon te Oei Kaleli sangas ni Kenesaret. E moletin xil labe holu pupu e mei lating xat Iesu tengan lalong ti sepinien na Hi xa di misa ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Di, Iesu pus bot lu (2) xa moletin xil teni lateling xalu ludi e ut tengan lava lakas moten net nae xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Di, Iesu be bot tei xa be na Saemon Pita, e misisi tengan vativin ni valis luvoluv vahe reling ut. Di, Iesu dotan de bot ak e di pispisi mi vanut moletin xil xa mahulong xa ladi ut. ");
INSERT INTO tvk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Melele xa Iesu misepin mi xil bus, biteni mi Saemon Pita bit, “Xamitel, tohalis ni bot valis vahe huinep, e mutiso net namitel inggak tengan mutisar ti meseo.” ");
INSERT INTO tvk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","E Saemon Pita bit rilomun ni mi Iesu bit, “Suv, vongien duxoh makoe ak, xamem mabilao tova tang e matasar ti meseo vari. E vengan xa xouk obiteni, ma bos tang, nisa sepinien tengan muha muso rilomun ni net namem.” ");
INSERT INTO tvk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","E melele xa ba laso net nae xil be tan, laleh meseo xil holu xa holu pupu … sangas langgur papas net nae xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ma laso hexil ba ni tua nae xil tengan lalis bot nae vamei e litutou ni xil. Ma, melele xa laduxoh xil, lase xat bot xalu vus ni meseo ba vuma … polu tova tang, sangas lalomerir. ");
INSERT INTO tvk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saemon Pita e moletin xil vus xa ladi e bot ak latemanin xa meseo xil xa lalehi labe holu xa labe holu pupu mak. E melele xa Saemon Pita pus kil naha xa mistal, be visal Iesu, mitingeiril pe meten, e biteni mini bit, “!O Suv, inou natapin ti tengan nate visaluk! Uhe reling nou vengan xa nabe moletin tesa tang.” ");
INSERT INTO tvk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E Iesu bit rilomun ni mini bit, “!Ulum nakan ti! Duxoh xosali, xouk otelihi meseo xil tang, e taxeak iha, ulihi moletin xil sung.” Moletin lu mun xa lupol vituei del Saemon Pita, hisealu Temis xal Sion xa lube nat Sepeti. Xalu mun lutepus holesok xa testal e lutemesep ni. ");
INSERT INTO tvk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Misak ni, melele xa lalihi bot nae be ut, Pita, Temis e Sion latstokovein holesok natel xil di, e latoba latonggusil Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Vatei, Iesu temei tehe taon tei. E rute ak, moletin tei da en xa mesien leporsi tepurun tenben. E melele xa moletin ak pus Iesu, bemei visali e mitingeiril be tan pe meten, valnaon ba duxoh tan. Di, midakes Iesu bit, “!Suv, xosxa iem bei, xouk okila opol ni veok vamese!” ");
INSERT INTO tvk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma Iesu misa hen ba duxoli, e biteni mini bit, “Ieok bei li tengan nipol ni. !Vem imese rilomun!” Vatei takes, mesien nan be relingi vari. ");
INSERT INTO tvk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","E Iesu misepin nggeih mini bit, “!Onahit rati ti mi mosav xil! E uha mu, upisen xouk mi pris tova xa de Nim Eo tengan ipus kuh tenbom. Ti, usa sanien eo nam ihusil naha xa rae na Mosis di biteni. Ixo suse ak, moletin xil vus lipus kila xa mesien nam bus, e omese tevi.” ");
INSERT INTO tvk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","E neta sav xa mak, longeongen usil Iesu mikapis miloh be ut sav xil mun xa be sotin. Ma, vanut moletin xil holu lamei tengan ti lilong pispisien nan xil e ti lisisi tengan ileh rerat mesien ra xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E vehakut, Iesu mea be reling moletin xil tengan ita tasen tang e ti isis. ");
INSERT INTO tvk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vatei, melele xa Iesu di pispisi mi vanut moletin xil, rut Farasi xil del titsa xil te rae na Mosis lamei ladotan sangas visali e di lataeong ni pispisien nan xil. Xil latexo metimal sav xil e provins xalu te hal Kaleli xal Sudea, e rute xil latexo taon te hal Serusalem mun tengan mei lapus Iesu. E Hi Suv di misa xeihen mi Iesu tengan mikila valeh rerat mesien xil ra moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","E melele nen ak, rut moletin xil lamei lapo moletin tei del vet man tang e lamei ve Iesu vengan xa ri moletin ak mat. E melele xa lasak pisi tengan lapoe vahe nim tengan lalingi pe met Iesu, ");
INSERT INTO tvk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","lasakras, vengan vanut moletin xil xa ladi e nim langgonaxon pupu. Mak toma, lapeou labe hilim nesao, e ladal rerat rut hilim ak ba. Di, lasae ni moletin ak xa da tamu e vet man be tan e hilaep te moletin xil, momal ni rute xa Iesu da en. ");
INSERT INTO tvk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Melele xa Iesu pus naha xa lapol ni e mile kil neketen nae, biteni mi moletin xa rin tei mat bit, “Tuxoli, Hi naketeh ti mun nasa minuk ve tesaen nam xil.” ");
INSERT INTO tvk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Melele xa Farasi xil del titsa xil te rae na Mosis lalonge mak, laseputut ni e nenemien nae labit, “!Ei! ?!Moletin ak minemi bit xi be visi!? !Xi di misep xar ni Hi! !Xi bit nggur xeihen nggoni Hi, vengan Hi kestang mikila valeh rat tesaen ra moletin tei!” ");
INSERT INTO tvk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","E Iesu mikil nenemien nae, ma biteni mi xil bit, “?Veneh ma di munemi xa natahur ti xeihen vapin tengan naleh rat tesaen ra moletin tei? ");
INSERT INTO tvk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","?Naha vari be temale mak mu tengan namiteni mi moletin ak? ?Tengan namit, ‘Hi naketeh ti mun nasa minuk ve tesaen nam xil,’ mu namit, ‘Utamea e ukakao’? Temale tang tengan namiteni xa Hi naketeh ti mun nasa mini vengan xa musakras mupus kila xa mistal mu tastal ti. ");
INSERT INTO tvk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","E taxeak, mupus kila xa Nat Moletin nggur xeihen e ut etan tengan valeh rerat tesaen ra moletin xil pe met Hi.” Di, Iesu pus moletin xa rin tei mat e biteni mini bit, “!Utamea, uvulun vet mam, e upoe utilomun uhe tim sam!” ");
INSERT INTO tvk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vatei takes, moletin ak mitamea pe met moletin xil. Xi po vet man, e mikakao be tim san. E melele xa de suse misa memesien ba mi Hi. ");
INSERT INTO tvk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Moletin xil vus latemanin e lanem pupu usili. Lames Hi labit, “!Xosali, xir rapus neta tei xa eilep pupu!” ");
INSERT INTO tvk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dutou ni melele nen ak, Iesu mistal nggo nim e mikakao ba. E kakaoen nan, pus Siu tei xa di pol mi kavmen te hal Rom, hisen Livae. Xi di dotan de von polien nan tengan valeh takis vaxo moletin xil tengan isa ni iha mi kavmen te hal Rom. Melele xa Iesu pusi, mikesi bit, “!Amei, uhusil nou!” ");
INSERT INTO tvk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Misak ni, Livae mea, mistokovein holesok nan xil di, e ba nggusil Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma Livae del Iesu e moletin nan xil labe tim san e pol ni anien tei xa mahulong ve Iesu. Ma misilasil ve vanut moletin xil holu tengan mei lavanien vituei: ngan xil xa laleh takis del rut moletin sav xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farasi xil e rut titsa te rae na Mosis di laseputut ni Iesu mi moletin xil labit, “?Veneh ma Iesu di mingganien e di mumun del moletin xil te takis e del rut moletin tesa sav xil ak?” ");
INSERT INTO tvk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu bit rilomun ni mi xil bit, “Moletin xil xa di lanemi labit latamesei ti, iexil ti tavei tengan ha lapus tokta. Tokta be na ngan xil kestang xa lakila labit lamesei. ");
INSERT INTO tvk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inou natamei ti tengan ti nikes moletin xil xa labit meulien nae momal ngamu. E‑e, namei tengan ti nikes moletin tesa xil tengan ti lihiles meulien nae ra tesaen nae xil.” ");
INSERT INTO tvk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Melele xa Iesu da tamu e nim ma Livae, rut moletin xil mei labiteni mini labit, “Vehakut, moletin xil na Sion Baptis di lasis mi Hi e di labal ni anien ven. E moletin xil na Farasi xil mun mak tang. E xamem mapusi xa moletin nam xil latapol ni ti vamak. Vehakut, dit langganien e di lamun. ?Veneh vari?” ");
INSERT INTO tvk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu bit rilomun ni mi xil bit, “E melele te tetelien tei, moletin xil limei ve anien teni. Osakras osak ni xil laval ni anien e melele xa moletin xa miteli dat tamu visal xil. ");
INSERT INTO tvk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","E melengien imei xa moletin tesa xil lihur rat moletin xa miteli ihe reling xil. E melele nen ak vari, xil ti lihal ni anien sung.” ");
INSERT INTO tvk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Di, Iesu dei vole mi xil bit, “Moletin tovuol xa vatal pas eising hu tei nan tengan vahur rut kaliko teni e vatil xol eising matu nan xa mahoe ni. Maxani, ipurun eising hu nan, e samulit eising hu ak tamal pupu ti ni eising matu nan. ");
INSERT INTO tvk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","E moletin tovuol xa vateh uaen hu vahe valite matu xa lapol ni ni hilbe sipsip vengan xa nggeih ngamu. Maxani, uaen hu ikaio vuma … isak ni valite matu iposou e imahoe. Ti, uaen imie ihe tan, e valite mun isa. ");
INSERT INTO tvk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","E‑e, namak ti. Ihos xa uaen hu ihe valite hu xa mavoh tang. ");
INSERT INTO tvk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","E moletin xil xa di lamu uaen matu, xil iexil ti tavei tengan lamu uaen hu vengan xa lanemi labit, ‘Uaen matu bos mak mu.’” ");
INSERT INTO tvk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vatei, e Sabat, Iesu del moletin nan xil di lakakao langgo naho tatei te uit. E melele xa di lakakao, moletin nan xil di laki xototeh uit xil ak, langgo utute, e langga ni. ");
INSERT INTO tvk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Misak ni, rut Farasi xil mei lasisi labit, “?Veneh ma di mupol ni sexien xa rae na Mosis bit ti rinapol ni ti e Sabat?” ");
INSERT INTO tvk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu bit rilomun ni mi xil bit, “?Midep? ?Xamim mutakil ti naha xa suv toto Deved tetel moletin nan xil latepol ni e melele xa mae teat xil? ");
INSERT INTO tvk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tave ti neta xa rae bit pris xil kestang lia beret eo, Deved tehe Nim Eo na Hi, tehur beret xa pris xil latesa ni tuei mi Hi e tea ni. Di, tesa rute mi moletin nan xil latea ni.” ");
INSERT INTO tvk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Di, Iesu biteni mi xil bit, “Nat Moletin vari iaxa be eilep mu mili Sabat.” ");
INSERT INTO tvk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","E Sabat teimun, Iesu ba di pispisi e nim te pispisientei. E rute ak, moletin tei da xa hen metu mikavui. ");
INSERT INTO tvk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rut titsa xil te rae na Mosis del rut Farasi xil labit lipus pisi xos Iesu ipol ni he moletin ak mei ihos rilomun e Sabat. Vengan xosxa ipol ni, ma likila lisa sepinien iha xat rin nan vengan xa di nggur xoteh rae xa misikoe xol Siu xil tengan linapol ti e Sabat. ");
INSERT INTO tvk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","E Iesu mikil nenemien nae, ma biteni mi moletin ak bit, “Amei. Usoh inggak visal inou.” Ma moletin ak mea, ba misoh rute ak pe met moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Di, Iesu biteni mi xil bit, “?Nasis xamim, rae na Mosis maen ni tengan ti ripol ni naha e Sabat? ?Ripol ihos, mu ripol isa? ?Ritutou ni meulien na mosav, mu rihas vini?” ");
INSERT INTO tvk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu miketeh mikapis e xil. Di, biteni mi moletin ak bit, “Te momal ni hem.” E melele xa pol ni, hen mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xil iexil mikat pupu, e lasep vesi xa lipol ni naha mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vatei, Iesu be nesao e hu tei tengan ha vasis. Xi misis mi Hi e vongien nen ak ba duxoh makoe. ");
INSERT INTO tvk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Melele xa ut milan, xi ba mikes moletin nan xil vus tengan lamei visali. E xi bosei moletin lu e le tei (12) tang tengan mei lave eloheoh nan xil: ");
INSERT INTO tvk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saemon (xa Iesu miling hisen teimun be ‘Pita’) del tunali Andru; Temis xal Sion; Pilip xal Batalomiu; ");
INSERT INTO tvk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu e Tomas; Temis nat Alveas; e Saemon (xa lakesi ni Silixin); ");
INSERT INTO tvk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sudas nat Temis; e Sudas Eskariot xa imaen Iesu ihe he ngan xil xa lihasi imat. ");
INSERT INTO tvk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Melele xa Iesu del moletin nan xil langgo vathu ak e labe tan, labe rute tei xa be motan xa vanut moletin xil holu xa di langgusil Iesu di ladatili. E Iesu pus vanut moletin savsav xil mun lamei: rute xil langgo taon te hal Serusalem e metimal savsav xil xa ladi e provins te hal Sudea, e rut moletin xil mun xa latave Siu xil ti langgo taon te hal Taer xal taon te hal Saedon xa ludi sangas visal Tas Medeterenia. ");
INSERT INTO tvk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xil lamei tengan lateong ni Iesu e lasisi tengan ileh rerat mesien nae xil. Ngan xil mun xa ninin tesa xil di purun xil lamei, ma Iesu nggol rerat ninin tesa xil ak ra xil e pol ni xil mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Moletin xil vus lasak tengan latuxol Iesu, vengan xeihen xa da en di mileh rerat mesien ra moletin xil ngasen e pol ni xil mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Melele xa Iesu da tamu del moletin xil ak, miketeh pus moletin nan xil e biteni bit, “Tuxolxatien iti mi xamim xa holesok namim xil tapin ti, vengan xa holesok xil xa ladi he Hi labe namim. ");
INSERT INTO tvk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tuxolxatien iti mi xamim xa, taxeak, mae di nggat xamim, vengan xa Hi isak ni xamim mupolu kuhi. Tuxolxatien iti mi xamim xa, taxeak, di mudang, vengan xa Hi isak ni xamim mumen. ");
INSERT INTO tvk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tuxolxatien iti mi xamim melele xa moletin xil di iexil nggat xamim e di lasin xamim ve nou. Reitin, tuxolxatien iti mi xamim melele xa di lasepsisil xamim e di lapurun hisemim vengan xa di munggusil xat Nat Moletin. ");
INSERT INTO tvk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mumaal melele xa xil di lapol ni mak mi xamim e muhutahut itel sien, vengan xa Hi pusi xa mupin tengan muvur huite teni xa ihe eilep e ut nesao. Vengan xa avu nae xil tetiamu latepurun provet xil tetiamu temak tang, e Hi tepus provet xil lamal pe meten. ");
INSERT INTO tvk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“E isa pupu mi xamim xa holesok namim holu taxeak, vengan xa mutehur sen hosien namim ngamu. ");
INSERT INTO tvk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Isa pupu mi xamim xa mupolu kuhi taxeak, vengan xa mae ti iat xamim. Isa pupu mi xamim xa di mumen taxeak, vengan xa ti mumuis e ti mutang. ");
INSERT INTO tvk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","E isa pupu mi xamim melele xa moletin xil vus di lapet rat hisemim, vengan xa avu nae xil tetiamu latepol ni temak tang mi provet te luvosen xil.” ");
INSERT INTO tvk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Di, Iesu misa sepinien ak mi moletin xil vus bit, “Nabiteni mak mi xamim vus xa di mulong sepinien navan xil ak: iemim ihei elu namim xil, mupol ni ihos mi ngan xil xa di laketeh misa mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Musis Hi tengan ituxol xat ngan xil xa di lasuhol xamim, e musis ve ngan xil xa di lapurun xamim. ");
INSERT INTO tvk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Xosxa moletin tei mileves vimim, musa ri vimim mun tengan ilevesi. E xosxa moletin tei misil rat kot namim, mumaen ni tengan ileh eising sav namim xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xosxa moletin tei dakes xamim ve neta tei, ma musa ni tang mini. E melele xa moletin tei nggur rat neta tei namim, munasis ti munahit nasa rilomun ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mupol ni mi mosav xil ixoni ngan xa xamim iemim bei tengan xil lipol ni minuk. ");
INSERT INTO tvk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“?Xosxa iemim bei moletin xil kestang xa di iexil bei xamim mun tang, veneh ma di munemi mubit Hi ituxol xat xamim ven? !Moletin tesa xil mun di lapol ni mak! ");
INSERT INTO tvk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","?E xosxa xamim di mupol bos mi moletin xil kestang xa di lapol bos mi xamim, veneh ma Hi ituxol xat xamim ven? !Moletin tesa xil mun di lapol ni mak! ");
INSERT INTO tvk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","?E xosxa mumaen mani mi moletin xil kestang xa mukila mubit lisa rilomun ni mi xamim, veneh ma di munemi mubit Hi ituxol xat xamim ven? !Moletin tesa xil mun di lamaen mani nae mi moletin tesa sav xil tengan, ti, lisa xolesi! ");
INSERT INTO tvk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","!E xamim, munapol ni ti namak! Eheien namim iti mi ngan xil xa di laketeh misa mi xamim e mupol ihos mi xil. Mumaen mani mi mosav xil e munanemi ti munahit lisa rilomun ni mi xamim. Xosxa mupol ni imak, ma Hi xa de ut nesao isa huite teni xa ihos pupu mi xamim e muhe horamue nan xil. Vengan Hi mun di pol ni bos mi moletin tesa xil xa lakavui e langgur votei ni holesok xil xa di misa ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mak, ma esaeen namim iti e mosav xil, ixoni ngan xa esaeen na Hi Tamemim mun di e mosav xil.” ");
INSERT INTO tvk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","E Iesu biteni mun bit, “Munaketeh ti nasa mi mosav xil ve tesaen nae xil. Xosxa munapol ni ti, ma Hi naketeh ti nasa mi xamim ve tesaen namim xil. E munasepin ti nasa naha xat mosav xil ve sexien tesa nae. Xosxa munapol ni ti, ma Hi nasepin ti nasa naha xat xamim ve sexien tesa namim xil. E xosxa mosav tei pol misa mi xamim, muketeh ihos tang mini. Mak, ma Hi iketeh ihos mi xamim melele xa di mupol misa. ");
INSERT INTO tvk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Melele xa musa tutouen mi mosav xil, ma Hi isa tutouen mi xamim. E melele xa xi isa tutouen mi xamim, ihe holu mu. Ixoni ngan taxa moletin tei minggutih raes amim ni kap tei xa mahulong pupu e polu ma … dit kiri lel. Mak, ma sexien xil xa di mupol ni mi moletin sav xil, Hi ipol ni imak tang mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Di, Iesu dei vole tei bit, “Moletin xa meten bar misakras vatel moletin teimun xa meten bar. Xosxa ipol ni imak, ma xalu vus lalikiri lalihe vul. ");
INSERT INTO tvk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Moletin xa nggur pispisien nggo titsa tei, xi nanemi ti nabit xi bos mak mu mili titsa nan. E xosxa xi ihur sen sukul nan, ma mei sung ixoni titsa nan. ");
INSERT INTO tvk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“?Veneh ma di mupus kil saxut liei xa hokorong tang xa de met tuemim, e mutapus kil ti vari xa marut liei xa mahulong de metemim? ");
INSERT INTO tvk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","?Veneh ma di mubiteni mi tuemim mubit, ‘Tua li, umaen ni xamem muhur rat saxut liei ra metom,’ e di mutapus ti vari xa marut liei dat e metemim? !Xamim mumese e hilbemim tang! Momal tengan, itiamu, muhur rat merut liei ra metemim. Ti, mukila sung muhit rat saxut liei ra met tuemim.” ");
INSERT INTO tvk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Iesu biteni mi vanut moletin xil ak bit, “Vatiei xa bos, taso ti huite xa misa. E vatiei xa misa, taso ti huite xa bos. ");
INSERT INTO tvk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vatiei xil vus, lapus kila nggo huite xil xa di laso ni. Musakras muleh huit manggo ra vatit vilu, e musakras muleh huit tavu ra vatit ai. ");
INSERT INTO tvk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Moletin xa meulien nan polu ni hosien, huit hosien di mistal nggo en. E moletin xa meulien nan polu ni tesaen, huit tesaen di mistal nggo en. Sepinien na moletin tei di pisen ni xa meulien nan polu ni naha.” ");
INSERT INTO tvk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iesu biteni mun mi moletin xil bit, “?Veneh ma di mukes nou mubit, ‘Suv, Suv,’ e mutapol ni ti naha xa nabiteni mi xamim? ");
INSERT INTO tvk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nitei vole tei usil hisit moletin xa bemei visal nou, di milong xat sepinien navan, e di pol nggusili. ");
INSERT INTO tvk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xi nggoni moletin tei xa di mikili ni nim man. Ma milang ves liei xil xa nggeih e mahulong tengan lihe pos xil teni. Di, mikili kuhi ni xil, e pol sen nim man. Di, melele xa us mus e votiang nggeih bemei midep, e misakras vahu len nim man. Nim man misoh nggeih tang da. ");
INSERT INTO tvk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","E moletin xa di miteong ni sepinien navan e di tapol ti vahusili, xi nggoni moletin xa mileh votei ni liei tesa xil tang, e mikili ni nim man ni. E melele xa us mus e votiang nggeih bemei, nggu len nim man vari.” ");
INSERT INTO tvk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Melele xa Iesu pispisi mi moletin xil bus, xi be Kapaniam. ");
INSERT INTO tvk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","E taon ak, vat tei na moletin xil te vaeen te hal Rom da. E tim san, slev nan tei xa bos mak mu e nenemien nan mesei pupu, sangas vamat. ");
INSERT INTO tvk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E melele xa vat ak milonge xa Iesu bemei, misil rut elda xil na Siu xil laba tengan lasis Iesu vamei vahur rat mesien ra slev nan. ");
INSERT INTO tvk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ma elda xil ak labe visal Iesu e ladakesi labit, “!Amei temanon e ututou ni vat ak li! Vengan xa xi be moletin hos tei xa xamem vus di mamerere ni. ");
INSERT INTO tvk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eheien nan di e Siu xil e xi di tetutou ni xamem melele xa matehil nim te pispisiennamem.” ");
INSERT INTO tvk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ma Iesu be xil laba. E melele xa Iesu di be sangas ni tim san, vat ak misil rut timue nan xil laba labit mesen sepinien nan mi Iesu labit, “Suv, onakon ti ve rin navan, vengan inou natapin ti tengan xouk omei e tim savan. ");
INSERT INTO tvk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E natapin ti mun tengan namei visaluk. E xosxa usepin tang, neta sav xosxa ode sotin, e nakila xa slev navan ilonge ihos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ixoni melele xa eilep navan di misa sepinien tei minou, e di napol nggusil xat raen. E melele xa inou mun nasa sepinien navan mi moletin te vaeen tei navan, xi mun di pol nggusil xat raeok. Nakila nasemae ni ngan xa de pe heok namit, ‘!Ha!’ ma xi iha. Mu namit, ‘!Amei!’ ma xi imei. E nakila nasemae ni slev tei navan namit, ‘!Pol ni netak!’ ma xi ipol ni.” ");
INSERT INTO tvk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Melele xa Iesu milong sepinien nan ak, mitemanin e biles pus vanut moletin xil xa di langgusili e biteni mi xil bit, “Reitin mak, e mol‑Isrel xil, natapus ti mu hisit neketen xa moletin ak xa tave Siu ti di pisen ni.” ");
INSERT INTO tvk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","E melele xa timue xil na vat ak ladilomun labe tim, lakameti xa slev nan milonge bos ngamu. ");
INSERT INTO tvk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dutou ni ngan ak, Iesu del moletin nan xil langgusil suse nae laba e laduxoh metimal te hal Naen. E vanut moletin xil holu di langgusil xil. ");
INSERT INTO tvk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Melele xa xil lamei sangas visal puiteh te vioh te metimal ak, xil lapus vanut moletin tei di lapo vet tei. Tiei na horam maxoe tei xa mat de vet ak e lava tengan latihin ni. Horam maxoe ak be siskes na tunau tei. ");
INSERT INTO tvk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Melele xa Suv Iesu pus tunau ak, ien misae en e biteni mini bit, “Onatang ti.” ");
INSERT INTO tvk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Di, Iesu be visal xil e misa hen ba duxol vet xa di lapoe. Ma, xil lasoh ladit mak. Di, Iesu biteni bit, “!Horam maxoe, nabiteni minuk, meul rilomun ra maten!” ");
INSERT INTO tvk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma horamue ak meul, mitamea, e misepin mun. Di, Iesu biteni mi ninen bit, “Nana, natumali xiak.” ");
INSERT INTO tvk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Moletin xil vus latemanin e lapet rat his Hi labit, “!Xosali, provet tei xa eilep mak mu de visal xir!” E labiteni mun labit, “!Hi bemei tuei tengan vatutou ni rin na moletin nan xil!” ");
INSERT INTO tvk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma longeongen usil Iesu mikapis e ut ngasen e provins te hal Sudea del rute xil vus xa be sangas visali. ");
INSERT INTO tvk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Longeongen usil Iesu duxoh moletin xil na Sion Baptis, ma ba lasep usili mini. ");
INSERT INTO tvk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Misak ni, Sion misil rumali lu luba tengan lalisis Suv Iesu lalihit, “?Xouk iaxa obe ngan xa Hi tehit xati tehit imei, mu mutatil tova mun tesav?” ");
INSERT INTO tvk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Melele xa ba lupus Iesu, lusisi lubit, “Sion Baptis tesil xamel tengan mei malsisuk imak, ‘?Xouk iaxa obe ngan xa Hi tehit xati tehit imei, mu mutatil tova mun tesav?’” ");
INSERT INTO tvk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","E melele nen ak, Iesu di dal rat moletin xil ra mesien nae e misak ni ngan xil xa lalong pangas xil mei lalonge bos rilomun. E di nggol rerat ninin tesa xil ra ngan tesav xil. E ngan xil xa metexil bar, xi pol ni xil mei laketeh rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma Iesu bit rilomun ni mi moletin xalu na Sion bit, “Muliha mun e mulihit mesen naha xa mulonge e mupusi. Ngan xil xa metexil tevar, lakila laketeh rilomun; e ngan xil xa latesakras latekakao, lakakao rilomun. Moletin xil xa latehur mesien leporsi, tenbexil mei memese rilomun; e ngan xil xa vurangexil tevon, lalongeong mun. Ngan xil xa latemat, lameul rilomun ra maten; e setutuen te longeongen hos di ba mi hoeo xil. ");
INSERT INTO tvk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Muliha mulihit mesen ni mi Sion mulihit ngan xil xa nenemien nae tave lu ti usil inou e holesok xil xa di napol ni, ma tuxolxatien na Hi iti mi xil.” ");
INSERT INTO tvk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Melele xa moletin xalu na Sion luba, Iesu misep usil Sion mi vanut moletin xil bit, “?Melele xa xamim mutehe uruvuol tengan mupus Sion, mutehe tengan mupus hisit moletin eah? ?Muteha tengan ha mupus ngan xa taxeih ti xa nggoni sulut vatiei tei xa misakras vasomal melele xa votiang bui nggeih? !E‑e! ");
INSERT INTO tvk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","?Muteha tengan ha mupus hisit moletin eah? ?Moletin tei xa mising kuhi ni eising xil xa bos pupu? !E‑e! Ngan xil xa lasing mak, meulien nae polu ni holesok holu e ladit e tim xa mahulong na eilep xil kestang. ");
INSERT INTO tvk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Mak, ma muteha tengan ha mupus visi vari? ?Provet tei? !Io! Sion be provet tei, e nave provet tei kestang. ");
INSERT INTO tvk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sion be ngan xa latetis usili e Vanuvei Eo latehit, ‘Upusi. Inou nisa eloheoh navan itiamu ni xouk. Xi iaxa iha tengan isak mesen suse ve meien nam.’ ");
INSERT INTO tvk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Reitin li nabiteni mi xamim, moletin sav tovuol xa lapesi e ut etan xa vahe eilep mu vali Sion. E xosxa moletin votei tei imaen Hi mei ihe suv toto nan, ma xi ihe eilep mak mu ili Sion pe met Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Moletin votei xil del moletin xil te takis xa lateong ni mak lakil reitinen te sepinien na Iesu. Vengan xa xil latelong kil suse xa momal na Hi texo pispisien na Sion, e latemaen Sion tebaptaes ni xil. ");
INSERT INTO tvk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","E Farasi xil del titsa xil te rae na Mosis lasin ni naha xa Hi ien bei tengan vapol ni e meulien nae vengan xa latamaen Sion ti tengan vabaptaes ni xil. ");
INSERT INTO tvk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu biteni mun bit, “?Moletin xil te xosali ak, langgoni naha? ?Sexien nae nggoni naha? ");
INSERT INTO tvk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xil langgoni tutut horamue xil xa di ladotan sangas ni von posen e di lake xat xil mun tang labit, ‘Melele xa xamem makikei e sien, e xamim mutahol ti. Melele xa xamem di madang, e xamim mutamuis ti.’ ");
INSERT INTO tvk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nabiteni mak vengan xa xamim, vat xil na Siu xil, di museputut ba xat inou xamel Sion mun vengan xa matahusil sexien namim xil ti. Vengan xa melele xa Sion Baptis temei, xi di tehal ni anien ve sisen e di tamu ti uaen, e xamim museputut ba ni mubit, ‘!Sion, ninin tesa da en!’ ");
INSERT INTO tvk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Di, melele xa inou, Nat Moletin, natemei, nangganien e namumun, e xamim mubiteni museputut ba ni nou mubit, ‘!Pus ti mu moletin ak! !Be vat anienen e vat munien tang! Xi di mikes moletin te takis xil e moletin tesa xil mun ni timue nan xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","E neta sav tang, inou nabiteni mi xamim xa ngan xil labe horamue xil na Hi lapus kil metisouen nan, e meulien nae di pisen reitinen teni.” ");
INSERT INTO tvk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dutou ni melele nen ak, Farasi tei misis Iesu tengan mei vanien vatela, hisen Saemon. Ma Iesu be tim san e dotan tengan vanien. ");
INSERT INTO tvk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","E rute sav tei e taon ak, atou tei te suse milonge xa Iesu bemei tengan vanien e tim sa Farasi ak. Ma, atou ak nggur valit vokon tei xa mani teni be nesao, e ba be nim ak. ");
INSERT INTO tvk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Melele xa be nim, atou ak mei misoh pe tou Iesu e di muis. Melele xa muis mak, simeten di mileh be tan e di mikas le Iesu, ma mitingeiril e misihi len xalu ni hilin. Melele xa len xalu lumese, mideh vokon xat xalu. ");
INSERT INTO tvk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Melele xa Farasi xa tesilasil ni Iesu pus netak, misep tasen bit, “Xosxa moletin ak be provet reitin, xi vakila xa visi iaxa di duxoli e be hisit atou eah. !Xi vakila xa atou ak be atou tei te suse!” ");
INSERT INTO tvk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Iesu biteni mi Farasi ak bit, “Saemon, ieok bei namit neta tei minuk.” Ma Saemon bit rilomun ni mini bit, “Bos tang. Hiteni.” ");
INSERT INTO tvk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Di, Iesu dei vole ak mini bit, “Vatei, rumali lu luleh mani ra eilep tei. Tei xalu nggur mani be handred taosen lim (500,000), e teimun tesav nggur mani be taosen hanutap lu e he xalu mun (50,000). ");
INSERT INTO tvk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dutou sung, rumali xalu ak lusakras lalosa xoles mani nan. Misak ni, eilep ien misae e xalu e biteni mi xalu xa ien ibong ni kaon nalu. Ma Saemon di nasisuk mak. ?Ngan xave e rumali xalu ak iaxa eheien nan iti e eilep ak ili?” ");
INSERT INTO tvk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saemon bit rilomun ni bit, “Nanemi nabit ngan xa kaon nan mahulong mak mu xa eilep ak ien bovong ni.” Melele xa Iesu milonge mak biteni mini bit, “Obiteni momal.” ");
INSERT INTO tvk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Di, Iesu biles pus atou ak e biteni mi Saemon bit, “?Xouk opus atou ak? Melele xa namei e tim sam, xouk otasa ti oei minou tengan nakas leok ni. E atou ak, tekas leok ni simeten e tesihia tevue ni hilin. ");
INSERT INTO tvk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Xouk otapesum ni viuk ti tengan ovur pilei nou e tim sam. E atou ak, melele kokot xa temei nim, xi tepesum ni leok xa tangel ni ti. ");
INSERT INTO tvk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Xouk otasa ti oel minou tengan naxul maxoe ni nou ni tengan nivue xat nou ve anien ak, e atou ak mikas leok ni vokon hos. ");
INSERT INTO tvk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Misak ni, nabiteni minuk mak: kaon xa mahulong te tesaen xil na atou ak, ieok bovong ni e ninaketeh ti mun nasa mini ven. Ve rin ak, eheien xa di pisen ni minou mahulong pupu. E ngan xa kaon te tesaen nan hokorong tang, neta sav xa ieok bovong ni kaon nan e di naketeh bos rilomun mini, eheien xa di pisen ni minou hokorong tang. E ngan ak nggoni xouk Saemon.” ");
INSERT INTO tvk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Di, Iesu biles e biteni mi atou ak bit, “Xosali, Hi tanem ti mun tesaen nam xil, e di miketeh bos rilomun mi xouk.” ");
INSERT INTO tvk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Melele xa moletin sav xil xa di langganien vituei lalong sepinien nan, labiteni mi xil mun tang labit, “?Xi minemi be visi xa mikila vahiteni xa Hi di miketeh bos rilomun e moletin xil?” ");
INSERT INTO tvk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","E Iesu biteni mi atou ak bit, “Ve neketen nam e nou, Hi di miteh meulien e xouk. Uha itel xat tomat na Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dutou ni melele nen ak, Iesu mikapis e rut taon e metimal xil. E melele xa di mikakao ba, di misetu usil longeongen hos xa midep iaxa Hi mei ihe suv toto te meulien na moletin nan xil. E melele nen ak, moletin lu e le tei (12) nan di langgusili. ");
INSERT INTO tvk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","E rut atou xil mun di langgusili: ngan xil xa Iesu tehol rerat ninin tesa latehe reling xil; e ngan xil mun xa teleh rerat mesien tehe reling xil. Tei e xil tehe Meri te hal Makdela xa Iesu tehol rerat ninin tesa lu e he sav (7) latehe relingi. ");
INSERT INTO tvk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Rut atou xil mun lateleh mani nae e latutou ni Iesu e moletin nan xil tetela: tei e xil tehe Susana, e teimun tehe Soana xa tehe atou na Xusa, vat te polien xa di milaxat holesok xil na suv toto Herod. ");
INSERT INTO tvk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vatei, moletin xil holu langgo metimal xil e lamei vituei tengan lalong ti sepinien na Iesu. E melele xa Iesu pus xil, dei vole ak mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Vatei, moletin tei ba tengan vaso utiei e naho nan. E melele xa miso lelen utiei xil be tan, rut utiei xil lamot e suse xa tan nen nggeih, e moletin xil lapel xati e tuman xil mei lada rerati. ");
INSERT INTO tvk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Rut utiei xil lamot e tan xa hat xil holu ladi en. Utiei xil ak lateh manon, e tavehi ti, lameles vengan xa tan mahin e oei tapin ti en. ");
INSERT INTO tvk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Rut utiei xil lamot e tan xa munae tesa xil di lameul en. E melele xa lateh, munae tesa xil ak mun lameul e lameul xol vin xil. ");
INSERT INTO tvk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","E rut utiei xil lamot e tan xa bos. Ma lameul bos e ladaxao bos tengan xil kekes laso huite holu mili hanutap lim (100).” Melele xa Iesu dei vole ak bus, biteni mi moletin xil bit, “!Xosxa vurangemim di, muteong kil naha xa di nabiteni!” ");
INSERT INTO tvk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dutou ni melele nen ak, moletin xil na Iesu lasisi tengan vahit kil koute te vole ak mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma xi bit rilomun ni mi xil bit, “Koute te sepinien xuxus usil lelaxatien na Hi, inou ti nihit kila mi xamim kestang. E mi mosav xil, di nabit usili nggo vole xil kestang tengan, ‘Xil liteong vuma … e linalong kil ti neta. Liketeh vuma … e linapus kil ti neta.’” ");
INSERT INTO tvk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ma Iesu biteni mi xil bit, “Koute te vole ak mak: utiei xil be sepinien na Hi. ");
INSERT INTO tvk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Utiei xil xa lamot e suse xa tan nen nggeih, nggoni moletin xil xa lataeong ni sepinien na Hi, e dutou ni, Temat bemei e mileh rerat utut sepinien xil ak ra nenemien nae. Misak ni, lasakras laling nenesien nae en e lavur meulien sal vaxo en. ");
INSERT INTO tvk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Utiei xil xa lamot e tan xa hat xil holu ladi en nggoni moletin xil xa lalong utut sepinien na Hi, e, vatei takes, langguri del sien. E vengan xa amulit neketen nae tameul kuhi ti mu, laling neketen nae e sepinien ak vuteili tang. E melele xa sakpisien xil lamei, xil lamot e neketen nae. ");
INSERT INTO tvk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","E utiei xil xa lamot e tan xa munae tesa xil di lameul en nggoni moletin xil xa lalong utut sepinien na Hi e minexo pupu ve holesok xil te ut etan e eheien nan di e mani holu mak mu. Ma holesok xil ak di lameul xol vin sepinien na Hi xa langguri, ma tava ni ti huite e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","E utiei xil xa lamot e tan xa bos nggoni moletin xil xa lalong utut sepinien na Hi e laling neketen nae nggeih en del nenemien tei xa bos e momal. Sakpisien xil te xeih lamei, e sepinien ak nggulehi di meul ba vuma … miso huite e meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu dei vole teimun bit, “Moletin tovuol xa vasahan laet nan, ti, vaha vakutaxole ni pesin mu vaha valingi vate pe vet man. E‑e. Vehakut, melele xa moletin xil lasahan laet bus, lasoxole ni de nesao tengan ngan xil xa lamei e vangit nim lakila lapus kil miehen teni. ");
INSERT INTO tvk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Reitinen xa di minggus, Hi ipisen ni mei e valkesao. E sepinien xa latehit xuxus ni tetiamu, lihithiteni pe met moletin xil tengan likila. ");
INSERT INTO tvk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Misak ni, muxuxou kuhi tengan mulong kuh sepinien navan xil. Vengan moletin xa di nggur xat koute teni, Hi isa metisouen ihe holu mu mini. E moletin xa tahur kuh ti koute teni, vuteili xa xi minemi bit mikila ngamu, Hi ihur rat rani.” ");
INSERT INTO tvk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","E melele nen ak, nine Iesu del tunali xil latomei tengan latopusi. E latsakras latohe visali vengan xa vanut moletin xil ak labe holu e langgonaxon pupu. ");
INSERT INTO tvk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma moletin tei ba bit mesen ni mi Iesu bit, “Ninom del tumali xatel mei latosoh latdi nga hale, e latbit latpusuk.” ");
INSERT INTO tvk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","E Iesu biteni mi xil bit, “Nana e tua navan xil labe moletin xil xa lalong sepinien na Hi e di lalong xati.” ");
INSERT INTO tvk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vatei, Iesu biteni mi moletin nan xil bit, “Bos xa rihur xoteh Oei Kaleli rihe rin.” Ma labut labe bot tei e laba. ");
INSERT INTO tvk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E melele xa laloh e bot ak laba, Iesu ba pat. Tavehi ti, votiang tei mistal e misak ni tehe xil milati hao, e oei bemei e vangit bot. Ngan xil xa ladi en lakameti nggeih e lapusi xa sangas tuturil nae imerir. ");
INSERT INTO tvk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Misak ni labe visal Iesu, lakes rati ra paten nan, e lake xati labit, “!Suv, suv! !Sangas ramerir xiak!” Ma Iesu mitamea, e misemae ni votiang e tehe xil tengan lihe tan. Vatei takes, votiang e tehe xil lalong xat sepinien nan e labe tan, e an mei bos mun. ");
INSERT INTO tvk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Di, Iesu misis moletin nan xil bit, “?Midep, neketen namim e nou tovuol tamu?” Melele xa lapus naha xa Iesu pol ni, lamesep pupu e ulixil mikan. Lasis xil mun tang labit, “?Moletin ak be hisit moletin eah? !Tave ti neta xa votiang e tehe xil, melele xa misemae ni xil, lalong xat raen!” ");
INSERT INTO tvk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Melele xa Iesu del moletin nan xil lade bot tei, langgur xoteh Oei Kaleli e labe ut sangas ni taon te hal Nggerasa. ");
INSERT INTO tvk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Melele xa Iesu but reling bot be ut, bisu mi moletin tei te hal Nggerasa xa ninin tesa xil ladi en. Be nousav xa moletin ak ti tenakavue ti e ti tenapat ti e nim. Dit pat e vangihat xil te tehinen. ");
INSERT INTO tvk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Vehakut, ninin tesa ak misak ni moletin ak mitalang pupu. Moletin sav xil latetal xat pisi tengan nakakao ti mun. Latevar xat hen xalu e len xalu ni sen te xeih xil. E neta sav xa mak, tetal xoteh sen xil ak. Di, ninin tesa di tetivin moletin ak ba teta tasen tang e uruvuol. Melele xa pus Iesu, muis nggeih be nesao, bemei visali e mitingeiril mini. Di, Iesu misemae ni ninin tesa tengan vahe reling moletin ak. Misak ni, ninin tesa xa di en mike be nesao mini bit, “!Iesu, Nat Hi te ut nesao! ?!Upol ni naha minou!? !Nadakesuk tengan onasa pangasien ti li minou!” ");
INSERT INTO tvk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu misisi bit, “?Hisom visi?” E moletin ak bit rilomun ni bit, “!Vanute!” Biteni mak vengan xa vanut ninin tesa xil iaxa ladi xati. ");
INSERT INTO tvk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ninin tesa xil ak ladakes Iesu tengan nasil rerat xil ti linave vangavul xa hoxalite teni tovuol. ");
INSERT INTO tvk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sangas ni rute ak, vueili xil holu di langganien e seri hu. Misak ni, ninin tesa xil ladakes Iesu tengan vamaen ni xil lava xat vueili xil ak, ma Iesu maen xil laba. ");
INSERT INTO tvk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ninin tesa xil ak labe reling moletin ak laba xat vueili xil sung. E xil lasak ni vueili xil laloh laba lakiri langgo meteh labe oei, e xil vus lamerir lalel. ");
INSERT INTO tvk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Melele xa moletin xil xa di lalaxat vueili xil ak lapus naha xa mistal, latemanon laba, e labit usili e taon e rute sav xil mun xa ladi sangas. ");
INSERT INTO tvk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Di, moletin xil xa lalongeong ni laba labit lapus ti naha xa testal xiak. Ma laba labe visal Iesu, e lapus moletin xa ninin tesa xil latehe relingi. Nenemien nan mei bos rilomun, mising ni eising e di dotan visal Iesu. Melele xa lapusi, latemanin e ulixil mikan ni Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","E ngan xil xa latepus naha xa testal latumul mi moletin xil usil suse xa Iesu tesak ni moletin ak mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Melele xa lalonge mak, moletin xil te rute ak xa ladi sangas ni metimal te hal Nggerasa lasis Iesu tengan ihe reling xil vengan xa ulixil mikan pupu. Mak toma, Iesu ba mun be bot del moletin nan xil tengan lihe reling xil. ");
INSERT INTO tvk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","E moletin xa ninin tesa xil lateti xati midakes Iesu tengan vamaen ni vahusil xil. E Iesu misila ba del sepinien ak bit, ");
INSERT INTO tvk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Utilomun uhe tim sam, ti uhithiteni mi moletin sav xil naha xa Hi tepol ni e meulien nam.” Ma moletin ak ba mikapis e rute xil vus e taon ak e misep usil neta xa bos xa Iesu tepol ni mini. ");
INSERT INTO tvk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Melele xa Iesu duxoh ri Oei Kaleli de moletin nan xil e bot tei, lamei ut sangas ni taon te hal Kapaniam. E rute ak, vanut moletin tei langgur pilei vengan xa di ladatil meien nan. ");
INSERT INTO tvk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Di, moletin tei bemei e mitingeiril momal pe valnaon, hisen Saeros. Xi be vat tei te nim te pispisienna Siu xil. Xi dakes Iesu tengan laloha mu e tim san, ");
INSERT INTO tvk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vengan xa atuli xa be siskes nan vari xa huram nan be lu e le tei (12) tang, sangas vamat xiak. E melele xa Iesu di nggusil Saeros luba, moletin xil holu di langgonaxon pupu e rin xil vus. ");
INSERT INTO tvk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","E vanut moletin xil ak, atou tei da xa mesei huram lu e le tei (12) ngamu ni mesien na atou xil xa misakras vavus. Atou ak teha tepus tokta xil holu e tesa sen mani nan mi xil, e latesakras latepol ni valonge vahos mun. ");
INSERT INTO tvk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Misak ni, atou ak bemei pe tou Iesu e misa hen ba duxol seri eising nan. Vatei takes, mesien nan bus vari. ");
INSERT INTO tvk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","E Iesu milong kila, ma misis moletin xil bit, “?Visi iaxa duxol nou?” Moletin xil vus labiteni xa latatuxoli ti. E Pita biteni mini bit, “Suv, moletin xil labe holu pupu, e di langgonaxon e laduxol xouk e rim xil vus.” ");
INSERT INTO tvk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","E Iesu bit rilomun ni mini bit, “E‑e, moletin tei duxol nou, vengan xa rut xeihen be reling nou.” ");
INSERT INTO tvk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Melele xa atou ak pusi xa misakras mun vaxus, bemei visal Iesu. Len di mulul, e mitingeiril pe valnaon. Di, pe met moletin xil, atou ak bit rati veneh ma duxol eising na Iesu, e midep iaxa mesien nan be relingi e melele taxa duxoli. ");
INSERT INTO tvk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Di, Iesu biteni mi atou ak bit, “Hinoxoli, neketen nam misak ni mei olonge bos ra mesien nam. Ma uha itel tomat na Hi e onanexo ti mun.” ");
INSERT INTO tvk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Melele xa Iesu di tamu misepin, moletin tei nggo nim ma Saeros e mei biteni mi Saeros bit, “Atuli nam mikesae ngamu. Onasis ti mun titsa xai nakon namei.” ");
INSERT INTO tvk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Melele taxa Iesu milong sepinien ak, biteni mi Saeros bit, “!Ulum nakan ti! Nenesien nam ixeih xa atuli nam imeul mun e mei istal ihe reitin.” ");
INSERT INTO tvk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","E melele xa Iesu duxoh tim sa Saeros, lapusi xa moletin xil di latangal pupu. Di lamuis e di ladang ve atuli ak. E Iesu biteni mi xil bit, “!Xamim munatang ti! Atuli ak tamat ti, xi di pat tang.” E xil di langue xati vengan lakila xa atuli ak mat tuei. Melele xa be vangit nim e rute xa atuli da en, Iesu maen Pita, Sion, Temis, tame atuli del ninen kestang latnggusili. ");
INSERT INTO tvk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Di, Iesu dal xat he atuli e misepin mini bit, “!Atuli, mea!” ");
INSERT INTO tvk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Vatei takes, meulien na atuli dilomun bemei en e mea misoh. Di, Iesu biteni mi tamen e ninen tengan lalisa ti anien mi atuli nalu. ");
INSERT INTO tvk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamen e ninen lumesep pupu e Iesu misep xol xalu tengan lalnavithiteni ti mi mosav xil usil naha xa testal. ");
INSERT INTO tvk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu mikes viton moletin nan xil xa labe lu e le tei (12). Di, misa xeihen mi xil tengan likila ti lihol rerat ninin tesa e lileh rerat mesien savsav xil ra moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Di, Iesu misil lelen xil laba tengan ha lisetu usil lelaxatien na Hi e meulien na moletin xil e suse xa mei ihe suv toto nae ixo en, e ha lileh rerat mesien ra moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","E biteni mi xil bit, “E kakaoen namim, munaleh ti neta natel xat xamim. Reitin, munaleh ti eitingil, ateli, mu mani. Munahur ti eising mu anien. ");
INSERT INTO tvk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Melele xa muhe rute tei, xosxa moletin tei nggur pilei xamim e nim man, ma muti kat en ituxoh melele xa muhe reling rute ak. ");
INSERT INTO tvk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","E xosxa moletin xil linahur pilei xamim ti e metimal tei, ma melele xa muheling rute ak, muhas rerat meas te rute ak ra lemim pe metexil. Ngan ak ihe selxatien mi xil xa Hi pus sexien tesa nae e isa rilomun ni mi xil.” ");
INSERT INTO tvk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Melele xa Iesu misepin mi xil bus, moletin nan xil lamea laba labe metimal xil vus e di lasetu usil longeongen hos na Hi. E xil laleh rerat mesien ra moletin xil e rute xil vus xa laba en. ");
INSERT INTO tvk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","E melengien nen ak, Herod Antipas be suv toto te provins te hal Kaleli. Melele xa milong usil holesok xil xa Iesu di pol ni, minem holu usili vengan xa rut moletin ngan xil di latumul holu usili. Rute xil labit Iesu be Sion Baptis xa temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Rute sav xil di labiteni xa xi be provet Ilaetsa xa mistal rilomun xiak, e rut moletin xil mun di labiteni xa provet tei tetiamu temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","E Herod biteni bit, “Inou vari tang iaxa natesemae ni tengan lita xoteh vat Sion temese. ?E visi vari iaxa di nalongeong usili xiak?” Ve rin ak, misak tengan vapus ti Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Melele xa moletin xil na Iesu lapol bus, ladilomun e lasep mesen ni mini holesok xil xa ba latepol ni. Ma Iesu mileh kes ni xil ba labe taon tei xa lakesi ni ‘Betsaeta.’ ");
INSERT INTO tvk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","E melele xa vanut moletin ngan xil lalongeong ni xa Iesu ba, lamea e langgusili. E melele xa Iesu pus xil, nggur pilei xil e di misetu mi xil usil lelaxatien na Hi e meulien na moletin xil e suse xa mei ihe suv toto nae ixo en. E ngan xil xa lamesei, Iesu mileh rerat mesien ra xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iesu pol del moletin xil ba vuma … eai ba minu. Ma moletin nan xil xa labe lu e le tei (12) lamei visali e labiteni mini labit, “Rute ak be toun ut e da be vongien tuei xiak. Bos xa usil rerat vanut moletin xil ak liha lihe metimal xil mu rute sav xil tengan ha likamet anien ae e ut te paten mae.” ");
INSERT INTO tvk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","E Iesu biteni mi moletin nan xil bit, “Xamim tang musa anien mi moletin xil tengan lia ni.” E labit rilomun ni mini labit, “!Ei! ?Mupol ni itep? Pusi xiak, xamem maleh xat beret be lim (5) e meseo be lu (2) tang. ?Midep? ?Iem bei mava maxal ti anien vapin mi vanut moletin xa be mahulong xiak?” ");
INSERT INTO tvk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Tata xil vus xa ladi e melele nen ak sangas labe taosen lim (5000), e atou e horamue xil latavuli xil ti.) Ma Iesu biteni mi moletin nan xil bit, “Ha museti moletin xil ha litotan e vanute xil xa moletin xil sangas lihe hanutap lu e he xalu mun (50) liti e vanute tei.” ");
INSERT INTO tvk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ma moletin nan xil lapol usil naha xa xi biteni, misak ni moletin xil vus ladotan. ");
INSERT INTO tvk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Di, Iesu mileh beret lim del meseo lu xiak, e miketeh be nesao e misa memesien mi Hi ven. Di, bul papas beret e meseo xil e misa ni mi moletin nan xil tengan ha liseti mi vanut moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Moletin xil vus langganien kuhi e vange polu. E melele xa moletin nan xil laleh viton rut anien xil xa moletin xil latea lingi, lase ni be valeat lu e le tei (12) xa lapolu ni. ");
INSERT INTO tvk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vatei, Iesu di misis tasen tang e moletin nan xil ladit sangas. Di, Iesu biles e misis xil bit, “?Vanut moletin xil di labiteni xa inou nabe visi?” ");
INSERT INTO tvk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","E labit rilomun ni mini labit, “Rut moletin xil labit obe Sion Baptis. E rute ngan xil labit obe provet Ilaetsa. E rute sav xil mun labit xouk obe provet tetiamu xa temea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E Iesu misis pilei xil bit, “?E xamim, ma midep? ?Mubit inou nabe visi vari?” E Pita mitamea e bit rati bit, “Xouk, obe Mesaea xa Hi tehit xati tengan imei.” ");
INSERT INTO tvk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Di, Iesu misep xol xil tengan linavit sepinien ak ti mi moletin sav xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E biteni mi xil bit, “Hi teling xati ngamu tengan inou, Nat Moletin, ti nilong pangas inou ihe holu. E elda xil na Siu xil, vat xil na pris xil, e titsa xil te rae na Mosis, xil ngasen ti lisin nou e lihas vin nou. E melele xa melengien tol mei itavi, nimea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Di, Iesu biteni mi xil bit, “Xosxa moletin tova ien bei tengan ihusil nou, ma istokovein holesok xil te meulien nan. Ti, e melengien xil vus, ipo eivave te maten nan e ihusil xat nou. ");
INSERT INTO tvk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vengan xa moletin xa misak pisi tengan ikenin meulien nan ve xi tang, ma meulien nan ikesae ra ni. E moletin xa di maen meulien nan ikesae vengan xa di nggusil xat inou, ma, e ut nesao, xi ikamet meulien sal. ");
INSERT INTO tvk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","?Naha ihos xosxa moletin tei ileh holesok xil vus te ut etan ak, e istokovein meulien sal nan tengan ileh holesok xil ak? !Navos ti vari! ");
INSERT INTO tvk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Xosxa moletin tei be unoun tengan vahit rati xa di nggusil nou e pispisien navan xil, ma inou mun, Nat Moletin, nihe unoun ni e melele xa itilomun itel masxaxa eo xil e minehinen te xeihen navan, e itel xeihen xa Tata navan isa ni minou. ");
INSERT INTO tvk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Reitin li nabiteni mi xamim xa rut xamim xa di lasoh del nou xosali, ti lipus neta tei mei istal e melele xa lameul tamu ladi xa ipisen ni xa xeihen te lelaxatien na Hi bemei ngamu.” ");
INSERT INTO tvk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Melele xa melengien tol e he sav (8) mei mitavi xa Iesu tehit kil holesok xil ak mi moletin nan xil, xi be nesao e vathu tei tengan vasis, e nggur Pita, Sion e Temis latnggusili. ");
INSERT INTO tvk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","32","E melele nen ak, Pita, Sion e Temis, met xeihen bas xatel e ba lapat. E melele xa Iesu di misis, valnaon biles, e eising nan mei mieh xa mieh pupu nggoni laet xa mileluv nggeih. E vatakes, moletin lu mun lustal e ba lusepin dela, tei xalu be Mosis, e teimun be provet Ilaetsa. Xalu mun luminehin pupu. Lubit kila mi Iesu xa itep ipol sen polien nan xil e hal Serusalem, ti, imat. E melele xa holesok xil ak di mistal, Pita, Sion e Temis, lattamea latketeh ba, e lattemanin pupu. Latpusi xa tenbe Iesu di minehin e di misoh del moletin lu mun. ");
INSERT INTO tvk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","E latopus kila xa be Mosis xal Ilaetsa iaxa lusepin del Iesu, e sangas lalohe relingi. Ma Pita mea e biteni mi Iesu bit, “!Suv, bos mak mu xa xamem madi tak! Matikili ni horao ihe tol: tei ihe mam, tei ihe ma Mosis, e tei mun ihe ma Ilaetsa.” Pita takil ti naha xa di biteni. ");
INSERT INTO tvk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E melele xa Pita di tamu misepin, momah tei xa mattel miloh bemei da xol xil, e uliatel mikan pupu. ");
INSERT INTO tvk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Di, latolong rae tei nggo momah xa bit, “Ngan ak be Natuxoli xati xa natehosei xa eheien navan di en. !Muteong xat raen!” ");
INSERT INTO tvk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Melele xa rae ak misepin bus, lattapus ti mun rumali, Iesu kestang di misoh del xatel. E neta xa xatel latopusi, latnggur xati be natel tang. Lattavit pas ti mi moletin sav xil e melele nen xil ak. ");
INSERT INTO tvk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","E makoe nen, Iesu xatel Pita, Sion e Temis latdilomun latnggo vat hu latomei e tan. E melele xa latomei e tan, lapus vanut moletin xil holu di ladatil Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Di, moletin tei xa de hilaep te vanut moletin xil ak mikei ba ni Iesu bit, “!Titsa! Ieok bei xouk li himetu tengan mei upus ti mu natuxoli xa be siskes navan. ");
INSERT INTO tvk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vengan xa ninin tesa tei da en. E melele xa bemei en, misak ni di mikei nggeih, malili tova tang, e pol ni rurungon mun di misol. Vehakut, ninin tesa ak di purun ni e nggeih pupu tengan vahe relingi. ");
INSERT INTO tvk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nadakes moletin nam xil tengan lavol rati vahe relingi, e xil lasakras.” ");
INSERT INTO tvk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Melele xa Iesu milonge mak, biteni mi moletin nan xil bit, “!Iva! !Xamim moletin xil te xosali, mukavui e neketen namim tovuol vari! ?Niti visal xamim ituxoh vilieh? Veok buol ni xamim xa neketen namim tovuol.” Di, misemae ni tame horamue bit, “Hur horamue nam vamei inggak.” ");
INSERT INTO tvk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","E melele xa horamue ak di mikakao bemei visal Iesu, ninin tesa xa da en bas tan ni e misak ni mikilkile e tan. Di, Iesu mike xat ninin tesa, ma be reling horamue ak. Di, horamue ak milonge bos mun e Iesu mideli ba misa rilomun ni mi tamen. ");
INSERT INTO tvk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngan xil xa ladi sangas lamesep tova tang ni xeihen na Hi xa lapusi. Melele xa moletin xil di labesi xil ve naha xa Iesu tepol ni, xi biteni mi moletin nan xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Xamim muteong kuhi ni sepinien navan. Nave nousav ti, moletin tei isa rat nou, Nat Moletin, nihe he moletin xil te ut etan.” ");
INSERT INTO tvk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","E moletin nan xil latakil ti koute te sepinien nan vengan xa minggus tamu ra xil. E ulixil mikan tengan lasisi ve kout sepinien nan. ");
INSERT INTO tvk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dutou ni melele nen ak, moletin xil na Iesu di langor mi xil mun tang usil visi e xil iaxa be eilep mak mu e xil. ");
INSERT INTO tvk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","E Iesu mikil nenemien nae. Misak ni, mideli tutut horamue tei bemei, e misak ni mei misoh e rin. ");
INSERT INTO tvk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Di, biteni mi xil bit, “Moletin xa nggur pilei horamue tei xa mak e hisok, nggoni ngan xa di nggur pilei inou. E ngan xa di nggur pilei inou, nggoni ngan xa di nggur pilei ngan xa tesil nou namei. Vengan xa moletin xa be neta sav tang pe metemim, xi iaxa be eilep mak mu mili xamim vus pe met Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E Sion biteni mi Iesu bit, “Suv, xamem matepus moletin tei xa di nggol rerat ninin tesa xil e hisom. Misak ni, xamem masep xole tengan napol ni ti mun vengan xa xi tave tei e xir ti.” ");
INSERT INTO tvk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","E Iesu biteni mi moletin nan xil bit, “E‑e. Munasep xole ti, vengan xa moletin xa di tavae ti vatel xamim, xi di mos e rin namim.” ");
INSERT INTO tvk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Melele xa melengien bemei sangas tengan Iesu ihe ut nesao, xi pol ni nenemien nan tengan vahe Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma misil rut moletin nan xil tengan ladiamu ni laba. Xil labe metimal tei na mol‑Sameria xil tengan lasak mesen holesok xil ven. ");
INSERT INTO tvk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","E moletin xil te metimal ak labit Iesu nava ti visal xil vengan lakila xa Iesu di nggusil suse nan tengan vahe Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Melele xa Temis xal Sion lulong usili, iexalu mikat e lusis Iesu lubit, “?Suv, midep? ?Iem bei tengan malokei ve upang vaxo ut nesao mei vaa len xil?” ");
INSERT INTO tvk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","E Iesu biles e bul xat xalu. ");
INSERT INTO tvk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Di, Iesu del moletin nan xil laka sal labe metimal sav tei. ");
INSERT INTO tvk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E melele xa di laba, moletin tei bemei visal Iesu e biteni mini bit, “Ut xave uha en, inou nihusil xatuk.” ");
INSERT INTO tvk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","E Iesu bit rilomun ni mini bit, “Asu xil vangavul te paten mae di, e tuman xil mun nunum mae di. E inou, Nat Moletin, tim savan xati tengan ningel kuhi en tovuol.” ");
INSERT INTO tvk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iesu biteni mi moletin sav tei bit, “!Husil xat inou!” E moletin ak biteni mini bit, “Bos tang, nihusiluk. E Suv, itiamu, umaen nou nitilomun niha, e nilaxat kuh tata navan ituxoh melele xa imat e nitihin ni.” ");
INSERT INTO tvk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E Iesu bit rilomun ni mini bit, “Ustokovein ngan xil xa lamat e neketen nae tengan litihin ngan xil xa lamat. E xouk iaxa umei uhithiten longeongen hos usil suse xa Hi mei ihe suv toto e meulien na moletin xil ixo en.” ");
INSERT INTO tvk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Moletin teimun bemei e biteni mini bit, “Suv, inou nihusiluk. E itiamu, umaen nou nitilomun niha e nisep ling kor ni vatimol navan xil.” ");
INSERT INTO tvk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","E Iesu biteni mini bit, “Moletin xa nggur kokot ni polien na Hi, e dutou sung, di minem holu usil naha xa testokovein ni, ma xi tapin ti tengan vahur polien ak.” ");
INSERT INTO tvk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dutou ni melele nen ak, Iesu bosei moletin sav xil xa latehe hanutap tol e he xalu mun (70). Di, misil xil labe lu lu tengan lave metimal xil vus. Iesu biteni xa xil litiamu ni, e navehi ti, xi mun ha imos e xil. ");
INSERT INTO tvk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iesu biteni mi xil bit, “Anien holu xa temetu di tuei e naho, e moletin xil te polien labe vuteili tang tengan ha lalehi vamei. Ma musis Suv te naho tengan isil moletin xil te polien lihe holu mu mei lileh anien xa di e naho nan. ");
INSERT INTO tvk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Taxeak muha. E muketeh kuhi vengan xa di nasil xamim nggoni ngan xa mube sulut sipsip xil xa di labe rute xa kuli reran xil labe holu en. ");
INSERT INTO tvk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","E melele xa muba, munaleh ti holesok xil. Munaleh ti mani, mu ateli, mu sandel ti mun natel xat xamim. E munahas ti melengien namim natel moletin xil e suse. ");
INSERT INTO tvk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","E melele xa mukamet moletin tei xa besi xi tengan vahur pilei xamim, ma mutit nim man. E melele xa muba rohon e nim man, muhiteni muhit, ‘Tomat na Hi iti mi xamim vus xa mudi e nim ak.’ ");
INSERT INTO tvk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","E xosxa ngan xil xa ladi e nim ak labe moletin te tomat e di langgur pilei xamim, ma tomat na Hi xa di e xamim iti mi xil. E xosxa xil lasin xamim, ma tomat na Hi istokovein xil e itit mi xamim melele xa muhe reling xil. ");
INSERT INTO tvk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Muti kat tang e nim ma moletin xa nggur pilei xamim, e anien mu oei eah xa lasa ni mi xamim, muhuri tang. Vengan momal tengan moletin te polien xil lihur huit polien nae. Munalil ti e nim xil. ");
INSERT INTO tvk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","E melele xa mube taon tei e moletin xil te rute ak langgur pilei xamim, anien eah xa lasa ni mi xamim, mua ni tang. ");
INSERT INTO tvk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Muha mutal rat mesien ra ngan xil xa lamesei, e muhithiteni mi moletin xil te rute ak muhit, ‘Hi dat sangas visal xamim e bit vahe suv toto e meulien namim.’ ");
INSERT INTO tvk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“E xosxa mube taon tei xa moletin xil teni latahur pilei xamim ti, ma muha musoh e valkesao e muhithiteni muhit, ");
INSERT INTO tvk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Vengan xa mutahur pilei xamel ti, di mabas rerat meas te vonemim ra lemel pe metemim. Ngan ak ihe selxatien mi xamim xa Hi pus sexien tesa namim e isa xolesi mi xamim. Mutakil ti vari xa xosali ak, Hi temei sangas ni xamim e tehit mei ihe suv toto e meulien namim, e xamim mutesin ni.’ ");
INSERT INTO tvk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Reitin li nabiteni mi xamim, e Melengien te Lepisien, pangasien xa Hi isa ni mi moletin xil xa ladi e rute ak ixeih ili pangasien xa isa ni mi moletin xil xa lateti e taon te hal Sodom tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Xi biteni bit, “!Aue li! !Isa pupu mi xamim, Siu xil te hal Korasin! !E isa pupu mun mi xamim, Siu xil te hal Betsaeta xil! Vengan xamim mutesin merekel xil xa natepol ni pe metemim, Hi isa pangasien ihe holu mi xamim. Vengan, vahit moletin xil te hal Taer e Saedon xa latave Siu ti, lapus hisit merekel xil vaxoni ngan xa mistal mi xamim, ma xil laviles ra tesaen nae xil nousav ngamu. Io, xil lapisen ni xa lalonge vasa vamak: lasing ni talmusu xil e laxul ni vulmeas. ");
INSERT INTO tvk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E Melengien te Lepisien, esaeen xa Hi ipisen ni mi moletin xil te hal Taer e Saedon ili ngan xa ipisen ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","?E xamim, Siu xil te hal Kapaniam, munemi xa Hi ipet rat xamim muhe ut nesao? !E‑e! !Xi iso xamim muhe etan e von maten vari!” ");
INSERT INTO tvk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Di, Iesu misil moletin xil del sepinien ak bit, “Ngan xil xa ti liteong xat sepinien namim, ixoni ngan xa di lateong xat sepinien navan. E ngan xil xa lisin xamim, ixoni ngan xa di lasin inou. E ngan xil xa lisin inou, ixoni ngan xa di lasin ngan xa tesil inou namei.” Di, Iesu misil xil labe lulu laba. ");
INSERT INTO tvk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Melele xa moletin hanutap tol e he xalu mun (70) xa Iesu tesil xil tengan ha lapol ladilomun, xil labesi xil holu. Labiteni mi Iesu labit, “!Suv, xamem matetal rerat mesien ra moletin xil e matepusi mun xa ninin tesa xil latelong xat xamem melele xa matesemae ni xil e hisom tengan lava!” ");
INSERT INTO tvk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","E Iesu bit rilomun ni mi xil bit, “Inou natepus Temat vari temot ra ut nesao e temei e ut etan texoni an xa milangas. ");
INSERT INTO tvk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","!Muteong kuhi! Inou natesa xeihen mi xamim tengan mupel xat tetal xil xa misa, skopion, e holesok sav xil mun xa ladi e xeihen na Temat. Reitin, mupel tan ni xil e neta ti naxul xamim. ");
INSERT INTO tvk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","E munahesi xamim ti vengan xa ninin tesa xil di lalong xat xamim. Bos mak mu xa ti muhesi xamim vengan xa Hi midis xat hisemim ngamu di e Vanuvei te Meulien xa de ut nesao.” ");
INSERT INTO tvk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","E melele nen ak, Ninin Eo misak ni Iesu mei polu ni sien e biteni bit, “Tata, xouk obe Suv te holesok xil ngasen e ut nesao e ut etan. Namesuk himetu vengan xa di ososon holesok xil ak tengan ngan xil xa langgur metisouen e kilakilen te ut etan lasakras lakil koute teni. E di opisen koute teni mi ngan xil xa langgoni tutut horamue xil xa latasukul kuhi ti. Reitin Tata, xouk di opol ni mak vengan xa di nggusil nenemien nam xa oteling xati ngamu teta.” ");
INSERT INTO tvk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Di, Iesu biteni mi vanut moletin xil bit, “Tata navan teling holesok xil vus ladi pe heok. Moletin xil latapus kil ti Nat Hi, Tamen kestang pus kila. E moletin xil latakil ti Hi Tamen, Natneli kestang mikila. E ngan xil kestang xa Natneli di ien bei tengan vapisen Tamen mi xil, xil mun iaxa likil xi.” ");
INSERT INTO tvk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Di, Iesu biles, pus moletin nan xil e biteni mi xil kestang bit, “Tuxolxatien na Hi di ngamu e xamim xa di mupus holesok xil xa di mistal xiak ni metemim. ");
INSERT INTO tvk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Reitin li nabiteni mi xamim, e melengien xil tetiamu, provet xil holu e suv toto xil holu mun iexil tehei mak mu tengan lapus ti naha xa xamim di mupusi, e latnapus ti. E iexil tehei tengan lalong ti sepinien xil xa xamim di mulonge, e latnalong ti.” ");
INSERT INTO tvk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","E melele nen ak, titsa tei te rae na Mosis bemei visal Iesu tengan vasak pisi. Ma misis Iesu bit, “?Titsa, nipol ni naha tengan nihur meulien sal?” ");
INSERT INTO tvk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","E Iesu bit rilomun ni mini bit, “?Rae xil na Mosis di bit naha? ?Xouk uhiteni minou?” ");
INSERT INTO tvk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma moletin ak biteni mini bit, “‘Iemim ihei Iahova xa be Hi namim ixo tinemim tevi, ixo meulien tevi namim, ixo polien tevi namim, e ixo nenemien tevi namim.’ E ‘Eheien namim iti e moletin sav xil ixoni ngan taxa eheien namim di e xamim mun tang.’” ");
INSERT INTO tvk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu bit rilomun ni mini bit, “Sepinien nam momal tevi. Xosxa upol ni imak, ma uhur meulien sal.” ");
INSERT INTO tvk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","E vengan xa moletin ak bit vapisen momalen nan pe met moletin xil, misis Iesu vatei mun bit, “?E moletin si vari iaxa be tua navan?” ");
INSERT INTO tvk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma Iesu dei vole tei mini bit, “Vatei, Siu tei mea nggo Serusalem e mikakao bit vahe taon te hal Seriko. E melele xa di nggusil suse nan ba, moletin tatei xil te kanen lamei ladal xati. Langgur rat eising nan e labasi. Sangas moletin ak vamat e lastokovein ni da nga. ");
INSERT INTO tvk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Di, bos xa pris tei na Siu xil di nggusil suse bemei e pusi pat da. E melele xa pusi, tava ti sangas visal e ba be seri suse e rin sav e mitavi tang ba. ");
INSERT INTO tvk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tave nousav ti, Siu tei xa nggo vatimol xa mahulong na Livae e di pol e Nim Eo na Hi nggusil suse bemei e pusi moletin ak pat da. E melele xa pusi, xi mun ba be seri suse e rin sav e mitavi tang ba. ");
INSERT INTO tvk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Di, ngan Sameria tei, xa Siu xil di laketeh misa mi xil, di nggusil suse bemei e pusi moletin ak pat da. E melele xa pusi mak, ien misae pupu li en. ");
INSERT INTO tvk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Misak ni, xi bemei visali, e mikas moten menuk nan xil ni uaen, bas oel en, e pis xol von menuk xil. Di, po rati, miling kuhi e dongki san. Di, poe ba be nim te ngelen tei e milaxat kuhi. ");
INSERT INTO tvk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","E makoe nen, ngan Sameria misa mani taosen lu (2000) mi moletin xa di milaxat nim ak. Di, biteni mini bit, ‘Ulaxat kuh moletin xa xiak. E xosxa mani ak tapin ti, naha mun xa upol ni e rin nan, ma nixal rati e melele xa nitilomun nimei.’” ");
INSERT INTO tvk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Di, Iesu misis titsa te rae na Mosis bit, “?Onemi obit naha? ?Visi e moletin xatel ak iaxa tepisen ni xa xi be tua hos tei na moletin xa moletin te kanen xil latehas purun ni?” ");
INSERT INTO tvk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","E xi bit rilomun ni mi Iesu bit, “Moletin xa tepisen esaeen mini.” Ma Iesu biteni mini bit, “Bos, ma xouk mun ha upol ni imak tang.” ");
INSERT INTO tvk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Melele xa Iesu del moletin nan xil di lakakao tengan lave Serusalem, xil lamei e metimal te hal Betani. E metimal ak, atou tei da en, hisen Merta, e xi nggur pilei xil lamei e nim man. ");
INSERT INTO tvk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tunehin, hisen Meri. E xi bemei visal Iesu e dotan sangas visal len. Xi di miteong kuhi ni pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","E Merta misakras vateong kuhi vengan xa xi di bilao ni polien te anien ae. E vengan xa xi di pol pupu, bemei visal Iesu e biteni mini bit, “?Suv, midep? ?Onemi obit bos tang xa tuxahin di miling polien xil ak di tengan inou tasok ti nipol ni? !Hiteni mini tengan vatamea mei vatutou ni nou!” ");
INSERT INTO tvk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","E Suv biteni mini bit, “Merta, Merta, onexo pupu e nenemien nam di mikon ve holesok xil holu. ");
INSERT INTO tvk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","E neta tei takes momal tengan xamil mulipol ni. Meri teling nenemien nan tuei tengan vapol ni neta xa momal, e inou ninahur rati ti rani.” ");
INSERT INTO tvk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vatei, Iesu de rute tei e di misis. E melele xa misis bus, moletin nan tei misisi bit, “Suv, pispisi mi xamem li usil sexien te sisen ixoni ngan taxa Sion Baptis tepispisi ni mi moletin nan xil.” ");
INSERT INTO tvk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Iesu biteni mi xil bit, “Melele xa musis, muhiteni imak muhit, ‘Hi Tamemem, hisom be eo e momal tengan musa merereen minuk. Masis tengan mei uhe suv toto namem e ulaxat kuh xamem. ");
INSERT INTO tvk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Usa anien li mi xamem ipin te melengien xil vus. ");
INSERT INTO tvk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Onaketeh ti mun nasa mi xamem ve holesok xil xa mapol ni tamal ti. Upol ni ixoni ngan xa xamem mun di maketeh bos rilomun mi ngan xil xa di lapol misa mi xamem. E onamaen sakpisien xil te xeih ti namei e nasak ni xamem munamot e tesaen.’” ");
INSERT INTO tvk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Di, Iesu biteni mi moletin nan xil bit, “Vahit tei e xamim vahe tim sa tuneli e hilaep te vongien e vasisi vahit, ‘?Tuak, okila osa ti anien minou? ");
INSERT INTO tvk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Vengan xa timue tei nggo sotin bemei e tim savan, e anien tovuol tengan nasa ni mini.’ ");
INSERT INTO tvk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“E tuneli xa de nim vahit rilomun ni mini vahit, ‘!Ei, onasa polien ti minou! Puiteh mikoe ngamu, e inou del horamue navan xil mun di mapat ngamu madi vet namem. Ve rin ak, nasakras namea nasa neta tova minuk.’ ");
INSERT INTO tvk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nabiteni mi xamim, tave ti neta xa ien ti tavei tengan vamea vasa ti anien minuk vengan xa xouk obe tunali, e vengan xa otave unoun ti tengan osisi, osisi, osisi vuma … xi imea e isa holesok xil vus minuk xa iem bei. ");
INSERT INTO tvk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Misak ni, nabiteni mi xamim xa xosxa iemim bei neta ngan, ma musis Hi ven e isa ni mi xamim. Xosxa mulang ni, ma mukameti. E xosxa murei puiteh ven, ma isah puiteh mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vengan xa ngan xil vus xa di lasis neta lihuri; e ngan xil xa lalang ni neta likameti; e ngan xil xa di larei puiteh, isah puiteh mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Vahit xouk ove tata tei xa natumali misisuk tengan usa meseo tova mini vaa ni. ?Usa tetal xa misa mini? ");
INSERT INTO tvk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mu vahit natumali misisuk tengan usa rel tuto tei mini. ?Usa skopion tei mini xa mikila vatil vini? !E‑e, unapol ni ti namak! ");
INSERT INTO tvk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Misak ni, mupusi xa xamim, tata xil, mukila musa neta xa bos mi horamue namim xil, neta sav xa mube moletin tesa xil te ut etan. E nabiteni mi xamim xa Tamemim e ut nesao bos mak mu mili xamim. Ve rin ak, melele xa musisi tengan vasa Ninin Eo mi xamim, isa ni vari.” ");
INSERT INTO tvk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Vatei, Iesu pus moletin tei xa be vut vengan xa ninin tesa da en e misak ni misakras vasepin. Ma Iesu minggol rati be relingi e moletin ak mei misepin sung. E vanut moletin xil xa lapusi latemanin ni. ");
INSERT INTO tvk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","E rut Farasi xil labiteni labit, “Moletin xai di nggol rerat ninin tesa xil ra moletin xil nggo xeihen xa Belsepul, suv na ninin tesa xil iaxa di misa xeihen mini.” ");
INSERT INTO tvk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","E rut moletin sav ngan xil labit lisak pis Iesu, ma lasisi tengan vapol ni merekel tova vaxo ut nesao tengan vapisen ni xa xeihen na Hi di mini. ");
INSERT INTO tvk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","E Iesu mikil nenemien nae e biteni mi xil bit, “Xosxa moletin xil na suv toto tei di labae mi xil mun tang, ma xeihen na suv toto ak mei ihe neta sav tang. E xosxa moletin xil te vatimol tei tang di labae mi xil mun, ma his vatimol ak ikesae. ");
INSERT INTO tvk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","?E xosxa ninin tesa xil na Belsepul di labae mi xil mun tang, ma ihur xat xeihen nan itep? Nabiteni mak vengan xa xamim, Farasi xil, mubiteni mubit inou di nanggol rerat ninin tesa xil nggo xeihen xa Belsepul di misa ni minou. ");
INSERT INTO tvk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?E xosxa vamak, ma midep mi moletin namim xil? ?Xil di langgol rerat ninin tesa xil ra moletin xil del xeihen na visi? Xil vari iaxa di lapisen ni xa naha xa di mubiteni tamal ti. ");
INSERT INTO tvk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","E xosxa di nanggol rerat ninin tesa ra moletin xil del xeihen na Hi, ma ngan ak di pisen ni xa xeihen te lelaxatien na Hi mistal tuei mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Belsepul nggoni silixin tei xa di miketeh xol nim man del holesok xil vus te vaeen nan tengan neta ti mei napangei holesok nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","E melele xa moletin tei xa nggeih mak mu mili silixin ak mei mistal mini e bas tan ni, xi ileh rerat holesok xil te vaeen nan, itel holesok xil xa ladi e nim man. Reitin, ileh rerat vuol ni holesok nan xil e iseti mi moletin nan xil sung. ");
INSERT INTO tvk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mak, ma ngan xil xa latamos ti vatel nou, xil di labae minou. E ngan xil xa latatutou ni nou ti tengan maleh viton moletin xil vaxoni sipsip xil, xil di langgol rerat xil laloh tasil ra nou.” ");
INSERT INTO tvk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Di, Iesu biteni mi vanut moletin xil bit, “Melele xa ninin tesa be reling moletin tei, di ba mikapis e uruvuol tengan vakamet rute tova tengan vangel kuhi en. E xosxa takamet ti, ma ihiteni mi xi mun tang ihit, ‘Nitilomun nihe nim mavan xa natehe relingi natemei.’ ");
INSERT INTO tvk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E melele xa itilomun imei, ma ikameti xa ladaveas tuei e nim ak, laling pilei holesok xil, e ninin tesav tovuol en. ");
INSERT INTO tvk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Misak ni, xi iha e ileh ninin lu e he sav (7) xa lasa mak mu mili xi. E xil lihe nim, e ha liti en. Nim ak be moletin tei, e lisak ni meulien na moletin ak isa mak mu ili ngan xa teti en tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Melele xa Iesu di tamu misepin usil rin ak, atou tei xa de hilaep te vanut moletin xil mikei ba ni bit, “Hi isa tuxolxatien mi ninom xa telinguk e telaxat kuh xouk.” ");
INSERT INTO tvk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E Iesu bit rilomun ni mini bit, “Hi isa tuxolxatien mi ngan xil mak mu xa di lalong sepinien na Hi e di lalong xati.” ");
INSERT INTO tvk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Melele xa vanut moletin xil mei labe holu, Iesu misepin mi xil bit, “Moletin xil te xosali ak lasa tang. Di lasis nou tengan nipol ni merekel tova xa lakila lake reitin e nou vaxo en. E ninapol ni ti merekel tova tengan lipusi. Tei takes vari iaxa lipusi xa ihe merekel xa testal mi Siona. ");
INSERT INTO tvk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Merekel xa testal mi Siona tepisen ni xa sepinien xa Hi tesa ni mini tengan vahit mesen ni mi mol‑Nineva xil tehe reitin. E ixo sexien ak, Hi ipol ni ixoni mi Nat Moletin tengan vapisen ni mi moletin xil te xosali ak xa sepinien navan be reitin. ");
INSERT INTO tvk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“E Melengien te Lepisien, moletin xil te xosali limea rilomun ra maten tengan Hi ilepis rin nae xil. E melele nen ak, Kuin te hal Siba xa tave Siu ti imeul mun, e xi ihit rat sexien tesa namim xil. Ipol ni mak vengan xa xi tekakao sotin temei tengan valong sepinien te metisouen na suv toto Solomon tetiamu. !E taxeak, tei xa eilep mak mu mili suv toto Solomon da xiak e xil di lasin ni! ");
INSERT INTO tvk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","E, e Melengien te Lepisien ak, moletin xil te hal Nineva mun xa latave Siu ti limei e lihit rat sexien tesa na moletin xil te xosali ak, vengan xa xil iaxa latehiles meulien nae melele xa latelong sepinien na Hi xa provet Siona tesa ni mi xil. !E taxeak, nabiteni reitin mi xamim xa tei xa mili provet Siona da xiak e xil latake reitin ti e sepinien nan e lataviles meulien nae ti!” ");
INSERT INTO tvk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Di, Iesu dei vole tei mi xil bit, “Moletin tovuol xa vasahan laet, ti, vaha vasoso ni mu vakutaxole ni pesin tova. !E‑e! Melele xa misahan ni bus, poe ba misoxolen ni de kesao. Mak, ma melele xa moletin ngan xil lamei e nim lakila lapusi xa laet di mileluv e nim. ");
INSERT INTO tvk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Metexir mun nggoni laet te tenbexir. Xosxa metexir bos, ma nggoni ngan xa meulien nar di e miehen e rakila rapus kil naha xa be reitin. E xosxa metexir bar, ma nggoni ngan xa meulien nar di e maluxoluken e rasakras rapus kil naha xa be reitin. ");
INSERT INTO tvk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Misak ni, xamim muxuxou kuhi xa meulien namim iti e miehen, e nati ti e maluxoluken. ");
INSERT INTO tvk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xosxa meulien namim di e miehen, e maluxoluken tovuol en, ma meulien namim ipolu ni miehen e mupus kil holesok xil vus.” ");
INSERT INTO tvk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Melele xa Iesu misepin bus, Farasi tei mei misisi tengan ha vaanien vatela e tim san. Ma Iesu be xalu lube tim san e dotan e vet te anien en nan. ");
INSERT INTO tvk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","E Farasi ak mitemanin melele xa pusi xa Iesu takas hen ti e ba dotan tengan vaanien. ");
INSERT INTO tvk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Suv Iesu biteni mini bit, “O reitin, xamim Farasi xil munggoni kap e pelet xa di lakas moten ni e hale tang, e vangite mumu nggoni tinemim xa polu ni nenemien te hokanen e holesok sav xil xa lasa. ");
INSERT INTO tvk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Xamim mube unu xil vari! ?Mutakil ti xa Hi xa tepol ni hale te moletin xil, xi vari iaxa tepol ni vangite mun? ");
INSERT INTO tvk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","E ihos mak mu xosxa musa oei xa de vangit kap e anien xa de vangit pelet mi ngan xil xa labe hoeo. Imak, ma meulien namim imese kuhi pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Isa pupu mi xamim, Farasi xil, vengan xa pangasien xil xa imei e xamim ihe mahulong. Xamim di mungguxou kuhi tengan muhusil rae xil xa labe hokorong tang. Ve rin ak, di mubuli kuhi ni tutut uvei xil te kuk en tengan mukila muhur rat taet teni tengan musa ni mi Hi. E mutahusil ti rae xil xa labe mahulong nggoni sexien xa di mupisen eheien namim mi Hi e mi mosav xil. Momal mak mu tengan, itiamu, muhusil rae xil xa labe mahulong tengan mupisen sexien te eheien. E, itutou sung, iemim nabong ni ti tengan muhusil rae xil xa labe hokorong mun. ");
INSERT INTO tvk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Isa pupu mun mi xamim, Farasi xil, vengan melele xa mube nim xil te pispisien iemim bei tengan mutotan e von merereen na eilep xil. E melele xa mube von posen mun, iemim bei tengan moletin xil ti likes kuh xamim e ti limerere ni xamim. ");
INSERT INTO tvk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Isa pupu mi xamim, vengan xa meulien namim tamese ti. Munggoni von tehinen xil xa lataling simeleleen ti vati en, xa moletin xil di lakakao sangas visali e latakil ti xa neta vutei bo di en.” ");
INSERT INTO tvk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Titsa tei te rae na Mosis biteni mi Iesu bit, “Titsa, melele xa di osepin mak, di osep purun xamem mun.” ");
INSERT INTO tvk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Iesu biteni mi xil mun bit, “Isa pupu mun mi xamim titsa xil te rae na Mosis, vengan xa di muling xat rae xil holu xa meas da xat mar moletin xil. E xil lasakras lalehi. E di, iemim ti tavei tengan musa hemim vatutou ni xil tengan lalehi. ");
INSERT INTO tvk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Isa pupu mun mi xamim, vengan xa di mupol kuhi ni tutut nim xil xa da xol von tehinen na provet xil, provet xil xa, tetiamu, avu namim xil vari latehas vin xil. ");
INSERT INTO tvk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Reitin, xil latehas vin provet xil, e xamim di mupol ni nim te tehinen nae. Nggo sexien ak iaxa di mupisen ni xa mumae e nenemien na avu namim xil melele xa latehas vin xil. ");
INSERT INTO tvk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ngan ak nggoni naha xa Hi xa be metisou pupu tehiteni xa tehit, ‘Inou nisil provet xil e eloheoh navan xil liha mi moletin navan xil. E moletin navan xil lihas vin rute ngan xil e lisak purun tesav xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ve rin ak, Hi isa pangasien mi xamim, moletin xil te xosali ak, vengan xa pusi xa hemim be muis ni re provet xil vus xa latehur sepinien na Hi e melele xa xi tepeas ni ut etan mei duxoh xosali, provet xil ak xa avu namim xil iaxa latehas vin xil. ");
INSERT INTO tvk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Reitin mak nabiteni mi xamim, re moletin xil vus na Hi xa avu namim xil latehas vin xil di lasak ni hemim be muis, maten na Ebel ba teha vuma ... tetuxoh maten na provet Sakaraea xa latehas vini e hilaep te hor te sanien e Nim Eo na Hi. E Hi isa pangasien ve maten xil ngasen nae mi xamim vus te xosali ak. ");
INSERT INTO tvk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Isa pupu mun mi xamim titsa xil te rae na Mosis, vengan xa moletin xil labit lamei visal Hi e xamim di musoson ki te puiteh xa lakila laxo en tengan mei lakil Hi. !Xamim iemim ti tavei tengan muxo puiteh ak tengan ha mukil Hi, e di musikoe xol moletin sav xil mun xa iexil bei tengan laxo en e mei lakil Hi!” ");
INSERT INTO tvk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Melele xa Iesu be reling nim te pispisien ak, titsa xil te rae na Mosis del Farasi xil, iexil mikat pupu ni ven. Misak ni, e melengien ak ba, xil latesak pisi tengan lasis Iesu ni holesok xil xa nggeih. ");
INSERT INTO tvk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Xil laling nenemien nae labit lisak pis Iesu tengan isa sepinien tova mu ipol ni neta tova xa likila lital xati ven. ");
INSERT INTO tvk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","E melele nen tak, moletin xil labe holu xa labe holu pupu xa lamei, e lating e dit lapel xat lexil tengan lapus Iesu. E Iesu biles misepin mu mi moletin nan xil bit, “Muketeh kuhi ve pispisien xil na Farasi xil xa lamese e hilbexil kestang. Nggoni is xa di pol xuxus ni pulaoa mei mikaio, pispisien nae mikila vapurun xuxus ni nenemien na moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","E holesok xil xa moletin di mikutaxole, Hi ital rati imei valkesao. E neta xa moletin misak pisi tengan valing xuxus ni, Hi ileh rerati imei e valkesao tengan moletin xil vus lipus kila. ");
INSERT INTO tvk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Holesok xil vus xa di lasep usili e maluxoluken, moletin xil lilong usili e miehen tang. E holesok xil xa moletin di misep piao ni e nim man, likekei ni pe met moletin xil tengan likila.” ");
INSERT INTO tvk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iesu biteni mun mi moletin nan xil bit, “Nabiteni mi xamim, tuxoli xil, ulimim nakan ni ti ngan xil xa likila lihas vin tenbemim. Vengan xa, itutou ni, lasakras lapol ni ti neta mun mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","E nihit kila mi xamim visi vari ulimim ikan ni. Ulimim ikan ni Hi kestang, vengan xa xi mikila ihas vin moletin tei, e nggur xeihen mun tengan iso ni ihe Upang xa misakras vamat. !Reitin mak, ulimim ikan ni Hi kestang! ");
INSERT INTO tvk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tuholaea xil xa latereli tang, moletin mikila vaxale vahe lim ni rut mani tei xa hokorong tang. E Hi ien tabong ni ti tova vari. ");
INSERT INTO tvk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","E meulien namim eilep mak mu pe met Hi mili tutut tuman xil ak e ilaxat kuh xamim. Reitin mak, Hi mikil sen hilimim kekes xa di e vatumim. Ma, munanexo ni ti neta.” ");
INSERT INTO tvk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Di, Iesu biteni mi moletin nan xil bit, “Nabiteni reitin mi xamim, xosxa moletin di bit rati pe met moletin xil bit di nggusil nou, ma inou, Nat Moletin, nihit rati mun pe met masxaxa xil na Hi nihit xi be moletin navan. ");
INSERT INTO tvk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","E xosxa moletin di bit rati pe met moletin xil bit di misin nou, ma inou, Nat Moletin, nihit rati mun pe met masxaxa xil na Hi nihit di nasin ni. ");
INSERT INTO tvk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“E ngan xil vus xa lasepin misa ba xat hisok xa nabe Nat Moletin, Hi ikila iketeh ihos rilomun mi xil. E ngan xil xa lasepin misa ba xat his Ninin Eo, ma Hi naketeh ti navos rilomun mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“E melele xa moletin xil lital xat xamim e lileh xamim ha musoh pe met vat xil te nim te pispisienna Siu xil mu pe met eilep xil te kavmen, munanexo ti. Munanem ti nahe holu usil sepinien xa ti muhithiteni. ");
INSERT INTO tvk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Vengan xa, e melele nen ak, Ninin Eo iaxa ipispisi mi xamim ni sepinien eah xa mukila muhithiteni.” ");
INSERT INTO tvk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Moletin tei xa de vanut moletin xil ak mei misis Iesu bit, “Titsa, tata navan mat. Hiteni mi tua navan tengan vaseti holesok xil na tamemel mi xamel.” ");
INSERT INTO tvk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","E Iesu bit rilomun ni mini bit, “?Tuxoli, visi iaxa teling nou tengan nilepis rin namil mu niseti holesok xil na tamemil mi xamil?” ");
INSERT INTO tvk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Di, xi biteni mi moletin xil vus bit, “Muxuxou kuhi e muketeh kuhi xol xamim tengan eheien te holesok xil nalihi nenemien namim ti. Vengan xa holesok xil te ut etan ak nave vatit meulien namim ti, neta sav xos holesok namim xil labe holu midep.” ");
INSERT INTO tvk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Di, Iesu dei vole ak mi xil bit, “Vatei, moletin tei da xa holesok nan holu. E naho nan xil, anien xil labe holu xa labe holu pupu. ");
INSERT INTO tvk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Di, nggur nenemien tei bit, ‘?Nipol ni itep? Ut tapin ti e nim mavan xil tengan niserev anien xil ak en. ");
INSERT INTO tvk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","!Aha nakila! Inou nipol ni imak. Nita lelen nim xil xa hokorong tang xiak, e ti, nipol ni nim xil xa lihe mahulong mak mu tengan niserev kuh anien xil ak itel holesok sav xil navan liti en. ");
INSERT INTO tvk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ti, nite meulien tei xa ihos itel holesok navan xil. Ningel kuhi, nianien kuhi, nimun kuhi, e nihesi nou vehakut.’” ");
INSERT INTO tvk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Di, Iesu biteni bit, “E Hi ihiteni mini ihit, ‘!Xouk obe unu tova tang! E vongien nen tak, nihur rat meulien nam ra xouk. ?Imak, ma holesok nam xil ak xa di oserev kuhi, visi vari ilehi?’” ");
INSERT INTO tvk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Melele xa Iesu dei vole ak bus, biteni bit, “E Hi ipol ni imak mi ngan xil xa di laso viton holesok xil holu mei be nae kestang tengan lakila lalonge vahos vatela, e naha xa eilep mak mu pe met Hi tovuol e meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Di, Iesu biteni mi moletin nan xil bit, “Vengan xa ngan ak be reitin, di nabiteni mi xamim, munanexo ti ve meulien namim: ve naha xa ti mua ni, mu ve naha xa ti musing xol tenbemim ni. ");
INSERT INTO tvk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vengan xa mutahur meulien namim ti tengan muanien kestang, e mutahur tenbemim ti tengan musing xole kestang. ");
INSERT INTO tvk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mupus ti mu tuman xil ak. Xil latapol ni ti naho tengan ti laleh anien vaxo en. Reitin, povah mae tovuol tengan laserev xat anien ae vati en. E neta sav xa mak, Hi di misa anien ae. E pe met Hi, xamim mube eilep mak mu mili tuman xil ak. ");
INSERT INTO tvk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nenexoen misakras vatutou ni moletin tei tengan vasak ni meulien nan vahe teviei luvoluv mu. ");
INSERT INTO tvk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","?E xosxa nenexoen misakras vapol ni neta xa hokorong vamak e meulien namim, ma veneh iaxa di munem pupu usil holesok sav xil mun xa iemim bei? ");
INSERT INTO tvk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Munem pisi usil hungovae xil e sexien xa di lameul en. Xil latapol ti e latatil ti eising nae. E nabiteni mi xamim, suv toto Solomon tetiamu, eising nan xil tehos xa tehos, e hungovae xil ak, lasing xol xil bos mak mu laleli. ");
INSERT INTO tvk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Reitin, Hi di mising xol kuh hungovae xil ak bos xa bos, tave ti neta xa di lameul melengien tei takes, e melengien sav tang, lameles e lakiri. Di, ladaveas viton ni e laso ni be upang. ?E xosxa Hi di mising xol xil mak, veneh ma di munexo xa nalaxat kuh xamim ti? !Ei, nenesien namim en hokorong tova tang! ");
INSERT INTO tvk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Tavos ti xa munexo ve naha xa mua ni mu mumu ni. ");
INSERT INTO tvk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vengan xa hisit nenexoen xil ak labe na ngan xil xa latakil ti Hi. E Hi xa be Tamemim mikil naha xa xamim mube tamure ni e meulien namim. ");
INSERT INTO tvk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","E bos xa musa xamim ve holesok xil xa be eilep mak mu pe met Hi xa be suv toto namim. E xi ilaxat kuh rin namim. ");
INSERT INTO tvk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Xamim munggoni sulut sipsip savan xil. Misak ni, ulimim nakan ti e munanexo ti vengan xa Tamemim memaal himetu tengan vasa holesok xil xa be nan mi xamim. Reitin, xamim mulaxat viton rute xil vus xa xi be suv toto en. ");
INSERT INTO tvk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ve rin ak, ha mupos vuol ni holesok namim xil e musa mani teni mi hoeo xil. Imak, ma Hi ipus kil sexien xil namim e isa huite teni xa ihos xa ihos mi xamim e ut nesao, e rute xa pipei xil lasakras lapangei, e moletin te kanen xil lasakras lakan ni. ");
INSERT INTO tvk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nabiteni mak vengan xa nenemien e eheien namim iti e rute xa di muserev naha xa be eilep mak mu e meulien namim di en.” ");
INSERT INTO tvk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Iesu biteni mun mi moletin nan xil bit, “Vehakut, muvue xat meulien namim ve naha xa imei ixoni ngan xa di musing ni eising te polien e laet namim di pili. ");
INSERT INTO tvk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xamim muxoni slev xil xa di ladatil suv nae xa ba be anien te tetelien tei, e latakil ti melele eah xa imei mun en. Misak ni, xil livue xat xil vehakut tang ve melele xa suv nae imei rilomun e ikes xil. Imak, ma melele xa ikes xil, vatakes lisah puiteh ven. ");
INSERT INTO tvk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","E xosxa suv ak imei rilomun e ipusi xa slev nan xil di ladatili mak e latapat ti, ma ihesi xi ihe holu ve xil, e xil lipus hosien nan e meulien nae. Reitin li nabiteni mi xamim xa suv nae ipol ni ihos mi slev nan xil. Xi vari ising ni eising te polien, ikes slev nan xil mei lianien, e xi iaxa isa anien ae. ");
INSERT INTO tvk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tave ti neta xos suv nae bemei e hilaep te vongien mu e makoe roroh, hosien iti mi slev xil xa labue xat xil vehakut ve mei rilomun en na suv nae. ");
INSERT INTO tvk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Reitin, muvue xat xamim vehakut. Mukila vahit moletin tei, vakil melele xati xa moletin te kanen imei e nim man, xi mikila iketeh xole tengan moletin te kanen namei ti en. ");
INSERT INTO tvk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vengan, usil sexien nen tak, inou, Nat Moletin, nimei rilomun e melele tei xa moletin xil linakil ti ixoni moletin te kanen. Mak, ma muvue xat kuh xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Di, Pita misis Iesu bit, “?Suv, otetei vole ak usil xamem kestang xa mabe moletin nam xil, mu usil moletin xil vus?” ");
INSERT INTO tvk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Suv Iesu bit rilomun ni mini nggo vole teimun bit, “?Visi iaxa be moletin te polien xa be metisou kuhi e di miteong xat rae na suv nan? Xi be ngan xa suv nan milingi be vat na moletin te polien sav xil e tim san tengan ti isa anien mi xil e melele xati teni. ");
INSERT INTO tvk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","E tuxolxatien iti mi moletin te polien xa, melele xa suv nan itilomun imei, ikameti xa xi di tamu pol ni polien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Reitin li nabiteni mi xamim xa suv nan ipet rat moletin te polien ak ihe nesao tengan ti ilaxat holesok sav nan xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“E xosxa moletin te polien ak xa suv nan telingi tehe vat te nim man di minemi bit, ‘Ei, suv navan da nousav, e tamei ti mok.’ Misak, ni di bas tiramue e atou sav xil te polien e nim ak, e di ngga vin xi e di mumun vuma mitalang. ");
INSERT INTO tvk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","E suv nan imei rilomun e melele tei xa xi tanemi ti vahit imei en. E melele xa imei rilomun, suv ak ihas purun ni e iso rati ha ite von longpangasien itel ngan tesav xil xa di lalong ras rae na suv nae. ");
INSERT INTO tvk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Xosxa moletin te polien tei mikil kuh naha xa suv nan ien bei tengan vapol ni, e tavue xat xi ti tengan vapol ni, ma suv nan ihas purun ni e isak ni ilong pangas pupu ni xi ven. ");
INSERT INTO tvk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","E xosxa moletin te polien tei takil ti naha xa suv nan ien bei tengan vapol ni, e ba pol ni neta tei xa misa, ma suv nan ihasi ihe vuteili tang e isak ni ilong pangas xi ihe hokorong tang. Vengan ngan xil xa Hi tesa holesok holu mi xil, xi ien bei tengan ipus huite holu mei ixo xil. E ngan xil xa Hi teling holesok xil holu mu teti hexil, Hi ien bei tengan ipus huite xil lihe holu mak mu mei listal lixo en.” ");
INSERT INTO tvk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu biteni mun mi moletin nan xil bit, “Inou namei tengan nasahan upang tei vaa moten ut etan. E vahit upang ak vamei ngamu, ma vahos. ");
INSERT INTO tvk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nave nousav ti, ha nihur longpangasien holu. E di nalong pangas nou ven ha ituxoh melele xa nipol sen polien navan xil. ");
INSERT INTO tvk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Xamim munemi mubit inou namei tengan niling tomat e ut etan? E‑e, ninaling tomat ti mu. E nipol ni moletin xil ti liseti xil ve nou. ");
INSERT INTO tvk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mak, ma taxeak iha, vatimol tei ti liti pas xil, e ngan xil xa ladi e vatimol tei, liketeh isa ni ngan tesav xil. ");
INSERT INTO tvk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tata xil lisel mi horamue nae xil, e horamue xil lisel mi tamexil. Nana xil lisel mi atuli nae xil, e atuli xil lisel mi ninexil. Atou xil lisel mi havnahin xil, e xil lisel mi avu sasa nae xil.” ");
INSERT INTO tvk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu biteni mun mi vanut moletin xil bit, “Melele xa mupus momah xa maluxoluk bemei nggo ist e votiang xa di mukesi ni ‘toio,’ mukila xa us vamus xiak, ma mus. ");
INSERT INTO tvk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E melele xa mupus votiang xa di mistal nggo notwes xa mukesi ni ‘aru,’ mukila xa ut vavue xiak, ma ut bue. ");
INSERT INTO tvk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","!Xamim, mube vat luvosen xil tang! Melele xa mupus neta tei xa mistal e ut etan mu e tilang hat, mukil kuh koute teni. ?E veneh ma mutapus kil ti sung koute te naha xa Hi di pol ni taxeak? ");
INSERT INTO tvk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Xamim vus mukil naha xa momal tengan mupol ni, e di mutapol ni ti. ");
INSERT INTO tvk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Xosxa moletin tei bit vahuruk ove kot ve neta ngan xa xi bit otepol ni mini, ma momal tengan utemanon ha userev rin nam itela melele xa di tamu munggusil suse tengan mulihe von koten. Maxani, xosxa onapol ni ti, melele xa multuxoh kot, xi ilinguk e he moletin te lepisien. Ma moletin ak ilinguk e he polis, e polis ilinguk e nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Reitin li nabiteni minuk, xouk utat rute ak e osakras ha vem vamase ha vuma … uxal rat vuol ni faen xa lalingi di xatuk.” ");
INSERT INTO tvk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E melele nen ak, rut moletin xil ladi xa latumul mi Iesu usil Siu xil te hal Kaleli xa latehe Nim Eo na Hi tengan lisa sanien eo xil nae mini. E melele xa di tamu latepol ni, moletin te vaeen xil na suv Paelet mei latehas xil e rute ak. E rexil teleh tehiles tetel re vongoro xil xa latehasi tehe sanien nae xil. ");
INSERT INTO tvk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Iesu biteni mi xil bit, “?Midep? ?Munemi mubit suse xa ngan Kaleli xil ak latelel texo en di pisen ni xa tesaen nae tehe eilep mak mu teli ngan xa di e rin na moletin sav xil te hal Kaleli? ");
INSERT INTO tvk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","!E‑e, tave reitin ti! Nabiteni mi xamim, xosxa munaviles meulien namim ti ra tesaen namim, ma xamim mun mulel imak tang. ");
INSERT INTO tvk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Munem usil pis usil moletin tol e le sav (18) xa latelel sangas ni rute tei xa lakesi ni Saelom e melele xa nim te ketehen xa teviei tehe nesao temot mei teta xat xil. ?Midep? ?Munemi mubit latelel vengan xa tesaen nae xil tehe tellep mak mu teli tesaen na moletin sav xil te hal Serusalem? ");
INSERT INTO tvk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","!E‑e, tave reitin ti! Nabiteni mi xamim, xosxa munaviles meulien namim ti ra tesaen namim xil, ma xamim mun mulel imak tang.” ");
INSERT INTO tvk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Di, Iesu dei vole tei mi moletin xil ak bit, “Vatei, moletin tei da xa di misis moletin te polien nan tengan vaha valih vatit fik tei vate urvatiei te grep san. E melele xa vatit fik ak di meul, vehakut, xi ba tengan valang ni huite. E vehakut, mikameti xa huite tovuol en. ");
INSERT INTO tvk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma, biteni mi moletin xa di milaxat urvatiei san bit, ‘Huram tol tuei iaxa natemei tengan nalang ves huite e vatit fik ak, e natakamet ti neta vari. !Ta rati vaha vengan xa dat votei e tan ak!’ ");
INSERT INTO tvk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“E moletin xa di pol e urvatiei san bit rilomun ni mini bit, ‘Suv, lingi vata munamun mu vahe huram tova tang. Inou nihil kuh tan xa di mikapis xole mei imerou, e niso tan xa bos en tengan itutou ni mei imeul ihos. ");
INSERT INTO tvk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xosxa iva e huram xor, ma bos. E xosxa nava ti, ma nita rati sung iha.’” ");
INSERT INTO tvk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Vatei, e Sabat, Iesu di pispisi mi moletin xil e nim te pispisientei. ");
INSERT INTO tvk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","E pusi xa atou tei de rute ak xa ninin tesa tepurun marin huram tehe tol e le sav (18) e misak ni misakras vasoh vamal. ");
INSERT INTO tvk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Melele xa Iesu pusi, mikei ba ni bit, “Nana, nalal ratuk omeluv ra mesien nam.” ");
INSERT INTO tvk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iesu miling hen en, e vari nga atou ak misomal e memes Hi ven. ");
INSERT INTO tvk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Melele xa vat te nim te pispisienak pusi xa Iesu pol ni mar atou ak mei bos e Sabat, ien mikat. Ma, misel ba ni vanut moletin xil ak bit, “Melengien tei e he sav (6) iaxa moletin ikila ipol en. Xamim mukila mumei e melengien xil ak tengan lileh rerat mesien ra xamim, e nave Sabat ti.” ");
INSERT INTO tvk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","E Iesu bit rilomun ni mini bit, “!Iva, xamim mumese e hilbemim tang! Xamim mun di mupol e Sabat. Reitin, xamim di mulal rat buluk samim xil e muleh xil ba di langganien e lamu oei e Sabat. ");
INSERT INTO tvk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","?E midep mi atou ak xa be natnahin tei na Ebraham xa Temat tevar xati huram be tol e le sav (18) xiak? ?Munemi mubit rasakras ralal rati vameluv ra mesien nan e Sabat?” ");
INSERT INTO tvk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sepinien na Iesu misak ni moletin xil xa laketeh misa ni labe unoun. E moletin sav xil labesi xil tova tang ve polien hos xil xa Iesu di pol ni. ");
INSERT INTO tvk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Di, Iesu biteni mi vanut moletin xil bit, “?Hi imei ihe suv toto na moletin xil itep? ?Nihit kila mi xamim itep? ");
INSERT INTO tvk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sexien teni nggoni utut mastad tei xa hokorong xa hokorong xa moletin tei ngguri e milihi e naho san. Neta sav xa utut mastad ak be hokorong mak, meul tepiei be nesao ba vuma ... mei be mahulong pupu mili holesok sav xil xa di lalih xil e naho. Reitin, melele xa matu, mei pipin tengan tuman xil mei lipol ni nunu mae xil e halite xil.” ");
INSERT INTO tvk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Di, Iesu biteni mi xil bit, “?Hi imei ihe suv toto na moletin xil itep? ?Nihit kila mi xamim itep? ");
INSERT INTO tvk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sexien teni nggoni is vutei xa atou tei ngguri e bilesi del pulaoa xa mahulong. E tave ti neta xa miling is hokorong tang en, is ak pol ni pulaoa ak mikaio ba vuma … mei be mahulong xa mahulong.” ");
INSERT INTO tvk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Melele xa Iesu di nggusil suse nan tengan vahe Serusalem, xi misao ni metimal e taon xil hao e di pispisi mi moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Vatei, moletin tei misisi bit, “?Suv, midep? ?Hi iteh meulien e moletin xil holu, mu rut moletin xil tang?” ");
INSERT INTO tvk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","E Iesu bit rilomun ni mini bit, “Vehakut, xamim di musak pisi tengan muxo puiteh xa hokorong muve ut nesao. Vengan xa be reitin xa moletin holu di lasak pisi tengan laxo en, e lasakras. ");
INSERT INTO tvk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Melele tei di bemei xa Suv te nim ak mei ikoe xol puiteh e ilok xole. E melele nen ak, xamim mei musoh e hale, ti muti puiteh, e mukei iha mi Suv muhit, ‘!Suv li, sah puiteh tengan mavat nim!’ “E xi ihiteni mi xamim ihit, ‘E‑e, munamei ti nim vengan xa natakil ti xamim e natakil ti xa munggo xave.’ ");
INSERT INTO tvk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ma xamim muhiteni mini muhit, ‘E, okil xamem. Vengan xa mateanien e matemun tetelak. Xouk otepispisi mi xamem e metimal namem.’ ");
INSERT INTO tvk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“E xi ihiteni mi xamim ihit, ‘E‑e, inou natakil ti vari xa xamim munggo xave. !Muhe reling nou, xamim vus xa mukavui!’ ");
INSERT INTO tvk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","E melele nen ak, Suv iso rat xamim, Siu xil, mutit hale tang, e ti mumuis e ti muat luhemim ve longpangasien namim. E muti nga sotin, ti mupus Ebraham, Aesak e Siekob itel provet xil tetiamu xa ladi e nim na Hi e ut nesao. ");
INSERT INTO tvk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","E moletin xil xa latave Siu ti lixo rute xil vus te ut etan, e mei liti e rute xa Hi ihe suv toto nae en. Xil mei litotan e von anienen nan itela. ");
INSERT INTO tvk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Reitin, ngan xil xa di mupus xil langgoni neta sav tang, xil mei lihe eilep mak mu lileli xamim. E xamim xa munemi mubit mube eilep mak mu, mei muhe neta sav tang pe met Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","E melele nen tak, rut Farasi xil lamei visal Iesu e labiteni mini labit, “!Bos xa umea e uhe reling rute ak uha, vengan xa suv toto Herod Antipas bit vahas vinuk!” ");
INSERT INTO tvk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","E Iesu bit rilomun ni mi xil bit, “Mutilomun muha e muhiteni mi kuli reran ak muhit, ‘Xosali e visuvong, ti nihol rerat ninin tesa xil e nileh rerat mesien ra moletin xil. E, e melengien tol nen, nipol sen polien xa natemei ven. ");
INSERT INTO tvk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Io, xosali, visuvong, e heis, nihusil suse navan nihe Serusalem. Reitin, nihe Serusalem e lihas vin nou en, vengan xa rute sav xil tavos ti tengan Siu xil lavas vin provet tei na Hi en. ");
INSERT INTO tvk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“!O moletin xil te hal Serusalem! Xamim iaxa mutehas vin provet xil e mutehov vin eloheoh xil xa Hi tesil xil latemei ve xamim. Melengien xil holu, ieok bei pupu tengan nakes viton xamim e nasikoe xol xamim vaxoni tuto tei xa mikes viton tuten xil mei mite aveoun e muhin xol xil. E xamim iemim ti tavei. ");
INSERT INTO tvk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Misak ni, Hi istokovein xamim e nasikoe xol xamim ti mun. Imaen Nim Eo namim mei ita hon tang, moletin ti mun nava en. Nabiteni reitin mi xamim, munapus ti mun inou ituxoh melele xa muhiteni muhit, ‘!Tuxolxatien iti mi ngan xa di bemei e his Iahova!’” ");
INSERT INTO tvk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E Sabat tei, Iesu ba mingganien e tim sa vat tei na Farasi xil. E Farasi sav xil lamei tengan lipus ti xos ipol ni neta tova xa tamal ti e Sabat xa likila lilihi ihe von koten nae ven. ");
INSERT INTO tvk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Di, moletin tei xa len e hen mitep bemei nim e misoh pe met Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Iesu biles pus titsa xil te rae na Mosis e Farasi xil e misis xil bit, “?Rae nar di maen xir tengan rital rat moletin tova ra mesien nan, mu tamaen ni ti?” ");
INSERT INTO tvk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","E xil ladit votei, latavit ti neta. Ma Iesu duxol moletin ak e pol ni ven mei bos rilomun. Di, misil moletin ak ba. ");
INSERT INTO tvk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Di, Iesu biteni mi xil bit, “?Vahit tova xamim, horamue nan mu buluk san vamot vahe vul e Sabat, ma vapol ni naha? Vatakes, vatal rat vari ni. ?Midep, ngan ak be reitin?” ");
INSERT INTO tvk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","E xil lasakras lasa rilomun ni sepinien nan. ");
INSERT INTO tvk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E anien ak, Iesu pus kila xa rut moletin xa lasilasil ni xil di lale kis ni von totanen xil xa bos. Ma dei vole tei mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Melele xa moletin tei misilasil ni xouk e anien te tetelien tei, onatemanon ti tengan onahur von totanen xa bos mak mu. Vengan xosxa latesilasil ni moletin tei xa be eilep mak mu mili xouk, ");
INSERT INTO tvk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ma melele xa imei, ngan xa tesilasil ni xouk mei ihiteni minuk ihit, ‘Umea e umaen eilep ak mei ihur voninom.’ Imak, ma xouk uhe unoun pe met moletin xil, e ha uhur von totanen xa misa tang. ");
INSERT INTO tvk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Misak ni, xosxa lasilasil ni xouk, ha utotan e von totanen xa tavos ti. Imak, ma ngan xa tesilasil ni xouk imei visaluk e ihiteni ihit, ‘Tua, amei nesao e von totanen xa bos inggak.’ Ti, moletin te nim ak isa merereen minuk pe met moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vengan ngan xil xa di lapol ni nenemien nae be nesao, Hi ipol ni xil lihe tan. E ngan xil xa di lapol ni nenemien nae be tan, Hi ipet rat hisexil ihe nesao.” ");
INSERT INTO tvk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Di, Iesu biteni mi moletin xa tesilasil ni bit, “Xosxa opol ni anien tei, onasilasil ni ti tua nam xil, mu vatimol nam xil, mu ngan xil xa holesok nae holu e ladit sangas visaluk. Vengan xa xil lakila lasilasil ni xouk mun, e uhur rilomun ni naha xa otepol ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E‑e. Melele xa opol ni anien tei, ihos mak mu xa usilasil ni hoeo xil, moletin xil xa lasakras lakakao, ngan xil xa rut tenbexil mat, e ngan xil xa metexil bar. ");
INSERT INTO tvk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Vengan xa xil lasakras lasa xoles neta xa otepol ni mi xil. Imak, ma Hi ituxol xatuk e isa rilomun ni huite teni minuk e melengien xa ngan xil xa lamal pe met Hi limea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Melele xa moletin tei xa de anien ak milong sepinien na Iesu, biteni mini bit, “!Sien iti mi ngan xil xa lianien vituei e anien xa mahulong na Hi e melele xa isak ni lelaxatien nan mei istal e ut etan!” ");
INSERT INTO tvk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Melele xa Iesu milong sepinien na Farasi ak, dei vole ak mini bit, “Vatei, eilep tei bit vapol ni anien tei xa eilep. Ma misilasil ba mi moletin xil holu. ");
INSERT INTO tvk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Di, momal e melengien xati te anien ak, xi misil eloheoh nan tengan vaha vahit mesen ni mi moletin xil xa tesilasil ni xil vahit, ‘Mumei, holesok xil te anien ak mese tuei.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“E xil vus lasin ni tengan lamei en vengan lanemi labit holesok sav xil be eilep mak mu mili anien ak. Tei e xil bit, ‘Inou natexal tan tei e niha mu nisao ni. Ve rin ak, nasakras namat.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Tei mun bit, ‘Inou natexal buluk te polien he xalu (10) tengan lilihi aean xa itei tan savan, e nabit nama mu nasak pis xil. Ve rin ak, nasakras namat.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Tei mun bit, ‘Inou nateli rohon tang. Ve rin ak, nasakras namat.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Misak ni, eloheoh ak dilomun ba bit mesen sepinien xil ak mi eilep nan. E melele xa milonge, eilep ak ien mikat pupu, e biteni mi eloheoh nan bit, ‘!Utemanon, uhe suse xil te metimal ak! Ha uleh hoeo xil, moletin xil xa lasakras lakakao, ngan xil xa metexil bar, e ngan xil xa rut tenbexil mat.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Tavehi ti, eloheoh dilomun e biteni mini bit, ‘Suv, napol sen holesok xil xa otesemae ni, e ut pipin ni moletin xil holu tamu.’ ");
INSERT INTO tvk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ma eilep biteni mini bit, ‘Ha uhe ut xil ngasen e suse xil vus e ukes moletin xil limei, tengan isak ni nim mavan ipolu kuhi ni moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","!E nabiteni minuk, tovuol e ngan xil xa natesilasil ni xil tetiamu likar pis ti anien ak!’” Melele xa Iesu ngganien bus, be reling nim ma Farasi ak ba. ");
INSERT INTO tvk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E melele xa Iesu di mikakao mikapis e metimal xil, vanut moletin xil holu di langgusili. Vatei, Iesu biles e biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Xosxa moletin tei bit vahusil nou, eheien nan e nou ili eheien xa di e tamen, ninen, atou nan, horamue nan xil, tuneli e hineli xil, e xi mun tang. Xosxa namak ti, ma xi misakras vahe moletin navan. ");
INSERT INTO tvk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngan xil xa iexil ti tavei tengan lapo eivave te maten nae e lavusil xat nou, xil lasakras mei lave moletin navan xil. ");
INSERT INTO tvk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Xosxa tei e xamim di minemi bit vahil nim tei xa mahulong, itotan mu e inem usili xa mani te nim ituxol mani eah. Ti, ipusi xa mani nan pipin mu tapin ti tengan ipol vuol ni nim ak. ");
INSERT INTO tvk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Maxani, ipol ni rute tang e napol vuol ni ti. Xosxa imak, ma moletin xil vus xa lipusi, lisepsisili lihit, ");
INSERT INTO tvk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘!Xi miling hen e polien te nim man, e misakras vapol vuol ni!’ ");
INSERT INTO tvk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nggusil nenemien ak, sexien ak nggoni suv toto tei xa mileh viton moletin xil taosen he xalu (10,000) tengan ha lavae vatel suv toto sav tei xa di bemei del moletin nan xil xa labe taosen hanutap tei (20,000). Itiamu, xi itotan e inem kuhi xa xi nggur xeihen pipin tengan vavae vatel suv toto ak e moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","E xosxa pus kila xa tahur ti xeihen vapin, ma isil ti eloheoh nan xil liha lipus suv toto sav ak melele xa xi da tamu sotin tengan lisep ves suse tova te tomat. ");
INSERT INTO tvk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ma, e hisit sexien ak, xamim vus munem kuhi mu. Xosxa xouk tasom osakras oling holesok nam xil vus, ma osakras mei ove moletin navan.” ");
INSERT INTO tvk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","E Iesu misel xat vanut moletin xil bit, “Xamim munggoni sol. Sol bos. ?E xosxa xa kekasen teni be relingi, ma likila liling rilomun ni itep? ");
INSERT INTO tvk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol ak tavos ni ti tova, e vahos mak mu vahit laso ni vaha. !Xosxa vurangemim di, ma muteong kuhi!” ");
INSERT INTO tvk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vatei, moletin te takis xil del moletin tesa sav xil mun lamei visal Iesu tengan lateong ni pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","E melele xa Farasi xil del titsa xil te rae na Mosis lapusi, di laseputut ni labit, “Moletin ak di nggur pilei moletin tesa xil e di mingganien vituei mun del xil.” ");
INSERT INTO tvk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma Iesu dei vole ak mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“?Xosxa tei e xamim, sipsip san xil labe handred tei (100) e tei e xil mikesae, ma xi ipol ni itep? Iling ngan tesav xil liti e valkesao lia husmunae e ha ilang ni ngan xa mikesae iha vuma … ikameti. ");
INSERT INTO tvk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","E melele xa ikameti, ihesi xi ihe holu xa ihe holu pupu, ipoe ite vatuvun, e itilomun ihe tim. ");
INSERT INTO tvk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","E melele xa ituxoh tim san, ikes viton tuneli xil e ngan xil xa ladi sangas visali, e ihiteni mi xil ihit, ‘!Rihesi xir vengan xa nakamet sipsip savan xa tekesae!’ ");
INSERT INTO tvk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nabiteni mi xamim, ngan xil te ut nesao di labesi xil mak mu melele xa moletin tei takes xa mikesae e tesaen biles meulien nan tengan ihusil Hi, ili moletin xil holu xa labit lamal ngamu pe meten, ma labit linaviles ti.” ");
INSERT INTO tvk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","E Iesu dei vole tei mun bit, “?Xosxa atou tei miling kuh mani nan xa be he xalu (10) di, e pusi xa tei e xil mikesae, ma ipol ni itep? Isahan laet, itaveas e nim, e ilang kuhi ni mani xa mikesae e ut xil vus iha vuma … ikameti. ");
INSERT INTO tvk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E melele xa mikameti, ikes viton timue nan xil e ngan xil xa ladi sangas visali e ihiteni mi xil ihit, ‘!Rihesi xir vengan xa nakamet mani navan xa tekesae!’ ");
INSERT INTO tvk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nabiteni mi xamim, masxaxa xil na Hi labesi xil mak mu melele xa moletin tei xa mikesae e tesaen biles meulien nan tengan ihusil Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu dei vole teimun bit, “E rute tei, tiramue tei da del natneli lu. ");
INSERT INTO tvk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Vatei, ngan xa be tasite mei biteni mi tamen bit, ‘Tata, ha useti holesok nam xil xa ihe namel. Ti, usa navan taxeak.’ Ma tamealu miseti holesok nan xil mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Melengien vahis mitavi, e natneli xa be tasite pos vuol ni tan nan e holesok sav nan xil, nggur xat mani teni, e be reling tim sa tamen ba. Di, be rute tei xa be sotin e purun sen mani nan e sexien xil te suse. ");
INSERT INTO tvk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","E melele xa horamue ak tepos vuol ni mani nan xil bus, rute xa da en, us tamus ti e anien tovuol. Misak ni, mae kekaten bemei e horamue ak mei be hoeo vari. ");
INSERT INTO tvk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Misak ni, ba pol mi moletin tei te rute ak xa misila tengan vati vatel vueili san xil e vahangan xil. ");
INSERT INTO tvk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","E melele xa di bangan xil mak, ien bei tengan vaa ti anien a vueili xil ak, e moletin tovuol xa mei vasa anien mini vahe an. ");
INSERT INTO tvk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Di, vatei, minem kila sung e biteni mi xi tasen bit, ‘Moletin te polien xil vus na tata nava, anien ae holu. E inou, navehi ti, mae ikar vin nou inggak. ");
INSERT INTO tvk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nimea, niha mun nipus tata nava, E melele xa nipusi nihiteni mini nihit, “Tata, napol misa li pe met Hi e pe metom. ");
INSERT INTO tvk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Natapin ti mun tengan okes nou ni natumali. Upol ni minou ixoni ngan xa nabe moletin te polien tei nam.”’ ");
INSERT INTO tvk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma mea, e nggur suse tengan itilomun ihe tim sa tamen. “E melele xa di tamu sotin vuteili ra tim, tamen pusi. Melele xa tamen pusi de suse, ien misae en, e mitamea miloh be visali. Melele xa duxoli, miso hen nggaxol natneli e pesum ni vin. ");
INSERT INTO tvk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","E natneli biteni mini bit, ‘Tata, napol misa li pe met Hi e pe metom. Natapin ti mun tengan okes nou ni natumali.’ ");
INSERT INTO tvk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tasepin ti mu vavus, e tamen di mikes moletin te polien nan xil lamei e biteni mi xil bit, ‘!Mutemanon! Muleh eising xil xa bos vamei mei musing xole ni. Muling ring e vakuhen tengan vapisen ni xa xi be natuxoli. E musa sandel ihesi tengan vapisen ni xa tave hoeo ti mun. ");
INSERT INTO tvk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","!Ti, muhas sulut buluk tova xa mikaio kuhi tengan ripol ni anien tei xa mahulong, vengan xa rabesi xir holu xa holu pupu xosali! ");
INSERT INTO tvk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Rabesi xir vengan xa natuxoli temat, e xosali, nggoni ngan xa meul rilomun. Reitin, xi tekesae, e taxeak, rakameti mun.’ Ma xil langganien, lakikei, e labol del sien. ");
INSERT INTO tvk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Melele xa holesok xil ak di mistal, horamue xa be muimol nan tete naho. E melele xa dilomun bemei sangas visal tim, milonge xa moletin xil di lakikei e di labol. ");
INSERT INTO tvk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma mikes moletin te polien tei bemei visali, e misisi bit, ‘?Naha xiak?’ ");
INSERT INTO tvk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“E xi bit rilomun ni mini bit, ‘Tumali dilomun bemei tim e tamom bas sulut buluk tei xa mikaio kuhi vengan pusi xa natneli meul tang da e bemei mun mi xir.’ ");
INSERT INTO tvk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“E melele xa muimol ak milonge mak, ien mikat, e bit nave ti nim. Ma tamen mistal be hale e dakesi tengan vahe nim vatel xil. ");
INSERT INTO tvk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","E muimol misa sepinien ba mi tamen bit, ‘!Uteong ni nou! !Huram holu ngamu di napol minuk nggoni ngan xa nabe moletin te polien nam tang! !Inou natateong ras ni ti raem! ?E naha tova iaxa otesa ni minou ven? !Neta tovuol! Otasa pas nani tova minou tengan nipol ni anien tova itel timue navan xil. ");
INSERT INTO tvk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","!E melele xa natumali xai bemei mistal mun e tim, ngan xa tepurun sen holesok nam xil e hoeaso xil, omea obas sulut buluk xa mikaio kuhi ven!’ ");
INSERT INTO tvk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“E tamen bit rilomun ni mini bit, ‘Natuxoli, vehakut xouk oda visal nou, e holesok xil vus navan be nam. ");
INSERT INTO tvk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","E momal tang tengan ripol ni anien ak, e rihesi xir holu ven. Vengan xa tumali temat, e taxeak, di meul mun. Reitin, xi tekesae, e taxeak, rakameti mun.’” ");
INSERT INTO tvk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Melele xa Iesu di tamu e suse tengan vahe Serusalem, dei vole ak mi moletin nan xil bit, “Vatei, eilep tei da xa pol ni bisnis tei, e xi teling moletin te polien nan tei tengan vahe vat te bisnis ak. Vat ak pol ba vuma … eilep nan nggur longeongen bit vat nan di purun holesok nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma mikes vat ak bemei visali e biteni mini bit, ‘?Naha iaxa di nalonge usiluk xiak? Uha utis usil polien xil vus xa di otepol ni e rin navan, vengan xa, navehi ti, niso ratuk ra polien ak.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Melele xa vat ak milonge mak, misep tasen bit, ‘Suv navan vaso rat nou ra polien navan xiak. ?Xosxa imak, ma nipol ni naha vari? Veok taxeih ti vapin tengan nata len tan, e nabe unoun pupu tengan naram ni moletin xil ve mani. ");
INSERT INTO tvk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","!Aha! Nakila naha xa nipol ni. Xosxa nipol ni imak, ma melele xa nivus ra polien ak, timue navan xil liti e lihur pilei nou e tim sae xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ma vat ak mikes kekes ni moletin xil xa kaon nae di del suv nan. Ngan xa bemei diamu, vat ak misisi bit, ‘?Kaon nam be naha del suv navan?’ ");
INSERT INTO tvk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“E moletin ak bit rilomun ni mini bit, ‘Nateleh tiram oel te olip tehe handred tei (100).’ “Ma vat biteni mini bit, ‘Utemanon, uhur uvei nam, e utei kaon nen imei etan ituxoh tiram oel hanutap lu e he xalu mun (50) kestang.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Di, mikes ngan tesav bemei e misisi bit, ‘?E xouk, kaon nam be naha?’ “E xi bit rilomun ni bit, ‘Nateleh bak pulaoa tehe taosen tei (1000).’ “E vat biteni mini bit, ‘Uhur uvei nam e utei kaon nam imei etan ituxoh bak handred tol e he sav (800) kestang.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Melele xa suv na vat ak milonge xa pol ni vatin mak, suv ak mei biteni mini bit, ‘Tave ti neta xa otepol ni vatum temak, sexien nam di pisen metisouen nam vengan xa di onem usil melele xa ti imei e melele xa niso ratuk ra polien ak.’” Di, Iesu bit kil koute te vole ak mi moletin xil bit, “Nabiteni mak vengan xa moletin xil te ut etan di lapol ni vatixil melele xa lapol del tua nae xil tengan linem ihos mi xil e melele xa ladi tamu e ut etan. E sexien nae bos mak mu mili sexien na ngan xil xa ladi e miehen. ");
INSERT INTO tvk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","E nabiteni mi xamim, mani namim misakras vata vahehi. Ma muleh moletin sav xil mei lihe timue namim xil e mututou ni xil itel holesok namim xil te ut etan ak. Vengan xa melele xa mustokovein holesok namim xil te ut etan, timue namim xil lihur pilei xamim e rute xa ita vehakut e ut nesao. ");
INSERT INTO tvk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Moletin xa di milaxat kuh neta tei xa hokorong, xi mikila valaxat kuh neta tei xa mahulong. E moletin tei xa di purun neta tei xa hokorong, xi mikila mun vapurun neta tei xa eilep. ");
INSERT INTO tvk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ve rin ak, xosxa otepol ni sexien xil xa tepisen ni xa moletin xil lasakras lanesi e xouk vatel holesok nae xil te ut etan, ma Hi mun misakras vanesi e xouk vatel holesok hos nan xil xa be eilep mak mu mili. ");
INSERT INTO tvk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E xosxa mutalaxat kuh holesok xil ti te ut etan xa Hi di milingi e hemim, ma misakras vasa ti mun neta mi xamim e ut nesao. ");
INSERT INTO tvk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Moletin te polien tei misakras vapol mi suv lu. Maxani, ien iat tei, e eheien nan iti e tei xalu. Mu ilong xat tei, e iketeh isa ni tei xalu. Osakras omot mi Hi e mi mani mun.” ");
INSERT INTO tvk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Melele xa Farasi xil lalong sepinien xil ak, lasep pepamen ni Iesu, vengan xa eheien nae di e mani holu. ");
INSERT INTO tvk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E Iesu biteni mi Farasi xil bit, “Xamim iaxa di mupol nggeih tengan vasak ni mosav xil lanem labit xamim mumal tevi, e Hi mikil nenemien namim. Vengan xa holesok xil xa moletin xil di lanemi labit bos, ngan ak pupuru pupu pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tetiamu, rae xil na Mosis e tisen na provet xil latepisen suse na Hi mi moletin xil ba duxoh melele xa Sion temei e di tebaptaes ni moletin xil. E xosali iha, di labithiten longeongen hos usil suse xa Hi mei be suv toto te meulien na moletin xil. Longeongen hos ak di mikapis e ut xil ngasen, e moletin xil holu di lakal tengan lasak ni Hi mei vahe suv toto te meulien nae. ");
INSERT INTO tvk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Neta sav xos ut nesao e ut etan lalivus e melengien tei xa ti imei, e mavulut sepinien xil vus te rae xil na Hi, xeihen teni misakras vavus vatova. ");
INSERT INTO tvk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ve rin ak, tiramue xa mistokovein atou nan e nggur atou sav di pol ni tesaen dela. E tiramue xa miteli del atou xa testokovein tiramue nan, xi mun di pol ni tesaen dela.” ");
INSERT INTO tvk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesu mitumul mi moletin xil bit, “Vatei, moletin tei da xa holesok nan holu. Xi mising ni eising xil xa bos e mani nan be holu, ma mikila vaxal holesok xil ngasen xa ien bei. E meulien nan, xi milonge bos vehakut. ");
INSERT INTO tvk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","E sangas visal puiteh te vioh xa di mikapis xol nim man, hoeo tei di pat, hisen Lasaros. Holesok nan tovuol, misakras vakakao, e tenben be menuk xil kestang. ");
INSERT INTO tvk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","E melele xa dat mak, kuli xil lamei di lamun menuk nan xil. E Lasaros ien bei pupu ni tengan vaa saxut anien xa moletin xa holesok nan holu di miso ni ba. ");
INSERT INTO tvk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ludi mak ba vuma … hoeo ak mat, e masxaxa xil langguri ba lalingi dotan vituei del avu Ebraham e anien xa mahulong e ut nesao. Tave nousav ti, moletin xa holesok nan holu mun mat, e ladihin ni. ");
INSERT INTO tvk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","E moletin ak ba de ut sa Temat, e milong pangas xi pupu. E melele xa miketeh be sotin, pus avu Ebraham nesao, e Lasaros dotan de rin. ");
INSERT INTO tvk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Misak ni, xi mikei be nesao bit, ‘!Avu Ebraham, iem isae li e nou! Usil Lasaros imei tengan isa rut oei nimu ni tengan vasak ni meok vamerir timoli. Vengan xa nalong pangas nou pupu e upang ak.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“E Ebraham biteni mini bit, ‘Natuxoli, unem pisi mu. E meulien nam tetiamu, xouk otepus kuh hosien vehakut, e Lasaros tepus longpangasien kestang. E taxeak, xi sung di pus hosien inggak, e xouk, di olong pangasuk inggaxai. ");
INSERT INTO tvk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E teimun, poal tei xa mahulong da xoteh xouk ra xamel xa be tan xa be tan e hoxalite teni tovuol. Misak ni xamel malsakras malihur xotehi malihat visal xouk. E xouk e ngan xil mun xa ladi delak musakras mumei visal xamel.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma moletin xa holesok nan tehe holu biteni mini bit, ‘O avu Ebraham, imak ma nadakesuk li tengan usil Lasaros ihe tim sa tata navan. ");
INSERT INTO tvk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vengan xa e rute ak, tuxoli lim (5) ladi en. Umaen ni Lasaros ha isel xat xil tengan xil sung linamei ti e ut te longpangasien ak.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“E Ebraham bit rilomun ni mini bit, ‘Rae xil na Mosis del sepinien na provet xil tetiamu di ngamu xa di misel xat vatimol nam xil. Momal tengan ti lilong xat sepinien xil ak.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“E moletin ak bit rilomun ni mini bit, ‘!E‑e! !Avu Ebraham, ngan ak tapin ti mu! E vahit moletin tova vamea rilomun ra maten e vahe visal xil, ma xil lipus kila sung, e lihiles meulien nae ra sexien tesa nae xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“E Ebraham misa sepinien kor mini bit, ‘Xosxa xil latalong xat ti rae xil na Mosis e sepinien na provet xil, ma lasakras lalong xat sepinien na moletin tei xa mea rilomun ra maten.’” ");
INSERT INTO tvk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu biteni mi moletin nan xil bit, “Be reitin xa sexien xil xa ipol ni moletin imot e tesaen ti imei. !E isa pupu mi moletin xa be suse te tesaen xil ak xa bemei e mosav xil! ");
INSERT INTO tvk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vengan xa pangasien xa Hi isa ni mi ngan xil xa di lapol ni moletin tei xa taxeih ti e neketen nan mot e tesaen isa xa isa pupu. Reitin, pangasien xa isa ni mi xil ili longpangasien na moletin tei xa labar xat hat tei xa mahulong de hiraen e laterir ni be huinep te tas. ");
INSERT INTO tvk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","!Ma muxuxou kuhi xa munapol ni tuemim xil ti e neketen linamot e tesaen! “Xosxa tumali e neketen di pol ni tesaen tei ba minuk, umal ni. E xosxa xi biles meulien nan ra tesaen ak, ma uketeh ihos rilomun mini. ");
INSERT INTO tvk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","E neta sav xos tumali ak pol ni tesaen ba minuk be valu e he sav (7) e melengien tei, e, e melele xil ngasen, xi bemei visaluk e biteni minuk bit, ‘Napol misa pupu li minuk e ninapol ni ti mun vari namak,’ xa momal xa uketeh ihos rilomun mini.” ");
INSERT INTO tvk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Melele xa moletin nan xil lalonge mak lasis Iesu labit, “O Suv li, upol ni neketen namem mei ixeih mu.” ");
INSERT INTO tvk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma xi biteni mi xil bit, “Reitin xa neketen namim hokorong pupu. Vengan xa xosxa neketen namim hokorong nggoni tutut utiei tei, ma mukila mupol ni merekel xil ixoni ngan xa muhiteni mi vatiei xa mahulong xiak muhit, ‘!Put ratuk ra tan ak, e ha, ulih xouk tasom ute tas inggaxor!’ e xi ilong xat rae namim.” ");
INSERT INTO tvk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Iesu biteni mun mi moletin nan xil bit, “Xamim mukil sexien na masta tei ngamu xa di misil slev nan tengan ha vapol e naho nan mu valaxat sipsip san xil. Melele xa slev nan pol bus, masta nan misakras vahiteni mini vahit, ‘!Amei, utotan kuhi e uanien!’ ");
INSERT INTO tvk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","!E‑e, sexien na masta tei tamak ti! Xi ihiteni mi slev nan imak ihit, ‘Ha usak mesen anien avan mu. Ti, using xoles eising nam e uleh anien avan imei. Utatil nou mu nianien. Ti, xouk sung okila uanien.’ ");
INSERT INTO tvk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","?E midep? ?Masta ak imes slev nan vengan xa di nggusil naha xa di misemae ni mini? E‑e, misakras. ");
INSERT INTO tvk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","E hisit sexien ak, melele xa mupol sen polien xil xa Hi biteni mi xamim tengan mupol ni, momal tengan muhiteni tang muhit, ‘Xamem mabe slev nan xil kestang, e di mapol nggusil naha xa Hi di misa ni mi xamem tengan mapol ni.’” ");
INSERT INTO tvk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Melele xa Iesu del moletin nan xil di langgusil suse tengan lave taon te hal Serusalem, xil langgo provins te hal Kaleli e langgur xoteh provins te hal Sameria laba. ");
INSERT INTO tvk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Melele xa xil lakakao labe metimal tei, labisu ni moletin he xalu (10) e suse xa mesien leporsi di bas purun tenbexil. Melele xa lapus Iesu, dit lasoh sotin ");
INSERT INTO tvk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","e lakei ba ni labit, “!Suv Iesu! !Iem isae li e xamem!” ");
INSERT INTO tvk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu miketeh ba e biteni mi xil bit, “Muha, mupisen xamim mi pris xil tengan lilepis kuh tenbemim.” E melele xa moletin xil ak langgusil suse nae laba, tenbexil mei memese rilomun ra mesien nae. ");
INSERT INTO tvk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Melele xa tei e xil pus kila xa tenben mei memese rilomun, xi dilomun bemei visal Iesu, e mikei be nesao ni memesien xil ba mi Hi. ");
INSERT INTO tvk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Moletin ak mitingeiril pe met Iesu e misa memesien nan mini. E moletin ak tave ngan Siu ti, be ngan Sameria. ");
INSERT INTO tvk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","E Iesu misis moletin nan xil bit, “Moletin he xalu (10) iaxa tenbexil temei temese rilomun. ?Ngan tesav xil xa labe hat e he sav (9) ladi xave? ");
INSERT INTO tvk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Moletin ak tave Siu ti. ?Veneh ma xi kestang dilomun bemei tengan vasa memesien nan mi Hi?” ");
INSERT INTO tvk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Misak ni, Iesu biteni mi moletin ak bit, “Umea e uhusil suse nam uha. Neketen nam iaxa tesak ni tenbom mei memese.” ");
INSERT INTO tvk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Vatei, rut Farasi xil mei lasis Iesu labit, “?Hi mei ihe suv toto na moletin xil vilieh?” E Iesu bit rilomun ni mi xil bit, “Lelaxatien na Hi namei ti naxo suse xa moletin xil lakila lipusi ni metexil. ");
INSERT INTO tvk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Moletin ti misakras vahiteni vahit, ‘!Pus ti mu, xi tak!’ mu ‘!Iaxa da inggaxor!’ vengan xa lelaxatien na Hi di mi xamim ngamu, e tine ngan xil xa xi be suv toto te meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Di, Iesu biteni mi moletin nan xil bit, “Melele te xeih xil ti imei, e inou ninara ti mun visal xamim. E melengien xil ak, iemim ti ihei tengan Nat Moletin imei isak ni xamim mei muti e hosien itela, tave ti neta xos ihe te melengien tei takes. E nastal ti e melengien xil ak ti. ");
INSERT INTO tvk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","E mulong moletin xil lihit, ‘!Mupus ti mu Nat Moletin iaxor!’ mu ‘!Xi tak!’ E munaha ti e munahusil xil ti. ");
INSERT INTO tvk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nabiteni mak mi xamim, melengien xa Nat Moletin imei rilomun en moletin xil vus lipus kila e litemanin ni ixoni melele xa lapus an milangas e miehen teni nggur vuol ni tilang hat nggo rin tei ba duxoh rin sav mun. ");
INSERT INTO tvk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","E itiamu, xi ilong pangas pupu ni xi, e moletin xil te xosali ak lisin ni. ");
INSERT INTO tvk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Melengien xil na Nat Moletin mei istal ixoni melengien xil na Noah tetiamu xa moletin xil latnavue xat xil ti. ");
INSERT INTO tvk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E melele nen ak, moletin xil ngasen di lateanien, di latemun, e di lateteli teha tetuxoh melengien xa Noah tehe tuturil nan xa mahulong. Latetemanin, e oei teleh xol rute xil vus e moletin xil vus latmerir. ");
INSERT INTO tvk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Melengien xil na Lot mun temak tang. Moletin xil ngasen di lateanien e di latemun, rute xil di latepos ni neta e rute sav xil mei latexale, di latepol ni naho e di latekili ni nim xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","E melele xa Lot temea tehe reling moletin xil te hal Sodom, upang e hatupang xil texo ut nesao temei e tan e tehas lelen moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","E melengien xa Nat Moletin mei istal en ixoni melele xalu ak xa moletin xil latetemanin ni. ");
INSERT INTO tvk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“E melengien nen ak, xosxa moletin tova di mingel e hale, mesal ihe tovuol tengan vatilomun vahe nim e vahur neta tova nan. E xosxa moletin tei di pol e naho, xi nava ti mun tim tengan vahur neta tova ra tim san. ");
INSERT INTO tvk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Munem usil longpangasien xa testal e meulien na atou na Lot. ");
INSERT INTO tvk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ngan xil xa lasak pisi tengan likenin meulien nae ve xil tang, ma meulien nae ikesae ra xil. E ngan xil xa limaen meulien nae ikesae, ma xil iaxa likamet meulien sal. ");
INSERT INTO tvk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nabiteni mi xamim, e melele nen ak, tiramue xal atou nan lalipat e rong tei takes, e Hi ihur rat tei xalu ihe visali e ut nesao, e teimun isin ni e ilingi ita. ");
INSERT INTO tvk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Atou lu ti lalipol ni anien e ut tei takes, e Hi ihur rat tei xalu ihe visali e ut nesao, e teimun isin ni e ilingi ita.” ");
INSERT INTO tvk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sepinien nan misak ni moletin nan xil lasisi labit, “?Suv, Nat Moletin imei rilomun e rute xave?” Ma Iesu bit rilomun ni mi xil bit, “Moletin xil vus lipus kil rute xa Nat Moletin itilomun imei en vengan xa imei itel pangasien holu. Reitin, lipus kila ixo hisit sexien xa di lapus kil rute xa neta tei mat da en e melele xa lapus vanut angelu xil ladi e ut tei.” ");
INSERT INTO tvk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Di, Iesu dei vole tei mi moletin nan xil tengan vapispisi mi xil xa ti lisis vehakut e linamaen nenemien nae ti namot. ");
INSERT INTO tvk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xi biteni mi xil bit, “E metimal tei, moletin te lepisien tei da, xa di tamerere ni Hi mu moletin sav xil ti. ");
INSERT INTO tvk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","E metimal ak, tunau tei da xa vehakut ba pus moletin te lepisien tengan vatakesi vahit, ‘Moletin tei di pol tavos ti minou. !Umea, ulepis rin namel e upol ni naha xa momal e rin navan!’ ");
INSERT INTO tvk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“E melengien xil vus, tunau ak dakesi dakesi dakesi ba vuma … moletin te lepisien ak pol ni naha xa misisi ven. Vengan minemi bit, ‘Tave ti neta xa natamerere ni Hi mu moletin xil ti, ");
INSERT INTO tvk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","e vengan xa tunau ak dit dakes nou ve tutouen vehakut mak, bos xa nipol ni naha xa momal e rin nan. Vengan xa xosxa ninapol ni ti, ma xi ixulehi imei vehakut e mei nitalang.’” ");
INSERT INTO tvk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Di, Iesu bit kil koute te vole ak mi moletin xil bit, “Neta sav xa sexien na moletin te lepisien ak tamal ti, mulonge xa biteni xa ipol ni naha xa momal e rin na tunau ak. ");
INSERT INTO tvk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Ma munemi midep e rin te sexien na Hi? ?Munemi mubit Hi xa momal mak mu mili moletin ak misakras valepis rin na moletin nan xil ixo sexien xa momal? ?Munemi mubit napol ni ti naha xa momal e rin na ngan xil xa tekes xil labe nan, xa di ladakesi ve tutouen melengien e vongien? ");
INSERT INTO tvk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Reitin li nabiteni mi xamim, Hi itemanon ilepis rin nae ihusil sexien xa momal e ipol ni ihos mi xil. ?E melele xa Nat Moletin imei rilomun mi moletin xil te ut etan, munemi mubit ikameti xa neketen nae nggeih en, mu nakameti ti?” ");
INSERT INTO tvk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E melele nen ak, rut moletin xil ladi inggak xa lanemi labit lamal ngamu pe met Hi ve polien hos nae xil. E lanem male ni mosav xil. Ma Iesu dei vole ak mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Vatei, moletin lu lube vioh te Nim Eo na Hi tengan lalisis. Tei xalu be Farasi, e teimun be moletin te takis. ");
INSERT INTO tvk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngan xa be Farasi mikakao bemei sangas visal puiteh te Nim Eo e misoh misis bit, ‘Hi, namesuk vengan xa inou nataxoni mosav xil ti xa di labe hokan, xa di lapol ni tesaen ba xat mosav xil, e xa di laleh atou na mosav xil. Namesuk mun vengan xa inou nataxoni moletin te takis ti xa da iaxor. ");
INSERT INTO tvk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Vengan xa inou di nabal ni anien ve sisen melengien lu e wik tei, e di nasa taet te holesok navan xil minuk.’ ");
INSERT INTO tvk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“E moletin te takis misoh de sotin vuteili ra Nim Eo e tapet rat vatin ti vahe nesao vengan xa bit napin ti tengan vaketeh vahe ut nesao. Melele xa minem usil meulien tesa nan, simeten mereh e misis bit, ‘!O Hi, iem isae li e nou! !Nabe moletin tesa tang!’” ");
INSERT INTO tvk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma Iesu biteni mi xil bit, “Nabiteni mi xamim, melele xa lusis bus e ludilomun lube tim salu, moletin te takis iaxa momal pe met Hi, e tave Farasi ti. Vengan xa moletin xil xa di lapet rat xil labe nesao, Hi ipol ni xil lihe tan. E ngan xil xa di laling nenemien nae be tan, Hi ipet rat xil lihe nesao.” ");
INSERT INTO tvk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","E melele nen ak, rut moletin xil di laleh tutut horamue nae xil labe visal Iesu tengan valing hen e xil e vasa tuxolxatien nan mi xil. E melele xa moletin nan xil lapus naha xa moletin xil di lapol ni, lasikoe xol xil e labul xat xil ven. ");
INSERT INTO tvk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","E Iesu mikes tutut horamue xil ak lamei visali e biteni mi moletin nan xil bit, “Munasikoe xol xil ti. Mumaen xil tang tengan limei visal nou. Vengan xa Hi be suv toto e meulien na hisit moletin xil xa langgoni tutut horamue xil ak. ");
INSERT INTO tvk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Reitin li nabiteni mi xamim, moletin xil xa lasakras laling nenemien nae vahe tan vaxoni tutut horamue tei, lasakras lavur tuxolxatien te lelaxatien na Hi e meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","E melele nen ak, vat tei na Siu xil bemei visal Iesu e misisi bit, “Titsa, xouk obos li mak. ?Nipol ni naha tengan nihur meulien sal?” ");
INSERT INTO tvk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","E Iesu misis rilomun ni ba mini bit, “?Veneh ma obit nabos? Moletin ti tavos, Hi kestang bos. ");
INSERT INTO tvk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xouk okil rae xil na Hi ngamu, ‘Munakan ni atou mu tiramue na mosav ti. Munahas vin ti moletin. Munakan ni ti neta. Munaluvos ni his mosav xil ti. Mumerere ni tamemim e ninemim xil.’” ");
INSERT INTO tvk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Vat ak bit rilomun ni mini bit, “E melele xa natehe horamue mei duxoh xosali natahur xoteh ti rae xil ak.” ");
INSERT INTO tvk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Melele xa Iesu milonge mak, biteni mini bit, “Neta tei mun otapol ni ti mu. Upos vuol ni holesok nam xil e useti mani teni mi hoeo xil. Imak, ma e ut nesao, holesok nam xil imei ihe holu mu. Ivus, ti umei uhusil nou.” ");
INSERT INTO tvk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","E melele xa vat ak milong sepinien na Iesu, xi milonge misa vengan xa holesok nan holu pupu. ");
INSERT INTO tvk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Melele xa Iesu pusi xa vat ak milonge misa biteni mi moletin xil bit, “Nggeih pupu mi ngan xil xa holesok nae holu tengan lamaen Hi vamei vahe suv toto te meulien nae. ");
INSERT INTO tvk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Minggeih pupu tengan kamel tei vakital vaxo vulut nitil tei. E minggeih mak mu mili mi moletin tei xa holesok nan holu tengan Hi vamei vahe suv toto te meulien nan.” ");
INSERT INTO tvk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngan xil xa lalong sepinien na Iesu lasisi labit, “?Imak, ma visi vari ikila ihur meulien sal?” ");
INSERT INTO tvk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Iesu bit rilomun ni mi xil bit, “Reitin xa moletin xil lasakras lapol ni neta tova tengan vasak ni xil lavur meulien sal. E Hi mikila vahiteni xa visi iaxa ihur meulien sal.” ");
INSERT INTO tvk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Di, Pita biteni mini bit, “?E midep e xamem? Matestokovein holesok xil namem e mei manggusil xatuk.” ");
INSERT INTO tvk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","E Iesu biteni mi moletin xil bit, “Nakila. E reitin li nabiteni mi xamim xa Hi isa huite teni mi ngan xil vus xa lastokovein tim sae, mu atou nae, mu tua nae xil, mu tamexil, mu ninexil, mu horamue nae xil mun tengan lavusil xat Hi e lasak ni mei vahe suv toto e meulien nae. ");
INSERT INTO tvk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Reitin, Hi isa xoles neta mi xil xa ihe holu mak mu ili holesok xil ak e ut etan. E, e ut nesao mun, xil lihur meulien sal.” ");
INSERT INTO tvk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu mileh viton moletin nan xil xa labe lu e le tei (12) ba ladi se xil, e xi biteni mi xil bit, “!Muteong ni nou! Taxeak, di raba ve Serusalem. E rute ak, holesok xil vus xa provet xil tetiamu di latehit lelen ni usil Nat Moletin mei istal ihe reitin. ");
INSERT INTO tvk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Rut moletin xil limaen ni ihe he moletin xil xa latave Siu ti. E ngan xil lisep purun ni, lipol isa mini, e likusah iha xati. ");
INSERT INTO tvk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Limeas pangasi, e lihasi imat. E melengien tol nen, xi imea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","E moletin nan xil latanem kil ti holesok xil ak. Koute te sepinien nan minggus ra xil. Misak ni xil latakil ti naha xa Iesu di misep usili. ");
INSERT INTO tvk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Melele xa Iesu del ngan xil xa di langgusili lamei sangas ni taon te hal Seriko, moletin tei xa meten bar dotan de seri suse e di miram ve tutouen. ");
INSERT INTO tvk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Melele xa milong vanut moletin xil ak di lakakao lali rute xa da en, misis xil bit, “?Naha xiak?” ");
INSERT INTO tvk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","E xil labit rilomun ni mini labit, “Iesu te hal Nasaret iaxa mei mitavi ba iaxai.” ");
INSERT INTO tvk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Melele xa metevar ak milonge mak, mikei nggeih bit, “!Iesu, nat suv toto Deved! !Iem isae li e nou!” ");
INSERT INTO tvk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Melele xa biteni mak, moletin xil xa di lakakao diamu labul xati labit, “!Utat votei!” E tavei ti neta xa mak, xi mikei nggeih pilei sung bit, “!O nat suv toto Deved! !Iem isae li e nou!” ");
INSERT INTO tvk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","E melele xa Iesu milong keien nan, misoh e biteni mi moletin xil bit, “Mutel moletin xai vamei inggak.” E melele xa bemei visali, Iesu misisi bit, ");
INSERT INTO tvk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Iem bei tengan nipol ni naha minuk?” E metevar ak biteni bit, “Suv, ieok bei li tengan niketeh rilomun.” ");
INSERT INTO tvk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Iesu biteni mini bit, “!Bos, keteh rilomun! Metom xalu mei lubos rilomun nggusil neketen nam.” ");
INSERT INTO tvk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Vatakes, metevar ak mikila vaketeh rilomun. Ma misa memesien ba mi Hi e nggusil xat Iesu. Melele xa vanut moletin xil ak lapusi, xil vus lames Hi ven. ");
INSERT INTO tvk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Melele xa Iesu di tamu nggusil suse ba be Serusalem, di mika pas taon te hal Seriko. ");
INSERT INTO tvk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","E taon te hal Seriko, Siu tei xa be vat na moletin te takis xil da en. Hisen Sakias xa holesok nan xil holu. ");
INSERT INTO tvk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xi bit vapus ti xa Iesu be visi, e misakras vengan xa xi be tamure tang e vanut moletin xil xa di langgusil Iesu labe holu pupu. ");
INSERT INTO tvk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma Sakias miloh diamu ni vanut moletin xil ak, e ba peou e vatit sikamor tei tengan ipus Iesu melele xa ihusil suse mei ileli rute xa da en. ");
INSERT INTO tvk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","E melele xa Iesu bemei momal ni rute ak, miketeh be nesao e biteni mi Sakias bit, “Sakias, utemanon umei e tan, vengan xa mei nisao ni xouk e tim sam xosali.” ");
INSERT INTO tvk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Misak ni, Sakias mitemanon bemei e tan. Xi besi xi e del Iesu luba, e nggur pilei e tim san. ");
INSERT INTO tvk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Moletin xil vus xa lapusi laseputut ba xat Iesu labit, “Moletin xai ba be tim sa moletin tesa tei.” ");
INSERT INTO tvk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Melele xa Iesu e moletin sav xil ladi tamu e tim san, Sakias mitamea misoh e biteni mi Iesu bit, “!Suv, uteong ni nou! Inou nabit xati xa niseti holesok xil vus navan ihe vanute lu, e vanute tei nisa ni mi hoeo xil. E xosxa natekan ni mani na moletin tova texo polien navan xil, ma nabit xati tengan nisa xolesi mini e nisa hat (4) mun itel xati.” ");
INSERT INTO tvk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Melele xa biteni mak, Iesu biteni mini bit, “Xosali, di opisen ni xa Hi miteh meulien e xouk del ngenom xil. Reitin, xouk mun obe nat Ebraham tei vengan xa di oling neketen nam e Hi nggoni ngan xa xi tepol ni. ");
INSERT INTO tvk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nat Moletin bemei e ut etan tengan valang ni hisit moletin xil vamak xa latekesae, tengan mei vateh meulien e xil.” ");
INSERT INTO tvk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Melele xa Iesu da tamu e taon te hal Seriko, moletin xil di lanem usil naha xa mei istal e taon te hal Serusalem. Moletin xil holu lanemi xa melele xa Iesu ituxoh Serusalem, xi mei ihe suv toto e isak ni lelaxatien na Hi mei istal. ");
INSERT INTO tvk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ve rin ak, Iesu dei vole ak mi xil bit, “Vatei, eilep tei di bue xat xi tengan vastokovein kantri nan xati tengan ha vapus suv toto xa mahulong xa di milaxat kantri xil vus. Xi ba tengan suv toto xa mahulong ak isa xeihen mini tengan itilomun e mei ihe suv toto te kantri nan xati e ilaxat moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","E diamu, xi mikes viton moletin xil te polien nan xa labe he xalu (10) lamei tengan iseti mani handred taosen (100,000) mi xil kekes. Di, biteni mi xil bit, ‘Muleh mani xil ak e mupol itela ituxoh melele xa nitilomun en.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma eilep ba, e moletin xil te kantri nan xati iexil ti tavei. Misak ni, xil lasil eloheoh nae xil laba tengan lihiteni mi suv toto xa mahulong lihit, ‘Xamem iemem ti tavei moletin ak tengan vamei vahe suv toto namem.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","E tave ti neta xa iexil ti tavei, suv toto xa mahulong xa di milaxat kantri xil vus milingi be suv toto nae. Di, eilep ak dilomun be kantri nan xati tengan valaxati. “Melele taxa eilep ak dilomun nggoni suv toto, mikes moletin te polien nan xil lamei tengan vakil ti xa xil latepol ni naha tetel mani xa teseti mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ngan xa diamu bemei visali e biteni bit, ‘Suv, inou natepol tetel mani nam, ma natekamet mani xa be milian tei (1,000,000) da xat ngan xa otesa ni minou.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Suv toto ak biteni mini bit, ‘!Bos pupu! Xouk obe moletin te polien tei xa bos. E vengan xa otelaxat kuh neta xa hokorong, nilinguk tengan ti ulaxat taon he xalu (10) navan.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Teimun bemei e biteni mini bit, ‘Suv, inou natepol tetel mani nam, ma nakamet mani xa be handred taosen lim (500,000) da xat ngan xa otesa ni minou.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ma suv toto ak biteni mini bit, ‘Xouk iaxa ulaxat taon lim (5) navan.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“E moletin te polien teimun bemei e biteni bit, ‘Suv, mani nam xiak. Natepis xol kuhi ni kaliko tei e ba natesoso ni tang teta. ");
INSERT INTO tvk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Natepol ni temak vengan xa uluk tekan ni xouk. Xouk di onggur neta xa otapol ti ven, e di onggur anien xa moletin sav xil di lapol ven e naho sam xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Di, suv toto ak biteni mini bit, ‘!Xouk obe moletin te polien tei xa osa tang! !Nipol ni sepinien nam xil ak mei ihe am mun tang! Xouk okila xa inou nabe moletin te xeih, di nanggur neta xa di natapol ti ven, e di nanggur anien xa moletin sav xil di lapol ni e naho navan. ");
INSERT INTO tvk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Ve rin ak, veneh ma otaso mani navan ti vahe bangk tova? Suse ak be temale tang, e melele xa natilomun nakila navur rilomun ni mani navan xil vatel tuten mun xa vata xati.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Di, suv toto ak biteni mi ngan xil xa lasoh ladi sangas visali bit, ‘Muleh rat mani ak ra moletin xai, e musa ni mi moletin te polien navan xa nggur mani milian tei (1,000,000).’ ");
INSERT INTO tvk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“E xil labiteni mini labit, ‘!E suv toto, xi nggur mani milian tei (1,000,000) ngamu!’ ");
INSERT INTO tvk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“E xi bit rilomun ni mi xil bit, ‘Nabiteni reitin mi xamim, ngan xil xa di lapol del xat naha xa di nalingi de hexil, xil lihur huite teni ihe mahulong mak mu. E ngan xil xa di latapol ti vatel xat naha xa di naling e hexil, neta sav xos vahe hokorong tang, nileh rati ra xil.’ ");
INSERT INTO tvk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Dutou ni ngan ak, suv toto ak biteni mun mi moletin nan xil bit, ‘E taxeak, ha utel elu navan xil xa iexil ti tavei tengan mei name suv toto nae tengan limei visal nou. Ti, muhas vin xil pe metok.’” ");
INSERT INTO tvk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Melele xa Iesu dei vole ak bus, nggusil suse nan tengan vahe Serusalem del moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Melele xa Iesu bemei sangas ni metimal te hal Betfas e Betani, sangas ni Vathu te Urvatiei te Olip, xi mikes moletin nan lu (2) tengan lalitiamu laliha. ");
INSERT INTO tvk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","E biteni mi xalu bit, “Mulihe metimal xa da iaxor. E melele xa muba en, mulikamet sulut dongki tei xa lasare da, xa moletin tovuol tamu vatotan en. Mullal rati e multeli imei inggak. ");
INSERT INTO tvk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Xosxa moletin tei isis xamil xa mulal rati veneh, ma mulhiteni mini xa Suv iaxa ien bei.” ");
INSERT INTO tvk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Misak ni, xalu luba e lupus holesok xil vus momal ni naha xa Iesu tehiteni mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E melele xa di lulal rat sulut dongki ak, moletin xil xa sae lasis xalu labit, “?Veneh ma di mullal rat sulut dongki samem?” ");
INSERT INTO tvk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","E xalu lubit rilomuni mi xil lubit, “Suv iaxa ien bei.” Melele xa lalonge mak, moletin xil ak lamaen ni mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma ludel sulut dongki ak be visal Iesu. Luden kot nalu da xol mar dongki, e ludutou ni Iesu ba dotan en. ");
INSERT INTO tvk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","E melele xa xi di muloh en e di nggusil suse ba, moletin xil laden kuh eising nae xil e suse nan tengan lapisen merereen nae mini. ");
INSERT INTO tvk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","E melele xa xi bemei sangas ni Serusalem, momal ni suse xa be Vathu te Urvatiei te Olip, moletin nan xil del vanut moletin sav xil mun xa di langgusili lakei ni memesien nae mi Hi. Xil lameun be nesao ve merekel xil xa di latepusi testal. Xil labit, ");
INSERT INTO tvk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“!Tuxolxatien iti mi ngan xa di bemei e his Iahova! Xi iling tomat mi moletin xil itel Hi, e xil lipet rat hisen ihe ut nesao.” ");
INSERT INTO tvk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E melele xa rut Farasi xa ladi e vanut moletin xil ak lalong sepinien nae, labul xat Iesu labit, “!Titsa, semae ni moletin nam xil tengan litit votei!” ");
INSERT INTO tvk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E Iesu bit rilomun ni mi xil bit, “Nabiteni mi xamim, xosxa xil litit votei, ma hat xil ak sung likekei ni.” ");
INSERT INTO tvk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Melele xa Iesu bemei sangas ni Serusalem, miketeh pusi, e muis ven ");
INSERT INTO tvk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","bit, “O mol‑Serusalem xil, vahit mupus kil suse te tomat, ma mukila muvuri. E taxeak, di mule rasi. ");
INSERT INTO tvk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Reitin li, melengien tei di bemei xa elu namim xil mei livae itel xat xamim. Xil mei likapis xol taon namim e musakras mulesae ra hexil. ");
INSERT INTO tvk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xil lihu lelen holesok namim xil vus, e hat xil vus te vioh e nim namim xil linavil xat xil ti mun, vengan xa xamim mutapus kil ti melele xa Hi temei tengan vateh meulien e xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Melele xa Iesu duxoh Serusalem, be Nim Eo na Hi. E melele xa be vioh teni, pusi xa moletin xil holu di lapos ni sipsip e tuman xil holu te sanien eo e von moten. Misak ni, Iesu ien mikat pupu e minggol rerat xil ra rute ak ");
INSERT INTO tvk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","bit, “Latetis xati e Vanuvei Eo na Hi bit, ‘Nim Eo navan ihe nim te sisen.’ E xamim mupol ni sung mei be ‘nim ma vati kanen xil.’” ");
INSERT INTO tvk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dutou sung, e melengien xil vus te wik ak, Iesu dilomun be vioh te Nim Eo na Hi e di pispisi mi moletin xil en. E vat xil na pris xil, titsa xil te rae na Mosis, e vat sav ngan xil mun na Siu xil lasep ves suse tengan lavas vin Iesu vaxo en. ");
INSERT INTO tvk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","E xil lasakras vengan xa, vehakut, vanut moletin xil di langgorelisi vengan xa iexil bei mak mu tengan lateong kuhi ni sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vatei, melele xa Iesu di pispisi mi moletin xil usil longeongen hos na Hi e vioh te Nim Eo, vat xil na pris xil, titsa xil te rae na Mosis, e elda xil mun lamei visali. ");
INSERT INTO tvk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","E lasisi labit, “?Hiteni mi xamem, visi iaxa temaen xouk tengan otehol rerat moletin xil ra vioh te Nim Eo ak? ?!Visi vari maenuk tengan mei opol ni polien xil ak!?” ");
INSERT INTO tvk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E Iesu bit rilomun ni mi xil bit, “Itiamu, inou nisis pilei neta tei mi xamim. E xosxa muhit rilomun ni minou, ma inou sung nihit rilomun ni naha xa musis inou ni. ?Muhiteni minou, ");
INSERT INTO tvk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","visi iaxa temaen Sion tengan mei vabaptaes ni moletin xil, Hi mu moletin tang?” ");
INSERT INTO tvk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","E vat xil ak lasel mi xil mun tang labit, “?Rihiteni itep? Xosxa rihit, ‘Hi iaxa temaen ni,’ ma xi ihit rilomun ni mi xir ihit, ‘?E veneh ma mutake reitin ti e pispisien na Sion?’ ");
INSERT INTO tvk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","E xosxa rihit, ‘Moletin tang temaen ni,’ ma vanut moletin xil ak lihov vin xir vengan xa xil laneket xa Sion be provet tei na Hi.” ");
INSERT INTO tvk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Misak ni, xil labit rilomun ni mi Iesu labit, “Matakil ti visi iaxa temaen Sion tengan vapol ni polien nan.” ");
INSERT INTO tvk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Iesu biteni mi xil bit, “Xosxa mak, ma inou mun ninavit kil ti mi xamim xa visi iaxa di maen nou tengan napol ni polien xil ak.” ");
INSERT INTO tvk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Melele xa vat xil na Siu xil di tamu lalonge, Iesu dei vole ak mi moletin xil bit, “Vatei, moletin tei milih urvatiei tei te grep e tan san. Milihi bus, hortan ak miling urvatiei ak de he moletin sav xil tengan ti lilaxati del nenemien xa xil ti lisa rut huite teni mini melele xa lamen. Di, hortan te urvatiei ak ba be ut tei xa de sotin, e ba da en huram vahis. ");
INSERT INTO tvk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Melele xa hortan ak mikila xa melele momal tengan laleh viton huit grep xa men, misil slev nan tei ba tengan vasis ngan xil xa di lalaxat urvatiei san tengan lisa ti huite xil xa labe san xati mini. “E melele xa slev nan ba visal xil, ngan xil xa lalaxat urvatiei ak lapurun ni. Di, langgol rati ba, e latasa ni ti neta mini. ");
INSERT INTO tvk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Misak ni, hortan ak, misil slev nan teimun ba visal xil. E ngan xil xa lalaxat urvatiei san labasi mun, e lasak purun ni mili ngan xa tetiamu. Di, langgol rati ba, e latasa ni ti neta mini. ");
INSERT INTO tvk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Di, hortan ak misil slev nan xa be tol nen ba visal xil. E melele xa duxoh moletin tesa xil ak, labasi ba vuma ... sangas vamat e lakuvun rati ra urvatiei ak. ");
INSERT INTO tvk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ma hortan te urvatiei ak minemi bit, ‘?Nipol ni itep sung? !Aha, nakila! Nisil natuxoli xati xa eheien navan da en iha. Xil limerere ni xi sung.’ ");
INSERT INTO tvk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“E melele xa moletin xil xa di lalaxat urvatiei ak lapusi bemei, xil lasem xil labit, ‘?Mupus ti? Ngan ak be nat hortan xati xa urvatiei te grep ak mei ihe san. !Rihas vini vari! !Imak, ma urvatiei te grep ak ihe sar sung!’ ");
INSERT INTO tvk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ma xil laba, ladal xati, lakuvun rati ra urvatiei ak, e labasi mat.” Melele xa Iesu dei vole ak bus, miketeh pus moletin xil e misis xil bit, “?Midep? ?Hortan te urvatiei ipol ni naha mi ngan xil xa di lalaxat urvatiei san? ");
INSERT INTO tvk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nabiteni mi xamim, xi imei ihas vin xil vus. Ti, imaen urvatiei te grep san mi moletin sav xil tengan lilaxat kuhi.” E melele xa moletin xil lalonge mak, labiteni mini labit, “!Ei, Hi misakras vamaen rin ak mei vastal!” ");
INSERT INTO tvk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu miketeh pus xil e misis xil bit, “Xosxa nastal ti, ma veneh ma Vanuvei na Hi di biteni mak bit, ‘Pos xa moletin te polien xil di lasin ni, xi vari iaxa mei be seteman xati te nim e mili sen pos nen xil vus.’ ");
INSERT INTO tvk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‘!Ngan xil xa mei lasavut en imot e sixil limavul tova tang! E xosxa seteman ak imot imal e moletin tei, ma moletin ak imat vari.’” ");
INSERT INTO tvk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Melele xa titsa xil te rae na Mosis del vat xil na pris xil lalonge mak, lalong kila xa Iesu dei vole ak ba xat rin nae bit xil iaxa labe ngan xil xa di lalaxat urvatiei te grep. Misak ni, iexil bei pupu ni tengan latal xati, e ulixil mikan ni moletin xil xa di lakapis xole vehakut. ");
INSERT INTO tvk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vengan xa titsa xil te rae na Mosis del vat xil na pris xil ulixil mikan ni moletin xil, lalang ni mesal tova xa likila lital xati ixo en. Misak ni, lasil xuxus ni rut moletin nae xil tengan ha lipus Iesu e lisis pilei ni neta ixoni ngan xa labe moletin hos xil. Lanemi xa xosxa lakila lasak ni Iesu isavut e sepinien nan, lakila lalingi e he kavmen te hal Rom. ");
INSERT INTO tvk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma, moletin te luvosen xil ak lamei visal Iesu e labiteni mini labit, “Titsa, xamem makila xa naha xa di obiteni e naha xa di opispisi ni mi moletin xil momal tevi. Makila mun xa xouk di opus moletin xil ngasen lapin tang, ngan xil xa latellep del moletin votei xil mun. E xouk di opispisi mi moletin xil vus usil suse te reitinen xa Hi ien bei tengan moletin xil lihusili. ");
INSERT INTO tvk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ve rin ak, xamem iemem bei tengan makil ti neta. ?E rin te takis xil xa di rasa ni ba mi Sisa te hal Rom, rae xil na Hi di maen xir tengan rasa ni, mu tamaen xir ti?” ");
INSERT INTO tvk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","E Iesu mile kil luvosen nae. Misak ni, biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“!Sa mani tova xa di langgal takis ni minou! Xamim mupus pisi. ?Valnao visi e his visi iaxa da en?” E xil labit, “Na Sisa te hal Rom.” ");
INSERT INTO tvk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma Iesu biteni mi xil bit, “Mak, ma musa naha xa be na Sisa iha rilomun ni mi Sisa. !E naha xa be na Hi, musa rilomun ni mi Hi!” ");
INSERT INTO tvk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","E Farasi xil lamesep vari ni metisouen te sepinien nan, e ladit votei. Lapusi xa lasakras lapol ni Iesu vamot e sepinien nan pe met moletin xil. ");
INSERT INTO tvk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Di, rut Siu xil xa lamos e vanut Siu xil xa lakes xil ni ‘Satusi’ lamei visal Iesu. Satusi xil lanemi labit moletin misakras vamea rilomun ra maten. Ma xil lamei labit lisak pis Iesu, e labiteni mini labit, ");
INSERT INTO tvk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Titsa, Mosis tetis rae ak tehe nar xa tehit, ‘Xosxa moletin tei mat e mistokovein atou nan e horamue nalu tovuol, ma tunali sav ihur mei iteli itel tunau nan. Imak, ma isa horamue mini xa ihur his tunali xa mat ngamu.’ ");
INSERT INTO tvk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ma vatei, tua xil latehe lu e he sav (7). E ngan xa tehe muimol teteli tetel atou tei. Di, xi temat e horamue nalu tehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Misak ni, tuneli xa tetutou ni mei tehur tunau nan. E xi mun temat, e tuvava nalu tehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma di, sexien ak testal mun mi ngan xa tehe tol nen e dit temak tang teha vuma … tetuxoh ngan xa tehe tasite e tua xil ak. Xil ngasen latelel e tuvava nae tehe tovuol. ");
INSERT INTO tvk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","E tetutou ni holesok xil ak, atou ak mun temat. ");
INSERT INTO tvk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","?Ma xosxa mea rilomunen be reitin, melele xa moletin xil vus limea rilomun ra maten, ngan xave e tua xil xa labe lu e he sav (7) xiak iaxa ihur atou ak ihe nan xati, vengan xil vus lateteli tetela?” ");
INSERT INTO tvk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","E Iesu bit rilomun ni mi xil bit, “E ut etan ak, tiramue xil e atou xil lakila lateli. ");
INSERT INTO tvk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","E, e melengien tei xa di bemei, ngan xil xa lamal pe met Hi limea rilomun ra maten, e linateli ti mun. ");
INSERT INTO tvk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Xil mei lixoni masxaxa xil xa lasakras lalel. E melele xa moletin xil limea rilomun ra maten, ipisen ni xa labe horamue xil na Hi. ");
INSERT INTO tvk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","E Mosis mun tehit kila xa ngan xil xa lamat, limea rilomun ra maten. E tumulen usil holiei xa upang tepili en e tenaxa ni ti, Mosis tetisi xa Hi Suv tehiteni tehit ‘Inou nabe Hi na Ebraham, Hi na Aesak, e Hi na Siekob.’ ");
INSERT INTO tvk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","?Mulonge? Neta sav xa lattelel ngamu, di tamu latmeul pe met Hi te ut nesao. Hi di meul, e xi be Hi na ngan xil xa di lameul, e tave Hi ti na ngan xil xa lalel. Vengan xa, pe meten, moletin xil vus di lameul.” ");
INSERT INTO tvk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Melele xa rut titsa te rae na Mosis lalong sepinien na Iesu, labiteni mini labit, “!Titsa, sepinien xa otesa ni mi xil momal tevi!” ");
INSERT INTO tvk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ve rin ak, vat xil na Siu xil ulixil mikan tengan lasisi ve neta tova mun. ");
INSERT INTO tvk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Di, Iesu misis vat xil na Siu xil bit, “?Midep? ?Mesaea istal ixo vatimol na suv toto Deved itep? ");
INSERT INTO tvk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vengan xa Deved vari tang tehiteni e sam nan tei tehit, ‘Iahova biteni mi Suv navan bit, “Utotan inggak e riuk metu, ");
INSERT INTO tvk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ituxoh melele xa niling elu nam xil e hem.”’ ");
INSERT INTO tvk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","?Mulonge? Suv toto Deved vari tekes Mesaea ni ‘Suv nan.’ ?E vengan xa tata tei misakras vakes natneli ni ‘suv,’ Mesaea istal ixo vatimol na Deved itep?” ");
INSERT INTO tvk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Melele xa moletin xil di tamu lateong ni sepinien nan, Iesu misel xat moletin nan xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Muxuxou kuhi tengan munapol ni ti sexien xil naxoni ngan xa titsa xil te rae na Mosis di lapol ni. Vengan xa xil iexil bei tengan lasing ni eising xil xa bos e teviei vaxoni eilep xil. Xil di lasing mak e di lakapis e valkesao tengan mosav xil lakila lipus xil e likes xil itel merereen. E melele xa ba labe nim te pispisienxil e anien xil xa latellep, ba ladotan e von totanen xa laserev kuhi be na eilep xil. ");
INSERT INTO tvk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Di lapol ni sisen xil xa teviei tengan moletin xil linemi lihit lamal tevi. E labe vati kanen tang xa di lakan ni holesok holu ra tunau xil. !Ve rin ak, pangasien xa imei mi xil ihe mahulong mak mu ili pangasien xa imei mi moletin tesa sav xil!” ");
INSERT INTO tvk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Melele xa Iesu di tamu pispisi mi moletin xil e vioh te Nim Eo na Hi, miketeh ba e pus moletin xil xa holesok nae holu di lasa sanien nae xil tengan vatutou ni polien te Nim Eo. ");
INSERT INTO tvk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Di, miketeh mun e pus tunau tei xa be hoeo bemei e miso selen lu (2) tang. ");
INSERT INTO tvk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Iesu biteni bit, “Nabiteni mi xamim, tunau xa be hoeo iaxai, sanien xa xi milingi mili sen sanien xa mosav xil latesa ni. ");
INSERT INTO tvk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vengan moletin sav xil di lasa sanien nae xa be rute tang te holesok nae xil, e eilep be nae. E tunau ak xa be hoeo tang, xi di misa vuol ni mani xa vahe te anien an.” ");
INSERT INTO tvk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Rut moletin xil na Iesu di laketeh mikapis e Nim Eo na Hi e holesok xil xa di e vioh teni. Lapusi xa lasak xati bos xa bos del hat xil xa laminehin pupu e del sanien hos sav xil. Melele xa di lasep usili, Iesu biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Melengien tei di bemei xa lihu len sen holesok xil xa di mupusi iaxai. Hat ti vari nasoh.” ");
INSERT INTO tvk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma moletin xil na Iesu lasisi labit, “?Titsa, holesok xil ak istal vilieh? ?E naha vari iaxa istal xa ipisen ni xa ngan ak di bemei sangas?” ");
INSERT INTO tvk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu biteni mi xil bit, “Muxuxou kuhi vengan xa moletin holu limei tengan liluvos pis xamim. Xil liluvos lihit di lasepin e hisok lihit, ‘!Inou nabe Mesaea xa Hi tehit xati!’ E liluvos mun lihit, ‘!Hoxalite te holesok xil bemei sangas xiak!’ E munake reitin ti e sepinien nae e munahusil xil ti. ");
INSERT INTO tvk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Melele xa mulongeong ni xa kantri tei di bae del kantri sav mun, mu moletin xil di labae mi xil mun tang, ulimim nakan ti. Sexien xil ak istal itiamu, e nave hoxalite te holesok xil ti mu.” ");
INSERT INTO tvk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Xi biteni mun bit, “Kantri tei ti ivae itel kantri sav mun, e suv toto tei ti ivae itel suv toto teimun. ");
INSERT INTO tvk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lul ilil ixeih e an tesa xil holu mei istal. E ut xil holu e ut etan, mae iat vanut moletin xil holu e mesien xil te xeih mei ihas vin moletin xil. E tilang hat nesao, neta xil hao listal xa isak ni moletin xil ulixil ikan pupu. ");
INSERT INTO tvk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“E itiamu, melele xa holesok xil ak nastal ti mu, moletin xil mei lital xat xamim e lisak purun xamim. Liling xamim muhe he eilep xil te nim te pispisienxil e lisa xamim muhe nim te xeih. Litel xamim ha musoh pe met suv toto xil e vat xil te kavmen vengan xa mube moletin navan xil e di mupol e hisok. ");
INSERT INTO tvk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","E ngan ak ihe mesal tengan muhithiten longeongen hos mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ve rin ak, bos xa mupol ni nenemien namim tengan munanexo pupu ti ve sepinien eah xa muvue xati tengan ha muhithiteni mi xil e rin namim. ");
INSERT INTO tvk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Vengan inou iaxa nisa sepinien te metisouen mi xamim xa elu namim xil lasakras lavit ti neta mun ven, mu lavit rilomun ni sepinien tova mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tamemim e ninemim xil, tuemim xil e vatimol namim xil mun tang, xil iaxa limaen xamim muhe he elu namim xil, e lihas vin rut xamim mulel. ");
INSERT INTO tvk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Moletin xil vus iexil iat xamim vengan xa di mupol e hisok. ");
INSERT INTO tvk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","E lasakras lapurun meulien sal xa xamim ti muhuri. ");
INSERT INTO tvk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Reitin, xosxa musoh ixeih e neketen namim, ma muhur meulien sal. ");
INSERT INTO tvk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Melele xa mupus moletin te vaeen xil mei likapis xol taon te hal Serusalem, ma mukila xa navehi ti lihu lelen ni. ");
INSERT INTO tvk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","E melele nen ak, ngan xil xa ladi en, litemanon lihe reling. E ngan xil xa ladi e ut sav xil sangas visali linasak pisi ti tengan litilomun en. E ngan xil xa liti e ut sav xil e provins te hal Sudea, lilesae ha liti e vathu xil. ");
INSERT INTO tvk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Melele nen ak ihe ‘Melengien xil te Longpangasien’ xa Hi ipol ni mei istal ixoni ngan xa tehit xati e Vanuvei Eo nan. ");
INSERT INTO tvk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","E melele nen xil ak, isa pupu mi atou xil xa ladi ni tuvava xil e ngan xil mun xa di latunat ni tuvava xil. Vengan xa melengien xil xa ixeih pupu mei istal, e moletin xil ak lilong pangas xil ihe holu pupu ve ekaten na Hi xa ita xat xil. ");
INSERT INTO tvk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E melele te vaeen, litil vin rute xil ni tiei te vaeen xil, e rute ngan xil mun livar xat xil e lileh xil ha liti pe he suv toto xil te kantri sav xil. E Hi imaen taon te hal Serusalem mi ngan xil xa latave Siu ti tengan lipurun ni ha ituxoh melele xa Hi ihiteni ihit melengien nae ipin. ");
INSERT INTO tvk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Holesok xil holu istal e meteneai, aveti e hitu xil mun. Misak ni, e ut etan, lisak ni tahe xil xa tellep limea e lihas lelen kantri xil holu. Melele xa moletin xil lipusi, linexo pupu, limuis e liat luhexil ve ulikanen. ");
INSERT INTO tvk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Melele xa moletin xil vus lipus holesok xil ak xa di mistal e ut etan e lipusi xa holesok xil te tilang hat di bilhiles, holu e xil limermesil ve ulikanen nae. ");
INSERT INTO tvk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","E melele xa liketeh ihe nesao, lipus ‘Nat Hi mei istal ixo momah xil te tilang hat’ itel xeihen e minehinen te xeihen nan. ");
INSERT INTO tvk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Melele xa holesok xil ak mei istal, musoh ixeih e mupet rat vatumim ihe nesao vengan xa Hi sangas vamei tengan vateh meulien e moletin nan xil.” ");
INSERT INTO tvk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Di, Iesu dei vole ak mi moletin nan xil bit, “Munem pis vatit fik xil itel vatiei savsav xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Melele xa lite xil miso rohon ni ute xil xa be neta hu, xamim mukila xa melele te an te tin di bemei. ");
INSERT INTO tvk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Usil sexien nen tak, melele xa mupus holesok xil ak mei istal, mukila xa melele xa Hi mei ihe suv toto na moletin xil te ut etan di bemei sangas xiak. ");
INSERT INTO tvk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nabiteni reitin mi xamim, moletin xil xa lameul ladi xosali ti lipus longpangasien xil ak mei listal e taon te hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ut nesao e ut etan lalivus, e sepinien navan xil misakras vavus vatova.” ");
INSERT INTO tvk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Iesu misel xat moletin nan xil bit, “!Muxuxou kuhi! Munamaen nenemien te anienen, mu munien, mu nenexoen sav xil te ut etan ak namei nalih nenemien namim ti. Maxani, melengien xa Nat Moletin itilomun en imei, e xamim mutemanin ni ixoni ngan xa moletin mitemanin melele xa mitam ras suse nan e be siling tei. ");
INSERT INTO tvk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vengan melengien ak mei istal mi moletin xil vus e ut etan. ");
INSERT INTO tvk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Misak ni, muvue xat xamim vehakut. E ti musis tengan muvur xeihen tengan mutuxoh hoxalit longpangasien ak, tengan munave unoun ti e melele xa ha musoh pe met Nat Moletin.” ");
INSERT INTO tvk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","E melengien xil vus, Iesu di pispisi mi moletin xil e vioh te Nim Eo. E melele xa vongien bemei, xi ba pat e Vathu te Urvatiei te Olip del moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","E, e makoe roroh xil vus, moletin xil labe vioh te Nim Eo na Hi tengan lateong ni pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Melele bemei sangas tengan Siu xil lanem rilomun ni Melengien xil te Beret xa Is Tovuol En. Melengien kokot teni vari, xil lapol ni anien xa lakesi ni Anien te Tavien. ");
INSERT INTO tvk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Vat xil na pris xil del titsa xil te rae na Mosis di lalang ves suse tengan lakila lavas xuxus ni Iesu vamat vaxo en. Iexil ti tavei tengan lapol ni e melele xa moletin xil di lakapis xol Iesu vengan ulixil mikan xa linapol ni neta tova mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Melele xa vat xil ak di latumul usili, Temat bemei misa nenemien tesa tei mi Sudas Eskariot xa be tei e moletin lu e le tei (12) na Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ma Sudas ba pus vat xil na pris xil del vat xil na mereketeh xil te Nim Eo usil suse xa xi mikila iling Iesu ihe hexil ixo en. ");
INSERT INTO tvk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xil labesi xil pupu ve tutouen nan e labit xati xa lixale ven. ");
INSERT INTO tvk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mak, ma Sudas maen ni tengan vatutou ni xil. E melele xa dilomun ba, di milang ves suse xa bos tengan iling Iesu ihe hexil ixo en e melele xa moletin xil linave holu ti en. ");
INSERT INTO tvk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","E melengien kokot te Melengien xil te Beret xa Is Tovuol En, be melele xati xa moletin xil di labas sulut sipsip xil ve Anien te Tavien. ");
INSERT INTO tvk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Iesu misil Pita xal Sion del xat sepinien ak, “Muliha mulisak mesen Anien te Tavien tengan ha ria vituei ni.” ");
INSERT INTO tvk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma xalu lusisi lubit, “?Rute xave iaxa iem bei tengan malsak mesen Anien te Tavien en?” ");
INSERT INTO tvk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Xi bit rilomun ni mi xalu bit, “Melele xa mulihe taon te hal Serusalem, mulhisu ni moletin tei xa di po valoei tei. Mulhusili ha mulhe nim xa xi iha en. ");
INSERT INTO tvk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ti, mulsis moletin te nim ak mulihit, ‘Titsa bit, “?Inou mei nia Anien te Tavien itel moletin navan xil e rute xave?”’ ");
INSERT INTO tvk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","E xi itel xamil mulihe nesao e nim man e ipisen von toen tei xa mahulong xa langgur revi ngamu datil xamil. Rute ak vari iaxa mulisak mesen holesok xil vus en.” ");
INSERT INTO tvk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Misak ni, Pita xal Sion luba, e lupus holesok xil vus nggoni ngan taxa Iesu tehiteni mi xalu. Ma xalu lusak mesen Anien te Tavien e rute ak. ");
INSERT INTO tvk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Momal ni melele te anien en, Iesu bemei vituei del moletin nan xil e lakapis xol vet te anien en. ");
INSERT INTO tvk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Melele xa ladotan bus, Iesu biteni mi xil bit, “Ieok tehei pupu tengan nama Anien te Tavien ak vatel xamim. Ti, niha sung nihur longpangasien navan. ");
INSERT INTO tvk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nabiteni mi xamim, ninaxa ti mun anien ak iha vuma ... koute te Anien te Tavien ak mei istal ihe reitin e melele xa Hi mei e isak ni lelaxatien nan iti e ut etan.” ");
INSERT INTO tvk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Di, Iesu nggur kap xa uaen ba en, memes Hi ven, e biteni bit, “Muhuri, e xamim vus mumu ni. ");
INSERT INTO tvk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nabiteni mi xamim, taxeak iha ninamu ti mun uaen ak ha ituxoh melele xa Hi imei istal ihe suv toto na moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Di, Iesu nggur beret, memes Hi ven, bul pasi e miseti mi moletin nan xil bit, “Ngan ak be tiei navan xa di nasa ni ve xamim. Mupol ni imak tengan ti munem xat nou.” ");
INSERT INTO tvk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Usil sexien tak, melele xa langganien bus, Iesu nggur kap xa uaen ba en, misa ni mi xil e biteni bit, “Uaen ak be reok xa di mileh ve xamim tengan vasak ni hitxatien te xeih hu na Hi mei istal e ihe reitin. ");
INSERT INTO tvk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“!E muteong ni nou! Ngan xa imaen ni nou nihe he elu navan xil da tak. Reitin, xi di ngganien vituei del nou e vet ak. ");
INSERT INTO tvk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Be reitin xa Nat Moletin ha imat ixoni ngan taxa Hi tehit xati ngamu tengan istal. !E isa xa isa pupu mi ngan xa ihe suse teni!” ");
INSERT INTO tvk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Melele xa lalonge mak, moletin nan xil lasis xil mun tang xa visi e xil iaxa ikila ipol ni sexien ak. ");
INSERT INTO tvk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Melele xa moletin xil na Iesu ladi tamu e von anien en, di langor mi xil mun tang usil visi e xil iaxa be eilep mak mu mili. ");
INSERT INTO tvk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Iesu biteni mi xil bit, “E kantri sav xil, suv toto xil na moletin xil xa latakil ti Hi di lapol ni nggeih mi ngan xil xa ladi pe hexil tengan vapisen xeihen nae. E melele xa di lapol ni nggeih mi moletin xil mak, di labit usil rin nae labit, ‘Xamem mabe timue hos na moletin xil e di madutou ni xil tang.’ ");
INSERT INTO tvk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","E rin xa namim, namak ti. Ngan xa be eilep e xamim mei ihur nenemien xa ihe tan ixoni ngan xa be moletin xa be neta sav tang. E ngan xa be vat namim, xi mei itutou ni ngan tesav xil e xamim ixoni ngan be slev nae tang. ");
INSERT INTO tvk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","?Visi iaxa be eilep mak mu, ngan xa dotan di ngganien e vet tei, mu ngan xa di misa anien mini? Moletin xil vus lanemi labit ngan xa dotan di ngganien. E inou, nade visal xamim nggoni slev tei xa di misa anien mi xamim. ");
INSERT INTO tvk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Xamim muteti visal inou e melele te xeih xil e melele te xeih xil vus xa natehisu ni. ");
INSERT INTO tvk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E nggoni ngan taxa Tata teling xat lelaxatien te holesok nan xil tete heok, inou mun niling xat lelaxatien ak ite hemim. ");
INSERT INTO tvk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","E melele xa nitotan e von lelaxatien navan ixoni suv toto, xamim ti muanien e ti mumun itel nou. E xamim mun mutotan e von lelaxatien e ti mulaxat vatimol xil xa mahulong lu e le tei (12) na mol‑Isrel xil e mulepis rin nae xil.” ");
INSERT INTO tvk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Di, Iesu biteni mi Saemon Pita bit, “!Saemon, Saemon, uteong ni nou! Temat tesis Hi tengan isak pis xamim vus, e Hi temaen ni tengan vakil ti reitinen te neketen namim. ");
INSERT INTO tvk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","E inou natesis ve xouk, Saemon, tengan neketen nam navus relinguk ti. E melele xa uhiles meulien nam e neketen nam imei ixeih mun, ha ututou ni tumali xil tengan neketen nae mun mei ixeih.” ");
INSERT INTO tvk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","E Pita mitamea e biteni mini bit, “!Suv, inou nabue xat nou tengan nihe nim te xeih itelak e nimat itelak!” ");
INSERT INTO tvk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E Iesu bit rilomun ni mini bit, “Nabiteni minuk Pita, melele xa tuto nakora ti mu e ut nalan ti mu, e xouk umuun xole ihe vatol (3) xa otakil ti nou.” ");
INSERT INTO tvk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Di, Iesu biteni mi moletin nan xil bit, “Melele xa natesil rerat xamim tengan ha mupol, mutnaleh ti mani, ateli, mu sandel. ?E midep, mutehe terume ni neta tova?” E labit rilomun ni mini labit, “E‑e, matnave terume ni ti neta.” ");
INSERT INTO tvk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu biteni mi xil bit, “E taxeak, tei xa mani mu ateli nan di, ihur xati itela. E xosxa tiei te vaeen nan tovuol, ma ipos ni eising tova nan e ixal tiei tova. ");
INSERT INTO tvk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nabiteni mi xamim, imak ma sepinien xa de Vanuvei Eo na Hi mei ihe reitin usil nou xa bit, ‘Xi temaen xi tengan lasak purun ni vaxoni moletin tesa xil.’ Reitin, e melele nen tak naha xa latetisi usil nou di bemei be reitin.” ");
INSERT INTO tvk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Melele xa moletin nan xil lalong selxatien nan, labiteni mini labit, “!Suv, pus ti mu! Tiei lu te vaeen xiak.” E Iesu bit rilomun ni bit, “!Ngan ak pipin!” ");
INSERT INTO tvk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Melele xa langganien bus, Iesu be reling taon te hal Serusalem e ba be Vathu te Urvatiei te Olip nggoni ngan taxa di pol vehakut ni, e moletin nan xil langgusili. ");
INSERT INTO tvk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Melele xa laduxoh rute ak, Iesu biteni mi xil bit, “Xamim ti musis tengan munamot ti e melele xa sakpisien xil imei mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Di, Iesu be reling xil e be sotin vuteili. E rute ak, mitingeiril be tan e misis bit, ");
INSERT INTO tvk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, xosxa omaen ni, ma hur rat longpangasien ihe reling nou li. E onapol ni ti naxoni ngan xa inou ieok bei, e upol ni uhusil naha xa xouk kestang di iem bei.” ");
INSERT INTO tvk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","E masxaxa tei te ut nesao mei mistal mini e misak ni ven e nenemien nan mei nggeih mu. ");
INSERT INTO tvk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesu minem holu usil naha xa imei, e midakes Hi nggeih vatei mun. E melele xa misis, vetin nan mileh holu e mot be tan nggoni ra. ");
INSERT INTO tvk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Melele xa Iesu misis bus, xi mea, ba rilomun visal moletin nan xil. E mikameti xa xil vus di lapat. Di lapat vengan xa nenexoen di bas xil e misak ni xil vexil labuol. ");
INSERT INTO tvk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma Iesu biteni mi xil bit, “?Veneh ma di mupat? !Mutamea! !Musis tengan Hi itutou ni xamim tengan munamot e tesaen ti e melele xa sakpisien xil imei!” ");
INSERT INTO tvk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Melele xa Iesu di tamu misepin mi moletin nan xil, Sudas xa be tei e moletin lu e le tei (12) nan di mikakao bemei del tatit moletin tatei xil. Melele xa pus Iesu, bemei visali tengan vapesum ni vin. ");
INSERT INTO tvk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Iesu misisi bit, “?Sudas, veneh ma mei opesum ni nou nggoni ngan xa nabe timue hos nam e melele xa di osa rat nou, Nat Moletin, tengan name he elu navan xil?” ");
INSERT INTO tvk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Melele xa moletin xil na Iesu lapus naha xa di mistal, lasis Iesu labit, “?Suv, rakila ravae vatel tiei te vaeen nar xiak?” ");
INSERT INTO tvk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tei xil milihi rat tiei nan e da xoteh vurang metu na slev tei na vatixar na pris xil. ");
INSERT INTO tvk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","E Iesu misel mini bit, “!Ei, pipin!” Di, mitang duxol vurang moletin ak e misak ni vurangen mei bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Di, Iesu biteni mi vat xil na pris xil, mereketeh xil te Nim Eo, del elda xil na Siu xil xa lamei tengan latal xati bit, “?Veneh ma di muleh tiei e homenda xil te vaeen tengan mei mutal xat nou? ?Munemi mubit inou di nadiamu ni moletin xil tengan mavae vaha xat kavmen nar? ");
INSERT INTO tvk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","!E‑e! Melengien xil ngasen nadotan nade vangit vioh te Nim Eo e di napispisi mi moletin xil, e xamim mutamei ti tengan mutal xat nou. E melele xa ut maluxoluk mak, ma di mupol ni, vengan xa ngan ak be melele namim, e be melele na ngan xil vus xa ladi pe xeihen te maluxoluken.” ");
INSERT INTO tvk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xil ladal xat Iesu e ladeli ba be nim ma vatixar na pris xil. E Pita di mika xus e di nggusil xil. ");
INSERT INTO tvk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Melele xa laduxoh nim ak, lasahan upang tei di minggan e hilaep te vioh teni. Ma Pita ba mos del ngan xil xa di ladotan xorelisi. ");
INSERT INTO tvk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Melele xa Pita di dotan visal upang mak, atou te polien tei pusi, miketeh momal ba ni, e biteni bit, “!Ei, moletin ak mun be tei e ngan xil xa latehusil xat Iesu!” ");
INSERT INTO tvk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","E Pita muun xole bit, “!Atou, inou natakil ti moletin xai!” ");
INSERT INTO tvk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tave nousav ti, moletin teimun pus kil Pita ma biteni mini bit, “!Xouk mun obe tei e xil!” E Pita muun xole vatei mun bit, “!Ei, natave tei e xil ti!” ");
INSERT INTO tvk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Di, be nousav vuteili, moletin sav mun pusi e misepin nggeih xati bit, “!Reitin mak! Tiramue ak be tei e moletin xil na Iesu vengan xa sepinien nan nggoni ngan Kaleli xil tang.” ");
INSERT INTO tvk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","E Pita muun xole nggeih vatol nen bit, “!Tave reitin ti! !Inou natakil ti vari naha xa di obit usili iaxai!” Vatei takes, melele xa di tamu misepin, tuto tei mikora. ");
INSERT INTO tvk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","E melele nen tak, Suv Iesu biles e miketeh momal ba ni Pita. Di, Pita minem rilomun ni naha xa Suv tehiteni mini tehit, “Melele xa tuto nakora ti mu e ut nalan ti mu, e xouk umuun xole ihe vatol (3) xa otakil ti nou.” ");
INSERT INTO tvk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma Pita milonge misa xa misa e mistal be reling vangit vioh ak, ba di muis nggeih. ");
INSERT INTO tvk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mereketeh xil te Nim Eo xa di laketeh xol Iesu lasep pepamen ni e di labas purun ni. ");
INSERT INTO tvk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Labar xol meten e labasi. E melele xa tei xil basi, xil lasisi labit, “?!Xosxa obe provet reitin, uhit pisi, visi iaxa basuk!?” ");
INSERT INTO tvk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E lasep purun ni ni holesok hao mun xa mak. ");
INSERT INTO tvk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Melele xa ut milan, elda xil na Siu xil, vat xil na pris xil, del titsa xil te rae na Mosis lamei vituei e von koten nae. Di, ladel Iesu bemei misoh pe metexil. ");
INSERT INTO tvk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Xil lasisi labit, “?Hit pisi mi xamem, be reitin xa xouk iaxa obe Mesaea xa Hi tehosei?” E Iesu bit rilomun ni mi xil bit, “Xosxa nihiteni mi xamim, ma munake reitin ti en. ");
INSERT INTO tvk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E xosxa nisis xamim xa veneh ma mutake reitin ti en, ma musakras muvit kuhi minou. ");
INSERT INTO tvk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","E nihiteni imak, taxeak iha, Nat Moletin itotan e von xeihen e ri metu na Hi te xeihen.” ");
INSERT INTO tvk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Melele xa Iesu biteni mak, xil vus lasisi labit, “?Midep? ?Di obiteni obit xouk iaxa obe Nat Hi?” Ma Iesu bit rilomun ni mi xil bit, “Nggoni ngan taxa xamim di mubiteni.” ");
INSERT INTO tvk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Misak ni vat xil na Siu xil labiteni labit, “?!Veneh ma di rilang ves moletin tova tengan isa sepinien iha xati!? !Xir vus ralong sepinien tesa xil xa mistal nggo vulongen ihe an mun tang!” ");
INSERT INTO tvk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Vat xil na Siu xil vus xa ladi e kot lamea e ladel Iesu ba misoh pe met Suv Paelet xa be vat te kavmen e provins te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Di, xil labit rat holesok holu ba xat rin na Iesu mi Paelet labit, “Xamem makameti xa moletin ak iaxa di miling nenemien xil xa misa mi Siu xil. Xi di misep xol xil tengan linaxal takis ti nava mi Sisa e kavmen nan te hal Rom. E xi di bithiteni xa be Mesaea xa Hi tehosei tengan mei vahe suv toto tei.” ");
INSERT INTO tvk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Paelet misis Iesu bit, “?Midep? ?Be reitin xa xouk iaxa obe suv toto na Siu xil?” E Iesu bit rilomun ni bit, “Nggoni ngan taxa obiteni.” ");
INSERT INTO tvk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Di, Paelet biteni mi vat xil na pris xil del tatit moletin xil ak bit, “Inou natakamet ti neta xa misa vata xat rin na moletin ak.” ");
INSERT INTO tvk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","E xil laso rut sepinien ba xat rin na Iesu labit, “Pispisien nan di misi petine moletin xil tengan livae itel xil mun tang. Xi tepol kokot ni e provins te hal Kaleli, e taxeak, di pol ni inggak e provins te hal Sudea.” ");
INSERT INTO tvk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Melele xa suv Paelet milonge mak, misis xil bit, “?Be reitin xa moletin ak be ngan Kaleli?” ");
INSERT INTO tvk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Melele xa Paelet milong kila xa Iesu be ngan Kaleli tei, rute xa suv toto Herod Antipas di milaxati, misil Iesu ba pusi vengan xa Herod de Serusalem e melele nen ak. ");
INSERT INTO tvk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E melele xa suv toto Herod pus Iesu, besi xi pupu. Besi xi vengan, be nousav ngamu, xi ien tehei tengan vapus ti ni meten xati. Xi minemi bit vahit Iesu vapol ni merekel tova tengan vapus ti. ");
INSERT INTO tvk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ma Herod misis rovui Iesu e rin xil holu, e Iesu dat votei, tasa rilomun ni ti sepinien tova mini. ");
INSERT INTO tvk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vat xil na pris xil del titsa xil te rae na Mosis mei lasoh pe met Herod e laso sepinien xil xa nggeih xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Di, Herod del moletin te vaeen nan xil mun lasepin misa ba xati. Xil lapol pepamen ni Iesu e lasing xole ni kaliko tei xa bos nggoni suv toto tei. Di, lasa rilomun ni be visal suv Paelet. ");
INSERT INTO tvk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","E melengien nen ak vari, Herod del Paelet mei lube timue hos. E diamu ni melele nen ak, lutehe elu mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelet mikes viton vat xil na pris xil, eilep xil na Siu xil, del moletin sav xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Di, biteni mi xil bit, “Xamim mutehur moletin ak temei visal nou e mutehiteni xa xi iaxa di miling nenemien xil xa misa mi Siu xil. E taxeak, pe metemim, natelepis rin nan xil vus, e natakamet ti rin tova xa misa xa xamim mubit xi di pol ni. ");
INSERT INTO tvk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E suv toto Herod mun takamet ti rin tova xa misa vata xati. Mak iaxa misa rilomun ni bemei visal xir. Moletin ak tenapol ni ti neta tengan ha imat ven. ");
INSERT INTO tvk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mak, ma nisemae ni moletin navan xil tengan ha limeas pangasi, ti, nimaen ni ha ven imase.” ");
INSERT INTO tvk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Vatei takes, vanut moletin xil ak lakei be nesao labit, “!Has vin moletin xai! !Maen Barabas ha ven imase!” ");
INSERT INTO tvk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tete nim te xeih vengan xa tehas vin moletin tei e hal Serusalem e melele xa latevae tetel kavmen te hal Rom en. ");
INSERT INTO tvk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paelet ien bei tengan vamaen Iesu vaha ven vamase, ma biteni mi vanut moletin xil ak vatei mun bit, “!Nimaen Iesu ha ven imase!” ");
INSERT INTO tvk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","E moletin xil lakei nggeih pilei sung labit, “!Ti xati e eivave! !Ti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Vatol nen, Paelet misak pisi tengan vasepin mi xil bit, “?Xi tepol ni naha xa tesa? !Natakamet ti neta tova xa xi tepol ni tengan vaha vamat ven! Misak ni, moletin navan xil ha limeas pangasi, ti, nimaen ni ha ven imase.” ");
INSERT INTO tvk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","E vanut moletin xil langgulehi di lakei nggeih pilei mu tengan ha liti xat Iesu e eivave. Dit lapol ni, lapol ni, lapol ni ba vuma … Paelet maen ni sung. ");
INSERT INTO tvk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ma Paelet pol ni naha xa moletin xil di lasisi ven. ");
INSERT INTO tvk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nggusil keien nae, xi maen ngan xa tehas vin moletin tei e vaeen tei tetel kavmen te hal Rom tengan ha ba ven imase ra nim te xeih. E Iesu sung, Paelet misa rati be he moletin te vaeen nan xil tengan lihusil naha xa vanut moletin xil ak iexil tehei, ma ba tengan liti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Melele xa moletin te vaeen xil na Paelet ladel Iesu laba, labisu ni moletin tei te hal Saerin xa di mikakao bemei tengan vahe Serusalem, hisen Saemon. Ma ladal xati, e laling eivave na Iesu de vatuvun tengan ipoe ihusil xil. ");
INSERT INTO tvk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tatit moletin tei xa mahulong mun di langgusil Iesu laba. E rute xil labe atou xil xa di lamuis e di ladang ven. ");
INSERT INTO tvk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","E Iesu biles, miketeh pus xil e biteni mi xil bit, “Atou xil te hal Serusalem, munates nou ti. E mutes xamim mun tang itel horamue namim xil. ");
INSERT INTO tvk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vengan melengien tesa xil di bemei xa moletin xil ti lihiteni lihit, ‘Ihos pupu mi atou xil xa labe lumalum, ngan xil xa lataling ti mu horamue, e ngan xil xa latatunat ni ti tuvava.’ ");
INSERT INTO tvk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E ti lihiteni mun mi vathu xil lihit, ‘!Tetu xat xamem!’ e mi hu xil lihit, ‘!Soson xamem!’ ");
INSERT INTO tvk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","?Vengan xosxa upang te pangasien di ngga len moletin hos tei xa nggoni vatiei xa memas, ma itep mi moletin tesa xil xa langgoni vatiei xil xa langguxu? Upang na Hi mei ia lelen xil vus.” ");
INSERT INTO tvk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","E melele nen ak, di ladel moletin lu mun xa lutepol tesa luba tengan ha lihas vin xalu itela. ");
INSERT INTO tvk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Melele xa laduxoh rute xa lakesi ni ‘Valvat Moletin,’ ladi xat Iesu de eivave. E moletin tesa xalu, ladi xat xalu ludi e eivave lu mun. Tei de rin metu, e tei de rin meil. ");
INSERT INTO tvk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Melele xa Iesu di murur e eivave, biteni bit, “Tata, unaketeh ti nasa ni xil vengan xa xil latakil ti naha xa di lapol ni.” Sangas visal Iesu, moletin te vaeen xil laso daes tengan laseti eising nan mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","E tave sotin pupu ti, moletin xil hao lasoh ladi tengan lapusi. Vat xil na Siu xil di lasep pepamen mini labit, “Mupus pisi. Xi miteh meulien e moletin sav xil. !Bos! !E xosxa be Mesaea reitin xa Hi tehosei, ma iteh meulien e xi tasen tang!” ");
INSERT INTO tvk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Moletin te vaeen xil mun, di lasep pepamen mini. Labe visali, e lasa uaen xa mikon mini tengan vamu ni. ");
INSERT INTO tvk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Labiteni labit, “!Xosxa obe suv toto na Siu xil, uteh meulien e xouk tasom tang!” ");
INSERT INTO tvk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di, xil ladi xat tisen tei de nesao ni vat Iesu xa bit, “Ngan ak be suv toto na Siu xil.” ");
INSERT INTO tvk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tei e moletin tesa xalu xa di murur e eivave misepin misa ba mi Iesu bit, “?Be reitin xa obe Mesaea? !Uteh meulien e xouk itel xamel mun!” ");
INSERT INTO tvk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","E teimun xalu misepin nggeih ba ni tua nan bit, “?Midep? ?Ulum takan ni Hi ti? Longpangasien naratel pipin tang. ");
INSERT INTO tvk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","E ralu, momal tang xa ralihur longpangasien ak vengan xa rupol misa. E moletin ak tapol ni ti neta xa vasa.” ");
INSERT INTO tvk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Di, xi biteni mi Iesu bit, “Melele xa mei uhe suv toto e uhur xeihen nam, unem xat inou li.” ");
INSERT INTO tvk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E, Iesu bit rilomun ni mini bit, “Nabit xati minuk, xosali tang, xouk uta itel xat nou e rute tei xa ihos xa ihos pupu.” ");
INSERT INTO tvk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","E piniae xati, ut biles bemei maluxoluk e dat mak duxoh tri klok mahis, ");
INSERT INTO tvk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","vengan xa eai taxan ti mun. Di, kaliko xa dakoe xol ut eo te Nim Eo na Hi mesel e hilaep be rin lu. ");
INSERT INTO tvk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","E melele nen ak, Iesu mikei be nesao mi Hi bit, “Tata, naling meulien navan de hem.” Melele xa biteni mak, Iesu milihi kor ni votiang, di, mat. ");
INSERT INTO tvk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Melele xa vat na moletin xil te vaeen pus naha xa mistal, xi pus kil xeihen na Hi nggo holesok xil xa di mistal e biteni bit, “Reitin mak, moletin ak temal tevi e tenapol ni ti neta vasa.” ");
INSERT INTO tvk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Moletin sav xil holu latemei tengan lapus holesok xil xa testal mi Iesu teha tetuxoh maten na Iesu e sexien xa di mat. E melele xa latepus naha xa mistal, ladang e lamuis ba labe tim sae xil. ");
INSERT INTO tvk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","E ngan xil xa latekil kuh Iesu, del atou xil xa di latehusili melele xa latexo provins te hal Kaleli latemei, xil lasoh ladi nga sotin vuteili, e di lapus holesok xil xa di mistal. ");
INSERT INTO tvk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Moletin tei da e rute ak, hisen Siosep te hal Aramatea e provins te hal Sudea. Xi be moletin hos tei e sexien nan xil momal. Neta sav xa be tei e kaonsel xa latepol ni kot mi Iesu, ");
INSERT INTO tvk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","xi tenamae ti e lingxatien nae tengan lavas vini. E xi mun di datil melele xa Hi imei ihe suv toto na moletin xil te ut etan. ");
INSERT INTO tvk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xi be visal Paelet e misisi tengan vamaen ni tiei na Iesu ha vatihin ni. Ma Paelet maen ni mini. ");
INSERT INTO tvk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Di, Siosep ba po rat tiei na Iesu ra eivave, e pis xole ni kaliko te mieh tei xa memese. Di, poe e ba milingi de vangihat te tehinen hu tei xa lateseh moten rohon ni tang. ");
INSERT INTO tvk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Be Fraede mahis, e Sabat bemei sangas xa Siu xil lasakras lapol en. ");
INSERT INTO tvk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Melele xa Siosep di po tiei na Iesu, atou xil xa di latehusil Iesu latexo Kaleli latemei lapusi. Ma xil langgusil xuxus ni e lapus vangihat ak e midep iaxa teling tiei na Iesu da en. ");
INSERT INTO tvk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Di, xil ladilomun labe tim, e labue xat vokon e oel tengan lixul maxoe ni tiei na Iesu ni. E langel e Sabat nggoni ngan xa rae na Mosis tesemae ni. ");
INSERT INTO tvk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","E Sande makoe roroh, atou xil lakakao labe vangihat del vokon e oel taxul maxoe en xa lateling xati tuei teti tengan livue xat tiei na Iesu ni. ");
INSERT INTO tvk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","E melele xa laduxoh vangihat ak, lakameti xa vatihat xa dakoe xol puiteh te vangihat, ladivin rati ngamu. ");
INSERT INTO tvk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","E melele xa labe vangite, latapus ti tiei na Suv Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Misak ni, lanexo e di lanem vesi xa tiei na Iesu ba xave. Vatakes, rumali lu xa eising nalu mihinehin pupu mei lustal mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Atou xil ulixil mikan pupu e latingeiril mi xalu. E rumali xalu ak lubiteni mi xil lubit, “?Veneh ma di mulang ni ngan xa meul e von maten? ");
INSERT INTO tvk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Xi tara ti ak, mea rilomun ra maten ngamu. Munem xat naha xa xi tehiteni mi xamim melele xa xi teta tamu e Kaleli. ");
INSERT INTO tvk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xi tehiteni xa lisa rat Nat Moletin ihe he moletin tesa xil. Ti, xil liti xati e eivave e imat. E melele xa melengien tol mei itavi, imea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma atou xil lanem rilomun ni sepinien na Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Di, labe reling vangihat te tehinen e ladilomun ba lapus moletin xil na Iesu xa labe tei e le tei (11) e labit mesen holesok xil vus mi xil del mosav xil mun xa latehusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Atou xil ak latehe Meri te hal Makdela, Soana, e Meri xa be nine Temis, del rut atou xil mun. E melele xa atou xil ak laba labit mesen holesok xil ak mi eloheoh xil, ");
INSERT INTO tvk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","xil lanemi labit tumulen na atou xil ak be luvosen tang, ma latake reitin ti e xil. ");
INSERT INTO tvk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","E Pita mitamea e miloh be vangihat. E melele xa duxoli, mitei hiraen be vangite e pus kaliko te mieh xa latepis xol Iesu ni da, e tapus ti tiei nan. Di, xi dilomun be tim e di minem ves naha xa mistal. ");
INSERT INTO tvk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E melengien nen tak, moletin lu xa lutehusil xat Iesu di lukakao lube metimal tei xa lakesi ni Emeas. Metimal ak be sotin vuteili, kilomita teni be tei e le tei (11) ra hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xalu lukakao luba e di lutumul usil holesok xil vus xa testal. ");
INSERT INTO tvk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","E melele xa di tamu lutumul mak, Iesu vari bemei dutou ni xalu e mei mos e xalu latoba. ");
INSERT INTO tvk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","E Hi misikoe xol nenemien nalu tengan lulnale kil ti. ");
INSERT INTO tvk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Melele xa latkakao mak, Iesu misis xalu bit, “?Xamil di mutumul usil naha e suse namil?” Xalu lusoh kat, e valnao xalu be tan. ");
INSERT INTO tvk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tei e xalu xa hisen Kleopas misis Iesu bit, “?Midep? ?Xouk kestang xa otemei e hal Serusalem iaxa otakil ti holesok xil xa testal e melengien vahis xa tetavi?” ");
INSERT INTO tvk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Iesu misis xalu bit, “?Holesok eah?” E xalu lubit rilomun ni mini lubit, “Holesok xil xa testal mi Iesu te hal Nasaret. Moletin ak tehe provet tei na Hi xa eilep pupu pe meten e pe met moletin xil mun xa tesepin e tepol tetel xeihen. ");
INSERT INTO tvk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","E vat xil na pris xil del eilep xil na Siu xil latesa rati teha tehe he kavmen te hal Rom. E xil iaxa latekin maten mini, lateti xati e eivave, e temat. ");
INSERT INTO tvk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","E xamem di matenesi matehit xi iaxa ileh rerat mol‑Isrel xil ha vexil imase ra he ngan xil xa di lapol ni nggeih mi xil. E neta tei mun, holesok xil testal melengien tol ngamu xa tetavi. ");
INSERT INTO tvk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","E xosali, makoe roroh tamu, rut atou xil xa di lamos e xamem latehe vangihat te tehinen nan, e latetumul ni neta xa misak ni xamem mamesep pupu. ");
INSERT INTO tvk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Xil latetilomun latemei e latehit mesen ni mi xamem xa latnapus ti tiei na Iesu e vangihat ak. Latehiteni mun xa latepus masxaxa lu xa lutestal mi xil xa lutehiteni mi xil xa Iesu temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Di, rute e xamem latehe vangihat ak e latekameti xa holesok xil vus texoni ngan taxa atou xil ak latehiteni. E tiei nan latnapus ti.” ");
INSERT INTO tvk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Melele xa Iesu milong tumulen nalu, biteni mi xalu bit, “!Xamil mube varu tova tang! !Muraru pupu tengan muke reitin e holesok xil xa provet xil tetiamu latehiteni! ");
INSERT INTO tvk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vengan xa xil latehiteni xa, itiamu, Mesaea ihur longpangasien xa mak. Ti, ihur his xa eilep e ha ihur von lelaxatien itel minehinen te xeihen nan.” ");
INSERT INTO tvk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Di, Iesu bit kil holesok xil vus xa di e Vanuvei Eo xa di misep usil xi: ngan xil xa langgo tisen xil na Mosis mei duxoh tisen xil na provet xil mun. ");
INSERT INTO tvk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Melele xa latomei sangas visal metimal te hal Emeas, Iesu bit ha ihur sal ni suse iha. ");
INSERT INTO tvk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","E xalu ludakesi lubit, “Uta tamu visal xamel li vengan xa meteneai ba tu xiak, e navehi ti ut imaluxoluk.” Ma be xatel latodi. ");
INSERT INTO tvk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","E melele xa Iesu dotan tengan vaanien vatel xalu, nggur beret, memes Hi ven, bul pasi e misa ni mi xalu. ");
INSERT INTO tvk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Vatei takes, nenemien nalu miluv e lupus kila xa xi be Iesu. E melele xa di tamu luketeh lupusi, Iesu mikesae reling metealu. ");
INSERT INTO tvk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","E xalu lubiteni mi xalu mun tang lubit, “!Moletin ak tehe Iesu vari! Melele xa di tamu tehit kil sepinien xil te Vanuvei Eo mi ralu, rulong kila nggo tineralu xa xi iaxai.” ");
INSERT INTO tvk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Misak ni, e melele nen ak vari, xalu lutamea e ludilomun lube Serusalem. Melele xa luduxoh hal Serusalem, lukamet moletin tei e le tei (11) na Iesu xa ladi vituei del rut moletin sav xil mun xa latehusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","E xil labiteni mi xalu labit, “!Be reitin! !Suv Iesu temea rilomun ra maten, vengan xa testal ni Saemon Pita!” ");
INSERT INTO tvk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Di, moletin xalu ak sung lusep kil naha xa testal mi xalu e suse, e midep iaxa lutepus kil Iesu melele xa tevul pas beret. ");
INSERT INTO tvk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Melele xa rumali di tamu lusep usil holesok xil ak mi xil, Suv Iesu vari mei misoh e hilaep te xil e biteni mi xil bit, “Tomat iti mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Xil lamesep pupu e ulixil mikan vengan xa lanemi labit di lapus ninin nan tang. ");
INSERT INTO tvk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","E xi biteni mi xil bit, “?Ulimim di mikan ni nou veneh? ?E veneh ma nenemien namim be lu usil nou e mutake reitin ti xa natemea rilomun ra maten reitin? ");
INSERT INTO tvk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Muketeh mupus heok xalu e leok xalu. Inou mak xiak. Mutang mei mutuxol inou tengan muteong kila xa hisi e siuk di, vengan xa ninin tei, hisi e sin xil latovuol en.” ");
INSERT INTO tvk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","E melele xa biteni mak, pisen hen xalu del len xalu mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Melele xa lapusi, lapolu e sien, e nggeih tamu tengan lake reitin xa be xi iaxai. Misak ni, Iesu misis xil bit, “?Rut anien ti di tak tengan nama ni?” ");
INSERT INTO tvk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma xil lasa rut meseo tei xa meses mini, ");
INSERT INTO tvk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","e Iesu ngguri e ngga ni pe metexil. ");
INSERT INTO tvk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Di, Iesu biteni mi xil bit, “Holesok xil xa testal tehusil xat naha xa natehiteni mi xamim e melele xa nateta tamu visal xamim. E testal minou tengan vasak ni holesok xil xa latetisi usil nou e rae xil na Mosis, tisen xil na provet xil, e sepinien te Sam xil mun mei vahe reitin.” ");
INSERT INTO tvk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Di, misah nenemien nae tengan lalong kil sepinien xil xa di e Vanuvei Eo. ");
INSERT INTO tvk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","E biteni mi xil bit, “Koute te tisen xil ak mak: Mesaea xa Hi tehosei ha ihur longpangasien e imat. Ti, melele xa melengien tol mei itavi, imea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","E, e hisen, moletin xil ha lihithiteni xa Hi iketeh ihos rilomun mi ngan xil vus xa labiles ra tesaen nae xil. Itiamu, lihithiten longeongen hos ak mi moletin xil te hal Serusalem. Ti, ha lihithiteni e rute xil vus te ut etan. ");
INSERT INTO tvk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Xamim xa di mupus holesok xil ak e di mulong sepinien nan ti muhit rati mi mosav xil. ");
INSERT INTO tvk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","!Muteong kuhi! Inou nisa Ninin Eo xa Hi Tata tehit xati tehit isa ni mi xamim. Ve rin ak, xamim mutit inggak e taon te hal Serusalem ituxoh melele xa xeihen na Hi imei ise xat xamim.” ");
INSERT INTO tvk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Di, Iesu del moletin nan xil labe reling taon te hal Serusalem e labe metimal te hal Betani. E rute ak, mitei momal ni hen e misa tuxolxatien mi xil. ");
INSERT INTO tvk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Melele xa di tamu misa tuxolxatien mi xil, Hi nggur rati be reling xil e ngguri be ut nesao. ");
INSERT INTO tvk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Melele xa lapusi mak, lamot mini. Di, del sien, ladilomun labe Serusalem. ");
INSERT INTO tvk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","E melengien xil vus, xil labe vioh te Nim Eo di lasa memesien nae ba mi Hi. ");
INSERT INTO tvk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tetiamu nousav, melele xa Hi tenapeas ni ut nesao mu ut etan ti mu, Vatit Sepinien teta ngamu. Xi xa be Vatit Sepinien teta tetel xat Hi, e xi tehe Hi e rin xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Xi teta tetel xat Hi ngamu e melele xa holesok xil latehe tovuol tamu. ");
INSERT INTO tvk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E texo xi, Hi tepeas ni holesok xil vus. E vahit nave xi ti, ma neta vahe tovuol. ");
INSERT INTO tvk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Vatit Sepinien ak be vatite te meulien. E mei be miehen mi moletin xil tengan lakila lale kil holesok xil vus vaxo en. ");
INSERT INTO tvk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngan xa be miehen ak mileluv e maluxoluken, e ngan xil xa ladi e maluxoluken ak lasakras lanem kila mu laleli. ");
INSERT INTO tvk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hi tesa moletin tei temei, hisen tehe Sion. ");
INSERT INTO tvk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xi temei tengan vahit usil xi xa be miehen ak, e tengan vasak ni moletin xil vus mei laling neketen nae en. ");
INSERT INTO tvk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sion tenave miehen ak ti. E xi temei tengan vahit usil xi xa be miehen ak. ");
INSERT INTO tvk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Reitin, Sion temei tengan vahit usil meien na ngan xa be miehen reitin xa mei ileluv e nenemien na moletin xil vus tengan lile kil reitinen na Hi. ");
INSERT INTO tvk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngan xa be miehen ak temei tete ut etan. E tave ti neta xa holesok xil vus e ut etan latestal latexo xeihen nan, moletin xil te ut etan latnakil ti xi. ");
INSERT INTO tvk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xi temei mi moletin nan xil xati, e moletin nan xil latnahur pilei ti. ");
INSERT INTO tvk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","E ngan xil vus xa latehur pilei e lateneket en, xi tepol ni suse temal tengan mei lihe horamue xil na Hi. ");
INSERT INTO tvk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Xil mei latehe neta hu reitin, e tenaxo rin te pesisen ti xa di mistal nggo eheien mu lingxatien na moletin xil. E xil latemei latehe horamue xil na Hi vengan xa Hi vari tang tehosei xil mei latehe nan. ");
INSERT INTO tvk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Vatit Sepinien ak temei tehe moletin xa ven teta. Xi temei tete visal xir e xamem matepus minehinen te xeihen nan, vengan xa xi be Nat Hi tei takes reitin xa tepolu ni eheien hos e reitinen. ");
INSERT INTO tvk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sion tehit usil xi xa xi be visi tehit, “Moletin ak be ngan xa di natesep usili. Ngan xa natehiteni natehit imei itutou ni nou xa ihe eilep ili nou. Be eilep mili nou vengan xa xi teta ngamu tetiamu nousav, e melele xa nana taling nou ti mu.” ");
INSERT INTO tvk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Xi polu ni eheien hos, ma di duxol xat xir vus holu xa holu pupu mili naha xa momal tengan ravuri. ");
INSERT INTO tvk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Texo Mosis tetiamu, Hi tesa rae nan xil mi moletin xil. E, nggo Iesu Kristo, Hi di pisen eheien hos e reitinen nan mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moletin tovuol tamu iaxa vapus Hi ni meten xati. E moletin xil mei lakil Hi nggo Natneli xa be siskes nan, ngan xa de ri Tamen. ");
INSERT INTO tvk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ngan ak be tumulen usil naha xa Sion Baptis tehit rati usil Iesu. Vatei, vat xil na Siu xil e hal Serusalem lasil rut pris xil del ngan xil xa lastal langgo vatimol na Livae xa di lapol e Nim Eo tengan lava lapus Sion e lasis pilei xa xi be visi. Ma melele xa lastal e rute xa Sion da en lasisi labit, “?Xouk obe visi?” ");
INSERT INTO tvk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E Sion tasin ni ti tengan vasa rilomun ni sepinien nae e bit rati bit, “Inou natave Mesaea ti xa Hi tehit xati tengan isa ni imei.” ");
INSERT INTO tvk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Misak ni, xil lasisi labit, “?Xos imaxai, ma xouk obe visi vari? ?Obe provet Ilaetsa?” E Sion bit rilomun ni mi xil bit, “E‑e, natave xi ti.” Lasisi mun labit, “?Xouk obe Provet xa Mosis tehit lelen ni tehit Hi isa ni imei?” E xi biteni bit. “E‑e.” ");
INSERT INTO tvk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma xil ladakesi labit, “Hit rati li mi xamem xa xouk obe visi tengan mukila muhit mesen ni mi vat namem xil xa lasil xamem mamei tengan makil ti. ?Di obit naha usil xouk tasom?” ");
INSERT INTO tvk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Misak ni, Sion misa sepinien na provet Aesea mi xil xa bit, “Inou nabe rae tei xa di mikei e uruvuol bit, ‘!Musak mesen suse na Suv! !Mupol ni suse nan imal!’” ");
INSERT INTO tvk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Rut moletin xil ak xa latemei, tehe Farasi xil iaxa latesil xil lamei visal Sion. ");
INSERT INTO tvk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","E xil iaxa mei lasis Sion labit, “?Xosxa xouk otave Mesaea ti, mu Ilaetsa ti, mu Provet xa Hi tehit xati ti, veneh ma di obaptaes ni moletin xil?” ");
INSERT INTO tvk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","E Sion bit rilomun ni mi xil bit, “Inou di nabaptaes ni moletin xil del oei tang. E, e hilaep te xamim, moletin tei da ngamu xa xamim mutakil ti. ");
INSERT INTO tvk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xi iaxa imei itutou ni nou xa be eilep mak mu mili inou. E inou natapin ti tengan mei name slev nan tang xa naleh rerat sandel nan.” ");
INSERT INTO tvk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Holesok xil vus ak testal e rute xa Sion di baptaes ni moletin xil en, ist te Oeisal Sodan e sangas visal taon te hal Betani. ");
INSERT INTO tvk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","E melengien sav nen, Sion miketeh ba e pus Iesu di bemei visali. Melele xa pusi, Sion bit rati mi moletin xil bit, “!Mupus ti! Sulut sipsip xa Hi tesila di bemei. Xi iaxa ileh rerat tesaen xil ra moletin xil te ut etan. ");
INSERT INTO tvk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Xi vari be ngan xa natesep usili natehit, ‘Moletin tei imei itutou ni nou e xi ihe eilep mak mu ili nou. Vengan xi teta ngamu e melele xa nana taling nou ti mu.’ ");
INSERT INTO tvk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Melele xa natesep usili, inou mun natnakil kuh ti mu xa xi be visi. E Hi tesil inou tengan namei inggak e nabaptaes ni moletin xil, e napisen xi mi mol‑Isrel xil.” ");
INSERT INTO tvk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Sion biteni mun bit, “Reitin. Tetiamu, inou natnakil ti xa xi be visi. E Hi xa tesil nou namei inggak tengan nabaptaes ni moletin xil vatel oei, xi tehiteni minou tehit, ‘Melele xa upus Ninin Eo imei etan e mei ite moletin tei, xi vari iaxa ihe ngan xa ti ibaptaes ni moletin xil itel Ninin Eo.’ Misak ni, tave nousav ti, natepusi xa xi temei visal inou, e natepus Ninin Eo texo ut nesao e temei texoni mae mei teta kat en. ");
INSERT INTO tvk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Reitin li nabiteni mi xamim xa natepusi ngamu. E di nabit rati mi xamim xa moletin ak vari be Nat Hi reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","E melengien sav nen, Sion dilomun be rute ak del moletin nan lu. ");
INSERT INTO tvk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","E melele xa Sion pus Iesu di mikakao ba, xi bit rati mi moletin xil bit, “?Mupusi? !Ngan ak be sulut sipsip xa Hi tesila temei!” ");
INSERT INTO tvk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Melele xa moletin nan xalu lulong naha xa biteni, luba lunggusil Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","E melele xa Iesu di mikakao ba, xi biles e pus xalu xa di lunggusili. Ma, misis xalu bit, “?Iemil bei naha?” E xalu lubit rilomun ni mini lubit, “Titsa, iemel bei tengan malkil ti xa oda xave.” ");
INSERT INTO tvk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu biteni mi xalu bit, “Mulimei e mulipusi.” Melele xa di latkakao latoba, be mahis ngamu e eai da be tan vuteili. E ludi visal Iesu duxoh vongien. ");
INSERT INTO tvk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tei e xalu xa telong sepinien na Sion e tehusil Iesu, hisen Andru, xa be tua na Saemon Pita. ");
INSERT INTO tvk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","E melele xa misepin del Iesu bus, vatakes, ba pus Saemon Pita e biteni mini bit, “Tuxoli, xamel makamet Mesaea xa Hi tehit xati tengan isa ni imei.” ");
INSERT INTO tvk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Di, Andru del Saemon Pita e lube visal Iesu. E melele xa Iesu pus Saemon, biteni bit, “Xouk obe Saemon, nat Sion. E taxeak iha, hisom ihe Pita.” Koute te Pita be ‘hat.’ ");
INSERT INTO tvk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","E melengien sav nen, Iesu pol ni nenemien nan tengan vahe reling rute xa de sangas ni Oeisal Sodan, e ihe provins te hal Kaleli. Ma, ba mikamet moletin tei xa hisen Pilip e biteni mini bit, “Amei, uhusil inou.” ");
INSERT INTO tvk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip be ngan Betsaeta tei, taon xa Andru xal Pita lutexo en. ");
INSERT INTO tvk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip maen ni e ba milang ni tuneli xa hisen Nataniel. Melele xa mikameti, xi biteni mini bit, “Xamem makamet Mesaea xa Mosis tetis usili e tisen te rae xil, ngan xa provet xil mun latetis usili. Hisen Iesu, nat Siosep te hal Nasaret.” ");
INSERT INTO tvk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Melele xa milong sepinien ak, Nataniel misisi bit, “?Reitin mak? Inou natanem ti xa neta tova vahos vamak mikila vaxo taon votei te hal Nasaret.” E Pilip bit rilomun ni mini bit, “Amei, mei upus ti.” Ma lukakao lube visal Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Melele xa Iesu pus Nataniel bemei visali, bit usili bit, “Ngan ak be moletin tei xa taluvos ti, ngan xa pipin tengan likesi ni ‘ngan Isrel tei.’” ");
INSERT INTO tvk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Melele xa Nataniel milonge mak, misisi bit, “?Xouk okil nou midep?” Iesu bit rilomun ni mini bit, “Natepusuk ngamu e melele xa di tamu otetotan pe mamel te vatit fik, e melele xa Pilip tenavat ti mu tengan vakes xouk.” ");
INSERT INTO tvk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel mesep pupu e biteni mini bit, “!Titsa, xouk obe Nat Hi reitin! !Xouk obe suv toto te hal Isrel xa di madatili!” ");
INSERT INTO tvk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu biteni mini bit, “Xouk oneket e nou vengan xa nabiteni tang minuk xa natepusuk melele xa di tamu otetotan pe mamel te vatit fik. E navehi ti, upus holesok savsav xil xa lihe tellep mak mu mili ngan ak. ");
INSERT INTO tvk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Reitin li nabiteni minuk xa upus tilang hat imesel e masxaxa na Hi xil ti likakao lihe nesao e limei etan lixo nou, Nat Moletin, ixoni ngan xa nabe suse tei.” ");
INSERT INTO tvk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Melengien lu mei mitavi. E, e melengien tol nen, moletin xil te metimal te hal Kena xa de provins te hal Kaleli lapol ni anien te tetelien tei. Nine Iesu tehe xil lateti e tetelien ak. ");
INSERT INTO tvk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","E latesilasil mun teha mi Iesu tetel moletin nan xil tengan mei lianien itel xil e tetelien ak. ");
INSERT INTO tvk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Melele xa di langganien, nine Iesu milongeong ni xa uaen tovuol mun tengan lasa ni mi moletin xil. Misak ni, be visal Iesu e biteni mini bit, “Uaen mae tovuol mun. Ututou ni xil li.” ");
INSERT INTO tvk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E Iesu bit rilomun ni mini bit, “Nana, rin naralu tovuol en. Melele xati tengan nipisen ni mi moletin xil xa nabe visi tamei ti mu.” ");
INSERT INTO tvk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E ninen be visal moletin te polien xil e biteni mi xil bit, “Mupol sen holesok xil xa xi ihiteni mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","E rin tei, Iesu pus valoei tei e he sav (6) xa eilep xa Siu xil lase oei ba en tengan likila likas moten holesok nae xil ni mei imese ihusil rae na Siu xil. Xil kekes pipin tengan lise oei iha en ihe lita handred tei (100). ");
INSERT INTO tvk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Melele xa Iesu pusi, biteni mi moletin te polien xil bit, “Muse xat valoei xil xa latellep xiak ni oei.” Ma, lase xat xil mei lapolu duxoh vulongexil nesao. ");
INSERT INTO tvk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lapol ni bus, Iesu biteni mi xil bit, “Muhutih ti oei ak ni kap tova. Ti, ha musa ni mi vat te anien ak tengan imu pisi.” Ma, lapol ni nggoni ngan xa xi biteni. ");
INSERT INTO tvk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","E melele xa vat ak mu pis oei ak, mu ni be uaen e takil ti xa nggo xave. E moletin te polien xil xa latehutih oei ak lakila. Ma, vat ak mikes moletin xa miteli ");
INSERT INTO tvk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e misepin bos mini bit, “Mosav xil xa lapol ni anien tei xa eilep, diamu, lasa uaen hos xa mani nen nggeih mi moletin xil. E melele xa moletin xil latalang holu, xi misa uaen sung xa tavos kuhi ti mi xil. E xouk, oling kuh uaen xil xa bos tengan ukila usa ni mi xamem sung itutou.” ");
INSERT INTO tvk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Misak ni, e taon te hal Kena e provins te hal Kaleli, Iesu tepisen kokot ni xa xeihen da en nggo merekel ak. E melele xa moletin nan xil lapus xeihen nan, laling neketen nae en. ");
INSERT INTO tvk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Melele xa tetelien bus, Iesu, ninen, tuneli xil, del moletin nan xil labe taon te hal Kapaniam. E ladi rute ak melengien vahis. ");
INSERT INTO tvk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Melele te Anien te Tavien bemei sangas, Siu xil holu labe Serusalem tengan lasa sanien eo xil teni e Nim Eo. Misak ni, Iesu mun ba del moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E melele xa Iesu be vioh te Nim Eo, mikameti xa moletin xil holu di lapos ni buluk, sipsip, e tuman xil tengan lave sanien eo. E moletin xil holu ladotan lade tep nae xil e di laso papas mani na moletin xil. ");
INSERT INTO tvk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Melele xa Iesu pus holesok xil xa moletin xil ak di lapol ni, ien mikat pupu. Ma, mileh mavulut ao vutei xa ladi e tan, minggil viton ni mei be teviei e nggeih, e minggol rerat ngan xil vus ak ra vioh te Nim Eo, del buluk e sipsip sae xil mun ni ao ak. Di, Iesu midivin rerat tep na ngan xil xa di laso papas mani e mani nae xil mikora lel be tan. ");
INSERT INTO tvk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","E mi ngan xil xa di lapos ni mae xil tengan vahe sanien eo xil, Iesu bul xat xil bit, “!Muleh holesok namim xil ak muhaha! !Munapol ni nim ma Tata navan ti mei nahe nim te posen!” ");
INSERT INTO tvk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Melele xa moletin nan xil lapus naha xa Iesu tepol ni, xil lanem xati xa Vanuvei Eo biteni bit, “O Hi, vengan xa di namerere ni Nim mam holu, ieok nggat pupu ni ngan xil xa latamerere ni ti.” ");
INSERT INTO tvk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","E melele xa vat xil na Siu xil lapus naha xa Iesu tepol ni, lamesep pupu e lasepin nggeih mini labit, “?Visi iaxa maen xouk tengan opol ni holesok xil ak? Xosxa be reitin xa xouk onggur xeihen pipin tengan opol ni vamak, ma upol ni merekel tova mapusi.” ");
INSERT INTO tvk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma Iesu bit rilomun ni mi xil bit, “Xosxa muhu len Nim Eo ak, inou nipet rilomun ni e melengien ihe tol (3) tang.” ");
INSERT INTO tvk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Vat xil ak latemanin ni sepinien nan labit, “!Iva! Moletin xil latepol huram hanutap lu e tei e he sav mun (46) tengan lapol pilei Nim Eo ak. E xouk obit ukila upet rilomun ni e melengien ihe tol tang. !E‑e, osakras!” ");
INSERT INTO tvk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","E melele xa Iesu misep usil Nim Eo ak, di misep usil tenben. ");
INSERT INTO tvk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E tetutou sung, e melele xa temea rilomun ra maten, moletin nan xil latenem rilomun ni sepinien nan, e lateneket e naha xa tehiteni e naha xa Vanuvei Eo tesep usili. ");
INSERT INTO tvk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Melele xa Iesu da tamu e Serusalem e melele te Anien te Tavien, moletin xil holu lapus merekel xil xa di pol ni e laling neketen nae en. ");
INSERT INTO tvk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","E Iesu take reitin ti xa neketen nae en be reitin vengan xa xi minem kil naha xa di nenemien na moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Moletin ti tavit kila mini, e xi minem kil holesok xil vus xa moletin xil di lanem usili e di iexil bei. ");
INSERT INTO tvk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","E taon te hal Serusalem, Farasi tei da en xa be tei e ngan xil xa ladi e Kaonsel na Siu xil, hisen Nikodimas. ");
INSERT INTO tvk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E vongien tei, xi ba tengan vasepin vatel Iesu e biteni mini bit, “Titsa, xamem makila xa xouk obe titsa tei xa Hi tesila tengan imei. Makila vengan vahit Hi nata ti natel xouk, ma osakras opol ni merekel xil ak.” ");
INSERT INTO tvk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","E Iesu bit rilomun mini bit, “Reitin li nabiteni minuk, xosxa moletin tei tenamei ti tenave neta hu rilomun, ma xi misakras mei vate pe lelaxatien na Hi.” ");
INSERT INTO tvk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Melele xa Nikodimas milonge mak, xi mitemanin e biteni bit, “?Moletin tei xa mahulong ngamu mei ihe neta hu rilomun itep? !Vengan xa moletin misakras vatilomun vahe vang ninen vatei mun tengan valingi mei vahe neta hu rilomun!” ");
INSERT INTO tvk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Misak ni, Iesu bit rilomun ni bit, “Reitin li nabiteni minuk, moletin xa tave neta hu ti vatel oei e Ninin Eo, xi misakras mei vate pe lelaxatien na Hi. ");
INSERT INTO tvk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Melele xa lapes moletin tei mei be neta hu nggusil suse na moletin xil, xi nggur tenbe moletin e sexien nan mei nggoni moletin tei tang. E melele xa moletin tei mei be neta hu nggusil suse na Ninin Eo, xi nggur ninin e sexien nan mei nggoni Ninin. ");
INSERT INTO tvk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Munatemanin ti xa nabiteni mi xamim xa xamim vus mei muhe neta hu rilomun. ");
INSERT INTO tvk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Polien na Ninin Eo nggoni polien te votiang xa di misisi nggusil nenemien nan. Xamim mukila mulong kil votiang, e mutakil ti xa nggo xave bemei mu di ba xave. Usil sexien nen tak, musakras mupus Ninin Eo. E mukila mupus kil polien nan e meulien na ngan xil xa xi mei mise xat xil e misak ni xil mei labe neta hu rilomun.” ");
INSERT INTO tvk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","E Nikodimas misisi bit, “?E netak mikila istal itep?” ");
INSERT INTO tvk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Iesu bit rilomun mini bit, “Xouk obe titsa tei na mol‑Isrel xil. ?Veneh ma otakil ti koute te sepinien navan xil? ");
INSERT INTO tvk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nabiteni reitin minuk xa inou del ngenok xil di mabit usil holesok xil xa makila ngamu, e di mabit rat naha xa matepusi tuei. E xamim vat xil na Siu xil mutake reitin ti e sepinien namem. ");
INSERT INTO tvk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Xouk otake reitin ti e sepinien navan melele xa nabit kila nggo holesok xil ak te ut etan. ?Mak, ma ukila uke reitin e sepinien navan xil itep xosxa nisep usil holesok xil te ut nesao? ");
INSERT INTO tvk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Inou, Nat Moletin, nakila nasepin usili vengan xa inou natexo ut nesao e namei e ut etan ak. E moletin tovuol mun vahe ut nesao. ");
INSERT INTO tvk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Tetiamu, e melele xa Mosis tete uruvuol, tepol ni tetal tei ni aean brons e teti xati tete liei tei e tepet rati tehe nesao. E ixo sexien nen ak, liti xat Nat Moletin ite liei tei e lipet rati ihe nesao. ");
INSERT INTO tvk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","E ngan xil vus xa lineket en lihur meulien sal. ");
INSERT INTO tvk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","E vengan xa eheien na Hi di e moletin xil vus te ut etan holu xa holu pupu, xi temaen xoteh meulien na Natneli xa be siskes nan tengan ngan xil vus xa laneket en lasakras lakesae, e ha lihur meulien sal sung. ");
INSERT INTO tvk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hi tenasa Natneli ti tenamei e ut etan tengan valepis rin na moletin xil e vasa pangasien mi xil ve sexien tesa nae xil. E‑e, Hi tesa Natneli temei tengan vahe suse xa iteh meulien na moletin xil te ut etan ixo en. ");
INSERT INTO tvk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ngan xil xa laneket e Nat Hi, Hi nasa pangasien ti mi xil. E ngan xil vus xa lataneket ti en, xil lalihi pangasien na Hi bemei e xil ngamu, vengan xa lataneket ti e Natneli xa be siskes nan. ");
INSERT INTO tvk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hi tesa miehen nan ngamu temei e ut etan. E moletin xil lasin ni e iexil bei maluxoluken mak mu mili miehen nan, vengan xa sexien nae misa. Misak ni, xi ilepis rin na moletin xil ihusil naha xa lapol ni del miehen ak. ");
INSERT INTO tvk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ngan xil vus xa di lapol ni tesaen, iexil di nggat miehen. E xil latava ti visal miehen ak vengan xa iexil ti tavei tengan miehen ak vapisen rat sexien nae xil xa lakavui. ");
INSERT INTO tvk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","E ngan xil xa langgusil suse te reitinen labe visal miehen xa ileluv kuhi xa sexien nae xil di nggusil naha xa Hi ien bei.” ");
INSERT INTO tvk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Melele xa Iesu misepin bus, ba be rute tei e provins te hal Sudea xa da sen nga tang. De rute ak del moletin nan xil e di baptaes ni moletin xil xa lamei visali. ");
INSERT INTO tvk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","E, e rute sav xa lakesi ni Aenon, Sion Baptis mun di baptaes ni moletin xil holu xa lamei visali vengan xa oei holu di e rute ak. Rute ak de provins te hal Sameria, sangas visal taon te hal Salim. ");
INSERT INTO tvk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","E melele nen ak, latnaso Sion ti mu vahe nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","E melele xa Sion de rute ak, Siu tei bemei visal moletin na Sion xil. Xi mingor del xil usil sexien eah xa momal tengan moletin tei ikas moten tenben imese ixo en tengan mei imal pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Misak ni, xil labe visal Sion e labiteni mini labit, “?Titsa, onem xat moletin xa otepisen ni mi xamem e seri Oeisal Sodan, ngan xa otehit rati otehit xi be Mesaea? !Xi mun di baptaes ni moletin xil, e, taxeak, moletin xil vus di labe visali sung!” ");
INSERT INTO tvk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sion bit rilomun ni bit, “Moletin tovuol xa mikila vahur polien tei xosxa Hi te ut nesao tamaen ni ti. ");
INSERT INTO tvk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xamim vari mutelong sepinien navan e melele xa natehiteni natehit inou natave Mesaea ti xa Hi tehit xati tengan isa ni imei. E Hi tesil nou tengan mei nisak mesen suse nan. ");
INSERT INTO tvk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iesu nggoni tiramue tei xa mei iteli itel atou tei. E atou ak be nan xati. E inou nanggoni tuneli tei xa di nadatili tengan nisoh e rin e nilong sepinien xa xi ihit rati. E melele xa tiramue xa iteli bemei, tuneli di besi xi holu melele xa milong raen. Ma, inou nabesi nou mak vengan xa Mesaea bemei ngamu tengan vahur voninen xati. ");
INSERT INTO tvk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Momal xa xi mei ihe nesao mak mu, e inou nihe etan mak mu.” ");
INSERT INTO tvk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sion biteni mun bit, “Iesu nggo ut nesao e be eilep mak mu mili holesok sav xil vus. Ngan xil xa langgo ut etan labe te ut etan tang, e di lasepin nggoni moletin xil te ut etan. E ngan xa nggo ut nesao bemei be eilep mak mu mili xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Xi di misepin usil holesok xil xa pusi e miteong ni e ut nesao, e moletin xil latake reitin ti e sepinien nan. ");
INSERT INTO tvk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","E ngan xil vus xa lake reitin e sepinien nan lakil kuhi xa naha xa Hi di biteni be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Reitin, ngan xa Hi tesila tengan imei di misa sepinien xati na Hi, vengan xa Hi mise xat kuh meulien nan ni Ninin Eo nan. ");
INSERT INTO tvk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Hi Tamer, eheien nan di e Natneli, e di misa rat holesok nan xil vus de pe hen. ");
INSERT INTO tvk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mak, ma ngan xil vus xa laneket e Nat Hi lihur meulien sal. E ngan xil xa lasin ni linahur ti meulien, vengan ekaten na Hi di xat xil e litit ni ngan taxa ti lihur pangasien ven.” ");
INSERT INTO tvk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","E melele nen ak, longeongen ba duxoh Farasi xil xa moletin xil holu di langgusil Iesu mili ngan xil xa di langgusil Sion. E lalongeong ni mun xa Iesu di baptaes ni moletin xil holu mili ngan xil xa Sion di baptaes ni xil. ");
INSERT INTO tvk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","E ngan ak tave reitin ti vengan tave Iesu ti iaxa di baptaes ni xil, be moletin nan xil iaxa di lapol ni. ");
INSERT INTO tvk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","E melele xa Iesu milong kila xa Farasi xil lalongeong ni usil polien nan, xi be reling provins te hal Sudea, e dilomun be provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Usil suse nae tengan lave Kaleli, Iesu del moletin nan xil laka pas provins te hal Sameria xa de hilaep te provins xalu ak. ");
INSERT INTO tvk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E melele xa di lakakao laba, laduxoh taon tei na mol‑Sameria xil, ngan xa lakesi ni Saekar. Saekar de sangas visal tan tei xa avu Siekob tesa ni mi natneli Siosep tetiamu. ");
INSERT INTO tvk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","E rute ak, vulut oei tei da xa avu Siekob vari tehili. Melele xa Iesu del moletin nan xil laduxoh vulut oei ak be piniae, e Iesu milonge ven memel e ba dotan visal vulut oei ak tengan vangel ti mu. ");
INSERT INTO tvk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","E melele xa di mingel, moletin nan xil labe taon tengan lalang ni ti anien ae. Tave nousav ti, ate‑Sameria tei bemei tengan vahutih oei. Melele xa mei duxoh vulut oei ak, Iesu misisi bit, “Sa ti oei li minou namu ni.” ");
INSERT INTO tvk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","E atou ak bit rilomun ni mini bit, “Xouk obe Siu tei e inou nabe ate‑Sameria tei. E Siu xil lasakras lavanien vituei e pelet tei takes mu lamun vituei e kap tei takes vatel xamem. ?Ma, veneh ma osis nou tengan nisa ti oei minuk umu ni?” ");
INSERT INTO tvk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu bit rilomun mini bit, “Xouk otakil ti sanien hos xa Hi bit vasa ni minuk. E otakil ti xa inou xa di nasis oei minuk nabe visi. Vengan xa vahit okila, ma osis nou ve oei te meulien e nisa ni minuk.” ");
INSERT INTO tvk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma atou ak biteni mini bit, “E suv, valoei nam tovuol, e vulut oei ak be tan xa be tan vari. ?Ma, obit uhur oei te meulien ak ixo xave? ");
INSERT INTO tvk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","?Midep? ?Oei xa di obit usili bos mak mu mili oei ak? Vengan xa avu Siekob vari iaxa tesa vulut oei ak mi xamem. E tehe oei ak xi temu ni, natneli xil latemu ni, e buluk tetel sipsip san xil mun latemu ni. ?Ma midep, di obiteni xa xouk obe eilep mak mu oli avu Siekob?” ");
INSERT INTO tvk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu bit rilomun ni bit, “Ngan xil vus xa lamu oei ak, meruru iat rilomun ni xil. ");
INSERT INTO tvk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","E ngan xil xa limu oei xa inou nisa ni mi xil, meruru naxat ti mun xil. Oei xa nisa ni mi xil mei ihe oeisal tei xa ti ileh e tinexil e isa meulien sal mi xil.” ");
INSERT INTO tvk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Atou ak biteni mini bit, “!Suv, sa ti oei ak minou li! Imak, ma meruru naxat nou ti mun, e ninakakao ti mun ninamei inggak vehakut tengan nihutih oei.” ");
INSERT INTO tvk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu biteni mini bit, “Ha ukes tiramue nam, ti multilomun mulimei.” ");
INSERT INTO tvk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Atou bit rilomun ni mini bit, “Tiramue navan tovuol.” E Iesu bit rilomun ni mini bit, “Xouk obiteni reitin melele xa obit tiramue nam tovuol. ");
INSERT INTO tvk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vengan xa, e meulien nam, xouk oteteli tetel tiramue lim (5) ngamu. E moletin xa oda vituei dela xosali, otateli ti vatela. Ma, naha xa otehiteni minou be reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Melele xa atou ak milonge mak, mesep pupu e biteni bit, “Suv, napus kila xa xouk obe provet tei. ");
INSERT INTO tvk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","?Mak, ma uhit kila mu minou, rute xave iaxa momal tengan moletin xil ha limot mi Hi en? Vengan xa avu namem xil tetiamu, latemot mi Hi inggak e Vathu Kerasim. E xamim, Siu xil, mubit Serusalem be rute xa momal tengan moletin xil vus ha limot mi Hi en.” ");
INSERT INTO tvk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E Iesu biteni mini bit, “Reitin li nabiteni minuk, melele tei di bemei xa nave ti neta xosxa moletin tei imot mi Hi Tamer e vathu ak mu e Serusalem mu e rute sav tova. ");
INSERT INTO tvk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xamim, mol‑Sameria xil, di mumot mi Hi e mutakil kuhi ti. E xamem, Siu xil, mamot mi Hi e makila. Vengan xa Hi tesa hitxatien mi Siu xil xa isa Mesaea nan imei, ngan xa iteh meulien e moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","E melele tei di bemei xa ngan xil xa labe reitin del Hi Tamer ti limot mini itel xeihen na Ninin Eo ixo sexien xil xa ihe reitin. Melele ak bemei ngamu. E Hi di milang ves hisit moletin xil ak tengan lamot mini. ");
INSERT INTO tvk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hi be ninin e tahur ti tenben vaxoni xir. Ma, momal tengan ngan xil xa lamot mini lipol ni itel xeihen na Ninin Eo e ihusil sepinien te reitinen nan.” ");
INSERT INTO tvk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Atou ak biteni mini bit, “Nakila xa Hi tehit xati xa isil Mesaea nan imei. E melele xa imei, xi ihit kil holesok xil vus mi xamem.” ");
INSERT INTO tvk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu bit rilomun ni bit, “Inou xa di nasepin minuk, inou nabe xi.” ");
INSERT INTO tvk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","E melele nen tak, moletin xil na Iesu ladilomun, e lamesep pupu melele xa lapus Iesu di misepin del atou ak vengan xa tahusil sexien nae ti. E tovuol e xil vasis atou ak vahit, “?Iem bei naha?” mu vasis Iesu vahit, “?Veneh ma di osepin del atou ak?” ");
INSERT INTO tvk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Di, atou ak be reling valoei nan da nga, dilomun be taon, e ba mikes moletin xil lamei e bit, ");
INSERT INTO tvk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“!Mumei mupus ti moletin xa bit lelen holesok xil vus xa natepol ni e meulien navan! Xos xi be Mesaea xa Hi tehit xati tengan isila imei.” ");
INSERT INTO tvk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma, moletin xil holu labe reling taon tengan ha lipus Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Melele xa atou ak teta tamu e taon, moletin xil na Iesu labiteni mini labit, “Titsa, amei a rut anien xil ak.” ");
INSERT INTO tvk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","E xi bit rilomun ni mi xil bit, “Anien tei avan da xa xamim mutakil ti.” ");
INSERT INTO tvk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Melele xa lalonge mak, xil lasis xil mun tang labit, “?Midep xiak? ?Moletin tova tesa anien tuei mini tea ni?” ");
INSERT INTO tvk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Misak ni, Iesu biteni mi xil bit, “Melele xa nanggusil nenemien na Hi xa tesil inou namei tengan nipol vuol ni polien nan, nateong ni nggoni ngan xa nangganien ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Moletin xil di labiteni labit, ‘Aveti hat (4) mei itavi e rileh rerat anien ar.’ E inou nabiteni mi xamim nabit muketeh kuhi ikapis e naho sa Hi. Anien teni men ngamu tengan lalehi. ");
INSERT INTO tvk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","E ngan xil vus xa di laleh viton anien xil teni, Hi di miling kuh huit polien nae iti. E anien ak be moletin xil xa di langgur meulien sal. Ma, ngan xil xa lalih utut sepinien na Hi e meulien na moletin xil e ngan xil mun xa di laleh viton anien xil teni, xil vus lihesi xil pupu ve naha xa di lapol ni. ");
INSERT INTO tvk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ngan ak nggoni sepinien te metisouen xa biteni bit, ‘Moletin tei milih naho tei, e moletin sav mileh viton anien teni.’ ");
INSERT INTO tvk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inou nasil xamim tengan ha muleh viton anien ixo naho tei xa moletin sav xil ba latepol en tetiamu ni xamim. E ihe xamim iaxa ti mupus huite te polien nae.” ");
INSERT INTO tvk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Melele xa Iesu di tamu misepin mi moletin nan xil, mol‑Sameria xil holu langgo taon lamei. Lamei e lake reitin en vengan xa latelong sepinien na atou xa tehiteni tehit, “!Mumei mupus moletin xa bit lelen holesok xil vus xa natepol ni e meulien navan!” ");
INSERT INTO tvk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Misak ni, melele xa lamei, ladakes Iesu tengan vate visal xil. Ma, Iesu del moletin nan xil ladi visal xil melengien lu mun. ");
INSERT INTO tvk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E melele xa mol‑Sameria xil lalong sepinien na Iesu, xil holu mun lake reitin en. ");
INSERT INTO tvk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma, laba e labiteni mi ate‑Sameria ak labit, “Tetiamu, mateke reitin e xi ve naha xa xouk otehiteni. E taxeak, make reitin xa xi be Mesaea xa iteh meulien e moletin xil vus te ut etan vengan xa di malong sepinien nan ni vurangemem xati vari.” ");
INSERT INTO tvk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Ngan ak nggoni ngan xa Iesu vari tehiteni tehit, “Provet tei, tave ti neta xa moletin sav xil di lamerere ni, e moletin xil te kantri nan xati latamerere ni ti.” E melele xa de visal xil melengien lu bus, Iesu del moletin nan xil laba sung labe provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Melele xa Iesu duxoh provins te hal Kaleli, moletin xil holu te rute ak langgur pilei. Holu e xil latetilomun ra Anien te Tavien e hal Serusalem e latepus holesok xil xa Iesu tepol ni en. Ma, mol‑Kaleli xil iexil bei tengan lapus ti Iesu vapol ni holesok xil ak e ut sae mun. ");
INSERT INTO tvk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu mikakao duxoh metimal te hal Kena, rute xa tehiles oei mei tehe uaen en. E metimal ak, eilep tei na suv toto Herod nggur longeongen xa natneli xa de taon te hal Kapaniam mesei pupu. ");
INSERT INTO tvk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Melele xa eilep ak milonge xa Iesu nggo provins te hal Sudea e bemei ngamu e provins te hal Kaleli, xi be visali e dakesi tengan vahe xalu lalohe Kapaniam tengan vahur rat mesien ra natneli xa sangas vamat. ");
INSERT INTO tvk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu biteni mini bit, “!Iva! Vehakut, xamim di mudakes nou ve merekel xil mu neta tova mun xa eilep. E xosxa natapol ni ti, ma xamim di mutake reitin ti e nou.” ");
INSERT INTO tvk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","E eilep ak biteni mini bit, “O suv li, ralotemanon raloha tengan natuxoli namat ti.” ");
INSERT INTO tvk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","E Iesu biteni mini bit, “Husil suse nam uha. Horamue nam milonge bos tuei.” Melele xa eilep ak milong naha xa Iesu biteni, xi mike reitin en e nggusil suse nan ba. ");
INSERT INTO tvk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Melengien tei mei mitavi, e melele xa eilep ak da tamu e suse nan, rut moletin xil te polien nan xa langgo Kapaniam mei labisu mini. Xil labiteni mini labit, “Natumali milonge bos tuei.” ");
INSERT INTO tvk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Melele xa eilep ak misis xil tengan lihit kil melele xati vari iaxa latepus horamue nan telonge tehos en, xil labit rilomun ni mini labit, “Horamue nam, ven tean pupu tetuxoh wan klok piniae. Di, mesien nan tehe relingi e telonge tehos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Melele xa labiteni mak, eilep ak minem kila xa ngan ak mistal e melele xati vari xa Iesu tehiteni mini xa horamue nan milonge bos tuei. Ma, xi del ngenen xil vus e nim man lake reitin e Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngan ak be merekel xa be lu nen xa Iesu tepol ni e provins te hal Kaleli, melele xa tetilomun ra provins te hal Sudea. ");
INSERT INTO tvk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","E melengien sav tei, Iesu dilomun be taon te hal Serusalem vengan xa mol‑Isrel xil di laba tengan lapus melengien eo tei nae en. ");
INSERT INTO tvk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","E melele xa Iesu duxoh taon, xi mikakao be sangas visal vangoei tei xa lakesi ni Betsaeta. Rute ak tave sotin ti ra puiteh xa lakesi ni Puiteh te Sipsip xil, e horao lim (5) iaxa mikapis xol oei ak. ");
INSERT INTO tvk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","E vangit horao xil ak, vanut moletin xa eilep xa lamesei ladi en: ngan xil xa metexil bar, ngan xil xa lasakras lakakao, e ngan xil mun xa rut tenbexil misa. ");
INSERT INTO tvk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Moletin tei xa di mesei de rute ak. E mesien nan tehasi huram hanutap tei e tol e le sav mun (38). ");
INSERT INTO tvk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Melele xa Iesu pus moletin ak pat da, xi mikila xa xi tepat temak tehe nousav pupu. Ma, be visali e misisi bit, “?Iem bei tengan olonge vahos rilomun?” ");
INSERT INTO tvk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","E moletin ak bit rilomun mini bit, “Suv, moletin tovuol xa mikila vatutou ni nou name vangit oei melele xa oei nggururi vengan melele xa nasak tengan ha naxul en, moletin sav tei diamu ni nou e ba minggul en.” ");
INSERT INTO tvk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E Iesu biteni mini bit, “!Utamea! Uleh rong mam e ukakao uha.” ");
INSERT INTO tvk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vatakes, tenbe moletin ak mei bos rilomun. Ma, mitamea, mileh rong man e mikakao ba. Ngan ak testal e Sabat. ");
INSERT INTO tvk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Melele xa moletin xa Iesu pol ni milonge bos di mikakao ba, vat xil na Siu xil lapusi e labul xati labit, “!Ei, be Sabat xosali! Rae nar biteni xa tamal ti tengan oleh rong mam xosali.” ");
INSERT INTO tvk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","E moletin ak bit rilomun mi xil bit, “Moletin xa pol ni tenbeok mei bos rilomun iaxa biteni minou bit nileh rong mavan e nikakao niha.” ");
INSERT INTO tvk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Xil lasisi labit, “?Visi iaxa tehiteni minuk tengan opol ni vamak?” ");
INSERT INTO tvk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","E moletin ak takil ti. Vengan melele xa tetamea, tepusi xa Iesu tekesae ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tave nousav ti, Iesu be vioh te Nim Eo. E melele xa di mikakao en, mikamet moletin ak e biteni mini bit, “?Opusi? Xouk olonge bos ngamu. E uxuxou kuhi xa onapol ni ti mun tesaen. Vengan, vahit vamak, ma xos neta tova sung xa isa pilei mak mu mei ipurun xouk.” ");
INSERT INTO tvk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Di, moletin ak ba, milang ni vat na Siu xil ak, e biteni mi xil xa moletin xa tepol ni ven mei tehos rilomun, hisen Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Melele xa vat xil ak lakil visi iaxa tepol ni moletin ak telonge tehos e Sabat, xil mei lasak purun Iesu holu mak mu. ");
INSERT INTO tvk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E melele xa lasepin misa ve naha xa di pol ni, Iesu bit rilomun ni mi xil bit, “Tata navan xa de ut nesao di pol vehakut, ma inou mun di napol vehakut nggoni xi.” ");
INSERT INTO tvk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sepinien ak misak ni vat xil ak mei iexil nggati pilei sung e lapol ni nenemien nae tengan lavasi vamat. Vengan xa, e nenemien nae, Iesu di nggur xoteh rae te Sabat. E, ngan xa misa mak mu, xi di po rat xi mei be nesao mu bit xi pipin ni Hi, vengan di biteni bit Hi be Tamen xati. ");
INSERT INTO tvk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Melele xa Iesu mikila xa vat na Siu xil ak iexil nggati vengan biteni bit Hi be Tamen xati, biteni mi xil bit, “Reitin li nabiteni mi xamim, natneli tei tapol ni ti neta vahusil nenemien nan tasen tang. E di pol kes ni naha xa di pus tamen di pol ni. Mak iaxa, inou xa nabe Nat Hi di napol nggusil Tata navan tang. ");
INSERT INTO tvk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nakila napol ni mak vengan xa Tata navan, eheien nan di e inou, e di pisen holesok xil xa tellep minou xa xi di pol ni. E xi ipisen ni minou holesok xil xa tellep mak mu xa inou ti nipol ni xa ili ngan xa mutepus inou natepol ni ngamu, e isak ni xamim ti mumesep ven. ");
INSERT INTO tvk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Reitin mak, vengan xa e hisit sexien xa Tata navan mikila vasak ni moletin tei vamea rilomun ra maten e vasa meulien mini, inou mun xa nabe Natneli nikila nisa meulien mi ngan xil xa ieok bei tengan nisa ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E rin sav mun, Tata navan di talepis rin na moletin xil ti, e xi miling polien ak de heok tengan ti nilepis rin na moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tata navan pol ni mak tengan vasak ni moletin xil vus lamerere ni nou xa nabe Natneli vaxo hisit sexien xa di lamerere mini. E ngan xil xa di latamerere ni nou ti xa nabe Natneli, ma xil di lapisen ni xa latamerere ni Tata navan ti xa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Reitin li nabiteni mi xamim, ngan xil vus xa lalong sepinien navan e lake reitin xa Hi tesa inou namei, xil vari iaxa lihur meulien sal. Ngan xil ak, Hi nalepis ti mun rin nae tengan vasa pangasien mi xil. Ngan xil ak lameluv ngamu ra xeihen te maten, e langgur meulien xa misakras vavus. ");
INSERT INTO tvk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Reitin li nabiteni mi xamim, melele tei di bemei xa ngan xil xa lalel tuei lilong rae Nat Hi e limea rilomun ra maten limeul. Reitin, melele ak bemei ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tata navan be vatit meulien. E usil rin tak, xi misak ni nou, Natneli, tengan mei nabe vatit meulien xa nakila nasa meulien mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E, vengan xa inou nabe Nat Moletin, Tata navan misa xeihen minou tengan nilepis rin na moletin xil e nisa pangasien mi xil ihusil sexien nae xil. ");
INSERT INTO tvk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Munatemanin ti ve sepinien navan xil. Vengan melengien tei di bemei sangas xa ngan xil xa lalel tuei liteong ni raeok. ");
INSERT INTO tvk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","E melele xa lilonge, xil limea ra von tehinen nae. Ngan xil xa latepol temal e meulien nae, xil limea rilomun ra maten e lihur meulien xa hoxalite teni ihe tovuol. E ngan xil xa latepol tenamal ti, xil limea rilomun ra maten e ha lihur pangasien xa hoxalite teni ihe tovuol.” ");
INSERT INTO tvk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E Iesu biteni mun mi xil bit, “Inou, natapol ni ti neta vahusil nenemien navan tasok. Melele xa nalepis rin tei, nenemien navan xil di nggusil naha xa Hi di biteni minou. Reitin, naha xa nabiteni momal vengan xa natasa ni ti vahusil nenemien navan, e di nasa naha taxa Hi Tata navan ien bei, ngan xa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Vahit inou tang iaxa ti nabit rat neta tei usil inou tasok, ma vamal tang tengan munake reitin ti en. ");
INSERT INTO tvk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","E vengan xa Tata navan di bit rati xa nabe visi, momal tengan muke reitin e nou, vengan nakila xa sepinien nan usil nou be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","E melele xa mutesil moletin namim xil tengan lava lapus Sion Baptis, naha xa xi tehit rati usil nou be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","E, e rin navan, inou nataling nenesien navan ti vate naha xa moletin xil te ut etan ak di labit rati usil nou. E di nasep usil sepinien xa Sion tehiteni usil inou tengan xamim mukila muke reitin en e Hi iteh meulien e xamim ixo en. ");
INSERT INTO tvk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Vengan xa Sion temei texoni laet tei xa tepili e teleluv kuhi ve holesok xil. E, vuteili tang, xamim mutehesi xamim tengan muteti e miehen te pispisien nan. ");
INSERT INTO tvk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“E neta tei di bit rati mak mu xa nabe reitin mili naha xa Sion tehit rati usil inou. Polien xil xa Tata tesa ni minou tengan napol ni, xil di lasepin e rin navan labit rati xa inou nabe Nat Hi reitin. Reitin, polien navan xil di lapisen ni xa Tata vari iaxa tesil inou namei. E inou nipol vuol ni naha xa xi telingi tete heok tengan ti nipol ni. ");
INSERT INTO tvk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","E Tata xa tesil inou namei, xi mun di bit rati xa inou nabe reitin. E xamim mutnalong ti mu raen e mutnapus ti mu valnaon. ");
INSERT INTO tvk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Di mupisen ni xa sepinien nan tara ti e meulien namim, vengan xa mutake reitin ti e nou xa xi tesil nou. ");
INSERT INTO tvk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Xamim di musak tengan mulang ves reitinen nggo sepinien xil te Vanuvei Eo vengan xa di munemi mubit mukamet meulien sal ixo en. E sepinien nen ak vari tang di bit rat reitinen usil inou. ");
INSERT INTO tvk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E tave ti neta xa mak, xamim mupol ni nenemien namim tengan munamei ti visal nou tengan muvur meulien sal vaxo inou. ");
INSERT INTO tvk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Tave ti neta e nou xosxa moletin xil lisa memesien minou mu linasa ni ti. ");
INSERT INTO tvk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","E nakil xamim, e nakila xa eheien na Hi tovuol e meulien namim. ");
INSERT INTO tvk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tave ti neta xa namei e his Tata navan, xamim mutahur pilei nou ti. E vahit moletin tova vamei e hisen tasen tang, xamim muvur pilei vari. ");
INSERT INTO tvk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xamim di mupol ni holesok xil tengan mukila musa memesien mi xamim mun tang. E mutapol ni ti holesok xil tengan mukila muvur memesien vaxo Hi vari. Misak ni, natamesep ti xa mutake reitin ti e nou. ");
INSERT INTO tvk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“E munanemi ti munahit ihe inou iaxa nisa sepinien iha xat rin namim e melele xa musoh pe met Tata navan. E‑e. Ihe Mosis vari tang xa di muling nenesien namim de sepinien nan iaxa isepin iha xat rin namim. ");
INSERT INTO tvk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vengan, vahit vahe reitin xa di muke reitin e sepinien na Mosis, ma muke reitin e inou mun, vengan xi tetis usil inou. ");
INSERT INTO tvk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","?E xosxa mutake reitin ti e naha xa Mosis tetisi usil inou, ma mukila mukei reitin e naha xa inou di nabiteni itep?” Di, Iesu be reling xil. ");
INSERT INTO tvk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Melengien vahis mei mitavi, e Iesu be bot del moletin nan xil e langgur xoteh Oei Kaleli (lakes oei ak ni Oei Taeberias mun). ");
INSERT INTO tvk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E melele xa Iesu ba, vanut moletin xil holu langgusili langgo ut vengan xa latepus merekel xil xa tepol ni e tetep iaxa tesak ni ngan xil xa latemesei latelonge tehos rilomun. ");
INSERT INTO tvk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Melele xa Iesu duxoh ri oei, xi be nesao e vathu tei e dotan en del moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngan ak testal sangas ni melele te Anien te Tavien. ");
INSERT INTO tvk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Melele xa ladotan mak, Iesu miketeh ba e pus vanut moletin xil holu di lamei visali. Ma, misis Pilip bit, “?Rute xave iaxa rikila rixal anien ipin tengan risa ni mi tatit moletin xa eilep xiak?” ");
INSERT INTO tvk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu mikila ngamu naha xa ipol ni, e biteni mak tengan vasak pis Pilip. ");
INSERT INTO tvk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E Pilip bit rilomun ni mini bit, “!Ei! Tave ti neta xosxa huit polien nar vapin ni aveti tei e he sav (6) tengan raxal beret ni, anien ak napin ti tengan moletin xil vus ak lavur mavulut beret xa hokorong tang vahe ae.” ");
INSERT INTO tvk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andru, xa be moletin teimun na Iesu e tua na Saemon Pita, xi biteni bit, ");
INSERT INTO tvk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“E horamue tei da tak xa mileh beret lim (5) xa lapol ni ni bale, del meseo lu. E anien ak tapin ti vari mi vanut moletin xa mahulong xiak.” ");
INSERT INTO tvk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma, Iesu biteni bit, “Muhiteni mi moletin xil ak tengan litotan.” E rute ak, husmunae holu di, ma vanut moletin xil ak ladotan en. Moletin xil vus sangas laduxoh taosen lim (5000). ");
INSERT INTO tvk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Melele xa ladotan bus, Iesu mileh beret, misa memesien mi Hi ven, e misa ni mi moletin nan xil tengan liseti mi vanut moletin xil vus xa ladotan ladi. Di, pol ni mak tang mi meseo mun. Moletin xil vus langganien ba duxoh melele xa xil vus lalonge labit pipin. ");
INSERT INTO tvk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Melele xa moletin xil vus langganien pipin, Iesu biteni mi xil bit, “Ha muleh viton rut anien xil xa ladi tengan rinapurun ni ti.” ");
INSERT INTO tvk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma, xil laba e laleh viton rut anien xa di nggo beret bale lim (5) tang xa moletin xil langga rasi di. E lamesep pupu melele xa lapusi xa lase ni be valeat lu e le tei (12) ba vuma ... xil vus lapolu. ");
INSERT INTO tvk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Melele xa vanut moletin xil ak lapus kil merekel xa Iesu pol ni, labiteni labit, “Reitin li, ngan ak be Provet xa Hi tehit xati tengan isila imei e ut etan.” ");
INSERT INTO tvk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu mikila xa nenemien na vanut moletin xil ak bit mei lixeih xati tengan mei ihe suv toto nae. Ma, Iesu be reling xil ladi nga, e mika tasen tang be vathu. ");
INSERT INTO tvk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Melele xa mahis bemei, moletin na Iesu xil labe tan e bien. ");
INSERT INTO tvk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lapusi xa Iesu tamei ti mu vastal visal xil, e ut maluxoluk ngamu. Ma, labe bot nae e labalis tengan lavur xoteh oei latilomun lave Kapaniam. ");
INSERT INTO tvk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Melele xa di laba, lakameti nggeih tengan lavalis vengan xa di labisu ni votiang tei xa nggeih e oei mun misa xa misa. ");
INSERT INTO tvk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Melele xa labalis ba duxoh kilomita lim (5), xil lamesep pupu xa lapus Iesu di bemei visal xil e di mikakao e ramut oei nggoni ngan taxa di mikakao e tan tang. Melele xa lapusi, ulixil mikan pupu. ");
INSERT INTO tvk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","E Iesu biteni mi xil bit, “!Ulimim nakan ti! !Inou nabe xi!” ");
INSERT INTO tvk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Melele xa lapusi xa be xi reitin, labesi xil tengan lavuri vamei e bot. E melele xa Iesu bemei e bot, latemanin xa laduxoh ut e rute xati xa labit lava en. ");
INSERT INTO tvk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Melele xa ut da milan, vanut moletin xil xa ladi tamu e ri oei di lanemi labit lipus Iesu, vengan xa lakila xa tehe moletin nan xil kestang xa latehe bot tei takes nae lateha, e latestokovein Iesu e ri oei nae. ");
INSERT INTO tvk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","E melele nen ak, moletin sav xil xa langgo taon te hal Taeberias lamei del bot nae xil. Xil lamei ut sangas e rute xa Iesu temes Hi ve beret e tesa ni mi tatit moletin xil lava ni. ");
INSERT INTO tvk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Melele xa moletin xil ak lapusi xa Iesu del moletin nan xil latari ti e rute ak, xil labe bot na mol‑Taeberias xil e labe taon te hal Kapaniam tengan lalang ni. ");
INSERT INTO tvk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Moletin xil lakamet Iesu e ri Oei Kaleli. E melele xa lakameti lasisi labit, “?Titsa, otemei inggak vilieh?” ");
INSERT INTO tvk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","E Iesu bit rilomun ni mi xil bit, “Reitin li nabiteni mi xamim xa mutalang ni nou ti vengan xa mule kil koute te merekel xil xa di napol ni. E‑e. Di mulang ni nou vengan xa natesak ni vangemim mei tepolu ni beret. ");
INSERT INTO tvk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Munasa xamim ti ve anien tang xa di mungga ni e, tavehi ti, di mikesae mun. E ihos pupu tengan musa xamim ve anien xa misakras vakesae xa mikila vasa meulien sal mi ngan xil vus xa langguri. Inou, Nat Moletin, nikila nisa ni mi xamim vengan xa Hi, Tata navan, tehosei inou e besi xi ve nou.” ");
INSERT INTO tvk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ma, moletin xil lasisi labit, “?Hi ien bei tengan xamem mupol ni naha?” ");
INSERT INTO tvk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","E Iesu bit rilomun ni bit, “Naha xa Hi ien bei tengan xamim mupol ni mak: muling neketen namim iti e ngan xa xi tesila temei.” ");
INSERT INTO tvk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma, xil lasis Iesu labit, “?Upol ni merekel eah mupusi tengan muling neketen namem e xouk? ?Reitin, upol ni naha vari? ");
INSERT INTO tvk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Melele xa avu namem xil di latekakao e uruvuol, latea manna xa Mosis tesa ni mi xil, vengan xa Vanuvei Eo biteni bit, ‘Xi tesa beret texo ut nesao tengan mei vahe ae.’” ");
INSERT INTO tvk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","E Iesu biteni mi xil bit, “Reitin li nabiteni mi xamim, ngan xa tesa beret texo ut nesao tengan vahe ae tenave Mosis ti. Tehe Tata navan iaxa tesa ni mi xil. E xosali, xi di misa beret xa nggo ut nesao reitin mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vengan xa beret xa Hi di misa ni be ngan xa nggo ut nesao bemei e di misa meulien mi moletin xil te ut etan.” ");
INSERT INTO tvk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Melele xa lalonge mak, xil lasisi labit, “Suv, sa beret ak mi xamem li vehakut.” ");
INSERT INTO tvk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma, Iesu biteni mi xil bit, “Inou nabe beret xa di misa meulien. Ngan xil vus xa lamei visal nou, mae naxat xil ti mun. E ngan xil xa laneket e nou, meruru naxat xil ti mun. ");
INSERT INTO tvk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","E tave ti neta xa natehiteni mi xamim xa mutepus nou e merekel xil xa natepol ni, mutaneket ti mu e nou. ");
INSERT INTO tvk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngan xil vus xa Tata navan bosei xil tengan mei labe moletin navan xil, xil mei lihusil xat kuh inou. E inou ti nihur pilei ngan xil vus xa di langgusil xat nou, ninasil rerat xil ti linave reling nou. ");
INSERT INTO tvk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Nihur pilei xil vengan xa ngan ak be naha xa ngan xa tesil nou ien bei inou nipol ni. E vehakut di napol ni naha xa xi ien bei e natapol ni ti naha xa inou tasok tang ieok bei. ");
INSERT INTO tvk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","E ien bei tengan nilaxat kuh holesok xil vus xa telingi teti heok tengan neta ti nakesae. E, e hoxalite te holesok xil vus, moletin navan xil vus limea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Vengan xa Tata navan ien bei tengan ngan xil vus xa lapus Natneli e laneket en mei lihur meulien sal. E, e hoxalite te holesok xil vus, inou nisak ni xil limea rilomun ra maten limeul.” ");
INSERT INTO tvk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Melele xa Siu xil lalong Iesu bit xi be beret te meulien xa nggo ut nesao bemei, xil laseputut ba xati labit, ");
INSERT INTO tvk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Xamem makil moletin ak. E makil tamen xal ninen mun. Xi be Iesu, nat Siosep tang. ?Ma, veneh di biteni xa xi texo ut nesao bemei?” ");
INSERT INTO tvk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu bit rilomun ni bit, “Munaseputut ti mun ve sepinien navan xil. ");
INSERT INTO tvk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Be reitin xa Hi Tata tesil nou namei, e ngan xil kestang xa xi di bosei xil lakila mei lihe moletin navan xil. E inou nisak ni xil limea rilomun ra maten e hoxalite te holesok xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Provet xil tetiamu latetisi latehit, ‘Hi vari ipispisi mi moletin xil vus.’ E ngan xil xa lalong rae Hi e langgur pispisien nggo en di lamei visal nou. ");
INSERT INTO tvk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nataviteni ti namit moletin tei tepus Hi Tata ni meten xati. Inou kestang natepus Tata navan ngamu vengan xa natexo visali. ");
INSERT INTO tvk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Reitin li nabiteni mi xamim xa ngan xil vus xa laling neketen nae e nou langgur meulien sal. ");
INSERT INTO tvk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inou nabe beret te meulien. ");
INSERT INTO tvk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Avu namim xil latea manna e uruvuol. E neta sav xa mak, xil latelel. ");
INSERT INTO tvk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","E inou nabe beret xa nggo ut nesao bemei e tan. E ngan xil xa langga beret ak linalel ti. ");
INSERT INTO tvk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Reitin, inou nabe beret xa nggo ut nesao bemei e tan xa di misa meulien. Moletin xa ia beret ak imeul iha vuma … navus ti. Beret xa nisa ni mi xamim be tenbeok. E di nasa ni mi moletin xil te ut etan tengan likila lihur meulien sal ixo en.” ");
INSERT INTO tvk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Melele xa Siu xil lalong sepinien na Iesu lamesep pupu ven. E langor mi xil mun tang labit, “?Ei, midep xiak? ?Moletin ak isa tenben mi xir tengan ria ni itep?” ");
INSERT INTO tvk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","E Iesu biteni mi xil bit, “Reitin li nabiteni mi xamim, xosxa xamim munaxa tenbe Nat Moletin ti, e munamu ren ti, meulien tovuol e xamim. ");
INSERT INTO tvk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngan xil xa langga tenbeok e lamu reok, nisak ni xil limea rilomun ra maten e hoxalite te holesok xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vengan xa tenbeok be neta tei te anienen reitin, e reok be neta tei te munien reitin. ");
INSERT INTO tvk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ngan xil xa langga tenbeok e lamu reok labisti del xat inou, e inou mun nabisti del xat xil. ");
INSERT INTO tvk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tata navan be vatit meulien, e inou nanggur meulien nggo en. Xi tesil inou namei, e ngan xil xa langga nou lihur meulien ixo inou. ");
INSERT INTO tvk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma, tenbeok be beret xa nggo ut nesao bemei etan. E beret ak taxoni beret ti xa avu namim xil latea ni, e tetutou ni sung latelel. Vengan moletin xa ia beret ak imeul vehakut xa vehakut tang.” ");
INSERT INTO tvk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu misa sepinien xil ak melele xa xi di pispisi e nim te pispisienna Siu xil e taon te hal Kapaniam. ");
INSERT INTO tvk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Melele xa ngan xil xa di langgusil Iesu lalong sepinien nan xil, labiteni mi xil mun tang labit, “Ei, pispisien xil ak nggeih pupu tengan ravuri. ?Visi vari mikila vake reitin en?” ");
INSERT INTO tvk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E Iesu mikila xa moletin nan xil di laseputut usil pispisien nan xil. Ma, ba pus xil e biteni mi xil bit, “?Midep? ?Pispisien xil ak di misak ni xamim mumesep e musavut e neketen namim? ");
INSERT INTO tvk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E ti mumesep e ti musavut reitin xosxa vahit mupus inou, Nat Moletin, nihe ut nesao, rute xa natexo en tetiamu. ");
INSERT INTO tvk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ninin na Hi kestang di misa meulien mi moletin xil. Moletin misakras vakamet meulien vaxo xeihen nan tasen. E sepinien xil xa inou iaxa di nasa ni mi xamim lastal langgo Ninin Eo e di lasa meulien. ");
INSERT INTO tvk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","E rut xamim lataling neketen nae ti e nou.” Iesu biteni mak vengan xa, e melele xa tepol kokot ni polien nan, xi tekila ngamu visi e xil linaling neketen nae ti en, e visi iaxa isa rati ihe he elu nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Di, Iesu biteni mun mi xil bit, “Vengan xa nakila xa moletin xil holu linaling neketen nae ti e nou, inou natehiteni mi xamim ngamu xa ngan xil kestang xa Hi Tata di bosei xil iaxa lakila mei lihe moletin navan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","E melele nen tak, moletin xil holu labe relingi e latahusili ti mun vari. ");
INSERT INTO tvk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Melele xa Iesu pusi xa moletin xil di labe relingi, xi biles pus moletin nan xil xa labe lu e le tei (12) e misis xil bit, “?E itep mi xamim? ?Xamim mun mubit muhe reling nou?” ");
INSERT INTO tvk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","E Saemon Pita bit rilomun ni mini bit, “?Suv, xosxa xamem muhe relinguk, ma muhe visal visi mun? Vengan xouk kestang di osa sepinien xil xa di misa meulien sal. ");
INSERT INTO tvk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","E xamem maling neketen namem e xouk e mapus kila xa xouk iaxa obe Mesaea, Moletin Eo na Hi.” ");
INSERT INTO tvk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma, Iesu biteni mi xil bit, “Inou iaxa nabosei xamim xa mube lu e le tei (12) tengan muvusil nou. E tave ti neta xa mak, tei e xamim be Temat.” ");
INSERT INTO tvk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu di misep usil Sudas, nat Saemon Eskariot. Vengan, tave ti neta xa xi be tei e moletin lu e le tei (12) nan, xi isa rat Iesu ihe he elu nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dutou ni ngan ak, Iesu mikakao mikapis e rute xil holu e provins te hal Kaleli. E xi ien ti tavei vahe provins te hal Sudea, vengan xa mikila xa vat xil na Siu xil di lalang ni mesal tova tengan lavasi vamat vaxo en. ");
INSERT INTO tvk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","E melele xa Wik te Horao xil bemei sangas, ");
INSERT INTO tvk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tua na Iesu xil labiteni mini labit, “Onata ti kestang inggak e provins te hal Kaleli. Ihos mak mu xa uhe provins te hal Sudea tengan ngan xil xa iexil bei tengan lihusil xouk likila lipus merekel xil xa di opol ni. ");
INSERT INTO tvk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Uhe Sudea sung vengan xa moletin xa ien bei tengan mei vahe eilep tei misakras ti vapol xuxus. Ma, xosxa be reitin xa okila opol ni merekel xil, ma upol ni e valkesao tengan upisen xouk mi moletin xil te ut etan.” ");
INSERT INTO tvk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tuneli xil labiteni mak mini vengan xa, tave ti neta xa xil labe tuneli xil, xil mun latake reitin ti en xa xi be Mesaea. ");
INSERT INTO tvk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","E Iesu biteni mi xil bit, “Melele xati tengan nipisen nou mi moletin xil vus tamei ti mu. E xamim mukila mupol ni naha xa iemim bei tengan mupol ni e melengien xil ngasen. ");
INSERT INTO tvk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Moletin xil te ut etan iexil taxat xamim ti. E iexil di nggat nou vengan xa di nabit rati e valkesao xa sexien nae misa. ");
INSERT INTO tvk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xamim ha mupus melengien eo xil ak e inou ninava ti mu, vengan xa melele nen ak tamal ti mu tengan nama.” ");
INSERT INTO tvk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Melele xa Iesu biteni mak, xi dat e provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Melele xa tua na Iesu xil labe Serusalem tengan lapus Wik te Horao xil en, Iesu dat e tim melengien vahis. Di, xi mun ba, e pol xuxus ni tang del moletin nan xil tengan moletin sav xil linakil ti. ");
INSERT INTO tvk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","E hal Serusalem, vat xil na Siu xil di lalang ves Iesu e hilaep te vanut moletin xa lamei tengan lapus melengien eo xil ak. Xil di lasis moletin xil labit, “?Moletin ak da xave?” ");
INSERT INTO tvk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Moletin xil xa lamei tengan lapus melengien eo xil ak lasep xuxus holu usil Iesu. Rute xil labit, “Xi be moletin hos tei.” E tesav e xil labit, “E‑e, xi di miluvos moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","E moletin xil latasepin ti e valkesao usil Iesu vengan xa ulixil mikan xa vat xil na Siu xil linalong ti e linapol ni naxeih mi xil. ");
INSERT INTO tvk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Melele xa Siu xil ladi tamu lapol vituei ni holesok xil e hilaep te Wik te Horao xil, Iesu bemei e hal Serusalem, be vioh te Nim Eo, e di pispisi mi moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E melele xa vat xil na Siu xil lalong pispisien nan xil, latemanin e labit, “?Moletin ak nggur kilakilen ak nggo xave, vengan xa xi tava ti e sukul tengan lapispisi mini?” ");
INSERT INTO tvk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu bit rilomun mi xil bit, “Holesok xil xa di napispisi ni taxo nou ti. Xil vus langgo Hi xa tesil nou namei. ");
INSERT INTO tvk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ngan xil xa iexil bei tengan lapol ni naha xa Hi ien bei, xil likila xa pispisien navan xil nggo visal Hi e taxo nou tasok ti. ");
INSERT INTO tvk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Moletin xa misa sepinien xil xa nggo xi tasen, xi ien bei vapet rat xi tasen vahe nesao. E moletin xa di misak pisi tengan vapet rat ngan xa misila, xi be reitin e luvosen tovuol en. ");
INSERT INTO tvk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Xamim vus mukila xa Mosis tesa rae xil mi xamim. E tovuol e xamim valong xat vuol ni rae xil ak. ?Ma, veneh iaxa di mulang ni mesal tova tengan muvas vin nou vaxo en?” ");
INSERT INTO tvk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vanut moletin xil xa lalong sepinien nan labiteni mini labit, “Xos temat tova de xouk xa biles nenemien nam. ?Visi vari iaxa di misak tengan vahas vinuk?” ");
INSERT INTO tvk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu bit rilomun ni mi xil bit, “Inou natepol ni tutut polien tei e Sabat e xamim musepin pupu ven e mubit natepol tesa. ");
INSERT INTO tvk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tetiamu, Mosis tesa rae te vexahu mi xamim, xa xi tehuri texo vatit avu nar xil tetiamu. E tengan muhusil xat rae ak, xamim vari di mupol ni vexahu ni rut tenbe horamue namim xil e melele xa melengien nae be tol e he sav (8) xati. ");
INSERT INTO tvk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","E neta sav xa di mupol ni polien ak e Sabat, mutahur xoteh rae te Sabat ti. ?Misak ni, veneh ma iemim di nggat inou xa natepol ni tenbe moletin tevi tei mei temese rilomun e Sabat? ");
INSERT INTO tvk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma, munalepis rin navan ti nahusil naha xa moletin xil di lapusi e hale tang, e mulepis rin navan ihusil naha xa momal reitin tengan ripol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Melele xa moletin xil e hal Serusalem lapus Iesu di pispisi labiteni labit, “?Tave moletin ak ti xa vat nar xil iexil bei tengan lavas vini? ");
INSERT INTO tvk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","!E mupus ti! Xi di misepin e valkesao pe met moletin xil ak, e vat xil ak latavit ti neta. Xos lakila be reitin xa moletin ak be Mesaea xa Hi tehit xati tengan isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E labiteni xa melele xa Mesaea imei, moletin ti nakil ti xa xi nggo xave bemei. Ma, xi tave Mesaea ti vengan xa rakil rute xa xi texo en.” ");
INSERT INTO tvk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Melele xa Iesu di pispisi e vioh te Nim Eo, xi misepin be nesao bit, “?Midep? ?Be reitin xa xamim mukil nou e rute xave xa natexo en? E natamei ti inggak vahusil nenemien navan tasok. E namei inggak nggusil nenemien na Hi xa tesil inou namei. Xi vari be reitin, e xamim mutakil ti xi. ");
INSERT INTO tvk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inou nakila, vengan xa natexo visali, e xi iaxa tesil inou namei e tan.” ");
INSERT INTO tvk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Melele xa lalong sepinien nan, rut moletin xil lasak tengan latal xati. E moletin ti tapol ni vengan xa melengien nan xati tamei ti mu. ");
INSERT INTO tvk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E moletin xil holu lake reitin xa xi be Mesaea vengan xa labiteni labit, “Xir ralonge xa melele xa Mesaea imei, xi ipol ni merekel xil holu. !E moletin tovuol xa mikila vapol ni merekel xil vahe holu mak mu vali ngan xil xa Iesu di pol ni!” ");
INSERT INTO tvk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasi xil lalong naha xa moletin xil di lasep piao ni usil Iesu. Ma, xil del vat xil na pris xil lasil mereketeh xil xa di laketeh xol Nim Eo na Hi tengan lava latal xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Melele xa mereketeh xil laba, Iesu biteni bit, “Inou nite visal xamim nave nousav ti. Ti, nitilomun nihe visal ngan xa tesil inou natemei. ");
INSERT INTO tvk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Xamim ti mulang ni nou, e munakamet nou ti. Xamim munakamet nou ti vengan xa musakras muve rute xa inou ha nita en.” ");
INSERT INTO tvk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Melele xa lalonge mak, vat xil na Siu xil ak labiteni mi xil mun tang labit, “?Moletin ak iha xave iaxa xir rasakras rakameti? ?Xos ihe visal Siu xil xa ladi e kantri na mol‑Kris xil nggoni ngan halesav xil, mu xos ha ipispisi mi mol‑Kris xil vari? ");
INSERT INTO tvk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","?Naha vari be koute te sepinien nan xa bit ti rilang ni e rinakameti ti, e rasakras rave rute xa xi ha ita en?” ");
INSERT INTO tvk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","E melengien eo kor te Wik te Horao xil, ngan xa be eilep mak mu mili melengien sav xil teni, Iesu misoh e vioh te Nim Eo e misepin be nesao bit, “Xamim xa meruru nggat xamim mumei visal nou. ");
INSERT INTO tvk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Moletin xa mineket e nou imei imu ni. Imak, ma naha xa Vanuvei Eo bit usili mei istal ihe reitin xa bit, ‘Inou nisak ni oei xa misa meulien mei istal ixo tin moletin, e ileh ihe holu ixoni oeisal tei xa mahulong.’” ");
INSERT INTO tvk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oei xa Iesu di bit usili be vole tei usil Ninin Eo xa mei ise xat ngan xil xa laneket en xa xi be Mesaea. E melele nen ak, Ninin Eo tenamei ti mu e xil vengan xa Hi tenasa ti mu Iesu vaha vahur minehinen te xeihen nan. ");
INSERT INTO tvk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Melele xa moletin xil lalong sepinien xil na Iesu, rute xil labiteni labit, “!Reitin mak xa moletin ak be Provet xa ixoni Mosis xa Hi tehit xati tengan isila imei!” ");
INSERT INTO tvk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","E rute xil labit, “E‑e, xi be Mesaea vari.” E rute sav xil mun labit, “Xi misakras vahe Mesaea vengan xa Mesaea misakras vastal vaxo provins te hal Kaleli. ");
INSERT INTO tvk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Vengan Vanuvei Eo bit lelen ni xa Mesaea imei ixo vatimol na suv toto Deved, e lipesi e hal Betlehem, taon xa Deved teta en tetiamu.” ");
INSERT INTO tvk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma, vanut moletin xil ak langgur nenemien savsav xil usil Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E rute e xil iexil bei tengan latal xati, e tovuol e xil vaha tengan vapol ni. ");
INSERT INTO tvk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mereketeh xil te Nim Eo xa vat na pris xil del Farasi xil latesil xil tengan lava latal xat Iesu lalong naha xa Iesu di biteni. Di, ladilomun labe visal vat nae xil. E melele xa vat na pris xil del Farasi xil lapusi xa lamei hon tang, xil labiteni labit, “?Veneh vari mutatal xat Iesu ti?” ");
INSERT INTO tvk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","E mereketeh xil labit rilomun ni mi xil labit, “Matatal xati ti vengan xa sepinien nan xil bos pupu. Pispisien nan xil taxoni na moletin sav xil ti.” ");
INSERT INTO tvk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma Farasi xil labul xat xil labit, “?Midep? ?Moletin ak miluvos xamim mun? ");
INSERT INTO tvk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tovuol e xamem Farasi xil del eilep xil maneket en mu mavusili. ");
INSERT INTO tvk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Be movotei xil tang xa latakil ti rae xil na Mosis iaxa di laneket en. E ve rin ak, halesil ite meulien nae.” ");
INSERT INTO tvk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, xa teha tuei tengan vasepin mi Iesu, xi mos e xil e be xil ladi. E melele xa milong sepinien nae xil biteni bit, ");
INSERT INTO tvk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“?Midep? ?Rae nar xil lamaen ni tengan rakin pangasien tei mi moletin tei melele xa ratalepis rin nan ti e von koten tengan rakamet naha tova xa xi pol ni xa misa? E‑e, tamaen ni ti.” ");
INSERT INTO tvk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Vat sav xil labul xati xeih labit, “!Ei! ?Midep? ?Xouk mun obe ngan Kaleli? Xosxa usak tengan ulang pisi e Vanuvei Eo, ma ukameti xa provet tovuol xa vaxo provins te hal Kaleli.” ");
INSERT INTO tvk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Di, xil vus ladilomun labe tim sae xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iesu be Vathu te Urvatiei te Olip del moletin nan xil e laba lapat en. ");
INSERT INTO tvk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ut milan, Iesu dilomun be Serusalem e ba be vioh te Nim Eo. Moletin xil holu lamei visali e lakapis xole. Ma, Iesu dotan e pispisi mi xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Melele xa di tamu pispisi, titsa xil te rae na Mosis del Farasi xil ladiamu ni atou tei xa latekameti di pat tetel tiramue tei xa tave tiramue nan xati ti. Ma ladel atou ak ba misoh pe met moletin xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Di, labiteni mi Iesu labit, “Titsa, atou ak, melele xa lakameti, xi dit pat del tiramue tei xa tave tiramue nan xati ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Rae na Mosis biteni xa rihov vin hisit atou xil xa lamak. ?E xouk, uhit naha?” ");
INSERT INTO tvk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xil lasis Iesu mak tengan vasak pisi e rin te sepinien nan tengan xos isa sepinien tova xa imaen xil ha lital xati ven. E Iesu mitingeiril, e midis neta tei e tan ni vakuhen. ");
INSERT INTO tvk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","E xil dit lasi petinen tengan isa nenemien nan mi xil usil rin ak. Ma, Iesu mea misoh e biteni mi xil bit, “Visi e xamim xa tapol ni ti tesaen, xi vari iaxa ihov kokot ni.” ");
INSERT INTO tvk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Di, mitingeiril mun e midis neta teimun e tan. ");
INSERT INTO tvk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Melele xa titsa xil te rae na Mosis del Farasi xil lalonge mak, xil kekes labaha. Ngan xil xa lamatu ladiamu, di, tesav xil mun laba ba vuma … Iesu tasen tang da, e atou ak di tamu misoh pe meten. ");
INSERT INTO tvk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Di, Iesu mea misoh e biteni mini bit, “?Atou, moletin xil laba xave? ?Midep? ?Ti xil tara ti ak tengan vahit umat ve tesaen nam?” ");
INSERT INTO tvk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Atou bit rilomun ni mini bit, “Suv moletin tovuol.” Ma Iesu biteni mini bit, “E inou mun ninavit neta ti nava xat rin nam. E utilomun uhe tim, e xosali iha, onapol ti mun nasa.” ");
INSERT INTO tvk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Melele xa Iesu di tamu e vioh te Nim Eo, misepin rilomun mi moletin xil bit, “Inou nabe miehen xa di mileluv e meulien na moletin xil te ut etan. E moletin xa di nggusil nou nakakao ti e maluxoluken, vengan xa miehen navan xa iti en ileluv kuh suse te meulien mini.” ");
INSERT INTO tvk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farasi xil xa lalong sepinien nan labiteni mini labit, “Xouk di obit rat sepinien xil ak e rin nam tasom tang. Misak ni, xamem masakras make reitin e sepinien nam.” ");
INSERT INTO tvk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu bit rilomun ni bit, “Reitin xa di nabit rat holesok xil holu e rin navan. E naha xa di nabit rati be reitin vengan xa nakil rute xa natexo en, e nakil rute xa niha en. E xamim mutakil ti rute xa natexo en mu rute xa niha en. ");
INSERT INTO tvk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Melele xa mulepis rin navan, munggusil nenemien na moletin xil te ut etan tang. E inou, di natalepis rin na moletin xil ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","E vahit ieok bei tengan nilepis rin na moletin tei, naha xa nihiteni ihe reitin. Vengan xa tave inou tasok ti xa nipol ni, e inou xamel Tata navan xa misil inou namei malilepis vituei ni rin ak. ");
INSERT INTO tvk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E rae xil na Mosis xa xamim vari di munggusil xati biteni xa melele xa sepinien na moletin lu usil neta tei lupin, moletin xil likila like reitin xa naha xa lubiteni be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mak, ma inou nasepin e rin navan, e Tata navan xa misil inou namei, xi mun di misepin e rin navan.” ");
INSERT INTO tvk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma, xil lasisi labit, “?Xosxa mak, tata nam da xave?” Iesu bit rilomun ni bit, “Xamim mutakil ti nou e mutakil ti Tata navan mun. Vengan, xosxa mukil inou, ma mukila mukil Tata navan mun.” ");
INSERT INTO tvk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Melele xa Iesu bit holesok xil ak, de vioh te Nim Eo, sangas visal rute xa laling kuh mani te Nim Eo di en. E tave ti neta xa rute ak de sangas ni rute xa vat na Siu xil ladi vituei en, moletin tovuol vatal xati. Latatal xati ti vengan xa melele nan xati tamei ti mu. ");
INSERT INTO tvk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Di, Iesu bit rilomun ni mi titsa xil te rae na Mosis e Farasi xil bit, “Inou nihe reling xamim e, neta sav musak pisi tengan mulang ni nou, munakamet nou ti. Xamim muxulehi mupol ni tesaen e muhur huite teni e von maten tang. Mak, ma xamim musakras muve rute xa inou niha en.” ");
INSERT INTO tvk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vat xil na Siu xil latakil ti koute te sepinien na Iesu. Ma, lasepin mi xil mun tang labit, “?Veneh ma xi biteni xa xir rasakras rave rute xa xi iha en? ?Itep? ?Ihas vin tasen ni xi tang?” ");
INSERT INTO tvk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu bit rilomun ni bit, “Xamim mube te ut etan ak tang. E inou, nabe te ut nesao. Xamim mube moletin xil te ut etan, e inou natave te ut etan ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mak, ma nabiteni xa xamim muhur huit tesaen namim xil e von maten tang. Vengan xa xosxa munake reitin ti en xa inou nabe xi, reitin xa mumat itel xat tesaen namim xil.” ");
INSERT INTO tvk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xil latemanin ni sepinien nan e labit, “?Xouk obe visi vari?” E Iesu bit rilomun ni bit, “Tetiamu mei duxol xosali, di nabit lelen ni mi xamim xa nabe visi. ");
INSERT INTO tvk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Inou nikila nihit rat neta holu xa misa iha xat rin namim. E di nabit lelen ni mi moletin xil te ut etan naha xa Tata biteni minou vengan xa nakila xa ngan xa tesil nou namei be reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Melele xa Iesu di bit usil Tata nan, xil latakil ti xa Iesu di bit usil Tata nan xa de ut nesao. ");
INSERT INTO tvk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mak, ma Iesu biteni mi xil bit, “Melele xa mupo rat Nat Moletin ihe nesao, mupus kila xa inou nabe xi. E melele nen ak mukila sung xa natapol ni ti neta vahusil nenemien navan tasok. E di nabit naha kestang xa Tata navan di pispisi minou. ");
INSERT INTO tvk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E ngan xa misil nou namei, xi di minou e tastokovein nou ti. Vengan xa, vehakut, di napol kes ni neta xa xi besi xi ven.” ");
INSERT INTO tvk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Melele xa Iesu bit holesok xil ak, moletin xil holu lake reitin en xa xi be Mesaea na Hi reitin. ");
INSERT INTO tvk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Di, Iesu pusi xa rut Siu xil lake reitin en, ma biteni mi xil bit, “Xosxa muxulehi ni ngan taxa ti mulong xat pispisien navan xil, ma mupisen ni xa xamim mube moletin navan xil reitin. ");
INSERT INTO tvk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mukil naha xa be reitin, e reitinen ak isak ni xamim mei mumeluv reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","E xil labit, “Xamem mabe vatimol na Ebraham, e matave slev na moletin ti vatova. ?Mak, ma veneh vari obiteni xa xamem mei mumeluv reitin?” ");
INSERT INTO tvk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu biteni mi xil bit, “Reitin li nabiteni mi xamim xa moletin xil vus xa di lapol ni tesaen labe slev xil teni. ");
INSERT INTO tvk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","E slev tei, voninen tovuol e vatimol xati na masta nan. E nat masta ak, voninen xati e vatimol nan da vehakut. ");
INSERT INTO tvk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mak, ma xosxa Nat Hi pol ni xouk mei omeluv, ma omeluv reitin. ");
INSERT INTO tvk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakila xa xamim mube vatimol xil na Ebraham. E neta sav xa mak, di musak pisi tengan mulang ni suse xa muvas vin inou vaxo en. E iemim bei tengan muvas vin inou vengan xa ut tovuol e tinemim tengan sepinien navan vaha vata en. ");
INSERT INTO tvk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inou di nabit mesen naha xa natepusi e melele xa natete visal Tata navan. E xamim, ihos xa ti mupol ni naha xa Tata di biteni mi xamim tengan ti mupol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Xil labit rilomun ni labit, “Tata namem Ebraham.” E Iesu biteni bit, “Xosxa xamim mube horamue xil na Ebraham reitin, ma sexien namim xil ixoni sexien nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inou nabit mesen ni mi xamim reitinen xa Hi biteni minou. E xamim, musak tengan muvas vin inou. Ngan ak tave sexien xil na Ebraham ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","E‑e. Sexien xil namim nggoni sexien xil na tata namim xati.” E xil labiteni labit, “!Ei! !Tave xamem ti iaxa mabe horamue xil te suse! Tata namem tei takes, xi be Hi vari.” ");
INSERT INTO tvk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu biteni mi xil bit, “Xosxa be reitin xa Hi be Tata namim, eheien namim vati e nou. Vengan xa inou natexo visal Hi, e xosali nade visal xamim inggak. Natamei ti vahusil nenemien navan, e Hi iaxa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","E nakila veneh ma xamim musakras mulong kil naha xa nabiteni. Vengan xa iemim ti tavei mukil sepinien navan xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tata namim be Temat vari e iemim bei tengan mupol ni naha xa xi ien bei xamim tengan mupol ni. Vengan xa xi misak ni moletin xil labas vin moletin sav xil e melengien xil tetiamu mei duxol xosali. Xi tara ti e rin te reitinen, vengan reitinen tovuol en. Melele xa miluvos, di misa sepinien nan xati, vengan xa xi be vat luvosen, e be tata na ngan xil xa di laluvos. ");
INSERT INTO tvk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mak, ma vengan naha xa inou nabiteni mi xamim be reitin, xamim mutake reitin e nou ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","?Visi e xamim mikila vahit rat naha xa inou di napol ni xa misa? Tovuol e xamim mukila vapol ni. ?Ma xosxa di nabit naha xa be reitin, veneh vari mutake reitin ti e sepinien navan xil? ");
INSERT INTO tvk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ngan xil xa labe horamue xil na Hi di lalong kil sepinien nan xil. E xamim mutave horamue xil na Hi ti, ma mutalong kil ti.” ");
INSERT INTO tvk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma Siu xil lasepsisil Iesu labit, “!Ei! Mabiteni reitin melele xa mabit osa tova tang e onggoni ngan Sameria tei e temat tei de xouk.” ");
INSERT INTO tvk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","E Iesu bit rilomun ni mi xil bit, “Temat tovuol e nou. Inou namerere ni Tata navan, e xamim mutamerere ni nou ti. ");
INSERT INTO tvk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Natasak pis ti tengan napet rat hisok vahe nesao. E tei da xa ien bei tengan vapet rat hisok, e xi iaxa ilepis rin namim. ");
INSERT INTO tvk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Reitin li nabiteni mi xamim xa ngan xil xa lalong xat pispisien navan xil linapus ti maten vatova.” ");
INSERT INTO tvk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vat na Siu xil labiteni mini labit, “Taxeak makil kuhi sung xa temat tei de xouk. Vengan Ebraham temat, e provet xil na Hi mun latelel. E xouk di obiteni xa ngan xil xa lalong xat pispisien nam xil linapus ti maten vatova. ");
INSERT INTO tvk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Midep? ?Di obiteni xa xouk obe eilep mak mu mili avu Ebraham tetiamu xa temat? ?E midep e rin te provet xil? ?Di obiteni xa xouk obe eilep mak mu mili xil, vengan xil mun lalel? ?Di obiteni xa xouk obe visi vari?” ");
INSERT INTO tvk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu bit rilomun ni bit, “Xosxa inou di napet rat tasok ni hisok, his ak be neta sav tang. E be Tata navan xa di pet rat hisok. Tata navan be ngan xa xamim mubit be Hi namim, ");
INSERT INTO tvk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","e mutakil ti xi vari. E inou nakila, e nasakras naluvos namit natakil ti. Vengan xosxa vamak, name vat luvosen vaxoni xamim tang. Reitin, inou nakil xi, e di nalong xat sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ebraham, avu namim, xi minem kila xa melengien navan mei istal, ma besi pupu ni xi ven.” ");
INSERT INTO tvk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Siu xil labiteni mini labit, “Huram nam tatuxoh hanutap lu e he xalu mun (50) ti mu. ?Mak, ma obit otepus Ebraham midep?” ");
INSERT INTO tvk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu bit rilomun ni mi xil bit, “Reitin li nabiteni xamim xa melele xa Ebraham tenapot ti mu, inou NABE.” ");
INSERT INTO tvk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Melele xa Siu xil lalong naha xa Iesu biteni, laleh hat xil labit lihov vini. E Iesu minggus ra xil e be reling vioh te Nim Eo. ");
INSERT INTO tvk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Melele xa Iesu di mikakao ba, pus moletin tei xa meten bar xa tevar ngamu melele xa ninen telingi. ");
INSERT INTO tvk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E melele xa moletin xil na Iesu lapusi, lasis Iesu labit, “?Titsa, tesaen na visi iaxa tesak ni met moletin ak tevar e melele xa ninen telingi? ?Tesaen nan tang, mu tesaen na tamen xal ninen?” ");
INSERT INTO tvk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu bit rilomun ni bit, “Tave tesaen nan ti, mu tesaen na tamen mu ninen iaxa tepol ni met moletin ak tevar melele xa ninen telingi. Xi be metevar mak tengan Hi ikila ipisen xeihen nan ixo meulien nan. ");
INSERT INTO tvk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Melele xa meteneai di tamu nesao, rixulehi ti ripol ni polien na Hi xa misil inou namei. Vengan vongien di bemei, e, e melele nen ak, moletin misakras mun vapol. ");
INSERT INTO tvk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E melele xa nada tamu e ut etan, inou nabe miehen teni.” ");
INSERT INTO tvk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Melele xa misepin bus, Iesu mikusah be tan e pol ni mei be mame. Di, miling mame ak e met moletin ak. ");
INSERT INTO tvk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Di, Iesu biteni mini bit, “Uha ukas valnaom e Vangoei Saelom.” (His Saelom, koute teni be ‘misila’). Ma, metevar ak ba mikas valnaon. Melele xa mikasi bus, mikameti xa mikila vaketeh. Di, dilomun be tim. ");
INSERT INTO tvk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Melele xa dilomun be tim san, ngenen xil del ngan xil mun xa lapus kila xa xi iaxa be ngan xa di miram ni moletin xil ve mani latemanin ni e labit, “?Midep? ?Be reitin xa ngan ak be metevar xa, vehakut, matepusi di tetotan e di tetakes moletin xil ve mani?” ");
INSERT INTO tvk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Rute xil labit, “Reitin, xi iaxai.” E rute ngan xil labit, “E‑e, be moletin sav xa mapusi nggoni xi.” E xi vari di biteni mi xil bit, “!Be inou vari!” ");
INSERT INTO tvk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma xil dit lasisi labit, “?Naha vari testal xa tesak ni xouk okila oketeh vamak?” ");
INSERT INTO tvk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Xi bit rilomun ni bit, “Moletin tei, hisen Iesu, pol ni mame e milingi de metok xalu. Di, biteni minou tengan nihe Vangoei Saelom e nikas valnaok en. Melele xa napol ni, vatakes nakila naketeh.” ");
INSERT INTO tvk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Moletin xil lasisi labit, “?E moletin ak da xave?” E ngan xa meten tevar bit, “Natakil ti.” ");
INSERT INTO tvk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ngenen xil ladiamu ni ngan xa meten tevar be visal Farasi xil. ");
INSERT INTO tvk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Melele xa Farasi xil lapus moletin ak, lasisi xa meten mei bos midep xa mikila miketeh mak. Ma, moletin ak biteni mi xil bit, “Iesu iaxa teling mame tete metok xalu. E melele xa natekas valnaok, nakila naketeh sung.” Melele xa Iesu tepol ni mame e tesak ni meten mei tehos, tehe Sabat. ");
INSERT INTO tvk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Melele xa Farasi xil lalong tumulen na moletin xa tehe metevar, rute xil labit, “Iesu misakras vaxo visal Hi, vengan xi talong xat rae xil te Sabat ti.” E rute xil mun labit, “?Xosxa be reitin xa be moletin tesa tei xa taxo visal Hi ti, ma midep iaxa mikila vapol ni merekel xil xa mak?” Ma, Farasi xil langgur nenemien lu (2) usili. ");
INSERT INTO tvk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Misak ni, Farasi xil lasis moletin ak vatei mun labit, “Be xouk iaxa moletin ak tepol ni metom xalu mei bos tengan okila oketeh. ?Onem naha usil moletin ak? ?Be visi vari?” Moletin ak bit rilomun ni bit, “Inou nake reitin xa xi be provet tei.” ");
INSERT INTO tvk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Melele xa vat xil na Siu xil lapus moletin ak, latake reitin ti xa, tetiamu, tehe metevar tei. E lakila sung xa be reitin melele xa lasis tamen xal ninen lumei e lasis pilei xalu usili. ");
INSERT INTO tvk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Lasis xalu labit, “?Be reitin xa moletin ak be horamue namil? E xamil mubit be metevar melele xa ninen telingi. ?Mak, ma, midep iaxa mikila sung vaketeh taxeak?” ");
INSERT INTO tvk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Xalu lubit rilomun ni lubit, “Xamel makila xa be horamue namel. E makila mun xa meten tevar melele xa ninen telingi mei duxoh xosali. ");
INSERT INTO tvk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","E matakil ti sung tetep iaxa mikila vaketeh taxeak, mu visi vari tepol ni meten xalu mei lubos rilomun. E xamim mukila musisi ni, vengan xi matu pipin tengan vasepin e rin nan tasen.” ");
INSERT INTO tvk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tame moletin ak xal ninen lubiteni mak vengan xa ulixalu mikan tengan lalihit his Iesu mi vat xil na Siu xil. Lulongeong ni xa moletin xil vus xa labit rati xa Iesu be Mesaea, vat xil liso rat xil ra nim te pispisienna Siu xil. ");
INSERT INTO tvk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mak, ma xalu lubiteni mi vat xil ak xa horamue nalu matu pipin tengan vasepin e rin nan. ");
INSERT INTO tvk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Misak ni, vatei mun, vat xil na Siu xil lasis moletin xa meten tevar tengan mei vasoh pe metexil. Di, labul xati labit, “!Uhit xati e his Hi xa be eilep pupu xa naha xa di obiteni be reitin! Vengan xa xamem makila xa Iesu ak be moletin tei xa misa.” ");
INSERT INTO tvk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma moletin ak bit rilomun ni bit, “Natakil ti xos moletin ak be moletin tesa tei, mu be visi mun. E neta tei takes nakila. Tetiamu, metok tevar, e xosali, di naketeh.” ");
INSERT INTO tvk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","E xil lasisi mun labit, “?Xi tepol ni naha minuk? ?Tepol ni metom xalu mei tehos texo sexien xave?” ");
INSERT INTO tvk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma, moletin ak bit rilomun ni mi xil bit, “Nabiteni ngamu mi xamim, e xamim iemim ti tavei tengan mulonge. ?Veneh ma iemim bei tengan muteong ni tumulen navan vatei mun? ?Xos xamim mun iemim bei tengan mei muve moletin nan xil?” ");
INSERT INTO tvk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Melele xa lalonge mak, vat xil na Siu xil lasepin misa ba xat moletin ak labit, “!Ei, xouk vari obe moletin nan tei! E xamem, mabe moletin xil na Mosis. ");
INSERT INTO tvk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xamem makila xa Hi tesepin mi Mosis e tesa xeihen mini. E, e rin na moletin xai, matakil ti rute xa xi nggur xeihen nan nggo en.” ");
INSERT INTO tvk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma, moletin xa mei miketeh bit rilomun ni bit, “Natemanin ni sepinien namim xil. Mubiteni xa mutakil ti rute xave xa xi nggur xeihen nan nggo en, neta sav xa pol ni metok xalu mei lubos rilomun. ");
INSERT INTO tvk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Rakila xa Hi tateong ni ti moletin tesa xil xa lasisi ve neta ngan. E di milong sisen na moletin tei xa di merere ni e di pol nggusil naha xa xi ien bei. ");
INSERT INTO tvk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Melele xa Hi tepeas kokot ni ut etan mei duxoh xosali, moletin sav tovuol xa vapol ni met moletin tei xa tehe metevar melele xa ninen telingi mei vahos rilomun. ");
INSERT INTO tvk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","E moletin nen ak tepol ni. Xosxa Iesu taxo visal Hi ti, ma misakras vapol ni merekel xil ak.” ");
INSERT INTO tvk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Melele xa lalonge mak, vat xil na Siu xil lasepin nggeih mini labit, “!Xouk osa pupu e melele xa latepesuk mei duxoh xosali! ?Veneh ma di osak pisi tengan opispisi mi xamem?” Ma laso rati ra nim te pispisien nae. ");
INSERT INTO tvk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Melele xa Iesu milongeong ni xa lateso rat moletin xa mei miketeh ra nim te pispisien na Siu xil, ba tengan valang ni. Melele xa mikameti, misisi bit, “?Xouk oke reitin e Nat Moletin?” ");
INSERT INTO tvk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","E moletin ak bit rilomun ni bit, “Suv, uhiteni minou li xa xi be visi. Imak, ma nikila nike reitin en.” ");
INSERT INTO tvk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma, Iesu biteni mini bit, “Xouk otepusi ngamu. Inou xa di nasepin delak iaxa nabe xi.” ");
INSERT INTO tvk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Melele xa milonge mak, moletin ak biteni bit, “O Suv li, nake reitin e xouk vari.” Ma, be tan e di mot mini. ");
INSERT INTO tvk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu bit, “Namei e ut etan ak tengan nilepis rin na moletin xil. Reitin, namei tengan nipol ni ngan xil xa metexil bar taxeak, mei liketeh; e nipol ni ngan xil xa labit lakila laketeh, metexil mei ivar.” ");
INSERT INTO tvk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Rut Farasi xil ladi sangas, e melele xa lalong sepinien na Iesu lasisi labit, “?Midep? ?Di obiteni xa metemem bar?” ");
INSERT INTO tvk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu bit rilomun ni bit, “Xosxa metemim bar reitin, munahur pangasien ti ve naha xa misa xa xamim di mupol ni. E vengan xa mubit mukila muketeh bos, ma xamim mudi tamu e tesaen namim xil.” ");
INSERT INTO tvk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu biteni mi Siu xil bit, “Reitin li nabiteni mi xamim, moletin xil ak langgoni sipsip xil na Hi xa ladi e vangit vioh nan. E xosxa ngan xil xa labit litiamu ni sipsip xil na Hi di lasin puiteh e di lasak pisi tengan lave vangit vioh ak vaxo suse sav mu di labut xorao e vioh ak, ma ngan xil ak labe moletin te kanen xil xa lasa. ");
INSERT INTO tvk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","E ngan xa be vangit vioh nggo puiteh xati teni, xi be moletin xati xa di milaxat kuh sipsip san xil. ");
INSERT INTO tvk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Melele xa bemei, ngan xa di miketeh xol vioh pus kila, ma misah puiteh mini. E melele xa xi mikes kekes ni sipsip san xil ni hisexil xati, sipsip xil lalong kil raen e di langgusili labe hale. ");
INSERT INTO tvk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","E melele xa mileh rerat san xil vus labe hale, di mikakao diamu ni xil. E sipsip san xil langgusil xati vengan xa lalong kil raen. ");
INSERT INTO tvk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Xil lasakras lavusil moletin sav tova. Reitin, lilesae rani vengan xa latakil ti e latalong kil ti raen.” ");
INSERT INTO tvk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Siu xil lalong vole xa Iesu biteni mi xil, e latakil ti koute teni. ");
INSERT INTO tvk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iesu misepin mun mi xil bit, “Reitin li nabiteni mi xamim, inou nabe puiteh xa sipsip xil langgo en tengan lave vangit vioh nae. ");
INSERT INTO tvk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Moletin xil xa latemei tetiamu ni nou, xil vus latehe moletin xil te kanen xa latesa. E sipsip xil latalong xat xil ti. ");
INSERT INTO tvk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","10","Moletin te kanen xil lamei tengan lakan ni neta, lavas vin sipsip xil, e lapurun holesok xil. E inou nabe puiteh te vioh. E ngan xil xa lamei nim langgo nou, Hi iteh meulien e xil. Xil limei nim e lihe hale lixo nou e likamet husmunae xa ihos. Reitin, namei tengan nakila nasa meulien mi moletin xil, meulien tei xa polu ni hosien. ");
INSERT INTO tvk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“E inou nabe moletin hos te lelaxatien na sipsip xil mun. E inou nabue xat inou tengan nimaen xoteh meulien navan e nimat tengan nihinat sipsip savan xil. ");
INSERT INTO tvk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Xosxa moletin te polien tang di milaxat sipsip xil e pus kuli reran tei bemei, ulin ikan e ilesae reling sipsip xil vengan xa latave san xati ti. Isak ni, kuli reran ak imei ingas vin rut sipsip xil ak e ihol tetasil ni ngan tesav xil. ");
INSERT INTO tvk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Reitin, moletin te polien di milesae tang vengan xa di milaxat xil tengan vahur huit polien teni tang, e eheien nan tara ti e sipsip xil. ");
INSERT INTO tvk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","E inou nabe moletin hos te lelaxatien na sipsip xil. E hisit sexien xa Tata navan mikil inou e inou nakila, inou nakil sipsip savan xil e xil lakil inou. E nabue xat inou tengan nimaen xoteh meulien navan e nimat nihinat xil. ");
INSERT INTO tvk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Sipsip sav xil savan ladi xa lasav ni sipsip xil xa ladi e vioh ak. Momal tengan niha nileh xil mun limei. Xil lilong raeok, e limei limos itel sipsip xil ak. Imak, ma limei lihe tatit sipsip tei takes, e inou nihe moletin te lelaxatien tei takes nae. ");
INSERT INTO tvk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata navan, eheien nan di e nou vengan xa nabue xat inou tengan nisa xoteh meulien navan ve rin nae. E itutou, nikila nihur rilomun ni. ");
INSERT INTO tvk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Moletin tovuol mikila vahur rat meulien navan ra nou. E napol ni nenemien navan tengan nasa rati. Inou nanggur xeihen tengan nasa rat meulien navan, e nanggur xeihen tengan nihur rilomun ni. Ngan ak be naha xa Tata navan tesemae ni nou tengan nipol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Melele xa moletin xil lalong sepinien nan xil, nenemien na Siu xil be lu (2) usil Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xil holu di labiteni labit, “!Temat tei da en xa di misak ni misep talang mak! ?Veneh vari xamim di mulong sepinien nan xil?” ");
INSERT INTO tvk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","E rute xil mun di labiteni labit, “Sepinien nan taxoni sepinien na moletin tei ti xa temat da en. E moletin xa temat da en misakras vapol ni met metevar tei mei vahos vaxoni ngan xa Iesu tepol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aveti lu mei mitavi, e be Disemba, melele xa momal tengan lapol ni Wik Eo te Tuxolxatien te Nim Eo e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E melele nen ak, Iesu bemei e di mikakao e vioh te Nim Eo, rute tei e vioh xa eilep xa lakesi ni veranda na Solomon. ");
INSERT INTO tvk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Melele xa Siu xil lapusi, lakapis xole e lasisi labit, “?Vilieh vari uhit kuhi mi xamem xa obe visi vari? Xosxa obe Mesaea reitin xa Hi tehit xati tehit isa ni imei, uhit rati imese tang.” ");
INSERT INTO tvk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","E Iesu bit rilomun ni bit, “Nabit rati mi xamim ngamu. E xamim mutake reitin ti en. Holesok xil xa napol ni nggo xeihen na Tata navan di lapisen ni xa inou nabe visi. ");
INSERT INTO tvk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","E neta sav xa mak, xamim mutake reitin ti e nou vengan xa mutave sipsip savan xil ti. ");
INSERT INTO tvk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vengan sipsip savan xil lalong kil raeok. Inou nakil xil, e xil langgusil nou. ");
INSERT INTO tvk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi xil iaxa di nasa meulien sal e linakesae ti vatova. E moletin tovuol mikila valeh rerat xil ra heok. ");
INSERT INTO tvk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata navan tesa xil minou, e xi be eilep mak mu mili holesok xil vus. Mak, ma moletin tovuol mikila valeh rerat xil ra he Tata. ");
INSERT INTO tvk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","E Tata navan e inou mabe tei takes.” ");
INSERT INTO tvk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Melele xa lalonge mak, Siu xil laleh hat xil tengan laxov vini. ");
INSERT INTO tvk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","E Iesu biteni mi xil bit, “Tata navan tesa xeihen minou tengan napol ni holesok holu xa bos pe metemim. ?Di mubue xat xamim tengan muhov vin inou ve polien hos eah?” ");
INSERT INTO tvk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Xil labit rilomun ni mini labit, “!Xamem iemem ti navei mavov vinuk ve polien hos tei, e mabit mavov vinuk vengan xa di musep xar ni his Hi vari! !Xouk obe movotei tei tang te ut etan, e di opo rat xouk e sepinien nam obit onggoni Hi vari!” ");
INSERT INTO tvk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu bit rilomun ni bit, “Ladisi de rae namim xil bit, ‘Inou di nabiteni xa xamim mube hi xil.’ ");
INSERT INTO tvk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Rakila xa sepinien na Hi taviles ti. Misak ni, xosxa Vanuvei Eo mikes moletin xil ak ni hi xil, ");
INSERT INTO tvk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","be reitin mak mu usil inou. Vengan xa inou nabe ngan xa Tata tehosei nou e tesil nou tengan namei e ut etan. Mak, ma natasep xar ni his Hi ti e melele xa nabiteni nabit nabe Natneli. ");
INSERT INTO tvk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Xosxa natapol ni ti merekel xil xa Tata navan tesa ni minou tengan ni pol ni, momal tengan mutake reitin ti e nou. ");
INSERT INTO tvk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","E xosxa di napol ni merekel xil, neta sav xa mutake reitin ti e nou, momal tang xa muke reitin e holesok xil xa di napol ni. Imak, ma mukila xa Tata di bisti del nou, e inou di nabisti dela.” ");
INSERT INTO tvk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vatei mun, lasak tengan latal xat Iesu, e xi mea reling hexil. ");
INSERT INTO tvk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Di, Iesu ba be Oeisal Sodan e ba nggur xotehi be rin. Iesu de rute ak del moletin nan xil, e rute xa, tetiamu, Sion di tebaptaes ni moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Moletin xil holu lamei tengan lapusi. E di labiteni mi xil mun tang labit, “Neta sav xa Sion tenapol ni ti merekel tova, holesok xil vus xa xi tehiteni usil moletin ak mei be reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E moletin xil holu e rute ak laneket xa Iesu be Mesaea xa Hi tehit xati tengan isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","E metimal te hal Betani, moletin tei da en, hisen Lasaros. Hineli xalu, Meri xal Merta. (Ihe Meri xa mei iteh vokon iha xat le Suv e isihia ni hilin.) Ma melele xa Lasaros mei mesei holu, ");
INSERT INTO tvk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","hineli xalu lusa sepinien ba mi Iesu bit, “Suv, ngan xa eheien nam di en mesei pupu.” ");
INSERT INTO tvk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Melele xa Iesu milonge, biteni bit, “Hoxalit mesien ak nave maten ti. Ngan ak di mistal tengan vapet rat his Hi e isak ni moletin xil mei lipet rat his Natneli mun.” ");
INSERT INTO tvk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E neta sav xa eheien na Iesu de Merta, Meri e Lasaros eilep pupu, ");
INSERT INTO tvk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","melele xa nggur longeongen xa Lasaros mesei mak, da kat e rute xa da en melengien lu mun. ");
INSERT INTO tvk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Di, Iesu biteni mi moletin nan xil bit, “Ritilomun rihe provins te hal Sudea.” ");
INSERT INTO tvk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E moletin nan xil lasisi labit, “Titsa, tenave nousav ti, Siu xil te rute ak latesak tengan lavov vinuk. ?Ma xouk iem bei tengan utilomun uha veneh?” ");
INSERT INTO tvk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu misepin bit, “E melengien tei, eai di ngan haoa lu e le tei (12). E ngan xil xa di lakakao e miehen lasakras lasavut vengan xa miehen xa bemei e ut etan ak di misak ni xil di lapus kil holesok xil vus. ");
INSERT INTO tvk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","E ngan xil xa lakakao e maluxoluken lasavut, vengan xa miehen tovuol e xil.” ");
INSERT INTO tvk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Di, Iesu bit rilomun ni bit, “Tua nar Lasaros ba pat li. E inou niha nisiasi ni tengan ilale.” ");
INSERT INTO tvk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma, moletin nan xil labiteni labit, “Suv, xosxa xi pat kuhi, ma di meul e, ti, ilonge ihos rilomun.” ");
INSERT INTO tvk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Xil lanemi xa Iesu di misepin usil paten na Lasaros, e xi di bit usil maten na Lasaros vari. ");
INSERT INTO tvk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mak, ma Iesu bit lelen ni mi xil bit, “Lasaros mat ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E nabesi nou xa natnara ti visal xil e melele nen ak, vengan xa ngan ak itutou ni xamim tengan muke reitin mak mu e nou. Rihe visali.” ");
INSERT INTO tvk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mak, ma Tomas, ngan xa lakesi ni Meah, biteni mi xil bit, “Xir vus riha tengan ha rimat itela.” ");
INSERT INTO tvk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Melele xa Iesu duxoh metimal te hal Betani, xi mikameti xa lateling tiei na Lasaros de vangihat te tehinen melengien hat (4) ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani tave sotin ti ra hal Serusalem, be kilomita tol (3 km) tang. ");
INSERT INTO tvk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma, Siu xil holu lamei tengan lasa esaeen nae mi Merta e Meri ve maten na tua nalu. ");
INSERT INTO tvk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Melele xa Merta milongeong ni xa Iesu di bemei, xi ba tengan ha vahisu mini. E Meri dat tim. ");
INSERT INTO tvk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Melele xa Merta pus Iesu, biteni mini bit, “Suv, vahit xouk otete inggak, tua navan namat ti li. ");
INSERT INTO tvk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E nakila xa xosali ak, Hi isa ni minuk naha xa di osisi ven.” ");
INSERT INTO tvk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu biteni mini bit, “Tumali imea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Merta bit rilomun ni bit, “Nakila xa xi imea rilomun ra maten e hoxalite te holesok xil vus.” ");
INSERT INTO tvk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu biteni mini bit, “Inou nabe vatit mea rilomunen e nabe vatit meulien. Ngan xil xa lake reitin e nou, neta sav xa lamat, xil limea rilomun ra maten e limeul. ");
INSERT INTO tvk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E ngan xil xa lameul tamu ladi e lake reitin e nou, xil linamat ti vatova. ?Midep? ?Oke reitin e ngan ak?” ");
INSERT INTO tvk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Xi bit rilomun ni bit, “Suv, nake reitin xa xouk obe Mesaea, Nat Hi, ngan xa xi tehit xati tengan isila imei e ut etan.” ");
INSERT INTO tvk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Melele xa Merta misepin mi Iesu bus, dilomun be tim e mikes xuxus ni tunehin Meri. Ngguri be rin e biteni mini bit, “Titsa bemei inggak e di misisuk.” ");
INSERT INTO tvk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Melele xa Meri milonge mak, mea katen e be hale tengan ha vapusi. ");
INSERT INTO tvk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Melele xa ngan xil xa di ladang dela lapusi xa mea katen mak, langgusili. Lanemi labit xi di be vangihat te tehinen tengan ha vatang en. Iesu datil Meri e rute xa Merta tehisu ni e seri metimal te hal Betani. ");
INSERT INTO tvk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Melele xa Meri duxoh rute xa Iesu da en, pusi ma mitingeiril sangas ni len e midang bit, “!O Suv, vahit otete inggak, tua navan li namat ti!” ");
INSERT INTO tvk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Melele xa Iesu pusi di midang mak, e pusi midep moletin xil xa lamei dela di ladang, xi mun milonge misa e tinen muis. ");
INSERT INTO tvk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Misis xil bit, “?Mutetihin ni ingga xave?” Labit rilomun ni labit, “Suv, amei pusi.” ");
INSERT INTO tvk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Melele xa di laba, simete Iesu mileh. ");
INSERT INTO tvk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","E ngan xil xa lapusi labiteni labit, “Pus ti mu. Eheien nan di pupu e tua nan.” ");
INSERT INTO tvk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","E rute xil labiteni labit, “Xi tepol ni met metevar mei miketeh. ?Veneh vari tenapol ni Lasaros tengan namat ti?” ");
INSERT INTO tvk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Melele xa laduxoh vangihat te tehinen, Iesu milonge misa mun. Pusi xa ladivin hat tei xa eilep da xol puiteh te vangihat ak. ");
INSERT INTO tvk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma, Iesu biteni bit, “Mutivin rat hat ak vaha.” Merta, hine ngan xa temat, bit rilomun ni bit, “Suv, tiei nan bo ngamu vengan xa mat melengien hat (4) tuei.” ");
INSERT INTO tvk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","E Iesu biteni mini bit, “Nabiteni tuei minuk xa upus minehinen te xeihen na Hi xosxa uke reitin en.” ");
INSERT INTO tvk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma, moletin xil ladivin rat hat ak ba. Di, Iesu miketeh be nesao e misis bit, “Tata, namesuk vengan xa di olong nou. ");
INSERT INTO tvk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nakila xa vehakut di olong nou, e nabit lelen sepinien ak ve moletin xil ak, tengan isak ni xil like reitin xa xouk iaxa otesil nou namei.” ");
INSERT INTO tvk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Melele xa bit sepinien ak bus, Iesu mikei nggeih bit, “!Lasaros, amei hale!” ");
INSERT INTO tvk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","E moletin xa temat mea e bemei hale. Mavulut kaliko xil di tamu bar xat tenben, hen e len del valnaon mun. Misak ni, Iesu biteni mi moletin xil bit, “Muleh rerat kaliko rani e mumaen ni ha ven imase.” ");
INSERT INTO tvk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Melele xa Siu xil xa langgusil Meri lapus naha xa Iesu pol ni, holu e xil lake reitin en. ");
INSERT INTO tvk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","E rute xil labe visal Farasi xil, e labit mesen ni mi xil naha xa Iesu tepol ni. ");
INSERT INTO tvk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mak, ma Farasi xil e vat xil na pris xil lakes viton kaonsel nae. Melele xa lamei vituei, lasis xil mun tang labit, “?Ripol ni naha vari mi Iesu? Xi dit pol ni merekel xil holu. ");
INSERT INTO tvk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Xosxa rimaen ni tengan ixulehi ipol imak, ma moletin xil vus mei like reitin en e lisak pisi tengan lilingi mei ihe suv toto nae. !Xosxa imak, ma mol‑Rom xil mei lihu len Nim Eo nar, e lipurun sen mol‑Isrel xil vus e kantri nar!” ");
INSERT INTO tvk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tei e kaonsel, hisen Kaeafas. Xi be vatixar na pris xil e huram ak. E melele xa milong sepinien na ngan xil te kaonsel, biteni mi xil bit, “!Xamim mutakil ti neta! ");
INSERT INTO tvk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ihos mak mu xosxa moletin tei takes imat e rin na moletin xil, ili xosxa rimaen mol‑Rom xil mei lipurun sen mol‑Isrel xil vus e kantri nar.” ");
INSERT INTO tvk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaeafas taviten sepinien ak ti vaxo nenemien nan tasen. E, texo polien nan usil vatixar na pris xil te huram ak, xi tehit lelen ni xa Iesu imat ihinat mol‑Isrel xil. ");
INSERT INTO tvk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E bit lelen ni mun xa Iesu imat e rin na horamue xil vus na Hi xa ladi e kantri sav xil tengan ileh viton xil mei lihe tatit moletin tei takes. ");
INSERT INTO tvk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Misak ni, e melele nen ak ba, vat xil na Siu xil lapol ni lingxatien tei tengan lihas vin Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mak, ma Iesu takakao ti mun e valkesao pe met Siu xil. Be reling rute ak e be metimal sav tei xa lakesi ni Efrem, xa de sangas ni uruvuol. E de rute ak del moletin nan xil melengien vahis. ");
INSERT INTO tvk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Melengien eo xil te Anien te Tavien di bemei sangas, e Siu xil hao langgo ut xil vus te kantri ak e labe Serusalem. Di laba tengan lapol ni sexien xil xa ipol ni xil mei limese pe met Hi tengan likila lipol ni holesok xil te anien eo ak. ");
INSERT INTO tvk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","E moletin xil di lalang ves Iesu. Melele xa lamei vituei e vioh te Nim Eo, di lasis xil mun tang labit, “?Munemi midep? ?Iesu imei e anien eo ak, mu namei ti?” ");
INSERT INTO tvk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Labiteni mak vengan xa vat xil na pris xil e Farasi xil latesemae ni xa moletin tova xa mikil rute xa Iesu da en imei ihit mesen ni mi xil tengan likila liha lital xati. ");
INSERT INTO tvk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Melengien tei e he sav (6) diamu ni Anien te Tavien, Iesu be metimal te hal Betani. Ba misao ni Lasaros e tim san, moletin xa tepol ni temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma, xil lapol ni anien tei xa eilep tengan lapisen memesien nae mini. Merta mileh anien bemei, e Lasaros dotan vituei e tep te anienen del Iesu e moletin sav xil mun. ");
INSERT INTO tvk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Di, Meri nggur valit vokon tei xa lapol ni ni nard xa mani nen be nesao pupu. Be sangas visal Iesu e mitahi ba xat le Iesu tengan vamerere ni. Di, Meri misihi moten len ni hilin. Melele xa pol ni mak, vut vokon xa bos xiak nggur sen rute xil vus e nim. ");
INSERT INTO tvk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","E, melele xa tei e moletin lu e le tei (12) na Iesu pusi, xi tavesi xi ti ven. His moletin ak Sudas Eskariot, ngan xa isa rat Iesu ihe he elu nan xil. Ma, xi bit, ");
INSERT INTO tvk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“?Veneh ma latapos ni vokon ti xa xiak tengan lasa mani nen mi hoeo xil? Vengan xa mani teni pipin ni silva mani handred tol (300).” ");
INSERT INTO tvk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Xi taviten sepinien ak ti vengan xa ien misae pupu ni hoeo xil. !E‑e! Xi misepin mak vengan xi be moletin te kanen tei. Vengan xa xi iaxa milaxat ateli te mani na Iesu e ngenen xil, e di mikan ni mani ra ni. ");
INSERT INTO tvk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","E Iesu biteni mini bit, “!Lingi! Atou ak nggal vokon ak tengan vavue xat tenbeok vamese ve melele te tehinen navan. ");
INSERT INTO tvk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hoeo xil liti visal xamim vehakut. E inou, ninata ti visal xamim vehakut.” ");
INSERT INTO tvk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Melele xa moletin xil lalonge xa Iesu de metimal te hal Betani, moletin xil holu xa holu pupu lamei tengan lapusi. Lamei mun tengan lapus ti Lasaros xa Iesu tesak ni temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","E melele xa vat xil na pris xil lalongeong ni, lapol ni lingxatien tengan lihas vin Lasaros mun. ");
INSERT INTO tvk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Labit lihas vini vengan lapusi xa merekel xa mistal en pol ni moletin xil holu lake reitin e Iesu, e latahusil xil ti mun. ");
INSERT INTO tvk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ut milan, vanut moletin xil xa lamei e hal Serusalem tengan lapol ni Anien te Tavien en lalonge xa Iesu di bemei. ");
INSERT INTO tvk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ma, ladei ut emeil xil e ba labisu mini e suse. E melele xa lakakao laba, lameun be nesao labit, “!Memesien ba mi Hi! !Tuxolxatien iti mi ngan xa bemei e his Iahova! !Tuxolxatien iti mi suv toto te hal Isrel!” ");
INSERT INTO tvk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu mikamet sulut dongki tei e miloh nggo en ba. Ngan ak nggoni ngan xa Vanuvei Eo tehiteni xa tehit, ");
INSERT INTO tvk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Xamim xa mudi e taon te hal Serusalem e Vathu Saeon ulimim nakan ti. !Mupusi! Suv toto namim di bemei tengan valaxat kuh xamim. Reitin, di dotan e sulut dongki tei tang e di bemei.” ");
INSERT INTO tvk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Melele xa holesok xil ak di mistal, moletin lu e le tei (12) na Iesu latakil ti koute teni. E, dutou sung, melele xa Hi tetal rat Iesu tehe nesao tengan vahur xeihen nan, lanem xati xa holesok xil xa testal mini tehusil xat naha xa Vanuvei Eo tehit lelen ni usili. ");
INSERT INTO tvk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Holu e vanut moletin xil ak latehur longeongen usil Iesu texo ngan xil xa latehithiteni xa tetep iaxa xi tekes rat Lasaros ra vangihat te tehinen e tesak ni temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ve rin ak, moletin xil holu pupu latelongeong tumulen usil merekel ak, e laba tengan lavisu mi Iesu e suse. ");
INSERT INTO tvk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","E melele xa Farasi xil lapus tatit moletin xil xa mahulong xiak, labiteni mi xil mun tang labit. “!Mupus ti mu! !Moletin xil vus e ut etan di langgusil xati ngamu! Misakras mun mupol ni ti neta tova vaha xati.” ");
INSERT INTO tvk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Melele xa Siu xil labe Serusalem tengan lava lamot mi Hi e melele te Anien te Tavien ak, rut mol‑Kris xil mun laba. ");
INSERT INTO tvk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mol‑Kris xil ak ba lapus Pilip, xa nggo metimal te hal Betsaeta e provins te hal Kaleli. E labiteni mini labit, “Xamem iemem bei tengan mapus Iesu.” ");
INSERT INTO tvk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ma, Pilip ba bit mesen ni mi Andru, e xalu luba lubiteni mi Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","E Iesu bit rilomun ni bit, “Melengien bemei xiak tengan Hi ipet rat his Nat Moletin. ");
INSERT INTO tvk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nitei vole usil reitinen tei mi xamim. Xosxa utiei tei namot ti vahe tan e latatihin ni ti naxoni ngan xa mat, ma utiei ak itat imak tang. E xosxa itihin utiei ak e tan ixoni ngan xa mat, ma itutou sung, imeul rilomun e ihur huite xil lihe holu. ");
INSERT INTO tvk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ngan xil xa iexil bei meulien nae, meulien ak ha ikesae ra xil. E ngan xil xa iexil nggat meulien nae e ut etan ak, xil vari lihur xat meulien nae iti vehakut. ");
INSERT INTO tvk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ngan xil xa iexil bei tengan lapol minou, xil lihusil nou. Vengan rute xave xa inou nada en, moletin te polien navan xil mun liti en. E Tata navan isa merereen mi ngan xil xa di lapol minou. ");
INSERT INTO tvk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Xosali, tinok li polu ni nenexoen. ?E nihit neh? Vahit nisis Tata navan tengan iteh meulien e nou tengan ninahisu ni ti melengien te xeih ak. E ninapol ni ti. Vengan xi tesil nou namei tengan nihisu ni longpangasien xil ak.” ");
INSERT INTO tvk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Di, Iesu misis bit, “O Tata li, upisen ni xa hisom be eilep mak mu.” Melele xa misis mak, rae tei misepin nggo ut nesao bit, “Natepisen ni xa hisok be eilep mak mu ngamu, e nipol rilomun ni.” ");
INSERT INTO tvk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Vanut moletin xil xa lasoh ladi e rute ak lalong rae ak, e rute xil labiteni labit be veta tang xa di posou. E rute xil mun labit, “!Masxaxa tei misepin mini!” ");
INSERT INTO tvk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","E Iesu biteni mi xil bit, “Rae ak tasepin ti tengan vatutou ni nou. E misepin mak tengan vatutou ni xamim. ");
INSERT INTO tvk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Melele bemei ngamu tengan Hi isa pangasien ihusil lepisien nan ve tesaen na moletin xil te ut etan ak. Melele bemei ngamu tengan Hi ihu len xeihen na Temat xa tehe vat na moletin xil holu te ut etan e ihol rati iha. ");
INSERT INTO tvk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","E melele xa moletin xil lipo rat inou e nimurur nihe nesao, nileh moletin xil vus limei visal nou.” ");
INSERT INTO tvk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu biteni mak tengan vahit lelen sexien xa imat ixo en. ");
INSERT INTO tvk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Vanut moletin xil ak labit rilomun ni labit, “Vanuvei Eo na Hi di biteni xa Mesaea ita vehakut. ?Ma, veneh ma di obiteni xa lipo rat Nat Moletin e imurur ihe nesao? ?Visi vari iaxa be Nat Moletin nen ak?” ");
INSERT INTO tvk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iesu biteni mi xil bit, “Miehen iti mi xamim ihe vuteili mun. Ma, bos xa ti mukakao kuhi e melele xa miehen di tamu mileluv tengan maluxoluken nakutaxol xamim ti. Vengan ngan xil xa lakakao e maluxoluken latakil ti rute xa di laba en. ");
INSERT INTO tvk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ma, muke reitin e miehen ak melele xa di tamu mileluv, tengan mei muhe moletin xil te miehen.” Melele xa Iesu misepin mi moletin xil bus, be reling xil e ba minggus ra xil. ");
INSERT INTO tvk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E neta sav xa Iesu pol ni merekel xil holu pe metexil, tave moletin xil vus ti xa lake reitin en. ");
INSERT INTO tvk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngan ak mistal be reitin nggusil naha xa provet Aesea tehiteni tehit, “?Iahova, vahit moletin tei vahit usil longeongen ak tetiamu, visi vari vake reitin en? ?O Iahova, visi mikila vapus kil hem vaxo sexien xil xa di mistal xiak?” ");
INSERT INTO tvk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Misak ni, xil lasakras lake reitin en, vengan xa Aesea tehiteni mun tehit, ");
INSERT INTO tvk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Hi misak ni xil di label xat metexil e tinexil mei nggeih pilei sung. Imak, ma linapus kil ti neta ni metexil, e linanem kil ti neta naxo tinexil. Vengan xosxa namak ti, ma lihiles meulien nae, e Hi ital rat xil ra mesien nae xil.” ");
INSERT INTO tvk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Provet Aesea tesa sepinien ak vengan xa tepus kil minehinen te xeihen na Iesu e tehit lelen ni usili. ");
INSERT INTO tvk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","E neta sav xa rin ak be reitin, moletin xil holu, del rut vat xil na Siu xil mun, lake reitin e Iesu, e ulixil mikan tengan lavit rati. Ulixil mikan mak vengan xa Farasi xil labiteni xa ngan xil xa labit rati xa Iesu be Mesaea, liso rat xil ra nim te pispisiennae xil. ");
INSERT INTO tvk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Melele xa ngan xil ak ladit votei mak, lapisen ni xa iexil bei mak mu tengan mei lihe eilep pe met moletin xil ili ngan xa lihe eilep pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu mikei nggeih bit, “Ngan xil xa laneket e nou, tave ti inou kestang xa laneket en. Di lapisen ni xa di laneket mun e ngan xa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Vengan ngan xil xa lapus nou, nggoni ngan taxa di lapus ngan xa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Namei nabe miehen xa di mileluv xol moletin xil te ut etan, tengan ngan xil vus xa lake reitin e nou linati ti mun e maluxoluken. ");
INSERT INTO tvk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Xosxa moletin tei milong sepinien navan e talong xati ti, inou ninasa pangasien ti mini. Vengan xa natamei ti e ut etan tengan nasa pangasien mi moletin xil teni. E‑e, namei tengan niteh meulien e xil. ");
INSERT INTO tvk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","E ngan xil xa lasin nou e laling nenemien nae tengan linake reitin ti e sepinien navan, tei da xa isa pangasien mi xil. E, e hoxalite te holesok xil, e Melengien te Lepisien, sepinien navan xil iat xil e ipisen ni xa imal tengan lihur pangasien ak. ");
INSERT INTO tvk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngan ak ihe reitin, vengan xa natavit ti neta xa vaxo nenemien navan tasok, e di nabit neta xil xa Tata xa tesil inou namei tesemae ni minou tengan nihiteni. ");
INSERT INTO tvk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma, di nabit mesen sepinien kestang xa Hi tesemae ni minou tengan nihiteni, vengan xa nakila xa moletin xil likamet meulien sal ixo en.” ");
INSERT INTO tvk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Be melengien tei sutang da, e ihe melengien eo te Anien te Tavien. Iesu mikila ngamu xa melele xa istokovein ut etan e ihe visal Tamen di bemei sangas. Ma, vengan xa eheien nan di e moletin xil xa Hi tesa ni mini, Iesu ien bei tengan vapisen eheien nan mi xil ha ituxoh hoxalit meulien nan. ");
INSERT INTO tvk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E Temat tesa nenemien ngamu mi Sudas, nat Saemon Eskariot, tengan isa rat Iesu ha ihe he elu nan xil. Di, e vongien, Iesu di ngganien del moletin nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","E xi minem kila xa Tata teling holesok xil ngasen de hen ngamu, e mikila mun xa xi texo visal Hi e itilomun iha ite visali. ");
INSERT INTO tvk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Misak ni, mitamea ra von anien en, misil rat kot xa mising ni, e mituatu ni taol tei. ");
INSERT INTO tvk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mising mak bus, miteh oei be pesin tei, di, poe be visal moletin nan xil. Bus, Iesu mikas kekes ni le moletin nan xil. Di, misihi lexil ni taol xa mituatu ni. ");
INSERT INTO tvk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Melele xa Iesu duxoh Saemon Pita, Pita biteni mini bit, “?Suv, veneh vari di obit ukas leok?” ");
INSERT INTO tvk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","E Iesu bit rilomun ni mini bit, “Taxeak otakil ti mu naha xa di napol ni, e itutou sung, mei ukila.” ");
INSERT INTO tvk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","E Pita biteni nggeih bit, “!E‑e, xouk onakas leok ti vatova!” E Iesu bit, “Xosxa natakas lem ti, ma rin nam tovuol e nou.” ");
INSERT INTO tvk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma Saemon Pita bit, “!Suv li, xosxa imak, ma onakas leok ti kestang! !E ukas heok xalu e vatuk mun!” ");
INSERT INTO tvk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu biteni mini bit, “Ngan xil xa langgul tuei lamese, linakas ti mun tenbexil vus. Ihe lexil kestang iaxa likas rilomun ni. E xamim mumese ngamu, e tave xamim vus ti xa mumese.” ");
INSERT INTO tvk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu biteni xa tave xil vus ti iaxa lamese, vengan xa tekila ngamu visi iaxa isa rati ha ihe he elu nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Melele xa Iesu mikas lexil bus, mising rilomun ni kot nan e dotan de von anien en. Di, biteni mi xil bit, “?Xamim mukil koute te naha xa napol ni mi xamim xiak? ");
INSERT INTO tvk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mukes inou ni ‘Titsa’ mu ‘Suv,’ e momal tengan mupol ni mak, vengan xa be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma, vengan xa inou, xa nabe Suv e Titsa namim, di naling nenemien navan be tan e nakas moten lemim, ma momal tengan xamim ti mukas moten lemim xil mun tang. ");
INSERT INTO tvk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inou napol ni sexien ak tengan xamim mukila mupol ni ixoni nou. Imak, ma ha mututou ni mosav xil itel nenemien xa be tan, ixoni ngan taxa inou di napol ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Reitin li nabiteni mi xamim, slev tei nave eilep ti nali masta nan, e eloheoh tei nave eilep ti nali ngan xa di misila. ");
INSERT INTO tvk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xosxa mukil reitinen ak, tuxolxatien iti mi xamim xosxa mupol ihusili.” ");
INSERT INTO tvk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Di, Iesu biteni mi moletin nan xil bit, “E nataviteni ti xa tuxolxatien ak iti mi xamim vus. Melele xa natehosei xamim tengan mei muhusil inou, nakil xamim ngamu. E natehosei tei e xamim mun tengan naha xa Vanuvei Eo tehit lelen ni mei ihe reitin xa bit, ‘Moletin xa ngganien del nou, xi vari biles e pol misa minou.’ ");
INSERT INTO tvk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Sexien ak tamei ti mu, e di nabit mesen ni mi xamim taxeak tengan, melele xa mei istal, xamim muke reitin xa inou nabe xi. ");
INSERT INTO tvk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Reitin li nabiteni mi xamim, moletin xa nggur pilei moletin tei xa nasila, nggoni ngan xa di nggur pilei inou mun. E moletin xa di nggur pilei inou, nggoni ngan xa xi di nggur pilei ngan xa tesil inou namei.” ");
INSERT INTO tvk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Melele xa Iesu bit sepinien ak bus, tinen polu ni nenexoen e bit lelen ni bit, “Reitin li nabiteni mi xamim, tei e xamim isa rat inou ha nihe he elu navan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Melele xa moletin nan xil lalonge mak, laketeh mikapis e xil mun tang, e latakil ti visi vari iaxa Iesu di bit usili. ");
INSERT INTO tvk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tei e moletin nan xil, ngan xa eheien na Iesu da en holu, xi di dotan e ri Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma, Saemon Pita misepin mini nggo hen bit xi isis Iesu xa di bit usil visi vari. ");
INSERT INTO tvk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Misak ni, moletin nan ak milis be visal Iesu e misisi bit, “?Suv, visi vari?” ");
INSERT INTO tvk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","E Iesu bit rilomun ni mini bit, “Niso saxut beret ak ihe sup xa iaxor e nisa ni mini. Xi vari iaxai.” Ma, Iesu nggur rut beret tei, miso ni be sup, e di, misa ni mi Sudas, nat Saemon Eskariot. ");
INSERT INTO tvk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ma Sudas nggur rut beret ak. Bus di, Temat mei mise xat nenemien nan. E Iesu misepin mi Sudas bit, “Neta xa onemi obit upol ni, utemanon ha upol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tovuol e xil xa ladotan e von anien en ak vakila veneh ma Iesu bit sepinien ak mini. ");
INSERT INTO tvk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Rute e xil lanemi labit Iesu di misila tengan ha vaxal neta tei ve anien ak, mu tengan vasa neta tova mi hoeo xil vengan xa Sudas iaxa di milaxat mani nae. ");
INSERT INTO tvk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ma, dutou ni ngan xa tehur rut beret ak, Sudas mitemanon be hale. E be vongien ngamu. ");
INSERT INTO tvk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Melele xa Sudas ba, Iesu biteni bit, “Taxeak be melele xa momal tengan Hi isa ni minou, Nat Moletin, his tei xa eilep. E naha xa ti nipol ni ipisen ni xa his Hi be eilep mak mu. ");
INSERT INTO tvk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","E vengan xa naha xa nipol ni ipisen ni xa hisen be eilep mak mu, ma Hi vari iaxa ipisen ni xa hisok, Nat Moletin, be eilep mun. E ipol ni xosali tang. ");
INSERT INTO tvk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Xamim li munggoni tutut horamue navan xil. E nite visal xamim vuteili mun. Ivus, ti mulang ni nou, e munapus ti nou. Nabiteni mi xamim sepinien xa natesa ni mi vat xil na Siu xil melele xa nabit, ‘Rute xa inou niha en, xamim musakras muva en.’ ");
INSERT INTO tvk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","E di nasa rae hu tei mi xamim: eheien namim iti e xamim mun tang. Ixo hisit sexien xa inou di napisen eheien navan mi xamim, xamim mun ti mupisen eheien namim mi xamim mun. ");
INSERT INTO tvk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Xosxa xamim di mupisen eheien mi xamim mun tang, ma moletin xil vus lipus kila xa mube moletin navan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saemon Pita misis Iesu bit, “?Suv, uha xave?” E Iesu bit rilomun ni bit, “Rute xa inou niha en, xouk osakras ova en taxeak. E itutou sung, xouk uhusil inou.” ");
INSERT INTO tvk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","E Pita misisi bit, “?Suv, veneh vari nasakras namusiluk taxeak? !Inou nabue xat inou tengan nimat e rin nam!” ");
INSERT INTO tvk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu bit rilomun ni bit, “?Reitin mak xa obue xatuk tengan umat ve nou? Reitin li nabiteni minuk xa ut nalan ti mu, e tuto nakorat ti mu, e xouk uhiteni ihe vatol ngamu xa otakil ti nou.” ");
INSERT INTO tvk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu misepin mi moletin nan xil bit, “Munanexo ti e munalonge ti nasa. Muneket e Hi e muneket e nou mun. ");
INSERT INTO tvk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","E rute xa Tata navan da en, vontoen holu ladi en. E inou niha tengan nisak mesen vonemim. Ngan ak be reitin, vengan vahit nave reitin ti, ma ninaviteni ti mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E vengan xa be reitin xa niha nisak mesen vonemim, reitin mak mu xa nitilomun e nileh xamim mumei visal inou. Isak ni, xamim muti e rute xa inou ha nita en. ");
INSERT INTO tvk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","E xamim mukil suse ngamu xa be rute xa inou niha en.” ");
INSERT INTO tvk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","E Tomas biteni mini bit, “Suv, xamem matakil ti rute xa uha en. ?Misak ni, xamem mukil suse nen itep?” ");
INSERT INTO tvk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu biteni mi moletin nan xil bit, “Inou nabe suse, inou nabe reitinen, e inou nabe meulien. Moletin tovuol mikila vahe visal Hi Tata xosxa naxo inou ti. ");
INSERT INTO tvk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xosxa xamim mukila xa nabe visi, ma mukil Tata navan mun. Ma, xosali iha, mukil kuh Hi Tata ixoni ngan taxa mutepusi reitin.” ");
INSERT INTO tvk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma Pilip biteni mini bit, “Suv, upisen Hi Tata mi xamem, e ngan ak iaxa ipin ni xamem.” ");
INSERT INTO tvk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu bit rilomun ni bit, “Pilip, natete visal xamim be nousav ngamu. ?Veneh ma otakil ti nou mu? Moletin xa pus inou, nggoni ngan xa di pus Tata mun. ?Veneh vari di osis nou tengan nipisen Tata mi xamim? ");
INSERT INTO tvk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Be reitin iaxa otake reitin ti mu xa inou nabisti del Tata, e Tata bisti del nou? Sepinien xil xa di nabiteni mi xamim tastal ti vaxo inou tasok. Tata xa di nabisti dela iaxa di misa ni minou, e xi misak ni nou di napol ni polien nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Muke reitin xa inou nabisti del Tata, e Tata di bisti del inou. E neta sav xa musakras muke reitin e rin ak, muneket e nou tang ve polien xil xa di napol ni. ");
INSERT INTO tvk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Reitin li nabiteni mi xamim, ngan xil xa laneket e nou ti lipol ni holesok xil xa tellep ixoni nou. Reitin, xil lipol ni holesok xil xa ihe eilep mak mu ili ngan xa inou di napol ni, vengan xa inou ha nite visal Tata. ");
INSERT INTO tvk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma melele xa musis ve neta e hisok, inou nipol ni tengan inou, Nat Hi, nikila nisak ni his Tata navan ihe nesao mak mu. ");
INSERT INTO tvk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Reitin, xosxa musis ve neta tova e hisok, inou nipol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Iesu biteni mun mi moletin nan xil bit, “Xosxa eheien namim di e nou, ma mulong xat rae navan xil. ");
INSERT INTO tvk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Imak, ma nisis Tata navan, e xi isa xoles teimun tesav tengan mei isa tutouen mi xamim e iti mi xamim vehakut. ");
INSERT INTO tvk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Di nasep usil Ninin xa di pisen reitinen na Hi mi moletin xil. E nara ti mi ngan xil xa labe te ut etan tang vengan xa lasakras lapus kila e latakil ti xi. E xamim mupus kila vengan xa xi di bisti del xamim e iti mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Melele xa niha, ninastokovein xamim ti naxoni ngan xa mube timaru xil. Vengan xa nitilomun nimei visal xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nave nousav ti, ngan xil xa labe te ut etan tang linapus ti mun inou, e xamim mupus inou e melele xa nimeul rilomun. E vengan xa nimeul rilomun, mukila xa xamim mun mumeul rilomun. ");
INSERT INTO tvk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","E melele nen ak, xamim mukila xa inou nabisti del Tata navan, e xamim mubisti del inou, e inou nabisti del xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ngan xil xa langgur rae navan xil e lalong xati, di lapisen ni xa eheien nae de nou. E ngan xil xa eheien nae de nou, eheien na Tata navan ite xil, e eheien navan mun ite xil e nipisen inou mi xil.” ");
INSERT INTO tvk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sudas, xa tave Sudas Eskariot ti, bemei visal Iesu e misisi bit, “?Suv, itep vari iaxa ti upisen xouk mi xamem e nave mi ngan tesav xil te ut etan?” ");
INSERT INTO tvk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu biteni mini bit, “Ngan xil xa eheien nae di e inou lilong xat neta xa nabiteni. Imak, ma eheien nan Tata navan iti mi xil. Xamel malimei maliti visal xil. ");
INSERT INTO tvk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","E ngan xil xa eheien nae tara ti e nou, latalong xat ti neta xa di nabiteni. E naha xa di mulong inou di nabiteni taxo ti e nou tasok, di nggo visal Tata xa tesil nou namei. ");
INSERT INTO tvk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Di natehit holesok xil ak melele xa nateta tamu visal xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","E hisok, Tata isil Ninin Eo xa imei ihe ngan te tutouen. Xi imei ipispisi mi xamim ni holesok xil vus e isak ni xamim munem xat holesok xil vus xa di natehiteni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Reitin xa nihe reling xamim, e di nasa tomat navan ite tinemim. Tomat xa nasa ni mi xamim taxoni ti naha xa ngan xil te ut etan di lasa ni. Ma, munanexo ti e ulimim nakan ti. ");
INSERT INTO tvk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Xamim di mulong nou nabiteni xa nihe reling xamim, e ivus, nitilomun nimei visal xamim. Xosxa eheien namim de nou reitin, ma muhesi xamim ihe holu xa nihe visal Tata navan. Vengan xi be eilep mak mu mili nou. ");
INSERT INTO tvk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Di nabit holesok xil ak mi xamim taxeak tengan, e melele xa mei istal ihe reitin, xamim mupus kila e muke reitin e naha xa natehiteni. ");
INSERT INTO tvk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ninasepin ti mun nave holu mi xamim vengan xa Temat, ngan xa be vat na moletin xil holu te ut etan, di bemei. Xi taxur ti xeihen vali nou, ");
INSERT INTO tvk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","e niha nihe hen ixoni ngan xa Tata tesemae ni nou tengan ti nipol ni. Imak, ma moletin xil te ut etan lipus kila xa eheien navan de Tata navan. “E taxeak, mumea, rave reling rute ak.” ");
INSERT INTO tvk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","E Iesu dei vole mi moletin nan xil bit, “Inou nabe vatite xa be reitin e Tata navan nggoni moletin xa di milaxati. ");
INSERT INTO tvk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E lite xil ngasen xa lataso ti huite, xi ita xoteh xil liha. E lite xil xa laso huite, xi ita moten xil tengan isak ni xil mei liso huite ihe holu mu. ");
INSERT INTO tvk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","E xamim mumese ngamu vengan xa mutehur sepinien xil xa natesa ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ma muxulehi muhisti itel nou, e inou mun nixulehi nihisti itel xamim. E hisit sexien xa lite xil xa latavisti ti vatel vatite lasakras laso tase ni huite, xamim mun musakras muso huite e meulien namim xosxa munavisti ti natel inou. ");
INSERT INTO tvk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Inou nanggoni vatite ak, e xamim munggoni lite xil teni. Ngan xil xa labisti del inou, e inou del xil, ti liso huite ihe holu e meulien nae. E xosxa munavisti vatel inou, misakras mupol ni ti neta. ");
INSERT INTO tvk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ngan xil xa latavisti ti vatel nou langgoni lite xil xa langguxou e labue. Hisit lite xil xa lamak, Hi ileh viton xil, e iso xil lihe upang xa ia len xil vari. ");
INSERT INTO tvk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","E xosxa mubisti del inou, e munggusil xat sepinien navan xil, xamim mukila musis ve neta xa iemim bei, e Hi ipol ni. ");
INSERT INTO tvk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","E di mumerere ni Hi Tata melele xa muso huite xil lihe holu e meulien namim. Imak, ma mupisen ni xa mube moletin navan xil reitin. ");
INSERT INTO tvk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Eheien navan di mi xamim e hisit sexien xa eheien na Tata de inou. Muxulehi muhisti itel inou tengan eheien navan iti mi xamim vehakut. ");
INSERT INTO tvk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xosxa mulong xat rae navan xil, ti mupisen ni xa di mubisti del inou reitin e eheien navan iti mi xamim. Ngan ak nggoni ngan taxa inou di nalong xat rae xil na Tata navan tengan nipisen ni xa di nabisti dela e eheien nan de nou. ");
INSERT INTO tvk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nabit holesok xil ak mi xamim tengan vasak ni sien navan vati e meulien namim e tengan mei mupolu kuhi itela. ");
INSERT INTO tvk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Rae xa di nasa ni mi xamim xiak: iemim ihei xamim mun ixoni ngan taxa inou di ieok bei xamim. ");
INSERT INTO tvk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sexien xil xa di pisen ni xa eheien na moletin tei de tuneli xil mak: melele xa di maen xoteh meulien nan tengan vamat vahinat xil. Sexien ak be eilep mak mu mili sexien sav xil te eheien. ");
INSERT INTO tvk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E xamim mube tua navan xil xosxa mupol ni naha xa nasemae ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ninakes xamim ti mun ni moletin te polien navan xil, vengan xa moletin te polien xil latakil ti naha xa masta nae di pol ni. E di nakes xamim ni tua navan xil, vengan xa natehit mesen ni mi xamim ngamu holesok xil vus xa Tata navan tehiteni minou. ");
INSERT INTO tvk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tave xamim ti xa mutehosei inou tengan ti muhusil inou, e be inou vari iaxa natehosei xamim. E natesil xamim tengan ha mupol. Ma, ha muso huite ihe holu, huite xa ita vehakut. Ma, isak ni Tata isa ni mi xamim neta xa musisi ni e hisok. ");
INSERT INTO tvk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vatei mun, ha mupol ni naha xa di nasemae ni mi xamim xiak: iemim ihei xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iesu biteni mun mi moletin nan xil bit, “Xosxa moletin xil te ut etan iexil di nggat xamim, ma munem xati xa, tetiamu, iexil di teat inou. ");
INSERT INTO tvk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xosxa xamim mube moletin xil te ut etan, ngan xil te ut etan iexil ihei xamim vengan lipus xamim muxoni xil tang. E inou natehosei rat xamim ra xil tengan mei musav ni ngan xil te ut etan. Misak ni, xil iexil di nggat xamim. ");
INSERT INTO tvk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Munem xat naha xa natehiteni mi xamim xa slev tei nave eilep ti nali masta nan. Ve rin ak, xosxa moletin xil latesak purun ni nou, ma be reitin xa xil ti lisak purun ni xamim mun. E xosxa moletin xil latelong xat pispisien navan xil, ma be reitin xa xil ti lilong xat pispisien namim mun. ");
INSERT INTO tvk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","E xil lipol ni holesok xil ak mi xamim, vengan xa mube navan xil e di mupol e hisok e latakil ti ngan xa tesil inou namei. ");
INSERT INTO tvk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Vahit natnamei ti e natnaviteni ti neta mi xil, ma naha xa di lapol ni nave tesaen ti. E vengan xa natemei ngamu visal xil e latesin sepinien navan xil, lasakras mun lamuun xole lavit latnakil ti xa di lapol ni tesaen. ");
INSERT INTO tvk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Moletin xa ien nggat inou, xi di pisen ni xa di ien nggat Tata navan mun. ");
INSERT INTO tvk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vahit natnamei ti, e natnapol ni ti merekel xil xa moletin sav xil lasakras lapol ni, ma naha xa di lapol ni nave tesaen ti. E vengan xa natemei ngamu visal xil e natepol ni hisit merekel xil pe metexil xa mosav xil lasakras lapol ni, di lapisen ni xa sexien tesa xil ak de rin nae. E vengan xa latesin merekel xil ak, di lapisen ni xa iexil di nggat inou e Tata navan mun. ");
INSERT INTO tvk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngan ak di mistal mak tengan vasak ni sepinien xil xa latetisi tete rae nae xil xa mei be reitin xa bit, ‘Iexil iat votei ni nou tang.’ ");
INSERT INTO tvk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Melele xa nite visal Tata navan, nisil Ninin te tutouen imei ve xamim e ise xat xamim. Xi ipisen reitinen nan mi xamim e ihit lelen reitinen usil inou. ");
INSERT INTO tvk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","E xamim mun muhit rat reitinen usil inou mi moletin sav xil, vengan xa xamim iaxa muteti visal inou e melele xa natepol kokot mei duxoh xosali.” ");
INSERT INTO tvk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iesu misepin mun mi moletin nan xil bit, “Nabit holesok xil ak mi xamim tengan munasavut ti e neketen namim melele xa muhisu ni sakpurunien xil. ");
INSERT INTO tvk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Rut Siu xil xa lasa liso rat xamim ra nim te pispisiennae xil. E melengien tei di bemei xa moletin xil linemi lihit Hi ihesi xi melele xa laba tengan lavas vin xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Xil ti lipol ni imak vengan xa latakil ti xa nabe visi, e latakil ti Tata navan mun. ");
INSERT INTO tvk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","E nabit holesok xil ak mi xamim tengan, melele xa mei istal, munem xati xa natehit lelen ni mi xamim ngamu.” Iesu biteni mun mi moletin nan xil bit, “Natnavit holesok xil ak ti mi xamim tetiamu vengan xa nateta tamu visal xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","E xosali, nihe visal ngan xa tesil nou namei. E xamim mutasis nou ti mun xa nihe ut xave. ");
INSERT INTO tvk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mutasis nou ti vengan xa tinemim polu ni nenexoen ve naha xa di nabiteni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E neta sav xa mak, nabiteni reitin mi xamim xa ihos mak mu xa nihe reling xamim niha. Vengan xosxa ninava ti, ma Ninin te tutouen namei ti visal xamim. E xosxa niha, ma nisila imei visal xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E melele xa Ninin imei, ipisen ni mi moletin xil xa nenemien nae tamal ti usil tesaen nae, momalen navan, e sexien te lepisien na Hi. ");
INSERT INTO tvk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ninin Eo mei ipisen ni xa be tesaen xa lataneket e nou ti. ");
INSERT INTO tvk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipisen ni momalen navan mi xil vengan xa ha nite visal Hi Tata e xamim munapus ti mun inou. ");
INSERT INTO tvk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","E ipisen ni xa be reitin xa Hi ilepis rin na moletin xil vengan xa telepis rin na Temat ngamu, ngan xa tehe vat na moletin xil holu te ut etan. ");
INSERT INTO tvk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ieok bei tengan namit kil holesok sav xil holu mi xamim, e xosali, imeas tova tang tengan muvur xil. ");
INSERT INTO tvk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","E melele xa Ninin Eo xa di pisen reitinen mi moletin xil imei, xi ipispisi mi xamim ni reitinen na Hi tengan mukila. Xi nasepin ti vaxo nenemien nan tasen tang, e ihit mesen ni mi xamim holesok xil vus xa miteong ni nggo ut nesao. Reitin, xi ihit lelen ni mi xamim holesok xil xa ti imei. ");
INSERT INTO tvk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xi ipet rat hisok ihe nesao vengan xa ihur neta xa nabiteni e mei ihit mesen ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Holesok xil vus na Tata navan be navan mun. Misak ni, inou nakila namiteni xa Ninin Eo ihur neta xa nabiteni e mei ihit mesen ni mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Iesu biteni mi moletin nan xil bit, “Navehi ti, munapus ti mun inou. Ti, nave nousav ti xa itutou, e mupus rilomun ni nou.” ");
INSERT INTO tvk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Di, rut moletin nan xil lasis xil mun tang labit, “?Naha vari iaxa be koute te sepinien nan melele xa bit, ‘Navehi ti munapus ti mun inou. Ti, nave nousav ti xa itutou, e mupus rilomun ni nou’? ?E naha vari be koute te, ‘Nihe visal Tata’? ");
INSERT INTO tvk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","?E, ‘Navehi ti’ be naha? !Xir ratakil ti vari naha xa xi di bit usili!” ");
INSERT INTO tvk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu mikila xa moletin nan xil iexil bei tengan lasisi ni holesok xil ak. Ma, biteni mi xil bit, “Nakila xa xamim di mubit usil sepinien navan melele xa nabit, ‘Navehi ti munapus ti mun inou. Ti, nave nousav ti, e mupus rilomun ni nou.’ ");
INSERT INTO tvk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Reitin li nabiteni mi xamim xa melele xa niha, xamim mumuis e mutang ve nou, e moletin sav xil te ut etan lihesi xil ihe holu. Ihe reitin xa xamim mulonge isa, e, itutou sung, longpangasien namim ihiles mei ihe sien. ");
INSERT INTO tvk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Melele xa atou tei sangas valing tuvava e mei duxoh melele te longpangasien nan, xi di milonge misa ven. E, dutou sung, melele xa miling tuvava nan ngamu e ut etan, ien bovong ni longpangasien teni vengan xa sien xa da en be holu mak mu mili. ");
INSERT INTO tvk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ngan ak nggoni xamim. Xosali mulonge misa. E melele xa nitilomun mei nipus xamim, ma sien xa ite xamim mei ihe himetu. E moletin ti misakras vahur rat sien ak ra xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Melele xa ripus rilomun ni xir, xamim munasis ti mun inou ve neta tova. Reitin li nabiteni mi xamim, xosxa musis Tata navan ni neta tova e hisok, ma xi isa ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tetiamu mei duxol xosali, mutnasis ti mu neta tova e hisok. Ma melele xa musis ve neta ngan, muhuri. E melele xa muhuri, mupolu kuhi ni sien. ");
INSERT INTO tvk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Melele xa di nasepin mi xamim usil holesok xil xa mei ti istal, di nasep xuxus ni nggo vole xil. E melele tei di bemei xa ninasepin ti mun naxo vole xil. E melele nen ak, nisep kil usil Tata navan ixo sepinien xil xa imese tevi. ");
INSERT INTO tvk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","E melele nen ak, xamim musis Tata navan e hisok, e xi isa ni. Nave inou ti mun xa nisis mini e rin namim, ");
INSERT INTO tvk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","vengan xa eheien na Hi Tata di ngamu e xamim. Xi ien bei xamim vengan xa eheien namim de inou e muke reitin xa inou natexo visali. ");
INSERT INTO tvk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","E be reitin mak xa inou natexo visal Tata e namei e ut etan. E xosali, nihe reling ut etan e nitilomun nihe visal Tata navan.” ");
INSERT INTO tvk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E moletin nan xil labiteni mini labit, “Reitin mak, xosali di obit lelen holesok xil vus mei memese. Otasepin ti mun vaxo vole xil. ");
INSERT INTO tvk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xosali, xamem makila xa okil holesok xil vus. E xamem munasisuk ti mun ni neta, vengan xouk okila ngamu naha xa de nenemien namem. Nggo sexien ak make reitin xa xouk otexo visal Hi vari tang.” ");
INSERT INTO tvk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu bit rilomun ni mi xil bit, “?Be reitin xa muke reitin e nou sung? ");
INSERT INTO tvk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Muteong pisi mu. Melele tei di bemei xa xamim te vusien muletasil, e xamim kekes iloh itilomun ihe tim san. Reitin xa muhe reling inou nitat tasok. E neta sav xa imak, ninata tasok ti, vengan xa Tata dat visal nou vehakut. ");
INSERT INTO tvk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nabit holesok xil ak mi xamim tengan muhisti kuhi itel inou, e, isak ni, tomat ite e tinemim. Melele xa mudi e ut etan ak, ti muhur sakpurunien xil. !E muxeih! Vengan xa inou nabas tan ni xeihen na Temat ngamu, ngan xa be vat na moletin xil holu te ut etan.” ");
INSERT INTO tvk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Melele xa Iesu bit usil holesok xil ak bus, miketeh be nesao e misis bit, “O Tata, melele te longpangasien bemei ngamu. Nasis minuk tengan upet rat hisok, xa nabe Natumali, tengan inou nikila nipet rat hisom. ");
INSERT INTO tvk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Oteling meulien na moletin xil vus tete heok tengan nikila nisa meulien sal iha mi ngan xil vus xa otesa xil minou. ");
INSERT INTO tvk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","E meulien sal be tengan moletin xil likila likil kuh xouk, xa xouk kestang obe Hi reitin, e tengan likila likil kuh inou mun, Iesu Kristo xa otesa ni bemei. ");
INSERT INTO tvk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inou natepet rat hisom pe met moletin xil te ut etan vengan xa natepol vuol ni polien xil xa otesa ni minou tengan nipol ni. ");
INSERT INTO tvk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mak, ma Tata, nasisuk tengan upet rat hisok e usak ni nou mei nihur his xa ihe eilep itelak ixoni ngan xa natehuri ngamu tetelak e melele xa nateti tamu visaluk e melele xa otnapeas ni ut etan ti mu. ");
INSERT INTO tvk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Inou natepisen xouk mi ngan xil xa otesa xil minou, ngan xil xa xouk otehosei xil ra moletin xil te ut etan. Xil labe nam, e otesa xil minou. E xil latelong xat sepinien nam. ");
INSERT INTO tvk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","E xosali, xil lakila xa holesok xil vus xa xouk otesa ni minou, texo visaluk. ");
INSERT INTO tvk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sepinien xil xa otesa ni minou, inou natesa ni sung mi xil, e xil latehuri. E lakila xa be reitin xa inou natexo visaluk, e lake reitin xa xouk otesa nou namei. ");
INSERT INTO tvk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Natasis ti ve moletin xil vus te ut etan. E di nasis tengan ututou ni ngan xil xa otesa xil minou vengan xa labe nam. ");
INSERT INTO tvk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngan xil vus xa di langgusil xat inou labe moletin nam xil, e moletin nam xil vus labe navan mun. E meulien nae di pisen ni xa hisok be eilep mak mu. ");
INSERT INTO tvk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Di nabat visaluk, e ninara ti mun e ut etan. E xil liti tamu inggak. O Tata, obe eo xa obe eo pupu. Usikoe xol meulien na moletin navan xil itel xeihen te hisom, his xa otesa ni minou. Imak, ma xil mei livituei lihe tei takes ixoni ngan xa xouk del inou rube tei takes. ");
INSERT INTO tvk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Melele xa nateta tamu visal xil, natesikoe xol xil tetel xeihen te hisom, his xa otesa ni minou. Reitin, nateketeh xol xil e ti e xil tenakesae. Tei takes e xil iaxa tehe reling inou e teha tekesae, ngan xa otehosei tengan vakesae xa tesak ni naha xa Vanuvei Eo tehit lelen ni usili mei tehe reitin. ");
INSERT INTO tvk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nave nousav ti, nitilomun nihat visal xouk. E xosali, melele xa nada tamu e ut etan ak, nabit lelen holesok xil ak minuk tengan vasak ni sien xa de nou, mei ipolu e tine moletin navan xil mun. ");
INSERT INTO tvk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Natesa sepinien nam mi xil, e misak ni, ngan xil xa labe te ut etan tang, iexil di nggat xil ven. Iexil di nggat xil vengan xa lapus kila xa ngenen xil latave te ut etan ti, nggoni ngan xa inou mun natave te ut etan ti. ");
INSERT INTO tvk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tata, natasisuk ti tengan oleh rat xil ra ut etan, e nasisuk li tengan usikoe xol xil ra Temat, ngan xa be vat tesaen. ");
INSERT INTO tvk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Moletin navan xil latave te ut etan ti, nggoni ngan xa inou mun natave te ut etan ti. ");
INSERT INTO tvk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uling rat xil tengan mei lihe moletin eo nam xil ixo reitinen nam. E likamet reitinen nam ixo sepinien nam xil xa be vatit reitinen. ");
INSERT INTO tvk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Di nasil xil tengan ha lapol e ut etan ixoni ngan taxa xouk otesil nou namei e ut etan ak. ");
INSERT INTO tvk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","E tengan nitutou ni rin nae, inou mun di naling rat meulien navan mei nabe moletin eo nam. Ve rin ak, xil mun lakila liling rat meulien nae mei lihe moletin eo nam xil ixo sepinien te reitinen nam.” ");
INSERT INTO tvk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Iesu misis mun bit, “Tata, natasisuk ti ve moletin xil ak kestang, e di nasis ve ngan xil mun xa like reitin e nou ixo sepinien xil xa moletin navan xil ti lisa ni mi xil. ");
INSERT INTO tvk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, nasisuk tengan xil vus mei lihe tei takes. Reitin, xil lihisti vituei itel ralu ixoni ngan taxa xouk obisti del inou, e inou nabisti del xouk. Vengan xa, melele xa mei labe tei takes, moletin xil te ut etan like reitin xa xouk vari iaxa otesil nou namei. ");
INSERT INTO tvk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","His xa eilep xa otesa ni minou, inou di nasa ni mi xil. Mak, ma xil lihe tei takes ixoni ngan xa ralu rabe tei takes. ");
INSERT INTO tvk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inou nihisti vituei itel xil ixoni ngan taxa ralu di rabisti vituei. Imak, ma xil mei livituei lihe tei takes, e moletin xil te ut etan lipus kila xa xouk vari iaxa otesil nou namei e eheien nam di e xil nggoni ngan taxa de nou. ");
INSERT INTO tvk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, ieok bei tengan ngan xil xa otesa xil minou mei liti visal nou e ut nesao, e lipus minehinen te xeihen navan. Reitin, ieok bei tengan xil lipus minehinen te xeihen navan xa usa ni minou vengan xa eheien nam tete nou e melele xa otnapeas ni ut etan ti mu. ");
INSERT INTO tvk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tata, xouk omal tevi. E tave ti neta xa moletin xil te ut etan latakil ti xouk, inou nakilak. E ngan xil xa otesa xil minou, xil lakila xa xouk otesa nou namei. ");
INSERT INTO tvk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inou natepisen ratuk mi xil, e nitit ni ngan xa di napol ni. Imak, ma eheien nam xa de inou, iti e xil. E inou mun niti e xil.” ");
INSERT INTO tvk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Melele xa Iesu misis bus, xi mea del moletin nan xil e laba labe ri Poal Kidron. E rute ak, urvatiei tei te olip di en, ma laba en. ");
INSERT INTO tvk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sudas mikil rute xa laba en vengan xa melele xil holu Iesu di teleh viton moletin nan xil en. Ma, melele xa Sudas ba tengan vapol ni suse xa isa rat Iesu ha ihe he elu nan xil ixo en, ");
INSERT INTO tvk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","xi del tatit moletin te vaeen tei te hal Rom, del xat mereketeh xil te Nim Eo xa vat xil na pris xil e Farasi xil latesil xil laba. Xil lamei del laet nae xil, e di langgur xat tiei e homenda te vaeen nae xil. ");
INSERT INTO tvk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu mikil vuol ni holesok xil vus xa mei istal mini, ma ba bisu mi xil e misis xil bit, “?Xamim di mulang ves visi?” ");
INSERT INTO tvk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Xil labit rilomun ni labit, “Iesu te hal Nasaret.” Xi bit, “Inou nabe xi.” Sudas xa di misa rati be he xil di mos del xat xil. ");
INSERT INTO tvk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Melele xa Iesu bit, “Inou nabe xi,” xil lali tou e lamot labe tan. ");
INSERT INTO tvk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu misis xil mun bit, “?Xamim di mulang ves visi?” E labiteni vatei mun labit, “Iesu te hal Nasaret.” ");
INSERT INTO tvk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","E xi bit, “Inou nabiteni mi xamim ngamu, inou nabe xi. E xosxa di mulang ves nou, ma mumaen ngan xil ak liha.” ");
INSERT INTO tvk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Xi bit sepinien ak tengan isak ni naha xa xi tehiteni mei ihe reitin melele xa tehit, “Tata, ti e ngan xil xa otesa xil minou tenakesae.” ");
INSERT INTO tvk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Di, Saemon Pita, ngan xa nggur xat tiei tei xa eilep, xi milihi rati tengan vahas moletin tova ni. E melele xa mikuvun tiei ak, da xoteh vurang metu na slev na vatixar na pris xil. His slev ak be Malkas. ");
INSERT INTO tvk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","E Iesu misepin nggeih mi Pita bit, “!Uling rilomun ni tiei nam ite voninen! Tata navan vari iaxa tesak mesen longpangasien ak tengan nihur vuol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Di, moletin te vaeen xil te hal Rom lamei del vat nae, e mereketeh xil te Nim Eo lamei ladal xat Iesu e labar xati. ");
INSERT INTO tvk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Diamu, ladela be visal Anas, avu sasa na Kaeafas, ngan xa be vatixar na pris xil te huram nen ak. ");
INSERT INTO tvk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","E tehe Kaeafas vari iaxa tesel xat ngan xil te Kaonsel na Siu xil tehit, “Ihos mak mu xosxa moletin tei takes imat ve rin na moletin xil, ili xosxa rimaen mol‑Rom xil mei lipurun sen mol‑Isrel xil vus te kantri nar.” ");
INSERT INTO tvk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita e moletin teimun na Iesu luka xus e lunggusil Iesu. E vengan vatixar na pris xil mikil moletin teimun ak, maen ni tengan vahusil Iesu vahe vioh te nim xa eilep man. ");
INSERT INTO tvk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","E Pita dit misoh e hale, sangas ni puiteh te vioh ak. Ma, moletin teimun na Iesu, ngan xa vatixar mikila, xi be hale e misepin mi atou xa di miketeh xol puiteh. Misak ni, atou ak maen Pita mun tengan vahe vioh. ");
INSERT INTO tvk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Di, atou xa di miketeh xol puiteh pus Pita e biteni mini bit, “?Midep? ?Xouk mun obe tei e moletin xil na moletin ak?” E Pita muun xole bit, “E‑e, tave nou ti.” ");
INSERT INTO tvk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Di, Pita ba mos del mereketeh xil e moletin xil te polien na vatixar na pris xil xa latesupang ni sakol e di laso xorelisi ladale vengan xa di lalong masoh mikat. ");
INSERT INTO tvk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","E vangit nim ma vatixar Anas, xi di misis pilei Iesu usil moletin nan xil e pispisien nan xil. ");
INSERT INTO tvk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","E Iesu bit rilomun ni bit, “Holesok xil xa natesep usili, natehit rati mi moletin xil vus. Melele xa di natepispisi, natepol ni e nim te pispisiennar tetel vioh te Nim Eo. Ma natepol ni e rute xil xa Siu xil holu di lamei vituei en. E natnavit xuxus ni ti neta tova. ");
INSERT INTO tvk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","?Misak ni, di osis nou usili veneh vari? Usis ngan xil xa lateteong ni naha xa natehiteni mi xil, vengan xa xil lakil naha xa natehiteni.” ");
INSERT INTO tvk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Melele xa Iesu misepin mak, mereketeh tei na vatixar na pris xil mileves valnao Iesu e bul xati bit, “?!Veneh vari di osepin mak ba mi vatixar na pris xil!?” ");
INSERT INTO tvk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu bit rilomun ni mini bit, “Xosxa natehit neta tova xa misa, ma uhit rati. ?E xosxa naha xa natehiteni momal, ma oleves nou veneh vari?” ");
INSERT INTO tvk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bus di, Anas misa Iesu xa ao te xeih da tamu e hen xalu tengan vahe visal vatixar na pris xil xa be Kaeafas. ");
INSERT INTO tvk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Melele xa Pita misoh da tamu sangas visal upang e di midale, tei e moletin xil ak misisi bit, “?Midep? ?Xouk mun obe tei e moletin xil na moletin xai?” E Pita muun xole bit, “E‑e, tave inou ti.” ");
INSERT INTO tvk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Di, slev tei na vatixar na pris xil misisi bit, “?E tave xouk ti iaxa natepus xouk oteta tetel Iesu e urvatiei te olip?” Slev ak be vatimol na slev na vatixar xa Pita teta xoteh vurangen. ");
INSERT INTO tvk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","E be vatol nen, Pita muun xole bit, “E‑e, tenave nou ti.” E melele nen tak vari, tuto mikorat. ");
INSERT INTO tvk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","E makoe roroh, vat na Siu xil ladel Iesu be reling tim sa vatixar Kaeafas, e ladela be tim sa Paelet, vat te kavmen te rute ak, e latave vangit nim man ti. Vat xil na Siu xil latave vangit nim man ti vengan xa xi tave ngan Siu ti e lanemi labit isak ni xil mei lihe muis pe met Hi, ma lasakras lava Anien te Tavien sung. ");
INSERT INTO tvk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma, Paelet be hale tengan vapus xil. Melele xa pus xil, misis xil bit, “?Naha vari iaxa be tesaen xa mubiteni ba xat rin na moletin ak?” ");
INSERT INTO tvk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma xil labit rilomun ni mini labit, “Moletin ak be moletin tesa tei. Vahit nave reitin ti, munasa ni ti minuk tengan osa pangasien mini.” ");
INSERT INTO tvk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma Paelet biteni mi xil bit, “Xosxa imak, ma xamim muhuri e mulepis rin nan ihusil rae namim xil. Ivus ti, musa pangasien mini ihusili.” E xil labit rilomun ni labit, “Rae xil te kantri ak di misikoe xol xamem bit xamem Siu xil masakras makin maten mi moletin tova e kot namem.” ");
INSERT INTO tvk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ngan ak testal tengan vasak ni sepinien na Iesu vamei vahe reitin melele xa tehit lelen sexien eah xa imat ixo en. ");
INSERT INTO tvk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ma, Paelet dilomun be nim man e misis moletin te vaeen nan xil tengan litel Iesu vamei pe meten. Melele xa pusi, Paelet misisi bit, “?Midep? ?Xouk iaxa obe suv toto na Siu xil reitin?” ");
INSERT INTO tvk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu bit rilomun ni mini bit, “?Di osis nou mak ve rin nam tasom, mu vengan xa moletin sav xil latehit usil inou minuk?” ");
INSERT INTO tvk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paelet bit rilomun ni bit, “Rin navan tovuol e xouk vengan xa natave Siu ti. Be moletin nam xil xati del vat na pris xil iaxa lasa ratuk omei e heok. ?Veneh? ?Otepol ni naha tova xa misa?” ");
INSERT INTO tvk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu biteni bit, “Tave ngan xil ti te ut etan xa di labosei nou tengan nihur xeihen te lelaxatien. Vengan, vahit vamak, moletin navan xil ti livae e rin navan tengan ninave he vat xil na Siu xil ti. E ngan xa di misa xeihen te lelaxatien minou tave ti te ut etan ak.” ");
INSERT INTO tvk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma, Paelet misisi bit, “?Ma, xouk obe suv toto reitin?” Iesu bit rilomun ni bit, “Xouk iaxa obiteni reitin xa nabe suv toto tei. E natepot e natemei e ut etan ak tengan nipol ni polien tei takes. Natemei tengan nihithiten reitinen na Hi iha mi moletin xil. E ngan xil vus xa iexil bei reitinen, xil di lalong xat sepinien navan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","E Paelet misisi bit, “?Visi vari mikila vakil ti reitinen?” Melele xa Paelet misepin del Iesu bus, be hale e misepin mun del Siu xil bit, “Inou natapus ti neta tova vasa e rin nan xa momal tengan nasa pangasien mini ven. ");
INSERT INTO tvk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E nggusil sexien metu naralu, e melengien te Anien te Tavien ak, di namaen moletin tei xa xamim mubosei tengan iha ven imase ra nim te xeih. ?Misak ni, xamim iemim bei tengan nimaen suv toto na Siu xil ha vameluv?” ");
INSERT INTO tvk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","E tatit moletin xil lakei nggeih labit, “!E‑e, iemem ti tavei moletin xai! Iemem bei Barabas tengan istal imeluv iha.” Barabas tehe vatxeih tei xa tevae tetel kavmen te hal Rom. ");
INSERT INTO tvk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Melele xa moletin xil lasin ni tengan lamaen Iesu ha ven vamase, Paelet misemae ni tengan limeasi ni ao xa mikan. ");
INSERT INTO tvk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma, moletin te vaeen nan xil langgur Iesu e laba. Langgil xat vatluvoluv tei ni ao tei xa sanute xil tepiei di en e lasili xol vatin. Lasing xole ni kaliko tei xa pili nggoni ngan xa be suv toto tei. ");
INSERT INTO tvk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Di, lapol pepamen ni labit, “!O suv toto na Siu xil, xamem mamerere ni xouk!” E melele xa labiteni mak, langgulehi lamei visali e lalevesi de valnaon. ");
INSERT INTO tvk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Di, Paelet dilomun visal vanut moletin xil vatei mun e biteni mi xil bit, “?Mupusi? Di nanggur moletin ak bemei visal xamim tengan mupus kila xa, e ketehen navan, natakamet ti neta xa vasa vaha xat rin nan.” ");
INSERT INTO tvk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ma ladel Iesu be pe metexil, vatluvoluv xa sanute di en de vatin e mising ni kaliko tei xa pili nggoni be suv toto tei. Di, Paelet biteni mi xil bit, “Mupusi. !Xi xiak!” ");
INSERT INTO tvk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Melele xa vat xil na pris xil del mereketeh xil te Nim Eo lapusi, lakei nggeih labit, “!Ti xati e eivave! !Ti xati e eivave!” Ma, Paelet biteni mi xil bit, “!Xamim vari muhuri e muti xati e eivave! Vengan xa, e ketehen navan, natakamet ti neta tova xa vasa vaha xat rin nan.” ");
INSERT INTO tvk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","E vat na Siu xil labit rilomun ni labit, “Usil rae nar, momal tengan ha imat, vengan di mikes tasen ni xi ni Nat Hi.” ");
INSERT INTO tvk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Melele xa Paelet milonge, ulin mikan holu mak mu. ");
INSERT INTO tvk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xi dilomun be nim e misis Iesu bit, “?Xouk onggo xave vari?” E Iesu tavit ti neta. ");
INSERT INTO tvk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","E Paelet biteni mun bit, “?Midep? ?Onasepin ti minou? ?Otakil ti xa inou nanggur xeihen tengan nimaen xouk ha vem imase, mu nimaen ni liti xatuk e eivave?” ");
INSERT INTO tvk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu bit rilomun ni bit, “Xosxa Hi te ut nesao namaen ni ti, ma xeihen nam ihe tovuol e meulien navan. Ma, ngan xa tesa rat inou mei nade hem, naha xa xi tepol ni misa mak mu mili ngan xa xouk iaxa di opol ni.” ");
INSERT INTO tvk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Melele xa Paelet milonge mak, xi di misak tengan vakamet suse tova tengan vamaen Iesu ha ven vamese vaxo en, e Siu xil lakei rilomun ba mi Paelet labit, “!Xosxa umaen moletin xai ha ven imase, di opisen ni xa xouk otave reitin ti mi Sisa, suv toto nam te hal Rom! !Vengan moletin xa di pet rat tasen ni xi bit be suv toto tei be elu del Sisa!” ");
INSERT INTO tvk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Melele xa Paelet milong sepinien nae, mikei tengan latel Iesu vamei visali, e xi dotan de von koten nan tengan vasa nenemien kor nan usil rin na Iesu. Rute ak lakesi ni ‘Kabata’ e sepinien Hibru xa koute teni be ‘Von Ngengelen te Hat.’ ");
INSERT INTO tvk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Melele xa pol ni mak, sangas be piniae e melengien xa di lasak xat holesok xil ve Sabat te wik te Anien te Tavien en. E Paelet biteni mi Siu xil bit, “!Suv toto namim xiak!” ");
INSERT INTO tvk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","E moletin xil lakei nggeih labit, “!Has vini! !Has vini vari! !Ti xati e eivave!” Paelet misis rilomun ni xil bit, “?Reitin? ?Iemim bei tengan niti xat suv toto namim ite eivave?” E vat xil na pris xil labit rilomun ni labit, “!Sisa te hal Rom, xi kestang be suv toto namem!” ");
INSERT INTO tvk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma, Paelet misa rat Iesu be he moletin te vaeen nan xil tengan litela iha e liti xati e eivave. Ma, moletin te vaeen ladel Iesu, ");
INSERT INTO tvk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","e langgeih xati tengan vapo tasen ni eivave nan. Xil laba labe ‘Von Valvat Moletin’ xa lakesi ni ‘Kolkota’ e sepinien Hibru. ");
INSERT INTO tvk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","E rute ak vari, ladi xat Iesu en. Ladi xati de hilaep na moletin lu mun xa lateti xat xalu lutete eivave nalu e rin xalu. ");
INSERT INTO tvk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Di, laling tisen tei de nesao e eivave na Iesu xa Paelet tetis en tehit, “Iesu te hal Nasaret, suv toto na Siu xil.” ");
INSERT INTO tvk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tetis sepinien ak texo sepinien tol: Hibru, Latin, e Krik. Moletin holu latele usil sepinien ak, vengan xa rute xa lateti xat Iesu en tenave sotin ti ra taon. ");
INSERT INTO tvk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Melele xa vat xil na pris xil lale usili, ladilomun ba lapus Paelet e labiteni mini labit, “Onatisi ti onahit, ‘Suv toto na Siu xil,’ e momal tengan utisi uhit, ‘Moletin ak tehiteni tehit xi be suv toto na Siu xil.’” ");
INSERT INTO tvk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","E Paelet bit rilomun ni mi xil bit, “Naha xa natetisi tuei itat imak.” ");
INSERT INTO tvk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Melele xa moletin te vaeen xil ladi xat Iesu bus, laleh eising nan xil xa latesil rati ra ni, e laseti be tatite hat, pipin ni moletin hat te vaeen xil ak. E eising nan xa teviei xa bos da nga, ngan xa latepol ni ni ul xa latehei sal ni tang. ");
INSERT INTO tvk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma, moletin te vaeen xil ak labiteni mi xil mun tang labit, “Rinatal papasi ti. Riso daes e rikameti xa visi e xir ihuri.” Ngan ak testal tengan vasak ni naha xa Vanuvei Eo tehiteni mei vahe reitin xa tehit, “Lateseti eising navan xil mi xil mun tang, e lateso daes ve eising tepiei navan.” E ngan ak vari be naha xa moletin te vaeen xil latepol ni. ");
INSERT INTO tvk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tave sotin ti ra eivave xa Iesu da en, atou hat (4) lasoh ladi: ninen xal tunehin, e Meri (atou na Klopas) del Meri te hal Makdela. ");
INSERT INTO tvk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Melele xa Iesu pus ninen e pusi xa moletin nan xa eheien nan di en di misoh visali, Iesu biteni mi ninen bit, “Nana, moletin ak ihe natumali.” ");
INSERT INTO tvk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Di, biteni mi moletin ak bit, “Atou ak ihe ninom.” Ma, e melengien ak ba, moletin ak nggur nine Iesu tengan ha ite visali e tim san. ");
INSERT INTO tvk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","E melele nen ak, Iesu mikila xa holesok xil xa temei e ut etan tengan vapol ni duxoh hoxalite teni. Ma, tengan vasak ni naha xa de Vanuvei Eo mei vastal vahe reitin, xi biteni bit, “Meruru nggat nou.” ");
INSERT INTO tvk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Valite tei da xa polu ni uaen xa mikon. Ma, tei e moletin xil xa ladi e rute ak nggur mavulut eising tei, mikasi ni uaen ak, milingi de kusut liei tei, e misa ni be nesao tengan Iesu vavisi. ");
INSERT INTO tvk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Melele xa mu rut uaen ak, Iesu biteni bit, “!Natepol sen holesok xil vus!” Di, mitamet be tan, e mat. ");
INSERT INTO tvk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Melele xa Iesu mat, be melengien xa di lasak xat holesok xil ve Sabat, e Sabat ak be eo mak mu vengan ti lipol ni e wik te Anien te Tavien. Ma, Siu xil lasis Paelet tengan ha vasemae ni moletin te vaeen nan xil tengan lava lamuvul le xatel xa di lamurur ladi e eivave natel tengan latolel vamanon. Imak, ma likila lileh rat tiei natel ak imei e tan ra eivave tengan xatel latnapurun Sabat ak ti vengan Sabat ak be eo pupu te wik te Anien te Tavien. ");
INSERT INTO tvk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma, moletin te vaeen xil laba, langguvul le moletin xa diamu. Di, langguvul ngan tesav mun xa lateti xati tete sangas visal Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","E melele xa lamei visal Iesu, lapusi xa xi mat ngamu. Ma, lataxuvul len xalu ti. ");
INSERT INTO tvk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","E moletin te vaeen tei misal valxou Iesu ni soso nan. E vatakes, ra del siben mileh nggo en. ");
INSERT INTO tvk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Moletin taxa pus holesok xil ak mistal di bit rati tengan mukila muke reitin en, e sepinien nan be reitin.) ");
INSERT INTO tvk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ngan ak testal tengan vasak ni naha xa Vanuvei Eo tehit lelen ni mei vahe reitin xa tehit, “Sin tovuol namavul.” ");
INSERT INTO tvk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E sepinien teimun e Vanuvei Eo xa tehiteni tehit, “Moletin xil lipus ngan xa latesal vini.” ");
INSERT INTO tvk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Dutou ni, moletin tei te hal Aramatea bemei, hisen Siosep. Xi mun tehe tei e xil xa tehusil xat Iesu, e tepol xuxus ni tang vengan xa ulin tekan ni vat xil na Siu xil. Xi ba pus Paelet e misisi tengan vamaen ni vapo tiei na Iesu. Paelet maen ni, ma Siosep ba po rat tiei nan. ");
INSERT INTO tvk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas mun bemei del vokon xil holu xa mir e alo xil di en xa kilo nen mili hanutap tei e he xalu mun (30). Tehe Nikodimas ak iaxa temei tesao ni Iesu tetiamu e vongien tei. ");
INSERT INTO tvk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xalu lupo rat tiei na Iesu, lubas vokon xil en nggusil sexien te tehinen na Siu xil, e lupis xole ni kaliko tei xa mieh e memese. ");
INSERT INTO tvk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sangas visal rute xa lateti xat Iesu en, urvatiei tei da xa vangihat tei te tehinen da en, ngan xa latetei ngamu e be neta hu tang, lataling ti mu tiei na moletin tova xa mat vata en. ");
INSERT INTO tvk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma, vengan xa be melengien xa di lasak xat holesok xil ve Sabat, e sangas ut vamaluxoluk xa Siu xil lasakras mun lapol en, xalu ba luling tiei na Iesu de rute ak vengan xa dat sangas. ");
INSERT INTO tvk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","E makoe roroh e Sande, ut talan ti mu, Meri te hal Makdela ba misao ni vangihat te tehinen na Iesu. E melele xa ba duxoli, mikameti xa hat xa eilep xa tetakoe xol puiteh teni, ladivin rati ngamu be relingi. ");
INSERT INTO tvk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma, miloh be visal Saemon Pita del ngan xa eheien na Iesu da en, e biteni mi xalu bit, “!Latepo rat Suv ra vangihat te tehinen! !E xamem matakil ti rute xave xa latelingi teti en!” ");
INSERT INTO tvk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Melele xa lulonge mak, Pita del moletin sav na Iesu lube vangihat. ");
INSERT INTO tvk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xalu vus luloh, e ngan tesav miloh ba mili Pita e duxoh vangihat diamu ni. ");
INSERT INTO tvk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xi tava ti vangite, e mitei hiraen be vangite e pus kaliko te mieh xa latepis xol Iesu ni da. ");
INSERT INTO tvk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","E melele xa Saemon Pita xa di tetutou ni bemei, vatei takes, xi mika sal be vangit vangihat. Xi mun pus kaliko te mieh xa latepis xol Iesu ni da. ");
INSERT INTO tvk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","E xi pusi mun xa kaliko te mieh sav xa latepis xol vat Iesu ni tara ti vatel kaliko sav xil. Latepis xol kuhi da nga tasen e rin sav. ");
INSERT INTO tvk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Di, ngan tesav xa tetuxoh vangihat tetiamu, xi mun be vangite. E melele xa pus holesok xil ak, xi mike reitin e Iesu. ");
INSERT INTO tvk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vengan, duxoh melele nen ak, lutnakil kuh ti mu xa Vanuvei Eo tehit lelen ni xa xi imea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Di, rumali ludilomun lube tim. ");
INSERT INTO tvk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Melele xa moletin na Iesu xalu luba, Meri dit misoh e hale te vangihat e di muis. E melele xa di muis mak, mitei hiraen tengan vaketeh vahe vangit vangihat. ");
INSERT INTO tvk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","E mitemanin melele xa pus masxaxa lu xa lusing ni eising te mieh. Ludotan ludi rute xa, tetiamu, tiei na Iesu teta en. Tei de von vatin e tei de von kaelen xalu. ");
INSERT INTO tvk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Xalu lusisi lubit, “?Atou, veneh ma di omuis?” Meri bit rilomun ni bit, “Latepo rat Suv navan ra rute ak e natakil ti xa latelingi da xave.” ");
INSERT INTO tvk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Melele xa bit ngan ak bus, biles e pus Iesu misoh sangas visali. E Meri takil ti xa ngan ak be Iesu vari. ");
INSERT INTO tvk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E Iesu misisi bit, “?Atou, veneh ma di omuis? ?Di olang ves visi?” Meri minemi bit xi be ngan xa di milaxat urvatiei ak. Ma, biteni mini bit, “O suv, xosxa xouk iaxa otepo rati be rute sav, uhit rati li rute xave xa otelingi teta en tengan niha nipoe.” ");
INSERT INTO tvk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","E Iesu mikesi bit, “Meri.” Melele xa milong raen, Meri biles pus kila e biteni mini bit, “!Raboni!” Koute te sepinien ak be ‘Titsa’ e sepinien Hibru. ");
INSERT INTO tvk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu biteni mini bit, “Onasak ni ti tengan otal xat nou vamak vengan xa natava ti mu visal Tata navan. E xouk uha upus tua navan xil e uhit mesen ni mi xil xa, nave nousav ti, ha nite visal Tata navan xa be Tata nae, ngan xa be Hi navan e be Hi nae mun.” ");
INSERT INTO tvk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ma, Meri te hal Makdela dilomun e ba biteni mi moletin na Iesu xil bit, “!Inou napus Suv!” E bit mesen naha xa xi tehiteni mini. ");
INSERT INTO tvk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","E Sande vongien, moletin xil na Iesu ladi vituei e nim tei e lalok xol puiteh xil teni vengan ulixil mikan xa vat xil na Siu xil linamei linatal xat xil. Di, latemanin xa Iesu vari mei mistal mi xil e misoh de hilaep te xil. E biteni mi xil bit, “Tomat iti mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Melele xa biteni mak, pisen hen xalu e valxoun mi xil. Misak ni, moletin nan xil lapus kila xa Suv nae meul reitin, e labesi xil pupu ven. ");
INSERT INTO tvk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Di, Iesu biteni mun mi xil bit, “Tomat iti mi xamim. Nggoni ngan xa Tata navan tesil inou, inou di nasil xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","E melele xa biteni mak, buhi xil e biteni bit, “Ninin Eo mei ise xat xamim. ");
INSERT INTO tvk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xosxa muketeh ihos iha mi moletin sav xil xa latepol tesa, ma Hi mun iketeh ihos iha mi xil. E xosxa munaketeh ti navos mi xil, ma Tata namim mun naketeh ti navos mi xil.” ");
INSERT INTO tvk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Melele xa Iesu mei mistal mi moletin nan xil, tei e xil tenara ti, hisen Tomas xa lakesi mun ni Meah. ");
INSERT INTO tvk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma, melele xa bemei visal moletin sav xil na Iesu, labiteni mini labit, “!Xamem matepus Suv!” E Tomas biteni mi xil bit, “Ninake reitin ti mu en ituxoh melele xa nipus von xoxo vari e kaehen xalu, nisingin vakuheok ihe von xoxo xalu ak, e niling heok ihe rute xa latesal valxoun en.” ");
INSERT INTO tvk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wik tei mei mitavi, e moletin xil na Iesu ladi vituei vatei mun e nim ak. E melele nen ak Tomas tehe xil lateti. Tave ti neta xa lalok xol puiteh xil, latemanin xa Iesu mei mistal mi xil, e misoh de hilaep te xil e biteni bit, “Tomat iti mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Di, biteni mi Tomas bit, “Amei visal nou. Usingin vakuhem vahe inggak, e upus ti heok xalu. Utei momal ni hem e ulingi ite valxouk. Nenemien nam nave lu ti mun usil nou, e mei uke reitin e nou.” ");
INSERT INTO tvk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E Tomas bit rilomun ni bit, “!Xouk obe Suv navan! !Xouk iaxa obe Hi navan!” ");
INSERT INTO tvk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu biteni mini bit, “Xouk oneket e nou vengan xa opus nou. E tuxolxatien iti e meulien na ngan xil xa di lake reitin e nou, tave ti neta xa latapus ti nou.” ");
INSERT INTO tvk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","E meulien nan, Iesu tepol ni merekel sav xil holu mun pe met moletin nan xil xa natnatis xati ti vati e vanuvei ak. ");
INSERT INTO tvk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","E natetis holesok xil ak tengan vasak ni moletin xil mei lake reitin xa Iesu be Mesaea, Nat Hi. E xamim mukil kuhi xa ngan xil xa lake reitin en, xil lihur meulien sal ixo hisen. ");
INSERT INTO tvk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","E melengien sav tei, dutou ni holesok xil ak, Iesu mei mistal mi rut moletin nan xil e seri Oei Kaleli, xa lakesi mun ni Oei Taeberias. Ngan ak be tumulen usili xa tetep iaxa Iesu tepisen xi mi xil. ");
INSERT INTO tvk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E melele nen ak, Saemon Pita, Tomas (ngan xa lakesi ni Meah), Nataniel (te metimal te hal Kena e provins te hal Kaleli), nat Sebede xalu, e moletin sav lu mun na Iesu ladi vituei e rute ak. ");
INSERT INTO tvk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saemon Pita biteni mi ngan tesav xil ak bit, “Nama naso net xiak.” E xil labiteni mini labit, “Xamem mun muhusil xouk.” Ma, labe bot, e ba laso net e vongien ba vuma … ut milan, e latasar ti meseo tova. ");
INSERT INTO tvk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Melele xa eai da mistal, Iesu bemei misoh e seri oei. E moletin nan xil latakil ti xa be Iesu iaxai. ");
INSERT INTO tvk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","E xi mikei ba ni xil bit, “?Tiram maxoe xil, midep vari? ?Mutasar ti neta?” Lakei rilomun ni labit, “Tovuol vari.” ");
INSERT INTO tvk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma, biteni mi xil bit, “Muso net namim ihe ri metu te bot. Imak, ma muhas ti xil.” Ma, laso net nae. E melele xa lalihi, lapusi xa lasakras lalihi rat net ak vengan xa labas pupu ni meseo xil. ");
INSERT INTO tvk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Moletin xa eheien na Iesu di en pus kila e biteni mi Pita bit, “!Be Suv iaxai!” Melele xa Pita milonge xa be Suv, mising rilomun ni eising nan xil (vengan tehur rat rut eising nan xil tengan vapol) e but be oei. ");
INSERT INTO tvk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","E moletin sav xil labalis labe ut. Xil lalihi net nae xa polu ni meseo xil. Xil di lalihi mak vengan xa latari ti vahe sotin ra ut, be mita hanutap lim tang (100 m). ");
INSERT INTO tvk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Melele xa laduxoh ut, lapusi xa Iesu misupang ni sakol e di midin rut meseo xil del rut beret en. ");
INSERT INTO tvk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu biteni mi xil bit, “Muleh ti meseo xil xa mubasi iaxai vamei.” ");
INSERT INTO tvk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ma, Saemon Pita ba be bot, e milihi rat net xa polu ni meseo xil holu xa latellep. Melele xa labul xil vus, lakameti xa labas meseo handred tei, hanutap lu e tol e le tei mun (153). E tave ti neta xa labe holu mak, latatal papas net nae ti. ");
INSERT INTO tvk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu biteni mi xil bit, “Mumei muanien.” Moletin nan xil ulixil mikan tengan lasisi xa xi be visi, vengan lakila ngamu be Suv. ");
INSERT INTO tvk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma, Iesu be visal xil, nggur beret, e miseti mi xil. Di, pol ni mak mun del meseo. ");
INSERT INTO tvk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ngan ak tehe vatol nen xa Iesu testal mi moletin nan xil tetutou ni melele xa temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Melele xa langganien bus, Iesu misis Saemon Pita bit, “?Saemon, nat Sion, be reitin xa eheien nam di e nou mili moletin sav xil ak?” Pita bit rilomun ni bit, “Suv, okila xa be reitin xa ieok bei xouk nggoni ngan xa obe tua navan.” Iesu biteni mini bit, “Uhangan sulut sipsip savan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Be valu nen, Iesu misisi bit, “?Saemon, nat Sion, be reitin xa eheien nam di e nou?” “Suv, okila xa ieok bei xouk nggoni ngan xa obe tua navan.” Iesu biteni mini bit, “Ulaxat kuh sipsip savan xil.” ");
INSERT INTO tvk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Di, be vatol nen, Iesu misisi mun bit, “?Saemon, nat Sion, be reitin xa iem bei nou nggoni ngan xa nabe tumali?” Pita milonge misa e tinen muis xa Iesu tesisi tehe vatol nen bit, “?Be reitin xa iem bei nou nggoni ngan xa nabe tumali?” Misak ni, Pita bit rilomun ni mini bit, “Suv, xouk okil holesok xil vus. Okila xa be reitin xa ieok bei xouk nggoni ngan xa obe tua navan.” Iesu biteni mini bit, “Imak, ma uhangan sipsip savan xil. ");
INSERT INTO tvk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","E reitin li nabiteni minuk xa melele xa otehe tiram maxoe tamu, otevue xatuk e otekila otekakao oteha e rute xil vus xa iem tehei. E melele xa mei uhe momatu, utei momal ni hem e moletin sav ising xolok e itelak uhe rute tei xa iem ti navei tengan ova en.” ");
INSERT INTO tvk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu biteni mak tengan vahit lelen suse xa Pita ipet rat his Hi ixo maten nan. Di, Iesu biteni mini bit, “Utit ni ngan taxa ti uhusil inou.” ");
INSERT INTO tvk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita biles, e pus moletin xa eheien na Iesu di en, ngan xa tetotan sangas visal Iesu melele xa di lateanien vituei e tesisi tehit, “?Suv, visi iaxa isa ratuk uhe he elu nam xil?” ");
INSERT INTO tvk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Melele xa Pita pusi, misis Iesu bit, “?Suv, itep mi moletin ak?” ");
INSERT INTO tvk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu bit rilomun ni bit, “Xosxa ieok bei tengan moletin ak imeul itat imak ituxoh melele xa nitilomun en, ngan ak tave ti tengan xouk okila. !E xouk, utit ni ngan taxa ti uhusil inou!” ");
INSERT INTO tvk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ve sepinien ak, longeongen mikapis xa moletin ak namat ti. E Iesu tenaviteni ti xa xi namat. Tehiteni tang tehit, “Xosxa ieok ihei tengan imeul itat imak ituxoh melele xa nitilomun en, ngan ak tave ti tengan xouk okila.” ");
INSERT INTO tvk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inou vari iaxa nabe moletin xa Iesu di tesep usili xiak, hisok Sion. Inou natesep usil holesok xil ak e natetis xati, e nakila xa holesok xil vus xa di natesep usili be reitin. ");
INSERT INTO tvk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu tepol ni holesok xil holu mak mu mili naha xa natetis xati. Xosxa latis xat holesok xil vus xa xi tepol ni vati e vanuvei xil, ma nanemi nabit ut tapin ti e ut xil vus te ut etan tengan laling xil en. ");
INSERT INTO tvk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tuxoli Teopolis, Nadis vanuvei ak bat minuk. E tisen xa natetisi tehat minuk tetiamu, natehit usil holesok xil xa Iesu di tepol ni e di tepispisi ni e melele xa tepol kokot ni polien nan xil ");
INSERT INTO tvk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ba duxoh melele xa Hi tehur rati tehe ut nesao. E melele xa Iesu teta tamu e ut etan, texo xeihen na Ninin Eo, xi tepispisi mi moletin xil xa tehosei xil mei latehe eloheoh nan xil. ");
INSERT INTO tvk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Melele xa Iesu tehur longpangasien nan e temat, xi testal mi moletin nan xil melengien hanutap lu (40) e suse holu xa tepisen ni xa xi temeul rilomun reitin ra maten. E, e melele nen xil ak, Iesu tesepin tetel xil usil suse xa Hi mei ihe suv toto na moletin xil en. ");
INSERT INTO tvk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","E melele xa Iesu teta tamu tetel moletin nan xil, tesel xat xil tehit, “Munahe reling Serusalem ti mu. E mutatil sanien te Ninin Eo xa natehiteni mi xamim xa Tata navan tehit xati tengan isa ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Vengan xa, tetiamu, Sion tebaptaes ni moletin xil ni oei tang, e navehi ti, Hi ibaptaes ni xamim ni Ninin Eo.” ");
INSERT INTO tvk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Di, e melengien tei mun, eloheoh xil lamei vituei del Iesu e lasisi labit, “?Suv midep? ?Taxeak, melengien momal tengan xouk omei ove suv toto na mol‑Isrel xil vaxoni suv toto Deved tetiamu, mu tamal ti mu?” ");
INSERT INTO tvk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","E Iesu bit rilomun ni mi xil bit, “Melengien ak, Tata kestang nggur xeihen tengan ihosei. Tave tengan ti xa xamim mukil melele xa xi teling xati tengan istal en. ");
INSERT INTO tvk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","E xamim mukil ngan ak kestang, melele xa Ninin Eo mei ise xat xamim, mupolu ni xeihen. Ma ti muhithiten holesok xil xa natehiteni e natepol ni. Mupol ni e taon te hal Serusalem, e rute sav xil mun e provins te hal Sudea. Ivus, ti muhithiteni e provins te hal Sameria, e ut sav xil mun iha ihur vuol ni ut etan.” ");
INSERT INTO tvk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Melele xa bit sepinien ak bus e xil dit tamu lapusi, Hi nggur rat Iesu be ut nesao, e momah tei mei da xole e latapus ti mun. ");
INSERT INTO tvk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","E melele xa di tamu laketeh be tilang hat, vatei takes, moletin lu xa lusing ni eising te mieh lusoh visal xil. ");
INSERT INTO tvk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","E lubiteni mi xil lubit, “?Mol‑Kaleli xil, xamim di musoh e di muketeh be nesao mak veneh? Iesu xa Hi nggur rati ra xamim e ngguri be ut nesao, xi vari tang itilomun imei ixo hisit sexien taxa di mupusi be ut nesao iaxai.” ");
INSERT INTO tvk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Di, eloheoh xil labe reling Vathu te Urvatiei te Olip e ladilomun labe Serusalem xa tave sotin ti. ");
INSERT INTO tvk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Melele xa laduxoh taon, labe von toen xa be nesao e nim xa ladi en. Ngan xil xa ladi vituei e melele nen ak labe Pita, Sion, e Temis; Andru, Pilip e Tomas; Batalomiu e Matiu; Temis (xa be nat Alveas), Saemon (xa lakesi ni Silixin) e Sudas (nat Temis). ");
INSERT INTO tvk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vehakut, eloheoh xil ak lamei di lasis vituei. E moletin sav xil mun xa mei di lasis vituei del xil labe Meri (nine Iesu), tua na Iesu xatel, del rut atou xil mun. ");
INSERT INTO tvk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Melengien vahis mei mitavi, e moletin xil xa laling neketen nae e Iesu lamei vituei. Moletin xil vus sangas laduxoh handred tei e hanutap tei (120). Melele xa ladi vituei mak, Pita mitamea misoh pe metexil e biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tuxoli e hinoxoli xil, sepinien xa suv toto Deved tehit lelen ni e Vanuvei Eo mei mistal be reitin usil Sudas Eskariot xa tetel ngan xil xa latemei latetal xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sudas tehe tei e xamem xa Iesu tehosei, e xi mun tepol vituei tetel xamem e polien namem.” ");
INSERT INTO tvk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Vat xil na pris xil latesa mani mi Sudas ve tesaen xa tepol ni. E melele xa Sudas temat, latehur mani nan e latexal rut tan ni. Ngan ak tehe tan taxa xi temot en, xa tesak ni vangen temesel e tinen xil testal. ");
INSERT INTO tvk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Melele xa longeongen usil rin xa Sudas temat texo en tekapis e ut xil vus te hal Serusalem, lakes rute ak ni ‘Akeldama,’ xa koute teni be ‘Tan te Ra.’) ");
INSERT INTO tvk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","E Pita biteni mun bit, “Reitin, suv toto Deved tehit lelen ni usil Sudas e Sam tei tehit, ‘Hi Suv, upol ni vatimol nan iha ikesae, e horamue tovuol mun nati e tim san.’ Deved tehit lelen ni mun tehit, ‘Bos xa moletin tei mei ixolesi e ihur voninen.’ ");
INSERT INTO tvk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ve rin ak, momal tengan moletin sav tei mei imos e xamem, tei xa tehusil xamem tetiamu e melele xa matehusil rohon ni Suv Iesu, e texulehi tehusil xamem e melele xil vus xa matekakao tetela. ");
INSERT INTO tvk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Reitin, muhosei moletin tova xa teta tetel xat xir e melele xa Sion di tebaptaes ni moletin xil, mei duxoh melengien xa Hi tehur rat Iesu tehe ut nesao. Rihosei tova e xil vari tengan mei ipol itel xamem e ti ihit rati mi mosav xil xa be reitin xa tepus Iesu temea rilomun ra maten.” ");
INSERT INTO tvk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma xil labosei moletin lu: Siosep Barsabas (xa hisen tei mun be Sastas) e Matias. ");
INSERT INTO tvk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Di, lasis mi Hi labit, “Suv, xouk okil nenemien na moletin xil vus. Ma upisen ni mi xamem xa visi e moletin xalu ak iaxa otehosei ");
INSERT INTO tvk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tengan mei ipol ixoni eloheoh nam. ?Visi e xalu mei ixoles von Sudas, xa testokovein polien ak tengan ha ihe voninen xati te maten?” ");
INSERT INTO tvk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Di, lasis xalu tengan mei lalitis hisealu iti e hat lu. Di, laso hat xalu ak lube valit neta tei. E melele xa lalihi rat hat tei, lakameti xa be ngan xa his Matias da en. Misak ni, be Matias iaxa langguri mei mos e eloheoh xil xa latehe tei e le tei (11). ");
INSERT INTO tvk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Melele xa melengien te anien xa lakesi ni ‘Pentekos’ bemei, moletin xil vus xa laling neketen nae e Iesu lamei ladi vituei e nim tei. ");
INSERT INTO tvk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Vatei takes, lalong tangalen tei xa nggo ut nesao e bemei nggoni votiang tei xa mu nggeih. Tangalen ak mise sen nim xa di ladotan en. ");
INSERT INTO tvk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Di, neta tei mistal e nim ak xa pili nggoni upang xa mitasil ba misoh e vatixil kekes. ");
INSERT INTO tvk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","E melele nen ak, xil vus mei lapolu ni Ninin Eo. E Ninin misa xeihen mi xil xa misak ni xil di lasepin nggo hisit sepinien sav xil xa tave nae xati ti. ");
INSERT INTO tvk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","E melele nen ak, Siu xil xa latexo kantri sav xil holu ladi e taon te hal Serusalem. Latemei vengan xa neketen nae e Hi nggeih e iexil bei tengan lamot mi Hi e melengien te Pentekos. ");
INSERT INTO tvk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Melele xa moletin xil ak lalong tangalen ak, xil holu lamei vituei tengan lakil ti naha iaxa di mistal xiak. E melele xa lamei sangas, latemanin vengan xa di lalong kil sepinien na moletin xil na Iesu nggo sepinien savsav nae xil. ");
INSERT INTO tvk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xil lamesep pupu e lasis xil mun tang labit, “!Ei, moletin xil xa di lasepin iaxai, xil vus labe ngan Kaleli xil tang! ");
INSERT INTO tvk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","?Ma veneh iaxa di ralonge xa xil di lasepin nggo sepinien savsav xati nar xil? ");
INSERT INTO tvk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Xir rabe ngan Partia, Midia, e Ilam; ngan Mesopotemia, Sudea e Kapadosia; ngan Pontas e Esia; ");
INSERT INTO tvk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ngan Frikea e Pampilia; ngan Isip e rin xil xa be Libia sangas visal Saerin. Rute e xir rabe Siu xil te hal Rom, e ngan tesav e xir labe te hal Rom xa labit xati tengan lihusil Hi e rae na Siu xil. ");
INSERT INTO tvk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Rute sav mun labe ngan Krit e Arebia. !E tave ti neta xa ranggo ut sav xil holu xa mak, e xir vus di ralong xil di lasepin e sepinien nar xati xil usil holesok xil xa tellep pupu xa Hi di tepol ni!” ");
INSERT INTO tvk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Xil vus latemanin e lanem holu usili. Ma lasis pilei xil mun labit, “?Naha vari koute te holesok xil ak?” ");
INSERT INTO tvk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E rute xil lasep pepamen ni eloheoh xil labit, “!Moletin xil xai lamun tova tang e latalang ni!” ");
INSERT INTO tvk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Di, Pita misoh del eloheoh sav xil xa labe tei e le tei (11), e mikei nggeih ba mi vanut moletin xil ak bit, “Xir Siu xil, e xamim vus xa mudi e Serusalem e melele ak, muteong ni nou e nihit kil koute te holesok xil ak mi xamim. ");
INSERT INTO tvk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Moletin xil ak latamun ti vaxoni ngan xa di munemi. Taxeak be naen klok makoe tang. ");
INSERT INTO tvk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E‑e. Naha xa di mupusi nggoni ngan taxa Hi tehit lelen ni texo provet Soel tetiamu tehit, ");
INSERT INTO tvk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘E melengien kor xil, inou nisa Ninin Eo navan mi moletin xil ngasen. Horamue e atuli namim xil lihit lelen sepinien navan xil. E horam maxoe xil ti lipus kil nenemien xuxus xil ixo Hi, e momatu xil lipus kil neta ixo metuveen xil. ");
INSERT INTO tvk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","E melengien xil ak, inou niteh rat Ninin Eo navan ha ise xat moletin navan xil vus ituxoh tiramue e atou xil mun xa labe slev tang. Reitin, xil mun, ti lihit lelen sepinien navan xil. ");
INSERT INTO tvk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Inou nipol ni holesok xil xa tellep listal e tilang hat, e nipisen xeihen navan e ut etan. E ut etan, nipol ni holesok xil listal ixoni melele te vaeen: ra ileh, e upang e eas ituvan e ut ngasen. ");
INSERT INTO tvk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","E tilang hat, meteneai mei imaluxoluk, e aveti imei ipili ixoni ra. Melele xa moletin xil lipus holesok xil ak mei istal, lipus kila xa melengien xa eilep na Hi Suv sangas vastal xa mei ilepis rin na moletin xil vus. ");
INSERT INTO tvk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E melele nen ak, ngan xil vus xa likes nou ve tutouen, inou, Hi Suv, niteh meulien e xil.’” ");
INSERT INTO tvk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita biteni mun mi xil bit, “!Tuxoli xil te hal Isrel, muteong ni sepinien xil ak! Melele xa Iesu te hal Nasaret teta tamu tetel xamim, Hi tepisen kila xa xi tehe Mesaea nan texo xeihen xa tesa ni mini tengan vapol ni merekel xil e holesok sav xil xa tellep pe valnaomim xa vasak ni mutemanin. Xamim vus mukil kuhi xa ngan ak be reitin. ");
INSERT INTO tvk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E nggusil lingxatien nan, Hi xa mikil holesok xil vus xa di mistal teling Iesu pe hemim. E xamim, mutesa maten mini melele xa mutexeih xat ngan xil xa latahusil ti rae xil na Hi tengan liti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","E Hi tesak ni temea rilomun ra maten tengan nahur ti mun longpangasien teni. Vengan xa xeihen te maten misakras vahur xati. ");
INSERT INTO tvk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ngan ak nggoni ngan xa suv toto Deved tetiamu tehit lelen ni usil Iesu tehit, ‘Vehakut, napus Hi Suv de riuk metu. E uluk nakan ti vengan xa xi de visal nou. ");
INSERT INTO tvk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Reitin, nabesi nou e nasa memesien ba mini. E naling nenesien navan en xa isikoe xol tenbeok. ");
INSERT INTO tvk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Reitin, nakila xa namaen ninin navan ti nate von maten. E namaen ni ti tiei navan, moletin eo nan, tengan navolel e vul te tehinen. ");
INSERT INTO tvk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xi pisen suse te meulien minou. Nihesi nou vehakut vengan xa xi de visal nou.’” ");
INSERT INTO tvk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita biteni mun mi vanut moletin xil bit, “Tuxoli xil te hal Isrel, inou nihiteni imal tang mi xamim usil Deved, avu nar. Xi temat, e latetihin ni. E von tehinen nan da tak duxoh xosali. ");
INSERT INTO tvk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Rakila xa xi tehe provet tei. Xi tekila xa Hi tepol ni hitxatien te xeih tei mini xa isak ni tei e vatimol nan ihur voninen e mei ihe suv toto. ");
INSERT INTO tvk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Suv toto Deved tepus kil naha xa Hi ipol ni e melengien xil xa ti imei. Ma tesep usil mea rilomunen na Mesaea melele xa tehiteni tehit, ‘Hi namaen ninin navan ti nate von maten. E namaen ni ti tiei navan, moletin eo nan, tengan navolel e vul te tehinen.’ ");
INSERT INTO tvk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ngan ak di misepin usil Iesu xa Hi tesak ni temea rilomun ra maten, e xamem vus matepusi xa be reitin. ");
INSERT INTO tvk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hi tepet rati tehe ut nesao tengan ha vate von xeihen xa de rin metu. E Tamen tesa Ninin Eo mini nggoni ngan taxa xi tehit xati mi xamem. E taxeak, naha xa mupusi e mulonge be Ninin Eo ak xa Iesu di misa ni mi xamem. ");
INSERT INTO tvk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Xir vus rakila xa tenave suv toto Deved ti iaxa tehe ut nesao. E Deved vari tang tesepin usil Iesu Kristo melele xa tesa sepinien ak tehit, ‘Hi Suv biteni mi Suv navan bit, “Utotan e riuk metu, ");
INSERT INTO tvk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ituxoh melele xa niling ngan xil xa labe elu minuk mei liti pe hem.”’ ");
INSERT INTO tvk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Misak ni, momal tengan xamim e mol‑Isrel xil vus mukil kuhi mak xa Iesu vari iaxa Hi tepol ni be Mesaea e be Suv nar. !E be xi vari xa xamim muteti xati e eivave!” ");
INSERT INTO tvk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Melele xa moletin xil lalong sepinien nan, iexil bon e tinexil muis. Ma lasis Pita del eloheoh sav xil mun labit, “?Tua xil, naha li vari iaxa makila mapol ni?” ");
INSERT INTO tvk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Pita bit rilomun ni mi xil bit, “Xamim kekes muhiles ra tesaen xil namim e mumaen xamem mubaptaes ni xamim e his Iesu Kristo. Imak, ma Hi ileh rerat tesaen namim xil e iketeh ihos rilomun mi xamim. Ivus, Hi isa Ninin Eo nan mi xamim ixoni sanien tei. ");
INSERT INTO tvk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Xamim vus mupol ni imak vengan xa Hi tepol ni hitxatien ak tetel xamim e horamue namim xil, e tetel ngan xil vus xa ladi sotin. Reitin, Hi Suv tehit xati xa xi isa Ninin Eo nan mi ngan xil ngasen xa xi di mikes xil tengan mei lihe moletin nan xil.” ");
INSERT INTO tvk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita misel xat xil nggeih del sepinien sav xil mun. E dakes xil bit, “!Musis Hi tengan iteh meulien e xamim ra pangasien xa isa ni imei mi moletin tesa xil te xosali ak!” ");
INSERT INTO tvk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Di, moletin xil holu lake reitin e sepinien nan, ma lamaen eloheoh xil labaptaes ni xil. E melengien nen ak, moletin xil laduxoh taosen tol (3000) xa mei lamos del ngan xil xa laling neketen nae e Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","E melengien xil ngasen, moletin xil ak di langgusil xat sexien xil ak: lamei vituei, lateong xat naha xa eloheoh xil di lapispisi ni mi xil, laseti anien mi xil, langgur Anien Eo na Suv, e di lasis vituei. ");
INSERT INTO tvk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Melengien xil holu mei mitavi, e Hi di pol ni merekel xil e sexien xil holu xa tellep nggo he eloheoh xil. Misak ni, moletin xil vus latemanin ni e lamerere ni Hi mak mu. ");
INSERT INTO tvk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ngan xil vus xa laneket e Iesu, vehakut labe vituei, e di laso viton holesok nae xil tengan ti litutou ni ti e xil xa labe tamure ni neta ngan. ");
INSERT INTO tvk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","E rute ngan xil di lapos ni tan nae mu rut holesok nae xil, e lasa mani teni ba tengan vatutou ni ngan xil xa labe tamure ni neta. ");
INSERT INTO tvk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Melengien xil ngasen, xil lamei vituei e vioh te Nim Eo na Hi. E tim sae xil, laso viton anien ae del tinae hos e di langganien vituei del sien. ");
INSERT INTO tvk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xil di latepet rat Hi, e moletin xil vus di lamerere ni xil. E melengien xil vus, Suv Iesu di misak ni moletin holu mu mei di lamos e xil e xi di miteh meulien e xil. ");
INSERT INTO tvk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Vatei, e tri klok mahis xa be melele te sisen na Siu xil, Pita xal Sion lube Nim Eo na Hi tengan lalosis. ");
INSERT INTO tvk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","E melele nen ak, rut moletin xil lapo tua tei nae xa misakras vakakao vengan xa len tesa melele xa ninen telingi. Xil lalingi sangas ni puiteh te vioh te Nim Eo xa lakesi ni ‘Puiteh xa Bos.’ E melengien xil ngasen, xil di lapoe ba lalingi e rute ak tengan ti varam ni mani ra moletin xil xa di lamei e Nim Eo. ");
INSERT INTO tvk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Melele xa moletin ak pus Pita xal Sion lumei sangas visali tengan lalohe nim, miram ni xalu tengan lalosa neta tova mini. ");
INSERT INTO tvk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Xalu luketeh momal ba ni, e Pita biteni mini bit, “!Keteh pus xamel!” ");
INSERT INTO tvk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma xi miketeh pus xalu e minemi bit ti ihur neta tova ra xalu. ");
INSERT INTO tvk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","E Pita biteni mini bit, “Mani navan tovuol vari, e naha xa nangguri, nisa ni minuk. !E his Iesu Kristo te hal Nasaret, tamea e kakao!” ");
INSERT INTO tvk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Di, Pita dal xat hen metu e dutou ni mitamea e misoh. Vatei takes, len xalu mei lunggeih. ");
INSERT INTO tvk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Moletin ak butahut be nesao, misoh e mikakao. Di, nggusil Pita xalu latbe vioh te Nim Eo na Hi. E inggak mun, moletin ak di mikakao, di butahut, e di memes Hi holu. ");
INSERT INTO tvk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Melele xa moletin xil lapusi xa di mikakao e di memes Hi mak, ");
INSERT INTO tvk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","lapus kila xa be ngan xa, vehakut, di tetotan sangas visal ‘Puiteh xa Bos’ te vioh te Nim Eo e di miram mi moletin xil ve mani. E xil vus iexil bon e latemanin ni naha xa mistal mini. ");
INSERT INTO tvk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Melele xa moletin ak xa mei mikakao di tamu nggusil xat Pita xal Sion, moletin xil vus latemanin e di labesi xil holu. Ladi e rute tei e vioh te Nim Eo xa lakesi ni ‘Veranda na Solomon.’ ");
INSERT INTO tvk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Melele xa Pita pus moletin xil ak, biteni mi xil bit, “?Tuxoli xil te hal Isrel, veneh ma di mumesep mak? ?Veneh ma di mule mah xat xamel mak? ?Munemi mubit moletin ak mikakao nggo xeihen namel tang? ?Mu munemi xa di mikakao vengan xa sexien namel momal pe met Hi? !E‑e, tamak ti! ");
INSERT INTO tvk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hi vari tesak ni mei bos rilomun. Hi ak be Hi na Ebraham, na Aesak, na Siekob, e na avu nar xil mun. Xi vari iaxa tepet rat his Iesu, moletin te polien nan, be nesao. E xamim, mutesi ni pe met Paelet e mutelingi tehe hen tengan vahasi vamat. Paelet ien tehei tengan vamaen ni ha ven vamase, e xamim mutamaen ni ti. ");
INSERT INTO tvk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Xi xa be moletin eo xa momal tevi pe met Hi, xamim iaxa mutesi ni. Di, mutesis Paelet tengan vamaen moletin tei xa tehas vin moletin mi xamim. ");
INSERT INTO tvk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xamim iaxa mutesak ni latehas vin ngan xa be Vatit Meulien. E Hi tesak ni temeul rilomun ra maten. Xamel matepusi, e taxeak di malsep mesen ni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Xeihen xa di e his Iesu iaxa tesak ni le moletin ak mei bos. Naha xa mupusi mistal xiak, mistal vengan xa moletin ak teling neketen nan de his Iesu Kristo. E ve rin ak xi dat bos tang pe metemim xosali. ");
INSERT INTO tvk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Tua navan xil, nakila xa naha xa xamim tetel vat namim xil mutepol ni mi Iesu, mutepol ni vengan xa mutnakil ti. ");
INSERT INTO tvk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","E suse ak, Hi tepol ni lingxatien nan mei testal tehe reitin. Vengan xa tetiamu, Hi tehit lelen ni texo provet xil xa Mesaea nan mei ilong pangas xi. ");
INSERT INTO tvk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mak, ma mulonge isa ve tesaen namim xil e muhiles sexien namim xil. Mumei visal Hi tengan iketeh ihos rilomun mi xamim, ");
INSERT INTO tvk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","isak ni sien iti e meulien namim, e isa rilomun ni Iesu, Mesaea xa xi tehosei, tengan mei iteh meulien e xamim. ");
INSERT INTO tvk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","E Iesu itat e ut nesao iha vuma … imal ni melengien xa holesok xil vus mei ituxoh hoxalite teni e Hi isak ni mei ihe neta hu. Ixoni naha xa Hi tehit lelen ni tetiamu texo provet eo nan xil. ");
INSERT INTO tvk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ixoni ngan xa Mosis tehiteni tehit, ‘Hi, Suv namim, ipet rat tei e xamim tengan mei ihe provet tei ixoni nou. Muteong xat holesok xil ngasen xa xi ihiteni mi xamim. ");
INSERT INTO tvk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","E xosxa ti e xamim linateong xat provet ak ti, ma Hi isil rerat xil ra vanut moletin nan xil e ihas xil lilel.’” ");
INSERT INTO tvk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","E Pita biteni mun mi xil bit, “Reitin mak, provet Samuel del provet xil xa latemei tetutou ni, xil vus latehit lelen holesok xil xa di mistal taxeak. ");
INSERT INTO tvk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Xir del provet xil ak, rabe mol‑Isrel xil. Misak ni, hitxatien te xeih xa Hi tepol ni tetel xil be nar vus. Nggoni ngan xa Hi tehit xati mi Ebraham tehit, ‘Vatimol nam xil lihe suse te tuxolxatien navan iha mi vanut moletin xil vus te ut etan.’ ");
INSERT INTO tvk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mak, ma melele xa Hi tesa moletin te polien nan temei, tesa ni mi xir tetiamu. Xi ien tehei tengan vatuxol xat xir vaxo sexien xa isak ni xir rihiles ra sexien tesa nar xil.” ");
INSERT INTO tvk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Melele xa Pita xal Sion di tamu lusepin mi moletin xil, rut pris xil mei lastal del mereketeh xil te Nim Eo del Satusi xil mun. ");
INSERT INTO tvk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iexil mikat vengan xa eloheoh xalu ak di lupispisi mi moletin xil xa Iesu temea rilomun ra maten, e, ve rin ak, be reitin xa xil mun likila limea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ma xil ladal xat xalu e laling xalu e nim te xeih ba duxoh melengien sav vengan xa be mahis ngamu. ");
INSERT INTO tvk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","E moletin holu xa lalong sepinien nalu lake reitin en. Misak ni, ngan xil xa laling neketen nae e Iesu sangas laduxoh taosen lim (5000). ");
INSERT INTO tvk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","E makoe nen, vat xil na Siu xil, elda xil, del titsa xil te rae na Mosis lamei vituei e kaonsel na Siu xil e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xil ladotan del Anas xa be vatixar na pris xil, e ngan xil mun xa lastal langgo vatimol na vatixar na pris xil xa Kaeafas, Sion, e Aleksanda latbe tol e xil. ");
INSERT INTO tvk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Melele xa xil vus ladotan, ladel Pita xal Sion mei lusoh pe metexil. E lasis xalu labit, “?Neta xa xamil mupol ni, munggur xeihen teni nggo xave? ?Mutepol ni netak e his visi?” ");
INSERT INTO tvk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","E xeihen na Ninin Eo mei polu e Pita, ma bit rilomun ni mi xil bit, “Vat xil e elda xil na Siu xil, ");
INSERT INTO tvk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","xosali, mudel xamel tengan musis xamel usil sexien hos xa mapol ni mi moletin xa len tesa. Mubit mukil ti xa xi bemei bos nggo sexien eah. ");
INSERT INTO tvk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mak, ma malisep kila mi xamim e mi mol‑Isrel xil vus xa le moletin ak bemei bos e xi di misoh pe metemim xosali nggo xeihen xa di e his Iesu Kristo te hal Nasaret. Ngan ak tehe Iesu taxa xamim muteti xati e eivave e temat. Ngan xa Hi tesak ni temea rilomun ra maten. ");
INSERT INTO tvk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Vanuvei Eo na Hi tesep usil Iesu tehit, ‘Pos xa moletin te polien xil di lasin ni, xi vari iaxa mei be seteman xati te nim e mili sen pos nen xil vus.’ ");
INSERT INTO tvk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iesu kestang mikila iteh meulien e xir. Vengan xa e ut etan, his moletin sav tovuol mun xa Hi tesa ni tengan vateh meulien e xir.” ");
INSERT INTO tvk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Melele xa vat xil te kaonsel lalong sepinien hos na Pita xal Sion, latemanin ni xalu. Vengan xa, tave ti neta xa lutasukul kuhi ti, lapusi xa ulikanen tovuol e xalu. E lapus kila xa xalu di lutehusil xat Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","E melele xa lapus moletin xa len mei bos di tamu misoh e rin nalu, lasakras laso sepinien tova vaha xat xalu. ");
INSERT INTO tvk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ma xil lasil rerat xatel latbe hale vuteili. Melele xa latoba, xil lasep tetavoe mi xil mun tang usil rin natel ");
INSERT INTO tvk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","labit, “?Ripol ni itep mi xalu? Moletin xil vus te hal Serusalem lakila xa xalu ak lutepol ni merekel tei xa eilep pupu. Rasakras raviteni ravit tave reitin ti. ");
INSERT INTO tvk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Xosxa rihit moletin xil linalongeong ti mun usil merekel ak, momal tengan rike xat xalu tengan lalnasepin ti mun mi moletin xil usil Iesu.” ");
INSERT INTO tvk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Di, lakes rilomun ni xalu lumei nim, e lake xat xalu nggeih tengan lalnasepin ti e lalnapispisi ti mun mi moletin xil usil Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","E Pita xal Sion lubit rilomun ni mi xil lubit, “Xamim mulepis rin namel. ?Momal mak mu tengan xamel ti maliteong xat xamim, mu maliteong xat Hi? ?Munemi midep? ");
INSERT INTO tvk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Vengan xa xamel masakras malhit malnasepin ti usil naha xa matepusi e matelonge usil Iesu.” ");
INSERT INTO tvk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma vat xil te kaonsel lake xat xalu nggeih rilomun e lamaen xalu ba vexalu mase. Lamaen xalu luba vengan xa lasakras lasa pangasien mi xalu vengan xa moletin xil vus di lapet rat his Hi ve naha xa testal. ");
INSERT INTO tvk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Moletin xil lakila xa naha xa testal be merekel tei vengan moletin xa len mei tehos, huram nan mili huram hanutap lu (40). ");
INSERT INTO tvk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Melele xa vat xil te kaonsel lamaen Pita xal Sion ba vexalu mase, ludilomun ba lupus timue nalu xil xa laling neketen nae e Iesu. E melele xa lupus xil, lubit mesen sepinien xil vus mi xil xa vat xil na pris xil, del elda xil latehiteni mi xalu. ");
INSERT INTO tvk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","E melele xa lalonge, xil vus lasis vituei ba mi Hi labit, “Hi Suv, xouk otepol ni ut nesao, ut etan, tas, e holesok xil vus xa ladi en. ");
INSERT INTO tvk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nggo xeihen te Ninin Eo, xouk otesepin texo avu namem Deved xa tehe moletin te polien nam otehit, ‘?Veneh ma ngan xil xa latave Siu ti di iexil mikat? ?Moletin xil di lapol ni lingxatien xil xa mei be neta sav tang veneh? ");
INSERT INTO tvk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Suv toto xil te ut etan di labue xat xil ve vaeen, e vat xil lamei vituei tengan lavae vatel Hi Suv e vatel Mesaea nan xa xi tehosei.’ ");
INSERT INTO tvk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Reitin mak, suv toto Herod e Pontias Paelet mei lutevituei e Serusalem tetel Siu xil e ngan xil xa latave Siu ti tengan lavae vatel Iesu, xa be moletin eo te polien nam. ");
INSERT INTO tvk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naha xa latepol ni mi Iesu tehusil naha xa xouk oteling xati tuei texo xeihen nam tengan mei istal. ");
INSERT INTO tvk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hi Suv, taxeak, uteong kuhi ni sepinien te xeih xil xa di laso ni ba xat rin namem, moletin te polien nam xil. Uhur rat ulikanen ihe reling xamem tengan mukila muhithiten sepinien nam itel xeihen. ");
INSERT INTO tvk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Usa xeihen nam mi xamem li tengan mukila mutal rerat mesien ra ngan xil xa lamesei, e mupol ni merekel e holesok sav xil xa tellep ixo his Iesu xa be moletin eo te polien nam.” ");
INSERT INTO tvk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Melele xa lasis bus, nim xa ladi en mulul. E xil vus mei lapolu ni Ninin Eo, e ulixil takan ti mun. Ma ba di lasetu ni sepinien na Hi del xeihen. ");
INSERT INTO tvk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vanut moletin xil xa laling neketen nae e Iesu, ladi vituei bos e nenemien nae be tei takes. Tovuol e xil vahe hokan ni neta ngan, xil vus lamaen holesok nae xil tengan latutou ni mosav xil ni. ");
INSERT INTO tvk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Del xeihen na Ninin Eo, eloheoh xil di labit usil mea rilomunen na Iesu. E Hi di duxol xat holesok xil vus xa di lapol ni. ");
INSERT INTO tvk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Xil latave tamure ni ti neta, vengan xa vatei nga, ngan xil xa tan nae mu nim mae di, lapos ni. Di, langgur mani nen ");
INSERT INTO tvk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","e lasa ni ba ni eloheoh xil. Di, laseti mani xil ak tengan vatutou ni ngan xil xa holesok nae tovuol. ");
INSERT INTO tvk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","E melele nen ak, moletin tei teta, hisen Siosep te hal Saepras. Xi nggo vatimol na Livae. Ve sexien hos nan, eloheoh xil laling hisen teimun nan be ‘Banabas’ xa koute teni be ‘moletin xa di pet rat nenemien na mosav xil.’ ");
INSERT INTO tvk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","E melele nen tak, xi pos ni tan tei nan e misa mani nen ba ni eloheoh xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","E melele nen ak, moletin teimun di mos e xil, hisen Ananaeas. E xi del atou nan xa hisen Savira lupos ni rut tan tei nalu. ");
INSERT INTO tvk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","E xalu lupol ni lingxatien tei nalu xa lalkixat xat rut mani nen ihe nalu. Di, Ananaeas mileh rut mani tang e ba misa ni mi eloheoh xil bit, “Xamel mapos ni rut tan namel e mani xil vus teni xiak.” ");
INSERT INTO tvk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Di, Pita biteni mini bit, “?Ananaeas, veneh ma otemaen Temat mei tepurun nenemien nam? ?Veneh ma obit oluvos Ninin Eo melele xa otepos ni rut tan nam e otekixat xat rut mani teni be nam? ");
INSERT INTO tvk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tetiamu, tan ak tehe nam. E melele xa otepos ni, mani xil vus nen be nam. ?Misak ni, veneh ma obit opol ni vamak? !Luvosen xa di opol ni xiak, otapol ni ti vaha xat xamem tang, e di opol ni ba xat Hi vari!” ");
INSERT INTO tvk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Melele xa Ananaeas milonge mak, vatei takes, mot e mat. Moletin xil vus xa lalongeong ni, le mulul holu ven. ");
INSERT INTO tvk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Di, rut horam maxoe xil lamei nim e lapis xol tiei nan. Di, lapoe ba, ladihin ni. ");
INSERT INTO tvk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Haoa tol mei mitavi, e atou nan bemei nim. E xi takil ti vari xa tiramue nan mat. ");
INSERT INTO tvk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","E Pita misisi bit, “?Hit kuhi mu minou, ngan ak be mani xil vus xa xamil tiramue nam mutehuri e tan xa mutepos ni?” Atou ak bit rilomun ni mini bit, “Io, xil vus iaxai.” ");
INSERT INTO tvk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ma Pita biteni mini bit, “?Veneh ma xouk del tiramue nam mubit mulosak pis Ninin na Hi? ?Olonge? Ngan xil xa latetihin tiramue nam di lamei sangas, ladi ngamu e puiteh. E mei lipo tiei nam mun iha.” ");
INSERT INTO tvk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vatakes, atou ak mun mot e mat sangas visal le Pita. E melele xa horam maxoe xil lamei nim, lakameti xa xi mun mat. Misak ni, lapoe ba e ladihin ni de ri tiramue nan. ");
INSERT INTO tvk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ngan xil vus te sias te hal Serusalem, del mosav xil mun xa lalongeong ni naha xa mistal, ulixil mikan tova tang ven. ");
INSERT INTO tvk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","E melele nen ak, eloheoh xil di lapol ni merekel xil del sexien xil holu xa tellep pe met moletin xil. Vehakut, ngan xil xa laneket e Iesu mei di labe vituei e rute tei e vioh te Nim Eo xa lakesi ni ‘Horao ma suv toto Solomon.’ ");
INSERT INTO tvk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Neta sav xa moletin xil ngasen lamerere ni xil, moletin xil xa lataneket ti mu, uli mikan tengan lamei vituei vatel xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E Hi mileh moletin holu lamei e laneket e Iesu. Misak ni xil mei labe holu mu. ");
INSERT INTO tvk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ve polien xa eloheoh xil di lapol ni, moletin xil laleh ngan xil xa lamesei mei laling xil ladi suon mae e seri suse. Xil labit xosxa nini Pita tang ituxol xil melele xa ikakao imei, ma xil lilonge ihos. ");
INSERT INTO tvk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E vanut moletin xil holu lamei langgo taon xil xa mikapis e Serusalem. Xil ladel ngan xil xa lamesei e ngan xil xa ninin tesa xil lapolu e xil. E xil vus mei lalonge bos rilomun. ");
INSERT INTO tvk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Di, vatixar na pris xil del Satusi xil lanem misa ni eloheoh xil e labit lisa pangasien mi xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Misak ni, ladal xat xil e laso xil labe nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","E vongien nen tak, masxaxa tei na Hi mei misah puiteh te nim te xeih e del xil lastal. Di, xi biteni mi xil bit, ");
INSERT INTO tvk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muha, musoh e vioh te Nim Eo na Hi. Musa sen sepinien xil ngasen usil meulien hu ak mi moletin xil.” ");
INSERT INTO tvk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ma eloheoh xil lalong xat sepinien nan, e melele xa ut da milan, xil labe vioh te Nim Eo na Hi e di lapispisi mi moletin xil. E melele nen tak, vatixar na pris xil del vat sav xil lamei e lakes viton elda xil na Siu xil lamei vituei e totanen tei na Kaonsel nae. Di, lasil mereketeh xil labe nim te xeih tengan lileh eloheoh xil ak limei lisoh pe met xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","E melele xa mereketeh xil labe nim te xeih, latapus ti xil. Ma ladilomun ba labit mesen ni mi vat xil te Kaonsel labit, ");
INSERT INTO tvk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Melele xa mabe nim te xeih, mapusi xa puiteh mikoe nggeih tang, e mereketeh xil dit laketeh xole. !E melele xa masah puiteh mabe nim, matale xoteh ti moletin!” ");
INSERT INTO tvk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Melele xa vat xil na pris xil del vat na mereketeh xil te Nim Eo lalong sepinien ak, latakil ti naha xa nggul eloheoh xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Di, moletin tei bemei visal xil e biteni bit, “!Muteong! !Moletin xil xa muteling xil e nim te xeih, taxeak, di lapispisi mi moletin xil e vioh te Nim Eo na Hi!” ");
INSERT INTO tvk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ma vat na mereketeh xil del rut moletin nan xil ba laleh eloheoh xil labe von Kaonsel. Xil latapol ni ti vaxeih mi xil vengan ulixil mikan xa moletin xil linahop vin xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Laleh eloheoh xil lamei nim, e lapol ni xil lasoh pe met moletin xil te Kaonsel ak. Di, vatixar na pris xil misis xil bit, ");
INSERT INTO tvk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Matesemae ni xamim texeih tengan munapispisi ti mun usil his moletin ak. E xamim dit mupispisi ni ba tang. Ma taxeak, Serusalem polu ni pispisien namim. !E mubit muling maten nan mun vata xat xamem!” ");
INSERT INTO tvk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","E Pita del eloheoh xil labit rilomun ni mini labit, “!Xamem muteong xat Hi kestang, e nave moletin xil ti! ");
INSERT INTO tvk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Hi na avu nar xil tepol ni Iesu temea rilomun ra maten, ngan xa xamim mutehas vini melele xa mutesak ni xil lateti xati e eivave. ");
INSERT INTO tvk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E xi, Hi tepet rati ba de rin metu e misa xeihen mini tengan mei ihe Vat ni moletin xil vus e iteh meulien e xil. Mak, ma Hi di misa mesal mi mol‑Isrel xil tengan lihiles ra tesaen nae e mei iketeh ihos rilomun mi xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Xamem iaxa di masep usil holesok xil ak, e Ninin Eo mun di pisen ni be reitin. Ninin Eo ak, Hi misa ni mi moletin xil xa di lalong xati.” ");
INSERT INTO tvk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Melele xa vat xil te Kaonsel lalong sepinien ak, iexil nggat pupu ni eloheoh xil e labit lavas vin xil. ");
INSERT INTO tvk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","E Farasi tei mitamea misoh, hisen Kameliel. Xi be titsa tei te rae na Mosis e moletin xil vus di lamerere ni. Xi misis vat te Kaonsel tengan vasil rerat eloheoh xil lastal vuteili mu. ");
INSERT INTO tvk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Di, biteni mi Kaonsel bit, “Tua navan xil te hal Isrel, mulaxat xamim ve naha xa mubit mupol ni mi moletin xil ak. ");
INSERT INTO tvk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","?Munem moletin tei xa hisen Teotas? Huram vahis xa ba ngamu, xi testal e tevae tetel mol‑Rom xil. Xi tehiteni tehit xi be eilep tei, e moletin xil xa lamos en labe handred hat (400). E melele xa mol‑Rom xil labas vin ni, moletin nan xil lateletasil, ma polien nan telel. ");
INSERT INTO tvk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dutou ni ngan ak, Sudas te hal Kaleli testal e melele xa kavmen tepol ni pupuluen te moletin xil. Xi teleh vanut moletin tei latehusili e xil mun latevae tetel mol‑Rom xil. Xi mun labas vin ni, ma moletin nan xil xa lathusili lateletasil. ");
INSERT INTO tvk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mak, ma e rin na moletin xil ak, inou nabiteni mi xamim mak: !Vat nae mat ngamu! !Munapol ni ti neta nasa mi xil! !Muling xil liti nga! Xosxa naha xa xil laling xati e lapol ni mistal nggo nenemien na moletin tang, ma mei ilel. ");
INSERT INTO tvk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","E xosxa mistal nggo Hi, ma xamim musakras musikoe xol xil. Maxani, munatemanin ni xa di mubae mi Hi.” Melele xa lalong sepinien nan, xil lamaal e nenemien nan. ");
INSERT INTO tvk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Di, lakes rilomun ni eloheoh xil lamei nim, e Lasemae ni mereketeh nae xil tengan lameas pangas xil. Di, lake xat xil tengan linavit usil ti mun Iesu, e lamaen xil ba vexil mase. ");
INSERT INTO tvk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Melele xa eloheoh xil labe reling Kaonsel, labesi pupu ni xil vengan lakila xa Hi di pet rat xil melele xa maen xil langgur pangasien ve his Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","E melengien xil ngasen, e vioh te Nim Eo e e tim sae xil mun, xil dit lapispisi e lasetu ni longeongen hos usil Iesu xa be Mesaea xa Hi tehosei. ");
INSERT INTO tvk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","E melengien xil ak, melele xa moletin xil xa laneket e Iesu mei labe holu mu, ngongoren tei mistal. Rut Siu xil xa lasepin ni sepinien Krik laseputut labit melele xa ngan xil xa lasepin ni sepinien Hibru di laseti anien ba mi hoeo xil, di latasa kuhi ti mi tunau xil xa di lasepin ni sepinien Krik. ");
INSERT INTO tvk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ma eloheoh xil xa labe lu e le tei (12) lakes viton moletin xil vus xa laneket mei labe vituei. Di, labiteni mi xil labit, “Tamal ti tengan xamem eloheoh xil maling polien namem xa di masa sepinien na Hi tengan ti maseti anien xil ak. ");
INSERT INTO tvk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tua xil, bos mak mu xa xamim muhosei moletin xil lihe lu he sav (7) xa nenesien namim di e xil, xa mupus kila labe metisou e lapolu ni xeihen na Ninin Eo. Ti, muling xil iaxa ti lilaxat polien ak. ");
INSERT INTO tvk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Imak, ma xamem mukila musa xamem tengan ti musis e ti musetu ni sepinien na Hi mi xamim.” ");
INSERT INTO tvk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma vanut moletin xil lamaal pupu ve nenemien na eloheoh xil. Ma xil labosei Stivin xa neketen nan nggeih e polu ni xeihen na Ninin Eo. Labosei Pilip mun, del Prokorus, Nikanor, Timon, Parmenas, e Nikolaus. Nikolaus be ngan Kris tei te hal Antiok xa tehusil xat rae na Siu xil, e dutou sung mei miling neketen nan e Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Di, ladel xil ba lasoh pe met eloheoh xil xa laling he e xil, e lasis Hi tengan ituxol xat polien na moletin xil ak. ");
INSERT INTO tvk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma di, longeongen hos usil Iesu mikapis e rute xi vus e Serusalem, e moletin holu mun lamei laling neketen nae e Iesu. E pris xil holu mun laling neketen nae e Iesu e mei lamos e xil. ");
INSERT INTO tvk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","E melele nen ak, Hi di duxol xat Stivin e di misa xeihen mini. Misak ni xi di pol ni merekel xil e sexien xil holu xa tellep xa pol ni moletin xil di lamesep ven. ");
INSERT INTO tvk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","E rut Siu xil mei langor mi Stivin. Ngan xil ak, langgo ‘nim te pispisienna ngan xil xa lameluv.’ Rute xil lastal langgo taon te hal Saerin e taon te hal Aleksandria. E rute xil langgo provins xalu te hal Silisia e Esia. ");
INSERT INTO tvk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","E melele xa xil langor del Stivin, Ninin Eo misa metisouen mini e lasakras lavit rilomun ni ti neta vaha xat sepinien nan xil. ");
INSERT INTO tvk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Misak ni, xil langgal xuxus ni moletin tatei xil tengan mei liluvos lihit, “!Xamem matelong moletin xai tesa sepinien tesa teha xat Mosis e teha xat Hi mun!” ");
INSERT INTO tvk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sepinien nae misak ni moletin xil, elda xil, del titsa xil te rae na Mosis, nenemien nae misa ni Stivin. Ma laba ladal xati e lalihi ba misoh pe met kaonsel na Siu xil. ");
INSERT INTO tvk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Di, lakes rut moletin xil tengan limei liluvos iha xat rin na Stivin. E xil labiteni labit, “Vehakut, moletin ak di misepin misa ba xat Nim Eo nar e ba xat rae xil na Mosis mun. ");
INSERT INTO tvk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Xamem malonge xa xi di biteni xa Iesu te hal Nasaret mei ihu len Nim Eo na Hi e ihiles sexien xil xa Mosis tesa ni mi avu nar xil.” ");
INSERT INTO tvk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","E ngan xil vus xa di ladotan e kaonsel ak lale mah xat Stivin. E latemanin xa valnaon di minehin nggoni valnao masxaxa tei. ");
INSERT INTO tvk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Di, vatixar na pris xil misis Stivin bit, “?Midep? ?Sepinien xil ak be reitin?” ");
INSERT INTO tvk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stivin bit rilomun ni mi xil bit, “!Tata xil e tuxoli xil, muteong ni nou! Tetiamu, melele xa avu nar Ebraham tenava ti mu tengan vate taon te hal Heran, Hi te minehinen testal mini e kantri te hal Mesopotemia. ");
INSERT INTO tvk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","E Hi tehiteni mini tehit, ‘Umea uhe reling kantri nam itel vatimol nam xil, e ha uhe ut tei xa inou nipisen ni minuk.’ ");
INSERT INTO tvk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ma avu Ebraham tehe reling kantri xa teta en xa be na mol‑Kaltia xil, e xi tehe taon te hal Heran e ba tehe sangas visali. E dutou ni ngan xa tamen temat, Hi tesila mei tete kantri ak xa xamim, Siu xil, mudi en taxeak. ");
INSERT INTO tvk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E Hi tenasa ti tan ak mini. Reitin, tenasa ti mavulut tan mini xa vahit vahe nan xati. E Hi tehit xati xa isa ni mi vatimol nan xil xa, itutou, listal lixo en tengan mei ihe tan nae xati. Hi tepol ni hitxatien ak tetel Ebraham, neta sav xa horamue nan tehe tovuol tamu. ");
INSERT INTO tvk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Ngan ak tehe naha xa Hi tehiteni mini tehit, ‘Vatimol nam xil lihe kantri na mosav xil e liti e tan sa moletin xil teni. Lihe slev xil na moletin xil te rute ak xa ti lisak purun xil huram ihe handred hat (400). ");
INSERT INTO tvk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Itutou ni, inou nilepis rin na moletin xil ak e nisa pangasien mi xil. Ti, vatimol nam xil limea ra rute xa latehe slev xil en, e litilomun mei limot minou inggak.’ ");
INSERT INTO tvk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Di, Hi tesa sexien te vexahu mi Ebraham tengan vapisen ni xa xi del vatimol nan xil labe moletin xil na Hi. Vi rin ak, melele xa latepes Aesak e melengien nan tehe tol e he sav (8) xati, Ebraham tepol ni tehe vexahu. E Aesak mun tepol ni Siekob tehe vexahu, e Siekob tepol ni natneli lu e le tei (12) latehe vexahu. Ngan xil ak iaxa latehe avu nar xil. ");
INSERT INTO tvk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“E avu nar xil ak xa latehe nat Siekob xil iexil teat Siosep xa tehe tua nae. Ma latepos ni teha tehe slev tei e kantri te hal Isip. E Hi teti mini ");
INSERT INTO tvk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","e tesikoe xol meulien nan ra sakpurunien xil xa tehisu ni. E melele xa Siosep tesoh pe met suv toto te hal Isip, Hi tesa metisouen mini e tesak ni suv toto ak tehesi xi pupu ven e tehosei Siosep tengan ilaxat kantri nan itel holesok xil vus xa teti e nim man mun. ");
INSERT INTO tvk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Di, melele te mae kekaten tei xa eilep mei tekapis e kantri xalu te hal Isip tetel Kenan, e tesak ni moletin xil ngasen lalong pangas xil holu. E avu nar xil tetiamu mun lasakras lakamet anien tova. ");
INSERT INTO tvk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","E melele xa Siekob telongeong ni xa anien teti e kantri te hal Isip, tesil natneli xil xa labe avu nar xil lateha. Ngan ak tehe kakaoen kokot nae xa latehe Isip. ");
INSERT INTO tvk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Di, e kakaoen nae xa tehe valu nen xa latehe Isip, Siosep tehit kil xi mi tuneli xil, e suv toto te hal Isip tepus kil vatimol xil na Siosep. ");
INSERT INTO tvk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma Siosep tesa sepinien teha mi tamen xa Siekob, tetel vatimol nan xil vus xa latehe hanutap tol e lim e le tei mun (75) tengan limei liti visali e Isip. ");
INSERT INTO tvk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Misak ni, avu Siekob tehe kantri te hal Isip e teta en teha vuma ... temat, xi tetel vatit avu nar xil vus. ");
INSERT INTO tvk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","E tetutou sung, lateleh rilomun ni tiei nae xil latehe taon te hal Sekem, e latetihin xil e von tehinen xa Ebraham texal rati ra vatimol xil na Hamor ni mani tei. ");
INSERT INTO tvk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Huram holu mei tetavi, e Siu xil xa lateti Isip mei latehe holu. E Hi tepusi xa be sangas ni melele xa xi teling xati tengan isak ni hitxatien nan xa tepol ni tetel Ebraham mei vastal vahe reitin. ");
INSERT INTO tvk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","E melele nen ak, suv toto teimun xa takil ti Siosep e naha xa tepol ni temei telaxat kantri te hal Isip. ");
INSERT INTO tvk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Suv toto ak tepol ni tesa mi Siu xil xa latexo avu nar xil e tesak purun xil. Xi texeih xat xil tengan listokovein tuvava hu nae xil liti nga hale tengan lilel. ");
INSERT INTO tvk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mosis, latepesi e melele nen ak vari. E xi tehe tuvava tehos tei pe met Hi. E tamen xal ninen lutelaxati e tim aveti tol (3). ");
INSERT INTO tvk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","E melele xa lutelingi tete hale, atuli na suv toto te hal Isip tekameti e telaxati texoni natneli xati. ");
INSERT INTO tvk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Misak ni, latepispisi mini ni kilakilen xil vus te hal Isip. E xi mei tesepin e tepol tetel xeihen. ");
INSERT INTO tvk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Melele xa huram na Mosis tetuxoh hanutap lu (40), tepol ni nenemien nan tengan vakil ti moletin nan xil xati, mol‑Isrel xil, ma teha tesao ni xil. ");
INSERT INTO tvk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","E melele xa tepus ngan Isip tei xa di tehas purun ngan Isrel tei, Mosis teha tetutou ni. Ma xi tesa xoles sakpurunien teha mi ngan Isip ak, e tehasi temat. ");
INSERT INTO tvk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xi tenemi tehit mol‑Isrel xil xa latehe vatimol nan xati lile kila xa Hi di miteh meulien e xil nggo hen, e xil latnale kil ti. ");
INSERT INTO tvk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“E melengien sav nen, Mosis tepus ngan Isrel lu xa di lutevae mi xalu mun tang. Ma xi teha tengan vamal ni rin nalu tehit, ‘!Ei, xamil, muliteong ni nou! Xamil vus mube ngan Isrel tang. ?Ma di mubae mi xamil veneh?’ ");
INSERT INTO tvk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“E ngan xa di tehas purun tuneli tetivin rat Mosis tehe rin e tesisi texeih tehit, ‘?Visi vari milinguk tengan mei ove vat namem e ti olepis rin namem? ");
INSERT INTO tvk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","?Obit ovas inou mun vaxoni ngan taxa otehas vin ngan Isip nanganoh?’ ");
INSERT INTO tvk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Melele xa Mosis telonge temak, ulin tekan holu, ma telesae tehe reling kantri te hal Isip, e tete sotin e teta tete tan na mol‑Midia xil. E rute ak, tehur atou tei xa teling natneli lu. ");
INSERT INTO tvk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mosis tete rute ak huram hanutap lu (40). Di, melele xa Mosis tehe rute tei xa be uruvuol, sangas visal Vathu Senae, masxaxa tei mei testal mini texoni upang xa tepili e holiei tei. ");
INSERT INTO tvk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Melele xa Mosis tepusi, temesep pupu e telis tehe sangas visali tengan vale kuhi. E melele xa temei sangas, telong rae na Hi Suv xa tehiteni mini tehit, ");
INSERT INTO tvk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Inou nabe Hi na avu nam xil: na Ebraham, na Aesak, e na Siekob.’ Melele xa telonge temak, Mosis temalili pupu e ulin tekan tengan vaketeh. ");
INSERT INTO tvk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","E Hi Suv tehiteni mini tehit, ‘Usil rat sandel nam vengan xa tan xa di osoh en be ut eo. ");
INSERT INTO tvk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inou natepus kil longpangasien xil xa moletin navan xil xa di langguri e hal Isip, e natelong tangen nae. Misak ni, namei etan tengan niteh meulien e xil. Amei, inou nisilak utilomun uhe Isip.’ ");
INSERT INTO tvk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ngan ak tehe Mosis nen tak xa mol‑Isrel xil latesin ni melele xa latesisi latehit, ‘?Visi vari milinguk tengan mei ove vat namem e ti olepis rin namem?’ E masxaxa xa testal mini texo upang xa pili e holiei tei tehiteni tehit Hi di tesil Mosis ha ihe vat na mol‑Isrel xil tengan ilaxat xil e isak ni ha vexil imase e limeluv liha. ");
INSERT INTO tvk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Melele xa xi teleh rerat mol‑Isrel xil ra hal Isip, Mosis tepol ni merekel xil e sexien xil xa tellep e Isip, e Tas Tepili, e, e uruvuol xa lateti en huram hanutap lu (40). ");
INSERT INTO tvk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosis nen tak tehiteni mi mol‑Isrel xil tehit, ‘Hi isa provet tei xa ixoni nou xa istal ixo xamim tang.’ ");
INSERT INTO tvk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosis ak be ngan taxa teti tetel mol‑Isrel xil e melele xa lateti e uruvuol. Xi teti tetel avu nar xil tetiamu, melele xa masxaxa tei tesepin tetela e Vathu Senae. E xi tehur sepinien te meulien texo Hi e tesa ni mi xir. ");
INSERT INTO tvk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“E avu nar xil latehit linalong xat ti sepinien na Mosis. Xil latesin ni e latepol ni nenemien nae latehit litilomun lihe Isip. ");
INSERT INTO tvk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ma latehiteni mi Eron latehit, ‘Pol ni hi sav xil ihe namem tengan ti litiamu ni xamem, vengan xa matakil ti naha xa nggul Mosis xai xa teleh rerat xir ra hal Isip.’ ");
INSERT INTO tvk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma e melele nen ak, latepol ni nanao tei xa tehur nini buluk. Di, latemot mini e latehas vongoro tei tehe sanien eo nae mini. Di, latepol ni anien tei xa eilep e lateanien ve nanao xa latepol xati ni hexil tang. ");
INSERT INTO tvk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ma Hi tekavitou ni xil e temaen xil latemot mi hitu xil. Ngan ak nggoni ngan taxa Hi tehit usili e tisen tei na provet xil tehit, ‘Mol‑Isrel xil, melele xa muteti e uruvuol huram hanutap lu (40), mutnavas ti vongoro tengan vahe sanien eo namim minou. ");
INSERT INTO tvk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","E mutetamea sung, mutepo xat nim tavolin na hi Molek, e muteleh xat nanao na hi Revan xa tehur nini hitu xil. Xamim mutepol ni nanao xalu ak tengan ti mumot mi xalu. Misak ni, inou nisil rerat xamim muha muhe slev xil e rute xil xa lihe sotin pupu ha ili hal Babilon.’” ");
INSERT INTO tvk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stivin biteni mun mi xil bit, “Avu nar xil latemot mi Hi e nim tavolin melele xa lateti tamu e uruvuol. Nim tavolin ak, latepol ni tehusil xat naha xa Hi tehiteni e tepisen ni mi Mosis. ");
INSERT INTO tvk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tetutou ni sung, moletin xil ak latesa ni teha mi avu nar xil, e xil latepo xat nim tavolin ak melele xa latehusil Sosua ba latehur tan na vanut moletin xil xa Hi tehol rerat xil ra rute ak. E nim tavolin ak tetak ba tetuxoh melele xa Deved mei tehe suv toto. ");
INSERT INTO tvk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hi tehesi xi ve Deved xa tesisi tengan vamaen ni vapet kuh nim hos tova vahe na Hi, xi xa be Hi na Siekob. E Hi tamaen ni ti. ");
INSERT INTO tvk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","E tehe Solomon sung iaxa tehil nim na Hi. ");
INSERT INTO tvk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","E Hi te ut nesao misakras vate nim xa moletin tang pol ni. Ngan ak nggoni ngan taxa Hi tehit lelen ni texo provet Aesea tehit, ");
INSERT INTO tvk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Inou nade von xeihen navan e ut nesao e di nalaxat kuh holesok xil en e ut etan be rute xa di naling leok di en. ?Hisit nim eah iaxa mukila muhili ihe mavan? Musakras muvil nim tova xa vapin tengan mei nangel en. ");
INSERT INTO tvk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Holesok xil ngasen xa di e ut nesao e ut etan, inou tang natepol ni.’” ");
INSERT INTO tvk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Di, Stivin misepin nggeih mi vat xil na Siu xil bit, “!Vatumim nggeih tova tang, e vurangemim bon ni sepinien na Hi! !Vehakut, holesok xil xa di mupol ni nggoni ngan xil xa latakil ti Hi! !Xamim munggoni avu namim xil tang, xa vehakut di latesin holesok xil xa Ninin Eo tepol ni! ");
INSERT INTO tvk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vengan xa avu namim xil iaxa latesak purun provet xil vus. Tetiamu, xil latehas vin ngan xil xa latehit lelen ni usil meien na Moletin te Momalen na Hi. E taxeak, be xamim vari tang iaxa musa rati be he ngan xil xa latehas vini. Ven rin ak, ren di xat hemim. ");
INSERT INTO tvk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Be xamim iaxa mutehur xat rae xil na Hi xa masxaxa xil latesa ni temei mi avu namim xil. !E neta sav xa mak, xamim mutalong xati ti!” ");
INSERT INTO tvk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Melele xa vat xil te kaonsel na Siu xil lalong sepinien na Stivin, iexil mikat pupu e mete pili xati. ");
INSERT INTO tvk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","E xeihen na Ninin Eo mei polu e Stivin, e xi miketeh momal be ut nesao. Melele xa miketeh nesao, pus minehinen te xeihen na Hi e pus Iesu di misoh de rin metu. ");
INSERT INTO tvk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma xi biteni mi xil bit, “?Mupusi? !Napus tilang hat di masel e Nat Hi di misoh de ri metu na Hi!” ");
INSERT INTO tvk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Melele xa vat xil te kaonsel lalong sepinien ak na Stivin, laki xol vurange, lakei nggeih, e xil vus laloh laba latal xati. ");
INSERT INTO tvk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Di, lakuvun rati be hale ra taon, e ngan xil xa lateso sepinien teha xat rin nan e kaonsel lamei tengan lihov kokot ni. Ma laling kot xil nae teti e he tiram maxoe tei, hisen Sol. Di, xil del moletin sav xil mun langgove. ");
INSERT INTO tvk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","E melele xa di langgov Stivin, xi mikei be nesao bit, “!Suv Iesu, uhur pilei ninin navan ihat visaluk!” ");
INSERT INTO tvk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Di, mitingeiril etan e mikei nggeih bit, “!O Suv li, onaketeh ti nasa naha xat moletin xil ak ve tesaen xil xa di lapol ni xiak!” Stivin biteni mak, di, mat. ");
INSERT INTO tvk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Melele xa Stivin mat, rut moletin xa neketen nae nggeih e Hi laba lapo tiei nan e ba ladihin ni. Xil ladang nggeih ve maten nan. E moletin tei da xa minem bit momal xa latehas vin Stivin temak, hisen Sol. E melele nen ak vari, sakpurunien tei xa eilep mistal nggo he Siu xil ba xat ngan xil te sias te hal Serusalem. Misak ni, holu e ngan xil xa laling neketen nae e Iesu lalesae labe reling taon te hal Serusalem e labe rute sav xil e provins xalu te hal Sudea e Sameria. E eloheoh xil na Iesu latnalesae ti, xil ladi kat e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","E Sol misa xi tengan ihu lelen sias na Iesu Kristo, ma ba misak purun ngan xil xa laling neketen nae e Iesu. Xi be vangit nim xil vus, tei bus teimun. E di dal xat tiramue e atou xil vus xa laling neketen nae e Iesu. E melele xa dal xat xil, ba miso xil labe nim te xeih. ");
INSERT INTO tvk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Melele xa moletin xil xa laling neketen nae e Iesu latelesae ra hal Serusalem, xil labe ut xil ngasen. E, e rute xil vus xa laba en, di labithiten longeongen hos usil Iesu mi moletin xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tei e xil xa laling neketen nae e Iesu tehe taon tei xa eilep e provins te hal Sameria, his moletin ak be Pilip. E ba bithiteni mi moletin xil te rute ak xa Iesu iaxa be Mesaea xa Hi tehit xati tehit isa ni imei. ");
INSERT INTO tvk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","E melele xa vanut moletin xil te rute ak lalong sepinien na Pilip e lapus holesok xil xa tellep xa di tepol ni, xil vus lateong kuhi ni holesok xil vus xa biteni. ");
INSERT INTO tvk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Xil lapusi xa tehol rerat ninin tesa xil ra moletin xil holu xa latehe reling moletin xil holu tetel tangen xil xa nggeih. E moletin xil holu xa rut tenbexil temat mu latsakras lakakao, xil vus mei labos rilomun. ");
INSERT INTO tvk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Misak ni, moletin xil vus te rute ak labesi pupu ni xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","E taon ak, moletin tei da en xa di tesak ni mol‑Sameria xil latemesep ve vongou xil xa di tepol ni, hisen Saemon. E pe met moletin xil, x di po xi bit be eilep tei xa nggur xeihen. ");
INSERT INTO tvk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma moletin xil vus te rute ak, ngan xil xa latellep ba duxoh movotei xil mun, xil vus latenemi latehit, “Moletin ak be eloheoh tei na Hi xa lakesi ni ‘Xeihen xa Mahulong.’” ");
INSERT INTO tvk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Xil di latehusili nousav vengan xa vongou xil xa di tepol ni tesak ni xil latmesep ven. ");
INSERT INTO tvk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","E melele xa moletin xil lalong longeongen hos xa Pilip di biteni usil sexien xa Hi mei ihe suv toto te meulien nae e usil Iesu xa be Mesaea xa xi tesila, moletin xil holu lake reitin en. E melele xa tiramue xil e atou xil ak laling neketen nae e Hi, xil mei lamaen Pilip tengan vabaptaes ni xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saemon mun mike reitin e sepinien na Pilip e maen ni baptaes ni. Di, Saemon nggusil xat Pilip e mesep pupu ve merekel xil e sexien sav xil mun xa tellep xa Pilip di pol ni. ");
INSERT INTO tvk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Longeongen usil naha xa di mistal e provins te hal Sameria duxoh eloheoh xil na Iesu e Serusalem. Xil lalonge xa mol‑Sameria xil di lake reitin e sepinien na Hi. Misak ni, lasil Pita xal Sion lube visal xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Melele xa ba lustal mi mol‑Sameria xil, lusis ve xil xa Ninin Eo mei ise xat xil ");
INSERT INTO tvk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","vengan xa Ninin Eo tenamei ti mu e tova xil. Pilip tebaptaes ni xil e his Iesu kestang. ");
INSERT INTO tvk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ma melele xa Pita xal Sion luling he xalu e xil, Ninin Eo mei polu e xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saemon pusi xa melele xa eloheoh xalu luling he xalu e moletin xil, Hi di misa Ninin Eo mi xil. Misak ni, Saemon misa mani mi xalu e biteni bit, ");
INSERT INTO tvk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nixal xamil xosxa mulisa xeihen xai minou li tengan inou mun nikila nisa Ninin Eo mi moletin eah xa niling heok en.” ");
INSERT INTO tvk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","E Pita misep pangasi bit, “!Xouk uhe Von Upang itel xat mani nam! !Osakras oxal rat sanien na Hi ni mani! ");
INSERT INTO tvk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Xouk otapin ti tengan omos e polien namem vengan meulien nam tamal ti pe met Hi. ");
INSERT INTO tvk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Itiamu, uhiles nenemien tesa nam, e usis mi Hi Suv tengan nasa pangasien ti minuk ve nenemien tesa xa obit opol ni. E vahit xi vaketeh vahos rilomun mi xouk. ");
INSERT INTO tvk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Taxeak, uhiles meulien nam vengan napusi xa di onem misa ni xamem ve xeihen xa Hi di misa ni mi xamem. E napusi mun xa tesaen di bar xolok.” ");
INSERT INTO tvk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Melele xa Saemon milong sepinien ak, dakes Pita xal Sion bit, “Lusis mi Hi Suv ve rin navan li tengan holesok xil xa di musep usili nastal ti minou.” ");
INSERT INTO tvk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita xal Sion lutehit usili mi mol‑Sameria xil holesok xil xa Suv Iesu tepol ni e tehiteni melele xa luteti tamu visali. Melele xa lupol ni bus, ludilomun lube Serusalem. E, e suse nalu, lusao ni metimal xil holu te hal Sameria e lubithiten longeongen hos usil Iesu Kristo mi mol‑Sameria xil. ");
INSERT INTO tvk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Vatei, masxaxa tei na Hi mei mistal mi Pilip e biteni mini bit, “Uvue xatuk e ukakao uhusil suse xa be saot. Uhusil suse xa nggo taon te hal Serusalem e ba be taon te hal Kasa.” Suse ak di nggur xoteh uruvuol. ");
INSERT INTO tvk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ma Pilip bue xat xi e ba. E melele nen ak, eilep tei te kantri te hal Itiopia di nggusil suse ak. Xi be eilep tei xa di milaxat mani xil vus na suv toto te hal Itiopia xa be atou, hisen Kandis. Eilep ak tehe Serusalem tengan vamot mi Hi, ");
INSERT INTO tvk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","e di, nggusil suse nan tengan vatilomun vahe ut san. E melele xa ba, di miloh e kat tei xa hos milihi. E melele xa dotan de kat, di buli rut sepinien e Vanuvei Eo na Hi xa provet Aesea tetisi. ");
INSERT INTO tvk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Ninin Eo biteni mi Pilip bit, “Uha, ha uhe sangas visal moletin xa di miloh e kat iaxor.” ");
INSERT INTO tvk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Misak ni, Pilip miloh be sangas visal kat ak e milonge xa eilep ak di buli sepinien xa provet Aesea tetisi. Ma misisi bit, “?Xouk okil koute te naha xa di obuli iaxai?” ");
INSERT INTO tvk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eilep ak bit rilomun ni mini bit, “?Xosxa moletin ti navit kila minou, ma nikil koute teni itep?” Ma eilep ak misis Pilip tengan vapeou vaha vatotan vatela e kat nan. ");
INSERT INTO tvk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Melele xa Pilip ba dotan dela, pusi xa eilep ak di buli rut sepinien te Vanuvei Eo na Hi xa biteni bit, “Moletin ak, texoni sulut sipsip tei xa ladela tengan ha lavasi vamat, xi tenavit pas ti sepinien. Io, xi tenatangal ti nggoni sipsip tei e melele xa di lakot rerat hilin. ");
INSERT INTO tvk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Melele xa latelepis rin nan, latnapol ni ti tenamal mini. Lasakras lanem usil horamue nan xil vengan xa latehur xoteh meulien nan e ut etan.” ");
INSERT INTO tvk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eilep ak misis Pilip bit, “Hiteni minou li. ?Provet ak di misep usil visi vari xiak? ?Di misep usil xi mun tang, mu moletin tova?” ");
INSERT INTO tvk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma Pilip bit kil koute te sepinien ak mini e misetu mun ni longeongen hos usil Iesu Kristo mini. Melele xa biteni mak, eilep ak mike reitin en. ");
INSERT INTO tvk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E melele xa di lunggusil suse luba, lumei e rute tei xa oei di en. Ma eilep ak biteni mi Pilip bit, “!Pus ti! Oei xi tak. Xosxa onemi obit bos, ma ubaptaes ni nou li en.” ");
INSERT INTO tvk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","E Pilip bit rilomun ni mini bit, “Nakila nibaptaes ni xouk en xosxa oke reitin en nggo meulien tevi nam.” Ma xi biteni bit, “Inou nake reitin xa Iesu Kristo be Nat Hi.” ");
INSERT INTO tvk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma, eilep ak biteni mi moletin nan tengan vapol ni kat nan vangel. Di, xal Pilip, lukakao lube oei, e Pilip baptaes ni en. ");
INSERT INTO tvk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","E melele xa xalu di lukakao lumea reling oei, vatei takes, Ninin Eo na Hi mei nggur rat Pilip ra rute ak. E eilep ak tapus ti mun. E neta sav xa mak, eilep nggusil suse nan ba del memesien mi Hi. ");
INSERT INTO tvk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","E Pilip mitemanin melele xa pusi xa da ngamu e taon tei xa lakesi ni Asotas. E kakaoen nan, Pilip di bithiten longeongen hos e taon xil vus xa di misao ni e suse nan ba vuma … duxoh taon te hal Sesaria. ");
INSERT INTO tvk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","E melele nen tak, Sol di tamu misa sepinien xil te xeih bit ihas vin ngan xil vus xa di laling neketen nae e Iesu. Misak ni, be visal vatixar na pris xil ");
INSERT INTO tvk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","e misisi tengan itis uvei xil xa isep kil polien nan mi vat xil te nim te pispisienxil na Siu xil xa ladi e taon te hal Damaskas. Ma vatixar misa uvei tei mini xa maen ni. Uvei ak biteni xa melele xa Sol ikamet tiramue mu atou tei xa di mineket e Iesu, ikila ital xati e ilihi imei mun e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Melele xa Sol di bemei sangas visal taon te hal Damaskas, vatei takes, miehen tei xa minehin pupu nggo ut nesao e mei mileluv xole. ");
INSERT INTO tvk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol mot be tan. E melele xa de tan, milong rae tei xa biteni mini bit, “!Sol, Sol! ?Veneh ma di osak purun nou del moletin navan xil mak?” ");
INSERT INTO tvk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","E Sol biteni mini bit, “?Suv, xouk visi?” E rae ak biteni mini bit, “Inou Iesu, ngan xa di osak purun ni. ");
INSERT INTO tvk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","E taxeak, umea uhe taon xai te hal Damaskas. E rute ak lihiteni minuk naha iaxa upol ni sung.” ");
INSERT INTO tvk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Moletin xil xa di lakakao del xat Sol, lalong rae ak, e xil latapus ti moletin tova. Ma ulixil mikan holu e ladit votei. ");
INSERT INTO tvk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Melele xa Sol mitamea ra tan e miketeh ba, mikila sung xa meten bar. Misak ni, tuneli xil ladal xat hen e ladeli be Damaskas. ");
INSERT INTO tvk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sol dat mak e taon ak melengien tol. Meten bar e bit naxanien ti e namu ti neta. ");
INSERT INTO tvk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","E taon te hal Damaskas, moletin tei xa miling neketen nan e Iesu da en, hisen Ananaeas. E Suv Iesu mistal mini nggo metuveen tei e biteni mini bit, “!Ananaeas!” E xi bit rilomun ni bit, “Io Suv, inou iaxale.” ");
INSERT INTO tvk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma Suv biteni mini bit, “Uvue xatuk e uha uhusil suse xa lakesi ni ‘Suse xa Momal.’ E tim sa Sudas, usis ves moletin tei te hal Tarsis, hisen Sol. E melele nen tak, xi di misis. ");
INSERT INTO tvk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","E metuveen tei, tepus moletin tei xa hisen Ananaeas xa bemei e miling hen en tengan vasak ni vaketeh rilomun.” ");
INSERT INTO tvk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaeas bit rilomun ni bit, “Suv, moletin xil holu di latumul usil moletin ak ve holesok holu xa misa xa di pol ni mi moletin nam xil e hal Serusalem. ");
INSERT INTO tvk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Labiteni xa bemei inggak del xeihen na vatixar na pris xil tengan mei ital xat moletin xil vus xa di laling neketen nae e xouk.” ");
INSERT INTO tvk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","E Suv Iesu biteni mini bit, “Ha pusi, vengan inou nabosei xi ngamu tengan ipol minou. Xi ti isep usil hisok mi ngan xil xa latave Siu ti, mi suv toto xil, e mi mol‑Isrel xil mun. ");
INSERT INTO tvk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","E inou vari iaxa ti nipisen ni mini hisit longpangasien xil xa ihuri ve polien xa ipol ni e hisok e melele xil xa ti imei.” ");
INSERT INTO tvk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ma Ananaeas ba mikamet tim xa Sol da en e be tim. Melele xa pus Sol, be visali e miling hen en bit, “Tua Sol, Suv Iesu xa testal minuk e suse melele xa di omei inggak, xi vari iaxa misil nou. Xi misil nou namei tengan nisis ve rin nam tengan uketeh rilomun e mei upolu ni Ninin Eo.” ");
INSERT INTO tvk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Vatei takes, neta tei xa nggoni kahbe meseo mot reling meten, e Sol mikila vaketeh rilomun. Di, melele xa mitamea, maen Ananaeas vabaptaes ni. ");
INSERT INTO tvk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","E melele xa ngganien bus, tenbe Sol mei nggeih rilomun. Sol da melengien vahis mun e taon te hal Damaskas del moletin xil xa laling neketen nae e Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Melele xa Sol miketeh rilomun, vari tang, mika mal be nim te pispisien xil na Siu xil e di bithiteni mi moletin xil xa Iesu be Nat Hi reitin. ");
INSERT INTO tvk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ngan xil vus xa lalong sepinien nan latemanin, e lasis xil mun tang labit, “?Ei, tave xi ti iaxa di tehas vin ngan xil xa di laling neketen nae e Iesu e hal Serusalem? Malonge xa bemei inggak tengan vatal xat ngan xil xa langgusil Iesu e valeh xil lava mun visal vat xil na pris xil. ?Midep vari?” ");
INSERT INTO tvk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","E Sol mei nggeih pilei sung e sexien xa di bit kila xa Iesu vari iaxa be Mesaea xa Hi tehosei tengan vamei. E Siu xil xa ladi e hal Damaskas lasakras lavit rilomun ni sepinien tova vaha xat sepinien na Sol. ");
INSERT INTO tvk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Melengien hao mei mitavi, e rut Siu xil lamei vituei e lapol ni lingxatien tei tengan lihas vin Sol. ");
INSERT INTO tvk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma e melengien xil vus, makoe be duxoh vongien, xil di laketeh xol puiteh te vioh xa mahulong xa mikapis xol taon ak tengan livulu xati e lihas vini. E Sol milongeong ni lingxatien nae. ");
INSERT INTO tvk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Misak ni, e vongien tei, ngan xil xa laling neketen nae e Iesu nggo pispisien na Sol, lasoson ni de ateli tei xa eilep. Di, lasar xat ao da en e laso kital ni nggo mesekital tei xa de nesao e seri vioh te taon ak. Di, lasae ni be tan. Ma, nggo sexien ak, Sol milesae be reling taon te hal Damaskas. ");
INSERT INTO tvk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol dilomun be Serusalem e misak pisi tengan mei vamos e ngan xil xa laling neketen nae e Iesu. E xil vus ulixil mikan ni e latake reitin ti e melele xa Sol biteni bit be tei e xil. ");
INSERT INTO tvk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Di, tei e xil xa bemei e dutou ni, hisen Banabas. Xi mei del Sol lube visal eloheoh xil na Iesu, e dap lelen kuhi sung mi xil xa Sol tepus Iesu e suse e tetep iaxa Suv tesepin mini. Xi biteni mun mi xil xa Sol ulin takan ti melele xa di tehit usil Iesu e taon te hal Damaskas. ");
INSERT INTO tvk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma lamaen Sol mei mos e xil. E xi ba mikapis e ut xil ngasen e hal Serusalem e di misepin usil Suv Iesu del xeihen. ");
INSERT INTO tvk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Di misep tetavoe del Siu xil xa lasepin ni sepinien Krik. E melele xa lapus kila xa lasakras laleli sepinien nan xil, lalang ves suse tova tengan lakila lavas vini vaxo en. ");
INSERT INTO tvk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","E melele xa ngan xil xa laneket lalongeong ni, xil ladel Sol ba be taon te hal Sesaria. E rute ak, lalingi be sip tei tengan vahe taon xati nan te hal Tarsis tengan vasikoe xol meulien nan. ");
INSERT INTO tvk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dutou ni ngan ak, ngan xil te Sias na Iesu xa ladi e provins xil te hal Sudea, Kaleli e Sameria, xil latehisu ni melele te tomat. Ma xil mei langgeih pilei sung e neketen nae. Lamerere kuhi mi Suv Iesu, e Ninin Eo dutou ni xil e misa xeihen mi xil. Ve rin ak, moletin xil holu mei latemos e xil. ");
INSERT INTO tvk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Eloheoh Pita mikakao ba misao ni ngan xil xa lateling neketen nae e Iesu xa lateti e rute savsav xil. E vatei, ba misao ni moletin xil na Hi xa ladi e taon te hal Lita. ");
INSERT INTO tvk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","E rute ak, Pita pus moletin tei xa rin tei mat, hisen Aeneas. Huram tol e he sav (8) xi takakao ti, e pat dat rong mak tang. ");
INSERT INTO tvk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Melele xa Pita pusi, biteni mini bit, “Aeneas, Iesu Kristo pol ni tenbem bos ngamu. !Utamea e uvulun suon mam!” Vatei takes, Aeneas mitamea e misoh. ");
INSERT INTO tvk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","E melele xa moletin xil vus te taon xalu te hal Lita e Saron lapusi midep iaxa tenben mei bos rilomun, xil labiles meulien nae e mei laling neketen nae e Suv Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","E taon te hal Siopa, atou tei da en xa teling neketen nan e Iesu, hisen Tapita. E moletin xil lakesi ni Dorkas, hisen sav e sepinien te hal Krik. Vehakut, atou ak di misa xi tengan vapol ni polien hos xil tengan vatutou ni hoeo xil. ");
INSERT INTO tvk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","E melele xa Pita da tamu e taon te hal Lita, atou ak nggur mesien tei e mat. Timue nan xil lakas moten tiei nan mei memese tengan ha litihin ni. Di, lalingi pat e von toen nesao e nim man. ");
INSERT INTO tvk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","E melele xa moletin xil e hal Siopa lalongeong ni xa Pita dat sangas e taon te hal Lita, lasil tiramue lu lube visali del xat sepinien ak lubit, “!Utemanon li, umei visal xamem!” ");
INSERT INTO tvk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Melele xa lubit mesen rin nalu mi Pita, xi bue xat xi e be xatel latoba. Melele xa latduxoh tim sa Dorkas, timue nan xil ladel Pita be von toen nesao e nim ak. E rute ak, tiei na Dorkas de vet tei e tunau xil di lasoh lakapis xole. Melele xa lapus Pita, ladang e lapisen ni mini eising xil xa Dorkas tetili melele xa temeul tamu teta. ");
INSERT INTO tvk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Di, Pita misis xil tengan lihe relingi lihe hale. Melele xa labe, mitingeiril e misis mi Hi. Di, pus tiei na Dorkas e biteni bit, “!Tapita, tamea!” Vatei takes, met Dorkas milale. E melele xa pus Pita, mitamea e dotan de vet man. ");
INSERT INTO tvk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Di, Pita dal xat hen e dal rati misoh. Melele xa misoh, Pita mikes viton moletin xil na Hi e tunau xil mun lamei, e Pita pisen ni mi xil xa Dorkas meul tang da. ");
INSERT INTO tvk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Longeongen usili ba mikapis e ut xil ngasen sangas visal taon te hal Siopa. Ma moletin holu mei laling neketen nae e Suv Iesu. ");
INSERT INTO tvk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","E Pita de visal xil melengien vahis mun e hal Siopa e nim ma moletin tei xa di pol kuh hilbe buluk tengan ikila ipol ni holesok hos xil ni, hisen Saemon. ");
INSERT INTO tvk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","E taon te hal Sesaria, ngan Rom tei da en xa hisen Konilias. Xi be vat tei na vanut moletin te vaeen xil xa lakes xil ni ‘mol‑Itali xil.’ ");
INSERT INTO tvk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Xi be moletin tei xa merere pupu ni Hi na Siu xil e di mot mini, xi del ngenen xil. Vehakut, di misa tutouen mi hoeo xil e di misis mi Hi. ");
INSERT INTO tvk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Vatei, e 3 klok mahis, Konilia