﻿USE sofia;
DROP TABLE IF EXISTS sofia.turytc_vpl;
CREATE TABLE turytc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES turytc_vpl WRITE;
INSERT INTO turytc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Başlangıçta Tanrı gökleri ve yeri yarattı. ");
INSERT INTO turytc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Yer biçimsiz ve boştu. Derinliğin yüzeyinde karanlık vardı. Tanrı'nın Ruhu suların yüzeyinde dolaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tanrı, “Işık olsun” dedi ve ışık oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Tanrı ışığın iyi olduğunu gördü. Tanrı ışığı karanlıktan ayırdı. ");
INSERT INTO turytc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Işığa “gündüz”, karanlığa “gece” adını verdi. Akşam oldu ve sabah oldu, ilk gün. ");
INSERT INTO turytc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Tanrı, “Suların ortasında boşluk olsun ve suları sulardan ayırsın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tanrı boşluğu yarattı ve boşluğun altındaki suları, boşluğun üstündeki sulardan ayırdı; ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tanrı boşluğa “gökyüzü” adını verdi. Akşam oldu ve sabah oldu, ikinci gün. ");
INSERT INTO turytc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Tanrı, “Gökyüzünün altındaki sular bir yere toplansın, kuru toprak görünsün” dedi ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tanrı kuru toprağa “kara”, toplanan sulara “denizler” adını verdi. Tanrı bunun iyi olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tanrı, “Yer ot, tohum veren bitki ve türlerine göre tohumu meyvesinde bulunan meyve ağaçları versin” dedi ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Yer ot, türlerine göre tohum veren bitki ve tohumu meyvesinden bulunan meyve ağaçları verdi; ve Tanrı bunun iyi olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Akşam oldu ve sabah oldu, üçüncü gün. ");
INSERT INTO turytc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tanrı, “Gökyüzündeki boşlukta ışıklar olsun, gündüzü geceden ayırsın, zamanları, günleri ve yılları belirleyen işaretler olsun, ");
INSERT INTO turytc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","yeryüzünü aydınlatsın” dedi ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tanrı iki büyük ışığı yarattı: Büyüğü gündüze, küçüğü geceye hükmedecekti. Tanrı ayrıca yıldızları da yarattı. ");
INSERT INTO turytc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Tanrı, yeryüzüne ışık vermesi, gündüze ve geceye hükmetmesi, ışığı karanlıktan ayırması için onları gökyüzündeki boşluğa yerleştirdi. Tanrı bunun iyi olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Akşam oldu ve sabah oldu, dördüncü gün. ");
INSERT INTO turytc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tanrı, “Sular canlı yaratıklarla dolup taşsın ve yerin üzerinde, gökyüzündeki boşlukta kuşlar uçsun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tanrı büyük deniz canavarlarını ve suların içinde kaynaşan canlıları ve kanatlı her kuşu kendi türüne göre yarattı. Tanrı bunun iyi olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tanrı, “Verimli olun, çoğalın, denizlerdeki suları doldurun ve karada kuşlar çoğalsın” diyerek onları kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Akşam oldu ve sabah oldu, beşinci gün. ");
INSERT INTO turytc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tanrı, “Yeryüzü türlerine göre canlılar, evcil ve yabanıl hayvanlar, sürüngenler ve türlerine göre canlılar üretsin” dedi ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tanrı türüne göre çeşit çeşit yabanıl hayvanı, evcil hayvanı, sürüngenleri yaptı. Tanrı bunun iyi olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tanrı, “Bizim suretimizde, kendimize benzer insan yapalım” dedi. “Denizin balıklarına, gökyüzünün kuşlarına, evcil hayvanlara, tüm yeryüzüne ve yerde sürünen her şeye hükmetsinler.” ");
INSERT INTO turytc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tanrı insanı kendi suretinde yarattı. Onu Tanrı suretinde yarattı; onları erkek ve kadın olarak yarattı. ");
INSERT INTO turytc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tanrı onları kutsadı. Tanrı onlara, “Verimli olun, çoğalın, yeryüzünü doldurun ve onu boyun eğdirin” dedi. “Denizin balıklarına, göklerin kuşlarına ve yerde hareket eden her canlıya hükmedin.” ");
INSERT INTO turytc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tanrı şöyle dedi: “İşte, yeryüzünde bulunup tohum veren her bitkiyi ve tohumu meyvesinde bulunan her meyve ağacını size verdim. Bunlar sizin yiyeceğiniz olacak. ");
INSERT INTO turytc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Yeryüzündeki hayvanlara, gökteki kuşlara, sürüngenlere, içinde yaşam olan her şeye yeşil otları yiyecek olarak verdim.” ve öyle oldu. ");
INSERT INTO turytc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tanrı yapmış olduğu her şeyi gördü ve işte, çok iyiydi. Akşam oldu ve sabah oldu, altıncı gün. ");
INSERT INTO turytc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gökler ve yer, onların bütün uçsuz bucaksız dizilişi tamamlandı. ");
INSERT INTO turytc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Yedinci güne gelindiğinde Tanrı yapmakta olduğu bütün işi bitirdi; ve yaptığı işten yedinci günde dinlendi. ");
INSERT INTO turytc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tanrı yedinci günü kutsadı ve onu kutsal kıldı. Çünkü Tanrı yaptığı bütün yaratılış işini tamamlayıp o gün dinlendi. ");
INSERT INTO turytc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bu, Yahve Tanrı’nın yeri ve gökleri yaptığı günde, göklerin ve yerin yaratılış hikayesidir. ");
INSERT INTO turytc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Henüz yerin toprağında yabanıl bir bitki, bir ot bile yoktu. Çünkü Yahve Tanrı yeryüzüne henüz yağmur yağdırmamıştı. Toprağı işleyecek adam da yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yerden yükselen buhar yerin bütün yüzeyini suluyordu. ");
INSERT INTO turytc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahve Tanrı yerin toprağından Adem’e biçim verdi ve onun burnuna yaşam soluğunu üfledi; ve Adem yaşayan bir can oldu. ");
INSERT INTO turytc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahve Tanrı doğuya doğru, Aden'de bir bahçe dikti ve biçim vermiş olduğu Adem’i oraya koydu. ");
INSERT INTO turytc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yahve Tanrı görünüşü güzel ve yemek için iyi olan her ağacı, bahçenin ortasındaki yaşam ağacını ve iyiyle kötüyü bilme ağacını yerden bitirdi. ");
INSERT INTO turytc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bahçeyi sulamak için Aden'den bir ırmak çıktı; oradan bölünüp dört ırmağın kaynağı oldu. ");
INSERT INTO turytc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","İlkinin adı Pişon’dur. Altın bulunan bütün Havila diyarından akar. ");
INSERT INTO turytc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","O diyarın altını iyidir. Orada reçine ve oniks de vardır. ");
INSERT INTO turytc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","İkinci ırmağın adı Gihon'dur. Tüm Kûş ülkesinde akan bu ırmaktır. ");
INSERT INTO turytc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Üçüncü ırmağın adı Dicle'dir. Aşur'un önünden akan budur. Dördüncü ırmak Fırat'tır. ");
INSERT INTO turytc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahve Tanrı Adem’i aldı ve yetiştirmesi ve bakması için onu Aden bahçesine koydu. ");
INSERT INTO turytc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahve Tanrı Adem’e, “Bahçenin her ağacından özgürce yiyebilirsin” diye buyurdu. ");
INSERT INTO turytc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","“Ama iyiyle kötüyü bilme ağacından yemeyeceksin. Çünkü ondan yediğin gün kesin olarak ölürsün.” ");
INSERT INTO turytc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yahve Tanrı “Adem'in yalnız kalması iyi değil. Ona kendisine kıyas bir yardımcı yapacağım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yahve Tanrı, kırdaki her hayvanı ve gökteki her kuşu topraktan yarattı ve onlara ne ad vereceğini görmek için Adem’e getirdi. Adem her birinin adını ne koyduysa, adı o oldu. ");
INSERT INTO turytc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adem bütün evcil hayvanlara, göklerin kuşlarına ve kırdaki her hayvana ad koydu. Ama Adem için ona denk bir yardımcı bulunamadı. ");
INSERT INTO turytc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yahve Tanrı Adem’e derin bir uyku verdi. Adem uyurken kaburga kemiğinden birini aldı ve yerini etle kapladı. ");
INSERT INTO turytc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yahve Tanrı Adem’den aldığı kaburga kemiğinden bir kadın yaptı ve onu Adem’e getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adem, “İşte, bu benim kemiklerimden kemik ve etimden ettir” dedi. İnsandan alındığı için ona ‘kadın’ denecek.” ");
INSERT INTO turytc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Bu nedenle insan babasını annesini bırakıp karısına bağlanacak ve tek beden olacaklar. ");
INSERT INTO turytc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adem de karısı da çıplaktı ve utançları yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yahve Tanrı'nın yarattığı kır hayvanlarının en kurnazı yılandı. Yılan kadına, “Tanrı gerçekten, ‘Bahçenin hiçbir ağacından yemeyin’ dedi mi?” diye sordu. ");
INSERT INTO turytc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kadın yılana, “Bahçedeki ağaçların meyvesinden yiyebiliriz” dedi, ");
INSERT INTO turytc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","“Ama bahçenin ortasındaki ağacın meyvesi hakkında Tanrı, ‘Ondan yemeyin, ona dokunmayın; yoksa ölürsünüz’ dedi.” ");
INSERT INTO turytc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yılan kadına, “Gerçekten ölmezsiniz” dedi, ");
INSERT INTO turytc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Çünkü Tanrı biliyor ki, ondan yediğiniz gün gözleriniz açılacak, iyiyi ve kötüyü bilerek Tanrı gibi olacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kadın, ağacın yemek için iyi, göze hoş, insanı bilge kılmak için çekici olduğunu gördü. Meyvesinden biraz aldı ve yedi. Ardından yanındaki kocasına da biraz verdi, o da yedi. ");
INSERT INTO turytc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Gözleri açıldı ve ikisi de çıplak olduklarını bildiler. İncir yapraklarını dikip kendilerine örtü yaptılar. ");
INSERT INTO turytc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Günün serinliğinde bahçede yürüyen Yahve Tanrı'nın sesini duydular. Adamla karısı Yahve Tanrı'nın huzurundan bahçedeki ağaçların arasına saklandılar. ");
INSERT INTO turytc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahve Tanrı adama, “Neredesin?” diye seslendi. ");
INSERT INTO turytc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam, “Bahçede sesini duydum ve korktum, çünkü çıplaktım” dedi. “Bu nedenle saklandım.” ");
INSERT INTO turytc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tanrı, “Çıplak olduğunu sana kim söyledi? Sana yememeni buyurduğum ağaçtan mı yedin?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam, “Yanıma verdiğin kadın ağacın meyvesinden bana verdi, ben de yedim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahve Tanrı kadına, “Ne yaptın?” dedi. Kadın, “Yılan beni aldattı, ben de yedim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahve Tanrı yılana şöyle dedi: “Bunu yaptığın için, tüm evcil ve kır hayvanlarının en lanetlisi sen olacaksın. Karnının üstünde sürünecek, ömrünün bütün günlerinde toprak yiyeceksin. ");
INSERT INTO turytc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Seninle kadının, onun soyuyla senin soyunun arasına düşmanlık koyacağım. O senin başını ezecek. Sen onun topuğunu yaralayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kadına şöyle dedi: “Çocuk doğururken acını katlanarak artıracağım. Ağrı içinde doğum yapacaksın. Arzun kocan için olacak, ve o sana hükmedecek.” ");
INSERT INTO turytc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adem'e şöyle dedi: “Karının sesine kulak verdiğin, ve sana, meyvesini yememeni buyurduğum ağaçtan yediğin için toprak senin yüzünden lanetlendi. Hayatının bütün günlerinde büyük emekle ondan yiyeceksin. ");
INSERT INTO turytc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Sana dikenler ve çalılar verecek; ve kır otunu yiyeceksin. ");
INSERT INTO turytc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Toprağa dönünceye dek alın teriyle ekmek yiyeceksin, çünkü topraktan çıkarıldın. Çünkü toz topraksın, ve yine toz toprağa döneceksin.” ");
INSERT INTO turytc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam bütün yaşayanların annesi olacağı için karısına Havva adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahve Tanrı Adem'le karısı için hayvan derisinden giysiler yaptı, onları giydirdi. ");
INSERT INTO turytc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahve Tanrı şöyle dedi: “İşte, adam iyiyi ve kötüyü bilmekle bizden biri gibi oldu. Şimdi, elini uzatıp yaşam ağacından almasın, yiyip sonsuza dek yaşamasın.” ");
INSERT INTO turytc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Bu nedenle Yahve Tanrı, içinden alındığı toprağı işlemesi için onu Aden bahçesinden gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Böylece adamı kovdu; ve yaşam ağacına giden yolu korumak için Aden bahçesinin doğusuna Keruvlar ve her yöne dönen alevli bir kılıç koydu. ");
INSERT INTO turytc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adem karısı Havva'yı bildi; ve gebe kalıp Kain'i doğurdu. “Yahve'nin yardımıyla bir adam kazandım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Yeniden doğum yaptı ve Kain'in kardeşi Habel'i dünyaya getirdi. Habel koyun çobanı oldu, ama Kain çiftçi oldu. ");
INSERT INTO turytc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bir süre sonra, Kain toprağın ürününden Yahve’ye sunu getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel de sürüsünün ilk doğanlarından ve yağından getirdi. Yahve Habel'i ve onun sunusunu saydı. ");
INSERT INTO turytc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ama Kain'i ve onun sunusunu saymadı. Kain çok öfkelendi ve suratını astı. ");
INSERT INTO turytc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahve Kain'e, “Niçin öfkelendin? Niçin suratını astın? ");
INSERT INTO turytc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Eğer iyi yaparsan, yükseltilmeyecek mi? Eğer iyi yapmazsan, günah kapıda pusuya yatmış durumda; onun istediği sensin, ama sen ona hükmetmelisin.” ");
INSERT INTO turytc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain, kardeşi Habel'e, “Haydi, kıra gidelim” dedi. Kırda birlikteyken, Kain kardeşi Habel’e karşı kalktı ve onu öldürdü. ");
INSERT INTO turytc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yahve Kain'e, “Kardeşin Habel nerede?” dedi. O, “Bilmiyorum. Ben kardeşimin bekçisi miyim?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yahve, “Ne yaptın? Kardeşinin kanının sesi topraktan bana haykırıyor. ");
INSERT INTO turytc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Artık kardeşinin kanını senden almak için ağzını açan toprağın laneti altındasın. ");
INSERT INTO turytc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bundan böyle işlediğin toprak gücünü sana vermeyecek. Yeryüzünde kaçak ve göçebe olacaksın.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain, Yahve’ye, “Cezam dayanamayacağım kadar ağır” dedi, ");
INSERT INTO turytc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","“İşte, bugün beni toprağın üstünden kovdun. Senin huzurundan ayrı kalacağım, yeryüzünde bir kaçak ve gezgin olacağım. Beni kim bulursa öldürecek.” ");
INSERT INTO turytc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahve ona, “Bunun üzerine, Kain'i kim öldürürse, ondan yedi kez öç alınacak” dedi. Yahve, Kain’in üzerine bir işaret koydu, öyle ki, onu bulan kimse ona vurmasın. ");
INSERT INTO turytc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kain Yahve'nin huzurundan ayrılıp Aden'in doğusundaki Nod diyarına yerleşti. ");
INSERT INTO turytc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain karısını bildi. Gebe kalıp Hanok'u doğurdu. Bir kent kurdu ve kente oğlu Hanok'un adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanok’tan İrad oldu. Irad, Mehuyael'in babası oldu. Mehuyael, Metuşael'in babası oldu. Metuşael Lamek'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek iki kadın aldı. İlkinin adı Ada, ikincisinin adı Tsilla’ydı. ");
INSERT INTO turytc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada, çadırlarda yaşayan ve hayvan besleyenlerin atası olan Yabal'ı doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kardeşinin adı Yubal'dı. O, çenk ve kaval çalan herkesin atasıydı. ");
INSERT INTO turytc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tsilla, her türlü tunç ve demirden kesici aletler yapan Tuval Kain'i de doğurdu. Tuval Kain'in kız kardeşi Naama'ydı. ");
INSERT INTO turytc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek karılarına şöyle dedi: “Ey Ada ve Tsilla, sesime kulak verin. Lamek'in karıları, sözümü dinleyin, beni yaraladığı için bir adamı, beni hırpaladığı için bir genci öldürdüm. ");
INSERT INTO turytc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain'in intikamı yedi kez alınacaksa, Lamek’in yetmiş yedi kez alınacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adem karısını yeniden bildi. Bir oğul doğurdu ve “Tanrı bana Habel yerine başka bir çocuk verdi, çünkü onu Kain öldürdü” diyerek ona Şit adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Şit'in de bir oğlu oldu, adını Enoş koydu. O zaman insanlar Yahve’yi adıyla çağırmaya başladılar. ");
INSERT INTO turytc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Bu, Adem soylarının kitabıdır. Tanrı insanı yarattığı gün, onu Tanrı'nın benzerliğinde yarattı. ");
INSERT INTO turytc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Onları erkek ve dişi olarak yarattı ve onları kutsadı. Yaratıldıkları gün onlara Adam adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adem yüz otuz yaşında, kendi benzerliğinde, kendi suretinde bir oğul babası oldu ve ona Şit adını koydu. ");
INSERT INTO turytc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adem Şit'in babası olduktan sonra sekiz yüz yıl yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adem toplam dokuz yüz otuz yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Şit yüz beş yaşında Enoş'un babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Şit, Enoş'un babası olduktan sonra sekiz yüz yedi yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Şit toplam dokuz yüz on iki yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoş doksan yaşındayken Kenan'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enoş, Kenan'ın babası olduktan sonra sekiz yüz on beş yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoş toplam dokuz yüz beş yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan yetmiş yaşındayken Mahalalel'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan, Mahalalel'in babası olduktan sonra sekiz yüz kırk yıl yaşadı, başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan toplam dokuz yüz on yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel altmış beş yaşındayken Yeret'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel, Yeret'in babası olduktan sonra sekiz yüz otuz yıl daha yaşadı ve başka oğulları ve kızları oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel toplam sekiz yüz doksan beş yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yeret yüz altmış iki yaşındayken Hanok'un babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yeret, Hanok'un babası olduktan sonra sekiz yüz yıl daha yaşadı ve başka oğulları ve kızları oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yeret toplam dokuz yüz altmış iki yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hanok altmış beş yaşındayken Metuşelah'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metuşelah'ın doğumundan sonra Hanok üç yüz yıl Tanrı’yla yürüdü ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hanok'un tüm günleri üç yüz altmış beş yıldı. ");
INSERT INTO turytc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hanok Tanrı'yla yürüdü ve bulunamadı, çünkü Tanrı onu aldı. ");
INSERT INTO turytc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuşelah yüz seksen yedi yaşındayken Lamek'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metuşelah, Lamek'in babası olduktan sonra yedi yüz seksen iki yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuşelah toplam dokuz yüz altmış dokuz yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek yüz seksen iki yaşındayken bir oğul babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","“İşimizden ve Yahve’nin lanetlediği toprak yüzünden çektiğimiz zahmetten, bu bizi rahatlatacak” diyerek çocuğa Noa adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek, Noa'nın babası olduktan sonra beş yüz doksan beş yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek toplam yedi yüz yetmiş yedi yıl yaşadıktan sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa beş yüz yaşındaydı. Noa Sam’ın, Ham’ın ve Yafet'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yeryüzünde insanlar çoğalmaya başladı, kızları doğdu. ");
INSERT INTO turytc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tanrı oğulları insan kızlarının güzel olduğunu gördüler ve dilediklerini kendilerine eş olarak aldılar. ");
INSERT INTO turytc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahve, “Ruhum insanla sonsuza dek çekişmeyecek” dedi, “Çünkü o et ve kemiktir; onun günleri yüz yirmi yıl olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tanrı oğullarının insan kızlarına vardıkları, onlarla çocuk sahibi oldukları günlerde ve sonrasında yeryüzünde Nefiller vardı. Bunlar kudretli ve ünlü eski çağ adamlarıydı. ");
INSERT INTO turytc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahve yeryüzünde insanın kötülüğünün büyüklüğünü ve insanın yüreğindeki düşüncelerindeki her hayalinin sürekli yalnızca kötülük olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahve yeryüzünde insanı yarattığına üzüldü ve yüreği kederlendi. ");
INSERT INTO turytc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yahve, “Yarattığım insanı, hayvanları, sürüngenleri, göğün kuşlarını yerin yüzeyinden yok edeceğim” dedi, “Çünkü onları yarattığıma üzüldüm.” ");
INSERT INTO turytc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ama Noa Yahve'nin gözünde lütuf buldu. ");
INSERT INTO turytc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Bu, Noa soylarının tarihidir: Noa doğru bir adamdı, kendi kuşağının arasında kusursuz biriydi. Noa Tanrı’yla yürüdü. ");
INSERT INTO turytc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa'nın üç oğlu oldu: Sam, Ham ve Yafet. ");
INSERT INTO turytc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Yeryüzü Tanrı'nın önünde bozulmuştu ve yeryüzü zorbalıkla doluydu. ");
INSERT INTO turytc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tanrı yeryüzünü gördü ve işte bozulmuştu. Yeryüzünde yaşayanların tümü yollarını bozmuştu. ");
INSERT INTO turytc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tanrı Noa'ya, “Bütün yaşayanların sonunu getireceğim” dedi, “Çünkü onların yüzünden yeryüzü zorbalıkla doldu. İşte, onları da yeryüzünü de yok edeceğim. ");
INSERT INTO turytc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gofer ağacından bir gemi yap. Gemide odalar yapacaksın, içini ve dışını ziftle kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Onu şöyle yapacaksın: Geminin uzunluğu üç yüz arşın, genişliği elli arşın ve yüksekliği otuz arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gemide pencere de yapacaksın ve onu yukarıya doğru bir arşına tamamlayacaksın. Geminin kapısını yanına koyacaksın. Alt, ikinci ve üçüncü katlı seviyeler yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Gökyüzünün altından yaşam soluğu taşıyan bütün canlıları yok etmek için yeryüzüne tufan getireceğim. Yeryüzündeki her şey ölecek. ");
INSERT INTO turytc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ama seninle antlaşmamı kuracağım. Sen, oğulların, karın ve oğullarının karıları seninle birlikte gemiye gireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Yanınızda yaşamaları için her türden canlıdan ikişer ikişer gemiye getireceksiniz. Erkek ve dişi olacaklar. ");
INSERT INTO turytc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Cinsine göre kuşlardan, cinsine göre davarlardan, cinsine göre topraktaki her sürüngenden, her cinsten ikişer sağ kalmak üzere sana gelecekler. ");
INSERT INTO turytc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Yenilen tüm yiyeceklerden yanına al ve kendiniz için toplayın; ve size ve onlara yiyecek olacaklar.” ");
INSERT INTO turytc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa böyle yaptı. Tanrı’nın kendisine buyurduğu her şeyi yerine getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahve Noa'ya, “Bütün ev halkınla birlikte gemiye gir” dedi, “Çünkü bu kuşak içinde yalnız seni önümde doğru gördüm. ");
INSERT INTO turytc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tüm yeryüzü üzerinde bulunan tohumlarının hayatta kalması için, yanına her temiz hayvandan, erkek ve dişi olmak üzere yedişer çift, temiz olmayan hayvanlardan erkek ve dişi olmak üzere birer çift, ");
INSERT INTO turytc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","gökyüzünün kuşlarından da erkek ve dişi olmak üzere yedişer çift al. ");
INSERT INTO turytc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yedi gün sonra yeryüzüne kırk gün kırk gece yağmur yağdıracağım. Yapmış olduğum her canlıyı yeryüzünden yok edeceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa Yahve’nin kendisine buyurduğu her şeyi yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yeryüzüne tufan geldiğinde Noa altı yüz yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa tufan sularından ötürü oğulları, karısı ve oğullarının karılarıyla birlikte gemiye bindi. ");
INSERT INTO turytc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Temiz hayvanlar, kirli hayvanlar, kuşlar ve toprak üzerinde sürünenlerin hepsi ");
INSERT INTO turytc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Tanrı'nın Noa'ya buyurduğu gibi, erkek ve dişi olarak ikişer ikişer gemiye gelip Noa'nın yanına girdiler. ");
INSERT INTO turytc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yedi gün sonra yeryüzü sularla kaplandı. ");
INSERT INTO turytc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa altı yüz yaşındayken, ikinci ayın on yedinci günü, büyük derinliğin bütün kaynakları fışkırdı, gökyüzünün pencereleri açıldı. ");
INSERT INTO turytc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yeryüzüne kırk gün kırk gece yağmur yağdı. ");
INSERT INTO turytc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tam o gün Noa, Noa'nın oğulları Sam, Ham, Yafet, karısı ve oğullarının üç karısıyla birlikte gemiye girdiler. ");
INSERT INTO turytc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Cinsine göre hayvanlar, cinsine göre bütün evcil hayvanlar, cinsine göre toprak üzerinde sürünenlerin hepsi, cinsine göre her kuş, uçan yaratıkların her cinsi gemiye girdi. ");
INSERT INTO turytc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","İçlerinde yaşam soluğu bulunan her canlıdan ikişer ikişer gemiye Noa'nın yanına geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","İçeri girenler, Tanrı'nın kendisine buyurduğu gibi, her hayvandan erkek ve dişi olarak girdiler. ");
INSERT INTO turytc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Yeryüzünde kırk gün tufan oldu. Sular çoğaldı, gemiyi kaldırdı ve yerin üstüne çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yeryüzünde sular yükseldi, çoğaldıkça çoğaldı; ve gemi suların yüzeyinde yüzmeye başladı. ");
INSERT INTO turytc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yeryüzünde sular pek çok yükseldi. Tüm gökyüzünün altında bulunan bütün yüksek dağlar örtüldüler. ");
INSERT INTO turytc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Örtülen dağları sular on beş arşın aştı. ");
INSERT INTO turytc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kuşlar, evcil ve yabanıl hayvanlar, yeryüzünde sürünen her canlı ve insan, yeryüzünde yaşayan tüm canlılar öldü. ");
INSERT INTO turytc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Karada olup burunlarında yaşam ruhunun soluğunu taşıyanların hepsi öldü. ");
INSERT INTO turytc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yerin yüzeyindeki her canlı, insan, evcil hayvanlar, sürüngenler ve gökte uçan kuşlar yok oldu. Yeryüzünden yok edildiler. Geride yalnızca Noa ve onunla birlikte gemide bulunanlar kalmıştı. ");
INSERT INTO turytc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sular yüz elli gün boyunca yeryüzünü kapladı. ");
INSERT INTO turytc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tanrı Noa'yı, onunla birlikte gemide bulunan bütün evcil ve yabanıl hayvanları, hatırladı. Tanrı yeryüzünün üzerinden rüzgâr estirdi. Sular çekildi. ");
INSERT INTO turytc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Derinliğin kaynakları ve gökyüzünün pencereleri de durduruldu, gökten yağan yağmur kesildi. ");
INSERT INTO turytc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sular gittikçe yerden çekildi. Yüz elli günün sonunda sular azaldı. ");
INSERT INTO turytc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Gemi yedinci ayın on yedinci günü, Ararat dağlarının üzerine oturdu. ");
INSERT INTO turytc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Sular onuncu aya kadar sürekli çekildi. Onuncu ayın birinci günü dağların dorukları göründü. ");
INSERT INTO turytc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kırk gün sonra Noa yapmış olduğu geminin penceresini açtı. ");
INSERT INTO turytc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Bir kuzgun gönderdi. Kuzgun sular yeryüzünden kuruyana dek öteye beriye gitti. ");
INSERT INTO turytc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noa’nın kendisi yerin yüzeyindeki suların çekilip çekilmediğini görmek için bir güvercin gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Güvercin ayağını koyup dinlenebileceği bir yer bulamayınca gemiye, Noa’ya geri döndü. Çünkü yeryüzünün tümü sularla kaplıydı. Elini uzatıp onu tuttu ve kendi yanına gemiye aldı. ");
INSERT INTO turytc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yedi gün daha bekledi; ve yine güvercini gemiden gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Güvercin akşam üstü ona geri geldi ve işte, ağzında yeni koparılmış bir zeytin yaprağı vardı. Böylece Noa, suların yeryüzünden çekildiğini bildi. ");
INSERT INTO turytc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yedi gün daha bekleyip güvercini gönderdi. Artık güvercin ona geri dönmedi. ");
INSERT INTO turytc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Altı yüz birinci yılının birinci ayında, ayın birinci gününde sular kurudu. Noa geminin örtüsünü kaldırdı ve baktı. Toprağın yüzünün kuru olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","İkinci ayın yirmi yedinci günü toprak kurudu. ");
INSERT INTO turytc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tanrı Noa'ya şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Sen, karın, oğullarınız ve oğullarınızın karılarıyla birlikte gemiden çıkın. ");
INSERT INTO turytc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kuşları, evcil hayvanları ve yerde sürünen sürüngenleri, yanınızda olan her canlıyı çıkarın ki, yeryüzünde bol bol üresinler ve verimli olup yeryüzünde çoğalsınlar.” ");
INSERT INTO turytc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noa, oğulları, karısı ve oğullarının karılarıyla birlikte çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Yeryüzünde yaşayan her hayvan, her sürüngen, her kuş, familyalarına göre gemiden çıktılar. ");
INSERT INTO turytc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa Yahve’ye bir sunak yaptı, her temiz hayvandan, her temiz kuştan aldı ve sunakta yakmalık sunular sundu. ");
INSERT INTO turytc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahve hoş kokuyu kokladı. Yahve yüreğinde şöyle dedi: “Artık insan yüzünden toprağı yeniden lanetlemeyeceğim, çünkü insanın yüreğinin hayalleri gençliğinden beri kötüdür. Daha önce yaptığım gibi her canlıya bir daha asla vurmayacağım. ");
INSERT INTO turytc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dünya durdukça, tohum ve hasat zamanı, soğuk ve sıcak, yaz ve kış, gündüz ve gece son bulmayacak.” ");
INSERT INTO turytc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tanrı Noa'yı ve oğullarını kutsadı ve onlara, “Verimli olun, çoğalın ve yeryüzünü doldurun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","“Yerdeki hayvanların, gökyüzündeki kuşların hepsi sizden korkup ürkecek. Toprağın üzerinde hareket edenlerin tümü, denizdeki bütün balıklar elinize teslim edildiler. ");
INSERT INTO turytc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hareket eden her canlı size yiyecek olacaktır. Size verdiğim yeşil bitkiler gibi, hepsini size veriyorum. ");
INSERT INTO turytc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ama eti, onun yaşamı olan, kanıyla birlikte yemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sizin de kanınızın hesabını mutlaka soracağım. Her hayvanın elinden bunu soracağım. Her insanın elinden, hatta her insanın kardeşinin elinden, insan yaşamının hesabını soracağım. ");
INSERT INTO turytc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kim insan kanı dökerse, onun kanı insan tarafından dökülecektir. Çünkü Tanrı insanı kendi suretinde yarattı. ");
INSERT INTO turytc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Verimli olun ve çoğalın. Yeryüzünde üreyin ve onda çoğalın.” ");
INSERT INTO turytc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tanrı Noa'ya ve oğullarına şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“İşte ben, sizinle ve sonraki kuşaklarınızla, ");
INSERT INTO turytc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","sizinle birlikte olan her canlıyla, kuşlarla, evcil hayvanlarla ve sizinle birlikte olan yerin bütün hayvanlarıyla, gemiden çıkanların hepsiyle, hatta yeryüzünün bütün hayvanlarıyla ");
INSERT INTO turytc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","antlaşmamı kuracağım. Tufan suları artık hiçbir canlıyı yok etmeyecek. Bir daha yeryüzünü yok edecek bir tufan olmayacak.” ");
INSERT INTO turytc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Tanrı şöyle dedi: “Sizinle ve sizinle birlikte olan bütün canlılarla daima sürecek antlaşmamın işareti şudur: ");
INSERT INTO turytc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Gökkuşağımı buluta yerleştirdim, benimle yerin arasında bir antlaşma işareti olacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yeryüzünün üzerine bulut getirdiğim zaman, gökkuşağı da görünecektir ");
INSERT INTO turytc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ve böylece benimle ve sizinle ve tüm canlı varlıklarla aramızda olan antlaşmamı hatırlayacağım ve tüm canlıları yok etmek için artık sular tufan olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Gökkuşağı bulutta olacaktır. Tanrı’yla yeryüzünde yaşayan her canlı yaratık arasındaki sonsuz antlaşmayı hatırlamak için ona bakacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tanrı Noa'ya, “Bu, benimle yeryüzündeki bütün canlılar arasında kurduğum antlaşmanın işaretidir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Gemiden çıkan Noa'nın oğulları: Sam, Ham ve Yafet idiler. Ham, Kenan'ın babasıdır. ");
INSERT INTO turytc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Bu üçü Noa'nın oğullarıydı ve bütün yeryüzündekiler onlardan çoğaldı. ");
INSERT INTO turytc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa çiftçiliğe başladı ve bir bağ dikti. ");
INSERT INTO turytc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Şarap içip sarhoş oldu. Çadırının içinde çıplaktı. ");
INSERT INTO turytc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenan'ın babası Ham, babasının çıplaklığını görünce dışarıdaki iki kardeşine söyledi. ");
INSERT INTO turytc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sam'la Yafet bir giysi alıp omuzlarına attılar, geri geri gidip babalarının çıplaklığını örttüler. Yüzleri geriye dönüktü ve babalarının çıplaklığını görmediler. ");
INSERT INTO turytc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa ayılınca küçük oğlunun kendisine ne yaptığını bildi. ");
INSERT INTO turytc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ve şöyle dedi: Kenan lanetlendi. Kardeşlerine hizmetkârlar hizmetkârı olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","“Sam'ın Tanrısı Yahve'ye övgüler olsun. Kenan onun hizmetkârı olsun. ");
INSERT INTO turytc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tanrı Yafet’e bolluk versin, Sam'ın çadırlarında yaşasın. Kenan onun hizmetkârı olsun.” ");
INSERT INTO turytc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa tufandan sonra üç yüz elli yıl yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa’nın bütün günleri dokuz yüz elli yıldı ve sonra öldü. ");
INSERT INTO turytc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa'nın oğulları ile Sam'ın, Ham'ın ve Yafet'in soylarının öyküsü bunlardır. Tufandan sonra onlara oğullar doğdu. ");
INSERT INTO turytc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet'in oğulları: Gomer, Magog, Meday, Yavan, Tubal, Meşek, Tiras. ");
INSERT INTO turytc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer'in oğulları: Aşkenaz, Rifat, Togarma. ");
INSERT INTO turytc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan'ın oğulları: Elişa, Tarşiş, Kittim, Rodanim. ");
INSERT INTO turytc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ülkelerinde her biri kendi diline göre, ailelerine göre, uluslarına göre ulusların adaları bunlardan bölündü. ");
INSERT INTO turytc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham'ın oğulları: Kuş, Misraim, Put ve Kenan. ");
INSERT INTO turytc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuş'un oğulları: Seva, Havila, Sevta, Raama, Savteka. Raama'nın oğulları: Şeva ve Dedan. ");
INSERT INTO turytc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuş Nimrod'un babası oldu. Yeryüzünde kudretli biri olmaya başladı. ");
INSERT INTO turytc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yahve’nin önünde güçlü bir avcıydı. Bu nedenle, “Yahve'nin önünde Nimrod gibi güçlü bir avcı” denir. ");
INSERT INTO turytc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Onun krallığının başlangıcı Şinar diyarında Babil, Erek, Akkad ve Kalne idi. ");
INSERT INTO turytc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Bu topraklardan Aşur'a gitti ve Nineve ile büyük Kala kenti arasında Nineve, Rehovot-İr, Kalah ");
INSERT INTO turytc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ve Resen'i kurdu. ");
INSERT INTO turytc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim, Ludiler’in, Anamiler’in, Lehabiler'in, Naftuhiler’in, ");
INSERT INTO turytc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusiler’in, Kasluhiler’in (Filistliler bunlardan geldi) ve Kaftorinler'in atası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan ilk oğlu Sidon, Het'in, ");
INSERT INTO turytc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yevuslular'ın, Amorlular'ın, Girgaşlılar'ın, ");
INSERT INTO turytc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivliler'in, Arklılar'ın, Sinliler'in, ");
INSERT INTO turytc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadlılar'ın, Semarlılar'ın ve Hamatiler'in atası oldu. Daha sonra Kenanlı soyları yayıldı. ");
INSERT INTO turytc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kenanlılar'ın sınırı Sayda'dan Gerar, Gaza, Sodom, Gomora, Adma ve Sevoyim'e doğru Laşa'ya kadar uzanıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ülkelerinde ve uluslarında dillerine göre boylarına göre Ham'ın oğulları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Eber'in bütün çocuklarının atası olan Sam’ın da (Yafet'in ağabeyi) çocukları oldu. ");
INSERT INTO turytc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sam'ın oğulları: Elam, Aşur, Arpakşad, Lud, Aram. ");
INSERT INTO turytc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram'ın oğulları: Uz, Hul, Geter, Maş. ");
INSERT INTO turytc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakşat Şelah'ın babası oldu. Şelah, Eber'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber'in iki oğlu oldu. Birinin adı Pelek'di, çünkü onun günlerinde yeryüzü bölünmüştü. Erkek kardeşinin adı Yoktan'dı. ");
INSERT INTO turytc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan, Almodad, Şelef, Hatsarmavet, Yerah, ");
INSERT INTO turytc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO turytc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Şeba, ");
INSERT INTO turytc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila ve Yoba'nın babası oldu. Bunların hepsi Yoktan'ın oğullarıydı. ");
INSERT INTO turytc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Doğuda, Meşa’dan Sefar’a uzanan dağlık bölgeye yerleşmişlerdi. ");
INSERT INTO turytc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ülkelerinde uluslarına göre, dillerine göre, boylarına göre Sam'ın oğulları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Uluslarına göre soylarına göre Noa'nın oğullarının aileleri bunlardır. Tufandan sonra yeryüzünde uluslar bunlardan bölündü. ");
INSERT INTO turytc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bütün dünyanın dili ve sözü birdi. ");
INSERT INTO turytc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Doğuya göçerlerken Şinar diyarında bir ova bulup orada yaşadılar. ");
INSERT INTO turytc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Birbirlerine, “Gelin, tuğla yapıp iyice pişirelim” dediler. Taş yerine tuğla ve harç yerine zift kullandılar. ");
INSERT INTO turytc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","“Gelin, kendimize bir kent, başı gökyüzüne erişecek bir kule yapalım, ün salıp yeryüzüne dağılmayalım” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yahve Ademoğulları’nın yaptığı kenti ve kuleyi görmek için aşağıya indi. ");
INSERT INTO turytc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahve, “İşte, onlar bir halk ve hepsinin bir dili var” dedi, “Yapmaya başladıkları şey budur. Artık yapmaya niyetlendikleri şeyden onları hiçbir şey alıkoyamayacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Gelin, aşağı inelim ve birbirlerinin konuşmalarını anlamasınlar diye orada dillerini karıştıralım.” ");
INSERT INTO turytc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Böylece Yahve onları oradan tüm yeryüzüne dağıttı. Kenti inşa etmeyi bıraktılar. ");
INSERT INTO turytc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Bu nedenle kentin adına Babil adı verildi. Çünkü Yahve bütün yeryüzünün dilini orada karıştırdı. Yahve oradan onları bütün yeryüzüne dağıttı. ");
INSERT INTO turytc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sam'ın soylarının öyküsü bunlardır: Tufandan iki yıl sonra Arpakşad'ın babası olduğunda Sam yüz yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sam, Arpakşad'ın babası olduktan sonra beş yüz yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakşad otuz beş yaşındayken Şelah'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpakşat Şelah'ın doğumundan sonra dört yüz üç yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Şelah otuz yaşındayken Ever'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Şelah, Ever'in babası olduktan sonra dört yüz üç yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ever otuz dört yaşındayken Pelek'in babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ever, Pelek'in babası olduktan sonra dört yüz otuz yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek otuz yaşındayken Reu'nun babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelek, Reu'nun babası olduktan sonra iki yüz dokuz yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu otuz iki yaşındayken Seruk'un babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk'un babası olduktan sonra Reu iki yüz yedi yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk otuz yaşındayken Nahor'un babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruk, Nahor'un doğumundan sonra iki yüz yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor yirmi dokuz yaşındayken Terah'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor, Terah'ın doğumundan sonra yüz on dokuz yıl daha yaşadı ve başka oğullar ve kızlar babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah yetmiş yaşındayken Avram, Nahor ve Haran'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terah’ın soylarının tarihi budur. Terah Avram, Nahor ve Haran'ın babası oldu. Haran, Lut'un babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran, babası Terah daha sağken, doğduğu topraklarda, Keldaniler'in Ur şehrinde öldü. ");
INSERT INTO turytc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Avram ve Nahor kendilerine karılar alarak evlendiler. Avram'ın karısının adı Saray'dı, Nahor'un karısının adı da Milka’ydı. Milka Yiska’nın babası olan Haran'ın kızıydı. ");
INSERT INTO turytc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray kısırdı. Çocuğu yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah oğlu Avram'ı, Haran'ın oğlu torunu Lut'u ve oğlu Avram'ın karısı gelini Saray'ı yanına aldı. Kenan diyarına gitmek için Keldaniler’in Ur şehrinden ayrıldılar. Haran'a gelip orada yaşadılar. ");
INSERT INTO turytc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah'ın günleri iki yüz beş yıldı. Terah, Haran'da öldü. ");
INSERT INTO turytc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yahve Avram'a şöyle dedi: “Ülkeni, akrabalarını, baba evini bırak, sana göstereceğim ülkeye git. ");
INSERT INTO turytc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Seni büyük bir ulus yapacağım. Seni kutsayacak adını büyük yapacağım. Bereket olacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Seni kutsayanları kutsayacağım, seni lanetleyeni lanetleyeceğim. Yeryüzünün bütün aileleri senin aracılığınla kutsanacak.” ");
INSERT INTO turytc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Böylece Avram, Yahve'nin kendisine söylediği gibi gitti. Lut da onunla gitti. Avram Haran'dan ayrıldığında yetmiş beş yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Avram karısı Saray'ı, kardeşinin oğlu Lut'u, Haran’da kazanmış oldukları bütün malları ve edinmiş oldukları canları alıp Kenan ülkesine gittiler. Kenan ülkesine geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Avram ülke üzerinden geçerek Şekem bölgesine, More meşesine gitti. O sırada Kenanlılar ülkedeydi. ");
INSERT INTO turytc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahve Avram'a görünerek, “Bu toprakları senin soyuna vereceğim” dedi. Kendisine görünmüş olan Yahve’ye orada bir sunak yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Beytel'in doğusunda olan dağa gitmek üzere oradan ayrıldı. Çadırını batıdaki Beytel'le doğudaki Ay Kenti’nin arasına kurdu. Orada Yahve’ye bir sunak yaptı ve Yahve’nin adını çağırdı. ");
INSERT INTO turytc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Avram güneye doğru ilerledi. ");
INSERT INTO turytc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ülkede kıtlık oldu. Avram orada bir yabancı olarak yaşamak üzere Mısır'a indi, çünkü ülkede kıtlık şiddetliydi. ");
INSERT INTO turytc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mısır'a yaklaştıklarında, karısı Saray'a, “İşte, senin görünüşü güzel bir kadın olduğunu biliyorum” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","“Olur ki, Mısırlılar seni görünce, ‘Bu onun karısı’ derler. Beni öldürürler, ama seni sağ bırakırlar. ");
INSERT INTO turytc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lütfen kız kardeşim olduğunu söyle ki, senin yüzünden bana iyi davransınlar ve senin sayende canım yaşasın.” ");
INSERT INTO turytc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Avram Mısır'a geldiğinde bazı Mısırlılar kadının çok güzel olduğunu gördüler. ");
INSERT INTO turytc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Firavunun beyleri onu görünce Firavun'a övdüler; ve kadın Firavun'un sarayına götürüldü. ");
INSERT INTO turytc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Onun hatırı için Firavun Avram'a iyi davrandı. Avram’ın koyunları, sığırları, eşekleri, erkek hizmetkârları, cariyeleri, dişi eşekleri ve develeri oldu. ");
INSERT INTO turytc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yahve Avram'ın karısı Saray yüzünden Firavun'la ev halkını büyük felaketlerle vurdu. ");
INSERT INTO turytc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Firavun Avram'ı çağırtarak, “Bana bu yaptığın nedir?” dedi. “Onun karın olduğunu neden bana söylemedin? ");
INSERT INTO turytc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Neden, ‘O benim kız kardeşim’ dedin ben de onu karım olarak aldım? Şimdi işte, karını al ve kendi yoluna git.” ");
INSERT INTO turytc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firavun adamlarına Avram hakkında buyruk verdi ve onlar da karısı ve sahip olduğu her şeyle birlikte onu gönderdiler. ");
INSERT INTO turytc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Avram, karısı, sahip olduğu her şey ve Lut'la birlikte Mısır'dan güneye çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Avram sürü, gümüş ve altın bakımından çok zengindi. ");
INSERT INTO turytc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Güneyden Beytel'e, Beytel ile Ay arasındaki başlangıçta çadırının bulunduğu yere, ");
INSERT INTO turytc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","oradan ilk yaptığı sunağın bulunduğu yere kadar gitti. Avram orada Yahve’nin adını çağırdı. ");
INSERT INTO turytc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Avram'la birlikte giden Lut'un da davarları, sığırları, çadırları vardı. ");
INSERT INTO turytc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Toprak, birlikte yaşamalarına el vermedi; malları o kadar çoktu ki birlikte yaşayamadılar. ");
INSERT INTO turytc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Avram'ın sürüsünün çobanlarıyla Lut'un sürüsünün çobanları arasında çekişme oldu. O dönemde bu topraklarda Kenanlılar ve Perizliler yaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Avram Lut'a şöyle dedi: Rica ederim, seninle benim, senin çobanlarınla benim çobanlarımın arasında çekişme olmasın; çünkü biz akrabayız. ");
INSERT INTO turytc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bütün ülke senin önünde değil mi? Rica ederim benden ayrıl. Sen sola gidersen, ben sağa gideceğim. Ya da sen sağa gidersen, ben sola giderim.” ");
INSERT INTO turytc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lut gözlerini kaldırdı ve bütün Yarden Ovası’nı gördü. Yahve Sodom ve Gomora'yı yok etmeden önce, Yahve’nin bahçesi gibi, Mısır diyarı gibi, Soar'a giderken her yerde bol su vardı. ");
INSERT INTO turytc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Böylece Lut kendisine Yarden Ovası'nı seçti. Lut doğuya gitti ve birbirlerinden ayrıldılar. ");
INSERT INTO turytc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram Kenan diyarında, Lut da ovadaki kentlerde oturdu ve çadırını Sodom'a kadar taşıdı. ");
INSERT INTO turytc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom halkı çok kötü ve Yahve’ye karşı günahkârdılar. ");
INSERT INTO turytc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut yanından ayrıldıktan sonra Yahve Avram'a şöyle dedi: “Şimdi gözlerini kaldır ve bulunduğun yerden kuzeye, güneye, doğuya ve batıya bak. ");
INSERT INTO turytc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Çünkü gördüğün bütün toprakları sonsuza dek sana ve soyuna vereceğim. ");
INSERT INTO turytc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Senin soyunu yerin tozu gibi yapacağım. Öyle ki, bir adam yerin tozunu sayabilirse, senin soyun da sayılabilir. ");
INSERT INTO turytc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kalk, toprakları enine boyuna dolaş çünkü onu sana vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Avram çadırını kaldırdı, gelip Hevron'daki Mamre meşeliği yanında yaşadı ve orada Yahve’ye bir sunak yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Şinar Kralı Amrafel'in günlerinde; Ellasar Kralı Ariyok; Elam Kralı Kedorlaomer ve Goyim Kralı Tidal, ");
INSERT INTO turytc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodom Kralı Bera ile savaştılar. Gomora Kralı Birşa’ya Adma Kralı Şinav’a, Sevoim Kralı Şemever’e ve Bala (Zoar da denir) Kralı’na karşı savaş açtı. ");
INSERT INTO turytc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bunların hepsi Siddim vadisinde (Tuzlu Deniz de denir) birleştiler. ");
INSERT INTO turytc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kedorlaomer'e on iki yıl hizmet ettiler ve on üçüncü yılda isyan ettiler. ");
INSERT INTO turytc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","On dördüncü yılda Kedorlaomer'le kendisiyle beraber olan krallar gelip Aşterot Karnayim'deki Refalılar'ı, Ham'daki Zuzlular'ı, Şave Kiryatayim'deki Emliler'i, ");
INSERT INTO turytc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","çöl kenarındaki El-Paran’a kadar uzanan dağlık Seir bölgesindeki Horiler’i bozguna uğrattılar. ");
INSERT INTO turytc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Geri dönüp Eyn Mişpat'a (Kadeş de denir) geldiler. Amalekliler'in ve Hazazon Tamar'da yaşayan Amorlular'ın bütün ülkesini vurdular. ");
INSERT INTO turytc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodom Kralı, Gomora Kralı, Adma Kralı, Sevoyim Kralı ve Bela (Tsoar da denir) Kralı dışarı çıktılar. ");
INSERT INTO turytc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam Kralı Kedorlaomer, Goyim Kralı Tidal, Şinar Kralı Amrafel ve Ellasar Kralı Aryok'a karşı dört kral beşe karşı Siddim Vadisi'nde savaş düzenine girdiler. ");
INSERT INTO turytc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim vadisi zift çukurlarıyla doluydu ve Sodom ve Gomora kralları kaçtı ve bazıları orada düştü. Geri kalanları tepelere kaçtılar. ");
INSERT INTO turytc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sodom ve Gomora'nın bütün mallarını, bütün yiyeceklerini alıp gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Avram'ın kardeşinin Sodom'da yaşayan oğlu Lut'u ve malını da alıp gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kaçıp kurtulan biri gelip İbrani Avram'a durumu bildirdi. O sırada Eşkol'un ve Aner'in kardeşi Amorlu Mamre'nin meşeliğinde yaşıyordu. Bunların hepsi Avram’dan yanaydılar. ");
INSERT INTO turytc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Avram akrabasının tutsak alındığını duyunca, evinde doğup yetişmiş üç yüz on sekiz adamını çıkarıp Dan'a kadar kovaladı. ");
INSERT INTO turytc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Geceleyin kendisi ve hizmetkârları onlara karşı bölük bölük ayrıldılar ve onları vurup Damaskus'un solunda kalan Hova'ya kadar kovaladılar. ");
INSERT INTO turytc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Bütün malını, akrabası Lut'u, malını, kadınları ve diğer insanları geri getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Avram Kedorlaomer ve yanında bulunan kralları bozguna uğratıp dönerken, Sodom Kralı onu karşılamak için Şave vadisine (yani Kral Vadisi'ne) çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Şalem Kralı Melkisedek ekmek ve şarap çıkardı. Yüce Tanrı'nın kâhiniydi. ");
INSERT INTO turytc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Onu kutsayarak şöyle dedi: “Göğün ve yerin sahibi Yüce Tanrı Avram’ı kutsasın. ");
INSERT INTO turytc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Düşmanlarını onun eline teslim eden Yüce Tanrı'ya övgüler olsun.” Avram ona her şeyin onda birini verdi. ");
INSERT INTO turytc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom Kralı Avram'a, “Adamları bana ver, malları kendine al” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Avram Sodom Kralı’na şöyle dedi: “Sana ait hiçbir şey, bir iplik, bir çarık bağı bile almayacağıma göğün ve yerin sahibi Yüce Tanrı Yahve'ye elimi kaldırdım. Öyle ki, ‘Avram'ı zengin ettim’ demeyesin. ");
INSERT INTO turytc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Gençlerin yediklerinden ve benimle birlikte gelen Aner, Eşkol ve Mamre'nin payından başka senden hiçbir şey kabul etmeyeceğim. Paylarına düşeni alsınlar.” ");
INSERT INTO turytc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bu olaylardan sonra bir görümde Avram’a Yahve’nin şu sözü geldi: “Korkma, ey Avram. Ben senin kalkanınım, senin çok büyük ödülünüm.” ");
INSERT INTO turytc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Avram, “Efendim Yahve, bana ne vereceksin? Ben çocuksuz gidiyorum ve evimin sahibi bu Damaskus’lu Eliezer olacaktır.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Avram, “İşte, bana çocuk vermedin” dedi, “İşte, evimde doğan mirasçım olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","İşte, ona Yahve’nin şu sözü geldi: “Bu adam senin mirasçın olmayacak, ama kendi bedeninden çıkacak olan senin mirasçın olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahve onu dışarı çıkarıp, “Gökyüzüne bak” dedi, “Eğer yıldızları sayabilirsen say.” Avram'a, “Senin soyun da böyle olacaktır” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Avram Yahve’ye iman etti ve Yahve bunu ona doğruluk saydı. ");
INSERT INTO turytc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Avram'a, “Bu toprakları miras olarak sana vermek için Keldaniler'in Ur kentinden seni çıkaran Yahve benim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","“Efendi Yahve, onu miras alacağımı nereden bileceğim?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ona, “Bana üç yaşında bir düve, üç yaşında bir keçi, üç yaşında bir koç, bir kumru ve bir güvercin yavrusu getir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Bütün bunları O’na getirdi, ortadan ikiye ayırdı ve her yarımı ötekisinin karşısına koydu; ama kuşları ayırmadı. ");
INSERT INTO turytc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yırtıcı kuşlar leşlerin üzerine kondular ve Avram onları kovdu. ");
INSERT INTO turytc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Güneş batarken Avram'ın üzerine derin bir uyku çöktü. Üzerine dehşet ve koyu bir karanlık çöktü. ");
INSERT INTO turytc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Avram'a şöyle dedi: “Şunu iyi bil ki, senin soyun, kendilerine ait olmayan bir ülkede yabancı olarak yaşayacak ve onlara hizmet edecekler. Kendilerine dört yüz yıl eziyet edecekler. ");
INSERT INTO turytc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ben de hizmet edecekleri o ulusu yargılayacağım. Sonra büyük bir servetle çıkacaklar. ");
INSERT INTO turytc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ama sen atalarına esenlikle gideceksin. İyi bir yaşta gömüleceksin. ");
INSERT INTO turytc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Dördüncü kuşakta buraya tekrar gelecekler. Çünkü Amorlular’ın suçu henüz tamamına ermedi.” ");
INSERT INTO turytc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Güneş batıp karanlık çökünce, bu parçaların arasından tüten bir fırın ve yanan bir meşale geçti. ");
INSERT INTO turytc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","O gün Yahve Avram'la bir antlaşma yaparak şöyle dedi: “Mısır Irmağı’ndan büyük ırmağa, Fırat Irmağı’na kadar bu toprakları ");
INSERT INTO turytc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","-Ken, Keniz, Kadmon, ");
INSERT INTO turytc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitit, Periz, Refa, ");
INSERT INTO turytc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor, Kenan, Girgaş ve Yevus topraklarını- senin soyuna verdim. ");
INSERT INTO turytc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Avram'ın karısı Saray ona çocuk doğurmadı. Saray’ın adı Hagar olan Mısırlı bir hizmetçisi vardı. ");
INSERT INTO turytc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray Avram'a şöyle dedi: “Bak, Yahve beni doğurmaktan alıkoydu. Lütfen hizmetçimin yanına gir. Belki ondan çocuklarım olur.” Avram, Saray'ın sözünü dinledi. ");
INSERT INTO turytc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Avram'ın karısı Saray, Avram Kenan ülkesinde on yıl yaşadıktan sonra hizmetçisi Mısırlı Hagar'ı alıp kocası Avram'a karı olarak verdi. ");
INSERT INTO turytc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Avram Hagar’ın yanına girdi ve Hagar hamile kaldı. Hagar hamile kaldığını görünce kendi hanımını hor gördü. ");
INSERT INTO turytc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saray Avram'a, “Bu senin suçun” dedi. “Hizmetçimi senin koynuna verdim, hamile kaldığını görünce beni hor gördü. Yahve benimle senin aranda hüküm versin.” ");
INSERT INTO turytc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ama Avram Saray'a, “İşte, hizmetçin senin elinde” dedi. “Gözünde iyi olan neyse onu yap.” Saray ona sert davrandı ve Hagar hanımının yanından kaçtı. ");
INSERT INTO turytc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yahve’nin meleği onu çölde, Şur yolundaki bir pınarın yanında buldu. ");
INSERT INTO turytc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Saray'ın hizmetçisi Hagar, nereden geldin?” dedi. “Nereye gidiyorsun?” O, “Hanımım Saray'ın yüzünden kaçıyorum” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yahve’nin meleği ona, “Hanımına dön ve kendini onun ellerine teslim et” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yahve’nin meleği ona, “Senin soyunu çoğalttıkça çoğaltacağım, sayılamayacak kadar çoğaltacağım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yahve’nin meleği ona, “İşte hamilesin, bir oğul doğuracaksın” dedi. “Adını İşmael koyacaksın, çünkü Yahve çektiğin sıkıntıyı işitti. ");
INSERT INTO turytc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","İnsanlar arasında yaban eşeği gibi olacak. Eli herkese karşı, herkesin eli ona karşı olacak. Kardeşlerinin hepsiyle çekişme içinde yaşayacak.” ");
INSERT INTO turytc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar kendisiyle konuşan Yahve’nin adını, “Sen gören Tanrı'sın” diye çağırdı. “O'nu görüp de hayatta mı kaldım?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Bu nedenle kuyuya, beni gören ve hayatta kalanın kuyusu anlamına gelen Beer Lahay Roy adı verildi. İşte, bu yer Kadeş ile Bered arasındadır. ");
INSERT INTO turytc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar Avram'a bir oğul doğurdu. Avram, Hagar'ın doğurduğu oğlunun adını İşmael koydu. ");
INSERT INTO turytc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar İşmael'i Avram'a doğurduğunda Avram seksen altı yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Avram doksan dokuz yaşındayken Yahve Avram'a görünüp ona şöyle dedi: “Ben Her Şeye Gücü Yeten Tanrı'yım. Önümde yürü ve suçsuz ol. ");
INSERT INTO turytc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Seninle benim aramda bir antlaşma yapacağım ve seni fazlasıyla çoğaltacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Avram yüzüstü kapandı. Tanrı onunla konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Bana gelince, işte, antlaşmam seninledir. Birçok ulusun babası olacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Artık adın Avram olarak anılmayacak, adın Avraham olacak. Çünkü seni birçok ulusun babası yaptım. ");
INSERT INTO turytc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Seni çok verimli kılacağım, senden uluslar ve krallar çıkacak. ");
INSERT INTO turytc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Senin ve soyunun Tanrısı olmak için benimle ve seninle ve senden sonra gelen soyunla yaptığım antlaşmayı kuşaklar boyu kalıcı bir antlaşma olarak sürdüreceğim. ");
INSERT INTO turytc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Geçmekte olduğun diyarı, bütün Kenan diyarını sonsuza dek mülk olarak sana ve senden sonraki soyuna vereceğim. Ben onların Tanrısı olacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tanrı Avraham’a, “Sen ve senden sonra gelen soyun kuşaklar boyu antlaşmama bağlı kalacaksınız. ");
INSERT INTO turytc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Bu, senin ve senden sonra gelen soyunla benim aramda tutacağın antlaşmadır. Aranızdaki her erkek sünnet edilecek. ");
INSERT INTO turytc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sünnet derinizden sünnet edileceksiniz. Bu sizinle benim aramdaki antlaşmanın bir işareti olacak. ");
INSERT INTO turytc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Aranızda evde doğan ya da soyunuzdan olmayıp bir yabancıdan parayla satın alınmış olan sekiz günlük her erkek çocuk kuşaklar boyunca sünnet edilecek. ");
INSERT INTO turytc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Evinizde doğan ve paranızla satın alınan mutlaka sünnet edilmelidir. Antlaşmam sonsuza dek sürecek bir antlaşma olarak bedeninizde olacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sünnet derisinden sünnet edilmemiş olan her erkek halkının arasından atılacaktır. O benim antlaşmamı bozmuştur.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tanrı Avraham’a şöyle dedi: “Karın Saray'a gelince, onun adına Saray demeyeceksin, artık onun adı Sarah olacak. ");
INSERT INTO turytc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Onu kutsayacağım ve ondan sana bir oğul vereceğim. Evet, onu kutsayacağım ve o ulusların anası olacaktır. Halkların kralları ondan çıkacak.” ");
INSERT INTO turytc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Avraham yüzüstü yere kapandı, güldü ve yüreğinde şöyle dedi: “Yüz yaşına gelenin çocuğu olur mu? Doksan yaşındaki Sarah doğurur mu?” ");
INSERT INTO turytc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Avraham Tanrı'ya, “Keşke İşmael senin önünde yaşasa!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tanrı, “Hayır, ama Sarah, senin karın sana bir oğul doğuracak” dedi. “Adını İshak koyacaksın. Onunla ve soyuyla antlaşmamı sonsuza dek sürdüreceğim. ");
INSERT INTO turytc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","İşmael'e gelince, seni işittim. İşte, onu kutsadım; onu verimli kılacağım ve onu haddinden fazla çoğaltacağım. On iki beyin atası olacak ve onu büyük bir ulus yapacağım. ");
INSERT INTO turytc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ama antlaşmamı gelecek yıl bu zamanda Sarah'ın sana doğuracağı İshak'la sürdüreceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Onunla konuşmasını bitirince, Tanrı Avraham’ın yanından yukarı çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Avraham, oğlu İşmael'i, evinde doğanların hepsini, parasıyla satın alınanların hepsini, evinde bulunan adamlar arasındaki her erkeği aldı ve Tanrı'nın kendisine buyurduğu gibi aynı gün sünnet derilerinden sünnet etti. ");
INSERT INTO turytc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Avraham sünnet derisinden sünnet olduğu zaman doksan dokuz yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Oğlu İşmael sünnet derisinden sünnet edildiğinde on üç yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aynı gün Avraham’la oğlu İşmael sünnet edildi. ");
INSERT INTO turytc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Evindeki bütün erkekler, evde doğanlar, bir yabancıdan parayla satın alınanlar, onunla birlikte sünnet oldular. ");
INSERT INTO turytc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamre meşeliği yanında, günün sıcağında çadırın kapısında otururken Yahve ona göründü. ");
INSERT INTO turytc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Gözlerini kaldırıp baktı ve üç kişinin karşısında durduğunu gördü. Onları görünce çadırın kapısından onları karşılamak için koştu ve yere kapandı. ");
INSERT INTO turytc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","O, “Efendim, eğer gözünüzde lütuf bulduysam, lütfen hizmetkârının yanından ayrılmayın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","“Şimdi biraz su getirilsin ayaklarınızı yıkayın ve ağacın altında dinlenin. ");
INSERT INTO turytc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mademki, hizmetkârının yanına geldiniz, bir parça ekmek getireyim de yüreğinizi güçlendirin. Ondan sonra yolunuza gidersiniz.” Onlar, “Pekala, dediğin gibi yap” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Avraham aceleyle çadıra, Sarah’ın yanına gidip, “Hemen üç ölçek has un hazırla, yoğur ve pide yap” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Avraham sığırlara koştu, körpe iyi bir buzağı alıp hizmetçisine verdi. Hizmetçisi hemen hazırladı. ");
INSERT INTO turytc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ayran, süt ve hazırlamış olduğu buzağıyı alıp önlerine koydu. Onlar yemek yerken o da ağacın altında yanlarında durdu. ");
INSERT INTO turytc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ona, “Karın Sarah nerede?” diye sordular. “Orada, çadırda” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","O, “Gelecek yıl bu zamanlar mutlaka yanına geleceğim” dedi. “İşte, karın Sarah'ın bir oğlu olacak.” Sarah, onun arkasındaki çadır kapısından dinliyordu. ");
INSERT INTO turytc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Avraham’la Sarah yaşlanmış, yaşları iyice ilerlemişti. Sarah çocuk doğurma yaşını geçmişti. ");
INSERT INTO turytc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah kendi kendine gülerek, “Bu yaştan sonra böyle bir sevinci tadabilir miyim? Efendim de yaşlandı.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahve Avraham'a şöyle dedi: “Sarah, ‘Yaşlılığımda gerçekten çocuk doğuracak mıyım?’ diyerek neden güldü? ");
INSERT INTO turytc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yahve için zor bir şey var mı? Belirlenen zamanda, mevsimi geldiğinde sana döneceğim ve Sarah'ın bir oğlu olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bunun üzerine Sarah, korktuğu için, “Gülmedim” diyerek bunu inkâr etti. Yahve, “Hayır, güldün” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Adamlar oradan kalkıp Sodom'a baktılar. Avraham onları yolcu etmek için onlarla birlikte gitti. ");
INSERT INTO turytc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahve, “Yapmakta olduğum şeyi Avraham’dan mı gizleyeceğim?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","“Avraham kesin olarak büyük ve güçlü bir ulus olacak, yeryüzünün bütün ulusları onda kutsanacaklar. ");
INSERT INTO turytc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Çünkü doğru ve adil olanı yaparak yolumda yürümeyi kendisinden sonra çocuklarına ve ev halkına buyursun diye onu tanıdım. Öyle ki, Yahve onun hakkında söylemiş olduğunu Avraham’ın üzerine getirsin.” ");
INSERT INTO turytc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yahve şöyle dedi: “Sodom ve Gomora'nın feryadı büyük ve günahları çok ağır olduğundan, ");
INSERT INTO turytc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","şimdi aşağı inip yaptıklarının bana gelen haberler kadar kötü olup olmadığına bakacağım. Değilse, bileceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Adamlar oradan dönüp Sodom'a doğru gittiler, ama Avraham hâlâ Yahve’nin huzurunda duruyordu. ");
INSERT INTO turytc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Avraham yaklaşıp şöyle dedi: “Doğruyu kötüyle birlikte mi yok edeceksin? ");
INSERT INTO turytc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ya kentte elli doğru varsa? O yeri içinde bulunan elli doğru için esirgemeyecek misin? ");
INSERT INTO turytc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Böyle yapmak senden uzak olsun. Doğru kişiyi kötüyle bir tutup doğruyu kötüyle birlikte öldürmek senden uzak olsun. Tüm dünyanın Yargıcı’nın adil olması gerekmez mi?” ");
INSERT INTO turytc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahve, “Eğer Sodom'da kentin içinde elli doğru kişi bulursam, onların hatırına tüm kenti esirgeyeceğim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Avraham şöyle yanıt verdi: “İşte, ben toz ve kül olduğum halde Efendi’yle konuşma cesaretini göstereceğim. ");
INSERT INTO turytc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ya elli doğru kişiden beş eksik olursa? Beş kişi eksik diye tüm kenti yok edecek misin?” Yahve, “Eğer orada kırk beş kişi bulursam kenti yok etmeyeceğim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","O’nunla tekrar konuşup, “Ya orada kırk kişi bulunursa?” dedi. Yahve, “Kırk kişinin hatırı için yapmayacağım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","O, “Efendi kızmasın, ben söyleyeceğim” dedi. “Ya orada otuz kişi bulunursa?” Yahve, “Orada otuz kişi bulursam yapmayacağım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","O, “İşte, Efendi’yle konuşma cesaretini gösteriyorum” dedi. “Ya orada yirmi kişi bulunursa?” Yahve, “Yirmi kişi için kenti yok etmeyeceğim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“Efendi kızmasın” dedi, “Bir kez daha konuşacağım. Ya orada on kişi bulunursa?” Yahve, “On kişinin hatırı için yok etmeyeceğim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahve, Avraham’la konuşmasını bitirince yoluna gitti, Avraham da yerine döndü. ");
INSERT INTO turytc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","İki melek akşam Sodom'a geldiler. Lut, kentin kapısında oturuyordu. Lut onları gördü ve karşılamak için ayağa kalktı. Yüzüstü yere kapanarak, ");
INSERT INTO turytc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Efendilerim, şimdi lütfen hizmetkârınızın evine gelin, geceyi geçirin, ayaklarınızı yıkar, erken kalkıp yolunuza gidersiniz.” Onlar, “Hayır, biz geceyi meydanda geçireceğiz” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lut çok ısrar etti ve onunla birlikte içeri gelip evine girdiler. Onlara bir ziyafet verdi ve mayasız ekmek pişirdi ve yediler. ");
INSERT INTO turytc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ama onlar yatmadan önce kentin erkekleri, Sodom'un erkekleri, genç yaşlı, her mahalleden bütün halk evi kuşattı. ");
INSERT INTO turytc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lut'a seslenip ona: “Bu gece yanına gelen adamlar nerede? Onları bize getir de onlarla yatalım” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut kapıya çıktı ve kapıyı arkasından kapattı. ");
INSERT INTO turytc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Kardeşlerim, lütfen böyle bir kötülük yapmayın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","“Bakın, erkek eli değmemiş iki kızım var. Onları size getireyim, ne isterseniz yapın. Yalnız bu adamlara bir şey yapmayın, çünkü onlar benim çatımın gölgesi altına girdiler.” ");
INSERT INTO turytc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Geri çekil!” dediler. Sonra, “Bu adam yabancı olarak yaşamak için geldi ve kendini yargıç sayıyor. Şimdi seni onlardan beter ederiz!” Lut’u çok zorladılar ve kapıyı kırmak için yaklaştılar. ");
INSERT INTO turytc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ama adamlar ellerini uzatıp Lut'u eve, yanlarına getirdiler ve kapıyı kapattılar. ");
INSERT INTO turytc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Evin kapısındaki adamları büyük küçük hepsini körlükle vurdular, öyle ki kapıyı aramaktan bitkin düştüler. ");
INSERT INTO turytc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Adamlar Lut'a, “Burada başka kimsen var mı? Damadın, oğulların, kızların ve kentte kimlerin varsa onları oradan çıkar. ");
INSERT INTO turytc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Çünkü burayı yok edeceğiz. Çünkü Yahve’nin önünde onların feryadı çok büyüdü. Yahve kenti yok etmemiz için bizi gönderdi.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lut dışarı çıktı, kızlarının sözlüleri olan adamlarla konuştu ve “Kalkın! Buradan uzaklaşın, çünkü Yahve kenti yok edecek!” dedi. Ama damatları onun şaka yaptığını sandı. ");
INSERT INTO turytc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sabah olunca melekler Lut'a, “Kalk! Karını ve burada olan iki kızını al, öyle ki kentin kötülüğü sizi de yutmasın.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ama Lut yavaş davrandı ve adamlar onun, karısının ve iki kızının elinden tuttular. Yahve ona merhamet etti, onu tutup kentin dışına koydular. ");
INSERT INTO turytc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Onları dışarı çıkardıklarında adamlardan biri, “Hayatını kurtarmak için kaç!” dedi. “Arkana bakma ve ovada hiçbir yerde durma. Dağlara kaçın yoksa, mahvolursunuz!” ");
INSERT INTO turytc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lut onlara, “Aman, efendim!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","“İşte şimdi, hizmetkârın gözünde iyilik buldu ve hayatımı kurtarmakla bana gösterdiğin lütfunu büyüttün. Dağa kaçamam, yoksa kötülük beni yakalar ve ölürüm. ");
INSERT INTO turytc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","İşte, bu kent kaçmak için yakın ve küçük bir kenttir. O küçük yere kaçmama izin verin ki, canım kurtulsun.” ");
INSERT INTO turytc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ona, “İşte, hakkında söylediğin kenti yıkmayacağıma ilişkin isteğini kabul ettim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","“Acele et, oraya kaç, çünkü sen oraya varmadan ben bir şey yapamam.” Bu nedenle o kente Soar adı verildi. ");
INSERT INTO turytc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut Soar'a geldiğinde güneş yer üzerine doğmuştu. ");
INSERT INTO turytc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Yahve Sodom ve Gomora üzerine gökten kükürt ve ateş yağdırdı. ");
INSERT INTO turytc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","O kentleri, bütün ovayı, kentlerde oturanların hepsini, toprakta yetişen her şeyi yerle bir etti. ");
INSERT INTO turytc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ama Lut'un karısı onun arkasından bakınca tuzdan bir sütun oldu. ");
INSERT INTO turytc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Avraham sabah erkenden kalkıp Yahve’nin önünde durmuş olduğu yere gitti. ");
INSERT INTO turytc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom ve Gomora'ya ve bütün ovaya baktı ve yerden dumanın ocak dumanı gibi yükseldiğini gördü. ");
INSERT INTO turytc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tanrı ovadaki kentleri yok ettiğinde, Tanrı Avraham’ı hatırladı ve Lut'un yaşadığı kentleri yerle bir ettiği zaman, Lut'u yıkımın ortasından dışına gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut Soar'dan çıkıp iki kızıyla birlikte dağda yaşadı. Çünkü Soar'da yaşamaktan korkuyordu. İki kızıyla birlikte bir mağarada yaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Büyük olan küçüğüne, “Babamız yaşlı” dedi, “Yeryüzünde, dünya geleneklerine göre yanımıza girecek kimse yok. ");
INSERT INTO turytc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Gel, babamıza şarap içirelim ve babamızın soyunu korumak için onunla yatalım.” ");
INSERT INTO turytc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","O gece babalarına şarap içirdiler. Büyük kız içeri girip babasıyla yattı. Lut yatıp kalktığını bilmiyordu. ");
INSERT INTO turytc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ertesi gün büyük olan küçüğüne, “İşte, dün gece babamla yattım. Bu gece ona yine şarap içirelim. Babamızın soyunu koruyabilmek için içeri girip onunla sen de yat.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","O gece de babalarına şarap içirdiler. Küçük kız babasıyla yattı. Ama Lut yatıp kalktığını bilmiyordu. ");
INSERT INTO turytc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Böylece Lut'un iki kızı da babalarından hamile kaldılar. ");
INSERT INTO turytc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Büyük olanın bir oğlu oldu, adını Moav koydu. O bugünkü Moavlılar’ın atasıdır. ");
INSERT INTO turytc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Küçük olanın da bir oğlu oldu ve adını Ben Ammi koydu. O da bugünkü Ammonlular’ın atasıdır. ");
INSERT INTO turytc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Avraham oradan Güney bölgesine gitti ve Kadeş ile Şur arasında yaşadı. Gerar'da bir yabancı olarak yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Avraham karısı Sarah için, “O benim kız kardeşimdir” dedi. Gerar Kralı Avimelek adam gönderip Sarah'ı aldı. ");
INSERT INTO turytc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ama Tanrı, geceleyin bir düşte Avimelek'e gelip ona şöyle dedi: “Aldığın kadın yüzünden işte, sen bir ölüsün; çünkü o bir adamın karısıdır.” ");
INSERT INTO turytc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Avimelek ona yaklaşmamıştı. Avimelek, “Efendim, doğru bir ulusu da öldürecek misin? ");
INSERT INTO turytc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Bana, ‘Kendisi benim kız kardeşimdir’ demedi mi? Kadın kendisi de, ‘O benim kardeşim’ dedi. Bunu temiz vicdanla, suçsuz ellerle yaptım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tanrı ona düşünde şöyle dedi: “Evet, bunu temiz vicdanla yaptığını biliyorum ve ben de seni bana karşı günah işlemekten alıkoydum. Bu yüzden ona dokunmana izin vermedim. ");
INSERT INTO turytc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Şimdi, adamın karısını geri ver. Çünkü o bir peygamberdir ve sizin için dua edecek ve siz yaşayacaksınız. Onu geri vermezsen, sen ve sana ait olan herkes mutlaka ölecek.” ");
INSERT INTO turytc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimelek sabah erkenden kalkıp bütün hizmetkârlarını çağırdı ve bütün bunları onlara söyledi. Adamlar çok korktular. ");
INSERT INTO turytc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Bunun üzerine Avimelek Avraham’ı çağırdı ve ona, “Bize ne yaptın? Sana karşı nasıl günah işledim ki, bana ve krallığıma büyük bir günah getirdin? Bana yapılmaması gereken şeyler yaptın!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avimelek Avraham’a, “Ne gördün de bu işi yaptın?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Avraham, “Çünkü, ‘Gerçekten bu yerde Tanrı korkusu yoktur’ diye düşündüm” dedi. “‘Karım yüzünden beni öldürecekler.’ ");
INSERT INTO turytc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Üstelik o gerçekten de benim kız kardeşimdir, babamın kızıdır, ama annemin kızı değildir ve benim karım oldu. ");
INSERT INTO turytc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tanrı beni babamın evinden gurbete çıkardığında, ona, ‘Bana göstereceğin iyilik budur’ dedim. Gittiğimiz her yerde benim hakkımda ‘O benim kardeşimdir’ de.” ");
INSERT INTO turytc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Avimelek davarları, sığırları, köleleri, cariyeleri alıp Avraham’a verdi, karısı Sarah'ı da geri verdi. ");
INSERT INTO turytc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Avimelek, “İşte, ülkem senin önünde” dedi. “Nerede istersen orada kal.” ");
INSERT INTO turytc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sarah’a, “İşte, kardeşine bin parça gümüş verdim” dedi. İşte, bu senin için yanında olanların hepsinin gözünde bir örtüdür. Herkesin önünde suçsuzsun.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Avraham Tanrı'ya dua etti. Böylece Tanrı Avimelek'i, karısını ve cariyelerini iyileştirdi ve çocuk doğurdular. ");
INSERT INTO turytc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Çünkü Yahve, Avraham’ın karısı Sarah yüzünden Avimelek'in evindeki bütün rahimleri kapatmıştı. ");
INSERT INTO turytc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahve demiş olduğu gibi Sarah'ı ziyaret etti ve Yahve Sarah’a söylemiş olduğu sözü yerine getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah hamile kaldı ve Avraham’ın yaşlılığında, tam Tanrı'nın belirttiği zamanda bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Avraham, Sarah'ın kendisine doğurduğu oğlunun adını İshak koydu. ");
INSERT INTO turytc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Avraham, Tanrı'nın kendisine buyurduğu gibi, oğlu İshak'ı sekiz günlükken sünnet etti. ");
INSERT INTO turytc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Avraham, oğlu İshak kendisine doğduğu zaman yüz yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah, “Tanrı beni güldürdü” dedi. “Duyan herkes benimle birlikte gülecek.” ");
INSERT INTO turytc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sarah, “Sarah'ın çocuk emzireceğini Avraham’a kim derdi?” dedi. “Çünkü yaşlılığında ona bir oğul doğurdum.” ");
INSERT INTO turytc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Çocuk büyüdü ve sütten kesildi. Avraham, İshak'ın sütten kesildiği gün büyük bir ziyafet verdi. ");
INSERT INTO turytc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarah, Mısırlı Hagar’ın Avraham’a doğurduğu oğlunun alay ettiğini gördü. ");
INSERT INTO turytc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Bu nedenle Avraham’a, “Bu hizmetçiyle oğlunu kov!” dedi. “Çünkü bu hizmetçinin oğlu, oğlum İshak'ın mirasçısı olmayacak.” ");
INSERT INTO turytc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Oğlu olduğundan bu durum Avraham’ı çok üzdü. ");
INSERT INTO turytc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tanrı Avraham’a şöyle dedi: “Oğlun ve hizmetçin için üzülme. Sarah'ın sana söylediği her şeyde, onun sözünü dinle. Çünkü senin soyun İshak’ın adından çıkacak. ");
INSERT INTO turytc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hizmetçinin oğlundan da bir ulus yaratacağım, çünkü o da senin çocuğundur.” ");
INSERT INTO turytc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Avraham sabah erkenden kalktı, ekmekle bir su tulumu aldı ve Hagar’ın omzuna attı, çocuğu da verip onu gönderdi. Hagar gidip Beer-Şeva çölünde dolaştı. ");
INSERT INTO turytc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tulumdaki su bitince çocuğu bir çalının altına bıraktı. ");
INSERT INTO turytc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Gidip karşıda bir ok atımı kadar uzakta oturdu. Çünkü, “Çocuğun ölümünü görmeyeyim” dedi. Karşıda oturup yüksek sesle ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Tanrı çocuğun sesini duydu. Tanrı'nın meleği gökyüzünden Hagar’a seslenip ona şöyle dedi: “Neyin var, Hagar? Korkma çünkü Tanrı, bulunduğu yerde çocuğun sesini işitti. ");
INSERT INTO turytc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kalk, çocuğu kaldır, elinle tut. Çünkü onu büyük bir ulus yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tanrı Hagar’ın gözlerini açtı ve bir su kuyusu gördü. Gidip tulumu suyla doldurdu ve çocuğa içirdi. ");
INSERT INTO turytc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tanrı çocukla birlikteydi ve büyüdü. Çölde yaşadı ve büyüyünce okçu oldu. ");
INSERT INTO turytc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paran Çölü'nde yaşadı. Annesi ona Mısır diyarından bir eş aldı. ");
INSERT INTO turytc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","O sırada Avimelek'le ordusunun komutanı Fikol Avraham’a şöyle dediler: “Yaptığın her şeyde Tanrı seninledir. ");
INSERT INTO turytc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Şimdi, ne bana, ne oğluma, ne de oğlumun oğluna karşı haksızlık etmeyeceğine dair Tanrı önünde bana ant iç. Bana ve konuk olarak yaşadığın bu ülkeye, benim sana yaptığım gibi davranacaksın.” ");
INSERT INTO turytc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Avraham, “Ant içerim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Avraham, Avimelek'in adamları tarafından zorla ele geçirilen bir su kuyusundan ötürü Avimelek'e yakındı. ");
INSERT INTO turytc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Avimelek, “Bunu kimin yaptığını bilmiyorum” dedi. “Bana söylemedin ve ben de ancak bugün işittim.” ");
INSERT INTO turytc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Avraham koyun ve sığır alıp Avimelek'e verdi. İkisi bir antlaşma yaptılar. ");
INSERT INTO turytc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Avraham sürüsünden yedi dişi kuzu ayırdı. ");
INSERT INTO turytc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimelek Avraham’a, “Ayırmış olduğun bu yedi dişi kuzu ne anlama geliyor?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","O, “Bu yedi dişi kuzuyu elimden almalısın, öyle ki, bu kuyuyu benim kazdığıma tanık olsun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bu yüzden oraya Beerşeva adını verdi, çünkü ikisi de orada ant içtiler. ");
INSERT INTO turytc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Böylece Beer-Şeva'da bir antlaşma yaptılar. Avimelek, ordusunun komutanı Fikol'la birlikte kalkıp Filist ülkesine döndüler. ");
INSERT INTO turytc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Avraham Beer-Şeva'da bir ılgın ağacı dikti ve orada Ebedi Tanrı Yahve’nin adını çağırdı. ");
INSERT INTO turytc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Avraham Filist diyarında uzun süre yabancı olarak yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bu şeylerden sonra Tanrı Avraham’ı denedi ve ona, “Avraham!” dedi. O, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tanrı, “Şimdi oğlunu, sevdiğin biricik oğlun İshak'ı al ve Moriya diyarına git. Sana söyleyeceğim dağların biri üzerinde onu yakmalık sunu olarak sun.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Avraham sabah erkenden kalkıp eşeğine palan vurdu, iki uşağıyla oğlu İshak'ı da yanına aldı. Yakmalık sunu için odunları yardı ve kalkıp Tanrı'nın kendisine söylemiş olduğu yere gitti. ");
INSERT INTO turytc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Üçüncü gün Avraham gözlerini kaldırıp uzaktan o yeri gördü. ");
INSERT INTO turytc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Avraham genç adamlarına, “Eşekle beraber burada kalın” dedi. “Çocukla ben oraya gideceğiz. Tapınıp yanınıza döneceğiz.” ");
INSERT INTO turytc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Avraham yakmalık sunu odunlarını alıp oğlu İshak’a yükledi. Ateşi ve bıçağı eline aldı. İkisi birlikte gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","İshak babası Avraham’a, “Baba?” dedi. O, “Evet oğlum” dedi. O, “İşte ateş ve odun, ama yakmalık sunu için kuzu nerede?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Avraham, “Oğlum, yakmalık sunu için kuzuyu Tanrı kendisi sağlayacak” dedi. Böylece ikisi birlikte gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tanrı'nın kendisine söylemiş olduğu yere geldiler. Avraham orada bir sunak yaptı ve odunları üzerine dizdi. Oğlu İshak'ı bağlayıp onu sunağın üzerine yatırdı. ");
INSERT INTO turytc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Avraham elini uzattı ve oğlunu öldürmek için bıçağı aldı. ");
INSERT INTO turytc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yahve’nin meleği gökten ona, “Avraham, Avraham!” diye seslendi. Avraham, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Çocuğa elini sürme, ona bir şey yapma” dedi. “Şimdi, biricik oğlunu benden esirgemediğin için Tanrı'dan korktuğunu biliyorum.” ");
INSERT INTO turytc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Avraham gözlerini kaldırıp baktığında arkasında boynuzlarından çalılara takılmış bir koç gördü. Avraham gidip koçu aldı ve oğlunun yerine onu yakmalık sunu olarak sundu. ");
INSERT INTO turytc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Avraham o yerin adını “Yahve Yire -Yahve Sağlar- koydu. Bugüne dek söylendiği gibi, “Yahve'nin dağında sağlanacak.” ");
INSERT INTO turytc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yahve’nin meleği gökten Avraham’a ikinci kez seslendi: ");
INSERT INTO turytc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Yahve diyor ki, kendi üzerime ant içiyorum. Bunu yaptığın için, biricik oğlunu benden esirgemediğin için ");
INSERT INTO turytc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","seni fazlasıyla kutsayacağım ve soyunu göklerin yıldızları ve deniz kıyısındaki kum kadar çoğaltacağım. Senin soyun, düşmanlarının kapısını ele geçirecek. ");
INSERT INTO turytc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dünyanın bütün ulusları senin soyunla kutsanacak, çünkü sözümü dinledin.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Böylece Avraham genç adamlarının yanına döndü ve birlikte kalkıp Beer-Şeva'ya gittiler. Avraham, Beer-Şeva’da yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bundan sonra Avraham’a şu haber verildi: “İşte, Milka, kardeşin Nahor'a çocuklar doğurdu: ");
INSERT INTO turytc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","İlk oğlu Uts, kardeşi Buz, Aram'ın atası olan Kemuel, ");
INSERT INTO turytc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildaş, Yidlaf, Betuel.” ");
INSERT INTO turytc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel, Rebeka'nın babası oldu. Milka bu sekizi Avraham’ın kardeşi Nahor'a doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Adı Reuma olan cariyesi de Tebah, Gaham, Tahaş ve Maaka'yı doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah yüz yirmi yedi yıl yaşadı. Ömrü bu kadardı. ");
INSERT INTO turytc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah, Kenan ülkesindeki Kiryat-Arba'da (Hebron da denir) öldü. Avraham, Sarah için yas tutmaya ve onun için ağlamaya geldi. ");
INSERT INTO turytc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Avraham ölüsünün başından kalkıp Het oğullarına şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ben sizinle yaşayan garip ve bir yabancıyım. Yanınızda bana mülk olarak bir mezar verin ki, ölümü önümden kaldırıp gömeyim.” ");
INSERT INTO turytc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Het oğulları Avraham'a şu karşılığı verdiler: ");
INSERT INTO turytc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Efendim, bizi dinle. Sen aramızda Tanrı'nın bir beyisin. Ölünü mezarlarımızın en iyisine göm. Ölünü gömmek için hiçbirimiz mezarını senden esirgemez.” ");
INSERT INTO turytc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Avraham ayağa kalkıp ülke halkı olan Het oğullarının önünde eğildi. ");
INSERT INTO turytc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Onlara şunu söyledi: “Ölümü önümden kaldırıp gömmeme razıysanız, beni dinleyin ve benim için Sohar oğlu Efron'a rica edin. ");
INSERT INTO turytc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Tarlasının dibindeki Makpela Mağarası’nı bana satsın. Tam fiyatını huzurunuzda ödeyip mezarlık yeri olarak bana versin.” ");
INSERT INTO turytc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron, Het oğullarının arasında oturuyordu. Hititli Efron, Het oğullarının, kent kapısından giren herkesin duyacağı biçimde, Avraham’a şu karşılığı verdi: ");
INSERT INTO turytc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hayır, efendim, beni dinle. Sana tarlayı ve içindeki mağarayı veriyorum. Halkımın huzurunda onu sana veriyorum. Ölünü göm.” ");
INSERT INTO turytc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Avraham ülke halkının önünde eğildi. ");
INSERT INTO turytc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ülke halkının önünde Efron'a şöyle dedi: “Lütfen beni dinle. Tarlanın bedelini ödeyeyim. Onu benden al ki ölümü oraya gömeyim.” ");
INSERT INTO turytc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron Avraham’a şu karşılığı verdi: ");
INSERT INTO turytc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Efendim, beni dinle. Seninle benim aramda dört yüz şekel gümüşlük bir toprak parçasının sözü mü olur? Ölünü göm.” ");
INSERT INTO turytc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Avraham Efron'u dinledi. Avraham, Het oğulları arasında söylemiş olduğu gümüşü Efron'a tartarak, tüccar ölçüsüne göre dört yüz şekel gümüş verdi. ");
INSERT INTO turytc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Böylece Mamre önündeki Makpela’da olan Efron’un tarlası, çevresindeki bütün ağaçlarla ve içindeki mağarayla birlikte, kent kapısında toplanan Heth oğullarının önünde Avraham’a mülk edildi. ");
INSERT INTO turytc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bundan sonra Avraham karısı Sarah'ı Kenan ülkesindeki Mamre'nin (yani Hebron'un) önündeki Makpela tarlasında bulunan mağaraya gömdü. ");
INSERT INTO turytc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tarla ve içindeki mağara, Het oğulları tarafından mezarlık yeri olmak üzere Avraham’a mülk edildi. ");
INSERT INTO turytc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Avraham kocamış ve yaşı iyice ilerlemişti. Yahve Avraham’ı her şeyde kutsamıştı. ");
INSERT INTO turytc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Avraham, evindeki en yaşlı ve kendisine ait olan her şeyi idare eden hizmetçisine, “Lütfen elini uyluğumun altına koy. ");
INSERT INTO turytc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Aralarında yaşadığım Kenanlılar’ın kızlarından oğluma kız almayacağına dair göğün Tanrısı ve yerin Tanrısı Yahve adına ant iç. ");
INSERT INTO turytc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Sen benim ülkeme ve akrabalarıma gideceksin ve oğlum İshak için bir eş alacaksın.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Hizmetçi, “Ya kız benim ardımca bu ülkeye gelmek istemezse? Oğlunu geldiğin ülkeye geri götüreyim mi?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Avraham ona, “Sakın oğlumu oraya götürme” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“Beni babamın evinden ve doğduğum ülkeden alan, benimle konuşup, ‘Bu ülkeyi senin soyuna vereceğim’ diye ant içen göklerin Tanrısı Yahve, senin önünde meleğini gönderecek ve oğlum için oradan bir eş alacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Eğer kız senin ardınca gelmek istemezse, sen de bu anttan özgür olursun. Yalnız oğlumu oraya götürmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hizmetçi elini efendisi Avraham’ın uyluğunun altına koydu ve bu konuda ona ant içti. ");
INSERT INTO turytc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hizmetçi, efendisinin develerinden on tanesini alıp yanında efendisinden çeşitli güzel şeyler alarak yola çıktı. Kalkıp Mezopotamya'ya, Nahor’un kentine gitti. ");
INSERT INTO turytc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Akşam vakti, kadınların su çekmek için dışarı çıktıkları sırada, develerini kentin dışında, su pınarının yanına çöktürdü. ");
INSERT INTO turytc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Hizmetçi, “Efendim Avraham'ın Tanrısı Yahve, lütfen bugün beni başarılı kıl” dedi, “Efendim Avraham’a iyilik et. ");
INSERT INTO turytc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","İşte, pınarının başında duruyorum. Kent halkının kızları su çekmeye çıkıyorlar. ");
INSERT INTO turytc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Birine, ‘Lütfen testini indir de içeyim’ diyeceğim. O da, “İç, develerine de içireyim’ derse bileceğim ki, hizmetkârın İshak için belirlemiş olduğun kızdır. Bununla efendime iyilik ettiğini anlayacağım.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","O sözünü bitirmeden, işte, Avraham’ın kardeşi Nahor'un karısı olan Milka'nın oğlu Betuel’e doğmuş olan Rebeka, omzunda testisiyle dışarı çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Erkek eli değmemiş olan genç kız bakılışta çok güzeldi. Pınara indi, testisini doldurup çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Hizmetçi koşup onu karşıladı, “Lütfen testinden bana biraz su ver, içeyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“İç, efendim” dedi. Hemen testisini indirdi, içmesi için ona su verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ona su verdikten sonra, “Develerin için de doyuncaya dek su çekeyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Çabucak testisini tekneye boşalttı ve su çekmek için tekrar kuyuya koştu. Onun bütün develeri için su çekti. ");
INSERT INTO turytc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Adam, Yahve’nin yolunu açık edip etmediğini bilmek için sessizce genç kızı izliyordu. ");
INSERT INTO turytc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Develer su içmeyi bitirince adam yarım şekel ağırlığında altın bir halka ve kolları için on şekel ağırlığında iki bilezik aldı. ");
INSERT INTO turytc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ona, “Kimin kızısın? Lütfen söyle. Babanın evinde kalmam için bir yer var mı?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Adama, “Ben, Milka'nın Nahor'a doğurduğu oğlu Betuel'in kızıyım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“Hem samanımız hem de yeterince yemimiz ve kalacak yerimiz de var.” ");
INSERT INTO turytc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Adam başını eğip Yahve’ye tapındı. ");
INSERT INTO turytc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Efendim Avraham’ın Tanrısı Yahve’ye övgüler olsun” dedi, “Lütfunu ve içtenliğini efendimden esirgemedi. Bana da, efendimin akrabalarının evine giden yolu Yahve gösterdi.” ");
INSERT INTO turytc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Genç kız koşarak annesinin evine bu sözleri bildirdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka'nın bir erkek kardeşi vardı, adı Lavan'dı. Lavan adama, pınara koştu. ");
INSERT INTO turytc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kız kardeşinin burnundaki halkayı, kollarındaki bilezikleri görmüştü. Lavan kız kardeşi Rebeka'nın, “Adam bana böyle söyledi” sözlerini duyunca, adamın yanına geldi. İşte, o pınar başında develerin yanında duruyordu. ");
INSERT INTO turytc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Ey Yahve’nin kutsadığı adam içeri gel” dedi. “Neden dışarıda duruyorsun? Çünkü senin için evi, develer için de yer hazırladım.” ");
INSERT INTO turytc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Adam eve girdi ve develerin yüklerini boşalttı. Develere saman ve yem, adamla yanındakilere ayaklarını yıkamaları için su verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Önüne yemek konuldu, ama o, “Neden geldiğimi söylemeden yemek yemeyeceğim” dedi. Lavan, “Öyleyse söyle” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Adam, “Ben Avraham’ın hizmetçisiyim. ");
INSERT INTO turytc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahve efendimi çok kutsadı. O büyük oldu. Ona davar, sığır, altın, gümüş, erkek ve kadın hizmetçiler, develer, eşekler verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Karısı Sarah ona ileri yaşta bir oğul doğurdu. Efendim sahip olduğu her şeyi oğluna verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Efendim, ‘Ülkelerinden yaşadığım Kenanlılar’dan oğluma kız almayacaksın. Oğluma kız almak için babamın evine, akrabalarımın yanına gideceksin’ diye bana ant içirdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Efendime, ‘Ya kadın ardımdan gelmezse?’ diye sordum. ");
INSERT INTO turytc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bana, ‘Huzurunda yürüdüğüm Yahve meleğini seninle gönderecek ve yolunu açık edecek’ dedi. ‘Oğluma akrabalarımdan ve babamın evinden bir eş alacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Akrabalarıma vardığında o zaman andından özgür olacaksın. Eğer onu sana vermezlerse andından özgür olmuş olursun.’ ");
INSERT INTO turytc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Bugün pınara geldim ve şöyle dedim: ‘Efendim Avraham’ın Tanrısı Yahve, şimdi yürüdüğüm yolu aç. ");
INSERT INTO turytc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","İşte, bu pınarın başında duruyorum. Su çekmeğe gelen kızlardan birine, lütfen testinden bana biraz su ver içeyim, diyeceğim. ");
INSERT INTO turytc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","O da iç, develerin için de su çekeyim, derse, bileceğim ki efendimin oğlu için Yahve’nin seçtiği kız odur.’ ");
INSERT INTO turytc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Daha yüreğimden bunları söylemeyi bitirmeden, işte, Rebeka testisi omzunda dışarı çıktı. Pınara gitti ve su çekti. Ona, ‘Lütfen su ver içeyim’ dedim. ");
INSERT INTO turytc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hemen testisini omzundan indirip, ‘İç, develerine de içireyim’ dedi. Ben içtim, develere de su verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ona, ‘Kimin kızısın sen?’ diye sordum. ‘Milka’nın Nahor’a doğurduğu Betuel’in kızıyım’ dedi. Bunun üzerine burnuna halka, kollarına bilezikler taktım. ");
INSERT INTO turytc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Başımı eğip Yahve’ye tapındım ve efendim Avraham’ın Tanrısı Yahve’yi yücelttim. ");
INSERT INTO turytc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Şimdi, efendime karşı iyilik ve içtenlikle davranacaksanız, bana söyleyin. Yoksa, bana bildirin ki, sağa ya da sola döneyim.” ");
INSERT INTO turytc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lavan'la Betuel, “Bu iş Yahve'den geliyor” diye yanıtladılar. Sana iyi ya da kötü diyemeyiz. ");
INSERT INTO turytc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","İşte Rebeka karşındadır. Onu al ve git ve Yahve’nin söylediği gibi, efendinin oğlunun karısı olsun.” ");
INSERT INTO turytc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Avraham’ın hizmetçisi onların sözlerini duyunca, Yahve’nin önünde yere kapandı. ");
INSERT INTO turytc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hizmetçi gümüş, altın takımlar ve giysiler çıkarıp Rebeka'ya verdi. Erkek kardeşine ve annesine de değerli şeyler verdi. ");
INSERT INTO turytc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kendisi ve yanındakiler yiyip içtiler ve geceyi orada geçirdiler. Sabah kalktılar ve o, “Beni efendime gönderin” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ağabeyi ve annesi, “Kız birkaç gün bizimle kalsın, hiç olmazsa on gün” dediler. “Ondan sonra gider.” ");
INSERT INTO turytc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Onlara, “Bana engel olmayın” dedi, “Çünkü Yahve yolumu açtı. Beni gönderin de efendime gideyim.” ");
INSERT INTO turytc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Onlar, “Kızı çağırıp ona soralım” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeka'yı çağırıp ona, “Bu adamla gider misin?” diye sordular Rebeka, “Giderim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kız kardeşleri Rebeka’yı dadısıyla birlikte, Avraham’ın hizmetçisi ve adamlarıyla birlikte gönderdiler. ");
INSERT INTO turytc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebeka'yı kutsayarak ona, “Kız kardeşimiz, binlerin, onbinlerin anası olasın, soyun kendilerinden nefret edenlerin kapılarını sahiplensinler” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka genç hizmetçileriyle birlikte kalktı. Develere binip hizmetçiyi izlediler. Hizmetçi, Rebeka'yı alıp gitti. ");
INSERT INTO turytc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","İshak, Güney bölgesinde yaşadığı için Beer-Lahai-Roi yolundan geldi. ");
INSERT INTO turytc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","İshak akşama doğru düşünmek için tarlaya gitti. Gözlerini kaldırdı ve baktı. İşte, develer geliyordu. ");
INSERT INTO turytc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka gözlerini kaldırdı ve İshak'ı görünce deveden indi. ");
INSERT INTO turytc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Hizmetçiye, “Bizi karşılamak için kırda yürüyen adam kim?” dedi. Hizmetçi, “Efendimdir” dedi. Peçesini alıp örtündü. ");
INSERT INTO turytc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Uşak yaptığı her şeyi İshak'a anlattı. ");
INSERT INTO turytc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","İshak onu annesi Sarah'ın çadırına getirdi, Rebeka'yı aldı ve Rebeka onun karısı oldu. Onu sevdi. Böylece İshak, annesinin ölümünden sonra teselli buldu. ");
INSERT INTO turytc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Avraham başka bir eş aldı, adı Ketura'ydı. ");
INSERT INTO turytc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ona Zimran’ı, Yokşan’ı, Medan’ı, Midyan’ı, İşbak’ı ve Şuah'ı doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokşan, Şeva'yla Dedan'ın babası oldu. Dedan'ın oğulları, Aşurlular, Letuşlular ve Leumlular’dır. ");
INSERT INTO turytc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyan'ın oğulları, Efa, Efer, Hanok, Avida, Eldaa’dır. Bunların hepsi Ketura'nın çocuklarıydı. ");
INSERT INTO turytc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Avraham sahip olduğu her şeyi İshak'a verdi. ");
INSERT INTO turytc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Avraham, cariyelerinin oğullarına ise hediyeler verdi. Henüz hayatta iken onları oğlu İshak'tan doğuya, doğu ülkesine gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Avraham’ın yaşadığı ömür yıllarının günleri bunlardır: Yüz yetmiş beş yıl. ");
INSERT INTO turytc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Avraham kocamış, yıllara doymuş olarak güzel ihtiyarlıkta ruhunu teslim etti. Ölüp halkına kavuştu. ");
INSERT INTO turytc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Oğulları İshak'la İşmael onu Mamre karşısındaki Makpela Mağarası'na, Hititli Zohar'ın oğlu Efron'un tarlasına gömdüler. ");
INSERT INTO turytc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Avraham o tarlayı Hetoğulları'ndan satın almıştı. Avraham, karısı Sarah ile birlikte oraya gömüldü. ");
INSERT INTO turytc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Tanrı, Avraham’ın ölümünden sonra oğlu İshak'ı kutsadı. İshak, Beer-Lahai-Roi’de yaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sarah'ın hizmetçisi Mısırlı Hagar'ın Avraham’a doğurduğu Avraham oğlu İşmael'in soylarının öyküsü şöyledir. ");
INSERT INTO turytc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Doğum sırasına göre İşmaeloğulları’nın adları şunlardır: İlk oğlu Nevayot. Sonra Kedar, Adbeel, Mivsam, ");
INSERT INTO turytc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mişma, Duma, Massa, ");
INSERT INTO turytc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Yetur, Nafiş ve Kedema’dır. ");
INSERT INTO turytc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","İşmael’in oğulları bunlardır; köylerine ve ordugâhlarına göre adları şunlardır: Uluslarına göre on iki beydiler. ");
INSERT INTO turytc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","İşmael'in ömrünün yılları yüz otuz yedi yıldı. Ruhunu teslim edip öldü ve halkına kavuştu. ");
INSERT INTO turytc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Havila'dan Aşur'a doğru giderken Mısır’ın yakınındaki Şur arasındaki bölgeye yerleştiler. Akrabalarının hepsinin karşısında yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Avraham’ın oğlu İshak'ın soylarının öyküsü şöyledir. Avraham, İshak'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","İshak Aramlı Lavan'ın kız kardeşi Paddan Aram'dan Arami Betuel'in kızı Rebeka'yı kendisine eş olarak aldığında kırk yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","İshak, karısı kısır olduğu için Yahve’ye yakardı. Yahve yalvarışını kabul etti ve karısı Rebeka hamile kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Çocuklar onun içinde itiştiler. Rebeka, “Madem böyle, ben niye yaşıyorum” dedi. Yahve’ye danışmaya gitti. ");
INSERT INTO turytc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahve ona şöyle dedi: “Rahminde iki ulus var. Bedeninden iki halk ayrılacak. Biri diğerinden güçlü olacak. Büyüğü küçüğüne hizmet edecek.” ");
INSERT INTO turytc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Doğum vakti geldiğinde, işte, rahminde ikizler vardı. ");
INSERT INTO turytc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Birincisinin her yeri kıllı bir giysi gibi kıpkırmızı doğdu. Adını Esav koydular. ");
INSERT INTO turytc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Bundan sonra kardeşi doğdu ve eli Esav'ın topuğundaydı. Adı Yakov koyuldu. Rebeka onları doğurduğunda İshak altmış yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Çocuklar büyüdüler. Esav yetenekli bir avcıydı, bir kır adamı oldu. Yakov çadırlarda yaşayan sakin bir adamdı. ");
INSERT INTO turytc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","İshak Esav'ı severdi, çünkü onun av etini yerdi. Rebeka, Yakov’u severdi. ");
INSERT INTO turytc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yakov çorba pişiriyordu. Esav kırdan geldi ve aç ve bitkindi. ");
INSERT INTO turytc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esav Yakov'a, “Lütfen bana şu kızıl çorbandan yedir, çünkü aç ve bitkinim” dedi. Bu nedenle ona Edom adı verildi. ");
INSERT INTO turytc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakov, “Önce bana ilk oğulluk hakkını sat” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esav, “İşte, ben ölmek üzereyim” dedi. “İlk oğulluk hakkımın bana ne faydası var?” ");
INSERT INTO turytc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakov, “Önce ant iç” dedi. Esav ant içti. İlk oğulluk hakkını Yakov'a sattı. ");
INSERT INTO turytc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakov Esav'a ekmekle mercimek çorbası verdi. Yedi, içti, kalkıp yoluna gitti. Böylece Esav ilk oğulluk hakkını hor gördü. ");
INSERT INTO turytc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Avraham’ın günlerinde olan ilk kıtlıktan başka, ülkede bir kıtlık daha oldu. İshak, Filist Kralı Avimelek'e, Gerar'a gitti. ");
INSERT INTO turytc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahve ona görünüp, “Mısır'a inme” dedi, “Sana söyleyeceğim ülkede yaşa. ");
INSERT INTO turytc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Bu ülkede yaşa, ben seninle olacağım ve seni kutsayacağım. Çünkü bütün bu toprakları sana ve soyuna vereceğim, baban Avraham’a verdiğim sözü pekiştireceğim. ");
INSERT INTO turytc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Soyunu gökyüzünün yıldızları kadar çoğaltacağım ve bütün bu toprakları senin soyuna vereceğim. ");
INSERT INTO turytc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Çünkü Avraham sözümü dinledi, uyarılarımı, buyruklarımı, kurallarımı, ilkelerimi yerine getirdi.” ");
INSERT INTO turytc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","İshak Gerar'da yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","O yörenin erkekleri ona karısını sordular. “Karım” demekten korktuğu için “O benim kız kardeşimdir” dedi, “Oranın adamları Rebeka için beni öldürebilir, çünkü o çok güzel” diye düşündü. ");
INSERT INTO turytc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Orada uzun süre kaldıktan sonra, Filist Kralı Avimelek pencereden dışarı bakıp gördü ve işte, İshak karısı Rebeka'yı okşuyordu. ");
INSERT INTO turytc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimelek İshak'ı çağırıp, “Bak, o gerçekten senin karın” dedi. “Neden ‘O benim kız kardeşim’ dedin?” İshak ona, “Çünkü ‘Onun yüzünden ölmeyeyim’ dedim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimelek, “Bize bu yaptığın nedir? Halkımdan birisi karınla kolayca yatabilirdi ve sen de suçu üzerimize atmış olurdun!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Avimelek halka, “Bu adama ya da karısına dokunan kesin olarak öldürülecek” diye buyruk verdi. ");
INSERT INTO turytc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","İshak o ülkede ekti ve aynı yıl ektiğinin yüz katını biçti. Yahve onu kutsamıştı. ");
INSERT INTO turytc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","İshak büyüdü ve gittikçe daha da büyüdü. ");
INSERT INTO turytc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sürüleri, sığırları ve evinde çok sayıda hizmetçisi vardı. Filistliler onu kıskandılar. ");
INSERT INTO turytc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Filistliler, babası Avraham’ın günlerinde babasının hizmetkârlarının kazmış olduğu bütün kuyuları toprakla doldurup kapadılar. ");
INSERT INTO turytc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Avimelek, İshak'a, “Yanımızdan git, çünkü bizden daha güçlü oldun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","İshak oradan ayrılıp Gerar Vadisi'nde konakladı ve orada yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","İshak, babası Avraham’ın günlerinde kazdıkları su kuyularını yeniden açtı. Çünkü Avraham’ın ölümünden sonra Filistliler onları kapatmışlardı. Babasının onlara verdiği aynı adlarla onları adlandırdı. ");
INSERT INTO turytc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","İshak'ın hizmetçileri vadide kazdılar ve orada bir kaynak buldular. ");
INSERT INTO turytc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerar'ın çobanları İshak'ın çobanlarıyla tartışıp, “Su bizimdir” dediler. Onunla çekiştikleri için kuyuya Esek adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Başka bir kuyu kazdılar ve bu kuyu için de kavga ettiler. Sitna adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Oradan ayrılıp başka bir kuyu kazdılar. Bunun için kavga etmediler. Bu yüzden ona Rehovot adını verdi. “Çünkü Yahve bize şimdi yer verdi ve biz bu ülkede verimli olacağız.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Oradan Beer-Şeva'ya çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Aynı gece Yahve ona görünüp şöyle dedi: “Ben baban Avraham’ın Tanrısı’yım. Korkma, çünkü ben seninleyim ve seni kutsayacağım ve hizmetkârım Avraham’ın hatırı için soyunu çoğaltacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","İshak orada bir sunak yaptı, Yahve’yi adıyla çağırdı ve çadırını oraya kurdu. Orada İshak'ın hizmetkârları bir kuyu kazdılar. ");
INSERT INTO turytc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Avimelek, dostu Ahuzzat ve ordusunun komutanı Fikol ile Gerar'dan İshak’ın yanına geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","İshak onlara, “Benden nefret ettiğiniz halde neden yanıma geldiniz? Üstelik beni yanınızdan göndermiştiniz.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“Yahve'nin seninle olduğunu açıkça gördük” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","“Bizim sana dokunmadığımız, sana hep iyilik edip seni esenlik içinde gönderdiğimiz gibi, senin de bize hiçbir kötülük etmeyeceğine dair seninle bir antlaşma yapalım. Artık sen Yahve’nin kutsadığı kişisin.” ");
INSERT INTO turytc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","İshak onlara bir ziyafet verdi, yiyip içtiler. ");
INSERT INTO turytc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Sabah erken kalkıp birbirlerine ant içtiler. İshak onları yolcu etti ve ondan barış içinde ayrıldılar. ");
INSERT INTO turytc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Aynı gün İshak'ın hizmetkârları gelip kazdıkları kuyu hakkında ona bilgi verdiler. “Su bulduk” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kuyuya “Şiva” adını verdi. Bu nedenle kentin adı bugüne dek “Beerşeva” olarak kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esav kırk yaşındayken Hititli Beeri'nin kızı Yudit'le Hititli Elon'un kızı Basemat'ı eş olarak aldı. ");
INSERT INTO turytc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bu kadınlar İshak'la Rebeka için can sıkıntısı oldular. ");
INSERT INTO turytc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","İshak yaşlanıp gözleri görmez olduğu zaman, büyük oğlu Esav'ı çağırdı ve ona, “Oğlum?” dedi. Ona, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“Bak, ben yaşlandım” dedi. “Öleceğim günü bilmiyorum. ");
INSERT INTO turytc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Şimdi silahlarını, ok kılıfını ve yayını al, kıra çıkıp bana av eti getir. ");
INSERT INTO turytc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Sevdiğim lezzetli bir yemek yap ve bana getir de yiyeyim. Ölmeden önce canım seni kutsasın.” ");
INSERT INTO turytc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka, İshak'ın oğlu Esav'la konuştuklarını duydu. Esav avlanıp avı getirmek için kıra çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka oğlu Yakov'a şöyle dedi: “Babanın kardeşin Esav'a şöyle dediğini duydum: ");
INSERT INTO turytc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bana av getir ve lezzetli bir yemek yap da yiyeyim ve ölümümden önce seni Yahve’nin önünde kutsayayım.’ ");
INSERT INTO turytc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Şimdi oğlum, sana vereceğim buyruğu iyi dinle. ");
INSERT INTO turytc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Şimdi sürüye git ve oradan bana iki iyi oğlak getir. Onlarla babanın sevdiği lezzetli bir yemek yapacağım. ");
INSERT INTO turytc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Yemesi için onu babana götüreceksin, ölmeden önce seni kutsasın.” ");
INSERT INTO turytc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakov annesi Rebeka'ya şöyle dedi: “Kardeşim Esav kıllı bir adam, bense kılsız bir adamım. ");
INSERT INTO turytc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ya babam bana dokunursa? Ona bir düzenbaz gibi görüneceğim ve üzerime kutsama değil, lanet getireceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Annesi, “Senin lanetin benim üzerime olsun oğlum” dedi. “Sadece sözümü dinle ve git onları benim için getir.” ");
INSERT INTO turytc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gidip onları aldı ve annesine getirdi. Annesi, babasının sevdiği gibi lezzetli bir yemek yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka büyük oğlu Esav'ın evde yanında bulunan güzel giysilerini alıp küçük oğlu Yakov'a giydirdi. ");
INSERT INTO turytc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ellerine ve ensesinin tüysüz kısmına oğlak derisiyle kapladı. ");
INSERT INTO turytc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hazırladığı lezzetli yemeği ve ekmeği oğlu Yakov'un eline verdi. ");
INSERT INTO turytc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakov babasının yanına varıp, “Baba” dedi. “İşte buradayım. Sen kimsin oğlum?” ");
INSERT INTO turytc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakov babasına, “Ben senin ilk oğlun Esav'ım” dedi. “Benden yapmamı istediğin şeyi yaptım. Lütfen kalk, otur ve avımı ye ki canın beni kutsasın.” ");
INSERT INTO turytc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","İshak oğluna, “Oğlum, nasıl bu kadar çabuk buldun?” dedi. “Çünkü Tanrın Yahve beni başarılı kıldı” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","İshak Yakov'a, “Lütfen yaklaş, oğlum, gerçekten oğlum Esav mısın, değil misin, dokunayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakov babası İshak'a yaklaştı. Ona dokundu, “Ses Yakov'un sesi, ama eller Esav'ın elleridir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kardeşi Esav'ın elleri gibi elleri kıllı olduğu için onu tanımadı. Böylece onu kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Sen gerçekten oğlum Esav mısın?” dedi. Yakov, “Benim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Onu bana getir, oğlumun avından yiyeyim de canım seni kutsasın” dedi. Yanına getirdi ve yedi. Ona şarap getirdi ve içti. ");
INSERT INTO turytc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Babası İshak ona, “Yaklaş, oğlum, beni öp” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaklaşıp onu öptü. Elbisesinin kokusunu kokladı ve onu kutsayarak şöyle dedi: “İşte, oğlumun kokusu Yahve’nin kutsadığı kırın kokusu gibidir. ");
INSERT INTO turytc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tanrı sana göklerin çiyinden, yerin veriminden, bol miktarda tahıl ve yeni şarap versin. ");
INSERT INTO turytc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Halklar sana kulluk etsin, uluslar sana boyun eğsin. Kardeşlerinin efendisi ol. Annenin oğulları sana boyun eğsin. Sana lanet edenler lanetli olsun. Seni kutsayanlar kutsansın.” ");
INSERT INTO turytc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","İshak Yakov'u kutsadıktan ve Yakov babası İshak'ın yanından çıkar çıkmaz, kardeşi Esav avdan döndü. ");
INSERT INTO turytc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ayrıca lezzetli yemek yapıp babasına getirdi. Babasına, “Baba kalk ve oğlunun avından ye de canın beni kutsasın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Babası İshak ona, “Sen kimsin?” dedi. “Ben senin oğlun, ilk oğlun Esav'ım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","İshak şiddetle titredi ve şöyle dedi: “Öyleyse, av avlayan ve bana getiren kimdi? Sen gelmeden önce hepsini yedim ve onu kutsadım? O da kutsanacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esav babasının sözlerini işitince çok büyük ve acı bir feryatla ağladı ve babasına, “Beni de kutsa, ey baba” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","“Kardeşin hile ile geldi, kutsamanı elinden aldı” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esav “Ona boşuna mı Yakov diyorlar? İki kezdir beni aldatıyor. İlk oğulluk hakkımı elimden aldı. Bak, şimdi de benim kutsamamı elimden aldı.” dedi. “Benim için bir kutsama alıkoymadın mı?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","İshak, Esav'a şu karşılığı verdi: “İşte, onu senin efendin yaptım ve bütün kardeşlerini ona hizmetkâr atadım. Onu tahıl ve yeni şarapla besledim. O zaman senin için ne yapayım oğlum?” ");
INSERT INTO turytc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esav babasına, “Baba, sende yalnız bir kutsamamı var? Beni kutsa, beni de baba.” dedi. Esav yüksek sesle ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Babası İshak ona şu karşılığı verdi: “İşte, meskenin göklerin çiğinde, yerin veriminde olacak. ");
INSERT INTO turytc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kılıcınla yaşayacak ve kardeşine hizmet edeceksin. Özgür olmak isteyince, onun boyunduruğunu kırıp atacaksın.” ");
INSERT INTO turytc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esav, babasının onu kutsadığı bereket yüzünden Yakov'dan nefret ediyordu. Esav yüreğinde şöyle dedi: “Babamın yas günleri yakındır. O zaman kardeşim Yakov’u öldürürüm.” ");
INSERT INTO turytc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Büyük oğlu Esav'ın sözleri Rebeka'ya iletildi. Rebeka küçük oğlu Yakov'u çağırttı ve ona şöyle dedi: “Kardeşin Esav seni öldürmeyi tasarlayarak kendini avutuyor. ");
INSERT INTO turytc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Şimdi oğlum, sözümü dinle. Kalk, Haran'daki kardeşim Lavan'a kaç. ");
INSERT INTO turytc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Kardeşinin öfkesi yatışıp kızgınlığı geçinceye ve ona yaptığını unutuncaya dek bir süre onun yanında kal. Sonra birini gönderir, seni oradan aldırtırım. Neden bir günde ikinizden de yoksun kalayım?” ");
INSERT INTO turytc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka, İshak'a şöyle dedi: “Het'in kızları yüzünden canımdan bezdim. Yakov da Het kızlarından, ülke kızlarından bir eş alırsa, ne diye yaşayayım?” ");
INSERT INTO turytc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","İshak Yakov'u çağırdı, kutsadı ve ona, “Kenan kızlarından kendine eş almayacaksın. ");
INSERT INTO turytc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kalk, Paddan Aram'a, annenin babası Betuel'in evine git. Oradan annenin kardeşi Lavan'ın kızlarından bir eş al. ");
INSERT INTO turytc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Her Şeye Gücü Yeten Tanrı seni kutsasın, seni verimli kılıp çoğaltsın ki, halklar topluluğu olasınız. ");
INSERT INTO turytc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Avraham kutsamasını sana ve seninle birlikte soyuna versin. Öyle ki, Tanrı’nın Avraham’a verdiği ve üzerinden geçmekte olduğun diyarı miras alasın.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","İshak Yakov'u gönderdi. Paddan Aram'a, Yakov'la Esav'ın annesi Rebeka'nın kardeşi Aramlı Betuel'in oğlu Lavan'ın yanına gitti. ");
INSERT INTO turytc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Esav, İshak'ın Yakov'u kutsadığını ve bir eş alması için Paddan-Aram'a gönderdiğini ve onu kutsadığı zaman, Kenan kızlarından kendine eş almayacaksın diye buyurduğunu, Yakov’un da anne babasını dinleyerek Paddan-Aram’a gittiğini öğrendi. ");
INSERT INTO turytc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esav, babası İshak’ın Kenan kızlarından hoşlanmadığını gördü. ");
INSERT INTO turytc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Böylece Esav İşmael'e gitti. Karılarının üzerine Avraham oğlu İşmael’in kızı Nevayot'un kız kardeşi, Mahalat'ı da eş olarak aldı. ");
INSERT INTO turytc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakov Beer-Şeva'dan Harran'a doğru yola çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Bir yere gelip orada geceledi. Çünkü güneş batmıştı. Yerin taşlarından birini alıp başının altına koydu ve uyumak için o yere yattı. ");
INSERT INTO turytc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Düşünde yeryüzünün üzerine dikilmiş, tepesi göğe ulaşan bir merdiven gördü. İşte, Tanrı’nın melekleri onun üzerine inip çıkıyorlardı. ");
INSERT INTO turytc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yahve onun üzerinde durup, “Ben, atan Avraham’ın, İshak'ın Tanrısı Yahve’yim” dedi. “Üzerinde yatmakta olduğun diyarı sana ve soyuna vereceğim. ");
INSERT INTO turytc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Soyun yerin tozu gibi olacak; batıya, doğuya, kuzeye ve güneye yayılacaksınız. Yerin bütün aileleri sende ve soyunda kutsanacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","İşte, ben seninleyim, gideceğin her yerde seni koruyacağım ve seni bu diyara geri getireceğim. Çünkü sana söylediğim şeyi yapana dek seni bırakmayacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakov uykusundan uyanıp, “Yahve gerçekten burada, ben fark edemedim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Korktu ve “Bu yer ne heybetli! Burası Tanrı'nın evinden başka bir yer olamaz. Burası göğün kapısıdır.” ");
INSERT INTO turytc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakov sabah erkenden kalktı, başının altına koyduğu taşı alıp sütun yaptı, üzerine yağ döktü. ");
INSERT INTO turytc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","O yere Beytel (Tanrı’nın Evi) adını verdi. Kentin adı ilk adı Luz'du. ");
INSERT INTO turytc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakov adak adayıp şöyle dedi: “Tanrı benimle olursa, gittiğim yolda beni korursa, bana yiyecek ekmek, giyecek giysi verirse, ");
INSERT INTO turytc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","esenlik içinde babamın evine dönersem, o zaman Yahve benim Tanrım olacak. ");
INSERT INTO turytc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","O zaman sütun olarak diktiğim bu taş Tanrı'nın Evi olacak. Bana vereceğin her şeyin ondalığını mutlaka sana vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakov yola çıkıp Doğuoğulları’nın ülkesine geldi. ");
INSERT INTO turytc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Baktı ve kırda bir kuyu gördü ve yanında yatan üç koyun sürüsü vardı. Çünkü o kuyudan sürüleri su verirlerdi. Kuyunun ağzındaki taş büyüktü. ");
INSERT INTO turytc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bütün sürüler orada toplanırdı. Taşı kuyunun ağzından yuvarlarlar, koyunlara su verdikten sonra taşı tekrar kuyunun ağzına, yerine koyarlardı. ");
INSERT INTO turytc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakov onlara, “Kardeşler, nerelisiniz?” dedi. “Biz Harranlı’yız” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Onlara, “Nahor'un oğlu Lavan'ı tanır mısınız?” “Tanırız” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Onlara, “Kendisi iyi mi?” diye sordu. “İyidir. Bak, kızı Rahel koyunlarla geliyor.” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“İşte, daha gün ortası, sürülerin toplanma vakti değil” dedi. “Koyunları su verdikten sonra götürüp otlatın.” ");
INSERT INTO turytc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“Bütün sürüler bir araya toplanmadan ve kuyunun ağzındaki taşı yuvarlamadan olmaz” dediler. “Sonra koyunlara su vereceğiz.” ");
INSERT INTO turytc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Daha onlarla konuşurken, Rahel babasının koyunlarıyla geldi çünkü o çobandı. ");
INSERT INTO turytc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakov, annesinin kardeşi Lavan'ın kızı Rahel'i ve annesinin kardeşi Lavan'ın koyunlarını görünce yaklaştı, kuyunun ağzındaki taşı yuvarladı. Annesinin kardeşi Lavan'ın sürüsüne su verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakov Rahel'i öptü, yüksek sesle ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakov Rahel'e babasının akrabası ve Rebeka'nın oğlu olduğunu söyledi. O da koşarak babasına haber verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lavan, kız kardeşinin oğlu Yakov'la ilgili haberi duyunca onu karşılamaya koştu. Yakov'u kucaklayıp öptü ve onu evine götürdü. Yakov bütün olanları Lavan'a anlattı. ");
INSERT INTO turytc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lavan, “Gerçekten sen benim kemiğim ve etimsin” dedi. Yakov onun yanında bir ay kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lavan, Yakov'a, “Akrabam olduğun için bana karşılıksız mı hizmet edeceksin?” dedi. “Söyle bana, ücretin nedir?” ");
INSERT INTO turytc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lavan'ın iki kızı vardı. Büyüğünün adı Lea, küçüğünün adı Rahel'di. ");
INSERT INTO turytc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea'nın gözleri zayıftı, ama Rahel görünüş açısından güzel ve çekiciydi. ");
INSERT INTO turytc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakov Rahel'i sevdi. “Küçük kızın Rahel için sana yedi yıl hizmet ederim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lavan, “Onu başka bir adama vermektense sana vermem daha iyi” dedi. Benimle kal.” ");
INSERT INTO turytc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakov Rahel için yedi yıl hizmet etti. Ona duyduğu sevgisinden dolayı birkaç gün gibi geldi ona. ");
INSERT INTO turytc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yakov Lavan'a, “Karımı bana ver, günlerim doldu, yanına gireyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lavan yöre halkını toplayıp bir ziyafet verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Akşam kızı Lea'yı Yakov'a getirdi. Yakov onun yanına girdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lavan hizmetçisi Zilpa'yı kızı Lea’nın hizmetine verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sabah olunca Yakov bir baktı ki, yanında Lea! Lavan'a, “Bana bu yaptığın nedir?” dedi. “Sana Rahel için hizmet etmedim mi? O zaman neden beni aldattın?” ");
INSERT INTO turytc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lavan, “Küçüğü büyüğünden önce vermek bizim buralarda uygun değildir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“Bu haftayı doldur, yanımda edeceğin başka yedi yıllık hizmete karşılık onu da sana veririz.” ");
INSERT INTO turytc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakov öyle yaptı ve haftasını tamamladı. Ona kızı Rahel'i eş olarak verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lavan hizmetçisi Bilha'yı kızı Rahel’in hizmetine verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakov Rahel'in yanına girdi ve Rahel'i Lea'dan daha çok sevdi. Yakov Lavan’ın yanında yedi yıl daha hizmet etti. ");
INSERT INTO turytc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahve Lea'dan nefret edildiğini görünce onun rahmini açtı, ama Rahel kısırdı. ");
INSERT INTO turytc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea hamile kaldı ve bir erkek çocuk doğurdu, adını Ruven (Bak erkek çocuk) koydu. Çünkü, “Madem Yahve çektiğim sıkıntıyı gördü. Şimdi kocam beni sevecek.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tekrar hamile kaldı ve bir oğul doğurdu. “Yahve benden nefret edildiğini duyduğundan bana bu oğulu da verdi” dedi. Ona Şimon (Duyar) adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tekrar hamile kaldı ve bir erkek çocuk doğurdu. “Artık kocam bana bağlanacak, çünkü ona üç oğul doğurdum” dedi. “Bu nedenle çocuğa Levi (Bağlılık) adı verildi. ");
INSERT INTO turytc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tekrar hamile kaldı ve bir erkek çocuk doğurdu. “Bu sefer Yahve’yi öveceğim” dedi. Bu nedenle ona Yahuda (Övgü) adını verdi. Sonra doğum yapmayı bıraktı. ");
INSERT INTO turytc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahel Yakov'a çocuk doğuramadığını görünce kız kardeşini kıskandı. Yakov'a, “Bana çocuklar ver, yoksa öleceğim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakov Rahel'e öfkelendi ve şöyle dedi: “Ben rahmin meyvesini senden esirgeyen Tanrı'nın yerinde miyim?” ");
INSERT INTO turytc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","“İşte hizmetçim Bilha” dedi. “Yanına gir. Öyle ki, dizlerimin üzerinde doğursun da ondan çocuklarım olsun.” ");
INSERT INTO turytc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hizmetçisi Bilha'yı ona eş olarak verdi ve Yakov onun yanına girdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha hamile kaldı ve Yakov'a bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel, “Tanrı davamı gördü, sesimi işitip bana bir oğul verdi” dedi. Bu nedenle onun adını Dan (Haklı) koydu. ");
INSERT INTO turytc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahel'in hizmetçisi Bilha yine hamile kaldı ve Yakov'a ikinci bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel, “Kız kardeşimle çetin güreşler yaptım ve yendim” dedi. Ona Naftali (Güreşim) adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea artık hamile kalamadığını görünce, hizmetçisi Zilpa'yı alıp Yakov'a karı olarak verdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea'nın uşağı Zilpa Yakov'a bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea, “Uğurum!” dedi. Adını Gad (Uğur) koydu. ");
INSERT INTO turytc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea'nın hizmetçisi Zilpa Yakov'a ikinci bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea, “Ne mutlu bana, çünkü kadınlar bana mutlu diyecekler” dedi. Ona Aşer (Mutlu) adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruven buğday hasadı günlerinde gidip tarlada adamotu buldu ve annesi Lea'ya getirdi. Rahel, Lea'ya, “Lütfen bana oğlunun adamotundan biraz ver” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea ona, “Kocamı aldığın yetmiyor mu?” dedi. “Oğlumun adamotunu da mı alacaksın?” Rahel, “Öyleyse, oğlunun adamotuna karşılık kocam bu gece seninle yatacak” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Akşam Yakov tarladan geldi. Lea onu karşılamaya çıkıp, “Benim yanıma gireceksin” dedi. “Çünkü seni oğlumun adamotuyla gerçekten tuttum.” O gece onunla yattı. ");
INSERT INTO turytc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tanrı Lea'yı işitti ve hamile kaldı. Yakov'a beşinci bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea, “Hizmetçimi kocama verdiğim için Tanrı bana bedelini verdi” dedi. Ona İsakar (Bedel) adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea yine hamile kaldı ve Yakov'a altıncı bir oğul doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea, “Tanrı bana güzel bir çeyiz verdi” dedi. “Artık kocam benimle yaşayacak çünkü ona altı erkek çocuk doğurdum.” Adını Zevulun (Saygın mesken) koydu. ");
INSERT INTO turytc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sonra bir kız doğurdu, adını Dina koydu. ");
INSERT INTO turytc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tanrı Rahel'i hatırladı ve onu işitip rahmini açtı. ");
INSERT INTO turytc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hamile kaldı, bir erkek çocuk doğurdu ve “Tanrı utancımı kaldırdı” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“Yahve bana bir oğul daha versin” diyerek çocuğun adını Yosef koydu. ");
INSERT INTO turytc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel Yosef'i doğurunca Yakov Lavan'a, “Beni gönder de kendi evime, ülkeme gideyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","“Hizmetime karşılık karılarımı ve çocuklarımı ver, bırak gideyim. Çünkü sana nasıl hizmet ettiğimi biliyorsun.” ");
INSERT INTO turytc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lavan, “Eğer şimdi gözünde lütuf bulduysam, burada kal” dedi, “Çünkü Yahve’nin senin sayende beni kutsadığını anladım.” ");
INSERT INTO turytc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","“Ücretini bana bildir de vereyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakov ona, “Sana nasıl hizmet ettiğimi, sürülerine nasıl baktığımı biliyorsun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","“Çünkü ben gelmeden önce malın azdı, fazlasıyla çoğaldı. Gelişimle Yahve seni kutsadı. Şimdi ben kendi evim için ne zaman çalışacağım?” ");
INSERT INTO turytc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lavan, “Sana ne vereyim?” dedi. Yakov, “Bana bir şey vermeyeceksin” dedi. “Eğer bana şunu yaparsan, yine sürünü güderim. ");
INSERT INTO turytc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bugün bütün sürünün içinden geçip noktalı ve benekli, koyunları, kara kuzuları, benekli ve noktalı keçileri ayıracağım. Benim ücretim bu olsun. ");
INSERT INTO turytc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Bundan sonra ücretim için geldiğinde, doğruluğum benim hakkında tanıklık edecektir. Yanımda bulunan keçiler arasında noktalı ve benekli, kuzularım arasında kara olmayanların hepsi çalıntı sayılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lavan, “İşte, sözüne göre olsun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","O gün benekli ve çizgili tekeleri, noktalı ve benekli keçileri, beyaz keçilerin hepsini, bütün kara kuzuları ayırıp oğullarının eline verdi. ");
INSERT INTO turytc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kendisiyle Yakov arasında üç günlük yol bıraktı. Yakov Lavan'ın kalan sürülerini güdüyordu. ");
INSERT INTO turytc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakov kavak, badem ve çınar ağaçlarından taze çubuklar aldı. Üzerindeki kabukları soyup beyaz rengini gösteren çizgiler yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Soyduğu çubukları sürülerin su içmek için geldikleri yalaklara, sürülerin önüne koydu. Su içmek için gelince çiftleşiyorlardı. ");
INSERT INTO turytc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Çubukların önünde çiftleşince sürüler çizgili, noktalı ve benekli doğarlardı. ");
INSERT INTO turytc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakov kuzuları ayırdı ve sürülerin yüzünü Lavan'ın sürüsünün çizgili ve kara olanlarına çevirdi. Kendi sürülerini ayırdı, onları Lavan'ın sürüsüne koymadı. ");
INSERT INTO turytc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sürünün güçlü olanları kızışınca, Yakov sürünün gözü önünde, yalaklara çubuklar koyuyordu. Öyle ki, çubukların yanında çiftleşsinler. ");
INSERT INTO turytc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ama sürünün zayıf olanlarının yanına koymazdı. Böylece zayıf olanlar Lavan’ın, güçlüleriyse Yakov’un oldu. ");
INSERT INTO turytc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakov alabildiğince çoğaldı. Sürüleri, kadın ve erkek hizmetçileri, develeri, eşekleri oldu. ");
INSERT INTO turytc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakov Lavan'ın oğullarının, “Yakov babamıza ait olan her şeyi aldı. Bütün bu serveti babamızın şeylerinden elde etti.” sözlerini söylediğini işitti. ");
INSERT INTO turytc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakov Lavan'ın yüzünü gördü ve kendisine karşı eskisi gibi değildi. ");
INSERT INTO turytc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yahve Yakov'a, “Atalarının ülkesine, akrabalarının yanına dön” dedi, “Seninle birlikte olacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakov Rahel'le Lea'yı sürüsünün yanına, kıra çağırdı. ");
INSERT INTO turytc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Onlara, “Babanızın yüzünü görüyorum, bana karşı eskisi gibi değil. Ama babamın Tanrısı benimledir. ");
INSERT INTO turytc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Var gücümle babanıza hizmet ettiğimi biliyorsunuz. ");
INSERT INTO turytc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Babanız beni aldattı, ücretimi on kez değiştirdi, ama Tanrı bana kötülük etmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Benekliler senin ücretin olacak dediğinde, bütün sürü benekli doğurdu. Ücretin çizgililer olacak dediğinde bütün sürü çizgili doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Böylece Tanrı babanızın sürüsünü alıp bana verdi. ");
INSERT INTO turytc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Çiftleşme mevsiminde, gözlerimi kaldırdım ve rüyada gördüm. Baktım, çiftleşen tekeler çizgili, noktalı ve kırçıldı. ");
INSERT INTO turytc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tanrı'nın meleği rüyada bana, ‘Yakov’ dedi. ‘Burdayım’ dedim. ");
INSERT INTO turytc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Bana, ‘Bak, bütün çiftleşen tekeler çizgili, noktalı ve kırçıl’ dedi. ‘Çünkü Lavan’ın sana yaptıklarının hepsini gördüm. ");
INSERT INTO turytc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sütun üzerine mesh ettiğin, bana adak adadığın Beytel'in Tanrısı benim. Şimdi kalk, bu topraklardan çık ve doğduğun ülkeye dön.’” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahel ile Lea ona şu karşılığı verdiler: “Babamızın evinden payımız ya da mirasımız kaldı mı? ");
INSERT INTO turytc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Onun gözünde artık yabancı sayılmıyor muyuz? Çünkü bizi sattı ve bedelimizi de tamamen yedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tanrı'nın babamızdan aldığı tüm o servet bizim ve çocuklarımızındır. Şimdi, Tanrı sana ne dediyse öyle yap.” ");
INSERT INTO turytc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakov kalktı, oğullarıyla karılarını develere bindirdi. ");
INSERT INTO turytc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Babası İshak’ın yanına, Kenan ülkesine gitmek üzere bütün hayvanlarını, Paddan Aram'da kazandığı davarlar da dahil kazandığı her şeyi aldı. ");
INSERT INTO turytc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lavan koyunlarını kırkmaya gitmişti ve Rahel, babasına ait olan terafimi (Aile putu) çaldı. ");
INSERT INTO turytc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakov kaçacağını söylemeyerek Aramlı Lavan'ı kandırdı. ");
INSERT INTO turytc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Böylece sahip olduğu her şeyle birlikte kaçtı. Kalkıp Irmağı geçti ve Gilad Dağı’na doğru yöneldi. ");
INSERT INTO turytc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Üçüncü gün Yakov'un kaçtığı Lavan'a bildirildi. ");
INSERT INTO turytc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yakınlarını da yanına alıp yedi gün boyunca onu takip etti. Gilad Dağı’nda ona yetişti. ");
INSERT INTO turytc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tanrı geceleyin düşte Aramlı Lavan'a gelip ona, “Dikkat et, Yakov'a iyi, ne de kötü bir şey söyleme” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lavan Yakov'a yetişti. Yakov çadırını dağa kurmuştu. Lavan da yakınlarıyla birlikte Gilad Dağı’nda çadır kurdu. ");
INSERT INTO turytc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lavan Yakov'a, “Nedir bu yaptığın? Beni aldattın.” dedi, “Kızlarımı savaş esirleri gibi alıp götürdün? ");
INSERT INTO turytc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Niçin gizlice kaçtın ve beni aldattın? Seni sevinçle, ezgilerle, tef ve çenkle yolcu ederdim. ");
INSERT INTO turytc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Torunlarımı ve kızlarımı öpmeme izin vermedin. Şimdi akılsızca davrandın. ");
INSERT INTO turytc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Size kötülük etmek elimdedir. Ama babanın Tanrısı dün gece bana görünüp, ‘Dikkat et!’ dedi, ‘Yakov’a ne iyi, ne de kötü bir şey söyleme.’ ");
INSERT INTO turytc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Babanın evini çok özlediğin için çıkıp gittin. Ama niçin ilâhlarımı çaldın?” ");
INSERT INTO turytc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakov Lavan'a şu karşılığı verdi: “Korktum, çünkü, ‘Kızlarını zorla benden alırsın’ dedim. ");
INSERT INTO turytc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","İlâhlarını kimde bulursan o kişi sağ kalmayacaktır. Yakınlarımızın önünde kendin ara, eşyalarımın arasında sana ait ne bulursan al.” Yakov onları Rahel’in çaldığını bilmiyordu. ");
INSERT INTO turytc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavan Yakov'un çadırına, Lea'nın çadırına ve iki hizmetçinin çadırına girdi, ama onları bulamadı. Lea'nın çadırından çıkıp Rahel'in çadırına girdi. ");
INSERT INTO turytc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel terafimi alıp devenin semerine koymuştu ve üzerinde oturuyordu. Lavan bütün çadırı yokladı ama bulamadı. ");
INSERT INTO turytc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel babasına, “Efendim, senin huzurunda kalkamadığım için bana kızma, çünkü adet görüyorum da” dedi. Araştırdı ama terafimi bulamadı. ");
INSERT INTO turytc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakov öfkelendi ve Lavan'a çıkıştı. Yakov Lavan'a şu karşılığı verdi: “Benim suçum ne? Benim günahım ne ki, hararetle peşime düştün? ");
INSERT INTO turytc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Madem bütün eşyalarımı karıştırdın, kendi eşyalarından ne buldun? Onu burada benim yakınlarımın ve senin yakınlarının önüne koy da aramızda hüküm versinler.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Yirmi yıldır yanındayım. Koyunların ve keçilerin hiç düşük yapmadı. Sürülerinden bir koç yemedim. ");
INSERT INTO turytc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Vahşi hayvanların parçaladıklarını sana getirmedim. Zararını ben çektim. Gerek gündüz gerekse gece, çalınmış hayvanın karşılığını benim elimden istedin. ");
INSERT INTO turytc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Durumum buydu: Gündüz kuraklık, gece ayaz beni yiyip bitirdi. Gözümü kırpmadım. ");
INSERT INTO turytc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yirmi yıldır senin evindeyim. İki kızın için sana on dört yıl, sürün için altı yıl hizmet ettim ve sen benim ücretimi on kez değiştirdin. ");
INSERT INTO turytc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Babamın Tanrısı, Avraham'ın Tanrısı ve İshak'ın Korktuğu benimle birlikte olmasaydı, şimdi beni kesin boş gönderirdin. Tanrı çektiğim sıkıntıyı ve verdiğim emeği gördü ve dün gece seni azarladı.” ");
INSERT INTO turytc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lavan Yakov'a şöyle yanıt verdi: “Kızlar benim kızlarım, çocuklar benim çocuklarım, sürüler benim sürülerim ve bütün gördüklerin benim! Bugün kızlarıma ya da onların doğurduğu çocuklarına ne yapabilirim? ");
INSERT INTO turytc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Şimdi gel, seninle bir antlaşma yapalım. Bu, seninle benim aramızda bir tanık olsun.” ");
INSERT INTO turytc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakov bir taş alıp onu sütun olarak dikti. ");
INSERT INTO turytc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakov yakınlarına, “Taş toplayın” dedi. Taşları alıp bir yığın yaptılar. Orada yığının yanında yemek yediler. ");
INSERT INTO turytc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lavan oraya Yegar Sahaduta adını verdi. Yakov ise ona Galed adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lavan, “Bu yığın bugün seninle benim aramızda tanıktır” dedi. Bu nedenle oraya Galed adı verildi. ");
INSERT INTO turytc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mispa diye de bilinir. Çünkü Lavan şöyle dedi: “Birbirimizi gözden kaybettiğimiz zaman Yahve seninle benim aramızda gözcü olsun. ");
INSERT INTO turytc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kızlarımı incitirsen ya da kızlarımın üzerine başka eşler alırsan, yanımızda kimse olmasa bile Tanrı tanık olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lavan Yakov'a, “İşte şu yığın ve seninle benim aramızda diktiğim sütun!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","“Bu yığın tanık olsun, sütun da tanık olsun ki, bu yığının ötesine geçip sana kötülük etmeyeceğim. Sen de bu yığını ve sütunu geçip bana kötülük etmeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Avraham’ın Tanrısı ve Nahor'un Tanrısı, babalarının Tanrısı aramızda yargıç olsun.” Yakov, babası İshak'ın Korktuğu’nun üzerine ant içti. ");
INSERT INTO turytc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakov dağda kurban kesti ve yakınlarını yemeye çağırdı. Yemeği yiyip geceyi dağda geçirdiler. ");
INSERT INTO turytc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lavan sabah erkenden kalktı. Torunlarını ve kızlarını öptükten sonra onları kutsadı. Lavan gidip kendi yerine döndü. ");
INSERT INTO turytc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakov yola çıktı ve Tanrı'nın melekleri onu karşıladı. ");
INSERT INTO turytc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakov onları görünce, “Bu Tanrı'nın ordusu” dedi. O yerin adını Mahanaim koydu. ");
INSERT INTO turytc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakov kardeşi Esav'a, Seir ülkesine, Edom bölgesine, önünden ulaklar gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Onlara şöyle buyruk verdi: “Efendim Esav'a şöyle deyin: ‘Hizmetkârın Yakov böyle diyor. Lavan’ın yanında konuk oldum ve şimdiye kadar kaldım. ");
INSERT INTO turytc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Sığırlarım, eşeklerim, davarlarım, erkek ve kadın hizmetçilerim var. Gözünde lütuf bulabileyim diye efendime haber gönderdim.’” ");
INSERT INTO turytc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Haberciler Yakov'a dönerek, “Kardeşin Esav'ın yanına vardık” dediler. “Seni karşılamaya geliyor ve yanında dört yüz adam var.” ");
INSERT INTO turytc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","O zaman Yakov çok korktu ve sıkıldı. Yanındaki halkı, davarları, sığırları ve develeri iki bölüğe ayırdı. ");
INSERT INTO turytc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“Esav bir bölüğün yanına gelip onu vurursa, kalan bölük kurtulur” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakov şöyle dedi: “Ey atam Avraham’ın, babam İshak’ın Tanrısı Yahve, bana, ‘Ülkene ve akrabalarının yanına dön ve sana iyilik edeceğim’ dedin. ");
INSERT INTO turytc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Hizmetkârına gösterdiğin bunca iyiliğe ve içtenliğe layık değilim. Çünkü Yarden’i geçtiğimde yalnızca bir değneğim vardı ama şimdi iki ordu oldum. ");
INSERT INTO turytc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Lütfen kurtar beni kardeşimin elinden, Esav'ın elinden. Çünkü gelip bana, annelerine ve çocuklara vurmasından korkuyorum. ");
INSERT INTO turytc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","‘Sana kesin olarak iyilik edeceğim, soyunu deniz kumu gibi sayılamayacak kadar çoğaltacağım’ demiştin.” ");
INSERT INTO turytc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","O gece orada kaldı. Yanında bulunan hayvanlardan kardeşi Esav'a hediye olarak, ");
INSERT INTO turytc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","iki yüz keçi, yirmi teke, iki yüz koyun, yirmi koç, ");
INSERT INTO turytc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","yavrularıyla birlikte otuz dişi deve, kırk inek, on boğa, yirmi dişi eşek ve on sıpa ayırdı. ");
INSERT INTO turytc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Onları, ayrı sürüler olarak hizmetçilerinin eline teslim etti. Hizmetçilerine, “Önümden gidin, sürüler arasına mesafe koyun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Birincisine buyruk verip şöyle dedi: “Kardeşim Esav’la karşılaştığında, ‘Sen kiminsin? Nereye gidiyorsun? Önündekiler kimindir?’ diye sorduğunda, ");
INSERT INTO turytc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘Bunlar, hizmetkârın Yakov'undur’ diyeceksin. ‘Efendim Esav'a gönderilmiş bir hediyedir. İşte, kendisi de arkamızda.’” ");
INSERT INTO turytc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","İkincisine, üçüncüsüne, sürülerin hepsinin ardından gidenlere de buyruk verdi, “Esav'ı bulduğunuzda onunla böyle konuşacaksınız” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“‘Yalnız bu kadar değil, işte, hizmetkârın Yakov arkamızda’ diyeceksiniz.” Çünkü, “Onu önümden giden hediyeyle yatıştırıp sonra yüzünü göreceğim” dedi. “Belki beni kabul eder.” ");
INSERT INTO turytc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Böylece hediye onun önünden geçti ve kendisi o gece ordugâhta kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","O gece kalkıp iki karısını, iki hizmetkârını ve on bir oğlunu alıp Yabbok geçidini geçti. ");
INSERT INTO turytc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Onları alıp ırmaktan geçirdi ve kendisine ait olan şeyi de geçirdi. ");
INSERT INTO turytc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakov yalnız kaldı ve gün ağarana dek orada bir adamla güreşti. ");
INSERT INTO turytc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Adam onu yenemediğini görünce, uyluğunun başına dokundu. Yakov güreşirken uyluğunun başı incindi. ");
INSERT INTO turytc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Adam, “Bırak gideyim, gün ağarıyor” dedi. Yakov, “Beni kutsamadıkça seni bırakmam” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ona, “Adın ne?” dedi. “Yakov” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Artık sana Yakov değil, İsrael denecek” dedi. “Çünkü Tanrı'yla ve insanlarla çekişip galip geldin.” ");
INSERT INTO turytc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakov, “Lütfen adını söyle” dedi. “Adımın ne olduğunu neden soruyorsun?” dedi. Orada Yakov’u kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakov o yerin adını Peniel koydu. ");
INSERT INTO turytc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakov Peniel’den geçerken güneş üzerine doğdu ve uyluğu yüzünden aksıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bu nedenle İsrael’in çocukları bugüne dek uyluk kemiğinin üzerindeki siniri yemezler. Çünkü Yakov’un uyluk kemiğinin başındaki sinire dokunulmuştu. ");
INSERT INTO turytc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakov gözlerini kaldırıp baktı ve işte Esav, yanında dört yüz adamla geliyordu. Çocukları Lea, Rahel ve iki hizmetkârına teslim etti. ");
INSERT INTO turytc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hizmetçilerle çocuklarını öne, Lea'yla çocuklarını arkaya, Rahel'le Yosef'i en arkaya koydu. ");
INSERT INTO turytc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kendisi de onların önünden geçerek kardeşinin yanına gelene kadar yedi kez yere eğildi. ");
INSERT INTO turytc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esav onu karşılamak için koştu. Onu kucakladı, boynuna sarılıp, onu öptü. Birlikte ağladılar. ");
INSERT INTO turytc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Gözlerini kaldırdı, kadınları ve çocukları gördü, “Yanındaki bunlar kim?” dedi. “Tanrı’nın hizmetkârına lütfettiği çocuklar” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hizmetçiler çocuklarıyla yaklaşıp eğildiler. ");
INSERT INTO turytc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea ve çocukları da yaklaşıp eğildiler. Onlardan sonra Yosef, Rahel ile yaklaşıp eğildiler. ");
INSERT INTO turytc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esav, “Karşılaştığım önceki topluluğun anlamı nedir?” dedi. Yakov, “Efendimin gözünde lütuf bulmak içindir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esav, “Ben yeterincesine sahibim kardeşim” dedi. “Sahip oldukların senin olsun.” ");
INSERT INTO turytc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakov, “Hayır, lütfen, eğer şimdi gözünde lütuf bulduysam, hediyemi al” dedi, “Çünkü senin yüzünü görmek Tanrı'nın yüzünü görmek gibi. Sen benden hoşnut oldun. ");
INSERT INTO turytc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Lütfen sana getirdiğim hediyeyi al. Çünkü Tanrı bana lütufta bulundu ve bende yeterince var.” Onu zorladı ve o aldı. ");
INSERT INTO turytc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esav, “Yola çıkalım, gidelim” dedi, “Ben senin önünden gideceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakov ona şöyle dedi: “Efendim, çocukların narin olduğunu bilirsin. Yanımdaki davarların ve sığırların yavruları var. Bir gün daha yürümeye zorlanırsa sürünün hepsi ölür. ");
INSERT INTO turytc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Lütfen efendim, hizmetkârının önünden geçsin, ben de efendimin yanına, Seir'e varıncaya kadar önümde olan hayvanların hızına ve çocukların hızına göre yavaşça yol alacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esav, “Yanımdaki adamlardan bazılarını yanınıza bırakayım” dedi. Yakov, “Bu niçin? Efendimin gözünde lütuf bulayım.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esav o gün Seir'e dönmek üzere yola çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakov Sukkot'a gitti, kendine bir ev yaptı, hayvanları için barınak yaptı. Bu nedenle o yerin adına Sukkot denilir. ");
INSERT INTO turytc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakov Paddan Aram'dan Kenan ülkesindeki Şekem Kenti'ne esenlikle vardı. Kentin önünde konakladı. ");
INSERT INTO turytc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Çadırını kurduğu arsayı Şekem'in babası Hamor'un oğullarından yüz parça gümüşe satın aldı. ");
INSERT INTO turytc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Orada bir sunak kurup adını El Elohe İsrael koydu. ");
INSERT INTO turytc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lea'nın Yakov'a doğurduğu kızı Dina, memleketin kızlarını görmek için dışarı çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ülkenin önderi Hivli Hamor'un oğlu Şekem onu gördü. Dina’yı alıp onunla yattı ve onu alçalttı. ");
INSERT INTO turytc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Canı Yakov'un kızı Dina'ya bağlandı. Genç kızı sevdi ve ona nazik davrandı. ");
INSERT INTO turytc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Şekem babası Hamor'a, “Bana bu kızı eş olarak al” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakov kızı Dina'yı kirletildiğini duyduğunda oğulları kırda hayvanlarının yanındaydı. Yakov onlar gelene kadar sustu. ");
INSERT INTO turytc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Şekem'in babası Hamor, Yakov'la konuşmak için yanına gitti. ");
INSERT INTO turytc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakov'un oğulları bunu duyunca kırdan geldiler. Üzüntülü ve öfkeliydiler. Çünkü Yakov'un kızıyla yatarak İsrael'de çirkinlik etmişti. Bu yapılmaması gereken bir şeydi. ");
INSERT INTO turytc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor onlarla konuşup şöyle dedi: “Oğlum Şekem, kızınızı özlüyor. Lütfen onu ona eş olarak verin. ");
INSERT INTO turytc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Bizimle evlilik yapın. Kızlarınızı bize verin, kızlarımızı da kendinize alın. ");
INSERT INTO turytc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bizimle oturursunuz, ülke önünüzdedir. İçinde yaşayın, ticaret yapıp mülk edinin.” ");
INSERT INTO turytc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Şekem kızın babasına ve kardeşlerine, “Gözünüzde iyilik bulmama izin verin” dedi, “Ne isterseniz veririm. ");
INSERT INTO turytc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Benden büyük bir çeyiz isteyin, ne dilerseniz veririm. Yeter ki, kızı bana eş olarak verin.” ");
INSERT INTO turytc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakov'un oğulları Şekem'le babası Hamor'a hileli bir yanıt verdiler, çünkü kız kardeşleri Dina'yı kirletmişti. ");
INSERT INTO turytc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Onlara, “Kız kardeşimizi sünnetli olmayan bir adama vermek bizim için ayıptır. ");
INSERT INTO turytc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Yalnızca şu koşulla kabul ederiz. Bütün erkekleriniz sünnet edilip bizim gibi olursanız, ");
INSERT INTO turytc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","o zaman kızlarımızı size veririz, kızlarınızı kendimize alırız ve sizinle birlikte oturur, tek bir halk oluruz. ");
INSERT INTO turytc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ama bizi dinlemez ve sünnet olmazsanız, kız kardeşimizi alıp gideriz.” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Sözleri Hamor'la Hamor'un oğlu Şekem'in hoşuna gitti. ");
INSERT INTO turytc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Genç adam bunu yapmak için beklemedi. Çünkü Yakov’un kızını çok beğenmişti ve kendisi babasının evindekilerin en saygınıydı. ");
INSERT INTO turytc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor ve oğlu Şekem, kent kapısına geldiler ve halkla konuşup şöyle dediler: ");
INSERT INTO turytc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Bu adamlar bizimle barış içindeler. Onun için ülkede yaşasınlar ve ticaret yapsınlar. Bakın, topraklarımız onlar için yeterince geniştir. Kızlarını kendimize eş olarak alalım, kızlarımızı onlara verelim. ");
INSERT INTO turytc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ancak aramızdaki her erkeğin onlar gibi sünnet edilmesi koşuluyla bizimle yaşamayı ve bir halk olmayı kabul ediyorlar. ");
INSERT INTO turytc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Onların sürüleri, malları ve bütün hayvanları bizim olmayacak mı? Yeter ki onlarla anlaşalım ve bizimle birlikte otursunlar.” ");
INSERT INTO turytc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kentin kapısından çıkan herkes Hamor'la oğlu Şekem'in sözünü dinledi. Kent kapısından çıkan her erkek sünnet edildi. ");
INSERT INTO turytc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Üçüncü gün, Yakov'un oğullarından ikisi, Dina'nın kardeşleri Şimon'la Levi, onlar hala acı çekerken kılıçlarını aldılar, habersiz kente saldırdılar, bütün erkekleri öldürdüler. ");
INSERT INTO turytc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor'la oğlu Şekem'i de kılıçtan geçirdiler, Dina’yı Şekem'in evinden alıp gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakov'un oğulları cesetleri soyup kız kardeşlerini kirlettikleri için kenti yağmaladılar. ");
INSERT INTO turytc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sürülerini, sığırlarını, eşeklerini, kentte ve kırda ne varsa hepsini aldılar. ");
INSERT INTO turytc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bütün çocuklarını ve eşlerini esir aldılar, evlerindeki her şeyi yağmaladılar. ");
INSERT INTO turytc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakov Şimon'la Levi'ye şöyle dedi: “Ülkede yaşayan Kenanlılar'la Perizliler’i bana düşman ettiniz, başımı belaya soktunuz. Sayıca azım. Bana karşı birleşip beni vuracaklar ve ben ve ev halkım yok olacağız.” ");
INSERT INTO turytc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","“Kızkardeşimize bir fahişeye olduğu gibi mi davranmalıydı?” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tanrı Yakov'a, “Kalk, Beytel'e git ve orada yaşa” dedi. Orada, kardeşin Esav'ın yüzünden kaçtığın zaman sana görünen Tanrı'ya bir sunak yap.” ");
INSERT INTO turytc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakov ailesine ve yanındakilerin hepsine şöyle dedi: “Aranızdaki yabancı ilâhları atın, kendinizi arındırın, giysilerinizi değiştirin. ");
INSERT INTO turytc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kalkıp Beytel'e gidelim. Sıkıntılı günümde bana yanıt veren, gittiğim yolda benimle birlikte olan Tanrı'ya orada bir sunak yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ellerindeki bütün yabancı ilâhları, kulaklarındaki küpeleri Yakov'a verdiler. Yakov onları Şekem yanındaki meşe ağacının altına gömdü. ");
INSERT INTO turytc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yola çıktılar ve çevrelerindeki kentlerin üzerinde Tanrı'nın dehşeti vardı. Yakovoğulları’nın peşine düşmediler. ");
INSERT INTO turytc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakov, yanındakilerle birlikte Kenan ülkesindeki Luz'a, yani Beytel'e geldi. ");
INSERT INTO turytc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Orada bir sunak yapıp oraya El-Beytel (Beytel’in Tanrısı) adını verdi. Çünkü kardeşinden kaçtığı zaman Tanrı orada kendisine görünmüştü. ");
INSERT INTO turytc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebeka'nın dadısı Debora öldü ve Beytel'in alt tarafındaki meşe ağacının altına gömüldü. Oraya Allon-Bakut (Yas meşesi) adı koyuldu. ");
INSERT INTO turytc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakov Paddan-Aram'dan gelince, Tanrı ona yine görünerek onu kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tanrı ona, “Adın Yakov'dur” dedi. “Artık adın Yakov olmayacak, adın İsrael olacak.” Adını İsrael koydu. ");
INSERT INTO turytc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tanrı ona, “Ben Her Şeye Gücü Yeten Tanrı'yım” dedi. “Verimli ol ve çoğal. Senden bir ulus ve uluslar topluluğu olacak ve bedeninden krallar çıkacak. ");
INSERT INTO turytc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Avraham'la İshak'a verdiğim diyarı sana vereceğim ve senden sonra senin soyuna vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tanrı, Yakov’la konuştuğu yerden, onun yanından yukarıya çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakov onunla konuştuğu yere taştan bir sütun dikti. Üzerine dökmelik sunu ve üzerine zeytinyağı döktü. ");
INSERT INTO turytc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakov, Tanrı'nın kendisiyle konuştuğu yerin adını “Beytel” koydu. ");
INSERT INTO turytc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Beytel'den yola çıktılar. Efrata'ya hâlâ biraz mesafe vardı. Rahel doğum yaptı ve ağır sancılı bir doğumdu. ");
INSERT INTO turytc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Doğum sancısı çekerken ebe, “Korkma, bir oğlun daha oluyor” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Canı ayrılırken (çünkü öldü), adını Benoni koydu. Ama babası ona Benyamin adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel öldü ve Efrat (Beytlehem de denir) yolunda gömüldü. ");
INSERT INTO turytc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakov onun mezarına bir sütun dikti; bugüne dek Rahel'ın mezar taşıdır. ");
INSERT INTO turytc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","İsrael göç edip çadırını Eder kulesinin ötesine kurdu. ");
INSERT INTO turytc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","İsrael o ülkede yaşarken Ruven gidip babasının cariyesi Bilha'yla yattı. İsrael bunu duydu. Yakov'un on iki oğlu vardı. ");
INSERT INTO turytc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea'nın oğulları: Ruven (Yakov'un ilk oğlu), Şimon, Levi, Yahuda, İssakar, Zevulun. ");
INSERT INTO turytc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel'in oğulları: Yosef ve Benyamin. ");
INSERT INTO turytc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel'in cariyesi Bilha'nın oğulları: Dan, Naftali. ");
INSERT INTO turytc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea'nın cariyesi Zilpa'nın oğulları: Gad, Aşer. Bunlar Yakov'un Paddan Aram'da doğan oğullarıdır. ");
INSERT INTO turytc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakov babası İshak'ın yanına, Avraham’la İshak'ın yabancı olarak yaşadığı Mamre'ye, Kiryat-Arba'ya (Hevron denir) geldi. ");
INSERT INTO turytc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","İshak'ın günleri yüz seksen yıldı. ");
INSERT INTO turytc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","İshak kocamış, günlere doymuş olarak ruhunu teslim etti ve halkının arasına katıldı. Oğulları Esav ve Yakov onu gömdüler. ");
INSERT INTO turytc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esav (yani Edom’un) kuşaklarının öyküsü budur. ");
INSERT INTO turytc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esav eşlerini Kenan'ın kızlarından aldı: Hititli Elon'un kızı Âda ve Hivli Sivon'un kızı Âna'nın kızı Oholivama; ");
INSERT INTO turytc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","İşmael'in kızı, Nevayot'un kız kardeşi Basemat. ");
INSERT INTO turytc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada, Esav'a Elifaz’ı, Basemat Reuel’i, ");
INSERT INTO turytc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholivama Yeuş, Yalam ve Korah'ı doğurdu. Esav'ın Kenan diyarında dünyaya gelen oğulları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esav eşlerini, oğullarını, kızlarını, evindeki bütün adamlarını, hayvanlarının tümünü, Kenan diyarında topladığı bütün malını alıp kardeşi Yakov’dan uzak bir diyara gitti. ");
INSERT INTO turytc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Çünkü malları bir arada oturamayacakları kadar çoktu ve sürüleri yüzünden gelip geçtikleri toprak onları taşıyamadı. ");
INSERT INTO turytc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esav Seir'in dağlık bölgesinde yaşıyordu. Esav, Edom'dur. ");
INSERT INTO turytc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seir dağlık bölgesinde Edomlular'ın babası Esav kuşaklarının öyküsü şunlardır: ");
INSERT INTO turytc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esav'ın oğullarının adları: Esav'ın karısı Ada oğlu Elifaz ve Esav'ın karısı Basemat'ın oğlu Reuel’dir. ");
INSERT INTO turytc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz'ın oğulları: Teman, Omar, Sefo, Gatam ve Kenaz. ");
INSERT INTO turytc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, Esav'ın oğlu Elifaz'ın hizmetçisiydi ve Elifaz Amalek'i doğurdu. Bunlar Esav'ın karısı Ada'nın soyundandır. ");
INSERT INTO turytc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel'in oğulları: Nahat, Zerah, Şamma, Mizza. Bunlar Esav'ın karısı Basemat'ın soyundandır. ");
INSERT INTO turytc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esav'ın karısı Sivon'un kızı Ana'nın kızı Oholivama'nın Esav'a doğurduğu oğulları şunlardı: Yeuş, Yalam, Korah. ");
INSERT INTO turytc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esav oğullarının beyleri şunlardır: Esav'ın ilk oğlu Elifaz'ın oğulları: Teman, Omar, Sefo, Kenaz, ");
INSERT INTO turytc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, Amalek. Edom diyarına Elifaz’dan gelen beyler bunlardır. Bunlar Ada’nın oğullarıdır. ");
INSERT INTO turytc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esav oğlu Reuel'in oğulları şunlardır: Nahat, Zerah, Şamma, Mizza. Edom diyarına Reuel'den gelen beyler bunlardır. Bunlar Esav'ın karısı Basemat'ın oğullarıdır. ");
INSERT INTO turytc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esav'ın karısı Oholivama'nın oğulları şunlardır: Yeuş, Yalam, Korah. Esav'ın karısı Ana'nın kızı Oholivama'dan gelen beyler bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bunlar Esav (yani Edom'un) oğulları ve onların beyleri bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ülkede yaşayan Horlu Seir'in oğulları şunlardır: Lotan, Şoval, Sivon, Ana, ");
INSERT INTO turytc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dişon, Eser, Dişan. Edom diyarında Horlular’dan gelen Seiroğulları’nın beyleri bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan'ın oğulları: Hori ve Heman. Lotan'ın kız kardeşi Timna'dır. ");
INSERT INTO turytc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Şoval'ın oğulları şunlardır: Alvan, Manahat, Eval, Şefo, Onam. ");
INSERT INTO turytc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sivon'un oğulları: Aya ve Âna. Bu, babası Sivon'un eşeklerini güderken çölde kaplıcaları bulan Ana'dır. ");
INSERT INTO turytc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Âna’nın çocukları şunlardır: Dişon ve Âna'nın kızı Oholivama. ");
INSERT INTO turytc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dişon'un oğulları şunlardır: Hemdan, Eşban, İtran, Keran. ");
INSERT INTO turytc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser'in oğulları şunlardır: Bilhan, Zaavan, Akan. ");
INSERT INTO turytc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dişan'ın oğulları: Uz ve Aran. ");
INSERT INTO turytc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horlular’dan gelen beyler şunlardır: Lotan, Şoval, Sivon, Ana, ");
INSERT INTO turytc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dişon, Ezer, Dişan. Seir diyarındaki beylerine göre Horlular'dan gelen beyler bunlardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Bunlar, İsrael’in çocukları üzerinde herhangi bir kral saltanat sürmeden önce, Edom diyarında hüküm sürmüş olan krallardır. ");
INSERT INTO turytc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor oğlu Bala Edom'da kral oldu. Kentinin adı Dinhava'ydı. ");
INSERT INTO turytc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bala ölünce, yerine Bosralı Zerah'ın oğlu Yovav kral oldu. ");
INSERT INTO turytc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yovav ölünce, onun yerine Temaniler diyarından Huşam kral oldu. ");
INSERT INTO turytc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Huşam ölünce, Midyan'ı Moav kırlarında vuran Bedat oğlu Hadat kral oldu. Şehrinin adı Avit'ti. ");
INSERT INTO turytc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadat ölünce, onun yerine Masrekalı Samla kral oldu. ");
INSERT INTO turytc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla ölünce onun yerine ırmak kıyısındaki Rehovotlu Şaul kral oldu. ");
INSERT INTO turytc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Şaul ölünce, yerine Akbor oğlu Baal Hanan kral oldu. ");
INSERT INTO turytc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor oğlu Baal Hanan ölünce yerine Hadar kral oldu. Kentinin adı Pau'ydu. Karısının adı Mezahav'ın kızı Matret'in kızı Mehetavel'di. ");
INSERT INTO turytc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esav'dan gelen beylerin boylarına, yerlerine ve adlarına göre adları şunlardır: Timna, Alva, Yetet, ");
INSERT INTO turytc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholivama, Ela, Pinon, ");
INSERT INTO turytc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mivsar, ");
INSERT INTO turytc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ve İram. Sahip oldukları diyardaki yerlerine göre Edom beyleri bunlardı. Edomlular'ın atası Esav’dır. ");
INSERT INTO turytc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakov babasının gelip geçtiği Kenan diyarında yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakov soyunun öyküsü budur. On yedi yaşındaki Yosef, kardeşleriyle birlikte sürüyü güdüyordu. Yosef babasının eşleri Bilha ve Zilpa'nın oğullarıyla birlikteydi. Yosef onların yaptığı kötülükleri babasına ulaştırırdı. ");
INSERT INTO turytc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","İsrael Yosef'i bütün çocuklarından daha çok severdi. Çünkü o yaşlılığının oğluydu ve ona rengârenk uzun bir giysi yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kardeşleri, babalarının onu bütün kardeşlerinden daha çok sevdiğini gördüler, ondan nefret ettiler ve onunla hoş konuşmaz oldular. ");
INSERT INTO turytc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yosef bir düş gördü, kardeşlerine anlattı ve ondan daha çok nefret ettiler. ");
INSERT INTO turytc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Onlara, “Lütfen gördüğüm bu düşü dinleyin. ");
INSERT INTO turytc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","İşte, tarlanın ortasında biz demetler bağlıyorduk ve benim demetim kalktı ve dikildi. Sizin demetleriniz çevresine toplanıp benim demetime eğildiler.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kardeşleri, “Gerçekten bize kral mı olacaksın? Üzerimizde gerçekten hüküm mü süreceksin?” dediler. Düşleri ve sözleri yüzünden ondan daha çok nefret ettiler. ");
INSERT INTO turytc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Başka bir düş daha gördü ve onu kardeşlerine anlatıp, “Bakın, ben yine bir düş gördüm” dedi, “İşte, güneş, ay ve on bir yıldız önümde eğildiler.” ");
INSERT INTO turytc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Bunu babasına ve kardeşlerine anlattı. Babası onu azarladı ve ona, “Gördüğün bu düş nedir? Ben, annen ve kardeşlerin gerçekten gelip önünde yere mi kapanacağız?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kardeşleri onu kıskandılar, ama babası bu sözü yüreğinde sakladı. ");
INSERT INTO turytc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kardeşleri babalarının sürüsünü gütmek için Şekem'e gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","İsrael Yosef'e şöyle dedi: “Kardeşlerin Şekem'de sürüyü güdüyor mu? Gel, seni onlara göndereyim.” Ona, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ona, “Şimdi git, kardeşlerinin ve sürünün iyi olup olmadığına bak ve bana bildir” dedi. Onu Hebron vadisinden gönderdi ve Şekem'e vardı. ");
INSERT INTO turytc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Bir adam onu bulduğunda o kırda dolanıyordu. Adam, “Ne arıyorsun?” diye ona sordu. ");
INSERT INTO turytc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Kardeşlerimi arıyorum” dedi. “Lütfen bana sürüyü nerede güttüklerini söyle.” ");
INSERT INTO turytc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Adam, “Buradan ayrıldılar” dedi, “‘Dotan'a gidelim’ dediklerini duydum.” Yosef kardeşlerinin peşine düştü ve onları Dotan'da buldu. ");
INSERT INTO turytc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Onu uzaktan gördüler. Yosef kendilerine yaklaşmadan onu öldürmek için düzen kurdular. ");
INSERT INTO turytc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Birbirlerine, “İşte bu düşçü geliyor” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Şimdi gelin, onu öldürelim ve kuyulardan birisinin içine atalım, ‘Onu vahşi bir hayvan yedi’ deriz. Bakalım düşleri ne olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruven bunu işitti, onu ellerinden kurtardı. “Canına kıymayın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruven onlara, “Kan dökmeyin” dedi. “Onu çölde olan bu kuyuya atın, ama ona el sürmeyin.” Niyeti onu ellerinden kurtarıp babasına geri götürmekti. ");
INSERT INTO turytc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosef kardeşlerinin yanına varınca, Yosef'in üzerindeki rengârenk uzun giysiyi çıkardılar. ");
INSERT INTO turytc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Onu alıp kuyuya attılar. Kuyu boştu ve içinde su yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ekmek yemek için oturduklarında gözlerini kaldırıp baktılar. İşte, Gilad’dan İşmaeli kervanı geliyordu. Develerin baharat, pelesenk ve mür yüklüydü. Mısır’a götürmek için gidiyorlardı. ");
INSERT INTO turytc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahuda kardeşlerine şöyle dedi: “Kardeşimizi öldürüp kanını gizlersek bize ne faydası var? ");
INSERT INTO turytc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Gelin, onu İşmaeloğulları’na satalım ve elimiz ona bulaşmasın. Çünkü o bizim kardeşimiz, etimizdir.” Kardeşleri onu dinlediler. ");
INSERT INTO turytc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tüccar olan Midyanlılar geçiyordu. Yosef'i çukurdan çekip çıkardılar ve onu yirmi gümüşe İşmaeloğulları’na sattılar. Tüccarlar Yosef’i Mısır'a götürdüler. ");
INSERT INTO turytc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruven kuyuya döndü ve Yosef’in kuyuda olmadığını gördü. Giysilerini yırttı. ");
INSERT INTO turytc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kardeşlerinin yanına dönerek, “Artık çocuk yok” dedi. “Ben, nereye gideyim?” ");
INSERT INTO turytc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yosef’in gömleğini alıp bir teke kestiler ve giysisini kana batırdılar. ");
INSERT INTO turytc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Rengârenk giysiyi alıp babalarına getirdiler ve ona, “Bunu bulduk” dediler. “Bak, bakalım, oğlunun mu değil mi?” ");
INSERT INTO turytc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakov onu tanıdı ve “Oğlumun giysisidir” dedi. “Vahşi bir hayvan onu yemiş. Yosef’i kesin parçalamış.” ");
INSERT INTO turytc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakov giysilerini yırttı, beline çul sardı ve günlerce oğlu için yas tuttu. ");
INSERT INTO turytc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bütün oğulları ve kızları onu teselli etmeye çalıştılar, ama o teselli edilmek istemedi. “Çünkü oğlumun yanına, Şeol'e yas tutarak ineceğim” dedi. Babası onun için ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midyanlılar onu Mısır'da, Firavun'un bir memuruna, muhafız birliği komutanı Potifar'a sattılar. ");
INSERT INTO turytc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","O sırada Yahuda kardeşlerinden ayrılarak Adullamlı, adı Hira olan birini ziyaret etti. ");
INSERT INTO turytc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yahuda orada Şua adında Kenanlı bir adamın kızını gördü. Onu aldı ve yanına girdi. ");
INSERT INTO turytc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kız hamile kaldı ve bir erkek çocuk doğurdu. Yahuda çocuğa Er adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tekrar hamile kaldı ve bir erkek çocuk doğurdu ve ona Onan adını verdi. ");
INSERT INTO turytc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yine bir erkek çocuk doğurdu, adını Şela koydu. Onu doğurduğu zaman, Yahuda Keziv'deydi. ");
INSERT INTO turytc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahuda ilk oğlu Er için bir kadın aldı. Adı Tamar'dı. ");
INSERT INTO turytc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yahuda'nın ilk oğlu Er, Yahve’nin gözünde kötüydü. Bu nedenle Yahve onu öldürdü. ");
INSERT INTO turytc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yahuda Onan'a, “Kardeşinin karısının yanına gir” dedi, “Kardeşine kayınbiraderlik görevini yap ve kardeşine soy yetiştir.” ");
INSERT INTO turytc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan, soyun kendisinin olmayacağını biliyordu. Kardeşinin karısının yanına girince, erkek kardeşine soy vermesin diye menisini yere döküyordu. ");
INSERT INTO turytc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yaptığı şey Yahve’nin gözünde kötüydü ve onu da öldürdü. ");
INSERT INTO turytc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda gelini Tamar'a, “Oğlum Şela büyüyünceye kadar babanın evinde dul kal” dedi. “Çünkü, kardeşleri gibi o da ölmesin” dedi. Tamar gidip babasının evinde yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Çok zaman sonra Yahuda'nın karısı Şua'nın kızı öldü. Yahuda teselli bulduktan sonra arkadaşı Adullamlı Hira ile koyun kırkıcılarının yanına, Timna'ya gitti. ");
INSERT INTO turytc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar'a, “Bak, kayınpederin koyunlarını kırkmak için Timna'ya gidiyor” denildi. ");
INSERT INTO turytc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Üzerindeki dulluk giysisini çıkardı. Peçesini örtüp sarındı ve Timna yolu üzerindeki Enaim Kapısı’nda oturdu. Çünkü Şela'nın büyüdüğünü ve kendisinin ona eş olarak verilmediğini gördü. ");
INSERT INTO turytc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yahuda onu görünce fahişe sandı, çünkü yüzünü örtmüştü. ");
INSERT INTO turytc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yolda ona dönerek, “Lütfen gel, yanına gireyim” dedi. Çünkü onun gelini olduğunu bilmiyordu. O, “Yanıma girmek için bana ne verirsin?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Sana sürüden bir oğlak gönderirim” dedi. “Gönderinceye kadar bana bir rehin verir misin?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Sana ne rehin vereyim?” dedi. “Mührünü, ipini ve elindeki değneği” dedi. Onları ona verip yanına girdi. Kadın ondan hamile kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kalkıp gitti ve peçesini çıkardı. Dulluk giysilerini giydi. ");
INSERT INTO turytc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahuda, kadının elinden rehini alması için Adullamlı dostunun eliyle oğlağı gönderdi, ama onu bulamadı. ");
INSERT INTO turytc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Sonra orada yaşayanlara, “Enayim'de yol kenarındaki fahişe nerede?” diye sordu. Onlar “Burada fahişe yok” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yahuda'ya döndü ve şöyle dedi: “Onu bulamadım ve yöre halkı da, ‘Burada fahişe yok’ dedi.” ");
INSERT INTO turytc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda, “Bırak eşyalar yanında kalsın” dedi, “Kendimizi utandırmayalım. Bak, ben bu oğlağı gönderdim, ama sen bulamadın.” ");
INSERT INTO turytc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Yaklaşık üç ay sonra Yahuda'ya, “Gelinin Tamar zina etti” diye haber geldi. “Üstelik bak, o zinadan hamile kalmış.” Yahuda, “Onu dışarı çıkarın yakılsın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Dışarı çıkarıldığı zaman kayınpederine haber göndererek, “Bunların sahibinden hamileyim” dedi. Ayrıca, “Lütfen şunlara bak. Mühür, ipler ve değnek kimin?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda onları tanıyarak, “O benden daha doğru birisi, çünkü onu oğlum Şela'ya vermedim” dedi. Artık bir daha onu bilmedi. ");
INSERT INTO turytc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Doğum vakti geldiğinde, işte, rahminde ikizler vardı. ");
INSERT INTO turytc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Doğum sırasında biri elini uzattı. Ebe, “Önce bu doğdu” diyerek onun eline kırmızı bir iplik bağladı. ");
INSERT INTO turytc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Çocuk elini geri çekerken, işte, kardeşi doğdu ve ebe, “Neden kendine gedik açtın?” dedi. Bu nedenle ona Peres adı koyuldu. ");
INSERT INTO turytc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sonra elinde kırmızı iplik olan kardeşi doğdu ve ona Zerah adı konuldu. ");
INSERT INTO turytc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yosef Mısır'a getirildi. Firavun'un bir memuru, muhafız birliği komutanı, Mısırlı Potifar, onu oraya getiren İşmaelliler’in elinden satın aldı. ");
INSERT INTO turytc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yahve Yosef'le birlikteydi ve o başarılı bir adamdı. Yosef Mısırlı efendisinin evinde kalıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Efendisi, Yahve’nin onunla birlikte olduğunu ve yaptığı her şeyde Yahve’nin ona başarı verdiğini gördü. ");
INSERT INTO turytc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yosef onun gözünde lütuf buldu ve onu hizmetine aldı. Potifar onu evinin sorumlusu yaptı ve sahip olduğu her şeyi eline verdi. ");
INSERT INTO turytc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yahve onu evinde ve sahip olduğu her şeyin üzerinde sorumlu atadığı andan itibaren Yosef'in hatırı için Mısırlı’nın evini kutsadı. Yahve, evde ve tarlada sahip olduğu her şeyi bereketledi. ");
INSERT INTO turytc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar sahip olduğu her şeyi Yosef’in eline bıraktı. Yediği yemek dışında hiçbir şeyle ilgilenmezdi. Yosef güzel yapılı ve yakışıklıydı. ");
INSERT INTO turytc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bir süre sonra efendisinin karısı Yosef'e göz dikip, “Benimle yat” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ama o reddedip efendisinin karısına şöyle dedi: “Bak, ben evde olduğum için efendim evde ne olduğuyla ilgilenmez. Sahip olduğu her şeyi benim elime verdi. ");
INSERT INTO turytc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bu evde benden daha büyük kimse yok ve senden başka benden hiçbir şeyi esirgemedi. Çünkü sen onun karısısın. O zaman nasıl bu büyük kötülüğü yapar ve Tanrı'ya karşı günah işlerim?” ");
INSERT INTO turytc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Her gün Yosef’e söylese de, yanında yatmak ya da onunla birlikte olma isteğini dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bir gün işini yapmak için eve girdiğinde ev halkından içeride kimse yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","“Benimle yat!” diyerek onu giysisinden yakaladı. Yosef elbisesini onun elinde bırakıp dışarı kaçtı. ");
INSERT INTO turytc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Onun giysisini elinde bırakıp dışarı kaçtığını görünce, ");
INSERT INTO turytc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ev halkına seslenip onlara şöyle dedi: “Bakın, bizi aşağılamak için bize bir İbrani getirdi. Benimle yatmak için yanıma geldi ve ben yüksek sesle bağırdım. ");
INSERT INTO turytc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sesimi yükseltip bağırdığımı duyunca giysisini yanımda bırakıp dışarı kaçtı.” ");
INSERT INTO turytc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Efendisi eve gelinceye dek giysisini yanında tuttu. ");
INSERT INTO turytc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ona da aynı şeyi anlattı: “Bize getirdiğin İbrani hizmetçi beni aşağılamak için yanıma geldi. ");
INSERT INTO turytc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Sesimi yükseltip bağırınca giysisini yanıma bırakıp dışarı kaçtı.” ");
INSERT INTO turytc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Efendisi, karısının kendisine söylediği, “Hizmetçinin bana yaptığı buydu” sözlerini duyunca, öfkesi alevlendi. ");
INSERT INTO turytc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yosef’in efendisi onu alıp zindana, kralın tutuklularının tutulduğu yere koydu. Orada zindanda kaldı. ");
INSERT INTO turytc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ama Yahve Yosef’le birlikteydi, ona lütfetti ve zindan müdürünün gözünde ona lütuf verdi. ");
INSERT INTO turytc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Zindan müdürü, zindandaki bütün tutukluları Yosef’in eline teslim etti. Orada yapılan her şeyden o sorumluydu. ");
INSERT INTO turytc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Zindan müdürü onun elinde olan hiçbir şeye bakmazdı. Çünkü Yahve onunla birlikteydi ve yaptığı işte Yahve onu başarılı kıldı. ");
INSERT INTO turytc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bu olaylardan sonra Mısır Kralı’nın sakisiyle fırıncısı, efendileri Mısır Kralı’nı gücendirdiler. ");
INSERT INTO turytc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firavun iki görevlisine, baş sakiyle fırıncıbaşına öfkelendi. ");
INSERT INTO turytc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Onları, Yosef'in tutuklu olduğu zindana, muhafız birliği komutanının evine hapsetti. ");
INSERT INTO turytc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Muhafız birliği komutanı Yosef’i onların üzerine atadı ve Yosef onlarla ilgilendi. Bir süre cezaevinde kaldılar. ");
INSERT INTO turytc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mısır Kralı’nın zindanda tutuklu olan sakisi ve fırıncısı, aynı gece düşlerinin yorumlarına göre birer düş gördüler. ");
INSERT INTO turytc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sabahleyin Yosef yanlarına geldiğinde üzgün olduklarını gördü. ");
INSERT INTO turytc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Efendisinin evinde, kendisiyle birlikte tutuklu bulunan Firavun'un görevlilerine, “Bugün neden bu kadar üzgün görünüyorsunuz?” diye sordu. ");
INSERT INTO turytc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ona, “Biz bir düş gördük, onu yorumlayacak kimse yok” dediler. Yosef onlara, “Yorum Tanrı'ya ait değil mi? Lütfen düşünüzü bana anlatın.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Baş saki Yosef’e düşünü anlatıp ona şöyle dedi: “Düşümde önümde bir asma vardı. ");
INSERT INTO turytc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Asmada üç dal vardı. Sanki tomurcuklanmış gibiydi. Çiçek açtı, salkımları olgun üzümler verdi. ");
INSERT INTO turytc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Firavun’un kâsesi elimdeydi. Üzümleri alıp Firavun'un kâsesine sıktım ve kâseyi Firavun'un eline verdim.” ");
INSERT INTO turytc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosef ona, “Onun yorumu şudur” dedi, “Üç çubuk üç gündür. ");
INSERT INTO turytc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Üç güne kadar Firavun senin başını yükseltecek ve eski görevini iade edecek. Firavun'un kadehini, eskiden kadeh taşıyıcısı olduğun zamanki gibi yine onun eline vereceksin. ");
INSERT INTO turytc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ama senin için her şey yoluna girdiğinde lütfen beni hatırla. Lütfen bana iyilik et. Firavun'a benden söz et ve beni bu evden çıkar. ");
INSERT INTO turytc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Gerçekten de İbraniler diyarından kaçırıldım ve burada da beni zindana atmaları için hiçbir şey yapmadım.” ");
INSERT INTO turytc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Fırıncıbaşı yorumun iyi olduğunu görünce Yosef’e, “Ben de düşümdeydim” dedi, “İşte, başımın üstünde üç sepet beyaz ekmek vardı. ");
INSERT INTO turytc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","En üstteki sepette Firavun için her çeşidinden ekmekçi işleri vardı. Kuşlar başımdaki sepetten onları yiyorlardı.” ");
INSERT INTO turytc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosef, “Onun yorumu budur” diye yanıtladı. “Üç sepet üç gündür. ");
INSERT INTO turytc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Üç güne kadar Firavun başını üzerinden kaldıracak ve seni bir ağaca asacak. Kuşlar senin etini yiyecekler.” ");
INSERT INTO turytc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Üçüncü günde, Firavun'un doğum gününde, bütün görevlilerine bir ziyafet verdi. Görevlilerinin ortasında baş sakisiyle başfırıncının başını yükseltti. ");
INSERT INTO turytc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Baş sakiyi sakiliğe geri döndürdü ve kâseyi Firavun'un eline verdi. ");
INSERT INTO turytc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ama Yosef’in yorumladığı gibi fırıncıbaşıyı astı. ");
INSERT INTO turytc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ancak baş saki Yosef’i hatırlamadı, onu unuttu. ");
INSERT INTO turytc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tam iki yılın sonunda, Firavun bir düş gördü ve işte, ırmağın yanında duruyordu. ");
INSERT INTO turytc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Irmaktan yedi inek çıktı. Güzel ve besiliydiler ve sazlar arasında otluyorlardı. ");
INSERT INTO turytc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Onlardan sonra ırmaktan çirkin ve cılız yedi inek daha çıktı. Nehrin kıyısında diğer ineklerin yanında durdular. ");
INSERT INTO turytc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Çirkin ve cılız inekler yedi güzel ve besili ineği yedi. Böylece Firavun uyandı. ");
INSERT INTO turytc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Uyudu ve ikinci kez düş gördü. İşte, bir sapta güzel ve dolgun yedi başak bitti. ");
INSERT INTO turytc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Onlardan sonra, cılız ve doğu rüzgârıyla kavrulmuş yedi başak daha bitti. ");
INSERT INTO turytc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Cılız başaklar yedi güzel ve dolgun başakları yuttular. Firavun uyandı ve işte, bu bir düştü. ");
INSERT INTO turytc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sabahleyin canı sıkıldı ve Mısır'ın bütün büyücülerini ve bilgelerini çağırttı. Firavun onlara düşünü anlatmış, ama düşünü Firavun'a yorumlayacak kimse çıkmamıştı. ");
INSERT INTO turytc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Baş saki Firavun'a şöyle dedi: “Bugün suçlarımı hatırlıyorum. ");
INSERT INTO turytc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Firavun hizmetkârlarına öfkelendiğinde beni fırıncıbaşının yanında, muhafız komutanının evinde zindana atmıştın. ");
INSERT INTO turytc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Aynı gece ben ve o birer düş gördük. Herkes kendi düşünün yorumuna göre bir düş görmüştü. ");
INSERT INTO turytc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Yanımızda muhafız birliği komutanının hizmetkârı İbrani bir genç vardı, ona anlattık ve bize düşlerimizi yorumladı. Her birimize düşüne göre bir yorum verdi. ");
INSERT INTO turytc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Bize nasıl yorumladıysa öyle oldu. Ben görevime geri döndüm, o asıldı.” ");
INSERT INTO turytc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Bunun üzerine Firavun adam gönderip Yosef’i çağırttı. Onu hemen zindandan çıkardılar. Yosef tıraş olup giysilerini değiştirdikten sonra Firavun'un huzuruna geldi. ");
INSERT INTO turytc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firavun, Yosef’e, “Bir düş gördüm” dedi, “Onu yorumlayacak kimse yok. Senin duyduğun düşleri yorumlayabildiğinin söylendiğini duydum.” ");
INSERT INTO turytc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosef, Firavun'a, “Bende yok” diye yanıtladı. “Esenlik yanıtını Tanrı Firavun'a verecektir.” ");
INSERT INTO turytc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firavun Yosef'e şöyle dedi: “Düşümde ırmağın kıyısında duruyordum. ");
INSERT INTO turytc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","İşte, ırmaktan besili ve güzel yedi sığır çıktı. Sazlıklar arasında otlanıyorlardı. ");
INSERT INTO turytc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Onlardan sonra, çirkinlikte onlar gibi tüm Mısır ülkesinde hiç görmediğim, zavallı, çirkin ve cılız yedi inek daha çıktı. ");
INSERT INTO turytc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Cılız ve çirkin inekler ilk yedi besili ineği yedi. ");
INSERT INTO turytc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Onları yediklerinde, yedikleri bellli olmadı, hala başlangıçtaki kadar çirkindiler. Sonra uyandım. ");
INSERT INTO turytc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Düşümde, işte, bir sapta dolgun ve güzel yedi başak bittiğini gördüm. ");
INSERT INTO turytc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","İşte, onlardan sonra solgun, cılız ve doğu rüzgârıyla kavrulmuş yedi başak daha bitti. ");
INSERT INTO turytc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Cılız başaklar yedi iyi başağı yuttu. Büyücülere bunu anlattım, bana yorumlayabilen kimse çıkmadı.” ");
INSERT INTO turytc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosef, Firavun'a, “Firavun'un gördüğü düş birdir” dedi. “Tanrı yapmak üzere olduğu şeyi Firavun'a bildirdi. ");
INSERT INTO turytc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Yedi iyi sığır, yedi yıldır ve yedi iyi başak yedi yıldır. Düş birdir. ");
INSERT INTO turytc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Onlardan sonra çıkan yedi cılız ve çirkin inek ve doğu rüzgârıyla kavrulmuş yedi boş başak da yedi yıldır. Yedi yıl kıtlık olacak. ");
INSERT INTO turytc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Firavun'a söylediğim şey budur. Tanrı, Firavun'a yapmak üzere olduğu şeyi göstermiştir. ");
INSERT INTO turytc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","İşte, bütün Mısır diyarında yedi büyük bolluk yılı geliyor. ");
INSERT INTO turytc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Onlardan sonra yedi kıtlık yılı çıkacaktır. Mısır'da bolluk unutulacaktır. Kıtlık diyarı kasıp kavuracaktır. ");
INSERT INTO turytc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ülkeyi kıtlık kaplayacak, ardından gelen kıtlık nedeniyle ülkede bolluk bilinmeyecektir. Çünkü çok şiddetli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Düş Firavun’a iki kez tekrar edildi. Çünkü bu olay Tanrı tarafından sabitlendi ve Tanrı yakında onu gerçekleştirecektir.” ");
INSERT INTO turytc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Şimdi Firavun akıllı ve bilge bir adam arasın ve onu Mısır ülkesinin başına koysun. ");
INSERT INTO turytc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Firavun bunu yapsın ve ülkeye gözetmenler atasın ve yedi bolluk yılında Mısır ülkesinin ürününün beşte birini alsın. ");
INSERT INTO turytc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Gelecek bu iyi yılların bütün yiyeceğini toplasınlar. Kentlerde yiyecek olmak üzere Firavun’un eli altında tahılı depolayıp saklasınlar. ");
INSERT INTO turytc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bu yiyecek Mısır'da olacak olan yedi yıllık kıtlığa karşı ülkeyi doyurmak için erzak olacak, öyle ki, ülke kıtlık yüzünden mahvolmasın.” ");
INSERT INTO turytc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bu söz Firavun'un ve bütün görevlilerinin gözünde iyiydi. ");
INSERT INTO turytc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firavun görevlilerine, “Bunun gibi, kendisinde Tanrı'nın Ruhu olan bir adam bulabilir miyiz?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Firavun Yosef'e, “Mademki Tanrı sana bütün bunları gösterdi, senin kadar akıllı ve bilgesi yoktur” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","“Evimin başında olacaksın. Bütün halkım senin sözüne göre yönetilecek. Ben yalnız tahtta senden daha büyük olacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Firavun Yosef'e, “İşte, seni bütün Mısır ülkesi üzerine atadım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Firavun mühür yüzüğünü elinden çıkarıp Yosef'in eline taktı, ona ince ketenden kaftan giydirdi. Boynuna altın bir zincir taktı. ");
INSERT INTO turytc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Onu kendisinin ikinci arabasına bindirdi. Onun önünde “Diz çökün!” diye bağırdılar. Onu bütün Mısır ülkesinin üzerine koydu. ");
INSERT INTO turytc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firavun Yosef'e, “Ben Firavun'um” dedi. “Mısır diyarında sensiz hiç kimse elini ve ayağını kaldırmayacak.” ");
INSERT INTO turytc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firavun Yosef’in adını Safenat-Paneah koydu. On Kenti kâhini Potifera'nın kızı Asenat'ı ona eş olarak verdi. Yosef Mısır diyarını boydan boya dolaştı. ");
INSERT INTO turytc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosef Mısır Firavunu'nun huzuruna çıktığında otuz yaşındaydı. Yosef Firavun'un huzurundan çıkıp bütün Mısır diyarını dolaştı. ");
INSERT INTO turytc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yedi bolluk yılında toprak bol bol ürün verdi. ");
INSERT INTO turytc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yedi yıl boyunca Mısır'da olan bütün yiyeceği toplayıp kentlere yığdı. Her kentte o kentin çevresinde tarlalardan yiyecek depoladı. ");
INSERT INTO turytc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosef denizin kumu kadar çok tahıl biriktirdi, öyle ki artık saymayı bıraktı. Çünkü sayısızdı. ");
INSERT INTO turytc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kıtlık yılı gelmeden önce Yosef’in iki oğlu oldu. On Kenti'nin kâhini Potifera'nın kızı Asenat ona doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef ilk oğlunun adını Manaşşe koydu, “Çünkü” dedi, “Tanrı bana bütün sıkıntılarımı ve babamın evini unutturdu.” ");
INSERT INTO turytc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","İkincisinin adını Efraim koydu. “Çünkü Tanrı sıkıntı çektiğim diyarda beni verimli kıldı.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mısır'da yedi bolluk yılı sona erdi. ");
INSERT INTO turytc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yosef’in söylediği gibi yedi kıtlık yılı başladı. Bütün ülkede kıtlık vardı, ama bütün Mısır diyarında ekmek vardı. ");
INSERT INTO turytc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mısır'ın tamamı aç kalınca, halk ekmek için Firavun'a yakardı. Firavun tüm Mısırlılar’a, “Yosef’e gidin” dedi. “O size ne derse öyle yapın.” ");
INSERT INTO turytc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kıtlık bütün yeryüzünü kaplamıştı. Yosef erzak depolarının hepsini açtı ve Mısırlılar’a satmaya başladı. Mısır diyarında kıtlık şiddetliydi. ");
INSERT INTO turytc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bütün ülkeler tahıl satın almak için Yosef’in yanına, Mısır'a geldiler. Çünkü bütün yeryüzünde kıtlık şiddetliydi. ");
INSERT INTO turytc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakov Mısır'da tahıl olduğunu görünce oğullarına, “Niçin birbirinize bakıyorsunuz?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“İşte, Mısır'da tahıl olduğunu duydum. Oraya gidin, satın alın ki, yaşayalım ve ölmeyelim.” ");
INSERT INTO turytc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yosef’in on erkek kardeşi tahıl almak için Mısır'a gittiler. ");
INSERT INTO turytc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ama Yakov Yosef’in kardeşi Benyamin'i kardeşleriyle birlikte göndermedi. Çünkü, “Başına bir zarar gelebilir” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Gelenler arasında İsrael’in oğulları da satın almak için geldiler. Çünkü Kenan diyarında kıtlık vardı. ");
INSERT INTO turytc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosef ülkenin valisiydi. Ülkenin bütün insanlarına satan oydu. Yosef’in kardeşleri geldiler ve onun önünde yere kapandılar. ");
INSERT INTO turytc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef kardeşlerini gördü ve onları tanıdı. Ancak onlara bir yabancı gibi davranıp onlarla sert konuştu. Onlara, “Nereden geliyorsunuz?” dedi. “Yiyecek satın almak için Kenan ülkesinden” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosef kardeşlerini tanıdı, ama onlar onu tanımadı. ");
INSERT INTO turytc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosef onlar hakkında gördüğü düşleri hatırladı ve onlara, “Siz casussunuz! Ülkenin açığını görmeye geldiniz.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ona, “Hayır, efendim” dediler, “Hizmetkârların yiyecek almaya geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Hepimiz bir adamın oğullarıyız, bizler dürüst insanlarız. Hizmetkârların casus değildir.” ");
INSERT INTO turytc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Onlara, “Hayır, siz ülkenin açıklarını görmek için geldiniz!” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Onlar, “Biz hizmetkârların, Kenan diyarında bir adamın oğulları, on iki kardeşiz” dediler. “En küçüğü bugün babamızın yanındadır, biri de yoktur.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosef onlara şöyle dedi: “‘Siz casussunuz’ dediğim budur! ");
INSERT INTO turytc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Bununla sınanacaksınız. Firavun'un hayatı üzerine ant içerim ki, küçük kardeşiniz buraya gelmedikçe buradan çıkmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sizden birini gönderin de kardeşinizi getirsin. Sözlerinizin doğru olup olmadığı sınanacak ve geri kalanınız gözaltında tutulacak. Yoksa Firavun’un hayatı üzerine ant içerim ki, sizler kesin olarak casussunuz.” ");
INSERT INTO turytc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hepsini üç gün boyunca gözaltında tuttu. ");
INSERT INTO turytc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Üçüncü gün Yosef onlara şöyle dedi: “Bunu yapın ve yaşayın, çünkü ben Tanrı'dan korkarım. ");
INSERT INTO turytc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Eğer dürüst insanlarsanız, kardeşlerinizden biri hapiste tutuklu kalsın. Siz gidin, evlerinizdeki kıtlık için tahıl götürün. ");
INSERT INTO turytc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Küçük kardeşinizi bana getirin. Böylece sözleriniz doğrulanacak ve ölmeyeceksiniz.” Öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Birbirlerine, “Kardeşimiz konusunda kesin olarak suçluyuz” dediler, “Bize yalvardığı zaman canının sıkıntısını gördük ve dinlemedik. Onun için bu sıkıntı başımıza geldi.” ");
INSERT INTO turytc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruven onlara şu karşılığı verdi: “Ben size, ‘Çocuğa karşı günah işlemeyin’ demedim mi? Dinlemediniz. Bu nedenle, işte, kanının hesabı soruluyor.” ");
INSERT INTO turytc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosef’in onları anladığını bilmiyorlardı, çünkü aralarında bir tercüman vardı. ");
INSERT INTO turytc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Onlardan uzaklaştı ve ağladı. Sonra onlara dönüp kendileriyle konuştu. Aralarından Şimon'u aldı ve gözleri önünde onu bağladı. ");
INSERT INTO turytc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosef, torbalarına tahıl doldurulmasını, herkesin parasının kesesine koyulmasını ve yol için onlara yiyecek verilmesini buyurdu. Onlara böyle yapıldı. ");
INSERT INTO turytc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tahıllarını eşeklerine yükleyip oradan ayrıldılar. ");
INSERT INTO turytc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","İçlerinden biri konakladıkları yerde eşeğine yem vermek için çuvalını açınca parasını gördü. Hemen çuvalının ağzındaydı. ");
INSERT INTO turytc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kardeşlerine, “Param geri verilmiş” dedi. “İşte, çuvalımda!” Yürekleri yerinden oynadı ve titreyerek birbirlerine dönüp, “Tanrı'nın bize bu yaptığı nedir?” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kenan diyarına, babaları Yakov’a gelip başlarına gelen her şeyi ona anlatıp şöyle dediler: ");
INSERT INTO turytc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ülkenin efendisi olan adam bizimle sert konuştu ve bizi ülkenin casusları sandı. ");
INSERT INTO turytc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Biz ona, ‘Biz dürüst insanlarız’ dedik. ‘Casus değiliz. ");
INSERT INTO turytc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Biz babamızın oğulları, on iki kardeşiz. Biri yoktur ve en küçüğü de bugün Kenan diyarında babamızın yanındadır.’ ");
INSERT INTO turytc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ülkenin efendisi olan adam bize dedi ki, ‘Bununla sizin dürüst insanlar olup olmadığınızı bileceğim. Kardeşlerinizden birini yanımda bırakarak evlerinizdeki kıtlık için tahıl alın ve yolunuza gidin. ");
INSERT INTO turytc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","En küçük kardeşinizi bana getirin. O zaman casus olmadığınızı, dürüst insanlar olduğunuzu bileceğim. Ben de kardeşinizi size teslim edeceğim ve siz de ülkede ticaret yaparsınız.” ");
INSERT INTO turytc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Torbalarını boşaltırken, işte, her adamın para kesesi çuvalındaydı. Kendileri ve babaları, para keselerini görünce korktular. ");
INSERT INTO turytc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Babaları Yakov onlara, “Beni çocuklarımdan ettiniz” dedi. “Artık Yosef yok, Şimon da yok ve siz Benyamin'i alıp götürmek istiyorsunuz. Bütün bunlar benim başıma geliyor.” ");
INSERT INTO turytc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruven babasına şöyle dedi: “Onu sana getirmezsem iki oğlumu öldür. Onu bana emanet et, ben de onu sana tekrar getiririm.” ");
INSERT INTO turytc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","O, “Oğlum sizinle gitmeyecek. Çünkü kardeşi öldü ve geriye sadece o kaldı. Eğer gideceğiniz yolda ona bir zarar gelirse, benim ak saçlarımı kederle Şeol'e indireceksiniz.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ülkede kıtlık şiddetliydi. ");
INSERT INTO turytc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Mısır'dan getirdikleri buğdayı yiyip tükettikten sonra babaları onlara, “Yine gidin, bize biraz daha yiyecek satın alın” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yahuda ona şöyle dedi: “O adam, ‘Kardeşiniz yanınızda olmadan yüzümü göremezsiniz’ diyerek bizi ciddi bir şekilde uyardı. ");
INSERT INTO turytc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kardeşimizi bizimle gönderirsen, gideriz ve sana yiyecek satın alırız. ");
INSERT INTO turytc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ama onu göndermezsen gitmeyiz. Çünkü adam bize, ‘Kardeşiniz yanınızda olmadıkça yüzümü göremezsiniz’ dedi.” ");
INSERT INTO turytc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","İsrael, “Adama başka bir kardeşinizin olduğunu söyleyerek neden bana bu kötülüğü ettiniz?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Onlar, “Adam doğrudan bizim ve akrabalarımız hakkında, ‘Babanız yaşıyor mu? Başka kardeşiniz var mı?’ diyerek sorular sordu. Biz de yanıt verdik. ‘Kardeşinizi getirin’ diyeceğini nereden bilebilirdik?” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yahuda, babası İsrael'e, “Çocuğu benimle gönder” dedi, “Sen de biz de çocuklarımız da yaşar ölmeyiz. ");
INSERT INTO turytc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ona ben kefil olurum. Beni sorumlu tut. Eğer onu sana getirmez ve karşına çıkarmazsam, o zaman sonsuza dek suçlu sayılayım. ");
INSERT INTO turytc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Çünkü gecikmemiş olsaydık, şimdiye dek kesin olarak ikinci kez dönmüş olurduk.” ");
INSERT INTO turytc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Babaları İsrael onlara şöyle dedi: “Öyleyse böyle yapın: Torbalarınıza ülkenin seçkin meyvelerinden alın ve adama hediye olarak biraz pelesenk, biraz bal, baharat, mür, fıstık ve badem götürün. ");
INSERT INTO turytc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Yanınıza iki katı para alın ve çuvallarınızın ağzında geri verilmiş olan parayı geri götürün. Belki bir yanlışlık olmuştur. ");
INSERT INTO turytc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kardeşini de alıp götürün ve adamın yanına dönün. ");
INSERT INTO turytc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Her Şeye Gücü Yeten Tanrı, adamın önünde size merhamet etsin de, diğer kardeşinizi ve Benyamin'i size teslim etsin. Ben çocuklarımdan olacaksam olayım.” ");
INSERT INTO turytc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Adamlar bu hediyeyi, ellerine iki kat parayı ve Benyamin’i alıp kalktılar ve Mısır’a gittiler. Yosef’in önünde durdular. ");
INSERT INTO turytc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosef Benyamin'i yanlarında görünce, evinin kâhyasına şöyle dedi: “Adamları eve götür, bir hayvan kesip hazırla. Çünkü onlar öğle yemeğini benimle birlikte yiyecekler.” ");
INSERT INTO turytc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kâhya Yosef’in dediğini yaptı ve adamları Yosef’in evine götürdü. ");
INSERT INTO turytc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Adamlar korktular, çünkü Yosef’in evine götürülmüşlerdi. Onlar, “İlk seferinde çuvallarımıza geri verilmiş olan para yüzünden getirildik” dediler. “Fırsat kollayıp saldıracak, ele geçirip eşeklerimizle birlikte bizi köle edecek.” ");
INSERT INTO turytc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yosef’in evinin kâhyasına yaklaşıp evin kapısında onunla konuştular. ");
INSERT INTO turytc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Aman efendim” dediler. “İlk defa yiyecek almak için gelmiştik. ");
INSERT INTO turytc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Konaklama yerine vardığımızda çuvallarımızı açtık ve işte, herkesin parası eksiksiz olarak çuvalının ağzındaydı. Onu elimizle geri getirdik. ");
INSERT INTO turytc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Yiyecek satın almak için başka paralar getirdik. Paramızı çuvallarımıza kimin koyduğunu bilmiyoruz.” ");
INSERT INTO turytc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kâhya, “Esenlik olsun size” dedi. “Korkmayın Tanrınız, babanızın Tanrısı size çuvallarınızda hazine verdi. Paranızı aldım.” Şimon'u yanlarına getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Birisi, adamları Yosef’in evine getirdi, onlara su verdi ve ayaklarını yıkadılar. Eşeklerine yem verdi. ");
INSERT INTO turytc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Öğleyin Yosef’in gelişine kadar hediyeler hazırladılar. Orada ekmek yiyeceklerini duymuşlardı. ");
INSERT INTO turytc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosef eve gelince ellerindeki hediyeyi eve getirdiler ve önünde yere kapandılar. ");
INSERT INTO turytc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Onlara hal hatır sordu, “Sözünü ettiğiniz ihtiyar babanız iyi mi? Yaşıyor mu?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Babamız hizmetkârın iyi” dediler. “O hâlâ yaşıyor.” Saygıyla eğilip yere kapandılar. ");
INSERT INTO turytc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosef gözlerini kaldırdı ve annesinin oğlu olan kardeşi Benyamin'i görünce, “Bana sözünü ettiğiniz en küçük kardeşiniz bu mu?” dedi. “Tanrı sana lütfetsin oğlum” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosef acele etti. Çünkü yüreği kardeşi için yanıyordu ve ağlayacak bir yer aradı. Odasına girdi ve orada ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yüzünü yıkayıp dışarı çıktı. Kendini tuttu ve “Yemek koyun” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosef’e ayrı, kardeşlerine ayrı ve Yosef’le yemek yiyen Mısırlılar’a ayrı hizmet edildi. Çünkü Mısırlılar İbraniler’le yemek yemezlerdi ve bunu iğrençlik sayarlardı. ");
INSERT INTO turytc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kardeşleri onun önünde büyükten küçüğe doğru yaş sırasına göre oturdular. Birbirlerine bakıp şaşırdılar. ");
INSERT INTO turytc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosef önünden onlara pay ayırdı, ama Benyamin'in payı onların her birinin payından beş kat daha fazlaydı. İçtiler ve onunla birlikte hoş vakit geçirdiler. ");
INSERT INTO turytc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Evinin kâhyasına şu buyruğu verdi: “Adamların çuvallarına taşıyabilecekleri kadar yiyecek doldur ve her birinin parasını çuvalının ağzına koy. ");
INSERT INTO turytc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Benim kâsemi, gümüş kâseyi, tahıl parasıyla birlikte en küçüğünün çuvalının ağzına koy.” Yosef’in söylediği söze göre yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sabah olur olmaz adamlar, eşekleriyle birlikte gönderildiler. ");
INSERT INTO turytc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kentten henüz çıkmışlar daha uzaklaşmamışlardı, Yosef kâhyasına, “Kalk, adamların peşinden git” dedi. “Onlara yetiştiğin zaman onlara de ki: ‘Niçin iyiliğe kötülükle karşılık verdiniz? ");
INSERT INTO turytc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bu, efendimin ondan içtiği hem de fal baktığı kâse değil mi? Bunu yapmakla kötülük ettiniz.’” ");
INSERT INTO turytc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Onlara yetişti ve kendilerine bu sözleri söyledi. ");
INSERT INTO turytc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ona, “Efendim neden böyle sözler söylüyor? Böyle bir şey yapmak hizmetkârlarından uzak olsun! ");
INSERT INTO turytc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","İşte, çuvallarımızın ağzında bulmuş olduğumuz parayı Kenan diyarından sana geri getirdik. O halde nasıl efendinizin evinden gümüş ya da altın çalalım? ");
INSERT INTO turytc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Hizmetkârlarından kimde bulunursa, öldürülsün, biz de efendimin köleleri oluruz.” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kâhya, “Peki, şimdi, sözlerinize göre olsun” dedi. “Kimin yanında bulunursa, o benim kölem olur. Siz de suçsuz olursunuz.” ");
INSERT INTO turytc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Sonra aceleyle herkes çuvalını yere indirip kendi çuvalını açtı. ");
INSERT INTO turytc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","En büyüğünden en küçüğüne kadar aradı. Kâse Benyamin'in çuvalında bulundu. ");
INSERT INTO turytc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Sonra giysilerini yırttılar ve her biri eşeğini yükleyip kente döndüler. ");
INSERT INTO turytc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yahuda ve kardeşleri Yosef’in evine geldiler, Yosef hâlâ oradaydı. Onun önünde yere kapandılar. ");
INSERT INTO turytc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef onlara, “Yaptığınız bu iş nedir? Benim gibi bir adamın elbet fala bakabileceğini bilmiyor muydunuz?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda, “Efendime ne diyelim? Ne söyleyelim? Kendimizi nasıl aklayalım? Tanrı, hizmetkârlarının suçunu ortaya çıkardı. Bakın, hem biz hem de kendisinde kâse bulunan efendimin köleleriyiz.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosef, “Böyle yapmak benden uzak olsun. Kâse elinde bulunan adam benim kölem olacak, ama siz esenlikle babanızın yanına gidin.” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yahuda ona yaklaşıp şöyle dedi: “Efendim, lütfen hizmetkârların efendimin kulağına bir söz söylesin ve hizmetkârına karşı öfken alevlenmesin. Çünkü sen Firavun gibisin. ");
INSERT INTO turytc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Efendim hizmetkârlarına sorup demişti: ‘Babanız ya da erkek kardeşiniz var mı?’ diye. ");
INSERT INTO turytc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Biz de efendime, ‘Yaşlı bir babamız ve onun yaşlılığında doğan küçük bir kardeşimiz var. O çocuğun kardeşi öldü, annesinden yalnız o kaldı. Babası onu sever.’ demiştik. ");
INSERT INTO turytc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Hizmetkârlarına, ‘Onu bana getirin de bir göreyim’ demiştiniz. ");
INSERT INTO turytc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Efendime, ‘Çocuk babasını bırakamaz, babasını bırakırsa babası ölür.’ demiştik. ");
INSERT INTO turytc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hizmetkârlarına, ‘Küçük kardeşiniz sizinle birlikte gelmezse, bir daha yüzümü göremezsiniz’ demiştin. ");
INSERT INTO turytc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Hizmetkârın babamızın yanına vardığımızda, ona efendimin sözlerini ilettik. ");
INSERT INTO turytc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Babamız, ‘Yine gidip bize biraz yiyecek satın alın’ dedi. ");
INSERT INTO turytc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","‘Gidemeyiz’ dedik. ‘En küçük kardeşimiz bizimle olursa gideriz. Çünkü en küçük kardeşimiz yanımızda olmazsa adamın yüzünü göremeyiz.’ ");
INSERT INTO turytc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Hizmetkârın babam bize, ‘Karımın bana iki oğul doğurduğunu biliyorsunuz. ");
INSERT INTO turytc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Biri yanımdan gitti ve ben, “Kesin parçalanmış dedim” ve o zamandan beri onu görmedim. ");
INSERT INTO turytc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Bunu da benden alırsanız ve ona bir zarar gelirse, ak saçımı kederle Şeol'e indirirsiniz. ");
INSERT INTO turytc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Şimdi hizmetkârın babamın yanına vardığımızda, çocuk bizimle birlikte olmazsa, onun hayatı, çocuğun hayatına bağlı olduğundan, ");
INSERT INTO turytc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","çocuğun artık olmadığını görünce ölür. Hizmetkârların, hizmetkârın babamın ak saçlarını kederle Şeol'e indirirler. ");
INSERT INTO turytc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Çünkü hizmetkârın babama çocuk için kefil oldu. ‘Onu sana getirmezsem, sonsuza dek babama karşı suçlu olayım’ dedim. ");
INSERT INTO turytc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Bu nedenle, lütfen efendimin kölesi olan çocuğun yerine ben hizmetkârın kalayım. Çocuk kardeşleriyle birlikte çıkıp gitsin. ");
INSERT INTO turytc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Çocuk yanımda olmadan babamın yanına nasıl giderim? Babamın başına gelecek kötülüğü görmeyeyim.” ");
INSERT INTO turytc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Bunun üzerine Yosef, yanında duranların hepsinin önünde kendini tutamayıp, “Herkesi yanımdan çıkarın!” diye bağırdı. Yosef kendisini kardeşlerine tanıttığı zaman yanında hiç kimse yoktu. ");
INSERT INTO turytc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yüksek sesle ağladı. Mısırlılar duydu ve Firavun'un ev halkı da duydu. ");
INSERT INTO turytc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosef kardeşlerine, “Ben Yosef'im” dedi. “Babam hâlâ yaşıyor mu?” Kardeşleri ona yanıt veremedi. Çünkü onun önünde dehşete kapıldılar. ");
INSERT INTO turytc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosef kardeşlerine, “Lütfen bana yaklaşın” dedi. Yaklaştılar. “Ben Mısır'a sattığınız kardeşiniz Yosef'im” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","“Şimdi beni buraya sattığınız için üzülmeyin ve kendinize kızmayın. Çünkü Tanrı, yaşamı korumak için beni önünüzden gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bu iki yıldır ülkede kıtlık var ve daha beş yıl daha var ki, bu süre içinde ne sürme ne de biçme olacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tanrı yeryüzünde sizin için bir bakiye saklamak ve sizi büyük bir kurtuluşla yaşatmak için beni önünüzden gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Şimdi beni buraya siz değil, Tanrı gönderdi ve beni Firavun’a baba, bütün evine efendi ve tüm Mısır diyarının hükümdarı yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hemen babama gidin ve ona deyin, ‘Oğlun Yosef şöyle diyor: Tanrı beni Mısır'ın efendisi yaptı. Yanıma gel, durma ");
INSERT INTO turytc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Goşen diyarında oturursunuz; sen ve çocukların, çocuklarının çocukları, davarların, sığırların ve sahip olduğun her şeyle birlikte bana yakın olursunuz. ");
INSERT INTO turytc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Orada sana bakarım, çünkü daha beş yıl kıtlık olacak. Yoksa sen ve ev halkın, senin olanların hepsi yoksulluk çekersiniz.’ ");
INSERT INTO turytc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","İşte, gözleriniz ve kardeşim Benyamin'in gözleri görüyor ki, sizinle konuşan benim ağzımdır. ");
INSERT INTO turytc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mısır'daki bütün görkemimi ve bütün gördüklerinizi babama söyleyin. Acele edip babamı buraya getirin.” ");
INSERT INTO turytc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kardeşi Benyamin'in boynuna kapanıp ağladı, Benyamin de onun boynunda ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Bütün kardeşlerini öptü ve onlarla ağladı. Ondan sonra kardeşleri kendisiyle konuştu. ");
INSERT INTO turytc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Firavun'un evinde, “Yosef'in kardeşleri geldi” diye haber duyuldu. Firavun ve görevlileri hoşnut oldu. ");
INSERT INTO turytc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firavun Yosef'e şöyle dedi: “Söyle kardeşlerine, ‘Hayvanlarınızı yükleyip Kenan ülkesine gidin. ");
INSERT INTO turytc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Babanı ve ev halkını alıp yanıma gelin. Size Mısır diyarında iyi olanı vereceğim, ülkenin yağından yiyeceksiniz.’ ");
INSERT INTO turytc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Şimdi size şöyle yapmanız buyruluyor: Yavrularınız ve karılarınız için Mısır diyarından kendinize arabalar alın ve babanızı da alıp getirin. ");
INSERT INTO turytc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ayrıca kendi malınız için endişelenmeyin, çünkü bütün Mısır diyarının iyi şeyleri sizindir.” ");
INSERT INTO turytc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","İsrael’in oğulları böyle yaptılar. Yosef, Firavun'un buyruğu uyarınca onlara arabalar verdi ve yol için yiyecek sağladı. ");
INSERT INTO turytc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Her birine yedek giysi verdi. Benyamin'e ise üç yüz parça gümüşle beş kat yedek giysi verdi. ");
INSERT INTO turytc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Babasına, Mısır'ın iyi mallarıyla yüklü on eşek, tahıl, ekmek ve ayrıca erzak yüklü on dişi eşek gönderdi. ");
INSERT INTO turytc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Böylece kardeşlerini gönderdi ve onlar da gittiler. Onlara, “Yolda kavga etmeyin” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mısır'dan çıkıp Kenan ülkesine, babaları Yakov’un yanına vardılar. ");
INSERT INTO turytc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ona, “Yosef hâlâ yaşıyor ve tüm Mısır ülkesinin hükümdarı” dediler. Yüreği kendinden geçti çünkü onlara inanmadı. ");
INSERT INTO turytc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yosef’in kendilerine bildirdiği bütün sözleri ona söylediler. Yosef’in kendisini taşımak için gönderdiği arabaları görünce, babaları Yakov’un ruhu canlandı. ");
INSERT INTO turytc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","İsrael, “Yeter artık” dedi. “Oğlum Yosef hâlâ yaşıyor. Ölmeden önce gidip onu göreceğim.” ");
INSERT INTO turytc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","İsrael sahip olduğu her şeyle birlikte göç ederek Beer-Şeva'ya geldi. Babası İshak'ın Tanrısı'na kurbanlar sundu. ");
INSERT INTO turytc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tanrı gece görümlerinde İsrael'le konuşarak, “Yakov, Yakov!” dedi. O, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Ben Tanrı’yım. Babanın Tanrısı’yım.” dedi. “Mısır'a gitmekten korkma, çünkü seni orada büyük bir ulus yapacağım. ");
INSERT INTO turytc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ben seninle birlikte Mısır'a geleceğim. Seni kesin olarak tekrar çıkaracağım. Senin gözlerini Yosef’in eli kapatacak.” ");
INSERT INTO turytc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakov Beer-Şeva'dan kalktı. İsrael’in çocukları babaları Yakov’u yavrularını, karılarını, onu taşımak için Firavun’un göndermiş olduğu arabalarda taşıdılar. ");
INSERT INTO turytc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Hayvanlarını, Kenan diyarından edindikleri malları, Yakov'la bütün soyunu alıp Mısır’a geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kendisiyle birlikte oğullarını, oğullarının oğullarını, kızlarını, oğullarının kızlarını ve bütün soyunu Mısır'a getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mısır'a gelen İsrael’in çocuklarının adları şöyledir: Yakov'la oğulları, Yakov'un ilk oğlu Ruven. ");
INSERT INTO turytc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruven'in oğulları: Hanok, Pallu, Hetsron, Karmi. ");
INSERT INTO turytc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Şimon'un oğulları: Yemuel, Yamin, Ohat, Yakin, Sohar ve Kenanlı bir kadının oğlu olan Şaul. ");
INSERT INTO turytc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi'nin oğulları: Gerşon, Kehat, Merari. ");
INSERT INTO turytc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda’nın oğulları: Er, Onan, Şela, Peres, Zerah. Ancak Er ve Onan, Kenan diyarında öldüler. Peres'in oğulları: Hetsron ve Hamul. ");
INSERT INTO turytc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","İssakar'ın oğulları: Tola, Puva, Yov, Şimron. ");
INSERT INTO turytc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zevulun'un oğulları: Seret, Elon, Yahleel. ");
INSERT INTO turytc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bunlar Lea'nın Paddan-Aram'da kızı Dina’yla birlikte Yakov'a doğurduğu oğullarıdır. Oğullarının ve kızlarının toplam canları otuz üçtü. ");
INSERT INTO turytc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad'ın oğulları: Sifyon, Hagi, Şuni, Ezbon, Eri, Arodi, Areli. ");
INSERT INTO turytc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aşer'in oğulları: İmna, Yişva, Yişvi, Beria ve kız kardeşleri Serah. Beria'nın oğulları: Hever ve Malkiel. ");
INSERT INTO turytc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bunlar, Lavan'ın kızı Lea'ya verdiği Zilpa'nın Yakov'a doğurduğu oğulları, on altı candır. ");
INSERT INTO turytc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakov'un karısı Rahel'in oğulları: Yosef ve Benyamin. ");
INSERT INTO turytc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Mısır diyarında Yosef'e Manaşşe ve Efraim doğdu. Onları kendisine On Kenti'nin kâhini Potifera'nın kızı Asenat doğurdu. ");
INSERT INTO turytc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin'in oğulları: Bala, Beker, Aşbel, Gera, Naaman, Ehi, Roş, Muppim, Huppim, Ard. ");
INSERT INTO turytc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rahel'in Yakov’a doğurduğu oğulları şunlardır: Toplam on dört candı. ");
INSERT INTO turytc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan’ın oğlu: Huşim. ");
INSERT INTO turytc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali'nin oğulları: Yahseel, Guni, Yeser, Şillem. ");
INSERT INTO turytc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Lavan'ın kızı Rahel'e verdiği Bilha'nın oğulları bunlardır. Bunları Yakov'a doğurdu, toplam yedi candı. ");
INSERT INTO turytc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bütün canlar, Yakov’un oğullarının karılarından başka Yakov’un soyundan olup kendisiyle Mısır’a gelmiş olan bütün canların toplamı altmıştı. ");
INSERT INTO turytc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosef'e Mısır'da doğan oğulları iki candı. Mısır'a gelen Yakov'un ev halkının toplam canları yetmiş kişiydi. ");
INSERT INTO turytc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakov, Goşen'e giden yolu göstermesi için Yahuda'yı kendisinden önce Yosef'e gönderdi. Goşen diyarına geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef arabasını hazırlayıp babası İsrael'i karşılamak için Goşen'e gitti. Kendisini ona takdim edip boynuna kapandı ve bir süre boynunda ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","İsrael, Yosef'e, “Hâlâ yaşıyorsun yüzünü de gördüğüme göre, şimdi bırak öleyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosef kardeşlerine ve babasının ev halkına şöyle dedi: “Gidip Firavun'la konuşacağım ve ona, ‘Kenan ülkesinde olan kardeşlerim ve babamın ev halkı bana geldi’ diyeceğim. ");
INSERT INTO turytc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","‘Bu adamlar çobandır, çünkü davar sahibidirler ve davarlarını, sığırlarını ve sahip oldukları her şeyi getirdiler.’ ");
INSERT INTO turytc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Firavun sizi çağırıp da, ‘Ne iş yaparsınız?’ diye sorarsa, ");
INSERT INTO turytc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Goşen diyarında oturabilesiniz diye, ‘Gençliğimizden beri biz hizmetkârların, atalarımız gibi hayvancılıkla uğraşırız’ diyeceksiniz. Çünkü Mısırlılar için her çoban iğrençtir.” ");
INSERT INTO turytc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosef içeri girdi ve Firavun’a haber verip şöyle dedi: “Babam ve kardeşlerim davarları, sığırları ve sahip oldukları her şeyle birlikte Kenan diyarından geldiler. İşte, Goşen diyarındalar.” ");
INSERT INTO turytc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kardeşlerinden beşini alıp Firavun’un huzuruna çıkardı. ");
INSERT INTO turytc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firavun kardeşlerine, “Ne iş yaparsınız?” dedi. Firavun'a, “Hizmetkârların, hem biz hem de atalarımız çobandır” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Firavun'a, “Biz bu ülkeye yabancı olarak yaşamaya geldik” dediler, “Çünkü hizmetkârlarının sürüleri için otlak yoktur. Çünkü Kenan diyarında kıtlık şiddetlidir. Şimdi lütfen hizmetkârlarının Goşen diyarında oturmasına izin ver.” ");
INSERT INTO turytc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firavun Yosef’e şöyle dedi: “Baban ve kardeşlerin sana geldiler. ");
INSERT INTO turytc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mısır diyarı senin önündedir. Babanı ve kardeşlerini ülkenin en iyi yerinde oturt. Goşen diyarında otursunlar. Eğer onlar arasında becerikli adamlar tanıyorsan, onları davarlarıma bakmakla görevlendir.” ");
INSERT INTO turytc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yosef babası Yakov'u getirip Firavun'un huzuruna çıkardı. Yakov Firavun'u kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firavun Yakov'a, “Kaç yaşındasın?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakov, Firavun'a, “Yolculuk yıllarım yüz otuz yıldır” dedi. “Ömrümün yıllarının günleri az ve kötüydü. Atalarımın yolculuk günlerinde yaşadıkları yıllara ulaşamadı.” ");
INSERT INTO turytc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakov Firavun'u kutsadı ve Firavun'un huzurundan ayrıldı. ");
INSERT INTO turytc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosef babasını ve kardeşlerini yerleştirdi ve Firavun’un buyurduğu gibi Mısır diyarında, ülkenin en iyi yerinde, Ramses diyarında onlara mülk verdi. ");
INSERT INTO turytc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef babasına, kardeşlerine ve babasının bütün ev halkına ailelerinin sayısına göre yiyecek sağladı. ");
INSERT INTO turytc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bütün ülkede ekmek yoktu. Çünkü kıtlık çok şiddetliydi, öyle ki Mısır diyarı ve Kenan diyarı kıtlıktan kırılıyordu. ");
INSERT INTO turytc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosef satın aldıkları tahıl bedeli olarak Mısır ve Kenan diyarında bulunan bütün parayı onlardan topladı. Yosef parayı Firavun’un evine getirdi. ");
INSERT INTO turytc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mısır ve Kenan diyarındaki paranın tamamı tükenince, bütün Mısırlılar Yosef'e gelip şöyle dediler: “Bize ekmek ver, senin önünde ölelim mi? Çünkü paramız bitti.” ");
INSERT INTO turytc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef, “Davarlarınızı bana verin” dedi. “Eğer paranız bittiyse, hayvanlarınıza karşılık yiyecek veririm.” ");
INSERT INTO turytc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Davarlarını Yosef'e getirdiler. Yosef atlara, davarlara, sığırlara ve eşeklere karşılık olarak ekmek verdi. O yıl için bütün davarlarına karşılık onları ekmekle besledi. ");
INSERT INTO turytc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","O yıl sona erince, ikinci yıl da ona gelip dediler: “Paramızın nasıl tükendiğini efendimden gizlemeyeceğiz, sürüler de efendimindir. Efendimin önünde bedenlerimizden ve topraklarımızdan başka bir şeyimiz kalmadı. ");
INSERT INTO turytc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Hem biz hem de toprağımız senin gözlerinin önünde niçin ölelim? Bizi ve toprağımızı ekmek karşılığında satın al, toprağımızla birlikte Firavun'un hizmetkârı olalım. Bize tohum ver ki, yaşayalım, ölmeyelim ve ülke ıssız kalmasın.” ");
INSERT INTO turytc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Böylece Yosef Mısır’ın bütün toprağını Firavun için satın aldı. Çünkü Mısırlılar’ın her biri kendi tarlasını sattı. Çünkü kıtlık onları zorluyordu ve toprak Firavun’un oldu. ");
INSERT INTO turytc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yosef, halkı Mısır’ın bir ucundan öbür ucuna kadar kentlere göçtürdü. ");
INSERT INTO turytc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ancak kâhinlerin toprağını satın almadı. Çünkü kâhinler Firavun'dan bir pay aldılar ve Firavun'un kendilerine verdiği paydan yediler. Bu yüzden toprak satmadılar. ");
INSERT INTO turytc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef halka, “İşte, bugün sizi ve toprağınızı Firavun'a satın aldım” dedi. “İşte, size tohum ve toprağı ekeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Hasat zamanı, beşte birini Firavun'a vereceksiniz. Tarlanın tohumu, kendi yiyeceğiniz, evinizde bulunanlara, küçük çocuklarınıza yiyecek olmak üzere dört pay sizin olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Onlar, “Hayatımızı kurtardın! Efendimizin gözünde lütuf bulalım, Firavun'a hizmetkârlar oluruz.” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yosef Mısır toprağı için bunu yasa haline getirdi. Bugüne dek beşte biri Firavun’undur. Yalnızca kâhinlerin toprağı Firavun'un olmadı. ");
INSERT INTO turytc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","İsrael Mısır ülkesinde, Goşen diyarında yaşıyordu. Orada kendilerine mal mülk edindiler, verimli olup fazlasıyla çoğaldılar. ");
INSERT INTO turytc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakov Mısır'da on yedi yıl yaşadı. Böylece Yakov'un günleri, ömrünün yılları yüz kırk yedi yıl sürdü. ");
INSERT INTO turytc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","İsrael'in öleceği zaman yaklaştığında oğlu Yosef'u çağırdı ve ona şöyle dedi: “Eğer şimdi gözünde lütuf buldumsa, lütfen elini uyluğumun altına koy ve bana karşı iyilik ve içtenlikle davran. Lütfen beni Mısır'a gömme. ");
INSERT INTO turytc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ama atalarımla birlikte uyuduğum zaman beni Mısır'dan çıkarıp onların mezarına göm.” Yosef, “Dediğin gibi yapacağım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","İsrael, “Ant iç” dedi. Yosef ant içti. Sonra İsrael yatağın başucunda eğildi. ");
INSERT INTO turytc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bu şeylerden sonra biri Yosef'e, “Bak, baban hasta” dedi. Yosef iki oğlu Manaşşe ve Efraim'i yanına aldı. ");
INSERT INTO turytc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Biri Yakov'a, “İşte, oğlun Yosef geliyor” dedi. İsrael kendini toparlayıp yatağın üzerine oturdu. ");
INSERT INTO turytc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakov Yosef'e şöyle dedi: “Her Şeye Gücü Yeten Tanrı, Kenan diyarında, Luz'da bana görünerek beni kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Bana, ‘Seni verimli kılacağım ve çoğaltacağım. Seni uluslar topluluğu yapacağım. Bu diyarı senden sonra sonsuza dek mülk olarak senin soyuna vereceğim’ dedi. ");
INSERT INTO turytc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Şimdi, ben senin yanına Mısır'a gelmeden önce Mısır ülkesinde doğmuş olan iki oğlun benimdir. Efraim ve Manaşşe, Ruven ve Şimon gibi benim olacaklar. ");
INSERT INTO turytc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Onlardan sonra sana doğacak olan soyun senin olacaklar. Miraslarında kardeşlerinin adına göre çağırılacaklardır. ");
INSERT INTO turytc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Bana gelince, Paddan'dan geldiğimde, Efrat'a daha biraz mesafe varken, Kenan diyarında, yolda Rahel yanımda öldü ve onu Efrat (Beytlehem de denir) yolunda oraya gömdüm.” ");
INSERT INTO turytc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","İsrael Yosef’in oğullarını görünce, “Bunlar kim?” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef babasına, “Tanrı'nın burada bana verdiği oğullarımdır” dedi. İsrael, “Lütfen onları bana getir de kutsayayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","İsrael'in gözleri ihtiyarlıktan iyi göremiyordu. Yosef onları yanına getirdi ve onları öptü ve kucakladı. ");
INSERT INTO turytc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","İsrael Yosef'e, “Senin yüzünü göreceğimi sanmıyordum” dedi, “İşte, Tanrı senin soyunu bile görmeme izin verdi.” ");
INSERT INTO turytc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yosef onları onun dizlerinin arasından çıkardı ve yere kapandı. ");
INSERT INTO turytc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosef, Efraim'i sağ eline İsrael'in sol eline doğru, Manaşşe'yi sol eline İsrael'in sağ eline doğru ikisini alıp ona yaklaştırdı. ");
INSERT INTO turytc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","İsrael sağ elini uzatıp küçüğü olan Efraim’in başına koydu, sol elini Manaşşe'nin başına koydu ve ellerini kasten değiştirdi, çünkü Manaşşe ilk doğandı. ");
INSERT INTO turytc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yosef'i kutsayarak şöyle dedi: “Atalarım Avraham ve İshak'ın önünde yürüdükleri Tanrı, Bugüne dek hayatım boyunca beni güden Tanrı, ");
INSERT INTO turytc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","beni tüm kötülüklerden kurtaran melek, bu çocukları kutsasın, Benim adım ve atalarım Avraham’la İshak’ın adları onların üzerlerinde anılsın, Yeryüzünde çoğaldıkça çoğalsınlar.” ");
INSERT INTO turytc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosef babasının sağ elini Efraim'in başına koyduğunu görünce, bu hoşuna gitmedi. Efraim'in başından Manaşşe'nin başına getirmek için babasının elini kaldırdı. ");
INSERT INTO turytc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosef babasına, “Öyle değil baba” dedi, “Çünkü bu ilk doğandır. Sağ elini onun başının üzerine koy.” ");
INSERT INTO turytc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Babası koymak istemedi ve “Biliyorum oğlum, biliyorum” dedi. “O da bir halk olacak ve o da büyük olacak. Ancak küçük kardeşi ondan daha büyük olacak ve onun soyu uluslar topluluğu olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","O gün onları kutsayarak, “‘Tanrı seni Efraim ve Manaşşe gibi etsin’ diyerek İsrael sizin adınızla kutsayacak” dedi. Efraim'i Manaşşe'nin önüne geçirdi. ");
INSERT INTO turytc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","İsrael Yosef’e, “Ben ölüyorum” dedi, “Ama Tanrı sizinle olacak ve sizi yeniden atalarınızın ülkesine götürecek. ");
INSERT INTO turytc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ben sana kardeşlerinden bir pay fazla veriyorum, onu kılıcımla ve yayımla Amorlular’ın elinden aldım.” ");
INSERT INTO turytc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakov oğullarına seslenip şöyle dedi: “Toplanın da, gelecekte başınıza gelecekleri size bildireyim. ");
INSERT INTO turytc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Toplanın ve dinleyin, ey Yakov'un oğulları. Babanız İsrael'i dinleyin.” ");
INSERT INTO turytc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruven, sen benim ilk oğlum, gücüm, gücümün başlangıcısın. Saygı ve güçte birincisin. ");
INSERT INTO turytc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ama su gibi oynaksın, birinci olmayacaksın, çünkü babanın yatağına girdin, onu kirlettin. O benim yatağıma çıktı.” ");
INSERT INTO turytc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Şimon'la Levi kardeştir. Kılıçları şiddet silahlarıdır. ");
INSERT INTO turytc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ey canım, onların toplantılarına katılma. Ey yüceliğim, toplantılarında onlarla bir olma çünkü öfkelendiklerinde adam öldürdüler. İsteyerek sığırları sakatladılar. ");
INSERT INTO turytc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Lanet olsun öfkelerine, çünkü şiddetlidir. Lanet olsun gazaplarına, çünkü zalimcedir. Onları Yakov'da böleceğim, Onları İsrael'de dağıtacağım.” ");
INSERT INTO turytc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yahuda, kardeşlerin seni övecekler. Elin düşmanlarının boynunda olacaktır. Babanın oğulları önünde eğilecekler. ");
INSERT INTO turytc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuda bir aslan yavrusudur. Oğlum benim! Avından yukarı çıktın. O yere çöktü, aslan gibi, dişi aslan gibi yattı. Kim onu kaldırabilir? ");
INSERT INTO turytc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Sahibi gelinceye dek, saltanat asası Yahuda'dan, hükümdarlık asası ayaklarının arasından ayrılmayacak. Ulusların itaati ona olacaktır. ");
INSERT INTO turytc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Sıpasını asmaya, eşeğinin yavrusunu seçme bir asmaya bağlayarak, giysilerini şarapta, Kaftanını üzümlerin kanında yıkadı. ");
INSERT INTO turytc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Gözleri şaraptan kızıl, dişleri sütten beyaz olacak.” ");
INSERT INTO turytc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zevulun deniz kıyısında oturacak. Gemilere liman olacak.” Sınırı Sayda’nın yanında olacak. ");
INSERT INTO turytc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“İssakar heybelerin arasında yatan, güçlü bir eşektir. ");
INSERT INTO turytc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","İyi bir dinlenme yeri, hoşuna giden bir memleket görürse, omzunu yüke eğer, Angaryada çalışan bir hizmetçi olur.” ");
INSERT INTO turytc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan İsrael oymaklarından biri olarak, halkını yargılayacak. ");
INSERT INTO turytc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan yolda bir yılan, toprak yolda bir engerek olacak, atın topuklarını ısıran, böylece binicisini sırtüstü düşüren bir engerek olacak. ");
INSERT INTO turytc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ben senin kurtarışını bekledim, ey Yahve.” ");
INSERT INTO turytc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Bir birlik Gad'a saldıracak, ama onların topuklarını ezecek.” ");
INSERT INTO turytc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aşer'in yiyeceği zengin olacak. Kraliyet lezzetleri üretecek.” ");
INSERT INTO turytc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali salıverilmiş bir geyiktir, güzel yavrular doğurur.” ");
INSERT INTO turytc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosef verimli bir asmadır, kaynak başında verimli bir asma. Onun dalları duvarın üzerinden aşar. ");
INSERT INTO turytc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Okçular onu çok hırpaladılar, ok atıp ona zulmettiler. ");
INSERT INTO turytc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ama onun yayı sağlam, ellerinin kolları güçlü çıktı, Yakov’un Kudretlisi’nin elleriyle, (İsrael'in çobanı ve kayası oradandır), ");
INSERT INTO turytc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Sana yardım edecek olan babanın Tanrısı’dır, Her Şeye Gücü Yeten Tanrı’dır seni kutsayacak olan. Yukarıdaki göğün, aşağıda yatan derinliğin bereketleriyle, memelerin ve rahmin bereketleriyle seni kutsayacak. ");
INSERT INTO turytc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Babanın kutsamaları, eski tepelerin sınırları üzerinden, atalarının kutsamalarından üstün geldi. Yosef’in başında olacak.” Önderlik kardeşlerinden ayrı olanın başı üzerinde olacak. ");
INSERT INTO turytc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin yırtıcı bir kurttur. Sabah avını yutar. Akşam ganimeti paylaşır.” ");
INSERT INTO turytc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bunların hepsi İsrael'in on iki oymağıdır. Babaları bunları söyleyip onları kutsadı. Herkesi kendi bereketine göre kutsadı. ");
INSERT INTO turytc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Onlara buyruk verip şöyle dedi: “Ben halkımın arasına katılmak üzereyim. Beni atalarımın yanına Hititli Efron'un tarlasındaki mağaraya, ");
INSERT INTO turytc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Avraham’ın mezar yeri olarak tarlasıyla birlikte Hititli Efron'dan satın almış olduğu Kenan diyarındaki, Mamre yakınlarında Makpela tarlasındaki mağaraya gömün. ");
INSERT INTO turytc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Avraham’la karısı Sarah'ı oraya gömdüler. İshak'la karısı Rebeka'yı da oraya gömdüler. Ben de Lea'yı oraya gömdüm. ");
INSERT INTO turytc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tarla ve içindeki mağara Het'in çocuklarından satın alınmıştı. ");
INSERT INTO turytc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakov oğullarına verdiği buyrukları bitirdikten sonra ayaklarını yatağın içine çekti, son nefesini vererek halkına kavuştu. ");
INSERT INTO turytc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosef babasının yüzü üzerine kapandı. Onun üzerinde ağladı ve onu öptü. ");
INSERT INTO turytc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yosef hekim hizmetkârlarına babasını mumyalamalarını buyurdu. Hekimler İsrael'i mumyaladılar. ");
INSERT INTO turytc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Onun için kırk günlük bir süre kullanıldı. Çünkü mumyalamak için gereken gün sayısı bu kadardı. Mısırlılar İsrael için yetmiş gün yas tuttular. ");
INSERT INTO turytc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Onun için yas günleri geçince, Yosef Firavun'un ev halkına, “Eğer şimdi gözünüzde lütuf bulduysam, lütfen Firavun’un kulağına seslenip şöyle deyin, ");
INSERT INTO turytc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Babam, İşte, ben ölüyorum. Beni Kenan diyarında kendim için kazdığım mezara gömeceksin diyerek bana ant içtirdi. Bu nedenle, lütfen izin verin şimdi çıkıp babamı gömüp geleyim.’” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firavun, “Git, babanı sana ant içirdiği gibi göm” dedi. ");
INSERT INTO turytc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yosef babasını gömmek için çıktı. Firavun’un bütün hizmetkârları, evinin ileri gelenleri, Mısır diyarının bütün ileri gelenleri, ");
INSERT INTO turytc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yosef’in bütün ev halkı, kardeşleri ve babasının ev halkı onunla birlikte çıktılar. Goşen diyarında yalnızca çocuklarını, sürülerini ve sığırlarını geride bıraktılar. ");
INSERT INTO turytc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Savaş arabaları ve atlılar onunla birlikte çıktılar. Kalabalık bir topluluk oldular. ");
INSERT INTO turytc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Yarden'in ötesindeki Atad'ın harman yerine varınca, yüksek sesle acı acı ağıt yaktılar. Babası için yedi gün yas tuttular. ");
INSERT INTO turytc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ülkede yaşayan Kenanlılar, Atad'ın harman yerindeki yası görünce, “Bu, Mısırlılar'ın hüzünlü yasıdır” dediler. Bu nedenle Yarden'in ötesinde olan o yere Avel-Misrayim (Mısırlılar’ın yası) adı verildi. ");
INSERT INTO turytc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Oğulları ona tam kendilerine buyurduğu gibi yaptı. ");
INSERT INTO turytc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Onu Kenan ülkesine götürdüler. Avraham’ın mezar yeri olarak Hititli Efron’dan tarlasıyla birlikte mülk olarak satın almış olduğu Mamre karşısında Makpela Tarlası'ndaki mağaraya gömdüler. ");
INSERT INTO turytc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef, kendisi, kardeşleri ve babasını gömmek için onunla birlikte gelenlerin hepsi babasını gömdükten sonra Mısır'a döndüler. ");
INSERT INTO turytc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosef’in kardeşleri babalarının öldüğünü görünce, “Belki Yosef bizden nefret edecek ve ona yaptığımız bütün kötülüklerin karşılığını bize ödetecek” dediler. ");
INSERT INTO turytc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Yosef’e haber gönderip şöyle dediler: “Baban ölmeden önce şöyle buyurmuştu: ");
INSERT INTO turytc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yosef’e şunu söyleyin: Şimdi lütfen kardeşlerinin itaatsizliğini ve günahlarını bağışla. Çünkü sana kötülük ettiler.’ Şimdi, lütfen babanın Tanrısı'nın hizmetkârlarının itaatsizliğini bağışla.” Yosef onlar kendisiyle konuşurken ağladı. ");
INSERT INTO turytc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kardeşleri de gidip onun önünde yere kapandılar ve şöyle dediler: “Bak, biz senin hizmetkârlarınız.” ");
INSERT INTO turytc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yosef onlara, “Korkmayın, çünkü ben Tanrı'nın yerinde miyim? ");
INSERT INTO turytc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Siz bana kötülük düşündünüz, ama Tanrı bugün olduğu gibi birçok halkın yaşamını kurtarmak için bunu iyiliğe çevirdi. ");
INSERT INTO turytc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bu nedenle şimdi korkmayın. Size ve çocuklarınıza bakacağım.” Onları teselli ederek yumuşak bir şekilde onlarla konuştu. ");
INSERT INTO turytc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosef, babasının ev halkıyla birlikte Mısır'da yaşıyordu. Yosef yüz on yıl yaşadı. ");
INSERT INTO turytc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosef üçüncü kuşaktan Efraim'in çocuklarını gördü. Manaşşe oğlu Makir'in çocukları da Yosef'in dizleri üzerinde doğdu. ");
INSERT INTO turytc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosef kardeşlerine, “Ben ölüyorum” dedi, “Tanrı sizi mutlaka ziyaret edecektir ve sizi bu ülkeden Avraham’a, İshak'a ve Yakov'a ant içerek söz verdiği ülkeye götürecektir.” ");
INSERT INTO turytc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yosef İsraelliler'den, “Tanrı mutlaka sizi ziyaret edecektir, kemiklerimi buradan çıkaracaksınız” diye ant içirdi. ");
INSERT INTO turytc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Böylece Yosef yüz on yaşında öldü. Onu mumyaladılar ve Mısır'da bir tabuta koydular. ");
INSERT INTO turytc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Mısır'a gelen İsrael'in oğullarının adları şunlardır (her biri ve onun ev halkı Yakov'la birlikte geldi): ");
INSERT INTO turytc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruven, Şimon, Levi, Yahuda, ");
INSERT INTO turytc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","İsakar, Zevulun, Benyamin, ");
INSERT INTO turytc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad ve Aşer. ");
INSERT INTO turytc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakov'un bedeninden gelen canların tümü yetmiş candı ve Yosef zaten Mısır'daydı. ");
INSERT INTO turytc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosef de kardeşleri ve tüm o kuşak gibi öldü. ");
INSERT INTO turytc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","İsrael'in çocukları verimli oldular, bolca artıp çoğaldılar, fazlasıyla güçlendiler ve ülke onlarla doldu. ");
INSERT INTO turytc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Şimdi Mısır üzerinde Yosef'i tanımayan yeni bir kral çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Halkına şöyle dedi, “İşte , İsrael'in çocuklarının halkı bizden daha çok ve daha güçlü. ");
INSERT INTO turytc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Gelin, onlara karşı bilgece davranalım, yoksa çoğalacaklar, olur da bir savaş çıkarsa, onlar da düşmanlarımıza katılıp bize karşı savaşır ve ülkeden kaçarlar. ");
INSERT INTO turytc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Bu nedenle yükleriyle onlara sıkıntı çektirmek için üzerlerine angarya görevlileri atadılar. ");
INSERT INTO turytc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ama onlara ne kadar eziyet ettilerse, onlar o kadar çok çoğaldılar ve daha da yayıldılar. ");
INSERT INTO turytc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mısırlılar İsrael'in çocuklarına acımasızca hizmet ettirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Her türlü tarla işi, harç ve kerpiç işi gibi ağır işlerle yaşamlarını zehir ettiler, onları acımasızca hizmet ettirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mısır Kralı, birinin adı Şifrah, diğerinin adı Puah olan İbrani ebelerle konuştu. ");
INSERT INTO turytc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ve şöyle dedi, “İbrani kadınlara ebelik yaptığınızda, onları doğum sandalyesinde gördüğünüzde, eğer çocuk erkekse, öldürün, kızsa yaşasın.” ");
INSERT INTO turytc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ama ebeler Tanrı'dan korktular, Mısır Kralı'nın kendilerine buyurduğu şeyi yapmayıp, erkek çocukları canlı kurtardılar. ");
INSERT INTO turytc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mısır Kralı ebeleri çağırıp onlara, “Neden bunu yapıp erkek çocukları canlı kurtardınız?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ebeler Firavun'a şöyle dediler, “Çünkü İbrani kadınlar Mısırlı kadınlara benzemiyor. Onlar güçlü oldukları için ebe yanlarına gelmeden doğum yapıyor.” ");
INSERT INTO turytc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Tanrı ebelere iyi davrandı ve halk çoğalıp fazlasıyla güçlendi. ");
INSERT INTO turytc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ebeler Tanrı'dan korktukları için Tanrı onlara aileler verdi. ");
INSERT INTO turytc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Firavun halkının tümüne şöyle buyurdu, “Doğan her erkek çocuğu nehre atın, her kız çocuğu canlı kurtarın.” ");
INSERT INTO turytc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Levi evinden bir adam gitti ve bir Levi kızını aldı. ");
INSERT INTO turytc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kadın gebe kaldı ve bir oğul doğurdu. Kadın çocuğun güzel olduğunu görünce onu üç ay sakladı. ");
INSERT INTO turytc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Artık onu daha fazla gizleyemeyince, papirüs ağacından bir sepet alıp onu katranla kapladı. Çocuğu içine koydu ve nehrin kıyısındaki sazlığa bıraktı. ");
INSERT INTO turytc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kız kardeşi ona ne olacağını görmek için uzakta duruyordu. ");
INSERT INTO turytc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Firavun'un kızı yıkanmak için nehre indi. Onun hizmetçileri nehrin kenarında yürüyorlardı. Sazların arasındaki sepeti gördü ve onu alması için hizmetçilerini gönderdi. ");
INSERT INTO turytc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Onu açtı ve çocuğu gördü. İşte bebek ağlıyordu. Ona acıdı ve şöyle dedi, “Bu İbraniler'in çocuklarından biridir.” ");
INSERT INTO turytc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Bunun üzerine kız kardeşi, Firavun'un kızına, “Çocuğu emzirmesi için sana İbrani kadınlardan bir dadı çağırayım mı?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Firavun'un kızı ona, “Git” dedi. Genç kız gidip çocuğun annesini çağırdı. ");
INSERT INTO turytc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Firavun'un kızı ona, “Bu çocuğu al ve benim için emzir, ben de ücretini veririm” dedi. Kadın çocuğu alıp emzirdi. ");
INSERT INTO turytc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Çocuk büyüdü ve kadın onu Firavun'un kızına getirdi ve onun oğlu oldu. Ona Moşe adını verdi, “Çünkü onu sudan çıkardım” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moşe büyüdüğü o günlerde kardeşlerinin yanına çıktı ve onların yüklerini gördü. Bir Mısırlı'nın kardeşlerinden biri olan bir İbrani'ye vurduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Çevresine bakınıp kimsenin olmadığını görünce Mısırlı'yı öldürüp kumun içine sakladı. ");
INSERT INTO turytc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ertesi gün çıktı, işte iki İbrani birbiriyle kavga ediyordu. Yanlış yapana, “Neden arkadaşına vuruyorsun?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Adam, “Kim seni üzerimize bey ve yargıç yaptı? Mısırlı'yı öldürdüğün gibi beni de öldürmeyi mi tasarlıyorsun?” dedi. Moşe korktu, “Bu şey kesin biliniyor” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Firavun bunu duyunca Moşe'yi öldürmeye çalıştı. Ama Moşe Firavun'un önünden kaçtı ve Midyan diyarında yaşadı ve bir kuyunun yanına oturdu. ");
INSERT INTO turytc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midyanlı bir kâhinin yedi kızı vardı. Gelip su çektiler ve babalarının sürüsünü sulamak için yalakları doldurdular. ");
INSERT INTO turytc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Çobanlar gelip onları uzaklaştırdı. Ama Moşe kalktı ve onlara yardım etti ve sürülerini suladı. ");
INSERT INTO turytc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Babaları Reuel'in yanına vardıklarında o, “Nasıl oldu da bugün bu kadar erken geldiniz?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Onlar, “Mısırlı bir adam bizi çobanların elinden kurtardı, üstelik bizim için su çekip sürüyü suladı” dediler. ");
INSERT INTO turytc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Adam kızlarına, “Nerede o? Adamı neden bıraktınız? Onu çağırın da yemek yesin” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moşe adamın yanında kalmaktan hoşnuttu. Adam kızı Sipporah'ı Moşe'ye verdi. ");
INSERT INTO turytc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Bir oğul doğurdu ve o, adını Gerşom koydu; “Çünkü yabancı bir diyarda garip olarak yaşıyorum” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Aradan çok sayıda günler gelip geçti, Mısır Kralı öldü. İsrael'in çocukları esaretten dolayı ah çektiler, feryat ettiler ve feryatları esaret nedeniyle Tanrı'ya ulaştı. ");
INSERT INTO turytc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tanrı onların iniltilerini duydu ve Tanrı Avraham'la, İshak'la ve Yakov'la yaptığı antlaşmayı hatırladı. ");
INSERT INTO turytc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tanrı İsrael'in çocuklarını gördü ve Tanrı anladı. ");
INSERT INTO turytc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moşe, kayınpederi Midyanlı Yetro'nun sürüsünü güdüyordu. Sürüyü çölün arka tarafına götürüp Tanrı Dağı'na, Horev'e geldi. ");
INSERT INTO turytc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yahve'nin meleği bir çalının ortasındaki alevin içinde ona göründü. Baktı, işte, çalı ateşte yanıyordu ama tükenmiyordu. ");
INSERT INTO turytc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moşe, “Şimdi gidip bu büyük manzarayı, çalının neden tükenmediğini göreyim” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yahve onun bakmaya geldiğini görünce, Tanrı ona çalının ortasından seslenip şöyle dedi, “Moşe! Moşe!” O, “İşte buradayım” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Yaklaşma. Çarıklarını çıkar, çünkü üzerinde durduğun yer kutsal topraktır” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Üstelik, “Ben babanın Tanrısı, Avraham'ın Tanrısı, İshak'ın Tanrısı ve Yakov'un Tanrısı'yım” dedi. Moşe, yüzünü sakladı çünkü Tanrı'ya bakmaya korkuyordu. ");
INSERT INTO turytc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahve şöyle dedi, “Mısır'da olan halkımın sıkıntısını elbette gördüm, angarya görevlileri yüzünden feryatlarını duydum. Çünkü onların acılarını biliyorum. ");
INSERT INTO turytc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Onları Mısırlılar'ın elinden kurtarmak ve o ülkeden iyi ve geniş bir ülkeye süt ve bal akan bir ülkeye, Kenanlı, Hititli, Amorlu, Perizli, Hivli ve Yevuslular'ın yerine götürmek için aşağıya indim. ");
INSERT INTO turytc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","İşte, İsrael çocuklarının feryadı bana ulaştı. Üstelik Mısırlılar'ın onlara ettiği zulmü gördüm. ");
INSERT INTO turytc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Bu nedenle şimdi gel, halkım İsrael'in çocuklarını Mısır'dan çıkarman için seni Firavun'a göndereyim.” ");
INSERT INTO turytc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moşe Tanrı'ya, “Ben kimim ki, Firavun'a gideyim de İsrael'in çocuklarını Mısır'dan çıkarayım?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ve Tanrı, “Ben kesinlikle seninle olacağım. Seni gönderdiğimin belirtisi şu olacak, halkı Mısır'dan çıkardığın zaman, bu dağda Tanrı'ya hizmet edeceksiniz” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moşe Tanrı'ya şöyle dedi, “İşte, İsrael'in çocuklarının yanına gelip onlara, 'Beni size atalarınızın Tanrısı gönderdi' dediğimde, onlar bana, 'O'nun adı nedir?' diye sorduklarında, onlara ne diyeyim?” ");
INSERT INTO turytc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Tanrı Moşe'ye, “BEN BEN OLAN'IM” dedi ve, “İsrael'in çocuklarına şunu diyeceksin” dedi: 'Beni size BEN'İM gönderdi.'” ");
INSERT INTO turytc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ayrıca Tanrı Moşe'ye, “İsrael'in çocuklarına böyle diyeceksin” dedi, “'Atalarınızın Tanrısı, Avraham'ın Tanrısı, İshak'ın Tanrısı ve Yakov'un Tanrısı Yahve beni size gönderdi.' Sonsuza dek adım bu ve bütün kuşaklarca anılmam budur. ");
INSERT INTO turytc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Git, İsrael'in ihtiyarlarını bir araya topla ve onlara şöyle de: 'Atalarınızın Tanrısı, Avraham'ın Tanrısı, İshak'ın Tanrısı ve Yakov'un Tanrısı Yahve bana göründü ve şöyle dedi: Sizi gerçekten ziyaret ettim ve Mısır'da size yapılanı gördüm. ");
INSERT INTO turytc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Dedim ki, sizi Mısır'ın sıkıntısından, Kenanlı Hititli, Amorlu, Perizli, Hivli ve Yevuslular'ın ülkesine, süt ve bal akan diyara götüreceğim.' ");
INSERT INTO turytc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Onlar sözünü dinleyecekler. Sen ve İsrael'in ihtiyarları Mısır Kralı'nın yanına gelip ona, 'İbraniler'in Tanrısı Yahve bizimle görüştü diyeceksiniz. Şimdi lütfen izin ver de Tanrımız Yahve'ye kurban sunmak için üç günlük bir yolculuk yapalım.' ");
INSERT INTO turytc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mısır Kralı'nın güçlü bir el aracılığıyla olsa bile gitmek için size izin vermeyeceğini biliyorum. ");
INSERT INTO turytc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Elimi uzatıp aralarında yapacağım harikalarla Mısır'ı vuracağım. Ondan sonra sizi bırakacak. ");
INSERT INTO turytc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mısırlılar'ın gözünde bu halka lütuf vereceğim. Öyle ki, gittiğiniz zaman eli boş gitmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ancak her kadın komşusundan ve evini ziyaret edenden gümüş takılar, altın takılar ve giysiler isteyecek. Bunları oğullarınızın ve kızlarınızın üzerine takacaksınız. Mısırlılar'ı yağmalayacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moşe şöyle yanıt verdi, “Ama, işte, bana inanmayacaklar, ne de sözümü dinleyecekler, çünkü 'Yahve sana görünmedi' diyecekler.” ");
INSERT INTO turytc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahve ona, “Elindeki nedir?” dedi. O, “Bir değnek” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“Onu yere at” dedi. O yere attı ve bir yılan oldu. Moşe ondan kaçtı. ");
INSERT INTO turytc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahve Moşe'ye, “Elini uzat ve kuyruğundan tut” dedi. O elini uzattı ve tuttu. Elinde bir değnek oldu. ");
INSERT INTO turytc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Bu atalarının Tanrısı, Avraham'ın Tanrısı, İshak'ın Tanrısı ve Yakov'un Tanrısı Yahve'nin sana göründüğüne iman etmeleri içindir.” ");
INSERT INTO turytc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahve ayrıca ona, “Şimdi elini abanın içine koy” dedi. Elini abasının içine soktu ve onu çıkardığında, işte, eli kar gibi beyaz cüzamlıydı. ");
INSERT INTO turytc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Elini yine abanın içine koy” dedi. Elini tekrar abasının içine soktu ve onu abasından çıkardığında, işte, yine diğer eti gibi olmuştu. ");
INSERT INTO turytc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Eğer sana inanmazlarsa ya da ilk belirtinin sözünü dinlemezlerse, sonraki belirtinin sözüne inanacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Eğer bu iki belirtiye de inanmazlarsa ya da sözünü dinlemezlerse, şöyle olacak, ırmağın suyundan alıp kuru toprağa dökeceksin. Irmaktan çıkaracağın su, kuru toprak üzerinde kana dönüşecek.” ");
INSERT INTO turytc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moşe Yahve'ye şöyle dedi, “Ey Efendim, ne önceden, ne de hizmetkârınla konuştuğundan beri güzel konuşan biri değilim. Çünkü ben konuşmada yavaşım ve yavaş dilliyim.” ");
INSERT INTO turytc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yahve ona şöyle dedi, “İnsanın ağzını yapan kim? Ya da insanı dilsiz, sağır, gören ya da kör yapan kimdir? Ben Yahve değil miyim? ");
INSERT INTO turytc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Bu nedenle şimdi git, ben de senin ağzınla olacağım ve ne konuşacağını sana öğreteceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moşe, “Ey Efendim, lütfen başka birisini gönder” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yahve Moşe'ye karşı öfkelendi ve şöyle dedi, “Peki ya kardeşin Levili Aron? Onun iyi konuşabildiğini biliyorum. Hem de, işte, o seni karşılamak için dışarı çıkıyor. Seni gördüğünde yüreği sevinecek. ");
INSERT INTO turytc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Onunla konuşacaksın ve sözleri onun ağzına koyacaksın. Ben senin ağzınla ve onun ağzıyla olacağım ve yapacağınız şeyi size öğreteceğim. ");
INSERT INTO turytc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","O senin halka karşı sözcün olacak. Öyle olacak ki, o sana ağız ve sen de ona Tanrı gibi olacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Belirtileri onunla yapacağın bu değneği eline alacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moşe gidip kayınpederi Yetro'nun yanına döndü ve ona, “Lütfen izin ver de gidip Mısır'daki kardeşlerimin yanına döneyim, onlar hâlâ hayatta mı göreyim?” dedi. Yetro Moşe'ye, “Esenlikle git” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahve Midyan'da Moşe'ye şöyle dedi, “Git, Mısır'a dön; çünkü seni öldürmeye çalışan bütün insanlar öldü.” ");
INSERT INTO turytc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moşe karısını ve oğullarını alıp bir eşeğe bindirdi ve Mısır ülkesine döndü. Moşe Tanrı'nın değneğini eline aldı. ");
INSERT INTO turytc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahve Moşe'ye şöyle dedi, “Mısır'a döndüğün zaman, sana verdiğim bütün harikaları Firavun'un önünde yapmaya bak, ama ben onun yüreğini katılaştıracağım ve o, halkın gitmesine izin vermeyecek. ");
INSERT INTO turytc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Firavun'a de ki, 'Yahve diyor ki, İsrael benim ilk oğlum, ilk doğanımdır. ");
INSERT INTO turytc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ben de sana, 'Oğlumu bırak, bana hizmet etsin' dedim ve sen onun gitmesine izin vermeyi reddettin. İşte, ilk doğan oğlunu öldüreceğim.'” ");
INSERT INTO turytc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yahve, konaklayacağı yere giderken yolda Moşe'yle karşılaştı ve onu öldürmek istedi. ");
INSERT INTO turytc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Bunun üzerine Sipporah bir çakmaktaşı alıp oğlunun sünnet derisini kesip ayaklarının dibine attı ve şöyle dedi, “Kesinlikle sen bana kan güveyisin.” ");
INSERT INTO turytc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Bunun üzerine onu rahat bıraktı. Daha sonra sünnetten dolayı “Sen kan güveyisin” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahve Aron'a, “Moşe'yi karşılamak için çöle git” dedi. Gidip Tanrı'nın dağında onunla karşılaştı ve onu öptü. ");
INSERT INTO turytc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moşe, Yahve'nin kendisiyle gönderdiği tüm sözleri ve kendisine buyurmuş olduğu bütün belirtileri Aron'a anlattı. ");
INSERT INTO turytc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moşe ile Aron gidip İsrael çocuklarının bütün ihtiyarlarını bir araya topladılar. ");
INSERT INTO turytc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron, Yahve'nin Moşe'ye söylediği bütün sözleri söyledi ve halkın önünde belirtileri yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Halk iman etti ve Yahve'nin İsrael çocuklarını ziyaret ettiğini, onların sıkıntılarını gördüğünü duyunca başlarını eğerek tapındılar. ");
INSERT INTO turytc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Daha sonra Moşe ile Aron gelip Firavun'a şöyle dediler, “İsrael'in Tanrısı Yahve şöyle diyor, 'Halkımın gitmesine izin ver, çölde bana bayram etsinler.'” ");
INSERT INTO turytc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firavun şöyle dedi, “Yahve kim ki, İsrael'in gitmesine izin vermek için O'nun sözünü dinleyeyim? Yahve'yi tanımıyorum ve dahası İsrael'in gitmesine izin vermeyeceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Onlar, “İbraniler'in Tanrısı bizimle görüştü” dediler. Lütfen, çölde üç günlük yol almamıza izin ver ki, Tanrımız Yahve'ye kurban keselim. Yoksa üzerimize salgın hastalık ya da kılıçla inebilir.” ");
INSERT INTO turytc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mısır Kralı onlara şöyle dedi, “Ey Moşe ve Aron, neden halkı işlerinden alıkoyuyorsunuz? Yüklerinize geri dönün!” ");
INSERT INTO turytc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Firavun, “İşte, şimdi ülke halkı çoktur, siz onları yüklerinden dinlendiriyorsunuz” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Aynı gün Firavun halkın angarya görevlilerine ve memurlara şu emri verdi, ");
INSERT INTO turytc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Artık eskisi gibi halka kerpiç yapmaları için saman vermeyeceksiniz. Gidip kendileri için saman toplasınlar. ");
INSERT INTO turytc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Onlardan daha önce yaptıkları kerpiçlerin sayısını isteyeceksiniz. Ondan hiçbir şey eksiltmeyeceksiniz; çünkü onlar tembeldirler. Bu nedenle, 'Hadi gidip Tanrımız'a kurban keselim' diyerek bağırıyorlar. ");
INSERT INTO turytc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Adamların üzerine daha ağır işler yüklensinler ki, çalışsınlar. Yalan sözlere aldırış etmesinler.” ");
INSERT INTO turytc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Halkın angarya görevlileri memurlarıyla birlikte dışarı çıktılar ve halka şöyle konuşup dediler, “Firavun şöyle diyor, 'Size saman vermeyeceğim. ");
INSERT INTO turytc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Siz gidin, bulduğunuz yerden saman alın; çünkü işinizden hiçbir şey eksiltilmeyecektir.'” ");
INSERT INTO turytc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Böylece halk, saman için anız toplamak amacıyla tüm Mısır diyarına dağıldı. ");
INSERT INTO turytc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Angaryacılar aceleyle, “Saman varken olduğu gibi gündelik iş kotanızı doldurun!” diyorlardı! ");
INSERT INTO turytc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Firavun'un angaryacılarının üzerlerine atadığı İsrael'in çocuklarının memurları dövüldü ve onlara, “Daha önce olduğu gibi kerpiç yapımında neden dün de bugün de kotanızı doldurmadınız?” diye soruldu. ");
INSERT INTO turytc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Bunun üzerine İsrael'in çocuklarının memurları gelip Firavun'a şöyle feryat ettiler, “Hizmetkârlarına neden böyle davranıyorsun? ");
INSERT INTO turytc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hizmetkârlarına saman verilmiyor ve bize, 'Kerpiç yap!' diyorlar. Ama işte hizmetkârların dövülüyor; ama suç senin kendi halkındadır.” ");
INSERT INTO turytc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ama Firavun, “Siz tembelsiniz” dedi. “Boş duruyorsunuz! Bu nedenle, 'Hadi gidip Yahve'ye kurban keselim' diyorsunuz. ");
INSERT INTO turytc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Bunun için şimdi gidin ve çalışın, çünkü size saman verilmeyecek; yine de aynı sayıda kerpiç teslim edeceksiniz!” ");
INSERT INTO turytc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","İsrael'in çocuklarının memurları, “Günlük kerpiç kotanızdan hiçbir şey eksiltmeyeceksiniz!” denildiğinde başlarının belada olduğunu anladılar. ");
INSERT INTO turytc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Firavun'un yanından çıkarken yolda durmakta olan Moşe ve Aron'la karşılaştılar. ");
INSERT INTO turytc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Onlara, “Yahve size baksın ve yargılasın” dediler, “Çünkü bizi Firavun'un ve hizmetkârlarının gözünde tiksindirici bir koku yaptınız, bizi öldürmeleri için ellerine bir kılıç verdiniz.” ");
INSERT INTO turytc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moşe Yahve'ye dönüp şöyle dedi, “Ey Efendi, neden bu halkın başına dert açtın? Beni neden gönderdin? ");
INSERT INTO turytc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Senin adına konuşmak için Firavun'a geldiğimden beri, o bu halkın başına bela getirdi. Sen de halkını hiç kurtarmadın!” ");
INSERT INTO turytc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yahve Moşe'ye şöyle dedi, “Şimdi Firavun'a ne yapacağımı göreceksin; çünkü güçlü el ile onların gitmesine izin verecek ve güçlü el ile onları ülkesinden kovacak.” ");
INSERT INTO turytc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Tanrı Moşe'ye konuşup ona şöyle dedi, “Ben Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Avraham'a, İshak'a ve Yakov'a Her Şeye Gücü Yeten Tanrı olarak göründüm, ama onlar beni Yahve adımla bilmiyordu. ");
INSERT INTO turytc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ayrıca, yabancı olarak yaşadıkları, gezip dolaştıkları Kenan ülkesini onlara vermek üzere onlarla antlaşmamı kurdum. ");
INSERT INTO turytc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Üstelik Mısırlılar'ın esaret altında tuttuğu İsrael'in çocuklarının inlemelerini duydum ve antlaşmamı hatırladım. ");
INSERT INTO turytc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Bu nedenle İsrael'in çocuklarına de ki, 'Ben Yahve'yim ve sizi Mısırlılar'ın yükleri altından çıkaracağım, sizi onların esaretinden kurtaracağım ve uzanmış kolumla ve büyük hükümlerle sizi kurtaracağım. ");
INSERT INTO turytc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Sizi kendime bir halk olarak alacağım. Sizin Tanrınız olacağım ve bileceksiniz ki, sizi Mısırlılar'ın yükleri altından çıkaran Tanrınız Yahve benim. ");
INSERT INTO turytc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Avraham'a, İshak'a ve Yakov'a vermeye söz verdiğim ülkeye sizi getireceğim ve onu miras olarak size vereceğim. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moşe İsrael'in çocuklarına böyle söyledi, ama onlar ruh ıstırabından ve acımasız esaretten dolayı Moşe'yi dinlemediler. ");
INSERT INTO turytc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahve Moşe'ye şöyle konuştu, ");
INSERT INTO turytc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“İçeri gir, Mısır Kralı Firavun'a İsrael çocuklarının ülkesinden gitmesine izin vermesini söyle.” ");
INSERT INTO turytc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moşe Yahve'nin huzurunda şöyle dedi, “İşte, İsrael'in çocukları beni dinlemediler. Dudaklarım sünnetsizken, Firavun beni nasıl dinleyecek?” ");
INSERT INTO turytc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahve Moşe ve Aron'la konuştu ve onlara İsrael'in çocuklarına ve Mısır Kralı Firavun'a, İsrael'in çocuklarını Mısır diyarından çıkarmaları buyruğunu verdi. ");
INSERT INTO turytc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Bunlar babalarının evlerinin başlarıdır. İsrael'in ilk oğlu Ruven'in oğulları: Hanok ve Pallu, Hetsron ve Karmi. Bunlar Ruven'in aileleridir. ");
INSERT INTO turytc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Şimon'un oğulları: Yemuel, Yamin, Ohad, Yakin, Zohar ve Kenanlı bir kadının oğlu Şaul. Bunlar Şimon'un aileleridir. ");
INSERT INTO turytc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kuşaklarına göre Levi oğullarının adları şunlardır: Gerşon, Kohat, Merari ve Levi'nin yaşam yılları yüz otuz yedi yıldı. ");
INSERT INTO turytc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerşon'un oğulları: Ailelerine göre Livni ve Şimi. ");
INSERT INTO turytc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat'ın oğulları: Amram, Yishar, Hebron, Uzziel. Kohat'ın yaşam yılları yüz otuz üç yıldı. ");
INSERT INTO turytc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari'nin oğulları: Mahli ve Muşi. Kuşaklarına göre Levi boyları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram babasının kız kardeşi Yokevet'i kendine eş olarak aldı ve ona Aron'la Moşe'yi doğurdu. Amram'ın yaşam yılları yüz otuz yedi yıldı. ");
INSERT INTO turytc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yishar'ın oğulları: Korah, Nefek ve Zikri. ");
INSERT INTO turytc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel'in oğulları: Mişael, Elsafan ve Sitri. ");
INSERT INTO turytc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron, Nahşon'un kız kardeşi Amminadav'ın kızı Elişeva'yı kendine eş olarak aldı ve ona Nadav'ı, Avihu'yu, Eleazar'ı ve İtamar'ı doğurdu. ");
INSERT INTO turytc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah'ın oğulları: Assir, Elkana ve Aviasaf. Bunlar Korahoğulları'nın aileleridir. ");
INSERT INTO turytc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron'un oğlu Eleazar Putiel'in kızlarından birini kendine eş olarak aldı ve ona Phinehas'ı doğurdu. Ailelerine göre Levililer'in babalarının başları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Bunlar, Yahve'nin, “İsrael'in çocuklarının ordularına göre Mısır diyarından çıkarın” dediği Aron ve Moşe'dir. ");
INSERT INTO turytc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","İsrael'in çocuklarını Mısır'dan çıkarmak için Mısır Kralı Firavun'la konuşanlar bunlardı. Bunlar Moşe ve Aron'dur. ");
INSERT INTO turytc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Yahve'nin Mısır'da Moşe'yle konuştuğu gün, ");
INSERT INTO turytc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yahve Moşe'ye şöyle dedi: “Ben Yahve'yim. Sana söyleyeceklerimin hepsini Mısır Kralı Firavun'a söyle.” ");
INSERT INTO turytc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moşe Yahve'nin huzurunda şöyle dedi, “İşte, ben sünnetsiz dudakları olan biriyim, Firavun beni nasıl dinleyecek?” ");
INSERT INTO turytc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahve Moşe'ye şöyle dedi, “İşte, seni Firavun'a Tanrı gibi yaptım ve kardeşin Aron senin peygamberin olacak. ");
INSERT INTO turytc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Sana buyurduğum her şeyi söyleyeceksin ve kardeşin Aron Firavun'la konuşacak, ta ki, İsrael'in çocuklarının kendi ülkesinden gitmesine izin versin. ");
INSERT INTO turytc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Firavun'un yüreğini katılaştıracağım, Mısır diyarında belirtilerimi ve harikalarımı çoğaltacağım. ");
INSERT INTO turytc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ama Firavun seni dinlemeyecek, o zaman elimi Mısır'ın üzerine koyacağım ve ordularımı, halkım İsrael'in çocuklarını, büyük hükümlerle Mısır diyarından çıkaracağım. ");
INSERT INTO turytc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mısır'a elimi uzattığım ve İsrael çocuklarını aralarından çıkardığım zaman, Mısırlılar benim Yahve olduğumu bilecekler.” ");
INSERT INTO turytc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moşe ve Aron da öyle yaptılar. Yahve onlara nasıl buyurduysa öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Firavun'la konuştuklarında Moşe seksen, Aron da seksen üç yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahve Moşe ve Aron'la konuşup şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Firavun seninle konuşup, 'Bir mucize gerçekleştir' derse, o zaman Aron'a, 'Değneğini al ve onu Firavun'un önüne at, değnek yılan olacak' diyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moşe ile Aron Firavun'un yanına gittiler ve Yahve'nin buyurduğu gibi yaptılar. Aron değneğini Firavun'un ve hizmetkârlarının önüne attı ve değneği bir yılana dönüştü. ");
INSERT INTO turytc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Bunun üzerine Firavun bilgeleri ve büyücüleri de çağırdı. Mısır'ın büyücüleri, onlar da büyüleriyle aynı şeyi yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Çünkü her biri kendi değneğini attı ve yılana dönüştüler, ama Aron'un değneği onların değneklerini yuttu. ");
INSERT INTO turytc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Firavun'un yüreği katılaştı ve Yahve'nin söylemiş olduğu gibi onları dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yahve Moşe'ye şöyle dedi, “Firavun'un yüreği inatçıdır. Halkı salıvermeyi reddediyor. ");
INSERT INTO turytc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sabahleyin Firavun'un yanına gidin. İşte, o suya çıkıyor. Onu karşılamak için nehrin kıyısında duracaksın. Yılana çevrilmiş değneği eline alacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ona diyeceksiniz ki, 'İbraniler'in Tanrısı Yahve, 'Halkımın gitmesine izin ver, çölde bana hizmet etsinler' diyerek beni sana gönderdi. İşte, şimdiye kadar dinlemedin.” ");
INSERT INTO turytc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahve şöyle diyor, “Bununla benim Yahve olduğumu bileceksin. İşte, ben elimdeki değneği ırmaktaki sulara vuracağım ve sular kana dönecekler. ");
INSERT INTO turytc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Irmakta bulunan balıklar ölecek, nehir kokacak. Mısırlılar ırmaktan su içmekten tiksinecekler.'' ");
INSERT INTO turytc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahve Moşe'ye şöyle dedi, “Aron'a de ki, 'Değneğini al ve elini Mısır'ın sularına, ırmaklarına, derelerine, havuzlarına ve bütün su birikintileri üzerine uzat da kan olsun. Bütün Mısır diyarında, hem ağaç kaplarda hem de taş kaplarda kan olacak.'” ");
INSERT INTO turytc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moşe ve Aron, Yahve'nin buyurduğu gibi yaptılar. Firavun'un ve hizmetkârlarının gözü önünde değneği kaldırdı ve ırmaktaki sulara vurdu ve ırmaktaki bütün sular kana döndü. ");
INSERT INTO turytc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Irmakta bulunan balıklar öldü. Irmak koktu. Mısırlılar ırmaktan su içemediler. Kan tüm Mısır diyarındaydı. ");
INSERT INTO turytc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mısır'ın büyücüleri de yaptıkları büyülerle aynı şeyi yaptılar. Böylece Firavun'un yüreği katılaştı ve Yahve'nin söylediği gibi onları dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firavun dönüp evine gitti, ama bunu ciddiye bile almadı. ");
INSERT INTO turytc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bütün Mısırlılar içecek su bulmak için nehrin çevresini kazdılar; çünkü nehrin suyunu içemiyorlardı. ");
INSERT INTO turytc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yahve'nin nehri vurmasının üzerinden yedi gün geçti. ");
INSERT INTO turytc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yahve Moşe'ye şöyle konuştu, “Firavun'un yanına git ve ona söyle, 'Yahve şöyle diyor, Halkımın gitmesine izin ver de bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Eğer onların gitmesine izin vermeyi reddedersen, işte, bütün sınırlarını kurbağalarla vuracağım. ");
INSERT INTO turytc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Irmak kurbağalarla dolup taşacak, kurbağalar yukarı çıkıp evinize, yatak odanıza, yatağınıza, hizmetkârlarının evine, halkınızın üzerine, fırınlarınıza ve hamur teknelerinize girecek. ");
INSERT INTO turytc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kurbağalar hem senin, hem halkının, hem de bütün hizmetkârlarının üzerine çıkacak.'” ");
INSERT INTO turytc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahve Moşe'ye şöyle dedi, “Aron'a de ki, ‘Değneğinle elini ırmakların, derelerin, havuzların üzerine uzat ve Mısır diyarının üzerine kurbağalar çıkart.'” ");
INSERT INTO turytc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aron elini Mısır suları üzerine uzattı ve kurbağalar çıkıp Mısır diyarını kapladılar. ");
INSERT INTO turytc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Büyücüler de büyüleriyle aynı şeyi yaptılar ve Mısır diyarı üzerine kurbağaları getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Bunun üzerine Firavun Moşe'yle Aron'u çağırıp şöyle dedi, “Yahve'ye yalvarın da kurbağaları benden ve halkımdan uzaklaştırsın. Ben de Yahve'ye kurban kesmeleri için halkın gitmesine izin vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moşe Firavun'a şöyle dedi, “Kurbağaların senden ve evlerinden yok edilmesi ve yalnızca ırmakta kalması için senin, hizmetkârların ve halkın için dua etmem için bir zaman kararlaştırma onurunu sana veriyorum.” ");
INSERT INTO turytc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firavun, “Yarın” dedi. Moşe şöyle dedi, “Sözün uyarınca olsun, ta ki, Tanrımız Yahve gibisinin olmadığını bilesin. ");
INSERT INTO turytc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kurbağalar senden, evlerinden, hizmetkârlarından ve halkından ayrılacak. Yalnızca ırmakta kalacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moşe ile Aron Firavun'un yanından ayrıldılar. Moşe, Firavun'a getirdiği kurbağalar hakkında Yahve'ye feryat etti. ");
INSERT INTO turytc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahve Moşe'nin sözüne göre yaptı ve evlerde, avlularda ve kırlarda kurbağalar öldü. ");
INSERT INTO turytc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Onları yığınlar halinde topladılar, ülke koktu. ");
INSERT INTO turytc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ama Firavun ara verildiğini görünce yüreğini katılaştırdı ve Yahve'nin söylediği gibi onları dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahve Moşe'ye şöyle dedi, “Aron'a de ki, 'Değneğini uzat ve yerin toprağına vur ki, bütün Mısır'da bit olsun.'” ");
INSERT INTO turytc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Onlar da öyle yaptılar ve Aron değneğiyle elini uzattı ve yerin toprağına vurdu. İnsanların ve hayvanların üzerinde bit vardı. Mısır diyarında yerin bütün tozu bit oldu. ");
INSERT INTO turytc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Büyücüler büyüleriyle bit yapmaya çalıştılar ama başaramadılar. İnsanda ve hayvanda bit vardı. ");
INSERT INTO turytc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Bunun üzerine büyücüler Firavun'a, “Bu, Tanrı'nın parmağıdır” dediler. Ama Firavun'un yüreği katılaştı ve Yahve'nin söylediği gibi onları dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahve Moşe'ye şöyle dedi, “Sabah erkenden kalk ve Firavun'un huzuruna çık. İşte, o, suya çıkıyor ve ona de ki, 'Yahve şöyle diyor, Halkımın gitmesine izin ver ki, bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Yoksa halkımın gitmesine izin vermezsen, işte, senin, hizmetkârlarının, halkının ve evlerinin üzerine sinek sürüleri göndereceğim. Mısırlılar'ın evleri ve bulundukları toprak sinek sürüleriyle dolu olacak. ");
INSERT INTO turytc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","O gün halkımın yaşadığı Goşen diyarını, orada sinek sürüsü olmasın diye ayıracağım, ta ki, benim yeryüzünde Yahve olduğumu bilesin. ");
INSERT INTO turytc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kendi halkımla senin halkın arasına bölme koyacağım. Bu belirti yarın gerçekleşecek.'” ");
INSERT INTO turytc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahve öyle yaptı. Firavun'un evine ve hizmetkârlarının evlerine korkunç sinek sürüleri geldi. Bütün Mısır diyarında sinek sürüleri yüzünden ülke harap oldu. ");
INSERT INTO turytc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Firavun, Moşe'yle Aron'u çağırıp, “Gidin, ülkede Tanrınız'a kurban kesin” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moşe şöyle dedi, “Böyle yapmak uygun değil. Çünkü Mısırlılar için iğrenç olanı Tanrımız Yahve'ye kurban edeceğiz. İşte, Mısırlılar için iğrenç olanı onların gözleri önünde kurban edersek, bizi taşlamazlar mı? ");
INSERT INTO turytc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Çölde üç günlük yol gideceğiz ve Tanrımız Yahve'nin bize buyuracağı gibi kurban keseceğiz.” ");
INSERT INTO turytc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firavun şöyle dedi, “Çölde Tanrınız Yahve'ye kurban kesmeniz için sizin gitmenize izin vereceğim, ama çok uzağa gitmeyeceksiniz. Benim için dua edin.” ");
INSERT INTO turytc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moşe şöyle dedi, “İşte, yanından çıkıyorum. Yarın sinek sürülerinin Firavun'dan, hizmetkârlarından ve halkından uzaklaşması için Yahve'ye dua edeceğim. Yalnız Firavun Yahve'ye kurban kesmek için halkın gitmesine izin vermeyerek bir daha hilekârlık yapmasın.” ");
INSERT INTO turytc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moşe Firavun'un yanından çıkıp Yahve'ye dua etti. ");
INSERT INTO turytc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yahve Moşe'nin sözüne göre yaptı ve Firavun'un, hizmetkârlarının ve halkının üzerinden sinek sürülerini uzaklaştırdı. Bir tane bile kalmadı. ");
INSERT INTO turytc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Firavun bu kez de yüreğini katılaştırdı ve halkın gitmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Bunun üzerine Yahve Moşe'ye şöyle dedi: “Firavun'un yanına git ve ona şunu söyle: 'İbraniler'in Tanrısı Yahve şöyle dedi: Halkımı salıver de bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Çünkü onları salıvermeyi reddedip onları daha tutarsan, ");
INSERT INTO turytc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","işte, Yahve'nin eli çok ağır bir salgınla kırdaki hayvanlarınızın, atlarınızın, eşeklerinizin, develerinizin, sığırlarınızın ve davarlarınızın üzerindedir. ");
INSERT INTO turytc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yahve İsrael'in hayvanları ile Mısır'ın hayvanları arasında ayrım yapacak. İsrael'in çocuklarına ait olanlardan hiçbiri ölmeyecek.'” ");
INSERT INTO turytc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahve belli bir zaman belirleyip şöyle dedi: “Yahve yarın ülkede bu işi yapacak.” ");
INSERT INTO turytc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yahve ertesi gün o şeyi yaptı. Mısır'ın bütün hayvanları öldü, ama İsrael'in çocuklarının hayvanlarından biri bile ölmedi. ");
INSERT INTO turytc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firavun adam gönderdi ve işte, İsrael'in çocuklarının tek bir hayvanı bile ölmemişti. Ancak Firavun'un yüreği inatçıydı ve halkın gitmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yahve Moşe ve Aron'a şöyle dedi: “Ocak külünden avuç dolusu alın ve Moşe onu Firavun'un gözü önünde havaya saçsın. ");
INSERT INTO turytc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Bütün Mısır diyarı üzerinde ince bir toz haline gelecek, bütün Mısır diyarında insanlarda ve hayvanlarda irinli çıbanlar çıkacak.” ");
INSERT INTO turytc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ocak külünü alıp Firavun'un huzuruna çıktılar. Moşe onu havaya doğru serpti, insanda ve hayvanda irinli çıbanlar oldu. ");
INSERT INTO turytc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Büyücüler çıbanlardan dolayı Moşe'nin önünde duramadılar. Çünkü büyücülerin ve bütün Mısırlılar'ın üzerinde çıbanlar vardı. ");
INSERT INTO turytc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yahve Firavun'un yüreğini katılaştırdı ve Yahve'nin Moşe'ye söylemiş olduğu gibi Firavun onları dinlemedi. ");
INSERT INTO turytc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yahve Moşe'ye şöyle dedi: “Sabah erkenden kalk, Firavun'un huzuruna çık ve ona söyle: İbraniler'in Tanrısı Yahve şöyle diyor: Halkımı salıver de bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Bu kez bütün belalarımı yüreğine, görevlilerine ve halkına göndereceğim, öyle ki, bütün yeryüzünde benim gibisinin olmadığını bilesin. ");
INSERT INTO turytc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Çünkü şimdi elimi uzatmış olsaydım, seni ve halkını vebayla vururdum, sen de yeryüzünden kesilip koparılırdın. ");
INSERT INTO turytc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ama aslında ben seni bunun için, adım tüm yeryüzünde duyurulsun diye, sana gücümü göstermek için ayakta tuttum. ");
INSERT INTO turytc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Çünkü hâlâ halkıma karşı kendini yüceltiyorsun ve onların gitmesine izin vermiyorsun. ");
INSERT INTO turytc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","İşte, yarın bu zamanlarda Mısır'da kurulduğu günden bu yana görülmemiş derecede şiddetli bir dolu yağdıracağım. ");
INSERT INTO turytc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Bu nedenle şimdi bütün hayvanlarının ve kırdaki tüm hayvanlarının barınağa alınmasını buyur. Kırda bulunan ve eve getirilmeyen her insan ve hayvanın üzerine dolu yağacak ve onlar ölecekler.'” ");
INSERT INTO turytc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firavun'un hizmetkârları arasında Yahve'nin sözünden korkanlar, hizmetçilerini ve hayvanlarını evlerine kaçırdılar. ");
INSERT INTO turytc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Yahve'nin sözüne saygı göstermeyen, hizmetçilerini ve hayvanlarını kırda bıraktı. ");
INSERT INTO turytc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yahve Moşe'ye şöyle dedi: “Elini gökyüzüne doğru uzat ki, bütün Mısır diyarında, insanların, hayvanların ve Mısır diyarındaki bütün kır otlarının üzerine dolu yağsın.” ");
INSERT INTO turytc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moşe değneğini göklere doğru uzattı ve Yahve gök gürültüsü ve dolu gönderdi ve yeryüzüne yıldırım düştü. Yahve Mısır topraklarına dolu yağdırdı. ");
INSERT INTO turytc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Böylece çok şiddetli dolu vardı ve doluyla karışık şimşekler çaktı, Mısır'ın ulus haline gelmesinden bu yana bunun gibisi olmamıştı. ");
INSERT INTO turytc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Dolu, Mısır'ın her yerinde, insan olsun hayvan olsun, kırdaki her şeyi vurdu, dolu kırdaki her bitkiyi vurdu ve kırın her ağacını kırdı. ");
INSERT INTO turytc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Yalnızca İsrael'in çocuklarının bulunduğu Goşen diyarında dolu yoktu. ");
INSERT INTO turytc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firavun Moşe'yle Aron'u çağırıp onlara şöyle dedi: “Bu sefer günah işledim. Yahve doğrudur, ben ve halkım kötüyüz. ");
INSERT INTO turytc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Yahve'ye dua edin, çünkü güçlü gök gürültüsü ve dolu yetti. Gitmenize izin vereceğim ve artık durmayacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moşe ona şöyle dedi: “Kentten çıkar çıkmaz ellerimi Yahve'ye açacağım. Gök gürlemeleri kesilecek ve artık dolu olmayacak, ta ki, yeryüzünün Yahve'ye ait olduğunu bilesin. ");
INSERT INTO turytc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ama sana ve hizmetkârlarına gelince, Yahve Tanrı'dan henüz korkmadığınızı biliyorum.” ");
INSERT INTO turytc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Keten ve arpa vuruldu, çünkü arpa olgunlaşmış, keten de çiçek açmıştı. ");
INSERT INTO turytc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ama buğday ve çavdar henüz büyümediğinden zarar görmemişti. ");
INSERT INTO turytc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moşe Firavun'un yanından kentten çıktı ve ellerini Yahve'ye açtı. Gök gürültüsü ve dolu kesildi ve yeryüzünde yağmur dindi. ");
INSERT INTO turytc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Firavun yağmurun, dolunun ve gök gürültüsünün dindiğini görünce, daha da günah işledi ve hem kendisi, hem de hizmetkârları yüreklerini katılaştırdı. ");
INSERT INTO turytc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Firavun'un yüreği katılaştı ve Yahve'nin Moşe aracılığıyla söylemiş olduğu gibi İsrael'in çocuklarının gitmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahve Moşe'ye şöyle dedi: “Firavun'un yanına git, belirtilerimi aralarında göstermek için onun ve hizmetkârlarının yüreğini katılaştırdım. ");
INSERT INTO turytc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Mısır'a neler yaptığımı, onların arasında yaptığım belirtilerimi oğluna ve oğlunun oğlunun duyacağı şekilde anlat, öyle ki, benim Yahve olduğumu bilesiniz.” ");
INSERT INTO turytc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moşe ile Aron Firavun'un yanına gidip ona şöyle dediler: “İbraniler'in Tanrısı Yahve şöyle diyor: 'Benim önümde alçakgönüllü olmayı ne zamana dek reddedeceksin? Halkımın gitmesine izin ver ki, bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Yoksa halkımın gitmesine izin vermezsen, işte, yarın ülkene çekirgeler getireceğim. ");
INSERT INTO turytc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Çekirgeler yeryüzünü kaplayacak, öyle ki kimse yeryüzünü göremeyecek. Doludan size kurtulmuş, artakalan yiyecekleri ve kırda sizin için büyüyen her ağacı yiyecekler. ");
INSERT INTO turytc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Senin evin, tüm hizmetkârlarının evleri ve tüm Mısırlılar'ın evleri, yeryüzünde bulundukları günden bugüne dek ne babaların ne de balarının babalarının görmediği şekilde dolacak.'” Dönüp Firavun'un yanından çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Firavun'un hizmetkârları ona, “Bu adam bize ne zamana dek tuzak olacak?” dediler. “Adamları bırak gitsinler de Tanrıları Yahve'ye hizmet etsinler. Mısır'ın harap olduğunu hala bilmiyor musun?” ");
INSERT INTO turytc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moşe ile Aron tekrar Firavun'un yanına getirildiler. Firavun onlara şöyle dedi: “Gidin, Tanrınız Yahve'ye hizmet edin, ama gidecek olanlar kimlerdir?” ");
INSERT INTO turytc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moşe, “Gençlerimizle, yaşlılarımızla gideceğiz” dedi. “Oğullarımızla, kızlarımızla, davarlarımızla, sığırlarımızla gideceğiz. Çünkü Yahve için bayram yapacağız.” ");
INSERT INTO turytc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","O onlara şöyle dedi: “Eğer sizi çocuklarınızla birlikte bırakırsam Yahve sizinle olsun! Bakın, kötülük apaçık önünüzdedir. ");
INSERT INTO turytc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Öyle olmaz! Ey erkekler, şimdi gidin ve Yahve'ye hizmet edin, çünkü istediğiniz şey de bu!” Sonra onlar Firavun'un huzurundan kovuldular. ");
INSERT INTO turytc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yahve Moşe'ye şöyle dedi: “Çekirgeler için elini Mısır toprakları üzerine uzat da Mısır topraklarına çıksınlar ve diyarın bütün otlarını, doludan arta kalanları yesinler.” ");
INSERT INTO turytc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moşe değneğini Mısır ülkesinin üzerine uzattı. Yahve bütün gün ve bütün gece ülkeye doğu rüzgârı getirdi. Sabah olduğunda doğu rüzgârı da çekirgeleri getirdi. ");
INSERT INTO turytc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Çekirgeler bütün Mısır topraklarına yayılıp Mısır'ın bütün sınırlarına kondu. Çok feciydiler. Onlardan önce onlar gibi çekirge olmamıştı, bir daha da olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Çünkü bütün yeryüzünü kapladılar, öyle ki, ülke karardı ve dolunun bıraktığı tüm otları ve ağaçlarda kalan tüm meyveleri yediler. Bütün Mısır diyarında kırın ağacında ve otunda hiçbir yeşillik kalmadı. ");
INSERT INTO turytc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firavun aceleyle Moşe'yle Aron'u çağırıp şöyle dedi: “Tanrınız Yahve'ye ve size karşı günah işledim. ");
INSERT INTO turytc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Şimdi lütfen günahımı bir kez daha bağışla ve bu ölümü benden uzaklaştırması için de Tanrın Yahve'ye dua et.” ");
INSERT INTO turytc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moşe Firavun'un yanından çıkıp Yahve'ye dua etti. ");
INSERT INTO turytc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yahve çok kuvvetli bir batı rüzgârı göndererek çekirgeleri alıp Kızıldeniz'e sürdü. Mısır'ın bütün sınırlarında tek bir çekirge kalmadı. ");
INSERT INTO turytc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ancak Yahve Firavun'un yüreğini katılaştırdı ve İsrael'in çocuklarının gitmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahve Moşe'ye şöyle dedi: “Elini göğe doğru uzat ki, Mısır diyarında karanlık olsun, üstelik hissedilebilen bir karanlık olsun.” ");
INSERT INTO turytc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moşe elini gökyüzüne doğru uzattı, bütün Mısır topraklarında üç gün boyunca koyu bir karanlık vardı. ");
INSERT INTO turytc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Üç gün boyunca birbirlerini görmediler ve kimse yerinden kalkmadı, ancak bütün İsrael'in çocuklarının evlerinde ışık vardı. ");
INSERT INTO turytc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firavun Moşe'yi çağırıp şöyle dedi: “Gidin, Yahve'ye hizmet edin. Yalnız davarlarınız ve sığırlarınız geride kalsın. Küçükleriniz de sizinle birlikte gitsin.” ");
INSERT INTO turytc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moşe şöyle dedi: “Tanrımız Yahve'ye kurban sunmamız için bize kurbanlar ve yakmalık sunular da vermelisin. ");
INSERT INTO turytc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Hayvanlarımız da bizimle birlikte gidecek. Geride tek bir toynak bile kalmayacak. Çünkü Tanrımız Yahve'ye hizmet etmek için onlardan almalıyız. Oraya varıncaya dek Yahve'ye neyle hizmet etmemiz gerektiğini bilmiyoruz.” ");
INSERT INTO turytc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ama Yahve Firavun'un yüreğini katılaştırdı ve o onların gitmesine izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firavun ona, “Benden uzak dur!” dedi. “Dikkatli ol, artık yüzümü görme. Çünkü yüzümü gördüğün gün öleceksin!” ");
INSERT INTO turytc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moşe, “İyi dedin.” dedi. “Bir daha yüzünü görmeyeceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yahve Moşe'ye şöyle dedi: “Firavun'un ve Mısır'ın başına bir bela daha getireceğim, ondan sonra gitmenize izin verecek. Gitmenize izin verdiğinde, sizi kesinlikle toplu olarak kovacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Şimdi halkın kulağına söyle, her adam kendi komşusundan, her kadın da kendi komşusundan gümüş, altın mücevherler istesin.'' ");
INSERT INTO turytc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahve Mısırlılar'ın gözünde halka lütuf verdi. Üstelik, Moşe denen adam Mısır diyarında Firavun'un hizmetkârlarının ve halkın gözünde çok büyüktü. ");
INSERT INTO turytc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moşe şöyle dedi: “Yahve şöyle diyor: 'Gece yarısına doğru Mısır'ın ortasına çıkacağım. ");
INSERT INTO turytc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tahtında oturan Firavun'un ilk doğanından, değirmen ardındaki cariyenin ilk doğanına kadar, Mısır ülkesindeki bütün ilk doğanlar, hayvanların ilk doğanları ölecek. ");
INSERT INTO turytc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bütün Mısır diyarında benzeri olmamış, bir daha da olmayacak büyük bir feryat kopacak. ");
INSERT INTO turytc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ancak Yahve'nin Mısırlılar ile İsraelliler arasında ayrım yaptığını bilesiniz diye, insandan hayvana dek, İsrael'in çocuklarından hiçbirine karşı bir köpek havlamayacak, dilini bile oynatmayacak. ");
INSERT INTO turytc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Bütün bu hizmetkârların aşağıya yanıma gelip önümde eğilecekler ve şöyle diyecekler: “Sen ve ardından gelen bütün halkla birlikte çıkın.” ve ben ondan sonra çıkacağım.'” Firavun'un yanından kızgın bir öfkeyle çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahve Moşe'ye, “Mısır ülkesinde harikalarım çoğalsın diye Firavun seni dinlemeyecek” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moşe ve Aron tüm bu harikaları Firavun'un önünde yaptılar, ama Yahve Firavun'un yüreğini katılaştırdı ve İsrael'in çocuklarının ülkesinden çıkmasına izin vermedi. ");
INSERT INTO turytc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahve Mısır'da Moşe ve Aron'la konuşup şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Bu ay sizin için ayların başlangıcı olacak. Bu sizin için yılın ilk ayı olacak. ");
INSERT INTO turytc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Bütün İsrael topluluğuna konuşup söyleyin, 'Bu ayın onuncu günü, her biri kendilerine bir kuzu, atalarının evlerine göre, ev halkına bir kuzu alacak. ");
INSERT INTO turytc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Eğer ev halkı bir kuzu için çok küçükse, o zaman o ve evinin yanındaki komşusu, canların sayısına göre bir tane alacaklar. Kuzu hesabını herkesin yiyebileceği kadarıyla yapacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kuzunuz kusursuz, bir yaşında erkek olacak. Onu koyunlardan ya da keçilerden alacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Onu aynı ayın on dördüncü gününe dek saklayacaksınız. İsrael halkının bütün topluluğu akşam onu öldürecekler. ");
INSERT INTO turytc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kanın bir kısmını alıp onu içlerinde yiyecekleri evlerin iki kapı sövesine ve üst eşiği üzerine sürecekler. ");
INSERT INTO turytc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","O gece ateşte kızartılmış eti mayasız ekmekle yiyecekler. Onu acı otlarla yiyecekler. ");
INSERT INTO turytc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Onu ne çiğ, ne de suda haşlanmış yiyin, yalnızca başı, bacakları ve iç kısımlarıyla birlikte ateşte kızarmış olarak yiyin. ");
INSERT INTO turytc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sabaha kadar ondan hiçbir şey kalmayacak, ondan sabaha kadar artakalanı ateşle yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Eti şu şekilde yiyeceksiniz: Kuşağınız belinizde, çarıklarınız ayağınızda ve değneğiniz elinizde olacak. Onu acele ederek yiyeceksiniz, bu, Yahve'nin Pesah'ıdır. ");
INSERT INTO turytc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Çünkü o gece Mısır diyarından geçeceğim ve Mısır diyarında insan olsun hayvan olsun bütün ilk doğanları vuracağım. Mısır'ın bütün ilâhlarını yargılayacağım. Ben Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Bulunduğunuz evlerin kanı sizin için bir işaret olacak. Kanı görünce üzerinizden geçeceğim ve Mısır diyarını vurduğumda üzerinizde sizi yok edecek bela olmayacak. ");
INSERT INTO turytc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Bugün sizin için bir anma günü olacak. Onu Yahve'ye bir bayram olarak tutacaksınız. Sonsuza dek süren bir kuralla onu kuşaklarınız boyunca bayram olarak tutacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“'Yedi gün mayasız ekmek yiyeceksiniz. Hatta ilk gün evinizden mayayı çıkaracaksınız, çünkü kim birinci günden yedinci güne kadar mayalı ekmek yerse, o can İsrael'den atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","İlk gün sizin için kutsal bir toplantı olacak, yedinci gün de kutsal bir toplantı olacaktır. Herkesin yeme zorunluluğu dışında, ki yalnızca bunu yapabilirler, onlarda başka hiçbir iş yapılmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mayasız Ekmek Bayramı'nı tutacaksınız, çünkü aynı gün ordularınızı Mısır diyarından çıkardım. Bu nedenle bu günü kuşaklarınız boyunca daima süren bir kuralla tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Birinci ayın on dördüncü günü akşamından, yirmi birinci günü akşamına kadar mayasız ekmek yiyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Evlerinizde yedi gün boyunca maya bulunmayacak, çünkü kim mayalı olanı yerse, ister yabancı olsun ister ülkede doğmuş olsun, o can İsrael topluluğundan atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mayalı hiçbir şey yemeyeceksiniz. Yaşadığınız her yerde mayasız ekmek yiyeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Bunun üzerine Moşe İsrael'in bütün ihtiyarlarını çağırıp onlara şöyle dedi: “Ailenize göre kendiniz için kuzular çekip alın ve Pesah kurbanını kesin. ");
INSERT INTO turytc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bir demet mercanköşkotu alıp leğendeki kana batıracaksınız, leğendeki kanla üst söveye ve iki kapı eşiğine çalacaksınız. Hiçbiriniz sabaha kadar evinin kapısından çıkmasın. ");
INSERT INTO turytc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Çünkü Yahve Mısırlılar'ı vurmak için geçecek. Yahve üst eşik üzerindeki ve iki kapı sövesindeki kanı görünce kapının üzerinden geçecek ve yok edicinin evlerinize gelip sizi vurmasına izin vermeyecek. ");
INSERT INTO turytc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kendiniz ve oğullarınız için bir kural olarak bu şeyi daima tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Böyle olacak, Yahve'nin söz verdiği gibi size vereceği ülkeye geldiğiniz zaman bu hizmeti tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Böyle olacak, çocuklarınız size, 'Bu hizmet ne demektir?' diye sorduklarında, ");
INSERT INTO turytc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","şöyle diyeceksiniz: 'Bu, Mısır'da İsrael'in çocuklarının evlerinin üzerinden geçen, Yahve'nin Pesah kurbanıdır, O Mısırlılar'ı vurduğunda evlerimizi esirgedi.'” Halk başlarını eğip tapındı. ");
INSERT INTO turytc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","İsrael'in çocukları gidip öyle yaptılar, Yahve'nin Moşe ve Aron'a buyurduğu gibi öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gece yarısı Yahve, tahtında oturan Firavun'un ilk doğanından, zindandaki tutsağın ilk doğanına kadar Mısır diyarında bütün ilk doğanları ve hayvanların ilk doğanlarını vurdu. ");
INSERT INTO turytc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firavun'un kendisi, bütün hizmetkârları ve bütün Mısırlılar geceleyin kalktılar; ve Mısır'da büyük bir feryat vardı, çünkü içinde ölü olmayan ev yoktu. ");
INSERT INTO turytc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Gece Moşe'yle Aron'u çağırıp şöyle dedi: “Kalkın, hem siz hem de İsrael'in çocukları halkımın arasından çıkın. Gidin, söylediğiniz gibi Yahve'ye hizmet edin! ");
INSERT INTO turytc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Söylediğiniz gibi davarlarınızı ve sığırlarınızı alın ve gidin. Beni de kutsayın!” ");
INSERT INTO turytc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mısırlılar, “Hepimiz ölü insanlarız” dediklerinden, onları bir an önce ülkeden göndermek için halka acil çağrıda bulundular. ");
INSERT INTO turytc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Halk hamurlarını daha mayalanmadan aldılar, hamur tekneleri giysilerine sarılmış omuzlarındaydı. ");
INSERT INTO turytc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","İsrael'in çocukları Moşe'nin sözüne göre yaptılar ve Mısırlılar'dan gümüş takılar, altın takılar ve giysiler istediler. ");
INSERT INTO turytc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yahve Mısırlılar'ın gözünde halka lütuf verdi, böylece onlar da istediklerini aldılar. Mısırlılar'ı yağmaladılar. ");
INSERT INTO turytc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","İsrael'in çocukları, çocukların yanı sıra yaklaşık altı yüz bin kişi yaya olarak Ramses'ten Sukkot'a doğru yola çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Davarlar, sığırlar ve çok sayıda hayvanla karışık bir kalabalık da onlarla birlikte yola çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Mısır'dan getirdikleri hamurdan mayasız pideler pişirdiler, çünkü mayalanmamıştı, çünkü Mısır'dan kovuldular, bekleyemediler ve kendilerine yiyecek hazırlamamışlardı. ");
INSERT INTO turytc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","İsrael'in çocuklarının Mısır'da yaşadığı süre dört yüz otuz yıldı. ");
INSERT INTO turytc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Dört yüz otuz yılın sonunda Yahve'nin bütün orduları Mısır diyarından aynı günde çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Onları Mısır diyarından çıkardığı için Yahve için çok kutlanması gereken bir gecedir. Bu, İsrael'in çocuklarının kuşaklar boyunca çokça kutlayacağı, Yahve'nin o gecesidir. ");
INSERT INTO turytc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahve Moşe'yle Aron'a şöyle dedi: “Pesah'ın kuralı budur. Hiçbir yabancı ondan yemeyecek. ");
INSERT INTO turytc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ancak para karşılığında satın alınan her hizmetkâr, sünnet ettirildikten sonra ondan yiyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Yabancı ve ücretli hizmetçi ondan yemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Bir evde yenmeli. Etin hiçbirini evin dışına taşımayacaksınız. Kemiklerinden hiçbirini kırmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Bütün İsrael topluluğu onu tutacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Yanında garip olarak yaşayan bir yabancı Yahve'ye Pesah tutmak isterse, onun bütün erkekleri sünnet edilsinler, ondan sonra yaklaşıp onu tutsun. O ülkede doğmuş biri gibi olacak, ancak sünnetsiz hiç kimse ondan yemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kendi evinizde doğan ve aranızda garip olarak yaşayan yabancı için yasa aynı olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bütün İsrael'in çocukları böyle yaptılar. Yahve Moşe ve Aron'a nasıl buyurduysa onlar da öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Aynı o günde Yahve İsrael'in çocuklarını ordularıyla Mısır diyarından çıkardı. ");
INSERT INTO turytc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“İsrael'in çocukları arasında insan olsun hayvan olsun rahmi açan tüm ilk doğanları bana ayır. O benimdir.” ");
INSERT INTO turytc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moşe halka şöyle dedi: “Mısır'dan, esaret evinden çıktığınız bu günü hatırlayın. Çünkü Yahve elinin gücüyle sizi bu yerden çıkardı. Mayalı ekmek yenilmeyecek. ");
INSERT INTO turytc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Bugün siz Aviv ayında çıkıyorsunuz. ");
INSERT INTO turytc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Böyle olacak, Yahve seni atalarına vereceğine dair ant içtiği Kenan, Hitit, Amor, Hiv ve Yevus topraklarına, süt ve bal akan ülkeye getirdiği zaman, bu ay bu hizmeti tutacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yedi gün mayasız ekmek yiyeceksin, yedinci gün Yahve'ye bayram olacak. ");
INSERT INTO turytc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Yedi gün boyunca mayasız ekmek yenilecek ve sende mayalı ekmek görülmeyecek. Bütün sınırlarında, sende maya görülmeyecek. ");
INSERT INTO turytc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","O gün oğluna, 'Mısır'dan çıktığımda Yahve'nin benim için yaptığı şey içindir' diyeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Bu, elinde bir işaret, gözlerinin arasında bir anma olacak, ta ki, Yahve'nin yasası ağzında olsun. Çünkü Yahve güçlü eliyle seni Mısır'dan çıkardı. ");
INSERT INTO turytc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Bu nedenle bu kutsal kuralı her yıl mevsiminde tutacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Böyle olacak, Yahve size ve atalarınıza ant içtiği gibi sizi Kenan diyarına götürüp orayı size vereceği zaman, ");
INSERT INTO turytc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","rahmi açan her şeyi, sana ait olan hayvanın ilk doğanlarını Yahve'ye ayıracaksın. Erkekler Yahve'nin olacak. ");
INSERT INTO turytc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eşeğin her ilk doğanı için bir kuzu fidye vereceksin. Eğer fidye veremeyeceksen o zaman onun boynunu kıracaksın. Oğullarının arasında insanın ilk doğanlarının hepsinin fidyesini vereceksin. ");
INSERT INTO turytc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Böyle olacak, oğlun ileride sana, 'Bu nedir?' diye sorduğunda, ona diyeceksin ki, 'Yahve bizi Mısır'dan, esaret evinden elinin gücüyle çıkardı. ");
INSERT INTO turytc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Firavun inatla bizi bırakmayı reddedince, Yahve Mısır'da hem insanın hem de hayvanların ilk doğanlarını öldürdü. Bu nedenle rahmi açan bütün erkekleri Yahve'ye kurban ediyorum, ancak oğullarımın ilk doğanlarının hepsi için fidye veriyorum.' ");
INSERT INTO turytc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Bu, elinde bir işaret, gözlerinin arasında simge olacak, Çünkü Yahve elinin gücüyle bizi Mısır'dan çıkardı.” ");
INSERT INTO turytc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Firavun halkı salıverdiğinde, orası daha yakın olduğu halde Tanrı onları Filist ülkesinin yolundan götürmedi Çünkü Tanrı şöyle dedi: “Belki halk savaşı görünce fikir değiştirip Mısır'a döner.” ");
INSERT INTO turytc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ama Tanrı halkı Kızıldeniz kıyısındaki çöl yolundan götürdü. İsrael'in çocukları Mısır diyarından silahlı olarak çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moşe, “Tanrı sizi mutlaka ziyaret edecek ve kemiklerimi buradan sizinle birlikte taşıyacaksınız” diyerek İsrael'in çocuklarına ant içirdiği için Yosef'in kemiklerini de yanına aldı. ");
INSERT INTO turytc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sukkot'tan yola çıkıp çölün kıyısındaki Etam'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahve gündüzleri bir bulut sütunu içinde önlerinden giderek onlara yol gösterdi, geceleyin de bir ateş sütunu içinde onlara ışık vererek gece gündüz yol alabilmeleri için önlerinden gidiyordu. ");
INSERT INTO turytc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gündüzleri bulut sütunu, geceleyin de ateş sütunu halkın önünden ayrılmadı. ");
INSERT INTO turytc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“İsrael halkına geri dönüp Pihahirot'un önünde, Migdol ile deniz arasında, Baal Sefon'un önünde kamp kurmalarını söyle. Onun karşısında, deniz kenarında kamp kuracaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firavun İsrael'in çocukları için, 'Onlar o diyarın içinde şaşkındırlar' diyecek. 'Çöl onları hapsetmiştir.’ ");
INSERT INTO turytc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Firavun'un yüreğini katılaştıracağım, o da onların peşine düşecek. Firavun ve onun bütün orduları üzerinde yücelik kazanacağım. Mısırlılar benim Yahve olduğumu bilecekler.” Öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mısır Kralı'na halkın kaçtığı söylendi. Firavun ile hizmetkârlarının yüreği halka karşı değişti ve dediler: “Biz ne yaptık da İsrael'i bize hizmet etmekten salıverdik?” ");
INSERT INTO turytc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Arabasını hazırlayıp ordusunu da yanına aldı. ");
INSERT INTO turytc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Seçme altı yüz savaş arabasını ve Mısır'ın bütün savaş arabalarını, hepsinin komutanlarıyla birlikte aldı. ");
INSERT INTO turytc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yahve Mısır Kralı Firavun'un yüreğini katılaştırdı ve İsrael'in çocuklarının peşine düştü. Çünkü İsrael'in çocukları yüksek elle dışarı çıkmışlardı. ");
INSERT INTO turytc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mısırlılar onların peşine düştü. Firavun'un bütün atları ve savaş arabaları, atlıları ve ordusu, deniz kenarında, Pihahirot'un yanında, Baal Sefon'un önünde kamp kurarken onlara yetiştiler. ");
INSERT INTO turytc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firavun yaklaşınca İsrael'in çocukları gözlerini kaldırdılar, işte, Mısırlılar onların peşinden yürüyorlardı ve çok korktular. İsrael'in çocukları Yahve'ye feryat ettiler. ");
INSERT INTO turytc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Moşe'ye şöyle dediler, “Mısır'da mezar olmadığı için bizi çölde ölmeye mi getirdin? Bizi Mısır'dan çıkarmakla bize neden böyle davrandın? ");
INSERT INTO turytc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Mısır'da sana, 'Bizi rahat bırak, Mısırlılar'a hizmet edelim' diye söylediğimiz söz bu değil mi? Çünkü çölde ölmektense Mısırlılar'a hizmet etmek bizim için daha iyi olurdu.” ");
INSERT INTO turytc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moşe halka şöyle dedi: “Korkmayın. Sakin durun ve bugün sizin için gerçekleştireceği Yahve'nin kurtarışını görün. Çünkü bugün gördüğünüz Mısırlılar'ı bir daha asla görmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahve sizin için savaşacak, siz de sakin olacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yahve Moşe'ye şöyle dedi: “Neden bana feryat ediyorsun? İsrael'in çocuklarına ileri gitmelerini söyle. ");
INSERT INTO turytc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Değneğini kaldır, elini denizin üzerine uzat ve onu ayır. Sonra İsrael'in çocukları denizin ortasına kuru yerden girecekler. ");
INSERT INTO turytc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","İşte, ben Mısırlılar'ın yüreklerini katılaştıracağım ve onlar da onların arkasından girecekler. Firavun'un, bütün ordularının, savaş arabalarının ve atlılarının önünde kendime yücelik kazandıracağım. ");
INSERT INTO turytc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Firavun'un, savaş arabalarının ve atlılarının önünde yücelik kazandığımda, Mısırlılar benim Yahve olduğumu bilecekler.” ");
INSERT INTO turytc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","İsrael ordugâhının önünden giden Tanrı'nın meleği yer değiştirip arkalarına gitti. Bulut sütunu da önlerinden yer değiştirip arkalarında durdu. ");
INSERT INTO turytc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mısır ordugâhıyla İsrael ordugâhının arasına geldi. Bulut ve karanlık vardı ama geceyi aydınlatıyordu. Bütün gece biri ötekinin yanına yaklaşmadı. ");
INSERT INTO turytc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moşe elini denizin üzerine uzattı ve Yahve bütün gece kuvvetli doğu rüzgârıyla denizi geri döndürdü, denizi karaya çevirdi ve sular ayrıldı. ");
INSERT INTO turytc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","İsrael'in çocukları kuru yerden denizin ortasına girdiler. Sular sağlarında ve sollarında onlara duvar oldu. ");
INSERT INTO turytc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mısırlılar onları takip ettiler, Firavun'un bütün atları, savaş arabaları ve atlıları arkalarından denizin ortasına girdiler. ");
INSERT INTO turytc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Sabah nöbetinde Yahve ateş ve bulut sütunundan Mısır ordusuna baktı ve Mısır ordusunu şaşkına çevirdi. ");
INSERT INTO turytc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Arabaların tekerleklerini çıkardı ve onları ağır bir şekilde sürdüler. Mısırlılar, “İsrael'in önünden kaçalım, çünkü Yahve onlar için Mısırlılar'a karşı savaşıyor!” dediler. ");
INSERT INTO turytc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahve Moşe'ye, “Elini denizin üzerine uzat” dedi, “Sular yeniden Mısırlılar'ın, savaş arabalarının ve atlılarının üzerine gelsin.” ");
INSERT INTO turytc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moşe elini denizin üzerine uzattı. Sabah olunca deniz yeniden eski gücüne döndü. Mısırlılar onun karşısında kaçtılar. Yahve Mısırlılar'ı denizin ortasında devirdi. ");
INSERT INTO turytc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Sular döndü ve savaş arabalarını, atlıları, arkalarından denize giren Firavun'un tüm ordusunu örttü. Onlardan biri bile kalmadı. ");
INSERT INTO turytc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ancak İsrael'in çocukları denizin ortasındaki kuru toprakta yürüdüler, sular sağlarında ve sollarında onlara duvar oldu. ");
INSERT INTO turytc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Böylece Yahve o gün İsrael'i Mısırlılar'ın elinden kurtardı ve İsrael Mısırlılar'ın deniz kıyısında öldüğünü gördü. ");
INSERT INTO turytc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","İsrael, Yahve'nin Mısırlılar'a yaptığı büyük işi gördü ve halk Yahve'den korktu. Yahve'ye ve hizmetkârı Moşe'ye inandılar. ");
INSERT INTO turytc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Bunun üzerine Moşe ile İsrael'in çocukları Yahve'ye bu ezgiyi söylediler ve şöyle dediler: “Yahve'ye ezgi söyleyeceğim, çünkü O görkemle zafer kazandı. Atı ve binicisini denize attı. ");
INSERT INTO turytc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahve benim gücüm ve ezgimdir. O benim kurtuluşum oldu. O benim Tanrım'dır ve O'nu öveceğim, babamın Tanrısı ve ben O'nu yücelteceğim. ");
INSERT INTO turytc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahve bir savaş adamıdır. Adı Yahve'dir. ");
INSERT INTO turytc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Firavun'un savaş arabalarını ve ordusunu denize attı. Seçme subayları Kızıldeniz'de battı. ");
INSERT INTO turytc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Derinler onları örttü. Taş gibi derinliklere indiler. ");
INSERT INTO turytc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Senin sağ elin, ey Yahve, kudrette yücedir. Senin sağ elin, ey Yahve, düşmanı parçalara ayırır. ");
INSERT INTO turytc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Heybetinin büyüklüğüyle sana karşı ayaklananları alt edersin. Gazabını gönderirsin. Onları anız gibi tüketir. ");
INSERT INTO turytc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Öfkenin soluğuyla sular yığıldılar. Seller yığın gibi dimdik durdu. Derinlikler denizin ortasında dondular. ");
INSERT INTO turytc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Düşman, 'Ben kovalayacağım' dedi. 'Yetişeceğim. Ganimeti paylaşacağım. Arzum onlarda yerine gelecek. Kılıcımı çekeceğim. Elim onları yok edecek.’ ");
INSERT INTO turytc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Sen rüzgârınla üfledin. Deniz onları örttü. Güçlü sularda kurşun gibi battılar. ");
INSERT INTO turytc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","İlâhlar arasında senin gibi kim var, ey Yahve? Senin gibi kutsallıkta yüce, övgülerde heybetli, harikalar yapan kim var? ");
INSERT INTO turytc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Sağ elini uzattın. Yer onları yuttu. ");
INSERT INTO turytc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Sen kurtardığın halka sevgi dolu iyiliğinle rehberlik ettin. Gücünle onlara kutsal meskenine doğru yol gösterdin. ");
INSERT INTO turytc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Halklar duydu. Titriyorlar. Dehşetler Filist sakinlerini ele geçirdi. ");
INSERT INTO turytc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","O zaman Edom ileri gelenleri dehşete düştüler. Moav'ın güçlü adamları titremeye başladı. Kenan'da oturanların tümü eriyip gitti. ");
INSERT INTO turytc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Üzerlerine korku ve dehşet indi. Senin halkın geçene kadar, ey Yahve, kendine satın aldığın halkın geçene kadar, kolunun büyüklüğünden taş gibi kesildiler. ");
INSERT INTO turytc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Onları içeri getireceksin, mirasın olan dağa, ey Yahve, kendine oturmak için yaptığın yere, ey Yahve, ellerinin kurduğu kutsal yerde onları dikeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahve sonsuza dek hüküm sürecek.” ");
INSERT INTO turytc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Çünkü Firavun'un atları savaş arabalarıyla ve atlılarıyla birlikte denize girdiler ve Yahve denizin sularını üzerlerine geri getirdi. Ama İsrael'in çocukları denizin ortasındaki kuru yerden yürüdüler. ");
INSERT INTO turytc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aron'un kız kardeşi Peygamber Miryam eline bir tef aldı. Bütün kadınlar teflerle ve danslarla onun peşinden çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryam onlara şöyle yanıt verdi: “Yahve'ye ezgi söyleyin, çünkü O görkemle zafer kazandı. Atı ve binicisini denize attı.” ");
INSERT INTO turytc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moşe İsrael'i Kızıldeniz'den ileri götürdü ve Şur Çölü'ne çıktılar. Çölde üç gün gittiler ve su bulamadılar. ");
INSERT INTO turytc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mara'ya vardıklarında Mara sularından içemediler. Çünkü onlar acıydı. Bu nedenle adına Mara denildi. ");
INSERT INTO turytc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Halk, “Ne içelim?” diye Moşe'ye karşı söylendiler. ");
INSERT INTO turytc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Sonra o Yahve'ye feryat etti. Yahve ona bir ağaç gösterdi, o da onu sulara attı ve sular tatlılaştı. Orada onlar için bir kural ve hüküm koydu. Onları orada sınadı. ");
INSERT INTO turytc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Şöyle dedi, “Tanrınız Yahve'nin sözünü dikkatle dinlerseniz, O'nun gözünde doğru olanı yaparsanız, buyruklarına dikkat ederseniz ve bütün kurallarına uyarsanız, Mısırlılar'ın üzerine koyduğum hastalıkların hiçbirini sizin üzerinize koymayacağım. Çünkü sana şifa veren Yahve benim.” ");
INSERT INTO turytc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","On iki su kaynağı ve yetmiş palmiye ağacının bulunduğu Elim'e geldiler. Orada suların kenarında kamp kurdular. ");
INSERT INTO turytc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","İsrael'in çocuklarının bütün topluluğu Elim'den yola çıktılar ve Mısır diyarından ayrıldıktan sonraki ikinci ayın on beşinci günü, İsrael'in çocuklarının bütün topluluğu Elim ile Sina arasındaki Sin Çölü'ne geldiler. ");
INSERT INTO turytc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","İsrael'in çocuklarının bütün topluluğu çölde Moşe'ye ve Aron'a karşı söylendiler. ");
INSERT INTO turytc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","İsrael'in çocukları onlara şöyle dediler: “Keşke Mısır diyarında et kazanlarının başında oturduğumuzda, ekmeğimizi doyuncaya dek yediğimiz sırada Yahve'nin eliyle ölseydik. Çünkü bütün bu topluluğu açlıkla öldürmek için sen bizi bu çöle çıkardın.” ");
INSERT INTO turytc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Bunun üzerine Yahve Moşe'ye şöyle dedi: “İşte, senin için gökten ekmek yağdıracağım ve halk çıkıp her gün bir günlük pay toplayacak, böylece yasama göre yürüyüp yürümeyeceklerini sınayacağım. ");
INSERT INTO turytc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Altıncı günde getirdiklerini hazırlayacaklar ve bu, günlük topladıklarının iki katı olacak.” ");
INSERT INTO turytc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moşe ile Aron bütün İsrael'in çocuklarına şöyle dediler: “Akşam, Yahve'nin sizi Mısır diyarından çıkardığını bileceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sabah Yahve'nin görkemini göreceksiniz. Çünkü Yahve kendisine karşı söylenmenizi işitiyor. Biz kimiz ki, bize karşı söyleniyorsunuz?” ");
INSERT INTO turytc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moşe şöyle dedi: “Şimdi Yahve size akşamları yemeniz için et, sabahları da doymanız için ekmek verecek. Çünkü Yahve, kendisine karşı söylenmelerinizi işitiyor. Peki biz kimiz? Söylenmeleriniz bize karşı değil, Yahve'ye karşıdır.” ");
INSERT INTO turytc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moşe Aron'a şöyle dedi: “Bütün İsrael'in çocuklarının topluluğuna deyin ki, 'Yahve'ye yaklaşın, çünkü O sizin söylenmelerinizi duydu.''' ");
INSERT INTO turytc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aron bütün İsrael'in çocuklarının topluluğuyla konuşurken çöle doğru baktılar ve işte, Yahve'nin görkemi bulutta göründü. ");
INSERT INTO turytc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“İsrael'in çocuklarının söylenmelerini duydum. Onlara de ki, 'Akşam et yiyeceksiniz ve sabahleyin ekmekle doyacaksınız. O zaman benim Tanrınız Yahve olduğumu bileceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Akşam bıldırcınlar çıkıp ordugâhı kapladı ve sabahleyin ordugâhın çevresine çiy serilmişti. ");
INSERT INTO turytc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Yere serilmiş çiy kaybolduğunda, işte, çölün yüzeyinde yerdeki kırağı kadar küçük, yuvarlak bir şey vardı. ");
INSERT INTO turytc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","İsrael çocukları bunu görünce birbirlerine, “Bu nedir?” dediler. Çünkü ne olduğunu bilmiyorlardı. Moşe onlara şöyle dedi: “Bu, yemeniz için Yahve'nin size verdiği ekmektir. ");
INSERT INTO turytc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yahve'nin buyurduğu şey şudur: 'Her biriniz yiyeceğine göre ondan toplayın. Her biriniz çadırında olanların sayısına göre bir omer, bir baş alacak.'” ");
INSERT INTO turytc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","İsrael'in çocukları da öyle yaptı. Bazıları daha çok, bazıları daha az topladı. ");
INSERT INTO turytc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Omerle ölçtüklerinde, çok toplayanın fazlası, az toplayanın da eksiği yoktu. Her biri yiyeceğine göre toplamıştı. ");
INSERT INTO turytc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moşe onlara, “Sabaha kadar kimse ondan bırakmasın” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ne var ki Moşe'nin sözünü dinlemediler ve bazıları ondan sabaha kadar bıraktılar. Kurtlanıp koktu. Moşe de onlara öfkelendi. ");
INSERT INTO turytc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Herkes yiyeceğine göre sabahtan sabaha ondan topladılar. Güneş ısınınca erirdi. ");
INSERT INTO turytc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Altıncı gün her biri için iki omer olmak üzere iki kat ekmek topladılar. Topluluğun bütün önderleri gelip Moşe'ye bildirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Onlara şöyle dedi: “Yahve'nin söylediği budur, 'Yarın kutsal dinlenme günü, Yahve için kutsal Şabat'dır. Pişirmek istediğinizi pişirin, haşlamak istediğinizi haşlayın. Arta kalanı da sabaha kadar saklamak üzere kendiniz için bir kenara koyun.'” ");
INSERT INTO turytc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moşe'nin buyurduğu gibi onu sabaha kadar bir kenara koydular, kokmadı, onda kurt da yoktu. ");
INSERT INTO turytc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moşe, “Onu bugün yiyin” dedi, “Çünkü bugün Yahve için Şabat'dır. Bugün onu kırda bulamayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Altı gün toplayacaksınız, ama yedinci gün Şabat'dır. O günde hiçbir şey bulunmayacak.” ");
INSERT INTO turytc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yedinci gün halktan bazıları toplamaya çıktı ama hiçbir şey bulamadılar. ");
INSERT INTO turytc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yahve Moşe'ye şöyle dedi: “Buyruklarımı ve yasalarımı tutmayı ne zamana dek reddedeceksiniz? ");
INSERT INTO turytc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","İşte, Yahve size Şabat'ı verdiği için, altıncı günde size iki günlük ekmeğinizi veriyor. Herkes kendi yerinde kalsın. Yedinci günde kimse yerinden çıkmasın.” ");
INSERT INTO turytc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Böylece halk yedinci gün dinlendi. ");
INSERT INTO turytc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","İsrael evi onun adını Man koydu. Kişniş tohumu gibi beyazdı. Tadı da ballı yufkaya benziyordu. ");
INSERT INTO turytc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moşe şöyle dedi: “Yahve'nin buyurduğu şey şudur: 'Mısır diyarından sizi çıkardığım zaman, çölde size yedirdiğim ekmeği görsünler diye bundan bir omer dolusu kuşaklarınız boyunca saklansın.'” ");
INSERT INTO turytc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moşe Aron'a, “Bir testi al, içine bir omer dolusu man koy” dedi, “Kuşaklar boyu saklanmak üzere onu Yahve'nin huzuruna koy.” ");
INSERT INTO turytc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Yahve'nin Moşe'ye buyurduğu gibi Aron onu saklanmak üzere Tanıklığın önüne koydu. ");
INSERT INTO turytc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","İsrael'in çocukları üzerinde yaşayanların bulunduğu bir diyara gelene dek kırk yıl boyunca man yediler. ");
INSERT INTO turytc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Bir omer efanın onda biridir. ");
INSERT INTO turytc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","İsrael'in çocuklarının bütün topluluğu Yahve'nin buyruğu uyarınca Sin Çölü'nden yola çıkıp Refidim'de konakladı. Ancak halkın içeceği su yoktu. ");
INSERT INTO turytc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Bunun üzerine halk Moşe'yle tartışıp, “Bize içecek su ver” dediler. Moşe onlara şöyle dedi: “Neden benimle tartışıyorsunuz? Neden Yahve’yi sınıyorsunuz?” ");
INSERT INTO turytc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Orada halk susamıştı. Bunun üzerine halk Moşe'ye karşı söylenip şöyle dediler: “Bizi, çocuklarımızı ve hayvanlarımızı susuzluktan öldürmek için neden bizi Mısır'dan çıkardın?” ");
INSERT INTO turytc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moşe Yahve'ye feryat edip, dedi: “Bu halka ne yapayım? Neredeyse beni taşlayacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahve Moşe'ye şöyle dedi: “Halkın önünde yürü, İsrael'in ihtiyarlarını da yanına al ve Nil'e vurduğun değneği eline alıp git. ");
INSERT INTO turytc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","İşte, ben Horev'deki kayanın üzerinde önünde duracağım. Kayaya vuracaksın ve halk içsin diye oradan su çıkacak.” Moşe İsrael'in ihtiyarlarının önünde böyle yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","İsrael çocukları çekiştiğinden ve “Yahve aramızda mı, değil mi?” diyerek Yahve'yi sınadıkları için bu yere Massa ve Meriva adını verdi. ");
INSERT INTO turytc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sonra Amalek gelip Refidim'de İsrael'le savaştı. ");
INSERT INTO turytc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moşe Yeşu'ya, “Bizim için adamlar seç ve Amalek'le savaşmaya çık” dedi. “Yarın elimde Tanrı'nın değneği ile tepenin zirvesinde duracağım.” ");
INSERT INTO turytc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeşu Moşe'nin kendisine söylediği gibi yaptı ve Amalek'le savaştı. Moşe, Aron ve Hur tepenin zirvesine çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moşe elini kaldırdığında İsrael galip geliyordu, elini indirdiğinde Amalek galip geliyordu. ");
INSERT INTO turytc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ama Moşe'nin elleri ağırlaştı, bir taş alıp altına koydular, o da üzerine oturdu. Aron ve Hur, biri bir tarafta, diğeri öbür tarafta onun ellerini kaldırdılar. Gün batımına kadar elleri sabit kaldı. ");
INSERT INTO turytc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yeşu, Amalek'le halkını kılıcın ağzıyla yendi. ");
INSERT INTO turytc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahve Moşe'ye, “Bunu anma olarak kitaba yaz ve Yeşu'nun kulağına tekrarla” dedi, “Öyle ki, Amalek'in anısını gökyüzünün altından tamamen sileyim.” ");
INSERT INTO turytc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moşe bir sunak yaptı ve adını “Yahve Sancağımızdır” koydu. ");
INSERT INTO turytc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","O şöyle dedi: “Yah, 'Yahve Amalek'le kuşaktan kuşağa savaş içinde olacaktır' diye ant içti.” ");
INSERT INTO turytc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moşe'nin kayınpederi Midyanlı kâhin Yetro, Tanrı'nın Moşe ve halkı İsrael için yaptığı her şeyi, Yahve'nin İsrael'i Mısır'dan nasıl çıkardığını duydu. ");
INSERT INTO turytc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moşe'nin kayınpederi Yetro, Moşe'nin geri göndermiş olduğu karısı Sippora'yı, ");
INSERT INTO turytc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ve iki oğlunu aldı. Oğullarından birinin adı Gerşom'du, çünkü Moşe, “Yabancı bir ülkede garip olarak yaşadım” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Diğerinin adı Eliezer'di, çünkü şöyle dedi: “Babamın Tanrısı benim yardımcımdı ve beni Firavun'un kılıcından kurtardı.” ");
INSERT INTO turytc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moşe'nin kayınpederi Yetro, Moşe'nin oğulları ve karısıyla birlikte Moşe'nin konakladığı çöle, Tanrı Dağı'na geldi. ");
INSERT INTO turytc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Moşe'ye, “Ben, kayınpederin Yetro, karın ve iki oğluyla birlikte sana geldim” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moşe kayınpederini karşılamaya çıktı, eğilip onu öptü. Birbirlerine hal hatır sorup çadıra girdiler. ");
INSERT INTO turytc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moşe kayınpederine, Yahve'nin İsrael uğruna Firavun'a ve Mısırlılar'a yaptıklarını, yolda başlarına gelen tüm zorlukları ve Yahve'nin onları nasıl kurtardığını anlattı. ");
INSERT INTO turytc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro, Yahve'nin İsrael'e yaptığı bütün iyiliklere, onları Mısırlılar'ın elinden kurtardığına sevindi. ");
INSERT INTO turytc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro şöyle dedi: “Seni Mısırlılar'ın ve Firavun'un elinden kurtaran Yahve'ye övgüler olsun. Halkı Mısırlılar'ın elinden kurtaran O'dur. ");
INSERT INTO turytc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Onların insanlara kibirli davranmalarından artık biliyorum ki, Yahve bütün ilâhlardan daha büyüktür.” ");
INSERT INTO turytc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Moşe'nin kayınpederi Yetro, Tanrı'ya yakmalık sunu ve kurbanlar sundu. Aron, İsrael'in tüm ihtiyarlarıyla birlikte Moşe'nin kayınpederiyle birlikte Tanrı'nın önünde ekmek yemeye geldi. ");
INSERT INTO turytc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ertesi gün Moşe halkı yargılamak için oturdu ve halk sabahtan akşama kadar Moşe'nin çevresinde durdu. ");
INSERT INTO turytc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Moşe'nin kayınpederi onun halka yaptıklarını görünce şöyle dedi: “Halk için yaptığınız bu şey nedir? Neden tek başına oturuyorsun ve bütün insanlar sabahtan akşama kadar senin etrafında duruyor?” ");
INSERT INTO turytc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moşe kayınpederine şöyle dedi: “Çünkü halk Tanrı'ya sormak için bana geliyor. ");
INSERT INTO turytc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bir mesele olduğunda bana gelirler, ben de adamla komşusu arasında hükmederim ve onlara Tanrı'nın hükümlerini ve yasalarını bildiririm.” ");
INSERT INTO turytc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moşe'nin kayınpederi ona şöyle dedi: “Yaptığın şey iyi değil. ");
INSERT INTO turytc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Hem sen, hem de seninle birlikte olan bu halk kesin olarak usanacaksınız. Çünkü bu şey senin için çok ağır. Bunu tek başına kendin yapamazsın. ");
INSERT INTO turytc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Şimdi sözümü dinle. Sana öğüt vereyim ve Tanrı seninle olsun. Sen halk için Tanrı'nın önünde ol ve konuları Tanrı'ya getir. ");
INSERT INTO turytc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Onlara hükümleri ve yasaları öğretirsin, yürümeleri gereken yolu ve yapmaları gereken işi onlara gösterirsin. ");
INSERT INTO turytc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ayrıca bütün halk arasından Tanrı'dan korkan yetenekli adamlar, haksız kazançtan nefret eden dürüst adamlar çıkar. Onları, binlerin başı, yüzlerin başı, ellilerin başı ve onların başı olarak onların üzerine koy. ");
INSERT INTO turytc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Halkı her zaman onlar yargılasınlar. Öyle olacak ki, her büyük meseleyi sana getirecekler, ama her küçük meseleyi kendileri yargılayacaklar. Böylece işin kolaylaşacak ve yükü seninle paylaşacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Eğer bunu yaparsan, Tanrı da sana öyle buyurursa, o zaman dayanabilirsin ve bütün bu halk da esenlik içinde yerine gider.” ");
INSERT INTO turytc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Böylece Moşe kayınpederinin sözünü dinledi ve söylediklerinin hepsini yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moşe tüm İsrael'den yetenekli adamlar seçti ve onları halkın üzerine, binlere, yüzlere, ellilere ve onlara baş yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Halkı her zaman yargıladılar. Zor davaları Moşe'ye getirdiler, ama her küçük meseleyi kendileri yargıladılar. ");
INSERT INTO turytc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moşe kayınpederinin gitmesine izin verdi ve o da kendi ülkesine doğru yola çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","İsrael'in çocukları Mısır diyarından çıktıktan sonraki üçüncü ayda, aynı gün Sina Çölü'ne geldiler. ");
INSERT INTO turytc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidim'den ayrılıp Sina Çölü'ne vardıklarında çölde konakladılar. İsrael orada dağın önünde konakladı. ");
INSERT INTO turytc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moşe Tanrı'nın yanına çıktı. Yahve dağdan onu çağırıp şöyle dedi: “Yakov'un evine ve İsrael'in çocuklarına şunu söyleyeceksin: ");
INSERT INTO turytc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Mısırlılar'a ne yaptığımı, sizi nasıl kartal kanatları üzerinde taşıdığımı ve sizi kendime getirdiğimi gördünüz. ");
INSERT INTO turytc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Şimdi, eğer gerçekten sözümü dinlerseniz ve antlaşmamı tutarsanız, o zaman bütün halklar arasında benim kendi mülküm olursunuz; çünkü bütün dünya benimdir. ");
INSERT INTO turytc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Sizler bana kâhinler krallığı ve kutsal bir ulus olacaksınız.' İsrael'in çocuklarına söyleyeceğin sözler bunlardır.” ");
INSERT INTO turytc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moşe gelip halkın ihtiyarlarını çağırdı ve Yahve'nin kendisine buyurduğu tüm bu sözleri onların önüne koydu. ");
INSERT INTO turytc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bütün halk hep birlikte şöyle yanıt verdi: “Yahve'nin söylediği her şeyi yapacağız.” Moşe halkın sözlerini Yahve'ye bildirdi. ");
INSERT INTO turytc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahve Moşe'ye şöyle dedi: “Seninle konuştuğumu halk duysun, hem de sana daima inansınlar diye, sana koyu bir bulut içinde geleceğim.” Moşe halkın sözlerini Yahve'ye bildirdi. ");
INSERT INTO turytc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahve Moşe'ye şöyle dedi: “Halka git, onları bugün ve yarın kutsa, giysilerini yıkasınlar, ");
INSERT INTO turytc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ve üçüncü günde hazır olsunlar, çünkü üçüncü gün Yahve bütün halkın gözü önünde Sina Dağı'na inecek. ");
INSERT INTO turytc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","'Dikkat edin, dağa çıkmayın, sınırına dokunmayın diyerek çevredeki insanlara sınır koyacaksın. Kim dağa dokunursa kesin olarak öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ona kimse dokunmayacak; mutlaka taşlanacak ya da vurulacak; ister hayvan olsun ister insan, yaşamayacaktır.' Boru uzun süre çalınca dağa çıkacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moşe dağdan halkın yanına indi ve halkı kutsadı ve elbiselerini yıkadılar. ");
INSERT INTO turytc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Halka, “Üçüncü güne hazır olun” dedi. “Bir kadınla cinsel ilişkiye girmeyin.” ");
INSERT INTO turytc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Üçüncü gün sabah olduğunda gök gürlemeleri, şimşekler, dağın üzerinde koyu bir bulut ve çok güçlü boru sesi oldu ve ordugâhta bulunan herkes titredi. ");
INSERT INTO turytc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moşe Tanrı'nın huzuruna çıkmak için halkı ordugâhtan çıkardı. Dağın eteğinde durdular. ");
INSERT INTO turytc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Yahve ateş içinde onun üzerine indiği için Sina Dağı'nın tamamı tütüyordu. Dumanı ocak dumanı gibi yükseldi ve bütün dağ şiddetle sarsıldı. ");
INSERT INTO turytc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Borunun sesi git gide yükselince Moşe konuştu ve Tanrı ona sesle yanıt verdi. ");
INSERT INTO turytc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahve Sina Dağı'nın zirvesine indi. Yahve Moşe'yi dağın zirvesine çağırdı ve Moşe yukarı çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahve Moşe'ye şöyle dedi: “Aşağı in ve halkı uyar, yoksa görmek için Yahve'ye doğru sınırı aşarlar, onlardan çoğu yok olurlar. ");
INSERT INTO turytc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Yahve'ye yaklaşan kâhinler de kendilerini kutsasınlar, yoksa Yahve onlara saldırır.” ");
INSERT INTO turytc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moşe Yahve'ye şöyle dedi, “Halk Sina Dağı'na çıkamaz, çünkü sen bizi uyardın: 'Dağın çevresine sınırlar koy ve onu kutsa' demiştin.” ");
INSERT INTO turytc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahve ona, “Aşağı in!” dedi. “Aron'u da yanında getireceksin, ama kâhinler ve halk Yahve'ye doğru çıkmasınlar, yoksa onlara saldırır.” ");
INSERT INTO turytc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Bunun üzerine Moşe halkın yanına indi ve onlara anlattı. ");
INSERT INTO turytc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tanrı bütün bu sözleri söyleyip şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Seni Mısır diyarından, esaret evinden çıkaran Tanrın Yahve benim.” ");
INSERT INTO turytc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Önümde başka ilâhların olmayacak.” ");
INSERT INTO turytc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kendin için bir put, yukarıda göklerde olanın, ya da aşağıda yerde olanın ya da yerin altında sularda olanın herhangi bir suretini yapmayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Onlara eğilmeyeceksin; çünkü ben, Tanrın Yahve, benden nefret edenlerin babalarının suçunu çocuklarına, üçüncü ve dördüncü kuşaklarına çektiren, ");
INSERT INTO turytc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ve beni seven ve buyruklarımı tutanların binlercesine sevgi dolu iyilik gösteren, kıskanç bir Tanrı'yım.” ");
INSERT INTO turytc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Tanrın Yahve'nin adını hor kullanmayacaksın; çünkü Yahve, adını hor kullananı suçsuz tutmayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Şabat Günü'nü kutsal tutmak için onu hatırla. ");
INSERT INTO turytc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Altı gün çalışacak ve tüm işini yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ama yedinci gün Tanrın Yahve için Şabat'dır. Sen, oğlun, kızın, erkek kölen, kadın kölen, hayvanların ve kapılarında olan yabancı onda hiçbir iş yapmayacak. ");
INSERT INTO turytc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Çünkü Yahve göğü, yeri, denizi ve içlerindeki her şeyi altı günde yarattı ve yedinci gün dinlendi; bu nedenle Yahve Şabat Günü'nü kutsadı ve onu kutsal kıldı.” ");
INSERT INTO turytc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Babana ve annene saygı göster ki, Tanrın Yahve'nin sana vereceği toprakta günlerin uzun olsun. ");
INSERT INTO turytc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Öldürmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Zina etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Çalmayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Komşuna karşı yalan yere tanıklık etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Komşunun evine göz dikmeyeceksin. Komşunun karısına, erkek hizmetçisine, kadın hizmetçisine, öküzüne, eşeğine ve komşunun hiçbir şeyine tamah etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bütün halk gök gürlemelerini, şimşekleri, boru sesini ve dağdan yükselen dumanı fark etti. İnsanlar bunu görünce titrediler ve uzakta durdular. ");
INSERT INTO turytc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Moşe'ye, “Bizimle sen konuş, biz de dinleyelim” dediler. “Ama Tanrı bizimle konuşmasın, yoksa ölürüz.” ");
INSERT INTO turytc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moşe halka, “Korkmayın, çünkü Tanrı sizi sınamak ve günah işlemeyesiniz, O'nun korkusu önünüzde olsun diye geldi” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Halk uzakta durdu ve Moşe, Tanrı'nın bulunduğu koyu karanlığa yaklaştı. ");
INSERT INTO turytc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahve Moşe'ye şöyle dedi: “İsrael'in çocuklarına bunu söyleyeceksin: 'Sizinle gökten konuştuğumu kendiniz gördünüz. ");
INSERT INTO turytc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Benim yanımsıra kendinize gümüşten ya da altından ilâhlar kesinlikle yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Benim için topraktan bir sunak yapacaksın ve yakmalık sunularını, esenlik sunularını, koyunlarını ve sığırlarını onun üzerinde kurban edeceksin. Adımı hatırlattığım her yerde sana geleceğim ve seni kutsayacağım. ");
INSERT INTO turytc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Eğer bana taştan bir sunak yaparsan, onu yontma taşlardan yapmayacaksın; çünkü eğer aletini onun üzerine kaldırırsan, onu kirletmiş olursun. ");
INSERT INTO turytc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Çıplaklığınız ortaya çıkmasın diye, sunağıma basamakla çıkmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Şimdi onların önüne koyacağın hükümler şunlardır:” ");
INSERT INTO turytc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Eğer İbrani bir hizmetçi satın alırsan, altı yıl hizmet edecek ve yedincisinde hiçbir şey ödemeden özgür olarak çıkacak. ");
INSERT INTO turytc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Eğer yalnız geldiyse, tek başına çıkacaktır. Evli ise karısı da onunla birlikte çıkacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Eğer efendisi ona bir eş verir ve o kadın ona oğulları ya da kızları doğurursa, karısı ve çocukları efendisinin olacak ve kendisi tek başına çıkacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ama hizmetçi açıkça, 'Efendimi, karımı ve çocuklarımı seviyorum' derse;” ");
INSERT INTO turytc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","o zaman efendisi onu Tanrı'ya getirecek. Onu kapıya ya da kapı sövesine getirecek ve efendisi bizle onun kulağını delecek. O da ona daima hizmet edecektir. ");
INSERT INTO turytc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Eğer bir adam kızını hizmetçi olarak satarsa, kız erkek hizmetçiler gibi dışarı çıkmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Eğer kendisiyle evlenmiş olan kız, efendisini memnun etmezse, efendisi onun geri satın alınmasına izin verecektir. Ona hileyle davrandığı için onu yabancı bir halka satmaya hakkı olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Eğer onu kendi oğluyla evlendirirse, ona kızı gibi davranacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Eğer kendine başka bir kadın alırsa, öncekinin yiyeceğini, giyeceğini ve evlilik haklarını kısmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Eğer bu üç şeyi onun için yapmazsa, kadın hiçbir para ödemeden özgür gidebilir.” ");
INSERT INTO turytc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Bir adamı vuran, vurduğu kişi de ölürse, kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ama bu kasıtsızsa, Tanrı bunun olmasına izin vermişse, o zaman sana onun kaçacağı bir yer tayin edeceğim. ");
INSERT INTO turytc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Eğer bir kişi kendisini öldürmek için komşusuna düzen kurar ve haddini bilmez bir şekilde komşusunun üstüne gelirse, onu ölsün diye sunağımdan alacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Babasına ya da annesine saldıran kesinlikle öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Birini kaçırıp satan ya da elinde bulunduran kişi kesinlikle öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Babasına ya da annesine lanet eden kesinlikle öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Eğer insanlar kavga eder ve biri diğerine taşla ya da yumrukla vurursa, o da ölmeyip yatağa mahkûm olursa; ");
INSERT INTO turytc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","eğer tekrar ayağa kalkıp değneğiyle dolaşırsa, ona vuran aklanacak, yalnızca kaybettiği zamanın bedelini kendisi ödeyecek ve tamamen iyileşene dek iyileşmesini karşılayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Eğer bir adam hizmetçisine ya da kadın hizmetçisine değnekle vurursa ve o kişi onun eli altında ölürse, o adam kesinlikle cezalandırılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Bununla birlikte, eğer hizmetçisi bir ya da iki gün sonra kalkarsa cezalandırılmaz; çünkü hizmetçi onun mülküdür.” ");
INSERT INTO turytc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Eğer insanlar kavga edip gebe bir kadını incitir, kadın da düşük yaparsa ve hiçbir zarar gelmese de, mutlaka kadının kocasının talep edeceği ve hakimlerin izin vereceği ölçüde para cezasına çarptırılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ama bundan bir zarar gelirse, cana karşılık can, ");
INSERT INTO turytc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","göze karşılık göz, dişe karşılık diş, ele karşılık el, ayağa karşılık ayak, ");
INSERT INTO turytc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","yanmaya karşılık yanma, yaraya karşılık yara, bereye karşılık bere alacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Eğer bir adam hizmetçisinin ya da kadın hizmetçisinin gözüne vurup onu sakatlarsa, gözü uğruna onu özgür bırakacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Eğer erkek hizmetçisinin ya da kadın hizmetçisinin dişine vurursa, dişi uğruna hizmetçiyi özgür bırakacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Eğer bir boğa bir erkeği ya da kadını süsüp öldürürse, boğa kesinlikle taşlanacak ve eti yenmeyecektir; ancak boğanın sahibi sorumlu tutulmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ancak boğanın geçmişte süsme alışkanlığı varsa ve bu durum sahibine bildirilmişse ve o da onu içeride tutmamışsa ve bir erkeği ya da kadını öldürmüşse, boğa taşlanacak, sahibi de öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Eğer kendisi üzerine bir fidye konulursa, o zaman yaşamının fidyesi olarak üzerine konulan ne ise ödeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","İster oğlunu, ister kızını süsmüş olsun, ona bu hükme göre yapılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Eğer boğa bir erkek ya da kadın hizmetçiyi süserse, efendilerine otuz şekel gümüş verilecek ve öküz taşlanacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Eğer bir kişi bir çukur açar, ya da bir kişi bir çukur kazar ve onu örtmezse ve içine bir boğa ya da eşek düşerse, ");
INSERT INTO turytc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","çukurun sahibi karşılığını ödeyecektir. Parayı onların sahibine verecek ve ölü hayvan kendisinin olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Eğer birinin boğası başka birinin boğasını yaralar o da ölürse, o zaman canlı boğayı satıp bedelini bölüşecekler; ölü hayvanı da böleceklerdir. ");
INSERT INTO turytc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ya da boğanın geçmişte süsme alışkanlığı olduğu biliniyorsa ve sahibi onu içeride tutmamışsa, kesinlikle boğa karşılığında boğa ödeyecek ve ölü hayvan kendisinin olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Eğer biri bir öküz ya da koyun çalar ve onu öldürür ya da satarsa, bir öküz için beş öküz, bir koyun için dört koyun ödeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Eğer hırsız içeri girerken yakalanır ve vurularak ölürse, onun için kan dökme suçu yoktur. ");
INSERT INTO turytc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Eğer güneş onun üzerine doğmuşsa, kan dökmeden suçludur. Zararı karşılayacaktır. Hiçbir şeyi yoksa hırsızlıktan dolayı satılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Çalınan mal, ister öküz, ister eşek, ister koyun olsun, elinde canlı olarak bulunursa, iki katını ödeyecek.” ");
INSERT INTO turytc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Eğer biri hayvanını salıverip bir tarladan ya da bağdan yedirirse ve hayvan başka bir adamın tarlasında otluyorsa, karşılığını kendi tarlasının ya da bağının en iyisiyle ödeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Eğer yangın çıkar dikenlere sıçrar ve ekinler, ekin demetleri ya da tarla yanarsa; ateşi tutuşturan, kesinlikle karşılığını ödeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Biri komşusuna saklaması için para ya da eşya verir ve bunlar adamın evinden çalınırsa, eğer hırsız bulunursa iki katını ödeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Hırsız bulunamazsa, evin sahibi, komşusunun eşyasına el atıp atmadığını öğrenmek için Tanrı'ya yaklaşacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Her suç meselesi hakkında, ister öküz, eşek, koyun, giysi ya da herhangi bir kayıp eşyayla ilgili olsun, 'Bu benimdir' diyen her iki tarafın davası Tanrı'ya getirilecektir. Tanrı'nın suçlu çıkardığı kişi komşusuna iki kat ödeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Eğer biri komşusuna bakması için bir eşek, bir öküz, bir koyun ya da herhangi bir hayvan teslim ederse ve bu hayvan ölürse, yaralanırsa ya da sürülüp götürülürse ve onu kimse görmezse; ");
INSERT INTO turytc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","komşusunun malına el sürmemiştir diye, Yahve'nin andı ikisi arasında olacaktır; sahibi bunu kabul edecek ve karşılık ödemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ama eğer ondan çalınmışsa, çalan kişi, sahibine karşılığını ödeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Parçalanmışsa kanıt olarak getirsin. Parçalanmış olanı ödemiyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Eğer biri komşusundan bir şey ödünç alırsa ve o şey sahibi yanında olmadan yaralanırsa ya da ölürse, kesinlikle borcunu ödeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Eğer sahibi onun yanındaysa, ödemeyecektir. Eğer kiralık bir şeyse, kirasına sayılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Bir adam nişanlı olmayan el değmemiş bir kızı ayartıp onunla yatarsa, onun karısı olması için kesinlikle bir çeyiz ödeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Eğer babası onu kendisine vermeyi tümüyle reddederse, el değmemiş kızların çeyizine göre para ödeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Büyücünün yaşamasına izin vermeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Kim bir hayvanla cinsel ilişkiye girerse kesinlikle öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Yalnız Yahve'nin dışında başka bir ilâha kurban sunan kişi tümüyle yok edilecek.” ");
INSERT INTO turytc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Bir yabancıya haksızlık etmeyeceksin ve onu ezmeyeceksin; çünkü siz Mısır diyarında yabancıydınız.” ");
INSERT INTO turytc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Hiçbir dul kadını ya da yetimi istismar etmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Onları bir şekilde istismar eder ve bana feryat ederlerse, feryatlarını mutlaka duyacağım; ");
INSERT INTO turytc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ve öfkem alevlenecek ve sizi kılıçla öldüreceğim; ve karılarınız dul, çocuklarınız yetim kalacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Eğer halkımdan yanında olan yoksul birine borç verirsen, ona tefeci gibi olmayacaksın. Ondan faiz almayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Eğer komşunun giysisini rehin olarak alırsan, onu güneş batmadan önce ona geri vereceksin. ");
INSERT INTO turytc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Çünkü bu onun tek örtüsüdür, bu onun derisinin giysisidir. Neyle yatsın? Böyle olacak, o bana feryat ettiğinde onu duyacağım, çünkü ben lütufkârım.” ");
INSERT INTO turytc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tanrı'ya sövmeyeceksin, halkının hükümdarına lanet etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Hasatınızdan ve masaranızdan çıkanı sunmakta gecikmeyeceksiniz.” “Oğullarının ilk doğanı bana vereceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Sığırlarınız ve koyunlarınız için de aynısını yapacaksınız. Yedi gün annesiyle birlikte kalacak, sonra sekizinci gün onu bana vereceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Siz benim için kutsal insanlar olacaksınız; bu nedenle kırda hayvanların parçaladığı etleri yemeyeceksiniz. Onu köpeklere atacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Yalan haber yaymayacaksın. Kötü niyetli tanık olmak için kötüye el vermeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Kötülük yapmak için kalabalığın peşinden gitmeyeceksin. Adaleti saptırmak için mahkemede kalabalığın yanında tanıklık yapmayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Davasında yoksulu kayırmayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Eğer düşmanının öküzünü ya da eşeğini yoldan sapmış halde bulursan, onu mutlaka kendisine geri getireceksin. ");
INSERT INTO turytc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Eğer senden nefret edenin eşeğinin yükü altında çökmüş görürsen, onu yalnız bırakmayacaksın. Bu konuda ona mutlaka yardım edeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Yoksul halkınızın davalarında adaleti saptırmayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Yalan suçlamadan uzak dur, suçsuzu ve doğruyu öldürme; çünkü ben kötüyü aklamam.” ");
INSERT INTO turytc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Rüşvet almayacaksın; çünkü rüşvet, görenleri kör eder ve doğruların sözlerini saptırır.” ");
INSERT INTO turytc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Yabancıyı ezmeyeceksin; çünkü siz Mısır diyarında yabancı olduğunuz için, yabancının yüreğini bilirsiniz.” ");
INSERT INTO turytc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Toprağını altı yıl ekeceksin ve ürününü toplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ama yedinci yıl onu, halkınızın yoksulları yiyebilsin diye dinlenmeye ve nadasa bırakacaksın; onların bıraktıklarını da kır hayvanı yiyecek. Bağın ve zeytinliğin için de aynı şekilde yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Altı gün işini yapacaksın, yedinci gün dinleneceksin ki, öküzün, eşeğin, hizmetçinin oğlu ve yabancı ferahlasın.” ");
INSERT INTO turytc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Size söylediğim her şeyi yapmaya dikkat edin; ve başka ilâhların adını anmayın ve onlar ağzında bile duyulmasın.” ");
INSERT INTO turytc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Yılda üç kez bana bayram edeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mayasız Ekmek Bayramı'nı tutacaksınız. Size buyurduğum gibi, Aviv ayının belirlenen vaktinde (çünkü Mısır'dan o ayda çıktınız) yedi gün mayasız ekmek yiyeceksiniz ve kimse önüme boş çıkmayacak. ");
INSERT INTO turytc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Tarlaya ekmiş olduğunuz emeğinizin ilk ürünü olan Hasat Bayramı'nı; yıl sonunda, tarladan emeklerinizi topladığınız zaman Toplama Bayramı'nı tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Bütün erkekleriniz yılda üç kez Efendi Yahve'nin önünde görünecek.” ");
INSERT INTO turytc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kurbanımın kanını mayalı ekmekle sunmayacaksın. Bayramımın yağı bütün gece sabaha kadar kalmayacak. ");
INSERT INTO turytc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Toprağınızın seçme ilk ürünlerini Tanrınız Yahve'nin Tapınağı'na getireceksiniz.” “Oğlağı anasının sütünde kaynatmayacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“İşte, size yolda bakması ve hazırladığım yere getirmesi için önünüzden bir Melek gönderiyorum. ");
INSERT INTO turytc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","O'na dikkat edin ve sözünü dinleyin. O'nu kışkırtmayın, çünkü O itaatsizliğinizi bağışlamayacaktır; çünkü benim adım Onda'dır. ");
INSERT INTO turytc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ama gerçekten onun sözünü dinler ve söylediklerimin hepsini yaparsanız, o zaman düşmanlarınıza düşman, hasımlarınıza hasım olacağım. ");
INSERT INTO turytc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Çünkü Melek'im önünüzden gidecek ve sizi Amorlular'ın, Hititler'in, Perizliler'in, Kenanlılar'ın, Hivliler'in ve Yevuslular'ın yanına getirecek; ben de onları kesip koparacağım. ");
INSERT INTO turytc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Onların ilâhlarına eğilmeyecek, onlara hizmet etmeyecek, onların uygulamalarını izlemeyeceksiniz; tersine onları tamamen devirecek ve dikili taşlarını yıkacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Tanrınız Yahve'ye hizmet edeceksiniz, O da ekmeğinizi ve suyunuzu bereketleyecek, ben de aranızdan hastalıkları kaldıracağım. ");
INSERT INTO turytc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ülkenizde kimse düşük yapmayacak, kısır bulunmayacak. Günlerinizin sayısını tamamına erdireceğim. ");
INSERT INTO turytc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Önünüzden dehşetimi salacağım, karşılaşacağınız bütün halkları şaşkına çevireceğim, bütün düşmanlarınızın size sırtını çevirteceğim. ");
INSERT INTO turytc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Hivliler'i, Kenanlılar'ı, Hititliler'i önünüz sıra kovacak, eşek arısını önünüzden göndereceğim. ");
INSERT INTO turytc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ülke ıssız kalmasın, kır hayvanları size karşı çoğalmasın diye, onları bir yıl içinde önünüzden kovmayacağım. ");
INSERT INTO turytc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Siz çoğalıncaya ve ülkeyi miras alana dek onları azar azar önünüzden kovacağım. ");
INSERT INTO turytc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Sınırınızı Kızıldeniz'den Filist denizine kadar, çölden o Nehre kadar koyacağım; çünkü ülkede yaşayanları elinize teslim edeceğim ve siz onları önünüzden kovacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Onlarla ve ilâhlarıyla antlaşma yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bana karşı günah işlememeniz için ülkenizde oturmayacaklar. Çünkü onların ilâhlarına hizmet ederseniz, bu kesin olarak sizin için bir tuzak olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ve Moşe'ye şöyle dedi: “Sen, Aron, Nadav, Avihu ve İsrael ihtiyarlarından yetmiş kişi Yahve'nin yanına çıkın; ve uzaktan tapının. ");
INSERT INTO turytc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Yalnız Moşe Yahve'ye yaklaşacak, ama onlar yaklaşmayacak. Halk onunla birlikte çıkmayacak.” ");
INSERT INTO turytc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moşe gelip Yahve'nin bütün sözlerini ve bütün hükümlerini halka anlattı; bütün halk da bir sesle yanıt verdi ve: “Yahve'nin söylediği bütün sözleri yapacağız.” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moşe Yahve'nin tüm sözlerini yazdı, sonra sabah erkenden kalktı ve dağın eteğinde İsrael'in on iki oymağı için on iki sütunlu bir sunak kurdu. ");
INSERT INTO turytc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","İsrael'in çocuklarından gençler gönderdi, Yahve'ye yakmalık sunular sundular, esenlik kurbanı olarak boğalar kestiler. ");
INSERT INTO turytc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moşe kanın yarısını leğenlere koydu, yarısını da sunağın üzerine serpti. ");
INSERT INTO turytc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Antlaşma kitabını alıp halkın önünde okudu ve onlar, “Yahve'nin bütün söylediklerini yapacağız ve itaat edeceğiz” dediler. ");
INSERT INTO turytc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moşe kanı alıp halkın üzerine serpti ve şöyle dedi: “İşte, bu, tüm bu sözlerle ilgili olarak Yahve'nin sizinle yaptığı antlaşmanın kanıdır.” ");
INSERT INTO turytc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Bunun üzerine Moşe, Aron, Nadav, Avihu ve İsrael'in ihtiyarlarından yetmiş kişi yukarı çıktılar. ");
INSERT INTO turytc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","İsrael'in Tanrısı'nı gördüler. Ayaklarının altında safir taşını andıran bir döşeme vardı; sanki gökyüzünün berraklığı gibiydi. ");
INSERT INTO turytc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","İsrael'in çocuklarının soylularına el sürmedi. Tanrı'yı gördüler, yediler, içtiler. ");
INSERT INTO turytc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahve Moşe'ye şöyle dedi: “Dağa, yanıma çık ve burada kal. Onlara öğretebilmen için yazdığım yasa ve buyruklarının bulunduğu taş levhalarını sana vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moşe ile hizmetkârı Yeşu kalktılar ve Moşe Tanrı Dağı'na çıktı. ");
INSERT INTO turytc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","İhtiyarlara şöyle dedi: “Biz tekrar yanınıza gelinceye dek bizi burada bekleyin. İşte Aron ve Hur seninle birlikteler. Anlaşmazlığa düşen herkes onlara gidebilir.” ");
INSERT INTO turytc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moşe dağa çıktı ve bulut dağı örttü. ");
INSERT INTO turytc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yahve'nin görkemi Sina Dağı'nın üzerinde durdu ve bulut onu altı gün boyunca örttü. Yedinci gün bulutun içinden Moşe'yi çağırdı. ");
INSERT INTO turytc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Yahve'nin görkeminin görünüşü, İsrael'in çocuklarının gözünde dağın zirvesinde yiyip bitiren ateş gibiydi. ");
INSERT INTO turytc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moşe bulutun içine girip dağa çıktı; Moşe kırk gün kırk gece dağda kaldı. ");
INSERT INTO turytc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“İsrael'in çocuklarına söyle, bana sunu getirsinler. Yüreği istekli olan herkesten sunumu alacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Onlardan alacağın sunular şunlardır: Altın, gümüş, tunç, ");
INSERT INTO turytc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mavi, mor, kırmızı, ince keten, keçi kılı, ");
INSERT INTO turytc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kırmızı boyalı koç derileri, deniz ayısı derileri, akasya ağacı, ");
INSERT INTO turytc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","kandil için yağ, mesh yağı ve hoş kokulu buhur için baharatlar, ");
INSERT INTO turytc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","oniks taşları, efod ve göğüslük için kakılacak taşlar. ");
INSERT INTO turytc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Aralarında oturmam için bana kutsal bir yer yapsınlar. ");
INSERT INTO turytc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Sana gösterdiğim her şeye, konutun örneğine ve içindeki tüm takımların örneğine göre, öyle yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Akasya ağacından bir sandık yapacaklar. Uzunluğu iki buçuk arşın, eni bir buçuk arşın ve yüksekliği bir buçuk arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Onu saf altınla kaplayacaksın. İçini ve dışını kaplayacaksın, çevresine de altın pervaz yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Onun için dört altın halka dökeceksin ve onları dört ayağına takacaksın. Bir tarafında iki halka, diğer tarafında iki halka bulunacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Akasya ağacından sırıklar yapacaksın ve onları altınla kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Sandığı taşımak için sırıkları sandığın yanlarındaki halkalara takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Sırıklar sandığın halkalarında kalacak. Ondan ayrılmayacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sana vereceğim antlaşmayı sandığın içine koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Saf altından bir merhamet örtüsü yapacaksın. Uzunluğu iki buçuk arşın, genişliği bir buçuk arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Dövme altından iki keruv yapacaksın. Bunları merhamet örtüsünün iki ucuna yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Bir uçta bir keruv, diğer uçta öbür keruvu yap. Keruvların iki ucunu merhamet örtüsüyle birlikte tek parça yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Keruvlar kanatlarını yukarıya doğru açacak, yüzleri birbirine bakacak şekilde merhamet örtüsünü kanatlarıyla örtecekler. Keruvların yüzleri merhamet örtüsüne doğru olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Merhamet örtüsünü sandığın üstüne koyacaksın ve sana vereceğim antlaşmayı sandığın içine koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Orada seninle buluşacağım ve İsrael'in çocukları için sana buyuracağım her şeyi, antlaşma sandığı üzerindeki iki keruvun arasından, merhamet örtüsünün üzerinden sana söyleyeceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Akasya ağacından bir masa yapacaksın. Uzunluğu iki arşın, eni bir arşın ve yüksekliği bir buçuk arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Onu saf altınla kaplayacaksın ve çevresine altın pervaz yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Çevresine bir karış genişliğinde bir kenar yapacaksın. Kenarın çevresine altın pervaz yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Onun için dört altın halka yapacaksın ve halkaları dört ayağının dört köşesine yerleştireceksin. ");
INSERT INTO turytc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Masayı taşıyacak sırıkların yeri için halkalar kenara yakın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Sırıkları akasya ağacından yapacaksın, onları altınla kaplayacaksın ve masa onlarla taşınacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Onun tabaklarını, kaşıklarını, kepçelerini, sunuları dökeceğiniz taslarını siz yapacaksınız. Onları saf altından yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Huzur ekmeğini her zaman önüme koyacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Saf altından bir şamdan yapacaksın. Şamdanın ayağı ve gövdesi dövmeci işi olacak. Tabanı, gövdesi, çanakları, tomurcukları ve çiçekleri ondan tek parça olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Yanlarından altı kol çıkacak: şamdanın bir yanından üç kol, diğer yanından da üç kol çıkacak; ");
INSERT INTO turytc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","bir kolda badem çiçeğine benzeyen üç tas, bir tomurcuk ve bir çiçek; diğer kolda da badem çiçeğine benzeyen üç tas, bir tomurcuk ve bir çiçek olacak, şamdandan çıkan altı kol için böyle olacaktır; ");
INSERT INTO turytc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","şamdanda badem çiçeğine benzer dört tas, onun tomurcukları ve çiçekleri olacaktır; ");
INSERT INTO turytc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ondan çıkan altı kol için, iki kol altında kendinden bir tomurcuk, iki kol altında kendinden bir tomurcuk ve iki kol altında kendinden bir tomurcuk olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tomurcukları ve kolları onunla tek parça olacak; hepsi saf altından dövmeci işi olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Onun kandillerini yedi tane yapacaksın; onlar da önündeki boşluğa ışık versin diye kandillerini yakacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Makasları ve tablaları saf altından olacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Bütün bu takımlarla birlikte bir talant saf altından yapılacak. ");
INSERT INTO turytc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Bak, bunları dağda sana gösterilen örneklerine göre yap.” ");
INSERT INTO turytc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Dahası konutu ince ketenden, mavi, erguvani ve kırmızı, keruvlarla on perdeyle yapacaksın. Bunları usta bir işçinin işiyle yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Her perdenin uzunluğu yirmi sekiz arşın, her perdenin eni dört arşın olacak; bütün perdelerin bir ölçüsü olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Beş perde birbirine bağlanacak, diğer beş perde de birbirine bağlanacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Bağlantı parçasındaki kenardan itibaren bir perdenin kenarına mavi ilmekler yapacaksın; aynısını ikinci bağlantı parçasındaki perdenin en dıştaki kenarına da yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Bir perdede elli ilmek yapacaksın ve ikinci bağlamadaki perdenin kenarında da elli ilmek yapacaksın. İlmekler birbirinin karşısında olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Elli altın kopça yapacaksın ve perdeleri kopçalarla birbirine bağlayacaksın. Konut tek parça olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Konutun üzerini örtmek için keçi kılından perdeler yapacaksın. On bir perde yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Her perdenin uzunluğu otuz arşın, her perdenin eni dört arşın olacak; on bir perdenin bir ölçüsü olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Beş perdeyi ayrı ayrı, altı perdeyi ayrı ayrı birleştireceksin; altıncı perdeyi çadırın ön tarafında ikiye katlayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bağlamadaki en dıştaki perdenin kenarına elli ilmek, ikinci bağlamadaki en dıştaki perdenin kenarına elli ilmek yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Elli tunç kopça yapacaksın, kopçaları ilmeklere geçireceksin ve çadırı birleştireceksin ki, tek parça olsun. ");
INSERT INTO turytc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Çadırın perdelerinden artan yarım perde, çadırın arka kısmından sarkacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Çadırın perdelerinin uzunluğundan artakalan miktarın bir yanda ve diğer yanda arşın kadarı, çadırı örtmek için bu yanda ve öte yanda, çadırın yanlarından sarkacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Çadır için kırmızı boyalı koç derilerinden bir örtü, üstüne de deniz ayısı derilerinden bir örtü yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Konutun çerçevelerini dik duracak şekilde akasya ağacından yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Bir çerçevenin uzunluğu on arşın, her bir çerçevenin eni bir buçuk arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Her kenarda birbirine bağlı iki geçmesi olacak; çadırın bütün çerçevelerini böyle yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Konutun güney tarafı, güney yönü için yirmi çerçeve yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Yirmi çerçevenin altına kırk gümüş taban; iki geçmesi için bir çerçevenin altında iki taban ve iki geçmesi için başka bir çerçevenin altında iki geçme yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Konutun kuzey tarafı, ikinci yanı için yirmi çerçeve, ");
INSERT INTO turytc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ve bir çerçeve altında iki taban, diğer çerçeve altında iki taban olmak üzere bunların kırk gümüş tabanını yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Konutun batıya bakan uzak tarafı için altı çerçeve yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Konutun uzak tarafındaki köşeleri için iki çerçeve yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Aşağıda çift olacaklar ve aynı şekilde tepeden tek halkaya kadar çift olacaklar; ikisi için de böyle olacak; onlar iki köşe için olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Sekiz çerçeve ve bunların gümüş tabanları, bir çerçeve altında iki taban ve diğer çerçevenin altında iki taban olmak üzere, onların on altı tabanları olacak.” ");
INSERT INTO turytc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Konutun bir tarafındaki çerçeveler için beş, konutun diğer tarafındaki çerçeveler için beş, ");
INSERT INTO turytc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ve konutun doğu uzak tarafındaki çerçeveler için beş olmak üzere akasya ağacından kirişler yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Çerçevelerin ortasındaki orta kiriş bir uçtan bir uca geçecek. ");
INSERT INTO turytc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Çerçeveleri altınla kaplayacaksın, ve kirişlerin yeri olarak altın halkalar yapacaksın. Kirişleri altınla kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Konutu dağda sana gösterildiği şekle göre kuracaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Lacivert, mor, kırmızı ve ince dokunmuş ince ketenden keruvlarla bir perde yapacaksın. Usta bir işçinin işi olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Onu altınla kaplanmış akasya ağacından dört sütun üzerine asacaksın. Çengelleri dört gümüş taban üzerinde altından olacak. ");
INSERT INTO turytc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Perdeyi kopçaların altına asacaksın ve Antlaşma Sandığı'nı perdenin içine, oraya getireceksin. Perde sizin için Kutsal Yeri En Kutsal Yer'den ayıracaktır. ");
INSERT INTO turytc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Merhamet Örtüsü'nü Antlaşma Sandığı'nın üzerine, En Kutsal Yer'e koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Masayı perdenin dışına koyacaksın, şamdanı da masanın karşısına, çadırın güney tarafına koyacaksın. Masayı kuzey tarafına koyacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Çadırın kapısına mavi, mor, kırmızı ve özenle dokunmuş ince ketenden nakışçı işi bir perde yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Perde için akasya ağacından beş direk yapacaksın ve onları altınla kaplayacaksın. Çengelleri altından olacak. Onlar için beş tunç taban dökeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Sunağı akasya ağacından, uzunluğu beş arşın, eni beş arşın olacak şekilde yapacaksın. Sunak kare şeklinde olacak. Yüksekliği üç arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Dört köşesine boynuz yapacaksın. Boynuzları kendisiyle tek parça olacaktır. Onu tunçla kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Küllerini uzaklaştırmak için onun kaplarını, küreklerini, leğenlerini, et çatallarını ve ateş kaplarını yapacaksın. Onun bütün takımlarını tunçtan yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Onun için tunç ağdan bir ızgara yapacaksın. Ağın dört köşesine dört tunç halka yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ağ sunağın yarısına kadar ulaşsın diye onu alttaki sunağın çevresindeki çıkıntının altına koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Sunak için akasya ağacından sırıklar yapacaksın ve onları tunçla kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Sırıkları halkalara geçirilecek ve sırıklar sunağı taşırken sunağın iki yanında olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tahtadan içi boş olarak yapacaksın. Dağda sana gösterildiği gibi yapacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Konutun avlusunu yapacaksın; güney tarafı için güneye doğru, avlunun bir tarafı için yüz arşın uzunluğunda özenle dokunmuş ince ketenden perdeler olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Yirmi direği, tabanları da yirmi tunçtan olacak. Direklerin çengelleri ve çemberleri gümüşten olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Aynı şekilde kuzey tarafının uzunluğu için de yüz arşın uzunluğunda perdeler, yirmi direk ve tunçtan yirmi tabanları olacak; sütunların çengelleri ve çemberleri gümüşten olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Çünkü avlunun batı tarafında eni elli arşın perde olacak; on direk, on taban olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Avlunun doğuya doğru eni elli arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kapının bir tarafındaki perdeler on beş arşın olacak; direkleri üç, tabanları da üç olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Diğer tarafta on beş arşınlık perdeler olacak; direkleri üç, tabanları da üç olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Avlunun kapısı için yirmi arşın boyunda mavi, mor, kırmızı, özenle dokunmuş ince ketenden, nakışçı işi bir perde olacak; direkleri dört ve tabanları da dört olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Avlunun çevresindeki tüm direkler gümüşle kaplanacak; çengelleri gümüşten, tabanları tunçtan olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Avlunun uzunluğu yüz arşın, eni elli arşın, yüksekliği beş arşın olacak ve özenle dokunmuş ince ketenden olacak; tabanları tunçtan olacak. ");
INSERT INTO turytc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Konutun tüm hizmetinde kullanılan bütün aletleri, bütün kazıkları, avlunun kazıklarının tümü tunçtan olacak.” ");
INSERT INTO turytc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Şamdan sürekli yansın diye, ışık için sıkma saf zeytinyağı getirmelerini İsrael'in çocuklarına buyuracaksın. ");
INSERT INTO turytc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aron'la oğulları, Buluşma Çadırı'nda, antlaşma önündeki perdenin dışında, onu akşamdan sabaha kadar Yahve'nin önünde tutacaklar; bu, İsrael'in çocukları için kuşaklar boyu daima geçerli olacak bir kural olacak.” ");
INSERT INTO turytc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“İsrael'in çocukları arasından bana kâhinlik makamında hizmet etmeleri için kardeşin Aron'u ve oğulları Nadav'ı, Avihu'yu, Eleazar'ı ve İtimar'ı yanına getir. ");
INSERT INTO turytc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kardeşin Aron'a görkem ve güzellik için kutsal giysiler yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kendilerini bilgelik ruhuyla doldurduğum tüm bilge yürekli adamlara söyleyeceksin, bana kâhinlik makamında hizmet etmek üzere Aron'un kutsal kılınması için onun giysilerini yapsınlar. ");
INSERT INTO turytc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yapacakları giysiler şunlardır: Göğüslük, efod, kaftan, nakışlı gömlek, sarık ve kuşak. Kardeşin Aron'a ve oğullarına, kâhinlik makamında bana hizmet etmesi için kutsal giysiler yapacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Altını, maviyi, moru, kırmızıyı ve ince keteni kullanacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Efodu altın, mavi, mor, kırmızı ve özenle dokunmuş ince ketenden usta işi olarak yapacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Birbirine bağlanabilmesi için iki ucunda birleştirilmiş iki omuz askısı bulunacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Üzerindeki ustalıkla dokunmuş şerit onun işi gibi ve aynı parçadan olacak; altın, mavi, mor, kırmızı ve özenle dokunmuş ince ketenden olacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","İki oniks taşı alıp üzerlerine İsrael'in çocuklarının adlarını oyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Doğum sırasına göre altısının adı bir taşta, altısının adı ise diğer taşta olacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","İki taşı, İsrael çocuklarının adlarına göre, mühür oyması gibi, taşa oymacı ustalığıyla oyacaksın. Onları altın yuvalar içine koyduracaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","İsrael'in çocukları için anma taşları olarak iki taşı efodun omuzluklarına koyacaksın. Aron onların adlarını anılma için Yahve'nin önünde iki omzunda taşıyacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Altından yuvalar, ");
INSERT INTO turytc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","saf altından iki zincir yapacaksın; onları örgülü kordon gibi yapacaksın. Örgülü zincirleri yuvalara takacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Hüküm göğüslüğünü usta işi yapacaksın; onu efodun işi gibi yapacaksın; altından, mavi, erguvan, kırmızı ve özenle dokunmuş ince ketenden yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kare şeklinde ve ikiye katlanmış olacak; bir karış uzunluğu, bir karış da eni olacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Oraya dört sıra taş yuvası koyacaksın; ilk sırada yakut, topaz ve beril olacak; ");
INSERT INTO turytc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ve ikinci sırada firuze, safir ve zümrüt; ");
INSERT INTO turytc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","üçüncü sırada gök yakut, agat, ametist; ");
INSERT INTO turytc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ve dördüncü sırada sarı yakut, oniks ve yeşim olacak. Onlar altın yuvalarına kakılacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Taşlar İsrael çocuklarının adlarına göre on iki adet olacak; mühür oymaları gibi, on iki oymak için her birinin kendi adına göre olacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Göğüslük üzerine saf altından örgülü kordon gibi zincirler yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Göğüslük üzerine iki altın halka yapacaksın ve bu iki halkayı göğüslüğün iki ucuna takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","İki örgülü altın zinciri göğüslüğün uçlarındaki iki halkaya takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","İki örgü zincirin diğer iki ucunu iki yuvanın üzerine geçirip efodun ön kısmındaki omuzluklara takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","İki altın halka yapacaksın ve bunları göğüslüğün iki ucuna, efodun iç tarafına doğru olan kenarına takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","İki altın halka yapacaksın ve bunları efodun iki omuz askısının altına, ön kısmına, bağlantı parçasının yakınına, efodun ustaca dokunmuş şeridinin üstüne takacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Göğüslüğü halkalarıyla efodun halkaları mavi bir kordonla birbirine bağlayacaklar. Öyle ki, göğüslük efodun ustaca dokunmuş şeridi üzerinde olsun ve göğüslük efodtan ayrılmasın. ");
INSERT INTO turytc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aron, Yahve'nin önünde anılmak üzere kutsal yere girdiğinde, İsrael'in çocuklarının adlarını hüküm göğüslüğünde sürekli olarak yüreği üzerinde taşıyacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim'i ve Tummim'i hüküm göğüslüğüne koyacaksın; Aron Yahve'nin huzuruna girdiğinde bunlar onun yüreği üzerinde olacaklar. Aron, İsrael'in çocuklarının hükmünü Yahve'nin önünde sürekli yüreği üzerinde taşıyacak.” ");
INSERT INTO turytc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Efodun kaftanını tamamen mavi yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ortasında baş için bir delik olacak. Yırtılmaması için boşluğunun kenarında, bir zırh deliği gibi dokuma işi bir kenarlık bulunacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Etek kısmı boyunca mavi, mor ve kırmızı narlar yapacaksın; tüm etek boyunca aralarında ve çevresinde altın çıngıraklar olacak: ");
INSERT INTO turytc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kaftanının eteğinde bir altın çıngırak, bir nar, bir altın çıngırak ve bir nar olacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Hizmet etme görevi Aron'a ait olacak; kutsal yere Yahve'nin huzuruna girdiğinde ve çıktığında ölmedi diye onun sesi duyulacak.” ");
INSERT INTO turytc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Saf altından bir levha yapacaksın ve üzerine mühür oyması gibi 'Yahve'ye kutsaldır' yazısını oyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Onu mavi bir kordon üzerine koyacaksın, sarığın üzerinde olacak, sarığın ön tarafında olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aron'un alnı üzerinde olacak ve İsrael'in çocuklarının tüm kutsal armağanlarında, bütün kutsal şeylerindeki suçu Aron taşıyacak; ve bunlar Yahve'nin önünde kabul edilsinler diye, bu her zaman onun alnı üzerinde olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Gömleği ince ketenden dokuyacaksın. İnce ketenden sarık yapacaksın. Nakışçı işi kuşak yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Aron'un oğulları için gömlekler yapacaksın. Onlar için kuşak yapacaksın. Görkem ve güzellik için onlara başlıklar yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Onları kardeşin Aron'a ve onunla birlikte olan oğullarına giydireceksin; onları meshedeceksin, atayacaksın ve kutsal kılacaksın ki, kâhinlik makamında bana hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Onlara çıplak yerlerini örtecek keten donlar yapacaksın. Belden kalçalara kadar uzanacak. ");
INSERT INTO turytc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Suç taşıyıp ölmesinler diye, Buluşma Çadırı'na girdiklerinde ya da kutsal yerde hizmet etmek için sunağa yaklaştıklarında Aron'la oğulları üzerinde olacaklar. Bu, hem kendisi hem de kendisinden sonraki soyu için daima bir kural olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Bana kâhinlik makamında hizmet edebilmeleri için onları kutsal kılmak üzere şunları yapacaksın: Kusursuz bir boğa ve iki koç, ");
INSERT INTO turytc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","mayasız ekmek, yağla yoğrulmuş mayasız pideler ve yağla meshedilmiş mayasız yufkalar al. Bunları ince buğday unundan yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Onları bir sepete koy, boğa ve iki koçu birlikte getir. ");
INSERT INTO turytc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Aron'la oğullarını Buluşma Çadırı'nın kapısına getirip onları suyla yıkayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Giysileri al, Aron'a gömleği, efodun kaftanını, efodu ve göğüslüğü giydir, efodun ustaca dokunmuş şeridini ona bağla. ");
INSERT INTO turytc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Onun başına sarığı koyacaksın, sarığın üstüne de kutsal tacı koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Sonra mesh yağını alıp başına dökeceksin ve onu meshedeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Oğullarını getirip üzerlerine gömlek giydireceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aron'la oğullarına kuşaklar takacaksın, onlara başlıklar bağlayacaksın. Kalıcı bir kuralla kâhinlik onların olacak. Aron'la oğullarını adayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Boğayı Buluşma Çadırı'nın önüne getireceksin; Aron ile oğulları ellerini boğanın başına koyacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Boğayı Yahve'nin önünde, Buluşma Çadırı'nın kapısında keseceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Boğanın kanını alıp parmağınla sunağın boynuzlarına süreceksin; bütün kanı sunağın dibine dökeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","İçini kaplayan yağın tamamını, karaciğerin zarını, iki böbreği ve üzerlerindeki yağı alıp onları sunak üzerinde yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ancak boğanın etini, derisini ve gübresini ordugâhın dışında ateşle yakacaksın. Bu bir günah sunusudur.” ");
INSERT INTO turytc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Sen de bir koç alacaksın; Aron'la oğulları ellerini koçun başına koyacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Koçu keseceksin, kanını alıp sunağın üzerine çepeçevre serpeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Koçu parçalara ayıracaksın, içini ve bacaklarını yıkayacak, parçalarıyla ve başıyla birlikte koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Koçun tamamını sunak üzerinde yakacaksın; bu Yahve'ye yakmalık bir sunudur; hoş bir kokudur, ateşle Yahve'ye yapılan bir sunudur.” ");
INSERT INTO turytc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Diğer koçu alacaksın; Aron'la oğulları ellerini koçun başına koyacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Sonra koçu kesip kanından biraz alacaksın, onu Aron'un sağ kulak memesi üzerine, ve oğullarının sağ kulak memeleri üzerine, ve sağ ellerinin başparmağı üzerine ve sağ ayaklarının başparmağı üzerine koyacaksın; kanı sunağın üzerine serpeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Sunağın üzerindeki kanı ve mesh yağını alıp Aron'un, onun giysilerinin, oğullarının ve onunla birlikte oğullarının giysilerinin üzerine serpeceksin; o ve onun giysileri, oğulları ve oğullarının giysileri de kendisiyle birlikte kutsal kılınacak. ");
INSERT INTO turytc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ayrıca koçun yağının bir kısmını, kuyruk yağını, içini kaplayan yağı, karaciğerin zarını, iki böbreği, üzerlerindeki yağı ve sağ budu (çünkü o bir adama koçudur), ");
INSERT INTO turytc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Yahve'nin önündeki mayasız ekmek sepetinden bir somun ekmek, bir yağlı pide ve bir de yufka alacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Bunların hepsini Aron'un ve oğullarının ellerine koyacaksın ve onları sallama sunusu olarak Yahve'nin önünde sallayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Onları ellerinden alacaksın ve Yahve'nin önünde hoş bir koku olarak sunak üzerinde yakmalık sunu üzerinde yakacaksın; bu, Yahve'ye ateşle yapılan bir sunudur.” ");
INSERT INTO turytc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Aron'un adaklık koçunun döşünü alacaksın ve onu Yahve'nin önünde sallama sunusu olarak sallayacaksın. Bu senin payın olacak. ");
INSERT INTO turytc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Aron için olan, oğulları için olan adama koçundan, sallanan sallama sunusu döşünü ve kaldırılan kaldırma budunu kutsayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Aron için ve oğulları için, İsrael'in çocuklarından daima onların payı olacaktır; çünkü bu bir sallama sunusudur. Bu, İsrael'in çocuklarının esenlik sunularının kurbanlarından sallama sunusu, onların Yahve'ye sallama sunusu olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aron'un kutsal giysileri kendisinden sonra onların meshedilmesi ve kutsanması için oğullarının olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Onun yerine kâhin olan oğul, Kutsal Yer'de hizmet etmek üzere Buluşma Çadırı'na girdiğinde bunları yedi gün giyecek.” ");
INSERT INTO turytc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Adama koçunu alıp etini kutsal bir yerde haşlayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aron'la oğulları koç etini ve sepetteki ekmeği Buluşma Çadırı'nın kapısında yiyecekler. ");
INSERT INTO turytc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Onları atayan ve kutsal kılmak için kefaret edilmiş olan şeyleri yiyecekler; ama bir yabancı ondan yemeyecek; çünkü bunlar kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Eğer adama etinden ya da ekmekten sabaha kalırsa, o zaman kalanını ateşte yakacaksın. Yenmeyecektir çünkü kutsaldır.” ");
INSERT INTO turytc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Sana buyurduğum her şeye göre Aron'la oğullarına böyle yapacaksın. Onları yedi gün adayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Her gün günah sunusu olan boğayı kefaret için sunacaksın. Sunak için kefaret ettiğinde onu temizleyeceksin. Onu kutsal kılmak için meshedeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yedi gün sunak için kefaret edeceksin ve onu kutsal kılacaksın; sunak çok kutsal olacak. Sunağa dokunan her şey kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Sunakta sunacağınız budur: Devamlı olarak bir yaşında iki kuzu. ");
INSERT INTO turytc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Bir kuzuyu sabahleyin sunacaksın; ve diğer kuzuyu akşam üstü sunacaksın; ");
INSERT INTO turytc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","bir kuzuyla birlikte dörtte bir hin sıkma yağla yoğrulmuş onda bir efa ince un ve dökülen sunu olarak dörtte bir hin şarap sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Diğer kuzuyu akşam üstü sunacaksın ve hoş koku, Yahve'ye ateşle yakmalık sunu olarak ona, sabahın ekmek sunusu gibi, dökülen sunu gibi yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Bu, sizinle konuşmak için sizinle buluşacağım Buluşma Çadırı'nın kapısında, Yahve'nin önünde kuşaklarınız boyunca sürekli olarak yakmalık bir sunu olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Orada İsrael'in çocuklarıyla buluşacağım; bu yer benim yüceliğim aracılığıyla kutsal kılınacak. ");
INSERT INTO turytc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Buluşma Çadırı'nı ve sunağı kutsal kılacağım. Aron'u ve oğullarını da kâhinlik makamında bana hizmet etmeleri için kutsayacağım. ");
INSERT INTO turytc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","İsrael'in çocukları arasında oturacağım ve onların Tanrısı olacağım. ");
INSERT INTO turytc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Aralarında oturmak için kendilerini Mısır diyarından çıkaran Tanrıları Yahve olduğumu bilecekler: Ben onların Tanrısı Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Buhur yakmak için bir sunak yapacaksın. Onu akasya ağacından yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Uzunluğu bir arşın, eni bir arşın olacak. Kare şeklinde olacak ve yüksekliği iki arşın olacak. Boynuzları kendisiyle tek parça olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Onu, üstünü, yanlarını ve boynuzlarını saf altınla kaplayacaksın; çevresine altın pervaz yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pervazının altına iki altın halka yapacaksın; iki yanları üzerinde, iki tarafa yapacaksın; bunlar onu taşıyacak sırıklar için yer olacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Sırıkları akasya ağacından yapıp altınla kaplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Onu, seninle buluşacağım Antlaşma Sandığı'nın yanındaki perdenin önüne, antlaşma üzerindeki Merhamet Örtüsü'nün önüne koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aron her sabah onun üzerine hoş baharatlardan buhur yakacak. Kandilleri düzelttiği zaman onu yakacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aron akşam üstü kandilleri yaktığında, onu Yahve'nin önünde kuşaklar boyu sürekli bir buhur olarak yakacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Onun üzerinde yabancı buhur, yakmalık sunu ve ekmek sunusu sunmayacaksınız; üzerine dökülen sunudan dökmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aron yılda bir kez onun boynuzları üzerinde kefaret edecek; yılda bir kez günah kefareti sunusunun kanı ile kuşaklarınız boyunca kefaret edecektir. Yahve için çok kutsaldır.” ");
INSERT INTO turytc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yahve Moşe'ye söyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“İsrael'in çocuklarının sayımını, aralarında sayılanlara göre yaptığın zaman, saydığında herkes canına karşılık Yahve'ye fidye verecek, ta ki onları saydığın zaman aralarında bela olmasın. ");
INSERT INTO turytc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Sayılmış olanlar tarafına geçen herkes, Kutsal Yer'in şekeline göre yarım şekel, (bir şekel yirmi geradır) Yahve'ye sunu olarak yarım şekel verecektir. ");
INSERT INTO turytc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Yirmi yaşında ve ondan yukarı olup sayılanlar tarafında geçen herkes, Yahve'ye sunu verecektir. ");
INSERT INTO turytc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Canlarınızın kefareti olarak Yahve'ye sunu verdiklerinde, zengin yarım şekelden fazla, yoksul da yarım şekelden az vermeyecektir. ");
INSERT INTO turytc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","İsrael'in çocuklarından kefaret parasını alıp Buluşma Çadırı'nın hizmetine vereceksin; ta ki bu, canlarınızın kefareti olsun diye, İsrael'in çocuklarına Yahve'nin önünde bir anma olsun.” ");
INSERT INTO turytc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Yıkanmak için tunçtan bir kazan ve onun ayağını da tunçtan yapacaksın. Onu Buluşma Çadırı ile sunak arasına koyacaksın ve içine su koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aron'la oğulları ellerini ve ayaklarını onda yıkayacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Buluşma Çadırı'na girdikleri zaman, ya da hizmet etmek için Yahve'ye ateşle yapılan sunuyu yakmak için sunağa yaklaştıkları zaman, ölmesinler diye suyla yıkanacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ölmesinler diye ellerini ve ayaklarını yıkayacaklar. Bu onlara, kendisi ve onun soyundan gelenler için kuşaklar boyu daima bir kural olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Dahası Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ayrıca güzel baharatlar da al: Beş yüz şekel sıvı mür, yarısı kadar, iki yüz elli şekel hoş kokulu tarçın; iki yüz elli şekel hoş kokulu kamış; ");
INSERT INTO turytc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kutsal yerin şekeline göre beş yüz şekel hıyarşembe ve bir hin zeytinyağı. ");
INSERT INTO turytc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Onu kutsal mesh yağı haline getireceksin, attar işine göre hazırlanmış bir hoş koku; kutsal mesh yağı olacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Buluşma Çadırı'nı, Antlaşma Sandığı'nı, ");
INSERT INTO turytc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","sofrayı ve içindeki bütün eşyaları, şamdan ve takımlarını, buhur sunağını, ");
INSERT INTO turytc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","yakmalık sunu sunağını ve tüm takımlarını, kazanı ve ayağını meshetmek için onu kullanacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Onları kutsal kılacaksın, onlar da çok kutsal olacaklar. Onlara dokunan her şey kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aron'la oğullarını meshedecek ve onları kutsal kılacaksın ki, onlar bana kâhinlik makamında hizmet etsinler. ");
INSERT INTO turytc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","İsrael'in çocuklarına şöyle diyeceksin: 'Bu, kuşaklarınız boyunca benim için kutsal mesh yağı olacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","İnsan bedeni üzerine dökülmeyecek ve derlemesine göre onun benzerini yapmayacaksınız. Bu kutsaldır. Sizin için kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kim buna benzer bir derleme yaparsa ya da kim ondan bir yabancıya sürerse, halkının arasından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahve Moşe'ye şöyle dedi: “Kendine hoş baharatlar, sakız reçinesi, onika, kasnı: Saf günnük ile hoş baharatlar al. Her birinin ağırlığı eşit olacak. ");
INSERT INTO turytc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ondan, tuzlanmış, saf ve kutsal bir buhur, attar işine göre bir koku yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bir kısmını çok ince döveceksin ve seninle buluşacağım Buluşma Çadırı'ndaki antlaşmanın önüne koyacaksın. Bu sizin için çok kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Bu buhuru derlemesine göre kendiniz için yapmayacaksınız; o senin için Yahve'ye kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Koklamak için kim buna benzer bir şey yaparsa, halkından atılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“İşte, Yahuda oymağından Hur oğlu Uri oğlu Bezalel'i adıyla çağırdım. ");
INSERT INTO turytc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Onu Tanrı'nın Ruhu'yla, bilgelikle, anlayışla, bilgiyle ve her türlü ustalıkla doldurdum; ");
INSERT INTO turytc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ta ki, ustaca işler tasarlasın, altında, gümüşde ve tunçda, ");
INSERT INTO turytc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","taş kesmede ve kakmada, ağaç oymacılığında ve her çeşit ustalıkta işlesin. ");
INSERT INTO turytc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","İşte ben de onun yanına Dan oymağından Ahisamak oğlu Oholiav'ı atadım; sana buyurduğum her şeyi yapabilsinler diye, yüreği bilge olanların hepsinin yüreğine bilgelik koydum: ");
INSERT INTO turytc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Buluşma Çadırı'nı, Antlaşma Sandığı'nı, onun üzerindeki Merhamet Örtüsü'nü, Çadır'ın bütün takımlarını, ");
INSERT INTO turytc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","masayı ve takımlarını, saf altın şamdanı ve tüm takımlarını, buhur sunağını, ");
INSERT INTO turytc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","yakmalık sunu sunağını ve tüm takımlarını, kazanı ve ayağını, ");
INSERT INTO turytc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","özenle dokunmuş giysileri, kâhin Aron'un kutsal giysilerini, oğullarının kâhinlik makamında hizmet edecekleri giysilerini; ");
INSERT INTO turytc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mesh yağını ve kutsal yer için hoş baharatlardan oluşan buhuru; sana buyurduğum her şeye göre yapacaklar.” ");
INSERT INTO turytc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“İsrael'in çocuklarına da söyle: 'Şabat günlerimi mutlaka tutacaksınız; çünkü bu, benim sizi kutsayan Yahve olduğumu bilesiniz diye kuşaklar boyu sizinle benim aramda bir belirtidir. ");
INSERT INTO turytc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Bunun için Şabat'ı tutacaksınız, çünkü o sizin için kutsaldır. Onu bozan herkes kesinlikle öldürülecektir; çünkü onun içinde her kim bir iş işlerse, o can halkının arasından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Altı gün iş işlenecek, ama yedinci günde Yahve'ye kutsal dinlenme Şabatı'dır. Şabat Günü'nde iş işleyen herkes kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Bu nedenle İsrael'in çocukları, daimi bir antlaşma gereği olarak, kuşaklar boyunca Şabat'a uymak için Şabat'ı tutacaklar. ");
INSERT INTO turytc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Bu benimle İsrael'in çocukları arasında daima bir belirti olacaktır; çünkü Yahve göğü ve yeri altı günde yarattı ve yedinci günde dinlendi ve rahatladı.'” ");
INSERT INTO turytc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sina Dağı'nda Moşe'yle konuşmasını bitirince, Tanrı'nın parmağı ile yazılmış olan iki antlaşma levhasını, ona verdi. ");
INSERT INTO turytc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Halk, Moşe'nin dağdan inmekte geciktiğini görünce, Aron'un yanında toplanıp ona şöyle dediler: “Gel, bize önümüzden gidecek ilâhlar yap; çünkü bizi Mısır diyarından çıkaran adama, bu Moşe'ye ne oldu bilmiyoruz.” ");
INSERT INTO turytc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron onlara, “Karılarınızın, oğullarınızın, kızlarınızın kulaklarındaki altın yüzükleri çıkarıp bana getirin” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bütün halk kulaklarındaki altın küpeleri çıkarıp Aron'a getirdi. ");
INSERT INTO turytc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ona verilenleri aldı, oymacı aletiyle ona şekil verdi ve dökme bir buzağı yaptı. Sonra onlar, “Ey İsrael, seni Mısır diyarından çıkaran ilâhların bunlardır” dediler. ");
INSERT INTO turytc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron bunu görünce önünde bir sunak yaptı; Aron ilan edip şöyle dedi: “Yarın Yahve'ye bayramdır.” ");
INSERT INTO turytc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ertesi gün erkenden kalktılar, yakmalık sunuları sındular ve esenlik sunularını getirdiler; insanlar yemek ve içmek için oturdular ve oynamak için kalktılar. ");
INSERT INTO turytc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yahve Moşe'ye şöyle dedi: “Git, aşağı in; çünkü Mısır diyarından çıkardığın halkın bozuldu! ");
INSERT INTO turytc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Onlar kendilerine buyurduğum yoldan çabuk saptılar. Kendileri için dökme bir buzağı yaptılar ve ona tapındılar, ona kurban kestiler ve dediler: Ey İsrael, seni Mısır diyarından çıkaran ilâhların bunlardır dediler.” ");
INSERT INTO turytc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yahve Moşe'ye şöyle dedi: “Bu halkı gördüm ve işte, onlar sert enseli bir halktır. ");
INSERT INTO turytc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Şimdi beni bırak da, onlara karşı öfkem alevlensin ve onları yok edeyim; seni de büyük bir ulus yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moşe Tanrısı Yahve'ye yalvarıp şöyle dedi: “Ey Yahve, Mısır diyarından büyük güçle, kudretli elle çıkardığın halkına karşı neden öfken alevleniyor? ");
INSERT INTO turytc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mısırlılar neden, 'Onları kötülük için, dağlarda öldürmek ve yeryüzünden yok etmek için çıkardı' diye konuşsunlar? Kızgın öfkenden dön ve halkına karşı bu kötülükten vazgeç. ");
INSERT INTO turytc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kendin üzerine ant içtiğin ve onlara, 'Senin soyunu gökteki yıldızlar kadar çoğaltacağım, hakkında söylediğim bütün bu diyarı sizin soyunuza vereceğim, onu sonsuza dek miras alacaklar' dediğin, hizmetkârların Avraham'ı', İshak'ı ve İsrael'i anımsa.” ");
INSERT INTO turytc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Böylece Yahve halkına yapacağını söylediği kötülükten vazgeçti. ");
INSERT INTO turytc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moşe dönüp elinde iki antlaşma levhasıyla dağdan indi; levhaların iki tarafı da yazılıydı. Onların bir tarafına ve öteki tarafına yazılmıştı. ");
INSERT INTO turytc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Levhalar Tanrı'nın işiydi ve levhaların üzerine kazınmış olan yazı da Tanrı'nın yazısıydı. ");
INSERT INTO turytc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yeşu, halkın bağırışlarını duyunca Moşe'ye, “Ordugâhta savaş gürültüsü var” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","O şöyle dedi: “Bu, zafer için bağıranların sesi değil. Yenilenlerin de feryat sesi değil bu; ama ben ezgi söyleyenlerin sesini duyuyorum.” ");
INSERT INTO turytc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ordugâha yaklaştığında buzağıyı ve dans edenleri gördü. O zaman Moşe'nin öfkesi alevlendi ve levhaları elinden fırlattı ve dağın eteğinde onları kırdı. ");
INSERT INTO turytc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Yaptıkları buzağıyı alıp ateşte yaktı, toz haline gelinceye kadar ezdi suyun üzerine serpti ve İsrael'in çocuklarına içirdi. ");
INSERT INTO turytc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moşe Aron'a, “Bu halk sana ne yaptı da onların üzerine büyük bir günah getirdin?” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron şöyle dedi: “Efendimin öfkesi alevlenmesin. Halkı sen bilirsin, kötülüğe eğilimlidir. ");
INSERT INTO turytc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Çünkü bana, 'Bizim için önümüzden gidecek ilâhlar yap' dediler. “Bizi Mısır diyarından çıkaran adama, bu Moşe'ye ne oldu bilmiyoruz.' ");
INSERT INTO turytc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ben de onlara, 'Kimde altın varsa çıkarsın' dedim. Onlar da bana verdi; onu ateşe attım ve bu buzağı çıktı.” ");
INSERT INTO turytc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moşe halkın kontrolden çıktığını görünce (çünkü Aron onları dizginlemediği için düşmanlarının alay konusu olmalarına neden olmuştu), ");
INSERT INTO turytc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moşe ordugâhın kapısında durdu ve şöyle dedi: “Kim Yahve'nin tarafındaysa, bana gelsin!” Levi'nin bütün oğulları onun yanında toplandılar. ");
INSERT INTO turytc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Onlara şöyle dedi: “İsrael'in Tanrısı Yahve şöyle diyor: 'Herkes kılıcını beline kuşansın, ordugâhta kapı kapı dolaşsın ve herkes kendi kardeşini, herkes kendi arkadaşını, ve herkes kendi komşusunu öldürsün.'” ");
INSERT INTO turytc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi oğulları Moşe'nin sözüne göre yaptılar. O gün yaklaşık üç bin kişi halktan düştü. ");
INSERT INTO turytc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moşe, “Bugün size bereket versin diye kendinizi Yahve'ye adayın” dedi, “Çünkü herkes oğluna ve kardeşine karşıydı.” ");
INSERT INTO turytc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ertesi gün Moşe halka şöyle dedi: “Büyük bir günah işlediniz. Şimdi Yahve'nin önüne çıkacağım. Belki günahınız için kefaret ederim.” ");
INSERT INTO turytc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moşe Yahve'ye dönüp şöyle dedi: “Ah bu halk büyük bir günah işledi ve kendilerine altından ilâhlar yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ama şimdi onların günahlarını bağışlasan—yoksa yazmış olduğun kitabından lütfen beni sil.” ");
INSERT INTO turytc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahve Moşe'ye şöyle dedi: “Kim bana karşı günah işlemişse, kitabımdan onu sileceğim. ");
INSERT INTO turytc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Şimdi git, halkı sana söylediğim yere götür. İşte, meleğim senin önünden gidecek. Ancak cezalandıracağım gün, onları günahlarından ötürü cezalandıracağım.” ");
INSERT INTO turytc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Çünkü Aron'un yaptığı buzağıya yaptıkları yüzünden Yahve halkı vurdu. ");
INSERT INTO turytc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahve Moşe'ye şöyle dedi: “Yola çık, sen ve Mısır diyarından çıkardığın halk Avraham'a, İshak'a ve Yakov'a, 'Senin soyuna vereceğim' diye ant içtiğim diyara buradan çıkın. ");
INSERT INTO turytc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Önünden bir melek göndereceğim; Kenanlılar'ı, Amorlular'ı, Hititler'i, Perizziler'i, Hivliler'i ve Yevuslular'ı kovacağım. ");
INSERT INTO turytc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Süt ve bal akan ülkeye gidin; ama ben sizin aranıza çıkmayacağım, çünkü siz sert enseli bir halksınız, yoksa yolda sizi tüketirim.” ");
INSERT INTO turytc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Halk bu kötü haberi duyunca yas tuttu; ve kimse takılarını takmadı. ");
INSERT INTO turytc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahve Moşe'ye şöyle demişti: “İsrael'in çocuklarına de ki, 'Siz sert enseli bir halksınız. Bir an aranıza çıksam, sizi tüketirim. Bu nedenle şimdi takılarını çıkar da sana ne yapacağımı bileyim.’” ");
INSERT INTO turytc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","İsrael'in çocukları Horev Dağı'ndan itibaren takılarını çıkardılar. ");
INSERT INTO turytc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moşe çadırı alıp ordugâhın dışına, ordugâhın çok uzağına kurardı ve ona “Buluşma Çadırı” adını verdi. Yahve'yi arayan herkes ordugâhın dışındaki Buluşma Çadırı'na giderdi. ");
INSERT INTO turytc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moşe Çadır'a çıkınca bütün halk ayağa kalkar, herkes kendi çadırının kapısında durup Moşe Çadır'a girene kadar onu izlerdi. ");
INSERT INTO turytc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moşe Çadır'a girince bulut sütuna inip Çadır'ın kapısında dururdu. Yahve Moşe'yle konuşurdu. ");
INSERT INTO turytc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bütün halk bulut sütununun Çadır'ın kapısında durduğunu görürdü. Herkes ayağa kalkıp kendi çadırının kapısında tapınırdı. ");
INSERT INTO turytc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahve Moşe'yle, bir adamın arkadaşıyla konuştuğu gibi yüz yüze konuşurdu. Tekrar ordugâha dönerdi ama genç bir adam olan hizmetkârı Nun oğlu Yeşu Çadır'dan ayrılmazdı. ");
INSERT INTO turytc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moşe Yahve'ye şöyle dedi: “İşte, sen bana, 'Bu halkı çıkar' diyorsun ama benimle kimi göndereceğini bana söylemedin. Ama sen, 'Seni adınla tanıyorum, sen de benim gözümde lütuf buldun' dedin. ");
INSERT INTO turytc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Bu nedenle, eğer senin gözünde lütuf bulduysam, lütfen şimdi bana yolunu göster, ta ki, gözünde lütuf bulayım diye seni bileyim; bu ulusun da senin halkın olduğunu gör.” ");
INSERT INTO turytc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ve dedi, “Varlığım seninle birlikte gidecek, sana rahat vereceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moşe O'na şöyle dedi: “Eğer varlığın benimle gitmeyecekse, bizi buradan çıkarma. ");
INSERT INTO turytc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Benim ve halkının senin gözünde lütuf bulduğumuzu insanlar nasıl bilecek? Senin bizimle gelmenle, böylece benim ve senin halkının yeryüzündeki bütün halklardan ayrılmış olmamızla değil mi?” ");
INSERT INTO turytc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahve Moşe'ye şöyle dedi: “Söylediğin bu şeyi de yapacağım; çünkü gözümde lütuf buldun ve seni adınla tanıyorum.” ");
INSERT INTO turytc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moşe, “Lütfen bana görkemini göster” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","O dedi, “Bütün iyiliğimi önünden geçireceğim ve senin önünde Yahve'nin adını ilan edeceğim. Lütfedeceğim insana lütfedeceğim, merhamet göstereceğim insana merhamet göstereceğim.” ");
INSERT INTO turytc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","“Yüzümü göremezsin, çünkü insan beni görüp de yaşayamaz” dedi. ");
INSERT INTO turytc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahve şunu da dedi: “İşte, yanımda bir yer var ve sen kayanın üzerinde duracaksın. ");
INSERT INTO turytc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Böyle olacak, görkemim gelip geçerken, seni bir kaya yarığına koyacağım ve ben oradan geçene kadar seni elimle örteceğim; ");
INSERT INTO turytc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","o zaman elimi kaldıracağım, sen de arkamı göreceksin; ama yüzüm görülmeyecek.” ");
INSERT INTO turytc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahve Moşe'ye şöyle dedi: “İlki gibi iki taş levha yont. Kırdığın ilk levhaların üzerinde olan sözleri levhaların üzerine yazacağım. ");
INSERT INTO turytc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sabah hazır ol, sabahleyin Sina Dağı'na çık ve orada, dağın zirvesinde yanıma gel. ");
INSERT INTO turytc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kimse seninle çıkmayacak, dağın hiçbir yerinde kimse görülmeyecek. O dağın önünde sürüler ya da sığırlar otlamasın.” ");
INSERT INTO turytc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","İlki gibi iki taş levhayı yonttu; sonra Moşe sabah erkenden kalktı, Yahve'nin kendisine buyurduğu gibi Sina Dağı'na çıktı ve eline iki taş levha aldı. ");
INSERT INTO turytc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahve bulutun içinde indi, orada onunla durdu ve Yahve'nin adını ilan etti. ");
INSERT INTO turytc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahve onun önünden geçerken ilan etti: “Yahve! Yahve, merhametli ve lütufkâr, geç öfkelenen, sevgi dolu iyiliği ve gerçeği bol olan, ");
INSERT INTO turytc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","binlercesi için sevgi dolu iyiliğini koruyan, haksızlığı, itaatsizliği ve günahı bağışlayan, babaların suçu için çocukları, çocukların üçüncü ve dördüncü kuşaklarını ziyaret ederek suçluyu hiçbir şekilde suçsuz çıkarmayan bir Tanrı'dır.” ");
INSERT INTO turytc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moşe aceleyle başını yere eğip tapındı. ");
INSERT INTO turytc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ve şöyle dedi: “Eğer şimdi senin gözünde lütuf bulduysam, ey Efendi, ensesi sert bir halk olsa da, lütfen Efendi bizimle birlikte gelsin; suçumuzu ve günahımızı bağışla ve bizi mirasın olarak al.” ");
INSERT INTO turytc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ve şöyle dedi: “İşte, bir antlaşma yapıyorum. Bütün halkının önünde, ne tüm dünyada, ne de hiçbir ulusta yapılmamış harikalar yapacağım; ve aralarında bulunduğun bütün halk Yahve'nin işini görecek; çünkü seninle yaptığım heybetli bir şeydir. ");
INSERT INTO turytc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Bugün sana buyurduğum şeyi tut. İşte, Amorlu, Kenanlı, Hititli, Perizli, Hivli ve Yevuslu'yu senin önünden kovacağım. ");
INSERT INTO turytc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Gideceğin ülkede yaşayanlarla antlaşma yapmamaya dikkat et, yoksa aranızda tuzak olur; ");
INSERT INTO turytc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ama onların sunaklarını yıkacaksın, dikili taşlarını parçalayacaksın ve onların Aşera putlarını keseceksin; ");
INSERT INTO turytc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","çünkü başka hiçbir ilâha tapmayacaksın; çünkü adı Kıskanç olan Yahve kıskanç bir Tanrı'dır.” ");
INSERT INTO turytc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Ülkede yaşayanlarla antlaşma yapma, yoksa onların ilâhlarının peşinden fahişelik ederler, ilâhlarına kurban sunarlar, biri seni çağırır, sen de onun kurbanından yersin; ");
INSERT INTO turytc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","onların kızlarını oğullarına alırsın ve onların kızları kendi ilâhlarının peşinden fahişelik eder, oğullarını da kendi ilâhlarının ardından fahişelik ettirirler.” ");
INSERT INTO turytc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kendiniz için dökme put yapmayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Mayasız Ekmek Bayramı'nı tutacaksın. Sana buyurduğum gibi, Aviv ayının belirlenen vaktinde, yedi gün mayasız ekmek yiyeceksin; çünkü Mısır'dan Aviv ayında çıktın.” ");
INSERT INTO turytc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Rahimi açan her şey; inekten ve koyundan, bütün hayvanlarının ilk doğan erkeklerinin hepsi benimdir. ");
INSERT INTO turytc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Eşeğin ilk doğanı için bir kuzunun fidyesini vereceksin. Eğer fidyesini veremeyeceksen, o zaman boynunu kıracaksın. Oğullarının tüm ilk doğanlarının fidyesini vereceksin. Hiç kimse karşımda boş görünmeyecek.” ");
INSERT INTO turytc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Altı gün çalışacaksın, ama yedinci gün dinleneceksin: Tarla sürme ve hasat zamanında dinleneceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Buğday hasadının ilk ürünleriyle Haftalar Bayramı'nı, yıl sonunda da Hasat Bayramı'nı yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Bütün erkeklerin yılda üç kez İsrael'in Tanrısı Efendi Yahve'nin önünde görünecekler. ");
INSERT INTO turytc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Çünkü önündeki ulusları kovacak, sınırlarını genişleteceğim; yılda üç kez Tanrın Yahve'nin önünde görünmek için çıktığında, hiç kimse ülkenizi arzulamayacak.” ");
INSERT INTO turytc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kurbanımın kanını mayalı ekmekle sunmayacaksın. Pesah Bayramı kurbanı sabaha bırakılmayacak.” ");
INSERT INTO turytc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Toprağının ilk seçme ürününü Tanrın Yahve'nin evine getireceksin. “Oğlağı anasının sütünde pişirmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahve Moşe'ye şöyle dedi: “Bu sözleri yaz; çünkü bu sözler uyarınca seninle ve İsrael'le bir antlaşma yaptım.” ");
INSERT INTO turytc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Kırk gün kırk gece Yahve'nin yanındaydı; ne ekmek yedi, ne de su içti. Antlaşmanın sözlerini, on buyruğu levhaların üzerine yazdı. ");
INSERT INTO turytc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moşe, elinde iki antlaşma levhasıyla Sina Dağı'ndan indiğinde, dağdan inerken Moşe, O'nunla konuştuğu için yüzünün derisinin parladığını bilmiyordu. ");
INSERT INTO turytc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aron'la bütün İsrael'in çocukları Moşe'yi gördüler, işte, yüzünün derisi parlıyordu; ve onun yanına yaklaşmaya korktular. ");
INSERT INTO turytc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moşe onları çağırdı. Aron'la bütün topluluk önderleri onun yanına döndüler. Moşe onlarla konuştu. ");
INSERT INTO turytc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Daha sonra bütün İsrael'in çocukları yaklaştı ve Yahve'nin Sina Dağı'nda kendisine söylemiş olduğu bütün buyrukları onlara verdi. ");
INSERT INTO turytc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moşe onlarla konuşmayı bitirince yüzüne bir peçe koydu. ");
INSERT INTO turytc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ancak Moşe konuşmak için Yahve'nin önüne gittiğinde, dışarı çıkana dek peçeyi kaldırırdı; ve dışarı çıkıp kendisine buyrulanı İsrael'in çocuklarına söylerdi. ");
INSERT INTO turytc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","İsrael'in çocukları Moşe'nin yüzünü gördüler, Moşe'nin yüzünün derisi parlıyordu; Moşe O'nunla konuşmak için içeri girene kadar peçeyi tekrar yüzüne kordu. ");
INSERT INTO turytc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moşe İsrael'in çocuklarının bütün topluluğunu toplayıp onlara şöyle dedi: “Yahve'nin yapmanız için buyurduğu şeyler şunlardır. ");
INSERT INTO turytc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","'Altı gün iş işlenecek, ama yedinci gün sizin için kutsal bir gün, Yahve'ye Şabat, dinlenme günü olacak; onun içinde iş işleyen her kişi öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Şabat Günü evlerinizde ateş yakmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moşe İsrael'in çocuklarının bütün topluluğuna şöyle dedi: “Yahve'nin buyurduğu şey şudur: ");
INSERT INTO turytc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","'Aranızda Yahve'ye sunu alın. Yüreği istekli olan herkes, onu Yahve'ye sunu olarak getirsin: Altın, gümüş, tunç, ");
INSERT INTO turytc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","mavi, mor, kırmızı, ince keten, keçi kılı, ");
INSERT INTO turytc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kırmızı boyalı koç derileri, deniz ayısı derisi, akasya ağacı, ");
INSERT INTO turytc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ışık için yağ, mesh yağı ve hoş kokulu buhur için baharatlar, ");
INSERT INTO turytc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","efod ve göğüslük için oniks ve kakma taşlar.'” ");
INSERT INTO turytc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“'Aranızda bilge yürekli olan her adam gelsin ve Yahve'nin buyurduğu her şeyi: ");
INSERT INTO turytc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Konutu, onun dış kaplamasını, tepesini, kopçalarını, çerçevelerini, kirişlerini, direklerini ve tabanlarını; ");
INSERT INTO turytc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sandığı ve sırıklarını, Merhamet Örtüsü'nü, bölme perdesini; ");
INSERT INTO turytc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","masayla sırıklarını, bütün takımlarını ve huzur ekmeğini; ");
INSERT INTO turytc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ışık için şamdanı, onun takımlarını, kandillerini, ışık için yağı; ");
INSERT INTO turytc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","buhur sunağını ve sırıklarını, mesh yağını, hoş kokulu buhuru, çadırın kapısındaki kapı perdesini; ");
INSERT INTO turytc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","yakmalık sunu sunağını, tunç ızgarasını, sırıklarını, bütün takımlarını, kazanı ve ayağını; ");
INSERT INTO turytc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","avlunun perdelerini, direklerini, tabanlarını ve avlu kapısının perdesini; ");
INSERT INTO turytc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","konutun kazıklarını, avlunun kazıklarını ve onları iplerini; ");
INSERT INTO turytc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","kutsal yerde hizmet etmek için özenle dokunmuş giysiler, kâhin Aron'un kutsal giysileri ve onun oğullarının - kâhinlik makamında hizmet etmek için giysilerini yapsınlar.'” ");
INSERT INTO turytc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","İsrael'in çocuklarının bütün topluluğu Moşe'nin önünden ayrıldı. ");
INSERT INTO turytc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Yüreği kendisini harekete geçiren ve ruhu istekli olan herkes geldiler ve Buluşma Çadırı'nın işi, tüm hizmetleri ve kutsal giysiler için Yahve'nin sunularını getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Erkek olsun kadın olsun, yüreği istekli olan herkes geldi, hepsi Yahve'ye altın sunular sundular, broşlar, küpeler, mühür yüzükleri, bilezikler getirdiler; hepsi altın takıydı. ");
INSERT INTO turytc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Yanında mavi, mor, kırmızı, ince keten, keçi kılı, kırmızı boyalı koç derileri ve deniz ayısı derileri bulunan herkes bunları getirdi. ");
INSERT INTO turytc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Gümüş ve tunç sunu sunan herkes Yahve'nin sunusunu getirdi; hizmetin herhangi bir işi için yanında akasya ağacı bulunan herkes onu getirdi. ");
INSERT INTO turytc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bilge yürekli kadınların tümü elleriyle eğirdiler ve eğirdikleri mavi, moru, kırmızıyı ve ince keteni getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Yürekleri bilgelikle harekete geçen kadınların tümü keçi kılı eğirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Önderler efod ve göğüslük için oniks taşlarını ve kakma taşlarını; ");
INSERT INTO turytc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ışık için, mesh yağı için ve hoş kokulu buhur için baharatı ve yağı getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Yahve'nin Moşe tarafından yapılmasını buyurduğu tüm işler için yürekleri kendilerini istekli kılan her erkek ve kadın, İsrael'in çocukları, Yahve'ye gönüllü sunu getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moşe İsrael'in çocuklarına şöyle dedi: “İşte, Yahve Yahuda oymağından Hur oğlu Uri oğlu Bezalel'i adıyla çağırdı. ");
INSERT INTO turytc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Bilgelikte, anlayışta, bilgide ve her türlü ustalıkta; ");
INSERT INTO turytc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","altın, gümüş ve tunç işlerken marifetli işler yapmak, ");
INSERT INTO turytc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","taş kesmede ve kakmada, ağaç oymacılığında, her türlü ustalık gerektiren işçilikte çalışmak üzere, Tanrı onu kendi ruhuyla doldurdu. ");
INSERT INTO turytc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hem kendisinin hem de Dan oymağından Ahisamak oğlu Oholiav'ın öğretmesini onun yüreğine koydu. ");
INSERT INTO turytc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ve O, oymacılıkta, ustalık işlerinde, mavide, morda, kırmızıda, ince ketende dokuma ve nakış işlerinde, her türlü ustalık işini yapabilmeleri için onları yürek bilgeliğiyle doldurdu, ta ki, herhangi bir işi yapan ustaca işler yapanlardan olsunlar. ");
INSERT INTO turytc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Besalel ile Oholiav, kutsal yerin hizmetiyle ilgili bütün işi Yahve'nin buyurduğu her şeye göre nasıl yapacaklarını bilmek için Yahve'nin bilgelik ve anlayış verdiği her bilge yürekli adamla birlikte çalışacaklardır.” ");
INSERT INTO turytc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moşe, Besalel'i ve Oholiav'ı, Yahve'nin yüreğine bilgelik koyduğu tüm bilge yürekli adamları, bu işe gelme konusunda yüreği harekete geçen herkesi çağırdı. ");
INSERT INTO turytc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","İsrael'in çocukları kutsal yerin hizmeti için getirdikleri tüm sunuları Moşe'den aldılar. Her sabah ona gönüllü sunuları getirmeye devam ettiler. ");
INSERT INTO turytc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kutsal yerin bütün işlerini yapan bilgelerin hepsi yapmakta olduğu kendi işinden geldi. ");
INSERT INTO turytc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Moşe'ye şöyle dediler: “Halk, Yahve'nin yapın diye buyurduğu iş için gereğinden çok daha fazlasını getirdi.” ");
INSERT INTO turytc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moşe bir buyruk verdi ve bunu ordugâhın her yerinde ilan ederek şöyle dediler: “Ne erkek ne de kadın kutsal yer için sunu olarak başka bir şey yapmasın.” Böylece halkın getirmesi engellendi. ");
INSERT INTO turytc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Çünkü sahip oldukları malzeme bütün işi yapmaya yeter ve fazlasıyla artardı bile. ");
INSERT INTO turytc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","İşi yapanların arasındaki bilge yürekli kişilerin tümü, konutu mavi, mor ve kırmızı renkte, özenle dokunmuş ince ketenden on perdeyle yaptı. Bunları usta işi Keruvlar'la yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Her perdenin uzunluğu yirmi sekiz arşın, her perdenin eni dört arşındı. Bütün perdelerin ölçüsü birdi. ");
INSERT INTO turytc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Beş perdeyi birbirine, diğer beş perdeyi de birbirine bağladı. ");
INSERT INTO turytc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Takımın kenarından perdelerden birinin kenarına mavi ilmekler yaptı. İkinci takımda perdenin en dıştaki kenarına da aynısını yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Bir perdede elli ilmek yaptı, ikinci takımdaki perdenin kenarında da elli ilmek yaptı. İlmekler birbirine karşıydılar. ");
INSERT INTO turytc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Elli altın kopça yaptı ve perdeleri kopçalarla birbirine bağladı; böylece çadır bir bütün oldu. ");
INSERT INTO turytc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Konutun üzerini örtmek için keçi kılından perdeler yaptı. Onlar için on bir perde yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Her perdenin uzunluğu otuz arşın, eni dört arşındı. On bir perdenin ölçüsü birdi. ");
INSERT INTO turytc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Beş perdeyi birbirine, altı perdeyi de birbirine bağladı. ");
INSERT INTO turytc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Bir takım perdenin en dıştaki kenarına elli ilmek yaptı, ikinci takımdaki perdenin en dıştaki kenarına da elli ilmek yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Çadırın tek bir bütün olabilmesi için elli tunç kopça yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Çadır için kırmızı boyalı koç derilerinden bir örtü, üstüne de deniz ayısı derilerinden bir örtü yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Konutun çerçevelerini akasya ağacından dikine yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Bir çerçevenin uzunluğu on arşın, her bir çerçevenin eni bir buçuk arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Her çerçevenin birbirine bağlı iki kolu vardı. Konutun bütün çerçevelerini bu şekilde yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Konut için çerçeveleri güneye bakan güney tarafı için yirmi çerçeve yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Yirmi çerçevenin altına kırk gümüş taban; bir çerçevenin altında iki kol için iki taban, başka bir çerçevenin altında iki kol için iki taban yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Konutun kuzey tarafındaki ikinci tarafı için yirmi çerçeve, ");
INSERT INTO turytc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","bir çerçevenin altında iki taban, diğer bir çerçevenin altında iki taban olmak üzere onların kırk gümüş tabanını yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Konutun batı tarafındaki uzak kısmı için altı çerçeve yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Konutun uzak tarafındaki köşeleri için iki çerçeve yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Altları iki kattı ve aynı şekilde tepeden tek bir halkaya kadar uzanıyorlardı. Bunu iki köşede ikisine de yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Sekiz çerçeve, her çerçevenin altında iki taban olmak üzere onların on altı gümüş tabanı vardı. ");
INSERT INTO turytc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Akasya ağacından konutun bir tarafındaki çerçeveler için beş kiriş, ");
INSERT INTO turytc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","konutun diğer tarafındaki çerçeveler için de beş kiriş, batıya bakan arka kısmı için de çadırın çerçeveleri için beş kiriş yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ortadaki kirişi çerçevelerin ortasından bir uçtan diğer uca geçecek şekilde yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Çerçeveleri altınla kapladı, kirişlerin yeri olarak onların halkalarını altın yaptı, kirişleri de altınla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Perdeyi mavi, mor, kırmızı ve özenle dokunmuş ince ketenden Keruvlar'la yaptı. Bunu usta işi bir işçilikle yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Bunun için akasya ağacından dört direk yaptı ve onları altınla kapladı. Çengelleri altındandı. Onlar için dört gümüş taban döktü. ");
INSERT INTO turytc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Çadırın kapısına mavi, mor, kırmızı ve özenle dokunmuş ince ketenden nakış işi bir perde; ");
INSERT INTO turytc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ve onun çengelleriyle birlikte beş direği yaptı. Başlıklarını ve çemberlerini altınla kapladı ve beş tabanı da tunçtandı. ");
INSERT INTO turytc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel sandığı akasya ağacından yaptı. Uzunluğu iki buçuk arşın, eni bir buçuk arşın ve yüksekliği bir buçuk arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Onun içini ve dışını saf altınla kapladı, çevresine de altın pervaz yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Onun dört ayağına, bir yanına iki halka, öbür yanına iki halka olmak üzere dört altın halka döktü. ");
INSERT INTO turytc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Akasya ağacından sırıklar yapıp onları altınla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Sandığı taşımak için sırıkları sandığın yanlarındaki halkalara yerleştirdi. ");
INSERT INTO turytc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Saf altından bir Merhamet Örtüsü yaptı. Uzunluğu iki buçuk arşın ve eni bir buçuk arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Altından iki Keruv yaptı. Onları Merhamet Örtüsü'nün iki ucunda dövmeci işi olarak, ");
INSERT INTO turytc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","bir uçta bir Keruv, diğer uçta bir Keruv olmak üzere yaptı. Keruvlar'ı iki ucunda Merhamet Örtüsü olacak şekilde tek parça yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Keruvlar kanatları yukarıya doğru açık, yüzleri birbirine dönük şekilde Merhamet Örtüsü'nü kanatlarıyla örtüyorlardı. Keruvlar'ın yüzleri Merhamet Örtüsü'ne doğruydu. ");
INSERT INTO turytc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Masayı akasya ağacından yaptı. Uzunluğu iki arşın, eni bir arşın ve yüksekliği bir buçuk arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Onu saf altınla kapladı ve çevresine altın pervaz yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Çevresine bir karış genişliğinde bir kenar, onun çevresine de altın pervaz yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Onun için dört altın halka döktü ve halkaları dört ayağı üzerinde olan dört köşesine yerleştirdi. ");
INSERT INTO turytc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Halkalar kenara, sırıkların masayı taşıyacağı yerlere yakındı. ");
INSERT INTO turytc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Masayı taşımak için sırıkları akasya ağacından yaptı ve altınla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Masanın üzerindeki kapları, tabakları, kaşıkları, tasları, dökmelik sunu testileri saf altından yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Şamdanı saf altından yaptı. Onu dövmeci işi olarak yaptı. Tabanı, gövdesi, çanakları, tomurcukları ve çiçekleri ondan tek parçaydı. ");
INSERT INTO turytc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Bir yanından üç kol, diğer yanından üç kol olmak üzere şamdanın yanlarından altı kol çıkıyordu; ");
INSERT INTO turytc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","bir kolda badem çiçeğine benzer üç çanak, bir tomurcuk, bir çiçek ve diğer kolda ise badem çiçeği şekline benzer üç çanak, bir tomurcuk, bir çiçek vardı; şamdandan çıkan altı kol böyleydi. ");
INSERT INTO turytc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Şamdanda badem çiçeğine benzer dört çanak, tomurcukları ve çiçekleri vardı; ");
INSERT INTO turytc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ve ondan çıkan altı kol için, iki kol altında kendisinden bir tomurcuk, iki kol altında kendisinden bir tomurcuk ve iki kol altında kendisinden bir tomurcuk vardı. ");
INSERT INTO turytc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tomurcukları ve kolları ondan tek parçaydı. Hepsi saf altından bir dövmeci işiydi. ");
INSERT INTO turytc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Onun yedi kandilini, maşalarını ve tablalarını saf altından yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Bütün takımlarıyla birlikte onu bir talant saf altından yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Buhur sunağını akasya ağacından yaptı. Kare şeklindeydi; uzunluğu bir arşın ve eni bir arşındı. Yüksekliği iki arşındı. Boynuzları da onunla tek parçaydı. ");
INSERT INTO turytc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Üstünü, yanlarını ve boynuzlarını saf altınla kapladı. Çevresine altın pervaz yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Onu taşımak için sırık yeri olarak, pervazın altına, iki yanları üzerine ve iki tarafına iki altın halka yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Sırıkları akasya ağacından yaptı ve altınla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Attar işine uygun olarak kutsal mesh yağını ve hoş baharatlardan oluşan saf buhuru yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Yakmalık sunu sunağını akasya ağacından yaptı. Kare şeklindeydi. Uzunluğu beş arşın, eni beş arşın ve yüksekliği üç arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Boynuzlarını dört köşesi üzerine yaptı. Boynuzları onunla tek parçaydı ve onu tunçla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Sunağın bütün takımlarını, kovaları, kürekleri, çanakları, çatalları ve ateş kaplarını yaptı. Bütün kaplarını tunçtan yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Sunak için, etrafındaki çıkıntının altına yarıya kadar uzanan tunç ağ şeklinde bir ızgara yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Sırıkların yeri olarak tunç ızgaranın dört köşesine dört halka döktü. ");
INSERT INTO turytc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Sırıkları akasya ağacından yaptı ve onları tunçla kapladı. ");
INSERT INTO turytc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Sırıkları sunağın yanlarındaki halkalara taktı, onu taşımak için kullandı. Onu tahtadan içi boş yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Buluşma Çadırı'nın kapısında hizmet eden hizmetkâr kadınların aynalarından kazanı ve ayağını tunçtan yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Avluyu yaptı; güney tarafı için avlunun perdeleri güneye doğru yüz arşın boyunda özenle dokunmuş ince ketendendi; ");
INSERT INTO turytc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","yirmi direği ve yirmi tabanı tunçtandı; direklerin çengelleri ve çemberleri gümüştendi. ");
INSERT INTO turytc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kuzey tarafı için yüz arşındı, direkleri yirmi ve tabanları yirmi tunçtandı; direklerin çengelleri ve çemberleri gümüştendi. ");
INSERT INTO turytc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Batı tarafında elli arşınlık perdeler, on direk ve on taban vardı; direklerin çengelleri ve çemberleri gümüştendi. ");
INSERT INTO turytc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Doğu tarafı için doğuya doğru elli arşındı, ");
INSERT INTO turytc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","bir tarafın perdeleri on beş arşındı; direkleri üç, tabanları üç; ");
INSERT INTO turytc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ve diğer tarafta da böyleydi; bu tarafta ve avlu kapısının yanında on beş arşınlık perdeler vardı; direkleri üç, tabanları da üçtü. ");
INSERT INTO turytc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Avlunun etrafındaki perdelerin tümü özenle dokunmuş ince ketendendi. ");
INSERT INTO turytc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Direklerin tabanları tunçtandı. Direklerin çengelleri ve çemberleri gümüştendi. Başlıkları gümüşle kaplanmıştı. Avlunun tüm direklerinde gümüş şeritler vardı. ");
INSERT INTO turytc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Avlu kapısının perdesi mavi, mor, kırmızı ve özenle dokunmuş ketenden nakışçı işiydi. Avlu perdeleri gibi uzunluğu yirmi arşın, eninde yüksekliği ise beş arşındı. ");
INSERT INTO turytc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Direkleri dört, tabanları dört tunçtandı; çengelleri gümüşten, başlıklarının kaplamaları ve çemberleri gümüştendi. ");
INSERT INTO turytc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Konutun ve avlunun çevresindeki tüm kazıklar tunçtandı. ");
INSERT INTO turytc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Antlaşma Çadırı'nda kullanılan malzemelerin miktarları bunlardı; Moşe'nin buyruğu uyarınca Levililer'in hizmeti için kâhin Aron oğlu İtamar'ın eliyle sayıldı. ");
INSERT INTO turytc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yahuda oymağından Hur oğlu Uri oğlu Besalel, Yahve'nin Moşe'ye buyurduğu her şeyi yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Dan oymağından Ahisamak oğlu, oymacı, usta bir işçi ve mavi, mor, kırmızı ve ince keten kumaşlarda nakışçı olan Oholiav onunla birlikteydi. ");
INSERT INTO turytc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Kutsal yerin bütün işlerinde kullanılan altının tamamı, sunu altınıyla birlikte kutsal yerin şekeline göre yirmi dokuz talant ve yedi yüz otuz şekeldi. ");
INSERT INTO turytc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Topluluktan sayılanların gümüşü, kutsal yerin şekeline göre yüz talant ve bin yedi yüz yetmiş beş şekeldi; ");
INSERT INTO turytc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","yirmi yaşında ve yukarı olan altı yüz üç bin beş yüz elli kişi için, sayılanlar tarafına geçen herkes için, nüfus başına bir beka, yani kutsal yerin şekeline göre yarım şekeldi. ");
INSERT INTO turytc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Yüz talant gümüş, kutsal yerin ve perdenin tabanlarının dökümü içindi; yüz talant için yüz taban, taban başına bir talanttı. ");
INSERT INTO turytc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bin yedi yüz yetmiş beş şekelden direkler için çengeller yaptı, direk başlıklarını kapladı ve onlara çemberler yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sununun tuncu yetmiş talant ve iki bin dört yüz şekeldi. ");
INSERT INTO turytc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bununla Buluşma Çadırı'nın kapısının tabanlarını, tunç sunağı, onun için olan tunç ızgarayı, sunağın tüm takımlarını, ");
INSERT INTO turytc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","avlunun çevresindeki tabanları, avlu kapısının tabanlarını, konutun tüm kazıklarını, avlunun çevresindeki tüm kazıkları yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kutsal yerde hizmet etmek için mavi, mor ve kırmızı renklerden özenle dokunmuş giysiler yaptılar; Yahve'nin Moşe'ye buyurduğu gibi Aron için de kutsal giysiler yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Efodu altın, mavi, mor, kırmızı ve özenle dokunmuş ince ketenden yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Altını dövüp ince levhalar haline getirdiler ve ustalık işçiliği ile mavi, mor, kırmızı ve ince keten arasına işlemek için onu teller halinde kestiler. ");
INSERT INTO turytc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Onun için birleştirilmiş omuz askıları yaptılar. İki ucundan birleştirilmişti. ");
INSERT INTO turytc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Üzerinde bulunan ve onu tutturmak için kullanılan ustaca dokunmuş şerit de tıpkı onun işi gibi aynı parçadandı, altından, mavi, mor, kırmızı ve özenle dokunmuş ince ketendendi; Yahve'nin Moşe'ye buyurduğu gibiydi. ");
INSERT INTO turytc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Altın yuvalar içine kakılmış, İsrael'in çocuklarının adlarına göre mühür oymasıyla oyulmuş, oniks taşlarını işlediler. ");
INSERT INTO turytc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Yahve'nin Moşe'ye buyurduğu gibi, İsrael'in çocuklarına anma taşları olsun diye bunları efodun omuz askılarına taktı. ");
INSERT INTO turytc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Efodun işi gibi usta işçiliğiyle göğüslüğü altından, mavi, mor, kırmızı ve özenle dokunmuş ince ketenden yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kare biçimindeydi. Göğüslüğü iki kat yaptılar. İki katı olarak uzunluğu bir karış, eni bir karıştı. ");
INSERT INTO turytc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","İçine dört sıra taş dizdiler. İlk sırada bir sıra yakut, topaz ve zümrüt; ");
INSERT INTO turytc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ikinci sırada firuze, safir ve aytaşı; ");
INSERT INTO turytc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","üçüncü sırada gökyakut, agat ve ametist; ");
INSERT INTO turytc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","dördüncü sırada gökzümrüt, oniks, ve yeşim vardı; yuvalarında altın çerçeveler içine kakılmıştı. ");
INSERT INTO turytc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Taşlar İsrael'in çocuklarının adlarına göre, on iki oymak için her birinin kendi adına göre, mühür oymaları gibi adlarına göre, on ikiydi. ");
INSERT INTO turytc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Göğüslük üzerine saf altından örmeci işi kordona benzer zincirler yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","İki altın yuva ve iki altın halka yapıp iki halkayı göğüslüğün iki ucuna taktılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","İki örme altın zinciri göğüslüğün uçlarındaki iki halkaya taktılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","İki örme zincirin diğer iki ucunu iki yuva üzerine geçirip efodun ön tarafındaki omuz askılarına taktılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","İki altın halka yapıp bunları göğüslüğün iki ucuna, efodun iç tarafına doğru olan kenarına taktılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","İki altın halka daha yapıp efodun iki omuz askısına, efodun ustaca dokunmuş şeridinin üstüne, ön kısmına, birleştiği yerin yakınına taktılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Yahve'nin Moşe'ye buyurduğu gibi, efodun ustaca dokunmuş şeridi üzerinde olsun ve göğüslük efodtan ayrılmasın diye, göğüslüğü halkalarıyla efodun halkalarına mavi bir kordonla bağladılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Efodun kaftanını tamamen mavi dokuma kumaştan yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kaftanının ortasındaki boşluk, bir zırhın boşluğuna benziyordu; boşluğun çevresinde yırtılmaması için bir bağ vardı. ");
INSERT INTO turytc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kaftanın etekleri üzerine mavi, mor, kırmızı ve özenle dokunmuş ketenden narlar yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Saf altından çıngıraklar yaptılar ve çıngırakları kaftanın etekleri üzerine çepeçevre narların arasına, narların ara yerlerine; ");
INSERT INTO turytc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Yahve'nin Moşe'ye buyurduğu gibi hizmet etmek için kaftan eteklerinin etrafına bir çıngırak ve bir nar, bir çıngırak ve bir nar şeklinde yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aron'la oğulları için ince ketenden dokunmuş gömlekler, ");
INSERT INTO turytc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ince ketenden sarık, ince ketenden süslü başlıkları, özenle dokunmuş ince ketenden keten donlar, ");
INSERT INTO turytc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","özenle dokunmuş ince ketenden mavi, mor, ve kırmızı nakışçı işi kuşaklar, Yahve'nin Moşe'ye buyurmuş olduğu gibi yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Kutsal tacın levhasını saf altından yaptılar ve üzerine mühür oymaları gibi “YAHVE'YE KUTSAL” yazısını yazdılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yahve'nin Moşe'ye buyurduğu gibi, yukarıdaki sarığın üzerine bağlamak için ona mavi bir kordon bağladılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Böylece Buluşma Çadırı'nın konutuyla ilgili tüm işler tamamlandı. İsrael'in çocukları Yahve'nin Moşe'ye buyurduğu her şeye göre yaptılar; onlar da öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Konutu, Çadırı, onun bütün takımlarını, kopçalarını, çerçevelerini, kirişlerini, direklerini, tabanlarını, ");
INSERT INTO turytc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kırmızı boyalı koç derilerinden örtüyü, deniz ayısı derilerinden örtüyü, bölme perdesini, ");
INSERT INTO turytc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sırıklarıyla birlikte Antlaşma Sandığı'nı, Merhamet Örtüsü'nü, ");
INSERT INTO turytc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","masayı, bütün takımlarını, huzur ekmeğini, ");
INSERT INTO turytc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","saf şamdanı, kandillerini, dizilecek kandillerini, bütün takımlarını, ışık için yağı, ");
INSERT INTO turytc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","altın sunağı, mesh yağını, hoş kokulu buhuru, Çadır kapısının perdesini, ");
INSERT INTO turytc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","tunç sunağı, onun tunç ızgarasını, sırıklarını, bütün takımlarını, kazanı ve onun ayağını, ");
INSERT INTO turytc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","avlu perdelerini, direklerini, tabanlarını, avlu kapısının perdesini, iplerini, kazıklarını ve Buluşma Çadırı için çadırın hizmetinde kullanılan bütün aletleri, ");
INSERT INTO turytc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","kutsal yerin hizmeti için özenle dokunmuş giysileri, Kâhin Aron'un kutsal giysilerini ve kâhinlik makamında hizmet edecek oğullarının giysilerini Moşe'ye getirdiler. ");
INSERT INTO turytc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","İsrael'in çocukları Yahve'nin Moşe'ye buyurduğu her şeye göre bütün işi öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moşe bütün işi gördü ve işte, Yahve'nin buyurduğu gibi yapmışlardı. Öyle yapmışlardı, Moşe de onları kutsadı. ");
INSERT INTO turytc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Birinci ayın birinci günü Buluşma Çadırı'nın konutunu kuracaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Antlaşma Sandığı'nı içine koyacaksın ve sandığı perdeyle gizleyeceksin. ");
INSERT INTO turytc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Masayı içeri getirip üzerindeki şeyleri dizeceksin. Şamdanı getirip kandillerini yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Buhur için altın sunağı Antlaşma Sandığı'nın önüne koyacaksın ve konutun kapısının perdesini takacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Yakmalık sunu sunağını Buluşma Çadırı'nın konutunun kapısı önüne koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kazanı Buluşma Çadırı ile sunak arasına koyacaksın ve içine su koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Çevresine avluyu kuracak, avlu kapısının perdesini asacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Mesh yağını alacaksın, konutu ve içindekilerin hepsini meshedeceksin, onu ve içindeki tüm takımları kutsal kılacaksın ve kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Yakmalık sunu sunağını tüm takımlarıyla birlikte meshedeceksin ve sunağı kutsal kılacaksın; sunak çok kutsal olacak. ");
INSERT INTO turytc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kazanı ve ayağını meshedecek ve onu kutsayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Aron'la oğullarını Buluşma Çadırı'nın kapısına getirip onları suyla yıkayacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aron'a kutsal giysileri giydireceksin; kâhinlik makamında bana hizmet edebilmesi için onu meshedip kutsal kılacaksın. ");
INSERT INTO turytc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oğullarını getirip üzerlerine gömlekler giydireceksin. ");
INSERT INTO turytc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kâhinlik makamında bana hizmet edebilmeleri için, babalarını meshettiğin gibi onları da meshedeceksin. Meshedilmeleri onlara kuşakları boyunca sonsuz bir kâhinlik için olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moşe öyle yaptı. Yahve'nin kendisine buyurduğu her şeye göre, öyle yaptı. ");
INSERT INTO turytc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","İkinci yılın birinci ayının birinci gününde konut ayağa kaldırıldı. ");
INSERT INTO turytc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moşe konutu kaldırdı, tabanlarını koydu, çerçevelerini yerleştirdi, kirişlerini taktı ve direklerini dikti. ");
INSERT INTO turytc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Yahve'nin Moşe'ye buyurduğu gibi örtüyü çadırın üzerine serdi, konutun örtüsünü üst taraftan onun üstüne koydu. ");
INSERT INTO turytc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Antlaşmayı alıp sandığın içine koydu, sırıkları sandığa taktı ve Merhamet Örtüsü'nü üst taraftan sandığın üstüne koydu. ");
INSERT INTO turytc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Yahve'nin Moşe'ye buyurduğu gibi sandığı konutun içine getirdi, bölme perdesini taktı ve Antlaşma Sandığı'nı gizledi. ");
INSERT INTO turytc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Masayı Buluşma Çadırı'na, konutun kuzey tarafına, perdenin dışına koydu. ");
INSERT INTO turytc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Yahve'nin Moşe'ye buyurduğu gibi ekmeği onun üzerine Yahve'nin önünde dizdi. ");
INSERT INTO turytc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Şamdanı Buluşma Çadırı'nın içine, konutun güneyine, masanın karşısına koydu. ");
INSERT INTO turytc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Yahve'nin Moşe'ye buyurduğu gibi, Yahve'nin önünde kandilleri yaktı. ");
INSERT INTO turytc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Altın sunağı Buluşma Çadırı'nın içindeki perdenin önüne koydu; ");
INSERT INTO turytc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Yahve'nin Moşe'ye buyurduğu gibi, onun üzerinde hoş kokulu buhur yaktı. ");
INSERT INTO turytc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Konutun kapısının perdesini taktı. ");
INSERT INTO turytc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Yakmalık sunu sunağını Buluşma Çadırı'nın kapısına koydu ve Yahve'nin Moşe'ye buyurduğu gibi yakmalık sunu ve ekmek sunusunu onun üzerinde sundu. ");
INSERT INTO turytc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Kazanı Buluşma Çadırı ile sunak arasına koydu ve içine yıkanmak üzere su koydu. ");
INSERT INTO turytc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moşe, Aron ve oğulları ellerini ve ayaklarını orada yıkadılar. ");
INSERT INTO turytc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Buluşma Çadırı'na girip sunağa yaklaştıklarında Yahve'nin Moşe'ye buyurduğu gibi yıkanırlardı. ");
INSERT INTO turytc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Avluyu konutun ve sunağın çevresinde yükseltti, avlu kapısının perdesini taktı. Böylece Moşe işi bitirdi. ");
INSERT INTO turytc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Sonra bulut Buluşma Çadırı'nı kapladı ve Yahve'nin görkemi konutu doldurdu. ");
INSERT INTO turytc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moşe Buluşma Çadırı'na giremedi; çünkü bulut onun üzerinde duruyordu ve Yahve'nin görkemi çadırı doldurmuştu. ");
INSERT INTO turytc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","İsrael'in çocukları bütün yolculuklarını, bulut konutun üzerinden kalkınca sürdürürlerdi; ");
INSERT INTO turytc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ama eğer bulut kalkmazsa, kalkacağı güne dek yola çıkmazlardı. ");
INSERT INTO turytc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Çünkü bütün yolculukları boyunca, bütün İsrael evinin gözü önünde, Yahve'nin bulutu gündüzleri konutun üzerindeydi, geceleri de bulutta ateş vardı. ");
INSERT INTO turytc_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yahve Moşe'yi çağırdı ve Buluşma Çadırı'ndan onunla konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Sizden biri Yahve'ye bir sunu sunduğu zaman, hayvanlardan, sığır ve davardan sunacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“'Eğer sunusu sığırdan yakmalık sunu ise, kusursuz erkek sunacak. Yahve'nin önünde kabul edilsin diye onu Buluşma Çadırı'nın kapısında sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Elini yakmalık sununun başına koyacak ve kendisi için kefaret etmek üzere kabul olunacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Boğayı Yahve'nin önünde kesecek. Aron'un oğulları kâhinler kanı sunacaklar ve kanı Buluşma Çadırı'nın kapısındaki sunağın üzerine çepeçevre serpecekler. ");
INSERT INTO turytc_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Yakmalık sunuların derisini yüzecek ve onu parçalar halinde kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kâhin Aron'un oğulları sunak üzerine ateş koyacaklar ve ateşin üzerine odunlar dizecekler; ");
INSERT INTO turytc_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Aron'un oğulları kâhinler parçaları, başı ve yağı sunaktaki ateşin üzerindeki odunların üzerine dizecekler; ");
INSERT INTO turytc_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ama onun içini ve bacaklarını suyla yıkayacak. Kâhin, yakmalık sunu olarak, ateşle yapılan sunu olarak, Yahve'ye hoş koku olarak, bunların hepsini sunak üzerinde yakacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“'Yakmalık sunu olarak sunusu davardan, koyunlardan ya da keçilerdense, kusursuz erkek sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Onu Yahve'nin önünde sunağın kuzey tarafında kesecek. Aron'un oğulları, kâhinler, onun kanını sunağın üzerine çepeçevre serpecekler. ");
INSERT INTO turytc_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Onu başı ve yağıyla birlikte parçalar halinde kesecek. Kâhin bunları sunaktaki ateşin üzerindeki odunların üzerine dizecek, ");
INSERT INTO turytc_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ama iç organlarını ve bacaklarını suyla yıkayacak. Kâhin hepsini sunacak ve sunak üzerinde yakacaktır. Bu yakılan bir sunudur, ateşle yapılan, Yahve'ye hoş kokudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“'Eğer Yahve'ye yakmalık sunu kuşlardansa, sunusunu kumrulardan ya da güvercin yavrularından sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kâhin onu sunağa getirecek, başını ayırıp sunak üzerinde yakacak; kanı sunağın yan tarafında akıtılacak; ");
INSERT INTO turytc_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","onun kursağını ve tüylerini alıp sunağın yanına, doğu tarafına, küllerin yerine atacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Onu kanatlarından ayıracak ama bölmeyecektir. Kâhin onu sunakta, yanan odunların üzerinde yakacaktır. Bu yakılan bir sunudur, ateşle yapılan, Yahve'ye hoş kokudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“'Birisi Yahve'ye ekmek sunusu sunduğu zaman, sunusu ince undan olacak. Üzerine yağ dökecek ve üzerine günnük koyacak. ");
INSERT INTO turytc_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Onu Aron'un oğullarına, kâhinlere getirecek. Onun ince unundan ve yağından, bütün günnüğüyle birlikte bir avuç alacak ve kâhin, onun anılması olarak onu sunak üzerinde yakacaktır; o ateşle yapılan bir sunu, Yahve'ye hoş kokudur. ");
INSERT INTO turytc_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ekmek sunusundan arta kalan Aron'un ve oğullarının olacak. Yahve'ye ateşle yapılan sunuların en kutsal kısmıdır.'” ");
INSERT INTO turytc_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“'Fırında pişmiş ekmek sunusu sunduğun zaman, ince undan yağla yoğrulmuş mayasız pideler, ya da üzerine yağ sürülmüş mayasız yufkalar olacak. ");
INSERT INTO turytc_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Eğer sununuz tavada pişirilen bir ekmek sunusu ise, yağla yoğrulmuş mayasız ince undan olacak. ");
INSERT INTO turytc_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Onu parçalara ayırıp üzerine yağ dökeceksin. Bu bir ekmek sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Eğer sunun tavada sunulan bir ekmek sunusu ise, ince undan ve zeytinyağıyla yapılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bunlardan yapılan ekmek sunusunu Yahve'ye getireceksin. Kâhine verilecek, o da onu sunağa getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kâhin, anma sunusu olarak ekmek sunusundan alacak ve onu, ateşle yapılan, Yahve'ye hoş koku olarak sunak üzerinde yakacak. ");
INSERT INTO turytc_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ekmek sunusundan arta kalan Aron'la oğullarının olacak. Yahve'ye ateşle yapılan sunuların en kutsal kısmıdır.'” ");
INSERT INTO turytc_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“'Yahve'ye sunacağınız hiçbir ekmek sunusu mayayla yapılmayacaktır; çünkü Yahve'ye ateşle yapılan sunu olarak ne maya ne de bal yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","İlk ürünleri sunu olarak Yahve'ye sunacaksınız, ama sunakta hoş koku olarak yükselmeyecekler. ");
INSERT INTO turytc_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ekmek sununuzun her sunusunu tuzlayacaksınız. Tanrın'la yaptığın antlaşmanın tuzunun ekmek sunusundan eksik etmeyeceksin. Bütün sunularınızla tuz sunacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“'Eğer Yahve'ye ilk ürünlerden ekmek sunusu sunuyorsan, ilk ürünlerinin ekmek sunusu olarak ateşte kavrulmuş ve ezilmiş taze buğday başakları sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Üzerine yağ döküp günnük koyacaksın. Bu bir ekmek sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kâhin onun için anılma olarak, ezilmiş tahılla yağının bir kısmını ve bütün günnüğüyle birlikte yakacak. Bu, Yahve'ye ateşle yapılan bir sunudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“'Eğer sunusu esenlik kurbanı ise, bunu erkek olsun, dişi olsun, sığırdan sunuyorsa, onu Yahve'nin önünde kusursuz olarak sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Elini sunusunun başına koyacak ve onu Buluşma Çadırı'nın kapısında kesecek. Aron'un oğulları, kâhinler, kanı sunağın üzerine çepeçevre serpecekler. ");
INSERT INTO turytc_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Yahve'ye esenlik kurbanından ateşle yapılan bir sunu sunacak. İçini kaplayan yağı, iç kısımdaki yağın tamamını, ");
INSERT INTO turytc_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","iki böbreği, onların üzerinde belin yanında olan yağı, böbreklerle birlikte karaciğerin zarını da ayıracak. ");
INSERT INTO turytc_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aron'un oğulları onu sunakta, ateşteki odunların üzerindeki yakmalık sunu üzerinde yakacaklar; bu, ateşle yapılan, Yahve'ye hoş kokulu bir sunudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“'Eğer Yahve'ye esenlik kurbanı olarak sunusu erkek ya da dişi davardan ise, onu kusursuz olarak sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Eğer sunu olarak bir kuzu sunarsa, onu Yahve'nin önünde sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Elini sunusunun başına koyacak ve onu Buluşma Çadırı'nın önünde kesecek. Aron'un oğulları onun kanını sunağın üzerine çepeçevre serpecekler. ");
INSERT INTO turytc_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Esenlik kurbanından Yahve'ye ateşle yapılan bir sunu sunacak; yağının tamamını, kuyruk yağının tamamını kuyruk sokumu yakınından ayıracak; içleri kaplayan yağı, içinin üzerindeki yağın tamamını, ");
INSERT INTO turytc_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","iki böbreği, onların üzerinde, belin yanında olan yağı, böbreklerle birlikte karaciğerin üzerindeki zarı ayıracak. ");
INSERT INTO turytc_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kâhin onu sunak üzerinde yakacak; bu, Yahve'ye ateşle yapılan yiyecek sunusudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“'Eğer sunusu keçi ise, onu Yahve'nin önünde sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Elini onun başına koyacak ve onu Buluşma Çadırı'nın önünde kesecek; Aron'un oğulları onun kanını sunağın üzerine çepeçevre serpecekler. ");
INSERT INTO turytc_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","O ondan Yahve'ye ateşle yapılan bir sunu olarak sunacak; içini kaplayan yağı ve iç kısımdaki tüm yağları, ");
INSERT INTO turytc_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","iki böbreği ve onların üzerinde belin yanında olan yağı ve böbreklerle birlikte karaciğerin zarını ayıracak. ");
INSERT INTO turytc_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kâhin onları sunakta yakacak; hoş koku olarak ateşle yapılan sunu yemeğidir bu; tüm yağlar Yahve'nindir.'” ");
INSERT INTO turytc_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“'Ne yağ ne de kan yememeniz, bütün konutlarınızda kuşaklarınız boyunca kalıcı bir kural olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“İsrael'in çocuklarına de ki: 'Bir kimse Yahve'nin yapılmamasını buyurduğu şeylerden birinde bilmeden günah işlerse ve bunlardan herhangi birini yaparsa, ");
INSERT INTO turytc_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","eğer meshedilmiş kâhin günah işleyip halkın üzerine suç getirirse, işlediği günahın karşılığında, günah sunusu olarak Yahve'ye kusursuz bir genç boğa sunsun. ");
INSERT INTO turytc_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Boğayı Buluşma Çadırı'nın kapısına, Yahve'nin önüne getirecek; elini boğanın başına koyacak ve boğayı Yahve'nin önünde kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Meshedilmiş kâhin boğanın kanından biraz alıp Buluşma Çadırı'na getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kâhin parmağını kana batıracak ve Yahve'nin önünde, kutsal yerin perdesi önünde kanın bir kısmını yedi kez serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kâhin kanın bir kısmını Yahve'nin önünde, Buluşma Çadırı'nda bulunan hoş kokulu buhur sunağının boynuzlarına sürecek; boğanın kanının geri kalanını Buluşma Çadırı'nın kapısındaki yakmalık sunu sunağının dibine dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Günah sunusu olan boğanın tüm yağını, içini kaplayan yağı, iç kısımlarındaki bütün yağı, ");
INSERT INTO turytc_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","iki böbreği, onların üzerinde belin yanında olan yağı, böbrekleriyle birlikte karaciğerinin üzerindeki zarı, ");
INSERT INTO turytc_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","esenlik kurbanının boğadan alındığı gibi ayıracak. Kâhin onları yakmalık sunu sunağında yakacak. ");
INSERT INTO turytc_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Boğanın derisini, bütün etini, başıyla, bacaklarıyla, iç kısmını, gübresiyle birlikte ");
INSERT INTO turytc_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","boğanın geri kalan kısmını ordugâhın dışına, küllerin döküldüğü temiz bir yere taşıyacak, onu odunların üzerinde ateşle yakacaktır. Küllerinin döküldüğü yerde yakılacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“'Tüm İsrael topluluğu günah işlerse ve bu durum topluluğun gözünden kaçarsa ve onlar Yahve'nin yapılmamasını buyurduğu şeylerden herhangi birini yaparlar ve suçlu olurlarsa; ");
INSERT INTO turytc_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","işledikleri günah bilindiği zaman topluluk günah sunusu olarak bir boğa sunacak ve onu Buluşma Çadırı'nın önüne getirecekler. ");
INSERT INTO turytc_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Topluluğun ihtiyarları Yahve'nin önünde ellerini boğanın başına koyacaklar; boğa Yahve'nin önünde kesilecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Meshedilmiş kâhin boğanın kanının bir kısmını Buluşma Çadırı'na getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kâhin parmağını kana batıracak ve onu Yahve'nin önünde, perdenin önünde yedi kez serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Yahve'nin önünde, Buluşma Çadırı'nda bulunan sunağın boynuzlarına kanın bir kısmını sürecek; kanın geri kalanını Buluşma Çadırı'nın kapısındaki yakmalık sunu sunağının dibine dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Bütün yağını ondan alıp sunak üzerinde yakacak. ");
INSERT INTO turytc_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Bunu boğayla yapacak; günah sunusu olan boğaya ne yaptıysa, bunu da öyle yapacak; kâhin onlar için kefaret edecek ve bağışlanacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Boğayı ordugâhın dışına taşıyacak ve ilk boğayı yaktığı gibi onu da yakacak. Bu, topluluk için günah sunusudur.'” ");
INSERT INTO turytc_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“'Önderlerden biri günah işleyip Tanrısı Yahve'nin yapılmamasını buyurduğu şeylerden herhangi birini bilmeden yapar ve suçlu olursa, ");
INSERT INTO turytc_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","işlediği günah kendisine bildirilirse, sunu olarak kusursuz bir erkek keçi getirecektir. ");
INSERT INTO turytc_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Elini tekenin başına koyacak ve onu Yahve'nin önünde yakmalık sunuların kesildiği yerde kesecek. Bu bir günah sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kâhin günah sunusu kanının bir kısmını parmağıyla alıp yakmalık sunu sunağının boynuzlarına sürecek. Kanının geri kalanını yakmalık sunu sunağının dibine dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Esenlik kurbanının yağı gibi, yağının tamamını sunakta yakacak; kâhin onun günahına kefaret edecek, o da bağışlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“'Eğer halktan biri Yahve'nin yapılmamasını buyurduğu şeylerden herhangi birini yaparak bilmeden günah işlerse ve suçlu olursa, ");
INSERT INTO turytc_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","eğer işlediği günah kendisine bildirilirse, o zaman işlediği günaha karşılık kusursuz bir dişi keçi getirecektir. ");
INSERT INTO turytc_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Elini günah sunusunun başına koyacak ve günah sunusunu yakmalık sunu yerinde kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kâhin parmağıyla onun kanının bir kısmını alıp yakmalık sunu sunağının boynuzlarına sürecek; kanının geri kalanını sunağın dibine dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Esenlik kurbanının yağının ayrıldığı gibi, o da onun bütün yağını ayıracak; kâhin onu Yahve'ye hoş koku olarak sunakta yakacak; kâhin onun için kefaret edecek, o da bağışlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“'Günah sunusu olarak bir kuzu getirirse, kusursuz bir dişi getirsin. ");
INSERT INTO turytc_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Elini günah sunusunun başına koyacak ve onu yakmalık sununun kesildiği yerde günah sunusu olarak kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kâhin günah sunusunun kanından parmağıyla alacak ve onu yakmalık sunu sunağının boynuzlarının üzerine sürecek; geri kalan kanın tümünü sunağın dibine dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Esenlik kurbanından kuzunun yağı ayrıldığı gibi, o da onun tüm yağını ayıracak. Kâhin onları Yahve'nin ateşle yapılan sunuları gibi sunak üzerinde yakacak. Kâhin, işlediği günahtan dolayı onun için kefaret edecek, o da bağışlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“'Eğer biri şunda günah işlerse; tanıklık etmek üzere bir yemini duyup, bir tanık olarak ister görmüş olsun ister bilsin ve bunu bildirmezse, o zaman suçunu yüklenecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“'Ya da bir kimse kirli bir şeye, kirli bir yabanıl hayvanın leşine, kirli bir evcil hayvanın leşine ya da yerde sürünen kirli şeyin leşine dokunursa, bunun farkına varmazsa, kendisi kirlidir, o zaman suçlu olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Ya da insan kirliliğine dokunursa, onu kirliliğiyle kirleten kirlilik ne olursa olsun ve bunun farkına varmazsa, onu bildiği zaman suçlu olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“'Ya da bir kimse kötülük yapmak ya da iyilik yapmak için dudaklarıyla aceleyle ant içerse—bir insanın aceleyle söylediği her ne olursa olsun ve bunun farkına varmazsa—onu bildiğinde, o zaman bunlardan birinden suçlu olur. ");
INSERT INTO turytc_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Bunlardan birinden suçlu olduğunda, işlediği günahı itiraf edecek; ");
INSERT INTO turytc_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","işlediği günahtan dolayı Yahve'ye suç sunusunu: Günah sunusu olarak sürüden bir dişi, bir kuzu ya da bir keçi getirecek; kâhin onun günahı için kefaret edecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“'Eğer bir kuzu almaya gücü yetmezse, işlediği günaha karşılık suç sunusu olarak, iki kumru ya da iki güvercin yavrusunu Yahve'ye getirecek; biri günah sunusu, diğeri ise yakmalık sunu içindir. ");
INSERT INTO turytc_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Bunları kâhine getirecek; o da günah sunusu olanı ilk sunacak. Başını boynundan ayıracak, ancak onu tamamen ayırmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Günah sunusunun kanından bir kısmını sunağın kenarına serpecek; kanın geri kalanı sunağın dibinde akıtılacak. Bu bir günah sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kural uyarınca ikincisini yakmalık sunu olarak sunacak; kâhin işlediği günahtan dolayı onun için kefaret edecek ve o bağışlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“'Ancak eğer iki kumru ya da iki güvercin yavrusu almaya gücü yetmezse, o zaman işlediği günahın karşılığı günah sunusu olarak efanın onda biri kadar ince un getirecek. Üzerine yağ sürmeyecek ve üzerine günnük koymayacak; çünkü bu bir günah sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Onu kâhine getirecek ve kâhin anma payı olarak ondan bir avuç alacak ve onu Yahve'ye ateşle yapılan sunuların üzerine sunakta yakacak. Bu bir günah sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kâhin bu şeylerden herhangi birinde işlediği günahtan dolayı onun için kefaret edecek ve o bağışlanacaktır; geri kalanı da ekmek sunusu gibi kâhinin olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Eğer biri bir suç işlerse ve Yahve'nin kutsal şeyleri konusunda bilmeden günah işlerse, o zaman suç sunusunu, günah sunusu olmak üzere, kutsal yerin şekeline göre, gümüş şekel olarak, Yahve'ye sürüden kusursuz bir koç getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kutsal şeyle ilgili yaptığı yanlışın bedelini ödeyecek, onun üzerine beşte birini ekleyip kâhine verecek; kâhin suç sunusu olarak sunulan koçla onun için kefaret edecek ve o bağışlanacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Bir kimse, Yahve'nin yapılmamasını buyurduğu şeylerden birini bilmeden yaparak günah işlerse, yine suçludur ve suçunu yüklenecektir. ");
INSERT INTO turytc_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Senin biçtiğin değere göre, suç sunusu olarak sürüden kusursuz bir koçu kâhine getirecek; kâhin bilmeden işlediği günah yüzünden onun için kefaret edecek ve o bağışlanacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Bu bir suç sunusudur. O, Yahve'nin önünde kesin olarak suçludur.” ");
INSERT INTO turytc_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Eğer bir kimse günah işlerse, Yahve'ye karşı suç işlerse, komşusuna emanet, pazarlık ya da hırsızlık konusunda yalan söylerse, ya da komşusuna baskı yaparsa, ");
INSERT INTO turytc_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ya da kaybolan şeyi bulup onun hakkında yalan söylerse ve yalan üzerine ant içerse; bir kişi bu şeylerden herhangi birinde, yaptıklarıyla günah işlerse, ");
INSERT INTO turytc_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","o zaman böyle olacak, eğer kişi günah işlemiş ve suçluysa, çaldığını geri verecek ya da baskı yoluyla elde ettiğini, ya da kendisine emanet edilen emaneti, ya da bulduğu kayıp şeyi, ");
INSERT INTO turytc_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ya da hakkında yalan yere ant içtiği herhangi bir şeyi; onu tam olarak geri verecek ve üzerine beşte birini ekleyecektir. Suçlu bulunduğu gün onu ait olduğu insana geri verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Yahve'ye suç sunusunu, kâhine suç sunusu olarak senin biçtiğin değere göre sürüden kusursuz bir koç getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kâhin onun için Yahve'nin önünde kefaret edecek ve suçlu sayılmış olmak için ne yapmış olursa olsun bağışlanacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Aron'la oğullarına buyurup de: 'Yakmalık sunu yasası şudur: Yakmalık sunu bütün gece sabaha kadar sunaktaki ateşin üzerinde olacak; sunağın ateşi onun üzerinde yanmaya devam edecek. ");
INSERT INTO turytc_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kâhin keten giysisini giyecek, keten donunu da üzerine giyecek; sunaktaki yakmalık sunuların küllerini alıp sunağın yanına koyacak. ");
INSERT INTO turytc_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Giysilerini çıkarıp başka giysiler giyecek ve külleri ordugâhın dışında temiz bir yere taşıyacak. ");
INSERT INTO turytc_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Sunağın üzerindeki ateş yanmaya devam edecek, sönmeyecek; kâhin her sabah onun üzerinde odun yakacak. Yakmalık sunuları onun üzerine dizecek ve esenlik sunularının yağını onun üzerinde yakacak. ");
INSERT INTO turytc_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Sunakta ateş sürekli yanacak; sönmeyecek.'” ");
INSERT INTO turytc_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“'Ekmek sunusuyla ilgili yasa şudur: Aron'un oğulları onu sunağın önünde Yahve'nin önünde sunacaklar. ");
INSERT INTO turytc_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Oradan ekmek sunusu ince unundan ve yağından bir avuç dolusu alacak ve tahıl sunusu üzerindeki tüm günnükleri anma payı, Yahve'ye hoş koku olarak sunakta yakacak. ");
INSERT INTO turytc_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Artakalanı Aron'la oğulları yiyecekler. Kutsal bir yerde mayasız olarak yenecektir. Onu Buluşma Çadırı'nın avlusunda yiyecekler. ");
INSERT INTO turytc_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mayayla pişirilmeyecek. Ateşle yapılan sunularımdan onlara pay olarak bunu verdim. Günah sunusu ve suç sunusu gibi bu da çok kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aron çocukları arasındaki her erkek, Yahve'nin ateşle yapılan sunularından, kuşaklarınız boyunca daima kendi payları olarak yiyecek. Onlara kim dokunursa kutsal olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Aron'la oğullarının, meshedildiği gün Yahve'ye sunacakları sunu şudur: Yarısı sabah, yarısı akşam olmak üzere sürekli ekmek sunusu olarak efanın onda biri ince undur. ");
INSERT INTO turytc_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tavada yağla yapılacak. Yağı iyice çekince onu içeri getireceksin. Ekmek sunusunu Yahve'ye hoş koku olarak, pişmiş parçalar halinde sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Onun yerine oğulları arasından gelecek olan meshedilmiş kâhin bunu sunacak. Sonsuza dek sürecek bir kural olarak Yahve'ye tümü yakılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Bir kâhinin sunduğu her ekmek sunusu tümüyle yakılacak. Ondan yenilmeyecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Aron'la oğullarına de ki, 'Günah sunusu yasası şudur: Yakmalık sunuların kesildiği yerde, günah sunusu Yahve'nin önünde kesilecek. Çok kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Onu günah için sunan kâhin onu yiyecek. Kutsal bir yerde, Buluşma Çadırı'nın avlusunda yenilecek. ");
INSERT INTO turytc_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Onun etine dokunan her şey kutsal olacaktır. Onun kanından bir giysi üzerine sıçradığında, üzerine sıçrayan şeyi kutsal bir yerde yıkayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ama içinde kaynatıldığı toprak kap kırılacak; eğer tunç bir kapta kaynatılırsa, ovulacak ve suda durulanacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kâhinler arasındaki her erkek ondan yiyecek. Çok kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Kutsal Yer'de kefaret olarak Buluşma Çadırı'na getirilen hiçbir günah sunusu yenilmeyecek. Ateşle yakılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“'Suç sunusuyla ilgili yasa şudur: Çok kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Yakmalık sunuların kesildiği yerde, suç sunusunu kesecek; kanını sunağın üzerine çepeçevre serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Bütün yağlarını, kuyruk yağını ve iç kısmını kaplayan yağı sunacak, ");
INSERT INTO turytc_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","iki böbreği, onların üzerlerindeki, bele yakın olan yağı ve karaciğerin zarını böbreklerle ayıracak; ");
INSERT INTO turytc_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","kâhin onları Yahve'ye ateşle yapılan sunu olarak sunakta yakacak; bu bir suç sunusudur. ");
INSERT INTO turytc_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kâhinler arasında her erkek ondan yiyebilir. Kutsal bir yerde yenilecek. Çok kutsaldır.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“'Günah sunusu nasılsa, suç sunusu da öyledir; onlar için tek bir yasa var. Onlarla kefaret eden kâhin kimse onun olacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Bir kişinin yakmalık sunusunu sunan kâhin, sunduğu yakmalık sunuların derisini kendisine alacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Fırında pişirilen her ekmek sunusu, tavada ve saç üzerinde hazırlanan her şey, onu sunan kâhinin olacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Yağla yoğrulmuş, ya da kuru, her ekmek sunusu, tek tek Aron'un oğullarının hepsine aittir.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“'Bir kişinin Yahve'ye sunacağı esenlik sunuları kurbanının yasası şudur: ");
INSERT INTO turytc_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Eğer o bunu şükran için sunuyorsa, o zaman şükran kurbanıyla birlikte, yağla karıştırılmış mayasız pideler, yağla meshedilmiş mayasız yufkalar ve yağla yoğrulmuş pideler sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Şükran için sunusunu esenlik kurbanıyla birlikte mayalı ekmek pideleriyle sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Her sunudan birini Yahve'ye kaldırma sunusu olarak sunacak. Esenlik sunularının kanını serpen kâhinin olacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Şükran için sunduğu esenlik kurbanının eti, sunulduğu gün yenilecek. Sabaha kadar hiçbir şey bırakmayacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“'Ancak eğer sunduğu kurban bir adak ya da gönüllü bir sunu ise, bu kurbanı sunduğu gün yenilecektir. Arta kalanlar ertesi gün yenilecek. ");
INSERT INTO turytc_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ama üçüncü gün kurbanın etinden arta kalanlar ateşte yakılacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Üçüncü günde esenlik kurbanının etinden yenilirse, kabul edilmeyecek ve onu sunan insana sayılmayacaktır. Bu iğrenç bir şey olacak ve ondan yiyen can, onun kötülüğünün yükünü taşıyacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“'Kirli bir şeye dokunan et yenmeyecek. Ateşle yakılacak. Ete gelince, onu temiz olan herkes yiyebilir; ");
INSERT INTO turytc_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ancak kirliliği üzerinde olup Yahve'ye ait olan esenlik kurbanının etini yiyen can, halkından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Bir kimse kirli bir şeye, insanın kirliliğine, kirli bir hayvana ya da kirli iğrenç bir şeye dokunursa ve Yahve'ye ait olan esenlik kurbanının etinden yerse, o can halkından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“İsrael'in çocuklarına de ki: 'Hiç yağ, boğa, koyun ya da keçi yağı yemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kendiliğinden ölen hayvanın yağı ve hayvanlardan parçalananın yağı başka herhangi bir iş için kullanılabilir, ancak onu hiçbir şekilde yemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","İnsanların Yahve'ye ateşle yapılan sunu olarak sunduğu hayvanın yağını kim yerse, onu yiyen can halkından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Konutlarınızın hiçbirinde kuş ya da hayvan kanı hiç yemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Her kim kan yerse, o can halkının arasından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“İsrael'in çocuklarına de ki, 'Kim Yahve'ye kendi esenlik kurbanını sunarsa, Yahve'ye sunusunu esenlik sunuları kurbanından getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Yahve'ye ateşle yapılan sunuları kendi elleriyle getirecek. Döş Yahve'nin önünde sallamalık sunu olarak sallanmak üzere, yağı döşle birlikte getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kâhin yağı sunakta yakacak, ama döş Aron'la oğullarının olacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Esenlik sunularınızın sağ budunu, kaldırma sunusu olarak kâhine vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Aron'un oğulları arasında esenlik sunularının kanını ve yağını sunanın payı olarak sağ but kendisinin olacak. ");
INSERT INTO turytc_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Çünkü İsrael'in çocuklarının esenlik sunularından sallama döşünü ve kaldırma budunu aldım ve onları İsrael'in çocuklarından payları olarak sonsuza dek Kâhin Aron'a ve oğullarına verdim.'” ");
INSERT INTO turytc_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Bu, Aron'un ve oğullarının, Yahve'ye kâhinlik makamında hizmet etmek üzere atandığı gün, Yahve'nin ateşle yapılan sunularından adama payıdır; ");
INSERT INTO turytc_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","bunu İsrael'in çocukları tarafından onlara verilmesini, kendilerini meshettiği günde Yahve buyurdu. Kuşaklar boyunca daima onların payı budur. ");
INSERT INTO turytc_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yakmalık sunu, ekmek sunusu, günah sunusu, suç sunusu, adama ve esenlik sunuları kurbanıyla ilgili yasa budur, ");
INSERT INTO turytc_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yahve'ye Sina Çölü'nde sunularını sunmaları için İsrael'in çocuklarına buyurduğu günde, Yahve Sina Dağı'nda Moşe'ye bunu buyurdu. ");
INSERT INTO turytc_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Aron'u ve kendisiyle birlikte oğullarını, giysilerini, mesh yağını, günah sunusu olan boğayı, iki koçu ve mayasız ekmek sepetini al; ");
INSERT INTO turytc_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","bütün topluluğu Buluşma Çadırı'nın kapısında topla.” ");
INSERT INTO turytc_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moşe Yahve'nin kendisine buyurduğu gibi yaptı; topluluk Buluşma Çadırı'nın kapısında toplandı. ");
INSERT INTO turytc_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moşe topluluğa, “Yahve'nin yapılmasını buyurduğu şey şudur” dedi. ");
INSERT INTO turytc_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moşe Aron'la oğullarını getirdi ve onları suyla yıkadı. ");
INSERT INTO turytc_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ona gömleği giydirdi, beline kuşağı bağladı, ona kaftanı giydirdi, ona efodu giydirdi ve efodun ustaca dokunmuş şeridini üzerine bağlayıp efodu kendisine onunla bağladı. ");
INSERT INTO turytc_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Göğüslüğü onun üzerine yerleştirdi. Urim ve Tummim'i göğüslüğün içine koydu. ");
INSERT INTO turytc_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Sarığı başına koydu. Yahve'nin Moşe'ye buyurduğu gibi altın levhayı, kutsal tacı sarığın üzerine, ön kısmına koydu. ");
INSERT INTO turytc_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moşe mesh yağını aldı, konutu ve içindekilerin hepsini meshedip kutsal kıldı. ");
INSERT INTO turytc_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Bunu sunağın üzerine yedi kez serpti ve sunağı, tüm takımlarını, kazanı ve ayağını kutsal kılmak için meshetti. ");
INSERT INTO turytc_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aron'un başına mesh yağından biraz döktü ve kendisini kutsal kılmak için onu meshetti. ");
INSERT INTO turytc_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Yahve'nin Moşe'ye buyurduğu gibi, Moşe Aron'un oğullarını getirdi, onlara gömlek giydirdi, üzerlerine kuşaklar bağladı ve onlara başlıklar taktı. ");
INSERT INTO turytc_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Günah sunusu olan boğayı getirdi; Aron'la oğulları ellerini günah sunusu olan boğanın başı üzerine koydular. ");
INSERT INTO turytc_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Onu kesti; Moşe kanı aldı, parmağıyla sunağın boynuzları üzerine çepeçevre sürdü, sunağı arındırdı, kanı sunağın dibine döktü ve onun için kefaret etmek üzere onu kutsal kıldı. ");
INSERT INTO turytc_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","İç kısmındaki bütün yağı, karaciğerin zarını, iki böbreği ve bunların yağlarını aldı; Moşe onu sunakta yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ama boğayı, derisini, etini ve gübresini Yahve'nin Moşe'ye buyurduğu gibi ordugâhın dışında ateşle yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Yakmalık sunu olarak koçu sundu. Aron'la oğulları ellerini koçun başı üzerine koydular. ");
INSERT INTO turytc_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Onu kesti; Moşe kanı sunağın üzerine çepeçevre serpti. ");
INSERT INTO turytc_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Koçu parçalar halinde kesti; Moşe başı, parçalarını ve yağını yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","İç kısmını ve bacaklarını suyla yıkadı; Moşe koçun tamamını sunakta yaktı. Hoş koku olarak yakılan bir sunuydu. Bu, Yahve'nin Moşe'ye buyurduğu gibi, Yahve'ye ateşle yapılan bir sunuydu. ");
INSERT INTO turytc_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Diğer koçu, adama koçunu sundu. Aron'la oğulları ellerini koçun başı üzerine koydular. ");
INSERT INTO turytc_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Onu kesti; Moşe onun kanının bir kısmını alıp Aron'un sağ kulak memesinin üzerine, sağ elinin baş parmağı üzerine ve sağ ayağının başparmağı üzerine sürdü. ");
INSERT INTO turytc_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aron'un oğullarını getirdi; Moşe kanın bir kısmını onların sağ kulak memesi üzerine, onların sağ ellerinin başparmağı üzerine ve onların sağ ayağının başparmağı üzerine sürdü; Moşe kanı sunağın üzerine çepeçevre serpti. ");
INSERT INTO turytc_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Yağı, kuyruk yağını, iç kısımdaki yağın tamamını, karaciğerin zarını, iki böbreği, yağlarını ve sağ budu aldı; ");
INSERT INTO turytc_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Yahve'nin önündeki mayasız ekmek sepetinden bir mayasız pide, bir yağlı ekmek ve bir yufka alıp yağın ve sağ budun üzerine koydu. ");
INSERT INTO turytc_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Bütün bunları Aron'un ve oğullarının ellerine koydu ve Yahve'nin önünde onları sallamalık sunu olarak salladı. ");
INSERT INTO turytc_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moşe onları ellerinden aldı ve sunakta yakmalık sunu üzerinde yaktı. Bunlar hoş koku olarak adama sunusuydu. Bu, Yahve'ye ateşle yapılan bir sunuydu. ");
INSERT INTO turytc_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moşe döşü alıp sallamalık sunu olarak Yahve'nin önünde onu salladı. Yahve'nin Moşe'ye buyurduğu gibi bu, adama koçundan Moşe'nin payıydı. ");
INSERT INTO turytc_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moşe sunağın üzerindeki mesh yağından ve kandan biraz aldı, Aron'un üzerine, giysileri üzerine, kendisiyle birlikte oğulları üzerine ve oğullarının giysileri üzerine serpti, Aron'u, giysilerini kendisiyle birlikte oğullarını ve oğullarının giysilerini kutsal kıldı. ");
INSERT INTO turytc_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moşe Aron'la oğullarına şöyle dedi: “Eti Buluşma Çadırı'nın kapısında haşlayın, sonra onu ve adak sepetindeki ekmeği, 'Aron'la oğulları onu yiyecekler' diye buyurmuş olduğum gibi orada yiyin. ");
INSERT INTO turytc_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Etten ve ekmekten arta kalanları ateşte yakacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Adama günleriniz doluncaya dek yedi gün boyunca Buluşma Çadırı'nın kapısından çıkmayacaksınız; çünkü adanmanız yedi gün sürecektir. ");
INSERT INTO turytc_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Bu gün yapılanın öyle yapılmasını, sizin için kefaret etmek üzere Yahve buyurdu. ");
INSERT INTO turytc_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Yedi gün gece gündüz Buluşma Çadırı'nın kapısında kalacaksınız ve ölmemek için Yahve'nin buyruğunu tutacaksınız; çünkü bana öyle buyuruldu.” ");
INSERT INTO turytc_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aron'la oğulları Yahve'nin Moşe aracılığıyla buyurduğu her şeyi yaptılar. ");
INSERT INTO turytc_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sekizinci gün Moşe Aron'la oğullarını ve İsrael'in ihtiyarlarını çağırdı; ");
INSERT INTO turytc_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ve Aron'a şöyle dedi: “Sürüden günah sunusu olarak kusursuz bir buzağı, yakmalık sunu olarak da kusursuz bir koç al ve onları Yahve'nin önünde sun. ");
INSERT INTO turytc_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","İsrael'in çocuklarına şöyle diyeceksiniz: 'Günah sunusu olarak bir teke; yakmalık sunu olarak her ikisi de bir yaşında kusursuz bir buzağı ve bir kuzu; ");
INSERT INTO turytc_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","esenlik sunuları olarak Yahve'nin önünde kurban etmek üzere bir boğayla bir koç; yağla yoğrulmuş ekmek sunusu alın; çünkü bugün Yahve size görünecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Moşe'nin buyurduklarını Buluşma Çadırı'nın önüne getirdiler. Bütün topluluk yaklaşıp Yahve'nin önünde durdu. ");
INSERT INTO turytc_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moşe şöyle dedi: “Yahve'nin size yapmanızı buyurduğu şey budur; Yahve'nin yüceliği size görünecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moşe Aron'a şöyle dedi: “Sunağa yaklaş, kendi günah sununu ve yakmalık sununu sun, kendin ve halk için kefaret et; Yahve'nin buyurduğu gibi halkın sunusunu sun ve onlar için kefaret et.” ");
INSERT INTO turytc_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Bunun üzerine Aron sunağa yaklaştı ve kendisi için olan günah sunusunun buzağısını kesti. ");
INSERT INTO turytc_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aron'un oğulları kanı ona sundular; ve parmağını kana batırıp sunağın boynuzları üzerine sürdü ve kanı sunağın dibine döktü; ");
INSERT INTO turytc_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ama günah sunusunun yağını, böbreklerini ve karaciğerinin zarını Yahve'nin Moşe'ye buyurduğu gibi sunakta yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Eti ve deriyi ordugâhın dışında ateşle yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Yakmalık sunuyu kesti; Aron'un oğulları kanı ona teslim ettiler; o da onu sunağın üzerine serpti. ");
INSERT INTO turytc_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yakmalık sunuları parça parça ve başı ona teslim ettiler. Onları sunak üzerinde yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","İç kısmını ve bacaklarını yıkadı ve bunları sunaktaki yakmalık sunu üzerinde yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Halkın sunusunu sundu ve halk için olan günah sunusu olan keçiyi aldı, onu kesti ve ilki gibi onu da günah sunusu olarak sundu. ");
INSERT INTO turytc_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yakmalık sunuyu sundu ve onu kuralına göre sundu. ");
INSERT INTO turytc_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ekmek sunusunu sundu, ondan avucunu doldurdu ve sabahın yakmalık sunusuna ek olarak onu da sunak üzerinde yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Halk için esenlik kurbanı olan boğayla koçu da kesti. Aron'un oğulları sunağın üzerine serptiği kanı ona teslim ettiler; ");
INSERT INTO turytc_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","boğanın ve koçun yağı, kuyruk yağı, iç kısımları, böbrekleri ve karaciğerin zarını; ");
INSERT INTO turytc_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","yağı döşlerin üzerine koydular, o da yağı sunak üzerinde yaktı. ");
INSERT INTO turytc_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aron Moşe'nin buyurduğu gibi Yahve'nin önünde sallamalık sunu olarak döşleri ve sağ budu salladı. ");
INSERT INTO turytc_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aron ellerini halka doğru kaldırıp onları kutsadı; günah sunusunu, yakmalık sunuyu ve esenlik sunularını sunduktan sonra indi. ");
INSERT INTO turytc_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moşe ile Aron Buluşma Çadırı'na girip çıktılar ve halkı kutsadılar; ve Yahve'nin yüceliği bütün halka göründü. ");
INSERT INTO turytc_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Yahve'nin önünden çıkan ateş, sunaktaki yakmalık sunuyu ve yağı tüketti. Bütün halk bunu görünce bağırdılar ve yüzüstü düştüler. ");
INSERT INTO turytc_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aron'un oğulları Nadav ile Avihu, her biri kendi buhurdanlığını alıp içine ateş koydular, üzerine buhur koydular ve Yahve'nin kendilerine buyurmadığı yabancı bir ateş sundular. ");
INSERT INTO turytc_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Yahve'nin önünden çıkan ateş onları yuttu ve Yahve'nin önünde öldüler. ");
INSERT INTO turytc_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Bunun üzerine Moşe Aron'a şöyle dedi: “Yahve, 'Bana yaklaşanlara kendimi kutsal göstereceğim, bütün halkın önünde yüceleceğim' diyerek söylediği budur.” Aron sessiz kaldı. ");
INSERT INTO turytc_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moşe, Aron'un amcası Uzziel'in oğulları Mişael ile Elsafan'ı çağırdı ve onlara şöyle dedi: “Yaklaşın, kardeşlerinizi kutsal yerin önünden ordugâhın dışına taşıyın.” ");
INSERT INTO turytc_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Yaklaştılar ve Moşe'nin söylediği gibi onları gömlekleriyle ordugâhın dışına taşıdılar. ");
INSERT INTO turytc_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moşe Aron'a, Eleazar'a ve oğulları İtamar'a şöyle dedi: “Ölmemeniz için saçlarınızı çözmeyin, giysilerinizi yırtmayın; öyle ki Yahve bütün topluluğa öfkelenmesin; ama kardeşleriniz, bütün İsrael evi, Yahve'nin tutuşturduğu yangına ağlasınlar. ");
INSERT INTO turytc_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ölmemek için Buluşma Çadırı'nın kapısından çıkmayacaksınız; çünkü Yahve'nin mesh yağı senin üzerindedir.” Moşe'nin sözüne göre yaptılar. ");
INSERT INTO turytc_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Bunun üzerine Yahve Aron'a şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Sen ve oğulların, Buluşma Çadırı'na her girdiğinizde şarap ya da içki içmeyin, yoksa ölürsünüz. Bu, kuşaklarınız boyunca daima geçerli bir kural olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kutsalla sıradan olanı, kirliyle temizi birbirinden ayıracaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Yahve'nin Moşe aracılığıyla kendilerine bildirdiği bütün kuralları İsrael'in çocuklarına öğreteceksin.” ");
INSERT INTO turytc_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moşe, Aron'a, geride kalan oğulları Eleazar'a ve İtamar'a şöyle dedi: “Yahve'nin ateşle yapılan sunularından arta kalan ekmek sunusunu alın ve onu mayasız olarak sunağın yanında yiyin; çünkü o çok kutsaldır; ");
INSERT INTO turytc_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","onu kutsal bir yerde yiyeceksiniz; çünkü bu, Yahve'ye ateşle yapılan sunulardan senin ve oğullarının payıdır; çünkü bana böyle buyuruldu. ");
INSERT INTO turytc_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Sallama döşünü ve kaldırma budunu, sen, oğulların ve kızlarınla birlikte temiz bir yerde yiyeceksiniz; çünkü bunlar, İsrael'in çocuklarının esenlik sunularının kurbanlarından sana ve oğullarınıza pay olarak verildi. ");
INSERT INTO turytc_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kaldırma budu ve sallama döşü yağlardan ateşte yapılan sunularla birlikte sallamalık sunu olarak Yahve'nin önünde sallamak üzere getirecekler. Yahve'nin buyurduğu gibi, daima pay olarak senin ve oğullarının olacak.” ");
INSERT INTO turytc_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moşe günah sunusu olan keçiyi özenle araştırdı ve işte, o keçi yanmıştı. Aron'un geride kalan oğulları Eleazar'a ve İtamar'a öfkelenip şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Neden günah sunusunu kutsal yerde yemediniz? Çünkü o çok kutsaldır ve topluluğun suçunu yüklenesiniz ve Yahve'nin önünde onlar için kefaret etmeniz için onu size vermiştir. ");
INSERT INTO turytc_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","İşte, onun kanı kutsal yerin iç kısmına getirilmedi. Buyurduğum gibi onu mutlaka kutsal yerde yemeliydiniz.” ");
INSERT INTO turytc_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aron Moşe'ye şöyle dedi: “İşte, bugün onların günah sunusunu ve yakmalık sunusunu Yahve'nin önünde sundular; buna benzer şeyler başıma geldi. Eğer bugün günah sunusunu yemiş olsaydım, bu Yahve'nin gözünde hoş olur muydu?” ");
INSERT INTO turytc_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moşe bunu duyduğunda bu onun gözüne hoş göründü. ");
INSERT INTO turytc_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahve Moşe ve Aron'la konuşup onlara şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“İsrael'in çocuklarına de ki, 'Bunlar yeryüzündeki bütün hayvanlar arasında yiyebileceğiniz canlılardır. ");
INSERT INTO turytc_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hayvanlar arasında, çatal ve yarık tırnaklı olup geviş getiren her hayvanı yiyebilirsiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“'Ancak geviş getirenlerden ya da çatal tırnaklardan bunları yemeyeceksiniz. Deve, çünkü o geviş getirir, ama çatal tırnaklı olmadığından sizin için kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Kaya porsuğu, çünkü o geviş getirir ama çatal tırnaklı olmadığından sizin için kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Tavşan, çünkü o geviş getirir, ama çatal tırnaklı olmadığından sizin için kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Domuz, çünkü çatal tırnaklı ve yarık tırnaklıdır, ama geviş getirmediğinden, sizin için kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Onların etini yemeyeceksiniz. Onların leşlerine dokunmayacaksınız. Onlar sizin için kirlidir.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“'Sularda olanların hepsinden, sularda, denizlerde ve ırmaklarda yüzgeçleri ve pulları olan ne varsa yiyebilirsiniz. ");
INSERT INTO turytc_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Denizlerde ve ırmaklarda yüzgeçleri ve pulları olmayanların hepsi, sularda hareket edenlerin hepsi, sularda yaşayan tüm canlılar sizin için iğrençtir. ");
INSERT INTO turytc_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Onlardan tiksineceksiniz. Onların etini yemeyeceksiniz ve leşlerinden tiksineceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sularda yüzgeçleri ve pulları olmayanlar sizin için iğrençtir.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“'Kuşların arasında bunlardan tiksineceksiniz; yenilmeyecekler, çünkü bunlar iğrençtir: Kartal, akbaba, kara akbaba, ");
INSERT INTO turytc_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kızıl çaylak, her tür kara çaylak, ");
INSERT INTO turytc_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","her tür kuzgun, ");
INSERT INTO turytc_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","baykuş, puhu, martı, her türlü atmaca, ");
INSERT INTO turytc_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","küçük baykuş, karabatak, ve büyük baykuş ");
INSERT INTO turytc_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","beyaz baykuş, çöl baykuşu, balıkkartalı, ");
INSERT INTO turytc_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","leylek, her türden balıkçıl, ibibik ve yarasa.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“'Dört ayak üzerinde yürüyen uçan böceklerin hepsi sizin için iğrençtir. ");
INSERT INTO turytc_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yine de şunları: Dört ayak üzerinde yürüyen, yerde sıçramak için uzun eklemli bacakları olan kanatlı böcekleri yiyebilirsiniz. ");
INSERT INTO turytc_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Bunlardan da yiyebilirsiniz: Her tür çekirge, her tür küçük çekirge, her tür cırcır böceği ve her tür ağustosböceği. ");
INSERT INTO turytc_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ama dört ayağı olan, kanatlı, böceklerin hepsi sizin için iğrençtir.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“'Bunlarla siz kirli olursunuz; onların leşine dokunan kişi akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Kim onların leşinden bir parça taşırsa, giysilerini yıkayacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“'Çatal tırnaklı olan, tırnağı yarık olmayan, ya da geviş getirmeyen her hayvan sizin için kirlidir. Onlara dokunan herkes kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Dört ayak üzerinde yürüyen hayvanlardan pençeleri üzerinde yürüyenler sizin için kirlidir. Kim onların leşine dokunursa akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Onların leşini taşıyan kişi giysilerini yıkayacak ve akşama kadar kirli olacaktır. Onlar sizin için kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“'Yer üzerinde sürünen hayvanlar arasında sizin için kirli olanlar şunlardır: Gelincik, fare, her tür büyük kertenkele, ");
INSERT INTO turytc_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geko, varan, duvar kertenkelesi, keler ve bukalemun. ");
INSERT INTO turytc_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bütün bu sürüngenler arasında size kirli olanlar bunlardır. Ölüsüne dokunan her kişi akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Öldüklerinde üzerine düşecekleri her şey kirli olacaktır. İster ağaçtan, ister giysiden, ister deriden, ister çuldan yapılmış bir kap olsun, hangi kapla iş yapılırsa yapılsın, suya konulmalı ve akşama kadar kirli olacak. Ondan sonra temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Bunlardan herhangi birinin içine düştüğü her toprak kap ve içindekilerin tümü kirli olacaktır. Onu kıracaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Su katılarak yenilen her türlü yiyecek kirli olacaktır. Bu tür kaplarda içilen her türlü içecek kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Onların leşlerinin üzerine düştüğü her şey kirli olacak; İster fırın ister ocak olsun, parçalanacaktır. Onlar kirlidir ve sizin için de kirli olacaklardır. ");
INSERT INTO turytc_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Bununla birlikte, suyun toplandığı kaynak ya da sarnıç temiz olacak, ama onların leşlerine dokunan kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Eğer ekilecek tohumun üzerine onların leşinin bir kısmı düşerse, o size temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ama tohumun üzerine su konulur da leşinin bir kısmı üzerine düşerse, o sizin için kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“'Yiyebileceğiniz hayvanlardan herhangi biri ölürse, onun leşine dokunan kişi akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Onun leşini yiyen, giysilerini yıkayacak ve akşama kadar kirli olacaktır. Onun leşini taşıyan da giysilerini yıkayacak ve akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“'Yerde sürünen her canlı iğrençtir. Yenilmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Karnının üzerinde sürünen, dört ayak üzerinde yürüyen, çok ayağı olan, yerde sürünen canlılarn hiçbirini yemeyeceksiniz; çünkü onlar iğrençtir. ");
INSERT INTO turytc_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Sürünen hiçbir şeyle kendinizi iğrenç kılmayacaksınız. Onlar tarafından kirletileceksiniz diye kendinizi onlarla kirletmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Çünkü ben Tanrınız Yahve'yim. Bu nedenle kendinizi kutsal kılın ve kutsal olun; çünkü ben kutsalım. Yeryüzünde sürünen hiçbir şeyle kendinizi kirletmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Çünkü Tanrınız olmak için sizi Mısır diyarından çıkaran Yahve benim. Bu nedenle siz de kutsal olacaksınız, çünkü ben kutsalım. ");
INSERT INTO turytc_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“'Kirliyle temizi birbirinden, yenilebilen canlıyla yenilemeyen canlıyı ayırt etmek için, ");
INSERT INTO turytc_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","hayvanların, kuşların, sularda hareket eden her canlının ve yerde sürünen her yaratığın yasası budur.'” ");
INSERT INTO turytc_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“İsrael'in çocuklarına de ki: 'Bir kadın gebe kalıp erkek çocuk doğurursa, yedi gün kirli olacaktır; âdet günlerinde olduğu gibi kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sekizinci gün sünnet derisinin eti sünnet edilecek. ");
INSERT INTO turytc_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Otuz üç gün boyunca kendi arınma kanında kalacak. Arınma günleri tamamlanıncaya kadar hiçbir kutsal şeye dokunmayacak ve tapınağa girmeyecek. ");
INSERT INTO turytc_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ama kız çocuk doğurursa, adet döneminde olduğu gibi iki hafta kirli sayılacaktır ve altmış altı gün kendi arınma kanında kalacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“'Bir erkek çocuk ya da kız çocuk için arınma günleri tamamlanınca, Buluşma Çadırı'nın kapısına, kâhine, yakmalık sunu olarak bir yaşında bir kuzu ve günah sunusu olarak bir güvercin yavrusu ya da bir kumru getirecektir. ");
INSERT INTO turytc_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Onu Yahve'nin önünde sunacak ve kadın için kefaret edecek; o zaman kanının pınarından temizlenecek.'” “‘Çocuk erkek olsun, kız olsun, doğuran kadın için yasa budur. ");
INSERT INTO turytc_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Eğer kuzu almaya gücü yetmezse, biri yakmalık sunu, diğeri günah sunusu olmak üzere iki kumru ya da iki yavru güvercin alacaktır. Kâhin onun için kefaret edecek ve o temiz olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahve Moşe'ye ve Aron'a konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Bir adamın bedeninin derisinde şişlik, yara kabuğu ya da parlak bir leke varsa ve bu durum bedeninin derisinde cüzzam haline gelirse, o zaman o kişi kâhin Aron'a ya da onun oğullarından biri olan kâhinlere getirilecek. ");
INSERT INTO turytc_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kâhin bedenin derisindeki vebayı inceleyecek. Vebadaki kıl ağarmışsa ve vebanın görünümü beden derisinden daha derinse, bu cüzzam belasıdır; bu yüzden kâhin onu inceleyecek ve onu kirli ilan edecek. ");
INSERT INTO turytc_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Bedenin derisindeki parlak leke beyazsa, görünümü deriden derin değilse ve kılı ağarmamışsa, kâhin hastayı yedi gün boyunca kapayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Yedinci gün kâhin onu inceleyecek. İşte, eğer kâhinin gözünde veba durmuş ve veba deriye yayılmamışsa, o zaman kâhin onu yedi gün daha kapayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Yedinci gün kâhin onu tekrar inceleyecek. İşte, eğer veba hafiflemişse ve veba deriye yayılmamışsa, o zaman kâhin onu temiz ilan edecektir. Bu bir kabuktur. Elbiselerini yıkayacak ve temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ama arınmak için kendini kâhine gösterdikten sonra derisinde kabuk yayılırsa, kendisini tekrar kâhine gösterecektir. ");
INSERT INTO turytc_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kâhin onu inceleyecek; işte, eğer kabuk deriye yayılmışsa, o zaman kâhin onu kirli ilan edecek. Bu cüzzamdır.” ");
INSERT INTO turytc_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Bir adamda cüzzam vebası olduğunda, o zaman o kişi kâhine götürülecek; ");
INSERT INTO turytc_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","kâhin onu inceleyecek. İşte, eğer deride beyaz bir şişlik varsa ve bu şişlik kılı ağartmışsa ve şişkinliğin içinde diri kızıl et varsa, ");
INSERT INTO turytc_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","bu, bedenin derisinde kronik bir cüzzamdır ve kâhin onu kirli ilan edecektir. Onu kapamayacak; zaten kirlidir.” ");
INSERT INTO turytc_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Eğer cüzzam derinin her yerine yayılmışsa ve cüzzam, hastalığın görüldüğü insanın başından ayaklarına kadar, kâhinin gördüğü kadarıyla bütün derisini kaplamışsa, ");
INSERT INTO turytc_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","o zaman kâhin onu inceleyecek. İşte, eğer cüzzam bütün bedenini kaplamışsa, onu vebadan temiz ilan edecek. Hepsi ağarmıştır: O kişi temizdir. ");
INSERT INTO turytc_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ama ne zaman onda kızıl et görünürse kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kâhin kızıl eti inceleyecek ve onu kirli ilan edecek; kızıl et kirlidir. Bu cüzzamdır. ");
INSERT INTO turytc_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ya da kızıl et tekrar ağarırsa, o zaman kâhine gelecektir. ");
INSERT INTO turytc_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kâhin onu inceleyecek. İşte, eğer veba beyaza dönmüşse, o zaman kâhin onu vebadan temiz ilan edecek. O kişi temizdir.” ");
INSERT INTO turytc_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Bedenin derisinde bir çıban olup iyileştiğinde, ");
INSERT INTO turytc_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","çıban yerinde beyaz bir şişlik ya da kırmızımsı beyaz parlak leke olursa, o zaman kâhine gösterilecek. ");
INSERT INTO turytc_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kâhin onu inceleyecek. İşte, eğer görünüşü derisinden daha derinse ve kılı ağarmışsa, o zaman kâhin onu kirli ilan edecektir. Bu cüzzam vebasıdır. Çıbanda meydana çıkmıştır. ");
INSERT INTO turytc_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ancak kâhin onu inceler ve içinde hiç beyaz kıl bulunmadığını, deriden daha derin olmayıp solmuş olduğunu görürse, o zaman kâhin onu yedi gün kapayacak. ");
INSERT INTO turytc_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Eğer deriye yayılırsa, kâhin onu kirli ilan edecek. Bu bir vebadır. ");
INSERT INTO turytc_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ama eğer parlak leke yerinde duruyorsa ve yayılmadıysa, bu çıban kabuğudur; ve kâhin onu temiz ilan edecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ya da bedeninde ateş yanığı varsa ve yanıktaki kızıl et kırmızımsı beyaz ya da beyaz parlak bir leke haline gelirse, ");
INSERT INTO turytc_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","o zaman kâhin onu inceleyecek; işte, eğer parlak lekede kıl ağarmışsa ve görünüşü deriden daha derinse, bu cüzzamdır. Yanıkta meydana çıkmıştır ve kâhin onu kirli ilan edecektir. Bu cüzzam vebasıdır. ");
INSERT INTO turytc_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ama kâhin onu inceleyip parlak lekede hiç beyaz kıl olmadığını ve deriden daha derin olmayıp solgunlaştığını görürse, o zaman kâhin onu yedi gün kapayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Yedinci gün kâhin onu inceleyecek. Eğer deriye yayılmışsa, kâhin onu kirli ilan edecek. Bu cüzzam vebasıdır. ");
INSERT INTO turytc_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Eğer parlak leke yerinde duruyorsa ve deriye yayılmayıp solmuşsa, bu yanıktan kaynaklanan şişliktir. Kâhin onu temiz ilan edecektir; çünkü yanık kabuğudur.” ");
INSERT INTO turytc_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Bir erkeğin ya da kadının başında ya da sakalında veba varsa, ");
INSERT INTO turytc_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","o zaman kâhin vebayı inceleyecek; işte, eğer görünüşü deriden daha derinse ve içindeki tüyler sarı ve ince ise, o zaman kâhin onu kirli ilan edecektir. Bu bir kaşıntı. Bu, baş ya da sakal cüzzamıdır. ");
INSERT INTO turytc_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Eğer kâhin kaşıntı belasını inceler ve görünüşü deriden daha derin değilse ve içinde hiç siyah kıl yoksa, o zaman kâhin kaşıntıya yakalanan kişiyi yedi gün kapayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Yedinci gün kâhin vebayı inceleyecek; işte, eğer kaşıntı yayılmamışsa, içinde sarı kıl yoksa ve kaşıntı deriden daha derin değilse, ");
INSERT INTO turytc_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","o zaman kişi tıraş edilecek, ancak kaşıntıyı tıraş etmeyecektir. Daha sonra kâhin kaşıntısı olan kişiyi yedi gün daha kapayacak. ");
INSERT INTO turytc_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Yedinci gün kâhin kaşıntıyı inceleyecek; işte, eğer kaşıntı deriye yayılmamışsa ve görünüşü deriden daha derin değilse, o zaman kâhin onu temiz ilan edecek. Elbiselerini yıkayacak ve temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ama temizlendikten sonra deride kaşıntı yayılırsa, ");
INSERT INTO turytc_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kâhin onu inceleyecek; işte, eğer deride kaşıntı yayılmışsa, kâhin sarı kıl aramayacak; o kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ama eğer kâhinin gözünde kaşıntı geçmişse ve onda siyah kıl çıkmışsa, kaşıntı iyileşmiştir. O kişi temizdir. Kâhin onu temiz ilan edecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Bir erkeğin ya da kadının bedeninde parlak lekeler, beyaz parlak lekeler varsa, ");
INSERT INTO turytc_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","o zaman kâhin onları inceleyecek, işte, eğer bedeninin derisindeki parlak lekeler solgun beyaz ise, bu zararsız bir döküntüdür. Deride meydana çıkmıştır. O kişi temizdir.” ");
INSERT INTO turytc_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Bir adamın saçları başından dökülmüşse o kişi keldir. O kişi temizdir. ");
INSERT INTO turytc_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Saçları başının ön kısmından dökülmüşse alın keldir. O kişi temizdir. ");
INSERT INTO turytc_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ama kel kafada ya da kel alnında kırmızımsı beyaz bir veba varsa, bu, kel kafasında ya da kel alnında meydana çıkan cüzzamdır. ");
INSERT INTO turytc_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sonra kâhin onu inceleyecek. İşte, kel kafasındaki ya da kel alnındaki vebanın şişi, bedeninin derisindeki cüzzam görünümüne benzer, kırmızımsı beyaz ise, ");
INSERT INTO turytc_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","o kişi cüzzamlı biridir. O kişi kirlidir. Kâhin onu kesin olarak kirli ilan edecek. Onun vebası başındadır.” ");
INSERT INTO turytc_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Kendisinde cüzzam vebası olan kişi, yırtık giysiler giyecek, saçı çözülecek. Üst dudağını kapatacak ve 'Kirli, kirli!' diye bağıracak. ");
INSERT INTO turytc_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Vebanın onda olduğu bütün günler kirli olacak. O kişi kirlidir. Yalnız başına oturacak. Oturduğu yer ordugâhın dışında olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Cüzzam vebasının bulunduğu giysi, ister yünlü, ister keten giysi olsun; ");
INSERT INTO turytc_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ister çözgü ister atkı, ister keten, ister yün; ister deri olsun, ister deriden yapılmış herhangi bir şey olsun; ");
INSERT INTO turytc_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","eğer veba giyside, deride, çözgüde, atkıda ya da deriden yapılmış herhangi bir şeyde yeşilimsi ya da kırmızımsı ise; cüzzam vebasıdır ve kâhine gösterilecektir. ");
INSERT INTO turytc_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kâhin vebayı inceleyecek ve vebayı yedi gün kapayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Yedinci gün vebayı inceleyecek. Eğer veba giysiye, çözgüye, atkıya ya da deriye yayılmışsa, deri ne amaçla kullanılırsa kullanılsın, veba yıkıcı bir küftür. Bu kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Vebanın bulunduğu yünden, ketenden ya da deriden yapılmış çözgü ya da atkı olsun, giysiyi yakacak; çünkü bu yıkıcı bir küftür. Ateşte yakılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Kâhin onu incelediğinde vebanın giysiye, çözgüye, atkıya ya da deriden herhangi bir şeye yayılmamışsa; ");
INSERT INTO turytc_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","sonra kâhin vebanın olduğu şeyi yıkamalarını buyuracak ve onu yedi gün daha kapayacak. ");
INSERT INTO turytc_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Veba yıkandıktan sonra kâhin onu inceleyecek; işte, vebanın rengi değişmediyse ve yayılmadıysa kirlidir; onu ateşte yakacaksın. Tüysüzlük içeride de olsa dışarıda da olsa, küflenmiş bir lekedir. ");
INSERT INTO turytc_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Eğer kâhin bakar ve işte, veba yıkandıktan sonra solmuşsa, o zaman onu giysiden, ya da deriden, ya da çözgüden ya da atkıdan yırtacaktır; ");
INSERT INTO turytc_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","eğer giysinin çözgüsünde, atkısında ya da deriden herhangi bir şeyde tekrar görünürse, yayılmaktadır. Kendisinde veba olan o şeyi ateşle yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Yıkayacağınız giysi, çözgü, atkı ya da deriden herhangi bir şey, eğer üzerinden veba geçmişse, o zaman ikinci kez yıkanacak ve temiz olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Yünlü ya da keten bir giysinin çözgüsünde, atkısında ya da deriden herhangi bir şeyde, onu temiz ya da kirli ilan etmek için küf vebasının yasası budur. ");
INSERT INTO turytc_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Cüzzamlının temiz kılınacağı gün yasası şu olacak: O, kâhine getirilecek, ");
INSERT INTO turytc_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kâhin ordugâhtan çıkacak. Kâhin onu inceleyecek. İşte, eğer cüzzamlıdaki cüzzam vebası iyileşirse, ");
INSERT INTO turytc_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","o zaman kâhin onlara, temiz kılınacak kişi için iki canlı, temiz kuş, sedir ağacı, kırmızı ve mercanköşkotu almalarını buyuracak. ");
INSERT INTO turytc_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kâhin onlara kuşlardan birini akan suyun üzerinde toprak bir kapta kesmelerini buyuracak. ");
INSERT INTO turytc_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Canlı kuşa gelince, onu, sedir ağacını, kırmızıyı ve mercanköşkotunu alacak; onları ve canlı kuşu akarsu üzerinde kesilen kuşun kanına batıracak. ");
INSERT INTO turytc_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Cüzzamdan temiz kılınacak insanın üzerine yedi kez serpecek, onu temiz ilan edecek ve canlı kuşu kıra salacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Temiz kılınacak olan kişi giysilerini yıkayacak, bütün kıllarını tıraş edecek ve suda yıkanacak; o da temiz olacak. Bundan sonra ordugâhın içine gelecek ama yedi gün çadırının dışında kalacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Yedinci gün böyle olacak, saçını, sakalını ve kaşlarını tıraş edecek. Bütün kıllarını tıraş edecek. Giysilerini yıkayacak ve bedenini suda yıkayacak. O zaman temiz olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Sekizinci gün kusursuz iki erkek kuzu, bir yaşında kusursuz bir dişi kuzu, ekmek sunusu olarak yağla yoğrulmuş onda üç efa ince un ve bir log yağ alacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Onu temiz kılan kâhin, temiz kılınacak kişiyi ve bu şeyleri, Yahve'nin önüne, Buluşma Çadırı'nın kapısında durduracak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Kâhin erkek kuzulardan birini alıp onu bir log yağla birlikte suç sunusu olarak sunacak ve sallamalık sunu olarak Yahve'nin önünde sallayacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Erkek kuzuyu, günah sunusunu ve yakmalık sunuyu kestikleri yerde, kutsal yerde kesecek; çünkü günah sunusu gibi suç sunusu da kâhinindir. Çok kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kâhin suç sunusunun kanından biraz alacak ve bunu temiz kılınacak insanın sağ kulak memesi üzerine, sağ elinin başparmağı üzerine ve sağ ayağının başparmağı üzerine sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kâhin bir log yağ alıp kendi sol avucuna dökecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kâhin sağ parmağını sol elindeki yağa batıracak ve Yahve'nin önünde yedi kez parmağıyla yağdan biraz serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kâhin elindeki geri kalan yağdan temiz kılınacak insanın sağ kulak memesi üzerine, sağ elinin başparmağı üzerine, sağ ayağının başparmağı üzerine ve suç sunusunun kanı üzerine sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kâhinin elindeki yağın geri kalanını temiz kılınacak insanın başına sürecek ve kâhin Yahve'nin önünde onun için kefaret edecek.” ");
INSERT INTO turytc_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Kâhin günah sunusunu sunacak ve kirliliğinden dolayı temiz kılınacak olan insana kefaret edecek. Ondan sonra yakmalık sunuyu kesecek; ");
INSERT INTO turytc_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","sonra kâhin yakmalık sunuyu ve ekmek sunusunu sunakta sunacak. Kâhin onun için kefaret edecek, o da temiz olacak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Eğer yoksulsa ve gücü bu kadarına yetmezse, o zaman kendisi için kefaret etmek üzere sallamalık suç sunusu olarak bir erkek kuzu ve ekmek sunusu olarak yağla yoğrulmuş onda bir efa ince un ve bir log yağ alacak; ");
INSERT INTO turytc_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","gücünün yettiği kadar iki kumru ya da iki güvercin yavrusu alacak; biri günah sunusu, diğeri yakmalık sunu olacak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Sekizinci gün onları arınmaları için Yahve'nin önüne, Buluşma Çadırı'nın kapısına, kâhine getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kâhin suç sunusunun kuzusunu ve bir log yağı alacak ve bunları sallamalık sunu olarak Yahve'nin önünde sallayacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Suç sunusunun kuzusunu kesecek. Kâhin suç sunusunun kanının bir kısmını alıp temiz kılınacak insanın sağ kulak memesi üzerine, sağ elinin başparmağı üzerine ve sağ ayağının başparmağı üzerine sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kâhin yağın bir kısmını kendi sol avucuna dökecek; ");
INSERT INTO turytc_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","kâhin sol elindeki yağdan sağ parmağıyla Yahve'nin önünde yedi defa serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Sonra kâhin elindeki yağdan bir kısmını temiz kılınacak insanın sağ kulak memesi üzerine, sağ elinin başparmağı üzerine ve sağ ayağının başparmağı üzerine ve suç sunusu kanının yeri üzerine sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kâhinin elindeki yağın geri kalanını, Yahve'nin önünde kefaret etmek üzere temiz kılınacak insanın başı üzerine sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Gücü yettiği kadar kumrulardan ya da güvercin yavrularından birini, ");
INSERT INTO turytc_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","gücünün yettiği kadarıyla ekmek sunusuyla birlikte birini günah sunusu, diğerini yakmalık sunu olarak sunacak. Kâhin, Yahve'nin önünde temiz kılınacak kişi için kefaret edecek.” ");
INSERT INTO turytc_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Kendisinde cüzzam vebası bulunan ve arınması için kurban sunmaya gücü yetmeyen kişi için yasa budur. ");
INSERT INTO turytc_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Size mülk olarak vereceğim Kenan diyarına girdiğinizde ve mülkünüz olan ülkede bir eve yayılan küf koyduğumda, ");
INSERT INTO turytc_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","o zaman o evin sahibi gelip, 'Bana öyle geliyor ki, evde sanki veba gibi bir şey var' diyerek kâhine söyleyecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kâhin, evde olanlar her şey kirlenmesin diye vebayı incelemek için içeri girmeden önce evi boşaltmalarını buyuracak. Daha sonra kâhin evi incelemek için içeri girecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Vebayı inceleyecek; işte, eğer veba evin duvarlarında yeşilimsi ya da kırmızımsı lekeler halindeyse ve onlar duvardan daha derin görünüyorsa, ");
INSERT INTO turytc_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","o zaman kâhin evden evin kapısına çıkacak ve evi yedi gün kapayacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Yedinci gün kâhin tekrar gelip bakacak. Eğer veba evin duvarlarına yayılmışsa, ");
INSERT INTO turytc_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","o zaman kâhin, vebanın bulunduğu taşları çıkarıp şehrin dışındaki kirli bir yere atmalarını buyuracak. ");
INSERT INTO turytc_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Evin içinin her tarafı kazınacak. Kazıdıkları harcı şehrin dışına, kirli bir yere dökecekler. ");
INSERT INTO turytc_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Başka taşlar alıp bu taşların yerine koyacaklar; başka harç alıp evi sıvayacak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Eğer taşlar çıkarıldıktan, evi kazıdıktan ve sıvandıktan sonra veba evde yine meydana çıkarsa, ");
INSERT INTO turytc_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","o zaman kâhin içeri girip bakacaktır; işte, eğer veba evde yayılmışsa, evde yıkıcı bir küf vardır ve kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Evi, taşlarını, kerestesini ve evin tüm harcını yıkacak. Onları şehrin dışına, kirli bir yere taşıyacak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Üstelik, kapalıyken eve giren kişi akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Evde yatan giysilerini yıkayacak; evde yemek yiyen de giysilerini yıkayacak.” ");
INSERT INTO turytc_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Eğer kâhin içeri girip evi incelerse, işte, ev sıvandıktan sonra veba evde yayılmamışsa, o zaman kâhin evi temiz ilan edecek; çünkü veba geçmiştir. ");
INSERT INTO turytc_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Evi temizlemek için iki kuş, sedir ağacı, kırmızı ve mercanköşkotu alacak. ");
INSERT INTO turytc_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kuşlardan birini akan suyun üzerinde toprak bir kapta kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sedir ağacını, mercanköşkotu, kırmızı ve canlı kuşu alıp onları öldürülen kuşun kanına ve akan suya batıracak ve eve yedi kez serpecek. ");
INSERT INTO turytc_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Evi kuşun kanıyla, akan suyla, canlı kuşla, sedir ağacıyla, mercanköşkotuyla ve kırmızıyla temizleyecek; ");
INSERT INTO turytc_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ancak canlı kuşu kentten çıkıp kıra salacak. Böylece ev için kefaret edecek; ve temiz olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Her türlü cüzzam hastalığı ve kaşıntı için, ");
INSERT INTO turytc_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","giysi küfü için, ev için, ");
INSERT INTO turytc_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","şiş için, kabuk için ve parlak leke için yasa budur; ");
INSERT INTO turytc_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ne zaman kirli, ne zaman temiz olduğunu öğretmek için; cüzzam yasası budur. ");
INSERT INTO turytc_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahve Moşe ve Aron'a şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Bir adamın bedeninden akıntısı varsa, o kişi kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Onun akıntısından kirliliği şu olacak: İster bedeni akıntısını akıtıyor, ister bedeni akıntıyı durdurmuş olsun, bu onun kirliliğidir.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“'Akıntısı olan insanın yattığı her yatak kirli olacaktır; üzerine oturduğu her şey kirli olacak. ");
INSERT INTO turytc_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Yatağına dokunan her kişi giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Akıntısı olan adamın oturduğu herhangi bir yere oturan kişi, giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“'Akıntısı olan birinin bedenine dokunan kişi giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“'Eğer akıntısı olan kişi temiz olana tükürürse, o zaman o kişi giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“'Akıntısı olanın üzerine bindiği eyer kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Onun altındaki herhangi bir şeye dokunan kişi akşama kadar kirli sayılacaktır. Bunları taşıyan kişi giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“'Akıntısı olan kişi, ellerini suyla yıkamadan kime dokunursa, o kişi giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“'Akıntısı olanın dokunduğu toprak kap kırılacak; ve her ağaç kap suyla durulanacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“'Akıntısı olan kişi akıntısından arındığında, arınmak için kendine yedi gün sayacak ve giysilerini yıkayacak; ve bedenini akar suda yıkayacak ve temiz olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“'Sekizinci gün iki kumru ya da iki güvercin yavrusu alıp Yahve'nin önüne, Buluşma Çadırı'nın kapısına gelecek ve onları kâhine verecek. ");
INSERT INTO turytc_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kâhin bunlardan birini günah sunusu, diğerini yakmalık sunu olarak sunacak. Kâhin akıntısından dolayı Yahve'nin önünde onun için kefaret edecek.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“'Eğer bir adamdan meni çıkarsa, o zaman bütün bedenini suda yıkayacak ve akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Üzerinde meni olan her giysi ve her deri suyla yıkanacak ve akşama kadar kirli olacak. ");
INSERT INTO turytc_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Bir adam bir kadınla yatarsa ve meni çıkarsa, ikisi de suda yıkanacak ve akşama kadar kirli olacaklar.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“'Bir kadının akıntısı varsa ve akıntısı kansa, yedi gün kirli olacaktır. Ona dokunan kişi akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“'Kendi kirliliğinde üzerinde yattığı her şey kirli olacak. Üzerinde oturduğu her şey de kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Kim onun yatağına dokunursa, giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kim onun üzerinde oturduğu herhangi bir şeye dokunursa, giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kadının oturmuş olduğu yatak ya da kadının üzerinde oturduğu herhangi bir şeye dokunan kişi, akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“'Bir erkek onunla yatarsa ve kadının aylık akıntısı onun üzerine gelirse, yedi gün kirli olacaktır; yattığı her yatak da kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“'Eğer bir kadının âdet zamanı dışında birçok gün kan akıntısı olursa ya da âdet zamanının ötesinde akıntısı varsa, kirliliğinin akıntısının bütün günleri âdet günleri gibi olacak. O kirlidir. ");
INSERT INTO turytc_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Akıntısı olduğu günler boyunca yattığı her yatak, onun için âdet yatağı gibi olacaktır. Üzerinde oturduğu her şey, kendi âdet kirliliği gibi kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Bu şeylere dokunan her kişi kirli olacak, giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“'Ama eğer akıntısından temizlenmişse, o zaman kendisine yedi gün sayacak ve ondan sonra temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sekizinci günde iki kumru ya da iki güvercin yavrusu alıp onları kâhine, Buluşma Çadırı'nın kapısına getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kâhin birini günah sunusu, diğerini yakmalık sunu olarak sunacak; kâhin onun için, akıntısının kirliliğinden dolayı Yahve'nin önünde kefaret edecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“'İsrael'in çocuklarını kendi kirliliklerinden böyle ayıracaksın ki, aralarındaki konutumu kirlettiklerinde kendi kirlilikleri içinde ölmesinler.'” ");
INSERT INTO turytc_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Akıntısı olanın ve kendisinden meni çıkmasından dolayı kirli olanın; ");
INSERT INTO turytc_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","âdet gören kadının, akıntısı olan erkek ya da kadının ve kirli olan kadınla birlikte yatan erkeğin yasası budur. ");
INSERT INTO turytc_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahve'nin önüne yaklaştıkları zaman ölen Aron'un iki oğlunun ölümünden sonra, Yahve Moşe'ye şöyle konuştu; ");
INSERT INTO turytc_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahve Moşe'ye dedi: “Kardeşin Aron'a söyle, perdenin içindeki En Kutsal Yer'e, sandık üzerinde Merhamet Örtüsü'nün iç tarafına her vakit girmesin; yoksa ölür; çünkü ben Merhamet Örtüsü'nün üzerindeki bulutta görüneceğim.” ");
INSERT INTO turytc_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aron, günah sunusu olarak bir boğa ve yakmalık sunu olarak bir koçla birlikte Kutsal Yer'e girecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kutsal keten gömleğini giyecek. Bedeni üzerinde keten don olacak, keten kuşak takacak ve kendisine keten sarık giydirilecek. Onlar kutsal giysilerdir. Bedenini suyla yıkayacak ve onları giyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","İsrael'in çocuklarının topluluğundan günah sunusu olarak iki teke, yakmalık sunu olarak da bir koç alacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aron kendisi için günah sunusu olan boğayı sunacak, kendisi ve evi için kefaret edecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","İki keçiyi alıp Buluşma Çadırı'nın kapısında, Yahve'nin önünde durduracaktır. ");
INSERT INTO turytc_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aron iki keçi için kura çekecek; kuralardan biri Yahve için, diğeri Azazel içindir. ");
INSERT INTO turytc_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aron Yahve'ye kura düşen tekeyi sunacak ve onu günah sunusu olarak sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ancak Azazel için üzerine kura düşen keçiyi, onun için kefaret etmek, onu Azazel için çöle salıvermek üzere, canlı olarak Yahve'nin önünde durdurulacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aron kendisi için olan günah sunusu boğasını sunacak, kendisi ve evi için kefaret edecek ve kendisi için olan günah sunusu boğasını kesecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Yahve'nin önündeki sunak üzerindeki ateş korlarıyla dolu bir buhurdan ve ince ezilmiş iki avuç hoş kokulu buhur alacak ve onu perdenin iç tarafına getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Buhur bulutu, antlaşma üzerinde olan Merhamet Örtüsü'nü örtsün ve ölmesin diye, buhuru Yahve'nin önünde ateş üzerine koyacak. ");
INSERT INTO turytc_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Boğanın kanından biraz alıp parmağıyla doğuya doğru Merhamet Örtüsü'ne serpecek; merhamet örtüsünün önünde parmağıyla yedi kez kanın bir kısmını serpecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Sonra halk için olan günah sunusu olan keçiyi kesecek, kanını perdenin iç tarafına getirecek, boğanın kanına yaptığının aynısını onun kanına da yapacak, onu Merhamet Örtüsü'nün üzerine, Merhamet Örtüsü'nün önünde serpecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","İsrael'in çocuklarının kirliliğinden, isyanlarından, bütün günahlarından dolayı Kutsal Yer için kefaret edecek; kirliliklerinin ortasında kendileriyle birlikte duran Buluşma Çadırı için de aynısını yapacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kutsal Yer'e kefaret etmek için girdiğinde, kendisi, ailesi ve tüm İsrael topluluğu için kefaret edip çıkana kadar Buluşma Çadırı'nda hiç kimse bulunmayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Yahve'nin önündeki sunağa çıkıp onun için kefaret edecek, boğanın kanından ve keçinin kanından biraz alıp sunağın boynuzları üzerine çepeçevre sürecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Parmağıyla yedi kez kanın bir kısmını üzerine serpecek, onu İsrael'in çocuklarının kirliliğinden arındırıp kutsal kılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Kutsal Yer, Buluşma Çadırı ve sunağın kefaretini bitirince canlı keçiyi sunacak. ");
INSERT INTO turytc_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aron iki elini canlı keçinin başına koyacak, İsrael'in çocuklarının bütün suçlarını, bütün isyanlarını ve bütün günahlarını onun üzerine itiraf edecek; bunları keçinin başı üzerine koyacak ve hazırlanmış bir adamın eliyle onu çöle salıverecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Keçi onların bütün kötülüklerini ıssız bir ülkeye kendi üzerinde taşıyacak ve keçiyi çöle salıverecektir.” ");
INSERT INTO turytc_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aron Buluşma Çadırı'na girecek ve Kutsal Yer'e girerken giydiği keten giysilerini çıkarıp orada bırakacak. ");
INSERT INTO turytc_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Sonra kutsal bir yerde kendini suyla yıkayacak, giysilerini giyecek ve dışarı çıkıp kendi yakmalık sunusunu ve halkın yakmalık sunusunu sunacak, kendisi ve halk için kefaret edecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Günah sunusunun yağını sunakta yakacak.” ");
INSERT INTO turytc_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Keçiyi günah keçisi olarak salıveren kişi, giysilerini yıkayacak, bedenini suda yıkayacak, ondan sonra ordugâha girecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kutsal Yer'de kefaret etmek üzere kanı getirilen günah sunusu boğası ve günah sunusu tekesi ordugâhın dışına taşınacak, derilerini, etlerini ve gübrelerini ateşte yakacaklar. ");
INSERT INTO turytc_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Bunları yakan kişi giysilerini yıkayacak, bedenini suda yıkayacak ondan sonra ordugâha girecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Size daima bir kural olacak: Yedinci ayda, ayın onuncu gününde, canlarınızı sıkıntıya sokacaksınız, ister yerli olsun, ister yabancı olarak aranızda yaşayan bir garip olsun, hiçbir iş yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Çünkü o gün sizi arındırmak üzere sizin için kefaret edilecek. Yahve'nin önünde bütün günahlarınızdan arınacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Bu sizin için tam bir dinlenme Şabatı'dır ve canlarınızı sıkıntıya sokacaksınız. Bu daima sürecek bir kuraldır. ");
INSERT INTO turytc_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Babasının yerine kâhin olmak üzere meshedilen ve atanan kâhin, kefareti gerçekleştirecek ve keten giysileri, kutsal giysileri giyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ondan sonra Kutsal Konut için kefaret edecek; Buluşma Çadırı ile sunak için kefaret edecek; kâhinler ve topluluktaki tüm halk için kefaret edecek. ");
INSERT INTO turytc_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Bu, İsrael'in çocuklarının bütün günahlarından dolayı yılda bir kez onlara kefaret etmen için senin için kalıcı bir kural olacak.” Bu, Yahve'nin Moşe'ye buyurduğu gibi yapıldı. ");
INSERT INTO turytc_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aron'la, oğullarıyla ve tüm İsrael'in çocuklarıyla konuş ve onlara de: 'Yahve'nin buyruğu şudur: ");
INSERT INTO turytc_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","İsrael evinden kim olursa olsun, ordugâhta bir boğayı, kuzuyu ya da keçiyi kesen ya da ordugâhın dışında kesen kişi, ");
INSERT INTO turytc_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Yahve'nin Konutu'nun önünde Yahve'ye sunu olarak sunmak üzere onu Buluşma Çadırı'nın kapısına getirmemişse; kanı o insana sayılacaktır; kan dökmüştür; o kişi halkının arasından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Bu, İsrael'in çocuklarının kırda kestikleri kurbanlarını Yahve'ye, Buluşma Çadırı'nın kapısına, kâhine getirebilmeleri ve onları Yahve'ye esenlik sunuları kurbanı olarak sunabilmeleri içindir. ");
INSERT INTO turytc_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kâhin kanı Buluşma Çadırı'nın kapısındaki Yahve'nin sunağı üzerine serpecek ve yağını Yahve'ye hoş koku olarak yakacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Artık ardlarınca zina ettikleri keçi putlarına kurban kesmeyecekler. Bu, onlara kuşaklar boyunca daima geçerli olacak bir kural olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Onlara diyeceksiniz ki, 'İsrael evinden ya da aralarında yabancı olarak yaşayan yabancılardan biri yakmalık sunu ya da kurban sunar, ");
INSERT INTO turytc_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","eğer kurbanı Yahve'ye sunmak üzere Buluşma Çadırı'nın kapısına getirmezse, o kişi halkının arasından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“'İsrael evinden ya da onların arasında yabancı olarak yaşayan yabancılardan her kim herhangi bir çeşit kan yerse, kan yiyen cana karşı yüzümü çevireceğim ve onu kendi halkının arasından atacağım. ");
INSERT INTO turytc_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Çünkü etin yaşamı kandadır. Ben onu sunak üzerinde canlarınıza kefaret etmek için size verdim; çünkü yaşamdan ötürü kefaret eden kandır. ");
INSERT INTO turytc_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Bu nedenle İsrael'in çocuklarına dedim: “Aranızda hiç kimse kan yemesin, aranızda yabancı olarak yaşayan hiçbir yabancı da kan yemesin.” ");
INSERT INTO turytc_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“'İsrael'in çocuklarından ya da aralarında yabancı olarak yaşayan yabancılardan kim olursa olsun, yenilebilir bir hayvan ya da kuş avlarsa, onun kanını akıtacak ve onu toprakla örtecektir. ");
INSERT INTO turytc_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Çünkü her etin yaşamına gelince, onun kanı yaşamıyladır. Bu nedenle İsrael'in çocuklarına şöyle dedim: “Hiçbir çeşit etin kanını yemeyeceksiniz; çünkü her çeşit etin yaşamı onun kanıdır. Onu her yiyen atılacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“'İster yerli ister yabancı olsun, kendiliğinden ölen ya da hayvanların parçaladığı hayvanı yiyen herkes giysilerini yıkayacak, suda yıkanacak ve akşama kadar kirli olacaktır. O zaman temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ancak eğer onları yıkamaz ya da bedenini yıkamazsa, o zaman kötülüğünü taşıyacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Ben Tanrınız Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","İçinde yaşamış olduğunuz Mısır diyarında onların yaptığı gibi yapmayacaksınız. Sizi götürmekte olduğum Kenan diyarında onların yaptığı gibi yapmayacaksınız. Onların kurallarını izlemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","İlkelerimi yerine getireceksiniz. Kurallarımı tutacak ve onların içinde yürüyeceksiniz. Ben Tanrınız Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Bu nedenle kurallarımı ve ilkelerimi tutacaksınız; eğer bir kişi bunları yaparsa, onlarla yaşayacaktır. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“'Hiçbiriniz çıplaklığını açmak için yakın akrabasına yaklaşmayacaktır; ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“'Babanın çıplaklığını, annenin çıplaklığını açmayacaksın; o senin annendir. Onun çıplaklığını açmayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“'Babanın karısının çıplaklığını açmayacaksın. O senin babanın çıplaklığıdır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“'Kız kardeşinin, babanın kızının, ya da annenin kızının, ister evde ister dışarıda doğmuş olsun, çıplaklığını açmayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“'Senin oğlunun kızının ya da kendi kızının kızının çıplaklığını, onların çıplaklığını açmayacaksın; çünkü onlarınki senin kendi çıplaklığındır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“'Babanın karısının babandan olan kızının çıplaklığını açmayacaksın, çünkü o senin kız kardeşindir.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“'Babanın kız kardeşinin çıplaklığını açmayacaksın. O, babanın yakın akrabasıdır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“'Annenin kız kardeşinin çıplaklığını açmayacaksın; çünkü o, annenin yakın akrabasıdır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“'Babanın kardeşinin çıplaklığını açmayacaksın. Onun karısına yaklaşmayacaksın. O senin yengendir.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“'Kendi gelininin çıplaklığını açmayacaksın. O, oğlunun karısıdır. Onun çıplaklığını açmayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“'Kardeşinin karısının çıplaklığını açmayacaksın. O kardeşinin çıplaklığıdır. ");
INSERT INTO turytc_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“'Bir kadının ve onun kızının çıplaklığını açmayacaksın. Çıplaklığını açmak için onun oğlunun kızını ya da kızının kızını almayacaksın. Onlar yakın akrabadır. Bu kötülüktür. ");
INSERT INTO turytc_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“'Kız kardeşi hayattayken, çıplaklığını açmak için ona rakip olarak kardeşini eş olarak almayacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“'Bir kadına, âdet kirliliğindeyken, çıplaklığını açmak için yaklaşmayacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“'Komşunun karısıyla yatmayacaksın ve onunla birlikte kendini kirletmeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“'Çocuklarınızdan hiçbirini Molek'e kurban olarak vermeyeceksin. Tanrınız'ın adına saygısızlık etmeyeceksin. Ben Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“'Bir erkekle kadınla yatar gibi yatmayacaksın. Bu iğrenç bir şeydir.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“'Kendini kirletmek için hiçbir hayvanla yatmayacaksın. Hiçbir kadın kendini bir hayvana verip onunla yatmayacak; bu sapkınlıktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“'Bu şeylerin hiçbiriyle kendinizi kirletmeyin; çünkü önünüzden kovmakta olduğum bu ulusların hepsi bu şeylerle kirlendiler. ");
INSERT INTO turytc_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ülke kirletildi. Bu yüzden onun kötülüğünü cezalandırdım ve ülke kendi sakinlerini kustu. ");
INSERT INTO turytc_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Bu nedenle kurallarımı ve ilkelerimi tutacaksınız; ne yerli, ne de aranızda garip olarak yaşayan yabancılar bu iğrençliklerin hiçbirini yapmayacak, ");
INSERT INTO turytc_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(çünkü sizden önceki ülke halkı bütün bu iğrençlikleri yapmışlardı ve ülke kirlenmişti), ");
INSERT INTO turytc_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ta ki, siz onu kirlettiğinizde, sizden önceki ulusu kustuğu gibi, ülke sizi de kusmasın.'” ");
INSERT INTO turytc_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“'Kim bu iğrençliklerden birini yaparsa, onları yapan canlar halkının arasından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Bu nedenle, sizden önce yapılan bu iğrenç törelerin hiçbirini yapmamanız ve bunlarla kendinizi kirletmemeniz için buyruklarımı tutacaksınız. Ben Tanrınz Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“İsrael'in çocuklarının bütün topluluğuna söyle ve onlara de: 'Kutsal olacaksınız; çünkü ben, Tanrınız Yahve, kutsalım.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘Her biriniz annesine ve babasına saygı göstersin. Şabatlarımı tutacaksınız. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“'Putlara dönmeyin, kendinize dökme ilâhlar yapmayın. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“'Yahve'ye esenlik kurbanı sunacağınız zaman, kabul edilesiniz diye onu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","O, sunduğunuz gün ve ertesi gün yenilecek. Üçüncü güne kadar bir şey kalırsa ateşle yakılacak. ");
INSERT INTO turytc_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Üçüncü günde bir parça bile yenirse bu iğrençtir. Kabul edilmeyecektir; ");
INSERT INTO turytc_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ve onu yiyen herkes kendi kötülüğünü yüklenecektir; çünkü o, Yahve'nin kutsal şeyini kirletmiştir ve o can, halkının arasından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“'Toprağınızın hasadını biçtiğinizde, tarlanızın köşelerini tamamıyla biçmeyeceksiniz, ve hasadınızın kırıntılarını da toplamayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Bağınızı toplamayacaksınız ve bağınızın yere düşmüş üzümlerini toplamayacaksınız. Onları yoksul ve yabancı için bırakacaksın. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“'Çalmayacaksın.'” “'Yalan söylemeyeceksin. “‘Birbirinizi kandırmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“'Benim adımla yalan yere ant içmeyeceksin ve Tanrın'ın adını kirletmeyeceksin. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“'Komşuna zulmetmeyeceksin, onu soymayacaksın.'” “‘Ücretli bir hizmetçinin ücretini bütün gece sabaha kadar yanında tutmayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“'Sağıra lanet etmeyeceksin, körün önüne tökezleme taşı koymayacaksın; ama Tanrınız'dan korkacaksınız. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“'Yargılarken haksızlık yapmayacaksın. Yoksula karşı taraf tutmayacaksın, büyükleri kayırmayacaksın; komşunu ise adaletle yargılayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“'Halkının arasında iftiracı olarak dolaşmayacaksın.'” “‘Komşunun hayatını tehlikeye atmayacaksın. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“'Yüreğinde kardeşinden nefret etmeyeceksin. Komşunu mutlaka azarlayacaksın ve onun yüzünden günah taşımayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“'Öç almayacaksın, halkının çocuklarına kin tutmayacaksın, komşunu ise kendin gibi seveceksin. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“'Kurallarımı tutacaksın. “‘Farklı türden hayvanları çiftleştirmeyeceksin. “‘Tarlana iki çeşit tohum ekmeyeceksin; “‘İki çeşit malzemeden yapılmış giysi giymeyin. ");
INSERT INTO turytc_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“'Bir adam, başka bir adamla nişanlı olan, ancak fidye ödenmemiş ya da özgürlüğüne kavuşturulmamış bir cariye kadınla yatarsa; cezalandırılacaklar. Öldürülmeyecekler, çünkü kadın özgür değildir. ");
INSERT INTO turytc_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Yahve'ye suç sunusunu, Buluşma Çadırı'nın kapısına, suç sunusu olarak bir koç getirecek. ");
INSERT INTO turytc_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kâhin, işlediği günahtan dolayı Yahve'nin önünde suç sunusu koçuyla onun için kefaret edecek; işlediği günah kendisine bağışlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“'Ülkeye gelip yiyecek olarak her çeşit ağacı diktiğinizde, onların meyvelerini yasak sayacaksınız. Üç yıl boyunca size yasak olacak. Yenilmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ama dördüncü yılda bütün meyvesi Yahve'ye övgü sunmak için kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Beşinci yıl meyvesini yiyeceksiniz ki, size bol ürün versin. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“'Kanı hâlâ içinde olan et yemeyeceksin. Büyü yapmayacaksınız ve büyücülükle uğraşmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“'Başınızın yanlarındaki saçları kesmeyeceksiniz, sakalınızın kenarlarını düzeltmeyeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“'Ölüler için bedeninizi yaralamayacaksınız, üzerinize dövme işareti yapmayacaksınız. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“'Kızını fahişe ederek onu kirletme; öyle ki, ülke fuhuş edip diyar kötülükle dolmasın.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“'Şabatlarımı tutacaksınız ve konutuma saygı göstereceksiniz; Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“'Medyumlara ya da büyücülere yönelmeyin. Onları aramayın, onlar tarafından kirletilmeyin. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“'Ak saçlının önünde ayağa kalkacaksın, yaşlıların yüzüne hürmet edeceksin; Tanrın'dan korkacaksın. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“'Eğer bir yabancı ülkenizde sizinle birlikte garip olarak yaşıyorsa, ona haksızlık etmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Sizinle yabancı olarak yaşayan garip, sizin için aranızda doğmuş biri gibi olacak ve onu kendin gibi seveceksin; çünkü Mısır diyarında yabancı olarak yaşadınız. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“'Yargıda, uzunluk, ağırlık ya da miktar ölçülerinde haksızlık etmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Sizde bulunan terazi doğru, tartı doğru, efa doğru, hin doğru olacak. Ben sizi Mısır diyarından çıkaran Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“'Bütün kurallarımı, bütün ilkelerimi tutacaksınız ve onları yapacaksınız. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ayrıca İsrael'in çocuklarına şunu söyle: 'İsrael'in çocuklarından ya da İsrael'de garip olarak yaşayan yabancılardan Molek'e soyundan birini veren her kişi, kesinlikle öldürülecektir. Ülke halkı o kişiyi taşlayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ben de o insana karşı yüzümü çevireceğim ve onu halkının arasından atacağım; çünkü o, kutsal yerimi kirletmek ve kutsal adımı lekelemek için soyundan Molek'e vermiştir. ");
INSERT INTO turytc_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Eğer o kişi çocuğunu Molek'e verirken ülke halkı o kişiyi görmezlikten gelir ve onu öldürmezlerse, ");
INSERT INTO turytc_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","o zaman o insana ve ailesine karşı yüzümü çevireceğim ve onu ve onun ardınca Molek'le fahişelik yapmak üzere fahişelik edenlerin hepsini halkının arasından atacağım.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“'Medyumlara ve büyücülere yönelip onların ardından fahişelik yapan insana karşı da yüzümü çevireceğim ve onu halkının arasından atacağım.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“'Bunun için kendinizi kutsal kılın ve kutsal olun; çünkü ben Tanrınız Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kurallarımı tutacak ve onları yapacaksınız. Sizi kutsal kılan Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“'Babasına ya da annesine lanet eden herkes kesinlikle öldürülecektir. Babasına ya da annesine lanet etmiştir. Onun kanı kendi üzerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“'Başka birinin karısıyla zina eden kişi, komşusunun karısıyla zina eden kişi, zina eden adam da, zina eden kadın da kesinlikle öldürülecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“'Babasının karısıyla yatan, babasının çıplaklığını açmıştır. Her ikisi de kesinlikle öldürülecektir. Onların kanı kendi üzerlerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“'Bir adam geliniyle yatarsa, ikisi de kesinlikle öldürülecektir. Sapkınlık yaptılar. Onların kanı kendi üzerlerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“'Eğer bir adam bir kadınla yatar gibi bir erkekle yatarsa, ikisi iğrençlik etmiştir. Kesinlikle öldürülecekler. Onların kanı kendi üzerlerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“'Bir adam bir kadınla birlikte annesini alırsa, bu kötülüktür. Aranızda kötülük olmasın diye, hem kendisi hem de onlar ateşte yakılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“'Bir kişi bir hayvanla yatarsa kesinlikle öldürülecektir; hayvanı da öldüreceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“'Eğer bir kadın herhangi bir hayvana yaklaşıp onunla yatarsa, kadını da hayvanı da öldüreceksiniz. Kesinlikle öldürülecekler. Kanları onların üzerinde olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“'Bir adam kız kardeşini, babasının kızını ya da annesinin kızını alır ve onun çıplaklığını görürse, kadın da onun çıplaklığını görürse, bu utanç verici bir şeydir. Halklarının çocuklarının gözü önünde atılacaklardır. Kız kardeşinin çıplaklığını açmıştır. Kötülüğüne katlanacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“'Eğer bir adam âdet gören bir kadınla yatar ve onun çıplaklığını açarsa, onun pınarını çıplak etmiştir, kadın da kendi kan pınarını çıplak etmiştir. İkisi de kendi halkının arasından atılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“'Kendi annenin kız kardeşinin ya da babanın kız kardeşinin çıplaklığını açmayacaksın; çünkü o, yakın akrabasını çıplak etmiştir. Onlar kötülüklerini taşıyacaklar.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Bir adam amcasının karısıyla yatarsa, amcasının çıplaklığını açmıştır. Günahlarına katlanacaklar. Çocuksuz öleceklerdir. ");
INSERT INTO turytc_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“'Bir adam kardeşinin karısını alırsa, bu kirliliktir. Kardeşinin çıplaklığını açmıştır. Çocuksuz olacaklardır.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“'Bütün kurallarımı, bütün ilkelerimi tutacaksın ve onları yapacaksın; öyle ki, orada oturmak üzere sizi götürmekte olduğum ülke sizi dışa kusmasın. ");
INSERT INTO turytc_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Önünüzden kovacağım ulusun töreleri içinde yürümeyeceksiniz; çünkü bütün bunları onlar yaptılar ve bu yüzden onlardan tiksindim. ");
INSERT INTO turytc_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ama ben size, “Onların topraklarını miras alacaksınız, ben de onu, süt ve bal akan ülkeyi mülk olarak size vereceğim” dedim. Sizi halklardan ayıran Tanrınız Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“'Bu nedenle temiz hayvanla kirli olanı, kirli kuşla temiz olanı birbirinden ayıracaksınız. Sizin için kirli diye sizden ayırdığım hayvanlarla, kuşlarla ya da yerde sürünen hiçbir şeyle kendinizi iğrenç kılmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Benim için kutsal olacaksınız; çünkü ben, Yahve, kutsalım ve benim olasın diye seni halkların arasından ayırdım.'” ");
INSERT INTO turytc_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“'Medyum ya da büyücü olan erkek ya da kadın kesinlikle öldürülecektir. Onlar taşlanacaklar. Onların kanı kendi üzerlerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahve Moşe'ye şöyle dedi: “Aron'un oğullarıyla, kâhinlerle konuş ve onlara söyle: 'Kâhin halkının ölüleri için kendini şunlar dışında kirletmeyecektir: ");
INSERT INTO turytc_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Kendisine yakın olan akrabalarından annesi için, babası için, oğlu için, kızı için, erkek kardeşi için, ");
INSERT INTO turytc_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ve kendisine yakın olan, kocaya varmamış, el değmemiş kız kardeşi için kendisini kirletebilir. ");
INSERT INTO turytc_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Halkı arasında bir önder olarak kendisini lekelemek üzere kendisini kirletmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“'Başlarını tıraş etmeyecekler, sakallarının kenarlarını tıraş etmeyecekler, bedenlerinde yara açmayacaklar. ");
INSERT INTO turytc_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kendi Tanrıları'na kutsal olacaklar ve Tanrıları'nın adına saygısızlık etmeyecekler; çünkü Yahve'nin ateşle yapılan sunularını, Tanrıları'nın ekmeğini onlar sunuyorlar. Bu nedenle kutsal olacaklar.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘Fahişe ya da lekelenmiş kadınla evlenmeyecekler. Bir kâhin kocasından boşanmış bir kadınla evlenmeyecektir; çünkü o, Tanrısı'na kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Bu nedenle onu kutsal kılacaksın; çünkü Tanrınız'ın ekmeğini o sunuyor. O sizin için kutsal olacaktır; çünkü sizi kutsal kılan ben Yahve, kutsalım.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“'Herhangi bir kâhinin kızı, fahişelik ederek kendini lekelerse, babasını lekelemiş olur. Kız ateşle yakılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“'Kardeşleri arasında başkâhin olan, başına mesh yağı dökülen ve giysileri giymek için atanan kişi, saçlarını çözmeyecek, ya da giysilerini yırtmayacak. ");
INSERT INTO turytc_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hiçbir ölünün yanına girmeyecek, babası ya da annesi için kendini kirletmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Konutun dışına çıkmayacak, Tanrısı'nın konutunu kirletmeyecek; çünkü Tanrısı'nın mesh yağının tacı onun üzerindedir. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“'Eş olarak alacağı el değmemiş kız olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Dul bir kadınla, boşanmış biriyle, kirletilmiş bir kadınla, ya da fahişeyle evlenmeyecek. Kendi halkından el değmemiş bir kızı kendine eş olarak alacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kendi halkının arasında soyunu lekelemeyecek; çünkü onu kutsal kılan Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Aron'a söyle: 'Senin soyundan kuşaklar boyunca kusurlu olan hiç kimse Tanrısı'nın ekmeğini sunmak için yaklaşmasın. ");
INSERT INTO turytc_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kusurlu kim olursa olsun, yaklaşmayacak: Kör, ya da topal, yassı burunlu, ya da herhangi bir şekil bozukluğu olan, ");
INSERT INTO turytc_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ya da ayağı kırık, ya da eli kırık olan, ");
INSERT INTO turytc_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ya da kambur, ya da cüce, ya da gözü kusurlu, ya da kaşıntısı olan, ya da kabuklu, ya da testislerinde hasar olan. ");
INSERT INTO turytc_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kâhin Aron'un soyundan kusurlu olan hiç kimse, Yahve'ye ateşle yapılan sunuları sunmak üzere yaklaşmayacak. Bir kusuru olduğundan, Tanrısı'nın ekmeğini sunmaya yaklaşmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Tanrısı'nın ekmeğinden, hem çok kutsal olandan, hem de kutsal olandan yiyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Bir kusuru olduğundan perdeye ve sunağa yaklaşmayacak; ta ki, kutsal yerlerimi kirletmesin; çünkü onları kutsal kılan Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Böylece Moşe Aron'la, oğullarıyla ve bütün İsrael'in çocuklarıyla konuştu. ");
INSERT INTO turytc_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Aron'la oğullarına söyle, İsrael'in çocuklarının bana kutsal kıldıkları kutsal şeylerden kendilerini sakınsınlar ve kutsal adıma saygısızlık etmesinler. Ben Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Onlara söyle, 'Kuşaklarınız boyunca bütün soyunuzdan her kim, İsrael'in çocuklarının Yahve'ye kutsal kıldığı kutsal şeylere kirliliği üzerinde olarak yaklaşırsa, o can benim önümden atılacaktır. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“'Aron'un soyundan cüzzamlı ya da akıntısı olan kişi temiz oluncaya dek kutsal şeylerden yemeyecek. Kim ölü nedeniyle kirli olmuş bir şeye, ya da meni çıkmış bir adama dokunursa, ");
INSERT INTO turytc_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ya da kim kendisini kirletecek sürünen bir şeye, ya da kirliliği ne olursa olsun insanı kirleten bir insana dokunursa, ");
INSERT INTO turytc_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","böyle bir şeye dokunan akşama kadar kirli sayılacak ve bedenini suda yıkamadıkça kutsal şeylerden yemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Güneş battığında temiz olacak; ondan sonra kutsal şeylerden yiyecektir, çünkü bu onun ekmeğidir. ");
INSERT INTO turytc_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kendiliğinden ölmüş, ya da hayvanlar tarafından parçalanmış hayvanın leşini, onunla kendisini kirletmek üzere yemeyecektir. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“'Bu nedenle, buyruğumu bozarlarsa günah yüklenmesinler ve onun içinde ölmesinler diye, buyruklarımı izleyecekler. Onları kutsal kılan Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“'Hiçbir yabancı kutsal şeyden yemeyecek; kâhinlerin yanında yaşayan bir yabancı, ya da ücretli bir hizmetçi kutsal şeyden yemeyecek. ");
INSERT INTO turytc_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ancak eğer kâhin, kendi parasıyla bir hizmetçi satın alırsa, ondan yiyecektir; onun evinde doğanlar onun ekmeğinden yiyeceklerdir. ");
INSERT INTO turytc_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Bir kâhinin kızı yabancı biriyle evliyse, kutsal şeylerin kaldırma sunularından yemeyecek. ");
INSERT INTO turytc_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ama bir kâhinin kızı dulsa ya da boşanmışsa, çocuğu yoksa ve gençliğinde olduğu gibi babasının evine dönmüşse, babasının ekmeğinden yiyebilir; ama hiçbir yabancı ondan yemeyecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“'Eğer bir kişi bilmeden kutsal bir şey yerse, o zaman ona değerinin beşte birini ekleyecek ve kutsal şeyi kâhine verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kâhinler İsrael'in çocuklarının Yahve'ye sundukları kutsal şeyleri bozmayacaklar, ");
INSERT INTO turytc_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","böylece kutsal şeyleri yediklerinde suçluluk duygusu getirecek kötülüğü onlara yükletirler; çünkü onları kutsal kılan Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aron'la, oğullarıyla ve bütün İsrael'in çocuklarıyla konuş ve onlara söyle: 'İsrael evinden ve İsrael'de olan yabancılardan kim olursa olsun, Yahve'ye yakmalık sunu olarak sundukları, ister adaklarından biri olsun, ya da ister gönüllü sunularından biri olsun, sunusunu sunduğu zaman, ");
INSERT INTO turytc_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kabul edilesiniz diye, boğalardan, koyunlardan, ya da keçilerden kusursuz bir erkek sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ama kusurlu olanı sunmayacaksınız; çünkü o sizin için kabul edilebilir olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kim bir adak ödemek için, Yahve'ye esenlik sunuları, ya da sığır, ya da davardan gönüllü bir kurban sunarsa, kabul edilmesi için kusursuz olacaktır. Hiçbir kusuru olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kör, yaralı, sakat, siğilli, iltihaplı ya da yarası açık olanı Yahve'ye sunmayacaksınız; bunları sunak üzerinde Yahve'ye ateşle sunmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Herhangi bir parçası fazla ya da eksik olan boğayı, ya da kuzuyu gönüllü sunulan sunu olarak sunabilirsiniz; ancak adak olarak kabul edilmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Testisleri vurulmuş, ezilmiş, burulmuş ya da kesilmiş olanı Yahve'ye sunmayacaksınız. Bunu diyarınızda yapmamalısınız. ");
INSERT INTO turytc_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bunlardan hiçbirini bir yabancının elinden Tanrınız'ın ekmeği olarak sunmayacaksınız; çünkü onların bozukluğu kendilerindedir. Onlarda kusur vardır. Bunlar sizin için kabul edilmeyecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Bir buzağı, kuzu ya da oğlak doğduğunda, annesiyle birlikte yedi gün kalacak. Sekizinci günden itibaren Yahve'ye ateşle yapılan sunu olarak kabul edilecektir. ");
INSERT INTO turytc_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","İster inek, ister koyun olsun, onu ve yavrusunu aynı günde kesmeyeceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Yahve'ye şükran kurbanı kurban edeceğiniz zaman, kabul edilesiniz diye onu kurban edeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Aynı günde yenilecektir; hiçbirini sabaha kadar bırakmayacaksınız. Ben Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Bu nedenle buyruklarımı tutacak ve yapacaksınız. Ben Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kutsal adıma saygısızlık etmeyeceksiniz, ama İsrael'in çocukları arasında kutsal kılınacağım. Seni kutsal kılan Yahve benim, ");
INSERT INTO turytc_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Tanrın olmak için seni Mısır'dan çıkardım. Ben Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Yahve'nin kutsal toplantılar olarak ilan edeceğiniz bayramları, benim bayramlarım bunlardır.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“'Altı gün iş yapılacak, ama yedinci gün tam dinlenme Şabat'ı, kutsal toplantı olacak; hiçbir iş yapmayacaksınız. Bütün konutlarınızda Yahve'ye Şabat'tır.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“'Bunlar, belirlenen vakitte ilan edeceğiniz Yahve'nin belirlediği bayramlar, kutsal toplantılardır. ");
INSERT INTO turytc_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Birinci ayın on dördüncü günü akşam Yahve'nin Pesah'ıdır. ");
INSERT INTO turytc_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Aynı ayın on beşinci günü Yahve'ye Mayasız Ekmek Bayramı'dır. Yedi gün mayasız ekmek yiyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Birinci günde kutsal toplantınız olacak. Olağan işleri yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Yahve'ye ateşle yapılan sunuyu ise yedi gün sunacaksınız. Yedinci gün kutsal toplantıdır. Olağan işleri yapmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“İsrael'in çocuklarına söyle ve onlara de: 'Size vereceğim ülkeye gelip ürününü biçeceğiniz zaman, o zaman hasadınızın ilk ürünlerinden oluşan demetini kâhine getireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Sizin için kabul edilsin diye demetini Yahve'nin önünde sallayacak. Kâhin onu Şabat'ın ertesi günü sallayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Demetini sallayacağın gün, yakmalık sunu olarak Yahve'ye bir yaşında kusursuz bir erkek kuzu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ekmek sunusuyla birlikte, Yahve'ye ateşle yapılan sunu, hoş koku olarak yağla yoğrulmuş onda iki efa ince un olacak; ve onunla birlikte dökmelik sunu da bir hinin dörtte biri kadar şaraptan olacak. ");
INSERT INTO turytc_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Bu aynı güne, Tanrınız'a sunu getirene kadar ekmek, kavrulmuş buğday ya da taze buğday yemeyeceksiniz. Bu, tüm konutlarınızda kuşaklar boyunca daima geçerli olacak bir kuraldır.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“'Şabat'ın ertesi gününden, sallama sunusu demetini getirdiğiniz günden itibaren sayacaksınız: Yedi Şabat tamamlanacak. ");
INSERT INTO turytc_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Yedinci Şabat'tan sonraki gün elli gün sayacaksın; ve Yahve'ye yeni ekmek sunusu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Yaşadığınız yerden sallama sunusu olarak onda iki efa ince undan yapılmış iki ekmek getireceksiniz. Bunlar Yahve'ye ilk ürünler olarak mayayla pişirilecek. ");
INSERT INTO turytc_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ekmekle birlikte bir yaşında kusursuz yedi kuzu, bir genç boğa ve iki koç sunacaksınız. Ekmek sunuları ve dökmelik sunularıyla birlikte bunlar, Yahve'ye yakmalık sunu, ateşle yapılan sunu, Yahve'ye hoş koku olacak. ");
INSERT INTO turytc_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Günah sunusu olarak bir teke, esenlik kurbanı olarak da bir yaşında iki erkek kuzu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kâhin onları sallamalık sunu olarak iki kuzuyla birlikte ilk ürünlerden oluşan ekmekle birlikte Yahve'nin önünde sallayacak. Kâhin için Yahve'ye kutsal olacaklar. ");
INSERT INTO turytc_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Aynı günde sizin için kutsal bir toplantı olacağını duyuracaksınız. Olağan işler yapmayacaksınız. Bu, kuşaklarınız boyunca tüm konutlarınızda daima geçerli olacak bir kuraldır. ");
INSERT INTO turytc_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“'Toprağınızın hasatını biçtiğinizde, tarlanızın köşelerini tamamen biçmemelisiniz, hasatınızın başaklarını toplamamalısınız. Bunları yoksullara ve yabancılara bırakmalısınız. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“İsrael'in çocuklarına söyle: 'Yedinci ayda, ayın birinci gününde sizin için tam bir dinlenme; boru sesiyle anma, kutsal toplantı olacak. ");
INSERT INTO turytc_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Olağan işler yapmayacaksınız. Yahve'ye ateşle yapılan sunu sunacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ancak bu yedinci ayın onuncu günü kefaret günüdür. Bu sizin için kutsal toplantı olacaktır. Kendinize acı çektireceksiniz ve Yahve'ye ateşle yapılan bir sunu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","O gün hiçbir iş yapmayacaksınız; çünkü bu, sizin için Tanrınız Yahve'nin önünde kefaret etmek üzere kefaret günüdür. ");
INSERT INTO turytc_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Çünkü o aynı günde kendini inkar etmeyen kişi halkından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kim o aynı günde herhangi bir iş yaparsa, onu halkının arasından yok edeceğim. ");
INSERT INTO turytc_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Hiçbir iş yapmayacaksınız; bu, tüm konutlarınızda kuşaklar boyunca daima geçerli olacak bir kuraldır. ");
INSERT INTO turytc_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Bu sizin için tam bir Şabat, dinlenme günü olacak ve kendinizi inkar edeceksiniz. Ayın dokuzuncu günü akşam üstü, bir akşamdan diğer akşama kadar Şabatınız'ı tutacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“İsrael'in çocuklarına söyle ve de: 'Bu yedinci ayın on beşinci günü Yahve için yedi günlük Çardak Bayramı'dır. ");
INSERT INTO turytc_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","İlk gün kutsal toplantı olacak. Olağan işleri yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Yedi gün Yahve'ye ateşle yapılan sunu sunacaksınız. Sekizinci gün size kutsal toplantı olacak. Yahve'ye ateşle yapılan sunu sunacaksınız. Bu tam toplantıdır; olağan işleri yapmayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“'Yahve'ye ateşle yapılan sunu, yakmalık sunu, ekmek sunusu, kurban ve dökmelik sunular sunmak için, her biri kendi gününde olmak üzere, kutsal toplantılar olarak ilan edeceğiniz Yahve'nin belirlenmiş bayramları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Yahve'nin Şabatları'na ek olarak, armağanlarınıza ek olarak, bütün adaklarınıza ek olarak, Yahve'ye gönülden verdiğiniz sunulara ek olarak, Yahve'ye verdiklerinizdir.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“'Yedinci ayın on beşinci günü, ülkenin ürünlerini topladığınızda, Yahve'nin bayramını yedi gün tutacaksınız. Birinci gün tam dinlenme olacak ve sekizinci gün tam dinlenme olacak. ");
INSERT INTO turytc_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Birinci gün heybetli ağaçların meyvelerini, palmiye ağaçlarının dallarını, sık ağaç dallarını ve dere söğütlerini alacaksınız; ve Tanrınız Yahve'nin önünde yedi gün sevineceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Bunu yılın yedi günü Yahve'ye bayram olarak tutacaksınız. Kuşaklarınız boyunca daima geçerli olacak bir kuraldır. Onu yedinci ayda tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Yedi gün boyunca geçici barınaklarda oturacaksınız. İsrael'de doğmuş olan herkes geçici barınaklarda oturacak; ");
INSERT INTO turytc_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ta ki, İsrael'in çocuklarını Mısır diyarından çıkardığımda onları geçici barınaklarda oturttuğumu sizin kuşaklarınız bilsin. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Böylece Moşe İsrael'in çocuklarına Yahve'nin belirlenmiş bayramlarını bildirdi. ");
INSERT INTO turytc_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“İsrael'in çocuklarına buyur ki, kandil sürekli yansın diye ışık için sana ezilmiş saf zeytinyağı getirsinler. ");
INSERT INTO turytc_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aron, tanıklık perdesinin dışında, Buluşma Çadırı'nda onu akşamdan sabaha dek sürekli olarak Yahve'nin önünde tutacak. Kuşaklarınız boyunca daima geçerli bir kural olacak. ");
INSERT INTO turytc_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Yahve'nin önündeki saf altın şamdanlık üzerindeki kandilleri sürekli olarak düzende tutacaktır.” ");
INSERT INTO turytc_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“İnce undan alıp on iki pide pişireceksin; bir pidede efanın onda ikisi olacak. ");
INSERT INTO turytc_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Onları iki sıra halinde, altışar tane olmak üzere Yahve'nin önünde saf altın masanın üzerine koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Her sıranın üzerine saf buhur koyacaksın; böylece ekmek için anılma, Yahve'ye ateşle yapılan sunu olsun. ");
INSERT INTO turytc_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Her Şabat'ta onu sürekli olarak Yahve'nin önünde hazırlayacak. Bu, İsrael'in çocukları adına kalıcı bir antlaşmadır. ");
INSERT INTO turytc_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Aron'la oğulları için olacak. Onu kutsal bir yerde yiyecekler; çünkü sürekli bir kuralla Yahve'nin ateşle yapılan sunularından kendisi için çok kutsaldır.” ");
INSERT INTO turytc_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Babası Mısırlı olan İsraelli bir kadının oğlu, İsrael'in çocukları arasına çıktı; İsraelli kadının oğluyla İsraelli bir adam ordugâhta kavga ettiler. ");
INSERT INTO turytc_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","İsraelli kadının oğlu Ad'a küfretti; ve onu Moşe'ye getirdiler. Annesinin adı Dan oymağından Divri'nin kızı Şelomit'ti. ");
INSERT INTO turytc_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Yahve'nin isteği kendilerine bildirilene kadar onu gözaltında tuttular. ");
INSERT INTO turytc_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Lanet edeni ordugâhın dışına çıkar; ve onu duyan herkes ellerini onun başı üzerine koysun ve bütün topluluk onu taşlasın. ");
INSERT INTO turytc_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","İsrael'in çocuklarına şöyle diyeceksin: 'Kim Tanrısı'na lanet ederse, günahını yüklenecektir. ");
INSERT INTO turytc_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Yahve'nin adına küfreden, kesinlikle öldürülecektir. Bütün topluluk onu mutlaka taşlayacaktır. Ad'a küfreden yabancı olsun, yerli olsun öldürülecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“'Bir insana ölümcül darbe vuran kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Bir hayvana ölümcül bir darbe vuran, bedelini ödeyecek, yaşama karşılık yaşam verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kim komşusunu yaralarsa, ona da onun yaptığının aynısı yapılacak: ");
INSERT INTO turytc_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kırığa karşılık kırık, göze karşılık göz, dişe karşılık diş. Birini nasıl yaraladı ise, kendisine de öyle yapılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Hayvanı öldüren onu ödeyecek; adam öldüren, öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Yerli için de, yabancı için de, tek bir yasa olacak; çünkü ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moşe İsrael'in çocuklarıyla konuştu; lanet edeni ordugâhın dışına çıkarıp taşladılar. İsrael'in çocukları Yahve'nin Moşe'ye buyurduğu gibi yaptılar. ");
INSERT INTO turytc_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahve Sina Dağı'nda Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“İsrael'in çocuklarına söyle ve onlara de: 'Size vermekte olduğum ülkeye girdiğinizde, diyar Yahve'ye Şabat tutacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Tarlanızı altı yıl ekeceksin, bağınızı altı yıl budayıp ürünlerini toplayacaksın; ");
INSERT INTO turytc_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ama yedinci yılda ülke için tam dinlenme Şabat'ı, Yahve'ye Şabat olacak. Tarlanı ekmeyecek, bağını budamayacaksın. ");
INSERT INTO turytc_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hasadında kendiliğinden yetişeni biçmeyeceksin, ve budanmamış asmanın üzümlerini toplamayacaksın. Ülke için tam dinlenme yılı olacak. ");
INSERT INTO turytc_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ülkenin Şabat'ı sizin için, kendin için, hizmetçin için, kadın hizmetçin için, ücretli hizmetçin için, garibin için, seninle birlikte yaşayan yabancı için yiyecek olacak. ");
INSERT INTO turytc_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Onun bütün ürünü senin sığırların, diyarda bulunan hayvanların için de yiyecek olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“'Yedi yıl, yedi kere yedi yılların Şabat'larını sayacaksın; ve senin için yılların Şabat'larının günleri, kırk dokuz yıl olacak. ");
INSERT INTO turytc_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","O zaman yedinci ayın onuncu günü yüksek sesle boru çalacaksınız. Kefaret Günü'nde bütün ülkenizde boru çalacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ellinci yılı kutsal kılacaksınız ve ülke sakinlerinin hepsine özgürlük ilan edeceksiniz. Bu sizin için bir jübile olacak; ve her biriniz kendi mülküne, her biriniz kendi ailesine dönecek. ");
INSERT INTO turytc_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","O ellinci yıl size jübile olacak. Onun içinde ekim yapmayacaksınız, kendiliğinden yetişenleri biçmeyeceksiniz ve budanmamış asmayı toplamayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Çünkü jübiledir; sizin için kutsal olacaktır. Onun ürününü tarladan yiyeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“'Bu Jübile Yılı'nda her biriniz kendi mülküne dönecek.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“'Komşuna bir şey satarsan ya da komşundan satın alırsan, birbirinize haksızlık etmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jübile'den sonraki yıl sayısına göre komşundan satın alacaksın. Ürünlerin yıl sayısına göre sana satacak. ");
INSERT INTO turytc_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Yılların uzunluğuna göre bedelini artıracaksın, yılların kısalığına göre de bedelini azaltacaksın; çünkü o sana ürünlerinin sayısını satıyor. ");
INSERT INTO turytc_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Birbirinize haksızlık yapmayacaksınız, tersine Tanrınız'dan korkacaksınız; çünkü ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“'Bu nedenle kurallarımı yapacaksınız, ilkelerimi tutacaksınız ve onları yapacaksınız; ülkede güvenlik içinde oturacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Toprak ürününü verecek, siz de doyana kadar yiyeceksiniz ve orada güvenlik içinde oturacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Eğer: “İşte, ekmeyeceğiz ve ürünümüzü toplamayacağız; yedinci yıl ne yiyeceğiz?” derseniz; ");
INSERT INTO turytc_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","o zaman altıncı yılda kutsamamı üzerinize buyuracağım ve üç yıllık ürün verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Sekizinci yıl ekim yapacaksın ve dokuzuncu yıla kadar ambarın eski ürününden yiyeceksin. Ürünü gelinceye kadar eski ambardan yiyeceksin.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“'Toprak temelli olarak satılmayacak, çünkü toprak benimdir; çünkü siz yabancısınız ve benim yanımda konuklarsınız. ");
INSERT INTO turytc_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Mülkünüz olan tüm topraklarda, toprak için fidye kabul edeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“'Eğer kardeşin yoksullaşır ve mülklerinin bir kısmını satarsa, kendisine en yakın akrabası gelip kardeşinin sattığını geri alacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Eğer bir adamın onu geri alacak kimsesi yoksa ve bolluğa kavuşup onu geri almak için yeterli yolu bulursa, ");
INSERT INTO turytc_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","o zaman satışından bu yana geçen yılları hesaplasın ve arta kalan kısmı onu sattığı adama geri ödesin; ve mülküne dönecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ama eğer onu geri alamazsa, sattığı şey Jübile Yılı'na kadar onu satın alanın elinde kalacaktır. Jübile'de serbest bırakılacak ve o, mülküne geri dönecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“'Eğer bir adam surlarla çevrili bir kentte oturduğu evi satarsa, satıldıktan sonraki tam bir yıl içinde onu geri alabilir. Tam bir yıl boyunca onu geri alma hakkına sahip olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Eğer bir yıl içinde geri almazsa, surlarla çevrili kentteki ev, onu satın alan insana kuşaklar boyu temelli olarak kalacaktır. Jübile'de serbest kalmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ama çevrelerinde duvar olmayan köylerin evleri ülkenin kırlarıyla bir sayılacaktır; bedeli ödenebilir ve Jübile'de serbest bırakılacaklardır.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“'Ancak Levililer'in kentleri, mülkleri olan kentlerdeki evlerini, Levililer istedikleri zaman geri alabilirler. ");
INSERT INTO turytc_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Levililer mülkü olan kentteki satılmış evi geri alabilirler, Jübile'de serbest bırakılacaktır, çünkü Levililer'in kentlerdeki evleri İsrael'in çocukları arasında onların mülküdür. ");
INSERT INTO turytc_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ama onların kentlerindeki otlaklar satılamaz; çünkü orası onların daimi mülküdür.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“'Kardeşin yoksul düştüyse ve eli aranızda kendini geçindiremiyorsa, ona destek olacaksın. O, sizinle bir yabancı ve konuk gibi yaşayacak. ");
INSERT INTO turytc_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ondan ne faiz ne de kâr alın; tersine Tanrınız'dan korkun ki, kardeşiniz aranızda yaşasın. ");
INSERT INTO turytc_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ona paranızı faizle ödünç vermeyeceksin, yiyeceklerini de kâr amacıyla ona vermeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kenan diyarını size vermek ve Tanrınız olmak için sizi Mısır diyarından çıkaran Tanrınız Yahve benim.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“'Eğer kardeşiniz aranızda yoksullaşır ve kendini size satarsa, onu köle gibi hizmet ettirmeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Yanında ücretli bir hizmetçi ve konuk gibi olacak; Jübile Yılı'na kadar yanında hizmet edecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Sonra kendisi ve çocukları senin yanından çıkıp kendi ailesinin ve atalarının mülküne dönecek. ");
INSERT INTO turytc_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Çünkü onlar Mısır diyarından çıkardığım hizmetkârlarımdır. Köle olarak satılmayacaklardır. ");
INSERT INTO turytc_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ona sertlikle hükmetmeyeceksin, ancak Tanrın'dan korkacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“'Çevrenizdeki uluslardan sahip olduğunuz erkek ve kadın kölelerinize gelince, onlardan erkek ve kadın köleler satın alabilirsiniz. ");
INSERT INTO turytc_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ayrıca aranızda yaşayan yabancıların çocuklarından ve onların sizinle birlikte olan ailelerinden ülkenizde doğmuş olanları satın alabilirsiniz; onlar da sizin mülkünüz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Bunları sizden sonra çocuklarınıza mülk olarak miras bırakabilirsiniz. Kölelerinizi sonsuza kadar onlardan alabilirsiniz, ama kardeşleriniz İsrael'in çocuklarına, birbirinize sertlikle hükmetmeyeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“'Aranızda yaşayan bir yabancı ya da konuk olan biri zenginleşirse, yanındaki kardeşin de yoksul düşer ve kendisini aranızda yaşayan bir yabancıya ya da konuğun aile üyesinden birine satarsa, ");
INSERT INTO turytc_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","satıldıktan sonra o geri alınabilir. Kardeşlerinden biri geri alabilir; ");
INSERT INTO turytc_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ya da amcası, ya da amcasının oğlu, onu geri alabilir, ya da ailesinden ona yakın akrabası olan biri onun fidyesini verebilir; ya da eğer o zenginleşirse kendisi için fidye verebilir. ");
INSERT INTO turytc_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kendisini satın alan kişiyle, ona kendisini sattığı yıldan Jübile Yılı'na kadar hesap görecektir. Satışının bedeli yılların sayısına göre olacaktır; onun yanında ücretli bir hizmetçinin zamanı gibi olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Eğer daha uzun yıllar varsa, onlara göre, satın alındığı paradan özgürlüğünün bedelini geri verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Jübile Yılı'na yalnızca birkaç yıl kalmışsa, o zaman onunla hesap görecek; hizmet yıllarına göre özgürlüğünün bedelini geri verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Her yıl tutulan bir hizmetçi olarak onun yanında olacak. O, senin önünde, ona sert bir şekilde hükmetmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Eğer bu yollarla geri alınmazsa, Jübile Yılı'nda kendisi ve çocukları da serbest bırakılacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Çünkü İsrael'in çocukları benim hizmetkârlarımdır; Mısır diyarından çıkardığım kendi hizmetkârlarımdır. Ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“'Kendinize putlar yapmayacaksınız, oyma put ya da dikili taş dikmeyeceksiniz, ülkenizde önünde eğilmek için oymalı taş koymayacaksınız; çünkü ben Tanrınız Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“'Şabat'larımı tutacaksınız ve konutuma saygı duyacaksınız. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“'Eğer kurallarım içinde yürürseniz, buyruklarımı tutarsanız ve onları yaparsanız, ");
INSERT INTO turytc_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","o zaman yağmurlarınızı size vaktinde vereceğim; toprak da ürününü verecek, kırın ağaçları da meyvesini verecekler. ");
INSERT INTO turytc_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Harmanınız bağ bozumuna kadar, bağ bozumu da ekim zamanına kadar sürecek. Ekmeğinizi doyasıya yiyeceksiniz ve ülkenizde güvenlik içinde oturacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“'Ülkeye barış vereceğim, siz de yatacaksınız ve kimse sizi korkutmayacak. Kötü hayvanları diyardan kovacağım ve ülkenizden kılıç geçmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Düşmanlarınızı kovalayacaksınız ve onlar önünüzde kılıçla düşecekler. ");
INSERT INTO turytc_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Sizden beşiniz yüz kişiyi kovalayacak, yüzünüz de on bin kişiyi kovalayacak; düşmanlarınız da önünüzde kılıçla düşecekler.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“'Sana saygım olacak, seni verimli kılacağım, seni çoğaltacağım ve seninle antlaşmamı sürdüreceğim. ");
INSERT INTO turytc_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Uzun süredir saklanan eski erzağı yiyeceksin ve yenisi için eskisini yerinden çıkaracaksın. ");
INSERT INTO turytc_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Çadırımı aranıza kuracağım, canım sizden nefret etmeyecek. ");
INSERT INTO turytc_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ben aranızda yürüyeceğim, sizin Tanrınız olacağım, siz de benim halkım olacaksınız. ");
INSERT INTO turytc_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ben, onların kölesi olmayasınız diye sizi Mısır diyarından çıkaran Tanrınız Yahve'yim. Boyunduruğunun demirlerini kırdım ve seni dik yürüttüm.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“'Ancak beni dinlemezseniz ve bu buyrukların tümünü yapmazsanız, ");
INSERT INTO turytc_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kurallarımı reddederseniz ve canınız benim ilkelerimden nefret ederse, bütün buyruklarımı yapmaz ve antlaşmamı bozarsanız, ");
INSERT INTO turytc_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ben de size şunu yapacağım: Üzerinize dehşeti, gözleri yiyip bitiren ve canı perişan eden veremi, ateşi üzerinize atayacağım. Tohumunu boşuna ekeceksin, çünkü onu düşmanların yiyecek. ");
INSERT INTO turytc_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Yüzümü sana karşı çevireceğim, düşmanlarınızın önünde vurulacaksınız. Sizden nefret edenler size hükmedecek; sizi kovalayan yokken bile kaçacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“'Bunlara rağmen beni dinlemezseniz, günahlarınız için sizi yedi kat daha cezalandıracağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Gücünün övüncünü kıracağım, gökyüzünü demir gibi, toprağını tunç gibi yapacağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Gücün boşa gidecek; çünkü toprağınız ürün vermeyecek, ülkenin ağaçları da meyvesini vermeyecek.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“'Bana karşı yürür ve beni dinlemezseniz, günahlarınıza göre başınıza yedi kat daha bela getireceğim. ");
INSERT INTO turytc_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Çocuklarınızı elinizden alacak, hayvanlarınızı yok edecek ve sayınızı azaltacak yaban hayvanları aranıza göndereceğim. Yollarınız ıssızlaşacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“'Bunlarla bana geri dönmezseniz ve bana karşı yürürseniz, ");
INSERT INTO turytc_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","o zaman ben de size karşı yürüyeceğim; ve ben de sizi günahlarınız için yedi kat vuracağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Antlaşmanın öcünü alan kılıcı üzerinize getireceğim. Kentlerinizde toplanacaksınız ve aranıza veba göndereceğim. Düşmanın eline teslim edileceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ekmek desteğinizi kırdığımda, ekmeğini on kadın aynı fırında pişirecekler ve ekmeğinizi tartarak getirecekler. Yiyeceksiniz ama doymayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“'Buna rağmen beni dinlemezseniz, bana karşı yürürseniz, ");
INSERT INTO turytc_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ben de öfkeyle size karşı yürüyeceğim. Günahlarınız için de sizi yedi kat cezalandıracağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Oğullarınızın etini yiyeceksiniz, kızlarınızın etini yiyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Yüksek yerlerinizi yok edeceğim, buhur sunaklarınızı devireceğim, ölü bedenlerinizi putlarınızın bedenleri üzerine atacağım; canım da sizden tiksinecek. ");
INSERT INTO turytc_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kentlerinizi harap edeceğim, kutsal yerlerinizi ıssız bırakacağım. Hoş kokulu sunularınızdan hoşnut olmayacağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ülkeyi ıssız bırakacağım; içinde oturan düşmanlarınız buna şaşacaklar. ");
INSERT INTO turytc_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Sizi uluslar arasına dağıtacağım ve ardınızdan kılıç çekeceğim. Ülkeniz ıssız kalacak, kentleriniz çöl olacak. ");
INSERT INTO turytc_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","O zaman ülke ıssız kaldığı ve siz düşman topraklarında olduğunuz sürece Şabat'lardan tat alacak. O zaman ülke dinlenecek ve Şabat'lardan tat alacak. ");
INSERT INTO turytc_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Issız kaldığı sürece, siz onun üzerinde yaşarken Şabat'larınızda sahip olmadığı dinlenmeye sahip olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“'Sizden arta kalanlara gelince, düşman topraklarında onların yüreklerine bir baygınlık göndereceğim. Sürüklenen bir yaprağın sesi onları uçuracak; ve kılıçtan kaçan biri gibi kaçacaklar. Kovalayan yokken düşecekler. ");
INSERT INTO turytc_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kovalayan yokken, sanki kılıç önündeymiş gibi birbirlerine çarpıp düşecekler. Düşmanlarınızın önünde duracak gücünüz olmayacak. ");
INSERT INTO turytc_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ulusların arasında yok olacaksınız. Düşmanlarınızın ülkesi sizi yiyip bitirecek. ");
INSERT INTO turytc_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Sizden sağ kalanlar düşmanlarınızın topraklarında kötülüklerinin acısını çekecekler; babalarının kötülüklerini de onlarla birlikte çekecekler.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“'Eğer bana karşı işledikleri suçta kendi kötülüklerini ve atalarının kötülüklerini itiraf ederlerse; bana karşı yürüdükleri için, ");
INSERT INTO turytc_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ben de onlara karşı yürüdüm ve onları düşmanlarının ülkesine getirdim; eğer o zaman sünnetsiz yürekleri alçakgönüllü olur ve kötülüklerinin cezasını kabul ederlerse, ");
INSERT INTO turytc_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","o zaman Yakov'la olan antlaşmamı, İshak'la olan antlaşmamı ve Avraham'la olan antlaşmamı hatırlayacağım; ülkeyi de hatırlayacağım. ");
INSERT INTO turytc_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ülke de onlar tarafından bırakılacak ve onlarsız ıssız kaldığı sürece Şabat'lardan tat alacak; kurallarımı reddettikleri ve canları ilkelerimden tiksindiği için, suçlarının cezasını kabul edecekler. ");
INSERT INTO turytc_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Bütün bunlara rağmen, düşmanlarının ülkesinde olduklarında, onları tamamen yok etmek ve onlarla olan antlaşmamı bozmak için onları reddetmeyeceğim ve onlardan nefret etmeyeceğim; çünkü ben onların Tanrısı Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ama onların Tanrısı olmak için Mısır'dan ulusların gözü önünde çıkardığım atalarının antlaşmasını onlar uğruna hatırlayacağım. Ben Yahve'yim.'” ");
INSERT INTO turytc_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Bunlar, Yahve'nin Moşe aracılığıyla Sina Dağı'nda kendisi ile İsrael'in çocukları arasında yaptığı kurallar, ilkeler ve yasalardır. ");
INSERT INTO turytc_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Bir adam bir kişiyi Yahve'ye adak olarak adadığında, senin biçtiğin değere göre, ");
INSERT INTO turytc_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","yirmi ile altmış yaş arasındaki bir erkeğe biçtiğin değer, kutsal yerin şekeline göre elli şekel gümüş olacak. ");
INSERT INTO turytc_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Eğer kadınsa, o zaman biçtiği değer otuz şekel olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Eğer kişi beş ile yirmi yaş arasındaysa, o zaman biçtiğin değer erkek için yirmi şekel, kız için on şekel olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Eğer kişi bir aylıktan beş yaşına kadarsa, o zaman biçtiğin değer erkek için beş şekel gümüş, kız için üç şekel gümüş olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kişi altmış yaş ve üzeri ise; eğer erkek ise, o zaman biçtiğiniz değer on beş şekel, bir kadın için ise on şekel olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ama biçtiğin değerden daha yoksulsa, o zaman kâhinin önünde durdurulacak ve kâhin ona bir değer biçecektir. Kâhin ödeme gücüne göre değer biçecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“'İnsanların Yahve'ye sunu olarak sunduğu bir hayvansa, insanın bu hayvandan Yahve'ye verdiği her şey kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Onu değiştirmeyecek, iyiyi kötüyle, kötüyü iyiyle değiştirmeyecek. Eğer hayvanı hayvanla değiştirirsen, o zaman hem o, hem de değiştirilen kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Eğer bu, Yahve'ye sunu olarak sunulmayan kirli bir hayvansa, hayvanı kâhinin önünde durduracak; ");
INSERT INTO turytc_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","kâhin bunun iyi mi ya da kötü mü olduğunun değerini biçecek. Kâhin ona nasıl değer biçerse, öyle olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ama eğer gerçekten onu geri alacaksa, o zaman onun beşte birini biçtiğin değerin üzerine ekleyecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“'Bir adam evini Yahve'ye kutsal kılmak üzere adadığında, kâhin bunun iyi mi ya da kötü mü olduğuna değer biçecek. Kâhin ona nasıl değer biçerse, öyle olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Eğer onu adayan kişi evini geri alırsa, o zaman senin değer biçtiğin paranın beşte birini ona ekleyecek ve ev onun olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“'Eğer bir adam mülkü olan tarlanın bir kısmını Yahve'ye adarsa, o zaman biçeceğin değer onun tohumuna göre olacaktır. Bir homer arpa ekiminin değeri elli şekel gümüş olacak. ");
INSERT INTO turytc_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Eğer tarlasını Jübile Yılı'ndan itibaren adarsa, senin biçtiğin değere göre kalacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ama eğer tarlasını Jübile'den sonra adarsa, o zaman kâhin ona parayı Jübile Yılı'na kadar kalan yıllara göre hesaplayacak; ve biçtiğin değerden düşecektir. ");
INSERT INTO turytc_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Eğer tarlayı adayan kişi gerçekten onu geri alacaksa, o zaman senin biçtiğin değerin beşte birini onun üzerine ekleyecek ve tarla onun olarak kalacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Tarlayı geri almazsa, ya da tarlayı başka birine satarsa, bir daha geri alınamaz; ");
INSERT INTO turytc_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ama tarla Jübile'de çıktığı zaman, Yahve'ye adanmış bir tarla gibi kutsal olacak. Mülkiyeti kâhinlere ait olacak.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“'Eğer biri satın aldığı ve kendi mülkü olmayan bir tarlayı Yahve'ye adarsa, ");
INSERT INTO turytc_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","o zaman kâhin senin biçtiğin değerin bedelini Jübile Yılı'na kadar ona hesap edecek; ve o gün senin biçtiğin değeri Yahve'ye kutsal bir şey olarak verecektir. ");
INSERT INTO turytc_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Jübile Yılı'nda tarla, kendisinden satın alınan insana, toprağın mülkiyeti kendisine ait olan insana dönecektir. ");
INSERT INTO turytc_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bütün biçtiğiniz değerler kutsal yerin şekeline göre olacak: Şekel başına yirmi gerah olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Ancak hayvanlar arasında ilk doğan, ilk doğan olarak Yahve'ye ait olduğu için, hiç kimse onu adayamaz; ister öküz, ister koyun olsun, o Yahve'nindir. ");
INSERT INTO turytc_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Eğer kirli bir hayvan ise, o zaman onu senin biçeceğin değere göre geri satın alacak ve beşte birini onun üzerine ekleyecektir; ya da geri alınamazsa o zaman senin biçeceğin değere göre satılacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“'Bununla birlikte, bir insanın sahip olduğu insan olsun, hayvan olsun ya da mülkü olan tarla olsun, Yahve'ye adadığı hiçbir şey satılmayacak ya da geri alınmayacaktır. Kalıcı olarak adanan her şey Yahve'ye çok kutsaldır.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“'İnsanlar arasından yıkıma ayrılan hiç kimse fidyeyle kurtarılmayacak. Kesinlikle öldürülecektir.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“'İster toprağın tohumu, ister ağaçların meyvesi olsun, toprağın bütün ondalığı Yahve'ye aittir. Yahve'ye kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Bir adam ondalığının bir kısmını geri alırsa, onun üzerine beşte birini ekleyecektir. ");
INSERT INTO turytc_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Bütün sığırların ya da davarların ondalığı, her değnek altından geçenlerin ondalığı, Yahve'ye kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Onun iyi mi kötü mü olduğunu incelemeyecek ve onu değiştirmeyecek. Eğer onu değiştirirse, o zaman hem o, hem de değiştirdiği kutsal olacaktır. O ödenip geri alınamayacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Bunlar, Yahve'nin Sina Dağı'nda İsrael'in çocukları için Moşe'ye buyurduğu buyruklardır. ");
INSERT INTO turytc_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahve, Mısır diyarından çıkışlarının ikinci yılında, ikinci ayın birinci günü, Sina Çölü'nde, Buluşma Çadırı'nda Moşe'yle konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“İsrael'in çocuklarının topluluğunu, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, her erkeği, ");
INSERT INTO turytc_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","İsrael'de yirmi yaş ve üzeri, savaşa gidebilecek durumda olanların hepsini, sen ve Aron onları bölüklerine göre, birer birer sayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Yanınızda her oymaktan bir adam, her biri atalarının evinin başı olacak. ");
INSERT INTO turytc_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Sizinle birlikte duracak adamların adları şunlardır: Ruven'den: Şedeur oğlu Elizur. ");
INSERT INTO turytc_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Şimon'dan: Surişadday oğlu Şelumiel. ");
INSERT INTO turytc_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yahuda'dan: Amminadav oğlu Nahşon. ");
INSERT INTO turytc_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","İssakar'dan: Zuar oğlu Netanel. ");
INSERT INTO turytc_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zevulun'dan: Helon oğlu Eliav. ");
INSERT INTO turytc_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yosef'in çocuklarından: Efraim'den: Ammihud oğlu Elişama; Manaşşe'den: Pedahsur oğlu Gamaliel. ");
INSERT INTO turytc_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benyamin'den: Gideoni oğlu Avidan. ");
INSERT INTO turytc_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan'dan: Ammişadday oğlu Ahiezer. ");
INSERT INTO turytc_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aşer'den: Okran oğlu Pagiel. ");
INSERT INTO turytc_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad'dan: Deuel oğlu Elyasaf. ");
INSERT INTO turytc_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftali'den: Enan oğlu Ahira.” ");
INSERT INTO turytc_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Topluluktan çağrılanlar, atalarının oymaklarının beyleri bunlardır; onlar İsrael binlerinin başlarıydı. ");
INSERT INTO turytc_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moşe ile Aron adları anılan bu adamları aldılar. ");
INSERT INTO turytc_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","İkinci ayın birinci günü bütün topluluğu bir araya topladılar; soylarını ailelerine göre, atalarının evlerine göre, ad sayısına göre yirmi yaş ve üzeri olarak teker teker ilan ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Yahve'nin Moşe'ye buyurduğu gibi onları Sina Çölü'nde saydı. ");
INSERT INTO turytc_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","İsrael'in ilk doğanı Ruven'in çocukları, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek her erkek, teker teker hepsi: ");
INSERT INTO turytc_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ruven oymağından sayılanlar kırk altı bin beş yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Şimon'un çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre teker teker, onlardan sayılanlar, yirmi yaş ve üzeri savaşa gidebilecek durumda olanların hepsi: ");
INSERT INTO turytc_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Şimon oymağından sayılanlar elli dokuz bin üç yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad'ın çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad oymağından sayılanlar kırk beş bin altı yüz elli kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yahuda'nın çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Yahuda oymağından sayılanlar yetmiş dört bin altı yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","İssakar'ın çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","İssakar oymağından sayılanlar elli dört bin dört yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zevulun'un çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zevulun oymağından sayılanlar elli yedi bin dört yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yosef çocuklarından: Efraim'in çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efraim oymağından sayılanlar kırk bin beş yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manaşşe'nin çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manaşşe oymağından sayılanlar otuz iki bin iki yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benyamin'in çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Benyamin oymağından sayılanlar otuz beş bin dört yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan'ın çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan oymağından sayılanlar altmış iki bin yedi yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aşer'in çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Aşer oymağından sayılanlar kırk bir bin beş yüz kişi vardı. ");
INSERT INTO turytc_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftali'nin çocuklarından, onların kuşakları, soylarına göre, atalarının evlerine göre, adlarının sayısına göre, yirmi yaş ve üzeri savaşa gidebilecek durumda olanlar: ");
INSERT INTO turytc_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naftali oymağından sayılanlar elli üç bin dört yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Sayılanlar bunlardır; onları Moşe ve Aron'la İsrael'in on iki beyleri saydılar; bunlardan her biri kendi atalarının evi içindi. ");
INSERT INTO turytc_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Böylece atalarının evlerine göre İsrael'in çocuklarından sayılan yirmi yaş ve üzeri İsrael'de savaşa gidebilecek durumda olanların hepsi, ");
INSERT INTO turytc_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","sayılanların tamamı altı yüz üç bin beş yüz elli kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ancak Levililer atalarının oymağına göre onların arasında sayılmadı. ");
INSERT INTO turytc_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Çünkü Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Yalnız Levi oymağını saymayacaksın, İsrael'in çocuklarının arasında onların sayımını yapmayacaksın; ");
INSERT INTO turytc_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ancak Levililer'i Levha Sandığı'nın, onun tüm takımlarının ve ona ait olan her şeyin üzerinde görevlendir. Konutu ve onun tüm takımlarını onlar taşıyacaklar; onunla onlar ilgilenecekler ve onun çevresinde konaklayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Konut taşınacağı zaman Levililer onu indirecekler; ve konut kurulacağı zaman onu Levililer kuracaklar. Yaklaşan yabancı öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","İsrael'in çocukları, kendi bölüklerine göre, herkes kendi ordugâhına ve herkes kendi sancağının yanında çadırlarını kuracaklar. ");
INSERT INTO turytc_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ama İsrael'in çocuklarının topluluğu üzerine gazap gelmesin diye Levililer Levha Sandığı'nın çevresinde konaklayacaklar. Levililer Tanıklık Konutu'ndan sorumlu olacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","İsrael'in çocukları böyle yaptılar. Yahve'nin Moşe'ye buyurduğu her şeye göre onlar da öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“İsrael'in çocukları, herkes kendi bayrağının yanında, atalarının evlerinin sancaklarıyla konaklayacak. Buluşma Çadırı'nın çevresinde, ondan uzakta konaklayacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Gündoğumuna doğru doğu tarafında konaklayanlar, bölüklerine göre Yahuda ordugâhının bayrağından olacaklar. Yahuda'nın çocuklarının beyi Amminadav oğlu Nahşon olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Onun bölüğü ve onlardan sayılanlar yetmiş dört bin altı yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Onun yanında konaklayanlar İssakar oymağı olacak. İssakar'ın çocuklarının beyi Zuar oğlu Netanel olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Onun bölüğü ve ondan sayılanlar elli dört bin dört yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“Zevulun oymağı: Zevulun'un çocuklarının beyi Helon oğlu Eliav olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Onun bölüğü ve ondan sayılanlar elli yedi bin dört yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“Yahuda ordugâhından sayılanların hepsi bölüklerine göre yüz seksen altı bin dört yüz kişiydi. İlk olarak onlar yola çıkacaklardır.” ");
INSERT INTO turytc_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Bölüklerine göre Ruven ordugâhının bayrağı güney tarafında olacak. Ruven çocuklarının beyi Şedeur oğlu Elizur olacak.” ");
INSERT INTO turytc_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Onun bölüğü ve ondan sayılanlar kırk altı bin beş yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Onun yanında konaklayan Şimon oymağı olacak. Şimon'un çocuklarının beyi Surişadday oğlu Şelumiel olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Onun bölüğü ve ondan sayılanlar elli dokuz bin üç yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“Gad oymağı: Gad'ın çocuklarının beyi Reuel oğlu Elyasaf olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Onun bölüğü ve ondan sayılanlar kırk beş bin altı yüz elli kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“Ruven ordugâhından sayılanların hepsi bölüklerine göre yüz elli bir bin dört yüz elli kişiydi. İkinci olarak onlar yola çıkacaklardır.” ");
INSERT INTO turytc_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Sonra Buluşma Çadırı yola çıkacak, Levililer'in ordugâhı ordugâhların ortasında olacak. Konakladıkları gibi, herkes kendi bayraklarına göre, her kişi kendi yerinden yola çıkacak.” ");
INSERT INTO turytc_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Bölüklerine göre Efraim ordugâhının sancağı batı tarafında olacak. Efraim'in çocuklarının beyi Ammihud oğlu Elişama olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Onun bölüğü ve onlardan sayılanlar kırk bin beş yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Onun yanında Manaşşe oymağı olacak. Manaşşe'nin çocuklarının beyi Pedahzur oğlu Gamaliel olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Onun bölüğü ve onlardan sayılanlar otuz iki bin iki yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“Benyamin oymağı: Benyamin'in çocuklarının beyi Gideoni oğlu Avidan olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Onun ordusu ve onlardan sayılanlar otuz beş bin dört yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“Efraim ordugâhından sayılanların hepsi bölüklerine göre yüz sekiz bin yüz kişiydi. Üçüncü olarak onlar yola çıkacaklardır.” ");
INSERT INTO turytc_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Bölüklerine göre Dan ordugâhının bayrağı kuzey tarafında olacak. Dan'ın çocuklarının beyi Ammişadday oğlu Ahiezer olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Onun bölüğü ve onlardan sayılanlar altmış iki bin yedi yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Onun yanında konaklayanlar Aşer oymağı olacak. Aşer'in çocuklarının beyi Okran oğlu Pagiel olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Onun bölüğü ve onlardan sayılanlar kırk bir bin beş yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“Naftali oymağı: Naftali'nin çocuklarının beyi Enan oğlu Ahira olacak. ");
INSERT INTO turytc_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Onun bölüğü ve onlardan sayılanlar elli üç bin dört yüz kişiydi.” ");
INSERT INTO turytc_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“Dan ordugâhından sayılanların hepsi yüz elli yedi bin altı yüz kişiydi. Kendi bayraklarına göre en son onlar yola çıkacaklardır.” ");
INSERT INTO turytc_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Bunlar atalarının evlerine göre İsrael'in çocuklarından sayılanlardır. Ordularına göre ordugâhlardan sayılanların hepsi altı yüz üç bin beş yüz elli kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ancak Yahve'nin Moşe'ye buyurmuş olduğu gibi Levililer İsrael'in çocukları arasında sayılmadılar. ");
INSERT INTO turytc_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","İsrael'in çocukları da böyle yaptı. Yahve'nin Moşe'ye buyurduğu her şeye göre, kendi bayraklarına göre konakladılar ve böylece herkes aileleri ile atalarının evlerine göre yola çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Yahve'nin Sina Dağı'nda Moşe'yle konuştuğu gün Aron'la Moşe'nin soylarının tarihi şöyledir. ");
INSERT INTO turytc_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aron'un oğullarının adları şunlardır: İlk doğan Nadav, Avihu, Eleazar ve İtamar. ");
INSERT INTO turytc_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aron'un oğullarının, kâhinlik makamında hizmet etmek üzere adadığı, meshedilmiş kâhinlerin adları bunlardır. ");
INSERT INTO turytc_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadav ile Avihu, Sina Çölü'nde Yahve'nin önünde yabancı ateş sundukları zaman Yahve'nin önünde öldüler; onların çocukları yoktu. Eleazar ve İtamar, babaları Aron'un önünde kâhinlik makamında hizmet ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Levi oymağını yaklaştır ve onları kâhin Aron'un önünde, ona hizmet etsinler diye durdur. ");
INSERT INTO turytc_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Konutun hizmetini yapmak üzere onun ve tüm topluluğun gereksinimlerini Buluşma Çadırı'nın önünde onlar sağlayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Buluşma Çadırı'nın bütün takımlarını ve İsrael'in çocuklarının konut hizmetiyle ilgili yükümlülüklerini onlar karşılayacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levililer'i Aron'la oğullarına vereceksin. Onlar İsrael'in çocukları adına tamamen ona verilmiştir. ");
INSERT INTO turytc_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aron'la oğullarını sen atayacaksın, onlar da kâhinliklerini sürdürecekler, yaklaşan yabancı ise öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“İşte, İsrael'in çocukları arasında rahmi açan ilk doğanların yerine, Levililer'i İsrael'in çocukları arasından seçtim; ve Levililer benim olacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Çünkü ilk doğanların hepsi benimdir. Mısır diyarında bütün ilk doğanları vurduğum gün, İsrael'de insan olsun hayvan olsun bütün ilk doğanları kendime kutsal kıldım. Benim olacaklar. Ben Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahve Sina Çölü'nde Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Levi çocuklarını atalarının evlerine, ailelerine göre say. Bir aylık ve üstü olan her erkeği sayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moşe onları Yahve'nin sözüne göre, kendisine buyurulduğu gibi saydı. ");
INSERT INTO turytc_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi'nin oğulları adlarıyla şunlardır: Gerşon, Kehat ve Merari. ");
INSERT INTO turytc_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerşon'un oğullarının ailelerine göre adları şunlardır: Livni ve Şimi. ");
INSERT INTO turytc_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ailelerine göre Kohat'ın oğulları: Amram, Yishar, Hevron ve Uzziel. ");
INSERT INTO turytc_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ailelerine göre Merari'nin oğulları: Mahli ve Muşi. Babalarının evlerine göre Levililer'in aileleri bunlardır. ");
INSERT INTO turytc_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Livnî ailesi ve Şimi ailesi Gerşon'dandı. Bunlar Gerşonlular'ın aileleridir. ");
INSERT INTO turytc_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Onlardan sayılanlar, bir aylık ve üstü olan tüm erkeklerin sayısına göre yedi bin beş yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gerşonlular'ın aileleri konutun arkasında batıya doğru konaklayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Lael oğlu Elyasaf Gerşonlular'ın atalar evinin beyi olacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Buluşma Çadırı'nda Gerşon oğullarının görevi konut, çadır, onun örtüsü, Buluşma Çadırı'nın kapı perdesi, ");
INSERT INTO turytc_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","konutla sunağın çevresindeki avlunun perdeleri, avlu kapısının perdesi ve bütün hizmeti için onun ipleri olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amramlılar'ın ailesi, Yisharlılar'ın ailesi, Hevronlular'ın ailesi ve Uzzielliler'in ailesi Kohat'tandı. ");
INSERT INTO turytc_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Bir aylık ve üstü olan tüm erkeklerin sayısına göre, kutsal yerin gereksinimlerini karşılayan sekiz bin altı yüz kişi vardı. ");
INSERT INTO turytc_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohatoğulları'nın aileleri konutun güney tarafında konaklayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohatlılar'ın ailelerinin atalar evi beyi Uzziel oğlu Elizafan olacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sandık, masa, şamdan, sunaklar, hizmet ettikleri kutsal yerin takımları, perde ve onun tüm hizmeti onların görevi olacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kâhin Aron'un oğlu Eleazar, kutsal yerin gereksinimlerini sağlayanların üzerinde Levili beylerin beyi olacak. ");
INSERT INTO turytc_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mahlitliler ailesi ve Muşililer ailesi Merari'dendi. Bunlar Merari'nin aileleridir. ");
INSERT INTO turytc_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Bir aylık ve daha üstü olan tüm erkeklerin sayısına göre onlardan sayılanlar altı bin iki yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari ailelerinin atalar evinin beyi Avihail oğlu Suriel'di. Onlar konutun kuzey tarafında konaklayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merarioğulları'nın belirlenmiş görevleri konutun çerçeveleri, kirişleri, direkleri, tabanları, bütün takımları, onun tüm hizmetleri, ");
INSERT INTO turytc_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","çevresindeki avlunun direkleri, tabanları, kazıkları ve ipleridir. ");
INSERT INTO turytc_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Doğuya doğru konutun önünde, güneşin doğduğu yere doğru Buluşma Çadırı'nın önünde, İsrael'in çocuklarının görevi için kutsal yerin gereksinimlerini karşılamak üzere konaklayanlar, Moşe, Aron ve oğulları olacaklar. Yaklaşan yabancı öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Moşe ile Aron'un Yahve'nin buyruğu uyarınca ailelerine göre saydıkları Levililer'in tümü, bir aylık ve üstü olan tüm erkekler yirmi iki bin kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yahve Moşe'ye şöyle dedi: “İsrael'in çocuklarından bir aylık ve üstü olan ilk doğan tüm erkekleri say ve adlarının sayısını al. ");
INSERT INTO turytc_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","İsrael'in çocukları arasında ilk doğanların yerine Levililer'i, —Ben Yahve'yim—benim için alacaksın; ve İsrael'in çocuklarının hayvanları arasında bütün ilk doğanlar yerine Levililer'in hayvanlarını alacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moşe, Yahve'nin kendisine buyurduğu gibi, İsrael'in çocukları arasında ilk doğanların hepsini saydı. ");
INSERT INTO turytc_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ad sayısına, bir aylık ve üstü olanlardan sayılanlara göre ilk doğan bütün erkekler yirmi iki bin iki yüz yetmiş üç kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“İsrael'in çocukları arasında ilk doğanların tümü yerine Levililer'i, onların hayvanları yerine de Levililer'in hayvanlarını al; Levililer de benim olacak. Ben Yahve'yim. ");
INSERT INTO turytc_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","İsrael'in çocuklarının ilk doğanlarından Levililer'in sayısını aşan iki yüz yetmiş üç kişinin bedeli için, ");
INSERT INTO turytc_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","kişi başına beş şekel alacaksın; onları kutsal yerin şekeline göre alacaksın (şekel yirmi geradır); ");
INSERT INTO turytc_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ve onlardan geri kalan bedel parasını Aron'la oğullarına vereceksin.” ");
INSERT INTO turytc_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moşe, Levililer'le bedeli verilmiş olanları aşanların bedel parasını aldı; ");
INSERT INTO turytc_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","İsrael'in çocuklarının ilk doğanlarından kutsal yerin şekeline göre bin üç yüz altmış beş şekel para aldı; ");
INSERT INTO turytc_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Yahve'nin sözü uyarınca Moşe, Yahve'nin Moşe'ye buyurduğu gibi bedel parasını Aron'la oğullarına verdi. ");
INSERT INTO turytc_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Levioğulları arasından Kohat'ın oğullarını, ailelerine, ata evlerine göre, ");
INSERT INTO turytc_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","otuz yaştan başlayarak elli yaşına kadar Buluşma Çadırı'nda iş yapmak üzere hizmete girenlerin tümünü sayın.” ");
INSERT INTO turytc_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Buluşma Çadırı'nda Kohatoğulları'nın en kutsal şeylerle ilgili hizmeti budur. ");
INSERT INTO turytc_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ordugâh göç edince Aronoğulları'yla birlikte içeri girecek ve bölme perdesini indirecekler, Levha Sandığı'nı onunla örtecekler, ");
INSERT INTO turytc_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","üzerine fok derisinden bir örtü koyacaklar, üzerine mavi bir bez serip sırıklarını takacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Sergi ekmeği masasının üzerine mavi bir bez serip üzerine tabakları, kaşıkları, kâseleri, dökmelik sunu için tasları koyacaklar; ve sürekli ekmek onun üzerinde olacak. ");
INSERT INTO turytc_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Üzerlerine kırmızı bir bez serip onu fok derisinden bir örtüyle örtecekler ve sırıklarını takacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Lacivert bir bez alıp ışık veren şamdanı, kandillerini, makaslarını, tablalarını ve onun hizmetinde kullanılan tüm yağ kaplarını örtecekler. ");
INSERT INTO turytc_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Onu ve içindeki tüm takımlarını fok derisinden bir örtü içine koyacaklar ve onu sedye üzerine koyacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Altın sunağın üzerine mavi bir bez serip onu deri bir örtüyle örtecekler ve sırıklarını geçirecekler.” ");
INSERT INTO turytc_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Kutsal yerde hizmet ettikleri bütün hizmet takımlarını alıp mavi bir beze saracaklar, üzerini fok derisinden bir örtüyle örtecekler ve sedye üzerine koyacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Sunağın küllerini kaldırıp üzerine mor bir bez serecekler. ");
INSERT INTO turytc_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Onun üzerinde hizmet için kullanılan tüm takımları, ateş tavalarını, et kancalarını, kürekleri ve leğenleri, sunağın tüm takımlarını onun üzerine koyacaklar; ve üzerine fok derisinden bir örtü serip sırıklarını geçirecekler.” ");
INSERT INTO turytc_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Aron'la oğulları kutsal yeri ve kutsal yerin tüm takımlarını örtmeyi bitirince, ordugâh göç ederken; ondan sonra Kohat'ın oğulları onu taşımaya gelecekler; ama ölmesinler diye kutsal yere dokunmayacaklar. Buluşma Çadırı'na ait olan bu şeyleri Kohat'ın oğulları taşıyacak.” ");
INSERT INTO turytc_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Kâhin Aron oğlu Eleazar'ın görevi, ışık için yağ, kokulu buhur, sürekli ekmek sunusu, mesh yağı, tüm konutun, ve içinde bulunan her şeyin, kutsal yer ve onun takımlarının gereksinimleri olacak.” ");
INSERT INTO turytc_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kohatlı ailelerin boyunu Levililer arasından ayırmayın; ");
INSERT INTO turytc_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ama onlara şöyle yapın ki, çok kutsal şeylere yaklaştıklarında ölmesinler, yaşasınlar. Aron'la oğulları içeri girecekler ve herkesi kendi hizmetine ve yüküne atayacaklar; ");
INSERT INTO turytc_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ama ölmemek için bir an bile kutsal yeri görmeye girmeyecekler.” ");
INSERT INTO turytc_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gerşon'un oğullarını da atalarının evlerine, ailelerine göre say; ");
INSERT INTO turytc_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","onları, otuz yaşından elli yaşına kadar Buluşma Çadırı'nda hizmete hazır, iş yapmak üzere içeri girenlerin hepsini sayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gerşonlu ailelerin hizmet ve yük taşımakta hizmeti şudur: ");
INSERT INTO turytc_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Konutun perdelerini ve Buluşma Çadırı'nı ve onun üstündeki fok derisinden örtüyü, Buluşma Çadırı'nın kapı perdesini, ");
INSERT INTO turytc_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","avlunun perdelerini, konutun yanındaki ve sunağın çevresindeki avlu kapısının kapı perdesi, bunların ipleri, onların hizmetinde kullanılan bütün aletleri onlar taşıyacaklar; onlarla yapılan her işte onlar hizmet edecekler. ");
INSERT INTO turytc_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gerşon'un oğullarının bütün hizmetinde, tüm yükleri ve tüm hizmetleri Aron'la oğullarının buyruğuyla olacak; ve tüm sorumluluklarında onlara görev atayacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gerşonlu oğulları ailelerinin Buluşma Çadırı'ndaki hizmeti budur. Görevleri kâhin Aron oğlu İtamar'ın eli altında olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Merari'nin oğullarına gelince, onları ailelerine, atalarının evlerine göre sayacaksın; ");
INSERT INTO turytc_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Buluşma Çadırı'nın işini yapmak üzere hizmete giren herkesi otuz yaşından elli yaşına kadar sayacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Buluşma Çadırı'nda yaptıkları tüm hizmete göre onların yükleri şunlardır: Bütün takımları ve bütün hizmetleriyle birlikte, konutun çerçeveleri, kirişleri, direkleri, tabanları, ");
INSERT INTO turytc_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","çevresindeki avlunun direkleri, bunların tabanları, kazıkları, ipleridir. Yüklerinin görev aletlerini adlarıyla onlara atayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merarioğulları ailelerinin, Kâhin Aron oğlu İtamar'ın eli altında Buluşma Çadırı'nda yaptıkları bütün hizmetlerine göre hizmeti budur.” ");
INSERT INTO turytc_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moşe, Aron ve topluluğun beyleri, Kohatlıoğulları'nı ailelerine ve atalarının evlerine göre; ");
INSERT INTO turytc_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","otuz yaşından elli yaşına kadar, Buluşma Çadırı'nda çalışmak üzere hizmete giren herkesi saydılar. ");
INSERT INTO turytc_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ailelerine göre onlardan sayılanlar iki bin yedi yüz elli kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Buluşma Çadırı'nda hizmet eden Kohatlı ailelerden sayılanlar bunlardı; Yahve'nin Moşe aracılığıyla verdiği buyruk uyarınca Moşe ile Aron'un saydıkları onlardı. ");
INSERT INTO turytc_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ailelerine ve atalarının evlerine göre Gerşon'un oğulları arasında sayılanlar, ");
INSERT INTO turytc_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","otuz yaşından elli yaşına kadar, Buluşma Çadırı'nda çalışmak üzere hizmete giren hepsi, ");
INSERT INTO turytc_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ailelerine ve atalarının evlerine göre onlardan sayılanlar iki bin altı yüz otuz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Moşe ve Aron'un Yahve'nin buyruğu uyarınca saydıkları, Buluşma Çadırı'nda hizmet eden Gerşon'un oğullarının ailelerinden sayılanlar bunlardı. ");
INSERT INTO turytc_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ailelerine ve atalarının evlerine göre Merarioğulları ailelerinden sayılanlar, ");
INSERT INTO turytc_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","otuz yaşından elli yaşına kadar, Buluşma Çadırı'nda çalışmak üzere hizmete giren herkes; ");
INSERT INTO turytc_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ailelerine göre onlardan sayılanlar üç bin iki yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Bunlar, Yahve'nin Moşe aracılığıyla verdiği buyruğa göre Moşe ile Aron'un saydıkları Merarioğulları ailelerinden sayılanlardı. ");
INSERT INTO turytc_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moşe, Aron ve İsrael beylerinin ailelerine ve atalarının evlerine göre saydıkları Levililer arasında sayılanlar, ");
INSERT INTO turytc_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","otuz yaşından elli yaşına kadar hizmet işini ve Buluşma Çadırı'nda yükler taşıma işini yapmak için girenlerin hepsi, ");
INSERT INTO turytc_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","onlardan sayılanlar sekiz bin beş yüz seksen kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Yahve'nin buyruğu uyarınca, herkes kendi hizmetine ve yüküne göre Moşe tarafından sayıldı. Böylece Yahve'nin Moşe'ye buyurduğu gibi onlar onun tarafından sayıldılar. ");
INSERT INTO turytc_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“İsrael'in çocuklarına buyur, her cüzzamlıyı, her akıntısı olanı ve ölüden dolayı kirli olan her kişiyi ordugâhtan çıkarsınlar. ");
INSERT INTO turytc_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ortasında oturduğum ordugâhı kirletmesinler diye, hem erkekleri hem de kadınları ordugâhın dışına çıkaracaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","İsrael'in çocukları da öyle yaptılar ve onları ordugâhın dışına çıkardılar; Yahve Moşe'ye nasıl söylediyse, İsrael'in çocukları da öyle yaptı. ");
INSERT INTO turytc_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“İsrael'in çocuklarına de ki: 'Bir erkek ya da kadın, Yahve'ye karşı gelerek, insanların işlediği günahlardan birisini işlediğinde ve o can suçlu olduğunda, ");
INSERT INTO turytc_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","o zaman işlemiş olduğu günahı itiraf edecek; ve suçunun karşılığını tamamen ödeyecek, üzerine beşte birini ekleyecek ve onu suçlu olduğu insana verecektir. ");
INSERT INTO turytc_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ancak eğer suçun karşılığını ödemek için o adamın yakın akrabası yoksa, kendisi için kefaret edecek olan kefaret koçunun yanı sıra, Yahve'ye ödenen suç karşılığı da kâhinin olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","İsrael'in çocuklarının kâhine sundukları tüm kutsal şeylerden her kaldırma sunusu onun olacak. ");
INSERT INTO turytc_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Herkesin kutsal şeyleri onun olacaktır; kim kâhine bir şey verirse, onun olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“İsrael'in çocuklarına söyle ve onlara de: 'Bir adamın karısı yoldan sapar ve ona sadakatsizlik ederse, ");
INSERT INTO turytc_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","bir erkek onunla yatar, bu kocasının gözlerinden gizlenir ve saklı kalırsa, ve kadın kirlenir, ona karşı hiçbir tanık yoksa, kadın eylem sırasında tutulmazsa; ");
INSERT INTO turytc_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","adamın üzerine kıskançlık ruhu gelir, karısı kirli olduğu halde karısını kıskanırsa; ya da eğer adamın üzerine kıskançlık ruhu gelir ve karısı kirli olmadığı halde karısını kıskanırsa; ");
INSERT INTO turytc_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","o zaman adam karısını kâhine getirecek ve onun için sunu olarak onda bir efa arpa unu getirecek. Üzerine yağ dökmeyecek ve üzerine buhur koymayacak; çünkü bu kıskançlık ekmeği sunusu, kötülüğü hatırlatan anma ekmek sunusudur. ");
INSERT INTO turytc_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kâhin kadını yaklaştırıp Yahve'nin önünde durduracak. ");
INSERT INTO turytc_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kâhin kutsal suyu toprak bir kap içine alacak; ve kâhin konutun zemini üzerindeki tozun bir kısmını alıp suya koyacak. ");
INSERT INTO turytc_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kâhin kadını Yahve'nin önünde durduracak, kadının saçlarını çözecek ve anma ekmek sunusunu onun ellerine koyacak, kıskançlık ekmek sunusudur. Kâhinin elinde lanet getiren acılık suyu olacak. ");
INSERT INTO turytc_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kâhin ona ant içirtip kadına şöyle diyecek: “Eğer seninle bir erkek yatmamışsa ve kocanın yetkisi altında kirliliğe sapmadıysan, lanet getiren bu acılık suyundan kurtul. ");
INSERT INTO turytc_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ama eğer kocanın yetkisi altındayken yoldan sapmışsan, kirlenmişsen ve kocandan başka bir adam seninle yatmışsa…” ");
INSERT INTO turytc_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","o zaman kâhin kadına lanet andı içirtip kâhin kadına şöyle diyecek: “Yahve kalçanın düşmesine ve vücudunun şişmesine izin verdiğinde, Yahve seni halkının arasında bir lanet ve küfür yapsın; ");
INSERT INTO turytc_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","lanet getiren bu su bağırsaklarına girecek, vücudunu şişirecek, kalçanı düşürecek.'' Kadın “Amin, Amin” diyecek.'” ");
INSERT INTO turytc_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“'Kâhin bu lanetleri bir kitaba yazacak ve onları acılık suyu içinde silecek. ");
INSERT INTO turytc_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Lanet getiren acılık suyunu kadına içirecek; ve lanete neden olan su onun içine girecek ve acılaşacak. ");
INSERT INTO turytc_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kâhin kıskançlık ekmek sunusunu kadının elinden alacak ve ekmek sunusunu Yahve'nin önünde sallayacak ve onu sunağa getirecek. ");
INSERT INTO turytc_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kâhin anma payı olarak ekmek sunusundan bir avuç alacak, onu sunakta yakacak, sonra da suyu kadına içirecek. ");
INSERT INTO turytc_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","O, suyu ona içirdiğinde, eğer kadın kirlenmişse ve kocasına karşı bir suç işlemişse, lanete neden olan su onun içine girecek ve acılaşacak, vücudu şişecek ve kalçası düşecek; kadın da halkı arasında bir lanet olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Eğer kadın kirli değilse ama temizse; o zaman kurtulacak ve soy sahibi olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“'Kocasına bağlı kadın yoldan sapıp kirlendiğinde, ");
INSERT INTO turytc_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ya da kıskançlık ruhu erkeğin üzerine geldiğinde ve karısını kıskandığında kıskançlık yasası budur; o zaman kadını Yahve'nin önünde durduracak ve kâhin bu yasanın tamamını onun üzerinde uygulayacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Erkek kötülükten özgür olacak, o kadın da kendi kötülüğünü taşıyacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“İsrael'in çocuklarına konuş ve onlara şunu söyle: 'Erkek ya da kadın, kendini Yahve'ye ayırmak için özel bir adak, yani bir Neziri adağı adarsa, ");
INSERT INTO turytc_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kendini şaraptan ve ağır içkiden ayrı tutacak. Şarap sirkesi ya da mayalanmış içecek sirkesi içmeyecek, hiç üzüm suyu içmeyecek, taze üzüm ya da kurutulmuş üzüm yemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ayrıldığı günler boyunca, çekirdeklerinden kabuğuna kadar asmadan yapılan hiçbir şeyi yemeyecektir. ");
INSERT INTO turytc_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“'Ayrılık adağı günleri boyunca, kendisini Yahve'ye ayıracağı günler doluncaya dek başına ustura gelmeyecek. O kutsal olacaktır. Başındaki saçlarını uzatacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“'Yahve'ye ayrıldığı günler boyunca ölünün yanına yaklaşmayacak. ");
INSERT INTO turytc_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Babası, annesi, erkek kardeşi ya da kız kardeşi öldüğü zaman onlar için kendini kirletmeyecektir; çünkü Tanrı'ya ayrılması onun başı üzerindedir. ");
INSERT INTO turytc_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ayrıldığı günler boyunca Yahve'ye kutsaldır. ");
INSERT INTO turytc_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“'Eğer bir kişi aniden onun yanında ölürse ve ayrılığının başını kirletirse, o zaman temizlendiği gün başını tıraş edecek. Yedinci gün onu tıraş edecek. ");
INSERT INTO turytc_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sekizinci gün kâhine, Buluşma Çadırı'nın kapısına iki kumru ya da iki güvercin yavrusu getirecek. ");
INSERT INTO turytc_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kâhin birini günah sunusu, diğerini yakmalık sunu olarak sunacak ve ölü yüzünden günah işlediği için onun için kefaret edecek ve aynı gün başını kutsal kılacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ayrılık günlerini Yahve'ye ayıracak ve suç sunusu olarak bir yaşında bir erkek kuzu getirecek; ancak önceki günler boşa gidecektir, çünkü onun ayrılığı kirlenmiştir. ");
INSERT INTO turytc_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“'Nezir'in yasası şudur: Ayrılık günleri tamamlanınca, Buluşma Çadırı'nın kapısına getirilecek. ");
INSERT INTO turytc_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Yahve'ye yakmalık sunu olarak kusursuz bir yaşında, erkek kuzu, günah sunusu olarak kusursuz bir yaşında dişi kuzu, esenlik sunuları olarak kusursuz bir koç, ");
INSERT INTO turytc_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","bir sepet mayasız ekmek, yağla yoğrulmuş ince undan pideler ve onların ekmek sunusuyla ve onların dökmelik sunusuyla birlikte yağ sürülmüş mayasız yufkalar sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kâhin bunları Yahve'nin önüne çıkaracak, günah sunusunu ve yakmalık sunusunu sunacak. ");
INSERT INTO turytc_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Koçu, mayasız ekmek sepetiyle birlikte Yahve'ye esenlik sunuları kurbanı olarak sunacak. Kâhin ayrıca onun ekmek sunusunu ve dökmelik sunusunu da sunacak. ");
INSERT INTO turytc_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nezir, ayrılığının başını Buluşma Çadırı'nın kapısında tıraş edecek, ayrılık başının saçını alıp esenlik sunuları kurbanının altındaki ateşin üzerine koyacak. ");
INSERT INTO turytc_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kâhin koçun haşlanmış omzunu, bir mayasız pideyi ve bir mayasız yufkayı sepetten çıkarıp Nezir'in başını tıraş ettikten sonra bunları onun ellerine koyacak; ");
INSERT INTO turytc_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ve kâhin bunları Yahve'nin önünde sallamalık sunu olarak sallayacak. Sallanan döş ve sunulan butla birlikte bunlar kâhin için kutsaldır. Bundan sonra Nezir şarap içebilir. ");
INSERT INTO turytc_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“'Adak adayan Neziri'nin, gücünün yettiği diğer şeylerin yanı sıra, ayrılığı için Yahve'ye sunusunun yasası budur. Adadığı adak uyarınca, kendi ayrılığının yasasına göre böyle yapmalıdır.'” ");
INSERT INTO turytc_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aron'la ve oğullarıyla konuş ve şöyle de: İsrael'in çocuklarını böyle kutsayacaksınız. Onlara diyeceksiniz: ");
INSERT INTO turytc_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","'Yahve sizi kutsasın ve korusun. ");
INSERT INTO turytc_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yahve yüzünü sizin üzerinizde ışıldatsın ve size lütfetsin. ");
INSERT INTO turytc_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yahve yüzünü size doğru kaldırsın ve size esenlik versin.' ");
INSERT INTO turytc_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Böylece İsrael'in çocukları üzerine adımı koyacaklar; ve ben onları kutsayacağım.” ");
INSERT INTO turytc_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moşe konutu kurmayı bitirdiği, onu meshettiği, tüm takımlarıyla birlikte, sunağı da tüm eşyalarıyla birlikte kutsadığı ve onları mesh edip kutsadığı gün; ");
INSERT INTO turytc_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","atalarının evlerinin başları olan İsrael beyleri sunular sundular. Bunlar oymakların beyleriydi. Bunlar, sayılanların başında olanlardı; ");
INSERT INTO turytc_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","her iki beye bir araba ve her birine bir öküz olmak üzere, Yahve'nin önüne sunularını altı kapalı araba ve on iki öküz getirdiler. Bunları konutun önünde takdim ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Buluşma Çadırı'nın hizmetinde kullanılmak üzere bunları onlardan al; ve bunları her adama hizmetine göre Levililer'e vereceksin.” ");
INSERT INTO turytc_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moşe arabaları ve öküzleri alıp Levililer'e verdi. ");
INSERT INTO turytc_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Yaptıkları hizmete göre Gerşon'un oğullarına iki araba ve dört öküz verdi. ");
INSERT INTO turytc_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Kâhin Aron oğlu İtamar'ın yönetimi altında Merari'nin oğullarına hizmetlerine göre dört araba ve sekiz öküz verdi. ");
INSERT INTO turytc_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ancak Kohat'ın oğullarına hiçbir şey vermedi; çünkü kutsal yerin hizmeti onlara aitti; onu omuzlarında taşırlardı. ");
INSERT INTO turytc_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Beyler sunağın meshedildiği gün onun adanması için sunular sundular. Beyler sunağın önünde sunularını sundular. ");
INSERT INTO turytc_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahve Moşe'ye şöyle dedi: “Sunağın adanması için her bey kendi gününde kendi sunularını sunacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","İlk gün sunusunu sunan kişi Yahuda oymağından Amminadav oğlu Nahşon'du, ");
INSERT INTO turytc_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","onun sunusu şunlardı: Kutsal yerin şekeline göre, ağırlığı yüz otuz şekel olan bir gümüş tepsi, yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","buhurla dolu on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","yakmalık sunu için bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Amminadav oğlu Nahşon'un sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","İkinci gün sunusunu sunan İssakar beyi Suar oğlu Netanel'di. ");
INSERT INTO turytc_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Sunusu olarak şunları sundu: Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","yakmalık sunu olarak bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","esenlik kurbanı olarak iki sığır, beş koç, beş teke, bir yaşında beş erkek kuzu. Bu, Suar oğlu Netanel'in sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Üçüncü gün Zevulunoğulları'nın beyi Helon oğlu Eliav sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","yakmalık sunu olarak bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Helon oğlu Eliav'ın sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Dördüncü gün Ruvenoğulları beyi Şedeur oğlu Elizur sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","yakmalık sunu için bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Şedeur oğlu Elizur'un sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Beşinci gün Şimonoğulları beyi Surişadday oğlu Şelumiel sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","buhurla dolu on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","yakmalık sunu olarak bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","günah sunusu için bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","esenlik kurbanı için iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu; bu, Surişadday oğlu Şelumiel'in sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Altıncı gün, Gadoğulları'nın beyi Deuel oğlu Elyasaf sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","yakmalık sunu olarak bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Deuel oğlu Elyasaf'ın sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Yedinci gün Efraimoğulları beyi Ammihud oğlu Elişama sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","buhurla dolu, on şekellik bir altın kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","yakmalık sunu olarak bir genç boğa, bir koç ve bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Ammihud oğlu Elişama'nın sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sekizinci gün Manaşşeoğulları beyi Pedahzur oğlu Gamaliel sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","yakmalık sunu için bir genç boğa, bir koç, bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","günah sunusu için bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Pedahzur oğlu Gamaliel'in sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Dokuzuncu gün Benyaminoğulları beyi Gideoni oğlu Avidan sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","yakmalık sunu için bir genç boğa, bir koç, bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","günah sunusu için bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Gideoni oğlu Avidan'ın sunusuydu ");
INSERT INTO turytc_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Onuncu gün Danoğulları beyi Ammişadday oğlu Ahiezer sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","yakmalık sunu için bir genç boğa, bir koç, bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","günah sunusu için bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Ammişadday oğlu Ahiezer'in sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On birinci gün Aşeroğulları beyi Okran oğlu Pagiel sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","buhurla dolu, on şekellik altın bir kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","yakmalık sunu için bir genç boğa, bir koç, bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","günah sunusu için bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Okran oğlu Pagiel'in sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On ikinci gün Naftalioğulları beyi Enan oğlu Ahira sunusunu sundu: ");
INSERT INTO turytc_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ağırlığı yüz otuz şekel olan bir gümüş tepsi, kutsal yerin şekeline göre yetmiş şekellik bir gümüş tas; bunların her ikisi de ekmek sunusu için yağla yoğrulmuş ince unla doluydu; ");
INSERT INTO turytc_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","buhurla dolu, on şekellik bir altın kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","yakmalık sunu için bir genç boğa, bir koç, bir yaşında bir erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","günah sunusu olarak bir teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","esenlik kurbanı olarak iki sığır, beş koç, beş teke ve bir yaşında beş erkek kuzu. Bu, Enan oğlu Ahira'nın sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Sunağın İsrael beyleri tarafından meshedildiği gün onun adama sunusu şunlardı: On iki gümüş tepsi, on iki gümüş tas, on iki altın kepçe; ");
INSERT INTO turytc_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","her biri yüz otuz şekel ağırlığında gümüş tepsi ve her tas yetmiş şekel; kapların tüm gümüşü, kutsal yerin şekeline göre iki bin dört yüz şekeldi; ");
INSERT INTO turytc_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","kutsal yerin şekeline göre her biri on şekel ağırlığında, buhurla dolu on iki altın kepçe; kepçelerdeki altınların tamamının ağırlığı yüz yirmi şekeldi; ");
INSERT INTO turytc_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","yakmalık sunu için bütün sığırlar on iki boğa, on iki koç, bir yaşında on iki erkek kuzu ve bunların ekmek sunusu; ve günah sunusu olarak on iki teke; ");
INSERT INTO turytc_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ve esenlik sunuları kurbanı için bütün sığırlar: Yirmi dört boğa, altmış koç, altmış teke ve birer yaşında altmış erkek kuzu. Bu, sunağın meshedilmesinden sonra sunulan adama sunusuydu. ");
INSERT INTO turytc_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Moşe, Yahve'yle konuşmak için Buluşma Çadırı'na girdiğinde, Levha Sandığı'nın üzerindeki Merhamet Örtüsü'nün üzerinden, iki keruvun arasından, kendisiyle konuşan O'nun sesini duydu; ve O'nunla konuştu. ");
INSERT INTO turytc_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aron'la konuş ve ona söyle: 'Kandilleri yaktığında, yedi kandil şamdanın önüne ışık verecek.'” ");
INSERT INTO turytc_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron öyle yaptı. Yahve'nin Moşe'ye buyurduğu gibi, şamdanın önündeki alanı aydınlatmak için kandillerini yaktı. ");
INSERT INTO turytc_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bu, şamdan işçiliğiydi, dövmeci işi altındı. Tabanından çiçeklerine kadar dövmeci işiydi. Şamdanı Yahve'nin Moşe'ye gösterdiği örneğe göre yaptı. ");
INSERT INTO turytc_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Levililer'i İsrael'in çocukları arasından alıp onları temizle. ");
INSERT INTO turytc_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Onları temizlemek için şunu yapacaksın: Arınma suyunu üzerlerine serp, bütün vücutlarını usturayla tıraş etsinler, giysilerini yıkasınlar ve kendilerini temizlesinler. ");
INSERT INTO turytc_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Sonra genç bir boğayla onun ekmek sunusunu, yağla yoğrulmuş ince unu alsınlar; ve günah sunusu olarak başka bir genç boğa alacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Levililer'i Buluşma Çadırı'nın önüne çıkaracaksın. İsrael'in çocuklarının bütün topluluğunu bir araya toplayacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Levililer'i Yahve'nin önüne çıkaracaksın. İsrael'in çocukları ellerini Levililer'in üzerine koyacaklar, ");
INSERT INTO turytc_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aron, Yahve'ye hizmet etmek onların işi olsun diye, İsrael'in çocuklarının adına Levililer'i sallamalık sunu olarak Yahve'nin önünde sunacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Levililer ellerini boğaların başları üzerine koyacaklar; sen de Levililer'in günahlarını bağışlatmak için birini günah sunusu, diğerini de yakmalık sunu olarak Yahve'ye sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Levililer'i Aron'la oğullarının önünde durduracaksın ve onları sallamalık sunu olarak Yahve'ye sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Böylece Levililer'i İsrael'in çocuklarının arasından ayıracaksın ve Levililer benim olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Bundan sonra Levililer Buluşma Çadırı'ndaki hizmete girecekler. Onları temizleyip sallamalık sunu olarak sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Çünkü İsrael'in çocuklarının arasından onların tamamı bana verildi; rahmi açanların hepsinin yerine, bütün İsrael'in çocuklarının ilk doğanlarının yerine, onları kendime aldım. ");
INSERT INTO turytc_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Çünkü İsrael'in çocuklarının arasında ilk doğanların tümü, insan olsun, hayvan olsun, benimdir. Mısır diyarında ilk doğanların hepsini vurduğum gün, onları kendim için kutsal kıldım. ");
INSERT INTO turytc_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","İsrael'in çocuklarının arasında ilk doğanların yerine Levililer'i aldım. ");
INSERT INTO turytc_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","İsrael'in çocukları kutsal yere yaklaştığı zaman İsrael'in çocukları arasında bela olmasın diye, Buluşma Çadırı'nda İsrael'in çocuklarına hizmet etmeleri ve İsrael'in çocuklarına kefaret etmeleri için İsrael'in çocukları arasından Levililer'i Aron'a ve oğullarına hediye olarak verdim.” ");
INSERT INTO turytc_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moşe, Aron ve İsrael'in çocuklarının bütün topluluğu Levililer'e böyle yaptılar. Yahve'nin Levililer hakkında Moşe'ye buyurduğu her şeye göre İsrael'in çocukları da onlara öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levililer kendilerini günahtan arındırıp giysilerini yıkadılar; Aron, Yahve'nin önünde onları sallamalık sunu olarak sundu ve Aron onları temizlemek üzere onlar için kefaret etti. ");
INSERT INTO turytc_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Bundan sonra Levililer, Aron'un ve oğullarının önünde hizmetlerini yapmak üzere Buluşma Çadırı'na girdiler; Yahve'nin Levililer hakkında Moşe'ye buyurduğu gibi onlara öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Levililer'e verilen görev şudur: Yirmi beş yaş ve üstünde olanlar, Buluşma Çadırı hizmetinde hizmet etmek üzere içeri girecekler; ");
INSERT INTO turytc_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","elli yaşını doldurduktan sonra hizmetten ayrılacaklar ve artık hizmet etmeyecekler. ");
INSERT INTO turytc_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ancak Buluşma Çadırı'ndaki kardeşlerinin görevi yerine getirmesine yardım edecekler ve hizmet etmeyecekler. Levililer'e görevlerini böyle yaptıracaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Mısır diyarından çıkışlarının ikinci yılının birinci ayında, Yahve Sina Çölü'nde Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“İsrael'in çocukları Pesah'ı belirlenen zamanda tutsunlar. ");
INSERT INTO turytc_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Bu ayın on dördüncü günü akşam, onu belirlenen zamanda tutacaksınız. Onu tüm kurallarına ve tüm ilkelerine göre tutacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moşe İsrael'in çocuklarına Pesah'ı tutmaları gerektiğini söyledi. ");
INSERT INTO turytc_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Birinci ayın on dördüncü günü akşam vakti Sina Çölü'nde Pesah'ı tuttular. Yahve'nin Moşe'ye buyurduğu her şeye göre İsrael'in çocukları öyle yaptı. ");
INSERT INTO turytc_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","İnsan ölüsü nedeniyle kirli sayılan, o gün Pesah'ı tutamayan bazı insanlar vardı ve o gün Moşe'yle Aron'un önüne geldiler. ");
INSERT INTO turytc_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Bu kişiler ona, “İnsan ölüsü yüzünden kirliyiz” dediler. “Yahve'nin sunusunu belirlenen zamanda İsrael'in çocuklarının arasında sunmamamız için neden geri tutuluyoruz?” ");
INSERT INTO turytc_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moşe onlara şu karşılığı verdi: “Durun da Yahve'nin sizin için ne buyuracağını duyayım.” ");
INSERT INTO turytc_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“İsrael'in çocuklarına de ki: 'Sizden ya da soylarınızdan herhangi biri ölü yüzünden kirliyse, ya da uzak bir yolculuktaysa, yine de Yahve'ye Pesah tutacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","İkinci ayın on dördüncü günü akşam onu tutacaklar; onu mayasız ekmek ve acı otlarla yiyecekler. ");
INSERT INTO turytc_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sabaha kadar ondan bir şey bırakmayacaklar, bir kemiğini bile kırmayacaklar. Pesah kuralına göre onu tutacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ama temiz olup yolculukta olmayan ve Pesah'ı tutmayan insanın canı halkından atılacaktır. Belirlenen zamanda Yahve'ye sunu sunmadığı için bu adam günahını yüklenecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“'Aranızda yaşayan bir yabancı Yahve'ye Pesah tutmak isterse, bunu Pesah kuralına ve ilkesine göre yapacaktır. Hem yabancı, hem de ülkede doğan kişi için tek bir kural olacak.'” ");
INSERT INTO turytc_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Konutun kurulduğu gün bulut, konutu, Levha Sandığı'nı örttü. Akşamleyin ateş görünüşü gibi sabaha kadar konutun üzerindeydi. ");
INSERT INTO turytc_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Böylece hep devam etti. Bulut onu örterdi, geceleyin de ateş görünümü. ");
INSERT INTO turytc_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Bulut Çadır'ın üzerinden kaldırılınca İsrael'in çocukları yola çıkardı; bulutun durduğu yerde de İsrael'in çocukları konaklardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","İsrael'in çocukları Yahve'nin buyruğuna göre yola çıkarlar ve Yahve'nin buyruğuna göre konaklarlardı. Bulut konutun üzerinde durduğu sürece konaklarlardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bulut konutun üzerinde çok günler kaldığı zaman İsrael'in çocukları Yahve'nin buyruğunu tutar ve yola çıkmazlardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Bazen konutun üzerinde bulut birkaç gün kalırdı; o zaman Yahve'nin buyruğuna göre konaklar ve Yahve'nin buyruğuna göre yola çıkarlardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Bazen bulut akşamdan sabaha kadar dururdu; ve sabahleyin bulut kaldırıldığında yola çıkarlardı; ya da gece gündüz bulut kaldırıldığında yolculuk yaparlardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Bulut ister iki gün, ister bir ay, ister bir yıl olsun konutun üzerinde durduğunda, İsrael'in çocukları konaklar ve yola çıkmazlardı; ancak kaldırıldığında yola çıkarlardı. ");
INSERT INTO turytc_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Yahve'nin buyruğuna göre konaklar ve Yahve'nin buyruğuna göre yola çıkarlardı. Yahve'nin Moşe aracılığıyla verdiği buyruk üzerine, Yahve'nin buyruğunu tutarlardı. ");
INSERT INTO turytc_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Gümüşten iki boru yap. Onları dövmeci işi olarak yapacaksın. Bunları topluluğu çağırmak ve orduların yola çıkması için kullanacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Onlar çalınınca, bütün topluluk Buluşma Çadırı'nın kapısında senin yanında toplanacak. ");
INSERT INTO turytc_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Biri bile çalınırsa, o zaman beyler, İsrael binlerinin başları senin yanında toplanacak. ");
INSERT INTO turytc_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Yüksek sesle çaldığınızda doğu tarafında konaklayan ordular yola çıkacak. ");
INSERT INTO turytc_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","İkinci kez yüksek sesle çaldığınızda güney tarafında konaklayan ordular yola çıkacak. Yola çıkmaları için yüksek sesle çalacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Topluluk toplanacağı zaman çalacaksınız, ancak yüksek sesle çalmayacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Boruları Aron'un oğulları, kâhinler çalacaklar. Bu sizin için kuşaklar boyu daima geçerli bir kural olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ülkenizde size baskı yapan düşmana karşı savaşa gittiğinizde, boruları yüksek sesle çalacaksınız. O zaman Tanrınız Yahve'nin önünde anılacak ve düşmanlarınızdan kurtulacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Ayrıca sevinç günlerinde, bayramlarınızda ve aylarınızın başında, yakmalık sunularınızın ve esenlik sunularınızın üzerinde boruları çalacaksınız; ve onlar Tanrı'nın önünde sizin için anılma olacaklar. Ben Tanrınız Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","İkinci yıl, ikinci ayın yirminci günü, bulut antlaşma konutunun üzerinden kaldırıldı. ");
INSERT INTO turytc_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","İsrael'in çocukları Sina Çölü'nden yolculuklarına devam ettiler; ve bulut Paran Çölü'nde durdu. ");
INSERT INTO turytc_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Yahve'nin Moşe aracılığıyla verdiği buyruğa uyarak ilk defa yola çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Önce Yahuda çocukları ordugâhının bayrağı ordularına göre yola çıktı. Amminadav oğlu Nahşon onun ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Suar oğlu Netanel, İssakar'ın çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Helon oğlu Eliav, Zevulun'un çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Konut indirildi; ve konutu taşıyan Gerşon'un oğulları ile Merari'nin oğulları yola çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruven ordugâhının bayrağı ordularına göre yola çıktı. Şedeur oğlu Elizur ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Surişadday oğlu Şelumiel, Şimon'un çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Deuel oğlu Elyasaf, Gad'ın çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kohatlılar kutsal yeri taşıyarak yola çıktılar. Diğerleri onlar gelmeden önce konutu kurarlardı. ");
INSERT INTO turytc_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efraim'in çocukları ordugâhının bayrağı ordularına göre yola çıktı. Ammihud oğlu Elişama onun ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedahzur oğlu Gamaliel, Manaşşe'nin çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gideoni oğlu Avidan Benyamin'in çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Bütün ordugâhların arka muhafızı olan Dan'ın çocukları ordugâhının bayrağı, ordularına göre yola çıktı. Ammişhadday oğlu Ahiezer onun ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okran oğlu Pagiel Aşer'in çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enan oğlu Ahira, Naftali'nin çocukları oymağının ordusunun başındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ordularına göre İsrael'in çocuklarının yola çıkışları şöyleydi; ve onlar göç ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moşe, kayınpederi Midyanlı Reuel'in oğlu Hovav'a şöyle dedi: “Yahve'nin, 'Size vereceğim' dediği yere gidiyoruz. Bizimle gel, sana iyilik ederiz; çünkü Yahve İsrael hakkında iyilik konuştu.” ");
INSERT INTO turytc_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ona, “Gitmeyeceğim” dedi. “Yalnız kendi topraklarıma ve akrabalarımın yanına gideceğim.” ");
INSERT INTO turytc_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moşe, “Lütfen bizden ayrılma” dedi. “Çünkü çölde nasıl konaklayacağımızı sen biliyorsun ve bizim gözümüz olursun. ");
INSERT INTO turytc_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Eğer bizimle gidersen, o zaman öyle olacak ki, Yahve bize ne iyilik yaparsa, biz de sana aynısını yapacağız.” ");
INSERT INTO turytc_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Yahve'nin Dağı'ndan üç günlük yol aldılar. Yahve'nin Antlaşma Sandığı, onlara dinlenme yeri bulmak için üç günlük yol boyunca önlerinden gidiyordu. ");
INSERT INTO turytc_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ordugâhtan yola çıkarken Yahve'nin bulutu gündüzün onların üzerindeydi. ");
INSERT INTO turytc_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sandık yola çıktığında Moşe şöyle dedi: “Kalk, ey Yahve, düşmanların dağılsın! Senden nefret edenler önünden kaçsın!” ");
INSERT INTO turytc_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sandık durduğunda, “Ey Yahve, onbinlerce, binlerce İsraelli'ye dön” derdi. ");
INSERT INTO turytc_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Halk Yahve'nin kulağına yakınıyordu. Yahve bunu duyunca öfkesi alevlendi; ve Yahve'nin ateşi onların arasında yandı ve ordugâhın bazı kenar kısımlarını kül etti. ");
INSERT INTO turytc_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Halk Moşe'ye feryat etti; Moşe Yahve'ye dua etti ve ateş geçti. ");
INSERT INTO turytc_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","O yere Taberah adı verildi, çünkü onların arasında Yahve'nin ateşi yandı. ");
INSERT INTO turytc_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Onların arasındaki karışık halk aşırı derecede iştahlandı; İsrael'in çocukları da yine ağlayıp dediler: “Bize yememiz için kim et verecek?” ");
INSERT INTO turytc_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mısır'da bedava yediğimiz balığı hatırlıyoruz; salatalıkları, kavunları, pırasaları, soğanlar ve sarımsakları; ");
INSERT INTO turytc_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ama artık iştahımızı kaybettik. Bu mandan başka görülecek hiçbir şey yok.” ");
INSERT INTO turytc_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Kişniş tohumu gibi olan man, görünüşüyle de reçineye benziyordu. ");
INSERT INTO turytc_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Halk dolaşır, onu toplardı, değirmende öğütür ya da havanda döverdi, tencerelerde kaynatır ve pideler yaparlardı. Tadı taze yağın tadı gibiydi. ");
INSERT INTO turytc_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Gece ordugâhın üzerine çiy düştüğünde, üzerine man düşerdi. ");
INSERT INTO turytc_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moşe, herkesin çadırının kapısında, aile boyu ağladığını duydu; ve Yahve'nin öfkesi çok alevlendi; Moşe de hoşnutsuzdu. ");
INSERT INTO turytc_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moşe Yahve'ye şöyle dedi: “Hizmetkârına neden bu kadar kötü davrandın? Bütün bu halkın yükünü bana yüklediğin halde neden senin gözünde lütuf bulamadım? ");
INSERT INTO turytc_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bu halkın tümüne ben mi gebe kaldım? Bana, 'Atalarına ant içtiğin ülkeye, emzikteki çocuğu taşıyan bir dadı gibi onları koynunda taşı' diyesin diye mi onları dışarı çıkardım? ");
INSERT INTO turytc_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Bunca insana verecek eti nereden bulabilirim? Çünkü, 'Bana et ver de yiyelim' diyerek önümde ağlıyorlar. ");
INSERT INTO turytc_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Bu halkın tümünü ben tek başıma taşıyamam, çünkü bu benim için çok ağır. ");
INSERT INTO turytc_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Eğer bana böyle davranırsan, eğer gözünde lütuf bulduysam, lütfen beni hemen öldür; ve sefaletimi görmeyeyim.” ");
INSERT INTO turytc_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yahve Moşe'ye şöyle dedi: “Halkın ihtiyarları, onların ileri gelenleri olduğunu bildiğin İsrael ihtiyarlarından yetmiş kişiyi bana topla; ve onları Buluşma Çadırı'na getir ki, orada seninle dursunlar. ");
INSERT INTO turytc_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","İneceğim ve orada seninle konuşacağım. Senin üzerinde olan Ruh'tan alıp onların üzerine koyacağım; ve sen tek başına taşımayasın diye, halkın yükünü onlar seninle birlikte taşıyacaklar.” ");
INSERT INTO turytc_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Halka de ki, 'Yarın için hazırlık yaparak kendinizi kutsal kılın, et yiyeceksiniz; çünkü siz, “Kim bize yemek için et verecek? Çünkü Mısır'da halimiz iyiydi.” diyerek Yahve'nin kulaklarına ağladınız. Bu nedenle Yahve size et verecek ve yiyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Sadece bir gün, iki gün, beş gün, on gün, yirmi gün değil, ");
INSERT INTO turytc_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ancak bütün bir ay; ta ki o, burnunuzdan gelinceye kadar; sizi tiksindirinceye kadar yiyeceksiniz; çünkü aranızda olan Yahve'yi reddettiniz ve “Mısır'dan neden çıktık?” diyerek O'nun önünde ağladınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moşe şöyle dedi: “Aralarında bulunduğum halk yaya olarak altı yüz bin kişidir; ve sen, 'Bir ay boyunca yiyebilmeleri için onlara et vereceğim' dedin. ");
INSERT INTO turytc_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Onlara yetecek kadar davar ve sığır onlar için boğazlanacak mı? Onlara yetecek kadar denizin bütün balıkları onlar için toplanacak mı?” ");
INSERT INTO turytc_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahve Moşe'ye şöyle dedi: “Yahve'nin eli mi kısaldı? Şimdi benim sözümün başınıza gelip gelmeyeceğini göreceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moşe dışarı çıkıp halka Yahve'nin sözlerini anlattı; halkın ihtiyarlarından yetmiş kişiyi toplayıp Çadır'ın çevresinde durdurdu. ");
INSERT INTO turytc_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yahve bulutun içinde inip onunla konuştu ve kendisindeki Ruh'u alıp yetmiş ihtiyarın üzerine koydu. Ruh onların üzerinde durunca peygamberlik ettiler, ama bunu bir daha yapmadılar. ");
INSERT INTO turytc_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ancak ordugâhta iki kişi kaldı. Birinin adı Eldad, diğerinin adı Medad'dı; ve Ruh onların üzerine durdu. Onlar yazılanlar arasındaydı, ama Çadır'dan çıkmamış olanlardandı; ve ordugâhta peygamberlik ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Genç bir adam koşup Moşe'ye şöyle dedi: “Eldad'la Medad ordugâhta peygamberlik ediyorlar!” ");
INSERT INTO turytc_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Moşe'nin seçmiş olduğu adamlardan biri olan hizmetkârı Nun oğlu Yeşu, “Efendim Moşe, onlara yasak koy!” diye yanıt verdi. ");
INSERT INTO turytc_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moşe ona şöyle dedi: “Sen benim için mi kıskanıyorsun? Keşke Yahve'nin tüm halkı peygamber olsaydı ve Yahve onların üzerine Ruhu'nu koysaydı!” ");
INSERT INTO turytc_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moşe, kendisi ve İsrael'in ihtiyarları ordugâha girdiler. ");
INSERT INTO turytc_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Yahve'den çıkan rüzgâr denizden bıldırcınları getirdi ve onları ordugâhın yakınına düşürdü; bu tarafta yaklaşık bir günlük yol, diğer tarafta ise ordugâhın çevresinde bir günlük yol olmak üzere yerin yüzeyinden iki arşın kadar yüksekteydi. ");
INSERT INTO turytc_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Halk bütün o gün, bütün o gece ve bütün ertesi gün kalkıp bıldırcın topladı. En az toplayan on homer topladı ve kendileri için hepsini ordugâhın çevresine serdiler. ");
INSERT INTO turytc_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Et henüz dişlerinin arasındayken, daha çiğnenmeden, Yahve'nin öfkesi halka karşı alevlendi ve Yahve halkı çok büyük bir belayla vurdu. ");
INSERT INTO turytc_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","İştahlanan halkı oraya gömdüklerinden o yere Kivrot Hattaava adı verildi. ");
INSERT INTO turytc_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Halk Kivrot Hattaava'dan yola çıktı; ve Haserot'da kaldılar. ");
INSERT INTO turytc_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miryam ile Aron, evlendiği Kûşlu kadın yüzünden Moşe'ye karşı konuştular; çünkü Kûşlu bir kadınla evlenmişti. ");
INSERT INTO turytc_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Onlar şöyle dediler: “Yahve gerçekten yalnızca Moşe'yle mi konuştu? Bizimle de konuşmadı mı?” Ve Yahve bunu duydu. ");
INSERT INTO turytc_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moşe denen adam, yeryüzündeki bütün insanlardan çok daha alçakgönüllüydü. ");
INSERT INTO turytc_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yahve ansızın Moşe'ye, Aron'a ve Miryam'a, “Siz üçünüz Buluşma Çadırı'na çıkın!” dedi. Üçü de dışarı çıktı. ");
INSERT INTO turytc_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yahve bir bulut sütunu içinde indi, Çadır'ın kapısında durup Aron'la Miryam'ı çağırdı; ve ikisi de öne çıktı. ");
INSERT INTO turytc_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","“Şimdi sözlerimi dinleyin” dedi. “Eğer aranızda bir peygamber varsa, ben Yahve, görümde ona kendimi tanıtacağım. Onunla rüyada konuşacağım. ");
INSERT INTO turytc_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Hizmetkârım Moşe öyle değildir. O, tüm evimde sadıktır. ");
INSERT INTO turytc_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Onunla bilmecelerle değil, ağızdan ağıza konuşacağım; ve Yahve'nin suretini görecek. O halde neden hizmetkârımın aleyhinde, Moşe aleyhinde konuşmaktan korkmadınız?” ");
INSERT INTO turytc_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yahve'nin öfkesi onlara karşı alevlendi; ve oradan gitti. ");
INSERT INTO turytc_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Bulut Çadırın üzerinden ayrıldı; ve işte, Miryam kar gibi beyaz, cüzzamlıydı. Aron Miryam'a baktı ve onun cüzzamlı olduğunu gördü. ");
INSERT INTO turytc_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aron Moşe'ye şöyle dedi: “Efendim, lütfen akılsızlık ederek işlediğimiz günahı, bu günahı bize sayma. ");
INSERT INTO turytc_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Yalvarırım, o, annesinin rahminden çıktığında etinin yarısı tükenmiş bir ölü gibi olmasın.” ");
INSERT INTO turytc_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moşe Yahve'ye şöyle feryat etti: “Tanrım, onu iyileştir, sana yalvarırım!” ");
INSERT INTO turytc_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahve Moşe'ye şöyle dedi: “Eğer babası onun yüzüne tükürseydi, yedi gün utanması gerekmez miydi? Yedi gün orduğâhın dışında kapalı kalsın, ondan sonra tekrar içeri getirilecek.” ");
INSERT INTO turytc_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miryam yedi gün orduğâhın dışında kapatıldı ve Miryam tekrar getirilene kadar halk yola çıkmadı. ");
INSERT INTO turytc_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Daha sonra halk Haserot'tan ayrıldı ve Paran Çölü'nde konakladı. ");
INSERT INTO turytc_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“İsrael'in çocuklarına vereceğim Kenan ülkesini araştırsınlar diye adamlar gönder. Atalarının her oymağından bir adam göndereceksin, her biri aralarında bir bey olacak.” ");
INSERT INTO turytc_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moşe Yahve'nin buyruğu uyarınca onları Paran Çölü'nden gönderdi. Hepsi İsrael'in çocuklarının başları olan adamlardı. ");
INSERT INTO turytc_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Adları şunlardı: Ruven oymağından Zakkur oğlu Şammua. ");
INSERT INTO turytc_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Şimon oymağından Hori oğlu Şafat. ");
INSERT INTO turytc_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yahuda oymağından Yefunne oğlu Kalev. ");
INSERT INTO turytc_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","İssakar oymağından Yosef oğlu İgal. ");
INSERT INTO turytc_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraim oymağından Nun oğlu Hoşea. ");
INSERT INTO turytc_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benyamin oymağından Rafu oğlu Palti. ");
INSERT INTO turytc_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zevulun oymağından Sodi oğlu Gaddiel. ");
INSERT INTO turytc_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yosef oymağından, Manaşşe oymağından Susi oğlu Gaddi. ");
INSERT INTO turytc_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan oymağından Gemalli oğlu Ammiel. ");
INSERT INTO turytc_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aşer oymağından Mikael oğlu Setur. ");
INSERT INTO turytc_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali oymağından Vofsi oğlu Nahbi. ");
INSERT INTO turytc_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad oymağından Maki oğlu Geuel. ");
INSERT INTO turytc_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Moşe'nin ülkeyi araştırmak üzere gönderdiği adamların adları bunlardır. Moşe, Nun oğlu Hoşea'ya Yeşu adını verdi. ");
INSERT INTO turytc_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moşe onları Kenan ülkesini araştırmak üzere gönderip şöyle dedi: “Güneyden bu tarafa gidin ve dağlık bölgeye çıkın. ");
INSERT INTO turytc_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ülkenin nasıl olduğuna bakın; ve orada oturanlar, güçlü mü yoksa zayıf mı, az mı yoksa çok mu; ");
INSERT INTO turytc_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ve üzerinde oturdukları yer nasıl, iyi mi yoksa kötü mü, içinde oturdukları kentler nasıl, açık mı yoksa surlu mu; ");
INSERT INTO turytc_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ve toprağın nasıl, verimli mi yoksa zayıf mı, içinde ağaç var mı yoksa yok mu? Cesur olun ve memleketin ürününden biraz getirin.” Şimdi vakit üzüm turfandası zamanıydı. ");
INSERT INTO turytc_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Böylece çıkıp Zin Çölü'nden Rehov'a, Hamat'ın girişine kadar olan ülkeyi araştırdılar. ");
INSERT INTO turytc_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Güney yönünde ilerleyerek Hevron'a geldiler; Anak'ın çocukları Ahiman, Şeşay ve Talmay da oradaydı. (Hevron, Mısır'daki Soan'dan yedi yıl önce kurulmuştu.) ");
INSERT INTO turytc_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Eşkol Vadisi'ne geldiler ve oradan bir salkım üzüm ile birlikte bir dal kestiler ve onu iki adam sırıkta taşıdı. Biraz narlardan ve incirlerden de getirdiler. ");
INSERT INTO turytc_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","İsrael'in çocuklarının oradan kestiği salkımlardan dolayı oraya Eşkol Vadisi denildi. ");
INSERT INTO turytc_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kırk gün sonra ülkeyi araştırmaktan döndüler. ");
INSERT INTO turytc_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paran Çölü'ne, Kadeş'e gidip Moşe'nin, Aron'un ve İsrael'in çocuklarının bütün topluluğunun yanına geldiler; ve onlara ve tüm topluluğa haber getirdiler. Onlara memleketin ürününü gösterdiler. ");
INSERT INTO turytc_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Bunu ona bildirip dediler: “Bizi gönderdiğin ülkeye vardık. Gerçekten süt ve bal akıyor ve bu da onun ürünüdür. ");
INSERT INTO turytc_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ancak ülkede oturan halk güçlü, kentler surlu ve çok büyük. Üstelik Anak'ın çocuklarını da orada gördük. ");
INSERT INTO turytc_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek Güney ülkesinde oturuyor. Hititler, Yebuslular ve Amorlular dağlık bölgede oturuyorlar. Kenanlılar deniz kıyısında ve Yarden kıyısı boyunca oturuyorlar.” ");
INSERT INTO turytc_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalev Moşe'nin önünde halkı susturdu ve şöyle dedi: “Hemen çıkıp orayı ele geçirelim; çünkü biz bunun üstesinden gelebiliriz!” ");
INSERT INTO turytc_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ama onunla birlikte çıkan adamlar şöyle dediler: “O halka karşı çıkmaya gücümüz yetmez; çünkü onlar bizden daha güçlüdürler.” ");
INSERT INTO turytc_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Araştırdıkları ülke hakkında İsrael'in çocuklarına kötü haber getirdiler ve şöyle dediler: “Araştırmak için içinden geçtiğimiz ülke, içinde oturanları yiyip bitiren bir ülkedir; ve orada gördüğümüz insanların hepsi uzun boylu insanlardı. ");
INSERT INTO turytc_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Orada Nefilim'den gelen Anak'ın oğullarını Nefilim'i gördük. Kendi gözümüzde çekirgeler gibiydik ve onların gözünde de öyleydik.” ");
INSERT INTO turytc_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Bütün topluluk sesini yükseltip bağırdı; ve insanlar o gece ağladılar. ");
INSERT INTO turytc_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bütün İsrael'in çocukları Moşe'ye ve Aron'a karşı söylendiler. Bütün topluluk onlara şöyle dedi: “Keşke Mısır diyarında ölseydik, ya da bu çölde ölseydik! ");
INSERT INTO turytc_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Yahve bizi neden bu ülkeye kılıçla düşelim diye götürüyor? Karılarımız ve çocuklarımız ya yakalanacak, ya da öldürülecek! Mısır’a dönmemiz daha iyi olmaz mı?” ");
INSERT INTO turytc_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Birbirlerine, “Bir önder seçip Mısır'a dönelim” dediler. ");
INSERT INTO turytc_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Bunun üzerine Moşe ile Aron, İsrael'in çocukları topluluğunun bütün meclisi önünde yüzüstü yere kapandılar. ");
INSERT INTO turytc_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ülkeyi araştıranlardan Nun oğlu Yeşu ile Yefunne oğlu Kalev giysilerini yırttılar. ");
INSERT INTO turytc_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","İsrael'in çocuklarının bütün topluluğuna şöyle dediler: “Araştırmak için içinden geçtiğimiz ülke son derece iyi bir ülkedir. ");
INSERT INTO turytc_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Eğer Yahve bizden hoşnutsa, bizi bu ülkeye, süt ve bal akan ülkeye getirecek ve onu bize verecektir. ");
INSERT INTO turytc_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yalnız Yahve'ye isyan etmeyin, ülke halkından da korkmayın; çünkü onlar bizim için ekmektir. Savunmaları onların üzerinden kaldırıldı ve Yahve bizimledir. Onlardan korkmayın.” ");
INSERT INTO turytc_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ama bütün topluluk onları taşlamakla tehdit etti. Yahve'nin görkemi Buluşma Çadırı'nda bütün İsrael'in çocuklarına göründü. ");
INSERT INTO turytc_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yahve Moşe'ye şöyle dedi: “Bu halk beni ne zamana dek küçümseyecek? Aralarında yapmış olduğum tüm belirtilere rağmen ne zamana dek bana inanmayacaklar? ");
INSERT INTO turytc_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Onları vebayla vuracağım, onları mirastan mahrum bırakacağım ve seni onlardan daha büyük ve daha güçlü bir ulus yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moşe Yahve'ye şöyle dedi: “O zaman Mısırlılar bunu duyacak; çünkü bu halkı kendi gücünle onların arasından çıkardın. ");
INSERT INTO turytc_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bunu bu ülkede oturanlara anlatacaklar. Sen, Yahve'nin bu halkın arasında olduğunu duydular; çünkü sen, Yahve yüz yüze görünüyorsun ve senin bulutun onların üzerinde duruyor; sen gündüz bulut sütunu içinde, gece ateş sütunu içinde onların önünde yürüyorsun. ");
INSERT INTO turytc_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Eğer bu halkı bir adam gibi öldürürsen, o zaman ününü duyan uluslar şöyle diyecekler, ");
INSERT INTO turytc_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Çünkü Yahve bu halkı kendilerine ant içerek söz verdiği ülkeye götüremediği için onları çölde katletti.' ");
INSERT INTO turytc_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Şimdi, söyleyip dediğin gibi, lütfen Efendi'nin gücü büyük olsun, ");
INSERT INTO turytc_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'Yahve öfkelenmekte yavaştır, sevgi dolu iyiliği boldur, haksızlığı ve itaatsizliği bağışlar; suçluyu asla temize çıkarmaz, babaların suçu için çocukların, üçüncü ve dördüncü kuşaklarını ziyaret eder.' ");
INSERT INTO turytc_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Mısır'dan bugüne kadar bu halkı bağışladığın gibi, sevginin büyüklüğüne göre, lütfen, bu halkın suçunu bağışla.” ");
INSERT INTO turytc_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yahve şöyle dedi: “Senin sözün uyarınca bağışladım; ");
INSERT INTO turytc_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ancak gerçekte, varlığımın hakkı için, tüm dünya Yahve'nin görkemi ile dolacaktır, ");
INSERT INTO turytc_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","çünkü yüceliğimi ve Mısır'da, çölde yaptığım harikalarımı gören bütün bu adamlar, yine de beni on kez denediler, benim sözümü de dinlemediler; ");
INSERT INTO turytc_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","atalarına ant içtiğim ülkeyi kesin olarak görmeyecekler, beni küçümseyenlerden hiçbiri orayı görmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ama hizmetkârım Kalev'i, kendisinde başka bir ruh olduğu ve tümüyle peşimden geldiği için gitmiş olduğu ülkeye onu götüreceğim. Onun soyu onu mülk edinecektir. ");
INSERT INTO turytc_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amalekliler ile Kenanlılar vadide oturduğu için, yarın dönüp Kızıldeniz yolundan çöle gidin.” ");
INSERT INTO turytc_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Bana karşı söylenen bu kötü topluluğa daha ne kadar katlanacağım? İsrael'in çocuklarının bana karşı olan söylenmelerini duydum. ");
INSERT INTO turytc_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Onlara de ki, 'Varlığım hakkı için diyor Yahve, kulaklarıma söylediğiniz gibi, kesinlikle size de öyle yapacağım. ");
INSERT INTO turytc_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Cesetleriniz bu çöle serilecek; bana karşı söylenen yirmi yaş ve üzeri, tam sayınıza göre sizden tüm sayılanlar, ");
INSERT INTO turytc_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","sizi orada oturtacağıma ant içtiğim ülkenin içine, Kalev, Yefunne oğlu ve Nun oğlu Yeşu dışında siz kesin olarak girmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ama yakalanacaklarını ya da öldürüleceklerini söylediğiniz çocuklarınızı oraya götüreceğim ve sizin reddettiğiniz ülkeyi onlar bilecekler. ");
INSERT INTO turytc_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ama size gelince, cesetleriniz bu çöle serilecek. ");
INSERT INTO turytc_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Çocuklarınız kırk yıl çölde dolaşacak ve cesetleriniz çölde tükeninceye kadar sizin fahişeliğinize katlanacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ülkeyi araştırdığınız günlerin sayısı kadar, kırk gün, her gün için bir yıl, kırk yıl boyunca suçlarınıza katlanacaksınız ve size yabancı olduğumu bileceksiniz.' ");
INSERT INTO turytc_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ben, Yahve, söyledim. Bunu bana karşı toplanan bütün bu kötü topluluğa mutlaka yapacağım. Bu çölde yok olup gidecekler ve orada ölecekler.” ");
INSERT INTO turytc_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Moşe'nin ülkeyi araştırmak için gönderdiği adamlar geri döndüler ve ülke hakkında kötü haberler çıkararak tüm topluluğu ona karşı söylendiren adamlar, ");
INSERT INTO turytc_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ülkeyle ilgili kötü haberler getiren o adamlar Yahve'nin önünde vebadan öldüler. ");
INSERT INTO turytc_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ülkeyi araştırmak için giden adamlardan Nun oğlu Yeşu ile Yefunne oğlu Kalev sağ kaldılar. ");
INSERT INTO turytc_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moşe bu sözleri bütün İsrael'in çocuklarına söyledi ve halk büyük yas tuttu. ");
INSERT INTO turytc_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sabah erkenden kalkıp dağın tepesine çıkıp şöyle dediler: “İşte, biz buradayız ve Yahve'nin söz verdiği yere çıkacağız; çünkü günah işledik.” ");
INSERT INTO turytc_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moşe şöyle dedi: “Başarılı olunmayacak şey için neden şimdi Yahve'nin buyruğuna karşı geliyorsunuz? ");
INSERT INTO turytc_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Çıkmayın, çünkü Yahve aranızda değildir; bu şekilde düşmanlarınızın önünde vurulmayasınız. ");
INSERT INTO turytc_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Çünkü orada Amalekliler ve Kenanlılar önünüzdedir; Yahve'nin ardınca gitmekten döndüğünüz için kılıçtan geçirileceksiniz; bu nedenle Yahve sizinle olmayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ama onlar dağın tepesine çıkmakla hadlerini aştılar. Buna rağmen Yahve'nin Antlaşma Sandığı ve Moşe ordugâhtan ayrılmadı. ");
INSERT INTO turytc_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Bunun üzerine Amalekliler ve o dağda oturan Kenanlılar indiler ve onları vurup Horma'ya kadar kırdılar. ");
INSERT INTO turytc_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“İsrael'in çocuklarına söyle ve onlara de ki: 'Size vermekte olduğum, oturacağınız diyara girdiğinizde, ");
INSERT INTO turytc_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Yahve'ye ateşle yapılan sunu—yakmalık sunu olsun, ya da kurban olsun, ya da adak yerine getirme olsun, ya da gönülden verilen bir sunu olsun, ya da belli bayramlarınızda Yahve'ye hoş koku yapmak için sığırdan ya da davardan kurban olsun— ");
INSERT INTO turytc_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","o zaman sunusunu sunan kişi, Yahve’ye ekmek sunusu olarak dörtte bir hin yağla yoğrulmuş onda bir efa ince un sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Dökmelik sunu olarak, yakmalık sunu ya da kurbanla birlikte her kuzu için dörtte bir hin şarap hazırlayacaksın.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“'Koç için, ekmek sunusu için bir hinin üçte biri yağla yoğrulmuş onda iki efa ince un hazırlayacaksın; ");
INSERT INTO turytc_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ve dökmelik sunu olarak Yahve'ye hoş kokulu bir hin üçte bir oranında şarap sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Yakmalık sunu, kurban, adak yerine getirme, ya da esenlik sunuları için Yahve'ye boğa hazırladığında, ");
INSERT INTO turytc_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","boğayla birlikte ekmek sunusu olarak yarım hin yağla yoğrulmuş efanın onda üçü ince un sunacaktır; ");
INSERT INTO turytc_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ve dökme sunusu olarak, ateşle yapılan sunu, Yahve'ye hoş koku olarak yarım hin şarap sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Her boğa, her koç, her erkek kuzu ya da oğlak için böyle yapılacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hazırlayacağınız sayıya göre, herkesin sayısına göre öyle yapacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“'Memlekette doğan herkes bunları Yahve'ye ateşle yapılan, hoş kokulu bir sunu olarak bu şekilde yapacak. ");
INSERT INTO turytc_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Eğer bir yabancı sizinle birlikte garip olarak yaşıyorsa, ya da kuşaklarınız boyunca aranızda olan ve Yahve'ye ateşle yapılan, hoş kokulu bir sunu sunarsa, sizin yaptığınız gibi, öyle yapacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Topluluk için, hem sizin için, hem de yabancı olarak yaşayan garip için, kuşaklarınız boyunca daima geçerli olacak tek bir kural olacak. Siz nasılsanız, yabancı da Yahve'nin önünde öyle olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sizin için de, sizinle yabancı olarak yaşayan garip için de, bir yasa ve bir ilke olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“İsrael'in çocuklarına söyle ve onlara şunu de: 'Sizi götürmekte olduğum ülkeye girdiğinizde, ");
INSERT INTO turytc_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","böyle olacak, o ülkenin ekmeğinden yediğinizde, Yahve'ye sallamalık sunu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","İlk hamurunuzdan sallamalık sunu olarak bir pide sunacaksınız. Onu harman sallama sunusu olarak kaldıracaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kuşaklarınız boyunca Yahve'ye ilk hamurunuzdan sallamalık sunu sunacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“'Yanlış yaptığınızda ve Yahve'nin Moşe'ye söylediği tüm bu buyrukları, ");
INSERT INTO turytc_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Yahve'nin buyurduğu günden itibaren kuşaklarınız boyunca tutmadığınızda, ");
INSERT INTO turytc_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","o zaman böyle olacak; eğer bu, topluluk tarafından bilmeden yapılmışsa, tüm topluluk, yakmalık sunu, Yahve'ye hoş koku olarak genç bir boğa, usule göre onun ekmek sunusuyla dökmelik sunusunu, suç sunusu olarak bir teke sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kâhin İsrael'in çocuklarının bütün topluluğu için kefaret edecektir ve onlar bağışlanacaktır; çünkü bu bir hataydı ve hatalarından dolayı sunularını, Yahve'ye ateşle yapılan sunuyu ve onların günah sunusunu Yahve'nin önüne getirmişlerdir. ");
INSERT INTO turytc_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","İsrael'in çocuklarının bütün topluluğu ve aralarında garip olarak yaşayan yabancı da bağışlanacaktır; çünkü bu tüm insanlarla ilgilidir, farkında olmadan yapıldı.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“'Bir kimse bilmeden günah işlerse, o zaman günah sunusu olarak bir yaşında bir dişi keçi sunacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Yahve'nin önünde bilmeden günah işleyen can için kâhin kefaret edecek. Onun için kefaret edecek; o da bağışlanacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","İsrael'in çocukları arasında yerli olsun, aralarında oturan yabancı olsun, bilmeden yanlış bir şey yapan için, tek bir yasanız olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“'Ama ister yerli, ister yabancı olsun, herhangi bir şeyi bilinçli yapan can, Yahve'ye küfretmiştir. O can halkının arasından atılacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Yahve'nin sözünü küçümsediği ve buyruğu çiğnediği için o can mutlaka atılacaktır. Kötülüğü kendi üzerinde olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","İsrael'in çocukları çöldeyken Şabat Günü odun toplayan bir adam buldular. ");
INSERT INTO turytc_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Onu odun toplarken bulanlar onu Moşe'yle Aron'un ve bütün topluluğun yanına getirdiler. ");
INSERT INTO turytc_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ona ne yapılacağı bildirilmediği için onu gözaltına aldılar. ");
INSERT INTO turytc_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yahve Moşe'ye şöyle dedi: “O adam kesinlikle öldürülecektir. Bütün topluluk ordugâhın dışında onu taşlayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Yahve'nin Moşe'ye buyurduğu gibi, bütün topluluk onu ordugâhın dışına çıkardı ve onu taşlarla taşlayarak öldürdü. ");
INSERT INTO turytc_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahve Moşe'ye şöyle konuştu, ");
INSERT INTO turytc_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“İsrael'in çocuklarına söyle ve onlara kuşaklar boyunca giysilerinin kenarlarına saçak yapmalarını ve her eteğin saçağı üzerine mavi kordon koymalarını söyle. ");
INSERT INTO turytc_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Görebilmeniz ve Yahve'nin bütün buyruklarını hatırlayıp onları yapmanız için bu size bir saçak olacak; ta ki, ardınca fahişelik etmiş olduğunuz kendi yüreğinizin ve kendi gözlerinizin ardınca gitmeyesiniz; ");
INSERT INTO turytc_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","öyle ki, bütün buyruklarımı hatırlayıp yapasınız ve Tanrınız'a kutsal olasınız. ");
INSERT INTO turytc_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Tanrınız olmak için sizi Mısır diyarından çıkaran Tanrınız Yahve benim; Ben Tanrınız Yahve'yim.” ");
INSERT INTO turytc_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levi oğlu Kohat oğlu Yishar oğlu Korah, Ruven'in oğullarından Eliav'ın oğulları Datan ve Aviram ve Pelet oğlu On ile birlikte birkaç adam aldı. ");
INSERT INTO turytc_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","İsrael'in çocuklarından bazılarıyla birlikte, topluluğun iki yüz elli beyi, meclise çağrılanlar, tanınmış kişiler Moşe'nin önünde kalktılar. ");
INSERT INTO turytc_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Moşe ve Aron'a karşı bir araya gelerek şöyle dediler: “Kendinize gereğinden fazla pay çıkarıyorsunuz; çünkü bütün topluluk, onlardan her biri kutsaldır, Yahve de onların arasındadır. Neden kendinizi Yahve'nin topluluğu üstüne çıkarıyorsunuz?” ");
INSERT INTO turytc_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Moşe bunu duyunca yüzüstü kapandı. ");
INSERT INTO turytc_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Korah'la yanındakilere şöyle dedi: “Sabahleyin Yahve kendisinin olanı, kutsal olanı gösterecek ve onu kendisine yaklaştıracaktır. Seçeceği kişiyi kendisine yaklaştıracaktır. ");
INSERT INTO turytc_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Şunu yapın: Ey Korah ve yanındakiler kendinize buhurdanlar alın, ");
INSERT INTO turytc_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","içlerine ateş koyun ve yarın Yahve'nin önünde üzerlerine buhur koyun. Yahve'nin seçeceği kişi kutsal olacaktır. Siz çok ileri gittiniz, Levioğulları!” ");
INSERT INTO turytc_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moşe Korah'a şöyle dedi: “Şimdi dinleyin, ey Levioğulları! ");
INSERT INTO turytc_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Sizi kendisine yakınlaştırmak, Yahve'nin konutunda hizmet etmek ve topluluğun önünde durup onlara hizmet etmek için İsrael'in Tanrısı'nın sizi İsrael topluluğundan ayırması size az mı geldi? ");
INSERT INTO turytc_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Seni ve Levioğulları kardeşlerinin tümünü seninle birlikte kendisine yaklaştırmadı mı? Kâhinliği de mi arıyorsunuz? ");
INSERT INTO turytc_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Bu nedenle sen ve bütün yanındakiler Yahve'ye karşı bir araya geldiniz! Aron nedir ki, ona karşı söyleniyorsunuz?” ");
INSERT INTO turytc_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moşe Eliav'ın oğulları Datan ve Aviram'ı çağırmak için adam gönderdi; onlar da, “Çıkmayacağız!” dediler. ");
INSERT INTO turytc_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bizi süt ve bal akan bir diyardan çıkarıp çölde öldürmek için çıkarman azmış gibi, üzerimize bey de mi olacaksın? ");
INSERT INTO turytc_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Bizi süt ve bal akan bir diyara da getirmedin, miras olarak tarlalar ve bağlar da vermedin. Bu adamların gözlerini mi çıkaracaksın? Çıkmayacağız.” ");
INSERT INTO turytc_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moşe çok kızmıştı ve Yahve'ye şöyle dedi: “Onların sunularına değer verme. Onlardan bir eşek bile almadım, hiçbirini de incitmedim.” ");
INSERT INTO turytc_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moşe Korah'a şöyle dedi: “Sen ve bütün arkadaşların, sen, onlar ve Aron, yarın Yahve'nin önüne çıkın. ");
INSERT INTO turytc_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Her biriniz kendi buhurdanını alıp üzerine buhur koysun. Her biriniz kendi buhurdanını, iki yüz elli buhurdanını Yahve'nin önüne getirsin; sen ve Aron da, ikiniz de kendi buhurdanınızı getirin.” ");
INSERT INTO turytc_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Her biri kendi buhurdanını alıp içine ateş koydu, üzerine buhur koydu ve Moşe ve Aron'la birlikte Buluşma Çadırı'nın kapısında durdu. ");
INSERT INTO turytc_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah bütün topluluğu onlara karşı, Buluşma Çadırı'nın kapısında topladı. Yahve'nin görkemi bütün topluluğa göründü. ");
INSERT INTO turytc_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yahve Moşe ve Aron'a şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Bu topluluğun arasından ayrılın da onları bir anda tüketeyim!” ");
INSERT INTO turytc_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Yüzüstü yere kapanıp şöyle dediler: “Tanrı, tüm insan ruhlarının Tanrısı, bir kişi günah işleyince bütün topluluğa mı kızacaksın?” ");
INSERT INTO turytc_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Topluluğa söyle ve, 'Korah, Datan ve Aviram'ın çadırının çevresinden uzaklaş' de.” ");
INSERT INTO turytc_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moşe kalkıp Datan ve Aviram'ın yanına gitti; İsrael'in ihtiyarları da onun ardından gittiler. ");
INSERT INTO turytc_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Topluluğa şöyle dedi: “Lütfen bu kötü adamların çadırlarından ayrılın ve onların hiçbir şeyine dokunmayın, yoksa onların bütün günahlarıyla tükenirsiniz!” ");
INSERT INTO turytc_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Böylece onlar Korah'ın, Datan'ın ve Aviram'ın çadırının her yanından uzaklaştılar. Datan ile Aviram dışarı çıkıp karıları, oğulları ve küçük çocuklarıyla birlikte çadırlarının kapısında durdular. ");
INSERT INTO turytc_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moşe şöyle dedi: “Bütün bu işleri yapmam için Yahve'nin beni gönderdiğini bununla bileceksiniz; çünkü bunlar benim kendi fikrim değildir. ");
INSERT INTO turytc_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Eğer bu adamlar herkesin öldüğü gibi ölürse, ya da herkesin yaşadığını yaşarsa, o zaman Yahve beni göndermemiştir. ");
INSERT INTO turytc_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ama eğer Yahve yeni bir şey yaparsa ve yer ağzını açarsa, onları ve kendilerine ait olan her şeyi yutarsa ve onlar da diri diri Şeol'e inerlerse, o zaman bu adamların Yahve'yi küçümsediklerini anlayacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Tüm bu sözleri söylemeyi bitirince, onların altındaki yer yarıldı. ");
INSERT INTO turytc_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Yer ağzını açtı ve onları, ev halklarını, Korah'ın bütün adamlarını ve mallarını yuttu. ");
INSERT INTO turytc_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Böylece onlar ve onlara ait olanların hepsi diri diri Şeol'e indiler. Yer onların üzerine kapandı ve topluluğun arasından yok oldular. ");
INSERT INTO turytc_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Etraflarında bulunan İsrael'in tümü onların feryadı üzerine kaçtı; çünkü, “Yer bizi yutmasın!” dediler. ");
INSERT INTO turytc_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Yahve'nin yanından gelen ateş buhur sunan iki yüz elli kişiyi yiyip bitirdi. ");
INSERT INTO turytc_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kâhin Aron oğlu Eleazar'a söyle, o da yangından buhurdanları alıp ordugâhın dışına dağıtsın; çünkü onlar kutsaldır, ");
INSERT INTO turytc_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","kendi hayatlarına karşı günah işleyenlerin buhurdanlarıdır. Onları sunak için örtü olmak üzere dövülmüş levhalar yapsınlar, çünkü onları Yahve'nin önünde sundular. Bu nedenle kutsaldırlar. Bunlar İsrael'in çocuklarına bir belirti olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Kâhin Eleazar, yakılan adamların sunduğu tunç buhurdanları aldı; ");
INSERT INTO turytc_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aron'un soyundan olmayan hiçbir yabancı Yahve'nin önünde buhur yakmak üzere yaklaşmasın ve Korah ve onun arkadaşları gibi olmasın diye, İsrael'in çocuklarına anılma olmak üzere, Yahve'nin Moşe aracılığıyla kendisine söylemiş olduğu gibi sunak için örtü olarak buhurdanları dövdüler. ");
INSERT INTO turytc_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ama ertesi gün İsrael'in çocukları topluluğunun tümü Moşe'ye ve Aron'a karşı söylenip, “Yahve'nin halkını siz öldürdünüz!” dediler. ");
INSERT INTO turytc_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Topluluk Moşe'ye ve Aron'a karşı toplandığında, Buluşma Çadırı'na doğru baktılar. İşte, bulut onu örttü ve Yahve'nin görkemi ortaya çıktı. ");
INSERT INTO turytc_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moşe'yle Aron Buluşma Çadırı'nın önüne geldiler. ");
INSERT INTO turytc_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Bu topluluğun arasından çıkın da onları bir anda tüketeyim!” Yüzüstü kapandılar. ");
INSERT INTO turytc_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moşe Aron'a şöyle dedi: “Buhurdanını al, sunaktan üzerine ateş koy, üzerine buhur koy, onu hemen topluluğa taşı ve onlar için kefaret et; çünkü Yahve'nin yanından gazap çıktı! Veba başladı.” ");
INSERT INTO turytc_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron Moşe'nin dediğini yaptı ve topluluğun ortasına koştu. Halk arasında veba çoktan başlamıştı. Buhur yakıp halk için kefaret etti. ");
INSERT INTO turytc_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ölülerle diriler arasında durdu; veba da durdu. ");
INSERT INTO turytc_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Korah meselesi yüzünden ölenlerin yanı sıra vebadan ölenlerin sayısı da on dört bin yedi yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aron Moşe'nin yanına, Buluşma Çadırı'nın kapısına döndü ve salgın kesildi. ");
INSERT INTO turytc_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“İsrael'in çocuklarına söyle ve onlardan her ata evi için bir tane olmak üzere, atalarının evlerine göre bütün beylerinden on iki değnek al. Her birinin adını değneğinin üzerine yaz. ");
INSERT INTO turytc_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Aron'un adını Levi değneği üzerine yazacaksın. Atalarının evlerinin her beyi için bir değnek olacak. ");
INSERT INTO turytc_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Onları Buluşma Çadırı'nda sizinle buluştuğum Levha'nın önüne koyacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Seçeceğim adamın değneği tomurcuklanacak. İsrael'in çocuklarının size karşı söylenmelerini benden kaldıracağım.” ");
INSERT INTO turytc_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moşe İsrael'in çocuklarıyla konuştu; ve onların bütün beyleri ona, atalarının evlerine göre her bey için bir tane olmak üzere toplam on iki değnek verdiler. Aron'un değneği de onların değnekleri arasındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moşe değnekleri Tanıklık Çadırı'nda Yahve'nin önüne koydu. ");
INSERT INTO turytc_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ertesi gün Moşe Tanıklık Çadırı'na girdi; ve işte, Aron'un Levi evi için olan değneği filizlenmiş, tomurcuklanmış, çiçek açmış ve olgun bademler vermişti. ");
INSERT INTO turytc_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moşe bütün değnekleri Yahve'nin önünden bütün İsrael'in çocuklarına çıkardı. Baktılar ve her biri kendi değneğini aldı. ");
INSERT INTO turytc_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yahve Moşe'ye şöyle dedi: “İsyan çocuklarına karşı bir işaret olarak saklanmak üzere Aron'un değneğini yine Levha'nın önüne koy; ta ki, bana karşı söylenmelerine bir son ver ki, ölmesinler.” ");
INSERT INTO turytc_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moşe öyle yaptı. Yahve ona nasıl buyurduysa öyle yaptı. ");
INSERT INTO turytc_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","İsrael'in çocukları Moşe'ye şöyle dediler: “İşte, yok oluyoruz! İşimiz bitti! Hepimizin işi bitti! ");
INSERT INTO turytc_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Yahve'nin konutuna yaklaşan herkes ölüyor! Hepimiz yok mu olacağız?” ");
INSERT INTO turytc_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahve Aron'a şöyle dedi: “Kutsal yerin kötülüğünü sen ve seninle birlikte, oğulların ve atalarının evi taşıyacaksınız; sen ve seninle birlikte oğulların kâhinliğinizin suçunu taşıyacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kardeşlerinizi, atanızın oymağını, Levi oymağını da yanınıza getirin ki, onlar da size katılsınlar ve size hizmet etsinler; ama sen ve oğulların Levha Çadırı'nın önünde olacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Buyruklarınızı ve tüm Çadır'ın görevini tutacaklar; ancak ne onlar ne de siz ölmeyesiniz diye kutsal yerdeki takımlara ve sunağa yaklaşmayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Onlar size katılacak ve Buluşma Çadır'ın tüm hizmetinin sorumluluğunu, tüm Çadır hizmeti için tutacaklar. Bir yabancı size yaklaşmayacak.” ");
INSERT INTO turytc_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“İsrael'in çocukları üzerinde artık gazap olmasın diye, konutun görevini ve sunağın görevini siz yerine getireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","İşte, ben kendim İsrael'in çocukları arasından kardeşleriniz Levililer'i aldım. Bunlar, Buluşma Çadırı'nın hizmetini yapmak için Yahve'ye adanmış olarak size verilen bir armağandır. ");
INSERT INTO turytc_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Sen ve seninle birlikte olan oğulların, sunağın her şeyi ve perdenin iç tarafı için kâhinliğinizi tutacaksınız. Hizmet edeceksiniz. Size kâhinlik hizmetini bir armağan olarak veriyorum. Yaklaşan yabancı öldürülecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahve Aron'a şöyle konuştu: “İşte, sallamalık sunularımı, İsrael'in çocuklarına ait bütün kutsal şeyleri ben kendim sana verdim. Bunları mesh nedeniyle sana ve oğullarına sonsuza dek pay olarak verdim. ");
INSERT INTO turytc_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ateşten gelen çok kutsal şeylerden biri bu olacak: Onların bana sunacakları her sunu, onların her ekmek sunusu, onların her günah sunusu ve onların her suç sunusu senin ve oğulların için çok kutsal olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Onları çok kutsal şeyler gibi yiyeceksiniz. Her erkek ondan yiyecek. Senin için kutsal olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Bu da senindir: Onların armağanının sallamalık sunuları, İsrael'in çocuklarının sallamalık sunularının tümü. Bunları sana, seninle birlikte oğullarına ve kızlarına sonsuza dek pay olarak verdim. Evinizde temiz olan herkes ondan yiyecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Yahve'ye verdikleri yağın en iyisini, bağ bozumunun en iyisini, tahılın ve bunların ilk ürünlerini sana verdim. ");
INSERT INTO turytc_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Memleketlerinde olanın tümünden Yahve'ye getirdikleri ilk olgun meyveler senin olacak. Evinizde temiz olan herkes ondan yiyecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“İsrael'de adanan her şey senin olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","İnsan olsun hayvan olsun Yahve'ye sundukları her canlıdan rahmi açan her şey sizin olacak. Bununla birlikte, mutlaka insanın ilk doğanı ile kirli hayvanların ilk doğanlarının bedelini alacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Senin biçtiğin değere göre bedel alınacak olanlardan, bir aylıktan itibaren, yirmi gerah ağırlığındaki kutsal yerin şekeline göre beş şekel para olarak, bedel alacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ancak ineğin ilk doğanı, koyunun ilk doğanı ya da keçinin ilk doğanı için bedel almayacaksın. Onlar kutsaldır. Kanlarını sunağın üzerine serpeceksin, ve yağlarını, Yahve'ye hoş koku olması için ateşle yapılan sunu olarak yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Onların eti senin olacak, sallamalık sunu döş ve sağ but gibi senin olacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","İsrael'in çocuklarının Yahve'ye sunduğu kutsal şeylerden sallamalık sunuların hepsini sonsuza dek pay olarak sana, oğullarına ve kızlarına verdim. Bu, Yahve'nin önünde seninle ve seninle birlikte soyuna daima geçerli bir tuz antlaşmasıdır.” ");
INSERT INTO turytc_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahve Aron'a şöyle dedi: “Onların diyarında senin mirasın olmayacak, aralarında hiçbir payın olmayacak. İsrael'in çocukları arasında senin payın ve mirasın benim.” ");
INSERT INTO turytc_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“İşte, yaptıkları hizmete, Buluşma Çadırı hizmetine karşılık, İsrael'deki tüm ondalığı miras olarak Levi çocuklarına verdim. ");
INSERT INTO turytc_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Bundan böyle İsrael'in çocukları, günah yüklenip ölmesinler diye Buluşma Çadırı'na yaklaşmayacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ancak Buluşma Çadırı'nın hizmetini Levililer yapacak ve onların suçunu onlar yüklenecek. Kuşaklarınız boyunca daima geçerli olacak bir kural olacak. İsrael'in çocukları arasında onların mirası olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Çünkü İsrael'in çocuklarının Yahve'ye sallamalık sunu olarak sundukları ondalığı miras olarak Levililer'e verdim. Bu nedenle onlara, 'İsrael'in çocukları arasında mirasları olmayacak' dedim.” ");
INSERT INTO turytc_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ayrıca Levililer'le konuşup onlara şöyle diyeceksin: 'İsrael'in çocuklarından mirasınız olarak size verdiğim ondalığı aldığınız zaman, ondan Yahve'ye sallamalık sunu olarak ondalığın ondalığını sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Sizin sallamalık sununuz, harman yeri buğdayı ve şarap cenderesinin doluluğu gibi size sayılacak. ");
INSERT INTO turytc_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Böylece siz de İsrael'in çocuklarından aldığınız ondalıklarınızın hepsinden Yahve'ye sallamalık sunu olarak sunacaksınız; ve ondan Yahve'nin sallamalık sunusunu kâhin Aron'a vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Aldığınız bütün armağanlardan, sallamalık sunuların en iyi kısımlarını, en kutsalını Yahve'ye sunacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Bu nedenle onlara şunu diyeceksin: 'En iyi kısmını çıkardığınızda, Levililer'e harman mahsulü gibi ve şarap cenderesinin mahsulü gibi sayılacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Onu siz ve ev halkınız her yerde yiyebilirsiniz. Çünkü Buluşma Çadırı'ndaki hizmetinize karşılık bu sizin ödülünüzdür. ");
INSERT INTO turytc_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ondan en iyisini çıkardığınızda, bundan dolayı hiçbir günah yüklenmeyeceksiniz. Ölmemek için İsrael'in çocuklarının kutsal şeylerine saygısızlık etmeyeceksiniz.'” ");
INSERT INTO turytc_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahve Moşe ve Aron'la konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Yahve'nin buyurduğu yasanın kuralı budur. İsrael'in çocuklarına, sana lekesiz, hiçbir kusuru olmayan ve boyunduruk takılmamış kırmızı bir düve getirmelerini söyle. ");
INSERT INTO turytc_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Onu kâhin Eleazar'a vereceksin; o da onu ordugâhın dışına çıkaracak; biri onu onun önünde kesecek. ");
INSERT INTO turytc_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kâhin Eleazar parmağıyla onun kanından biraz alacak ve kanını yedi kez Buluşma Çadırı'nın önüne doğru serpecek. ");
INSERT INTO turytc_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Birisi düveyi onun gözü önünde yakacak; onun derisini, etini ve kanını gübresiyle birlikte yakacak. ");
INSERT INTO turytc_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kâhin sedir ağacını, mercanköşkotu ve kırmızıyı alıp düvenin yakıldığı ateşin ortasına atacak. ");
INSERT INTO turytc_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Sonra kâhin giysilerini yıkayacak, bedenini suda yıkayacak, sonra ordugâha girecek ve kâhin akşama kadar kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onu yakan kişi giysilerini suda yıkayacak, bedenini de suda yıkayacak ve akşama kadar kirli olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Temiz bir adam düvenin külünü toplayacak ve onları ordugâhın dışında, temiz bir yere koyacak; ve kirliliklerini temizleyen suda kullanılmak üzere İsrael'in çocukları topluluğu için saklanacaktır. Bu bir günah sunusudur. ");
INSERT INTO turytc_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Düvenin külünü toplayan kişi giysilerini yıkayacak ve akşama kadar kirli olacaktır. Bu, İsrael'in çocuklarına ve aralarında garip olarak yaşayan yabancıya sonsuza dek bir kural olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Herhangi bir insan ölüsüne dokunan kişi yedi gün kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Üçüncü gün suyla arınacak, yedinci gün de temiz olacak; ama kendini üçüncü gün arındırmazsa, o zaman yedinci gün temiz olmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ölüye, ölmüş birinin bedenine dokunan ve kendini arındırmayan kişi, Yahve'nin konutunu kirletmiş olur; ve o can İsrael'den atılacaktır; üzerine kirlilik suyu serpilmediği için kirli olacaktır. Kirliliği hâlâ üzerindedir.” ");
INSERT INTO turytc_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Bir adam çadırda öldüğünde yasa şudur: Çadıra giren ve çadırda bulunan herkes yedi gün kirli olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Üzerinde örtüsü bağlı olmayan her açık kap kirlidir.” ");
INSERT INTO turytc_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Kırda kılıçla öldürülmüş birine, bir ölüye, bir insan kemiğine ya da bir mezara dokunan kişi yedi gün kirli olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Kirli kişiler için yakılan günah sunusunun küllerinden alacaklar; ve bir kapta onların üzerine akarsu dökülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Temiz kişi mercanköşkotu alıp suya batıracak ve çadırın üzerine, bütün kapların üzerine, orada bulunanların üzerine, kemiğe, öldürülmüş insana, ölüye ya da mezara dokunanın üzerine serpecek. ");
INSERT INTO turytc_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Temiz kişi üçüncü ve yedinci günde kirli olanın üzerine serpecek. Yedinci gün onu arındıracak. Giysilerini yıkayacak, suda yıkanacak ve akşam temiz olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ama kirli olup kendini arındırmayan kişi, Yahve'nin kutsal yerini kirlettiği için topluluğun arasından atılacaktır. Üzerine kirlilik suyu serpilmemiştir. O kirlidir. ");
INSERT INTO turytc_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Bu onlar için kalıcı bir kural olacaktır. Kirlilik suyu serpen kişi, giysilerini yıkayacak ve kirlilik suyuna dokunan kişi, akşama kadar kirli olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","“Kirli kişinin dokunduğu her şey kirli olacaktır; ve ona dokunan can akşama kadar kirli olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","İsrael'in çocukları, bütün topluluk birinci ayda Zin Çölü'ne geldiler. Halk Kadeş'te oturdu. Miryam orada öldü ve oraya gömüldü. ");
INSERT INTO turytc_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Topluluk için su yoktu; Moşe'ye ve Aron'a karşı bir araya toplandılar. ");
INSERT INTO turytc_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Halk Moşe'yle çekişip şöyle dedi: “Keşke kardeşlerimiz Yahve'nin önünde öldüğü gibi biz de ölseydik! ");
INSERT INTO turytc_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Biz ve hayvanlarımız burada ölelim diye neden Yahve'nin topluluğunu bu çöle getirdiniz? ");
INSERT INTO turytc_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Bizi bu kötü yere getirmek için neden bizi Mısır'dan çıkardınız? Tohumun, incirlerin, asmaların ya da narların yeri değil; içecek su da yok.” ");
INSERT INTO turytc_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moşe ile Aron topluluğun önünden Buluşma Çadırı'nın kapısına gidip yüzüstü yere kapandılar. Yahve'nin görkemi onlara göründü. ");
INSERT INTO turytc_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Değneği al, sen ve kardeşin Aron'la birlikte topluluğu toplayın ve onların gözleri önünde kayaya, suyunu vermesini söyleyin. Onlara kayadan su çıkaracaksın; böylece topluluğa ve hayvanlarına içecek vereceksin.” ");
INSERT INTO turytc_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moşe, kendisine buyurduğu gibi değneği Yahve'nin önünden aldı. ");
INSERT INTO turytc_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moşe ile Aron topluluğu kayanın önünde topladılar ve o onlara şöyle dedi: “Ey siz başkaldıranlar, şimdi dinleyin! Size bu kayadan su çıkaralım mı?” ");
INSERT INTO turytc_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moşe elini kaldırıp değneğiyle kayaya iki kez vurdu ve bol miktarda su çıktı. Topluluk ve hayvanları içti. ");
INSERT INTO turytc_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yahve Moşe'yle Aron'a şöyle dedi: “İsrael'in çocuklarının gözünde beni kutsal kılmak için bana inanmadığınızdan bu topluluğu onlara verdiğim ülkeye götürmeyeceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Bunlar Meriva sularıdır; çünkü İsrael'in çocukları Yahve ile çekiştiler ve O onlarda kutsal kılındı. ");
INSERT INTO turytc_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moşe Kadeş'ten Edom Kralı'na ulaklar göndererek şöyle dedi: “Kardeşin İsrael diyor ki: Başımıza gelen bütün sıkıntıları biliyorsun; ");
INSERT INTO turytc_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","atalarımız Mısır'a indiler, biz de uzun süre Mısır'da yaşadık. Mısırlılar bize ve atalarımıza kötü davrandılar. ");
INSERT INTO turytc_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Yahve'ye feryat ettiğimizde sesimizi duydu, bir melek göndererek bizi Mısır'dan çıkardı. İşte, biz senin sınırının kenarındaki Kadeş kentindeyiz. ");
INSERT INTO turytc_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Lütfen izin ver ülkenden geçelim. Tarladan, bağdan geçmeyeceğiz, kuyu suyundan da içmeyeceğiz. Kralın yolundan gideceğiz. Sınırınızı geçinceye kadar ne sağa ne de sola sapacağız.” ");
INSERT INTO turytc_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom ona, “Benden geçmeyeceksin, yoksa karşına kılıçla çıkarım” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","İsrael'in çocukları ona, “Ana yoldan yukarı çıkacağız” dediler. “Eğer ben ve hayvanlarım senin suyundan içersek, o zaman bedelini vereceğim. Başka hiçbir şey yapmadan yürüyüp geçmeme izin ver.” ");
INSERT INTO turytc_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","“Geçmeyeceksin” dedi. Edom birçok kişiyle ve güçlü bir el ile ona karşı çıktı. ");
INSERT INTO turytc_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Bunun üzerine Edom, İsrael'in kendi sınırından geçmesine izin vermeyi reddetti ve İsrael onun yanından döndü. ");
INSERT INTO turytc_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kadeş'ten göç ettiler ve İsrael'in çocukları, bütün topluluk Hor Dağı'na geldiler. ");
INSERT INTO turytc_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahve, Edom ülkesinin sınırındaki Hor Dağı'nda Moşe ve Aron'a şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aron halkına kavuşacak; çünkü Meriva sularında sözüme karşı isyan ettiğiniz için İsrael'in çocuklarına verdiğim diyara girmeyecek. ");
INSERT INTO turytc_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aron'la oğlu Eleazar'ı al ve onları Hor Dağı'na götür; ");
INSERT INTO turytc_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aron'un giysilerini çıkarıp oğlu Eleazar'a giydir. Aron kavuşturulacak ve orada ölecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moşe Yahve'nin buyurduğu gibi yaptı. Bütün topluluğun gözü önünde Hor Dağı'na çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moşe Aron'un giysilerini çıkarıp oğlu Eleazar'a giydirdi. Aron orada dağın zirvesinde öldü ve Moşe ile Eleazar dağdan indiler. ");
INSERT INTO turytc_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aron'un öldüğünü gören bütün topluluk, bütün İsrael evi Aron için otuz gün ağladı. ");
INSERT INTO turytc_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Güneyde yaşayan Kenanlı, Arad Kralı, İsrael'in Atarim yolundan geldiğini duydu. İsrael'e karşı savaştı ve onlardan bazılarını esir aldı. ");
INSERT INTO turytc_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","İsrael Yahve'ye adak adayıp şöyle dedi: “Eğer bu halkı gerçekten benim elime verirsen, o zaman kentlerini tamamen yok edeceğim.” ");
INSERT INTO turytc_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yahve İsrael'in sesini duydu ve Kenanlılar'ı teslim etti; onları ve kentlerini tamamen yok ettiler. O yere Horma adı verildi. ");
INSERT INTO turytc_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Edom ülkesinin etrafından dolanmak için Hor Dağı'ndan, Kızıldeniz yolundan yol aldılar. Yolculuktan dolayı halkın canı çok sıkkındı. ");
INSERT INTO turytc_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Halk, Tanrı'ya ve Moşe'ye karşı şöyle konuştu: “Çölde ölmemiz için neden bizi Mısır'dan çıkardınız? Çünkü ekmek yok, su yok canımız da bu iğrenç yiyecekten tiksiniyor!” ");
INSERT INTO turytc_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Yahve halkın arasına zehirli yılanlar gönderdi, onlar da insanları ısırdılar. İsraelliler'in çoğu öldü. ");
INSERT INTO turytc_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Halk Moşe'ye gelip şöyle dedi: “Günah işledik, çünkü Yahve'ye ve sana karşı konuştuk. Yılanları bizden uzaklaştırması için Yahve'ye dua et.” Moşe halk için dua etti. ");
INSERT INTO turytc_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahve Moşe'ye şöyle dedi: “Zehirli bir yılan yap ve onu bir direğin üzerine koy. Öyle olacak ki, ısırılan herkes onu görünce yaşayacak.” ");
INSERT INTO turytc_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moşe tunçtan bir yılan yapıp onu direğin üzerine koydu. Eğer bir kişiyi yılan ısırmışsa, o kişi tunç yılana baktığında yaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","İsrael'in çocukları yola koyuldular ve Ovot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ovot'tan ayrılıp gün doğumuna doğru Moav'ın önündeki çölde, İyeavarim'de konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Oradan ayrılıp Zered Vadisi'nde konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Oradan ayrılıp Arnon Nehri'nin karşı yakasında, Amorlular'ın sınırından çıkan çölde konakladılar. Çünkü Arnon, Moav'la Amorlular arasındaki Moav sınırıdır. ");
INSERT INTO turytc_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Bu nedenle Yahve'nin Savaşları Kitabı'nda şöyle deniyor: “Vahev, Arnon vadilerindeki Sufa'da, ");
INSERT INTO turytc_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","vadilerin Ar yerleşkesine doğru uzanan yamacı Moav sınırına kadar dayanır.” ");
INSERT INTO turytc_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Oradan Beer'e gittiler; Yahve'nin Moşe'ye, “Halkı topla, onlara su vereceğim” dediği kuyu budur. ");
INSERT INTO turytc_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Sonra İsrael şu ezgiyi söyledi: “Ey kuyu, fışkır! ");
INSERT INTO turytc_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Beylerin kazdığı, halkın ileri gelenlerinin asayla ve sırıklarla kazdıkları kuyuya ezgi söyleyin.” Çölden Mattana'ya; ");
INSERT INTO turytc_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattana'dan Nahaliel'e; ve Nahaliel'den Bamot'a; ");
INSERT INTO turytc_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamot'tan Moav kırındaki vadiye, çöle bakan Pisga Tepesi'ne gittiler. ");
INSERT INTO turytc_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","İsrael, Amorlular'ın Kralı Sihon'a ulaklar göndererek şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“İzin ver ülkenden geçeyim. Tarlaya, bağa sapmayacağız. Kuyuların suyundan içmeyeceğiz. Sınırından geçinceye kadar kralın yolundan gideceğiz.” ");
INSERT INTO turytc_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon İsrael'in kendi sınırından geçmesine izin vermedi; ve Sihon bütün halkını bir araya topladı ve İsrael'e karşı çöle çıkıp Yahesa'ya geldi. İsrael'e karşı savaştı. ");
INSERT INTO turytc_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","İsrael onu kılıçla vurdu ve Arnon'dan Yabbok'a kadar, Ammon'un çocuklarına kadar, onun diyarına sahip oldu; çünkü Ammon'un çocuklarının sınırı güçlüydü. ");
INSERT INTO turytc_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","İsrael bu kentlerin hepsini aldı. İsrael Amorlular'ın bütün kentlerinde, Heşbon'da ve onun bütün köylerinde yaşıyordu. ");
INSERT INTO turytc_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Çünkü Heşbon, eski Moav Kralı'na karşı savaşan ve Arnon'a kadar bütün ülkesini elinden alan Amorlular'ın Kralı Sihon'un kentiydi. ");
INSERT INTO turytc_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Bu nedenle özdeyişleri söyleyenler, “Heşbon'a gelin” diyorlar. “Sihon kenti kurulsun ve sağlamlaştırılsın; ");
INSERT INTO turytc_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Çünkü Heşbon'dan bir ateş, Sihon kentinden bir alev çıktı. Arnon'un yüksek yerlerinin efendileri Moavlı Ar'ı yiyip bitirdi. ");
INSERT INTO turytc_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Vay başına, ey Moav! İşiniz bitti, Kemoş halkı! Oğullarını kaçak, kızlarını ise Amorlular'ın kralı Sihon'a sürgüne verdi. ");
INSERT INTO turytc_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Onlara ok attık. Heşbon, Divon'a kadar yok oldu. Medeva'ya dek uzanan Nofa'ya kadar yerle bir ettik.” ");
INSERT INTO turytc_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Böylece İsrael Amorlular'ın diyarında yaşadı. ");
INSERT INTO turytc_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moşe Yazer'i araştırmak üzere adamlar gönderdi. Onun köylerini aldılar ve orada bulunan Amorlular'ı kovdular. ");
INSERT INTO turytc_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Dönüp Başan yoluna çıktılar. Başan Kralı Og, kendisi ve tüm halkı Edrei'de savaşmak için onlara karşı çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yahve Moşe'ye şöyle dedi: “Ondan korkma; çünkü onu, bütün halkıyla ve ülkesiyle birlikte senin eline teslim ettim. Heşbon'da yaşayan Amorlular'ın Kralı Sihon'a yaptığın gibi yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Böylece, bir kişi bile sağ kalmayana dek onu, oğullarını ve bütün halkını vurdular; ve onun diyarına sahip oldular. ");
INSERT INTO turytc_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","İsrael'in çocukları yola çıktılar ve Yarden'in ötesindeki Moav ovalarında, Yeriha yanında konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sippor oğlu Balak, İsrael'in Amorlular'a yaptıklarının tümünü gördü. ");
INSERT INTO turytc_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moav bu halktan çok korkuyordu, çünkü çoktular. Moav, İsrael'in çocukları yüzünden sıkıntı çekiyordu. ");
INSERT INTO turytc_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moav Midyan'ın ihtiyarlarına şöyle dedi: “Öküzün kır otunu yaladığı gibi, bu kalabalık da çevremizdeki her şeyi yalayacak.” O sırada Sippor oğlu Balak Moav Kralı'ydı. ");
INSERT INTO turytc_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Beor oğlu Balam'a, onun halkının çocuklarının yaşadığı ülkeye, o Irmak kıyısındaki Petor'a ulaklar göndererek onu çağırmak üzere şöyle dedi: “İşte, Mısır'dan çıkan bir halk var. Bak, yerin yüzünü kaplıyorlar ve karşımda duruyorlar. ");
INSERT INTO turytc_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Lütfen, şimdi gel de benim için bu halka lanet et; çünkü onlar benden çok güçlüdürler. Belki galip gelirim de onları vururuz ve onları ülkeden kovarım; çünkü senin kutsadığın insanın kutsandığını, lanetlediğin insanın de lanetlendiğini biliyorum.” ");
INSERT INTO turytc_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moav ihtiyarlarıyla Midyan ihtiyarları ellerinde falcılık ödülleriyle yola çıktılar. Balam'a gelip Balak'ın sözlerini ona bildirdiler. ");
INSERT INTO turytc_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Onlara, “Bu gece burada kalın, Yahve'nin bana söyleyeceği gibi size de haberi bildireceğim” dedi. Moav beyleri Balam'ın yanında kaldı. ");
INSERT INTO turytc_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Tanrı Balam'a gelip, “Yanındaki bu adamlar kim?” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balam Tanrı'ya şöyle dedi: “Moav Kralı Sippor oğlu Balak bana şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","'İşte, Mısır'dan çıkan halk yerin yüzünü kaplıyor. Şimdi gel de benim için onlara lanet oku. Belki onlara karşı savaşabilir ve onları kovabilirim.'” ");
INSERT INTO turytc_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Tanrı Balam'a, “Onlarla gitmeyeceksin” dedi. “O halkı lanetlemeyeceksin, çünkü onlar kutsanmıştır.” ");
INSERT INTO turytc_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balam sabah kalktı ve Balak'ın beylerine şöyle dedi: “Ülkenize gidin; çünkü Yahve sizinle gelmeme izin vermiyor.” ");
INSERT INTO turytc_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moav beyleri kalkıp Balak'a giderek, “Balam bizimle gelmeyi reddediyor” dediler. ");
INSERT INTO turytc_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak yine onlardan daha çok ve daha saygın beyler gönderdi. ");
INSERT INTO turytc_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Balam'a gelip şöyle dediler: “Sippor oğlu Balak şöyle diyor: 'Lütfen, hiçbir şey bana gelmene engel olmasın. ");
INSERT INTO turytc_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Çünkü seni büyük bir saygınlıkla yükselteceğim ve bana ne dersen onu yapacağım. Lütfen, gel de benim için bu halka lanet et.'” ");
INSERT INTO turytc_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balam, Balak'ın hizmetkârlarına şöyle yanıt verdi: “Eğer Balak bana altın ve gümüş dolu evini verse bile, az olsun çok olsun, Tanrım Yahve'nin sözünün dışına çıkamam. ");
INSERT INTO turytc_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Bu nedenle şimdi lütfen, bu gece de burada kalın ki, Yahve'nin bana başka neler söyleyeceğini bileyim.” ");
INSERT INTO turytc_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Gece Tanrı Balam'a gelip şöyle dedi: “Eğer adamlar seni çağırmaya geldiyse kalk, onlarla birlikte git; ama yalnızca sana söylediğim sözü yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balam sabah kalktı, eşeğine palan vurdu ve Moav beyleriyle birlikte gitti. ");
INSERT INTO turytc_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","O gittiği için Tanrı'nın öfkesi alevlendi; ve Yahve'nin meleği ona karşı bir düşman olarak yolda dikildi. Eşeğine binmişti ve iki hizmetçisi de yanındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Eşek, Yahve'nin meleğinin elinde kılıcını çekmiş yolda durduğunu gördü; ve eşek yoldan sapıp tarlanın içine girdi. Balam onu yola döndürmek için eşeğe vurdu. ");
INSERT INTO turytc_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yahve'nin meleği üzüm bağları arasındaki dar bir yolda durdu; bu tarafta bir duvar, o tarafta bir duvar vardı. ");
INSERT INTO turytc_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Eşek Yahve'nin meleğini görünce kendini duvara attı ve Balam'ın ayağını duvara sıkıştırdı. Ona tekrar vurdu. ");
INSERT INTO turytc_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Yahve'nin meleği daha da ileri gitti, ne sağa ne de sola sapmak için yolun olmadığı dar bir yerde durdu. ");
INSERT INTO turytc_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Eşek Yahve'nin meleğini görünce Balam'ın altında yattı. Balam'ın öfkesi alevlendi ve değneğiyle eşeğe vurdu. ");
INSERT INTO turytc_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Yahve eşeğin ağzını açtı ve Balam'a, “Sana ne yaptım da bana böyle üç kez vurdun?” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam eşeğe, “Madem benimle alay ettin, keşke elimde bir kılıç olsaydı, seni şimdi öldürürdüm” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Eşek Balam'a şöyle dedi: “Bugüne dek bütün ömrün boyunca üzerine bindiğin eşeğin ben değil miyim? Sana böyle yapmışlığım oldu mu hiç?” “Hayır” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Sonra Yahve Balam'ın gözlerini açtı ve Yahve'nin meleğinin elinde kılıcını çekmiş yolda durduğunu gördü; ve başını eğip yüzüstü yere kapandı. ");
INSERT INTO turytc_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Yahve'nin meleği ona şöyle dedi: “Eşeğine neden böyle üç kez vurdun? İşte, sana düşman olarak çıktım, çünkü senin yolun önümde sapkındır. ");
INSERT INTO turytc_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Eşek beni gördü ve üç kez önümden saptı. Eğer önümden sapmamış olsaydı, şimdi seni kesinlikle öldürür, onu da sağ bırakırdım.” ");
INSERT INTO turytc_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balam Yahve'nin meleğine şöyle dedi: “Günah işledim; çünkü bana karşı durduğunu bilmiyordum. Bu nedenle, eğer sen bundan hoşnut değilsen, geri döneceğim.” ");
INSERT INTO turytc_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Yahve'nin meleği Balam'a şöyle dedi: “Adamlarla birlikte git; ama yalnızca sana söyleyeceğim sözü söyleyeceksin.” Balam Balak'ın beyleriyle birlikte gitti. ");
INSERT INTO turytc_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak, Balam'ın geldiğini duyunca, onu karşılamak için Arnon sınırında, sınırın en uzak yerindeki Moav Kenti'ne gitti. ");
INSERT INTO turytc_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak, Balam'a şöyle dedi: “Seni çağırtmak için ciddiyetle çağrıda bulunmadım mı? Neden bana gelmedin? Seni gerçekten saygınlık için yükseltmeye ben yeterli değil miyim?” ");
INSERT INTO turytc_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balam Balak'a şöyle dedi: “İşte, sana geldim. Artık bir şey söylemeye gücüm var mı? Tanrı’nın ağzıma koyduğu sözü söyleyeceğim.” ");
INSERT INTO turytc_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balam Balak'la birlikte gitti ve Kiryat-Husot'a geldiler. ");
INSERT INTO turytc_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sığır ve koyun kurban etti ve Balam'a ve kendisiyle birlikte olan beylere gönderdi. ");
INSERT INTO turytc_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Sabah Balak Balam'ı alıp Baal'ın yüksek yerlerine götürdü; ve oradan halkın bir kısmını gördü. ");
INSERT INTO turytc_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balam, Balak'a, “Burada bana yedi sunak yap, burada benim için yedi boğayla yedi koç hazırla” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak, Balam'ın söylediği gibi yaptı; ve Balak ile Balam her sunakta bir boğa ve bir koç sundular. ");
INSERT INTO turytc_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balam Balak'a, “Yakmalık sunularının yanında dur, ben de gideceğim” dedi. “Belki Yahve benimle buluşmaya gelecektir. Bana ne gösterirse onu sana söyleyeceğim.” Çıplak bir tepeye gitti. ");
INSERT INTO turytc_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Tanrı Balam'la karşılaştı ve Balam O'na şöyle dedi: “Yedi sunak hazırladım ve her sunakta bir boğayla bir koç sundum.” ");
INSERT INTO turytc_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahve Balam'ın ağzına bir söz koydu, “Balak'a dön, böylece konuşacaksın” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Onun yanına döndü ve işte, kendisi ve tüm Moav beyleri yakmalık sunusunun yanında duruyordu. ");
INSERT INTO turytc_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Benzetmesine şu sözle başladı: “Doğu dağlarındaki Moav Kralı Balak beni Aram'dan getirdi. Gel, benim için Yakov'a lanet et. Gel, İsrael'e meydan oku. ");
INSERT INTO turytc_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Tanrı'nın lanetlemediğini ben nasıl lanet edeyim? Yahve'nin meydan okumadığına ben nasıl meydan okuyayım? ");
INSERT INTO turytc_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Çünkü onu kayaların doruğundan görüyorum. Tepelerden ona bakıyorum. İşte, bu tek başına oturan bir halktır ve ulusların arasında sayılmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yakov'un tozunu kim sayabilir, İsrael'in dörtte birini hesap edebilir? Doğruların ölümüyle öleyim! Benim sonum onunki gibi olsun!” ");
INSERT INTO turytc_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak, Balam'a, “Bana ne yaptın?” dedi. “Seni düşmanlarıma lanet etmeye getirdim ve işte, onları, hepsini yalnızca kutsadın.” ");
INSERT INTO turytc_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","O yanıt verip dedi: “Yahve'nin ağzıma koyduğunu söylemeye dikkat etmem gerekmez mi?” ");
INSERT INTO turytc_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak ona, “Lütfen benimle birlikte onları görebileceğin başka bir yere gel” dedi. “Sadece bir kısmını göreceksin, hepsini görmeyeceksin. Benim için onlara oradan lanet et.” ");
INSERT INTO turytc_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Onu Sofim Kırı'na, Pisga Tepesi'ne götürdü, yedi sunak yaptı, her sunakta bir boğa ve bir koç sundu. ");
INSERT INTO turytc_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balak'a, “Ben orada Tanrı'yla buluşurken sen burada, yakmalık sunularının yanında dur” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yahve Balam'la karşılaştı ve onun ağzına bir söz koyup, “Balak'a dön ve şunu söyle” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Onun yanına geldi ve işte, kendisi ve Moav beyleri de yakmalık sunusunun yanında duruyordu. Balak ona, “Yahve ne söyledi?” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Benzetmesini sürdürüp şöyle dedi: “Kalk, ey Balak, ve dinle! Dinle beni, ey Sippor oğlu. ");
INSERT INTO turytc_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tanrı bir insan değil ki, yalan söylesin, insanoğlu değil ki, düşüncesini değiştirsin. O söyler de yapmaz mı? Ya da konuşur da gerçekleştirmez mi? ");
INSERT INTO turytc_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","İşte, kutsamak için buyruk aldım. O kutsadı, ben de geri çeviremem. ");
INSERT INTO turytc_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yakov'da kötülük görmedi. İsrael'de de sapkınlık görmedi. Tanrısı Yahve onunladır. Bir kralın haykırışı onların arasındadır. ");
INSERT INTO turytc_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tanrı onları Mısır'dan çıkarıyor. Yaban öküzü gibi gücü var. ");
INSERT INTO turytc_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kesinlikle Yakov'a büyü tutmaz; İsrael'e fal işlemez. Şimdi Yakov ve İsrael için, 'Tanrı neler yaptı?' denilecektir. ");
INSERT INTO turytc_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","İşte, bir halk dişi aslan gibi kalkıyor. Bir aslan gibi kendini yukarı kaldırıyor. Avının etini yemeden ve öldürülenlerin kanını içmeden yatmayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak, Balam'a, “Onlara ne hiç lanet et, ne de onları hiç kutsa” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ama Balam Balak'a şu karşılığı verdi: “Ben sana, 'Yahve ne söylerse hepsini yapmalıyım' demedim mi?” ");
INSERT INTO turytc_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak, Balam'a, “Şimdi gel, seni başka bir yere götüreyim” dedi. “Belki oradan benim için onlara lanet etmenden Tanrı hoşnut olur.'' ");
INSERT INTO turytc_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak, Balam'ı çöle bakan Peor Tepesi'ne götürdü. ");
INSERT INTO turytc_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balam Balak'a, “Burada bana yedi sunak yap, burada benim için yedi boğayla yedi koç hazırla” dedi. ");
INSERT INTO turytc_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak, Balam'ın söylediklerini yaptı ve her sunakta bir boğayla bir koç sundu. ");
INSERT INTO turytc_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balam, Yahve'nin İsrael'i kutsamaktan hoşnut olduğunu görünce, diğer seferler olduğu gibi kehanete başvurmak yerine yüzünü çöle çevirdi. ");
INSERT INTO turytc_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balam gözlerini kaldırdı ve İsrael'in oymaklarına göre oturduğunu gördü; ve onun üzerine Tanrı'nın Ruhu geldi. ");
INSERT INTO turytc_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Benzetmesini şöyle sürdürdü ve dedi: “Beor oğlu Balam diyor ki, gözleri açık olan adam diyor ki; ");
INSERT INTO turytc_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Tanrı'nın sözlerini duyan, Her Şeye Gücü Yeten'in görümünü gören, yere kapanıp gözleri açılmış olan şöyle diyor: ");
INSERT INTO turytc_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Çadırların ne kadar güzel, ey Yakov, konutların da, ey İsrael! ");
INSERT INTO turytc_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Vadiler gibi, ırmak kıyısındaki bahçeler gibi, Yahve'nin diktiği öd ağaçları gibi, su kıyısındaki sedir ağaçları gibi yayıldılar. ");
INSERT INTO turytc_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Onun kovalarından su akacaktır. Onun tohumu birçok sularda olacaktır. Onun Kralı Agag'dan daha üstün olacaktır. Onun krallığı yüceltilecektir. ");
INSERT INTO turytc_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Tanrı onu Mısır'dan çıkarıyor. Onun yaban öküzü gibi gücü var. Düşmanları olan ulusları tüketecek, kemiklerini kıracak ve oklarıyla onları delecektir. ");
INSERT INTO turytc_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Çömeldi, aslan gibi yattı, dişi aslan gibi; onu kim kaldıracak? Seni kutsayan herkes kutsansın. Seni lanetleyen herkes lanetlensin.” ");
INSERT INTO turytc_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak'ın öfkesi Balam'a karşı alevlendi ve ellerini birbirine vurdu. Balak, Balam'a şöyle dedi: “Seni düşmanlarıma lanet etmeye çağırdım ve işte, onları bu üç keredir yalnızca kutsadın. ");
INSERT INTO turytc_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Bu nedenle şimdi yerine koş! Seni büyük bir saygınlıkla yükseltmeyi düşünmüştüm; ama işte, Yahve seni saygınlıktan yoksun bıraktı.” ");
INSERT INTO turytc_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balam Balak'a şöyle dedi: “Bana gönderdiğin ulaklarına: ");
INSERT INTO turytc_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'Eğer Balak bana altın ve gümüş dolu evini verse bile, kendi fikrimle iyilik ya da kötülük etmek için Yahve'nin sözünün dışına çıkamam. Yahve'nin söylediğini söyleyeceğim' diye dememiş miydim? ");
INSERT INTO turytc_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","İşte şimdi halkımın yanına gidiyorum. Gel, bu halkın son günlerde senin halkına ne yapacaklarını sana bildireyim.” ");
INSERT INTO turytc_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Benzetmesini şöyle sürdürdü ve dedi: “Beor oğlu Balam diyor ki, gözleri açık olan adam şöyle diyor; ");
INSERT INTO turytc_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Tanrı'nın sözlerini duyan, Yüceler Yücesi'nin bilgisini bilen ve yere kapanıp gözleri açık olarak Her Şeye Gücü Yeten'in görümünü gören şöyle diyor: ");
INSERT INTO turytc_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Onu görüyorum, ama şimdi değil. Ona bakıyorum ama yakın değil. Yakov'dan bir yıldız çıkacak. İsrael'den bir asa yükselecek, Moav'ı dört bir yanından vuracak ve Şet'in bütün oğullarını ezecek. ");
INSERT INTO turytc_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom mülk olacak. İsrael yiğitçe bunu yaparken, düşmanı Seir de mülk olacak. ");
INSERT INTO turytc_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yakov'dan biri hüküm sürecek, ve kentte artakalanları yok edecek.” ");
INSERT INTO turytc_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Amalek'e baktı, benzetmesini sürdürüp şöyle dedi: “Amalek ulusların birincisiydi, ama onun sonu yıkım olacak.” ");
INSERT INTO turytc_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kenli'ye baktı ve benzetmesini sürdürüp şöyle dedi: “Mesken yerin güçlüdür. Senin yuvan kaya içine koyulmuştur. ");
INSERT INTO turytc_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Yine de Aşur seni tutsak alana dek Keni harap olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Benzetmesini sürdürdü ve şöyle dedi: “Ne yazık ki, Tanrı bunu yaptığı zaman kim yaşayacak? ");
INSERT INTO turytc_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ama Kittim kıyısından gemiler gelecek. Aşur'u ve Ever'i sarsacaklar. O da yıkıma uğrayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balam kalkıp gitti ve yerine döndü; Balak da kendi yoluna gitti. ");
INSERT INTO turytc_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","İsrael Şittim'de kaldı; ve halk Moav kızlarıyla zina yapmaya başladı; ");
INSERT INTO turytc_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","çünkü halkı kendi ilâhlarına kurban sunmaya çağırıyorlardı. Halk yedi ve onların ilâhlarına eğildiler. ");
INSERT INTO turytc_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","İsrael Baal Peor'a bağlandı ve Yahve'nin öfkesi İsrael'e karşı alevlendi. ");
INSERT INTO turytc_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yahve Moşe'ye şöyle dedi: “Halkın bütün ileri gelenlerini al ve onları güneşe karşı Yahve'nin önünde as ki, Yahve'nin kızgın öfkesi İsrael'den dönsün.” ");
INSERT INTO turytc_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moşe İsrael hâkimlerine şöyle dedi: “Herkes Baal Peor'a bağlanan adamlarını öldürsün.” ");
INSERT INTO turytc_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","İşte, İsrael'in çocuklarından biri geldi, Moşe'nin gözü önünde, Buluşma Çadırı kapısında ağlamakta olan bütün İsrael'in çocuklarının bütün topluluğu gözü önünde kardeşlerine Midyanlı bir kadın getirdi. ");
INSERT INTO turytc_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kâhin Aron'un oğlu Eleazar'ın oğlu Pinehas bunu görünce topluluğun ortasından kalktı ve eline bir mızrak aldı. ");
INSERT INTO turytc_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","İsraelli adamın peşinden çadıra girdi ve ikisini de, İsraelli adamın da, kadının da bedeninden mızrağı sapladı. Böylece İsrael'in çocukları arasındaki veba durduruldu. ");
INSERT INTO turytc_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Vebadan ölenler yirmi dört bindi. ");
INSERT INTO turytc_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Kâhin Aron'un oğlu, Eleazar'ın oğlu Finehas, aralarındaki kıskançlığımla kıskandığı için İsrael'in çocuklarından gazabımı döndürdü, bundan ötürü İsrael'in çocuklarını kıskançlığımla tüketmedim. ");
INSERT INTO turytc_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Bu nedenle söyle, 'İşte, ona esenlik antlaşmamı veriyorum. ");
INSERT INTO turytc_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Kendisi ve kendisinden sonra soyu için sonsuz bir kâhinlik antlaşması olacaktır; çünkü o, Tanrı için kıskandı ve İsrael'in çocukları için kefaret etti.'” ");
INSERT INTO turytc_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","İsraelli adamın adı, Midyanlı kadınla birlikte öldürülen kişi, Şimon'un oğulları ata evinin beyi Salu oğlu Zimri'ydi. ");
INSERT INTO turytc_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Öldürülen Midyanlı kadının adı Sur'un kızı Kozbi'ydi. Midyan'daki bir ata evi halkının beyiydi. ");
INSERT INTO turytc_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midyanlılar'ı sıkıştır ve onları vur; ");
INSERT INTO turytc_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","çünkü Peor meselesinde hileleriyle sizi sıkıştırdılar; Peor meselesinde ve veba gününde öldürülen kız kardeşleri Midyan beyinin kızı Kozbi ile ilgili olayda sizi aldattılar.” ");
INSERT INTO turytc_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Vebadan sonra Yahve Moşe'ye ve kâhin Aron oğlu Eleazar'a şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Atalarının evlerine göre yirmi yaş ve üzeri İsrael'in çocuklarından tüm topluluğu, İsrael'de savaşa çıkabileceklerin tümünü sayın.” ");
INSERT INTO turytc_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moşe ile Kâhin Eleazar, Yarden yanında, Yeriha'daki Moav ovalarında onlarla konuşup şöyle dediler: ");
INSERT INTO turytc_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Yahve'nin Moşe'ye ve İsrael'in çocuklarına buyurduğu gibi, yirmi yaş ve yukarısını sayın.” Bunlar Mısır diyarından çıkanlardır. ");
INSERT INTO turytc_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","İsrael'in ilk oğlu Ruven; Ruven'in oğulları: Hanok'tan Hanokiler soyu; Pallu'dan Palluliler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hetsron'dan Hetsroniler soyu; Karmi'den Karmiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ruvenliler'in soyları bunlardır; ve onlardan sayılanlar kırk üç bin yedi yüz otuz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu'nun oğlu: Eliav. ");
INSERT INTO turytc_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliav'ın oğulları: Nemuel, Datan ve Aviram. Bunlar, Yahve'ye başkaldırdıklarında Korah'ın yanında Moşe'ye ve Aron'a başkaldıran, topluluk tarafından çağrılan Datan ve Aviram'dır; ");
INSERT INTO turytc_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ve o topluluk öldüğünde, yer ağzını açıp Korah'la birlikte onları da yutmuştu; o sırada ateş iki yüz elli kişiyi yakıp tüketti ve onlar bir belirti haline geldiler. ");
INSERT INTO turytc_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ne var ki, Korah'ın oğulları ölmedi. ");
INSERT INTO turytc_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Şimon'un oğulları soylarına göre: Nemuel'den Nemuelliler soyu; Yamin'den Yaminiler soyu; Yakin'den Yakiniler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah'tan Zerahiler soyu; Şaul'dan Şauliler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Şimoniler'in soyları bunlardır; yirmi iki bin iki yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Soylarına göre Gad'ın oğulları: Sefon'dan Sefoniler soyu; Haggi'den Haggililer soyu; Şuni'den Şunililer soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni'den Ozniniler soyu; Eri'den Erililer soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod'tan Arodiler soyu; Areli'den Areliler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gadoğulları'ndan sayılanlara göre soyları bunlardır, kırk bin beş yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yahuda'nın oğulları: Er ve Onan. Er ve Onan Kenan diyarında öldüler. ");
INSERT INTO turytc_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Soylarına göre Yahuda'nın oğulları: Şela'dan Şelaniler soyları; Peres'ten Peresiler soyu; Zerah'tan Zerahiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peres'in oğulları: Hetsron'dan Hetsroniler soyu; Hamul'dan Hamuliler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Onlardan sayılanlara göre Yahuda soyları bunlardır; yetmiş altı bin beş yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Soylarına göre İssakar'ın oğulları: Tola'dan Tolaliler soyu; Puva'dan Puniler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaşuv'dan Yaşuviler soyu; Şimron'dan Şimroniler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Onlardan sayılanlara göre İssakar'ın soyları bunlardır; altmış dört bin üç yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Soylarına göre Zevulun'un oğulları: Sered'ten Serediler soyu; Elon'dan Eloniler soyu; Yahleel'den Yahleeliler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sayılanlara göre Zevuluniler soyları bunlardır, altmış bin beş yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Soylarına göre Yosef'in oğulları: Manaşşe ve Efraim. ");
INSERT INTO turytc_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manaşşe'nin oğulları: Makir'den Makiriler soyu; ve Makir Gilad'ın babası oldu; Gilad'tan Giladlılar soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilad'ın oğulları şunlardır: İezer'den İezerliler soyu; Helek'ten Helekiler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ve Asriel'den Asrieliler soyu; ve Şekem'den Şekemiler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ve Şemida'dan Şemidailer soyu; ve Hefer'den Heferiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefer oğlu Zelofehad'ın oğlu yoktu, yalnızca kızları vardı; ve Selofhad'ın kızlarının adları Mahla, Nuh, Hogla, Milka ve Tirsa idi. ");
INSERT INTO turytc_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manaşşe'nin soyları bunlardır. Onlardan sayılanlar elli iki bin yedi yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Soylarına göre Efraim'in oğulları şunlardır: Şutelah'tan Şutelahiler soyu; Beker'den Bekeriler soyu; Tahan'dan Tahaniler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Şutelah'ın oğulları şunlardır: Eran'dan Eraniler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efraimoğulları'ndan sayılanlara göre soyları bunlardır, otuz iki bin beş yüz. Bunlar soylarına göre Yosef'in oğullarıdır. ");
INSERT INTO turytc_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Soylarına göre Benyamin'in oğulları: Bela'dan Belailer soyu; Aşbel'den Aşbeliler soyu; Ahiram'dan Ahiramiler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Şufam'dan Şufamiler soyu; Hufam'dan Hufamiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela'nın oğulları Ard ve Naaman'dı; Ardiler soyu; ve Naaman'dan Naamiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Soylarına göre Benyamin'in oğulları şunlardır; ve onlardan sayılanlar kırk beş bin altı yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Soylarına göre Dan'ın oğulları şunlardır: Şuham'dan Şuhamiler soyu. Bunlar soylarına göre Dan'ın soylarıdır. ");
INSERT INTO turytc_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Kendilerinden sayılanlara göre Şuhamiler'in bütün soyları altmış dört bin dört yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Soylarına göre Aşer'in oğulları: Yimna'dan Yimniler soyu; Yişvi'den Yişviler soyu; Beria'dan Berililer soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beria'nın oğullarından: Heber'den Heberiler soyu; Malkiel'den Malkieliler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aşer'in kızının adı Serah'tı. ");
INSERT INTO turytc_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Sayılanlara göre Aşeroğulları'nın soyları bunlardır; elli üç bin dört yüz. ");
INSERT INTO turytc_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Soylarına göre Naftali'nin oğulları: Yahseel'den Yahseeliler soyu; Guni'den Guniler soyu; ");
INSERT INTO turytc_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeser'den Yeseriler soyu; Şillem'den Şillemiler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Soylarına göre Naftali soyları şunlardır; ve onlardan sayılanlar kırk beş bin dört yüz kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","İsrael'in çocuklarından sayılanlar bunlardır; altı yüz bin yedi yüz otuz. ");
INSERT INTO turytc_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ülke adlarının sayısına göre miras olarak bunlara bölünecektir. ");
INSERT INTO turytc_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Daha çok olana daha çok miras verecekseniz, daha az olana daha az miras vereceksiniz. Kendisinden sayılanlara göre herkese mirası verilecektir. ");
INSERT INTO turytc_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Bununla birlikte ülke kurayla bölünecek. Ata oymaklarının adlarına göre miras alacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Mirasları çok olanla az olan arasında kuraya göre bölünecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levililer'den soylarına göre sayılanlar şunlardı: Gerşon'dan Gerşoniler soyu; Kohat'tan Kohatiler soyu; Merari'den Merariler soyu. ");
INSERT INTO turytc_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi soyları şunlardır: Livnî soyu, Hevronî soyu, Mahliler soyu, Muşîler soyu ve Korahîler soyu. Kohat Amram'ın babası oldu. ");
INSERT INTO turytc_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram'ın karısının adı Levi'nin Mısır'da doğan kızı Yokevet'ti. Amram'a Aron'u, Moşe'yi ve kız kardeşleri Miryam'ı doğurdu. ");
INSERT INTO turytc_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aron'a Nadav, Avihu, Eleazar ve İtamar doğdu. ");
INSERT INTO turytc_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadav ile Avihu, Yahve'nin önünde yabancı ateş sundukları zaman öldüler. ");
INSERT INTO turytc_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Onlardan sayılanlar, bir aylık ve daha yukarı hepsi erkek olmak üzere, yirmi üç bin kişiydi; çünkü İsrael'in çocukları arasında sayılmadılar, çünkü İsrael'in çocukları arasında onlara miras verilmedi. ");
INSERT INTO turytc_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Bunlar, Yarden yanında, Yeriha'daki Moav ovalarında İsrael'in çocuklarını sayan Moşe ve Kâhin Eleazar'ın saydıkları kişilerdir. ");
INSERT INTO turytc_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ancak bunların arasında, Sina Çölü'nde İsrael'in çocuklarını saymış olan Moşe ve Kâhin Aron'un saydıklarından kimse yoktu. ");
INSERT INTO turytc_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Çünkü Yahve onlar hakkında, “Kesinlikle çölde ölecekler” demişti. Onlardan Yefunne oğlu Kalev ile Nun oğlu Yeşu dışında kimse kalmamıştı. ");
INSERT INTO turytc_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Bunun üzerine Yosef'in oğlu Manaşşe soylarından Manaşşe oğlu Makir oğlu Gilad oğlu Hefer oğlu Selofhad'ın kızları yaklaştı. Kızlarının adları şunlardır: Mahla, Nuh, Hogla, Milka ve Tirsa. ");
INSERT INTO turytc_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Moşe'nin, Kâhin Eleazar'ın, beylerin ve bütün topluluğun önünde Buluşma Çadırı'nın kapısında durup şöyle dediler: ");
INSERT INTO turytc_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Babamız çölde öldü. O, Korah'ın yanında Yahve'ye karşı toplananların arasında değildi, ama kendi günahı içinde öldü. Oğulları yoktu. ");
INSERT INTO turytc_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Oğlu olmadığı için babamızın adı neden soyu arasından kaldırılsın? Bize babamızın kardeşleri arasında bir mülk verin.” ");
INSERT INTO turytc_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moşe onların davasını Yahve'nin önüne götürdü. ");
INSERT INTO turytc_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Selofhad'ın kızları doğru söylüyor. Babalarının kardeşleri arasında onlara mutlaka miras vereceksin. Babalarının mirasını onlara geçireceksin. ");
INSERT INTO turytc_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","İsrael'in çocuklarına söyleyip diyeceksin, 'Eğer bir adam oğlu olmadan ölürse, onun mirası onun kızına geçecektir. ");
INSERT INTO turytc_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kızı yoksa mirasını kardeşlerine vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kardeşi yoksa mirasını babasının kardeşlerine vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Babasının erkek kardeşi yoksa, mirasını soyundan kendisine en yakın olan akrabasına vereceksiniz ve o da onun mülkü olacak. Bu, Yahve'nin Moşe'ye buyurduğu gibi İsrael'in çocukları için bir kural ve ilke olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahve Moşe'ye şöyle dedi: “Bu Havarim Dağı'na çık ve İsrael'in çocuklarına verdiğim ülkeyi gör. ");
INSERT INTO turytc_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Onu gördükten sonra, kardeşin Aron gibi sen de halkına kavuşacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Çünkü topluluğun çekişmesi sırasında, Zin Çölü'nde, onların gözleri önünde beni sularda kutsal sayma sözüme karşı başkaldırdın.'' (Bunlar Zin Çölü'ndeki Kadeş'te Meriva sularıdır.) ");
INSERT INTO turytc_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moşe Yahve'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Bütün insanların ruhlarının Tanrısı Yahve, topluluğun başına bir adam atasın; ");
INSERT INTO turytc_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","o da onların önünden çıksın, onların önünden girsin, onları dışarı çıkarsın, onları içeri de getirsin ki, Yahve'nin topluluğu çobansız koyunlar gibi olmasın.” ");
INSERT INTO turytc_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yahve Moşe'ye şöyle dedi: “Kendisinde Ruh bulunan Nun oğlu Yeşu'yu al ve elini onun üzerine koy. ");
INSERT INTO turytc_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Onu kâhin Eleazar'ın ve tüm topluluğun önüne çıkar; ve onu onların gözü önünde görevlendir. ");
INSERT INTO turytc_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ona yetki vereceksin ki, İsrael'in çocuklarının bütün topluluğu itaat etsinler. ");
INSERT INTO turytc_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Urim'in kararına göre Yahve'nin önünde onun için soracak olan Kâhin Eleazar'ın önünde duracak. Hem kendisi, hem de onunla birlikte bütün İsrael'in çocukları, bütün topluluk, onun sözü üzerine çıkacaklar ve onun sözü üzerine içeri girecekler.” ");
INSERT INTO turytc_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moşe Yahve'nin kendisine buyurduğu gibi yaptı. Yeşu'yu alıp kâhin Eleazar'ın ve bütün topluluğun önünde durdurdu. ");
INSERT INTO turytc_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Yahve'nin Moşe aracılığıyla söylediği gibi ellerini onun üzerine koydu ve onu görevlendirdi. ");
INSERT INTO turytc_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“İsrael'in çocuklarına buyur ve onlara de: 'Ateşle yapılan sunular yiyeceğimi, hoş koku olarak, zamanı geldiğinde bana sunmaya dikkat edin.' ");
INSERT INTO turytc_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Onlara şöyle diyeceksin: 'Yahve'ye sunacağınız ateşle yapılan sunu şudur: Sürekli yakmalık sunu olarak her gün iki baş olmak üzere bir yaşında kusursuz erkek kuzular. ");
INSERT INTO turytc_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Kuzulardan birini sabah, diğerini akşam sunacaksın, ");
INSERT INTO turytc_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ekmek sunusu olarak hinin dörtte biri kadar dövülmüş yağla yoğrulmuş onda bir efa ince un sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Bu, hoş koku olarak Sina Dağı'nda atanmış sürekli yakmalık sunudur, Yahve'ye ateşle yapılan bir sunudur. ");
INSERT INTO turytc_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Onun dökmelik sunusu her kuzu için bir hinin dörtte biri kadar olacaktır. Kutsal Yerde Yahve'ye dökmelik sunu olarak ağır içkiden dökeceksin. ");
INSERT INTO turytc_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Diğer kuzuyu akşam üstü sunacaksın. Sabahın ekmek sunusu gibi, onun dökmelik sunusu gibi, onu Yahve'ye hoş koku olarak, ateşle yapılan sunu olarak sunacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“'Şabat Günü, bir yaşında kusursuz iki erkek kuzu, ekmek sunusu olarak yağla yoğrulmuş onda iki efa ince un ve onun dökmelik sunusunu sunacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Sürekli yakmalık sunuya ve onun dökmelik sunusuna ek olarak, her Şabat'ın yakmalık sunusu budur.”' ");
INSERT INTO turytc_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“'Aylarınızın başında Yahve'ye yakmalık sunu sunacaksınız: İki genç boğa, bir koç, bir yaşında kusursuz yedi erkek kuzu, ");
INSERT INTO turytc_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ve her boğa için, ekmek sunusu olarak yağla yoğrulmuş efanın onda üçü ince un; ve bir koç için, ekmek sunusu olarak yağla yoğrulmuş efanın onda ikisi ince un; ");
INSERT INTO turytc_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ve her kuzu için ekmek sunusu olarak yağla yoğrulmuş efanın onda biri ince un, yakmalık sunu, hoş koku olarak Yahve'ye ateşle yapılan sunu sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Onların dökmelik sunuları olarak boğa için yarım hin şarap, koç için hinin üçte biri ve kuzu için hinin dörtte biri kadar şarap olacak. Bu, yılın ayları boyunca her ayın yakmalık sunusudur. ");
INSERT INTO turytc_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Sürekli yakmalık sunu ve dökmelik sunuya ek olarak Yahve'ye günah sunusu olarak bir teke de sunulacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“'Birinci ayın on dördüncü günü Yahve'nin Pesah'ıdır. ");
INSERT INTO turytc_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Bu ayın on beşinci günü bayram olacaktır. Yedi gün mayasız ekmek yenilecektir. ");
INSERT INTO turytc_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","İlk gün kutsal toplantı yapılacak. Olağan hiçbir iş yapmayacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","yalnızca Yahve'ye ateşte yapılan sunu olarak yakmalık sunu sunacaksınız: İki genç boğa, bir koç ve bir yaşında yedi erkek kuzu. Onlar kusursuz olacaklar, ");
INSERT INTO turytc_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","onların ekmek sunusuyla birlikte, yağla yoğrulmuş ince un. Boğa için onda üç, koç için onda iki sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Yedi kuzunun her kuzusu için onda birini; ");
INSERT INTO turytc_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ve günah sunusu olarak sizin için kefaret etmek üzere bir teke sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Sürekli yakmalık sunu olarak sunulan sabah yakmalık sunularına ek olarak bunları da sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Böylece, Yahve'ye hoş koku olarak, ateşle yapılan sununun yiyeceğini her gün, yedi gün boyunca sunacaksınız. Sürekli yakmalık sunu ve dökmelik sunuya ek olarak sunulacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Yedinci gün kutsal toplantı olacaktır. Olağan hiçbir iş yapmayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“'İlk ürünler günü, Haftalar Bayramı'nda Yahve'ye yeni ekmek sunusu sunduğunuz zaman, sizin için kutsal bir toplantı da olacaktır. Olağan hiçbir iş yapmayacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ama Yahve'ye hoş koku, yakmalık sunu olarak: İki genç boğa, bir koç, bir yaşında yedi erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ve onların ekmek sunusu, yağla yoğrulmuş ince un, her boğa için onda üç, bir koç için onda iki, ");
INSERT INTO turytc_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","yedi kuzunun her kuzusu için onda bir; ");
INSERT INTO turytc_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ve sizin için kefaret etmek üzere bir de teke sunacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Sürekli yakmalık sunu ve ekmek sunusu dışında, bunları ve onların dökmelik sunuları da sunacaksınız. Onların kusursuz olmasına dikkat edin.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“'Yedinci ayın birinci günü kutsal toplantınız olacak; olağan hiçbir iş yapmayacaksın. Bu size boru çalma günüdür. ");
INSERT INTO turytc_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Yahve'ye hoş koku, yakmalık sunu olarak: Bir genç boğa, bir koç, bir yaşında kusursuz yedi erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ve bunların ekmek sunuları olarak, yağla yoğrulmuş ince un; boğa için onda üç, koç için onda iki, ");
INSERT INTO turytc_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ve yedi kuzunun her kuzusu için onda bir; ");
INSERT INTO turytc_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ve günah sunusu olarak sizin için kefaret etmek üzere bir teke sunacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","bu, yakmalık sunuyla birlikte yeni ay sunusuna, onun ekmek sunusuyla sürekli yakmalık sunuya ve usulüne göre hoş koku için dökmelik sunulara ek olarak, Yahve'ye ateşle yapılan bir sunudur.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“'Bu yedinci ayın onuncu günü kutsal toplantınız olacak. Canlarınıza acı çektireceksiniz. Hiçbir iş yapmayacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","yalnızca hoş koku olarak Yahve'ye yakmalık sunu olarak: Bir genç boğa, bir koç, bir yaşında yedi erkek kuzu; hepsi kusursuz olacaklar; ");
INSERT INTO turytc_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ve bunların ekmek sunusu olarak, yağla yoğrulmuş ince un; boğa için onda üç, bir koç için onda iki, ");
INSERT INTO turytc_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","yedi kuzunun her kuzusu için onda bir; ");
INSERT INTO turytc_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","günah sunusu olarak bir teke sunacaksınız; bu, kefaret günah sunusuna, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunularına ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“'Yedinci ayın on beşinci günü kutsal toplantınız olacaktır. Olağan hiçbir iş yapmayacaksınız. Yedi gün Yahve'ye bayram tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Yakmalık sunu, ateşle yapılan sunu, hoş kokulu olarak, on üç genç boğa, iki koç, bir yaşında on dört erkek kuzu; hepsi kusursuz olacaklar; ");
INSERT INTO turytc_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ve bunların ekmek sunusu olarak, yağla yoğrulmuş ince un; on üç boğadan her boğa için onda üç, iki koçtan her koç için onda iki, ");
INSERT INTO turytc_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ve on dört kuzunun her kuzusu için onda biri; ");
INSERT INTO turytc_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“'İkinci gün on iki genç boğa, iki koç ve bir yaşında kusursuz on dört erkek kuzu sunacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“'Üçüncü gün on bir boğa, iki koç, bir yaşında kusursuz on dört erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“'Dördüncü günde on boğa, iki koç, bir yaşında kusursuz on dört erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“'Beşinci gün dokuz boğa, iki koç, bir yaşında kusursuz on dört erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“'Altıncı gün sekiz boğa, iki koç, bir yaşında kusursuz on dört erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“'Yedinci gün: Yedi boğa, iki koç, bir yaşında kusursuz on dört erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ve bunların sayısına göre, usulüne göre, boğalar, koçlar ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“'Sekizinci gün kutsal toplanmanız olacaktır. Olağan hiçbir iş yapmayacaksınız; ");
INSERT INTO turytc_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","yalnız yakmalık sunu, ateşte yapılan sunu, hoş koku olarak Yahve'ye, bir boğa, bir koç, bir yaşında kusursuz yedi erkek kuzu; ");
INSERT INTO turytc_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","bunların sayısına göre, usulüne göre, boğa için, koç için ve kuzular için onların ekmek sunusunu ve onların dökmelik sunularını; ");
INSERT INTO turytc_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","günah sunusu olarak bir teke sunacaksınız; bu, sürekli yakmalık sunuya, onun ekmek sunusuna ve onun dökmelik sunusuna ektir. ");
INSERT INTO turytc_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“'Yakmalık sunularınız, ekmek sunularınız, dökmelik sunularınız ve esenlik sunularınız olarak, adaklarınızın ve gönüllü sunularınızın yanısıra, bunları da belirlenen bayramlarınızda Yahve'ye sunacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moşe Yahve'nin kendisine buyurduğu her şeye göre İsrael'in çocuklarına söyledi. ");
INSERT INTO turytc_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moşe İsrael'in çocuklarının oymak başlarıyla konuşup şöyle dedi: “Yahve'nin buyurduğu şey şudur. ");
INSERT INTO turytc_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Bir adam Yahve'ye adak adadığında, ya da canını bir bağla bağlayacağına dair ant içtiğinde, sözünden dönmeyecektir. Ağzından çıkan her şeye göre yapacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Bir kadın da gençliğinde babasının evindeyken Yahve'ye adak adadığında ve kendisini bir sözle bağladığında, ");
INSERT INTO turytc_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ve babası onun canını bağladığı adağı ve sözü duyar; ona hiçbir şey söylemezse, bütün adakları geçerli olacak ve canını bağladığı her söz yerinde duracaktır. ");
INSERT INTO turytc_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ama eğer babası duyduğu gün onu yasaklarsa, onun canını bağladığı adakların ya da verdiği sözlerin hiçbiri geçerli olmayacaktır. Babası onu yasakladığı için Yahve onu bağışlayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Eğer adakları, ya da canının bağladığı dudaklarının aceleci sözleri üzerindeyken kocaya varırsa, ");
INSERT INTO turytc_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ve kocası bunu duyarsa ve duyduğu gün ona hiçbir şey söylemezse; o zaman onun adakları geçerli olacak ve canını bağladığı sözleri yerinde duracaktır. ");
INSERT INTO turytc_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ama kocası bunu duyduğu gün onu yasaklarsa, o zaman onun üzerine olan adağını ve canını bağladığı dudaklarının aceleci sözlerini geçersiz kılmış olur. Yahve onu bağışlayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ancak dul kadının ya da boşanmış kadının adağı, canını bağladığı her şey ona karşı olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Eğer kadın kocasının evinde adak adadıysa, ya da canını bir antla bağladıysa, ");
INSERT INTO turytc_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ve kocası bunu duyduysa, ona karşı sessiz kaldıysa ve ona engel olmadıysa, o zaman onun bütün adakları geçerli olacak ve canını bağladığı her söz yerinde duracaktır. ");
INSERT INTO turytc_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ama eğer kocası duyduğu gün bunları geçersiz kıldıysa, o zaman onun adaklarıyla ya da canının bağıyla ilgili olarak ağzından çıkan hiçbir şey geçerli olmayacaktır. Kocası bunları geçersiz kılmıştır. Yahve onu bağışlayacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Canı yaralayan her adak ve bağlayan andı kocası yerine getirebilir, ya da kocası onu geçersiz kılabilir. ");
INSERT INTO turytc_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ama eğer kocası günden güne geçerken ona bir şey söylemezse, o zaman kocası onun üzerine olan bütün adaklarını ya da verdiği bütün sözlerini sağlamlaştırmıştır. Bunları duyduğu gün ona hiçbir şey söylemediği için pekiştirmiştir. ");
INSERT INTO turytc_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ama eğer onları duyduktan sonra geçersiz kılarsa, o zaman kadının suçunu yüklenecektir.” ");
INSERT INTO turytc_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Bunlar, erkekle karısı arasında, bir baba ile kızı arasında, gençliğinde kızın babasının evinde olduğunda, Yahve'nin Moşe'ye buyurduğu kurallardır. ");
INSERT INTO turytc_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“İsrael'in çocuklarının Midyanlılar'dan öcünü al. Ondan sonra halkına kavuşacaksın.” ");
INSERT INTO turytc_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moşe halka seslenip şöyle dedi: “Midyan'dan Yahve'nin öcünü almak için Midyan'a karşı savaşmak üzere aranızdan adamlar silahlandırın. ");
INSERT INTO turytc_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Her oymaktan, İsrael'in bütün oymaklarından bin kişiyi savaşa göndereceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Böylece İsrael binlerinden, her oymaktan bin kişi, savaş için silahlanmış on iki bin kişi teslim edildi. ");
INSERT INTO turytc_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moşe, elinde Kutsal Yer'in takımları ve çağrı borularıyla, her oymaktan bin kişiyi kâhin Eleazar oğlu Pinehas'la savaşa gönderdi. ");
INSERT INTO turytc_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Yahve'nin Moşe'ye buyurduğu gibi Midyan'a karşı savaştılar. Her erkeği öldürdüler. ");
INSERT INTO turytc_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Midyan krallarını da diğerleriyle birlikte öldürdüler: Beş Midyan kralı Evi, Rekem, Sur, Hur ve Reva'dır. Beor oğlu Balam'ı da kılıçla öldürdüler. ");
INSERT INTO turytc_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","İsrael'in çocukları Midyanlı kadınları çocuklarıyla birlikte esir aldılar; ve bütün hayvanlarını, bütün davarlarını ve bütün mallarını yağmaladılar. ");
INSERT INTO turytc_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Yaşadıkları yerlerdeki bütün kentleri ve ordugâhlarını ateşe verdiler. ");
INSERT INTO turytc_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Bütün tutsakları, insan olsun hayvan olsun yağmalanan her şeyi aldılar. ");
INSERT INTO turytc_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Tutsakları ganimetle birlikte yağmayı Moşe'ye, Kâhin Eleazar'a ve İsrael'in çocukları topluluğuna, Yarden'in yanında, Yeriha'daki Moav ovalarında bulunan ordugâha getirdiler. ");
INSERT INTO turytc_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moşe ve Kâhin Eleazar, topluluğun bütün beyleriyle birlikte onları karşılamak için ordugâhın dışına çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moşe, savaş hizmetinden gelen subaylara, binbaşılara, yüzbaşılara öfkelendi. ");
INSERT INTO turytc_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moşe onlara şöyle dedi: “Kadınların hepsini sağ mı bıraktınız? ");
INSERT INTO turytc_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","İşte bunlar, Balam'ın öğüdüyle İsrael'in çocuklarının Peor meselesinde Yahve'ye karşı suç işlemesine neden oldu ve böylece Yahve'nin topluluğu arasında veba oldu. ");
INSERT INTO turytc_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Şimdi çocuklar arasındaki her erkeği öldürün ve erkekle yatmış, erkek bilen her kadını öldürün. ");
INSERT INTO turytc_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Yalnız erkekle yatmamış, erkek bilmeyen bütün kızları kendiniz için sağ bırakın.” ");
INSERT INTO turytc_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Yedi gün ordugâhın dışında konaklayın. İnsan öldüren herkes ve öldürülmüş olana dokunan herkes, siz ve esirleriniz üçüncü ve yedinci günde kendinizi arındırın. ");
INSERT INTO turytc_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Her giysiyi, deriden yapılmış her şeyi, keçi kılından yapılmış her işi ve ağaçtan yapılmış her şeyi arındıracaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kâhin Eleazar savaşa giden askerlere şöyle dedi: “Yahve'nin Moşe'ye buyurduğu yasanın kuralı budur. ");
INSERT INTO turytc_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Ancak altını, gümüşü, tuncu, demiri, kalayı ve kurşunu, ");
INSERT INTO turytc_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ateşe dayanıklı olan her şeyi ateşten geçireceksiniz ve o temiz olacaktır; yine de kirlilik suyu ile arındırılacaktır. Ateşe dayanamayan her şeyi sudan geçireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Yedinci gün giysilerinizi yıkayacaksınız ve temiz olacaksınız. Ondan sonra ordugâha gireceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yahve Moşe'ye şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Sen, kâhin Eleazar ve topluluğun ata evlerinin başları olmak üzere insanlardan ve hayvanlardan alınan ganimeti say; ");
INSERT INTO turytc_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ve ganimeti savaşta becerikli, savaşa giden adamlar ile tüm topluluk arasında ikiye böl. ");
INSERT INTO turytc_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Savaşa çıkan savaşçılardan beş yüzde bir can olmak üzere; insanlardan, sığırlardan, eşeklerden ve sürülerden Yahve için vergi alacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Onların yarısından alıp Yahve'ye sallamalık sunu olarak kâhin Eleazar'a vereceksin. ");
INSERT INTO turytc_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","İsrael'in çocuklarına düşen yarıdan, insanlardan, sığırlardan, eşeklerden, davarlardan ve bütün hayvanlardan seçilen her elli kişiden birini alıp onları Yahve'nin konutu görevini gerçekleştiren Levililer'e vereceksin.” ");
INSERT INTO turytc_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moşe ve Kâhin Eleazar, Yahve'nin Moşe'ye buyurduğu gibi yaptılar. ");
INSERT INTO turytc_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Savaşçıların yağmaladığı ganimetin dışında, yağmalananlar arasında altı yüz yetmiş beş bin koyun, ");
INSERT INTO turytc_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","yetmiş iki bin sığır, ");
INSERT INTO turytc_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","altmış bir bin eşek, ");
INSERT INTO turytc_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ve erkekle yatmamış, erkek bilmeyen kadınlardan toplam otuz iki bin kişi vardı. ");
INSERT INTO turytc_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Savaşa çıkanların payına düşen yarının sayısı üç yüz otuz yedi bin beş yüz koyundu; ");
INSERT INTO turytc_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Yahve'nin koyunlardan aldığı vergi altı yüz yetmiş beşti. ");
INSERT INTO turytc_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Sığırlar otuz altı bindi; bunlardan Yahve'nin vergisi yetmiş ikiydi. ");
INSERT INTO turytc_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Eşekler otuz bin beş yüzdü; bunların Yahve'nin vergisi altmış birdi. ");
INSERT INTO turytc_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","On altı bin kişi vardı; bunlardan Yahve'nin vergisi otuz iki kişiydi. ");
INSERT INTO turytc_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moşe, Yahve'nin kendisine buyurduğu gibi, Yahve'nin sallamalık sunu olan vergiyi Kâhin Eleazar'a verdi. ");
INSERT INTO turytc_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Moşe'nin savaşan erkeklerden böldüğü İsrael'in çocuklarının yarısından ");
INSERT INTO turytc_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(şimdi topluluğun yarısı üç yüz otuz yedi bin beş yüz koyun, ");
INSERT INTO turytc_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","otuz altı bin sığır, ");
INSERT INTO turytc_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","otuz bin beş yüz eşek, ");
INSERT INTO turytc_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ve on altı bin kişiydi), ");
INSERT INTO turytc_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","İsrael'in çocuklarının yarısından, insandan olsun, hayvandan olsun, her elliden çekilmiş olsun birisini, Yahve'nin Moşe'ye buyurduğu gibi Yahve'nin konutu görevini gerçekleştiren Levililer'e verdi. ");
INSERT INTO turytc_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ordu binlerinin başındaki subaylar, binbaşılar ve yüzbaşılar Moşe'ye yaklaştı. ");
INSERT INTO turytc_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Moşe'ye şöyle dediler: “Hizmetkârların, komutamız altındaki askerlerin tamamını aldık; aramızdan tek bir adam bile eksik değil. ");
INSERT INTO turytc_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Yahve'nin önünde canlarımızın kefareti olsun diye, herkesin bulduğu sunuları, altın takıları, ayak halkaları, bilezikleri, mühür yüzüklerini, küpeleri ve kolyeleri getirdik.” ");
INSERT INTO turytc_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moşe ile Kâhin Eleazar onlardan altınları, işlenmiş mücevherlerin hepsini aldılar. ");
INSERT INTO turytc_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Binbaşıların ve yüzbaşıların Yahve'ye sundukları sallama sunusu altının tamamı on altı bin yedi yüz elli şekeldi. ");
INSERT INTO turytc_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Savaşcılar, hepsi kendisi için ganimet almıştı. ");
INSERT INTO turytc_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moşe ile Kâhin Eleazar, binbaşılardan ve yüzbaşılardan altını aldılar ve Yahve'nin önünde İsrael'in çocuklarının anılması için Buluşma Çadırı'na getirdiler. ");
INSERT INTO turytc_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ruven'in çocuklarının ve Gad'ın çocuklarının çok sayıda hayvanı vardı. Yazer ülkesini ve Gilad ülkesini gördüler. İşte, o yer hayvanlara göre bir yerdi. ");
INSERT INTO turytc_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Bunun üzerine Gad'ın çocukları ve Ruven'in çocukları gelip Moşe'ye, Kâhin Eleazar'a ve topluluğun beylerine şöyle dediler: ");
INSERT INTO turytc_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Yazer, Nimra, Heşbon, Eleale, Sevam, Nevo, ve Beon, ");
INSERT INTO turytc_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Yahve'nin İsrael topluluğunun önünde vurduğu ülke, hayvancılık diyarıdır; hizmetkârının da hayvanları var.” ");
INSERT INTO turytc_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Onlar, “Eğer senin gözünde lütuf bulduysak, bu diyar mülk olarak hizmetkârlarına verilsin” dediler. “Bizi Yarden'den geçirmeyin.” ");
INSERT INTO turytc_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moşe Gad'ın çocuklarına ve Ruven'in çocuklarına şöyle dedi: “Siz burada otururken kardeşleriniz savaşa mı gidecek? ");
INSERT INTO turytc_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","İsrael'in çocuklarının yüreğini Yahve'nin kendilerine verdiği ülkeye gitmekten neden vazgeçiriyorsunuz? ");
INSERT INTO turytc_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Babalarınızı ülkeyi görmek için Kadeş-Barnea'dan gönderdiğimde öyle yaptılar. ");
INSERT INTO turytc_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Çünkü Eşkol Vadisi'ne çıkıp ülkeyi gördüklerinde, Yahve'nin kendilerine verdiği ülkeye girmesinler diye, İsrael'in çocuklarının yüreğini yılgınlığa düşürdüler. ");
INSERT INTO turytc_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","O gün Yahve'nin öfkesi alevlendi ve şöyle ant içti: ");
INSERT INTO turytc_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'Mısır'dan çıkan yirmi yaş ve üzeri adamlardan hiçbiri, Avraham'a, İshak'a ve Yakov'a ant içtiğim ülkeyi kesinlikle görmeyecekler; çünkü tamamen beni izlemediler, ");
INSERT INTO turytc_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kenizzi Yefunne oğlu Kalev ve Nun oğlu Yeşu dışında, tamamen beni izlemediler; çünkü onlar tamamen Yahve'nin ardınca gittiler.' ");
INSERT INTO turytc_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Yahve'nin öfkesi İsrael'e karşı alevlendi ve Yahve'nin gözünde kötülük yapan tüm kuşak tükeninceye dek, kırk yıl onları çölde gezdirdi.” ");
INSERT INTO turytc_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“İşte, Yahve'nin İsrael'e karşı öfkesini artırmak için, günahkâr artışıyla, atalarınızın yerine siz kalktınız. ");
INSERT INTO turytc_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Çünkü onun arkasından dönerseniz, yine onları çölde bırakacaktır; siz de bu insanların hepsini yok edeceksiniz.” ");
INSERT INTO turytc_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Onun yanına gelip şöyle dediler: “Burada hayvanlarımız için ağıllar, çocuklarımız için kentler kuracağız; ");
INSERT INTO turytc_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ama biz, İsrael'in çocuklarını kendi yerlerine götürünceye kadar, onların önünden gitmek üzere silahlanmış olacağız. Küçüklerimiz bu ülke sakinleri yüzünden surlu kentlerde oturacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","İsrael'in çocuklarının tümü miraslarını alana dek evlerimize dönmeyeceğiz. ");
INSERT INTO turytc_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Çünkü biz Yarden'in karşı yakasında ve ötesinde miras almayacağız; çünkü mirasımız bize Yarden'in bu yakasında, doğuya doğru düştü.” ");
INSERT INTO turytc_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moşe onlara şöyle dedi: “Eğer bunu yaparsanız, Yahve'nin önünde savaşa gitmek üzere silahlanırsanız, ");
INSERT INTO turytc_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","silahlı adamlarınızın her biri, düşmanlarını önden kovana dek Yahve'nin önünde Yarden'den geçecek, ");
INSERT INTO turytc_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ülke Yahve'nin önünde boyunduruk altına alınınca; sonra geri döneceksiniz ve Yahve'ye ve İsrael'e karşı yükümlülüklerinizden kurtulacaksınız. O zaman bu diyar Yahve'nin önünde sizin mülkünüz olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Ama eğer bunu yapmazsanız, işte, Yahve'ye karşı günah işlemiş olursunuz; ve emin olun günahınız sizi bulacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Çocuklarınız için kentler, koyunlarınız için ağıllar yapın; ve ağzınızdan çıkanı yapın.” ");
INSERT INTO turytc_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gad'ın çocukları ile Ruven'in çocukları Moşe'ye şöyle dediler: “Hizmetkârların efendimin buyurduğu gibi yapacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Çocuklarımız, karılarımız, davarlarımız ve bütün hayvanlarımız burada, Gilad kentlerinde olacaklar; ");
INSERT INTO turytc_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ama efendimin dediği gibi, savaş için silahlanmış olan herkes, hizmetkârların Yahve'nin önünden geçecekler.'' ");
INSERT INTO turytc_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Bunun üzerine Moşe, Kâhin Eleazar'a, Nun oğlu Yeşu'ya ve İsrael'in çocuklarının boylarının atalar evleri beylerine onlar hakkında buyruk verdi. ");
INSERT INTO turytc_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moşe onlara şöyle dedi: “Eğer Gad'ın çocukları ve Ruven'in çocukları, savaşmak üzere silahlanmış olan her adam Yahve'nin önünde sizinle birlikte Yarden'den geçerlerse, ve ülke önünüzde boyunduruk altına alınırsa, o zaman onlara mülk olarak Gilad diyarını vereceksiniz; ");
INSERT INTO turytc_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ama eğer silahlı olarak sizinle birlikte geçmezlerse, Kenan ülkesinde aranızda mülkleri olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad'ın çocukları ile Ruven'in çocukları şöyle yanıt verdiler: “Yahve'nin senin hizmetkârlarına söylediği gibi, biz de öyle yapacağız. ");
INSERT INTO turytc_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Yahve'nin önünde silahlanmış olarak Kenan ülkesine geçeceğiz ve mirasımızın mülkü Yarden'in ötesinde bizde kalacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moşe onlara, Amorlular'ın kralı Sihon'un krallığını ve Başan Kralı Og'un krallığını; ülkeyi, kentlerine ve sınırlarına göre, kentin çevresindeki arazileriyle, Gad'ın çocuklarına, Ruven'in çocuklarına ve Yosef oğlu Manaşşe'nin yarım oymağına verdi. ");
INSERT INTO turytc_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gad'ın çocukları Divon'u, Atarot'u, Aroer'i, ");
INSERT INTO turytc_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-şofan'ı, Yazer'i, Yogveha'yı, ");
INSERT INTO turytc_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beyt-Nimra'yı ve Beyt-Haran'ı kurdular; bunlar surlu kentler ve koyun ağıllarıydı. ");
INSERT INTO turytc_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruven'in çocukları Heşvon'u, Eleale'yi, Kiriatayim'i, ");
INSERT INTO turytc_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nevo'yu, Baal Meon'u (adları değiştirildi) ve Sivma'yı kurdular. Kurdukları kentlere başka adlar verdiler. ");
INSERT INTO turytc_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manaşşe oğlu Makir'in çocukları Gilad'a giderek orayı aldılar ve orada yaşayan Amorlular'ın mülklerinden ettiler. ");
INSERT INTO turytc_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moşe Gilad'ı Manaşşe oğlu Makir'e verdi; ve orada yaşadı. ");
INSERT INTO turytc_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manaşşe oğlu Yair gitti ve onların köylerini aldı ve onlara Havvot Yair adını verdi. ");
INSERT INTO turytc_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Novah gidip Kenat'ı ve köylerini aldı ve oraya kendi adını, Novah adını verdi. ");
INSERT INTO turytc_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","İsrael'in çocuklarının Moşe'yle Aron'un eli altında ordularıyla Mısır diyarından çıktıklarında yaptıkları yolculuklar bunlardır. ");
INSERT INTO turytc_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moşe Yahve'nin buyruğu uyarınca yolculuklarının başlangıç noktalarını yazdı. Bunlar başlangıç noktalarına göre yolculuklarıdır. ");
INSERT INTO turytc_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Birinci ayın on beşinci günü Ramses'ten yola çıktılar. Pesah'ın ertesi günü, İsrael'in çocukları tüm Mısırlılar'ın gözü önünde büyük bir el aracılığıyla çıktılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Mısırlılar, Yahve'nin aralarında vurduğu ilk doğanların hepsini gömüyordu. Yahve aynı zamanda onların ilâhlarını da yargılamıştı. ");
INSERT INTO turytc_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","İsraelliler Ramses'ten yola çıkıp Sukkot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukkot'tan yola çıkıp çölün kıyısındaki Etam'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etam'dan yola çıkıp Baal Sefon'un önündeki Pihahirot'a döndüler ve Migdol'un önünde konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Hahirot'un önünden yola çıkıp denizin ortasından çöle doğru ilerlediler. Etam çölünde üç günlük bir yol alıp Mara'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Mara'dan yola çıkıp Elim'e geldiler. Elim'de on iki su kaynağı ve yetmiş palmiye ağacı vardı ve orada konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elim'den yola çıkıp Kızıldeniz'in yanında konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Kızıldeniz'den yola çıkıp Sin Çölü'nde konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin Çölü'nden yola çıkıp Dofka'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dofka'dan yola çıkıp Aluş'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Aluş'tan yola çıkıp halkın içmesi için suyun olmadığı Refidim'de konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Refidim'den yola çıkıp Sina Çölü'nde konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sina Çölü'nden yola çıkıp Kivrot Hattaava'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kivrot Hattaava'dan yola çıkıp Haserot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Haserot'tan yola çıkıp Ritma'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ritma'dan yola çıkıp Rimmon Peres'te konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmon Peres'ten yola çıkıp Livna'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Livna'dan yola çıkıp Rissa'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissa'dan yola çıkıp Kehelata'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kehelata'dan yola çıkıp Şefer Dağı'nda konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Şefer Dağı'ndan yola çıkıp Harada'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Harada'dan yola çıkıp Makhelot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Makhelot'tan yola çıkıp Tahat'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahat'tan yola çıkıp Terah'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Terah'tan yola çıkıp Mitka'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitka'dan yola çıkıp Haşmona'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Haşmona'dan yola çıkıp Moserot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserot'tan yola çıkıp Bene Yaakan'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Bene Yaakan'dan yola çıkıp Hor Haggidgad'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Hor Haggidgad'dan yola çıkıp Yotvata'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yotvata'dan yola çıkıp Avrona'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Avrona'dan yola çıkıp Esyon Geber'de konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Esyon Geber'den yola çıkıp Zin Çölü'ndeki Kadeş'te konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kadeş'ten yola çıkıp Edom ülkesinin kenarındaki Hor Dağı'nda konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kâhin Aron, İsrael'in çocuklarının Mısır diyarından çıkışının kırkıncı yılında, beşinci ayın, ayın birinci günü, Yahve'nin buyruğu uyarınca Hor Dağı'na çıktı ve orada öldü. ");
INSERT INTO turytc_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aron Hor Dağı'nda öldüğünde yüz yirmi üç yaşındaydı. ");
INSERT INTO turytc_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Güneyde Kenan ülkesinde yaşayan Kenanlı Arad Kralı, İsrael'in çocuklarının geldiğini duydu. ");
INSERT INTO turytc_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Hor Dağı'ndan yola çıkıp Salmona'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Salmona'dan yola çıkıp Punon'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punon'dan yola çıkıp Ovot'ta konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ovot'tan yola çıkıp Moav sınırındaki İye Avarim'de konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","İyim'den yola çıkıp Divon Gad'da konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Divon Gad'dan yola çıkıp Almon Divlatayim'de konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almon Divlatayim'den yola çıkıp Nevo'nun önündeki Avarim dağlarında konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Avarim dağlarından ayrılıp Yarden yanında, Yeriha'daki Moav ovalarında konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Yarden yanında, Beyt-Yeşimot'tan Moav ovalarındaki Avel-Şittim'e kadar konakladılar. ");
INSERT INTO turytc_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Yahve, Moav ovalarında, Yarden yanında, Yeriha'da Moşe'ye şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","İsrael'in çocuklarına söyle ve onlara de ki: “Yarden'i geçerek Kenan ülkesine girdiğinizde, ");
INSERT INTO turytc_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","o zaman ülkede oturanların hepsini önünüzden kovacaksınız, bütün taştan putlarını yok edeceksiniz, bütün dökme putlarını yok edeceksiniz, ve tüm yüksek yerlerini yıkacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ülkeyi mülk edinecek ve orada oturacaksınız; çünkü ülkeyi mülk edinmek için size verdim. ");
INSERT INTO turytc_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ülkeyi oymaklarınıza göre kurayla miras alacaksınız; daha büyük gruplara daha çok, daha küçük gruplara daha az miras vereceksiniz. Birine kura nereye düşerse, orası onun olacaktır. Atalarınızın oymaklarına göre miras alacaksınız.” ");
INSERT INTO turytc_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Ama eğer ülkede yaşayanları önünüzden kovmazsanız, onlardan geriye bıraktıklarınız gözlerinizde iğne, böğrünüzde diken gibi olacak. İçinde oturduğunuz ülkeden sizi sıkıştıracaklar. ");
INSERT INTO turytc_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Öyle olacak ki, onlara ne yapmayı düşündümse size de öyle yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“İsrael'in çocuklarına buyur ve onlara söyle: 'Kenan ülkesine girdiğiniz zaman, (burası size miras olarak düşecek olan ülkedir; sınırlarına göre Kenan ülkesi), ");
INSERT INTO turytc_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","güney sınırınız Zin Çölü'nden Edom kıyısı boyunca olacak ve güney sınırınız Tuz Denizi'nin ucundan doğuya doğru olacak. ");
INSERT INTO turytc_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Sınırınız Akravvim yokuşunun güneyine doğru dönecek ve Zin'e kadar geçecek; ve Kadeş-Barnea'nın güneyinden geçecek; ve oradan Hazar Addar'a gidecek ve Asmon'a geçecek. ");
INSERT INTO turytc_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Sınır Asmon'dan Mısır Irmağı'na doğru dönecek ve denizde sona erecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“'Batı sınırında Büyük Deniz ve onun sınırı olacaktır. Burası sizin batı sınırınız olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“'Kuzey sınırınız bu olacak; kendinize Büyük Deniz'den Hor Dağı'na kadar işaret koyacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hor Dağı'ndan Hama'nın girişine doğru işaret koyacaksınız; sınır Sedad'ın yanından geçecek. ");
INSERT INTO turytc_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Ondan sonra sınır Sifron'a gidecek ve Hazar Enan'da son bulacak. Bu sizin kuzey sınırınız olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“'Doğu sınırınızı Hazar Enan'dan Şefam'a kadar işaret koyacaksınız. ");
INSERT INTO turytc_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Sınır Şefam'dan Ain'in doğusundaki Rivla'ya kadar inecek. Sınır aşağıya inecek ve doğuya doğru Kinneret Denizi kıyısına kadar ulaşacak. ");
INSERT INTO turytc_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Sınır Yarden'e kadar inecek ve Tuz Denizi'nde son bulacaktır. Çevresindeki sınırlarına göre bu sizin ülkeniz olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moşe İsrael'in çocuklarına buyruk verip şöyle dedi: “Bu, kurayla miras alacağınız Yahve'nin dokuz buçuk oymağa verilmesini buyurmuş olduğu ülkedir; ");
INSERT INTO turytc_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","atalarının evlerine göre Ruven'in çocukları oymağı, atalarının evlerine göre Gad'ın çocukları oymağı ve Manaşşe oymağının yarısı miraslarını aldılar. ");
INSERT INTO turytc_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","İki oymakla yarım oymak miraslarını Yarden'in ötesinde, doğuda, gün doğusuna doğru Yeriha'da aldılar.” ");
INSERT INTO turytc_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yahve Moşe'ye şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ülkeyi miras olarak size bölecek olan adamların adları şunlardır: Kâhin Eleazar ve Nun oğlu Yeşu. ");
INSERT INTO turytc_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ülkeyi miras olarak bölmek üzere her oymaktan bir bey alacaksın. ");
INSERT INTO turytc_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","O adamların adları şunlardır: Yahuda oymağından Yefunne oğlu Kalev. ");
INSERT INTO turytc_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Şimon'un çocukları oymağından Ammihud oğlu Şemuel. ");
INSERT INTO turytc_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Benyamin oymağından Kislon oğlu Elidad. ");
INSERT INTO turytc_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan'ın çocukları oymağından bey olarak, Yogli oğlu Bukki. ");
INSERT INTO turytc_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yosef'in çocuklarından: Manaşşe'nin çocukları oymağından bey olarak, Efod oğlu Hanniel. ");
INSERT INTO turytc_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efraim'in çocukları oymağından bey olarak, Şiftan oğlu Kemuel. ");
INSERT INTO turytc_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zevulun'un çocukları oymağından bey olarak, Parnak oğlu Elisafan. ");
INSERT INTO turytc_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","İssakar'ın çocukları oymağından bey olarak, Azzan oğlu Paltiel. ");
INSERT INTO turytc_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aşer'in çocukları oymağından bey olarak, Şelomi oğlu Ahihud. ");
INSERT INTO turytc_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naftali'nin çocukları oymağından bey olarak, Ammihud oğlu Pedahel.” ");
INSERT INTO turytc_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Kenan ülkesinde İsrael'in çocuklarına mirası bölmek için Yahve'nin buyurduğu kişiler bunlardır. ");
INSERT INTO turytc_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yahve, Moav ovalarında, Yarden yanında, Yeriha'da Moşe'ye şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“İsrael'in çocuklarına buyur, miraslarından oturmaları için Levililer'e kentler versinler. Kentler için onların çevresinde Levililer'e otlaklar vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","İçinde oturmak için kentleri olacak. Onların otlakları hayvanları, malları ve bütün sığırları için olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Levililer'e vereceğiniz kentlerdeki otlaklar kentin surlarından başlayıp çevresine doğru bin arşın olacak. ");
INSERT INTO turytc_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Kentin ortada olmak üzere, kentin dışını doğu tarafı için iki bin arşın, güney tarafı için iki bin arşın, batı tarafı için iki bin arşın, kuzey tarafı için iki bin arşın ölçeceksiniz. Bu onların kentlerinin otlakları olacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Levililer'e vereceğiniz kentler, adam öldüren insanın oraya kaçması için vereceğiniz altı sığınak kent olacaktır. Bunların dışında kırk iki kent vereceksiniz. ");
INSERT INTO turytc_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Levililer'e vereceğiniz kentlerin tümü, otlaklarıyla birlikte kırk sekiz kent olacaktır. ");
INSERT INTO turytc_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","İsrael'in çocuklarına mülk olarak vereceğiniz kentlerin çoğundan çoğunu, azından da azını alacaksınız. Herkes miras aldığı mirasa göre kentlerinden bazılarını Levililer'e verecek. ");
INSERT INTO turytc_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yahve Moşe'ye şöyle konuştu: ");
INSERT INTO turytc_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“İsrael'in çocuklarına söyle ve onlara de: Yarden'i aşıp Kenan ülkesine girdiğinizde, ");
INSERT INTO turytc_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ondan sonra kendinize sığınacak kentler olarak kentler atayacaksınız; kasıtsız birini öldüren kişi oraya kaçabilecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Kentler sizin için öç alandan sığınacağınız yer olacak; öyle ki, adam öldüren kişi yargılanmak üzere topluluğun önüne çıkana dek ölmesin. ");
INSERT INTO turytc_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Vereceğiniz kentler sizin için altı sığınak kent olacak. ");
INSERT INTO turytc_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Yarden'in ötesinde üç kent vereceksiniz ve Kenan ülkesinde de üç kent vereceksiniz. Bunlar sığınma kentleri olacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Bu altı kent İsrael'in çocuklarına, gariplere ve aralarında yaşayan yabancılara sığınak olacak; öyle ki, kasıtsız birini öldüren herkes oraya kaçabilsin.” ");
INSERT INTO turytc_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“'Ama eğer onu demir bir aletle vurmuş ve o ölmüşse, o katildir. Katil kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Eğer elindeki bir adamı öldürebilecek bir taşla onu vurmuş ve o ölmüşse, o katildir. Katil kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ya da insanı öldürebilecek elindeki ağaçtan bir silahla ona vurmuş ve o ölmüşse, o katildir. Katil kesinlikle öldürülecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Kan öcü alan, katili kendisi öldürecektir. Onunla karşılaştığında onu öldürecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Eğer kinden dolayı onu iterse, ya da pusuya yatıp ona bir şey fırlatmışsa ve o ölmüşse, ");
INSERT INTO turytc_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ya da düşmanlıkla ona eliyle vurmuşsa ve o ölmüşse, ona vuran kişi kesinlikle öldürülecektir. O katildir. Kan öcünü alan, katille karşılaştığında onu öldürecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“'Ama eğer onu ansızın düşmanlık olmadan iterse, ya da pusuya yatmadan üzerine bir şey fırlatmışsa, ");
INSERT INTO turytc_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ya da görmeden üstüne insanın ölebileceği bir taş atmış ve o ölmüşse, onun düşmanı olmadan zararını aramamışsa, ");
INSERT INTO turytc_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","o zaman topluluk, vuranla kan öcünü alan arasında bu hükümlere göre hüküm verecektir. ");
INSERT INTO turytc_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Topluluk, adam öldüren kişiyi kan öcü alanın elinden kurtaracak ve topluluk onu kaçtığı sığınma kentine geri gönderecektir. Kutsal yağla meshedilen başkâhinin ölümüne dek orada oturacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“'Ama adam öldüren kişi herhangi bir zamanda kaçmış olduğu sığındığı kentin sınırlarının dışına çıkarsa, ");
INSERT INTO turytc_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","kan öcünü alan kişi de onu sığındığı kentin sınırının dışında bulur ve kan öcü alan onu öldürürse, o kişi kandan suçlu olmayacaktır, ");
INSERT INTO turytc_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","çünkü onun başkâhinin ölümüne dek sığındığı kentte kalması gerekirdi. Yalnız başkâhinin ölümünden sonra, adam öldüren kişi kendi mülkü olan diyara geri dönecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“'Bunlar, tüm konutlarınızda kuşaklar boyunca sizin için kural ve ilke olacaktır.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“'Kim bir insanı öldürürse, katil tanıkların ifadesine göre öldürülecektir; ancak bir tanık, herhangi bir insanın ölmesine karşı tek başına tanıklık etmeyecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“'Ölüm suçlusu katilin yaşamı için de fidye almayacaksınız. Kesinlikle öldürülecektir.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“'Kâhinin ölümünden önce tekrar gelip diyarda otursun diye sığındığı kente kaçan kişiden fidye almayacaksınız.'” ");
INSERT INTO turytc_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“'Yaşadığınız ülkeyi kirletmeyeceksiniz; çünkü kan ülkeyi kirletir. Ülke içinde dökülen kanın kefareti ancak onu dökenin kanı ile olur. ");
INSERT INTO turytc_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Oturduğunuz ve benim oturduğum ülkeyi kirletmeyeceksiniz; çünkü ben, Yahve, İsrael'in çocukları arasında oturuyorum.'” ");
INSERT INTO turytc_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Yosef'in oğulları soylarından Manaşşe oğlu Makir oğlu, Gilad'ın oğulları soyundan atalar evleri beyleri yaklaştılar ve Moşe'nin önünde ve İsrael'in çocuklarının atalar evleri başları olan beylerin önünde konuştular. ");
INSERT INTO turytc_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Onlar şöyle dediler: “Yahve efendime, bu toprakları kurayla İsrael'in çocuklarına miras olarak vermesini buyurdu. Efendime Yahve tarafından kardeşimiz Selofhad'ın mirasını kızlarına vermesi buyruldu. ");
INSERT INTO turytc_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","İsrael'in çocuklarından başka oymakların oğullarından biriyle evlenirlerse, o zaman onların mirası atalarımızın mirasından alınacak ve ait olacakları oymağın mirasına katılacak. Böylece mirasımızın kurasından alınmış olacak. ");
INSERT INTO turytc_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","İsrael'in çocuklarının Jübile'si geldiğinde, onların mirası ait olacakları oymağın mirasına katılacak. Böylece onların mirası atalarımızın oymağının mirasından alınacak.” ");
INSERT INTO turytc_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moşe, Yahve'nin sözüne göre İsrael'in çocuklarına şu buyruğu verdi: “Yosefoğulları oymağı doğru söylüyor. ");
INSERT INTO turytc_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Selofhad'ın kızları hakkında Yahve'nin buyurup söylediği şey şudur: Onlar en iyisinin kim olduğunu düşünüyorsa onunla evlensinler, yalnız babalarının oymağının soyu içinde evlenecekler. ");
INSERT INTO turytc_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Böylece İsrael'in çocuklarının mirası oymaktan oymağa geçmeyecek; çünkü İsrael'in çocuklarının hepsi atalarının oymağının mirasını koruyacaklar. ");
INSERT INTO turytc_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","İsrael'in çocuklarından herhangi bir oymağında mirasa sahip olan her kız, babasının oymağının soyundan birine eş olacak; böylece İsrael'in çocuklarının her biri atalarının mirasına sahip olabilecekler. ");
INSERT INTO turytc_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Böylece miras bir oymaktan diğerine geçmeyecektir; çünkü İsrael'in çocuklarının oymaklarının her biri kendi mirasını koruyacaktır.” ");
INSERT INTO turytc_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofhad'ın kızları, Yahve'nin Moşe'ye buyurduğu gibi yaptı: ");
INSERT INTO turytc_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Çünkü Selofhad'ın kızları Mahlah, Tirsa, Hoglah, Milka ve Noa, babalarının kardeşinin oğullarıyla evlendiler. ");
INSERT INTO turytc_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Yosef oğlu Manaşşe'nin oğullarının soyları içinde evlendiler. Mirasları atalarının soyunun oymağında kaldı. ");
INSERT INTO turytc_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Bunlar, Yahve'nin Moşe aracılığıyla Yarden yanında Yeriha'daki Moav ovalarında İsrael'in çocuklarına buyurduğu buyruk ve kurallardır. ");
INSERT INTO turytc_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Bunlar Moşe'nin Yarden'in ötesinde, çölde, Suf'un karşısındaki Arava'da, Paran, Tofel, Lavan, Hazerot ve Dizahav arasında bütün İsrael'e söylediği sözlerdir. ");
INSERT INTO turytc_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Horev'den Seir Dağı yoluyla Kadeş-Barnea'ya on bir günlük bir yoldur. ");
INSERT INTO turytc_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Heşbon'da yaşayan Amorlular'ın Kralı Sihonu ve Edrei'deki Aştarot'ta yaşayan Başan Kralı Og'u vurduktan sonra, ");
INSERT INTO turytc_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","kırkıncı yıl, on birinci ayın birinci günü Moşe, Yahve'nin kendisine verdiği buyrukların hepsini İsrael'in çocuklarına söyledi. ");
INSERT INTO turytc_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yarden'in ötesinde, Moav ülkesinde Moşe bu yasayı şöyle duyurmaya başladı: ");
INSERT INTO turytc_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Tanrımız Yahve Horev'de bizimle konuştu ve şöyle dedi, 'Bu dağda yeterince yaşadınız. ");
INSERT INTO turytc_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Dönüp yola çıkın ve Amorlular'ın dağlık bölgesine ve oraya yakın bütün yerlere, Arava'da, dağlık bölgede, ovada, güneyde, deniz kıyısında, Kenanlılar ve Lübnan'da büyük nehre, Fırat Nehri'ne kadar gidin. ");
INSERT INTO turytc_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","İşte, ülkeyi önünüze koydum. Girin ve Yahve'nin atalarınıza, Avraham'a, İshak'a ve Yakov'a, onlara ve kendilerinden sonra onların soyuna vereceğine dair ant içtiği ülkeyi mülk edinin.'” ");
INSERT INTO turytc_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","O sırada sizinle konuşup şöyle dedim: “Ben sizi tek başıma taşıyamam. ");
INSERT INTO turytc_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Tanrınız Yahve sizi çoğalttı; ve işte, bugün çok sayıda gökteki yıldızlar gibisiniz. ");
INSERT INTO turytc_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Atalarınızın Tanrısı Yahve, sizi olduğunuzdan bin kat daha fazla kılsın ve söz verdiği gibi sizi kutsasın! ");
INSERT INTO turytc_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Sorunlarınıza, yüklerinize, çekişmelerinize ben tek başıma nasıl katlanabilirim? ");
INSERT INTO turytc_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Oymaklarınız arasından saygın, anlayışlı bilge adamları alın, ben de onları üzerinize baş olarak atayacağım.” ");
INSERT INTO turytc_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Bana yanıt verip dediniz: “Söylemiş olduğun şeyin yapılması iyidir.” ");
INSERT INTO turytc_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Bunun üzerine oymaklarınızdan bilge ve saygın adamların başlarını aldım ve onları üzerinize başlar, binbaşılar, yüzbaşılar, ellibaşılar ve onbaşılar ve oymaklarınıza göre görevliler yaptım. ");
INSERT INTO turytc_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","O zaman hakimlerinize şöyle buyurmuştum: “Kardeşlerinizin arasındaki davaları dinleyin ve bir adamla kardeşi ve onunla birlikte yaşayan yabancı arasında doğrulukla hükmedin. ");
INSERT INTO turytc_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Hüküm verirken taraf tutmayacaksınız; küçüğü de büyüğü gibi dinleyeceksiniz. İnsan yüzünden korkmayacaksınız, çünkü hüküm Tanrı'nındır. Sizin için çok zor olan davayı bana getireceksiniz, ben de onu dinleyeceğim.” ");
INSERT INTO turytc_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","O zaman yapmanız gereken her şeyi size buyurmuştum. ");
INSERT INTO turytc_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Tanrımız Yahve'nin bize buyurduğu gibi Horev'den yola çıktık ve Amorlular'ın dağlık bölgesine giden yolda gördüğünüz o büyük ve korkunç çölden geçtik; ve Kadeş Barnea'ya geldik. ");
INSERT INTO turytc_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Size şöyle dedim: “Tanrımız Yahve'nin bize vermekte olduğu Amorlular'ın dağlık bölgesine geldiniz. ");
INSERT INTO turytc_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","İşte, Tanrınız Yahve ülkeyi önünüze koydu. Çıkın, atalarınızın Tanrısı Yahve'nin size söylediği gibi mülk edinin. Korkmayın, yılmayın.” ");
INSERT INTO turytc_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Hepiniz yanıma gelip şöyle dediniz: “Önümüzden adamlar gönderelim, bizim için diyarı araştırsınlar, gitmemiz gereken yol ve gideceğimiz kentler hakkında bize haber getirsinler.” ");
INSERT INTO turytc_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Bu şey beni hoşnut etti. Her oymaktan bir adam olmak üzere on iki adamınızı aldım. ");
INSERT INTO turytc_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Dönüp dağlık bölgeye çıkıp Eşkol Vadisi'ne geldiler ve orayı araştırdılar. ");
INSERT INTO turytc_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ülkenin ürünlerinden bir kısmını ellerine alıp bize getirdiler ve bize tekrar haber getirip, “Burası Tanrımız Yahve'nin bize verdiği iyi bir ülkedir” dediler. ");
INSERT INTO turytc_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Yine de yukarı çıkmadınız ve Tanrınız Yahve'nin buyruğuna karşı isyan ettiniz. ");
INSERT INTO turytc_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Çadırlarınızda söylenip şöyle dediniz: “Yahve bizden nefret ettiği için, bizi yok etmek üzere Amorlular'ın eline teslim etmek için bizi Mısır diyarından çıkardı. ");
INSERT INTO turytc_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Nereye çıkıyoruz? Kardeşlerimiz, ‘O halk bizden büyük ve uzundur’ diyerek yüreklerimizi erittiler. 'Kentler büyüktür, gökyüzüne kadar da surludur. Üstelik orada Anakoğulları'nı da gördük!'” ");
INSERT INTO turytc_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Sonra size, “Dehşete kapılmayın” dedim. “Onlardan korkmayın. ");
INSERT INTO turytc_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Önünüzden gitmekte olan Tanrınız Yahve, Mısır'da gözlerinizin önünde sizin için yaptığı her şeye göre sizin için savaşacaktır, ");
INSERT INTO turytc_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ve çölde bu yere gelinceye kadar gittiğiniz bütün yolda, Tanrınız Yahve'nin bir adamın oğlunu taşıdığı gibi sizi nasıl taşıdığını gördünüz.” ");
INSERT INTO turytc_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ancak, çadırlarınızı kurmak üzere size yer aramak, gitmeniz gereken yolu size göstermek için geceleyin ateşte ve gündüzleri bulutta, ");
INSERT INTO turytc_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","önünüzden yolda giden Tanrınız Yahve'ye bu şeyde inanmadınız. ");
INSERT INTO turytc_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Yahve sizin sözlerinizin sesini duydu ve öfkelendi ve şöyle ant içti: ");
INSERT INTO turytc_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Atalarınıza vermeye ant içtiğim güzel ülkeyi, bu kötü kuşağın bu kötü adamlarından, Yefunne oğlu Kalev dışında hiç kimse kesinlikle görmeyecektir. ");
INSERT INTO turytc_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","O görecektir. Ayak bastığı diyarı ona ve çocuklarına vereceğim, çünkü o tümüyle Yahve'nin peşinden gitti.” ");
INSERT INTO turytc_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Yahve sizin yüzünüzden bana da kızıp şöyle dedi: “Sen de oraya girmeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Önünde duran Nun oğlu Yeşu oraya girecek. Onu yüreklendir, çünkü o, ülkeyi İsrael'e miras edindirecektir. ");
INSERT INTO turytc_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Tutsak alınacaklarını ya da öldürüleceklerini söylediğiniz çocuklarınız, bugün iyiyi ve kötüyü bilmeyen çocuklarınız da oraya girecekler. Onu onlara vereceğim, onlar da onu mülk edinecekler. ");
INSERT INTO turytc_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ama siz dönün ve Kızıldeniz yolundan çöle doğru yol alın.” ");
INSERT INTO turytc_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","O zaman siz bana şöyle yanıt verdiniz: “Yahve'ye karşı günah işledik. Tanrımız Yahve'nin bize buyurduğu her şeye göre çıkıp savaşacağız.” Her biriniz savaş silahlarını kuşandı ve dağlık bölgeye çıkmakla haddinizi aştınız. ");
INSERT INTO turytc_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Yahve bana şöyle dedi: “Onlara de ki, 'Çıkmayın ve savaşmayın; çünkü ben aranızda değilim, düşmanlarınızın önünde vurulmayasınız.'” ");
INSERT INTO turytc_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Böylece size söyledim, ama dinlemediniz; ama siz Yahve'nin buyruğuna karşı isyan ettiniz, küstahlık ettiniz ve dağlık bölgeye çıktınız. ");
INSERT INTO turytc_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","O dağlık bölgede yaşayan Amorlular size karşı çıktılar, sizi arılar gibi kovaladılar, Seir'de, Horma'ya kadar sizi yendiler. ");
INSERT INTO turytc_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Siz geri döndünüz ve Yahve'nin önünde ağladınız, ama Yahve sesinizi dinlemedi, kulağını size döndürmedi. ");
INSERT INTO turytc_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Böylece kaldığınız günlere göre, Kadeş'te birçok günler oturdunuz. ");
INSERT INTO turytc_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Sonra döndük ve Yahve'nin bana söylediği gibi Kızıldeniz yolundan çöle doğru yola çıktık; Seir Dağı'nın çevresinde günlerce dolaştık. ");
INSERT INTO turytc_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Yahve benimle konuşup şöyle dedi, ");
INSERT INTO turytc_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Bu dağın çevresinde yeterince uzun dolandınız. Kuzeye dönün. ");
INSERT INTO turytc_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Halka buyurup deyin: 'Seir'de oturan kardeşlerinizin, Esav'ın çocuklarının sınırından geçeceksiniz; ve sizden korkacaklar. Bu nedenle dikkatli olun. ");
INSERT INTO turytc_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Onlarla çekişmeyin; çünkü size onların diyarından ayak tabanı basacak kadar bile toprak vermeyeceğim; çünkü mülk olarak Seir Dağı'nı Esav'a verdim. ");
INSERT INTO turytc_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Onlardan para karşılığında yiyecek satın alacaksınız. İçmek için suyu da onlardan para karşılığında satın alacaksınız.’” ");
INSERT INTO turytc_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Çünkü Tanrınız Yahve, ellerinizin tüm işinde sizi kutsadı. Bu büyük çölde yürüdüğünüzü biliyor. Bu kırk yıl boyunca Tanrınız Yahve sizinle birlikteydi. Hiçbir eksiğiniz olmadı. ");
INSERT INTO turytc_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Böylece Seir'de oturan kardeşlerimiz Esav'ın çocuklarının yanından, Arava yolundan Elat'tan ve Esion Gever'den geçtik. Dönüp Moav Çölü yolundan geçtik. ");
INSERT INTO turytc_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Yahve bana şöyle dedi: “Moav'ı rahatsız etme, onlarla savaşa girişme; çünkü Ar'ı mülk olarak Lut'un çocuklarına verdim.” ");
INSERT INTO turytc_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Daha önce orada Emler yaşıyordu; büyük ve kalabalık bir halktı ve Anaklılar kadar uzun boyluydu. ");
INSERT INTO turytc_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Bunlar da Anaklılar gibi Refalar sayılırlar; ama Moavlılar onlara Emler derler. ");
INSERT INTO turytc_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Geçmişte Horlular de Seir'de yaşardı, ama Esav'ın çocukları onların yerini aldı. İsraelliler, Yahve'nin kendilerine verdiği mülkü olan ülkeye yaptığı gibi, onları önlerinde yok edip onların yerinde yaşadılar.) ");
INSERT INTO turytc_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Şimdi kalkın ve Zered Deresi'ni geçin.” Zered Deresi'nin üzerinden geçtik. ");
INSERT INTO turytc_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Yahve'nin onlara ant içtiği gibi, ordugâhın ortasından bütün savaş adamlarının kuşağı tükeninceye dek, Kadeş-Barnea'dan Zered Deresi'ne varıncaya kadar geldiğimiz günler otuz sekiz yıldı. ");
INSERT INTO turytc_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Yahve'nin eli de, onları ordugâhın ortasından tükeninceye kadar yok etmek üzere onlara karşıydı. ");
INSERT INTO turytc_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Böylece, halkın arasından bütün savaş adamları tükenip ölünce, ");
INSERT INTO turytc_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Yahve benimle konuşup şöyle dedi: ");
INSERT INTO turytc_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Sen bugün Moav sınırındaki Ar'ı geçeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ammonlular'ın sınırına yaklaştığınızda onları rahatsız etmeyin, onlarla çekişmeyin. Çünkü Ammon'un çocuklarına ait diyardan hiçbirini mülk olarak sana vermeyeceğim; çünkü onu mülk olarak Lut'un çocuklarına verdim.” ");
INSERT INTO turytc_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Burası da Refalar diyarı sayılır. Geçmişte Refalar orada yaşamıştı, ama Ammonlular onlara Zamzumlar derler; ");
INSERT INTO turytc_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Anaklılar gibi çok sayıda ve uzun boylu, büyük bir halktı; ama Yahve onları İsrael'in önünden yok etti ve onlar onların yerine aldı ve yerlerinde yaşadılar). ");
INSERT INTO turytc_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Horlular'ı onların önlerinden yok ettiğinde Seir'de oturan Esav'ın çocukları için yaptığı gibi, onlar da onların yerini aldı ve bugüne dek onların yerinde yaşadılar. ");
INSERT INTO turytc_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Avlar Gaza'ya kadar olan köylerde yaşıyordu: Kaftor'dan çıkan Kaftorlular onları yok edip yerlerinde yaşadılar.) ");
INSERT INTO turytc_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Kalkın, yola çıkın ve Arnon Vadisi'ni geçin. İşte Heşbon Kralı Amorlu Sihon'u ve ülkesini elinize verdim; mülk olarak onu almaya başlayın ve onunla savaşa girişin. ");
INSERT INTO turytc_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Bugün gökyüzünün altında olan halklar üzerine, sizin dehşetinizi ve korkunuzu koymaya başlayacağım, onlar sizin haberinizi duyacaklar ve sizin yüzünüzden titreyecek ve acı içinde kalacaklar.'' ");
INSERT INTO turytc_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Kedemot Çölü'nden Heşbon Kralı Sihon'a esenlik sözleriyle ulaklar gönderip dedim, ");
INSERT INTO turytc_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“İzin ver diyarından geçeyim. Ana yoldan gideceğim. Ne sağa ne sola sapacağım. ");
INSERT INTO turytc_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Yemem için bana para karşılığında yiyecek satacaksın; ve içeyim diye bana para karşılığında su vereceksin. ");
INSERT INTO turytc_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Seir'de yaşayan Esav'ın çocukları ve Ar'da yaşayan Moavlılar'ın bana yaptığı gibi, Yarden'den Tanrımız Yahve'nin bize vermekte olduğu ülkeye geçene kadar yalnızca ayaklarımın üzerinde geçeyim.'' ");
INSERT INTO turytc_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ama Heşbon Kralı Sihon onun yanından geçmemize izin vermedi; çünkü Tanrınız Yahve, onu bugün olduğu gibi elinize teslim etmek için onun ruhunu katılaştırdı ve yüreğini inatçı yaptı. ");
INSERT INTO turytc_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Yahve bana şöyle dedi: “İşte, Sihon'u ve ülkesini senin önünde teslim etmeye başladım. Mülk edinmeye başlayın ki, onun ülkesini miras alasın.” ");
INSERT INTO turytc_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Bunun üzerine Sihon, kendisi ve bütün halkı Yahaz'da savaşmak üzere bize karşı çıktı. ");
INSERT INTO turytc_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Tanrımız Yahve onu önümüze teslim etti; biz de onu, oğullarını ve bütün halkını vurduk. ");
INSERT INTO turytc_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","O zaman onun bütün kentlerini aldık ve içinde oturulan her kenti, kadınları ve çocukları ile birlikte tamamen yok ettik. Kimseyi bırakmadık. ");
INSERT INTO turytc_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Alıp yağmaladığımız kentlerin yanı sıra yalnızca kendimiz için yağma olarak aldığımız hayvanlar vardı. ");
INSERT INTO turytc_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Arnon Vadisi kıyısındaki Aroer'den ve vadideki kentten Gilad'a kadar bizden daha üstün bir kent yoktu. Tanrımız Yahve önümüzde hepsini teslim etti. ");
INSERT INTO turytc_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Yalnız Ammon'un çocuklarının ülkesine, Yabbok Irmağı'nın bütün kıyılarına, dağlık bölgedeki kentlere ve Tanrımız Yahve'nin bizi yasakladığı yerlere yaklaşmadınız. ");
INSERT INTO turytc_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Ondan sonra dönüp Başan'a doğru yola çıktık. Başan Kralı, kendisi ve tüm halkı Edrei'de savaşmak üzere bize karşı çıktı. ");
INSERT INTO turytc_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Yahve bana şöyle dedi: “Ondan korkma; çünkü onu, bütün halkıyla ve ülkesiyle birlikte senin eline teslim ettim. Heşbon'da yaşayan Amorlular'ın Kralı Sihon'a yaptığın gibi ona da yapacaksın.” ");
INSERT INTO turytc_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Böylece Tanrımız Yahve Başan Kralı Og'u ve tüm halkını elimize teslim etti. Kimsesi kalmayana dek onu vurduk. ");
INSERT INTO turytc_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","O zaman onun bütün kentlerini aldık. Onlardan almadığımız bir kent bile kalmadı: Altmış kent, Argov bölgesinin tamamı, Başan'daki Og Krallığı. ");
INSERT INTO turytc_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Bunların hepsi yüksek duvarlarla, kapılarla ve sürgülerle sağlamlaştırılmış kentlerdi ve bunun yanı sıra çok sayıda duvarsız köy de vardı. ");
INSERT INTO turytc_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Heşbon Kralı Sihon'a yaptığımız gibi, onları da tamamen yok ettik; kadınlar ve çocuklarla birlikte içinde oturulan her kenti tamamen yok ettik. ");
INSERT INTO turytc_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ancak bütün hayvanları ve kentlerden yağmalanan malları kendimiz için yağmaladık. ");
INSERT INTO turytc_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","O sırada o diyarı, Yarden'in ötesinde, Arnon Vadisi'nden Hermon Dağı'na kadar Amorlular'ın iki kralının elinden aldık. ");
INSERT INTO turytc_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Saydalılar Hermon'a Sirion, Amorlular ise Senir derler.) ");
INSERT INTO turytc_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Ovadaki bütün kentleri, bütün Gilad'ı ve bütün Başan'ı, Başan'daki Og Krallığı'nın kentleri olan Saleka ve Edrei'ye kadar ele geçirdik. ");
INSERT INTO turytc_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Refalar'dan geride kalan yalnızca Başan Kralı Og vardı. İşte, onun yatağı demirden bir yataktı. Yatak Ammon'un çocuklarının Rabba'sında değil mi? İnsan arşınına göre, uzunluğu dokuz arşın, genişliği dört arşındı. ");
INSERT INTO turytc_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","O sırada mülk edindiğimiz bu diyarı, Arnon Vadisi kıyısındaki Aroer'den, Gilad dağlık bölgesinin yarısını ve kentlerini Ruvenliler'e ve Gadiler'e verdim; ");
INSERT INTO turytc_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Gilad'ın geri kalanını ve Og Krallığı olan Başan'ın tamamını, Argov bölgesinin tamamını, Başan'ın tamamını Manaşşe'nin yarım oymağına verdim. (Aynı yere Refalar diyarı da denir. ");
INSERT INTO turytc_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manaşşe oğlu Yair, Geşurlular ile Maakalılar sınırına kadar olan Argov bölgesinin tamamını ele geçirdi ve onlara Başan'a, kendi adına göre Havvot Yair adını verdi, bugüne kadar böyle denir.) ");
INSERT INTO turytc_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Gilad'ı Makir'e verdim. ");
INSERT INTO turytc_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ruvenliler'e ve Gadlılar'a Gilad'dan vadinin ortası sınır olmak üzere Arnon Vadisi'ne kadar, Ammon oğullarının sınırı olan Yabbok Irmağı'na kadar verdim; ");
INSERT INTO turytc_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Yarden sınır olmak üzere Kinneret'ten Arava Denizi'ne, Tuz Denizi'ne, doğuda Pisga yamaçları altına kadar Arava'yı da verdim. ");
INSERT INTO turytc_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","O zaman size buyurup dedim, “Tanrınız Yahve bu diyarı mülk olarak size verdi. Siz bütün yiğitler, kardeşlerinizin, İsrael'in çocuklarının önünden silahlı olarak geçeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ancak karılarınız, çocuklarınız ve hayvanlarınız (çok sayıda hayvanınız olduğunu biliyorum), ");
INSERT INTO turytc_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Yahve size verdiği gibi kardeşlerinize de rahat verinceye ve Yarden'in ötesinde Tanrınız Yahve'nin onlara vermekte olduğu mülke onlar da sahip oluncaya dek size verdiğim kentlerde yaşayacaklar. Ondan sonra her biriniz size verdiğim mülküne geri dönecektir.” ");
INSERT INTO turytc_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","O sırada Yeşu'ya buyurup dedim: “Tanrın Yahve'nin bu iki krala yaptığı her şeyi gözlerin gördü. Yahve gitmekte olduğunuz bütün krallıklara da öyle yapacaktır. ");
INSERT INTO turytc_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Onlardan korkmayacaksınız; Çünkü Tanrınız Yahve'nin kendisi sizin için savaşıyor.” ");
INSERT INTO turytc_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","O sırada Yahve'ye yalvarıp dedim, ");
INSERT INTO turytc_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ey Efendi Yahve, hizmetkârına büyüklüğünü, güçlü elini göstermeye başladın. Çünkü gökte ve yerde seninki gibi işler yapabilecek ve seninki gibi kudretli eylemler yapabilecek hangi ilâh var? ");
INSERT INTO turytc_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Lütfen izin ver de geçeyim, Yarden'in ötesindeki güzel ülkeyi, o güzel dağı ve Lübnan'ı göreyim.” ");
INSERT INTO turytc_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ancak Yahve sizin yüzünüzden bana kızdı ve beni dinlemedi. Yahve bana şöyle dedi: “Yeter! Artık bana bu konu hakkında bir daha konuşma. ");
INSERT INTO turytc_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Pisga'nın zirvesine çık, gözlerini batıya, kuzeye, güneye ve doğuya kaldır ve gözlerinle gör; çünkü bu Yarden'i geçmeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ama Yeşu'yu görevlendir, onu cesaretlendir ve güçlendir; çünkü bu halkın önüne geçecek ve göreceğin o ülkeyi miras olarak onlara aldıracak olan odur.” ");
INSERT INTO turytc_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Böylece Beyt-Peor yakınındaki vadide kaldık. ");
INSERT INTO turytc_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Şimdi, ey İsrael, sana öğrettiğim kuralları ve ilkeleri yapmak için dinle ta ki, yaşayasınız, içeri giresiniz ve atalarınızın Tanrısı Yahve'nin size vermekte olduğu ülkeyi mülk edinesiniz. ");
INSERT INTO turytc_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Size buyurmakta olduğum söze bir şey katmayacaksınız ve ondan bir şey çıkarmayacaksınız ta ki, Tanrınız Yahve'nin size buyurmakta olduğum buyruklarını tutasınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Yahve'nin Baal Peor yüzünden yaptıklarını gözleriniz gördü; çünkü Tanrınız Yahve aranızdan Baal Peor'un ardından gitmiş olan bütün erkekleri yok etti. ");
INSERT INTO turytc_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ama siz, Tanrınız Yahve'ye sadık olanlar, hepiniz bugün hayattasınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","İşte, Tanrım Yahve'nin bana buyurduğu gibi, mülk edinmek için gittiğiniz ülkenin ortasında öyle yapmanız için size kurallar ve ilkeler öğrettim. ");
INSERT INTO turytc_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Bu nedenle bunları tutun ve yapın; çünkü bütün bu kuralları duyup, “Gerçekten bu büyük ulus bilge ve anlayışlı bir halktır” diyecek olan halkların gözünde sizin bilgeliğiniz ve anlayışınız budur. ");
INSERT INTO turytc_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Çünkü kendisini her çağırdığımızda Tanrımız Yahve'nin bize yakın olduğu gibi, kendilerine bu kadar yakın bir tanrısı olan hangi büyük ulus vardır? ");
INSERT INTO turytc_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Bugün önünüze koymakta olduğum bu yasa gibi doğru kuralları ve ilkeleri olan hangi büyük ulus var? ");
INSERT INTO turytc_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ancak dikkatli olun ve canınızı özenle koruyun, gözlerinizin gördüğü şeyleri unutmayasınız ve bunlar yaşamınızın bütün günleri boyunca yüreğinizden kaybolmasın; ama bunları çocuklarınıza ve çocuklarınızın çocuklarına bildirin; ");
INSERT INTO turytc_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Horev'de Tanrınız Yahve'nin önünde durduğunuz gün, Yahve bana şöyle dedi: “Halkı yanıma topla, ben de sözlerimi onlara işittireceğim ta ki, yeryüzünde yaşadıkları bütün günler boyunca benden korkmayı öğrensinler ve çocuklarına öğretsinler.” ");
INSERT INTO turytc_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Siz de yaklaştınız ve dağın altında durdunuz. Dağ, karanlıkla, bulutla ve koyu karanlıkla birlikte gökyüzünün yüreğine kadar ateşle yandı. ");
INSERT INTO turytc_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Yahve sizinle ateşin içinden konuştu; siz sözlerin sesini duydunuz, ama bir biçim görmediniz; sadece bir ses duydunuz. ");
INSERT INTO turytc_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","O, yapmanızı buyurduğu antlaşmasını, On Buyruk'u size bildirdi. Bunları iki taş levha üzerine yazdı. ");
INSERT INTO turytc_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Yahve o sırada bana, mülk edinmek üzere geçmekte olduğunuz ülkede yapabilesiniz diye size kurallar ve ilkeler öğretmemi buyurdu. ");
INSERT INTO turytc_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Çok dikkatli olun; çünkü Yahve'nin Horev'de sizinle ateşin içinden konuştuğu gün hiçbir biçim görmediniz; ");
INSERT INTO turytc_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","kendinizi yozlaştırmayasınız ve kendinize herhangi bir biçimde erkek ya da kadın benzerliğinde, ");
INSERT INTO turytc_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","yeryüzündeki herhangi bir hayvanın benzerliğinde, gökyüzünde uçan herhangi bir kanatlı kuşun benzerliğinde, ");
INSERT INTO turytc_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","toprakta sürünen herhangi bir şeyin benzerliğinde, yeryüzünün altında suda olan herhangi bir balığın benzerliğinde, oyma put yapmayasınız; ");
INSERT INTO turytc_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ve gözlerinizi gökyüzüne kaldırmayın ve Tanrınız Yahve'nin tüm gökyüzünün altındaki bütün halklara bölüştürdüğü güneşi, ayı ve yıldızları, gökyüzünün bütün ordusunu gördüğünüzde, geri çekilip onlara tapmayasınız ve onlara hizmet etmeyesiniz. ");
INSERT INTO turytc_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Ancak Yahve bugün olduğu gibi kendisine miras halkı olasınız diye sizi alıp demir eritme fırınından, Mısır'dan çıkardı. ");
INSERT INTO turytc_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Üstelik Yahve sizin yüzünüzden bana öfkelendi ve Yarden'den geçmemem ve Tanrınız Yahve'nin miras olarak size vermekte olduğu o güzel ülkeye girmemem için ant içti. ");
INSERT INTO turytc_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ancak benim bu ülkede ölmem gerekiyor. Ben Yarden'in ötesine geçmemeliyim ama siz geçip o güzel ülkeyi mülk olarak alacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Dikkat edin ki, Tanrınız Yahve'nin sizinle yaptığı antlaşmayı unutmayasınız ve Tanrınız Yahve'nin size yasakladığı herhangi bir şeyin biçiminde kendinize oyma put yapmayasınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Çünkü Tanrınız Yahve yiyip bitiren ateş, kıskanç bir Tanrı'dır. ");
INSERT INTO turytc_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Senin çocukların, çocukarının çocukları olup uzun süre ülkede kaldığınızda, sonra kendinizi bozduğunuzda, herhangi bir biçime benzer oyma put yaptığınızda ve Tanrınız Yahve'yi kışkırtmak için O'nun gözünde kötü olanı yaptığınızda, ");
INSERT INTO turytc_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","bugün göğü ve yeri size karşı tanık tutuyorum ki, mülk edinmek için Yarden'in üzerinden geçmekte olduğunuz ülkede çok geçmeden tamamen yok olacaksınız. Onun üzerindeki günleriniz uzun sürmeyecek, ancak tamamıyla yok olacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Yahve sizi halkların arasına dağıtacak, Yahve'nin sizi götüreceği uluslar arasında sayınız az kalacak. ");
INSERT INTO turytc_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Orada görmeyen, duymayan, yemeyen, koklamayan, insan eli işi, tahta ve taştan ilâhlara tapacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ama Tanrınız Yahve'yi oradan arayacaksınız ve O'nu bütün yüreğinizle, bütün canınızla aradığınızda O'nu bulacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Baskı altındayken ve bütün bunlar başınıza geldiğinde, son günlerde Tanrınız Yahve'ye dönüp O'nun sesini dinleyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Çünkü Tanrınız Yahve merhametli bir Tanrı'dır. O, sizi yüzüstü bırakmayacak, sizi yok etmeyecek, atalarınızın antlaşmasını, onlara içtiği andı unutmayacaktır. ");
INSERT INTO turytc_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Çünkü Tanrı'nın yeryüzünde insanı yarattığı günden beri, sizden önceki geçmiş günleri, gökyüzünün bir ucundan öbür ucuna dek şimdi bir sorun; bu şey kadar büyük bir şey oldu mu, ya da böylesi duyuldu mu? ");
INSERT INTO turytc_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Sizin gibi, ateşin içinden konuşan Tanrı'nın sesini duyup da hayatta kalan bir halk oldu mu? ");
INSERT INTO turytc_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ya da Tanrınız Yahve Mısır'da gözlerinizin önünde sizin için yaptığı şeylere göre, denemelerle, belirtilerle, harikalarla, savaşla, kudretli elle, uzanmış kolla ve büyük dehşetlerle gidip başka bir ulus içinden kendisi için bir ulusu almaya kalkıştı mı? ");
INSERT INTO turytc_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Yahve'nin Tanrı olduğunu bilesiniz diye bu size gösterildi. O'nun dışında kimse yok. ");
INSERT INTO turytc_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","O, size buyruk vermek için gökten size sesini duyurdu. Yeryüzünde size büyük ateşini gösterdi; ve siz O'nun sözlerini ateşin içinden duydunuz. ");
INSERT INTO turytc_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Atalarınızı sevdiği için onların soyunu seçti; ");
INSERT INTO turytc_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","sizden daha büyük ve daha güçlü ulusları önünüzden kovmak, onların ülkesini bugün olduğu gibi miras olarak size vermek üzere, içeri getirmek için sizi kendi varlığıyla, büyük gücüyle Mısır'dan çıkardı. ");
INSERT INTO turytc_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Bu nedenle, bugün yukarıda gökte, aşağıda yeryüzünde bilin ve yüreğinize koyun ki, Yahve'nin kendisi Tanrı'dır. Başka biri yoktur. ");
INSERT INTO turytc_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Sizin ve sizden sonra çocuklarınızın hali iyi olsun ve Tanrınız Yahve'nin sonsuza dek size vermekte olduğu ülkede günleriniz uzun olsun diye, bugün size buyurmakta olduğum kuralları ve buyrukları tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Ondan sonra Moşe, Yarden'in ötesinde, gün doğumuna doğru üç kent ayırdı; ");
INSERT INTO turytc_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ta ki, komşusunu geçmişte nefreti olmadan kasıtsızca onu öldüren kişi oraya kaçabilsin ve bu kentlerden birine kaçıp yaşayabilsin: ");
INSERT INTO turytc_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Ruvenililer için ovadaki kırsal, çöldeki Beser; Gadlılar için Gilad'da Ramot; ve Manaşşeliler için Başan'daki Golan. ");
INSERT INTO turytc_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Moşe'nin İsrael'in çocuklarının önüne koyduğu yasa budur. ");
INSERT INTO turytc_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Mısır'dan çıktıklarında Moşe'nin İsrael'in çocuklarına söylediği tanıklıklar, kurallar ve ilkeler bunlardır; ");
INSERT INTO turytc_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Yarden'in ötesinde, Beyt Peor'un karşısındaki vadide, yaşayan Amorlular'ın Kralı Sihon'un ülkesinde, Heşbon'da Moşe ile İsrael'in çocukları onları Mısır'dan çıktıklarında vurdular. ");
INSERT INTO turytc_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Onun ülkesini ve Yarden'in ötesinde, gün doğumuna doğru bulunan Amorlular'ın iki kralı Başan Kralı Og'un ülkesini; ");
INSERT INTO turytc_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Arnon Vadisi'nin kıyısındaki Aroer'den Sion Dağı'na (Hermon da denir) kadar, ");
INSERT INTO turytc_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ve Yarden'in ötesinde doğuya doğru, Pisga yamaçları altındaki Arava Denizi'ne kadar bütün Arava'yı aldılar. ");
INSERT INTO turytc_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Moşe bütün İsrael'i çağırdı ve onlara şöyle dedi: “Dinle Ey İsrael, bugün kulaklarınıza söylediğim kuralları ve ilkeleri öğrenin ve onlara uymaya dikkat edin.” ");
INSERT INTO turytc_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Tanrımız Yahve Horev'de bizimle bir antlaşma yaptı. ");
INSERT INTO turytc_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Yahve bu antlaşmayı atalarımızla değil, bizimle, bugün burada hayatta olan bizlerle yaptı. ");
INSERT INTO turytc_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Yahve dağda ateşin içinden sizinle yüz yüze konuşup, ");
INSERT INTO turytc_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(Ben o sırada Yahve'nin sözünü size göstermek için Yahve ile aranızda durdum; çünkü ateşten korktunuz ve dağa çıkmadınız), dedi. ");
INSERT INTO turytc_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Seni Mısır diyarından, esaret evinden çıkaran Tanrın Yahve benim.” ");
INSERT INTO turytc_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Önümde benden başka ilâhların olmayacak.” ");
INSERT INTO turytc_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Kendine yukarıda gökte olanın, aşağıda yerde olanın ya da yerin altında sularda olanın hiçbir benzerini oyma put yapmayacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Onların önünde eğilmeyeceksin, onlara hizmet etmeyeceksin; çünkü ben, senin Tanrın Yahve, benden nefret edenlerin babalar suçunu çocuklarında, üçüncü ve dördüncü kuşağında arayan, ");
INSERT INTO turytc_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","beni seven ve buyruklarımı tutan binlercesine sevgi dolu iyiliğini gösteren kıskanç bir Tanrı'yım.” ");
INSERT INTO turytc_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Tanrınız Yahve'nin adını hor kullanmayacaksın; çünkü Yahve, adını hor kullananı suçsuz tutmayacaktır.” ");
INSERT INTO turytc_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Tanrınız Yahve'nin size buyurduğu gibi Şabat Günü'nün kutsallığını korumak için onu tut. ");
INSERT INTO turytc_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Altı gün çalışacaksın ve bütün işini yapacaksın; ");
INSERT INTO turytc_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ama yedinci gün, Tanrınız Yahve için Şabat'tır; ne sen, ne oğlun, ne kızın, ne erkek hizmetçin, ne kadın hizmetçin, ne öküzün, ne eşeğin, ne hayvanın, ne kapılarında olan yabancın, hiçbir iş yapmayacaksınız; ta ki, erkek hizmetçin ve kadın hizmetçin, senin gibi dinlenebilsinler. ");
INSERT INTO turytc_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Mısır diyarında hizmetçi olduğunu ve Tanrın Yahve'nin seni güçlü ve uzanmış koluyla oradan çıkardığını hatırlayacaksın. Bu nedenle Tanrın Yahve sana Şabat Günü'nü tutmanı buyurdu.” ");
INSERT INTO turytc_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Tanrın Yahve'nin sana buyurduğu gibi babana ve annene saygı göster ki, günlerin uzun olsun ve Tanrınız Yahve'nin sana vermekte olduğu ülkede işin yolunda gitsin.” ");
INSERT INTO turytc_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Öldürmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Zina etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Çalmayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Komşuna karşı yalan yere tanıklık etmeyeceksin.” ");
INSERT INTO turytc_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Komşunun karısına göz dikmeyeceksin. Komşunuzun evini, tarlasını, erkek hizmetçisini, kadın hizmetçisini, öküzünü, eşeğini ya da komşunun hiçbir şeyini arzulamayacaksın.” ");
INSERT INTO turytc_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Yahve bu sözleri dağda ateşin, bulutun ve koyu karanlığın içinden yüksek sesle tüm topluluğunuza söyledi. Başka bir şey eklemedi. Bunları iki taş levhaya yazdı ve onları bana verdi. ");
INSERT INTO turytc_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Dağ ateşle yanarken, karanlığın içinden sesi duyduğunuzda, bütün oymak başlarınız ve ihtiyarlarınız bana yaklaştınız; ");
INSERT INTO turytc_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ve dediniz: “İşte, Tanrımız Yahve bize yüceliğini ve büyüklüğünü gösterdi; biz de O'nun sesini ateşin içinden duyduk. Bugün Tanrı'nın insanla konuştuğunu ve onun yaşadığını gördük. ");
INSERT INTO turytc_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Öyleyse şimdi neden ölelim? Çünkü bu büyük ateş bizi tüketecek. Eğer Tanrımız Yahve'nin sesini bir daha duyarsak, o zaman öleceğiz. ");
INSERT INTO turytc_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Bütün canlılar arasında, bizim gibi ateşin içinden konuşan diri Tanrı'nın sesini duyup sağ kalan kim var? ");
INSERT INTO turytc_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Sen yaklaş, Tanrımız Yahve'nin söyleyeceği her şeyi dinle ve Tanrımız Yahve'nin sana söyleyeceği her şeyi bize söyle; biz de onu duyacağız ve yapacağız.” ");
INSERT INTO turytc_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Benimle konuştuğunuzda Yahve sözlerinizin sesini duydu; ve Yahve bana şöyle dedi: “Bu halkın sana söylediği sözlerin sesini duydum. Söyledikleri her şeyi iyi söylediler. ");
INSERT INTO turytc_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Keşke onlarda öyle bir yürek olsaydı da, hem kendilerine hem de çocuklarına daima iyilik olsun diye benden korkup bütün buyruklarımı daima tutsalardı!” ");
INSERT INTO turytc_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Git onlara, 'Çadırlarınıza dönün' de. ");
INSERT INTO turytc_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Ama sen burada, yanımda dur. Ben de onlara öğreteceğin bütün buyrukları, kuralları ve ilkeleri sana söyleyeceğim, ta ki mülk edinmek için kendilerine vermekte olduğum ülkede onları yapsınlar.” ");
INSERT INTO turytc_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Bunun için Tanrınız Yahve'nin size buyurduğu gibi yapmaya dikkat edeceksiniz. Sağa ve sola sapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Yaşayasınız, iyi olasınız ve mülk edineceğiniz ülkede günleriniz uzun olsun diye, Tanrınız Yahve'nin size buyurduğu bütün yolda yürüyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Tanrınız Yahve'nin mülk edinmek için geçmekte olduğunuz ülkede yapmanız için size öğretmeyi buyurduğu buyruklar, kurallar ve ilkeler şunlardır; ");
INSERT INTO turytc_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ta ki, yaşamınızın bütün günlerinde sen, oğlun ve oğlunun oğlu sana buyurduğum bütün kuralları ve buyrukları tutarak, Tanrın Yahve'den korkasın ve günlerin uzun olsun. ");
INSERT INTO turytc_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Bu nedenle, dinle ey İsrael, ve bunu yapmaya dikkat et ki, sana iyilik olsun ve atalarının Tanrısı Yahve'nin sana söz verdiği gibi süt ve bal akan diyarda fazlasıyla çoğalasınız. ");
INSERT INTO turytc_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Dinle ey İsrael: Yahve bizim Tanrımız'dır. Yahve birdir. ");
INSERT INTO turytc_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Tanrın Yahve'yi bütün yüreğinle, bütün canınla, bütün gücünle seveceksin. ");
INSERT INTO turytc_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Bugün size buyurmakta olduğum bu sözler senin yüreğinde olacaktır; ");
INSERT INTO turytc_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ve bunları çocuklarına özenle öğreteceksin ve evinde oturduğunda, yolda yürürken, yattığında ve kalktığında onlardan söz edeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Onları elinin üzerine bir işaret olarak bağlayacaksın ve gözlerinin arasında alın bağı olacaklar. ");
INSERT INTO turytc_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Bunları evinin kapı sövelerine ve kapılarının üzerine yazacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Öyle olacak ki, Tanrın Yahve, senin bina etmediğin büyük ve iyi kentleri, senin doldurmadığın bütün iyi şeylerle dolu evleri, ");
INSERT INTO turytc_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","senin kazmadığın kazılmış sarnıçları ve senin dikmediğin bağları ve zeytin ağaçlarını sana vermek üzere, atalarına, Avraham'a, İshak'a ve Yakov'a ant içtiği diyara seni getirecek ve yiyip doyacaksın, ");
INSERT INTO turytc_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","o zaman seni Mısır diyarından, esaret evinden çıkaran Yahve'yi unutmaktan sakın. ");
INSERT INTO turytc_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Tanrın Yahve'den korkacaksın; ve O'na hizmet edeceksin ve O'nun adıyla ant içeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Çevrenizdeki halkların ilâhları olan başka ilâhların ardınca gitmeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Çünkü Tanrın Yahve aranızda kıskanç bir Tanrı'dır, öyle ki, Tanrınız Yahve'nin öfkesi sana karşı alevlenmesin ve seni yeryüzünden yok etmesin. ");
INSERT INTO turytc_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Tanrınız Yahve'yi Massa'da denediğiniz gibi denemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Tanrınız Yahve'nin buyruklarını, tanıklıklarını, size buyurduğu kuralları özenle tutacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Yahve'nin gözünde doğru ve iyi olanı yapacaksın; öyle ki, sana iyilik olsun, ");
INSERT INTO turytc_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ve içeri girip, Yahve'nin söylediği gibi bütün düşmanlarını önünden kovmak için atalarına ant içtiği güzel ülkeyi mülk olarak alasın. ");
INSERT INTO turytc_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Oğlun ileride sana, “Tanrımız Yahve'nin size buyurduğu tanıklıklar, kurallar ve ilkeler ne anlama geliyor?” diye sorunca, ");
INSERT INTO turytc_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","o zaman oğluna, “Mısır'da Firavun'un köleleriydik” diyeceksin. “Yahve güçlü eliyle bizi Mısır'dan çıkardı; ");
INSERT INTO turytc_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ve Yahve Mısır'da, gözlerimizin önünde, Firavun'un üzerinde ve onun bütün evi üzerinde büyük ve dehşet verici belirtiler ve harikalar gösterdi; ");
INSERT INTO turytc_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ve atalarımıza ant içerek söz verdiği ülkeyi bize vermek üzere bizi içeri getirmek için oradan çıkardı. ");
INSERT INTO turytc_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Yahve bize bütün bu kuralları tutmamızı, her zaman iyiliğimiz için Tanrımız Yahve'den korkmamızı ve bugün olduğu gibi biz sağ kalalım diye buyurdu. ");
INSERT INTO turytc_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Tanrımız Yahve'nin önünde tüm bu buyrukları O'nun bize buyurduğu gibi dikkatle yaparsak, bizim için doğru olacaktır.'' ");
INSERT INTO turytc_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Tanrın Yahve seni mülk olarak almak için gittiğin ülkeye götürüp önünüzden birçok ulusu - Hititler'i, Girgaşiler'i, Amorlular'ı, Kenanlılar'ı, Perizziler'i, Hivliler'i ve Yevuslular'ı - senden daha büyük ve senden daha güçlü yedi ulusu kovduğunda; ");
INSERT INTO turytc_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Tanrın Yahve onları önünde teslim ettiği ve onları vurduğunda, o zaman onları tümüyle yok edeceksin. Onlarla antlaşma yapmayacaksın ve onlara merhamet göstermeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Onlarla evlenmeyeceksin. Kızını onun oğluna vermeyeceksin, onun kızını da kendi oğluna almayacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Çünkü bu, oğullarını benim ardımca gitmekten saptırır ve başka ilahlara hizmet ederler. Böylece Yahve'nin öfkesi size karşı alevlenir ve sizi çabucak yok eder. ");
INSERT INTO turytc_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ancak onlara şöyle yapacaksın: Sunaklarını yıkacaksın, dikili taşlarını parçalayacaksın, Aşera putlarını keseceksin ve oyma putlarını ateşle yakacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Çünkü sen Tanrın Yahve'ye kutsal bir halksın. Tanrın Yahve, kendine ait halk olman için, yeryüzündeki bütün halkların üstünde seni seçti. ");
INSERT INTO turytc_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Yahve sizi sayıca bütün halklardan çok olduğunuz için sevip seçmedi; çünkü siz bütün halkların en az olanıydınız; ");
INSERT INTO turytc_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ama Yahve sizi sevdiğinden ve atalarınıza ettiği andı tutmak istediğinden, Yahve güçlü eliyle sizi Mısır'dan çıkardı ve esaret evinden, Mısır Kralı Firavun'un elinden kurtardı. ");
INSERT INTO turytc_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Bu nedenle şunu bil ki, Tanrın Yahve Tanrı'nın kendisidir, kendisini seven ve buyruklarını tutan bin kuşak boyunca antlaşmasını ve sevgi dolu iyiliğini koruyan, ");
INSERT INTO turytc_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ve kendisinden nefret edenleri yok etmek için yüzlerine karşılığını veren sadık Tanrı'dır. Kendisinden nefret edene karşı gevşeklik göstermez. Karşılığını yüzüne verecektir. ");
INSERT INTO turytc_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Bu nedenle, bugün sana buyurduğum buyrukları, kuralları ve ilkeleri tutacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Bu kuralları dinlediğiniz, tuttuğunuz ve onları yaptığınız için, Tanrın Yahve atalarına ettiği andı, antlaşmayı ve sevgi dolu iyiliğini senin için koruyacak. ");
INSERT INTO turytc_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","O seni sevecek, kutsayacak ve seni çoğaltacak. Sana vermek için atalarına ant içtiği ülkede bedeninin ürününü, toprağının ürününü, tahılını, yeni şarabını ve zeytin yağını, sığırlarının artışını, sürünün yavrularını da kutsayacak. ");
INSERT INTO turytc_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Bütün halklardan çok sen kutsanacaksın. Erkek yada kadın olsun sizin aranızda, hayvanlarınız arasında kısır olmayacak. ");
INSERT INTO turytc_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Yahve senden her hastalığı kaldıracak; ve Mısır'ın bildiğin kötü hastalıklarından hiçbirini senin üzerinize koymayacak, ancak senden nefret edenlerin hepsinin üzerine koyacak. ");
INSERT INTO turytc_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Tanrın Yahve'nin sana teslim edeceği bütün halkları tüketeceksin. Gözlerin onlara acımayacak. Onların ilâhlarına hizmet etmeyeceksin; çünkü bu sana tuzak olacaktır. ");
INSERT INTO turytc_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Yüreğinde, “Bu uluslar benden çoktur, onları nasıl mülksüz bırakabilirim?” dersen, ");
INSERT INTO turytc_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","onlardan korkmayacaksın. Tanrın Yahve'nin Firavun'a ve tüm Mısır'a yaptıklarını, ");
INSERT INTO turytc_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","gözlerinin gördüğü büyük denemeleri, belirtileri, harikaları, güçlü eli ve Tanrınız Yahve'nin seni oradan çıkarmak için uzanan kolunu iyi hatırlayacaksın. Tanrın Yahve korktuğunuz bütün halklara da öyle yapacaktır. ");
INSERT INTO turytc_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Üstelik Tanrın Yahve, geride kalanları ve gizlenenleri önünden yok oluncaya dek onların aralarına eşekarısı gönderecektir. ");
INSERT INTO turytc_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Onlardan korkmayacaksın; çünkü Tanrın Yahve, büyük ve heybetli bir Tanrı olarak arandadır. ");
INSERT INTO turytc_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Tanrın Yahve bu ulusları önünden azar azar kovacak. Onları hemen tüketemezsin, yoksa kır hayvanları senin üzerine çoğalır. ");
INSERT INTO turytc_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ama Tanrın Yahve onları önüne teslim edecek, yok oluncaya dek onları büyük bir şaşkınlıkla akıllarını karıştıracak. ");
INSERT INTO turytc_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Krallarını eline teslim edecek ve sen de onların adını gökyüzünün altından yok edeceksin. Sen onları yok edene kadar hiç kimse senin önünde duramayacak. ");
INSERT INTO turytc_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Onların ilâhlarının oyma putlarını ateşle yakacaksın. Üzerlerindeki gümüşe ya da altına göz dikmeyeceksin, ve onu kendine almayacaksın; yoksa onunla tuzağa düşersin. Çünkü bu, Tanrın Yahve'ye iğrenç bir şeydir. ");
INSERT INTO turytc_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Evine iğrenç bir şey getirmeyecek ve ona bağlanmayacaksın. Bundan kesinlikle nefret edeceksin. Ondan tamamen tiksineceksin; çünkü bu bağlılıkla ilgili bir şeydir. ");
INSERT INTO turytc_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Yaşayasın, çoğalasın ve Yahve'nin atalarınıza ant içerek söz verdiği ülkeye girip mülk edinebilesin diye bugün size buyurduğum bütün buyrukları tutacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Tanrın Yahve'nin seni alçaltmak, seni sınamak, O'nun buyruklarını tutacak mısın yoksa tutmayacak mısın diye yüreğinde olanı bilmek için bu kırk yıl boyunca çölde seni yürüttüğü bütün yolu hatırlayacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","O, seni alçalttı, aç kalmana izin verdi ve insanın yalnızca ekmekle yaşamadığını, Yahve'nin ağzından çıkan her sözle insanın yaşadığını sana öğretmek için senin bilmediğin, atalarının da bilmediği man ile seni doyurdu. ");
INSERT INTO turytc_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Bu kırk yıl, giysilerin eskimedi, ayağın da şişmedi. ");
INSERT INTO turytc_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Bir adam oğlunu nasıl terbiye ederse, Tanrın Yahve'nin de seni öyle terbiye etmekte olduğunu yüreğinde düşüneceksin. ");
INSERT INTO turytc_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Tanrın Yahve'nin yollarında yürümek ve O'ndan korkmak için O'nun buyruklarını tutacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Çünkü Tanrın Yahve seni güzel ülkeye, derelerin, pınarların, vadilerin ve tepelerin içine akan yer altı sularının diyarına; ");
INSERT INTO turytc_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","buğday, arpa, üzüm, incir ağaçları ve nar diyarı; zeytin ağaçları ve bal diyarına götürüyor; ");
INSERT INTO turytc_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","kıtlık çekmeden ekmek yiyeceğiniz bir ülke, orada hiçbir eksiğiniz olmayacak; taşları demir olan ve tepelerinden bakır çıkarabileceğiniz bir ülke. ");
INSERT INTO turytc_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Yiyip doyacaksın ve sana verdiği güzel ülke için Tanrın Yahve'yi yücelteceksin. ");
INSERT INTO turytc_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Bugün sana buyurmakta olduğum O'nun buyruklarını, kurallarını ve ilkelerini tutmayarak Tanrın Yahve'yi unutmaktan sakın; ");
INSERT INTO turytc_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","yiyip doyduğunda, güzel evler yapıp onlarda oturduğunda; ");
INSERT INTO turytc_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","sığırların ve davarların çoğaldığı, gümüşün ve altının çoğaldığı ve sahip olduğun her şey çoğaldığında; ");
INSERT INTO turytc_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","o zaman yüreğin yükselebilir ve seni Mısır diyarından, esaret evinden çıkaran; ");
INSERT INTO turytc_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","içinde zehirli yılanlar ve akreplerle dolu, susuz kurak toprağın bulunduğu o büyük ve korkunç çölde sana öncülük eden; çakmaktaşı kayadan sana su çıkaran; ");
INSERT INTO turytc_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","seni alçaltsın, ve sonunda sana iyilik etmek için seni denesin diye, atalarının bilmediği man ile çölde seni besleyen Tanrın Yahve'yi unutmayasın; ");
INSERT INTO turytc_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","sakın yüreğinde, “Bana bu serveti yapan benim kendi gücüm ve elimin kudretidir” demeyesin. ");
INSERT INTO turytc_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Ama Tanrın Yahve'yi hatırlayacaksın; çünkü atalarına ettiği andı bugün olduğu gibi pekiştirmek için sana servet kazanma gücünü veren O'dur. ");
INSERT INTO turytc_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Öyle olacak ki, eğer Tanrın Yahve'yi unutur ve başka ilâhların ardınca yürürsen, onlara hizmet edip onlara taparsan, bugün size tanıklık ederim ki, kesinlikle yok olacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Yahve'nin önünüzden yok ettiği uluslar gibi, siz de yok olacaksınız, çünkü Tanrınız Yahve'nin sözünü dinlemediniz. ");
INSERT INTO turytc_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Dinle, ey İsrael! Senden daha büyük ve güçlü ulusları, büyük uzun boylu bir halkı, ");
INSERT INTO turytc_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","bildiğin ve hakkında: “Anak'ın oğullarının önünde kim durabilir?” dendiğini duyduğun Anakim'in oğullarını, büyük ve gökyüzüne kadar uzanan surlu kentleri mülksüz bırakmak üzere bugün Yarden'den geçeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Bu nedenle bugün şunu bil ki, önünden yiyip bitiren bir ateş gibi geçen Tanrın Yahve'dir. Onları yok edecek ve senin önünde onlara boyun eğdirecektir. Bu yüzden Yahve'nin sana söylediği gibi onları kovacaksın ve onları tez zamanda yok edeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Tanrın Yahve onları önünden attıktan sonra, yüreğinden, “Doğruluğumdan dolayı Yahve beni bu ülkeye mülk edinmek için getirdi” deme; çünkü bu ulusların kötülükleri yüzünden Yahve onları önünden kovuyor. ");
INSERT INTO turytc_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Onların topraklarını mülk edinmek için doğruluğun ya da yüreğinin doğruluğu için girmiyorsun; ancak bu ulusların kötülüğünden dolayı, ve Yahve'nin atalarına, Avraham'a, İshak'a ve Yakov'a ant içtiği sözü pekiştirmek için Tanrın Yahve onları önünden kovuyor. ");
INSERT INTO turytc_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Bunun için şunu bil ki, Tanrın Yahve bu güzel ülkeyi, doğruluğundan dolayı sana mülk edinmen için vermiyor; çünkü sen sert enseli bir halksın. ");
INSERT INTO turytc_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Tanrın Yahve'yi çölde nasıl öfkelendirdiğini hatırla ve unutma. Mısır diyarından ayrıldığın günden bu yere gelinceye kadar Yahve'ye karşı isyankâr oldunuz. ");
INSERT INTO turytc_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Horev'de de Yahve'yi öfkelendirdiniz ve Yahve sizi yok etmek için gazaba geldi. ");
INSERT INTO turytc_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Taş levhaları, Yahve'nin sizinle yaptığı antlaşmanın levhalarını almak için dağa çıktığımda kırk gün kırk gece dağda kaldım. Ne ekmek yedim ne de su içtim. ");
INSERT INTO turytc_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Yahve Tanrı'nın parmağıyla yazılmış iki taş levhayı bana teslim etti. Toplantı gününde Yahve'nin dağda ateşin içinden size söylediği bütün sözler onların üzerindeydi. ");
INSERT INTO turytc_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kırk gün kırk gecenin sonunda Yahve bana iki taş levhayı, antlaşma levhalarını verdi. ");
INSERT INTO turytc_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Yahve bana şöyle dedi: “Kalk, buradan çabuk in; çünkü Mısır'dan çıkardığın halkın kendilerini bozdular. Onlara buyurduğum yoldan hemen saptılar. Kendilerine dökme bir suret yaptılar!” ");
INSERT INTO turytc_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Bundan başka Yahve benimle konuşup şöyle dedi: “Bu insanları gördüm ve işte onlar sert enseli bir halktır. ");
INSERT INTO turytc_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Beni bırak da onları yok edeyim, adlarını gökyüzünün altından sileyim; seni de onlardan daha kudretli ve daha büyük bir ulus yapacağım.” ");
INSERT INTO turytc_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Bunun üzerine dönüp dağdan indim; dağ ateşle yanıyordu. Antlaşmanın iki levhası iki elimdeydi. ");
INSERT INTO turytc_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","İşte, Tanrınız Yahve'ye karşı günah işlemiş olduğunuzu gördüm. Kendinize dökme bir buzağı yapmıştınız. Yahve'nin size buyurduğu yoldan çabucak sapmıştınız. ");
INSERT INTO turytc_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","İki levhayı alıp iki elimden attım ve onları gözünüzün önünde kırdım. ");
INSERT INTO turytc_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","İlk seferki gibi kırk gün kırk gece Yahve'nin önünde yere kapandım. Yahve'yi öfkelendirmek için gözünde kötü olanı yaparak işlediğiniz bütün günahtan dolayı ne ekmek yedim, ne de su içtim. ");
INSERT INTO turytc_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Çünkü Yahve'nin sizi yok etmek için size öfkelenmesinden ve kızgın hoşnutsuzluğundan korkuyordum. Ama Yahve o zaman da beni dinledi. ");
INSERT INTO turytc_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Yahve Aron'u yok edecek kadar öfkeliydi. Aynı zamanda Aron için de dua ettim. ");
INSERT INTO turytc_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Günahınızı, yaptığınız buzağıyı alıp ateşle yaktım ve onu parçaladım ve toz haline gelinceye kadar onu iyice ezdim. Tozunu dağdan inen dereye attım. ");
INSERT INTO turytc_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Tabera'da, Massa'da ve Kivrot Hattaava'da Yahve'yi öfkelendirdiniz. ");
INSERT INTO turytc_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Yahve, “Gidin, size verdiğim ülkeyi mülk edinin” diyerek sizi Kadeş-Barnea'dan gönderdiği zaman, Tanrınız Yahve'nin buyruğuna karşı isyan ettiniz, O'na inanmadınız, O'nun sözünü dinlemediniz. ");
INSERT INTO turytc_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Sizi tanıdığım günden beri Yahve'ye karşı isyankâr oldunuz. ");
INSERT INTO turytc_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Böylece kırk gün kırk gece Yahve'nin önünde yere kapandım, çünkü Yahve sizi yok edeceğini söylemişti. ");
INSERT INTO turytc_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Yahve'ye dua edip şöyle dedim: “Efendim Yahve, halkını, büyüklüğünle kurtardığın, güçlü elle Mısır'dan çıkardığın mirasını yok etme. ");
INSERT INTO turytc_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Hizmetkârların Avraham'ı, İshak'ı ve Yakov'u hatırla. Bu halkın inatçılığına, kötülüğüne, günahına bakma, ");
INSERT INTO turytc_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","yoksa bizi çıkardığın ülke, 'Çünkü Yahve onları kendilerine vaat ettiği ülkeye götüremedi ve onlardan nefret ettiği için onları çölde öldürmek üzere çıkardı.' demesin. ");
INSERT INTO turytc_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Ama onlar senin halkındır ve senin büyük gücünle ve uzanmış kolunla çıkardığın mirasındır.” ");
INSERT INTO turytc_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","O sırada Yahve bana şöyle dedi: “İlki gibi iki taş levha kes, dağa yanıma çık ve ağaçtan bir sandık yap. ");
INSERT INTO turytc_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Kırdığın önceki levhaların üzerindeki sözleri bu levhaların üzerine yazacağım ve onları sandığa koyacaksın.” ");
INSERT INTO turytc_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Akasya ağacından bir sandık yaptım, ilki gibi iki taş levha kestim ve elimde iki levhayla dağa çıktım. ");
INSERT INTO turytc_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Toplantı gününde Yahve'nin dağda ateşin içinden size söylediği On Buyruk'u önceki yazıya göre levhaların üzerine yazdı; ve Yahve onları bana verdi. ");
INSERT INTO turytc_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Dönüp dağdan indim ve levhaları yapmış olduğum sandığa koydum; ve onlar Yahve'nin bana buyurduğu gibi oradalar. ");
INSERT INTO turytc_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(İsrael'in çocukları Beerot Bene Yaakan'dan Moseray'a gittiler. Orada Aron öldü ve orada gömüldü; ve oğlu Eleazar onun yerine kâhinlik makamında hizmet etti. ");
INSERT INTO turytc_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Oradan Gudgoda'ya ve Gudgoda'dan Yotvata'ya gittiler. ");
INSERT INTO turytc_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","O sırada Yahve, Levi oymağını, Yahve'nin Antlaşma Sandığı'nı taşımaları, bugüne dek Yahve'nin önünde durup O'na hizmet etmeleri ve O'nun adıyla kutsamaları için ayırmıştı. ");
INSERT INTO turytc_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Bu nedenle Levi'nin kardeşleri ile payı ve mirası yoktur. Tanrın Yahve'nin ona söylediği gibi, Yahve onun mirasıdır.) ");
INSERT INTO turytc_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","İlk seferinde olduğu gibi kırk gün kırk gece dağda kaldım; Yahve o zaman da beni dinledi. Yahve seni yok etmeyecekti. ");
INSERT INTO turytc_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Yahve bana şöyle dedi: “Kalk, halkın önünde yola çık; ve onlara vermek üzere atalarına ant içtiğim diyara girecekler ve onu mülk edinecekler.” ");
INSERT INTO turytc_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Şimdi, ey İsrael, Tanrın Yahve'den korkmaktan, O'nun bütün yollarında yürümekten, O'nu sevmekten, Tanrın Yahve'ye bütün yüreğinle, bütün canınla hizmet etmekten, ");
INSERT INTO turytc_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","bugün iyiliğin için sana buyurmakta olduğum Yahve'nin buyrukları ve kurallarını tutmaktan başka, Tanrın Yahve senden ne ister? ");
INSERT INTO turytc_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","İşte, gökler, göklerin göğü, yeryüzü ve içindeki her şey Tanrın Yahve'ye aittir. ");
INSERT INTO turytc_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Yalnız Yahve atalarınızı sevmekten hoşlandı ve onlardan sonra soylarını, bugün olduğu gibi sizi bütün halkların üstünde seçti. ");
INSERT INTO turytc_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Bu nedenle yüreğinizin sünnet derisini sünnet edin ve artık sert enseli olmayın. ");
INSERT INTO turytc_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Tanrınız Yahve, ilâhların Tanrısı, efendilerin Efendi'si, büyük, güçlü ve heybetli Tanrı'dır, insanları kayırmaz ve rüşvet almaz. ");
INSERT INTO turytc_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Yetimin ve dulun hakkını verir, yabancıyı yiyecek ve giyecek vererek onu sever. ");
INSERT INTO turytc_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Bu nedenle yabancıyı sevin; çünkü siz de Mısır diyarında yabancıydınız. ");
INSERT INTO turytc_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Tanrın Yahve'den korkacaksın. O'na hizmet edeceksin. O'na bağlanacaksın ve O'nun adıyla ant içeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Gözlerinin gördüğü bu büyük ve heybetli şeyleri senin için yapan Tanrın'dır, O senin övgündür. ");
INSERT INTO turytc_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Ataların yetmiş kişiyle birlikte Mısır'a indiler; ve şimdi Tanrın Yahve seni kalabalıkta gökyüzünün yıldızları gibi yaptı. ");
INSERT INTO turytc_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Bu nedenle Tanrın Yahve'yi seveceksin ve O'nun uyarılarını, kurallarını, ilkelerini ve buyruklarını her zaman tutacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Bugün bilin; çünkü Tanrınız Yahve'nin yola getirişini, büyüklüğünü, kudretli elini, uzanmış kolunu, belirtileri ve yaptığı işleri bilmeyen ve görmeyen çocuklarınızla konuşmuyorum. ");
INSERT INTO turytc_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Mısır'ın ortasında Mısır Kralı Firavun'a ve onun bütün ülkesine yaptığını; ");
INSERT INTO turytc_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Mısır ordusuna, atlarına ve savaş arabalarına ne yaptığını; onlar sizi kovalarken Kızıldeniz'in sularını nasıl onların üzerine taştırdığını ve Yahve'nin onları bugüne kadar nasıl yok ettiğini; ");
INSERT INTO turytc_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ve siz bu yere gelinceye kadar çölde size ne yaptığını; ");
INSERT INTO turytc_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Ruven oğlu Eliav'ın oğulları Datan ve Aviram'a ne yaptığını; bütün İsrael'in ortasında yerin ağzını açıp onları, ev halklarını, çadırlarını ve onların ardından giden her canlı şeyi nasıl yuttuğunu; ");
INSERT INTO turytc_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ama sizin gözleriniz Yahve'nin yaptığı büyük işlerin hepsini gördü. ");
INSERT INTO turytc_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Bu nedenle, güçlü olmanız ve mülk edinmek için gitmekte olduğunuz diyara girip onu mülk edinmeniz için bugün size buyurmakta olduğum buyruğun tamamını tutacaksın; ");
INSERT INTO turytc_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","öyle ki, Yahve'nin atalarınıza ve onların soyuna vermek için ant içtiği süt ve bal akan diyarda günleriniz uzun olsun. ");
INSERT INTO turytc_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Çünkü mülk edinmek için girmekte olduğun ülke, tohum ektiğin ve ayağınla suladığın, çıktığın Mısır ülkesine, sebze bahçesine benzemez; ");
INSERT INTO turytc_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ama mülk edinmek için geçmekte olduğun diyar, gökten gelen yağmurdan su içen, tepeler ve vadilerle dolu bir ülkedir; ");
INSERT INTO turytc_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Tanrın Yahve'nin ilgilendiği bir ülkedir. Tanrın Yahve'nin gözleri, yılın başından sonuna dek her zaman onun üzerindedir. ");
INSERT INTO turytc_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Eğer Tanrın Yahve'yi sevmek ve O'na bütün yüreğinle, bütün canınla hizmet etmek için bugün size buyurmakta olduğum buyruklarımı özenle dinlerseniz, öyle olacak ki, ");
INSERT INTO turytc_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","tahılını, yeni şarabını ve yağını toplayasın diye diyarınızın yağmurunu, ilk yağmur ve son yağmuru mevsiminde vereceğim. ");
INSERT INTO turytc_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Tarlalarında hayvanların için ot vereceğim; sen de yiyip doyacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Dikkatli olun, yüreğiniz aldanmasın ve başka ilahlara hizmet etmek için sapmayasınız ve onlara tapmayasınız; ");
INSERT INTO turytc_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ve Yahve'nin öfkesi size karşı alevlenmesin; yağmur yağmasın ve toprak ürününü vermesin diye gökyüzünü kapatmasın; ve Yahve'nin size vermekte olduğu güzel ülkede çabucak yok olmayasınız. ");
INSERT INTO turytc_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Bu nedenle bu sözlerimi yüreğinize ve canınıza koyacaksınız. Onları elinize işaret olarak bağlayacaksınız ve gözlerinizin arasında alın bağı olacaklar. ");
INSERT INTO turytc_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Evinde oturduğunda, yolda yürürken, yattığında ve kalktığında onlardan söz edecek bunları çocuklarına öğreteceksin. ");
INSERT INTO turytc_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Onları evinin kapı sövelerine ve kapılarının üzerine yazacaksın; ");
INSERT INTO turytc_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","öyle ki, Yahve'nin atalarınıza vermek için ant içtiği o ülkede sizin ve çocuklarınızın günleri, yerin üzerindeki göklerin günleri gibi çoğalsın. ");
INSERT INTO turytc_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Çünkü size buyurduğum bütün bu buyrukları yapmak için, Tanrınız Yahve'yi sevmek, O'nun bütün yollarında yürümek ve O'na yapışmak için onu özenle tutarsanız, ");
INSERT INTO turytc_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","o zaman Yahve bütün bu ulusları önünüzden kovacak ve sizden daha büyük ve daha güçlü ulusları mülksüz bırakacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Ayak tabanınızın bastığı her yer sizin olacak; sınırınız çölden ve Lübnan'dan, ırmaktan, Fırat Nehri'nden batı denizine kadar olacak. ");
INSERT INTO turytc_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Hiç kimse önünüzde duramayacak. Tanrınız Yahve, size söylediği gibi, bastığınız bütün diyara sizin korkunuzu ve dehşetinizi koyacak. ");
INSERT INTO turytc_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","İşte, bugün önünüze bereketi ve laneti koyuyorum: ");
INSERT INTO turytc_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Eğer bugün size buyurmakta olduğum Tanrınız Yahve'nin buyruklarını dinlerseniz, bereket; ");
INSERT INTO turytc_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ve eğer Tanrınız Yahve'nin buyruklarını dinlemezseniz ve bugün size buyurduğum yoldan sapıp, bilmediğiniz başka ilâhların ardınca giderseniz, lanet. ");
INSERT INTO turytc_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Tanrın Yahve seni mülk edinmek için gitmekte olduğun ülkeye getirdiğinde, bereketi Gerizim Dağı üzerine, laneti ise Eval Dağı üzerine koyacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Onlar Yarden'in ötesinde, güneşin battığı yolun arkasında, Gilgal yakınındaki Arava'da, Moreh Meşeliği yanında oturan Kenanlılar'ın ülkesinde değiller mi? ");
INSERT INTO turytc_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Çünkü Tanrınız Yahve'nin size vermekte olduğu ülkeyi mülk edinmek için Yarden'i geçeceksiniz; onu mülk edinecek ve orada oturacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Bugün önünüze koymakta olduğum bütün kuralları ve ilkeleri yapmaya dikkat edeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Atalarınızın Tanrısı Yahve'nin, yeryüzünde yaşayacağınız bütün günler boyunca size mülk olarak verdiği ülkede dikkatle yapacağınız kurallar ve ilkeler bunlardır. ");
INSERT INTO turytc_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Mülksüz bırakacağınız ulusların ilâhlarına tapındıkları bütün yerleri, yüksek dağları, tepeleri ve her yeşil ağacın altını kesinlikle yok edeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Onların sunaklarını yıkacaksın, dikili taşlarını parçalayacaksın, Aşera putlarını ateşle yakacaksın. Onların ilâhlarının oyma putlarını keseceksin. Adlarını o yerden yok edeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Tanrınız Yahve'ye böyle yapmayacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Ama Tanrınız Yahve'nin adını yerleştirmek için bütün oymaklarınız arasından seçeceği yere, O'nun konutunu arayacaksınız ve oraya geleceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Yakmalık sunularınızı, kurbanlarınızı, ondalıklarınızı, sallama sunusunu, adaklarınızı, gönüllü sunularınızı, sığırlarınızın ve sürünüzün ilk doğanlarını oraya getireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Orada Tanrınız Yahve'nin önünde yiyeceksiniz; siz ve ev halkınız elinizi attığınız ve Tanrınız Yahve'nin sizi kutsadığı her şeyde sevineceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Bugün burada bizim yaptığımız her şeye göre yapmayacaksınız, herkes kendi gözünde doğru olanı yapmakta; ");
INSERT INTO turytc_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","çünkü dinlenmeye ve Tanrınız Yahve'nin size vermekte olduğu mirasa henüz girmediniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Ama Yarden'in ötesine geçip Tanrınız Yahve'nin size miras olarak vereceği ülkede oturduğunuzda ve güvenlik içinde oturmak üzere çevrenizdeki tüm düşmanlarınızdan size rahat verdiğinde, ");
INSERT INTO turytc_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","o zaman öyle olacak ki, Tanrınız Yahve'nin kendi adına konut olarak seçeceği yere, size buyurduğum her şeyi, yakmalık sunularınızı, kurbanlarınızı, ondalıklarınızı, elinizdeki sallama sunusunu ve Yahve'ye adadığınız bütün seçme adaklarınızı oraya getireceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Tanrınız Yahve'nin önünde, siz, oğullarınız, kızlarınız, erkek hizmetçileriniz, kadın hizmetçileriniz ve kapılarınızda olan Levili sevineceksiniz; çünkü Levili'nin sizinle hiç payı ve mirası yoktur. ");
INSERT INTO turytc_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Yakmalık sunularını gördüğün her yerde sunmamaya dikkat et; ");
INSERT INTO turytc_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ancak Yahve'nin oymaklarının birinde seçeceği yerde yakmalık sunularını orada sunacaksın ve sana buyurmakta olduğum her şeyi orada yapacaksın. ");
INSERT INTO turytc_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Yine de, Tanrın Yahve'nin sana verdiği berekete göre, canının dilediği her ne ise, bütün kapılarında kesebilir ve et yiyebilirsin. Ceylan ve geyik gibi, kirli ve temiz olanlar da ondan yiyebilir. ");
INSERT INTO turytc_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Yalnız kanını yemeyeceksin. Onu su gibi yere dökeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Tahılının, yeni şarabının, yağının ondalığını, sığırlarının ya da sürülerinin ilk doğanlarını, adadığın adakların hiçbirini ya da gönülden verdiğin sunuları ve elinin sallama sunusunu kapılarında yiyemezsin; ");
INSERT INTO turytc_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ama onları sen, oğlun, kızın, erkek hizmetçin, kadın hizmetçin ve kapılarında olan Levili, Tanrınız Yahve'nin önünde, Tanrın Yahve'nin seçeceği yerde yiyeceksin. El attığın her şeyde Tanrın Yahve'nin önünde sevineceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Ülkende yaşadığın sürece Levililer'i yalnız bırakmamaya dikkat et. ");
INSERT INTO turytc_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Tanrın Yahve, sana verdiği söz uyarınca sınırını genişlettiğinde ve canın et yemek istediğinde, “Et yemek istiyorum” dersen, canının her arzusuna göre et yiyebilirsin. ");
INSERT INTO turytc_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Tanrın Yahve'nin adını koymak için seçeceği yer senden çok uzaksa, o zaman Yahve'nin sana verdiği sığırlarını ve sürülerini sana buyurduğum gibi keseceksin ve canının bütün arzusuna göre kapılarında yiyebilirsin. ");
INSERT INTO turytc_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Ceylan ve geyik nasıl yenirse, sen de ondan öyle yiyeceksin. Kirli ve temiz olan ondan aynı şekilde yiyebilir. ");
INSERT INTO turytc_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Yalnız kan yemediğinden emin ol; çünkü kan yaşamdır. Yaşamı etle birlikte yemeyeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Onu yemeyeceksin. Onu su gibi yere dökeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Yahve'nin gözünde doğru olanı yaptığında, sana ve senden sonra çocuklarına iyilik olsun diye onu yemeyeceksiniz. ");
INSERT INTO turytc_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Yalnızca kutsal şeylerini ve adaklarını alıp Yahve'nin seçeceği yere gideceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Yakmalık sunularını, etini ve kanını Tanrın Yahve'nin sunağı üzerinde sunacaksın. Kurbanlarının kanı Tanrın Yahve'nin sunağı üzerine dökülecek ve eti yiyeceksin. ");
INSERT INTO turytc_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Tanrın Yahve'nin gözünde iyi ve doğru olanı yaptığında, senin ve senden sonra çocukların daima iyilik olsun diye, sana buyurmakta olduğum bütün bu sözleri tut ve dinle. ");
INSERT INTO turytc_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Tanrın Yahve, mülklerinden etmek için gitmekte olduğun ulusları önünden kesip attığında ve sen onları mülklerinden edip ülkelerinde oturduğunda, ");
INSERT INTO turytc_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","dikkatli ol, onlar önünden yok edildikten sonra onları takip ederek tuzağa düşme “Bu uluslar kendi ilâhlarına nasıl hizmet ediyorlar ben de öyle yapacağım” diye onların ilâhlarını arama. ");
INSERT INTO turytc_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Tanrın Yahve'ye böyle yapmayacaksın; Yahve'nin nefret ettiği her iğrençliği kendi ilâhlarına yaptılar; çünkü oğullarını ve kızlarını bile ateşte kendi ilâhlarına yakarlar. ");
INSERT INTO turytc_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Sana ne buyurduysam onu dikkatle yapacaksın. Ona ne bir şey ekleyeceksin, ne de ondan bir şey eksilteceksin. ");
INSERT INTO turytc_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Eğer aranızda bir peygamber ya da rüya gören biri çıkar ve size bir belirti ya da şaşılacak bir şey verirse, ");
INSERT INTO turytc_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ve bilmediğiniz “Başka ilâhların ardınca gidelim ve onlara hizmet edelim” der ve size söylediği belirti ya da şaşılacak şey gerçekleşirse, ");
INSERT INTO turytc_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","o peygamberin ya da o rüya görenin sözlerini dinlemeyeceksin; çünkü Tanrınız Yahve, Tanrınız Yahve'yi bütün yüreğinizle, bütün canınızla sevip sevmediğinizi bilmek için sizi sınıyor. ");
INSERT INTO turytc_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Tanrınız Yahve'nin ardından yürüyeceksiniz, O'ndan korkacaksınız, O'nun buyruklarını tutacaksınız ve O'nun sözünü dinleyeceksiniz. O'na hizmet edeceksiniz ve O'na yapışacaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","O peygamber ya da o rüya gören, Tanrınız Yahve'nin size yürümenizi buyurduğu yoldan çıkarmak için, sizi Mısır diyarından çıkaran, esaret evinden kurtaran Tanrınız Yahve'ye karşı başkaldırı konuştuğu için öldürülecektir. Böylece kötülüğü aranızdan kaldıracaksınız. ");
INSERT INTO turytc_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Eğer erkek kardeşin, annenin oğlu, kendi oğlun, kızın, ya da koynundaki karın ya da can dostun, seni gizlice ayartırsa, senin ve atalarının bilmediği; ");
INSERT INTO turytc_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","dünyanın bir ucundan öbür ucuna kadar çevrenizde, yakınınızda ya da senden uzakta olan halkların ilâhları hakkında; “Gidip başka ilahlara hizmet edelim” derse; ");
INSERT INTO turytc_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ona razı olmayacak, onu dinlemeyeceksin; gözün ona acımayacak, onu esirgemeyeceksin, onu gizlemeyeceksin; ");
INSERT INTO turytc_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","ancak onu kesinlikle öldüreceksin. Onu öldürmek için ilk önce senin elin, sonra da bütün halkın eli onun üzerinde olacak. ");
INSERT INTO turytc_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Onu taşlarla taşlayarak öldüreceksin; çünkü o, seni Mısır diyarından, esaret evinden çıkaran Tanrın Yahve'den uzaklaştırmaya çalıştı. ");
INSERT INTO turytc_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Bütün İsrael bunu duyup korkacak ve aranızda bunun gibi bir kötülük y