﻿USE sofia;
DROP TABLE IF EXISTS sofia.turobt_vpl;
CREATE TABLE turobt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES turobt_vpl WRITE;
INSERT INTO turobt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","İbrahimʼin ve Davudʼun soyundan gelen İsa Mesihʼin soy kaydı şöyledir: ");
INSERT INTO turobt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","İbrahim, İshakʼın babasıydı. İshak, Yakubʼun babasıydı. Yakub, Yahuda ve kardeşlerinin babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda, Tamarʼdan doğan Peres ve Zerahʼın babasıydı. Peres, Hesronʼun babasıydı. Hesron, Ramʼın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, Amminadavʼın babasıydı. Amminadav, Nahşonʼun babasıydı. Nahşon, Salmonʼun babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Rahav tarafından Boazʼın babasıydı. Boaz, Rut tarafından Ovedʼin babasıydı. Oved, İşayʼın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","İşay, Kral Davudʼun babasıydı. Davud, Uriyaʼnın karısından doğan Süleymanʼın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Süleyman, Rehavamʼın babasıydı. Rehavam, Aviyaʼnın babasıydı. Aviya, Asaʼnın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, Yehoşafatʼın babasıydı. Yehoşafat, Yehoramʼın babasıydı. Yehoram, Uzziyaʼnın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziya, Yotamʼın babasıydı. Yotam, Ahazʼın babasıydı. Ahaz, Hizkiyaʼnın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkiya, Manaşeʼnin babasıydı. Manaşe, Amonʼun babasıydı. Amon, Yoşiyaʼnın babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yoşiya, Yekonya ve kardeşlerinin babasıydı. Bunlar, İsrail halkının Babilʼe sürüldüğü zaman doğdular. ");
INSERT INTO turobt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yekonya, halk Babilʼe sürüldükten sonra doğan Şealtiyelʼin babasıydı. Şealtiyel, Zerubbabilʼin babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabil, Avihudʼun babasıydı. Avihud, Elyakimʼin babasıydı. Elyakim, Azorʼun babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, Sadokʼun babasıydı. Sadok, Ahimʼin babasıydı. Ahim, Elihudʼun babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud, Elazarʼın babasıydı. Elazar, Mattanʼın babasıydı. Mattan, Yakubʼun babasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub, Meryemʼin kocası olan Yusufʼun babasıydı. Meryemʼden Mesih diye bilinen İsa doğdu. ");
INSERT INTO turobt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Böylece İbrahimʼden Davudʼa kadar on dört kuşak, Davudʼdan İsrail halkının Babilʼe sürüldüğü zamana kadar da on dört kuşak vardır. Halkın Babilʼe sürüldüğü zamandan Mesihʼe kadar yine on dört kuşak vardır. ");
INSERT INTO turobt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","İsa Mesihʼin doğması şöyle oldu: Oʼnun annesi Meryem, Yusufʼla nişanlıydı. Onlar birleşmeden önce Meryemʼin Kutsal Ruhʼtan gebe olduğu anlaşıldı. ");
INSERT INTO turobt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Meryemʼin nişanlısı Yusuf iyi bir adamdı. Meryemʼi halkın gözünde rezil etmek istemedi. Bunun için nişanı sessizce bozmak niyetindeydi. ");
INSERT INTO turobt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yusuf tam bunu düşünürken, Rabbin bir meleği ona rüyada göründü. Ona, “Ey Davud oğlu Yusuf” dedi. “Meryemʼi karın olarak yanına almaktan korkma. Çünkü ondaki bebek Kutsal Ruhʼtandır. ");
INSERT INTO turobt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O bir oğul doğuracak. Adını İsa koyacaksın. Çünkü halkını günahlarından O kurtaracak.” ");
INSERT INTO turobt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bütün bunlar, Rabbin peygamber aracılığıyla söylediği şu söz yerine gelsin diye oldu: ");
INSERT INTO turobt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“İşte bakire kız gebe kalacak, bir oğul doğuracak. Oʼnun adını İmmanuel koyacaksınız.” İmmanuel, “Allah bizimle” demektir. ");
INSERT INTO turobt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf uykudan kalkınca, Rabbin meleğinin ona buyurduğu gibi yaptı. Meryemʼi karısı olarak yanına aldı. ");
INSERT INTO turobt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama Meryem oğlunu doğurana kadar Yusuf onunla birleşmedi. Çocuğun adını İsa koydu. ");
INSERT INTO turobt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","İsa, Kral Hirodesʼin zamanında, Yahudiyeʼdeki Beytlehem kasabasında doğdu. Bundan sonra yıldızbilimciler doğudan Yeruşalim şehrine geldiler. ");
INSERT INTO turobt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Şunu sordular: “Yahudilerin Kralı olarak doğan çocuk nerede? Çünkü onun yıldızının yükseldiğini gördük ve yere kapanarak ona saygı göstermeye geldik.” ");
INSERT INTO turobt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bunu işitince, Kral Hirodes ve onunla birlikte bütün Yeruşalim halkı telaşa düştü. ");
INSERT INTO turobt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kral bütün başrahipleri ve halkın Tevrat uzmanlarını bir araya topladı. Onlardan Mesihʼin nerede doğacağını öğrenmek istedi. ");
INSERT INTO turobt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Krala şunu söylediler: “Yahudiyeʼdeki Beytlehem kasabasında. Çünkü peygamber aracılığıyla şöyle yazılmıştır: ");
INSERT INTO turobt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sen, Yahuda topraklarında bulunan Beytlehem, Yahuda liderleri arasında en önemsiz kasaba değilsin. Çünkü halkım İsrailoğullarını güdecek lider senden çıkacak.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ondan sonra Hirodes gizlice yıldızbilimcileri çağırdı. Yıldızın onlara tam olarak ne zaman göründüğünü sordu. ");
INSERT INTO turobt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sonra onları Beytlehemʼe gönderirken şunları söyledi: “Oraya varınca çocuğu dikkatle arayın. Bulduktan sonra bana haber yollayın. Ben de gelip yere kapanarak ona saygı göstereyim.” ");
INSERT INTO turobt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yıldızbilimcileri kralı dinledikten sonra yola çıktılar. Yükselişini gördükleri aynı yıldız onların önünden gitti. En sonunda çocuğun bulunduğu evin üstünde durdu. ");
INSERT INTO turobt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yıldızı görünce olağanüstü büyük bir sevinç duydular. ");
INSERT INTO turobt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eve girip çocuğu ve annesi Meryemʼi gördüler. Yere kapanıp çocuğa saygı gösterdiler. Sandıklarını açıp Oʼna hediyeler verdiler. Bunlar altın ve günnük ile mür denen değerli kokulardı. ");
INSERT INTO turobt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Allah onları bir rüyada Hirodesʼin yanına dönmemeleri için uyardı. Bu sebeple memleketlerine başka yoldan döndüler. ");
INSERT INTO turobt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yıldızbilimciler gittikten sonra, Rabbin bir meleği rüyada Yusufʼa göründü ve ona şöyle dedi: “Kalk, çocuğu ve annesini al. Mısırʼa kaç. Ben sana haber verene kadar orada kal. Çünkü Hirodes bu çocuğu öldürmek istiyor. Yakın zamanda onu aramak için adamlar gönderecek.” ");
INSERT INTO turobt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuf geceleyin kalkıp çocuğu ve annesini aldı ve Mısırʼa gitmek için yola çıktı. ");
INSERT INTO turobt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hirodes ölünceye kadar orada kaldı. Böylece Rabbin, peygamberin ağzıyla söylediği şu söz yerine geldi: “Oğlumu Mısırʼdan geri çağırdım.” ");
INSERT INTO turobt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hirodes yıldızbilimcilerin onu aldattığını anlayınca, öfkeden kudurdu. Kral çocuğun doğduğu zamanı yıldızbilimcilerden öğrenmişti. Bu yüzden hemen askerler gönderip Beytlehem ve çevresindeki köylerde iki yaşından küçük bütün erkek çocukları öldürttü. ");
INSERT INTO turobt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Böylece Allahʼın Yeremya Peygamberʼin ağzıyla söylediği şu söz yerine gelmiş oldu: ");
INSERT INTO turobt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramaʼda bir ses işitildi, ağlama ve acı bir feryat sesi. Rahel, çocukları için ağlıyor. Avutulmak istemiyor, çünkü onlar yok oldular.” ");
INSERT INTO turobt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hirodes öldükten sonra Rabbin bir meleği Yusufʼa rüyada göründü. Yusuf daha Mısırʼdaydı. ");
INSERT INTO turobt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Melek ona şöyle dedi: “Kalk, çocuğu ve annesini al ve İsrail topraklarına dön. Çünkü çocuğun canını almak isteyenler öldü.” ");
INSERT INTO turobt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf kalktı, çocuğu ve annesini aldı ve İsrail topraklarına döndü. ");
INSERT INTO turobt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama Hirodesʼin yerine oğlu Arhelasʼın Yahudiye kralı olduğunu işitti. O zaman Yusuf oraya dönmeye korktu. Allah tarafından bir rüyada uyarılınca, Celile topraklarına çekildi. ");
INSERT INTO turobt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Gidip Nasıra denilen bir kasabaya yerleşti. Böylece peygamberlerin aracılığıyla söylenen “Oʼna Nasıralı diyecekler” sözü yerine geldi. ");
INSERT INTO turobt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bir süre sonra Vaftizci Yahya Yahudiyeʼnin ıssız yerlerine gidip vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Şöyle diyordu: “Tövbe edin, çünkü Göklerin Krallığı yaklaştı.” ");
INSERT INTO turobt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Allahʼın Peygamber Yeşaya aracılığıyla haber verdiği kişi Yahyaʼdır. Yeşaya şöyle demişti: “Issız yerlerde sesini yükselten biri, ‘Rabbin yolunu hazırlayın, geçeceği yerleri düz yapın!’ diyor.” ");
INSERT INTO turobt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahya deve tüyünden elbise giyerdi ve belinde deriden bir kayış vardı. Yemek olarak çekirge ve yaban balı yerdi. ");
INSERT INTO turobt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","O vakit Yeruşalimʼden bütün Yahudiyeʼden ve Şeria ırmağının çevresinden halk ona akın etti. ");
INSERT INTO turobt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Onlar günahlarını açıkça söyleyip Yahyaʼnın eliyle Şeria ırmağında vaftiz oldular. ");
INSERT INTO turobt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ferisilerden ve Sadukilerden de bir sürü kişi vaftiz olmak için Yahyaʼya geldi. Yahya bunu görünce onlara şöyle dedi: “Ey yılan soyu! Allahʼın vereceği cezadan kaçabileceğinizi kim söyledi? ");
INSERT INTO turobt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bunun için tövbenize layık meyve verin. ");
INSERT INTO turobt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kendi kendinize, ‘Atamız İbrahimʼdir’ demeye kalkmayın. Ben size diyorum ki, Allah şu taşlardan bile İbrahimʼe çocuklar yaratabilecek güçtedir. ");
INSERT INTO turobt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Balta artık ağaçların köküne dayandı. İyi meyve vermeyen her ağaç kesilip ateşe atılacak. ");
INSERT INTO turobt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tövbe edesiniz diye ben sizi suyla vaftiz ediyorum. Ama benden sonra gelen benden daha güçlü. Ben Oʼnun ayaklarından sandaletlerini çıkarmaya layık değilim. O sizi Kutsal Ruhʼla ve ateşle vaftiz edecek. ");
INSERT INTO turobt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Küreği elindedir. O kürekle harman yerini temizleyip buğdayını ambara toplayacak. Ama samanı hiç sönmeyen ateşle yakacak.” ");
INSERT INTO turobt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","O sırada İsa Celile bölgesinden Şeria ırmağına, Yahyaʼnın yanına, onun eliyle vaftiz olmak için geldi. ");
INSERT INTO turobt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama Yahya Oʼna şu sözlerle engel olmak istedi: “Benim senin tarafından vaftiz edilmem lazım. Yine de sen bana geliyorsun!” ");
INSERT INTO turobt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ama İsa ona şöyle cevap verdi: “Şimdilik buna razı ol! Çünkü doğru olan her şeyi bu şekilde yerine getirmemiz lazım.” Bunun üzerine Yahya İsaʼnın dileğine razı oldu. ");
INSERT INTO turobt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Vaftiz olur olmaz İsa sudan çıktı. O anda gökler açıldı ve İsa, Allahʼın Ruhuʼnun bir güvercin gibi inip kendi üzerinde durduğunu gördü. ");
INSERT INTO turobt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gökten bir ses şöyle dedi: “Bu benim sevgili Oğlumʼdur. Oʼndan memnunum.” ");
INSERT INTO turobt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ondan sonra Kutsal Ruh, İsaʼyı ıssız yerlere götürdü. Orada İblis Oʼnu günaha düşürmeye çalışacaktı. ");
INSERT INTO turobt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","İsa kırk gün kırk gece oruç tuttuktan sonra acıktı. ");
INSERT INTO turobt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oʼnu deneyen İblis gelip dedi ki: “Eğer Allahʼın Oğluʼysan, emret, şu taşlar ekmek olsun.” ");
INSERT INTO turobt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","İsa ona şöyle cevap verdi: “ ‘İnsan sadece ekmekle yaşamaz, Allahʼın ağzından çıkan her bir sözle yaşar’ diye Tevratʼta yazılmıştır.” ");
INSERT INTO turobt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bunun üzerine İblis İsaʼyı kutsal şehir Yeruşalimʼe götürdü. Oʼnu tapınağın en yüksek yerine çıkardı ");
INSERT INTO turobt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ve Oʼna şöyle dedi: “Eğer Allahʼın Oğluʼysan, kendini aşağı at. Çünkü şöyle yazılmıştır: ‘Seni korumaları için meleklerine buyruk verecek. Ayağın taşa çarpmasın diye seni elleri üzerinde taşıyacaklar.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","İsa ona şu cevabı verdi: “ ‘Allahınız Rabbi denemeyin’ diye de yazılmıştır.” ");
INSERT INTO turobt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","İblis bu sefer İsaʼyı çok yüksek bir dağa götürdü. Oʼna dünyanın bütün ülkelerini ve onların görkemini gösterdi. ");
INSERT INTO turobt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Oʼna şöyle dedi: “Eğer yere kapanıp bana taparsan, bütün bunları sana vereceğim.” ");
INSERT INTO turobt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bunun üzerine İsa ona şöyle dedi: “Çekil önümden Şeytan! Çünkü şöyle yazılmıştır: ‘Allahınız Rabbe tapının, yalnız Oʼna hizmet edin.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bundan sonra İblis İsaʼdan ayrıldı. Melekler de gelip İsaʼya hizmet ettiler. ");
INSERT INTO turobt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","İsa Yahyaʼnın tutuklandığını öğrenince, Celile bölgesine çekildi. ");
INSERT INTO turobt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasıra kasabasından ayrılıp Kefernahumʼa yerleşti. Kefernahum göl kenarında, Zevulun ve Naftali topraklarının arasındaki sınırda bulunuyordu. ");
INSERT INTO turobt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Böylece Allahʼın Peygamber Yeşayaʼnın aracılığıyla söyledikleri yerine geldi: ");
INSERT INTO turobt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zevulun ve Naftali toprakları, denize inen yol, Şeria Irmağıʼnın ötesi, diğer milletlerin yaşadığı Celile! ");
INSERT INTO turobt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Karanlıkta yaşayan halk, büyük bir ışık gördü. Ölümün gölgesinde olan bölgede oturanların üzerine şafak doğdu.” ");
INSERT INTO turobt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","O zaman İsa vaazında halka şunları duyurmaya başladı: “Tövbe edin! Çünkü Göklerin Krallığı yaklaştı!” ");
INSERT INTO turobt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","İsa Celile Gölüʼnün kenarında gezinirken iki kardeş gördü. Biri Petrus takma adıyla tanınan Simun, öbürü de onun kardeşi Andreasʼtı. Göle ağ atıyorlardı, çünkü balıkçıydılar. ");
INSERT INTO turobt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","İsa onlara şöyle dedi: “Peşimden gelin! Sizi bana insan kazanan balıkçılar yapacağım” ");
INSERT INTO turobt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Anında ağlarını bırakıp İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","İsa oradan ilerleyince, başka iki kardeş gördü. Onlar Zebediʼnin oğlu Yakub ve onun kardeşi Yuhannaʼydı. Babaları Zebedi ile birlikte teknedeydiler, ağlarını tamir ediyorlardı. İsa onları da çağırdı. ");
INSERT INTO turobt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Onlar da hemen tekneyi ve babalarını bırakıp İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","İsa, Celile bölgesinin her tarafını dolaştı. Halkın toplantı yerlerinde vaaz edip göksel krallık hakkındaki Müjdeʼyi duyurdu. Halkın arasında her türlü hastalığı ve sakatlığı iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oʼnun adı bütün Suriyeʼye yayıldı. Çeşitli hastalıklara tutulanları, acı içinde kıvrananları, cinlileri, saralıları ve felçlileri Oʼna getirdiler. İsa da onları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Celile ve Dekapolis bölgelerinden, Yeruşalimʼle Yahudiyeʼden ve Şeria ırmağının ötesinden gelen büyük kalabalıklar Oʼnun arkasından gidiyordu. ");
INSERT INTO turobt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","İsa kalabalıkları görünce bir tepeye çıktı. Oturduktan sonra, öğrencileri Oʼnun yanına geldiler. ");
INSERT INTO turobt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","İsa da onlara şöyle vaaz etmeye başladı: ");
INSERT INTO turobt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ne mutlu ruhsal fakirlere! Çünkü Göklerin Krallığı onlarındır. ");
INSERT INTO turobt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ne mutlu yas tutanlara! Çünkü onlar teselli bulacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ne mutlu yumuşak huylu olanlara! Çünkü onlar yeryüzünü miras alacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ne mutlu doğruluğa acıkmış ve susamış insanlara! Çünkü onlar doyacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ne mutlu merhametli olanlara! Çünkü onlara da merhamet edilecek. ");
INSERT INTO turobt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ne mutlu yüreği temiz olanlara! Çünkü onlar Allahʼı görecekler. ");
INSERT INTO turobt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ne mutlu barış getirenlere! Çünkü onlara Allah evlatları denecek. ");
INSERT INTO turobt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ne mutlu doğru olanı yaptıkları için eziyet görenlere! Çünkü Göklerin Krallığı onlarındır. ");
INSERT INTO turobt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Benim yüzümden insanlar size hakaret ve eziyet ettikleri zaman ne mutlu size! Hakkınızda yalan yere her türlü kötü söz söylediklerinde size ne mutlu! ");
INSERT INTO turobt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sevinin, şen olun, çünkü gökte ödülünüz büyük olacak. Zaten sizden önceki peygamberlere de aynı şekilde eziyet ettiler. ");
INSERT INTO turobt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Dünyanın tuzu sizsiniz. Ama tuz tadını kaybederse, tekrar ona nasıl tuz tadı verilebilir? O artık dışarı atılmak ve insanların ayakları altında çiğnenmekten başka bir işe yaramaz. ");
INSERT INTO turobt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dünyanın ışığı sizsiniz. Tepe üzerine kurulan şehir saklı kalamaz. ");
INSERT INTO turobt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kimse de bir lamba yakıp onu bir kabın altına koymaz. Hayır, onu lambalığa koyar ve evdeki herkese aydınlık verir. ");
INSERT INTO turobt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aynı bunun gibi, sizin ışığınız da insanların gözü önünde parlasın. Öyle ki, yaptığınız iyilikleri görüp gökteki Babanızʼı yüceltsinler. ");
INSERT INTO turobt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sakın Tevratʼı ya da peygamberlerin yazdıklarını ortadan kaldırmaya geldiğimi sanmayın. Ben onları ortadan kaldırmaya değil, tamamlamaya geldim. ");
INSERT INTO turobt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Size doğrusunu söylüyorum: Yer ve gök ortadan kalkmadan, her şey yerine gelmeden, Tevratʼtan tek bir ufak harf ya da çizgi bile asla yok olmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bu sebeple, her kim bu buyrukların en ufağını bozup insanlara da aynısını yapmayı öğretirse, o kişi Göklerin Krallığıʼnda önemsiz sayılacak. Ama onları kim yerine getirip başkalarına öyle yapmayı öğretirse, o kişiye Göklerin Krallığıʼnda önemli denilecek. ");
INSERT INTO turobt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Çünkü size şunu söylüyorum: Doğruluğunuz Tevrat uzmanlarının ve Ferisilerin doğruluğundan daha üstün olmazsa, Göklerin Krallığıʼna asla giremezsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Atalarımıza ‘Adam öldürmeyin!’ ve ‘Kim adam öldürürse, yargılanacak’ denildiğini işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ancak ben size şunu diyorum: Kardeşine öfkelenen herkes yargılanmayı hak edecek. Kardeşine boş kafalı diyen, Meclisʼin önünde hesap verecek. Birine aptal diyen kişi, cehennem ateşini hak edecek. ");
INSERT INTO turobt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sen kurban yerinde Allahʼa bir adak getirirken, kardeşinin sana karşı bir şikâyeti olduğunu hatırlarsan, ");
INSERT INTO turobt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","o vakit adağını kurban yerinin önünde bırak ve git. Önce kardeşinle barış, sonra dön ve adağını sun! ");
INSERT INTO turobt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Senden davacı olan kişiyle bir an önce, henüz yoldayken anlaş. Öyle ki, o seni yargıca vermesin. Yargıç da seni gardiyana teslim etmesin, o da seni hapishaneye atmasın. ");
INSERT INTO turobt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sana doğrusunu söylüyorum: borcunu son kuruşuna kadar ödemeden oradan çıkamazsın. ");
INSERT INTO turobt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Zina etmeyin!’ denildiğini işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama ben size diyorum: her kim bir kadına bakarsa ve onda gözü kalırsa, o kişi zaten yüreğinde zina etmiştir. ");
INSERT INTO turobt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sağ gözün seni iman yolundan saptırırsa, onu çıkar at! Bütün bedenin cehenneme atılacağına bedeninin bir parçasının yok olması senin için daha iyidir. ");
INSERT INTO turobt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sağ elin seni iman yolundan saptırırsa, onu kes at! Bütün bedenin cehenneme atılacağına bedeninin bir parçasının yok olması senin için daha iyidir. ");
INSERT INTO turobt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Şöyle de denildi: ‘Karısını boşayan adam ona bir boşanma kâğıdı versin.’ ");
INSERT INTO turobt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama ben size diyorum ki, her kim karısını evlilik dışı seksüel ilişkiden başka bir sebeple boşarsa, o kadının zina işlemesine sebep olur. Hem de, kim boşanmış kadınla evlenirse, zina işlemiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Atalarımıza, ‘Yalan yere yemin etmeyin, Rabbin huzurunda ettiğiniz yeminleri yerine getirin’ denildiğini de işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama ben size diyorum ki: hiç yemin etmeyin! Gök üzerine yemin etmeyin, çünkü gök Allahʼın tahtıdır. ");
INSERT INTO turobt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yeryüzü üzerine de yemin etmeyin, çünkü yeryüzü Allahʼın ayaklarının basamağıdır. Yeruşalim üzerine yemin etmeyin, çünkü Yeruşalim Büyük Kralʼın şehridir. ");
INSERT INTO turobt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kendi başınızın üzerine de yemin etmeyin, çünkü saçınızın tek bir telini bile ak, ya da kara yapamazsınız. ");
INSERT INTO turobt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Söylemek istediğiniz söz evet ise, ‘evet’ deyin, hayır ise ‘hayır’ deyin. Ondan ötesi Şeytanʼdandır. ");
INSERT INTO turobt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Göze göz, dişe diş’ denildiğini işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama ben size diyorum ki: size kötülük yapana karşı direnmeyin. Hayır, kim sağ yanağınıza bir tokat atarsa, ona öbür yanağınızı da çevirin. ");
INSERT INTO turobt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Size karşı dava açıp gömleğinizi almak isteyene paltonuzu da verin. ");
INSERT INTO turobt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sizi bin adım gitmeye zorlayan adamla iki bin adım gidin. ");
INSERT INTO turobt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sizden dileyene verin. Ödünç isteyeni geri çevirmeyin. ");
INSERT INTO turobt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Komşunuzu sevin, ama düşmanınızdan nefret edin!’ denildiğini işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama ben size diyorum: düşmanlarınızı sevin, size eziyet edenler için dua edin. ");
INSERT INTO turobt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Öyle ki, gökteki Babanızʼın evlatları olasınız. Çünkü O güneşini hem kötülerin, hem de iyilerin üzerine parlatır. Hem doğru olanlara, hem de doğru olmayanlara yağmur yağdırır. ");
INSERT INTO turobt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Çünkü sadece sizi sevenleri severseniz, ne ödülünüz olur? Vergi memurları bile aynısını yapmazlar mı? ");
INSERT INTO turobt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sadece kardeşlerinize selam verirseniz, diğer insanlardan fazla ne yapmış olursunuz? Diğer milletler bile aynısını yapmazlar mı? ");
INSERT INTO turobt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bunun için, gökteki Babanız nasıl kusursuzsa siz de öyle kusursuz olun!” ");
INSERT INTO turobt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Sakın gösteriş için insanların gözü önünde iyilik yapmayın. Yoksa gökteki Babanızʼdan ödülünüz olmaz. ");
INSERT INTO turobt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bu sebeple, fakirlere yardım ettiğiniz zaman, bunu davul zurnayla duyurmayın. İkiyüzlüler toplantı yerlerinde ve sokaklarda öyle yaparlar. Yeter ki, insanlar onlara saygı göstersinler. Size doğrusunu söylüyorum: onlar ödüllerini zaten aldılar. ");
INSERT INTO turobt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hayır! Siz fakir birine yardım ettiğiniz zaman, sol eliniz sağ elinizin ne yaptığını bilmesin. ");
INSERT INTO turobt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Öyle ki, ettiğiniz yardım gizli kalsın. Gizli olanı gören Göksel Babanız size karşılık verecek. ");
INSERT INTO turobt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Dua ettiğiniz zaman ikiyüzlüler gibi yapmayın. Onlar toplantı yerlerinde ve sokaklarda dikilip dua etmeye bayılırlar. Yeter ki, insanlar onları görsün. Size doğrusunu söylüyorum: onlar ödüllerini zaten aldılar. ");
INSERT INTO turobt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama siz dua ettiğiniz zaman odanıza girin, kapıyı kapatın, gözle görülmeyen göksel Babanızʼa dua edin. Gizlice yaptığınızı gören Babanız size karşılık verecek. ");
INSERT INTO turobt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dua ettiğiniz zaman, aynı boş lafları tekrarlayıp durmayın. Diğer milletler öyle yapıyorlar. Çünkü çok laf ettikleri için Allahʼın onları işiteceğini sanıyorlar. ");
INSERT INTO turobt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Onlar gibi olmayın. Göksel Babanız ihtiyacınızın ne olduğunu siz daha dilemeden bilir. ");
INSERT INTO turobt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Onun için siz şöyle dua edin: ‘Gökteki Babamız! Senin adın kutsal olsun. ");
INSERT INTO turobt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Senin krallığın gelsin. Gökte olduğu gibi, yeryüzünde de senin istediğin olsun. ");
INSERT INTO turobt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bugün bize gündelik ekmeğimizi ver. ");
INSERT INTO turobt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bize karşı suç işleyenleri nasıl bağışladıysak, sen de bizim suçlarımızı bağışla. ");
INSERT INTO turobt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bizi doğru yoldan saptıracak bir duruma düşürme, ama kötü olandan kurtar. Çünkü krallık, güç ve yücelik, sonsuzlara kadar senindir. Amin.’ ");
INSERT INTO turobt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Çünkü siz insanların suçlarını bağışlarsanız, gökteki Babanız da sizi bağışlayacak. ");
INSERT INTO turobt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama insanları bağışlamazsanız, Babanız da sizin suçlarınızı bağışlamayacak. ");
INSERT INTO turobt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Oruç tuttuğunuz zaman, ikiyüzlüler gibi surat asmayın. Onlar, insanlar oruçlu olduklarını fark etsinler diye kara kara bakınırlar. Size doğrusunu söylüyorum: onlar ödüllerini zaten aldılar. ");
INSERT INTO turobt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Fakat siz oruç tuttuğunuz zaman, başınıza koku sürün ve yüzünüzü yıkayın. ");
INSERT INTO turobt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Öyle ki, insanlar değil, gözden uzak olan Babanız oruç tuttuğunuzu görsün. Gizlice yaptığınızı gören Babanız size karşılık verecek. ");
INSERT INTO turobt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yeryüzünde kendinize servet biriktirmeyin. Burada böcek ve küf onları yiyip bitirir. Hırsızlar da evi basıp serveti çalarlar. ");
INSERT INTO turobt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hayır! Kendinize gökte bir servet biriktirin. Orada ne böcek ne de küf onları yiyip bitirmez. Hırsızlar da evi basıp onları çalamazlar. ");
INSERT INTO turobt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Çünkü servetiniz neredeyse, yüreğiniz de orada olacak. ");
INSERT INTO turobt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Bedenin ışığı gözdür. Öyleyse gözünüz sağlam olursa, bütün bedeniniz aydınlık olur. ");
INSERT INTO turobt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama gözünüz kötü olursa, bütün bedeniniz karanlık olur. Sizdeki aydınlık karanlık olursa, o karanlık ne kadar korkunçtur! ");
INSERT INTO turobt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kimse iki efendiye kölelik edemez. Ya birinden nefret edip, öbürünü sevecek, ya da birine bağlanıp, öbürünü hor görecek. Siz hem Allahʼa, hem de paraya kölelik edemezsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Bunun için size şunu söylüyorum: Ne yiyip ne içeceğiz diye canınızı sıkmayın. Ne giyeceğiz diye de bedeniniz için kaygılanmayın. Can yiyecekten, beden de giyecekten daha önemlidir, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gökteki kuşlara bakın: ne ekerler ne biçerler, ne de ambarlarda yiyecek biriktirirler. Fakat gökteki Babanız onları besler. Siz onlardan daha değerli değil misiniz? ");
INSERT INTO turobt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hangi biriniz kaygılanarak ömrünü bir saat bile uzatabilir? ");
INSERT INTO turobt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Elbise için neden kaygılanıyorsunuz? Tarladaki çiçeklere bakın nasıl büyürler! Ne iş yaparlar, ne de dikiş dikerler. ");
INSERT INTO turobt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yine de size şunu söylüyorum: Kral Süleyman gösterişli hayat yaşadı. Ama o bile, bu çiçeklerden biri kadar güzel giyinmemişti. ");
INSERT INTO turobt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Otlar bir gün çayırda büyür, ertesi gün fırına atılır. Ey siz imanı az olanlar! Allah otları bile öyle giydiriyorsa, mutlaka sizi de giydirecek, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Onun için yiyeceğimizi ve içeceğimizi nasıl sağlayacağız, örtünmek için nasıl elbise bulacağız diye kaygılanmayın. ");
INSERT INTO turobt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Çünkü diğer milletler hep böyle şeylerin peşindeler. Oysa gökteki Babanız bütün bunlara muhtaç olduğunuzu biliyor. ");
INSERT INTO turobt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Siz Allahʼın Krallığıʼna ve doğru yoluna öncelik verin. O zaman size bütün bu şeyler de verilecek. ");
INSERT INTO turobt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","O halde yarın için kaygılanmayın. Yarının derdi yarına kalsın. Her günün derdi kendine yeter.” ");
INSERT INTO turobt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Başkasını yargılamayın ki, siz de yargılanmayasınız. ");
INSERT INTO turobt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Çünkü nasıl suçlarsanız öyle suçlanacaksınız. Bir de hangi ölçüyle yargılarsanız, siz de aynı ölçüyle yargılanacaksınız. ");
INSERT INTO turobt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Neden başkasının gözündeki çöpü görüyorsun da, kendi gözündeki kütüğü görmüyorsun? ");
INSERT INTO turobt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kendi gözünde kütük varken, nasıl kardeşine, ‘İzin ver, gözündeki çöpü çıkarayım’ dersin? ");
INSERT INTO turobt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Seni ikiyüzlü seni! Önce kendi gözündeki kütüğü çıkar. O zaman kardeşinin gözündeki çöpü çıkarmak için daha iyi görürsün. ");
INSERT INTO turobt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kutsal olanı köpeklere vermeyin, ve incilerinizi domuzların önüne atmayın. Yoksa onları ayaklarının altında çiğnerler. Sonra da dönüp sizi paramparça ederler. ");
INSERT INTO turobt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dileyin, size verilecek. Arayın, bulacaksınız. Kapıyı çalın, size açılacak. ");
INSERT INTO turobt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Çünkü her dileyen alır, arayan bulur ve kapıyı çalana kapı açılır. ");
INSERT INTO turobt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aranızda hangi adam oğlu ondan ekmek isteyince, ona taş verir? ");
INSERT INTO turobt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ya da ondan balık isteyince ona yılan verir? ");
INSERT INTO turobt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kötü olan sizler bile çocuklarınıza iyi hediyeler vermeyi biliyorsunuz. Öyleyse, gökteki Babanızın da ondan isteyenlere iyi olanı vereceği daha kesin değil mi? ");
INSERT INTO turobt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Öyleyse, insanların size nasıl davranmasını istiyorsanız, siz de onlara öyle davranın. Tevratʼın ve peygamberlerin söyledikleri budur. ");
INSERT INTO turobt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Dar kapıdan girin. Çünkü geniş kapı ve rahat yol yıkıma götürür. Oradan girenler çoktur. ");
INSERT INTO turobt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hayata götüren kapı ise dardır ve yolu zahmetlidir. Onu bulanlar da azdır. ");
INSERT INTO turobt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sahte peygamberlerden sakının! Aranıza koyun kılığında girerler, fakat aslında yırtıcı kurtlardır. ");
INSERT INTO turobt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Onları meyvelerinden tanıyacaksınız. Üzümler çalılardan toplanmaz, incirler de dikenlerden toplanmaz, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Demek ki, her iyi ağaç iyi meyve verir, ama kötü ağaç kötü meyve verir. ");
INSERT INTO turobt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","İyi ağaç kötü meyve veremez, kötü ağaç da iyi meyve veremez. ");
INSERT INTO turobt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","İyi meyve vermeyen her ağaç kesilip ateşe atılır. ");
INSERT INTO turobt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Evet, onları meyvelerinden tanıyacaksınız. ");
INSERT INTO turobt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bana ‘Efendimiz, Efendimiz!’ diyen herkes Göklerin Krallığıʼna girmeyecek. Ama kim gökte olan Babamʼın isteğini yerine getirirse, o girecek. ");
INSERT INTO turobt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","O gün çok kişi bana şöyle diyecek: ‘Efendimiz, Efendimiz! Biz senin adınla peygamberlik etmedik mi? Senin adınla cinleri kovmadık mı? Senin adınla birçok mucize yapmadık mı?’ ");
INSERT INTO turobt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","O zaman ben onlara açıkça diyeceğim ki: ‘Sizi hiç tanımadım. Defolun, sizi kötülük yapanlar.’ ");
INSERT INTO turobt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Bunun için, her kim benim bu sözlerimi işitirse, ve ona göre yaşarsa, akıllı bir adama benzer. Böyle bir adam evini kaya üzerine kurar. ");
INSERT INTO turobt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sonra yağmur yağar, seller yükselir, rüzgar eser ve o eve çarpar. Fakat ev yıkılmaz, çünkü kaya üzerine kurulmuştur. ");
INSERT INTO turobt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Oysa her kim benim bu sözlerimi işitirse ama ona göre yaşamazsa, akılsız bir adama benzer. Böyle bir adam evini kum üzerine kurar. ");
INSERT INTO turobt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sonra yağmur yağar, seller yükselir, rüzgar eser ve o eve çarpar. Ev de yıkılır, korkunç bir şekilde mahvolur.” ");
INSERT INTO turobt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","İsa bu konuşmayı bitirince, halk Oʼnun öğrettiklerine şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Çünkü onlara Tevrat uzmanları gibi değil, yetkiye sahip biri olarak vaaz ediyordu. ");
INSERT INTO turobt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","İsa tepeden indi. Büyük bir kalabalık Oʼnun arkasından yürüdü. ");
INSERT INTO turobt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bu sırada cüzzam hastası bir adam yaklaştı. İsaʼnın ayaklarına kapanarak şöyle dedi: “Ey Efendim! İstersen, beni hastalığımdan temizleyebilirsin!” ");
INSERT INTO turobt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","İsa elini uzatıp adama dokundu ve, “İsterim” dedi. “Temiz ol!” Anında adam cüzzam hastalığından temizlendi. ");
INSERT INTO turobt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","İsa adama şöyle dedi: “Bunu kimseye anlatma. Ancak git, rahibe görün. Sonra Musaʼnın buyurduğu kurbanı sun. Bu herkese şahitlik olacak.” ");
INSERT INTO turobt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","İsa Kefernahumʼa geldikten sonra, Romalı bir yüzbaşı Oʼna yaklaştı ve şöyle yalvardı: ");
INSERT INTO turobt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Efendimiz, evde genç bir hizmetkârım var, eli ayağı tutmaz oldu, büyük acılar içinde yatıyor.” ");
INSERT INTO turobt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","İsa adama, “Gelip onu iyileştireceğim” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ama yüzbaşı şöyle cevap verdi: “Efendimiz, evime kadar gelmene layık değilim. Sadece bir söz söyle, o zaman hizmetkârım iyileşecek. ");
INSERT INTO turobt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Çünkü ben de buyruk altında bir adamım. Benim de buyruğumda askerlerim var. Birisine ‘Git’ derim, gider. Başkasına ‘Gel’ derim, gelir. Köleme de ‘Şunu yap’ derim, yapar.” ");
INSERT INTO turobt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","İsa bunu duyunca hayret etti ve Oʼnu izleyenlere şöyle dedi: “Size doğrusunu söylüyorum: İsrail halkında hiç kimsede bu kadar büyük imana rastlamadım. ");
INSERT INTO turobt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Size derim ki, Doğudan ve batıdan çok kişi gelecek ve Göklerin Krallığıʼnda İbrahim, İshak ve Yakubʼla birlikte sofraya oturacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama bu krallığın asıl vatandaşları dışarıya atılıp karanlıkta kalacaklar. Orada ağlayıp dişlerini gıcırdatacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sonra İsa yüzbaşıya dedi: “Git, sen nasıl iman ettiysen, öyle olsun.” O anda genç hizmetkâr iyileşti. ");
INSERT INTO turobt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","İsa Petrusʼun evine geldi. Petrusʼun kaynanasının ateşler içinde hasta yattığını gördü. ");
INSERT INTO turobt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","İsa onun eline dokununca kadının ateşi düştü. Sonra kadın kalkıp İsaʼya hizmet etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Akşam olunca, İsaʼya cinli birçok kişiyi getirdiler. İsa emir vererek cinleri kovdu ve bütün hastaları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Böylece Allahʼın Peygamber Yeşayaʼnın aracılığıyla söylediği şu söz yerine geldi: “Zayıflıklarımızı O üstlendi. Hastalıklarımızı O yüklendi.” ");
INSERT INTO turobt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","İsaʼnın etrafına kalabalıklar toplandı. İsa bunu görünce öğrencilerine gölün öbür tarafına geçmelerini söyledi. ");
INSERT INTO turobt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bir Tevrat uzmanı gelip İsaʼya şöyle dedi: “Öğretmenim, sen nereye gidersen peşinden geleceğim”. ");
INSERT INTO turobt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","İsa ona şöyle cevap verdi: “Tilkilerin yatacak yerleri var. Gökteki kuşların da yuvaları var. Ama İnsan Oğluʼnun başını koyacak yeri yok.” ");
INSERT INTO turobt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Başka bir öğrenci İsaʼya “Efendim, izin ver de, önce gidip babamı gömeyim” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","İsa ona şöyle karşılık verdi: “Sen benim peşimden gel. Bırak, ölüler kendi ölülerini gömsünler.” ");
INSERT INTO turobt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","İsa tekneye bindi. Öğrencileri de Oʼnunla beraber gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aniden gölde büyük bir fırtına koptu. Öyle ki, dalgalar tekneyi yutacak gibiydi. Fakat İsa uykuya dalmıştı. ");
INSERT INTO turobt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Öğrencileri gelip Oʼnu uyandırdılar. “Efendimiz!” dediler. “Kurtar bizi, boğuluyoruz!” ");
INSERT INTO turobt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","İsa onlara şöyle dedi: “Neden korkuyorsunuz, sizi imanı az olanlar?” Sonra kalktı, rüzgarı ve gölü azarladı. Ortalık tamamen sakinleşti. ");
INSERT INTO turobt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Adamlar hayret ettiler. “Bu nasıl bir adam ki, rüzgar ve göl bile Oʼnun buyruğuna uyuyor?” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gölün öbür tarafına, Gadara kasabasının yakınındaki topraklara geldiler. Cinli iki adam İsaʼyı karşıladı. Bu adamlar mezarlık olarak kullanılan mağaralarda yaşıyorlardı. Onlar o kadar belalıydı ki, kimse o yoldan geçemezdi. ");
INSERT INTO turobt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bu iki adam İsaʼya bağırıp şöyle dediler: “Ey Allahʼın Oğlu, bizden ne istiyorsun? Vaktinden önce bize işkence etmeye mi geldin?” ");
INSERT INTO turobt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Onlardan biraz uzakta büyük bir domuz sürüsü otluyordu. ");
INSERT INTO turobt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Cinler İsaʼya şöyle yalvarmaya başladılar: “Madem bizi kovacaksın, o zaman domuz sürüsüne yolla.” ");
INSERT INTO turobt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","İsa onlara “Gidin!” dedi. Onlar da adamlardan çıkıp domuzların içine girdiler. Bütün sürü dik yamaçtan aşağı göle atladı. Domuzlar boğularak öldüler. ");
INSERT INTO turobt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Domuzları otlatanlar oradan kaçıp kasabaya gittiler. Orada cinli adamlara olanlar dahil, her şeyi anlattılar. ");
INSERT INTO turobt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bunun üzerine kasabadaki herkes İsaʼyı karşılamaya çıktı. Oʼnu görünce o bölgeden ayrılması için Oʼna yalvardılar. ");
INSERT INTO turobt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","İsa tekneye binip gölün karşı tarafına geçti ve kendi kasabasına geldi. ");
INSERT INTO turobt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Oʼna döşek üzerinde yatan felçli bir adam getirdiler. İsa onların imanını görünce felçli adama, “Evladım” dedi. “Gözün aydın! Günahların bağışlandı.” ");
INSERT INTO turobt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bunun üzerine Tevrat uzmanlarından bazıları aralarında, “Bu adam Allahʼa hakaret ediyor!” diye homurdandılar. ");
INSERT INTO turobt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ama İsa onların düşüncelerini anlayıp şunu sordu: “Aklınızda neden kötülüğe yer veriyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hangisi daha kolay? ‘Günahların bağışlandı’ demek mi, yoksa ‘Kalk, yürü’ demek mi? ");
INSERT INTO turobt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama İnsan Oğluʼnun yeryüzünde günahları bağışlama yetkisine sahip olduğunu bilesiniz diye…” Sonra felçli adama, “Kalk, yatağını al ve evine git” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Adam da kalkıp evine gitti. ");
INSERT INTO turobt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Halk bunu görünce hayran kaldı. İnsanlara bu yetkiyi veren Allahʼı övdüler. ");
INSERT INTO turobt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","İsa oradan yoluna devam etti. Vergi toplanma yerinde oturan Matta adındaki adamı gördü. Ona “Peşimden gel!” dedi. O da kalkıp İsaʼnın peşinden gitti. ");
INSERT INTO turobt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sonra İsa Mattaʼnın evinde sofra başındayken, vergi memurları dahil birçok günahkâr geldi. Onlar İsaʼyla ve Oʼnun öğrencileriyle birlikte yemek yiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ferisiler bunu görünce İsaʼnın öğrencilerine şöyle dediler: “Öğretmeniniz niçin vergi memurları ve günahkârlarla yemek yiyor?” ");
INSERT INTO turobt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ama İsa bunu işitince, “Sağlıklı insanların değil, hasta olanların doktora ihtiyacı var” diye cevap verdi. ");
INSERT INTO turobt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Gidin şu ayetin anlamını öğrenin: ‘Kurban değil merhamet istiyorum.’ Ben doğru kişileri değil, günahkârları tövbeye çağırmaya geldim.” ");
INSERT INTO turobt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sonra Yahyaʼnın öğrencileri İsaʼya gelip sordular: “Biz oruç tutuyoruz, Ferisiler de oruç tutuyorlar. Neden senin öğrencilerin oruç tutmuyor?” ");
INSERT INTO turobt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","İsa onlara şöyle cevap verdi: “Damat onların arasındayken, damadın arkadaşları yas tutar mı? Ama gün gelecek, damat aralarından alınacak. İşte, o zaman oruç tutacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hiç kimse yepyeni bir kumaş parçasını alıp onu eski bir elbiseye yama yapmaz. Yoksa yama elbiseden sökülür ve yırtık daha büyür. ");
INSERT INTO turobt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hiç kimse de yeni şarabı eski tulumlara doldurmaz. Yoksa tulumlar patlar. Şarap dökülür ve tulumlar paramparça olur. Hayır, yeni şarap yeni tulumlara doldururlar. Böylece ikisi de korunur.” ");
INSERT INTO turobt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","İsa daha bu şeyleri onlara anlatırken, bir halk lideri gelip Oʼnun önünde yere kapandı ve şöyle dedi: “Kızım az önce öldü. Ama gelip elinle ona dokunursan, o yaşayacak”. ");
INSERT INTO turobt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","İsa kalkıp öğrencileriyle birlikte adamın ardından gitti. ");
INSERT INTO turobt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bu sırada bir kadın İsaʼnın arkasından yaklaştı. Kadının on iki yıldan beri kanaması vardı. Hemen gelip İsaʼnın elbisesinin kenarına dokundu. ");
INSERT INTO turobt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Çünkü kadın kendi kendine şöyle demişti: “Elbisesine bir dokunursam, iyileşirim.” ");
INSERT INTO turobt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","İsa dönüp kadını görünce ona, “Kızım, gözün aydın! İmanın seni kurtardı” dedi. Kadın o anda iyileşti. ");
INSERT INTO turobt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","İsa halk liderinin evine geldi. Avluda cenaze müziği çalanları ve gürültülü kalabalığı gördü. ");
INSERT INTO turobt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Dışarı çıkın!” dedi. “Kız ölmedi, sadece uyuyor.” İsaʼyla alay ettiler. ");
INSERT INTO turobt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kalabalık dışarıya çıkarıldıktan sonra, İsa kızın bulunduğu odaya girdi. Kızın elini tuttu ve kız ayağa kalktı. ");
INSERT INTO turobt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bu haber bütün bölgeye yayıldı. ");
INSERT INTO turobt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","İsa oradan yoluna devam ederken, iki kör adam Oʼnu izledi. Onlar İsaʼya yüksek sesle, “Davud Oğlu, bize acı!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","İsa eve girdikten sonra, kör adamlar Oʼna yaklaştılar. İsa da onlara şunu sordu: “Gözlerinizi açabileceğime inanıyor musunuz?” Oʼna, “Evet Efendimiz, inanıyoruz” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","O zaman İsa onların gözlerine dokunup “İmanınıza göre olsun” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Onların gözleri açıldı ve İsa onları çok sıkı uyardı. “Bakın, bu işten kimsenin haberi olmasın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Fakat onlar dışarı çıkıp İsa hakkındaki haberi bütün bölgeye yaydılar. ");
INSERT INTO turobt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Onlar dışarı çıkınca, İsaʼya konuşamayan cinli bir adam getirildi. ");
INSERT INTO turobt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cin kovulduktan sonra adam konuşmaya başladı. Halk da şaşırıp kaldı. “İsrailʼde şimdiye kadar hiç böyle bir şey görülmedi” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama Ferisiler, “Cinleri cinlerin lideri Şeytanʼın gücüyle kovuyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","İsa o bölgedeki bütün köyleri ve kasabaları dolaştı. Halkın toplantı yerlerinde vaaz edip göksel krallık hakkındaki Müjdeʼyi duyurdu. Her türlü hastalığı ve sakatlığı iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kalabalıkları görünce onlara acıdı, çünkü onlar üzgün ve endişeliydiler. Çobansız koyunlar gibiydiler. ");
INSERT INTO turobt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","O zaman öğrencilerine şunu söyledi: “Toplanacak ekin bol, ama işçi az. ");
INSERT INTO turobt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Onun için, ekin Sahibiʼne yalvarın ki, ekinleri biçmeye işçi göndersin.” ");
INSERT INTO turobt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","İsa on iki öğrencisini yanına çağırdı. Onlara şeytani ruhların üzerine yetki verdi. Böylece şeytani ruhları kovacak, her tür hastalığı ve sakatlığı iyileştireceklerdi. ");
INSERT INTO turobt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","On iki elçinin adları şunlardır: Birincisi, Petrus lakabıyla tanınan Simun ve onun kardeşi Andreas, Zebediʼnin oğlu Yakub ve onun kardeşi Yuhanna, ");
INSERT INTO turobt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus ve Bartalmay, Tomas ve vergi memuru Matta, Alpay oğlu Yakub ve Taday, ");
INSERT INTO turobt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yurtsever Simun ve İsaʼya ihanet eden Yahuda İskariyot. ");
INSERT INTO turobt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","İsa bu on iki adamı hizmete gönderdi. Göndermeden önce onlara şu emirleri verdi: “Diğer milletlere gitmeyin, Samiriyelilerin hiçbir kasabasına girmeyin. ");
INSERT INTO turobt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Onun yerine kaybolmuş koyunlara benzeyen İsrail halkına gidin. ");
INSERT INTO turobt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gittiğiniz her yerde ‘Göklerin Krallığı yaklaştı’ haberini bildirin. ");
INSERT INTO turobt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hastaları iyileştirin, ölüleri diriltin, cüzzam hastalarını temiz kılın, cinleri kovun. Bu gücü karşılıksız aldınız, karşılıksız kullanın. ");
INSERT INTO turobt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Keselerinize altın, gümüş, ya da bakır almayın. ");
INSERT INTO turobt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yolculuk için yiyecek torbası, yedek gömlek, sandalet ya da değnek almayın. Çünkü işçi yiyeceğini hak eder. ");
INSERT INTO turobt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hangi kasabaya, hangi köye girerseniz, orada saygıdeğer biri var mı diye araştırın. Ayrılana kadar o kişinin evinde kalın. ");
INSERT INTO turobt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","O eve girerken ona esenlik dileyin. ");
INSERT INTO turobt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Evdekiler buna layıksa, dilediğiniz esenlik onların üzerine kalsın. Ama layık değillerse, esenlik dileğiniz size geri dönsün. ");
INSERT INTO turobt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eğer bir ev ya da kasaba halkı sizi iyi karşılamaz ve söylediklerinizi dinlemezse, o yerden ayrılın. Ayrılırken de ayaklarınızın tozunu silkin. ");
INSERT INTO turobt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Size doğrusunu söylüyorum: Dünyanın yargılanacağı günde Sodom ve Gomora o kasabadan daha hafif bir ceza alacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Bakın, ben sizi koyunlar gibi kurtların arasına yolluyorum. Bunun için yılan gibi akıllı ve güvercin gibi zararsız olun. ");
INSERT INTO turobt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","İnsanlardan sakının! Çünkü sizi dava yerlerine teslim edecekler ve toplantı yerlerinde kamçılayacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Benim yüzümden sizi valilerin ve kralların önüne getirecekler. Bu sizin için onlara ve diğer milletlere şahitlik etme fırsatı olacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Onlar sizi dava yerlerine teslim edince, neyi nasıl söyleyeceğiz diye, hiç kaygılanmayın. Çünkü o anda söyleyeceğiniz sözler size verilecek. ");
INSERT INTO turobt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Zaten konuşan siz olmayacaksınız, sizin içinizde konuşan Göksel Babanızʼın Ruhu olacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kardeş kardeşi, baba da evladını ölüme teslim edecek. Çocuklar da anne babalarına karşı ayaklanıp onları öldürtecekler. ");
INSERT INTO turobt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Benim adım yüzünden herkes sizden nefret edecek. Ama kim sonuna kadar dayanırsa, o kurtulacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Size bir kasabada eziyet ederlerse, başka kasabaya kaçın. Size doğrusunu söylüyorum: İnsan Oğlu gelene kadar siz İsrailʼdeki kasabaları dolaşmayı bitiremezsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Öğrenciöğretmeninden, köle de efendisinden üstün değildir. ");
INSERT INTO turobt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yeter ki, öğrenci öğretmeniyle, köle de efendisiyle aynı durumda olsun. Evin efendisine Şeytan derlerse, ev halkına neler demezler! ");
INSERT INTO turobt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Bunun için onlardan korkmayın. Çünkü açığa çıkarılmayacak üstü kapalı bir şey yoktur. Bilinmeyecek gizli bir şey de yoktur. ");
INSERT INTO turobt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Size karanlıkta ne söylediysem, onu aydınlıkta söyleyin. Kulağınıza fısıldanan sözleri evin çatısından duyurun. ");
INSERT INTO turobt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bedeni öldüren ama ruhu öldürmeye gücü olmayanlardan korkmayın. Yalnız Allahʼtan korkun. Oʼnun hem ruhu hem de bedeni cehennemde yok etmeye gücü vardır. ");
INSERT INTO turobt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","İki serçe kuşu bir bakır paraya satılmıyor mu? Fakat Babanızʼın haberi olmadan onlardan bir tanesi bile yere düşmez. ");
INSERT INTO turobt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Saçınızın her teli bile sayılmıştır. ");
INSERT INTO turobt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Onun için korkmayın. Siz birçok serçeden daha değerlisiniz. ");
INSERT INTO turobt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Her kim bana ait olduğunu insanların önünde duyurursa, ben de onun bana ait olduğunu gökte olan Babamʼın önünde duyuracağım. ");
INSERT INTO turobt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama her kim beni insanların önünde reddederse, ben de onu gökte olan Babamʼın önünde reddedeceğim. ");
INSERT INTO turobt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yeryüzüne barış getirmeye geldiğimi sanmayın. Barış değil, kılıç getirmeye geldim. ");
INSERT INTO turobt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Çünkü ben bir adamın babasıyla arasını açmaya geldim. Kızın annesiyle ve gelinin kaynanasıyla arasını açmaya geldim. ");
INSERT INTO turobt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","İnsanın düşmanı kendi ev halkı olacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kim annesini ve babasını benden daha çok severse, o bana layık değildir. Kim oğlunu ya da kızını benden daha çok severse, o da bana layık değildir. ");
INSERT INTO turobt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Çarmıhını yüklenip peşimden gelmeyen kişi bana layık değildir. ");
INSERT INTO turobt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kim canını kurtarmak isterse onu kaybedecek. Ama kim canını benim uğruma kaybederse onu bulacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kim sizi kabul ederse, o beni de kabul etmiş olur. Kim beni kabul ederse, beni göndereni de kabul etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kim bir peygamberi, peygamber olduğu için kabul ederse, o peygamberle aynı ödülü alacak. Kim doğru bir kişiyi doğru olduğu için kabul ederse, o doğru kişiyle aynı ödülü alacak. ");
INSERT INTO turobt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Her kim, bu basit kişilerden birine öğrencim olduğu için sadece bir bardak soğuk su verirse, size doğrusunu söylüyorum: ödülsüz kalmayacak.” ");
INSERT INTO turobt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","İsa, on iki öğrencisine bu buyrukları verdikten sonra oradan ayrıldı. Halka vaaz vermek ve Allahʼın sözünü duyurmak için etraftaki kasabaları dolaştı. ");
INSERT INTO turobt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahya hapisteyken Mesihʼin yaptıklarını işitmişti. Kendi öğrencilerinden bazılarını İsaʼya gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Onların aracılığıyla Oʼna şunu sordu: “Gelecek olan Mesih sen misin, yoksa başkasını mı bekleyelim?” ");
INSERT INTO turobt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","İsa Yahyaʼnın öğrencilerine şöyle cevap verdi: “Gidin, işittiğinizi, gördüğünüzü Yahyaʼya anlatın. ");
INSERT INTO turobt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Körlerin gözleri açılıyor, sakatlar yürüyor, cüzzam hastaları temiz kılınıyor, sağırlar işitiyor, ölüler diriliyor ve fakirlere Müjde duyuruluyor. ");
INSERT INTO turobt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Benim hakkımda şüpheye düşmeyene ne mutlu!” ");
INSERT INTO turobt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yahyaʼnın öğrencileri oradan ayrılırken İsa halka Yahyaʼdan söz etmeye başladı: “Issız yerlere ne görmeye gittiniz? Rüzgarda sallanan bir kamış mı? ");
INSERT INTO turobt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Söyleyin, ne görmeye gittiniz? Lüks elbiseler giyen bir adam mı? Bakın, lüks elbiseler giyenler kral sarayında oturanlardır. ");
INSERT INTO turobt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Öyleyse ne görmeye gittiniz? Bir peygamber mi? Evet! Ama ben size diyorum ki, Yahya peygamberden de üstündür. ");
INSERT INTO turobt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yahya hakkında şu sözler yazılmıştır: ‘Bak, ben habercimi senin önünden gönderiyorum. O önden gidip senin yolunu hazırlayacak.’ ");
INSERT INTO turobt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Size doğrusunu söylüyorum: kadından doğanların arasında Vaftizci Yahyaʼdan daha üstün bir kişi ortaya çıkmadı. Ama Göklerin Krallığıʼnda en önemsiz kişi Yahyaʼdan üstündür. ");
INSERT INTO turobt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Vaftizci Yahyaʼnın zamanından bugüne kadar Göklerin Krallığı saldırılara uğruyor ve saldırganlar onu zorla ele geçirmeye çalışıyorlar. ");
INSERT INTO turobt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Çünkü Yahyaʼya kadar bütün peygamberler de, Tevrat da olacakları önceden bildirdiler. ");
INSERT INTO turobt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dediklerini kabul ederseniz, beklediğiniz İlyas Peygamber aslında Yahyaʼdır. ");
INSERT INTO turobt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kulağı olan işitsin. ");
INSERT INTO turobt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ama bu kuşağın insanlarını neye benzeteyim? Bu kuşak çarşıda oturan çocuklara benziyor. Seslerini yükseltip arkadaşlarına şöyle derler: ");
INSERT INTO turobt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Size kaval çaldık, oynamadınız. Cenaze ezgileri söyledik, ağlamadınız.’ ");
INSERT INTO turobt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yahya geldiği zaman oruç tutup içkiden kaçındı. ‘Adamda cin var’ diyorlar. ");
INSERT INTO turobt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","İnsan Oğlu geldiğinde yiyip içti. Bu sefer, ‘Bakın, ne biçim adam bu!’ diyorlar. ‘Boğazına düşkün ve içkici, vergi memurlarının ve günahkârların arkadaşı.’ Oysa hikmet getirdiği sonuçlarla haklı çıkarılır.” ");
INSERT INTO turobt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","O zaman İsa mucizelerinin çoğunun yapıldığı kasabaları azarlamaya başladı. Çünkü bu kasabalar tövbe etmemişlerdi. ");
INSERT INTO turobt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","İsa şöyle dedi: “Vay senin haline ey Horazin! Vay senin haline ey Beytsayda! Çünkü sizde yapılan mucizeler Sur ve Sayda şehirlerinde yapılmış olsaydı, onlar çoktan çuval bezine sarınıp kül içinde tövbe ederlerdi. ");
INSERT INTO turobt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ben size diyorum ki, dünyanın yargılanacağı günde Sur ve Sayda sizden daha hafif bir ceza alacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya sen, ey Kefernahum! Göğe kadar mı yükseleceksin? Hayır, ölüler dünyasına batacaksın. Çünkü sende yapılan mucizeler Sodom şehrinde yapılmış olsaydı, Sodom bugüne kadar ayakta kalırdı. ");
INSERT INTO turobt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama ben size diyorum ki, dünyanın yargılanacağı günde Sodom senden daha hafif bir ceza alacak.” ");
INSERT INTO turobt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","O sırada İsa konuşmasına şöyle devam etti: “Sana şükrediyorum, ey Baba, göğün ve yerin Efendisi, çünkü bu konuları bilgili ve akıllı kişilerden gizledin ve basit insanlara açıkladın. ");
INSERT INTO turobt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Evet Baba, çünkü seni memnun eden budur. ");
INSERT INTO turobt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Babam her şeyi bana emanet etti. Babaʼdan başka kimse Oğulʼu tanımaz. Babaʼyı da sadece Oğul ve Oğulʼun Oʼnu tanıtmak istediği kişiler tanır. ");
INSERT INTO turobt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ey bütün yorgunlar, yükleri ağır olanlar! Bana gelin, ben sizi rahata kavuşturacağım. ");
INSERT INTO turobt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Benim boyunduruğumu üstlenin ve benden ders alın. Çünkü ben yumuşak huylu ve alçak gönüllüyüm. O zaman gönül rahatlığı bulursunuz. ");
INSERT INTO turobt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Çünkü benim boyunduruğum kolay taşınır, vereceğim yük de hafiftir.” ");
INSERT INTO turobt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","İsa bir Şabat günü ekin tarlalarından geçiyordu. Oʼnun öğrencileri acıkmıştı ve ekin başaklarını koparıp yemeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ferisiler bunu görünce İsaʼya şöyle dediler: “Bak, senin öğrencilerin Şabat gününde Tevratʼta yasaklananı yapıyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","İsa onlara şöyle dedi: “Davud ve adamları acıkınca Davudʼun ne yaptığını okumadınız mı? ");
INSERT INTO turobt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Allahʼın evine girdi, hem kendisi hem de adamları adak ekmeklerinden yediler. Oysa o ekmekten yemeye sadece rahiplerin izni vardı. ");
INSERT INTO turobt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ya da Tevratʼta hiç okumadınız mı, rahipler tapınakta hizmet ederken Şabat günü emrini çiğnerler ve bu onlara günah sayılmaz? ");
INSERT INTO turobt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Size şunu söylüyorum: burada tapınaktan daha önemli bir şey var. ");
INSERT INTO turobt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Kurban değil, merhamet istiyorum’ diyen ayetin anlamını bilseydiniz, suçsuz kişileri suçlu çıkarmazdınız. ");
INSERT INTO turobt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Çünkü İnsan Oğlu olarak ben Şabat gününün efendisiyim.” ");
INSERT INTO turobt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","İsa oradan ayrılınca, Yahudilerin toplantı yerine girdi. ");
INSERT INTO turobt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Orada eli sakat bir adam vardı. Bazıları İsaʼya, “Şabat günü şifa vermek Tevratʼa uygun mudur?” diye sordular. İsaʼyı suçlayacak bir sebep arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","İsa onlara şöyle cevap verdi: “Hangi biriniz Şabat günü çukura düşen koyununu oradan çekip çıkarmaz? ");
INSERT INTO turobt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","İnsan bir koyundan çok daha değerlidir! Bu nedenle Şabat günü iyilik yapmak Tevratʼa uygundur.” ");
INSERT INTO turobt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","İsa adama, “Elini uzat” dedi. Adam da elini uzattı ve eli öbür eli gibi sapasağlam oldu. ");
INSERT INTO turobt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ferisiler ise oradan uzaklaşınca İsaʼyı nasıl yok edecekleri konusunda plan kurmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ama İsa bunun farkındaydı ve oradan ayrıldı. Birçok kişi Oʼnun arkasından gitti; İsa da hepsini iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Fakat İsa kim olduğunu açıklamasınlar diye onları sıkı sıkıya uyardı. ");
INSERT INTO turobt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Öyle ki, peygamber Yeşayaʼnın ağzından söylenen şu söz yerine gelsin: ");
INSERT INTO turobt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“İşte Hizmetkârım, Oʼnu ben seçtim. Gönlümün hoşnut olduğu sevgili Hizmetkârım Oʼdur. Ruhumʼu Oʼnun üzerine koyacağım. O da adaleti milletlere bildirecek. ");
INSERT INTO turobt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O, kavga etmeyecek, bağırıp çağırmayacak. Sokakta kimse Oʼnun sesini duymayacak. ");
INSERT INTO turobt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Adaletin üstün gelmesini sağlayacak. O zamana kadar ezilmiş bir kamışı kırmayacak, tüten bir fitili de söndürmeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Diğer milletler Oʼnun adına umut bağlayacak.” ");
INSERT INTO turobt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ondan sonra İsaʼya cinli bir adam getirdiler. Adam hem kör, hem de dilsizdi. İsa onu iyileştirdi, öyle ki, kör ve dilsiz adam hem görmeye, hem de konuşmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Halk da şaşırıp kaldı. “Bu, Davudʼun oğlu olabilir mi?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama Ferisiler bunu işitince şöyle dediler: “Bu adam cinleri sadece cinlerin lideri Baalzevulʼun gücüyle kovuyor.” ");
INSERT INTO turobt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","İsa onların düşüncelerini bildiği için şöyle dedi: “İçinden bölünmüş olan her krallık yıkılır. İçinden bölünmüş şehir veya hane ayakta durmaz. ");
INSERT INTO turobt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Şeytan Şeytanʼı kovarsa, kendi içinden bölünmüş demektir. O zaman onun krallığı nasıl ayakta durur? ");
INSERT INTO turobt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Peki, ben cinleri Baalzevulʼun gücüyle kovuyorsam, o zaman sizin adamlarınız onları kimin gücüyle kovuyorlar? Bu durumda kendi adamlarınız sizi yargılayacak. ");
INSERT INTO turobt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama eğer ben cinleri Allahʼın Ruhuʼyla kovuyorsam, o zaman Allahʼın Krallığı aranıza gelmiş demektir. ");
INSERT INTO turobt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bir kişi nasıl güçlü bir adamın evine girip mallarını çalabilir? Ancak adamın elini kolunu bağladıktan sonra evini soyabilir. ");
INSERT INTO turobt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Benimle birlikte olmayan bana karşıdır. Benimle birlikte toplamayan, dağıtıyor demektir. ");
INSERT INTO turobt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bunun için size diyorum: insanların işlediği her günah ve ettiği her hakaret bağışlanacak. Ama Kutsal Ruhʼa edilen hakaret bağışlanmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kim İnsan Oğluʼnu kötülerse, o kişi bağışlanacak. Ama kim Kutsal Ruhʼu kötülerse o, ne bu dünyada, ne de gelecek dünyada asla bağışlanmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ağaca iyi bakarsanız iyi meyve verir, kötü bakarsanız kötü meyve verir. Ağaç meyvesinden tanınır. ");
INSERT INTO turobt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sizi yılan soyu sizi! Kötüyken nasıl iyi şeyler söyleyebilirsiniz? İnsanın kalbinde ne varsa ağzından o çıkar. ");
INSERT INTO turobt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","İyi insan iyilik dolu kalbinden iyi şeyler çıkarır. Kötü insan ise kötülük dolu kalbinden kötü şeyler çıkarır. ");
INSERT INTO turobt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Size şunu da söylüyorum: Dünyanın yargılandığı gün insanlar söyledikleri her boş laf için hesap verecekler. ");
INSERT INTO turobt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Çünkü sizi suçlu çıkaran da, haklı çıkaran da sözlerinizdir.” ");
INSERT INTO turobt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ondan sonra Tevrat uzmanları ve Ferisilerden bazıları İsaʼya şöyle dediler: “Öğretmenimiz, senden mucizevi bir işaret görmek istiyoruz.” ");
INSERT INTO turobt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","İsa onlara şöyle cevap verdi: “Kötü ve sadakatsiz kuşak mucizevi bir işaret istiyor. Ama bu kuşağa Peygamber Yunusʼun işaretinden başka bir işaret gösterilmeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus üç gün, üç gece deniz canavarının karnında kaldı. Aynı bunun gibi, İnsan Oğlu da üç gün üç gece yerin bağrında kalacak. ");
INSERT INTO turobt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninova halkı, dünyanın yargılanacağı günde bu kuşağın insanlarıyla birlikte ayağa kalkacak ve onları suçlu çıkaracak. Çünkü onlar Yunusʼun vaaz etmesi üzerine tövbe ettiler. Ama bakın, burada Yunusʼtan daha üstün olan bulunuyor. ");
INSERT INTO turobt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Güney Kraliçesi dünyanın yargılanacağı günde bu kuşakla birlikte kalkacak ve onu suçlu çıkaracak. Çünkü kraliçe, Süleymanʼın hikmetli sözlerini işitmek için dünyanın öbür ucundan geldi. Ama bakın, burada Süleymanʼdan daha üstün olan bulunuyor. ");
INSERT INTO turobt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Şeytani ruh insandan çıkınca susuz yerleri gezip rahat edeceği bir yer arar. ");
INSERT INTO turobt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Onu bulmayınca şöyle der: ‘Çıktığım eve geri döneceğim.’ Dönünce de evi boş, süpürülmüş ve toplanmış bulur. ");
INSERT INTO turobt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","O vakit gidip yanına kendisinden daha kötü olan yedi cin alır. Sonra eve geri dönüp onlarla oraya yerleşir. Böylece adamın son hali önceki halinden beter olur. Bu kötü kuşağın hali de böyle olacak.” ");
INSERT INTO turobt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","İsa daha halkla konuşurken Oʼnun annesiyle kardeşleri gelip dışarda durdular ve Oʼnunla konuşmak istediler. ");
INSERT INTO turobt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Biri İsaʼya, “Bak, annen ve kardeşlerin dışarda, seninle konuşmak istiyorlar” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ama İsa bunu söyleyen adama şöyle cevap verdi: “Kim benim annem? Kim benim kardeşlerim?” ");
INSERT INTO turobt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sonra eliyle öğrencilerini göstererek şöyle dedi: “İşte annem, işte kardeşlerim! ");
INSERT INTO turobt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Evet, gökte olan Babamʼın isteğini yerine getiren herkes kardeşim, kız kardeşim ve annemdir.” ");
INSERT INTO turobt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","O gün İsa evden çıkmış, gölün kenarında oturuyordu. ");
INSERT INTO turobt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Etrafına büyük bir kalabalık toplandı. Bu yüzden İsa bir tekneye binip oturdu. Kalabalık ise kıyıda duruyordu. ");
INSERT INTO turobt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Onlara benzetmelerle birçok şey anlattı. Şöyle dedi: “İşte, bir çiftçi ekin ekmeye gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ekerken bazı tohumlar yol kenarına düşmüş. Kuşlar gelip onları yemiş. ");
INSERT INTO turobt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bazı tohumlar az topraklı, taşlı yerlere düşmüş. Toprak derin olmadığı için hemen filizlenmeye başlamış. ");
INSERT INTO turobt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama güneş çıkınca, kavrulmuş. Yeteri kadar kök salamadıkları için kuruyup gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bazıları da dikenlerin arasına düşmüş. Dikenler büyüyünce, ekinleri boğmuş. ");
INSERT INTO turobt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bazı tohumlar ise iyi toprağa düşmüş, kimisi yüz kat, kimisi altmış kat, kimisi de otuz kat ürün vermiş. ");
INSERT INTO turobt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kulağı olan işitsin!” ");
INSERT INTO turobt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","İsaʼnın öğrencileri Oʼna gelip sordular: “Niçin halka benzetmelerle vaaz ediyorsun?” ");
INSERT INTO turobt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Onlara şöyle cevap verdi: “Sizlere Göklerin Krallığıʼnınsırlarını anlama gücü verildi. Ama onlara verilmedi. ");
INSERT INTO turobt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Çünkü kim sahip olduğu şeyleri kullanırsa, ona daha çok verilecek, bolluğa kavuşacak. Ama kim kullanmazsa, elindeki de alınacak. ");
INSERT INTO turobt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bunun için halka benzetmelerle vaaz ediyorum. Çünkü bakıp görmüyorlar; dinleyip işitmiyorlar, hem de anlamıyorlar. ");
INSERT INTO turobt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Onlar için Yeşaya Peygamberʼin şu sözü yerine geliyor: ‘Hep işiteceksiniz, ama hiç anlamayacaksınız. Hep bakacaksınız, ama hiç görmeyeceksiniz. ");
INSERT INTO turobt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Çünkü bu halkın yüreği duygusuz oldu. Kulakları zor işitiyor. Gözlerini kapadılar. Öyle olmasaydı, onların gözleri görür, kulakları işitir, yürekleri anlardı. Bana dönerlerdi, ben de onlara şifa verirdim.’ ");
INSERT INTO turobt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Fakat ne mutlu size! Çünkü gözleriniz görüyor, kulaklarınız işitiyor. ");
INSERT INTO turobt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Size doğrusunu söylüyorum: birçok peygamber ve iyi insan, sizin gördüklerinizi görmek istedi, ama görmedi. Duyduklarınızı duymak istedi, ama duymadı. ");
INSERT INTO turobt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Şimdi ekin eken çiftçi benzetmesinin anlamını dinleyin: ");
INSERT INTO turobt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Allahʼın Krallığı hakkındaki haberi işiten ama anlamayan bir kişi varsa, kötü olan gelip o adamın yüreğine ekilmiş olanı çalar. Yol kenarına ekilen tohum işte budur. ");
INSERT INTO turobt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Taşlı toprağa ekilen tohum da şudur: kişi, sözü işittiği zaman onu hemen sevinçle kabul eder. ");
INSERT INTO turobt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama kök salamadığı için sadece kısa bir zaman dayanır. Böyle biri Allahʼın sözü için eziyet ya da baskı görünce hemen iman yolundan döner. ");
INSERT INTO turobt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dikenler arasına ekilen tohum da şudur: kişi sözü işitir, ama dünyanın kaygıları ve zenginliğin göz boyaması sözü boğar, ve söz ürün vermez. ");
INSERT INTO turobt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bereketli toprağa ekilen tohum ise şudur: kişi sözü işitir ve anlar. O kişi gerçekten ürün verir: kimisi yüz kat, kimisi altmış kat, kimisi de otuz kat.” ");
INSERT INTO turobt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","İsa onlara başka bir benzetme anlattı: “Göklerin Krallığı, tarlasına iyi tohum eken adama benzer. ");
INSERT INTO turobt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ama insanlar uyurken, adamın düşmanı gelip ekinin arasına yabani ot ekip gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Fakat ekin filizlenip başaklar serpilince, yabani otlar da ortaya çıkmış. ");
INSERT INTO turobt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Toprak sahibinin köleleri ona gelip şunu sormuşlar: ‘Efendimiz, sen tarlana iyi tohum ekmedin mi? Nasıl oluyor da, onda şimdi yabani ot var?’ ");
INSERT INTO turobt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Adam onlara, ‘Bunu bir düşman yaptı’ demiş. Köleler de ona şunu sormuşlar: ‘O zaman gidip yabani otları sökmemizi ister misin?’ ");
INSERT INTO turobt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ama adam şöyle demiş: ‘Hayır, yabani otları toplarken, belki ekini de onlarla birlikte sökersiniz. ");
INSERT INTO turobt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bırakın, biçme vaktine kadar ikisi yan yana büyüsün. Biçme vakti gelince orakçılara, “Önce yabani otları toplayın, ve yakmak için onları demet yapın. Ekinleri ise, ambarıma toplayın” diyeceğim.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","İsa onlara bir benzetme daha anlattı: “Göklerin Krallığı bir hardal tohumuna benzer. Bir adam onu alıp tarlasına eker. ");
INSERT INTO turobt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hardal tohumu bütün öbür tohumlardan daha küçüktür. Ama büyüdükten sonra, bahçedeki bütün bitkilerden büyük olur. Ağaç kadar olunca kuşlar gelip onun dallarında yuva kurar.” ");
INSERT INTO turobt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","İsa onlara bir benzetme daha anlattı: “Göklerin Krallığı mayaya benzer. Kadın onu alıp üç büyük kap una karıştırır. En sonunda bütün hamur mayalanır.” ");
INSERT INTO turobt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","İsa bütün bu şeyleri kalabalıklara benzetmelerle anlattı. Benzetmeler kullanmadan onlara hiçbir şey anlatmazdı. ");
INSERT INTO turobt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Böylece Allahʼın peygamberin ağzından söylediği şu söz yerine geldi: “Konuştuğum zaman benzetmeler kullanacağım. Dünyanın kurulmasından bu yana gizli kalmış şeyleri anlatacağım.” ");
INSERT INTO turobt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","İsa kalabalıklardan uzaklaşıp bir eve girdi. Öğrencileri de Oʼna gelip “Bize o tarladaki yabani ot benzetmesini açıkla” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","İsa onlara şöyle cevap verdi: “İyi tohum eken adam İnsan Oğluʼdur. ");
INSERT INTO turobt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tarla dünyadır. İyi tohum, Krallığın evlatlarıdır, yabani otlar ise Şeytanʼın evlatlarıdır. ");
INSERT INTO turobt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Onları eken düşman İblisʼtir. Biçme zamanı dünyanın sonudur. Orakçılar da meleklerdir. ");
INSERT INTO turobt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nasıl yabani otları toplayıp ateşte yaktılarsa, dünyanın sonunda da aynı öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","İnsan Oğlu meleklerini gönderecek. Melekler, insanları yoldan saptıran her şeyi ve günah işleyen insanları Oʼnun Krallığıʼndan sökecekler. ");
INSERT INTO turobt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Onları ateşli fırına atacaklar. Orada ağlayıp dişlerini gıcırdatacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","O vakit doğru kişiler göksel Babalarıʼnın Krallığıʼnda güneş gibi parlayacaklar. Kulağı olan işitsin! ");
INSERT INTO turobt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Göklerin Krallığı tarlada gömülmüş bir hazineye benzer. Adamın biri onu bulunca saklamış. O kadar sevinmiş ki, gidip varını yoğunu satmış ve o tarlayı satın almış. ");
INSERT INTO turobt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yine Göklerin Krallığı güzel inciler arayan bir tüccara benzer. ");
INSERT INTO turobt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Çok değerli bir inci bulunca, adam gidip varını yoğunu satmış ve o inciyi satın almış. ");
INSERT INTO turobt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yine Göklerin Krallığı denize atıldığında her çeşit balık yakalayan balıkçı ağına benzer. ");
INSERT INTO turobt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ağ dolunca, onu kıyıya çekerler. Sonra oturup iyi balıkları kaplara koyarlar, ama işe yaramayanları atarlar. ");
INSERT INTO turobt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dünyanın sonunda da böyle olacak: melekler çıkıp kötüleri iyilerden ayıracaklar. ");
INSERT INTO turobt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kötüleri ateşli fırına atacaklar. Orada ağlayıp dişlerini gıcırdatacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bütün bunları anladınız mı?” İsaʼya, “Evet” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","İsa onlara şöyle dedi: “Bunun için, Göklerin Krallığıʼnınöğrencisi olan her Tevrat uzmanı, ambarından hem yeni, hem de eski şeyler çıkaran ev sahibine benzer.” ");
INSERT INTO turobt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","İsa bu benzetmeleri bitirince oradan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kendi memleketine geldi ve Yahudilerin toplantı yerinde vaaz etmeye başladı. Dua evindekiler hayret içinde şöyle dediler: “Bu adam bu hikmeti ve mucize yapma gücünü nereden aldı? ");
INSERT INTO turobt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bu, marangozun oğlu değil mi? Annesinin adı Meryem değil mi? Kardeşleri Yakub, Yusuf, Simun ve Yahuda değil mi? ");
INSERT INTO turobt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kız kardeşleri aramızda değil mi? Madem öyle, bu adam bütün bu şeyleri nereden alıyor?” ");
INSERT INTO turobt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Böylece gücenip İsaʼyı reddettiler. Ama İsa onlara şöyle dedi: “Bir peygamberin saygı görmediği tek yer kendi memleketi ve ailesidir.” ");
INSERT INTO turobt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Onların imansızlığı yüzünden orada fazla mucize yapmadı. ");
INSERT INTO turobt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","O arada bölge Kralı Hirodes İsa hakkındaki haberi duydu. ");
INSERT INTO turobt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Adamlarına şöyle dedi: “Bu Vaftizci Yahyaʼdır! Ölümden dirildi! İşte o yüzden bu mucizeleri yapma gücüne sahip.” ");
INSERT INTO turobt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hirodes, kardeşi Filipusʼun karısı Hirodiya yüzünden Yahyaʼyı yakalatıp bağlamış ve hapishaneye atmıştı. ");
INSERT INTO turobt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Çünkü Yahya ona şöyle derdi: “Kardeşinin karısıyla birleşmen Tevratʼa aykırıdır.” ");
INSERT INTO turobt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aslında Hirodes Yahyaʼyı öldürtmek istiyordu, ama halkın tepkisinden korkuyordu. Çünkü onlar Yahyaʼyı peygamber sayıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hirodesʼin doğum günü gelince, Hirodiyaʼnın kızı ortaya çıkıp göbek attı. Bu da Hirodesʼin hoşuna gitti. ");
INSERT INTO turobt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yemin ederek her ne dilerse ona vereceğine söz verdi. ");
INSERT INTO turobt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kız annesinin kışkırtmasıyla şöyle dedi: “Bana bir tepsi üzerinde Vaftizci Yahyaʼnın kafasını getir.” ");
INSERT INTO turobt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kral buna üzüldü. Ama sofra başındaki misafirlerin önünde yemin etmişti. Bu yüzden dileğin yerine getirilmesini buyurdu. ");
INSERT INTO turobt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Haber yollayıp hapishanede Yahyaʼnın kafasını kestirdi. ");
INSERT INTO turobt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kafayı tepsi üzerinde getirip kıza verdiler, kız da onu annesine götürdü. ");
INSERT INTO turobt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yahyaʼnın öğrencileri geldiler ve Yahyaʼnın cesedini alıp gömdüler. Sonra gidip İsaʼya haber verdiler. ");
INSERT INTO turobt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","İsa bunu işitince oradan çekildi. Öğrencileriyle baş başa kalmak için tekneyle ıssız bir yere gitti. Halk bunu öğrenince kasabalardan çıkıp karadan yürüyerek İsaʼnın ardından gitti. ");
INSERT INTO turobt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","İsa tekneden inince büyük bir kalabalık gördü. Onlara acıdı ve onların hastalarını iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Akşam olunca öğrencileri Oʼnun yanına gelip şöyle dediler: “Burası ıssız bir yer, hem de vakit çok ilerledi. Halkı gönder de, etraftaki köylere gitsinler, kendilerine yiyecek alsınlar.” ");
INSERT INTO turobt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ama İsa onlara, “Gitmeleri lazım değil. Onlara siz yiyecek verin!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","İsaʼya, “Burada yalnız beş ekmekle iki balığımız var” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","İsa, “Onları bana buraya getirin” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Halka çayırlığa oturmalarını emretti. Sonra beş ekmekle iki balığı aldı, gözlerini göğe kaldırarak şükretti. Ekmekleri bölüp öğrencilerine verdi. Öğrencileri de ekmekleri halka dağıttılar. ");
INSERT INTO turobt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Herkes yiyip doydu. Artakalan parçaları topladılar ve onlarla on iki sepet doldurdular. ");
INSERT INTO turobt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kadın ve çocukların dışında yemek yiyen aşağı yukarı beş bin kişi vardı. ");
INSERT INTO turobt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","İsa hemen öğrencilerine tekneye bindirdi. Onları kendisinden önce gölün öbür tarafına gönderdi. O arada halkı evlerine gönderecekti. ");
INSERT INTO turobt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Halkı yolcu ettikten sonra, dua etmek için tek başına bir tepeye çıktı. Akşam olunca orada yalnız kaldı. ");
INSERT INTO turobt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tekne ise, karadan epey uzakta, dalgalarla boğuşuyordu. Çünkü rüzgar karşı yönden esiyordu. ");
INSERT INTO turobt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sabaha doğru İsa gölün üstünde yürüyüp onlara yaklaştı. ");
INSERT INTO turobt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Öğrenciler Oʼnun gölün üstünde yürüdüğünü görünce dehşete kapıldılar. “Bu bir hayalettir!” diye korkudan bağırmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","İsa ise hemen onlara, “Rahat olun! Benim! Korkmayın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus Oʼna şöyle cevap verdi: “Efendimiz eğer sensen, bana buyruk ver de, su üstünde yürüyerek sana geleyim.” ");
INSERT INTO turobt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","İsa, “Gel” dedi. Petrus tekneden inip suyun üzerinde yürüdü ve İsaʼya doğru ilerledi. ");
INSERT INTO turobt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama güçlü rüzgarı fark edince, korktu ve batmaya başladı. “Efendimiz, kurtar beni!” diye bağırdı. ");
INSERT INTO turobt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","İsa hemen elini uzatıp onu tuttu ve, “Ey kıt imanlı adam! Niçin şüphe ettin?” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tekneye bindiler ve rüzgar dindi. ");
INSERT INTO turobt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Teknedekiler İsaʼya tapındılar. “Sen gerçekten Allahʼın Oğluʼsun!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Gölü geçip, Ginnesar taraflarında karaya vardılar. ");
INSERT INTO turobt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Oranın halkı İsaʼyı tanıdı. Hemen etraftaki bölgelere haber yolladılar. İsaʼya hasta olan herkesi getirdiler. ");
INSERT INTO turobt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hastalar İsaʼnın sadece elbisesinin eteğine dokunabilmek için yalvardılar. Oʼna dokunan herkes şifa buldu. ");
INSERT INTO turobt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Daha sonra Yeruşalimʼden bazı Ferisiler ve Tevrat uzmanları İsaʼya geldiler ve şöyle dediler: ");
INSERT INTO turobt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Öğrencilerin neden atalarımızın adetlerini bozuyorlar? Yemekten önce ellerini din adetine göre yıkamıyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ama İsa onlara şöyle cevap verdi: “Ya siz? Siz kendi adetleriniz uğruna niçin Allahʼın buyruğunu çiğniyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Çünkü Allah şöyle buyurdu: ‘Annenize babanıza saygı gösterin’ ve ‘Kim annesini ve babasını aşağılarsa, ölüm cezasını hak eder.’ ");
INSERT INTO turobt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sizler ise şöyle diyorsunuz: ‘Kim annesine ya da babasına “Sana yardım etmek için vereceğim şeyleri Allahʼa adadım” derse, ");
INSERT INTO turobt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","o kişi annesine ve babasına saygı göstermeye mecbur değildir.’ Böylece kendi adetleriniz yüzünden Allahʼın sözünü geçersiz kılıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sizi ikiyüzlüler sizi! Peygamber Yeşaya hakkınızda ne kadar doğru konuştu: ");
INSERT INTO turobt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Allah diyor ki, ‘Bu halk beni dudaklarıyla sayıyor, ama yürekleri benden uzaktır. ");
INSERT INTO turobt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Boşuna bana tapıyorlar. Vaaz ettikleri, insan buyruklarıdır.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","İsa kalabalığı yanına çağırıp onlara şöyle dedi: “İşitin ve anlayın! ");
INSERT INTO turobt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ağza giren hiçbir şey insanı kirletmez. İnsanı kirleten şey ağızdan çıkandır.” ");
INSERT INTO turobt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","O zaman öğrencileri İsaʼya gelip şöyle dediler: “Biliyor musun, Ferisiler bu sözü işitince darıldılar?” ");
INSERT INTO turobt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","İsa onlara şöyle cevap verdi: “Gökteki Babamʼın dikmediği her fidan kökünden sökülecek. ");
INSERT INTO turobt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bırakın gitsinler. Onlar kör insanların kör rehberleridir. Kör adam başka bir kör adama yol gösterirse, ikisi de çukura düşer.” ");
INSERT INTO turobt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus İsaʼya, “Bu benzetmeyi bize açıklar mısın?” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","İsa şöyle konuştu: “Siz de mi hâlâ anlamıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aklınız ermiyor mu? Ağza giren her şey mideye iner, oradan da dışarı atılır? ");
INSERT INTO turobt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama ağızdan çıkan şeyler yürekten gelir. İşte, insanı kirleten onlardır. ");
INSERT INTO turobt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Çünkü kötü düşünceler insanın yüreğinden çıkar. Bunlar, adam öldürme, zina, evlilik dışı seksüel ilişkiler, hırsızlık, yalancı şahitlik ve iftiralara yol açar. ");
INSERT INTO turobt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","İnsanı kirleten şeyler bunlardır. Ama ellerini din adetine göre yıkamadan yemek yemek insanı kirletmez.” ");
INSERT INTO turobt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","İsa oradan çekilip Sur ve Sayda taraflarına gitti. ");
INSERT INTO turobt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Oralardan Kenanlı bir kadın gelip İsaʼya yüksek sesle yalvardı: “Efendimiz, ey Davud Oğlu, bana merhamet et! Kızım cine tutuldu, çok acı çekiyor.” ");
INSERT INTO turobt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Fakat İsa ona hiç cevap vermedi. Öğrencileri de İsaʼya gelip şöyle rica ettiler: “Kadını sal gitsin, çünkü arkamızdan bağırıp duruyor.” ");
INSERT INTO turobt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ama İsa şöyle dedi: “Ben sadece İsrail halkına gönderildim. Onlar kaybolmuş koyunlar gibidir.” ");
INSERT INTO turobt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kadın ise gelip İsaʼnın önünde yere kapandı ve “Efendimiz, bana yardım et!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","İsa ona şöyle cevap verdi: “Çocukların ekmeğini alıp köpeklerin önüne atmak doğru değil.” ");
INSERT INTO turobt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kadın da, “Evet, Efendimiz, öyle. Ama köpekler bile, efendilerinin masasından düşen ekmek kırıntılarını yer” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","O zaman İsa ona şöyle cevap verdi: “İmanı büyük bir kadınsın! İstediğin gibi olsun.” O anda kadının kızı iyileşti. ");
INSERT INTO turobt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","İsa oradan ayrılıp Celile Gölüʼnün kenarına gitti. Sonra bir tepeye çıkıp oturdu. ");
INSERT INTO turobt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Büyük kalabalıklar Oʼna geldi. Topal, sakat, kör, dilsiz olanları ve daha bir sürü hastayı getirdiler. Onları İsaʼnın ayaklarının dibine yatırdılar. İsa da onları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dilsizler konuşmaya başladı, sakatlar iyileşti, topallar yürüdü ve körler gördü. İnsanlar bunu görünce, şaşırıp kaldılar ve İsrail halkının tapındığı Allahʼı övdüler. ");
INSERT INTO turobt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","İsa öğrencilerini yanına çağırıp şöyle dedi: “Halka acıyorum. Üç gündür, yanımdalar ve yiyecek bir şeyleri yok. Yolda bayılmasınlar diye onları aç karnına göndermek istemiyorum.” ");
INSERT INTO turobt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Öğrencileri Oʼna, “Böyle ıssız bir yerde bu kalabalığı doyuracak ekmeği nereden bulalım?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","İsa onlara, “Kaç ekmeğiniz var?” dedi. “Yedi ekmekle birkaç küçük balık” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","İsa kalabalığa yere oturmalarını emretti. ");
INSERT INTO turobt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yedi ekmeği ve balıkları alıp şükretti. Bunları bölüp öğrencilerine verdi. Öğrencileri de onları kalabalığa dağıttılar. ");
INSERT INTO turobt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Herkes yiyip doydu. Yemek artıklarından yedi sepet dolusu toplandı. ");
INSERT INTO turobt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kadınlar ve çocuklar sayılmazsa yemek yiyenler aşağı yukarı dört bin kişiydi. ");
INSERT INTO turobt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","İsa halkı gönderdikten sonra bir tekneye binip Magadan topraklarına geçti. ");
INSERT INTO turobt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ferisiler ve Sadukiler İsaʼya geldiler. Oʼnu denemek için kendilerine gökten mucizevi bir işaret göstermesini istediler. ");
INSERT INTO turobt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","İsa onlara şöyle cevap verdi: “Akşam olunca, ‘Gökyüzü kırmızı, demek ki hava güzel olacak’ diyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sabah olunca, ‘Gökyüzü kırmızı ve bulutlu, demek ki bugün fırtına çıkacak’ diyorsunuz. Gökyüzünün görünüşünden bir anlam çıkarabiliyorsunuz da, yaşadığınız bu zamanın işaretlerinden bir anlam çıkaramıyor musunuz? ");
INSERT INTO turobt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kötü ve sadakatsiz kuşak mucizevi bir işaret istiyor. Ama bu kuşağa Peygamber Yunusʼun işaretinden başka bir işaret gösterilmeyecek.” Sonra İsa onları bırakıp gitti. ");
INSERT INTO turobt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","İsaʼnın öğrencileri gölün öbür tarafına geçtiler. Fakat yanlarına ekmek almayı unutmuşlardı. ");
INSERT INTO turobt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","İsa onlara şöyle dedi: “Dikkat edin, Ferisilerin ve Sadukilerin mayasından sakının!” ");
INSERT INTO turobt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Öğrenciler aralarında tartışmaya başladılar. “Ekmek almadık diye öyle konuşuyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","İsa bunu fark edince onlara şöyle dedi: “Ey imanı kıt olanlar! Neden ekmeğimiz yok diye tartışıp duruyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Daha anlamıyor musunuz? Beş ekmekle beş bin kişinin doyduğunu hatırlamıyor musunuz? Kaç sepet topladınız? ");
INSERT INTO turobt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yedi ekmekle dört bin kişinin doyduğunu da mı hatırlamıyorsunuz? O zaman kaç sepet topladınız? ");
INSERT INTO turobt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ekmek hakkında konuşmadım. Nasıl olur da bunu anlamıyorsunuz? Hayır, Ferisilerin ve Sadukilerin mayasından sakının!” ");
INSERT INTO turobt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","O vakit anladılar ki, İsa ekmek mayasından değil de, Ferisilerin ve Sadukilerin öğrettikleri şeylerden sakınmalarını söylüyordu. ");
INSERT INTO turobt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","İsa, Filipus Sezariyesi topraklarına gitti. Orada öğrencilerine şunu sordu: “İnsanlar İnsan Oğluʼnun kim olduğunu söylüyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Oʼna şöyle cevap verdiler: “Kimisi ‘Vaftizci Yahya’ diyor. Kimisi de ‘İlyas’ diyorlar. Diğerleri de ‘Yeremya,’ ya da ‘eski peygamberlerden biri’ diyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","İsa onlara sordu: “Ya siz? Sizce ben kimim?” ");
INSERT INTO turobt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simun Petrus da şöyle cevap verdi: “Sen Mesihʼsin. Diri olan Allahʼın Oğluʼsun.” ");
INSERT INTO turobt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","İsa ona cevap olarak şöyle dedi: “Ne mutlu sana, ey Yunus oğlu Simun! Çünkü bunu sana açıklayan insan değil, göklerde olan Babamʼdır. ");
INSERT INTO turobt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sana şunu söylüyorum: sen Petrusʼsun. Bu kayanın üzerine topluluğumu kuracağım ve ölüler dünyasının kapıları bile ona karşı direnemeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Göklerin Krallığıʼnın anahtarlarını sana vereceğim. Yeryüzünde bağladığın her şey gökte de bağlanmış olacak. Yeryüzünde çözdüğün her şey gökte de çözülmüş olacak.” ");
INSERT INTO turobt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sonra İsa, kendisinin Mesih olduğunu kimseye söylemesinler diye öğrencilerini uyardı. ");
INSERT INTO turobt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bundan sonra İsa öğrencilerine Yeruşalimʼe gitmesi gerektiğini açıklamaya başladı. Orada liderler, başrahipler ve Tevrat uzmanlarının elinden çok acı çekmesi, öldürülmesi ve üçüncü gün ölümden dirilmesi gerektiğini söyledi. ");
INSERT INTO turobt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrus İsaʼyı bir kenara çekip azarlamaya başladı: “Efendimiz, Allah korusun! Öyle bir şey asla başına gelmeyecek!” ");
INSERT INTO turobt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama İsa dönüp Petrusʼa şöyle dedi: “Çekil önümden, Şeytan! Sen bana kösteksin. Çünkü düşüncelerin Allahʼtan değil, insandandır.” ");
INSERT INTO turobt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sonra İsa öğrencilerine şöyle dedi: “Bir kişi peşimden gelmek isterse, kendini gözden çıkarsın, çarmıhını yüklensin ve yolumu tutsun. ");
INSERT INTO turobt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Çünkü kim canını kurtarmak isterse onu kaybedecek. Ama kim canını benim uğruma kaybederse, onu bulacak. ");
INSERT INTO turobt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bir kişi bütün dünyayı kazanır, ama canını kaybederse, bunun kendisine ne faydası olur? İnsan kendi canına karşılık olarak ne verebilir? ");
INSERT INTO turobt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ben İnsan Oğlu olarak Babamʼın yüceliği içinde meleklerimle geleceğim ve her bir insana yaptıklarına göre karşılık vereceğim. ");
INSERT INTO turobt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Size doğrusunu söylüyorum: burada duran bazı kişiler İnsan Oğluʼnun kendi krallığıyla geldiğini görmeden ölümü tatmayacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Altı gün sonra İsa, Petrusʼu, Yakubʼu ve Yakubʼun kardeşi Yuhannaʼyı yanına aldı. Onları yüksek bir dağın tepesine çıkardı. Orada yalnızdılar. ");
INSERT INTO turobt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Önlerinde İsaʼnın görünüşü tamamen değişti. Yüzü güneş gibi parlamaya başladı. Elbiseleri de ışık gibi bembeyaz oldu. ");
INSERT INTO turobt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","O anda Musaʼyla İlyas öğrencilere göründü. İsaʼyla konuşuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bunun üzerine Petrus İsaʼya şöyle dedi: “Efendimiz, iyi ki buradayız. İstersen, burada üç çardak kurayım: biri senin için, biri Musa için, biri de İlyas için.” ");
INSERT INTO turobt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O daha konuşurken, işte, parlak bir bulut onların üstüne gölge yaptı. Bulutun içinden bir ses şöyle dedi: “Sevgili Oğlum budur, Oʼndan memnunum. Oʼnu dinleyin!” ");
INSERT INTO turobt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Öğrenciler bunu işitince çok korktular ve yere kapandılar. ");
INSERT INTO turobt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","İsa gelip onlara dokundu ve “Kalkın, korkmayın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Başlarını kaldırıp bakınca İsaʼdan başka kimseyi görmediler. ");
INSERT INTO turobt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dağdan inerlerken İsa onlara şöyle emretti: “İnsan Oğlu ölümden dirilene kadar, gördüklerinizi kimseye anlatmayın.” ");
INSERT INTO turobt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Öğrencileri İsaʼya şunu sordular: “Peki Tevrat uzmanları neden, ‘Önce İlyas gelmeli’ diyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O da onlara şöyle cevap verdi: “Evet, İlyas gelecek ve her şeyi yeniden düzene koyacak. ");
INSERT INTO turobt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama ben size diyorum: İlyas zaten geldi. Onu tanımadılar. Ona istedikleri gibi yaptılar. İnsan Oğlu da bunun gibi onların elinden acı çekecek.” ");
INSERT INTO turobt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","O vakit öğrenciler İsaʼnın Vaftizci Yahya hakkında konuştuğunu anladılar. ");
INSERT INTO turobt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","İsaʼyla üç öğrencisi halkın yanına dönünce adamın biri İsaʼya gelip önünde diz çöktü ve şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Efendimiz, çocuğuma merhamet et. O saralıdır ve çok acı çekiyor. Sık sık ateşe ya da suya düşüyor. ");
INSERT INTO turobt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Oğlumu senin öğrencilerine getirdim, ama onu iyileştiremediler.” ");
INSERT INTO turobt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","İsa cevap olarak şöyle dedi: “Ey imansız ve yoldan sapmış kuşak! Ne zamana kadar sizinle beraber olacağım? Ne zamana kadar size katlanacağım? Çocuğu buraya, bana getirin.” ");
INSERT INTO turobt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","İsa cini azarladı, o da çocuktan çıktı. Çocuk da aynı anda iyileşti. ");
INSERT INTO turobt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sonra İsa yalnızken öğrencileri Oʼna gelip, “Biz cini neden kovamadık?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","İsaʼnın onlara cevabı şuydu: “İmanınız yetersiz de, ondan. Size doğrusunu söylüyorum: hardal tohumu kadar imanınız olsa, şu dağa ‘Buradan kalk, oraya git’ dersiniz, o da gider. Sizin için hiçbir şey imkansız olmayacak.” ");
INSERT INTO turobt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Celile bölgesinde bir araya geldiklerinde İsa öğrencilerine şöyle dedi: “İnsan Oğlu yakın bir zamanda insanların eline teslim edilecek. ");
INSERT INTO turobt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Oʼnu öldürecekler, ama O üçüncü gün ölümden dirilecek.” Öğrenciler bu söze çok üzüldüler. ");
INSERT INTO turobt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","İsaʼyla öğrencileri Kefernahumʼa geldiler. Orada iki dirhemlik tapınak vergisini toplayan memurlar Petrusʼa gelip şunu sordular: “Öğretmeniniz iki dirhemi ödemiyor mu?” ");
INSERT INTO turobt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus, “Ödüyor” dedi. Petrus eve gelince, İsa hemen onunla konuşmaya başladı: “Simun, ne diyorsun? Sence dünyadaki krallar kimden gümrük ya da vergi alıyorlar, kendi evlatlarından mı, yoksa yabancılardan mı?” ");
INSERT INTO turobt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus, “Yabancılardan” diye cevap verdi. Bunun üzerine İsa ona, “Demek, evlatlar vergiden serbesttir” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Fakat vergi toplayanları gücendirmeyelim. Göle git, oltayı at ve tuttuğun ilk balığın ağzını aç. Orada dört dirhemlik bir para bulacaksın. Bu parayı al, hem kendin hem de benim için onlara ver.” ");
INSERT INTO turobt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","O sırada öğrencileri İsaʼya gelip şunu sordular: “Acaba Göklerin Krallığıʼnda en önemli kimdir?” ");
INSERT INTO turobt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","İsa bir çocuğu çağırıp onu aralarına aldı. ");
INSERT INTO turobt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sonra şöyle dedi: “Size doğrusunu söylüyorum: Siz bu fikrinizden dönüp çocuklar gibi olmazsanız, Göklerin Krallığıʼna asla girmeyeceksiniz. ");
INSERT INTO turobt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bunun için, her kim bu çocuk gibi alçakgönüllü davranırsa, Göklerin Krallığıʼnda en büyük odur. ");
INSERT INTO turobt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Her kim böyle bir çocuğu benim adıma kabul ederse, o beni kabul etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ama bana iman eden bu küçüklerden birini yoldan saptıran kişinin vay haline! Boynuna büyük bir değirmen taşı bağlanması ve denizin dibine atılıp boğulması kendisi için daha iyi olur. ");
INSERT INTO turobt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","İnsanları yoldan saptıran tuzaklar yüzünden vay dünyanın haline! Bu tuzakların ortaya çıkması kaçınılmazdır. Ama bu tuzaklara sebep olan kişinin vay haline! ");
INSERT INTO turobt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Elin ya da ayağın seni iman yolundan saptırırsa, onu kes at! İki elinle veya iki ayağınla hiç sönmeyen ateşe atılmaktansa, tek el ya da tek ayakla sonsuz yaşama kavuşmak senin için daha iyidir! ");
INSERT INTO turobt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Gözün seni iman yolundan saptırırsa onu çıkar at! Senin için tek gözle sonsuz yaşama kavuşmak iki gözle cehennem ateşine atılmaktan daha iyidir. ");
INSERT INTO turobt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Bu küçüklerden birini bile sakın hor görmeyin. Çünkü size söylüyorum, onların gökteki melekleri devamlı göksel Babamʼın yüzünü görürler. ");
INSERT INTO turobt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ne dersiniz? Bir adamın yüz koyunu varsa ve onlardan bir tanesi yolunu şaşırırsa, adam doksan dokuzu tepede bırakıp yolunu şaşıran koyunu aramaya gitmez mi? ");
INSERT INTO turobt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Size doğrusunu söylüyorum, eğer onu bulursa, o koyun için, yolunu şaşırmamış doksan dokuz koyundan daha fazla sevinecek. ");
INSERT INTO turobt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aynı bunun gibi, gökteki Babanız bu küçüklerden birinin yok olmasını istemez. ");
INSERT INTO turobt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","İmanlı kardeşin sana karşı günah işlerse, gidip ona suçunu göster. Mesele ikinizin arasında kalsın. Seni dinlerse, kardeşini kazanmış olursun. ");
INSERT INTO turobt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama seni dinlemezse, yanına bir ya da iki kişi daha al. Öyle ki, ‘Her suçlama iki ya da üç kişinin şahitliğiyle desteklensin.’ ");
INSERT INTO turobt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kardeş onları dinlemek istemezse, meseleyi imanlılar topluluğuna bildir. Topluluğu bile dinlemek istemezse, onu putperest ya da vergi memuru gibi say. ");
INSERT INTO turobt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Size doğrusunu söylüyorum ki, yeryüzünde bağladığınız her şey, gökte de bağlanmış olacak. Yeryüzünde çözdüğünüz her şey gökte de çözülmüş olacak. ");
INSERT INTO turobt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Size şunu da söylüyorum: yeryüzünde sizden iki kişi bir şey dilerse ve o konuda aynı fikirde olurlarsa, gökteki Babam onların dilediğini yapacak. ");
INSERT INTO turobt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Çünkü iki ya da üç kişi nerede benim adımı anarak bir araya gelirlerse, ben oradayım, onların arasındayım.” ");
INSERT INTO turobt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sonra Petrus İsaʼya gelip şöyle dedi: “Efendimiz, imanlı kardeşim bana karşı kaç defa günah işlerse onu bağışlamalıyım? Yedi kereye kadar mı?” ");
INSERT INTO turobt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","İsa ona şöyle dedi: “Ben sana diyorum ki, yedi kere değil, yetmiş kere yediye kadar. ");
INSERT INTO turobt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bu konuda bir örnek vereyim: Göklerin Krallığı, görevlileriyle hesap görmek isteyen bir kral gibidir. ");
INSERT INTO turobt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hesapları görürken krala dünya kadar borcu olan bir köle getirmişler. ");
INSERT INTO turobt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Adamın borcunu ödeyecek bir şeyi yokmuş. Efendisi ise borcun ödenmesi için adamın karısı, çocukları ve bütün mallarıyla birlikte satılmasını emretmiş. ");
INSERT INTO turobt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bunun üzerine köle, kralın önünde yere kapanıp yalvarmaya başlamış: ‘Ne olur, azıcık daha dayan, sana bütün borcumu öderim.’ ");
INSERT INTO turobt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kölenin efendisi ona acımış. Onu serbest bırakıp bütün borcunu silmiş. ");
INSERT INTO turobt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Fakat köle çıkıp hizmet arkadaşlarından birini bulmuş. Arkadaşının ona yüz gümüş para borcu varmış. Köle arkadaşını yakasından tutup boğmaya başlamış. ‘Borcunu öde!’ demiş. ");
INSERT INTO turobt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bunun üzerine arkadaşı yere kapanıp köleye yalvarmaya başlamış: ‘Ne olur, azıcık daha dayan. Sana borcumu ödeyeceğim.’ ");
INSERT INTO turobt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Fakat köle razı gelmemiş. Gidip hizmet arkadaşını borcunu ödeyene kadar hapishaneye attırmış. ");
INSERT INTO turobt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kölenin diğer arkadaşları olanları görünce çok üzülmüşler ve gidip efendilerine olup biten her şeyi ayrıntılı olarak anlatmışlar. ");
INSERT INTO turobt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Efendisi köleyi çağırtmış ve ona şöyle demiş: ‘Seni namussuz köle seni! Bana yalvardın diye, senin bütün borcunu sildim. ");
INSERT INTO turobt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Benim sana merhamet ettiğim gibi, senin de hizmet arkadaşına merhamet etmen lazımdı, değil mi?’ ");
INSERT INTO turobt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Efendisi çok öfkelenmiş. Bütün borcunu ödeyene kadar köleyi işkencecilere teslim etmiş. ");
INSERT INTO turobt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Her biriniz kardeşini yürekten bağışlamazsa, gökteki Babam da aynısını size yapacak.” ");
INSERT INTO turobt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","İsa bu konuşmayı bitirdikten sonra Celileʼden ayrıldı ve Şeria Irmağıʼnın öte tarafındaki Yahudiye topraklarına gitti. ");
INSERT INTO turobt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Büyük kalabalıklar Oʼnun arkasından gidiyordu. İsa orada onların hastalarını iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bazı Ferisiler gelip İsaʼyı denemek için şunu sordular: “Acaba erkeğin karısını herhangi bir sebep için boşaması Tevratʼa uygun mudur?” ");
INSERT INTO turobt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","İsa da onlara şöyle cevap verdi: “Yaradan başlangıçta insanları erkek ve kadın olarak yarattı. Bunu Tevratʼta okumadınız mı? ");
INSERT INTO turobt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Allah şöyle dedi: ‘Bunun için adam annesini ve babasını bırakacak, karısına bağlanacak ve ikisi bir beden olacak.’ ");
INSERT INTO turobt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Şöyle ki, onlar artık iki değil, bir bedendirler. Bu sebeple, Allahʼın birleştirdiğini insan ayırmasın.” ");
INSERT INTO turobt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ferisiler İsaʼya, “Madem öyle” dediler, “Musa neden erkek boşanma kâğıdı vererek karısını boşayabilir diye buyurdu?” ");
INSERT INTO turobt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","İsa onlara şöyle dedi: “Musa inatçılığınız yüzünden karılarınızı boşamanıza izin verdi. Ama en başta bu böyle değildi. ");
INSERT INTO turobt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ben size diyorum ki, her kim karısını evlilik dışı seksüel ilişkiden başka bir sebeple boşayıp başka kadınla evlenirse, o kişi zina işlemiş olur.” ");
INSERT INTO turobt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Öğrencileri İsaʼya, “Madem erkekle karısının durumu böyledir, hiç evlenmemek daha iyi” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","İsa da onlara şöyle dedi: “Herkes bu dediklerimi kabul edemez. Sadece bunları anlama yeteneği verilenler kabul edebilir. ");
INSERT INTO turobt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Evlenemeyen erkeklerin bazıları kusurlu doğup evlenemezler. Bazıları insan tarafından evlenemez hale getirilirler. Bazıları da Göklerin Krallığı için bekâr kalmaya karar verirler. Bunu kabul edebilen, kabul etsin.” ");
INSERT INTO turobt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oradakiler çocuklarını İsaʼya getirdiler. İsaʼdan onlara dokunup dua etmesini istediler. İsaʼnın öğrencileri çocukları getirenleri azarladılar. ");
INSERT INTO turobt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Fakat İsa şöyle dedi: “Bırakın, çocuklar bana gelsin. Onlara engel olmayın! Çünkü Göklerin Krallığı çocuklar gibi olanlarındır.” ");
INSERT INTO turobt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Elleriyle dokunup çocuklara bereket diledikten sonra oradan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","İşte, birisi İsaʼya gelip şunu sordu: “Öğretmenim, sonsuz yaşama sahip olmak için nasıl bir iyilik yapmalıyım?” ");
INSERT INTO turobt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","İsa ona şöyle dedi: “İyilik hakkında neden bana soruyorsun? İyi olan yalnız biri var. Sonsuz yaşama kavuşmak istiyorsan, Allahʼın buyruklarını yerine getir.” ");
INSERT INTO turobt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Adam İsaʼya, “Hangilerini?” diye sordu. İsa ona şöyle cevap verdi: “Adam öldürmeyin, zina etmeyin, çalmayın, yalan yere şahitlik etmeyin. ");
INSERT INTO turobt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Annenize babanıza saygı gösterin ve komşunuzu kendinizi sevdiğiniz gibi sevin.” ");
INSERT INTO turobt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Genç adam İsaʼya, “Bütün bunları hep yerine getirdim. Daha ne eksiğim var?” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","İsa ona şöyle cevap verdi: “Eğer eksiksiz olmak istersen, git mallarını sat ve parasını fakirlere ver. O zaman gökte hazinen olacak. Sonra gel, benim peşime düş.” ");
INSERT INTO turobt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Genç adam bu sözü işitince üzüntü içinde ayrıldı, çünkü malı mülkü çoktu. ");
INSERT INTO turobt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","İsa öğrencilerine şöyle dedi: “Size doğrusunu söylüyorum: zengin bir kişinin Göklerin Krallığıʼna girmesi zordur! ");
INSERT INTO turobt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Size tekrar söylüyorum: Bir devenin iğne deliğinden geçmesi, zengin bir insanın Allahʼın Krallığıʼna girmesinden daha kolaydır.” ");
INSERT INTO turobt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Öğrenciler bunu duyunca çok hayret ettiler. “Öyleyse, kim kurtulabilir?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","İsa onlara dikkatle bakıp şöyle dedi: “İnsan için bu imkansız, fakat Allah için her şey mümkündür.” ");
INSERT INTO turobt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sonra Petrus söz alıp İsaʼya şöyle dedi: “Bak, biz her şeyi bıraktık, senin peşine düştük. Peki, karşılığımız ne olacak?” ");
INSERT INTO turobt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","İsa onlara şöyle dedi: “Size doğrusunu söylüyorum: her şey yenilendiği zaman İnsan Oğlu görkemli tahtına oturacak. O vakit benim peşimden gelen sizler de on iki tahta oturup İsrail halkının on iki oymağını yargılayacaksınız. ");
INSERT INTO turobt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Benim uğruma evlerini, kardeşlerini, kız kardeşlerini, babasını, annesini, çocuklarını ya da tarlalarını bırakmış olan herkes, onları yüz kat geri alacak ve sonsuz yaşamı da miras alacak. ");
INSERT INTO turobt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Fakat şimdi birinci olan birçokları sonuncu, sonuncu olan birçokları da birinci olacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Göklerin Krallığı bir bağ sahibine benzer. Adam sabah erkenden üzüm bağına işçi tutmaya gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","İşçilerle günlüğü bir gümüş paraya anlaşmış, sonra onları üzüm bağına yollamış. ");
INSERT INTO turobt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Saat dokuzda tekrar dışarı çıkmış. Çarşıda boş duran başka adamlar görmüş. ");
INSERT INTO turobt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Onlara şöyle demiş: ‘Siz de gidin üzüm bağına. Hakkınız ne kadarsa, size ödeyeceğim.’ ");
INSERT INTO turobt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Böylece onlar bağa gitmişler. Sonra öğle vakti saat on ikide, ve tekrar saat üçte bir daha çıkmış ve yine aynısını yapmış. ");
INSERT INTO turobt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Saat akşamüstü beşte çıkıp yine başkalarını boş dururken bulmuş. Onlara şöyle demiş: ‘Neden bütün gün burada boş duruyorsunuz?’ ");
INSERT INTO turobt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Kimse bizi tutmadı da ondan’ diye cevap vermişler. Üzüm bağının sahibi, ‘Siz de üzüm bağına gidin’ demiş. ");
INSERT INTO turobt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Akşam olunca, bağ sahibi ustabaşına şöyle demiş: ‘İşçileri çağır, onlara gündeliklerini öde. Son tuttuğum kişilerle başla, ilk tuttuklarıma kadar devam et.’ ");
INSERT INTO turobt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Saat beşte tutulanlar gelince, herkes birer gümüş para almış. ");
INSERT INTO turobt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sıra ilk tutulanlara gelince, daha fazla para alacaklarını sanmışlar. Ama onlar da birer gümüş para almışlar. ");
INSERT INTO turobt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Paralarını alınca bağın sahibine karşı şöyle homurdanmaya başlamışlar: ");
INSERT INTO turobt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Bu son gelenler sadece bir saat çalıştılar. Ama sen onları bizimle bir tutuyorsun. Fakat yakıcı güneşin altında bütün günün işini biz yüklendik.’ ");
INSERT INTO turobt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bağ sahibi onlardan birine şöyle demiş: ‘Arkadaş, ben sana haksızlık etmiyorum. Seninle bir gümüş paraya anlaşmadık mı? ");
INSERT INTO turobt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hakkını al ve evine git. Bu son tuttuğum adama sana verdiğimin aynısını vermek istiyorum. ");
INSERT INTO turobt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kendi malımı istediğim gibi harcarım. Bu benim hakkım değil mi? Yoksa benim elim açık olduğu için, gözün onda mı kalıyor?’ ");
INSERT INTO turobt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bunun gibi, sonuncular birinci, birinciler de sonuncu olacak.” ");
INSERT INTO turobt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","İsa Yeruşalimʼe gidiyordu. Yoldayken on iki elçisini bir kenara çekti ve onlara şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bakın, Yeruşalimʼe gidiyoruz. İnsan Oğlubaşrahiplere ve Tevrat uzmanlarına teslim edilecek. Oʼnu ölüm cezasına çarptıracaklar ");
INSERT INTO turobt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ve yabancıların eline teslim edecekler. Onlar da Oʼnunla alay edecek, Oʼnu kamçılayacak ve çarmıha gerecekler. Ama üçüncü gün O ölümden dirilecek.” ");
INSERT INTO turobt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sonra Zebedi oğullarının annesi oğullarıyla birlikte İsaʼya geldi. Oʼnun önünde yere kapanıp Oʼndan bir şey rica etti. ");
INSERT INTO turobt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","İsa kadına, “İstediğin ne?” diye sordu. Kadın Oʼna şöyle dedi: “Buyur et, senin Krallığınʼda bu benim iki oğlumdan biri senin sağında ve öbürü solunda otursun.” ");
INSERT INTO turobt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","İsa şöyle cevap verdi: “Siz ne istediğinizi anlamıyorsunuz. Benim yakında içeceğim acı dolu bardaktan içebilir misiniz?” “İçebiliriz” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Onlara şöyle dedi: “Evet, bardağımdan içeceksiniz. Ama sağımda ve solumda oturmak için izin vermek bana düşmez. Göksel Babam bunu kimler için hazırlamışsa, onlara verilecek.” ");
INSERT INTO turobt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Öbür on öğrenci bunu duyunca, o iki kardeşe kızmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ama İsa hepsini yanına çağırıp şöyle dedi: “Bildiğiniz gibi, diğer milletlerin liderleri halklarına baskı yaparlar, ve büyük adamları onları ezerler. ");
INSERT INTO turobt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sizin aranızda böyle olmasın. Aranızda büyük olmak isteyen, diğerlerine hizmetkâr olsun. ");
INSERT INTO turobt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aranızda birinci olmak isteyen, diğerlerine kul köle olsun. ");
INSERT INTO turobt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tıpkı İnsan Oğlu gibi davransın. İnsan Oğlu Oʼna hizmet edilsin diye gelmedi. Hayır, O hizmet etmeye ve kendi canını feda ederek birçok kişiyi günaha esirlikten kurtarmaya geldi.” ");
INSERT INTO turobt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","İsaʼyla öğrencileri Eriha kasabasından çıkarken, büyük bir kalabalık Oʼnunla birlikte gitti. ");
INSERT INTO turobt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","İki kör adam yol kenarında oturuyordu. İsaʼnın yanlarından geçtiğini duyunca şöyle bağırmaya başladılar: “Efendimiz, Davud Oğlu, bize acı!” ");
INSERT INTO turobt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kalabalık sussunlar diye onlara sert çıkıştı. Fakat onlar daha da fazla bağırdılar: “Efendimiz, Davud Oğlu, bize acı!” ");
INSERT INTO turobt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","İsa durdu ve onları yanına çağırdı. “Sizin için ne yapmamı istiyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Oʼna şöyle dediler: “Efendimiz, gözlerimizin açılmasını istiyoruz.” ");
INSERT INTO turobt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","İsa onlara acıdı. Onların gözlerine dokundu. Anında yeniden görmeye başladılar ve İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","İsaʼyla öğrencileriYeruşalimʼe yaklaşırken Zeytin Dağıʼnda bulunan Beytfaci Köyüʼne geldiler. O zaman İsa iki öğrencisini önden gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Onlara şöyle dedi: “Karşınızdaki köye gidin. Varır varmaz, bağlı duran bir dişi eşek ve yanında sıpasını bulacaksınız. Onları çözün ve bana getirin. ");
INSERT INTO turobt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Biri size bir şey söylerse, ona şöyle deyin: ‘Bunlar Efendimizʼe lazımdır. Onları hemen geri gönderecek.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bu olayla peygamberin ağzından söylenen şu söz yerine gelmiş oldu: ");
INSERT INTO turobt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siyon kızına şöyle deyin: Bak, Kralın sana geliyor, alçakgönüllü ve bir eşeğe binmiş, bir sıpaya, bir yük hayvanının yavrusuna binmiş geliyor!” ");
INSERT INTO turobt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Öğrencileri de gidip, İsaʼnın buyurduğunu yaptılar. ");
INSERT INTO turobt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Eşeği ve sıpayı getirdiler ve paltolarını onların üzerine koydular. İsa üstüne bindi. ");
INSERT INTO turobt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kalabalığın çoğu paltolarını yolun üzerine serdi. Başkaları da ağaçlardan dallar kesip yolun üzerine yaydılar. ");
INSERT INTO turobt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","İsaʼnın önünde ve arkasında birer kalabalık vardı. Şöyle bağırdılar: “Davud Oğluʼna, hozana! Rabbin adıyla gelene övgüler olsun! En yücelerde hozana!” ");
INSERT INTO turobt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","İsa Yeruşalimʼe girdikten sonra, bütün şehir heyecanlandı. “Kim bu?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kalabalık şöyle dedi: “Bu, Celileʼnin Nasıra kasabasından gelen peygamber İsaʼdır.” ");
INSERT INTO turobt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","İsa tapınak avlusuna girdi. Avluda mal satan ve alışveriş yapan herkesi kovdu. Yabancı para değiştirenlerin masalarını ve güvercin satanların iskemlelerini devirdi. ");
INSERT INTO turobt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","İsa onlara şöyle dedi: “Kitapʼta ‘Benim evime ibadet evi denilecek’ diye yazılmıştır. Ama siz onu ‘haydut yatağına’ çevirdiniz.” ");
INSERT INTO turobt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","İsa tapınak avlusundayken kör ve topal kişiler Oʼnun yanına geldiler, İsa da onları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Başrahipler ve Tevrat uzmanları ise İsaʼnın yaptığı harika mucizeleri ve tapınak avlusunda “Davud Oğluʼna hozana!” diye bağıran çocukları görünce öfkelendiler. ");
INSERT INTO turobt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","İsaʼya, “Bunların ne bağırdıklarını duyuyor musun?” diye sordular. İsa onlara şöyle cevap verdi: “Evet, duyuyorum. Siz şu ayeti hiç okumadınız mı? ‘Çocukların ve sütten kesilmemiş bebeklerin ağzından kendine övgüler döktürdün.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sonra İsa onları bırakıp şehirden ayrıldı. Beytanya köyüne gitti ve orada geceledi. ");
INSERT INTO turobt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sabah erkenden şehre dönerken, İsa acıktı. ");
INSERT INTO turobt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yol kenarında bir incir ağacı gördü. Fakat yanına gidince yapraktan başka bir şey bulmadı. O zaman ağaca şöyle dedi: “Artık bir daha senden meyve çıkmasın!” Ağaç hemen kurudu. ");
INSERT INTO turobt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Öğrenciler bunu görünce şaştılar. “İncir ağacı nasıl hemen kurudu?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","İsa onlara şöyle cevap verdi: “Size doğrusunu söylüyorum: Eğer imanınız olursa ve hiç şüphe etmezseniz, bu incir ağacına yapılanı yapmakla kalmazsınız. Şu tepeye bile, ‘Yerinden kalk, denize atıl!’ dersiniz ve dediğiniz olur. ");
INSERT INTO turobt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","İman ederek dua ederseniz, dilediğiniz her şeyi alacaksınız.” ");
INSERT INTO turobt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","İsa, tapınak avlusuna gidip vaaz etmeye başladı. O zaman başrahipler ve halkın liderleri İsaʼya gelip şöyle dediler: “Bu şeyleri ne yetkiyle yapıyorsun? Sana bu yetkiyi veren kim?” ");
INSERT INTO turobt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","İsa onlara şöyle cevap verdi: “Ben de size tek bir soru soracağım. Eğer bana cevap verirseniz, size bu şeyleri ne yetkiyle yaptığımı söyleyeceğim. ");
INSERT INTO turobt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yahyaʼnın vaftiz etme yetkisi nereden geldi? Allahʼtan mi, yoksa insandan mıydı?” Bu soruyu aralarında şöyle tartışmaya başladılar: “ ‘Allahʼtan’ dersek, ‘O zaman ona neden inanmadınız?’ diyecek. ");
INSERT INTO turobt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama ‘İnsandan’ dersek, biz halkın tepkisinden korkuyoruz, çünkü hepsi Yahyaʼyı peygamber olarak kabul ediyor.” ");
INSERT INTO turobt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","İsaʼya “Bilmiyoruz” diye cevap verdiler. O da onlara şöyle dedi: “Ben de bu şeyleri ne yetkiyle yaptığımı size söylemeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Şuna ne dersiniz? Bir adamın iki oğlu varmış. Birincisine gidip şöyle demiş: ‘Evladım, git bugün üzüm bağında çalış.’ ");
INSERT INTO turobt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Oğlu da ‘Gitmek istemiyorum!’ demiş. Ama sonra pişman olup gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Babası sonra öbür çocuğuna gitmiş ve ona aynısını söylemiş. O da ‘Olur, efendim’ demiş, ama gitmemiş. ");
INSERT INTO turobt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","O ikisinden hangisi babasının isteğini yerine getirdi?” “Birincisi” dediler. İsa onlara dedi: “Size doğrusunu söylüyorum: vergi memurları ve fahişeler Allahʼın Krallığıʼna sizden önce girecekler. ");
INSERT INTO turobt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yahya size doğruluk yolunu göstermek için geldi, ona inanmadınız. Fakat vergi memurları ve fahişeler ona inandılar. Siz ise bunları gördüğünüz halde pişmanlık duyup Yahyaʼya inanmadınız. ");
INSERT INTO turobt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Diğer bir benzetmeye kulak verin: Bir toprak sahibi varmış. Adam üzüm bağı dikmiş, etrafına duvar çekmiş, üzüm çiğneme çukurunu kazmış, bir de gözetleme kulesi yapmış. Sonra bağını bağcılara kiraya vermiş ve yolculuğa çıkmış. ");
INSERT INTO turobt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Üzüm toplama zamanı yaklaşınca, bağ sahibi bağın ürününden payına düşeni almaları için kölelerini bağcıların yanına göndermiş. ");
INSERT INTO turobt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bağcılar da adamın kölelerini alıp birini dövmüşler, diğerini öldürmüşler, üçüncüsünü de taşlamışlar. ");
INSERT INTO turobt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Adam sonra öncekinden daha fazla köle göndermiş. Bağcılar onlara da aynısını yapmışlar. ");
INSERT INTO turobt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","En sonunda adam, ‘Oğluma saygı gösterirler’ diyerek onlara oğlunu yollamış. ");
INSERT INTO turobt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama bağcılar adamın oğlunu görünce aralarında şöyle konuşmuşlar: ‘Mirasçı budur. Haydi, onu öldürelim de, mirası ele geçirelim.’ ");
INSERT INTO turobt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Böylece onu alıp bağdan dışarı atmışlar ve öldürmüşler. ");
INSERT INTO turobt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","O zaman bağ sahibi gelince o bağcılara ne yapacak?” ");
INSERT INTO turobt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","İsaʼya şöyle dediler: “O kötü adamları korkunç bir şekilde öldürecek. Bağı da kendisine ürünü vaktinde getirecek başka bağcılara kiraya verecek.” ");
INSERT INTO turobt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","İsa onlara şunu sordu: “Siz Kutsal Yazılarʼda şu sözleri hiç okumadınız mı? ‘İnşaatçıların reddettiği taş, binanın köşe taşı oldu. Bu iş Rabʼdendir, gözümüzde harika bir şeydir.’ ");
INSERT INTO turobt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bunun için size diyorum ki, Allahʼın Krallığı sizden alınacak ve o krallığa layık ürün getiren bir millete verilecek. ");
INSERT INTO turobt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kim o taşın üzerine düşerse, paramparça olacak. O taş da kimin üzerine düşerse, onu ezip toz duman edecek.” ");
INSERT INTO turobt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Başrahipler ve Ferisiler bu benzetmeleri işitince, İsaʼnın kendileri hakkında konuştuğunu anladılar. ");
INSERT INTO turobt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Onu yakalamak istediler ama halkın tepkisinden korktular. Çünkü halk İsaʼyı peygamber olarak kabul ediyordu. ");
INSERT INTO turobt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","İsa tekrar halka benzetmeler anlatmaya başladı. Şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Göklerin Krallığı oğluna düğün yapan bir krala benzer. ");
INSERT INTO turobt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kral kölelerini gönderip düğüne davetli olanları çağırtmış. Ama gelmek istememişler. ");
INSERT INTO turobt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kral yine başka köleler gönderip onlara şöyle demiş: ‘Davetli olanlara şunu deyin: “İşte, ziyafetimi hazırladım, öküzlerimi ve besili danalarımı kestirdim. Artık her şey hazır, düğüne gelin.” ’ ");
INSERT INTO turobt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama davetliler hiç kulak asmamışlar. Herkes kendi yoluna gitmiş. Birisi tarlasına, öbürü ticaretine dönmüş. ");
INSERT INTO turobt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Geri kalanlar da kralın kölelerini yakalamış, aşağılamış ve öldürmüşler. ");
INSERT INTO turobt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kral öfkelenmiş. Ordularını gönderip o katilleri yok etmiş, şehirlerini de ateşe vermiş. ");
INSERT INTO turobt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sonra kölelerine şöyle demiş: ‘Düğün hazır, ama davetliler buna layık değil. ");
INSERT INTO turobt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bunun için şehrin ana yollarına çıkın. Orada kimi bulursanız onu düğüne çağırın.’ ");
INSERT INTO turobt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Köleler yollara düşmüşler ve iyi kötü kimi buldularsa hepsini toplamışlar. Böylece düğün salonu misafirlerle dolmuş. ");
INSERT INTO turobt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kral misafirlerle görüşmek için içeri girdiğinde orada düğün elbisesi giymemiş olan birini görmüş. ");
INSERT INTO turobt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ona şöyle demiş: ‘Arkadaş, nasıl oldu da, düğün elbisesi giymeden buraya girdin?’ Adamın dili tutulmuş. ");
INSERT INTO turobt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","O zaman kral, kölelerine şöyle demiş: ‘Onun ellerini, ayaklarını bağlayın ve onu dışarıya atın, karanlıkta kalsın.’ Orada insanlar ağlayacak ve dişlerini gıcırdatacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Çünkü davetliler çok, ama seçilenler az.” ");
INSERT INTO turobt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sonra Ferisiler gidip İsaʼyı kendi sözleriyle tuzağa düşürmek için plan kurdular. ");
INSERT INTO turobt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kendi öğrencileriniHirodesçilerle birlikte İsaʼya yolladılar. Bu kişiler şöyle dediler: “Öğretmenimiz! Biliyoruz ki, sen dürüst bir adamsın ve Allahʼın yolunu doğru öğretiyorsun. Hiç taraf tutmuyorsun. İnsanlar arasında ayrım yapmıyorsun. ");
INSERT INTO turobt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Peki, söyle bize, sen ne düşünüyorsun: Sezarʼa vergi ödemek Tevratʼa uygun mu, değil mi?” ");
INSERT INTO turobt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama İsa onların kötü niyetini fark edip şöyle dedi: “Sizi ikiyüzlüler sizi! Neden beni tuzağa düşürmeye çalışıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Vergi öderken kullandığınız parayı bana bir gösterin!” Oʼna bir gümüş para getirdiler. ");
INSERT INTO turobt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","İsa onlara, “Burada kimin resmi var, kimin adı yazılı?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Oʼna, “Sezarʼın” dediler. Bunun üzerine İsa onlara şöyle dedi: “Öyleyse, Sezarʼın hakkını Sezarʼa verin, Allahʼın hakkını Allahʼa verin.” ");
INSERT INTO turobt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bunu duyunca hayret ettiler ve İsaʼyı bırakıp gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aynı gün Sadukiler İsaʼya geldi. Sadukiler “Ölümden diriliş diye bir şey yoktur” derler. İsaʼya şunu sordular: ");
INSERT INTO turobt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Öğretmenimiz! Musa bize şöyle buyurdu: ‘Bir adamın kardeşi ölürse ve karısını çocuğu olmadan dul bırakırsa, o adam ölen kardeşinin karısıyla evlensin ve kardeşine soy yetiştirsin.’ ");
INSERT INTO turobt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aramızda yedi kardeş vardı. Birincisi evlendi fakat çocuğu olmadan öldü. Karısını kardeşine bıraktı. ");
INSERT INTO turobt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","İkincisine de, üçüncüsüne de öyle oldu. Ta yedincisine kadar hep aynı şey oldu. ");
INSERT INTO turobt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Son olarak kadın da öldü. ");
INSERT INTO turobt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Öyleyse, ölüler dirildiği zaman kadın bu yedi kardeşten hangisinin karısı olacak? Çünkü hepsi onunla evlenmişti.” ");
INSERT INTO turobt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ama İsa onlara şöyle cevap verdi: “Siz Kutsal Yazılarʼı ve Allahʼın gücünü bilmediğiniz için yanılıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Çünkü ölüler dirildiği zaman ne karı alırlar, ne de kocaya giderler. Gökteki melekler gibi olurlar. ");
INSERT INTO turobt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ölülerin dirilişi hakkında Allahʼın ne söylediğini okumadınız mı? O şöyle der: ");
INSERT INTO turobt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ben İbrahimʼin Allahı, İshakʼın Allahı ve Yakubʼun Allahıʼyım.’ O, ölülerin Allahı değil, yaşayanların Allahıʼdır.” ");
INSERT INTO turobt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Halk bunu işitince, Oʼnun öğrettiklerine şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ferisiler İsaʼnın Sadukileri susturduğunu işitince, İsaʼnın yanına toplandılar. ");
INSERT INTO turobt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aralarında bir Tevrat uzmanı vardı. O, İsaʼyı tuzağa düşürmek için kendisine şu soruyu sordu: ");
INSERT INTO turobt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Öğretmenimiz! Tevratʼta en önemli buyruk hangisidir?” ");
INSERT INTO turobt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","İsa ona şöyle dedi: “ ‘Allahınız Rabbi bütün yüreğinizle, bütün canınınızla ve bütün aklınızla sevin.’ ");
INSERT INTO turobt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Birinci ve en önemli buyruk budur. ");
INSERT INTO turobt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ona benzeyen ikinci buyruk da şudur: ‘Komşunuzu kendinizi sevdiğiniz gibi sevin.’ ");
INSERT INTO turobt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bütün Tevrat ve peygamberlerin yazdıkları bu iki buyruğa dayanır.” ");
INSERT INTO turobt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferisiler toplanmışken, İsa onlara şunu sordu: ");
INSERT INTO turobt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mesih hakkında ne düşünüyorsunuz? Sizce o kimin oğlu?” Oʼna, “Davud Oğlu” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","İsa onlara şöyle dedi: “Peki, öyleyse, Davud Kutsal Ruh aracılığıyla ona nasıl ‘Efendim’ diyebilir? Çünkü şöyle der: ");
INSERT INTO turobt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Rab Efendimʼe dedi ki: “Senin düşmanlarını ayaklarının altına sereceğim. O zamana kadar sağımda otur.” ’ ");
INSERT INTO turobt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davud Mesihʼe ‘Efendim’ dediğine göre, Mesih nasıl Davudʼun oğlu olabilir?” ");
INSERT INTO turobt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hiç kimse İsaʼya tek bir söz bile söyleyemedi. O günden sonra kimse Oʼna soru sormaya cesaret etmedi. ");
INSERT INTO turobt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ondan sonra İsa kalabalığa ve öğrencilerine şunları söyledi: ");
INSERT INTO turobt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tevrat uzmanları ve Ferisiler Musaʼnın koltuğuna oturdular. ");
INSERT INTO turobt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bunun için, size söyledikleri her şeye itaat edip onu yerine getirin. Ama onlar gibi davranmayın. Çünkü onlar söyledikleri şeyleri yapmazlar. ");
INSERT INTO turobt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Taşınması zor ağır yükleri bağlayıp insanların omuzlarına yüklerler. Kendileriyse bu yükleri kaldırmak için parmaklarını bile kıpırdatmak istemezler. ");
INSERT INTO turobt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yaptıkları bütün iyilikleri gösteriş için yaparlar. Örneğin, ayet kutularını büyük ve elbiselerinin püsküllerini uzun yaparlar. ");
INSERT INTO turobt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ziyafetlerde ve toplantı yerlerinde en saygın yerlerde oturmayı severler. ");
INSERT INTO turobt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Çarşılarda insanların onları selamlayıp ‘Öğretmenim’ demesine bayılırlar. ");
INSERT INTO turobt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Fakat insanlar size ‘Öğretmenim’ demesinler, çünkü tek bir Öğretmeniniz var, ve hepiniz kardeşsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yeryüzünde kimseye ‘Baba’ unvanını vermeyin. Çünkü tek bir Babanız var, O da göktedir. ");
INSERT INTO turobt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Size ‘Rehber’ demesinler. Çünkü tek bir Rehberiniz var, o da Mesihʼtir. ");
INSERT INTO turobt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ama sizin aranızda en önemli olan, diğerlerinin hizmetkârı olsun. ");
INSERT INTO turobt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kendini yücelten alçaltılacak, kendini alçaltan ise yüceltilecek. ");
INSERT INTO turobt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Vay halinize Tevrat uzmanları ve Ferisiler, ikiyüzlüler sizi! Çünkü Göklerin Krallığıʼnın kapısını insanların yüzüne kapıyorsunuz. Hem kendiniz girmiyorsunuz, hem de girmeye hazır olanlara izin vermiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Vay halinize ikiyüzlü Tevrat uzmanları ve Ferisiler! Çünkü tek bir kişiyi dininize çevirmek için deniz toprak aşarsınız. Adam dininize dönünce onu kendinizden iki kat daha fazla cehennemlik yaparsınız. ");
INSERT INTO turobt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Vay halinize, halka yol gösteren körler! Diyorsunuz ki, ‘İnsan tapınak üzerine yemin ederse bu onu bağlamaz. Ama kim tapınaktaki altın üzerine yemin ederse, o artık yemini yerine getirmeye mecburdur.’ ");
INSERT INTO turobt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Akılsızlar! Körler! Hangisi daha önemli: altın mı, yoksa altını kutsal kılan tapınak mı? ");
INSERT INTO turobt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hem de diyorsunuz ki, ‘İnsan kurban yerinin üzerine yemin ederse, bu onu bağlamaz. Ama kim kurban yerindeki adağın üzerine yemin ederse o artık yemini yerine getirmeye mecburdur.’ ");
INSERT INTO turobt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sizi körler! Hangisi daha önemli: adak mı, yoksa adağı kutsal kılan kurban yeri mi? ");
INSERT INTO turobt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bunun için, kim kurban yerinin üzerine yemin ederse, hem kurban yerinin üzerine, hem de onun üstünde olan her şeyin üzerine yemin etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kim tapınak üzerine yemin ederse, hem tapınağın kendisi üzerine, hem de orada yaşayan Allahʼın üzerine yemin etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kim gök üzerine yemin ederse, hem Allahʼın tahtı üzerine, hem de orada oturan Allahʼın üzerine yemin etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Vay halinize Tevrat uzmanları ve Ferisiler, ikiyüzlüler sizi! Çünkü nanenin, dereotunun ve kimyonun ondalığını veriyorsunuz. Ama Tevratʼın adalet, merhamet ve sadakat hakkındaki buyrukları gibi daha önemli şeyleri terk ettiniz. Asıl bunları yerine getirmeli, öbür işleri de bırakmamalıydınız. ");
INSERT INTO turobt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kör liderler sizi! Sineği süzüp deveyi yutuyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Vay halinize ikiyüzlü Tevrat uzmanları ve Ferisiler! Çünkü bardağın ve çanağın dış tarafını temizliyorsunuz, ama bunların içi hırsızlık ve açgözlülükle dolu. ");
INSERT INTO turobt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sizi kör Ferisiler! Önce bardağın ve çanağın içini temizleyin ki onun dış tarafı da temiz olsun. ");
INSERT INTO turobt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Vay halinize ikiyüzlü Tevrat uzmanları ve Ferisiler! Kireçli türbelere benziyorsunuz. Bu türbeler dışardan güzel görünüyor, ama içleri ölü kemikler ve her türlü pislikle doludur. ");
INSERT INTO turobt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aynı bunun gibi, siz de insanlara dıştan doğru dürüst görünüyorsunuz, ama içiniz ikiyüzlülük ve kanunsuzlukla dolu. ");
INSERT INTO turobt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Vay halinize ikiyüzlü Tevrat uzmanları ve Ferisiler! Çünkü peygamberlerin türbelerini yaparsınız ve iyi insanların anıtlarını süslersiniz. ");
INSERT INTO turobt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hem de dersiniz ki, ‘Biz atalarımızın zamanında yaşasaydık, peygamberlerin kanını dökenlere yardım etmezdik.’ ");
INSERT INTO turobt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bunu söylerken peygamberleri öldürenlerin torunları olduğunuza kendiniz şahitsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","O halde durmayın, atalarınızın başlattığı işi bitirin. ");
INSERT INTO turobt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hey, sizi yılanlar, sizi zehirli yılan soyu! Cehennemin cezasından nasıl kaçıp kurtulacaksınız? ");
INSERT INTO turobt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bu yüzden, bakın, ben size peygamberler, hikmetli adamlar ve Tevrat uzmanları göndereceğim. Onların bazılarını öldüreceksiniz, çarmıha gereceksiniz. Bazılarını da toplantı yerlerinizde kamçılayıp kasabadan kasabaya kovacaksınız. ");
INSERT INTO turobt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Öyle ki, suçsuz Habilʼin kanından, Berekya oğlu Zekeriyaʼnın kanına kadar yeryüzünde ne kadar suçsuz kan dökülmüşse, siz hepsinden sorumlu tutulacaksınız. Zekeriyaʼyı siz tapınakla kurban yerinin arasında öldürdünüz. ");
INSERT INTO turobt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Size doğrusunu söylüyorum: bütün bunların hesabını bu kuşak ödeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ey Yeruşalim, Yeruşalim! Peygamberleri öldüren ve sana gönderilen elçileri taşlayan şehir! Tavuk civcivlerini kanatlarının altına nasıl toplarsa, ben de senin evlatlarını kaç defa öyle toplamak istedim. Ama siz istemediniz. ");
INSERT INTO turobt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bakın, tapınağınız size terk edilmiş durumda bırakılacak. ");
INSERT INTO turobt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Size şunu diyorum, ‘Rabbin adıyla gelene övgüler olsun!’ diyene kadar beni bir daha görmeyeceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","İsa, tapınak avlusundan çıkmış yoluna devam ediyordu. Öğrencileri Oʼna tapınak binalarını göstermek için yaklaştılar. ");
INSERT INTO turobt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ama İsa onlara şöyle karşılık verdi: “Bütün bunları görüyor musunuz? Size doğrusunu söylüyorum: burada taş üstünde taş bırakılmayacak, hepsi yıkılacak.” ");
INSERT INTO turobt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","İsa Zeytin Dağıʼnda tek başına otururken öğrencileri yanına gelip şöyle dediler: “Bize söyle, bu şeyler ne zaman olacak? Senin görkemli gelişini ve dünyanın sonunu gösteren işaret nedir?” ");
INSERT INTO turobt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","İsa onlara şöyle cevap verdi: “Bakın kimse sizi aldatmasın. ");
INSERT INTO turobt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Birçok kişi benim adımı kullanarak gelecek. ‘Mesih benim’ diyecek ve birçok kişiyi aldatacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Savaş gürültüleri ve savaş haberleri duyacaksınız. Sakın korkmayın! Bunların olması lazım, ama dünyanın sonu hemen gelmeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Millet millete, devlet devlete saldıracak. Kimi yerlerde kıtlıklar ve depremler olacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bütün bu olaylar doğum yapan kadının ilk sancıları gibi, sıkıntıların başlangıcıdır. ");
INSERT INTO turobt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","O zaman sizi tutuklayıp eziyet edecekler, sizi öldürecekler. Benim adım yüzünden bütün milletler sizden nefret edecek. ");
INSERT INTO turobt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","O zaman birçokları imandan dönecek, birbirlerine ihanet edecek ve birbirlerinden nefret edecekler. ");
INSERT INTO turobt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bir sürü sahte peygamber kalkıp birçok insanı yoldan saptıracak. ");
INSERT INTO turobt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kanunsuzluk çoğalacak ve bunun için birçoklarının sevgisi soğuyacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama kim sonuna kadar dayanırsa, o kurtulacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bütün milletlere şahitlik olsun diye Göklerin Krallığı hakkındaki bu Müjde tüm dünyada duyurulacak. İşte, o zaman son gelecek. ");
INSERT INTO turobt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Peygamber Daniel tapınakta dikilen, oranın ‘kutsallığını bozan rezalet’ hakkında konuşmuştu. (Okuyan anlasın!) ");
INSERT INTO turobt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bunu görünce Yahudiye bölgesinde olanlar dağlara kaçsınlar. ");
INSERT INTO turobt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Evin damında olan kişi aşağı insin ama evinden bir şey almasın. ");
INSERT INTO turobt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tarlada olan kişi paltosunu almak için geri dönmesin. ");
INSERT INTO turobt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Vay o günlerde hamile olanların ve bebek emzirenlerin haline! ");
INSERT INTO turobt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dua edin ki, kaçışınız kışa ya da Şabat gününe rast gelmesin. ");
INSERT INTO turobt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Çünkü o günler büyük bir eziyet zamanı olacak. Dünyanın başlangıcından beri böyle bir eziyet olmadı, bir daha da olmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","O günler kısaltılmasaydı, hiçbir insan kurtulmazdı. Fakat Allah seçtiği kişilerin hatırı için o günleri kısaltacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","O zaman size birisi, ‘Bak, Mesih burada!’ ya da, ‘Bak, orada!’ derse, inanmayın. ");
INSERT INTO turobt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Çünkü ‘Ben Mesihʼim’ ve ‘Ben peygamberim’ diyen yalancılar ortaya çıkacaklar. Ellerinden gelse Allahʼın seçtiği insanları bile saptırmak için büyük mucizeler ve harikalar yapacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","İşte, size önceden söylüyorum. ");
INSERT INTO turobt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yani ‘Bakın, Mesih ıssız yerdedir’ derlerse, oraya çıkmayın. ‘Bakın, iç odadadır’ derlerse, inanmayın. ");
INSERT INTO turobt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Çünkü nasıl şimşek doğudan çakıp batıya kadar her tarafı aydınlatırsa İnsan Oğluʼnun görkemli gelişi de aynı öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Leş neredeyse, akbabalar da oraya toplanır. ");
INSERT INTO turobt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ama o günlerin eziyetinden hemen sonra, ‘güneş kararacak, ay da ışığını vermeyecek. Yıldızlar gökten düşecek ve gökteki güçler sarsılacak.’ ");
INSERT INTO turobt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","O zaman İnsan Oğluʼnun işareti gökte görünecek. O vakit dünyanın bütün halkları ağlayıp dövünecekler. İnsan Oğluʼnun gökteki bulutların üzerinde kudret ve büyük görkemle geldiğini görecekler. ");
INSERT INTO turobt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","İnsan Oğlu güçlü bir borazan sesiyle meleklerini gönderecek. Onlar da Oʼnun seçtiği kişileri dünyanın dört bucağından, göğün bir ucundan öbür ucuna kadar toplayacaklar. ");
INSERT INTO turobt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Şimdi de, incir ağacından bir ders alın: dalları filizlenip yaprak çıkarınca, yaz mevsiminin yaklaştığını bilirsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bunun gibi, bütün bu şeyleri gördüğünüz zaman bileceksiniz ki, Allahʼın Krallığı yakındır, kapıdadır. ");
INSERT INTO turobt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Size doğrusunu söylüyorum: bütün bu şeyler yerine gelmeden bu kuşak yok olmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gök ve yer ortadan kalkacak, ama benim sözlerim asla ortadan kalkmayacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yalnız, o günü ve o saati hiç kimse bilmiyor: ne gökteki melekler, ne de Oğul, sadece Baba biliyor. ");
INSERT INTO turobt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Çünkü Nuhʼun günlerinde nasıl olmuşsa, İnsan Oğluʼnun gelişinde de öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tufandan önceki o günlerde yiyip içerlerdi, karı alıp kocaya giderlerdi. Bunlar Nuhʼun gemiye bindiği güne kadar devam etti. ");
INSERT INTO turobt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tufan gelip onların hepsini götürene kadar bir şey anlamadılar. İnsan Oğluʼnun görkemli gelişi de aynı öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","O vakit tarlada bulunan iki adamdan birisi alınacak, öbürü bırakılacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bir değirmende buğday öğüten iki kadından birisi alınacak, öbürü bırakılacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bunun için tetikte durun. Çünkü Efendinizʼin hangi günde geleceğini bilmiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Şunu da bilin: Eğer ev sahibi hırsızın gecenin hangi saatinde geleceğini bilseydi, tetikte durur, evinin soyulmasına izin vermezdi. ");
INSERT INTO turobt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bunun için, siz de hazır olun. Çünkü İnsan Oğlu beklemediğiniz saatte gelecek. ");
INSERT INTO turobt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sadık ve akıllı köle kimdir ki efendisi onu diğer kölelerin başına koyar ve onlara zamanında yiyecek vermesini buyurur? ");
INSERT INTO turobt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Efendisinin eve döndüğünde işinin başında bulacağı o köleye ne mutlu! ");
INSERT INTO turobt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Size doğrusunu söylüyorum: efendisi bu köleyi sahip olduğu bütün malın ve mülkün başına koyacak. ");
INSERT INTO turobt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ama o köle kötü niyetliyse ve kendi içinden ‘Efendimin gelmesine daha çok vakit var’ derse, arkadaşlarını dövmeye ve içkicilerle birlikte yiyip içmeye başlar. ");
INSERT INTO turobt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","O zaman efendisi kölenin hiç beklemediği bir gün, hiç bilmediği bir saatte gelecek. ");
INSERT INTO turobt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Onu şiddetle cezalandıracak ve ikiyüzlülerin yanında ona yer verecek. Orada ağlayacak ve dişlerini gıcırdatacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“O zaman Göklerin Krallığı lambalarını alıp damadı karşılamaya çıkan on genç kıza benzeyecek. ");
INSERT INTO turobt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bunların beşi akılsız, beşi ise akıllıymış. ");
INSERT INTO turobt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akılsız kızlar lambalarını almış, ama yanlarına yedek yağ almamışlar. ");
INSERT INTO turobt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Akıllı kızlar ise yanlarına hem lambalarını hem de yağ kaplarını almışlar. ");
INSERT INTO turobt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ama damat gecikince hepsini uyku basmış ve uyumuşlar. ");
INSERT INTO turobt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gece yarısı biri şöyle bağırmış: ‘Bakın, damat geliyor! Onu karşılamaya çıkın!’ ");
INSERT INTO turobt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","O vakit bütün kızlar kalkıp lambalarını hazırlamışlar. ");
INSERT INTO turobt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Akılsız kızlar, akıllı olanlara şöyle demişler: ‘Bize yağınızdan azıcık verin, lambalarımız sönüyor.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ama akıllı kızlar şöyle karşılık vermiş: ‘Hayır olmaz! Yağ hem bize, hem size yetmeyecek. Bunun yerine satıcılara gidin, kendinize yağ alın.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Onlar yağ almaya giderken, damat gelmiş ve hazırlıklı kızlar onunla birlikte içeri girip düğüne katılmışlar. Ardından kapı kilitlenmiş. ");
INSERT INTO turobt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sonra da öbür kızlar gelip, ‘Efendimiz, Efendimiz, kapıyı aç bize!’ demişler. ");
INSERT INTO turobt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ama damat şöyle cevap vermiş: ‘Size doğrusunu söylüyorum: sizi tanımıyorum.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bunun için, tetikte durun, çünkü geleceğim günü ve saati bilemezsiniz. ");
INSERT INTO turobt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Göklerin Krallığı şuna benzer: adamın biri yolculuğa çıkmış, gitmeden önce kölelerini çağırmış ve mallarını onlara emanet etmiş. ");
INSERT INTO turobt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Birine beş çuval, birine iki, birine de bir çuval altın vermiş. Herkese kendi yeteneğine göre vermiş. Sonra yolculuğa çıkmış. ");
INSERT INTO turobt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Beş çuvalı alan hemen gitmiş, onlarla ticaret etmeye başlamış ve beş çuval altın daha kazanmış. ");
INSERT INTO turobt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aynı bunun gibi, iki çuvalı alan da, iki çuval altın daha kazanmış. ");
INSERT INTO turobt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama bir çuval altın alan, gidip toprağı kazmış, efendisinin parasını oraya saklamış. ");
INSERT INTO turobt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Uzun zaman sonra, o kölelerin efendisi gelmiş ve onların hesabını görmeye başlamış. ");
INSERT INTO turobt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Beş çuval altın almış olan gelip beş çuval daha getirmiş ve şöyle demiş: ‘Efendimiz! Sen bana beş çuval altın emanet ettin, bak, beş çuval daha kazandım.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Efendisi ona şöyle demiş: ‘Aferin! Sen iyi ve güvene layık bir kölesin. Küçük işlerde güvene layık çıktın, ben de seni büyük işlerin başına geçireceğim. Efendinin sevincine katıl.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sonra iki çuval altın almış olan gelip iki çuval daha getirmiş ve şöyle demiş: ‘Efendimiz! Sen bana iki çuval altın emanet ettin, bak, iki çuval daha kazandım.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Efendisi ona şöyle demiş: ‘Aferin! Sen iyi ve güvene layık bir kölesin. Küçük işlerde güvene layık çıktın, ben de seni büyük işlerin başına geçireceğim. Efendinin sevincine katıl.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sonra bir çuval altın almış olan gelip şöyle demiş: ‘Efendimiz, senin sert bir adam olduğunu biliyordum. Ekmediğin yerden biçersin ve harman savurmadığın yerden toplarsın. ");
INSERT INTO turobt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bu sebeple korktum ve gidip senin çuvalını toprağa sakladım. İşte al malını!’ ");
INSERT INTO turobt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Efendisi ona şöyle cevap vermiş: ‘Seni kötü ve tembel köle seni! Benim ekmediğim yerden biçtiğimi ve harman savurmadığım yerden topladığımı bilirdin. ");
INSERT INTO turobt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Öyleyse paramı bankaya koymalıydın. O zaman döndüğümde paramı faiziyle birlikte geri alırdım.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sonra diğer kölelere şöyle emretmiş: ‘Onun çuvalını alın ve kendisinde on çuval altın olan köleye verin. ");
INSERT INTO turobt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Çünkü kim sahip olduğu şeyleri kullanırsa, ona daha çok verilecek, bolluğa kavuşacak. Ama kim kullanmazsa, elindeki de alınacak. ");
INSERT INTO turobt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Şu yaramaz köleyi dışarıya atın, karanlıkta kalsın. Orada insanlar ağlayacak ve dişlerini gıcırdatacaklar.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","İnsan Oğlu bütün meleklerle birlikte kendi görkemiyle gelecek. O zaman görkemli tahtında oturacak. ");
INSERT INTO turobt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bütün milletler Oʼnun önünde toplanacaklar. O da çobanın koyunları keçilerden ayırdığı gibi, insanları birbirlerinden ayıracak. ");
INSERT INTO turobt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Koyunları sağ tarafına, keçileri de sol tarafına alacak. ");
INSERT INTO turobt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","O zaman Kral sağ tarafındaki insanlara şöyle diyecek: ‘Ey Babamʼın övgüsünü alanlar, gelin! Dünyanın yaratılışından beri sizin için hazırlanan Krallığı miras alın. ");
INSERT INTO turobt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Çünkü açtım, bana yiyecek verdiniz. Susamıştım, bana su verdiniz. Yabancıydım, bana kapı açtınız. ");
INSERT INTO turobt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Çıplaktım, beni giydirdiniz. Hastaydım, bana baktınız. Hapisteydim, ziyaretime geldiniz.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","O zaman doğru kişiler Oʼna şöyle cevap verecekler: ‘Efendimiz, ne zaman seni aç gördük de, doyurduk? Ne zaman seni susuz gördük de, su verdik? ");
INSERT INTO turobt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ne zaman seni yabancı gördük de sana kapımızı açtık, çıplak gördük de seni giydirdik? ");
INSERT INTO turobt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ne zaman seni hasta ya da hapiste gördük de, ziyaret ettik?’ ");
INSERT INTO turobt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kral onlara şöyle cevap verecek: ‘Size doğrusunu söylüyorum: Bu en önemsiz kardeşlerimden birine ne yaptınızsa onu bana yapmış olursunuz.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sonra Kral, sol tarafındakilere şöyle diyecek: ‘Yıkılın karşımdan, lanetli insanlar! İblis ve onun melekleri için hazırlanan, hiç sönmeyen ateşe gidin! ");
INSERT INTO turobt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Çünkü açtım, bana yiyecek vermediniz. Susamıştım, bana su vermediniz. ");
INSERT INTO turobt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yabancıydım, bana kapı açmadınız. Çıplaktım, beni giydirmediniz. Hasta ve hapisteydim, beni ziyaret etmediniz.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","O zaman o kişiler şöyle cevap verecekler: ‘Efendimiz, seni ne vakit aç, susuz, yabancı, çıplak, hasta ya da hapiste gördük de sana yardım etmedik?’ ");
INSERT INTO turobt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kral onlara şöyle karşılık verecek: ‘Size doğrusunu söylüyorum: Bu en önemsiz kişilerden birine yapmadığınız şeyi bana da yapmamış oldunuz.’ ");
INSERT INTO turobt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bunlar sonsuz cezaya uğrayacaklar. Ama doğru olanlar sonsuz yaşama kavuşacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","İsa bütün bunları söyledikten sonra öğrencilerine şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Biliyorsunuz, iki gün sonra Özgürlük Bayramı olacak. O zaman İnsan Oğlu Oʼnu çarmıha gerecek olanlara teslim edilecek.” ");
INSERT INTO turobt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","O arada başrahipler ve halkın liderleri, Kayafa adındaki başrahibin evinde toplandılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","İsaʼyı hileyle yakalayıp öldürmek için anlaştılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Aman!” dediler. “Bayramda olmasın. Yoksa halkın arasında ayaklanma olabilir.” ");
INSERT INTO turobt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","İsa Beytanya köyünde, Simun adında bir adamın evindeydi. Simun daha önce cüzzam hastasıydı. ");
INSERT INTO turobt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","O zaman bir kadın kaymaktaşı bir kapla İsaʼya yaklaştı. Kabın içinde çok pahalı, güzel kokulu yağ vardı. İsa sofrada otururken, kadın yağı yavaşça Oʼnun başına döktü. ");
INSERT INTO turobt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","İsaʼnın öğrencileri bunu görünce kızdılar. “Nedir bu ziyan?” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Bu yağ çok yüksek fiyata satılıp parası fakirlere dağıtılabilirdi.” ");
INSERT INTO turobt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","İsa bunu fark edince onlara şöyle dedi: “Niçin kadını üzüyorsunuz? O bana güzel bir şey yaptı. ");
INSERT INTO turobt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Fakirler her zaman sizinle olacak. Ama ben her zaman sizinle olmayacağım. ");
INSERT INTO turobt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kadın bu yağı bedenime sürerek beni gömülmeye hazırladı. ");
INSERT INTO turobt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Size doğrusunu söylüyorum: Müjde dünyanın neresinde duyurulursa, bu kadının yaptığı da anılacak.” ");
INSERT INTO turobt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ondan sonra, İsaʼnın on iki elçisinden biri olan Yahuda İskariyot başrahiplere gitti. ");
INSERT INTO turobt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Onlara şöyle dedi: “İsaʼyı size teslim edersem bana ne verirsiniz?” Ona otuz gümüş para saydılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yahuda o zamandan sonra İsaʼyı onların eline vermek için uygun bir fırsat aradı. ");
INSERT INTO turobt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mayasız Ekmek Bayramıʼnın birinci gününde, İsaʼnın öğrencileri Oʼna geldiler, “Özgürlük Bayram yemeğini sana nerede hazırlayalım?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","İsa dedi: “Şehre gidin, tanıdığım bir adamın yanına varıp şöyle deyin: ‘Öğretmenimiz diyor ki, Artık vaktim geldi, Özgürlük Bayramıʼnı öğrencilerimle birlikte senin evinde kutlayacağım.’ ” ");
INSERT INTO turobt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Öğrenciler İsaʼnın dediğini yerine getirdiler. Böylece Özgürlük Bayram hazırlıklarını yaptılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Akşam olunca, İsa on iki elçisiyle birlikte sofraya oturdu. ");
INSERT INTO turobt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yemek yerlerken İsa şöyle dedi: “Size doğrusunu söylüyorum: sizden biri bana ihanet edecek.” ");
INSERT INTO turobt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Buna çok üzüldüler. Teker teker İsaʼya sormaya başladılar: “Efendimiz, beni demek istemedin ya?” ");
INSERT INTO turobt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","İsa şöyle cevap verdi: “Benimle birlikte eliyle ekmeğini çanağa bandıran adam bana ihanet edecek. ");
INSERT INTO turobt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gerçi, İnsan Oğlu tıpkı kendisi hakkında yazıldığı gibi ölüme gidiyor. Ama İnsan Oğluʼna ihanet eden adamın vay haline! O adam hiç doğmasaydı, onun için daha iyi olurdu.” ");
INSERT INTO turobt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","İsaʼya ihanet edecek olan Yahuda, “Öğretmenim, herhalde bu ben değilim?” diye sordu. İsa ona, “Sen kendin söyledin” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Onlar yemek yerken, İsa eline ekmek aldı, şükredip onu böldü. Ekmeği öğrencilerine verirken şöyle dedi: “Alın, yiyin! Bu benim bedenimdir.” ");
INSERT INTO turobt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sonra eline bir bardak şarap aldı, şükretti ve onlara verip şöyle dedi: “Hepiniz bundan için. ");
INSERT INTO turobt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Çünkü bu benim kanımdır, antlaşma kanıdır. Birçok insanın günahlarının bağışlanması için akıtılıyor. ");
INSERT INTO turobt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Size söylüyorum, göksel Babamʼın Krallığıʼnda sizinle birlikte yenisini içeceğim güne kadar asmanın bu ürününden bir daha içmeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","İlahi söyledikten sonra, İsa ve öğrencileri çıkıp Zeytin Dağıʼna doğru gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sonra İsa onlara şöyle dedi: “Bu gece başıma gelenler yüzünden hepinizin inancı sarsılacak. Çünkü şöyle yazılmıştır: Allah diyor ki, ‘Çobanı vuracağım, sürüdeki koyunlar da darmadağın olacak.’ ");
INSERT INTO turobt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama ben ölüp dirildikten sonra önünüzden Celileʼye gideceğim.” ");
INSERT INTO turobt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus İsaʼya şöyle cevap verdi: “Senin başına gelenler yüzünden herkesin inancı sarsılsa da, benimki asla sarsılmaz.” ");
INSERT INTO turobt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","İsa ona şöyle dedi: “Sana doğrusunu söylüyorum: bu gece, horoz ötmeden, sen beni üç defa inkâr edeceksin.” ");
INSERT INTO turobt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus şöyle karşılık verdi: “Seninle birlikte ölmem lazımsa bile, seni asla inkâr etmem.” Bütün öğrenciler de aynısını söylediler. ");
INSERT INTO turobt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bunun üzerine İsa onlarla birlikte Getsemani denilen bahçeye gitti. İsa öğrencilerine şöyle dedi: “Ben şuraya kadar gidip dua edeceğim. Siz burada oturun.” ");
INSERT INTO turobt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yanına Petrusʼu ve Zebediʼnin iki oğlunu aldı. Üzüntü ve derin bir sıkıntı hissetmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bunun üzerine onlara şunu söyledi: “Ben ölüm derecesinde üzüntülüyüm. Burada kalın ve benimle birlikte uyanık durun.” ");
INSERT INTO turobt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","İsa biraz ileri gitti, yüzüstü yere kapandı ve şöyle dua etmeye başladı: “Baba, mümkünse, bu bardak benden geçsin. Yine de, benim istediğim değil, senin istediğin olsun.” ");
INSERT INTO turobt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","İsa öğrencilerine döndü, onları uykuda buldu. Petrusʼa şöyle dedi: “Demek ki, bir saat bile, benimle birlikte uyanık duramadınız. ");
INSERT INTO turobt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uyanık durun. Denendiğinizde günaha düşmemek için dua edin. Ruh istekli, ama beden zayıftır.” ");
INSERT INTO turobt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","İsa ikinci defa gidip şöyle dua etti: “Baba, eğer ben içmeden bu bardağın benden alınması mümkün değilse, o vakit senin istediğin olsun.” ");
INSERT INTO turobt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bir daha geldiğinde onları uykuda buldu, çünkü gözlerini açık tutamıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bu sefer onları bırakıp döndü ve üçüncü defa aynı sözlerle dua etti. ");
INSERT INTO turobt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bunun üzerine öğrencilere gelip şöyle dedi: “Hâlâ uyuyor ve dinleniyorsunuz! Bakın, İnsan Oğluʼnun günahkârların eline teslim edileceği saat geldi. ");
INSERT INTO turobt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kalkın, gidelim. Bakın, bana ihanet eden adam yaklaşıyor!” ");
INSERT INTO turobt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","İsa daha konuşurken, işte, on iki elçisinden biri olan Yahuda geldi. Yanında büyük bir kalabalık vardı. Kılıçlar ve sopalar taşıyorlardı. Başrahipler ve halkın liderleri onları yollamıştı. ");
INSERT INTO turobt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","İsaʼya ihanet eden Yahuda onlara şöyle bir işaret vermişti: “Ben kimi öpersem, İsa Oʼdur. Oʼnu yakalayın.” ");
INSERT INTO turobt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dosdoğru İsaʼya yaklaşıp, “Selam, Öğretmenim!” dedi ve Oʼnu öptü. ");
INSERT INTO turobt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","İsa ona, “Arkadaş!” dedi. “Yapmaya geldiğin işi yap!” Sonra adamlar gelip İsaʼyı yakalayıp tutukladılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","İsaʼyla birlikte olanlardan biri ani bir hareketle kılıcını çekip başrahibin kölesinin kulağını kesti. ");
INSERT INTO turobt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","O vakit İsa o kişiye, “Kılıcını yerine koy!” dedi. “Çünkü her kim kılıç çekerse, kendisi kılıçla ölür. ");
INSERT INTO turobt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yoksa göksel Babamʼdan yardım rica edemez miyim sanıyorsun? O zaman O hemen emrime on iki ordudan fazla melek koyar. ");
INSERT INTO turobt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama o vakit her şeyin böyle olması gerektiğini söyleyen Kutsal Yazılar nasıl yerine gelecek?” ");
INSERT INTO turobt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sonra İsa kalabalığa dönerek, “Haydut muyum ki beni kılıçlarla, sopalarla yakalamaya çıktınız?” dedi. “Her gün tapınak avlusunda oturup vaaz ederdim ve beni tutuklamadınız. ");
INSERT INTO turobt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama bütün bunlar peygamberlerin yazdıkları yerine gelsin diye oldu.” Bunun üzerine bütün öğrencileri İsaʼyı bırakıp kaçtılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","İsaʼyı yakalayanlar Oʼnu Başrahip Kayafaʼnın önüne götürdüler. Tevrat uzmanları ve liderler orada toplanmıştı. ");
INSERT INTO turobt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus ise İsaʼyı uzaktan izledi. Sonunda başrahibin avlusuna yetişti. İçeri girip görevlilerle birlikte oturdu. Bu işin sonu ne olacak diye merak ediyordu. ");
INSERT INTO turobt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Başrahipler ve Meclisʼin öbür üyeleri İsaʼyı ölüm cezasına çarptırabilmek için Oʼna karşı şahitlik yapacak birilerini bulmaya çalışıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bir sürü yalancı şahit öne çıktıysa da, aradıklarını bulamadılar. En sonunda iki kişi öne çıkıp şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bu adam, ‘Allahʼın tapınağını yıkabilirim ve üç gün sonra onu yeniden kurabilirim’ dedi.” ");
INSERT INTO turobt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Başrahip ayağa kalkıp İsaʼya şunu sordu: “Bu adamların sana karşı yaptıkları şahitliklere cevabın yok mu?” ");
INSERT INTO turobt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama İsa hep sustu. Başrahip Oʼna şöyle dedi: “Diri olan Allahʼın adına sana yemin ettiriyorum, söyle bize, Allahʼın Oğlu Mesih sen misin?” ");
INSERT INTO turobt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","İsaʼnın cevabı şuydu: “Sen kendin söyledin. Yine de size söylüyorum: Bundan sonra İnsan Oğluʼnun kudret Sahibiʼnin sağında oturduğunu, ve gökteki bulutların üzerinde geldiğini göreceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bunun üzerine başrahip elbiselerini yırttı ve şöyle dedi: “Allahʼa hakaret etti. Artık şahitlere ne ihtiyacımız var? Kendini Allahʼla bir saydığını siz kendiniz işittiniz. ");
INSERT INTO turobt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kararınız ne?” Meclisʼtekiler şöyle cevap verdiler: “Ölümü hak etti!” ");
INSERT INTO turobt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ondan sonra İsaʼnın yüzüne tükürdüler. Oʼnu yumruklayarak dövdüler. Bazıları Oʼnu tokatladılar. ");
INSERT INTO turobt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ey Mesih! Haydi peygamberliğini göster! Sana vuran kim?” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bu arada Petrus dışarda avluda oturuyordu. Bir hizmetçi kız gelip ona şöyle dedi: “Sen de Celileli İsaʼyla birlikteydin.” ");
INSERT INTO turobt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama Petrus bunu herkesin önünde inkâr edip, “Ne söylediğini anlamıyorum!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sonra avlunun kapısının önüne çıktı. O vakit başka bir hizmetçi kız Petrusʼu gördü ve orada duranlara, “Bu adam Nasıralı İsaʼyla birlikteydi” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus ise yemin ederek “Ben o adamı tanımıyorum!” diye yine inkâr etti. ");
INSERT INTO turobt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Az sonra orada duranlar yaklaşıp Petrusʼa şöyle dediler: “Elbette sen de onlardansın. Konuşman seni ele veriyor.” ");
INSERT INTO turobt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bunun üzerine Petrus lanet okuyarak yemin etti: “O adamı tanımıyorum!” O anda horoz öttü. ");
INSERT INTO turobt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","O vakit Petrus, İsaʼnın ona söylediği sözleri hatırladı: “Horoz ötmeden sen beni üç defa inkâr edeceksin.” Dışarı çıkıp acı acı ağladı. ");
INSERT INTO turobt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sabah olunca, başrahipler ve halkın liderleri, İsaʼyı ölüm cezasına çarptırmak için anlaştılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oʼnu bağlayıp götürdüler ve Vali Pilatusʼa teslim ettiler. ");
INSERT INTO turobt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","İsaʼya ihanet eden Yahuda İsaʼnın ölüm cezasına çarptırıldığını görünce yaptığına pişman oldu. Otuz gümüş parayı alıp başrahiplere ve halkın liderlerine geri götürdü. ");
INSERT INTO turobt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Günah işledim” dedi. “Suçsuz bir adama ihanet ettim!” Onlarsa şöyle karşılık verdiler: “Bundan bize ne? Onu sen düşün.” ");
INSERT INTO turobt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuda parayı tapınağın içine fırlattı ve oradan ayrıldı. Sonra gidip kendini astı. ");
INSERT INTO turobt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Başrahipler parayı alıp şöyle dediler: “Bu para kan parasıdır. Onu tapınak hazinesine koymak Tevratʼa uygun değildir.” ");
INSERT INTO turobt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sonra aralarında anlaşarak o parayla Çömlekçi Tarlasıʼnı satın aldılar. Orada yabancılar için bir mezarlık yapacaklardı. ");
INSERT INTO turobt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bunun için o tarlanın adı bugüne kadar Kan Tarlası diye kaldı. ");
INSERT INTO turobt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","O vakit Allahʼın peygamber Yeremya aracılığıyla söylediği şu söz yerine geldi: “İsrailoğulları otuz gümüşü aldılar, bir insana biçtikleri değer buydu. ");
INSERT INTO turobt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rabbin bana buyurduğu gibi, bu parayla çömlekçinin tarlasını satın aldılar.” ");
INSERT INTO turobt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","İsa, valinin önüne götürüldü. O da İsaʼyı sorguya çekti: “Sen Yahudilerin Kralı mısın?” İsa da, “Bunu sen söylüyorsun” dedi. ");
INSERT INTO turobt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Başrahipler ve halkın liderleri Oʼnu suçladılar. Ama İsa hiç karşılık vermedi. ");
INSERT INTO turobt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sonra Pilatus Oʼna şöyle dedi: “Sana karşı yapılan bunca şahitliği duymuyor musun?” ");
INSERT INTO turobt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama İsa tek bir suçlamaya bile cevap vermedi. Vali buna çok şaştı. ");
INSERT INTO turobt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Valinin bir adeti vardı: her yıl Özgürlük Bayramıʼnda halkın istediği bir tutukluyu serbest bırakırdı. ");
INSERT INTO turobt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","O günlerde Barabba adında çok tanınmış bir tutuklu vardı. ");
INSERT INTO turobt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Halk bir araya geldikten sonra, Pilatus onlara sordu: “Kimi serbest bırakmamı istersiniz: Barabbaʼyı mı, yoksa Mesih denilen İsaʼyı mı?” ");
INSERT INTO turobt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus, başrahipler ve halkın liderlerinin İsaʼyı kıskandıkları için Oʼnu kendisine teslim ettiklerini biliyordu. ");
INSERT INTO turobt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus yargı yerinde otururken, karısı ona şu haberi yolladı: “O adam suçsuzdur. Sakın bu işe karışma. Dün gece Oʼnun hakkında bir rüya gördüm. Bu rüya yüzünden çok acı çektim.” ");
INSERT INTO turobt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Başrahipler ve halkın liderleri, Barabbaʼnın serbest bırakılması ve İsaʼnın öldürülmesini istesinler diye kalabalığı kandırdılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ama Pilatus kalabalığa şunu sordu: “Ne istersiniz? Bu iki adamdan hangisini serbest bırakayım?” Onlar da “Barabbaʼyı” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus, “Öyleyse, Mesih denilen İsaʼyla ne yapayım?” diye sordu. Hepsi, “Çarmıha gerilsin!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus sordu: “Adam ne kötülük yaptı ki?” Ama seslerini daha da fazla yükselterek, “Çarmıha gerilsin!” diye bağırdılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus durumu değiştiremeyeceğini anladı. Tam tersine halk ayaklanmaya başlıyordu. Pilatus su alıp halkın önünde ellerini yıkadı ve şöyle dedi: “Bu adamın kanından ben sorumlu değilim. Gerisi size kalmış.” ");
INSERT INTO turobt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Halk da şöyle cevap verdi: “Oʼnun kanı bizim ve evlatlarımızın üzerinde olsun!” ");
INSERT INTO turobt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sonra Pilatus Barabbaʼyı serbest bıraktı. İsaʼyı ise, kamçılattı ve çarmıha gerilsin diye askerlere teslim etti. ");
INSERT INTO turobt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Valinin askerleri İsaʼyı alıp Pretoriyum denen vali sarayına götürdüler. Bütün asker bölüğünü İsaʼnın etrafına topladılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Oʼnun elbiselerini çıkarıp üstüne kırmızı bir kaftan attılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dikenlerden bir taç örüp başına koydular. Sağ eline bir sopa verdiler. Oʼnunla alay etmek için, önünde diz çöküp, “Yaşasın Yahudilerin kralı!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Üzerine tükürdüler, sopayı alıp başına vurdular. ");
INSERT INTO turobt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","İsaʼyla alay ettikten sonra üzerinden kaftanı çıkarıp kendi elbiselerini giydirdiler. Sonra Oʼnu çarmıha germeye götürdüler. ");
INSERT INTO turobt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Onlar şehirden çıkarken, Simun adında Kireneli bir adam buldular. Onu İsaʼnın çarmıhını taşımaya zorladılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgota denilen yere geldiler. Bu ad kafatası yeri anlamına gelir. ");
INSERT INTO turobt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","İsaʼya öd denilen acı ilaçla karıştırılmış şarap verdiler. Ama İsa şarabı tadınca içmek istemedi. ");
INSERT INTO turobt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","İsaʼyı çarmıha gerdiler. Kura çekerek elbiselerini aralarında paylaştılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sonra oraya oturup İsaʼnın yanında nöbet tuttular. ");
INSERT INTO turobt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Başının üzerine Oʼnu suçlayan bir yazı astılar: “Bu, Yahudilerin Kralı İsaʼdır.” ");
INSERT INTO turobt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","İki haydut İsaʼyla aynı zamanda çarmıha gerildi. Biri sağındaki, öbürü solundaki çarmıhtaydı. ");
INSERT INTO turobt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Oradan geçenler başlarını sallayıp İsaʼya hakaret ettiler. ");
INSERT INTO turobt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Şöyle dediler: “Hani tapınağı yıkıp üç günde yeniden kuracaktın! Kendini kurtar bakalım. Eğer Allahʼın Oğluʼysan çarmıhtan in!” ");
INSERT INTO turobt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bunun gibi, başrahipler, Tevrat uzmanları ve halkın liderleri İsaʼyla alay ettiler: ");
INSERT INTO turobt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Başkalarını kurtardı ama kendini kurtaramıyor! O İsrailʼin Kralı imiş! Şimdi çarmıhtan insin de, Oʼna iman edelim. ");
INSERT INTO turobt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Allahʼa güveniyormuş. ‘Allahʼın Oğlu benim’ derdi. Eğer Allah Oʼnu seviyorsa, şimdi kurtarsın bakalım!” ");
INSERT INTO turobt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","İsaʼyla birlikte çarmıha gerilmiş haydutlar da Oʼnu aşağıladılar. ");
INSERT INTO turobt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Öğleyin saat on ikiden saat üçe kadar bütün ülkenin üzerine karanlık çöktü. ");
INSERT INTO turobt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Saat üçe doğru İsa yüksek sesle şöyle bağırdı: “Eli, Eli, lema şevaktani?” Bu söz, “Allahım, Allahım, beni niçin terk ettin?” demektir. ");
INSERT INTO turobt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Orada duranların bazıları bunu işitince “Bu adam İlyasʼı çağırıyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Onlardan biri hemen koşup bir sünger aldı, onu ekşi şaraba batırdı, süngeri bir kamışın ucuna taktı ve içmesi için İsaʼya uzattı. ");
INSERT INTO turobt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama öbürleri, “Dur bakalım, İlyas gelip Oʼnu kurtaracak mı?” dediler. ");
INSERT INTO turobt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","İsa ise tekrar yüksek sesle bağırıp ruhunu teslim etti. ");
INSERT INTO turobt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","O anda tapınaktaki perde yukarıdan aşağıya kadar yırtılıp ikiye ayrıldı. Yer sarsıldı ve kayalar yarıldı. ");
INSERT INTO turobt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mezarlar açıldı ve Allahʼın kutsal halkından ölmüş olan birçok kişinin cesetleri dirildi. ");
INSERT INTO turobt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Onlar İsaʼnın dirilişinden sonra mezarlarından çıkıp kutsal şehre girdiler ve birçok kişiye göründüler. ");
INSERT INTO turobt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","İsaʼya bekçilik yapan yüzbaşı ve onun yanındaki adamlar deprem ve diğer olup bitenleri gördüler. Bu yüzden çok korktular ve şöyle dediler: “Bu adam gerçekten de Allahʼın Oğluʼydu!” ");
INSERT INTO turobt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Olaylara uzaktan bakan birçok kadın da oradaydı. Bunlar, Celileʼden İsaʼnın peşinden gelip Oʼna hizmet etmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kadınların arasında Mecdelli Meryem, Yakubʼun ve Yusufʼun annesi Meryem ve Zebedi oğullarının annesi vardı. ");
INSERT INTO turobt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Akşam olunca, Aramatyalı Yusuf adında zengin bir adam geldi. Kendisi de İsaʼnın öğrencisiydi. ");
INSERT INTO turobt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bu adam Pilatusʼa gidip İsaʼnın ölüsünü istedi. Pilatus cesedin ona verilmesi için buyruk verdi. ");
INSERT INTO turobt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuf İsaʼnın cesedini alıp temiz bir keten beze sardı. ");
INSERT INTO turobt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yusuf kendisi için kayanın içine yeni bir mezar oydurmuştu. İsaʼnın cesedini oraya koydu. Mezarın kapısının önüne kocaman bir taş yuvarladı ve oradan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bu arada Mecdelli Meryem ve öteki Meryem oradaydı, mezarın karşısında oturuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ertesi gün, yani Hazırlık Günüʼnden sonraki gün,başrahipler ve Ferisiler toplanıp hep birlikte Pilatusʼa gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Şöyle dediler: “Efendimiz, şu yalancının daha hayattayken, ‘Üç gün sonra dirileceğim’ dediğini hatırlıyoruz. ");
INSERT INTO turobt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bu sebeple, buyruk ver ki, mezar üçüncü güne kadar koruma altına alınsın. Öğrencileri gelip ölüyü çalmasınlar, sonra da halka, ‘O, ölümden dirildi’ demesinler. Yoksa, son yalan ilkinden beter olacak.” ");
INSERT INTO turobt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus onlara şöyle dedi: “Buyurun, bir grup kollayıcı asker sizin olsun. Gidin, elinizden geldiği kadar mezarı koruma altına alın.” ");
INSERT INTO turobt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gidip taşı mühürlediler, başına askerler diktiler. Böylece mezarı koruma altına aldılar. ");
INSERT INTO turobt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Şabat gününden sonra, yani pazar günü güneşin doğmasından az önce, Mecdelli Meryem ve öteki Meryem mezarı görmeye gittiler. ");
INSERT INTO turobt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aniden büyük bir deprem oldu. Rabbin bir meleği gökten indi. Mezara yaklaşarak taşı kenara yuvarladı ve o taşın üstüne oturdu. ");
INSERT INTO turobt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Onun görünüşü şimşek gibi parlak, elbiseleri de kar gibi beyazdı. ");
INSERT INTO turobt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kollayıcı askerler korkudan titreyip ölü gibi yere yıkıldılar. ");
INSERT INTO turobt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Melek kadınlara şöyle dedi: “Korkmayın! Biliyorum, siz çarmıha gerilmiş İsaʼyı arıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O burada yok, söylediği gibi dirildi. Gelin, Oʼnun yattığı yeri görün. ");
INSERT INTO turobt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hemen gidin ve Oʼnun öğrencilerine şöyle deyin: ‘İsa ölümden dirildi. O sizden önce Celileʼye gidiyor. Oʼnu orada göreceksiniz.’ İşte, size haber verdim.” ");
INSERT INTO turobt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kadınlar çabucak mezardan ayrıldılar. Hem korku, hem de büyük sevinç içindeydiler. İsaʼnın öğrencilerine haber vermeye koştular. ");
INSERT INTO turobt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tam o sırada İsa onlarla karşılaştı ve selam verdi. Onlar da yaklaşıp İsaʼnın ayaklarına sarıldılar ve Oʼna tapındılar. ");
INSERT INTO turobt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","O zaman İsa onlara şöyle dedi: “Korkmayın! Gidin, imanlı kardeşlerime haber verin, Celileʼye doğru yola çıksınlar. Orada beni görecekler.” ");
INSERT INTO turobt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kadınlar daha yoldayken, kollayıcı askerlerden bazıları şehre gittiler ve olup biten her şeyi başrahiplere bildirdiler. ");
INSERT INTO turobt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Onlar da halk liderleriyle toplanıp birbirlerine danıştılar. Sonra askerlere çok para verdiler. ");
INSERT INTO turobt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Onlara şöyle dediler: “Şunu söyleyin: ‘İsaʼnın öğrencileri gece gelip biz uyurken cesedini çaldılar.’ ");
INSERT INTO turobt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bu haber valinin kulağına giderse, biz onu kandırıp sizi beladan uzak tutacağız.” ");
INSERT INTO turobt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Askerler de parayı alıp, kendilerine söyleneni yaptılar. Bu söz Yahudilerin arasında çok yayıldı, ve hâlâ yaygındır. ");
INSERT INTO turobt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","On bir öğrenci de Celile bölgesine, İsaʼnın onlara buyurduğu dağa gitti. ");
INSERT INTO turobt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","İsaʼyı görünce, Oʼna tapınmaya başladılar. Bazıları ise, şüphe içindeydi. ");
INSERT INTO turobt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","İsa onlara yaklaşıp şöyle dedi: “Gökte ve yeryüzünde bütün yetki bana verildi. ");
INSERT INTO turobt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bunun için gidin, bütün milletleri öğrencilerim olarak yetiştirin. Onları Baba, Oğul ve Kutsal Ruhadıylavaftiz edin. ");
INSERT INTO turobt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Size emrettiğim her şeyi yerine getirmeyi onlara öğretin. Bakın, ben dünyanın sonuna kadar her zaman sizinle birlikteyim.”");
INSERT INTO turobt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Allahʼın Oğlu olan İsa Mesih hakkındaki Müjde şöyle başladı: ");
INSERT INTO turobt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tıpkı Yeşaya peygamberin kitabında yazıldığı gibi: “Allah diyor ki, ‘Bak, habercimi senin önünden gönderiyorum. O, senin yolunu hazırlayacak. ");
INSERT INTO turobt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Issız yerlerde sesini yükselten biri, “Rabbin yolunu hazırlayın, geçeceği yerleri düz yapın!” diyor.’ ” ");
INSERT INTO turobt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Böylece Vaftizci Yahya ıssız yerlerde ortaya çıktı. Halkı günahlarının bağışlanması için tövbe edip vaftiz olmaya çağırıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Halk, Yeruşalim dahil, Yahudiyeʼnin her yerinden ona akın etti. Onlar günahlarını açıkça söyleyip Yahyaʼnın eliyle Şeria ırmağında vaftiz oldular. ");
INSERT INTO turobt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahya deve tüyünden elbise giyerdi ve belinde deriden bir kayış vardı. Çekirge ve yaban balı yerdi. ");
INSERT INTO turobt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Şöyle vaaz ediyordu: “Ardımdan benden daha güçlü olan geliyor. Ben eğilip Oʼnun ayaklarındaki sandalet bağlarını çözmeye layık değilim. ");
INSERT INTO turobt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ben sizi suyla vaftiz ediyorum. O sizi Kutsal Ruhʼla vaftiz edecek.” ");
INSERT INTO turobt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","O günlerde İsa Celile bölgesindeki Nasıra kasabasından geldi ve Yahyaʼnın eliyle Şeria ırmağında vaftiz oldu. ");
INSERT INTO turobt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tam sudan çıkarken göklerin yarıldığını ve Ruhʼun bir güvercin gibi üzerine indiğini gördü. ");
INSERT INTO turobt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gökten gelen bir ses şöyle dedi: “Sen benim sevgili Oğlumʼsun. Senden memnunum.” ");
INSERT INTO turobt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bundan hemen sonra Kutsal Ruh İsaʼyı ıssız yerlere gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","İsa ıssız yerlerde kırk gün kaldı ve Şeytan Oʼnu günaha düşürmeye çalıştı. İsa yabani hayvanların arasındaydı ve melekler Oʼna hizmet etti. ");
INSERT INTO turobt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yahya tutuklandıktan sonra, İsa Celile bölgesine gitti ve Allahʼın Müjdeʼsini duyurmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Artık vakit doldu. Allahʼın Krallığı yaklaştı. Tövbe edin ve Müjdeʼye iman edin!” diyordu. ");
INSERT INTO turobt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","İsa Celile Gölüʼnün kenarında yürürken, Simun ve kardeşi Andreasʼı gördü. Göle ağ atıyorlardı, çünkü balıkçıydılar. ");
INSERT INTO turobt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","İsa onlara şöyle dedi: “Peşimden gelin. Sizi bana insan kazanan balıkçılar yapacağım.” ");
INSERT INTO turobt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Onlar da hemen ağlarını bırakıp İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","İsa az öteye gidince Zebediʼnin oğulları Yakub ve Yuhannaʼyı gördü. Onlar teknede ağlarını tamir ediyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","İsa hemen onları yanına çağırdı. Onlar da babaları Zebediʼyi teknede, işçilerin yanında bırakıp İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kefernahum kasabasına girdiler. Şabat günü İsa Yahudilerin toplantı yerine gidip vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Oradakiler İsaʼnın vaaz etmesine şaşırıp kaldılar. Çünkü onlara Tevrat uzmanları gibi değil, yetkiye sahip biri olarak vaaz ediyordu. ");
INSERT INTO turobt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","O sırada toplantı yerinde içinde şeytani ruh olan bir adam vardı. Yüksek sesle bağırıp şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasıralı İsa, bizden ne istiyorsun? Bizi yok etmeye mi geldin? Senin kim olduğunu biliyorum: sen Allahʼın kutsal Mesihiʼsin!” ");
INSERT INTO turobt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","İsa şeytani ruhu azarladı. Ona, “Sus! Çık o adamdan!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Şeytani ruh adamı sarstı, yüksek sesle bağırarak içinden çıktı. ");
INSERT INTO turobt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Herkes şaşırıp kaldı. Birbirleriyle şöyle tartışmaya başladılar: “Nedir bu? Yeni bir çeşit vaaz! Bu adamın nasıl bir yetkisi var! Şeytani ruhlara bile emrediyor, ruhlar da Oʼnun sözünü dinliyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hemen İsa hakkındaki haber bütün Celile bölgesine yayıldı. ");
INSERT INTO turobt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bu olaydan hemen sonra İsa Yahudilerin toplantı yerinden çıktı ve Yakubʼla Yuhannaʼyla birlikte Simun ve Andreasʼın evine gitti. ");
INSERT INTO turobt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simunʼun kaynanası ateşler içinde hasta yatıyordu. Durumu hemen İsaʼya anlattılar. ");
INSERT INTO turobt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","İsa kadının yanına gitti, onu elinden tutup ayağa kaldırdı. O zaman kadının ateşi düştü ve onlara hizmet etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Akşam güneş battıktan sonra bütün hastaları ve cinli olanları İsaʼya getirdiler. ");
INSERT INTO turobt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bütün kasaba halkı toplanıp evin kapısına dikilmişti. ");
INSERT INTO turobt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","İsa çeşitli hastalıklardan rahatsız olanları iyileştirdi. Birçok cini de kovdu. Cinler İsaʼnın kim olduğunu biliyorlardı. Bu sebeple İsa onların konuşmasına izin vermedi. ");
INSERT INTO turobt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sabah erken henüz karanlıkken İsa kalkıp dışarı çıktı, ıssız bir yere gitti ve orada dua etti. ");
INSERT INTO turobt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simun ve yanındakiler Oʼnu aramaya çıktılar. ");
INSERT INTO turobt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oʼnu bulunca, “Herkes seni arıyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","İsa onlara şöyle dedi: “Başka yerlere, çevre kasabalara gidelim, orada da vaaz edeyim. Zaten ben bunun için geldim.” ");
INSERT INTO turobt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","İsa Celile bölgesinin her tarafını dolaştı. Halkın toplantı yerlerinde vaaz etti ve insanlardan cinleri kovdu. ");
INSERT INTO turobt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Cüzzam hastası bir adam İsaʼya geldi. Oʼnun önünde diz çöküp şöyle yalvardı: “İstersen, beni hastalığımdan temizleyebilirsin!” ");
INSERT INTO turobt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","İsa adama acıdı, elini uzatıp ona dokundu. “İsterim” dedi. “Temiz ol!” ");
INSERT INTO turobt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Adam o anda cüzzam hastalığından kurtuldu ve temiz oldu. ");
INSERT INTO turobt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","İsa adamı sıkıca uyarıp şöyle dedi: “Bunu kimseye anlatma. Ancak git. İnsanlara şahitlik olsun diye rahibe görün. Musaʼnın buyurduğu gibi kendin için bir temizlenme kurbanı sun.” Sonra hemen adamı oradan gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Fakat adam gitti, İsaʼnın yaptığını serbestçe duyurmaya ve sağa sola yaymaya başladı. Bu yüzden İsa hiçbir kasabaya açıkça giremedi. Issız yerlerde kaldı. Yine de insanlar her taraftan akın akın Oʼna geliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Birkaç gün sonra İsa Kefernahumʼa döndü. İsaʼnın evde olduğu haberi halkın arasında yayıldı. ");
INSERT INTO turobt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","O kadar insan toplandı ki, artık kapının önünde bile duracak yer kalmamıştı. İsa oradaki insanlara Allahʼın sözünü duyuruyordu. ");
INSERT INTO turobt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","O arada Oʼna felçli bir adam getirdiler. Adamı dört kişi taşıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ama kalabalık yüzünden onu İsaʼya getiremediler. O zaman çatıda bir delik açtılar ve felçli adamı yattığı döşekle birlikte aşağı indirdiler. ");
INSERT INTO turobt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","İsa onların imanını görünce, felçli adama, “Evladım” dedi. “Günahların bağışlandı.” ");
INSERT INTO turobt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Orada oturan bazı Tevrat uzmanları şöyle düşündüler: ");
INSERT INTO turobt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bu adam neden böyle konuşuyor? Allahʼa hakaret ediyor! Allahʼtan başka kim günahları bağışlayabilir?” ");
INSERT INTO turobt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","İsa böyle düşündüklerini hemen ruhunda fark etti. Onlara, “Aklınızda neden böyle düşüncelere yer veriyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Hangisi daha kolay? Felçli adama, ‘Günahların bağışlandı’ demek mi, yoksa ‘Kalk, döşeğini al ve yürü’ demek mi? ");
INSERT INTO turobt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ama İnsan Oğluʼnun yeryüzünde günahları bağışlama yetkisine sahip olduğunu bilesiniz diye…” Felçli adama şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Sana söylüyorum: ‘Kalk, döşeğini al ve evine git!’ ” ");
INSERT INTO turobt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Adam kalktı, hemen döşeğini kaldırıp herkesin gözü önünde dışarı çıktı. Herkes şaşırıp kaldı ve “Böyle bir şey hiç görmedik!” deyip Allahʼı övdüler. ");
INSERT INTO turobt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","İsa yine göl kenarına gitti. Bütün halk Oʼnun yanına geldi, O da onlara vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Daha sonra İsa gezinirken Alpay oğlu Leviʼyi gördü. O vergi toplanma yerinde oturuyordu. İsa ona, “Peşimden gel!” dedi. O da kalkıp İsaʼnın peşinden gitti. ");
INSERT INTO turobt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sonra İsa, Leviʼnin evinde oturmuş yemek yiyordu. O zaman vergi memurları dahil birçok günahkâr İsaʼyla ve Oʼnun öğrencileriyle birlikte yemeğe oturdu. İsaʼnın peşinden giden böyle birçok kişi vardı. ");
INSERT INTO turobt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ferisi partisinden bazı Tevrat uzmanları İsaʼnın günahkârlarla ve vergi memurlarıyla yemek yediğini gördüler. İsaʼnın öğrencilerine şöyle dediler: “Nasıl olur da, vergi memurları ve günahkârlarla birlikte yemek yiyor?” ");
INSERT INTO turobt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","İsa bunu işitince şöyle cevap verdi: “Sağlıklı insanların değil, hasta olanların doktora ihtiyacı var. Ben doğru kişileri değil, günahkârları çağırmaya geldim.” ");
INSERT INTO turobt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yahyaʼnın öğrencileri ve Ferisiler oruç tutuyordu. Bazı kişiler gelip İsaʼya şunu sordular: “Yahyaʼnın öğrencileri ve Ferisilerin öğrencileri oruç tutuyorlar. Neden senin öğrencilerin oruç tutmuyor?” ");
INSERT INTO turobt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","İsa da onlara şöyle dedi: “Damat onların arasındayken, damadın arkadaşları oruç tutabilirler mi? Hayır, damat onların arasındayken, oruç tutmazlar! ");
INSERT INTO turobt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama gün gelecek, damat aralarından alınacak. İşte o günlerde oruç tutacaklar. ");
INSERT INTO turobt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hiç kimse yepyeni bir kumaş parçasını alıp onu eski bir elbiseye yama yapmaz. Yoksa yeni parça eski elbiseden sökülür ve yırtık daha büyür. ");
INSERT INTO turobt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hiç kimse de yeni şarabı eski tulumlara doldurmaz. Yoksa şarap tulumları patlatır; hem şarap, hem de tulumlar ziyan olur. Hayır, yeni şarap yeni tulumlara doldurulur!” ");
INSERT INTO turobt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Şabat günü İsa ekin tarlalarından geçiyordu. Öğrencileri yolda giderken ekin başaklarını koparmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ferisiler İsaʼya şöyle dediler: “Neden öğrencilerinŞabat gününde Tevratʼta yasaklananı yapıyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","İsa da onlara şöyle cevap verdi: “Davud ve adamları muhtaç kalıp acıkınca Davudʼun ne yaptığını hiç okumadınız mı? ");
INSERT INTO turobt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aviyatarʼın başrahip olduğu günlerde Allahʼın evine girip adak ekmeklerinden yedi ve yanındakilere de verdi. Oysa o ekmekten yemeye sadece rahiplerin izni vardı.” ");
INSERT INTO turobt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sonra İsa şöyle devam etti: “Şabat günü insan için yaratıldı. İnsan Şabat günü için yaratılmadı. ");
INSERT INTO turobt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bu sebeple İnsan Oğlu olarak ben Şabat gününün de efendisiyim.” ");
INSERT INTO turobt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","İsa yine Yahudilerin toplantı yerine girdi. Orada eli sakat bir adam vardı. ");
INSERT INTO turobt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bazıları, Şabat günü şifa verecek mi diye İsaʼyı yakından izliyorlardı. İsaʼyı suçlayacak bir sebep arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","İsa eli sakat adama, “Kalk, ortaya geç!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sonra oradakilere sordu: “Şabat günü iyilik mi yoksa kötülük mü yapmak Tevratʼa uygundur? Bir hayatı kurtarmak mı, yoksa onu yok etmek mi uygundur?” Onlardan hiç ses çıkmadı. ");
INSERT INTO turobt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","İsa etrafındakilere öfkeyle baktı. Yüreklerinin bu kadar duyarsız olmasına üzüldü. Adama, “Elini uzat!” dedi. Adam elini uzattı ve eli sapasağlam oldu. ");
INSERT INTO turobt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ferisiler oradan uzaklaştılar. Hemen gidip Hirodesçilerle görüştüler. İsaʼyı nasıl yok edecekleri konusunda plan kurmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","İsa öğrencileriyle birlikte göl kenarına çekildi. Büyük bir kalabalık Oʼnunla beraber yürüyordu. Bu insanlar Celileʼden, Yahudiyeʼden, Yeruşalimʼden, İdumeya bölgesinden, Şeria ırmağının ötesinden, Sur ve Sayda şehirlerinin etrafından gelmişlerdi. İsaʼnın yaptıklarının haberini alıp Oʼna geldiler. ");
INSERT INTO turobt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","İsa kalabalık tarafından ezilmemek için öğrencilerine bir tekne hazırlamalarını buyurdu. ");
INSERT INTO turobt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","İsa birçok kişiyi iyileştirmişti. Bu yüzden hastalık çeken herkes itişe kakışa Oʼna dokunmaya çalışıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Şeytani ruhlar da İsaʼyı görünce Oʼnun önünde yere kapanıp bağıra bağıra, “Sen Allahʼın Oğluʼsun!” diyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Fakat İsa kim olduğunu açıklamasınlar diye onları sıkı sıkıya uyardı. ");
INSERT INTO turobt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","İsa bir dağa çıkıp istediği kişileri kendisine çağırdı. Onlar da yanına geldiler. ");
INSERT INTO turobt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Onlardan on iki kişiyi seçti ve onlara elçi adını verdi. Onları yanında bulundurmak, vaaz etmeye göndermek ve onlara cinleri kovma yetkisini vermek istiyordu. ");
INSERT INTO turobt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","İsa şu on iki kişiyi seçti: Petrus lakabıyla tanınan Simun, ");
INSERT INTO turobt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Beni-Regeş, yani Gökgürültüsü Oğulları takma adıyla tanınan Zebediʼnin oğulları Yakub ve Yuhanna, ");
INSERT INTO turobt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartalmay, Matta, Tomas, Alpay oğlu Yakub, Taday, Yurtsever Simun ");
INSERT INTO turobt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ve İsaʼya ihanet eden Yahuda İskariyot. ");
INSERT INTO turobt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sonra İsa bir eve gitti. Kalabalık yine toplanınca evdekilerin yemek yemeye bile fırsatı kalmadı. ");
INSERT INTO turobt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","İsaʼnın hısımları bunu öğrenince “Aklını kaçırmış” diyerek Oʼnu oradan alıp götürmek için yola çıktılar. ");
INSERT INTO turobt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yeruşalimʼden Tevrat uzmanları geldiler. “Oʼnda Baalzevul var” dediler. “Cinleri cinlerin lideri Şeytanʼın gücüyle kovuyor.” ");
INSERT INTO turobt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","İsa onları yanına çağırdı ve benzetmeler kullanarak şöyle dedi: “Şeytan Şeytanʼı nasıl kovabilir? ");
INSERT INTO turobt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bir krallık kendi içinde bölünmüşse, o krallık ayakta duramaz. ");
INSERT INTO turobt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bir hane kendi içinde bölünmüşse, o hane ayakta duramaz. ");
INSERT INTO turobt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Şeytan da kendine karşı gelip içinde bölünmüşse, ayakta kalamaz, sonu gelmiştir. ");
INSERT INTO turobt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kimse güçlü adamın evine girip mallarını çalamaz. Ancak adamın elini kolunu bağladıktan sonra evini soyabilir. ");
INSERT INTO turobt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Size doğrusunu söylüyorum: İnsanların işlediği her günah ve ettiği her hakaret bağışlanabilir, ama kim Kutsal Ruhʼa hakaret ederse, o hiçbir zaman bağışlanmayacak. O kişinin günahı sonsuza kadar boynunda kalacak.” ");
INSERT INTO turobt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","İsa bu sözleri, “Oʼnda şeytani ruh var” dedikleri için söyledi. ");
INSERT INTO turobt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","İsaʼnın annesiyle kardeşleri gelip dışarda durdular. İsaʼyı çağırması için birisini yolladılar. ");
INSERT INTO turobt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","İsaʼnın etrafında bir sürü insan oturuyordu. Oʼna şöyle dediler: “Bak, annen, kardeşlerin ve kız kardeşlerin dışarda, seni arıyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","İsa onlara şöyle cevap verdi: “Kim benim annem, kim benim kardeşlerim?” ");
INSERT INTO turobt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Etrafında oturanlara bakıp şöyle dedi: “İşte annem, işte kardeşlerim! ");
INSERT INTO turobt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Çünkü Allahʼın isteğini yerine getiren herkes, kardeşim, kız kardeşim ve annemdir.” ");
INSERT INTO turobt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","İsa yine göl kenarında vaaz etmeye başladı. Etrafına büyük bir kalabalık toplandı. Bu yüzden İsa göldeki bir tekneye binip oturdu. Kalabalık da göl kenarında duruyordu. ");
INSERT INTO turobt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Onlara benzetmelerle birçok şey öğretti. Vaaz verirken onlara şunları söyledi: ");
INSERT INTO turobt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dikkat edin! İşte, bir çiftçi ekin ekmeye gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ektiği tohumlardan bazıları yol kenarına düşmüş. Kuşlar gelip onları yemiş. ");
INSERT INTO turobt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bazı tohumlar az topraklı, taşlı yerlere düşmüş. Toprak derin olmadığı için hemen filizlenmeye başlamış. ");
INSERT INTO turobt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Güneş çıkınca da kavrulmuş. Yeteri kadar kök salamadıkları için kuruyup gitmiş. ");
INSERT INTO turobt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bazı tohumlar dikenlerin arasına düşmüş. Dikenler büyüyünce ekinleri boğmuş ve ekinler hiç ürün vermemiş. ");
INSERT INTO turobt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ama bazı tohumlar iyi toprağa düşmüş. Büyüyüp çoğalmış ve ürün vermiş: kimisi otuz kat, kimisi altmış kat, kimisi de yüz kat.” ");
INSERT INTO turobt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sonra İsa şunu ekledi: “Kulağı olan işitsin!” ");
INSERT INTO turobt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","İsa on iki elçisi ve peşinden gelen başka insanlarla yalnız kalınca, Oʼna benzetmeleri sordular. ");
INSERT INTO turobt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","İsa onlara şöyle dedi: “Allahʼın Krallığıʼnınsırrını anlama gücü size verildi. Ama bizden olmayanlara her şey benzetmelerle anlatılıyor. ");
INSERT INTO turobt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Öyle ki, ‘Hep baksınlar ama görmesinler, Hep işitsinler ama anlamasınlar. Aksi halde tövbe edip bağışlanırlar.’ ” ");
INSERT INTO turobt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","İsa onlara şunu sordu: “Bu benzetmeyi anlamıyorsanız, diğer bütün benzetmeleri nasıl anlayacaksınız? ");
INSERT INTO turobt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Çiftçinin ektiği tohum Allahʼın sözüdür. ");
INSERT INTO turobt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bazı insanlar tohumun ekildiği tarlanın kenarındaki toprak yola benzer. Onlar sözü işitir işitmez Şeytan gelir, yüreklerine ekilen sözü çalar. ");
INSERT INTO turobt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bazı insanlar tohumun ekildiği taşlı toprağa benzer. Onlar sözü işitir işitmez sevinçle kabul ederler. ");
INSERT INTO turobt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama sözün kök salmasına izin vermedikleri için sadece kısa bir zaman dayanırlar. Sonra sözden ötürü eziyet veya baskı başlayınca hemen iman yolundan dönerler. ");
INSERT INTO turobt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bazı insanlar, tohumun ekildiği dikenli toprağa benzer. Bunlar sözü işitirler. ");
INSERT INTO turobt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ama dünyanın kaygıları, zenginliğin göz boyaması ve diğer hevesler yüreklerine girip sözü boğar. Bu yüzden söz ürün vermez. ");
INSERT INTO turobt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bazılarıysa tohumun ekildiği bereketli toprağa benzer. Bunlar sözü işitip yürekten kabul ederler ve bol ürün verirler. Bazısı otuz, bazısı altmış, bazısı da yüz kat ürün verir.” ");
INSERT INTO turobt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","İsa şunu da söyledi: “İnsanlar lambayı bir kabın altına ya da bir yatağın altına koymak için içeri getirmezler, değil mi? Daha doğrusu, onu lambalığa koymak için getirirler. ");
INSERT INTO turobt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Çünkü gizli olan ancak ortaya çıkarılmak için gizlenir. Saklı olan da aydınlığa çıkmak için saklanır. ");
INSERT INTO turobt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kulağı olan işitsin!” ");
INSERT INTO turobt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","İsa şöyle devam etti: “Neye kulak verdiğinize dikkat edin. Size, verdiğiniz ölçekle verilecek, hatta fazlasıyla verilecek. ");
INSERT INTO turobt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Çünkü kim sahip olduğu şeyleri kullanırsa, ona daha çok verilecek. Ama kim kullanmazsa, elindeki de alınacak.” ");
INSERT INTO turobt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sonra İsa şöyle dedi: “Allahʼın Krallığı toprağa tohum eken bir adama benzer. ");
INSERT INTO turobt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Adam gece olunca yatar ve sabah olunca kalkar. Bu arada tohum filizlenir, büyür. Bu iş nasıl olur, adam bilmez. ");
INSERT INTO turobt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Toprak kendiliğinden ürün verir: önce filiz, sonra başak, en sonunda başağın içinde olgun taneler. ");
INSERT INTO turobt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ekinler olgunlaşınca, adam hemen orak salar, çünkü artık harman vakti gelmiştir.” ");
INSERT INTO turobt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","İsa yine şöyle dedi: “Allahʼın Krallığıʼnı neye benzetelim? Hangi benzetmeyle onu anlatalım? ");
INSERT INTO turobt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Allahʼın Krallığı hardal tohumuna benzer. Hardal tohumu toprağa ekildiği zaman, yeryüzündeki bütün tohumlardan daha küçüktür. ");
INSERT INTO turobt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama ekildikten sonra büyür ve bahçedeki bütün bitkilerden daha büyük olur. Dalları o kadar büyür ki, gökteki kuşlar onun gölgesinin altında yuva kurabilir.” ");
INSERT INTO turobt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","İsa bunun gibi birçok benzetmeyle onlara dinleyebildikleri ölçüde Allahʼın sözünü bildirirdi. ");
INSERT INTO turobt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Benzetmeler kullanmadan onlara hiçbir şey anlatmazdı. Ama öğrencileriyle baş başa kalınca, onlara her şeyi açıklardı. ");
INSERT INTO turobt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","O gün akşam olunca, İsa öğrencilerine, “Gölün öbür tarafına geçelim!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Öğrenciler kalabalığı geride bırakıp İsaʼyı binmiş olduğu tekneyle götürdüler. Teknenin yanında başka tekneler da vardı. ");
INSERT INTO turobt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","O sırada güçlü bir fırtına koptu. Dalgalar tekneye öyle çarptı ki, tekne neredeyse suyla doluyordu. ");
INSERT INTO turobt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","İsa ise, teknenin arka tarafında bir yastığa yaslanmış uyuyordu. Öğrencileri Oʼnu uyandırdılar. “Öğretmenimiz, boğuluyoruz!” dediler. “Buna hiç aldırmıyor musun?” ");
INSERT INTO turobt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","İsa uyanınca rüzgarı azarladı ve göle, “Sus, sakin ol!” dedi. Rüzgar dindi, ortalık tamamen sakinleşti. ");
INSERT INTO turobt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","İsa öğrencilerine, “Niçin böyle korkaksınız?” dedi. “İmanınız hâlâ mı yok?” ");
INSERT INTO turobt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Öğrenciler büyük korku içinde birbirlerine şöyle dediler: “Bu nasıl bir adam ki, rüzgar ve göl bile Oʼnun buyruğuna uyuyor?” ");
INSERT INTO turobt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","İsa ile öğrencileri gölün öbür tarafına, Gerasalıların bölgesine geldiler. ");
INSERT INTO turobt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","İsa tekneden iner inmez mezarlık olarak kullanılan mağaralardan çıkan bir adamla karşılaştı. Adamda şeytani ruh vardı. ");
INSERT INTO turobt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kendisi mağaralarda yaşıyordu. Kimse onu zincirle bile bağlı tutamıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ayaklarını çok defa prangaya vurdular, ellerini zincirlediler. Fakat o her seferinde zincirleri kopardı, prangaları parçaladı. Kimse adamı kontrol altına alamadı. ");
INSERT INTO turobt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gece gündüz mezarlık mağaralarda ve dağlarda bağırıp çağırırdı, kendini taşlarla yaralardı. ");
INSERT INTO turobt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Adam İsaʼyı uzaktan görünce koşarak geldi ve İsaʼnın önünde yere kapandı. ");
INSERT INTO turobt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yüksek sesle şöyle dedi: “Benden ne istiyorsun, ey İsa, yüce Allahʼın Oğlu? Allah aşkına yalvarırım, bana işkence etme!” ");
INSERT INTO turobt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Çünkü İsa ona, “Adamdan çık, ey şeytani ruh!” diyordu. ");
INSERT INTO turobt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sonra İsa adama, “Adın ne?” diye sordu. “Adım ‘Ordu’, çünkü sayımız çoktur” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kendilerini o bölgeden uzaklaştırmasın diye İsaʼya yalvarıp yakardı. ");
INSERT INTO turobt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Orada, tepe yamacında otlayan büyük bir domuz sürüsü vardı. ");
INSERT INTO turobt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Şeytani ruhlar İsaʼya şöyle yalvardılar: “Bizi domuzlara yolla, onların içine girelim.” ");
INSERT INTO turobt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","İsa onlara izin verdi. Şeytani ruhlar da adamdan çıkıp domuzların içine girdiler. Bütün sürü yaklaşık iki bin hayvandı. Domuzlar dik yamaçtan aşağı koştu ve göle atlayıp boğuldu. ");
INSERT INTO turobt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Domuzları otlatanlar oradan kaçtılar. Vardıkları kasaba ve köylerde olayı anlattılar. Halk da çıkıp olup biteni görmeye geldi. ");
INSERT INTO turobt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","İsaʼnın yanına gelince önceleri bir ordu cine tutulmuş adamı gördüler. Adam giyinmiş, aklı başına gelmiş oturuyordu. O zaman korktular. ");
INSERT INTO turobt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Olayı görenler halka cinli adama ve domuzlara ne olduğunu anlattılar. ");
INSERT INTO turobt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bunun üzerine halk o bölgeden ayrılması için İsaʼya yalvarmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","İsa tekneye binerken cinlerden kurtulmuş adam İsaʼnın yanında kalmayı rica etti. ");
INSERT INTO turobt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama İsa ona izin vermedi. Adama şöyle dedi: “Evine, ailene dön. Onlara Rabbin senin için neler yaptığını, sana nasıl merhamet ettiğini anlat.” ");
INSERT INTO turobt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Adam oradan ayrıldı. Dekapolis bölgesinde İsaʼnın onun için neler yaptığını duyurmaya başladı. Herkes de şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","İsa tekneyle tekrar öbür tarafa geçti. Göl kenarındayken İsaʼnın etrafına büyük bir kalabalık toplandı. ");
INSERT INTO turobt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Oradaki toplantı yerinin Yair adında bir lideri oraya geldi. İsaʼyı görünce Oʼnun ayaklarına kapandı. ");
INSERT INTO turobt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","İsaʼya yalvarıp yakardı, “Küçük kızım ölmek üzere. Ne olur gel, ellerinle ona dokun, şifa bulsun ve yaşasın.” ");
INSERT INTO turobt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","İsa adamla birlikte yola çıktı. Büyük bir kalabalık İsaʼnın ardından gidiyordu ve Oʼnu sıkıştırıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Orada on iki yıldan beri kanaması olan bir kadın vardı. ");
INSERT INTO turobt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bir sürü doktordan çok çekmişti. Bütün parasını doktorlara harcamıştı, fakat iyileşeceğine durumu daha da kötüleşmişti. ");
INSERT INTO turobt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","İsa hakkındaki haberi duymuştu. Kadın kalabalığın içinden İsaʼnın arkasına yanaştı, elbisesine dokundu. ");
INSERT INTO turobt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kendi kendine şöyle diyordu: “Oʼnun elbiselerine bir dokunursam, iyileşirim.” ");
INSERT INTO turobt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dokunduğu an kanaması kesildi. Kadın bedeninde o hastalıktan şifa bulduğunu hissetti. ");
INSERT INTO turobt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","İsa hemen kendisinden güç çıktığını anladı. Kalabalığa dönüp dedi: “Elbiselerime kim dokundu?” ");
INSERT INTO turobt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Öğrencileri Oʼna şöyle dediler: “Görüyorsun, kalabalık seni sıkıştırıyor. Bir de, ‘Bana kim dokundu?’ diye soruyorsun!” ");
INSERT INTO turobt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","İsa bunu yapmış olan kişiyi görmek için etrafına bakındı. ");
INSERT INTO turobt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kadın kendisine ne olduğunu fark etti. Korkudan titreyerek ortaya çıkıp İsaʼnın önünde yere kapandı. Oʼna bütün gerçeği anlattı. ");
INSERT INTO turobt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","İsa da ona, “Kızım, imanın seni kurtardı” dedi. “Esenlikle git, artık acı çekmeyeceksin.” ");
INSERT INTO turobt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","İsa henüz konuşurken, toplantı yeri liderinin evinden adamlar gelip “Kızın öldü” dediler. “Öğretmeni niçin hâlâ rahatsız ediyorsun?” ");
INSERT INTO turobt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Fakat İsa bu sözlere aldırmadı ve toplantı yerinin liderine, “Korkma!” dedi. “Yalnız iman et.” ");
INSERT INTO turobt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","İsa sadece Petrus, Yakub ve Yakubʼun kardeşi Yuhannaʼyı yanına aldı. Başka kimsenin Oʼnunla birlikte gitmesine izin vermedi. ");
INSERT INTO turobt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Toplantı yeri liderinin evine vardılar. İsa gürültü yapan kalabalığı, acı acı ağlayıp feryat edenleri gördü. ");
INSERT INTO turobt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","İçeri girdikten sonra onlara, “Neden gürültü yapıp ağlıyorsunuz?” dedi. “Kız ölmedi, sadece uyuyor!” ");
INSERT INTO turobt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ama onlar İsaʼyla alay ettiler. İsa hepsini dışarı çıkardı. Yanına yalnız çocuğun annesini, babasını ve Oʼnunla gelen öğrencileri alıp kızın yattığı odaya girdi. ");
INSERT INTO turobt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kızın elini tutup ona, “Talita kumi!” dedi. Yani, “Kız, sana diyorum kalk”. ");
INSERT INTO turobt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kız hemen ayağa kalkıp yürümeye başladı. On iki yaşındaydı. Oradaki insanlar şaşırıp kaldılar. ");
INSERT INTO turobt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","İsa bu olaydan kimsenin haberi olmaması için onları çok sıkı uyardı. Bir de kıza yemek verilmesini emretti. ");
INSERT INTO turobt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","İsa oradan ayrılıp memleketine gitti. Öğrencileri de Oʼnunla gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Şabat günü olunca İsa Yahudilerin toplantı yerinde vaaz etmeye başladı. Oʼnu dinleyen birçok kişi hayret edip şöyle dedi: “Bu adam bu şeyleri nereden biliyor? Oʼna verilen bu hikmet nedir? Oʼnun elinden nasıl böyle mucizeler geliyor? ");
INSERT INTO turobt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bu adam Meryemʼin oğlu, marangoz değil mi? Kardeşleri Yakub, Yusuf, Yahuda ve Simun değil mi? Kız kardeşleri burada, aramızda oturmuyorlar mı?” Böyle diyerek Oʼna gücendiler. ");
INSERT INTO turobt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","İsa onlara şöyle dedi: “Bir peygamberin saygı görmediği tek yer kendi memleketi, hısımları ve ailesidir.” ");
INSERT INTO turobt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","İsa orada birkaç hastaya dokunup şifa vermekten başka hiçbir mucize yapamadı. ");
INSERT INTO turobt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Oradaki halkın imansızlığına şaşırıp kaldı. İsa çevre köyleri dolaşıp vaaz veriyordu. ");
INSERT INTO turobt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sonra yanına on iki elçisini çağırdı ve onları ikişer ikişer halk arasına göndermeye başladı. Onlara şeytani ruhların üzerine yetki verdi. ");
INSERT INTO turobt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yolculuğa değnekten başka bir şey almamalarını emretti. Ne ekmek, ne sırtlarında torba, ne de keselerinde para götüreceklerdi. ");
INSERT INTO turobt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ayaklarına sandalet giyeceklerdi ama yedek gömlek almayacaklardı. ");
INSERT INTO turobt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Onlara şöyle dedi: “Bir yere gittiğinizde, oradan ayrılana kadar aynı evde kalın. ");
INSERT INTO turobt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bir yerde sizi kabul etmezlerse ya da sizi dinlemezlerse, oradan ayrılırken onlara karşı şahitlik olsun diye ayaklarınızın altındaki tozu silkin.” ");
INSERT INTO turobt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","İsaʼnın öğrencileri yola çıkıp halkı tövbeye çağırdılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Birçok cini kovdular. Bir sürü hastanın üzerine zeytinyağı sürüp onlara şifa verdiler. ");
INSERT INTO turobt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kral Hirodes olup bitenleri işitti, çünkü İsaʼnın ünü yayılmıştı. Bazıları İsa hakkında şöyle diyordu: “Bu Vaftizci Yahyaʼdır. Ölümden dirildi. İşte o yüzden bu mucizeleri yapma gücüne sahip.” ");
INSERT INTO turobt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Diğerleri ise, “O İlyasʼtır” diyordu. Başkaları da, “O eski peygamberlerden biridir!” diyordu. ");
INSERT INTO turobt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama Hirodes bunu işitince “Hayır!” dedi. “Kafasını kestirdiğim Yahya dirilmiştir.” ");
INSERT INTO turobt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Çünkü Hirodes adamlarını yollayıp Yahyaʼyı yakalatmıştı. Onlar da onu bağlayıp hapishaneye atmışlardı. Bunun sebebi şuydu: Hirodes kendi kardeşi Filipusʼun karısı Hirodiya ile evlenmişti. ");
INSERT INTO turobt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yahya da Hirodesʼe, “Kardeşinin karısıyla birleşmen Tevratʼa aykırıdır” deyip durmuştu. ");
INSERT INTO turobt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hirodiya bu yüzden Yahyaʼya kin bağladı ve onu öldürtmek istedi, ama yapamadı. ");
INSERT INTO turobt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Çünkü Hirodes Yahyaʼdan korkuyordu. Onun Allahʼa adanmış doğru bir adam olduğunu biliyor ve onu koruyordu. Yahyaʼyı dinlerken Hirodesʼin aklı iyice karışıyordu, yine de onu dinlemekten hoşlanıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hirodes doğum gününde saray büyüklerine, komutanlara ve Celile bölgesinin önemli insanlarına bir ziyafet yaptı. Hirodiya orada beklediği fırsatı buldu. ");
INSERT INTO turobt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Onun kızı içeri girip Hirodes ve misafirleri için göbek attı. Bu da onların hoşuna gitti. Kral kıza şöyle dedi: “Dile benden ne dilersen, onu sana vereceğim.” ");
INSERT INTO turobt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sonra “Ne dilersen dile, krallığımın yarısını iste, sana vereceğim!” diye kıza yemin etti. ");
INSERT INTO turobt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kız dışarı çıkıp annesine, “Ne isteyeyim?” diye sordu. Annesi de, “Vaftizci Yahyaʼnın kafasını” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kız hemen içeri girip acele acele kralın önüne çıktı ve şöyle dedi: “Hemen bana bir tepsi üzerinde Vaftizci Yahyaʼnın kafasını vermeni istiyorum.” ");
INSERT INTO turobt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kral çok üzüldü, ama sofra başındaki misafirlerin önünde yemin ettiği için kızı kırmak istemedi. ");
INSERT INTO turobt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kral hemen bir cellat gönderdi ve Yahyaʼnın kafasını getirmesini emretti. Cellat da hapishaneye gidip Yahyaʼnın kafasını kesti. ");
INSERT INTO turobt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kafayı tepsi üzerinde getirip kıza verdi, kız da onu annesine verdi. ");
INSERT INTO turobt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yahyaʼnın öğrencileri bunu öğrenince, gelip Yahyaʼnın cesedini aldılar ve mezara koydular. ");
INSERT INTO turobt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bu arada elçiler İsaʼnın etrafında toplandılar. Yaptıkları ve vaaz ettikleri her şeyi Oʼna anlattılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","İsa onlara şöyle dedi: “Haydi, birlikte yalnız olarak ıssız bir yere gidelim. Orada biraz dinlenin.” Çünkü o kadar çok kişi gelip gidiyordu ki, yemek yemeye bile fırsat bulamamışlardı. ");
INSERT INTO turobt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Böylece tekneye binip tek başlarına ıssız bir yere doğru yol aldılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ancak birçok insan onların gittiğini gördü ve onları tanıdı. Bu insanlar bütün kasabalardan yaya olarak yola çıktılar. Koşa koşa o yere İsaʼdan önce yetiştiler. ");
INSERT INTO turobt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","İsa tekneden inince büyük bir kalabalık gördü ve onlara acıdı, çünkü çobansız koyunlar gibiydiler. Onlara birçok şey öğretmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Saat ilerleyince İsaʼnın öğrencileri Oʼna gelip şöyle dediler: “Burası ıssız bir yer. Hem de vakit çok geç. ");
INSERT INTO turobt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Halkı gönder de, etraftaki çiftliklere ve köylere gitsinler, kendilerine yiyecek alsınlar.” ");
INSERT INTO turobt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","İsa ise onlara şöyle cevap verdi: “Onlara siz yiyecek verin!” Oʼna şöyle dediler: “Gidip yeterli ekmek almak için iki yüz gümüş para lazım!” ");
INSERT INTO turobt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","İsa onlara, “Kaç ekmeğiniz var? Gidin bakın!” dedi. Bunu öğrendikten sonra Oʼna, “Beş ekmekle iki balık” diye cevap verdiler. ");
INSERT INTO turobt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","İsa halka gruplar halinde yeşil çayırlığa oturmalarını emretti. ");
INSERT INTO turobt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Halk da ellişer yüzer kişilik gruplar halinde oturdu. ");
INSERT INTO turobt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","İsa beş ekmekle iki balığı aldı, gözlerini göğe kaldırarak şükretti. Sonra ekmekleri böldü ve dağıtmaları için öğrencilerine verdi. İki balığı da aralarında paylaştırdı. ");
INSERT INTO turobt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Herkes yiyip doydu. ");
INSERT INTO turobt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Artakalan ekmek kırıntılarını ve balıkları toplayıp on iki sepet doldurdular. ");
INSERT INTO turobt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yemek yiyen erkeklerin sayısı beş bindi. ");
INSERT INTO turobt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bundan hemen sonra İsa öğrencilerini tekneye bindirdi. Onları kendisinden önce gölün öbür tarafına, Beytsaydaʼya gönderdi. Kendisi ise halkı evlerine gönderecekti. ");
INSERT INTO turobt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","İsa halkı yolcu ettikten sonra, dua etmek için bir tepeye çıktı. ");
INSERT INTO turobt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Akşam olunca tekne gölün ortasına vardı. Ama İsa tek başına karadaydı. ");
INSERT INTO turobt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Öğrencilerini uzaktan gördü. Kürek çekmekte zorlanıyorlardı. Çünkü rüzgar onlara karşı esiyordu. Sabaha doğru İsa gölün üstünde yürüyüp onlara yaklaştı.Yanlarından geçecekmiş gibi davrandı. ");
INSERT INTO turobt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Öğrencileri Oʼnun gölün üstünde yürüdüğünü gördüler. İsaʼyı bir hayalet sanıp çığlık attılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Çünkü hepsi Oʼnu gördü ve çok korktu. İsa hemen onlarla konuştu. “Rahat olun! Benim! Korkmayın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","İsa tekneye binip onlara katıldı ve rüzgar dindi. Öğrenciler acayip şaşırdılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Çünkü İsaʼnın ekmeklerle yaptığı mucizeden bir şey anlamamışlardı. Olup bitenlere akıl erdiremiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","İsaʼyla öğrencileri gölü geçtiler. Ginnesar taraflarında karaya vardıktan sonra tekneyi bağladılar. ");
INSERT INTO turobt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tekneden indiklerinde halk İsaʼyı hemen tanıdı. ");
INSERT INTO turobt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Koşa koşa gidip o bölgedeki herkese haber verdiler. İnsanlar İsaʼnın gittiği her yere döşekler üzerinde hastalarını getiriyordu. ");
INSERT INTO turobt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","İsa o bölgedeki köylere, kasabalara ve çiftliklere gitti. Her yerden insanlar hastalarını çarşı meydanlarına getiriyordu. Hastalar İsaʼnın elbisesinin eteğine dokunabilmek için yalvardılar. Dokunanların hepsi hastalığından kurtuldu. ");
INSERT INTO turobt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yeruşalimʼden gelen Ferisiler ve bazı Tevrat uzmanları İsaʼnın etrafına toplandılar. ");
INSERT INTO turobt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","İsaʼnın bazı öğrencilerininmurdar, yani din adetine göre yıkanmamış ellerle yemek yediğini gördüler. ");
INSERT INTO turobt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Çünkü Ferisiler, aslında bütün Yahudiler, ellerini iyice yıkamadan yemek yemezler. Böylece atalarının adetlerine uyarlar. ");
INSERT INTO turobt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Çarşıdan dönünce de yıkanmadan yemezler. Bunun gibi daha bir sürü adete uyarlar. Meselâ, bardakları, su kaplarını ve bakır tencereleri suya batırıp çıkarırlar. ");
INSERT INTO turobt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ferisiler ve Tevrat uzmanları İsaʼyı sorguya çektiler: “Öğrencilerin neden atalarımızın adetlerine uymadan yaşıyorlar? Niçin murdar ellerle yemek yiyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","İsa onlara, “Sizi ikiyüzlüler!” dedi. “Yeşaya Peygamberʼin hakkınızda söylediği sözler ne kadar doğru! Yazıldığı gibi: Allah diyor ki, ‘Bu halk beni dudaklarıyla sayıyor, ama yürekleri benden uzaktır. ");
INSERT INTO turobt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Boşuna bana tapıyorlar. Vaaz ettikleri insan buyruklarıdır.’ ");
INSERT INTO turobt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Allahʼın buyruklarını bir kenara bıraktınız ve insan adetlerine uyuyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bir de onlara şunu söyledi: “Kendi adetlerinizi sürdürmek için Allahʼın buyruğunu bir kenara atmayı çok iyi beceriyorsunuz! ");
INSERT INTO turobt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Örneğin: Musa şöyle dedi: ‘Annenize babanıza, saygı gösterin’ ve ‘Kim annesini ve babasını aşağılarsa, ölüm cezasını hak eder.’ ");
INSERT INTO turobt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ancak siz diyorsunuz ki, eğer bir kişi anne babasına, ‘Size verebileceğim şeyler kurbandır yani Allahʼa adaktır’ derse, ");
INSERT INTO turobt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","artık annesi babası için bir şey yapmasına izin vermiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Böylece kuşaktan kuşağa aktardığınız adetlerle Allahʼın sözünü geçersiz kılıyorsunuz. Buna benzer daha birçok şey yapıyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","İsa kalabalığı tekrar yanına çağırıp şöyle dedi: “Hepiniz beni dinleyin ve anlayın: ");
INSERT INTO turobt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","İnsanın içine giren hiçbir şey onu kirletemez. İnsanı kirleten şey, ağızdan çıkandır.” ");
INSERT INTO turobt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","İsa kalabalığı bırakıp bir eve girdi. O zaman öğrencileri İsaʼya bu benzetmenin anlamını sordular. ");
INSERT INTO turobt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O da onlara şöyle dedi: “Demek siz de anlamıyorsunuz. Bilmez misiniz, dışardan ağza giren hiçbir şey insanı kirletemez. ");
INSERT INTO turobt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Çünkü onun yüreğine girmez, sadece onun midesine girer, oradan da dışarı atılır.” İsa bu sözlerle bütün yiyeceklerin temiz olduğunu söyledi. ");
INSERT INTO turobt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","İsa şöyle devam etti: “İnsanı kirleten şey, insanın içinden çıkandır. ");
INSERT INTO turobt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Çünkü kötü düşünceler içten, insanın yüreğinden çıkar. Bunlar, evlilik dışı seksüel ilişkiler, hırsızlık, adam öldürme, ");
INSERT INTO turobt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zina, açgözlülük, kin, hile, azgın seksüel hareketler, kıskançlık, iftira, gurur ve akılsızlığa yol açar. ");
INSERT INTO turobt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","İşte, bütün bu kötülükler içten çıkar ve insanı kirletir.” ");
INSERT INTO turobt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","İsa oradan kalkıp Sur şehrinin bölgesine gitti. Bir eve girdi ve kimsenin bunu bilmesini istemedi. Ama gizlenemedi. ");
INSERT INTO turobt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bir kadın İsaʼnın hakkındaki haberi duydu. Şeytani ruha tutulmuş bir kızı vardı. Kadın hemen gelip İsaʼnın ayaklarının dibine kapandı. ");
INSERT INTO turobt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bu kadın Yahudi değildi, Suriyeʼnin Fenike bölgesinde doğmuş bir Grekti. Kızından cini çıkarması için İsaʼya yalvarıp durdu. ");
INSERT INTO turobt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","İsa ona şöyle dedi: “Bırak, önce çocuklar karınlarını doyursunlar. Çünkü çocukların ekmeğini alıp köpeklerin önüne atmak doğru değil.” ");
INSERT INTO turobt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kadın da İsaʼya şöyle cevap verdi: “Efendimiz, masanın altındaki köpekler bile çocukların ekmek kırıntılarıyla besleniyor.” ");
INSERT INTO turobt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","İsa ona, “Böyle uygun cevap verdiğin için gidebilirsin” dedi. “Cin kızından çıktı.” ");
INSERT INTO turobt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kadın da evine dönüp kızını yatakta yatarken buldu. Cin ondan çıkmıştı. ");
INSERT INTO turobt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","İsa, Sur taraflarından ayrıldı. Sayda şehrinden ve Dekapolis bölgesinden geçerek Celile Gölüʼne döndü. ");
INSERT INTO turobt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","İsaʼya zorlukla konuşan sağır bir adamı getirdiler. Adama dokunup şifa vermesi için İsaʼya yalvardılar. ");
INSERT INTO turobt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","İsa onu kalabalıktan çıkardı, tek başına yanına aldı. Parmaklarını onun kulaklarına soktu. Sonra parmağına tükürüp adamın diline dokundu. ");
INSERT INTO turobt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Göğe baktı. Derin bir ah çekerek, “Effata!” yani “Açıl!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Adamın kulakları hemen açıldı, dili çözüldü ve düzgün konuşmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","İsa kimseye söylemesinler diye oradakilere sıkı sıkıya emretti. Ama ne kadar onlara emrettiyse de, o kadar daha fazla anlattılar. ");
INSERT INTO turobt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Halk son derece büyük bir hayret içindeydi. “Yaptığı her şey iyi” dediler. “Sağırların kulaklarını açıyor ve dilsizleri konuşturuyor.” ");
INSERT INTO turobt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","O günlerde yine büyük bir kalabalık toplandı. Yiyecek hiçbir şeyleri yoktu. O zaman İsa öğrencilerini yanına çağırıp onlara şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Halka acıyorum. Üç gündür yanımdalar ve yiyecek bir şeyleri yok. ");
INSERT INTO turobt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Onları aç karnına evlerine gönderirsem, yolda bayılırlar. Hem de bazıları uzak yoldan geldiler.” ");
INSERT INTO turobt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Öğrencileri şöyle cevap verdi: “Bunları doyurmak için insan nereden ekmek bulabilir? Burası ıssız yer.” ");
INSERT INTO turobt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","İsa onlara, “Kaç ekmeğiniz var?” diye sordu. “Yedi tane” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","İsa kalabalığa yere oturmalarını emretti. Sonra yedi ekmeği alıp şükretti, böldü ve dağıtmaları için öğrencilerine verdi. Onlar da kalabalığa dağıttılar. ");
INSERT INTO turobt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Birkaç tane küçük balıkları da vardı. İsa bunlar için de şükretti ve öğrencilerin onları da dağıtmalarını söyledi. ");
INSERT INTO turobt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Halk yiyip doydu. Yemek artıklarından yedi sepet dolusu toplandı. ");
INSERT INTO turobt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Orada aşağı yukarı dört bin kişi vardı. İsa onları evlerine gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bundan hemen sonra öğrencileriyle birlikte tekneye bindi ve Dalmanuta taraflarına geçti. ");
INSERT INTO turobt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferisiler gelip İsaʼyla tartışmaya başladılar. Oʼnu denemek için gökten mucizevi bir işaret göstermesini istediler. ");
INSERT INTO turobt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","İsa içinden derin bir ah çekip şöyle dedi: “Bu kuşak neden mucizevi bir işaret istiyor? Size doğrusunu söylüyorum: bu kuşağa hiçbir işaret gösterilmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Onları bırakıp yine tekneye bindi ve gölün öbür kenarına geçti. ");
INSERT INTO turobt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Öğrenciler ekmek almayı unutmuşlardı. Teknede onların yanında sadece bir ekmek vardı. ");
INSERT INTO turobt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","İsa onları şöyle uyardı: “Dikkat edin! Ferisilerin ve Hirodesʼin mayasından sakının!” ");
INSERT INTO turobt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Öğrenciler de birbirleriyle tartışmaya başladılar. “Ekmeğimiz yok diye öyle konuşuyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","İsa bunu fark edince onlara şöyle dedi: “Neden ekmeğimiz yok diye birbirinizle tartışıyorsunuz? Hâlâ anlamıyor, akıl erdiremiyor musunuz? Kafanız bu kadar mı kalın? ");
INSERT INTO turobt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gözleriniz var, görmüyor musunuz? Kulaklarınız var, işitmiyor musunuz? Hatırlamıyor musunuz? ");
INSERT INTO turobt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Beş ekmeği beş bin kişi için böldüğüm zaman, kaç sepet dolusu ekmek ve balık parçası topladınız?” Oʼna, “On iki sepet” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Yedi ekmeği dört bin kişi için böldüğüm zaman, kaç sepet dolusu ekmek ve balık parçası topladınız?” Oʼna, “Yedi sepet” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","İsa onlara, “Hâlâ anlamıyor musunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","İsa ile öğrencileri Beytsayda köyüne geldikleri zaman, bazı kişiler İsaʼya kör bir adam getirdiler. İsaʼnın ona dokunup şifa vermesi için yalvardılar. ");
INSERT INTO turobt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","İsa da kör adamı elinden tutup köyden dışarı çıkardı ve onun gözlerine tükürdü. Sonra elleriyle ona dokundu. “Bir şey görüyor musun?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Adam yukarı baktı ve şöyle dedi: “İnsanlar görüyorum. Gördüğüm insanlar ağaçlara benziyorlar, ama yürüyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","İsa bir daha elleriyle adamın gözlerine dokundu. Adam gözlerini iyice açtı. Gözleri şifa bulmuştu. Her şeyi açıkça görebiliyordu. ");
INSERT INTO turobt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","İsa adama “Köye uğramadan evine dön!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","İsa öğrencileriyle birlikte oradan ayrıldı, Filipus Sezariyesi çevresindeki köylere gitti. Yolda öğrencilerine sordu: “İnsanlar benim kim olduğumu söylüyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Onlar da İsaʼya şöyle cevap verdiler: “ ‘Vaftizci Yahya,’ diyorlar, bazıları da ‘İlyas’ ya da ‘eski peygamberlerden biri’ diyorlar.” ");
INSERT INTO turobt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","İsa “Ya siz? Sizce ben kimim?” diye sordu. Petrus Oʼna şöyle cevap verdi: “Sen Mesihʼsin.” ");
INSERT INTO turobt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","İsa da, “Benim hakkımda kimseye bir şey söylemeyin” diye öğrencilerini uyardı. ");
INSERT INTO turobt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","İsa öğrencilerine şunu öğretmeye başladı: “İnsan Oğluʼnun çok acı çekmesi lazım. Halkın liderleri, başrahipler ve Tevrat uzmanları tarafından reddedilip öldürülmesi, üç gün sonra ölümden dirilmesi lazım.” ");
INSERT INTO turobt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","İsa bunları açıkça söyledi. Petrus Oʼnu bir kenara çekip azarlamaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Fakat İsa dönüp öğrencilerine baktı ve Petrusʼu şöyle azarladı: “Çekil önümden, Şeytan! Çünkü düşüncelerin Allahʼtan değil, insandandır.” ");
INSERT INTO turobt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","İsa hem kalabalığı, hem de öğrencilerini çağırıp onlara şöyle dedi: “Bir kişi peşimden gelmek isterse, kendini gözden çıkarsın, çarmıhını yüklensin ve yolumu tutsun. ");
INSERT INTO turobt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Çünkü kim canını kurtarmak isterse, onu kaybedecek. Ama kim canını benim ve Müjdeʼnin uğruna kaybederse, onu kurtaracak. ");
INSERT INTO turobt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bir kişi bütün dünyayı kazanırsa, ama kendi canını kaybederse ona ne faydası olur? ");
INSERT INTO turobt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","İnsan, kendi canına karşılık olarak ne verebilir ki? ");
INSERT INTO turobt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bu sadık olmayan ve günahkâr kuşağın önünde her kim benden ve sözlerimden utanırsa, İnsan Oğlu da geldiğinde, ondan utanacak. İnsan Oğlu Babasıʼnın görkemiyle ve kutsal meleklerle birlikte gelecek.” ");
INSERT INTO turobt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sonra İsa onlara şöyle dedi: “Size doğrusunu söylüyorum: burada duran bazı kişiler Allahʼın Krallığıʼnın güçlü bir şekilde geldiğini görmeden ölümü tatmayacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Altı gün sonra İsa, Petrusʼu, Yakubʼu ve Yuhannaʼyı yanına aldı. Onları yüksek bir dağın tepesine çıkardı. Orada yalnızdılar. Önlerinde İsaʼnın görünüşü tamamen değişti. ");
INSERT INTO turobt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oʼnun elbiseleri çok parlak bir beyazlığa dönüştü, öyle bir beyazlık ki, dünyadaki hiçbir çamaşırcı bunu beceremezdi. ");
INSERT INTO turobt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sonra onlara İlyas ve Musa göründü. İsaʼyla konuşuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrus da söze karışıp İsaʼya, “Öğretmenim iyi ki buradayız” dedi. “Üç çardak kuralım: biri senin için, biri Musa için, biri de İlyas için.” ");
INSERT INTO turobt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus ne söyleyeceğini bilmiyordu. Hepsi de çok korkmuşlardı. ");
INSERT INTO turobt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","O sırada bir bulut onların üstüne gölge yaptı. Bulutun içinden bir ses şöyle dedi: “Sevgili Oğlum budur. Oʼnu dinleyin!” ");
INSERT INTO turobt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Öğrenciler hemen etraflarına baktılar, fakat yanlarında İsaʼdan başka kimseyi görmediler. ");
INSERT INTO turobt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dağdan inerlerken İsa onları uyardı: “İnsan Oğlu ölümden dirilene kadar, gördüklerinizi kimseye anlatmayın” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Onlar da bu buyruğa uydular. Ama aralarında, “Ölümden dirilmek de ne demek?” diye tartıştılar. ");
INSERT INTO turobt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sonra İsaʼya şunu sordular: “Tevrat uzmanları neden, ‘Önce İlyas gelmeli’ diyorlar?” ");
INSERT INTO turobt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","İsa onlara şöyle cevap verdi: “Evet, İlyas önce gelecek ve her şeyi yeniden düzene koyacak. Ama nasıl olur da, Kutsal Yazılarʼda İnsan Oğluʼnun çok acı çekip hiçe sayılacağı yazılmıştır? ");
INSERT INTO turobt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ben size şunu söylüyorum: İlyas zaten geldi. Ona istedikleri gibi yaptılar. Böylece onun hakkında yazılanlar yerine geldi.” ");
INSERT INTO turobt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","İsaʼyla beraberindekiler diğer öğrencilerin yanına dönünce, onların etrafında büyük bir kalabalık gördüler. Tevrat uzmanları öğrencilerle tartışıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","İsaʼyı görür görmez bütün kalabalık büyük bir şaşkınlığa kapıldı. Koşarak Oʼnu selamladılar. ");
INSERT INTO turobt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","İsa, “Ne tartışıyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kalabalığın içinden biri şöyle cevap verdi: “Öğretmenim, oğlumu sana getirdim. Cine tutulmuş, konuşamıyor. ");
INSERT INTO turobt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cin oğlumu tuttuğu zaman, onu yere yıkıyor. Oğlum ağzından köpükler saçıyor, dişlerini gıcırdatıyor. Bedeni kaskatı kesiliyor. Senin öğrencilerine cini kovmalarını söyledim, ama beceremediler.” ");
INSERT INTO turobt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","İsa onlara şöyle dedi: “Ey imansız kuşak! Ne zamana kadar sizinle beraber olacağım? Ne zamana kadar size katlanacağım? Çocuğu bana getirin.” ");
INSERT INTO turobt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Çocuğu Oʼna getirdiler. İsaʼyı görünce, çocuğu hemen cin çarptı. Çocuk yere düştü, yuvarlanmaya ve ağzından köpük saçmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","İsa çocuğun babasına sordu: “Çocuk ne zamandan beri bu vaziyette?” Babası, “Küçüklüğünden beri” diye cevap verdi. ");
INSERT INTO turobt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Cin, çocuğu yok etmek için onu sık sık ateşe, ya da suya atıyor. Ama senin elinden bir şey gelirse, bize acı, yardım et!” ");
INSERT INTO turobt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","İsa adama şöyle dedi: “Niçin ‘senin elinden bir şey gelirse’ diyorsun? İman eden kişi için her şey mümkündür.” ");
INSERT INTO turobt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Çocuğun babası hemen yüksek sesle, “İman ediyorum! Ama imanım zayıf. Ne olur, bana yardım et!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","İsa kalabalığın koşup toplanmaya başladığını görünce, şeytani ruhu azarladı ve ona şöyle dedi: “Ey sen, çocuğu dilsiz ve sağır yapan ruh! Sana emrediyorum, ondan çık ve bir daha ona girme!” ");
INSERT INTO turobt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ruh yüksek sesle bağırıp çocuğu kuvvetle sarsarak ondan çıktı. Çocuk ölü gibi oldu. Birçok kişi onun için, “Öldü!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama İsa onu elinden tutup kaldırdı, çocuk da ayağa kalktı. ");
INSERT INTO turobt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sonra İsa bir eve girdi. İsaʼyla yalnızken öğrencileri Oʼna şunu sordular: “Biz cini neden kovamadık?” ");
INSERT INTO turobt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","İsa onlara şöyle dedi: “Bu tür cin ancak duayla çıkabilir.” ");
INSERT INTO turobt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oradan çıkıp Celile bölgesini dolaşmaya başladılar. Ama İsa, kimsenin bunu bilmesini istemedi. ");
INSERT INTO turobt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Çünkü öğrencilerine ders veriyordu. Onlara şöyle dedi: “İnsan Oğlu insanların eline teslim edilecek. Oʼnu öldürecekler. Ancak öldükten üç gün sonra dirilecek.” ");
INSERT INTO turobt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama İsaʼnın bu sözünü anlamadılar. Oʼna sormaya da korktular. ");
INSERT INTO turobt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","İsa öğrencileriyle Kefernahum kasabasına gitti. Eve girdikten sonra onlara şunu sordu: “Yolda neyi tartışıyordunuz?” ");
INSERT INTO turobt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Cevap vermediler, çünkü yolda aralarında kimin en önemli olduğunu tartışmışlardı. ");
INSERT INTO turobt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","İsa oturup on iki elçisini yanına çağırdı ve onlara şöyle dedi: “Kim birinci olmak isterse, herkesin arasında en sonuncu ve herkesin hizmetkârı olmalı.” ");
INSERT INTO turobt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sonra İsa bir çocuğu elinden tutup aralarına aldı. Onu kucağına alarak öğrencilerine şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Her kim böyle bir çocuğu benim adıma kabul ederse, beni kabul etmiş olur. Beni kabul eden de beni değil, beni Gönderenʼi kabul etmiş olur.” ");
INSERT INTO turobt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhanna İsaʼya şöyle dedi: “Öğretmenim, senin adınla cin kovan bir kişiyi gördük. Biz de ona engel olmaya çalıştık, çünkü bizden biri değildi.” ");
INSERT INTO turobt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ama İsa şöyle dedi: “Ona engel olmayın! Çünkü benim adımla mucize yapan hiç kimse bundan hemen sonra beni kötüleyemez. ");
INSERT INTO turobt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kim bize karşı değilse, bizden yanadır. ");
INSERT INTO turobt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mesihʼe bağlı olduğunuz için size kim bir bardak su verirse, size doğrusunu söylüyorum: ödülsüz kalmayacak. ");
INSERT INTO turobt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ama bana iman eden bu küçüklerden birini yoldan saptıran kişinin vay haline! Boynuna büyük bir değirmen taşı asılıp denize atılması o kişi için daha iyi olur. ");
INSERT INTO turobt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Elin seni iman yolundan saptırırsa, onu kes at! Senin için tek elle sonsuz yaşama kavuşmak, iki elle cehenneme, o sönmez ateşe gitmekten iyidir. ");
INSERT INTO turobt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ayağın seni iman yolundan saptırırsa, onu kes at! Senin için tek ayakla sonsuz yaşama kavuşmak, iki ayakla cehenneme atılmaktan iyidir. ");
INSERT INTO turobt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Gözün seni iman yolundan saptırırsa, onu çıkar at! Senin için tek gözle Allahʼın Krallığıʼna girmek, iki gözle cehenneme atılmaktan iyidir. ");
INSERT INTO turobt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Orada, ‘Onları yiyen kurtçuklar ölmez ve yakan ateş sönmez.’ ");
INSERT INTO turobt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Çünkü herkes ateşle tuzlanacak. ");
INSERT INTO turobt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tuz iyi bir şeydir. Ama tuz tuzluluğunu kaybederse, ona bir daha neyle tuz tadı verilebilir? İçinizde tuz olsun ve birbirinizle barış içinde yaşayın.” ");
INSERT INTO turobt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","İsa oradan kalkıp Yahudiye bölgesine ve Şeria Irmağıʼnın öte tarafına gitti. Yine Oʼnun etrafına kalabalıklar toplandı ve her zamanki gibi İsa onlara vaaz etti. ");
INSERT INTO turobt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bazı Ferisiler gelip İsaʼyı denemek için şunu sordular: “Erkeğin karısını boşaması Tevratʼa uygun mudur?” ");
INSERT INTO turobt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","İsa onlara şu soruyla cevap verdi: “Musa size neyi emretti?” ");
INSERT INTO turobt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Onlar da “Musa, erkeğin bir boşanma kâğıdı yazıp karısını boşamasına izin verdi” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ama İsa onlara şöyle dedi: “Musa size bu buyruğu inatçılığınız yüzünden verdi. ");
INSERT INTO turobt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Daha dünyanın başında, ‘Allah onları erkek ve kadın olarak yarattı.’ ");
INSERT INTO turobt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Bunun için adam annesini ve babasını bırakacak, karısına bağlanacak ");
INSERT INTO turobt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ve ikisi bir beden olacak.’ Böylece, onlar artık iki değil, bir bedendirler. ");
INSERT INTO turobt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bu sebeple, Allahʼın birleştirdiğini insan ayırmasın.” ");
INSERT INTO turobt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Evdeyken, İsaʼnın öğrencileri Oʼna bu konuyu tekrar sordular. ");
INSERT INTO turobt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O da onlara şöyle dedi: “Kim karısını boşayıp başka kadınla evlenirse, karısına karşı zina işlemiş olur. ");
INSERT INTO turobt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kadın kocasını boşayıp başka erkeğe varırsa, o da zina işlemiş olur.” ");
INSERT INTO turobt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bazıları İsaʼya çocuklarını getirdiler. Onlara dokunup bereket dilemesini istediler. Ama öğrenciler çocukları getirenleri azarladılar. ");
INSERT INTO turobt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","İsa bunu görünce kızdı. Onlara şöyle dedi: “Bırakın, çocuklar bana gelsin. Onlara engel olmayın. Çünkü Allahʼın Krallığı çocuklar gibi olanlarındır. ");
INSERT INTO turobt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Size doğrusunu söylüyorum: Kim Allahʼın Krallığıʼnı bir çocuk gibi kabul etmezse, oraya asla girmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sonra çocukları kucakladı, elleriyle onlara dokunup bereket diledi. ");
INSERT INTO turobt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","İsa yolculuğa çıkarken, bir adam koşarak Oʼna geldi ve önünde diz çöküp şunu sordu: “İyi Öğretmen! Sonsuz yaşama kavuşmak için ne yapmalıyım?” ");
INSERT INTO turobt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","İsa adama şöyle dedi: “Neden bana ‘iyi’ diyorsun? Allahʼtan başka iyi olan yoktur. ");
INSERT INTO turobt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oʼnun buyruklarını biliyorsun: Adam öldürmeyin, zina etmeyin, çalmayın, yalan yere şahitlik etmeyin, kimsenin hakkını yemeyin, annenize ve babanıza saygı gösterin.” ");
INSERT INTO turobt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Adam da İsaʼya şöyle cevap verdi: “Öğretmenim, bütün bunları zaten gençliğimden beri yerine getiriyorum.” ");
INSERT INTO turobt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","İsa adamın gözlerinin içine baktı ve onu sevdi. “Bir eksiğin var” dedi. “Git, bütün malını sat ve parasını fakirlere dağıt. İşte o zaman gökte hazinen olacak. Sonra gel, benim peşime düş.” ");
INSERT INTO turobt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Adam bunu duyunca suratını astı ve üzüntü içinde ayrıldı, çünkü malı mülkü çoktu. ");
INSERT INTO turobt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","İsa etrafına bakıp öğrencilerine şöyle dedi: “Mal mülk sahipleri için Allahʼın Krallığıʼna girmek ne kadar zordur!” ");
INSERT INTO turobt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Öğrencileri bu sözlere şaşırıp kaldılar. İsa sözüne devam edip onlara şöyle dedi: “Çocuklar, Allahʼın Krallığıʼna girmek ne kadar zordur. ");
INSERT INTO turobt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Devenin iğne deliğinden geçmesi, zenginin Allahʼın Krallığıʼna girmesinden daha kolaydır.” ");
INSERT INTO turobt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Öğrencileri daha da fazla hayret ettiler. Birbirlerine, “Öyleyse, kim kurtulabilir?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","İsa onlara dikkatle bakıp şöyle dedi: “İnsan için bu imkansız, ama Allah için değil. Allah için her şey mümkün.” ");
INSERT INTO turobt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrus İsaʼya, “Bak” dedi. “Biz her şeyi bıraktık, senin peşine düştük.” ");
INSERT INTO turobt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","İsa da şunları söyledi: “Size doğrusunu söylüyorum: benim için ve Müjde için evini, kardeşlerini, kız kardeşlerini, annesini, babasını, çocuklarını ya da tarlalarını bırakmış olan herkes bunların yüz katını alacak. Şimdi bu dünyada, çekeceği eziyetlerle birlikte, evler, kardeşler, kız kardeşler, anneler, çocuklar ve tarlalara kavuşacak. Hem de gelecek dünyada sonsuz yaşama sahip olacak. ");
INSERT INTO turobt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ne var ki, şimdi birinci olan birçokları sonuncu olacak, sonuncular da birinci olacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","İsa ve yanındakiler yola çıkmış Yeruşalimʼe gidiyorlardı. İsa da onların önünden yürüyordu. Öğrencileri şaşkınlık içindeydi; arkadan gelenler de korkuyorlardı. İsa on iki elçisini tekrar bir kenara çekti ve yakın bir zamanda Oʼnun başına neler geleceğini onlara anlatmaya başladı: ");
INSERT INTO turobt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Bakın, Yeruşalimʼe gidiyoruz. İnsan Oğlu başrahiplere ve Tevrat uzmanlarına teslim edilecek. Oʼnu ölüm cezasına çarptıracaklar. Oʼnu yabancıların eline teslim edecekler. ");
INSERT INTO turobt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oʼnunla alay edecek, Oʼna tükürecekler. Oʼnu kamçılayacak ve öldürecekler. Ama üç gün sonra O ölümden dirilecek.” ");
INSERT INTO turobt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sonra Zebediʼnin oğulları Yakubʼla Yuhanna, İsaʼya yaklaşıp şöyle dediler: “Öğretmenimiz, senden bir dileğimiz var: istediğimizi bizim için yapar mısın?” ");
INSERT INTO turobt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O da, “Sizin için ne yapmamı istiyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oʼna, “İzin ver de, sen görkemli krallığına kavuşunca birimiz sağında, öbürümüz solunda otursun” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ama İsa onlara, “Siz ne istediğinizi anlamıyorsunuz” dedi. “Benim içtiğim acı dolu bardaktan içebilir misiniz? Benim vaftiz olduğum gibi vaftiz olabilir misiniz?” ");
INSERT INTO turobt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oʼna, “Evet, bunu yapabiliriz!” dediler. İsa onlara şöyle cevap verdi: “Gerçi benim içtiğim bardaktan içeceksiniz. Benim vaftiz olduğum gibi vaftiz olacaksınız. ");
INSERT INTO turobt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama sağımda ya da solumda kimin oturacağına karar vermek bana düşmez. Bu yerler kimler için hazırlanmışsa, onlara verilecek.” ");
INSERT INTO turobt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Öbür on öğrenci bunu duyunca Yakubʼla Yuhannaʼya kızmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ama İsa hepsini yanına çağırıp şöyle dedi: “Bildiğiniz gibi, milletlerin liderleri sayılanlar, halklarına baskı yaparlar ve devlet adamları onları ezerler. ");
INSERT INTO turobt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sizin aranızda böyle olmasın. Aranızda büyük olmak isteyen, diğerlerine hizmetkâr olsun. ");
INSERT INTO turobt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aranızda birinci olmak isteyen, herkese kul köle olsun. ");
INSERT INTO turobt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Çünkü, İnsan Oğlu Oʼna hizmet edilsin diye gelmedi. Hayır, O hizmet etmeye ve kendi canını feda ederek birçok kişiyi günaha esirlikten kurtarmaya geldi.” ");
INSERT INTO turobt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eriha kasabasına geldiler. İsa, öğrencileriyle ve büyük bir kalabalıkla birlikte oradan ayrıldı. O sırada Bartimay, yani Timay oğlu, adlı kör bir dilenci yol kenarında oturuyordu. ");
INSERT INTO turobt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yoldan geçenin Nasıralı İsa olduğunu işitince, şöyle bağırmaya başladı: “Davud Oğlu İsa, bana acı!” ");
INSERT INTO turobt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Birçok kişi onu susturmak için azarladı. Bu kez o daha da fazla bağırmaya başladı: “Ey Davud Oğlu, bana acı!” ");
INSERT INTO turobt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","İsa durdu. “Onu buraya çağırın!” dedi. Kör adamı çağırıp ona şöyle dediler: “Gözün aydın! Haydi kalk. O seni çağırıyor.” ");
INSERT INTO turobt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Adam da paltosunu bir yana atıp ayağa kalktı ve İsaʼya yaklaştı. ");
INSERT INTO turobt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","İsa ona dönüp, “Senin için ne yapmamı istiyorsun?” diye sordu. Kör adam Oʼna şöyle cevap verdi: “Öğretmenim, görmek istiyorum.” ");
INSERT INTO turobt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","İsa ona şöyle dedi: “Gidebilirsin, imanın seni kurtardı.” Adamın gözleri o anda açıldı. Yolda İsaʼnın peşinden gitmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yeruşalimʼe yaklaşıyorlardı. Zeytin Dağıʼnın yamacındaki Beytfaci ve Beytanya köylerine vardılar. İsa öğrencilerinden ikisini önden gönderdi. ");
INSERT INTO turobt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Onlara şöyle dedi: “Karşınızdaki köye gidin. Köye girer girmez bir yere bağlı bir sıpa bulacaksınız. Ona daha önce hiç kimse binmemiştir. Onu çözün ve bana getirin. ");
INSERT INTO turobt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bir kişi size, ‘Niçin bunu yapıyorsunuz?’ derse, ona deyin ki: ‘Efendimizʼin ona ihtiyacı var. Onu hemen geri gönderecek.’ ” ");
INSERT INTO turobt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gittiler, sıpayı bir evin dışında sokakta buldular. Kapının yanında bir yere bağlıydı. Onu çözdüler. ");
INSERT INTO turobt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Etrafta duranlardan bazı kişiler onlara, “Ne yapıyorsunuz?” diye sordular. “Sıpayı niçin çözüyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Öğrenciler İsaʼnın söylediği gibi cevap verdiler, oradakiler de onları rahat bıraktılar. ");
INSERT INTO turobt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Öğrenciler sıpayı İsaʼya getirip paltolarını üzerine koydular. İsa da sıpaya bindi. ");
INSERT INTO turobt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Birçok kişi paltolarını yola serdi. Başkaları da kırlıktan yapraklı dallar kesip yola serdiler. ");
INSERT INTO turobt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Önden gidenler ve arkadan gelenler şöyle bağırıp durdular: “Hozana!” “Rabbin adıyla gelene övgüler olsun!” ");
INSERT INTO turobt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Atamız Davudʼun yaklaşan krallığı kutlu olsun!” “En yücelerde hozana!” ");
INSERT INTO turobt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","İsa Yeruşalimʼe girdi. Tapınağa gidip her tarafı gözden geçirdi. Fakat artık saat geç olmuştu. Bu sebepten on iki elçisiyle birlikte Beytanya köyüne döndü. ");
INSERT INTO turobt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Onlar ertesi gün Beytanya köyünden ayrıldıklarında İsa acıktı. ");
INSERT INTO turobt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uzaktan bol yapraklı bir incir ağacı gördü. Aslında incir mevsimi değildi. Yine de üzerinde bir şey var mı diye bakmak için İsa ağaca yaklaştı. Fakat yapraktan başka bir şey bulmadı. ");
INSERT INTO turobt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ağaca, “Artık hiç kimse senden bir daha meyve yemesin!” dedi. Öğrencileri bunu işittiler. ");
INSERT INTO turobt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yeruşalimʼe vardıklarında İsa, tapınak avlusuna gidip oradan satıcıları ve alışveriş yapanları dışarı atmaya başladı. Yabancı para değiştirenlerin masalarını ve güvercin satanların iskemlelerini devirdi. ");
INSERT INTO turobt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hiç kimsenin tapınak avlularından yük taşımasına izin vermedi. ");
INSERT INTO turobt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Halka vaaz edip şöyle dedi: “Kitapʼta şöyle yazılmıyor mu: ‘Benim evime, bütün milletlerin ibadet evi denilecek’? Ama siz onu haydut yatağına çevirdiniz!” ");
INSERT INTO turobt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Başrahipler ve Tevrat uzmanları bunu işitince, İsaʼyı yok etmek için bir yol aramaya başladılar. İsaʼdan korkuyorlardı, çünkü bütün halk Oʼnun vaazlarına hayrandı. ");
INSERT INTO turobt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Akşam olunca, İsaʼyla öğrencileri şehirden çıktılar. ");
INSERT INTO turobt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ertesi sabah onlar oradan geçerken incir ağacının kökünden kuruduğunu fark ettiler. ");
INSERT INTO turobt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus İsaʼnın söylediklerini hatırladı ve “Öğretmenim, bak!” dedi. “Senin lanetlediğin incir ağacı kurumuş!” ");
INSERT INTO turobt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","İsa ona şöyle cevap verdi: “Allahʼa imanınız olsun. ");
INSERT INTO turobt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Size doğrusunu söylüyorum: Kim şu tepeye ‘Kalk ve denize atıl!’ derse ve yüreğinde hiç şüphe etmeden söylediği şeyin olacağına iman ederse, onun söylediği olacak. ");
INSERT INTO turobt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bunun için size diyorum: duada her ne dilerseniz, onu aldığınıza iman edin ve dileğiniz olacak. ");
INSERT INTO turobt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ayağa kalkıp dua ettiğiniz zaman, bir kişiye dargınsanız, onu bağışlayın. Öyle ki, gökteki Babanız da sizin suçlarınızı bağışlasın.” ");
INSERT INTO turobt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","İsaʼyla öğrencileri yine Yeruşalimʼe geldiler. İsa tapınak avlularında gezinirken, başrahipler, Tevrat uzmanları ve halkın liderleri Oʼna yaklaştılar. ");
INSERT INTO turobt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Şöyle dediler: “Bu şeyleri ne yetkiyle yapıyorsun? Bu şeyleri yapmak için sana bu yetkiyi veren kim?” ");
INSERT INTO turobt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","İsa onlara şöyle cevap verdi: “Ben de size tek bir soru soracağım. Eğer bana cevap verirseniz, size bu şeyleri ne yetkiyle yaptığımı söyleyeceğim. ");
INSERT INTO turobt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yahyaʼnın vaftiz etme yetkisi Allahʼtan mı, yoksa insandan mıydı? Bana cevap verin!” ");
INSERT INTO turobt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bu soruyu aralarında şöyle tartışmaya başladılar: “ ‘Allahʼtan’ dersek, ‘O zaman, ona neden inanmadınız?’ diyecek. ");
INSERT INTO turobt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama ‘İnsandan’ dersek…” Halkın tepkisinden korktukları için böyle konuştular. Çünkü herkes Yahyaʼnın gerçekten peygamber olduğuna inanıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Böylece İsaʼya, “Bilmiyoruz” diye cevap verdiler. Bunun üzerine İsa onlara şöyle dedi: “Öyleyse, ben de bu şeyleri ne yetkiyle yaptığımı size söylemeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sonra İsa o insanlara benzetmelerle konuşmaya başladı. “Bir adam üzüm bağı dikmiş” dedi. “Etrafına duvar çekmiş, üzüm çiğneme çukurunu kazmış, bir de gözetleme kulesi yapmış. Sonra bağını bağcılara kiralamış ve yolculuğa çıkmış. ");
INSERT INTO turobt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Üzüm toplama zamanı gelince bağ sahibi bağın ürününden payına düşeni almak için bağcılara bir köle göndermiş. ");
INSERT INTO turobt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama bağcılar köleyi yakalayıp dövmüş, boş elle geri göndermişler. ");
INSERT INTO turobt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Adam bu sefer bağcılara başka bir köle göndermiş. Bağcılar onu başından yaralayıp aşağılamışlar. ");
INSERT INTO turobt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Adam bir köle daha yollamış. Bağcılar onu öldürmüşler. Gönderdiği bir sürü kişiyi ya dövmüşler, ya da öldürmüşler. ");
INSERT INTO turobt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Adamın bağcılara göndereceği tek bir kişi kalmış. O da çok sevdiği oğluymuş. ‘Oğluma saygı gösterirler’ diyerek en son onu bağcılara göndermiş. ");
INSERT INTO turobt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Fakat bağcılar birbirleriyle şöyle konuşmuşlar: ‘Mirasçı budur! Haydi onu öldürelim, o vakit miras bizim olur.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Onu tutup öldürmüşler ve bağdan dışarı atmışlar. ");
INSERT INTO turobt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Peki, bağ sahibi ne yapacak? Gelip o bağcıları yok edecek, bağı başkalarına verecek. ");
INSERT INTO turobt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kutsal Yazılarʼda şu sözleri hiç okumadınız mı? ‘İnşaatçıların reddettiği taş, binanın köşe taşı oldu. ");
INSERT INTO turobt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bu iş Rabʼdendir, gözümüzde harika bir şeydir.’ ” ");
INSERT INTO turobt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yahudi liderleri İsaʼyı yakalamak istediler, çünkü İsaʼnın bu benzetmeyi onlara karşı anlattığını anladılar. Fakat halktan korktular. Bu sebeple onu bırakıp gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sonra liderler Ferisilerden ve Hirodesçilerden bazılarını yolladılar. İsaʼyı söyleyeceği bir sözle tuzağa düşürmek istiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","İsaʼnın yanına gelip şöyle dediler: “Öğretmenimiz! Biliyoruz ki sen dürüst bir adamsın. İnsanların düşüncelerine önem vermiyorsun. Çünkü insanlar arasında ayrım yapmıyorsun, ama Allahʼın yolunu doğru öğretiyorsun. Sezarʼa vergi ödemek Tevratʼa uygun mu, değil mi? Ödeyelim mi, ödemeyelim mi?” ");
INSERT INTO turobt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","İsa ise onların ikiyüzlülüğünü bildiği için şöyle dedi: “Neden beni tuzağa düşürmeye çalışıyorsunuz? Bana bir gümüş para getirin de ona bir göz atayım.” ");
INSERT INTO turobt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Parayı getirdiler. İsa da onlara sordu: “Burada kimin resmi var, kimin adı yazılı?” Oʼna, “Sezarʼın” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","İsa da onlara şöyle dedi: “Sezarʼın hakkını Sezarʼa verin, Allahʼın hakkını Allahʼa verin.” O zaman onlar İsaʼya büsbütün hayret ettiler. ");
INSERT INTO turobt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sonra Sadukilerden bazıları İsaʼya geldi. Sadukiler “Ölümden diriliş diye bir şey yoktur” derler. İsaʼya şunu sordular: ");
INSERT INTO turobt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Öğretmenimiz, Tevratʼta Musa bize şöyle buyurdu: ‘Bir adamın kardeşi ölürse ve karısını çocuksuz dul bırakırsa, o adam ölen kardeşinin soyunu devam ettirmek için onun karısını alsın.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Diyelim ki yedi kardeş varmış. Birincisi bir kadınla evlenmiş fakat çocuğu olmadan ölmüş. ");
INSERT INTO turobt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","İkinci kardeş de aynı kadını almış ve çocuk yapmadan o da ölmüş. Üçüncüsüne de aynı şey olmuş. ");
INSERT INTO turobt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yani yedi kardeş de soyunu devam ettirememiş. En sonunda kadın da ölmüş. ");
INSERT INTO turobt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Herkes ölümden dirildiği zaman kadın kimin karısı olacak? Çünkü yedi kardeş aynı kadınla evlenmişti.” ");
INSERT INTO turobt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","İsa onlara şöyle dedi: “Siz Kutsal Yazılarʼı ve Allahʼın gücünü bilmediğiniz için yanılıyorsunuz, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Çünkü insanlar ölümden dirilince, ne evlenirler, ne de kocaya giderler. Aksine, gökteki melekler gibi olurlar. ");
INSERT INTO turobt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ölülerin dirilmesine gelince, Musaʼnın kitabında alevlenen çalı hakkındaki bölümü hiç okumadınız mı? Allah orada şöyle der: ‘Ben İbrahimʼin Allahı, İshakʼın Allahı ve Yakubʼun Allahıʼyım.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","O ölülerin Allahı değil, yaşayanların Allahıʼdır. Bu konuda çok yanılıyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tevrat uzmanlarından biri gelip nasıl tartıştıklarını işitti. İsaʼnın onlara ne kadar güzel bir cevap verdiğini fark etti. Bunun üzerine İsaʼya sordu: “Buyrukların hangisi en önemli?” ");
INSERT INTO turobt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","İsa şöyle cevap verdi: “En önemli buyruk şudur: ‘Dinleyin, ey İsrailoğulları, Rab, yalnız Rab, Allahımızʼdır. ");
INSERT INTO turobt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Allahınız Rabbi bütün yüreğinizle, bütün canınızla, bütün aklınızla ve bütün gücünüzle sevin.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","İkinci buyruk şudur: ‘Komşunuzu kendinizi sevdiğiniz gibi sevin.’ Bunlardan daha önemli buyruk yoktur.” ");
INSERT INTO turobt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tevrat uzmanı İsaʼya, “Öğretmenim, doğru söyledin!” dedi, “ ‘O birdir ve Oʼndan başkası yok.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Oʼnu bütün yüreğinizle, bütün aklınızla ve bütün gücünüzle sevmek ve komşunuzu kendinizi sevdiğiniz gibi sevmek, yakılan adak ve kurbanların hepsinden daha önemlidir.” ");
INSERT INTO turobt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","İsa adamın nasıl akıllıca cevap verdiğini fark edince ona, “Sen Allahʼın Krallığıʼndan uzak değilsin!” dedi. Ondan sonra kimse artık İsaʼya soru sormaya cesaret etmedi. ");
INSERT INTO turobt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","İsa tapınak avlusunda vaaz ederken şöyle konuşmaya başladı: “Nasıl oluyor da Tevrat uzmanları Mesihʼin Davud Oğlu olduğunu söylüyorlar? ");
INSERT INTO turobt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Çünkü Davudʼun kendisi Kutsal Ruhʼun aracılığıyla şunu söyledi: ‘Rab Efendimʼe şöyle dedi: Senin düşmanlarını ayaklarının altına sereceğim. O zamana kadar sağımda otur.’ ");
INSERT INTO turobt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davud Mesihʼe ‘Efendim’ dediğine göre, Mesih nasıl Davudʼun oğlu olabilir?” Orada duran büyük kalabalık İsaʼyı zevkle dinliyordu. ");
INSERT INTO turobt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","İsa vaazına şöyle devam etti: “Tevrat uzmanlarından sakının. Onlar uzun kaftanlar içinde dolaşmayı severler. Çarşılarda selam almaya bayılırlar. ");
INSERT INTO turobt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Toplantı yerlerinde ve ziyafetlerde en saygın yerlere oturmak isterler. ");
INSERT INTO turobt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dul kadınları kandırıp mallarını mülklerini ellerinden alırlar. Gösteriş için uzun uzun dua ederler. Böyle kişiler çok ağır bir ceza alacaklar.” ");
INSERT INTO turobt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","İsa, tapınak avlusunda bağış kutusunun karşısında oturdu ve halkın oraya nasıl para attığına dikkat etti. Birçok zengin kişi bol para atıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Fakir bir dul kadın da gelip birkaç kuruş değerinde iki küçük bakır para attı. ");
INSERT INTO turobt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","İsa öğrencilerini yanına çağırıp onlara şöyle dedi: “Size doğrusunu söylüyorum: bu fakir dul kadın, bağış kutusuna para atanların hepsinden daha çok verdi. ");
INSERT INTO turobt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Çünkü bütün diğerleri servetlerinden artan parayı verdiler. Ama bu kadın fakir olduğu halde varını yoğunu, bütün geçimini bağışladı.” ");
INSERT INTO turobt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","İsa tapınak avlusundan çıkarken, öğrencilerinden biri Oʼna, “Öğretmenim!” dedi. “Bak ne biçim taşlar, ne biçim binalar!” ");
INSERT INTO turobt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","İsa ona şöyle cevap verdi: “Bu büyük binaları görüyor musunuz? Burada taş üstünde taş bırakılmayacak, hepsi yıkılacak.” ");
INSERT INTO turobt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","İsa, tapınağın karşısında Zeytin Dağıʼnda otururken Petrus, Yakub, Yuhanna ve Andreas özel olarak Oʼna şunu sordular: ");
INSERT INTO turobt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bize söyle. Bu şeyler ne zaman olacak ve bütün bunların yerine geleceğini gösteren işaret nedir?” ");
INSERT INTO turobt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","İsa da onlara anlatmaya başladı: “Dikkat edin, kimse sizi aldatmasın. ");
INSERT INTO turobt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Birçok kişi ortaya çıkıp benim adımı kullanacak. ‘Ben Mesihʼim’ deyip birçok kişiyi aldatacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Savaş gürültüleri, savaş haberleri duyduğunuzda korkmayın. Bunların olması lazım, ama bu daha son demek değildir. ");
INSERT INTO turobt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Çünkü millet millete, devlet devlete saldıracak. Yer yer depremler, kıtlıklar olacak. Bunlar doğum yapan kadının ilk sancıları gibi, sıkıntıların başlangıcıdır. ");
INSERT INTO turobt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Sizlerse kendinizi kollayın! Sizi dava yerlerine teslim edecekler ve toplantı yerlerinde kamçılayacaklar. Benim yüzümden sizi valilerin ve kralların önüne getirecekler. Bu size şahitlik etme fırsatı olacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Fakat önce Müjdeʼnin bütün milletlere duyurulması lazım. ");
INSERT INTO turobt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sizi tutuklayıp dava yerine teslim ettikleri zaman, ne söyleyeceğiz diye önceden kaygılanmayın. O anda söyleyeceğiniz sözler size verilecek. Zaten konuşan siz olmayacaksınız, Kutsal Ruh olacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kardeş kardeşi, baba evladını ölüme teslim edecek. Çocuklar da anne babalarına karşı ayaklanıp onları öldürtecekler. ");
INSERT INTO turobt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Benim adım yüzünden herkes sizden nefret edecek. Ama kim sonuna kadar dayanırsa, o kurtulacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tapınağın ‘kutsallığını bozan rezalet’ olmaması gereken yerde duracak. (Okuyan anlasın!) Bunu görünce Yahudiye bölgesinde olanlar dağlara kaçsınlar. ");
INSERT INTO turobt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Evin damında olan kişi ne aşağı insin, ne de bir şey almak için evine girsin. ");
INSERT INTO turobt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tarlada olan kişi de paltosunu almak için geri dönmesin. ");
INSERT INTO turobt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Vay o günlerde hamile olanların ve bebek emzirenlerin haline! ");
INSERT INTO turobt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dua edin ki, bunlar kış vakti olmasın. ");
INSERT INTO turobt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Çünkü o günler büyük bir eziyet zamanı olacak. Allahʼın dünyayı yarattığı zamandan bu yana böyle bir eziyet olmadı, bir daha da olmayacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Rab o günleri kısaltmasaydı, hiçbir insan kurtulmayacaktı. Ama Rab, seçilmiş olanlar, yani kendi seçtiği kişiler uğruna o günleri kısaltmıştır. ");
INSERT INTO turobt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","O zaman size birisi, ‘Bak, Mesih burada!’ ya da, ‘Bak, orada!’ derse, inanmayın. ");
INSERT INTO turobt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Çünkü ‘Ben Mesihʼim’ ve ‘Ben peygamberim’ diyen yalancılar ortaya çıkacak. Ellerinden gelirse, Allahʼın seçtiği insanları saptırmak için mucizeler ve harikalar yapacaklar. ");
INSERT INTO turobt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bu sebeple siz dikkatli olun! Her şeyi size önceden söylüyorum. ");
INSERT INTO turobt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ama o günlerde, o eziyet zamanından sonra, ‘güneş kararacak, ay da ışığını vermeyecek. ");
INSERT INTO turobt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yıldızlar gökten düşecek ve gökteki güçler sarsılacak.’ ");
INSERT INTO turobt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","O zaman İnsan Oğluʼnun bulutlar içinde büyük güç ve görkemle geldiğini görecekler. ");
INSERT INTO turobt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O vakit İnsan Oğlu melekleri gönderecek ve seçtiği kişileri dünyanın dört bucağından, yeryüzünün en uzak ucundan göğün en uzak ucuna kadar toplayacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","İncir ağacından ders alın: dalları filizlenip yaprak çıkarınca, yaz mevsiminin yaklaştığını bilirsiniz. ");
INSERT INTO turobt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bunun gibi, bu olayların gerçekleştiğini görünce bileceksiniz ki Allahʼın Krallığı yakındır, kapıdadır. ");
INSERT INTO turobt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Size doğrusunu söylüyorum: bu kuşak yok olmadan bütün bu şeyler yerine gelecek. ");
INSERT INTO turobt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gök ve yer ortadan kalkacak ama benim sözlerim asla ortadan kalkmayacak. ");
INSERT INTO turobt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yalnız, o günü ve o saati hiç kimse bilmiyor: ne gökteki melekler, ne de Oğul, sadece Baba biliyor. ");
INSERT INTO turobt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dikkat edin, gözünüzü dört açın! Çünkü o anın ne zaman geleceğini bilmiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bu durum, evini bırakıp yolculuğa çıkmış bir adama benzer. Gitmeden önce evini kölelerine emanet eder, herkese işini verir. Kapıdaki nöbetçiye de bekçilik yapmasını emreder. ");
INSERT INTO turobt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bu sebeple, tetikte durun, çünkü ev sahibinin ne vakit geleceğini bilmiyorsunuz. Akşam mı, gece yarısı mı, horoz öttüğü zaman mı, yoksa sabahleyin mi, belli olmaz. ");
INSERT INTO turobt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ansızın gelip sizi uykuda bulmasın. ");
INSERT INTO turobt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Size söylediğimi herkese söylüyorum: tetikte durun.” ");
INSERT INTO turobt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Özgürlük Bayramı ve Mayasız Ekmek Bayramı iki gün sonra başlayacaktı. Başrahipler ve Tevrat uzmanları İsaʼyı hileyle yakalayıp öldürmek için bir yol arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Aman!” dediler. “Bayramda olmasın, yoksa halk ayaklanacak!” ");
INSERT INTO turobt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","İsa Beytanya köyünde, Simun adında bir adamın evindeydi. Simun daha önce cüzzam hastasıydı. İsa yemek yerken bir kadın yanına geldi. Elinde kaymaktaşından bir kap vardı. Kapta çok pahalı saf hintsümbülü çiçeğinden yapılmış hoş kokulu yağ bulunuyordu. Kadın kabın ucunu kırdı, yağı yavaşça İsaʼnın başına döktü. ");
INSERT INTO turobt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oradakilerden bazıları buna kızdılar. Birbirlerine şöyle dediler: “Bu hoş kokulu yağ niye ziyan edildi? ");
INSERT INTO turobt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Üç yüz gümüş paradan fazlaya satılabilir, parası fakirlere dağıtılabilirdi.” Böylece kadına sertçe çıkıştılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama İsa, “Kadını rahat bırakın!” dedi. “Niçin onu üzüyorsunuz? O bana güzel bir şey yaptı. ");
INSERT INTO turobt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Fakirler her zaman sizinle olacak. İstediğiniz zaman onlara yardım edebilirsiniz. Ama ben her zaman sizinle olmayacağım. ");
INSERT INTO turobt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kadın elinden geleni yaptı. Bedenimi gömülmeye hazırlamak için üzerime yağ sürdü. ");
INSERT INTO turobt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Size doğrusunu söylüyorum: Müjde dünyanın neresinde duyurulursa, bu kadının yaptığı da anılacak.” ");
INSERT INTO turobt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","İsaʼnın on iki elçisinden biri olan Yahuda İskariyot, İsaʼyı ele vermek için başrahiplere gitti. ");
INSERT INTO turobt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Onlar bunu duyunca sevindiler. Yahudaʼya para ödemeye söz verdiler. O da İsaʼyı onların eline vermek için uygun bir fırsat aradı. ");
INSERT INTO turobt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mayasız Ekmek Bayramıʼnın birinci gününde Özgürlük Bayram kuzuları kesilirdi. İsaʼnın öğrencileri Oʼna sordular: “Bayram yemeğini nerede yemek istersin? Oraya gidip hazırlık yapalım.” ");
INSERT INTO turobt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","İsa öğrencilerinden iki kişiyi gönderdi. Onlara, “Şehre gidin” dedi. “Orada karşınıza testiyle su taşıyan bir adam çıkacak. Onun arkasından gidin. ");
INSERT INTO turobt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Adam bir eve girecek. O evin sahibine deyin ki, ‘Öğretmenimiz, “Misafir odam nerede?” diye soruyor. “Orada öğrencilerimle birlikte bayram yemeğini yemek istiyorum.” ’ ");
INSERT INTO turobt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","O size üst katta döşenmiş ve hazırlanmış büyük bir oda gösterecek. Bizim için orasını hazırlayın.” ");
INSERT INTO turobt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","İki öğrenci çıkıp şehre gitti. Her şeyi İsaʼnın anlattığı gibi buldular. Özgürlük Bayram hazırlıklarını yaptılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Akşam olunca İsa on iki elçisiyle geldi. ");
INSERT INTO turobt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Onlar sofraya oturmuş yemek yerken İsa şöyle dedi: “Size doğrusunu söylüyorum: aranızdan benimle yemek yiyen biri bana ihanet edecek!” ");
INSERT INTO turobt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Öğrenciler üzülmeye başladılar ve teker teker Oʼna sordular: “Herhalde ben değilim?” ");
INSERT INTO turobt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","İsa onlara şöyle dedi: “On iki elçiden biridir. Benimle birlikte ekmeğini çanağa bandırandır. ");
INSERT INTO turobt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gerçi İnsan Oğlu tıpkı kendisi hakkında yazıldığı gibi ölüme gidiyor. Ama İnsan Oğluʼna ihanet eden adamın vay haline! O adam hiç doğmasaydı, onun için daha iyi olurdu.” ");
INSERT INTO turobt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Onlar yemek yerken, İsa eline ekmek aldı, şükredip onu böldü ve öğrencilerine verdi. “Alın, bu benim bedenimdir” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sonra eline bir bardak şarap aldı, şükredip onlara verdi. Hepsi ondan içti. ");
INSERT INTO turobt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Onlara, “Bu benim kanımdır” dedi. “Birçok kişi için akıtılan antlaşma kanıdır. ");
INSERT INTO turobt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Size doğrusunu söylüyorum: Allahʼın Krallığıʼnda yenisini içeceğim güne kadar asmanın ürününden bir daha içmeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","İlahi söyledikten sonra, İsa ve öğrencileri çıkıp Zeytin Dağıʼna doğru gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","İsa onlara şöyle dedi: “Hepiniz beni terk edeceksiniz. Çünkü şöyle yazılmıştır: ‘Çobanı vuracağım, koyunlar da darmadağın olacak.’ ");
INSERT INTO turobt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama ben ölüp dirildikten sonra önünüzden Celileʼye gideceğim.” ");
INSERT INTO turobt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus İsaʼya, “Herkes seni terk etse de ben asla terk etmem!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","O zaman İsa ona şöyle dedi: “Sana doğrusunu söylüyorum: bu gece, horoz iki defa ötmeden, sen beni üç defa inkâr edeceksin.” ");
INSERT INTO turobt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus ise ısrarla şöyle dedi: “Seninle birlikte ölmem lazım olsa bile, seni asla inkâr etmem!” Hepsi de aynı şeyi söyledi. ");
INSERT INTO turobt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Böylece Getsemani adındaki bahçeye geldiler. İsa öğrencilerine şöyle dedi: “Ben dua ederken burada oturun.” ");
INSERT INTO turobt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yanına Petrusʼu, Yakubʼu ve Yuhannaʼyı aldı. Endişe ve derin bir sıkıntı hissetmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Onlara şöyle dedi: “Ben ölüm derecesinde üzüntülüyüm. Burada kalın ve uyanık durun.” ");
INSERT INTO turobt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","İsa biraz ileri gitti, yere kapandı. Eğer mümkünse acı çekeceği saati yaşamamak için dua etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Abba!Baba!” dedi. “Sen her şeyi yapabilirsin. Bu bardağı benden uzaklaştır. Yine de, benim istediğim değil, senin istediğin olsun.” ");
INSERT INTO turobt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","İsa döndüğünde öğrencileri uykuda buldu. Petrusʼa, “Simun, uyuyor musun?” dedi. “Bir saat bile uyanık duramadın mı? ");
INSERT INTO turobt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uyanık durun. Denendiğinizde günaha düşmemek için dua edin. Ruh istekli, ama beden zayıftır.” ");
INSERT INTO turobt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tekrar onlardan uzaklaşıp aynı sözlerle dua etti. ");
INSERT INTO turobt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Geri geldiğinde onları yine uykuda buldu. Çünkü gözleri ağırlaşmıştı. İsaʼya ne cevap vereceklerini bilemediler. ");
INSERT INTO turobt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","İsa üçüncü defa gelip onlara şöyle dedi: “Hâlâ uyuyor ve dinleniyorsunuz! Yeter artık! Saat geldi. Bakın, İnsan Oğlu günahkârların eline teslim ediliyor. ");
INSERT INTO turobt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kalkın, gidelim! Bakın, bana ihanet eden adam yaklaşıyor!” ");
INSERT INTO turobt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","İsa daha konuşurken, on iki elçiden biri olan Yahuda geldi. Yanında bir kalabalık vardı. Kılıçlar ve sopalar taşıyorlardı. Başrahipler, Tevrat uzmanları ve halkın liderleri onları yollamıştı. ");
INSERT INTO turobt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","İsaʼya ihanet eden Yahuda onlara şöyle bir işaret vermişti: “Kimi öpersem, İsa Oʼdur. Oʼnu yakalayın, sıkı tutup götürün.” ");
INSERT INTO turobt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yahuda gelir gelmez İsaʼya yaklaşıp, “Öğretmenim”, dedi ve Oʼnu öptü. ");
INSERT INTO turobt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bunun üzerine adamlar İsaʼyı yakalayıp tutukladılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ama İsaʼnın yanında olanlardan biri kılıcını çekti. Başrahibin kölesine vurup, onun kulağını kesti. ");
INSERT INTO turobt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","İsa gelenlere şöyle dedi, “Haydut muyum ki, beni kılıçlarla, sopalarla yakalamaya çıktınız? ");
INSERT INTO turobt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Her gün tapınak avlusunda aranızda vaaz ediyordum. O zaman beni tutuklamadınız. Ama bunlar, Kutsal Yazılarʼın sözleri yerine gelsin diye oldu.” ");
INSERT INTO turobt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bunun üzerine bütün öğrencileri İsaʼyı bırakıp kaçtılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","İsaʼnın ardından gidenlerin arasında sadece keten çarşafa sarınmış bir delikanlı da vardı. Onu da tutmaya çalıştılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ama o çarşafı bırakıp çırılçıplak kaçtı. ");
INSERT INTO turobt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","İsaʼyı başrahibin evine götürdüler. Orada bütün önemli rahipler, liderler ve Tevrat uzmanları toplanmıştı. ");
INSERT INTO turobt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus ise İsaʼyı uzaktan izledi. Sonunda başrahibin avlusuna girdi. Görevlilerle birlikte oturmuş, ateş başında ısınıyordu. ");
INSERT INTO turobt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Başrahipler ve Meclisʼin öbür üyeleri İsaʼyı ölüm cezasına çarptırabilmek için Oʼna karşı şahitlik yapacak birilerini bulmaya çalışıyorlardı. Ama hiç bulamadılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bir sürü kişi İsa hakkında yalancı şahitlik yaptı, ama şahitlikleri birbirine uymadı. ");
INSERT INTO turobt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kimi adamlar kalkıp İsa hakkında yalancı şahitlik yaptılar: ");
INSERT INTO turobt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Biz Oʼnun şöyle konuştuğunu işittik: ‘Elle yapılmış bu tapınağı yıkıp üç gün sonra elle yapılmamış başka bir tapınak kuracağım!’ ” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ama bu konuda bile şahitlikleri birbirine uymadı. ");
INSERT INTO turobt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Başrahip ayağa kalkıp orta yere çıktı ve İsaʼya şunu sordu: “Bu adamların sana karşı yaptıkları şahitliklere cevabın yok mu?” ");
INSERT INTO turobt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama İsa sessiz kaldı, hiç cevap vermedi. Başrahip tekrar Oʼna sordu: “Övülmeye layık OlanʼınOğlu Mesih sen misin?” ");
INSERT INTO turobt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","İsa, “Evet” dedi. “Ben Oʼyum! Üstelik İnsan Oğluʼnun, kudret Sahibiʼnin sağında oturduğunu ve gökteki bulutlarla geldiğini göreceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bunun üzerine başrahip elbiselerini yırttı ve “Artık şahitlere ne ihtiyacımız kaldı?” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Kendini Allahʼla bir saydığını siz kendiniz işittiniz. Kararınız ne?” Oradakilerin hepsi İsaʼnın ölüm cezasını hak ettiğine karar verdi. ");
INSERT INTO turobt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bazıları Oʼnun üzerine tükürmeye başladılar. Gözlerini bağlayıp Oʼnu yumrukladılar. “Haydi, peygamberliğini göster!” dediler. Nöbetçiler de Oʼnu aralarına alıp tokatladılar. ");
INSERT INTO turobt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bu arada Petrus aşağıda, avluda bulunuyordu. Başrahibin bir hizmetçi kızı oradan geçti. ");
INSERT INTO turobt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petrusʼun ısınmakta olduğunu gördü. Ona dikkatle baktıktan sonra, “Sen de Nasıralı İsaʼyla birlikteydin” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petrus ise bunu inkâr etti. “Ne söylüyorsun bilmiyorum, anlamıyorum da!” dedi. Sonra dışarıya avlunun kapısının önüne çıktı. Bu arada horoz öttü. ");
INSERT INTO turobt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hizmetçi kız Petrusʼu görünce etrafta duranlara yine “Bu adam da onlardandır!” demeye başladı. ");
INSERT INTO turobt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petrus bunu bir daha inkâr etti. Az sonra etrafta duranlar yine Petrusʼa, “Elbette onlardansın, çünkü sen de Celileʼdensin” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bunun üzerine Petrus kendine lanet okuyup yemin etmeye başladı. “Bahsettiğiniz adamı tanımıyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","O anda horoz ikinci defa öttü. Petrus da İsaʼnın şu sözünü hatırladı: “Horoz iki kere ötmeden sen beni üç defa inkâr edeceksin.” Sonra yere çöküp hüngür hüngür ağlamaya başladı. ");
INSERT INTO turobt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sabah olunca başrahipler, liderler, Tevrat uzmanları ve Meclisʼin öbür üyeleri danışma toplantısı yaptılar. Sonuç olarak İsaʼyı bağlayıp götürdüler ve Vali Pilatusʼa teslim ettiler. ");
INSERT INTO turobt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus İsaʼyı sorguya çekti: “Sen Yahudilerin kralı mısın?” İsa ona şöyle cevap verdi: “Bunu sen söylüyorsun.” ");
INSERT INTO turobt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Başrahipler İsaʼyı birçok şeyle suçlamaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus Oʼnu yine sorguya çekti. “Hiç cevap vermeyecek misin?” dedi. “Bak, seni ne kadar çok şeyle suçluyorlar!” ");
INSERT INTO turobt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama İsa artık hiç cevap vermedi. Pilatus buna şaştı. ");
INSERT INTO turobt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatus her yıl Özgürlük Bayramıʼnda halkın istediği bir tutukluyu serbest bırakırdı. ");
INSERT INTO turobt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","O sırada hapiste Barabba adında bir adam vardı. Başka isyancılarla birlikte ayaklanma sırasında adam öldürmüştü. ");
INSERT INTO turobt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kalabalık toplanıp Pilatusʼtan kendileri için her yıl yaptığı gibi yapmasını rica etmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus onlara şöyle karşılık verdi: “Yahudilerin Kralıʼnı serbest bırakmamı ister misiniz?” ");
INSERT INTO turobt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Çünkü başrahiplerin İsaʼyı kıskandıklarını ve bu sebeple Oʼnu kendisine teslim ettiklerini biliyordu. ");
INSERT INTO turobt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ne var ki, başrahipler İsaʼnın değil de Barabbaʼnın serbest bırakılmasını istiyorlardı. Kalabalığı da bunu istemeye kışkırttılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus onlara bir daha sordu: “Peki, Yahudilerin kralı dediğiniz adama ne yapmamı istiyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Oʼnu çarmıha ger!” diyerek yine bağırdılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus onlara sordu: “Adam ne kötülük yaptı ki?” Ama halk daha da fazla bağırmaya devam etti: “Oʼnu çarmıha ger!” ");
INSERT INTO turobt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus halkın gönlünü almak istiyordu. Onun için onlara Barabbaʼyı serbest bıraktı. Sonra İsaʼyı kamçılattı ve çarmıha gerilsin diye askerlere teslim etti. ");
INSERT INTO turobt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Askerler İsaʼyı Pretoriyumʼa yani vali sarayına götürdüler. Bütün asker bölüğünü topladılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","İsaʼya mor renkli bir kaftan giydirdiler ve başına dikenlerden örülmüş bir taç koydular. ");
INSERT INTO turobt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sonra Oʼnu, “Yaşasın Yahudilerin kralı!” diye selamlamaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Başına sopayla vurdular, Oʼna tükürdüler ve diz çöküp önünde yere kapandılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","İsaʼyla alay ettikten sonra üzerinden mor renkli kaftanı çıkarıp kendi elbiselerini giydirdiler. Sonra Oʼnu çarmıha germek için dışarıya çıkardılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yolda Simun adında Kireneli bir adamla karşılaştılar. İskender ve Rufusʼun babası olan Simun şehir dışından geliyordu. Askerler onu İsaʼnın çarmıhını taşımaya zorladılar. ");
INSERT INTO turobt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","İsaʼyı Golgota denilen yere götürdüler. Bu ad kafatası yeri demektir. ");
INSERT INTO turobt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","İsaʼya ilaçlı şarap sundular, fakat O kabul etmedi. ");
INSERT INTO turobt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","İsaʼyı çarmıha gerdiler. Sonra Oʼnun elbiselerini paylaşmak için, kim neyi alacak diye kura çektiler. ");
INSERT INTO turobt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","İsaʼyı çarmıha gerdikleri zaman saat dokuzdu. ");
INSERT INTO turobt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Çarmıhta Oʼnu “Yahudilerin Kralı” diye suçlayan bir yazı vardı. ");
INSERT INTO turobt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","İsaʼyla birlikte, iki haydudu da çarmıha gerdiler. Biri sağındaki, öbürü solundaki çarmıhtaydı. ");
INSERT INTO turobt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Oradan geçenler başlarını sallayıp İsaʼya hakaret ettiler: “Hey, sen tapınağı yıkıp üç günde yeniden kuracaktın! ");
INSERT INTO turobt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Haydi, şimdi çarmıhtan inip kendini kurtar!” ");
INSERT INTO turobt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aynı şekilde başrahipler ve Tevrat uzmanları da İsaʼyla alay edip birbirlerine şöyle dediler: “Başkalarını kurtardı, ama kendini kurtaramıyor! ");
INSERT INTO turobt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","İsrailʼin kralı Mesih kendisiymiş! O zaman çarmıhtan insin de, bunu görelim ve iman edelim!” İsa ile birlikte çarmıha gerilmiş olanlar da Oʼna hakaret ettiler. ");
INSERT INTO turobt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Saat öğleyin on iki olunca, bütün ülkenin üzerine karanlık çöktü. Bu karanlık saat üçe kadar sürdü. ");
INSERT INTO turobt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saat üçte İsa sesini yükselterek, “Elohi, Elohi, lema şevaktani?” dedi. Bu söz, “Allahım, Allahım, beni niçin terk ettin?” demektir. ");
INSERT INTO turobt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Orada duranların bazıları bunu işitince “Bakın, İlyasʼı çağırıyor!” dediler. ");
INSERT INTO turobt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Adamın biri koşup bir sünger aldı, onu ekşi şaraba batırdı. Süngeri bir kamışın ucuna takarak İsaʼya içirmeye çalıştı. “Bakalım İlyas Oʼnu çarmıhtan indirmeye gelecek mi?” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sonra İsa yüksek sesle bağırıp son nefesini verdi. ");
INSERT INTO turobt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tapınaktaki perde yukarıdan aşağıya kadar yırtılıp ikiye ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","İsaʼnın karşısında duran yüzbaşı Oʼnun son nefesini nasıl verdiğini gördü. “Bu adam gerçekten Allahʼın Oğluʼydu!” dedi. ");
INSERT INTO turobt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bazı kadınlar da olup bitenleri uzaktan izliyorlardı. Onların arasında Mecdelli Meryem, küçük Yakubʼun ve Yusufʼun annesi Meryem ve Salome vardı. ");
INSERT INTO turobt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","İsa daha Celileʼdeyken bu kadınlar, Oʼnun peşinden gidip, Oʼna hizmet etmişlerdi. Oʼnunla birlikte Yeruşalimʼe gelen başka birçok kadın da oradaydı. ");
INSERT INTO turobt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Akşam oluyordu. Hazırlık Günü, yani Şabatʼtan önceki gündü. ");
INSERT INTO turobt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bu sebeple Aramatyalı Yusuf cesaretini toplayıp Pilatusʼa gitti. Ondan İsaʼnın ölüsünü istedi. Yusuf Meclisʼin saygıdeğer bir üyesiydi ve Allahʼın Krallığıʼnın gelişini umutla bekliyordu. ");
INSERT INTO turobt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus İsaʼnın bu kadar çabuk öldüğü haberine şaştı. Onun için yüzbaşıyı çağırtıp, “Öleli çok oldu mu?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Olup bitenleri yüzbaşıdan öğrendikten sonra, cesedi Yusufʼa verdi. ");
INSERT INTO turobt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusuf keten bez satın aldı. Cesedi çarmıhtan indirdikten sonra beze sardı ve kayanın içine oyulmuş bir mezara koydu. Sonra mezarın girişine bir taş yuvarlayıp mezarı kapattı. ");
INSERT INTO turobt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mecdelli Meryem ve Yusufʼun annesi Meryem İsaʼnın cesedinin nereye koyulduğunu gördüler. ");
INSERT INTO turobt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Şabat günü geçtikten sonra Mecdelli Meryem, Yakubʼun annesi Meryem ve Salome hoş kokulu yağ satın aldılar. Gidip yağı İsaʼnın cesedine süreceklerdi. ");
INSERT INTO turobt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pazar günü çok erken, güneş doğarken mezara gittiler. ");
INSERT INTO turobt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yolda birbirlerine, “Mezarın girişini kapatan taşı bizim için kim yana yuvarlayacak?” diyorlardı. ");
INSERT INTO turobt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baktıklarında o kocaman taşın yana yuvarlanmış olduğunu fark ettiler. ");
INSERT INTO turobt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mezara girdikten sonra sağ tarafta oturan, beyaz kaftan giyinmiş genç bir adam gördüler. Çok şaşırıp korktular. ");
INSERT INTO turobt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Adam kadınlara “Korkmayın!” dedi. “Siz çarmıha gerilmiş olan Nasıralı İsaʼyı arıyorsunuz. O dirildi. Burada yok. İşte bakın, Oʼnu buraya yatırmışlardı. ");
INSERT INTO turobt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Şimdi gidin, Petrusʼa ve İsaʼnın diğer öğrencilerine şöyle deyin: ‘İsa sizden önce Celileʼye gidiyor. Aynen size söylediği gibi, Oʼnu orada göreceksiniz.’ ” ");
INSERT INTO turobt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kadınlar dışarı çıkıp mezardan kaçtılar. Onları bir titreme ve şaşkınlık aldı. Korktukları için kimseye bir şey söylemediler. ");
INSERT INTO turobt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","İsa, haftanın ilk günü, yani Pazar günü, erken saatlerde ölümden dirildi. İlk olarak Mecdelli Meryemʼe göründü. İsa bu kadından yedi cin kovmuştu. ");
INSERT INTO turobt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meryem gidip İsaʼnın izleyicilerine haber verdi. Onlar yas tutup ağlamaktaydılar. ");
INSERT INTO turobt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","İsaʼnın yaşadığını ve Meryemʼe göründüğünü işitince, inanmadılar. ");
INSERT INTO turobt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bundan sonra İsaʼnın iki izleyicisi kıra doğru giderken İsa onlara farklı bir şekilde göründü. ");
INSERT INTO turobt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","İki izleyici geri dönüp diğerlerine haber verdi. Fakat onlara da inanmadılar. ");
INSERT INTO turobt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Daha sonra on bir öğrencisi yemek yerken İsa onlara göründü. İmansız ve inatçı oldukları için onları azarladı. Çünkü Oʼnu dirilmiş olarak görenlere inanmamışlardı. ");
INSERT INTO turobt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","İsa onlara şöyle buyurdu: “Bütün dünyaya gidin ve Müjdeʼyi bütün insanlara duyurun. ");
INSERT INTO turobt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kim iman edip vaftiz olursa, o kurtulacak. Ama kim iman etmezse, o hüküm giyecek. ");
INSERT INTO turobt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","İman edenlerin arasında şu mucizevi işaretler görülecek: benim adımla cinleri kovacaklar, yeni diller konuşacaklar. ");
INSERT INTO turobt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yılanları elleriyle tutacaklar, zehir içseler de zarar görmeyecekler. Elleriyle hastalara dokunacaklar ve hastalar şifa bulacak.” ");
INSERT INTO turobt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Rab İsa on bir öğrencisiyle konuştuktan sonra göğe alındı ve Allahʼın sağında oturdu. ");
INSERT INTO turobt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Onlar da gidip bu haberi her yerde duyurdular. Rab onlarla birlikte çalışıyordu ve söylediklerini mucizevi işaretlerle doğruluyordu.");
INSERT INTO turobt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Birçok kişi aramızda geçen olaylar hakkındaki bilgileri bir araya getirmeye çalışmıştı. ");
INSERT INTO turobt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bu olayları başlangıçtan beri gözleriyle görenler ve Allahʼın sözüne hizmet edenler bize anlattılar. ");
INSERT INTO turobt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ben de her şeyi en baştan dikkatle araştıran biriyim. Buna göre, ey saygıdeğer Teofilos, bunları sana düzenli bir şekilde yazmayı uygun gördüm. ");
INSERT INTO turobt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Öyle ki, bilgi aldığın konuların doğruluğunu kesinlikle bilesin. ");
INSERT INTO turobt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yahudiye kralı Hirodesʼin günlerinde Zekeriya adında bir rahip vardı. Rahiplerin Aviya denilen hizmet grubuna bağlıydı. Onun bir de Harun soyundan karısı vardı. Adı Elizabetʼti. ");
INSERT INTO turobt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","İkisi de Allahʼın gözünde iyi insanlardı. Rabbin bütün buyruklarını ve kurallarını kusursuzca yerine getirirlerdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama çocukları yoktu. Çünkü ikisi de çok yaşlıydı ve Elizabet kısırdı. ");
INSERT INTO turobt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bir gün hizmet sırası Zekeriyaʼnın grubuna gelmişti. Zekeriya da Allahʼa rahip olarak hizmet ediyordu. ");
INSERT INTO turobt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Rabbin tapınağına girip hoş kokulu tütsü yakmak için seçilmişti. Rahiplerin adetine göre bu ibadet görevini yapacak rahip kura çekilerek seçilirdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tütsü yakma zamanı geldiğinde büyük bir kalabalık dışarda toplanmış dua ediyordu. ");
INSERT INTO turobt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","O sırada Rabbin bir meleği tütsü masasının sağında durup Zekeriyaʼya göründü. ");
INSERT INTO turobt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Meleği görünce Zekeriya ürktü, korkuya kapıldı. ");
INSERT INTO turobt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama melek ona şöyle dedi: “Korkma Zekeriya! Çünkü duan kabul edildi. Karın Elizabet sana bir oğul doğuracak. Adını Yahya koyacaksın. ");
INSERT INTO turobt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sevinip coşacaksın. Birçok kişi de onun doğuşuna sevinecek. ");
INSERT INTO turobt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Çünkü o, Rabbin gözünde büyük adam olacak. Hiç şarap ya da başka alkollü içki içmeyecek. Daha annesinin karnındayken Kutsal Ruhʼla dolu olacak. ");
INSERT INTO turobt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","İsrailoğullarından birçoğunu Allahları olan Rabbe geri döndürecek. ");
INSERT INTO turobt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","İlyasʼın ruhu ve gücüyle Rabbin önünden gidecek. Babaların yüreklerini yeniden çocuklarına döndürecek. İtaatsizleri de doğru kişilerin anlayışına çevirecek. Böylece Rabbe hazırlanmış bir halk yetiştirecek.” ");
INSERT INTO turobt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekeriya da meleğe şöyle dedi: “Peki, bundan nasıl emin olabilirim? Çünkü ben yaşlı bir adamım, karım da çok yaşlı.” ");
INSERT INTO turobt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Melek ona şöyle cevap verdi: “Ben Cebrailʼim. Allahʼın huzurunda hizmet ederim. Seninle konuşmaya ve sana bu müjdeyi vermeye gönderildim. ");
INSERT INTO turobt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Zamanında gerçekleşecek sözlerime inanmadığın için dilin tutulacak. Bu şeylerin yerine geleceği güne kadar konuşamayacaksın.” ");
INSERT INTO turobt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zekeriyaʼyı bekleyen halk, tapınakta neden geciktiğini merak etti. ");
INSERT INTO turobt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zekeriya dışarı çıktığı zaman, onlarla konuşamadı. Tapınakta olağanüstü bir görüntü gördüğünü anladılar. Eliyle işaretler yapan Zekeriya hâlâ konuşamıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tapınaktaki hizmet günleri bitince, Zekeriya kendi evine döndü. ");
INSERT INTO turobt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bir süre sonra karısı Elizabet hamile kaldı ve beş ay evine kapandı. ");
INSERT INTO turobt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Rab bunu benim için yaptı!” dedi. “Bu günlerde benimle ilgilendi, halkın gözünde utancımı ortadan kaldırdı.” ");
INSERT INTO turobt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabetʼin hamileliğinin altıncı ayında melek Cebrail Allah tarafından Celileʼdeki Nasıra kasabasına gönderildi. ");
INSERT INTO turobt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Orada Meryem adında bakire bir kız vardı. O da Davudʼun soyundan olan Yusuf adında bir adamla nişanlıydı. ");
INSERT INTO turobt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Melek içeri girip Meryemʼe şöyle dedi: “Selam, ey Allahʼın lütfuna kavuşan kız! Rab seninle.” ");
INSERT INTO turobt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ama Meryem bu söze şaşırdı. Bu selamın ne anlama geldiğini düşünüp durdu. ");
INSERT INTO turobt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Melek ona “Korkma Meryem” dedi. “Çünkü Allahʼın lütfuna kavuştun. ");
INSERT INTO turobt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hamile kalıp bir oğul dünyaya getireceksin. Adını İsa koyacaksın. ");
INSERT INTO turobt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O büyük olacak. Oʼna ‘Yüce Allahʼın Oğlu’ denecek. Rab Allah Oʼna atası kral Davudʼun tahtını verecek. ");
INSERT INTO turobt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O Yakub soyu üzerinde sonsuza kadar hüküm sürecek ve Krallığıʼnın sonu hiç gelmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meryem meleğe şöyle dedi: “Bu nasıl olur? Hiçbir erkekle ilişkim olmadı.” ");
INSERT INTO turobt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Melek ona şöyle cevap verdi: “Kutsal Ruh senin üzerine gelecek. Yüce Allahʼın gücü, senin üzerine gölge yapacak. Bunun için doğacak kutsal çocuğa ‘Allahʼın Oğlu’ denecek. ");
INSERT INTO turobt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bak, senin akrabalarından Elizabet bile çok yaşlı olduğu halde hamile kaldı ve bir oğlu olacak. Kısır dedikleri bu kadın şimdi altıncı ayındadır. ");
INSERT INTO turobt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Çünkü Allah için imkansız bir şey yoktur.” ");
INSERT INTO turobt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meryem de şöyle dedi: “Ben Rabbin hizmetkârıyım. Bana söylediğin gibi olsun.” Melek de onun yanından ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","O günlerde Meryem aceleyle hazırlanıp Yahuda dağlık bölgesinde bulunan bir kasabaya gitti. ");
INSERT INTO turobt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zekeriyaʼnın evine girip Elizabetʼe selam verdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet Meryemʼin selamını işitince, onun karnındaki bebek hopladı. Elizabet de Kutsal Ruhʼla doldu. ");
INSERT INTO turobt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yüksek sesle şöyle dedi: “Sen kadınlar arasında kutsanmış olansın, karnındaki bebek de kutsanmıştır. ");
INSERT INTO turobt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bu nasıl oldu da, Efendimʼin annesi bana kadar geldi? ");
INSERT INTO turobt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Çünkü selamını işittiğim an bebek karnımda sevinçle hopladı. ");
INSERT INTO turobt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne mutlu o kadına ki, Rabbin ona söylediği şeylerin gerçekleşeceğine inandı!” ");
INSERT INTO turobt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meryem de şöyle dedi: “Rabbi candan yüceltirim. ");
INSERT INTO turobt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Allah beni kurtardığı için ruhum coştu. ");
INSERT INTO turobt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Çünkü O, benim gibi sıradan bir hizmetkârına ilgi gösterdi. Bundan böyle bütün kuşaklar beni mutlu sayacak. ");
INSERT INTO turobt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Çünkü kudretli Allah benim için büyük işler yaptı. Kutsaldır Oʼnun adı. ");
INSERT INTO turobt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kuşaktan kuşağa kendisinden korkanlara merhamet eder. ");
INSERT INTO turobt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O, kendi koluyla gücünü gösterdi. Gururlu insanları yüreklerindeki fikirleriyle darmadağın etti. ");
INSERT INTO turobt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Güçlü liderleri tahtlarından aşağı attı ve sıradan insanları yükseltti. ");
INSERT INTO turobt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aç olanları iyiliklerle doyurdu, zenginleri ise boş ellerle geri çevirdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kendi merhametini anıp hizmetkârı olan İsrail halkına yardım etti. ");
INSERT INTO turobt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Atalarımıza söz verdiği gibi, İbrahimʼe ve soyuna sonsuza kadar merhamet edecek.” ");
INSERT INTO turobt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meryem üç ay kadar Elizabetʼin yanında kaldı. Sonra evine döndü. ");
INSERT INTO turobt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabetʼin doğurma vakti gelince, bir oğul dünyaya getirdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabetʼin komşuları ve akrabaları Rabbin ona ne kadar büyük merhamet gösterdiğini duydular. Onunla beraber sevindiler. ");
INSERT INTO turobt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bebek sekiz günlükken sünnetine geldiler. Ona babası Zekeriyaʼnın adını vereceklerdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Fakat Annesi söz alıp, “Hayır, olamaz!” dedi. “Adı Yahya olacak.” ");
INSERT INTO turobt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ona şöyle dediler: “Senin akrabalarının arasında bu adı taşıyan kimse yok.” ");
INSERT INTO turobt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Çocuğun babasına el işaretleriyle, adını ne koymak istediğini sordular. ");
INSERT INTO turobt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O da bir yazı tahtası istedi. Üzerinde şöyle yazdı: “Adı Yahya.” Herkes de şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","O anda Zekeriyaʼnın ağzı açıldı ve dili çözüldü. Allahʼı överek konuşmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Komşuların hepsi korkuya kapıldı. Yahudiyeʼnin dağlık bölgesinin her tarafında bu olaylar konuşuluyordu. ");
INSERT INTO turobt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bunu işiten herkes olup bitenleri yüreklerinde sakladı. “Acaba bu çocuk nasıl biri olacak?” dediler. Çünkü Rabbin eli çocuğun üzerindeydi. ");
INSERT INTO turobt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yahyaʼnın babası Zekeriya Kutsal Ruhʼla dolup şöyle peygamberlik etti: ");
INSERT INTO turobt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“İsrailoğullarının Allahʼı Rabbe övgüler olsun. Çünkü kendi halkının yardımına geldi, onları esirlikten kurtardı. ");
INSERT INTO turobt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hizmetkârı Davudʼun soyundan bizim için güçlü bir Kurtarıcı ortaya çıkardı. ");
INSERT INTO turobt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bunu yapacağını uzun zaman önce kutsal peygamberlerinin ağzından bildirdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Allah, bizi düşmanlarımızdan koruyacağına, bizden nefret edenlerin elinden kurtaracağına söz verdi. ");
INSERT INTO turobt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Böylece Allah atalarımıza merhamet gösterdi, ve kutsal antlaşmasını anmış oldu. ");
INSERT INTO turobt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bu antlaşma atamız İbrahimʼe yemin ederek verdiği sözdür. ");
INSERT INTO turobt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Bu söze göre Allah, bizi düşmanlarımızın elinden kurtaracak. Bu sayede hayatımız boyunca pak ve doğru kişiler olarak, korkusuzca Oʼna hizmet edebileceğiz. ");
INSERT INTO turobt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sen de, ey çocuk, Yüce Allahʼın peygamberi olarak tanınacaksın. Çünkü Rabbin yolunu hazırlamak için Oʼnun önünden gideceksin. ");
INSERT INTO turobt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oʼnun halkına günahlarının bağışlanmasıyla kurtulacaklarını bildireceksin. ");
INSERT INTO turobt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Çünkü Allahımızʼın yüreği merhametle doludur. Bu sayede Mesih yücelerden doğan Güneş olarak yardımımıza gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Karanlıkta ve ölüm gölgesinde oturanların üzerine parlayacak, ayaklarımızı esenlik yoluna yöneltecek.” ");
INSERT INTO turobt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Çocuk büyüyor, ruhça güçleniyordu. İsrail halkının önüne çıkacaktı; ama o gün gelinceye kadar ıssız yerlerde yaşadı. ");
INSERT INTO turobt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","O günlerde Roma imparatorluğunda yaşayan herkesin sayılması için Sezar Avgustusʼtan bir buyruk çıktı. ");
INSERT INTO turobt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bu, birinci sayımdı. O vakit Kirinius Suriyeʼnin yöneticisiydi. ");
INSERT INTO turobt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Herkes sayılmak için kendi memleketine gitti. ");
INSERT INTO turobt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusuf da Celile bölgesindeki Nasıra kasabasından Yahudiyeʼdeki Beytlehem kasabasına gitti. Beytlehem Davudʼun doğduğu kasabaydı. Yusuf Davudʼun soyundan ve ailesinden olduğu için oraya gitti. ");
INSERT INTO turobt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yazılmaya gittiğinde yanına hamile olan nişanlısı Meryemʼi aldı. ");
INSERT INTO turobt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Onlar Beytlehemʼdeyken Meryemʼin doğum yapma zamanı geldi. ");
INSERT INTO turobt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","İlk oğlunu doğurdu. Oʼnu bezlere sarıp bir yemliğe yatırdı, çünkü misafir odasında onlara yer yoktu. ");
INSERT INTO turobt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aynı bölgede kırlıkta yaşayan çobanlar vardı. Geceleyin nöbet tutup sürülerini koruyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Birdenbire Rabbin bir meleği onlara göründü ve Rabbin görkemi etraflarında parladı. Büyük korkuya kapıldılar. ");
INSERT INTO turobt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Melek onlara “Korkmayın!” dedi. “Bakın, size bütün halkı çok sevindirecek bir müjde veriyorum. ");
INSERT INTO turobt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Çünkü bugün size Davudʼun kasabasında bir kurtarıcı doğdu. O da Efendiniz Mesihʼtir. ");
INSERT INTO turobt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sizin için işaret şu olacak: bezlere sarılmış ve yemlikte yatan bir bebek bulacaksınız.” ");
INSERT INTO turobt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aniden meleğin yanında göksel ordudan büyük bir topluluk göründü. Allahʼı överek şöyle diyorlardı: ");
INSERT INTO turobt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“En yücelerde olan Allahʼa övgüler olsun. Yeryüzünde de Allahʼın hoşnut olduğu insanlara esenlik olsun.” ");
INSERT INTO turobt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Melekler yanlarından ayrılıp göğe çekildikten sonra, çobanlar aralarında konuşmaya başladılar. “Haydi, Beytlehemʼe gidelim” dediler. “Rabbin bize bildirdiği bu olayı görelim.” ");
INSERT INTO turobt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Çobanlar aceleyle ayrıldılar. Meryemʼle Yusufʼu ve bebeği arayıp buldular. Bebek yemlikte yatıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Çobanlar onları görünce bebek hakkında bildirilen sözü anlattılar. ");
INSERT INTO turobt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Haberi duyan herkes çobanların anlattıklarına şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ama Meryem bütün bunları derin derin düşünerek yüreğinde sakladı. ");
INSERT INTO turobt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Çobanlar da yerlerine dönerken, duydukları ve gördükleri her şey için Allahʼı övüp yücelttiler. Çünkü her şey tam onlara anlatıldığı gibiydi. ");
INSERT INTO turobt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sekiz gün geçtikten sonra çocuğu sünnet etme zamanı geldi. Oʼna İsa adı verildi. Bu ad annesi hamile kalmadan önce melek tarafından Oʼna verilmişti. ");
INSERT INTO turobt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Musaʼya verilen Tevratʼa göre onların temizlenme zamanı sona erdi. Çocuğu Rabbe adamak için Yeruşalimʼe götürdüler. ");
INSERT INTO turobt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Rabbin verdiği Tevratʼta şöyle yazılmıştır: “Ana karnından ilk doğan her erkek çocuk Rabbe adanacak.” ");
INSERT INTO turobt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hem de Tevratʼta denildiği gibi: “Bir çift kumru, ya da iki güvercin yavrusu” kurban olarak sunulmalıdır. ");
INSERT INTO turobt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bu arada, Yeruşalimʼde Şimon adında bir adam vardı. Allahʼa bağlı, iyi bir adamdı. İsrail halkının esirlikten kurtulmasını hasretle bekliyordu. Kutsal Ruh da onun üzerindeydi. ");
INSERT INTO turobt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kutsal Ruh, Rabbin söz verdiği Kurtarıcı Mesihʼi görmeden ölmeyeceğini vahiyle ona bildirmişti. ");
INSERT INTO turobt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Şimon Ruhʼun yol göstermesiyle tapınağa geldi. O sırada bebek İsaʼnın annesi ve babası Tevratʼtaki adeti yerine getirmek için çocuğu getirdiler. ");
INSERT INTO turobt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Şimon bebeği kucağına alıp Allahʼı şöyle övdu: ");
INSERT INTO turobt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ey Efendim, söz verdiğin gibi, şimdi hizmetkârını serbest bırakıyorsun. Artık rahatlıkla bu hayattan ayrılabilirim. ");
INSERT INTO turobt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Çünkü hazırladığın kurtuluşu kendi gözlerimle gördüm. ");
INSERT INTO turobt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bütün halklar da onu görecek. ");
INSERT INTO turobt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","O diğer milletlere aydınlık ve halkın İsrailʼe yücelik getiren ışık olacak.” ");
INSERT INTO turobt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","İsaʼnın annesi ve babası İsa hakkında söylenenlere şaşırıp kaldılar. ");
INSERT INTO turobt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Şimon da onlara Allahʼtan iyilik diledi ve sonra çocuğun annesi Meryemʼe “Bak!” dedi. “Bu çocuk yüzünden İsrailʼde birçok kişi düşecek, birçok kişi de yükselecek. Çocuk Allahʼtan gönderilen olağanüstü bir işaret olacak. Ama birçokları Oʼna karşı çıkacak. ");
INSERT INTO turobt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Senin başına gelecekler kalbini delip deşen kılıç gibi olacak. Bütün bunlar birçok kişinin yüreğindeki niyetlerini ortaya çıkaracak.” ");
INSERT INTO turobt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hanna adında yaşlı bir peygamber de oradaydı. Kendisi Aşer oymağından Fanuelʼin kızıydı. Evlendikten sonra yedi sene kocasıyla yaşamıştı. ");
INSERT INTO turobt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sonra dul kalmıştı. Seksen dört yaşına gelmişti. Tapınak avlusundan hiç ayrılmazdı. Gece gündüz oruç ve dualarla Allahʼa hizmet ederdi. ");
INSERT INTO turobt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tam o sırada yaklaşıp Allahʼa şükretti ve Yeruşalimʼin kurtuluşunu bekleyen herkese İsa hakkında konuşmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Rabbin kanununa göre her şeyi yerine getirdikten sonra, Celileʼye, kendi memleketleri olan Nasıraʼya döndüler. ");
INSERT INTO turobt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bu arada çocuk büyüyerek güçleniyordu. Hikmetle doluydu ve Allahʼın lütfu onun üzerindeydi. ");
INSERT INTO turobt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","İsaʼnın annesi ve babası her yıl Özgürlük Bayramı zamanında Yeruşalimʼe giderdi. ");
INSERT INTO turobt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","İsa on iki yaşını doldurunca, her zamanki gibi bayram adetine göre Yeruşalimʼe gittiler. ");
INSERT INTO turobt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bayramın sona erdiğinde eve dönmek için yol aldılar. Çocuk İsa ise Yeruşalimʼde kaldı. Ama annesi ve babası bunu fark etmediler. ");
INSERT INTO turobt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","İsaʼnın başka bir yolcu grubunda olduğunu sanarak bir günlük yol gittiler. Sonra onu akrabaları ve arkadaşlarının arasında aramaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","İsaʼyı bulamayınca, Oʼnu araya araya Yeruşalimʼe döndüler. ");
INSERT INTO turobt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Üç gün sonra Oʼnu tapınakta buldular. Tevrat öğretmenlerinin arasında oturuyordu. Hem onları dinliyor, hem de onlara sorular soruyordu. ");
INSERT INTO turobt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","İsaʼyı dinleyen herkes Oʼnun anlayışına ve verdiği cevaplara şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Annesiyle babası Oʼnu görünce hayret ettiler. Annesi İsaʼya, “Evladım!” dedi. “Bize bunu neden yaptın? Baban ve ben senin için çok endişelendik, seni her yerde aradık.” ");
INSERT INTO turobt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","İsa da onlara şöyle cevap verdi: “Beni niçin aradınız? Babamʼın evinde olmam lazım. Bunu bilmiyor muydunuz?” ");
INSERT INTO turobt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama Meryemʼle Yusuf Oʼnun bu sözünü anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","İsa onlarla birlikte Yeruşalimʼden Nasıraʼya döndü ve onların sözünü dinlemeye devam etti. Annesi bütün bu olayları yüreğinde sakladı. ");
INSERT INTO turobt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","İsa hikmette gelişerek büyüyordu. Allahʼın ve insanların gönlünü kazanıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sezar Tiberiusʼun imparatorluğunun on beşinci yılıydı. Pontiyus Pilatus Yahudiye valisiydi. İmparatorun izniyle Celile bölgesinde Hirodes, İtureya ve Trahonitis bölgelerinde kardeşi Filipus ve Abilene bölgesinde Lisanias krallık ediyordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanan ile Kayafa başrahiptiler. Tam o sırada Allahʼın sözü ıssız yerlerde yaşayan Zekeriya oğlu Yahyaʼya geldi. ");
INSERT INTO turobt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yahya bütün Şeria ırmağının çevresini dolaştı. Halkı günahlarının bağışlanması için tövbe edip vaftiz olmaya çağırıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Onun hakkında Peygamber Yeşaya kitabında şunu yazmıştır: “Issız yerlerde sesini yükselten biri, ‘Rabbin yolunu hazırlayın, geçeceği yerleri düz yapın!’ diyor. ");
INSERT INTO turobt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Her dere doldurulacak, her dağ ve her tepe alçaltılacak, eğri yollar doğrultulacak, inişli yokuşlu yerler düzleştirilecek. ");
INSERT INTO turobt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","O zaman bütün insanlık Allahʼın kurtarışını görecek.” ");
INSERT INTO turobt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","İnsanlar vaftiz olmak için kalabalık halinde Yahyaʼya geliyordu. Yahya onlara şöyle diyordu: “Ey yılan soyu! Allahʼın vereceği cezadan kaçabileceğinizi kim söyledi? ");
INSERT INTO turobt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bunun için tövbenize layık meyve verin. Kendi kendinize ‘Atamız İbrahimʼdir’ demeye kalkmayın. Ben size diyorum ki, Allah şu taşlardan bile İbrahimʼe çocuklar yaratabilecek güçtedir. ");
INSERT INTO turobt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Balta artık ağaçların köküne dayandı. İyi meyve vermeyen her ağaç kesilip ateşe atılacak.” ");
INSERT INTO turobt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Halk Yahyaʼya, “O zaman ne yapalım?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O da onlara şu cevabı verirdi: “Kimin iki gömleği varsa bir tanesini hiç gömleği olmayana versin. Aynı bunun gibi kimin yiyeceği varsa onu hiç yiyeceği olmayanla paylaşsın.” ");
INSERT INTO turobt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bazı vergi memurları da vaftiz olmaya geldiler. Ona şunu sordular: “Öğretmenimiz, biz ne yapalım?” ");
INSERT INTO turobt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Onlara şu cevabı verdi: “Size emredilen vergi parasından daha fazlasını toplamayın.” ");
INSERT INTO turobt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Askerlerden bazıları sordular: “Ya biz ne yapalım?” Onlara da şu cevabı verdi: “Kaba kuvvetle hiç kimseden para koparmayın. Kimseyi de yalan yere suçlamayın. Aldığınız ücretle yetinin.” ");
INSERT INTO turobt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","O sırada halk umutlanıyordu. Yahya hakkında herkesin aklında “Acaba Mesih bu mu?” sorusu vardı. ");
INSERT INTO turobt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahya da onların hepsine şöyle cevap verdi: “Ben sizi suyla vaftiz ediyorum. Ama benden daha güçlü biri geliyor. Oʼnun ayaklarındaki sandalet bağlarını çözmeye layık değilim. O, sizi Kutsal Ruhʼla ve ateşle vaftiz edecek. ");
INSERT INTO turobt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Küreği elindedir. O kürekle harman yerini temizleyip buğdayı ambarına toplayacak. Ama samanı hiç sönmeyen ateşle yakacak.” ");
INSERT INTO turobt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahya daha birçok sözle halka öğüt verip Müjdeʼyi bildiriyordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bölge kralı Hirodes, kendi kardeşinin karısı Hirodiyaʼyla evlenmişti. Yahya Hirodesʼin bu davranışını ve yaptığı daha nice kötülükleri yüzüne vuruyordu. ");
INSERT INTO turobt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hirodes işlediği diğer günahlara bir yenisini ekledi: Yahyaʼyı hapishaneye kapattı. ");
INSERT INTO turobt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bütün halk vaftiz olurken, İsa da vaftiz oldu. O dua ederken gök açıldı ");
INSERT INTO turobt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ve Kutsal Ruh bedenleşmiş şekilde, güvercin gibi İsaʼnın üzerine indi. Gökten bir ses duyuldu: “Sen benim sevgili Oğlumʼsun, senden memnunum.” ");
INSERT INTO turobt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","İsa görevine başladığı zaman, aşağı yukarı otuz yaşındaydı. İnsanlar Oʼnun Yusufʼun oğlu olduğunu sanıyorlardı. Yusuf da Eli oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mattat oğlu, Levi oğlu, Malki oğlu, Yannay oğlu, Yusuf oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mattitya oğlu, Amos oğlu, Nahum oğlu, Hesli oğlu, Nagay oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mahat oğlu, Mattitya oğlu, Şimi oğlu, Yosek oğlu, Yoda oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yohanan oğlu, Reşa oğlu, Zerubbabil oğlu, Şealtiyel oğlu, Neri oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Malki oğlu, Addi oğlu, Kosam oğlu, Elmadam oğlu, Er oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yeşu oğlu, Eliezer oğlu, Yorim oğlu, Mattat oğlu, Levi oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Şimon oğlu, Yahuda oğlu, Yusuf oğlu, Yonam oğlu, Elyakim oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Mala oğlu, Menna oğlu, Mattat oğlu, Natan oğlu, Davud oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","İşay oğlu, Oved oğlu, Boaz oğlu, Salmon oğlu, Nahşon oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadav oğlu, Ram oğlu, Hesron oğlu, Peres oğlu, Yahuda oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yakub oğlu, İshak oğlu, İbrahim oğlu, Terah oğlu, Nahor oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug oğlu, Reyu oğlu, Peleg oğlu, Eber oğlu, Şelah oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenan oğlu, Arpakşad oğlu, Sam oğlu, Nuh oğlu, Lemek oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metuşelah oğlu, Hanok oğlu, Yered oğlu, Mahalalel oğlu, Kenan oğlu, ");
INSERT INTO turobt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enoş oğlu, Şit oğlu, Adem oğlu, Allah Oğluʼydu. ");
INSERT INTO turobt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","İsa Kutsal Ruhʼla dolu olarak Şeria Irmağıʼndan ayrıldı, Ruhʼa uyarak ıssız yerleri dolaştı. ");
INSERT INTO turobt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","İblis İsaʼyı kırk gün, kırk gece günaha düşürmeye çalıştı. O sırada İsa hiçbir şey yemedi. Bu sebeple o günlerin sonunda acıktı. ");
INSERT INTO turobt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","İblis Oʼna şöyle dedi: “Eğer Allahʼın Oğluʼysan, emret, şu taş ekmek olsun.” ");
INSERT INTO turobt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","İsa ona şöyle cevap verdi: “Tevratʼta ‘İnsan sadece ekmekle yaşamaz’ diye yazılmıştır.” ");
INSERT INTO turobt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sonra İblis İsaʼyı yüksek bir yere götürdü. Oradan Oʼna dünyanın bütün ülkelerini bir anda gösterdi. ");
INSERT INTO turobt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","İblis İsaʼya, “Bak” dedi. “Bütün bu ülkelerin yönetimini ve servetini sana vereceğim. Çünkü bunlar bana teslim edildi. Ben de istediğim kişiye veririm. ");
INSERT INTO turobt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Önümde eğilip bana taparsan, hepsi senin olacak.” ");
INSERT INTO turobt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","İsa ona şu cevabı verdi: “Şöyle yazılmıştır: ‘Allahınız Rabbe tapının, yalnız Oʼna hizmet edin.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sonra İblis İsaʼyı Yeruşalimʼe götürdü. Tapınağın en yüksek yerine çıkardı ve Oʼna şöyle dedi: “Eğer Allahʼın Oğluʼysan, kendini buradan aşağı at. ");
INSERT INTO turobt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Çünkü şöyle yazılmıştır: ‘Allah seni korumaları için meleklerine buyruk verecek. ");
INSERT INTO turobt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ayağın taşa çarpmasın diye seni elleri üzerinde taşıyacaklar.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","İsa ona şu cevabı verdi: “ ‘Allahınız Rabbi denemeyin’ diye yazılmıştır.” ");
INSERT INTO turobt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","İblis İsaʼyı günaha düşürmek için her yolu denedikten sonra Oʼndan ayrıldı. Başka fırsat çıkana kadar Oʼnu rahat bıraktı. ");
INSERT INTO turobt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","İsa, Kutsal Ruhʼun gücüyle dolu olarak Celile bölgesine döndü. Oʼnun hakkındaki haber bütün bölgeye yayıldı. ");
INSERT INTO turobt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Celileʼdeki toplantı yerlerinde vaaz etti. Herkes de Oʼnu övdü. ");
INSERT INTO turobt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Böylece İsa büyüdüğü memleket olan Nasıraʼya geldi. Her zaman yaptığı gibi, Şabat gününde Yahudilerin toplantı yerine gitti. Toplanan halka Kutsal Yazılarʼdan okumak için ayağa kalktı. ");
INSERT INTO turobt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Oʼna Yeşaya peygamberin kitabı verildi. Kitabı açıp şu sözlerin yazılı olduğu yeri buldu: ");
INSERT INTO turobt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Rabbin Ruhu üzerimdedir: Bu sayede O beni meshetti. Öyle ki, Müjdeʼyi fakirlere duyurayım. Esirlere serbest bırakılacaklarını, körlere, göreceklerini bildirmem için beni göndermiştir. Öyle ki, ezilenleri özgürlüğe kavuşturayım ");
INSERT INTO turobt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ve Rabbin halkına lütuf göstereceği yılın geldiğini bildireyim.” ");
INSERT INTO turobt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sonra İsa kitabı kapadı, onu görevliye geri verdi ve oturdu. Toplantı yerinde herkes Oʼna dikkatle bakıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","O da onlara şöyle konuşmaya başladı: “Bugün dinlediğiniz bu Kutsal Yazı yerine gelmiştir.” ");
INSERT INTO turobt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Herkes İsa hakkında iyi konuşuyordu. Oʼnun ağzından çıkan lütufkâr sözlere hayran kaldılar. Birbirlerine, “Bu Yusufʼun oğlu değil mi?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","İsa da onlara şöyle dedi: “Herhalde bana şu atasözünü söyleyeceksiniz: ‘Ey doktor, önce kendini iyileştir.’ Kefernahumʼda neler yaptığını duyduk. Şimdi aynı şeyleri burada, kendi memleketinde de yap!” ");
INSERT INTO turobt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","İsa şöyle devam etti: “Size doğrusunu söylüyorum: hiçbir peygamber kendi memleketinde iyi karşılanmaz! ");
INSERT INTO turobt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Size gerçeği söylüyorum: İlyas zamanında gökyüzü üç yıl altı ay kapalı kalınca bütün ülkede korkunç bir kıtlık oldu. O günlerde İsrail halkında çok dul kadın vardı. ");
INSERT INTO turobt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yine de İlyas onların hiçbirine gönderilmedi. Yalnız Sayda bölgesindeki Sarfat kasabasında oturan dul bir kadına gönderildi. ");
INSERT INTO turobt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elişa Peygamber zamanında İsrail halkında birçok cüzzam hastası vardı. Ama Suriyeli Naamanʼdan başka onların hiçbiri hastalığından temiz kılınmadı.” ");
INSERT INTO turobt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bunu duyunca toplantı yerinde oturan herkes öfkeden kudurdu. ");
INSERT INTO turobt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kalkıp İsaʼyı kasabadan kovdular. Kasaba bir tepenin üzerinde kurulmuştu. İsaʼyı o tepenin ta yukarısına götürdüler. Oʼnu uçurumdan aşağı atmak istediler. ");
INSERT INTO turobt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama İsa onların ortasından geçip yoluna devam etti. ");
INSERT INTO turobt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sonra İsa Celileʼnin Kefernahum kasabasına indi. Şabat gününde oradakilere vaaz verdi. ");
INSERT INTO turobt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Onlar da İsaʼnın öğrettiklerine şaşırıp kaldılar. Çünkü İsa yetkiyle konuşuyordu. ");
INSERT INTO turobt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Toplantı yerinde cinli bir adam vardı. İçinde şeytani ruh bulunuyordu. Yüksek sesle bağırıp şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah, Nasıralı İsa! Bizden ne istiyorsun? Bizi yok etmeye mi geldin? Senin kim olduğunu biliyorum: sen Allahʼın Kutsal Mesihiʼsin!” ");
INSERT INTO turobt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","İsa cini azarladı. Ona, “Sus! Çık o adamdan!” dedi. Cin adamı herkesin gözü önünde yere yıktı. Sonra adama hiç zarar vermeden içinden çıktı. ");
INSERT INTO turobt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Herkes şaşırıp kaldı. Aralarında şöyle konuşmaya başladılar: “Bu nasıl sözdür? Güç ve yetkiyle şeytani ruhlara emrediyor, onlar da insanlardan çıkıyorlar!” ");
INSERT INTO turobt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Böylece İsa hakkındaki haber o bölgenin her tarafına yayıldı. ");
INSERT INTO turobt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","İsa kalkıp Yahudilerin toplantı yerinden çıktı ve Simunʼun evine gitti. Simunʼun kaynanası hastaydı. Yüksek ateşi vardı. Kadın için İsaʼdan yardım istediler. ");
INSERT INTO turobt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","İsa kadının başucunda durup ateşi azarladı. Kadının ateşi düştü ve hemen kalkıp onlara hizmet etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Güneş batarken insanlar çeşitli hastalıklara yakalanmış bütün yakınlarını İsaʼya getirdiler. İsa elleriyle her birine dokundu ve onları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aynı zamanda birçoklarından cinler çıktı. Yüksek sesle bağırıp, “Sen Allahʼın Oğluʼsun!” dediler. Fakat İsa onları azarlayıp konuşmalarına izin vermedi. Çünkü cinler Oʼnun Mesih olduğunu biliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gün doğunca İsa dışarı çıkıp ıssız bir yere gitti. Halk ise Oʼnu arıyordu. İsaʼnın bulunduğu yere varınca bir daha onlardan ayrılmamasını istediler. ");
INSERT INTO turobt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama İsa onlara şunu söyledi: “Allahʼın Krallığı hakkındaki Müjdeʼyi diğer kasabalara da duyurmam lazım. Çünkü ben bunun için gönderildim.” ");
INSERT INTO turobt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","İsa, Yahudi topraklarında olan toplantı yerlerinde vaaz etmeye devam etti. ");
INSERT INTO turobt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bir gün İsa Ginnesar Gölüʼnün kıyısında duruyordu. Halk Oʼnun etrafını sarmış, Allahʼın sözünü dinliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","İsa gölün kıyısında duran iki tekne gördü. Balıkçılar ise onlardan çıkmış ağlarını temizliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","İsa bu teknelerden birine bindi. Teknenin sahibi Simunʼa kıyıdan biraz açılmasını söyledi. Sonra oturup tekneden halka vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Konuşmasını bitirince Simunʼa dedi ki, “Derin sulara açıl. Balık tutmak için ağlarınızı atın.” ");
INSERT INTO turobt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simun şöyle cevap verdi: “Efendim, bütün gece çalışıp çabaladık, hiçbir şey yakalamadık. Ama madem sen söylüyorsun, ağları atacağım.” ");
INSERT INTO turobt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bunu yaptıktan sonra o kadar çok balık tuttular ki, ağları yırtılmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bu yüzden diğer teknedeki ortaklarına işaret ederek onları yardıma çağırdılar. Onlar da gelip her iki tekneyi de o kadar çok balıkla doldurdular ki neredeyse tekneler batacaktı. ");
INSERT INTO turobt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simun Petrus bunları görünce İsaʼnın dizlerine kapanarak şöyle dedi: “Ey Efendim, çekil yanımdan. Ben günahlı bir adamım.” ");
INSERT INTO turobt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Çünkü kendisi ve bütün arkadaşları ne kadar çok balık tuttuklarına şaşırıp kaldılar. ");
INSERT INTO turobt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simunʼun iş arkadaşları olan Zebedi oğulları Yakub ve Yuhanna da aynı şaşkınlık içindeydi. İsa Simunʼa şöyle dedi: “Korkma, artık balık tutacağına insanları imana getireceksin.” ");
INSERT INTO turobt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tekneleri karaya çekince, her şeyi bırakıp İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","İsa kasabalardan birindeyken, bedeni cüzzam hastalığıyla kaplanmış bir adam vardı. Adam İsaʼyı görünce yüzüstü yere kapandı ve İsaʼya şöyle yalvardı: “Ey Efendim! İstersen beni hastalığımdan temizleyebilirsin.” ");
INSERT INTO turobt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","İsa da elini uzatıp adama dokundu. “İstiyorum” dedi. “Temiz ol!” Anında adamın cüzzam hastalığı yok oldu. ");
INSERT INTO turobt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","İsa ona bu olayı kimseye anlatmamasını emretti. “Ancak git, rahibe görün” dedi. “Musaʼnın buyurduğu gibi, kendin için bir kurban sun. Böylece insanlara hastalıktan temizlendiğini gösterirsin.” ");
INSERT INTO turobt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Fakat İsa hakkındaki haber daha da çok yayıldı. Halk kalabalık halinde İsaʼya akın akın geliyordu. Çünkü Oʼnu dinlemek ve hastalıklarına şifa bulmak istiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","İsa ise, sık sık ıssız yerlere çekilir, dua ederdi. ");
INSERT INTO turobt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bir gün İsa vaaz ederken Ferisiler ve bazı Tevrat uzmanları Oʼnun çevresinde oturuyorlardı. Bunlar Celile ve Yahudiye bölgelerinin birçok köyünden ve Yeruşalimʼden gelmişlerdi. İsa, Rabbin gücüyle hastalara şifa veriyordu. ");
INSERT INTO turobt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bu sırada bazıları döşek üzerinde felçli bir adam taşıyordu. Onu içeri getirip İsaʼnın önüne bırakmaya çalışıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama kalabalık yüzünden onu içeri getirecek yol bulamadılar. Dama çıkıp, adamı kiremitlerin arasından döşek üzerinde, kalabalığın tam ortasına, İsaʼnın önüne indirdiler. ");
INSERT INTO turobt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","İsa onların imanını görünce felçli adama şöyle dedi: “Arkadaş, günahların bağışlandı.” ");
INSERT INTO turobt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tevrat uzmanları ve Ferisiler aralarında tartışmaya başladılar. “Kim bu adam?” dediler. “Allahʼa hakaret ediyor. Allahʼtan başka kim günahları bağışlayabilir?” ");
INSERT INTO turobt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ama İsa onların düşündüklerini biliyordu. Böylece onlara, “Aklınızda neden böyle düşüncelere yer veriyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Hangisi daha kolay? ‘Günahların bağışlandı’ demek mi, yoksa ‘Kalk, yürü’ demek mi? ");
INSERT INTO turobt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama İnsan Oğluʼnun yeryüzünde günahları bağışlama yetkisine sahip olduğunu bilesiniz diye…” Felçli adama, “Sana söylüyorum: ‘Kalk, döşeğini al ve evine git!’ ” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Adam da hemen herkesin gözü önünde ayağa kalktı. Döşeğini kaldırdı ve Allahʼı öve öve evine gitti. ");
INSERT INTO turobt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Herkesi bir şaşkınlık almıştı. Allahʼı övmeye başladılar. Büyük bir korkuya kapılıp, “Bugün olağanüstü şeyler gördük” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ondan sonra İsa dışarı çıktı. Levi adında bir vergi memuru gördü. Vergi toplanma yerinde oturuyordu. İsa ona, “Peşimden gel!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","O da kalktı, her şeyi bırakıp İsaʼnın peşinden gitti. ");
INSERT INTO turobt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sonra Levi kendi evinde İsa için büyük bir ziyafet verdi. Vergi memurları ve başka kişiler büyük bir kalabalık halinde gelmiş, onlarla beraber yemeğe oturmuşlardı. ");
INSERT INTO turobt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ama Ferisiler ve Tevrat uzmanları söylenmeye başladılar. İsaʼnın öğrencilerine şöyle dediler: “Nasıl olur da vergi memurları ve günahkârlarla birlikte yiyip içiyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","İsa onlara şöyle cevap verdi: “Sağlıklı insanların değil, hasta olanların doktora ihtiyacı var. ");
INSERT INTO turobt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ben doğru kişileri değil, günahkârları tövbeye çağırmaya geldim.” ");
INSERT INTO turobt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","İsaʼya şöyle dediler: “Yahyaʼnın öğrencileri sık sık oruç tutup dua ediyorlar. Ferisilerin öğrencileri de aynısını yapıyorlar. Ama seninkiler yiyip içiyorlar.” ");
INSERT INTO turobt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","İsa onlara şunları söyledi: “Damat onların arasındayken, siz damadın arkadaşlarına oruç tutturabilir misiniz? ");
INSERT INTO turobt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama öyle günler gelecek ki, damat aralarından alınacak. İşte o günlerde oruç tutacaklar.” ");
INSERT INTO turobt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ayrıca İsa onlara şu benzetmeyi anlattı: “Hiç kimse yeni elbiseden bir parça alıp eski elbisenin üzerine yama yapmaz. Yoksa hem yenisi yırtılır, hem de yeni elbiseden alınan parça eskisine uymaz. ");
INSERT INTO turobt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hiç kimse yeni şarabı eski tulumlara doldurmaz. Yoksa yeni şarap tulumları patlatır. Hem şarap dökülür, hem de tulumlar ziyan olur. ");
INSERT INTO turobt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ama yeni şarap yeni tulumlara doldurulmalı. ");
INSERT INTO turobt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Üstelik eski şarabı içtikten sonra kimse yeni şarabı istemez, ‘Eskisi daha iyi!’ der.” ");
INSERT INTO turobt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bir Şabat günü İsa ekin tarlalarından geçiyordu. Oʼnun öğrencileri ekin başaklarını koparıyor, avuçlarında ezip yiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ama Ferisilerden bazıları şunu sordular: “Neden Şabat gününde Tevratʼta yasaklananı yapıyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","İsa onlara şöyle cevap verdi: “Davud ve adamları acıkınca Davudʼun ne yaptığını okumadınız mı? ");
INSERT INTO turobt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Allahʼın evine girdi, adak ekmeklerinden alıp yedi ve yanındakilere de verdi. Oysa o ekmekleri yemeye sadece rahiplerin izni vardı.” ");
INSERT INTO turobt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","İsa onlara şunu da söyledi: “İnsan Oğlu olarak ben Şabat gününün efendisiyim.” ");
INSERT INTO turobt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Başka bir Şabat günü İsa, Yahudilerin bir toplantı yerine girip vaaz etmeye başladı. Orada sağ eli sakat bir adam vardı. ");
INSERT INTO turobt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tevrat uzmanları ve Ferisiler İsaʼyı yakından izliyorlardı. Oʼnun Şabat gününde şifa verip vermeyeceğini gözlüyorlardı. Böylece İsaʼyı suçlamak için fırsat arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama İsa akıllarından geçenleri biliyordu. Eli sakat adama, “Kalk, ortaya geç!” dedi. Adam da kalktı, ortaya geçti. ");
INSERT INTO turobt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","O zaman İsa onlara şunu dedi: “Size bir sorum var! Şabat gününde iyilik mi, yoksa kötülük mü yapmak Tevratʼa uygundur? Bir hayatı kurtarmak mı, yoksa onu yok etmek mi uygundur?” ");
INSERT INTO turobt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Etrafına dönüp herkese baktı. Sonra adama “Elini uzat!” dedi. Adam elini uzattı ve eli sapasağlam oldu. ");
INSERT INTO turobt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama Tevrat uzmanları ve Ferisiler öfkeden deliye döndüler. İsaʼya ne yapacaklarını aralarında konuşmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","O günlerde İsa dua etmek için bir tepeye çıktı. Bütün geceyi Allahʼa dua etmekle geçirdi. ");
INSERT INTO turobt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gün doğunca İsa öğrencilerini yanına çağırdı. Onların arasından “elçi” adını verdiği şu on iki kişiyi seçti: ");
INSERT INTO turobt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Petrus adını verdiği Simun ve onun kardeşi Andreas, Yakub ve Yuhanna, Filipus ve Bartalmay, ");
INSERT INTO turobt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta ve Tomas, Alpay oğlu Yakub ve lakabı “Yurtsever” olan Simun, ");
INSERT INTO turobt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakub oğlu Yahuda ve İsaʼya ihanet eden Yahuda İskariyot. ");
INSERT INTO turobt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","İsa onlarla birlikte aşağı inip düzlükte durdu. Öğrencileri büyük bir kalabalık halinde oradaydılar. Ayrıca bütün Yahudiyeʼden, Yeruşalimʼden, Sur ve Sayda şehirlerinin çevresindeki deniz kenarından çok sayıda insan vardı. ");
INSERT INTO turobt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","İsaʼyı dinlemeye ve hastalıklarından şifa bulmaya gelmişlerdi. Şeytani ruhlar yüzünden sıkıntı çekenler de iyileşiyordu. ");
INSERT INTO turobt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bütün kalabalık İsaʼya dokunmaya çalışıyordu. Çünkü Oʼndan güç akıyor ve herkese şifa veriyordu. ");
INSERT INTO turobt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","İsa başını kaldırıp öğrencilerine bakarak şöyle konuşmaya başladı: “Ne mutlu size, fakirler! Çünkü Allahʼın Krallığı sizindir. ");
INSERT INTO turobt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ne mutlu size, şimdi açlık çekenler! Çünkü doyacaksınız. Ne mutlu size, şimdi ağlayanlar! Çünkü yüzünüz gülecek. ");
INSERT INTO turobt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","İnsan Oğluʼna bağlı olduğunuz için insanlar sizden nefret ettikleri, sizi aralarından kovup aşağıladıkları ve adınızı kötüledikleri zaman, ne mutlu size! ");
INSERT INTO turobt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","O gün sevinin, sevinçten zıplayın, çünkü gökte ödülünüz büyük olacak. Bilin ki, size kötü davrananların ataları peygamberlere aynısını yaptılar. ");
INSERT INTO turobt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama vay halinize, siz zenginler! Çünkü daha şimdiden rahata kavuştunuz. ");
INSERT INTO turobt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Vay halinize, şimdi karnı tok olanlar! Çünkü açlık çekeceksiniz. Vay halinize, şimdi yüzü gülenler! Çünkü yas tutup ağlayacaksınız. ");
INSERT INTO turobt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Herkes sizi övdüğü zaman vay halinize! Çünkü ataları, sahte peygamberlere de aynısını yaptılar.” ");
INSERT INTO turobt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ama, beni dinleyen sizlere söylüyorum, düşmanlarınızı sevin! Sizden nefret edenlere iyilik yapın. ");
INSERT INTO turobt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Size lanet edenler için bereket dileyin. Size hakaret edenler için dua edin. ");
INSERT INTO turobt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bir yanağınıza şamar atana öbür yanağınızı da çevirin. Paltonuzu zorla alan kişiye gömleğinizi de verin. ");
INSERT INTO turobt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sizden bir şey dileyen herkese verin. Biri malınızı almışsa, geri istemeyin. ");
INSERT INTO turobt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","İnsanların size nasıl davranmasını istiyorsanız, siz de onlara öyle davranın. ");
INSERT INTO turobt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Eğer sadece sizi sevenleri severseniz, bu size ne övgü kazandırır? Günahkârlar bile kendilerini sevenleri sever. ");
INSERT INTO turobt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Eğer sadece size iyilik yapanlara iyilik yaparsanız, bu size ne övgü kazandırır? Günahkârlar bile aynısını yaparlar. ");
INSERT INTO turobt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Eğer sadece geri almayı umut ettiğiniz kişilere ödünç verirseniz, bu size ne övgü kazandırır? Günahkârlar da verdiklerini geri almak şartıyla diğer günahkârlara ödünç verirler. ");
INSERT INTO turobt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama siz düşmanlarınızı sevin, iyilik yapın, hiçbir şey beklemeden ödünç verin. O zaman ödülünüz büyük olacak. O zaman yüce Allahʼın oğulları olacaksınız. Çünkü O da nankör ve kötü kişilere iyilik eder. ");
INSERT INTO turobt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Babanız nasıl merhametliyse, siz de merhametli olun.” ");
INSERT INTO turobt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Başkasını yargılamayın ki siz de yargılanmayasınız. Suçlu çıkarmayın ki siz de suçlu çıkarılmayasınız. Bağışlayın ki siz de bağışlanasınız. ");
INSERT INTO turobt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Verin, size de verilecek. Sizin kucağınıza sıkı bastırılmış, güzelce silkelenmiş, dolup taşan bol bir ölçüyle dökecekler. Çünkü hangi ölçekle ölçerseniz, aynı ölçekle size de ölçülecek.” ");
INSERT INTO turobt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bir de onlara şu benzetmeyi anlattı: “Kör adam başka bir kör adama yol gösterebilir mi? İkisi de çukura düşmez mi? ");
INSERT INTO turobt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Öğrenciöğretmeninden üstün değildir. Ama eğitimini tamamlayan herkes öğretmeni gibi olur. ");
INSERT INTO turobt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Neden başkasının gözündeki çöpü görüyorsun da, kendi gözündeki kütüğü görmüyorsun? ");
INSERT INTO turobt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kendi gözündeki kütüğü görmüyorsan, kardeşine nasıl ‘Kardeş, izin ver, gözündeki çöpü çıkarayım’ diyebilirsin? Seni ikiyüzlü seni! Önce kendi gözündeki kütüğü çıkar. O zaman daha iyi görür ve kardeşinin gözündeki çöpü çıkarabilirsin.” ");
INSERT INTO turobt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kötü meyve veren iyi ağaç da, iyi meyve veren kötü ağaç da yoktur. ");
INSERT INTO turobt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Çünkü her ağaç kendi meyvesinden tanınır. İnsanlar dikenlerden incir, çalılardan da üzüm toplamazlar. ");
INSERT INTO turobt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","İyi insan iyilik dolu kalbinden iyi olanı çıkarır. Kötü insan da kötülük dolu kalbinden kötü olanı çıkarır. İnsanın kalbinde ne varsa, ağzından da o çıkar.” ");
INSERT INTO turobt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Neden beni ‘Efendimiz, Efendimiz!’ diye çağırıyorsunuz, ama size söylediğim şeyleri yapmıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bana gelen, sözlerimi işiten ve onları hayatında yerine getiren herkesin nasıl bir kişiye benzediğini size anlatayım. ");
INSERT INTO turobt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Böyle kişi ev yapan biri gibidir. Derin kazıp kaya üstüne temel atar. Sel basınca ve kabaran sular o eve çarpınca, onu yerinden oynatamaz, çünkü ev sağlam yapılmıştır. ");
INSERT INTO turobt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Öte yandan sözlerimi dinleyip de yerine getirmeyen kişi, temel atmadan toprak üzerinde ev yapana benzer. Kabaran sular o eve çarpınca ev hemen yıkılır. Evin yıkılışı da korkunç olur.” ");
INSERT INTO turobt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","İsa kendisini dinleyen halka bütün bunları söyledikten sonra Kefernahumʼa gitti. ");
INSERT INTO turobt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Orada Romalı bir yüzbaşı vardı. Onun çok değer verdiği bir kölesi ölüm döşeğinde hasta yatıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yüzbaşı, İsa hakkındaki haberleri duyunca, Yahudi liderlerden birkaçını Oʼnun yanına yolladı. Onlara İsaʼdan şunu rica etmelerini söyledi: “Lütfen gel ve kölemi iyileştir.” ");
INSERT INTO turobt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","İsaʼnın yanına geldikten sonra yüzbaşına yardım etmesi için Oʼna içtenlikle yalvardılar: “Bu adam senin yardımına layıktır. ");
INSERT INTO turobt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Çünkü milletimizi seviyor. Toplantı yerimizi de yaptıran odur.” ");
INSERT INTO turobt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Böylece İsa onlarla birlikte yola çıktı. Eve varmadan önce, yüzbaşı bazı arkadaşlarını yollayıp İsaʼya şu haberi gönderdi: “Efendimiz, zahmet etme. Evime kadar gelmene layık değilim. ");
INSERT INTO turobt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Zaten bunun için yanına gelmeye yüzüm olmadı. Ama sen bir söz söyle ki hizmetkârım iyileşsin. ");
INSERT INTO turobt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Çünkü ben de buyruk altında bir adamım. Benim de buyruğumda askerlerim var. Birisine ‘Git’ derim, gider. Başkasına ‘Gel’ derim, gelir. Köleme de ‘Şunu yap’ derim, yapar.” ");
INSERT INTO turobt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","İsa bu sözleri duyunca, yüzbaşıya hayret etti. Dönüp Oʼnu izleyen kalabalığa şöyle dedi: “Size doğrusunu söylüyorum: İsrail halkında bile bu kadar büyük imana rastlamadım.” ");
INSERT INTO turobt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gönderilen adamlar eve dönünce, köleyi sapasağlam buldular. ");
INSERT INTO turobt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bu olaydan kısa bir zaman sonra İsa Nain adında bir kasabaya gitti. Öğrencileri ve büyük bir kalabalık Oʼnunla beraber yürüyordu. ");
INSERT INTO turobt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","İsa kasaba kapısına tam yaklaştığı sırada bir adamın cenazesi kaldırılıyordu. Ölen adam dul bir kadının tek oğluydu. Kasabadan büyük bir kalabalık kadınla gelmişti. ");
INSERT INTO turobt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Rab İsa kadını görünce ona acıdı. “Ağlama!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yaklaşıp açık tabuta dokundu. Tabutu taşıyanlar durdu. İsa şöyle dedi: “Delikanlı, sana diyorum, kalk.” ");
INSERT INTO turobt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ölü doğrulup oturdu ve konuşmaya başladı. İsa onu annesine geri verdi. ");
INSERT INTO turobt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Herkesi bir korku sardı. “Aramızda büyük bir peygamber ortaya çıktı” ve “Allah halkına yardıma geldi” diyerek Allahʼı övmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","İsa hakkındaki bu haber bütün Yahudiye bölgesine ve çevreye yayıldı. ");
INSERT INTO turobt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Yahyaʼnın öğrencileri ona bütün bu olayları anlattılar. Yahya da öğrencilerinden ikisini yanına çağırıp onları Rab İsaʼya yolladı. Şunu sormalarını istedi: “Gelecek olan Mesih sen misin, yoksa başkasını mı bekleyelim?” ");
INSERT INTO turobt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Adamlar İsaʼya gelip şöyle dediler: “Vaftizci Yahya bizi sana yolladı. ‘Gelecek olan Mesih sen misin, yoksa başkasını mı bekleyelim?’ diye soruyor.” ");
INSERT INTO turobt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","İsa tam o sırada acı çeken, hasta ve cinlere tutulmuş birçok kişiyi iyileştirdi. Birçok körün gözlerini de açtı. ");
INSERT INTO turobt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","İsa Yahyaʼnın öğrencilerine şöyle cevap verdi: “Gidin, gördüğünüzü, işittiğinizi Yahyaʼya anlatın: Körlerin gözleri açılıyor, sakatlar yürüyor, cüzzam hastaları temiz kılınıyor, sağırlar işitiyor, ölüler diriliyor ve fakirlere Müjde duyuruluyor. ");
INSERT INTO turobt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Benim hakkımda şüpheye düşmeyene ne mutlu!” ");
INSERT INTO turobt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yahyaʼnın gönderdiği haberciler ayrıldıktan sonra, İsa halka dönüp Yahya hakkında konuşmaya başladı: “Issız yerlere ne görmeye gittiniz? Rüzgarda sallanan bir kamış mı? ");
INSERT INTO turobt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Söyleyin, ne görmeye gittiniz? Lüks elbiseler giyen bir adam mı? Bakın, gösterişli elbiseler giyen, bolluk içinde yaşayan adamlar saraylarda oturanlardır. ");
INSERT INTO turobt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Öyleyse ne görmeye gittiniz? Bir peygamber mi? Evet! Ama ben size diyorum ki, Yahya peygamberden de üstündür. ");
INSERT INTO turobt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kutsal Yazılarʼda Allah Yahya hakkında şöyle der: ‘İşte, habercimi senin önünden gönderiyorum. O, önden gidip senin yolunu hazırlayacak.’ ");
INSERT INTO turobt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Size diyorum ki, kadından doğanların arasında Yahyaʼdan daha üstün kimse yoktur. Ama Allahʼın Krallığıʼnda en önemsiz kişi Yahyaʼdan üstündür.” ");
INSERT INTO turobt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bütün halk, hatta vergi memurları bile bunu duyunca Allahʼın yolunun doğru yol olduğunu kabul ettiler. Çünkü Yahya tarafından vaftiz edilmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Ferisiler ve Tevrat uzmanları Allahʼın kendileri için olan amacını reddettiler. Çünkü Yahya tarafından vaftiz edilmemişlerdi. ");
INSERT INTO turobt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","İsa sözlerine şöyle devam etti: “Bu kuşağın insanlarını neye benzeteyim, onlar neye benziyorlar? ");
INSERT INTO turobt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Çarşıda oturan çocuklara benziyorlar. Birbirlerine şöyle bağırıyorlar: ‘Size kaval çaldık, oynamadınız. Cenaze ezgileri söyledik, ağlamadınız.’ ");
INSERT INTO turobt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Çünkü Vaftizci Yahya geldiği zaman, ekmek yemedi, şarap da içmedi. O zaman dediniz ki, ‘Adamda cin var.’ ");
INSERT INTO turobt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","İnsan Oğlu geldiğinde, yiyip içti. Bu sefer, ‘Bakın, ne biçim adam bu!’ diyorsunuz. ‘Boğazına düşkün ve içkici, vergi memurlarının ve günahkârların arkadaşı!’ ");
INSERT INTO turobt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Oysa hikmet bütün evlatları tarafından haklı çıkarılmıştır.” ");
INSERT INTO turobt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferisilerden biri İsaʼyı yemeğe çağırdı. İsa da Ferisiʼnin evine girip sofraya oturdu. ");
INSERT INTO turobt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Birden bir kadın göründü. O kasabada günahkâr olarak bilinen kadın İsaʼnın Ferisiʼnin evinde oturduğunu öğrenmişti. Kaymaktaşından yapılmış bir kapta hoş kokulu yağ getirdi. ");
INSERT INTO turobt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kadın arkada İsaʼnın ayaklarının dibinde durdu ve ağladı. Oʼnun ayaklarını gözyaşları ile ıslattı, saçları ile kuruttu. Sonra da ayaklarını öpüp üzerlerine hoş kokulu yağı sürdü. ");
INSERT INTO turobt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","İsaʼyı davet eden Ferisi bunu görünce, kendi kendine şöyle dedi: “Bu adam peygamber olsaydı, Oʼna dokunan kadının kim olduğunu ve ne tür bir kadın olduğunu bilirdi. Günahkâr biri olduğunu anlardı.” ");
INSERT INTO turobt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","İsa ona şöyle karşılık verdi: “Simun, sana bir söyleyeceğim var.” O da, “Söyle, Öğretmenim” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Bir faizcinin iki borçlusu varmış. Birinin borcu beş yüz gümüş para, öbürünün borcu elli gümüş paraymış. ");
INSERT INTO turobt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","İkisi de aldıkları parayı geri ödeyememiş. Bu sebeple adam her ikisinin de borcunu bağışlamış. Acaba onlardan hangisi o adamı daha çok sever?” ");
INSERT INTO turobt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simun şöyle cevap verdi: “Sanırım, daha çok bağışlanan adam.” İsa, “Doğru karar verdin” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sonra kadına dönerek Simunʼa şöyle dedi: “Bu kadını görüyor musun? Ben senin evine geldiğimde, ayaklarım için su vermedin. Ama bu kadın ayaklarımı gözyaşlarıyla ıslattı, saçlarıyla kuruttu. ");
INSERT INTO turobt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bana öpücük vermedin. Ama bu kadın evine girdiğimden beri durmadan ayaklarımı öpüyor. ");
INSERT INTO turobt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sen başıma zeytinyağı sürmedin. Ama bu kadın ayaklarıma hoş kokulu yağ sürdü. ");
INSERT INTO turobt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bu nedenle sana söylüyorum, onun çok olan günahları bağışlandı. Onun için çok sevdi. Oysa az bağışlanan kişi az sever.” ");
INSERT INTO turobt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sonra İsa kadına şöyle dedi: “Günahların bağışlandı.” ");
INSERT INTO turobt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","İsaʼyla birlikte sofrada oturanlar aralarında konuşmaya başladılar. “Bu adam kim ki, günahları bile bağışlıyor?” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bunun üzerine İsa kadına dedi: “İmanın seni kurtardı. Git ve esenlik içinde yaşa!” ");
INSERT INTO turobt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bundan kısa bir süre sonra İsa köy kasaba dolaşmaya başladı. Halka vaaz edip Allahʼın Krallığı hakkındaki Müjdeʼyi duyuruyordu. On iki elçisi de Oʼnunla birlikteydi. ");
INSERT INTO turobt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ayrıca yanında cinlerden ve hastalıklardan kurtulmuş bazı kadınlar da vardı. Onlardan biri Mecdelli Meryemʼdi. Kendisinden yedi cin kovulmuştu. ");
INSERT INTO turobt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kral Hirodesʼin saray yöneticisi olan Kuzaʼnın karısı Yohanna, Suzanna, ve başka birçok kadın da İsaʼyla birlikteydi. Kendi paralarından İsaʼnın ve öğrencilerinin geçimine yardım ediyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","İsa değişik kasabalardan yanına gelen büyük bir kalabalığa şu benzetmeyi anlattı: ");
INSERT INTO turobt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bir çiftçi ekin ekmeye gitmiş. Ekerken kimi tohumlar yol kenarına düşmüş. Ayak altında çiğnenmiş ve gökteki kuşlar onları yemiş. ");
INSERT INTO turobt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kimi tohumlar taşlı toprağa düşmüş. Tohumlar filiz vermişse de susuzluktan kuruyup gitmiş. ");
INSERT INTO turobt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kimi tohumlar dikenlerin arasına düşmüş. Dikenler de filizlerle beraber büyüyünce filizleri boğmuş. ");
INSERT INTO turobt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kimi tohumlar ise bereketli toprağa düşmüş. Büyüyüp yüz kat daha fazla ürün vermiş.” İsa bunları anlattıktan sonra yüksek sesle şöyle dedi: “Kulağı olan işitsin!” ");
INSERT INTO turobt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Öğrencileri İsaʼya, “Acaba bu benzetme ne anlama geliyor?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O da onlara şöyle dedi: “Sizlere Allahʼın Krallığıʼnınsırlarını anlama gücü verildi. Ama başkalarına benzetmelerle anlatıyorum. Öyle ki, ‘Bakıp da görmesinler, işitip de anlamasınlar.’ ");
INSERT INTO turobt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Benzetmenin anlamı şöyledir: Tohum, Allahʼın sözüdür. ");
INSERT INTO turobt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yol kenarındakiler sözü duyanlardır. Ama sonra İblis gelip Allahʼın sözünü onların yüreklerinden çalar. Öyle ki, iman edip kurtulmasınlar. ");
INSERT INTO turobt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Taşlı topraktakiler sözü duyunca onu sevinçle kabul edenlerdir. Ama bunların derin kökleri yoktur. Sadece bir zaman için iman ederler, sonra zorluklarla denendikleri zaman imandan dönerler. ");
INSERT INTO turobt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dikenler arasına düşenler sözü duyarlar ama zamanla bu hayatın kaygıları, zenginliği ve zevkleri onları boğar. Bu yüzden olgun ürün vermezler. ");
INSERT INTO turobt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ama bereketli topraktakiler sözü dürüst ve iyi yürekle duyanlardır. Bu kişiler söze sarılarak sabırla dayanır ve bol ürün verirler.” ");
INSERT INTO turobt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hiç kimse lambayı yakıp onu bir kapla örtmez, ya da yatağın altına koymaz. Hayır, onu lambalığa koyar, öyle ki, içeri girenler ışığı görsünler. ");
INSERT INTO turobt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Çünkü gizli olup da ortaya çıkmayacak hiçbir şey yoktur. Bilinmeyecek ve aydınlığa çıkmayacak saklı bir şey de yoktur. ");
INSERT INTO turobt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bunun için nasıl dinlediğinize dikkat edin. Çünkü kim sahip olduğu şeyleri kullanırsa, ona daha çok verilecek. Ama kim kullanmazsa, kendisinde var sandığı şey bile elinden alınacak.” ");
INSERT INTO turobt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sonra İsaʼnın annesiyle kardeşleri Oʼnu ziyaret etmeye geldiler. Fakat kalabalık olduğu için Oʼnun yanına yaklaşamadılar. ");
INSERT INTO turobt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","İnsanlar İsaʼya şu haberi verdiler. “Annen ve kardeşlerin dışarda, seni görmek istiyorlar.” ");
INSERT INTO turobt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ama İsa onlara şöyle cevap verdi: “Annem ve kardeşlerim, Allahʼın sözünü duyup yerine getirenlerdir.” ");
INSERT INTO turobt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","O günlerde İsa ve öğrencileri tekneye bindiler. İsa onlara “Gölün öbür tarafına geçelim” dedi. Böylece göle açıldılar. ");
INSERT INTO turobt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Onlar teknede giderken, İsa uykuya daldı. O sırada gölde bir fırtına koptu. Tekne suyla dolmaya başladı. Batma tehlikesindeydiler. ");
INSERT INTO turobt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Öğrencileri gelip İsaʼyı uyandırdılar. “Efendimiz, Efendimiz, boğuluyoruz!” dediler. İsa kalkıp rüzgarı ve kabaran dalgaları azarladı. Fırtına durdu, ortalık sakinleşti. ");
INSERT INTO turobt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","İsa onlara, “İmanınız nerede?” diye sordu. Onlar da korktular. Şaşkınlık içinde birbirlerine şöyle dediler: “Bu nasıl bir adam ki, rüzgara ve suya emrediyor, onlar da Oʼnun buyruğuna uyuyor?” ");
INSERT INTO turobt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tekneyle Gerasalılarʼın memleketine vardılar. Orası Celileʼnin karşı tarafındadır. ");
INSERT INTO turobt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Karaya çıktıktan sonra, İsaʼyı kasabadan bir adam karşıladı. Adam cinlere tutulmuş, uzun zamandan beri hiç elbise giymemişti. Evde değil, mezarlık mağaralarda yaşıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","İsaʼyı görünce, adam bağırıp önünde yere kapandı ve yüksek sesle şöyle dedi: “Benden ne istiyorsun, ey İsa, yüce Allahʼın Oğlu? Yalvarırım, bana işkence etme!” ");
INSERT INTO turobt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Çünkü İsa şeytani ruha adamdan çıkmasını emretmişti. Şeytani ruh adamı sık sık yakalardı. İnsanlar adamın ellerini ve ayaklarını zincirlerle bağlayıp başında nöbet tutarlardı. Ama adam bağlarını hep koparırdı. Cin tarafından ıssız yerlere sürüklenirdi. ");
INSERT INTO turobt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","İsa ona, “Adın ne?” diye sordu. O da “Ordu” dedi, çünkü adama birçok cin girmişti. ");
INSERT INTO turobt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cinler, dipsiz çukura gitmelerini emretmesin diye, İsaʼya yalvarıp durdular. ");
INSERT INTO turobt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Orada, tepelerde otlayan büyük bir domuz sürüsü vardı. Cinler domuzlara girmelerine izin vermesi için İsaʼya yalvardılar. O da onlara izin verdi. ");
INSERT INTO turobt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cinler o adamdan çıkıp, domuzların içine girdiler. Sürü dik yamaçtan aşağı koştu ve göle atlayıp boğuldu. ");
INSERT INTO turobt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Domuzları otlatanlar olup bitenleri görünce kaçtılar. Haberi kasabada ve köylerde duyurdular. ");
INSERT INTO turobt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Böylece halk olup biteni görmeye çıktı. İsaʼnın yanına varınca, içinden cinler çıkmış adamı gördüler. Adam giyinmiş, aklı başına gelmiş olarak İsaʼnın ayaklarının dibinde oturuyordu. O zaman korktular. ");
INSERT INTO turobt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Olayı görenler cinli adamın nasıl kurtulduğunu diğerlerine anlattılar. ");
INSERT INTO turobt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa çevresinin bütün halkı İsaʼnın oradan ayrılmasını istedi. Çünkü büyük korkuya kapılmışlardı. Böylece İsa, geri dönmek için tekneye bindi. ");
INSERT INTO turobt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","İçinden cinler çıkmış adam, İsaʼnın yanında kalmak için Oʼna yalvardı. Ama İsa onu geri gönderdi. ");
INSERT INTO turobt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Evine dön” dedi. “Allahʼın senin için neler yaptığını anlat.” Adam da ayrılıp İsaʼnın onun için neler yaptığını kasabanın her tarafında duyurdu. ");
INSERT INTO turobt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","İsa gölün karşı tarafına dönünce, halk Oʼnu karşıladı. Çünkü herkes Oʼnu bekliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Derken Yair adında bir adam geldi. Kendisi Yahudilerin toplantı yerinde liderdi. İsaʼnın ayaklarına kapanıp evine gelmesi için yalvardı. ");
INSERT INTO turobt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Çünkü on iki yaşlarındaki biricik kızı ölmek üzereydi. İsa Yairʼin evine giderken halk Oʼnu her taraftan sıkıştırıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Orada on iki yıldan beri kanaması olan bir kadın vardı. Bütün parasını doktorlara harcamıştı ama hiç kimse onu iyileştirememişti. ");
INSERT INTO turobt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Arkadan yaklaşıp İsaʼnın elbisesinin kenarına dokundu. Kanaması hemen kesildi. ");
INSERT INTO turobt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","İsa, “Bana dokunan kim?” diye sordu. Herkes inkâr ederken Petrus, “Efendimiz” dedi. “Kalabalık her tarafını sarmış, seni sıkıştırıyor.” ");
INSERT INTO turobt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama İsa şöyle dedi: “Birisi bana dokundu. Benden bir gücün çıktığını fark ettim.” ");
INSERT INTO turobt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kadın olup biteni saklayamayacağını anlayınca, titreye titreye ortaya çıkıp İsaʼnın önünde yere kapandı. Bütün halkın karşısında İsaʼya neden dokunduğunu ve nasıl o anda şifa bulduğunu anlattı. ");
INSERT INTO turobt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","İsa ona şöyle dedi: “Kızım, imanın seni kurtardı. Esenlikle git.” ");
INSERT INTO turobt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","İsa henüz konuşurken, toplantı yeri liderinin evinden biri gelip ona şöyle dedi: “Kızın öldü. Artık öğretmeni rahatsız etme.” ");
INSERT INTO turobt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","İsa bunu duyunca Yairʼe, “Korkma!” dedi. “Yalnız iman et ve kızın kurtulacak.” ");
INSERT INTO turobt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","İsa Yairʼin evine gelince Petrus, Yuhanna, Yakub ve kızın anne ve babasından başka hiç kimsenin içeri girmesine izin vermedi. ");
INSERT INTO turobt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Herkes kızın arkasından ağlıyor, göğsünü dövüyordu. İsa da şöyle dedi: “Ağlamayı kesin! Kız ölmedi, sadece uyuyor.” ");
INSERT INTO turobt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","İsaʼyla alay ettiler, çünkü kızın öldüğünü biliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama İsa kızın elini tuttu ve sesini yükseltip, “Kalk kızım!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kızın ruhu döndü ve kız hemen ayağa kalktı. İsa ona yemek verilmesini buyurdu. ");
INSERT INTO turobt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kızın annesiyle babası şaşırıp kaldılar. Ama İsa olup biteni kimseye anlatmasınlar diye onları uyardı. ");
INSERT INTO turobt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","İsa on iki elçisini bir araya çağırdıktan sonra onlara bütün cinlerin üzerine ve hastalıkları iyileştirmek için güç ve yetki verdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Onları Allahʼın Krallığıʼnı duyurmaya ve hastalara şifa vermeye gönderdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Giderlerken şöyle dedi: “Yol için yanınıza hiçbir şey almayın. Ne değnek, ne torba, ne ekmek, ne para, ne de yedek gömlek! ");
INSERT INTO turobt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hangi eve girerseniz hep orada kalın. Sonra oradan ayrılıp yolunuza devam edin. ");
INSERT INTO turobt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gittiğiniz yerde sizi kabul etmeyenler olursa, o kasabadan ayrılırken onlara karşı şahitlik olsun diye ayaklarınızdan tozu silkin.” ");
INSERT INTO turobt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Onlar da ayrılıp köy köy dolaşmaya başladılar. Müjdeʼyi her tarafta yayıp hastalara şifa verdiler. ");
INSERT INTO turobt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Celile bölgesini yöneten Hirodes, bütün olup bitenleri duyunca aklı karıştı. Çünkü bazı insanlar diyordu ki, “Yahya ölümden dirildi.” ");
INSERT INTO turobt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bazıları da, “İlyas göründü”, başkaları ise, “Eski peygamberlerden biri yeniden yaşama döndü” diyordu. ");
INSERT INTO turobt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hirodes, “Yahyaʼnın kafasını ben kestirdim. O zaman hakkında böyle şeyler duyduğum bu adam kimdir?” dedi ve İsaʼyı görmenin bir yolunu aradı. ");
INSERT INTO turobt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Elçiler dönünce, bütün yaptıklarını İsaʼya anlattılar. İsa elçileri yanına alıp Beytsayda denilen kasabanın yakınlarına çekildi. Orada onlarla baş başa kalmak istedi. ");
INSERT INTO turobt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bunun farkına varan halk İsaʼyı izledi. İsa halkı hoş karşıladı. Onlara Allahʼın Krallığı hakkında vaaz verdi ve şifaya muhtaç olanları iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Akşama doğru on iki elçi gelip İsaʼya şunu söyledi: “Halkı gönder de etraftaki köylere ve çiftliklere gitsin. Kendilerine kalacak yer ve yiyecek bulsunlar. Çünkü burada ıssız bir yerdeyiz.” ");
INSERT INTO turobt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","İsa onlara şöyle dedi: “Onlara siz yiyecek verin!” Öğrenciler şu cevabı verdiler: “Beş ekmekle iki balıktan başka bir şeyimiz yok. Yoksa biz gidip bütün bu insanlar için yiyecek mi satın alalım?” ");
INSERT INTO turobt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Çünkü orada yalnız erkeklerden aşağı yukarı beş bin kişi vardı. İsa öğrencilerine şunu söyledi: “Onları ellişer kişilik gruplar halinde oturtun.” ");
INSERT INTO turobt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Öyle yaptılar, herkesi oturttular. ");
INSERT INTO turobt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","İsa, beş ekmekle iki balığı aldı, gözlerini göğe kaldırarak şükretti. Sonra ekmekleri bölüp halkın önüne koysunlar diye öğrencilerine verdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Herkes doyana kadar yedi. Sonra artakalan parçaları topladılar ve onlarla on iki sepet doldurdular. ");
INSERT INTO turobt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bir gün İsa halktan ayrı olarak dua ediyordu. Öğrencileri yanındaydı. İsa, “Halk benim kim olduğumu söylüyor?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Öğrenciler şöyle cevap verdiler: “ ‘Vaftizci Yahya’ diyorlar. Başkaları ‘İlyas’ diyor, diğerleri de ‘Eski peygamberlerden biri dirildi’ diyorlar.” ");
INSERT INTO turobt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","İsa onlara sordu: “Ya siz ne dersiniz? Sizce ben kimim?” Petrusʼun cevabı şuydu: “Sen Allahʼın Mesihiʼsin.” ");
INSERT INTO turobt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","İsa onları sıkı sıkı uyardı, “Bunu kimseye söylemeyin!” diye emretti. ");
INSERT INTO turobt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“İnsan Oğluʼnun çok acı çekmesi lazım” dedi. “Halkın liderleri, başrahipler ve Tevrat uzmanları tarafından reddedilip öldürülmelidir. Ama üçüncü gün ölümden dirilmesi gerekir.” ");
INSERT INTO turobt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sonra İsa herkese şunu söyledi: “Bir kişi peşimden gelmek isterse, kendini gözden çıkarsın, her gün çarmıhını yüklensin ve yolumu tutsun. ");
INSERT INTO turobt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Çünkü her kim canını kurtarmak isterse, onu kaybedecek. Ama her kim canını benim uğruma kaybederse, onu kurtaracak. ");
INSERT INTO turobt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Çünkü bir kişi bütün dünyayı kazanırsa, ama kendisini mahvedip canını kaybederse, ona ne fayda olur? ");
INSERT INTO turobt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Çünkü her kim benden ve sözlerimden utanırsa, İnsan Oğlu da, geldiğinde, ondan utanacak. İnsan Oğlu kendi görkemi, Babaʼnın görkemi ve kutsal meleklerin görkemiyle gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Size doğrusunu söylüyorum: burada duran bazı kişiler Allahʼın Krallığıʼnı görmeden ölümü tatmayacaklar.” ");
INSERT INTO turobt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bunu söyledikten aşağı yukarı sekiz gün sonra, İsa, Petrusʼu, Yuhannaʼyı ve Yakubʼu yanına aldı ve dua etmek için bir dağa çıktı. ");
INSERT INTO turobt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","İsa dua ederken, yüzünün görünüşü değişti. Elbiseleri de şimşek gibi bir beyazlıkla parladı. ");
INSERT INTO turobt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","O anda iki adam İsaʼyla konuşmaya başladı. Bunlar Musa ve İlyasʼtı. ");
INSERT INTO turobt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Görünüşleri görkemliydi. İsaʼnın yakında Yeruşalimʼde ölüp dirildikten sonra dünyadan nasıl ayrılacağını konuşuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus ve onunla beraber olanları ağır bir uyku bastı. Ama uyandıklarında İsaʼnın görkemini ve Oʼnunla beraber duran iki adamı gördüler. ");
INSERT INTO turobt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa ve İlyas İsaʼdan ayrılırken Petrus İsaʼya şöyle dedi: “Efendimiz, iyi ki buradayız. Üç çardak kuralım: biri senin için, biri Musa için, biri de İlyas için!” Aslında ne dediğinin farkında değildi. ");
INSERT INTO turobt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus daha konuşurken, bir bulut görünüp onların üstüne gölge yapmaya başladı. Buluta girince öğrenciler korktular. ");
INSERT INTO turobt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sonra buluttan gelen bir ses şöyle dedi: “Bu benim Oğlumʼdur, Seçilmiş Olanʼdır. Oʼnu dinleyin!” ");
INSERT INTO turobt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","O ses kesildiğinde İsa tek başınaydı. Üç öğrenci bu olayı kendilerine sakladı. O günlerde kimseye gördüklerini anlatmadılar. ");
INSERT INTO turobt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ertesi gün İsaʼyla üç öğrencisi dağdan indiler. Büyük bir kalabalık İsaʼyı karşılamaya geldi. ");
INSERT INTO turobt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Derken kalabalıktan bir adam yüksek sesle şöyle dedi: “Öğretmenim, yalvarırım sana, oğluma bak, çünkü o benim tek evladım. ");
INSERT INTO turobt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Durum şu: şeytani bir ruh oğlumu yakalıyor ve birden bağırmaya başlıyor. Şeytani ruh onu ağzından köpükler çıkana kadar sarsıyor. Oğlumu yara bere içinde bıraktıktan sonra ondan zorlukla ayrılıyor. ");
INSERT INTO turobt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Şeytani ruhu kovsunlar diye, senin öğrencilerine yalvardım, ama beceremediler.” ");
INSERT INTO turobt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","İsa cevap olarak şöyle dedi: “Ey imansız ve yoldan sapmış kuşak! Ne zamana kadar sizinle beraber olacağım? Ne zamana kadar size katlanacağım? Oğlunu buraya getir!” ");
INSERT INTO turobt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Çocuk gelirken, cin onu yere yıkıp sarstı. Ama İsa şeytani ruhu azarladı, çocuğu iyileştirdi ve babasına geri verdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Herkes Allahʼın yüce kudretine şaşırıp kaldı. Herkes İsaʼnın yaptığı bütün şeylere hayret ediyordu. Bu arada İsa öğrencilerine şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Şu sözleri siz aklınızdan çıkarmayın: İnsan Oğlu yakın bir zamanda insanların eline teslim edilecek.” ");
INSERT INTO turobt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama öğrenciler İsaʼnın bu sözle ne demek istediğini anlamadılar. Hem de anlamasınlar diye bu onlardan gizlendi. Bu söz hakkında İsaʼya soru sormaktan bile korktular. ");
INSERT INTO turobt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","İsaʼnın öğrencileri aralarında kimin en önemli olduğunu tartışmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","İsa yüreklerindeki düşünceleri bildiği için, bir çocuğu kendi yanına çekti. ");
INSERT INTO turobt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Onlara şöyle dedi: “Her kim bu çocuğu benim adıma kabul ederse, beni kabul etmiş olur. Beni kabul eden de, beni Gönderenʼi kabul etmiş olur. Çünkü aranızda en önemsiz kim ise, en önemli odur.” ");
INSERT INTO turobt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhanna şöyle cevap verdi: “Efendimiz, senin adınla cinler kovan bir kişi gördük. Ona engel olmaya çalıştık, çünkü bizden biri değildi.” ");
INSERT INTO turobt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","İsa ona şöyle dedi: “Ona engel olmayın. Kim size karşı değilse, sizden yanadır.” ");
INSERT INTO turobt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","İsaʼnın göğe alınacağı zaman yaklaşmıştı. O da Yeruşalimʼe gitmeye kesin karar verdi. ");
INSERT INTO turobt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","İsa kendi önünden haberciler gönderdi. Onlar da gidip, İsa için hazırlık yapmak üzere, bir Samiriye köyüne girdiler. ");
INSERT INTO turobt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama oradaki halk İsaʼyı kabul etmedi, çünkü Yeruşalimʼe doğru gidiyordu. ");
INSERT INTO turobt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Öğrencilerinden Yakub ve Yuhanna bunu görünce şöyle dediler: “Efendimiz, bir emirle gökten ateş yağdırıp bu insanları yok etmemizi ister misin?” ");
INSERT INTO turobt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ama İsa dönüp onları azarladı. ");
INSERT INTO turobt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sonra başka bir köye gittiler. ");
INSERT INTO turobt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Onlar yolda giderlerken birisi İsaʼya şöyle dedi: “Sen nereye gidersen peşinden geleceğim.” ");
INSERT INTO turobt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","İsa ona şöyle karşılık verdi: “Tilkilerin yatacak yerleri var, gökteki kuşların da yuvaları var. Ama İnsan Oğluʼnun başını koyacak yeri yok.” ");
INSERT INTO turobt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bir başkasına da, “Peşimden gel!” dedi. O da “Efendim, izin ver de önce gidip babamı gömeyim” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","İsa ona şöyle dedi: “Bırak, ölüler kendi ölülerini gömsünler. Ama sen git, Allahʼın Krallığıʼnı duyur.” ");
INSERT INTO turobt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bir başkası ise, “Efendimiz, senin peşinden geleceğim,” dedi. “Ama izin ver de önce gideyim, evdekilerle vedalaşayım.” ");
INSERT INTO turobt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","İsa ona şöyle cevap verdi: “Sabanı tutup tarlayı sürmeye başladıktan sonra geriye bakan kişi Allahʼın Krallığıʼna layık değildir.” ");
INSERT INTO turobt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bundan sonra Rab İsa yetmiş kişiyi daha görevlendirdi. Kendisinin gideceği her kasabaya, her yere onları ikişer ikişer önden gönderdi ");
INSERT INTO turobt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Onlara şöyle dedi: “Toplanacak ekin bol, ama işçi az. Onun için ekin Sahibiʼne yalvarın ki, ekinleri biçmeye işçi göndersin. ");
INSERT INTO turobt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gidin! İşte, ben sizi kuzular gibi kurtların arasına yolluyorum. ");
INSERT INTO turobt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yanınıza kese, torba ya da ayaklarınıza yedek sandalet almayın. Yoldayken de kimseyle selamlaşmayın. ");
INSERT INTO turobt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hangi eve girerseniz ilk önce, ‘Bu eve esenlik olsun!’ deyin. ");
INSERT INTO turobt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","O evde bir esenlik adamı varsa, dilediğiniz esenlik onun üzerinde duracak. Ama yoksa, tekrar size dönecek. ");
INSERT INTO turobt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","O evde misafir olun. Size ne verirlerse onu yiyip için. Çünkü işçi ücretini hak eder. O evden ayrılıp başka evlerde misafir olmayın. ");
INSERT INTO turobt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bir kasabaya girdiğiniz zaman, insanlar sizi kabul ederlerse, önünüze ne koyarlarsa onu yiyin. ");
INSERT INTO turobt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","O kasabadaki hastaları iyileştirin, halka, ‘Allahʼın Krallığı size yaklaştı’ deyin. ");
INSERT INTO turobt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama bir kasabaya girdiğiniz zaman oradakiler sizi kabul etmezlerse, kasabanın sokaklarına çıkın ve şöyle deyin: ");
INSERT INTO turobt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kasabanızdan ayaklarımıza yapışan tozu bile size karşı silkip atıyoruz. Ama şundan emin olun: Allahʼın Krallığı yaklaştı.’ ");
INSERT INTO turobt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ben size şunu söylüyorum: Dünyanın yargılanacağı günde Sodom o kasabadan daha hafif bir ceza alacak. ");
INSERT INTO turobt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Vay senin haline, ey Horazin kasabası! Vay senin haline, ey Beytsayda kasabası! Çünkü sizde yapılan mucizeler Sur ve Sayda şehirlerinde yapılmış olsaydı, onlar çoktan tövbe edip pişman olduklarını göstermek için çuval bezini kuşanarak kül içinde oturacaklardı. ");
INSERT INTO turobt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ama dünyanın yargılanacağı günde Sur ve Sayda sizden daha hafif bir ceza alacak. ");
INSERT INTO turobt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya sen, ey Kefernahum! Göğe kadar mı yükseleceksin? Hayır, ölüler dünyasına batacaksın.” ");
INSERT INTO turobt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","İsa öğrencilerine şöyle dedi: “Kim sizin sözünüzü dinlerse, benim sözümü dinlemiş olur. Kim sizi reddederse, beni reddetmiş olur. Beni reddeden de beni Gönderenʼi reddetmiş olur.” ");
INSERT INTO turobt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yetmişler sevinç içinde döndüler. İsaʼya şöyle dediler: “Ey Efendimiz, senin adını kullandığımızda cinler bile buyruğumuza uyuyorlar.” ");
INSERT INTO turobt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","O da onlara şöyle cevap verdi: “Şeytanʼın bir yıldırım gibi gökten düştüğünü gördüm. ");
INSERT INTO turobt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","İşte ben size, yılanları, akrepleri ve düşmanın bütün gücünü ezmeye yetki verdim. Hiçbir şey size zarar vermeyecek. ");
INSERT INTO turobt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yine de cinlerin buyruğunuza uyduğuna sevinmeyin, ama adlarınızın gökte yazılı olduğuna sevinin.” ");
INSERT INTO turobt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","O anda İsa, Kutsal Ruhʼla coşarak şöyle dedi: “Sana şükrediyorum, ey Baba, göğün ve yerin Efendisi, çünkü bu konuları bilgili ve akıllı kişilerden gizli tuttun, ve basit insanlara açıkladın. Evet, Baba, çünkü seni memnun eden budur. ");
INSERT INTO turobt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Babam her şeyi bana emanet etti. Oğulʼun kim olduğunu Babaʼdan başka hiç kimse bilmez. Babaʼnın kim olduğunu da Oğulʼdan ve Oğulʼun Oʼnu tanıtmak istediği kişilerden başkası bilmez.” ");
INSERT INTO turobt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","İsa öğrencilerine dönüp onlara özel olarak şunları söyledi: “Ne mutlu o gözlere ki, sizin gördüklerinizi görüyorlar. ");
INSERT INTO turobt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Size şunu söylüyorum: Birçok peygamber ve kral, sizin gördüklerinizi görmek istedi, ama görmedi. Duyduklarınızı duymak istedi, ama duymadı.” ");
INSERT INTO turobt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bir Tevrat uzmanı ayağa kalktı. İsaʼyı denemek amacıyla, “Öğretmen” dedi. “Sonsuz yaşama kavuşmak için ne yapmalıyım?” ");
INSERT INTO turobt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","İsa ona şöyle karşılık verdi: “Tevratʼta ne yazılmıştır? Orada ne okuyorsun?” ");
INSERT INTO turobt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Adam şöyle cevap verdi: “ ‘Allahınız Rabbi bütün yüreğinizle, bütün canınızla, bütün gücünüzle ve bütün aklınızla sevin.’ ‘Komşunuzu da kendinizi sevdiğiniz gibi sevin.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","İsa ona, “Doğru cevap verdin” dedi. “Bunu yap ve yaşayacaksın.” ");
INSERT INTO turobt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama adam kendini haklı çıkarmak isteyerek İsaʼya şunu sordu: “Peki, komşum kim?” ");
INSERT INTO turobt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","İsa ona şöyle cevap verdi: “Adamın biri Yeruşalimʼden Erihaʼya inerken haydutların eline düşmüş. Onu soymuşlar, dövmüşler, ölü gibi ortada bırakıp gitmişler. ");
INSERT INTO turobt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tesadüfen bir rahip o yoldan gidiyormuş. Adamı görünce yolun öbür tarafından geçmiş. ");
INSERT INTO turobt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aynen bunun gibi bir Levili o yere gelmiş, adamı görmüş ve yolun öbür tarafından geçmiş. ");
INSERT INTO turobt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yolculuk yapan bir Samiriyeli ise adamın bulunduğu yere gelmiş. Adamı görünce ona acımış. ");
INSERT INTO turobt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yanına gidip yaralarına zeytinyağı ve şarap dökmüş, yaralarını sarmış. Sonra kendi hayvanına bindirip adamı bir hana götürmüş. Ona orada bakmış. ");
INSERT INTO turobt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ertesi gün ayrılırken iki gümüş para çıkarıp hancıya vermiş ve ona şöyle demiş: ‘Adama iyi bak. Verdiğim paradan daha fazla harcarsan, dönüşte onu sana öderim.’ ");
INSERT INTO turobt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sence bu üç kişiden hangisi haydutların eline düşen adama komşu gibi davrandı?” ");
INSERT INTO turobt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tevrat uzmanı, “Adama merhamet gösteren” dedi. O zaman İsa ona, “Sen de git, aynısını yap” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","İsa öğrencileriyle yolculuk yaparken bir köye girdi. Marta adında bir kadın Oʼnu kendi evinde misafir etti. ");
INSERT INTO turobt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martaʼnın Meryem adında bir kız kardeşi vardı. Rab İsaʼnın ayaklarının dibinde oturmuş, Oʼnun anlattıklarını dinliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ise, bir sürü işle uğraşıp duruyordu. Onun için dikkati dağılmıştı. İsaʼnın yanına dikilip şöyle dedi: “Efendimiz, kız kardeşim bütün işleri bana bıraktı. Buna hiç aldırmıyor musun? Söyle de, bana yardım etsin.” ");
INSERT INTO turobt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Rab İsa ona şöyle cevap verdi: “Marta, Marta, sen birçok şey için kaygı çekip, telaşa düşüyorsun. ");
INSERT INTO turobt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama sadece bir şey gereklidir. Meryem iyi olanı seçti, ve bu ondan alınmayacak.” ");
INSERT INTO turobt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bir gün İsa bir yerde dua ediyordu. Duasını bitirdikten sonra, öğrencilerinden biri Oʼna şöyle dedi: “Efendimiz, Yahya kendi öğrencilerine nasıl dua edeceklerini öğretti. Sen de bize dua etmeyi öğret.” ");
INSERT INTO turobt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","İsa onlara dedi: “Dua ederken, şöyle deyin: ‘Baba, adın kutsal olsun. Krallığın gelsin. ");
INSERT INTO turobt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Her gün bize gündelik ekmeğimizi ver. ");
INSERT INTO turobt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Günahlarımızı bağışla, çünkü biz de bize karşı suç işleyen herkesi bağışlıyoruz. Bizi doğru yoldan saptıracak bir duruma düşürme.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sonra onlara şöyle dedi: “Sizlerden birinin bir arkadaşı var diyelim. Gece yarısı ona gidiyorsunuz, ve, ‘Arkadaş, bana üç ekmek ödünç ver’ diyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Çünkü bir arkadaşım yolculuktan geldi ve onun önüne koyacak bir şeyim yok.’ ");
INSERT INTO turobt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Diyelim ki arkadaşınız da içerden şöyle cevap veriyor: ‘Beni rahatsız etme. Kapı kilitli, çocuklarım yanımda yataktalar. Artık kalkıp sana bir şey veremem.’ ");
INSERT INTO turobt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Size söylüyorum, arkadaşınız olduğu için ilk başta kalkıp ekmek vermese bile, durmadan istediğiniz için kalkıp size ne lazımsa verir. ");
INSERT INTO turobt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bu sebeple size diyorum ki: dileyin, size verilecek. Arayın, bulacaksınız. Kapıyı çalın, size açılacak. ");
INSERT INTO turobt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Çünkü her dileyen alır, arayan bulur ve kapıyı çalana kapı açılır. ");
INSERT INTO turobt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aranızda hangi baba, ekmek isteyen oğluna taş verir? Ya da balık isterse balık yerine yılan verir? ");
INSERT INTO turobt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ya da yumurta isterse ona akrep verir? ");
INSERT INTO turobt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kötü olan sizler bile çocuklarınıza iyi hediyeler vermeyi biliyorsunuz. Öyleyse gökteki Babaʼnın kendisinden dileyenlere Kutsal Ruhʼu vereceği çok daha kesin.” ");
INSERT INTO turobt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bir gün İsa bir adamdan cin kovuyordu. Cin yüzünden adam konuşamıyordu. Cin çıkınca, dilsiz adam konuşmaya başladı. Halk da şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama bazıları şöyle dedi: “Cinleri cinlerin lideri Baalzevulʼun gücüyle kovuyor.” ");
INSERT INTO turobt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Başkaları ise İsaʼyı denemeye çalıştılar. Onlara gökten mucizevi bir işaret göstermesini istediler. ");
INSERT INTO turobt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama İsa onların düşüncelerini bildiği için şöyle dedi: “İçinden bölünmüş olan her krallık yıkılır. İçinden bölünmüş hane dağılır. ");
INSERT INTO turobt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Şeytan da kendisine karşı bölünmüşse, onun krallığı nasıl ayakta durur? Çünkü size göre, ben cinleri Baalzevulʼun gücüyle kovuyorum. ");
INSERT INTO turobt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Peki, ben cinleri Baalzevulʼun gücüyle kovuyorsam, o zaman sizin adamlarınız onları kimin gücüyle kovuyorlar? Bu durumda kendi adamlarınız sizi yargılayacak. ");
INSERT INTO turobt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama eğer ben cinleri Allahʼın parmağıyla kovuyorsam, o zaman Allahʼın Krallığı aranıza gelmiş demektir. ");
INSERT INTO turobt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Güçlü ve silahlı bir adam kendi evini kolladığı sürece, malları güvenlik içindedir. ");
INSERT INTO turobt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama daha güçlü biri saldırıp onu yenerse, o zaman adamın güvendiği silahları alıp götürür. Yağmaladığı malları da yanındakilerle bölüşür. ");
INSERT INTO turobt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Benimle birlikte olmayan bana karşıdır. Benimle birlikte toplamayan, dağıtıyor demektir. ");
INSERT INTO turobt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Şeytani ruh insandan çıkınca, susuz yerleri gezip rahat edeceği bir yer arar. Onu bulmayınca şöyle der: ‘Çıktığım eve geri döneceğim.’ ");
INSERT INTO turobt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dönünce de evi süpürülmüş ve toplanmış bulur. ");
INSERT INTO turobt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","O vakit gidip kendisinden daha kötü olan yedi cin alır. Sonra eve geri dönüp onlarla oraya yerleşir. Böylece adamın son hali, önceki halinden beter olur.” ");
INSERT INTO turobt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","İsa bunu anlatırken, kalabalıktan bir kadın sesini yükseltip, “Ne mutlu seni taşıyan ana karnına, ne mutlu seni emziren memelere!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Oysa İsa şöyle cevap verdi: “Aksine, Allahʼın sözünü işitip de yerine getirenlere ne mutlu!” ");
INSERT INTO turobt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kalabalık çoğalınca İsa konuşmaya başladı. “Bu kuşak kötü bir kuşaktır” dedi. “Mucizevi bir işaret istiyor, ama onlara Peygamber Yunusʼun işaretinden başka bir işaret gösterilmeyecek. ");
INSERT INTO turobt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Çünkü Yunus nasıl Ninova halkına bir işaret olmuşsa, İnsan Oğlu da bu kuşağa bir işaret olacak. ");
INSERT INTO turobt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Güneyden gelen kraliçe dünyanın yargılanacağı günde bu kuşağın insanlarıyla birlikte kalkacak ve onları suçlu çıkaracak. Çünkü kraliçe, Süleymanʼın hikmetli sözlerini işitmek için dünyanın öbür ucundan geldi. Ama bakın, burada Süleymanʼdan daha üstün olan bulunuyor. ");
INSERT INTO turobt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninova halkı, dünyanın yargılanacağı günde bu kuşağın insanlarıyla birlikte ayağa kalkacak ve onları suçlu çıkaracak. Çünkü onlar Yunusʼun vaaz etmesi üzerine tövbe ettiler. Ama bakın burada Yunusʼtan daha üstün olan bulunuyor.” ");
INSERT INTO turobt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hiç kimse lamba yakıp onu saklamaz, bir kabın altına da koymaz. Ama içeri girenler ışığı görebilsinler diye, onu lambalığa koyarlar. ");
INSERT INTO turobt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bedenin ışığı gözdür. Gözünüz sağlam olursa, bütün bedeniniz aydınlık olur. Ama gözünüz hasta olursa, bütün bedeniniz karanlık olur. ");
INSERT INTO turobt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bu yüzden, dikkat edin ki, içinizdeki aydınlık karanlık olmasın. ");
INSERT INTO turobt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Diyelim ki bütün bedeniniz aydınlık içindedir ve orada hiç karanlık yoktur. O zaman bir lambanın sizi ışığıyla aydınlattığı gibi, bedeniniz de tamamen aydınlanmış olur.” ");
INSERT INTO turobt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","İsa sözünü bitirdikten sonra, bir Ferisi Oʼnu yemeğe davet etti. O da gidip sofraya oturdu. ");
INSERT INTO turobt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","İsa yemekten önce ellerini din adetine göre yıkamamıştı. Ferisi bunu görünce şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Rab İsa ona şöyle dedi: “Bakın şimdi, siz Ferisiler bardağın ve tabağın dış tarafını temizliyorsunuz. Ama içiniz açgözlülük ve kötülükle doludur. ");
INSERT INTO turobt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ey akılsızlar! Dışı yapan, içi de yapmadı mı? ");
INSERT INTO turobt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sahip olduklarınızla fakirlere yardım edin, o zaman sizin için her şey temiz olur. ");
INSERT INTO turobt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Vay halinize, ey Ferisiler! Çünkü siz nanenin, sedefotunun ve bahçedeki her türlü bitkinin ondalığını veriyorsunuz, ama adalete ve Allah sevgisine önem vermiyorsunuz. Ondalık vermeyi unutmadan esas bunları yerine getirmeniz lazım. ");
INSERT INTO turobt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Vay halinize, ey Ferisiler! Çünkü siz toplantı yerlerinde en saygın yerde oturmayı seviyorsunuz. Çarşılarda selam almaya bayılıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vay halinize! Siz insanların fark etmeden üzerinden geçtikleri isimsiz mezarlara benziyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tevrat uzmanlarından biri İsaʼya cevap verip şöyle dedi: “Öğretmenim, bunu derken, bize de hakaret etmiş oluyorsun.” ");
INSERT INTO turobt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","İsa da şunu dedi: “Vay sizin de halinize, ey Tevrat uzmanları! Çünkü taşınması zor olan yükleri insanlara yüklüyorsunuz. Ama kendiniz o yükleri taşımalarına yardım etmek için tek bir parmağınızı bile oynatmıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vay halinize! Peygamberlere anıt dikiyorsunuz, ama onları öldürenler atalarınızdır! ");
INSERT INTO turobt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Böylece atalarınızın yaptıklarına şahitlik ediyorsunuz. Yaptıkları için onları kutlamış oluyorsunuz. Çünkü onlar peygamberleri öldürdüler, siz de anıt dikiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bunun için Allah hikmeti hakkınızda şöyle diyor: ‘Onlara peygamberler ve elçiler göndereceğim. Onların bazılarını öldürecekler, bazılarına da eziyet edecekler.’ ");
INSERT INTO turobt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Öyle ki, dünyanın yaradılışından bu yana ne kadar peygamberin kanı dökülmüşse, bu kuşaktan sorulsun, ");
INSERT INTO turobt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Habilʼin kanından tut, kurban yeri ile tapınağın arasındaki yerde öldürülen Zekeriyaʼnın kanına kadar. Evet, size diyorum, onların kanından bu kuşak sorumlu tutulacak. ");
INSERT INTO turobt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Vay halinize, ey Tevrat uzmanları! Çünkü bilgi kapısının anahtarını alıp götürdünüz. Bu kapıdan hem kendiniz girmediniz, hem de girmeye hazır olanlara engel oldunuz.” ");
INSERT INTO turobt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","İsa oradan ayrılınca, Tevrat uzmanları ve Ferisiler Oʼna düşman kesilmeye başladılar. Birçok konu hakkında onun ağzını aradılar. ");
INSERT INTO turobt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","İsaʼya karşı düzen kurdular. Oʼnu kendi sözleriyle tuzağa düşürmek için fırsat kolluyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bu arada binlerce insan toplandı. Kalabalıktan neredeyse birbirlerini ezeceklerdi. İsa önce öğrencileriyle konuşmaya başladı. “Ferisilerin mayasından, yani ikiyüzlülükten sakının” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Açığa çıkarılmayacak üstü kapalı bir şey yoktur. Gizli olan her şey bilinecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bunun için karanlıkta söylediğiniz her şey, aydınlıkta anlatılacak, ve kapalı kapılar ardında kulağa fısıldadıklarınız çatılardan duyurulacak.” ");
INSERT INTO turobt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Arkadaşlar, size diyorum ki bedeni öldüren ama ondan başka zarar veremeyenlerden korkmayın. ");
INSERT INTO turobt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Esas kimden korkmanız gerektiğini size söylüyorum. Sizi öldürüp cehenneme atma yetkisi olan Allahʼtan korkun. Evet, size diyorum ki, Oʼndan korkun. ");
INSERT INTO turobt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Beş serçe kuşu iki bakır paraya satılmıyor mu? Fakat Allah o serçelerin hiçbirini unutmaz. ");
INSERT INTO turobt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bakın, saçınızın her teli bile sayılmıştır. Korkmayın, siz birçok serçeden daha değerlisiniz. ");
INSERT INTO turobt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Size diyorum ki, her kim beni insanların önünde açıkça kabul ederse, İnsan Oğlu da onu Allahʼın melekleri önünde açıkça kabul edecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama kim beni insanların önünde reddederse, o kişi Allahʼın meleklerinin önünde de reddedilecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","İnsan Oğluʼna karşı bir söz söyleyen herkes bağışlanacak. Ama Kutsal Ruhʼa hakaret eden kişi bağışlanmayacak. ");
INSERT INTO turobt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sizi toplantı yerlerindeki toplulukların, halk liderlerinin ve yetkililerin önüne çıkardıkları zaman, hiç kaygılanmayın. ‘Kendimizi nasıl savunacağız?’ ya da ‘Ne diyeceğiz?’ diye hiç düşünmeyin. ");
INSERT INTO turobt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Çünkü Kutsal Ruh size o saatte ne söylemeniz lazım olduğunu öğretecek.” ");
INSERT INTO turobt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kalabalıktan biri gelip İsaʼya, “Öğretmenim, kardeşime söyle de, aile mirasını benimle paylaşsın” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","İsa ona şöyle cevap verdi: “Ey adam! Kim beni üzerinize yargıç ya da miras dağıtıcısı yaptı?” ");
INSERT INTO turobt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sonra herkese şunu söyledi: “Dikkat edin, kendinizi her türlü açgözlülükten kollayın. Çünkü insanın yaşamı mallarının bolluğuna bağlı değildir.” ");
INSERT INTO turobt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sonra İsa onlara bir benzetme anlattı. “Zengin bir adamın toprağı bol ürün vermiş. ");
INSERT INTO turobt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kendi kendine düşünmüş: ‘Ne yapacağım? Ürünümü saklayacak yerim yok!’ ");
INSERT INTO turobt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sonra, ‘Evet’ demiş. ‘Ne yapacağımı biliyorum: ambarlarımı yıkıp daha büyüklerini yapacağım. Bütün buğdayımı ve mallarımı orada saklayacağım. ");
INSERT INTO turobt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sonra şöyle diyeceğim, ey canım, şimdi yıllarca yetecek kadar malların var, rahatına bak, ye, iç, hayatın tadını çıkar.’ ");
INSERT INTO turobt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama Allah ona şöyle demiş: ‘Ey akılsız adam! Bu gece canın senden istenecek. O zaman biriktirdiğin şeyler kimin olacak?’ ");
INSERT INTO turobt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kendisine mal biriktiren ama Allahʼın istediği gibi zengin olmayan kişinin durumu budur.” ");
INSERT INTO turobt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sonra İsa öğrencilerine şunu söyledi: “Bu yüzden size derim ki, ne yiyeceğiz diye canınızı sıkmayın. Ne giyeceğiz diye de bedeniniz için kaygılanmayın. ");
INSERT INTO turobt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Çünkü can yiyecekten, beden de giyecekten daha önemlidir. ");
INSERT INTO turobt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kargaları düşünün! Ne ekerler, ne de biçerler. Ne kilerleri vardır, ne de ambarları. Yine de Allah onları besler. Siz kuşlardan çok daha değerlisiniz. ");
INSERT INTO turobt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hangi biriniz kaygılanarak ömrünü tek bir saat uzatabilir? ");
INSERT INTO turobt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Madem siz bu kadar küçük bir şey bile yapamıyorsanız, niçin öbür şeyler için kaygılanıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kırdaki çiçekleri düşünün, nasıl büyürler! Ne iş yaparlar, ne de dikiş dikerler. Fakat size şunu söylüyorum: Kral Süleyman gösterişli hayat yaşadı. Ama o bile, bu çiçeklerden biri kadar güzel giyinmemişti. ");
INSERT INTO turobt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Otlar bir gün çayırda büyür, ertesi gün fırına atılır. Ey siz imanı az olanlar! Allah otları bile öyle giydiriyorsa, mutlaka sizi de giydirecek, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yiyeceğimizi ve içeceğimizi nasıl sağlayacağız diye düşünüp endişelenmeyin. ");
INSERT INTO turobt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Çünkü dünyanın bütün milletleri hep böyle şeylerin peşindeler. Fakat göksel Babanız bunlara muhtaç olduğunuzu biliyor. ");
INSERT INTO turobt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sizler ise Allahʼın Krallığıʼna önem verin. O zaman size bu şeyler de verilecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Korkmayın, ey küçük sürü. Çünkü göksel Babanız sizi krallığına kavuşturmayı uygun gördü. ");
INSERT INTO turobt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mallarınızı satın, parasını fakirlere verin. Eskimeyen keseler alın. Gökte hiç eksilmeyen bir servet toplayın. Oraya hırsız giremez, böcek de yiyip bitiremez. ");
INSERT INTO turobt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Çünkü servetiniz neredeyse, yüreğiniz de orada olacak. ");
INSERT INTO turobt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kemerleriniz bellerinizde bağlı olsun, lambalarınız ise yanar olsun. ");
INSERT INTO turobt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Düğünden eve dönecek olan efendilerini bekleyen adamlar gibi olun. Efendileri gelip kapıyı çaldığında, ona kapıyı hemen açarlar. ");
INSERT INTO turobt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Efendileri geldiğinde uyanık bulduğu hizmetkârlara ne mutlu. Size doğrusunu söylüyorum: O efendi beline önlük takıp onları sofraya oturtacak ve gelip onlara hizmet edecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Efendi ister gece yarısı, ister daha geç vakitte gelsin, uyanık bulacağı kölelere ne mutlu! ");
INSERT INTO turobt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ama şunu bilin: Eğer ev sahibi hırsızın hangi saatte geleceğini bilseydi, evinin soyulmasına izin vermezdi. ");
INSERT INTO turobt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Siz de hazır olun. Çünkü İnsan Oğlu beklemediğiniz saatte gelecek.” ");
INSERT INTO turobt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus şöyle sordu: “Efendimiz, bu benzetmeyi sadece bize mi, yoksa herkese mi anlatıyorsun?” ");
INSERT INTO turobt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rab İsa da şöyle dedi: “Sadık ve akıllı yönetici kimdir ki efendisi onu ev halkının başına getirir, yiyeceklerini zamanında vermesini buyurur? ");
INSERT INTO turobt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Efendisinin eve döndüğünde işinin başında bulacağı o köleye ne mutlu! ");
INSERT INTO turobt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Size doğrusunu söylüyorum: efendisi bu köleyi sahip olduğu bütün malın ve mülkün başına koyacak. ");
INSERT INTO turobt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama diyelim ki, o köle içinden, ‘Efendimin gelmesine daha çok vakit var,’ der. Bunun üzerine öbür erkek ve kadın hizmetkârları dövüp, yemeye, içmeye ve sarhoş olmaya başlar. ");
INSERT INTO turobt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","O zaman efendisi, kölenin hiç beklemediği bir gün, hiç bilmediği bir saatte gelecek. Onu şiddetle cezalandıracak, sadık olmayan kişilerle bir tutacak. ");
INSERT INTO turobt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Efendisinin isteğini bilip de hazırlık yapmayan ve onun istediğini yerine getirmeyen köle çok dayak yiyecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Fakat bir köle efendisinin isteğini bilmeden dayağı hak eden şeyler yapmışsa, o zaman az dayak yiyecek. Kime çok şey verilmişse, ondan çok istenecek. Kime çok şey emanet edilmişse, ondan daha fazlası istenecek.” ");
INSERT INTO turobt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ben dünyaya ateş yağdırmaya geldim. Keşke o ateş daha şimdiden alevlenmiş olsaydı. ");
INSERT INTO turobt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Suya vaftiz edilen bir insan gibi acılara batırılıp çıkarılmam lazım. Bu iş tamamlanıncaya kadar nasıl da sıkıntı içindeyim. ");
INSERT INTO turobt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ne sanıyorsunuz, dünyaya barış mı getirmeye geldim? Hayır, aslında ayrılık getirmeye geldim. ");
INSERT INTO turobt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Çünkü bundan sonra beş kişilik bir hane, ikiye karşı üç ve üçe karşı iki olarak bölünecek. ");
INSERT INTO turobt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baba oğluna, oğul da babasına karşı gelecek. Kız annesine ve anne kızına karşı gelecek. Kaynana geline, gelin de kaynanasına karşı gelecek.” ");
INSERT INTO turobt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","İsa halka şunu da söyledi: “Batıdan bir bulutun yükseldiğini görünce, hemen ‘Yağmur geliyor’ dersiniz, ve yağmur yağmaya başlar. ");
INSERT INTO turobt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Rüzgarın güneyden estiğini görünce, hemen ‘Sıcak bir gün olacak’ dersiniz, ve öyle olur. ");
INSERT INTO turobt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sizi ikiyüzlüler sizi! Yeryüzünün ve gökyüzünün görünüşünden ne güzel anlam çıkarabiliyorsunuz! Ama niçin şimdiki zamanda olup bitenlerden bir anlam çıkaramıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Neden neyin doğru olduğuna kendi kendinize karar vermiyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Meselâ senden davacı olan kişiyle sorgu yargıcına giderken, yolda davacıyla anlaşmaya bak. Yoksa o seni yargıcın önüne sürükleyecek ve yargıç seni gardiyanın eline teslim edecek, o da seni hapishaneye atacak. ");
INSERT INTO turobt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sana şunu söylüyorum: borcunu son kuruşuna kadar ödemeden oradan çıkamazsın.” ");
INSERT INTO turobt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","O sırada bazı kişiler İsaʼya geldi. Oʼna vali Pilatusʼun kurban kesen bazı Celilelileri öldürdüğünü anlattılar. Adamların kanları kestikleri kurbanların kanıyla karışmıştı. ");
INSERT INTO turobt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","İsa onlara şöyle dedi: “Sizce bu Celileliler diğer Celilelilerden daha mı günahkârdı? Onun için mi bu kadar çok acı çektiler? ");
INSERT INTO turobt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Size hayır diyorum, ama tövbe etmezseniz hepiniz de onlar gibi yok olacaksınız. ");
INSERT INTO turobt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya Şiloahʼdaki kulenin üzerlerine düşüp öldürdüğü on sekiz kişi için ne diyelim? Sizce onlar Yeruşalimʼde oturan öbür insanlardan daha mı günahkârdı? ");
INSERT INTO turobt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Size hayır diyorum, ama tövbe etmezseniz hepiniz de onlar gibi yok olacaksınız.” ");
INSERT INTO turobt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Onlara şu benzetmeyi de anlattı: “Adamın birinin bağında dikili bir incir ağacı varmış. Adam ağaçta meyve aramaya gelmiş, ama bulmamış. ");
INSERT INTO turobt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bağcıya şöyle demiş: ‘Üç senedir gelip bu incir ağacında meyve aradım, hiçbir şey bulmadım. Artık kes onu. Niye toprağı boşuna tüketsin?’ ");
INSERT INTO turobt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Adam da ona şöyle cevap vermiş: ‘Efendim, onu bu yıl da bırak, ben onun etrafını kazıp gübre koyayım. ");
INSERT INTO turobt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gelecek yıl meyve verirse, iyi. Vermezse, onu kesersin.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","İsa Şabat günü Yahudilerin bir toplantı yerinde vaaz ediyordu. ");
INSERT INTO turobt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","On sekiz yıldır içinde hastalık ruhu bulunan bir kadın da oradaydı. İki büklüm olmuştu, belini hiç doğrultamıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","İsa kadını görünce onu çağırdı. “Ey kadın! Hastalığından kurtuldun!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Elleriyle ona dokundu. Kadın da hemen doğruldu ve Allahʼı övmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama toplantı yerinin lideri, Şabat gününde şifa verdiği için İsaʼya kızdı. Adam toplantı yerindeki halka şöyle dedi: “Çalışmak için haftada altı gün vardır. O günlerde şifa bulmak için gelmelisiniz, Şabat gününde değil!” ");
INSERT INTO turobt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rab İsa da ona şöyle cevap verdi: “Sizi ikiyüzlüler sizi! Şabat günü hepiniz öküzünüzü ya da eşeğinizi bağlandığı yerden çözüp su içirmeye götürmez misiniz? ");
INSERT INTO turobt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","İşte, bu kadın da İbrahimʼin bir kızıdır. Ama Şeytan onu on sekiz yıl bağlı tuttu. Şabat günü bu bağdan serbest bırakılmalıydı, öyle değil mi?” ");
INSERT INTO turobt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","İsa bunu söyleyince, Oʼna karşı gelen herkes utançtan yerin dibine geçti. Ama bütün halk İsaʼnın yaptığı harika işlere sevindi. ");
INSERT INTO turobt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sonra İsa şunları söyledi: “Allahʼın Krallığı neye benziyor? Onu neyle karşılaştırayım? ");
INSERT INTO turobt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Allahʼın Krallığı küçücük hardal tohumuna benziyor. Adam onu alıp bahçesine ekti. Sonra büyüdü, ağaç kadar oldu. Gökteki kuşlar gelip onun dallarının arasında yuva kurdu.” ");
INSERT INTO turobt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","İsa yine şöyle dedi: “Allahʼın Krallığıʼnı neye benzeteyim? ");
INSERT INTO turobt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","O bir parça mayaya benziyor. Kadın onu alıp üç büyük kap una karıştırır. En sonunda bütün hamur mayalanır.” ");
INSERT INTO turobt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bu arada İsa köy kasaba dolaşarak vaaz ediyor, Yeruşalimʼe doğru ilerliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Biri Oʼna şunu sordu: “Efendimiz, acaba kurtulanlar az mı olacak?” İsa oradakilere şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Dar kapıdan girmeye uğraşın. Size söylüyorum, çok kişi ondan girmek isteyecek, fakat giremeyecek. ");
INSERT INTO turobt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ev sahibi kalkıp kapıyı kilitleyince, dışarda kalacaksınız. Kapıyı çalarak: ‘Efendimiz, bize kapıyı aç!’ diyeceksiniz. O da size şöyle cevap verecek: ‘Kim olduğunuzu, nereden geldiğinizi bilmiyorum.’ ");
INSERT INTO turobt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","O zaman, ‘Seninle birlikte yedik, içtik. Bizim sokaklarımızda vaaz verdin’ demeye başlayacaksınız. ");
INSERT INTO turobt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ama ev sahibi şöyle diyecek: ‘Kim olduğunuzu, nereden geldiğinizi bilmiyorum. Ey kötülük işleyenler! Hepiniz önümden çekilin.’ ");
INSERT INTO turobt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","İbrahimʼi, İshakʼı, Yakubʼu ve bütün peygamberleri Allahʼın Krallığıʼnda göreceksiniz. Siz ise kendinizi dışarıya atılmış bulacaksınız. Orada ağlayıp dişlerinizi gıcırdatacaksınız. ");
INSERT INTO turobt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","İnsanlar doğudan ve batıdan, kuzeyden ve güneyden gelecek, Allahʼın Krallığıʼnda sofraya oturacaklar. ");
INSERT INTO turobt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bakın, sonuncu olan bazıları birinci olacak, birinci olan bazıları da sonuncu olacak.” ");
INSERT INTO turobt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tam o anda bazı Ferisiler gelip İsaʼya şöyle dediler: “Git buradan, yoluna devam et. Hirodes seni öldürmek istiyor.” ");
INSERT INTO turobt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","İsa onlara şöyle dedi: “Gidin o tilkiye deyin ki, ‘Bak, bugün ve yarın cinleri kovacağım, hastalara şifa vereceğim, ve üçüncü gün amacıma ulaşacağım.’ ");
INSERT INTO turobt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yine de bugün, yarın ve öbür gün yoluma devam etmeliyim. Çünkü bir peygamberin Yeruşalim dışında öldürülmesi düşünülemez.” ");
INSERT INTO turobt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ey Yeruşalim, Yeruşalim! Peygamberleri öldüren ve sana gönderilen elçileri taşlayan şehir! Tavuk civcivlerini kanatlarının altına nasıl toplarsa, ben de senin evlatlarını kaç defa öyle toplamak istedim. Ama siz istemediniz. ");
INSERT INTO turobt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","İşte, tapınağınız ıssız bırakılacak. Size şunu söylüyorum: ‘Rabbin adıyla gelene övgüler olsun!’ diyeceğiniz zamana kadar beni bir daha görmeyeceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","İsa bir Şabat günü Ferisi liderlerinden birinin evine yemeğe davet edildi. Oradakiler İsaʼyı yakından izliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","İsaʼnın önüne bedeni su toplamış bir adam çıktı. ");
INSERT INTO turobt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","İsa da Tevrat uzmanları ve Ferisilere dönerek şunu sordu: “Şabat gününde şifa vermek Tevrat kanunlarına uygun mu, değil mi?” ");
INSERT INTO turobt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Onlar sessiz kaldılar. Bunun üzerine İsa adamı yanına alıp iyileştirdi, sonra evine gönderdi. ");
INSERT INTO turobt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sonra onlara şöyle dedi: “Şabat gününde oğlunuz ya da öküzünüz kuyuya düşerse hanginiz onu hemen çıkarmaz?” ");
INSERT INTO turobt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Onlar bu söze hiç cevap veremedi. ");
INSERT INTO turobt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","İsa davet edilen kişilerin nasıl en önemli yerlerde oturmayı seçtiklerini gördü. Bu yüzden onlara şöyle örnek verdi: ");
INSERT INTO turobt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Birisi seni bir düğüne davet ederse, en baştaki yere oturma. Belki senden daha önemli birisi de davet edilmiştir. ");
INSERT INTO turobt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","İkinizi davet eden kişi gelip, ‘Yerini bu adama ver!’ diyebilir. O zaman utanç içinde kalkıp en arkadaki yere oturursun. ");
INSERT INTO turobt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama sen davet edildiğin zaman, git, en arkadaki yerde otur. Öyle ki, seni davet eden adam gelip sana şöyle desin: ‘Arkadaşım, kalk, daha iyi bir yere geç.’ O vakit seninle beraber sofrada oturanların saygısını kazanırsın. ");
INSERT INTO turobt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Çünkü kendini yücelten alçaltılacak. Kendini alçaltan ise yüceltilecek.” ");
INSERT INTO turobt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","İsa da kendisini davet eden adama şöyle dedi: “Öğle ya da akşam yemeği verdiğin zaman arkadaşlarını, kardeşlerini, akrabalarını ya da zengin komşularını çağırma. Çünkü onlar da seni yemeğe davet ederek karşılık verirler. ");
INSERT INTO turobt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fakat bir ziyafet verdiğin zaman fakirleri, topalları, sakatları ve körleri davet et. ");
INSERT INTO turobt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Onlar sana karşılık verecek durumda olmadıklarından mutlu olacaksın. Çünkü doğru kişilerin dirilişinde karşılığını alacaksın.” ");
INSERT INTO turobt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","İsa ile beraber sofrada oturan bir adam bunu duyunca, Oʼna şöyle dedi: “Allahʼın Krallığıʼnda yemek yiyen adama ne mutlu!” ");
INSERT INTO turobt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","İsa ise ona şunu söyledi: “Bir gün adamın biri büyük bir ziyafet vermiş, birçok kişiyi davet etmiş. ");
INSERT INTO turobt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yemek saati gelince davetlilere, ‘Gelin, her şey hazır’ demesi için kölesini göndermiş. ");
INSERT INTO turobt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama hepsi anlaşmışcasına birer bahane uydurmuş. Birincisi ona, ‘Bir tarla aldım’ demiş. ‘Gidip ona bakmam lazım. Lütfen beni hoş gör.’ ");
INSERT INTO turobt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Başkası, ‘Beş çift öküz aldım’ demiş. ‘Onları denemeye gidiyorum. Lütfen beni hoş gör.’ ");
INSERT INTO turobt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sonra başkası, ‘Yeni evlendim’ demiş. ‘O yüzden gelemem.’ ");
INSERT INTO turobt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Köle geri dönünce durumu efendisine anlatmış. O zaman ev sahibi öfkelenmiş. Kölesine ‘Haydi’ demiş. ‘Çabuk ol, şehrin caddelerini ve ara sokaklarını dolaş. Fakirleri, topalları, körleri ve sakatları buraya getir.’ ");
INSERT INTO turobt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Köle dönünce, ‘Efendimiz, buyurduğun gibi oldu’ demiş. ‘Ama daha yer var.’ ");
INSERT INTO turobt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Efendi de kölesine şöyle demiş: ‘Şehirden çık, yolları ve patikaları dolaş. İnsanları içeri gelmeye razı et ki, evim dolsun. ");
INSERT INTO turobt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Çünkü size diyorum: davet edilen o adamlardan hiçbiri yemeğimi tatmayacak.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Büyük kalabalıklar İsaʼyla beraber yürüyordu. O da arkasına dönüp onlara şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bir kişi bana gelip de, beni kendi annesinden, babasından, karısından, çocuklarından, kardeşlerinden ve kız kardeşlerinden, hem de, evet, kendi hayatından bile daha fazla sevmezse, o kişi benim öğrencim olamaz. ");
INSERT INTO turobt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Çarmıhını yüklenip peşimden gelmeyen kişi, öğrencim olamaz. ");
INSERT INTO turobt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aranızdan biri bir kule yapmak isterse, onu tamamlayacak parası var mı yok mu diye önce oturup hesabını yapmaz mı? ");
INSERT INTO turobt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","O bunu yapmazsa, temel attıktan sonra işi bitiremeyince, onu gören herkes onunla alay etmeye başlar. ");
INSERT INTO turobt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Bu adam inşaata başladı, ama bitiremedi’ derler. ");
INSERT INTO turobt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Başka bir krala karşı savaşa giden bir kralı düşünün. On bin adamı olan bu kral, yirmi bin adamla karşısına gelen kralı yenebilir mi diye önce oturup düşünmez mi? ");
INSERT INTO turobt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","O kralı yenecek gücü yoksa, o daha uzaktayken, elçiler gönderip barış şartlarını ister. ");
INSERT INTO turobt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Durum her biriniz için aynıdır. Sahip olduğunuz her şeyi gözden çıkarmazsanız, benim öğrencim olamazsınız. ");
INSERT INTO turobt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Evet, tuz iyi bir şeydir. Ama tadını kaybederse ona bir daha neyle tuz tadı verilebilir? ");
INSERT INTO turobt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ne toprağa, ne de gübreye faydalıdır. Çöpe atılır. Kulağı olan işitsin.” ");
INSERT INTO turobt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bütün vergi memurları ve günahkârlar İsaʼyı dinlemek için yanına akın ediyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ferisiler ve Tevrat uzmanları ise şikâyet etmeye başladılar. “Bu adam günahkârları kabul ediyor, onlarla yemek yiyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bunun üzerine İsa onlara şu benzetmeyi anlattı: ");
INSERT INTO turobt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Diyelim ki sizden birinin yüz koyunu var ve bir tanesi kaybolur. O adam ne yapar? Doksan dokuz koyunu kırda bırakıp kayıp olanı bulana kadar onun peşine düşmez mi? ");
INSERT INTO turobt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bulduktan sonra da onu büyük sevinç içinde omuzlarına alır. ");
INSERT INTO turobt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eve gelince arkadaşlarını ve komşularını çağırıp, onlara şöyle der: ‘Benimle beraber sevinin. Çünkü kaybolan koyunumu buldum.’ ");
INSERT INTO turobt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Size söylüyorum, aynı şekilde, tövbe eden tek bir günahkâr için gökte sevinç olacak. Bu sevinç, doksan dokuz doğru kişi için duyulan sevinçten daha büyüktür. Çünkü onların tövbeye ihtiyacı yoktur. ");
INSERT INTO turobt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ya da diyelim ki, bir kadının on gümüş parası var. Kadın onlardan birini kaybetse bir lamba yakıp evi süpürmez mi? Parayı bulana kadar her tarafı didik didik aramaz mı? ");
INSERT INTO turobt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Parayı bulduğunda hanım arkadaşlarını ve komşularını çağırıp şöyle der: ‘Benimle beraber sevinin, çünkü kaybettiğim parayı buldum.’ ");
INSERT INTO turobt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Size diyorum, aynı bunun gibi tek bir günahkâr tövbe etse Allahʼın melekleri sevinir.” ");
INSERT INTO turobt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sonra İsa şöyle dedi: “Bir adamın iki oğlu varmış. ");
INSERT INTO turobt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bunlardan küçük olanı babasına demiş ki, ‘Babam, malından bana düşen payı ver.’ Adam da varını yoğunu oğullarının arasında bölüştürmüş. ");
INSERT INTO turobt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Çok vakit geçmeden, küçük oğul her şeyini toplamış, uzak bir ülkeye yolculuğa çıkmış. Orada çılgınca bir hayat yaşamış, varını yoğunu boşa harcamış. ");
INSERT INTO turobt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hepsini harcadıktan sonra o ülkede korkunç bir kıtlık olmuş, kendisi de yokluk çekmeye başlamış. ");
INSERT INTO turobt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bunun üzerine gitmiş, o ülkenin vatandaşlarından birinin yanında iş bulmuş. Adam da onu domuz gütmek için otlaklarına yollamış. ");
INSERT INTO turobt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Küçük oğul karnını domuzların yediği keçiboynuzlarıyla doyurmaya can atarmış. Ama kimse ona bir şey vermemiş. ");
INSERT INTO turobt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aklı başına gelince kendi kendine şöyle demiş: ‘Babamın bir sürü işçisi var. Hepsinin de yiyeceğinden fazla ekmeği var. Ben ise burada açlıktan ölüyorum! ");
INSERT INTO turobt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kalkıp babama gideceğim. Ona şöyle diyeceğim: “Baba, Allahʼa ve sana karşı günah işledim. ");
INSERT INTO turobt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Artık senin oğlun olarak anılmaya layık değilim. Beni işçilerinden biri gibi kabul et.” ’ ");
INSERT INTO turobt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Böylece kalkıp babasının yanına dönmüş. Ama o henüz uzaktayken, babası onu görmüş. Yüreği sızlamış, koşarak boynuna sarılmış ve onu öpmüş. ");
INSERT INTO turobt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oğlu da ona, ‘Baba’ demiş. ‘Gökte olan Allahʼa ve sana karşı günah işledim. Artık senin oğlun olarak anılmaya layık değilim.’ ");
INSERT INTO turobt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama babası kölelerine şöyle demiş: ‘Çabuk olun, en iyi kaftanı getirip oğluma giydirin. Parmağına bir yüzük takın, ayaklarına da sandalet giydirin. ");
INSERT INTO turobt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Besili danayı getirip kesin. Yiyelim ve şenlik yapalım. ");
INSERT INTO turobt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Çünkü benim bu oğlum ölüydü, şimdi hayata döndü, kayıptı ama bulundu.’ Böylece eğlenmeye başlamışlar. ");
INSERT INTO turobt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Adamın büyük oğlu ise tarladaymış. Dönüp eve yaklaştığı zaman, çalgı ve oyun sesi duymuş. ");
INSERT INTO turobt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hizmetkârlardan birini çağırıp ona ‘Ne oluyor?’ diye sormuş. ");
INSERT INTO turobt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O da şöyle cevap vermiş: ‘Kardeşin geri döndü. Baban da evladına sağ salim kavuştuğu için besili danayı kestirdi.’ ");
INSERT INTO turobt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ama büyük oğul öfkelenmiş ve içeri girmek istememiş. Babası dışarı çıkıp ona yalvarmaya başlamış. ");
INSERT INTO turobt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O da babasına, ‘Bak’ demiş. ‘Bunca yıl senin için köle gibi çalıştım. Senin buyruğundan hiç dışarı çıkmadım. Ama arkadaşlarımla eğlenmem için bana bir defa olsun bir keçi yavrusu bile vermedin. ");
INSERT INTO turobt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Fakat senin malını fahişelerle harcayıp yok eden şu oğlun gelince, ona besili danayı kestirdin!’ ");
INSERT INTO turobt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Babası ona, ‘Evladım’ demiş. ‘Sen her zaman benimle berabersin. Benim neyim varsa senindir. ");
INSERT INTO turobt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Fakat sevinip şenlik yapmamız lazım. Çünkü kardeşin ölüydü, şimdi hayata döndü, kayıptı ama bulundu.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","İsa, öğrencilerine şunları da anlattı: “Bir zamanlar zengin bir adam varmış. Malına bakmak için bir yönetici tutmuş. Ama yönetici onun malını oraya buraya savurmuş. Durum adama bildirilmiş. ");
INSERT INTO turobt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O da yöneticiyi çağırmış ona şöyle demiş: ‘Senin hakkında duyduğum bu şeyler nedir? Yaptığın yönetimin hesabını ver. Artık sen yönetici olamazsın.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yönetici de kendi kendine demiş: ‘Ne yapsam, acaba? Efendim yöneticiliği elimden alıyor. Toprak kazmaya kuvvetim yok, dilencilik yapmaya da yüzüm yok. ");
INSERT INTO turobt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ha, buldum! Yöneticilikten atıldığım zaman insanların beni evlerine kabul etmeleri için ne yapacağımı biliyorum.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Böylece efendisinin borçlularını teker teker çağırmış. Birincisine sormuş, ‘Efendime ne kadar borcun var?’ ");
INSERT INTO turobt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","O da şöyle cevap vermiş: ‘Yüz kap zeytinyağı.’ Ona, ‘Al borç kâğıdını!’ demiş. ‘Hemen otur, elli kap diye yaz.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sonra bir başkasına sormuş: ‘Senin ne kadar borcun var?’ O da şöyle cevap vermiş: ‘Bin çuval buğday.’ Yönetici ona, ‘Al borç kâğıdını!’ demiş. ‘Hemen otur, sekiz yüz çuval diye yaz.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Efendisi de haksız yöneticiyi akıllıca davrandığı için övmüş. Çünkü dünyevi insanlar birbirleriyle olan işlerini yürütürken Allahʼın aydınlattığı insanlardan daha akıllıdır. ");
INSERT INTO turobt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ben size diyorum ki: dünya malını kendinize arkadaşlar edinmek için kullanın, öyle ki, malınız yok olunca, sonsuza kadar kalıcı evlere kabul edilesiniz. ");
INSERT INTO turobt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Küçük bir işte sadık olan kişi, büyük işlerde de sadıktır. Ama küçük bir işte dürüst olmayan kişi, büyük işlerde de dürüst değildir. ");
INSERT INTO turobt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eğer dünya malıyla sadık olmadıysanız, o zaman gerçek zenginliği size kim emanet edecek? ");
INSERT INTO turobt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eğer başkasının malına iyi bakmadıysanız, kendi malınız olsun diye size kim bir şey verir? ");
INSERT INTO turobt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hiçbir hizmetkâr iki efendiye kölelik edemez: ya birinden nefret edip, öbürünü sevecek, ya da birine bağlanıp, öbürünü hor görecek. Siz hem Allahʼa, hem de paraya kölelik edemezsiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parayı seven Ferisiler, İsaʼnın bütün bu sözlerini işitiyor ve Oʼnunla alay ediyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ama İsa onlara şöyle dedi: “Siz insanların önünde kendinizi haklı çıkarıyorsunuz. Ama Allah yüreğinizi biliyor. Çünkü insanları gururlandıran her şey Allahʼa iğrenç gelir.” ");
INSERT INTO turobt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tevrat ve peygamberler Yahyaʼnın zamanına kadar sürdü. O zamandan beri Allahʼın Krallığı müjdeleniyor. Herkes oraya zorla girmek için çabalıyor. ");
INSERT INTO turobt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Göğün ve yerin ortadan kalkması, Tevratʼtan en ufak bir çizginin yok olmasından daha kolaydır.” ");
INSERT INTO turobt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Her kim karısını boşayıp başka bir kadınla evlenirse, zina işlemiş olur. Her kim kocasından boşanmış bir kadınla evlenirse zina işlemiş olur.” ");
INSERT INTO turobt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bir zamanlar zengin bir adam varmış. Mor, ince keten elbiseler giyermiş, bolluk içinde her gün eğlenirmiş. ");
INSERT INTO turobt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bir de Lazar adında fakir bir adam varmış. Zengin adamın evinin kapısının önünde bırakılırmış. Bedeni yaralarla doluymuş. ");
INSERT INTO turobt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Zengin adamın sofrasından düşen kırıntılarla karnını doyurmaya can atarmış. Üstelik köpekler gelip adamın yaralarını yalarmış. ");
INSERT INTO turobt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bir gün fakir adam ölmüş. Melekler onu götürüp İbrahimʼin yanına oturtmuşlar. Sonra zengin adam da ölmüş ve gömülmüş. ");
INSERT INTO turobt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ölüler dünyasında acı çeken zengin adam, gözlerini kaldırıp uzaktan İbrahimʼi ve yanında oturan Lazarʼı görmüş. ");
INSERT INTO turobt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Şöyle bağırmış: ‘Ey İbrahim Baba! Bana merhamet et! Ne olur, Lazarʼı yolla da parmağının ucunu suya bandırıp dilimi serinletsin. Çünkü bu alevler içinde korkunç acılar çekiyorum.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama İbrahim: ‘Evladım!’ demiş. ‘Hatırla, hayatın boyunca sen ne kadar iyi yaşadın. Lazar da hep perişan durumdaydı. Ama şimdi o burada rahat içinde, sen de korkunç acılar çekiyorsun. ");
INSERT INTO turobt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ayrıca, aramızda büyük bir uçurum var, öyle ki, ne buradan sizin yanınıza geçmek isteyenler geçebilir, ne de oradan biri buraya gelebilir.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","O zaman zengin adam şöyle demiş: ‘Ey Baba, sana yalvarırım, Lazarʼı babamın evine gönder. ");
INSERT INTO turobt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Çünkü beş kardeşim var. Onları uyarsın ki, korkunç acılar çekilen bu yere gelmesinler.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ama İbrahim şöyle demiş: ‘Onlarda Musaʼnın ve peygamberlerin kitapları var, orada yazılan sözleri dinlesinler.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Adam ise şöyle demiş: ‘Hayır, İbrahim Baba! Eğer ölüler arasından biri onlara giderse, o zaman tövbe ederler.’ ");
INSERT INTO turobt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Fakat İbrahim ona şöyle demiş: ‘Eğer Musa ve peygamberleri dinlemezlerse, ölülerden biri dirilse bile inanmayacaklar.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","İsa öğrencilerine şunları da anlattı: “İnsanları yoldan saptıran tuzakların olması kaçınılmaz. Ama bu tuzaklara sebep olan kişinin vay haline! ");
INSERT INTO turobt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","O kişinin, bu küçüklerden birini yoldan saptırmaktansa, boynuna bir değirmen taşı asılıp denize atılması daha iyidir.” ");
INSERT INTO turobt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Kendinize dikkat edin! Eğer kardeşin günah işlerse, onu azarla. Tövbe ederse, onu bağışla. ");
INSERT INTO turobt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eğer günde sana karşı yedi defa günah işlerse, sonra yedi defa sana dönüp ‘tövbe ediyorum’ derse, onu bağışla.” ");
INSERT INTO turobt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Elçiler ise Rab İsaʼya şöyle dediler, “Bize daha çok iman ver.” ");
INSERT INTO turobt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rab de şöyle dedi: “İmanınız hardal tohumu kadar olsa, şu dut ağacına, ‘Kökünle birlikte sökül ve denize dikil’ diyebilirsiniz, o da sözünüzü dinler.” ");
INSERT INTO turobt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Diyelim ki aranızdan bir kişinin tarla süren ya da koyun güden bir kölesi var. Köle tarladan geldiğinde ona, ‘Hemen gel, sofraya buyur’ der mi? ");
INSERT INTO turobt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tam tersine ona şöyle demez mi? ‘Bana yiyecek bir şey hazırla. Önlüğünü tak ve ben yiyip içinceye kadar bana hizmet et. Ben bitirdikten sonra, sen de yiyip içersin.’ ");
INSERT INTO turobt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Köle kendisine emredilen şeyleri yaptı diye efendisi ona teşekkür eder mi hiç? ");
INSERT INTO turobt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bunun gibi, size emredilen her şeyi yerine getirdikten sonra, siz de, ‘Biz faydasız köleleriz. Sadece yapmamız gerekeni yaptık’ dersiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","İsa Yeruşalimʼe giderken, Samiriye ile Celile arasındaki sınır bölgesinden geçiyordu. ");
INSERT INTO turobt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bir köye yaklaşırken İsaʼnın karşısına cüzzam hastası on adam çıktı. Onlar uzakta durdular. ");
INSERT INTO turobt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Yüksek sesle bağırdılar: “Ey İsa, Efendimiz, bize acı!” ");
INSERT INTO turobt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","İsa onları görünce, “Gidin, kendinizi rahiplere gösterin” dedi. Yolda giderlerken hastalıklarından temizlendiler. ");
INSERT INTO turobt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Onlardan biri, şifa bulduğunu görünce geri döndü, yüksek sesle Allahʼı övmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","İsaʼnın ayaklarına yüzüstü kapandı ve Oʼna teşekkür etti. Adam da Samiriyeliydi. ");
INSERT INTO turobt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bu durum karşısında İsa şunu sordu: “Hastalıktan temizlenen on kişi değil miydi? Diğer dokuz kişi nerede? ");
INSERT INTO turobt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Allahʼı yüceltmek için bu yabancıdan başka geri dönen olmadı mı?” ");
INSERT INTO turobt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sonra İsa adama, “Ayağa kalk, gidebilirsin. İmanın seni kurtardı” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ferisiler İsaʼya, “Allahʼın Krallığı ne vakit gelecek?” diye sorunca, İsa onlara şöyle cevap verdi: “Allahʼın Krallığı gözle görülür bir şekilde gelmez. ");
INSERT INTO turobt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Üstelik ‘Bak, buradadır!’ ya da ‘Oradadır!’ demeyecekler. Çünkü, işte Allahʼın Krallığı aranızdadır.” ");
INSERT INTO turobt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sonra İsa öğrencilerine şöyle dedi: “Öyle günler gelecek ki, İnsan Oğluʼnun günlerinin tek birini görmeye hasret kalacaksınız, ama görmeyeceksiniz. ");
INSERT INTO turobt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","İnsanlar size, ‘Bak, orada!’ ya da ‘Bak, şurada!’ diyecekler. Yerinizden ayrılmayın ve onların peşinden gitmeyin. ");
INSERT INTO turobt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Çünkü şimşek çakıp göğü bir ucundan öbür ucuna kadar nasıl aydınlatırsa, İnsan Oğlu da kendi gününde öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama İnsan Oğluʼnun önce çok acı çekip, bu kuşak tarafından reddedilmesi lazım. ");
INSERT INTO turobt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nuhʼun günlerinde nasıl olmuşsa, İnsan Oğluʼnun günlerinde de öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuhʼun gemiye bindiği güne kadar insanlar yiyip içerlerdi, karı alıp kocaya giderlerdi. Sonunda tufan gelip hepsini yok etti. ");
INSERT INTO turobt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lutʼun günlerinde de öyleydi: yiyip içiyorlar, mal alıp satıyor, tohum ekiyor, ev yapıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama Lutʼun Sodomʼdan ayrıldığı gün gökten ateş ve kükürt yağdı ve hepsini yok etti. ");
INSERT INTO turobt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","İşte, İnsan Oğluʼnun ortaya çıkacağı gün de öyle olacak. ");
INSERT INTO turobt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","O gün bir adamın malları evinde, kendisi de damdaysa, mallarını almaya aşağı inmesin. Tarlada olan adam da eve dönmesin. ");
INSERT INTO turobt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lutʼun karısını hatırlayın! ");
INSERT INTO turobt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Her kim sadece kendi canının rahatına bakarsa, canını kaybedecek. Ama her kim canını kaybederse, onu koruyacak. ");
INSERT INTO turobt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Size diyorum, o gece iki kişi bir yatakta olacak: birisi alınacak, öbürü bırakılacak. ");
INSERT INTO turobt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Aynı değirmende çalışan iki kadın olacak. Biri alınacak, öbürü bırakılacak.” ");
INSERT INTO turobt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bunun üzerine öğrenciler İsaʼya sordular, “Nerede, Efendimiz?” O da onlara şöyle dedi: “Leş neredeyse, akbabalar da oraya toplanacak.” ");
INSERT INTO turobt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","İsa öğrencilerine, yılmadan devamlı dua etsinler diye bir benzetme anlattı. ");
INSERT INTO turobt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Şehrin birinde bir hâkim varmış” dedi. “Kendisi Allahʼtan korkmayan ve insanları saymayan biriymiş. ");
INSERT INTO turobt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","O şehirde dul bir kadın da varmış. Hâkime devamlı gelip, ‘Bir adamla davam var. Ondan hakkımı al’ dermiş. ");
INSERT INTO turobt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hâkim bir süre yardım etmek istememiş. Ama daha sonra kendi kendine, ‘Ben Allahʼtan korkmuyorum ve insanları saymıyorum’ demiş. ");
INSERT INTO turobt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","‘Yine de şu kadının hakkını alacağım. Çünkü beni hep rahatsız ediyor. Yoksa durmadan gelip, beni çileden çıkaracak.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sonra Rab İsa şöyle devam etti: “Dürüst olmayan hâkimin sözlerini işittiniz. ");
INSERT INTO turobt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Allah da seçilmiş halkının hakkını almaz mı? Onlar Oʼna gece gündüz yalvarırken onları çok bekletir mi? ");
INSERT INTO turobt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Size diyorum ki, onların hakkını tez alacak. Ancak İnsan Oğlu gelince acaba dünyada iman bulacak mı?” ");
INSERT INTO turobt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kendi doğruluklarına güvenip başkalarını hor gören bazı kişiler vardı. İsa onlara şu benzetmeyi anlattı: ");
INSERT INTO turobt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Biri Ferisi, öbürü vergi memuru iki adam tapınağa dua etmeye gitmişler. ");
INSERT INTO turobt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ferisi ayakta dikilip kendi kendine şöyle dua etmiş: ‘Ey Allahʼım, öbür insanlar gibi olmadığım için sana şükrederim. Soyguncu, dolandırıcı, zinacı değilim. Şu vergi memuruna da benzemiyorum. ");
INSERT INTO turobt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Haftada iki defa oruç tutuyorum, bütün kazancımın ondalığını veriyorum.’ ");
INSERT INTO turobt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama vergi memuru uzakta durmuş. Gözlerini göğe kaldırmaya bile yüzü yokmuş. Göğsüne vura vura şöyle demiş: ‘Ey Allahım, ben günahkârım. Bana merhamet et.’ ");
INSERT INTO turobt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Size diyorum ki, Ferisi değil, vergi memuru Allahʼın gözünde doğru sayıldı ve öyle evine döndü. Çünkü kendini yücelten alçaltılacak. Kendini alçaltan ise yüceltilecek.” ");
INSERT INTO turobt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bazıları İsaʼya bebeklerini de getiriyordu. Onlara dokunmasını istediler. İsaʼnın öğrencileri bunu görünce onları azarladılar. ");
INSERT INTO turobt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama İsa çocukları yanına çağırıp şöyle dedi: “Bırakın, çocuklar bana gelsin. Onlara engel olmayın. Çünkü Allahʼın Krallığı çocuk gibi olanlarındır. ");
INSERT INTO turobt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Size doğrusunu söylüyorum: Kim Allahʼın Krallığıʼnı çocuk gibi kabul etmezse, oraya asla giremez.” ");
INSERT INTO turobt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Liderlerden biri İsaʼya şu soruyu sordu: “İyi öğretmenim sonsuz yaşama kavuşmak için ne yapmalıyım?” ");
INSERT INTO turobt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","İsa adama şöyle dedi: “Neden bana ‘iyi’ diyorsun? Allahʼtan başka iyi olan yoktur. ");
INSERT INTO turobt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Allahʼın buyruklarını biliyorsun: ‘Zina etmeyin, adam öldürmeyin, çalmayın, yalan yere şahitlik etmeyin, annenize ve babanıza saygı gösterin.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Adam, “Zaten bütün bunları gençliğimden beri yapıyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","İsa bunu duyunca ona şöyle dedi: “Daha bir eksiğin var: bütün malını sat ve fakirlere dağıt. İşte o zaman gökte hazinen olacak. Sonra gel, benim peşime düş.” ");
INSERT INTO turobt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Adam bunu duyunca çok üzüldü, çünkü son derece zengindi. ");
INSERT INTO turobt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Onun üzüldüğünü gören İsa şöyle dedi: “Zengin insanlar için Allahʼın Krallığıʼna girmek ne kadar zordur! ");
INSERT INTO turobt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Devenin iğne deliğinden geçmesi, zengin insanın Allahʼın Krallığıʼna girmesinden daha kolaydır.” ");
INSERT INTO turobt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bunu duyanlar sordular, “Öyleyse, kim kurtulabilir?” ");
INSERT INTO turobt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","İsa da onlara şöyle cevap verdi: “İnsan için imkansız olan şeyler Allah için mümkündür.” ");
INSERT INTO turobt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus da şöyle dedi: “Bak, biz her şeyimizi bıraktık, senin peşine düştük.” ");
INSERT INTO turobt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","İsa da onlara şunu söyledi: “Size doğrusunu söylüyorum: Allahʼın Krallığı için evini, karısını, kardeşlerini, annesini, babasını, ya da çocuklarını bırakan herkes, bu dünyada bunların kat kat fazlasını alacak. Hem de gelecek dünyada sonsuz yaşama kavuşacak.” ");
INSERT INTO turobt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sonra İsa on iki elçisini bir kenara çekip, onlara şöyle dedi: “Bakın, Yeruşalimʼe gidiyoruz. Peygamberlerin İnsan Oğlu hakkında yazdıkları her şey yerine gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Çünkü O, yabancıların eline teslim edilecek. Oʼnunla alay edecekler, Oʼnu aşağılayacaklar, yüzüne tükürecekler, ");
INSERT INTO turobt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oʼnu kamçılayıp öldürecekler. Ama üçüncü gün O ölümden dirilecek.” ");
INSERT INTO turobt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Öğrenciler bunlardan hiçbir şey anlayamadılar. Bu sözün anlamı onlardan gizlendi. Söylenen şeyler akıllarına yatmadı. ");
INSERT INTO turobt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","İsa Eriha kasabasına yaklaşırken kör bir adam yol kenarında oturmuş dilencilik yapıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Adam kalabalığın geçtiğini duyunca, “Ne oluyor?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ona, “Nasıralı İsa geçiyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Adam, “Ey Davud Oğlu İsa, bana acı” diye bağırdı. ");
INSERT INTO turobt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Önden gidenler onu azarlayarak susmasını istediler. Ama adam daha da çok bağırıyordu: “Ey Davud Oğlu, bana acı!” ");
INSERT INTO turobt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","İsa durup adamı kendisine getirsinler diye buyurdu. Adam gelince, İsa ona şunu sordu: ");
INSERT INTO turobt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Senin için ne yapmamı istiyorsun?” Adam, “Efendimiz, gözlerim tekrar görsün istiyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","İsa ona, “Gözlerin görsün” dedi. “İmanın seni kurtardı.” ");
INSERT INTO turobt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Adamın o anda gözleri açıldı ve Allahʼı överek İsaʼyı izlemeye başladı. Bütün halk bunu görünce, Allahʼı övdü. ");
INSERT INTO turobt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","İsa Eriha kasabasına girdi. Kasabanın içinden geçiyordu. ");
INSERT INTO turobt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Orada Zakkay adında bir adam vardı. Vergi memurlarının başıydı ve zengindi. ");
INSERT INTO turobt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","İsaʼnın nasıl bir kişi olduğunu görmek istiyordu. Ama kalabalık yüzünden Oʼnu göremiyordu, çünkü boyu kısaydı. ");
INSERT INTO turobt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bu sebeple Oʼnu görebilmek için önden koşup bir yabani incir ağacına tırmandı. Çünkü İsa o yoldan geçecekti. ");
INSERT INTO turobt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","İsa oraya gelince yukarı bakıp adama şöyle dedi: “Zakkay, çabuk aşağı in! Bugün senin evinde misafir kalmam lazım.” ");
INSERT INTO turobt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Adam aceleyle aşağı indi, İsaʼyı sevinçle evine buyur etti. ");
INSERT INTO turobt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oradakilerin hepsi bunu görünce söylenmeye başladılar. “İsa günahkâr bir adamın evine girip misafir oldu!” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakkay ayağa kalkıp Rab İsaʼya şöyle dedi: “İşte Efendimiz, mallarımın yarısını fakirlere veriyorum. Eğer birinden haksızlıkla bir şey aldımsa, onun dört katını geri veriyorum.” ");
INSERT INTO turobt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","İsa ona şöyle dedi: “Bugün bu ev kurtuluşa kavuştu. Çünkü bu adam da İbrahimʼin evladıdır. ");
INSERT INTO turobt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Çünkü İnsan Oğlu kaybolanı aramaya ve kurtarmaya geldi.” ");
INSERT INTO turobt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kalabalık bu sözleri dinlerken, İsa bir benzetme daha anlattı. Çünkü Yeruşalimʼe yaklaşıyordu, onlar ise Allahʼın Krallığıʼnın hemen görüneceğini sanıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bunun için İsa şöyle dedi: “Soylu bir adam uzak bir ülkeye gitmiş. Oradan kendi ülkesini yönetme yetkisini alıp geri dönecekmiş. ");
INSERT INTO turobt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gitmeden önce kölelerinden on kişiyi çağırıp onlara birer altın para vermiş. Onlara şöyle demiş: ‘Ben gelinceye kadar, siz bu parayla iş yapın.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ama adamın vatandaşları ondan nefret ederlermiş. Onun peşinden, ‘Bu adamın kralımız olmasını istemiyoruz’ diyen haberciler göndermişler. ");
INSERT INTO turobt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ama adam krallık yetkisini almış. Ülkesine dönünce, parayı verdiği köleleri yanına çağırtmış. Ticaretle edindikleri kazancı öğrenmek istemiş. ");
INSERT INTO turobt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Birincisi gelip şöyle demiş: ‘Efendimiz, senin bir altın paran on altın daha kazandı.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Efendisi ona ‘Aferin, iyi köle’ demiş. ‘Küçük işte güvene layık çıktığın için, on şehir üzerine yetkili olursun.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","İkincisi gelip şöyle demiş: ‘Efendimiz, senin bir altın paran beş altın para daha kazandı.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Efendisi ona, ‘Sen de beş şehir üzerine yetkili olursun’ demiş. ");
INSERT INTO turobt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sonra başka bir köle gelip şöyle demiş: ‘Efendimiz, senin altın paran işte burada. Onu bir mendile sarıp bir yerde sakladım. ");
INSERT INTO turobt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Çünkü senden korktum. Sen sert bir adamsın, yatırım yapmadığından kazanırsın, ekmediğini biçersin.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Efendisi ona şöyle cevap vermiş: ‘Seni faydasız köle! Kendi ağzından çıkan sözle seni yargılayacağım. Madem biliyordun ki, ben sert bir adamım, yatırım yapmadığımdan kazanırım, ekmediğimi biçerim, ");
INSERT INTO turobt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","o zaman niye paramı bankaya yatırmadın? Döndüğüm zaman onu faiziyle birlikte geri alırdım.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Etrafta duranlara şöyle demiş: ‘Adamın altın parasını alın, on parası olana verin.’ ");
INSERT INTO turobt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ona, ‘Efendimiz’ demişler. ‘Onun zaten on altın parası var!’ ");
INSERT INTO turobt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ben size şunu söylüyorum: Kendisine verileni kullanan kişiye daha da çok verilecek, kullanmayan kişiden ise elinde olan da alınacak. ");
INSERT INTO turobt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Şimdi kral olmamı istemeyen bu düşmanlarımı buraya getirin, benim önümde kılıçtan geçirin.’ ” ");
INSERT INTO turobt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","İsa bunları söyledikten sonra Yeruşalimʼe doğru yola çıkarak önden gitti. ");
INSERT INTO turobt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zeytin Dağı denilen tepede Beytfaci ve Beytanya adlı köyler vardı. İsa oraya yaklaşınca, öğrencilerinden ikisini önden gönderdi. ");
INSERT INTO turobt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Onlara şöyle dedi: “Karşıdaki köye gidin. Köye girince bağlı duran bir sıpa bulacaksınız. Ona daha önce hiç kimse binmemiştir. Onu çözüp bana getirin. ");
INSERT INTO turobt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eğer biri size, ‘Onu neden çözüyorsunuz?’ diye sorarsa, ‘Efendimizʼin ona ihtiyacı var’ dersiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gönderilen iki öğrenci, her şeyi aynen İsaʼnın onlara anlattığı gibi buldular. ");
INSERT INTO turobt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sıpayı çözerken hayvanın sahipleri onlara, “Sıpayı neden çözüyorsunuz?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Öğrenciler şöyle cevap verdi: “Efendimizʼin ona ihtiyacı var.” ");
INSERT INTO turobt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sıpayı İsaʼya getirdiler, paltolarını üzerine attılar ve İsaʼyı üstüne bindirdiler. ");
INSERT INTO turobt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","İsa yoluna devam ederken, halk paltolarını yolun üzerine serdi. ");
INSERT INTO turobt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","İsa Zeytin Dağıʼndan aşağı inen yola yaklaşmıştı. Öğrencilerinden oluşan kalabalık sevinç içindeydi. Görmüş oldukları bütün mucizeler için yüksek sesle Allahʼı övmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Şöyle dediler: “Rabbin adıyla gelen Kralʼa övgüler olsun! Gökte esenlik, en yücelerde Olanʼa yücelik olsun!” ");
INSERT INTO turobt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kalabalığın içinde bazı Ferisiler vardı. İsaʼya “Öğretmen, öğrencilerini sustur!” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O da şöyle cevap verdi: “Size diyorum ki, bunlar sussalar bile taşlar bağırır.” ");
INSERT INTO turobt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","İsa Yeruşalimʼe yaklaşınca, şehri görüp onun için ağladı. ");
INSERT INTO turobt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Şöyle dedi: “Keşke sen bugün sana barış getiren yolu bilseydin. Ama o şimdi senin gözlerinden saklıdır. ");
INSERT INTO turobt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Evet, senin üzerine öyle günler gelecek ki, düşmanların seni duvarlarla çevirecek, çepeçevre saracak ve her taraftan sıkıştıracak. ");
INSERT INTO turobt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Seni de, içinde bulunan evlatlarını da yerle bir edecekler. Sende taş üstünde taş bırakmayacaklar. Çünkü Allahʼın seni ziyaret ettiği zamanı fark etmedin.” ");
INSERT INTO turobt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sonra İsa tapınağın avlusuna girip satıcıları kovmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Onlara şöyle dedi: “Kitapʼta şöyle yazılıdır: ‘Benim evim ibadet evi olacak.’ Ama siz onu ‘haydut yatağına’ çevirdiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","İsa her gün tapınak avlusunda vaaz ediyordu. Başrahipler, Tevrat uzmanları ve halkın liderleri Oʼnu yok etmek için bir yol arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yine de bunu nasıl yapacaklarını bilemiyorlardı. Çünkü bütün halk İsaʼyı can kulağıyla dinliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","İsa bir gün tapınak avlusunda halka vaaz edip Müjdeʼyi bildiriyordu. O zaman başrahipler, Tevrat uzmanları ve halkın liderleri Oʼna yaklaştılar. ");
INSERT INTO turobt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Söyle bize bakalım” dediler. “Bu şeyleri ne yetkiyle yapıyorsun? Sana bu yetkiyi veren kim?” ");
INSERT INTO turobt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","İsa onlara şöyle cevap verdi: “Ben de size bir soru soracağım. Bana söyleyin: ");
INSERT INTO turobt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yahyaʼnın vaftiz etme yetkisi nereden geldi? Allahʼtan mı yoksa insandan mıydı?” ");
INSERT INTO turobt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bu soruyu aralarında tartışıp şöyle dediler: “ ‘Allahʼtan’ dersek, ‘O zaman ona neden inanmadınız?’ diyecek. ");
INSERT INTO turobt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ama ‘İnsandan’ dersek, bütün halk bizi taşlayacak, çünkü hepsi Yahyaʼnın peygamber olduğuna inanıyor.” ");
INSERT INTO turobt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Böylece, “Nereden olduğunu bilmiyoruz” diye cevap verdiler. ");
INSERT INTO turobt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","İsa da onlara şöyle dedi: “Ben de bu şeyleri ne yetkiyle yaptığımı size söylemem.” ");
INSERT INTO turobt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sonra İsa halka şu benzetmeyi anlattı: “Bir adam üzüm bağı dikmiş ve onu bağcılara kiraya vermiş. Sonra yolculuğa çıkarak uzun bir süre uzakta kalmış. ");
INSERT INTO turobt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Üzüm toplama zamanı gelince, bağ sahibi bağcılara bir köle göndermiş. Bağın ürününden sahibine düşen payı vermelerini istemiş. Ama bağcılar köleyi dövüp boş elle geri göndermişler. ");
INSERT INTO turobt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sonra adam başka bir köle göndermiş. Onu da dövüp aşağılamışlar ve boş elle geri yollamışlar. ");
INSERT INTO turobt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Adam üçüncü defa bir köle göndermiş. Bağcılar onu da yaralayıp bağdan atmışlar. ");
INSERT INTO turobt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sonra bağ sahibi demiş ki, ‘Acaba ne yapsam? Sevgili oğlumu göndereyim. Herhalde ona saygı gösterirler.’ ");
INSERT INTO turobt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama bağcılar sahibin oğlunu görünce birbirleriyle şöyle konuşmuşlar: ‘Mirasçı budur. Onu öldürelim de, miras bize kalsın.’ ");
INSERT INTO turobt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Böylece, sahibin oğlunu bağdan dışarı atıp öldürmüşler. Peki, bunun sonunda bağ sahibi onlara ne yapacak? ");
INSERT INTO turobt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Gelip o bağcıları yok edecek, üzüm bağını da başkalarına verecek.” Halk bunu duyunca, “Allah korusun” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","İsa onların gözlerinin içine bakarak şöyle dedi: “O zaman Kutsal Yazılarʼdaki şu söz ne demek? ‘İnşaatçıların reddettiği taş, binanın köşe taşı oldu.’ ");
INSERT INTO turobt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kim o taşın üzerine düşerse, paramparça olacak. O taş da kimin üzerine düşerse, onu ezip toz duman edecek.” ");
INSERT INTO turobt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tevrat uzmanları ve başrahipler o anda İsaʼyı yakalamak istediler, çünkü bu benzetmeyi kendilerine karşı anlattığını anladılar. Ama halkın tepkisinden korktular. ");
INSERT INTO turobt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bu yüzden İsaʼyı gözlemeye başladılar. Kendilerine dürüst insan süsü veren ispiyoncular gönderdiler. İsaʼyı kendi sözüyle tuzağa düşürmek istiyorlardı. Bunu İsaʼyı valinin hükmüne ve yetkisine teslim edebilmek için yaptılar. ");
INSERT INTO turobt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Böylece İsaʼya sordular: “Öğretmenimiz, biliyoruz ki, sen doğru olanı söylüyorsun ve öğretiyorsun. İnsanlar arasında ayrım yapmıyorsun, Allahʼın yolunu dürüstlükle öğretiyorsun. ");
INSERT INTO turobt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sezarʼa vergi ödememiz Tevratʼa uygun mu, değil mi?” ");
INSERT INTO turobt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama İsa onların hilesini anlayıp şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bana bir gümüş para gösterin! Üzerinde kimin resmi var, kimin adı yazılı?” “Sezarʼın” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","İsa da onlara şöyle dedi: “Öyleyse, Sezarʼın hakkını Sezarʼa verin, Allahʼın hakkını da Allahʼa verin.” ");
INSERT INTO turobt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","İspiyoncular İsaʼyı halkın önünde söylediği sözlerle tuzağa düşüremediler. Oʼnun cevabına hayret ederek susup kaldılar. ");
INSERT INTO turobt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sonra İsaʼya bazı Sadukiler geldi. Sadukiler “Ölüler dirilmez” derler. ");
INSERT INTO turobt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","İsaʼya şunu sordular: “Öğretmenimiz, Tevratʼta Musa bize şöyle buyurur: ‘Eğer evli bir adam çocuksuz ölürse, adamın kardeşi ölen kardeşinin karısını alsın ve kardeşinin soyunu devam ettirsin.’ ");
INSERT INTO turobt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Peki, yedi kardeş var diyelim. Birincisi bir kadınla evlendi, fakat çocuğu olmadan öldü. ");
INSERT INTO turobt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","İkincisi de öyle. ");
INSERT INTO turobt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Üçüncüsü de aynı kadınla evlendi. Bütün diğer kardeşler de sırayla onunla evlendi, ama hepsi çocuksuz öldü. ");
INSERT INTO turobt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","En sonunda kadın da öldü. ");
INSERT INTO turobt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bu durumda ölüler dirildiği zaman kadın kimin karısı olacak? Çünkü bu kadın yedi kardeşin de karısı olmuştu.” ");
INSERT INTO turobt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","İsa onlara şöyle cevap verdi: “Bu dünyanın insanları karı alırlar, kocaya giderler. ");
INSERT INTO turobt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama gelecek dünyaya ve ölümden dirilişe kavuşmaya layık sayılanlar, ne karı alırlar, ne de kocaya giderler. ");
INSERT INTO turobt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Böyleleri bir daha ölemez, melekler gibi olurlar. Ölümden dirilenler olarak Allahʼın oğulları olurlar. ");
INSERT INTO turobt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa yanan çalı hakkındaki bölümde ölülerin dirildiğine işaret ediyor. Orada Rab için, ‘İbrahimʼin Allahı, İshakʼın Allahı ve Yakubʼun Allahı’ der. ");
INSERT INTO turobt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Allah ölülerin değil, yaşayanların Allahıʼdır. Çünkü Oʼnun gözünde herkes hâlâ yaşıyor.” ");
INSERT INTO turobt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bazı Tevrat uzmanları söze karışıp şöyle dedi: “Öğretmenimiz, iyi cevap verdin.” ");
INSERT INTO turobt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Çünkü kimse artık İsaʼya soru sormaya cesaret etmedi. ");
INSERT INTO turobt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sonra İsa onlara şöyle dedi: “İnsanlar Mesihʼe neden Davud Oğlu diyorlar? ");
INSERT INTO turobt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Çünkü Davud Mezmurlar kitabında şöyle diyor: ‘Rab Efendimʼe dedi ki, “Senin düşmanlarını ayaklarına basamak yapacağım. O zamana kadar sağımda otur.” ’ ");
INSERT INTO turobt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davud Mesihʼe ‘Efendim’ dediğine göre, Mesih nasıl Davudʼun oğlu olabilir?” ");
INSERT INTO turobt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bütün halk dinlerken İsa kendi öğrencilerine şunları söyledi: ");
INSERT INTO turobt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tevrat uzmanlarından sakının. Onlar uzun elbiseler içinde dolaşmayı severler. Çarşılarda selam almaya bayılırlar. Toplantı yerlerinde en saygın yerleri ve ziyafetlerde en güzel yerleri ararlar. ");
INSERT INTO turobt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dul kadınları kandırıp mallarını mülklerini ellerinden alırlar. Gösteriş için uzun uzun dua ederler. Böyle kişilerin cezası çok ağır olacak.” ");
INSERT INTO turobt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","İsa başını kaldırıp baktı. Zenginlerin bağışlarını tapınaktaki bağış kutusuna attıklarını gördü. ");
INSERT INTO turobt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sonra yoksul bir dul kadının oraya iki bakır para attığını gördü. ");
INSERT INTO turobt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bunun üzerine şöyle dedi: “Size doğrusunu söylüyorum: bu fakir dul kadın hepsinden daha çok verdi. ");
INSERT INTO turobt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Çünkü bütün diğerleri kutuya servetlerinden artanı attılar. Bu kadın ise son derece fakir olduğu halde bütün geçimini attı.” ");
INSERT INTO turobt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bazı kişiler tapınak hakkında konuşuyorlardı. “Ne güzel taşlarla ve adanan hediyelerle süslenmiş!” diyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","İsa şöyle dedi: “Bu gördüğünüz şeyler var ya! Öyle günler gelecek ki, taş üstünde taş bırakılmayacak, hepsi yıkılacak.” ");
INSERT INTO turobt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oʼna şunu sordular: “Peki öğretmenimiz, bunlar ne zaman olacak, ve bunların yerine geleceğini gösteren işaret nedir?” ");
INSERT INTO turobt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","İsa şöyle dedi: “Sakın aldanmayın. Çünkü birçok kişi benim adımla gelip ‘Ben Oʼyum!’ ve ‘Vakit yaklaştı!’ diyecek. Onların peşinden gitmeyin. ");
INSERT INTO turobt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Savaş ve isyan haberleri işittiğinizde korkuya düşmeyin. Önce bunlar olmalıdır. Ama bu dünyanın sonu hemen gelmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sonra İsa onlara şunu söyledi: “Millet millete, krallık krallığa saldıracak. ");
INSERT INTO turobt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Büyük depremler olacak. Kimi yerlerde kıtlıklar ve salgın hastalıklar meydana gelecek. Korkunç olaylar ve gökte olağanüstü işaretler olacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama bütün bunlar olmadan önce, sizi yakalayacaklar, size eziyet edecekler. Sizi Yahudilerin toplantı yerlerine sürükleyip hapishaneye atacaklar. Bana bağlı olduğunuz için sizi kralların ve valilerin önüne çıkaracaklar. Bütün bunlar benim adım yüzünden sizin başınıza gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bu da, hakkımda şahitlik etmeniz için fırsat olacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","O durumlarda sakın ‘Kendimizi nasıl savunacağız?’ diye düşünmeyin. ");
INSERT INTO turobt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ben size konuşma yeteneği ve hikmet vereceğim. Öyle ki, hiçbir düşmanınız size karşı koyamayacak, söylediklerinize verecek cevap bulamayacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anne babanız, kardeşler, hısımlar ve arkadaşlarınız bile size ihanet edecekler. Bazılarınızın ölümüne sebep olacaklar ");
INSERT INTO turobt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bana bağlı olduğunuz için herkes sizden nefret edecek. ");
INSERT INTO turobt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama saçınızın tek bir teli bile yok olmayacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Acılara dayanarak asıl hayat bulursunuz. ");
INSERT INTO turobt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yeruşalimʼin askerler tarafından kuşatıldığını gördüğünüz zaman, bilin ki, onun yıkılışı yaklaşmıştır. ");
INSERT INTO turobt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","O zaman Yahudiyeʼdekiler dağlara kaçsınlar. Şehrin içindekiler oradan çıksınlar. Kırdakiler de şehre girmesinler. ");
INSERT INTO turobt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Çünkü bunlar ceza günleridir. Böylece Kutsal Kitapʼta yazılan her şey yerine gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vay o günlerde hamile olanların ve bebek emzirenlerin haline! Çünkü ülkede büyük sıkıntı olacak ve bu halk Allahʼın öfkesine uğrayacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bazıları kılıçtan geçirilecek, bazıları da esir olarak bütün milletlerin arasına dağıtılacaklar. Yeruşalim diğer milletlerin ayakları altında çiğnenecek. Ama sonunda o milletlerin zamanları sona erecek. ");
INSERT INTO turobt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Güneşte, ayda ve yıldızlarda olağanüstü işaretler olacak. Bütün yeryüzünde ise milletler denizin gürültüsü ve dalgaların çarpmasıyla altüst olup şaşkına dönecekler. ");
INSERT INTO turobt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","İnsanlar, dünyanın üzerine gelecek olan felâketleri beklerken korkudan bayılacaklar. Çünkü gök cisimleri sarsılacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","O zaman İnsan Oğluʼnun bulut içinde büyük güç ve görkemle geldiğini görecekler. ");
INSERT INTO turobt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bu olaylar olmaya başlayınca, dik durup başlarınızı kaldırın, çünkü kurtuluşunuz yaklaşıyor.” ");
INSERT INTO turobt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sonra onlara bir benzetme anlattı: “İncir ağacına ve bütün ağaçlara bakın. ");
INSERT INTO turobt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ağaçların yaprak çıkardığını görünce yaz mevsiminin yaklaştığını bilirsiniz. ");
INSERT INTO turobt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bunun gibi, bu olayların gerçekleştiğini görünce bilin ki, Allahʼın Krallığı yakındır. ");
INSERT INTO turobt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Size doğrusunu söylüyorum: bütün bu şeyler yerine gelmeden, bu kuşak yok olmayacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gök ve yer ortadan kalkacak, ama benim sözlerim asla ortadan kalkmayacak. ");
INSERT INTO turobt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kendinize dikkat edin ki, çılgınca eğlenme, sarhoşluk ve bu hayatın kaygılarıyla yüreğiniz sıkılmasın. O gün sizi ansızın kapan gibi yakalamasın. ");
INSERT INTO turobt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Çünkü o gün yeryüzünde yaşayan herkesin üzerine gelecek. ");
INSERT INTO turobt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Her an tetikte durun. Dua edin ki, gelecek olan bütün bu şeylerden kaçmaya gücünüz olsun ve İnsan Oğluʼnun önünde durabilesiniz.” ");
INSERT INTO turobt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","İsa gündüz tapınak avlusunda vaaz ediyordu. Geceleyin de şehirden çıkıp Zeytin Dağı denilen tepede kalıyordu. ");
INSERT INTO turobt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bütün halk Oʼnu dinlemek için sabah erkenden tapınağa geliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yahudilerin Mayasız Ekmek Bayramı yaklaşıyordu. Bu bayrama aynı zamanda “Özgürlük Bayramı” da deniliyor. ");
INSERT INTO turobt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Başrahipler ve Tevrat uzmanları İsaʼyı öldürmenin uygun bir yolunu arıyorlardı. Çünkü halktan korkuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bu arada Şeytan, İsaʼnın on iki elçisinden biri olan Yahuda İskariyotʼun içine girdi. ");
INSERT INTO turobt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuda, başrahipler ve tapınağın güvenlik görevlileriyle danışmaya gitti. İsaʼyı tutuklamaları için nasıl yardım edebileceğini konuştu. ");
INSERT INTO turobt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Onlar buna sevindiler. Kendisine para vermek için anlaştılar. ");
INSERT INTO turobt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O da razı geldi. Kalabalıktan uzakta, İsaʼya ihanet etmek için fırsat kollamaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mayasız Ekmek Bayramıʼnın birinci günü geldi. O gün kurban kuzusunun kesilmesi lazımdı. ");
INSERT INTO turobt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","İsa, Petrus ve Yuhannaʼya, “Gidin! Hazırlık yapın da bayram yemeğini yiyelim” dedi ve onları önden gönderdi. ");
INSERT INTO turobt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Onlar da İsaʼya, “Onu nerede hazırlamamızı istiyorsun?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Onlara, “Dikkat edin!” dedi. “Şehre girerken testiyle su taşıyan bir adam karşınıza çıkacak. Onun arkasından gidin. Adam bir eve girecek. ");
INSERT INTO turobt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","O ev sahibine deyin ki, ‘Öğretmenimiz, “Misafir odası nerede?” diye soruyor. “Orada öğrencilerimle birlikte Özgürlük Bayram yemeğini yemek istiyorum.” ’ ");
INSERT INTO turobt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","O zaman size üst katta döşenmiş büyük bir oda gösterecek. Bizim için orasını hazırlayın.” ");
INSERT INTO turobt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","İki öğrenci gitti. Her şeyi İsaʼnın anlattığı gibi buldular ve Özgürlük Bayram hazırlıklarını yaptılar. ");
INSERT INTO turobt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yemek vakti gelince İsa elçileriyle birlikte sofraya oturdu. ");
INSERT INTO turobt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Onlara şöyle dedi: “Ben acı çekmeden önce bu Özgürlük Bayram yemeğini sizinle beraber yemeyi çok istedim. ");
INSERT INTO turobt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Çünkü size söylüyorum, bu yemek Allahʼın Krallığıʼnda tam anlamına kavuşacak. O zamana kadar onu bir daha yemeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sonra eline bir bardak aldı. Şükrettikten sonra, “Bunu alın, aranızda paylaşın” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“Çünkü size söylüyorum, Allahʼın Krallığı gelene kadar asmanın ürününden bir daha içmeyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sonra eline ekmek aldı, şükredip onu böldü ve onlara verdi. “Bu sizler için verilen bedenimdir” dedi. “Beni anmak için bunu yapın.” ");
INSERT INTO turobt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tıpkı bunun gibi, yemekten sonra eline bir bardak şarap alıp şöyle dedi: “Bu bardak sizin için akıtılacak olan kanımla başlayan yeni antlaşmadır. ");
INSERT INTO turobt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Fakat bakın, bana ihanet eden adamın eli, benim elimle birlikte sofradadır. ");
INSERT INTO turobt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gerçi İnsan Oğlu kendisi için çizilen yoldan ölüme gidiyor. Fakat Oʼna ihanet eden adamın vay haline!” ");
INSERT INTO turobt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bunun üzerine öğrenciler aralarında bunu kimin yapabileceğini tartışmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ayrıca onlardan kimin en önemli sayılacağı konusunda aralarında çekişme oldu. ");
INSERT INTO turobt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","İsa da onlara şunu söyledi: “Diğer milletlerin kralları onların başlarına buyrukçu kesilirler. Yetkili adamları da kendilerine ‘iyiliksever’ dedirtirler. ");
INSERT INTO turobt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama siz böyle olmayın. Aranızda en büyük olan en küçük gibi olsun, liderlik yapan da hizmet eden gibi olsun. ");
INSERT INTO turobt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Çünkü kim daha büyük? Sofraya oturan mı yoksa hizmet eden mi? Sofraya oturan, değil mi? Ama ben aranızda hizmet eden biri gibiyim. ");
INSERT INTO turobt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Zorluklarla denendiğimde bana sadık kalan sizlersiniz. ");
INSERT INTO turobt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Babam bana nasıl bir krallık verdiyse, ben de öylece size bir krallık veriyorum. ");
INSERT INTO turobt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Öyle ki, krallığımda benim soframda yiyip içesiniz ve tahtlar üzerinde oturup İsrailʼin on iki oymağını yargılayasınız. ");
INSERT INTO turobt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simun, Simun, dikkat et! Şeytan sizleri ekin gibi elekten geçirmek için yetki istedi. ");
INSERT INTO turobt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama ben imanın kaybolup gitmesin diye senin için dua ettim. Sen ise bana geri döndüğün zaman imanlı kardeşlerini güçlendir.” ");
INSERT INTO turobt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simun Petrus da İsaʼya, “Efendimiz!” dedi. “Ben seninle cezaevine de ölüme de gitmeye hazırım.” ");
INSERT INTO turobt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","İsa şöyle dedi: “Ey Petrus, sana diyorum ki, bu gece horoz ötmeden beni tanıdığını üç defa inkâr edeceksin.” ");
INSERT INTO turobt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sonra elçilere şunu sordu: “Sizi kesesiz, torbasız ve sandaletsiz gönderdiğim zaman bir eksiğiniz oldu mu?” “Hiç olmadı,” diye cevap verdiler. ");
INSERT INTO turobt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sonra onlara şöyle dedi: “Ama şimdi kesesi ve torbası olan yanına alsın. Kimin kılıcı yoksa, paltosunu satıp bir kılıç alsın. ");
INSERT INTO turobt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Çünkü size söylüyorum: Benim hakkımda yazılan şu söz yerine gelmelidir: ‘O suçlu adamlarla bir sayıldı.’ Evet, benim hakkımda yazılmış olanlar yerine geliyor.” ");
INSERT INTO turobt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Efendimiz” dediler. “Bak, burada iki kılıç var.” O da onlara, “Yeter!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","İsa dışarı çıkıp adeti olduğu gibi Zeytin Dağıʼna gitti. Öğrencilerine de Oʼnun ardından gittiler. ");
INSERT INTO turobt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","O yere varınca, İsa onlara şöyle dedi: “Denendiğinizde günaha düşmemek için dua edin.” ");
INSERT INTO turobt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sonra onlardan bir taş atımı kadar uzaklaştı, diz çöküp şöyle dua etmeye başladı: ");
INSERT INTO turobt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baba, eğer istersen bu bardağı benden uzaklaştır. Yine de, benim değil, senin isteğin olsun.” ");
INSERT INTO turobt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sonra gökten bir melek İsaʼya göründü, Oʼna güç verdi. ");
INSERT INTO turobt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","İsa derin acı çekerek daha heyecanlı bir şekilde dua etmeye başladı. Oʼnun teri, yere düşen iri kan damlaları gibiydi. ");
INSERT INTO turobt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","İsa duasından kalkınca öğrencilerinin yanına geldi. Onları üzüntüden uyumuş buldu. ");
INSERT INTO turobt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Onlara dedi: “Niye uyuyorsunuz? Kalkın, denendiğinizde günaha düşmemek için dua edin.” ");
INSERT INTO turobt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","İsa daha konuşurken birdenbire bir kalabalık geldi. On iki elçiden biri olan Yahuda onlara yol gösteriyordu. İsaʼyı öpmek için yaklaştı. ");
INSERT INTO turobt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama İsa ona, “Yahuda” dedi. “İnsan Oğluʼna bir öpücükle mi ihanet ediyorsun?” ");
INSERT INTO turobt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","İsaʼnın yanında duranlar, ne olacağını anlayınca, “Efendimiz, kılıçla vuralım mı?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Onlardan biri başrahibin kölesine vurup onun sağ kulağını kesti. ");
INSERT INTO turobt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama İsa, “Yetti artık!” dedi. Sonra adamın kulağına dokunup onu iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","İsa Oʼnun üzerine yürüyen başrahipler, tapınak güvenlik görevlileri ve halkın liderlerine şöyle dedi: “Bir hayduda karşı çıkıyormuş gibi kılıçlarla, sopalarla mı geldiniz? ");
INSERT INTO turobt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Her gün yanınızda tapınak avlusundaydım; o zaman bana karşı el kaldırmadınız. Ama bu sizin zamanınızdır, karanlığın hüküm sürdüğü zamandır.” ");
INSERT INTO turobt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ondan sonra İsaʼyı yakaladılar, başrahibin evine götürüp, içeri aldılar. Petrus onları uzaktan izliyordu. ");
INSERT INTO turobt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Görevliler avlunun ortasında bir ateş yaktıktan sonra beraber oturdular. Petrus da onların arasında oturdu. ");
INSERT INTO turobt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sonra bir hizmetçi kız ateşin ışığında oturan Petrusʼu gördü. Gözlerini ona dikerek şöyle dedi: “Bu adam da İsaʼyla birlikteydi.” ");
INSERT INTO turobt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama Petrus, “Kadın, ben Oʼnu tanımıyorum” diye inkâr etti. ");
INSERT INTO turobt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Az bir zaman sonra başkası onu görüp, “Sen de onlardan birisin” dedi. Ama Petrus, “Yok arkadaş, ben değilim” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aşağı yukarı bir saat geçtikten sonra yine başkası ısrarla şöyle dedi: “Gerçekten bu adam İsaʼyla beraberdi. Çünkü Celileʼdendir.” ");
INSERT INTO turobt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ama Petrus, “Arkadaş, sen ne diyorsun, anlamıyorum” dedi. Tam o anda, Petrus daha konuşurken, horoz öttü. ");
INSERT INTO turobt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Rab İsa da dönüp Petrusʼa baktı. O zaman Petrus Rabbin şu sözünü hatırladı: “Horoz ötmeden, bu gece sen beni üç defa inkâr edeceksin.” ");
INSERT INTO turobt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bunun üzerine Petrus dışarı çıkıp acı acı ağladı. ");
INSERT INTO turobt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","İsaʼyı tutuklayan adamlar Oʼnunla alay ediyor, Oʼnu dövüyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gözlerini bağlayıp Oʼna ikide bir sordular: “Haydi peygamberliğini göster! Sana vuran kim?” ");
INSERT INTO turobt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Oʼna daha bir sürü aşağılayıcı söz söylediler. ");
INSERT INTO turobt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sabah olunca halkın liderleri toplandı. Toplantı başrahipler ve Tevrat uzmanlarından oluşuyordu. İsaʼyı Meclisleriʼnin önüne çıkarttılar. ");
INSERT INTO turobt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oʼna şöyle dediler: “Eğer sen Mesihʼsen, bize söyle.” İsa onlara şöyle cevap verdi: “Eğer size söylersem, kesinlikle inanmazsınız. ");
INSERT INTO turobt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ve eğer size bir şey sorarsam, kesinlikle cevap vermezsiniz. ");
INSERT INTO turobt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama bundan sonra İnsan Oğlu kudret sahibi olan Allahʼın sağında oturacak.” ");
INSERT INTO turobt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hepsi bir ağızdan şunu sordular, “Yani, sen Allahʼın Oğlu musun?” İsa onlara, “Söylediğiniz gibi, ben Oʼyum” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Artık şahitliğe ne ihtiyacımız var?” dediler. “Söylediklerini biz kendimiz Oʼnun ağzından işittik!” ");
INSERT INTO turobt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sonra toplantıdaki herkes kalkıp İsaʼyı Pilatusʼa götürdüler. ");
INSERT INTO turobt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Oʼnu suçlamaya başladılar. “Bu adam var ya!” dediler. “Milletimizi yoldan saptırırken yakaladık. Bir de Sezarʼa vergi ödenmesine karşı çıkıyor. Aynı zamanda kendisinin Mesih, yani kral olduğunu söylüyor.” ");
INSERT INTO turobt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus İsaʼya, “Sen Yahudilerin kralı mısın?” diye sordu. İsa ona şöyle cevap verdi: “Bunu sen söylüyorsun.” ");
INSERT INTO turobt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus başrahiplere ve kalabalığa, “Ben bu adamda hiçbir suç bulmuyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Onlar ise ısrarla şöyle dediler: “Bütün Yahudiyeʼde vaaz ederek halkı kışkırtıyor. Celileʼden başlayarak ta buraya kadar geldi.” ");
INSERT INTO turobt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus bunu duyunca, “Bu adam Celileʼden mi?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","İsaʼnın Hirodesʼin yetkisi altındaki bölgeden olduğunu öğrenince, Oʼnu Hirodesʼin yanına gönderdi. Çünkü Hirodes de o arada Yeruşalimʼdeydi. ");
INSERT INTO turobt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hirodes İsaʼyı görünce çok sevindi. Uzun zamandan beri Oʼnu görmek istiyordu. Çünkü Oʼnun hakkındaki haberleri duymuştu ve Oʼnun bir mucizesini görmeyi umut ediyordu. ");
INSERT INTO turobt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","İsaʼya birçok soru sordu. Ama İsa hiç cevap vermedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Başrahipler ve Tevrat uzmanları da orada durup İsaʼyı ağır dille suçladılar. ");
INSERT INTO turobt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirodes de askerleriyle birlikte İsaʼyı aşağılayıp alay etti. Sonra Oʼna gösterişli bir kaftan giydirip, Pilatusʼa geri yolladı. ");
INSERT INTO turobt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aynı gün Hirodes ile Pilatus arkadaş oldular. Daha önce birbirlerine düşmandılar. ");
INSERT INTO turobt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ondan sonra Pilatus başrahipleri, halkın liderlerini ve halkı bir araya çağırdı. ");
INSERT INTO turobt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Onlara şöyle dedi: “Siz bana bu adamı halkı saptıran biri diye getirdiniz. Ben de Oʼnu önünüzde sorguya çektim. Ama Oʼnu yüklediğiniz suçlamaların hiçbirinden suçlu bulmadım. ");
INSERT INTO turobt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Üstelik Hirodes de bir şey bulamadı, çünkü Oʼnu bize geri gönderdi. Bakın, adam ölümü hak edecek hiçbir şey yapmadı. ");
INSERT INTO turobt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Bunun için Oʼnu kamçılatıp, serbest bırakacağım.” ");
INSERT INTO turobt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ama onlar hep bir ağızdan şöyle bağırdılar: “Bu adamı yok et! Bize Barabbaʼyı serbest bırak!” ");
INSERT INTO turobt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabba şehirdeki ayaklanma ve adam öldürme suçları yüzünden cezaevine atılmıştı. ");
INSERT INTO turobt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus İsaʼyı serbest bırakmak istediği için sesini yükseltip onlarla bir daha konuştu. ");
INSERT INTO turobt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama onlar hep, “Oʼnu çarmıha ger, Oʼnu çarmıha ger!” diye bağrıştılar. ");
INSERT INTO turobt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus üçüncü defa, “Adam ne kötülük yaptı ki? Oʼnda ölüm cezasını hak eden hiçbir suç bulmadım. Bu nedenle Oʼnu kamçılatıp serbest bırakacağım” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Fakat onlar yüksek sesle bağırarak ısrarla İsaʼnın çarmıha gerilmesini istediler. Onların sesleri üstün geldi. ");
INSERT INTO turobt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatus da onların isteğini yerine getirmeye karar verdi. ");
INSERT INTO turobt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","İstedikleri kişiyi, Barabbaʼyı serbest bıraktı. O, ayaklanma ve adam öldürme suçları yüzünden hapishaneye atılmıştı. İsaʼyı da onların isteğine teslim etti. ");
INSERT INTO turobt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Askerler İsaʼyı götürürken, şehir dışından gelen Kireneli Simun adındaki adamı yakaladılar. İsaʼnın arkasından taşıması için çarmıhı sırtına yüklediler. ");
INSERT INTO turobt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Halktan büyük bir kalabalık İsaʼyla birlikte gidiyordu. Aralarında Oʼnun için ağlayıp dövünen kadınlar da vardı. ");
INSERT INTO turobt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","İsa onlara dönüp, “Ey Yeruşalim kızları” dedi. “Benim için ağlamayın, kendiniz ve çocuklarınız için ağlayın. ");
INSERT INTO turobt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Çünkü günler gelecek, insanlar şöyle diyecek: ‘Ne mutlu kısır kadınlara, hiç doğurmamış rahimlere ve hiç emzirmemiş memelere!’ ");
INSERT INTO turobt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","O zaman dağlara, ‘Üzerimize düşün!’ ve tepelere, ‘Bizi örtün!’ demeye başlayacaklar. ");
INSERT INTO turobt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Çünkü ağaç yaşken böyle yaparlarsa, kuru ağaca neler olacak?” ");
INSERT INTO turobt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ayrıca iki suçlu İsaʼyla birlikte ölüme götürülüyordu. ");
INSERT INTO turobt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kafatası denilen yere geldiler. Orada İsaʼyı ve suçluları birer çarmıha gerdiler. Suçlulardan biri İsaʼnın sağında, öbürü ise solundaydı. ");
INSERT INTO turobt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","O zaman İsa şöyle dedi: “Baba, onları bağışla. Çünkü ne yaptıklarını bilmiyorlar.” Askerler İsaʼnın elbiselerini aralarında paylaşmak için kura çektiler. ");
INSERT INTO turobt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Halk etrafta durmuş bakıyordu. Halkın liderleri de İsaʼyla alay ettiler. “Başkalarını kurtardı. Eğer O Allahʼın Mesihi, Allahʼın seçtiği kişiyse kendini de kurtarsın bakalım!” diyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Askerler de İsaʼyla alay ettiler. Yaklaşıp Oʼna ekşi şarap uzattılar. ");
INSERT INTO turobt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Eğer sen Yahudilerin kralıysan, kendini kurtar bakalım” dediler. ");
INSERT INTO turobt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","İsaʼnın başının üzerinde bir de şöyle bir yazı vardı: Yahudilerin Kralı budur. ");
INSERT INTO turobt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Çarmıha gerilmiş suçlulardan biri İsaʼyı aşağılamaya başladı. “Sen Mesih değil misin? Haydi kendini de bizi de kurtar!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama öbürü onu azarladı. “Sen Allahʼtan hiç mi korkmuyorsun?” diye karşılık verdi. “Sen de aynı ölüm cezasını çekiyorsun. ");
INSERT INTO turobt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aslında, biz haklı olarak ceza çekiyoruz. Yaptıklarımızın karşılığını alıyoruz. Ama bu adam hiçbir kötülük yapmadı.” ");
INSERT INTO turobt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sonra, “Ey İsa, kral olarak geldiğinde beni hatırla” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","İsa ona, “Sana doğrusunu söylüyorum, bugün benimle birlikte cennette olacaksın” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Saat aşağı yukarı öğlen on iki olmuştu. Saat üçe kadar bütün ülkenin üzerine karanlık çöktü. ");
INSERT INTO turobt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Güneş karardı. Tapınaktaki perde de ortadan yırtıldı. ");
INSERT INTO turobt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","O zaman İsa yüksek sesle şöyle bağırdı: “Baba, ruhumu senin ellerine teslim ediyorum!” Bunu söyledikten sonra son nefesini verdi. ");
INSERT INTO turobt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Oradaki yüzbaşı bunu görünce Allahʼı yüceltti ve şöyle dedi: “Bu adam gerçekten iyi bir insandı!” ");
INSERT INTO turobt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Büyük bir kalabalık olanları görmek için toplanmıştı. Olanları seyrettikten sonra göğüslerine vura vura evlerine döndüler. ");
INSERT INTO turobt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","İsaʼnın bütün tanıdıkları ve Oʼnunla beraber Celileʼden gelen kadınlar ise olanlara uzaktan bakıp duruyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Meclis üyelerinden Yusuf adında iyi ve doğru bir adam vardı. ");
INSERT INTO turobt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yusuf Yahudilerin Aramatya kasabasındandı. Meclisʼin kararına ve yaptıklarına hiç razı gelmemişti. Allahʼın Krallığıʼnı umutla bekleyen biriydi. ");
INSERT INTO turobt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatusʼa gidip İsaʼnın ölüsünü istedi. ");
INSERT INTO turobt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ondan sonra Oʼnu çarmıhtan indirip bir keten beze sardı. Kayanın içine oyulmuş bir mezara yatırdı. Oraya daha önce hiç kimse yatırılmamıştı. ");
INSERT INTO turobt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hazırlık Günüʼydü ve Şabat günü başlamak üzereydi. ");
INSERT INTO turobt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","İsaʼyla beraber Celileʼden gelmiş olan kadınlar Yusufʼu arkadan izlediler. Mezarı ve İsaʼnın cesedinin oraya nasıl koyulduğunu gördüler. ");
INSERT INTO turobt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sonra dönüp cenaze için güzel kokular ve hoş kokulu yağlar hazırladılar. Şabat gününde Allahʼın buyruğuna göre hiçbir iş yapmadılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pazar günü çok erkenden daha gün doğarken, kadınlar mezara gittiler. Hazırladıkları güzel kokuları yanlarına aldılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Taşı mezarın girişinden yuvarlanmış buldular. ");
INSERT INTO turobt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","İçeri girdiklerinde Rab İsaʼnın cesedini bulmadılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bu olaya şaşıp dururken, yanlarında aniden çok parlak elbiseler içinde iki adam durdu. ");
INSERT INTO turobt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kadınlar korkuyla başlarını yere eğdiler. Adamlar onlara, “Diri Olanʼı neden ölülerin arasında arıyorsunuz?” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“O burada yok. Dirildi. Hatırlarsınız, O daha Celileʼdeyken size şunu söylemişti: ");
INSERT INTO turobt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","İnsan Oğluʼnun günahlı adamların ellerine verilmesi, çarmıha gerilmesi ve üçüncü gün dirilmesi lazım.” ");
INSERT INTO turobt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","O zaman İsaʼnın sözlerini hatırladılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mezardan dönünce bütün bu şeyleri on bir öğrenciye ve diğer öğrencilere anlattılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bunları elçilere anlatanlar Mecdelli Meryem, Yohanna, Yakubʼun annesi olan Meryem ve onlarla beraber olan diğer kadınlardı. ");
INSERT INTO turobt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama bu sözler öğrencilere saçma geldi ve kadınlara inanmadılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Fakat Petrus kalkıp koşarak mezara gitti. Eğilip içeri baktı. Sadece keten sargı bezlerini gördü. Olanlara hayret ederek oradan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tam o günde öğrencilerin ikisi Emmaus adında bir köye gidiyordu. Yeruşalimʼden aşağı yukarı on bir kilometre uzaklıktaydı. ");
INSERT INTO turobt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bütün olup bitenleri aralarında konuşuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Onlar konuşup tartışırken, İsaʼnın kendisi yaklaştı, onlarla beraber yürümeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ama öğrencilerin gözleri Oʼnu tanımaktan alıkonuldu. ");
INSERT INTO turobt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","İsa onlara sordu, “Yürürken birbirinizle konuşup tartıştığınız şeyler neydi?” Onlar da durup üzgün üzgün bakıştılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","O zaman onlardan Kleopas adlı adam İsaʼya şöyle dedi: “Yeruşalimʼde misafir olan ve bu günlerde orada olup biten olaylardan haberi olmayan tek kişi sen misin?” ");
INSERT INTO turobt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O da onlara “Hangi olup bitenlerden?” diye sordu. Oʼna, “Nasıralı İsa hakkındaki olaylardan” dediler. “O, Allahʼın ve bütün halkın gözünde yaptıklarıyla ve söyledikleriyle gücünü gösteren bir peygamberdi. ");
INSERT INTO turobt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Oysa başrahipler ve halkımızın liderleri Oʼnu ölüm cezasına çarptırılması için Romalılara teslim ettiler. Onlar da Oʼnu çarmıha gerdiler. ");
INSERT INTO turobt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ama biz Oʼnun İsrail halkını esirlikten kurtaracak kişi olduğunu umuyorduk. Hem de bu olaylar olalı üç gün oldu. ");
INSERT INTO turobt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bu yetmezmiş gibi, aramızdan bazı kadınlar da bizi şaşırttı. Bu sabah erkenden mezara varmışlar. ");
INSERT INTO turobt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ama Oʼnun ölüsünü bulamamışlar. Dönüp olağanüstü bir görüntüde melekler gördüklerini anlattılar. Onlara görünen melekler, ‘İsa yaşıyor’ demiş. ");
INSERT INTO turobt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bizimle beraber olan birkaç kişi mezara gitmiş ve durumu kadınların anlattığı gibi bulmuşlar. Ama İsaʼnın kendisini görmemişler.” ");
INSERT INTO turobt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","İsa onlara şöyle dedi: “Sizi akılsız insanlar! Peygamberlerin söylediklerine iman etmekte ne kadar ağır davranıyorsunuz! ");
INSERT INTO turobt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mesihʼin bu acıları çekmesi ve sonra yüceliğine kavuşması lazım değil miydi?” ");
INSERT INTO turobt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bunun üzerine Musa ve bütün peygamberlerden başlayarak, Kutsal Yazılarʼın hepsinde kendisi hakkında yazılan şeyleri onlara açıkladı. ");
INSERT INTO turobt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Böylece gidecekleri köye yaklaştılar. Ama İsa kendisi sanki daha öteye gidecekmiş gibi yaptı. ");
INSERT INTO turobt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Onlarsa, “Bizimle kal, çünkü akşam oluyor, gün bitmek üzere” diyerek İsaʼyı zorladılar. Öylelikle onlarla beraber kalmak üzere içeri girdi. ");
INSERT INTO turobt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","İsa onlarla birlikte sofradayken eline ekmek aldı ve şükretti. Sonra ekmeği bölüp onlara vermeye başladı. ");
INSERT INTO turobt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","O vakit onların gözleri açıldı. Oʼnu tanıdılar. Ama İsa onların gözleri önünde kaybolup gitti. ");
INSERT INTO turobt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Birbirlerine şöyle dediler, “O bizimle yolda konuşup Kutsal Yazılarʼın anlamını açıklarken, yüreklerimiz yanıp tutuşuyordu, değil mi?” ");
INSERT INTO turobt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Onlar da aynı saatte kalkıp Yeruşalimʼe döndüler. On bir elçiyi ve onlarla beraber olanları toplanmış buldular. ");
INSERT INTO turobt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Elçiler ve diğerleri, “Rab gerçekten dirildi ve Simunʼa göründü” diyorlardı. ");
INSERT INTO turobt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gelen iki öğrenci öğrenci onlara yolda neler olduğunu ve ekmeği bölerken İsaʼyı nasıl tanıdıklarını anlatmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","İki öğrenci bu şeyleri anlatırken, birdenbire İsaʼnın kendisi öğrencilerinin ortasında durdu. “Size esenlik olsun!” dedi. ");
INSERT INTO turobt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Onlar ise ürküp korktular. Hayalet gördüklerini sandılar. ");
INSERT INTO turobt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","İsa onlara şöyle dedi: “Niçin telaşlanıyorsunuz? Yürekleriniz neden şüpheyle doluyor? ");
INSERT INTO turobt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ellerime, ayaklarıma bakın; işte benim! Bana dokunun da görün. Hayaletin eti kemiği yok, ama gördüğünüz gibi bende var.” ");
INSERT INTO turobt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bunları söyledikten sonra, İsa onlara ellerini ve ayaklarını gösterdi. ");
INSERT INTO turobt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Onlar hâlâ sevinçten inanamadılar. Şaşıp kaldılar. O zaman onlara sordu: “Burada yiyecek bir şeyiniz var mı?” ");
INSERT INTO turobt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ona bir parça kızarmış balık verdiler. ");
INSERT INTO turobt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","İsa balığı alıp gözlerinin önünde yedi. ");
INSERT INTO turobt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sonra onlara şöyle dedi: “Daha sizinle beraberken aynı şu sözleri size söylemiştim: Musaʼya verilen Tevratʼta, peygamberlerin kitaplarında ve Mezmurlar kitabında benim hakkımda yazılanların hepsinin yerine gelmesi lazım.” ");
INSERT INTO turobt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ondan sonra Kutsal Yazılarʼı anlayabilmeleri için zihinlerini açtı. ");
INSERT INTO turobt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Onlara şöyle dedi: “Kutsal Yazılarʼda, Mesih acı çekecek ve üçüncü gün ölümden dirilecek, diye yazılmıştır. ");
INSERT INTO turobt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","İnsanlar tövbeye davet edilecek; tövbe edenlerin günahları affedilecek. Bu Müjde, Yeruşalimʼden başlayarak bütün milletlere Mesihʼin adıyla duyurulacak. ");
INSERT INTO turobt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Siz bu şeylerin şahitlerisiniz. ");
INSERT INTO turobt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","İşte, Babamʼın vaat ettiğini size göndereceğim. Ama yukarıdan gelen güç üzerinize ininceye kadar bu şehirde kalın.” ");
INSERT INTO turobt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sonra İsa onları şehrin dışına, Beytanyaʼya kadar götürdü. Ellerini kaldırıp onlara bereket diledi. ");
INSERT INTO turobt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kendisi onları bereketlerken yanlarından ayrıldı, göğe yükseldi. ");
INSERT INTO turobt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Onlar da İsaʼya tapındılar. Sonra Yeruşalimʼe büyük bir sevinçle döndüler. ");
INSERT INTO turobt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Devamlı tapınakta bulunup Allahʼı övüyorlardı.");
INSERT INTO turobt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Başlangıçta Söz vardı, Söz Allahʼla birlikteydi ve Allah neyse Söz de Oʼydu. ");
INSERT INTO turobt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","O başlangıçta Allahʼla birlikteydi. ");
INSERT INTO turobt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Her şey Sözʼün aracılığıyla yaratıldı. Yaratılmış olan hiçbir şey Oʼnsuz var olmadı. ");
INSERT INTO turobt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yaşam kaynağı Oʼydu ve bu yaşam insanların ışığıydı. ");
INSERT INTO turobt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Işık karanlığı aydınlatır, karanlık ise ışığı söndüremedi. ");
INSERT INTO turobt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Allahʼın gönderdiği Yahya adlı bir adam vardı. ");
INSERT INTO turobt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yahya Işık için şahitlik etmeye geldi. Öyle ki, onun şahitliği sayesinde herkes iman etsin. ");
INSERT INTO turobt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yahya Işık değildi ama Işık için şahitlik etmeye geldi. ");
INSERT INTO turobt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bütün insanları aydınlatan gerçek Işık dünyaya geliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Söz dünyadaydı. Dünya Oʼnun aracılığıyla var oldu. Fakat dünya Oʼnu tanımadı. ");
INSERT INTO turobt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O kendi memleketine geldi, kendi halkı bile Oʼnu kabul etmedi. ");
INSERT INTO turobt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama Söz kendisini kabul edenlere Allahʼın evlatları olma hakkını verdi. Bunlar Oʼnun adına güvenen kişilerdi. ");
INSERT INTO turobt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Onlar kandan, bedenin isteğinden, ya da erkeğin isteğinden değil, Allahʼtan doğdular. ");
INSERT INTO turobt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Söz insan oldu, aramızda yaşadı. Biz de Oʼnun yüceliğini, Babaʼdan gelen biricik Oğulʼun yüceliğini gördük. O, lütuf ve gerçekle doludur. ");
INSERT INTO turobt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahya Oʼnun için şahitlik ederken yüksek sesle şunu söyledi: “ ‘Benden sonra gelen, benden üstündür, çünkü O benden önce vardı,’ dediğim kişi budur.” ");
INSERT INTO turobt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Evet hepimiz Oʼnun doluluğundan lütuf üzerine lütuf aldık. ");
INSERT INTO turobt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tevrat kanunları Musa aracılığıyla verildi, lütuf ve gerçek ise İsa Mesih aracılığıyla geldi. ");
INSERT INTO turobt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hiç kimse hiçbir zaman Allahʼı görmemiştir. Ama Babaʼnın bağrında olan ve kendisi Allah olan biricik Oğul Oʼnu tanıttı. ");
INSERT INTO turobt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yahudi liderler Yahyaʼya kim olduğunu sormak için Yeruşalimʼdenrahipler ve Levililer gönderdiler. Yahya şöyle şahitlik etti: ");
INSERT INTO turobt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“Ben Mesih değilim” dedi. Bunu hiç inkâr etmeden açıkça söyledi. ");
INSERT INTO turobt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yahyaʼya sordular: “O zaman ne diyorsun? İlyas peygamber misin?” O da, “Hayır” dedi. “Beklediğimiz peygamber misin?” Cevap olarak, “Hayır, değilim” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bunun üzerine ona şöyle dediler: “Sen kimsin? Bizi gönderenlere bir cevabımız olsun. Sen kendin için ne diyorsun?” ");
INSERT INTO turobt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yahya şöyle dedi: “Yeşaya Peygamberʼin söylediği gibi ben, ‘Rabbin yolunu düz yapın’, diye ıssız yerlerde sesini yükselten biriyim.” ");
INSERT INTO turobt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yahyaʼnın yanına gönderilen adamlar Ferisiydi. ");
INSERT INTO turobt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Onlar Yahyaʼya sordular: “Mademki sen ne Mesih, ne İlyas, ne de beklediğimiz peygambersin, o zaman niye vaftiz ediyorsun?” ");
INSERT INTO turobt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahya onlara şöyle cevap verdi: “Ben suyla vaftiz ediyorum. Ama aranızda tanımadığınız bir kişi duruyor. ");
INSERT INTO turobt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Benden sonra gelen Oʼdur. Ben Oʼnun ayaklarındaki sandalet bağlarını çözmeye layık değilim.” ");
INSERT INTO turobt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bu olaylar Şeria ırmağının öte tarafındaki Beytanya köyünde oldu. Yahya orada vaftiz ediyordu. ");
INSERT INTO turobt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yahya ertesi gün İsaʼnın kendisine doğru geldiğini gördü ve şöyle dedi: “Bakın, bu Allah Kuzusu, dünyanın günahını ortadan kaldıran! ");
INSERT INTO turobt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Oʼnun hakkında şöyle demiştim: ‘Benden sonra bir adam gelecek, O benden daha üstündür, çünkü benden önce vardı.’ ");
INSERT INTO turobt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ben Oʼnun kim olduğunu fark etmedim. Ama O, İsrail halkına tanıtılsın diye suyla vaftiz etmeye geldim.” ");
INSERT INTO turobt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahya şahitliğine şöyle devam etti: “Kutsal Ruhʼun gökten indiğini ve bir güvercin gibi Oʼnun üzerinde durduğunu gördüm. ");
INSERT INTO turobt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ben Oʼnun kim olduğunu fark etmedim. Ama suyla vaftiz etmek için beni gönderen Allah bana şöyle demişti: ‘Ruhʼun inip birinin üzerinde durduğunu göreceksin. İşte, Kutsal Ruhʼla vaftiz eden Oʼdur.’ ");
INSERT INTO turobt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ben de bunu gördüm ve şahitlik ediyorum ki, Allahʼın Oğlu budur.” ");
INSERT INTO turobt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yahya ertesi gün iki öğrencisiyle duruyordu. ");
INSERT INTO turobt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","İsa geçerken, Yahya Oʼna dikkatle bakarak şöyle dedi: “İşte, Allah Kuzusu!” ");
INSERT INTO turobt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yahyaʼnın iki öğrencisi onun bu sözünü duydular ve İsaʼnın peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","İsa arkasına dönüp onların kendisini izlediğini gördü. Onlara sordu: “Ne istiyorsunuz?” Onlar da şöyle dediler: “Ey Rabbi, nerede kalıyorsun?” Rabbi “öğretmenim” demektir. ");
INSERT INTO turobt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Onlara, “Gelin ve görün!” dedi. Gidip Oʼnun nerede kaldığını gördüler. Saat yaklaşık öğleden sonra dörttü. O gün Oʼnunla kaldılar. ");
INSERT INTO turobt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yahyaʼnın söylediklerini işiten ve İsaʼnın peşinden giden iki kişiden biri Simun Petrusʼun kardeşi Andreasʼtı. ");
INSERT INTO turobt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","O da önce gitti, kardeşi Simunʼu buldu ve ona şöyle dedi: “Biz Mesihʼi bulduk!” Mesih “meshedilmiş Kişi” demektir. ");
INSERT INTO turobt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas Simunʼu İsaʼnın yanına götürdü. İsa Simunʼa bakıp şöyle dedi: “Sen Yuhanna oğlu Simunʼsun. Ama adın artık Kefas olacak.” Kefasʼın Grekçesi “Taş” anlamına gelen Petrusʼtur. ");
INSERT INTO turobt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ertesi gün İsa Celile bölgesine gitmeye karar verdi. Filipusʼu buldu ve ona şöyle dedi: “Benim peşimden gel!” ");
INSERT INTO turobt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus aynı Andreas ve Petrus gibi Beytsayda kasabasındandı. ");
INSERT INTO turobt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus Natanelʼi bulup ona şöyle dedi: “Musaʼnın Tevratʼta ve peygamberlerin kitaplarında yazdığı Kişiʼyi bulduk. O Yusuf oğlu Nasıralı İsaʼdır.” ");
INSERT INTO turobt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanel ona: “Nasıra kasabasından iyi bir şey çıkabilir mi?” diye sordu. Filipus ona, “Gel de gör!” cevabını verdi. ");
INSERT INTO turobt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","İsa kendisine yaklaşan Natanelʼi gördü ve onun hakkında şöyle dedi: “Bakın, bu gerçek bir İsrailoğlu! İçinde hiç hile yok!” ");
INSERT INTO turobt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanel İsaʼya, “Sen beni nereden tanıyorsun?” diye sordu. İsa ona şöyle cevap verdi: “Filipus seni çağırmadan önce, seni incir ağacının altında gördüm.” ");
INSERT INTO turobt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanel İsaʼya şöyle dedi: “Öğretmenim, sen Allahʼın Oğluʼsun! İsrailʼin Kralıʼsın!” ");
INSERT INTO turobt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","İsa ona şöyle cevap verdi: “ ‘Seni o incir ağacının altında gördüm’ dediğim için mi iman ediyorsun? Sen bunlardan daha büyük şeyler göreceksin!” ");
INSERT INTO turobt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sonra sözlerine şöyle devam etti: “Size doğrusunu söylüyorum: göklerin açıldığını ve Allahʼın meleklerinin İnsan Oğluʼnun üzerine nasıl yükselip indiğini göreceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Üçüncü gün Celile bölgesindeki Kana köyünde bir düğün vardı. İsaʼnın annesi oradaydı. ");
INSERT INTO turobt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","İsaʼyla öğrencileri de o düğüne davetliydi. ");
INSERT INTO turobt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Şarap bitince, annesi İsaʼya “Şarapları kalmadı” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","İsa ona şöyle cevap verdi: “Bayan, benden ne istiyorsun? Benim saatim daha gelmedi.” ");
INSERT INTO turobt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Annesi hizmetkârlara şöyle dedi: “Size ne derse, onu yapın.” ");
INSERT INTO turobt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Orada altı tane taştan yapılmış su küpü duruyordu. Bunlar Yahudilerin temizlenmek adetleri için kullanılırdı. Her biri aşağı yukarı seksenle yüz yirmi litre arası su alırdı. ");
INSERT INTO turobt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","İsa hizmetkârlara, “Küpleri suyla doldurun!” dedi. Onlar da küpleri ağzına kadar doldurdular. ");
INSERT INTO turobt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sonra onlara şöyle dedi: “Şimdi sudan çekin ve başhizmetkâra götürün.” Onlar da götürdüler. ");
INSERT INTO turobt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Başhizmetkâr şarap olmuş suyu tattı. Onun nereden geldiğini bilmiyordu. Fakat suyu çeken hizmetkârlar biliyordu. O zaman başhizmetkâr damadı çağırdı. ");
INSERT INTO turobt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ona şöyle dedi: “Herkes önce iyi şarabı verir. Sonra misafirlerin gönlü hoş olunca daha düşük kaliteli şarabı verir. Oysa sen iyi şarabı şimdiye kadar saklamışsın.” ");
INSERT INTO turobt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Bu, İsaʼnın ilk mucizesiydi. Bunu Celile bölgesindeki Kana köyünde yaptı ve kendi yüceliğini gösterdi. Öğrencileri de Oʼna iman ettiler. ");
INSERT INTO turobt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bundan sonra İsa, annesi, kardeşleri ve öğrencileriyle birlikte Kefernahum kasabasına gitti. Orada birkaç gün kaldılar. ");
INSERT INTO turobt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yahudilerin Özgürlük Bayramı yaklaşmıştı. İsa da Yeruşalimʼe gitti. ");
INSERT INTO turobt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tapınak avlusunda sığır, koyun ve güvercin satanları, orada oturmuş para bozanları gördü. ");
INSERT INTO turobt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","İsa iplerden bir kamçı yapıp hepsini, hem koyunları hem de sığırları tapınaktan kovdu. Yabancı para değiştirenlerin masalarını devirdi ve paralarını yere döktü. ");
INSERT INTO turobt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Güvercin satanlara da şöyle dedi: “Bunları buradan kaldırın! Babamʼın evini pazar yerine çevirmeyin!” ");
INSERT INTO turobt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bu olay İsaʼnın öğrencilerine Kutsal Yazılarʼda yazılan şu sözleri hatırlattı: “Senin evin için gösterdiğim gayret beni yiyip bitirecek.” ");
INSERT INTO turobt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yahudi liderler de Oʼna cevap olarak şöyle dediler: “Bunları yapmaya yetkili olduğunu gösteren nasıl bir mucize yapacaksın?” ");
INSERT INTO turobt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","İsa onlara şu cevabı verdi: “Bu tapınağı yıkın. Üç günde onu yeniden kuracağım.” ");
INSERT INTO turobt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yahudi liderler de şöyle dediler: “Bu tapınak kırk altı yılda yapıldı, sen onu üç günde mi yeniden kuracaksın?” ");
INSERT INTO turobt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aslında İsaʼnın sözünü ettiği tapınak, kendi bedeniydi. ");
INSERT INTO turobt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","İsa ölümden dirilince, öğrencileri bunu söylediğini hatırladılar. Kutsal Yazıʼya ve İsaʼnın söylemiş olduğu söze inandılar. ");
INSERT INTO turobt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","İsa Özgürlük Bayramı için Yeruşalimʼde kaldı. Birçok kişi Oʼnun yaptığı mucizeleri görerek Oʼnun adına inandı. ");
INSERT INTO turobt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Fakat İsa onlara güvenmiyordu. Çünkü herkesin niyetini biliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","İnsan tabiatı hakkında hiç kimsenin şahitliğine ihtiyacı yoktu. Çünkü insanın içinden geçenleri biliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ferisiler arasında Yahudi liderlerinden Nikodim adlı bir adam vardı. ");
INSERT INTO turobt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nikodim gece İsaʼnın yanına geldi ve şöyle dedi: “Rabbi! Senin Allahʼtan gelmiş bir öğretmen olduğunu biliyoruz. Çünkü eğer Allah onunla olmazsa hiç kimse senin yaptığın bu mucizeleri yapamaz.” ");
INSERT INTO turobt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","İsa ona şöyle cevap verdi: “Sana doğrusunu söylüyorum, bir kimse yeniden doğmadıkça Allahʼın Krallığıʼnı göremez.” ");
INSERT INTO turobt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodim Oʼna şöyle dedi: “Yaşlı adam nasıl doğabilir? Annesinin rahmine ikinci kez girip doğamaz ya!” ");
INSERT INTO turobt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","İsa şöyle cevap verdi: “Sana doğrusunu söylüyorum, bir kimse sudan ve Ruhʼtan doğmadıkça Allahʼın Krallığıʼna giremez. ");
INSERT INTO turobt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bedenden doğan bedendir. Ruhʼtan doğan ruhtur. ");
INSERT INTO turobt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sana ‘Yeniden doğmalısınız’ dediğime şaşma. ");
INSERT INTO turobt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rüzgâr istediği yerde eser. Sesini işitirsin, ama nereden geliyor, nereye gidiyor bilmezsin. İşte, Ruhʼtan doğan herkes de böyledir.” ");
INSERT INTO turobt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodim İsaʼya şunu sordu: “Bu söylediklerin nasıl olabilir?” ");
INSERT INTO turobt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","İsa şöyle cevap verdi: “Sen İsrailʼin öğretmenisin. Nasıl olur da bunları bilmiyorsun? ");
INSERT INTO turobt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sana doğrusunu söylüyorum, bildiğimizi söylüyoruz ve gördüğümüze şahitlik ediyoruz. Fakat siz şahitliğimizi kabul etmiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Size yer hakkında dediklerime inanmazsanız, gök hakkında dediklerime nasıl inanacaksınız? ");
INSERT INTO turobt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gökten inmiş olan İnsan Oğluʼndan başka hiç kimse göğe çıkmadı. ");
INSERT INTO turobt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tıpkı Musaʼnın ıssız yerlerde tunç yılanı yukarı kaldırdığı gibi, İnsan Oğlu da yukarı kaldırılmalı. ");
INSERT INTO turobt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Öyle ki, Oʼna iman eden herkes sonsuz yaşama kavuşsun.” ");
INSERT INTO turobt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Allah dünyayı o kadar sevdi ki, biricik Oğluʼnu verdi. Öyle ki, her kim Oʼna iman ederse mahvolmasın ama sonsuz yaşama kavuşsun. ");
INSERT INTO turobt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Çünkü Allah, Oğluʼnu dünyaya insanları yargılamak için göndermedi. Fakat dünya Oʼnun aracılığıyla kurtulsun diye gönderdi. ");
INSERT INTO turobt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kim Oʼna iman ederse yargılanmaz, ama kim iman etmezse zaten yargılandı. Çünkü Allahʼın biricik Oğluʼnun adına iman etmedi. ");
INSERT INTO turobt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yargı da şudur: Işık dünyaya geldi, ama insanlar karanlığı ışıktan daha çok sevdi, çünkü yaptıkları kötüydü. ");
INSERT INTO turobt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Devamlı kötülük yapan herkes ışıktan nefret eder. Işığa gelmez, çünkü yaptıklarının açığa çıkmasını istemez. ");
INSERT INTO turobt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Fakat kim gerçeğe uyarak yaşarsa, ışığa gelir. Öyle ki, onun yaptıklarının Allahʼtan olduğu belli olsun. ");
INSERT INTO turobt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bundan sonra İsa kendi öğrencileriyle birlikte Yahudiye topraklarına gitti. Orada onlarla bir süre kaldı ve insanları vaftiz etti. ");
INSERT INTO turobt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahya Salim kasabasına yakın olan Aynon köyünde vaftiz ediyordu, çünkü orada bol su vardı. Halk ona gelip vaftiz oluyordu. ");
INSERT INTO turobt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yahya daha hapishaneye atılmamıştı. ");
INSERT INTO turobt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","O sırada Yahyaʼnın öğrencileriyle bir Yahudi arasında dini temizlik konusunda tartışma çıktı. ");
INSERT INTO turobt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sonra öğrencileri Yahyaʼnın yanına geldiler ve ona şöyle dediler: “Öğretmenim, Şeria ırmağının karşı tarafında seninle birlikte olan ve kendisi için şahitlik ettiğin kişi vaftiz ediyor ve herkes Oʼna gidiyor.” ");
INSERT INTO turobt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahya şöyle cevap verdi: “Allah vermedikçe insan hiçbir şey alamaz. ");
INSERT INTO turobt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Ben Mesih değilim. Oʼnun önünden gönderildim’ dediğime siz şahitsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gelin kime aitse damat odur. Damadın arkadaşı, yanında durup onu dinler. Damadın sesini işitince sevinçle coşar. Böylece benim sevincim tam oldu. ");
INSERT INTO turobt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","O yücelmeli, bense küçülmeliyim.” ");
INSERT INTO turobt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Gökten gelen, herkesten üstündür. Dünyaya ait olan dünyadandır ve dünyadan bahseder. Gökten gelen herkesten üstündür. ");
INSERT INTO turobt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O ne görmüş ve işitmişse buna şahitlik eder, ama şahitliğini kimse kabul etmez. ");
INSERT INTO turobt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Şahitliğini kabul eden ise, Allahʼın gerçeği söylediğine mühür basmış olur. ");
INSERT INTO turobt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Allahʼın gönderdiği Kişi Allahʼın sözlerini duyurur. Çünkü Allah Oʼna Ruhuʼnu ölçüsüz verir. ");
INSERT INTO turobt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","BabaOğulʼu sever, ve her şeyi Oʼnun eline teslim etmiştir. ");
INSERT INTO turobt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oğulʼa iman edenin sonsuz yaşamı vardır. Ama Oğulʼa itaat etmeyen, yaşamı görmeyecek. Allahʼın öfkesi böylesinin üzerinde kalır. ");
INSERT INTO turobt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ferisiler İsaʼnın Yahyaʼdan daha çok öğrenci toplayıp vaftiz ettiğini duymuşlardı. ");
INSERT INTO turobt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aslında İsaʼnın kendisi değil, Oʼnun öğrencileri vaftiz ediyordu. ");
INSERT INTO turobt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","İsa Ferisilerin duyduklarını öğrenince Yahudiye bölgesinden ayrılıp Celile bölgesine dönmek için yola çıktı. ");
INSERT INTO turobt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Fakat önce Samiriye bölgesinden geçmesi lazımdı. ");
INSERT INTO turobt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Böylece Samiriyeʼnin Sihar adlı bir kasabasına geldi. Burası Yakubʼun, oğlu Yusufʼa vermiş olduğu tarlaya yakındı. ");
INSERT INTO turobt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakubʼun kuyusu da oradaydı. İsa yolculuktan yorulduğu için kuyunun başına oturdu. Öğle vaktiydi. ");
INSERT INTO turobt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samiriyeli bir kadın su çekmeye geldi. İsa ona şöyle dedi: “Bana su ver, içeyim.” ");
INSERT INTO turobt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","O sırada İsaʼnın öğrencileri yiyecek almak için kasabaya gitmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Bunun üzerine Samiriyeli kadın Oʼna dedi ki, “Sen Yahudisin, bense Samiriyeli bir kadınım. Nasıl olur da benden su istersin? Çünkü Yahudiler Samiriyelilerle aynı kabı kullanmazlar.” ");
INSERT INTO turobt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","İsa ona şöyle cevap verdi: “Allahʼın sana neler verebileceğinden haberin yok. Sana ‘Bana su ver, içeyim’ diyenin kim olduğunu da bilmiyorsun. Bilseydin, Oʼndan isterdin, O da sana yaşam suyunu verirdi.” ");
INSERT INTO turobt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kadın Oʼna şöyle dedi: “Efendim, kuyu derin, su çekecek kovan da yok. Bu yaşam suyuna nereden sahip oluyorsun? ");
INSERT INTO turobt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bu kuyuyu bize atamız Yakub vermiş. Kendisi, çocukları ve hayvanları da bu kuyudan içmişler. Sen ondan daha büyük değilsin ya!” ");
INSERT INTO turobt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","İsa ona şöyle cevap verdi: “Bu sudan içen herkes tekrar susayacak. ");
INSERT INTO turobt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Fakat benim vereceğim sudan içen bir daha susamayacak. Ona vereceğim su, içinde fışkıran, ona sonsuz yaşam veren bir pınar olacak.” ");
INSERT INTO turobt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kadın Oʼna, “Efendim, bu suyu bana ver” dedi. “Böylece ne susayayım ne de su çekmek için buraya kadar geleyim.” ");
INSERT INTO turobt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","İsa ona, “Git, kocanı çağır ve buraya dön” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kadın Oʼna cevap olarak, “Kocam yok” dedi. İsa ona, “ ‘Kocam yok’ demekle doğruyu söyledin” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Çünkü beş kocaya vardın. Şimdi beraber yaşadığın adam da kocan değil. Söylediğin doğru.” ");
INSERT INTO turobt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kadın Oʼna şöyle dedi: “Efendim, anlıyorum ki, sen bir peygambersin. ");
INSERT INTO turobt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Atalarımız Allahʼa bu dağda tapındılar. Fakat siz Yahudiler diyorsunuz ki, Allahʼa tapınacak yer Yeruşalimʼde.” ");
INSERT INTO turobt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","İsa ona şöyle dedi: “Bayan, bana inan, öyle bir saat geliyor ki, Babaʼya ne bu dağda, ne de Yeruşalimʼde tapınacaksınız. ");
INSERT INTO turobt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Siz bilmediğinize tapınıyorsunuz. Biz bildiğimize tapınıyoruz. Çünkü kurtuluş Yahudilerdendir. ");
INSERT INTO turobt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama öyle bir saat geliyor ki, yürekten tapınanlar Babaʼya ruhla ve gerçekte tapınacaklar. Çünkü Baba kendisine böyle tapınanları arıyor. İşte o saat şimdidir. ");
INSERT INTO turobt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Allah ruhtur, Oʼna tapınanların ruhla ve gerçekte tapınmaları gerekir.” ");
INSERT INTO turobt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kadın İsaʼya şöyle dedi: “Biliyorum ki, Mesih diye bilinen meshedilmiş Kişi geliyor. O gelince, bize her şeyi bildirecek.” ");
INSERT INTO turobt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","İsa ona şöyle dedi: “Seninle konuşan ben, Oʼyum.” ");
INSERT INTO turobt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","O anda İsaʼnın öğrencileri geri döndüler. Oʼnun bir kadınla konuştuğuna şaşırıp kaldılar. Ama hiçbiri “Ne istiyorsun?” ya da, “Bu kadınla neden konuşuyorsun?” demedi. ");
INSERT INTO turobt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bunun üzerine kadın su kabını bırakıp kasabaya döndü ve oradakilere şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Gelin, yaptığım her şeyi bana söyleyen adamı görün. Acaba bu Mesih olabilir mi?” ");
INSERT INTO turobt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Halk kasabadan çıkıp İsaʼnın yanına geliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bu arada öğrencileri Oʼna “Öğretmenimiz, bir şey yemez misin?” diye yalvardılar. ");
INSERT INTO turobt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama İsa onlara şöyle dedi: “Sizin hiç bilmediğiniz bir yemeğim var.” ");
INSERT INTO turobt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Öğrencileri birbirlerine, “Acaba biri Oʼna yiyecek mi getirdi?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","İsa onlara şöyle dedi: “Benim yiyeceğim, beni Gönderenʼin istediğini yerine getirmek ve bana verdiği işi tamamlamaktır. ");
INSERT INTO turobt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Siz, ‘Ekinleri biçmeye daha dört ay var’ demiyor musunuz? İşte, size söylüyorum ki, başınızı kaldırın ve tarlalara bakın. Ekinler zaten sararmış, biçmeye hazır. ");
INSERT INTO turobt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kim onları biçerse, ücretini alır ve sonsuz yaşam için ürün toplar. Öyle ki, eken ve biçen birlikte sevinsin. ");
INSERT INTO turobt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Çünkü şu söz doğrudur: ‘Biri eker, başkası biçer.’ ");
INSERT INTO turobt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ben sizi, çalışmadığınız yerde biçmeye gönderiyorum. Başkaları çalıştı, sizse onların işine kondunuz.” ");
INSERT INTO turobt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","İsa hakkında, “Yaptığım her şeyi bana söyledi” diye şahitlik eden kadının sözü sayesinde o kasabadan birçok Samiriyeli İsaʼya iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samiriyeliler de İsaʼya gelip yanlarında kalması için rica ettiler. O da orada iki gün kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Oʼnun konuşmasını işiten daha birçok kişi iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kadına da şöyle dediler: “İmanımız artık senin söylediklerine dayanmıyor. Çünkü Oʼnu kendimiz işittik ve biliyoruz ki, gerçekten dünyanın kurtarıcısı Oʼdur.” ");
INSERT INTO turobt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","İki gün geçtikten sonra İsa oradan ayrıldı ve Celile bölgesine döndü. ");
INSERT INTO turobt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Daha önce İsaʼnın kendisi şöyle şahitlik etti: “Peygamber kendi memleketinde saygı görmez.” ");
INSERT INTO turobt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Celile bölgesine vardığı zaman, Celileliler Oʼnu iyi karşıladılar. Yeruşalimʼde bayram zamanında yapmış olduğu her şeyi gördüler, çünkü onlar da oraya gitmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","İsa tekrar Celileʼnin Kana köyüne geldi. Bu köyde suyu şaraba çevirmişti. Orada kralın hizmetinde görevli bir adam vardı. Oğlu Kefernahum şehrinde hastaydı. ");
INSERT INTO turobt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Adam, İsaʼnın Yahudiye bölgesinden Celile bölgesine geldiğini işitti. Hemen ayrılıp İsaʼnın yanına gitti. İsaʼnın yetişip oğlunu iyileştirmesi için yalvardı, çünkü oğlu ölüm döşeğindeydi. ");
INSERT INTO turobt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","İsa ona şöyle dedi: “Siz mucizeler ve harikalar görmedikçe hiç iman etmeyeceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kralın hizmetindeki adam Oʼna şöyle dedi: “Efendim, evladım ölmeden yetiş!” ");
INSERT INTO turobt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","İsa ona, “Evine dön, oğlun yaşıyor” dedi. Adam İsaʼnın kendisine söylediği söze inanıp ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","O henüz yolda iken, köleleri onu karşıladı ve “Oğlun yaşıyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Adam çocuğun iyileşmeye başladığı saati sordu. Onlar da şöyle cevap verdiler: “Dün, öğleyin saat birde ateşi düştü.” ");
INSERT INTO turobt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baba, bunun İsaʼnın “Oğlun yaşıyor” dediği saat olduğunu anladı. Bunun üzerine hem kendisi hem de bütün ev halkı iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bu, İsaʼnın Yahudiyeʼden Celileʼye tekrar geldikten sonra yaptığı ikinci mucizeydi. ");
INSERT INTO turobt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bu olaylardan sonra, Yahudilerin bir bayramı vardı. İsa da Yeruşalimʼe gitti. ");
INSERT INTO turobt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yeruşalimʼde Koyun Kapısıʼnın yanında beş kemeraltı olan bir havuz vardı. Aramiceʼde adı Beytesdaʼdır. ");
INSERT INTO turobt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Bu kemeraltlarında yatan birçok hasta, kör, topal ve eli ayağı tutmayan insan vardı. ");
INSERT INTO turobt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Otuz sekiz yıldan beri hasta olan bir adam da oradaydı. ");
INSERT INTO turobt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","İsa onu orada yatarken gördü. Adamın uzun zamandan beri bu vaziyette olduğunu biliyordu. Ona, “İyi olmak ister misin?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hasta adam Oʼna şöyle cevap verdi: “Efendim, sular çalkalanınca, beni havuza indirecek kimsem yok. Ben daha yoldayken başkası benden önce iniyor.” ");
INSERT INTO turobt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","İsa ona şöyle dedi: “Kalk, döşeğini al ve yürü!” ");
INSERT INTO turobt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Adam hemen iyileşti, döşeğini kaldırdı ve yürümeye başladı. Ne var ki, o gün Şabat günüydü. ");
INSERT INTO turobt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bu nedenle Yahudi liderler iyileşmiş olan adama şöyle dediler: “Bugün Şabat günü. Döşeğini kaldırman yasak!” ");
INSERT INTO turobt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Adam onlara şu cevabı verdi: “Beni iyileştiren kişi, bana, ‘Döşeğini kaldır ve yürü’ dedi.” ");
INSERT INTO turobt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bunun üzerine, “ ‘Döşeğini kaldır ve yürü’ diyen adam kim?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Fakat şifa bulan adam bunu söyleyenin kim olduğunu bilmiyordu. Çünkü orası kalabalıktı. İsa da çekilip gitmişti. ");
INSERT INTO turobt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bu olaylardan sonra İsa adamı tapınakta buldu ve ona şöyle dedi: “Bak, iyi oldun. Artık günah işleme ki, senin başına daha kötü bir şey gelmesin.” ");
INSERT INTO turobt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Adam gidip kendisine şifa verenin İsa olduğunu Yahudi liderlere bildirdi. ");
INSERT INTO turobt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bu yüzden Yahudi liderler İsaʼyı sıkıştırmaya başladılar. Çünkü bu şeyleri Şabat gününde yapıyordu. ");
INSERT INTO turobt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ama İsa onlara şöyle cevap verdi: “Babam hâlâ çalışıyor; ben de çalışıyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bu nedenle Yahudi liderler İsaʼyı öldürmek için daha da çok çaba gösterdiler. Çünkü yalnız Şabat gününü bozmakla kalmıyor, “Allah Babamʼdır” diyerek kendini Allahʼa eşit kılıyordu. ");
INSERT INTO turobt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Böylece İsa onlara cevap olarak şöyle dedi: “Size doğrusunu söylüyorum, Oğul kendiliğinden hiçbir iş yapamaz. Ancak Babaʼdan gördüğünü yapar. Baba ne yaparsa Oğul da aynısını yapar. ");
INSERT INTO turobt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Çünkü Baba Oğulʼu sever ve yaptığı her şeyi Oʼna gösterir. Şaşıp kalasınız diye Oʼna bunlardan daha büyük işler de gösterecek. ");
INSERT INTO turobt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Baba nasıl ölüleri diriltip yaşam verirse, Oğul da istediği kişilere yaşam verir. ");
INSERT INTO turobt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baba hiç kimseyi yargılamaz, bütün yargılama işini Oğulʼa verdi. ");
INSERT INTO turobt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Öyle ki, herkes Babaʼya gösterdiği aynı saygıyı Oğulʼa da göstersin. Oğulʼa saygı göstermeyen, Oʼnu gönderen Babaʼya da saygı göstermez. ");
INSERT INTO turobt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Size doğrusunu söylüyorum, Sözümü işiten ve beni göndermiş Olanʼa iman eden kişi sonsuz yaşama sahip olur. Böyle biri yargılanmaz, ama ölümden yaşama geçmiştir. ");
INSERT INTO turobt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Size doğrusunu söylüyorum, öyle bir saat geliyor ki, ölüler Allahʼın Oğluʼnun sesini işitecekler ve bu sesi işitenler yaşam bulacaklar. O saat geldi bile! ");
INSERT INTO turobt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Çünkü Baba yaşam kaynağı olduğu gibi, Oğulʼu da yaşam kaynağı yaptı. ");
INSERT INTO turobt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Oʼna yargılama yetkisini de verdi. Çünkü O İnsan Oğluʼdur. ");
INSERT INTO turobt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Buna şaşmayın. Mezardaki herkesin Oʼnun sesini işiteceği saat geliyor. ");
INSERT INTO turobt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","O zaman mezarlarından çıkacaklar. İyilik yapmış olanlar yaşamak için dirilecek, fakat kötülük yapmış olanlar yargılanmak için dirilecekler. ");
INSERT INTO turobt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ben kendiliğimden bir şey yapamam. İşittiğim gibi yargılarım ve yargım doğrudur. Çünkü kendi isteğimi değil, beni Gönderenʼin isteğini yerine getiririm. ");
INSERT INTO turobt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ben kendim için şahitlik edersem, şahitliğim geçerli olmaz. ");
INSERT INTO turobt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Benim için şahitlik eden başka biri var. Benim için ettiği şahitliğin geçerli olduğunu biliyorum. ");
INSERT INTO turobt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Siz Yahyaʼya adamlar gönderdiniz. O da gerçeğe şahitlik etti. ");
INSERT INTO turobt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ben bunları, insan şahitliğini kabul ettiğim için değil, siz kurtulasınız diye söylüyorum. ");
INSERT INTO turobt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahya yanan ve aydınlık veren bir lambaydı. Sizler de bir süre onun ışığında sevinmek istediniz. ");
INSERT INTO turobt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama benim Yahyaʼnınkinden daha önemli bir şahitliğim var. Babaʼnın tamamlamam için bana verdiği işler, şu yaptığım işler beni Babaʼnın gönderdiğine şahitlik ediyor. ");
INSERT INTO turobt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Beni gönderen Baba da benim için şahitlik etmiştir. Siz hiçbir zaman Oʼnun sesini işitmediniz, Oʼnu yüz yüze görmediniz. ");
INSERT INTO turobt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Oʼnun sözü içinizde kalmıyor. Çünkü Oʼnun gönderdiği Kişiʼye inanmıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kutsal Yazılarʼı araştırıyorsunuz, çünkü bunlar sayesinde sonsuz yaşama sahip olduğunuzu sanıyorsunuz. Oysa bana şahitlik eden de bunlardır. ");
INSERT INTO turobt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yine de yaşama sahip olmak için bana gelmek istemiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ben insanlardan övgü beklemiyorum. ");
INSERT INTO turobt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Fakat sizi bilirim, içinizde Allah sevgisi yoktur. ");
INSERT INTO turobt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ben Babamʼınadıyla geldim ve beni kabul etmiyorsunuz. Ama başka biri kendi adıyla gelirse onu kabul edeceksiniz. ");
INSERT INTO turobt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Siz birbirinizden övgü bekliyorsunuz. Ama tek olan Allahʼtan gelen övgüyü kazanmaya çalışmıyorsunuz. Öyleyse, nasıl iman edebilirsiniz? ");
INSERT INTO turobt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sizi Babaʼnın önünde suçlayacağımı sanmayın. Sizi suçlayan başka biri var, o da umut bağladığınız Musaʼdır. ");
INSERT INTO turobt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musaʼnın yazdıklarına inansaydınız bana da inanırdınız. Çünkü o benim hakkımda yazmıştır. ");
INSERT INTO turobt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama mademki onun yazdıklarına inanmıyorsunuz, benim sözlerime nasıl inanacaksınız?” ");
INSERT INTO turobt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bir süre sonra İsa Celile Gölüʼnün, yani Taberiye Gölüʼnün karşı tarafına geçti. ");
INSERT INTO turobt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Büyük bir kalabalık İsaʼnın peşinden gidiyordu. Çünkü Oʼnun hastalara yaptığı mucizeleri görmüşlerdi. ");
INSERT INTO turobt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","İsa bir tepeye çıkıp orada öğrencileriyle birlikte oturdu. ");
INSERT INTO turobt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yahudilerin Özgürlük Bayramı yakındı. ");
INSERT INTO turobt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","İsa başını kaldırdı ve büyük bir kalabalığın kendisine doğru geldiğini gördü. Bunun için Filipusʼa, “Bu insanların yiyeceği ekmeği nereden alalım?” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","İsa bunu Filipusʼu denemek için söyledi. Aslında kendisi ne yapacağını biliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus Oʼna şöyle cevap verdi: “Herkesin birer lokma yiyebileceği kadar ekmek almaya iki yüz gümüş para bile yetmez.” ");
INSERT INTO turobt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","İsaʼnın öğrencilerinden, Simun Petrusʼun kardeşi olan Andreas, Oʼna şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Burada beş arpa ekmeğiyle iki balığı olan bir çocuk var. Ama bu kadar kişi için bunlar nedir ki?” ");
INSERT INTO turobt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","İsa, “İnsanları yere oturtun” dedi. Yer çayırlıktı. Onlar da oraya oturdular. Aralarındaki erkeklerin sayısı aşağı yukarı beş bindi. ");
INSERT INTO turobt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sonra İsa ekmekleri aldı, şükredip oturanlara dağıttı. Aynı şekilde balıklardan da istedikleri kadar verdi. ");
INSERT INTO turobt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Onlar doyacak kadar yedikten sonra İsa öğrencilerine şöyle dedi: “Artakalan yemek parçalarını toplayın. Hiçbir şey ziyan olmasın!” ");
INSERT INTO turobt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Böylece artakalan parçaları topladılar. Yemek yiyen insanlardan artan beş arpa ekmeğinin parçalarıyla on iki sepet doldurdular. ");
INSERT INTO turobt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","İnsanlar İsaʼnın yaptığı mucizeyi görünce şöyle dediler: “Gerçekten dünyaya gelecek olan peygamber budur.” ");
INSERT INTO turobt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","İsa onların gelip Oʼnu kral yapmak için zorla götüreceklerini biliyordu. Bu yüzden tekrar yalnız başına tepeye çekildi. ");
INSERT INTO turobt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Akşam olunca, İsaʼnın öğrencileri göl kıyısına indiler. ");
INSERT INTO turobt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tekneye binip gölün karşı tarafındaki Kefernahumʼa doğru yol aldılar. Artık karanlık çökmüştü, İsa da henüz yanlarına gelmemişti. ");
INSERT INTO turobt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Üstelik güçlü bir rüzgarın esmesiyle gölde dalgalar yükseliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Öğrenciler aşağı yukarı beş kilometre kürek çektikten sonra, İsaʼnın gölün üzerinde yürüdüğünü ve tekneye yaklaştığını gördüler. Çok korktular. ");
INSERT INTO turobt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Fakat İsa onlara, “Benim! Korkmayın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bunun üzerine Oʼnu tekneye almak istediler. Tekne de hemen gidecekleri yere vardı. ");
INSERT INTO turobt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ertesi gün, gölün karşı tarafında duran halk orada sadece bir tekne bulunduğunu fark etti. İsaʼnın öğrencileriyle birlikte tekneye binmediğini ve öğrencilerinin Oʼnsuz yola çıktığını da anladılar. ");
INSERT INTO turobt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Öte yandan Taberiye şehrinden başka tekneler, Rab İsaʼnın şükretmesinden sonra ekmek yedikleri yere yaklaştı. ");
INSERT INTO turobt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Halk İsaʼnın ve öğrencilerinin orada olmadığını görünce, o teknelere binip İsaʼyı aramak için Kefernahumʼa gitti. ");
INSERT INTO turobt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","İsaʼyı gölün karşı tarafında bulunca Oʼna şunu sordular: “Öğretmenimiz, buraya ne zaman geldin?” ");
INSERT INTO turobt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","İsa onlara şöyle cevap verdi: “Size doğrusunu söylüyorum, beni mucizeleri gördüğünüz için aramıyorsunuz, ekmeklerden yiyip doyduğunuz için arıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Geçip giden yiyecek için çalışmayın. Sonsuz yaşama kadar kalacak olan yiyecek için çalışın. Bunu size İnsan Oğlu verecek. Çünkü Baba Allah Oʼna bu yetkiyi vermiştir.” ");
INSERT INTO turobt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oʼna şunu sordular, “Peki ne yapmalıyız? Allahʼın bizden beklediği şeyleri nasıl yerine getiririz?” ");
INSERT INTO turobt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","İsa onlara şöyle cevap verdi: “Allahʼın sizden beklediği şey Oʼnun gönderdiği Kişiʼye iman etmenizdir.” ");
INSERT INTO turobt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bunun üzerine Oʼna dediler: “O zaman sen nasıl bir mucize yapacaksın ki, biz onu görüp sana inanalım? Evet, ne yapacaksın? ");
INSERT INTO turobt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atalarımız ıssız yerlerde man yediler. Aynı yazıldığı gibi: ‘Yemeleri için onlara gökten ekmek verdi.’ ” ");
INSERT INTO turobt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bunun üzerine İsa onlara şöyle dedi: “Size doğrusunu söylüyorum, size gökten ekmek veren Musa değildi. Fakat gökten gelen asıl ekmeği size Babam verir. ");
INSERT INTO turobt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Çünkü Allahʼın ekmeği gökten inen ve dünyaya yaşam verendir.” ");
INSERT INTO turobt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","O zaman İsaʼya, “Efendimiz, bize her zaman bu ekmeği ver!” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","İsa onlara şöyle dedi: “Yaşam ekmeği benim. Bana gelen asla acıkmaz, bana iman eden asla susamaz. ");
INSERT INTO turobt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Fakat size söylediğim gibi, beni gördünüz, yine de iman etmiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Babaʼnın bana verdiklerinin hepsi bana gelecek. Bana geleni de asla geri çevirmem. ");
INSERT INTO turobt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Çünkü ben kendi isteğimi değil, beni Gönderenʼin isteğini yerine getirmek için gökten indim. ");
INSERT INTO turobt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Beni Gönderenʼin isteği şudur: Bana verdiklerinden hiçbirini kaybetmeyeyim, ama onları son günde dirilteyim. ");
INSERT INTO turobt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Çünkü Babamʼın istediği, Oğulʼu gören ve Oʼna iman eden herkesin sonsuz yaşama kavuşmasıdır. Ben de böylelerini son günde dirilteceğim.” ");
INSERT INTO turobt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Gökten inmiş olan ekmek benim” dediği için oradaki Yahudiler İsaʼya karşı homurdanmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Birbirlerine şöyle dediler: “Bu Yusuf oğlu İsa değil mi? Annesini babasını tanıyoruz, değil mi? Nasıl olur da şimdi, ‘Ben gökten indim’ diyor?” ");
INSERT INTO turobt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","İsa onlara şöyle cevap verdi: “Aranızda homurdanmayın. ");
INSERT INTO turobt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eğer beni gönderen Baba bir kimseyi bana çekmezse, o kimse bana gelemez. Ben de o kişiyi son günde dirilteceğim. ");
INSERT INTO turobt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Peygamberlerin kitaplarında şöyle yazılıdır: ‘Onların hepsi Allah tarafından eğitilecek.’ Babaʼdan işitip öğrenen herkes bana gelir. ");
INSERT INTO turobt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bu, bir kimsenin Babaʼyı gördüğü anlamına gelmez. Sadece Allahʼtan gelmiş Olan Babaʼyı görmüştür. ");
INSERT INTO turobt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Size doğrusunu söylüyorum, bana iman eden sonsuz yaşama sahiptir. ");
INSERT INTO turobt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yaşam ekmeği benim. ");
INSERT INTO turobt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Atalarınız ıssız yerlerde man yediler ve öldüler. ");
INSERT INTO turobt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gökten inen öyle bir ekmek var ki, ondan yiyen ölmeyecek. ");
INSERT INTO turobt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gökten inmiş diri ekmek benim. Bu ekmekten yiyen kişi sonsuza dek yaşayacak. Benim vereceğim ekmek de kendi bedenimdir. Ben onu dünyanın hayat bulması için vereceğim.” ");
INSERT INTO turobt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bunun üzerine Yahudiler birbirleriyle çekişmeye başladılar. “Bu adam bize yemek için kendi bedenini nasıl verebilir?” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bu yüzden İsa onlara şöyle dedi: “Size doğrusunu söylüyorum, İnsan Oğluʼnun bedenini yemez ve Oʼnun kanını içmezseniz sizde yaşam yoktur. ");
INSERT INTO turobt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kim bedenimi yerse ve kanımı içerse, onun sonsuz yaşamı olur. Ben onu son günde dirilteceğim. ");
INSERT INTO turobt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Çünkü bedenim asıl yiyecek ve kanım asıl içecektir. ");
INSERT INTO turobt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kim bedenimi yer ve kanımı içerse, o bende kalır, ben de onda. ");
INSERT INTO turobt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Beni gönderen, yaşam kaynağı olan Babaʼdır. Ben Baba sayesinde yaşıyorum. Tıpkı bunun gibi, beni yiyen de benim sayemde yaşayacak. ");
INSERT INTO turobt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gökten inmiş olan ekmek budur. Atalarınızın man yemesi gibi değildir. Onlar yediler ve öldüler. Oysa bu ekmeği yiyen sonsuza kadar yaşayacak.” ");
INSERT INTO turobt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","İsa bunları, Kefernahumʼda Yahudilerin toplantı yerinde vaaz ederken söyledi. ");
INSERT INTO turobt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","İsaʼnın öğrencilerinden birçok kişi bunu işitip şöyle dediler: “Bu çok çetin bir söz. Onu kim kabul edebilir?” ");
INSERT INTO turobt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","İsa yüreğinde öğrencilerinin bunun hakkında homurdandıklarını fark etti. Onlara şöyle dedi: “Bu söylediklerim sizi gücendiriyor mu? ");
INSERT INTO turobt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ya İnsan Oğluʼnun önceden bulunduğu yere tekrar çıktığını görseniz ne olur? ");
INSERT INTO turobt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yaşam veren Allahʼın Ruhuʼdur, insan çabası bunu hiç başaramaz. Size söylediğim sözler Ruh ve yaşamdır. ");
INSERT INTO turobt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ne var ki, aranızda iman etmeyen kişiler var.” İsa kimlerin iman etmediklerini ve kimin Oʼna ihanet edeceğini baştan biliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Şöyle devam etti: “İşte, bunun için size demiştim ki, Babam fırsat vermedikçe, hiç kimse bana gelemez.” ");
INSERT INTO turobt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bunun üzerine öğrencilerinin birçoğu geri döndü. Artık İsaʼyla dolaşmıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Bu sebeple İsa on iki elçisine şunu sordu: “Siz de mi ayrılmak istiyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simun Petrus Oʼna şöyle cevap verdi: “Efendimiz, biz ayrılıp kime gidelim? Sonsuz yaşam veren sözler sendedir. ");
INSERT INTO turobt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","İnandık ve artık biliyoruz ki, Allahʼın Kutsal Mesihi sensin.” ");
INSERT INTO turobt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","İsa ona şöyle cevap verdi: “Siz on iki elçimi ben seçmedim mi? Yine de içinizden biri iblistir.” ");
INSERT INTO turobt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","İsa, Simun İskariyotʼun oğlu Yahudaʼdan söz ediyordu. O, on iki elçiden biri olduğu halde İsaʼya ihanet edecekti. ");
INSERT INTO turobt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bir süre sonra İsa Celile bölgesinde dolaşmaya başladı. Yahudiyeʼde dolaşmak istemiyordu, çünkü Yahudi liderler Oʼnu öldürmek için fırsat arıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yahudilerin Çardak Bayramı yakındı. ");
INSERT INTO turobt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bu yüzden İsaʼnın kardeşleri Oʼna şöyle dediler: “Buradan ayrıl, Yahudiyeʼye git. Öyle ki, öğrencilerin yaptığın mucizeleri görsünler. ");
INSERT INTO turobt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Çünkü halk tarafından tanınmak isteyen kimse yaptıklarını gizlemez. Mademki bu işleri yapıyorsun, kendini dünyaya göster.” ");
INSERT INTO turobt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aslında kardeşleri bile Oʼna iman etmiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bu yüzden İsa onlara şöyle dedi: “Benim için uygun vakit daha gelmedi. Ama sizin için her vakit uygun. ");
INSERT INTO turobt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dünya sizden nefret edemez. Ama benden nefret ediyor. Çünkü dünyanın yaptıklarının kötü olduğuna şahitlik ediyorum. ");
INSERT INTO turobt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Siz bu bayramı kutlamaya gidin. Ben gitmiyorum, çünkü benim vaktim daha gelmedi.” ");
INSERT INTO turobt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","İsa bunları söyledikten sonra, Celileʼde kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kardeşleri bayramı kutlamaya gittikten sonra İsa da gitti. Ancak bunu açıkça değil, gizli olarak yaptı. ");
INSERT INTO turobt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yahudi liderler İsaʼyı bayram kutlaması sırasında aradılar. “O adam nerede?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kalabalıklar arasında birçok kişi İsa hakkında mırıldanıyordu. Bazıları, “O iyi bir adam” diyordu. Başkaları ise, “Hayır, O halkı aldatıyor” diyordu. ");
INSERT INTO turobt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Fakat hiç kimse Oʼnun hakkında açıkça konuşmuyordu, çünkü Yahudi liderlerden korkuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bayramın yarısı geçmişti. İsa tapınak avlusuna gidip vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudi liderler de şaşırıp kaldılar. “Bu adam eğitim görmediği halde nasıl bu kadar çok şey biliyor?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","İsa onlara şöyle cevap verdi: “Benim öğrettiklerim aslında benim değil, beni göndermiş Olanʼındır. ");
INSERT INTO turobt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Eğer bir kimse Allahʼın isteğini yerine getirmek istiyorsa, öğrettiklerimin Allahʼtan mı olduğunu, yoksa kendi adıma mı konuştuğumu bilecek. ");
INSERT INTO turobt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kendi adına konuşan kendini yüceltmek ister. Ancak kendisini göndereni yüceltmek isteyen doğruyu söyler, hiç yalan söylemez. ");
INSERT INTO turobt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa size Tevratʼı vermedi mi? Fakat hiçbiriniz Tevrat kanunlarını yerine getirmiyor. Neden beni öldürmek için fırsat arıyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kalabalık Oʼna şöyle cevap verdi: “Seni cin çarpmış! Kim seni öldürmek istiyor?” ");
INSERT INTO turobt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","İsa onlara şöyle cevap verdi: “Bir mucize yaptım ve hepiniz şaşırıp kaldınız. ");
INSERT INTO turobt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa erkek çocuklarınızı sünnet etmenizi buyurdu ve siz Şabat gününde bile sünnet edersiniz. Aslında sünnet Musaʼdan değil, atalarınızdan kalmadır. ");
INSERT INTO turobt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Demek ki, Musaʼya verilen Tevratʼın buyruğu bozulmasın diye, Şabat gününde bir erkek çocuk sünnet oluyor. Öyleyse Şabat gününde bir adamı tamamen iyileştirdim diye, bana neden kızıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dış görünüşe bakarak yargılamayın, yargınız doğru olsun.” ");
INSERT INTO turobt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yeruşalim halkından bazıları şöyle dediler: “Öldürmeye çalıştıkları adam bu değil mi? ");
INSERT INTO turobt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bakın, açıkça konuşuyor, Oʼna bir şey demiyorlar. Yoksa gerçekten liderler Oʼnu Mesih olarak kabul ettiler mi? ");
INSERT INTO turobt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Fakat biz bu adamın nereden geldiğini biliyoruz. Oysa Mesih geldiği zaman Oʼnun nereden geldiğini kimse bilmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","İsa tapınakta vaaz ederken yüksek sesle şöyle dedi: “Hem beni tanıyorsunuz, hem de nereden geldiğimi biliyorsunuz. Ben kendiliğimden gelmedim. Fakat beni Gönderen gerçektir. Sizlerse Oʼnu tanımıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ben Oʼnu tanıyorum, çünkü Oʼndanım ve beni O gönderdi.” ");
INSERT INTO turobt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Onlar bu yüzden İsaʼyı yakalamak için fırsat arıyorlardı. Ama kimse Oʼna el sürmedi, çünkü Oʼnun saati daha gelmemişti. ");
INSERT INTO turobt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama kalabalıktan birçok kişi İsaʼya iman etti ve şöyle dediler: “Mesih gelince bu adamın yaptığından daha mı çok mucize yapacak?” ");
INSERT INTO turobt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ferisiler halkın İsa hakkında bu şeyleri fısıldadığını işittiler. Böylece başrahipler ve Ferisiler İsaʼyı yakalamak için tapınak polislerini yolladılar. ");
INSERT INTO turobt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","İsa konuşmasına şöyle devam etti: “Sizinle kısa bir süre daha kalacağım. Ondan sonra beni Gönderenʼe döneceğim. ");
INSERT INTO turobt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Beni arayacaksınız ama bulmayacaksınız. Çünkü benim bulunacağım yere siz gelemezsiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudi liderler aralarında şöyle konuştular: “Bu adam nereye gidecek de biz Oʼnu bulamayacağız? Acaba diğer milletler arasında yaşayan Yahudilere mi gidecek? Greklere mi vaaz edecek? ");
INSERT INTO turobt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Beni arayacaksınız ama bulmayacaksınız’ ve ‘Benim bulunacağım yere siz gelemezsiniz?’ dedi. Bu söz ne demektir?” ");
INSERT INTO turobt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bayramın sonuncu ve en önemli günü İsa ayağa kalkıp yüksek sesle şöyle dedi: “Bir kimse susamışsa bana gelsin ve içsin. ");
INSERT INTO turobt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kutsal Yazıʼda yazıldığı gibi, kim bana iman ederse, onun içinden yaşam veren su ırmakları akacak.” ");
INSERT INTO turobt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","İsa bu sözü kendisine iman edenlerin kavuşacakları Kutsal Ruh hakkında söyledi. Kutsal Ruh henüz verilmemişti, çünkü İsa henüz yüceltilmemişti. ");
INSERT INTO turobt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Halktan bazı insanlar bu sözleri işitince şöyle konuştular, “Gerçekten bu adam beklediğimiz peygamberdir.” ");
INSERT INTO turobt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bazıları da, “Bu Mesihʼtir” dediler. Başkaları ise şöyle konuştu: “Mesih Celile bölgesinden gelir mi hiç? ");
INSERT INTO turobt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kutsal Yazı Mesihʼin Davudʼun soyundan olup Davudʼun kasabası olan Beytlehemʼden geleceğini bildirmemiş miydi?” ");
INSERT INTO turobt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bunun üzerine halkın arasında İsa hakkında ayrılık çıktı. ");
INSERT INTO turobt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Onlardan bazıları Oʼnu yakalamak istediler. Ama kimse Oʼna el sürmedi. ");
INSERT INTO turobt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sonra polisler geri döndüler. Başrahipler ve Ferisiler onlara, “Onu neden getirmediniz?” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Polisler şöyle cevap verdiler: “Hiçbir insan hiçbir zaman bu adam gibi konuşmamıştır.” ");
INSERT INTO turobt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ferisiler onlara şöyle çıkıştılar: “Yoksa siz de mi aldandınız? ");
INSERT INTO turobt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Liderlerden ya da Ferisilerden Oʼna iman eden oldu mu hiç? ");
INSERT INTO turobt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama Tevrat kanunlarını bilmeyen bu halk lanetlidir!” ");
INSERT INTO turobt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","İsaʼya daha önce gelen ve onlardan biri olan Nikodim onlara şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kanunlarımıza göre bir adamı dinlemeden, ne yaptığını öğrenmeden onu yargılamak doğru mu?” ");
INSERT INTO turobt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ona cevap olarak şöyle dediler: “Yoksa sen de mi Celileʼdensin? Araştır ve gör: Celileʼden peygamber çıkmaz.” ");
INSERT INTO turobt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sonra herkes evine döndü. ");
INSERT INTO turobt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","İsa ise Zeytin Dağıʼna gitti, ");
INSERT INTO turobt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ama sabah erkenden tekrar tapınak avlusuna döndü. Bütün halk Oʼnun yanına geliyordu. İsa oturup onlara vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tevrat uzmanları ile Ferisiler, İsaʼya zinada yakalanmış bir kadın getirdiler. Kadını orta yere çıkararak İsaʼya şöyle dediler: ");
INSERT INTO turobt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Ey öğretmen! Bu kadın tam zina ederken yakalandı. ");
INSERT INTO turobt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musa bize Tevratʼta böyle kadınların taşlanmasını buyurmuştur. Peki, sen ne dersin?” ");
INSERT INTO turobt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bunu İsaʼyı zor duruma düşürmek için söylediler. Oʼnu suçlayacak bir bahane arıyorlardı. Ama İsa eğildi ve parmağıyla yere bir şeyler yazmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Oʼna aynı soruyu sormaya devam ettiler. O zaman İsa doğrulup onlara şöyle dedi: “Aranızda kim günahsızsa, kadına ilk taşı o atsın.” ");
INSERT INTO turobt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ardından yere eğilip toprağa yazmaya devam etti. ");
INSERT INTO turobt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Onlar bunu işitince önce yaşlılar olmak üzere teker teker oradan ayrıldılar. Böylece İsa yalnız bırakıldı. Kadın da orta yerde duruyordu. ");
INSERT INTO turobt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","İsa doğrulup kadına şöyle dedi: “Bayan, onlar nerede? Seni suçlu bulan olmadı mı?” ");
INSERT INTO turobt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kadın şöyle cevap verdi: “Hiç kimse, efendim!” İsa, “Ben de seni suçlamıyorum” dedi. “Git, artık günah işleme.” ");
INSERT INTO turobt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","İsa halkla tekrar konuştu. Şöyle dedi: “Dünyanın ışığı benim. Benim peşimden gelen asla karanlıkta yürümez, ama yaşam veren ışığa sahip olur.” ");
INSERT INTO turobt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bu yüzden Ferisiler Oʼna şöyle dediler: “Sen kendin için şahitlik ediyorsun. Şahitliğin geçerli değil.” ");
INSERT INTO turobt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","İsa onlara cevap olarak şöyle dedi: “Ben kendim için şahitlik ediyorsam bile, şahitliğim geçerlidir. Çünkü nereden geldiğimi ve nereye gideceğimi biliyorum. Fakat siz nereden geldiğimi ve nereye gideceğimi bilmiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Siz insan gözüyle yargılıyorsunuz, ama ben kimseyi yargılamam. ");
INSERT INTO turobt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yargılasam bile, benim yargılamam geçerlidir. Çünkü ben yalnız değilim. Beni gönderen Babaʼyla birlikteyim. ");
INSERT INTO turobt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ayrıca size verilen Tevratʼta iki kişinin şahitliği geçerlidir diye yazılıdır. ");
INSERT INTO turobt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kendim için şahitlik ediyorum, hem de beni gönderen Baba benim için şahitlik ediyor.” ");
INSERT INTO turobt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","O zaman İsaʼya, “Baban nerede?” diye sordular. İsa şöyle cevap verdi: “Ne beni tanıyorsunuz, ne de Babamʼı. Beni tanımış olsaydınız, Babamʼı da tanırdınız.” ");
INSERT INTO turobt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","İsa bu sözleri tapınak avlusunda, bağış toplanan yerde vaaz ederken söyledi. Ama kimse Oʼnu yakalamadı, çünkü Oʼnun saati daha gelmemişti. ");
INSERT INTO turobt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","İsa onlara şöyle dedi: “Ben gidiyorum. Beni arayacaksınız ve günahınızın içinde öleceksiniz. Benim gideceğim yere siz gelemezsiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bunun üzerine Yahudi liderler şöyle dediler: “Acaba kendini mi öldürecek? Onun için mi, ‘Benim gideceğim yere siz gelemezsiniz’ diyor?” ");
INSERT INTO turobt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","İsa da onlara şöyle dedi: “Siz aşağıdansınız, ben yukarıdanım. Siz bu dünyadansınız, ben bu dünyadan değilim. ");
INSERT INTO turobt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","İşte bunun için, ‘Günahlarınızın içinde öleceksiniz’ dedim. Ben benim. Buna iman etmezseniz, günahlarınızın içinde öleceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bunun üzerine Oʼna, “Sen kimsin?” dediler. İsa onlara şöyle cevap verdi: “Size baştan beri ne dedimse Oʼyum. ");
INSERT INTO turobt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sizin için söyleyecek ve hakkınızda yargılayacak çok şeyim var. Ama beni Gönderen doğruyu söyler. Oʼndan işittiklerimi dünyaya bildiriyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kendilerine Baba Allah hakkında konuştuğunu anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bu yüzden İsa şöyle dedi: “İnsan Oğluʼnu yukarı kaldırdığınız zaman anlayacaksınız ki, Ben benim. Kendiliğimden hiçbir şey yapmıyorum, ama Babaʼnın bana öğrettiği gibi konuşuyorum. ");
INSERT INTO turobt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Beni Gönderen benimle birliktedir. O beni yalnız bırakmadı. Çünkü her zaman Oʼnu memnun eden şeyleri yapıyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","İsa bunları söyleyince birçok kişi Oʼna iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","İsa, kendisine inanmış Yahudilere şunu söyledi: “Siz benim sözümü devamlı yerine getirirseniz, gerçekten öğrencilerim olursunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gerçeği bileceksiniz, gerçek de sizi özgür kılacak.” ");
INSERT INTO turobt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Oʼna şöyle karşılık verdiler: “Biz İbrahimʼin soyundanız. Hiçbir zaman kimseye köle olmadık. Nasıl olur da sen, ‘Özgür olacaksınız’ diyorsun?” ");
INSERT INTO turobt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","İsa onlara cevap verdi: “Size doğrusunu söylüyorum, günah işleyen herkes günahın kölesidir. ");
INSERT INTO turobt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Köle ailede devamlı kalmaz, oğulsa devamlı kalır. ");
INSERT INTO turobt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bu sebeple Oğul sizi özgür kılarsa, mutlaka özgür olursunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","İbrahimʼin soyundan olduğunuzu biliyorum. Oysa beni öldürmek istiyorsunuz. Çünkü kalbinizde sözüme yer vermiyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Babamʼın yanında gördüklerimi anlatıyorum. Siz de babanızdan işittiklerinizi yapıyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","İsaʼya karşılık verdiler: “Bizim babamız İbrahimʼdir.” İsa onlara şunları söyledi: “Siz İbrahimʼin evlatları olsaydınız, İbrahim gibi davranırdınız. ");
INSERT INTO turobt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Oysa şimdi beni, Allahʼtan işittiği gerçeği size bildireni öldürmeye fırsat arıyorsunuz. İbrahim böyle yapmadı. ");
INSERT INTO turobt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Siz babanız gibi davranıyorsunuz.” Bunun üzerine Oʼna şöyle dediler: “Biz zinadan doğmadık. Tek bir babamız var. O da Allahʼtır.” ");
INSERT INTO turobt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","İsa onlara cevap verdi: “Allah sizin babanız olsaydı, beni severdiniz. Çünkü ben Allahʼtan çıkıp geldim. Kendiliğimden gelmedim. Beni O gönderdi. ");
INSERT INTO turobt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Benim söylediklerimi neden anlamıyorsunuz? Sözümü dinlemeye dayanamıyorsunuz da ondan. ");
INSERT INTO turobt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Siz babanız İblisʼtensiniz. Babanızın isteklerini yapmayı seviyorsunuz. O baştan beri katildir. Gerçeğe bağlı kalmadı, çünkü onda gerçek yoktur. O yalan söylediği zaman kendi özünden konuşur. Çünkü o hem yalancı hem de yalanın babasıdır. ");
INSERT INTO turobt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Fakat gerçeği söylediğim için bana inanmıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sizlerden kim günah işlediğimi kanıtlayabilir? Madem gerçeği söylüyorum, neden bana inanmıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Allahʼtan olan kişi Allahʼın sözlerini dinler. Siz bu yüzden dinlemiyorsunuz, çünkü Allahʼtan değilsiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudiler Oʼna cevap olarak şöyle dediler: “Senin cinli bir Samiriyeli olduğunu söylemekte haklı değil miyiz?” ");
INSERT INTO turobt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","İsa şöyle cevap verdi: “Ben cinli değilim. Ama Babamʼa saygı gösteriyorum. Siz ise bana saygısızlık ediyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ben kendimi yüceltmeye çalışmıyorum. Beni yücelten ve haklı çıkaran biri var. ");
INSERT INTO turobt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Size doğrusunu söylüyorum, eğer bir kimse sözüme uyarsa, ölümü asla görmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bunun üzerine Yahudiler İsaʼya şöyle dediler: “Evet, şimdi biliyoruz ki, seni cin çarpmış. İbrahim öldü, peygamberler de öldü. Sen yine de diyorsun ki, ‘Eğer bir kimse sözüme uyarsa, ölümü asla tatmayacak.’ ");
INSERT INTO turobt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sen bizim atamız İbrahimʼden daha mı büyüksün? İbrahim öldü. Peygamberler de öldü. Sen kendini kim sanıyorsun?” ");
INSERT INTO turobt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","İsa şöyle cevap verdi: “Ben kendimi yüceltirsem, benim yüceliğim bir hiçtir. Ama beni yücelten, kendisine ‘Allahımız’ dediğiniz Babamʼdır. ");
INSERT INTO turobt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Siz Oʼnu tanımıyorsunuz, ama ben Oʼnu tanıyorum. ‘Eğer ben Oʼnu tanımıyorum’ desem, ben de sizin gibi yalancı olurum. Ama ben Oʼnu tanıyorum, ve Oʼnun sözüne uyuyorum. ");
INSERT INTO turobt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atanız İbrahim geleceğim günü göreceği için sevinçle coştu. Gördü ve sevindi.” ");
INSERT INTO turobt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bunu duyan Yahudiler Oʼna şöyle dediler: “Sen daha elli yaşına bile gelmedin. İbrahimʼi de mi gördün?” ");
INSERT INTO turobt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","İsa onlara, “Size doğrusunu söylüyorum: İbrahim doğmadan önce ben varım” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bunun üzerine İsaʼya atmak için ellerine taşlar aldılar. Ama İsa saklandı ve tapınaktan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","İsa yoldan geçerken doğuştan kör bir adam gördü. ");
INSERT INTO turobt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Öğrencileri de Oʼna sordular: “Öğretmenimiz, kim günah işledi de, bu adam kör olarak doğdu? Kendisi mi, yoksa annesi babası mı?” ");
INSERT INTO turobt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","İsa onlara cevap verdi: “Ne bu adam, ne de annesi babası günah işledi. Ama yalnız Allahʼın yapabildiği şeyler onda görülsün diye, ");
INSERT INTO turobt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","beni Gönderenʼin yapmak istediği şeyleri vakit daha gündüzken yapmalıyız. Gece yaklaşıyor, o zaman hiç kimse çalışamaz. ");
INSERT INTO turobt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dünyada bulundukça dünyanın ışığı benim.” ");
INSERT INTO turobt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bu şeyleri söyledikten sonra İsa yere tükürdü, tükürükten çamur yaptı ve çamuru kör adamın gözlerine sürdü. ");
INSERT INTO turobt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sonra adama şöyle dedi: “Git, Şiloah Havuzuʼnda yıkan.” Şiloah, “gönderilmiş” demektir. Böylece adam gidip yıkandı, geri döndüğünde gözleri görüyordu. ");
INSERT INTO turobt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Adamın komşuları ve daha önce dilendiğini görenler şöyle dediler: “Oturup dilencilik yapan adam bu değil mi?” ");
INSERT INTO turobt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bazı kişiler “Evet, odur” dediler. Başkalarıysa “Hayır, ama ona benziyor” dediler. Kendisi ise “Ben oyum” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ona sordular: “Öyleyse, gözlerin nasıl açıldı?” ");
INSERT INTO turobt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O da şöyle cevap verdi: “İsa adındaki adam çamur yaptı, gözlerime sürdü. Bana ‘Şiloah Havuzuʼna git ve yıkan’ dedi. Ben de gidip yıkandım ve gözlerim açıldı.” ");
INSERT INTO turobt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Adama, “Nerede O?” diye sordular. O da, “Bilmiyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Önceden kör olan adamı Ferisilere götürdüler. ");
INSERT INTO turobt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","İsaʼnın çamur yaptığı ve adamın gözlerini açtığı gün Şabat günüydü. ");
INSERT INTO turobt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bu nedenle Ferisiler adama gözlerinin nasıl açıldığını tekrar sordular. Adam onlara şöyle dedi: “Gözlerime çamur sürdü, yıkandım ve görüyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bunun üzerine bazı Ferisiler şöyle dediler: “Madem bu adam Şabat günü hakkındaki buyruklara uymuyor, Allahʼtan olamaz.” Başkaları ise şöyle dedi: “Günahlı bir adam nasıl böyle mucizeler yapabilir?” Böylece Ferisiler ikiye bölündü. ");
INSERT INTO turobt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eskiden kör olan adama tekrar sordular: “Senin gözlerini açan bu adam hakkında sen ne dersin?” Adam, “O bir peygamberdir” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yahudi liderler, adamın annesiyle babasını çağırıncaya kadar, onun eskiden kör olup gözlerinin açıldığına inanmadılar. ");
INSERT INTO turobt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Kör doğdu dediğiniz oğlunuz bu mu? Peki, nasıl oluyor da şimdi görüyor?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Annesi babası şöyle cevap verdiler: “Bu bizim oğlumuzdur. Kör doğduğunu da biliyoruz. ");
INSERT INTO turobt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Fakat şimdi nasıl gördüğünü bilmiyoruz. Gözlerini kimin açtığını da bilmiyoruz. Ona sorun. Kendisi için konuşacak yaştadır.” ");
INSERT INTO turobt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Adamın annesiyle babası Yahudi liderlerden korktukları için böyle konuştular. Çünkü Yahudi liderler İsaʼnın Mesih olduğunu açıkça söyleyen herkesi toplantı yerlerinden kovmak için anlaşmışlardı. ");
INSERT INTO turobt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bu yüzden adamın annesiyle babası, “Kendisi için konuşacak yaştadır” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bunun üzerine eskiden kör olan adamı ikinci defa çağırıp, “Allahʼın hakkı için doğru olanı söyle!” dediler, “Biz biliyoruz ki, bu adam günahkârdır.” ");
INSERT INTO turobt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Adam şöyle cevap verdi: “O günahkâr mı, değil mi, bilmiyorum. Tek bir şey biliyorum: kördüm, ama şimdi görüyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ona tekrar sordular: “O sana ne yaptı? Senin gözlerini nasıl açtı?” ");
INSERT INTO turobt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Adam onlara cevap verdi: “Size zaten söyledim, ama dinlemediniz. Niye bunu bir daha duymak istiyorsunuz? Yoksa siz de mi Oʼnun öğrencileri olmak istiyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ona söverek şöyle dediler: “Oʼnun öğrencisi sensin. Bizse Musaʼnın öğrencileriyiz. ");
INSERT INTO turobt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Biz Allahʼın Musaʼyla konuştuğunu biliyoruz. Ama bu adamın nereden geldiğini bilmiyoruz.” ");
INSERT INTO turobt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Adam onlara şöyle cevap verdi: “Bu şaşılacak şey! Oʼnun nereden geldiğini siz bilmiyorsunuz, ama O gözlerimi açtı. ");
INSERT INTO turobt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Biliyoruz ki, Allah günahkârlara kulak vermez. Tam tersine, bir kişi Allahʼtan korkarsa ve Oʼnun istediğini yaparsa, Allah ona kulak verir. ");
INSERT INTO turobt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dünya var olalı kimsenin anadan doğma kör birinin gözlerini açtığı duyulmadı. ");
INSERT INTO turobt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bu adam Allahʼtan olmasaydı, hiçbir şey yapamazdı.” ");
INSERT INTO turobt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Onu terslediler: “Sen büsbütün günah içinde doğmuşsun. Sen mi kalkıp bize ders vereceksin?” Böylece onu toplantı yerinden kovdular. ");
INSERT INTO turobt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","İsa Yahudi liderlerin adamı toplantı yerinden kovduklarını duydu. Onu bulunca, “Sen İnsan Oğluʼna iman ediyor musun?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Adam cevap verdi: “Efendim, O kimdir? Söyle de, Oʼna iman edeyim.” ");
INSERT INTO turobt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","İsa ona şöyle dedi: “Oʼnu zaten gördün ve şimdi seninle konuşan Oʼdur.” ");
INSERT INTO turobt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Adam da, “Ey Efendim, iman ediyorum” dedi ve İsaʼya tapındı. ");
INSERT INTO turobt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","İsa da şöyle dedi: “Ben hüküm için bu dünyaya geldim. Öyle ki, görmeyenler görsün, görenler de kör olsun.” ");
INSERT INTO turobt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","İsaʼnın yanında bulunan bazı Ferisiler bunu işitince, “Yoksa biz de mi körüz?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","İsa onlara şöyle dedi: “Kör olsaydınız, günahınız olmazdı. Fakat madem, ‘Görüyoruz’ diyorsunuz, günahınız duruyor.” ");
INSERT INTO turobt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Size doğrusunu söylüyorum, koyun ağılına kapıdan girmeyen, ama başka bir yerden tırmanıp giren kişi hırsız ve hayduttur. ");
INSERT INTO turobt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kapıdan girense, koyunların çobanıdır. ");
INSERT INTO turobt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bekçi ona kapıyı açar. Koyunlar çobanın sesini işitir. O da koyunlarını adlarıyla çağırır ve onları dışarıya çıkarır. ");
INSERT INTO turobt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Koyunlarının hepsini dışarıya çıkardıktan sonra, onların önünden gider. Koyunlar da onu izler, çünkü onun sesini tanırlar. ");
INSERT INTO turobt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Fakat yabancı bir kişiyi asla izlemezler. Ondan kaçarlar, çünkü yabancıların sesini tanımazlar.” ");
INSERT INTO turobt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","İsa Ferisilere bu benzetmeyi anlattı, ama onlar ne demek istediğini anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bu nedenle İsa onlarla tekrar konuştu: “Size doğrusunu söylüyorum: koyunların kapısı benim. ");
INSERT INTO turobt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Benden önce gelenlerin hepsi hırsız ve hayduttu. Ama koyunlar onların sesine kulak asmadılar. ");
INSERT INTO turobt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kapı benim: bir kişi benden içeri girerse, kurtulur. Girer, çıkar ve otlak bulur. ");
INSERT INTO turobt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hırsız yalnız çalmak, öldürmek ve yok etmek için gelir. Ama ben insanlar yaşama, bereketli yaşama kavuşsunlar diye geldim. ");
INSERT INTO turobt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","İyi çoban benim. İyi çoban koyunları için canını verir. ");
INSERT INTO turobt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Koyunların sahibi olmayan, parayla tutulan işçi ise çoban gibi değildir. İşçi kurdun yaklaştığını görünce koyunları bırakıp kaçar. Kurt da koyunları kapıp dağıtır. ");
INSERT INTO turobt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","İşçi kaçar, çünkü parayla tutulmuştur ve koyunlar için kaygı çekmez. ");
INSERT INTO turobt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","İyi çoban benim. Bana ait olanları tanırım. Bana ait olanlar da beni tanırlar. ");
INSERT INTO turobt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Babaʼnın beni tanıdığı gibi, ben de Babaʼyı tanırım ve koyunlarım için canımı veririm. ");
INSERT INTO turobt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bu ağıldan olmayan başka koyunlarım da var. Onları da getirmeliyim. Onlar sesimi işitecekler ve tek sürü, tek çoban olacak. ");
INSERT INTO turobt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baba beni sever, çünkü ben canımı veririm, öyle ki onu geri alayım. ");
INSERT INTO turobt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kimse canımı benden almaz. Ben onu kendiliğimden veririm. Onu vermeye ve geri almaya yetkim var. Bu buyruğu Babamʼdan aldım.” ");
INSERT INTO turobt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bu sözler yüzünden Yahudiler tekrar ikiye bölündü. ");
INSERT INTO turobt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Onların birçoğu şöyle dedi: “Adam deli, hem de cinlidir. Niye onu dinliyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Başkalarıysa şöyle dediler: “Bu sözler, cinli bir adamın söyleceği sözlere benzemez. Cin kör adamın gözlerini açabilir mi?” ");
INSERT INTO turobt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","O sırada Yeruşalimʼde Işık Bayramı kutlanıyordu. Kış mevsimiydi. ");
INSERT INTO turobt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","İsa da tapınağın içinde, Süleymanʼın Kemeraltıʼnda dolaşıyordu. ");
INSERT INTO turobt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","O zaman Yahudi liderler Oʼnun etrafını sarıp şunu sordular: “Bizi ne zamana kadar merakta bırakacaksın? Eğer Mesihʼsen, bize açıkça söyle.” ");
INSERT INTO turobt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","İsa onlara şöyle cevap verdi: “Size zaten söyledim. Fakat inanmıyorsunuz. Babamʼınadıyla yaptığım mucizeler benim için şahitlik ediyor. ");
INSERT INTO turobt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Fakat siz inanmıyorsunuz, çünkü benim koyunlarımdan değilsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Koyunlarım sesimi işitir. Ben onları tanırım, onlar da peşimden gelir. ");
INSERT INTO turobt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ben koyunlarıma sonsuz yaşam veririm. Onlar asla yok olmayacaklar. Hiç kimse onları elimden kapmayacak. ");
INSERT INTO turobt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Onları bana veren Babam her şeyden üstündür. Hiç kimse onları Babamʼın elinden kapamaz. ");
INSERT INTO turobt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ben ve Baba biriz.” ");
INSERT INTO turobt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yahudi liderler İsaʼyı taşlamak için yerden yine taş topladılar. ");
INSERT INTO turobt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","İsa onlara şöyle dedi: “Ben size Babaʼdan kaynaklanan birçok iyi işler gösterdim. Bunlardan hangisi için beni taşlıyorsunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahudi liderler Oʼna cevap verdiler: “Seni iyi iş yaptığın için taşlamıyoruz, ama Allahʼa hakaret ettiğin için taşlıyoruz. Çünkü sen insan olduğun halde kendini Allah yapıyorsun.” ");
INSERT INTO turobt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","İsa onlara şöyle karşılık verdi: “Size verilen Tevratʼta ‘Ben, “Tanrılarsınız” dedim’ diye yazılı değil mi? ");
INSERT INTO turobt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Allah, sözünü gönderdiği insanları ‘tanrılar’ diye çağırır. Kutsal Yazı da geçersiz kılınamaz. ");
INSERT INTO turobt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Baba Allah beni göreve ayırıp dünyaya gönderdi. O halde ‘Allahʼın Oğluʼyum’ dediğim için bana nasıl olur da ‘Allahʼa hakaret ediyorsun’ dersiniz? ");
INSERT INTO turobt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eğer Babamʼın istediği şeyleri yapmıyorsam, bana inanmayın. ");
INSERT INTO turobt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama eğer o şeyleri yapıyorsam, bana inanmazsanız bile, yaptığım mucizelere inanın. Öyle ki, Babaʼnın bende, benim de Babaʼda olduğumu bilesiniz ve anlayasınız.” ");
INSERT INTO turobt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","İsaʼyı tekrar yakalamaya çalıştılar. Ama İsa onların elinden kurtulup gitti. ");
INSERT INTO turobt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","İsa oradan ayrılıp yine Şeria Irmağıʼnın karşı tarafına, Yahyaʼnın daha önce insanları vaftiz ettiği yere gitti ve orada kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Birçok kişi İsaʼnın yanına geldi. Şöyle diyorlardı: “Gerçi Yahya hiçbir mucize yapmadı. Ama Yahya bu adam hakkında ne söylediyse, hepsi doğru çıktı.” ");
INSERT INTO turobt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Böylece orada birçok kişi İsaʼya iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","O sırada Lazar adında bir adam hastalanmıştı. Kendisi kız kardeşleri Meryemʼle Martaʼnın yaşadığı Beytanya köyündendi. ");
INSERT INTO turobt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meryem Rab İsaʼya hoş kokulu yağ sürüp Oʼnun ayaklarını kendi saçları ile kurutan kadındı. Hasta olan Lazar onun kardeşiydi. ");
INSERT INTO turobt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bu nedenle kız kardeşler İsaʼya şöyle haber yolladılar: “Ey Efendimiz! Sevdiğin kişi hastadır.” ");
INSERT INTO turobt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bunu duyunca İsa şöyle dedi: “Bu hastalık ölümle sonuçlanmayacak. Ama Allahʼın yüceliğine ve Allahʼın Oğluʼnun yüceltilmesine hizmet edecek.” ");
INSERT INTO turobt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","İsa, Martaʼyı, kız kardeşini ve Lazarʼı severdi. ");
INSERT INTO turobt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","İsa Lazarʼın hasta olduğunu işitince bulunduğu yerde iki gün daha kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ondan sonra öğrencilerine, “Yahudiyeʼye dönelim” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Öğrencileri Oʼna şöyle dediler: “Öğretmenimiz, Yahudi liderler az önce seni taşlamak istiyorlardı. Sen yine oraya mı döneceksin?” ");
INSERT INTO turobt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","İsa onlara cevap verdi: “Günde on iki saat aydınlık yok mu? İnsan gündüz yürürken tökezlemez, çünkü bu dünyanın ışığını görür. ");
INSERT INTO turobt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Fakat insan gece yürürken tökezler, çünkü kendisinde ışık yoktur.” ");
INSERT INTO turobt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bunları anlattıktan sonra, onlara şöyle dedi: “Arkadaşımız Lazar uyudu. Fakat onu uyandırmaya gidiyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bunun üzerine öğrencileri Oʼna, “Efendimiz, uyuduysa iyileşecek” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aslında İsa Lazarʼın ölümünden bahsediyordu. Fakat öğrencileri İsaʼnın normal uykudan söz ettiğini sandılar. ");
INSERT INTO turobt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bunun üzerine İsa onlara durumu açıkladı: “Lazar öldü. ");
INSERT INTO turobt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","İman edesiniz diye orada olmadığıma sizin için seviniyorum. Haydi, onun yanına gidelim.” ");
INSERT INTO turobt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","İkiz diye bilinen Tomas öbür öğrencilere, “Haydi, biz de gidelim” dedi. “Böylece Oʼnunla birlikte ölelim.” ");
INSERT INTO turobt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","İsa Beytanya köyüne yaklaştığında Lazarʼın dört günden beri mezarda bulunduğunu öğrendi. ");
INSERT INTO turobt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beytanya köyü Yeruşalimʼden üç kilometre kadar uzaklıktaydı. ");
INSERT INTO turobt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Birçok Yahudi, kardeşlerini kaybeden Meryem ve Martaʼya baş sağlığı dilemeye gelmişti. ");
INSERT INTO turobt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta İsaʼnın geldiğini işitince, Oʼnu karşılamaya gitti. Meryem ise evde kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta İsaʼya, “Efendimiz!” dedi. “Sen burada olsaydın, kardeşim ölmezdi. ");
INSERT INTO turobt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama şimdi bile biliyorum ki, Allahʼtan ne dilersen, Allah onu sana verecek.” ");
INSERT INTO turobt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","İsa ona, “Kardeşin dirilecek” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta, “Son gün, diriliş günü kardeşimin dirileceğini biliyorum” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","İsa Martaʼya şöyle dedi: “Diriliş ve yaşam benim. Bana iman eden ölse de yaşayacak. ");
INSERT INTO turobt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yaşayan ve bana iman eden kimse asla ölmeyecek. Buna inanıyor musun?” ");
INSERT INTO turobt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta, “Evet, Efendimiz!” dedi. “Ben inandım ki, sen dünyaya gelen Allahʼın Oğlu, Mesihʼsin.” ");
INSERT INTO turobt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta bunları söyledikten sonra ayrılıp kız kardeşi Meryemʼi gizlice çağırdı. “Öğretmenimiz geldi ve seni çağırıyor” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meryem bunu duyunca acele kalkıp İsaʼyı karşılamaya gitti. ");
INSERT INTO turobt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","İsa henüz köye gelmemişti, hâlâ Martaʼnın Oʼnu karşıladığı yerde duruyordu. ");
INSERT INTO turobt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Meryemʼle birlikte evde bulunan ve ona baş sağlığı dileyen Yahudiler Meryemʼin aceleyle kalkıp dışarı çıktığını gördüler. Ağlamak için mezara gittiğini sanarak onun peşinden gittiler. ");
INSERT INTO turobt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meryem, İsaʼnın yanına geldi. Oʼnu görünce ayaklarının dibine kapandı. İsaʼya şöyle dedi: “Efendimiz! Burada olsaydın, kardeşim ölmezdi.” ");
INSERT INTO turobt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Meryem de, arkasından gelen Yahudiler de ağlıyorlardı. Bunu gören İsaʼnın ruhu derinden etkilendi ve yüreği sızladı. ");
INSERT INTO turobt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Siz onu nereye yattırdınız?” diye sordu. “Efendimiz, gel de gör” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","İsa ağladı. ");
INSERT INTO turobt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bunu gören Yahudiler, “Bakın, Lazarʼı ne kadar severdi!” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama onlardan bazıları şöyle dedi: “Bu adam körlerin gözlerini açtı. Lazarʼın ölmesini de önleyemez miydi?” ");
INSERT INTO turobt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","İsa tekrar derinden etkilenerek mezarın yanına gitti. Mezar bir mağaraydı ve girişi büyük bir taşla kapatılmıştı. ");
INSERT INTO turobt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","İsa, “Taşı çekin!” diye buyruk verdi. Ölen adamın kız kardeşi Marta İsaʼya şöyle dedi: “Efendimiz, o kötü kokuyor artık, çünkü öleli dört gün oldu.” ");
INSERT INTO turobt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","İsa ona şöyle dedi: “Ben sana ‘İman edersen, Allahʼın yüceliğini göreceksin’ demedim mi?” ");
INSERT INTO turobt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bunun üzerine, mezardaki taşı çektiler. İsa da başını kaldırıp şöyle dedi: “Ey Baba, beni işittiğin için sana şükrederim. ");
INSERT INTO turobt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Beni her zaman işittiğini biliyorum. Fakat bunu etrafta duran kalabalık için söyledim. Öyle ki, beni senin gönderdiğine inansınlar.” ");
INSERT INTO turobt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bunları söyledikten sonra yüksek sesle, “Lazar, dışarı çık!” diye bağırdı. ");
INSERT INTO turobt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ölü adam dışarı çıktı. Elleri ve ayakları sargı bezleriyle sarılmıştı. Yüzü de bir bezle bağlanmıştı. İsa onlara şöyle dedi: “Onu çözün, bırakın gitsin.” ");
INSERT INTO turobt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","O zaman Meryemʼe gelen ve İsaʼnın yaptıklarını gören birçok Yahudi Oʼna iman etti. ");
INSERT INTO turobt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Fakat orada bulunan bazıları Ferisilere gidip İsaʼnın yaptıklarını anlattılar. ");
INSERT INTO turobt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bunun için başrahipler ve Ferisiler Meclisʼi topladılar. “Ne yapacağız? Bu adam birçok mucize yapıyor. ");
INSERT INTO turobt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Oʼnu kendi haline bırakırsak herkes Oʼna iman edecek. Romalılar da gelip hem kutsal yerimizi, hem de milletimizi ortadan kaldıracaklar” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Fakat aralarından biri, o yıl başrahip olan Kayafa, onlara şöyle dedi: “Siz hiçbir şey bilmiyorsunuz! ");
INSERT INTO turobt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bütün millet yok olacağına, halk uğruna tek bir kişinin ölmesi daha faydalıdır. Bunu anlamıyor musunuz?” ");
INSERT INTO turobt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa bunu kendiliğinden söylemedi. Ama o yıl başrahip olduğu için İsaʼnın halk uğruna öleceğini peygamber gibi önceden bildirdi. ");
INSERT INTO turobt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","İsaʼnın yalnız Yahudi milleti uğruna değil, ama aynı zamanda Allahʼın dağılmış evlatlarını bir araya toplamak için öleceğini söyledi. ");
INSERT INTO turobt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","O günden sonra İsaʼyı öldürmek için plan kurmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bu yüzden İsa artık Yahudilerin arasında açıkça dolaşamaz oldu. Oradan ayrılıp ıssız bölgeye yakın Efrayim adında bir kasabaya gitti. Öğrencileriyle birlikte orada kaldı. ");
INSERT INTO turobt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yahudilerin Özgürlük Bayramı yaklaşmıştı. Kırlardan birçok kişi bayramdan önce arınma adetlerini yerine getirmek için Yeruşalimʼe gitti. ");
INSERT INTO turobt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","İsaʼyı arıyor ve tapınak avlusundayken birbirlerine, “Ne dersiniz, O bayram için gelmeyecek mi?” diye soruyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Başrahipler ve Ferisiler İsaʼyı yakalayabilmek için, Oʼnun yerini bilenlerin haber vermelerini emretmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Böylece İsa Özgürlük Bayramıʼndan altı gün önce ölümden dirilttiği Lazarʼın bulunduğu Beytanya köyüne geldi. ");
INSERT INTO turobt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Orada İsa için bir yemek verdiler. Marta hizmet ediyordu ve Lazar İsaʼyla birlikte sofra başında olanların arasındaydı. ");
INSERT INTO turobt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","O zaman Meryem yarım litre hoş kokulu yağ aldı. Bu saf hintsümbülü yağı çok pahalıydı. Bunu İsaʼnın ayaklarına sürdükten sonra ayaklarını kendi saçlarıyla sildi. Bütün ev bu yağın hoş kokusuyla doldu. ");
INSERT INTO turobt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne var ki, İsaʼnın öğrencilerinden biri, az sonra Oʼna ihanet edecek olan Yahuda İskariyot şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Neden bu hoş kokulu yağ üç yüz gümüş paraya satılmadı? Bu para fakirlere dağıtılabilirdi!” ");
INSERT INTO turobt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bunu fakirleri düşündüğü için değil, hırsız olduğu için söyledi. Çünkü ortak para kutusu ondaydı ve Yahuda oraya koyulan paradan çalıyordu. ");
INSERT INTO turobt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","İsa, “Kadını rahat bırak” dedi. “Bu hoş kokulu yağı gömüleceğim gün için saklasın. ");
INSERT INTO turobt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Fakirler her zaman sizinle olacak. Ama ben her zaman sizinle olmayacağım.” ");
INSERT INTO turobt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yahudilerden büyük bir kalabalık, İsaʼnın orada olduğunu öğrenince geldiler. Sadece İsaʼyı değil, İsaʼnın ölümden dirilttiği Lazarʼı da görmek istiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bu sebeple başrahipler Lazarʼı da öldürmeye karar vermişlerdi. ");
INSERT INTO turobt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Çünkü Lazar yüzünden birçok Yahudi onları terk edip İsaʼya iman ediyordu. ");
INSERT INTO turobt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ertesi gün bayramı kutlamak için büyük bir kalabalık toplandı, çünkü İsaʼnın da Yeruşalimʼe geleceğini duymuşlardı. ");
INSERT INTO turobt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hurma ağaçlarından dallar alıp Oʼnu karşılamaya çıktılar. Şöyle bağırıyorlardı: “Hozana!” “Rabbin adıyla gelene övgüler olsun!” “İsrailʼin Kralı Oʼdur!” ");
INSERT INTO turobt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","İsa genç bir eşek bulup ona bindi. Böylece şu yazı yerine geldi: ");
INSERT INTO turobt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ey Siyon kızı, korkma! Bak, Kralın geliyor! Genç bir eşeğe binmiş geliyor!” ");
INSERT INTO turobt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","İsaʼnın öğrencileri bu şeyleri önce anlamadılar. Ama İsa yüceltildikten sonra bu sözlerin Oʼnun hakkında yazıldığını ve insanların bunları Oʼna yaptığını hatırladılar. ");
INSERT INTO turobt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","İsa Lazarʼı ölümden diriltip mezardan dışarı çıkmasını emrettiğinde yanında bir kalabalık vardı. Bu insanlar İsaʼnın yaptığını herkese anlatmaya devam ettiler. ");
INSERT INTO turobt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bundan dolayı halk İsaʼyı karşılamaya çıktı, çünkü Oʼnun bu mucizeyi yaptığını duymuşlardı. ");
INSERT INTO turobt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","O zaman Ferisiler birbirlerine şöyle dediler: “Görüyorsunuz, elimizden hiçbir şey gelmiyor. Bakın, bütün dünya bu adamın peşine takıldı.” ");
INSERT INTO turobt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yeruşalimʼde Allahʼa tapınmak için bayrama katılanların arasında bazı Grekler vardı. ");
INSERT INTO turobt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Celile bölgesindeki Beytsayda kasabasından olan Filipus da oradaydı. Bu Grekler Filipusʼun yanına gelip, “Efendimiz, İsaʼyı görmek istiyoruz” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipus gidip bunu Andreasʼa anlattı. Filipus ve Andreas da gidip İsaʼya haber verdiler. ");
INSERT INTO turobt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","İsa onlara karşılık verip şöyle dedi: “Artık İnsan Oğluʼnun yüceltileceği saat geldi. ");
INSERT INTO turobt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Size doğrusunu söylüyorum, bir buğday tohumu toprağa düşüp ölmezse, yalnız başına kalır. Ama ölürse, çok ürün meydana getirir. ");
INSERT INTO turobt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kim kendi canını severse, onu kaybedecek. Ama kim bu dünyada canını gözden çıkarırsa, onu koruyup sonsuz yaşama kavuşacak. ");
INSERT INTO turobt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kim bana hizmet ederse, peşimden gelsin. Ben neredeysem, bana hizmet eden de orada olacak. Kim bana hizmet ederse, Babam onu ödüllendirecek. ");
INSERT INTO turobt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Şu an çok sıkıntı çekiyorum. Buna ne diyeyim? ‘Baba, beni bu saatten kurtar’ mı diyeyim? Hayır, çünkü bu amaç için bu saate geldim. ");
INSERT INTO turobt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, kendi adını yücelt!” Bunun üzerine gökten şöyle bir ses geldi: “Adımı hem yücelttim, hem de tekrar yücelteceğim.” ");
INSERT INTO turobt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Etrafta duran ve bu sesi işiten kalabalık da, “Gök gürledi” dedi. Başkalarıysa, “Bir melek Oʼnunla konuştu” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","İsa sesini yükselterek şöyle dedi: “Bu ses benim için değil, sizin içindi. ");
INSERT INTO turobt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Şimdi bu dünyanın yargılanacağı zaman gelmiştir. Bu dünyayı yöneten artık yerinden kovulacak. ");
INSERT INTO turobt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bense yerden yukarı kaldırıldığım zaman herkesi kendime çekeceğim.” ");
INSERT INTO turobt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","İsa bunu nasıl öleceğine işaret etmek için söyledi. ");
INSERT INTO turobt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kalabalık Oʼna şöyle karşılık verdi: “Tevratʼtan anladığımız kadarıyla Mesih dünyada sonsuza kadar kalacak. Sen nasıl diyebilirsin ki, ‘İnsan Oğluʼnun yukarı kaldırılması lazım’? Bu İnsan Oğlu kimdir?” ");
INSERT INTO turobt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","İsa şöyle cevap verdi: “Işık az bir vakit daha aranızda kalacak. Aydınlık varken yürüyün. Karanlık sizi yakalamasın. Kim karanlıkta yürürse, nereye gittiğini bilmez. ");
INSERT INTO turobt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sizde ışık varken, ışığa iman edin, öyle ki, ışık evlatları olasınız.” İsa bunları söyledikten sonra onlardan ayrılıp gizlendi. ");
INSERT INTO turobt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","İsa birçok mucize yaptı. Halk bunları kendi gözleriyle gördü; fakat yine de Oʼna iman etmedi. ");
INSERT INTO turobt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Öyle ki, Yeşaya peygamberin sözü yerine gelsin. O şöyle demişti: “Ya Rab, verdiğimiz habere kim inandı? Rabbin gücü kime gösterildi?” ");
INSERT INTO turobt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","İşte, bu yüzden iman edemiyorlardı, çünkü Yeşaya yine şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Allah onların gözlerini kör etti ve yüreklerini duygusuz hale getirdi. Öyle ki, gözleriyle bir şey görmesinler, yürekleriyle anlayıp bana dönmesinler. Dönselerdi, onlara şifa verirdim.” ");
INSERT INTO turobt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yeşaya bunları söyledi, çünkü İsaʼnın yüceliğini gördü ve Oʼnun hakkında konuştu. ");
INSERT INTO turobt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bununla birlikte, Yahudi liderlerden bile birçok kişi İsaʼya iman etti. Ama Ferisiler yüzünden bunu açıkça söylemediler. Yahudilerin toplantı yerinden kovulmak istemediler. ");
INSERT INTO turobt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Çünkü insanlar tarafından övülmeyi Allah tarafından övülmekten daha çok sevdiler. ");
INSERT INTO turobt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","İsa yüksek sesle şöyle dedi: “Kim bana iman ederse, bana değil, beni Gönderenʼe iman etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kim beni görürse, beni Gönderenʼi görmüş olur. ");
INSERT INTO turobt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ben ışık olarak dünyaya geldim. Öyle ki, bana iman eden kimse karanlıkta kalmasın. ");
INSERT INTO turobt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Fakat bir kişi benim sözlerimi işitip de onlara uymazsa, ben onu yargılamam. Çünkü dünyayı yargılamak için gelmedim. Dünyayı kurtarmaya geldim. ");
INSERT INTO turobt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kim beni reddederse ve sözlerimi kabul etmezse, onu yargılayacak biri var. Son günde o kişiyi söylediğim söz yargılayacak. ");
INSERT INTO turobt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ne de olsa, ben kendi adıma konuşmadım. Fakat beni gönderen Baba, ne söyleyeceğimi ve ne duyuracağımı bana buyurdu. ");
INSERT INTO turobt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Biliyorum ki, Oʼnun buyruğu sonsuz yaşam getirir. Onun için ben ne duyuruyorsam, Babaʼnın bana söylediği gibi duyuruyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Özgürlük Bayramıʼndan önceydi. İsa bu dünyadan ayrılıp Babaʼya dönme saatinin geldiğini biliyordu. Bu dünyada kendisine ait olanları hep sevmişti. Şimdi sevgisini tam olarak gösteriyordu. ");
INSERT INTO turobt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Akşam yemeği sırasıydı. Simun İskariyotʼun oğlu Yahuda İsaʼya ihanet etmek niyetindeydi. İblis bunu onun yüreğine çoktan koymuştu. ");
INSERT INTO turobt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","İsa Babaʼnın her şeyi Oʼnun eline teslim ettiğini biliyordu. Kendisinin Allahʼtan geldiğini ve yine Allahʼa döneceğini de biliyordu. ");
INSERT INTO turobt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Böylece yemekten kalktı, üst elbisesini çıkarıp bir yana koydu. Ardından bir havlu alıp beline sardı. ");
INSERT INTO turobt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sonra bir leğene su doldurup öğrencilerinin ayaklarını yıkamaya başladı. Ardından sarınmış olduğu havluyla ayaklarını kuruladı. ");
INSERT INTO turobt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Böylece İsa Simun Petrusʼa geldi. Petrus Oʼna, “Efendimiz, sen mi benim ayaklarımı yıkayacaksın?” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","İsa ona şöyle cevap verdi: “Ne yaptığımı şu anda anlayamazsın. Ama daha sonra farkına varacaksın.” ");
INSERT INTO turobt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus Oʼna, “Benim ayaklarımı asla yıkamayacaksın!” dedi. İsa şöyle cevap verdi: “Seni yıkamazsam, yanımda yerin olmaz.” ");
INSERT INTO turobt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simun Petrus Oʼna, “Efendimiz, sadece ayaklarımı değil, ellerimi ve başımı da yıka!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","İsa Simun Petrusʼa şöyle dedi: “Boydan boya yıkanmış kişi tamamen temizdir. Onun sadece ayaklarının yıkanmasına ihtiyacı vardır. Siz temizsiniz, ama hepiniz değil!” ");
INSERT INTO turobt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Çünkü İsa kendisine kimin ihanet edeceğini biliyordu. İşte bunun için “Hepiniz temiz değilsiniz” demişti. ");
INSERT INTO turobt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","İsa öğrencilerin ayaklarını yıkadıktan sonra üst elbisesini giydi. Tekrar yerine oturdu ve onlara şöyle dedi: “Size ne yaptığımı anladınız mı? ");
INSERT INTO turobt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Siz bana ‘Öğretmenimiz’ veya ‘Efendimiz’ diyorsunuz. Doğru söylüyorsunuz, çünkü öyleyim. ");
INSERT INTO turobt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eğer ben, Efendiniz ve Öğretmeniniz olarak ayaklarınızı yıkadıysam, siz de birbirinizin ayaklarını yıkamalısınız. ");
INSERT INTO turobt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Çünkü size bir örnek gösterdim: Benim size yaptığım gibi, siz de aynısını yapasınız. ");
INSERT INTO turobt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Size doğrusunu söylüyorum: köle efendisinden büyük değildir. Elçi de kendisini gönderenden büyük değildir. ");
INSERT INTO turobt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Eğer bu şeyleri bilip yerine getirirseniz, ne mutlu size! ");
INSERT INTO turobt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Hepiniz hakkında konuşmuyorum. Seçtiğim kişileri tanıyorum. Ama bu, Kutsal Yazılarʼdaki şu söz yerine gelsin diye oldu: ‘Ekmeğimi yiyen bana düşman oldu.’ ");
INSERT INTO turobt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Size şimdiden, bunlar olmadan önce söylüyorum ki, bunlar olunca, benim O olduğuma inanasınız. ");
INSERT INTO turobt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Size doğrusunu söylüyorum, kim benim gönderdiğim kişiyi kabul ederse, beni kabul etmiş olur. Beni kabul eden de, beni Gönderenʼi kabul etmiş olur.” ");
INSERT INTO turobt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","İsa bu sözleri söyledikten sonra ruhu derinden etkilendi. Şunu açıkça söyledi: “Size doğrusunu söylüyorum, sizden biri bana ihanet edecek.” ");
INSERT INTO turobt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Öğrenciler birbirlerine bakıp, acaba kimin hakkında konuşuyor diye merak etmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Öğrencilerden biri sofrada İsaʼnın yanı başındaydı. İsa onu severdi. ");
INSERT INTO turobt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simun Petrus İsaʼnın kimden söz ettiğini sorması için o öğrenciye işaret etti. ");
INSERT INTO turobt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","O da İsaʼnın göğsüne iyice yaslanarak Oʼna sordu: “Efendimiz, kimdir o?” ");
INSERT INTO turobt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","İsa şöyle cevap verdi: “Lokmayı yemeğe bandırıp kime verirsem odur”. Hemen lokmayı bandırıp Simun İskariyotʼun oğlu Yahudaʼya verdi. ");
INSERT INTO turobt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","O lokmayı aldıktan sonra Şeytan onun içine girdi. Bunun üzerine İsa Yahudaʼya, “Yapacağını çabuk yap!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama sofradakilerden hiçbiri İsaʼnın ona neden böyle dediğini anlamadı. ");
INSERT INTO turobt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Para kutusu Yahudaʼdaydı. Bunun için bazıları sandı ki: İsa ona “Bayram için bize lazım olan şeyleri satın al” ya da “Fakirlere bir şey ver” diye emretmişti. ");
INSERT INTO turobt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuda lokmayı yedi. Sonra hemen dışarı çıktı. Karanlık çökmüştü. ");
INSERT INTO turobt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yahuda çıktıktan sonra İsa şöyle dedi: “Şimdi İnsan Oğlu yüceltildi. Allah da Oʼnda yüceltildi. ");
INSERT INTO turobt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eğer Allah Oʼnda yüceltildiyse, Allah da Oʼnu kendinde yüceltecek. Hem de Oʼnu hemen yüceltecek. ");
INSERT INTO turobt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ey evlatlar, kısa bir süre daha sizinle beraberim. Beni arayacaksınız. Yahudi liderlere söylediğim gibi, şimdi size de söylüyorum: Benim gideceğim yere siz gelemezsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Size yeni bir buyruk veriyorum: birbirinizi sevin. Ben sizi nasıl sevdiysem, siz de birbirinizi sevin. ");
INSERT INTO turobt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Birbirinize sevginiz olursa, herkes bununla benim öğrencilerim olduğunuzu bilecek.” ");
INSERT INTO turobt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simun Petrus Oʼna, “Efendimiz, nereye gidiyorsun?” diye sordu. İsa şöyle cevap verdi: “Gideceğim yere şimdi peşimden gelemezsin, ama daha sonra geleceksin.” ");
INSERT INTO turobt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus Oʼna sordu: “Efendimiz, neden şimdi peşinden gelemezmişim? Senin için canımı veririm!” ");
INSERT INTO turobt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","İsa ona şöyle cevap verdi: “Benim için canını mı vereceksin? Sana doğrusunu söylüyorum, horoz ötmeden beni tanıdığını üç defa inkâr edeceksin.” ");
INSERT INTO turobt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Yüreğiniz üzülmesin. Allahʼa iman edin, bana da iman edin. ");
INSERT INTO turobt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Babamʼın evinde kalacak çok yer var. Öyle olmasaydı, ‘size yer hazırlamaya gidiyorum,’ der miydim? ");
INSERT INTO turobt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Gidip size yer hazırlarsam, tekrar gelip sizi yanıma alacağım. Öyle ki, ben neredeysem, siz de orada olasınız. ");
INSERT INTO turobt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gideceğim yerin yolunu biliyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas Oʼna şöyle dedi: “Efendimiz, senin nereye gideceğini bilmiyoruz. Yolu nasıl bilebiliriz?” ");
INSERT INTO turobt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","İsa ona şöyle cevap verdi: “Yol benim, gerçek ve yaşam da benim. Ben olmadan hiç kimse Babaʼya kavuşmaz. ");
INSERT INTO turobt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Beni tanırsanız, Babamʼı da tanırsınız. Bundan böyle Oʼnu tanıyorsunuz, Oʼnu gördünüz.” ");
INSERT INTO turobt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus İsaʼya şöyle dedi: “Ey Efendimiz, bize Babaʼyı göster. Bu bize yeter.” ");
INSERT INTO turobt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","İsa ona şöyle dedi: “Ey Filipus, bunca vakit sizinle birlikteyim ve beni hâlâ tanımadın mı? Beni görmüş olan, Babaʼyı görmüş olur. Nasıl olur da ‘Bize Babaʼyı göster’ diyorsun? ");
INSERT INTO turobt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ben Babaʼdayım, Baba da bendedir. Sen buna inanmıyor musun? Size söylediğim sözleri kendiliğimden söylemiyorum. Hayır, bende sürekli yaşayan Baba kendi işlerini yapıyor. ");
INSERT INTO turobt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bana inanın ki, ben Babaʼdayım ve Baba bendedir. Hiç değilse, o işler sayesinde inanın. ");
INSERT INTO turobt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Size doğrusunu söylüyorum, kim bana iman ederse, benim yaptığım işleri o da yapacak. Hem de bundan daha büyük işler yapacak, çünkü ben Babaʼya gidiyorum. ");
INSERT INTO turobt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Benim adımla her ne dilerseniz, onu yapacağım. Öyle ki, Baba Oğulʼda yüceltilsin. ");
INSERT INTO turobt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Benim adımla bir şey dilerseniz, onu yapacağım. ");
INSERT INTO turobt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Eğer beni severseniz, benim buyruklarımı yerine getirirsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ben de Babaʼdan isteyeceğim, O da size başka bir Yardımcı verecek, öyle ki, O sonsuza kadar sizinle kalsın. ");
INSERT INTO turobt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yardımcı, Hakikat Ruhuʼdur. Dünya Oʼnu kabul edemez. Çünkü Oʼnu ne görür ne de tanır. Siz Oʼnu tanıyorsunuz, çünkü O yanınızda kalıyor ve içinizde olacak. ");
INSERT INTO turobt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ben sizi öksüz bırakmayacağım. Size geri döneceğim. ");
INSERT INTO turobt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Az sonra dünya beni artık görmeyecek. Ama siz beni göreceksiniz. Madem ben yaşıyorum, siz de yaşayacaksınız. ");
INSERT INTO turobt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","O günde anlayacaksınız ki, ben Babaʼdayım, siz bendesiniz ve ben sizdeyim. ");
INSERT INTO turobt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kim buyruklarımı kabul eder ve yerine getirirse, işte, beni seven odur. Beni kim severse, Babam da onu sevecek. Ben de onu seveceğim ve kendimi ona göstereceğim.” ");
INSERT INTO turobt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuda, İskariyot değil öbür Yahuda Oʼna şöyle dedi: “Efendimiz, nasıl olur da kendini dünyaya göstermeden bize göstereceksin?” ");
INSERT INTO turobt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","İsa ona cevap olarak şöyle dedi: “Bir kişi beni severse, sözümü yerine getirecek, Babam da onu sevecek. Biz de o kişiye gelip onunla birlikte yaşayacağız. ");
INSERT INTO turobt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kim beni sevmezse, benim sözlerimi yerine getirmez. İşittiğiniz söz de benim değil, beni göndermiş olan Babaʼnın sözü. ");
INSERT INTO turobt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Daha sizinle birlikteyken bu sözleri size söyledim. ");
INSERT INTO turobt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yardımcı size her şeyi öğretecek ve benim söylediğim her şeyi aklınıza getirecek. Yardımcı Kutsal Ruhʼtur. Baba Oʼnu benim adımla gönderecek. ");
INSERT INTO turobt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Size esenlik bırakıyorum, size benim esenliğimi veriyorum. Dünyanın verdiği gibi vermiyorum. Yüreğiniz üzülmesin ve korkmasın. ");
INSERT INTO turobt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Size söylediğim şu sözü duydunuz: ‘Ben gidiyorum ama size döneceğim.’ Eğer beni sevmiş olsaydınız, ‘Babaʼya gidiyorum’ dediğime sevinirdiniz. Çünkü Baba benden üstündür. ");
INSERT INTO turobt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bunları size her şey olup bitmeden önce söyledim. Öyle ki, bunlar olunca iman edesiniz. ");
INSERT INTO turobt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sizinle artık fazla konuşmayacağım. Çünkü bu dünyayı yöneten geliyor ve onun benim üzerimde hiçbir gücü yok. ");
INSERT INTO turobt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama dünya, Babaʼyı sevdiğimi ve Babaʼnın bana buyurduğu her şeyi yaptığımı bilmeli. Haydi kalkın, buradan gidelim!” ");
INSERT INTO turobt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Gerçek asma benim. Babam da bağcı. ");
INSERT INTO turobt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Babam bende olup da meyve vermeyen her dalı kesip atar. Meyve veren her dalı ise temizler, öyle ki, daha fazla meyve versin. ");
INSERT INTO turobt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Size söylemiş olduğum söz aracılığıyla siz zaten temizsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Siz bende kalın, ben de sizde kalayım. Dal asmada kalmazsa, kendiliğinden meyve veremez. Aynı bunun gibi, siz de bende kalmazsanız meyve veremezsiniz. ");
INSERT INTO turobt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ben asmayım, siz dallarsınız. Bende kalan ve benim kendisinde kaldığım kişi çok meyve verir. Çünkü bensiz, bir şey yapamazsınız. ");
INSERT INTO turobt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bir kişi bende kalmazsa, bir dal gibi atılır kurur. Böyle dallar toplanır, ateşe atılır ve yakılır. ");
INSERT INTO turobt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Eğer siz bende kalırsanız ve sözlerim sizde kalırsa, her ne isterseniz dileyin, dileğiniz yerine gelecek. ");
INSERT INTO turobt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bol meyve verirseniz, benim öğrencilerim olduğunuzu gösterirsiniz. Böylece Babam yüceltilir. ");
INSERT INTO turobt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Babam beni nasıl sevdiyse, ben de sizi öyle sevdim. Benim sevgimde kalın. ");
INSERT INTO turobt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eğer buyruklarımı yerine getirirseniz, sevgimde kalırsınız. Tıpkı benim de Babamʼın buyruklarını yerine getirerek Oʼnun sevgisinde kaldığım gibi olursunuz. ");
INSERT INTO turobt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Bunları size, benim sevincim sizde olsun, sizin de sevinciniz tamamlansın diye söyledim. ");
INSERT INTO turobt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Benim buyruğum şu: Ben sizi nasıl sevdiysem, siz de birbirinizi sevin! ");
INSERT INTO turobt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bir kişinin kendi arkadaşları için canını vermesinden daha büyük bir sevgi yoktur. ");
INSERT INTO turobt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Benim size buyurduklarımı yaparsanız, siz arkadaşlarımsınız. ");
INSERT INTO turobt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Size artık ‘hizmetkâr’ demiyorum. Çünkü hizmetkâr efendisinin neler yaptığını bilmiyor. Hayır, size ‘arkadaş’ dedim. Çünkü Babamʼdan işittiğim her şeyi size bildirdim. ");
INSERT INTO turobt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Siz beni seçmediniz, ben sizi seçtim. Gidip meyve veresiniz, meyveniz de kalıcı olsun diye size görev verdim. Öyle ki, Babaʼdan benim adımla ne dilerseniz, O size versin. ");
INSERT INTO turobt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Size şu buyruğu veriyorum: ‘Birbirinizi sevin!’ ");
INSERT INTO turobt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Eğer dünya sizden nefret ederse, bilin ki, sizden önce benden nefret etmişti. ");
INSERT INTO turobt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eğer dünyadan olsaydınız, dünya sizi kendisine ait görür ve severdi. Ama siz dünyadan değilsiniz. Çünkü ben sizi dünyadan seçtim. İşte, bunun için dünya sizden nefret ediyor. ");
INSERT INTO turobt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Size söylemiş olduğum şu sözü hatırlayın: ‘Köle efendisinden büyük değildir.’ Bana eziyet ettilerse, size de eziyet edecekler. Benim sözümü yerine getirdilerse, sizin sözünüzü de yerine getirecekler. ");
INSERT INTO turobt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ama bütün bu şeyleri size bana ait olduğunuz için yapacaklar. Çünkü beni Gönderenʼi tanımıyorlar. ");
INSERT INTO turobt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eğer gelmeseydim ve onlarla konuşmamış olsaydım, günahları olmazdı. Fakat şimdi günahları için bahaneleri yok. ");
INSERT INTO turobt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Benden nefret eden herkes Babamʼdan da nefret eder. ");
INSERT INTO turobt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Onların arasında başka hiç kimsenin yapmadığı mucizeler yaptım. Eğer bunları yapmamış olsaydım günahları olmazdı. Ama şimdi hem yaptıklarımı gördüler hem de benden ve Babamʼdan nefret ettiler. ");
INSERT INTO turobt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Fakat bunlar, onlara verilen Tevratʼta yazılmış olan şu söz yerine gelsin diye oldu: ‘Hiç sebep yokken benden nefret ettiler.’ ");
INSERT INTO turobt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ben Babaʼdan size Yardımcıʼyı göndereceğim. O, Babaʼdan çıkıp gelen, gerçeği bildiren Ruhʼtur. O gelince benim için şahitlik edecek. ");
INSERT INTO turobt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Siz de şahitlik edeceksiniz, çünkü başlangıçtan beri benimle birliktesiniz. ");
INSERT INTO turobt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Bunları size tökezleyip düşmeyesiniz diye söyledim. ");
INSERT INTO turobt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sizi toplantı yerlerinden kovacaklar. Hatta öyle bir zaman geliyor ki, sizi öldüren herkes Allahʼa hizmet ettiğini sanacak. ");
INSERT INTO turobt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bunları, Babaʼyı ve beni tanımadıkları için yapacaklar ");
INSERT INTO turobt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Zamanı geldiğinde bu sözleri söylediğimi hatırlayasınız diye bunları size şimdiden bildiriyorum. Başlangıçta bunları size söylemedim, çünkü sizinle birlikteydim. ");
INSERT INTO turobt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Şimdiyse beni Gönderenʼe gidiyorum. Fakat hiçbiriniz bana ‘Nereye gidiyorsun?’ diye sormuyor. ");
INSERT INTO turobt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama size bunları bildirdiğim için yüreğiniz üzüntüyle doldu. ");
INSERT INTO turobt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Size doğrusunu söylüyorum, benim gitmem sizin iyiliğiniz için. Çünkü gitmezsem, Yardımcı size gelmeyecek. Ama gidersem, Oʼnu size göndereceğim. ");
INSERT INTO turobt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yardımcı gelince, dünyayı günah, doğruluk ve yargı hakkında ikna edecek: ");
INSERT INTO turobt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Günah hakkında, çünkü bana iman etmiyorlar; ");
INSERT INTO turobt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","doğruluk hakkında, çünkü ben Babamʼa gidiyorum ve artık beni görmeyeceksiniz; ");
INSERT INTO turobt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","yargı hakkında, çünkü bu dünyanın lideri artık yargılanmış bulunuyor. ");
INSERT INTO turobt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Size söyleyecek daha çok şeyim var, ama şimdi bunları dinlemeye dayanamazsınız. ");
INSERT INTO turobt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ne var ki, Gerçeğin Ruhu gelince, O sizi tüm gerçeğe yöneltecek. Çünkü kendiliğinden konuşmayacak: ne işitirse, onu söyleyecek. Hem de gelecekte olacakları size bildirecek. ");
INSERT INTO turobt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O beni yüceltecek. Çünkü benden aldıklarını size bildirecek. ");
INSERT INTO turobt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Babamʼın olan her şey benimdir. Bunun için dedim ki, ‘Benden aldıklarını size bildirecek.’ ");
INSERT INTO turobt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kısa bir zaman sonra artık beni görmeyeceksiniz. Yine kısa bir zaman sonra beni göreceksiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bunun üzerine öğrencilerinden bazıları, “Ne demek istiyor?” diye birbirlerine sordular. “ ‘Kısa bir zaman sonra beni görmeyeceksiniz; yine kısa bir zaman sonra beni göreceksiniz’ diyor. Ayrıca, ‘Çünkü Babaʼya gidiyorum’ diyor.” ");
INSERT INTO turobt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Böylece, “Bu ‘kısa zaman’ dediği nedir? Söylediğini anlamıyoruz!” deyip durdular. ");
INSERT INTO turobt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","İsa, öğrencilerinin kendisine soru sormak istediğini anladı. Onlara dedi ki, “ ‘Kısa bir zaman sonra beni görmeyeceksiniz. Yine kısa bir zaman sonra beni göreceksiniz’ dediğimi mi tartışıyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Size doğrusunu söylüyorum, siz ağlayacaksınız ve yas tutacaksınız, ama dünya sevinecek. Siz üzüleceksiniz, ama üzüntünüz sevince dönecek. ");
INSERT INTO turobt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kadın çocuk doğuracağı zaman sancılanır, çünkü doğum yapma zamanı gelmiştir. Ama çocuğu doğurduktan sonra, artık sancıyı hatırlamaz, çünkü dünyaya bir çocuk geldi diye sevinir. ");
INSERT INTO turobt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Evet, siz de şimdi üzülüyorsunuz. Ama sizinle yine görüşeceğim. O zaman yüreğiniz sevinecek, kimse de o sevinci sizden alamayacak. ");
INSERT INTO turobt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","O gün bana bir şey sormayacaksınız. Size doğrusunu söylüyorum, Babaʼdan benim adımla ne dilerseniz, O size verecek. ");
INSERT INTO turobt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Şimdiye kadar benim adımla bir şey dilemediniz. Dileyin, alacaksınız. Öyle ki, sevinciniz tam olsun. ");
INSERT INTO turobt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Bunları size bir benzetme gibi anlattım. Ama zaman gelecek ki, sizinle konuşurken artık benzetmeler kullanmayacağım. O zaman Babaʼyı size açıkça anlatacağım. ");
INSERT INTO turobt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","O gün ne dilerseniz benim adımla dileyeceksiniz. Sizin için Babaʼdan istekte bulunacağımı söylemiyorum. ");
INSERT INTO turobt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Doğrusu Babaʼnın kendisi sizi seviyor. Çünkü siz beni sevdiniz ve Allahʼtan çıkıp geldiğime inandınız. ");
INSERT INTO turobt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ben Babaʼdan çıkıp dünyaya geldim. Şimdiyse dünyayı bırakıp tekrar Babaʼya dönüyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Öğrencileri Oʼna şöyle dedi: “Bak, şimdi açıkça konuşuyorsun, kapalı söz kullanmıyorsun. ");
INSERT INTO turobt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Şimdi anladık ki, her şeyi biliyorsun ve kimsenin sana soru sormasına ihtiyacın yok. Artık senin Allahʼtan geldiğine inanıyoruz.” ");
INSERT INTO turobt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","İsa onlara cevap olarak şöyle dedi: “Şimdi mi iman ediyorsunuz? ");
INSERT INTO turobt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bakın, öyle bir saat geliyor, ve geldi bile, hepiniz dağılıp evlerinize döneceksiniz ve beni yalnız bırakacaksınız. Fakat ben yalnız değilim, çünkü Baba benimledir. ");
INSERT INTO turobt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Bunları size, benim sayemde esenlik bulasınız diye söyledim. Bu dünyada sıkıntı çekersiniz, ama cesur olun! Ben dünyayı yendim.” ");
INSERT INTO turobt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","İsa bu sözleri söyledikten sonra, gözlerini göğe kaldırdı ve şöyle dedi: “Baba, saat geldi, Oğlunʼu yücelt ki, Oğul da seni yüceltsin. ");
INSERT INTO turobt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Çünkü sen Oʼna bütün insanların üzerinde yetki verdin. Öyle ki, Oʼna verdiğin herkese sonsuz yaşam versin. ");
INSERT INTO turobt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sonsuz yaşam da şudur: seni, tek gerçek Allahʼı, ve göndermiş olduğun İsa Mesihʼi tanısınlar. ");
INSERT INTO turobt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ben yeryüzündeyken seni yücelttim, çünkü yapmam için bana verdiğin işi tamamladım. ");
INSERT INTO turobt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Şimdi, Baba, dünya kurulmadan önce senin yanında sahip olduğum yücelikle beni senin yanında yücelt. ");
INSERT INTO turobt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Bana bu dünyadan verdiğin insanlara senin adını açıkladım. Onlar senindi, sen onları bana verdin, onlar da senin sözünü yerine getirdiler. ");
INSERT INTO turobt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Artık bana verdiğin her şeyin senden geldiğini anladılar. ");
INSERT INTO turobt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Çünkü bana bildirdiğin sözleri onlara bildirdim. Onlar da o sözleri kabul ettiler ve gerçekten senden çıkıp geldiğimi anladılar. Hem de beni senin gönderdiğine inandılar. ");
INSERT INTO turobt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Onlar için dua ediyorum. Dünya için değil, bana verdiklerin için dua ediyorum. Çünkü onlar senindir. ");
INSERT INTO turobt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Benim olan her şey senindir, seninkiler de benimdir. Ben de onların aracılığıyla yüceltildim. ");
INSERT INTO turobt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ben sana geliyorum ve artık dünyada olmayacağım, ama onlar dünyadalar. Ey kutsal Baba, onları kendi adınla, bana verdiğin adla koru. Öyle ki, bizim bir olduğumuz gibi onlar da bir olsunlar. ");
INSERT INTO turobt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Onlarla birlikte olduğum zaman, onları bana verdiğin adınla koruyordum. Evet, onları kolladım, onlardan hiçbiri kaybolmadı. Kutsal Yazı yerine gelsin diye, yalnız mahvolacak adam kayboldu. ");
INSERT INTO turobt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Şimdi de sana geliyorum. Bunları ben daha dünyadayken söylüyorum. Öyle ki, onlar benim sevincimle dolsun. ");
INSERT INTO turobt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Onlara senin sözünü bildirdim. Dünya da onlardan nefret etti. Çünkü ben dünyaya ait olmadığım gibi, onlar da dünyaya ait değiller. ");
INSERT INTO turobt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Onları dünyadan alman için değil, ama kötü olandan koruman için dua ediyorum. ");
INSERT INTO turobt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ben dünyaya ait olmadığım gibi, onlar da dünyaya ait değiller. ");
INSERT INTO turobt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Senin sözün gerçektir. Bu gerçekle sana adanmalarını sağla. ");
INSERT INTO turobt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sen beni nasıl dünyaya gönderdiysen, ben de onları dünyaya gönderdim. ");
INSERT INTO turobt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kendimi onlar için adıyorum, öyle ki, onlar da sana gerçekten adansınlar. ");
INSERT INTO turobt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yalnız onlar için değil, onların söylediklerini duyup bana iman edecek olanlar için de dua ediyorum ki, ");
INSERT INTO turobt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","hepsi bir olsunlar. Nasıl ki sen, Baba, bendesin ve ben sendeyim, onlar da bizde olsunlar. Öyle ki, dünya beni senin gönderdiğine inansın. ");
INSERT INTO turobt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Beni yücelttiğin gibi ben de onları yücelttim. Öyle ki, bizim bir olduğumuz gibi onlar da bir olsunlar. ");
INSERT INTO turobt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Senin bende olduğun gibi ben de onlarda olacağım. Böylece onlar tam birliğe kavuşacaklar. O zaman dünya beni senin gönderdiğini bilecek ve beni sevdiğin gibi onları da sevdiğini anlayacak. ");
INSERT INTO turobt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baba, bana verdiğin herkesin bulunduğum yerde benimle birlikte olmasını diliyorum. Öyle ki, benim yüceliğimi görsünler. Yücelmemi sen sağladın, çünkü dünya kurulmadan önce beni sevdin. ");
INSERT INTO turobt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ey adaletli Baba, dünya seni tanımadı. Oysa ben seni tanıyorum. Bu öğrencilerim de beni senin gönderdiğini biliyorlar. ");
INSERT INTO turobt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Senin adını onlara bildirdim, hem de bildirmeye devam edeceğim. Öyle ki, bana gösterdiğin sevgi onlarda da olsun, ben de onlarda olayım.” ");
INSERT INTO turobt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bunları söyledikten sonra, İsa öğrencileriyle birlikte dışarı çıkıp Kidron Deresiʼni geçti. Orada bir bahçe vardı. Kendisi ve öğrencileri bahçeye girdi. ");
INSERT INTO turobt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Oʼna ihanet eden Yahuda da bu yeri biliyordu, çünkü İsa öğrencileriyle sık sık orada buluşurdu. ");
INSERT INTO turobt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bu sebeple Yahuda hem yanına bir grup asker hem de başrahipler ve Ferisilerden tapınak polisleri alıp oraya geldi. Fenerler, meşaleler ve silahlar taşıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","İsa başına gelecek şeylerin hepsini biliyordu. Bu yüzden öne çıkıp onlara, “Kimi arıyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Nasıralı İsaʼyı” diye cevap verdiler. İsa, “Benim” dedi. Oʼna ihanet eden Yahuda da onlarla birlikte duruyordu. ");
INSERT INTO turobt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","İsa “Benim” deyince, onlar geri çekilip yere düştüler. ");
INSERT INTO turobt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Onun için onlara bir defa daha sordu: “Kimi arıyorsunuz?” Onlar da, “Nasıralı İsaʼyı” dediler. ");
INSERT INTO turobt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","İsa şöyle cevap verdi: “Size ‘Benim’ dedim. Beni aradığınıza göre, bu adamları bırakın gitsinler.” ");
INSERT INTO turobt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Bu, daha önce söylediği şu sözün yerine gelmesi için oldu: “Bana verdiğin kişilerden hiçbirini kaybetmedim.” ");
INSERT INTO turobt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","O zaman Simun Petrus yanında taşıdığı kılıcı çekip başrahibin kölesine saldırdı ve onun sağ kulağını kesti. Kölenin adı Malkusʼtu. ");
INSERT INTO turobt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","İsa Petrusʼa, “Kılıcını yerine koy!” dedi. “Babamʼın bana verdiği bardaktan içmeyeyim mi?” ");
INSERT INTO turobt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","O zaman askerler, komutanları ve Yahudi tapınak polisleri İsaʼyı yakalayıp bağladılar. ");
INSERT INTO turobt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Oʼnu önce Hananʼa götürdüler. Hanan, o yıl başrahip olan Kayafaʼnın kayın pederiydi. ");
INSERT INTO turobt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Halk yerine tek bir kişinin ölmesi daha faydalıdır” diye Yahudi liderlere akıl veren Kayafaʼydı. ");
INSERT INTO turobt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simun Petrus ve başka bir öğrenci İsaʼyı götürenlerin ardından gidiyordu. O öğrenci başrahibin tanıdığıydı. Bu yüzden İsaʼyla birlikte başrahibin avlusuna girdi. ");
INSERT INTO turobt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petrus ise dışarıda, avlu kapısında kaldı. Başrahibin tanıdığı öbür öğrenci dışarıya çıkıp kapı bekçisi kızla konuştu ve Petrusʼu içeri aldı. ");
INSERT INTO turobt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kapı bekçisi kız Petrusʼa şunu sordu: “Sen de bu adamın öğrencilerinden değil misin?” Petrus, “Hayır, değilim” diye cevap verdi. ");
INSERT INTO turobt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Köleler ve tapınak polisleri orada duruyordu. Hava soğuk olduğundan kömürden ateş yakmış ısınıyorlardı. Petrus da aralarında durmuş ısınıyordu. ");
INSERT INTO turobt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bu arada başrahip İsaʼyı öğrencileri ve öğrettikleri hakkında sorguladı. ");
INSERT INTO turobt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","İsa ona şöyle cevap verdi: “Ben dünyaya ne söyledimse açıkça söyledim. Her zaman toplantı yerlerinde ve bütün Yahudilerin bir araya geldiği tapınak avlusunda vaaz ettim. Hiçbir şeyi gizlice söylemedim. ");
INSERT INTO turobt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Niye beni sorguya çekiyorsun? Söylediğim sözleri kim dinlediyse, onlara sor. Onlar ne söylediğimi biliyorlar.” ");
INSERT INTO turobt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","İsaʼnın böyle konuşması üzerine yanında duran bir tapınak polisi Oʼna bir tokat atarak şöyle dedi: “Sen başrahibe böyle mi karşılık verirsin?” ");
INSERT INTO turobt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","İsa ona şöyle cevap verdi: “Ben yanlış bir şey söyledimse, yanlışımı göster. Ama söylediklerim doğruysa, neden bana vuruyorsun?” ");
INSERT INTO turobt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bunun üzerine Hanan Oʼnu eli kolu bağlı olarak başrahip Kayafaʼnın yanına yolladı. ");
INSERT INTO turobt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simun Petrus hâlâ durup ısınıyordu. Etrafındakiler ona, “Sen de Oʼnun öğrencilerinden değil misin?” diye sordular. Petrus bunu inkâr ederek “Hayır, değilim” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Başrahibin kölelerinden biri de oradaydı. Bu adam, Petrusʼun kulağını kestiği kişinin akrabasıydı. “Ben seni bahçede Oʼnun yanında görmedim mi?” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus tekrar inkâr etti ve o anda horoz öttü. ");
INSERT INTO turobt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sabah erken Yahudi liderler İsaʼyı Kayafaʼnın yanından vali sarayına götürdüler. Fakat saraya girmediler. Özgürlük Bayram yemeğini yiyebilmek için temizlikle ilgili din kurallarını çiğnemek istemiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bu sebeple Pilatus onları karşılamak için dışarı çıktı. “Bu adamı neyle suçluyorsunuz?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ona şöyle cevap verdiler: “O kötülük yapan biri olmasaydı, Oʼnu sana getirmezdik.” ");
INSERT INTO turobt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus onlara, “Siz onu alın, kendi kanunlarınıza göre yargılayın” dedi. Ama Yahudi liderler ona şöyle dediler: “Bizim hiç kimseyi ölümle cezalandırmaya yetkimiz yok.” ");
INSERT INTO turobt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Böylece İsaʼnın sözü yerine geldi. Çünkü O daha önce nasıl bir ölümle öleceğini bildirmişti. ");
INSERT INTO turobt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ondan sonra Pilatus tekrar saraya girdi ve İsaʼyı çağırttı. Oʼna, “Sen Yahudilerin Kralı mısın?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","İsa ona şöyle cevap verdi: “Bunu kendin mi söylüyorsun, yoksa başkaları mı benim hakkımda böyle söyledi?” ");
INSERT INTO turobt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus, “Ben Yahudi miyim?” diye karşılık verdi. “Halkın ve başrahiplerin seni bana teslim ettiler. Ne yaptın?” ");
INSERT INTO turobt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","İsa şöyle dedi: “Benim krallığım bu dünyadan değildir. Eğer krallığım bu dünyadan olsaydı, Yahudi liderlere teslim edilmemem için adamlarım benim için savaşırdı. Oysa benim krallığım buradan değil.” ");
INSERT INTO turobt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bunun üzerine Pilatus, “Demek sen bir kralsın, öyle mi?” diye sordu. İsa ona şöyle cevap verdi: “Sen kral olduğumu söylüyorsun. Ben gerçeğe şahitlik etmek için doğup dünyaya geldim. Gerçeğe bağlı herkes benim sesimi işitir.” ");
INSERT INTO turobt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus Oʼna “Gerçek nedir?” diye sordu. Bunu söyledikten sonra tekrar dışarı çıkıp Yahudi liderlere yaklaştı. Onlara şöyle dedi: “Ben Oʼnda hiçbir suç bulmuyorum. ");
INSERT INTO turobt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama adete göre Özgürlük Bayramıʼnda sizin için bir suçluyu serbest bırakırım. Peki, Yahudilerin Kralıʼnı serbest bırakmamı ister misiniz?” ");
INSERT INTO turobt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Onlarsa tekrar bağırmaya başladılar: “Hayır, bu adamı değil, Barabbaʼyı serbest bırak!” Oysa Barabba bir hayduttu. ");
INSERT INTO turobt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","O zaman Pilatus İsaʼyı kamçılattı. ");
INSERT INTO turobt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Askerler dikenlerden bir taç örüp İsaʼnın başına koydular. Sonra Oʼna mor renkli bir kaftan giydirdiler. ");
INSERT INTO turobt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","İsaʼnın önüne gelip defalarca, “Yaşasın Yahudilerin kralı!” dediler ve Oʼna tokat attılar. ");
INSERT INTO turobt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus tekrar dışarı çıktı. Yahudi liderlere şöyle dedi: “Bakın, Oʼnu size dışarı getiriyorum ki, Oʼnda hiçbir suç bulmadığımı bilesiniz.” ");
INSERT INTO turobt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bunun üzerine İsa dışarı çıktı. Başında dikenli taç ve sırtında mor renkli kaftan vardı. Pilatus onlara, “İşte o adam!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Başrahipler ve tapınak polisleri İsaʼyı görünce, “Çarmıha ger! Çarmıha ger!” diye bağırdılar. Pilatus onlara şöyle dedi: “Oʼnu siz alın ve çarmıha gerin. Çünkü ben Oʼnda hiçbir suç bulmuyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahudi liderler Pilatusʼa şöyle karşılık verdiler: “Bizim bir kanunumuz var. Bu kanuna göre Oʼnun ölmesi lazım, çünkü Allahʼın Oğlu olduğunu söylüyor.” ");
INSERT INTO turobt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus bu sözü duyunca daha da çok korktu. ");
INSERT INTO turobt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tekrar saraya girip İsaʼya, “Sen neredensin?” diye sordu. Ama İsa ona cevap vermedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bunun üzerine Pilatus Oʼna şöyle dedi: “Bana söyleyecek bir şeyin yok mu? Seni serbest bırakmaya da, çarmıha germeye de yetkim olduğunu bilmiyor musun?” ");
INSERT INTO turobt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","İsa şöyle cevap verdi: “Sana yukarıdan verilmemiş olsaydı, benim üzerimde hiçbir yetkin olmazdı. Bunun için, kim beni senin eline teslim ettiyse, onun günahı daha büyüktür.” ");
INSERT INTO turobt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bu nedenle Pilatus Oʼnu serbest bırakmaya çalıştı. Ama Yahudi liderler şöyle bağırdılar: “Sen bu adamı serbest bırakırsan, Sezarʼın arkadaşı değilsin. Kendine kral diyen herkes Sezarʼa başkaldırmış olur.” ");
INSERT INTO turobt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus bu sözleri işitince, İsaʼyı dışarıya, Taş Döşeme denilen yere çıkardı. Orada yargı yerine oturdu. Yerin adı Aramiceʼde Gabbataʼdır. ");
INSERT INTO turobt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Saat öğleyin on ikiye doğruydu. Özgürlük Bayramıʼnın Hazırlık Günüʼydü. Pilatus da Yahudi liderlere, “İşte kralınız!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Onlar da şöyle bağırdılar: “Yok et Oʼnu, yok et! Oʼnu çarmıha ger!” Pilatus, “Kralınızı mı çarmıha gereyim?” diye sordu. Başrahipler şöyle cevap verdiler: “Sezarʼdan başka kralımız yok!” ");
INSERT INTO turobt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","O zaman Pilatus İsaʼyı, çarmıha gerilsin diye askerlere teslim etti. Onlar da İsaʼyı alıp götürdüler. ");
INSERT INTO turobt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","İsa kendi çarmıhını yüklenip şehirden çıktı, Kafatası denilen yere doğru gitti. Bu yerin Aramice adı Golgotaʼdır. ");
INSERT INTO turobt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","İsaʼyı orada çarmıha gerdiler. Oʼnunla birlikte iki adamı daha çarmıha gerdiler. Biri bir yanda, diğeri öbür yanda, İsa ise ortadaydı. ");
INSERT INTO turobt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus bir de tabela yazdırdı ve onu çarmıhın üzerine astırdı. Şöyle yazılıydı: “Nasıralı İsa, Yahudilerin Kralı.” ");
INSERT INTO turobt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahudilerin birçoğu bu tabelayı okudu. Çünkü İsaʼnın çarmıha gerildiği yer şehre yakındı ve tabela Aramice, Latince ve Grekçe olarak yazılmıştı. ");
INSERT INTO turobt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bu yüzden Yahudi başrahipler Pilatusʼa şöyle dediler: “ ‘Yahudilerin Kralı’ diye yazma. Ama ‘O Yahudilerin Kralıʼyım dedi’ diye yaz.” ");
INSERT INTO turobt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus cevap olarak, “Ne yazdıysam yazdım” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Askerler İsaʼyı çarmıha gerdikten sonra Oʼnun elbiselerini alıp dört parçaya böldüler. Her askere birer pay düşecekti. Gömleğini de aldılar. Gömlek boydan boya dikişsiz, tek bir kumaş parçasıydı. ");
INSERT INTO turobt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bu sebeple birbirlerine şöyle dediler: “Bunu yırtmayalım, kime düşecek diye kura çekelim.” Bu, Kutsal Yazıʼnın şu sözü yerine gelsin diye oldu: “Giysilerimi aralarında paylaştılar ve kaftanım için kura çektiler.” İşte, bunları askerler yaptılar. ");
INSERT INTO turobt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","İsaʼnın çarmıhının yanındaysa kadınlar duruyordu. Onlar İsaʼnın annesi, teyzesi, Klopasʼın karısı Meryem, ve Mecdelli Meryemʼdi. ");
INSERT INTO turobt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","İsa, annesinin ve sevdiği öğrencinin orada durduğunu gördü. Annesine, “Bayan, işte bu senin oğlun!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ondan sonra öğrencisine “Bak, bu senin annen!” dedi. O öğrenci o günden sonra İsaʼnın annesini kendi evine aldı. ");
INSERT INTO turobt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bundan sonra İsa her şeyin zaten tamamlandığını biliyordu. Kutsal Yazılarʼın sözü yerine gelsin diye, “Susadım” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Orada ekşi şarapla dolu bir kap vardı. Askerler bir sünger alıp onu şaraba batırdılar. Sonra süngeri bir dalın ucuna takıp İsaʼnın ağzına uzattılar. ");
INSERT INTO turobt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","İsa ekşi şarabı içtikten sonra, “Tamamlandı!” dedi. Ardından başını eğip ruhunu teslim etti. ");
INSERT INTO turobt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","O gün Hazırlık Günüʼydü. Akşam olunca hem Şabat Günü hem de önemli bayram başlayacaktı. Yahudi liderler cesetlerin çarmıhta kalmasını istemiyorlardı. Bu sebeple Pilatusʼtan çarmıha gerilenlerin bacaklarının kırılmasını ve cesetlerin kaldırılmasını istediler. ");
INSERT INTO turobt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bunun üzerine askerler İsaʼnın yanında çarmıha gerilmiş adamlara geldiler. Birinci adamın bir de öbür adamın bacaklarını kırdılar. ");
INSERT INTO turobt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama İsaʼya gelince Oʼnun zaten öldüğünü gördüler. Bunun için Oʼnun bacaklarını kırmadılar. ");
INSERT INTO turobt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ne var ki askerlerden biri mızrakla Oʼnun böğrünü deldi. Bunu yapar yapmaz oradan kan ve su aktı. ");
INSERT INTO turobt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bunu görmüş olan kişi, siz de iman edesiniz diye şahitlik etmiştir ve şahitliği doğrudur. Doğruyu söylediğini de kendisi biliyor. ");
INSERT INTO turobt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bunlar şu Kutsal Yazı yerine gelsin diye oldu: “Onun tek bir kemiği bile kırılmayacak.” ");
INSERT INTO turobt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yine başka bir Kutsal Yazı şöyle diyor: “Bedenini delip deştikleri kişiye bakacaklar.” ");
INSERT INTO turobt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bundan sonra Aramatyalı Yusuf İsaʼnın ölüsünü almak için Pilatusʼa rica etti. Yusuf, İsaʼnın bir öğrencisiydi. Ama Yahudi liderlerden korktuğundan bunu gizli tutuyordu. Pilatus Yusufʼa izin verdi. Yusuf gidip İsaʼnın cesedini kaldırdı. ");
INSERT INTO turobt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Gece vakti İsaʼyı ziyaret etmiş olan Nikodim de oraya gitti. Nikodim otuz litre kadar karışık mür ve sarısabır kokularını getirdi. ");
INSERT INTO turobt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","İsaʼnın cesedinini alıp güzel kokularla birlikte bezlere sardılar. Yahudilerin cenaze adetleri böyleydi. ");
INSERT INTO turobt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","İsaʼnın çarmıha gerildiği yerde bir bahçenin içinde yeni bir mezar vardı. Oraya henüz hiç kimse koyulmamıştı. ");
INSERT INTO turobt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yahudilerin Bayrama Hazırlık Günüʼydü. Bunun için İsaʼyı oraya koydular, çünkü mezar yakındı. ");
INSERT INTO turobt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pazar günü erkenden, hâlâ karanlıkken, Mecdelli Meryem mezara gitti. Mezarın girişindeki taşın yana yuvarlanmış olduğunu gördü. ");
INSERT INTO turobt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bu yüzden koşup Simun Petrusʼun ve İsaʼnın sevdiği öbür öğrencinin yanına geldi ve onlara şöyle dedi: “Efendimizʼi mezardan almışlar. Oʼnu nereye koyduklarını bilmiyoruz.” ");
INSERT INTO turobt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bunun üzerine Petrus ve öbür öğrenci dışarı çıkıp mezara yöneldiler. ");
INSERT INTO turobt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","İkisi birlikte koşuyordu, ama öbür öğrenci Petrusʼtan daha hızlı koşarak mezara önce vardı. ");
INSERT INTO turobt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Eğilip içeri baktı ve keten sargı bezlerini orada serilmiş gördü. Fakat içeri girmedi. ");
INSERT INTO turobt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Onun ardından Simun Petrus geldi ve mezara girdi. Orada serilmiş sargı bezlerini gördü. ");
INSERT INTO turobt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","İsaʼnın başına bağlanmış bir bez de vardı. Ama bu, sargı bezlerinin yanında değildi. Ayrı bir yerde dürülmüş duruyordu. ");
INSERT INTO turobt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ondan sonra mezara önce varan öbür öğrenci içeri girdi. Olanları gördü ve inandı. ");
INSERT INTO turobt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kutsal Yazıʼya göre İsaʼnın ölümden dirilmesi lazımdı. Ama bu yazıyı henüz anlamamışlardı. ");
INSERT INTO turobt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sonra iki öğrenci diğerlerinin yanına döndü. ");
INSERT INTO turobt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Fakat Meryem mezarın dışında durmuş ağlıyordu. Ağlarken eğilip mezarın içine baktı. ");
INSERT INTO turobt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Orada beyaz elbiseler giymiş iki melek gördü. Birisi, İsaʼnın cesedinin daha önce yattığı yerin başucunda, öbürü ise ayakucunda oturuyordu. ");
INSERT INTO turobt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ona, “Bayan, niye ağlıyorsun?” diye sordular. Meryem onlara şöyle dedi: “Efendimʼi alıp götürmüşler ve Oʼnu nereye koyduklarını bilmiyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bunu söyledikten sonra, arkasına dönüp baktı. İsa orada duruyordu. Ama onun İsa olduğunu bilmiyordu. ");
INSERT INTO turobt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","İsa, “Bayan, niye ağlıyorsun? Kimi arıyorsun?” diye sordu. Meryem Oʼnu bahçıvan sanarak şöyle dedi: “Efendim, eğer sen Oʼnu götürdünse, Oʼnu nereye koyduğunu söyle. Ben gidip Oʼnu alayım.” ");
INSERT INTO turobt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","İsa ona, “Meryem!” dedi. Meryem dönüp Oʼna Aramiceʼde “Rabbuni” dedi. Rabbuni “Öğretmenim” demektir. ");
INSERT INTO turobt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","İsa ona şöyle dedi: “Bana tutunma! Çünkü Babaʼnın yanına daha çıkmadım. Kardeşlerime git ve onlara şunu söyle: ‘Benim Babamʼa ve sizin Babanızʼa, benim Allahımʼa ve sizin Allahınızʼa çıkıyorum.’ ” ");
INSERT INTO turobt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mecdelli Meryem gidip İsaʼnın öğrencilerine haber verdi. “Ben Efendimizʼi gördüm!” dedi. Sonra İsaʼnın kendisine söylediği şeyleri anlattı. ");
INSERT INTO turobt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Haftanın ilk günüydü ve akşam olmuştu. İsaʼnın öğrencilerinin bulunduğu evin kapıları kapalıydı, çünkü Yahudi liderlerden korkuyorlardı. İsa gelip ortalarında durdu ve “Size esenlik olsun!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bunu söyledikten sonra onlara kendi ellerini ve böğrünü gösterdi. Öğrenciler Efendileriʼni görünce sevindiler. ");
INSERT INTO turobt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","İsa onlara tekrar “Size esenlik olsun!” dedi. “Baba beni gönderdiği gibi, ben de sizi gönderiyorum.” ");
INSERT INTO turobt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bunu söyledikten sonra üzerlerine üfledi ve onlara “Kutsal Ruhʼu alın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Kimin günahlarını bağışlarsanız, onlar bağışlanmış olur. Kimin günahlarını bağışlamazsanız, onlar bağışlanmamış olur.” ");
INSERT INTO turobt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Fakat İsa geldiği zaman, on iki elçisinden biri olan ve İkiz adıyla bilinen Tomas onlarla birlikte değildi. ");
INSERT INTO turobt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Öbür öğrenciler ona, “Biz Efendimizʼi gördük!” dediler. O da onlara şöyle dedi: “Ben ellerindeki çivi izlerini görmeden, parmağımı çivilerin battığı yerlere ve elimi böğrüne koymadan asla inanmayacağım.” ");
INSERT INTO turobt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sekiz gün sonra İsaʼnın öğrencileri yine evdeydiler. Tomas da onlarla birlikteydi. Kapılar kapalıyken İsa geldi, ortalarında durdu ve “Size esenlik olsun!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sonra Tomasʼa şöyle dedi: “Parmağını buraya uzat, ellerime bak. Elini de uzat, böğrüme koy. Artık imansız olma, imanlı ol.” ");
INSERT INTO turobt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas Oʼna, “Rabbim ve Allahım!” diye karşılık verdi. ");
INSERT INTO turobt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","İsa ona şöyle dedi: “Beni gördüğün için mi iman ettin? Görmeden iman edenlere ne mutlu!” ");
INSERT INTO turobt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","İsa öğrencilerinin gözü önünde bu kitapta yazılı olmayan daha birçok mucize yaptı. ");
INSERT INTO turobt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Fakat bunlar, İsaʼnın Allahʼın Oğlu Mesih olduğuna inanmanız için yazılmıştır. Oʼna iman ederseniz Oʼnun adıyla hayat bulursunuz. ");
INSERT INTO turobt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bundan sonra, İsa Taberiye Gölüʼnün yanında öğrencilerine tekrar göründü. Bu da şöyle oldu: ");
INSERT INTO turobt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simun Petrus, İkiz diye bilinen Tomas, Celile bölgesindeki Kana köyünden olan Natanel, Zebediʼnin oğulları ve İsaʼnın öğrencilerinden iki kişi daha bir aradaydı. ");
INSERT INTO turobt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simun Petrus onlara şöyle dedi: “Ben balık tutmaya gidiyorum.” Onlar da, ona “Biz de seninle geliyoruz” dediler. Dışarı çıkıp tekneye bindiler. Ama o gece hiçbir şey tutmadılar. ");
INSERT INTO turobt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Güneş doğmak üzereyken İsa kıyıda durdu. Fakat öğrenciler Oʼnun İsa olduğunu anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","İsa onlara, “Çocuklar, balığınız yok mu?” diye sordu. Onlar, “Yok” diye cevap verdiler. ");
INSERT INTO turobt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","İsa onlara şöyle dedi: “Ağı teknenin sağ tarafına atın, o zaman balık tutarsınız.” Onlar da ağı attılar ve o kadar çok balık tuttular ki, ağı teknenin içine çekmeye güçleri yetmedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bunun üzerine İsaʼnın sevdiği öğrenci Petrusʼa, “Bu Rabʼdir!” dedi. Simun Petrus Oʼnun Rab olduğunu duyunca, iş elbisesine çekidüzen verdi, çünkü başka bir şey giymemişti. Sonra göle atladı. ");
INSERT INTO turobt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Öbür öğrenciler balık dolu ağı çekerek tekneyle geldiler. Karadan ancak yüz metre kadar uzaktaydılar. ");
INSERT INTO turobt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Karaya çıkınca kömürden bir ateş gördüler. Ateşin üstünde balık pişiyordu. Bir de ekmek vardı. ");
INSERT INTO turobt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","İsa onlara şöyle dedi: “Az önce tuttuğunuz balıklardan getirin.” ");
INSERT INTO turobt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simun Petrus da tekneye binip ağı karaya çekti. Ağ yüz elli üç büyük balıkla doluydu. O kadar çok balık olduğu halde ağ yırtılmadı. ");
INSERT INTO turobt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","İsa onlara, “Gelin, yemek yiyin!” dedi. Öğrencilerinden hiçbiri Oʼna, “Sen kimsin?” diye sormaya cesaret edemedi. Çünkü Oʼnun Rab olduğunu anladılar. ");
INSERT INTO turobt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","İsa da gidip ekmeği aldı ve onlara verdi. Aynı şekilde balıkları da verdi. ");
INSERT INTO turobt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bu, İsaʼnın ölümden dirildikten sonra öğrencilerine üçüncü görünüşüydü. ");
INSERT INTO turobt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yemekten sonra İsa Simun Petrusʼa şunu sordu: “Yuhanna oğlu Simun, beni bunlardan daha çok seviyor musun?” Petrus Oʼna şöyle dedi: “Evet, Rab, seni sevdiğimi biliyorsun.” İsa ona, “Kuzularımı otlat!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","İsa ona ikinci defa sordu: “Yuhanna oğlu Simun, beni seviyor musun?” Petrus ona şöyle dedi: “Evet, Rab, seni sevdiğimi biliyorsun.” İsa ona, “Koyunlarımı güt!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","İsa ona üçüncü defa sordu: “Yuhanna oğlu Simun, beni seviyor musun?” Petrus İsaʼnın ona üçüncü defa, “Sen beni seviyor musun?” diye sorduğuna üzüldü ve şöyle dedi: “Rab, her şeyi biliyorsun. Seni sevdiğimi de biliyorsun.” İsa ona, “Koyunlarımı otlat!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Sana doğrusunu söylüyorum, sen gençken, kendi kuşağını kendin bağlardın ve istediğin yere giderdin. Ama yaşlanınca ellerini uzatacaksın, başkası seni bağlayacak ve istemediğin yere götürecek.” ");
INSERT INTO turobt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Bunu söylemekle Petrusʼun ne çeşit ölümle Allahʼı yücelteceğine işaret ediyordu. Sonra, “Benim peşimden gel!” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus arkasına dönüp İsaʼnın sevdiği öğrencinin peşlerinden geldiğini gördü. Bu öğrenci, akşam yemeğinde İsaʼnın göğsüne yaslanan ve “Efendimiz, sana ihanet edecek olan kimdir?” diye soran öğrenciydi. ");
INSERT INTO turobt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus onu görünce İsaʼya, “Rab, ya ona ne olacak?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","İsa ona şöyle dedi: “Ben gelinceye dek onun hayatta kalmasını isteyecek olsam, bundan sana ne? Sen peşimden gel!” ");
INSERT INTO turobt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","İşte, bu yüzden imanlı kardeşlerin arasında, “O öğrenci hiç ölmeyecek” diye bir söylenti çıktı. Ama İsa onun ölmeyeceğini söylemedi. Sadece, “Ben gelinceye dek onun hayatta kalmasını isteyecek olsam, bundan sana ne?” dedi. ");
INSERT INTO turobt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bu olaylara şahitlik eden ve bunları yazan öğrenci budur. Onun şahitliğinin doğru olduğunu biliyoruz. ");
INSERT INTO turobt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","İsaʼnın yaptığı daha birçok şey var. Bunlar tek tek yazılsaydı, sanırım yazılan kitaplar dünyaya sığmazdı.");
INSERT INTO turobt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ey Teofilos, İlk kitabımda İsaʼnın göklere alındığı güne kadar yapmaya ve öğretmeye başladığı her şeyi yazdım. ");
INSERT INTO turobt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","İsa göklere alınmadan önce, seçtiği elçilere Kutsal Ruh aracılığıyla buyruklar verdi. ");
INSERT INTO turobt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Acı çekip öldükten sonra, birçok kanıtla elçilere dirilmiş olduğunu gösterdi. Kırk gün süresince onlara göründü ve Allahʼın Krallığı hakkında konuştu. ");
INSERT INTO turobt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bir gün onlarla yemek yerken şunları emretti: “Yeruşalimʼden ayrılmayın. Babaʼnın verdiği sözün yerine gelmesini bekleyin. Bunun hakkında konuştuğumu işittiniz. ");
INSERT INTO turobt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Şöyle ki, Yahya suyla vaftiz etti, ama siz birkaç güne kadar Kutsal Ruhʼla vaftiz olacaksınız.” ");
INSERT INTO turobt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Elçiler bir araya gelmişken, İsaʼya sordular: “Ya Rab, İsrailʼin krallığını şimdi mi yeniden kuracaksın?” ");
INSERT INTO turobt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Onlara şöyle dedi: “Babaʼnın kendi yetkisiyle kararlaştırdığı zamanları ve tarihleri bilmek size düşmez. ");
INSERT INTO turobt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama Kutsal Ruh üzerinize gelince kuvvet alacaksınız. Yeruşalimʼde, bütün Yahudiye ve Samiriyeʼde, dünyanın en uzak köşesine kadar benim şahitlerim olacaksınız.” ");
INSERT INTO turobt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","İsa bu sözleri söyledikten sonra, elçileri seyrederken yukarı alındı. Bir bulut İsaʼyı alıp götürdü. Oʼnu artık göremediler. ");
INSERT INTO turobt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","İsa giderken ve onların gözleri hâlâ göğe dikiliyken, birden yanlarında beyaz elbiseler içinde iki adam göründü. ");
INSERT INTO turobt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Şöyle dediler: “Celileli adamlar, neden göğe bakıp duruyorsunuz? Aranızdan göğe alınan İsa, aynen göğe çıktığını gördünüz gibi geri gelecek.” ");
INSERT INTO turobt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ondan sonra Zeytin Dağı denilen tepeden Yeruşalimʼe döndüler. O tepe Yeruşalimʼe yakındır. Bir kilometre kadar uzaklıktadır. ");
INSERT INTO turobt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Şehre varınca Petrus ve Yuhanna, Yakub ve Andreas, Filipus ve Tomas, Bartalmay ve Matta, Alpay oğlu Yakub ve “Yurtsever” Simun, ve Yakub oğlu Yahuda kaldıkları evin üst katına çıktılar. ");
INSERT INTO turobt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Onlar kendilerini tek bir fikirle hep duaya verdiler. Bazı kadınlar, İsaʼnın annesi Meryem ve İsaʼnın erkek kardeşleri onlara katıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","O günlerde Petrus imanlı kardeşlerin arasında ayağa kalktı. Aşağı yukarı yüz yirmi kişiden meydana gelen bir topluluk bir araya gelmişti. Petrus onlara şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kardeşler, Kutsal Yazıʼnın yerine gelmesi lazımdı. Bunu Kutsal Ruh, Davudʼun ağzıyla Yahuda hakkında önceden haber vermişti. Yahuda, İsaʼyı yakalayanlara yol gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Oysa bizden biriydi ve bu hizmette pay alırdı.” ");
INSERT INTO turobt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yahuda ihanetinin karşılığıyla bir tarla aldı. Sonra baş aşağı düştü, karnı yarıldı ve bütün bağırsakları dışarı fışkırdı. ");
INSERT INTO turobt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yeruşalimʼde yaşayan herkesin bu olaydan haberi oldu. Bu yüzden o tarlaya onların dilinde “Hakeldema” denilir. Bu ad “Kan Tarlası” anlamına gelir. ");
INSERT INTO turobt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus konuşmasına şöyle devam etti: “Mezmurlar kitabında şöyle yazılmıştır: ‘Onun evi ıssız kalsın, artık kimse orada oturmasın.’ Yine de: ‘Onun görevini başkası alsın.’ ");
INSERT INTO turobt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Bunun için, Rab İsa aramızdayken hep bizimle beraber olan adamlardan birini seçmeliyiz. ");
INSERT INTO turobt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bu kişi, İsaʼnın Yahya tarafından vaftiz edilmesinden göklere alınmasına kadar aramızda bulunmuş biri olmalı. Bize katılıp İsaʼnın dirilişine şahitlik etmeli.” ");
INSERT INTO turobt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","İki adamı öne çıkardılar: Biri Barsabba ve Yustus diye bilinen Yusuf, öbürüyse Mattiya idi. ");
INSERT INTO turobt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Şöyle dua ettiler: “Ya Rab, sen her insanın yüreğini biliyorsun. Bize bu ikisinden hangisini seçtiğini göster. ");
INSERT INTO turobt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yahudaʼnın hak ettiği yere gitmek için boş bıraktığı bu hizmeti ve elçilik görevini kim alsın?” ");
INSERT INTO turobt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ondan sonra bu iki kişi arasında kura çektirdiler. Kura Mattiyaʼya düştü. Böylece Mattiya seçilip on bir elçiye katıldı. ");
INSERT INTO turobt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikost Bayramı gelmişti. O gün imanlıların hepsi birlikte aynı yerdeydiler. ");
INSERT INTO turobt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Birdenbire gökten bir ses geldi. Bu ses, kuvvetle esen bir rüzgarın sesi gibiydi ve bulundukları evi doldurdu. ");
INSERT INTO turobt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Onlara dil şeklinde alevlere benzer bir şeyler göründü. Bunlar dağılarak her birinin üzerine indi. ");
INSERT INTO turobt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","İmanlıların hepsi Kutsal Ruhʼla doldu. Ruhʼun onları konuşturduğu başka diller konuşmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","O arada Yeruşalimʼde dünyanın bütün ülkelerinden gelen Yahudiler, Allahʼtan korkan adamlar vardı. ");
INSERT INTO turobt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bu ses duyulunca, büyük bir kalabalık bir araya geldi. Onlar şaşırıp kaldı, çünkü herkes kendi ana dilinde konuşulduğunu duydu. ");
INSERT INTO turobt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hayret ve şaşkınlık içinde şöyle dediler: “Şuna bak! Bu konuşanların hepsi Celileli değil mi? ");
INSERT INTO turobt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nasıl oluyor da her birimiz kendi ana dilini işitiyor? ");
INSERT INTO turobt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aramızda Partlar ve Medler, Elamlılar ve Mezopotamyaʼda yaşayanlar, Yahudiye ve Kapadokyaʼda, Pontus ve Ege bölgesinde, ");
INSERT INTO turobt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigya ve Pamfilyaʼda, Mısırʼda ve Libyaʼnın Kirene şehrinin etrafında oturanlar var. Romaʼdan gelen ");
INSERT INTO turobt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","hem asıl Yahudi hem de Yahudi inancını kabul eden ziyaretçiler, Giritliler ve Araplar var. Hepimiz Allahʼın yaptığı harikaların kendi dillerimizde konuşulduğunu duyuyoruz.” ");
INSERT INTO turobt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Herkes hayret ve şaşkınlık içinde birbirine “Bu ne demek oluyor?” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bazıları ise, onlarla alay ederek şöyle dediler: “Bunlar yeni şarabı fazla kaçırmış!” ");
INSERT INTO turobt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bunun üzerine Petrus öbür on bir elçiyle ayağa kalkıp sesini yükseltti ve kalabalığa şunları söyledi: “Ey Yahudi kardeşler ve Yeruşalimʼde oturan herkes, bu olayı size açıklayayım. Sözlerime kulak verin. ");
INSERT INTO turobt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bu insanlar sandığınız gibi sarhoş değiller. Saat daha sabahın dokuzu! ");
INSERT INTO turobt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hayır, bu Peygamber Yoelʼin aracılığıyla bildirilen olaydır: ");
INSERT INTO turobt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Allah şöyle diyor: Son günlerde bütün insanların üzerine Ruhumʼdan dökeceğim. Oğullarınız ve kızlarınız peygamberlik edecekler. Gençleriniz olağanüstü görüntüler, yaşlı adamlarınız rüyalar görecekler. ");
INSERT INTO turobt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Evet, o günlerde kadın erkek bütün kullarımın üzerine, Ruhumʼdan dökeceğim, onlar da peygamberlik edecekler. ");
INSERT INTO turobt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yukarıda, gökte harikalar, aşağıda, yeryüzünde mucizevi işaretler göstereceğim: kan, ateş ve duman bulutları. ");
INSERT INTO turobt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rabbin büyük ve görkemli günü gelmeden önce, güneş kapkaranlık olacak. Ay kan rengine dönecek. ");
INSERT INTO turobt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","O zaman Rabbi adıyla yardıma çağıran herkes kurtulacak.’ ");
INSERT INTO turobt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ey İsrail halkı! Şu sözleri dinleyin: Nasıralı İsa Allah tarafından kimliği size kanıtlanmış bir adamdır. Bildiğiniz gibi, Allah bunu Oʼnun aracılığıyla aranızda yapılan güçlü işler, harikalar ve mucizelerle yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Fakat Allahʼın önceden karar verdiği bir planı vardı. O, ne olacağını önceden biliyordu. Buna göre İsa elinize teslim edildi. Oʼnu Tevratʼı tanımayanların eliyle çarmıha çivileyip öldürdünüz. ");
INSERT INTO turobt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Fakat Allah Oʼnu diriltti. Oʼnun ölüm acılarına son verdi. Çünkü ölümün İsaʼyı esir tutması mümkün değildi. ");
INSERT INTO turobt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Evet, Davud Oʼnun hakkında şöyle der: ‘Gözümü Rabʼden asla ayırmam. O sağımda kaldığı için sarsılmam. ");
INSERT INTO turobt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Bu sebeple yüreğim mutlu ve dilim sevinçten coşuyor. Üstelik bedenim de umutla yaşayacak. ");
INSERT INTO turobt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Çünkü sen ya Rab, canımı ölüler dünyasına terk etmeyeceksin. Sana sadık olanın çürümesine de izin vermeyeceksin. ");
INSERT INTO turobt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sen nasıl hayat bulacağımı bana bildirdin. Huzurunda beni sevinçle dolduracaksın.’ ");
INSERT INTO turobt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kardeşler, yüce atamız Davud hakkında şunu kesinlikle söyleyebilirim. O öldü ve gömüldü. Onun mezarı bugüne kadar aramızdadır. ");
INSERT INTO turobt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Fakat Davud bir peygamberdi. Allahʼın ona yeminle söz verdiğini biliyordu. Bu söze göre Allah onun soyundan bir kişiyi tahtına oturtacaktı. ");
INSERT INTO turobt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Bunun için o ne olacağını gördü ve Mesihʼin dirilişi hakkında konuştu. Dedi ki, Mesih ‘ölüler dünyasına terk edilmedi’, ‘bedeninin çürümesine izin verilmedi’. ");
INSERT INTO turobt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Allah bu İsaʼyı ölümden diriltti. Biz hepimiz buna şahidiz. ");
INSERT INTO turobt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","İsa, Allahʼın sağına yükseltildi. Babaʼnın vaat ettiği Kutsal Ruhʼu alıp Oʼnu gördüğünüz ve işittiğiniz gibi üzerimize döktü. ");
INSERT INTO turobt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Elbette göğe çıkan Davud değildi; ama kendisi şöyle der: ‘Rab Efendimʼe dedi ki, “Senin düşmanlarını ayaklarına basamak yapacağım. O zamana kadar sağımda otur.” ’ ");
INSERT INTO turobt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Onun için bütün İsrail halkı şunu kesin olarak bilsin: sizin çarmıha gerdiğiniz bu İsaʼyı Allah hem Efendi, hem de Mesih yaptı!” ");
INSERT INTO turobt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Halk bunu işitince yüreklerine bıçak saplanmış gibi oldu. Petrusʼa ve öbür elçilere sordular: “Kardeşler, ne yapmalıyız?” ");
INSERT INTO turobt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus onlara şöyle dedi: “Tövbe edin ve her biriniz İsa Mesihʼin adıylavaftiz olsun. Böylece günahlarınız bağışlanacak ve Kutsal Ruhʼu karşılıksız alacaksınız. ");
INSERT INTO turobt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bu vaat sizin için, çocuklarınız ve uzakta olan herkes için, yani Rab Allahımızʼın kendisine çağıracağı herkes içindir.” ");
INSERT INTO turobt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus daha birçok sözle onları sıkı sıkı uyardı. “Kendinizi bu sapık kuşağın uğrayacağı cezadan kurtarın!” diye yalvardı. ");
INSERT INTO turobt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sonuçta Petrusʼun sözünü kabul edenler vaftiz oldu. O gün yaklaşık üç bin kişi topluluğa katıldı. ");
INSERT INTO turobt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Onlar kendilerini elçilerin öğrettiklerini dinlemeye, beraberliğe, ekmek bölüp paylaşmaya ve dua etmeye adadılar. ");
INSERT INTO turobt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Herkes hayranlıkla karışık korku içindeydi. Elçilerin aracılığıyla birçok harika ve mucize yapılıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bütün iman edenler bir aradaydı, her şeyi paylaşıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mallarını mülklerini satıp parasını herkese ihtiyacına göre dağıtıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Günden güne tek bir fikirle kendilerini tapınak avlusunda toplanmaya adadılar. Evlerde ekmek bölüp paylaşıyorlardı. Hep birlikte coşkun bir sevinç ve temiz yürekle yemek yiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Allahʼı devamlı övüyorlardı. Bütün halk onları beğeniyordu. Rab da her gün kurtulan kişileri onların topluluğuna katıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bir gün Petrus ve Yuhanna dua saatinde tapınağa çıkıyorlardı. Saat öğleden sonra üçtü. ");
INSERT INTO turobt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Doğuştan sakat bir adam oraya getiriliyordu. Bu adamı tapınak avlusuna giren kişilerden para dilenmesi için her gün “Güzel Kapı” denilen avlu kapısının önüne bırakırlardı. ");
INSERT INTO turobt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petrusʼla Yuhanna tapınak avlusuna girmek üzereydi. Adam onları görünce, onlardan para istedi. ");
INSERT INTO turobt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","O zaman Petrusʼla Yuhanna ona dikkatle baktılar. Sonra Petrus, “Bize bak!” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Adam da bir şey alacağını umarak onlara dikkatle baktı. ");
INSERT INTO turobt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Fakat Petrus ona şöyle dedi: “Bende gümüş ve altın yok. Ama bende ne varsa, onu sana veriyorum: Nasıralı İsa Mesihʼin adıyla kalk, yürü!” ");
INSERT INTO turobt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sonra Petrus adamı sağ elinden tutup ayağa kaldırdı. Aynı anda adamın ayakları ve ayak bilekleri sapasağlam oldu. ");
INSERT INTO turobt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Adam ayağa fırlayarak dimdik durdu ve yürümeye başladı. Yürüye, zıplaya, Allahʼı överek onlarla birlikte tapınak avlusuna girdi. ");
INSERT INTO turobt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bütün halk onun yürüdüğünü ve Allahʼı övdüğünü gördü. ");
INSERT INTO turobt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tapınağın Güzel Kapısında oturup dilenen adam olduğunu fark ettiler. Ona olanlara şaşırıp hayret ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Adam Petrusʼla Yuhannaʼnın yanından ayrılmadı. Bütün halk da şaşkınlık içinde onların yanına koştu. Tapınağın “Süleymanʼın Kemeraltı” denilen üstü kapalı kısmında toplandılar. ");
INSERT INTO turobt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus bunu görünce, halka şöyle vaaz etmeye başladı: “Ey İsrail halkı! Buna neden şaştınız? Niçin gözlerinizi bize dikmiş bakıyorsunuz? Sanmayın ki bu adamı kendi kuvvetimizle, ya da dindarlığımızla yürüttük! ");
INSERT INTO turobt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","İbrahimʼin, İshakʼın ve Yakubʼun ve diğer Atalarımızın tapındığı Allah, hizmetkârı İsaʼyı yüceltti. Siz ise Oʼnu ele verdiniz. Vali Pilatus Oʼnu serbest bırakmaya karar verdi, fakat siz Oʼnu Pilatusʼun önünde reddettiniz. ");
INSERT INTO turobt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kutsal ve Doğru Olanʼı reddettiniz ve bir katilin serbest bırakılmasını istediniz. ");
INSERT INTO turobt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hayat Kaynağıʼnı öldürdünüz. Fakat Allah Oʼnu ölümden diriltti. Biz buna şahidiz. ");
INSERT INTO turobt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","İsaʼnın adı, gördüğünüz ve tanıdığınız bu adama şifa verdi. Çünkü o, İsaʼnın adına iman etti. Evet, İsaʼya olan iman onu hepinizin önünde sapasağlam yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Şimdi, kardeşlerim, sizin de aynı liderleriniz gibi bilgisizlikle davrandığınızı biliyorum. ");
INSERT INTO turobt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fakat Allah, bütün peygamberlerin ağzından, Mesihiʼnin acı çekeceğini önceden bildirmişti. Bu haberi de söylediği şekilde yerine getirdi. ");
INSERT INTO turobt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bunun için tövbe edin, Allahʼa dönün, öyle ki, günahlarınız silinsin. ");
INSERT INTO turobt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Öyle ki, Rab size yenilenme fırsatları versin ve sizin için önceden seçilen Mesihʼi, yani İsaʼyı göndersin. ");
INSERT INTO turobt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Her şey bir gün yeniden yaratılacak. Allah bunu ta eski zamanlardan beri kutsal peygamberlerinin ağzından bildirmişti. O zamana kadar İsaʼnın gökte kalması lazım. ");
INSERT INTO turobt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa şöyle dedi: ‘Rab Allahınız kendi halkınızdan sizin için benim gibi bir peygamber ortaya çıkaracak. Oʼnun size söyleyeceği her şeye kulak vermelisiniz. ");
INSERT INTO turobt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","O peygamberin sözünü dinlemeyen herkes Allahʼın halkından atılıp yok olacak.’ ");
INSERT INTO turobt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuelʼden başlayarak, onun ardından konuşan bütün peygamberler bu günleri bildirdi. ");
INSERT INTO turobt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Peygamberlerin evlatları sizsiniz. Allahʼın atalarınızla yaptığı antlaşmaya ortaksınız. Allah İbrahimʼe şöyle söz verdi: ‘Senin soyun sayesinde yeryüzündeki bütün halklar bereketlenecek.’ ");
INSERT INTO turobt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Allah, hizmetkârı İsaʼyı önce sizin için ortaya çıkardı. Oʼnu her birinizi yaptığınız kötülüklerden döndürüp bereketlemek için gönderdi.” ");
INSERT INTO turobt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrusʼla Yuhanna daha halkla konuşuyordu. Birden rahipler, tapınak polislerinin komutanı ve Sadukiler denen din partisinden bazı adamlar onların karşısına dikildiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bu adamlar çok kızgındı, çünkü Petrusʼla Yuhanna halka vaaz ediyorlardı. İsaʼnın ölümden dirildiğini, böylece tüm ölülerin de dirileceğini bildiriyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Petrusʼla Yuhannaʼyı yakaladılar. Akşam olduğu için ertesi güne kadar onları hapiste tuttular. ");
INSERT INTO turobt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Fakat o konuşmayı dinleyenlerden birçok kişi iman etti. Böylece iman eden erkeklerin sayısı aşağı yukarı beş bine çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ertesi gün halkın liderleri, Meclis üyeleri ve Tevrat uzmanları Yeruşalimʼde toplantıya çağırıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Başrahip Hanan, Kayafa, Yohanan, İskender ve başrahibin soyundan gelen herkes oradaydı. ");
INSERT INTO turobt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Petrusʼla Yuhannaʼyı orta yere dikip onları şöyle sorgulamaya başladılar: “Siz bunu hangi güçle ya da kimin adıyla yaptınız?” ");
INSERT INTO turobt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","O an Kutsal Ruhʼla dolmuş olan Petrus onlara şöyle dedi: “Ey halkın liderleri ve Meclis üyeleri! ");
INSERT INTO turobt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Biz sakat bir adama iyilik yaptık, ona nasıl şifa verdik diye mi bugün sorgulanıyoruz? ");
INSERT INTO turobt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Siz ve bütün İsrail halkı bilin ki, bu adam Nasıralı İsa Mesih adıyla önünüzde sağlam duruyor. Siz İsaʼyı çarmıha gerdiniz, ama Allah Oʼnu ölümden diriltti. ");
INSERT INTO turobt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Siz inşaatçıların reddettiği taş olan bu İsa, binanın köşe taşı oldu. ");
INSERT INTO turobt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","İsaʼdan başka hiç kimsede kurtuluş yoktur. Kurtuluşumuz için göğün altında insanlara bağışlanmış başka hiçbir ad yoktur.” ");
INSERT INTO turobt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Meclis üyeleri Petrus ve Yuhannaʼnın cesaretle konuştuklarını gördüler ve onların okumamış ve sıradan kişiler olduklarını anlayınca şaşkına döndüler. Ayrıca onların daha önce İsaʼyla birlikte olduğunu fark ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","İyileşmiş olan adamı da Petrus ve Yuhannaʼnın yanında görünce söyleyecek bir şey bulamadılar. ");
INSERT INTO turobt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Onların Meclis odasından çıkmalarını emrettikten sonra tartışmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Bu adamları ne yapacağız?” dediler. “Çünkü Yeruşalimʼde oturan herkes onların olağanüstü bir mucize yaptığını biliyor. Bunu inkâr edemeyiz. ");
INSERT INTO turobt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama bunun halk arasında daha fazla yayılmasını önlemek için onları tehdit edelim. Böylece bir daha bu adamın adını anarak hiç kimseyle konuşmasınlar.” ");
INSERT INTO turobt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Petrusʼla Yuhannaʼyı çağırdılar. “Kesinlikle İsa adını ağzınıza almayın, Oʼnun hakkında vaaz etmeyin” diye onlara buyruk verdiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama Petrus ve Yuhanna onlara şöyle cevap verdiler: “Allahʼın gözünde doğru olan ne? Allahʼın mı yoksa sizin sözünüzü mü dinleyelim? Buna siz karar verin. ");
INSERT INTO turobt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Çünkü biz gördüğümüz ve duyduğumuz şeyleri konuşmadan duramayız.” ");
INSERT INTO turobt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Meclis üyeleri Petrusʼla Yuhannaʼyı bir daha tehdit ettikten sonra serbest bıraktılar. Onlara ceza vermenin bir yolunu bulamadılar. Çünkü bütün halk olup bitenler için Allahʼı övüyordu. ");
INSERT INTO turobt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hem de bu mucizeyle şifa bulan adamın yaşı kırkı geçmişti. ");
INSERT INTO turobt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petrus ve Yuhanna serbest bırakıldıktan sonra, arkadaşlarına döndüler. Başrahiplerin ve liderlerin onlara söylediklerini anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","İmanlılar bunu duyunca seslerini yükseltip hep birlikte Allahʼa şöyle dua ettiler: “Ey Efendimiz! Gökyüzünü, yeryüzünü, denizi ve onların içinde olan her şeyi yaratan sensin. ");
INSERT INTO turobt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kutsal Ruh aracılığıyla, hizmetkârın olan atamız Davudʼun ağzından şöyle dedin: ‘Milletler niçin kafa tutup kızdılar? Halklar neden boş planlar kurdular? ");
INSERT INTO turobt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dünyanın kralları savaşa hazırlandılar. Rabbe ve Oʼnun Mesihiʼne karşı liderler bir araya geldiler.’ ");
INSERT INTO turobt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gerçekten bu şehirde Hirodes ve Pontiyus Pilatus, İsrail halkı ve diğer milletlerden kişilerle toplandılar. Mesih olarak seçtiğin kutsal hizmetkârın İsaʼya karşı geldiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Onlar ancak senin gücün ve isteğinle önceden karar verdiğini yerine getirebildiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Şimdi, ya Rab, onların tehditlerine bak. Biz hizmetkârlarına güç ver ki, senin sözünü tam bir cesaretle bildirelim. ");
INSERT INTO turobt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sen de aynı zamanda elini uzat ki, senin kutsal hizmetkârın İsaʼnın adıyla hastalara şifa verilsin, mucizeler ve harikalar yapılsın.” ");
INSERT INTO turobt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Onların duası bittikten sonra toplandıkları yer sarsıldı. Hepsi Kutsal Ruhʼla dolup Allahʼın sözünü cesaretle bildirmeye devam ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","İman edenlerin topluluğu yürekte ve düşüncede birdi. Onlardan hiçbiri malı mülkü için “bu benimdir” demiyordu. Her şeyi paylaşıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Elçiler de büyük kuvvetle Rab İsaʼnın ölümden dirilişine şahitlik ediyorlardı. Allah da bütün imanlılara lütfunu bol bol gösteriyordu. ");
INSERT INTO turobt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Aralarında muhtaç olan yoktu. Çünkü tarlaları ya da evleri olanlar bunları satıyor, satıştan aldıkları parayı elçilerin emrine veriyorlardı. Elçiler de bu paradan herkese ihtiyacına göre dağıtıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bir de Yusuf adlı bir adam vardı. Kendisi Kıbrıs doğumlu bir Leviliydi. Elçiler ona Barnaba lâkabını taktılar. Bu lâkap “Cesaret Veren” anlamına gelir. ");
INSERT INTO turobt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Onun bir tarlası vardı. Tarlayı satıp parasını elçilerin emrine verdi. ");
INSERT INTO turobt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hananya adında bir adam karısı Safiraʼyla anlaşarak bir mülk sattı. ");
INSERT INTO turobt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Paranın bir kısmını kendisine ayırdı. Gerisini getirip elçilerin emrine verdi. Karısının her şeyden haberi vardı. ");
INSERT INTO turobt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petrus ona şöyle dedi: “Hananya, neden Şeytanʼa uydun? Kutsal Ruhʼa yalan söyledin. Neden tarladan aldığın paranın bir kısmını kendine ayırdın? ");
INSERT INTO turobt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tarla satılmadan önce senin değil miydi? Satıldıktan sonra da parayı istediğin gibi kullanamaz mıydın? Nasıl oldu da yüreğinde bu işe yer verdin? İnsanlara değil, Allahʼa yalan söyledin.” ");
INSERT INTO turobt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananya bu sözleri işitince yere yıkılıp can verdi. Bu olaydan haber alan herkesin üzerine büyük bir korku düştü. ");
INSERT INTO turobt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Genç adamlar kalkıp Hananyaʼnın ölüsünü kefene sardılar, sonra dışarıya taşıyıp gömdüler. ");
INSERT INTO turobt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aradan aşağı yukarı üç saat geçtikten sonra Hananyaʼnın karısı içeri girdi. Fakat olanlardan haberi yoktu. ");
INSERT INTO turobt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus söz alıp şöyle dedi: “Söyle bana, tarlayı filanca paraya mı sattınız?” Safira da, “Evet, o paraya” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bunun üzerine Petrus ona şöyle dedi: “Neden Rabbin Ruhuʼnu denemek için söz birliği yaptınız? İşte kocanı gömen kişilerin ayak sesleri kapıda duyuluyor. Onlar seni de dışarıya taşıyacaklar.” ");
INSERT INTO turobt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Safira hemen Petrusʼun ayaklarının dibine yıkılıp can verdi. O anda genç adamlar içeri girdiler. Safiraʼyı ölü buldular ve onu dışarıya taşıyıp kocasının yanına gömdüler. ");
INSERT INTO turobt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bütün imanlılar topluluğu ve bu olaydan haber alan herkes büyük korkuya kapıldı. ");
INSERT INTO turobt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Halk arasında elçilerin elleriyle birçok mucize ve harika yapılıyordu. Hep birlikte tek bir fikirle “Süleymanʼın Kemeraltı” denen üstü kapalı kısmında toplanıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Diğer Yahudiler onlara katılmaya cesaret edemediler. Yine de halk onlara büyük saygı gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gittikçe daha fazla kişi, hem erkek hem de kadın, Rabbe iman edip onlara katıldı. ");
INSERT INTO turobt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sonuçta hastaları sokağa çıkarıp yataklar ve döşeklerin üzerine yatırdılar. Bunu Petrus oradan geçerken, hiç değilse gölgesi bazılarının üzerine düşsün de şifa versin diye yaptılar. ");
INSERT INTO turobt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yeruşalimʼin etrafındaki kasabalardan birçok insan geliyordu. Hastalarını ve şeytani ruhlardan eziyet çekenleri getiriyorlardı. Onların hepsi iyileşti. ");
INSERT INTO turobt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","O arada başrahip harekete geçti. Kendisi ve yanında bulunanların hepsi, yani Saduki partisinden olanlar kıskançlıkla doldular. ");
INSERT INTO turobt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Elçileri yakalatıp herkesin gözü önünde hapishaneye attılar. ");
INSERT INTO turobt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Fakat Rabbin bir meleği geceleyin hapishanenin kapılarını açtı ve elçileri dışarıya çıkarıp şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gidin, tapınak avlusunda durun ve bu yaşam yolu hakkındaki her şeyi halka anlatın!” ");
INSERT INTO turobt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Elçiler bunu duyunca sabaha doğru tapınak avlusuna gidip vaaz etmeye başladılar. Bu arada başrahip ve yanında bulunan adamlar geldiler ve Meclisʼi, yani İsrail halkının bütün liderlerini toplantıya çağırdılar. Ondan sonra elçilerin getirilmesi için hapishaneye haber yolladılar. ");
INSERT INTO turobt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Fakat oraya giden tapınak polisleri onları hapishanede bulmadılar. Bunun üzerine dönüp durumu anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hapishaneyi kapalı kilitli bulduk” dediler. “Bekçiler de kapıların önünde duruyorlardı. Fakat kapıları açınca içerde kimseyi bulmadık.” ");
INSERT INTO turobt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tapınak polislerinin komutanı ve başrahipler bu sözleri işitince şaşırıp kaldılar ve bu işin sonu ne olacak diye merak ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","O sırada birisi gelip onlara şu haberi getirdi: “Sizin hapishaneye attığınız adamlar var ya! İşte, onlar tapınak avlusunda durmuş halka vaaz ediyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","O zaman komutan, öbür polislerle birlikte, elçileri getirmeye gitti. Fakat hiç zor kullanmadılar, çünkü halkın kendilerini taşlamasından korkuyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Elçileri getirip Meclisʼin önüne çıkardılar. Başrahip onları sorguya çekmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Size kesin bir emir vermiştik” dedi. “Bu adamın adıyla vaaz etmeyin demiştik. Fakat siz inancınızı Yeruşalimʼin her tarafına yaydınız. Üstelik bu adamın kanını dökmekten bizi sorumlu tutmak istiyorsunuz.” ");
INSERT INTO turobt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Fakat Petrus ve öbür elçiler şöyle cevap verdiler: “İnsanlardan çok Allahʼa itaat etmeliyiz. ");
INSERT INTO turobt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Siz İsaʼyı ağaçtan bir çarmıha asıp öldürdünüz. Fakat atalarımızın Allahı Oʼnu diriltti. ");
INSERT INTO turobt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allah Oʼnu Lider ve Kurtarıcı olarak kendi sağına yükseltti. Böylece İsrail halkına günahlarından tövbe edip bağışlanma fırsatını verdi. ");
INSERT INTO turobt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Biz bu olayların şahitleriyiz, Kutsal Ruh da şahittir. Allah Kutsal Ruhʼu kendisine itaat edenlere verir.” ");
INSERT INTO turobt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bunu işitince, Meclis üyeleri öfkeden kudurdular ve elçileri öldürmek istediler. ");
INSERT INTO turobt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Orada Gamaliyel adında bir Ferisi vardı. O bir Tevrat öğretmeniydi ve bütün halk ona saygı gösterirdi. Meclisʼte ayağa kalkıp elçilerin kısa bir zaman için dışarı çıkarılmasına buyruk verdi. ");
INSERT INTO turobt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ondan sonra Gamaliyel Meclis üyelerine şunu söyledi: “Değerli soydaşlarım! Siz bu adamlara bir şey yapmayı düşünürken dikkatli davranın! ");
INSERT INTO turobt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bir süre önce Tevdas kendini önemli biri göstererek ayaklandı. Dört yüz kadar kişi ona katıldı. Adam öldürüldü. Onu izleyenler de dağıtıldı. Başlattığı hareket de yok olup gitti. ");
INSERT INTO turobt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bu adamdan sonra, halk sayımı yapıldığı günlerde, Celileli Yahuda ayaklandı ve arkasından bir sürü insan sürükledi. O adam da yok oldu ve onu izleyenler dağıtıldı. ");
INSERT INTO turobt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Şimdiki duruma gelince, size şunu söylüyorum: bu adamlardan uzak durun, bırakın gitsinler. Çünkü eğer bu plan, bu hareket insan işiyse, o zaman kendiliğinden yok olacak. ");
INSERT INTO turobt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama eğer bu iş Allahʼın işiyse bu adamları yok edemezsiniz. Tersine, kendinizi Allahʼa karşı savaşır durumda bulabilirsiniz.” Meclisʼtekiler Gamaliyelʼin fikrini kabul ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ondan sonra elçileri içeri çağırtıp kamçılattılar. Onlara bir daha İsaʼnın adını anarak konuşmamaları için buyruk verdiler. Sonra onları serbest bıraktılar. ");
INSERT INTO turobt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Elçiler Meclisʼten ayrılırken, İsaʼnın adı uğruna aşağılanmaya layık sayıldıkları için sevindiler. ");
INSERT INTO turobt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Her gün hem tapınak avlusunda, hem de evden eve giderek, vaaz etmeye devam ettiler. İsaʼnın Mesih olduğunu müjdelemekten vazgeçmediler. ");
INSERT INTO turobt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","O günlerde İsaʼnın öğrencileri gittikçe çoğalıyordu. Toplulukta her gün dul kadınlara yardım dağıtılıyordu. Bir ara, Grekçe konuşan Yahudiler, İbranice konuşan Yahudilerden şikâyet etmeye başladılar. “Günlük yardım dağıtılmasında bizim dul kadınlarımıza ilgi gösterilmiyor” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","O zaman on iki elçi, öğrencilerin hepsini toplantıya çağırıp şöyle dedi: “Dullara yardım dağıtmak için Allahʼın sözünü vaaz etmeyi bırakmamız uygun değildir. ");
INSERT INTO turobt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kardeşler, aranızdan yedi adam seçin. Onlar Kutsal Ruh ve hikmetle dolu, saygıya değer insanlar olarak tanınmış olsunlar. Onları bu işin başına koyacağız. ");
INSERT INTO turobt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Biz ise, kendimizi duaya ve Allahʼın sözünü duyurma hizmetine verelim.” ");
INSERT INTO turobt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bütün topluluk bu teklifi beğendi. Böylece iman ve Kutsal Ruhʼla dolu bir adam olan İstefanosʼu seçtiler. Bir de Filipus, Prohoros, Nikanor, Timon, Parmenas ve daha önce Yahudi inancını kabul eden Antakyalı Nikolasʼı seçtiler. ");
INSERT INTO turobt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Onları elçilerin önüne getirdiler. Elçiler de bu yedi kişiyi görevlendirmek için onlara elleriyle dokunup dua ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Böylece Allahʼın sözü yayılmaya devam etti. Yeruşalimʼde İsaʼnın öğrencilerinin sayısı arttıkça arttı. Hatta rahiplerden birçoğu iman çağrısına uyuyordu. ");
INSERT INTO turobt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","İstefanos Allahʼın lütfu ve gücüyle doluydu. Halk arasında olağanüstü mucizeler ve harikalar yapıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Fakat “Serbest Bırakılanlar” denilen toplantı yerinden bazı Yahudiler İstefanosʼa karşı çıktılar. Onlar Kirene ile İskenderiye şehirlerinden ve Kilikya ile Ege bölgelerindendiler. İstefanosʼla tartışmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Fakat İstefanosʼun konuşmasındaki hikmete ve Ruhʼa karşı koyamadılar. ");
INSERT INTO turobt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bunun üzerine “Bu adamın Musaʼya ve Allahʼa hakaret ettiğini işittik” demeleri için bazı adamlara rüşvet verdiler. ");
INSERT INTO turobt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Böylece halkı, liderleri ve Tevrat uzmanlarını ayağa kaldırdılar. İstefanosʼun üzerine yürüdüler. Onu yakalayıp Meclisʼin önüne götürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oraya yalancı şahitler getirdiler. Bu şahitler de şöyle dediler: “Bu adam durmadan bu Kutsal Yerʼi ve Tevratʼı kötülüyor. ");
INSERT INTO turobt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","‘Şu Nasıralı İsa bu tapınağı yok edecek ve Musaʼnın bize verdiği adetleri değiştirecek’ dediğini işittik.” ");
INSERT INTO turobt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Meclisʼte oturanların hepsi gözlerini İstefanosʼun üzerine dikti. Yüzünün bir melek yüzüne benzediğini gördüler. ");
INSERT INTO turobt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Başrahip, “Bu suçlamalar doğru mu?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","İstefanos şöyle cevap verdi: “Kardeşler ve babalar, bana kulak verin! Yüce Allah, atamız İbrahimʼe göründü. O sırada İbrahim Mezopotamyaʼdaydı. Hâlâ Harranʼa yerleşmemişti. ");
INSERT INTO turobt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Allah ona şöyle dedi: ‘Memleketinden ve akrabalarından ayrıl ve sana göstereceğim ülkeye git!’ ");
INSERT INTO turobt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ondan sonra İbrahim, Kildan topraklarından ayrıldı ve Harran şehrine yerleşti. Babası öldükten sonra Allahʼın emriyle oradan çıkıp sizin şimdi oturduğunuz bu ülkeye göç etti. ");
INSERT INTO turobt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Burada Allah ona hiçbir miras, bir karış toprak bile vermedi. O sırada İbrahimʼin çocuğu yoktu. Ne var ki, Allah İbrahimʼe bu ülkeyi ona ve soyuna mülk olarak vereceğine söz verdi. ");
INSERT INTO turobt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allah ona şöyle dedi: ‘Senin soyun yabancı bir ülkede gurbetçi olacak. Orada dört yüz sene köle olarak çalışacaklar, eziyet görecekler. ");
INSERT INTO turobt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama köle olarak hizmet ettikleri milleti ben yargılayacağım. Ondan sonra oradan çıkıp bana bu yerde tapınacaklar.’ ");
INSERT INTO turobt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Allah İbrahimʼle bir antlaşma yaptı. Bu antlaşmanın işareti sünnet idi. Böylece İbrahim İshakʼın babası olunca onu sekiz günlükken sünnet etti. İshak, Yakubʼun babası oldu. Yakub da on iki büyük atamızın babası oldu. ");
INSERT INTO turobt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bu atalarımız Yusufʼu kıskanıp onu Mısırʼa giden tüccarlara köle olarak sattılar. Fakat Allah ona hep yardım etti. ");
INSERT INTO turobt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Onu bütün sıkıntılarından kurtardı. Ona hikmet verdi. Firavunʼun, yani Mısır kralının gözüne girmesini sağladı. Firavun onu Mısırʼa ve bütün saray halkına yönetici yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Sonra bütün Mısır ve Kenan topraklarında kıtlık oldu. Korkunç sıkıntılar başladı. Atalarımız yiyecek bulamaz oldular. ");
INSERT INTO turobt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ama Yakub Mısırʼda buğday olduğunu işitince, atalarımızı oraya yolladı. Bu onların ilk gidişiydi. ");
INSERT INTO turobt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","İkinci gidişlerinde Yusuf kendini kardeşlerine tanıttı. Böylece Firavun Yusufʼun ailesiyle tanıştı. ");
INSERT INTO turobt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusuf da haber yollayıp babası Yakubʼu ve bütün ailesini çağırttı. Hepsi toplam yetmiş beş kişiydiler. ");
INSERT INTO turobt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakub Mısırʼa gitti. Orada kendisi ve atalarımız öldüler. ");
INSERT INTO turobt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ama kemikleri oradan alınıp Şekem kasabasına götürüldü. İbrahim orada bir miktar gümüş ödeyerek Hamorʼun oğullarından bir mezar satın almıştı. İşte, atalarımızın kemikleri oraya koyuldu. ");
INSERT INTO turobt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Fakat Allah İbrahimʼe vaat etmişti. O vaadin yerine gelme vakti yaklaştığında, halkımız Mısırʼda fazlasıyla çoğalmıştı. ");
INSERT INTO turobt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sonunda başka bir kral Mısırʼda tahta çıktı. Bu kralın Yusufʼtan haberi yoktu. ");
INSERT INTO turobt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","O, bizim halkımıza kurnazca davrandı. Atalarımıza öyle eziyet etti ki, yeni doğan çocuklarını dışarda ölüme terk etmeye zorladı. ");
INSERT INTO turobt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","O arada Musa doğdu. Musa Allahʼın gözünde özel bir çocuktu. Babasının evinde üç ay bakıldı. ");
INSERT INTO turobt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sonra dışarıya terk edildi. Ama Firavunʼun kızı onu evlat edindi ve onu kendi oğluymuş gibi büyüttü. ");
INSERT INTO turobt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa, Mısırlıların okuduğu bütün konularda eğitim gördü. Hem sözde, hem işte güçlü bir adam oldu. ");
INSERT INTO turobt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Musa kırk yaşına gelince, kendi halkı olan İsrailoğullarına gidip hallerini sormaya karar verdi. ");
INSERT INTO turobt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Onlardan birine haksızlık yapıldığını görünce adamı savundu. İntikamını almak için ona eziyet eden Mısırlıyı öldürdü. ");
INSERT INTO turobt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Allah Musaʼyı halkını kurtarmakla görevlendirmişti. Musa, soydaşlarının bunu anlayacağını düşündü, ama anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ertesi gün, kavga eden iki soydaşına rast geldi. Onları barıştırmaya çalıştı. ‘Siz kardeşsiniz’ dedi. ‘Niçin birbirinize haksızlık ediyorsunuz?’ ");
INSERT INTO turobt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama soydaşına haksızlık eden adam Musaʼyı iterek ‘Seni üzerimize kim lider ve yargıç yaptı?’ dedi. ");
INSERT INTO turobt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Yoksa dün o Mısırlıyı öldürdüğün gibi beni de mi öldürmek istiyorsun?’ ");
INSERT INTO turobt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bu sözü duyunca Musa kaçtı. Gidip Midyan ülkesinde gurbette yaşadı. Orada iki oğul babası oldu. ");
INSERT INTO turobt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Aradan kırk yıl geçti. Musaʼya Sina Dağı yakınlarında ıssız bir yerdeyken yanan bir çalının alevleri içinde bir melek göründü. ");
INSERT INTO turobt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa gördüklerine hayret etti. Daha yakından bakmak için yaklaştı. O zaman Rabbin sesini duydu: ");
INSERT INTO turobt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ben atalarının Allahıʼyım. İbrahimʼin, İshakʼın ve Yakubʼun Allahı benim.’ Musa korkudan titredi ve çalıya bakmaya cesaret edemedi. ");
INSERT INTO turobt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Rab ona şöyle dedi: ‘Ayaklarından sandaletlerini çıkar, çünkü durduğun yer kutsal topraktır. ");
INSERT INTO turobt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Elbette, halkımın Mısırʼda ne kadar eziyet çektiğini gördüm. Ah çekmelerini işittim ve onları kurtarmak için indim. Şimdi gel, seni Mısırʼa göndereceğim.’ ");
INSERT INTO turobt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kendisinden yüz çevirdikleri adam Musaʼydı. Ona ‘Seni üzerimize kim lider ve yargıç yaptı?’ demişlerdi. Musa Allahʼın gönderdiği kişiydi. Çalının içinden görünen meleğin aracılığıyla Allah onu hem lider, hem kurtarıcı yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Evet bu adam halkı Mısırʼdan çıkardı. Mısırʼda, Kızıldenizʼde ve ıssız yerlerde kırk yıl boyunca mucizeler ve harikalar yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Bu aynı Musa İsrailoğullarına dedi ki, ‘Allah size kardeşlerinizin arasından benim gibi bir peygamber ortaya çıkaracak.’ ");
INSERT INTO turobt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aynı Musa ıssız yerlerde Allahʼın topluluğu arasında yaşıyordu. Atalarımızla beraber olan Musa Sina Dağıʼnda kendisiyle konuşan melekle görüştü. Bize ulaştırmak için, ondan hayat veren sözler aldı. ");
INSERT INTO turobt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Atalarımız onun sözünü dinlemek istemediler. Onu reddettiler. Yüreklerinde Mısırʼa dönme hevesi vardı. ");
INSERT INTO turobt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Harunʼa şöyle dediler: ‘Bizim için önümüzden gidecek olan tanrılar yap. Çünkü bizi Mısırʼdan çıkaran şu Musaʼya ne oldu bilmiyoruz.’ ");
INSERT INTO turobt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","O zaman dana şeklinde bir put yaptılar. Puta tapmak için kurban kestiler. Kendi elleriyle yaptıkları put için bayram yaptılar. ");
INSERT INTO turobt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Allah ise onlardan yüz çevirdi. Onları gökteki yıldızlara tapsınlar diye kendi hallerine bıraktı. Peygamberlerin kitabında yazıldığı gibi: ‘Ey İsrail halkı, kırk yıl boyunca ıssız yerlerde bana mı adaklar, kurbanlar sundunuz? ");
INSERT INTO turobt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hayır, siz Molekʼin ibadet çadırını ve tanrınız Refanʼın yıldızını taşıdınız. Bunlar tapmak için yaptığınız putlardı. Ben de sizi Babilʼin ötesine süreceğim.’ ");
INSERT INTO turobt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Issız yerlerde atalarımızın ‘Şahitlik Çadırı’ denen ibadet çadırı vardı. Musaʼyla konuşan Allah ona bu çadırı yapmasını buyurmuştu. Musa da onu kendisine gösterilen örneğe göre yaptı. ");
INSERT INTO turobt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Atalarımız Şahitlik Çadırıʼnı önceki kuşaktan teslim aldılar. Onu Yeşuʼnun önderliğinde diğer milletlerin topraklarını ele geçirdikleri zaman buraya getirdiler. Allah o milletleri önlerinden kovdu, topraklarını atalarımıza verdi. Çadır Davudʼun zamanına kadar kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davud Allahʼın lütfuna kavuştu. Allahʼtan İsrail halkına bir tapınak yapmak için izin istedi. ");
INSERT INTO turobt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama Allahʼa tapınak yapan Süleyman oldu. ");
INSERT INTO turobt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ne var ki, yüce Allah ellerle yapılmış binalarda oturmaz. Peygamberin söylediği gibi: ");
INSERT INTO turobt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Rab diyor ki, Gökyüzü benim tahtımdır, yeryüzü de ayaklarıma basamaktır. Bana nasıl bir ev yapacaksınız? Ya da dinlenme yerim neresi? ");
INSERT INTO turobt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bütün bunları yapan, benim elim değil miydi?’ ");
INSERT INTO turobt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sizi dik kafalılar! Yürekleriniz ve kulaklarınız hâlâ sünnetsiz. Siz her zaman Kutsal Ruhʼa karşı koyuyorsunuz. Atalarınızın yaptığı gibi yapıyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Atalarınız peygamberlerin hangisine eziyet etmediler ki? Doğru Olanʼın geleceğini önceden bildiren peygamberleri bile öldürdüler. Siz de şimdi Doğru Olanʼa ihanet edip Oʼnun katilleri oldunuz! ");
INSERT INTO turobt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Siz Tevratʼı meleklerin aracılığıyla aldınız, ama yerine getirmediniz.” ");
INSERT INTO turobt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bunu işitince, öfkeden kudurdular ve İstefanosʼa karşı diş bilemeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Fakat o, Kutsal Ruhʼla doldu, gözlerini göğe dikti. Allahʼın görkemini ve İsaʼnın Allahʼın sağ tarafında durduğunu gördü ");
INSERT INTO turobt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ve şöyle dedi: “İşte, göklerin açıldığını ve İnsan Oğluʼnun Allahʼın sağ tarafında durduğunu görüyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bunun üzerine var güçleriyle bağırdılar, kulaklarını tıkayıp hep birlikte İstefanosʼa saldırdılar. ");
INSERT INTO turobt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Onu şehirden çıkarıp taşlamaya başladılar. İstefanosʼa karşı şahitlik etmiş olanlar da kaftanlarını çıkarıp Saul adında genç bir adamın ayaklarının dibine bıraktılar. ");
INSERT INTO turobt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Onlar İstefanosʼu taşlarken, o “Ya Rab İsa, ruhumu al!” diye yalvardı. ");
INSERT INTO turobt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dizlerinin üstüne düşüp yüksek sesle, “Ya Rab, bu günahı onlara sayma!” Bunu söyledikten sonra gözlerini yaşama kapadı. ");
INSERT INTO turobt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul İstefanosʼun öldürülmesine razı gelmişti. O gün Yeruşalimʼdeki imanlılar topluluğuna karşı korkunç bir eziyet zamanı başladı. Elçilerden başka, imanlıların hepsi Yahudiye ve Samiriye bölgelerinde her tarafa dağıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Allahʼtan korkan bazı adamlar da İstefanosʼun cenazesini kaldırdılar. Ondan sonra İstefanos için derin üzüntüyle yas tuttular. ");
INSERT INTO turobt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul ise imanlılar topluluğunu yok etmeye çalıştı. Ev ev dolaşıp kadın erkek demeden, imanlıları dışarı sürüklüyor, hapishaneye atıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bunun üzerine dağılmış olan imanlılar her yeri dolaşarak Allahʼın sözünü müjdelediler. ");
INSERT INTO turobt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipus da Samiriye şehrine gitti ve oradakilere Mesih hakkında vaaz etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Halk Filipusʼun söylediklerini işitip yaptığı mucizeleri gördü. Söylediklerini can kulağıyla dinlediler. ");
INSERT INTO turobt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Çünkü şeytani ruhlar birçoklarının içinden var gücüyle bağırarak çıkıyordu. Birçok felçli ve sakat insan şifa buluyordu. ");
INSERT INTO turobt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Böylece o şehirde büyük sevinç oldu. ");
INSERT INTO turobt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aynı şehirde Simun adında bir adam vardı. Bir süreden beri orada büyücülük yaparak Samiriye halkını şaşkına çeviriyordu. Kendisinin önemli bir adam olduğunu söylüyordu. ");
INSERT INTO turobt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Küçük büyük, herkes onu dikkatle dinliyordu. Şöyle diyorlardı: “Bu adam, ‘Allahʼın Büyük Gücü’ denen kişidir!” ");
INSERT INTO turobt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Halkı uzun zamandan beri yaptığı büyücülükle şaşkınlık içinde bırakmıştı. Bu yüzden onu dikkatle dinliyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipus ise, halka Allahʼın Krallığını ve İsa Mesihʼin adını müjdeliyordu. Onlar da Filipusʼun söylediklerine inandılar. Kadın erkek, hepsi vaftiz oldu. ");
INSERT INTO turobt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simunʼun kendisi bile inandı. Vaftiz olduktan sonra Filipusʼun yanından ayrılmadı. Yapılan olağanüstü harikaları ve mucizeleri görünce şaşırıp kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yeruşalimʼdeki elçiler Samiriye halkının Allahʼın sözünü kabul ettiğini öğrenince Petrusʼla Yuhannaʼyı onlara gönderdiler. ");
INSERT INTO turobt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Petrusʼla Yuhanna oraya varınca iman edenlerin Kutsal Ruhʼu almaları için dua ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Çünkü Kutsal Ruh henüz hiçbirinin üzerine inmemişti. Sadece Rab İsaʼnın adıylavaftiz olmuşlardı. ");
INSERT INTO turobt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sonra Petrusʼla Yuhanna iman edenlere elleriyle dokunup onları kutsadılar. Onlar da Kutsal Ruhʼu aldılar. ");
INSERT INTO turobt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simun Kutsal Ruhʼun elçilerin dokunmasıyla verildiğini görünce onlara para teklif etti. ");
INSERT INTO turobt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Bana da aynı yetkiyi verin. Öyle ki, ellerimle kime dokunursam o Kutsal Ruhʼu alsın” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama Petrus ona şöyle dedi: “Paran seninle birlikte yok olsun! Çünkü Allahʼın karşılıksız verdiğini sen parayla satın alabileceğini sandın. ");
INSERT INTO turobt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bu işte senin ne payın, ne de hakkın var. Çünkü Allahʼın gözünde yüreğin dürüst değil. ");
INSERT INTO turobt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Onun için bu kötü niyetinden tövbe et. Rabbe yalvar, eğer mümkünse, senin yüreğindeki bu niyet bağışlansın. ");
INSERT INTO turobt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Çünkü senin kıskançlıkla dolu ve günaha esir olduğunu görüyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simun cevap verip şöyle dedi: “Siz benim için Rabbe yalvarın ki söylediğiniz şeylerden hiçbiri başıma gelmesin.” ");
INSERT INTO turobt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Böylece Petrusʼla Yuhanna İsa hakkında şahitlik edip Rabbin sözünü duyurdular. Sonra Yeruşalimʼe dönerken Samiriyelilerin birçok köyünde Müjdeʼyi duyurdular. ");
INSERT INTO turobt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","O arada Rabbin bir meleği Filipusʼa şunu söyledi: “Kalk, güneye doğru, Yeruşalimʼden Gazzeʼye inen ıssız yola git!” ");
INSERT INTO turobt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipus da kalkıp oraya gitti. Yolda Etiyopyalı bir hadıma rastladı. Adam Etiyopya kraliçesi Kandakeʼnin vezirlerinden biriydi. Kraliçenin bütün hazinesinden sorumluydu. Allahʼa ibadet etmek için Yeruşalimʼe gelmişti. ");
INSERT INTO turobt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ülkesine dönerken at arabasında oturmuş, peygamber Yeşayaʼnın kitabını okuyordu. ");
INSERT INTO turobt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kutsal Ruh Filipusʼa, “Git, şu arabaya yetiş” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipus koşup at arabasının yanına vardı. Vezirin Yeşaya Peygamberʼin kitabından okuduğunu işitince ona sordu: “Acaba okuduklarını anlıyor musun?” ");
INSERT INTO turobt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Vezir de şöyle cevap verdi: “Birisi bana yol göstermedikçe nasıl anlayabilirim?” Ondan sonra Filipusʼun arabaya binip yanına oturmasını rica etti. ");
INSERT INTO turobt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Vezirin Kutsal Yazılarʼdan okuduğu parça şuydu: “Koyun gibi kesilmeye götürüldü. Kuzu kırkıcının önünde nasıl ses çıkarmazsa, o da ağzını açmadı. ");
INSERT INTO turobt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Aşağılandı ve adaletten yoksun kaldı. Soyundan kim söz edecek? Çünkü Oʼnun yeryüzündeki hayatına son verildi.” ");
INSERT INTO turobt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Vezir de Filipusʼa dönüp şöyle dedi: “Rica ederim, söyle bana, peygamber kimden söz ediyor? Kendisinden mi yoksa başka birisinden mi?” ");
INSERT INTO turobt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipus Kutsal Yazılarʼın o bölümünden başlayarak vezire İsaʼyı müjdeledi. ");
INSERT INTO turobt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Yollarına devam ederlerken, su bulunan bir yere geldiler. O zaman vezir şöyle dedi: “İşte su! Vaftiz olmama ne engel var?” ");
INSERT INTO turobt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sonra at arabasının durdurulmasını buyurdu. Filipusʼla vezir birlikte suya indiler. Filipus da onu vaftiz etti. ");
INSERT INTO turobt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sudan çıktıklarında Rabbin Ruhu Filipusʼu hemen alıp götürdü. Yoluna sevinçle devam eden vezir, Filipusʼu bir daha görmedi. ");
INSERT INTO turobt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipus ise kendini Aşdod şehrinde buldu. Sezariyeʼye varıncaya kadar, bütün kasabaları dolaşarak Müjdeʼyi duyurdu. ");
INSERT INTO turobt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bu arada Saul hâlâ Rabbin öğrencilerini tehdit ediyor, onlara karşı ölüm kusuyordu. Başrahibe gitti. ");
INSERT INTO turobt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ondan Şam şehrindeki toplantı yerlerine mektuplar yazmasını istedi. Erkek kadın demeden İsaʼnın yolunda kimi bulsa tutuklayıp Yeruşalimʼe getirecekti. ");
INSERT INTO turobt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saul yolculuk yaparken Şamʼa yaklaştı. Birdenbire gökten bir ışık onun etrafını aydınlattı. ");
INSERT INTO turobt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saul yere yıkılıp bir ses duydu. Ses, “Saul, Saul! Niçin bana eziyet ediyorsun?” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul, “Kimsin, Efendim?” diye sordu. Gelen cevap şuydu: “Ben senin eziyet ettiğin İsaʼyım. ");
INSERT INTO turobt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Haydi, kalk ayağa, şehre gir ve ne yapacağın sana söylenecek.” ");
INSERT INTO turobt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulʼla birlikte yolculuk yapan adamların dilleri tutuldu ve oldukları yerde kalakaldılar. Sesi işittiler ama kimseyi göremediler. ");
INSERT INTO turobt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul yerden kalktı. Fakat gözlerini açtığında hiçbir şey göremedi. Yol arkadaşları onu elinden tutarak Şam şehrine götürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saulʼun gözleri üç gün görmedi. O sürede hiçbir şey yiyip içmedi. ");
INSERT INTO turobt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Şamʼda İsaʼnın Hananya adında bir öğrencisi vardı. Rab ona olağanüstü bir görüntüde göründü. Ona, “Hananya!” dedi. O da, “Buyur, ya Rab!” dedi. “Dinliyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Rab ona şunları söyledi: “Kalk, Doğru Sokak denilen sokakta Yahudaʼnın evine git. Orada Saul adında Tarsuslu bir adamı sor. O şu anda dua ediyor. ");
INSERT INTO turobt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Olağanüstü bir görüntü gördü. Görüntüde Hananya adında bir adam içeri girdi ve gözlerinin açılması için ona dokundu.” ");
INSERT INTO turobt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananya ise şöyle cevap verdi: “Ya Rab, bu adam hakkında birçok kişiden haber aldım. Yeruşalimʼde senin kutsal halkına ne kadar zarar verdiğini duydum. ");
INSERT INTO turobt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Burada da senin adını anan herkesi tutuklamak için başrahiplerden yetki almış.” ");
INSERT INTO turobt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fakat Rab ona şöyle dedi: “Git, çünkü bu adamı ben seçtim. Adımı diğer milletlere, krallara ve İsrailoğullarına bildirecek aracım olacak. ");
INSERT INTO turobt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Benim adım uğruna ne kadar acı çekmesi gerektiğini ona göstereceğim.” ");
INSERT INTO turobt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","O zaman Hananya yola çıkıp o eve girdi. Saulʼa elleriyle dokunup şöyle dedi: “Saul kardeş, sen buraya gelirken yolda sana görünen Rab, yani İsa, gözlerin açılsın ve Kutsal Ruhʼla dolasın diye beni gönderdi.” ");
INSERT INTO turobt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aynı anda Saulʼun gözlerinden balık pulları gibi bir şeyler düştü ve o yeniden görmeye başladı. Kalkıp vaftiz oldu. ");
INSERT INTO turobt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sonra yemek yiyip kuvvet buldu. Saul birkaç gün İsaʼnın Şamʼdakiöğrencilerinin yanında kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hemen Yahudilerin toplantı yerlerinde İsa hakkında vaaz etmeye başladı. “O Allahʼın Oğluʼdur” diyordu. ");
INSERT INTO turobt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulʼu duyan herkes hayret içinde kalıp şöyle dedi: “Yeruşalimʼde bu adı ananları yok etmeye çalışan adam bu değil mi? Buraya da onları tutuklayıp başrahiplerin önüne çıkarmak için gelmedi mi?” ");
INSERT INTO turobt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Fakat Saulʼun vaazları gittikçe daha etkili oldu. İsaʼnın Mesih olduğunu kanıtlayarak Şamʼda oturan Yahudileri cevapsız bıraktı. ");
INSERT INTO turobt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Uzun süre sonra, Yahudi liderler Saulʼu öldürmek için gizli bir plan kurdular. ");
INSERT INTO turobt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ama Saul onların planının haberini aldı. Şehrin kapılarını gece gündüz gözlüyorlardı. Saul şehirden çıkacak olursa onu öldüreceklerdi. ");
INSERT INTO turobt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Saulʼun öğrencileri ise onu gece alıp büyük bir sepet içinde şehir duvarının bir deliğinden aşağıya indirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bunun üzerine Saul Yeruşalimʼe gitti. İsaʼnın öğrencilerine katılmaya çalıştı, ama hepsi ondan korktular. Onun bir öğrenci olduğuna inanmadılar. ");
INSERT INTO turobt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Fakat Barnaba yardımına gelip onu elçilerin yanına götürdü. Onlara Saulʼun nasıl yolda Rabbi gördüğünü, Rabbin de onunla konuştuğunu ve Saulʼun Şamʼda İsa adını nasıl korkusuzca duyurduğunu anlattı. ");
INSERT INTO turobt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saul elçilerle kaldı. Onlarla birlikte Yeruşalimʼde serbestçe dolaşırken, Rabbin adını korkusuzca duyuruyordu. ");
INSERT INTO turobt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saul Grekçe konuşan Yahudilerle sohbet edip tartışıyordu. Onlar ise onu öldürmeyi planlıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","İmanlı kardeşler bu durumdan haber alınca, Saulʼu Sezariye şehrine götürdüler, oradan da Tarsusʼa gönderdiler. ");
INSERT INTO turobt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Böylece bütün Yahudiye, Celile ve Samiriye bölgelerindeki imanlılar topluluğu esenliğe kavuştu ve güçlendi. Topluluk Rab korkusu içinde yaşayıp Kutsal Ruhʼun verdiği cesaretle büyümeye devam etti. ");
INSERT INTO turobt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Öyle oldu ki, Petrus oradan oraya dolaşırken, Lidda kasabasındaki imanlılara da uğradı. ");
INSERT INTO turobt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Orada Eneyas adında bir adama rast geldi. Eneyas felçliydi. Sekiz yıldan beri yatalaktı. ");
INSERT INTO turobt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus ona dedi: “Eneyas, İsa Mesih seni iyileştiriyor. Kalk, yatağını topla.” O da anında kalktı. ");
INSERT INTO turobt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidda ve Şaronʼda oturanların hepsi adamı görünce Rabbe döndüler. ");
INSERT INTO turobt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yafa şehrinde İsaʼnın öğrencilerinden Tabita adında bir kadın vardı. Kadının adı “Ceylan” anlamına gelir. Bu kadın devamlı iyilik yapıp fakirlere yardım ederdi. ");
INSERT INTO turobt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","O günlerde hastalanıp öldü. Ölüsünü yıkadıktan sonra evinin üst katındaki odaya koydular. ");
INSERT INTO turobt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda ise Yafa şehrine yakındı. Yafaʼdaki imanlılar Petrusʼun Liddaʼda olduğundan haber aldılar. Bunun için ona iki adam yolladılar. Adamlar Petrusʼa şöyle yalvardılar: “Haydi hiç oyalanmadan bize gel!” ");
INSERT INTO turobt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus da kalkıp onlarla gitti. Eve varınca, onu üst kattaki odaya götürdüler. Bütün dul kadınlar Petrusʼun etrafında toplandılar. Ağlayarak ona Tabitaʼnın hâlâ aralarındayken diktiği bütün paltoları ve diğer elbiseleri gösterdiler. ");
INSERT INTO turobt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fakat Petrus onların hepsini odadan çıkardı. Diz çöküp dua etti. Sonra ölüye döndü ve “Tabita, kalk!” dedi. Tabita gözlerini açtı ve Petrusʼu görünce doğruldu. ");
INSERT INTO turobt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus da ona elini uzattı ve onu ayağa kaldırdı. Sonra dul kadınları ve diğer imanlıları çağırıp onlara Tabitaʼyı diri olarak gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bu olayın haberi bütün Yafaʼya yayıldı ve birçok kişi Rabbe iman etti. ");
INSERT INTO turobt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ondan sonra Petrus uzun bir süre Yafaʼda derici Simun adında bir adamın evinde kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sezariye şehrinde Kornelyus adında bir adam vardı. Roma ordusunun “İtalyan” bölüğünde yüzbaşıydı. ");
INSERT INTO turobt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bütün ev halkıyla birlikte Allahʼa saygı ve korkuyla kulluk eden bir adamdı. Fakir halka cömertlikle yardım edip Allahʼa sürekli dua ederdi. ");
INSERT INTO turobt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bir gün öğleden sonra saat üçe doğru olağanüstü bir görüntüde Allahʼın bir meleğini açıkça gördü. Melek içeri girdi ve ona, “Kornelyus!” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelyus gözlerini ona dikti. Korku içinde, “Ne var, efendim?” dedi. Melek ona şöyle dedi: “Allah senin dualarını ve fakirlere yaptığın yardımları huzuruna yükselen bir hoş koku gibi kabul etti. ");
INSERT INTO turobt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Şimdi Yafa şehrine adam yolla, Petrus lakabıyla bilinen Simun adlı adamı çağırt! ");
INSERT INTO turobt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","O, derici Simun adında birinin evinde kalıyor. Onun evi de deniz kenarındadır”. ");
INSERT INTO turobt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kendisiyle konuşan melek ayrıldıktan sonra Kornelyus ev kölelerinden ikisini, bir de özel yardımcılarından dindar bir askeri yanına çağırdı. ");
INSERT INTO turobt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Her şeyi anlattıktan sonra onları Yafaʼya yolladı. ");
INSERT INTO turobt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ertesi gün öğleye doğru yolda ilerleyip şehre yaklaşırlarken Petrus dua etmek için evin damına çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Acıkınca yemek istedi. Yemek hazırlanırken, Petrus olağanüstü hale dalıp bir görüntü gördü. ");
INSERT INTO turobt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Göğün açıldığını ve büyük bir çarşafa benzeyen bir şeyin indiğini gördü. Çarşaf dört köşesinden tutulup yere kadar sarkıtıldı. ");
INSERT INTO turobt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Onun içinde her çeşit dört ayaklı hayvan, sürüngen ve kuş bulunuyordu. ");
INSERT INTO turobt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bir ses ona, “Petrus, kalk, kes ve ye!” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Fakat Petrus şöyle cevap verdi: “Ya Rab! Bu, kesinlikle olmaz! Ben şimdiye kadar murdar ya da din bakımından kirli olan hiçbir şey yemedim!” ");
INSERT INTO turobt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ses ona ikinci defa geldi: “Allahʼın temiz kıldığı şeyleri, artık murdar sayma!” ");
INSERT INTO turobt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bu üç defa oldu. Sonra çarşafa benzeyen şey hemen göğe çekildi. ");
INSERT INTO turobt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrusʼun kafası iyice karışmıştı. Görmüş olduğu olağanüstü görüntünün anlamını kestiremiyordu. Tam o sırada, Kornelyusʼun gönderdiği adamlar sora sora Simunʼun evini buldular ve kapının önünde durdular. ");
INSERT INTO turobt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yüksek sesle, “Petrus lakabıyla bilinen Simun adında biri burada mı kalıyor?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus daha o görüntünün ne anlama geldiğini düşünürken, Kutsal Ruh ona, “Bak, üç adam seni arıyor” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","“Kalk, aşağı in, hiç çekinmeden onlarla git. Çünkü onları ben gönderdim.” ");
INSERT INTO turobt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus inip adamların yanına gitti ve şöyle dedi: “İşte, aradığınız kişi benim. Ne için geldiniz?” ");
INSERT INTO turobt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Şöyle dediler: “Kornelyus adında bir yüzbaşı var. O, Allahʼtan korkan doğru bir adamdır. Bütün Yahudi halkı ona saygı duyar. Allah ona kutsal bir melek aracılığıyla buyruk vermiş, seni evine çağırtmasını, söyleyeceğin sözleri dinlemesini emretmiş.” ");
INSERT INTO turobt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bunun üzerine Petrus onları içeri buyurup misafir etti. Ertesi gün Petrus kalkıp onlarla birlikte yola çıktı. Yafaʼdaki imanlılardan bazıları ona eşlik ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bir gün sonra Sezariyeʼye vardılar. Kornelyus onları bekliyordu. Bütün akrabalarını ve yakın arkadaşlarını da çağırmıştı. ");
INSERT INTO turobt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrus evine girecekken Kornelyus onu karşıladı ve eğilip ayaklarına kapandı. ");
INSERT INTO turobt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Petrus onu ayağa kaldırıp şöyle dedi: “Kalk, ben de sadece bir insanım.” ");
INSERT INTO turobt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kornelyusʼla konuşa konuşa eve girdi ve orada bir sürü kişiyi toplanmış buldu. ");
INSERT INTO turobt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Onlara şunları söyledi: “Siz kendiniz biliyorsunuz ki, bir Yahudinin bir yabancıyla yakın ilişki kurması, onu ziyaret etmesi dinimize aykırıdır. Fakat Allah bana hiç kimseyi murdar ya da din bakımından kirli saymamam gerektiğini gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bunun için çağrıldığım zaman, problem çıkarmadan geldim. Şimdi sorabilir miyim, beni ne maksatla buraya çağırttınız?” ");
INSERT INTO turobt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelyus şöyle cevap verdi: “Üç gün önce aynı saatte, öğleden sonra saat üçte evimde dua ediyordum. Aniden parlak elbise giyinmiş bir adam önüme çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","O bana şöyle dedi: ‘Kornelyus, Allah senin dualarını işitti ve fakirlere yaptığın yardımları kabul etti. ");
INSERT INTO turobt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bu nedenle Yafa şehrine haber gönder ve Petrus lakabıyla bilinen Simunʼu çağırt. O, deniz kenarında derici Simunʼun evinde kalıyor.’ ");
INSERT INTO turobt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Böylece sana hemen haber yolladım. Sen de iyilik ettin ve geldin. Evet, biz burada hepimiz Allahʼın huzurunda toplandık. Rabbin sana buyurduğu her şeyi dinlemeye hazırız”. ");
INSERT INTO turobt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus şöyle konuşmaya başladı: “Gerçekten anladım ki, Allah insanlar arasında ayrım yapmaz. ");
INSERT INTO turobt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Hangi milletten olursa olsun kendisinden korkan ve doğru olanı yapan kişiyi kabul eder. ");
INSERT INTO turobt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Allahʼın İsrailoğullarına bildirdiklerinden haberiniz var. O, İsa Mesihʼin aracılığıyla esenlik müjdeledi. İsa Mesih herkese hâkim olan Rabʼdir. ");
INSERT INTO turobt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yahudiyeʼnin her tarafında neler olduğunu biliyorsunuz. Olaylar, Yahyaʼnın vaftiz çağrısından sonra Celile bölgesinde başladı. ");
INSERT INTO turobt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Allah Nasıralı İsaʼyı meshetti ve Kutsal Ruhʼla güçlendirdi. İsa her tarafı gezip iyilik yaptı. İblisʼin eziyet ettiği insanların hepsini iyileştirdi. Çünkü Allah Oʼnunla birlikteydi. ");
INSERT INTO turobt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Biz de İsaʼnın Yahudi topraklarında ve Yeruşalimʼde yaptığı her şeye şahidiz. Oʼnu çarmıha asıp öldürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Fakat Allah Oʼnu üçüncü gün ölümden diriltti ve Oʼnu diri olarak insanlara gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","İsa bütün halka görünmedi. Allahʼın önceden seçtiği şahitlere göründü. O şahitler biziz. İsa ölümden dirildikten sonra Oʼnunla birlikte yedik içtik. ");
INSERT INTO turobt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O, halka vaaz etmemizi emretti. Allah İsaʼyı ölülerle dirilerin yargıcı olarak seçti. Buna şahitlik etmemizi buyurdu. ");
INSERT INTO turobt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bütün peygamberler İsa hakkında şahitlik ediyor, ‘Oʼna iman eden herkesin günahları Oʼnun adıyla bağışlanacak’ diyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus daha bu sözleri söylerken, Kutsal Ruh konuşmayı dinleyen herkesin üzerine indi. ");
INSERT INTO turobt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Petrusʼla birlikte gelen Yahudi imanlılar şaşırıp kaldılar. Çünkü Allah, Kutsal Ruh armağanını Yahudi olmayanların üzerine dökmüştü. ");
INSERT INTO turobt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yahudi imanlılar Yahudi olmayanların da başka diller konuşup Allahʼı övdüklerini duydular. Bunun üzerine Petrus şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Madem onlar bizim gibi Kutsal Ruhʼu almışlar, kimse suyla vaftiz olmalarına engel olamaz, değil mi?” ");
INSERT INTO turobt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Böylece İsa Mesihʼin adıylavaftiz olmalarını buyurdu. Sonra onlar Petrusʼun birkaç gün daha yanlarında kalmasını rica ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bu arada elçiler ve Yahudiyeʼdeki imanlılar, diğer milletlerin de Allahʼın sözünü kabul ettiğini duydular. ");
INSERT INTO turobt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petrus Yeruşalimʼe varınca, sünnete önem veren Yahudi imanlılar onu eleştirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Sen sünnetsiz kişilerle aynı çatı altına girip onlarla birlikte yemek yemişsin!” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petrus olup bitenleri onlara tek tek anlatmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ben Yafa şehrindeyken dua ediyordum” dedi. “O sırada olağanüstü hale dalıp bir görüntü gördüm. Büyük çarşafa benzeyen bir şey dört köşesinden tutulup gökten aşağıya indirildi. Bulunduğum yere kadar geldi. ");
INSERT INTO turobt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gözlerimi çarşafa dikip onu inceledim. Yeryüzünde yaşayan dört ayaklı hayvanlar, yabani hayvanlar, sürüngenler ve kuşlar gördüm. ");
INSERT INTO turobt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sonra bana, ‘Petrus, kalk, kes ve ye!’ diyen bir ses işittim. ");
INSERT INTO turobt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Fakat ben şöyle dedim: ‘Ya Rab! Kesinlikle olmaz! Murdar ya da din bakımından kirli olan bir şey asla ağzıma girmedi.’ ");
INSERT INTO turobt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ses ikinci defa gökten, ‘Allahʼın temiz kıldığı şeyi, murdar sayma’ dedi. ");
INSERT INTO turobt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bu olay üç defa oldu. Ondan sonra her şey tekrar göğe çekildi. ");
INSERT INTO turobt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tam o anda kaldığım evin önünde üç adam durdu. Onlar Sezariye şehrinden bana gönderilmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kutsal Ruh bana, problem çıkarmadan onlarla gitmemi söyledi. Bu altı kardeş de benimle geldi ve biz adamın evine girdik. ");
INSERT INTO turobt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O da bize kendi evinde görünen meleği nasıl gördüğünü anlattı. Melek ona şöyle demiş: ‘Yafaʼya haber yolla ve Petrus lakabıyla bilinen Simunʼu buraya çağırt. ");
INSERT INTO turobt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Onun sana söyleyeceği sözlerle sen ve bütün ev halkın kurtuluş bulacaksınız.’ ");
INSERT INTO turobt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Konuşmaya başladım. Tam o sırada Kutsal Ruh üzerimize ilk indiği gibi onların üzerine de indi. ");
INSERT INTO turobt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","O zaman Rabbin şu sözü aklıma geldi: ‘Yahya suyla vaftiz etti, ama siz Kutsal Ruhʼla vaftiz olacaksınız.’ ");
INSERT INTO turobt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Allah onlara, Rab İsa Mesihʼe iman eden bizlere verdiğinin aynısını verdi. Bu durumda ben kimim ki, Allahʼa karşı geleyim?” ");
INSERT INTO turobt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bunu işitince yatıştılar ve Allahʼı yüceltip şöyle dediler: “Demek, Allah diğer milletlere de tövbe edip sonsuz yaşama kavuşma fırsatını vermiş.” ");
INSERT INTO turobt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","İstefanosʼun öldürülmesinden sonra eziyet sonucu dağılan imanlılar ta Fenike, Kıbrıs ve Antakyaʼya kadar gittiler. İsa hakkındaki haberi Yahudilerden başka kimseye duyurmadılar. ");
INSERT INTO turobt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Fakat aralarında bazı Kıbrıslı ve Kireneli adamlar vardı. Onlar Antakyaʼya gelip Greklerle de konuşmaya başladılar. Greklere Rab İsaʼyı müjdelediler. ");
INSERT INTO turobt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Rabbin eli onların üzerindeydi ve birçok kişi iman edip Rabbe döndü. ");
INSERT INTO turobt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Olup bitenlerin haberi Yeruşalimʼdeki imanlılar topluluğuna ulaştı. Bunun üzerine Barnabaʼyı Antakyaʼya yolladılar. ");
INSERT INTO turobt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnaba oraya vardığında Allahʼın oradakilere gösterdiği lütfu görünce sevindi. Rabbe canı gönülden sadık kalmaları için herkese cesaret verdi. ");
INSERT INTO turobt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","O, Kutsal Ruh ve imanla dolu, iyi bir adamdı. Böylece daha birçok kişi Rabbin topluluğuna katıldı. ");
INSERT INTO turobt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bundan sonra Barnaba, Saulʼu aramak için Tarsusʼa gitti. ");
INSERT INTO turobt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Onu bulunca da Antakyaʼya geri getirdi. Bir yıl boyunca imanlılar topluluğuna katılıp birçok kişiyi eğittiler. İsaʼnın öğrencilerine Hristiyan adı ilk kez Antakyaʼda verildi. ");
INSERT INTO turobt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","O günlerde Yeruşalimʼden birkaç peygamber Antakyaʼya geldi. ");
INSERT INTO turobt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Onların arasında Hagabos adında biri vardı. O ayağa kalkıp bütün dünyada korkunç bir kıtlık olacağını Kutsal Ruh aracılığıyla bildirdi. Bu kıtlık da İmparator Klavdiyusʼun zamanında oldu. ");
INSERT INTO turobt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bunun üzerine Antakyaʼdaki imanlılar Yahudiyeʼde yaşayan imanlılara yardım etmeye karar verdiler. Her biri elinden geldiği kadar yardım gönderecekti. ");
INSERT INTO turobt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bağışlarını Barnaba ve Saulʼun eliyle Yeruşalimʼdeki topluluk liderlerine gönderdiler. ");
INSERT INTO turobt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","O sırada kral Hirodes imanlılar topluluğundan bazı kişilere eziyet etmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yuhannaʼnın kardeşi Yakubʼu kılıçla öldürttü. ");
INSERT INTO turobt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yahudilerin bundan memnun kaldığını fark edince Petrusʼu da tutuklattı. O günlerde Mayasız Ekmek Bayramı kutlanıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petrusʼu yakalatıp hapishaneye attırdı. Onu kollamak için başına dörder kişilik dört takım asker koydu. Özgürlük Bayramıʼndan sonra Petrusʼu halkın önünde yargılamak istiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Böylece Petrus hapishanede gözaltına alındı. Fakat imanlılar topluluğu onun için Allahʼa canı gönülden dua ediyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tam Hirodesʼin onu halkın önünde yargılamak istediği günden önceki gece, Petrus iki zincirle bağlı olarak iki askerin arasında uyuyordu. Kapının önünde gardiyanlar durup, hapishanenin güvenliğini sağlıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Birdenbire Rabbin bir meleği göründü. Hücrede ışık parladı. Melek Petrusʼun yan tarafını dürtüp onu uyandırdı. “Çabuk kalk!” dedi. Bunun üzerine zincirler Petrusʼun bileklerinden düştü. ");
INSERT INTO turobt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Melek ona şöyle dedi: “Kemerini bağla ve ayaklarına sandaletlerini giy!” Petrus da öyle yaptı. Melek, “Paltonu üstüne al ve peşimden gel” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petrus dışarı çıktı ve meleğin arkasından gitti. Meleğin yaptığının gerçek olduğunu anlamıyor, olağanüstü bir görüntü gördüğünü sanıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Birinci ve ikinci nöbetçiyi geçtiler, sonra şehre açılan demir kapıya kadar geldiler. Kapı kendiliğinden açıldı. Dışarı çıkıp sokağın sonuna kadar yürüdükten sonra melek birdenbire Petrusʼun yanından ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","O zaman Petrus kendine geldi ve şöyle dedi: “Rab bana meleğini göndermiş! Bunu şimdi gerçekten anlıyorum. Rab beni Hirodesʼin elinden ve Yahudi halkının bana yapmayı umduğu her şeyden kurtardı.” ");
INSERT INTO turobt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Petrus olanların farkına varınca Meryemʼin evine gitti. Meryem Markos lakabıyla bilinen Yuhannaʼnın annesiydi. Orada birçok kişi toplanmış dua ediyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrus evin dış kapısını çaldı. Roda adında hizmetçi kız kapıyı açmaya gitti. ");
INSERT INTO turobt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrusʼun sesini tanıdı, ama o kadar sevinçliydi ki, kapıyı açmadan içeri koştu. “Petrus kapıda duruyor!” diye haber verdi. ");
INSERT INTO turobt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ona, “Sen çıldırmışsın!” dediler. Fakat kız ısrar edince, “Galiba onun meleğidir” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrus ise kapıyı çalmaya devam etti. Kapıyı açıp onu gördüler ve şaşırıp kaldılar. ");
INSERT INTO turobt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus susmaları için eliyle işaret etti. Onlara Rabbin kendisini nasıl hapisten çıkardığını anlattı. “Bu haberi Yakubʼa ve diğer imanlılara götürün” dedi. Ondan sonra oradan ayrıldı, başka yere gitti. ");
INSERT INTO turobt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sabah olunca askerler büyük telaşa düştü. “Petrusʼa ne oldu?” diye sordular. ");
INSERT INTO turobt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hirodes de Petrusʼu arattı ama bulamadı. Bekçileri sorguya çekti ve öldürülmelerini emretti. Ondan sonra Hirodes Yahudiyeʼden Sezariye şehrine gitti. Bir süre orada kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirodes, Sur ve Sayda şehir halklarına karşı çok öfkeliydi. Onlar da kralın saray yöneticisi olan Vlastusʼu kendi taraflarına çektiler ve hep birlikte Hirodesʼten barış istemeye gittiler. Çünkü memleketlerinin yiyeceği Hirodesʼin ülkesinden geliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Karar verilen günde Hirodes krallık elbiselerini içinde tahtına oturdu. Onlara bir konuşma yapmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Halk ise, “Bu bir insanın sesi değil, bir tanrının sesi!” diye bağırıp durdu. ");
INSERT INTO turobt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tam o anda Rabbin bir meleği Hirodesʼi çarptı. Çünkü o Allahʼı yücelteceğine kendini yüceltti. Bağırsak kurtları içini yedi ve böylece can verdi. ");
INSERT INTO turobt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Allahʼın sözü ise yayılıyordu ve iman edenlerin sayısı günden güne artıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba ve Saul hizmetlerini bitirip Yeruşalimʼden Antakyaʼya döndüler. Yanlarına Markos lakabıyla bilinen Yuhannaʼyı da aldılar. ");
INSERT INTO turobt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antakyaʼdaki imanlılar topluluğunda peygamberler ve öğretmenler vardı. Adları Barnaba, Niger lakabıyla bilinen Şimon, Kirene şehrinden Lukiyus, bölge kralı Hirodesʼle birlikte büyümüş olan Menahem ve Saulʼdu. ");
INSERT INTO turobt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Onlar oruç tutup Rabbe ibadet ederken Kutsal Ruh şöyle dedi: “Barnabaʼyla Saulʼu özel bir hizmete çağırdım. Onları bana ayırın.” ");
INSERT INTO turobt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Oruç tutup dua ettikten sonra Barnabaʼyla Saulʼa elleriyle dokunarak kutsadılar. Sonra onları yolcu ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Böylece Kutsal Ruhʼun emriyle yola çıkan Barnabaʼyla Saul Selefkiye limanına gittiler, oradan da gemiyle Kıbrısʼa geçtiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamis şehrine varınca Yahudilerin toplantı yerlerinde Allahʼın sözünü duyurmaya başladılar. Yuhanna Markos onların yardımcısıydı. ");
INSERT INTO turobt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bütün adayı boydan boya geçip Baf şehrine geldiler. Orada Baryeşu adında Yahudi bir büyücüyle karşılaştılar. O aynı zamanda sahte bir peygamberdi. ");
INSERT INTO turobt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Baryeşu, adanın valisi Sergiyus Pavlusʼa devamlı eşlik ediyordu. Vali akıllı biriydi. Barnabaʼyla Saulʼu çağırtıp Allahʼın sözünü işitmek istedi. ");
INSERT INTO turobt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Baryeşu büyücü anlamına gelen Elimas adıyla tanınıyordu. O Barnabaʼyla Saulʼa karşı koydu ve valinin imana gelmesine engel olmaya çalıştı. ");
INSERT INTO turobt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Fakat Pavlus olarak da bilinen Saul Kutsal Ruhʼla dolup gözlerini Elimasʼa dikti ");
INSERT INTO turobt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ve şöyle dedi: “Seni İblis oğlu, doğru olan her şeyin düşmanı! Yüreğin her türlü yalan ve dolandırıcılıkla dolu. Rabbin doğru yolunu çarpıtmaktan vazgeçmeyecek misin? ");
INSERT INTO turobt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","İşte şimdi, Rab elini kaldırıp cezanı verecek. Kör olacaksın, bir süre güneşi göremeyeceksin!” O anda Elimasʼın üzerine sis ve karanlık çöktü. Sağa sola dönerek elinden tutup yol gösterecek birini aradı. ");
INSERT INTO turobt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Vali bu olanları görünce, Rab hakkında öğretilenlere hayran kaldı ve iman etti. ");
INSERT INTO turobt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pavlus ve arkadaşları Bafʼtan denize açılıp Pamfilya bölgesindeki Perge şehrine gittiler. Orada Yuhanna Markos onlardan ayrılıp Yeruşalimʼe döndü. ");
INSERT INTO turobt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Diğerleri Pergeʼden devam edip Pisidya sınırındaki Antakya şehrine vardılar. Şabat gününde Yahudilerin toplantı yerine girip oturdular. ");
INSERT INTO turobt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tevratʼtan ve peygamberlerin kitaplarından okunduktan sonra toplantı yerinin liderleri onları çağırtıp şöyle dediler: “Kardeşler, halkımıza bir teşvik sözünüz varsa söyleyin.” ");
INSERT INTO turobt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pavlus ayağa kalktı. Eliyle işaret ederek şöyle konuştu: “Ey İsrail soyu ve Allahʼtan korkan diğer milletler! Beni dinleyin! ");
INSERT INTO turobt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bu İsrail halkının ibadet ettiği Allah atalarımızı seçmişti. Mısırʼda gurbette yaşarlarken Allah onları büyük bir halk yaptı. Sonra onları kolunun gücüyle Mısırʼdan çıkardı. ");
INSERT INTO turobt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Yaklaşık kırk yıl boyunca ıssız yerlerde onlara katlandı. ");
INSERT INTO turobt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kenan topraklarında yedi milleti yok etti ve topraklarını miras olarak halkımıza dağıttı. ");
INSERT INTO turobt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bütün bunlar yaklaşık dört yüz elli yıl sürdü. Bundan sonra onlara hâkimler verdi. Bu da peygamber Samuelʼin zamanına kadar sürdü. ");
INSERT INTO turobt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuelʼden bir kral seçmesini istediler. Allah da onlara Benyamin oymağından Kişʼin oğlu Saulʼu kral yaptı. Kırk yıl böyle geçti. ");
INSERT INTO turobt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Allah Saulʼun krallığına son verdi ve kral olarak Davudʼu başa geçirdi. Davud için şahitlik ederek şöyle dedi: ‘Ben İşayʼın oğlu Davudʼu buldum. O, gönlüme uygun bir adamdır ve bütün istediğimi yerine getirecek.’ ");
INSERT INTO turobt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Allah, verdiği vaadi yerine getirerek bu adamın soyundan İsrail halkına bir Kurtarıcı gönderdi. Bu Kurtarıcı İsaʼdır. ");
INSERT INTO turobt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","İsaʼnın ortaya çıkmasından önce Yahya bütün İsrail halkını tövbe edip vaftiz olmaya çağırdı. ");
INSERT INTO turobt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yahya, görevini tamamlarken hep şöyle diyordu: ‘Sizce ben kimim? Ben Mesih değilim! Ama bakın, O benden sonra geliyor. Oʼnun ayaklarındaki sandaletlerini çözmeye layık değilim.’ ");
INSERT INTO turobt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kardeşler, bu kurtuluş haberi, İbrahimʼin soyundan gelenlere ve aranızda Allahʼtan korkan diğerlerine, yani hepimize gönderildi. ");
INSERT INTO turobt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yeruşalimʼde oturanlar ve onların liderleri İsaʼnın kim olduğunu fark etmediler ve Oʼnu yargıladılar. Böylece her Şabat günü okunan peygamberlerin sözlerini yerine getirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aslında Oʼnu ölüm cezasına çarptırmak için hiçbir sebep bulamadılar, ama yine de Oʼnun öldürülmesini Pilatusʼtan istediler. ");
INSERT INTO turobt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kutsal Yazılarʼda Oʼnun hakkında yazılanların hepsini yerine getirdikten sonra Oʼnu çarmıhtan indirip mezara koydular. ");
INSERT INTO turobt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Allah Oʼnu ölümden diriltti. ");
INSERT INTO turobt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","İsa kendisiyle birlikte Celile bölgesinden Yeruşalimʼe gelmiş olanlara günlerce göründü. Onlar da şimdi İsa için halka şahitlik ediyorlar. ");
INSERT INTO turobt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Biz de size şu müjdeyi getiriyoruz: Allah atalarımıza verdiği vaadi onların torunları olan bizler için yerine getirdi. Bunu İsaʼyı ortaya çıkarmakla yaptı. İkinci Mezmurʼda da yazıldığı gibi: ‘Sen benim oğlumsun, bugün ben sana baba oldum.’ ");
INSERT INTO turobt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allah İsaʼyı ölümden diriltti, bedeninin çürümesine hiçbir zaman izin vermeyecek. Allah bu konuda şunları söyledi: ‘Davudʼa söz verdiğim kutsal ve kalıcı bereketleri size vereceğim.’ ");
INSERT INTO turobt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Bu sebeple başka bir Mezmurʼda şöyle diyor: ‘Sen sadık hizmetkârının mezarda çürümesine izin vermeyeceksin.’ ");
INSERT INTO turobt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davud kendi zamanında Allahʼın amacına hizmet ettikten sonra hayata gözlerini kapadı. Atalarının yanına gömüldü ve bedeni mezarda çürüdü. ");
INSERT INTO turobt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Fakat İsa mezarda çürümedi. Allah Oʼnu ölümden diriltti. ");
INSERT INTO turobt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Böylece kardeşler, şunu bilin ki, İsa sayesinde günahların bağışlandığı size bildiriliyor. Musaʼya verilen Tevrat, sizi günahlarınızdan kurtaramaz. ");
INSERT INTO turobt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Fakat İsaʼya iman eden herkes, Oʼnun aracılığıyla kurtulur. ");
INSERT INTO turobt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bu sebeple dikkat edin, peygamberlerin söyledikleri başınıza gelmesin: ");
INSERT INTO turobt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Bakın, siz alay edenler, şaşkına dönün ve ortadan kaybolun! Çünkü sizin günlerinizde ben bir iş yapıyorum. Öyle bir iş ki, onu birisi size anlatsa bile, hiçbir zaman inanmayacaksınız.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pavlusʼla Barnaba dışarı çıkarken, oradakiler bir sonraki Şabat gününde aynı konularda vaaz etmelerini onlardan rica ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Toplantı yerindeki toplantı dağıldıktan sonra Yahudilerin ve Yahudi inancını kabul eden dindar yabancıların birçoğu Pavlusʼla Barnabaʼya katıldı. Pavlusʼla Barnaba bu insanlarla konuşup onları hep Allahʼın lütfuna güvenmeye teşvik ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ertesi Şabat günü hemen hemen bütün şehir Rabbin sözünü duymak için toplandı. ");
INSERT INTO turobt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Fakat Yahudi liderler kalabalığı görünce kıskançlıkla doldular. Pavlusʼun söylediklerine karşı çıkıp ona hakaret etmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pavlus ve Barnaba ise cesaretle karşılık verdiler: “Allahʼın sözünün önce size bildirilmesi lazımdı. Madem siz onu reddediyorsunuz ve kendinizi sonsuz yaşama layık görmüyorsunuz, biz diğer milletlere dönüyoruz. ");
INSERT INTO turobt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Çünkü Rab bize şöyle buyurdu: ‘Seni milletlere ışık yaptım. Dünyanın en uzak yerine kadar kurtuluş götüreceksin.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yahudi olmayanlar bunu işitince sevinip Rabbin sözünü yüceltmeye başladılar. Sonsuz yaşama kavuşmak için seçilenlerin hepsi iman etti. ");
INSERT INTO turobt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Rabbin sözü bütün o bölgede yayıldı. ");
INSERT INTO turobt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Fakat Yahudi liderler, dindar olan saygın kadınları ve şehrin ileri gelen erkeklerini ayağa kaldırdılar. Pavlusʼla Barnabaʼya eziyet etmeye kışkırttılar ve onları memleketlerinden kovdular. ");
INSERT INTO turobt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pavlusʼla Barnaba ise onlara uyarı olsun diye, ayaklarının tozunu silktiler. Sonra Konyaʼya gittiler. ");
INSERT INTO turobt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","İsaʼnın Pisidya Antakyasıʼndaki öğrencileri sevinç ve Kutsal Ruhʼla dolup taşıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Konyaʼda ise Pavlus ve Barnaba her zamanki gibi Yahudilerin toplantı yerine girdiler. Öyle konuştular ki, hem Yahudilerden hem de Greklerden birçok kişi iman etti. ");
INSERT INTO turobt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama iman etmek istemeyen Yahudiler, Yahudi olmayan kişilerin düşüncelerini zehirlediler ve onları imanlılara karşı gelmeye kışkırttılar. ");
INSERT INTO turobt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pavlusʼla Barnaba uzun bir zaman orada kaldılar. Rab hakkında cesaretle konuştular. Rab, onlara mucizeler ve harikalar yapma gücünü verdi. Böylece lütfu hakkında verdikleri vaazları doğruladı. ");
INSERT INTO turobt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ancak şehir halkı ikiye bölündü: kimisi Yahudilerin, kimisi de elçilerin tarafını tuttu. ");
INSERT INTO turobt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yahudilerle Yahudi olmayanlardan bazıları, liderlerinin desteğiyle elçileri dövmek ve taşlamak için plan yaptılar. ");
INSERT INTO turobt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Fakat Pavlusʼla Barnaba bundan haber alınca kaçtılar. Likaonya bölgesinin Listra ve Derbe şehirlerine ve etraf köylere gittiler. ");
INSERT INTO turobt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Oralarda da Müjdeʼyi yaymaya devam ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra şehrinde ayakları tutmayan bir adam vardı. Doğuştan sakattı, hiç yürüyemiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pavlusʼun konuşmasını dinledi. Pavlus ona dikkatle baktı ve adamın şifa bulmak için imanı olduğunu gördü. ");
INSERT INTO turobt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","O zaman yüksek sesle şöyle dedi: “Ayağa kalk, dik dur!” Adam ayağa fırladı ve yürümeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kalabalıklar Pavlusʼun yaptığını görünce, seslerini yükseltip Likaonya dilinde şöyle dediler: “Tanrılar insan kılığına girip yanımıza inmişler!” ");
INSERT INTO turobt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabaʼya Zeus adını, Pavlusʼa ise baş sözcü olduğu için Hermes adını taktılar. ");
INSERT INTO turobt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeus tapınağı şehrin dışındaydı. Tapınağın rahibi şehir kapısına çiçeklerle süslenmiş boğalar getirdi. Halkla birlikte kurban kesmek istiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Elçiler, yani Barnaba ve Pavlus, bunu duyunca elbiselerini yırtarak kalabalığa daldılar. Yüksek sesle şöyle dediler: ");
INSERT INTO turobt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Beyler, neden böyle yapıyorsunuz? Biz de sizin gibi insanız, aynı tabiata sahibiz. Size müjde getiriyoruz. Sizi bu boş şeylerden vazgeçip diri olan Allahʼa dönmeye çağırıyoruz. O, gökyüzünü, yeryüzünü, denizi ve onların içinde olan her şeyi yaratmıştır. ");
INSERT INTO turobt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Allah, geçmiş kuşaklarda bütün milletlerin kendi bildikleri yoldan gitmelerine izin verdi. ");
INSERT INTO turobt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yine de varlığına şahitlik olarak size iyilik yapıyor. Size gökten yağmur yağdırıyor, meyve dolu mevsimler veriyor. Karnınızı doyuruyor, yüreklerinizi de sevindiriyor.” ");
INSERT INTO turobt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pavlusʼla Barnaba bunları söyleyerek kalabalığın onlara kurban kesmesine zor engel oldular. ");
INSERT INTO turobt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ama Pisidya Antakyası ve Konya şehirlerinden bazı Yahudiler geldiler. Onlar halkı kendi taraflarına çekip Pavlusʼu taşladılar. Onu ölü sanıp şehirden dışarı sürüklediler. ");
INSERT INTO turobt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Fakat İsaʼnın öğrencileri Pavlusʼun etrafında toplandılar. O da ayağa kalktı ve şehre döndü. Ertesi gün Barnabaʼyla birlikte Derbe şehrine gitti. ");
INSERT INTO turobt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Orada İsaʼyı müjdelediler ve birçok kişiyi Oʼnun öğrencisi olarak yetiştirdiler. Ondan sonra Listra, Konya ve Pisidya Antakyasıʼna döndüler. ");
INSERT INTO turobt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Oralarda İsaʼnın öğrencilerini yüreklendirip güçlendirdiler. Onları imana bağlı kalmaya teşvik ettiler. “Allahʼın Krallığıʼna girmek için, birçok sıkıntıdan geçmemiz lazım” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pavlusʼla Barnaba imanlıların her topluluğunda liderler görevlendirdiler. Oruç tutup dua ettiler. Sonra liderleri iman ettikleri Rabbe emanet ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidyaʼnın içinden geçip Pamfilya bölgesine vardılar. ");
INSERT INTO turobt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge şehrinde Allahʼın sözünü vaaz ettikten sonra Antalyaʼya gittiler. ");
INSERT INTO turobt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Oradan da gemiye binip Antakyaʼya doğru gittiler. Tamamlamış oldukları görevi yapmak için Allahʼın lütfuna Antakyaʼda teslim edilmişlerdi. ");
INSERT INTO turobt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Oraya varınca imanlılar topluluğunu bir araya çağırdılar. Allahʼın onların eliyle neler yaptığını, nasıl diğer milletler için bir iman kapısı açtığını teker teker anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","İsaʼnın Antakyaʼdaki öğrencileriyle uzun uzun vakit geçirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yahudiye bölgesinden bazı kişiler Antakyaʼya gelip oradaki imanlılara şunu öğretmeye başladılar: “Musaʼya verilen Tevratʼa göre sünnet olmazsanız, kurtulamazsınız.” ");
INSERT INTO turobt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pavlus ve Barnaba bu adamlarla çekişti. Aralarında uzun bir tartışma oldu. Sonunda Pavlusʼla Barnabaʼyı ve oradan bazı imanlıları Yeruşalimʼe gönderme kararı verildi. Onlar bu konuyu elçilere ve diğer liderlere danışacaklardı. ");
INSERT INTO turobt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Böylece imanlılar topluluğu onları yolcu ettikten sonra Fenike ve Samiriye bölgelerinden geçtiler. Oradaki imanlılara Yahudi olmayan insanların nasıl Allahʼa döndüğünü anlattılar. Bu haber bütün imanlıları fazlasıyla sevindirdi. ");
INSERT INTO turobt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pavlus, Barnaba ve yanlarındaki imanlılar Yeruşalimʼe vardılar. Oradaki imanlılar topluluğu, elçiler ve liderler tarafından hoş karşılandılar. Allahʼın onların eliyle yapmış olduğu her şeyi anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fakat Ferisi partisinden imana gelmiş bazı kişiler kalkıp şöyle dediler: “Yahudi olmayan imanlıları sünnet etmeliyiz. Musaʼya verilen Tevratʼa uymalarını emretmeliyiz.” ");
INSERT INTO turobt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bunun üzerine elçiler ve liderler bu sorunu görüşmek için bir araya geldiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Uzun bir tartışmadan sonra Petrus ayağa kalkıp onlara şöyle dedi: “Kardeşler, biliyorsunuz, Allah uzun zaman önce aranızdan beni seçti. Diğer milletlerin Müjdeʼyi benim ağzımdan duyarak ve imana gelmelerini istiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","İnsanın yüreğini bilen Allah, Kutsal Ruhʼu bize verdiği gibi, onlara da verdi. Böylece onları kabul ettiğini gösterdi. ");
INSERT INTO turobt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Onların yüreklerini imanla temizledi. Bizimle onların arasında hiç ayrım yapmadı. ");
INSERT INTO turobt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tevratʼın buyrukları ağır bir yüktür. Öyleyse neden şimdi imanlıların üstüne bu yükü koymakla Allahʼın sabrını deniyorsunuz? Bu yükü ne biz taşıyabildik ne de atalarımız taşıyabildiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Hayır! Biz Rab İsaʼnın lütfuyla kurtulduğumuza inanıyoruz. Yahudi olmayanlar da aynen böyle kurtulur.” ");
INSERT INTO turobt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bunun üzerine bütün topluluk sustu ve Barnabaʼyla Pavlusʼu dinlemeye başladı. Barnabaʼyla Pavlus, Allahʼın onların elleriyle milletlerin arasında ne gibi mucizeler ve harikalar yaptığını anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Onlar konuşmalarını bitirince, Yakub söz alıp şöyle dedi: “Kardeşler, beni dinleyin! ");
INSERT INTO turobt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simun bize Allahʼın ilk defa diğer milletlerle nasıl ilgilenip, onlardan kendisine ait bir halk çıkardığını açıkladı. ");
INSERT INTO turobt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Peygamberlerin sözleri de bunu doğruluyor. Aynı yazıldığı gibi: ");
INSERT INTO turobt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Rab diyor ki, bundan sonra geri döneceğim, Davudʼun yıkık evini yeniden kuracağım. Evet, onun yıkıntılarını yeniden inşa edeceğim. Onu tekrar ayağa kaldıracağım. ");
INSERT INTO turobt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","O zaman geriye kalan insanlar, halkım olmaya çağırdığım bütün milletler, bana sığınacaklar.’ Rab bu şeyleri ezelden beri bildirmiştir. ");
INSERT INTO turobt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Bu sebeple, bence Allahʼa dönen yabancılara güçlük çıkarmayalım. ");
INSERT INTO turobt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ancak onlara bir mektup yazalım ve şu buyruğu verelim: putların önünde kesilmiş ve bu sebeple temiz olmayan kurban etlerinden, evlilik dışındaki seksüel ilişkilerden, boğularak öldürülen hayvanların etinden ve kanı süzülmemiş etten uzak durun. ");
INSERT INTO turobt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bildiğiniz gibi Musaʼya verilen Tevrat eski zamanlardan beri her şehirde vaaz ediliyor, her Şabat günü toplantı yerlerinde okunuyor.” ");
INSERT INTO turobt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Bunun üzerine elçiler ve diğer liderler bütün imanlılar topluluğuyla birlikte aralarından bazı adamlar seçtiler. Onları Pavlus ve Barnabaʼyla birlikte Antakya şehrine göndermeyi uygun gördüler. Barsabba adıyla bilinen Yahudaʼyı ve Silasʼı seçtiler. Bunlar imanlıların arasında liderlerdi. ");
INSERT INTO turobt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Onların eliyle şu mektubu gönderdiler: “Kardeşleriniz olan biz elçiler ve diğer liderlerden selam! Antakya şehrinde ve Suriyeʼyle Kilikya bölgelerinde bulunan sizlere, yani Yahudi olmayan imanlı kardeşlerimize selam ederiz. ");
INSERT INTO turobt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Duyduğumuza göre aramızdan çıkan bazı kişiler sizi sözleriyle rahatsız etmiş, kafalarınızı karıştırmışlar. Onları biz göndermedik. ");
INSERT INTO turobt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Bu nedenle aramızdan bazı adamları seçtik. Onları sevgili kardeşlerimiz Barnaba ve Pavlusʼla birlikte size göndermeye karar verdik. ");
INSERT INTO turobt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bu adamlar Rabbimiz İsa Mesihʼin adı için hayatlarını tehlikeye attılar. ");
INSERT INTO turobt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Böylece Yahuda ve Silasʼı gönderiyoruz. Onlar da aynı şeyleri sözlü olarak anlatacaklar. ");
INSERT INTO turobt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Evet, Kutsal Ruh ve biz, şu zorunlu kuralların dışında, üzerinize daha fazla yük koymamayı uygun gördük: ");
INSERT INTO turobt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Putların önünde kesilen kurban etlerinden, kanı süzülmemiş etten, boğularak öldürülen hayvanların etinden ve evlilik dışındaki seksüel ilişkilerden uzak durmalısınız. Bunlardan sakınırsanız, iyi edersiniz. Hoşça kalın!” ");
INSERT INTO turobt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Böylece Barnaba, Pavlus, Yahuda ve Silas yolcu edildi. Antakyaʼya varınca, topluluğu bir araya getirip mektubu teslim ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","İmanlılar mektubu okuyunca, içindeki cesaret verici sözlere sevindiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kendileri peygamber olan Yahuda ve Silas birçok vaaz verdiler. İmanlıları yüreklendirip güçlendirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Bir süre orada kaldılar. Sonra imanlılar, onları gönderen kişilere geri dönmek üzere esenlik dileğiyle yolcu ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pavlusʼla Barnaba ise Antakyaʼda kaldılar ve birçok kişiyle birlikte vaaz edip Rabbin sözünü müjdelediler. ");
INSERT INTO turobt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bir süre sonra Pavlus Barnabaʼya şöyle dedi: “Haydi Rabbin sözünü vaaz ettiğimiz bütün o kasabalara dönüp imanlı kardeşlerimizi ziyaret edelim. Hallerini görelim.” ");
INSERT INTO turobt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba, Markos diye bilinen Yuhannaʼyı yanlarına almak istiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Fakat Pavlus bunu uygun görmedi. Onu yanlarına almak istemedi. Çünkü Markos onları daha önce Pamfilyaʼda terk etmiş ve göreve onlarla birlikte devam etmemişti. ");
INSERT INTO turobt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aralarında öyle keskin bir anlaşmazlık çıktı ki, birbirlerinden ayrıldılar. Barnaba Markosʼu yanına alıp gemiyle Kıbrısʼa gitti. ");
INSERT INTO turobt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pavlus ise Silasʼı seçti ve imanlılar tarafından Rabbin lütfuna emanet edildikten sonra yola çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Suriye ve Kilikya bölgelerinden geçerek oradaki imanlılar topluluklarını güçlendirdi. ");
INSERT INTO turobt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Sonra Pavlus Derbe ve Listra şehirlerine geldi. Listraʼda İsaʼnın Timoteos adında bir öğrencisi vardı. Annesi İsaʼya iman etmiş bir Yahudi, babası ise Grekti. ");
INSERT INTO turobt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra ve Konyaʼdaki imanlılar Timoteos hakkında iyi şeyler söylüyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pavlus Timoteosʼu yolculukta yanına almak istedi. O bölgedeki Yahudiler yüzünden Timoteosʼu sünnet ettirdi. Çünkü babasının Grek olduğunu hepsi biliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pavlus, Silas ve Timoteos şehir kasaba dolaştılar. Yeruşalimʼdeki elçilerle diğer liderlerin aldığı kararları imanlılara bildirdiler. Bunlara uymalarını istediler. ");
INSERT INTO turobt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Böylece toplulukların imanı kuvvetlendi, imanlılar her gün sayıca çoğaldılar. ");
INSERT INTO turobt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pavlus, Silas ve Timoteos Frigya ve Galatya sınırlarındaki bölgeden geçtiler, çünkü Kutsal Ruh Ege bölgesinde vaaz etmelerini engellemişti. ");
INSERT INTO turobt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misya bölgesine varınca Bitinya bölgesine geçmek istediler, ama İsaʼnın Ruhʼu onlara izin vermedi. ");
INSERT INTO turobt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misyaʼdan geçip Troas şehrine gittiler. ");
INSERT INTO turobt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","O gece Pavlus olağanüstü bir görüntü gördü. Karşısında Makedonyalı bir adam durmuş ona şöyle yalvarıyordu: “Makedonyaʼya gel ve bize yardım et!” ");
INSERT INTO turobt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pavlusʼun gördüğü bu görüntüden sonra hemen oradan ayrılıp Makedonyaʼya gitmenin bir yolunu aradık. Çünkü Allahʼın bizi oradakilere Müjdeʼyi duyurmaya çağırdığını anladık. ");
INSERT INTO turobt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troasʼtan denize açılıp doğrudan Semadirek adasına gittik. Ertesi gün Neapolis şehrine devam ettik. ");
INSERT INTO turobt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Oradan da Filipiʼye geçtik. Filipi, Romalıların kurduğu bir yerleşme yeri ve Makedonya bölgesinin birinci kısmında bulunan bir şehirdir. Orada birkaç gün kaldık. ");
INSERT INTO turobt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Şabat günü şehir kapısından çıkıp ırmak kenarına gittik. Orada bir dua yeri olacağını düşündük. Oturduk ve toplanmış olan kadınlarla konuşmaya başladık. ");
INSERT INTO turobt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bizi dinleyenler arasında Tiyatira şehrinden Lidya adında bir kadın vardı. Mor renkli kumaş ticareti yapardı. Allahʼa tapınan biriydi. Pavlusʼun söylediklerine önem vermesi için Rab Lidyaʼnın yüreğini açtı. ");
INSERT INTO turobt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kendisi ve bütün ev halkı vaftiz oldu. Sonra bizi evine davet etti: “Eğer siz beni Rabbe iman etmiş biri sayarsanız, evime gelip bende kalın” dedi. Böylece bizi razı etti. ");
INSERT INTO turobt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bir gün, biz dua yerine giderken, bir köle kızla karşılaştık. Kızın içinde falcılık ruhu vardı. Gelecekten haber vererek sahiplerine çok para kazandırıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pavlusʼla bizim arkamıza takıldı ve şöyle bağırıp durdu: “Bu adamlar yüce Allahʼın kullarıdır. Size kurtuluş yolunu bildiriyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Günlerce böyle devam etti. Pavlus bundan öyle rahatsız oldu ki, dönüp kızdaki ruha şöyle dedi: “İsa Mesihʼin adıyla sana emrediyorum, bu kızın içinden çık!” Ruh da anında kızdan çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kızın sahipleri para kazanma umutlarının yok olduğunu gördüler. Pavlusʼla Silasʼı yakalayıp meydana, şehir yöneticilerinin önüne sürüklediler. ");
INSERT INTO turobt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Onları hâkimlerin yanına götürüp şöyle dediler: “Bu adamlar şehrimizi karıştırıyorlar. Onlar Yahudi. ");
INSERT INTO turobt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Biz Romalıların kabul etmesi ve uygulaması yasak olan adetler yayıyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kalabalık da Pavlusʼla Silasʼa yapılan saldırıya katıldı. Hâkimler onların elbiselerinin yırtılıp çıkartılması ve sopalarla dövülmeleri için buyruk verdiler. ");
INSERT INTO turobt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Onları iyice dövdükten sonra, hapishaneye attılar. Hapishane müdürüne de, onları sıkı güvenlik altına alması için buyruk verdiler. ");
INSERT INTO turobt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Böyle bir buyruğu alan müdür, onları hapishanenin en içerdeki kısmına attı ve ayaklarını tomruğa vurdu. ");
INSERT INTO turobt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gece yarısına yakın bir vakitte Pavlus ve Silas dua ediyor, ilahilerle Allahʼı övüyorlardı. Öbür tutuklular da onları dinliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Aniden öyle büyük bir deprem oldu ki, hapishanenin temelleri sarsıldı. Birdenbire bütün kapılar açıldı ve herkesin zincirleri çözüldü. ");
INSERT INTO turobt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Hapishane müdürü uykusundan kalktı, hapishanenin kapılarını açık gördü ve bütün tutukluların kaçmış olduğunu sandı. Bu sebeple kılıcını çekip kendini öldürecekti. ");
INSERT INTO turobt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Fakat Pavlus yüksek sesle şöyle dedi: “Sakın kendine zarar verme, çünkü hepimiz buradayız!” ");
INSERT INTO turobt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Müdür lamba getirtti, içeri koştu ve korkudan titreyerek Pavlusʼla Silasʼın önünde yere kapandı. ");
INSERT INTO turobt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Onları dışarı çıkarttı. “Efendiler, kurtulmak için ne yapmam lazım?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Onlar, “Rab İsaʼya iman et, hem sen, hem de ev halkın kurtulacaksınız” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ondan sonra müdüre ve onun evindekilere Rabbin sözünü anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Müdür de onları gecenin o saatinde su bulunan bir yere götürüp yaralarını yıkadı. Hemen sonra kendisi ve evindeki herkes vaftiz oldu. ");
INSERT INTO turobt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Müdür Pavlusʼla Silasʼı yukarı çıkarıp kendi evine götürdü ve önlerinde sofra kurdu. Evindeki herkesle birlikte sevinçle doldu. Çünkü Allahʼa iman etmişti. ");
INSERT INTO turobt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sabah olunca, hâkimler silahlı görevlileri gönderip, “O adamları serbest bırakın” diye emrettiler. ");
INSERT INTO turobt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hapishane müdürü bu sözleri Pavlusʼa bildirdi. “Hâkimler sizi serbest bırakmak için haber yolladılar. Bunun için şimdi dışarı çıkıp esenlikle gidin” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Fakat Pavlus görevlilere şöyle dedi: “Biz Roma vatandaşlarıyız! Hiç dava açmadan bizi herkesin önünde dövüp hapishaneye attılar. Şimdi bizi gizlice mi kovacaklar? Olmaz öyle şey! Hayır, kendileri gelip bizi çıkarsınlar!” ");
INSERT INTO turobt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Görevliler bu sözleri hâkimlere bildirdiler. Hâkimler de Pavlusʼla Silasʼın Roma vatandaşı olduğunu duyunca korktular. ");
INSERT INTO turobt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Gelip özür dilediler. Onları serbest bıraktıktan sonra şehirden ayrılmalarını rica ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hapisten çıkan Pavlusʼla Silas Lidyaʼnın evine gittiler. İmanlılarla görüşüp onları yüreklendirdikten sonra oradan ayrıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pavlusʼla yanındakiler Amfipolis ve Apollonya şehirlerinden geçip Selanik şehrine gittiler. Orada Yahudilerin bir toplantı yeri vardı. ");
INSERT INTO turobt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavlus, kendi adetine göre, onların toplantılarına katıldı. Arka arkaya üç Şabat günü onlarla Kutsal Yazılar üzerinde tartıştı. ");
INSERT INTO turobt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pavlus yazıları açıkladı, Mesihʼin acı çekmesi ve ölümden dirilmesi gerektiğini kanıtlarla anlattı. Onlara şöyle dedi: “Size sözünü ettiğim bu İsa, Mesihʼin kendisidir.” ");
INSERT INTO turobt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yahudilerden bazıları ve Allahʼa tapınan bir sürü Grek ikna olup iman ettiler ve Pavlusʼla Silasʼa katıldılar. Aralarında birçok önemli kadın da vardı. ");
INSERT INTO turobt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yahudi liderler ise kıskançlığa kapıldılar. Çarşıda boş gezen serserileri topladılar ve kalabalık halinde şehirde kargaşa başlattılar. Yasonʼun evini bastılar. Pavlusʼla Silasʼı arıyorlardı. Onları halkın önüne çıkarıp yargılamak istiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Fakat onları bulamayınca, Yasonʼu ve bazı imanlıları şehir yöneticilerinin önüne sürükleyip şöyle bağırdılar: “Dünyayı altüst eden bu adamlar buraya da geldiler. ");
INSERT INTO turobt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason onları misafir etti. Onların hepsi imparatorun buyruklarına karşı koyuyor. İsa adında başka bir kral var, diyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bu sözleri işiten kalabalık ve şehir yöneticileri telaşa kapıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Şehir yöneticileri Yason ve diğerlerinden yeterli para aldıktan sonra, onları serbest bıraktılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","İmanlılar da hiç beklemeden Pavlusʼla Silasʼı geceleyin Veriya şehrine gönderdiler. Pavlusʼla Silas oraya varınca, Yahudilerin toplantı yerine gittiler. ");
INSERT INTO turobt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Veriyaʼdaki Yahudiler Selanikʼtekilerden daha açık fikirliydi. Allahʼın sözünü büyük hevesle kabul ettiler. Anlatılanların doğru olup olmadığını anlamak için her gün Kutsal Yazılarʼı araştırıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sonuç olarak birçok Yahudi ile bir sürü saygın Grek kadın ve erkek imana geldi. ");
INSERT INTO turobt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Fakat Selanikli Yahudi liderler Pavlusʼun Veriyaʼda da Allahʼın sözünü yaydığını öğrenince oraya gittiler. Halkı ayağa kaldırıp kargaşa çıkardılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bu yüzden imanlılar hemen Pavlusʼu deniz kenarına gönderdiler. Silasʼla Timoteos ise Veriyaʼda kaldılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pavlusʼa eşlik edenler onu Atinaʼya kadar götürdüler. Pavlusʼtan, “Silasʼla Timoteos bir an önce yanıma gelsinler” diye buyruk aldıktan sonra yanından ayrıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pavlus Silasʼla Timoteosʼu Atinaʼda bekliyordu. Şehrin her tarafında putlar olduğunu görünce ruhu acıyla doldu. ");
INSERT INTO turobt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Bu sebeple toplantı yerinde Yahudiler ve Allahʼa tapınan Greklerle konuştu. Her gün çarşı meydanında karşılaştığı insanlarla da konuştu. ");
INSERT INTO turobt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ayrıca Epikürcü ve Stoacı olarak bilinen bazı filozoflar onunla tartışmaya başladılar. Onlardan kimileri, “Bu boşboğaz ne demek istiyor?” diye soruyordu. Diğerleriyse, “Galiba yabancı tanrıların propagandasını yapıyor” diyorlardı. Çünkü Pavlus, İsaʼyı ve Dirilişʼi müjdeliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pavlusʼu alıp Arestepeʼde toplanan Atina meclisine götürdüler. Ona şöyle dediler: “Vaaz ettiğin bu yeni inancın ne olduğunu öğrenebilir miyiz? ");
INSERT INTO turobt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kulağımıza garip gelen şeyler söylüyorsun. Bu şeylerin anlamını öğrenmek istiyoruz.” ");
INSERT INTO turobt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bütün Atinalılar ve orada bulunan yabancılar vakitlerini hep yeni fikirler anlatıp dinlemekle geçiriyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavlus da Arestepe Meclisiʼnin ortasında durup şöyle dedi: “Ey Atinalılar! Her konuda çok dindar olduğunuzu gördüm. ");
INSERT INTO turobt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Çünkü gezinirken ve tapınma yerlerinizi incelerken üzerinde ‘Bilinmeyen tanrıya ait’ diye yazılmış bir kurban yerine bile rastladım. Siz bilmediğiniz bir tanrıya tapıyorsunuz. Bilmeden taptığınız bu Tanrıʼyı size anlatayım. ");
INSERT INTO turobt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dünyayı ve onun içindeki her şeyi yaratan Allahʼtır. O, yerin ve göğün Efendisi olduğu için elle yapılmış tapınaklarda oturmaz. ");
INSERT INTO turobt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Oʼnun bir şeye ihtiyacı varmış gibi insan eliyle Oʼna yardım edilmez. Çünkü herkese hayat, soluk ve her şeyi veren Oʼdur. ");
INSERT INTO turobt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Allah Tek insandan bütün milletleri yarattı. Onları yeryüzünün dört bucağına yerleştirdi. Onların tarihlerine ve yaşayacakları yerlerin sınırlarına önceden karar verdi. ");
INSERT INTO turobt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Allah bunu, insanlar Oʼnu elleriyle yoklarmış gibi arayıp bulsunlar diye yaptı. O aslında hiçbirimizden uzak değildir. ");
INSERT INTO turobt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Çünkü biz Oʼnda yaşıyoruz ve hareket ediyoruz. Var olmamız Oʼndandır.’ Aranızdan bazı şairlerin de dediği gibi, ‘Biz de Oʼnun soyundanız.’ ");
INSERT INTO turobt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Madem Allahʼın soyundanız, şunu anlamalıyız: Allahʼın özü altın, gümüş ya da taştan bir şeye benzemez, insan ustalığı ve hayal gücüyle şekil verilen bir şey değildir. ");
INSERT INTO turobt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Allah, cahillik zamanlarını görmemezlikten geldi. Ama şimdi her yerde herkesin tövbe etmesini emrediyor. ");
INSERT INTO turobt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Çünkü Allah bir gün seçti ve o gün görevlendirdiği adam aracılığıyla dünyadaki bütün insanları adaletle yargılayacak. Oʼnu ölümden dirilterek bunu herkese kanıtladı.” ");
INSERT INTO turobt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ölülerin dirilme konusunu duyunca, bazıları alay etmeye başladılar. Başkalarıysa, “Bu konuda seni tekrar dinleyeceğiz” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Böylece Pavlus onların arasından ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ama bazı adamlar ona katılarak iman ettiler. Onların arasında meclis üyesi Dionisiyos, Damaris adında bir kadın ve birkaç kişi daha vardı. ");
INSERT INTO turobt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ondan sonra Pavlus Atinaʼdan ayrılıp Korint şehrine gitti. ");
INSERT INTO turobt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Orada Akvila adında Pontus doğumlu bir Yahudiye rastladı. Akvila kısa bir zaman önce karısı Priskilaʼyla İtalyaʼdan Korintʼe gelmişti. Çünkü İmparator Klavdiyus bütün Yahudilerin Romaʼyı terk etmelerini emretmişti. Pavlus onları görmeye gitti. ");
INSERT INTO turobt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Çadırcılık yapıyorlardı. Pavlus onlarla meslektaş olduğu için, onların yanında kaldı ve birlikte çalıştılar. ");
INSERT INTO turobt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Üstelik Pavlus her Şabat günü Yahudilerin toplantı yerindetartışarak hem Yahudileri hem de Grekleri imana getirmeye çalışıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sonra Silas ve Timoteos Makedonyaʼdan geldiler. O zaman Pavlus kendini tamamen Allahʼın sözünü yaymaya verdi. Yahudilere şahitlik ederek İsaʼnın Mesih olduğunu bildirdi. ");
INSERT INTO turobt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Fakat Yahudiler Pavlusʼa karşı gelip hakaret ettiler. Bu yüzden Pavlus elbiselerini silkip onlara şöyle dedi: “Başınıza gelecek belalardan siz sorumlusunuz! Sorumluluk benden gitti! Artık öbür milletlere gideceğim.” ");
INSERT INTO turobt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pavlus oradan ayrılıp Titiyus Yustus adında bir adamın evine gitti. O, Allahʼa tapınan bir Grekti. Evi Yahudilerin toplantı yeriyle yan yanaydı. ");
INSERT INTO turobt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Toplantı yerinin lideri olan Krispus bütün ev halkıyla birlikte Rabbe inandı. Pavlusʼu dinleyen birçok Korintli de iman edip vaftiz oldu. ");
INSERT INTO turobt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Rab Pavlusʼa geceleyin olağanüstü bir görüntüde görünüp şöyle dedi: “Korkma, konuşmaya devam et, susma! ");
INSERT INTO turobt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Çünkü ben seninleyim, hiç kimse sana elini kaldırıp zarar vermeyecek, çünkü bu şehirde çok halkım var.” ");
INSERT INTO turobt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pavlus orada bir yıl altı ay kaldı ve onların arasında Allahʼın sözünü vaaz etmeye devam etti. ");
INSERT INTO turobt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galliyo Ahaya valisi olduğu sıralarda Yahudiler birleşip Pavlusʼa saldırdılar. Onu dava yerine çıkardılar. ");
INSERT INTO turobt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Şöyle dediler: “Bu adam insanları kanuna ters düşen biçimde Allahʼa ibadet etmeye kandırıyor.” ");
INSERT INTO turobt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pavlus tam konuşmaya başlayacağı zaman Galliyo Yahudilere şöyle dedi: “Ey Yahudiler, eğer davanız haksızlık ya da ağır suç olsaydı, sizi dinlemem akla uygun olurdu. ");
INSERT INTO turobt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Fakat bu tartışmalar sadece sözler, adlar ve kendi kanunlarınız hakkındadır. O yüzden bu işe kendiniz bakın. Böyle davaları yargılamaya benim hiç niyetim yok.” ");
INSERT INTO turobt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ondan sonra onları dava yerinden kovdu. ");
INSERT INTO turobt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bütün halk, Yahudilerin toplantı yerinin lideri olan Sostenesʼi yakalayıp dava yerinin önünde dövmeye başladı. Fakat Galliyo bu olaylara hiç aldırmadı. ");
INSERT INTO turobt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pavlus Korintʼte bir süre daha kaldı. Sonra oradaki imanlı kardeşlerle vedalaşıp Suriyeʼye gitmek için gemiye bindi. Priskila ve Akvila da onun yanındaydı. Denize açılmadan önce Pavlus Kenhere limanında saçını kestirdi. Çünkü Allahʼa verdiği sözü tutuyordu. ");
INSERT INTO turobt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sonra Efesʼe vardılar. Pavlus, Priskila ve Akvilaʼyı orada bıraktı. Kendisi ise, Yahudilerin toplantı yerine gidip Yahudilerle konuştu. ");
INSERT INTO turobt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Onlar Pavlusʼun daha uzun bir süre kalmasını rica ettiler, ama o razı gelmedi. ");
INSERT INTO turobt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Onlarla vedalaşıp şöyle dedi: “Allah isterse size tekrar döneceğim.” Sonra Efesʼten denize açıldı. ");
INSERT INTO turobt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sezariye limanına vardı, oradan da Yeruşalimʼe gitti. Oradaki imanlılar topluluğunu ziyaret etti. Ondan sonra Antakyaʼya geçti. ");
INSERT INTO turobt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Orada biraz vakit geçirdikten sonra ayrıldı. Galatya ve Frigya topraklarını dolaştı ve oralardaki bütün imanlıları güçlendirdi. ");
INSERT INTO turobt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","O sıralarda İskenderiye şehrinden Apollos adında bir Yahudi Efesʼe geldi. Kendisi eğitim görmüş bir konuşmacıydı ve Kutsal Yazılarʼı çok iyi biliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bu adam Rabbin yolu hakkında bilgi almıştı. Coşkun bir ruhla konuşuyor ve İsaʼyla ilgili doğru bilgiler veriyordu. Fakat yalnız Yahyaʼnın vaftizini biliyordu. ");
INSERT INTO turobt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apollos Yahudilerin toplantı yerinde cesaretle konuşmaya başladı. Ama Priskila ve Akvila konuşmasını dinleyince, onu bir kenara çekip Allahʼın yolunu ona daha doğru biçimde açıkladılar. ");
INSERT INTO turobt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ondan sonra Apollos, Ahaya bölgesine geçmek istedi. Efesʼteki imanlılar onu oraya gitmeye teşvik ettiler. Onu kabul etsinler diye Ahaya bölgesindeki imanlılara bir de mektup yazdılar. Apollos oraya varınca, Allahʼın lütfuyla imana gelmiş olanlara çok yardımcı oldu. ");
INSERT INTO turobt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yahudilerin İsaʼya karşı söylediklerini herkesin önünde güçlü bir şekilde yalanladı. Çünkü Kutsal Yazıları İsaʼnın Mesih olduğunu kanıtlamak için kullandı. ");
INSERT INTO turobt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos Korintʼteyken, Pavlus İç Anadoluʼdan geçip Efesʼe geldi. Orada bazı imanlıları buldu. ");
INSERT INTO turobt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Onlara şunu sordu: “İman ettiğiniz zaman Kutsal Ruhʼu aldınız mı?” Onlar da Pavlusʼa şöyle cevap verdiler: “Hayır, almadık. Kutsal Ruhʼun varlığından bile haberimiz yok.” ");
INSERT INTO turobt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","O zaman Pavlus onlara, “Madem öyle, siz hangi vaftizi aldınız?” diye sordu. Onlarsa “Yahyaʼnın vaftizini” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pavlus da, “Yahyaʼnın yaptığı vaftiz tövbe edenler içindi” dedi. “Yahya, halka kendisinden sonra gelecek Olanʼa, yani İsaʼya, iman etmelerini söyledi.” ");
INSERT INTO turobt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Onlar bunu işitince, Rab İsaʼnın adıylavaftiz oldular. ");
INSERT INTO turobt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pavlus da onların üzerine ellerini koydu. O zaman Kutsal Ruh onların üzerine geldi, ve başka diller konuşmaya ve peygamberlik etmeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Onlar aşağı yukarı on iki kişiydiler. ");
INSERT INTO turobt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pavlus Yahudilerin toplantı yerine gitti ve üç ay boyunca cesaretle vaaz etti. Oradakilerle tartışarak onları Allahʼın Krallığı konusunda inandırmaya çalıştı. ");
INSERT INTO turobt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama bazıları inat etti. İman etmek istemediler. Dua evindekilerin önünde İsaʼnın yolunu kötülemeye başladılar. O zaman Pavlus onlardan ayrıldı. Öğrencilerini beraberinde götürdü ve her gün Tiranusʼun dershanesinde tartışmalarını sürdürdü. ");
INSERT INTO turobt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bu böyle iki yıl devam etti. Neticede Yahudi olsun Grek olsun, Ege bölgesinde oturanların hepsi Rabbin sözünü duydular. ");
INSERT INTO turobt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Allah Pavlusʼun eliyle olağanüstü mucizeler yapıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Öyle ki, onun bedenine değmiş mendilleri ve önlükleri hastalara götürdüler. Hastalar şifa buldu, şeytani ruhlar da insanlardan kovuldu. ");
INSERT INTO turobt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Fakat yer yer gezip cin kovan bazı Yahudiler vardı. Onlar şeytani ruhlara esir olanları kurtarmak için Rab İsaʼnın adını kullanmaya kalktılar. Şeytani ruhlara şöyle diyorlardı: “Pavlusʼun vaaz ettiği İsaʼnın adıyla size emrediyorum!” ");
INSERT INTO turobt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Skeva adında bir Yahudi başrahibin yedi oğlu da bunu yapıyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bir seferinde şeytani ruh onlara şöyle cevap verdi: “İsaʼyı biliyorum, Pavlusʼtan da haberim var. Ama siz kimsiniz?” ");
INSERT INTO turobt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sonra içinde şeytani ruh bulunan adam onların üstüne atladı. Hepsini dövüp perişan etti. Öyle ki, adamın evinden çıplak ve yaralı kaçtılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efes şehrinde yaşayan Yahudi, Grek herkesin bu olaydan haberi oldu. Hepsini bir korku sardı ve Rab İsaʼnın adı büyük bir saygınlık kazandı. ");
INSERT INTO turobt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","İman etmiş olanların birçoğu öne çıktı. Yapmış oldukları kötülükleri anlattılar, açığa çıkardılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Büyücülükle uğraşmış birçok kişi de büyü kitaplarını toplayıp herkesin gözü önünde yaktı. Yakılan kitapların elli bin gümüş değerinde olduğunu hesapladılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Böylece Rabbin sözü kuvvetle yayıldı, daha da etkili oldu. ");
INSERT INTO turobt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bütün bu şeylerden sonra, Pavlus Makedonya ve Ahaya bölgelerinden geçip Yeruşalimʼe gitmeye karar verdi. “Oraya gittikten sonra Romaʼyı da görmem lazım” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pavlus kendisine yardım edenlerden ikisini, Timoteos ve Erastusʼu Makedonyaʼya yolladı. Kendisi ise Ege bölgesinde bir süre daha kaldı. ");
INSERT INTO turobt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","O arada İsaʼnın yolu hakkında büyük bir karışıklık çıktı. ");
INSERT INTO turobt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetriyos adında gümüş ustası bir adam vardı. Artemis tapınağının gümüşten maketlerini yaparak bu işle uğraşanlara çok kârlı bir iş sağlıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriyos onları ve benzer işlerle uğraşanları toplayıp şöyle dedi: “Beyler! Biliyorsunuz, kazancımız bu işe bağlıdır. ");
INSERT INTO turobt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Fakat şu Pavlusʼun ne yaptığını görüyorsunuz ve duyuyorsunuz. Yalnız Efesʼte değil, ama neredeyse bütün Ege bölgesinde birçok kişiyi kandırıp yoldan saptırdı. Onlara, elle yapılan tanrılar gerçek tanrı değildir, diyor. ");
INSERT INTO turobt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tehlikeli durumdayız. Hem sanatımızın saygınlığı elden gidecek, hem de büyük tanrıçamız Artemisʼin tapınağı hiçe sayılacak. Üstelik tüm Ege bölgesinin ve dünyanın tapındığı Artemis yüceliğini kaybedecek.” ");
INSERT INTO turobt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bunu duyunca öfkeyle doldular. “Efeslilerin Artemisi büyüktür!” diye bağırmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Şehir tamamen karıştı. Halk Pavlusʼun Makedonyalı yol arkadaşları olan Gayus ve Aristarhusʼu yakaladı. Onları sürükleyerek çabucak tiyatroya götürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pavlus halkın önüne çıkmak istedi. Fakat imanlılar ona engel oldular. ");
INSERT INTO turobt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ege yöneticilerinden bazıları Pavlusʼun arkadaşlarıydı. Onlar da Pavlusʼa haber yollayıp tiyatroya ayak basmaması için yalvardılar. ");
INSERT INTO turobt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tiyatroda her kafadan başka bir ses çıkıyordu. Toplantı karmakarışıktı. Çoğunluk neden bir araya geldiklerini bile bilmiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yahudiler İskenderʼi öne çıkardılar. Kalabalıktan bazıları olayı ona bağladı. İskender eliyle işaret yaptı ve halkın önünde savunmasını yapmak istedi. ");
INSERT INTO turobt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama onun Yahudi olduğunu anlayınca, hemen hemen iki saat boyunca hepsi bir ağızdan “Efeslilerin Artemisi büyüktür!” diye bağırdı. ");
INSERT INTO turobt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Şehir başkanı gelip kalabalığı susturdu ve sonra şöyle konuştu: “Efesliler! Efes şehri büyük Artemisʼin tapınağının ve gökten düşen taşın kollayıcısıdır. Bunu bilmeyen var mı? ");
INSERT INTO turobt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kimse bu şeyleri inkâr edemez. Onun için sakin olmanız lazım. Akılsız bir şey yapmayın. ");
INSERT INTO turobt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Buraya getirdiğiniz bu adamlar ne tapınakları soydular, ne de tanrıçamıza hakaret ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Onun için eğer Demetriyos ve meslektaşlarının herhangi bir kişiden şikâyeti varsa, dava yerleri açık, yargıçlar da var. Orada birbirlerine dava açsınlar. ");
INSERT INTO turobt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bundan başka bir isteğiniz varsa, yasal toplantıda halledilsin. ");
INSERT INTO turobt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Çünkü bugünkü olaylardan dolayı ayaklanma suçundan yargılanma tehlikesindeyiz. Bu kargaşanın haklı bir sebebi yok, onun hesabını veremeyiz.” ");
INSERT INTO turobt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bunu söyledikten sonra toplantıyı dağıttı. ");
INSERT INTO turobt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Karışıklık bitince, Pavlus imanlıları çağırttı. Onlara cesaret verdikten sonra vedalaştı ve Makedonyaʼya gitmek için ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O tarafları gezip birçok konuşmalarla oradaki imanlıları cesaretlendirdi. Sonra Ahaya bölgesine gitti. ");
INSERT INTO turobt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Orada üç ay kaldı. Suriyeʼye deniz yoluyla gidecekti, ama Yahudiler onu gemide öldürmek için plan yaptılar. Bu sebeple Pavlus Makedonya üzerinden dönmeye karar verdi. ");
INSERT INTO turobt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Piros oğlu Veriyalı Sopater, Selanikli Aristarhus ve Sekundus, Derbe şehrinden olan Gayus, Timoteos ve Ege bölgesinden Tihikos ile Trofimos Pavlusʼa eşlik ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Onlar önden gidip bizi Troas şehrinde beklediler. ");
INSERT INTO turobt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Biz ise Mayasız Ekmek Bayramıʼndan sonra Filipiʼden denize açıldık ve beş gün sonra Troasʼa şehrine varıp onlara katıldık. Orada yedi gün kaldık. ");
INSERT INTO turobt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Haftanın birinci günüekmek bölmek için bir araya geldik. Pavlus imanlılara bir konuşma yaptı. Ertesi gün oradan ayrılacağı için konuşmasını gece yarısına kadar sürdürdü. ");
INSERT INTO turobt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Üst katta bir odada toplanmıştık ve orada birçok lamba yanıyordu. ");
INSERT INTO turobt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Eftihos adında bir genç pencerede oturmuş uyukluyordu. Pavlus konuşmasını uzatınca, Eftihos derin bir uykuya dalıp üçüncü kattan aşağı düştü. Ölüsünü yerden kaldırdılar. ");
INSERT INTO turobt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavlus da aşağı indi. Eftihosʼun üzerine kapanıp onu kucakladı. “Olay yaratmayın, o yaşıyor” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pavlus tekrar yukarı çıktı, imanlılarla ekmek böldü ve yedi. Güneş doğuncaya kadar onlarla uzun uzun konuştu. Sonra oradan ayrıldı. ");
INSERT INTO turobt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bu arada imanlılar çocuğu canlı olarak eve götürdüler ve olup bitenlerden büyük cesaret aldılar. ");
INSERT INTO turobt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Biz ise, Pavlusʼun önünden gidip gemiye bindik ve Assos şehrine doğru denize açıldık. Niyetimiz Pavlusʼu oradan gemiye almaktı. Pavlus Assos şehrine yürüyerek gideceği için bunu önceden ayarlamıştı. ");
INSERT INTO turobt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assosʼta o bizimle buluştu, biz de onu gemiye aldık ve Midilli şehrine geçtik. ");
INSERT INTO turobt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ertesi gün oradan deniz yolculuğumuza devam edip Sakız adasının karşısına vardık. Üçüncü gün Sisam adasına uğradık ve bir sonraki gün Milet şehrine vardık. ");
INSERT INTO turobt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pavlus Efesʼe uğramadan yola devam etmeye karar vermişti. Çünkü Ege bölgesinde vakit geçirmek istemiyordu. Mümkünse, Pentikost Bayramıʼnda Yeruşalimʼde olabilmek için acele ediyordu. ");
INSERT INTO turobt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pavlus Miletʼten Efesʼe haber yolladı, imanlılar topluluğunun liderlerini yanına çağırttı. ");
INSERT INTO turobt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Geldiklerinde onlara şöyle dedi: “Ege bölgesine ayak bastığım ilk günden beri, yanınızda olduğum süre boyunca nasıl davrandığımı siz kendiniz biliyorsunuz. ");
INSERT INTO turobt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tam bir alçakgönüllülük ve gözyaşlarıyla Rabbe hizmet ettim. Yahudilerin kurdukları düzenler yüzünden sıkıntılar çektim. ");
INSERT INTO turobt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Biliyorsunuz ki, faydalı olan ne varsa size hiç çekinmeden bildirdim ve halka açık toplantılarda ve evden eve gezerek size vaaz ettim. ");
INSERT INTO turobt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Hem Yahudilere hem de Greklere şahitlik ettim. Tövbe edip Allahʼa dönmelerini ve Rabbimiz İsaʼya iman etmelerini söyledim. ");
INSERT INTO turobt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Şimdi de Kutsal Ruhʼa bağlı olduğum için Yeruşalimʼe gidiyorum. Orada başıma neler geleceğini bilmiyorum. ");
INSERT INTO turobt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bir tek şunu biliyorum: Kutsal Ruh beni her şehirde uyarıyor, beni hapis ve sıkıntıların beklediğini söylüyor. ");
INSERT INTO turobt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama canıma hiç değer ve önem vermiyorum. Yeter ki, amacıma ulaşayım ve Rab İsaʼdan aldığım görevi tamamlayayım. Bu görev, Allahʼın lütfunu bildiren Müjdeʼye şahitlik etmektir. ");
INSERT INTO turobt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ben aranızda dolaşıp Allahʼın Krallığıʼnı sizlere duyurmuştum. Şimdi biliyorum ki, hiçbiriniz yüzümü bir daha görmeyecek. ");
INSERT INTO turobt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Bu sebeple kimsenin uğrayacağı cezadan sorumlu olmadığıma bugün şahitlik ederim. ");
INSERT INTO turobt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Çünkü Allahʼın planını size tam olarak bildirmekten hiç çekinmedim. ");
INSERT INTO turobt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sürüsünü bekleyen bir çoban gibi kendinize ve Rabbin topluluğuna göz kulak olun. Rab bu topluluğa kendi kanı pahasına sahip oldu. Kutsal Ruh sizi bu topluluğun gözetmenleri olarak görevlendirdi. ");
INSERT INTO turobt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Biliyorum ki, ben gittikten sonra bazıları sürüye zarar veren yırtıcı kurtlar gibi aranıza girecekler. ");
INSERT INTO turobt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Aranızdan bile sapık şeyler söyleyen adamlar ortaya çıkacak. İmanlıları kendi peşlerinden sürüklemeye çalışacaklar. ");
INSERT INTO turobt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bunun için tetikte olun! Hatırlayın ki, ben üç yıl boyunca gece gündüz durmadan her birinizi gözyaşlarıyla uyarmıştım. ");
INSERT INTO turobt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Şimdi de sizi Allahʼa ve Oʼnun lütfunu bildiren söze emanet ediyorum. Bu söz kudretlidir. İmanınızı güçlendirecek ve size Allahʼa adanmış olan herkesin arasında bir miras verecek. ");
INSERT INTO turobt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Hiç kimsenin gümüşünde, altınında ya da elbisesinde gözüm kalmadı. ");
INSERT INTO turobt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kendiniz biliyorsunuz ki, bu ellerimle çalışarak hem kendi ihtiyaçlarımı, hem de benimle birlikte olanların ihtiyaçlarını karşıladım. ");
INSERT INTO turobt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yaptığım her şeyle size örnek oldum. Çalışıp güçsüzlere yardım etmemiz gerektiğini gösterdim. Rab İsaʼnın sözlerini hatırlayın. O kendisi dedi ki, ‘Vermek, almaktan daha büyük mutluluktur.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pavlus bunları söyledikten sonra diz çöküp hepsi ile birlikte dua etti. ");
INSERT INTO turobt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sonra hepsi hüngür hüngür ağlayarak Pavlusʼun boynuna sarıldı ve onu öptü. ");
INSERT INTO turobt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","En çok üzüldükleri şey, “Yüzümü bir daha görmeyeceksiniz” demesi oldu. Sonra onu gemiye kadar geçirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Onlardan istemeyerek ayrıldık. Sonra gemiyle denize açıldık ve doğru İstanköy adasına gittik. Ertesi gün Rodos adasına, oradan da Patara şehrine devam ettik. ");
INSERT INTO turobt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fenikeʼye gidecek bir gemi bulduk. Ona binip denize açıldık. ");
INSERT INTO turobt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kıbrıs adasını görünce onu sol tarafımızda bırakıp Suriyeʼye giden yöne devam ettik. Sur limanında karaya çıktık, çünkü gemide çalışanlar yükü orada indireceklerdi. ");
INSERT INTO turobt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","İmanlıları arayıp bulunca onlarla yedi gün kaldık. Onlar Kutsal Ruhʼtan aldıkları bilgiye dayanarak Pavlusʼa “Yeruşalimʼe gitme!” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Fakat oradaki günlerimiz sona erince, ayrılıp yola çıktık. İmanlıların hepsi, eşleri ve çocuklarıyla birlikte bizi şehrin dışına kadar geçirdiler. Deniz kenarında diz çöküp dua ettik. ");
INSERT INTO turobt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Birbirimizle vedalaştıktan sonra biz gemiye bindik, onlarsa evlerine döndüler. ");
INSERT INTO turobt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sur şehrinden yolculuğumuza devam ederek Batlamya şehrine vardık. Oradaki imanlıları ziyaret edip yanlarında bir gün kaldık. ");
INSERT INTO turobt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ertesi gün ayrılıp Sezariye şehrine vardık. Müjdeci Filipusʼun evine gidip onun yanında kaldık. Filipus yardım dağıtan yedi görevliden biriydi. ");
INSERT INTO turobt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Bu adamın peygamberlik eden dört bakire kızı vardı. ");
INSERT INTO turobt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Birkaç gün orada kaldık. O vakit Yahudiyeʼden Hagabos adında bir peygamber geldi. ");
INSERT INTO turobt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yanımıza gelip, Pavlusʼun kuşağını aldı, ve onunla kendi ellerini ve ayaklarını bağlayıp şunları söyledi: “Kutsal Ruh şöyle diyor: ‘Yeruşalimʼdeki Yahudiler bu kuşağın sahibini böyle bağlayacak ve yabancıların eline teslim edecekler.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bunu işitince hem biz, hem de oradaki imanlılar Yeruşalimʼe gitmemesi için Pavlusʼa yalvarmaya başladık. ");
INSERT INTO turobt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bunun üzerine Pavlus şöyle karşılık verdi: “Neden böyle ağlayıp yüreğimi parçalıyorsunuz? Rab İsaʼnın adı uğruna Yeruşalimʼde sadece bağlanmaya değil, ölmeye de hazırım.” ");
INSERT INTO turobt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Biz Pavlusʼun fikrini değiştiremeyince, “Rabbin istediği olsun” deyip sustuk. ");
INSERT INTO turobt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Birkaç gün sonra hazırlık yapıp Yeruşalimʼe doğru yola çıktık. ");
INSERT INTO turobt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sezariye şehrinden bazı imanlılar da bizimle geldiler. Bizi misafir olacağımız Kıbrıslı Minasonʼun evine götürdüler. Minason, İsaʼya ilk iman edenlerden biriydi. ");
INSERT INTO turobt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yeruşalimʼe vardığımızda imanlılar bizi sevinçle karşıladılar. ");
INSERT INTO turobt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ertesi gün Pavlus bizimle birlikte Yakubʼun yanına gitti. Bütün liderler oradaydılar. ");
INSERT INTO turobt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pavlus, onlarla selamlaştıktan sonra kendi hizmetinin aracılığıyla Allahʼın diğer milletler arasında yaptıklarını birer birer anlattı. ");
INSERT INTO turobt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bunu işitince, Allahʼı yücelttiler. Sonra Pavlusʼa şöyle dediler: “Kardeş, görüyorsun, Yahudilerin arasında imana gelmiş binlerce kişi var. Hepsi de Tevratʼın uygulanması için can atıyorlar. ");
INSERT INTO turobt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ama duyduklarına göre sen diğer milletlerin arasında yaşayan bütün Yahudilere Musaʼya sırt çevirmeyi öğretiyorsun. Onlara ‘Çocuklarınızı sünnet etmeyin, adetlerimize uymayın!’ diyorsun. ");
INSERT INTO turobt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Peki, ne yapmalı? Senin buraya geldiğini mutlaka işitecekler. ");
INSERT INTO turobt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bu yüzden sana diyeceğimizi yap. Aramızda kendilerini yeminle Allahʼa adamış dört adam var. ");
INSERT INTO turobt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Onları yanına al ve onlarla birlikte paklanma adetini yerine getir. Onların kurban masraflarını öde ki saçlarını tıraş ettirebilsinler. O zaman herkes, senin hakkındaki söylentilerin asılsız olduğunu anlar. Bilirler ki, Tevratʼa uygun yaşıyorsun. ");
INSERT INTO turobt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yahudi olmayan imanlılara gelince, onlara kararımızı anlatan bir mektup yolladık: putların önünde kesilen kurbanların etinden, kanı süzülmemiş etten, boğularak öldürülen hayvanların etinden ve evlilik dışı seksüel ilişkilerden uzak durun dedik.” ");
INSERT INTO turobt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bunun üzerine Pavlus o dört adamı yanına aldı. Ertesi gün onlarla birlikte paklanma adetini yerine getirdi. Tapınağa gidip paklanma günlerinin ne zaman biteceğini ve her biri için ne zaman kurban kesileceğini bildirdi. ");
INSERT INTO turobt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Yedi günlük paklanma süresi bitmek üzereydi. Ege bölgesinden gelen Yahudiler Pavlusʼu tapınak avlusunda gördüler. Bütün kalabalığı ayağa kaldırdılar ve Pavlusʼu yakaladılar. ");
INSERT INTO turobt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Şöyle bağırdılar: “Ey İsrailoğulları, yardım edin! Her yerde herkese halkımızı, Tevratʼı ve bu yeri kötülemeyi öğreten adam budur. Üstelik tapınak avlusuna Grekleri sokarak bu kutsal yeri kirletti.” ");
INSERT INTO turobt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ege bölgesinden gelen Yahudiler böyle konuştular, çünkü daha önce Efesli Trofimosʼu şehirde Pavlusʼun yanında görmüşlerdi ve Pavlusʼun Trofimosʼu tapınağa götürdüğünü sandılar. ");
INSERT INTO turobt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Bütün şehir ayaklandı, insanlar her taraftan koşuşup geldiler. Pavlusʼu yakalayıp tapınak avlusundan dışarıya sürüklediler. Hemen arkalarından avlu kapıları kapatıldı. ");
INSERT INTO turobt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kalabalık Pavlusʼu öldürmek istiyordu. O sırada Romalı ordu komutanına bütün Yeruşalim karıştı diye haber geldi. ");
INSERT INTO turobt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Komutan hemen yanına birkaç asker ve yüzbaşı alıp koşa koşa kalabalığın olduğu yere indi. Onlar da komutanı ve askerleri görünce, Pavlusʼu dövmekten vazgeçtiler. ");
INSERT INTO turobt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ondan sonra komutan yaklaşıp Pavlusʼu yakaladı ve iki zincirle bağlanması için emir verdi. Onun kim olduğunu ve ne yaptığını öğrenmeye çalıştı. ");
INSERT INTO turobt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ama kalabalıkta her kafadan bir ses çıkıyordu. Komutan kargaşa yüzünden gerçeği öğrenemeyince, Pavlusʼun kaleye götürülmesini emretti. ");
INSERT INTO turobt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Merdivenlere kadar geldiler. Halk o kadar kudurmuştu ki, askerler Pavlusʼu omuzlarında taşımak zorunda kaldılar. ");
INSERT INTO turobt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","“Onu yok edin!” diye bağıran kalabalık peşlerini bırakmadı. ");
INSERT INTO turobt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pavlus kalenin içine götürülürken komutana, “Sana bir şey söyleyebilir miyim?” dedi. Komutan, “Grekçe biliyor musun?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Demek ki sen bir süre önce ayaklanma başlatan ve dört bin teröristi alıp ıssız yerlere götüren şu Mısırlısın, öyle değil mi?” ");
INSERT INTO turobt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pavlus ona şöyle dedi: “Ben Kilikya bölgesinden Tarsuslu bir Yahudiʼyim. Önemli bir şehrin vatandaşıyım. Sana yalvarıyorum, bana izin ver de, halkla konuşayım.” ");
INSERT INTO turobt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Komutan izin verince, Pavlus merdivenin üzerinde durup eliyle halka işaret etti. Etrafa derin bir sessizlik çöktükten sonra Aramice konuşmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Kardeşler ve babalar, şimdi kendimi savunmak için söyleyeceklerimi dinleyin.” ");
INSERT INTO turobt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pavlusʼun onlarla Aramice konuştuğunu işitince daha da sakinleştiler. Pavlus şöyle devam etti: ");
INSERT INTO turobt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ben bir Yahudiyim. Kilikya bölgesinin Tarsus şehrinde doğdum. Ama Yeruşalimʼde büyüdüm. Gamaliyelʼin öğrencisiydim. Atalarımıza verilen Tevrat üzerine sıkı bir eğitim gördüm. Hepinizin bugün yaptığı gibi ben de Allahʼa canla başla hizmet eden biriydim. ");
INSERT INTO turobt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","İsaʼnın yolundan gidenlere eziyet ettim. Bazılarının öldürülmesine sebep oldum. Kadın erkek demeden onları bağlayıp hapishaneye attım. ");
INSERT INTO turobt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Başrahip ve bütün Meclis üyeleri söylediklerime şahitlik edebilir. Onlardan Şamʼdaki Yahudi din kardeşlerimize yazılmış mektuplar alıp yola çıktım. Orada İsaʼyı izleyenleri yakalayıp cezalandırmak için Yeruşalimʼe getirecektim. ");
INSERT INTO turobt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Fakat Şam yolunda bana bir şey oldu. Öğleye doğru oraya yaklaşırken birdenbire gökten şimşek gibi parlak bir ışık etrafımı aydınlattı. ");
INSERT INTO turobt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Yere düştüm ve bir sesin bana, ‘Saul, Saul, niçin bana eziyet ediyorsun?’ dediğini işittim. ");
INSERT INTO turobt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ben de ‘Kimsin, Efendim?’ diye sordum. O da bana, ‘Ben senin eziyet ettiğin Nasıralı İsaʼyım’ dedi. ");
INSERT INTO turobt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yanımdakiler o ışığı gördüler, ama benimle konuşan kişinin dediklerini anlamadılar. ");
INSERT INTO turobt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","‘Ne yapayım, ya Rab?’ dedim. Rab bana şöyle dedi: ‘Ayağa kalk, Şamʼa git. Orada yapman için planlanan her şey sana anlatılacak.’ ");
INSERT INTO turobt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Işık o kadar görkemliydi ki, gözlerim görmez olmuştu. Bu yüzden yanımda olanlar elimden tutup beni Şamʼa götürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Orada Hananya adında Tevratʼa bağlı, Allahʼa adanmış bir adam vardı. Şamʼda yaşayan bütün Yahudiler ondan övgüyle söz ediyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","O bana geldi. Yanımda durup, ‘Saul kardeş, gözlerin görsün’ dedi. Tam o anda gözlerim açıldı ve onu gördüm. ");
INSERT INTO turobt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Hananya sözlerine şöyle devam etti: ‘Atalarımızın Allahı seni seçti. Oʼnun isteğini bilmen, Doğru Olanʼı görmen ve ağzından çıkan sözleri işitmen için seni görevlendirdi. ");
INSERT INTO turobt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Çünkü Oʼnun şahidi olacaksın, görüp işittiklerini bütün insanlara duyuracaksın. ");
INSERT INTO turobt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Haydi, ne bekliyorsun? Kalk, İsa adını anarak vaftiz ol ve günahlarından temizlen.’ ");
INSERT INTO turobt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ben Yeruşalimʼe döndükten sonra tapınak avlusunda dua ediyordum. O sırada olağanüstü bir hale daldım. ");
INSERT INTO turobt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","İsaʼyı gördüm. O bana şöyle dedi: ‘Çabuk ol! Hemen Yeruşalimʼden kaç! Çünkü benim hakkımda yaptığın şahitliği kabul etmeyecekler.’ ");
INSERT INTO turobt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ben de şöyle cevap verdim: ‘Ya Rab, onların kendileri de biliyor ki, ben toplantı yerlerini dolaşıp sana iman edenleri hapishaneye atıyordum ve dövüyordum. ");
INSERT INTO turobt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Üstelik senin şahidin olan İstefanosʼun kanı dökülürken ben de orada durup bunu yapanları alkışlıyordum. Onu öldürenlerin kaftanlarına bekçilik ediyordum.’ ");
INSERT INTO turobt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Rab ise bana ‘Buradan git!’ dedi. ‘Seni uzakta olan milletlere göndereceğim.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Halk Pavlusʼu bu noktaya kadar dinledi. Sonra seslerini yükseltip, “Bu adamı yeryüzünden temizleyin! Böyle birinin yaşamaya hakkı yok!” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bağırmaya devam ettiler. Kaftanlarını çıkarıp havaya toz attılar. ");
INSERT INTO turobt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Bunun üzerine komutan, Pavlusʼun kalenin içine götürülmesini emretti. Halkın niçin ona karşı o kadar bağırdığını öğrenmek istedi. Bu sebeple Pavlusʼun kamçılanarak sorguya çekilmesi için buyruk verdi. ");
INSERT INTO turobt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Onu kayışlarla germeye başladılar. O zaman Pavlus yanında duran yüzbaşıya şunu sordu: “Kendisine dava açmadan bir Roma vatandaşını kamçılamak yasal mıdır?” ");
INSERT INTO turobt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yüzbaşı bunu işitince, komutana gidip şöyle dedi: “Ne yapıyorsun? Bu adam Roma vatandaşıymış!” ");
INSERT INTO turobt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Komutan da gelip Pavlusʼa, “Söyle bakayım, sen Roma vatandaşı mısın?” diye sordu. Pavlus, “Evet” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Komutan karşılık olarak, “Ben bu vatandaşlığı elde etmek için çok para ödedim” dedi. Ama Pavlus ona, “Ben ise vatandaş olarak doğdum” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bunun üzerine onu sorguya çekmeye hazırlanan adamlar hemen onun yanından ayrıldılar. Komutan da Pavlusʼun Roma vatandaşı olduğunu öğrenince korktu, çünkü kendisi onu bağlatmıştı. ");
INSERT INTO turobt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Komutan Yahudilerin Pavlusʼu neyle suçladıklarını tam olarak öğrenmek istiyordu. Bu sebeple Pavlusʼu ertesi gün hapisten çıkarttı ve başrahiplerle bütün Meclisʼin toplanmasını emretti. Sonra Pavlusʼu kaleden aşağıya indirip onların önüne götürdü. ");
INSERT INTO turobt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pavlus Meclisʼin adamlarına gözlerini dikip şöyle dedi: “Kardeşler! Ben bugüne kadar Allahʼın gözünde tertemiz bir vicdanla yaşadım.” ");
INSERT INTO turobt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Başrahip Hananya da kendisinin yanında duranlara Pavlusʼun ağzına şamar atmalarını emretti. ");
INSERT INTO turobt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","O vakit Pavlus ona, “Allah da sana vuracak” dedi. “Seni ikiyüzlü! Kireçlenmiş duvara benziyorsun. Sen hem beni Tevrat kanunlarına göre yargılamak için oturuyorsun, hem de kanunlara karşı gelip bana şamar attırıyorsun.” ");
INSERT INTO turobt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","O vakit etrafta duranlar “Sen Allahʼın seçtiği başrahibe hakaret ediyorsun!” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pavlus şöyle cevap verdi: “Kardeşler, onun başrahip olduğunu bilmiyordum. Çünkü Tevratʼta şöyle yazılmıştır: ‘Halkınızın liderleri hakkında kötü konuşmayın.’ ” ");
INSERT INTO turobt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pavlus Meclisʼin bir kısmının Saduki, geri kalanlarınsa, Ferisi din partisinden olduğunu fark etti. O vakit Meclisʼin ortasında yüksek sesle şöyle dedi: “Kardeşler, ben özbeöz Ferisiʼyim. Ölülerin dirileceğine umut ettiğim için yargılanıyorum!” ");
INSERT INTO turobt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pavlus bunu söyleyince Ferisilerle Sadukiler arasında tartışma çıktı. Böylece toplanan kişiler ikiye bölündü. ");
INSERT INTO turobt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Çünkü Sadukiler diriliş, melek ve ruh yok derler. Fakat Ferisiler bunların hepsini kabul ederler. ");
INSERT INTO turobt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Böylece büyük bir kargaşa çıktı. Ferisi partisinden bazı Tevrat uzmanları ayağa fırlayıp tartışmaya başladılar. “Bu adamda hiçbir suç görmüyoruz” dediler. “Bir ruh ya da bir melek onunla konuşmuşsa, ne olmuş yani?” ");
INSERT INTO turobt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Çekişme o kadar kızıştı ki, komutan Pavlusʼu parçalayacaklar diye korktu. Askerlerine aşağı inip Pavlusʼu onların arasından zorla alıp kaleye götürmelerini emretti. ");
INSERT INTO turobt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","O gece Rab Pavlusʼa görünüp, “Cesur ol!” dedi. “Bana Yeruşalimʼde şahitlik ettiğin gibi Romaʼda da şahitlik etmen lazım.” ");
INSERT INTO turobt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Sabah olunca bazı Yahudiler bir plan kurdular. “Pavlusʼu öldürünceye kadar bir şey yiyip içersek bize lanet olsun!” diye yemin ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bu anlaşmaya kırktan fazla kişi katıldı. ");
INSERT INTO turobt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Onlar başrahipler ve liderlerin yanına gidip şöyle dediler: “Pavlusʼu öldürünceye kadar ağzımıza bir şey koyarsak bize lanet olsun diye yemin ettik. ");
INSERT INTO turobt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Şimdi siz Meclisʼle birlikte komutana haber verin. Pavlusʼu getirmesini rica edin. Sanki Pavlusʼun davasını daha yakından araştıracakmış gibi yapın. Biz ise Pavlus daha buraya varmadan onu öldürmeye hazırız.” ");
INSERT INTO turobt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ne var ki, Pavlusʼun kız kardeşinin oğlu onların pusu kurduğunu öğrendi. Gidip kaleye girdi ve Pavlusʼa haber verdi. ");
INSERT INTO turobt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavlus da yüzbaşılardan birini yanına çağırıp şöyle dedi: “Bu delikanlıyı komutanın yanına götür. Ona söyleyeceği bir şey var.” ");
INSERT INTO turobt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yüzbaşı delikanlıyı alıp komutana götürdü ve şöyle dedi: “Tutuklu Pavlus beni yanına çağırdı ve bu delikanlıyı sana getirmemi rica etti. Sana bir diyeceği varmış.” ");
INSERT INTO turobt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Komutan delikanlıyı elinden tutup bir kenara çekti. “Bana söyleyeceğin nedir?” diye sordu. ");
INSERT INTO turobt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Delikanlı şöyle dedi: “Yahudi liderleri anlaştı. Yarın Pavlusʼu Meclisʼin önüne getirmeni rica edecekler. Onun davasını daha yakından araştırmak istediklerini söyleyecekler. ");
INSERT INTO turobt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama sen onlara kanma! Çünkü aralarından kırktan fazla kişi ona karşı pusuya yatmış bekliyor. Onu öldürünceye kadar bir şey yiyip içersek bize lanet olsun diye yemin ettiler. Şimdi hepsi hazır duruyorlar, senin kararını bekliyorlar.” ");
INSERT INTO turobt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bunun üzerine komutan delikanlıyı salıverdi. Onu şöyle uyardı: “Bana bu haberi verdiğini hiç kimseye söyleme.” ");
INSERT INTO turobt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sonra komutan iki yüzbaşıyı yanına çağırıp şöyle dedi: “Bu gece saat dokuza kadar iki yüz yaya asker, yetmiş atlı ve iki yüz mızraklı asker hazırlayın. Sezariyeʼye kadar gitsinler. ");
INSERT INTO turobt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ayrıca atlar hazırlayın. Pavlusʼu birine bindirip Vali Feliksʼin yanına sağ salim götürün.” ");
INSERT INTO turobt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Komutan şöyle bir mektup yazdı: ");
INSERT INTO turobt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Klavdiyus Lisiyasʼtan, Sayın Vali Feliksʼe, selam! ");
INSERT INTO turobt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bu adam Yahudiler tarafından yakalanmıştı ve tam öldürülmek üzereydi. Fakat ben onun Roma vatandaşı olduğunu öğrendim, askerlerimle gidip onu kurtardım. ");
INSERT INTO turobt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Onu neyle suçladıklarını öğrenmek istedim. Bu sebeple onu Yahudilerin Meclisiʼne götürdüm. ");
INSERT INTO turobt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Onun Yahudi kanunlarıyla ilgili meselelerle suçlandığını öğrendim. Bu suçlama ölüm ya da hapis cezasını gerektirmiyordu. ");
INSERT INTO turobt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bu adamı öldürmek için bir düzen kurulduğu bana bildirildi. Bu sebeple onu hemen sana yolladım. Onu suçlayanlara da şikâyetlerini senin önünde yapmalarını emrettim.” ");
INSERT INTO turobt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Böylece askerler komutanın emrini yerine getirdiler. Pavlusʼu alıp geceleyin Antipatris şehrine götürdüler. ");
INSERT INTO turobt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ertesi gün atlıların Pavlusʼla yola devam etmesine izin verildi. Diğer askerler ise kaleye döndüler. ");
INSERT INTO turobt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Atlılar Sezariyeʼye varınca mektubu valiye verip Pavlusʼu ona teslim ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","35","Vali mektubu okuyunca, Pavlusʼa hangi bölgeden olduğunu sordu. Kilikya bölgesinden olduğunu öğrenince şöyle dedi: “Seni suçlayanlar geldikleri zaman davanı dinleyeceğim.” Pavlusʼun Hirodesʼin sarayında gözaltında tutulması için buyruk verdi. ");
INSERT INTO turobt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Beş gün sonra başrahip Hananya bazı liderlerle birlikte Sezariye şehrine geldi. Onların yanında Tertullus adında bir avukat da vardı. Valinin huzuruna çıkıp Pavlusʼa karşı şikâyetlerini anlattılar. ");
INSERT INTO turobt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Pavlus çağrıldıktan sonra Tertullus onu şöyle suçlamaya başladı: “Saygıdeğer Feliks! Sen bunca zaman esenlik içinde yaşamamızı sağladın. Düşünceli liderliğinle halkımıza yenilikler getirdin. Biz bunları her zaman, her yerde şükranla anarız. ");
INSERT INTO turobt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Fazla vaktini almak istemem. Onun için bize kısa bir söz hakkı lütfeder misiniz? ");
INSERT INTO turobt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Anladığımıza göre, bu adam baş belasıdır. Dünyanın her tarafındaki bütün Yahudilerin arasında kargaşa çıkarıyor ve Nasrani tarikatının elebaşıdır. ");
INSERT INTO turobt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Üstelik tapınağımızın kutsallığını bozmaya kalktı. Fakat onu yakaladık. Bu adamı kendin sorguya çekersen onu suçladığımız her şeyin doğru olduğunu göreceksin.” ");
INSERT INTO turobt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahudi liderler de söylenenleri destekleyip saldırıya katıldılar. ");
INSERT INTO turobt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Vali, konuşması için Pavlusʼa bir işaret verdi. O da suçlamaları şöyle cevapladı: “Yıllardan beri yargıç olarak bu halkın davalarına baktığını biliyorum. Onun için kendimi sevinçle savunuyorum. ");
INSERT INTO turobt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ben Allahʼa ibadet etmek için Yeruşalimʼe gideli en fazla on iki gün oldu. Sen kendin bunu öğrenebilirsin. ");
INSERT INTO turobt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Beni suçlayanlar beni tapınakta, toplantı yerlerinde, ya da şehrin başka bir yerinde tartışırken ya da halkı ayaklandırırken görmedi. ");
INSERT INTO turobt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Şu anda bana yaptıkları suçlamaları da sana kanıtlayamazlar. ");
INSERT INTO turobt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yalnız, sana şunu açıkça söylüyorum: ben onların ‘tarikat’ dedikleri Yolʼa uygun olarak atalarımızın Allahıʼna ibadet ediyorum. Tevratʼta ve peygamberlerin kitaplarında ne yazılmışsa, hepsine inanıyorum. ");
INSERT INTO turobt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ben aynı bu adamlar gibi, iyilerin de kötülerin de ölümden dirileceği konusunda Allahʼa umut bağladım. ");
INSERT INTO turobt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Buna göre her vakit hem Allahʼın, hem de insanların karşısında temiz vicdanla yaşamaya çalışıyorum. ");
INSERT INTO turobt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Yıllar geçtikten sonra, milletime yardım getirmek ve Allahʼa kurbanlar sunmak için Yeruşalimʼe geldim. ");
INSERT INTO turobt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Beni tapınağın avlusunda paklanmış durumda, kurban sunarken buldular. Etrafımda kalabalık ya da gürültü patırtı yoktu. ");
INSERT INTO turobt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama orada Ege bölgesinden bazı Yahudiler vardı. Eğer bana karşı şikâyetleri varsa, onların burada senin önüne çıkıp beni suçlamaları lazım. ");
INSERT INTO turobt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ya da buradakilere sorun. Meclisʼin önünde yargılandığım zaman bende ne suç bulduklarını açıklasınlar. ");
INSERT INTO turobt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Beni suçlayabilecekleri tek şey var: Aralarında durduğumda yüksek sesle şöyle dedim: ‘Ben bugün ölülerin dirileceğine umut ettiğim için huzurunuzda yargılanıyorum!’ ” ");
INSERT INTO turobt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks İsaʼnın yolu hakkında oldukça bilgiliydi. Davayı başka güne erteleyip şunu dedi: “Komutan Lisiyas buraya gelince davanız hakkında kararımı vereceğim.” ");
INSERT INTO turobt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pavlusʼu kollayan yüzbaşıya da onu gözaltında tutmasını emretti. “Fakat ona biraz serbestlik tanı ve ihtiyaçlarını karşılayacak arkadaşlarından hiçbirine engel olma” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Birkaç gün sonra Feliks, Yahudi olan karısı Drusilla ile birlikte geldi. Pavlusʼu çağırttı. Mesih İsaʼya iman etmek hakkındaki konuşmasını dinledi. ");
INSERT INTO turobt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pavlus doğruluk, insanın kendine hâkim olması ve dünyanın yargılanacağı gün hakkında konuştu. Feliks bunları duyunca korkmaya başladı. “Şimdilik gidebilirsin” dedi. “Vakit bulunca seni tekrar çağırtırım.” ");
INSERT INTO turobt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Aynı zamanda Pavlusʼun ona rüşvet vereceğini umut ediyordu. Bu sebeple onunla sohbet etmek için onu sık sık çağırttı. ");
INSERT INTO turobt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aradan iki yıl geçtikten sonra Feliksʼin yerine Porkiyus Festus görev aldı. Feliks de Yahudi liderlere bir iyilik yapmak isteyerek Pavlusʼu hapishanede bıraktı. ");
INSERT INTO turobt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus vali olacağı bölgeye vardıktan üç gün sonra Sezariyeʼden Yeruşalimʼe gitti. ");
INSERT INTO turobt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Başrahipler ve diğer önemli Yahudiler ona gidip Pavlusʼa karşı şikâyette bulundular. Festusʼtan bir ricaları vardı. ");
INSERT INTO turobt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Kendilerine bir iyilik yapıp Pavlusʼu Yeruşalimʼe getirtmesini istediler. Pusu kurup Pavlusʼu yolda öldüreceklerdi. ");
INSERT INTO turobt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus ise Pavlusʼun Sezariyeʼde tutulduğunu, kendisinin de yakında oraya gideceğini söyledi. ");
INSERT INTO turobt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Önemli adamlarınız benimle gelsin. Bu adam bir suç işlediyse onu orada suçlasınlar” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus sekiz on gün kadar onların arasında kaldı. Ondan sonra Sezariyeʼye döndü. Ertesi gün de dava yerinde oturup Pavlusʼun getirilmesini emretti. ");
INSERT INTO turobt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pavlus oraya varınca, Yeruşalimʼden gelmiş olan Yahudiler onun etrafını sarıp birçok ağır suçlamalarda bulundular. Ama bu suçlamalarını kanıtlayamadılar. ");
INSERT INTO turobt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pavlus da kendini savunmak için şöyle dedi: “Ben ne Yahudilerin kanunlarına, ne tapınağa, ne de Sezarʼa karşı hiçbir suç işlemedim.” ");
INSERT INTO turobt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama Festus Yahudilere bir iyilik yapmak istedi. Bu sebeple Pavlusʼa “Sen Yeruşalimʼe gitmeye razı mısın?” diye sordu. “Orada benim önümde bu suçlamalar konusunda yargılanabilirsin.” ");
INSERT INTO turobt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pavlus şöyle cevap verdi: “Ben Sezarʼın dava yerinin önünde bulunuyorum. Burada yargılanmam lazım. Yahudilere karşı hiçbir suç işlemedim. Sen de bunu çok iyi biliyorsun. ");
INSERT INTO turobt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Eğer suç işlemişsem, eğer ölümü hak eden herhangi bir şey yapmışsam, ölümden kaçmam. Ama eğer bu adamların suçlamaları doğru değilse, kimse beni onlara teslim edemez. Davamla Sezarʼa başvuruyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bunun üzerine Festus kendi danışma meclisiyle görüştükten sonra şöyle cevap verdi: “Sezarʼa başvurdun, Sezarʼa gideceksin.” ");
INSERT INTO turobt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Birkaç gün sonra, kral Agrippa ve Bernike, Festusʼa saygı göstermek için Sezariye şehrine geldiler. ");
INSERT INTO turobt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bir süre orada kaldılar. Ziyaret sırasında Festus Pavlusʼun davasını krala anlattı. “Burada bir adam var” dedi. “Feliks onu hapishanede bıraktı. ");
INSERT INTO turobt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ben Yeruşalimʼdeyken başrahipler ve diğer Yahudi liderler ona karşı şikâyette bulundular. Onu cezalandırmamı istediler. ");
INSERT INTO turobt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Onlara bu Romalıların adeti değildir diye cevap verdim. Kişi kendini suçlayanlarla yüzleşip suçlamalara karşı kendini savunma şansına sahip olmadan teslim edilmez. ");
INSERT INTO turobt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bu nedenle onlar benimle buraya gelince hiç vakit kaybetmedim. Ertesi gün dava yerinde oturdum ve adamın getirilmesini emrettim. ");
INSERT INTO turobt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ama suçlayanlar ayağa kalkınca, ona karşı beklediğim suçlamaları yapmadılar. ");
INSERT INTO turobt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sadece kendi dinleri konusunda ve İsa adında ölmüş bir adam hakkında anlaşmazlıkları vardı. Pavlus o adamın yaşamakta olduğunu söylüyordu. ");
INSERT INTO turobt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bu konuları nasıl soruşturacağımı bilemedim. Bu nedenle Pavlusʼa ‘Yeruşalimʼe gidip bu konularda orada yargılanmaya razı mısın?’ diye sordum. ");
INSERT INTO turobt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Fakat Pavlus davasıyla imparatora başvurdu. İmparator karar verinceye kadar hapishanede tutulmak istedi. Ben de onun imparatora gönderene kadar tutuklu kalmasını emrettim.” ");
INSERT INTO turobt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","O zaman Agrippa Festusʼa şöyle dedi: “Ben de bu adamı dinlemek isterdim.” Festus, “Yarın onu dinlersin” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ertesi gün Agrippa ve Bernike büyük tantanayla toplantı salonuna girdiler. Onların yanında yüksek rütbeli askerler ve şehrin önemli adamları vardı. Festusʼun emriyle Pavlus oraya getirildi. ");
INSERT INTO turobt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","O zaman Festus şöyle dedi: “Kral Agrippa ve yanımızda bulunan herkes! Bu adamı görüyorsunuz! Onun hakkında hem Yeruşalimʼde hem burada bütün Yahudi halkı bana şikâyette bulundu. ‘Bu adamın artık yaşaması doğru değildir’ diye bağırdılar. ");
INSERT INTO turobt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bense ölümü hak edecek hiçbir şey yapmadığını anladım. Ne var ki o, davasıyla imparatora başvurdu. Bu nedenle onu imparatora göndermeye karar verdim. ");
INSERT INTO turobt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama elimde onun hakkında Efendimʼe yazabileceğim kesin bir şey yok. Bunun için adamı sizin önünüze ve özellikle senin önüne getirdim, ey Kral Agrippa. Öyle ki, bu soruşturmanın sonunda yazacak bir şeyim olsun. ");
INSERT INTO turobt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Çünkü neyle suçlandığını açıklamadan bir tutukluyu imparatora göndermek bence anlamsız.” ");
INSERT INTO turobt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","O zaman Agrippa Pavlusʼa şöyle dedi: “Şimdi kendini savunabilirsin.” Bunun üzerine Pavlus elini uzatarak kendini savunmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kral Agrippa! Bugün Yahudi liderlerin bana yaptıkları suçlamalar hakkında senin huzurunda savunmamı yapabildiğim için kendimi mutlu sayıyorum. ");
INSERT INTO turobt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Özellikle Yahudilerin bütün adetlerini ve aralarında tartıştıkları konuları iyi bildiğin için mutluyum. Bu nedenle beni sabırla dinlemeni rica ediyorum. ");
INSERT INTO turobt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Durum şu, hayatım boyunca halkımın arasında ve Yeruşalimʼde, çocukluğumdan beri nasıl yaşadığımı bütün Yahudiler bilirler. ");
INSERT INTO turobt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Beni uzun zamandan beri tanırlar. İsteseler, geçmişte dinimizin en titiz partisine, Ferisi partisine bağlı olarak yaşadığıma şahitlik edebilirler. ");
INSERT INTO turobt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Şimdi Allahʼın atalarımıza verdiği vaade umut bağladığım için burada durup yargılanıyorum. ");
INSERT INTO turobt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Halkımızın on iki oymağı bu umuda kavuşmak istiyor. Bu sebeple gece gündüz Allahʼa canı gönülden ibadet ediyorlar. Ey Kralım, bu umuttan dolayı Yahudiler beni suçluyorlar. ");
INSERT INTO turobt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Allahʼın ölüleri diriltmesi sizlere niye inanılmaz geliyor? ");
INSERT INTO turobt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Aslında ben de Nasıralı İsaʼnın adının yayılmasına engel olmak için elimden geleni yapmam gerektiğine karar vermiştim. ");
INSERT INTO turobt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yeruşalimʼde aynen bunu yaptım. Başrahiplerden yetki alıp Allahʼın kutsal halkından birçoğunu hapishaneye attırdım. Yargılandıkları zaman da onlara ölüm cezası verilsin diye oy verdim. ");
INSERT INTO turobt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yahudilerin bütün toplantı yerlerini dolaşarak onları sık sık cezalandırdım. İnandıklarına küfretmeye zorladım. O kadar kudurmuştum ki, yabancı şehirlere bile gidip onlara eziyet ettim. ");
INSERT INTO turobt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Bu amaçla başrahiplerden yetki ve görev alıp Şam şehrine gidiyordum. ");
INSERT INTO turobt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ey Kral, yolda giderken öğle vakti gökten gelen bir ışık gördüm. Güneşten daha parlaktı. Benim ve benimle birlikte yolculuk edenlerin etrafını aydınlattı. ");
INSERT INTO turobt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Hepimiz yere yıkıldık. Ondan sonra benimle Aramice konuşan bir ses duydum. Bana şöyle dedi: ‘Saul, Saul, niçin bana eziyet ediyorsun? Benimle uğraşmakla kendine zarar veriyorsun!’ ");
INSERT INTO turobt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","O zaman, ‘Kimsin, Efendim?’ diye sordum. Rab şöyle cevap verdi: ‘Ben senin eziyet ettiğin İsaʼyım. ");
INSERT INTO turobt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Haydi, kalk ayağa! Bana hizmet etmen için seni seçtim. İşte bu sebeple sana göründüm. Bugün gördüklerin ve ileride sana göstereceğim şeyler hakkında şahitlik edeceksin. ");
INSERT INTO turobt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Seni kendi halkının ve diğer milletlerin elinden kurtaracağım. Çünkü seni onlara gönderiyorum. ");
INSERT INTO turobt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Onların gözlerini açmanı istiyorum. Öyle ki, karanlıktan aydınlığa, Şeytanʼın kuvvetinden Allahʼa dönsünler. Böylece günahları bağışlansın ve bana iman etmekle Allahʼın kutsal halkının arasında yer alsınlar.’ ");
INSERT INTO turobt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Bunun için, ey Kral Agrippa, gökten bana gösterilen bu olağanüstü görüntüye karşı koymadım. ");
INSERT INTO turobt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Önce Şam ve Yeruşalim halkına, bütün Yahudiye bölgesinde olanlara ve diğer milletlere gittim. Onları tövbe edip Allahʼa dönmeye ve tövbeye uygun şeyler yapmaya çağırdım. ");
INSERT INTO turobt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bu sebeple bazı Yahudiler beni tapınak avlusunda yakaladılar ve öldürmeye kalkıştılar. ");
INSERT INTO turobt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bugüne kadar Allah bana yardımcı oldu. Bu sayede burada durup küçük büyük herkese şahitlik ediyorum. Benim söylediklerim, peygamberlerin ve Musaʼnın önceden haber verdiği olaylardan başka bir şey değildir. ");
INSERT INTO turobt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bu peygamberler şöyle demişlerdi: Mesih acı çekecek, ölümden dirilenlerin ilki olacak ve hem kendi halkına, hem de diğer milletlere ışığın doğduğunu duyuracak.” ");
INSERT INTO turobt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pavlus bu sözlerle kendini savunurken, Festus yüksek sesle “Pavlus, çıldırmışsın!” dedi. “Çok okumak seni delirtmiş!” ");
INSERT INTO turobt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pavlus şöyle cevap verdi: “Hayır, sayın Festus, çıldırmadım. Söylediğim sözler gerçek ve akla uygun. ");
INSERT INTO turobt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kral bu konuları anlıyor. Onun için kendisiyle çekinmeden konuşuyorum. Çünkü eminim ki, bu olaylardan hiçbiri onun dikkatinden kaçmadı. Zaten bu iş gizli saklı bir köşede olmadı. ");
INSERT INTO turobt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kral Agrippa, peygamberlerin yazılarına inanıyor musun? İnandığını biliyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa ise Pavlusʼa, “Az kalsın beni Mesihçi olmaya inandıracaktın!” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pavlus da şöyle cevap verdi: “Az ya da çok, yalnız sen değil, ama bugün beni duyan herkes, bu zincirlerin dışında benim gibi olsun diye Allahʼtan diliyorum.” ");
INSERT INTO turobt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ondan sonra kral, vali, Bernike ve onlarla birlikte oturanlar ayağa kalktılar. ");
INSERT INTO turobt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bir kenara çekilip birbirleriyle şöyle konuştular. “Bu adam ölüm ya da hapis cezasını hak edecek bir şey yapmamış” dediler. ");
INSERT INTO turobt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa da Festusʼa şöyle dedi: “Eğer davasıyla Sezarʼa başvurmasaydı, bu adam serbest bırakılabilirdi.” ");
INSERT INTO turobt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Gemiyle İtalyaʼya gitmemize karar verilmişti. Pavlusʼu ve diğer birkaç tutukluyu Yulyus adında bir yüzbaşıya teslim ettiler. Yulyus ordunun imparatorluk bölüğündendi. ");
INSERT INTO turobt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Edremit şehrinden olan bir gemiye bindik. Gemi Ege bölgesinin kıyısındaki şehirlere uğrayacaktı. Böylece denize açıldık. Yanımızda Selanik şehrinden Makedonyalı Aristarhus vardı. ");
INSERT INTO turobt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ertesi gün Sayda limanına uğradık. Yulyus Pavlusʼa insanca davrandı ve ihtiyaçlarının karşılanması için arkadaşlarıyla görüşmesine izin verdi. ");
INSERT INTO turobt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Oradan yine denize açıldık. Rüzgar ters yönden esiyordu. Bu yüzden Kıbrıs adasının rüzgarsız tarafından geçtik. ");
INSERT INTO turobt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilikya ve Pamfilyaʼnın önündeki açık denizden geçip Likya bölgesindeki Mira limanında karaya bağlandık. ");
INSERT INTO turobt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Orada yüzbaşı başka bir gemi buldu. Bu gemi İskenderiyeʼden gelip İtalyaʼya gidecekti. Bizi ona bindirdi. ");
INSERT INTO turobt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Günlerce ağır ağır ilerledik. Knidos şehrinin karşısına zorlukla vardık. Rüzgar daha öteye gitmemize engel oluyordu. Bunun için Salmone burnundan dolanıp Girit adasının rüzgarsız tarafından geçtik. ");
INSERT INTO turobt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Girit kıyısı boyunca güçlükle ilerledik. Laseya kasabasına yakın olan Kali Limenes adında bir yere geldik. ");
INSERT INTO turobt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Çok vakit kaybetmiştik. Yahudilerin sonbahardaki oruç günü de geçmişti. Bu mevsimde deniz yolculuğu tehlikeliydi. Onun için Pavlus onlara akıl verip şöyle dedi: ");
INSERT INTO turobt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Beyler! Görüyorum ki bu yolculuğa devam etmek tehlikeli ve çok zararlı olacak. Yalnız yükü ve gemiyi değil, canlarımızı da kaybedebiliriz” dedi. ");
INSERT INTO turobt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama yüzbaşı, Pavlusʼun söylediklerini dinlemedi. Kaptanla gemi sahibinin fikrine uydu. ");
INSERT INTO turobt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kali Limenes kışı geçirmeye uygun değildi. Bu yüzden gemidekilerin çoğu, oradan denize açılmaya ve mümkünse Fineka şehrine ulaşmaya karar verdiler. Fineka, Giritʼin hem güneybatıya hem de kuzeybatıya bakan bir limanıdır. Kışı orada geçirmeyi uygun gördüler. ");
INSERT INTO turobt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Güneyden hafif bir rüzgar esmeye başlayınca gemidekiler istediklerini elde ettiklerini sandılar. Demir aldılar ve Girit kıyısının yakınından ilerlemeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Fazla vakit geçmeden, adadan “Evrakilon” denilen çok kuvvetli bir rüzgar esmeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Gemi rüzgara tutuldu ve rüzgara karşı ilerleyemedi. O zaman gemiyi sürüklenmeye bıraktık. ");
INSERT INTO turobt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Gavdos adında küçük bir adanın rüzgarsız tarafından geçtik. Orada geminin arkasından çekilen can kurtaran botu zorla tutabildik. ");
INSERT INTO turobt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Botu yukarı çektiler. Sonra gemiyi güçlendirmek için kalın ipler kullanarak altından bağladılar. Geminin Sirte Körfeziʼndeki sığ yerlerde karaya saplanmasından korktular. Bunun için bez çapayı denize indirip gemiyi sürüklenmeye bıraktılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Fırtına bizi çok hırpalıyordu. Bu yüzden ertesi gün gemiden yük atmaya başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Üçüncü gün de kendi elleriyle bazı gemi aletlerini denize attılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Günlerce ne güneş, ne de yıldızlar göründü. Fırtına bütün gücüyle devam etti. Artık kurtulma umudumuz hiç kalmamıştı. ");
INSERT INTO turobt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Uzun zaman hiç kimse bir şey yemedi. Pavlus onların önüne çıkıp şöyle dedi: “Beyler! Beni dinlemeliydiniz. Giritʼten denize açılmayın dedim. O zaman bu zarar ve ziyana uğramazdınız. ");
INSERT INTO turobt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama şimdi size akıl vereyim: Gönlünüz rahat olsun! Aranızdan bir kişi bile canını kaybetmeyecek, sadece gemi yok olacak. ");
INSERT INTO turobt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Çünkü dün gece ait olduğum ve ibadet ettiğim Allahʼın bir meleği yanıma geldi. ");
INSERT INTO turobt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Şöyle dedi: ‘Korkma, Pavlus! Sezarʼın önüne çıkman lazım. Bak, Allah sana lütuf olarak seninle birlikte gemide olan herkesi sağ bırakacak.’ ");
INSERT INTO turobt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Bunun için, beyler, gönlünüz rahat olsun! Allahʼa güveniyorum. Her şey aynen bana bildirildiği gibi olacak. ");
INSERT INTO turobt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ancak gemiyi bir adada karaya oturtmamız lazım.” ");
INSERT INTO turobt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","On dördüncü gece geldiğinde İyon Deniziʼnde sağa sola sürükleniyorduk. Gece yarısına doğru gemiciler karaya yaklaştıklarını sezdiler. ");
INSERT INTO turobt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Denizin derinliğini ölçmeye başladılar. Derinliği yaklaşık kırk metre buldular. İleride tekrar ölçtüler ve yaklaşık otuz metre buldular. ");
INSERT INTO turobt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kayalık yerlere çarpmaktan korktular. Bunun için geminin arka tarafından dört tane demir attılar ve günün doğması için dua ettiler. ");
INSERT INTO turobt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","O arada gemiciler gemiyi terk etmeye kalkıştılar. Geminin ön tarafından demir atacaklarmış gibi yaptılar. Aslında can kurtaran botu denize indirdiler. ");
INSERT INTO turobt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pavlus yüzbaşıya ve askerlere şöyle dedi: “Bu gemiciler gemide kalmadıkça siz de kurtulamazsınız.” ");
INSERT INTO turobt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bunun üzerine askerler can kurtaran botun iplerini kesip onu denize saldılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sabaha doğru Pavlus herkesin yemek yemesini rica etti. Onlara şöyle dedi: “On dört gündür kaygı içinde bekleyip aç kaldınız, bir lokma bile yemediniz. ");
INSERT INTO turobt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bunun için size rica ederim, yemek yiyin. Kurtulmak için, bunu yapmanız lazım. Hiçbirinizin kafasından bir saç teli bile düşmeyecek.” ");
INSERT INTO turobt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bunu söyledikten sonra, eline ekmek aldı, herkesin önünde Allahʼa şükretti ve ekmeği bölüp yemeye başladı. ");
INSERT INTO turobt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hepsi bundan cesaret aldılar ve yemek yemeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Gemide toplam iki yüz yetmiş altı kişiydik. ");
INSERT INTO turobt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Herkes doyduktan sonra gemiyi hafifletmek için buğdayı denize döktüler. ");
INSERT INTO turobt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sabah olunca gördükleri yeri tanıyamadılar. Ama kumsal bir koy fark ettiler. Mümkünse gemiyi orada karaya oturtmaya karar verdiler. ");
INSERT INTO turobt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Demirleri çözüp denizde bıraktılar. Aynı zamanda dümenlerin iplerini çözdüler ve ön yelkeni rüzgara karşı açtılar. Böylece kıyıya doğru ilerlediler. ");
INSERT INTO turobt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama deniz altında bir kumluk tepe vardı. Gemi oraya saplandı. Geminin ön tarafı takılıp kaldı, arka tarafı ise dalgaların kuvvetiyle parçalanmaya başladı. ");
INSERT INTO turobt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Askerler tutukluları öldürmek niyetindeydi. Çünkü yüzerek kaçmalarını istemiyorlardı. ");
INSERT INTO turobt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Yüzbaşı ise, Pavlusʼu kurtarmak istedi. Bu sebeple askerlerin niyetine engel oldu. Yüzmeyi bilen kişilerin önce denize atlayıp karaya çıkmaları için buyruk verdi. ");
INSERT INTO turobt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kalanların ya tahtalara, ya da geminin başka parçalarına tutunarak arkadan gelmelerini emretti. Aynı bu şekilde herkes sağ salim karaya vardı. ");
INSERT INTO turobt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Herkes kurtulduktan sonra o adanın isminin Malta olduğunu öğrendik. ");
INSERT INTO turobt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Yerli halk bize olağanüstü bir yakınlık gösterip hepimizi hoş karşıladı. Hava soğuk ve yağmurlu olduğu için ateş yaktılar. ");
INSERT INTO turobt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pavlus büyük bir demet çalı çırpı toplayıp ateşe koydu. O an sıcaktan bir yılan fırlayıp onun eline yapıştı. ");
INSERT INTO turobt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Yerliler Pavlusʼun eline asılan yılanı görünce birbirlerine şöyle dediler: “Bu adam katil olsa gerek. Denizden kurtuldu, ama Adalet onu yaşatmadı.” ");
INSERT INTO turobt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Fakat Pavlus, elini sallayıp hayvanı ateşe fırlattı ve hiç zarar görmedi. ");
INSERT INTO turobt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Halk Pavlusʼun bedeninin şişmesini ya da aniden yere düşüp ölmesini bekliyordu. Uzun zaman beklediler. Ama ona bir zarar gelmediğini görünce fikirlerini değiştirdiler. “O bir tanrıdır!” demeye başladılar. ");
INSERT INTO turobt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Malta Adasıʼnın valisi Publiyus adında bir adamdı. Bulunduğumuz yere yakın toprakları vardı. Bizi iyi karşıladı ve üç gün boyunca misafir etti. ");
INSERT INTO turobt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","O arada Publiyusʼun babası dizanteri hastalığına yakalanmış ateşler içinde yatıyordu. Pavlus onun yanına gitti, dua etti ve ellerini onun üstüne koyup onu iyileştirdi. ");
INSERT INTO turobt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Bu olay olduktan sonra, adadaki diğer hastalar da geldiler ve şifa buldular. ");
INSERT INTO turobt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bize saygı göstermek için birçok hediye getirdiler. Oradan ayrılırken de, yolculuğumuz için gereken malzemeleri gemiye yüklediler. ");
INSERT INTO turobt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","İskenderiyeʼden bir gemi kışı adada geçirmişti. Geminin başında “İkiz tanrılar” heykeli vardı. Üç ay geçtikten sonra bu gemiye binip denize açıldık. ");
INSERT INTO turobt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirakuza limanına uğrayınca orada üç gün kaldık. ");
INSERT INTO turobt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Oradan dolanarak Regiyum limanına vardık. Bir gün sonra güneyden bir rüzgar esmeye başladı ve ikinci gün Puteyoli şehrine geldik. ");
INSERT INTO turobt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Orada bazı imanlılarla karşılaştık. Bizi davet ettiler ve yedi gün onlarla kaldıktan sonra Romaʼya doğru hareket ettik. ");
INSERT INTO turobt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romaʼdaki imanlılar bizden haber alınca, bizi karşılamak için ta Appiyus Çarşısıʼna ve Üç Hanlarʼa kadar gelmişlerdi. Pavlus onları görünce Allahʼa şükretti ve cesaretlendi. ");
INSERT INTO turobt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romaʼya geldiğimiz zaman, Pavlusʼun tek başına ev hapsinde kalmasına izin verildi. Sadece bir askerin gözetimi altındaydı. ");
INSERT INTO turobt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Vardıktan üç gün sonra Pavlus Yahudi liderleri yanına çağırdı. Toplandıklarında onlara şöyle dedi: “Kardeşler! Ben ne halkımıza, ne de atalarımızın adetlerine aykırı bir şey yapmadım. Yine de Yeruşalimʼde tutuklandım ve Romalıların eline teslim edildim. ");
INSERT INTO turobt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romalılar beni sorguya çektikten sonra serbest bırakmak istiyorlardı. Çünkü ölüm cezasına çarptırılacak hiçbir suç işlememiştim. ");
INSERT INTO turobt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama Yahudi liderler bana karşı çıktılar. Bunun için davamla Sezarʼa başvurmaya mecbur kaldım. Bunu kendi halkımdan şikâyet etmek için yapmadım. ");
INSERT INTO turobt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ben İsrail halkının umudu olan Mesih için bu zincirlere vuruldum. İşte bu sebeple sizi davet ettim. Sizinle görüşmek ve konuşmak istedim.” ");
INSERT INTO turobt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Romaʼdaki Yahudi liderler Pavlusʼa şöyle dediler: “Yahudiyeʼden senin hakkında mektup almadık, oradan gelen kardeşlerden hiçbiri de senin hakkında haber getirmedi, kötü bir şey söylemedi. ");
INSERT INTO turobt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama senin fikirlerini senden öğrenmek isteriz. Çünkü her yerde bu din partisine karşı konuşulduğunu biliyoruz.” ");
INSERT INTO turobt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Buluşmak için Pavlusʼa bir gün verdiler. O gün daha büyük bir kalabalık halinde Pavlusʼun kaldığı eve geldiler. Pavlus onlarla sabahtan akşama kadar konuştu, Allahʼın Krallığıʼnı açıkladı. Musaʼya verilen Tevratʼı ve diğer peygamberlerin kitaplarını kullanarak onları İsaʼya inandırmaya çalıştı. ");
INSERT INTO turobt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kimisi onun söylediklerini kabul ediyor, kimisi ise reddediyordu. ");
INSERT INTO turobt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Aralarında anlaşmazlık çıkınca oradan ayrılmaya başladılar. Onlar gitmeden Pavlus şu son sözü söyledi: “Kutsal Ruh atalarınıza peygamber Yeşayaʼnın ağzından doğru konuşmuştu. ");
INSERT INTO turobt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Şöyle dedi: ‘Bu halka git ve söyle: Hep işiteceksiniz, ama hiç anlamayacaksınız. Hep bakacaksınız, ama hiç görmeyeceksiniz. ");
INSERT INTO turobt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Çünkü bu halkın yüreği duygusuz oldu. Kulakları zor işitiyor. Gözlerini kapadılar. Öyle olmasaydı, onların gözleri görür, kulakları işitir, yürekleri anlardı. Bana dönerlerdi, ben de onlara şifa verirdim.’ ");
INSERT INTO turobt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Bunun için, şunu iyi bilin: Allahʼın sağladığı bu kurtuluşun haberi diğer milletlere gönderilmiştir. Onlar da buna kulak verecekler!” ");
INSERT INTO turobt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pavlus tam iki yıl kendi kiraladığı evde kaldı. Kendisine gelen herkesi kabul etti. ");
INSERT INTO turobt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Allahʼın Krallığıʼnı büyük cesaretle duyurdu ve Rab İsa Mesih hakkında vaaz etti. Kimse de ona engel olmadı.");
INSERT INTO turobt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ben Pavlus, Mesih İsaʼnın kuluyum. Allah beni elçisi olmaya çağırdı ve Müjdesiʼni yaymak için seçti. ");
INSERT INTO turobt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Bu Müjdeʼyi peygamberleri aracılığıyla Kutsal Yazılarʼda önceden vaat etti. ");
INSERT INTO turobt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Müjde Oʼnun Oğlu Rabbimiz İsa Mesih hakkındadır. O, beden açısından Davudʼun soyundandır. Ama ruhunun kutsallığı açısından Allahʼın Oğluʼdur. Ölümden dirilerek bunu kudretle gösterdi. ");
INSERT INTO turobt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mesihʼin aracılığıyla ve Oʼnun adı uğruna elçisi olma lütfuna kavuştuk. Öyle ki, bütün halklardan insanlar imana gelip Allahʼa itaat etsinler. ");
INSERT INTO turobt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Siz de bu insanlar arasındasınız. İsa Mesihʼe ait olmaya çağrılmıştınız. ");
INSERT INTO turobt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Allah tarafından sevilen ve Oʼnun kutsal halkı olmaya çağrılan Romaʼdaki bütün imanlılara yazıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","En başta İsa Mesih adıyla Allahımʼa hepiniz için şükrediyorum. Çünkü imanınız bütün dünyada konuşuluyor. ");
INSERT INTO turobt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Sizleri dualarımda sürekli andığıma Allah şahidimdir. Bütün varlığımla Oʼna hizmet ediyorum, Oğlu hakkındaki Müjdeʼyi yayıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Allahʼın izniyle yakında yanınıza gelmek için yolum açılsın diye daima yalvarıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Çünkü sizleri görmeye hasret kaldım. Güçlenmeniz için sizlerle Allah lütfundan ruhsal bir bereket paylaşmak istiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yani, ben aranızdayken birbirimizin imanından karşılıklı cesaret alalım. ");
INSERT INTO turobt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Kardeşler, bilmenizi istiyorum ki, size gelmeye çok defa niyet ettim. Ama önüme hep engel çıktı. Diğer milletlerde olduğu gibi sizin aranızda da hizmetimin verimli olmasını istiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ben hem Greklere, hem de başka halklara, hem okumuşlara, hem de cahillere hizmet etmeye mecburum. ");
INSERT INTO turobt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Bu sebeple Romaʼda bulunan sizlere de Müjdeʼyi bildirmek için sabırsızlanıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ben Müjdeʼden utanmam. Çünkü iman eden herkese, önce Yahudilere, sonra Greklere, kurtuluş getiren Allahʼın gücüdür. ");
INSERT INTO turobt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Müjdeʼde Allahʼın insanları nasıl doğru saydığı açıkça gösterilir. Doğruluk baştan sona kadar imana dayanır. Yazılmış olduğu gibi, “Allahʼın doğru saydığı kişi imanı sayesinde hayat bulacak.” ");
INSERT INTO turobt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","İnsanların Allahʼa saygısızlıkları ve yaptıkları kötülükler yüzünden Allahʼın öfkesi gökten açıkça gösteriliyor. İnsanlar yaptıkları kötülüklerle gerçeğin bilinmesine engel oluyorlar. ");
INSERT INTO turobt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Çünkü Allah hakkında bilinmesi mümkün olan her şey onların gözleri önünde. Allah bunu onlara açıkladı. ");
INSERT INTO turobt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Oʼnun sonsuza dek var olan kudreti ve öz tabiatı gözle görülmez. Fakat bunlar, dünyanın yaratılışından beri Allahʼın yarattığı şeylerden anlaşılarak fark edilir. Bu yüzden insanların özürleri yok. ");
INSERT INTO turobt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Allahʼı tanıdılar, fakat Oʼna layık olduğu saygıyı göstermediler, Oʼna şükretmediler. Boş düşüncelere daldılar ve akılsız yüreklerine karanlık çöktü. ");
INSERT INTO turobt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","“Akıllıyız” derken akılsız çıktılar. ");
INSERT INTO turobt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ölümsüz Allahʼın yüceliğini, ölümlü insana, kuşlara, dört ayaklı hayvanlara ve yerde sürünen yaratıklara benzeyen putlarla değiştirdiler. ");
INSERT INTO turobt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Bu yüzden Allah onları yüreklerindeki kötü isteklerden gelen rezil davranışlara terk etti. Bedenlerini utanç verici şeyler yapmak için kullanıyorlar. ");
INSERT INTO turobt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Allah hakkındaki gerçeği reddedip bir yalana inandılar. Yaratana değil de, yaratılana tapıp hizmet ettiler. Oysa sonsuza kadar övgüye layık olan Allahʼtır. Amin. ");
INSERT INTO turobt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Bu sebeple, Allah onları rezil isteklere terk etti. Onların kadınları, erkeklerle birleşmeyi bırakıp sapık ilişkilere giriştiler. ");
INSERT INTO turobt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Erkekler de kadınla olan birleşmeyi bırakıp birbirlerine seksüel istekle yanıp tutuştular. Erkek erkekle utanç verici şeyler yaptı. Bu sapıklık için hak ettikleri cezayı aldılar. O cezayı da kendi bedenlerinde çektiler. ");
INSERT INTO turobt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Allahʼı tanımak işlerine gelmediği için, Allah onları aşağılık düşüncelere, edepsiz davranışlara terk etti. ");
INSERT INTO turobt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Her türlü kötülük, haksızlık, açgözlülük ve kinle doldular. Yürekleri kıskançlık, katillik, kavgacılık, aldatıcılık ve kötü niyetle dolup taştı. ");
INSERT INTO turobt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Onlar dedikoducu, birbirlerini kötüleyen, Allahʼtan nefret eden, saygısız, gururlu, kibirli, kötülük yapmak için fırsat kollayan, anne babalarını dinlemeyen kişilerdir. ");
INSERT INTO turobt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bu insanlar anlayışsız, sözünü tutmayan, sevgisiz ve merhametsiz kişilerdir. ");
INSERT INTO turobt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Allahʼın adaletli hükmüne göre böyle davrananlar ölümü hak eder. Onlar da bunu bilirler, ama yine de bu işleri yaparlar. Bu kötülükleri yapmaları yetmiyormuş gibi, bu tür işleri yapanları da alkışlarlar. ");
INSERT INTO turobt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Bunun için, sen kim olursan ol, başkalarını yargılamak için hiçbir bahanen yok. Başkasını suçladığın zaman kendini suçlu çıkarıyorsun. Çünkü aynı şeyleri yapıyorsun. ");
INSERT INTO turobt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Allahʼın böyle şeyleri yapan kişileri haklı olarak yargıladığını biliyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Böyle şeyleri yapanları yargılayan ama aynı şeyleri yapan sen, Allahʼın yargısından kaçıp kurtulacağını mı sanıyorsun? ");
INSERT INTO turobt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Yoksa Allahʼın sınırsız iyiliğini, hoşgörüsünü ve sabrını hor mu görüyorsun? Allahʼın iyiliği seni tövbe etmeye yöneltiyor. Bunu bilmiyor musun? ");
INSERT INTO turobt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Fakat inatçılığın ve tövbesiz yüreğin yüzünden Allahʼın seni öfkeyle yargılayacağı günde çekeceğin cezayı biriktiriyorsun. O gün Allah, öfkesini ve adaletli yargısını açıkça gösterecek. ");
INSERT INTO turobt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","“Herkese yaptığının karşılığını verecek.” ");
INSERT INTO turobt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bazıları sabırla iyilik yapmaya devam ederek yücelik, saygınlık ve ölümsüzlük ararlar. Allah onlara sonsuz yaşam verecek. ");
INSERT INTO turobt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Diğerleri ise bencil isteklerine uyarak gerçeği reddedip kötülük yapmaya devam ederler. Allah onları öfke ve kızgınlıkla cezalandıracak. ");
INSERT INTO turobt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kötülük işleyen herkese, önce Yahudilere, sonra Yahudi olmayanlara acı ve sıkıntı çektirecek. ");
INSERT INTO turobt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Fakat iyilik yapan herkesi, önce Yahudileri, sonra Yahudi olmayanları yücelik, saygınlık ve esenlikle ödüllendirecek. ");
INSERT INTO turobt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Çünkü Allah insanlar arasında ayrım yapmaz. ");
INSERT INTO turobt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Tevrat kanunlarından habersiz olup günah işleyenler bu kanunlar olmadan da mahvolacaklar. Tevrat kanunlarını bilerek günah işleyenler ise bu kanunlara göre yargılanacaklar. ");
INSERT INTO turobt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Çünkü Allahʼın gözünde doğru sayılacak olanlar Tevrat kanunlarını işitenler değil, onları yerine getirenlerdir. ");
INSERT INTO turobt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Yahudi olmayanlar Tevratʼa sahip değildir. Ama bazıları doğal olarak Tevrat kanunlarını yerine getirirler. Tevratʼa sahip değilseler de, doğru ve yanlışı gösteren bir kanunları var. ");
INSERT INTO turobt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Böyle kişiler Tevrat kanunlarının istediği şeylerin yüreklerinde yazılı olduğunu kanıtlar. Vicdanları da buna şahitlik eder. Çelişen düşünceleri, onları bazen suçlu bazen de haklı bile çıkarır. ");
INSERT INTO turobt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Yargı gününde durum böyle olacak. Yaydığım Müjdeʼye göre bir gün Allah insanların gizlediği günahları İsa Mesih aracılığıyla yargılayacak. ");
INSERT INTO turobt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ya sen? Kendine Yahudi diyorsun, Tevratʼa dayanıyorsun ve Allahʼa yakın olmakla övünüyorsun. ");
INSERT INTO turobt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Allahʼın senden ne istediğini biliyorsun ve doğruyu yanlıştan ayırt edebiliyorsun. Çünkü bunları Tevrat kanunlarından öğrenmişsin. ");
INSERT INTO turobt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","Körlerin kılavuzu, karanlıktakilerin ışığı, cahillerin eğitmeni, acemilerin öğretmeni olduğuna inanıyorsun. Çünkü Tevrat sayesinde bilginin ve gerçeğin esasına sahipsin. ");
INSERT INTO turobt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Başkalarına akıl verirsin. Öyleyse kendine akıl vermez misin? “Çalma” diye vaaz ederken, çalıyor musun? ");
INSERT INTO turobt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","“Zina etme” derken, zina ediyor musun? Putlardan iğrendiğini söylerken, tapınakları soyuyor musun? ");
INSERT INTO turobt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tevratʼa sahip olmakla övünürken, Tevrat kanunlarını çiğneyip Allahʼın şerefine leke sürüyorsun. ");
INSERT INTO turobt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Tıpkı yazıldığı gibi: “Sizin yüzünüzden diğer milletler arasında Allahʼın adı kötüleniyor.” ");
INSERT INTO turobt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Eğer Tevrat kanunlarını yerine getirirsen, sünnetli olmanın elbette faydası olur. Ama eğer Tevrat kanunlarını çiğnersen, sünnetliysen de sünnetsiz gibi olursun. ");
INSERT INTO turobt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Çünkü eğer sünnetsiz bir kişi Tevratʼtaki buyrukları yerine getirirse, o kişi Allah tarafından sünnetli sayılır, öyle değil mi? ");
INSERT INTO turobt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Bedence sünnetsiz olan ama Tevrat kanunlarını yerine getiren bir kişi seni suçlu çıkaracak. Çünkü sen Tevrat kitabına ve sünnete sahipsin, ama Tevrat kanunlarını çiğniyorsun. ");
INSERT INTO turobt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ne de olsa asıl Yahudi dış görünüşte Yahudi değildir. Asıl sünnet de dış görünüşte, bedende yapılan sünnet değildir. ");
INSERT INTO turobt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ancak içten olan Yahudi asıl Yahudidir. Asıl sünnet de insan yüreğindedir. Bu da yazılı buyrukla değil, Kutsal Ruhʼla olur. Böyle bir kişi, insanlardan değil, Allahʼtan övgü alır. ");
INSERT INTO turobt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","O halde Yahudiʼnin ne üstünlüğü var? Ya da sünnetin faydası ne? ");
INSERT INTO turobt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Elbette her bakımdan çoktur. Öncelikle Allah, vahiylerini Yahudilere emanet etti. ");
INSERT INTO turobt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Peki, bazı Yahudiler o emanete sadık kalmadıysa onların sadakatsizliği Allahʼın sadakatini ortadan kaldırır mı? ");
INSERT INTO turobt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Olmaz öyle şey! Bütün insanlar yalancı çıksa bile, bilin ki Allah doğruyu söyler. Allah hakkında yazılmış olduğu gibi, “Sen sözlerinle haklı çıkarsın. Seni suçladıkları zaman davayı kazanırsın.” ");
INSERT INTO turobt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Peki, eğer yaptığımız doğru olmayan şeyler Allahʼın doğruluğunu gösterirse, ne diyelim? Ben insanların bakış açısından konuşuyorum. Bizi öfkeyle cezalandıran Allah haksız mı? ");
INSERT INTO turobt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Olmaz öyle şey! Öyle olsa Allah dünyayı nasıl yargılayabilir? ");
INSERT INTO turobt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Eğer benim yalanımla Allahʼın doğruluğu daha belli oluyorsa ve bu Allahʼı yüceltiyorsa, nasıl oluyor da, ben hâlâ bir günahkâr olarak yargılanıyorum? ");
INSERT INTO turobt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Niçin “Kötülük yapalım ki bundan iyilik çıksın” demeyelim? Zaten bazıları bizi tam bunu söylemekle suçluyorlar. Bu iftiradır! Böyle konuşanlar hak ettikleri cezayı alacaklar. ");
INSERT INTO turobt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Öyleyse, ne diyelim? Biz Yahudiler diğer milletlerden daha üstün bir durumda mıyız? Elbette hayır! Çünkü ister Yahudi, ister diğer milletlerden olsun, herkesi günaha esir olmakla suçladık. ");
INSERT INTO turobt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Yazılmış olduğu gibi, “Doğru kimse yok, tek kişi bile yok. ");
INSERT INTO turobt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Aklı başında kimse yok, Allahʼı izleyen yok. ");
INSERT INTO turobt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Hepsi yoldan saptı, tümü değersiz oldu. İyilik yapan kimse yok, bir kişi bile yok.” ");
INSERT INTO turobt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Boğazları açık birer mezardır. Dilleriyle aldatırlar.” “Dudaklarından yılan zehri dökülür.” ");
INSERT INTO turobt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Ağızları lanet ve acıyla doludur.” ");
INSERT INTO turobt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ayakları kan dökmeye koşar. ");
INSERT INTO turobt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Gittikleri her yerde yıkım ve perişanlık bırakırlar. ");
INSERT INTO turobt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Esenlik yolunu bilmezler.” ");
INSERT INTO turobt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Allahʼtan korkmak onların aklına bile gelmez.” ");
INSERT INTO turobt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tevrat kanunlarında emredilen her şeyin bu kanunlara uymaya mecbur olan kişilere söylendiğini biliyoruz. Öyle ki her ağız susturulsun ve bütün dünya Allahʼa hesap versin. ");
INSERT INTO turobt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Çünkü Tevrat kanunlarını yerine getirmekle hiç kimse Allahʼın gözünde doğru sayılmayacak. Tevrat kanunları sayesinde günahın ne olduğunu öğreniyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ama şimdi kanuna dayanmadan Allahʼın insanı nasıl doğru sayabileceği açıklandı. Tevrat ve peygamberler buna şahitlik eder. ");
INSERT INTO turobt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Allah İsa Mesihʼe iman edenleri doğru sayar. Bu, iman eden herkes için geçerlidir. Çünkü Allah insanların arasında ayrım yapmaz. ");
INSERT INTO turobt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Herkes günah işledi bu yüzden Allahʼın yüceliğinden yoksun kalır. ");
INSERT INTO turobt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Allah hiçbir karşılık beklemeden insanları kendi lütfuyla doğru sayar. Çünkü Mesih İsa onları günaha esir olmaktan kurtarır. ");
INSERT INTO turobt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Allah Oʼnu bizim için kurban olarak sundu. Mesih kendi kanını akıtarak iman edenlerin günahlarını bağışlattı. Allah böylece doğruluğunu açıkça gösterdi. Çünkü geçmişte hep sabretmiş ve işlenen günahları cezasız bırakmıştı. ");
INSERT INTO turobt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Allah böyle sabrederek şimdiki zamanda doğruluğunu gösterdi. Neticede hem kendi doğruluğunu korudu, hem de İsaʼya iman edenleri doğru sayabildi. ");
INSERT INTO turobt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Öyleyse, insanın övünmesi için sebep var mı? Hiç yok. Bu hangi prensibe dayanır? Tevratʼın kanunlarını yerine getirmek prensibine mi? Hayır, iman prensibine dayanarak insanın övünmesine sebep yoktur. ");
INSERT INTO turobt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Çünkü şu sonuca vardık: Allah insanları, Tevratʼtaki kanunları yerine getirdikleri için değil, iman ettikleri için doğru sayar. ");
INSERT INTO turobt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Yoksa Allah sadece Yahudilerin Allahı mı? Diğer milletlerin de Allahı değil mi? Elbette, diğer milletlerin de Allahıʼdır. ");
INSERT INTO turobt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mademki Allah birdir, O, sünnetli olan Yahudileri iman sayesinde doğru sayacak, sünnetsiz olan diğer milletleri de imanlarıyla doğru sayacak. ");
INSERT INTO turobt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Öyleyse, imanla kurtuluruz demekle Tevrat kanunlarını geçersiz mi kılıyoruz? Olmaz öyle şey! Tam tersine, Tevratʼı daha da geçerli kılıyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Öyleyse biz Yahudilerin atası İbrahimʼin neye kavuştuğu konusunda ne diyelim? ");
INSERT INTO turobt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","İbrahim kendi yaptıkları sayesinde doğru sayılmadı. Öyle olsaydı övünmeye hakkı olurdu, ama Allahʼın önünde övünemez. ");
INSERT INTO turobt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kutsal Yazı ne diyor? “İbrahim Allahʼa iman etti ve bu ona doğruluk sayıldı.” ");
INSERT INTO turobt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Çalışan adamın aldığı karşılık lütuf sayılmaz, hak sayılır. ");
INSERT INTO turobt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ama bir kişi Tevratʼın buyurduğu işleri yapmazsa, sadece günahkârları doğru sayan Allahʼa iman ederse, o kişi imanı sayesinde doğru sayılır. ");
INSERT INTO turobt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Bunun gibi Davud da Allah tarafından doğru sayılmayı hak edecek bir şey yapmayan, yine de doğru sayılan insanların mutluluğunu şöyle anlatır: ");
INSERT INTO turobt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Ne mutlu o kişilere ki, suçları bağışlandı, günahları affedildi. ");
INSERT INTO turobt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ne mutlu o insana ki, Rab onun günahlarını hesaba katmaz.” ");
INSERT INTO turobt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Peki, bu mutluluk sadece sünnetliler, yani Yahudiler için mi, yoksa aynı zamanda sünnetsiz olan diğer milletler için de mi geçerli? Hani diyoruz ki, İbrahimʼin imanı ona doğruluk sayıldı. ");
INSERT INTO turobt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","İbrahim hangi durumdayken doğru sayıldı? Sünnetliyken mi, sünnetsizken mi? Sünnetliyken değil, sünnetsizken doğru sayıldı. ");
INSERT INTO turobt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Evet, İbrahim daha sünnetsizken iman ederek doğru sayılmıştı. Daha sonra sünnet oldu. Sünnet bu doğruluğun işareti ve mührüydü. Öyle ki İbrahim, sünnet olmadan iman eden herkesin babası olsun. Böylece Allah onları da doğru saysın. ");
INSERT INTO turobt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","İbrahim aynı zamanda sünnetlilerin de babasıdır. O sünnetliler ki, sünnetli olmakla kalmayıp, babamız İbrahimʼin sünnetsizken sahip olduğu iman yolundan giderler. ");
INSERT INTO turobt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Allah İbrahimʼe ve soyundan gelenlere dünyayı miras alacaklarına vaat etti. Ama Allah bu vaadi, Tevrat kanunlarına değil, imandan gelen doğruluğa dayanarak verdi. ");
INSERT INTO turobt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Çünkü insan Tevrat kanunlarını yerine getirmekle mirasçı olsaydı, imanın değeri kalmaz ve Allahʼın vaadi de geçersiz olurdu. ");
INSERT INTO turobt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tevrat kanunları Allahʼın ceza vermesine yol açar. Ama kanunun olmadığı yerde kanun çiğnenemez. ");
INSERT INTO turobt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Bunun için Allahʼın vaadi imana dayanır. Öyle ki, bu vaat Allahʼın lütfuyla İbrahimʼin bütün soyu için geçerli olsun. Yalnız İbrahimʼin Tevratʼa sahip olan soyu için değil, İbrahimʼin imanına sahip olan soyu için de geçerli olsun. Çünkü İbrahim, iman ettiği Allahʼın gözünde hepimizin babasıdır. ");
INSERT INTO turobt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Aynı yazıldığı gibi: “Allah dedi ki, ‘Ben seni birçok milletin babası yaptım.’ ” İbrahimʼin iman ettiği Allah, ölülere yaşam veren ve henüz var olmayan şeyleri var edendir. ");
INSERT INTO turobt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","İbrahim, umutsuz durumdayken umutla iman etti. Böylece birçok milletin babası oldu. Bu da Allahʼın şu sözüne dayanır: “Senin soyun böyle çok olacak.” ");
INSERT INTO turobt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","İbrahim, neredeyse yüz yaşındaydı. Ölüme yaklaşmış bedenini ve karısı Saraʼnın kısır rahmini aklına getirdiğinde imanı hiç zayıflamadı. ");
INSERT INTO turobt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Allahʼın vaadinden şüphelenmedi. İmansızlık etmedi. Tam tersine, imanıyla kuvvetlendi. Allahʼı yüceltti. ");
INSERT INTO turobt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Allahʼın, verdiği sözü yerine getirecek güçte olduğuna tamamen güvendi. ");
INSERT INTO turobt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Bu sebeple Allah İbrahimʼi iman ettiği için doğru saydı. ");
INSERT INTO turobt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","“Doğru saydı” sözü sadece İbrahim için yazılmadı. ");
INSERT INTO turobt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Bu söz bizim için de geçerlidir. Rabbimiz İsaʼyı ölümden dirilten Allahʼa iman ettiğimiz için, Allah bizi de doğru sayacak. ");
INSERT INTO turobt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","İsa suçlarımız için ölüme teslim edildi ve doğru sayılmamız için ölümden diriltildi. ");
INSERT INTO turobt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Böylece, madem imanla doğru sayıldık, Rabbimiz İsa Mesih aracılığıyla Allahʼla barışmış oluyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","İman ederek İsa Mesih sayesinde Allahʼın lütfuna kavuşma hakkına sahip olduk. Bu lütfa dayanarak ayaktayız ve Allahʼın yüceliğine erişmek umuduyla seviniyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Üstelik sadece bu umutla değil, çektiğimiz sıkıntılarla bile seviniyoruz. Çünkü biliriz ki, sıkıntı bize dayanma gücü verir. ");
INSERT INTO turobt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Dayanma gücü de bize değeri kanıtlanmış karakter kazandırır. Kanıtlanmış karaktere sahip olmak bizi umutla doldurur. ");
INSERT INTO turobt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Bu umut da bizi utandırmaz, çünkü Allah bize verdiği Kutsal Ruh aracılığıyla sevgisini yüreklerimize dökmüştür. ");
INSERT INTO turobt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Yani, biz daha çaresizken, Mesih bizim gibi Allahʼı saymayan kişiler için tam zamanında öldü. ");
INSERT INTO turobt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Dürüst bir insan için ölecek birisi zor bulunur. Yine de belki iyi bir insan için ölmeyi göze alan birisi bulunabilir. ");
INSERT INTO turobt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ama Allah bize kendi sevgisini şununla kanıtlıyor: biz daha günahkârken, Mesih bizim için öldü. ");
INSERT INTO turobt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","İsaʼnın kanı sayesinde Allah şimdi bizi doğru insanlar olarak kabul ediyor. Bu sebeple İsa aracılığıyla Allahʼın öfkesinden kurtulacağımız çok daha kesindir. ");
INSERT INTO turobt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Çünkü biz daha Allahʼa düşmanken, Oʼnun Oğluʼnun ölümü sayesinde kendisiyle barıştık. Barıştıktan sonra, Oğluʼnun yaşamı sayesinde kurtulacağımız çok daha kesindir. ");
INSERT INTO turobt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Üstelik Rabbimiz İsa Mesih aracılığıyla Allahʼa kavuştuğumuz için de seviniyoruz. Mesih sayesinde şimdi Allahʼla barıştık. ");
INSERT INTO turobt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","İşte böyle, günah tek bir adam yüzünden, ölüm de günah yüzünden dünyaya girdi. Böylece ölüm bütün insanlara yayıldı. Çünkü hepsi günah işledi. ");
INSERT INTO turobt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Tevrat kanunları verilmeden önce bile dünyada günah vardı. Ama kanunun olmadığı yerde günahların hesabı tutulmaz. ");
INSERT INTO turobt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ne var ki, ölüm Ademʼden Musaʼnın zamanına kadar herkesin üzerinde hüküm sürdü. Ademʼin suçuna benzer bir günah işlememiş olanlar bile ölümün hükmü altındaydı. Adem, bir bakıma, kendisinden sonra gelecek olan Mesihʼin örneğidir. ");
INSERT INTO turobt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ancak Allahʼın bağışladığı lütuf Ademʼin yoldan sapmasına benzemez. Eğer bir adamın yoldan sapması yüzünden birçok insan öldüyse, Allahʼın lütfu ve bir adamın, yani İsa Mesihʼin lütfuyla verilen bağış, birçok insana daha büyük bollukla ulaştı. ");
INSERT INTO turobt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Allahʼın bağışı o tek adamın işlediği günahın sonucuna benzemez. Çünkü o tek adamın günahı onun yargılanmasına ve suçlu çıkarılmasına sebep oldu. İnsanlar birçok suç işlediler. Fakat Allah, bağışladığı lütufla onları doğru saydı. ");
INSERT INTO turobt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Tek bir adamın yoldan sapması yüzünden o tek adamın aracılığıyla ölüm hüküm sürdü. Ama bundan çok daha kesin bir şey var: Allahʼın bol lütfunu ve bağışını alan insanlar Oʼnun tarafından doğru sayıldılar. Bu insanlar, tek adam, yani İsa Mesih sayesinde kavuştukları yaşamda hüküm sürecekler. ");
INSERT INTO turobt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Demek ki tek bir günah sonucunda tüm insanlık suçlu çıkarıldı. Aynı bunun gibi tek bir doğru davranış sayesinde tüm insanlığın doğru sayılarak yaşam bulması mümkün oldu. ");
INSERT INTO turobt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Bir tek adamın itaatsizliği yüzünden birçok kişi günahkâr kılındı. Aynı bunun gibi bir tek adamın itaati sayesinde birçok kişi doğru kılınacak. ");
INSERT INTO turobt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tevrat kanunları suç çoğalsın diye getirildi. Fakat günahın çoğaldığı yerde Allahʼın lütfu daha da çoğaldı. ");
INSERT INTO turobt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Böylece günah nasıl herkesin üzerinde hüküm sürdü ve onlara ölüm getirdiyse, şimdi Allahʼın lütfu da doğruluk aracılığıyla hüküm sürüyor. Bunun sonucu Rabbimiz İsa Mesih sayesinde sonsuz yaşamdır. ");
INSERT INTO turobt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","O halde ne diyelim? Allah bizlere daha fazla lütuf göstersin diye günah işlemeye devam mı edelim? ");
INSERT INTO turobt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Olmaz öyle şey! Günaha öldük. Artık nasıl günah içinde yaşayabiliriz? ");
INSERT INTO turobt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Hepimiz vaftiz olunca Mesih İsaʼyla bir olduk; vaftiz olmakla Oʼnun ölümüne ortak olduk. Yoksa bunu bilmiyor musunuz? ");
INSERT INTO turobt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Biz vaftiz edilirken Mesih İsaʼyla birlikte ölüp gömüldük. Mesihʼin Baba Allahʼın görkemli gücüyle ölümden dirildiği gibi biz de yepyeni bir yaşam sürelim. ");
INSERT INTO turobt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","İsa Mesihʼin ölümüne benzer bir ölümde Oʼnunla birleştik. Buna göre Oʼnun dirilişinde de Oʼnunla birleşeceğiz. ");
INSERT INTO turobt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Bildiğimiz gibi eski kişiliğimiz Mesihʼle birlikte çarmıha gerildi. Öyle ki, günahlı tabiatımız gücünü kaybetsin ve artık günaha esir olmayalım. ");
INSERT INTO turobt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Çünkü ölmüş kişi günahın hükmünden kurtulmuştur. ");
INSERT INTO turobt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Mesihʼle birlikte öldüğümüze göre Oʼnunla birlikte de yaşayacağımıza inanıyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Biliyoruz ki, Mesih ölümden dirildi ve bir daha ölmeyecek. Ölümün artık Oʼnun üzerinde hükmü yok. ");
INSERT INTO turobt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Çünkü Mesih ölümüyle günah karşısında ilk ve son defa öldü. Şimdiyse hayatını Allah için yaşıyor. ");
INSERT INTO turobt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Siz de bunun gibi, kendinizi günah karşısında ölü ve Mesih İsaʼya bağlı olarak Allah karşısında diri sayın. ");
INSERT INTO turobt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Buna göre günahın ölümlü bedeninizde hüküm sürmesine izin vermeyin, bedenin heveslerine uymayın. ");
INSERT INTO turobt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Bedeninizin hiçbir yerini kötülük yapan alet olarak günaha teslim etmeyin. Tam tersine, ölümden yaşama geçmiş olanlar olarak, kendinizi Allahʼa teslim edin. Bedeninizin her yerini doğru olanı yapan alet olarak Allahʼa adayın. ");
INSERT INTO turobt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Günah efendiniz olmasın. Çünkü herhangi bir kanuna değil, Allahʼın lütfuna bağlısınız. ");
INSERT INTO turobt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Bunun için ne diyelim? Herhangi bir kanuna değil, Allahʼın lütfuna bağlı olduğumuza göre günah mı işleyelim? Olmaz öyle şey! ");
INSERT INTO turobt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Bilmiyor musunuz ki, kime kendinizi köle olarak teslim edip itaat ederseniz, onun kölesi olursunuz? Ya günahın ya da itaatin kölesi olursunuz. Günah sizi ölüme, itaat ise doğruluğa götürür. ");
INSERT INTO turobt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Eskiden günahın kölesiydiniz. Ama Allahʼa şükürler olsun, size emanet edilen öğretilerin tamamına yürekten bağlandınız. ");
INSERT INTO turobt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Günahtan özgür kılınıp doğruluğun kölesi oldunuz. ");
INSERT INTO turobt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","İnsan tabiatınız zayıf olduğu için günlük yaşamdan örnek veriyorum. Eskiden bedeninizi köle olarak rezil davranışlara ve kötülük yapmak için kötülüğe teslim ederdiniz. Tıpkı bunun gibi, şimdi bedeninizi doğruluğa köle olarak teslim edin ki, Allahʼa adanmış insanlar olasınız. ");
INSERT INTO turobt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Eskiden günahın kölesiyken doğru olanı yapmaya mecbur değildiniz. ");
INSERT INTO turobt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Şimdi utanç duyduğunuz o şeyleri yapmakla ne elde ettiniz? Onların sonucu ölümdür. ");
INSERT INTO turobt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ama şimdi günaha köle olmaktan kurtuldunuz ve Allahʼa köle oldunuz. Bundan kazancınız Allahʼa adanmışlık ve sonucu sonsuz yaşamdır. ");
INSERT INTO turobt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Çünkü günahın bedeli ölümdür, ama Allahʼın bağışı Rabbimiz Mesih İsa sayesinde sonsuz yaşamdır. ");
INSERT INTO turobt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Kardeşler, kanunu bilen kişilere söylüyorum. Bilmiyor musunuz ki, insan ancak yaşadığı sürece kanunun hükmü altındadır? ");
INSERT INTO turobt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Meselâ, evli bir kadın, kocasının yaşadığı sürece kanunla ona bağlıdır. Ama kocası ölünce onu kocasına bağlayan kanundan kurtulur. ");
INSERT INTO turobt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Buna göre kadın, kocası yaşarken başka erkekle giderse zina işlemiş sayılır. Ama kocası ölürse, kadın o kanundan özgür olur. Başka bir erkeğe varırsa, zina işlemiş sayılmaz. ");
INSERT INTO turobt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Aynı bunun gibi, kardeşlerim, siz de çarmıhta ölen Mesihʼin bedeni aracılığıyla Tevrat kanunları karşısında öldünüz. Artık başka birine, yani Allahʼın hizmetinde verimli olmamız için ölümden dirilen Mesihʼe aitsiniz. ");
INSERT INTO turobt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Eskiden biz insan tabiatımıza göre yaşarken Tevrat kanunlarının uyandırdığı günah istekleri bedenimizde işliyordu. Bu istekler ölümle sonuçlanır. ");
INSERT INTO turobt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Eskiden Tevrat kanunlarının esiriydik. Fakat ölmüş sayıldığımız için artık Tevrat kanunlarına esir olmaktan kurtulduk. Bu sayede yazıya dayanan eski yolda değil, Kutsal Ruhʼa dayanan yeni yolda Allahʼa hizmet ederiz. ");
INSERT INTO turobt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Öyleyse ne diyelim? Tevrat kanunları günah mı oldu? Olmaz öyle şey! Fakat Tevrat kanunları olmasaydı, günahın ne olduğunu bilmezdim. Çünkü Tevrat “Açgözlü olmayın!” dememiş olsaydı, açgözlülüğün günah olduğunu bilmezdim. ");
INSERT INTO turobt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ama günah bu buyruktan fırsat bulup, benim içimde her türlü açgözlülüğü uyandırdı. Kanun olmasa, günah cansızdır. ");
INSERT INTO turobt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","10","Bir zamanlar, Tevrat kanunlarından habersizken diriydim. Fakat Tevratʼın buyruklarını öğrendiğim zaman içimdeki günah canlandı ve ben öldüm. Böylece buyruğun yaşam vereceğine ölüm getirdiğini anladım. ");
INSERT INTO turobt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Çünkü günah buyruktan fırsat bulup beni aldattı ve buyruk aracılığıyla beni öldürdü. ");
INSERT INTO turobt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Demek ki, Tevrat gerçekten kutsaldır. Buyrukları da kutsal, doğru ve iyidir. ");
INSERT INTO turobt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Öyleyse iyi olan şey bana ölüm mü getirdi? Olmaz öyle şey! Ama günah, günah olduğu açıkça görünsün diye, iyi olan şeyi kullanıp bana ölüm getirdi. Öyle ki, buyruğun aracılığıyla günahın ne kadar günahlı olduğu anlaşılsın. ");
INSERT INTO turobt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tevrat kanunlarının ruhsal olduğunu biliyoruz. Ama ben beden sahibi bir insanım. Günaha satılmış bir esirim. ");
INSERT INTO turobt_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ne yaptığımı bilmiyorum. Çünkü yapmak istediğim şeyleri yapmıyorum, tersine, nefret ettiğim şeyleri yapıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Yapmak istemediğim şeyleri yapsam, Tevrat kanunlarının iyi olduğunu kabul etmiş olurum. ");
INSERT INTO turobt_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Artık bu şeyleri yapan ben değilim, benim içimde yaşayan günahtır. ");
INSERT INTO turobt_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Çünkü biliyorum ki, bende, yani insan tabiatımda, iyi bir şey bulunmaz. Bende iyi olanı yapma isteği var, ama onu yerine getirme gücü yok. ");
INSERT INTO turobt_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","İstediğim iyi şeyi yapmıyorum, tersine, istemediğim kötü şeyi yapıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ama eğer istemediğim şeyi yapıyorsam, artık bunu yerine getiren ben değilim, içimde yaşayan günahtır. ");
INSERT INTO turobt_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Bundan şu kanunu çıkarıyorum: Ben iyi olanı yapmak isterken, yanımda kötülük hep hazır duruyor. ");
INSERT INTO turobt_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Çünkü yüreğimin derinliğinde Allahʼın verdiği Tevrat kanunlarından zevk alıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ama bedenimde başka bir kanun görüyorum. O da aklımın doğru bulduğu kanunla savaşıyor ve beni bedenimde var olan günah kanununa esir ediyor. ");
INSERT INTO turobt_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ben ne kadar zavallı bir insanım! Ölüme götüren bu bedenden beni kim kurtaracak? ");
INSERT INTO turobt_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Rabbimiz İsa Mesih aracılığıyla beni kurtaran Allahʼa şükrolsun! Demek ki, ben aklımla Allahʼın kanununa, ama insan tabiatımla günah kanununa hizmet ediyorum. ");
INSERT INTO turobt_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Buna göre Mesih İsaʼya ait olanlar artık suçlu çıkarılmaz. ");
INSERT INTO turobt_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Çünkü Mesih İsa sayesinde yaşam veren Ruhʼun kanunu beni günah ve ölüm kanunundan özgür etti. ");
INSERT INTO turobt_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Çünkü insan tabiatımız yüzünden Tevrat kanunları güçsüzdü. Fakat Tevratʼın yapamadığını Allah yaptı. Kendi Oğluʼnu günahlı insan tabiatımıza benzeyen bir tabiatla yeryüzüne gönderdi. Oʼnu günahımız için kurban ederek insan tabiatımızdaki günahı yargılayıp cezalandırdı. ");
INSERT INTO turobt_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Öyle ki, Tevratʼın gerektirdiği doğruluk insan tabiatımıza göre değil, Kutsal Ruhʼa göre yaşayan bizlerde yerine gelsin. ");
INSERT INTO turobt_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Çünkü insan tabiatına uyanlar ancak insan tabiatına ait şeyler düşünürler. Ama Kutsal Ruhʼa uyanlar, Ruhʼa ait şeyler düşünürler. ");
INSERT INTO turobt_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","İnsan tabiatına uyan düşünce ölüm getirir, fakat Ruhʼa uyan düşünce yaşam ve esenlik verir. ");
INSERT INTO turobt_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Çünkü insan tabiatına uyan düşünce Allahʼa düşmandır. Allahʼın kanunlarına boyun eğmez, eğemez de. ");
INSERT INTO turobt_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","İnsan tabiatına uyanlar Allahʼı hoşnut edemez. ");
INSERT INTO turobt_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Sizler ise insan tabiatınıza bağlı değilsiniz. Eğer Allahʼın Ruhu gerçekten içinizde yaşıyorsa, Ruhʼa bağlısınız. İçinde Mesihʼin Ruhu olmayan kişiyse Mesihʼe ait değildir. ");
INSERT INTO turobt_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Eğer Mesih içinizdeyse, bedeniniz günah yüzünden ölü, ama ruhunuz, doğru sayıldığınız için diridir. ");
INSERT INTO turobt_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Allah İsaʼyı ölümden diriltti. Oʼnun Ruhu içinizde yaşıyor. Buna göre Mesihʼi ölümden dirilten Allah, sizin ölümlü bedenlerinize de yaşam verecek. Bunu içinizde yaşayan kendi Ruhu aracılığıyla yapacak. ");
INSERT INTO turobt_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Öyleyse kardeşler, borçluyuz. Fakat insan tabiatımıza uyarak yaşamak için insan tabiatımıza borçlu değiliz. ");
INSERT INTO turobt_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Çünkü insan tabiatınıza göre yaşarsanız, öleceksiniz. Ama eğer Ruh aracılığıyla bedeninizin yaptığı kötülükleri öldürürseniz, yaşayacaksınız. ");
INSERT INTO turobt_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Allahʼın Ruhu tarafından güdülenler Allahʼın oğullarıdır. ");
INSERT INTO turobt_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Çünkü sizi tekrar köle yapan, korkuya sürükleyen bir ruh almadınız. Ama sizi oğlu yapan Allahʼın Ruhuʼnu aldınız. Biz de o Ruhʼla Allahʼa, “Abba”, yani Baba diye yalvarıyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruhʼun kendisi, bizim ruhumuzla birlikte Allahʼın evlatları olduğumuza şahitlik ediyor. ");
INSERT INTO turobt_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Evlatlar olduğumuza göre, aynı zamanda mirasçıyız. Allahʼın vereceği bereketlerin mirasçısıyız. Mesihʼe vermiş olduğu bereketlerin ortak mirasçısıyız. Yeter ki Mesihʼin acılarını paylaşalım, o zaman Oʼnun görkeminden de pay alacağız. ");
INSERT INTO turobt_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Eminim ki, bu hayatta çektiğimiz acılar bize gösterilecek görkemle kıyaslanamaz. ");
INSERT INTO turobt_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Zaten yaratılan her şey Allahʼın oğullarının ortaya çıkarılmasını hasretle bekliyor. ");
INSERT INTO turobt_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Yaratılan her şey amaçsızlığa teslim edildi. Bu da kendi isteğiyle değil, ama onu amaçsızlığa teslim eden Allahʼın isteğiyle oldu. Ama yine de umut var. ");
INSERT INTO turobt_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Çünkü yaratılan her şey bozulmaya esir olmaktan kurtarılıp Allahʼın evlatlarının görkemli özgürlüğüne kavuşacak. ");
INSERT INTO turobt_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Biliyoruz ki, yaratılan her şey doğum yapan kadın gibi hâlâ inleyip sancı çekiyor. ");
INSERT INTO turobt_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Üstelik Kutsal Ruhʼun ilk ürününe kavuşmuş olan bizler de için için inliyoruz, çünkü Allah tarafından evlatlığa alınmayı, yani bedenlerimizin kurtuluşa kavuşmasını hasretle bekliyoruz. ");
INSERT INTO turobt_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Çünkü bu umutla kurtulduk. Ama gözle görülen umut aslında umut değildir. İnsan gördüğü şeyi nasıl umut edebilir ki? ");
INSERT INTO turobt_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ama görmediğimiz şeye umut bağlarsak, onu sabırla bekleyebiliriz. ");
INSERT INTO turobt_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Tıpkı bunun gibi, Kutsal Ruh, biz çaresiz durumdayken bize yardım ediyor. Çünkü ne için dua etmemiz gerektiğini bilmiyoruz. Ama Ruhʼun kendisi sözle anlatılamaz bir şekilde inleyerek bizim için aracılık eder. ");
INSERT INTO turobt_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Yüreklerimizi inceleyen Allah, Ruhʼun ne düşündüğünü bilir. Çünkü Ruh Allahʼın isteğine göre kutsal halkı için aracılık eder. ");
INSERT INTO turobt_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Biliyoruz ki, Ruh her durumda iyi olan için Allahʼı sevenlerle iş birliği yapar. Onlar Allahʼın amacına uymaya çağrılmışlardır. ");
INSERT INTO turobt_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Çünkü Allah önceden bildiği kişileri Oğluʼna benzer kılmak için seçti. Öyle ki, Oğlu birçok kardeş arasında ilk doğan olsun. ");
INSERT INTO turobt_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Allah seçtiği kişileri kendisine gelmeye çağırdı; çağırdığı kişileri doğru saydı; doğru saydığı kişileri de yüceltti. ");
INSERT INTO turobt_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Peki, bu şeyler için ne diyelim? Allah bizden yanaysa, kim bize karşı olabilir? ");
INSERT INTO turobt_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Allah kendi Oğluʼnu bile esirgemedi, Oʼnu hepimiz için feda etti. Öyleyse Oğluʼyla birlikte bize her şeyi karşılıksız vermeyecek mi? ");
INSERT INTO turobt_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Allahʼın seçtiği kişileri kim suçlayabilir? Onları doğru sayan Allahʼtır. ");
INSERT INTO turobt_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kim onları suçlu çıkarır? Mesih İsa öldü, üstelik ölümden diriltildi. O şimdi Allahʼın sağında duruyor ve bizim için aracılık ediyor. ");
INSERT INTO turobt_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Bizi Mesihʼin sevgisinden ne ayırabilir: sıkıntı mı, yoksulluk mu, eziyet mi, açlık mı, elbise yetersizliği mi, tehlike mi, kılıç mı? ");
INSERT INTO turobt_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Aynı yazıldığı gibi: “Senin için bütün gün öldürülüyoruz, kasaplık koyun sayılıyoruz.” ");
INSERT INTO turobt_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ne var ki, bütün bu durumlarda bizi seven Mesih sayesinde tam bir zafer kazanıyoruz! ");
INSERT INTO turobt_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Eminim ki, ne ölüm ne de yaşam, ne melekler, ne de başka güçler ve kuvvetler, ne şimdi var olan şeyler ne de gelecekteki şeyler, ");
INSERT INTO turobt_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ne yıldızların en yüksek ve en aşağı noktası ne de yaratılmış başka bir şey bizi Rabbimiz Mesih İsaʼda olan Allah sevgisinden ayırabilir. ");
INSERT INTO turobt_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mesihʼe ait biri olarak size gerçeği söylüyorum, yalan söylemiyorum. Vicdanım da Kutsal Ruh sayesinde bunu doğruluyor. ");
INSERT INTO turobt_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Yüreğimde büyük bir sıkıntı, hiç bitmeyen bir acı var. ");
INSERT INTO turobt_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Kardeşlerimin, yani benimle aynı kandan olan soydaşlarımın yerine, ben kendim Allahʼın lanetine uğrayıp Mesihʼten ayrı kalmaya razı olurdum. ");
INSERT INTO turobt_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Onlar İsrail halkıdır. Allah onları evlat edindi, onlara görkemini gösterdi ve onlarla antlaşmalar yaptı. Tevrat kanunlarını, tapınma düzenini ve vaatlerini onlara verdi. ");
INSERT INTO turobt_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Büyük atalar onlarındır. Mesih de insan olarak onlardandır. O her şeyin üzerinde hüküm süren, sonsuzlara kadar övgüye layık olan Allahʼtır. Amin. ");
INSERT INTO turobt_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Bu, Allahʼın İsrailʼe verdiği sözün boşa çıktığı anlamına gelmez. Çünkü İsrail soyundan gelen herkes Allahʼın halkından değildir. ");
INSERT INTO turobt_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","İbrahimʼin soyundan gelen herkes İbrahimʼin evladı değildir. Allah ona, “Senin soyun İshakʼla devam edecek” dedi. ");
INSERT INTO turobt_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yani, sadece bedence İbrahimʼin soyundan olmak insanı Allahʼın evladı yapmaz. Allahʼın evladı sayılanlar, ancak Allahʼın vaadine göre doğan evlatlardır. ");
INSERT INTO turobt_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Çünkü Allahʼın verdiği vaat şuydu: “Gelecek yıl bu zamanda geleceğim ve Saraʼnın bir oğlu olacak.” ");
INSERT INTO turobt_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Sadece bu değil, Rebeka, atamız İshakʼtan ikizlere gebe kalmıştı. ");
INSERT INTO turobt_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","İkizler de henüz doğmamış, iyi kötü hiçbir şey yapmamışlardı. O zaman Allah Rebekaʼya şöyle dedi: “Büyük oğlun küçüğüne hizmet edecek.” Allah bunu seçim yapmaktaki amacı devam etsin diye söyledi. Buna göre Allahʼın çağrısı, insanın yaptığı hiçbir şeye dayanmaz, ancak Allahʼın seçme hakkına dayanır. ");
INSERT INTO turobt_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Tıpkı yazıldığı gibi: “Yakubʼu sevdim, ama Esavʼı reddettim.” ");
INSERT INTO turobt_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","O vakit ne diyelim? Allah haksız mı? Olmaz öyle şey! ");
INSERT INTO turobt_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Allah Musaʼya şöyle dedi: “Kime merhamet edersem, ona merhamet edeceğim; ve kime acırsam, ona acıyacağım.” ");
INSERT INTO turobt_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Demek ki bu, insanın isteğine ya da çabasına değil, Allahʼın merhametine dayanır. ");
INSERT INTO turobt_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Allah Kutsal Yazıʼda Firavunʼa şöyle der: “Gücümü yaşamında göstermek için seni ortaya çıkardım. Böylece şanım bütün dünyaya yayılsın.” ");
INSERT INTO turobt_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Demek ki, Allah istediği kişiye merhamet eder, istediği kişiyi de inatçı yapar. ");
INSERT INTO turobt_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","O zaman bana diyeceksin ki, “Madem öyle, nasıl oluyor da Allah insanda hâlâ suç buluyor. Çünkü kim Oʼnun istediğine karşı durmuştur?” ");
INSERT INTO turobt_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ne var ki, ey insan, sen kim oluyorsun da Allahʼa karşılık veriyorsun? Kendisine biçim verilen, biçim verene, “Beni niçin böyle yaptın?” der mi? ");
INSERT INTO turobt_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ya da çömlekçinin kullandığı kil üzerinde yetkisi yok mu? Aynı kilden şerefli iş için bir kap, ve sıradan iş için başka bir kap yapamaz mı? ");
INSERT INTO turobt_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Allah da öfkesini göstermek ve gücünü bildirmek istediği zaman öfkesini hak eden ve mahvedilmeye hazırlanmış olan insanlara büyük sabırla katlandıysa, ne diyelim? ");
INSERT INTO turobt_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Bunu da merhamet edeceği insanlara sınırsız yüceliğini bildirmek için yaptıysa, ne diyelim? Bu insanları yüceliğine kavuşturmak için hazırlamıştı. ");
INSERT INTO turobt_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Biz de bu insanların arasındayız. Allah bizleri sadece Yahudilerden değil, diğer milletlerden de çağırdı. ");
INSERT INTO turobt_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Allah Peygamber Hoşeyaʼnın kitabında şöyle der: “Halkım olmayana ‘Halkım’ diyeceğim, sevmediğime ‘sevgili’ diyeceğim.” ");
INSERT INTO turobt_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","“ ‘Halkım değilsiniz’ denilen yerde, onlara ‘Diri olan Allahʼın oğulları’ denecek.” ");
INSERT INTO turobt_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Peygamber Yeşaya da İsrail halkı hakkında sesini yükseltip şöyle der: “İsrailoğullarının sayısı deniz kenarındaki kum kadar çok olsa bile, onların ancak bir kalıntısı kurtulacak. ");
INSERT INTO turobt_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Çünkü Rab yeryüzünü yargılayıp işini çabucak bitirecek.” ");
INSERT INTO turobt_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Yeşayaʼnın önceden bildirdiği gibi: “Eğer Kudretli Rab soyumuzu sürdürecek bir avuç insanı sağ bırakmasaydı, Sodom gibi olurduk, Gomoraʼya benzerdik.” ");
INSERT INTO turobt_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Şimdi buna ne diyelim? Yahudi olmayanlar Allahʼın doğruluğuna kavuşmaya çabalamıyorlardı, ama doğruluğa, yani imandan gelen doğruluğa kavuştular. ");
INSERT INTO turobt_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","İsrail halkı ise Tevrat kanunlarının getirdiği doğruluğa kavuşmaya çabaladı, ama bunu başaramadı. ");
INSERT INTO turobt_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Neden? Çünkü bunu imanla değil, kendi yaptıklarına güvenerek başarmaya çabaladılar. Köstekleme taşına takılıp kösteklendiler. ");
INSERT INTO turobt_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Aynı yazıldığı gibi: “İşte, Siyonʼa bir köstekleme taşı, bir tökezleme kayası koyuyorum. Oʼna iman edenler hayal kırıklığına uğramayacaklar.” ");
INSERT INTO turobt_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Kardeşler, İsrail halkının kurtuluşunu yürekten arzuluyorum ve bunun için Allahʼa dua ediyorum. ");
INSERT INTO turobt_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Onların Allahʼa gayretle hizmet ettiklerine şahidim. Fakat bu, bilgisiz bir gayrettir. ");
INSERT INTO turobt_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Onlar Allahʼın insanı nasıl doğru saydığını anlamıyorlar. Kendi çabalarıyla doğru sayılmaya çalışıyorlar. Bu yüzden kendilerini Allahʼın doğruluğuna teslim etmediler. ");
INSERT INTO turobt_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Oysa Mesih Tevratʼın sonudur. Böylece Oʼna iman eden herkes Allahʼın gözünde doğru sayılır. ");
INSERT INTO turobt_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Aslında Musa Tevrat kanunlarından gelen doğruluk hakkında şunları yazar: “Bunları yerine getirenler hayat bulacak.” ");
INSERT INTO turobt_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","7","İmana dayanan doğruluk ise şöyle diyor: “Kendi kendine, ‘Allahʼın sözünü, yani Mesihʼi, yeryüzüne indirmek için göğe kim çıkacak?’ diye sorma. ‘Dipsiz derinliklere, yani Mesihʼi ölüler arasından çıkarmaya kim inecek?’ diye de sorma.” ");
INSERT INTO turobt_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ama ne diyor? “Allahʼın sözü sana yakın, dudaklarında ve yüreğinde.” O söz iman hakkında vaaz ettiğimiz haberdir. ");
INSERT INTO turobt_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Eğer ağzınla açıkça “İsa Rabʼdir” dersen ve Allahʼın Oʼnu ölümden dirilttiğine yürekten iman edersen kurtulacaksın. ");
INSERT INTO turobt_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Çünkü insan yürekle iman edince doğruluğa kavuşur ve iman ettiğini ağzıyla açıkça söyleyince kurtuluş bulur. ");
INSERT INTO turobt_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Kutsal Yazı da şöyle der: “Oʼna iman eden hiç kimse hayal kırıklığına uğramayacak.” ");
INSERT INTO turobt_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Yahudilerle Yahudi olmayanlar arasında hiçbir ayrım yok. Aynı Rab bütün insanların Efendisiʼdir. Oʼnu yardıma çağıran herkese cömertçe lütuf gösterir. ");
INSERT INTO turobt_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Çünkü, “Rabbi adıyla yardıma çağıran herkes kurtulacak.” ");
INSERT INTO turobt_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Peki, eğer Rabbe iman etmemişlerse Oʼnu nasıl yardıma çağıracaklar? Eğer Oʼndan haber almamışlarsa Oʼna nasıl iman edecekler? Eğer vaaz eden yoksa Oʼndan nasıl haber alacaklar? ");
INSERT INTO turobt_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Eğer Allah vaaz edenleri göndermezse nasıl vaaz edecekler? Aynı yazıldığı gibi: “İyi haber müjdeleyenlerin ayakları ne güzeldir!” ");
INSERT INTO turobt_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ama onların hepsi Müjdeʼye itaat etmedi. Peygamber Yeşayaʼnın dediği gibi: “Ya Rab, verdiğimiz habere kim inandı?” ");
INSERT INTO turobt_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Demek ki, iman etmek haberi duymakla, haberi duymak da Mesihʼin sözünün yayılmasıyla olur. ");
INSERT INTO turobt_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ama şunu soruyorum: “İsrailoğulları haberi duymadılar mı?” Elbette duydular. “Habercilerin sesi bütün yeryüzüne yayıldı, sözleri dünyanın en uzak köşelerine ulaştı.” ");
INSERT INTO turobt_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Yine soruyorum: “Acaba İsrailoğulları haberi anlamadılar mı?” En başta Allah Musa aracılığıyla onlara şöyle der: “Ben sizi halkım olmayan bir halkla kıskandıracağım, cahil bir halkla kızdıracağım.” ");
INSERT INTO turobt_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Sonra da Yeşaya Allahʼın sözlerini cesaretle bildirir: “Beni aramayanlar tarafından bulundum. Sormayanlara kendimi gösterdim.” ");
INSERT INTO turobt_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Fakat Allahʼın İsrail halkı hakkında dediği şudur: “İtaatsiz ve dik kafalı bir halka bütün gün ellerimi uzattım.” ");
INSERT INTO turobt_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Öyleyse soruyorum: “Allah kendi halkını mı reddetti?” Olmaz öyle şey! Çünkü ben de İsrailoğullarındanım. İbrahimʼin soyundan, Benyamin oymağındanım. ");
INSERT INTO turobt_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Allah ezelden beri halkı olarak bildiği insanları reddetmedi. Yoksa, Kutsal Yazılarʼın İlyas hakkındaki bölümde ne dediğini bilmiyor musunuz? İlyas İsrail halkı hakkında Allahʼa şöyle şikâyet eder: ");
INSERT INTO turobt_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Ya Rab! Senin peygamberlerini öldürdüler. Senin kurban yerlerini yıktılar. Yalnız ben kaldım. Beni de öldürmeye çalışıyorlar.” ");
INSERT INTO turobt_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Oysa Allahʼın İlyasʼa verdiği cevap nedir? “Baal putunun önünde diz çökmemiş yedi bin kişiyi kendime ayırdım.” ");
INSERT INTO turobt_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tıpkı bunun gibi şimdi de İsrail halkından Allahʼa sadık kalmış küçük bir topluluk var. Allah bu insanlara lütuf gösterip onları kendi halkı olarak seçmiştir. ");
INSERT INTO turobt_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Eğer bu insanlar Oʼnun lütfuyla seçilmişlerse, demek ki kendi yaptıkları sayesinde seçilmediler. Yaptıkları sayesinde seçilseydiler lütuf artık lütuf olmazdı. ");
INSERT INTO turobt_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Öyleyse ne diyelim? İsrail halkı aradığını bulamadı ama Allahʼın seçtiği insanlar buldular. Geri kalanlarsa duyarsız oldular. ");
INSERT INTO turobt_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kutsal Yazılarʼda yazıldığı gibi: “Allah onların zihinlerini uyuşturdu. Gözlerini kör, kulaklarını sağır etti. Bugün hâlâ öyledirler.” ");
INSERT INTO turobt_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Davud da şöyle diyor, “Sofraları onlara tuzak ve kapan, tökez ve ceza olsun. ");
INSERT INTO turobt_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Gözleri kararsın ki, görmesinler. Belleri hep bükük olsun.” ");
INSERT INTO turobt_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Öyleyse şunu soruyorum: “İsrailoğulları bir daha kalkmamak üzere mi tökezlenip düştüler?” Olmaz öyle şey! Onların doğru yoldan sapması sayesinde diğer milletlere kurtulma fırsatı verildi. Öyle ki, İsrailoğulları diğer milletlere imrenip gayrete gelsinler. ");
INSERT INTO turobt_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","İsrailoğullarının yoldan sapması dünyaya bereket, onların yetersizliği de milletlere bereket oldu. O zaman onların tamamlanması daha ne kadar büyük bereket olacak! ");
INSERT INTO turobt_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Şimdi siz Yahudi olmayanlara söylüyorum: Yahudi olmayanlara gönderilen bir elçi olarak bu yüce hizmetimden gurur duyuyorum. ");
INSERT INTO turobt_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Belki böylece soydaşlarımı imrendiririm ve bazılarını kurtarırım. ");
INSERT INTO turobt_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Allahʼın onları reddetmesi dünyanın Oʼnunla barışmasını sağladı. Öyleyse onları tekrar kabul etmesi ölümden yaşama geçmekten başka ne olabilir? ");
INSERT INTO turobt_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Eğer Allahʼa adanan hamurun ilk parçası kutsalsa, bütün hamur kutsaldır. Ağacın kökü kutsalsa dalları da kutsaldır. ");
INSERT INTO turobt_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ama zeytin ağacının bazı dalları kesildi, ve sen yabani bir zeytin dalı olarak onların yerine koyuldun. Sen o ağacının kökünden yükselen bereketli özüne ortak oldun. ");
INSERT INTO turobt_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Öyleyse kendini iyi ağaçtan kesilen dallardan üstün görme. Kendini üstün görürsen, unutma ki, sen ağacın kökünü beslemiyorsun, kök seni besliyor. ");
INSERT INTO turobt_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","O zaman şöyle diyeceksin: “Benim oraya eklenmem için o dallar kesildi.” ");
INSERT INTO turobt_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Doğru da, onlar imansızlıkları yüzünden kesildiler. Sense imanla yerinde duruyorsun. Gururlanma, Allahʼtan kork! ");
INSERT INTO turobt_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Çünkü eğer Allah asıl dallara acımadıysa, sana da acımaz. ");
INSERT INTO turobt_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Öyleyse Allahʼın iyiliğine ve sertliğine dikkat et! Allah günaha düşenlere sert, sana ise iyi davranır. Yeter ki, Oʼnun iyiliğine güvenmeye devam edesin. Yoksa Allah seni de ağaçtan kesip atacak. ");
INSERT INTO turobt_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","İsrailoğulları ise imansızlıkta devam etmezlerse, ağaca geri eklenecekler. Çünkü Allahʼın onları geri eklemeye gücü var. ");
INSERT INTO turobt_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Sen yabani zeytin ağacından kesilen dallar gibisin. Tabiata aykırı olarak iyi zeytin ağacına eklendin. İsrailoğulları ise iyi zeytin ağacından kesilen dallar gibidir. O halde tabiata göre kendi zeytin ağacına tekrar eklenmeleri çok daha kolaydır! ");
INSERT INTO turobt_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ey imanlı kardeşlerim, şu konudaki sırdan habersiz kalıp kendinizi çok akıllı görmenizi istemiyorum. Sır şudur: İsrailoğullarının bir kısmı inatçılığa kapıldı. Bu durum Yahudi olmayan imanlıların sayısı tamamlanıncaya kadar devam edecek. ");
INSERT INTO turobt_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Sonunda bütün İsrail halkı kurtulacak. Tıpkı Kutsal Yazılarʼda yazıldığı gibi: “Kurtarıcı Siyonʼdan gelecek, Yakubʼun soyundan allahsızlığı uzaklaştıracak. ");
INSERT INTO turobt_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Allah diyor ki, ‘Onların günahlarını sildiğim zaman, onlarla yapacağım antlaşma bu olacak.’ ” ");
INSERT INTO turobt_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Gerçi onlar Mesihʼin Müjdesini reddetmekle Allahʼa düşman oldular. Bu da siz Yahudi olmayanların hatırı için oldu. Fakat İsrailoğulları Allah tarafından seçilmiş olan atalarının hatırı için seviliyorlar. ");
INSERT INTO turobt_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Çünkü Allahʼın lütufları ve çağrısı geri alınamaz. ");
INSERT INTO turobt_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Yahudi olmayan sizler bir zamanlar Allahʼa itaat etmiyordunuz. Ama şimdi İsrailoğullarının itaatsizliği yüzünden Allahʼın merhametine kavuştunuz. ");
INSERT INTO turobt_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Bunun gibi, Yahudi halkı da şimdi Allahʼa itaatsiz oldu. Öyle ki, siz merhamete kavuştuğunuz için onlar da merhamete kavuşsunlar. ");
INSERT INTO turobt_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Çünkü Allah herkese merhamet göstermek için herkesi itaatsizliğe esir etti. ");
INSERT INTO turobt_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ah, Allahʼın hikmeti ve bilgisi ne kadar derin, ne kadar da zengin! Oʼnun kararlarına hiçbir akıl ermez, Oʼnun yöntemleri insan anlayışının ötesindedir. ");
INSERT INTO turobt_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Rabbin düşüncelerini kim bildi? Ya da Oʼna kim akıl verdi?” ");
INSERT INTO turobt_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Kim Allahʼa bir şey verdi de, geri ödenmesini istesin?” ");
INSERT INTO turobt_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Çünkü her şey Oʼndan, her şey Oʼnun aracılığıyla ve her şey Oʼnun içindir. Oʼna sonsuzlara kadar övgüler olsun! Amin. ");
INSERT INTO turobt_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Bu sebeple, kardeşler, Allahʼın merhameti adına size yalvarırım, bedenlerinizi Allahʼı hoşnut eden diri ve kutsal birer kurban olarak Oʼna teslim edin. Asıl ibadetiniz budur. ");
INSERT INTO turobt_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Bu dünyanın gidişine uymayın. Ama düşüncelerinizin yenilenmesiyle tamamen değiştirilmiş kişiler olun. Böylece Allahʼın ne istediğini, neyin iyi, hoş ve kusursuz olduğunu ayırt edebilirsiniz. ");
INSERT INTO turobt_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Allahʼın bana verdiği lütufla hepinize söylüyorum: Hiç kimse kendini gereğinden daha üstün görmesin. Ama Allahʼın verdiği iman ölçüsünde, akla yatkın görüşle düşünsün. ");
INSERT INTO turobt_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Bir bedenin çok parçaları vardır. Bütün bu parçalar da ayrı ayrı görevlere sahiptir. ");
INSERT INTO turobt_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Tıpkı bunun gibi, biz çok kişiyiz ama Mesihʼte tek bir bedeniz. Aynı bedenin parçaları olarak birbirimize bağlıyız. ");
INSERT INTO turobt_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Allah, lütfuyla bize değişik yetenekler verdi. Eğer peygamberlikse, imanımızın ölçüsünde peygamberlik edelim. ");
INSERT INTO turobt_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Hizmetse, hizmet edelim. Vaaz eden vaaz etsin. ");
INSERT INTO turobt_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Teşvik eden, teşvik etsin. Bağış veren cömertçe bağış versin. Liderlik eden canı gönülden liderlik etsin. Merhamet eden bunu güler yüzle yapsın. ");
INSERT INTO turobt_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Sevginiz ikiyüzlü olmasın. Kötülükten nefret edin, iyiliğe sarılın. ");
INSERT INTO turobt_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Birbirinize kardeş sevgisiyle bağlanın, şefkatli olun. Birbirinize saygı göstermekte yarışın. ");
INSERT INTO turobt_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","İman yolundaki gayretiniz azalmasın. Coşkun bir ruhla Rabbe hizmet edin. ");
INSERT INTO turobt_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Umudunuz sizi sevindirsin. Eziyete dayanın. Devamlı kendinizi duaya verin. ");
INSERT INTO turobt_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Allahʼın kutsal halkından muhtaç durumda olanlara yardım edin. Misafir kabul etmeye önem verin. ");
INSERT INTO turobt_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Size eziyet edenler için iyilik dileyin. İyilik dileyin, lanet etmeyin. ");
INSERT INTO turobt_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Sevinenlerle sevinin, ağlayanlarla ağlayın. ");
INSERT INTO turobt_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Birbirinizle aynı fikirde olun. Gururlu olmayın, ama önemli sayılmayan insanlarla arkadaşlık edin. Her şeyi anladığınızı sanmayın. ");
INSERT INTO turobt_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kimsenin kötülüğüne kötülükle karşılık vermeyin. Herkesin gözünde iyi olanı yapmaya dikkat edin! ");
INSERT INTO turobt_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Mümkünse, elinizden geldiği kadar bütün insanlarla barış içinde yaşayın. ");
INSERT INTO turobt_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Sevgili arkadaşlarım, kimseden öç almayın, ama ceza verme işini Allahʼa bırakın. Çünkü şöyle yazılmıştır: “Rab ‘Öç benimdir. Karşılık ben vereceğim’ diyor.” ");
INSERT INTO turobt_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Bunun yerine, “Düşmanınız acıkmışsa, ona yemek verin; susamışsa, ona su verin. Böylece onu utandırarak başına yanan korlar yığmış gibi olursunuz.” ");
INSERT INTO turobt_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kötülük sizi yenmesin, kötülüğü iyilikle yenin! ");
INSERT INTO turobt_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Herkes devlet yetkililerinin emrine uysun. Çünkü Allahʼtan olmayan yetki yoktur. Var olan yetkililer Allah tarafından görevlendirilmiştir. ");
INSERT INTO turobt_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Demek ki, kim yetkilinin emrine uymazsa, Allahʼın düzenine karşı çıkmış olur. Karşı çıkan da cezasını çeker. ");
INSERT INTO turobt_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Liderlerden asıl korkacak olanlar iyilik yapanlar değil, kötülük işleyenlerdir. Yetkiliden korkmadan yaşamak ister misin? O halde iyi olanı yap. O zaman onun övgüsünü kazanırsın. ");
INSERT INTO turobt_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Yetkili kişi senin iyiliğin için Allahʼa hizmet eder. Ama eğer kötülük yaparsan, kork! Yetkili kişi boşuna kılıç taşımaz. Çünkü o, Allahʼa hizmet eder, kötülük yapanı cezalandırmakla Allahʼın öfkeli yargısını yerine getirir. ");
INSERT INTO turobt_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Bunun için yetkililerin emrine uymalısınız. Bunu sadece öfkelerinden korktuğunuz için değil, vicdanınızı temiz tutmak için de yapmalısınız. ");
INSERT INTO turobt_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Vergiyi de aynı sebeple ödüyorsunuz. Çünkü yetkililer Allahʼın hizmetkârlarıdır ve kendilerini bu işe adarlar. ");
INSERT INTO turobt_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Her yetkiliye hakkını verin: vergi isteyene vergi, gümrük isteyene gümrük ödeyin. Korkmanız gerekenden korkun. Saygıyı hak edene saygı gösterin. ");
INSERT INTO turobt_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Birbirinizi sevmekten başka hiç kimseye borcunuz olmasın. Başkasını seven kişi, Tevrat kanunlarını yerine getirmiş olur. ");
INSERT INTO turobt_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Çünkü, “zina etmeyin”, “adam öldürmeyin”, “çalmayın”, “açgözlü olmayın” ve daha ne kadar buyruk varsa, hepsi şu sözle özetlenir: “Komşunuzu kendinizi sevdiğiniz gibi sevin.” ");
INSERT INTO turobt_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Seven kişi başkalarına kötülük yapmaz. Bu sebeple sevgi, Tevratʼın yerine getirilmesidir. ");
INSERT INTO turobt_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Bunu yaşadığınız zamanın farkında olarak yapın. Artık uykudan uyanmanızın vakti geldi. Çünkü şimdi kurtuluşumuz, iman ettiğimiz o ilk günden daha yakındır. ");
INSERT INTO turobt_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Gece ilerledi, gün yaklaştı. Bu sebeple, karanlığın işlerini üzerimizden atalım, ışığın silahlarını kuşanalım. ");
INSERT INTO turobt_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Gün ışığına uygun olarak düzgün bir hayat sürelim. Vaktimizi çılgın eğlenceler ve sarhoşluk, zina ve azgın seksüel davranışlar, kavga ve kıskançlıkla geçirmeyelim. ");
INSERT INTO turobt_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Bunun yerine Rab İsa Mesihʼi kuşanın ve insan tabiatınızın heveslerine uymayı düşünmeyin. ");
INSERT INTO turobt_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","İmanı zayıf olan kişiyi aranıza kabul edin. Ancak farklı fikirler üzerinde onlarla tartışmayın. ");
INSERT INTO turobt_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Biri her şeyi yiyebileceğine inanır. Ama imanı zayıf olan başka birisi sadece sebze yer. ");
INSERT INTO turobt_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Her şeyi yiyen yemeyeni hor görmesin. Sadece sebze yiyen de her şeyi yiyeni yargılamasın. Çünkü Allah onu kabul etmiştir. ");
INSERT INTO turobt_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Sen hangi hakla başkasının evindeki köleyi yargılıyorsun? Onu haklı ya da haksız çıkarmak efendisinin işidir. Elbette haklı çıkacak. Çünkü Rab onu haklı çıkarma gücüne sahiptir. ");
INSERT INTO turobt_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Bazıları bir günü öbür günlerden daha önemli sayar. Bazılarıysa bütün günlere aynı önem verir. Bu konularda herkes kendi fikrinden emin olsun. ");
INSERT INTO turobt_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Bir günü bayram olarak kutlayan kişi, o günü Rab için kutlar. Her şeyi yiyen kişi Rab için yer, çünkü Allahʼa şükreder. Bazı şeyleri yemeyen de bunu Rabbi memnun etmek için yapar ve Allahʼa şükreder. ");
INSERT INTO turobt_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Bizden hiç kimse ne kendisi için yaşar, ne de kendisi için ölür. ");
INSERT INTO turobt_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Eğer yaşarsak Rab için yaşarız. Eğer ölürsek Rab için ölürüz. Demek ki, yaşasak da ölsek de Rabbe aidiz. ");
INSERT INTO turobt_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Mesih hem ölülerin hem dirilerin Efendisi olsun diye öldü ve dirildi. ");
INSERT INTO turobt_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Öyleyse sen niçin imanlı kardeşini yargılıyorsun? Neden imanlı kardeşini hor görüyorsun? Hepimiz Allahʼın yargı yerinin önüne çıkacağız. ");
INSERT INTO turobt_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kutsal Yazılarʼda yazıldığı gibi: “Rab diyor ki, ‘Varlığım üzerine yemin ederim ki, her diz önümde çökecek, her dil Allah olduğumu açıkça söyleyecek’.” ");
INSERT INTO turobt_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Demek ki, her birimiz kendisi için Allahʼa hesap verecek. ");
INSERT INTO turobt_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Onun için artık birbirimizi yargılamayalım. Bunun yerine kardeşinizin imanına köstek olacak ya da onu yoldan çıkaracak bir şey yapmamaya karar verin. ");
INSERT INTO turobt_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Biliyorum ve Rab İsaʼya ait biri olarak eminim ki, hiçbir şey kendiliğinden murdar değildir. Ama kim bir şeyi murdar sayarsa, o şey onun için murdardır. ");
INSERT INTO turobt_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Eğer yediğin bir şeyle kardeşini üzüyorsan, artık sevgi yolunda yürümüyorsun. Yediğin şey kardeşinin mahvolmasına yol açmasın. Çünkü Mesih onun uğruna da öldü. ");
INSERT INTO turobt_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Böylece iyi saydığınız şeyi kimse kötülemesin. ");
INSERT INTO turobt_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Çünkü Allahʼın Krallığı yemek içmek meselesi değildir. Tersine, doğruluk, esenlik ve Kutsal Ruhʼtan gelen sevinçtir. ");
INSERT INTO turobt_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Bunlara önem vererek Mesihʼe hizmet eden kişi, Allahʼı hoşnut eder ve insanların saygısını kazanır. ");
INSERT INTO turobt_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Öyleyse, kendimizi esenlik getiren ve birbirimizin imanını kuvvetlendiren işlere verelim. ");
INSERT INTO turobt_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Yiyecek yüzünden Allahʼın işini bozmayın. Her yiyecek temiz sayılır. Ama yediği bir şey yüzünden başkasının imanına köstek olan kişi kötülük etmiş olur. ");
INSERT INTO turobt_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Et yememek, şarap içmemek ve imanlı kardeşinin imanına köstek olan herhangi bir şey yapmamak iyidir. ");
INSERT INTO turobt_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Bu konulardaki inancın Allahʼla kendi aranda kalsın. Doğru saydığı şeyler yüzünden kendini suçlu çıkarmayana ne mutlu! ");
INSERT INTO turobt_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ama yediği yemeği şüphe içinde yiyen kişi suçlu çıkar. Çünkü yaptığı iş imana dayanmaz. İmandan gelmeyen her şey günahtır. ");
INSERT INTO turobt_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Biz imanı güçlü olanlar, kendimizi memnun etmeyelim. Onun yerine güçsüzlerin zayıflıklarına katlanmaya mecburuz. ");
INSERT INTO turobt_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Her birimiz başkasının iyiliğini düşünerek onu memnun etmeye çalışsın. Böylece onu ruhça kuvvetlendirmiş olacağız. ");
INSERT INTO turobt_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Çünkü Mesih de kendini memnun etmeye çalışmadı. Ama Oʼnun hakkında yazıldığı gibi, “Ey Allah, seni aşağılayan kişilerin hakaretlerine ben uğradım.” ");
INSERT INTO turobt_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Çünkü önceden yazılan her şey bize ders vermek için yazıldı. Öyle ki, Kutsal Yazılarʼın verdiği sabır ve cesaretle umudumuz olsun. ");
INSERT INTO turobt_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Sabır ve cesaret kaynağı olan Allah, Mesih İsaʼnın istediği gibi hepinizi aynı düşüncede birleştirsin. ");
INSERT INTO turobt_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Öyle ki hep birlikte, bir ağızdan Rabbimiz İsa Mesihʼin Babası Allahı övesiniz. ");
INSERT INTO turobt_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Bu sebeple, Mesih bizi nasıl kabul ettiyse, siz de Allahʼın yüceltilmesi için birbirinizi öyle kabul edin. ");
INSERT INTO turobt_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Size şunu diyorum: Mesih, Allahʼın sözüne sadık olduğunu göstermek için sünnetlilerin, yani Yahudilerin, hizmetkârı oldu. Bunu Allahʼın onların atalarına verdiği vaatleri yerine getirmek için yaptı. ");
INSERT INTO turobt_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ayrıca Yahudi olmayan milletlerin Allahʼı merhameti için yüceltmelerini istedi. Tıpkı Kutsal Yazıʼda yazıldığı gibi: “Bunun için diğer milletlerin arasında seni yücelteceğim. Adını ilahilerle öveceğim.” ");
INSERT INTO turobt_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Yine şöyle diyor: “Siz milletler Allahʼın halkıyla birlikte sevinin.” ");
INSERT INTO turobt_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Hem de diyor ki, “Ey bütün milletler, Rabbi övün! Ey bütün halklar, Oʼnu yüceltin!” ");
INSERT INTO turobt_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Üstelik Yeşaya şöyle diyor: “İşayʼın Kökü ortaya çıkacak, bütün milletlere kral olmak için yükselecek. Milletler Oʼna umut bağlayacak.” ");
INSERT INTO turobt_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Umut veren Allah, iman hayatınızda sizi tam bir sevinç ve esenlikle doldursun. O zaman Kutsal Ruhʼun gücü sayesinde umutla dolup taşarsınız. ");
INSERT INTO turobt_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ey kardeşlerim, iyilikle dolu olduğunuzdan eminim. Her tür bilgiye sahipsiniz ve birbirinize akıl verebilecek durumdasınız. ");
INSERT INTO turobt_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","16","Ama bu mektupla epey cesaret göstererek size bazı konuları hatırlatmak istedim. Şöyle ki, Allah bana, Mesih İsaʼnın kulu olarak Yahudi olmayanlara hizmet etme lütfunu bağışladı. Onlar Kutsal Ruh sayesinde Allahʼa adanan, Oʼnu hoşnut eden adaklar olsunlar diye Allahʼın Müjdesiʼnirahip gibi yayıyorum. ");
INSERT INTO turobt_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Bu sebeple, Mesih İsaʼya bağlı olduğum için Allah yolundaki hizmetimle gurur duyuyorum. ");
INSERT INTO turobt_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","19","Çünkü sadece Mesihʼin benim aracılığımla başardıklarından söz etmek istiyorum. O diğer milletlerin Allahʼa itaat etmesi için mucizelerin ve harikaların gücüyle, Allahʼın Ruhuʼnun gücüyle söylediklerimi ve yaptıklarımı kullandı. Bunun sonucunda Mesihʼin Müjdesiʼni yayma işini Yeruşalimʼden başlayarak ta İllirikum bölgesine kadar tamamladım. ");
INSERT INTO turobt_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Amacım Mesihʼin Müjdesiʼni adının henüz bilinmediği yerlerde yaymaktır. Çünkü hizmetimi başka birinin koyduğu temelin üzerine kurmak istemiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ama Kutsal Yazılarʼda yazıldığı gibi, “Oʼndan habersiz olanlar görecek. İşitmemiş olanlar anlayacak.” ");
INSERT INTO turobt_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Onun için ne zaman yanınıza gelmek istediysem önüme hep bir engel çıktı. ");
INSERT INTO turobt_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ama artık buralarda hizmet etmek için bana yer kalmadı ve zaten yıllardır size gelmek istiyordum. ");
INSERT INTO turobt_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","İspanyaʼya giderken size uğrayacağım. Çünkü geçerken sizinle görüşmeyi umuyorum. Sohbetinize bir süre doyduktan sonra sizin tarafınızdan oraya yolcu edilmek istiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ama şimdi Allahʼın kutsal halkına hizmet etmek için Yeruşalimʼe gidiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Çünkü Makedonya ve Ahaya bölgelerindeki imanlılar yardım toplayıp bunu Allahʼın Yeruşalimʼdeki kutsal halkında fakir olanlara göndermeyi uygun gördüler. ");
INSERT INTO turobt_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Uygun gördüler diyorum, ama zaten onlara borçluydular. Çünkü Yahudi olmayan imanlılar Yahudilerin ruhsal bereketlerinden pay aldılar. Buna göre onlara maddi nimetlerle de hizmet etmeye borçludurlar. ");
INSERT INTO turobt_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Bu yardımı onlara güvenlikle ulaştırıp görevimi tamamlayacağım. Oradan ayrılıp size uğradıktan sonra İspanyaʼya doğru yol alacağım. ");
INSERT INTO turobt_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Biliyorum ki, size geldiğim zaman Mesihʼin dolgun bereketiyle geleceğim. ");
INSERT INTO turobt_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ey kardeşler, Rabbimiz İsa Mesihʼin ve Kutsal Ruhʼun sevgisi hatırına size yalvarıyorum, benim için Allahʼa dua ederek benim mücadeleme katılın. ");
INSERT INTO turobt_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Öyle ki, Allah beni Yahudiyeʼdeki imansız kişilerden korusun. Yeruşalimʼe götürmekte olduğum yardım da Allahʼın oradaki kutsal halkını hoşnut etsin. ");
INSERT INTO turobt_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ondan sonra Allah isterse sevinçle yanınıza geleyim, aranızda gönlüm ferahlasın. ");
INSERT INTO turobt_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Esenlik veren Allah hepinizle birlikte olsun. Amin. ");
INSERT INTO turobt_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","İmanlı kız kardeşimiz Fibeʼyi size tavsiye etmek istiyorum. O, Kenhere şehrindeki imanlılar topluluğunun hizmetkârlarından biridir. ");
INSERT INTO turobt_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Onu Rabbe ait biri olarak Allahʼın kutsal halkına layık bir şekilde karşılayın. Sizden herhangi bir yardıma ihtiyacı olursa, ona destek olun. Çünkü o, hem bana hem de birçok kişiye destek oldu. ");
INSERT INTO turobt_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Priska ve Akvilaʼya benden selam söyleyin. Onlar Mesih İsa yolunda benim hizmet arkadaşlarımdır. ");
INSERT INTO turobt_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Benim için kendi hayatlarını tehlikeye attılar. Yalnız ben değil, Yahudi olmayan bütün imanlı toplulukları onlara teşekkür borçlu. ");
INSERT INTO turobt_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Onların evinde bir araya gelen topluluğa da selam söyleyin. Sevgili arkadaşım Epenetusʼa da selam söyleyin. O Ege bölgesinden Mesihʼe ilk iman eden kişidir. ");
INSERT INTO turobt_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Meryemʼe selam söyleyin. O sizin için çok çalıştı. ");
INSERT INTO turobt_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Soydaşlarım Andronikus ve Yunyaʼya selam söyleyin. Onlar benim hapis arkadaşlarım. Elçiler arasında tanınmış kişiler. Hem de benden önce Mesihʼe iman ettiler. ");
INSERT INTO turobt_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Rabbe ait biri olarak sevdiğim Ampliatusʼa da selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mesih yolunda hizmet arkadaşımız Urbanusʼa ve sevgili arkadaşım Stahisʼe selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mesihʼe bağlı biri olarak değeri kanıtlanmış Apellesʼe selam söyleyin. Aristobulusʼun ev halkına selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Soydaşım Herodiyonʼa selam söyleyin. Narkisʼin ev halkından Rabbe bağlı olanlara selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Rabbin hizmetinde çalışan imanlı kız kardeşlerimiz Trifena ve Trifosaʼya selam söyleyin. Rabbin hizmetinde çok çalışmış olan sevgili imanlı kız kardeşimiz Persisʼe de selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Rabbe bağlı seçkin bir insan olan Rufusʼa, ve annesine selam söyleyin. Annesi bana da annelik etti. ");
INSERT INTO turobt_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asinkritus, Flegon, Hermes, Patrovas, Hermas ve yanlarındaki imanlı kardeşlere selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filologus ve Yulyaʼya, Nereus ve kız kardeşine, Olimpas ve onların yanındaki bütün imanlılara selam söyleyin. ");
INSERT INTO turobt_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Birbirinizi Allahʼın kutsal halkına yakışan bir öpücükle selamlayın. Mesihʼin bütün toplulukları size selam söylüyorlar. ");
INSERT INTO turobt_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Size öğretilenlere ters düşen fikirler yayan, ayrılıklar yaratan ve imanlıları yoldan saptıran kişiler var. Kardeşler, size yalvarırım: dikkatli olun, böyle kişilerden uzak durun. ");
INSERT INTO turobt_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Çünkü bu tür kişiler Rabbimiz Mesihʼe değil, kendi midelerine hizmet ederler. Kulağı okşayan tatlı sözlerle saf kişileri aldatırlar. ");
INSERT INTO turobt_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Sizin Allahʼa itaat ettiğinizden herkesin haberi oldu. Bu yüzden sizin için seviniyorum. Ama istiyorum ki, iyilik konusunda hikmetli, kötülük konusunda suçsuz olasınız. ");
INSERT INTO turobt_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Esenlik veren Allah kısa zamanda Şeytanʼı ayaklarınızın altında ezecek. Rabbimiz İsa Mesihʼin lütfu üzerinizde olsun. ");
INSERT INTO turobt_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Hizmet arkadaşım Timoteos ve soydaşlarım Lukiyus, Yason ve Susipater size selam gönderiyorlar. ");
INSERT INTO turobt_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Bu mektubu yazıya geçiren ben Tertiyus Rabbe ait biri olarak size selam gönderiyorum. ");
INSERT INTO turobt_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","24","Ben Pavlusʼu ve bütün topluluğu evinde misafir eden Gayus size selam gönderiyor. Şehir hazine yöneticisi Erastusʼun ve imanlı kardeşimiz Kuvartusʼun size selamları var. ");
INSERT INTO turobt_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Allah, İsa Mesih hakkında vaaz ettiğim Müjdeʼyle sizi kuvvetlendirme gücüne sahiptir. Bu Müjde, Allahʼın ezelden beri gizlediği sırrın açığa çıkarılmasıdır. ");
INSERT INTO turobt_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Bu plan zamanın başlangıcından önce var olan Allahʼın buyruğuna göre peygamberlerin yazılarıyla şimdi açıklandı ve bütün milletlerin imana gelip Allahʼa itaat etmeleri için duyuruldu. ");
INSERT INTO turobt_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Evet, tek hikmet sahibi olan Allahʼa, İsa Mesih aracılığıyla sonsuzlara kadar övgüler olsun! Amin.");
INSERT INTO turobt_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Allahʼın isteğiyle Mesih İsaʼnın elçisi olmaya çağrılan ben Pavlusʼtan ve imanlı kardeşimiz Sostenesʼten, ");
INSERT INTO turobt_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Allahʼın Korint şehrindeki topluluğuna selam! Her yerde hepimizin Efendisi olan İsa Mesihʼe yalvaranlarla beraber Mesih İsa sayesinde Allahʼa adandınız. Allahʼın kutsal halkına katılmaya çağrıldınız. ");
INSERT INTO turobt_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Babamız Allahʼtan ve Rab İsa Mesihʼten size lütuf ve esenlik olsun. ");
INSERT INTO turobt_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Her zaman sizin için Allahımʼa şükrediyorum. Çünkü Allah, Mesih İsa aracılığıyla size lütfunu bağışladı. ");
INSERT INTO turobt_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","İsa Mesih sayesinde her konuda berekete kavuştunuz. Her türlü bilginiz, her türlü konuşma yeteneğiniz var. ");
INSERT INTO turobt_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Bu şekilde Mesih hakkındaki şahitliğimiz aranızda doğrulanmış oluyor. ");
INSERT INTO turobt_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Böylece siz Rabbimiz İsa Mesihʼın görünmesini dört gözle beklerken, Allahʼın lütfettiği hiçbir yetenekten yoksun değilsiniz. ");
INSERT INTO turobt_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Rabbimiz İsa Mesih sona kadar dayanmanız için sizi güçlendirecek. Öyle ki, Oʼnun geldiği gün suçsuz olasınız. ");
INSERT INTO turobt_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Allah güvenilirdir. O sizi Oğlu, Rabbimiz İsa Mesihʼle ruhsal beraberliğe çağırdı. ");
INSERT INTO turobt_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Kardeşler, aynı fikirde olmanız için size Rabbimiz İsa Mesihʼin adıyla yalvarıyorum. Aranızda ayrılık olmasın. Aynı fikirde, aynı amaçta birleşin. ");
INSERT INTO turobt_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Kardeşlerim, Kloveʼnin ev halkından bana gelen habere göre, aranızda kavgalar oluyormuş. ");
INSERT INTO turobt_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Şunu demek istiyorum: her biriniz taraf tutuyor, “Ben Pavlusçuyum”, “Ben Apollosçuyum”, “Ben Petrusçuyum”, ya da “Ben Mesihçiyim” diyor. ");
INSERT INTO turobt_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Mesih bölündü mü? Sizin için Pavlus mu çarmıha gerildi? Pavlusʼun adıyla mı vaftiz oldunuz? ");
INSERT INTO turobt_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Allahʼa şükür, ben Krispus ve Gayusʼtan başka hiç kimseyi vaftiz etmedim. ");
INSERT INTO turobt_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Öyle ki, hiçbiriniz benim adımla vaftiz olduğunu söylemesin. ");
INSERT INTO turobt_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Evet, bir de İstefanasʼın ev halkını vaftiz ettim. Bunların dışında kimseyi vaftiz ettiğimi hatırlamıyorum. ");
INSERT INTO turobt_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Zaten Mesih beni vaftiz etmeye değil, Müjdeʼyi vaaz etmeye gönderdi. Ama bunu insan hikmetine dayanan 