﻿USE sofia;
DROP TABLE IF EXISTS sofia.tuoNT_vpl;
CREATE TABLE tuoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tuoNT_vpl WRITE;
INSERT INTO tuoNT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ne waro Õꞌacʉ̃ ʉꞌmʉse, tojo nicã diꞌtare bajurẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Titare diꞌta ne bajuticaro niwʉ̃. Tojo weero ne apeyenojõ marĩcaro niwʉ̃. Aco diaꞌcʉ̃ nipeꞌtiropʉ nicaro niwʉ̃. Tojo nicã naꞌitĩꞌarõ nicaro niwʉ̃. Espíritu Santu aco buꞌipʉ wʉʉcusiacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Õꞌacʉ̃ tere ĩꞌagʉ̃, aꞌtiro nicʉ niwĩ: “Boꞌreyuse niato”, nicʉ niwĩ. Cʉ̃ tojo nicãta, boꞌreyua waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Te boꞌreyuse añuse nicã ĩꞌagʉ̃, “Añuꞌu”, nicʉ niwĩ. To beꞌro boꞌreyusere dʉcawaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tere dʉcawaagʉ, aꞌtiro wãmeyecʉ niwĩ. Boꞌreyusere “ʉmʉco”, naꞌitĩꞌasere “ñami” wãmeyecʉ niwĩ. Cʉ̃ tojo níca beꞌro ʉmʉco, ñami nʉꞌcãcaro niwʉ̃. Ticʉseta weecʉ niwĩ Õꞌacʉ̃ ne nʉꞌcãrĩ nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Tere wééca beꞌro ape nʉmʉ peꞌe, te acore ĩꞌagʉ̃, Õꞌacʉ̃ aꞌtiro nicʉ niwĩ: “Acore dʉcawaaroʉaꞌa. Apeye ʉꞌmʉsepʉ, apeye nucũcãpʉ tojato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Cʉ̃ níꞌcaronojõta acore dʉcawaacʉ niwĩ. Apeye ʉꞌmʉsepʉ, apeye nucũcãpʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ʉꞌmʉarõpʉ oꞌmecurari nirõpʉre “ʉꞌmʉse” wãmeyecʉ niwĩ. Aꞌtere weecʉ niwĩ Õꞌacʉ̃, niꞌcã nʉmʉ beꞌro cja nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ape nʉmʉrẽ Õꞌacʉ̃ “Diꞌta boposãjã bajuato nígʉ̃, aco ʉꞌmʉse docapʉ nise niꞌcãrõpʉta nerẽato”, nicʉ niwĩ. Cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Te boposãjãꞌquere ĩꞌagʉ̃, “diꞌta” wãmeyecʉ niwĩ. Aco niꞌcãrõ meꞌrã nerẽꞌquere “dia pajiri maajo” wãmeyecʉ niwĩ. Õꞌacʉ̃ te cʉ̃ weeꞌquere ĩꞌagʉ̃, “Añuꞌu”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Te nipeꞌtise añurõ bajucã ĩꞌagʉ̃, “Diꞌtapʉre noꞌo nise pĩꞌrĩato. Noꞌo nipeꞌtise otese cape oꞌosenojõ, tojo nicã yucʉpagʉ nipeꞌtise dʉcatise cape oꞌosenojõ pĩꞌrĩato. Tojo weero te dʉcata pĩꞌrĩturiarosaꞌa”, nicʉ niwĩ Õꞌacʉ̃. Cʉ̃ tojo níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Diꞌtapʉre noꞌo otese cape cʉosenojõ pĩꞌrĩ, dʉcaticaro niwʉ̃. Tojo nicã pacase yucʉpagʉ quẽꞌrã pĩꞌrĩ, dʉcaticaro niwʉ̃. Aꞌte cʉ̃ weeꞌquere ĩꞌagʉ̃, “Añuꞌu”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Aꞌtere weecʉ niwĩ Õꞌacʉ̃ pʉa nʉmʉ beꞌro cja nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Iꞌtia nʉmʉ beꞌro Õꞌacʉ̃ nicʉ niwĩ tja: “Ʉꞌmʉsepʉre sĩꞌose cũurõʉaꞌa. Tojo weecã, ʉmʉcore, ñamirẽ dʉcawaarosaꞌa. Te meꞌrã ĩꞌamasĩnoꞌrõsaꞌa ʉmʉcori, ñamirĩ, cʉ̃ꞌmarĩ, puꞌecʉri waꞌasere. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Aꞌte diꞌtare sĩꞌoatje ʉꞌmʉsepʉ nirõsaꞌa”, nicʉ niwĩ Õꞌacʉ̃. Cʉ̃ níꞌcaronojõta tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tojo weegʉ Õꞌacʉ̃ pʉarã mujĩpũa weecʉ niwĩ. Niꞌcʉ̃ mujĩpũ pajigʉ ʉmʉcore sĩꞌoacjʉre, apĩ cãꞌgʉ̃acã ñamirẽ sĩꞌoacjʉre weecʉ niwĩ. Ñocõa quẽꞌrãrẽ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Cʉ̃ aꞌti diꞌtare sĩꞌoato nígʉ̃, narẽ ʉꞌmʉsepʉ cũucʉ niwĩ. Boꞌreyusere, naꞌitĩꞌasere dʉcawaagʉ, tojo weecʉ niwĩ. Te sĩꞌose añuse nicã ĩꞌagʉ̃, “Añuꞌu”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Aꞌtere weecʉ niwĩ Õꞌacʉ̃ iꞌtia nʉmʉ beꞌro cja nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Baꞌparitise nʉmʉrĩ beꞌrore Õꞌacʉ̃ apeye bajurẽnemocʉ niwĩ tja. Aꞌtiro nicʉ niwĩ: “Diapʉre waꞌi, noꞌo nirãnojõ nirãsama. Na pãjãrã masãputirãsama. Tojo nicã ʉꞌmʉarõpʉre mirĩcʉ̃a wʉʉrã nirãsama”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. Pacarã dia pajiri maapʉ nirã́, tojo nicã waꞌi, ãpẽrã nipeꞌtirã diapʉ nirãnojõrẽ, nipeꞌtirã waꞌicʉrã wʉʉrãrẽ bajurẽcʉ niwĩ. Tuꞌajatojanʉꞌcõ, “Añuꞌu”, ni ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Narẽ añurõ waꞌato nígʉ̃, aꞌtiro nicʉ niwĩ: “Põꞌrãti weetjĩarã, nipeꞌtiropʉ ʉꞌmʉarõpʉ, tojo nicã maarĩpʉre tuuseꞌsanʉꞌcãrã waꞌaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Aꞌtere weecʉ niwĩ Õꞌacʉ̃ baꞌparitise nʉmʉrĩ beꞌro cja nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Niꞌcãmocʉse nʉmʉrĩ beꞌrore Õꞌacʉ̃ aꞌtiro nicʉ niwĩ tja: “Diꞌtapʉre waꞌicʉrãrẽ cũugʉ̃ti. Na nʉcʉ̃cjãrã, ecarã, bʉarã, nucũcãpʉ sĩꞌcõsijarã nirãsama”, nicʉ niwĩ. Cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tojo weegʉ waꞌicʉrã nʉcʉ̃cjãrã, ecarã, bʉarã, nucũcãpʉ sĩꞌcõsijarãrẽ daꞌrecʉ niwĩ. Narẽ ĩꞌagʉ̃, “Añuꞌu”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Cʉ̃ nipeꞌtise wééca beꞌro aꞌtiro nicʉ niwĩ: “Niꞌcʉ̃ masʉ̃ marĩ weronojõ niseti, bajugʉre daꞌrerã. Tʉꞌomasĩse cʉogʉ nigʉ̃sami. Cʉ̃ waꞌi, mirĩcʉ̃a, waꞌicʉrã ecarã, nʉcʉ̃cjãrã, bʉarã, nucũcãpʉ sĩꞌcõsijarã, nipeꞌtirã aꞌti nucũcãpʉ nirã́ buꞌipʉ dutigʉ nigʉ̃sami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Õꞌacʉ̃ masʉ̃rẽ daꞌregʉ, cʉ̃ weronojõ niseti, bajugʉre weecʉ niwĩ. Ʉmʉ, numio daꞌrecʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Narẽ aꞌtiro nicʉ niwĩ: “Mʉsãrẽ añurõ waꞌato. Pãjãrã põꞌrãti masãputiya. Nipeꞌtiropʉre tuuseꞌsanʉꞌcãña. Mʉsã aꞌti diꞌta wiorã nirãsaꞌa. Waꞌire, mirĩcʉ̃arẽ, nipeꞌtirã waꞌicʉrãrẽ dutirãsaꞌa.” ");
INSERT INTO tuoNT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Beꞌro narẽ ninemocʉ niwĩ: “Noꞌo baꞌase otese peri cʉosenojõrẽ, yucʉdʉca dʉcatisenojõrẽ mʉsãrẽ oꞌoꞌo. Te mʉsã baꞌase nirõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Apeye quẽꞌrãrẽ, nipeꞌtirã waꞌicʉrã, wʉʉrã, nucũcãpʉ sĩꞌcõsijarã, nipeꞌtirã catise cʉorãnojõ tá, tojo nicã pũrĩ yaꞌsasere baꞌarãsama. Narẽ tere cũuꞌu”, nicʉ niwĩ Õꞌacʉ̃. Cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Te nipeꞌtise cʉ̃ weeꞌquere weetuꞌajanʉꞌcõ, “Añubutiaꞌa”, ni ĩꞌacʉ niwĩ. Tocãꞌrõta weecʉ niwĩ Õꞌacʉ̃ niꞌcãmocʉse nʉmʉrĩ beꞌro cja nʉmʉrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ʉꞌmʉse, tojo nicã aꞌti diꞌtare Õꞌacʉ̃ nipeꞌtise cʉ̃ weeꞌquere tuꞌajanʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nitʉori nʉmʉrẽ, cʉ̃ nipeꞌtise wééca beꞌro soocʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tojo weegʉ Õꞌacʉ̃ aꞌtiro nicʉ niwĩ: “Nitʉori nʉmʉ yʉꞌʉ weemʉꞌtãꞌque nʉmʉrĩ weronojõ nisome. Ya nʉmʉ, yʉꞌʉ soodutiri nʉmʉ nirõsaꞌa. Ti nʉmʉ añurĩ nʉmʉ nirõsaꞌa”, ni cũucʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ʉꞌmʉse, diꞌta nipeꞌtise Õꞌacʉ̃ cʉ̃ weeꞌque aꞌtiro weenoꞌcaro niwʉ̃. Ne waro Õꞌacʉ̃ aꞌti diꞌta, ʉꞌmʉsere wéégʉ, ");
INSERT INTO tuoNT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","maata acoro pejacã weeticʉ niwĩ. Tojo weero ne noꞌo nisenojõ pĩꞌrĩticaro niwʉ̃. Diꞌtare daꞌragʉ quẽꞌrã marĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tojo nimicã, aco diꞌtapʉ nise wijati, diꞌtare puocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Õꞌacʉ̃ masʉ̃rẽ bajurẽgʉ̃, diꞌta meꞌrã daꞌrecʉ niwĩ. Tojo weegʉ cʉ̃rẽ catise oꞌogʉ, ẽꞌquẽapʉ putisãacʉ niwĩ. Cʉ̃ tojo weecãta, catinʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Cʉ̃rẽ tojo wééca beꞌro Edẽ́ wãmetiropʉ, Õꞌacʉ̃ niꞌcã wese cʉ̃rẽ daꞌrebosacʉ niwĩ. Mujĩpũ mʉjãtiro peꞌe nicaro niwʉ̃. Topʉ cʉ̃ ʉmʉrẽ, cʉ̃ daꞌreꞌcʉre cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ti wesepʉ peje yucʉpagʉ añuse baꞌase dʉcatisepagʉre pĩꞌrĩcã weecʉ niwĩ. Tepagʉ añusepagʉ bajucaro niwʉ̃. Ti wese decopʉre pʉagʉ nicaro niwʉ̃. Niꞌcãgʉ̃ catinuꞌcũse oꞌocjʉ nicaro niwʉ̃. Apegʉ peꞌe tʉꞌomasĩsere oꞌocjʉ nicaro niwʉ̃. Tigʉ dʉcare baꞌarã, “Aꞌtiro weese añu niꞌi, aꞌte ñaꞌa niꞌi”, ni tʉꞌomasĩse oꞌocjʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edẽ́pʉre niꞌcã maa nicaro niwʉ̃. Ti wese deco yʉꞌrʉtẽrĩwãꞌcã, baꞌparitise maarĩ dʉcawaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nimʉꞌtãrĩ maa Pisón wãmeticaro niwʉ̃. Ti maa nipeꞌtiro Havila wãmetiropʉre oꞌmabʉrocaro niwʉ̃. Topʉ peje uru ");
INSERT INTO tuoNT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","añuse nicaro niwʉ̃. Topʉre añuse yucʉ ʉꞌmʉtisepagʉ, tojo nicã ʉ̃tãperi wapabʉjʉse peri ónice wãmetise peri nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ape maa peꞌe Gihón wãmeticaro niwʉ̃. Ti maa nipeꞌtiro Cus wãmetiri diꞌtare yʉꞌrʉtẽrĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ape maa Tigris wãmeticaro niwʉ̃. Ti maa Asiria wãmetiro mujĩpũ mʉjãtiro peꞌe oꞌmabʉrocaro niwʉ̃. Ape maa Éufrates wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Õꞌacʉ̃ masʉ̃rẽ ti wesere cṹúgʉ̃, te otesere coꞌtedutigʉ, aꞌtiro ni werecʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","“Aꞌti wese cjase nipeꞌtise yucʉdʉcare baꞌagʉsaꞌa, baꞌagʉ peꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tepagʉ waꞌteropʉre niꞌcãgʉ̃ niꞌi. Tigʉ dʉcare baꞌaticãꞌña. Tigʉ añuse, ñaꞌasere masĩse oꞌocjʉ niꞌi. Tigʉ dʉcare baꞌagʉ, ti nʉmʉta wẽrĩgʉ̃saꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Beꞌro Õꞌacʉ̃ nicʉ niwĩ: “Masʉ̃ niꞌcʉ̃ta nicã, añuweꞌe. Cʉ̃rẽ baꞌpati, weetamuacjore weegʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Õꞌacʉ̃ ne waropʉre waꞌicʉrãrẽ, mirĩcʉ̃arẽ diꞌta meꞌrã daꞌrecʉ niwĩ. Beꞌro narẽ wãme õꞌoato nígʉ̃, masʉ̃ tiropʉ miacʉ niwĩ. Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta weecʉ niwĩ. Nipeꞌtirã ecarã, mirĩcʉ̃a, waꞌicʉrã nʉcʉ̃cjãrãrẽ wãme õꞌocʉ niwĩ. Tojo weerã cʉ̃ õꞌoꞌque wãme meꞌrã tojacãrã niwã. Ãꞌrã pãjãrã nimicã, ne niꞌcõ cʉ̃rẽ baꞌpati weetamuacjo marĩco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tojo weegʉ Õꞌacʉ̃ cʉ̃rẽ cãrĩyʉꞌrʉcã weecʉ niwĩ. Cʉ̃ cãrĩrĩ cura, niꞌcã paatipaꞌmaca õꞌarẽ miicʉ niwĩ. Miitoja, ti õꞌa cʉ̃ miiꞌcarore añurõ biꞌacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ti õꞌa meꞌrã cʉ̃rẽ weetamuacjore daꞌrecʉ niwĩ majã. Co numiorẽ daꞌretojanʉꞌcõ, miiti, cʉ̃rẽ ĩꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Cʉ̃ core ĩꞌagʉ̃, pũrõ eꞌcatise meꞌrã ĩꞌacʉ niwĩ. Tojo weegʉ aꞌtiro nicʉ niwĩ: “Aꞌtigo pũrĩcã, ye diꞌi, ya õꞌa meꞌrã daꞌrenoꞌco nimo. Co ʉmʉpʉre miinoꞌco niyugo, ‘numio’ pisunoꞌgõsamo”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tojo weegʉ ʉmʉ cʉ̃ pacʉre, cʉ̃ pacore wijagʉsami. Cʉ̃ nʉmo meꞌrã nigʉ̃sami. Na pʉarã niꞌcã upʉ weronojõ nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Titapʉre na pʉarã suꞌti marĩrã nicũcãrã niwã. Tojo nimirã, ne bopoyase moocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ʉmʉ, numio Õꞌacʉ̃ cʉ̃ narẽ weebosáca wesepʉ nicãrã niwã. Topʉ na niseti, na pʉarã nirĩ curare, niꞌcʉ̃ pĩrõ numio tiropʉ etacʉ niwĩ. Cʉ̃ nipeꞌtirã waꞌicʉrã yʉꞌrʉoro nisoomeꞌrĩgʉ̃ nicʉ niwĩ. Co tiro etagʉ, core sẽrĩtiñaꞌcʉ niwĩ: —¿Nirõta Õꞌacʉ̃ mʉsãrẽ aꞌtepagʉ dʉcare baꞌadutitiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Cʉ̃ tojo nicã tʉꞌogo, cʉ̃rẽ yʉꞌtico niwõ: —Nipeꞌtise aꞌto nisere baꞌadutiami. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tojo nimigʉ̃ta, niꞌcãgʉ̃ tepagʉ waꞌtero nicjʉ dʉcare baꞌadutitiami. “Mʉsã tigʉ dʉcare baꞌarã, ñeꞌeñaꞌrã, wẽrĩrãsaꞌa”, niami Õꞌacʉ̃, ni yʉꞌtico niwõ pĩrõrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Co tojo nicã tʉꞌogʉ, añurõ nisoomeꞌrĩse meꞌrã core nicʉ niwĩ: —Wẽrĩsome. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Õꞌacʉ̃ añurõ masĩsami. Mʉsã te dʉcare baꞌarã, cʉ̃ weronojõ nirãsaꞌa; ñaꞌasere, añusere masĩrãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Cʉ̃ tojo nisere tʉꞌogo, co numio peꞌe, tigʉ dʉcare ĩꞌamorõ weeco niwõ. Co ĩꞌacã, tigʉ dʉca añuse waro bajucaro niwʉ̃. “Añurõ ʉꞌsʉasenojõ niꞌi” nígõ, baꞌasĩꞌrĩyʉꞌrʉaco niwõ. Tojo nicã, “Tʉꞌomasĩse cʉogoti”, ni wãcũgõ, tigʉ dʉcare téé, baꞌaco niwõ. Baꞌatojanʉꞌcõ, co marãpʉre oꞌoco niwõ. Cʉ̃ quẽꞌrã baꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Na tere baꞌáca beꞌro narẽ tʉꞌomasĩse ejacaro niwʉ̃. Tere baꞌatjĩarã, na suꞌti marĩrã nisere tʉꞌomasĩcãrã niwã. Tojo weetjĩarã, higuera wãmeticjʉ pũrĩ meꞌrã mii, dero, cãꞌmotaꞌasĩꞌrĩmicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Beꞌro na tojo wééca beꞌro ñamicaꞌa mujĩpũ sãjãrĩ cura, Õꞌacʉ̃ ti wesepʉ sijawãꞌcãticã tʉꞌocãrã niwã. Cʉ̃rẽ uirã, yucʉpagʉ waꞌteropʉ duꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tojo weegʉ Õꞌacʉ̃ peꞌe ʉmʉrẽ pisucʉ niwĩ: —¿Noꞌopʉ niti mʉꞌʉ? ");
INSERT INTO tuoNT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Cʉ̃ peꞌe Õꞌacʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ wesepʉ sijawãꞌcãticã tʉꞌoapʉ. Yʉꞌʉ peꞌe suꞌti marĩgʉ̃ niasʉ. Tojo weegʉ uigʉ duꞌtiasʉ, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Cʉ̃ tojo nisere tʉogʉ, Õꞌacʉ̃ cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Noa mʉꞌʉrẽ “Suꞌti marĩgʉ̃ niꞌi”, niati? ¿Mʉꞌʉ yucʉdʉca yʉꞌʉ “Baꞌaticãꞌña” níꞌcʉ dʉcare baꞌati? Tere baꞌatigʉ, mʉꞌʉ masĩtiboapã, nicʉ niwĩ Õꞌacʉ̃ cʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Cʉ̃ tojo nicã tʉꞌogʉ, ʉmʉ cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ yʉꞌʉre baꞌpadaꞌreꞌco yʉꞌʉre tigʉ dʉcare ecamo. Tojo weegʉ baꞌasʉ, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Cʉ̃ tojo nicã tʉꞌogʉ, co numiorẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Mʉꞌʉ deꞌro weego tojo weeati? Co cʉ̃rẽ yʉꞌtico niwõ: —Pĩrõ yʉꞌʉre nisooami. Yʉꞌʉ tojo weego baꞌasʉ, ni yʉꞌtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Õꞌacʉ̃ co tojo nicã tʉꞌogʉ, pĩrõrẽ nicʉ niwĩ: —Mʉꞌʉ nisooꞌque wapa nipeꞌtirã ãpẽrã waꞌicʉrã nemorõ ñaꞌarõ waꞌagʉsaꞌa. Niꞌcãrõacã meꞌrãta téé noꞌo mʉꞌʉ catiro põtẽorõ diꞌtapʉ sĩꞌcõsijagʉsaꞌa. Tojo sĩꞌcõsijagʉ, diꞌtare baꞌagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Numio mʉꞌʉrẽ ne ĩꞌasĩꞌrĩtigosamo. Co põꞌrã, co pãrãmerã nituriarã quẽꞌrã mejãrõta weerãsama. Niꞌcãcã meꞌrã aꞌmerĩ ĩꞌatuꞌtinʉꞌcãrãsaꞌa. Mʉꞌʉ, co macʉ̃ ya dʉꞌpodiare cũꞌrĩgʉ̃saꞌa. Cʉ̃ peꞌe mʉꞌʉ dʉpoare ʉꞌtamʉtõgʉ̃sami, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Cʉ̃rẽ tojo nitoja, numio peꞌere aꞌtiro nicʉ niwĩ: —Mʉꞌʉ yʉꞌrʉnʉꞌcãꞌque buꞌiri wĩꞌmagʉ̃rẽ ñeꞌegõtigo, pũrõ piꞌetigosaꞌa. Tojo põꞌrãti, pũrĩnoꞌmigõ, mʉꞌʉ marãpʉ meꞌrã nisĩꞌrĩgõsaꞌa. Cʉ̃ peꞌe mʉꞌʉ wiogʉ weronojõ nigʉ̃sami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Core tojo nituꞌajanʉꞌcõ, co marãpʉ peꞌere aꞌtiro nicʉ niwĩ: —Mʉꞌʉ nʉmo co ucũsere tʉꞌo ẽjõpeotjĩagʉ̃, yʉꞌʉ baꞌadutitiꞌquere baꞌaꞌque buꞌiri, mʉꞌʉ pũrõ piꞌetise meꞌrã daꞌra, baꞌasere bocagʉsaꞌa. Niꞌcãcã meꞌrãta ʉpʉtʉ daꞌratjĩagʉ̃, piꞌetinʉꞌcãgʉ̃saꞌa. Téé wẽrĩgʉ̃pʉ tojo weetʉogʉsaꞌa. Mʉꞌʉ yʉꞌʉre yʉꞌrʉnʉꞌcãꞌque buꞌiri nipeꞌtiro diꞌtapʉre ñaꞌase pĩꞌrĩrõsaꞌa. Pota, tá, apeye peje ñaꞌase pĩꞌrĩnemorõsaꞌa. Tojo nicã nʉcʉ̃ cjase otetisenojõrẽ baꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Baꞌasere aꞌmagʉ̃, mʉꞌʉ pũrõ asituuase meꞌrã daꞌragʉsaꞌa. Téé wẽrĩgʉ̃pʉ soogʉsaꞌa. Mʉꞌʉ diꞌta meꞌrã weenoꞌcʉ niꞌi. Tojo weegʉ mʉꞌʉ wẽrĩgʉ̃, diꞌtata apaturi dojogʉsaꞌa, ni werecʉ niwĩ Õꞌacʉ̃ cʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adã́ cʉ̃ nʉmorẽ Eva wãme õꞌocʉ niwĩ. “Co nipeꞌtirã paco nigõsamo,” nígʉ̃, tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Beꞌro Õꞌacʉ̃ narẽ na suꞌti sãñatjere weebosacʉ niwĩ. Waꞌicʉrã caseri meꞌrã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tojo wee, Õꞌacʉ̃ aꞌtiro nicʉ niwĩ: “Ãꞌrĩ yʉꞌʉ dutisere yʉꞌrʉnʉꞌcãtjĩagʉ̃, marĩ weronojõ añuse, ñaꞌasere tʉꞌomasĩgʉ̃ waꞌami. Cʉ̃ apegʉ catinuꞌcũsere oꞌocjʉ dʉcare baꞌacã, ñaꞌa nibosaꞌa. Cʉ̃ tere baꞌagʉ pũrĩcã, catinuꞌcũcãꞌbosami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tojo weegʉ cʉ̃rẽ apesepʉ wĩorẽcʉ niwĩ. Cʉ̃, cʉ̃rẽ cũumiꞌcarore nidutiticʉ niwĩ majã. Ne waro añurõpʉ Edẽ́pʉ nimiꞌcʉre cõꞌawĩrõcãꞌcʉ niwĩ. Cʉ̃ diꞌta meꞌrã daꞌrenoꞌcʉre baꞌasere aꞌmagʉ̃, diꞌtareta daꞌraduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Õꞌacʉ̃ Adã́, Evare cõꞌawĩrõca beꞌro na catinuꞌcũsere oꞌocjʉ dʉcare baꞌabosama nígʉ̃, ʉꞌmʉsecjãrã Õꞌacʉ̃rẽ werecoꞌterãrẽ Edẽ́ mujĩpũ mʉjãtiro peꞌere coꞌtedutigʉ cũucʉ niwĩ. Tojo nicã cʉ̃ diꞌpjĩ pajiri pjĩ pecameꞌe weronojõ ʉ̃jʉ̃, sʉtʉanuꞌcũrĩ pjĩrẽ cũucʉ niwĩ. Ne niꞌcʉ̃ catinuꞌcũse cʉocjʉ tiropʉ ejaticãꞌto nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Beꞌro Adã́, Eva añurĩ wese Edẽ́pʉ níꞌcãrã na wijáca beꞌro aperopʉ waꞌacãrã niwã. Topʉ Adã́ cʉ̃ nʉmo meꞌrã nicʉ niwĩ. Tojo weego nijĩpaco tojaco niwõ. Beꞌro niꞌcʉ̃ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃rẽ Caĩ́ wãme õꞌocãrã niwã. Cʉ̃ bajuacã ĩꞌagõ, Eva, “Õꞌacʉ̃ weetamuse meꞌrã yʉꞌʉ wĩꞌmagʉ̃rẽ wʉapʉ”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Beꞌro apaturi Eva apĩ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃ wãmeticʉ niwĩ Abel. Cʉ̃ Abel, Caĩ́ acabiji nicʉ niwĩ. Na pʉarã bʉcʉa weetjĩarã, nanʉcʉ̃ daꞌrase cʉocãrã niwã. Abel oveja coꞌtegʉ nicʉ niwĩ. Cʉ̃ maꞌmi Caĩ́ peꞌe otesere oteri masʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yoáca beꞌro Caĩ́ niꞌcã nʉmʉ cʉ̃ daꞌrase cjasere Õꞌacʉ̃rẽ oꞌogʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Cʉ̃ acabiji Abel quẽꞌrã cʉ̃ daꞌrasere miacʉ niwĩ. Cʉ̃ yarã oveja ne põꞌrãtiꞌcãrã añurãrẽ miacʉ niwĩ. Õꞌacʉ̃ Abere, cʉ̃ miaꞌquere añurõ eꞌcatise meꞌrã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Cʉ̃ maꞌmi Caĩ́ peꞌere, cʉ̃ miaꞌquere Õꞌacʉ̃ tʉꞌsaticʉ niwĩ. Tojo weegʉ Caĩ́ ua waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Cʉ̃ tojo uacã ĩꞌagʉ̃, Õꞌacʉ̃ Caĩrẽ́ aꞌtiro nicʉ niwĩ: “¿Deꞌro weegʉ mʉꞌʉ uati? ");
INSERT INTO tuoNT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mʉꞌʉ añurõ weecã, eꞌcatise meꞌrã mʉꞌʉrẽ ĩꞌagʉ̃saꞌa. Añurõ weetigʉ pũrĩcã, ñaꞌarõ nisetinuꞌcũgʉ̃saꞌa. Tojo weegʉ mʉꞌʉ ñaꞌarõ weesĩꞌrĩsere tojo tʉꞌoñaꞌa, wãcũtutuaya”, ni werecʉ niwĩ Õꞌacʉ̃ Caĩrẽ́. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Beꞌro niꞌcã nʉmʉ Caĩ́ cʉ̃ acabiji Abere, “Teꞌa cãpũpʉ sijarã”, nicʉ niwĩ. To cãpũpʉ na pʉarã nírã, Caĩ́ peꞌe cʉ̃ acabijire wẽjẽcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Õꞌacʉ̃ cʉ̃ tojo weecã ĩꞌagʉ̃, Caĩrẽ́ aꞌtiro nicʉ niwĩ: —¿Mʉꞌʉ acabiji Abel noꞌopʉ niti? nicʉ niwĩ. Caĩ́ cʉ̃rẽ yʉꞌticʉ niwĩ: —Masĩtisaꞌa. Cʉ̃rẽ coꞌtegʉ mejẽta niꞌi, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Cʉ̃ tojo yʉꞌticã tʉꞌogʉ, Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —¿Deꞌro weegʉ mʉꞌʉ acabijire wẽjẽati? Mʉꞌʉ acabiji ye dí diꞌtapʉ yʉꞌʉre pisu caricũcũñarõ weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tojo weegʉ mʉꞌʉ acabijire wẽjẽꞌque buꞌiri mʉꞌʉrẽ ñaꞌarõ waꞌarosaꞌa. Piꞌeti, bajaqueꞌatinuꞌcũgʉ̃saꞌa. Cʉ̃rẽ wẽjẽcã, cʉ̃ ye dí diꞌtapʉ siꞌbisãjã waꞌapʉ. Tojo weegʉ niꞌcãrõacãrẽ aꞌti diꞌtare cõꞌawĩrõnoꞌgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mʉꞌʉ otecã, ne dʉca marĩrõsaꞌa. Sooro marĩrõ nipeꞌtiropʉ sijabajaqueꞌatigʉ nigʉ̃saꞌa, nicʉ niwĩ Õꞌacʉ̃ Caĩrẽ́. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caĩ́ cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ yʉꞌʉre to cãꞌrõjo buꞌiri daꞌrecã, ne põtẽosome. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Niꞌcãcã yʉꞌʉre aꞌti diꞌta nimiꞌcʉre cõꞌabutiaꞌa. Tojo weegʉ mʉꞌʉ ĩꞌorõpʉre nisome. Sooro marĩrõ nipeꞌtiropʉre sijabajaqueꞌatigʉsaꞌa. Tojo weecãma, noꞌo yʉꞌʉre bocaejagʉ wẽjẽgʉ̃sami, ni yʉꞌticʉ niwĩ Caĩ́ Õꞌacʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Cʉ̃ tojo nicã tʉꞌogʉ, Õꞌacʉ̃ yʉꞌticʉ niwĩ: —Noꞌo mʉꞌʉrẽ bocaeja wẽjẽgʉ̃nojõ sietetiri mʉꞌʉrẽ buꞌiri daꞌrero nemorõ daꞌrenoꞌgʉ̃sami, nicʉ niwĩ. Tojo weegʉ Õꞌacʉ̃ Caĩrẽ́ wẽjẽticãꞌto nígʉ̃, cʉ̃ upʉpʉre apeyenojõ ojaõꞌocʉ niwĩ. Cʉ̃rẽ ĩꞌamasĩ, wẽjẽticãꞌto nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tojo weegʉ, Caĩ́ Õꞌacʉ̃ ĩꞌorõpʉ nimiꞌcʉ wija waꞌacʉ niwĩ. Nod wãmetiropʉ, Edẽ́ mujĩpũ mʉjãtiro peꞌe nirõpʉ niseticʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caĩ́ yoáca beꞌro nʉmotia waꞌacʉ niwĩ. Cʉ̃ nʉmo meꞌrã nicʉ niwĩ. Tojo weego co nijĩpaco tojaco niwõ. Beꞌro niꞌcʉ̃ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃ wãmeticʉ niwĩ Enoc. Titare Caĩ́ niꞌcã macã daꞌrecʉ niwĩ. Ti macãrẽ Enoc wãmeyecʉ niwĩ. Cʉ̃ macʉ̃ nimʉꞌtãgʉ̃ ye wãme weronojõ õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc, Irad pacʉ nicʉ niwĩ. Irata Mehujael pacʉ nicʉ niwĩ. Mehujaeta Metusael pacʉ nicʉ niwĩ. Metusael Lamec pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Cʉ̃, Lamec pʉarã numia nʉmoticʉ niwĩ. Niꞌcõ Ada wãmetico niwõ, apego Zila. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada niꞌcʉ̃ põꞌrãtico niwõ. Cʉ̃ Jabal wãmeticʉ niwĩ. Cʉ̃ pãrãmerã nituriarã wecʉa cʉorã nicãrã niwã. Na sijari masã nitjĩarã, suꞌti caseri meꞌrã weeꞌque wiꞌserire cʉocũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal acabiji Jubal wãmeticʉ niwĩ. Cʉ̃ Jubal pãrãmerã nituriarã wẽopawʉ putirã, bʉapʉ̃tẽrĩ masã nicũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Apego Lamec nʉmo Zila wãmetigo niꞌcʉ̃ põꞌrãtico niwõ. Tubal-caĩ́ wãmetigʉ cõme, tojo nicã bronce wãmetise meꞌrã apeyenojõ daꞌrecũcʉ niwĩ. Cʉ̃ niꞌcõ acabijoticʉ niwĩ. Co Naama wãmetico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Niꞌcã nʉmʉ Lamec cʉ̃ nʉmosãnumiarẽ, Ada, Zilare aꞌtiro nicʉ niwĩ: “Yʉꞌʉ ucũsere añurõ tʉꞌoya. Yʉꞌʉre cãmidaꞌrese wapa niꞌcʉ̃ ʉmʉrẽ wẽjẽcãꞌpʉ. Niꞌcʉ̃ maꞌmʉrẽ yʉꞌʉre paase wapa mejãrõta weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","‘Caĩrẽ́ wẽjẽgʉ̃nojõ sietetiri cʉ̃rẽ aꞌmenoꞌgʉ̃sami’, nicʉ niwĩ Õꞌacʉ̃. Yʉꞌʉ peꞌema setenta y sietetiri aꞌmenoꞌrõsaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adã́ apaturi cʉ̃ nʉmo meꞌrã nicʉ niwĩ tja. Tojo weego co niꞌcʉ̃ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃ bajuacã ĩꞌagõ, cʉ̃rẽ Set wãme õꞌoco niwõ. “Õꞌacʉ̃ yʉꞌʉre oꞌomi” nígõ, tojo weeco niwõ. “Õꞌacʉ̃ ãꞌrĩ, Caĩ́ wẽjẽꞌcʉ Abere dʉcayugʉre yʉꞌʉre oꞌomi”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Beꞌro cʉ̃ Set quẽꞌrã bʉcʉa, nʉmoticʉ niwĩ. Cʉ̃ nʉmo niꞌcʉ̃ põꞌrãtico niwõ. Cʉ̃rẽ Enós wãme õꞌocʉ niwĩ. Cʉ̃ bajuáca beꞌro masã Õꞌacʉ̃rẽ “Ʉ̃sã wiogʉ niꞌi” ni ẽjõpeo, sẽrĩnʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aꞌte Adã́ põꞌrã nituriarã ye queti ojaꞌque niꞌi. Ne waro Õꞌacʉ̃ masʉ̃rẽ wéégʉ, cʉ̃ weronojõ bajugʉta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ʉmʉ, numio weecʉ niwĩ. Narẽ bajurẽgʉ̃, “Ãꞌrã masã nima; narẽ añurõ waꞌato” ni, cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adã́ ciento treinta cʉ̃ꞌmarĩ cʉogʉ, niꞌcʉ̃ cʉ̃ weronojõ bajugʉ macʉ̃ticʉ niwĩ. Cʉ̃ wĩꞌmagʉ̃rẽ Set wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set bajuáca beꞌrore Adã́ ochocientos cʉ̃ꞌmarĩ catinemocʉ niwĩ. Tojo weegʉ pãjãrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nipeꞌtise cʉ̃ꞌmarĩ catigʉ, novecientos treinta cʉ̃ꞌmarĩ caticʉ niwĩ. Ticʉse cʉ̃ꞌmarĩ cʉogʉ, Adã́ wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Adã́ macʉ̃ Set niꞌcʉ̃ macʉ̃ticʉ niwĩ. Cʉ̃ wĩꞌmagʉ̃rẽ Enós wãme õꞌocʉ niwĩ. Cʉ̃ macʉ̃ Enós bajuácaterore ciento cinco cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Cʉ̃ bajuáca beꞌrore Set ochocientos siete cʉ̃ꞌmarĩ catinemocʉ niwĩ. Cʉ̃ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set novecientos doce cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Cʉ̃ macʉ̃ Enós, Cainán wãmetigʉre macʉ̃ticʉ niwĩ. Cainán bajuácaterore Enós noventa cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Beꞌro Enós ochocientos quince cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enós novecientos cinco cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Enós macʉ̃ Cainán Mahalaleel wãmetigʉre macʉ̃ticʉ niwĩ. Mahalaleel bajuácaterore Cainán setenta cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Cainán ochocientos cuarenta cʉ̃ꞌmarĩ catinemocʉ niwĩ. Ticʉse cʉ̃ꞌmarĩ cʉogʉ, ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Cainán novecientos diez cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Cainán macʉ̃ Mahalaleel Jared wãmetigʉre macʉ̃ticʉ niwĩ. Jared bajuácaterore Mahalaleel sesenta y cinco cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Beꞌro te cʉ̃ꞌmarĩ beꞌrore ochocientos treinta cʉ̃ꞌmarĩ catinemocʉ niwĩ. Pãjãrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleel ochocientos noventa y cinco cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared quẽꞌrã Enoc wãmetigʉre macʉ̃ticʉ niwĩ. Enoc bajuácaterore Jared ciento sesenta y dos cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Beꞌro pãjãrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. Ochocientos cʉ̃ꞌmarĩ catinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared novecientos sesenta y dos cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Beꞌro Jared macʉ̃ Enoc, Matusalén wãmetigʉre macʉ̃ticʉ niwĩ. Cʉ̃ macʉ̃ Matusalén bajuácaterore sesenta y cinco cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoc Õꞌacʉ̃ meꞌrã añurõ niseti, cʉ̃ ʉaro weecʉ niwĩ. Cʉ̃ macʉ̃ Matusalén bajuáca beꞌrore Enoc trescientos cʉ̃ꞌmarĩ catinemocʉ niwĩ. Ãpẽrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoc trescientos sesenta y cinco cʉ̃ꞌmarĩ caticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Cʉ̃ Õꞌacʉ̃ dutise weegʉ́ nitjĩagʉ̃, wẽrĩticʉ niwĩ. Niꞌcã nʉmʉ bajudutia waꞌacʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ mia waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Enoc macʉ̃ Matusalén Lamec wãmetigʉre macʉ̃ticʉ niwĩ. Lamec bajuácaterore Matusalén ciento ochenta y siete cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Beꞌro setecientos ochenta y siete cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusalén cʉ̃ novecientos sesenta y nueve cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Beꞌro Matusalén macʉ̃ Lamec ciento ochenta y dos cʉ̃ꞌmarĩ cʉogʉ, macʉ̃ticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Cʉ̃ macʉ̃rẽ Noé wãme õꞌogʉ̃, aꞌtiro nicʉ niwĩ: “Õꞌacʉ̃, ‘Diꞌtapʉre peje ñaꞌase, tá, pota pĩꞌrĩrõsaꞌa’, nicʉ niwĩ. Tojo weerã marĩ baꞌasere aꞌmarã, pũrõ piꞌetise meꞌrã diꞌtare daꞌraꞌa. Ãꞌrĩ yʉꞌʉ macʉ̃ meꞌrã marĩ soose bocarãsaꞌa”, nicʉ niwĩ Lamec. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","31","Noé bajuáca beꞌrore Lamec quinientos noventa y cinco cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ãpẽrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. Lamec setecientos setenta y siete cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Beꞌro cʉ̃ macʉ̃ Noé quinientos cʉ̃ꞌmarĩ cʉóca beꞌro, cʉ̃ põꞌrã Sẽ, Cã, Jafet bajuacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Titare masã aꞌti diꞌtapʉre pãjãrã waro masãputicãrã niwã. Na põꞌrã numia añubutiarã numia nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Õꞌacʉ̃ yarã nimiꞌcãrã na numiarẽ ĩꞌarã, “Añubutiarã numia nima”, ni ĩꞌacãrã niwã. Tojo weerã nanʉcʉ̃ noꞌo na ʉagore, na tʉꞌsagore nʉmoticũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Õꞌacʉ̃ peꞌe aꞌtiro nicʉ niwĩ: “Yʉꞌʉ masãrẽ aꞌti nucũcãpʉ catinuꞌcũcã weesome. Na boacjãrã diaꞌcʉ̃ nima. Ciento veinte cʉ̃ꞌmarĩta catirãsama”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Titare Õꞌacʉ̃ yarã nimiꞌcãrã, na masã põꞌrã numia meꞌrã nʉmoticã, na põꞌrã pacarã waro, tutuarã nicãrã niwã. Beꞌropʉ quẽꞌrãrẽ na pãrãmerã nituriarã pacarã nicãrã niwã. Dʉporocjãrã narẽ ucũrã, “Nipeꞌtirã ãpẽrã masã yʉꞌrʉoro tutuarã, tʉꞌomasĩrã nima”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","7","Titare masã ñaꞌabutiaro weeseticãrã niwã. Ñaꞌarõ weese diaꞌcʉ̃rẽ wãcũcãrã niwã. Õꞌacʉ̃ na tojo weeseticã ĩꞌagʉ̃, narẽ ne tʉꞌsaticʉ niwĩ. “Yʉꞌʉ masãrẽ weeticã, añubopã”, ni wãcũcʉ niwĩ. Tojo ni, pũrõ bʉjawetise meꞌrã aꞌtiro nicʉ niwĩ: “Masã yʉꞌʉ weemiꞌcãrãrẽ cõꞌapeꞌocʉ̃ti. Tojo nicã waꞌicʉrã, nucũcãpʉ nirã́, wʉʉrã, nipeꞌtirãrẽ cõꞌapeꞌocʉ̃ti. Yʉꞌʉ pũrõ bʉjawetiꞌi. Yʉꞌʉ narẽ weeticã, añubopã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tojo nimigʉ̃, Noé cʉ̃ añurõ weesetisere ĩꞌagʉ̃, cʉ̃ meꞌrã pũrõ eꞌcaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Aꞌte Noé ye queti niꞌi. Noé añugʉ̃ nicʉ niwĩ. Õꞌacʉ̃ cʉ̃ dutíꞌcaronojõta weeseticʉ niwĩ. Masã nipeꞌtirã waꞌteropʉre cʉ̃ diaꞌcʉ̃ Õꞌacʉ̃ ʉaronojõ niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé iꞌtiarã põꞌrãticʉ niwĩ. Sẽ, Cã, Jafet wãmeticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ãpẽrã masã peꞌe Õꞌacʉ̃ ĩꞌacã peꞌema, ñaꞌase diaꞌcʉ̃ weecãrã niwã. Aꞌmewẽjẽse yʉꞌrʉa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Masã nipeꞌtirã ñaꞌarõ weesetirã diaꞌcʉ̃ nicãrã niwã. Na tojo weesetisere ĩꞌagʉ̃, ");
INSERT INTO tuoNT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Õꞌacʉ̃ Noerẽ́ aꞌtiro nicʉ niwĩ: “Yʉꞌʉ nipeꞌtirã masãrẽ cõꞌapeꞌocʉ̃ti. Na basu ñaꞌarõ weecã, aꞌti ʉmʉcopʉre aꞌmewẽjẽse yʉꞌrʉmajã waꞌaꞌa. Tojo weegʉ masã, diꞌtare miopeꞌocʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tojo weegʉ mʉꞌʉ aꞌtiro weeya. Yucʉsʉ pajipjʉjo weeya. Yucʉgʉ añucjʉ cjasere mii, aꞌmedoꞌoya. Tiwʉ poꞌpeapʉre peje tucũrĩ weeya. Aco sãjãrĩ nígʉ̃, buꞌire, poꞌpeapʉ quẽꞌrãrẽ ope meꞌrã añurõ biꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Aꞌtocãꞌrõ pajipjʉ weeya. Ciento treinta y cinco metro yoapjʉ nirõsaꞌa. Eꞌsaro peꞌe veintidos metro, ape metro deco nirõsaꞌa. Ʉꞌmʉarõ peꞌema trece metro, ape metro deco ʉꞌmʉapjʉ nirõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Iꞌtia casatipjʉ weeya. Tiwʉ dʉposãrĩpʉre añurõ moꞌaña. To moꞌaꞌcaro docare boꞌreyuse sãjãtjore dʉꞌaya. Niꞌcã metro deco dʉꞌabaqueꞌaya. Tojo nicã niꞌcã sope sãjãtji sopere weeya. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yʉꞌʉ aꞌti diꞌtare miogʉ̃tigʉ weeꞌe. Nipeꞌtirã aꞌti diꞌtacjãrã catise cʉorãnojõ mirĩ, wẽrĩpeꞌtia waꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Yʉꞌʉ mʉꞌʉ meꞌrã pũrĩcãrẽ añurõ wee, apogʉti. Mʉꞌʉ, mʉꞌʉ nʉmo, mʉꞌʉ põꞌrã ʉmʉa, na nʉmosãnumia meꞌrã tiwʉpʉre sãjã́árãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tojo nicã, mʉꞌʉ tiwʉpʉre aꞌticʉrã waꞌicʉrãrẽ miisãagʉ̃saꞌa. Nipeꞌtirã waꞌicʉrã aꞌti diꞌtapʉ nirãnʉcʉ̃ niꞌcʉ̃ ʉmʉ, niꞌcõ numio miisãagʉ̃saꞌa. Na, mʉsã meꞌrã nirãsama. Tojo weerã mʉꞌʉ meꞌrã waꞌicʉrã yʉꞌrʉwetirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mʉꞌʉ meꞌrã pʉarẽrã sãjã́árãsama. Waꞌicʉrãnʉcʉ̃, wʉʉrã, bʉarã, diꞌtapʉ sĩꞌcõsijarã quẽꞌrã sãjã́árãsama. Mʉꞌʉ weronojõta na quẽꞌrã yʉꞌrʉwetirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tojo nicã mʉꞌʉ tiwʉpʉ nígʉ̃ baꞌatjere miaña. Na waꞌicʉrã baꞌatje quẽꞌrãrẽ miaña”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noé nipeꞌtisere Õꞌacʉ̃ weedutiꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","2","Beꞌro Noerẽ́ Õꞌacʉ̃ aꞌtiro nicʉ niwĩ: “Nipeꞌtirã aꞌtocaterocjãrã masã ñaꞌarã nima. Mʉꞌʉ niꞌcʉ̃ta yʉꞌʉ dutisere queoro weegʉ́ niꞌi. Tojo weegʉ mʉꞌʉ acawererã meꞌrã yucʉsʉpʉ sãjãña. Waꞌicʉrã yʉꞌʉre ʉ̃jʉ̃amorõpeoajãrẽ siete ʉmʉa, siete numia tiwʉpʉre miisãaña. Ãpẽrã waꞌicʉrã baꞌatirãnojõ peꞌema nanʉcʉ̃ ʉmʉ, numio miisãaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mirĩcʉ̃a quẽꞌrãrẽ na ye cururinʉcʉ̃ siete ʉmʉa, siete numia miisãaña. Mʉꞌʉ tojo weecã, aꞌti nucũcãpʉre bajudutisome. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Siete nʉmʉrĩ beꞌro acoro pejanʉꞌcãcã weegʉti. Cuarenta ʉmʉcori, cuarenta ñamirĩ pejarosaꞌa. Nipeꞌtirã catirã yʉꞌʉ weemiꞌcãrãrẽ miocõꞌapeꞌocʉ̃ti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé nipeꞌtisere Õꞌacʉ̃ cʉ̃ weedutiꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Titare diꞌta mirĩcaterore Noé seisciento cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Dia mirĩsere yʉꞌrʉwetirãti nírã, Noé, cʉ̃ nʉmo, cʉ̃ põꞌrã ʉmʉa, na nʉmosãnumia meꞌrã tiwʉ yucʉsʉjopʉre sãjãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Na waꞌicʉrã nipeꞌtirã Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeoajã, baꞌatirãnojõ, wʉʉrã, bʉarã, diꞌtapʉ sĩꞌcõsijarã ");
INSERT INTO tuoNT_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Noé meꞌrã sãjãacãrã niwã. Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta waꞌicʉrã curarinʉcʉ̃ ʉmʉ, numio sãjãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Õꞌacʉ̃ cʉ̃ níꞌcaronojõta siete nʉmʉrĩ beꞌro acoro pejanʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Titare Noé seiscientos cʉ̃ꞌmarĩ cʉori curare maꞌma cʉ̃ꞌma nʉꞌcãrĩ mujĩpũ beꞌro cja mujĩpũ diecisiete nʉmʉrĩ ejari cura pejanʉꞌcãcaro niwʉ̃. Dia pajiri maa poꞌpeapʉ aco wijase peri pãrĩpeꞌtia waꞌacaro niwʉ̃. Aco ʉꞌmʉarõpʉ nise quẽꞌrã pajibutiaro pejacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Cuarenta ʉmʉcori, cuarenta ñamirĩ aꞌti diꞌtapʉre pejacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Aco pejanʉꞌcãrĩ nʉmʉrẽ Noé tiwʉjopʉre cʉ̃ nʉmo, cʉ̃ põꞌrã Sẽ, Cã, Jafet, na nʉmosãnumia sãjãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Na meꞌrã nipeꞌtirã waꞌicʉrã, ecarã, bʉarã, diꞌtapʉ sĩꞌcõsijarã, mirĩcʉ̃a, nipeꞌtirã wʉʉrã, te curarinʉcʉ̃ sãjãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Na waꞌicʉrã pʉarẽrã Noé meꞌrã tiwʉpʉre sãjãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Õꞌacʉ̃ Noerẽ́ dutiꞌcaronojõta na waꞌicʉrã curarinʉcʉ̃ ʉmʉ, numio sãjãacãrã niwã. Beꞌro na nipeꞌtirã sãjã́ca beꞌro Õꞌacʉ̃ sopere biꞌacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Cuarenta nʉmʉrĩ acoro pejacaro niwʉ̃. Siapeꞌe meꞌrã diꞌta mirĩa waꞌacaro niwʉ̃. Tojo weero tiwʉ yucʉsʉ wãꞌcãpaꞌa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Aco aꞌti diꞌtapʉre mirĩyʉꞌrʉa waꞌacaro niwʉ̃. Tiwʉ acopʉ paꞌsacusiacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Te aco nipeꞌtise ʉ̃rʉ̃pagʉ ʉꞌmʉasepagʉre yʉꞌrʉmʉjã waꞌaꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Te aco ʉ̃rʉ̃pagʉre siete metros yʉꞌrʉmʉjãnemocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tojo waꞌacã, masã aꞌti ʉmʉcopʉ nimiꞌcãrã mirĩpeꞌtia waꞌacãrã niwã. Mirĩcʉ̃a, waꞌicʉrã, ecarã, bʉarã, diꞌtapʉ sĩꞌcõsijarã mirĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nipeꞌtirã diꞌtapʉ nirã́, catise cʉomiꞌcãrã wẽrĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Noé, tojo nicã cʉ̃ meꞌrã tiwʉpʉ sãjãaꞌcãrã diaꞌcʉ̃ yʉꞌrʉcãrã niwã. Ãpẽrã tiwʉpʉ sãjãatiꞌcãrãpʉa masã, waꞌicʉrã, ecarã, mirĩcʉ̃a, bʉarã, diꞌtapʉ sĩꞌcõsijarã mirĩ, wẽrĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Te aco ciento cincuenta nʉmʉrĩ diꞌtapʉre wetiro marĩrõ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Na tiwʉpʉ nirĩ cura, Õꞌacʉ̃ Noerẽ́, waꞌicʉrã, cʉ̃ meꞌrã nirãrẽ wãcũcʉ niwĩ. Tojo weegʉ te acore wetidijato nígʉ̃, wĩꞌrõ wẽecã weecʉ niwĩ. Cʉ̃ tojo weese meꞌrã dia wetidijanʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Aco, dia pajiri maa poꞌpeapʉ wijase peri biꞌa waꞌacaro niwʉ̃. Tojo nicã, ʉꞌmʉarõpʉ pejaꞌque quẽꞌrã pejaduꞌucaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tojo weero dia pajiri maa wetidijaro weecaro niwʉ̃ majã. Ciento cincuenta nʉmʉrĩ aco pejanʉꞌcãca beꞌro dia wetidijacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ti cʉ̃ꞌmarẽta seis mujĩpũrĩ beꞌro cja mujĩpũ diecisiete nirĩ nʉmʉ tiwʉ yucʉsʉjo ʉ̃rʉ̃pagʉ Ararat wãmetisepagʉ buꞌipʉ wetiweepejacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dia wetidijanuꞌcũcaro niwʉ̃. Nueve mujĩpũrĩ beꞌro cja mujĩpũ nimʉꞌtãrĩ nʉmʉ nicã, ʉ̃rʉ̃pagʉ yapari bajuanʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Cuarenta nʉmʉrĩ beꞌrore Noé sope cʉ̃ wééca sopere pãocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Pãotojanʉꞌcõ, niꞌcʉ̃ yuca weronojõ bajugʉ ñigʉ̃, cuervo wãmetigʉre ti sopepʉ duꞌuwĩrõcʉ niwĩ. Cʉ̃ nipeꞌtiropʉ wʉʉcusiacʉ niwĩ. Téé diꞌta bajucãpʉ wʉʉcusiatʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Beꞌro, diꞌta bajutojati nígʉ̃, bujare duꞌuoꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Buja peꞌe ne cʉ̃ ejapejacjʉre bocaticʉ niwĩ. Dia ne wetidijapeꞌtiticaro niwʉ̃ yujupʉ. Tojo weegʉ buja Noé tiropʉ dajacãꞌcʉ niwĩ. Noé cʉ̃ omocãrẽ sĩowĩrõ, bujare ñeꞌe, tiwʉpʉta apaturi miisõrõcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Cʉ̃ siete nʉmʉrĩ yucuecʉ niwĩ. Beꞌro apaturi bujare duꞌuoꞌócʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Naꞌiqueꞌari cura buja cʉ̃ ẽꞌquẽapʉ niꞌcã pũrĩ olivo wãmeticjʉ pũrĩ cʉoꞌcʉ, Noé tiropʉ dajacʉ niwĩ. Tojo weegʉ Noé “Dia wetidijarota weesaꞌa”, ni masĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tojo nimigʉ̃, siete nʉmʉrĩ yucuenemocʉ niwĩ. Apaturi bujare oꞌócʉ niwĩ tja. Ti nʉmʉ waꞌaꞌcʉpʉta buja ne dajaticʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Titare Noé seiscientos uno cʉ̃ꞌmarĩ cʉogʉ nicã, dia añurõ wetipeꞌticaro niwʉ̃ majã. Maꞌma cʉ̃ꞌma nimʉꞌtãrĩ nʉmʉ nicã Noé tiwʉ yucʉsʉjo moꞌaꞌcarore pãacʉ niwĩ. Tore pãa, diꞌtare ĩꞌacʉ niwĩ. Diꞌta boporo weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ape mujĩpũ veintisiete nirĩ nʉmʉ nicã, diꞌta añurõ bopoa tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tojo weegʉ Õꞌacʉ̃ Noerẽ́ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Mʉꞌʉ, mʉꞌʉ nʉmo, mʉꞌʉ põꞌrã, na nʉmosãnumia meꞌrã wijaaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mʉꞌʉ meꞌrã níꞌcãrã waꞌicʉrã, mirĩcʉ̃a, ecarã, bʉarã, diꞌtapʉ sĩꞌcõsijarã, nipeꞌtirãrẽ wĩorẽpeꞌocãꞌña. Mʉꞌʉ tojo weecã, na aꞌti diꞌta nipeꞌtiropʉ waꞌarãsama. Na pãjãrã põꞌrãti, aꞌti diꞌtare tuuseꞌsanʉꞌcãrãsama”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Cʉ̃ tojo nicã tʉꞌogʉ, Noé Õꞌacʉ̃ dutiꞌcaronojõta weecʉ niwĩ. Noé, cʉ̃ nʉmo, cʉ̃ põꞌrã, na nʉmosãnumia tiwʉ yucʉsʉpʉ níꞌcãrã wijaacãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nipeꞌtirã waꞌicʉrã, bʉarã, diꞌtapʉ sĩꞌcõsijarã, mirĩcʉ̃a, tiwʉpʉ níꞌcãrã wijaapeꞌtia waꞌacãrã niwã. Te curarinʉcʉ̃ morẽrõ marĩrõ wijaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Beꞌro Noé Õꞌacʉ̃rẽ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeogʉti nígʉ̃, niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tore apopeꞌotoja, Õꞌacʉ̃rẽ ẽjõpeogʉ waꞌicʉrã, mirĩcʉ̃a añurãnojõrẽ wẽjẽ ʉ̃jʉ̃amorõpeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Õꞌacʉ̃ Noé tojo weecã ĩꞌagʉ̃, cʉ̃ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeocã ʉꞌmʉtisere wĩjĩgʉ̃, eꞌcaticʉ niwĩ. Tojo weegʉ aꞌtiro wãcũcʉ niwĩ: “Ne apaturi diꞌtare ñaꞌarõ weesome. Masã na ñaꞌarõ weese buꞌiri tojo weewʉ. Masã maata wĩꞌmarã nírãpʉta ñaꞌarõ weesere masĩtojasama. Nipeꞌtirã catise cʉorãrẽ ne apaturi yʉꞌʉ narẽ mioꞌcaro weronojõ weenemosome majã”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Apeye aꞌtiro nicʉ niwĩ: “Aꞌti ʉmʉco nirĩ curare masã ote, te dʉcare mii, baꞌanuꞌcũrãsama. Aꞌti nucũcãpʉre asise, yʉsʉase ninuꞌcũcãꞌrõsaꞌa. Cʉ̃ꞌma, puꞌecʉ quẽꞌrã ninuꞌcũcãꞌrõsaꞌa. Ʉmʉcori, ñamirĩ quẽꞌrã ne peꞌtisome. Tojo ninuꞌcũcãꞌrosaꞌa téé aꞌti ʉmʉco peꞌticãpʉ”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Õꞌacʉ̃ Noerẽ́, cʉ̃ põꞌrãrẽ “Añurõ waꞌato” nígʉ̃, aꞌtiro nicʉ niwĩ: “Pãjãrã põꞌrãti masãputiya. Nipeꞌtiropʉre tuuseꞌsanʉꞌcãña. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Niꞌcãrõacã meꞌrã nipeꞌtirã waꞌicʉrã aꞌti nucũcãcjãrã mʉsãrẽ uirãsama. Ʉꞌmʉarõpʉ wʉʉrã, diꞌtapʉ sĩꞌcõsijarã, bʉarã, dia pajiri maapʉ nirã́ nipeꞌtirã uirãsama. Mʉsã na wiorã nirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Todʉporo mʉsã otese, yucʉdʉca noꞌo nisenojõrẽ baꞌadutiꞌcaronojõta na quẽꞌrãrẽ mʉsã baꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Waꞌicʉ diꞌi baꞌarã, dí meꞌrã baꞌaticãꞌña. Aꞌtiro niꞌi. Te dípʉreta catise niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tojo weegʉ noꞌo niꞌcʉ̃ masʉ̃rẽ wẽjẽgʉ̃nojõrẽ buꞌiri daꞌredutigʉti. Noꞌo waꞌicʉ quẽꞌrã, masʉ̃rẽ wẽjẽgʉ̃nojõrẽ wẽjẽdutigʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","”Aꞌtiro niꞌi. Masã yʉꞌʉ weronojõ bajurã weenoꞌcãrã nima. Tojo weegʉ masãrẽ wẽjẽgʉ̃nojõ cʉ̃ quẽꞌrã wẽjẽnoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mʉsã peꞌe pãjãrã põꞌrãtiya. Aꞌti nucũcã nipeꞌtiropʉre tuuseꞌsaya”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Apeyere Õꞌacʉ̃ Noerẽ́, cʉ̃ põꞌrãrẽ ninemocʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Niꞌcãrõacã mʉsã meꞌrã aꞌtiro apogʉti. Mʉsã pãrãmerã nituriarã quẽꞌrãrẽ tojota weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tojo nicã nipeꞌtirã waꞌicʉrã mʉsã meꞌrã nirãrẽ apogʉti. Na mʉsã meꞌrã yucʉsʉpʉ níꞌcãrã mirĩcʉ̃a, waꞌicʉrã, ecarã, nʉcʉ̃cjãrã nipeꞌtirã meꞌrã apogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yʉꞌʉ mʉsã meꞌrã apoꞌque ne dʉcayusome. Aꞌtiro niꞌi. Masãrẽ, waꞌicʉrãrẽ ne apaturi aco meꞌrã miosome. Ne aꞌti diꞌtare tojo weenemosome. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yʉꞌʉ mʉsãrẽ, mʉsã pãrãmerã nituriarãrẽ, waꞌicʉrãrẽ ne apaturi tojo weesome majã nisere ĩꞌogʉ̃, aꞌtiro weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Oꞌmecuraripʉ buꞌedare cũugʉ̃ti. Ti da meꞌrã yʉꞌʉ aꞌti nucũcãpʉ nirã́ meꞌrã yʉꞌʉ apoꞌquere ĩꞌogʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tojo weero yʉꞌʉ acoro ñiacã weecã, buꞌeda bajuarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ti dare ĩꞌagʉ̃, mʉsã meꞌrã, tojo nicã nipeꞌtirã aꞌti nucũcãpʉ nirã́ meꞌrã yʉꞌʉ apoꞌquere wãcũgʉ̃saꞌa. Ne apaturi aco meꞌrã mʉsãrẽ miocõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ti da oꞌmecuraripʉ bajuacã, yʉꞌʉ ĩꞌagʉ̃saꞌa. Ĩꞌagʉ̃, yʉꞌʉ nipeꞌtirã masã meꞌrã, aꞌti nucũcãpʉ nirã́ meꞌrã ‘Yʉꞌʉ apoꞌque ne peꞌtisome’ níꞌquere wãcũgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ti da yʉꞌʉ masã, waꞌicʉrã, nipeꞌtirã aꞌti nucũcãpʉ nirã́ meꞌrã yʉꞌʉ apoꞌquere ĩꞌorĩ da nirõsaꞌa”, nicʉ niwĩ Õꞌacʉ̃ Noerẽ́. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé põꞌrã cʉ̃ meꞌrã yucʉsʉpʉ níꞌcãrã aꞌticʉrã nicãrã niwã: Sẽ, Cã, tojo nicã Jafet. Cã, Canaá pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Na iꞌtiarã Noé põꞌrã nicãrã niwã. Na nipeꞌtirã aꞌti nucũcãcjãrã ñecʉ̃sʉmʉa nicãrã niwã. Beꞌro na pãrãmerã nituriarã nipeꞌtiropʉ seꞌsa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé diꞌtare seꞌe apocũu, ʉꞌsere otecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Beꞌro, ʉꞌsedʉcaco meꞌrã vino daꞌre, sĩꞌrĩcʉ niwĩ. Tere sĩꞌrĩgʉ̃, queꞌa waꞌacʉ niwĩ. Tojo queꞌagʉ, cʉ̃ ya wiꞌi suꞌti caseri meꞌrã wééca wiꞌipʉ sãjãa, ejapeja, suꞌti marĩgʉ̃ pesacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cʉ̃ tojo pesari cura cʉ̃ macʉ̃ Cã sãjãa, ĩꞌacʉ niwĩ. Cã, Canaá pacʉ nicʉ niwĩ. Cã, cʉ̃ pacʉ Noerẽ́ suꞌti marĩcã ĩꞌagʉ̃, cʉ̃ maꞌmisʉmʉarẽ weregʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Cʉ̃ tojo werecã tʉꞌorã, Sẽ, Jafet niꞌcã casero, suꞌti caserojore paapeowãꞌcã, aperopʉ ĩꞌa, dustisãjãa, moꞌacãrã niwã. Na pacʉ suꞌti marĩgʉ̃ nicã ĩꞌasĩꞌrĩtirã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Beꞌro Noé cʉ̃ queꞌase peꞌticã, wãꞌcãcʉ niwĩ. Wãꞌcãgʉ̃, cʉ̃ macʉ̃ dʉꞌsagʉpʉ cʉ̃rẽ tojo weeꞌquere masĩgʉ̃, ");
INSERT INTO tuoNT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","aꞌtiro nicʉ niwĩ: “Cã macʉ̃ Canaárẽ ñaꞌarõ waꞌarosaꞌa. Cʉ̃ maꞌmisʉmʉarẽ daꞌracoꞌtegʉ nigʉ̃sami.” ");
INSERT INTO tuoNT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noé aꞌtiro ninemocʉ niwĩ: “Sẽ wiogʉ Õꞌacʉ̃rẽ ‘Añuyʉꞌrʉami’, ni eꞌcatipeoato. Canaá Sẽrẽ daꞌracoꞌtegʉ niato. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Õꞌacʉ̃ Jafere pajiri diꞌta oꞌoato. Cʉ̃ Sẽ meꞌrã añurõ nisetiato. Canaá peꞌe cʉ̃rẽ daꞌracoꞌtegʉ niato,” nicʉ niwĩ Noé. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Aꞌti diꞌta mírĩ́ca beꞌro Noé trescientos cincuenta cʉ̃ꞌmarĩ catinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Cʉ̃ novecientos cincuenta cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Aꞌte Sẽ, Cã, Jafet ye queti niꞌi. Aꞌti diꞌta mírĩ́ca beꞌrore Noé põꞌrã, Sẽ, Cã, Jafet na nʉmosãnumia meꞌrã põꞌrãticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet põꞌrã aꞌticʉrã nicãrã niwã: Nimʉꞌtãgʉ̃ Gomer wãmeticʉ niwĩ. Cʉ̃ beꞌrocjãrã Magog, Madai, Javán, Tubal, Mesec nicãrã niwã. Nitʉogʉ Tiras wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer, masã maꞌmi põꞌrã aꞌticʉrã nicãrã niwã: Cʉ̃ põꞌrãtimʉꞌtãꞌcʉ Askenaz wãmeticʉ niwĩ. Cʉ̃ beꞌrocjʉ̃ Rifat nicʉ niwĩ. Cʉ̃ beꞌrocjʉ̃ Togarma wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jafet macʉ̃ decocjʉ̃ Javán wãmetigʉ põꞌrã aꞌticʉrã nicãrã niwã: Elisa, Tarsis, Quitim, Dodanim wãmetirã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ãꞌrã nipeꞌtirã Jafet põꞌrã cʉ̃ ya curuacjãrã nicãrã niwã. Na dia pajiri maa sumutocjãrã nicãrã niwã. Na niatje diꞌtapʉ waꞌastea waꞌacãrã niwã. Te diꞌtapʉ nírã, te curarinʉcʉ̃ na ucũse meꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Noé macʉ̃ dʉꞌsagʉpʉ Cã wãmetigʉ põꞌrã aꞌticʉrã nicãrã niwã: Nimʉꞌtãgʉ̃ Cus wãmeticʉ niwĩ. Cʉ̃ beꞌrocjãrã Misraim, Fut, tojo nicã Canaá nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cã macʉ̃ nimʉꞌtãgʉ̃ Cus aꞌticʉrã põꞌrãticʉ niwĩ: Seba, Havila, Sabta, Raama, tojo nicã Sabteca nicãrã niwã. Raama põꞌrã Seba, Dedán wãmetirã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus wãmetigʉ Nimrod pacʉ nicʉ niwĩ. Cʉ̃ Nimrod nipeꞌtiropʉre aꞌmewẽjẽtutuagʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Õꞌacʉ̃ ĩꞌorõpʉre cʉ̃ waꞌicʉrã wẽjẽmuꞌsĩgʉ̃ nicʉ niwĩ. Tojo weero waꞌicʉrã wẽjẽmuꞌsĩgʉ̃nojõrẽ aꞌtiro ucũwʉase nicaro niwʉ̃: “Õꞌacʉ̃ ĩꞌorõpʉre Nimrod weronojõ waꞌicʉrãrẽ wẽjẽmuꞌsĩgʉ̃ nimi”, nicũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Cʉ̃ peje macãrĩ wiogʉ nicũcʉ niwĩ. Cʉ̃ ne waro dutiꞌque macãrĩ aꞌticʉse macãrĩ nicaro niwʉ̃: Babel, Erec, Acad, tojo nicã Calne nicaro niwʉ̃. Te macãrĩ Sinar wãmetiri diꞌtapʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Sinar wãmetiropʉ níꞌcʉ Asiria wãmetiri diꞌtapʉ waꞌacʉ niwĩ. Topʉre Nínive, Rehobot Ir, Cala wãmetise macãrĩ daꞌrecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Tojo nicã Resén wãmetiri macãrẽ daꞌrecʉ niwĩ. Ti macã, Nínive, Cala wãmetise macãrĩ waꞌteropʉ tojacaro niwʉ̃. Pajiri macã nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Cã macʉ̃ Misraim wãmetigʉ aꞌticʉse cururi ñecʉ̃ nicʉ niwĩ: ludeo masã, anameo masã, leabita masã, naftuita masã, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseo masã, casluhita masã, tojo nicã caftorita masã nicãrã niwã. Caftorita masã, filisteo masã ñecʉ̃sʉmʉa nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Cã macʉ̃ Canaá wãmetigʉ Sidṍ pacʉ nicʉ niwĩ. Sidṍ masã maꞌmi nicʉ niwĩ. Cʉ̃ docacjʉ̃ Het wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaá pãrãmerã nituriarã aꞌticʉrã nicãrã niwã: jebuseo masã, amorreo masã, gergeseo masã, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveo masã, araceo masã, sineo masã, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeo masã, zemareo masã, tojo nicã hamateo masã nicãrã niwã. Beꞌropʉre nipeꞌtirã Canaá ye cururicjãrã nipeꞌtiro na ya diꞌtapʉre seꞌsa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Na ya diꞌta Sidṍ wãmetiri macã meꞌrã ninʉꞌcãcaro niwʉ̃. Téé Gerar wãmetiri macãpʉ, tojo nicã Gazapʉ nitʉocaro niwʉ̃. Mujĩpũ mʉjãtiro peꞌe na ya diꞌta Sodoma, Gomorra, Adma, Zeboim, tojo nicã Lasapʉ nitʉocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ãꞌrã nipeꞌtirã Cã põꞌrã, cʉ̃ ya curuacjãrã nicãrã niwã. Na ye diꞌtapʉ nírã, te cururinʉcʉ̃ na ye ucũse meꞌrã niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Apĩ Noé macʉ̃ Sẽ quẽꞌrã põꞌrãticʉ niwĩ. Cʉ̃ Jafet maꞌmi nicʉ niwĩ. Sẽ nipeꞌtirã Heber põꞌrã nituriarã ñecʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sẽ põꞌrã aꞌticʉrã nicãrã niwã: Elam, Asur, Arfaxad, Lud, tojo nicã Aram nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram põꞌrã aꞌticʉrã nicãrã niwã: Uz, Hul, Geter, tojo nicã Mas wãmetirã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Sẽ macʉ̃ Arfaxad Sala pacʉ nicʉ niwĩ. Salata Heber pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Sala macʉ̃ Heber wãmetigʉ pʉarã põꞌrãticʉ niwĩ. Nimʉꞌtãgʉ̃ Peleg wãmeticʉ niwĩ. Peleg “dʉcawatise” nisĩꞌrĩrõ weeꞌe. Cʉ̃ nícateropʉre masã aꞌti diꞌtacjãrã dʉcawatinʉꞌcã waꞌacãrã niwã. Tojo weegʉ tojo wãmeticʉ niwĩ. Peleg acabiji Joctán wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Cʉ̃ Joctán pãjãrã põꞌrãticʉ niwĩ. Aꞌtiro wãmeticãrã niwã. Na masã maꞌmi Almodad nicʉ niwĩ. Cʉ̃ beꞌrore Selef, Hazar-mavet, Jera, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO tuoNT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, tojo nicã Jobab nicãrã niwã. Ãꞌrã nipeꞌtirã Joctán põꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Na Joctán põꞌrã na ya diꞌta Mesa wãmetiro meꞌrã ninʉꞌcãcaro niwʉ̃. Téé Sefar wãmetiro, ʉ̃rʉ̃pagʉ mujĩpũ mʉjãtiro peꞌe nirõpʉ nitʉocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ãꞌrã nipeꞌtirã, Sẽ põꞌrã, cʉ̃ ya curuacjãrã nicãrã niwã. Na ye diꞌtapʉ nírã, te cururinʉcʉ̃ na ye ucũse meꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noé põꞌrã nanʉcʉ̃ na pãrãmerã nituriarã meꞌrã nicũcãrã niwã. Te curarinʉcʉ̃ na ya diꞌtapʉre waꞌacãrã niwã. Tojo weerã aꞌti diꞌta mírĩ́ca beꞌro na nipeꞌtiropʉ waꞌastea waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Noé põꞌrã nituriarã nipeꞌtirã niꞌcãrõnojõ ucũseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Beꞌro majã masã mujĩpũ mʉjãtiro peꞌe waꞌa, Sinar wãmetiropʉ etacãrã niwã. Ti diꞌtapʉre añurĩ pa bocacãrã niwã. Topʉ na niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Topʉ nírã, niꞌcã nʉmʉ aꞌmerĩ ucũcãrã niwã: “Marĩ diꞌta cujirire daꞌrerã. Beꞌro te cujirire, añurõ bʉtiato nírã, pecameꞌepʉ ʉ̃jʉ̃arã”, nicãrã niwã. Na daꞌreꞌque cujiri meꞌrã wiꞌserire yeecãrã niwã. Ʉ̃tãpaga meꞌrã weeticãrã niwã. Tojo nicã ope meꞌrã yeemʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Beꞌro aꞌtiro nicãrã niwã: “Má, pajiri macã weerã́. Tojo nicã, niꞌcã wiꞌi téé ʉꞌmʉsepʉ ejari wiꞌi yeerã. Tojo weerã marĩ beꞌropʉre ãpẽrãrẽ añurõ ucũnoꞌrãsaꞌa. Marĩ tojo weerã aꞌti macãpʉre añurõ nisetirãsaꞌa. Ne aperopʉ waꞌastea waꞌa weesome”, nicãrã nimiwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Na tojo weeri cura Õꞌacʉ̃ peꞌe na tiropʉ dijati, na ya macã, tojo nicã na ʉꞌmʉarĩ wiꞌi na yeeri wiꞌijore ĩꞌagʉ̃ ejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Na tojo weesere ĩꞌagʉ̃, aꞌtiro nicʉ niwĩ: “Na niꞌcã curuacjãrã nima. Niꞌcãrõnojõ ucũma. Tojo weerã aꞌtere daꞌranʉꞌcãtojama. Na tojo daꞌranʉꞌcãse ne nʉꞌcãse niꞌi. Aꞌte beꞌro noꞌo na weesĩꞌrĩsere weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tojo weerã na tiro dija, na ucũse peꞌere dʉcayurã. Tojo weecã, na aꞌmerĩ ucũmasĩti, aꞌmerĩ tʉꞌosome”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tojo weegʉ Õꞌacʉ̃ masã ucũsere dʉcayucʉ niwĩ. Na aꞌmerĩ tʉꞌotiyurã, ti macãrẽ weeduꞌucãꞌcãrã niwã. Nipeꞌtiro aꞌti diꞌtapʉ waꞌastea waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Titare ti macãpʉre Õꞌacʉ̃ nipeꞌtirã masãrẽ ucũsuꞌriacã weecʉ niwĩ. Tojo weero ti macã Babel wãmeticaro niwʉ̃. Õꞌacʉ̃ tojo weegʉ narẽ nipeꞌtiropʉ waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Aꞌte Sẽ ye queti niꞌi. Pʉa cʉ̃ꞌma dia mírĩ́ca beꞌro Sẽ cien cʉ̃ꞌmarĩ cʉocʉ niwĩ. Ticʉse cʉ̃ꞌmarĩ cʉocã, cʉ̃ nʉmo niꞌcʉ̃ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃ Arfaxad wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Beꞌro Sẽ cien cʉ̃ꞌmarĩ cʉóca beꞌrore quinientos cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Cʉ̃ põꞌrãtimʉꞌtãꞌcʉ Arfaxad nʉmoti, niꞌcʉ̃ põꞌrãticʉ niwĩ. Cʉ̃ macʉ̃ bajuácaterore treinta y cinco cʉ̃ꞌmarĩ cʉocʉ niwĩ. Cʉ̃ macʉ̃ Sala wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Beꞌro Arfaxad cuatrocientos tres cʉ̃ꞌmarĩ catinemocʉ niwĩ. Pãjãrã ãpẽrã ʉmʉa, numia põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Cʉ̃ macʉ̃ Sala nʉmoticʉ niwĩ. Cʉ̃ nʉmo niꞌcʉ̃ põꞌrãtico niwõ. Cʉ̃ wĩꞌmagʉ̃ bajuácaterore Sala treinta cʉ̃ꞌmarĩ cʉocʉ niwĩ. Cʉ̃ macʉ̃ Heber wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Beꞌro Sala cuatrocientos tres cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Sala macʉ̃ Heber treinta y cuatro cʉ̃ꞌmarĩ cʉocã, cʉ̃ nʉmo niꞌcʉ̃ wĩꞌmagʉ̃rẽ põꞌrãtico niwõ. Cʉ̃ Peleg wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg bajuáca beꞌrore Heber cuatrocientos treinta cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Heber macʉ̃ Peleg nʉmoticʉ niwĩ. Nʉmoti, niꞌcʉ̃ wĩꞌmagʉ̃ põꞌrãticʉ niwĩ. Cʉ̃ Reu wãmeticʉ niwĩ. Reu bajuácaterore Peleg treinta cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Te beꞌro Peleg doscientos nueve cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Peleg macʉ̃ Reu nʉmoti, niꞌcʉ̃ põꞌrãticʉ niwĩ. Cʉ̃ Serug wãmeticʉ niwĩ. Cʉ̃ bajuácaterore Reu treinta y dos cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Beꞌro Reu doscientos siete cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Reu macʉ̃ Serug nʉmoti, niꞌcʉ̃ macʉ̃ticʉ niwĩ. Cʉ̃ wĩꞌmagʉ̃ Nacor wãmeticʉ niwĩ. Cʉ̃ bajuácaterore Serug treinta cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Cʉ̃ bajuáca beꞌro Serug doscientos cʉ̃ꞌmarĩ catinemocʉ niwĩ. Ãpẽrã pãjãrã ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Serug macʉ̃ Nacor niꞌcʉ̃ macʉ̃ticʉ niwĩ. Cʉ̃ Taré wãmeticʉ niwĩ. Cʉ̃ macʉ̃ bajuácaterore Nacor veintinueve cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Beꞌro Taré bajuáca beꞌro Nacor ciento diecinueve cʉ̃ꞌmarĩ catinemocʉ niwĩ. Te cʉ̃ꞌmarĩrẽ ʉmʉa, numia põꞌrãtinemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Nacor macʉ̃ Taré setenta cʉ̃ꞌmarĩ cʉogʉ, niꞌcʉ̃ Abrã wãmetigʉre põꞌrãticʉ niwĩ. Beꞌro pʉarã põꞌrãtinemocʉ niwĩ. Nacor, Harã́ wãmeticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Aꞌte Taré ye queti niꞌi. Taré iꞌtiarã ʉmʉa põꞌrãticʉ niwĩ. Na Abrã, Nacor, Harã́ nicãrã niwã. Harã́ macʉ̃ Lot nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harã́ cʉ̃ pacʉ Taré dʉporo wẽrĩcʉ niwĩ. Ur wãmetiri macãpʉ wẽrĩcʉ niwĩ. Ti macã caldeo masã nirĩ diꞌtapʉ tojacaro niwʉ̃. Harã́ cʉ̃ bajua, masãꞌcaropʉta wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abrã, tojo nicã Nacor nanʉcʉ̃ nʉmoticãrã niwã. Abrã nʉmo Sarai wãmetico niwõ. Nacor nʉmo Milca nico niwõ. Milca Harã́ mijĩ macõ nico niwõ. Apego Isca wãmetigore põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Co Sarai Abrã nʉmo põꞌrãmarĩgõnojõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Beꞌro majã Taré Ur wãmetiri macã caldeo masã nirĩ diꞌtapʉ níꞌcʉ Canaá wãmetiri diꞌtapʉ waꞌacʉ niwĩ. Topʉ waꞌacã, cʉ̃ macʉ̃ Abrã, cʉ̃ pãrãmi Lot Harã́ mijĩ macʉ̃, tojo nicã Abrã nʉmo Sarai cʉ̃ meꞌrã waꞌacãrã niwã. Canaá diꞌtapʉ waꞌamirã, na Harã́ wãmetiri macãpʉ eta, topʉ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","To Harã́pʉre Taré doscientos cinco cʉ̃ꞌmarĩ cʉogʉ, wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Niꞌcã nʉmʉ Õꞌacʉ̃ Abrãrẽ pijio weetjĩagʉ̃, aꞌtiro nicʉ niwĩ: “Mʉꞌʉ ya diꞌtare, mʉꞌʉ acawererãrẽ, mʉꞌʉ pacʉ ya wiꞌire wijayá. Ape diꞌtapʉ mʉꞌʉ waꞌagʉsaꞌa. Yʉꞌʉ mʉꞌʉrẽ ti diꞌtare ĩꞌogʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mʉꞌʉ pãrãmerã nituriarã pãjãrã masãputicã weegʉti. Mʉꞌʉrẽ añurõ weegʉti. Nipeꞌtirã masã mʉꞌʉrẽ añurõ wãcũrãsama. Mʉꞌʉ meꞌrã ãpẽrã quẽꞌrãrẽ añurõ waꞌarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Masã mʉꞌʉrẽ añurõ nirãrẽ añurõ waꞌacã weegʉti. Noꞌo mʉꞌʉrẽ ñaꞌarõ waꞌacã weerã́ peꞌere yʉꞌʉ narẽ ñaꞌarõ waꞌacã weegʉti. Mʉꞌʉ meꞌrã nipeꞌtirã aꞌti turicjãrãrẽ añurõ waꞌacã weegʉti”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tojo weegʉ Abrã Õꞌacʉ̃ dutiꞌcaronojõta Harã́rẽ wijawãꞌcãcʉ niwĩ. Titare cʉ̃ setenta y cinco cʉ̃ꞌmarĩ cʉocʉ niwĩ. Topʉ wija, Canaá diꞌtapʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Cʉ̃ waꞌagʉ, aꞌticʉrãrẽ miacʉ niwĩ. Cʉ̃ nʉmo Sarai, cʉ̃ acabiji macʉ̃ Lot, apeyenojõ cʉ̃ cʉoꞌque, tojo nicã cʉ̃rẽ Harã́pʉ daꞌracoꞌteꞌcãrãrẽ miacʉ niwĩ. Na waꞌa, Canaá diꞌtare etacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Eta, Abrã Siquem wãmetiri macãpʉ yʉꞌrʉwãꞌcãcʉ niwĩ. Ti macã pʉꞌto niꞌcʉ̃ yucʉgʉ pajicjʉ More wãmeticjʉ nicaro niwʉ̃. Tigʉ pʉꞌto Abrã tojaqueꞌacʉ niwʉ̃. Tocjãrã tigʉ pʉꞌto na ẽjõpeorãnojõrẽ ẽjõpeoseticãrã niwã. Ti diꞌtapʉre cananeo masã nicũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Cʉ̃ topʉ nicã, Õꞌacʉ̃ cʉ̃rẽ bajuacʉ niwĩ. Abrãrẽ aꞌtiro nicʉ niwĩ: “Aꞌti diꞌta yʉꞌʉ mʉꞌʉ pãrãmerã nituriarãrẽ oꞌoatji diꞌta niꞌi”, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌogʉ, Abrã to cʉ̃rẽ bajuaꞌcaropʉta waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Õꞌacʉ̃rẽ ẽjõpeogʉ, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Topʉ níꞌcʉ, ʉ̃rʉ̃pagʉ nirṍ Betel wãmetiri macã mujĩpũ mʉjãtiro peꞌe waꞌacʉ niwĩ. Topʉ na cãrĩatje wiꞌserire nʉꞌcõcʉ niwĩ. Betel mujĩpũ sãjãrõ peꞌe tojacaro niwʉ̃. Ape macã Hai wãmetiri macã mujĩpũ mʉjãtiro peꞌe nicaro niwʉ̃. Topʉ quẽꞌrãrẽ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Seeneocũutojanʉꞌcõ, Õꞌacʉ̃rẽ eꞌcatise oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Beꞌro Abrã Betel pʉꞌto níꞌcʉ wijawãꞌcãcʉ niwĩ. Cʉ̃ sojaro marĩrõ waꞌa, téé Neguev wãmetiropʉ etacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Abrã Neguepʉ nirĩ cura baꞌase marĩcaro niwʉ̃. Pũrõ ʉjʉaboase waꞌacã ĩꞌagʉ̃, Abrã Egiptopʉ waꞌa waꞌacʉ niwĩ. “Topʉ baꞌase niaporo” nicã tʉꞌotjĩagʉ̃, waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Beꞌro Egipto diꞌtapʉ etarã, Abrã cʉ̃ nʉmo Saraire aꞌtiro nicʉ niwĩ: “Yʉꞌʉ ĩꞌacã, mʉꞌʉ numio añugõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Egiptocjãrã mʉꞌʉrẽ ĩꞌarã, ‘Aꞌtigo ãꞌrĩ nʉmo nimo’, nirãsama. Mʉꞌʉrẽ ẽꞌmasĩꞌrĩrã, yʉꞌʉre wẽjẽrãsama. Mʉꞌʉ meꞌrã nisĩꞌrĩrã, mʉꞌʉrẽ wẽjẽsome. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tojo weego mʉꞌʉ, ‘Cʉ̃ nʉmo niꞌi’, niticãꞌña. ‘Yʉꞌʉ cʉ̃ acabijo niꞌi’, niña. Mʉꞌʉ tojo weecã, mʉꞌʉrẽ ʉarã, yʉꞌʉre añurõ weerãsama. Tojo nicã yʉꞌʉre wẽjẽsome”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Cʉ̃ níꞌcaronojõ Abrã, Sarai Egiptopʉ etacã, tocjãrã Saraire ĩꞌarã, “Añugõ nimo”, ni ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ti macã wiogʉ faraṍ cʉ̃ docacjãrã core ĩꞌarã, faraṍrẽ, “Co numio añubutiago niamo”, ni werecãrã niwã. Tojo weerã core faraṍ tiropʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","“Sarai maꞌmi nisami” ni wãcũgʉ̃, faraṍ Abrãrẽ añurõ weecʉ niwĩ. Cʉ̃rẽ pãjãrã ecarã, ovejare, wecʉare, burroare, cameyoare tojo oꞌocãꞌcʉ niwĩ. Tojo nicã daꞌracoꞌteri masã, ʉmʉarẽ, numiarẽ cʉ̃rẽ oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Saraire faraṍ tiropʉ miaꞌque buꞌiri Õꞌacʉ̃ faraṍrẽ, cʉ̃ ya wiꞌicjãrãrẽ dutitícã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tojo waꞌacã ĩꞌagʉ̃, faraṍ Abrãrẽ pijio, cʉ̃rẽ nicʉ niwĩ: “¿Deꞌro weegʉ mʉꞌʉ tojo weeati yʉꞌʉre? ¿Deꞌro weegʉ ‘Aꞌtigo yʉꞌʉ nʉmo nimo’, nitiati? ");
INSERT INTO tuoNT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘Yʉꞌʉ acabijo nimo’, nimiapʉba. Tere tʉꞌogʉ, yʉꞌʉ core cãꞌrõ nʉmotimiasʉ. ¡Ma! Aꞌtigo nimo. Core miaña. Mʉꞌʉ quẽꞌrã waꞌaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraṍ cʉ̃ yarã surarare Abrãrẽ, cʉ̃ nʉmorẽ, tojo nicã nipeꞌtise cʉ̃ cʉose meꞌrã Egiptopʉre wĩorẽdutigʉ oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abrã, cʉ̃ nʉmo, nipeꞌtirã cʉ̃ cʉose meꞌrã Egiptopʉ wijagʉ, na todʉporopʉ níꞌcaropʉta Neguev wãmetiropʉ dajacʉ niwĩ. Cʉ̃ acabiji macʉ̃ Lot na meꞌrã waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrã peje waro cʉocʉ niwĩ. Cʉ̃ uru, plata, tojo nicã pãjãrã ecarã cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Neguepʉ níꞌcãrã sojaro marĩrõ dajatojaa waꞌacãrã niwã téé Betel wãmetiri macãpʉ. Betere yʉꞌrʉa, ne waro aꞌtigʉ cʉ̃ cãrĩꞌcaropʉre ejacʉ niwĩ. To Betel, Hai decopʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Todʉporopʉre Õꞌacʉ̃rẽ eꞌcatise oꞌogʉti nígʉ̃, waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Topʉta Abrã Õꞌacʉ̃rẽ apaturi eꞌcatise oꞌocʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Cʉ̃ acabiji macʉ̃ Lot quẽꞌrã Abrã weronojõta peje cʉocʉ niwĩ. Pãjãrã ecarã oveja, wecʉa tojo nicã pãjãrã daꞌracoꞌterã cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Na nirṍ pajiro diꞌta niticaro niwʉ̃. Tojo weero na pãjãrãrẽ baꞌase ne ejatuꞌajaticaro niwʉ̃. Na niꞌcãrõ meꞌrã nímasĩticãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abrã yarã ecarã coꞌterã, Lot yarã ecarã coꞌterã meꞌrã aꞌmetuꞌticũcãrã niwã. Apeyema tja, titare cananeo masã, tojo nicã ferezeo masã topʉre nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tojo weegʉ Abrã cʉ̃ acabiji macʉ̃ Lot meꞌrã aꞌtiro ni ucũcʉ niwĩ: “Marĩ niꞌcʉ̃ põꞌrã niꞌi. Tojo weerã marĩ cumuca marĩrõ nirõʉaꞌa. Marĩ yarã ecarã coꞌterã quẽꞌrã mejãrõta nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tojo weerã marĩrẽ dʉcawaaroʉaꞌa. Nipeꞌtiro aꞌti diꞌtare ĩꞌaña. Mʉꞌʉ tʉꞌsarore ‘Aꞌtota nigʉ̃ti’ ni, beseya. Mʉꞌʉ mujĩpũ mʉjãtiro nirĩ diꞌta peꞌe waꞌacã, yʉꞌʉ mujĩpũ sãjãrõ nirĩ diꞌta peꞌere waꞌagʉti. Mʉꞌʉ mujĩpũ sãjãrõ peꞌe waꞌacã pũrĩcãrẽ, yʉꞌʉ mujĩpũ mʉjãtiro peꞌe waꞌagʉti”, nicʉ niwĩ Abrã. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Cʉ̃ tojo nicã tʉꞌogʉ, Lot nipeꞌtiro dia Jordã́ wãmetiri maa sumuto nirĩ diꞌtare ĩꞌacʉ niwĩ. Téé Zoar wãmetiri macãpʉ opa paꞌtiro añurõ acotiro nicã ĩꞌacʉ niwĩ. Añurĩ diꞌta Õꞌacʉ̃ ne waro wééca wese weronojõ nicaro niwʉ̃. Egipto diꞌta weronojõ bajumeꞌrĩcãꞌcaro niwʉ̃. Õꞌacʉ̃ Sodoma, Gomorrare ʉ̃jʉ̃acõꞌatjo dʉporo añurõ bajucaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot ti diꞌta añurĩ diꞌta nicã ĩꞌagʉ̃, nipeꞌtiro Jordã́ sumuto nirĩ diꞌtare besecʉ niwĩ. Abrãrẽ, “Mujĩpũ mʉjãtiro peꞌe waꞌagʉti”, nicʉ niwĩ. Na pʉarã niꞌcãrõ meꞌrã nimiꞌcãrã aꞌmerĩ dʉcawatia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrã Canaápʉ tojacʉ niwĩ. Lot peꞌe macãrĩ pʉꞌto añurĩ pa nirõpʉ tojacʉ niwĩ. Cʉ̃ ye wiꞌseri suꞌti caseri meꞌrã weeꞌque wiꞌserire Sodoma pʉꞌtopʉ nʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ti macãcjãrã masã ñaꞌabutiarã Õꞌacʉ̃ cʉ̃ dutítisenojõrẽ weeseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Beꞌro Lot waꞌáca beꞌro Õꞌacʉ̃ Abrãrẽ aꞌtiro nicʉ niwĩ: “Mʉꞌʉ nirṍ meꞌrã nipeꞌtiropʉre ĩꞌaña. Mujĩpũ mʉjãtiro peꞌe, mujĩpũ sãjãrõ peꞌe, diacjʉ̃ peꞌe, cũpe peꞌe añurõ ĩꞌaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nipeꞌtiro mʉꞌʉ ĩꞌáca diꞌtare mʉꞌʉrẽ oꞌogʉti. Mʉꞌʉrẽ, mʉꞌʉ pãrãmerã nituriarãrẽ oꞌogʉti. Mʉsã ye diꞌta ninuꞌcũrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mʉꞌʉ pãrãmerã nituriarã pãjãrã waro nirãsama. Nucũpori queota basiotise weronojõ mʉꞌʉ pãrãmerã nituriarã quẽꞌrãrẽ ne queopõtẽota basiotirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nipeꞌtiro aꞌti diꞌtare sijawãꞌcãñaꞌrẽ. ¿Noꞌocãꞌrõ yoati, noꞌocãꞌrõ eꞌsati? ni ĩꞌañaꞌrẽ. Aꞌti diꞌtare mʉꞌʉrẽ oꞌogʉ weeꞌe. Tojo weegʉ nipeꞌtiro ĩꞌagʉ̃ waꞌaya”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tojo weegʉ Abrã niꞌcʉ̃ masʉ̃ Mamre wãmetigʉ pʉꞌto waꞌacʉ niwĩ. Yucʉ pacasepagʉ nirṍ tojaqueꞌacʉ niwĩ. Topʉ cʉ̃ ye wiꞌseri suꞌti caseri meꞌrã weeꞌque wiꞌserire nʉꞌcõcʉ niwĩ. To Hebrṍ wãmetiri macã pʉꞌtopʉ nicaro niwʉ̃. Topʉ Õꞌacʉ̃rẽ ẽjõpeogʉti nígʉ̃, waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Titare Amrafel Sinar wãmetiri diꞌtare dutigʉ nicʉ niwĩ. Tojo nicã Arioc wãmetigʉ Elasar wãmetirore duticʉ niwĩ. Apĩ Quedorlaomer Elam wãmetiri diꞌtare duticʉ niwĩ. Apĩ wiogʉ Tidal wãmetigʉ Goim wãmetirore dutigʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ãꞌrã baꞌparitirã wiorã ape diꞌtacjãrã meꞌrã aꞌmewẽjẽrã waꞌacãrã niwã. Na meꞌrã aꞌmewẽjẽajã aꞌticʉrã nicãrã niwã: Bera wãmetigʉ Sodomacjãrã wiogʉ, apĩ Birsa wãmetigʉ Gomorracjãrã wiogʉ, apĩ Sinab wãmetigʉ Admacjãrã wiogʉ, apĩ Semeber wãmetigʉ Zeboĩcjãrã wiogʉ, tojo nicã Bela wãmetirocjãrã wiogʉ nicãrã niwã. Apeterore Bela wãmetiri macã Zoar pisunoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ãꞌrã niꞌcãmocʉse macãrĩcjãrã na yarã surarare Sidim wãmetiropʉ neonʉꞌcõcãrã niwã. Sidim diacjʉ̃ca pa, ditara Oꞌmabʉrotiri ditara sumutopʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Todʉporo na yoacã doce cʉ̃ꞌmarĩ Quedorlaomer wãmetigʉ Elãcjãrã wiogʉ dutise doca nicãrã niwã. Beꞌro majã trece cʉ̃ꞌmarĩ waꞌaboronojõ cʉ̃ dutisere weenemosĩꞌrĩtirã, cʉ̃ meꞌrã aꞌmewẽjẽrãtirã, na basu apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ape cʉ̃ꞌma Quedorlaomer cʉ̃ meꞌrã nirã́ wiorã Astarot Karnaim wãmetiropʉ waꞌacãrã niwã. Topʉre waꞌa, refaíta masãrẽ aꞌmewẽjẽ wapataꞌacãrã niwã. Beꞌro, Ham wãmetiropʉre zuzita masãrẽ aꞌmewẽjẽ wapataꞌacãrã niwã. Tojo nicã emita masã quẽꞌrãrẽ Save-quiriataim wãmetiropʉre aꞌmewẽjẽ wapataꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Beꞌrore horeo masãrẽ ʉ̃rʉ̃pagʉ Seir wãmeticjʉpʉ wẽjẽsirutuwãꞌcãcãrã niwã téé El-parán wãmetiri papʉ. Ti pa yucʉ marĩrõpʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Beꞌro totá Quedorlaomer, tojo nicã cʉ̃ meꞌrã waꞌaꞌcãrã majãmitojaticãrã niwã. Tojatirã, En-mispat wãmetiropʉ etacãrã niwã. Apeterore En-mispat Cades pisunoꞌcaro niwʉ̃. Tojo weerã, nipeꞌtirã na noꞌo bocaejarãrẽ amaleca masã na nirõpʉ wẽjẽcõꞌapeꞌowãꞌcãcãrã niwã. Mejãrõta amorreo masã quẽꞌrãrẽ wẽjẽcãrã niwã. Amorreo masã Hazezon-tamar wãmetiropʉ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Beꞌro na tojo weesere tʉꞌorã, ãpẽrã niꞌcãmocʉrã wiorã Sodomacjʉ̃, Gomorracjʉ̃, Admacjʉ̃, Zeboĩcjʉ̃, Belacjʉ̃ na yarã surara meꞌrã Sidim wãmetiri papʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Topʉ na baꞌparitirã wiorã meꞌrã aꞌmewẽjẽrãtirã waꞌacãrã niwã. Na meꞌrã aꞌmewẽjẽajã peꞌe, aꞌticʉrã nicãrã niwã: Quedorlaomer Elam wãmetirocjʉ̃, Tidal Goim wãmetirocjʉ̃, Amrafel Sinar wãmetirocjʉ̃, tojo nicã Arioc, Elasar wãmetirocjʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Topʉ na aꞌmewẽjẽatjopʉ Sidim wãmetiri papʉre ope coperi peje nicaro niwʉ̃. Pʉarã wiorã Sodomacjʉ̃, Gomorracjʉ̃ aꞌmewẽjẽrõpʉ omaduꞌtimirã, te coperipʉ bʉrʉsãjãdijacãrã niwã. Na meꞌrãcjãrã ãpẽrã wiorã peꞌe ʉ̃rʉ̃pagʉpʉ duꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tojo weerã na duꞌtisteaca beꞌro Quedorlaomer quẽꞌrã nipeꞌtise Sodoma, Gomorrapʉ nimiꞌque baꞌase, apeyenojõ wapabʉjʉse nimiꞌquere miicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot Abrã acabiji macʉ̃rẽ Sodomapʉ nise buꞌiri ñeꞌe, cʉ̃ ye nipeꞌtise meꞌrã miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Niꞌcʉ̃ na aꞌmewẽjẽꞌcaropʉ níꞌcʉ Abrã tiropʉ omaduꞌtiwãꞌcãcʉ niwĩ. Abrã hebreo masʉ̃ nicʉ niwĩ. Abrãrẽ Lore na miaꞌquere werecʉ niwĩ. Abrã nirṍ pʉꞌto niꞌcʉ̃ Mamre wãmetigʉ amorreo masʉ̃ nicʉ niwĩ. Cʉ̃ nirṍ yucʉ pacasepagʉ nirṍ nicaro niwʉ̃. Mamre acabijirã Escol, tojo nicã Aner nicãrã niwã. Na quẽꞌrã Abrã meꞌrã añurõ niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abrã cʉ̃ acabiji macʉ̃rẽ “Ñeꞌe, mia waꞌama” nisere tʉꞌogʉ, cʉ̃ tiro masãꞌcãrã, cʉ̃rẽ daꞌracoꞌterãrẽ neocũucʉ niwĩ. Tojo weetjĩagʉ̃, Lore miaꞌcãrãrẽ sirutucʉ niwĩ. Abrã meꞌrã waꞌaꞌcãrã trescientos dieciocho ʉmʉa nicãrã niwã. Na sirutuwãꞌcã, téé Dan wãmetiropʉ wiorãrẽ bocaejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Narẽ bocaeja, wiorã ne masĩtiri cura ñamipʉ Abrã cʉ̃ masã meꞌrã aꞌmewẽjẽnʉꞌcãcãrã niwã. Na wiorã tojo weecã ĩꞌarã, duꞌtia waꞌacãrã niwã. Abrã quẽꞌrã narẽ sirutuwãꞌcãcãrã niwã téé Hoba wãmetiropʉ. Ti macã Damasco wãmetiri macã yʉꞌrʉropʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Narẽ sirutu, nipeꞌtise na miaꞌquere ẽꞌmapeꞌocãꞌcãrã niwã. Aꞌtiro wee, Abrã Lot cʉ̃ acabiji macʉ̃rẽ, cʉ̃ ye nipeꞌtise meꞌrã wijataꞌacʉ niwĩ. Tojo nicã numia, ãpẽrã na miaꞌcãrãrẽ wijataꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abrã Quedorlaomer quẽꞌrãrẽ aꞌmewẽjẽ wapataꞌaca beꞌro dajatojaacʉ niwĩ. Cʉ̃ dajari cura Save wãmetiri papʉ Sodomacjʉ̃ wiogʉ cʉ̃rẽ põtẽrĩgʉ̃ ejacʉ niwĩ. Save wãmetiri pa, wiogʉ ya pa nisĩꞌrĩrõ weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Apĩ Melquisedec, Salem wãmetiri macãcjʉ̃ wiogʉ nicʉ niwĩ. Tojo nicã cʉ̃ paꞌi Õꞌacʉ̃ nipeꞌtirã buꞌipʉ nigʉ̃rẽ ẽjõpeogʉ nicʉ niwĩ. Cʉ̃ pã́, tojo nicã ʉꞌsedʉcaco vinorẽ miiti, ");
INSERT INTO tuoNT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abrãrẽ oꞌogʉ, aꞌtiro nicʉ niwĩ: “Õꞌacʉ̃ nipeꞌtirã buꞌipʉ nigʉ̃́, ʉꞌmʉse, aꞌti diꞌtare weeꞌcʉ mʉꞌʉrẽ añurõ weeato. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Õꞌacʉ̃ nipeꞌtirã buꞌipʉ nigʉ̃rẽ ‘Añuꞌu’, nírã. Mʉꞌʉrẽ ĩꞌatuꞌtiꞌcãrãrẽ aꞌmewẽjẽ wapataꞌacã weecʉ niami.” Cʉ̃ tojo níca beꞌro Abrã cʉ̃ aꞌmewẽjẽ wapataꞌaꞌquere diez mesãrĩ dʉcawaacũucʉ niwĩ. Niꞌcã mesãrẽ Melquisedere oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tojo wééca beꞌro Sodomacjʉ̃ wiogʉ Abrãrẽ nicʉ niwĩ: —Mʉꞌʉ wijataꞌaꞌque mʉꞌʉ yeta tojato. Masã diaꞌcʉ̃rẽ yʉꞌʉre wiaya. Apeꞌquema mʉꞌʉ miaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abrã peꞌe Melquisedere yʉꞌticʉ niwĩ: —Õꞌacʉ̃ nipeꞌtirã buꞌipʉ nigʉ̃́ ʉꞌmʉsere, aꞌti diꞌtare weeꞌcʉre cʉ̃ tʉꞌoropʉ mʉꞌʉ ye cjasere ucũtojapʉ: ");
INSERT INTO tuoNT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","“Ne cãꞌrõ mʉꞌʉ ye apeyenojõ meꞌrã tojasome. Ne niꞌcã yuta da, ne niꞌcã da sapatu dʉꞌteri danojõrẽ miasome. Yʉꞌʉ miacãma, beꞌropʉre mʉꞌʉ yʉꞌʉre aꞌtiro nibosaꞌa, ‘Yʉꞌʉ cʉ̃rẽ niyerubʉcʉ waꞌacã weewʉ’, nibosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tojo weegʉ yʉꞌʉ peꞌe ne apeyenojõ mʉꞌʉ yere miasome. Yʉꞌʉ meꞌrã waꞌaꞌcãrã na baꞌaꞌquema dʉcayuya. Tojo nicã, yʉꞌʉre baꞌpatiꞌcãrã pũrĩcã Aner, Escol, Mamre na ʉasere miarãsama”, nicʉ niwĩ Abrã. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Beꞌro nipeꞌtise tojo waꞌáca beꞌro Õꞌacʉ̃ quẽꞌerõpʉ Abrãrẽ aꞌtiro ni ucũcʉ niwĩ: —Abrã, uiticãꞌña. Yʉꞌʉ mʉꞌʉrẽ coꞌtegʉti. Mʉꞌʉrẽ peje añuse oꞌogʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Cʉ̃ tojo nicã tʉꞌogʉ, Abrã peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Õꞌacʉ̃, yʉꞌʉ wiogʉ, ¿ñeꞌe meꞌrã yʉꞌʉre añurõ weebosari? Mʉꞌʉ masĩꞌi; yʉꞌʉ põꞌrã marĩꞌi. Tojo weecã, yʉꞌʉ cʉose Eliezer Damascocjʉ̃ cʉosirutugʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Mʉꞌʉ yʉꞌʉre põꞌrã oꞌotise buꞌiri yʉꞌʉre daꞌracoꞌtegʉre yé níꞌque tojarosaꞌa, nicʉ niwĩ Abrã. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Cʉ̃ mʉꞌʉ yere ñeꞌesome. Mʉꞌʉ macʉ̃ diácjʉ̃ mʉꞌʉ yere ñeꞌegʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Cʉ̃ tojo nitojanʉꞌcõ, Abrãrẽ wijaaropʉ pijiwijaacʉ niwĩ. Cʉ̃rẽ nicʉ niwĩ: —Ʉ̃ꞌmʉarõpʉ ĩꞌamorõña. Mʉꞌʉ põtẽorõ ñocõarẽ baꞌpaqueoya. Na ñocõa pãjãrã weronojõ mʉꞌʉ pãrãmerã nituriarã nirãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrã Õꞌacʉ̃rẽ ẽjõpeocʉ niwĩ. Tojo weegʉ Õꞌacʉ̃ cʉ̃rẽ “Añugʉ̃, buꞌiri marĩgʉ̃ nimi”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Cʉ̃ tojo ẽjõpeocã ĩꞌagʉ̃, cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ mʉꞌʉ wiogʉ niꞌi. Yʉꞌʉta mʉꞌʉ Ur caldeo masã ya macãpʉ nimiꞌcʉre miiwijawʉ. Aꞌti diꞌta mʉꞌʉ ya diꞌta niato nígʉ̃, tojo weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Cʉ̃ tojo nicã tʉꞌogʉ, Abrã cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —Õꞌacʉ̃, yʉꞌʉ wiogʉ, ¿deꞌro wee aꞌti diꞌta ya diꞌta nirõsaꞌa nisere masĩbosari? nicʉ niwĩ Abrã. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Cʉ̃ tojo nicã tʉꞌogʉ, Õꞌacʉ̃ aꞌtiro nicʉ niwĩ: —Yʉꞌʉre niꞌcõ wecʉo, niꞌcõ cabra, niꞌcʉ̃ oveja ʉmʉ miitia. Nanʉcʉ̃ iꞌtiarẽ cʉ̃ꞌmarĩ cʉorã niato. Tojo nicã niꞌcʉ̃ buja, apĩ buja wĩꞌmagʉ̃acãrẽ miitia, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrã nipeꞌtirã Õꞌacʉ̃ miitidutiꞌcãrãrẽ miiticʉ niwĩ. Miiti, nanʉcʉ̃rẽ deco meꞌrã dʉtesurecʉ niwĩ. Te sirinʉcʉ̃ ĩꞌapõtẽorõ peobʉrocʉ niwĩ. Na bujama ne dʉtesureticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Cʉ̃ tojo wééca beꞌro yuca waꞌicʉ diꞌire baꞌasĩꞌrĩrã, te diꞌi buꞌipʉ ejapejamʉjãcãrã niwã. Na tojo weecã, Abrã narẽ nʉrʉ̃mʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nʉrʉ̃cũmí, mujĩpũ sãjãrĩ cura Abrã cãrĩyʉꞌrʉa waꞌacʉ niwĩ. Maata pũrõ naꞌitĩꞌa waꞌacaro niwʉ̃. Tojo naꞌitĩꞌaꞌcã ĩꞌagʉ̃, uise meꞌrã tʉꞌoñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tojo waꞌacã, Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ pãrãmerã nituriarãrẽ waꞌatjere masĩcã ʉasaꞌa. Na ãpẽrã ya diꞌtapʉ nirãsama. Topʉ na nicã, tocjãrã narẽ daꞌracoꞌterã cʉorãsama. Topʉre ñaꞌarõ weepenoꞌrãsama. Na cuatrocientos cʉ̃ꞌmarĩ piꞌetirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Narẽ tojo weemicã, yʉꞌʉ tocjãrã narẽ daꞌradutiperãrẽ buꞌiri daꞌregʉti. Beꞌro na tojo piꞌetiꞌcãrã nimirã, ti diꞌtapʉ nimiꞌcãrã wijarãsama. Peje apeque meꞌrã wijarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mʉꞌʉ pũrĩcã bʉcʉ waro waꞌagʉ, añurõ soose meꞌrã wẽrĩgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Baꞌparitise curari mʉꞌʉ pãrãmerã nituriarã masãbajuaca beꞌro aꞌti diꞌtapʉre dajatojatirãsama. Maata aꞌtisome. Aꞌtocaterore aꞌti diꞌtacjãrã amorreo masã ñaꞌarõ weesetima. Beꞌropʉre nemorõ ñaꞌarõ weesetirãsama. Tojo waꞌari cura, mʉꞌʉ pãrãmerã nituriarã tojatirãsama tja. Tojati, amorreo masãrẽ cõꞌawĩrõrãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Beꞌro ñamipʉ niꞌcãrʉ̃ oꞌme bue ʉ̃jʉ̃tjʉ, tojo nicã ʉ̃jʉ̃rĩ tuturo waꞌicʉrã dʉtesureꞌcãrã waꞌteropʉ yʉꞌrʉacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ti nʉmʉrẽta, Õꞌacʉ̃ Abrã meꞌrã cʉ̃ “Mʉꞌʉrẽ aꞌtiro weegʉti” níꞌquere apocʉ niwĩ. Abrãrẽ aꞌtiro nicʉ niwĩ: —Aꞌti diꞌtare mʉꞌʉ pãrãmerã nituriarãrẽ oꞌogʉti. Egipto cja dia meꞌrã nʉꞌcã, téé dia pajiri maa Éufrates wãmetiri maapʉ nitʉorosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Aꞌtiro nicã aꞌti diꞌtacjãrã aꞌticʉrã nima: ceneo masã, cenezeo masã, cadmoneo masã, ");
INSERT INTO tuoNT_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hitita masã, ferezeo masã, refaíta masã, ");
INSERT INTO tuoNT_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreo masã, cananeo masã, gergeseo masã, jebuseo masã nima, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrã nʉmo Sarai ne põꞌrã marĩco niwõ. Tojo nimigõta, niꞌcõ core daꞌracoꞌtego Egiptocjõ, Agar wãmetigore cʉoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tojo weego Sarai co marãpʉ Abrãrẽ aꞌtiro nico niwõ: —Õꞌacʉ̃ yʉꞌʉre ne põꞌrã marĩcã weemi. Tojo weego Agar yʉꞌʉre daꞌracoꞌtego meꞌrã mʉꞌʉ nicã ʉasaꞌa. Apetero weego mʉꞌʉ co meꞌrã põꞌrãticã, yʉꞌʉ põꞌrã weronojõ tojarã́sama, nico niwõ Sarai. Co tojo nicã tʉꞌogʉ, Abrã “Jaʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tojo weego cʉ̃ nʉmo Sarai core daꞌracoꞌtego Agare cʉ̃ nʉmo weronojõ niato nígõ, co marãpʉ Abrãrẽ oꞌoco niwõ. Titare Abrã diez cʉ̃ꞌmarĩ Canaápʉ nígʉ̃ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tojo wee Abrã Agar meꞌrã nicʉ niwĩ. Cʉ̃ meꞌrã ni, co nijĩpaco niwãꞌcãtico niwõ. Tojo wee majã, siapeꞌe meꞌrã co nijĩpaco nisere masĩgõ, co wiogore tojo ĩꞌacõꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Co tojo weecã ĩꞌagõ, Sarai Abrãrẽ aꞌtiro nico niwõ: —Agar yʉꞌʉre ĩꞌacõꞌase mʉꞌʉ ye buꞌiri niꞌi. Yʉꞌʉ basuta yʉꞌʉre daꞌracoꞌtegore mʉꞌʉ nʉmo weronojõ cʉoato nígõ, mʉꞌʉrẽ oꞌowʉ. Niꞌcãrõacã co nijĩpaco nitjĩagõ, “Yʉꞌʉ co nemorõ wapatiꞌi”, nisamo. Õꞌacʉ̃ “¿Noa peꞌe buꞌiri cʉoti?” ni beseato, nico niwõ Sarai. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrã core yʉꞌticʉ niwĩ: —Mʉꞌʉrẽ daꞌracoꞌtego mʉꞌʉ yago nimo. Mʉꞌʉ ʉaronojõ weeya core. Tojo weego Sarai Agare ñaꞌarõ weenʉꞌcãco niwõ. Co tojo weecã ĩꞌagõ, Agar duꞌtia waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Co tojo duꞌtiwãꞌcãrĩ cura Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, core yucʉ marĩrõpʉ bajuacʉ niwĩ. Core bocaejaꞌcaro niꞌcã pe aco waari pe maꞌa sumuto nicaro niwʉ̃. Ti maꞌa co waꞌáca maꞌa Shur wãmetiro waꞌari maꞌa nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Core topʉ bocaejagʉ, aꞌtiro ni sẽrĩtiñaꞌcʉ niwĩ: —Agar, Saraire daꞌracoꞌtego, ¿noꞌopʉ níꞌco aꞌtiati mʉꞌʉ? Tojo nicã ¿noꞌopʉ waꞌago weeti? Cʉ̃ tojo nicã tʉꞌogo, cʉ̃rẽ yʉꞌtico niwõ: —Yʉꞌʉ wiogo Saraire duꞌtigo weeꞌe, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Co tojo nicã tʉꞌogʉ, aꞌtiro nicʉ niwĩ: —Majãmitojaaya tja mʉꞌʉ wiogo Sarai tiropʉ. Nipeꞌtise co weedutisere añurõ yʉꞌtiya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃ cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, apeye core ninemocʉ niwĩ tja: “Yʉꞌʉ mʉꞌʉrẽ pãjãrã põꞌrãticã weegʉti. Ne niꞌcʉ̃ na pãjãrãrẽ queo põtẽosome. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mʉꞌʉ niꞌcãrõacãrẽ nijĩpaco niꞌi. Mʉꞌʉ wĩꞌmagʉ̃ wʉagosaꞌa. Cʉ̃rẽ Ismae wãme õꞌogõsaꞌa. Õꞌacʉ̃ mʉꞌʉ piꞌetisere ĩꞌami. Tojo weego mʉꞌʉ macʉ̃rẽ tojo wãme õꞌogõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mʉꞌʉ macʉ̃ niꞌcʉ̃ burro nʉcʉ̃cjʉ̃ weronojõ yucʉ marĩrõpʉ sijabaqueꞌatigʉsami. Nipeꞌtirã meꞌrã aꞌmewẽjẽsetigʉsami. Na peꞌe quẽꞌrã cʉ̃ meꞌrã mejãrõta nisetirãsama. Nipeꞌtirã cʉ̃ acawererãrẽ ĩꞌatuꞌtiri masʉ̃ nigʉ̃sami”, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tojo weego majã Agar Õꞌacʉ̃ meꞌrã ucũ weetjĩagõ, aꞌtiro cʉ̃rẽ wãme õꞌoco niwõ: “Õꞌacʉ̃ yʉꞌʉre ĩꞌagʉ̃ nimi”. Tojo nígõ, aꞌtiro nisĩꞌrĩgõ weeco niwõ: “Õꞌacʉ̃ yʉꞌʉre ĩꞌaꞌcʉre ĩꞌapʉ. Tojo weemigõ, catiꞌi yujupʉ”. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tojo weero ti aco wijari pe “Catinuꞌcũgʉ̃, yʉꞌʉre ĩꞌagʉ̃ ya pe” wãmeyenoꞌcaro niwʉ̃. Ti pe Cades, Bered wãmetise macãrĩ waꞌtero nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Beꞌro Agar Abrãrẽ cʉ̃ macʉ̃rẽ põꞌrãtibosaco niwõ. Cʉ̃ wĩꞌmagʉ̃rẽ Ismae wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ismae bajuácaterore Abrã ochenta y seis cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abrã noventa y nueve cʉ̃ꞌmarĩ cʉori cura Õꞌacʉ̃ cʉ̃rẽ apaturi bajuacʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃, tutuayʉꞌrʉnʉꞌcãgʉ̃ niꞌi. Yʉꞌʉ ĩꞌorõpʉre añurõ buꞌiri marĩgʉ̃ niña. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Yʉꞌʉ mʉꞌʉ meꞌrã “Aꞌtiro weegʉti” ni ucũꞌquere ĩꞌogʉ̃ti. Mʉꞌʉ pãrãmerã nituriarã pãjãrã waro nicã weegʉti, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Cʉ̃ tojo nicã tʉꞌogʉ, Abrã paamuꞌrĩqueꞌacʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ ninemocʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Yʉꞌʉ mʉꞌʉ meꞌrã apogʉ, aꞌtiro weegʉti. Mʉꞌʉ peje diꞌtacjãrã ñecʉ̃ tojagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Abrã wãmetisome majã. Yʉꞌʉ nírõnojõta mʉꞌʉrẽ peje diꞌtacjãrã ñecʉ̃ tojacã weegʉsaꞌa. Tojo weegʉ niꞌcãcã meꞌrã Abrahã wãmetigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yʉꞌʉ mʉꞌʉ pãrãmerã nituriarãrẽ pãjãrã weegʉti. Na peje macãrĩcjãrã nirãsama. Tojo nicã niꞌcãrẽrã mʉꞌʉ pãrãmerã nituriarã diꞌta dutirã wiorã nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mʉꞌʉ meꞌrã “Aꞌtiro weegʉti” nise ne peꞌtisome. Yʉꞌʉ mʉꞌʉrẽ níꞌcaronojõta mʉꞌʉ pãrãmerã quẽꞌrãrẽ añurõ weegʉti. Mʉꞌʉ wiogʉ, tojo nicã mʉꞌʉ pãrãmerã nituriarã wiogʉ nigʉ̃ti. Mʉꞌʉ, tojo nicã na quẽꞌrã yʉꞌʉre ẽjõpeorãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nipeꞌtise aꞌti diꞌta, mʉꞌʉ niꞌcãrõacã nirõrẽ mʉꞌʉrẽ oꞌogʉsaꞌa. Na quẽꞌrãrẽ oꞌogʉsaꞌa. Mʉsã niatji diꞌta ninuꞌcũcãꞌrõsaꞌa. Na wiogʉ nigʉ̃ti, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Apeyere ninemocʉ niwĩ tja: —Mʉꞌʉ peꞌema, aꞌtiro weecã ʉaꞌa. Tojo nicã mʉꞌʉ põꞌrã, mʉꞌʉ pãrãmerã nituriarã yʉꞌʉ weedutisere weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yʉꞌʉ mʉꞌʉ meꞌrã, tojo nicã mʉꞌʉ pãrãmerã nituriarã meꞌrã apoꞌque aꞌtiro niꞌi. Mʉsã tiropʉ nirã́ ʉmʉa nipeꞌtirã õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌcãrã niato. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mʉsã õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌque meꞌrã yʉꞌʉ mʉsã meꞌrã “Aꞌtiro weegʉti” ni apoꞌquere ĩꞌonoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Niꞌcãcã meꞌrã nipeꞌtirã wĩꞌmarã ʉmʉa ocho nʉmʉrĩ bajuáca beꞌro õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌrãsama. Noꞌo wĩꞌmagʉ̃ mʉꞌʉ ya wiꞌipʉ bajuaꞌcʉ, tojo nicã apesecjʉ̃ cʉ̃ duuꞌcʉ quẽꞌrã mejãrõta weenoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mʉꞌʉ ya wiꞌi bajuaꞌcãrã, tojo nicã mʉꞌʉ duuꞌcãrã quẽꞌrã na õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌrãsama. Tojo weese meꞌrã yʉꞌʉ mʉsã meꞌrã “Aꞌtiro weegʉti” ni apoꞌque ĩꞌonoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Noꞌo niꞌcʉ̃ yejecõꞌanoꞌña marĩgʉ̃nojõ mʉsã waꞌteropʉre cõꞌanoꞌgʉ̃sami. Mʉsã meꞌrã nímasĩsome majã. Cʉ̃ yʉꞌʉ ucũꞌquere ẽjõpeotigʉ nimi. Tojo weegʉ cõꞌanoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Õꞌacʉ̃ tere nitojanʉꞌcõ, Abrahãrẽ aꞌte quẽꞌrãrẽ nicʉ niwĩ: —Mʉꞌʉ nʉmo Sarai peꞌe, Sarai wãmetisome majã. Co Sara wãmetigosamo. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Core añurõ weegʉsaꞌa. Co meꞌrã mʉꞌʉ macʉ̃rẽ oꞌogʉti. Co peje macãrĩcjãrã ñecõ nigõsamo. Co pãrãmerã nituriarã diꞌta dutirã wiorã nirãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Cʉ̃ tojo nisere tʉꞌogʉ, Abrahã paamuꞌrĩqueꞌacʉ niwĩ. Õꞌacʉ̃ ucũsere wãcũgʉ̃, buji, cʉ̃ basu aꞌtiro ni wãcũcʉ niwĩ: “¿Niꞌcʉ̃ cien cʉ̃ꞌmarĩ cʉogʉpʉ põꞌrãtibosari? ¿Sara quẽꞌrã noventa cʉ̃ꞌmarĩ cʉomigõ, wĩꞌmagʉ̃rẽ wʉamasĩbosari?” ");
INSERT INTO tuoNT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tojo weegʉ Õꞌacʉ̃rẽ nicʉ niwĩ: —Ismae mʉꞌʉ “Añurõ waꞌato” nise meꞌrã niato. Mʉꞌʉ cʉ̃rẽ añurõ weecã ʉaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Õꞌacʉ̃ cʉ̃rẽ aꞌtiro ni yʉꞌticʉ niwĩ: —Tojota niꞌi, nírõ peꞌe. Mʉꞌʉ nʉmo Sara niꞌcʉ̃ wĩꞌmagʉ̃rẽ wʉabosagosamo. Mʉꞌʉ cʉ̃rẽ Isaa wãmeyegʉsaꞌa. Cʉ̃ meꞌrã yʉꞌʉ “Aꞌtiro weegʉti” ni apoꞌquere añurõ weegʉti. Cʉ̃ meꞌrãta, cʉ̃ põꞌrã nituriarãpʉre mejãrõta añurõ weenuꞌcũgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismae peꞌere, cʉ̃ ye cjasere, mʉꞌʉ níꞌquere tʉꞌoapʉ. Cʉ̃ quẽꞌrãrẽ añurõ waꞌacã weegʉti. Pãjãrã põꞌrãticã weegʉti. Cʉ̃ pãrãmerã nituriarã pãjãrã nirãsama. Cʉ̃ doce wiorã pacʉ nigʉ̃sami. Yʉꞌʉ cʉ̃ meꞌrã pajibutiari curua weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yʉꞌʉ “Mʉsã meꞌrã tojo weegʉti” níꞌque peꞌema Isaa, Sara macʉ̃ meꞌrã apogʉti. Cʉ̃ ape cʉ̃ꞌma aꞌtocateronojõta bajuagʉsami, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Cʉ̃ Abrahã meꞌrã ucũtojanʉꞌcõ, waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ti nʉmʉta Abrahã cʉ̃ macʉ̃ Ismaere cʉ̃ õꞌrẽcjʉ yapa caserore yejecõꞌacʉ niwĩ. Tojo nicã, nipeꞌtirã cʉ̃rẽ daꞌracoꞌterã, cʉ̃ ya wiꞌipʉ bajuaꞌcãrã, ãpẽrã cʉ̃ duuꞌcãrã, nipeꞌtirã ʉmʉa cʉ̃ meꞌrã nirãrẽ Õꞌacʉ̃ cʉ̃rẽ dutiꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Titare Abrahã noventa y nueve cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Cʉ̃ macʉ̃ Ismae trece cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahã cʉ̃ macʉ̃ meꞌrã ti nʉmʉta yejecõꞌanoꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Nipeꞌtirã ʉmʉa cʉ̃ ya wiꞌipʉ bajuaꞌcãrã, tojo nicã apesecjãrã cʉ̃ duuꞌcãrã mejãrõta weenoꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Niꞌcã nʉmʉ Õꞌacʉ̃ Abrahãrẽ yucʉpagʉ pacasepagʉ nirṍ, Mamre wãmetiropʉ bajuacʉ niwĩ. Dajaritero nicã ʉpʉtʉ asiri cura Abrahã cʉ̃ ya wiꞌi suꞌti caseri meꞌrã wééca wiꞌi sope pʉꞌtopʉ dujicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","To dujigʉ, ĩꞌáoo, iꞌtiarã ʉmʉa cʉ̃ diacjʉ̃ nuꞌcũrãrẽ ĩꞌacʉ niwĩ. Narẽ ĩꞌa, sojaro meꞌrã wãꞌcãnʉꞌcã, narẽ põtẽrĩgʉ̃ waꞌacʉ niwĩ. Na tiro eta, diꞌtapʉ paamuꞌrĩqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Narẽ aꞌtiro nicʉ niwĩ: —Wiogʉ, yʉꞌʉre yʉꞌrʉaticãꞌña; coꞌteniña yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mʉsã dʉꞌpocãrĩrẽ coecã, yʉꞌʉ aco miitidutigʉti. Beꞌro mʉsã yucʉ docapʉ soorã waꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mʉsãrẽ daꞌracoꞌtegʉ tiro aꞌtiapʉ. Tojo weegʉ mʉsã baꞌatjere miigʉ̃ waꞌagʉti. Mʉsã tere baꞌáca beꞌro wãcũtutua, yʉꞌrʉwãꞌcãrãsaꞌa, nicʉ niwĩ Abrahã. Na “Jaʉ”, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Na tojo nicã tʉꞌogʉ, Abrahã cʉ̃ ya wiꞌipʉ sãjãa, cʉ̃ nʉmo Sarare nicʉ niwĩ: —Quero, veinte kilo harina añuse miitjĩagõ, pã́ weebaqueꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Core tojo nitojanʉꞌcõ, Abrahã wecʉa nirõpʉ omawãꞌcã, niꞌcʉ̃ wecʉ wĩꞌmagʉ̃ añugʉ̃rẽ ĩꞌabese weetjĩagʉ̃, cʉ̃rẽ daꞌracoꞌtegʉre wẽjẽdutigʉ oꞌocʉ niwĩ. Tojo weegʉ maata cʉ̃rẽ wẽjẽ, na baꞌatjere doꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tuꞌajanʉꞌcõ, Abrahã narẽ wecʉ diꞌire, wecʉ õpẽco, tojo nicã te õpẽco bʉꞌaꞌquere ecacʉ niwĩ. Na yucʉpagʉ doca baꞌari cura narẽ ĩꞌanuꞌcũ coꞌtecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sijari masã baꞌatuꞌajanʉꞌcõ, Abrahãrẽ sẽrĩtiñaꞌcãrã niwã: —Mʉꞌʉ nʉmo Sara, ¿noꞌopʉ niati? —Wiꞌipʉ niamo, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Cʉ̃ tojo yʉꞌticã tʉꞌogʉ, niꞌcʉ̃ na meꞌrãcjʉ̃ Abrahãrẽ nicʉ niwĩ: —Ape cʉ̃ꞌma mʉsãrẽ ĩꞌagʉ̃ aꞌtigʉti tja. Yʉꞌʉ tocãꞌrõ aꞌticã, mʉꞌʉ nʉmo niꞌcʉ̃ wĩꞌmagʉ̃ põꞌrãtigosamo. Sara cʉ̃ tojo ucũrĩ cura wiꞌi sãjãrõ Abrahã sẽꞌema ejanʉꞌcã, na tojo ni ucũsere tʉꞌopeꞌocãꞌco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahã, Sara bʉcʉrã waro nicãrã niwã. Sara co beꞌti ĩꞌase peꞌtiꞌcopʉ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tojo weego Sara bujidiꞌocũ põtẽotico niwõ. Aꞌtiro ni wãcũco niwõ: “¿Deꞌro weerã ʉ̃sã bʉcʉrã nimirã, ʉ̃sã ʉaripejase cʉobosari?” ");
INSERT INTO tuoNT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Õꞌacʉ̃ peꞌe Abrahãrẽ nicʉ niwĩ: —¿Deꞌro weego Sara bujiti? ¿Bʉcʉo nimigõ, põꞌrãtigosaꞌa, ni ẽjõpeoweti? ");
INSERT INTO tuoNT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mʉsã tʉꞌoñaꞌcã, ¿yʉꞌʉre apeyenojõ weemasĩtise nibosari? Ape cʉ̃ꞌma mʉsãrẽ ĩꞌagʉ̃ aꞌtigʉti tja. Yʉꞌʉ tocãꞌrõ aꞌticã, mʉꞌʉ nʉmo wĩꞌmagʉ̃ põꞌrãtigosamo. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Aꞌtere tʉꞌogo, Sara uigo, aꞌtiro nico niwõ: —Yʉꞌʉ bujigo mejẽta weeapʉ. Õꞌacʉ̃ core yʉꞌticʉ niwĩ: —Yʉꞌʉ masĩꞌi; mʉꞌʉ bujiapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Beꞌro sijari masã wãꞌcãnʉꞌcã, Sodoma wãmetiri macãpʉ waꞌacãrã niwã. Abrahã narẽ ĩꞌatʉogʉ waꞌagʉ, na meꞌrã waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Na tojo waꞌari cura Õꞌacʉ̃ aꞌtiro wãcũcʉ niwĩ: “Abrahã pãrãmerã nituriarã pãjãrã waro, tutuarã nirãsama. Cʉ̃ meꞌrã nipeꞌtirã aꞌti ʉmʉcocjãrãrẽ añurõ waꞌacã weegʉti. Tojo weegʉ yʉꞌʉ Sodomacjãrãrẽ weeatjere cʉ̃rẽ wereroʉasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yʉꞌʉ cʉ̃ põꞌrãrẽ, cʉ̃ pãrãmerã nituriarãrẽ yʉꞌʉ buꞌesere yʉꞌtidutigʉ, tojo nicã añuse, diacjʉ̃ cjase weeato nígʉ̃, cʉ̃rẽ besewʉ. Na tojo weecã, nipeꞌtise yʉꞌʉ ‘Tojo weegʉti’ níꞌque queoro waꞌarosaꞌa”, ni wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tojo weegʉ Õꞌacʉ̃ Abrahãrẽ aꞌtiro nicʉ niwĩ: —Sodoma, Gomorracjãrã na ñaꞌarõ weesetisere tʉꞌoapʉ. Na tojo weese ñaꞌabutiase niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tojo weegʉ niꞌcãrõacã yʉꞌʉ basuta topʉ ĩꞌagʉ̃ waꞌagʉti. ¿Diacjʉ̃ta yʉꞌʉ tʉꞌoꞌcaronojõta ñaꞌabutiaro weerã weeti? Tere ĩꞌatojagʉpʉ, añurõ masĩgʉ̃saꞌa majã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Beꞌro pʉarã Sodomapʉ waꞌacãrã niwã. Abrahã peꞌe Õꞌacʉ̃ tiropʉ tojánícʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Cʉ̃ pʉꞌtocure waꞌa, sẽrĩtiñaꞌcʉ niwĩ: —¿Ñaꞌarã meꞌrã añurã quẽꞌrãrẽ cõꞌagʉ̃sari? ");
INSERT INTO tuoNT_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Apetero weerã ti macãpʉre cincuenta añurã nibosama. ¿Tojo nimicã, ti macãrẽ cõꞌagʉ̃sari? Na cincuenta añurã nimicã, ¿deꞌro weegʉ mʉꞌʉ ti macãcjãrãrẽ acobojotibosari? ");
INSERT INTO tuoNT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Buꞌiritirã, buꞌiri marĩrã meꞌrã, narẽ niꞌcãrõnojõ buꞌiritirã weronojõ wẽjẽta basioweꞌe. Tere weeticãꞌña. Mʉꞌʉ nipeꞌtirã aꞌti turicjãrãrẽ besegʉ ¿queoro weetibosari? nicʉ niwĩ Abrahã. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tojo nicã tʉꞌogʉ, Õꞌacʉ̃ yʉꞌticʉ niwĩ: —To pũrĩcãrẽ ti macã Sodomacjãrãrẽ cincuenta añurã bocaejagʉ, nipeꞌtirã to nirãrẽ acobojogʉti, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahã ninemocʉ niwĩ tja: —Mʉꞌʉ Õꞌacʉ̃ niꞌi. Yʉꞌʉ pũrĩcã masʉ̃ mejõ nigʉ̃ niꞌi. Tojo nimigʉ̃, noꞌo ʉaro bʉsʉmaꞌagʉ̃ weronojõ mʉꞌʉrẽ ucũmaꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","¿Apetero weegʉ na cincuenta níꞌcãrã, cinco dijaro nicãrẽ, na cinco ye buꞌiri ti macãcjãrãrẽ cõꞌagʉ̃sari tja? Õꞌacʉ̃ aꞌtiro ni yʉꞌticʉ niwĩ: —Na cuarenta y cinco añurã nicãrẽ cõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","—¿Cuarenta añurã nicã warore, deꞌro weegʉsari? nicʉ niwĩ Abrahã. —Na cuarenta nicã quẽꞌrãrẽ, ti macãcjãrãrẽ cõꞌasome, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahã peꞌe sẽrĩtiñaꞌnemocʉ niwĩ tja: —Yʉꞌʉ meꞌrã uaticãꞌña. Mʉꞌʉrẽ apaturi sẽrĩtiñaꞌnemogʉ̃ti. ¿Deꞌro weegʉsari treinta añurãrẽ bocaejagʉ waro? Õꞌacʉ̃ apaturi nicʉ niwĩ: —Treinta añurãrẽ bocaejagʉ, ti macãcjãrãrẽ acobojogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahã sẽrĩtiñaꞌnemosãjãcʉ niwĩ tja: —Yʉꞌʉ wiogʉ, uiro marĩrõ mʉꞌʉrẽ ucũmiapʉba. Veinte añurã bocaejagʉ, ¿deꞌro weegʉsari? Õꞌacʉ̃ yʉꞌticʉ niwĩ tja: —Na veinte añurã nicã quẽꞌrãrẽ ti macãcjãrãrẽ cõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahã sẽrĩtiñaꞌtʉocʉ niwĩ: —Yʉꞌʉ wiogʉ, yʉꞌʉ meꞌrã uacʉpa. Mʉꞌʉrẽ aꞌtota sẽrĩtiñaꞌtʉogʉti majã. Ne caribonemosome. ¿Deꞌro weegʉsari mʉꞌʉ, diez diaꞌcʉ̃ añurãrẽ bocaejagʉ? Õꞌacʉ̃ nicʉ niwĩ: —Diez añurã nicã, ti macãcjãrãrẽ cõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Õꞌacʉ̃ Abrahã meꞌrã ucũtojanʉꞌcõ, waꞌa waꞌacʉ niwĩ. Abrahã quẽꞌrã cʉ̃ ya wiꞌipʉ dajatojaa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Naꞌiqueꞌari cura, Õꞌacʉ̃rẽ werecoꞌterã Sodomapʉre etacãrã niwã. Na topʉ etari cura Lot, Abrahã acabiji macʉ̃, macã sãjãrĩ sope tiro dujicʉ niwĩ. To cʉ̃ dujiro nipeꞌtirã masã nerẽwʉaro nicaro niwʉ̃. Na etacã ĩꞌagʉ̃, wãꞌcãnʉꞌcã, paamuꞌrĩqueꞌa, ");
INSERT INTO tuoNT_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","narẽ nicʉ niwĩ: —Yʉꞌʉ mʉsãrẽ daꞌracoꞌtegʉ niꞌi. Tojo weerã ya wiꞌipʉ cãrĩrã aꞌtia. Topʉ mʉsã dʉꞌpocãrĩrẽ coerãsaꞌa. Beꞌro ñamiñaꞌcũrõ mʉsã waꞌaropʉ yʉꞌrʉwãꞌcãrãsaꞌa. Cʉ̃ tojo nicã, yʉꞌticãrã niwã: —Niweꞌe. Aꞌto macã deco cãrĩrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Na tojo nimicã, Lot tutuaro meꞌrã, “Niweꞌe; ya wiꞌi cãrĩrãsaꞌa,” nicʉ niwĩ. Cʉ̃ tojo níca beꞌro, na “Jaʉ” ni, cʉ̃ meꞌrã waꞌacãrã niwã. Cʉ̃ ya wiꞌipʉ sãjãa, Lot narẽ baꞌase daꞌrebosacʉ niwĩ. Cʉ̃ pã́ bʉcʉase morẽña marĩsere weebosacʉ niwĩ. Na tere baꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Beꞌro, na cãrĩatji dʉporo nipeꞌtirã Sodomacjãrã ʉmʉa, maꞌmapjia, bʉcʉrã nipeꞌtirã Lot ya wiꞌi pʉꞌtore sʉtʉanʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Na to sʉtʉanʉꞌcã, cʉ̃rẽ caricũcãrã niwã: —¿Ʉmʉa noꞌopʉ niti ñamipʉ mʉꞌʉ tiro etaꞌcãrã? Narẽ oꞌowĩrõña. Numia meꞌrã weewʉasenojõrẽ weesĩꞌrĩsaꞌa na meꞌrã, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Na tojo nicã tʉꞌogʉ, Lot cʉ̃ ya wiꞌi wijaa, na meꞌrã ucũgʉ̃tigʉ, sopere añurõ biꞌacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Narẽ nicʉ niwĩ: —Yʉꞌʉ meꞌrãcjãrã, narẽ tojo ñaꞌarõ weeticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aꞌtiro peꞌe weeya. Yʉꞌʉ põꞌrã, pʉarã numia ne niꞌcʉ̃ ʉmʉ meꞌrã nitirã numia nima yujupʉ. Narẽ wĩorẽgʉ̃ti. Mʉsã narẽ noꞌo weesĩꞌrĩrõ weeya. Ãꞌrã ʉmʉa yʉꞌʉ tiro etaꞌcãrã peꞌema, narẽ ñaꞌarõ weeticãꞌña. Na yʉꞌʉ pijioꞌcãrã nima. Narẽ añurõ coꞌtegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Cʉ̃ tojo nicã tʉꞌorã, aꞌtiro yʉꞌticãrã niwã: —Siapeꞌe waꞌaya. Mʉꞌʉ aperocjʉ̃ niꞌi. Ʉ̃sã mʉꞌʉ dutinoꞌboꞌcãrã niweꞌe. To pũrĩcãrẽ niꞌcãrõacã ʉ̃sã narẽ tojo weesĩꞌrĩrõ nemorõ mʉꞌʉrẽ ñaꞌarõ weerãti, nicãrã niwã. Na Lore pũrõ tuuquenʉꞌcõcãrã niwã. Ti wiꞌi sopere tuupãꞌrẽsĩꞌrĩmicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na tojo weenʉꞌcãrĩ cura sijari masã Lore ñeꞌe, wiꞌi poꞌpeapʉ miisãjã waꞌacãrã niwã. Tojo weetoja, na sopere añurõ biꞌacãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tojo weetojanʉꞌcõ, na nipeꞌtirã sope pʉꞌtopʉ níꞌcãrã ʉmʉarẽ, maꞌmapjiare, bʉcʉrãrẽ caperi bajuticã weecãrã niwã. Caperi bajutirã, ti wiꞌipʉ sãjãasĩꞌrĩrã, sopere aꞌmasijarã, põtẽotia waꞌacãrã niwã. Ne bocaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wiꞌi poꞌpeapʉ sijari masã Lore sẽrĩtiñaꞌcãrã niwã: —¿Aꞌtore ãpẽrã mʉꞌʉ acawererã marĩti? Nipeꞌtirã mʉꞌʉ põꞌrã ʉmʉa, numia, mʉꞌʉ bujisʉmʉa, nipeꞌtirã mʉꞌʉ acawererã aꞌti macã nirãrẽ apero yoaropʉ miaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Aꞌti macãrẽ cõꞌapeꞌocãꞌrãsaꞌa. Õꞌacʉ̃ aꞌti macãcjãrã na peje ñaꞌarõ weesetise queti tʉꞌoami. Tojo weegʉ ʉ̃sãrẽ aꞌti macãrẽ cõꞌadutigʉ oꞌoámi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Na tojo nicã tʉꞌogʉ, Lot cʉ̃ bujisʉmʉa niajãrẽ weregʉ waꞌamicʉ niwĩ. Narẽ nicʉ niwĩ: —Wãꞌcãnʉꞌcãña. Aꞌti macãrẽ wijayá. Õꞌacʉ̃ aꞌti macãrẽ cõꞌagʉ̃tigʉ weemi, nicʉ niwĩ. Cʉ̃ bujisʉmʉa niajã cʉ̃ tojo nisere, “Tojo nimaꞌacʉ̃ weemi,” ni wãcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Cʉ̃ na meꞌrã ucũrĩ cura boꞌrearo weecaro niwʉ̃. Tojo weerã Õꞌacʉ̃rẽ werecoꞌterã tutuaro meꞌrã cʉ̃rẽ nicãrã niwã: —¡Quero! Mʉꞌʉ nʉmo, mʉꞌʉ põꞌrã numiarẽ sojaro meꞌrã aperopʉ miaña. Waꞌaya ʉ̃sã aꞌti macãrẽ ʉ̃jʉ̃acõꞌacã, wẽrĩsĩꞌrĩtirã, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Na tojo nimicã, Lot sojaticʉ niwĩ. Cʉ̃ ʉmʉñarõ waꞌaticã ĩꞌarã, na cʉ̃ omocãrẽ ñeꞌe, miacãrã niwã. Õꞌacʉ̃ cʉ̃rẽ pajañaꞌgʉ̃, tojo weeduticʉ niwĩ. Lot nʉmo, cʉ̃ põꞌrã numia quẽꞌrãrẽ macã sumutopʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na macãpʉ wijáca beꞌro niꞌcʉ̃ Õꞌacʉ̃rẽ werecoꞌtegʉ narẽ nicʉ niwĩ: —¡Omaña catisĩꞌrĩrã! Ne majãmiĩꞌatõrõticãꞌña. Wẽrĩsĩꞌrĩtirã, aꞌtore ne tojanʉꞌcãtirãta, ʉ̃rʉ̃pagʉpʉ waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot peꞌe narẽ nicʉ niwĩ: —Yʉꞌʉ wiorã, ʉ̃rʉ̃gʉ̃pʉre waꞌadutiticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mʉsã yʉꞌʉre añurõ weetamuapʉ. Yʉꞌʉ wẽrĩboꞌcʉre mʉsã yʉꞌrʉoapʉ. Yʉꞌʉ ʉ̃rʉ̃gʉ̃pʉre ejatibosaꞌa. To waꞌari curata macãrẽ ʉ̃jʉ̃ase yʉꞌʉre ẽmʉejábosaꞌa. Tojo weegʉ yʉꞌʉ maꞌa deco wẽrĩbosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Topʉ waꞌaronojõ oꞌogʉ, niꞌcã macã pʉꞌtoacã nirĩ macãpʉ waꞌadutiya. Ti macã cãꞌmacãcã niꞌi. Topʉ waꞌagʉ, yʉꞌrʉgʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Cʉ̃ tojo nicã tʉꞌogʉ, Õꞌacʉ̃rẽ werecoꞌtegʉ cʉ̃rẽ nicʉ niwĩ: —Jaʉ, mʉꞌʉ níꞌcaronojõta weegʉti. Si macã, mʉꞌʉ níca macãrẽ ʉ̃jʉ̃acõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","¡Quero, si macãpʉ omawãꞌcãña! Mʉꞌʉ etaticãma, ne apeye macãrĩrẽ ʉ̃jʉ̃acõꞌanoꞌña marĩrõsaꞌa. Mʉꞌʉ etáca beꞌropʉ ʉ̃jʉ̃acõꞌanoꞌrõsaꞌa, nicʉ niwĩ. Ti macã cãꞌmacãcã niyuro, Zoar wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot Zoapʉ etacã, boꞌrearo weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Cʉ̃ topʉ etáca beꞌro Õꞌacʉ̃ Sodoma, Gomorra buꞌipʉre pecameꞌe, tojo nicã azufre acoro pejaro weronojõ ʉ̃jʉ̃dijaticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Cʉ̃ te macãrĩrẽ ʉ̃jʉ̃acõꞌacã, to nimiꞌque nipeꞌtise ʉ̃jʉ̃peꞌtia waꞌacaro niwʉ̃. Ti macã nimiꞌcãrã wẽrĩpeꞌtia waꞌacãrã niwã. Na otese nimiꞌque quẽꞌrã ʉ̃jʉ̃peꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tojo waꞌari cura Lot nʉmo cʉ̃ beꞌro sirutuco nimiwõ. Tojo sirutugo, majãmiĩꞌatõrõco niwõ. Totá co moa tuturo dojonʉꞌcã waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ape nʉmʉ te macãrĩ ʉ̃jʉ̃acõꞌaca beꞌro Abrahã cʉ̃ Õꞌacʉ̃ meꞌrã ucũꞌcaropʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Topʉ waꞌagʉ, Sodoma, Gomorra níꞌcaro nipeꞌtiro ti papʉre ĩꞌaquejocʉ niwĩ. Yoaropʉ cʉ̃ ĩꞌacã, pã́ na ʉ̃jʉ̃arõ oꞌme mʉjãrõ weronojõ oꞌmepuꞌsumorõcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ti paꞌtiropʉ nise macãrĩ Lot níꞌcarore ʉ̃jʉ̃acõꞌagʉ̃, Õꞌacʉ̃ Abrahãrẽ wãcũcʉ niwĩ. Tojo weegʉ te macãrĩ ʉ̃jʉ̃acõꞌase dʉporo wẽrĩrĩ nígʉ̃, Lore apesepʉ miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Beꞌro Lot uigʉ, Zoapʉre tojanemosĩꞌrĩticʉ niwĩ. Tojo weegʉ cʉ̃ põꞌrã pʉarã numia meꞌrã ʉ̃rʉ̃pagʉpʉ waꞌacʉ niwĩ. Topʉ waꞌa, na iꞌtiarã niꞌcã ʉ̃tã tutipʉ niseticũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Niꞌcã nʉmʉ masã maꞌmio co acabijore nico niwõ: —Marĩ pacʉ bʉcʉ nimi majã. Marĩ nirõpʉre marĩrẽ nʉmotigʉnojõ ne niꞌcʉ̃ marĩmi. Tojo weero nipeꞌtirã masã weewʉasenojõrẽ weeta basioweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tojo weerã marĩ pacʉre queꞌacã weerã́. Cʉ̃ queꞌáca beꞌro cʉ̃ meꞌrã cãjĩrã. Tojo weerã marĩ cʉ̃ meꞌrã põꞌrãtirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ti ñami na pacʉre queꞌato nírã, ʉꞌsedʉcaco vino tĩacãrã niwã. Beꞌro masã maꞌmio cʉ̃ meꞌrã cãjĩco niwõ. Cʉ̃ peꞌe co tojo weesere ne tʉꞌoñaꞌticʉ niwĩ. Co dijaacã quẽꞌrãrẽ, ne tʉꞌoñaꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ape nʉmʉ masã maꞌmio co acabijore nico niwõ: —Ñamicaꞌa ñami yʉꞌʉ marĩ pacʉ meꞌrã cãjĩapʉ. Aꞌti ñami quẽꞌrãrẽ cʉ̃rẽ queꞌacã weerã́. Tojo weego mʉꞌʉ cʉ̃ meꞌrã cãjĩgõ waꞌapa. Tojo weerã marĩnʉcʉ̃ põꞌrãtirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na níꞌcaronojõta weecãrã niwã. Na pacʉre queꞌadutirã, ʉꞌsedʉcaco vino tĩacãrã niwã tja. Dʉꞌsago co pacʉ meꞌrã cãjĩco niwõ. Lot peꞌe ne tʉꞌoñaꞌticʉ niwĩ. Co dijaacã quẽꞌrãrẽ, ne tʉꞌoñaꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Na tojo weetjĩarã, Lot põꞌrã numia na pacʉ meꞌrã pʉarãpʉta põꞌrãticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Beꞌro masã maꞌmio niꞌcʉ̃ wĩꞌmagʉ̃ wʉaco niwõ. Cʉ̃rẽ Moab wãmeyeco niwõ. Cʉ̃ moabita masã ñecʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Dʉꞌsago quẽꞌrã macʉ̃tico niwõ. Cʉ̃rẽ Ben-ammi wãmeyeco niwõ. Cʉ̃ amonita masã ñecʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahã cʉ̃ níꞌcaro cõꞌawãꞌcãgʉ̃, Neguev wãmetiropʉ waꞌacʉ niwĩ. Cʉ̃ Cades, tojo nicã Shur waꞌteropʉ tojacʉ niwĩ. Tita cʉ̃ Gerar wãmetiri macãpʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Cʉ̃ topʉ nígʉ̃, cʉ̃ nʉmo Sarare “Yʉꞌʉ acabijo nimo”, ni werecʉ niwĩ. Cʉ̃ tojo nicã tʉꞌo, Geracjʉ̃ wiogʉ Abimelec Sarare nʉmotigʉti nígʉ̃, miidutigʉ oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ti ñami Õꞌacʉ̃ Abimelere quẽꞌerõpʉ aꞌtiro nicʉ niwĩ: “Mʉꞌʉ wẽrĩgʉ̃saꞌa. Mʉꞌʉ miidutigʉ oꞌoꞌco marãpʉtigo nimo”. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelec peꞌe Sara meꞌrã ne niticʉ niwĩ yujupʉ. Tojo weegʉ Õꞌacʉ̃rẽ yʉꞌticʉ niwĩ: “Yʉꞌʉ wiogʉ, yʉꞌʉ ñaꞌarõ weetimicã, ¿yʉꞌʉre, tojo nicã aꞌti macãcjãrã quẽꞌrãrẽ wẽjẽgʉ̃sari? ");
INSERT INTO tuoNT_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahã basuta yʉꞌʉre, ‘Co yʉꞌʉ acabijo nimo’, niami. Co quẽꞌrã, ‘Yʉꞌʉ maꞌmi nimi’, niamo. Tojo weegʉ ‘Marãpʉ moogõ nimo’, ni wãcũgʉ̃, tojo weeasʉ. Ne ñaꞌarõ weetiapʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Cʉ̃ tojo nisere tʉꞌo, Õꞌacʉ̃ Abimelere quẽꞌerõpʉ yʉꞌticʉ niwĩ: “Yʉꞌʉ masĩꞌi. Mʉꞌʉ añurõ wãcũse meꞌrã tojo weeapʉ. Tojo weegʉ mʉꞌʉ co meꞌrã cãjĩsĩꞌrĩcã cãꞌmotaꞌapʉ. Mʉꞌʉ co meꞌrã nígʉ̃, yʉꞌʉre ñaꞌarõ wéégʉ weronojõ weeboapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Niꞌcãrõacã pũrĩcãrẽ co marãpʉre wiaya tja. Cʉ̃ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ nimi. Mʉꞌʉrẽ wẽrĩticãꞌto nígʉ̃, mʉꞌʉ ye cjasere sẽrĩbosagʉsami. Mʉꞌʉ cʉ̃ nʉmorẽ wiatigʉ pũrĩcã, mʉꞌʉ, mʉꞌʉ yarã nipeꞌtirã meꞌrã wẽrĩgʉ̃saꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ape nʉmʉ boꞌreacãpʉ Abimelec wãꞌcã, cʉ̃rẽ daꞌracoꞌterãrẽ pijio, cʉ̃ quẽꞌerõpʉ ĩꞌaꞌquere werecʉ niwĩ. Tere tʉꞌorã, pũrõ uicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Narẽ wéréca beꞌro Abrahãrẽ pijio, aꞌtiro nicʉ niwĩ: —¿Deꞌro weeati mʉꞌʉ ʉ̃sãrẽ? ¿Ñeꞌenojõ yʉꞌʉ mʉꞌʉrẽ ñaꞌarõ weeꞌque wapa to cãꞌrõjo yʉꞌʉre, tojo nicã yarãrẽ ñaꞌabutiaro tojacã weemiati? Mʉꞌʉ yʉꞌʉre tojo weeꞌque ne niꞌcʉ̃ tojo weeya marĩsere weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Deꞌro weegʉ tojo weeati? ¿Ñeꞌenojõrẽ wãcũgʉ̃, tojo weeati? ni sẽrĩtiñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahã cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ aꞌtiro wãcũcãti. “Aꞌtopʉ Õꞌacʉ̃rẽ ne ẽjõpeotisama”, nicãti. Yʉꞌʉ, “Yʉꞌʉ nʉmo nimo” nicãrẽ, “Yʉꞌʉre wẽjẽbosama”, ni wãcũasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Diacjʉ̃ta niꞌi. Co yʉꞌʉ acabijota nimo. Yʉꞌʉ pacʉ macõ nimo. Paco peꞌe apego nimo. Tojo weegʉ core nʉmotiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yʉꞌʉ pacʉ tiropʉ níꞌcʉ Õꞌacʉ̃ dutiro meꞌrã wijagʉ, core aꞌtiro niwʉ̃: “Noꞌo marĩ waꞌaro etago, ãpẽrãrẽ, ‘Yʉꞌʉ maꞌmi nimi’, niña”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Na tojo ucṹca beꞌro, Abimelec Abrahãrẽ oveja, wecʉa oꞌocʉ niwĩ. Tojo nicã daꞌracoꞌterã ʉmʉa, numia oꞌocʉ niwĩ. Abrahãrẽ cʉ̃ nʉmo Sarare wiacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelec Abrahãrẽ nicʉ niwĩ: —Aꞌti diꞌta ya diꞌta niꞌi. Noꞌo mʉꞌʉ tʉꞌsaro mʉꞌʉ niatjore beseya. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sarare aꞌtiro nicʉ niwĩ: —Mʉꞌʉ maꞌmirẽ mil niyeru cujiri wapabʉjʉse cujirire oꞌoapʉ. Te meꞌrã mʉꞌʉ meꞌrã nirã́ mʉꞌʉrẽ ne mejẽcã wãcũsome. Tojo weego na ĩꞌorõpʉ buꞌiri marĩgõ tojagosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelec tojo níca beꞌro, Abrahã Õꞌacʉ̃rẽ sẽrĩbosacʉ niwĩ. Abimelec Sarare miaꞌque buꞌiri cʉ̃ nʉmorẽ, narẽ daꞌracoꞌterã numiarẽ, nipeꞌtirã cʉ̃ ya wiꞌi nirãrẽ Õꞌacʉ̃ põꞌrãtimasĩticã weecʉ niwĩ. Abrahã narẽ sẽrĩbosáca beꞌro Õꞌacʉ̃ narẽ yʉꞌrʉocʉ niwĩ. Tojo weerã na põꞌrãtimasĩcãrã niwã tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Õꞌacʉ̃ cʉ̃ níꞌcaronojõta Sarare añurõ weecʉ niwĩ. Cʉ̃, “Mʉꞌʉ wĩꞌmagʉ̃ cʉogosaꞌa”, níꞌque queoro waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tojo weego nijĩpaco tojaco niwõ. Beꞌro Abrahã cʉ̃ bʉcʉ waro nimicã, wĩꞌmagʉ̃rẽ wʉabosaco niwõ. Õꞌacʉ̃ cʉ̃rẽ “Ape cʉ̃ꞌma mʉsãrẽ ĩꞌagʉ̃ aꞌtigʉti tja; yʉꞌʉ tocãꞌrõ aꞌticã, mʉꞌʉ nʉmo niꞌcʉ̃ wĩꞌmagʉ̃ põꞌrãtigosamo” níꞌquere queoro waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sara Abrahãrẽ põꞌrãtibosaꞌcʉre, Isaa wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Beꞌro Õꞌacʉ̃ cʉ̃rẽ dutíꞌcaronojõta wĩꞌmagʉ̃ cʉ̃ ocho nʉmʉrĩ bajuáca beꞌro Abrahã cʉ̃ õꞌrẽcjʉ yapa caserore yejecõꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Cʉ̃ macʉ̃ Isaa bajuácaterore Abrahã cien cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tojo weego Sara aꞌtiro wãcũco niwõ: “Õꞌacʉ̃ yʉꞌʉre eꞌcati, bujicã weeami. Tojo weerã ‘Sara wĩꞌmagʉ̃ wʉapo’ nise quetire tʉꞌorã, nipeꞌtirã yʉꞌʉre eꞌcatitamurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Noa Abrahãrẽ, ‘Sara wĩꞌmagʉ̃ wʉabosagosamo’ nibopari? Ne niꞌcʉ̃ tojo nitimicã, cʉ̃ bʉcʉ waro nigʉ̃rẽ yʉꞌʉ niꞌcʉ̃ wĩꞌmagʉ̃ põꞌrãtibosawʉ”, ni wãcũco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaa bʉcʉa, cʉ̃ miꞌrĩduꞌuri nʉmʉrẽ Abrahã pajiri bosenʉmʉ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tojo weeri curare Sara Agar macʉ̃ Abrahãrẽ wʉabosaꞌcʉ Isaare bujicãꞌcã ĩꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tojo weego co Abrahã tiro waꞌa, aꞌtiro nico niwõ: —Sico daꞌracoꞌtego macʉ̃ mʉꞌʉ wẽ́rĩ́ca beꞌro, mʉꞌʉ ye níꞌquere ne ñeꞌesome. Yʉꞌʉ macʉ̃ Isaa peꞌe ñeꞌegʉ̃sami. Tojo weegʉ daꞌracoꞌtegore, co macʉ̃ meꞌrãta cõꞌawĩrõcãꞌña, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Co tojo nicã tʉꞌogʉ, Abrahã cʉ̃ macʉ̃ Ismaere maꞌígʉ̃, pũrõ bʉjaweticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Õꞌacʉ̃ peꞌe cʉ̃rẽ nicʉ niwĩ: “Narẽ sõꞌowaro wãcũqueꞌtiticãꞌña. Sara dutiꞌcaronojõta weeya. Isaa meꞌrã mʉꞌʉ pãrãmerã nituriarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Daꞌracoꞌtego macʉ̃ peꞌere aꞌtiro weegʉti. Cʉ̃ quẽꞌrãrẽ, pãjãrã cʉ̃ pãrãmerã nituriacã weegʉsaꞌa. Mʉꞌʉ macʉ̃ niyucã, pajiri diꞌtacjãrã nirãsama”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ape nʉmʉ ñamiñaꞌcũrõ Abrahã Agare pã́, aco ajuro waꞌicʉ casero meꞌrã wééca ajurore co sẽꞌemapʉ miiõꞌocʉ niwĩ. Core, co macʉ̃ meꞌrã weꞌriti, narẽ waꞌaduticʉ niwĩ. Co waꞌa, noꞌo ʉaro yucʉ marĩrõ, masã marĩrõpʉ Beerseba wãmetiropʉ sijabaqueꞌatico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Aco peꞌticã ĩꞌagõ, co macʉ̃rẽ yucʉsti docapʉ cũuco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","“Cʉ̃ wẽrĩcã ĩꞌasĩꞌrĩtisaꞌa” nígõ, yoacureropʉ waꞌa, dujico niwõ. Co topʉ dujiri cura cʉ̃ utinʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Õꞌacʉ̃ co macʉ̃ uticã tʉꞌocʉ niwĩ. Cʉ̃ tojo weecã tʉꞌogʉ, cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, ʉꞌmʉsepʉ ucũdijocʉ niwĩ: “¿Agar, deꞌro waꞌati? Uiticãꞌña. Õꞌacʉ̃ mʉꞌʉ macʉ̃ uticã tʉomi. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Wãꞌcãnʉꞌcãña. Mʉꞌʉ macʉ̃rẽ wejewãꞌcõnʉꞌcõña. Cʉ̃ meꞌrã pajiri diꞌtacjãrã waꞌacã weegʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tojo níca beꞌro Õꞌacʉ̃ Agare niꞌcã pe aco wijari pe ĩꞌabocacã weecʉ niwĩ. Co waꞌicʉ casero meꞌrã wééca ajuropʉ aco poseye, co macʉ̃rẽ tĩaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Õꞌacʉ̃ co macʉ̃rẽ añurõ weetamucʉ niwĩ. Cʉ̃ bʉcʉa, yucʉ marĩrõ, masã marĩrõpʉ nicãꞌcʉ niwĩ. Topʉ nígʉ̃, bʉacatjẽ meꞌrã bʉemuꞌsigʉ̃ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Cʉ̃ yucʉ marĩrõ, masã marĩrõpʉ Parán wãmetiropʉ nirĩ cura, cʉ̃ paco, Egiptocjõrẽ cʉ̃ nʉmo niacjore bocabosaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Titare Abimelec Abrahã meꞌrã ucũgʉ̃ waꞌacʉ niwĩ. Tojo nicã cʉ̃ yarã surara wiogʉ Ficol wãmetigʉ meꞌrã waꞌacʉ niwĩ. Cʉ̃ Abrahãrẽ nicʉ niwĩ: —Nipeꞌtise mʉꞌʉ weesere Õꞌacʉ̃ mʉꞌʉrẽ weetamusami. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tojo weegʉ Õꞌacʉ̃ tʉꞌoropʉ mʉꞌʉ aꞌtiro weecã ʉasaꞌa. Yʉꞌʉre, yʉꞌʉ põꞌrãrẽ, yʉꞌʉ pãrãmerãrẽ ne mejẽcã weeticãꞌña. Yʉꞌʉ mʉꞌʉrẽ wééꞌcaronojõta yʉꞌʉre añurõ weeya. Mʉꞌʉ apesecjʉ̃ nimigʉ̃, ʉ̃sã ya diꞌtapʉ niꞌi. Aꞌti diꞌtacjãrã quẽꞌrãrẽ añurõ weeya. “Õꞌacʉ̃ wãme meꞌrã tojota weegʉti” niña, nicʉ niwĩ Abimelec. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahã aꞌtiro ni yʉꞌticʉ niwĩ: —Õꞌacʉ̃ tʉꞌoropʉ mʉꞌʉ tojo níꞌcaronojõta añurõ weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tojo níca beꞌro Abrahã Abimelere aꞌtiro nicʉ niwĩ: —Mʉꞌʉrẽ daꞌracoꞌterã yʉꞌʉ aco waari pere ẽꞌmacãrã niama. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelec peꞌe cʉ̃ tojo nicã tʉꞌogʉ, cʉ̃rẽ nicʉ niwĩ: —Ne masĩtiasʉ, noa tojo weero weeapã. Mʉꞌʉ yʉꞌʉre ne weretiapʉ. Niꞌcãcãpʉta ne tʉꞌogʉ weeꞌe, nicʉ niwĩ Abimelec. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tojo níca beꞌro Abrahã ovejare, wecʉare mii, Abimelere oꞌocʉ niwĩ. Cʉ̃ tojo oꞌóca beꞌro, ti nʉmʉta “Aꞌtiro weerãti”, ni aꞌmerĩ apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Na tojo wééca beꞌro Abrahã siete oveja numia wĩꞌmarãrẽ apesepʉ oveja marĩrõpʉ cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelec cʉ̃ tojo weecã ĩꞌagʉ̃, sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weegʉ mʉꞌʉ ãꞌrã siete ovejare apesepʉ cũuati? ");
INSERT INTO tuoNT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahã cʉ̃rẽ yʉꞌticʉ niwĩ: —Ãꞌrã siete ovejare miiña. Narẽ miigʉ̃, “Aꞌti pe aco waari pe Abrahã seꞌéca pe niꞌi”, ni ĩꞌagʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Na pʉarã “Aꞌtiro weerãti” ni apoꞌcaro nitjĩarõ, na nirõpʉ Beerseba wãme õꞌonoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Na aꞌmerĩ apóca beꞌro Beerseba wãmetiropʉ níꞌcãrã Abimelec, Ficol filisteo ya diꞌtapʉ dajatojaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Beersebapʉ Abrahã niꞌcãgʉ̃ yucʉgʉ tamarisco wãmeticjʉ otecʉ niwĩ. Topʉ Õꞌacʉ̃ catinuꞌcũgʉ̃rẽ sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahã yoacã filisteo ya diꞌtapʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yoáca beꞌropʉ Õꞌacʉ̃ Abrahãrẽ “¿Diacjʉ̃ta yʉꞌʉre ẽjõpeomiti?” nígʉ̃, cʉ̃rẽ pisucʉ niwĩ. —¡Abrahã! nicʉ niwĩ. Cʉ̃ tojo pisucã tʉꞌogʉ, Abrahã, “Aꞌto niꞌi”, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Cʉ̃ yʉꞌtíca beꞌro Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ macʉ̃, niꞌcʉ̃ nigʉ̃rẽ, mʉꞌʉ ʉpʉtʉ maꞌigʉ̃ Isaare aperopʉ Moriah wãmetiri diꞌtapʉ miaña. Topʉ etagʉ, ʉ̃rʉ̃gʉ̃, mʉꞌʉrẽ ĩꞌocjʉpʉ mʉjãña. Tigʉ buꞌipʉ cʉ̃rẽ waꞌicʉre wẽjẽ ʉ̃jʉ̃amorõpeogʉ weronojõ weeya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ape nʉmʉ boꞌrequeꞌari cura, Abrahã wãꞌcãnʉꞌcã, cʉ̃ burro buꞌipʉ dujiri caserore peocʉ niwĩ. Tojo weetuꞌajanʉꞌcõ, peca, cʉ̃ ʉ̃jʉ̃amorõpeoatjere paawaꞌacʉ niwĩ. Cʉ̃ macʉ̃, tojo nicã cʉ̃rẽ daꞌracoꞌterã pʉarã meꞌrã téé Õꞌacʉ̃ cʉ̃rẽ wereꞌcaropʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Iꞌtia nʉmʉ beꞌro Abrahã Õꞌacʉ̃ cʉ̃rẽ waꞌadutiꞌcarore yoaropʉ ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tojo weegʉ cʉ̃rẽ daꞌracoꞌterãrẽ nicʉ niwĩ: —Mʉsã burro meꞌrã aꞌto tojayá. Yʉꞌʉ, yʉꞌʉ macʉ̃ meꞌrã sõꞌopʉ Õꞌacʉ̃rẽ eꞌcatipeorã waꞌarã weeꞌe. Tojo weetoja, mʉsã tiro tojatirãsaꞌa tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahã Õꞌacʉ̃rẽ waꞌicʉ ʉ̃jʉ̃amorõpeoatje pecare Isaare miaduticʉ niwĩ. Cʉ̃ peꞌe pecameꞌe, tojo nicã diꞌpjĩ miacʉ niwĩ. Na pʉarã niꞌcãrõ meꞌrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","To beꞌroacã Isaa cʉ̃ pacʉre nicʉ niwĩ: —¡Pacʉ! —¿Ñeꞌenojõ ʉati, macʉ̃? ni yʉꞌticʉ niwĩ. Isaa cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —Marĩ peca, tojo nicã pecameꞌe cʉoꞌo. ¿Oveja wĩꞌmagʉ̃ marĩ ʉ̃jʉ̃amorõpeoacjʉ noꞌopʉ niti? ");
INSERT INTO tuoNT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahã cʉ̃rẽ yʉꞌticʉ niwĩ: —Macʉ̃, Õꞌacʉ̃ marĩrẽ niꞌcʉ̃ oveja wĩꞌmagʉ̃rẽ oꞌogʉsami, nicʉ niwĩ. Tojo ni, na pʉarã sijawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Õꞌacʉ̃ Abrahãrẽ wereꞌcaropʉre etarã, Abrahã waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoatjore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tuꞌajanʉꞌcõ, pecare to buꞌipʉ seepeocʉ niwĩ. Seepeotoja, cʉ̃ macʉ̃rẽ dʉꞌte, peca buꞌipʉ peocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Seepeotoja, cʉ̃ macʉ̃rẽ wẽjẽgʉ̃ti nígʉ̃, diꞌpjĩrẽ miicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Cʉ̃ tojo weeri cura Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, ʉꞌmʉsepʉ cʉ̃rẽ pisudijocʉ niwĩ: —¡Abrahã! Abrahã cʉ̃rẽ yʉꞌticʉ niwĩ: —Aꞌtota niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","—Mʉꞌʉ macʉ̃rẽ ne mejẽcã weeticãꞌña. Niꞌcãrõacã yʉꞌʉ masĩꞌi. Mʉꞌʉ yʉꞌʉre, “Yʉꞌʉ macʉ̃ niꞌcʉ̃ nigʉ̃rẽ mʉꞌʉrẽ oꞌosome”, ne nitiapʉ. Tojo weegʉ yʉꞌʉ masĩꞌi mʉꞌʉ yʉꞌʉre wiopesase meꞌrã ĩꞌaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Cʉ̃ tojo nicã, Abrahã ĩꞌaoo, niꞌcʉ̃ oveja ʉmʉ niꞌcã yucʉsti waꞌteropʉ cʉ̃ capesaꞌripʉ suꞌrinuꞌcũgʉ̃rẽ ĩꞌacʉ niwĩ. Tojo wee cʉ̃rẽ ñeꞌe, wẽjẽ Õꞌacʉ̃rẽ eꞌcatise oꞌogʉ, ʉ̃jʉ̃amorõpeocʉ niwĩ. Cʉ̃ macʉ̃rẽ wẽjẽboꞌcʉ oveja peꞌere wẽjẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Beꞌro Abrahã tojo weeꞌcarore aꞌtiro wãme õꞌocʉ niwĩ: “Õꞌacʉ̃ marĩrẽ dʉꞌsasenojõrẽ oꞌomi”. Tojo weero niꞌcãrõacã quẽꞌrãrẽ “Tigʉ Õꞌacʉ̃ yagʉ ʉ̃rʉ̃gʉ̃rẽ marĩrẽ dʉꞌsasenojõrẽ oꞌogʉsami”, ninoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Apaturi Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, ʉꞌmʉsepʉ Abrahãrẽ pisudijocʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ aꞌtiro niami: “Aꞌte mʉꞌʉ weeꞌquere masĩꞌi. Yʉꞌʉre, ‘Yʉꞌʉ macʉ̃ niꞌcʉ̃ nigʉ̃rẽ mʉꞌʉrẽ oꞌosome’, ne nitiapʉ. Tojo weegʉ yʉꞌʉ basu yʉꞌʉ wãme meꞌrã mʉꞌʉrẽ añurõ waꞌacã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mʉꞌʉrẽ peje añuse weegʉti. Mʉꞌʉ pãrãmerã nituriarãrẽ ñocõa weronojõ, tojo nicã pajiri maa sumuto nucũpori weronojõ pãjãrã waꞌacã weegʉti. Apeyema narẽ ĩꞌatuꞌtirãrẽ docaqueꞌacã weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mʉꞌʉ yʉꞌʉre añurõ ẽjõpeose wapa mʉꞌʉ pãrãmerã meꞌrã nipeꞌtirã aꞌti ʉmʉcocjãrã añurõ weenoꞌrãsama”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Beꞌro Abrahã cʉ̃rẽ daꞌracoꞌterã tiropʉ dajatojaacʉ niwĩ. Nipeꞌtirã niꞌcãrõ meꞌrã Beerseba wãmetiropʉ waꞌacãrã niwã. Topʉ Abrahã niseticũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yoáca beꞌropʉ Abrahã cʉ̃ acabiji Nacor ye quetire tʉꞌocʉ niwĩ. Nacor nʉmo Milca wĩꞌmarãrẽ cʉ̃rẽ põꞌrãtibosaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz wãmetigʉ bajuamʉꞌtãꞌcʉ niwĩ. Cʉ̃ beꞌrore cʉ̃ acabiji Buz bajuacʉ niwĩ. Buz beꞌrore Kemuel, Aram pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Beꞌro aꞌticʉrã bajuanemocãrã niwã: Quesed, Hazo, Pildas, Jidlaf, Betuel. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ãꞌrĩ Betuel Rebeca pacʉ nicʉ niwĩ. Ãꞌrã ochore Abrahã acabiji Nacor, Milca meꞌrã põꞌrãticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ãpẽrã Nacor nʉmo Milca peꞌsu Reúma põꞌrã Teba, Gaham, Tahas, Maaca nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara ciento veintisiete cʉ̃ꞌmarĩ catico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ticʉse cʉ̃ꞌmarĩ cʉogo, Quiriat-arba wãmetiropʉ Canaá diꞌta nirĩ macãpʉ wẽrĩco niwõ. Quiriat-arba, apetero Hebrṍ pisunoꞌcaro niwʉ̃. Abrahã Sara wẽrĩcã ĩꞌagʉ̃, uti, dʉjasewãꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tojo uti, co wẽrĩꞌco tiropʉ níꞌcʉ wija, hitita masã nirõpʉ na meꞌrã ucũgʉ̃ waꞌacʉ niwĩ. Aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Yʉꞌʉ mʉsã waꞌteropʉre apesecjʉ̃ nimicã, niꞌcã ʉ̃tã tuti yʉꞌʉ nʉmorẽ yaatji tutire duaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Cʉ̃ tojo nicã tʉꞌorã, hitita masã cʉ̃rẽ yʉꞌticãrã niwã: ");
INSERT INTO tuoNT_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Ʉ̃sãrẽ tʉꞌoníña yujupʉ. Mʉꞌʉ ʉ̃sã waꞌterore niꞌcʉ̃ Õꞌacʉ̃ beseꞌcʉ, wiogʉ macʉ̃ weronojõ niꞌi. Tojo weegʉ mʉꞌʉ nʉmorẽ ʉ̃sã ye ʉ̃tã tutiri waꞌtero añurĩ tutipʉ yaaya. Ne niꞌcʉ̃ ʉ̃sã waꞌteropʉ nigʉ̃́, “Ya tuti niꞌi, yaaticãꞌña”, nisome. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tojo weegʉ Abrahã wãꞌcãnʉꞌcã, hitita masãrẽ paamuꞌrĩqueꞌa, ");
INSERT INTO tuoNT_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","narẽ nicʉ niwĩ: —To pũrĩcãrẽ mʉsã yʉꞌʉ nʉmorẽ aꞌto yaacã ʉarã, Efrṍ, Zohar macʉ̃rẽ aꞌtiro ni sẽrĩbosaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Niꞌcã ʉ̃tã tuti Macpela wãmetiri tuti cʉ̃ ya diꞌta nitʉoro nirĩ tutire yʉꞌʉre duato. Yʉꞌʉ ti tuti wapatiro ejatuaro wapayegʉti. Yʉꞌʉ tore duugʉ, mʉsã waꞌteropʉ yaari tuti cʉogʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrṍ hitita masʉ̃ na waꞌteropʉ dujicʉ niwĩ. Tojo weegʉ nipeꞌtirã cʉ̃ acawererã tʉꞌoropʉ, tojo nicã nipeꞌtirã macã sãjãrĩ sope tiro yʉꞌrʉarã tʉꞌoro aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Niweꞌe, yʉꞌʉ wiogʉ. Añurõ tʉꞌoya. Yʉꞌʉ mʉꞌʉrẽ ti diꞌtare, tojo nicã ti diꞌtapʉ nirĩ tutire wapamarĩrõ oꞌogʉti. Yʉꞌʉ acawererã tʉꞌoropʉ mʉꞌʉrẽ ti diꞌtare oꞌoꞌo. Mʉꞌʉ nʉmorẽ yaaya majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahã peꞌe apaturi tocjãrã masãrẽ paamuꞌrĩqueꞌacʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Tojo wee, masã to nirã́ tʉꞌoro Efrṍrẽ nicʉ niwĩ: —Yʉꞌʉre tʉꞌoya. Ti diꞌta wapa queoro wapayegʉti. Mʉꞌʉ “Jaʉ”, nicã, topʉ yʉꞌʉ nʉmorẽ yaagʉti majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Cʉ̃ tojo nicã, Efrṍ yʉꞌticʉ niwĩ tja: ");
INSERT INTO tuoNT_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Wiogʉ, yʉꞌʉre tʉꞌoya. Ti diꞌta cuatrocientos niyeru cujiri wapatiꞌi. Ti diꞌta wapatisere ucũnemoticãꞌrã. Mʉꞌʉ nʉmorẽ yaagʉ waꞌaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahã, “Jaʉ” ni, Efrṍ hitita masã ĩꞌorõpʉ tocãꞌrõ wapatiꞌi níꞌcarore cuatrocientos niyeru cujirire wapayecʉ niwĩ. Tocjãrã duari masã wapayeꞌcaronojõta wapayecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Tojo weero nipeꞌtise Efrṍ duaꞌque diꞌta Abrahã ye tojacaro niwʉ̃. Ʉ̃tãtuti, yucʉpagʉ nipeꞌtise cʉ̃ ye tojacaro niwʉ̃. Ti diꞌta Macpela wãmeticaro niwʉ̃. Mamre mujĩpũ mʉjãtiro peꞌe tojacaro niwʉ̃. Hitita masã, tojo nicã nipeꞌtirã ti macã sãjãrĩ sopere yʉꞌrʉarã ĩꞌorõpʉ wapayecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Beꞌro Abrahã cʉ̃ nʉmo Sarare ʉ̃tã tutipʉ yaacʉ niwĩ. Ti tuti Macpela wãmetiropʉ Mamre mujĩpũ mʉjãtiro peꞌe nicaro niwʉ̃. Totá tja apetero Hebrṍ wãmeticaro niwʉ̃. Canaá wãmetiri diꞌtapʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tojo weero ti diꞌta, ʉ̃tã tuti topʉ nirĩ tuti, hitita masã Abrahã cʉ̃ acawererãrẽ yaatjore duacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahã bʉcʉ waro nicʉ niwĩ. Nipeꞌtise cʉ̃ weesetise meꞌrã Õꞌacʉ̃ cʉ̃rẽ añurõ waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Niꞌcã nʉmʉ cʉ̃rẽ daꞌracoꞌtegʉ ãpẽrã yʉꞌrʉoro bʉcʉ nigʉ̃rẽ pijicʉ niwĩ. Cʉ̃ nipeꞌtise Abrahã cʉosere ĩꞌanʉrʉ̃gʉ̃ nicʉ niwĩ. Abrahã cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ omocãrẽ ya ʉsó docapʉ cũuña. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Õꞌacʉ̃ marĩ wiogʉ ʉꞌmʉse, diꞌta weeꞌcʉ wãme meꞌrã mʉꞌʉ “Aꞌtiro weegʉti” nicã ʉasaꞌa. Ne yʉꞌʉ macʉ̃ Isaare aꞌto Canaá yʉꞌʉ nirĩ diꞌtacjõ meꞌrã nʉmoticã weeticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tojo weetigʉ, ya diꞌtapʉ waꞌa, yʉꞌʉ acawererã numia waꞌteropʉre cʉ̃ nʉmo niacjore besegʉ waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Cʉ̃rẽ daꞌracoꞌtegʉ yʉꞌticʉ niwĩ: —Co numio yʉꞌʉ meꞌrã aꞌtisĩꞌrĩticã, ¿deꞌro weegʉsari? ¿Tojo weecãma, yʉꞌʉ mʉꞌʉ macʉ̃rẽ mʉꞌʉ wijawãꞌcãtica diꞌtapʉre miagʉ̃sari? ");
INSERT INTO tuoNT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahã cʉ̃rẽ yʉꞌticʉ niwĩ: —Niweꞌe. Topʉ yʉꞌʉ macʉ̃rẽ miaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yʉꞌʉ wiogʉ Õꞌacʉ̃ ʉꞌmʉsecjʉ̃, yʉꞌʉ pacʉ ya wiꞌi níꞌcʉre, tojo nicã yʉꞌʉ acawererã ya diꞌtapʉ níꞌcʉre miiwĩorẽwĩ. Miiwĩorẽ, aꞌti diꞌtare “Mʉꞌʉ pãrãmerã nituriarãrẽ oꞌogʉti”, niwĩ. Cʉ̃ta mʉꞌʉ dʉporo cʉ̃rẽ werecoꞌtegʉre oꞌoyugʉsami. Tojo weegʉ mʉꞌʉ yʉꞌʉ macʉ̃ nʉmo niacjo tocjõrẽ boca, miitigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Co numio mʉꞌʉ meꞌrã aꞌtisĩꞌrĩticã, yʉꞌʉ mʉꞌʉrẽ “Tojo weegʉsaꞌa” níꞌque tojo tojacãꞌrõsaꞌa. Mejõ yʉꞌʉ macʉ̃rẽ topʉ ne miaticãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tojo wee cʉ̃rẽ daꞌracoꞌtegʉ cʉ̃ ya omocãrẽ cʉ̃ wiogʉ Abrahã ʉsó docapʉ ñapeocʉ niwĩ. Beꞌro “Õꞌacʉ̃ tʉꞌoropʉ diacjʉ̃ta weegʉti mʉꞌʉ dutiꞌquere”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Beꞌro cʉ̃ wiogʉ yarã cameyoa diez, tojo nicã apeye peje añuse Abrahã cʉ̃ oꞌoatjere miicʉ niwĩ. Tere mii, Nacor wãmetiri macã, Mesopotamia diꞌtapʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Abrahãrẽ daꞌracoꞌtegʉ ti macã sumuto ejari cura, naꞌiqueꞌaro weecaro niwʉ̃. Ti horata numia aco waarã waꞌacãrã niwã. Cʉ̃ peꞌe cameyoare aco waari pe tiro soodutigʉ cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Tojo weetoja, Õꞌacʉ̃rẽ aꞌtiro sẽrĩcʉ niwĩ: “Õꞌacʉ̃, yʉꞌʉ wiogʉ Abrahã ẽjõpeogʉ, niꞌcãcãrẽ yʉꞌʉre añurõ waꞌacã weeya. Yʉꞌʉ wiogʉre mʉꞌʉ maꞌisere ĩꞌoña. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aꞌto aco waari pe tiro tojánígʉ̃ti yujupʉ. Aꞌtocjãrã numia aco waarã aꞌticã, ");
INSERT INTO tuoNT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","yʉꞌʉ niꞌcõrẽ aꞌtiro nigʉ̃ti: ‘Acotʉre miidijoya. Sĩꞌrĩgʉ̃tigʉ weeꞌe.’ Co ‘Sĩꞌrĩña. Mʉꞌʉ yarã cameyoa quẽꞌrãrẽ tĩagõti,’ tojo yʉꞌtigo cóta mʉꞌʉ beseꞌco mʉꞌʉrẽ daꞌracoꞌtegʉ Isaa nʉmo niacjo nigõsamo. Mʉꞌʉ tojo weecã ĩꞌagʉ̃, ‘Diacjʉ̃ta yʉꞌʉ wiogʉ Abrahãrẽ añurõ weemi’, nigʉ̃saꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Cʉ̃ Õꞌacʉ̃rẽ sẽrĩtuꞌajaticãta, niꞌcõ numio acotʉ wʉawãꞌcãtigore ĩꞌacʉ niwĩ. Co Rebeca, Betuel macõ nico niwõ. Betuel Milca, Nacor macʉ̃ nicʉ niwĩ. Nacor Abrahã acabiji nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeca añugõ nico niwõ. Ne niꞌcʉ̃ ʉmʉ meꞌrã niñaꞌtico niwõ. Aco waari pepʉ buꞌa, acore waamii, majãgõ weeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Co majãcã ĩꞌagʉ̃, Abrahãrẽ daꞌracoꞌtegʉ peꞌe omasirutuwãꞌcã, core ẽmʉeja, nicʉ niwĩ: —Mʉꞌʉ yʉꞌʉre pajañaꞌcureya. Aco mʉꞌʉ waaꞌquere cãꞌrõ tĩaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","—Jaʉ, sĩꞌrĩgʉ̃ aꞌtia, nico niwõ. Tojo wee, acotʉre miidijo, cʉ̃rẽ tĩaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cʉ̃ sĩꞌrĩtojáca beꞌro, Rebeca cʉ̃rẽ nico niwõ: —Mʉꞌʉ yarã cameyoa quẽꞌrãrẽ miibosago waꞌagoti. Na sĩꞌrĩsĩꞌrĩrõ põtẽorõ sĩꞌrĩrãsama, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nipeꞌtirã cameyoa sĩꞌrĩato nígõ, pejetiri acore waa, ʉmʉñarõ meꞌrã na sĩꞌrĩrĩ coꞌropʉ piosãamʉjãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Co tojo weesere ĩꞌagʉ̃, Abrahãrẽ daꞌracoꞌtegʉ “Yʉꞌʉ aꞌtopʉ aꞌticã, Õꞌacʉ̃ cʉ̃ ‘Aꞌtiro weegʉti’ níꞌquere ¿diacjʉ̃ta weegʉsari?”, ni tʉꞌoñaꞌgʉ̃, tojo ĩꞌacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cameyoa sĩꞌrĩtuꞌajaca beꞌro, Abrahãrẽ daꞌracoꞌtegʉ ẽꞌquẽa yoosari beꞌto, uru meꞌrã wééca beꞌto, seis gramo nʉcʉ̃rĩ beꞌtore mii, ẽꞌquẽapʉ yoocʉ niwĩ. Tojo nicã pʉa beꞌto omocã tuusãase uru meꞌrã weeꞌque beꞌtorire, cien gramo nemorõ nʉcʉ̃sere oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Oꞌotojanʉꞌcõ, core nicʉ niwĩ: —¿Noa macõ niti mʉꞌʉ? ¿Mʉꞌʉ pacʉ ya wiꞌipʉre cãrĩrõ niati yʉꞌʉmasã meꞌrã cãrĩatjo? ");
INSERT INTO tuoNT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Co yʉꞌtico niwõ: —Yʉꞌʉ Betuel macõ niꞌi. Cʉ̃ Milca, Nacor macʉ̃ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ʉ̃sã ya wiꞌipʉre mʉsã cãrĩatjo niapʉ. Tojo nicã cameyoa na baꞌase tá peje niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tojo nicã tʉꞌogʉ, Abrahãrẽ daꞌracoꞌtegʉ ejaqueꞌa, Õꞌacʉ̃rẽ eꞌcatipeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Aꞌtiro nicʉ niwĩ: “Õꞌacʉ̃, Abrahã yʉꞌʉ wiogʉ ẽjõpeogʉ, mʉꞌʉ añuyʉꞌrʉaꞌa. Yʉꞌʉ wiogʉre añurõ wéégʉ, mʉꞌʉ ‘Aꞌtiro weegʉti’ níꞌquere queoro weeapʉ. Yʉꞌʉ quẽꞌrãrẽ cʉ̃ acawererã ya wiꞌipʉ miitiapʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Beꞌro Rebeca nipeꞌtise core waꞌaꞌquere werego waꞌago, co paco ya wiꞌipʉ omawãꞌcãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Co maꞌmi Labán wãmeticʉ niwĩ. Co tojo nicã tʉꞌogʉ, Abrahãrẽ daꞌracoꞌtegʉre aꞌmagʉ̃ waꞌagʉ, aco waari pe tiro omawãꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Cʉ̃ acabijo ẽꞌquẽapʉ yoosari beꞌto, omocã tuusãase beꞌtori miiejacã ĩꞌatojacʉ niwĩ. Tojo nicã, Abrahãrẽ daꞌracoꞌtegʉ core wereꞌquere tʉꞌopeꞌocãꞌcʉ niwĩ. Tojo weegʉ Labán cʉ̃rẽ aꞌmagʉ̃ waꞌacʉ niwĩ. Aco pe tiropʉta, cʉ̃ yarã cameyoa meꞌrã nigʉ̃rẽ bocaejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labán cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Aꞌtia, Õꞌacʉ̃ añurõ weenoꞌgʉ̃. ¿Deꞌro weegʉ mʉꞌʉ aꞌto wijaropʉ nuꞌcũti? Mʉꞌʉ cãrĩatjo, tojo nicã cameyoa niatjo apobosatojapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tojo weegʉ Abrahãrẽ daꞌracoꞌtegʉ wiꞌipʉ sãjãacʉ niwĩ. Topʉ Labán cameyoa na oꞌmaꞌquere miidijo, narẽ baꞌase ecacʉ niwĩ. Tojo wééca beꞌro Abrahãrẽ daꞌracoꞌtegʉ, cʉ̃ meꞌrãcjãrãrẽ dʉꞌpocãrĩ coeato nígʉ̃, aco miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Na baꞌase etiri cura, Abrahãrẽ daꞌracoꞌtegʉ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ mʉsãrẽ nigʉ̃ti níꞌquere weretimigʉ̃, baꞌatisaꞌa. —To pũrĩcãrẽ ucũmʉꞌtaña, nicʉ niwĩ Labán. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Abrahãrẽ daꞌracoꞌtegʉ narẽ nicʉ niwĩ: —Yʉꞌʉ Abrahãrẽ daꞌracoꞌtegʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Õꞌacʉ̃ yʉꞌʉ wiogʉ Abrahãrẽ añurõ weeami. Peje cʉogʉ waꞌacã weeami. Cʉ̃rẽ oveja, wecʉa, uru, niyeru plata wãmetise, daꞌracoꞌterã ʉmʉa, numia, cameyoa, tojo nicã burroa oꞌowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Apeyema cʉ̃ nʉmo Sara bʉcʉo nimigõ, niꞌcʉ̃ põꞌrãtiwõ. Yʉꞌʉ wiogʉ cʉ̃ macʉ̃rẽ nipeꞌtise cʉ̃ cʉosere oꞌowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Yʉꞌʉ wiogʉ yʉꞌʉre, cʉ̃ macʉ̃rẽ ne niꞌcõ ti diꞌta Canaá cʉ̃ nirõcjõ meꞌrã omocã dʉꞌtedutitiwĩ. Tere nígʉ̃, yʉꞌʉre cʉ̃ dutisere Õꞌacʉ̃ wãme meꞌrã “Diacjʉ̃ta mʉꞌʉ dutiro weegʉti”, ni yʉꞌtidutiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Cʉ̃ yʉꞌʉre ninemowĩ: “Yʉꞌʉ pacʉ acawererã tiropʉ waꞌa, to nirã́ numia waꞌterore niꞌcõ cʉ̃ nʉmo niacjore aꞌmaña”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Yʉꞌʉ peꞌe yʉꞌʉ wiogʉre niwʉ̃: “Yʉꞌʉ wiogʉ, co numio yʉꞌʉ meꞌrã aꞌtisĩꞌrĩticã warore, ¿deꞌro weegʉsari?” ");
INSERT INTO tuoNT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Cʉ̃ yʉꞌʉre yʉꞌtiwĩ: “Yʉꞌʉ Õꞌacʉ̃ ʉaronojõ nisetigʉ niꞌi. Mʉꞌʉ waꞌaro añurõ waꞌato nígʉ̃, mʉꞌʉ meꞌrã Õꞌacʉ̃ cʉ̃rẽ werecoꞌtegʉre oꞌógʉsami. Tojo weegʉ yʉꞌʉ pacʉ acawererã põꞌrã numia waꞌterore niꞌcõ yʉꞌʉ macʉ̃ nʉmo niacjore bocagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Na yʉꞌʉ acawererã core oꞌosĩꞌrĩticãma, mʉꞌʉ ‘Tojo weegʉti’ níꞌque tojo tojacãꞌrõsaꞌa”, niwĩ yʉꞌʉre. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","»Niꞌcãcã aco waari pe tiropʉ ejagʉ, Õꞌacʉ̃, yʉꞌʉ wiogʉ Abrahã ẽjõpeogʉre sẽrĩapʉ: “Mʉꞌʉ ʉaro yʉꞌʉ aꞌtopʉ aꞌtisere añurõ waꞌacã weebosaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mʉꞌʉ aꞌtiro weecã ʉasaꞌa. Niꞌcãrõacã yʉꞌʉ aco waari pe tiro nirĩ cura aꞌtiro waꞌato. Niꞌcõ numio aco waago aꞌticã, yʉꞌʉ aꞌtiro nigʉ̃saꞌa: ‘Mʉꞌʉ aco waasere cãꞌrõ tĩacureya.’ ");
INSERT INTO tuoNT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Co yʉꞌʉre ‘Sĩꞌrĩña, mʉꞌʉ yarã cameyoa quẽꞌrãrẽ tĩagõti,’ nigṍ, cóta mʉꞌʉ beseꞌco yʉꞌʉ wiogʉ macʉ̃ nʉmo niacjo nigõsamo”, ni sẽrĩwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Yʉꞌʉ Õꞌacʉ̃rẽ sẽrĩtuꞌajatimigʉ̃, Rebeca aco co waatjʉre wʉawãꞌcãtigore ĩꞌapʉ. Aco waari pepʉ buꞌa, acore waamiiamo. Core niapʉ: “Mʉꞌʉ aco waaꞌquere yʉꞌʉre cãꞌrõ tĩaña”, niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tojo weego acotʉre miidijo, yʉꞌʉre niamo: “Jaʉ, sĩꞌrĩña. Mʉꞌʉ yarã cameyoa quẽꞌrãrẽ tĩagõti.” Yʉꞌʉre aco tĩa, yarã cameyoa quẽꞌrãrẽ tĩamo. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","»Beꞌro core sẽrĩtiñaꞌpʉ: “¿Noa macõ niti mʉꞌʉ?” Co yʉꞌʉre yʉꞌtiamo: “Yʉꞌʉ Betuel macõ niꞌi. Cʉ̃ Nacor, Milca macʉ̃ nimi”, niamo. Beꞌro ẽꞌquẽa yoosari beꞌtore ẽꞌquẽapʉ yooapʉ. Tojo nicã pʉa beꞌto omocã tuusãase beꞌtorire tuusãapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tojo weetoja, yʉꞌʉ ejaqueꞌa, Õꞌacʉ̃rẽ, Abrahã yʉꞌʉ wiogʉ ẽjõpeogʉre eꞌcatise oꞌoapʉ. Cʉ̃ yʉꞌʉ wiogʉ acawererã tiropʉ waꞌari maꞌarẽ queoro ĩꞌoami. Cʉ̃ yʉꞌʉ wiogʉ Abrahã macʉ̃ nʉmo niacjore miidutigʉ, tojo weeami. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Niꞌcãrõacãma majã, yʉꞌʉ wiogʉ ʉasere añurõ eꞌcatise meꞌrã yʉꞌtisĩꞌrĩrã, wereya. Tojo yʉꞌtisĩꞌrĩtirã quẽꞌrã, wereya. Tojo weegʉ yʉꞌʉ weeatjere masĩgʉ̃saꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Cʉ̃ tojo nicã tʉꞌorã, Labán, Betuel yʉꞌticãrã niwã: —Aꞌte nipeꞌtise Õꞌacʉ̃ weese niꞌi. Ʉ̃sã ne “Tojota waꞌato, tojo waꞌaticãꞌto”, nímasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Aꞌtigo nimo Rebeca. Core miaña majã. Õꞌacʉ̃ ʉaronojõta mʉꞌʉ wiogʉ macʉ̃ nʉmo nigõsamo, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abrahãrẽ daꞌracoꞌtegʉ na tojo nicã tʉꞌogʉ, Õꞌacʉ̃rẽ eꞌcatipeogʉ ejaqueꞌa, paamuꞌrĩqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Õꞌacʉ̃rẽ eꞌcatise oꞌóca beꞌro, apeyenojõ uru, plata meꞌrã weeꞌquenojõrẽ, tojo nicã suꞌtire Rebecare oꞌocʉ niwĩ. Tojo nicã co maꞌmirẽ, co pacore apeyenojõ wapabʉjʉsenojõrẽ oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Beꞌro cʉ̃rẽ baꞌpatiꞌcãrã meꞌrã baꞌa, sĩꞌrĩ, topʉta cãrĩcãrã niwã. Ape nʉmʉ wãꞌcã, Abrahãrẽ daꞌracoꞌtegʉ narẽ nicʉ niwĩ: —Yʉꞌʉ wiogʉ ya wiꞌipʉ dajatojaacã, mʉsã macõrẽ oꞌoya majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tojo nicã tʉꞌorã, Rebeca maꞌmi, co paco aꞌtiro nicãrã niwã: —Co diez nʉmʉrĩ ʉ̃sã meꞌrã tojáníato yujupʉ. Beꞌro mʉꞌʉ meꞌrã waꞌagosamo majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Abrahãrẽ daꞌracoꞌtegʉ peꞌe aꞌtiro nicʉ niwĩ: —Yʉꞌʉ tojaacã, cãꞌmotaꞌanemoticãꞌña majã. Õꞌacʉ̃ yʉꞌʉ aꞌtiꞌquere añurõ waꞌacã weetojami. Tojo weerã yʉꞌʉ wiogʉ ya wiꞌipʉ dajatojaadutiya. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Cʉ̃ tojo nicã tʉꞌorã, na yʉꞌticãrã niwã: —Jaʉ. Rebecare pijiñaꞌrã marĩ, ¿deꞌro ni yʉꞌtigosari co? ");
INSERT INTO tuoNT_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tojo weerã Rebecare pijio, sẽrĩtiñaꞌcãrã niwã: —¿Mʉꞌʉ ãꞌrĩ ʉmʉ meꞌrã waꞌasĩꞌrĩsari? —Ʉ̃ʉ, waꞌagoti, ni yʉꞌtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Co tojo nicã tʉꞌorã, Rebecare, core masõꞌco quẽꞌrãrẽ oꞌócãrã niwã. Tojo nicã, Abrahãrẽ daꞌracoꞌtegʉre, cʉ̃rẽ baꞌpatiꞌcãrã meꞌrã waꞌaduticãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebecare añurõ waꞌato nírã, aꞌtiro nicãrã niwã: “Numió, Õꞌacʉ̃ mʉꞌʉrẽ pãjãrã paco nicã weeato. Mʉꞌʉ pãrãmerã nituriarã narẽ ĩꞌatuꞌtirã nise macãrĩcjãrã meꞌrã aꞌmewẽjẽ wapataꞌato.” ");
INSERT INTO tuoNT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na core tojo níca beꞌro, Rebeca, core daꞌracoꞌterã numia meꞌrã cameyoa buꞌipʉ mʉjãpeja, Abrahãrẽ daꞌracoꞌtegʉre sirutuwãꞌcãcãrã niwã. Tojo wee, Abrahãrẽ daꞌracoꞌtegʉ Rebecare mia, to níꞌcʉ waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaa peꞌe aco waari pe, “Catinuꞌcũgʉ̃, yʉꞌʉre ĩꞌagʉ̃ ya pe” wãmetiropʉ níꞌcʉ majãmitojaticʉ niwĩ. Cʉ̃ peꞌe Neguev wãmetiropʉ niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Naꞌiqueꞌawãꞌcãtiri cura sijagʉ waꞌacʉ niwĩ. Tojo weegʉ cameyoa aꞌticã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca quẽꞌrã cʉ̃rẽ ĩꞌaco niwõ. Isaare ĩꞌagõta, cameyo buꞌipʉ pesaꞌco dijaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abrahãrẽ daꞌracoꞌtegʉre sẽrĩtiñaꞌco niwõ: —¿Noa niti sĩꞌi marĩrẽ põtẽrĩgʉ̃ aꞌtigʉ? nico niwõ. —Yʉꞌʉ wiogʉ nimi, nicʉ niwĩ. Tere tʉꞌogo, suꞌtiro casero meꞌrã co diapoare moꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Abrahãrẽ daꞌracoꞌtegʉ Isaare nipeꞌtise cʉ̃ weeꞌquere werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Beꞌro Isaa Rebecare cʉ̃ paco Sara níca wiꞌi, waꞌicʉ caseri meꞌrã wééca wiꞌipʉ mia waꞌacʉ niwĩ. Tojo wee cʉ̃ nʉmo tojaco niwõ. Isaa Rebecare pũrõ maꞌicʉ niwĩ. Aꞌte meꞌrã cʉ̃ paco wẽrĩꞌquere wãcũtutuacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahã apego nʉorẽcʉ niwĩ. Co Cetura wãmetico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Co meꞌrã aꞌtiro wãmetirãrẽ põꞌrãticʉ niwĩ. Zimram, Jocsán, Medán, Madiã́, Isbac, Súa nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán põꞌrã Seba, Dedán nicãrã niwã. Dedán pãrãmerã nituriarã asureo masã, letuseo masã, leumeo masã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiã́ põꞌrã Efa, Efer, Hanoc, Abida, Elda nicãrã niwã. Ãꞌrã nipeꞌtirã Cetura põꞌrã nituriarã pãjãrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Isaa Abrahã cʉ̃ pacʉ cʉoꞌque nipeꞌtisere cʉosirutucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ãpẽrã cʉ̃ põꞌrã, ãpẽrã numia meꞌrã põꞌrãtiꞌcãrã peꞌema cãꞌrõ apeyenojõacãrẽ oꞌocʉ niwĩ. Abrahã cʉ̃ catícaterore cʉ̃ macʉ̃ Isaa tiropʉ niticãꞌto nígʉ̃, narẽ apero mujĩpũ mʉjãtiro nirĩ diꞌtapʉ oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahã ciento setenta y cinco cʉ̃ꞌmarĩ caticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Cʉ̃ muꞌñu meꞌrã wẽrĩcʉ niwĩ. Cʉ̃ ñecʉ̃sʉmʉa mejãrã wẽrĩꞌcaronojõta cʉ̃ quẽꞌrã wẽrĩsirutudijacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Cʉ̃ põꞌrã Isaa, Ismae Macpela nirĩ tutipʉ cʉ̃rẽ yaarã waꞌacãrã niwã. To mujĩpũ mʉjãtiro Mamre wãmetiropʉ tojasaꞌa. Ti tuti Efrṍ Zohar macʉ̃ hitita masʉ̃ ya diꞌtapʉ tojasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ti diꞌtare Abrahã hitita masãrẽ duucʉ niwĩ. Topʉ Abrahãrẽ yaacãrã niwã. Cʉ̃ nʉmo Sarare yaaꞌcaro pʉꞌtopʉta yaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahã wẽ́rĩ́ca beꞌro Õꞌacʉ̃ cʉ̃ macʉ̃ Isaare añurõ waꞌacã weecʉ niwĩ. Cʉ̃ niꞌcã aco pe tiro niseticʉ niwĩ. Ti pere aꞌtiro pisucãrã niwã: “Catinuꞌcũgʉ̃, yʉꞌʉre ĩꞌagʉ̃ ya pe” pisucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Aꞌte Ismae, Abrahã macʉ̃ ye queti niꞌi. Cʉ̃ Agar macʉ̃ nicʉ niwĩ. Agar Egiptocjõ, Abrahã nʉmo Sarare daꞌracoꞌtego nico niwõ. Ismae põꞌrã aꞌticʉrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Bajuamʉꞌtãꞌcʉ meꞌrã werenʉꞌcãnoꞌrõsaꞌa. Masã maꞌmi Nebaiot wãmeticʉ niwĩ. Beꞌrocjãrã Cedar, Adbeel, Mibsam, ");
INSERT INTO tuoNT_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO tuoNT_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis, Cedema wãmeticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na Ismae põꞌrã doce nicãrã niwã. Na wãme meꞌrãta na ye diꞌta wãmerẽ na nirõpʉre masĩnoꞌcaro niwʉ̃. Nanʉcʉ̃ curari na yarã masãrẽ wejepeori masã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismae ciento treinta y siete cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. Tojo weegʉ cʉ̃ ñecʉ̃sʉmʉa mejãrã wẽ́rĩ́ꞌcaronojõta wẽrĩsirutudijacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Cʉ̃ põꞌrã nituriarã pãjãrã Havila wãmetiro meꞌrã nʉꞌcã, téé Shur wãmetiropʉ niseticãrã niwã. To Egipto põtẽorõ Asiria waꞌaropʉ nisaꞌa. To nirṍ nipeꞌtirã na acawererã ʉatimicã, niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aꞌte Isaa, Abrahã macʉ̃ ye queti niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaa cuarenta cʉ̃ꞌmarĩ cʉogʉ, Rebecare nʉmoticʉ niwĩ. Co Betuel macõ, Labán acabijo nico niwõ. Na arameo masã Padan-arãcjãrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca ne põꞌrã marĩco niwõ. Tojo weegʉ Isaa Õꞌacʉ̃rẽ sẽrĩbosacʉ niwĩ. Õꞌacʉ̃ cʉ̃ sẽrĩsere tʉocʉ niwĩ. Tojo weego co nijĩpaco tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Wĩꞌmarã pʉarã paagapʉre aꞌmequẽsãñacãrã niwã. Tojo weego co aꞌtiro wãcũco niwõ: “Na tojo weenuꞌcũcãma, yʉꞌʉ mejõ waro catimaꞌabosaꞌa. Mejõ peꞌe wẽrĩrõʉasaꞌa”, ni wãcũco niwõ. Tojo weego Õꞌacʉ̃rẽ “¿Deꞌro weero tojo nimitito?” ni sẽrĩtiñaꞌco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Õꞌacʉ̃ core yʉꞌticʉ niwĩ: “Mʉꞌʉ paaga poꞌpeapʉre pʉa diꞌta, pʉa macãcjãrã sãñama. Na bajuatji dʉporo aꞌmequẽsãñatojama. Niꞌcʉ̃ apĩ nemorõ tutuayʉꞌrʉagʉ nigʉ̃sami. Masã maꞌmi cʉ̃ acabiji dutisere yʉꞌtigʉsami”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Beꞌro Rebeca wĩꞌmarãrẽ wʉari nʉmʉ ejacaro niwʉ̃. Na pʉarã sʉꞌrʉaꞌcãrã páápʉ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ne bajuamʉꞌtãgʉ̃ poari sõꞌagʉ̃ nicʉ niwĩ. Tojo nicã, cʉ̃ upʉpʉre poaripijagʉ nicʉ niwĩ. Cʉ̃rẽ Esaú pisucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Beꞌro cʉ̃ acabiji cʉ̃ dʉꞌpodiapʉ niꞌcã omocã meꞌrã ñeꞌetjĩagʉ̃ bajuacʉ niwĩ. Tojo weeyucã, cʉ̃rẽ Jacob pisucãrã niwã. Isaa sesenta cʉ̃ꞌmarĩ cʉori cura, Rebeca narẽ põꞌrãtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Siapeꞌe meꞌrã wĩꞌmarã bʉcʉacãrã niwã. Esaú cãpũpʉ sijasere tʉꞌsa, waꞌicʉrã muꞌsĩgʉ̃ nicʉ niwĩ. Jacob peꞌe sõꞌowaro niticʉ niwĩ. Cʉ̃ wiꞌipʉ niseticãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaa waꞌicʉrã nʉcʉ̃cjãrãrẽ baꞌatʉꞌsayugʉ, cʉ̃ macʉ̃ Esaú peꞌere maꞌiyʉꞌrʉnʉꞌcãcʉ niwĩ. Paco Rebeca peꞌe Jacore maꞌiyʉꞌrʉnʉꞌcãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Niꞌcã nʉmʉ Jacob cʉ̃ baꞌase doꞌari cura Esaú nʉcʉ̃pʉ sijagʉ ejaꞌcʉ ʉjʉaboayʉꞌrʉaꞌcʉ dajacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Tojo weegʉ cʉ̃ acabijire nicʉ niwĩ: —Yʉꞌʉre pajañaꞌña. Sise baꞌase sõꞌase mʉꞌʉ cʉosere yʉꞌʉre oꞌocureya. Yʉꞌʉ ʉjʉaboa wẽrĩgʉ̃ weesaꞌa, nicʉ niwĩ. (Tojo weerã ape wãme Esaúre Edom pisusama.) ");
INSERT INTO tuoNT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob cʉ̃rẽ nicʉ niwĩ: —Tojo nígʉ̃ pũrĩcã, mʉꞌʉ masã maꞌmi nisere yʉꞌʉre duamʉꞌtãña. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tere tʉꞌogʉ, Esaú nicʉ niwĩ: —¿Mʉꞌʉ yʉꞌʉre ĩꞌaweti? Yʉꞌʉ ʉjʉaboa wẽrĩgʉ̃ weesaꞌa. Tojo weero yʉꞌʉ masã maꞌmi nise yʉꞌʉma wapamarĩꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob cʉ̃rẽ nicʉ niwĩ: —To pũrĩcãrẽ Õꞌacʉ̃rẽ wãmepeo, “Tojota weegʉti”, nibaqueꞌoya, nicʉ niwĩ. Tere tʉꞌogʉ, Esaú “Õꞌacʉ̃rẽ wãmepeo, diacjʉ̃ta niꞌi”, nicʉ niwĩ. Tojo weegʉ cʉ̃ acabijire cʉ̃ masã maꞌmi nisere duacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Beꞌro Jacob, Esaúre, pã́, tojo nicã cʉ̃ baꞌase doꞌaꞌquere ecacʉ niwĩ. Esaú baꞌa, sĩꞌrĩtojagʉ, wãꞌcãnʉꞌcã, waꞌa waꞌacʉ niwĩ. Cʉ̃ masã maꞌmi nisere “Tojo nisaꞌa”, ni wãcũticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abrahã cʉ̃ caticũcateropʉ waꞌaꞌcaronojõta nipeꞌtiro ti diꞌtapʉre baꞌase marĩcaro niwʉ̃. Tojo weegʉ Isaa Gerar wãmetiropʉ waꞌacʉ niwĩ. Topʉre filisteo masã wiogʉ Abimelec nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Topʉ Õꞌacʉ̃ cʉ̃rẽ bajua, ucũcʉ niwĩ. Aꞌtiro nicʉ niwĩ: “Egiptopʉre waꞌaticãꞌña. Yʉꞌʉ mʉꞌʉrẽ tojadutirota tojapa. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Niꞌcãrõacãrẽ aꞌti diꞌtata toja, níniꞌña yujupʉ. Yʉꞌʉ mʉꞌʉ meꞌrã nigʉ̃ti. Mʉꞌʉrẽ añurõ waꞌacã weegʉti. Mʉꞌʉrẽ, mʉꞌʉ pãrãmerã nituriarãrẽ aꞌti diꞌtare oꞌogʉti. Aꞌtiro wéégʉ, mʉꞌʉ pacʉ Abrahãrẽ yʉꞌʉ ‘Tojo weegʉti’ níꞌquere queoro waꞌacã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mʉꞌʉ pãrãmerã nituriarã pãjãrã ñocõa weronojõ nicã weegʉsaꞌa. Nipeꞌtise aꞌte diꞌtare oꞌogʉsaꞌa. Tojo nicã, nipeꞌtiri diꞌtacjãrã mʉꞌʉ pãrãmerã nituriarã meꞌrã añurõ waꞌacã weenoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abrahã yʉꞌʉ dutiꞌquere, yʉꞌʉ ‘Tojo weeya’ níꞌquere queoro yʉꞌtiwĩ. Tojo weegʉ tojo weegʉsaꞌa”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tere tʉꞌogʉ, Isaa Gerapʉ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Topʉ nirã́ masã Isaare Rebecare “Aꞌtigo waro ¿noanojõ niti?” ni sẽrĩtiñaꞌcãrã niwã. Isaa, “Yʉꞌʉre co ye buꞌiri wẽjẽbosama” ni uigʉ, “Yʉꞌʉ acabijo nimo”, nicʉ niwĩ. Co Rebeca añugõ niyucã, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Topʉ yoacã tojacʉ niwĩ. Niꞌcã nʉmʉ ti diꞌta wiogʉ Abimelec ventanapʉ yuꞌuĩꞌaꞌcʉ niwĩ. Tojo weeri cura Isaa cʉ̃ nʉmo Rebecare paasuꞌsu eꞌcaticã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Beꞌro Isaare pijio, aꞌtiro nicʉ niwĩ: —Co mʉꞌʉ nʉmo nimiapõ. ¿Deꞌro weegʉ “Yʉꞌʉ acabijo nimo” nisooati? —Apetero weerã yʉꞌʉre co ye buꞌiri wẽjẽbosama, ni wãcũasʉ, ni yʉꞌticʉ niwĩ Isaa. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tere tʉꞌogʉ, Abimelec nicʉ niwĩ: —¿Deꞌro weegʉ ʉ̃sãrẽ tojo niati? “Cʉ̃ nʉmo mejẽta nisamo”, ni wãcũgʉ̃, niꞌcʉ̃ aꞌti macãcjʉ̃ core nʉmotiboapĩ. Core tojo weecãma, mʉꞌʉ ʉ̃sãrẽ Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãcã weeboapã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tojo weegʉ Abimelec nipeꞌtirãrẽ niꞌcã dutise cũucʉ niwĩ. Te dutise aꞌtiro nicaro niwʉ̃: “Noꞌo niꞌcʉ̃ Isaare o cʉ̃ nʉmorẽ caribogʉnojõ wẽjẽnoꞌgʉ̃sami”, nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Topʉre Isaa otesere otecʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ añurõ waꞌacã weecʉ niwĩ. Tojo weero ti cʉ̃ꞌmarẽ cʉ̃ oteꞌque peje waro dʉcaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Siapeꞌe meꞌrã cʉ̃ cʉose bʉcʉanemocaro niwʉ̃. Tojo weegʉ cʉ̃ peje waro apeyenojõ cʉogʉ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Pãjãrã waro oveja, wecʉa cʉocʉ niwĩ. Cʉ̃rẽ daꞌracoꞌterã quẽꞌrãrẽ pãjãrã waro cʉocʉ niwĩ. Tere ĩꞌarã, filisteo masã cʉ̃rẽ ʉocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Todʉporopʉ cʉ̃ pacʉ Abrahã catícateropʉre cʉ̃rẽ daꞌracoꞌtecũꞌcãrã aco péri seꞌecãrã niwã. Filisteo masã Isaare ʉorã, te perire diꞌta meꞌrã yaabiꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Beꞌro cʉ̃ peje waro cʉocã, ĩꞌacũmí, Abimelec Isaare aꞌtiro nicʉ niwĩ: —Mʉꞌʉ aꞌtore wijayá. Peje waro ʉ̃sã yʉꞌrʉoro apeyenojõ cʉoyʉꞌrʉnʉꞌcãꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tojo weegʉ Isaa Gerapʉ nimiꞌcʉ wijacʉ niwĩ. Wija, to opa paꞌtiro nirõpʉ wiꞌseriacã wee, tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Topʉre cʉ̃ pacʉ catigʉ aco péri seꞌeꞌque perire cʉ̃ wẽ́rĩ́ca beꞌro filisteo masã diꞌta meꞌrã yaacãrã niwã. Isaa na yaaꞌque perire apaturi seꞌecʉ niwĩ. Cʉ̃ te perire seꞌéca beꞌro cʉ̃ pacʉ catigʉ wãme õꞌoꞌcaronojõta õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Niꞌcã nʉmʉ Isaare daꞌracoꞌteri masã opa paꞌtiro nirõpʉ aco pére seꞌérã, pajiro oꞌmawĩrõrĩ pere bocacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerapʉ nirã́ ovejare coꞌteri masã ti pere ãpẽrã Isaa yarã ovejare coꞌterã meꞌrã dʉꞌsasoocãrã niwã. Na “Ʉ̃sã ya pe niꞌi”, nicãrã niwã. Isaa yarã ovejare coꞌterã peꞌe quẽꞌrã “Ʉ̃sã ya pe peꞌe niꞌi”, ni aꞌmerĩ dʉꞌsasoomʉjãcãrã niwã. Tojo weegʉ Isaa ti pere “cumuca pe” wãme õꞌocʉ niwĩ. Na dʉꞌsasooyucã, tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Beꞌro cʉ̃rẽ daꞌracoꞌterã ape pe seꞌecãrã niwã. Ti pe quẽꞌrãrẽ mejãrõta dʉꞌsasoocãrã niwã. Tojo weegʉ Isaa ti pere “aꞌmerĩ ĩꞌasĩꞌrĩtiri pe” wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Beꞌro Isaa yoaropʉ waꞌa waꞌacʉ niwĩ. Topʉre aco pé ape pe seꞌecʉ niwĩ. Ti pema dʉꞌsasooticãrã niwã majã. Tojo weegʉ ti pere “añurĩ pjoaca pe, cumuca marĩrĩ pe” wãme õꞌocʉ niwĩ. Aꞌtiro nicʉ niwĩ: “Õꞌacʉ̃ marĩrẽ niꞌcãrõacãma añurĩ pjoa cũumi majã. Tojo weerã marĩ aꞌtopʉre añurõ niseti, daꞌrasetirãsaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","To níꞌcʉta Isaa Beersebapʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Topʉ cʉ̃ etáca ñamirẽ Õꞌacʉ̃ cʉ̃rẽ bajua, aꞌtiro nicʉ niwĩ: “Yʉꞌʉ, mʉꞌʉ pacʉ Abrahã ẽjõpeogʉ niꞌi. Yʉꞌʉ mʉꞌʉ meꞌrã niꞌi. Tojo weegʉ uiticãꞌña. Yʉꞌʉre daꞌracoꞌtegʉ Abrahãrẽ maꞌígʉ̃, mʉꞌʉrẽ añurõ waꞌacã weegʉti. Tojo nicã mʉꞌʉ pãrãmerãrẽ pãjãrã masãputicã weegʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tere tʉꞌogʉ, Isaa niꞌcãrõ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Topʉ Õꞌacʉ̃rẽ eꞌcatise oꞌogʉ, tojo weecʉ niwĩ. Topʉ wiꞌseri nʉꞌcõ, niseticʉ niwĩ. Cʉ̃rẽ daꞌracoꞌterã niꞌcã aco pé seꞌecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Niꞌcã nʉmʉ Abimelec Gerapʉ níꞌcʉ Isaa tiropʉ ucũgʉ̃ aꞌticʉ niwĩ. Cʉ̃rẽ werecasagʉ Ahuzat, tojo nicã Ficol surara wiogʉ cʉ̃rẽ baꞌpaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Narẽ ĩꞌagʉ̃, Isaa nicʉ niwĩ: —¿Deꞌro weerã yʉꞌʉre ĩꞌarã aꞌtiati? Yʉꞌʉre ʉatiwʉ. Mʉsã ya diꞌtapʉ nigʉ̃rẽ cõꞌawĩrõwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Na cʉ̃rẽ yʉꞌticãrã niwã: —Ʉ̃sã mʉꞌʉrẽ ĩꞌacã, Õꞌacʉ̃ mʉꞌʉ meꞌrã nimi. Tojo weerã “Mʉꞌʉ ʉ̃sãrẽ ñaꞌarõ weeri nírã, mʉꞌʉ meꞌrã Õꞌacʉ̃ tʉꞌoropʉ aꞌmerĩ aporoʉaꞌa”, ni wãcũasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Mʉꞌʉrẽ ne cãꞌrõ caribotiwʉ. Ʉ̃sã mʉꞌʉrẽ cariboronojõ oꞌorã, añurõ wejepeowʉ. Añurõ meꞌrã mʉꞌʉrẽ weꞌriti oꞌówʉ. Õꞌacʉ̃ mʉꞌʉrẽ niꞌcãrõacãrẽ añurõ weetamugʉ̃ weemi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tojo weegʉ Isaa narẽ pajiri bosenʉmʉ weepeocʉ niwĩ. Ti nʉmʉrẽ na baꞌa, sĩꞌrĩ yapaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ape nʉmʉ peꞌe boꞌreacã wãꞌcã, na Õꞌacʉ̃ wãme meꞌrã “Aꞌtiro weerã́” ni aꞌmerĩ apocãrã niwã. Beꞌro Isaa narẽ weꞌriti, “Añurõ waꞌaya”, nicʉ niwĩ. Na niꞌcãrõ meꞌrã tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na tojo weeri nʉmʉrẽta Isaare daꞌracoꞌteri masã na seꞌeri pere “Aco bocapʉ” ni, cʉ̃rẽ queti wererã etacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaa ti pere Seba wãme õꞌocʉ niwĩ. Tojo weero topʉ nirĩ macã niꞌcãrõacãrẽ Beerseba wãmetisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú cuarenta cʉ̃ꞌmarĩ cʉogʉ, Judit wãmetigore nʉmoticʉ niwĩ. Co Beeri wãmetigʉ hitita masʉ̃ macõ nico niwõ. Beꞌro apego nʉmotinemocʉ niwĩ tja. Co Basemat wãmetico niwõ. Co Elón wãmetigʉ hitita masʉ̃ macõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ãꞌrã pʉarã Esaú nʉmosãnumia Isaare, Rebecare pũrõ waro bʉjaweticã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaa bʉcʉ waro ẽjãgʉ̃, cʉ̃ caperi añurõ ĩꞌaticʉ niwĩ. Tojo weegʉ niꞌcã nʉmʉ cʉ̃ macʉ̃ masã maꞌmi Esaúre pijio, aꞌtiro nicʉ niwĩ: —¡Macʉ̃! Cʉ̃ tojo nicã, Esaú “¿Deꞌro niti, pacʉ?”, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","—Mʉꞌʉ ĩꞌacãta, yʉꞌʉ bʉcʉ waro niꞌi. Tojo weegʉ aꞌte nʉmʉrĩ noꞌo nirĩ nʉmʉ yʉꞌʉ wẽrĩmasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mʉꞌʉ cãpũpʉ waꞌa, mʉꞌʉ ya bʉacatjẽ meꞌrã waꞌicʉrã bʉegʉ waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Tuꞌajanʉꞌcõ, yʉꞌʉ tʉꞌsaronojõta baꞌase ʉꞌsʉase doꞌa, yʉꞌʉre ecaya. Mʉꞌʉ tojo weecã, yʉꞌʉ wẽrĩati dʉporo mʉꞌʉrẽ añurõ waꞌato nígʉ̃, Õꞌacʉ̃rẽ sẽrĩbosagʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeca peꞌe Isaa Esaúre tojo nisere tʉꞌoco niwõ. Tojo tʉꞌoꞌco niyugo, Esaú cãpũpʉ cʉ̃ pacʉre waꞌicʉrã wẽjẽbosagʉ waꞌáca beꞌro, ");
INSERT INTO tuoNT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","co macʉ̃ Jacore aꞌtiro nico niwõ: —Mʉꞌʉ pacʉ, mʉꞌʉ maꞌmi Esaúre aꞌtiro nicã tʉꞌoapʉ. Aꞌtiro niami: ");
INSERT INTO tuoNT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Macʉ̃, cãpũpʉ waꞌaya. Waꞌa, waꞌicʉ wẽjẽ, baꞌase ʉꞌsʉase doꞌa, yʉꞌʉre ecaya. Mʉꞌʉ tojo weecã, mʉꞌʉrẽ Õꞌacʉ̃ ĩꞌorõpʉ ‘Añurõ weeya’, ni sẽrĩbosagʉti”, niami. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Macʉ̃, yʉꞌʉ niatjere añurõ tʉꞌo, tere weeapa. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mʉꞌʉ niꞌcãrõacã ecarã na nirõpʉ waꞌa, pʉarã cabracãrẽ miitia. Mʉꞌʉ pacʉ cʉ̃ baꞌatʉꞌsasenojõta añuse baꞌase doꞌabosagoti. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mʉꞌʉ cʉ̃rẽ ecagʉ waꞌagʉsaꞌa. Mʉꞌʉ tojo weecã, mʉꞌʉrẽ cʉ̃ wẽrĩati dʉporo Õꞌacʉ̃rẽ “Añurõ weeya”, ni sẽrĩbosagʉsami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob peꞌe cʉ̃ pacore yʉꞌticʉ niwĩ: —Yʉꞌʉ maꞌmi nipeꞌtiro cʉ̃ upʉpʉ poaritigʉ nimi. Yʉꞌʉ peꞌe mooꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Yʉꞌʉ pacʉ yʉꞌʉre daꞌrañaꞌa, “Cʉ̃ mejẽta nimi”, ni masĩgʉ̃, “Mʉꞌʉ yʉꞌʉre bujicãꞌgʉ̃ weeꞌe”, nibosami. Yʉꞌʉre “Añurõ waꞌato” ni sẽrĩbosaronojõ oꞌogʉ, “Ñaꞌarõ peꞌe waꞌabataꞌto mʉꞌʉrẽ”, nibosami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Cʉ̃ paco cʉ̃rẽ yʉꞌtico niwõ: —Mʉꞌʉrẽ ĩꞌamasĩcãma, mʉꞌʉrẽ “Ñaꞌarõ waꞌato” nise yʉꞌʉ peꞌere tojato. Mʉꞌʉ peꞌe yʉꞌʉ dutiro weeya. Sõjã cabracãrẽ miigʉ̃ waꞌaya, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tojo nicã tʉꞌo, Jacob cabracãrẽ miigʉ̃ waꞌa, pacore oꞌocʉ niwĩ. Tojo weego Isaa tʉꞌsasenojõrẽta baꞌase doꞌabosaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Beꞌro masã maꞌmi Esaú ye suꞌti añuyʉꞌrʉnʉꞌcãse co wiꞌipʉ nʉrõꞌquere mii, cʉ̃ acabiji Jacore sãaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Beꞌro na cabra caseri meꞌrã cʉ̃ omocãrĩrẽ omaco niwõ. Tojo nicã wãmʉtare moꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tuꞌajanʉꞌcõ, te baꞌase ʉꞌsʉase doꞌaꞌquere, pã́rẽ co macʉ̃ Jacore oꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tojo weegʉ Jacob cʉ̃ pacʉ tiropʉ sãjãa, aꞌtiro nicʉ niwĩ: —¡Pacʉ! —Ãa, aꞌto niꞌi. ¿Niꞌinojõ peꞌe niti mʉꞌʉ? ni sẽrĩtiñaꞌcʉ niwĩ Isaa. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","—Yʉꞌʉ masã maꞌmi Esaú niꞌi. Mʉꞌʉ yʉꞌʉre dutiꞌcaronojõta weeapʉ. Wãꞌcãnujãña. Yʉꞌʉ waꞌicʉ wẽjẽ doꞌaꞌquere baꞌaya. Baꞌatoja, yʉꞌʉre Õꞌacʉ̃rẽ “Añurõ weeya”, ni sẽrĩbosaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaa cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —Macʉ̃ ¿deꞌronojõ maata waro waꞌicʉre bocamiati? —Mʉꞌʉ wiogʉ Õꞌacʉ̃ yʉꞌʉre maata bocacã weeami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaa cʉ̃rẽ nicʉ niwĩ: —Aꞌtocure aꞌtia. ¿Diacjʉ̃ta yʉꞌʉ macʉ̃ Esaú niti mʉꞌʉ? nígʉ̃, mʉꞌʉrẽ daꞌrañaꞌgʉ̃tigʉ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tojo weegʉ Jacob cʉ̃ tiroacãpʉ waꞌacʉ niwĩ. Cʉ̃rẽ daꞌrañaꞌgʉ̃, cʉ̃ pacʉ nicʉ niwĩ: —Mejõ mʉꞌʉ ucũse peꞌe Jacob ucũse weronojõ nírõcoro. Tojo nimirõ, omocãrĩ peꞌe Esaú ye omocãrĩ nírõcoro. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Esaú weronojõ omocãrĩ poaritiyucã, Isaa “Apĩ nimi”, ni masĩticʉ niwĩ. Cʉ̃ Õꞌacʉ̃rẽ sẽrĩbosati dʉporoacã, ");
INSERT INTO tuoNT_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","apaturi sẽrĩtiñaꞌapocʉ niwĩ tja. —¿Diacjʉ̃ta Esaú niti mʉꞌʉ? —Esaúta niꞌi, ni yʉꞌticʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tere tʉꞌogʉ, Isaa nicʉ niwĩ: —Macʉ̃, baꞌase mʉꞌʉ bocaꞌquere oꞌoya majã. Baꞌagʉtigʉ weeꞌe. Õꞌacʉ̃rẽ “Yʉꞌʉ macʉ̃rẽ añurõ waꞌato”, ni sẽrĩbosacũugʉ̃ti. Jacob cʉ̃ pacʉre baꞌase eca, cʉ̃rẽ ʉꞌsedʉcaco vinorẽ tĩacʉ niwĩ. Cʉ̃ tere baꞌa, sĩꞌrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Beꞌro cʉ̃ pacʉ Isaa cʉ̃rẽ nicʉ niwĩ: —Macʉ̃, yʉꞌʉ tiroacãpʉ aꞌti, yʉꞌʉre miꞌmiña. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tojo weegʉ Jacob cʉ̃ pʉꞌtoacãpʉ waꞌa, cʉ̃rẽ miꞌmicʉ niwĩ. Isaa cʉ̃ ye suꞌtire wĩjĩgʉ̃, cʉ̃ ye niatjere Õꞌacʉ̃rẽ aꞌtiro ni sẽrĩbosacʉ niwĩ: “Ãꞌrĩ yʉꞌʉ macʉ̃ cãpũ cjase oꞌori Õꞌacʉ̃ weeꞌque weronojõ añurõ ʉꞌmʉtimeꞌrĩcãꞌmi. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Õꞌacʉ̃ mʉꞌʉrẽ ʉꞌmʉarõ cjase aco pejasere oꞌoato. Mʉꞌʉ otesere diꞌtapʉre añurõ pĩꞌrĩ, dʉcaticã weeato. Peje trigo, tojo nicã ʉꞌsedʉcaco vinorẽ oꞌoato. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pãjãrã masã mʉꞌʉ dutise doca niato. Peje diꞌtacjãrã mʉꞌʉ dʉporo ejaqueꞌa, mʉꞌʉrẽ ẽjõpeoato. Mʉꞌʉ niꞌcʉ̃ põꞌrãpʉreta dutigʉsaꞌa. Mʉꞌʉ paco põꞌrã ʉmʉa mʉꞌʉrẽ ẽjõpeorã paamuꞌrĩqueꞌato. Mʉꞌʉrẽ ‘Ñaꞌarõ waꞌato’ nirã́ nemorõ ‘Ñaꞌabutiaro waꞌato’, ninoꞌrãsama. Mʉꞌʉrẽ ‘Añurõ waꞌato’ nirã́ peꞌe ‘Añurõta waꞌato’ ninoꞌrãsama”, nicʉ niwĩ Isaa. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Cʉ̃ Jacore Õꞌacʉ̃rẽ sẽrĩbosatuꞌajáca beꞌroacã, cʉ̃ wijaari cura Esaú waꞌicʉrã wẽjẽgʉ̃ ejaꞌcʉ dajacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Daja, cʉ̃ quẽꞌrã baꞌase añurõ ʉꞌsʉase doꞌa, cʉ̃ pacʉre baꞌadutigʉ miacʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Pacʉ, wãꞌcãnujãña. Yʉꞌʉ waꞌicʉ wẽjẽꞌcʉre baꞌaya. Baꞌa, yʉꞌʉre ye niatjere Õꞌacʉ̃rẽ sẽrĩbosaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tere tʉꞌogʉ, Isaa sẽrĩtiñaꞌcʉ niwĩ: —¿Noanojõ niti mʉꞌʉ? —Yʉꞌʉ Esaú niꞌi. Masã maꞌmi niꞌi, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tere tʉꞌogʉ, cʉ̃ pacʉ ʉpʉtʉ narãsãgʉ̃, aꞌtiro nicʉ niwĩ: —¿To pũrĩcãrẽ noa peꞌe niapari, yʉꞌʉre waꞌicʉ wẽjẽ, doꞌa, mejẽpʉ miitiꞌcʉ? Mʉꞌʉ dajati dʉporoacã yʉꞌʉ baꞌatojapʉ. Baꞌa, cʉ̃rẽ Õꞌacʉ̃rẽ sẽrĩbosatojapʉ. Tojo weegʉ cʉ̃ Õꞌacʉ̃rẽ sẽrĩbosanoꞌcʉpʉ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tere tʉꞌogʉ, Esaú ʉpʉtʉ bʉjaweti ua, uticʉ niwĩ. Aꞌtiro caricũcʉ niwĩ: —Pacʉ, yʉꞌʉ quẽꞌrãrẽ Õꞌacʉ̃rẽ sẽrĩbosacureya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Cʉ̃ pacʉ cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ acabiji mʉꞌʉ dʉporo eja, yʉꞌʉre nisooapĩ. Cʉ̃ mʉꞌʉ ye nimiꞌquere Õꞌacʉ̃rẽ yʉꞌʉ sẽrĩbosaboꞌquere miatojami. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tere tʉꞌogʉ, Esaú cʉ̃ pacʉre nicʉ niwĩ tja: —Tʉꞌomasĩrãta cʉ̃rẽ Jacob wãme õꞌocãrã niwʉ̃. Cʉ̃ yʉꞌʉre pʉatipʉ ñaꞌarõ weetojami. Ne waro, yʉꞌʉ masã maꞌmi nisere yʉꞌʉre ẽꞌmawĩ. Niꞌcãrõacãrẽ tja mejãrõta Õꞌacʉ̃rẽ mʉꞌʉ sẽrĩbosase, ye níboꞌquere ẽꞌmapĩ. ¿Yʉꞌʉre ne cãꞌrõ apeyenojõ dʉꞌsatibutiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaa cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ Jacore mʉꞌʉ wiogʉ waꞌacã weeasʉ. Nipeꞌtirã cʉ̃ acawererã cʉ̃rẽ daꞌracoꞌteri masã nirãsama. Peje baꞌase trigo, ʉꞌsedʉcaco vino cʉogʉsaꞌa, niasʉ. Macʉ̃, yʉꞌʉ niꞌcãrõacãma deꞌro weemasĩtisaꞌa majã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaú cʉ̃ pacʉre ninemocʉ niwĩ: —Pacʉ, ¿niꞌcãtita Õꞌacʉ̃rẽ añusere sẽrĩta basioti? Yʉꞌʉ quẽꞌrãrẽ cʉ̃rẽ añusere sẽrĩbosaya, nicʉ niwĩ. Beꞌro apaturi caricũ, uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Cʉ̃ tojo nicã tʉꞌogʉ, Isaa cʉ̃rẽ nicʉ niwĩ: “Mʉꞌʉ diꞌta añuse nitiropʉ nisetigʉsaꞌa. Ʉꞌmʉarõ cjase aco pejase marĩrõpʉ nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mʉꞌʉ, mʉꞌʉ ya diꞌpjĩ meꞌrã wãmoti, mejẽcã waꞌacã cãꞌmotaꞌagʉsaꞌa. Mʉꞌʉ acabijire daꞌracoꞌtegʉ nigʉ̃saꞌa. Beꞌro mʉꞌʉ tutuagʉ waꞌagʉ, cʉ̃ dutise doca nisome majã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tojo waꞌáca beꞌro te meꞌrã Esaú cʉ̃ acabijire ĩꞌasĩꞌrĩti, uanʉꞌcãcʉ niwĩ. Cʉ̃ pacʉ Jacob peꞌere Õꞌacʉ̃rẽ sẽrĩbosaꞌque buꞌiri tojo weecʉ niwĩ. “Yʉꞌʉ pacʉ cʉ̃ wẽrĩatjo cãꞌrõ dʉꞌsaꞌa. Cʉ̃ wẽ́rĩ́ca beꞌro yʉꞌʉ acabijire wẽjẽgʉ̃ti”, ni wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esaú tojo weegʉti nise quetire tʉꞌogo, Rebeca Jacore pijio, aꞌtiro nico niwõ: —Mʉꞌʉ maꞌmi Esaú mʉꞌʉrẽ aꞌmegʉ̃, “Wẽjẽgʉ̃ti”, niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tojo weegʉ, macʉ̃, yʉꞌʉ dutiro weeya. Harã́pʉ yʉꞌʉ maꞌmi Labán ya wiꞌipʉ duꞌtiabaqueꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Topʉ tojáníña. Téé mʉꞌʉ maꞌmi cʉ̃ uase peꞌtíca beꞌropʉ topʉre nitʉoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mʉꞌʉ cʉ̃rẽ weeꞌquere acobojóca beꞌro mʉꞌʉrẽ “Aꞌtia tja” ni, queti oꞌógoti. Mʉsãrẽ yʉꞌʉ põꞌrã pʉarãrẽ niꞌcã nʉmʉta wẽrĩcã ʉaweꞌe, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Beꞌro Rebeca co marãpʉ Isaare nico niwõ: —Ãꞌrã hitita masã numia Esaú nʉmosãnumia meꞌrã yʉꞌʉ caributiyʉꞌrʉa waꞌasaꞌa. Jacob cʉ̃ aꞌti diꞌta Canaácjãrã ãꞌrã hitita masã numia weronojõ nigõrẽ cʉ̃ nʉmoticãma, mejõ wẽrĩa waꞌasĩꞌrĩsaꞌa, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tere tʉꞌogʉ, Isaa Jacore pijio, cʉ̃rẽ “Õꞌacʉ̃ mʉꞌʉrẽ añurõ weeato”, nicʉ niwĩ. Tojo nicã, cʉ̃rẽ aꞌtiro weeduticʉ niwĩ: —Mʉꞌʉ aꞌti diꞌta Canaácjãrã numiarẽ ne nʉmotiticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mʉꞌʉ ñecʉ̃ tiro Betuel Padan-arãpʉ waꞌaya. Topʉ mʉꞌʉ pacopánʉmʉ Labán macõrẽ nʉmotiya. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ mʉꞌʉrẽ añurõ weeato. Pãjãrã mʉꞌʉrẽ masãputi, pãrãmerãticã weeato. Cʉ̃ tojo weecã, peje curaricjãrã nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Abrahãrẽ Õꞌacʉ̃ “Añurõ weegʉti” níꞌquere mʉꞌʉrẽ, mʉꞌʉ pãrãmerãrẽ oꞌoato. Aꞌti diꞌta mʉsã ya diꞌta waro tojato nígʉ̃, tojo niꞌi. Niꞌcãrõacãrẽ aꞌti diꞌtapʉ ape diꞌtacjãrã weronojõ niꞌi yujupʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tojo wee Jacore Padan-arãpʉ oꞌócãꞌcʉ niwĩ. Topʉre Labán ya wiꞌipʉ etacʉ niwĩ. Cʉ̃ Betuel, arameo masʉ̃ macʉ̃, tojo nicã Rebeca maꞌmi nicʉ niwĩ. Rebeca, Jacob, Esaú paco nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú, cʉ̃ pacʉ Isaa, Õꞌacʉ̃rẽ “Jacore añurõ weeya”, ni sẽrĩbosacã, tojo nicã cʉ̃rẽ Padan-arãpʉ nʉmotidutigʉ oꞌócã tʉꞌocʉ niwĩ. Tojo nicã cʉ̃rẽ Õꞌacʉ̃rẽ añurõ weedutigʉ, “Aꞌtocjãrã Canaácjãrã numia meꞌrã ne nʉmotiticãꞌña” nicã tʉꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Apeyema Jacob cʉ̃ pacʉsʉmʉa weedutiꞌcaronojõta Padan-arãpʉ waꞌacã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tojo weegʉ Esaú cʉ̃ pacʉsʉmʉa Canaá diꞌtacjãrã numiarẽ tʉꞌsatisere masĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tere masĩgʉ̃, Abrahã macʉ̃ Ismae tiropʉ ĩꞌagʉ̃ waꞌacʉ niwĩ. Topʉ cʉ̃ macõ Mahalat wãmetigore nʉmoticʉ niwĩ. Co Nebaiot acabijo nico niwõ. Cʉ̃ Esaú ãpẽrã pʉarã numia Canaácjãrã numiarẽ nʉmotitojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob Beersebapʉ níꞌcʉ waꞌa, Harã́ waꞌari maꞌapʉ buꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Waꞌacũmí, ñamicaꞌapʉ niyucã, cʉ̃ noꞌo naꞌitõꞌorõ cãrĩcʉ niwĩ. Topʉ cãrĩgʉ̃tigʉ, niꞌcãgã ʉ̃tãgã topʉ cũñacjare miicṹú, cʉ̃ dʉpoare ẽotuucũuocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Topʉ aꞌtiro quẽꞌecʉ niwĩ. Niꞌcãrõ mʉjãrõjo nucũcãpʉ téé ʉꞌmʉsepʉ nimʉjãnʉꞌcãcaro niwʉ̃. To mʉjãrõpʉre Õꞌacʉ̃rẽ werecoꞌterã mʉjãmʉjã, dijatimʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tojo nicã, Õꞌacʉ̃rẽ cʉ̃ pʉꞌto nuꞌcũcã ĩꞌacʉ niwĩ. Cʉ̃rẽ aꞌtiro nicʉ niwĩ: “Yʉꞌʉ mʉꞌʉ ñecʉ̃ Abrahã, mʉꞌʉ pacʉ Isaa ẽjõpeogʉ Õꞌacʉ̃ niꞌi. Mʉꞌʉrẽ, mʉꞌʉ pãrãmerã nituriarãrẽ aꞌte mʉꞌʉ cũñase diꞌtare oꞌogʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mʉꞌʉ pãrãmerã pãjãrã waro nucũpori weronojõ nirãsama. Nipeꞌtiropʉ seꞌsanʉꞌcãrãsama. Mujĩpũ cʉ̃ mʉjãtiro peꞌe, cʉ̃ sãjãrõ peꞌe, tojo nicã norte, téé surpʉ nirãsama. Nipeꞌtirã aꞌti turicjãrãrẽ mʉꞌʉ meꞌrã, tojo nicã mʉꞌʉ pãrãmerã nituriarã meꞌrã añurõ waꞌacã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Yʉꞌʉ mʉꞌʉ meꞌrã niꞌi. Mʉꞌʉrẽ, mʉꞌʉ noꞌo waꞌaro coꞌtegʉti. Aꞌti diꞌtare mʉꞌʉrẽ apaturi dajanʉꞌcãcã weegʉti. Yʉꞌʉ ‘Tojo weegʉti’ níꞌquere weetimigʉ̃, ne cãꞌrõ mʉꞌʉrẽ cõꞌawãꞌcãsome”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob cʉ̃ quẽꞌéca beꞌro wãꞌcãgʉ̃, aꞌtiro wãcũcʉ niwĩ: “Diacjʉ̃ta Õꞌacʉ̃ aꞌto nimi. Yʉꞌʉ ne masĩtiasʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Cʉ̃ ʉpʉtʉ ui, aꞌtiro wãcũcʉ niwĩ: “Aꞌto wiobutiaꞌa. Õꞌacʉ̃ cʉ̃ nirṍ waro niꞌi. Cʉ̃ ya wiꞌi niꞌi. Ʉꞌmʉse sãjãrĩ sope pʉꞌto niꞌi”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ape nʉmʉ peꞌe maata wãꞌcã, ʉ̃tãgã cʉ̃ dʉpoapʉ ẽotuucũucagare añurõ miinʉꞌcõcʉ niwĩ. Tuꞌajanʉꞌcõ, tigare Õꞌacʉ̃ yaga tojadutigʉ, ʉꞌsere piopeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ne waropʉre tore niꞌcã macã nicaro nimiwʉ̃. Ti macã Luz wãmeticaro niwʉ̃. Jacob peꞌe mejẽcã wãme dʉcayucʉ niwĩ. Betel wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Topʉ Jacob Õꞌacʉ̃rẽ “Mʉꞌʉ meꞌrã aꞌtiro weegʉti”, ni ucũcʉ niwĩ: “Õꞌacʉ̃ niꞌcãrõacã yʉꞌʉ waꞌarore baꞌpati, coꞌte, yʉꞌʉre baꞌase, suꞌti oꞌogʉ, yʉꞌʉ wiogʉ nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Tojo nicã, ne cãꞌrõ mejẽcã waꞌati, apaturi yʉꞌʉre yʉꞌʉ pacʉ ya wiꞌipʉre majãmitojaacã wéégʉ, tojo nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mʉꞌʉ tojo weecã, aꞌtiga ʉ̃tãgã yʉꞌʉ miinʉꞌcõcaga Õꞌacʉ̃ ya wiꞌi nirõsaꞌa. Mʉꞌʉ nipeꞌtisetiri yʉꞌʉre apeyenojõ diez oꞌocã, mʉꞌʉrẽ niꞌcãrõ oꞌogʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob waꞌa, mujĩpũ mʉjãtirocjãrã ya diꞌtapʉ etacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Topʉre etagʉ, cãpũpʉ iꞌtia curua oveja aco sĩꞌrĩrĩ pe tiro soocũñarãrẽ ĩꞌacʉ niwĩ. Na ti pe cjase acore sĩꞌrĩcãrã niwã. Ti pe sope pʉꞌtopʉre pajiri pe ʉ̃tãpejo meꞌrã biꞌanoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nipeꞌtirã oveja topʉre nerẽnʉꞌcãca beꞌro oveja coꞌterã ti pere pãa, ovejare aco tĩacãrã niwã. Na sĩꞌrĩ́ca beꞌro oveja coꞌterã ti pere biꞌacãrã niwã tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob oveja coꞌterãrẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Ne, noꞌocjãrã niti mʉsã? —Ʉ̃sã Harã́cjãrã niꞌi, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Narẽ sẽrĩtiñaꞌnemocʉ niwĩ tja: —¿Mʉsã Labã́rẽ Nacor pãrãmirẽ masĩti? —Masĩꞌi, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","—¿Cʉ̃ dutimarĩati? ni sẽrĩtiñaꞌnemocʉ niwĩ. —Ʉ̃́ʉ, duti marĩami, ni yʉꞌticãrã niwã. Beꞌro Jacore ninemocãrã niwã: —Ĩꞌaña. Sico Raquel, Labán macõ co yarã oveja meꞌrã aꞌtimo, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob narẽ aꞌtiro nicʉ niwĩ: —Ʉmʉcjo waro niꞌi yujupʉ. Ovejare biꞌasõrõrõ mejẽta niꞌi. ¿Deꞌro weerã mʉsã ovejare aco tĩa, beꞌro tá baꞌadutirã, cãpũpʉ mianʉꞌcõweti? ");
INSERT INTO tuoNT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Na cʉ̃rẽ yʉꞌticãrã niwã: —Tojo weemasĩtisaꞌa. Nipeꞌtirã oveja nerẽpeꞌtiato yujupʉ. Na nerẽpeꞌtica beꞌro oveja coꞌterã ti pere biꞌácaga ʉ̃tãgãjore pãa, acore tĩanoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jacob na meꞌrã ucũrĩ cura Raquel co pacʉ yarã oveja meꞌrã ejaco niwõ. Co narẽ coꞌtego nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Topʉ Raquere, Labán macõrẽ, cʉ̃ pacopánʉmʉ Labán yarã oveja meꞌrã ejacã ĩꞌagʉ̃, maata ʉ̃tãgãjore pãogʉ̃ waꞌacʉ niwĩ. Pãotoja, narẽ aco tĩacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Beꞌro Raquere añudutigʉ miꞌmicʉ niwĩ. Tojo weetoja, eꞌcatigʉ, uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob, “Yʉꞌʉ Rebeca macʉ̃ niꞌi, Labán páácjʉ̃ niꞌi”, ni werecʉ niwĩ. Tere tʉꞌogo, co pacʉpʉre omawãꞌcã, werego waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labán, “Yʉꞌʉ acabijo macʉ̃ niapʉ” nisere tʉꞌogʉ, cʉ̃rẽ põtẽrĩgʉ̃ waꞌagʉ, omawãꞌcãcʉ niwĩ. Cʉ̃rẽ paabʉꞌa, waꞌsuporopʉ miꞌmicʉ niwĩ. Beꞌro cʉ̃ ya wiꞌipʉ miacʉ niwĩ. Jacob nipeꞌtise cʉ̃rẽ waꞌaꞌquere quetiwerepeꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labán cʉ̃rẽ nicʉ niwĩ: “Diacjʉ̃ta mʉꞌʉ yʉꞌʉ acawerego macʉ̃ nígʉ̃, ye dí warota niꞌi”, nicʉ niwĩ. Jacob Labán tiropʉre niꞌcã mujĩpũ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ti mujĩpũ beꞌro Labán Jacore aꞌtiro nicʉ niwĩ: —Mʉꞌʉ, yʉꞌʉ acawerego macʉ̃ nise wapa tojowaro daꞌra, weesome. ¿Mʉꞌʉ noꞌocãꞌrõ wapayecã ʉasari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labán pʉarã numia põꞌrãticʉ niwĩ. Masã maꞌmio Lea wãmetico niwõ. Dʉꞌsago peꞌe Raquel wãmetico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea caperi añuse cʉoco niwõ. Raquel peꞌe añugõ, añurõ upʉtigo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob Raquere tʉꞌsayugʉ, aꞌtiro nicʉ niwĩ: —Mʉꞌʉ macõ Raquere ʉagʉ, siete cʉ̃ꞌmarĩ mʉꞌʉrẽ daꞌratamugʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labán cʉ̃rẽ yʉꞌticʉ niwĩ: —Jaʉ, añurõsaꞌa. Aperocjãrã peꞌere oꞌoronojõ oꞌógʉ, mʉꞌʉrẽ numisogʉti. Yʉꞌʉ meꞌrã tojayá, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tojo weegʉ Jacob Raquere wapataꞌagʉ, siete cʉ̃ꞌmarĩ daꞌracʉ niwĩ. Cʉ̃ Raquere ʉayʉꞌrʉayucã, te cʉ̃ꞌmarĩ ne yoabajuticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Te siete cʉ̃ꞌmarĩ yʉꞌrʉ́ca beꞌro Jacob Labã́rẽ nicʉ niwĩ: —Yʉꞌʉ nʉmo niacjore wiaya majã. Yʉꞌʉ core nʉmotigʉsaꞌa. Ticʉse cʉ̃ꞌmarĩ daꞌragʉti níꞌque peꞌtia waꞌaꞌa. Core daꞌra, wapataꞌatojaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tojo weegʉ Labán nipeꞌtirã cʉ̃ pʉꞌtocjãrãrẽ omocã dʉꞌteri bosenʉmʉrẽ pijiocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Beꞌro ñamipʉ Labán masã maꞌmio Lea peꞌere mia, Jacore oꞌocʉ niwĩ. Jacob co meꞌrã cãrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Apeyema tja Leare Labán niꞌcõ cʉ̃rẽ daꞌracoꞌtegore weetamudutigʉ oꞌocʉ niwĩ. Co Zilpa wãmetico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ape nʉmʉ boꞌreacã Jacob “Apego Lea meꞌrã peꞌe cãrĩapã”, ni ĩꞌacʉ niwĩ. Tojo weegʉ Labã́rẽ sẽrĩtiñaꞌgʉ̃ waꞌacʉ niwĩ. —¿Deꞌro weegʉ yʉꞌʉre tojo weeati? Yʉꞌʉ Raquere wapataꞌagʉtigʉ mʉꞌʉ meꞌrã daꞌrawʉ. ¿Deꞌro weegʉ yʉꞌʉre tojo weesooati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labán cʉ̃rẽ yʉꞌticʉ niwĩ: —Aꞌti diꞌtapʉ aꞌtiro weesetisaꞌa. Dʉꞌsago peꞌe masã maꞌmio dʉporo marãpʉtitimo. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mʉꞌʉ omocã dʉꞌteri bosenʉmʉ nirĩ semanarẽ Lea meꞌrãta níniꞌña yujupʉ. Ti semana peꞌtíca beꞌro co acabijore oꞌogʉti. Mʉꞌʉ core daꞌra wapayegʉ, siete cʉ̃ꞌmarĩ daꞌranemogʉ̃saꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob “Añurõsaꞌa”, nicʉ niwĩ. Lea omocã dʉꞌteri bosenʉmʉ nirĩ semana peꞌtíca beꞌro Raquel quẽꞌrãrẽ numisocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán cʉ̃rẽ daꞌracoꞌtegore Raquere weetamudutigʉ, co quẽꞌrãrẽ Bilha wãmetigore oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob Raquel meꞌrã quẽꞌrãrẽ cãrĩcʉ niwĩ. Lea nemorõ co peꞌere maꞌiyʉꞌrʉnʉꞌcãcʉ niwĩ. Siete cʉ̃ꞌmarĩ Labán meꞌrã daꞌranemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Õꞌacʉ̃ Jacob Leare maꞌiticã ĩꞌagʉ̃, core wĩꞌmarã põꞌrãticã weecʉ niwĩ. Raquel peꞌema wĩꞌmarã bocamasĩticã weecʉ niwĩ yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nijĩpaco waꞌa, wĩꞌmagʉ̃ põꞌrãtico niwõ. Cʉ̃rẽ Rubén wãme õꞌoco niwõ. Aꞌtiro nico niwõ: “Õꞌacʉ̃ yʉꞌʉ bʉjaweticã ĩꞌagʉ̃, wĩꞌmagʉ̃ oꞌoami. Tojo weegʉ niꞌcãrõacãma yʉꞌʉ marãpʉ yʉꞌʉre maꞌigʉ̃sami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Beꞌro Lea apĩ põꞌrãtico niwõ tja. Cʉ̃rẽ Simeó wãme õꞌoco niwõ. Tojo weego aꞌtiro nico niwõ: “Õꞌacʉ̃ yʉꞌʉ marãpʉ yʉꞌʉre tojo ĩꞌacõꞌacã ĩꞌami. Tojo weegʉ apĩ yʉꞌʉre oꞌonemoami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Apĩ cʉonemoco niwõ tja. Cʉ̃rẽ Leví wãme õꞌoco niwõ. “Yʉꞌʉ marãpʉre iꞌtiarã wĩꞌmarã oꞌotojaꞌa. Tojo weegʉ niꞌcãrõacãma yʉꞌʉ peꞌere nemorõ maꞌigʉ̃sami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea apĩ wʉanemoco niwõ tja. “Niꞌcãrõacãma Õꞌacʉ̃rẽ eꞌcatipeogoti”, nico niwõ. Tojo weego cʉ̃rẽ Judá wãme õꞌoco niwõ. Ãꞌrĩ beꞌro põꞌrãtiduꞌuníco niwõ yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquel yʉꞌʉ Jacore põꞌrãtibosatisaꞌa nígõ, co maꞌmiorẽ ʉoco niwõ. Tojo tʉꞌoñaꞌgõ, co marãpʉre nico niwõ: —Yʉꞌʉre põꞌrãticã weeya. Mʉꞌʉ tojo weeticãma, wẽrĩa waꞌagoti, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tere tʉꞌogʉ, Jacob ua waꞌa, core nicʉ niwĩ: —¿To pũrĩcãrẽ yʉꞌʉ Õꞌacʉ̃ niti? Cʉ̃ta mʉꞌʉrẽ wĩꞌmarã bocaticã weemi. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Beꞌro cʉ̃rẽ nico niwõ: —Aꞌtigo yʉꞌʉre daꞌracoꞌtego Bilhare miaña. Co meꞌrã ni, wĩꞌmagʉ̃rẽ põꞌrãtiya. Co tojo põꞌrãticã, yʉꞌʉ quẽꞌrã põꞌrãtiꞌco weronojõ cʉogosaꞌa, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tojo weego Raquel core daꞌracoꞌtego Bilhare cʉ̃ nʉmo weronojõ niato nígõ, co marãpʉre oꞌoco niwõ. Jacob co meꞌrã cãrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Co nijĩpaco toja, niꞌcʉ̃ wĩꞌmagʉ̃ Jacore wʉabosaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Co tojo weecã ĩꞌagõ, Raquel nico niwõ: “Ãpẽrã ĩꞌorõpʉ Õꞌacʉ̃ yʉꞌʉre queoro waꞌacã weeami. Cʉ̃ yʉꞌʉ sẽrĩsere tʉꞌogʉ, yʉꞌʉre wĩꞌmagʉ̃ oꞌoami. Tojo weegʉ ãꞌrĩ wĩꞌmagʉ̃ Dan wãmetigʉsami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Beꞌro apĩ Bilha põꞌrãtinemoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel aꞌtiro nico niwõ: “Yʉꞌʉ maꞌmio meꞌrã ʉpʉtʉ waro aꞌmetuꞌtiapʉ. Añuꞌu majã, yʉꞌʉ core yʉꞌrʉwetitojapʉ”, nico niwõ. Tojo weego wĩꞌmagʉ̃rẽ Neftalí wãme õꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea peꞌe “Yʉꞌʉ põꞌrã bocamasĩtisaꞌa majã” nígõ, core daꞌracoꞌtego Zilpare co marãpʉ Jacore peꞌsudaꞌreco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Co Zilpa Jacob meꞌrã wĩꞌmagʉ̃ põꞌrãtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Co tojo weecã ĩꞌagõ, Lea aꞌtiro nico niwõ: “Añubutiaro waꞌaꞌa. Tojo weegʉ wĩꞌmagʉ̃ Gad wãmetigʉsami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Beꞌro Zilpa Jacore apĩ põꞌrãtibosaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tere ĩꞌagõ, Lea aꞌtiro nico niwõ: “Eꞌcatiyʉꞌrʉasaꞌa. Numia niꞌcãrõacãma yʉꞌʉre ‘Eꞌcatiyʉꞌrʉamo’, nirãsama.” Tojo weego wĩꞌmagʉ̃ Aser wãme õꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Niꞌcã nʉmʉ na trigo tʉ̃ꞌrẽrĩtero nicã, Rubén cãpũpʉ waꞌacʉ niwĩ. Topʉ yucʉdʉca mandrágora wãmetisere bocacʉ niwĩ. Boca, cʉ̃ paco Leare miacʉ niwĩ. Tere miidajacã ĩꞌagõ, Raquel Leare nico niwõ: —Yʉꞌʉ quẽꞌrãrẽ mʉꞌʉ macʉ̃ miitiꞌque yucʉdʉcare oꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea peꞌe core yʉꞌtico niwõ: —¿Deꞌro weego oꞌobosari? Mʉꞌʉ yʉꞌʉre ñaꞌabutiaro weewʉ. Yʉꞌʉ marãpʉre ẽꞌmawʉ̃. ¿Niꞌcãrõacãrẽ yʉꞌʉ macʉ̃ yucʉdʉca bocaꞌquere ẽꞌmasĩꞌrĩti tja? Tere tʉꞌogo, Raquel nico niwõ: —To pũrĩcãrẽ aꞌtiro weegoti. Mʉꞌʉ macʉ̃ yucʉdʉca bocaꞌquere mʉꞌʉ oꞌocã, niꞌcãcã ñamirẽ Jacob mʉꞌʉ meꞌrã cãrĩgʉ̃sami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Beꞌro naꞌiqueꞌari cura Jacob cʉ̃ cãpũpʉ níꞌcʉ dajari cura Lea cʉ̃rẽ põtẽrĩgõ waꞌa, aꞌtiro nico niwõ: —Niꞌcãcã ñamirẽ, mʉꞌʉ yʉꞌʉ meꞌrã cãrĩgʉ̃saꞌa. Yʉꞌʉ macʉ̃ bocaꞌque mandrágora yucʉdʉca meꞌrã wapayeapʉ. Tojo weegʉ ti ñamirẽ Jacob Lea meꞌrã cãrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Õꞌacʉ̃ Lea sẽrĩsere yʉꞌticʉ niwĩ. Tojo weego nijĩpaco waꞌa, cʉ̃ meꞌrã niꞌcãmocʉrã põꞌrãtibosanemoco niwõ Jacore. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tere ĩꞌagõ, Lea nico niwõ: “Yʉꞌʉre daꞌracoꞌtegore yʉꞌʉ marãpʉre oꞌowʉ. Tojo weeꞌque wapa Õꞌacʉ̃ niꞌcãrõacãrẽ yʉꞌʉre añurõ weemi majã. Tojo weegʉ ãꞌrĩ wĩꞌmagʉ̃ Isacar wãmetigʉsami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Beꞌro Lea apĩ põꞌrãtinemoco niwõ. Cʉ̃ meꞌrã seis põꞌrãtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Aꞌtiro nico niwõ: “Õꞌacʉ̃ yʉꞌʉre añubutiase oꞌoami. Niꞌcãrõacãrẽ yʉꞌʉ marãpʉ nemorõ maꞌigʉ̃sami. Cʉ̃rẽ yʉꞌʉ seis ʉmʉa põꞌrãtibosatojaꞌa. Tojo weegʉ ãꞌrĩ wĩꞌmagʉ̃ Zabulṍ wãmetigʉsami”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Lea põꞌrãtitʉogo, numiorẽ wʉaco niwõ. Core Dina wãmeyeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Beꞌro Õꞌacʉ̃ Raquel quẽꞌrãrẽ wãcũcʉ niwĩ. Co sẽrĩsere tʉꞌogʉ, core põꞌrãticã weecʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tojo weego co põꞌrãtimʉꞌtãgʉ̃rẽ wʉago, aꞌtiro nico niwõ: “Yʉꞌʉ põꞌrãmarĩgõ nígõ bopoyaꞌquere Õꞌacʉ̃ peꞌticã weeami. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Cʉ̃ yʉꞌʉre apĩ oꞌonemocã añuyʉꞌrʉabosaꞌa”, nico niwõ. Tojo weego cʉ̃rẽ José wãmeyeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel Joseré wʉáca beꞌro Jacob mañecʉ̃ Labã́rẽ nicʉ niwĩ: —Yʉꞌʉre ya diꞌtapʉ dajatojaadutiya. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yʉꞌʉ nʉmosãnumiarẽ mʉꞌʉrẽ daꞌrawapataꞌaꞌcãrã numiarẽ, tojo nicã yʉꞌʉ põꞌrãrẽ oꞌoya. Mʉꞌʉ yʉꞌʉre yʉꞌtíca beꞌro waꞌagʉti. Yʉꞌʉ mʉꞌʉ meꞌrã ʉpʉtʉ daꞌrasere añurõ masĩsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labán cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ nisetisere tʉꞌsagʉ, yʉꞌʉ meꞌrã tojayá. Yʉꞌʉ tʉꞌoñaꞌse meꞌrã aꞌtiro masĩꞌi. Õꞌacʉ̃ mʉꞌʉ meꞌrã yʉꞌʉre añurõ waꞌacã weeami. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","¿Noꞌocãꞌrõ wapataꞌasĩꞌrĩsari mʉꞌʉ? Mʉꞌʉ werecã, yʉꞌʉ tocãꞌrõ wapayegʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ masĩsaꞌa. Yʉꞌʉ mʉꞌʉrẽ añurõ daꞌratamuwʉ̃. Mʉꞌʉ yarã waꞌicʉrãrẽ añurõ coꞌtebosawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yʉꞌʉ etati dʉporore mʉꞌʉ pejetirãcã cʉocʉ niwʉ̃. Niꞌcãrõacãma pãjãrã waro nima. Yʉꞌʉ etanʉꞌcãꞌcaro meꞌrã Õꞌacʉ̃ mʉꞌʉrẽ añurõ weemi. Niꞌcãrõacã yʉꞌʉ nʉmosãnumia, yʉꞌʉ põꞌrã ye peꞌere daꞌrabosasĩꞌrĩsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","—¿Noꞌocãꞌrõ yʉꞌʉ wapayecã ʉati? ni sẽrĩtiñaꞌnemocʉ niwĩ Labã́. Jacob aꞌtiro yʉꞌticʉ niwĩ: —Ne wapayeticãꞌña. Yʉꞌʉ mʉꞌʉrẽ “Aꞌtiro weeya” nisere “Jaʉ” nicã, mʉꞌʉ yarã ovejare coꞌtebosagʉti tja, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Aꞌtiro weegʉti. Niꞌcãcã nipeꞌtirã mʉꞌʉ yarã ovejare ĩꞌacusiagʉ waꞌagʉti. Ĩꞌacusia, oveja sereritirã, doꞌrorã́rẽ, tojo nicã wĩꞌmarã ñirãcãrẽ dʉcawaagʉti. Nipeꞌtirã cabra sereritirã, doꞌrorã́rẽ dʉcawaacũugʉ̃ti. Narẽta mʉꞌʉ yʉꞌʉre wapayegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tojo wééca beꞌro mʉꞌʉ yʉꞌʉ wapataꞌasere ĩꞌagʉ̃ aꞌtigʉ, “Queorota weeapĩ, ne yajatiapĩ”, nigʉ̃saꞌa. Yarã oveja, cabra tiropʉ doꞌrorã marĩcã, tojo nicã oveja ñirã marĩcãma, “Ãꞌrĩ yajagʉ weeapĩ”, nigʉ̃saꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labán cʉ̃rẽ yʉꞌticʉ niwĩ: —Añurõsaꞌa. Mʉꞌʉ tojo nise tojota waꞌato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ti nʉmʉta Labán peꞌe cabra ʉmʉa yʉꞌtʉrãrẽ, doꞌrorã́rẽ, tojo nicã cabra numia sereritirãrẽ, doꞌrorã́rẽ, cãꞌrõ butise cʉorãrẽ, nipeꞌtirã oveja wĩꞌmarã ñirãrẽ cʉ̃ põꞌrãrẽ coꞌtedutigʉ oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Beꞌro topʉ níꞌcʉ narẽ Jacob nirõpʉ meꞌrã téé iꞌtia nʉmʉ waꞌaropʉ narẽ miacʉ niwĩ. Jacob peꞌe Labán yarã oveja, cabra dʉꞌsaꞌcãrãrẽ coꞌtecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Narẽ coꞌteri cura aꞌtiro weecʉ niwĩ. Cʉ̃ álamo, almendro, castaño wãmetise yaꞌsase dʉpʉrire dʉtecʉ niwĩ. Dʉte, te dʉpʉrire butise dari pãꞌrẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Beꞌro te pãꞌrẽꞌque dʉpʉrire ecarã na aco sĩꞌrĩrĩ coꞌro tiro diacjʉ̃ peocʉ niwĩ. Topʉta na amorĩ cura na sĩꞌrĩrã aꞌtirã, te dʉpʉri tiro ʉmʉa, numiarẽ ñeꞌecãrã niwã. Tojo weerã wĩꞌmarã bajuarã, yʉꞌtʉrã, doꞌrorã bajuacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Wĩꞌmarãrẽ mejẽcã cũucʉ niwĩ. Ãpẽrã peꞌere Labán yarã doꞌrorã, yʉꞌtʉrã, ñirã põtẽorõ cũucʉ niwĩ. Aꞌtiro wee cʉ̃ yarã pãjãrã waꞌacã weecʉ niwĩ. Narẽ Labán yarã meꞌrã morẽticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Apeyema tja Jacob aꞌtiro weecʉ niwĩ. Oveja numia tutuarã amorã, Jacob sõꞌoníꞌque dʉpʉrire na sĩꞌrĩrĩ coꞌro tiropʉ cũucʉ niwĩ. Te dʉpʉri põtẽorõpʉ aꞌmerĩ ñeꞌeato nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tutuatirã mejãrã aꞌticã peꞌema, te dʉpʉrire cũuticʉ niwĩ. Tojo weerã na mejãrã Labán yarã tojacãrã niwã. Tutuarã peꞌe Jacob yarã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Aꞌtiro wee siapeꞌe meꞌrã Jacob pãjãrã waro ecarã cʉocʉ niwĩ. Pãjãrã waro oveja, cabra, cameyoa, burroa cʉocʉ niwĩ. Cʉ̃rẽ daꞌracoꞌterã numia, ʉmʉa quẽꞌrãrẽ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob Labán põꞌrã cʉ̃rẽ ucjase quetire tʉꞌocʉ niwĩ. “Jacob marĩ pacʉ ye níꞌquere ẽꞌmapeꞌo, te meꞌrã cʉ̃ peꞌe peje cʉogʉ tojami,” nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Apeye quẽꞌrã Jacob Labán todʉporopʉ cʉ̃rẽ añurõ weeꞌcaronojõ weeticã tʉꞌoñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tere ĩꞌagʉ̃, Õꞌacʉ̃ Jacore nicʉ niwĩ: “Mʉꞌʉ pacʉsʉmʉa ya diꞌtapʉ tojaaya. Mʉꞌʉ acawererã tiropʉ waꞌaya. Yʉꞌʉ mʉꞌʉrẽ coꞌtegʉti,” nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Cʉ̃ tojo nicã tʉꞌogʉ, Jacob cʉ̃ nʉmosãnumia Raquere, Leare cʉ̃ nirṍ cãpũpʉ cʉ̃ oveja, cabra coꞌteropʉ pijidutioꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Narẽ nicʉ niwĩ: —Yʉꞌʉ ĩꞌacãta, mʉsã pacʉ yʉꞌʉre todʉporopʉ cʉ̃ weeꞌcaronojõ weetimi. Tojo weemicã, Õꞌacʉ̃, yʉꞌʉ pacʉ ẽjõpeogʉ peꞌe yʉꞌʉre añurõ coꞌtemi. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mʉsã masĩsaꞌa, yʉꞌʉ mʉsã pacʉre nipeꞌtiro yʉꞌʉ tutuaro põtẽorõ añurõ warota daꞌrabosawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Yʉꞌʉ tojo weemicã, cʉ̃ yʉꞌʉre nisoomʉjãwĩ. Naꞌirõ yʉꞌʉ daꞌrase wapare queoro wapayetimʉjãwĩ. Tojo weemicã, Õꞌacʉ̃ peꞌe yʉꞌʉre ñaꞌarõ weedutitigʉ, cʉ̃rẽ cãꞌmotaꞌami. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tojo weegʉ Labán cʉ̃ “Oveja, cabra doꞌrorã mʉꞌʉ yarã nirãsama” nicã, oveja, cabra numia doꞌrorãta põꞌrãtiwã. Tojo nicã, cʉ̃ “Oveja, cabra yʉꞌtʉrã mʉꞌʉ yarã nirãsama” nicã, tojo bajurãta põꞌrãtiwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tojo weegʉ Õꞌacʉ̃ cʉ̃ yarã ecarã peꞌere ẽꞌma, yʉꞌʉre oꞌowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","»Niꞌcã nʉmʉ na waꞌicʉrã amorĩ cura aꞌtiro quẽꞌecãti. Cabra ʉmʉa numiarẽ ñeꞌemʉjãwã. Na ʉmʉa yʉꞌtʉrã, doꞌrorã, sereritirã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Quẽꞌerõpʉ Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã yʉꞌʉ wãmerẽ pisuwĩ. Yʉꞌʉ peꞌe cʉ̃rẽ yʉꞌtiwʉ: “Aꞌtota niꞌi”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tojo nicã tʉꞌogʉ, cʉ̃rẽ werecoꞌtegʉ weronojõ nigʉ̃́ yʉꞌʉre niwĩ: “Añurõ ĩꞌaña. Nipeꞌtirã ecarã ʉmʉa numiarẽ ñeꞌerã, yʉꞌtʉrã, doꞌrorã, sereritirã nima. Yʉꞌʉ Labán mʉꞌʉrẽ weeꞌquere ĩꞌapeꞌocãꞌpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yʉꞌʉ Õꞌacʉ̃, mʉꞌʉrẽ Betepʉ bajuaꞌcʉ niꞌi. Topʉ mʉꞌʉ ʉ̃tãgãrẽ miinʉꞌcõ, ʉꞌse waꞌre, yʉꞌʉre ‘Tojo weegʉti’, ni ucũwʉ̃. Niꞌcãrõacã aꞌtore wijayá. Mʉꞌʉ bajuáca diꞌtapʉ dajaya”, niwĩ, ni werecʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tojo nicã tʉꞌorã, Raquel, Lea cʉ̃rẽ yʉꞌticãrã niwã: —Ʉ̃sã, ʉ̃sã pacʉ tiroma beꞌropʉre apeyenojõ ñeꞌeatje ne moosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tojo weronojõ oꞌogʉ, ʉ̃sãrẽ aperocjãrãrẽ weronojõ tojo ĩꞌacõꞌacãꞌmi. Ʉ̃sãpʉreta mʉꞌʉrẽ nʉmotidutigʉ duasãjãwĩ. Nipeꞌtise ʉ̃sãrẽ duaꞌque wapare cõꞌastepeꞌocãꞌmi. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Diacjʉ̃ta niꞌi. Ʉ̃sã pacʉre Õꞌacʉ̃ cʉ̃ cʉosere ẽꞌmaꞌque ʉ̃sã ye, ʉ̃sã põꞌrã ye niꞌi. Õꞌacʉ̃ mʉꞌʉrẽ níꞌcaronojõta weeya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Jacob cʉ̃ pacʉ Isaa nirĩ diꞌta Canaápʉ dajatojaacʉ niwĩ. Tojo weegʉ cʉ̃ põꞌrãrẽ, cʉ̃ nʉmosãnumiarẽ cameyoa buꞌipʉ miipeocʉ niwĩ. Nipeꞌtise cʉ̃ cʉoꞌquere miacʉ niwĩ. Nipeꞌtirã ecarã cʉ̃ daꞌraꞌque wapa Padan-arãpʉ cʉ̃ bocaꞌquere miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labán aperopʉ cʉ̃ yarã ovejare poari seegʉ waꞌari cura, Raquel co pacʉ ẽjõpeose na queose yeeꞌquere cʉ̃ ya wiꞌipʉ nisere yajaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob cʉ̃ mañecʉ̃ Labán arameo masʉ̃rẽ weꞌrititimigʉ̃, weesoo, duꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nipeꞌtise cʉ̃ cʉose meꞌrã duꞌtiwãꞌcãcʉ niwĩ. Éufrates wãmetiri maarẽ eja, pẽꞌabaqueꞌocʉ niwĩ. Diacjʉ̃ yʉꞌrʉmajã, Galaad buꞌpapijaro nirõpʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Iꞌtia nʉmʉ beꞌro Labán Jacob cʉ̃ duꞌtiꞌquere masĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tojo weegʉ Labán cʉ̃ acawererã meꞌrã Jacore sirutugʉ waꞌacʉ niwĩ. Siete nʉmʉrĩ beꞌro Galaad buꞌpapijaro nirõpʉ ẽmʉejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Cʉ̃ topʉ ejati ñamirẽ Õꞌacʉ̃ Labã́rẽ, arameo masʉ̃rẽ quẽꞌerõpʉ bajuacʉ niwĩ. Bajua, aꞌtiro nicʉ niwĩ: “Tʉꞌoya, Jacore pũrĩrõ ucũacʉpa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labán Jacore Galaad buꞌpapijaro cʉ̃ cãrĩꞌcaropʉ ẽmʉejacʉ niwĩ. Topʉta Labán, cʉ̃ acawererã meꞌrã tojaqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Beꞌro Jacore ĩꞌa, aꞌtiro ni sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weeati mʉꞌʉ? ¿Deꞌro weegʉ yʉꞌʉre weesooati? Mʉꞌʉ yʉꞌʉ põꞌrã numiarẽ aꞌmewẽjẽrã ñeꞌenoꞌcãrã numiarẽ weronojõ miitiapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Deꞌro weegʉ yʉꞌʉre weretimigʉ̃, weesoo, ĩꞌatiro duꞌtiati? Yʉꞌʉ queoro masĩgʉ̃ pũrĩcã, mʉꞌʉrẽ añurõ weꞌritiboapã. Bʉapʉ̃tẽrõ, toꞌatʉ meꞌrã bosenʉmʉ weetʉoboapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yʉꞌʉ põꞌrã numiarẽ, yʉꞌʉ pãrãmerãrẽ ne cãꞌrõ miꞌmitʉotiasʉ. Mʉꞌʉ ne tʉꞌomasĩtibutiagʉ weronojõ weeapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yʉꞌʉ mʉsãrẽ ñaꞌarõ weesĩꞌrĩgʉ̃ weecãꞌboapã. Mʉꞌʉ pacʉ ẽjõpeogʉ Õꞌacʉ̃ peꞌe yʉꞌʉre ñamipʉ ucũami. Aꞌtiro niami: “Tʉꞌoya, Jacore pũrĩrõ ucũacʉpa”, niami. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mʉꞌʉ, mʉꞌʉ pacʉ tiropʉ ʉpʉtʉ dajasĩꞌrĩꞌcʉ niyugʉ, aꞌtitojapã. Tojo nimigʉ̃, ¿deꞌro weegʉ yʉꞌʉ ẽjõpeorã na queose yeeꞌquere yajati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ uiasʉ. Apetero weegʉ mʉꞌʉ põꞌrã numiarẽ tutuaro meꞌrã numitaꞌabosami, niasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Noꞌo mʉꞌʉ ẽjõpeorã queose yeeꞌquere cʉogʉnojõ wẽrĩato. Aꞌto nirã́ marĩ acawererã ĩꞌorõpʉ aꞌmaña. Narẽ bocagʉ, miaña. Jacob peꞌe, “Raquel co pacʉ ẽjõpeose yeeꞌquere yajapõ”, ni masĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labán Jacob ya wiꞌi, suꞌti casero meꞌrã wééca wiꞌipʉ aꞌmagʉ̃, sãjãamʉꞌtãcʉ niwĩ. Beꞌro Lea ya wiꞌipʉ sãjãacʉ niwĩ. To beꞌro na pʉarã numia narẽ daꞌracoꞌterã ye wiꞌseriacãpʉ sãjãacʉ niwĩ. Cʉ̃ ẽjõpeose queose yeeꞌquere ne bocaticʉ niwĩ. Lea ya wiꞌipʉ níꞌcʉ wijati, Raquel ya wiꞌipʉ sãjãacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Co peꞌe cʉ̃ sãjãti dʉporo te queosere míí, cameyo pesarã na dujiro docapʉ cũuco niwõ. Beꞌro te buꞌipʉ mʉjãpeja, dujidiꞌopesaco niwõ. Labán nipeꞌtiro ti wiꞌipʉre aꞌmapeꞌocʉ nimiwĩ. Ne bocaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raquel peꞌe pacʉre nico niwõ: —Pacʉ, mʉꞌʉ tiro yʉꞌʉ dijaticã uacʉpa. Yʉꞌʉ niꞌcãcãrẽ beꞌtigo nisaꞌa, nico niwõ. Labán nipeꞌtiropʉ cʉ̃ ẽjõpeose queose yeeꞌquere aꞌmacʉ nimiwĩ. Ne bocaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Cʉ̃ bocaticã ĩꞌagʉ̃, Jacob ua waꞌacʉ niwĩ. Tojo weegʉ “Mejõ waro dioapã” nígʉ̃, Labã́rẽ aꞌtiro nicʉ niwĩ: —¿Ñeꞌenojõ mʉꞌʉrẽ ñaꞌarõ weeati? Mʉꞌʉ yʉꞌʉre ñaꞌabutiaro wééca beꞌro weronojõ yʉꞌʉre sirutubutiapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nipeꞌtise yeacãrẽ añurõ ĩꞌaweepeꞌobutiacãꞌa. ¿Mʉꞌʉ ya wiꞌi cjase apeyenojõacã bocati? Bocagʉ, aꞌto mʉꞌʉ acawererã ĩꞌorõ, tojo nicã yʉꞌʉ acawererã ĩꞌorõ bajurópʉ peoya. Na noa peꞌe diacjʉ̃ ucũti ni, beserãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yʉꞌʉ mʉꞌʉ tiropʉre veinte cʉ̃ꞌmarĩ daꞌrawʉ. Te cʉ̃ꞌmarĩrẽ ne niꞌcãti mʉꞌʉ yarã oveja, cabra sĩatíwã. Ne niꞌcãti mʉꞌʉ yarã ecarã oveja, cabra ʉmʉarẽ baꞌatiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ne niꞌcãti waꞌicʉrã nʉcʉ̃cjãrã wẽjẽnoꞌcãrãrẽ mʉꞌʉ tiropʉ miidajatiwʉ. Yʉꞌʉ basu tere wapayewʉ. Topʉ ʉmʉco, ñami ãpẽrã masã na mʉꞌʉ yarãrẽ yajacãma, mʉꞌʉ yʉꞌʉre wapaseewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ʉmʉcjore yʉꞌʉ asise poowʉ. Ñami peꞌere yʉsʉabʉꞌa narãsãwʉ̃. Apeterore ne cãrĩtiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mʉꞌʉ ya wiꞌipʉre veinte cʉ̃ꞌmarĩ niwʉ̃. Mʉꞌʉ põꞌrã pʉarã numiarẽ wapataꞌagʉ, catorce cʉ̃ꞌmarĩ mʉꞌʉ dutiro doca daꞌrawʉ. Mʉꞌʉ yarã ecarãrẽ coꞌtégʉ seis cʉ̃ꞌmarĩ daꞌrawʉ. Yʉꞌʉ wapataꞌasere mʉꞌʉ naꞌirõ dʉcayumʉjãwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Yʉꞌʉ ñecʉ̃ Abrahã wiogʉ Õꞌacʉ̃ yʉꞌʉ meꞌrã niticãma, yʉꞌʉ pacʉ Isaa wiopesase meꞌrã cʉ̃ ẽjõpeogʉ Õꞌacʉ̃ yʉꞌʉ meꞌrã niticãma, tojowarota mʉꞌʉ yʉꞌʉre oꞌotõrõbopã. Ne moobutiagʉ dajabopã. Õꞌacʉ̃ yʉꞌʉ piꞌetisere ĩꞌagʉ̃, yʉꞌʉ daꞌraꞌquere ĩꞌagʉ̃, ñamipʉ mʉꞌʉrẽ tutuaro meꞌrã ucũapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tere tʉꞌogʉ, Labán Jacore yʉꞌticʉ niwĩ: —Yʉꞌʉ põꞌrã numia, yʉꞌʉ põꞌrãta nima. Yʉꞌʉ pãrãmerã yʉꞌʉ pãrãmerãta nima. Oveja quẽꞌrã yarã ovejata nima. Nipeꞌtise aꞌto mʉꞌʉ ĩꞌase ye diaꞌcʉ̃ niꞌi. Tojo nimicã, niꞌcãrõacãrẽ yʉꞌʉ põꞌrã numiarẽ, yʉꞌʉ pãrãmerãrẽ ¿deꞌro weebosari yʉꞌʉ? ");
INSERT INTO tuoNT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tojo weerã marĩ pʉarã aꞌmerĩ “Aꞌtiro weerã́” ni aporã. Tere marĩ beꞌropʉre “Tojota ni aponoꞌwʉ̃” ninoꞌrõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tere tʉꞌogʉ, Jacob niꞌcã ʉ̃tãgã mii, niꞌcã tuturo weronojõ nʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Beꞌro cʉ̃ acawererãrẽ aꞌtiro nicʉ niwĩ: —Ʉ̃tãperire seeneocũuña. Tojo weerã nipeꞌtirã niꞌcã mesãjo seeneocũucãrã niwã. Na nipeꞌtirã ti mesã pʉꞌtopʉ baꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labán tore cʉ̃ ye ucũse meꞌrã aꞌtiro wãme õꞌocʉ niwĩ “Jegar Sahaduta”. Jacob peꞌe cʉ̃ ye meꞌrã “Galaad” wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Tojo weegʉ Labán nicʉ niwĩ: —Aꞌti ʉ̃tãmesã meꞌrã marĩ niꞌcãcã apoꞌquere wãcũnoꞌrõsaꞌa. Tojo weero Galaad wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tojo nicã Mizpa wãmeticaro niwʉ̃. Labán aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ marĩ aꞌmerĩ ĩꞌatiri curare marĩ pʉarãrẽ ĩꞌanʉrʉ̃ato. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Yʉꞌʉ põꞌrã numiarẽ mʉꞌʉ ñaꞌarõ weecã o ãpẽrã numiarẽ mʉꞌʉ nʉmotinemocã, apĩ marĩ aꞌmerĩ aposere ĩꞌatimicã, Õꞌacʉ̃ basuta marĩ weesere masĩgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labán Jacore apeye ninemocʉ niwĩ tja: —Aꞌto ʉ̃tãmesã yʉꞌʉ seeneocũuca mesã, tojo nicã ʉ̃tãgã yʉꞌʉ miinʉꞌcõcaga marĩ deco nisere ĩꞌaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Aꞌti mesã, tojo nicã aꞌtigare ĩꞌarã, marĩ pʉarã apoꞌquere wãcũrãsaꞌa. Yʉꞌʉ mʉꞌʉrẽ ñaꞌarõ weesĩꞌrĩgʉ̃, aꞌti mesãrẽ, aꞌtigare yʉꞌrʉsome. Tojo nicã mʉꞌʉ quẽꞌrã yʉꞌʉre ñaꞌarõ weesĩꞌrĩgʉ̃, yʉꞌrʉsome. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Marĩ mejẽcã weecã, Õꞌacʉ̃ Abrahã ẽjõpeogʉ, yʉꞌʉ ñecʉ̃ Nacor ẽjõpeogʉ marĩ weesere queoro beseato, nicʉ niwĩ Labán. Tere tʉꞌogʉ, Jacob Õꞌacʉ̃ cʉ̃ pacʉ Isaa ẽjõpeogʉ wãme meꞌrã “Tojota waꞌato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Beꞌro ti buꞌapʉ waꞌicʉre wẽjẽ, Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeocʉ niwĩ. Tuꞌajanʉꞌcõ, nipeꞌtirã cʉ̃ acawererãrẽ baꞌadutigʉ pijiocʉ niwĩ. Nipeꞌtirã baꞌacãrã niwã. Baꞌatoja, ti buꞌapʉ cãrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ape nʉmʉ ñamicureacã Labán wãꞌcã, waꞌagʉtigʉ, cʉ̃ pãrãmerãrẽ, cʉ̃ põꞌrã numiarẽ miꞌmitʉocʉ niwĩ. Beꞌro “Mʉsãrẽ añurõ waꞌato”, ni sẽrĩbosacʉ niwĩ. Tuꞌajanʉꞌcõ, cʉ̃ ya diꞌtapʉ majãmitojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Beꞌro Jacob apaturi waꞌacʉ niwĩ tja. Topʉ waꞌari cura Õꞌacʉ̃rẽ werecoꞌterã cʉ̃rẽ põtẽrĩrã aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Narẽ ĩꞌagʉ̃, Jacob aꞌtiro nicʉ niwĩ: “Na Õꞌacʉ̃ yarã surara nima.” Tojo weegʉ tore Mahanaim wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob cʉ̃ dʉporo quetiwereri masãrẽ Seir diꞌtapʉ oꞌómʉꞌtãcʉ niwĩ. To Seir Edom wãmetiropʉ tojacaro niwʉ̃. Cʉ̃ maꞌmi Esaúre quetiweremʉꞌtãdutigʉ, narẽ oꞌóyucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Narẽ aꞌte quetire weredutigʉ oꞌócʉ niwĩ: “Yʉꞌʉ maꞌmi Esaúre aꞌtiro ni wereapa: ‘Mʉꞌʉ acabiji Jacob mʉꞌʉ dutiro doca nigʉ̃́ aꞌtiro weredutiami: “Yʉꞌʉ yoacã Labán meꞌrã niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Niꞌcãrõacã wecʉa, burroa, oveja, daꞌracoꞌterã ʉmʉa, numia cʉoꞌo. Mʉꞌʉ yʉꞌʉ wiogʉ yʉꞌʉre añurõ wãcũcã ʉagʉ, aꞌte quetire oꞌómʉꞌtãꞌa” mʉꞌʉrẽ niami’, niapa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Cʉ̃ quetiweredutigʉ oꞌóꞌcãrã dajarã, Jacore aꞌtiro nicãrã niwã: —Ʉ̃sã mʉꞌʉ maꞌmi Esaú tiropʉ ejapʉ. Niꞌcãrõacã mʉꞌʉrẽ põtẽrĩgʉ̃ aꞌtiami. Cuatrocientos ʉmʉa meꞌrã aꞌtiami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Te quetire tʉꞌogʉ, Jacob ʉpʉtʉ uicʉ niwĩ. Pũrõ wãcũqueꞌticʉ niwĩ. Tojo weegʉ cʉ̃ meꞌrã níꞌcãrãrẽ pʉa curua dʉcawaacʉ niwĩ. Cʉ̃ yarã oveja, wecʉa, cameyoa quẽꞌrãrẽ mejãrõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Aꞌtiro wãcũcʉ niwĩ: “Esaú cʉ̃ niꞌcã curuacjãrã meꞌrã aꞌmewẽjẽgʉ̃ sãjãcã, ape curuacjãrã duꞌtiarãsama.” ");
INSERT INTO tuoNT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Beꞌro Õꞌacʉ̃rẽ aꞌtiro ñubue sẽrĩcʉ niwĩ: “Õꞌacʉ̃, yʉꞌʉ ñecʉ̃ Abrahã ẽjõpeogʉ, tojo nicã yʉꞌʉ pacʉ Isaa ẽjõpeogʉ, mʉꞌʉ yʉꞌʉre ya diꞌtapʉ, yʉꞌʉ acawererã tiropʉ dajadutiapʉ. ‘Mʉꞌʉ acawererã tiropʉ dajacã, mʉꞌʉrẽ añurõ waꞌacã weegʉti’, niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mʉꞌʉ yʉꞌʉre añurõ pajañaꞌa, queoro weeapʉ. Yʉꞌʉ ñaꞌagʉ̃ nimicã, tojo weeapʉ. Yʉꞌʉ aꞌti maa dia Jordã́rẽ yʉꞌrʉtẽrĩpẽꞌagʉ̃, yʉꞌʉ tuacjʉacã diaꞌcʉ̃ cʉomiwʉ̃. Niꞌcãrõacãma pʉa curua masã cʉoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yʉꞌʉre pajañaꞌcureya. Yʉꞌʉ maꞌmi Esaú yʉꞌʉre ne mejẽcã weecã weeticãꞌña. Cʉ̃ yʉꞌʉre, numiarẽ, wĩꞌmarãrẽ wẽjẽbosami nígʉ̃, uiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tojo nimicã, mʉꞌʉ yʉꞌʉre ‘Añurõ mʉꞌʉrẽ waꞌacã weegʉti. Mʉꞌʉ pãrãmerã nituriarã pãjãrã waro nucũpori pajiri maa cjase weronojõ pãjãrã nirãsama. Ne narẽ queota basiosome’, niwʉ̃”, ni sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ti ñamirẽ Jacob topʉta cãrĩcʉ niwĩ. Cʉ̃ cʉose, cʉ̃ miaꞌquere cʉ̃ maꞌmi Esaúre oꞌogʉtigʉ besecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Doscientos cabra numia, veinte cabra ʉmʉa, doscientos oveja numia, veinte oveja ʉmʉa, ");
INSERT INTO tuoNT_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","treinta cameyoa numia ne põꞌrãtiꞌcãrãrẽ na põꞌrã wĩꞌmarã meꞌrãta, cuarenta wecʉa, diez wecʉa ʉmʉarẽ, veinte burroa numiarẽ, diez burroa ʉmʉarẽ besecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Beꞌro cʉ̃rẽ daꞌracoꞌterãrẽ wiacʉ niwĩ. Narẽ wiagʉ, mejẽcã diaꞌcʉ̃ waꞌicʉrãrẽ, nanʉcʉ̃ curaricjãrãrẽ wiacʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —Mʉsã yʉꞌʉ dʉporo waꞌayuya. Na waꞌicʉrãrẽ te curarinʉcʉ̃ yoacurero dʉcawaa miaña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ne waro cʉ̃ oꞌómʉꞌtãgʉ̃rẽ aꞌtiro weeduticʉ niwĩ: —Yʉꞌʉ maꞌmi Esaúre põtẽrĩgʉ̃, cʉ̃ sẽrĩtiñaꞌcã, “¿Noa mʉꞌʉ wiogʉ niti, noꞌopʉ waꞌati, ãꞌrã waꞌicʉrã mʉꞌʉ miarã, noa yarã niti?” nicã, ");
INSERT INTO tuoNT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","aꞌtiro yʉꞌtiya: “Yʉꞌʉ wiogʉ Jacob, mʉꞌʉrẽ oꞌóꞌcãrã nima. Jacob, mʉꞌʉ dutise doca nigʉ̃́ mʉꞌʉrẽ oꞌoámi. Cʉ̃ ʉ̃sã beꞌro sirutusami,” niña. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Cʉ̃ oꞌómʉꞌtãꞌcʉ beꞌrocjʉ̃, tojo nicã nipeꞌtirã cʉ̃ beꞌrocjãrã quẽꞌrãrẽ mejãrõta wereduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Apeye quẽꞌrãrẽ aꞌtiro niduticʉ niwĩ: “ ‘Jacob mʉꞌʉ dutise doca nigʉ̃́ ʉ̃sã beꞌro aꞌtisami’, niapa”, nicʉ niwĩ. Jacob aꞌtiro wãcũcʉ niwĩ: “Yʉꞌʉ dʉporo apeyenojõ oꞌomʉꞌtãse meꞌrã cʉ̃ uase peꞌticã weegʉti. Beꞌro yʉꞌʉ basu cʉ̃rẽ ĩꞌacã, apetero weegʉ yʉꞌʉre añurõ põtẽrĩgʉ̃sami”, ni wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tojo wãcũꞌcʉ niyugʉ, cʉ̃ oꞌoatjere cʉ̃ dʉporo miayuduticʉ niwĩ. Cʉ̃ peꞌe topʉta ti ñamirẽ tojánícʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tojo weegʉ ti ñamirẽta ñamipʉ Jacob cãrĩatji dʉporo wãꞌcãnʉꞌcã, cʉ̃ nʉmosãnumia pʉarãrẽ, narẽ daꞌracoꞌterã numiarẽ, cʉ̃ põꞌrã ʉmʉa oncere ti maa Jaboc wãmetiri maa ʉ̃ꞌcʉ̃atiropʉ ñumupẽꞌaduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Cʉ̃ nipeꞌtise cʉose quẽꞌrãrẽ pẽꞌrõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Cʉ̃ niꞌcʉ̃ta tojanʉꞌcãrĩ cura, niꞌcʉ̃ ʉmʉ bajua, cʉ̃ meꞌrã aꞌmerĩ ñadiꞌocũupecãrã niwã. Téé boꞌremʉjãticãpʉ tojo weeduꞌucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Cʉ̃ Jacob meꞌrã põtẽoti, Jacob ʉsó õꞌa aꞌmesʉꞌarore paaweecʉ niwĩ. Tojo weero to aꞌmesʉꞌaro wetia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Beꞌro ʉmʉ cʉ̃ meꞌrã aꞌmequẽꞌcʉ Jacore nicʉ niwĩ: —Yʉꞌʉre duꞌuya. Boꞌrearopʉ weeꞌe, nicʉ niwĩ. Jacob cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ, yʉꞌʉre “Añurõ waꞌato” niticãma, ne duꞌusome. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","—To pũrĩcãrẽ ¿mʉꞌʉ deꞌro wãmetiti? nicʉ niwĩ. —Yʉꞌʉ Jacob wãmetiꞌi, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tere tʉꞌogʉ, cʉ̃ meꞌrã aꞌmequẽꞌcʉ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ Jacob wãmetisome majã. Õꞌacʉ̃ meꞌrã, masã meꞌrã aꞌmequẽgʉ̃, wapataꞌapʉ. Tojo weegʉ niꞌcãrõacãrẽ majã Israe wãmetigʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","—Mʉꞌʉ quẽꞌrã yʉꞌʉre wereya. ¿Deꞌro wãmetiti mʉꞌʉ? ni sẽrĩtiñaꞌcʉ niwĩ Jacob. —Yʉꞌʉ wãmerẽ sẽrĩtiñaꞌticãꞌña, ni yʉꞌticʉ niwĩ. Beꞌro topʉta Jacore “Mʉꞌʉrẽ añurõ waꞌato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob aꞌtiro nicʉ niwĩ: “Yʉꞌʉ basuta Õꞌacʉ̃rẽ bajuyoropʉ ĩꞌapʉ. Tojo nimigʉ̃, catiꞌi yujupʉ.” Tojo weegʉ to na aꞌmerĩ ñadiꞌocũupeꞌcarore Jacob Peniel wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jacob cʉ̃ Peniepʉre yʉꞌrʉari curare mujĩpũ mʉjãtigʉpʉ weecʉ niwĩ. Cʉ̃rẽ ʉsó aꞌmesʉꞌaropʉ paanoꞌca beꞌro niyucã, cʉ̃ opa cuꞌsiro sijacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tojo weerã aꞌtocatero quẽꞌrãrẽ Israe pãrãmerã nituriarã noꞌo nigʉ̃́ waꞌicʉ ʉsó õꞌa aꞌmesʉꞌari wadare baꞌatisama. Jacore topʉ pááca beꞌro niyucã, tojo weesama. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Esaú cuatrocientos ʉmʉa meꞌrã aꞌticã ĩꞌagʉ̃, Jacob aꞌtiro weecʉ niwĩ. Lea, Raquel, pʉarã narẽ daꞌracoꞌterã numia meꞌrã nanʉcʉ̃ na põꞌrãrẽ dʉcawaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Narẽ daꞌracoꞌterã numiarẽ na põꞌrã meꞌrã na dʉporo nʉꞌcõcʉ niwĩ. Beꞌro Leare co põꞌrã meꞌrã nʉꞌcõcʉ niwĩ. Nitʉoropʉ Raquere co macʉ̃ José meꞌrã nʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Beꞌro Jacob na dʉporoacã ʉꞌmʉtãwãꞌcãcʉ niwĩ. Esaúre põtẽrĩgʉ̃ waꞌagʉ, sietetiri cʉ̃ diapoare nucũcãpʉ paamuꞌrĩqueꞌacʉ niwĩ. Téé cʉ̃ tiropʉ ejagʉ, tojo weeduꞌucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaú peꞌe cʉ̃rẽ põtẽrĩgʉ̃, omawãꞌcãti, paabʉꞌa, miꞌmicʉ niwĩ. Na pʉarãpʉta aꞌmerĩ uticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tuꞌajanʉꞌcõ, Esaú na numiarẽ, wĩꞌmarãrẽ ĩꞌa, aꞌtiro ni sẽrĩtiñaꞌcʉ niwĩ: —¿Ãꞌrã waro noanojõ niti? ni sẽrĩtiñaꞌcʉ niwĩ. —Na, yʉꞌʉ põꞌrã Õꞌacʉ̃ yʉꞌʉre, mʉꞌʉ dutise doca nigʉ̃rẽ oꞌoꞌcãrã nima, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tojo nicã tʉꞌorã, cʉ̃rẽ daꞌracoꞌterã numia na põꞌrã meꞌrã, Esaú tiroacãpʉ waꞌa, cʉ̃rẽ wiopesase meꞌrã añudutirã, nucũcãpʉ paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Beꞌro Lea cʉ̃ tiroacãpʉ aꞌti, co quẽꞌrã co põꞌrã meꞌrã mejãrõta weeco niwõ. Yapatigopʉa Raquel co macʉ̃ José meꞌrã, mejãrõta weeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaú Jacore sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weegʉsari mʉꞌʉ, waꞌicʉrã sõꞌonícãrã yʉꞌʉre põtẽrĩwãꞌcãꞌcãrã pãjãrã meꞌrã? Jacob cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ yʉꞌʉre añurõ wãcũcã ʉagʉ, tojo weeasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","—Niweꞌe, nijã. Yʉꞌʉ quẽꞌrã pãjãrã cʉoapʉ. Na mʉꞌʉ yarã meꞌrãta tojayá, nicʉ niwĩ Esaú. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob cʉ̃ maꞌmirẽ ninemocʉ niwĩ: —Yʉꞌʉre añurõ wãcũgʉ̃, yʉꞌʉ oꞌosere ñeꞌeña. Yʉꞌʉ mʉꞌʉrẽ ĩꞌagʉ̃, Õꞌacʉ̃rẽ ĩꞌagʉ̃ weronojõ ĩꞌaꞌa. Mʉꞌʉ yʉꞌʉre añurõ põtẽrĩ ñeꞌetojapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Yʉꞌʉ mʉꞌʉrẽ miiti oꞌosere ñeꞌeña. Õꞌacʉ̃ yʉꞌʉre peje apeyenojõ cʉocã weeami. Ne apeyenojõ dʉꞌsaweꞌe. Jacob cʉ̃ pejetiri tojo nicã tʉꞌogʉ, Esaú “Jaʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Beꞌro Esaú nicʉ niwĩ: —Teꞌa. Yʉꞌʉ mʉꞌʉ dʉporo ʉꞌmʉtãgʉ̃ti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Maꞌmi, yʉꞌʉ maꞌigʉ̃, mʉꞌʉ masĩsaꞌa. Wĩꞌmarã marĩ weronojõ tutuatima. Oveja, wecʉa, na põꞌrãrẽ yʉꞌʉ wãcũsaꞌa. Na niꞌcã nʉmʉta ñujũyʉꞌrʉrã, wẽrĩpeꞌtia waꞌabosama. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mʉꞌʉ peꞌe mʉꞌʉ dutise doca nigʉ̃́ dʉporo ʉꞌmʉtãwãꞌcãña. Mʉꞌʉ tojo weecã, añurõsaꞌa. Yʉꞌʉ peꞌe waꞌicʉrã, yʉꞌʉ dʉporo waꞌarã na sijaro ejatuaro sajatiro waꞌagʉti. Tojo nicã wĩꞌmarã na sijaro ejatuaro waꞌagʉti. Téé Seipʉ aꞌmerĩ ĩꞌarã, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaú, “Jaʉ, tojota weerã́. Yʉꞌʉ meꞌrã aꞌtiꞌcãrã ʉmʉarẽ mʉꞌʉrẽ baꞌpaticã, pejetirã cũugʉ̃ti”, nicʉ niwĩ. Jacob peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Añurõsaꞌa. Cũuticãꞌña. Mʉꞌʉrẽ caribosĩꞌrĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na tojo ni ucṹca nʉmʉrẽta Esaú Seipʉ dajatojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob peꞌe Sucot wãmetiropʉ waꞌacʉ niwĩ. Topʉ cʉ̃ niatji wiꞌire weecʉ niwĩ. Tojo nicã waꞌicʉrã ye wiꞌseriacãrẽ paapeocʉ niwĩ. Tojo weegʉ tore Sucot wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob cʉ̃ Padan-arãpʉ níꞌcʉ, cʉ̃ dajatojaticã, ne mejẽcã waꞌaticaro niwʉ̃. Canaápʉre añurõ dajacʉ niwĩ. Topʉre Siquem wãmetiri macã põtẽorõ tojaqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Cien cujiri niyeru cujiri meꞌrã niꞌcã diꞌta duucʉ niwĩ. Ti diꞌtare Hamor põꞌrã duacãrã niwã. Cʉ̃ Siquem wãmetigʉ pacʉ nicʉ niwĩ. Topʉ Jacob cʉ̃ ya wiꞌi, suꞌti caseri meꞌrã sẽeopeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tuꞌajanʉꞌcõ, Õꞌacʉ̃rẽ ẽjõpeogʉ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tore El-Elohe-Israe wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lea macõ Dina Jacore põꞌrãtibosaꞌco, tocjãrã nuꞌmiarẽ ĩꞌagõ waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tojo weeri cura, Siquem, Hamor heveo masʉ̃ macʉ̃ core ĩꞌagʉ̃, tutuaro meꞌrã ñeꞌe, ñaꞌarõ weecʉ niwĩ. Cʉ̃ Hamor tocjãrãrẽ dutigʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tojo ñaꞌarõ weeꞌcʉ nimigʉ̃, core ʉagʉ, cʉ̃rẽ tʉꞌsacã weesĩꞌrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tojo weegʉ, cʉ̃ pacʉ Hamor meꞌrã aꞌtiro ucũcʉ niwĩ: —Pacʉ, yʉꞌʉre aꞌtigore numisẽrĩbosagʉ waꞌaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob peꞌe cʉ̃ macõrẽ ñaꞌarõ weeꞌquere masĩtojacʉ nimiwĩ. Cʉ̃ põꞌrã peꞌe cãpũpʉ na yarã ecarãrẽ coꞌterã weecãrã niwã. Tojo weegʉ téé na dajacãpʉ ne mejẽcã nimaꞌaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tojo weeri curare Hamor Siquem pacʉ Jacob meꞌrã ucũgʉ̃ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jacob põꞌrã na cãpũpʉ níꞌcãrã dajarã, te quetire tʉꞌorã, uayʉꞌrʉa, aꞌtiro nicãrã niwã: “Siquem Israe põꞌrãrẽ ñaꞌabutiaro bopoyoro weeapĩ, co meꞌrã wʉacãjĩgʉ̃. Tenojõrẽ ne weenoꞌña marĩꞌi”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tojo nimicã, Hamor peꞌe na meꞌrã ucũ, aꞌtiro nicʉ niwĩ: —Yʉꞌʉ macʉ̃ Siquem mʉsã acabijore tʉꞌsayʉꞌrʉami. Core cʉ̃rẽ numisoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mʉsã ʉ̃sã acawererã weronojõ tojarã́saꞌa. Ʉ̃sã mʉsã põꞌrã numiarẽ nʉmoti, mʉsã peꞌe quẽꞌrã ʉ̃sã põꞌrã numiarẽ nʉmotirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ʉ̃sã meꞌrã aꞌtopʉ tojayá. Aꞌti diꞌta nipeꞌtiro mʉsã ya diꞌta tojarosaꞌa. Diꞌtare duutjĩarã, duase tucũrĩ pãaña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siquem peꞌe quẽꞌrã cʉ̃ basu Dina pacʉ Jacore, co maꞌmisʉmʉarẽ aꞌtiro nicʉ niwĩ: —Mʉsã yʉꞌʉre core oꞌocã ʉasaꞌa. Mʉsã noꞌo sẽrĩsere oꞌogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Noꞌocãꞌrõ mʉsã sẽrĩrõ põtẽorõ sẽrĩcã, oꞌogʉti. Mejõ yʉꞌʉre core numisoya majã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Cʉ̃ Siquem tojo nimicã, na acabijo Dinarẽ ñaꞌarõ weeꞌque wapa Jacob põꞌrã cʉ̃rẽ, cʉ̃ pacʉ Hamorẽ nisoose meꞌrã yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Aꞌtiro nicãrã niwã: —Ʉ̃sã acabijore õꞌrẽcjʉ yapa casero yejecõꞌanoꞌtigʉre numisomasĩtisaꞌa. Ʉ̃sã tojo weerã bopoyoro weerã weebosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tojo weenoꞌcãrã diaꞌcʉ̃rẽ ʉ̃sã numisorãti. Mʉsã quẽꞌrã ʉ̃sã weronojõ niña. Nipeꞌtirã ʉmʉa mʉsã waꞌteropʉ nirãrẽ na õꞌrẽcjʉ yapa caserore yejecõꞌaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tojo wééca beꞌro pũrĩcãrẽ mʉsã, ʉ̃sã põꞌrã numiarẽ nʉmotirãsaꞌa. Ʉ̃sã quẽꞌrã mʉsã põꞌrã numiarẽ nʉmotirãsaꞌa. Marĩ niꞌcãrõ meꞌrã nirãsaꞌa. Niꞌcã macãcjãrãta nirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mʉsã ʉ̃sã tojo nisere yʉꞌtiticãma, ʉ̃sã aꞌtore wija, ʉ̃sã acabijore miarãsaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tere tʉꞌorã, Hamor, cʉ̃ macʉ̃ Siquem “Jaʉ, añurõsaꞌa”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tojo weegʉ ne yoogoro marĩrõ Siquem cʉ̃ ya õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌcʉ niwĩ. Jacob macõrẽ tʉꞌsayʉꞌrʉatjĩagʉ̃, tojo weecʉ niwĩ. Cʉ̃ Siquẽrẽta cʉ̃ niꞌcʉ̃ põꞌrãrẽ ãpẽrã yʉꞌrʉoro cʉ̃rẽ wiopesase meꞌrã ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tojo weerã Siquem cʉ̃ pacʉ Hamor meꞌrã macã sãjãrĩ sope pʉꞌtopʉ waꞌacãrã niwã. Topʉ na apeyenojõrẽ duase tiropʉ masãrẽ aꞌtiro werecãrã niwã: ");
INSERT INTO tuoNT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Sõjã masã marĩ meꞌrã maata níꞌcãrã weronojõ nisetiama. Na aꞌtopʉ nirãsama. Aꞌtopʉ apeyenojõrẽ duase wiꞌseri weerãsama. Diꞌta pajiro nicãꞌa. Marĩ na põꞌrã numiarẽ nʉmotirãsaꞌa. Na peꞌe quẽꞌrã marĩ põꞌrã numiarẽ nʉmotirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Na marĩ meꞌrã nirãti, nírã, aꞌtiro weecã ʉama. Na weesetironojõta marĩ põꞌrã ʉmʉarẽ na õꞌrẽcjʉ yapa caserore yejecõꞌacã ʉama. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nipeꞌtise na cʉose, nipeꞌtirã na yarã ecarã marĩ ye nirõsaꞌa. Marĩ “Tojota weerãti” nicã, na marĩ meꞌrã tojarã́sama. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Nipeꞌtirã ʉmʉa ti macã sope pʉꞌto nerẽrã Hamor, cʉ̃ macʉ̃ Siquem meꞌrã na tojo nisere “Añurõsaꞌa, tojota weerãti”, nicãrã niwã. Tojo weerã nipeꞌtirã ʉmʉa na õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Iꞌtia nʉmʉ beꞌro na yejecõꞌanoꞌcãrã pũrĩnoꞌrĩ cura Jacob põꞌrã pʉarã Simeó, Leví macãpʉ waꞌacãrã niwã. Na ye diꞌpjĩrĩ meꞌrã na ne wãcũtiri cura nipeꞌtirã ʉmʉarẽ wẽjẽpeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor, cʉ̃ macʉ̃ Siquem quẽꞌrãrẽ diꞌpjĩ meꞌrãta wẽjẽcãrã niwã. Beꞌro Dinarẽ Siquem ya wiꞌipʉ níꞌcore miiwijaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Beꞌro ãpẽrã Jacob põꞌrã sirutu, ejanemocãrã niwã. Na wẽjẽnoꞌcãrã cũñarõ waꞌteropʉ yʉꞌrʉa, ti macãpʉ apeyenojõrẽ yajapeꞌocãꞌcãrã niwã. Na acabijore ñaꞌarõ weeꞌque wapa aꞌmerã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Oveja, wecʉa, burroa, nipeꞌtise ti macãpʉ níꞌquere, cãpũpʉ níꞌquere yajacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wiꞌseri poꞌpeapʉ na cʉoꞌquere yajapeꞌocãꞌcãrã niwã. Wĩꞌmarãrẽ, tojo nicã numiarẽ ñeꞌe, miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tere ĩꞌagʉ̃, Jacob Simeó, Levíre aꞌtiro nicʉ niwĩ: —Mʉsã yʉꞌʉre ñaꞌabutiaro weepetíyeapã. Niꞌcãrõacãma aꞌtopʉ nirã́ masã cananeo masã, ferezeo masã yʉꞌʉre ne ĩꞌasĩꞌrĩtirãsama. Na yʉꞌʉ meꞌrã aꞌmewẽjẽrãtirã nerẽrãsama. Yʉꞌʉ pejetirãcã masã cʉoꞌo. Marĩrẽ wẽjẽpeꞌocãꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Na peꞌe cʉ̃rẽ yʉꞌticãrã niwã: —To pũrĩcãrẽ ¿cʉ̃ ʉ̃sã acabijore ʉmʉarẽ aꞌmetãrãwapataꞌari masõrẽ weronojõ cʉobopari? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Õꞌacʉ̃ Jacore aꞌtiro nicʉ niwĩ: “Wãꞌcãnʉꞌcãña. Betepʉ waꞌa, topʉ tojaqueꞌaya. Topʉ niꞌcãrõ yʉꞌʉre ẽjõpeogʉ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore daꞌreapa. Mʉꞌʉ maꞌmi Esaúre uiwãꞌcãcaterore yʉꞌʉ topʉ mʉꞌʉrẽ bajuaꞌcaropʉ waꞌaya.” ");
INSERT INTO tuoNT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tere tʉꞌogʉ, cʉ̃ acawererãrẽ, nipeꞌtirã cʉ̃ meꞌrã nirãrẽ aꞌtiro nicʉ niwĩ: —Nipeꞌtise mʉsã ãpẽrãnojõ ẽjõpeorã queose yeeꞌquere cõꞌacãꞌña. Tojo nicã uꞌacoe, suꞌti dʉcayuya. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Teꞌa, Betepʉ waꞌarã. Topʉ Õꞌacʉ̃rẽ ẽjõpeogʉ, niꞌcãrõ cʉ̃rẽ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũugʉ̃ti. Cʉ̃ta yʉꞌʉre bʉjawetiri curare weetamuwĩ. Noꞌo waꞌaro yʉꞌʉre baꞌpatiwãꞌcãwĩ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Na ãpẽrãnojõ ẽjõpeorã queose yeeꞌque na cʉoꞌquere, tojo nicã na oꞌmeperi yosasere Jacore oꞌocãrã niwã. Jacob tere ñeꞌe, niꞌcãgʉ̃ yucʉgʉ encina wãmeticjʉjo docapʉ tere yaacʉ niwĩ. Tigʉjo Siquem pʉꞌtopʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Na topʉ níꞌcãrã wijawãꞌcãrĩ cura Õꞌacʉ̃ to pʉꞌtopʉ nise macãrĩcjãrãrẽ ʉpʉtʉ uicã weecʉ niwĩ. Tojo weerã Jacob põꞌrãrẽ sirututicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob, cʉ̃ meꞌrã waꞌaꞌcãrã, nipeꞌtirã Luz wãmetiri macãpʉ etacãrã niwã. Ti macãta tja Betel wãmeticaro niwʉ̃. Canaá diꞌtapʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Topʉ niꞌcãrõ Õꞌacʉ̃rẽ ẽjõpeorã waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tore Jacob cʉ̃ maꞌmirẽ duꞌticaterore Õꞌacʉ̃ cʉ̃rẽ bajuacʉ niwĩ. Tojo weegʉ tore El-betel wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Topʉta Rebecare coꞌteꞌco Débora wẽrĩco niwõ. Betel pʉꞌtoacã core niꞌcãgʉ̃ yucʉgʉ encina wãmeticjʉjo docapʉ yaacãrã niwã. Jacob tore “encina dʉjarigʉ” pisucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jacob cʉ̃ Padan-arãpʉ níꞌcʉ dajatojaticã, topʉta Õꞌacʉ̃ apaturi bajua, “Mʉꞌʉrẽ añurõ weegʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“Mʉꞌʉ Jacob wãmetiꞌi. Tojo wãmetisome majã. Niꞌcãcã meꞌrã mʉꞌʉ wãme Israe nirõsaꞌa”, nicʉ niwĩ tja. Cʉ̃ wãmerẽ dʉcayúca beꞌro, ");
INSERT INTO tuoNT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","aꞌtiro nicʉ niwĩ: “Yʉꞌʉ Õꞌacʉ̃ tutuayʉꞌrʉgʉ niꞌi. Mʉꞌʉ pãjãrã põꞌrãti, pãjãrã pãrãmerãtigʉsaꞌa. Mʉꞌʉ meꞌrã pãjãrã masãputirãsama. Peje macãrĩ waꞌarosaꞌa. Mʉꞌʉ pãrãmerã waꞌtero nirã́ wiorã waro sãjãrã́sama. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abrahã, Isaare yʉꞌʉ oꞌoꞌque diꞌtare mʉꞌʉ quẽꞌrãrẽ oꞌogʉti. Mʉꞌʉ beꞌrore, mʉꞌʉ pãrãmerã nituriarãrẽ oꞌogʉti”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Õꞌacʉ̃ topʉ Jacob meꞌrã ucũtoja, waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Beꞌro cʉ̃rẽ Õꞌacʉ̃ ucũꞌcaropʉ niꞌcãgã ʉ̃tãgãrẽ miiwãꞌcõnʉꞌcõcʉ niwĩ. Õꞌacʉ̃rẽ ẽjõpeosere ĩꞌogʉ̃, tigare olivo ʉꞌsere, tojo nicã ʉꞌsedʉcaco vinorẽ piopeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Tore Betel wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Beꞌro Betepʉ níꞌcãrã aperopʉ waꞌacãrã niwã. Na Efrata wãmetiropʉ etatjo dʉꞌsacaro niwʉ̃ yujupʉ. Topʉ Raquel wĩꞌmagʉ̃rẽ ñeꞌeco niwõ. Ne maata wĩꞌmagʉ̃rẽ ñeꞌemasĩtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Co ʉpʉtʉ pũrĩse piꞌetiri curare, põꞌrãtirãrẽ coꞌteri masõ aꞌtiro nico niwõ: “Uiticãꞌña. Wĩꞌmagʉ̃ bajuatojami. Ʉmʉ nimi tja”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Co tojo nirĩ cura, Raquel wẽrĩgṍpʉ nico niwõ. Co ejeripõꞌrã duꞌuati dʉporoacã co macʉ̃rẽ Benoni pisuco niwõ. Cʉ̃ pacʉ Jacob peꞌe cʉ̃rẽ Benjamí wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tojo wee Raquel wẽrĩa waꞌaco niwõ. Core Efrata waꞌari maꞌapʉ yaacãrã niwã. Niꞌcãrõacãma to Belẽ́ wãmetiꞌi majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob core yaaꞌcaro buꞌipʉre niꞌcã ʉ̃tãtuturo nʉꞌcõcʉ niwĩ. Téé aꞌtocateropʉ ti tuturore ĩꞌarã, “Aꞌto Raquere yaapã”, ni ĩꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Beꞌro Jacob yʉꞌrʉa, Eder wãmetiro oveja coꞌterã na coꞌtedujiri wiꞌi yʉꞌrʉropʉ tojaqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Na topʉ añurõ apoqueꞌa nisetiri cura Rubén cʉ̃ pacʉ nʉmo weronojõ nigṍ Bilha meꞌrã wʉacãjĩ, co meꞌrã nicʉ niwĩ. Tere masĩgʉ̃, cʉ̃ pacʉ ʉpʉtʉ waro uacʉ niwĩ. Jacob põꞌrã doce nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Cʉ̃ Lea meꞌrã aꞌticʉrã põꞌrãticʉ niwĩ: Rubén masã maꞌmi nicʉ niwĩ. Beꞌro Simeó, Leví, Judá, Isacar, Zabulṍ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Cʉ̃ Raquel meꞌrã aꞌticʉrã põꞌrãticʉ niwĩ: José, Benjamí nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha Raquere daꞌracoꞌtego níꞌco meꞌrã aꞌticʉrã põꞌrãticʉ niwĩ: Dan, Neftalí nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa, Leare daꞌracoꞌtego níꞌco meꞌrã aꞌticʉrã põꞌrãticʉ niwĩ: Gad, Aser nicãrã niwã. Ãꞌrã Jacob Padan-arãpʉ nicã bajuacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob cʉ̃ pacʉ Isaare Mamre wãmetiropʉ ĩꞌagʉ̃ waꞌacʉ niwĩ. Ti macãrẽ ãpẽrã Arba o Hebrṍ pisuma. Topʉ todʉporopʉ Abrahã, Isaa niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaa ciento ochenta cʉ̃ꞌmarĩ cʉogʉ, wẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Cʉ̃ ñecʉ̃sʉmʉarẽ sirutugʉ, cʉ̃ quẽꞌrã bʉcʉ waro waꞌa, wẽrĩa waꞌacʉ niwĩ. Cʉ̃ wẽrĩcã ĩꞌa, cʉ̃ põꞌrã Esaú, Jacob cʉ̃rẽ yaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aꞌticʉrã Esaú põꞌrã, cʉ̃ pãrãmerã nituriarã nicãrã niwã. Cʉ̃rẽta tja Edom pisucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú Canaá diꞌtacjãrã numiarẽ nʉmoticʉ niwĩ. Niꞌcõ Ada, Elón hitita masʉ̃ macõ nico niwõ. Apego Aholibama Aná macõ, Zibeón heveo masʉ̃ pãrãmeo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Apego Basemat Ismae macõ, Nebaiot acabijo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada meꞌrã cʉ̃ põꞌrãtiꞌcʉ Elifaz wãmeticʉ niwĩ. Basemat macʉ̃ Reuel wãmeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibama meꞌrã cʉ̃ põꞌrãtiꞌcãrã Jeús, Jaalam, Coré nicãrã niwã. Ãꞌrã cʉ̃ Canaá diꞌtapʉ nicã bajuacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú cʉ̃ nʉmosãnumia meꞌrã, cʉ̃ põꞌrã ʉmʉa, numia nipeꞌtirã cʉ̃ meꞌrã nirãrẽ piji, aperopʉ macãrĩ waꞌacʉ niwĩ. Cʉ̃ acabiji Jacob tiropʉ níꞌcʉ yoaropʉ waꞌacʉ niwĩ. Nipeꞌtirã cʉ̃ yarã waꞌicʉrãrẽ, tojo nicã nipeꞌtise cʉ̃ Canaá diꞌtapʉ bocaꞌquere miapeꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Na cʉ̃ acabiji Jacob meꞌrã apeyenojõ cʉoyʉꞌrʉmajã waꞌacãrã niwã. Tojo weerã na niꞌcãrõ meꞌrã nita basioticaro niwʉ̃. Tojo nicã waꞌicʉrã na cʉorã pãjãrãrẽ baꞌase ejatuaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tojo weegʉ Esaú, apetero Edom na nigʉ̃́, Seir opa buꞌpapijaro nirõpʉ macãrĩ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esaú pãrãmerã nituriarã edomita masã Seir opa buꞌpapijaro nirõpʉ niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esaú põꞌrã ʉmʉa aꞌtiro wãmeticãrã niwã: Ada, Esaú nʉmo Elifare põꞌrãtico niwõ. Esaú nʉmo apego Basemat Reuere põꞌrãtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz põꞌrã ʉmʉa aꞌtiro wãmeticãrã niwã: Temán, Omar, Zefo, Gatam, Cenaz nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ãꞌrã, Esaú nʉmo Ada pãrãmerã nicãrã niwã. Elifaz apego cʉ̃ nʉmo nitigo meꞌrã põꞌrãticʉ niwĩ tja. Co Timna wãmetico niwõ. Co meꞌrã Amalec wãmetigʉre põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel põꞌrã aꞌticʉrã nicãrã niwã: Nahat, Zera, Sama, Miza nicãrã niwã. Na, apego Esaú nʉmo Basemat pãrãmerã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Apego Aholibama Esaú nʉmo nico niwõ tja. Co meꞌrã aꞌticʉrã põꞌrãticʉ niwĩ: Jeús, Jaalam, Coré nicãrã niwã. Co Ana macõ, Zibeón pãrãmeo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aꞌticʉrã Esaú pãrãmerã nituriarã wiorã nicãrã niwã: Elifaz, Esaú macʉ̃ masã maꞌmi põꞌrã Temán, Omar, Zefo, Cenaz, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam, Amalec nicãrã niwã. Na Elifaz põꞌrã Edom diꞌtapʉre wiorã nicãrã niwã. Na nipeꞌtirã Ada pãrãmerã nituriarã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú pãrãmerã Reuel põꞌrã Edom diꞌtapʉre aꞌticʉrã wiorã nicãrã niwã: Nahat, Zera, Sama, Miza nicãrã niwã. Na Basemat Esaú nʉmo pãrãmerã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaú nʉmo Aholibama põꞌrã aꞌticʉrã wiorã nicãrã niwã: Jeús, Jaalam, Coré nicãrã niwã. Aholibama Aná macõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Na nipeꞌtirã Esaú, Edom na nigʉ̃́, pãrãmerã nicãrã niwã. Na te curaricjãrã wiorã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seir põꞌrã, horeo masʉ̃ na nigʉ̃́ põꞌrã aꞌticʉrã nicãrã niwã: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer, Disán nicãrã niwã. Na horeo masã wiorã nicãrã niwã. Edom diꞌtapʉre Seir pãrãmerã nituriarã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán põꞌrã aꞌticʉrã nicãrã niwã: Hori, Hemam nicãrã niwã. Timna Lotán acabijo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal põꞌrã aꞌticʉrã nicãrã niwã: Alván, Manahat, Ebal, Sefo, Onam nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeón põꞌrã aꞌticʉrã nicãrã niwã: Aja, Aná nicãrã niwã. Anáta yucʉ marĩrõpʉre nígʉ̃, aco asibususe oꞌmabʉrose perire bocacʉ niwĩ. Cʉ̃ pacʉ Zibeón yarã burroare cʉ̃ coꞌtecaterore tere bocacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná niꞌcʉ̃ macʉ̃ Disón wãmetigʉre macʉ̃ticʉ niwĩ. Tojo nicã niꞌcõ numio Aholibamarẽ macõticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disón põꞌrã aꞌticʉrã nicãrã niwã: Hemdán, Esbán, Itrán, Querán nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer põꞌrã aꞌticʉrã nicãrã niwã: Bilhán, Zaaván, Acán nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disán põꞌrã aꞌticʉrã nicãrã niwã: Uz, Arán nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeo masã wiorã aꞌticʉrã nicãrã niwã: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer, Disán nicãrã niwã. Na horeo masã wiorã nicãrã niwã. Na Seir diꞌtapʉre na ye curarinʉcʉ̃ wiorã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israe curuacjãrã wiogʉ dutigʉ waro cʉoatji dʉporore Edom diꞌtapʉre wiorã dutirã aꞌtiro wãmetirã nicãrã niwã: ");
INSERT INTO tuoNT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beor macʉ̃ Edom diꞌta wiogʉ dutigʉ nicʉ niwĩ. Cʉ̃ ya macã Dinaba wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Jobab, Zera macʉ̃ duticʉ niwĩ. Cʉ̃ Bosra wãmetiri macãcjʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab cʉ̃ wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Husam wãmetigʉ duticʉ niwĩ. Cʉ̃ Temán wãmetirocjʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam cʉ̃ wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Hadad, Bedad macʉ̃ duticʉ niwĩ. Cʉ̃ madianita masãrẽ Moab cja cãpũpʉ aꞌmewẽjẽ wapataꞌacʉ niwĩ. Cʉ̃ ya macã Avit wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad cʉ̃ wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Samla, Masreca macãcjʉ̃ duticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla cʉ̃ wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Saúl duticʉ niwĩ. Cʉ̃ Rehobot wãmetiri macãcjʉ̃ nicʉ niwĩ. Ti macã dia sumutopʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Baal-hanán, Acbor macʉ̃, duticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanán wẽ́rĩ́ca beꞌrore cʉ̃ dʉcayuro Hadad, Pau wãmetiri macãcjʉ̃ duticʉ niwĩ. Hadad nʉmo Mehetabel wãmetico niwõ. Co Matred macõ, Mezaab pãrãmeo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esaú põꞌrã wiorã te curarinʉcʉ̃ sʉꞌori nisetiꞌcãrã aꞌticʉrã nicãrã niwã. Niꞌcʉ̃ põꞌrã masã maꞌmi meꞌrã nʉꞌcãcaro niwʉ̃. Na nisetiꞌcaropʉ, tojo nicã na ye curari wãmerẽ werenoꞌrõsaꞌa. Timna, Alva, Jetet, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO tuoNT_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram nicãrã niwã. Esaú, apeterore Edom pisunoꞌgʉ̃ nicʉ niwĩ. Na edomita masã wiorã nicãrã niwã. Na, na nirõpʉre, na yarã masãrẽ sʉꞌori duticãrã niwã. Ãꞌrĩ Esaú, Edom masã ñecʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob peꞌe Canaá diꞌtapʉ tojacãꞌcʉ niwĩ. Ti diꞌtapʉta cʉ̃ pacʉ yoaticã nínicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Aꞌte Jacob niꞌcʉ̃ põꞌrã nisetiꞌque queti niꞌi. José diecisiete cʉ̃ꞌmarĩ cʉogʉ, cʉ̃ maꞌmisʉmʉa meꞌrã oveja coꞌtegʉ weecʉ niwĩ. Na cʉ̃ pacʉ nʉmosãnumia peꞌsu daꞌreꞌcãrã numia Bilha, Zilpa põꞌrã nicãrã niwã. José na daꞌraropʉ cʉ̃ maꞌmisʉmʉa ñaꞌarõ weeseticã ĩꞌagʉ̃, na pacʉpʉre “Ñaꞌarõ weeama”, ni weredajamʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob José peꞌere ãpẽrã cʉ̃ põꞌrã nemorõ maꞌiyʉꞌrʉnʉꞌcãcʉ niwĩ. Cʉ̃ bʉcʉ waro nirĩ cura bajuaꞌcʉ niyucã, tojo weecʉ niwĩ. Cʉ̃rẽ maꞌiyʉꞌrʉgʉ, niꞌcãrõ suꞌtiro cʉ̃ sãñatjo añurõ waro weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Cʉ̃ maꞌmisʉmʉa cʉ̃ peꞌere “Marĩ nemorõ maꞌiyʉꞌrʉnʉꞌcãmi” nírã, cʉ̃rẽ ĩꞌasĩꞌrĩti, uacãrã niwã. Cʉ̃rẽ ne cãꞌrõ añudutiticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Niꞌcã ñami José quẽꞌecʉ niwĩ. Tere cʉ̃ maꞌmisʉmʉarẽ werecʉ niwĩ. Tere tʉꞌorã, totá nemorõ cʉ̃ meꞌrã uacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aꞌtiro nicʉ niwĩ: —Yʉꞌʉ quẽꞌeꞌquere mʉsãrẽ weregʉtigʉ weeꞌe. Tere tʉꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Marĩ nipeꞌtirãpʉta cãpũpʉ niasʉ. Topʉre trigore opa dotori dʉꞌterã weeasʉ. Niꞌcã ño ya doto cjã ño wãꞌcãnʉꞌcã, diacjʉ̃ ejanʉꞌcã waꞌasʉ. Mʉsã ye ñorĩ peꞌe ya ño sumuto sʉtʉanʉꞌcãpʉ. Ya ñorẽ ẽjõpeoro weronojõ paamuꞌrĩqueꞌapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tere tʉꞌorã, cʉ̃ maꞌmisʉmʉa nicãrã niwã: —¿To pũrĩcãrẽ mʉꞌʉ ʉ̃sã wiogʉ nigʉ̃sari? ¿Mʉꞌʉ ʉ̃sãrẽ dutipegʉsari? Cʉ̃ quẽꞌeꞌquere werecã, “Tojo waꞌapʉ” nicã tʉꞌorã, nemorõ ua, cʉ̃ meꞌrã aꞌpepũrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Beꞌro apaturi José quẽꞌenemocʉ niwĩ. Te quẽꞌrãrẽ cʉ̃ maꞌmisʉmʉarẽ werecʉ niwĩ: —Tʉꞌoya tja. Yʉꞌʉ apaturi quẽꞌeasʉ. Aꞌtocaterore mujĩpũ ʉmʉcocjʉ̃, ñamicjʉ̃, once ñocõa yʉꞌʉre ẽjõpeorã paamuꞌrĩqueꞌama. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Cʉ̃ pacʉre, cʉ̃ maꞌmisʉmʉarẽ cʉ̃ quẽꞌeꞌquere werecʉ niwĩ. Tere tʉꞌogʉ, cʉ̃ pacʉ pũrĩrõ meꞌrã cʉ̃rẽ yʉꞌticʉ niwĩ: —¿Deꞌro nisĩꞌrĩrõ weeti aꞌte mʉꞌʉ quẽꞌeꞌque? ¿To pũrĩcãrẽ, yʉꞌʉ, mʉꞌʉ paco, mʉꞌʉ maꞌmisʉmʉa mʉꞌʉrẽ ẽjõpeorã paamuꞌrĩqueꞌarãsari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Cʉ̃ maꞌmisʉmʉa cʉ̃rẽ ʉoyʉꞌrʉacãrã niwã. Cʉ̃ pacʉ peꞌe tere pũrõ wãcũnʉrʉ̃cʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Niꞌcã nʉmʉ José maꞌmisʉmʉa Siquem wãmetiropʉ waꞌacãrã niwã. Na pacʉ Jacob yarã ovejare tá ecarã waꞌarã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Beꞌro Jacob cʉ̃ macʉ̃ Joseré nicʉ niwĩ: —Mʉꞌʉ masĩsaꞌa. Mʉꞌʉ maꞌmisʉmʉa Siquẽpʉ ovejare tá ecacoꞌterã weesama. Narẽ ĩꞌagʉ̃ waꞌaya. —Jaʉ, waꞌagʉti, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Cʉ̃ tojo nicã tʉꞌogʉ, Jacob nicʉ niwĩ: —Añuꞌu. ¿Mʉꞌʉ maꞌmisʉmʉa, tojo nicã oveja, ¿deꞌronojõ nisetiti? Narẽ ĩꞌagʉ̃ waꞌaya. Ĩꞌatoja, yʉꞌʉre quetiweregʉ tojatia, nicʉ niwĩ. Jacob Joseré oꞌógʉ, Hebrṍ wãmetiro ti paꞌtiro nirṍ meꞌrã oꞌócʉ niwĩ. José Siquẽpʉ etagʉ, ");
INSERT INTO tuoNT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","cãpũpʉ wisia waꞌacʉ niwĩ. Tojo weegʉ niꞌcʉ̃ masʉ̃ cʉ̃rẽ bocaeja, sẽrĩtiñaꞌcʉ niwĩ: —¿Ñeꞌenojõrẽ aꞌmacusiagʉ weeti? ");
INSERT INTO tuoNT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","José cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ maꞌmisʉmʉarẽ aꞌmacusiagʉ weeꞌe. ¿Noꞌopʉ na yarã ovejare coꞌterã weesari? ¿Mʉꞌʉ masĩweti? ");
INSERT INTO tuoNT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","—Waꞌatojama. Aꞌto níꞌcãrã “Dotán tiropʉ waꞌarã” nicã tʉꞌoasʉ, ni yʉꞌticʉ niwĩ cʉ̃rẽ. Tojo weegʉ José cʉ̃ maꞌmisʉmʉarẽ aꞌmawãꞌcã, Dotán sumutopʉ bocaejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Na peꞌe cʉ̃rẽ yoaropʉta aꞌticã ĩꞌacãrã niwã. Na tiropʉ ejase dʉporo, “Marĩ cʉ̃rẽ wẽjẽrã”, ni apoyucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","—Ĩꞌaña. Sĩꞌi quẽꞌese bʉcʉ aꞌtimimiba, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","—Teꞌa, cʉ̃rẽ wẽjẽrã. Wẽjẽtoja, copepʉ cʉ̃rẽ tuuquesãrã. “Noꞌo niꞌcʉ̃ yai nʉcʉ̃cjʉ̃ baꞌagʉ baꞌapĩ cʉ̃rẽ”, nírã marĩ pacʉre. Tojo weero cʉ̃ quẽꞌeꞌque ¿deꞌro waꞌaro waꞌarosaꞌa? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubén na tojo nisere tʉꞌogʉ, cʉ̃ acabijire yʉꞌrʉosĩꞌrĩgʉ̃, narẽ nicʉ niwĩ: —Wẽjẽticãꞌrã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Aꞌti pe aco marĩrĩ pepʉ tuuquesãña. Ne cʉ̃rẽ mejẽcã weeticãꞌña. Rubén cʉ̃ acabijire yʉꞌrʉo, cʉ̃ pacʉpʉre wiasĩꞌrĩgʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","José cʉ̃ maꞌmisʉmʉa tiropʉ etacã, na cʉ̃rẽ ñeꞌea, cʉ̃ sãñarõ suꞌtiro cʉ̃ pacʉ oꞌoꞌcarore tuweecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Tuwee, topʉ nirĩ pe aco marĩrĩ pepʉ tuuquesãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tuꞌajanʉꞌcõ, baꞌarãtirã ejanujãcãrã niwã. Na tojo weeri cura ismaelita masã duari masã pãjãrã aꞌticã ĩꞌacãrã niwã. Na Galaad wãmetiro meꞌrã, Egiptopʉ miarã, na yarã waꞌicʉrã cameyoa buꞌipʉ, ʉꞌmʉtise pejere, tojo nicã waꞌrese bálsamo wãmetisere, mirra wãmetisere miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Narẽ ĩꞌagʉ̃, Judá cʉ̃ maꞌmisʉmʉarẽ, cʉ̃ acabijirãrẽ nicʉ niwĩ: —Marĩ cʉ̃rẽ wẽjẽ, ãpẽrãrẽ yaꞌyiorã, ñeꞌenojõ añuse bocabosari? ");
INSERT INTO tuoNT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Cʉ̃rẽ wẽjẽrõnojõ oꞌorã, sõjã duari masã peꞌere duarã. Cʉ̃ quẽꞌrã marĩ acabijita nimi. Judá cʉ̃ tojo nisere tʉꞌorã, “Jaʉ, tojota weerã́”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tojo weerã ismaelita masã apeyenojõ duari masã na tiropʉ yʉꞌrʉacã, José maꞌmisʉmʉa ti pepʉ sãñaꞌcʉre miiwĩrõ, narẽ duacãrã niwã. Cʉ̃rẽ veinte niyeru cujiri wapayecãrã niwã. Tojo weerã Joseré Egiptopʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubén na duari cura marĩꞌcʉ niyugʉ, na tiropʉ daja, ti pepʉ Joseré marĩcã ĩꞌagʉ̃, cʉ̃ bʉjawetisere ĩꞌogʉ̃, cʉ̃ yaro suꞌtirore tʉ̃ꞌrẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Beꞌro cʉ̃ acabijirã tiropʉ waꞌa, narẽ nicʉ niwĩ: —Marĩ acabiji marĩamiba majã. ¿Niꞌcãrõacãrẽ yʉꞌʉ deꞌro weegʉsari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Beꞌro niꞌcʉ̃ cabra wĩꞌmagʉ̃rẽ wẽjẽcãrã niwã. Wẽjẽtoja, José yaro suꞌtiro na tuweeꞌcarore mii, cʉ̃ ye dí meꞌrã tore tuuwaꞌrecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tuꞌajanʉꞌcõ, to suꞌtirore na pacʉpʉre mia, ĩꞌocãrã niwã. —Ʉ̃sã aꞌto suꞌtirore bocapʉ. Ĩꞌaña. Apetero weero mʉꞌʉ macʉ̃ yaro nírõ nibosaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob ti suꞌtirore ĩꞌamasĩgʉ̃, aꞌtiro nicʉ niwĩ: —Ʉ̃ʉ. Yʉꞌʉ macʉ̃ yarota niꞌi. Niꞌcʉ̃ yai nʉcʉ̃cjʉ̃ yʉꞌʉ macʉ̃rẽ ñeꞌe, cũꞌrĩ wẽjẽste, baꞌapĩ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tojo weegʉ Jacob cʉ̃ bʉjawetisere ĩꞌogʉ̃, cʉ̃ suꞌtirore tʉ̃ꞌrẽ, na weewʉaronojõpʉma suꞌti wãquĩsenojõrẽ sãñacʉ niwĩ. Cʉ̃ macʉ̃ wẽrĩꞌquere yoacã uti, dʉjasewãꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nipeꞌtirã cʉ̃ põꞌrã ʉmʉa, numia cʉ̃rẽ “Tocãꞌrõta bʉjaweti, utiya”, nicãrã nimiwã. Cʉ̃ peꞌe na “Wãcũtutuaya”, nimicã, ne ʉaticʉ niwĩ. Siape meꞌrã nemorõ utinemosãjãcʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Téé wẽrĩgʉ̃pʉ bʉjawetiduꞌugʉti, nicʉ niwĩ. Tojo weegʉ Jacob cʉ̃ macʉ̃ José bajuticã ĩꞌagʉ̃, utinuꞌcũcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ismaelita masã Egiptopʉre etarã, Joseré Potifar wãmetigʉre duaturiacãrã niwã. Cʉ̃ Egiptocjãrã wiogʉ faraṍrẽ daꞌratamugʉ̃ nicʉ niwĩ. Tojo nicã faraṍrẽ coꞌterã surara wiogʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Joseré na duáca beꞌro Judá cʉ̃ maꞌmisʉmʉa, cʉ̃ acabijirãrẽ cõꞌawijacʉ niwĩ. Cõꞌawija, Adulam wãmetiri macãpʉ waꞌacʉ niwĩ. Topʉ ti macãcjʉ̃ Hira wãmetigʉ ya wiꞌipʉ cãjĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Topʉ niꞌcõ numiorẽ Canaá diꞌtacjʉ̃ Súa wãmetigʉ macõrẽ ĩꞌacʉ niwĩ. Core nʉmoticʉ niwĩ. Co meꞌrã níca beꞌro co nijĩpaco ni, niꞌcʉ̃ wĩꞌmagʉ̃ põꞌrãtico niwõ. Cʉ̃rẽ Er wãme õꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Beꞌro apaturi nijĩpaco waꞌa, apĩ wĩꞌmagʉ̃rẽ põꞌrãtico niwõ. Cʉ̃rẽ Onán wãme õꞌocʉ niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na beꞌrore apĩ põꞌrãtinemoco niwõ tja. Cʉ̃rẽ Sela wãme õꞌoco niwõ. Cʉ̃ Quezib wãmetiropʉ bajuacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Beꞌropʉ Judá cʉ̃ macʉ̃ masã maꞌmi Er Tamar wãmetigore numiadaꞌrecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er cʉ̃ ñaꞌarõ weesetisere Õꞌacʉ̃ ne tʉꞌsaticʉ niwĩ. Tojo weegʉ cʉ̃ catiri ʉmʉcore ẽꞌmacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Cʉ̃ wẽ́rĩ́ca beꞌro Judá cʉ̃ macʉ̃ Onárẽ aꞌtiro nicʉ niwĩ: —Macʉ̃, marĩrẽ dutisere queoro wéégʉ, mʉꞌʉ maꞌmi nʉmo níꞌcore nʉorẽña. Tojo weegʉ mʉꞌʉ maꞌmi mijĩrẽ põꞌrãtibosaturiagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onán peꞌe “Co meꞌrã yʉꞌʉ põꞌrãticã, yʉꞌʉ põꞌrã nitibosama” ni, masĩcʉ niwĩ. Tojo weegʉ nipeꞌtisetiri co meꞌrã nimigʉ̃, nijĩpacoyoticʉ niwĩ. Tere tojo weegʉ, cʉ̃ maꞌmi põꞌrã nituriarã waꞌacã ʉasãtigʉ, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Õꞌacʉ̃ Onán cʉ̃ tojo weesere ĩꞌagʉ̃, tere tʉꞌsaticʉ niwĩ. Tojo weegʉ cʉ̃ quẽꞌrãrẽ wẽrĩcã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tojo waꞌáca beꞌro Judá cʉ̃ macʉ̃ nʉmo níꞌcore nicʉ niwĩ: —Mʉꞌʉ pacʉ ya wiꞌipʉ wapewio tojáníña. Yʉꞌʉ macʉ̃ Sela cʉ̃ bʉcʉ nicãpʉ cʉ̃rẽ marãpʉtiapa, nicʉ niwĩ. Tojo weego, Tamar co pacʉ ya wiꞌipʉ dajaco niwõ. Core tojo nimigʉ̃, Judá aꞌtiro wãcũcʉ niwĩ: “Apetero weegʉ Sela quẽꞌrã cʉ̃ maꞌmisʉmʉa weronojõ wẽrĩbosami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Yoáca beꞌro Judá nʉmo Súa macõ wẽrĩa waꞌaco niwõ. Cʉ̃ dʉjari peꞌtíca beꞌro Judá Timnat wãmetiri macãpʉ waꞌacʉ niwĩ. Ti macãpʉta cʉ̃ yarã oveja poarire seecãrã niwã. Cʉ̃ meꞌrãcjʉ̃ Hira Adulãcjʉ̃ cʉ̃rẽ baꞌpaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar, co mañecʉ̃ “Timnat macãpʉ cʉ̃ yarã oveja poarire seegʉ waꞌapʉ” nicã tʉꞌogo, aꞌtiro weeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Co wapewio sãñarĩ suꞌtirore tuweeco niwõ. Tuwee, na ĩꞌamasĩticãꞌto nígõ, niꞌcã casero meꞌrã co diapoare moꞌaco niwõ. Tuꞌajanʉꞌcõ, Enaim macã sãjãrĩ sope pʉꞌto dujico niwõ. Ti macã Timnat waꞌari maꞌa tiropʉ nicaro niwʉ̃. Tamar, “Sela bʉcʉpʉ niapʉ” nisere tʉꞌogo, tojo weeco niwõ. Sela bʉcʉpʉ nimicã, Judá core Selare numiadaꞌreticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judá core ĩꞌagʉ̃, “Ʉmʉarẽ aꞌmetãrãwapataꞌari masõ nisamo”, ni wãcũcʉ niwĩ. Co diapoare moꞌa, ĩꞌata basiotico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Cʉ̃ macʉ̃ nʉmo níꞌco nisamo, ni masĩtigʉ, maꞌapʉ níꞌcʉ co tiro ojanʉꞌcã, core aꞌtiro nicʉ niwĩ: —Yʉꞌʉ, mʉꞌʉ meꞌrã nisĩꞌrĩsaꞌa, nicʉ niwĩ. Co peꞌe “¿Ñeꞌenojõ yʉꞌʉre wapayegʉsari?” nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","—Yʉꞌʉ ecarã cʉorãrẽ niꞌcʉ̃ cabracãrẽ mʉꞌʉrẽ oꞌogʉti, nicʉ niwĩ. —Añuꞌu to pũrĩcãrẽ. Mʉꞌʉ cʉ̃rẽ oꞌoati dʉporo apeyenojõ cũuña yujupʉ, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","—¿Ñeꞌenojõrẽ yʉꞌʉ cũucã ʉati? ni sẽrĩtiñaꞌcʉ niwĩ. —Mʉꞌʉ wãmerẽ ñacũurõrẽ ti da bʉsari da meꞌrã, tojo nicã mʉꞌʉ tuacjʉ mʉꞌʉ cʉocjʉre cũuña, nico niwõ. Judá core tere oꞌotoja, co meꞌrã nicʉ niwĩ. Tojo wee co nijĩpaco tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Cʉ̃ meꞌrã níca beꞌro topʉ níꞌco Tamar waꞌaco niwõ. Waꞌa, co diapoa omáca caserore tuweeco niwõ. Tuꞌajanʉꞌcõ, co wapewio suꞌtiro co tuweeꞌcarore sãñaco niwõ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Beꞌro Judá cʉ̃ níꞌcaronojõ cʉ̃ meꞌrãcjʉ̃ Adulãcjʉ̃ meꞌrã cabracãrẽ oꞌócʉ niwĩ. Cʉ̃ co meꞌrã topʉ cũuꞌquere wiatõrõdutigʉ, tojo weecʉ niwĩ. Cʉ̃ meꞌrãcjʉ̃ peꞌe core ne bocaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tojo weegʉ tocjãrã masãrẽ sẽrĩtiñaꞌcʉ niwĩ: —Mʉsã ĩꞌacã sõꞌoníco Enaícjõ, mʉsã ẽjõpeori wiꞌicjõ ʉmʉarẽ aꞌmetãrãwapataꞌari masõ, ¿noꞌopʉ nisari? Na peꞌe “Aꞌtoma ne niꞌcõ conojõ marĩmo aꞌti macãma”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tere tʉꞌogʉ, Judá tiropʉ cʉ̃ majãmitojaacʉ niwĩ. Cʉ̃rẽ nicʉ niwĩ: —Ne bocatiasʉ. Tocjãrã marĩcã “Conojõ aꞌtoma ne marĩmo”, niama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judá cʉ̃rẽ yʉꞌticʉ niwĩ: —Tocjãrã marĩrẽ bujiticãꞌto, nírã, yʉꞌʉ cũuꞌque meꞌrãta tojacãꞌto. Yʉꞌʉ cabracãrẽ oꞌomiapʉ, oꞌogʉ peꞌe; mʉꞌʉ bocatiapã, nicʉ niwĩ Judá. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Iꞌtiarã mujĩpũ beꞌro ãpẽrã Judáre aꞌtiro quetiwererã etacãrã niwã: —Mʉꞌʉ macʉ̃ nʉmo ãpẽrã ʉmʉarẽ aꞌmetãrã, nijĩpacoyoja waꞌaco niamo, nicãrã niwã. Judá tere tʉꞌogʉ, “Core miiwĩrõ, ʉ̃jʉ̃acõꞌacãꞌrã waꞌaya”, ni caricũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Core miiwĩrõrĩ curare co peꞌe cʉ̃ wapaye cũuꞌquere oꞌo, co mañecʉ̃rẽ aꞌtiro queti oꞌóco niwõ: “Aꞌte noa cũuꞌque nírõ nisasaꞌa. Aꞌte wiogʉta yʉꞌʉre nijĩpacoyowĩ. Ĩꞌarẽ mʉꞌʉ. ¿Noa yaro aꞌto wãme ñacũurõ, aꞌti da meꞌrã, tojo nicã aꞌtigʉ tuacjʉ niti?” ");
INSERT INTO tuoNT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá cʉ̃ yere ĩꞌamasĩgʉ̃, aꞌtiro nicʉ niwĩ: —Co peꞌe yʉꞌʉ yʉꞌrʉoro añurõ weeapõ. Yʉꞌʉ peꞌe, yʉꞌʉ macʉ̃ Sela meꞌrã numiadaꞌretigʉ, ñaꞌarõ weepã, nicʉ niwĩ. Tojo weegʉ Judá core ne apaturi aꞌmetãrãnemoticʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar co wĩꞌmagʉ̃ wʉari nʉmʉ ejacã, pʉarã sʉꞌrʉaꞌcãrã bajuacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na bajuari curare niꞌcʉ̃ omocã sĩowĩrõcʉ niwĩ. Tojo weego põꞌrãtirãrẽ coꞌteri masõ niꞌcã da sõꞌarĩ da meꞌrã, omocãpʉ dʉꞌteõꞌoco niwõ. Aꞌtiro nico niwõ: “Ãꞌrĩ bajuamʉꞌtãmi”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Co tojo nirĩ curata cʉ̃ omocãrẽ wejequesõrõcʉ niwĩ. Cʉ̃ tojo weecãta, cʉ̃ acabiji peꞌe bajuamʉꞌtãcʉ niwĩ. Tojo weego põꞌrãtirãrẽ coꞌtego cʉ̃rẽ aꞌtiro nico niwõ: “¿Deꞌro weegʉ mʉꞌʉ maꞌmi peꞌere bajuamʉꞌtãcã weetiati?” Tojo weerã cʉ̃rẽ Fares wãmeyecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Beꞌro apĩ omocãpʉ sõꞌarĩ da dʉꞌteõꞌoꞌcʉ peꞌe bajuacʉ niwĩ. Cʉ̃rẽ Zara wãme õꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","José Egiptopʉ mianoꞌcʉ niwĩ. Cʉ̃rẽ topʉ miáca beꞌro cʉ̃rẽ miaꞌcãrã ismaelita masã Potifar wãmetigʉre duaturiacãrã niwã. Cʉ̃ Egiptocjʉ̃ wiogʉ faraṍrẽ daꞌratamugʉ̃, tojo nicã cʉ̃rẽ coꞌterã surara wiogʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Õꞌacʉ̃ José meꞌrã ni, cʉ̃rẽ weetamucʉ niwĩ. Tojo weegʉ cʉ̃ wiogʉ Potifar, Egiptocjʉ̃ ya wiꞌipʉ nirĩ cura nipeꞌtise cʉ̃rẽ añurõ diaꞌcʉ̃ waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifata Õꞌacʉ̃ Joseré weetamusere, tojo nicã cʉ̃rẽ añurõ waꞌasere ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tojo weegʉ Joseré añurõ wãcũcʉ niwĩ. Tojo wãcũgʉ̃ cʉ̃rẽ, cʉ̃ ya wiꞌi wiogʉ, cʉ̃rẽ weetamuacjʉ warore sõrõcʉ niwĩ. Nipeꞌtise cʉ̃ yere sʉꞌori ĩꞌanʉrʉ̃dutigʉ sõrõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Cʉ̃rẽ wiogʉ sõrõca nʉmʉ meꞌrãta Õꞌacʉ̃ Potifare añurõ waꞌacã weenuꞌcũcʉ niwĩ. Cʉ̃ ya wiꞌi cjase cʉ̃ cʉosere, tojo nicã cʉ̃ cãpũpʉ cʉosere “Añurõ waꞌato”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","José tere coꞌtegʉ niyucã, Potifar ne cãꞌrõ wãcũqueꞌtiticʉ niwĩ. Baꞌaritero ejacã diaꞌcʉ̃rẽ baꞌagʉ waꞌamʉjãcʉ niwĩ. José tutuagʉ, añurõ bajugʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Beꞌro cʉ̃ wiogʉ Potifar nʉmo cʉ̃rẽ pũrõ ĩꞌaco niwõ. Joseré tʉꞌsago, niꞌcã nʉmʉ cʉ̃rẽ, “Yʉꞌʉ meꞌrã nígʉ̃ aꞌtia”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","José co tojo nisere tʉꞌsatigʉ, core aꞌtiro nicʉ niwĩ: —Ĩꞌaña. Yʉꞌʉ wiogʉ mʉꞌʉ marãpʉ, nipeꞌtise mʉsã cʉosere yʉꞌʉre ĩꞌanʉrʉ̃dutigʉ cũuami. Yʉꞌʉ aꞌtopʉ nirĩ curare cʉ̃ ne apeyenojõ wãcũqueꞌtitimi. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Aꞌti wiꞌipʉre ne apĩ yʉꞌʉ nemorõ nigʉ̃́ marĩmi. Yʉꞌʉ wiogʉ yʉꞌʉre, yʉꞌʉ sẽrĩsere oꞌoticã weetimi. Noꞌo nipeꞌtisere oꞌomi. Mʉꞌʉ pũrĩcãrẽ basioweꞌe. Mʉꞌʉ yʉꞌʉ wiogʉ nʉmo niꞌi. Tojo weegʉ yʉꞌʉ to cãꞌrõjo ñaꞌarõ weemasĩtisaꞌa. Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãmasĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Co cʉ̃rẽ nipeꞌtise nʉmʉrĩ “Baꞌpati, yʉꞌʉ meꞌrã nígʉ̃ aꞌtia”, nimicã, ne waꞌaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Niꞌcã nʉmʉ José cʉ̃ wiogʉ ya wiꞌipʉ cʉ̃ daꞌrasenojõrẽ weegʉ waꞌacʉ niwĩ. Titare ãpẽrã ti wiꞌipʉ daꞌracoꞌterã topʉ marĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifar nʉmo cʉ̃ yaro suꞌtiro buꞌicjãrõrẽ tʉ̃awee, “Yʉꞌʉ meꞌrã nígʉ̃ aꞌtia”, nico niwõ. José peꞌe suꞌtiro buꞌicjãrõ moogʉ̃ ti wiꞌipʉ níꞌcʉ omawijaacʉ niwĩ. Co peꞌe cʉ̃ yaro suꞌtiro meꞌrã tojanʉꞌcãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Cʉ̃ buꞌicjãrõrẽ topʉ cõꞌa omawijaacã ĩꞌagõ, ");
INSERT INTO tuoNT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","to daꞌracoꞌterãrẽ pijio, aꞌtiro nico niwõ: —Ĩꞌaña. Yʉꞌʉ marãpʉ hebreo masʉ̃ cʉ̃ miitiꞌcʉ marĩrẽ ñaꞌarõ bujicãꞌmi. Cʉ̃ yʉꞌʉ meꞌrã nisĩꞌrĩgʉ̃, aꞌti wiꞌipʉre sãjãticʉ niami. Yʉꞌʉ peꞌe ʉpʉtʉ caricũapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Yʉꞌʉ tutuaro põtẽorõ caricũcã tʉꞌogʉ, cʉ̃ yaro suꞌtiro buꞌicjãrõrẽ cõꞌa, omawijaami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Co marãpʉ wiꞌipʉ dajari cura to suꞌtirore cʉoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Cʉ̃rẽ mejãrõta wereco niwõ tja: —Hebreo masʉ̃ mʉꞌʉ daꞌracoꞌtegʉ miitiꞌcʉ, ya tucũpʉ sãjãa, yʉꞌʉre ñaꞌarõ weesĩꞌrĩgʉ̃ weeami. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yʉꞌʉ tutuaro põtẽorõ caricũcã, cʉ̃ yaro suꞌtiro buꞌicjãrõ aꞌto doquecũ, omawijaa waꞌami. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar cʉ̃ nʉmo “Mʉꞌʉrẽ daꞌracoꞌtegʉ tojo weeami”, nicã tʉꞌogʉ, uayʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tojo weegʉ Joseré ñeꞌeduti, buꞌiri daꞌreri wiꞌipʉ sõrõduticʉ niwĩ. Ti wiꞌipʉta buꞌiriwiꞌia wiogʉ faraṍrẽ yʉꞌrʉnʉꞌcãꞌcãrã dujicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tojo weemicã, Õꞌacʉ̃ peꞌe cʉ̃ maꞌisere ĩꞌogʉ̃, José meꞌrã ninuꞌcũcʉ niwĩ. Cʉ̃rẽ weetamugʉ̃, topʉ buꞌiri wiꞌi wiogʉre añurõ wãcũcã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tojo weegʉ José topʉ nipeꞌtirã buꞌiri cʉorãrẽ ĩꞌanʉrʉ̃, narẽ coꞌtegʉ tojacʉ niwĩ. Tojo nicã, nipeꞌtise ti wiꞌipʉ weesere sʉꞌori duticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Õꞌacʉ̃ José meꞌrã nígʉ̃, nipeꞌtise añurõ diaꞌcʉ̃ waꞌacã weecʉ niwĩ. Tojo weegʉ surara topʉ coꞌterã wiogʉ cʉ̃ Joseré cũuꞌquere wãcũqueꞌtiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tojo waꞌáca beꞌro Egiptocjʉ̃ wiogʉre ʉꞌsedʉcaco vino tĩacoꞌterã wiogʉ, tojo nicã apĩ pã́ weerã́ wiogʉ na faraṍrẽ tʉꞌsaticã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraṍ narẽ, ʉꞌsedʉcacore tĩacoꞌterã wiogʉ, tojo nicã pã́ weerã́ wiogʉ meꞌrã uayʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Tojo weegʉ cʉ̃rẽ coꞌterã surara wiogʉ ya wiꞌipʉ narẽ buꞌiri daꞌredutigʉ oꞌócʉ niwĩ. Topʉta José quẽꞌrã buꞌiri daꞌrenoꞌcʉ dujicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ti wiꞌipʉ coꞌterã wiogʉ Joseré “Ãꞌrãrẽ coꞌteya”, nicʉ niwĩ. Na topʉre yoacã buꞌiri dujicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Niꞌcã ñami ʉꞌsedʉcacore tĩacoꞌtegʉ, pã́rẽ weecoꞌtegʉ nanʉcʉ̃ mejẽcã bajuse quẽꞌecãrã niwã. Na pʉaro quẽꞌeꞌquenʉcʉ̃ mejẽcã diaꞌcʉ̃ nisĩꞌrĩrõ weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Boꞌreacã José narẽ ĩꞌawãꞌcãgʉ̃ ejagʉ, na bʉjawetirãrẽ bocaejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Narẽ aꞌtiro nicʉ niwĩ: —¿Deꞌro weerã niꞌcãcãrẽ tocãꞌrõ bʉjawetirã waro niti? ");
INSERT INTO tuoNT_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Na yʉꞌticãrã niwã: —Ʉ̃sã pʉarã mejẽcã bajuse quẽꞌeasʉ. Aꞌtopʉre ne niꞌcʉ̃pʉta ʉ̃sã quẽꞌeꞌquere “Tojo nisĩꞌrĩrõ weeapã” nigʉ̃nojõrẽ bocatisaꞌa, nicãrã niwã. Na tojo nicã tʉꞌogʉ, José aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ niꞌcʉ̃ta aꞌtenojõrẽ weremasĩsami. Yʉꞌʉre wereya mʉsã quẽꞌeꞌquere, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tojo weegʉ ʉꞌsedʉcacore tĩacoꞌtegʉ cʉ̃ quẽꞌeꞌquere Joseré aꞌtiro werecʉ niwĩ: —Quẽꞌerõpʉre niꞌcã da ʉꞌsedare yʉꞌʉ diacjʉ̃ peꞌe ĩꞌasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ti da iꞌtia dʉpʉ cʉoapʉ. Te dʉpʉri pĩꞌrĩ oꞌoritia waꞌapʉ. Te tõꞌorĩ ʉꞌse bʉcʉamajãmʉjãpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Topʉre faraṍ sĩꞌrĩrĩ pare cʉoasʉ. Ʉꞌse tõꞌorĩrẽ míí, ti papʉ bipesãsʉ. Tuꞌajanʉꞌcõ, ti pare faraṍpʉre oꞌoasʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","José cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ quẽꞌeꞌque aꞌtiro nisĩꞌrĩrõ weeꞌe. Te iꞌtia dʉpʉ, iꞌtia nʉmʉ nisĩꞌrĩrõ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Iꞌtia nʉmʉ beꞌro faraṍ mʉꞌʉrẽ besegʉsami. Besetoja, mʉꞌʉrẽ acobojo, mʉꞌʉ daꞌraꞌquere daꞌradutigʉsami tja. Todʉporo mʉꞌʉ weeꞌcaronojõta faraṍrẽ ʉꞌsedʉcacore tĩacoꞌtegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mʉꞌʉrẽ aꞌtiro waꞌacã, yʉꞌʉre wãcũapa. Yʉꞌʉ aꞌto buꞌiri daꞌreri wiꞌipʉ nigʉ̃rẽ miiwĩrõdutigʉ, faraṍrẽ ucũbosaya. Sajatiro yʉꞌʉre wãcũcureapa. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yʉꞌʉre hebreo masã ya diꞌtapʉ tutuaro meꞌrã ñeꞌe, miitiwã. Ñaꞌarõ weetimigʉ̃, mejõ waro buꞌiri daꞌreri wiꞌipʉ dujisaꞌa, nicʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pã́ weeri masã wiogʉ José cʉ̃ queoro weremeꞌrĩcã ĩꞌagʉ̃, cʉ̃ quẽꞌrã aꞌtiro nicʉ niwĩ: —Yʉꞌʉa, quẽꞌerõpʉre iꞌtia bati pã́ butisere tuupeoasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Buꞌipʉ pesamʉꞌtãrĩ bati faraṍ yere peje pã́ mejẽcã bajuse iꞌpitisenojõ posetiapʉ. Tojo nimicã, mirĩcʉ̃a peꞌe yʉꞌʉ dʉpoa buꞌiacã pesari bati peꞌere baꞌarã dijatiama. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tere tʉꞌogʉ, José cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ quẽꞌeꞌque aꞌtiro nisĩꞌrĩrõ weeꞌe. Te iꞌtia bati iꞌtia nʉmʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Iꞌtia nʉmʉ beꞌro faraṍ mʉꞌʉrẽ niꞌcãgʉ̃ yucʉgʉpʉ dʉꞌteyoodutigʉsami. Mʉꞌʉ wẽ́rĩ́ca beꞌro mirĩcʉ̃a mʉꞌʉ ye diꞌire baꞌarãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iꞌtia nʉmʉ beꞌro José aꞌtere wéréca beꞌro faraṍ cʉ̃ bajuáca nʉmʉ bosenʉmʉjo weecʉ niwĩ. Nipeꞌtirã cʉ̃rẽ daꞌratamurã meꞌrã tojo weecʉ niwĩ. Nipeꞌtirã cʉ̃ pijioꞌcãrã ĩꞌorõ waꞌtero faraṍ buꞌiri daꞌreri wiꞌipʉ nirã́ ʉꞌsedʉcaco vino tĩacoꞌterã wiogʉre, pã́ weerã́ wiogʉre pijiwĩrõduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ʉꞌsedʉcaco vino tĩacoꞌteꞌcʉma mejãrõta cʉ̃rẽ daꞌrase cũucʉ niwĩ. Cʉ̃ todʉporo weeꞌcaronojõta faraṍrẽ ʉꞌsedʉcaco vino tĩagʉ̃ sãjãacʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pã́ weerã́ wiogʉ peꞌema yucʉgʉpʉ dʉꞌteyooduticʉ niwĩ. José cʉ̃rẽ níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tojo waꞌamicã, ʉꞌsedʉcaco vino tĩacoꞌtegʉ Joseré ne wãcũticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","José na pʉarã quẽꞌeꞌquere wéréca beꞌro pʉa cʉ̃ꞌma yʉꞌrʉcaro niwʉ̃. Niꞌcã nʉmʉ faraṍ aꞌtiro quẽꞌecʉ niwĩ: Dia Nilo wãmetiri maa sumutopʉ nuꞌcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Cʉ̃ tojo weeri cura ti maapʉre siete wecʉa añurã, diꞌitirã wijapaꞌacãrã niwã. Ti maa sumutopʉ aco tiropʉ táre baꞌanuꞌcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Beꞌro ti maapʉta tja ãpẽrã siete wecʉa ñaꞌarã mejãrã, diꞌi marĩrã wijapaꞌacãrã niwã. Ãpẽrã ʉꞌmʉtãwijaꞌcãrã tiro nʉꞌcãejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ãꞌrã wecʉa ñaꞌarã mejãrã, diꞌi marĩrã ãpẽrã añurã siete wecʉa pacarã diꞌitirã peꞌere baꞌapeꞌocãrã niwã. Tere quẽꞌegʉ̃ta, faraṍ wãꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Beꞌro cãrĩa waꞌacʉ niwĩ tja. Apeye quẽꞌenemocʉ niwĩ. Cʉ̃ ĩꞌacã, siete trigo põꞌrãrĩ añubutiase peritise niꞌcã ñopʉreta pĩꞌrĩwijacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Beꞌro tja siete ñaꞌase trigo põꞌrãrĩ mejã, ñai bopoaꞌque mejã pĩꞌrĩbajuacaro niwʉ̃. Wĩꞌrõ mujĩpũ mʉjãtiro cjase ʉpʉtʉ asibusu wẽetuuwãꞌcãtise meꞌrã tojo waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Aꞌte siete ñaꞌase bopoaꞌque põꞌrãrĩ mejã apeye siete añuse trigo peritise põꞌrãrĩrẽ baꞌapeꞌocãꞌcaro niwʉ̃. Tojo waꞌacã, faraṍ wãꞌcã, “Quẽꞌese niapã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ape nʉmʉ ñamiñaꞌcũrõ wãcũqueꞌtiyʉꞌrʉacʉ niwĩ. Tojo weegʉ nipeꞌtirã níbocari masãrẽ, tʉꞌomasĩrĩ masã Egiptopʉ nirãrẽ pijio, cʉ̃ quẽꞌeꞌquere werecʉ niwĩ. Ne niꞌcʉ̃ peꞌeta “Tojo nisĩꞌrĩrõ weeꞌe” ni, weremasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na weremasĩticã ĩꞌagʉ̃, faraṍrẽ ʉꞌsedʉcaco vino tĩacoꞌtegʉ aꞌtiro nicʉ niwĩ: —Niꞌcãrõacãpʉta yʉꞌʉ queoro weetiꞌquere wãcũsaꞌa majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wiogʉ, ti nʉmʉpʉ mʉꞌʉ pã́ weeri masã wiogʉ meꞌrã, tojo nicã yʉꞌʉ meꞌrã uácaterore, ʉ̃sã pʉarãpʉreta surara wiogʉ ya wiꞌipʉ ʉ̃sãrẽ buꞌiri daꞌregʉ sõrõwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Niꞌcã ñami pã́ weeri masã wiogʉ quẽꞌecʉ niwĩ. Yʉꞌʉ quẽꞌrã mejẽcã bajuse quẽꞌewʉ̃. Ʉ̃sã quẽꞌeꞌquenʉcʉ̃ mejẽcã diaꞌcʉ̃ nisĩꞌrĩrõ weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Titare niꞌcʉ̃ hebreo masʉ̃ maꞌmʉacã ʉ̃sã meꞌrã niwĩ. Cʉ̃ mʉꞌʉrẽ coꞌterã surara wiogʉre daꞌracoꞌtegʉ niwĩ. Ʉ̃sã quẽꞌeꞌquere cʉ̃rẽ werewʉ. Cʉ̃ peꞌe ʉ̃sãrẽ “Tojo nisĩꞌrĩrõ weeapã”, ni werewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Te cʉ̃ níꞌcaronojõta queoro waꞌawʉ. Yʉꞌʉ apaturi yʉꞌʉ daꞌrase cʉoꞌquere daꞌrawʉ tja. Apĩ dʉꞌteyoo wẽjẽnoꞌwĩ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tere tʉꞌogʉ, faraṍ “Joseré pijigʉ waꞌaya”, nicʉ niwĩ. Tojo weerã maata cʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ níꞌcʉre pijiwijaacãrã niwã. José peꞌe ʉseca poarire wʉjawee, suꞌtirore dʉcayu, faraṍ tiropʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Topʉ ejacã, faraṍ cʉ̃rẽ nicʉ niwĩ: —Yʉꞌʉ quẽꞌeꞌquere ne niꞌcʉ̃nojõ “Tojo nisĩꞌrĩrõ weeꞌe” ni, weremasĩgʉ̃rẽ bocatiasʉ. Mʉꞌʉrẽ “Cʉ̃ peꞌe quẽꞌesere weremasĩapʉ” nisere tʉꞌoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","José faraṍrẽ yʉꞌticʉ niwĩ: —Aꞌtere yʉꞌʉ mejẽta weremasĩsaꞌa. Wiogʉ, aꞌtere Õꞌacʉ̃ peꞌe mʉꞌʉrẽ añurõ waꞌadutigʉ, mʉꞌʉ quẽꞌeꞌquere “Tojo nisĩꞌrĩrõ weeꞌe” ni weregʉsami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraṍ Joseré “Aꞌtiro quẽꞌeasʉ”, nicʉ niwĩ: —Dia Nilo sumutopʉ nuꞌcũasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ti maapʉre siete wecʉa añurã pacarã, diꞌitirã wijapaꞌama. Na ti maa sumutopʉ tá nirõpʉ baꞌanuꞌcũama. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na beꞌro tja siete wecʉa ñaꞌarã mejãrã, diꞌi marĩrã wijapaꞌama. Ne niꞌcãti tojo bajurã wecʉa aꞌto Egiptopʉre ĩꞌatigʉ nicãti. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ãꞌrã wecʉa ñaꞌarã mejãrã, diꞌi marĩrã siete añurã, pacarã diꞌitirã peꞌere baꞌacãꞌma. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Na baꞌaꞌcãrã nimirã, “Na baꞌapã”, nita basiotiama. Mejãrõta ñaꞌarã mejãrã, diꞌi marĩrã nicãꞌma. Tere quẽꞌegʉ̃, yʉꞌʉ wãꞌcãpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Beꞌro apaturi apeye quẽꞌenemoapʉ tja. Siete trigo põꞌrãrĩ añubutiase peritise niꞌcã ñopʉreta pĩꞌrĩwijatiapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Te beꞌro tja siete põꞌrãrĩ trigo ñaꞌase, te peri marĩse põꞌrãrĩ ñai bopoaꞌque mejã pĩꞌrĩwijatiapʉ. Wĩꞌrõ mujĩpũ mʉjãtiro cjase ʉpʉtʉ asibusu wẽetuuwãꞌcãtise meꞌrã tojo waꞌapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Aꞌte siete põꞌrãrĩ ñaꞌase mejã, apeye añuse trigo peritise põꞌrãrĩ peꞌere baꞌapeꞌocãꞌpʉ. Yʉꞌʉ aꞌtere níbocari masãrẽ weremiapʉ. Ne niꞌcʉ̃nojõ peꞌeta “Tojo nisĩꞌrĩrõ weeꞌe” ni weremasĩtiama, nicʉ niwĩ faraṍ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tere tʉꞌogʉ, José faraṍrẽ yʉꞌticʉ niwĩ: —Wiogʉ, pʉaropʉta mʉꞌʉ quẽꞌeꞌque niꞌcãrõnojõ nisĩꞌrĩrõ weeꞌe. Õꞌacʉ̃ cʉ̃ weeatjere mʉꞌʉrẽ wereyugʉ weeapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Aꞌtiro niꞌi: Siete wecʉa añurã siete cʉ̃ꞌmarĩ niꞌi. Siete trigo põꞌrãrĩ añuse põꞌrãrĩ quẽꞌrã siete cʉ̃ꞌmarĩ niꞌi. Te pʉaropʉta niꞌcãrõnojõ quẽꞌese niapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Siete wecʉa ñaꞌarã, diꞌi marĩrã mejãrã, na añurã beꞌro bajuaꞌcãrã quẽꞌrã siete cʉ̃ꞌmarĩta niꞌi. Tojo nicã, siete trigo põꞌrãrĩ ñaꞌase bopoaꞌque mejã quẽꞌrã, mejãrõta niꞌi. Siete cʉ̃ꞌmarĩ baꞌase marĩrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Yʉꞌʉ mʉꞌʉrẽ níꞌcaronojõta niꞌi. Wiogʉ, Õꞌacʉ̃ cʉ̃ weeatjere mʉꞌʉrẽ wereyugʉ weeapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siete cʉ̃ꞌmarĩ nipeꞌtiro Egiptopʉre baꞌase niyʉꞌrʉarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Beꞌro siete cʉ̃ꞌmarĩta tja ne baꞌase marĩrõsaꞌa. Tojo weero te cʉ̃ꞌmarĩ peje baꞌase nimiꞌque acobojonoꞌrõsaꞌa. Nipeꞌtiro Egiptopʉre baꞌase peꞌtibutiarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Baꞌase marĩbutiarosaꞌa. Tojo weerã “Siete cʉ̃ꞌmarĩ Egiptopʉre baꞌase peje nimiwʉ̃” ni, ne niꞌcʉ̃nojõpʉta wãcũsome. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Wiogʉ, mʉꞌʉ aꞌtere pʉatipʉta mejãrõta quẽꞌeapã. Õꞌacʉ̃ “Aꞌtere tojo weegʉti”, nitojapĩ. Tojo weegʉ cʉ̃ níꞌcaronojõta aꞌtere maata weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","»Tojo weegʉ, wiogʉ, aꞌtiro weecã añubosaꞌa. Niꞌcʉ̃ masʉ̃ tʉꞌomasĩse cʉogʉ “Aꞌtiro weeroʉaꞌa” nigʉ̃nojõrẽ aꞌmaña. Cʉ̃ aꞌti diꞌta Egiptopʉre sʉꞌori ĩꞌanʉrʉ̃gʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Wiogʉ, mʉꞌʉrẽ aꞌtiroʉaꞌa. Ãpẽrã wiorã mʉꞌʉ doca nirãrẽ sõrõrõʉaꞌa. Na nipeꞌtiro Egipto diꞌtapʉ waꞌato. Waꞌa, trigo perire niꞌcãmocʉse piꞌseri seeneocũu, niꞌcã piꞌire beꞌropʉ na baꞌatjere nʉrõdutirã oꞌoato. Te siete cʉ̃ꞌmarĩ baꞌase peje nirĩ curare tojo seeneoato. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Te baꞌase peje nise cʉ̃ꞌmarĩrẽ mʉꞌʉ wiogʉ dutiro meꞌrã na neoato. Te perire neo, macãrĩ na baꞌase nʉrõse wiꞌseripʉ na beꞌropʉ baꞌatjere nʉrõato. Nʉrõ, surara tere ĩꞌanʉrʉ̃ato. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na tojo weecã, siete cʉ̃ꞌmarĩ baꞌase marĩatje cʉ̃ꞌmarĩrẽ na nʉrõꞌque nirõsaꞌa. Aꞌti diꞌta Egiptopʉre baꞌase peꞌtisome. Tojo weerã masã ne ʉjʉaboa wẽrĩsome, nicʉ niwĩ José faraṍrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tere tʉꞌorã, faraṍ, tojo nicã cʉ̃rẽ daꞌratamurã “Cʉ̃ ‘tojo weeya’ nise añu niꞌi”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tojo weegʉ faraṍ aꞌtiro nicʉ niwĩ: —¿Marĩ apĩ ãꞌrĩ weronojõ nigʉ̃rẽ bocarãsariba tja? Cʉ̃ Õꞌacʉ̃ wãcũsere cʉomi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Beꞌro Joseré faraṍ nicʉ niwĩ: —Mʉꞌʉ weronojõ apĩ añurõ tʉꞌomasĩgʉ̃, masĩse cʉogʉ marĩmi. Õꞌacʉ̃ mʉꞌʉrẽ aꞌte masĩsere oꞌoapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ya wiꞌire dutigʉsaꞌa. Nipeꞌtirã yarã masã mʉꞌʉ dutisere yʉꞌtirãsama. Yʉꞌʉ niꞌcʉ̃ta mʉꞌʉ nemorõ nigʉ̃saꞌa. Wiogʉ waro nitjĩagʉ̃, tojo nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yʉꞌʉ mʉꞌʉrẽ nipeꞌtiro Egipto wiogʉ sõrõgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tojo nígʉ̃ta, faraṍ cʉ̃ omopica tuusãarĩ beꞌtore tuwee, Joseré sãacʉ niwĩ. Ti beꞌto cʉ̃ wiogʉ wãme cʉori beꞌto nicaro niwʉ̃. Beꞌro ãpẽrãrẽ cʉ̃rẽ añuse suꞌti, lino wãmetise meꞌrã weeꞌque suꞌtire sãaduticʉ niwĩ. Tojo nicã, niꞌcã da uru meꞌrã wééca da, bʉsari dare cʉ̃rẽ bʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tuꞌajanʉꞌcõ, tũrũpjʉ cabayua meꞌrã wejepjʉ cʉ̃ yawʉ beꞌro sirutupjʉre sãjãduticʉ niwĩ. Tiwʉ dʉporo surara masãrẽ “Ejaqueꞌaya”, ni caricũduticʉ niwĩ. Tojo wee Joseré wiogʉ sõrõcʉ niwĩ. Cʉ̃ nipeꞌtiro Egipto diꞌtapʉre dutigʉ sãjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Beꞌro faraṍ Joseré nicʉ niwĩ: —Yʉꞌʉ faraṍ, wiogʉ waro niꞌi. Tojo nimicã, masã mʉꞌʉ dutiro marĩcã, ne apeyenojõacã weemasĩtisama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraṍ Joseré cʉ̃ wãmerẽ dʉcayucʉ niwĩ. Egiptocjãrã wãme õꞌogʉ̃, Zafnat-panea wãmeyecʉ niwĩ. Cʉ̃ Joseré Asenat wãmetigore numiadaꞌrecʉ niwĩ. Co, Potifera wãmetigʉ paꞌi, On wãmetiri macãcjʉ̃ macõ nico niwõ. Tojo wee José Egipto wiogʉ sãjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José faraṍ meꞌrã daꞌranʉꞌcãgʉ̃, treinta cʉ̃ꞌmarĩ cʉocʉ niwĩ. Beꞌro José faraṍ ĩꞌorõpʉ wija, nipeꞌtiro Egipto diꞌtapʉre ĩꞌacusianʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Te siete cʉ̃ꞌmarĩrẽ Egipto diꞌtapʉre, to cjase otese añubutiaro pĩꞌrĩ dʉcaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tojo weegʉ José nipeꞌtiropʉ trigore seeneocʉ niwĩ. Cʉ̃ cãpũpʉ seeneoꞌquere nipeꞌtise pacase macãrĩpʉ nʉrõcũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Baꞌase peje waro niyʉꞌrʉmajãcaro niwʉ̃. Tojo weegʉ tere nucũpori pajiri maa cjase weronojõ seemesãcũucʉ niwĩ. “Ticʉse niꞌi”, ni queota basioticaro niwʉ̃. Tojo weegʉ baꞌpaqueonemoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Siete cʉ̃ꞌmarĩ ʉjʉaboase waꞌati dʉporore José cʉ̃ nʉmo Asenat meꞌrã pʉarã põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Masã maꞌmirẽ Manasés wãme õꞌocʉ niwĩ. “Õꞌacʉ̃ yʉꞌʉre nipeꞌtise yʉꞌʉ piꞌetisere acobojocã weemi. Tojo nicã nipeꞌtirã yʉꞌʉ acawererãrẽ acobojocã weemi” nígʉ̃, tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Beꞌrocjʉ̃rẽ Efraĩ́ wãme õꞌocʉ niwĩ. “Õꞌacʉ̃ Egipto yʉꞌʉ piꞌetiꞌcaropʉ põꞌrãticã weeami” nígʉ̃, tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Titare Egiptopʉre te siete cʉ̃ꞌmarĩ peje baꞌase nimiꞌque peꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","José níꞌcaronojõta siete cʉ̃ꞌmarĩ baꞌase marĩatje cʉ̃ꞌmarĩ nʉꞌcãrõtiro weecaro niwʉ̃. Nipeꞌtise diꞌtapʉre baꞌase marĩcaro niwʉ̃. Egipto diꞌta peꞌema baꞌase nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Beꞌro Egiptocjãrã quẽꞌrãrẽ baꞌase peꞌtia waꞌacaro niwʉ̃. Tojo weerã faraṍ tiropʉ baꞌase sẽrĩrã waꞌacãrã niwã. Tojo weegʉ faraṍ nipeꞌtirã Egipto diꞌtacjãrãrẽ aꞌtiro nicʉ niwĩ: “José tiro waꞌaya. Cʉ̃ mʉsãrẽ dutironojõta weeya.” ");
INSERT INTO tuoNT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nipeꞌtiro Egiptopʉ ʉjʉaboase seꞌsa waꞌacã, José cʉ̃ trigo nʉrõcũuꞌque wiꞌserire pãoduti, tere duacʉ niwĩ. Siapeꞌe meꞌrã nemorõ baꞌase marĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Nipeꞌtiropʉ baꞌase ne marĩcaro niwʉ̃. Tojo weerã nipeꞌtise diꞌtacjãrã Egiptopʉ José tiro baꞌase duurã aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob, Egiptopʉ “Trigo niaporo” nisere tʉꞌocʉ niwĩ. Tojo weegʉ cʉ̃ põꞌrãrẽ nicʉ niwĩ: —¿Deꞌro weerã mʉsã aꞌmerĩ ĩꞌacũñabajaqueꞌati? ");
INSERT INTO tuoNT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ãpẽrã yʉꞌʉre “Egiptopʉre trigo niaporo”, ni wereama. Marĩ ʉjʉaboa, wẽrĩrĩ nírã, topʉ marĩ baꞌatje trigore duurã waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tojo weerã José maꞌmisʉmʉa diez Egiptopʉre trigo duurã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","José acabiji waro Benjamí peꞌema Jacob cʉ̃rẽ mejẽcã waꞌari nígʉ̃, oꞌóticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ãpẽrã Canaá diꞌtacjãrã quẽꞌrã na meꞌrã baꞌase duurã waꞌacãrã niwã. Nipeꞌtiro Canaá diꞌtapʉre baꞌase marĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José Egipto diꞌtapʉre dutigʉ nicʉ niwĩ. Cʉ̃ta nipeꞌtirocjãrã masãrẽ topʉ etarãrẽ trigo duagʉ nicʉ niwĩ. Cʉ̃ maꞌmisʉmʉa cʉ̃ tiropʉ etarã, añudutirã ejanʉꞌcã, nucũcãpʉ paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José cʉ̃ maꞌmisʉmʉarẽ maata ĩꞌamasĩcãꞌcʉ niwĩ. Masĩmigʉ̃, ĩꞌamasĩtigʉ weronojõ weecʉ niwĩ. Tojo weegʉ narẽ pũrĩrõ sẽrĩtiñaꞌcʉ niwĩ: —¿Mʉsã noꞌocjãrãpʉ aꞌtiati? —Ʉ̃sã Canaá diꞌtapʉ aꞌtiapʉ. Trigo duurã aꞌtiapʉ, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José cʉ̃ maꞌmisʉmʉarẽ ĩꞌamasĩcʉ niwĩ. Na peꞌe cʉ̃rẽ ĩꞌamasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Beꞌro dʉporopʉ cʉ̃ narẽ quẽꞌeꞌquere wãcũbocagʉ, aꞌtiro nicʉ niwĩ: —Mʉsã ĩꞌaduꞌtiri masã nisaꞌa. Aꞌti diꞌtare diapeꞌe sãjãata añuti nírã, ĩꞌarã aꞌtiapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","—Niweꞌe. Ʉ̃sã mʉꞌʉ dutise doca nirã́ trigo diaꞌcʉ̃rẽ duurã aꞌtiapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ʉ̃sã nipeꞌtirãpʉta niꞌcʉ̃ põꞌrã, diacjʉ̃ weeri masã niꞌi. Ĩꞌaduꞌtiri masã mejẽta niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","José narẽ nicʉ niwĩ: —Niweꞌe. Mʉsã aꞌti diꞌtare noꞌo peꞌe sãjãata basiosari nírã, ĩꞌaduꞌtirã aꞌtiapã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Na peꞌe yʉꞌticãrã niwã tja: —Ʉ̃sã mʉꞌʉ dutise doca nirã́ niꞌcʉ̃ põꞌrãta doce niꞌi. Ʉ̃sã Canaá diꞌtacjãrã niꞌi. Ʉ̃sã acabiji niꞌcʉ̃ta ʉ̃sã pacʉ meꞌrã tojami. Apĩ peꞌe dʉporopʉ wẽrĩa waꞌacʉ niwĩ, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tojo nisere tʉꞌogʉ, José narẽ ninemocʉ niwĩ tja: —Yʉꞌʉ níꞌcaronojõta mʉsã aꞌti diꞌtare ĩꞌaduꞌtiri masã niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mʉsãrẽ faraṍ wãme meꞌrã aꞌtiro weegʉti. Mʉsã acabiji nitʉogʉ aꞌtopʉre aꞌtiticãma, mʉsã aꞌtore wijasome. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Noꞌo niꞌcʉ̃ mʉsã waꞌteropʉ nigʉ̃́ cʉ̃rẽ miigʉ̃ waꞌato. Ãpẽrã peꞌe aꞌto buꞌiri daꞌreri wiꞌipʉ tojarã́sama. Tojo weese meꞌrã “Diacjʉ̃ta ucũapã”, ni masĩnoꞌrõsaꞌa. Miititicãma, diacjʉ̃ta faraṍ wãme meꞌrã “Ĩꞌaduꞌtiri masãta niapã”, ninoꞌrõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","José narẽ buꞌiri daꞌreri wiꞌipʉ iꞌtia nʉmʉ narẽ cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Iꞌtia nʉmʉ beꞌro José narẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃rẽ wiopesase meꞌrã ĩꞌaꞌa. Mʉsã aꞌtiro wéérã, catirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mʉsã diacjʉ̃ta “Mejẽcã weetiri masã niꞌi” nírã, niꞌcʉ̃rẽ aꞌtopʉ cũuña. Mʉsã ãpẽrãpʉa dajatojaaya. Mʉsã põꞌrã, nʉmosãnumia ʉjʉaboaticãꞌto nírã, narẽ trigore miaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mʉsã, “Ʉ̃sã mejẽcã weeri masã niweꞌe” nírã, mʉsã acabiji nitʉogʉpʉre miitiapa. Tojo weerã, mʉsã yʉꞌrʉwetirãsaꞌa, nicʉ niwĩ. —Jaʉ, tojota weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Beꞌro na basu aꞌmerĩ ucũcãrã niwã: —Diacjʉ̃ta niꞌi. Marĩ acabijire ñaꞌabutiaro weeꞌque wapa marĩrẽ tojo waꞌaꞌa. Cʉ̃ “Yʉꞌʉre pajañaꞌcureya; tojo weeticãꞌña” nimicã, tʉꞌotiwʉ. Cʉ̃ ñaꞌabutiaro yʉꞌrʉmicã, tojo ĩꞌacãꞌwʉ̃. Te buꞌiri marĩ niꞌcãrõacãrẽ piꞌetirã weeꞌe, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubén narẽ nicʉ niwĩ: —Yʉꞌʉ pũrĩcã marĩ acabijire “Ñaꞌarõ weeticãꞌña”, nimiwʉ̃. Mʉsã peꞌe yʉꞌʉre tʉꞌotiwʉ. Niꞌcãrõacãrẽ majã cʉ̃ wẽrĩꞌque wapa marĩ wapaseenoꞌrãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Na, “José marĩ ucũsere tʉꞌosami”, ni masĩticãrã niwã. José peꞌere na ucũsere apĩ peꞌe “Aꞌtiro nisĩꞌrĩrã weeama”, ni wereturiacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","José na tiropʉ níꞌcʉ apesepʉ waꞌa, uticʉ niwĩ. Beꞌro wãcũtutua, na tiropʉ ejagʉ, ucũcʉ niwĩ. Nipeꞌtirã ĩꞌorõpʉ Simeórẽ mejẽcã pijioduti, dʉꞌteduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Beꞌro cʉ̃rẽ daꞌracoꞌterãrẽ na ye ajuripʉ trigore poseyeduticʉ niwĩ. Na wapayeꞌque niyeru quẽꞌrãrẽ te ajuri poꞌpeapʉ cũuduticʉ niwĩ. Tojo nicã, baꞌase na maꞌapʉ baꞌatojaatjere oꞌoduticʉ niwĩ. José dutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Beꞌro na yarã burroa buꞌipʉ, te trigore miipeo, tore wijawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Beꞌro na cãrĩatjopʉ etarã, niꞌcʉ̃ cʉ̃ yagʉ burrore trigo ecagʉtigʉ, cʉ̃ ya ajurore pãacʉ niwĩ. Ti ajurore pãa, trigo buꞌipʉ nipeꞌtise niyeru cʉ̃ wapayeꞌquere sãñacã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tere ĩꞌagʉ̃, cʉ̃ maꞌmisʉmʉa, cʉ̃ acabijirãrẽ nicʉ niwĩ: —Ĩꞌarã aꞌtia. Aꞌti ajuropʉ ye niyeru nipeꞌticãꞌa. Cʉ̃ tojo nicã tʉꞌorã, nipeꞌtirã ʉcʉapeꞌtia waꞌacãrã niwã. Uirã, narãsãrãta, aꞌmerĩ ucũcãrã niwã: —¿Marĩrẽ Õꞌacʉ̃ deꞌronojõ weebutiamiapari? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Na Canaá diꞌtapʉ na pacʉ Jacob tiropʉ dajarã, nipeꞌtise narẽ Egiptopʉ waꞌaꞌquere werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Aꞌtiro nicãrã niwã: —Ti diꞌta wiogʉ dutigʉ pũrĩcã ʉ̃sãrẽ tutuabutiaro ucũami. Ʉ̃sãrẽ, “Mʉsã aꞌti diꞌtare ĩꞌaduꞌtirã aꞌtirã weeapã”, niami. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ʉ̃sã peꞌe cʉ̃rẽ “Ʉ̃sã diacjʉ̃ weeri masã niꞌi; ĩꞌaduꞌtiri masã mejẽta niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Niꞌcʉ̃ põꞌrã doce waro niꞌi. Niꞌcʉ̃ wẽrĩa waꞌacʉ niwĩ. Nitʉogʉpʉa Canaápʉ ʉ̃sã pacʉ meꞌrã tojami”, niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","»Tere tʉꞌogʉ, ti diꞌta dutigʉ ʉ̃sãrẽ niami: “To pũrĩcãrẽ diacjʉ̃ta nimitito nígʉ̃, aꞌtore niꞌcʉ̃ tojato. Ãpẽrãpʉa cãꞌrõ trigo mʉsã ye wiꞌsericjãrã baꞌaro ejatuaro miaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Apaturi aꞌtirã, mʉsã acabiji nitʉogʉre miitia. Mʉsã tojo weecã, yʉꞌʉ ‘Diacjʉ̃ta añurã nima’, nigʉ̃saꞌa. Mʉsã tojo weecã, apĩ aꞌto tojaꞌcʉre wiagʉsaꞌa. Beꞌro mʉsã aꞌti diꞌtapʉre ne cãꞌmotaꞌaro marĩrõ sijarãsaꞌa”, niami, nicãrã niwã na pacʉre. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na ye trigo ajurire poꞌocũurã, José maꞌmisʉmʉa na wapayeꞌque niyeru sãñapeꞌticã ĩꞌacãrã niwã. Te niyerure ĩꞌarã, ʉcʉayʉꞌrʉa waꞌacãrã niwã. Na pacʉ Jacob quẽꞌrã ʉcʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tere ĩꞌagʉ̃, Jacob cʉ̃ põꞌrãrẽ nicʉ niwĩ: —Mʉsã yʉꞌʉre põꞌrã marĩꞌcʉ weronojõ tojacã weeꞌe. José marĩ meꞌrã marĩmi. Simeó quẽꞌrã marĩmi. Niꞌcãrõacãrẽ “Benjamírẽ miarãti”, niꞌi tja. Mʉsã tojo weese yʉꞌʉre ñaꞌarõ waꞌaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tere tʉꞌogʉ, Rubén cʉ̃ pacʉre nicʉ niwĩ: —Benjamírẽ yʉꞌʉ sʉꞌori miagʉ̃ti. Mia, mʉꞌʉ tiropʉ miidaja, wiagʉti. Yʉꞌʉ wiaticãma, yʉꞌʉ põꞌrã pʉarãrẽ wẽjẽapa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jacob cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ macʉ̃ mʉsã meꞌrã ne waꞌasome. José mʉsã acabiji wẽrĩatojacʉ niwĩ. Ãꞌrĩ niꞌcʉ̃ta yʉꞌʉre dʉꞌsami majã. Cʉ̃rẽ maꞌapʉ mejẽcã ñaꞌarõ waꞌacã, yʉꞌʉ bʉcʉ mijĩ bʉjawetise meꞌrã wẽrĩgʉ̃saꞌa. Tojo waꞌacã, mʉsã buꞌiritirãsaꞌa, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Canaá na nirĩ diꞌtapʉ ʉjʉaboase nemorõ waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na Egiptopʉ trigore duurã ejaꞌque peꞌticã ĩꞌagʉ̃, Jacob cʉ̃ põꞌrãrẽ nicʉ niwĩ: —Apaturi trigo marĩ baꞌatjere cãꞌrõ duunemorã waꞌaya tja. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Cʉ̃rẽ Judá yʉꞌticʉ niwĩ: —Sõꞌonícʉ Egipto dutigʉ ʉ̃sãrẽ tʉꞌota basiorota niwĩ: “Mʉsã acabiji nitʉogʉpʉre miititicã, mʉsãrẽ ñeꞌenemosome majã”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tojo weerã mʉꞌʉ ʉ̃sã meꞌrã Benjamírẽ waꞌaduticã, trigore duurã waꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mʉꞌʉ cʉ̃rẽ oꞌóticãma, waꞌasome. Sõꞌonícʉ wiogʉ ʉ̃sãrẽ queoro niwĩ: “Mʉsã acabiji nitʉogʉpʉ miititicã, mʉsãrẽ ñeꞌenemosome”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tere tʉꞌogʉ, Jacob nicʉ niwĩ: —Mʉsã yʉꞌʉre ¿deꞌro weerã tocãꞌrõ ñaꞌarõ weeati? ¿Deꞌro weerã cʉ̃rẽ “Ʉ̃sã acabiji nitʉogʉpʉ niami”, ni wereri? ");
INSERT INTO tuoNT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Na cʉ̃rẽ yʉꞌticãrã niwã: —Ʉ̃sãrẽ, ʉ̃sã ye cjasere añurõ sẽrĩtiñaꞌnʉrʉ̃wĩ. Marĩ niꞌcʉ̃ põꞌrã nise cjasere añurõ sẽrĩtiñaꞌwĩ: “¿Mʉsã pacʉ catiati yujupʉ? ¿Apĩ mʉsã acabiji marĩati?” ni sẽrĩtiñaꞌwĩ. Ʉ̃sã cʉ̃ sẽrĩtiñaꞌse diaꞌcʉ̃rẽ yʉꞌtiwʉ. ¿Ʉ̃sã deꞌro weerã ʉ̃sã acabijire miitidutigʉsami, ni masĩbosaʉ? ");
INSERT INTO tuoNT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Beꞌro Judá cʉ̃ pacʉ Jacore nicʉ niwĩ: —Mʉꞌʉ macʉ̃ Benjamírẽ oꞌóya. Yʉꞌʉ cʉ̃rẽ ĩꞌanʉrʉ̃gʉ̃ti. Mʉꞌʉ “Jaʉ” nicã, maata waꞌabaqueꞌorãti. Tojo weerã marĩ, ʉ̃sã põꞌrã ʉjʉaboa wẽrĩsome. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yʉꞌʉ basu cʉ̃rẽ coꞌtegʉti. Cʉ̃ mʉꞌʉ macʉ̃rẽ mejẽcã waꞌacãma, aꞌtopʉ cʉ̃ dajaticã, yʉꞌʉre “Mʉꞌʉ buꞌiritiꞌi” niapa. Téé yʉꞌʉ catiro põtẽorõ tojo buꞌiritigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ʉ̃sã aꞌtopʉre tocãꞌrõ yoogotirã, pʉati Egiptopʉre waꞌamajã, majãmitojatiboapã, nicʉ niwĩ Judá. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Cʉ̃ tojo níca beꞌro na pacʉ Jacob narẽ yʉꞌticʉ niwĩ: —Mʉsã nírõnojõta ne mejẽcã weeta basiotirocoro. Tojo weerã aꞌtiro weeya. Mʉsã ye ajuripʉ apeyenojõ cʉ̃rẽ oꞌoatjere miisãaña. Aꞌti diꞌtapʉ añuse nisenojõrẽ cãꞌrõ miaña. Waꞌrese bálsamo wãmetise, nʉcʉ̃cjãrã mumia yere, ʉꞌmʉtise, baꞌase morẽsenojõrẽ miaña. Tojo nicã mirrare, nueces, almendras miaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Niyeru quẽꞌrãrẽ pʉati mʉsã todʉporopʉ miaꞌcaro nemorõ miaña. Mʉsã basuta cʉ̃rẽ mʉsã ye ajuripʉ bocaꞌquere wiaya. Apetero weegʉ wisigʉ weepĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ãꞌrĩ mʉsã acabiji meꞌrã maata Egipto dutigʉ tiropʉ waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ mʉsãrẽ weetamuato. Cʉ̃ mʉsãrẽ pajañaꞌcã weeato. Cʉ̃ tojo weecã, mʉsã maꞌmi Simeórẽ duꞌuwĩrõgʉ̃sami. Tojo nicã, ãꞌrĩ Benjamí quẽꞌrãrẽ mʉsã meꞌrã dajacã weegʉsami. Yʉꞌʉ peꞌe põꞌrã marĩgʉ̃ weronojõ tojagʉ, tojo tojacʉ̃ti, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tojo weerã Jacob põꞌrã na oꞌoatjere poseye, niyerure na todʉporo miaꞌque pʉati nemorõ, na acabiji Benjamí meꞌrã, sojaro Egiptopʉ waꞌacãrã niwã. Topʉ etarã, José tiropʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Na etacã, Benjamí na meꞌrã nicã ĩꞌagʉ̃, cʉ̃ ya wiꞌi coꞌtegʉ wiogʉre nicʉ niwĩ: —Ãꞌrãrẽ ya wiꞌipʉ miaña. Wecʉre wẽjẽ, baꞌase doꞌayuya. Dajaritero nicã yʉꞌʉ meꞌrã baꞌarãsama, nicʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ti wiꞌi dutigʉ José dutiꞌcaronojõta weecʉ niwĩ. Cʉ̃ basuta narẽ pijiwãꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Na peꞌe José ya wiꞌipʉ cʉ̃ miacã, ʉcʉayʉꞌrʉacãrã niwã. Aꞌmerĩ aꞌtiro ucũcãrã niwã: —Marĩrẽ tojo weetaꞌsagʉ weemi. Sõꞌoníꞌque niyeru marĩ ye ajuripʉ sãñaꞌque wapa nitʉꞌsaꞌa. Marĩrẽ topʉ marĩ yarã waꞌicʉrã meꞌrã ñeꞌe, daꞌracoꞌteri masã sõrõ, dutipegʉtigʉ weesami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tojo weerã na wiꞌi sope pʉꞌtopʉ ejarã, aꞌtiro weecãrã niwã. Ti wiꞌi coꞌtegʉ wiogʉ tiroacãpʉ waꞌa, ucũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Aꞌtiro nicãrã niwã: —Wiogʉ, sõꞌonícaterore ʉ̃sã aꞌtopʉta trigo duurã ejawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Titare ʉ̃sã dajatojaarã cãrĩrãtirã, ʉ̃sã yarã ecarãrẽ baꞌase ecarãtirã, ʉ̃sã ye ajurire pãawʉ̃. Te ajuripʉ ʉ̃sã niyeru wapayeꞌque sãñapeꞌticãꞌwʉ̃. Te niyerure wiarãtirã, miitiapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tojo nicã, apeye ʉ̃sã duuatje niyerure miitinemoapʉ. Niyeru ʉ̃sã ye ajuripʉ sãñaꞌquema noa sãarõ sãapã, masĩtisaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ti wiꞌi coꞌtegʉ yʉꞌticʉ niwĩ: —Wãcũtutuaya. Uiticãꞌña. Õꞌacʉ̃ mʉsã, tojo nicã mʉsã pacʉ ẽjõpeogʉ mʉsã ye ajuripʉ sãaboapĩ. Mʉsã yʉꞌʉre wapayeꞌquema yʉꞌʉ ñeꞌewʉ̃, nicʉ niwĩ. Beꞌro Simeórẽ na tiropʉ miiejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Na nipeꞌtirãpʉreta José ya wiꞌipʉ pijisãjãacʉ niwĩ. Topʉ dʉꞌpocãrĩrẽ coedutigʉ, acore oꞌocʉ niwĩ. Na yarã waꞌicʉrã quẽꞌrãrẽ ecabosacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ti wiꞌipʉ nírã, Joseré na oꞌoatjere apoyucãrã niwã. “Dajaritero nicã José aꞌtopʉ aꞌtigʉsami” nírã, tojo weecãrã niwã. “José ya wiꞌipʉ baꞌarãsaꞌa” nisere tʉꞌotojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","José wiꞌipʉ ejacã, na miaꞌquere cʉ̃rẽ oꞌocãrã niwã. Tuꞌajanʉꞌcõ, cʉ̃rẽ ẽjõpeorã, paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","José narẽ nicʉ niwĩ: —¿Añuti mʉsã? ¿Mʉsã pacʉ bʉcʉ quẽꞌrã añuati? ¿Cʉ̃ catiati yujupʉ? ");
INSERT INTO tuoNT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","—Ʉ̃sã pacʉ mʉꞌʉrẽ daꞌracoꞌtegʉ weronojõ nigʉ̃́ duti marĩami. Catiami yujupʉ, ni yʉꞌticãrã niwã. Beꞌro apaturi cʉ̃rẽ ẽjõpeose ĩꞌorã, paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Topʉ narẽ majãmiĩꞌamigʉ̃, Benjamírẽ ĩꞌacʉ niwĩ. Na niꞌcõ põꞌrãta nicãrã niwã. Tojo weegʉ aꞌtiro nicʉ niwĩ: —¿Ãꞌrĩta niti mʉsã acabiji nitʉogʉpʉ mʉsã wereꞌcʉ? Beꞌro Benjamírẽ: “Õꞌacʉ̃ mʉꞌʉrẽ añurõ weeato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José cʉ̃ acabijire ĩꞌa eꞌcatiyʉꞌrʉagʉ, utisĩꞌrĩcʉ niwĩ. Tojo wee põtẽoti, sojaro meꞌrã cʉ̃ ya tucũpʉ sãjãa, ʉpʉtʉ uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Beꞌro wãcũtutua, cʉ̃ utiduꞌuca beꞌro diapoare coe, cʉ̃ ya tucũpʉ níꞌcʉ wijaa, “Baꞌase etiya majã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Cʉ̃ tojo nicã, baꞌase etirã Joseré cʉ̃ ya mesapʉ baꞌase peocãrã niwã. Cʉ̃ maꞌmisʉmʉarẽ, cʉ̃ acabijire ape mesapʉ baꞌase peocãrã niwã. Egiptocjãrã José meꞌrã baꞌamiꞌcãrã peꞌere ape mesapʉ baꞌase peocãrã niwã. Egiptocjãrã hebreo masã meꞌrã baꞌadutinoꞌña marĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José cʉ̃ maꞌmisʉmʉarẽ dujiduticʉ niwĩ. Masã maꞌmirẽ dujimʉꞌtãduticʉ niwĩ. Téé nitʉogʉpʉre yapaticʉ niwĩ. Cʉ̃ tojo weecã ĩꞌa ʉcʉarã, aꞌmerĩ ĩꞌapõtẽocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","José cʉ̃ ya mesapʉ nisere narẽ ecaduticʉ niwĩ. Benjamíma ãpẽrã nemorõ baꞌase õrẽsãpeoduticʉ niwĩ. José cʉ̃ maꞌmisʉmʉa meꞌrã niꞌcãrõ meꞌrã sĩꞌrĩ, baꞌa, ʉpʉtʉ ecaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na baꞌáca beꞌro José cʉ̃ ya wiꞌi cjase dutigʉre nicʉ niwĩ: —Ãꞌrã ye ajuripʉ trigore na miarõ põtẽorõ poseyeya. Tojo nicã, na ye ajurinʉcʉ̃ na niyeru wapayeꞌquere sãaña. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tojo wééca beꞌro, na acabiji nitʉogʉ ya ajuropʉ yʉꞌʉ sĩꞌrĩrĩ pa, plata meꞌrã wééca pare, niyeru cʉ̃ trigo wapayeꞌque meꞌrã sãaña, nicʉ niwĩ. Ti wiꞌi dutigʉ José cʉ̃ níꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ape nʉmʉ boꞌremʉjãtiri cura José narẽ, “Mʉsã yarã burroa meꞌrã waꞌarãsaꞌa majã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Na ti macã pʉꞌto nirĩ curata José cʉ̃ ya wiꞌi wiogʉre aꞌtiro nicʉ niwĩ: —Sõꞌonícãrã ʉmʉarẽ sirutugʉ waꞌaya. Narẽ ẽmʉgʉ̃, aꞌtiro niña: “Yʉꞌʉ wiogʉ mʉsãrẽ añurõ weeami. ¿Deꞌro weerã cʉ̃ tojo wééca beꞌro nimicã, mʉsã peꞌe ñaꞌarõ weeati? ");
INSERT INTO tuoNT_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","¿Deꞌro weerã cʉ̃ sĩꞌrĩrĩ pa, plata meꞌrã wééca pare yajati? Yʉꞌʉ wiogʉ ti pa meꞌrã sĩꞌrĩgʉ̃ niami. Tojo nicã, ti pa meꞌrã apeyenojõ quẽꞌesere ‘Tojo nisĩꞌrĩrõ weeꞌe’ nigʉ̃́ niami. Mʉsã ñaꞌabutiaro weecãrã niapʉ,” niña narẽ, nicʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Narẽ ẽmʉejagʉ, cʉ̃ nidutiꞌcaronojõta nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Na cʉ̃rẽ yʉꞌticãrã niwã: —¿Deꞌro weegʉ ʉ̃sãrẽ tojo ucũti? Ʉ̃sã aꞌtenojõ pacama ne weemasĩweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ʉ̃sã sõꞌonícatero niyeru ʉ̃sã ye ajuripʉ bocácatero marĩcãrẽ, tere wiarã aꞌtiwʉ. Niꞌcãrõacãma plata, uru meꞌrã weeꞌquema mʉꞌʉ wiogʉ ya wiꞌi cjasere yajamasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Noꞌo ti pare cʉ̃ ya ajuropʉ cʉogʉnojõ wẽrĩato. Ʉ̃sã ãpẽrã peꞌe cʉ̃rẽ daꞌracoꞌterã tojarã́saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tere tʉꞌogʉ, wiꞌi wiogʉ nicʉ niwĩ: —Añurõsaꞌa. Mʉsã níꞌcaronojõta waꞌarosaꞌa. Mejõ ti pare cʉogʉ seꞌsaro daꞌracoꞌtegʉ tojagʉ́sami. Ãpẽrãpʉa buꞌiri moorãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Nanʉcʉ̃ sojaro meꞌrã na ye ajurire dijanʉꞌcã, te ajurire pãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Tojo weegʉ wiꞌi dutigʉ na ye ajuripʉre aꞌmacʉ niwĩ. Masã maꞌmi ya ajurore aꞌmanʉꞌcã, téé nitʉogʉ ya ajuropʉ yapaticʉ niwĩ. Ti pare Benjamí ya ajuropʉ bocacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Na, na bʉjawetisere ĩꞌorã, na ye suꞌtire wejetʉ̃ꞌrẽcãrã niwã. Beꞌro na ye ajurire burroa buꞌipʉ miipeo, macãpʉ majãmitojaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judá cʉ̃ maꞌmisʉmʉa, cʉ̃ acabijirã meꞌrã ejari curare José cʉ̃ ya wiꞌipʉta nicʉ niwĩ yujupʉ. Cʉ̃rẽ pajañaꞌto nírã, paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","José narẽ nicʉ niwĩ: —¿Deꞌro weemiati mʉsã? Mʉsã yʉꞌʉre, “Masĩse cʉogʉnojõ, masã yaꞌyioropʉ weesere níbocase meꞌrã masĩgʉ̃ nibosami”, ¿ni wãcũtiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judá cʉ̃rẽ yʉꞌticʉ niwĩ: —Wiogʉ, ʉ̃sã deꞌro nímasĩtisaꞌa. ¿Deꞌro wee ʉ̃sã buꞌiri marĩsere ĩꞌomasĩbosari? Õꞌacʉ̃ ʉ̃sã ñaꞌarõ weeꞌque wapare, ʉ̃sãrẽ buꞌiri daꞌregʉtigʉ weetʉꞌsami. Niꞌcãrõacã majã ti pa cʉoꞌcʉ meꞌrã mʉꞌʉrẽ daꞌracoꞌterã niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","José peꞌe narẽ nicʉ niwĩ: —Niweꞌe. Yʉꞌʉ tojo weemasĩtisaꞌa. Cʉ̃ ti pare cʉogʉ diaꞌcʉ̃ tojagʉ́sami. Ãpẽrãpʉa wãcũqueꞌtiro marĩrõ mʉsã pacʉ tiropʉ tojaaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tere tʉꞌogʉ, Judá José tiroacãpʉ waꞌa, ucũcʉ niwĩ: —Wiogʉ, yʉꞌʉ ĩꞌacã, mʉꞌʉ faraṍ weronojõ niꞌi. Tojo nimigʉ̃, yʉꞌʉ meꞌrã uacʉpa. Cãꞌrõ ãpẽrã tʉꞌotiropʉ mʉꞌʉ meꞌrã ucũsĩꞌrĩsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mʉꞌʉ ʉ̃sãrẽ sẽrĩtiñaꞌwʉ̃: “¿Mʉsã pacʉ niti? ¿Acabijirã cʉoti?” niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","“Ʉ̃sã cʉoꞌo, cʉ̃ bʉcʉ nimi”, ni yʉꞌtiwʉ. “Niꞌcʉ̃ maꞌmʉ nitʉogʉpʉ acabijitiꞌi. Cʉ̃ ʉ̃sã pacʉ bʉcʉ waro nicã bajuaꞌcʉ nimi. Niꞌcõ põꞌrã cʉ̃ niꞌcʉ̃ta dʉꞌsami. Apĩ wẽrĩa waꞌacʉ niwĩ. Tojo weegʉ cʉ̃rẽ maꞌiyʉꞌrʉami”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mʉꞌʉ cʉ̃rẽ ĩꞌasĩꞌrĩgʉ̃, ʉ̃sãrẽ miitidutiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Cʉ̃, cʉ̃ pacʉre duꞌutimi”, niwʉ̃. “Cʉ̃ duꞌucãma, cʉ̃ pacʉ wẽrĩa waꞌabosami”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mʉꞌʉ peꞌe ʉ̃sãrẽ “Cʉ̃rẽ miititicãma, mʉsãrẽ ne ñeꞌenemosome majã”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","»Beꞌro ʉ̃sã, ʉ̃sã pacʉ tiropʉ dajarã, mʉꞌʉ níꞌquere werepeꞌocãꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Beꞌropʉ ʉ̃sã pacʉ ʉ̃sãrẽ niwĩ: “Apaturi trigo marĩ baꞌatjere cãꞌrõ duunemorã waꞌaya tja”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ʉ̃sã cʉ̃rẽ aꞌtiro werewʉ: “Benjamírẽ miaticãma, ʉ̃sãrẽ ‘Ne ñeꞌesome’, niami”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Yʉꞌʉ pacʉ, mʉꞌʉrẽ daꞌracoꞌtegʉ weronojõ nigʉ̃́ aꞌtiro yʉꞌtiwĩ: “Mʉsã masĩsaꞌa. Yʉꞌʉ nʉmo yʉꞌʉre pʉarã ʉmʉarẽ põꞌrãtibosawõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Niꞌcʉ̃ yʉꞌʉ meꞌrã níꞌcʉ bajudutia waꞌawĩ. ‘Apetero weegʉ niꞌcʉ̃ yai nʉcʉ̃cjʉ̃ baꞌagʉ, baꞌasapĩ’, nícãti. Ne cʉ̃rẽ apaturi ĩꞌanemotisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ãꞌrĩ dʉꞌsagʉre mia, mejẽcã waꞌacã, yʉꞌʉ bʉcʉ mijĩ bʉjawetise meꞌrã wẽrĩgʉ̃saꞌa. Tojo waꞌacã, mʉsã buꞌiritirãsaꞌa”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","»Yʉꞌʉ pacʉ cʉ̃ basu maꞌirõnojõta Benjamírẽ maꞌiyʉꞌrʉami. Tojo weegʉ cʉ̃ marĩrõ ʉ̃sã dajacã, ");
INSERT INTO tuoNT_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","cʉ̃rẽ ĩꞌatigʉ, wẽrĩa waꞌabosami. Tojo weerã ʉ̃sã pacʉ bʉcʉre dʉjasewãꞌa, wẽrĩcã weebosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yʉꞌʉ, yʉꞌʉ pacʉre “Benjamírẽ sʉꞌori waꞌagʉti. Cʉ̃rẽ miidajatigʉ, yʉꞌʉ catiro põtẽorõ buꞌiritigʉsaꞌa”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tojo weegʉ yʉꞌʉ peꞌe cʉ̃rẽ dʉcayuro, mʉꞌʉrẽ daꞌracoꞌtegʉ tojagʉti. Cʉ̃ peꞌema ãpẽrã cʉ̃ maꞌmisʉmʉa meꞌrã cʉ̃ pacʉ tiropʉ oꞌótõrõña. ");
INSERT INTO tuoNT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Cʉ̃ waꞌaticã, yʉꞌʉ, yʉꞌʉ pacʉ tiropʉ tojaamasĩtisaꞌa. Yʉꞌʉ pacʉre ñaꞌabutiaro bʉjawetise tʉꞌoñaꞌcã ĩꞌasĩꞌrĩtisaꞌa, nicʉ niwĩ Judá. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José utisĩꞌrĩgʉ̃, ne põtẽoticʉ niwĩ. Tojo weegʉ topʉ nirã́ cʉ̃rẽ daꞌracoꞌterãrẽ caricũcʉ niwĩ: —Nipeꞌtirã wijaapeꞌtia waꞌaya, nicʉ niwĩ. Beꞌro José cʉ̃ maꞌmisʉmʉarẽ “Yʉꞌʉ mʉsã acabiji niꞌi” ni, werebajurẽcã, ne niꞌcʉ̃ cʉ̃rẽ daꞌracoꞌterã tojaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Beꞌro José ʉpʉtʉ uticʉ niwĩ. Egiptocjãrã cʉ̃ wijaadutiꞌcãrã tʉꞌoseꞌsacãrã niwã. Te queti téé wiogʉ faraṍ ya wiꞌipʉ seꞌsa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","José cʉ̃ maꞌmisʉmʉarẽ nicʉ niwĩ: —Yʉꞌʉ José niꞌi. ¿Yʉꞌʉ pacʉ catiati yujupʉ? Na peꞌe ʉcʉayʉꞌrʉaꞌcãrã nitjĩarã, ne yʉꞌtimasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Beꞌro José narẽ nicʉ niwĩ: —Mʉsã yʉꞌʉ tirocure aꞌtia. Na cʉ̃ tiroacã ejacã, narẽ nicʉ niwĩ: —Yʉꞌʉ José niꞌi. Mʉsã yʉꞌʉre Egiptopʉ duaꞌcʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aꞌtere tʉꞌorã, bʉjawetiticãꞌña. Mʉsã basu aꞌmerĩ tuubʉaticãꞌña. Õꞌacʉ̃ mʉsã dʉporo yʉꞌʉre oꞌóyuwĩ. Masãrẽ yʉꞌrʉogʉtigʉ, tojo weewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aꞌti diꞌta Egiptopʉre ʉjʉaboase pʉa cʉ̃ꞌma waꞌatojaꞌa. Niꞌcãmocʉse cʉ̃ꞌmarĩ dʉꞌsaꞌa yujupʉ. Te cʉ̃ꞌmarĩ otemicã, ne pĩꞌrĩsome, ne dʉcatisome. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Õꞌacʉ̃ mʉsã dʉporo yʉꞌʉre oꞌóyumʉꞌtãwĩ. Mʉsã pãrãmerã nituriato nígʉ̃, tojo nicã cʉ̃ tutuase meꞌrã mʉsãrẽ yʉꞌrʉwetiato nígʉ̃, tojo weewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tojo weegʉ Õꞌacʉ̃ta aꞌtopʉre yʉꞌʉre oꞌówĩ. Mʉsã mejẽta yʉꞌʉre oꞌówʉ. Õꞌacʉ̃ yʉꞌʉre faraṍrẽ werecasari masʉ̃ sõrõwĩ. Tojo nicã nipeꞌtise cʉ̃ ya wiꞌi cjasere dutigʉ, nipeꞌtiro Egiptopʉre dutigʉ sõrõwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Maata tojaaya marĩ pacʉ tiropʉ. Cʉ̃rẽ aꞌtere wererã waꞌaya: “Mʉꞌʉ macʉ̃ José mʉꞌʉrẽ aꞌtiro nidutiami: ‘Õꞌacʉ̃ yʉꞌʉre nipeꞌtiro Egipto wiogʉ sõrõwĩ. Maata yʉꞌʉre ĩꞌagʉ̃ aꞌtia. Yoogoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mʉꞌʉ aꞌtopʉ Gosén wãmetiropʉ tojagʉsaꞌa. Yʉꞌʉ tiroacã nigʉ̃saꞌa. Nipeꞌtise mʉꞌʉ cʉose, nipeꞌtirã mʉꞌʉ põꞌrã meꞌrã, mʉꞌʉ pãrãmerã meꞌrã, mʉꞌʉ yarã waꞌicʉrã meꞌrã aꞌtia. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aꞌtopʉ mʉꞌʉrẽ, mʉꞌʉ põꞌrãrẽ, nipeꞌtirã mʉꞌʉ meꞌrã nirãrẽ baꞌase oꞌogʉti. Ne apeyenojõ dʉꞌsasome. Ʉjʉaboase cʉ̃ꞌmarĩ niꞌcãmocʉse cʉ̃ꞌmarĩ dʉꞌsaꞌa yujupʉ. Tojo aꞌtitirã pũrĩcã, mʉꞌʉ, mʉꞌʉ põꞌrã, mʉꞌʉ pãrãmerã, apeyenojõ moorã tojarã́saꞌa’, ni wereya yʉꞌʉ pacʉre. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Apeyema tja yʉꞌʉ acabiji Benjamí, tojo nicã mʉsã basuta ‘Diacjʉ̃ José tojo niami’, ni weremasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Marĩ pacʉre ‘Cʉ̃ nipeꞌtiro Egiptopʉre dutigʉ niami’, tojo nicã nipeꞌtise mʉsã ĩꞌaꞌquere cʉ̃rẽ wereya. Maatacure yʉꞌʉ pacʉre miirã waꞌaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Cʉ̃ tojo nitoja, cʉ̃ acabiji Benjamírẽ paabʉꞌagʉta, uticʉ niwĩ. Benjamí quẽꞌrã cʉ̃ maꞌmi Joseré paabʉꞌa, uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Beꞌro nipeꞌtirãrẽ paabʉꞌa, miꞌmi, uticʉ niwĩ. Aꞌtiro wééca beꞌropʉta cʉ̃ maꞌmisʉmʉa cʉ̃ meꞌrã ucũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tojo wee faraṍ ya wiꞌipʉre “José maꞌmisʉmʉa etapãrã” nise seꞌsa waꞌacaro niwʉ̃. Te quetire tʉꞌorã, faraṍ, cʉ̃rẽ dutitamurã eꞌcatiyʉꞌrʉacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tojo weegʉ faraṍ Joseré aꞌtiro nicʉ niwĩ: —Mʉꞌʉ maꞌmisʉmʉarẽ na yarã waꞌicʉrã buꞌipʉ trigore miipeo, Canaápʉ dajatojaadutiya. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Tojaa, mʉꞌʉ pacʉre, mʉꞌʉ acawererãrẽ miirã waꞌato. Aꞌto Egiptopʉ diꞌta añusere narẽ oꞌogʉti. Tojo nicã aꞌti diꞌta cjase otese dʉcare baꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Narẽ aꞌtiro weedutiya. Aꞌto cjase tũrũsepawʉre miadutiya. Tepawʉ meꞌrã na nʉmosãnumiarẽ, na põꞌrãrẽ, mʉsã pacʉre miitirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Egipto cjase añubutiase na ye nirõsaꞌa. Tojo weerã na topʉ miitidʉꞌaꞌquere wãcũqueꞌtiticãꞌto, ni wereduticʉ niwĩ faraṍ Joseré. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tojo weerã Jacob põꞌrã aꞌtiro weecãrã niwã. Faraṍ cʉ̃ oꞌodutiꞌcaronojõta José tũrũsepawʉre oꞌocʉ niwĩ. Tojo nicã, na maꞌapʉ baꞌatjere oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nanʉcʉ̃ maꞌma suꞌti oꞌocʉ niwĩ. Benjamí cʉ̃ acabiji waro peꞌema trescientos cujiri niyeru plata meꞌrã weeꞌque cujirire oꞌocʉ niwĩ. Cʉ̃ peꞌema niꞌcãmocʉse suꞌti oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Cʉ̃ pacʉre diez burro ʉmʉa buꞌipʉ Egipto cjase añusere miipeo, oꞌócʉ niwĩ. Ãpẽrã burra numia ticʉrãta tja trigo, pã́, cʉ̃ pacʉ Egiptopʉ aꞌtigʉ, maꞌapʉ baꞌatjere miipeo, oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","José cʉ̃ maꞌmisʉmʉarẽ weꞌritigʉ, aꞌtiro nicʉ niwĩ: —Mʉsã, noꞌo maꞌapʉ waꞌarã, aꞌmetuꞌtiwãꞌcãticãꞌña, nicʉ niwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tojo weerã na Egiptopʉ níꞌcãrã waꞌa, na pacʉ Jacob nirĩ diꞌta Canaápʉ dajacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Topʉ daja, na pacʉre “José catiami. Cʉ̃ nipeꞌtiro Egiptopʉre dutiami”, ni werecãrã niwã. Tere tʉꞌogʉ, tʉꞌoʉcʉa waꞌacʉ niwĩ. Na weresere ẽjõpeoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nipeꞌtise José cʉ̃ níꞌquere werecãpʉta, cʉ̃rẽ miitidutigʉ oꞌóꞌque tũrũsepawʉre ĩꞌagʉ̃pʉta ẽjõpeocʉ niwĩ. Tojo weegʉ tere ĩꞌagʉ̃, wãcũtutuacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Aꞌtiro nicʉ niwĩ: —Yʉꞌʉ ĩꞌacã, diacjʉ̃ta nitʉꞌsaꞌa. To pũrĩcãrẽ yʉꞌʉ macʉ̃ José catisami yujupʉ. Yʉꞌʉ wẽrĩse dʉporo cʉ̃rẽ ĩꞌaweꞌogʉ waꞌagʉti, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tojo weegʉ Jacob cʉ̃ cʉose nipeꞌtise meꞌrã waꞌacʉ niwĩ. Waꞌa, Beerseba wãmetiri macãpʉ etacʉ niwĩ. Topʉ etagʉ, cʉ̃ pacʉ Isaa ẽjõpeoꞌcʉ Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Topʉ cʉ̃ cã́rĩ́ca ñamirẽ Õꞌacʉ̃ Jacore pisucʉ niwĩ: —¡Jacob! nicʉ niwĩ. Cʉ̃ peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Aꞌtota niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃, mʉꞌʉ pacʉ ẽjõpeoꞌcʉ niꞌi. Mʉꞌʉ Egiptopʉre waꞌagʉ, ne uiticãꞌña. Topʉre yʉꞌʉ mʉꞌʉ pãrãmerã nituriarãrẽ pãjãrã masãputicã weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mʉꞌʉ meꞌrãta Egiptopʉre baꞌpatiwãꞌcãgʉ̃saꞌa. Topʉ mʉꞌʉ pãrãmerã nituriarãrẽ aꞌti diꞌtapʉ miitigʉsaꞌa tja. Apeye quẽꞌrãrẽ mʉꞌʉ wẽrĩrĩ cura José mʉꞌʉ meꞌrãta nigʉ̃sami, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Beꞌro cʉ̃ Beersebapʉ níꞌcʉ wijawãꞌcãcʉ niwĩ. Jacob põꞌrã na pacʉre, na põꞌrãrẽ, na nʉmosãnumiarẽ aꞌtiro weecãrã niwã. Faraṍ cʉ̃ aꞌtidutigʉ cʉ̃ oꞌóꞌquepawʉ tũrũsepawʉpʉ narẽ miisãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Na Egiptopʉ waꞌarã, na yarã wecʉa, oveja, nipeꞌtise na Canaá diꞌtapʉ cʉoꞌquere miapeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Tojo nicã cʉ̃ põꞌrã, cʉ̃ põꞌrã numia, pãrãmerã ʉmʉa, numia nipeꞌtirã cʉ̃ meꞌrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacob põꞌrã, tojo nicã cʉ̃ pãrãmerã Egiptopʉ macãrĩ waꞌaꞌcãrã aꞌtiro wãmeticãrã niwã: Masã maꞌmi Rubén nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Cʉ̃ põꞌrã Hanoc, Falú, Hezrón, Carmi nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Beꞌrore Simeó põꞌrã aꞌticʉrã nicãrã niwã: Jemuel, Jamín, Ohad, Jaquín, Zohar nicãrã niwã. Tojo nicã Saúl, cananeocjõ macʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Beꞌrore Leví põꞌrã Gersón, Coat, Merari nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Beꞌrore Judá põꞌrã Er, Onán, Sela, Fares, Zara nicãrã niwã. Er, Onán na pũrĩcã Canaá diꞌtapʉ wẽrĩa waꞌacãrã niwã. Fares põꞌrã Hezrón, Hamul nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Beꞌrore Isacar põꞌrã Tola, Fúa, Job, Simrón nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Beꞌrore Zabulṍ põꞌrã Sered, Elón, Jahleel nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ãꞌrã Jacob Lea meꞌrã põꞌrãtiꞌcãrã nicãrã niwã. Na Padan-aram wãmetiropʉ nírã põꞌrãticãrã niwã. Tojo nicã Dinarẽ põꞌrãticʉ niwĩ. Nipeꞌtirã Jacob põꞌrã, cʉ̃ pãrãmerã nituriarã Lea meꞌrã põꞌrãtiꞌcãrã treinta y tres ʉmʉa, numia nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Beꞌrore Gad põꞌrã Zifión, Hagui, Ezbón, Suni, Eri, Arodi, Areli nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Beꞌrore Aser põꞌrã Imna, Isúa, Isúi, Bería nicãrã niwã. Na acabijo Sera nico niwõ. Beriá põꞌrã Heber, Malquiel nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ãꞌrãrẽ Jacob Zilpa meꞌrã põꞌrãticʉ niwĩ. Põꞌrãti, pãrãmerãticʉ niwĩ. Co Zilpa Labán macõ Leare daꞌracoꞌtedutigʉ oꞌonoꞌco nico niwõ. Co meꞌrã Jacob dieciseis põꞌrãti, pãrãmerãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob Raquel meꞌrã José, Benjamírẽ põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José Asenat meꞌrã Manasés, Efraĩ́rẽ põꞌrãticʉ niwĩ. Na pʉarã Egiptopʉ bajuacãrã niwã. Co Asenat paꞌi Potifera, On wãmetiri macãcjʉ̃ macõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamí põꞌrã Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim, Ard nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ãꞌrã Jacob, Raquel pãrãmerã nituriarã catorce nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Beꞌrore Dan macʉ̃ Husim niꞌcʉ̃ta nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftalí põꞌrã Jahzeel, Guni, Jezer, Silem nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ãꞌrãrẽ Jacob Bilha meꞌrã põꞌrãticʉ niwĩ. Co Labán macõ Raquere daꞌracoꞌtedutigʉ oꞌonoꞌco nico niwõ. Nipeꞌtirã cʉ̃ põꞌrã, pãrãmerã siete nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tojo weerã Egiptopʉre waꞌarã, Jacob põꞌrã, cʉ̃ pãrãmerã waro sesenta y seis nicãrã niwã. Na põꞌrã nʉmosãnumiarẽ baꞌpaqueonoꞌña marĩrã ticʉrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José pʉarã põꞌrãticʉ niwĩ. Na Egiptopʉ bajuacãrã niwã. Tojo weerã Egiptopʉre setenta Jacob acawererã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob cʉ̃ macʉ̃ Judáre José tiropʉ oꞌómʉꞌtãcʉ niwĩ. Cʉ̃rẽ oꞌógʉ, Joseré “Yʉꞌʉre Gosẽ́pʉ põtẽrĩgʉ̃ aꞌtiato”, ni queti oꞌócʉ niwĩ. Tojo weerã na Gosén etacã, ");
INSERT INTO tuoNT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José cʉ̃ yawʉ tũrũpjʉre apoduti, topʉ cʉ̃ pacʉre põtẽrĩgʉ̃ waꞌacʉ niwĩ. Cʉ̃rẽ bocaeja, paabʉꞌa, yoacã uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob cʉ̃ macʉ̃ Joseré aꞌtiro nicʉ niwĩ: —Yʉꞌʉ basuta mʉꞌʉrẽ ĩꞌaꞌa. Mʉꞌʉ catiꞌi yujupʉ. Tojo weegʉ yʉꞌʉ niꞌcãrõacãma añurõ wẽrĩmasĩꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Beꞌro José cʉ̃ maꞌmisʉmʉarẽ, cʉ̃ pacʉ acawererãrẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ faraṍ tiropʉ waꞌagʉti. “Yʉꞌʉ maꞌmisʉmʉa, yʉꞌʉ pacʉ acawererã, Canaá diꞌtapʉ níꞌcãrã yʉꞌʉ meꞌrã macãrĩ aꞌtirã etatojama”, ni quetiweregʉ waꞌagʉti. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","“Na ovejare, wecʉare coꞌterã nima. Na yarã oveja, wecʉa, nipeꞌtise na cʉosenojõrẽ miitipeꞌocãrã niama,” nigʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tojo weegʉ faraṍ mʉsãrẽ pijio, sẽrĩtiñaꞌcã, “¿Mʉsã ñeꞌenojõrẽ daꞌrati?” nicã, aꞌtiro yʉꞌtiapa. ");
INSERT INTO tuoNT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“Ʉ̃sã wĩꞌmarã nírãpʉta oveja coꞌtesere daꞌranʉꞌcãwʉ̃. Ʉ̃sã ñecʉ̃sʉmʉa daꞌraꞌcaronojõta tere daꞌradecotiꞌi,” niña. Egiptocjãrã oveja coꞌtesere tʉꞌsatisama. Mʉsã tojo yʉꞌticã, mʉsãrẽ Gosén diꞌtapʉ cũugʉ̃sami, nicʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Beꞌro José faraṍ tiropʉ queti miacʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Yʉꞌʉ pacʉ, yʉꞌʉ maꞌmisʉmʉa Canaápʉ níꞌcãrã etatojama. Na Gosén diꞌtapʉ na yarã oveja, wecʉa, na cʉose nipeꞌtise meꞌrã niama. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Faraṍ tiropʉre niꞌcãmocʉrã cʉ̃ maꞌmisʉmʉarẽ bese, miacʉ niwĩ. Narẽ ĩꞌamasĩato nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Na topʉ etacã, faraṍ cʉ̃ maꞌmisʉmʉarẽ sẽrĩtiñaꞌcʉ niwĩ. Aꞌtiro nicʉ niwĩ: —¿Mʉsã ñeꞌenojõrẽ daꞌrati? Na cʉ̃rẽ yʉꞌticãrã niwã: —Ʉ̃sã mʉꞌʉ dutise doca nirã́ ovejare coꞌteri masã niꞌi. Ʉ̃sã, ʉ̃sã ñecʉ̃sʉmʉa daꞌrasetiꞌquereta daꞌraꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Canaá diꞌtapʉre ʉjʉaboase niyʉꞌrʉapʉ. Ʉ̃sã yarã oveja na baꞌase tá ne marĩapʉ. Te ye buꞌiri aꞌto Egiptopʉ macãrĩ aꞌtirã weeapʉ. Tojo weerã mʉꞌʉrẽ aꞌtere sẽrĩꞌi. Ʉ̃sãrẽ Gosẽ́pʉ diꞌta oꞌoya. Ʉ̃sã topʉ nirãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tere tʉꞌogʉ, faraṍ Joseré nicʉ niwĩ: —Mʉꞌʉ maꞌmisʉmʉa, mʉꞌʉ pacʉ mʉꞌʉ tiropʉ macãrĩ aꞌtiapã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mʉꞌʉ aꞌti diꞌta Egiptore dutigʉ niꞌi. Tojo weegʉ Gosén añurĩ diꞌtare narẽ oꞌoya. Na ti diꞌtapʉ niato. Noꞌo mʉꞌʉ maꞌmisʉmʉa na wecʉa coꞌtemeꞌrĩrã nicã, narẽ te coꞌtesere sõrõña. Yarã wecʉa quẽꞌrãrẽ coꞌteato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Beꞌro José cʉ̃ pacʉ Jacore faraṍ tiropʉ miacʉ niwĩ. Tojo weegʉ Jacob faraṍrẽ wiopesase meꞌrã añuduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraṍ cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Dicʉse cʉ̃ꞌmarĩ cʉoti mʉꞌʉ? ");
INSERT INTO tuoNT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","—Ciento treinta cʉ̃ꞌmarĩ cʉoꞌo. Yʉꞌʉ noꞌo nirṍ waꞌamʉjã, sijabaqueꞌatise cʉ̃ꞌmarĩrẽ piꞌetise meꞌrã nisetiwʉ. Tojo weemigʉ̃, yʉꞌʉ ñecʉ̃sʉmʉa na catiꞌque cʉ̃ꞌmarĩrẽ ẽmʉejatisaꞌa yujupʉ, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tuꞌajanʉꞌcõ, Jacob faraṍrẽ “Õꞌacʉ̃ mʉꞌʉrẽ añurõ weeato” ni, weꞌriti waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","José narẽ Egipto cjase diꞌta añusere oꞌocʉ niwĩ. Faraṍ dutiꞌcaronojõta weecʉ niwĩ. Tojo weerã cʉ̃ pacʉ, cʉ̃ maꞌmisʉmʉa Ramsés wãmetiropʉ diꞌta oꞌo, cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","José cʉ̃ pacʉre, cʉ̃ maꞌmisʉmʉarẽ, cʉ̃ acabijire, nipeꞌtirã cʉ̃ acawererãrẽ baꞌasere oꞌonuꞌcũcãꞌcʉ niwĩ. Nipeꞌtirã na põꞌrã baꞌatjo ejatuaro oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Egiptopʉre, tojo nicã Canaápʉre ne baꞌase marĩcaro niwʉ̃. Ʉjʉaboase siapeꞌe meꞌrã nemorõ waꞌacaro niwʉ̃. Tojo weerã masã wẽrĩse pʉꞌto nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tere ĩꞌagʉ̃, José aꞌtiro weecʉ niwĩ. Nipeꞌtirã Egiptocjãrã, Canaácjãrã trigo wapare na wapayeꞌquere ñeꞌe, faraṍ ya wiꞌipʉ nʉrõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Beꞌro nipeꞌtirã Egiptocjãrã, tojo nicã Canaá diꞌtacjãrã niyeru peꞌticã ĩꞌarã, José tiropʉ waꞌa, aꞌtiro nicãrã niwã: —Ʉ̃sã baꞌase duurã, niyeru peꞌtiqueꞌa waꞌapʉ. Ʉ̃sãrẽ baꞌase oꞌoya. Mʉꞌʉ oꞌoticã, mʉꞌʉ ĩꞌorõta wẽrĩrãsaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Na tojo nicã, José narẽ yʉꞌticʉ niwĩ: —Mʉsã niyeru moorã, mʉsã yarã waꞌicʉrãrẽ miitia. Na meꞌrã mʉsãrẽ trigore dʉcayugʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tojo weerã Egiptocjãrã na yarã cabayua, oveja, wecʉa, noꞌo na waꞌicʉrã cʉorãnojõrẽ trigo dʉcayurãtirã miacãrã niwã. Aꞌtiro wéérã ti cʉ̃ꞌmarẽ na waꞌicʉrã meꞌrã baꞌase dʉcayurã, baꞌase cʉocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ape cʉ̃ꞌma José tiropʉ aꞌticãrã niwã tja. Aꞌtiro nicãrã niwã: —Wiogʉ, mʉꞌʉrẽ diacjʉ̃ta wererãti. Ʉ̃sã niyeru mooꞌo majã. Tojo weerã ʉ̃sã yarã waꞌicʉrã, ʉ̃sã cʉoꞌcãrã mʉsã yarã nima. Ʉ̃sã tojaqueꞌa waꞌasaꞌa majã. Tojo weerã ʉ̃sã upʉ, ʉ̃sã ye diꞌta diaꞌcʉ̃ mʉꞌʉrẽ wiamasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mejõ waro mʉꞌʉ ĩꞌorõpʉ wẽrĩbosaꞌa. Mʉꞌʉ ʉ̃sãrẽ, ʉ̃sã ye diꞌtare duuya. Te wapare trigore dʉcayuya. Tojo weerã ʉ̃sã, tojo nicã ʉ̃sã ye diꞌta meꞌrã faraṍ dutise doca nirãsaꞌa. Mejõ ʉ̃sãrẽ otese capere oꞌoya. Te diꞌtare daꞌra, ote baꞌarãsaꞌa. Tojo weerã ʉ̃sã catirãsaꞌa. Tojo nicã, ʉ̃sã ye diꞌta apeyenojõ otese marĩrĩ diꞌta nisome. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Aꞌtiro wee José nipeꞌtise diꞌtare duu, wiogʉ faraṍpʉre wiacʉ niwĩ. Egiptocjãrã ʉjʉaboayurã, nipeꞌtise na ye diꞌtare duacãrã niwã. Tojo weero na diꞌta duaꞌque faraṍ ye diꞌta tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Te meꞌrã nipeꞌtirã Egiptocjãrã faraṍrẽ daꞌracoꞌteri masã tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Paꞌia ye diꞌta diaꞌcʉ̃rẽ José duuticʉ niwĩ. Narẽ faraṍ queoro na baꞌaro ejatuaro oꞌocʉ niwĩ. Tojo weerã te diꞌtare duaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Beꞌro José masãrẽ nicʉ niwĩ: —Niꞌcãrõacã meꞌrã mʉsã, tojo nicã mʉsã ye diꞌta faraṍ ye tojaꞌa. Yʉꞌʉ cʉ̃ ye niatjere duubosapʉ. Mʉsã oteatje cape aꞌte niꞌi. Te meꞌrã mʉsã nimiꞌque diꞌtare oterã waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mʉsã ote dʉcatisere niꞌcãmocʉse mesãrĩ seeneocũu, faraṍrẽ niꞌcã mesã cjase trigore oꞌoya. Apeye baꞌparitise mesãrĩ cjase, mʉsã oteatje cape, mʉsã põꞌrã meꞌrã baꞌatje, nipeꞌtirã mʉsã meꞌrã nirã́ na baꞌatje nirõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tere tʉꞌorã, na cʉ̃rẽ yʉꞌticãrã niwã: —Mʉꞌʉ ʉ̃sãrẽ yʉꞌrʉweticã weeapʉ. Mʉꞌʉ ʉ̃sãrẽ añubutiaro weeꞌe. Tojo weerã ʉ̃sã faraṍrẽ daꞌracoꞌteri masã tojarã́saꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","José aꞌtiro dutise cũucʉ niwĩ. Te dutise aꞌtiro nicaro niwʉ̃: “Mʉsã oteꞌque dʉca niꞌcãmocʉse mesãrĩ mʉsã seeꞌque niꞌcã mesã faraṍ ye nirõsaꞌa”, nicaro niwʉ̃. Aꞌte dutise cũuꞌque nidecotisaꞌa yujupʉ. Paꞌia ye diꞌta pũrĩcã faraṍ ye diꞌta mejẽta nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Beꞌro Israe curuacjãrã Egipto diꞌtapʉ macãrĩ niseticãrã niwã. Gosén wãmetiropʉ diꞌta ñeꞌe, tojacãrã niwã. Topʉre pãjãrã waro masãputicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob to Gosẽ́pʉre diecisiete cʉ̃ꞌmarĩ nicʉ niwĩ. Nipeꞌtise cʉ̃ catise cʉ̃ꞌmarĩ ciento cuarenta y siete cʉ̃ꞌmarĩ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Beꞌro Jacob wẽrĩgʉ̃tigʉ, cʉ̃ macʉ̃ Joseré pijidutigʉ oꞌócʉ niwĩ. Cʉ̃ tiro etacã ĩꞌagʉ̃, cʉ̃rẽ nicʉ niwĩ: —Macʉ̃, diacjʉ̃ta yʉꞌʉre maꞌígʉ̃, aꞌtiro weeya. Mʉꞌʉ ya omocãrẽ ya ʉsó docapʉ cũuña. Diacjʉ̃, mʉꞌʉ pajañaꞌse meꞌrã yʉꞌʉ “Aꞌtiro weeya” nisere “Jaʉ, tojota weegʉti”, niña. Yʉꞌʉre aꞌto Egiptopʉre yaaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yʉꞌʉ wẽ́rĩ́ca beꞌro yʉꞌʉ ñecʉ̃sʉmʉa masãperi nirõpʉ yʉꞌʉre yaagʉ waꞌaya. Topʉ na tiropʉ soogʉ waꞌagʉsaꞌa. —Pacʉ, mʉꞌʉ nírõnojõta weegʉti, nicʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","—“Õꞌacʉ̃ wãme meꞌrã diacjʉ̃ta tojo weegʉti” niña, ninemocʉ niwĩ cʉ̃ macʉ̃rẽ. Tere tʉꞌogʉ, José nicʉ niwĩ: —Jaʉ, Õꞌacʉ̃ wãme meꞌrã tojota weegʉti. Cʉ̃ tojo níca beꞌro Jacob Õꞌacʉ̃rẽ ẽjõpeogʉ, cʉ̃ cũñarõ yapapʉ ejaqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Cãꞌrõ yʉꞌrʉ́ca beꞌro José macãpʉ nigʉ̃rẽ “Mʉꞌʉ pacʉ dutitigʉ weeami”, nicãrã niwã. Tere tʉꞌogʉ, Gosẽ́pʉ nigʉ̃rẽ ĩꞌagʉ̃ waꞌacʉ niwĩ. Cʉ̃ põꞌrã pʉarãrẽ Manasés, Efraĩ́rẽ miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jacob cʉ̃ macʉ̃ “Etapʉ” nise quetire tʉꞌogʉ, wãcũtutua, cʉ̃ cũñarõpʉ níꞌcʉ wãꞌcãnujãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob cʉ̃ macʉ̃rẽ nicʉ niwĩ: —Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ Canaá diꞌta Luz wãmetiri macãpʉ bajua, yʉꞌʉre “Añurõ waꞌato”, ni ucũwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Aꞌtiro niwĩ: “Mʉꞌʉrẽ pãjãrã põꞌrãticã weegʉti. Mʉꞌʉ pãrãmerã nituriarã peje curaricjãrã nirãsama. Tojo nicã, aꞌti diꞌtare narẽ oꞌogʉti. Na ye diꞌta ninuꞌcũrõsaꞌa”, niwĩ Õꞌacʉ̃ yʉꞌʉre, nicʉ niwĩ Joseré. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Beꞌro Jacob aꞌtiro ninemocʉ niwĩ: “Mʉꞌʉ põꞌrã Efraĩ́, Manasés aꞌti diꞌta Egiptopʉ bajuacãrã niwã. Yʉꞌʉ mʉꞌʉ tiro macãrĩ aꞌtiatji dʉporo bajuatojacãrã niwã. Yʉꞌʉ põꞌrã weronojõ nirãsama. Na quẽꞌrã Rubén, Simeó nírõnojõta yarã nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Na beꞌro bajuasiruturã mʉꞌʉ põꞌrã nirãsama. Na Efraĩ́, Manasés acabijirã niyurã, na diꞌta ñeꞌeatje na maꞌmisʉmʉa meꞌrãta ñeꞌesiruturãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yʉꞌʉ Padan-arãpʉ níꞌcʉ dajanʉꞌcãrĩ cura Canaá diꞌtapʉ mʉꞌʉ paco Raquel wẽrĩa waꞌawõ. Ʉ̃sã Efrata wãmetiro etati dʉporoacã tojo waꞌawõ. Tojo weegʉ maꞌa Efrata sumutopʉ core yaawʉ. Niꞌcãrõacãma to Belẽ́ wãmetiꞌi majã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Beꞌro Jacob José põꞌrãrẽ ĩꞌaboca, sẽrĩtiñaꞌcʉ niwĩ: —¿Ãꞌrã waro noanojõ niti? ");
INSERT INTO tuoNT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ põꞌrã nima. Ãꞌrãrẽ Õꞌacʉ̃ yʉꞌʉ aꞌto Egiptopʉ nicã oꞌowĩ, nicʉ niwĩ. Tere tʉꞌogʉ, cʉ̃ pacʉ cʉ̃rẽ nicʉ niwĩ: —Narẽ yʉꞌʉ tiroacãpʉ miitia. Õꞌacʉ̃rẽ narẽ sẽrĩbosagʉtigʉ weeꞌe, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jacob bʉcʉ waro nicʉ niwĩ. Tojo weegʉ añurõ caperi ĩꞌaejaticʉ niwĩ. José cʉ̃ põꞌrãrẽ cʉ̃ pacʉ tiroacãpʉ miiejacã, narẽ põtẽrĩ, miꞌmi, paabʉꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Beꞌro Joseré nicʉ niwĩ: —Mʉꞌʉrẽ apaturi ĩꞌagʉ̃saꞌa, nitiasʉ. Tojo nimicã, Õꞌacʉ̃ yʉꞌʉre mʉꞌʉ põꞌrã quẽꞌrãrẽ ĩꞌadutigʉ cũuapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","José cʉ̃ põꞌrãrẽ cʉ̃ pacʉ ʉsópʉ dujiꞌcãrãrẽ miinʉꞌcõ, paamuꞌrĩqueꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Beꞌro na pʉarãrẽ na omocãrĩpʉ ñeꞌe, Jacob tiro weje ejanʉꞌcõcʉ niwĩ. Efraĩ́rẽ cũpe peꞌe, Manasére diacjʉ̃ peꞌe nʉꞌcõcʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Cʉ̃ tojo weemicã, Jacob cʉ̃ ye omocãrĩrẽ sĩ́oo, mii dʉcayuquejocãꞌcʉ niwĩ. Tojo weegʉ Efraĩ́ ya dʉpoa buꞌipʉ diacjʉ̃camocãrẽ ñapeocʉ niwĩ. Cʉ̃ peꞌe dʉꞌsagʉpʉ nicʉ nimiwĩ. Cũpecamocã peꞌere Manasés ya dʉpoa buꞌipʉ ñapeocʉ niwĩ. Cʉ̃ peꞌe masã maꞌmi nicʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Narẽ “Añurõ waꞌato” ni, Õꞌacʉ̃rẽ aꞌtiro ni sẽrĩbosacʉ niwĩ: “Õꞌacʉ̃, yʉꞌʉ ñecʉ̃ Abrahã, yʉꞌʉ pacʉ Isaa mʉꞌʉ dutisere yʉꞌticãrã niwã. Õꞌacʉ̃, yʉꞌʉ bajuáca nʉmʉ meꞌrã yʉꞌʉre coꞌtenʉꞌcã, aꞌtiro nicãpʉ quẽꞌrãrẽ coꞌtenuꞌcũcãꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mʉꞌʉrẽ werecoꞌtegʉ yʉꞌʉre ñaꞌarõ waꞌaboꞌquere yʉꞌrʉweticã weeꞌcʉ ãꞌrãrẽ añurõ waꞌacã weeato. Mʉꞌʉ ãꞌrã yʉꞌʉ pãrãmerãrẽ beꞌropʉre na meꞌrã yʉꞌʉ wãmerẽ, yʉꞌʉ ñecʉ̃ Abrahã wãmerẽ, yʉꞌʉ pacʉ Isaa wãmerẽ wãcũcã weeya. Ʉ̃sãrẽ acobojoticãꞌto. Na pãjãrã põꞌrãti masãputiato. Aꞌti diꞌtapʉre pãjãrã waro niyʉꞌrʉoquejocãꞌto”, ni sẽrĩbosacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","José cʉ̃ pacʉre Efraĩ́ ya dʉpoapʉre diacjʉ̃camocã meꞌrã ñapeocã ĩꞌagʉ̃, tʉꞌsaticʉ niwĩ. Tojo weegʉ Manasés ya dʉpoa peꞌere diacjʉ̃camocãrẽ ñapeodutigʉ, cʉ̃ pacʉ ya omocãrẽ miicʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Aꞌtiro nicʉ niwĩ: —Pacʉ, tojo niweꞌe. Ãꞌrĩ peꞌe masã maꞌmi nimi. Tojo weegʉ diacjʉ̃camocãrẽ cʉ̃ dʉpoapʉre ñapeoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Cʉ̃ pacʉ peꞌe, “Macʉ̃, tere masĩꞌi. Masã maꞌmi quẽꞌrã pãjãrã pãrãmerãtigʉsami. Beꞌro niꞌcã diꞌta pajiri diꞌtajo sãjãrã́sama. Tojo nimicã, cʉ̃ acabiji peꞌe cʉ̃ yʉꞌrʉoro niyʉꞌrʉnʉꞌcãgʉ̃sami. Cʉ̃ pãrãmerã nituriarã pũrĩcã pãjãrã waro masãputirãsama. Masãputi, peje curaricjãrã nirãsama”, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ti nʉmʉrẽta Jacob narẽ Õꞌacʉ̃rẽ añurõ weedutigʉ, aꞌtiro sẽrĩbosacʉ niwĩ: —Israe curuacjãrã mʉsã pʉarã ye wãme meꞌrã ãpẽrãrẽ añurõ waꞌadutirã, Õꞌacʉ̃rẽ aꞌtiro nirãsama: “Õꞌacʉ̃ Efraĩ́rẽ, Manasére añurõ weeꞌcaronojõta mʉsã quẽꞌrãrẽ ‘Añurõ weeato’, nirãsama”, nicʉ niwĩ. Aꞌtiro wéégʉ, Jacob Efraĩ́rẽ, Manasés yʉꞌrʉoro cʉ̃ buꞌipʉ tojacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Cʉ̃ Õꞌacʉ̃rẽ sẽrĩbosáca beꞌro Joseré nicʉ niwĩ: —Yʉꞌʉ wẽrĩgʉ̃tigʉ weesaꞌa. Õꞌacʉ̃ mʉsã meꞌrã ninuꞌcũgʉ̃sami. Mʉsãrẽ, mʉsã ñecʉ̃sʉmʉa níꞌque diꞌtapʉ macãrĩ dajanʉꞌcãcã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mʉꞌʉrẽ, ãpẽrã mʉꞌʉ maꞌmisʉmʉa yʉꞌrʉoro oꞌoyʉꞌrʉnʉꞌcãꞌa. Mʉꞌʉrẽ Siquem, yʉꞌʉ amorreo masã meꞌrã aꞌmewẽjẽ wapataꞌaca diꞌtare mʉꞌʉrẽ oꞌogʉti, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob nipeꞌtirã cʉ̃ põꞌrãrẽ pijio, aꞌtiro nicʉ niwĩ: “Yʉꞌʉ tirocureacã aꞌtia. Mʉsãrẽ beꞌropʉ waꞌatjere weregʉti weeꞌe: ");
INSERT INTO tuoNT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","”Nipeꞌtirã yʉꞌʉ põꞌrã tʉꞌorã aꞌtia. Mʉsã pacʉ ucũsere tʉꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Mʉꞌʉ, Rubén, yʉꞌʉ põꞌrãtimʉꞌtãꞌcʉ niꞌi. Yʉꞌʉ tutuase mʉꞌʉ meꞌrã dʉꞌpocã́tiwʉ. Mʉꞌʉ acabijirã yʉꞌrʉoro añurõ wãcũnoꞌcʉ niꞌi. Tojo nicã, ãpẽrã yʉꞌrʉoro tutuase cʉoyʉꞌrʉnʉꞌcãgʉ̃ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tojo nimigʉ̃, nipeꞌtirã mʉꞌʉ acabijirã buꞌipʉ nisome majã. Maa cãꞌmotaꞌaꞌcã, aco muꞌmu oꞌmayʉꞌrʉbʉroro weronojõ niꞌi. Yʉꞌʉre daꞌracoꞌtego meꞌrã aꞌmetãrãcʉ niwʉ̃. Yʉꞌʉ cãrĩpesarore ñaꞌabutiaro weecʉ niwʉ̃. Bopoyoro weecʉ niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeó, Leví, mʉsã niꞌcõ põꞌrã niyurã, niꞌcãrõnojõ ñaꞌarõ weesetiꞌi. Mʉsã wãmo meꞌrã cumucapijarã niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mʉsã nerẽ, aꞌmerĩ ucũrĩ curare mʉsã meꞌrã ne nisĩꞌrĩtisaꞌa. Mʉsã uayʉꞌrʉrã, pãjãrã masãrẽ wẽjẽwʉ̃. Noꞌo ʉaro weemaꞌarã, wecʉa ye dʉꞌpocãrĩ ʉꞌtacũuse wadarire dʉtesurewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mʉsã uayʉꞌrʉꞌque wapa ñaꞌarõ waꞌarosaꞌa. Te buꞌiri mʉsã pãrãmerã Israe diꞌtapʉre ape curuacjãrã waꞌteropʉ mʉsãrẽ waꞌastecã weegʉti. Mʉsã ye curari meꞌrã nisome majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, mʉꞌʉma mʉꞌʉ maꞌmisʉmʉa, mʉꞌʉ acabijirã mʉꞌʉrẽ añurõ ucũ, ẽjõpeorãsama. Mʉꞌʉrẽ ĩꞌatuꞌtirãrẽ docaqueꞌacã weegʉsaꞌa. Mʉꞌʉ maꞌmisʉmʉa, mʉꞌʉ acabijirã mʉꞌʉrẽ ẽjõpeorã paamuꞌrĩqueꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá, mʉꞌʉ yʉꞌʉ macʉ̃, mʉꞌʉ niꞌcʉ̃ yai uamʉ macʉ̃ weronojõ niꞌi. Waꞌicʉre ñeꞌebaꞌaꞌcʉ pajigʉ yaijo weronojõ paamuꞌrĩqueꞌa, ejaqueꞌamʉjãꞌa. Ne niꞌcʉ̃ mʉꞌʉrẽ caribomasĩtisami. Mʉꞌʉ ĩꞌoduagʉ tutuayʉꞌrʉagʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judá, mʉꞌʉ dutisere ne niꞌcʉ̃ mʉꞌʉrẽ ẽꞌmasome. Téé nipeꞌtirocjãrãrẽ dutiacjʉ aꞌticãpʉ ninuꞌcũgʉ̃saꞌa. Mʉꞌʉrẽ nipeꞌtise macãrĩcjãrã yʉꞌtirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Judá cʉ̃ yagʉ burrore ʉꞌsedapʉ dʉꞌtenʉꞌcõgʉ̃sami. Cʉ̃ macʉ̃ quẽꞌrã añurĩ dapʉre dʉꞌtenʉꞌcõgʉ̃sami. Tojo weegʉ cʉ̃ ye suꞌtire vino ʉꞌsedʉcaco meꞌrã coewéégʉ weronojõ weegʉsami. Te dari peje pĩꞌrĩ dʉcaticã ĩꞌarã, tojo weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Judá caperi ʉꞌsedʉcaco nemorõ ñise niꞌi. Cʉ̃ upicari õpẽco nemorõ butiꞌi. Cʉ̃ pãrãmerã nituriarã na otese, na ecarã nipeꞌtise añurõ waꞌarosaꞌa, nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulṍ, mʉꞌʉ dia pajiri maa sumutopʉ nigʉ̃saꞌa. Topʉre pacase yucʉsʉpawʉ paꞌaejase petari nirõsaꞌa. Téé Sidṍ macãpʉ mʉꞌʉ ye nitʉorosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacar, mʉꞌʉ burro tutuagʉ pʉa ajuro oꞌmase ajuri waꞌteropʉ soocũñagʉ̃ weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mʉꞌʉ ya diꞌta añurõ ejerisãjã soori diꞌta nicã ĩꞌagʉ̃, añurõ tʉꞌsase meꞌrã ãpẽrãrẽ daꞌracoꞌte nigʉ̃saꞌa. Tojo nicã, ti diꞌta añurĩ diꞌta nicã ĩꞌagʉ̃, tojo weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, mʉꞌʉ pũrĩcã mʉꞌʉ yarã masãrẽ dutigʉsaꞌa. Niꞌcã curua Israe curuacjãrãrẽ dutigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan, mʉꞌʉ niꞌcʉ̃ aña maꞌa sumutopʉ cũñagʉ̃ weronojõ mʉꞌʉrẽ ĩꞌatuꞌtirãrẽ uicã weegʉsaꞌa. Cabayu buꞌipʉ pesagʉre bʉrʉdijadutigʉ, cʉ̃ dʉꞌpodiapʉ cũꞌrĩgʉ̃ weronojõ weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Õꞌacʉ̃, yʉꞌʉre wiosere yʉꞌrʉoya, nicʉ niwĩ Jacob. Beꞌro cʉ̃ põꞌrãrẽ nicʉ niwĩ tja: ");
INSERT INTO tuoNT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, yajari masã mʉꞌʉ tiropʉ sãjã́árãsama. Beꞌro mʉꞌʉ peꞌe narẽ wẽjẽ sirutugʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, peje waro baꞌase cʉogʉsami. Tojo weegʉ wiorã baꞌasenojõrẽ ãpẽrãrẽ ecagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalí, niꞌcõ ñama añurã põꞌrãti, ne cãꞌmotaꞌaro marĩrõ sijago weronojõ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","José, niꞌcã da ʉꞌseda aco wijari pe tiropʉ pĩꞌrĩ, peje dʉcati, te dʉpʉri añurõ pĩꞌrĩ, te tʉꞌrʉripʉ páápejaro weronojõ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Cʉ̃rẽ ĩꞌatuꞌtirã bʉemʉjã, caribonuꞌcũcãꞌma. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Jacob wiogʉ Õꞌacʉ̃ tutuayʉꞌrʉgʉ weetamuse meꞌrã José peꞌe omocãrĩ tutuagʉ niyugʉ, cʉ̃ bʉecatjẽrẽ añurõ tuatu, cʉonuꞌcũgʉ̃ weronojõ nimi. Õꞌacʉ̃ta ovejare coꞌtegʉ weronojõ Israe curuacjãrãrẽ coꞌteato. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mʉꞌʉ pacʉ Jacob ẽjõpeogʉ Õꞌacʉ̃ mʉꞌʉrẽ weetamuato. Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃, nipeꞌtise mʉꞌʉrẽ añurõ waꞌacã weeato. Nipeꞌtise añuse ʉꞌmʉse cjase meꞌrã mʉꞌʉrẽ añurõ waꞌacã weeato. Tojo nicã nipeꞌtise aco ʉ̃ꞌcʉ̃arõpʉ nise meꞌrã tojo weeato. Mʉꞌʉ pãrãmerã nituriarã pãjãrã masãputicã weeato. Tojo nicã, mʉꞌʉ ecarã quẽꞌrã mejãrõta pãjãrã masãputiato. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yʉꞌʉ ñecʉ̃sʉmʉa yʉꞌʉre sẽrĩbosaꞌque nemorõ mʉꞌʉrẽ añurõ sẽrĩbosaꞌa. Te mʉꞌʉrẽ sẽrĩbosase añuyʉꞌrʉnʉꞌcãꞌa. Téé ʉ̃rʉ̃pagʉ peꞌticãpʉ mʉꞌʉrẽ sẽrĩbosaꞌque nitʉorosaꞌa. Mʉꞌʉ, mʉꞌʉ maꞌmisʉmʉa waꞌterore Õꞌacʉ̃ besenoꞌcʉ niꞌi. Nipeꞌtise aꞌte ‘Añurõ waꞌato’ ni sẽrĩbosaꞌque mʉꞌʉpʉre ninuꞌcũcãꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamí niꞌcʉ̃ yai uagʉ weronojõ nimi. Ñamiñaꞌcũrõrẽ waꞌicʉre ñeꞌebaꞌaꞌcʉ weronojõ nimi. Ñamicaꞌa peꞌere cʉ̃ baꞌadʉꞌaꞌque diꞌire ãpẽrãrẽ dʉcawaagʉ weronojõ nimi”, nicʉ niwĩ Jacob. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Náta nima doce curaricjãrã Jacob põꞌrã nituriarã. Tere Jacob cʉ̃ põꞌrãrẽ nanʉcʉ̃rẽ añurõ waꞌato nígʉ̃, Õꞌacʉ̃rẽ sẽrĩbosacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Niꞌcã nʉmʉ Jacob cʉ̃ põꞌrãrẽ “Yʉꞌʉ wẽ́rĩ́ca beꞌro aꞌtiro weeapa” ni, dutise cũucʉ niwĩ. “Yʉꞌʉ wẽrĩatjo cãꞌrõ dʉꞌsaꞌa. Yʉꞌʉ wẽ́rĩ́ca beꞌro yʉꞌʉ ñecʉ̃sʉmʉarẽ yááca tutipʉta sĩosõrõcũuapa. Ti tuti Efrṍ hitita masʉ̃ ya diꞌtapʉ nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Canaá diꞌtapʉ ti tuti Macpela wãmetiropʉ nisaꞌa. To Mamre wãmetiro diacjʉ̃pʉ tojasaꞌa. Abrahã ti tutire, ti diꞌta meꞌrãta Efrṍrẽ duucãꞌcʉ niwĩ. Tojo weero ti tuti nipeꞌtirã Abrahã acawererã nituriarãrẽ yaatji tuti nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Topʉ Abrahãrẽ, cʉ̃ nʉmo Sarare yaarã sĩosõrõcũuocãrã niwã. Tojo nicã topʉta Isaare, cʉ̃ nʉmo Rebecare yaacãrã niwã. Yʉꞌʉ quẽꞌrã yʉꞌʉ nʉmo Leare topʉta yaawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ti diꞌta, ti tuti hitita masãrẽ duunoꞌcaro niwʉ̃”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacob cʉ̃ põꞌrãrẽ aꞌtere wéréca beꞌro apaturi ejapeja, wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Cʉ̃ pacʉ wẽrĩcã ĩꞌagʉ̃, José cʉ̃ pacʉ ya upʉre paamuꞌrĩpeja, utigʉta, miꞌmicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Beꞌro acoyeri masã cʉ̃ meꞌrã daꞌrarãrẽ cʉ̃ pacʉ Jacob ya upʉre boaticãꞌto nígʉ̃, ʉꞌse, tojo nicã boatisecore waꞌreduticʉ niwĩ. Na cʉ̃ dutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Te tojo weese cuarenta nʉmʉrĩ cjase nicaro niwʉ̃. Egiptocjãrã masã setenta nʉmʉrĩ cʉ̃ wẽrĩꞌquere bʉjaweticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ticʉse nʉmʉrĩ yʉꞌrʉ́ca beꞌro José faraṍ ya wiꞌipʉ nirã́ meꞌrã ucũcʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —Mʉsã, yʉꞌʉre añurõ ẽjõpeorã, faraṍrẽ aꞌtiro werebosarã waꞌaya: ");
INSERT INTO tuoNT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Joseré cʉ̃ pacʉ cʉ̃ wẽrĩatji dʉporo Canaá diꞌtapʉ cʉ̃ masãpe cʉ̃ basu apóca tutipʉre yaadutiapʉ. ‘Õꞌacʉ̃ wãme meꞌrã tojota weegʉti’, nidutiapʉ. Tojo weegʉ José mʉꞌʉrẽ cʉ̃ pacʉre ‘Yaagʉ waꞌato’, nidutiami. ‘Yaatoja, majãmitojatigʉti’, niami”, niña, ni wereoꞌocʉ niwĩ José. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraṍ cʉ̃rẽ queti oꞌócʉ niwĩ: —Mʉꞌʉ pacʉre yaagʉ waꞌaya. Cʉ̃ weedutiꞌcaronojõta weeya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Beꞌro José cʉ̃ pacʉre yaagʉ waꞌacʉ niwĩ. Nipeꞌtirã wiorã faraṍrẽ daꞌratamurĩ masã Egiptocjãrã Joseré baꞌpatiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tojo nicã, cʉ̃ mijĩ acawererã waro, José acawererã, cʉ̃ maꞌmisʉmʉa waꞌacãrã niwã. Gosẽ́pʉma na põꞌrã wĩꞌmarã, tojo nicã na ecarã seꞌsaro tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ãpẽrã quẽꞌrã surara cabayua wejese coꞌri meꞌrã, tojo nicã ãpẽrã cabayua meꞌrã Joseré baꞌpatiwãꞌcãcãrã niwã. Tojo weerã masã pãjãrã waro nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Na Goren-ha-atad wãmetiro na trigo sʉꞌaweeropʉ etarã, wẽrĩꞌcʉ mijĩrẽ wãcũ, ʉpʉtʉ caricũ, uticãrã niwã. To Jordã́ wãmetiri maa pʉꞌto tojacaro niwʉ̃. Niꞌcã semana José cʉ̃ pacʉ mijĩrẽ wãcũ, bʉjaweticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ti diꞌtapʉ nirã́ cananeo masã na tojo weesere ĩꞌarã, aꞌtiro nicãrã niwã: “Egiptocjãrã masã wẽrĩꞌcãrãrẽ yaarã, pajiro bʉjawetise meꞌrã tojo weesama.” Tojo weerã na tojo weeꞌcarore Abel-mizraim pisucãrã niwã. Dia Jordã́ mujĩpũ mʉjãtiro peꞌe tojasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacob põꞌrã nipeꞌtise na pacʉ dutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Tojo weerã cʉ̃ mijĩrẽ Canaápʉ yaarã waꞌarã miacãrã niwã. Mia, Macpela wãmetiro nirĩ tutipʉ yaacãrã niwã. Ti tutire Abrahã Efrṍ hitita masʉ̃rẽ dúúca tuti nicaro niwʉ̃. Ti tutire Abrahã nipeꞌtirã yʉꞌʉ acawererãrẽ yaatji tuti nirõsaꞌa nígʉ̃, duucʉ niwĩ. Ti diꞌta Mamre wãmetiro diacjʉ̃ peꞌe tojasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","José cʉ̃ pacʉre yááca beꞌro, cʉ̃ maꞌmisʉmʉa, nipeꞌtirã cʉ̃rẽ baꞌpatiꞌcãrã meꞌrã Egiptopʉ majãmitojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na pacʉ Jacob wẽ́rĩ́ca beꞌro José maꞌmisʉmʉa aꞌtiro wãcũcãrã niwã: “Apetero weegʉ José marĩ meꞌrã uasami. Marĩrẽ ĩꞌasĩꞌrĩtibosami. Marĩ cʉ̃rẽ ñaꞌarõ weeꞌquere marĩrẽ aꞌmebosami”, ni wãcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tojo weerã José maꞌmisʉmʉa ãpẽrã meꞌrã “Marĩ pacʉ wẽrĩatji dʉporo aꞌtiro niwĩ”, ni queti oꞌócãrã niwã Josepʉre. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Mʉꞌʉ maꞌmisʉmʉarẽ pajañaꞌcureapa. Na mʉꞌʉrẽ ñaꞌarõ weeꞌquere acobojoya,” niwĩ marĩ pacʉ. “Tojo weegʉ mʉꞌʉ ʉ̃sãrẽ pajañaꞌa, acobojoya. Ʉ̃sã quẽꞌrã mʉꞌʉ pacʉ ẽjõpeoꞌcʉre ẽjõpeorã niꞌi”, ni queti oꞌócãrã niwã. Na tojo nicã tʉꞌogʉ, José ʉpʉtʉ uticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Cʉ̃ utíca beꞌro José maꞌmisʉmʉa cʉ̃ tiropʉ ejacãrã niwã. Cʉ̃rẽ ĩꞌarã, paamuꞌrĩqueꞌa, aꞌtiro nicãrã niwã: —Ʉ̃sã aꞌto niꞌi. Mʉꞌʉrẽ daꞌrawãꞌñacoꞌterã sãjãꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","José peꞌe narẽ yʉꞌticʉ niwĩ: —Ne uiticãꞌña. Yʉꞌʉ Õꞌacʉ̃ mejẽta niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mʉsã yʉꞌʉre ñaꞌarõ weesĩꞌrĩcãrã nimiwʉ̃. Õꞌacʉ̃ peꞌe te ñaꞌase waꞌaboꞌquere añurõ waꞌacã weecʉ niwĩ. Tojo weegʉ pãjãrã masãrẽ ʉjʉaboaboꞌcãrãrẽ yʉꞌrʉweticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tojo weerã mʉsã uiticãꞌña. Yʉꞌʉ mʉsãrẽ, mʉsã põꞌrãrẽ baꞌase oꞌogʉti. José narẽ maꞌise meꞌrã ucũcʉ niwĩ. Tojo weerã ne mejẽcã wãcũnemoticãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José nipeꞌtirã cʉ̃ pacʉ acawererã pãjãrã meꞌrã Egiptopʉre niseticʉ niwĩ. Cʉ̃ ciento diez cʉ̃ꞌmarĩ caticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tojo weegʉ Efraĩ́ põꞌrã cʉ̃ pãrãmerã nituriarãpʉre ĩꞌacʉ niwĩ. Tojo nicã, Manasés macʉ̃ Maquir põꞌrã bajuacã, cʉ̃ põꞌrã weronojõ tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Beꞌro José cʉ̃ maꞌmisʉmʉarẽ nicʉ niwĩ: —Yʉꞌʉ wẽrĩatjo cãꞌrõ dʉꞌsaꞌa. Õꞌacʉ̃ mʉsãrẽ weetamugʉ̃ aꞌtigʉsami. Cʉ̃ Abrahãrẽ, Isaare, Jacore “Canaá diꞌtare oꞌogʉti” níꞌcaronojõta weegʉsami. Aꞌti diꞌtapʉ níꞌcãrãrẽ topʉ miagʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Diacjʉ̃ta Õꞌacʉ̃ mʉsãrẽ weetamugʉ̃ aꞌtigʉsami. Tojo waꞌacã, ye õꞌarĩ mejãrẽ mʉsã miaña. “Õꞌacʉ̃ wãme meꞌrã tojota weerãti”, niña, nicʉ niwĩ. —Jaʉ, Õꞌacʉ̃ wãme meꞌrã mʉꞌʉ níꞌcaronojõ weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","José ciento diez cʉ̃ꞌmarĩ cʉogʉ, Egiptopʉ wẽrĩcʉ niwĩ. Cʉ̃ ya upʉre boatiseco meꞌrã waꞌre, masãacaropʉ misãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israe curuacjãrã Jacob põꞌrã cʉ̃ meꞌrã Egiptopʉ waꞌaꞌcãrã, aꞌticʉrã nicãrã niwã. Nipeꞌtirã nanʉcʉ̃ na nʉmosãnumia, na põꞌrãrẽ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","4","Aꞌticʉrã nicãrã niwã: Rubén, Simeó, Leví, Judá, Isacar, Zabulṍ, Benjamí, Dan, Neftalí, Gad, Aser nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Na nipeꞌtirã Jacob põꞌrã, tojo nicã na pãrãmerã nírã setenta nicãrã niwã. José peꞌe Egiptopʉ nitojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Beꞌropʉ José, cʉ̃ maꞌmisʉmʉa, cʉ̃ acabiji, tojo nicã nipeꞌtirã na ya turicjãrã quẽꞌrã wẽrĩa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Na Israe curuacjãrã peꞌe pãjãrã waro põꞌrãticãrã niwã. Tojo weerã masãputiyʉꞌrʉa, pãjãrã waro waꞌacãrã niwã. Ti diꞌta Egiptopʉre seꞌsa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Beꞌropʉre Egiptore apĩ wiogʉ sãjãcʉ niwĩ. Cʉ̃ José ye cjasere masĩticʉ niwĩ. Cʉ̃́masãrẽ nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Israe curuacjãrã marĩ yʉꞌrʉoro pãjãrã waro nima. Tojo nicã marĩ yʉꞌrʉoro tutuarã nima. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tojo weerã na põꞌrãtinemoticãꞌto nírã, ¿deꞌro weeroʉamitito? Marĩ cãꞌmotaꞌaticãma, aꞌmewẽjẽse waꞌa, marĩrẽ ĩꞌatuꞌtirã meꞌrã aꞌmesʉꞌa, marĩ meꞌrã aꞌmewẽjẽ, marĩ ya diꞌtare wijawãꞌcãbosama”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tojo weerã faraṍ, Egiptocjãrã wiogʉ, tojo nicã ãpẽrã wiorã Egiptocjãrãrẽ sʉꞌori daꞌrase dutiri masãrẽ sõrõcãrã niwã. Tutuaro meꞌrã Israe curuacjãrãrẽ daꞌradutipecãrã niwã. Narẽ cʉ̃ baꞌase nʉrõatje macãrĩrẽ Pitón, Ramsés wãmetise macãrĩrẽ yeeduticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Narẽ pũrõ daꞌradutipemicã, nemorõ masãputicãrã niwã. Tojo weerã Egiptocjãrã narẽ pũrõ uicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Daꞌrase dutiri masã Israe curuacjãrãrẽ pajañaꞌrõ marĩrõ daꞌradutipenemocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Na catiri ʉmʉcore ñaꞌabutiaro piꞌeticã weecãrã niwã. Diꞌta saꞌbeduti, te diꞌta cujirire yeeduti, tojo nicã cãpũ cjasere daꞌradutipecãrã niwã. Aꞌte nipeꞌtise na Israe curuacjãrãrẽ tojo weesere ne pajañaꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Apeyema tja faraṍ numia wĩꞌmarã bajuari cura coꞌterã numia Sifra, Fúa wãmetirãrẽ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Mʉsã hebreo masã numia põꞌrãticã coꞌterã, ʉmʉ, numio niti nírã, añurõ ĩꞌaña. Numio nicã, cũuña. Ʉmʉ pũrĩcãrẽ wẽjẽcãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Cʉ̃ tojo nimicã, coꞌterã numia peꞌe Õꞌacʉ̃rẽ wiopesase meꞌrã tʉꞌoñaꞌrã, wiogʉ cʉ̃ dutisere weeticãrã niwã. Tojo weerã wĩꞌmarã ʉmʉarẽ wẽjẽticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na tojo wẽjẽticã tʉꞌogʉ, faraṍ na numiarẽ pijiocʉ niwĩ: —¿Deꞌro weerã mʉsã wĩꞌmarã ʉmʉarẽ wẽjẽtiati? ni sẽrĩtiñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Na faraṍrẽ yʉꞌticãrã niwã: —Hebreo masã numia Egiptocjãrã numia weronojõ nitima. Na tutuarã numia niyurã, ʉ̃sã etase dʉporo wʉatojacãrã niama, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Na wĩꞌmarã ʉmʉarẽ wẽjẽtiyucã, Israe curuacjãrã pãjãrã waro masãputinemo, nemorõ tutuarã waꞌacãrã niwã. Coꞌterã numia Õꞌacʉ̃rẽ wiopesase meꞌrã tʉꞌoñaꞌyucã, na quẽꞌrãrẽ põꞌrãticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Beꞌro faraṍ nipeꞌtirã Egiptocjãrãrẽ aꞌtiro duticʉ niwĩ: “Nipeꞌtirã hebreo masã ʉmʉa bajuacã, dia Nilopʉ doqueñocõꞌacãꞌña. Numia diaꞌcʉ̃rẽ dʉꞌaya”, nicʉ niwĩ faraṍ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Faraṍ cʉ̃ Israe curuacjãrã põꞌrã ʉmʉarẽ wẽjẽdutiri cura niꞌcʉ̃ ʉmʉ Leví ya curuacjʉ̃ ti curuacjõ meꞌrãta omocã dʉꞌtecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Co nijĩpaco waꞌa, ʉmʉrẽ põꞌrãtico niwõ. Cʉ̃ wĩꞌmagʉ̃ añugʉ̃ nicã ĩꞌagõ, iꞌtia mujĩpũ cʉ̃rẽ nʉocʉoco nimiwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Co cʉ̃rẽ nʉopõtẽotibosaꞌa majã nígõ, niꞌcã bati na suꞌáca batire mii, aco sãjãrĩ nígõ, ope meꞌrã biꞌaco niwõ. Tojo weetuꞌajanʉꞌcõ, wĩꞌmagʉ̃rẽ ti batipʉ sãaco niwõ. Sãatoja, dia Nilo sumuto nise queri waꞌteropʉ poꞌobʉroco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Poꞌobʉrotoja, cʉ̃ maꞌmiorẽ “¿Deꞌro waꞌagʉsari?” nígõ, “Yoacureropʉ tojanʉꞌcã ĩꞌaoꞌoña”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","To beꞌro faraṍ macõ diapʉ uꞌago buꞌaco niwõ. Core daꞌracoꞌterã numia ti maa sumuto sijabaqueꞌari cura, co peꞌe ti batire te queri waꞌteropʉ paꞌsacã ĩꞌabocaco niwõ. Ĩꞌa, niꞌcõ core daꞌracoꞌtegore piji, ti batire miitidutico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ti batire pão, wĩꞌmagʉ̃ utigʉre ĩꞌaco niwõ. Cʉ̃rẽ ĩꞌagõ, pũrõ pajañaꞌco niwõ. —Ãꞌrĩ wĩꞌmagʉ̃ hebreo masã macʉ̃ nisami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Co tojo weecã ĩꞌagõ, cʉ̃ maꞌmio ĩꞌawãꞌcã, faraṍ macõrẽ nico niwõ: —¿Niꞌcõ hebreo masõ ãꞌrĩ wĩꞌmagʉ̃rẽ miomasõacjore yʉꞌʉ pijigo waꞌacã ʉasari? nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","—Ʉ̃ʉ, niꞌcõ pijigo waꞌaya, nico niwõ. Co tojo nicã tʉꞌogo, wĩꞌmagʉ̃ pacore pijigo waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Beꞌro cʉ̃ paco etacã ĩꞌagõ, faraṍ macõ core nico niwõ: —Ãꞌrĩ wĩꞌmagʉ̃rẽ mia, yʉꞌʉre masõbosaya. Yʉꞌʉ mʉꞌʉrẽ wapayegoti, nico niwõ. Tojo weego wĩꞌmagʉ̃ paco cʉ̃rẽ mia, masõco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Cʉ̃ bʉcʉcure nicãpʉ, faraṍ macõrẽ wiaco niwõ. Co peꞌe co macʉ̃ diácjʉ̃rẽ weronojõ tojacã weeco niwõ. Cʉ̃rẽ Moisé wãme õꞌoco niwõ. “Diapʉ poꞌobʉroꞌcʉre miiwʉ̃” nígõ, tojo wãme õꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Peje cʉ̃ꞌmarĩ beꞌro Moisé bʉcʉpʉ nígʉ̃, niꞌcã nʉmʉ cʉ̃ acawererãrẽ ĩꞌagʉ̃ waꞌacʉ niwĩ. Topʉ hebreo masãrẽ ʉpʉtʉ daꞌradutipecã ĩꞌacʉ niwĩ. Niꞌcʉ̃ Egiptocjʉ̃ cʉ̃ acaweregʉ hebreo masʉ̃rẽ paacã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Cʉ̃rẽ tojo weecã ĩꞌa, añurõ ĩꞌastepeo, “Ãpẽrã marĩma” ni, Egiptocjʉ̃rẽ wẽjẽ, nucũporopʉ yaacũucãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ape nʉmʉ cʉ̃ acawererã nirõpʉ waꞌacʉ niwĩ tja. Pʉarã hebreo masãrẽ aꞌmequẽcã ĩꞌacʉ niwĩ. Tojo wee, apĩrẽ paagʉre sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weegʉ mʉꞌʉ acaweregʉre paati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Cʉ̃ peꞌe yʉꞌticʉ niwĩ: —¿Noa mʉꞌʉrẽ ʉ̃sãrẽ beseacjʉ, wiogʉ sõrõati? ¿Mʉꞌʉ Egiptocjʉ̃rẽ wẽjẽꞌcaro weronojõ yʉꞌʉre wẽjẽsĩꞌrĩsari? nicʉ niwĩ. Tere tʉꞌogʉ, Moisé pũrõ uicʉ niwĩ. “¡Acoe! Yʉꞌʉ Egiptocjʉ̃rẽ wẽjẽꞌquere masĩtojapã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faraṍ cʉ̃ Egiptocjʉ̃rẽ wẽjẽꞌquere tʉꞌogʉ, Moisére wẽjẽsĩꞌrĩgʉ̃, cʉ̃rẽ ñeꞌeduticʉ nimiwĩ. Moisé peꞌe faraṍrẽ duꞌtigʉ, Madiã́ wãmetiropʉ nisetigʉ waꞌacʉ niwĩ. Topʉ etagʉ, aco wijari pe na seꞌéca pe pʉꞌto ejanujãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madiã́cjʉ̃ paꞌi, Reuel wãmetigʉ siete numia põꞌrãticʉ niwĩ. Ti nʉmʉrẽta na numia ti pepʉ aco waarã waꞌacãrã niwã. Na pacʉ yarã ovejare tĩarãtirã, sĩꞌrĩse coꞌripʉ aco pio muꞌmuorã aꞌticãrã nimiwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ãpẽrã ʉmʉa oveja, cabra coꞌterã peꞌe eta, na numiarẽ cõꞌatõrõcãꞌcãrã niwã. Na tojo weecã ĩꞌagʉ̃, Moisé wãꞌcãnʉꞌcã, na numiarẽ caribocã cãꞌmotaꞌacʉ niwĩ. Beꞌro acore waamíí, sĩꞌrĩse coꞌripʉ piosãa, na yarã ovejare tĩacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Na numia pacʉ tiropʉ dajacã, narẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weerã niꞌcãcãrẽ maata dajati? ");
INSERT INTO tuoNT_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Na cʉ̃rẽ yʉꞌticãrã niwã: —Niꞌcʉ̃ Egiptocjʉ̃ oveja cabra coꞌterãrẽ cãꞌmotaꞌabosami. Beꞌro aco waamíí, marĩ yarã ovejare tĩami. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Na tojo nicã tʉꞌogʉ, narẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Noꞌopʉ niati cʉ̃? ¿Deꞌro weerã cʉ̃rẽ cõꞌawãꞌcãtiati? Cʉ̃rẽ baꞌadutirã pijirã waꞌaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Tojo wee Moisé Reuel ya wiꞌipʉ eja, baꞌacʉ niwĩ. Cʉ̃ “Ʉ̃sã meꞌrã tojayá” nicã, “Jaʉ” ni, na meꞌrã niseticʉ niwĩ. Beꞌro Reuel cʉ̃ macõ Séforare Moisére numisocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Beꞌro co nijĩpaco waꞌa, niꞌcʉ̃ macʉ̃tico niwõ. Moisé cʉ̃rẽ Gersón wãme õꞌocʉ niwĩ. “Yʉꞌʉ ãpẽrã ye diꞌtapʉre aperocjʉ̃ weronojõ tʉꞌoñaꞌa. Tojo weegʉ cʉ̃rẽ Gersón wãme õꞌoꞌo”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Peje cʉ̃ꞌmarĩ beꞌro Egiptocjʉ̃ wiogʉ wẽrĩa waꞌacʉ niwĩ. Tojo wẽrĩmicã, Egiptocjãrã Israe curuacjãrãrẽ ʉpʉtʉ daꞌradutipe, piꞌeticã weenuꞌcũcãꞌcãrã niwã. Tojo weerã na bʉjawetiyʉꞌrʉa, Õꞌacʉ̃rẽ “Ʉ̃sãrẽ weetamuña”, ni sẽrĩ, caricũnuꞌcũcãꞌcãrã niwã. Õꞌacʉ̃ na caricũsere tʉꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tere tʉꞌogʉ, cʉ̃ todʉporopʉ Abrahã, Isaa, Jacob meꞌrã apoꞌquere wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tojo weegʉ na piꞌetisere ĩꞌagʉ̃, pajañaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisé cʉ̃ mañecʉ̃ Jetro yarã ovejare coꞌtecũcʉ niwĩ. Jetro Madiã́cjʉ̃ paꞌi nicʉ niwĩ. Niꞌcã nʉmʉ Moisé Jetro yarã ovejare masã marĩrõpʉ yʉꞌrʉa, téé Õꞌacʉ̃ yagʉ ʉ̃rʉ̃gʉ̃ Horeb wãmeticjʉpʉ miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Topʉ niꞌcʉ̃ zarza wãmetiri siti ʉ̃jʉ̃rĩ põꞌrã decopʉ Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃ cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, cʉ̃rẽ bajuacʉ niwĩ. Ti pecameꞌe ʉ̃jʉ̃caro niwʉ̃, ʉ̃jʉ̃rõ peꞌe. Mejõ ʉ̃jʉ̃peꞌtidijaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tere pũrõ ĩꞌagʉ̃, Moisé aꞌtiro wãcũcʉ niwĩ: “¿Ñeꞌenojõ niti tojo waꞌase? ¿Deꞌro weero ti zarza ʉ̃jʉ̃peꞌtiweti? nígʉ̃, ĩꞌagʉ̃ waꞌagʉti,” ni wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Õꞌacʉ̃ Moisére ti meꞌerẽ ĩꞌawãꞌcãticã ĩꞌacʉ niwĩ. Ti zarza siti decopʉ nígʉ̃, cʉ̃rẽ pisucʉ niwĩ: —¡Moisé! nicʉ niwĩ. —Aꞌtopʉ niꞌi, ni yʉꞌticʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Tojo nitoja, Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Pʉꞌtoacãpʉ aꞌtiticãꞌña. Mʉꞌʉ ye sapatu caserire tuweeya. Mʉꞌʉ ʉꞌtacũurõ añurõ yʉꞌʉ nirṍ waro niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yʉꞌʉ mʉꞌʉ ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob ẽjõpeoꞌcʉ Õꞌacʉ̃ niꞌi, nicʉ niwĩ. Moisé Õꞌacʉ̃rẽ ĩꞌaui nicʉ niwĩ. Tojo weegʉ cʉ̃ diapoare moꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Beꞌro Õꞌacʉ̃ ninemocʉ niwĩ tja: —Yarã masã Israe curuacjãrã na Egiptopʉ piꞌetisere añurõ ĩꞌapʉ. Narẽ sʉꞌori daꞌrase dutiri masã daꞌradutipesere caributirã caricũcã tʉꞌoapʉ. Na piꞌetisere añurõ masĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tojo weegʉ narẽ yʉꞌrʉogʉ, dijatiapʉ. Egiptocjãrã doca nirãrẽ miiwĩorẽgʉ̃ti. Ti diꞌtapʉ nirãrẽ miiwija, añurĩ diꞌta, pajiri diꞌtapʉ miagʉ̃ti. Cabra õpẽco, mumiaco pajiro aco oꞌmabʉroro weronojõ nirĩ diꞌta niꞌi. Cananeo masã, hitita masã, amorreo masã, ferezeo masã, heveo masã, jebuseo masã na nirĩ diꞌta niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Israe curuacjãrã narẽ daꞌradutipesere “Caributia waꞌasaꞌa” ni caricũsere tʉꞌoapʉ. Tojo nicã, Egiptocjãrã narẽ ñaꞌarõ weepecã ĩꞌapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tojo weegʉ waꞌabaqueꞌoya. Yarã masã Israe curuacjãrãrẽ Egiptopʉre miiwĩrõdutigʉ, faraṍ tiropʉ mʉꞌʉrẽ oꞌógʉtigʉ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Cʉ̃ tojo nicã tʉꞌogʉ, Moisé Õꞌacʉ̃rẽ nicʉ niwĩ: —Yʉꞌʉ mejõ nigʉ̃ niꞌi. Tojo weegʉ ¿deꞌro weegʉ yʉꞌʉ faraṍ tiropʉ waꞌa, Israe curuacjãrã Egiptopʉ nirãrẽ miiwĩrõbosari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Õꞌacʉ̃ cʉ̃rẽ aꞌtiro ni yʉꞌticʉ niwĩ: —Yʉꞌʉ mʉꞌʉ meꞌrã nigʉ̃saꞌa. Yarã masã Egiptopʉ nirãrẽ miiwĩrṍca beꞌro mʉsã nipeꞌtirã aꞌtigʉ ʉ̃rʉ̃gʉ̃pʉ yʉꞌʉre eꞌcatipeorãsaꞌa. Tojo waꞌacã, “Diacjʉ̃ta Õꞌacʉ̃ yʉꞌʉre oꞌoámi”, ni masĩgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moisé peꞌe Õꞌacʉ̃rẽ aꞌtiro ni yʉꞌtinemocʉ niwĩ: —Yʉꞌʉ Egiptopʉ waꞌa, Israe curuacjãrãrẽ “Õꞌacʉ̃, marĩ ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob wiogʉ mʉsã tiropʉ yʉꞌʉre oꞌoámi” ni werecã, na yʉꞌʉre “¿Deꞌro wãmetiti cʉ̃?” ni sẽrĩtiñaꞌbosama. To pũrĩcãrẽ, ¿narẽ deꞌro ni yʉꞌtibosari? ");
INSERT INTO tuoNT_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉta niꞌi niwʉagʉta. Israe curuacjãrãrẽ weregʉ, “Yʉꞌʉta niꞌi” nigʉ̃́ mʉsã tiropʉ yʉꞌʉre oꞌoámi, niña. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Apeye Õꞌacʉ̃ Moisére nicʉ niwĩ tja: —Israe curuacjãrãrẽ aꞌtiro ni wereya: “Õꞌacʉ̃, mʉsã ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob wiogʉta mʉsã tiropʉ yʉꞌʉre oꞌoámi”, ni wereya. Aꞌte yʉꞌʉ wãme ninuꞌcũcãꞌrõsaꞌa. Nipeꞌtirã beꞌrocjãrãpʉ aꞌti wãmerẽ yʉꞌʉre pisunuꞌcũcãꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Egiptopʉ waꞌa weetjĩagʉ̃, Israe curuacjãrã wiorãrẽ neocũu, aꞌtiro niña: “Õꞌacʉ̃, mʉsã ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob wiogʉ, yʉꞌʉre bajuami. Mʉsã ye cjasere aꞌtiro niami: ‘Narẽ añurõ ĩꞌanʉrʉ̃apʉ. Egiptocjãrã narẽ ñaꞌarõ weepesere ĩꞌapʉ’, niami. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Apeye yʉꞌʉre ninemoami: ‘Egiptocjãrã narẽ ñaꞌarõ weepesere yʉꞌrʉweticã weegʉsaꞌa,’ niami. Tojo wee mʉsãrẽ ti diꞌtapʉ miiwija, cananeo masã, hitita masã, amorreo masã, ferezeo masã, heveo masã, jebuseo masã nirĩ diꞌtapʉ miagʉ̃sami. Ti diꞌta añurĩ diꞌta cabra õpẽco, mumiaco aco oꞌmabʉroro weronojõ nirĩ diꞌta nisaꞌa”, ni weredutiami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Mʉꞌʉ wiorãrẽ tojo werecã, mʉꞌʉrẽ yʉꞌtirãsama. Tojo weegʉ Egiptocjʉ̃ wiogʉ tiropʉ na meꞌrã waꞌaya. Cʉ̃rẽ aꞌtiro ni wereya: “Õꞌacʉ̃, hebreo masã wiogʉ, ʉ̃sãrẽ põtẽrĩgʉ̃ ejami. Tojo weegʉ iꞌtia nʉmʉ waꞌaro ʉ̃sãrẽ yucʉ marĩrõ, masã marĩrõpʉ duꞌuoꞌoya. Topʉ Õꞌacʉ̃ ʉ̃sã wiogʉre waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeorã waꞌarãti”, niña. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mʉsã tojo nimicã, yʉꞌʉ tutuaro meꞌrã cʉ̃rẽ weeĩꞌoticã, Egiptocjʉ̃ wiogʉ mʉsãrẽ duꞌuwĩrõsome. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tojo weegʉ yʉꞌʉ tutuasere ĩꞌogʉ̃, peje ĩꞌa ʉcʉase meꞌrã Egiptocjãrãrẽ buꞌiri daꞌregʉti. Tojo wééca beꞌro faraṍ mʉsãrẽ duꞌuwĩrõgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Apeyema, yʉꞌʉ Egiptocjãrã mʉsãrẽ añurõ wãcũcã weegʉti. Tojo weerã apeyenojõ marĩrã waꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nipeꞌtirã Israe curuacjãrã numia Egiptocjãrã numia na ye wiꞌseri pʉꞌto nirãrẽ, tojo nicã ãpẽrã numia na ya wiꞌipʉ nirãrẽ uru meꞌrã weeꞌque, plata meꞌrã weeꞌque, tojo nicã suꞌti sẽrĩrãsama. Te suꞌti na põꞌrã sãñatje nirõsaꞌa. Tojo wee Egiptocjãrã cʉose añusere miapeꞌocãꞌrãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moisé Õꞌacʉ̃rẽ yʉꞌticʉ niwĩ: —Na yʉꞌʉ tojo nisere ẽjõpeosome. Tojo nicã yʉꞌʉ dutisere yʉꞌtisome. Yʉꞌtironojõ oꞌorã, aꞌtiro peꞌe nirãsama: “Õꞌacʉ̃ mʉꞌʉrẽ bajuatiapĩ”, nirãsama, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Õꞌacʉ̃, “¿Mʉꞌʉ omocãpʉre ñeꞌenojõrẽ cʉoti?” ni sẽrĩtiñaꞌcʉ niwĩ. “Yʉꞌʉ tuacjʉ niꞌi”, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","—Tigʉre nucũcãpʉ doquecũuña, nicʉ niwĩ Õꞌacʉ̃. Moisé tere tʉꞌogʉ, nucũcãpʉ doquecũucʉ niwĩ. Cʉ̃ tojo weecãta, tigʉ tuacjʉ aña dojocaro niwʉ̃. Tojo waꞌacã ĩꞌagʉ̃, Moisé ui dustimajãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Õꞌacʉ̃ peꞌe cʉ̃rẽ nicʉ niwĩ: —Omocãrẽ sĩ́oo, cʉ̃ pĩcõrõrẽ ñeꞌeña. Moisé cʉ̃ omocãrẽ sĩ́oo, aña pĩcõrõrẽ ñeꞌecʉ niwĩ. Cʉ̃ tojo ñeꞌecãta, aña nimiꞌcʉ tuacjʉ dojocaro niwʉ̃ tja. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","—Aꞌtere ĩꞌarã, “Õꞌacʉ̃ na ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob wiogʉ cʉ̃rẽ bajuapĩ”, nirãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Beꞌro Õꞌacʉ̃ ninemocʉ niwĩ: —Niꞌcãrõacãrẽ mʉꞌʉ ya omocãrẽ mʉꞌʉ ya suꞌtiro doca cutiro tiropʉ sĩosõrõña, nicʉ niwĩ. Cʉ̃ tojo nicã, Moisé cʉ̃ ya omocãrẽ sĩosõrõcʉ niwĩ. Beꞌro cʉ̃ ya omocãrẽ miiwĩrõ, ti omocãrẽ cãmi boari omocã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Tere ĩꞌagʉ̃, Õꞌacʉ̃ nicʉ niwĩ: —Apaturi mʉꞌʉ ya omocãrẽ mʉꞌʉ ya suꞌtiro doca cutiro tiropʉ sĩosõrõña tja. Õꞌacʉ̃ dutironojõta Moisé weecʉ niwĩ. Cʉ̃ ya omocãrẽ miiwĩrõcãta, nipeꞌtiro cʉ̃ upʉ weronojõ añurĩ omocã tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Beꞌro Õꞌacʉ̃ ninemocʉ niwĩ: —Mʉꞌʉ nimʉꞌtãse weeĩꞌose meꞌrã ẽjõpeotirã, mʉꞌʉ dutisere weetirã, apetero weerã beꞌro apaturi weeĩꞌose meꞌrã ẽjõpeobosama. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mʉꞌʉrẽ aꞌte pʉaro mʉꞌʉ weeĩꞌose meꞌrã ẽjõpeoti, mʉꞌʉ dutisere weeticãma, aꞌtiro weeya. Diapʉ acore waamíí, nucũcãpʉ piocũoña. Mʉꞌʉ topʉ waamíí piocũse nucũcãpʉ dí dojorosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","—Acoe, yʉꞌʉ wiogʉ. Yʉꞌʉ ucũmeꞌrĩgʉ̃ niweꞌe. Todʉporopʉ, tojo nicã mʉꞌʉ niꞌcãrõacã yʉꞌʉ mʉꞌʉ meꞌrã ucũcã quẽꞌrãrẽ añurõ ucũmasĩtisaꞌa. Nipeꞌtisetiri ucũgʉ̃, cuꞌcu nisaꞌa, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —¿Noa masãrẽ ucũmasĩcã weeri? ¿Noa narẽ tʉꞌoticã, ucũticã weeri? ¿Noa narẽ ĩꞌamasĩcã, o caperi bajuticã weeri? Yʉꞌʉta tojo weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tojo weegʉ mʉꞌʉ na masã tiropʉ waꞌaya. Mʉꞌʉ narẽ ucũcã weetamugʉ̃ti. Mʉꞌʉ narẽ ucũatjere yʉꞌʉ mʉꞌʉrẽ weregʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisé ne waꞌasĩꞌrĩticʉ niwĩ. Tojo weegʉ aꞌtiro nicʉ niwĩ: —Acoe, yʉꞌʉ wiogʉ. Apĩrẽ waꞌaduticureya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tere tʉꞌogʉ, Õꞌacʉ̃ Moisé meꞌrã ua waꞌacʉ niwĩ. Tojo weegʉ cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ maꞌmi Aarṍ peꞌe añurõ ucũmeꞌrĩgʉ̃ nimi. Mʉꞌʉ weronojõ Leví ya curuacjʉ̃ nimi. Cʉ̃ mʉꞌʉrẽ põtẽrĩgʉ̃ aꞌtisami. Mʉꞌʉrẽ ĩꞌagʉ̃, ʉpʉtʉ eꞌcatigʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Cʉ̃ meꞌrã ucũña. Cʉ̃ masãrẽ ucũatjere añurõ wereya. Yʉꞌʉ mʉsã pʉarãrẽ ucũcã weegʉti. Mʉsãrẽ, mʉsã weeatjere queoro weregʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Mʉꞌʉ Aarṍrẽ ucũgʉ̃, yʉꞌʉ Õꞌacʉ̃ cʉ̃rẽ ucũgʉ̃ weronojõ ucũgʉ̃saꞌa. Aarṍ peꞌe mʉꞌʉ weresere masãrẽ wereturiagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Aꞌtigʉ tuacjʉre miaña. Tigʉ meꞌrã peje ĩꞌa ʉcʉase weeĩꞌogʉ̃saꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisé cʉ̃ mañecʉ̃ Jetro ya wiꞌipʉ dajagʉ, cʉ̃rẽ nicʉ niwĩ: —Yʉꞌʉ apaturi Egipto diꞌtapʉ waꞌacã yʉꞌʉre duꞌuoꞌoya. Topʉ yʉꞌʉ acawererã waro nisama. Na catimiti nígʉ̃, narẽ ĩꞌasĩꞌrĩgʉ̃coro, nicʉ niwĩ. —Jaʉ, añurõ waꞌaya, ni yʉꞌticʉ niwĩ Jetro. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisé cʉ̃ Madiã́ wãmetiropʉ nícaterore Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Egiptopʉ dajatojaaya. Mʉꞌʉrẽ wẽjẽsĩꞌrĩmiꞌcãrã wẽrĩpeꞌtiatojama. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Cʉ̃ tojo nicã tʉꞌogʉ, Moisé cʉ̃ nʉmorẽ, cʉ̃ põꞌrãrẽ “Teꞌa” nígʉ̃, niꞌcʉ̃ wĩꞌmagʉ̃ burro buꞌipʉ narẽ miipeo, Egiptopʉ sʉꞌori dajatojaacʉ niwĩ. Tojo nicã tuacjʉ, Õꞌacʉ̃ cʉ̃rẽ miadutiꞌcʉre miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Beꞌro Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: —Yʉꞌʉ mʉꞌʉrẽ peje ĩꞌa ʉcʉasere weeĩꞌomasĩcã weeapʉ. Tojo weegʉ mʉꞌʉ Egiptopʉre etagʉ, faraṍ ĩꞌorõpʉ te pejere weeĩꞌoña. Yʉꞌʉ peꞌe faraṍrẽ mʉsãrẽ yʉꞌrʉnʉꞌcãcã weegʉti. Tojo weegʉ Israe curuacjãrãrẽ duꞌuwĩrõsome. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Cʉ̃ tojo weecã, mʉꞌʉ cʉ̃rẽ nigʉ̃saꞌa: “Ʉ̃sã wiogʉ Õꞌacʉ̃ aꞌtiro niami: ‘Israe curuacjãrã yʉꞌʉ macʉ̃, masã maꞌmi weronojõ nima. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Yʉꞌʉre eꞌcatipeorã waꞌacã, narẽ duꞌuwĩrõña’, mʉꞌʉrẽ nitojamiapʉ. Mʉꞌʉ peꞌe narẽ duꞌuwĩrõtiapʉ. Tojo weegʉ mʉꞌʉ macʉ̃ masã maꞌmirẽ wẽjẽgʉ̃saꞌa”, ni werecʉ niwĩ Õꞌacʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Moisé maꞌapʉ waꞌari curare Õꞌacʉ̃ peꞌe Aarṍrẽ aꞌtiro nicʉ niwĩ: “Masã marĩrõ, yucʉ marĩrõpʉ waꞌa, mʉꞌʉ acabiji Moisére põtẽrĩgʉ̃ waꞌaya.” Tere tʉꞌogʉ, Aarṍ waꞌa, Moisére Õꞌacʉ̃ yagʉ ʉ̃rʉ̃gʉ̃pʉ põtẽrĩgʉ̃ waꞌacʉ niwĩ. Topʉ cʉ̃rẽ bocaejagʉ, põtẽrĩ, añudutigʉ miꞌmicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Beꞌro Moisé, Aarṍrẽ Õꞌacʉ̃ cʉ̃rẽ weredutiꞌquere, tojo nicã peje cʉ̃ ĩꞌa ʉcʉase ĩꞌorãsaꞌa níꞌquere werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Tuꞌajanʉꞌcõ, na pʉarãpʉta Israe curuacjãrã wiorãrẽ neocũurã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Na tiropʉ ejacã, Aarṍ nipeꞌtise Õꞌacʉ̃ Moisére níꞌquere werepeꞌocãꞌcʉ niwĩ. Tojo nicã, masã ĩꞌorõpʉre, ĩꞌa ʉcʉase Õꞌacʉ̃ narẽ weeĩꞌodutiꞌquere weeĩꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Masã tere ĩꞌarã, cʉ̃ níꞌquere ẽjõpeocãrã niwã. Õꞌacʉ̃ na piꞌetisere ĩꞌa, narẽ pajañaꞌcã tʉꞌorã, cʉ̃rẽ eꞌcatipeorã, ejaqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moisé, Aarṍ Israe curuacjãrã wiorã meꞌrã ucṹca beꞌro, faraṍ tiropʉ waꞌa, cʉ̃rẽ aꞌtiro nicãrã niwã: —Õꞌacʉ̃, Israe curuacjãrã wiogʉ, mʉꞌʉrẽ aꞌtiro weredutiami: “Yarã masãrẽ masã marĩrõ, yucʉ marĩrõpʉ duꞌuoꞌoya. Na topʉ yʉꞌʉre eꞌcatipeorã, bosenʉmʉ weepeorãsama”, niami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tere tʉꞌogʉ, faraṍ peꞌe aꞌtiro yʉꞌticʉ niwĩ: —¿Noanojõ niti mʉsã wiogʉ nigʉ̃́? ¿Deꞌro wee cʉ̃ dutisere tʉꞌo, Israe curuacjãrãrẽ duꞌuwĩrõbosari? Mʉsã “ʉ̃sã wiogʉ Õꞌacʉ̃” mʉsã nigʉ̃rẽ masĩtisaꞌa. Tojo nicã Israe curuacjãrãrẽ ne duꞌuwĩrõsome, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Faraṍ tojo nicã tʉꞌorã, Moisé, Aarṍ cʉ̃rẽ nicãrã niwã: —Õꞌacʉ̃, hebreo masã wiogʉ, ʉ̃sãrẽ põtẽrĩgʉ̃ aꞌticʉ niami. Tojo weerã ʉ̃sã masã marĩrõ, yucʉ marĩrõpʉ waꞌarãsaꞌa. Iꞌtia nʉmʉ waꞌanoꞌrõsaꞌa. Topʉ ʉ̃sã wiogʉ Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeorã waꞌarãsaꞌa. Tojo weeticãma, duti pũrĩse meꞌrã ʉ̃sãrẽ buꞌiri daꞌregʉsami. Tojo weetigʉ, aꞌmewẽjẽse meꞌrã wẽrĩcã weegʉsami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tere tʉꞌogʉ, faraṍ peꞌe aꞌtiro nicʉ niwĩ: —Moisé, Aarṍ, ¿deꞌro weerã masãrẽ daꞌraduꞌucã weeti? Daꞌrarã waꞌato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Apeyere faraṍ nicʉ niwĩ: —Niꞌcãrõacãma Israe curuacjãrã aꞌti diꞌtapʉre pãjãrã waro masãputima. ¿Na pãjãrãrẽ daꞌraduꞌucã weesĩꞌrĩrã weeti? ");
INSERT INTO tuoNT_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Na tojo níca nʉmʉrẽta faraṍ sʉꞌori daꞌrase dutiri masãrẽ, tojo nicã Israe curuacjãrã narẽ dutituriarãrẽ aꞌtiro duticʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","—Mʉsã Israe curuacjãrãrẽ na wiꞌseri weerã yeese cujirire weedutirã, tábutire oꞌoticãꞌña majã. Na basu waꞌa weetjĩarã tábutire miirã waꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Todʉporo na wiꞌseri weerã yeeꞌque cujiri weeꞌcarocãꞌrota weeato tja. Ne niꞌcã cuji dʉoticãꞌto. Na nijĩsijarã bajuróma aꞌtiro caricũma: “Teꞌa, marĩ wiogʉ Õꞌacʉ̃rẽ eꞌcatipeorã, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeorã waꞌarã”, nima. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Narẽ nemorõ tutuaro daꞌranemocã weeya. Tojo weese meꞌrã narẽ nisoo weresere wãcũsome, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tojo weerã sʉꞌori daꞌrase dutiri masã, tojo nicã Israe curuacjãrã narẽ dutituriarã Israe curuacjãrã wiorã tiropʉ masãrẽ weredutirã waꞌacãrã niwã: —Faraṍ mʉsãrẽ niꞌcãcã meꞌrã ne tábutire oꞌonemodutitiami. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Niꞌcãrõacãrẽ mʉsã basuta tere mʉsã noꞌo bocaro aꞌmasijarã waꞌarãsaꞌa. Tojo weemirã, todʉporo mʉsã yeeꞌque cujirinʉcʉ̃ta yeerãsaꞌa tja. Ne dʉosome, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tere tʉꞌorã, Israe curuacjãrã nipeꞌtiro Egiptopʉ tábutire aꞌmarã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Faraṍ sʉꞌori daꞌrase dutiri masã, nipeꞌtise nʉmʉrĩ masãrẽ na todʉporo oꞌoꞌque cujiricãꞌrõta oꞌoduticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tojo nicã Egiptocjãrãta Israe curuacjãrã narẽ dutituriarãrẽ paamʉjã, aꞌtiro nicãrã niwã: —¿Deꞌro weerã mʉsã ñamicaꞌa, niꞌcãcã quẽꞌrãrẽ todʉporopʉ mʉsã weeꞌcarocãꞌrõta te cujirire weerã ẽmʉejaweti? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Israe curuacjãrã narẽ dutituriarã peꞌe faraṍ tiropʉ cʉ̃rẽ aꞌtiro ni wererã waꞌacãrã niwã: —Wiogʉ, ʉ̃sã mʉꞌʉrẽ daꞌracoꞌterãrẽ ¿deꞌro weegʉ tojo ñaꞌarõ weeti? ");
INSERT INTO tuoNT_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Mʉꞌʉ yarã sʉꞌori daꞌrase dutiri masã ʉ̃sãrẽ tábutire oꞌotima. Tere oꞌotimirã, “Ticʉse cujiri weeya”, nima. Tojo nicã, ʉ̃sãrẽ paama. Ʉ̃sã mejẽta buꞌiritiꞌi. Wiogʉ, mʉꞌʉ yarã daꞌrase dutiri masã buꞌiritima, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faraṍ peꞌe narẽ yʉꞌticʉ niwĩ: —Mʉsã nijĩsijarã niꞌi. Tojo weerã aꞌtiro ninuꞌcũꞌu: “Ʉ̃sã wiogʉ Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeorã waꞌacã duꞌuoꞌoya”, niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Daꞌrarã waꞌaya majã. Mʉsãrẽ tábuti oꞌotimicã, todʉporo mʉsã yeeꞌque cujiricãꞌrõta yeeya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israe curuacjãrã narẽ dutituriarã faraṍ “Ticʉse cujirita yeeya” nicã tʉꞌorã, diasaꞌro tʉꞌoñaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Na faraṍ tiropʉ níꞌcãrã wijaarã, Moisére, Aarṍrẽ narẽ coꞌteꞌcãrãrẽ bocaejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Narẽ aꞌtiro nicãrã niwã: —Õꞌacʉ̃ mʉsã weepetíyeꞌquere ĩꞌa, mʉsãrẽ buꞌiri daꞌreato. Faraṍ, tojo nicã ãpẽrã cʉ̃rẽ sʉꞌori daꞌrase dutiri masã ʉ̃sãrẽ ñaꞌarõ ĩꞌatuꞌtima. Mʉsã basuta cʉ̃rẽ diꞌpjĩ oꞌo, ʉ̃sãrẽ wẽjẽdutirã weronojõ weeapã. Tojo weerã mʉsãta buꞌiritiꞌi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Na tojo nicã tʉꞌogʉ, Moisé Õꞌacʉ̃rẽ aꞌtiro ni ñubue, sẽrĩcʉ niwĩ: —Wiogʉ, ¿deꞌro weegʉ mʉꞌʉ ãꞌrã masãrẽ ñaꞌarõ weeti? ¿Deꞌro weedutigʉ yʉꞌʉre aꞌtopʉ aꞌtidutiati? ");
INSERT INTO tuoNT_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mʉꞌʉ ye cjasere yʉꞌʉ faraṍ meꞌrã ucũnʉꞌcãca nʉmʉ meꞌrã, cʉ̃ mʉꞌʉ yarã masãrẽ nemorõ ñaꞌarõ weenuꞌcũcãꞌmi. Mʉꞌʉ peꞌe mʉꞌʉ yarã masãrẽ ne yʉꞌrʉweticã weeweꞌe, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Moisé Õꞌacʉ̃rẽ sẽ́rĩ́ca beꞌro Õꞌacʉ̃ aꞌtiro ni yʉꞌticʉ niwĩ: —Niꞌcãrõacã mʉꞌʉ yʉꞌʉ faraṍrẽ weeatjere ĩꞌagʉ̃saꞌa. Yʉꞌʉ tutuase meꞌrã narẽ wijacã weegʉti. Yʉꞌʉ tutuasere ĩꞌagʉ̃, Egiptopʉ nirãrẽ wijadutigʉsami, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Õꞌacʉ̃ apetero Moisére ucũgʉ̃, aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abrahãrẽ, Isaare, Jacore ucũgʉ̃, “Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ niꞌi”, ni werewʉ. Tojo nimigʉ̃, yʉꞌʉ wãme waro peꞌere werebajurẽtiwʉ. Yʉꞌʉta niꞌi Õꞌacʉ̃ mʉsã wiogʉ niwʉagʉta. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Apeyema tja, “Mʉsã pãrãmerã nituriarãrẽ Canaá diꞌtare oꞌogʉti” ni, na meꞌrã apowʉ. Na ti diꞌtare apesecjãrã weronojõ níniꞌwã yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Niꞌcãrõacãrẽ Israe curuacjãrã piꞌeticã ĩꞌagʉ̃, Egiptocjãrã narẽ ʉpʉtʉ daꞌraduticã ĩꞌagʉ̃, yʉꞌʉ na ñecʉ̃sʉmʉa nituriarã meꞌrã apoꞌquere wãcũꞌu. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Tojo weegʉ Israe curuacjãrãrẽ aꞌtiro ni wereya: “Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ, mʉsã Egiptocjãrã dutise doca nirãrẽ na tutuaro daꞌradutipesere wijataꞌagʉti. Yʉꞌʉ tutuaro meꞌrã, Egiptocjãrãrẽ buꞌiri daꞌre, mʉsãrẽ yʉꞌrʉweticã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mʉsã, yarã masã nirãsaꞌa. Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ nigʉ̃saꞌa. Tojo weese meꞌrã mʉsã yʉꞌʉre ‘Õꞌacʉ̃, ʉ̃sã wiogʉ nimi’, nirãsaꞌa. ‘Cʉ̃ta ʉ̃sãrẽ Egiptocjãrã dutise doca níꞌcãrãrẽ wijacã weeami; na tutuaro meꞌrã daꞌradutipesere wijataꞌami’, nirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Yʉꞌʉ Abrahãrẽ, Isaare, Jacore oꞌogʉti níca diꞌtapʉ mʉsãrẽ miagʉ̃saꞌa. Te mʉsã ye diꞌta nidojarosaꞌa. Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisé aꞌtere Israe curuacjãrãrẽ wereturiacʉ niwĩ. Ʉpʉtʉ Egiptocjãrã narẽ daꞌradutipeyucã, bʉjaweti, wãcũtutuaduꞌucãrã niwã. Tojo weerã Moisé narẽ níꞌquere yʉꞌtiticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Tere ĩꞌagʉ̃, Õꞌacʉ̃ Moisére nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Faraṍ tiropʉ waꞌaya. Waꞌa, cʉ̃rẽ Israe curuacjãrãrẽ ti diꞌtapʉ nirãrẽ wijadutiya. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moisé peꞌe Õꞌacʉ̃rẽ aꞌtiro yʉꞌticʉ niwĩ: —Israe curuacjãrã yʉꞌʉre ne cãꞌrõ yʉꞌtitima. Nemorõ faraṍ pũrĩcã yʉꞌtitisami. Yʉꞌʉ ucũgʉ̃ ne meꞌrĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tere tʉꞌogʉ, Õꞌacʉ̃ Moisére, Aarṍrẽ Israe curuacjãrãrẽ, tojo nicã faraṍrẽ aꞌtiro ni weredutigʉ oꞌócʉ niwĩ tja: —Õꞌacʉ̃ Israe curuacjãrã Egiptopʉ nirãrẽ ʉ̃sãrẽ miiwijadutiami, ni wereya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israe curuacjãrã masã maꞌmisʉmʉa ãꞌrã nicãrã niwã: Jacob macʉ̃ Rubén, masã maꞌmi nicʉ niwĩ. Cʉ̃ põꞌrã Hanoc, Falú, Hezrón, Carmi nicãrã niwã. Ãꞌrã Rubén ya curuacjãrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeó põꞌrã aꞌticʉrã nicãrã niwã: Jemuel, Jamín, Ohad, Jaquín, Zohar, Saúl nicãrã niwã. Cʉ̃ Saúl cananeo diꞌtacjõ macʉ̃ nicʉ niwĩ. Ãꞌrã Simeó ya curuacjãrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leví ciento treinta y siete cʉ̃ꞌmarĩ caticʉ niwĩ. Masã maꞌmi meꞌrã nʉꞌcã, téé nitʉogʉ meꞌrã cʉ̃ põꞌrã aꞌtiro wãmeticãrã niwã: Gersón, Coat, Merari. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersón põꞌrã aꞌticʉrã nicãrã niwã: Libni, Simei. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Coat ciento treinta y tres cʉ̃ꞌmarĩ caticʉ niwĩ. Cʉ̃ põꞌrã aꞌticʉrã nicãrã niwã: Amram, Izhar, Hebrṍ, Uziel. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari põꞌrã aꞌticʉrã nicãrã niwã: Mahli, Musi nicãrã niwã. Ãꞌrã Leví ya curuacjãrã masã maꞌmi meꞌrã ninʉꞌcã, téé nitʉogʉ meꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram cʉ̃ wãmeo Jocabed meꞌrã nʉmoticʉ niwĩ. Na Aarṍ, Moisére põꞌrãticãrã niwã. Amram ciento treinta y siete cʉ̃ꞌmarĩ caticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar põꞌrã aꞌticʉrã nicãrã niwã: Coré, Nefeg, Zicri. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel põꞌrã aꞌticʉrã nicãrã niwã: Misael, Elzafán, Sitrí. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarṍ Elisabet wãmetigore nʉmoticʉ niwĩ. Co Aminadab macõ Naasón acabijo nico niwõ. Na aꞌticʉrã põꞌrãticãrã niwã: Nadab, Abihú, Eleazar, Itamar. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Coré põꞌrã aꞌticʉrã nicãrã niwã: Asir, Elcana, Abiasaf. Na Coré ya curuacjãrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Niꞌcʉ̃ Aarṍ macʉ̃ Eleazar, Futiel wãmetigʉ macõ niꞌcõrẽ nʉmoticʉ niwĩ. Co Finees wãmetigʉre põꞌrãtico niwõ. Leví ya curuacjãrã masã maꞌmi meꞌrã nʉꞌcã, téé nitʉogʉ meꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aarṍ, Moiséreta Õꞌacʉ̃ Israe curuacjãrãrẽ Egipto diꞌtapʉ níꞌcãrãrẽ sʉꞌori miiwijaduticʉ niwĩ. Na ye curari meꞌrã tojo weeduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Náta tja Israe curuacjãrãrẽ Egiptopʉre miiwijarãti nírã, faraṍ meꞌrã ucũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Õꞌacʉ̃ Egiptopʉ Moisé meꞌrã cʉ̃ ucṹca nʉmʉrẽ, cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. Nipeꞌtise yʉꞌʉ mʉꞌʉrẽ wereatjere faraṍ, Egiptocjãrã wiogʉre wereapa. ");
INSERT INTO tuoNT_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moisé peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Wiogʉ, yʉꞌʉma yʉꞌʉ ucũse ne, to waꞌaweꞌe. Tojo weegʉ faraṍ yʉꞌʉ ucũsere ne yʉꞌtitigʉsami, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Moisé tojo nicã tʉꞌogʉ, Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Ĩꞌaña majã. Mʉꞌʉ faraṍrẽ ucũcã, yʉꞌʉ basu cʉ̃rẽ ucũgʉ̃ weronojõ tʉꞌoñaꞌgʉ̃sami. Mʉꞌʉ maꞌmi Aarṍ peꞌe mʉꞌʉrẽ ucũbosagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mʉꞌʉ Aarṍrẽ nipeꞌtise yʉꞌʉ dutisere weregʉsaꞌa. Beꞌro cʉ̃ peꞌe faraṍpʉre Israe curuacjãrãrẽ ti diꞌtapʉ nirãrẽ wijadutigʉ ucũgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Yʉꞌʉ peꞌe cʉ̃rẽ mʉsãrẽ yʉꞌrʉnʉꞌcãcã weegʉti. Peje apeyenojõ ĩꞌa ʉcʉasenojõrẽ Egiptopʉre weeĩꞌomicã, faraṍ mʉsã sẽrĩsere yʉꞌtisome. Egiptopʉre yʉꞌʉ tutuasere ĩꞌogʉ̃ti. Queoro narẽ buꞌiri daꞌregʉ, to Egiptopʉ nirã́ yarã masãrẽ wijacã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Egiptopʉre yʉꞌʉ tutuasere ĩꞌóca beꞌro, tojo nicã Israe curuacjãrãrẽ miiwijáca beꞌro, Egiptocjãrã yʉꞌʉ wiogʉ niꞌi nisere masĩrãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisé, Aarṍ Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta queoro weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Na faraṍ meꞌrã ucũcaterore Moisé ochenta cʉ̃ꞌmarĩ cʉocʉ niwĩ. Aarṍ peꞌe ochenta y tres cʉ̃ꞌmarĩ cʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Õꞌacʉ̃ Moisére, Aarṍrẽ nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","—Faraṍ mʉsãrẽ apeyenojõ weeĩꞌoduticã, Aarṍ cʉ̃ ya tuacjʉre mii, nucũcãpʉ faraṍ tiro doquecũudutiya. Cʉ̃ tojo weecã, tigʉ tuacjʉ aña dojorosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moisé, Aarṍ, faraṍ tiropʉ cʉ̃ meꞌrã ucũrã waꞌacãrã niwã. Õꞌacʉ̃ dutiꞌcaronojõta weecãrã niwã. Aarṍ cʉ̃ tuacjʉre faraṍ, tojo nicã cʉ̃rẽ daꞌracoꞌterã põtẽorõpʉ doquecũucʉ niwĩ. Cʉ̃ tojo weecãta, tigʉ tuacjʉ aña dojocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tojo weecã ĩꞌagʉ̃, faraṍ peꞌe cʉ̃ yarã masĩrĩ masãrẽ, tʉꞌoñaꞌrĩ masãrẽ pijicʉ niwĩ. Na quẽꞌrã na masĩsere mejãrõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Na ye tuasepagʉre nanʉcʉ̃ doquecũucãrã niwã. Tepagʉnʉcʉ̃ aña dojocaro niwʉ̃. Aarṍ yagʉ tuacjʉ peꞌe masĩrĩ masã, tʉꞌoñaꞌrĩ masã yepagʉre baꞌapeꞌocãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Tojo waꞌamicã, faraṍ peꞌe Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãcʉ niwĩ. Õꞌacʉ̃ “Tojo waꞌarosaꞌa” níꞌcaronojõta ne yʉꞌtiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Moisé, Aarṍ faraṍ tiropʉ wijááca beꞌro Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: —Faraṍ yʉꞌtiti, ne Israe curuacjãrãrẽ wijacã weetimi. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ñamiacã ñamicure, cʉ̃ diapʉ buꞌari cura cʉ̃ meꞌrã ucũrã waꞌaya. To dia sumutopʉ coꞌteapa. Mʉꞌʉ yagʉ tuacjʉ aña dojocã weeꞌcʉ meꞌrã waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Topʉ faraṍrẽ aꞌtiro niña: “Õꞌacʉ̃, hebreo masã wiogʉ, mʉꞌʉrẽ aꞌtiro nidutigʉ yʉꞌʉre oꞌoami: ‘Yarã masãrẽ yucʉ marĩrõ, masã marĩrõpʉ yʉꞌʉre eꞌcatipeorã waꞌacã, duꞌuoꞌoato’, niami. Mʉꞌʉ peꞌe ne ‘Jaʉ’ niweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tojo weegʉ Õꞌacʉ̃ aꞌtiro niami: ‘Niꞌcãrõacã meꞌrã yʉꞌʉ wiogʉ nisere masĩgʉ̃saꞌa’, niami. Yʉꞌʉ, Moisé, yagʉ tuacjʉ meꞌrã acore paapoꞌocã, aco dí dojorosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Waꞌi wẽrĩrãsama. Te aco ʉ̃rĩse dojorosaꞌa. Tere yabirã, Egiptocjãrã ne sĩꞌrĩsome”, Õꞌacʉ̃ Moisére tojo ni wereduticʉ niwĩ faraṍrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Õꞌacʉ̃ Moisére aꞌtiro ninemocʉ niwĩ: —Aarṍrẽ aꞌtiro niña: “Nipeꞌtise maarĩrẽ, oꞌmajã maarĩacãrẽ, tojo nicã ditararire, nipeꞌtise aco posetisenojõ Egiptopʉ nisere mʉꞌʉ yagʉ tuacjʉ meꞌrã sĩ́oo, wẽjẽtuato. Tojo weecã, aco na yucʉ coꞌripʉ nise, ʉ̃tã meꞌrã weeꞌqueparʉpʉ nise dí dojorosaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisé, Aarṍ Õꞌacʉ̃ dutiꞌcaronojõta weecãrã niwã. Aarṍ cʉ̃ yagʉ tuacjʉre diapʉ paapoꞌocʉ niwĩ. Faraṍ, cʉ̃ docacjãrã ĩꞌorõpʉ tojo weecʉ niwĩ. Tojo weecã, te aco dí dojocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Waꞌi wẽrĩcãrã niwã. Aco ʉ̃rĩse tojacaro niwʉ̃. Tojo weerã Egiptocjãrã masã ne te acore sĩꞌrĩticãrã niwã. Nipeꞌtiro Egipto cjase aco dí dojopeꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tojo waꞌamicã, Egiptocjãrã tʉꞌoñaꞌrĩ masã na masĩse meꞌrã mejãrõta weecãrã niwã. Faraṍ Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcã, Õꞌacʉ̃ cʉ̃ níꞌcaronojõta Moisé, Aarṍ na nisere ne tʉꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraṍ tʉꞌoronojõ oꞌogʉ, majãmitojaa, cʉ̃ ya wiꞌipʉ waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nipeꞌtirã Egiptocjãrã aco añuse na waatje perire dia sumutopʉ seꞌecãrã niwã. Dia cjase peꞌe ne sĩꞌrĩse mejẽta nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Õꞌacʉ̃ diare dí dojocã wééca beꞌro niꞌcã semana yʉꞌrʉcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Titare Õꞌacʉ̃ Moisére nicʉ niwĩ: —Faraṍ tiropʉ waꞌa, cʉ̃rẽ aꞌtiro niña: “Õꞌacʉ̃ aꞌtiro niami: ‘Yarã masãrẽ duꞌuoꞌoya. Na yʉꞌʉre ẽjõpeorã waꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mʉꞌʉ narẽ duꞌuwĩrõticãma, oma meꞌrã nipeꞌtiro Egiptopʉre buꞌiri daꞌregʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Diapʉre oma yʉꞌrʉmajãrãsama. Na mʉꞌʉ wiogʉ nirĩ wiꞌipʉre sãjã́árãsama. Mʉꞌʉ cãrĩrĩ tucũpʉre, mʉꞌʉ cãrĩpesaropʉre, mʉꞌʉ docacjãrã wiorã ye wiꞌseripʉre, nipeꞌtirã mʉꞌʉ yarã masã nirõpʉre sãjã́árãsama. Mʉꞌʉ pã́ ʉ̃jʉ̃ase wiꞌseripʉre, tojo nicã pã́ tuumorẽse coꞌripʉre sãñarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Na oma mʉꞌʉ buꞌipʉ buꞌpupejarãsama. Mʉꞌʉ docacjãrã wiorã buꞌipʉ, mʉꞌʉ yarã masã buꞌipʉ buꞌpupejarãsama’ ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Õꞌacʉ̃ Moisére werenemocʉ niwĩ: —Aarṍrẽ cʉ̃ yagʉ tuacjʉ meꞌrã nipeꞌtise maarĩrẽ, maarĩacãpʉre, ditararipʉre sĩ́oo, wẽjẽtuato. Cʉ̃ tojo weecã, oma tepʉ níꞌcãrã majãa, Egipto diꞌtapʉre muꞌmua waꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tere tʉꞌogʉ, Aarṍ Egipto diꞌtapʉ nise aco buꞌipʉ cʉ̃ tuacjʉre sĩ́oo, wẽjẽtuocʉ niwĩ. Cʉ̃ tojo weecã, oma pãjãrã nipeꞌtiro ti diꞌtapʉre tuuseꞌsa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tojo nimicã, tʉꞌoñaꞌrĩ masã, masĩrĩ masã quẽꞌrã mejãrõta weecãrã niwã. Egipto diꞌtapʉre oma bajuacã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tere ĩꞌagʉ̃, faraṍ Moisére, Aarṍrẽ pijidutioꞌocʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Mʉsã wiogʉ Õꞌacʉ̃rẽ oma yʉꞌʉ, tojo nicã yarã masã tiro nirãrẽ peꞌticã weedutiya. Mʉꞌʉ tojo weecã, mʉꞌʉ yarã masãrẽ waꞌicʉrãrẽ wẽjẽ, Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeodutigʉ duꞌuoꞌogʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moisé faraṍrẽ yʉꞌticʉ niwĩ: —¿Deꞌro nicã mʉꞌʉrẽ, mʉꞌʉ docacjãrã wiorãrẽ, mʉꞌʉ yarã masãrẽ sẽrĩbosacã ʉasari? Yʉꞌʉ sẽrĩcã, oma mʉꞌʉrẽ, mʉꞌʉ ya wiꞌipʉre marĩrãsama. Diapʉ diaꞌcʉ̃ tojarã́sama. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","—Ñamiacãta sẽrĩbaqueꞌoya, nicʉ niwĩ faraṍ. Moisé peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ nírõnojõta waꞌarosaꞌa. Te meꞌrã ne apĩ Õꞌacʉ̃ ʉ̃sã wiogʉ weronojõ tutuagʉ marĩmi nisere masĩgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Oma mʉꞌʉ wiogʉ nirĩ wiꞌipʉreta peꞌtirãsama. Peꞌti, diapʉ diaꞌcʉ̃ tojarã́sama. Mʉꞌʉrẽ, mʉꞌʉ docacjãrã wiorãrẽ, mʉꞌʉ yarã masãrẽ caribonemosome, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tuꞌajanʉꞌcõ Moisé, Aarṍ faraṍ ya wiꞌipʉ níꞌcãrã wijaa waꞌacãrã niwã. Beꞌro Moisé Õꞌacʉ̃rẽ “Oma Faraṍrẽ oꞌóꞌcãrãre peꞌticã weeya” ni, sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Õꞌacʉ̃ Moisé cʉ̃ sẽrĩꞌcaronojõta weecʉ niwĩ. Oma wiꞌseripʉ níꞌcãrã, wijaropʉ níꞌcãrã, cãpũpʉ níꞌcãrã wẽrĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Masã na oma wẽrĩꞌcãrãrẽ seeneocũucãrã niwã. Nipeꞌtiropʉ ñaꞌarõ ʉ̃rĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Oma peꞌticã ĩꞌamigʉ̃, faraṍ na marĩcã ĩꞌagʉ̃, Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãgʉ̃, Moisé, Aarṍ na ucũsere ne tʉꞌosĩꞌrĩticʉ niwĩ. Õꞌacʉ̃ cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Õꞌacʉ̃ Moisére nicʉ niwĩ: —Aarṍrẽ cʉ̃ yagʉ tuacjʉre sĩ́oo, nucũcãpʉ diꞌtamarãrĩ nisere paacũudutiya. Tojo weecã, nipeꞌtiro Egiptopʉre moarã dímiꞌrĩrãcã pãjãrã bajuarãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Cʉ̃ dutiꞌcaronojõta weecãrã niwã. Aarṍ cʉ̃ tuacjʉre sĩ́oo, nucũcãpʉ paacũucʉ niwĩ. Cʉ̃ tojo weecãta, nipeꞌtise diꞌtamarãrĩ Egiptopʉre moarã dímiꞌrĩrãcã pãjãrã dojocãrã niwã. Na masãrẽ, waꞌicʉrãrẽ nuꞌrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Masĩrĩ masã, tʉꞌoñaꞌrĩ masã quẽꞌrã na weeĩꞌomasĩse meꞌrã moarã dímiꞌrĩrãcã pãjãrãrẽ bajurẽsĩꞌrĩcãrã nimiwã. Põtẽoticãrã niwã. Na moarã dímiꞌrĩrãcã masãrẽ, waꞌicʉrãrẽ nuꞌrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Na tojo wee põtẽotirã, faraṍrẽ nicãrã niwã: —Aꞌte Õꞌacʉ̃ cʉ̃ tutuaro meꞌrã weese niꞌi, nicãrã niwã. Tojo waꞌamicã, faraṍ peꞌe Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãgʉ̃, na ucũsere ne tʉꞌoticʉ niwĩ. Õꞌacʉ̃ cʉ̃ níꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Faraṍ ñamiacã ñamicure diapʉ buꞌagʉsami. Tojo weerã mʉsã maata wãꞌcã, cʉ̃rẽ aꞌtiro nirã waꞌapa: “Õꞌacʉ̃ aꞌtiro niami: ‘Yarã masãrẽ yʉꞌʉre eꞌcatipeorã waꞌacã duꞌuoꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Mʉꞌʉ narẽ duꞌuoꞌoticãma, mʉꞌʉrẽ, mʉꞌʉ docacjãrã wiorãrẽ, mʉꞌʉ yarã masãrẽ, mʉsã ye wiꞌseripʉre nurũrũarẽ oꞌógʉti. Egiptocjãrã ye wiꞌseripʉ nurũrũa muꞌmua waꞌarãsama. Mejãrõta nucũcãpʉ quẽꞌrãrẽ muꞌmurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tojo waꞌari curare Gosén diꞌta peꞌema, yarã masã na nirõrẽ ne niꞌcʉ̃ nurũrũ marĩgʉ̃sami. Mʉꞌʉ faraṍ, te meꞌrã yʉꞌʉ Õꞌacʉ̃, aꞌti diꞌtapʉ nisere masĩgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Aꞌtiro weecã, yarã masãrẽ, mʉꞌʉ yarã meꞌrã dʉcawaasere masĩgʉ̃saꞌa. Aꞌte yʉꞌʉ tojo nise ñamiacãta tojo waꞌarosaꞌa’, niami Õꞌacʉ̃”, ni werecʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Cʉ̃ níꞌcaronojõta waꞌacaro niwʉ̃. Faraṍ ya wiꞌipʉre, tojo nicã cʉ̃ docacjãrã wiorã ye wiꞌseripʉre nurũrũa pãjãrã waro añurõ naꞌitĩꞌarõ tuusãjãacãrã niwã. Nipeꞌtiro Egiptocjãrã na nirõpʉre tojo waꞌacaro niwʉ̃. Na nurũrũa pãjãrã niyʉꞌrʉarã, ti diꞌtare añurõ muꞌmuyʉꞌrʉa, dojorẽbutiacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tojo waꞌacã, faraṍ Moisére, Aarṍrẽ pijidutioꞌocʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeorã waꞌaya. Mejõ aꞌti diꞌtapʉre wijaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisé cʉ̃rẽ yʉꞌticʉ niwĩ: —Ne queoro nitirocoro. Ʉ̃sã wiogʉ Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeorã, Egiptocjãrã peꞌema na waꞌicʉrã na ẽjõpeorã wiori nima. Tojo weerã na Egiptocjãrã ʉ̃sã waꞌicʉrã na ẽjõpeorãrẽ ʉ̃jʉ̃amorõpeocã ĩꞌarã, ʉ̃sãrẽ ʉ̃tãperi meꞌrã doquewẽjẽbosama. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ʉ̃sã iꞌtia nʉmʉ waꞌaro, yucʉ marĩrõ, masã marĩrõpʉ waꞌarãsaꞌa. Topʉ Õꞌacʉ̃ ʉ̃sã wiogʉre cʉ̃ dutiꞌcaronojõta waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeorãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tere tʉꞌogʉ, faraṍ nicʉ niwĩ: —To pũrĩcãrẽ masã marĩrõpʉ waꞌaya. Topʉ mʉsã wiogʉ Õꞌacʉ̃rẽ waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeoya. Yoaropʉ waro waꞌaticãꞌña. Yʉꞌʉ quẽꞌrãrẽ sẽrĩbosapa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moisé cʉ̃rẽ yʉꞌticʉ niwĩ: —Maata aꞌto níꞌcʉ wijaagʉta, Õꞌacʉ̃ yʉꞌʉ wiogʉre sẽrĩgʉ̃ti. Ñamiacãta nurũrũa mʉꞌʉ tiropʉre, mʉꞌʉ docacjãrã wiorã tiropʉre, mʉꞌʉ yarã masã tiropʉre marĩrãsama. Mʉꞌʉ “Aꞌtiro weegʉti” ni weecã, tojo nicã Israe curuacjãrãrẽ, Õꞌacʉ̃ ʉ̃sã wiogʉre waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeodutigʉ duꞌuoꞌocã, tojo waꞌarosaꞌa, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisé faraṍ ya wiꞌipʉ níꞌcʉ cʉ̃ wijááca beꞌroacãta Õꞌacʉ̃rẽ sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Õꞌacʉ̃ Moisé cʉ̃ sẽrĩꞌcaronojõta weecʉ niwĩ. Nurũrũa faraṍ tiropʉ, cʉ̃ docacjãrã wiorã tiropʉ, cʉ̃ yarã masã tiropʉ níꞌcãrã wijaapeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Na peꞌticã ĩꞌamigʉ̃, faraṍ Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãgʉ̃, Israe curuacjãrãrẽ duꞌuoꞌoticʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: —Faraṍ tiropʉ waꞌa, aꞌtiro niña: “Õꞌacʉ̃, hebreo masã wiogʉ, aꞌtiro niami: ‘Yarã masãrẽ yʉꞌʉre eꞌcatipeorã waꞌacã duꞌuoꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mʉꞌʉ duꞌuoꞌoronojõ oꞌogʉ, narẽ duꞌuticã, ");
INSERT INTO tuoNT_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Õꞌacʉ̃ cʉ̃ tutuasere ĩꞌogʉ̃, mʉꞌʉ yarã waꞌicʉrã cãpũpʉ nirãrẽ buꞌiri daꞌregʉsami. Narẽ duti pũrĩse waro wãꞌcãrõsaꞌa. Cabayua, burroa, cameyoa, wecʉa, oveja wẽrĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Õꞌacʉ̃ Egiptocjãrã yarã waꞌicʉrãrẽ wẽrĩcã weegʉsami. Israe curuacjãrã yarã peꞌea ne niꞌcʉ̃ wẽrĩsome’ ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Õꞌacʉ̃ cʉ̃ buꞌiri daꞌreatji nʉmʉrẽ cũutojacʉ niwĩ. Aꞌtiro niami: —Ñamiacã tere tojo weegʉti, niami. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ape nʉmʉ cʉ̃ tojo níꞌquere weecʉ niwĩ. Nipeꞌtirã waꞌicʉrã Egiptocjãrã yarã wẽrĩpeꞌtia waꞌacãrã niwã. Israe curuacjãrã yarã peꞌe ne niꞌcʉ̃ wẽrĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraṍ Israe curuacjãrã yarã waꞌicʉrãrẽ ĩꞌadutigʉ oꞌócʉ niwĩ. Na yarã ne niꞌcʉ̃ waꞌicʉ wẽrĩticʉ niwĩ. Tojo waꞌacã ĩꞌamigʉ̃, Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãgʉ̃, Israe curuacjãrãrẽ ne duꞌuoꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Õꞌacʉ̃ Egiptocjãrã yarã waꞌicʉrãrẽ buꞌiri daꞌréca beꞌro Moisére, Aarṍrẽ nicʉ niwĩ: —Pã́ na ʉ̃jʉ̃arõ cjase nujãrẽ niꞌcã omocã ejatuaro õrẽmiiña. Moisé faraṍ ĩꞌorõ ʉꞌmʉarõpʉ tere doquestemorõato. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Te nujã añuse marãrĩ tojarosaꞌa. Nipeꞌtiro Egipto diꞌtapʉre seꞌsa waꞌarosaꞌa. Seꞌsa, masãrẽ, waꞌicʉrãrẽ bipisepa waꞌacã weerosaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tojo weerã Moisé, Aarṍ pã́ ʉ̃jʉ̃arõ cjase nujãrẽ mii, faraṍ tiropʉ cʉ̃ meꞌrã ucũrã waꞌacãrã niwã. Topʉ Moisé te nujãrẽ doquestemorõcʉ niwĩ. Cʉ̃ tojo weecã, masãrẽ, waꞌicʉrãrẽ na upʉ nipeꞌtiropʉ bipisepa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Egiptocjãrã masĩrĩ masã, tʉꞌoñaꞌrĩ masã quẽꞌrã ãpẽrã weronojõta bipisepa waꞌanoꞌcãrã niwã. Tojo weerã Moisére ne põtẽoticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Õꞌacʉ̃ta faraṍrẽ Moisére, Aarṍrẽ yʉꞌrʉnʉꞌcãcã weecʉ niwĩ. Tojo weegʉ Õꞌacʉ̃ Moisére níꞌcaronojõta Moisé, Aarṍ na ucũsere ne yʉꞌtiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Ñamiacã ñamicure wãꞌcã, faraṍrẽ aꞌtiro nigʉ̃ waꞌaya: “Õꞌacʉ̃, hebreo masã wiogʉ, aꞌtiro niami: ‘Yarã masãrẽ yʉꞌʉre eꞌcatipeorã waꞌacã duꞌuoꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Niꞌcãrõacãma mʉꞌʉrẽ, mʉꞌʉ docacjãrã wiorãrẽ, mʉꞌʉ yarã masãrẽ ʉpʉtʉ waro buꞌiri daꞌregʉti. Te meꞌrã mʉꞌʉ masĩgʉ̃saꞌa ne apĩ aꞌti diꞌtapʉre yʉꞌʉ weronojõ nigʉ̃́ marĩmi. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Yʉꞌʉ tutuasere ĩꞌogʉ̃, niꞌcãti meꞌrãta mʉꞌʉrẽ, mʉꞌʉ yarã masãrẽ buꞌiri daꞌre, wẽjẽpeꞌotojabopã. Aꞌti diꞌtapʉ nimiꞌcãrã bajudutipeꞌtiatojabopã. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mʉꞌʉrẽ yʉꞌʉ tutuasere ĩꞌato nígʉ̃, wẽjẽtiwʉ. Tojo nicã masã nipeꞌtise diꞌtacjãrã yʉꞌʉre masĩato nígʉ̃, tojo weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tojo weemicã, mʉꞌʉ peꞌe yarã masãrẽ cãꞌmotaꞌagʉ, ne duꞌuoꞌoweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mʉꞌʉrẽ aꞌtiro weegʉti. Ñamiacã aꞌti orata yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉcã weegʉti. Ne niꞌcãti Egiptopʉre tojo waꞌatiꞌquere waꞌacã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tojo weegʉ mʉꞌʉ yarã waꞌicʉrãrẽ mejẽcã waꞌari nígʉ̃, añurõ nʉrõña. Tojo nicã, nipeꞌtise mʉꞌʉ cãpũpʉ cʉosere nʉrõpeꞌoya. Te yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉpejaro, masãrẽ, waꞌicʉrãrẽ wiꞌi poꞌpeapʉ nitirãrẽ wẽjẽpeꞌorosaꞌa,’ ” nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Niꞌcãrẽrã faraṍ docacjãrã wiorã tere tʉꞌoyurã, uicãrã niwã. Tojo weerã narẽ daꞌrawãꞌñacoꞌterãrẽ, waꞌicʉrãrẽ wiꞌi poꞌpeapʉ cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ãpẽrã peꞌe tere wiopesase meꞌrã tʉꞌoticãrã niwã. Tojo weerã narẽ daꞌrawãꞌñacoꞌterãrẽ, waꞌicʉrãrẽ cãpũpʉ cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Mʉꞌʉ ya omocãrẽ ʉꞌmʉarõpʉ sĩomorõña. Mʉꞌʉ tojo weecã, nipeꞌtiro Egiptopʉre yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉrosaꞌa. Te peri masãrẽ, waꞌicʉrãrẽ, yucʉpagʉre, cãpũpʉ oteꞌquere nipeꞌtiro Egiptopʉ nisere bʉrʉpejarosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisé cʉ̃ ya omocãrẽ ʉꞌmʉarõpʉ sĩomorõcʉ niwĩ. Cʉ̃ tojo weecã, Õꞌacʉ̃ bʉpo paase, yaꞌbase oꞌócʉ niwĩ. Tojo nicã yʉsʉase aco peri bʉꞌaꞌque peri paca diꞌtapʉre bʉrʉcã weecʉ niwĩ. Nipeꞌtiro Egiptopʉre te peri bʉrʉ, tuuseꞌsanʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Bʉpo yaꞌba, yʉsʉase aco peri bʉꞌaꞌque peri paca ne tojanʉꞌcãrõ marĩrõ bʉrʉnuꞌcũcaro niwʉ̃. Egiptopʉre ne niꞌcãti tocãꞌrõ tutuaro bʉrʉticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Te peri paca nipeꞌtiro Egiptopʉre topʉ nisere mʉtõdijocãꞌcaro niwʉ̃. Masãrẽ, waꞌicʉrãrẽ, yucʉpagʉre, otesere tojo weecaro niwʉ̃. Tojo nicã, topʉ nise nipeꞌtise yucʉpagʉre doquewiꞌredijocãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tojo waꞌamicã, Gosén diꞌta peꞌema Israe curuacjãrã tirore ne niꞌcã pe bʉrʉticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tojo waꞌacã ĩꞌagʉ̃, faraṍ Moisére, Aarṍrẽ pijidutioꞌocʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ ñaꞌarõ weeapã. Yʉꞌʉta buꞌiritiꞌi. Tojo nicã yʉꞌʉmasã quẽꞌrã buꞌiritima. Õꞌacʉ̃ pũrĩcã buꞌiri moomi. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ʉpʉtʉ waro bʉpo paase, yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉsere tʉꞌoñaꞌtojaꞌa. Põtẽotisaꞌa. Tojo weegʉ mʉsãrẽ duꞌuwĩrõgʉ̃ti majã. Mʉsã Õꞌacʉ̃rẽ ʉ̃sã ye cjasere sẽrĩbosaya. Yʉꞌʉ mʉsãrẽ duꞌuoꞌogʉti, nicʉ niwĩ faraṍ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moisé cʉ̃rẽ yʉꞌticʉ niwĩ: —Maata aꞌti macãpʉre wijagʉ, Õꞌacʉ̃rẽ sẽrĩ ñubuegʉ, ya omocãrẽ sĩomorõgʉ̃ti. Tojo weecã, aco bʉꞌaꞌque peri paca bʉrʉnemosome. Bʉpo paanemosome. Te meꞌrã nipeꞌtiro aꞌti nucũcã “Õꞌacʉ̃ ye niꞌi” nisere masĩrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Yʉꞌʉ peꞌe mʉꞌʉ weesetisere añurõ masĩꞌi. Mʉꞌʉ, tojo nicã mʉꞌʉ docacjãrã wiorã, Õꞌacʉ̃ yʉꞌʉ wiogʉre ne wiopesase meꞌrã tʉꞌoñaꞌweꞌe, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Cebada pupiropʉ weecaro nimiwʉ̃. Lino peꞌe oꞌoro weecaro nimiwʉ̃. Tojo weero na oteꞌquere añurõ doquemʉtõcãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Trigo, centenoa pũrĩcã beꞌropʉ pupisaꞌa. Tojo weero tea mejẽcã waꞌaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisé faraṍ tiropʉ níꞌcʉ ti macãpʉ wijagʉ, cʉ̃ ye omocãrĩrẽ sĩomorõ, Õꞌacʉ̃rẽ sẽrĩcʉ niwĩ. Cʉ̃ tojo weeri curata maata aco bʉꞌaꞌque peri paca bʉrʉduꞌucaro niwʉ̃. Tojo nicã acoro pejaduꞌucaro niwʉ̃. Bʉpo quẽꞌrã paaduꞌucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tojo waꞌacã ĩꞌamigʉ̃, faraṍ Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãcʉ niwĩ. Cʉ̃ docacjãrã wiorã quẽꞌrã mejãrõta yʉꞌrʉnʉꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Õꞌacʉ̃ Moisé meꞌrã todʉporopʉ níꞌcaronojõta faraṍ Israe curuacjãrãrẽ ne duꞌuoꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Õꞌacʉ̃ Moisére nicʉ niwĩ: —Faraṍ meꞌrã ucũgʉ̃ waꞌaya. Yʉꞌʉta cʉ̃rẽ, tojo nicã cʉ̃ docacjãrã wiorãrẽ mʉꞌʉrẽ yʉꞌrʉnʉꞌcãcã weeapʉ. Narẽ yʉꞌʉ tutuase, ĩꞌa ʉcʉasenojõrẽ weeĩꞌogʉ̃ti nígʉ̃, tojo weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Tojo nicã, mʉꞌʉ põꞌrãrẽ, mʉꞌʉ pãrãmerãrẽ yʉꞌʉ Egiptocjãrãrẽ buꞌiri daꞌreꞌquere, ĩꞌa ʉcʉase weeĩꞌoꞌquere wereturiato nígʉ̃, tojo weeapʉ. Tojo weerã “Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi” nisere masĩrãsaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Cʉ̃ tojo níca beꞌro Moisé, Aarṍ faraṍ meꞌrã ucũrã waꞌacãrã niwã: —Õꞌacʉ̃, hebreo masã wiogʉ mʉꞌʉrẽ aꞌtiro nidutiami: “Yʉꞌʉ weesere ĩꞌamigʉ̃, yʉꞌʉ dutiro ne weeweꞌe. Yarã masãrẽ yʉꞌʉre eꞌcatipeorã waꞌacã duꞌuoꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Mʉꞌʉ duꞌuoꞌoticãma, ñamiacãta mʉꞌmʉrĩwiꞌia aꞌti diꞌtare aꞌticã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tojo weerã mʉꞌmʉrĩwiꞌia pãjãrã niyucã, diꞌta ne bajusome. Aco bʉꞌaꞌque peri paca bʉrʉ, doquewẽjẽ dʉꞌaꞌquere baꞌarãsama. Tojo nicã cãpũpʉ yucʉpagʉ nise pũrĩrẽ baꞌapeꞌocãꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mʉꞌʉ ya wiꞌire, mʉꞌʉ docacjãrã wiorã ye wiꞌserire, nipeꞌtirã Egiptocjãrã ye wiꞌserire muꞌmua waꞌarãsama. Mʉꞌʉ ñecʉ̃sʉmʉa, mʉꞌʉ pacʉsʉmʉa na ninʉꞌcãcaterore ĩꞌatiꞌquere, téé niꞌcãrõacãpʉ quẽꞌrãrẽ mʉsã ĩꞌatiꞌquere ĩꞌarãsaꞌa”, nicʉ niwĩ. Tojo nitojagʉta, Moisé majãminʉꞌcã, faraṍ ya wiꞌire wijaa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tere tʉꞌorã, faraṍ docacjãrã wiorã cʉ̃rẽ aꞌtiro nicãrã niwã: —¿Deꞌro nicãpʉ marĩrẽ ãꞌrĩ ñaꞌarõ weeduꞌugʉsari? Õꞌacʉ̃ na wiogʉre eꞌcatipeorã waꞌacã, narẽ duꞌuoꞌocãꞌña. Cʉ̃ marĩ ya diꞌtare dojorẽpeꞌotojami. ¿Mʉꞌʉ tere ĩꞌaweti? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Faraṍ Moisére, Aarṍrẽ pijiduticʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃, mʉsã wiogʉre eꞌcatipeorã waꞌaya. Wereya. ¿Noa waꞌarãsari mʉsã meꞌrã? ");
INSERT INTO tuoNT_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisé yʉꞌticʉ niwĩ: —Ʉ̃sãpʉma Õꞌacʉ̃ ya bosenʉmʉ pajiri bosenʉmʉ nirõ weeꞌe. Tojo weerã wĩꞌmarã, maꞌmapjia, bʉcʉrã ʉ̃sã meꞌrã waꞌarãsama. Tojo nicã ʉ̃sã yarã ovejare, wecʉare miarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraṍ cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉre mʉsã nʉmosãnumia, wĩꞌmarã meꞌrã duꞌuoꞌogʉsami, ni wãcũmisaꞌa. Yʉꞌʉ narẽ ne duꞌuoꞌosome. Yʉꞌʉ ĩꞌacã peꞌema, mʉsã ñaꞌarõ wãcũsere masĩnoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Niweꞌe. Mʉsã ʉaro weesome. Diacjʉ̃ta Õꞌacʉ̃rẽ eꞌcatipeosĩꞌrĩrã, ʉmʉa diaꞌcʉ̃ waꞌaya, nicʉ niwĩ faraṍ. Tojo nitoja, faraṍ Moisére, Aarṍrẽ cʉ̃ tiro nirãrẽ cõꞌawĩrõduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Mʉꞌmʉrĩwiꞌia bajuato nígʉ̃, Egipto diꞌtare mʉꞌʉ omocãrẽ sĩ́oo, wẽjẽtuoya. Mʉꞌʉ tojo weecã, nipeꞌtiropʉ seꞌsa waꞌarãsama. Nipeꞌtise yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉ, doquewẽjẽ dʉꞌaꞌquere baꞌapeꞌocãꞌrãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisé Egiptopʉre cʉ̃ tuacjʉre sĩ́oo, wẽjẽtuocʉ niwĩ. Õꞌacʉ̃ ʉmʉco, ñami wĩꞌrõrõ mujĩpũ mʉjãtiro peꞌe meꞌrã wẽeonaꞌia, wẽeoboꞌreacã weecʉ niwĩ. Ape nʉmʉ boꞌreacã wĩꞌrõrõ wẽeose meꞌrãta mʉꞌmʉrĩwiꞌia aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Na ti diꞌtare nipeꞌtiropʉ tuuseꞌsanʉꞌcã waꞌacãrã niwã. Todʉporopʉ ne niꞌcãti ticʉrã pãjãrã mʉꞌmʉrĩwiꞌia marĩcãrã niwã. Beꞌropʉ quẽꞌrãrẽ ĩꞌanoꞌña marĩrãsama majã. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Pãjãrã niyucã, diꞌta ne bajuticaro niwʉ̃. Cãpũpʉ na oteꞌque dʉca, tojo nicã yucʉdʉca aco bʉꞌaꞌque peri bʉrʉ, doquewẽjẽ dʉꞌaꞌquere nipeꞌtiro Egiptopʉre baꞌapeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tojo waꞌacã ĩꞌagʉ̃, faraṍ sojaro meꞌrã Moisére, Aarṍrẽ pijidutitjĩagʉ̃, aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ mʉsã wiogʉre, tojo nicã mʉsãrẽ ñaꞌarõ weeasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Niꞌcãrõacã waroma yʉꞌʉ ñaꞌarõ weeꞌquere acobojoya. Õꞌacʉ̃rẽ yʉꞌʉre sẽrĩbosaya ãꞌrã mʉꞌmʉrĩwiꞌia ñaꞌarõ weerãrẽ cõꞌabosacã, nicʉ niwĩ faraṍ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisé ti wiꞌipʉ níꞌcʉ wijaa, faraṍ sẽrĩdutiꞌcaronojõ Õꞌacʉ̃rẽ sẽrĩbosacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tojo weegʉ Õꞌacʉ̃ wĩꞌrõ mujĩpũ mʉjãtiro peꞌe aꞌtiꞌquere mujĩpũ sãjãrõ peꞌe dʉcayucʉ niwĩ. Te wĩꞌrõ tutuaro meꞌrã mʉꞌmʉrĩwiꞌiare Maa Sõꞌarĩ maapʉ wẽequeñocã weecʉ niwĩ. Tojo weecã, Egiptopʉre ne mʉꞌmʉrĩwiꞌia dʉꞌsaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Õꞌacʉ̃ peꞌe faraṍrẽ Moisére yʉꞌrʉnʉꞌcãcã weecʉ niwĩ. Tojo weegʉ faraṍ Israe curuacjãrãrẽ duꞌuoꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Õꞌacʉ̃ mʉꞌmʉrĩwiꞌia meꞌrã buꞌiri daꞌréca beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Nipeꞌtiro Egiptopʉre naꞌitĩꞌato nígʉ̃, ʉꞌmʉarõ peꞌe mʉꞌʉ ya omocãrẽ sĩomorõña. Ʉpʉtʉ naꞌitĩꞌarõ waro waꞌato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisé cʉ̃ ya omocãrẽ sĩomorõca beꞌro, iꞌtia nʉmʉ Egiptopʉre ʉpʉtʉ naꞌitĩꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tojo waꞌari curare ne niꞌcʉ̃ Egiptopʉ nirã́ aꞌmerĩ ĩꞌati, ne aperopʉ waꞌamasĩticãrã niwã. Tojo waꞌamicã, Israe curuacjãrã ye wiꞌseri peꞌea boꞌreyu nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tojo weegʉ faraṍ Moisére pijiduti, aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ mʉsã wiogʉre eꞌcatipeorã waꞌaya. Mʉsã nʉmosãnumiarẽ, mʉsã põꞌrãrẽ miaña. Mʉsã yarã oveja, wecʉa peꞌema aꞌto cũuña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moisé peꞌe aꞌtiro yʉꞌticʉ niwĩ: —Niweꞌe. Ʉ̃sã yarã waꞌicʉrãrẽ duꞌuoꞌoya. Náta Õꞌacʉ̃ ʉ̃sã wiogʉre eꞌcatipeorã wẽjẽ, ʉ̃jʉ̃amorõpeoajã nima. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tojo weerã ʉ̃sã yarã waꞌicʉrãrẽ miapeꞌocãꞌrãsaꞌa. Ne niꞌcʉ̃rẽ cũusĩꞌrĩtisaꞌa. Ʉ̃sã Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeoajãrẽ beserãtirã ʉarãsaꞌa. Topʉ ejarã, ʉ̃sã Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeoajãrẽ ñamarãnojõrẽ ʉarã ʉabosaꞌa, masĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Õꞌacʉ̃ peꞌe faraṍrẽ cʉ̃rẽ yʉꞌrʉnʉꞌcãcã weecʉ niwĩ. Tojo weegʉ faraṍ Israe curuacjãrãrẽ duꞌuoꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Apeyema faraṍ Moisére aꞌtiro nicʉ niwĩ: —Waꞌaya aꞌtore. Ne apaturi yʉꞌʉ tiro aꞌtiticãꞌña. Apaturi yʉꞌʉ tiro aꞌtigʉ, boa waꞌagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Cʉ̃ tojo nicã tʉꞌogʉ, Moisé faraṍrẽ yʉꞌticʉ niwĩ: —Añurõ wéégʉ, tojo niꞌi. Apaturi mʉꞌʉrẽ ĩꞌanemosome, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Õꞌacʉ̃ Moisére nicʉ niwĩ: —Niꞌcãti faraṍrẽ, tojo nicã Egiptocjãrã masãrẽ buꞌiri daꞌretʉogʉtigʉ weeꞌe majã. Aꞌte beꞌro faraṍ mʉsãrẽ duꞌuoꞌogʉsami, duꞌuoꞌogʉ peꞌe. Mejõ nipeꞌtise mʉsã ye meꞌrã cõꞌawĩrõbutiagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Niꞌcãrõacãrẽ Israe curuacjãrã ʉmʉarẽ, numiarẽ Egiptocjãrã na pʉꞌto nirãrẽ uru, plata meꞌrã weeꞌquere sẽrĩdutiya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Õꞌacʉ̃ Egiptocjãrãrẽ Israe curuacjãrãrẽ ĩꞌa, eꞌcaticã weecʉ niwĩ. Apeyema tja faraṍ docacjãrã wiorã, tojo nicã ti diꞌtacjãrã Moisére wiopesase meꞌrã ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisé faraṍrẽ nicʉ niwĩ: —Aꞌtiro niami Õꞌacʉ̃: “Ñami deco nicã nipeꞌtiro Egiptopʉre sijagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Yʉꞌʉ to sijari curare nipeꞌtirã Egiptocjãrã põꞌrã masã maꞌmisʉmʉa faraṍ macʉ̃ cʉ̃rẽ wiogʉ sãjãdʉcayuacjʉ meꞌrã, téé cʉ̃rẽ daꞌracoꞌtego trigo ãrʉ̃agõ macʉ̃, tojo nicã waꞌicʉrã bajuamʉꞌtãꞌcãrã wẽrĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tojo waꞌacã, nipeꞌtiro Egiptopʉre caricũ utirãsama. Todʉporopʉ ne niꞌcãti tocãꞌrõ utitiwã. Beꞌropʉ quẽꞌrãrẽ ne apaturi tocãꞌrõ utisome majã”, niami. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Israe curuacjãrã waꞌtero peꞌema ne niꞌcʉ̃ masʉ̃rẽ, ne niꞌcʉ̃ waꞌicʉre diayi tuꞌtisome. Tojo weese meꞌrã mʉsã Õꞌacʉ̃ Egiptocjãrãrẽ, Israe curuacjãrãrẽ dʉcawaasere masĩrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Beꞌro nipeꞌtirã mʉꞌʉ doca wiorã nirã́ yʉꞌʉ tiro aꞌti, ejaqueꞌatjĩarã, “Waꞌagʉsaꞌa nipeꞌtirã Israe curuacjãrã meꞌrã”, nirãsama. Na yʉꞌʉre tojo niticãma, yʉꞌʉ waꞌasome, nicʉ niwĩ Moisé. Tojo nitoja, Moisé uase meꞌrã faraṍ ya wiꞌire wijaa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Faraṍ mʉsã sẽrĩsere yʉꞌtisome. Cʉ̃ oꞌóticãma, yʉꞌʉ tutuasere weeĩꞌonemonoꞌrõsaꞌa Egipto diꞌtapʉre, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisé, Aarṍ meꞌrã Õꞌacʉ̃ níꞌcaronojõta faraṍrẽ peje weeĩꞌonemocãrã niwã. Õꞌacʉ̃ peꞌe faraṍrẽ narẽ yʉꞌrʉnʉꞌcãcã weecʉ niwĩ. Tojo weegʉ faraṍ Israe curuacjãrãrẽ duꞌuoꞌoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Õꞌacʉ̃ Moisére, Aarṍrẽ Egiptopʉ nirãrẽ aꞌtiro ni werecʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Aꞌti mujĩpũ mʉsãrẽ mejõ nirĩ mujĩpũ mejẽta nirõsaꞌa. Aꞌti cʉ̃ꞌmarẽ ne ninʉꞌcãrĩ mujĩpũ nirõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nipeꞌtirã Israe curuacjãrãrẽ aꞌtiro ni wereya: ‘Aꞌti mujĩpũ diez nirĩ nʉmʉ nicã, niꞌcã wiꞌicjãrã niꞌcʉ̃ oveja wĩꞌmagʉ̃rẽ o cabracãrẽ ñeꞌe cʉoyuya. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Niꞌcã wiꞌicjãrã pejetirã nicã “Cʉ̃ waꞌicʉre baꞌapeꞌotibosaꞌa” nírã, aꞌtiro weerãsaꞌa. Mʉsã ya wiꞌi pʉꞌto nirĩ wiꞌicjãrãrẽ pijio, sʉꞌori baꞌarãsaꞌa. Mʉsã baꞌaro ejatuaro “Ticʉrã masã nima” ni, eti baꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Cʉ̃ waꞌicʉ niꞌcã cʉ̃ꞌma cʉogʉ, ʉmʉ ne duti moogʉ̃, cãmi marĩgʉ̃ niato. Cʉ̃ oveja wĩꞌmagʉ̃ o cabracã niato. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Cʉ̃ waꞌicʉre ñeꞌe, cʉoyuya. Téé aꞌti mujĩpũ catorce nirĩ nʉmʉpʉ cʉotʉorãsaꞌa. Mʉsã nipeꞌtirã Israe curuacjãrã, niꞌcã wiꞌicjãrã ñamicaꞌa naꞌiqueꞌari cura waꞌicʉre wẽjẽrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Beꞌro te díre míí, mʉsã waꞌicʉre baꞌari wiꞌi sope sumutorire waꞌrerãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ñamipʉ te pecameꞌepʉ pʉ̃oꞌque diꞌire, tá sʉ̃ꞌese meꞌrã morẽꞌquere baꞌarãsaꞌa. Tojo nicã pã́ bʉcʉase meꞌrã morẽtiꞌquere baꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ne cãꞌrõ catise diꞌire, ne doꞌaꞌque diꞌire baꞌaticãꞌña. Waꞌicʉ cʉ̃ dʉpoa, cʉ̃ dʉꞌpocãrĩ, cʉ̃ ʉꞌtamisĩ nipeꞌtise meꞌrã pecameꞌepʉ pʉ̃onoꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tere ape nʉmʉpʉ baꞌarãti nírã, ne dʉꞌaticãꞌña. Dʉꞌsacãma, mejõ ʉ̃jʉ̃apeꞌocãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Suꞌti, sapatu sãña, mʉsã tuacjʉre cʉo, sojaro meꞌrã baꞌarãsaꞌa. Yʉꞌʉ Õꞌacʉ̃ Egiptopʉre yʉꞌrʉasere wãcũrĩ nʉmʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ti ñamita yʉꞌʉ nipeꞌtiro Egiptopʉre yʉꞌrʉagʉsaꞌa. Tojo yʉꞌrʉagʉ, nipeꞌtirã Egiptocjãrã masã maꞌmisʉmʉarẽ wẽjẽgʉ̃saꞌa. Tojo nicã na yarã ecarã ʉmʉa bajuamʉꞌtãꞌcãrãrẽ wẽjẽgʉ̃saꞌa. Nipeꞌtirã Egiptocjãrã ẽjõpeorãnojõrẽ buꞌiri daꞌregʉti. Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ weretojapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","” ’Mʉsã dí waꞌreꞌque wiꞌserire ĩꞌagʉ̃, “Israe curuacjãrã te wiꞌseripʉ nima”, ni masĩgʉ̃saꞌa. Tojo weegʉ Egiptocjãrãrẽ wẽjẽgʉ̃, te díre ĩꞌagʉ̃, diacjʉ̃ yʉꞌrʉa waꞌagʉsaꞌa. Ne niꞌcʉ̃ mʉsã wẽrĩsome. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Aꞌti nʉmʉrẽ mʉsã wãcũsiruturãsaꞌa. Tere wãcũrã, niꞌcã bosenʉmʉ yʉꞌʉ Õꞌacʉ̃rẽ weepeorãsaꞌa. Mʉsã ti bosenʉmʉrẽ weepeorã, tojo weenuꞌcũcãꞌrãsaꞌa. Cʉ̃ꞌmarĩnʉcʉ̃ mʉsã, mʉsã beꞌrocjãrã quẽꞌrã ti bosenʉmʉrẽ weenuꞌcũcãꞌrãsama. Aꞌte dutisere mʉsãrẽ cũuꞌu. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Siete nʉmʉrĩ pã́ bʉcʉase meꞌrã morẽtiꞌquere baꞌarãsaꞌa. Bosenʉmʉ nʉꞌcãrĩ nʉmʉ meꞌrã mʉsã ye wiꞌseripʉre pã́ bʉcʉacã weesere ne cʉoticãꞌña. Noꞌo te siete nʉmʉrĩrẽ pã́ bʉcʉase meꞌrã morẽꞌquere baꞌarãnojõ Israe curuacjãrã meꞌrã nimiꞌcãrã cõꞌawĩrõnoꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Bosenʉmʉ nʉꞌcãrĩ nʉmʉ mʉsã nerẽ, yʉꞌʉre eꞌcatipeori nʉmʉ nirõsaꞌa. Yapatiri nʉmʉ quẽꞌrãrẽ nerẽ, yʉꞌʉre eꞌcatipeori nʉmʉ nirõsaꞌa. Te nʉmʉrĩrẽ ne daꞌraticãꞌña. Baꞌase diaꞌcʉ̃rẽ doꞌacã, añurõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Pã́ bʉcʉase meꞌrã morẽtiꞌquere baꞌari bosenʉmʉrẽta mʉsãrẽ nipeꞌtirã Egiptopʉ níꞌcãrãrẽ miiwijagʉsaꞌa. Tojo weerã mʉsã ti nʉmʉrẽ bosenʉmʉ weepeorãsaꞌa. Cʉ̃ꞌmarĩnʉcʉ̃ mʉsã, mʉsã beꞌrocjãrã quẽꞌrã ti bosenʉmʉrẽ tojo weenuꞌcũcãꞌrãsaꞌa. Mʉsãrẽ te dutisere cũuꞌu. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Nimʉꞌtãrĩ mujĩpũ pã́ bʉcʉase meꞌrã morẽtiꞌquere baꞌarãsaꞌa. Catorce nirĩ nʉmʉ ñamicaꞌa meꞌrã baꞌanʉꞌcã, téé veintiuno nirĩ nʉmʉ ti mujĩpũrẽta ñamicaꞌapʉ baꞌatʉorãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mʉsã ye wiꞌseripʉre siete nʉmʉrĩ ne pã́ bʉcʉase meꞌrã morẽꞌque marĩato. Noꞌo niꞌcʉ̃ pã́ bʉcʉase meꞌrã morẽꞌquere baꞌagʉnojõ, Israe curuacjʉ̃ waro, o ape macãcjʉ̃ Israe curuacjãrã meꞌrã nisetigʉnojõ quẽꞌrã cõꞌawĩrõnoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tere wãcũrã, mʉsã pã́ bʉcʉase meꞌrã morẽꞌquere baꞌaticãꞌña. Mʉsã noꞌo nirṍ ti bosenʉmʉ nicã, pã́ bʉcʉase meꞌrã morẽꞌque marĩrõ baꞌaya’ ”, ni werecʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Beꞌro Moisé nipeꞌtirã Israe curuacjãrã wiorãrẽ pijidutioꞌocʉ niwĩ. Aꞌtiro nicʉ niwĩ: “Waꞌaya. Waꞌa, oveja wĩꞌmagʉ̃rẽ o cabracãrẽ ñeꞌe, mʉsã ya wiꞌicjãrãrẽ ecarãtirã miitia. Miiti, Õꞌacʉ̃ Egiptopʉre yʉꞌrʉari nʉmʉrẽ baꞌacjʉre wẽjẽña. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Díre niꞌcã pajopʉ cũuña. Beꞌro hisopo wãmetiri siti cja dʉpʉ mii, te díre yosoya. Beꞌro sope nipeꞌtiro sumutorire waꞌreya. Boꞌreati dʉporo ne niꞌcʉ̃ mʉsã ye wiꞌseripʉ níꞌcãrã wijaaticãꞌña. Topʉta tojacãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Õꞌacʉ̃ Egiptocjãrã masã maꞌmisʉmʉarẽ wẽjẽgʉ̃ waꞌagʉ, wiꞌserire yʉꞌrʉagʉ, sope sumutorire dí waꞌreꞌquere ĩꞌagʉ̃, ti wiꞌire diacjʉ̃ yʉꞌrʉagʉsami. Tojo weegʉ Õꞌacʉ̃ cʉ̃rẽ werecoꞌtegʉ masãrẽ wẽjẽgʉ̃rẽ mʉsã ye wiꞌserire sãjãcã cãꞌmotaꞌagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Aꞌte dutise cũuꞌquere mʉsã, mʉsã pãrãmerã nituriarã wiopesase meꞌrã cʉonuꞌcũrãsaꞌa. Mʉsã beꞌrocjãrã quẽꞌrãrẽ aꞌte dutise ninuꞌcũcãꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Õꞌacʉ̃ cʉ̃ níꞌcaronojõta cʉ̃ mʉsãrẽ ‘Oꞌogʉti’ níca diꞌtapʉre sãjã́ca beꞌro aꞌti bosenʉmʉrẽ weenuꞌcũrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mʉsã põꞌrã mʉsãrẽ ‘¿Aꞌti bosenʉmʉ deꞌro nisĩꞌrĩrõ weeti?’ ni sẽrĩtiñaꞌcã, ");
INSERT INTO tuoNT_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mʉsã aꞌtiro yʉꞌtiya: ‘Õꞌacʉ̃rẽ ẽjõpeorã, ãꞌrĩnojõ ovejare aꞌti bosenʉmʉnojõrẽ wẽjẽnoꞌo. Õꞌacʉ̃ Egiptocjãrã masã maꞌmisʉmʉarẽ wẽjẽ́caterore cʉ̃ Israe curuacjãrã ye wiꞌseri peꞌere diacjʉ̃ yʉꞌrʉacʉ niwĩ. Aꞌtiro wéégʉ, marĩ acawererã Israe curuacjãrãrẽ yʉꞌrʉocʉ niwĩ’, ni wereya”, nicʉ niwĩ Moisé. Tere tʉꞌorã, Israe curuacjãrã Õꞌacʉ̃rẽ eꞌcatipeorã, paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Beꞌro nipeꞌtise Õꞌacʉ̃ Moisére, Aarṍrẽ weedutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ñami deco nicã, Õꞌacʉ̃ nipeꞌtirã Egiptocjãrã masã maꞌmisʉmʉarẽ wẽjẽcʉ niwĩ. Faraṍ ti diꞌta wiogʉ macʉ̃ masã maꞌmi meꞌrã wẽjẽnʉꞌcã, téé buꞌiri daꞌreri wiꞌipʉ dujirã põꞌrã masã maꞌmisʉmʉapʉre wẽjẽtʉocʉ niwĩ. Tojo nicã waꞌicʉrã bajuamʉꞌtãꞌcãrãrẽ wẽjẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tojo waꞌacã, faraṍ, tojo nicã nipeꞌtirã cʉ̃ docacjãrã wiorã, nipeꞌtirã Egiptocjãrã ti ñamirẽ wãꞌcãpeꞌtia waꞌacãrã niwã. Nipeꞌtiro Egiptopʉre bʉjawetirã uti, caricũcãrã niwã. Ne niꞌcã wiꞌi masã maꞌmi wẽrĩtiri wiꞌi dʉꞌsaticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ti ñamita faraṍ Moisére, Aarṍrẽ pijidutioꞌocʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —Aꞌtore yarã masã meꞌrã ninemoticãꞌña. Wijaya. Mʉsã, nipeꞌtirã Israe curuacjãrã meꞌrã waꞌaya. Mʉsã níꞌcaronojõta mʉsã wiogʉ Õꞌacʉ̃rẽ eꞌcatipeorã waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mʉsã ʉaꞌcaronojõta mʉsã yarã ovejare, wecʉare miaña. Yʉꞌʉre Õꞌacʉ̃rẽ sẽrĩbosapa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egiptocjãrã Israe curuacjãrãrẽ na ya diꞌtare sojaro meꞌrã waꞌaduticãrã niwã. “Na maata wijaticãma, ʉ̃sã quẽꞌrã wẽrĩpeꞌtia waꞌabosaꞌa”, ni wãcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tojo weerã Israe curuacjãrã na pã́ weeatjere, bʉcʉase marĩrõ miacãrã niwã. Te morẽse coꞌripʉ na ye suꞌti caseri meꞌrã oma weetjĩarã wʉacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Tojo nicã Moisé cʉ̃ dutiꞌcaronojõta Egiptocjãrãrẽ uru meꞌrã weeꞌquere, plata meꞌrã weeꞌquere, tojo nicã suꞌtire sẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Õꞌacʉ̃ Egiptocjãrãrẽ apeyenojõ tʉꞌsaro meꞌrã Israe curuacjãrãrẽ oꞌocã weecʉ niwĩ. Aꞌtiro weerã Egiptocjãrãrẽ na cʉomiꞌque wapatisenojõrẽ miapeꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israe curuacjãrã Ramsés wãmetiri macãpʉ níꞌcãrã wija, Sucot wãmetiropʉ waꞌacãrã niwã. Ʉmʉa seiscientos mil waꞌtero dʉꞌpocã meꞌrã waꞌacãrã niwã. Numia, wĩꞌmarã baꞌpaqueoya marĩrõ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na meꞌrã pãjãrã Israe curuacjãrã nitirã, tojo nicã pãjãrã oveja, wecʉa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egiptocjãrã Israe curuacjãrãrẽ sojaro meꞌrã waꞌaduticãrã niwã. Tojo weerã Israe curuacjãrã na baꞌatjere apoyuticãrã niwã. Na pã́ weeatje bʉcʉase marĩrõ na Egiptopʉ miitiꞌque meꞌrã opa caseri wee, pʉ̃ꞌobaꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Na Israe curuacjãrã cuatrocientos treinta cʉ̃ꞌmarĩ Egiptopʉre nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ticʉse cʉ̃ꞌmarĩ waꞌari nʉmʉrẽta Egiptopʉre Õꞌacʉ̃ yarã masã doce curari nirã́ wijapeꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ti ñamirẽ Õꞌacʉ̃ narẽ añurõ ĩꞌanʉrʉ̃ coꞌtecʉ niwĩ. Egiptopʉ nirãrẽ miiwijagʉti nígʉ̃, tojo weecʉ niwĩ. Tojo weerã cʉ̃ꞌmarĩnʉcʉ̃ Israe curuacjãrã Õꞌacʉ̃ ti ñamirẽ narẽ coꞌteꞌquere wãcũrã, cãrĩtiboꞌreasama. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraṍ Israe curuacjãrãrẽ duꞌuwĩrõcaterore Õꞌacʉ̃ narẽ filisteo masã nirĩ diꞌta yʉꞌrʉtẽrĩrĩ maꞌapʉ miaticʉ niwĩ. Ti maꞌa diacjʉ̃ca maꞌa nimicã, aꞌtiro wãcũcʉ niwĩ: “Filisteo masã na meꞌrã aꞌmewẽjẽsĩꞌrĩcã, na uirã, aꞌmewẽjẽrõnojõ oꞌorã, Egiptopʉ dajatojabosama”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tojo weegʉ Maa Sõꞌarĩ maapʉ waꞌadutigʉ, masã marĩrõ, yucʉ marĩrõ nirĩ maꞌa peꞌe beꞌtoawãꞌcãcã weecʉ niwĩ. Israe curuacjãrã Egipto diꞌtare wijarã, surara aꞌmewẽjẽrã waꞌarã weronojõ wijawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisé cʉ̃ José mijĩ ye õꞌarĩ mejãrẽ miacʉ niwĩ. Todʉporopʉ José Israe curuacjãrãrẽ tojo weeduticʉ niwĩ. Titare José narẽ nicʉ niwĩ: “Õꞌacʉ̃ mʉsãrẽ diacjʉ̃ta weetamugʉ̃ aꞌtigʉsami. Te tojo waꞌacã, ye õꞌarĩ mejãrẽ mʉsã miaña. Õꞌacʉ̃ wãme meꞌrã ‘Tojota weerãti’, niña”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israe curuacjãrã Sucore wija, téé Etam wãmetiro masã marĩrõ, yucʉ marĩrõ sumutopʉ tojaqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Õꞌacʉ̃ na dʉporo waꞌayucʉ niwĩ. Ʉmʉcjore oꞌmepõꞌrã meꞌrã narẽ maꞌa sʉꞌori ĩꞌogʉ̃, baꞌpaticʉ niwĩ. Ñami peꞌere niꞌcã pecameꞌe ʉ̃jʉ̃rĩ põꞌrã meꞌrã, narẽ sĩꞌoo, baꞌpaticʉ niwĩ. Cʉ̃ tojo weecã, ñami, ʉmʉco waꞌamʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Oꞌmepõꞌrã peꞌe ʉmʉcore na dʉporo ʉꞌmʉtãcaro niwʉ̃. Ñami peꞌema pecameꞌe ʉ̃jʉ̃rĩ põꞌrã ʉꞌmʉtãcaro niwʉ̃. Tojo diaꞌcʉ̃ waꞌanuꞌcũcãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Israe curuacjãrã Etãpʉ nirĩ cura Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Israe curuacjãrãrẽ majãmitojatidutiya. Narẽ Pi-hahirot wãmetiri macã põtẽorõ, Baal-zefón pʉꞌtopʉ tojaqueꞌadutiya. To Migdol, Maa Sõꞌarĩ maa waꞌtero tojaꞌa. Na topʉ maa sumutopʉ na ye wiꞌseriacãrẽ bʉa, tojaqueꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Na tojo weecã, faraṍ aꞌtiro wãcũgʉ̃sami: ‘Ãꞌrã Israe curuacjãrã noꞌo apero waꞌamasĩtima. Na masã marĩrõ, yucʉ marĩrõpʉ wisinuꞌcũbajaqueꞌatima’, nigʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Faraṍrẽ yʉꞌʉre yʉꞌrʉnʉꞌcãcã weegʉti. Tojo weegʉ Israe curuacjãrãrẽ ñeꞌesĩꞌrĩgʉ̃, sirutugʉsami. Cʉ̃ tojo weecã, yʉꞌʉ peꞌe cʉ̃rẽ, cʉ̃ yarã surarare docaqueꞌacã weegʉ, yʉꞌʉ tutuasere ĩꞌogʉ̃ti. Nipeꞌtirã Egiptocjãrã tojo waꞌacã ĩꞌarã, ‘Yʉꞌʉ wiogʉ niꞌi’ nisere masĩrãsama”, nicʉ niwĩ Õꞌacʉ̃. Israe curuacjãrã cʉ̃ tojo dutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Egiptocjʉ̃ wiogʉ na duꞌtiwijaꞌque quetire tʉꞌogʉ, cʉ̃, cʉ̃ docacjãrã wiorã meꞌrã na wãcũꞌquere mejẽcã dʉcayu, aꞌtiro nicãrã niwã: “¿Marĩ deꞌro weerã Israe curuacjãrãrẽ duꞌuoꞌomiapari? Na marĩrẽ daꞌracoꞌterã nimiama”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Maata faraṍ cʉ̃ aꞌmewẽjẽse cabayua wejesepawʉ tũrũsepawʉre apoduticʉ niwĩ. Cʉ̃ yarã surara pãjãrã meꞌrã Israe curuacjãrãrẽ sirutucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","To waꞌagʉ, seiscientopawʉ, tũrũse añusepawʉre miacʉ niwĩ. Tojo nicã, nipeꞌtise Egipto cjase surara yepawʉre miacʉ niwĩ. Tepawʉnʉcʉ̃ niꞌcʉ̃ surara wiogʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Õꞌacʉ̃ faraṍrẽ cʉ̃rẽ yʉꞌrʉnʉꞌcãcã weecʉ niwĩ. Tojo weegʉ faraṍ Israe curuacjãrãrẽ sirutucʉ niwĩ. Na peꞌe wijarãpʉta uiro marĩrõ wijatojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Egiptocjãrã yarã surara dʉꞌpocã meꞌrã waꞌarã, cabayua pesarã meꞌrã, na ye aꞌmewẽjẽsepawʉ meꞌrã Israe curuacjãrãrẽ siruturã waꞌacãrã niwã. Narẽ Maa Sõꞌarĩ maa sumutopʉ tojaqueꞌarãrẽ ẽmʉjácãrã niwã. To Pi-hahirot pʉꞌtopʉ Baal-zefón põtẽorõpʉ tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Israe curuacjãrã faraṍ, tojo nicã Egiptocjãrã na pʉꞌto aꞌticã ĩꞌarã, ʉcʉacãrã niwã. Tojo weerã Õꞌacʉ̃rẽ weetamuse ʉpʉtʉ sẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Moisére aꞌtiro nicãrã niwã: —¿Egiptopʉre masã wẽrĩcã yaase peri marĩrĩ? ¿Ʉ̃sãrẽ topʉ níꞌcãrãrẽ aꞌto masã marĩrõ, yucʉ marĩrõpʉ wẽrĩdutigʉ miitiri? ¿Deꞌro weeacjʉ Egiptopʉ níꞌcãrãrẽ aꞌtopʉ miitiri? ");
INSERT INTO tuoNT_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ʉ̃sã Egiptopʉ nírã quẽꞌrã mʉꞌʉrẽ aꞌtereta ucũmiwʉ̃: “Ʉ̃sãrẽ cariboticãꞌña. Ʉ̃sã Egiptocjãrãrẽ daꞌrawãꞌñacoꞌtecã, tojo ĩꞌacãꞌña,” nimiwʉ̃. Niꞌcãrõacãma masã marĩrõ, yucʉ marĩrõpʉ ʉ̃sã wẽrĩcã ñaꞌa niꞌi. Narẽ daꞌracoꞌterã ninuꞌcũcã nemorõ añubopã, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Na tojo nicã, Moisé narẽ yʉꞌticʉ niwĩ: —Mʉsã uiticãꞌña. Totá tojaqueꞌaya. Õꞌacʉ̃ niꞌcãcã mʉsãrẽ yʉꞌrʉoatjere ĩꞌarãsaꞌa. Egiptocjãrã mʉsã niꞌcãcã ĩꞌarãrẽ ne apaturi ĩꞌanemosome. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Õꞌacʉ̃ cʉ̃ basu mʉsãrẽ aꞌmewẽjẽbosagʉsami. Tojo weerã ne wãcũqueꞌtiticãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —¿Deꞌro weegʉ yʉꞌʉre weetamuse sẽrĩgʉ̃ caricũti? Israe curuacjãrãrẽ pijio, waꞌadutiya. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mʉꞌʉ tuacjʉre maajopʉre sĩ́oña. Mʉꞌʉ tojo weecã, maa deco meꞌrã dʉcawatirosaꞌa. Israe curuacjãrã aco marĩ, bopori maꞌapʉ pẽꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Yʉꞌʉ peꞌe Egiptocjãrãrẽ mʉsãrẽ ñaꞌarõ wãcũcã weegʉti. Tojo weerã mʉsãrẽ wẽjẽsĩꞌrĩrã siruturãsama. Na tojo weecã, faraṍrẽ, cʉ̃ yarã surarare, cʉ̃ ye tũrũsepawʉre, surara cabayua pesarãrẽ yʉꞌʉ tutuayʉꞌrʉasere ĩꞌogʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Yʉꞌʉ faraṍrẽ, cʉ̃ ye tũrũsepawʉre, surara cabayua pesarãrẽ docaqueꞌacã wééca beꞌro Egiptocjãrã yʉꞌʉre “Diacjʉ̃ta Õꞌacʉ̃ wiogʉ nimi”, ni masĩrãsama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Cʉ̃ tojo ni ucũrĩ curata Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã na siro peꞌe sirutunʉꞌcãcʉ niwĩ. Tojo nicã oꞌmepõꞌrã na dʉporo ʉꞌmʉtãmiꞌcaro quẽꞌrã na siro peꞌe tja sirutunʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Tojo wee ti põꞌrã Egiptocjãrã surara, Israe curuacjãrã decore ejanʉꞌcãcaro niwʉ̃. Ñamipʉ ti oꞌmepõꞌrã Egiptocjãrãrẽ naꞌiatĩꞌacã weecaro niwʉ̃. Israe curuacjãrã peꞌema boꞌreyucaro niwʉ̃. Tojo weerã Egiptocjãrã ti ñamirẽ Israe curuacjãrãrẽ ne ẽmʉticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moisé cʉ̃ ya omocãrẽ maajopʉre sĩ́onuꞌcũcʉ niwĩ. Cʉ̃ tojo weeri cura Õꞌacʉ̃ mujĩpũ mʉjãtiro peꞌe cjase wĩꞌrõrẽ ʉpʉtʉ wẽetuucã weecʉ niwĩ. Te wĩꞌrõ nipeꞌtiro ti ñamirẽ wẽetuuboꞌreacaro niwʉ̃. Tojo weero ti maajore pʉaperi dʉcawaticaro niwʉ̃. Aꞌtiro wee Õꞌacʉ̃ ti maajore bopori maꞌa waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Diꞌta boposãjãrõpʉ Israe curuacjãrã pẽꞌacãrã niwã. Topʉre pʉa taꞌtiajo aco dʉcawaanoꞌcaro niwʉ̃. Buꞌi peꞌe ape tʉꞌrʉjo, siro peꞌe ape tʉꞌrʉjo nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Faraṍ yarã surara, cʉ̃ ye tũrũsepawʉ meꞌrã Israe curuacjãrã beꞌro ti maajo decopʉ narẽ sirututʉocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Boꞌreati dʉporo Õꞌacʉ̃ ʉ̃jʉ̃rĩ põꞌrã, oꞌmecuruapʉ nígʉ̃, Egiptocjãrã surarare ĩꞌadijocʉ niwĩ. Tojo ĩꞌadijotjĩagʉ̃, narẽ noꞌo ʉaro waꞌamaꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tojo nicã na ye tũrũsepawʉre tũrũsepa wetiwijacã weecʉ niwĩ. Tojo weerã ʉmʉñarõ waꞌamasĩticãrã niwã. Tere ĩꞌarã, Egiptocjãrã aꞌtiro nicãrã niwã: —¡Teꞌa, Israe curuacjãrãrẽ tocãꞌrõta sirutuduꞌurã marĩ! Õꞌacʉ̃ marĩrẽ ĩꞌatuꞌtigʉ, narẽ aꞌmewẽjẽbosagʉ weemi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Mʉꞌʉ ya omocãrẽ ti maajopʉre sĩ́oña tja. Mʉꞌʉ tojo weecã, aco dʉcawaanʉꞌcõmiꞌque Egiptocjãrã buꞌipʉ paamio, na ye tũrũsepawʉ, na surara cabayua buꞌipʉ níꞌcãrãrẽ miopeꞌorosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tojo weegʉ Moisé cʉ̃ ya omocãrẽ ti maajo buꞌipʉ sĩ́ocʉ niwĩ. Boꞌreari cura mejãrõta ti maajo níꞌcaronojõta tojacaro niwʉ̃. Na Egiptocjãrã duꞌtisĩꞌrĩmirã, aco paamionoꞌcãrã niwã. Tojo wee Õꞌacʉ̃ narẽ ti maapʉ miodijocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tojo waꞌacã, tũrũsepawʉ, surara cabayua pesaꞌcãrã, nipeꞌtirã surara, ti maajopʉ Israe curuacjãrãrẽ siruturã waꞌamiꞌcãrã mirĩpeꞌtia waꞌacãrã niwã. Ne niꞌcʉ̃ faraṍ yarã yʉꞌrʉwetiticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tojo waꞌamicã, Israe curuacjãrã peꞌe ti maajore diꞌta boposãjãrõpʉ pẽꞌacãrã niwã. Aco pʉa taꞌtiajo dʉcawaanoꞌcaropʉ, niꞌcãrõ buꞌi peꞌe, apero siro peꞌe nirõrẽ pẽꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ti nʉmʉ nicã, Õꞌacʉ̃ Israe curuacjãrã Egiptocjãrã dutise doca níꞌcãrãrẽ yʉꞌrʉweticã weecʉ niwĩ. Israe curuacjãrã Egiptocjãrã wẽrĩꞌcãrã mejãrãrẽ ti maa sumutopʉ cũñacã ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israe curuacjãrã Õꞌacʉ̃ cʉ̃ tutuayʉꞌrʉase meꞌrã Egiptocjãrãrẽ tojo docaqueꞌacã weecã ĩꞌarã, Õꞌacʉ̃rẽ wiopesase meꞌrã ĩꞌa, cʉ̃rẽ ẽjõpeocãrã niwã. Moisé, Õꞌacʉ̃ dutisere daꞌracoꞌtegʉ quẽꞌrãrẽ ẽjõpeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Õꞌacʉ̃ Egiptocjãrãrẽ maajopʉ miopeꞌocã ĩꞌarã, Moisé, tojo nicã Israe curuacjãrã aꞌte basasere cʉ̃rẽ basapeocãrã niwã: “Õꞌacʉ̃ añubutiaro cʉ̃ waparãrẽ docaqueꞌacã weewĩ. Cabayua pesaꞌcãrãrẽ pajiri maajopʉ doqueñojã, mirĩdijacã weewĩ. Tere wãcũgʉ̃, cʉ̃rẽ basapeogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Õꞌacʉ̃ yʉꞌʉ wiogʉ yʉꞌʉre tutuacã weemi. Cʉ̃rẽ wãcũgʉ̃, basapeoꞌo. Cʉ̃ta yʉꞌʉre ĩꞌatuꞌtiꞌcãrãrẽ yʉꞌʉre yʉꞌrʉweticã weemi. Cʉ̃, yʉꞌʉ ẽjõpeogʉ Õꞌacʉ̃ nimi. Cʉ̃rẽ basapeogʉti. Cʉ̃ yʉꞌʉ pacʉ ẽjõpeoꞌcʉ nimi. Cʉ̃rẽ eꞌcatipeogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Õꞌacʉ̃ aꞌmewẽjẽrĩ masʉ̃ tutuagʉ weronojõ nimi. Cʉ̃rẽ ‘Mʉꞌʉ wiogʉta niꞌi’, ninoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Õꞌacʉ̃, faraṍ ye tũrũsepawʉ, tojo nicã cʉ̃ yarã surarare Maa Sõꞌarĩ maajopʉ mirĩdijacã weewĩ. Cʉ̃ yarã wiorã aꞌmewẽjẽtutuayʉꞌrʉrã, Maa Sõꞌarĩ maajopʉ mirĩ boawã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Na dia poꞌpeapʉ ʉ̃tãperi nʉcʉ̃rõ weronojõ diꞌadijawã. Ti maa ʉ̃ꞌcʉ̃arĩ maajo miidijawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Õꞌacʉ̃, yʉꞌʉ wiogʉ, mʉꞌʉ ya omocã diacjʉ̃camocã meꞌrã mʉꞌʉrẽ ĩꞌatuꞌtigʉre wẽjẽpeꞌowʉ. Ti omocã meꞌrãta mʉꞌʉ tutuasere ĩꞌanoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mʉꞌʉ tutuayʉꞌrʉase meꞌrã, mʉꞌʉ meꞌrã aꞌmewẽjẽrãrẽ mejõ nirã tojacã weewʉ. Mʉꞌʉ uase pecameꞌe ʉ̃jʉ̃rĩ põꞌrã tá boposãjãsere ʉ̃jʉ̃arõ weronojõ narẽ peꞌowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Mʉꞌʉ ẽꞌquẽa meꞌrã ejerimiquejo, acore dʉcawaa, pʉaperi tuuneocũuwʉ̃. Te pãꞌcõrĩ paca pʉaperi nʉꞌcãejawʉ. Maa decopʉ bʉꞌaro weronojõ ne aꞌmeñaꞌmaꞌatiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mʉꞌʉrẽ ĩꞌatuꞌtigʉ peꞌe aꞌtiro wãcũcʉ nimiwĩ: ‘Narẽ sirutu, ẽmʉgʉ̃ti. Yʉꞌʉ na cʉosere ẽꞌma, dʉcawaagʉti. Yʉꞌʉ noꞌo miisĩꞌrĩrõ miigʉ̃ti. Ya diꞌpjĩjore mii, narẽ wẽjẽcõꞌagʉ̃ti’, nicʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mʉꞌʉ peꞌe putistegʉ weronojõ weewʉ. Tojo weecã, ti maajo narẽ miocõꞌawʉ̃. Na ti maajo ʉpʉtʉ wĩꞌrõ wẽetuuri cura cõme nʉcʉ̃rõ weronojõ diꞌadijawã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wiogʉ, ne niꞌcʉ̃ ãpẽrã ẽjõpeogʉnojõ mʉꞌʉrẽ niꞌcãrõwijimasĩtimi. Nipeꞌtirã yʉꞌrʉoro tutuayʉꞌrʉnʉꞌcãꞌa. Ne niꞌcʉ̃ mʉꞌʉ weronojõ ñaꞌase moogʉ̃ marĩmi. Añuse, wiopesase weeĩꞌogʉ̃ niꞌi. Tojo weerã nipeꞌtirã masã mʉꞌʉrẽ ‘Añuyʉꞌrʉami’, ni basapeoato. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mʉꞌʉ ya diacjʉ̃camocãrẽ sĩ́ocã, dia mʉꞌʉrẽ ĩꞌatuꞌtirãrẽ miimádija waꞌawʉ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Õꞌacʉ̃, ʉ̃sã wiogʉ, mʉꞌʉ dutise ninuꞌcũcãꞌrõsaꞌa”, ni basapeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faraṍ ye aꞌmewẽjẽse tũrũsepawʉ, cʉ̃ yarã cabayuapʉ pesarã, tojo nicã surara, ti maajopʉre na sãjãnʉꞌcãwãꞌcãrĩ cura Õꞌacʉ̃ na buꞌipʉ aco bʉrʉpeja, mirĩcã weecʉ niwĩ. Israe curuacjãrã peꞌe diꞌta boporopʉ pẽꞌa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Beꞌro Aarṍ maꞌmio María, Õꞌacʉ̃ yere weremʉꞌtãgõ, niꞌcãrõ na basarã omocã meꞌrã paawʉarore miico niwõ. Nipeꞌtirã ãpẽrã numia co beꞌro siruturã quẽꞌrã tonojõ meꞌrã paarãta basacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Co peꞌe narẽ sʉꞌori basaco niwõ: “Õꞌacʉ̃rẽ basapeoya. Cʉ̃rẽ ĩꞌatuꞌtiꞌcãrãrẽ docaqueꞌacã weewĩ. Dia pajiri maajopʉ, cabayuare, surara na buꞌipʉ pesaꞌcãrãrẽ mirĩdijacã weewĩ”, ni basaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisé Israe curuacjãrãrẽ Maa Sõꞌarĩ maajopʉ níꞌcãrãrẽ miiwijáca beꞌro aperopʉ sʉꞌori miacʉ niwĩ. Na masã marĩrõ, yucʉ marĩrõ Shur wãmetiropʉ waꞌacãrã niwã. Topʉre iꞌtia nʉmʉ sijacãrã niwã. Ne aco bocaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Na Mara wãmetiropʉ etarã, to cjase acore ne sĩꞌrĩmasĩticãrã niwã. Te aco sʉ̃ꞌese niyucã, tojo weecãrã niwã. Tojo weerã tore Mara wãmeyecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Aco añusenojõ marĩcã ĩꞌarã, masã Moisére ñaꞌarõ ucũnʉꞌcãcãrã niwã. Cʉ̃rẽ aꞌtiro ni sẽrĩtiñaꞌcãrã niwã: “¿Marĩ ñeꞌenojõrẽ sĩꞌrĩrãsari?” nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tere tʉꞌogʉ, Moisé Õꞌacʉ̃rẽ weetamuse ʉpʉtʉ sẽrĩcʉ niwĩ. Cʉ̃ peꞌe niꞌcã yucʉdʉpʉ ĩꞌocʉ niwĩ. Moisé ti dʉpʉre acopʉ doqueñocʉ niwĩ. Cʉ̃ tojo weecãta, aco iꞌpitise waꞌacaro niwʉ̃. Õꞌacʉ̃ narẽ “¿Yʉꞌʉ dutiro weerãsari?” nígʉ̃, tojo weecʉ niwĩ. Topʉta niꞌcã dutiro na añurõ weesetiatjere cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Aꞌtiro nicʉ niwĩ: “Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. Mʉsãrẽ dutire yʉꞌrʉogʉ niꞌi. Mʉsã diacjʉ̃ta yʉꞌʉ dutisere yʉꞌticã, yʉꞌʉ tʉꞌsasenojõrẽ, yʉꞌʉ dutise cũuꞌquere queoro weecã, yʉꞌʉ Egiptocjãrãrẽ buꞌiri daꞌreꞌquenojõrẽ mʉsãrẽ ne cãꞌrõ weesome”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Beꞌro na yʉꞌrʉa, Elim wãmetiropʉ etacãrã niwã. Topʉre doce aco wijase peri nicaro niwʉ̃. Tojo nicã setenta ñorĩ nicaro niwʉ̃. Topʉre aco pʉꞌtoacã tojaqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nipeꞌtirã Israe curuacjãrã Elim wãmetirore wijawãꞌcã, Sin wãmetiro masã marĩrõ, yucʉ marĩrõpʉ etacãrã niwã. To Elim, Sinaí decopʉ tojacaro niwʉ̃. Titare Egiptore na wijáca beꞌro nimʉꞌtãrĩ mujĩpũ beꞌro cja mujĩpũ quince nirĩ nʉmʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Topʉ masã marĩrõ, yucʉ marĩrõpʉre na nipeꞌtirã Moisé, Aarṍrẽ ñaꞌarõ ũrũsãnʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Aꞌtiro nicãrã niwã: —Marĩrẽ Õꞌacʉ̃ Egiptopʉ wẽrĩcã weecã, añu nibopã. Topʉre marĩ baꞌase waꞌicʉ diꞌi doꞌaꞌqueparʉ waꞌtero dujimiwʉ̃. Marĩ baꞌasĩꞌrĩrõ ejatuaro baꞌa yapiwʉ. Mʉsã peꞌe ʉ̃sã nipeꞌtirãrẽ masã marĩrõ, yucʉ marĩrõpʉ ʉjʉaboase meꞌrã wẽrĩdutirã, miitiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Na tojo ucũcã tʉꞌogʉ, Õꞌacʉ̃ Moisére nicʉ niwĩ: —Yʉꞌʉ mʉsãrẽ ʉꞌmʉse cjase baꞌase acoro pejaro weronojõ dijaticã weegʉti. Masã ʉmʉcorinʉcʉ̃ te baꞌasere miirã waꞌarãsama. Na niꞌcã nʉmʉrẽ baꞌatje ejatuaro seerãsama. Te meꞌrã “¿Noanojõ yʉꞌʉ dutiꞌquere queoro weeti, noa yʉꞌrʉnʉꞌcãti?” nímasĩgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Niꞌcãmocʉse nʉmʉrĩ beꞌro cja nʉmʉrẽ, na pʉa nʉmʉ baꞌatjere seero weronojõ weeato, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tojo weerã Moisé, Aarṍ Israe curuacjãrãrẽ werecãrã niwã: —Niꞌcãcã naꞌiqueꞌari cura mʉsã marĩ wiogʉ Õꞌacʉ̃ta mʉsãrẽ Egiptopʉ níꞌcãrãrẽ miiwijaꞌquere masĩrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ñamiacã ñamicure peꞌere Õꞌacʉ̃ cʉ̃ asistesere ĩꞌarãsaꞌa. Mʉsã cʉ̃rẽ ũrũsãsere tʉꞌoami. ¿Deꞌro weerã ʉ̃sãrẽ ũrũsãti? Ʉ̃sã mejõ nirã niꞌi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moisé apeye narẽ ninemocʉ niwĩ: —Ñamicaꞌa nicã Õꞌacʉ̃ mʉsã baꞌatji diꞌirore oꞌogʉsami. Boꞌreacãma mʉsãrẽ peje baꞌase pã́ weronojõ nisere oꞌogʉsami. Mʉsã cʉ̃rẽ ñaꞌarõ ucũ, ũrũsãsere tʉꞌoami. Mʉsã ũrũsãrã, ʉ̃sã mejẽtare ñaꞌarõ ucũrã weeapʉ. Õꞌacʉ̃ peꞌere ñaꞌarõ ucũrã weeapʉ. Ʉ̃sã mejõ nirã niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Beꞌro Moisé Aarṍrẽ nicʉ niwĩ: —Nipeꞌtirã Israe curuacjãrãrẽ Õꞌacʉ̃ ĩꞌorõpʉ aꞌtidutiya. Na ñaꞌarõ ũrũsãsere tʉꞌoami, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aarṍ na meꞌrã ucũrĩ curata nipeꞌtirã Israe curuacjãrã masã marĩrõ, yucʉ marĩrõpʉ ĩꞌaquejocãrã niwã. Wãcũña marĩrõ Õꞌacʉ̃ asistese oꞌmecurua poꞌpeapʉ bajucaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","—Israe curuacjãrã na ñaꞌarõ ũrũsãsere tʉꞌoapʉ. Narẽ aꞌtiro ni wereya: “Naꞌiqueꞌari cura mʉsã waꞌicʉ diꞌi baꞌarãsaꞌa. Ñamiacã ñamicure peꞌere pã́ mʉsã baꞌasĩꞌrĩrõ põtẽorõ baꞌarãsaꞌa. Te meꞌrã mʉsã ‘Yʉꞌʉ mʉsã wiogʉ Õꞌacʉ̃ niꞌi’, nisere masĩrãsaꞌa”, niña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ti nʉmʉ ñamicaꞌata putuá weronojõ bajurã pãjãrã na tiropʉ dijatacãrã niwã. Na nirõpʉre muꞌmua waꞌacãrã niwã. Ape nʉmʉ ñamicure nucũcãpʉre ñocõa ʉꞌseco na nirõpʉre cũñacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Beꞌro te ñocõa ʉꞌseco bopóca beꞌro, te diꞌa diaꞌcʉ̃ bʉꞌa bopoqueꞌaꞌque masã marĩrõ, yucʉ marĩrõpʉre nucũcãpʉ cũñacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Na Israe curuacjãrã tere ne ĩꞌamasĩtirã, “¿Ñeꞌenojõ niti?”, ni aꞌmerĩ sẽrĩtiñaꞌcãrã niwã. Moisé narẽ nicʉ niwĩ: —Aꞌte mʉsã pã́ weeatje Õꞌacʉ̃ cʉ̃ oꞌose niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Õꞌacʉ̃ mʉsãrẽ aꞌtiro weedutiami: “Mʉsãnʉcʉ̃ mʉsã baꞌatjo ejatuaro seeya. Mʉsã ye wiꞌseripʉ nirãnʉcʉ̃ pʉa kilo cãꞌrõ seeya”, niami, ni werecʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Na cʉ̃ miidutiꞌcaronojõta weecãrã niwã. Ãpẽrã pajiro, ãpẽrã cãꞌrõacã seecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Na seeꞌquere queocã, peje seeꞌcʉre yʉꞌrʉoticaro niwʉ̃. Pejeti seeꞌcãrã quẽꞌrãrẽ queoro ejacaro niwʉ̃. Dʉꞌsaticaro niwʉ̃. Nanʉcʉ̃ na baꞌaro ejatuaro seecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Beꞌro Moisé narẽ nicʉ niwĩ: —Ne niꞌcʉ̃ mʉsã ape nʉmʉ baꞌatjere dʉꞌaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Moisé tojo nimicã, ãpẽrã cʉ̃ níꞌquere yʉꞌrʉnʉꞌcãcãrã niwã. “Ape nʉmʉpʉ baꞌarãti” nírã, dʉꞌacãrã niwã. Te na dʉꞌaꞌque becoa boa waꞌa, ʉ̃rĩa waꞌacaro niwĩ. Tere ĩꞌagʉ̃, Moisé na meꞌrã ua waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Beꞌro ʉmʉcorinʉcʉ̃ ñamicurere nipeꞌtirã na baꞌaro ejatuaro seeneocãrã niwã. Mujĩpũ asiro meꞌrã te acoapeꞌtiacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Niꞌcãmocʉse nʉmʉrĩ beꞌro cja nʉmʉrẽ pʉa nʉmʉ baꞌatjere weronojõ seeneocãrã niwã. Baꞌparitise kilo niꞌcʉ̃ baꞌatjere seeneocãrã niwã. Na tojo weecã ĩꞌarã, Israe curuacjãrãrẽ sʉꞌori nisetiri masã Moisé tiropʉ waꞌa, cʉ̃rẽ werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Na tere werecã tʉꞌogʉ, Moisé narẽ nicʉ niwĩ: —Õꞌacʉ̃ aꞌtiro dutiami: “Ñamiacã mʉsã sooatji nʉmʉ nirõsaꞌa. Yʉꞌʉre wãcũ, eꞌcatipeoatji nʉmʉ mʉsãrẽ cũuꞌu. Mʉsã baꞌase doꞌasenojõrẽ niꞌcãcã doꞌaweꞌocãꞌña. Mʉsã baꞌase pʉ̃osenojõrẽ pʉ̃oweꞌocãꞌña. Mʉsãrẽ baꞌase dʉꞌsacã, ‘Ñamiacãpʉ baꞌarãti’ nírã dʉꞌaya”, niami Õꞌacʉ̃, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moisé narẽ dutiꞌcaronojõta na baꞌadʉꞌaꞌquere ape nʉmʉ baꞌatjere dʉꞌacãrã niwã. Te baꞌase ne dojoti, ne becoa boꞌoticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Beꞌro Moisé narẽ nicʉ niwĩ: —Niꞌcãcã mʉsãrẽ soodutiri nʉmʉ, Õꞌacʉ̃rẽ eꞌcatipeori nʉmʉ niꞌi. Tojo weerã tere baꞌaya. Mʉsã niꞌcãcãrẽ cãpũpʉre ne apeyenojõ baꞌase bocasome. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mʉsã seis nʉmʉrĩrẽ baꞌase seeneorãsaꞌa. Siete nʉmʉrĩ waꞌari cura sauru, Õꞌacʉ̃ soodutíca nʉmʉ niꞌi. Ti nʉmʉma baꞌase seese marĩrõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Moisé tojo nimicã, ti nʉmʉrẽta niꞌcãrẽrã baꞌase seerã waꞌacãrã nimiwã. Ne bocaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ Moisére nicʉ niwĩ: —¿Noꞌocãꞌrõ yoacã mʉsã yʉꞌʉ dutise, yʉꞌʉ buꞌese cũuꞌquere yʉꞌrʉnʉꞌcãrãsari? ");
INSERT INTO tuoNT_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Aꞌtere masĩña. Yʉꞌʉ, mʉsã wiogʉ, mʉsãrẽ soodutigʉ, niꞌcã nʉmʉ cũuapʉ. Tojo weegʉ seis nʉmʉ nirĩ nʉmʉrẽ pʉa nʉmʉ baꞌasere oꞌogʉti. Ape nʉmʉ peꞌe mʉsãrẽ soodutiri nʉmʉ nicã, nipeꞌtirã mʉsã ye wiꞌseripʉ tojayá. Ne wijaaticãꞌña, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tojo weerã siete nʉmʉ nirĩ nʉmʉrẽ soocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israe curuacjãrã na baꞌase seeneosere maná wãme pisucãrã niwã. Te cilantro wãmetise cape weronojõ butise peri bajucaro niwʉ̃. Pʉ̃ꞌarṍ ʉsemerĩseacã mumiaco meꞌrã weeꞌque weronojõ iꞌpitimeꞌrĩcãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisé narẽ aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ aꞌtiro weedutiami: “Pʉa kilo ejatuaro see, nʉrõña. Tere mʉsã pãrãmerã nituriarãpʉre mʉsã masã marĩrõ, yucʉ marĩrõpʉ nícaterore yʉꞌʉ baꞌase oꞌoꞌquere ĩꞌarãsama. Yʉꞌʉ mʉsãrẽ Egiptopʉ miiwijacã oꞌoꞌquere ĩꞌarãsama”, niami, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Beꞌro Moisé Aarṍrẽ aꞌtiro nicʉ niwĩ: —Niꞌcãrʉ̃ miiti, tirʉpʉ pʉa kilo manárẽ miisãaña. Beꞌro tere Õꞌacʉ̃ ĩꞌorõpʉ cũuña. Tere mʉsã põꞌrã, mʉsã pãrãmerã nituriarã ĩꞌato nígʉ̃, nʉrõbosaya. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Õꞌacʉ̃ Moisére tojo weedutiꞌcaronojõta, Aarṍ Õꞌacʉ̃ “Masã meꞌrã añurõ weegʉti” níꞌquere cʉori acaro dʉporo tirʉre nʉrõdutigʉ dʉpocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israe curuacjãrã cuarenta cʉ̃ꞌmarĩ manárẽ baꞌacãrã niwã. Canaá diꞌta sumuto etarãpʉ tere baꞌatʉocãrã niwã. Canaá na niatji diꞌta nicaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nipeꞌtirã Israe curuacjãrã masã marĩrõ, yucʉ marĩrõ, Sin wãmetiropʉ níꞌcãrã wijawãꞌcãcãrã niwã. Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta sajatiro waꞌameꞌrĩcãꞌcãrã niwã. Waꞌa, Refidim wãmetiropʉ tojaqueꞌacãrã niwã. Topʉre ne aco na sĩꞌrĩse marĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tojo weerã Moisére uase meꞌrã, “Ʉ̃sãrẽ aco sĩꞌrĩse oꞌoya”, nicãrã niwã. Moisé peꞌe “¿Deꞌro weerã yʉꞌʉre tojo ucũti? ¿Deꞌro weerã ‘¿Õꞌacʉ̃ ʉ̃sãrẽ aco oꞌomasĩweti?’, ni wãcũti?” ni yʉꞌticʉ niwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na masã peꞌe aco wʉoyʉꞌrʉarã, Moisére tojo ũrũsãcãrã niwã. Aꞌtiro nicãrã niwã: —¿Deꞌro weeacjʉ ʉ̃sã Egiptopʉ níꞌcãrãrẽ miiwijari? ¿Mʉꞌʉ ʉ̃sãrẽ, ʉ̃sã põꞌrãrẽ, ʉ̃sã yarã waꞌicʉrãrẽ acowʉose meꞌrã wẽjẽgʉ̃ti nígʉ̃, miiwijari? ");
INSERT INTO tuoNT_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moisé tere tʉꞌogʉ, Õꞌacʉ̃rẽ ʉpʉtʉ sẽrĩgʉ̃, aꞌtiro nicʉ niwĩ: —¿Yʉꞌʉ deꞌro weegʉsari ãꞌrã masã meꞌrã? Cãꞌrõacã dʉꞌsaꞌa na ʉ̃tãperi meꞌrã yʉꞌʉre doque wẽjẽatjo, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Tere tʉꞌogʉ, Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Masã dʉporo yʉꞌrʉaya. Niꞌcãrẽrã wiorã Israe curuacjãrãrẽ sʉꞌori nirãrẽ mʉꞌʉrẽ baꞌpatidutigʉ pijiaya. Tojo nicã tuacjʉ, mʉꞌʉ dia Nilore paapoꞌoꞌcʉre miiwãꞌcãña. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Yʉꞌʉ mʉꞌʉ dʉporo ʉ̃rʉ̃gʉ̃ Horeb wãmeticjʉ pʉꞌto ʉ̃tãgãpʉ nuꞌcũgʉ̃ti. Mʉꞌʉ tigare doteya. Mʉꞌʉ dotecã, masã sĩꞌrĩcã, aco wijarosaꞌa, nicʉ niwĩ Õꞌacʉ̃. Moisé Israe curuacjãrã wiorã ĩꞌorõpʉ Õꞌacʉ̃ weedutiꞌcaronojõta dotecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Cʉ̃ tojo weeꞌcaropʉ Israe curuacjãrã na Moisé meꞌrã aꞌpepũrĩca beꞌro niyucã, Meriba wãme õꞌocʉ niwĩ. Tojo nicã toreta Masah wãme õꞌocʉ niwĩ. Masã Õꞌacʉ̃rẽ “¿Diacjʉ̃ta Õꞌacʉ̃ marĩ meꞌrã niti o niwetine?” níca beꞌro niyucã, tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Surara amaleca masã wãmetiri curua Refidĩpʉ Israe curuacjãrã meꞌrã aꞌmewẽjẽrã aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tojo weegʉ Moisé Josuére aꞌtiro nicʉ niwĩ: —Niꞌcãrẽrã ʉmʉarẽ beseya. Bese, amaleca masã meꞌrã aꞌmewẽjẽgʉ̃ waꞌaya. Yʉꞌʉ ñamiacãrẽ aꞌtigʉ ʉ̃rʉ̃gʉ̃ dʉposãrĩpʉ nigʉ̃ti. Topʉre tuacjʉ Õꞌacʉ̃ yʉꞌʉre miadutiꞌcʉ meꞌrã nuꞌcũgʉ̃ti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué Moisé dutiꞌcaronojõta weecʉ niwĩ. Amaleca masã meꞌrã aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. Cʉ̃ topʉ na ʉmʉa meꞌrã waꞌari cura Moisé, Aarṍ, apĩ Hur wãmetigʉ, Moisére weetamugʉ̃, tigʉ ʉ̃rʉ̃gʉ̃ buꞌipʉ mʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moisé cʉ̃ omocãrĩ sĩomorõrĩ curare Israe curuacjãrã tutuayʉꞌrʉnʉꞌcãcãrã niwã. Cʉ̃ omocãrĩ dijocã peꞌema, amaleca masã peꞌe na meꞌrã aꞌmewẽjẽrã tutuayʉꞌrʉnʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moisé sĩomorõmigʉ̃ ñujũcã ĩꞌarã, niꞌcã ʉ̃tãgã mii, cʉ̃rẽ dujidutirã dʉpocãrã niwã. Tuꞌajanʉꞌcõ, Aarṍ, Hur cʉ̃ omocãrĩrẽ tuuñeꞌe nuꞌcũcãrã niwã. Niꞌcʉ̃ niꞌcã pãꞌrẽ, apĩ ape pãꞌrẽ peꞌe nuꞌcũcãrã niwã. Na tojo weeyucã, Moisé ye omocãrĩ ne ñujũticaro niwʉ̃. Téé mujĩpũ sãjãcãpʉ tigʉ tuacjʉ meꞌrã sĩomorõtʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tojo weegʉ Josué surara amaleca masã meꞌrã aꞌmewẽjẽgʉ̃, cʉ̃ ya diꞌpjĩjo meꞌrã wẽjẽpeꞌocãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Beꞌro Õꞌacʉ̃ Moisére nicʉ niwĩ: —Aꞌtere acobojoticãꞌto nígʉ̃, niꞌcã tũrũpʉ ojaya. Josuére aꞌtiro niña: “Nipeꞌtirã amaleca masãrẽ peꞌocãꞌgʉ̃saꞌa. Tojo weerã ne niꞌcʉ̃ aꞌti ʉmʉcocjãrã narẽ wãcũsome.” Tere Josuére wereturiacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moisé niꞌcãrõ Õꞌacʉ̃rẽ ẽjõpeorã, waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoatjore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tore aꞌtiro wãme õꞌocʉ niwĩ: “Yʉꞌʉ wiogʉ Õꞌacʉ̃ yʉꞌʉre wapataꞌacã weegʉ́ nimi.” ");
INSERT INTO tuoNT_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Aꞌtiro ni ucũcʉ niwĩ: “Yʉꞌʉ wiogʉ Õꞌacʉ̃ weetamusere sẽrĩrã, omocãrĩ cʉ̃ tiropʉ sĩomorõnoꞌwʉ̃. Õꞌacʉ̃ amaleca masã meꞌrã aꞌmewẽjẽnuꞌcũcjʉ̃sami. Aꞌtocaterocjãrã meꞌrã téé beꞌrocjãrãpʉ quẽꞌrãrẽ tojota aꞌmewẽjẽ yapatinuꞌcũgʉ̃sami”, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro Madiã́cjʉ̃ paꞌi, Moisé mañecʉ̃, nipeꞌtise Õꞌacʉ̃ Moisére weeꞌquere tʉꞌocʉ niwĩ. Tojo nicã Õꞌacʉ̃ yarã masã Israe curuacjãrãrẽ weeꞌquere tʉꞌocʉ niwĩ. Apeye quẽꞌrãrẽ Õꞌacʉ̃ na wiogʉ narẽ Egiptopʉ níꞌcãrãrẽ miiwijaꞌquere tʉꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moisé cʉ̃ nʉmo Séforare co pacʉ ya wiꞌipʉ oꞌóyutojacʉ niwĩ. Jetro core, ");
INSERT INTO tuoNT_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","tojo nicã co põꞌrã pʉarãrẽ ñeꞌecʉ niwĩ. Niꞌcʉ̃ Gersón wãmeticʉ niwĩ. Moisé aꞌtiro nitojacʉ niwĩ: “Yʉꞌʉ ãpẽrã ye diꞌtapʉre sijari masʉ̃, aperocjʉ̃ weronojõ tʉꞌoñaꞌa.” Tojo weegʉ masã maꞌmirẽ Gersón wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Cʉ̃ acabiji peꞌe Eliezer wãmeticʉ niwĩ. Moisé aꞌtiro ni ucũyutojacʉ niwĩ: “Õꞌacʉ̃ yʉꞌʉ pacʉ ẽjõpeoꞌcʉ yʉꞌʉre weetamuwĩ. Faraṍ yʉꞌʉre wẽjẽboꞌcʉre yʉꞌrʉweticã weewĩ.” Tojo weegʉ dʉꞌsagʉre tojo wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moisé, Israe curuacjãrã meꞌrã masã marĩrõ, yucʉ marĩrõ Õꞌacʉ̃ yagʉ ʉ̃rʉ̃gʉ̃ pʉꞌtopʉ tojaqueꞌacʉ niwĩ. Topʉ Jetro, cʉ̃ macõ Moisé nʉmo, põꞌrã meꞌrã cʉ̃ tiropʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Moisére aꞌtiro queti oꞌómʉꞌtãcʉ niwĩ: —Yʉꞌʉ, mʉꞌʉ mañecʉ̃, mʉꞌʉ nʉmo meꞌrã, mʉꞌʉ põꞌrã pʉarã meꞌrã mʉꞌʉ tiropʉ waꞌagʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Cʉ̃ etacã, Moisé suꞌti caseri meꞌrã wééca wiꞌi poꞌpeapʉ níꞌcʉ wijaa, cʉ̃ mañecʉ̃rẽ põtẽrĩgʉ̃ waꞌacʉ niwĩ. Cʉ̃rẽ añudutigʉ, paamuꞌrĩqueꞌa, miꞌmicʉ niwĩ. Aꞌmerĩ añudutíca beꞌro cʉ̃ ya wiꞌipʉ narẽ sʉꞌori pijisãjãacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Topʉ Moisé Õꞌacʉ̃ faraṍrẽ, Egiptocjãrãrẽ weeꞌquere werepeꞌocʉ niwĩ. Tojo nicã maꞌapʉ aꞌtirã, nipeꞌtise na piꞌetiwãꞌcãtiꞌquere werecʉ niwĩ. “Õꞌacʉ̃, ʉ̃sãrẽ aꞌtiro wee yʉꞌrʉowĩ”, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro Õꞌacʉ̃ Israe curuacjãrãrẽ maꞌi pajañaꞌgʉ̃, Egiptocjãrã doca níꞌcãrãrẽ yʉꞌrʉweticã weeꞌquere tʉꞌogʉ, eꞌcatiyʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Aꞌtiro nicʉ niwĩ: —Õꞌacʉ̃ añuyʉꞌrʉami, ni eꞌcatipeoato. Cʉ̃ta mʉsãrẽ faraṍ, Egiptocjãrã na dutise doca níꞌcãrãrẽ yʉꞌrʉweticã weeapĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Egiptocjãrã mʉsãrẽ ñaꞌabutiaro daꞌradutipecã, Õꞌacʉ̃ mʉsãrẽ yʉꞌrʉweticã weeapĩ. Tojo weegʉ niꞌcãrõacã yʉꞌʉ masĩꞌi. Õꞌacʉ̃ nipeꞌtirã ãpẽrã masã na ẽjõpeorãnojõ yʉꞌrʉoro tutuayʉꞌrʉnʉꞌcãmi, nicʉ niwĩ Jetro. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Beꞌro Jetro niꞌcʉ̃ waꞌicʉre wẽjẽ, Õꞌacʉ̃rẽ eꞌcatipeogʉ ʉ̃jʉ̃amorõpeocʉ niwĩ. Tojo nicã apeye Õꞌacʉ̃rẽ oꞌosenojõrẽ ʉ̃jʉ̃amorõpeonemocʉ niwĩ. Tojo wééca beꞌro Aarṍ, nipeꞌtirã Israe curuacjãrã wiorã Õꞌacʉ̃ ĩꞌorõpʉ, Moisé mañecʉ̃ meꞌrã baꞌarã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Na baꞌáca beꞌro ape nʉmʉ peꞌe Moisé Israe curuacjãrã na ñaꞌarõ ucũ, aꞌpepũrĩsere apogʉ, cʉ̃ dujiwʉaropʉ dujicʉ niwĩ. Tere na nipeꞌtirã cʉ̃ aposere ʉarã, topʉ ninaꞌiacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Cʉ̃ mañecʉ̃ nipeꞌtise Moisé masãrẽ weebosaꞌquere ĩꞌagʉ̃, aꞌtiro nicʉ niwĩ: —¿Ñeꞌenojõ weegʉ weemiti mʉꞌʉ, ãꞌrã masã meꞌrã? ¿Deꞌro weegʉ mʉꞌʉ seꞌsaro tere weeti? Na peꞌe mʉꞌʉ tiro tojo nuꞌcũnaꞌia waꞌama. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisé cʉ̃rẽ yʉꞌticʉ niwĩ: —Na “¿Õꞌacʉ̃ deꞌro ʉati?” ni, yʉꞌʉre sẽrĩtiñaꞌrã aꞌtiama. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Na tiropʉre mejẽcã waꞌacã, “¿Ʉ̃sã deꞌronojõ weerãsari?” nírã, “¿Noa peꞌe queoro niti?” nírã, apodutirã, aꞌtopʉre etama. Yʉꞌʉ peꞌe narẽ Õꞌacʉ̃ cʉ̃ dutise cũuꞌquere, cʉ̃ buꞌesere narẽ wereturiaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tere tʉꞌogʉ, cʉ̃ mañecʉ̃ cʉ̃rẽ aꞌtiro ni werecasacʉ niwĩ: —Mʉꞌʉ tojo weese añuweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mʉꞌʉ tojo weegʉ caributia waꞌagʉsaꞌa. Masã quẽꞌrã mʉꞌʉ meꞌrã nirã́ caributia waꞌarãsama. Tojo weese mʉꞌʉrẽ tutuayʉꞌrʉaꞌa. Mʉꞌʉ niꞌcʉ̃ta tere põtẽotisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Yʉꞌʉ mʉꞌʉrẽ “Aꞌtiro weeapa” ni weresere añurõ tʉꞌoapa. Mʉꞌʉ tojo weecã, Õꞌacʉ̃ mʉꞌʉrẽ weetamugʉ̃sami. Mʉꞌʉ peꞌe Õꞌacʉ̃pʉre masã aꞌpepũrĩsere ucũbosagʉ nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Õꞌacʉ̃ cʉ̃ dutise cũuꞌquere, cʉ̃ buꞌesere narẽ weregʉsaꞌa. “Aꞌtiro nisetiroʉaꞌa, aꞌte peꞌere weeya” ni, narẽ masĩcã weeya. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Israe curuacjãrã waꞌteropʉ ʉmʉa añurõ tʉꞌomasĩrãnojõrẽ, Õꞌacʉ̃rẽ wiopesase meꞌrã tʉꞌoñaꞌrãrẽ, tojo nicã queoro ucũ weesetirãnojõrẽ, “Noꞌo ʉaro weese meꞌrã wapataꞌarãti” ni wãcũtirãnojõrẽ beseya. Narẽ besegʉ, ãpẽrãrẽ mil masãrẽ dutiajãrẽ bese sõrõña. Ãpẽrãrẽ cien masãrẽ dutiajãrẽ beseya. Ãpẽrãrẽ cincuenta masãrẽ dutiajãrẽ beseya. Ãpẽrãrẽ diez masãrẽ dutiajãrẽ beseya. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Na nipeꞌtirã Israe curuacjãrãrẽ “Aꞌtiro peꞌe weeya”, ni dutinuꞌcũrãsama. Apeye na apomasĩtise diasase nicãma, mʉꞌʉ tiropʉ aporã aꞌtirãsama. Mejõ niseacãma, na basu aporãsama. Na aꞌtiro weecã, sõꞌowaro mʉꞌʉ piꞌetisome. Na mʉꞌʉrẽ sʉꞌori tere weetamurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Aꞌte yʉꞌʉ werecasaꞌquere queoro wéégʉ, Õꞌacʉ̃ mʉꞌʉrẽ “Aꞌtere tojota weeya” nicã, mʉꞌʉ te daꞌrasere põtẽomasĩgʉ̃saꞌa. Mʉꞌʉ tojo weecã, masã eꞌcatise meꞌrã na ye wiꞌseripʉ dajatojaarãsama, ni werecasacʉ niwĩ Jetro. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moisére cʉ̃ mañecʉ̃ “Tojo weeapa” níꞌcaronojõta tere queoro weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Tojo weegʉ Israe curuacjãrãrẽ “Ãꞌrãta tʉꞌomasĩma”, ni besecʉ niwĩ. Narẽ dutise cṹúgʉ̃, mil masãrẽ, cien masãrẽ, cincuenta masãrẽ, diez masãrẽ dutiajãrẽ besecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na “Tojo peꞌe ʉaꞌa” ni, Israe curuacjãrãrẽ nipeꞌtiropʉ ĩꞌanʉrʉ̃nuꞌcũcãrã niwã. Na apomasĩtise diasasema Moisé tiropʉ aporã waꞌacãrã niwã. Mejõ niseacã peꞌema na basu aꞌmerĩ apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Beꞌro Moisé cʉ̃ mañecʉ̃ meꞌrã aꞌmerĩ weꞌriticãrã niwã. Tuꞌajanʉꞌcõ, Jetro cʉ̃ ya diꞌtapʉ dajatojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Israe curuacjãrã Refidĩpʉ níꞌcãrã wija, masã marĩrõ, yucʉ marĩrõ ʉ̃rʉ̃gʉ̃ Sinaí pʉꞌtopʉ etacãrã niwã. Eta, topʉta tigʉ ʉ̃rʉ̃gʉ̃ põtẽorõ tojaqueꞌacãrã niwã. Pʉa mujĩpũ na Egiptopʉre wijáca beꞌro topʉre etacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Beꞌro Moisé Õꞌacʉ̃ meꞌrã ucũgʉ̃ waꞌagʉ, tigʉpʉ mʉjãcʉ niwĩ. Õꞌacʉ̃ tigʉpʉ nígʉ̃, Moisére pisucʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Aꞌte yʉꞌʉ ucũsereta Jacob pãrãmerã nituriarã, Israe curuacjãrãrẽ wereya: ");
INSERT INTO tuoNT_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Mʉsã, yʉꞌʉ Egiptocjãrãrẽ weeꞌquere ĩꞌapʉ. Yʉꞌʉ niꞌcʉ̃ á pacʉ cʉ̃ põꞌrãrẽ cʉ̃ wʉʉse buꞌipʉ wʉʉbuꞌegʉ weronojõ mʉsãrẽ maꞌi coꞌtegʉ, aꞌto yʉꞌʉ nirõpʉ miitiapʉ. Mʉsã yʉꞌʉ tojo weeꞌquere masĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tojo weerã mʉsã yʉꞌʉ dutisere queoro yʉꞌtirã, marĩ niꞌcãrõ meꞌrã apoꞌquere queoro wéérã, nipeꞌtirã ãpẽrã masã yʉꞌrʉoro, yarã, yʉꞌʉ tʉꞌsarã nirãsaꞌa. Nipeꞌtirocjãrã yarãta nima, nírã peꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tojo nimirã, mʉsã peꞌe yʉꞌʉ ʉaro weeri masã, paꞌia ye cjasere daꞌrarã weronojõ nirãsaꞌa. Apesecjãrãrẽ ye cjasere wereturiarãsaꞌa. Yarã, ya macãcjãrã añurã nirãsaꞌa. Aꞌtere nipeꞌtirã Israe curuacjãrãrẽ wereya”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Beꞌro Moisé ʉ̃rʉ̃gʉ̃pʉ níꞌcʉ dijaa, nipeꞌtirã wiorãrẽ pijio, Õꞌacʉ̃ cʉ̃ weredutiꞌquenʉcʉ̃ werepeꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Moisé tere werecã tʉꞌorã, Israe curuacjãrã niꞌcãrõnojõ wãcũseti, yʉꞌticãrã niwã: —Nipeꞌtise Õꞌacʉ̃ ʉ̃sãrẽ weedutiꞌquere weerãti, nicãrã niwã. Na tojo ni yʉꞌticã tʉꞌogʉ, Moisé na níꞌquere Õꞌacʉ̃rẽ weregʉ mʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Moisé wereꞌquere tʉꞌóca beꞌro Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Masã yʉꞌʉ mʉꞌʉ meꞌrã ucũcã tʉꞌoato nígʉ̃, oꞌmecurua poꞌpeapʉ mʉꞌʉ tiro dijatagʉsaꞌa. Tojo weerã mʉꞌʉrẽ ẽjõpeonuꞌcũcãꞌrãsama, nicʉ niwĩ. Cʉ̃ tojo níca beꞌro Moisé Õꞌacʉ̃rẽ masã níꞌquere werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Beꞌro Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Masã tiropʉ waꞌaya. Yʉꞌʉre eꞌcatipeoajã, niꞌcãcã, ñamiacã, apoyuato. Na ye suꞌtire coeyuato. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ñamiacã yʉꞌrʉro apoyuꞌquepʉ nitojato. Ti nʉmʉ yʉꞌʉ, mʉsã wiogʉ, nipeꞌtirã ĩꞌorõpʉ ʉ̃rʉ̃gʉ̃ Sinaípʉ dijatagʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tigʉ ʉ̃rʉ̃gʉ̃ dʉꞌpocã́ masã yʉꞌrʉaticãꞌto nígʉ̃, cãꞌmotaꞌacũuña. Narẽ aꞌtiro wereya: “Tigʉ ʉ̃rʉ̃gʉ̃rẽ wiopesase meꞌrã ĩꞌaña. Ne mʉjãticãꞌña. Tigʉ dʉꞌpocã́rẽ ne cãꞌrõ ʉꞌtacũuticãꞌña. Noꞌo tigʉre daꞌrañaꞌgʉ̃nojõ wẽrĩgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tojo wee wẽrĩgʉ̃nojõrẽ ne niꞌcʉ̃ cãꞌrõ omocã ñapeomaꞌaticãꞌña. Ʉ̃tãperi meꞌrã doquewẽjẽnoꞌrõsaꞌa. Tojo weetirã, mejõ bʉewẽjẽnoꞌrõsaꞌa. Noꞌo nigʉ̃́ masʉ̃rẽ o waꞌicʉ quẽꞌrãrẽ wẽjẽcãꞌnoꞌrõsaꞌa. Masã oveja ʉmʉ capesaꞌro meꞌrã diaꞌcʉ̃ puticã tʉꞌorã, tigʉ ʉ̃rʉ̃gʉ̃pʉre mʉjãrãsama”, ni wereya, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Beꞌro Moisé ʉ̃rʉ̃gʉ̃pʉ níꞌcʉ dijaticʉ niwĩ. Õꞌacʉ̃rẽ eꞌcatipeoajã, masãrẽ apoyuduticʉ niwĩ. Beꞌro na ye suꞌtire coecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Na suꞌtire coéca beꞌro Moisé narẽ aꞌtiro werecʉ niwĩ: —Ñamiacã yʉꞌrʉro apoyuꞌcãrãpʉ nitojaya. Tojo nicã aꞌte nʉmʉrĩ mʉsã nʉmosãnumia meꞌrã ne wʉacãjĩticãꞌña, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pʉa nʉmʉ beꞌro boꞌrequeꞌari cura bʉpo paa, yaꞌbacʉ niwĩ. Tigʉ ʉ̃rʉ̃gʉ̃ buꞌipʉre niꞌcã oꞌmecurua tojanʉꞌcãcaro niwʉ̃. Cabra capesaꞌro meꞌrã ʉpʉtʉ putise bʉsʉcaro niwʉ̃. Nipeꞌtirã na suꞌti caseri meꞌrã weeꞌque wiꞌseri nirõpʉ te bʉsʉsere tʉꞌo uirã, narãsãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Beꞌro Moisé Õꞌacʉ̃rẽ põtẽrĩrã waꞌajã, narẽ sʉꞌori miacʉ niwĩ. Waꞌa, tigʉ ʉ̃rʉ̃gʉ̃ dʉꞌpocã́pʉ ejanʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nipeꞌtiro tigʉ ʉ̃rʉ̃gʉ̃ Sinaí wãmeticjʉpʉ oꞌmepuꞌsunuꞌcũcaro niwʉ̃. Õꞌacʉ̃ pecameꞌe ʉ̃jʉ̃rĩ põꞌrã meꞌrã dijatáca beꞌro niyucã, tojo waꞌacaro niwʉ̃. Pã́ ʉ̃jʉ̃arõ weronojõ oꞌme buenuꞌcũcaro niwʉ̃. Nipeꞌtiro tigʉ ʉ̃rʉ̃gʉ̃ ʉpʉtʉ waro narãsãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Oveja ʉmʉ capesaꞌro putise siapeꞌe meꞌrã nemorõ bʉsʉcaro niwʉ̃. Tojo waꞌari cura Moisé Õꞌacʉ̃ meꞌrã ucũmʉjãcʉ niwĩ. Cʉ̃ peꞌe bʉpo bʉsʉro weronojõ cʉ̃rẽ yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Õꞌacʉ̃ ʉ̃rʉ̃gʉ̃ Sinaí dʉposãrĩpʉ dijati, ejanʉꞌcãcʉ niwĩ. Beꞌro Moisére cʉ̃ tiropʉ mʉjãtiduticʉ niwĩ. Tere tʉꞌogʉ, Moisé mʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Dijaya. Masãrẽ wiopesase meꞌrã weregʉ waꞌaya: “Yʉꞌʉre ĩꞌasĩꞌrĩrã, aꞌtigʉ ʉ̃rʉ̃gʉ̃ dʉꞌpocã́pʉ cãꞌmotaꞌaꞌcarore ne yʉꞌrʉticãꞌto. Yʉꞌrʉrã pũrĩcã, pãjãrã wẽrĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Paꞌiapʉta, yʉꞌʉ tiropʉ aꞌtirãnojõ yʉꞌʉ ĩꞌorõpʉ ñaꞌase marĩrã nirãti nírã, apoyuato. Na tojo weeticã, narẽ buꞌiri daꞌregʉsaꞌa”, ni wereya, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moisé Õꞌacʉ̃rẽ aꞌtiro ni yʉꞌticʉ niwĩ: —Masã aꞌtigʉ ʉ̃rʉ̃gʉ̃pʉre ne mʉjãtimasĩtisama. Mʉꞌʉta narẽ “Tigʉ dʉꞌpocã́rẽ cãꞌmotaꞌaꞌcarore yʉꞌrʉticãꞌto. Tigʉ yʉꞌʉ nirṍ niꞌi”, ni weredutitojapʉ. Tojo weerã aꞌtore ne yʉꞌrʉtisama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Õꞌacʉ̃ peꞌe Moisére nicʉ niwĩ: —Dija, Aarṍrẽ aꞌtopʉ miitia. Paꞌia, tojo nicã masã pũrĩcã aꞌtopʉ aꞌtisĩꞌrĩrã, cãꞌmotaꞌaꞌcarore ne yʉꞌrʉticãꞌto. Tojo weecãma, yʉꞌʉ narẽ buꞌiri daꞌrebosaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Tere tʉꞌogʉ, Moisé dijata, Õꞌacʉ̃ cʉ̃ níꞌquere Israe curuacjãrãrẽ wereturiacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Õꞌacʉ̃ ʉ̃rʉ̃gʉ̃pʉ ucũgʉ̃, nipeꞌtise aꞌte ucũsere ucũcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. Yʉꞌʉta mʉsãrẽ Egiptopʉre miiwijawʉ. Topʉre mʉsã narẽ daꞌracoꞌterã niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","”Yʉꞌʉ niꞌcʉ̃rẽta ẽjõpeoya. Ne ãpẽrãnojõrẽ ẽjõpeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","”Ne queosere yee, ẽjõpeoticãꞌña. Ʉꞌmʉarõ cjase queosere, ne docapʉ aꞌti diꞌtapʉ nisere, maa pajiri maajopʉ nise queose quẽꞌrãrẽ yee ẽjõpeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ne narẽ ẽjõpeorã, paamuꞌrĩqueꞌaticãꞌña. Ne narẽ ñubuepeoticãꞌña. Yʉꞌʉ Õꞌacʉ̃ mʉsã wiogʉ niꞌi. Mʉsã ãpẽrãrẽ ẽjõpeosirutucã, ne ʉaweꞌe. Yʉꞌʉre ĩꞌasĩꞌrĩtirã tojo weema. Tojo weegʉ na põꞌrãrẽ, na pãrãmerãrẽ, na pãrãmerã nituriarãrẽ buꞌiri daꞌregʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Yʉꞌʉre mairã, yʉꞌʉ dutiꞌquere queoro weerã́ peꞌema peje turiri beꞌrocjãrãrẽ maꞌinuꞌcũgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","”Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉre wiopesase meꞌrã wãcũtimirã, wãmepeomaꞌaticãꞌña. Tojo ucũmaꞌarãrẽ buꞌiri daꞌregʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","”Yʉꞌʉ soodutigʉ cũuca nʉmʉ saurure wãcũña. Ya nʉmʉ, yʉꞌʉre ẽjõpeori nʉmʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Seis nʉmʉrĩta daꞌraya. Te nʉmʉrĩrẽ nipeꞌtise mʉsã daꞌrase cʉosere daꞌraweꞌocãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Siete nʉmʉ nirĩ nʉmʉ peꞌema, yʉꞌʉ mʉsã wiogʉre wãcũ, soodutigʉ cũuca nʉmʉ niꞌi. Ti nʉmʉrẽ ne cãꞌrõ daꞌraticãꞌña. Mʉsã macʉ̃, mʉsã macõ, mʉsãrẽ daꞌracoꞌtegʉ o daꞌracoꞌtego, mʉsã yarã waꞌicʉrã, ape diꞌtacjãrã mʉsã tiropʉ nirã́ ne daꞌraticãꞌto. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ seis nʉmʉrĩta ʉꞌmʉsere, diꞌtare, pacase maarĩrẽ, nipeꞌtise tepʉ nisere weewʉ. Tuꞌajanʉꞌcõ, siete nʉmʉ nirĩ nʉmʉrẽ soowʉ. Tojo weero ti nʉmʉ sauru, ya nʉmʉ niꞌi. ‘Yʉꞌʉre ẽjõpeori nʉmʉ niato’, ni soodutigʉ cũuwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","”Mʉsã pacʉre, mʉsã pacore añurõ wejepeoya. Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ mʉsãrẽ oꞌori diꞌtare yoacã catirãti nírã, tojo weeya. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","”Masãrẽ wẽjẽcõꞌaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","”Mʉsã nʉmosãnumia nitirãrẽ, mʉsã marãpʉsʉmʉa nitirãrẽ aꞌmetãrãticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","”Yajaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","”Beseropʉ ãpẽrãrẽ ñaꞌarõ waꞌadutirã, na ye cjasere nisooticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","”Ãpẽrã ya wiꞌire ne ʉoticãꞌña. Cʉ̃ nʉmorẽ, cʉ̃rẽ daꞌracoꞌtegʉre, cʉ̃rẽ daꞌracoꞌtegore, cʉ̃ yagʉ wecʉre, cʉ̃ yagʉ burrore, nipeꞌtise cʉ̃ cʉosere ʉoticãꞌña” ni, dutise oꞌocʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Israe curuacjãrã nipeꞌtirã bʉpo paacã, oveja ʉmʉ capesaꞌro bʉsʉcã tʉꞌorã, bʉpo yaꞌbacã, ʉ̃rʉ̃gʉ̃ oꞌmepuꞌsunuꞌcũcã ĩꞌarã, ui narãsãcãrã niwã. Tojo weeꞌcãrã niyurã, tigʉ yoacureropʉ tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Tojo weerã Moisére aꞌtiro nicãrã niwã: —Mʉꞌʉ ʉ̃sãrẽ ucũña. Mʉꞌʉ dutisere yʉꞌtirãti. Õꞌacʉ̃ cʉ̃ basu ʉ̃sãrẽ ucũticãꞌto. Cʉ̃ ʉ̃sã meꞌrã ucũcã pũrĩcãrẽ, ʉ̃sã wẽrĩbosaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisé narẽ yʉꞌticʉ niwĩ: —Mʉsã uiticãꞌña. Õꞌacʉ̃ marĩrẽ diacjʉ̃ta yʉꞌʉre ẽjõpeomiti nígʉ̃, aꞌtiami. Mʉsã cʉ̃rẽ wiopesase meꞌrã wãcũcã ʉagʉ, cʉ̃rẽ yʉꞌrʉnʉꞌcã, ñaꞌarõ weeticãꞌto nígʉ̃, aꞌtiami. ");
INSERT INTO tuoNT_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Masã uirã, ʉ̃rʉ̃gʉ̃ yoacureropʉ tojaqueꞌacãrã niwã. Moisé peꞌe Õꞌacʉ̃ nirṍ, oꞌmecurua naꞌitĩꞌarĩ curua pʉꞌtopʉ ejanʉꞌcãcʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Õꞌacʉ̃ dutise cũuꞌquere wéréca beꞌro Moisére nicʉ niwĩ: —Aarṍ, cʉ̃ põꞌrã Nadab, Abihú, ãpẽrã setenta Israe curuacjãrã wiorã meꞌrã aꞌto yʉꞌʉ nirõpʉ mʉjãtia. Mejõ yoacurero tojato. Topʉ paamuꞌrĩqueꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mʉꞌʉ seꞌsaro yʉꞌʉ tiropʉre ejaya. Masã peꞌe mʉꞌʉ meꞌrã ne pʉꞌtoacãpʉ mʉjãtinemoticãꞌto, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisé masã tiropʉ waꞌa, nipeꞌtise Õꞌacʉ̃ níꞌquere, tojo nicã cʉ̃ dutiꞌquere masãrẽ weregʉ waꞌacʉ niwĩ. Cʉ̃ tojo werecã tʉꞌorã, nipeꞌtirãpʉta niꞌcãrõnojõ wãcũseti, yʉꞌticãrã niwã: —Nipeꞌtise Õꞌacʉ̃ ʉ̃sãrẽ weedutiꞌquere weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tere tʉꞌogʉ, Moisé nipeꞌtise Õꞌacʉ̃ dutiꞌquere ojaõꞌocʉ niwĩ. Ape nʉmʉ peꞌe ñamiñaꞌcũrõ wãꞌcã, niꞌcãrõ Õꞌacʉ̃rẽ ẽjõpeorã waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoatjore ʉ̃rʉ̃gʉ̃ dʉꞌpocã́pʉ niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tojo nicã docepaga ʉ̃tãpaga te Israe curarinʉcʉ̃rẽ niꞌcãrẽpaga miinʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Beꞌro niꞌcãrẽrã maꞌmapjia Israe curuacjãrãrẽ waꞌicʉrã wẽjẽdutigʉ oꞌócʉ niwĩ. Narẽ Õꞌacʉ̃rẽ eꞌcatipeorã, waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoduticʉ niwĩ. Tojo nicã, apeyema Õꞌacʉ̃ narẽ añurõ weeato nírã, wecʉa ʉmʉarẽ wẽjẽ, ʉ̃jʉ̃amorõpeoduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisé deco meꞌrã díre mii, bapari pacapʉ piosãacʉ niwĩ. Apeye dʉꞌsasere waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoropʉ piopeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Tuꞌajanʉꞌcõ, Moisé “Õꞌacʉ̃ masã meꞌrã aꞌtiro apogʉti” ni ojáca turipʉre mii, masãrẽ buꞌeĩꞌocʉ niwĩ. Tere tʉꞌorã, na peꞌe aꞌtiro nicãrã niwã: —Nipeꞌtise marĩ wiogʉ Õꞌacʉ̃ marĩrẽ weedutiꞌquere weerãti. Cʉ̃ dutisere yʉꞌtirãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Beꞌro Moisé díre mii, masãpʉre tere wẽeste, aꞌtiro nicʉ niwĩ: —Aꞌte dí meꞌrã Õꞌacʉ̃ “Masã meꞌrã tojo weegʉti” níꞌquere diacjʉ̃ta cʉ̃ dutiꞌquenojõta weegʉsami, ni masĩnoꞌo, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Tere tuꞌajáca beꞌro Moisé Aarṍ, Nadab, Abihú, tojo nicã setenta Israe curuacjãrã wiorã meꞌrã ʉ̃rʉ̃gʉ̃pʉ mʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Topʉ na Õꞌacʉ̃, Israe curuacjãrã wiogʉre ĩꞌacãrã niwã. Cʉ̃ ʉꞌtacũrõrẽ añuse yaꞌsase peri zafiro wãmetise peri asipaꞌacũñacaro niwʉ̃. Ʉꞌmʉse weronojõ yaꞌsameꞌrĩcãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ãꞌrã Israe curuacjãrã wiorã Õꞌacʉ̃rẽ ĩꞌamicã, narẽ ne mejẽcã waꞌacã weeticʉ niwĩ. Na niꞌcãrõ meꞌrã baꞌa, sĩꞌrĩ weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Õꞌacʉ̃ Moisére aꞌtiro nicʉ niwĩ: —Yʉꞌʉ tiro ʉ̃rʉ̃gʉ̃pʉ mʉjãtinemoña. Mʉjãti, topʉ yʉꞌʉre coꞌteya. Yʉꞌʉ ʉ̃tã meꞌrã weeꞌque pjĩrĩrẽ mʉꞌʉrẽ oꞌogʉti. Te pjĩrĩpʉ yʉꞌʉ ojaꞌque nipeꞌtise yʉꞌʉ weedutiꞌquere mʉꞌʉ Israe curuacjãrãrẽ weregʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tere tʉꞌogʉ, Moisé, cʉ̃rẽ weetamugʉ̃ Josué meꞌrã ʉ̃rʉ̃gʉ̃ Õꞌacʉ̃ nirõpʉ mʉjãnemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Cʉ̃ mʉjãnemoati dʉporo wiorãrẽ aꞌtiro nicʉ niwĩ: —Aꞌtota coꞌteya, téé ʉ̃sã dijaticãpʉ. Aarṍ, tojo nicã Hur mʉsã meꞌrã tojama. Noꞌo mʉsãrẽ mejẽcã waꞌacã, narẽ wereya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Tojo níca beꞌro Moisé ʉ̃rʉ̃gʉ̃pʉ mʉjãcʉ niwĩ. Tigʉre niꞌcã oꞌmecurua tuubiꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Õꞌacʉ̃ cʉ̃ añurõ asistese ʉ̃rʉ̃gʉ̃ Sinaípʉ dijatacã, seis nʉmʉrĩrẽ omecurua tigʉre tuubiꞌacaro niwʉ̃. Ape nʉmʉ siete nʉmʉ nirĩ nʉmʉrẽ oꞌmecuruapʉta Õꞌacʉ̃ Moisére pijidijocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israe curuacjãrã Õꞌacʉ̃ asistesere ʉ̃rʉ̃gʉ̃ dʉposãrĩpʉ pecameꞌe ʉ̃jʉ̃acõꞌarõ weronojõ ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisé ti oꞌmecuruapʉ sãjãa, tigʉ ʉ̃rʉ̃gʉ̃pʉ mʉjãnemocʉ niwĩ. Topʉre cuarenta ʉmʉcori, cuarenta ñamirĩ tojacʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Õꞌacʉ̃ ʉ̃rʉ̃gʉ̃ Sinaípʉ Moisé meꞌrã ucṹca beꞌro cʉ̃rẽ pʉa pjĩ ʉ̃tã meꞌrã weeꞌque pjĩrĩrẽ oꞌocʉ niwĩ. Te pjĩrĩpʉ Õꞌacʉ̃ diez dutise cũuꞌque nicaro niwʉ̃. Õꞌacʉ̃ basuta cʉ̃ omopica meꞌrã tere ojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Beꞌro Israe curuacjãrã Moisé cʉ̃ ʉ̃rʉ̃gʉ̃pʉ mʉjãaꞌcʉre yoogocã ĩꞌarã, Aarṍ tiropʉ nerẽcãrã niwã. Cʉ̃rẽ aꞌtiro nicãrã niwã: —Sõꞌonícʉ Moisé marĩrẽ Egiptopʉ níꞌcãrãrẽ miitiꞌcʉ waro ¿deꞌro waꞌapari cʉ̃rẽ? Marĩ ne masĩtisaꞌa. Tojo weegʉ ʉ̃sã ẽjõpeoatje queosere yeebosaya. Marĩ dʉporo wʉamʉꞌtãrãsama. Na marĩ waꞌatji maꞌarẽ ĩꞌorãsama, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aarṍ narẽ yʉꞌticʉ niwĩ: —Mʉsã nʉmosãnumia, mʉsã põꞌrã ʉmʉa, mʉsã põꞌrã numia oꞌmeperi yosase uru meꞌrã weeꞌquere aꞌto yʉꞌʉ tiropʉ miitia, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Cʉ̃ tojo nicã tʉꞌorã, nipeꞌtirãpʉta na oꞌmeperi yosase uru meꞌrã weeꞌquere tuweemii, Aarṍ tiropʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Cʉ̃ tere ñeꞌe, ʉ̃jʉ̃asipiocʉ niwĩ. Na wecʉ wĩꞌmagʉ̃ queose wééca coꞌropʉ piosãcãrã niwã. Beꞌro te bʉꞌáca beꞌro wecʉ wĩꞌmagʉ̃ queose weronojõ bajugʉ wijacʉ niwĩ. Cʉ̃rẽ ĩꞌarã, masã aꞌtiro nicãrã niwã: —Israe curuacjãrã, ãꞌrĩ marĩ ẽjõpeogʉ nimi. Cʉ̃ta marĩrẽ Egiptopʉ níꞌcãrãrẽ sʉꞌori miiwijawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na tojo weecã ĩꞌagʉ̃, Aarṍ wecʉ wĩꞌmagʉ̃ queose põtẽorõpʉ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Tuꞌajanʉꞌcõ, masãrẽ werecʉ niwĩ: —Ñamiacã marĩ wiogʉ Õꞌacʉ̃rẽ bosenʉmʉ wee eꞌcatipeorãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ape nʉmʉ peꞌe ñamiñaꞌcũrõ wãꞌcã, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeocãrã niwã. Tojo nicã, apeyema Õꞌacʉ̃ narẽ añurõ weeato nírã, waꞌicʉrãrẽ wẽjẽ, ʉ̃jʉ̃amorõpeocãrã niwã. Beꞌro nipeꞌtirã masã baꞌa, sĩꞌrĩ, queꞌa, ejanujãcãrã niwã. Tuꞌajanʉꞌcõ, wãꞌcãnʉꞌcã, tʉꞌomasĩti, bopoyase moorã basanuꞌcũsiacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ Moisére nicʉ niwĩ: —Waꞌagʉsaꞌa. Dijaya. Mʉꞌʉ, Egiptopʉ miiwijaꞌcãrã ñaꞌabutiarã dojorã weema. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Na maata waro yʉꞌʉ weedutiꞌquere duꞌucãꞌma. Niꞌcʉ̃ wecʉ wĩꞌmagʉ̃ queosere uru meꞌrã ʉ̃jʉ̃asipio wĩorẽama. Cʉ̃rẽ eꞌcatipeorã, ejaqueꞌama. Tojo nicã, waꞌicʉrãrẽ wẽjẽ, cʉ̃rẽ ʉ̃jʉ̃amorõpeoama. Aꞌtiro ni ucũama: “Israe curuacjãrã, ãꞌrĩ marĩ ẽjõpeogʉ nimi. Cʉ̃ta Egipto diꞌtapʉre marĩrẽ sʉꞌori miiwijawĩ”, niama, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Õꞌacʉ̃ apeye Moisére ninemocʉ niwĩ: —Yʉꞌʉ sõjã masãrẽ na nisetisere añurõ masĩꞌi. Yʉꞌʉre yʉꞌrʉnʉꞌcãsepijarã nima. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Na meꞌrã uayʉꞌrʉmajãꞌa. Tojo weegʉ narẽ buꞌiri daꞌre bajuriopeꞌogʉti. Yʉꞌʉ tojo weecã, ne cãꞌmotaꞌaticãꞌña. Mʉꞌʉ pãrãmerã nituriarã meꞌrã peꞌema pãjãrã masãputicã weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Õꞌacʉ̃ tojo nimicã, Moisé peꞌe cʉ̃ wiogʉ Õꞌacʉ̃rẽ aꞌte ucũse meꞌrã nijĩsijosĩꞌrĩcʉ niwĩ: —Wiogʉ, ¿deꞌro weegʉ mʉꞌʉ, mʉꞌʉ yarã masã meꞌrã tocãꞌrõ uati? Mʉꞌʉ tutuayʉꞌrʉse meꞌrã narẽ Egiptopʉre miiwijawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mʉꞌʉ narẽ buꞌiri daꞌrecãma, Egiptocjãrã aꞌtiro ni wãcũrãsama: “Õꞌacʉ̃ narẽ ʉ̃rʉ̃pagʉpʉ wẽjẽ, aꞌti diꞌtapʉ nirãrẽ bajuriogʉti nígʉ̃, miiwijapĩ”, nibosama. Uaticãꞌña majã. Mʉꞌʉ yarã masãrẽ ñaꞌarõ weesĩꞌrĩsere tocãꞌrõta duꞌuya. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Mʉꞌʉrẽ daꞌracoꞌterã Abrahãrẽ, Isaare, Jacore níꞌquere wãcũña. Mʉꞌʉ basuta mʉꞌʉ wãme meꞌrã narẽ aꞌtiro nicũpã: “Mʉsã pãrãmerã nituriarãrẽ ñocõa weronojõ pãjãrã masãputicã weegʉti. Tojo nicã, aꞌti diꞌta mʉsãrẽ oꞌogʉti níꞌque diꞌtare mʉsã pãrãmerã nituriarãrẽ oꞌogʉsaꞌa. Na ye diꞌta ninuꞌcũcãꞌrõsaꞌa”, nicũpã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Moisé tojo nicã tʉꞌogʉ, Õꞌacʉ̃ cʉ̃ yarã masãrẽ “Buꞌiri daꞌregʉti” nimiꞌquere duꞌucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Beꞌro Moisé ʉ̃rʉ̃gʉ̃pʉ níꞌcʉ Õꞌacʉ̃ dutise pʉa pãꞌrẽpʉ ojanoꞌque pjĩrĩrẽ miidijaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Õꞌacʉ̃ta te pjĩrĩrẽ weecʉ niwĩ. Cʉ̃ basuta topʉ níꞌquere ñacũ, ojaõꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josué masã na caricũsere tʉꞌogʉ, Moisére aꞌtiro nicʉ niwĩ: —Masã aꞌmewẽjẽrã caricũrõ weronojõ bʉsʉrocoro marĩ cãrĩse uꞌturi waꞌteropʉre, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moisé peꞌe cʉ̃rẽ aꞌtiro yʉꞌticʉ niwĩ: —Na aꞌmewẽjẽ wapataꞌaca beꞌro caricũ eꞌcatise mejẽta nírõcoro. Tojo nicã aꞌmewẽjẽ bajuriorã bʉjawetirã basase mejẽta nírõcoro. Mejẽcã basase tʉꞌogʉcoro, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Moisé na nirõpʉ etagʉ, wecʉ wĩꞌmagʉ̃ na uru meꞌrã wĩorẽꞌcʉre ĩꞌagʉ̃, na noꞌo ʉaro basanuꞌcũcusiasere ĩꞌagʉ̃, uayʉꞌrʉacʉ niwĩ. Tojo weegʉ cʉ̃ cʉose pjĩrĩrẽ tigʉ ʉ̃rʉ̃gʉ̃ dʉꞌpocã́pʉ doquemʉtõcũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Te beꞌro wecʉ wĩꞌmagʉ̃ queose wĩorẽꞌcʉre mii, pecameꞌepʉ doquetĩacʉ niwĩ. Beꞌro cʉ̃rẽ añuse marãrĩ doquemʉtõcʉ niwĩ. Te marãrĩrẽ aco buꞌipʉ wẽestepoꞌocʉ niwĩ. Tojo weetoja, Israe curuacjãrãrẽ te acore sĩꞌrĩcã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moisé Aarṍrẽ aꞌtiro nicʉ niwĩ: —¿Ãꞌrã masã deꞌro weemiati mʉꞌʉrẽ? Mʉꞌʉ narẽ ñaꞌabutiaro weecã weeapã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aarṍ peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ acabiji, yʉꞌʉ meꞌrã uatigʉta. Mʉꞌʉ masĩmiba. Ãꞌrã masã ñaꞌarõ weesere weepoyʉꞌrʉama. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Na yʉꞌʉre aꞌtiro niama: “Niꞌcʉ̃ ʉ̃sã ẽjõpeoacjʉ queose marĩrẽ sʉꞌori miacjʉre weebosaya. Sõꞌonícʉ Moisé marĩrẽ Egiptopʉre sʉꞌori miiwijatiꞌcʉre deꞌro waꞌaro waꞌapã. Masĩtisaꞌa”, niama. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Na tojo nicã, narẽ yʉꞌtiapʉ: “Noꞌo oꞌmeperi yosase uru meꞌrã weeꞌquere cʉorãnojõ tuweemii miitia”, niapʉ. Na yʉꞌʉre miiti, tere oꞌoama. Yʉꞌʉ tere pecameꞌepʉ doquetĩapʉ. Wãcũña marĩrõ ãꞌrĩ wecʉ wĩꞌmagʉ̃ queose wijamajãmi, nicʉ niwĩ Aarṍ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moisé na noꞌo ʉaro weesere ĩꞌacʉ niwĩ. Tere ĩꞌamigʉ̃, Aarṍ peꞌe narẽ “Tojo weeticãꞌña”, niticʉ niwĩ. Tojo weerã na ñaꞌarõ weesere ĩꞌarã, narẽ ĩꞌatuꞌtirã bujicãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tojo weecã ĩꞌagʉ̃, Moisé na suꞌti caseri meꞌrã weeꞌque wiꞌseri waꞌtero sãjãa, ejanʉꞌcãcʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: —“Õꞌacʉ̃ yarã niꞌi” nirãnojõ yʉꞌʉ tiro aꞌtia, nicʉ niwĩ. Cʉ̃ tojo nicã, nipeꞌtirã Leví ya curuacjãrã Moisé tiropʉ nerẽnʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Na tojo weecã ĩꞌagʉ̃, Moisé narẽ nicʉ niwĩ: —Õꞌacʉ̃, Israe curuacjãrã wiogʉ, aꞌtiro nimi: “Mʉsãnʉcʉ̃ diꞌpjĩrĩrẽ dʉꞌteõꞌoña. Beꞌro mʉsã wiꞌseri nirõpʉ tojaaya. Tojaa, wiꞌserinʉcʉ̃ mʉsã acabijirãrẽ, mʉsã maꞌmisʉmʉarẽ, mʉsã meꞌrãcjãrãrẽ, mʉsã ya wiꞌi pʉꞌto nirãrẽ wẽjẽcãꞌña”, ni werecʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leví ya curuacjãrã Moisé tojo weedutiꞌquere queoro weecãrã niwã. Ti nʉmʉrẽ iꞌtiati mil ʉmʉa wẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Beꞌro Moisé narẽ nicʉ niwĩ: —Masã Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãcã, mʉsã cʉ̃ dutiro wéérã, mʉsã põꞌrãrẽ, mʉsã acabijirãrẽ, mʉsã maꞌmisʉmʉapʉreta na ñaꞌarõ weeꞌquere ĩꞌarã, wẽjẽcãꞌmotaꞌapʉ. Tojo weegʉ niꞌcãcã Õꞌacʉ̃ mʉsãrẽ cʉ̃ dutisere daꞌradutigʉ cũuami. Aꞌtiro wee mʉsãrẽ añurõ waꞌacã weeami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ape nʉmʉ peꞌere Moisé masãrẽ aꞌtiro nicʉ niwĩ: —Mʉsã Õꞌacʉ̃ dutisere yʉꞌrʉnʉꞌcãrã, ñaꞌabutiaro weecãrã niapʉ. Niꞌcãrõacãrẽ Õꞌacʉ̃ tiropʉ mʉjãgʉ̃ti. Apetero weegʉ mʉsã yere cʉ̃rẽ sẽrĩbosacã, mʉsãrẽ acobojobosami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Cʉ̃ tojo níca beꞌro apaturi Moisé Õꞌacʉ̃ tiropʉ mʉjãa, cʉ̃rẽ nicʉ niwĩ: —Diacjʉ̃ta masã wecʉ wĩꞌmagʉ̃ uru meꞌrã queose wĩorẽꞌcʉre eꞌcatipeotjĩarã, ñaꞌabutiaro weecãrã niama. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Niꞌcãrõacãrẽ mʉꞌʉrẽ ʉpʉtʉ sẽrĩꞌi. Narẽ acobojoya. Acobojotigʉ pũrĩcã, mʉꞌʉ ya pũrĩ catirã wãme ojaõꞌonoꞌca pũrĩpʉ yʉꞌʉ wãmerẽ coecãꞌña, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Õꞌacʉ̃ peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ dutisere yʉꞌrʉnʉꞌcãꞌcãrã diaꞌcʉ̃rẽ ya pũrĩpʉ ojaõꞌonoꞌcãrã wãmerẽ coegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Niꞌcãrõacãrẽ majã waꞌaya. Masãrẽ yʉꞌʉ mʉꞌʉrẽ “Oꞌogʉti” níca diꞌtapʉ sʉꞌori miaña. Yʉꞌʉre werecoꞌtegʉ mʉꞌʉrẽ sʉꞌori ĩꞌo miagʉ̃sami. Tojo weemicã, yʉꞌʉ buꞌiri daꞌreri nʉmʉ ejacã, na ñaꞌarõ weeꞌque wapare narẽ buꞌiri daꞌregʉti, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Beꞌro Õꞌacʉ̃ masãrẽ buꞌiri daꞌregʉ, duti ñaꞌabutiase oꞌócʉ niwĩ. Aarṍ wecʉ wĩꞌmagʉ̃ queose yeeꞌcʉre eꞌcatipeoꞌque buꞌiri tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Õꞌacʉ̃ masãrẽ buꞌiri daꞌréca beꞌro Moisére aꞌtiro nicʉ niwĩ: —Aꞌtore wijayá. Masã mʉꞌʉ Egiptopʉ miiwijaꞌcãrã meꞌrã waꞌagʉsaꞌa. Yʉꞌʉ Abrahãrẽ, Isaare, Jacore “Oꞌogʉti” níca diꞌtapʉ waꞌaya. Ti diꞌtare na pãrãmerãrẽ “Oꞌogʉti” nitojawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Yʉꞌʉre werecoꞌtegʉre mʉsã dʉporo oꞌógʉti. Yʉꞌʉ ti diꞌtapʉ nirã́ cananeo masã, amorreo masã, hitita masã, ferezeo masã, heveo masã, jebuseo masãrẽ cõꞌawĩrõgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Cabra õpẽcõ, mumiaco pajiro aco oꞌmabʉroro weronojõ nirĩ diꞌtapʉre waꞌarã weeꞌe. Yʉꞌʉ peꞌe mʉsã meꞌrã waꞌasome. Mʉsã yʉꞌrʉnʉꞌcãsepijarã niꞌi. Yʉꞌʉ waꞌagʉ pũrĩcã mʉsã ñaꞌarõ weecã, buꞌiri daꞌre bajuriodijobosaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Masã te bʉjawetise quetire tʉꞌorã, dʉjasewãꞌarã weronojõ pũrõ bʉjaweticãrã niwã. Na ne niꞌcʉ̃pʉta bʉsa, oꞌmeperi yosaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Õꞌacʉ̃ Moisére aꞌtiro wereyutojacʉ niwĩ: —Israe curuacjãrãrẽ aꞌtiro ni wereya: “Mʉsã yʉꞌrʉnʉꞌcãsepijarã niꞌi. Mʉsã waꞌteropʉre mʉsã meꞌrã yʉꞌʉ cãꞌrõ baꞌpatiquejogʉ, mʉsãrẽ buꞌiri daꞌre bajuriobosaꞌa. Tojo weerã mʉsã suꞌti añusere, mʉsã bʉsasere, tojo nicã yosasere tuweemiicãꞌña. Mʉsã tere tuweemiica beꞌro yʉꞌʉ mʉsãrẽ weeatjere wãcũgʉ̃saꞌa”, ni wereya, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tojo weerã Israe curuacjãrã Horeb wãmeticjʉ ʉ̃rʉ̃gʉ̃pʉ wijáca beꞌro bʉsanemoti, oꞌmeperi yosanemoticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisé Õꞌacʉ̃ suꞌti caseri meꞌrã wééca wiꞌiacãrẽ mia, masã na nirṍ yoacureropʉ cũucʉ niwĩ. Ti wiꞌiacãrẽ “Õꞌacʉ̃ meꞌrã bocaejari wiꞌi niꞌi”, nicʉ niwĩ. Noꞌo niꞌcʉ̃ Õꞌacʉ̃rẽ cʉ̃ weeatjere sẽrĩtiñaꞌsĩꞌrĩgʉ̃nojõ topʉ waꞌacʉ niwĩ. Ti wiꞌiacã na masã nirṍ yʉꞌrʉro nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moisé ti wiꞌiacãpʉ waꞌacã ĩꞌarã, masã nipeꞌtirã na ye wiꞌseri sope pʉꞌtopʉ nuꞌcũcãrã niwã. Téé ti wiꞌipʉ sãjãcãpʉ cʉ̃rẽ ĩꞌasirutuduꞌucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moisé ti wiꞌipʉ sãjãcãta, oꞌmepõꞌrã dijati, ti wiꞌi sãjãrĩ sopepʉ ejanʉꞌcãcaro niwʉ̃. Õꞌacʉ̃ Moisé meꞌrã ucũrĩ cura tojo tojanʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Masã oꞌmepõꞌrã ti wiꞌi sopepʉ ejanʉꞌcãcã ĩꞌarã, nipeꞌtirã na ye wiꞌseri sope pʉꞌto paamuꞌrĩqueꞌacãrã niwã. Õꞌacʉ̃rẽ eꞌcatipeorã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Õꞌacʉ̃ Moisé meꞌrã aꞌmerĩ ĩꞌapõtẽo, niꞌcʉ̃, cʉ̃ meꞌrãcjʉ̃rẽ ucũgʉ̃ weronojõ ucũcãrã niwã. Na ucṹca beꞌro Moisé masã tiropʉre dajatojaacʉ niwĩ. Cʉ̃rẽ weetamucoꞌtegʉ maꞌmʉ Josué, Nun macʉ̃ peꞌe pũrĩcã ti wiꞌiacã poꞌpeapʉ toja, ninuꞌcũcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisé Õꞌacʉ̃rẽ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ yʉꞌʉre “Ãꞌrã masãrẽ sʉꞌori miaña”, niapʉ. Tojo nimigʉ̃, yʉꞌʉ meꞌrã waꞌacjʉre weretiapʉ. Tojo nicã “Mʉꞌʉrẽ añurõ masĩꞌi. Mʉꞌʉ weesere ĩꞌagʉ̃, eꞌcatiꞌi”, niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Diacjʉ̃ta yʉꞌʉ meꞌrã eꞌcatigʉ pũrĩcã, mʉꞌʉ weeatjere yʉꞌʉre wereya. Mʉꞌʉ tojo weecã, mʉꞌʉrẽ masĩnemogʉ̃saꞌa. Tojo nicã, mʉꞌʉ tʉꞌsasere weenuꞌcũgʉ̃saꞌa. Wãcũña. Ãꞌrã masã, mʉꞌʉ yarã nima, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Moisé tojo nicã tʉꞌogʉ, Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Yʉꞌʉ basuta mʉsãrẽ baꞌpatigʉti. Baꞌpati, mʉꞌʉrẽ soose oꞌogʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisé peꞌe cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ basu ʉ̃sãrẽ sʉꞌori waꞌatigʉ pũrĩcã, ʉ̃sãrẽ aꞌtore wijacã weeticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mʉꞌʉ ʉ̃sã meꞌrã baꞌpatiwãꞌcãticãma, apeye diꞌtacjãrã masã “Õꞌacʉ̃ Moisé meꞌrã, Israe curuacjãrã meꞌrã eꞌcatimi”, ni masĩsome. Ʉ̃sã meꞌrã waꞌacã pũrĩcãrẽ, “Õꞌacʉ̃ Moisé, Israe curuacjãrã meꞌrã diaꞌcʉ̃ nimi”, ni masĩrãsama, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Õꞌacʉ̃ Moisére apaturi ucũapocʉ niwĩ: —Mʉꞌʉrẽ añurõ masĩꞌi. Mʉꞌʉ meꞌrã eꞌcatiꞌi. Tojo weegʉ mʉꞌʉ sẽrĩꞌcaronojõta weegʉsaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Cʉ̃ tojo nicã tʉꞌogʉ, Moisé aꞌtiro ni sẽrĩnemocʉ niwĩ: —Mʉꞌʉ asistesere yʉꞌʉre ĩꞌoña. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Nipeꞌtise yʉꞌʉ asistesere mʉꞌʉ dʉporo yʉꞌrʉacã weegʉti. Tojo yʉꞌrʉacã, nipeꞌtise yʉꞌʉ añubutiase nisere ĩꞌagʉ̃saꞌa. Tojo nicã mʉꞌʉ ĩꞌorõpʉ yʉꞌʉ wãmerẽ weregʉti. Noꞌo yʉꞌʉ pajañaꞌsĩꞌrĩgʉ̃rẽ pajañaꞌgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tojo nimicã, ya diapoama ne ĩꞌasome. Ne niꞌcʉ̃ yʉꞌʉre ĩꞌáca beꞌro catisome majã. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Õꞌacʉ̃ apeye quẽꞌrãrẽ nicʉ niwĩ: —Aꞌto yʉꞌʉ tiro ʉ̃tãgãpʉ nuꞌcũña. ");
INSERT INTO tuoNT_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","23","Yʉꞌʉ asistese meꞌrã yʉꞌrʉagʉ, niꞌcã cope tigapʉ nirĩ copepʉ mʉꞌʉrẽ cũugʉ̃ti. Yʉꞌʉre ĩꞌarĩ nígʉ̃, ya omocã meꞌrã mʉꞌʉ ya diapoare cãꞌmotaꞌagʉti. Téé yʉꞌʉ yʉꞌrʉagʉpʉ cãꞌmotaꞌatʉogʉti. Yʉꞌʉ sẽꞌema waroma ĩꞌagʉ̃saꞌa, ĩꞌagʉ̃ peꞌe. Yʉꞌʉ diapoa peꞌema, ne ĩꞌanoꞌña marĩrõsaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Õꞌacʉ̃ Moisére cʉ̃ asistesere ĩꞌóca beꞌro cʉ̃rẽ nicʉ niwĩ: —Pʉa pjĩ ʉ̃tã pjĩrĩ mʉꞌʉ doquemʉtõꞌque pjĩrĩ weronojõta daꞌreya. Ne waro ojaꞌquereta ojagʉti tja. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ñamiacã ñamicurero ʉ̃rʉ̃gʉ̃ Sinaípʉ mʉjãgʉ̃tigʉ̃ apoyuya. Tigʉ dʉposãrĩpʉ waꞌa, yʉꞌʉ tiro ejaya. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ne apĩ mʉꞌʉ meꞌrã mʉjãticãꞌto. Ne tigʉpʉre ãpẽrã masã marĩato. Tojo nicã oveja, wecʉa tigʉ põtẽorõpʉre baꞌanuꞌcũticãꞌto. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Cʉ̃ níꞌcaronojõta Moisé todʉporo ʉ̃tã pjĩrĩ níꞌque weronojõ daꞌrecʉ niwĩ. Ape nʉmʉ peꞌe ñamicurero wãꞌcã, Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta ʉ̃rʉ̃gʉ̃ Sinaípʉ te pjĩrĩrẽ miimʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","To cʉ̃ mʉjãejacã, Õꞌacʉ̃ oꞌmecurua meꞌrã dijati, Moisé tiropʉ ejacʉ niwĩ. Cʉ̃ wãmerẽ weregʉ, “Wiogʉ niꞌi”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moisé dʉporo yʉꞌrʉagʉ, aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. Masãrẽ pajañaꞌgʉ̃, añurõ weesetigʉ niꞌi. Uáyegʉ mejẽta niꞌi. Masãrẽ yʉꞌʉ maꞌiyʉꞌrʉsere ĩꞌoꞌo. Yʉꞌʉ “Weegʉti” níꞌquere queoro weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Peje curari beꞌrocjãrã quẽꞌrãrẽ maꞌinuꞌcũcʉ̃saꞌa. Masã ñaꞌarõ weesere, yʉꞌʉre yʉꞌrʉnʉꞌcãsere acobojoꞌo. Yʉꞌʉ tojo weemicã, ñaꞌarõ weegʉ́a ne buꞌiri daꞌrenoꞌña marĩgʉ̃ tojatisami. Buꞌiri daꞌrenoꞌsami. Pacʉsʉmʉa ñaꞌarõ weeꞌque wapa na põꞌrãpʉre, na pãrãmerãpʉre, na pãrãmerã nituriarãpʉre, tojota buꞌiri daꞌre yapatinoꞌrãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Cʉ̃ tojo nicã tʉꞌogʉ, Moisé maata nucũcãpʉ paamuꞌrĩqueꞌa, Õꞌacʉ̃rẽ eꞌcatipeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Cʉ̃rẽ eꞌcatipeogʉ, aꞌtiro ni sẽrĩcʉ niwĩ: —Wiogʉ, diacjʉ̃ta yʉꞌʉ weesere tʉꞌsagʉ, ʉ̃sãrẽ baꞌpatiya. Ãꞌrã masã yʉꞌrʉnʉꞌcãsepijarã nima. Tojo nimicã, ʉ̃sã ñaꞌasere, ʉ̃sã ñaꞌarõ weesere acobojoya. Ʉ̃sãrẽ mʉꞌʉ yarã masã tojacã weeya, ni sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Õꞌacʉ̃ Moisé sẽrĩꞌquere tʉꞌóca beꞌro aꞌtiro nicʉ niwĩ: “Añurõ tʉꞌoya. Niꞌcãrõacãrẽ yʉꞌʉ nipeꞌtirã mʉsã Israe curuacjãrã meꞌrã ‘Aꞌtiro weegʉti’ ni apoꞌquere cũugʉ̃ti. Nipeꞌtirã masã ĩꞌorõpʉ añubutiasere weeĩꞌogʉ̃saꞌa. Te todʉporopʉ ne ape diꞌtapʉ aꞌti turipʉre weeĩꞌonoꞌña marĩꞌquere ĩꞌogʉ̃ti. Noꞌo nipeꞌtirã mʉsã waꞌtero nirã́ yʉꞌʉ mʉsã wiogʉ mʉsãrẽ añubutiaro weeatjere ĩꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","”Niꞌcãcã yʉꞌʉ mʉsãrẽ weedutiꞌquere weeya. Mʉsã tojo weecã, yʉꞌʉ mʉsã tiro nirã́ amorreo masãrẽ, cananeo masãrẽ, hitita masãrẽ, ferezeo masãrẽ, heveo masãrẽ, jebuseo masãrẽ cõꞌawĩrõgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","”Mʉsã sãjãti diꞌtacjãrã meꞌrã ne aꞌmerĩ ‘Tojo weerã́’, ni apoticãꞌña. Mʉsã tojo weecã pũrĩcãrẽ, mʉsãrẽ na ẽjõpeose queose yeeꞌquere sirutucã weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Tojo weronojõ oꞌorã, aꞌtiro peꞌe weeya. Na waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeosere paamʉtõcãꞌña. Apeye ʉ̃tãpaga na miinʉꞌcõꞌque na ẽjõpeosere mʉtõpeꞌocãꞌña. Tojo nicã Aserá wãmetigo na ẽjõpeose yeeꞌque yucʉ meꞌrã weeꞌque tuturire dʉtecõꞌacãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","”Ne apĩ Õꞌacʉ̃ nitigʉre ẽjõpeoticãꞌña. Ãpẽrãrẽ ẽjõpeosirutucã ne ʉaweꞌe. Yʉꞌʉ diaꞌcʉ̃rẽ ẽjõpeocã ʉaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","”Ti diꞌtapʉ nirã́ meꞌrã ne aꞌmerĩ ‘Tojo weerã́’, ni apoticãꞌña. Na ãpẽrãnojõ Õꞌacʉ̃ nitirãrẽ eꞌcatipeorã, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeorã, mʉsãrẽ pijibosama. Mʉsã quẽꞌrã na wẽjẽ ʉ̃jʉ̃amorõpeoꞌquere na meꞌrã baꞌatamubosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Apetero weerã na põꞌrã numiarẽ mʉsã põꞌrã ʉmʉarẽ numisobosama. Numisoo, na põꞌrã numia Õꞌacʉ̃ nitirãrẽ ẽjõpeorã, mʉsã põꞌrã ʉmʉarẽ mejãrõta narẽ ẽjõpeocã weebosama. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","”Mʉsã ne cãꞌrõ Õꞌacʉ̃ nitirãrẽ cõme meꞌrã ʉ̃jʉ̃asipio wĩorẽꞌquere ẽjõpeoticãꞌña”, nicʉ niwĩ Õꞌacʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Õꞌacʉ̃ Moisére cʉ̃ dutise wéréca beꞌro cʉ̃rẽ nicʉ niwĩ: “Yʉꞌʉ ucũsere ojaya. Te yʉꞌʉ mʉꞌʉ meꞌrã, Israe curuacjãrã meꞌrã apoꞌque niꞌi”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moisé topʉre Õꞌacʉ̃ meꞌrã cuarenta ʉmʉcori, cuarenta ñamirĩ tojacʉ niwĩ. Ne baꞌaro marĩrõ, sĩꞌrĩrõ marĩrõ nicʉ niwĩ. Topʉ “Õꞌacʉ̃ masã meꞌrã tojo weegʉti” ni apoꞌquere te ʉ̃tãpjĩrĩpʉ ojaõꞌocʉ niwĩ. Tetá diez Õꞌacʉ̃ dutise cũuꞌque nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Beꞌro Moisé ʉ̃rʉ̃gʉ̃ Sinaípʉ níꞌcʉ pʉa pjĩ te dutise ojaꞌque pjĩrĩrẽ miidijaticʉ niwĩ. Tigʉ ʉ̃rʉ̃gʉ̃pʉ níꞌcʉ dijatagʉ, cʉ̃ diapoa asistesere masĩticʉ niwĩ. Cʉ̃, Õꞌacʉ̃ meꞌrã ucṹca beꞌro niyucã, tojo asistecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aarṍ, tojo nicã nipeꞌtirã Israe curuacjãrã cʉ̃ diapoa asistecã ĩꞌarã, cʉ̃rẽ ui nicãrã niwã. Tojo weerã cʉ̃ pʉꞌtoacãpʉ waꞌaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Na tojo weecã ĩꞌagʉ̃, Moisé peꞌe narẽ pijineocʉ niwĩ. Tojo weerã Aarṍ, nipeꞌtirã wiorã cʉ̃ tiropʉ dajacãrã niwã. Na dajacã ĩꞌagʉ̃, na meꞌrã ucũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Beꞌro nipeꞌtirãpʉta Israe curuacjãrã etabʉrocãrã niwã. Na etacã, Moisé Õꞌacʉ̃ ʉ̃rʉ̃gʉ̃ Sinaípʉ dutise oꞌoꞌquereta narẽ werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Na meꞌrã ucũpeꞌoca beꞌro cʉ̃ diapoapʉre niꞌcã suꞌti casero ʉsemerĩrĩ casero meꞌrã moꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Moisé Õꞌacʉ̃ meꞌrã bocaejari wiꞌipʉ cʉ̃ meꞌrã ucũgʉ̃ sãjãgʉ̃, ti caserore tuweemʉjãcʉ niwĩ. Cʉ̃ wijatagʉ, Õꞌacʉ̃ dutisere Israe curuacjãrãrẽ wereturiamʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Cʉ̃ ti wiꞌire wijatacã, Israe curuacjãrã Moisé diapoa asistecã ĩꞌacãrã niwã. Tojo weegʉ ti casero meꞌrã diapoare moꞌamʉjãcʉ niwĩ tja. Õꞌacʉ̃ meꞌrã ucũgʉ̃ sãjãgʉ̃, ti caserore tuweemʉjãcʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Aꞌte capítulori 25–30; 35–39 Õꞌacʉ̃ wiꞌi waꞌicʉrã caseri meꞌrã wééca wiꞌi cjasere wereꞌe. Aꞌti capítulo cuarenta, Õꞌacʉ̃ “Tojo weeya”, ni weedutiꞌquere wereꞌe. Moisé masãrẽ Õꞌacʉ̃ dutisere wéréca beꞌro Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Nimʉꞌtãrĩ mujĩpũ, ninʉꞌcãrĩ nʉmʉ nicã, ya wiꞌi, waꞌicʉrã caseri meꞌrã wééca wiꞌire aponʉꞌcõña. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ti wiꞌipʉ yʉꞌʉ ‘Masã meꞌrã añurõ weegʉti’ níꞌquere cʉori acarore cũuña. Ti acaro poꞌpeapʉ yʉꞌʉ diez dutise ojaꞌque pjĩrĩ sãñasaꞌa. Ti acaro dʉporo ʉsebʉtiri caserore yoo cãꞌmotaꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mesare, sĩꞌocjʉ quẽꞌrãrẽ topʉ cũuña. Ti mesapʉre docepaga pã́rẽ añurõ apopeoya. Tigʉ sĩꞌocjʉpʉre sĩꞌosepagare sĩꞌonʉꞌcõña. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ʉꞌmʉtise ʉ̃jʉ̃amorõpeoro uru meꞌrã weeꞌcaro ‘Masã meꞌrã añurõ weegʉti’ níꞌque cʉori acaro põtẽorõpʉ peoya. Ti wiꞌi, ya wiꞌi ne sãjãnʉꞌcãrõrẽ niꞌcã casero ʉsebʉtiri caserore yooya. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tuꞌajanʉꞌcõ, ti wiꞌi ne sãjãrõ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore cũuña. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","To beꞌro bapa pajiri pare ya wiꞌi, tojo nicã waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoro, aꞌte pʉaro waꞌtero, deco ti pare dʉpoya. Ti pare aco piomuꞌmuoña. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Yʉꞌʉ mʉꞌʉrẽ dutiꞌcaronojõta, ti wiꞌi sumutore apoya. Tuꞌajanʉꞌcõ, suꞌtiro casero ʉsebʉtiri caserore topʉ sãjãrõ cãꞌmotaꞌatjore yooya. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","”Beꞌro aꞌtiro weeya. Ye waro tojato nígʉ̃, ʉꞌse to waꞌrewʉasenojõrẽ ti wiꞌire waꞌreya. Nipeꞌtise ti wiꞌipʉ nisere waꞌrepeꞌocãꞌña. Tojo weecã, topʉ nise nipeꞌtise ye tojarosaꞌa. Ne ñaꞌase marĩrõ tojarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tojo nicã, te ʉꞌsereta tja waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoro buꞌipʉ waꞌreya. Topʉ deꞌro nisere waꞌrepeꞌocãꞌña. Mʉꞌʉ tojo weegʉ tore añurõ, ñaꞌase marĩrõ waro tojacã weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Beꞌro te ʉꞌse meꞌrã bapa pajiri papʉre waꞌreya. Tojo nicã, to pesaro dʉꞌpocãrẽ waꞌregʉsaꞌa. Tere waꞌregʉ, ye waro tojacã weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","”Beꞌro Aarṍrẽ, cʉ̃ põꞌrã ʉmʉarẽ ya wiꞌi sope pʉꞌtopʉ miaña. Topʉ narẽ ʉꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aarṍ paꞌi cʉ̃ sãñarõnojõrẽ sãñato. Beꞌro cʉ̃rẽ ‘Yé cjasere daꞌragʉ’ paꞌi sãjãdutigʉ, ʉꞌsere piopeoya. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tuꞌajanʉꞌcõ, cʉ̃ põꞌrãrẽ miiti, narẽ suꞌti yoase paca suꞌaꞌquere sãaña. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Na pacʉ Aarṍrẽ weeꞌcaronojõ napʉre ʉꞌsere piopeoya. Mʉꞌʉ tojo weecã, na quẽꞌrã yarã paꞌia, yé cjasere daꞌrarã nirãsama. Mʉꞌʉ narẽ aꞌtiro ʉꞌse piopeose meꞌrã na pãrãmerã nituriarã paꞌia nisere ninuꞌcũcãꞌrãsama. Ne peꞌtisome”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Õꞌacʉ̃ dutíꞌcaronojõta Moisé nipeꞌtisere weepeꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tojo weerã na niꞌcã cʉ̃ꞌma Egiptopʉre wijáca beꞌro nimʉꞌtãrĩ mujĩpũ, ninʉꞌcãrĩ nʉmʉrẽ Õꞌacʉ̃ wiꞌire aponʉꞌcõcãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Moisé Õꞌacʉ̃ wiꞌire aponʉꞌcõca beꞌro, oꞌmecurua ti wiꞌire tuubiꞌacaro niwʉ̃. Õꞌacʉ̃ cʉ̃ asistese ti wiꞌipʉre niyʉꞌrʉacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Tojo weegʉ Moisé ne sãjãamasĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Oꞌmecurua ti wiꞌi buꞌipʉ níꞌque mʉjã́áca beꞌro Israe curuacjãrã na ye wiꞌserire pã́ámii, aperopʉ waꞌamʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Oꞌmecurua mʉjãaticãma, na ye wiꞌserire ne pã́ámiiticãrã niwã. Téé oꞌmecurua mʉjãacãpʉ coꞌtemʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Israe curuacjãrã noꞌo na waꞌaro nipeꞌtirã ĩꞌorõpʉ Õꞌacʉ̃ ya oꞌmecurua, ʉmʉcore ti wiꞌi buꞌipʉ nimʉjãcaro niwʉ̃. Ñami peꞌema ti curua poꞌpeapʉ pecameꞌe ʉ̃jʉ̃rĩ põꞌrã nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Beꞌro Moisé, Õꞌacʉ̃ dutisere daꞌracoꞌteꞌcʉ wẽ́rĩ́ca beꞌro, Õꞌacʉ̃ Josuére ucũcʉ niwĩ. Josué peꞌe Nun wãmetigʉ macʉ̃, tojo nicã Moisére weetamucoꞌteꞌcʉ nicʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ aꞌtiro ni ucũcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Moisé yʉꞌʉ dutisere weeꞌcʉ wẽrĩa waꞌami. Niꞌcãrõacãma mʉꞌʉ peꞌe nipeꞌtirã Israe curuacjãrãrẽ dia Jordã́rẽ sʉꞌori pẽꞌagʉ̃saꞌa majã. Yʉꞌʉ mʉsãrẽ oꞌoatji diꞌtapʉ waꞌarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Yʉꞌʉ Moisére ‘Aꞌtiro weegʉti’ níꞌcaronojõta mʉsãrẽ weegʉsaꞌa. Yʉꞌʉ nipeꞌtiro mʉsã diꞌta sijatjo ejatuaro oꞌogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Diꞌta aꞌtocãꞌrõ yoaro oꞌogʉti. Yucʉ marĩrõpʉ, téé Líbano diꞌtapʉ nitʉorosaꞌa. Eꞌsaro peꞌe maa yoari maa Éufrates, nipeꞌtiro hitita masã ye diꞌta meꞌrã ninʉꞌcã, téé pajiri maa Mediterráneo nirõpʉ nitʉorosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ne ãpẽrã mʉsã meꞌrã aꞌmewẽjẽrã põtẽosome. Moisé meꞌrã níꞌcaronojõta mejãrõta nigʉ̃saꞌa mʉꞌʉ meꞌrã quẽꞌrãrẽ tja. Ne mʉꞌʉrẽ cõꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Tojo weegʉ wãcũtutuaya, uiro marĩrõ nisetiya. Na ñecʉ̃sʉmʉarẽ ‘Aꞌti diꞌtare oꞌogʉti’, niwʉ̃. Mʉꞌʉ narẽ sʉꞌori mia, na meꞌrã aꞌti diꞌtare miiwapa etigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Tojo weegʉ yʉꞌʉ níꞌcaronojõ wãcũtutuanuꞌcũcãꞌña. Tojo nicã nipeꞌtise Moisé mʉsãrẽ dutise cũuꞌquere weepeꞌocãꞌña. Tojo weegʉ nipeꞌtise mʉꞌʉ weesetise añurõ waꞌarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Yʉꞌʉ dutise cũuꞌquere masãrẽ buꞌenuꞌcũcãꞌña. Ñamirĩnʉcʉ̃, ʉmʉcori quẽꞌrãrẽ wãcũnʉrʉ̃nuꞌcũcãꞌña. Tere weecã, nipeꞌtise mʉꞌʉ weesetise queoro waꞌarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Yʉꞌʉ mʉꞌʉrẽ aꞌtiro dutiapʉ. Ne mʉꞌʉrẽ mejẽcã waꞌacã uiticãꞌña. Wãcũtutua nisetiya. Yʉꞌʉ Õꞌacʉ̃, mʉꞌʉ wiogʉ, mʉꞌʉ meꞌrã ninuꞌcũcʉ̃saꞌa. Mʉꞌʉ noꞌo waꞌaro mʉꞌʉ meꞌrã waꞌagʉsaꞌa”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Beꞌro majã Josué Israe curuacjãrã wiorãrẽ aꞌtiro weeduticʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Nipeꞌtiro masã cãrĩse uꞌturipʉ waꞌa weetjĩarã, narẽ ‘Baꞌase mʉsã miatjere apoyuya’, nirã waꞌaya. Marĩ iꞌtia nʉmʉ beꞌro dia Jordã́rẽ pẽꞌarãsaꞌa. Õꞌacʉ̃ oꞌoatji diꞌtare ñeꞌerã waꞌarãsaꞌa”, ni werecʉ niwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Rubén ya curuacjãrã, Gad ya curuacjãrã, tojo nicã deco meꞌrã Manasés ya curuacjãrã peꞌere Josué aꞌtiro ni ucũcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","—Wãcũña Moisé, Õꞌacʉ̃ ʉaro weecoꞌtegʉ, mʉsãrẽ dutiꞌquere: Õꞌacʉ̃ mʉsãrẽ “Sooato” nígʉ̃, aꞌti diꞌta, mʉsã nirĩ diꞌtare oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Mʉsã nʉmosãnumiarẽ, mʉsã põꞌrãrẽ, mʉsã yarã ecarãrẽ aꞌto dia Jordã́ mujĩpũ mʉjãtiro peꞌe cũucãꞌña yujupʉ. Moisé mʉsãrẽ oꞌóca diꞌta niꞌi. Mʉsã nipeꞌtirã ʉmʉa pũrĩcã aꞌmewẽjẽtutuarã nirãnojõ mʉsã wãmo meꞌrã pẽꞌarãsaꞌa. Mʉsã acawererãrẽ aꞌmewẽjẽtamurã, na dʉporo ʉꞌmʉtãña. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Téé Õꞌacʉ̃ mʉsãrẽ soose oꞌoꞌcaronojõta na quẽꞌrãrẽ oꞌocãpʉ, mʉsã narẽ aꞌmewẽjẽtamuduꞌurãsaꞌa. Narẽ Õꞌacʉ̃ oꞌoatji diꞌtare ñeꞌéca beꞌropʉ, aꞌmewẽjẽtamutʉorãsaꞌa. Tojo weetuꞌajaca beꞌropʉ mʉsã ye diꞌta dia aꞌti pãꞌrẽ peꞌe dajatojatirãsaꞌa. Moisé mʉsãrẽ cũuꞌque diꞌtare miiwapa, sãjãqueꞌarãsaꞌa majã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Cʉ̃ tojo nicã tʉꞌorã, na peꞌe aꞌtiro ni yʉꞌticãrã niwã: —Nipeꞌtise mʉꞌʉ dutisere weerãti. Noꞌo mʉꞌʉ waꞌadutiro waꞌarãti. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ʉ̃sã Moisé dutiꞌquere queoro yʉꞌtiꞌcaronojõta mʉꞌʉ quẽꞌrãrẽ yʉꞌtirãti. Ʉ̃sã aꞌte diaꞌcʉ̃rẽ ʉaꞌa. Õꞌacʉ̃ Moisé meꞌrã niwĩ. Mejãrõta cʉ̃ meꞌrã níꞌcaronojõta mʉꞌʉ meꞌrã quẽꞌrãrẽ nicã ʉasãꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Noꞌo mʉꞌʉrẽ yʉꞌrʉnʉꞌcãgʉ̃nojõ, mʉꞌʉ dutiro weetigʉnojõ wẽjẽnoꞌgʉ̃sami. Mʉꞌʉ peꞌe wãcũtutua, nisetiya, nicãrã niwã Josuére. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Beꞌro Josué pʉarã ʉmʉarẽ yaꞌyioropʉ Canaá diꞌtare, Jericópʉre ĩꞌaduꞌtirã waꞌaduticʉ niwĩ. Tojo weerã na Sitĩpʉ níꞌcãrã Jericópʉ waꞌacãrã niwã. Ti ñamirẽ na niꞌcõ ʉmʉarẽ aꞌmetãrãwapataꞌari masõ Rahab wãmetigo ya wiꞌipʉ sãjãa, tojacãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Jericócjʉ̃ wiogʉ “Niꞌcãcã ñami Israe curuacjãrã marĩ ya diꞌtare ĩꞌaduꞌtirã aꞌtiapãrã” nisere tʉꞌobocacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Tojo weegʉ cʉ̃ yarã surarare co ya wiꞌipʉ oꞌócʉ niwĩ. Ti wiꞌipʉ waꞌa weetjĩarã, core aꞌtiro nicãrã niwã: “Na ʉmʉa mʉꞌʉ ya wiꞌipʉ nirãrẽ cõꞌawĩrõña. Na ĩꞌaduꞌtiri masã nima”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Rahab peꞌe narẽ nʉotojaco niwõ. Na sẽrĩtiñaꞌcã, wiogʉ oꞌóꞌcãrãrẽ aꞌtiro yʉꞌtico niwõ: —Diacjʉ̃ta niꞌi. Mʉsã nírõnojõta aꞌti wiꞌita nimiama. Na “Tocjãrã nima” nisere masĩtiasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Mujĩpũ sãjãrĩ cura, aꞌti macã cja sopere biꞌatji dʉporoacã waꞌama. Diapeꞌe waꞌarã waꞌapã. Quero waꞌabaqueꞌoya. Apetero weerã narẽ ẽmʉejábosaꞌa, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Co ya wiꞌi buꞌi opa sira nirõpʉ ñocãpũrĩ põꞌrã sĩꞌoꞌque weronojõ nise docapʉ narẽ nʉocũuco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Co tojo nicã tʉorã, surara maata ti wiꞌipʉ wijaa, dia Jordã́ tiropʉ ĩꞌaduꞌtiri masãrẽ aꞌmarã waꞌamicãrã niwã. Na waꞌáca beꞌro maata ti macã cja sopere biꞌanoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Israe curuacjãrã cãrĩse dʉporo Rahab narẽ nʉoꞌcaropʉ mʉjãa, narẽ nico niwõ: ");
INSERT INTO tuoNT_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","—Yʉꞌʉ masĩꞌi. Õꞌacʉ̃ mʉsã Israe curuacjãrãrẽ aꞌti diꞌtare oꞌotojacʉ niwĩ. Cʉ̃ aꞌti diꞌtacjãrãrẽ mʉsãrẽ uicã weecʉ niwĩ. Tojo weerã ʉ̃sã nipeꞌtirã uibutiasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ʉ̃sã tʉꞌowʉ Õꞌacʉ̃ mʉsãrẽ Egiptopʉ níꞌcãrãrẽ miiwijaꞌquere. Maa sõꞌarĩ maarẽ acore mʉsãrẽ pẽꞌato nígʉ̃, dʉcawaanʉꞌcõ, boposãjãcã weecʉ niwĩ. Tojo nicã, pʉarã amorreo masã wiorã maa Jordã́ aꞌti pãꞌrẽ peꞌe nirã́ Og, tojo nicã Sehṍrẽ wẽjẽpeꞌocãrã niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Tojo weerã ʉ̃sã pũrõ uise meꞌrã mʉsãrẽ ĩꞌaꞌa. Õꞌacʉ̃, mʉsã wiogʉ nipeꞌtiro ʉꞌmʉsepʉ, aꞌti nucũcãpʉre wiogʉ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Tojo weego mʉsãrẽ sẽrĩꞌi. Õꞌacʉ̃ wãme meꞌrã “Mʉꞌʉ acawererãrẽ añurõ weerãti”, niña. Yʉꞌʉ mʉsãrẽ añurõ weetamuꞌcaronojõta weeya. “Diacjʉ̃ta tojo weerãti” nírã, ");
INSERT INTO tuoNT_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","yʉꞌʉ pacʉsʉmʉarẽ, yʉꞌʉ maꞌmisʉmʉarẽ, yʉꞌʉ acawererã numiarẽ yʉꞌrʉweticã weeya, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Na core aꞌtiro ni yʉꞌticãrã niwã: —Mʉꞌʉ nírõnojõta weerãti. Weeticãma, Õꞌacʉ̃ ʉ̃sãrẽ wẽjẽato. Mʉꞌʉ peꞌe marĩ niꞌcãrõacã ucũsere ne ãpẽrãrẽ wereticãꞌña. Tojo nicã, Õꞌacʉ̃ aꞌti diꞌtare oꞌocãpʉta, ʉ̃sã mʉꞌʉrẽ añurõ wiopesase meꞌrã, añurõ pajañaꞌa, weetamurãsaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Rahab ya wiꞌi, ti macã yeecãꞌmotaꞌaca tʉꞌrʉpʉ wãꞌñacaro niwʉ̃. Tojo weego narẽ ventana sopepʉ pũnʉꞌmo da meꞌrã duꞌudijoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Tojo weetoja, narẽ nico niwõ: —Mʉsãrẽ aꞌmarĩ masã bocari nírã, ʉ̃rʉ̃gʉ̃pʉ waꞌaya. Noꞌo iꞌtia nʉmʉnojõ tojayá. Téé mʉsãrẽ aꞌmarĩ masã macãpʉ dajatojatica beꞌropʉ mʉsã acawererã tiro tojááya, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Co tojo nicã tʉꞌorã, aꞌtiro ni yʉꞌticãrã niwã: —Mʉꞌʉ ʉ̃sãrẽ “Yʉꞌʉre tojo weeapa” níꞌcaronojõta weerãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Ʉ̃sã aꞌti diꞌtare sãjã́ácãrẽ, sõꞌarĩ da pũnʉꞌmo da mʉꞌʉ ʉ̃sãrẽ duꞌudijoca dare ventana sopepʉ yoodijoya tja. Mʉꞌʉ ya wiꞌipʉ mʉꞌʉ pacʉ, mʉꞌʉ paco, mʉꞌʉ maꞌmisʉmʉa, nipeꞌtirã mʉꞌʉ acawererãrẽ neocũuña. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Noꞌo niꞌcʉ̃ cʉ̃ ʉaro wijaamaꞌagʉ̃nojõ cʉ̃ basu cʉ̃rẽ wẽjẽsere buꞌiritigʉsami. Ʉ̃sã buꞌiri moorãsaꞌa. Niꞌcʉ̃ ʉ̃sãnojõ mʉꞌʉ ya wiꞌipʉ nirãrẽ mejẽcã weecã pũrĩcãrẽ, ʉ̃sãta buꞌiritirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Mʉꞌʉ ãpẽrãrẽ werecãma, marĩ ucũꞌque wapamarĩrõsaꞌa, nicãrã niwã Rahare. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","—Jaʉ. Mʉsã nírõnojõta tojota weegosaꞌa, ni yʉꞌtico niwõ. Beꞌro tojo nitojanʉꞌcõ, waꞌa waꞌacãrã niwã. Na waꞌáca beꞌro co na weedutiꞌcaronojõta weeco niwõ. Pũnʉꞌmo da, sõꞌarĩ dare ventana sopepʉ dʉꞌteõꞌodijoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Beꞌro na pʉarã Israe curuacjãrã ĩꞌaduꞌtiri masã ʉ̃rʉ̃gʉ̃pʉ duꞌticãrã niwã. Topʉre iꞌtia nʉmʉ tojacãrã niwã. Narẽ aꞌmarã, surara peꞌe nipeꞌtiropʉ aꞌmacũmí, ne bocaticãrã niwã. Tojo weerã Jericópʉ dajatojaa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Beꞌro ĩꞌaduꞌtiri masã ʉ̃rʉ̃pagʉpʉ níꞌcãrã dijaa, maarẽ pẽꞌaa, téé Josué tiropʉ dajacãrã niwã tja. Topʉ daja, cʉ̃rẽ nipeꞌtise narẽ waꞌaꞌquere werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Aꞌtiro ni werecãrã niwã: “Õꞌacʉ̃ marĩrẽ ‘Nipeꞌtise ti diꞌtare oꞌogʉti’, nitojami. Na masã ti diꞌtapʉ nirã́ marĩrẽ pũrõ uibutiarã weeama”, ni quetiwerecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Ape nʉmʉ peꞌe, boꞌrequeꞌari cura Josué nipeꞌtirã Israe curuacjãrã meꞌrã Sitim wãmetiropʉ níꞌcãrã dia Jordã́pʉ buꞌatacãrã niwã. Na diare pẽꞌati dʉporo ti maa sumutopʉ tojaqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Iꞌtia nʉmʉ yʉꞌrʉ́ca beꞌro surara wiorã, nipeꞌtirã waꞌteropʉre waꞌa weetjĩarã, ");
INSERT INTO tuoNT_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","aꞌtiro duticãrã niwã: “Mʉsã paꞌia, Leví ya curuacjãrã Õꞌacʉ̃ ‘Masã meꞌrã añurõ weegʉti’ níꞌquere cʉori acarore na miacã ĩꞌarã, na siro sirutuya. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Tojo weerã mʉsã waꞌarore masĩrãsaꞌa. Mʉsã ne niꞌcʉ̃ aꞌti maꞌapʉre waꞌañaꞌtisaꞌa. Ti acarore yoacurero, niꞌcã kilómetronojõ sirutuya. Pʉꞌtoacã tuꞌaticãꞌña”, ni werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Tere na wéréca beꞌro Josué aꞌtiro nicʉ niwĩ tja: “Ñamiacã Õꞌacʉ̃ cʉ̃ tutuasere ĩꞌarãsaꞌa. Tojo weerã mʉsã Õꞌacʉ̃ ĩꞌorõpʉ ñaꞌase marĩrã niato nírã, mʉsã ye suꞌtire coe, tojo nicã mʉsã ya upʉre uꞌacoecãꞌña”, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Paꞌia peꞌema aꞌtiro nicʉ niwĩ: “Mʉsã paꞌia Õꞌacʉ̃ ‘Masã meꞌrã añurõ weegʉti’ níꞌquere cʉori acarore wʉa, masã nipeꞌtirã dʉporo maarẽ ʉꞌmʉtãpẽꞌarãsaꞌa.” Tojo weerã cʉ̃ dutiꞌcaronojõta ti acarore wʉa, masã dʉporo ʉꞌmʉtãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Beꞌro Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: “Niꞌcãcã meꞌrã nipeꞌtirã Israe curuacjãrãrẽ mʉꞌʉrẽ ãpẽrã yʉꞌrʉoro añurõ ĩꞌacã weenʉꞌcãgʉ̃ti. Tojo weerã Moisé meꞌrã níꞌcaronojõta yʉꞌʉ mʉꞌʉ meꞌrã nisere masĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Paꞌia yʉꞌʉ ‘Masã meꞌrã añurõ weegʉti’ cʉori acarore miarãrẽ aꞌtiro ni wereya: ‘Mʉsã dia Jordã́ sumutore etarã, ti maapʉre ñumuwija, tojanʉꞌcãña’ ”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Beꞌro Josué masãrẽ pijio, nicʉ niwĩ: “Tʉꞌorã aꞌtia marĩrẽ Õꞌacʉ̃ nisere. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Aꞌtiro weemasĩrãsaꞌa ‘Õꞌacʉ̃ catigʉ marĩ meꞌrã ninuꞌcũmi’ nisere. Tojo nicã aꞌti diꞌtacjãrã cananeo masã, hitita masã, heveo masã, ferezeo masã, gergeseo masã, amorreo masã, jebuseo masãrẽ cõꞌapeꞌowãꞌcãgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ĩꞌaña. Õꞌacʉ̃, nipeꞌtise diꞌta wiogʉ ya acarore mʉsã dʉporo dia Jordã́rẽ pẽꞌamʉꞌtãrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Tojo weerã mʉsã Israe curuacjãrã doce curari nirã́, te curarinʉcʉ̃ niꞌcʉ̃rẽ beseya. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Aꞌtiro waꞌarosaꞌa. Na paꞌia Õꞌacʉ̃ nipeꞌtise diꞌta wiogʉ ya acarore miarã, na diapʉ ñumuwijacã, te aco dʉcawatia waꞌarosaꞌa. Te aco nimiꞌque oꞌmabʉrosome. Pʉaperipʉta opa ditara weronojõ nicãꞌrõsaꞌa”, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Tojo weerã Israe curuacjãrã dia Jordã́rẽ pẽꞌarã, na cãrĩꞌque uꞌturire wijacãrã niwã. Paꞌia Õꞌacʉ̃ “Masã meꞌrã añurõ weegʉti” níꞌquere cʉori acarore na dʉporo miamʉꞌtãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Titare masã otese dʉcatiri cura dia Jordã́ pajiro puꞌeeja, mirĩa waꞌacaro niwʉ̃. Tojo nimicã, paꞌia ti acarore miarã, Jordã́pʉ na dʉꞌpocãrĩ ti maarẽ ʉꞌtacũucãta, ");
INSERT INTO tuoNT_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","te aco buꞌipʉ bʉrʉtiꞌque tojanʉꞌcãcaro niwʉ̃. Yoaropʉ niꞌcã macã Adã́ wãmetiri macãpʉ opa ditara biꞌa cãꞌmotaꞌaꞌro weronojõ waꞌacaro niwʉ̃. Adã́ Saretán wãmetiro pʉꞌtopʉ tojacaro niwʉ̃. Aco tosiropʉ tojaꞌque peꞌe Oꞌmabʉrotiri ditarapʉ wetibʉrʉdijacaro niwʉ̃. Tojo waꞌacã, na Israe curuacjãrã Jericó põtẽorõ pẽꞌacãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Na pẽꞌarĩ cura paꞌia Õꞌacʉ̃ ya acarore cʉorã peꞌe dia deco boporopʉ nʉꞌcãejacãꞌcãrã niwã. Téé nipeꞌtirã Israe curuacjãrã pẽꞌapeꞌtica beꞌropʉ pẽꞌacãrã niwã. Nipeꞌtirã Israe curuacjãrã boporopʉ pẽꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Nipeꞌtirã dia Jordã́rẽ pẽꞌatáca beꞌro Õꞌacʉ̃ Josuére nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Israe curuacjãrãrẽ te doce curarinʉcʉ̃ niꞌcʉ̃rẽ beseya. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Narẽ waꞌaduti weetjĩagʉ̃, paꞌia dia deco na nuꞌcũrõ tiropʉ docepaga ʉ̃tãpagare miicũudutiya. Mʉsã niꞌcãcã ñami cãrĩatjopʉ tepagare cũuña.” ");
INSERT INTO tuoNT_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Tojo weegʉ Josué doce ʉmʉarẽ cʉ̃ beseꞌcãrãrẽ pijio, ");
INSERT INTO tuoNT_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","narẽ nicʉ niwĩ: “Mʉsã Jordã́ decopʉ, Õꞌacʉ̃ mʉsã wiogʉ ya acaro tiropʉ waꞌa, mʉsãnʉcʉ̃ ʉ̃tãpaga niꞌcãrẽpaga wʉarã waꞌaya. Tojo weerã mʉsã docepaga cʉorãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Te tojo weesere mʉsã põꞌrã masãbajuarãpʉ, ‘Aꞌtepaga ¿deꞌro nisĩꞌrĩrõ weeti?’ nicã, mʉsã aꞌtiro ni yʉꞌtirãsaꞌa: ");
INSERT INTO tuoNT_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","‘Ʉ̃sã Õꞌacʉ̃ ya acarore dia Jordã́rẽ miipẽꞌacã, ne aco marĩrĩ maa waꞌawʉ. Aꞌtepaga Israe curuacjãrã doce curari ti maa Jordã́rẽ pẽꞌawʉ̃’, nisĩꞌrĩrõ weeꞌe, ni wereapa mʉsã põꞌrãrẽ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Tojo weerã na Josué cʉ̃ weedutiꞌquere queoro weecãrã niwã. Na ʉ̃tãpaga docepaga Jordã́ decopʉ níꞌquepagare miiwʉacãrã niwã. Israe curuacjãrã te curarinʉcʉ̃ niꞌcʉ̃ niꞌcãrẽpaga miacãrã niwã. Õꞌacʉ̃ Josuére níꞌcaronojõta na cãrĩrõpʉ tepagare mia, cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Apeyere tja Josué ti maa decopʉ paꞌia na Õꞌacʉ̃ ya acarore wʉanuꞌcũꞌcaropʉre apeyepaga docepaga cũucʉ niwĩ. Tepaga topʉ nidecotiꞌi yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Téé nipeꞌtise Õꞌacʉ̃ Josuére dutiꞌquere weepeꞌóca beꞌro, paꞌia ti maa decopʉ ti acarore wʉanuꞌcũcãrã niwã yujupʉ. Moisé Josuére weedutiꞌcaronojõta queoro weecãrã niwã. Masã peꞌe sojaro meꞌrã ti maarẽ pẽꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Nipeꞌtirã masã na pẽꞌaejanʉꞌcãca beꞌro paꞌia Õꞌacʉ̃ “Masã meꞌrã tojo weegʉti” níꞌquere cʉori acaro meꞌrã pẽꞌa, masã dʉporo nʉꞌcãejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Ʉmʉa Rubén ya curuacjãrã, Gad ya curuacjãrã, tojo nicã deco meꞌrã Manasés ya curuacjãrã na wãmo meꞌrã ãpẽrã Israe curuacjãrã dʉporo pẽꞌamʉꞌtãcãrã niwã. Tojo weerã Moisé cʉ̃ dutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Pãjãrã cuarenta mil aꞌmewẽjẽrĩ masã añurõ wãmotirã nʉꞌcãejabʉrocãrã niwã. Jericó opa paꞌtiro nirõpʉ waꞌa, aꞌmewẽjẽrãtirã apoyucãrã niwã. Ti acaro topʉ niyucã, Õꞌacʉ̃ na meꞌrã nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Na tojo weeri nʉmʉrẽta nipeꞌtirã Israe curuacjãrã ĩꞌorõpʉ Õꞌacʉ̃ Josuére ãpẽrã yʉꞌrʉoro tojacã weecʉ niwĩ. Cʉ̃ catiri ʉmʉcore nipeꞌtirã masã Josuére wiopesase meꞌrã ĩꞌacãrã niwã. Moisére weeꞌcaronojõta cʉ̃ meꞌrã quẽꞌrãrẽ mejãrõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Tuꞌajanʉꞌcõ, Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Paꞌia, Õꞌacʉ̃ masã meꞌrã ‘Tojo weegʉti’ níꞌquere cʉori acarore cʉorãrẽ ti maa Jordã́pʉ nirãrẽ majãtidutiya.” ");
INSERT INTO tuoNT_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Tere tʉꞌogʉ, Josué paꞌiare “Majãtia”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Na cʉ̃ dutironojõta paꞌia Õꞌacʉ̃ ya acarore miimajãcãrã niwã. Nipeꞌtirã masã, paꞌia ti acaro meꞌrã pẽꞌáca beꞌro ti maa ne waropʉ níꞌcaronojõta oꞌmabʉrocaro niwʉ̃ tja. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Ʉꞌmʉtãrĩ mujĩpũrẽ, diez nʉmʉrĩ nirĩ nʉmʉrẽ, Israe curuacjãrã Jordã́pʉ níꞌcãrã majãa, Gilgal wãmetiropʉ cãrĩrã waꞌacãrã niwã. Gilgal, Jericó macã mujĩpũ mʉjãtiro peꞌe nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Gilgapʉ Josué ʉ̃tãpagare docepaga Jordã́pʉ miiꞌquepagare cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Josué Israe curuacjãrãrẽ aꞌtiro nicʉ niwĩ: “Beꞌropʉ mʉsã pãrãmerã nituriarã na pacʉsʉmʉarẽ ‘¿Aꞌtepaga deꞌro nisĩꞌrĩrõ weeti?’ nicã, ");
INSERT INTO tuoNT_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","narẽ wereya: ‘Israe curuacjãrã dia Jordã́rẽ pẽꞌarã, aco dʉcawaanʉꞌcõ, bopori maꞌapʉ pẽꞌawã’, nisĩꞌrĩrõ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Õꞌacʉ̃ marĩ wiogʉ dia Jordã́rẽ maꞌa bopori maꞌa weewĩ. Téé ʉ̃sã pẽꞌapeꞌtíca beꞌropʉ tojo weeduꞌuwĩ. Õꞌacʉ̃ marĩ wiogʉ dʉporopʉ Maa sõꞌarĩ maarẽ weeꞌcaronojõta weewĩ. Ʉ̃sã ti maarẽ pẽꞌapeꞌtíca beꞌropʉ tojo bopori maꞌa weewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Nipeꞌtirocjãrã Õꞌacʉ̃ cʉ̃ tutuasere masĩato nígʉ̃, tojo nicã mʉsã Õꞌacʉ̃ marĩ wiogʉre wiopesase meꞌrã wãcũnuꞌcũcãꞌto nígʉ̃, tojo weewĩ”, ni wereya, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Aꞌtiro wee Õꞌacʉ̃ dia Jordã́rẽ Israe curuacjãrãrẽ pẽꞌato nígʉ̃, boposãjãcã weecʉ niwĩ. Tere tʉꞌorã, nipeꞌtirã amorreo masã wiorã dia Jordã́ mujĩpũ sãjãrõ peꞌe nirã́ pũrõ ui, ʉcʉacãrã niwã. Tojo nicã, mejãrõta cananeo masã wiorã dia Mediterráneo sumutopʉ nirã́ uicãrã niwã. Tojo weerã “Na meꞌrã aꞌmewẽjẽrõʉaꞌa” ni, ne wãcũticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Titare Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: “Mʉsã ʉ̃tãperi meꞌrã yejese pjĩrĩrẽ daꞌreya. Tuꞌajanʉꞌcõ, mʉsã todʉporopʉ weeꞌcaronojõta weeya tja. Mʉsã Israe curuacjãrã ʉmʉarẽ õꞌrẽcjʉ yapa caserore yejecõꞌaña”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Tere tʉꞌogʉ, Josué cʉ̃ yejecõꞌatje pjĩrĩrẽ daꞌrecʉ niwĩ. Te meꞌrã Israe curuacjãrã ʉmʉarẽ Aralot wãmetiro opa buꞌpa nirõpʉ na õꞌrẽcjʉ yapa caserore yejecõꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Nipeꞌtirã ʉmʉa Egiptopʉ wijaꞌcãrã, surara sãjãrĩ cʉ̃ꞌmanojõ cʉorã yucʉ marĩrõpʉ wẽrĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Na nipeꞌtirãpʉta na õꞌrẽcjʉ yapa caserore yejecõꞌanoꞌcãrã nicãrã niwã. Egiptopʉ wijaꞌcãrã pũrĩcã yucʉ marĩrõpʉ bajuaꞌcãrã yejecõꞌanoꞌña marĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Õꞌacʉ̃ na ñecʉ̃sʉmʉarẽ “Mʉsã pãrãmerã nituriarãpʉre añuse diꞌtare oꞌogʉti”, nicʉ niwĩ. Te diꞌta añuse diꞌta nujãtuꞌque, apeye otese pĩꞌrĩse diꞌta nirõsaꞌa. Tojo nimicã, ʉmʉa surara sãjãrĩ cʉ̃ꞌmanojõ cʉorã Egiptopʉ wijaꞌcãrã peꞌe Õꞌacʉ̃ dutisere queoro weeticãrã niwã. Na tojo ñaꞌarõ weese buꞌiri Õꞌacʉ̃ “Diacjʉ̃ta na te diꞌtare ĩꞌasome”, ni ucũcʉ niwĩ. Tojo weerã na yucʉ marĩrõpʉ cuarenta cʉ̃ꞌmarĩ sijabaqueꞌaticãrã niwã. Téé na ʉmʉa wẽrĩpeꞌticãpʉ topʉre sijaduꞌucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Na wẽrĩꞌcãrã põꞌrãrẽ Õꞌacʉ̃ narẽ põꞌrãti, dʉcayuꞌcãrãrẽ õꞌrẽcjʉ yapa caserore Josué yejecõꞌacʉ niwĩ. Na sijari curare yejecõꞌanoꞌña marĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Na nipeꞌtirã yejecõꞌanoꞌca beꞌro na wiꞌseriacãpʉ te cãmirẽ sijorã, nicãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Beꞌro Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: “Niꞌcãcã meꞌrã Egiptocjãrã dutise doca mʉsã bopoyoro níꞌquere wijataꞌacã weeꞌe.” Cʉ̃ tojo wééca beꞌro niyucã, to Gilgal wãmetisaꞌa. Aꞌtiro nicãpʉ quẽꞌrãrẽ mejãrõta wãmetisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Israe curuacjãrã Gilgapʉ queꞌajácãrã niwã. Nimʉꞌtãrĩ mujĩpũ pʉa semana beꞌro opa paꞌtiro nirṍ Jericó põtẽorõpʉ mujĩpũ sãjãrĩ cura Õꞌacʉ̃ yʉꞌrʉari bosenʉmʉrẽ bosebaꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ape nʉmʉ peꞌe Canaá diꞌta cjase cebada ʉ̃tẽꞌque, tojo nicã pã́ bʉcʉase marĩrõ baꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ti nʉmʉ meꞌrã Õꞌacʉ̃ narẽ manárẽ tocãꞌrõta bʉrʉcã weetʉocʉ niwĩ. Ti cʉ̃ꞌmarẽ ti diꞌta cjasere baꞌacãrã niwã majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Niꞌcã nʉmʉ Josué Jericó pʉꞌto nígʉ̃, cʉ̃ diacjʉ̃ niꞌcʉ̃ masʉ̃ diꞌpjĩ ñosẽrĩ pjĩ meꞌrã sĩ́oejanʉꞌcãcã ĩꞌacʉ niwĩ. Josué cʉ̃ tiro waꞌa, sẽrĩtiñaꞌcʉ niwĩ: —¿Mʉꞌʉ ʉ̃sã meꞌrãcjʉ̃ niti? ¿Niwetine? ¿Ʉ̃sãrẽ ĩꞌatuꞌtirã meꞌrãcjʉ̃ niti? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Cʉ̃ yʉꞌticʉ niwĩ: —Ne niweꞌe. Yʉꞌʉ Õꞌacʉ̃ yarã surara wiogʉ mʉsã tiropʉ aꞌtiapʉ, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌogʉ, Josué ẽjõpeose meꞌrã nucũcãpʉ paamuꞌrĩqueꞌacʉ niwĩ. —Wiogʉ, yʉꞌʉ, mʉꞌʉrẽ daꞌracoꞌtegʉ, ¿deꞌro weecã ʉasari? ni sẽrĩtiñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Õꞌacʉ̃ yarã surara wiogʉ cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ sapature tuweeya. Mʉꞌʉ nuꞌcũrõ Õꞌacʉ̃ nirṍ niꞌi, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌogʉ, Josué cʉ̃ dutiꞌcaronojõta cʉ̃ sapature tuweecũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Jericócjãrã Israe curuacjãrãrẽ pũrõ uicãrã niwã. Israe curuacjãrã sãjãrĩ nírã, ti macã cjase soperire añurõ biꞌapeꞌocãꞌcãrã niwã. Tojo weerã ti macãrẽ ne niꞌcʉ̃ sãjãti, ne wijaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Na tojo weemicã, Õꞌacʉ̃ Josuére aꞌtiro ni werecʉ niwĩ: “Yʉꞌʉ mʉꞌʉrẽ Jericóre, tocjʉ̃ wiogʉre, tojo nicã tocjãrã surarare wiatojapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Tojo weerã mʉsã Israe curuacjãrã surara ʉmʉa wãmotirã aꞌtiro weerãsaꞌa. Mʉsã seis nʉmʉrĩ ti macãrẽ sʉtʉarãsaꞌa. Niꞌcã nʉmʉrẽ niꞌcãrẽtirita sʉtʉaya. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ya acaro dʉporo siete paꞌia ʉꞌmʉtãrãsama. Nanʉcʉ̃ oveja ʉmʉa na putise capesaꞌrire cʉorãsama. Seis nʉmʉrĩ peꞌtíca beꞌro ape nʉmʉ peꞌe ti macãrẽ sietetiri sʉtʉarãsaꞌa majã. Mʉsã sʉtʉari cura paꞌia oveja ʉmʉa capesaꞌrire putirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Na ʉpʉtʉ puticã tʉꞌorã, mʉsã caricũrõ põtẽorõ caricũña. Mʉsã tojo caricũcã, ti macã cjase ʉ̃tã tʉꞌrʉri seꞌtedija peꞌtia waꞌarosaꞌa. Tojo waꞌari cura mʉsã maata ti macãpʉ sãjã́árãsaꞌa.” ");
INSERT INTO tuoNT_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Tojo wee Josué paꞌiare pijio, aꞌtiro ni werecʉ niwĩ: “Mʉsã Õꞌacʉ̃ ya acarore miiwãꞌcãña. Siete paꞌia ti acaro dʉporo oveja ʉmʉa capesaꞌri na putiatje meꞌrã waꞌayuato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Surara peꞌere aꞌtiro nicʉ niwĩ: “Waꞌaya. Ti macãrẽ beꞌtoanʉꞌcãña. Surara wãmotirã Õꞌacʉ̃ ya acaro dʉporo waꞌamʉꞌtãto”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Nipeꞌtirã Josué dutiꞌcaronojõta weecãrã niwã. Tojo weerã siete paꞌia ti acaro dʉporo capesaꞌrire putimʉꞌtãwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Aꞌmewẽjẽrĩ masã surara peꞌe paꞌia dʉporo ʉꞌmʉtãcãrã niwã. Ãpẽrã surara ti acaro siro peꞌe sirutucãrã niwã. Duꞌucũro marĩrõ paꞌia oveja capesaꞌrire putiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Surara peꞌere Josué “Diꞌtamarĩrõ waꞌaya. Yʉꞌʉ caricũduticãpʉ, mʉsã tutuaro põtẽorõ caricũrãsaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Josué paꞌiare ti acaro meꞌrã macãrẽ niꞌcãti sʉtʉabaqueꞌaduticʉ niwĩ. Tojo weetojanʉꞌcõ, na cãrĩꞌcaropʉta daja, naꞌitõꞌo, cãrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Ape nʉmʉ ñamiñaꞌcũrõ Josué wãꞌcã, cʉ̃ dutiꞌcaronojõta paꞌiare, surarare mejãrõta duticʉ niwĩ tja. Tojo weerã paꞌia Õꞌacʉ̃ ya acarore miiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Na siete paꞌia ti acaro dʉporo sooro marĩrõ waꞌa, na putisere putisʉtʉacãrã niwã. Aꞌmewẽjẽrĩ masã surara peꞌe na dʉporo waꞌacãrã niwã. Ãpẽrã surara ti acaro siro peꞌe sirutucãrã niwã. Na sʉtʉari cura paꞌia ne putiduꞌuticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Tojo weerã nimʉꞌtãrĩ nʉmʉ beꞌro cja nʉmʉrẽ apaturi ti macãrẽ sʉtʉanemocãrã niwã. Tojo sʉtʉatojanʉꞌcõ, dajacãrã niwã na cãrĩꞌcaropʉre tja. Seis nʉmʉrĩ mejãrõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Beꞌro ape nʉmʉ siete nʉmʉrĩ nirĩ nʉmʉrẽ, ñamiñaꞌcũrõ wãꞌcã, na weeꞌcaronojõta ti macã Jericóre sʉtʉacãrã niwã tja. Ti nʉmʉrẽ majã sietetiri sʉtʉacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Na sʉtʉatʉocã, paꞌia pũrõ puticã tʉꞌogʉ, Josué masãrẽ nicʉ niwĩ: “Pũrõ caricũña. Õꞌacʉ̃ marĩrẽ aꞌti macãrẽ oꞌotojami. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta ti macã nipeꞌtise to nise meꞌrã cõꞌanoꞌrõsaꞌa. Rahab, ʉmʉa meꞌrã aꞌmetãrãwapataꞌari masõ, tojo nicã co ya wiꞌipʉ nirã́ diaꞌcʉ̃rẽ yʉꞌrʉonoꞌrõsaꞌa. Cóta marĩ ĩꞌaduꞌtirã oꞌoꞌcãrãrẽ nʉoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Mʉsã Õꞌacʉ̃ cʉ̃ cõꞌadutiꞌque to nisere ne miaticãꞌña. Mʉsã tojo weecãma, mʉsã ye buꞌiri Õꞌacʉ̃ Israe curuacjãrãrẽ ñaꞌabutiaro waꞌacã weebosami. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Nipeꞌtise ti macã cjase uru, plata, bronce, cõme meꞌrã weeꞌquea Õꞌacʉ̃ ye diaꞌcʉ̃ niꞌi. Õꞌacʉ̃ ya wiꞌi cjase nʉrõrõpʉ miicũunoꞌrõsaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Paꞌia capesaꞌri meꞌrã puticãrã niwã. Tojo bʉsʉcã tʉꞌorã, masã niꞌcãrõ meꞌrã ʉpʉtʉ caricũcãrã niwã. Na tojo caricũcã, ti macã ʉ̃tã tʉꞌrʉ, na yee cãꞌmotaꞌamiꞌque seꞌtemadija waꞌacaro niwʉ̃. Tojo waꞌacã ĩꞌarã, surara ti macãrẽ diacjʉ̃ta omasãjã, miiwapa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Beꞌro ti macãcjãrã ʉmʉarẽ, numiarẽ, maꞌmapjiare, bʉcʉrãrẽ, na yarã ecarã meꞌrãta wẽjẽcõꞌacãꞌcãrã niwã. Nipeꞌtirãrẽ wẽjẽpeꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Josué pʉarã ʉmʉa todʉporo ti macãrẽ ĩꞌaduꞌtiꞌcãrãrẽ nicʉ niwĩ: “Mʉsã ʉmʉa meꞌrã aꞌmetãrãwapataꞌari masõ ya wiꞌipʉ waꞌa, core, co acawererãrẽ, na ye nipeꞌtise meꞌrã miiwĩrõrã waꞌaya. Mʉsã core ‘Tojo weerãti’ níꞌcaronojõta weeya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Cʉ̃ tojo nisere tʉꞌo, ĩꞌaduꞌtiri masã Rahare, co pacʉsʉmʉarẽ, co acawererãrẽ miirã waꞌacãrã niwã. Narẽ Israe curuacjãrã nirṍ yʉꞌrʉropʉ cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Beꞌro narẽ miiwĩrṍca beꞌro ti macã Jericóre ʉ̃jʉ̃acõꞌacãꞌcãrã niwã. Plata, uru, bronce, cõme meꞌrã weeꞌque peꞌere Õacʉ̃ wiꞌi cjasere nʉrõrõpʉ cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Josué Rahab, co acawererã diaꞌcʉ̃rẽ wẽjẽticʉ niwĩ. Cóta Jericóre ĩꞌaduꞌtiri masã Josué oꞌóꞌcãrãrẽ nʉoco niwõ. Co narẽ weetamuꞌque meꞌrã yʉꞌrʉwetico niwõ. Tojo weerã Rahab, co acawererã Israe curuacjãrã meꞌrã nisetidecotima yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Beꞌro Josué “Ne apaturi aꞌti macãrẽ weeapoticãꞌto” nígʉ̃, aꞌtiro nicʉ niwĩ: “Noꞌo niꞌcʉ̃ aꞌti macãrẽ weeaposĩꞌrĩgʉ̃nojõrẽ Õꞌacʉ̃ cʉ̃rẽ ñaꞌarõ waꞌacã weegʉsami. Cʉ̃ maꞌma macã weenʉꞌcãrĩ cura cʉ̃ macʉ̃ masã maꞌmi wẽrĩgʉ̃sami. Ti macã yeeꞌque tʉꞌrʉri cjase soperire õꞌorĩ cura cʉ̃ macʉ̃ dʉꞌsagʉ peꞌe wẽrĩgʉ̃sami tja”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Õꞌacʉ̃ Josuére weetamunuꞌcũcʉ niwĩ. Tojo weerã ti diꞌtacjãrã cʉ̃ añurõ weesetisere masĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Israe curuacjãrã waꞌteropʉre niꞌcʉ̃ Acã́ wãmetigʉ Jericó cjasere Õꞌacʉ̃ cʉ̃ miadutitiꞌquere miacʉ niwĩ. Cʉ̃ Judá ya curuacjʉ̃, Carmi macʉ̃, Zabdi pãrãmi, Zera pãrãmi nituriagʉ nicʉ niwĩ. Cʉ̃ Õꞌacʉ̃ cõꞌadutiꞌquere miiꞌque buꞌiri nipeꞌtirã Israe curuacjãrã meꞌrã Õꞌacʉ̃ pũrõ uacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Josué niꞌcãrẽrã surarare ape macã Hai wãmetiri macãpʉ oꞌócʉ niwĩ. Ti macã Betel mujĩpũ mʉjãtiro peꞌe, Bet-aven pʉꞌtopʉ tojacaro niwʉ̃. Narẽ oꞌógʉ, “Ti macãrẽ, tojo nicã to sumutopʉre ĩꞌaduꞌtirã waꞌaya”, nicʉ niwĩ. Tojo weerã na ti macãrẽ ĩꞌaduꞌtirã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Dajarã, Josuére werecãrã niwã: “Haipʉre pejetirãcã ʉmʉa niama. Tojo weerã nipeꞌtirã surara ti macãcjãrã meꞌrã aꞌmewẽjẽrã waꞌaticãꞌto. Pʉati mil, o iꞌtiati mil surara ticʉrãta waꞌacã añurõsaꞌa. Na meꞌrã ti macãcjãrãrẽ docaqueꞌacã weerãsama. Tojo weegʉ nipeꞌtirã surarare oꞌóticãꞌña”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Tojo weerã iꞌtiati mil surara diaꞌcʉ̃ aꞌmewẽjẽrã waꞌacãrã niwã. Haicjãrã peꞌe narẽ docaqueꞌacã weecãrã niwã. Tojo nicã, narẽ ui, duꞌtiwãꞌcãcã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Israe curuacjãrãrẽ omasirutu wẽjẽcãrã niwã. Treinta y seis surara wẽjẽnoꞌcãrã niwã. Macã sãjãrĩ sope pʉꞌto, téé diꞌta seꞌteꞌcaro nitʉoropʉ narẽ sirutu wẽjẽcãꞌcãrã niwã. Tojo weerã Israe curuacjãrã bʉjaweti, ui wãcũtutuaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Josué, cʉ̃ bʉjawetisere ĩꞌogʉ̃, cʉ̃ sãñase suꞌtire wejetʉ̃ꞌrẽcʉ niwĩ. Téé naꞌiqueꞌari curapʉ, Õꞌacʉ̃ ya acaro tiropʉ paamuꞌrĩqueꞌacʉ niwĩ. Bʉcʉrã quẽꞌrã mejãrõta weecãrã niwã. Tojo nicã na dʉpopapʉre diꞌtare ṍrẽ́peocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Tojo wee Josué Õꞌacʉ̃rẽ nicʉ niwĩ: —Õꞌacʉ̃, ¿deꞌro weegʉ mʉꞌʉ ʉ̃sãrẽ dia Jordã́rẽ miipẽꞌrõrĩ? Mʉꞌʉ amorreo masã ʉ̃sãrẽ wẽjẽcõꞌato nígʉ̃, ¿tojo weerine? Ʉ̃sã ti maa ape pãꞌrẽpʉ tojacã añuyʉꞌrʉabopã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Wiogʉ, Israe curuacjãrã surara ʉ̃sãrẽ ĩꞌatuꞌtirãrẽ uirã, omamʉꞌtãma. Na tojo weecã ĩꞌagʉ̃, yʉꞌʉ ¿deꞌro ni werebosari narẽ? ");
INSERT INTO tuoNT_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Cananeo masã, ãpẽrã aꞌti diꞌtacjãrã ʉ̃sãrẽ tojo waꞌaꞌquere tʉꞌopeꞌticãꞌrãsama. Ʉ̃sã nipeꞌtirãrẽ wẽjẽrãsama. Ne niꞌcʉ̃ ʉ̃sã waꞌteropʉre tojasome. To pũrĩcãrẽ Õꞌacʉ̃, nipeꞌtirã aꞌti diꞌtacjãrã mʉꞌʉrẽ ñaꞌarõ wãcũrãsama, tojo nicã mʉꞌʉ wãmerẽ, nicʉ niwĩ Josué Õꞌacʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Cʉ̃ tojo nisere tʉꞌogʉ, Õꞌacʉ̃ Josuére yʉꞌticʉ niwĩ: —Wãꞌcãnʉꞌcãña. ¿Deꞌro weegʉ mʉꞌʉ nucũcãpʉ paamuꞌrĩqueꞌati? ");
INSERT INTO tuoNT_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Israe curuacjãrã yʉꞌʉ dutisere yʉꞌrʉnʉꞌcãma. Yʉꞌʉ mʉsãrẽ “Weeticãꞌña” níꞌquere queoro weetiama. Yʉꞌʉ Jericó cjasere, yʉꞌʉ miidutitiꞌquere miama. “Ñaꞌa niꞌi”, ni masĩmirã, yajama. Tere miitoja, na ye apeyenojõ waꞌteropʉ nʉoama. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Tojo weerã Israe curuacjãrã na tojo weeꞌque wapa narẽ ĩꞌatuꞌtirãrẽ põtẽosome. Narẽ põtẽonʉꞌcã, aꞌmewẽjẽrõnojõ oꞌorã, mejõ peꞌe narẽ uiwãꞌcãrãsama. Na basu buꞌiri daꞌrenoꞌrãsama. Mʉsã yʉꞌʉ “Miaticãꞌña” níꞌquere maata cõꞌaticãma, ne mʉsã meꞌrã ninemosome majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Masãrẽ neocũu, narẽ weregʉ waꞌaya: “Õꞌacʉ̃ mʉsãrẽ aꞌtiro niami: ‘Mʉsã Israe curuacjãrã, yʉꞌʉ mʉsãrẽ “Miaticãꞌña” níꞌque mʉsã waꞌteropʉ niꞌi. Mʉsã tere cõꞌapeꞌoticãma, ne mʉsã meꞌrã aꞌmewẽjẽrãrẽ docaqueꞌacã weesome. Ñamiacãrẽ yʉꞌʉ ĩꞌorõpʉ nuꞌcũrãsaꞌa. Tojo weerã yʉꞌʉ ĩꞌorõpʉ ñaꞌase marĩrã niato nírã, mʉsã ye suꞌtire coe, mʉsã ya upʉre uꞌacoecãꞌña. Apoyuꞌcãrãpʉ nitojaya. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Yʉꞌʉ ĩꞌorõpʉ nipeꞌtirã mʉsã ye curarinʉcʉ̃ bajuyoropʉ ejanʉꞌcãña. Yʉꞌʉ beseri cura nipeꞌtise nisirutuse curarire besewéénoꞌrõsaꞌa. Nisiruturi curua yʉꞌʉ beséca curua niꞌcʉ̃ põꞌrã nise curari besewéénoꞌrõsaꞌa. Niꞌcʉ̃ põꞌrã yʉꞌʉ beséca curua na ʉmʉarẽ besenoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Yʉꞌʉ “Miaticãꞌña” níꞌquere cʉogʉ cʉ̃ acawererã meꞌrã, tojo nicã cʉ̃ cʉose nipeꞌtise meꞌrã ʉ̃jʉ̃acõꞌanoꞌgʉ̃sami. Cʉ̃ Israe curuacjãrãrẽ bopoyoro weeꞌque buꞌiri, tojo nicã yʉꞌʉ “Aꞌtiro weeya” níꞌquere yʉꞌrʉnʉꞌcãꞌque buꞌiri ʉ̃jʉ̃acõꞌanoꞌgʉ̃sami’ ”, nicʉ niwĩ Õꞌacʉ̃ Josuére. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Ape nʉmʉ ñamiñaꞌcũrõ Josué masãrẽ te curarinʉcʉ̃ wijatiduticʉ niwĩ. Tojo weeri curare Õꞌacʉ̃ Judá ya curuacjãrãrẽ ĩꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Beꞌro Josué ti curuacjãrãrẽ nisirutuse curarire wijatiduticʉ niwĩ. Õꞌacʉ̃ Zera ya curuare ĩꞌocʉ niwĩ. Ti curua waꞌterore Zabdi acawererãrẽ besecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Zabdi acawererã ʉmʉarẽ ĩꞌobʉrocã, Acã́ wãmetigʉ besenoꞌcʉ niwĩ. Acã́ Carmi macʉ̃, Zabdi pãrãmi, Zera pãrãmi nituriagʉ, Judá ya curuacjʉ̃ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Tojo weegʉ Josué cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ yʉꞌʉ macʉ̃ weronojõ nigʉ̃́ niꞌi. Õꞌacʉ̃, Israe curuacjãrã wiogʉre eꞌcatipeoya. Mʉꞌʉ weeꞌquere diacjʉ̃ wereya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Acã́ cʉ̃rẽ yʉꞌticʉ niwĩ: —Diacjʉ̃ta mʉꞌʉrẽ wereꞌe. Israe curuacjãrã wiogʉ Õꞌacʉ̃rẽ yʉꞌrʉnʉꞌcãwʉ̃. Aꞌtiro weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Jericó cjase marĩ miiꞌque waꞌteropʉ niꞌcãrõ suꞌtiro añubutiaro Babiloniacjãrã wééca suꞌtirore ĩꞌawʉ̃. Tojo nicã plata cujiri doscientos cujiri, niꞌcãgʉ̃ uru meꞌrã weeꞌcʉre, niꞌcã kilo deco nʉcʉ̃cjʉre ʉaripeja, miicãꞌwʉ̃. Ya wiꞌi suꞌti caseri meꞌrã wééca wiꞌi poꞌpeapʉ yaacãꞌwʉ̃. Niyeru apeye docapʉ niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Cʉ̃ tojo nicã tʉꞌogʉ, Josué ãpẽrãrẽ Acã́ ya wiꞌipʉ waꞌaduticʉ niwĩ. Cʉ̃ ya wiꞌipʉ Acã́ mííca suꞌtirore, niyerure, urugʉre bocacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Tere míí, Josuére, tojo nicã Israe curuacjãrãrẽ wiacãrã niwã. Õꞌacʉ̃ “Masã meꞌrã añurõ weegʉti” níꞌquere cʉori acaro põtẽorõpʉ cũucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Beꞌro Josué, Israe curuacjãrã meꞌrã Acã́, Zera macʉ̃rẽ, niyeru cʉ̃ yajaꞌquere, suꞌtirore, urure, cʉ̃ põꞌrã ʉmʉarẽ, numiarẽ, cʉ̃ yarã ecarã wecʉare, burroare, ovejare, tojo nicã cʉ̃ ya wiꞌi suꞌti caseri meꞌrã wééca wiꞌire, nipeꞌtise cʉ̃ cʉosere na cãrĩrõ yʉꞌrʉro Acor wãmetiro paꞌtiropʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Josué cʉ̃rẽ nicʉ niwĩ: —¿Deꞌro weegʉ mʉꞌʉ marĩrẽ aꞌte bopoyoro buꞌiri daꞌreatjere weeati? Niꞌcãrõacã Õꞌacʉ̃ mʉꞌʉrẽ buꞌiri daꞌregʉsami, nicʉ niwĩ. Tojo nitoja, nipeꞌtirã Israe curuacjãrã ʉ̃tãperi meꞌrã cʉ̃rẽ, cʉ̃ yarã ecarãrẽ doquewẽjẽcãrã niwã. Beꞌro narẽ ʉ̃jʉ̃acõꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Na buꞌipʉ Josué ʉ̃tã mesãjo seepeocʉ niwĩ. Te meꞌrã Õꞌacʉ̃ na meꞌrã uaꞌque peꞌtia waꞌacaro niwʉ̃. Tojo weero ti paꞌtiro Acor wãmetidecotisaꞌa yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Tojo wééca beꞌro Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: “Ne uiticãꞌña. Wãcũtutuaya. Mʉꞌʉ yarã surara nipeꞌtirãrẽ neocũu, Haicjãrã meꞌrã aꞌmewẽjẽrã waꞌaya tja. Yʉꞌʉ Haicjãrã wiogʉre, tojo nicã ti macãcjãrãrẽ mʉsãrẽ wapataꞌacã weetamugʉ̃ti. Cʉ̃ ya macã, na ya diꞌta nimiꞌcaro mʉsã ye tojarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Mʉꞌʉ Jericócjʉ̃ wiogʉre, ti macãcjãrãrẽ weeꞌcaronojõta Haicjãrãrẽ, na wiogʉ quẽꞌrãrẽ weegʉsaꞌa tja. Niꞌcãrõacãma na cʉose, na yarã ecarã mʉsã yarã tojarã́sama. Mʉsã aꞌtiro weeya. Macã sẽꞌema peꞌe niꞌcã curua mʉꞌʉ yarã surarare waꞌadutiya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Tojo weegʉ Josué treinta mil surara añurõ aꞌmewẽjẽmasĩrãnojõrẽ ñamipʉre Haipʉre oꞌógʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","aꞌtiro nicʉ niwĩ: “Mʉsã añurõ tʉꞌoya. Macã sẽꞌema peꞌe waꞌa, bajutiropʉ niña. Na meꞌrã aꞌmewẽjẽajã, tʉꞌomasĩ coꞌteya. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ãpẽrã surara yʉꞌʉ meꞌrã bajuyoro peꞌe piꞌarãsama. Haicjãrã ʉ̃sãrẽ ĩꞌarã, ʉ̃sãrẽ wẽjẽrãtirã macãpʉ níꞌcãrã wijatirãsama. Na tojo weecã, ʉ̃sã todʉporopʉ weeꞌcaronojõta ui omarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Na peꞌe macãpʉ wija, ʉ̃sãrẽ siruturãsama. ‘Todʉporo weeꞌcaronojõ marĩrẽ uiwãꞌcãrã weema’, nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Na tojo weecã ĩꞌarã, mʉsã macã sẽꞌema peꞌe níꞌcãrã macãpʉ sãjãaña. Sãjãa, ti macãcjãrã nipeꞌtirãrẽ wẽjẽpeꞌocãꞌña. Õꞌacʉ̃ mʉsã wiogʉ ti macãrẽ mʉsã ya macã tojacã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Beꞌro Õꞌacʉ̃ dutiꞌcaronojõta ti macãrẽ ʉ̃jʉ̃acãꞌña. Yʉꞌʉ mʉsãrẽ dutitojaꞌa”, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Tojo níca beꞌro Josué narẽ Betel, Hai waꞌteropʉ waꞌa, tojaduticʉ niwĩ. Hai mujĩpũ sãjãrõ peꞌe tojacaro niwʉ̃. Josué peꞌe cʉ̃ yarã masã meꞌrã ti ñamirẽ mejãrõpʉta yʉꞌrʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Ape nʉmʉ ñamiñaꞌcũrõ cʉ̃ masãrẽ ĩꞌawãꞌcãcʉ niwĩ. Beꞌro Israe curuacjãrã wiorã meꞌrã sʉꞌori Haipʉ aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Nipeꞌtirã surara cʉ̃ meꞌrã nirã́ ti macã põtẽorõpʉ etacãrã niwã. Eta, ti macã yʉꞌrʉropʉ tojaqueꞌacãrã niwã. To na nirṍ meꞌrã opa paꞌtiro nidijacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Josué niꞌcãmocʉsetiri mil surarare Betel, Hai waꞌteropʉ mujĩpũ sãjãrõ peꞌe nʉocũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Aꞌtiro wee surarare pʉa curua dʉcawaacãrã niwã. Niꞌcã curua ti macã mujĩpũ sãjãrõ peꞌe tojacãrã niwã. Ape curua ti macã yʉꞌrʉro peꞌe tojacãrã niwã. Ti ñamita Josué opa paꞌtiro nidijaro decopʉ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Haicjʉ̃ wiogʉ tojo waꞌacã ĩꞌagʉ̃, sojaro meꞌrã cʉ̃ yarã surara meꞌrã ti macãpʉ níꞌcãrã wija, dia Jordã́ cja paꞌtiropʉ Israe curuacjãrã meꞌrã aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. “Ape curua Israe curuacjãrã ti macã sẽꞌema peꞌe duꞌtiapã” ni, masĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Josué, cʉ̃ surara meꞌrã duꞌtirã weronojõ weesoocãrã niwã. Tojo weerã yucʉ marĩrõ nirĩ maꞌa peꞌe uiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Tojo weerã nipeꞌtirã surara Haicjãrã na wiorã dutisere tʉꞌorã, Josuére siruturã, na ya macãrẽ wijawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Nipeꞌtirã ʉmʉa Haicjãrã, tojo nicã Betecjãrã Israe curuacjãrãrẽ siruturã, waꞌapeꞌtia waꞌacãrã niwã. Tojo weero ti macã coꞌtero marĩrõ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Beꞌro Õꞌacʉ̃ Josuére nicʉ niwĩ: “Mʉꞌʉ ñosẽrĩ pjĩ meꞌrã ti macãrẽ sĩ́opuaya. Ti macãrẽ mʉꞌʉ ya macã tojacã weegʉti.” Tojo weegʉ surarare Josué ti pjĩ meꞌrã sĩ́opuatjĩagʉ̃, “Aꞌmewẽjẽrã waꞌaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Cʉ̃ tojo nicãta, surara na bajutiropʉ níꞌcãrã sojaro meꞌrã wijacãrã niwã. Ti macãpʉ omasãjã, pecameꞌe sĩꞌayoobaqueꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Haicjãrã surara majãmiñatõrõrã, na ya macãrẽ oꞌme mʉjãacã ĩꞌacãrã niwã. Israe curuacjãrã uiwãꞌcãmiꞌcãrã majãmitojati, na meꞌrã aꞌmewẽjẽrã aꞌticãrã niwã. Tojo weero ne aperopʉ narẽ duꞌtita basioticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Josué, nipeꞌtirã Israe curuacjãrã ti macã sẽꞌemapʉ duꞌtiꞌcãrã ti macãrẽ ʉ̃jʉ̃acõꞌacã ĩꞌarã, majãmitojaa, Haicjãrã meꞌrã aꞌmewẽjẽrã aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Beꞌro ti macãrẽ sãjãaꞌcãrã wijaa, Haicjãrãrẽ cãꞌmotaꞌaqueꞌacãrã niwã. Tojo weerã na Haicjãrã Israe curuacjãrã pʉa curua decopʉ tojacãrã niwã. Israe curuacjãrã na nipeꞌtirãrẽ wẽjẽpeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Haicjãrã wiogʉ diaꞌcʉ̃rẽ wẽjẽticãrã niwã. Cʉ̃rẽ ñeꞌe, Josué tiropʉ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Israe curuacjãrã na sirutuꞌcãrãrẽ wẽjẽpeꞌoca beꞌro na Haipʉ daja, dʉꞌsaꞌcãrãrẽ wẽjẽpeꞌocãꞌcãrã niwã tja. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Ti nʉmʉrẽ doce mil masã Haicjãrã ʉmʉa, numia wẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Josué peꞌe cʉ̃ ñosẽrĩ pjĩrẽ sĩ́opuanuꞌcũcʉ niwĩ. Téé na nipeꞌtirã Haicjãrãrẽ wẽjẽpeꞌoca beꞌropʉ duꞌudijocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Beꞌro Õꞌacʉ̃ Josuére weedutiꞌcaronojõta Israe curuacjãrã ti macã cjase apeyenojõ, tojo nicã na yarã ecarã meꞌrã tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Josué Haire ʉ̃jʉ̃acõꞌacã, te ʉ̃jʉ̃amoꞌaꞌque, tojo nicã ti macã cjase ʉ̃tãperiacã diaꞌcʉ̃ tojacaro niwʉ̃. Niꞌcãrõacãpʉ quẽꞌrãrẽ tojota bajudecotisaꞌa yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Haicjʉ̃ wiogʉre wẽjẽ́ca beꞌro yucʉgʉpʉ dʉꞌteyoocʉ niwĩ téé ñamicaꞌapʉ. Naꞌiqueꞌari cura cʉ̃rẽ miidijoduti, cʉ̃ upʉre macã sãjãarõpʉ cõꞌaduticʉ niwĩ. Beꞌro cʉ̃ buꞌi ʉ̃tãperi meꞌrã seebiꞌacũuduticʉ niwĩ. Aꞌtocaterore ti ʉ̃tãmesã cũñasaꞌa yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Te beꞌro Josué ʉ̃rʉ̃gʉ̃ Ebal wãmeticjʉpʉ Israe curuacjãrã wiogʉ Õꞌacʉ̃rẽ ẽjõpeorãtirã, waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Cʉ̃ Moisé, Õꞌacʉ̃ dutisere weecoꞌtegʉ, Israe curuacjãrãrẽ dutiꞌcaronojõta daꞌreduticʉ niwĩ. Moisé cʉ̃ dutise cũuca turi ojaꞌcaronojõta ʉ̃tãpaga pááte, bopenoꞌña marĩsepaga meꞌrã tojo weecãrã niwã. Tojo weerã topʉ Israe curuacjãrã Õꞌacʉ̃rẽ ẽjõpeorã, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Topʉ Israe curuacjãrã ĩꞌorõpʉ tepagapʉta tja Josué Õꞌacʉ̃ Moisére dutise cũuꞌquere ojaõꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Nipeꞌtirã masã Israe curuacjãrã, Israe curuacjãrã nitirã na meꞌrã sijarã, nipeꞌtirã bʉcʉrã, narẽ sʉꞌori nirĩ masã, tojo nicã beseri masã Õꞌacʉ̃ ya acaro tiro pʉaperi nʉꞌcãejacãrã niwã. Paꞌia Leví ya curuacjãrã ti acarore wʉawãꞌcãrã masã pãjãrã diacjʉ̃ peꞌe ejanʉꞌcãcãrã niwã. Õꞌacʉ̃ narẽ “Añurõ waꞌato” nisere tʉꞌorãtirã, ʉ̃rʉ̃gʉ̃ Gerizim wãmeticjʉ dʉꞌpocãpʉ deco meꞌrã masã nʉꞌcãejacãrã niwã. Ãpẽrã peꞌe ʉ̃rʉ̃gʉ̃ Ebal wãmeticjʉ dʉꞌpocãpʉ nʉꞌcãejacãrã niwã. Moisé ne waro dutinʉꞌcãꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Beꞌro Josué nipeꞌtise Moisé cʉ̃ dutiꞌquenʉcʉ̃ buꞌeñocʉ niwĩ. “Añurõ waꞌarosaꞌa” níꞌquere, tojo nicã “Ñaꞌarõ waꞌarosaꞌa” níꞌquere buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Ne niꞌcã uuro Moisé dutiꞌquere Josué buꞌeticã weeticʉ niwĩ. Nipeꞌtirã Israe curuacjãrã topʉ nerẽrãrẽ buꞌeñopeꞌocãꞌcʉ niwĩ. Dʉꞌaro marĩrõ numiarẽ, wĩꞌmarãrẽ, tojo nicã Israe curuacjãrã nitirã na meꞌrã nirã́ quẽꞌrãrẽ buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Nipeꞌtirã wiorã dia Jordã́ mujĩpũ sãjãrõpʉ nirã́ Israe curuacjãrã na aꞌmewẽjẽ, wapataꞌaꞌquere tʉꞌocãrã niwã. Na hitita masã, amorreo masã, cananeo masã, ferezeo masã, heveo masã, tojo nicã jebuseo masã nicãrã niwã. Ʉ̃rʉ̃pagʉpʉ nirã́, opa buꞌpa nirõpʉ nirã́, maa pajiri maa Mediterráneo sumutopʉ nirã́ téé Líbanopʉ nirã́ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Tojo weerã na Josué, Israe curuacjãrã meꞌrã aꞌmewẽjẽrã aꞌtirã, niꞌcãrõ meꞌrã nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Tojo weemicã, heveo masã Gabaṍpʉ nirã́ peꞌe, Josué Jericó, tojo nicã Haipʉ weeꞌquere masĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Tojo weerã Israe curuacjãrãrẽ aꞌtiro weesoocãrã niwã. Maꞌapʉ waꞌarã, na burro buꞌipʉ ajuri mejã, tojo nicã vino poseyeꞌque ajuri mejãmejã, tʉ̃ꞌrʉ̃ꞌque mejã, sereõꞌoꞌquere miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Tojo nicã suꞌti mejã, sapatu caseri tʉ̃ꞌrʉ̃ꞌque, sereõꞌoꞌquere sãñacãrã niwã. Maꞌapʉ waꞌarã, pã́ boposãaꞌque, butiwijaꞌquere miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Na Josué nirṍ Gilgapʉ ejarã, cʉ̃rẽ, tojo nicã Israe curuacjãrãrẽ aꞌtiro nicãrã niwã: —Yoarocjãrãpʉ aꞌtiꞌi. Tojo weerã mʉsã ʉ̃sã meꞌrã “Aꞌtiro weerãti”, ni apoya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Israe curuacjãrã heveo masãrẽ yʉꞌticãrã niwã: —Apetero weerã mʉsã ʉ̃sã pʉꞌtoacãcjãrã nisaꞌa. Tojo nicãma, mʉsã meꞌrã “Aꞌtiro weerãti”, nímasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Na peꞌe Josuére nicãrã niwã: —Ʉ̃sã mʉsãrẽ daꞌracoꞌterã nirãsaꞌa. Josué peꞌe narẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Noanojõ niti mʉsã? ¿Noꞌocjãrãpʉ aꞌtiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","—Ʉ̃sã yoarocjãrãpʉ aꞌtiꞌi. Ʉ̃sã mʉsã wiogʉ Õꞌacʉ̃ tutuasere tʉꞌoapʉ. Nipeꞌtise cʉ̃ Egiptopʉ weeꞌquere, ");
INSERT INTO tuoNT_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","tojo nicã pʉarã amorreo masã wiorãrẽ maa Jordã́ si pãꞌrẽ peꞌe níꞌcãrãrẽ cʉ̃ weeꞌquere tʉꞌoapʉ. Na Sehón, Hesbón wiogʉ, tojo nicã Og, Basán wiogʉ nicãrã niwã. Og Astaropʉ macãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Tojo weerã ʉ̃sã wiorã, ʉ̃sã ya diꞌtacjãrã ʉ̃sãrẽ aꞌtopʉ aꞌtidutiama. “Mʉsã maꞌapʉ baꞌatjere mia, Israe curuacjãrã tiropʉ waꞌaya”, ni oꞌoáma. “Mʉsãrẽ daꞌracoꞌterã nirãsaꞌa. Tojo weerã ‘Aꞌtiro weerãti’ ni apoya”, ni dutioꞌoáma ʉ̃sãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Ʉ̃sã mʉsã tiropʉ aꞌticã, aꞌte pã́ asibususepaga niwʉ̃. Niꞌcãrõacãma boposãaꞌque, butiwijaꞌque mejã niꞌi majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Tojo nicã aꞌte vino poseyeꞌque ajuri maꞌma ajuri níniꞌwʉ̃ yujupʉ. Niꞌcãrõacãma tʉ̃ꞌrʉ̃ꞌque niꞌi. Maꞌa yoaro meꞌrã tojo waꞌawʉ ʉ̃sã ye suꞌti, sapatu caseri quẽꞌrã, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Tere tʉꞌorã, Israe curuacjãrã, Õꞌacʉ̃rẽ sẽrĩtiñaꞌtimirã, Gabaṍcjãrã pã́ na cʉosere baꞌañaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Tojo weegʉ Josué narẽ “Mʉsãrẽ coꞌte, wẽjẽsome”, ni apocʉ niwĩ. Ãpẽrã Israe curuacjãrã wiorã “Õꞌacʉ̃ wãme meꞌrã tojota weerãti”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Iꞌtia nʉmʉ na apóca beꞌro Israe curuacjãrã “Ãꞌrã marĩ tiropʉ etaꞌcãrã marĩ nirṍ pʉꞌtocjãrã niapãrã” nisere masĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Tojo weerã na Gabaṍcjãrã masãrẽ aꞌmarã waꞌacãrã niwã. Iꞌtia nʉmʉ beꞌro na ye macãrĩpʉre ejacãrã niwã. Te macãrĩ Gabaṍ, Cafira, Beerot, tojo nicã Quiriat-jearim nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Te macãrĩ pʉꞌtopʉ nimirã, tocjãrãrẽ wẽjẽticãrã niwã. Na wiorã Õꞌacʉ̃, Israe curuacjãrã wiogʉ wãme meꞌrã “Narẽ wẽjẽsome” ni apoꞌcãrã niyurã, narẽ wẽjẽmasĩticãrã niwã. Tojo weerã masã na wiorãrẽ ñaꞌarõ ucũcoꞌtecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Wiorã peꞌe narẽ yʉꞌticãrã niwã: —Ʉ̃sã Õꞌacʉ̃, Israe curuacjãrã wiogʉ wãme meꞌrã, “Narẽ wẽjẽsome”, ni apotojapʉ. Tojo weerã niꞌcãrõacãma narẽ ne mejẽcã weemasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Na catinuꞌcũrãsama. Marĩ Õꞌacʉ̃ meꞌrã “Tojo weerãti” níꞌquere weeticãma, Õꞌacʉ̃ marĩ meꞌrã uagʉsami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Tojo weerã wiorã narẽ wẽjẽdutiticãrã niwã. Mejõ Israe curuacjãrãrẽ peca paawaꞌacoꞌterã, tojo nicã aco waacoꞌterã nicãrã niwã majã. Aꞌte meꞌrã na “Aꞌtiro weerãti” níꞌquere queoro weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Beꞌro Josué Gabaṍcjãrãrẽ pijio, narẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Deꞌro weerã mʉsã ʉ̃sã pʉꞌto nimirã, yoaropʉ aꞌtiapʉ, nisooati? ");
INSERT INTO tuoNT_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Aꞌte meꞌrã mʉsã Õꞌacʉ̃ ñaꞌarõ waꞌarosaꞌa níꞌque wapa tojarã́saꞌa. Tojo weerã mʉsã Õꞌacʉ̃ wiꞌi cjasenojõrẽ peca paawaꞌacoꞌterã, aco waacoꞌterã ninuꞌcũrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Gabaṍcjãrã Josuére yʉꞌticãrã niwã: —Õꞌacʉ̃ mʉꞌʉ wiogʉ Moisére “Aꞌti diꞌtare oꞌogʉti, tojo nicã aꞌto nirãrẽ cõꞌagʉ̃ti” níꞌquere tʉꞌowʉ. Tojo weerã “Na marĩrẽ wẽjẽbosama” ni uirã, tojo weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ʉ̃sã mʉꞌʉ yarã niꞌi. Mʉꞌʉ noꞌo ʉ̃sãrẽ weesĩꞌrĩrõnojõ weeya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Tojo weegʉ Josué Israe curuacjãrãrẽ “Ãꞌrã Gabaṍcjãrãrẽ wẽjẽticãꞌña”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Tojo nimigʉ̃, ti nʉmʉta Gabaṍcjãrãrẽ Israe curuacjãrãrẽ peca paawaꞌacoꞌterã, aco waacoꞌterã tojacã weecʉ niwĩ. Tojo nicã, Õꞌacʉ̃ wiꞌi na ñubuepeoro cjasere Õꞌacʉ̃ cʉ̃ besenoꞌatjopʉ quẽꞌrãrẽ tojota weeduticʉ niwĩ. Aꞌtocateropʉre Gabaṍ masã te daꞌrasere cʉodecotisama yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Wiogʉ Jerusalẽ́cjʉ̃ Adonisedec wãmetigʉ Israe curuacjãrã Haicjãrãrẽ docaqueꞌacã weeꞌquere tʉꞌocʉ niwĩ. Cʉ̃ “Jericóre, ti macã wiogʉre weeꞌcaronojõta Haicjãrãrẽ, na wiogʉre weeapʉ” nisere tʉꞌocʉ niwĩ. Tojo nicã Gabaṍcjãrã Israe curuacjãrã meꞌrã na ucũ aꞌmerĩ apoꞌquere tʉꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Tere tʉꞌogʉ, pũrõ uicʉ niwĩ. Gabaṍ, wiorã nirĩ macã, Hai nemorõ pajiri macã nicaro niwʉ̃. Na Gabaṍcjãrã ʉmʉa aꞌmewẽjẽtutuarã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Tojo weegʉ Adonisedec baꞌparitise macãrĩcjãrã wiorãrẽ queti oꞌócʉ niwĩ. Na Hoham Hebrṍcjʉ̃, Piream Jarmucjʉ̃, Jafía Laquicjʉ̃, tojo nicã Debir Eglṍcjʉ̃ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Narẽ aꞌtiro níoꞌocʉ niwĩ: “Gabaṍcjãrã Josué, tojo nicã Israe curuacjãrã meꞌrã apocãrã niama. Tojo weerã mʉsã, mʉsã yarã surara meꞌrã yʉꞌʉre Gabaṍcjãrã meꞌrã aꞌmewẽjẽcã weetamurã aꞌtia”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Tojo weerã na niꞌcãmocʉrã amorreo masã wiorã nerẽ, na yarã surara meꞌrã Gabaṍcjãrã meꞌrã aꞌmewẽjẽrã waꞌacãrã niwã. Na wiorã Jerusalẽ́cjʉ̃, Hebrṍcjʉ̃, Jarmucjʉ̃, Laquicjʉ̃, tojo nicã Eglṍcjʉ̃ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Na tojo weecã ĩꞌarã, Gabaṍcjãrã Josué Gilgapʉ nigʉ̃rẽ queti oꞌócãrã niwã: “Ʉ̃sãrẽ, mʉsãrẽ daꞌracoꞌterãrẽ cõꞌawãꞌcãticãꞌña. Quero, ʉ̃sãrẽ weetamurã aꞌtia. Ʉ̃sãrẽ yʉꞌrʉorã aꞌtia. Nipeꞌtirã wiorã amorreo masã ʉ̃rʉ̃pagʉcjãrã ʉ̃sã meꞌrã aꞌmewẽjẽrãtirã nerẽcãrã niama”, ni queti oꞌócãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Tere tʉꞌogʉ, Josué nipeꞌtirã cʉ̃ yarã surara tutuarã meꞌrã Gilgapʉ wijaa, Gabaṍpʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: “Narẽ uiticãꞌña. Yʉꞌʉ mʉsãrẽ aꞌmewẽjẽbosa, wapataꞌacã weegʉti. Ne niꞌcʉ̃ na meꞌrã nigʉ̃́ mʉꞌʉrẽ põtẽomasĩtisami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Ñamipʉ Josué Gilgapʉ wija, waꞌaboꞌrea, amorreo masã ne masĩtiri cura na meꞌrã aꞌmewẽjẽnʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Õꞌacʉ̃ Israe curuacjãrãrẽ narẽ ʉcʉacã weecʉ niwĩ. Tojo weegʉ Josué Gabaṍpʉre pãjãrã amorreo masãrẽ wẽjẽcʉ niwĩ. Narẽ Bet-horón wãmetiri maꞌapʉ sirutu, téé yoaro apeye macãrĩpʉ Azeca, Maceda wãmetise macãrĩpʉ wẽjẽsirutuwãꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Apeyema tja na Bet-horón buꞌari maꞌapʉ uiwãꞌcãrĩ cura Õꞌacʉ̃ aꞌtiro weecʉ niwĩ. Acoro pejaro weronojõ narẽ yʉsʉase aco peri bʉꞌaꞌque peri paca bʉrʉcã weecʉ niwĩ. Cʉ̃ tojo weeꞌque meꞌrã pãjãrã amorreo masã wẽrĩcãrã niwã. Israe curuacjãrã surara narẽ wẽjẽꞌcaro nemorõ pãjãrã wẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Õꞌacʉ̃ Israe curuacjãrã amorreo masãrẽ docaqueꞌacã wééca nʉmʉrẽ Josué Õꞌacʉ̃rẽ masã ĩꞌorõpʉ nicʉ niwĩ: “Mujĩpũ, Gabaṍ buꞌipʉ tojanʉꞌcãña. Mujĩpũ ñamicjʉ̃ peꞌe, Ajalón cja paꞌtiro buꞌipʉ tojanʉꞌcãña”. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Cʉ̃ tojo nicã, mujĩpũ ʉmʉcocjʉ̃, ñamicjʉ̃ téé narẽ ĩꞌatuꞌtirãrẽ wẽjẽcõꞌáca beꞌropʉ tojanʉꞌcãtʉocãrã niwã. Aꞌtere Justo wãmetiri turipʉ ojanoꞌwʉ̃. Tojo weegʉ mujĩpũ ʉmʉcocjʉ̃ ʉꞌmʉse decopʉ tojanʉꞌcãcʉ niwĩ. Niꞌcã nʉmʉ ejatuaro ne sãjãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Todʉporopʉ ti nʉmʉ weronojõ Õꞌacʉ̃ masʉ̃rẽ cʉ̃ tojo sẽrĩsere yʉꞌtíca nʉmʉ weronojõ waꞌaticaro niwʉ̃. Beꞌropʉ quẽꞌrãrẽ tojo waꞌaticaro niwʉ̃. Ti nʉmʉrẽta Õꞌacʉ̃ cʉ̃ tutuaro meꞌrã Israe curuacjãrãrẽ aꞌmewẽjẽtamucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Beꞌro Josué na cãrĩrõ Gilgapʉ nipeꞌtirã Israe curuacjãrã meꞌrã dajatojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Na niꞌcãmocʉse macãrĩcjãrã wiorã, ʉ̃tã tutipʉ Maceda nirĩ tutipʉ duꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Beꞌro ãpẽrã na niꞌcãmocʉrã wiorã Macedapʉ nirĩ tutipʉ duꞌtiꞌcãrãrẽ boca, Josuére werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Josué tere tʉꞌogʉ, aꞌtiro dutíoꞌocʉ niwĩ: “Ti tuti sãjãrĩ sopere ʉ̃tãpaga paca meꞌrã tũrũwãꞌcã, tuubiꞌaya. Tojo nicã, ti tutire masãrẽ coꞌtedutiya. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Mʉsã peꞌe aꞌtore ne tojatícãꞌña. Mʉsãrẽ ĩꞌatuꞌtirãrẽ sirutuya. Narẽ na ya macãpʉ dajacã weeticãꞌña. Õꞌacʉ̃ marĩ wiogʉ narẽ docaqueꞌacã weetojami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Tojo weerã Josué, Israe curuacjãrã pãjãrã amorreo masãrẽ wẽjẽcãrã niwã. Pejetirã na wẽjẽdʉꞌaꞌcãrã na ye macãrĩpʉ dajacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Nipeꞌtirã Israe curuacjãrã surara peꞌe narẽ sirutuꞌcãrã Josué cʉ̃ nirṍ Macedapʉ cãmi marĩrã dajapeꞌticãrã niwã. Topʉ nise macãrĩcjãrã ne cãꞌrõacã Israe curuacjãrãrẽ ñaꞌarõ ucũticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Beꞌro Josué aꞌtiro nicʉ niwĩ: “Ʉ̃tã tuti ne sãjãarõpʉ pão weetjĩarã, na niꞌcãmocʉrã wiorãrẽ miiwĩrõ, yʉꞌʉ tiropʉ miitia”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Tojo weerã niꞌcãmocʉrã wiorã Jerusalẽ́cjʉ̃, Hebrṍcjʉ̃, Jarmucjʉ̃, Laquicjʉ̃, tojo nicã Eglṍcjʉ̃rẽ miiwĩrõcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Na wiorãrẽ Josué tiropʉ miiejáca beꞌro nipeꞌtirã Israe curuacjãrã ʉmʉarẽ pijiocʉ niwĩ. Surara wiorã cʉ̃ meꞌrã aꞌmewẽjẽtamuꞌcãrãrẽ aꞌtiro duticʉ niwĩ: “Mʉsã ãꞌrã wiorã wãmʉtare ʉꞌtacũurã aꞌtia.” Cʉ̃ tojo nicã tʉꞌorã, cʉ̃ dutironojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Beꞌro Josué surara wiorãrẽ nicʉ niwĩ: “Wãcũtutuaya. Uiro marĩrõ nisetiya. Mʉsã narẽ weeꞌcaronojõta Õꞌacʉ̃ weegʉsami nipeꞌtirã mʉsãrẽ ĩꞌatuꞌtirãrẽ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Cʉ̃ tojo nitoja, wiorãrẽ wẽjẽcʉ nimi. Beꞌro cʉ̃ yarã surarare na upʉre yucʉpagʉ niꞌcãmocʉsepagʉpʉ dʉꞌteyooduticʉ niwĩ. Topʉ yosanaꞌitõꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Beꞌro naꞌiqueꞌari cura narẽ miidijoduti, na duꞌtíca tutipʉ cõꞌaduticʉ niwĩ. Ti tuti sãjãrõrẽ ʉ̃tã pacasepaga meꞌrã biꞌacãrã niwã. Tepaga topʉ nidecotiꞌi yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Narẽ wẽjẽ́ca nʉmʉrẽta Josué Maceda wiogʉ, nipeꞌtirã ti macãpʉ nirãrẽ wẽjẽpeꞌocãꞌcʉ niwĩ. Ne niꞌcʉ̃ tocjʉ̃rẽ caticã weeticʉ niwĩ. Cʉ̃ Jericócjʉ̃ wiogʉre weeꞌcaronojõta Maceda wiogʉ quẽꞌrãrẽ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Maceda macãpʉ níꞌcãrã Josué, tojo nicã nipeꞌtirã Israe curuacjãrã Libna wãmetiri macãpʉ waꞌacãrã niwã. Topʉ waꞌa, aꞌmewẽjẽrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Õꞌacʉ̃ Israe curuacjãrãrẽ ti macãcjʉ̃ wiogʉre, cʉ̃ yarã masãrẽ na dutise doca cũucʉ niwĩ. Tocjãrã nipeꞌtirã masãrẽ Josué, cʉ̃ yarã surara meꞌrã wẽjẽcõꞌapeꞌocãꞌcʉ niwĩ. Ne niꞌcʉ̃ yʉꞌrʉwetiticʉ niwĩ. Libna macãcjʉ̃ wiogʉ Jericócjʉ̃ wiogʉre waꞌaꞌcaronojõta waꞌacaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Tojo weetjĩagʉ̃, Josué nipeꞌtiro ti diꞌtare ñeꞌepeꞌocãꞌcʉ niwĩ. Tere ñeꞌegʉ̃, ʉ̃rʉ̃pagʉ peje, Neguev yucʉ marĩbocureropʉ, tojo nicã opa paꞌtirojo nirṍ, opa buꞌpa nirõpʉ ñeꞌecʉ niwĩ. Topʉ nirã́ nipeꞌtirã wiorãrẽ docaqueꞌacã weecʉ niwĩ. Ne niꞌcʉ̃ wiogʉ catigʉ tojatícʉ niwĩ. Nipeꞌtirã masã wẽjẽnoꞌcãrã niwã. Aꞌtere Õꞌacʉ̃, Israe curuacjãrã wiogʉ, cʉ̃ weedutiꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Titare Josué nipeꞌtirãrẽ nipeꞌtiropʉ docaqueꞌacã weecʉ niwĩ. Cades-barnea wãmetiro meꞌrã nʉꞌcã, téé Gazapʉ yapaticʉ niwĩ. Apero quẽꞌrãrẽ Gosén wãmetiro meꞌrã nʉꞌcã, téé Gabaṍpʉ yapaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Õꞌacʉ̃ Israe curuacjãrã wiogʉ cʉ̃ yarã masãrẽ maꞌígʉ̃, aꞌmewẽjẽbosacʉ niwĩ. Tojo weeyucã, Josué cʉ̃ aꞌmewẽjẽse meꞌrãta na nipeꞌtirã wiorã pãjãrãrẽ, tojo nicã te diꞌtare miiwapacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Beꞌro Josué cʉ̃ yarã surara meꞌrã Gilgal na níꞌcaropʉ dajatojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","“Tojo waꞌaporo” nise quetire tʉꞌogʉ, Jabín Hasor macã wiogʉ aꞌtiro weecʉ niwĩ. Jobab wãmetigʉ Madón macã wiogʉre, tojo nicã Simrón, Acsaf macãrĩcjãrã wiorãrẽ pijiocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","Apeyema wiorã ʉ̃rʉ̃pagʉ nortepʉ nirãrẽ pijiocʉ niwĩ. Tojo nicã, ditara Cineret siropʉ nirãrẽ pijiocʉ niwĩ. Ãpẽrãma opa paꞌtiro nídijaro nirã́ Dor mujĩpũ sãjãrõcjãrãrẽ pijiocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Ãpẽrã mujĩpũ mʉjãtiro peꞌecjãrã cananeo masãrẽ, mujĩpũ sãjãrõ peꞌecjãrã cananeo masãrẽ, amorreo masãrẽ, hitita masãrẽ, ferezeo masãrẽ, jebuseo ʉ̃rʉ̃pagʉpʉ nirĩ masãrẽ, heveo masã ʉ̃rʉ̃gʉ̃ Hermón wãmeticjʉ nídijaro Mizpapʉ nirãrẽ pijiocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Tojo weerã na wiorã na yarã surara meꞌrã aꞌmewẽjẽrã waꞌacãrã niwã. Na yarã cabayua pãjãrãrẽ, na aꞌmewẽjẽse cabayua wejesepawʉ meꞌrã waꞌacãrã niwã. Na pãjãrã waro nitjĩarã, nucũpori maa sumuto cjase weronojõ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Beꞌro na Israe curuacjãrã meꞌrã aꞌmewẽjẽrã waꞌarãtirã, “Aꞌtiro weerã” ni, aꞌmerĩ apocãrã niwã. Tuꞌajanʉꞌcõ, niꞌcã curuajota aco nirṍ Merom tiropʉ queꞌaejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ peꞌe Josuére “Narẽ ne uiticãꞌña. Ñamiacã aꞌti orata na pãjãrãrẽ mʉsã wẽjẽpeꞌocã weegʉti. Mʉsã peꞌe na yarã cabayua dʉꞌpocãrĩ ʉꞌtacũuse wadarire dʉtesureapa. Tojo nicã na tũrũsepawʉ aꞌmewẽjẽsepawʉ cabayua na wejesere ʉ̃jʉ̃apa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Tojo wee Josué, cʉ̃ yarã surara meꞌrã waꞌa weetjĩagʉ̃, narẽ ĩꞌatuꞌtirã masĩnoꞌña marĩrõ, aco nirṍ Merõpʉ na meꞌrã aꞌmewẽjẽnʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Õacʉ̃ peꞌe Israe curuacjãrãrẽ narẽ miiwapa waꞌacã weecʉ niwĩ. Na narẽ téé Sidṍ macãjopʉ, tojo nicã Misrefot-maim, apero opa paꞌtiro Mizpa mujĩpũ mʉjãtiropʉ narẽ sirututʉocãrã niwã. Ne niꞌcʉ̃ catiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta Josué queoro weecʉ niwĩ. Tere wéégʉ, cʉ̃rẽ ĩꞌatuꞌtirã yarã cabayuare na dʉꞌpocãrĩ ʉꞌtacũuse wadarire dʉtecʉ niwĩ. Tojo nicã na tũrũsepawʉ aꞌmewẽjẽsepawʉre ʉ̃jʉ̃acʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Aꞌmewẽjẽgʉ̃ etaꞌcʉ cʉ̃ dajáca beꞌro Josué Hasor macãrẽ miiwapacʉ niwĩ. Titare cʉ̃ ya diꞌpjĩjo meꞌrã ti macãcjʉ̃ wiogʉre wẽjẽcʉ niwĩ. Ti macã Hasota apeye macãrĩ nemorõ nirĩ macã nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Israe curuacjãrã nipeꞌtirã ti macãpʉ nirãrẽ wẽjẽpeꞌocãrã niwã. Ti macã Hasore mʉtõdijopeꞌo, ʉ̃jʉ̃acõꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Josué topʉ nise macãrĩ nipeꞌtise macãrĩrẽ na wiorã meꞌrãpʉta miiwapacʉ niwĩ. Wiorãrẽ diꞌpjĩjo meꞌrã wẽjẽcõꞌapeꞌocʉ niwĩ. Nipeꞌtirãrẽ, nipeꞌtisere mʉtõdijopeꞌocʉ niwĩ. Cʉ̃ tojo weese meꞌrã Josué Moisé, Õꞌacʉ̃ dutisere weecoꞌtegʉ, cʉ̃ dutiꞌquere queoro weemeꞌrĩcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Israe curuacjãrã opa buꞌpapʉ nise macãrĩma ʉ̃jʉ̃aticãrã niwã. Hasor diaꞌcʉ̃rẽ ʉ̃jʉ̃acãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Te macãrĩpʉ nirãrẽ diꞌpjĩjo meꞌrã wẽjẽcõꞌacãrã niwã. Ne niꞌcʉ̃ catigʉ tojatícʉ niwĩ. Te macãrĩ cjase, na yarã ecarã, na ye apeyenojõ nimiꞌque Israe curuacjãrãrẽ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Õꞌacʉ̃ Moisére dutiꞌcaronojõta Moisé peꞌe quẽꞌrã Josuére dutituriacʉ niwĩ. Ãꞌrĩ Josué pũrĩcã Õꞌacʉ̃ cʉ̃ Moisére dutiꞌque weeturiagʉ, te cʉ̃ dutise cũuꞌquere ne cãꞌrõ weꞌoticʉ niwĩ. Nipeꞌtisere añurõpʉ weedutipeꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Josué aꞌticʉse diꞌtare miiwapacʉ niwĩ. Nipeꞌtiro ʉ̃rʉ̃pagʉ nirõrẽ miiwapacʉ niwĩ. Nipeꞌtiro Neguere, tojo nicã nipeꞌtiro Gosẽ́rẽ, nipeꞌtiro opa paꞌtiro nirõrẽ, nipeꞌtiro Arabáre, tojo nicã Israe nipeꞌtiro ʉ̃rʉ̃pagʉ tiropʉ to opa paꞌtiro nirõrẽ ñeꞌepeꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Todʉporopʉ Õꞌacʉ̃ Moisére dutíꞌcaronojõta Josué nipeꞌtiro Canaá diꞌtapʉ peje macãrĩrẽ miiwapacʉ niwĩ. Tuꞌajanʉꞌcõ, Josué ti diꞌtare Israe curaricjãrãrẽ dʉcawaacʉ niwĩ. Nanʉcʉ̃ na ye diꞌta tojato nígʉ̃, tojo weecʉ niwĩ. Beꞌro ti diꞌtapʉre ne aꞌmewẽjẽse marĩcaro niwʉ̃ majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Moisé catícatero Israe curuacjãrã pʉarã wiorã dia Jordã́ mujĩpũ mʉjãtiro peꞌecjãrãrẽ docaqueꞌacã weetojacãrã niwã. Na ye diꞌta nimiꞌquere miiwapacãrã niwã. Te diꞌta dia Arnón wãmetiri maa meꞌrã nʉꞌcã, tojo nicã nipeꞌtiro dia Jordã́ sumuto nirĩ paꞌtiro, téé ʉ̃rʉ̃gʉ̃ Hermón wãmeticjʉpʉ nitʉocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Niꞌcʉ̃ wiogʉ Sehón amorreo masã wiogʉ nicʉ niwĩ. Cʉ̃ Hesbón wãmetiri macãpʉ niseticʉ niwĩ. Cʉ̃ dutiro Aroer wãmetiri macã meꞌrã nʉꞌcã, téé dia Arnón sumuto nicaro niwʉ̃. Tojo nicã, ti paꞌtiro deco meꞌrã nʉꞌcã, dia Jaboc meꞌrãpʉ nitʉocaro niwʉ̃. Dia Jaboc ape diꞌta amonita masã ya diꞌta sãjãrõpʉ nicaro niwʉ̃. Tojo nicã Galaad diꞌta deconojõ cʉ̃ dutiri diꞌta nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Apeyema tja mujĩpũ mʉjãtiro dia Jordã́ paꞌtirore duticʉ niwĩ. Cineret wãmetiri ditara meꞌrã dutinʉꞌcã, téé oꞌmabʉrotiri ditara meꞌrãpʉ duti yapatitʉocʉ niwĩ. Toó Bet-jesimot mujĩpũ sãjãrõ peꞌe toja, sur peꞌe téé Pisga wãmeticjʉ ʉ̃rʉ̃gʉ̃ dʉꞌpocã́pʉ dutitʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Apĩ peꞌe Og wãmetigʉ Basán wãmetiro dutigʉ nicʉ niwĩ. Cʉ̃ refaíta masʉ̃ pejetirã dʉꞌsagʉ meꞌrãcjʉ̃ ninoꞌgʉ̃ nicʉ niwĩ. Cʉ̃ Astarot, tojo nicã Edrei wãmetise macãrĩpʉ niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Og téé nortepʉ Hermón wãmeticjʉ ʉ̃rʉ̃gʉ̃pʉ dutitʉocʉ niwĩ. Cʉ̃ Salca macãrẽ, nipeꞌtiro Basán wãmetirore duticʉ niwĩ. Téé ape diꞌta na taꞌaꞌcaro Gesur wãmetirore, tojo nicã Maaca wãmetirore, apero Galaad diꞌta decopʉ Sehón, Hesbón macã wiogʉ cʉ̃ dutiropʉre dutitʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Moisé, tojo nicã Israe curuacjãrã ãꞌrã wiorã pʉarãrẽ aꞌmewẽjẽ docaqueꞌacã weecãrã niwã. Beꞌro Moisé te diꞌtare Rubén ya curuacjãrãrẽ, Gad ya curuacjãrãrẽ, tojo nicã Manasés ya curuacjãrã deco meꞌrã nirãrẽ na ye niatje diꞌtare dʉcawaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Aꞌticʉrã wiorãrẽ Josué Israe curuacjãrã meꞌrã dia Jordã́ mujĩpũ sãjãrõ peꞌecjãrã, to Baal-gad Líbano wãmetiri paꞌtiropʉ Halac wãmeticjʉ ʉ̃rʉ̃gʉ̃pʉ, tigʉ Seipʉ ʉꞌmʉatuꞌajanʉꞌcõsaꞌa. Josué ãꞌrã wiorã ye diꞌta nimiꞌquere aꞌmewẽjẽ, wapataꞌa, Israe curuacjãrãrẽ te curarinʉcʉ̃rẽ te diꞌtare dʉcawaacʉ niwĩ. Te diꞌta na ye waro tojanuꞌcũcãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Ʉ̃rʉ̃pagʉ pijaro peꞌe, opapa nirṍ peꞌema, tojo nicã Jordã́ paꞌtiro peꞌema, opa tʉꞌrʉri nídijase coꞌari, yucʉ marĩrõ, masã marĩrõ Neguev cjase ãꞌrã masã ye diꞌta nicaro nimiwʉ̃: Hitita masã, amorreo masã, cananeo masã, ferezeo masã, heveo masã, tojo nicã jebuseo masã ye diꞌta nicaro nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Wiorã aꞌmewẽjẽrã docaqueꞌaꞌcãrã aꞌticʉrã nicãrã niwã: Jericó wiogʉ, apĩ Hai, Betel macã pʉꞌto wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","apĩ Jerusalẽ́ wiogʉ, apĩ Hebrṍ wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","apĩ Jarmut wiogʉ, apĩ Laquis wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","apĩ Eglón wiogʉ, apĩ Gezer wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","apĩ Debir wiogʉ, apĩ Geder wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","apĩ Horma wiogʉ, apĩ Arad wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","apĩ Libna wiogʉ, apĩ Adulam wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","apĩ Maceda wiogʉ, apĩ Betel wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","apĩ Tapúa wiogʉ, apĩ Hefer wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","apĩ Afec wiogʉ, apĩ Sarón wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","apĩ Madón wiogʉ, apĩ Hazor wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","apĩ Simron-merón wiogʉ, apĩ Acsaf wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","apĩ Taanac wiogʉ, apĩ Meguido wiogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","apĩ Cedes wiogʉ, apĩ Jocneam wiogʉ, ʉ̃rʉ̃gʉ̃ Carmelo dʉꞌpocãpʉ nigʉ̃́, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","apĩ Dor wiogʉ, Dor majãrõcjʉ̃, apĩ Goim wiogʉ, Gilgal wãmetiri macãcjʉ̃, ");
INSERT INTO tuoNT_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","apĩ Tirsa wiogʉ nicãrã niwã. Na wiorã nipeꞌtirã nírã treinta y uno nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Josué bʉcʉ waro ẽjã́cã, Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: “Mʉꞌʉ bʉcʉ waro niꞌi. Aꞌti diꞌtare mʉsã ñeꞌeatje peje dʉꞌsaꞌa yujupʉ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","Israe curuacjãrã na ĩꞌorõpʉta sidonio masãrẽ cõꞌawĩrõgʉ̃ti. Tojo nicã, nipeꞌtirã masã to ʉ̃rʉ̃gʉ̃pʉ nirãrẽ Líbano meꞌrã nʉꞌcã, téé Misrefot-maipʉ cõꞌawĩrõgʉ̃ti. Mʉꞌʉ peꞌe te diꞌta na waꞌaweꞌoꞌquere Israe curuacjãrãrẽ miiwapa, dʉcawaaya. Yʉꞌʉ mʉꞌʉrẽ dutiꞌcaronojõta weeya. ");
INSERT INTO tuoNT_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Tojo weegʉ nueve curari, tojo nicã Manasés ya curuacjãrã deco meꞌrã nirãrẽ nipeꞌtise diꞌtare dʉcawaaweꞌoya”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Moisé Rubén ya curuacjãrãrẽ, Gad ya curuacjãrãrẽ, tojo nicã Manasés ya curuacjãrã deco meꞌrã nirãrẽ na niatji diꞌtare oꞌotojacʉ niwĩ. Te diꞌta dia Jordã́ mujĩpũ mʉjãtiro peꞌe nicaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Moisé Leví ya curuacjãrã peꞌema diꞌtare oꞌoticʉ niwĩ. Mejõ Õꞌacʉ̃ Moisére níꞌcaronojõta “Leví ya curuacjãrã ye niatje masã yʉꞌʉre ñubuepeorã, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeose cjase nirõsaꞌa”, nicʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Te diꞌtata Canaá diꞌta cjase nicaro niwʉ̃. Paꞌi Eleazar, Josué, Nun macʉ̃, tojo nicã nipeꞌtise curaricjãrã wiorã te diꞌtare dʉcawaacãrã niwã. Na Israe curuacjãrãrẽ dʉcawááca beꞌro na ye diꞌta tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Õꞌacʉ̃ Moisére diꞌtare dʉcawaadutiꞌcaronojõta níbocase meꞌrã te nueve curaricjãrãrẽ, ape deco meꞌrã nirĩ curua quẽꞌrãrẽ te diꞌtare dʉcawaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","4","Moisé te diꞌtare mujĩpũ mʉjãtiro dia Jordã́pʉ na pʉa curuacjãrã Rubén, Gad, tojo nicã Manasés deco meꞌrã nirĩ curuacjãrãrẽ oꞌotojacʉ nimiwĩ. Tojo wééca beꞌro nimicã, José yarã peꞌe pʉa curuapʉ dʉcawaticãrã niwã. Na Manasés ya curua, tojo nicã Efraĩ́ ya curua nicãrã niwã. Paꞌia Leví ya curua peꞌema diꞌtare oꞌoticãrã niwã. Mejõ macãrĩrẽ, cãꞌrõ diꞌta nisenojõacãrẽ waꞌicʉrã na tá baꞌanuꞌcũatjo nirṍ ejatuaro oꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Õꞌacʉ̃ Moisére dutiꞌcaronojõta Israe curuacjãrã Canaá diꞌtare dʉcawaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Judá ya curuacjãrã ʉmʉa Gilgapʉ Josué meꞌrã ucũrã waꞌacãrã niwã. Caleb, cenezeo masʉ̃, Jefone macʉ̃, Josuére aꞌtiro nicʉ niwĩ: “Cades-barneapʉ Õꞌacʉ̃ Moisére níꞌquere wãcũña. Cʉ̃ marĩ pʉarã ye cjasere niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Moisé yʉꞌʉ ti macãpʉ níꞌcʉre Canaá diꞌtare ĩꞌacusiagʉ oꞌócaterore cuarenta cʉ̃ꞌmarĩ cʉowʉ. Ĩꞌadajagʉ, yaꞌyioro marĩrõ diacjʉ̃ nise meꞌrã yʉꞌʉ ĩꞌaꞌquere cʉ̃rẽ werewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Yʉꞌʉ meꞌrã waꞌaꞌcãrã peꞌe masãrẽ uisãwã. Yʉꞌʉ pũrĩcã nipeꞌtise yʉꞌʉ wãcũ, ẽjõpeose meꞌrã Õꞌacʉ̃ ʉaro weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Tojo weegʉ Moisé Õꞌacʉ̃ tʉꞌoropʉ yʉꞌʉre aꞌtiro niwĩ: ‘Mʉꞌʉ Õꞌacʉ̃ dutiro queoro weenuꞌcũwʉ̃. Tojo weegʉ Canaá diꞌtapʉ mʉꞌʉ ʉꞌtacũusijaꞌcaro ejatuaro mʉꞌʉ ye nirõsaꞌa. Tojo nicã mʉꞌʉ pãrãmerã nituriarã ye diꞌta nirõsaꞌa’, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","Õꞌacʉ̃ Moisére tojo níꞌque cuarenta y cinco cʉ̃ꞌmarĩ yʉꞌrʉtojawʉ. Israe curuacjãrã marĩ yucʉ marĩrõpʉ sijácaterore tojo niwĩ. Cʉ̃ níꞌcaronojõta te cʉ̃ꞌmarĩrẽ yʉꞌʉre catise oꞌowĩ. Niꞌcãrõacã ochenta y cinco cʉ̃ꞌmarĩ cʉoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Tojo nimigʉ̃, Moisé yʉꞌʉre aꞌti diꞌtare ĩꞌaduꞌtidutigʉ oꞌócatero weronojõ tutua niꞌi yujupʉ. Titare yʉꞌʉ aꞌmewẽjẽtutuaꞌcaro weronojõ mejãrõta tʉꞌoñaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Tojo weegʉ niꞌcãrõacã opa buꞌpapijaro nirõrẽ, Õꞌacʉ̃ yʉꞌʉre oꞌogʉti níꞌque diꞌtare oꞌoya. Tita meꞌrã tocjãrã ye cjasere mʉꞌʉ tʉꞌowʉ. Masã pacarã Anac pãrãmerã nituriarã topʉ niwã. Tojo nicã, na ye macãrĩ pacase macãrĩ, añurõ biꞌa cãꞌmotaꞌaꞌque macãrĩ niwʉ̃. Tojo nimicã, Õꞌacʉ̃ cʉ̃ weetamurõ meꞌrã, cʉ̃ níꞌcaronojõ narẽ na ye macãrĩrẽ nʉrʉ̃wĩrõgʉ̃ti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Tojo weegʉ, Josué Caleb, Jefone macʉ̃rẽ “Añurõ waꞌato” ni, Õꞌacʉ̃rẽ sẽrĩbosacʉ niwĩ. Beꞌro Hebrṍ macãrẽ cʉ̃rẽ, cʉ̃ pãrãmerã nituriarãrẽ oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ti nʉmʉ meꞌrã ti macã Hebrṍ Caleb, cʉ̃ pãrãmerã ya macã, aꞌtiro nicã quẽꞌrãrẽ nidecotiꞌi yujupʉ. Cʉ̃ Õꞌacʉ̃ Israe curuacjãrã wiogʉ dutisere queoro weemeꞌrĩꞌcʉ niyucã, tojo niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Dʉporo cjase wãme Hebrṍ Quiriat-arba wãmeticaro nimiwʉ̃. Arba ãpẽrã Anac pajigʉjo pãrãmerã nituriarã yʉꞌrʉoro niyʉꞌrʉnʉꞌcãcʉ niwĩ. Aꞌte beꞌrore ti diꞌtapʉre ne aꞌmewẽjẽse marĩcaro niwʉ̃ majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Níbocase meꞌrã Judá ya diꞌta sur nibʉrʉaropʉ bocaꞌque Edom diꞌta nitʉoropʉ, téé yucʉ marĩrõ, masã marĩrõ Zin wãmetiropʉ nitʉocaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Õꞌacʉ̃ cʉ̃ “Tojo weeya” níꞌcaronojõta Josué Caleb, Jefone macʉ̃rẽ niꞌcã diꞌta Judá ya curuacjãrãrẽ opa buꞌpapijaro níꞌcarore oꞌocʉ niwĩ. Cʉ̃ oꞌoꞌque diꞌta Quiriat-arba nicaro niwʉ̃. Beꞌro ti macãrẽ Hebrṍ pisucãrã niwã. Ti macã Anac pajigʉ, ʉꞌmʉagʉ̃jo pãrãmerã nituriarã niyʉꞌrʉnʉꞌcãrĩ macã nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Hebrṍ macãpʉ níꞌcãrãrẽ Caleb iꞌtiarã Anac pãrãmerã nituriarãrẽ aperopʉ cõꞌaõꞌocʉ niwĩ. Na aꞌticʉrã nicãrã niwã: Sesai, Ahimán, tojo nicã Talmai nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Topʉ níꞌcʉta majãa, Debir macãcjãrã meꞌrã aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. Ti macãta todʉporopʉre Quiriat-sefer wãmeticaro nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Caleb aꞌtiro nicʉ niwĩ: “Noꞌo niꞌcʉ̃ ʉmʉ Quiriat-sefer macãrẽ aꞌmewẽjẽ miiwapagʉre yʉꞌʉ macõ Acsare numisogʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Tere cʉ̃ tojo nicã tʉꞌogʉ, Otoniel, Cenaz macʉ̃, Caleb acabiji macʉ̃ Quiriat-sefer macãrẽ aꞌmewẽjẽ, miiwapa waꞌacʉ niwĩ. Tuꞌajanʉꞌcõ, Caleb cʉ̃ macõ Acsare Otonierẽ numisocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Co cʉ̃ tiropʉ etacã, Otoniel core “Diꞌta marĩ oteatjere sẽrĩña”, nicʉ niwĩ. Co peꞌe “Jaʉ”, ni yʉꞌtico niwõ. Acsa burro buꞌipʉ pesaꞌco dijacã, co pacʉ Caleb core sẽrĩtiñaꞌcʉ niwĩ: —Macõ, ¿ñeꞌenojõrẽ mʉꞌʉ ʉati? ");
INSERT INTO tuoNT_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","—Pacʉ, mʉꞌʉ yʉꞌʉre weetamuña. Neguev yucʉ marĩrõpʉ yʉꞌʉre diꞌta oꞌotojapʉ. Niꞌcãrõacãma majã aco wijase peri nise diꞌtare oꞌoya, nico niwõ. Tojo weetjĩagʉ̃, Caleb cʉ̃ macõrẽ ʉꞌmʉase buꞌpapʉre, tojo nicã buꞌaro aco wijase diꞌta nirõpʉre oꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Judá ya curuacjãrã nituriarã peꞌe Jerusalẽ́pʉ nirã́ jebuseo masãrẽ cõꞌawĩrõmasĩticãrã niwã. Tojo weerã na niꞌcãrõacãpʉ quẽꞌrãrẽ Judá pãrãmerã nituriarã meꞌrã nidecotisama yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","José pãrãmerã nituriarã Manasés ya curuacjãrã, tojo nicã Efraĩ́ ya curuacjãrã narẽ oꞌoꞌque diꞌtare ñeꞌecãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Efraĩ́ ya curuacjãrã peꞌe Gezer macãpʉ nirã́ cananeo masãrẽ cõꞌawĩrõticãrã niwã. Tojo weemirã, narẽ ʉpʉtʉ waro tutuaro daꞌrase dutipecãrã niwã. Niꞌcãrõacã quẽꞌrãrẽ na tiropʉta nidecotima yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","José pãrãmerã nituriarã Manasés ya curuacjãrã, tojo nicã Efraĩ́ ya curuacjãrã Josuére aꞌtiro nicãrã niwã: —¿Deꞌro weegʉ ʉ̃sãrẽ ʉ̃sã ye niatjere niꞌcã diꞌtacãta oꞌoati? Ʉ̃sãrẽ ejatuatʉꞌsaweꞌe. Õꞌacʉ̃ ʉ̃sãrẽ añurõ wéégʉ, pãjãrã masãputicã weeami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Na tojo nicã tʉꞌogʉ, Josué narẽ yʉꞌticʉ niwĩ: —Mʉsã pãjãrã niꞌi nírã, mʉsãrẽ oꞌóca diꞌta Efraĩ́, buꞌpapijaro nirṍ ejatuaticã, ferezeo masã, tojo nicã refaíta masã ya diꞌta yucʉpagʉ pejepagʉ nirõpʉ waꞌaya. Waꞌa, tere paa, ote, topʉ nisetiya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Na cʉ̃rẽ yʉꞌticãrã niwã: —Diacjʉ̃ta niꞌi. Aꞌte buꞌpapijaro nirṍ ʉ̃sãrẽ ejatuatisaꞌa. Mejõ cananeo masã opa paꞌtiro nirõpʉ nirã́ peꞌe pejepawʉ cabayua wejesepawʉ cõme meꞌrã weeꞌquepawʉre cʉoma. Bet-seã́pʉ nirã́, to sumuto nise nirã́, tojo nicã Jezreel opa paꞌtiro nirã́ quẽꞌrã mejãrõta cʉoma, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Na tojo nicã tʉꞌogʉ, Josué José pãrãmerã nituriarã Efraĩ́, Manasés ya curuacjãrãrẽ nicʉ niwĩ: —Diacjʉ̃ta mʉsã pãjãrã, tutuarã niꞌi. Tojo weerã niꞌcã diꞌta diaꞌcʉ̃ cʉomasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Opa buꞌpapijaro, yucʉpagʉ peje nirṍ quẽꞌrã mʉsã ye nirõsaꞌa. Mʉsã tepagʉre paacõꞌa, noꞌocãꞌrõ mʉsã paacõꞌarõ põtẽorõ te mʉsã ye diꞌta nirõsaꞌa. Sõjã cananeo masã, cõme meꞌrã weeꞌquepawʉre cʉomicã, na tutuamicã, narẽ nʉrʉ̃stewĩrõmasĩrãsaꞌa, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Israe curuacjãrã ti diꞌtacjãrãrẽ docaqueꞌacã wééca beꞌrore nipeꞌtirã Silo macãpʉ nerẽcãrã niwã. Topʉta Õꞌacʉ̃ wiꞌi, waꞌicʉrã caseri meꞌrã wééca wiꞌire apo, nerẽwʉacãrã niwã. Ti wiꞌi Õꞌacʉ̃rẽ na ẽjõpeo, ucũrĩ wiꞌi nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Titare siete curari na diꞌta oꞌo, dʉcawaasere ñeꞌeticãrã niwã yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Tojo weegʉ Josué Israe curuacjãrãrẽ nicʉ niwĩ: “¿Noꞌocãꞌrõ yoacã te diꞌtare mʉsã ñeꞌerãtirã coꞌterãsari? Te diꞌta Õꞌacʉ̃ mʉsã ñecʉ̃sʉmʉa ẽjõpeogʉ mʉsãrẽ oꞌoꞌque niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Te curarinʉcʉ̃ iꞌtiarã ʉmʉa bese, oꞌóya. Yʉꞌʉ narẽ na ye diꞌta ‘To nitʉoꞌo’, ni ĩꞌabesedutigʉ, oꞌógʉtigʉ weeꞌe. Na ĩꞌáca beꞌro ‘Tocãꞌrõ ʉ̃sã ye diꞌta nitʉopʉ’, ni ojarãsama. Tuꞌajanʉꞌcõ, dajatojatirã, ");
INSERT INTO tuoNT_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","siete diꞌta dʉcawaanʉꞌcõato. Judá ya curuacjãrã ye diꞌta sur peꞌe tojarosaꞌa. José ya curuacjãrã nituriarã ye diꞌta peꞌe norte peꞌe tojarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Mʉsã siete diꞌtare dʉcawááca beꞌro yʉꞌʉre te ojaꞌquere miitia. Beꞌro yʉꞌʉ marĩ wiogʉ Õꞌacʉ̃ ĩꞌorõpʉ bese, níbocase meꞌrã mʉsãrẽ ‘Topʉ tojarã́saꞌa’, ni cũugʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","‘Leví ya curuacjãrã pũrĩcã ne cãꞌrõ diꞌta ñeꞌesome’ nisere masĩtojasama. Te ñeꞌerõnojõ oꞌorã, náma Õꞌacʉ̃ ye cjasere daꞌratje nirõsaꞌa. Tojo nicã Gad, Rubén, deco meꞌrã nirã́ Manasés ya curuacjãrã pũrĩcã na ye diꞌta niatjere ñeꞌetojacãrã niwã. Na ye diꞌta Jordã́ mujĩpũ mʉjãtiro ape pãꞌrẽ peꞌe niꞌi. Moisé Õꞌacʉ̃ ʉaro weecoꞌtegʉ te diꞌtare narẽ oꞌotojacʉ niwĩ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Na ʉmʉa te diꞌtare añurõ ĩꞌabese, “To niapʉ” ni, na aporã waꞌarãtirã weeri cura Josué peꞌe aꞌtiro weeduticʉ niwĩ: “Nipeꞌtiro aꞌti diꞌtare ĩꞌasijabiꞌarã waꞌa, ‘Aꞌtiro bajuri diꞌta niꞌi’, ni ojarã waꞌaya. Tuꞌajanʉꞌcõ, yʉꞌʉ tiropʉ tojatia. Beꞌro aꞌti macã Silopʉ Õꞌacʉ̃rẽ ‘¿Deꞌro wee aꞌti diꞌtare níbocase meꞌrã dʉcawaagʉsari?’, ni sẽrĩgʉ̃ti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Tojo weerã na ʉmʉa Josué cʉ̃ weedutiꞌcaronojõta queoro weecãrã niwã. Na Silopʉ dajarã, ti diꞌtare na “To niapʉ” ni, na oja apoꞌquere miidajacãrã niwã. Macãrĩnʉcʉ̃rẽ “To niapʉ”, nicãrã niwã. Te na dʉcawaaꞌquere siete curari cjasere na ojaꞌquere miidajacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Topʉre Josué Õꞌacʉ̃ ĩꞌorõpʉre “¿Noarẽ te diꞌta tojarosari?” ni, níbocase meꞌrã dʉcawaacʉ niwĩ. Tojo weegʉ Israe curuacjãrãrẽ na diꞌta niatjere nanʉcʉ̃ oꞌo, dʉcawaanʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Dʉcawaanʉꞌcõ, Benjamí ya curuacjãrã na nise curarinʉcʉ̃rẽ oꞌonʉꞌcãcʉ niwĩ. Õꞌacʉ̃ “Aꞌti diꞌta narẽ oꞌoya”, ni ĩꞌóca beꞌro na niatje diꞌtare oꞌocʉ niwĩ. Te diꞌta Judá ya curuacjãrã waꞌtero, tojo nicã José ya curuacjãrã waꞌtero tojacaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Benjamí ya curuacjãrã beꞌrore Simeó ya curuacjãrã na niatje diꞌtare oꞌocʉ niwĩ. Te curarinʉcʉ̃ oꞌonoꞌcãrã niwã. Te diꞌta Judá ya diꞌta waꞌteropʉ tojacaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Na pʉa curuacjãrã beꞌrore Zabulṍ ya curuacjãrã, na niatje diꞌtare oꞌocʉ niwĩ. Ti diꞌta téé Sarid wãmetiri macãpʉ nitʉocaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Na iꞌtia curua beꞌrore Isacar ya curuacjãrãrẽ, na niatje diꞌtare oꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Te baꞌparitise curaricjãrã beꞌrore Aser ya curuacjãrãrẽ, na niatje diꞌtare oꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Niꞌcãmocʉse curaricjãrã beꞌrore Neftalí ya curuacjãrãrẽ, na niatje diꞌtare oꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Seis curaricjãrã beꞌrore Dan ya curuacjãrãrẽ, na niatje diꞌtare oꞌocʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","50","Beꞌro te diꞌtare etíca beꞌro, Israe curuacjãrã Õꞌacʉ̃ dutiꞌcaronojõta Josuére cʉ̃ niatji macãrẽ oꞌocãrã niwã. Ti macã cʉ̃ sẽrĩ́ca macã Timnat-sera, Efraĩ́ ya diꞌta opa buꞌpapijaropʉ nicaro niwʉ̃. Topʉ ti macãrẽ apaturi apo, niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Aꞌtiro wee paꞌi Eleazar, Josué, tojo nicã nipeꞌtise curaricjãrã wiorã te diꞌtare dʉcawaanʉꞌcõcãrã niwã. Silopʉ Õꞌacʉ̃ wiꞌi, suꞌti caseri meꞌrã wééca wiꞌi sope pʉꞌtopʉ “Õꞌacʉ̃, ¿noanojõrẽ ti diꞌta tojarosari?” níbocaca beꞌropʉ eticãrã niwã. Tojo weero na etiꞌque queoro dʉcawaanʉꞌcõnoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Õꞌacʉ̃ Josuére aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Mʉꞌʉ Israe curuacjãrãrẽ mʉsã duꞌti nisetiatje macãrĩrẽ besedutiya. Yʉꞌʉ Moisére weedutiꞌcaronojõta weeya. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Tojo weeyucã, noꞌo wãcũña marĩrõ apĩrẽ wẽjẽgʉ̃nojõ te macãrĩpʉ duꞌtiwãꞌcãmasĩsami. Tojo weegʉ wẽjẽnoꞌcʉ acaweregʉ waro cʉ̃rẽ wẽjẽaꞌmerĩ nígʉ̃, topʉ duꞌti, nicãꞌmasĩsami. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Tojo wee masʉ̃ te macãrĩpʉ duꞌtiagʉnojõ ne sãjãrĩ sopepʉ etagʉ, tocjãrã bʉcʉrãrẽ ‘Tojo weeasʉ’, ni weregʉsami. Tojo wééca beꞌro bʉcʉrã ‘Aꞌto tojayá’, nirãsama. Tojo nicã, cʉ̃ nisetiatji wiꞌire cũurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Wẽjẽꞌcʉre wẽjẽaꞌmerĩ masʉ̃ cʉ̃rẽ ti macãpʉ sirutucãma, na bʉcʉrã cʉ̃rẽ nʉo cʉorãsama. Cʉ̃ uase, wãcũña marĩrõ ‘Tojo weeapʉ’ ni wéréca beꞌro niyucã, tojo waꞌarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Na weresãnoꞌcʉ ti macãpʉ duꞌti, nicãꞌbosami téé nipeꞌtirã ti macãcjãrã masã nerẽ beséca beꞌro yʉꞌrʉwetigʉsami. Tojo nicã paꞌia wiogʉ cʉ̃ wẽrĩcãpʉ topʉ nitʉogʉsami. Aꞌtiro waꞌáca beꞌro cʉ̃, cʉ̃ ya wiꞌipʉ, cʉ̃ ya macã, cʉ̃ uiwijaca macãpʉ dajagʉsami tja”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Õꞌacʉ̃ Josuére tojo nicã tʉꞌorã, na duꞌti niatje macãrĩ Galileapʉ nirĩ macã Quedes wãmetiri macãrẽ besecãrã niwã. Ti macã Neftalí ye diꞌta ʉ̃rʉ̃pagʉ pijaropʉ tojacaro niwʉ̃. Ape macã Siquem Efraĩ́ ye diꞌta ʉ̃rʉ̃pagʉ pijaropʉ tojacaro niwʉ̃. Nitʉori macãpʉa majã Quiriat-arba nicaro niwʉ̃. Ti macãrẽta tja na Hebrṍ pisusama. Judá ye diꞌta ʉ̃rʉ̃pagʉ pijaropʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Mujĩpũ mʉjãtiro dia Jordã́ siaquiji peꞌema iꞌtia macã na duꞌti niatje macãrĩrẽ besecãrã niwã. Nimʉꞌtãrĩ macã Beser nicaro niwʉ̃. Ti macã Rubén ye diꞌta opa buꞌpa, yucʉ marĩrõpʉ tojacaro niwʉ̃. Ape macã Ramot, Galaad na ninoꞌrõpʉ, Gad ye diꞌtapʉ tojacaro niwʉ̃. Nitʉori macãpʉa Golán nicaro niwʉ̃. Basán na ninoꞌrõpʉ Manasés ya curuacjãrã nirõpʉ tojacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Tojo weerã nipeꞌtirã Israe curuacjãrã, tojo nicã apesecjãrã na meꞌrã nirã́ noꞌo wãcũña marĩrõ wẽjẽgʉ̃nojõ te macãrĩpʉ duꞌtita basiocaro niwʉ̃. Na te macãrĩcjãrã pãjãrã nerẽ beseatji dʉporo tojo weeta basiocaro niwʉ̃. Tojo weeticãma, cʉ̃rẽ wẽjẽaꞌmebosama nírã, tojo weenoꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","2","Leví ya curuacjãrã wiorã Silopʉ paꞌia wiogʉ Eleazar, Josué, ãpẽrã Israe curuacjãrã wiorã meꞌrã ucũrã waꞌacãrã niwã. Silo Canaá diꞌtapʉ nicaro niwʉ̃. Topʉ Leví ya curuacjãrã wiorã narẽ aꞌtiro nicãrã niwã: “Õꞌacʉ̃ Moisé meꞌrã ʉ̃sãrẽ ʉ̃sã niatje macãrĩrẽ oꞌoduticʉ niwĩ. Tojo nicã, diꞌta te macãrĩ sumutopʉ ʉ̃sã waꞌicʉrãrẽ eca nisetiatjere oꞌoduticʉ niwĩ”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Tojo nicã tʉꞌorã, Õꞌacʉ̃ cʉ̃ dutiꞌcaronojõta Israe curuacjãrã na ye diꞌta cʉoꞌquere Leví ya curuacjãrãrẽ queoro oꞌocãrã niwã. Tere oꞌorã, macãrĩ, tojo nicã cãpũpʉ na waꞌicʉrãrẽ eca nisetiatjere oꞌocãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Tojo weerã Israe curuacjãrã ye diꞌtapʉre Leví ya curuacjãrã cuarenta y ocho macãrĩ, tojo nicã na cãpũpʉ waꞌicʉrãrẽ eca nisetiajere ñeꞌecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Te macãrĩ nipeꞌtisepʉreta tja sumutopʉ waꞌicʉrã na eca nisetiatje diꞌta nibajaqueꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Õꞌacʉ̃ nipeꞌtise na ñecʉ̃sʉmʉarẽ “Aꞌtiro oꞌogʉti” níꞌque diꞌtare queoro oꞌocʉ niwĩ. Tojo weerã na te diꞌtare ñeꞌe, topʉ niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Tere wéégʉ, nipeꞌtise Õꞌacʉ̃ cʉ̃ “Weegʉti” níꞌquere queorota weecʉ niwĩ. Nipeꞌtiro ti diꞌtapʉ narẽ soose oꞌocʉ niwĩ. Õꞌacʉ̃ weetamurõ meꞌrã Israe curuacjãrã narẽ ĩꞌatuꞌtirãrẽ docaqueꞌacã weecʉ niwĩ. Tojo weerã Israe curuacjãrãrẽ ne mejẽcã weemasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Õꞌacʉ̃ nipeꞌtise cʉ̃ “Weegʉti” níꞌquere queorota weecʉ niwĩ. Ne niꞌcãrõ weedʉꞌa weeticʉ niwĩ; weepeꞌocãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Beꞌro ti diꞌtare etipeꞌotoja, Josué Rubén ya curuacjãrãrẽ, Gad ya curuacjãrãrẽ, tojo nicã Manasés ya curuacjãrã deco meꞌrã nirãrẽ piji, narẽ ");
INSERT INTO tuoNT_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","nicʉ niwĩ: “Mʉsã nipeꞌtise Moisé, Õꞌacʉ̃ dutisere daꞌracoꞌtegʉ cʉ̃ dutiꞌquere queoro weeapʉ. Tojo nicã nipeꞌtise yʉꞌʉ mʉsãrẽ weedutiꞌquere weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Ne niꞌcãti mʉsã acawererã Israe curuacjãrãrẽ cõꞌawãꞌcã weetiapʉ. Narẽ weetamunuꞌcũcãꞌpʉ. Niꞌcãrõacã quẽꞌrãrẽ na meꞌrã ninuꞌcũꞌu yujupʉ. Tojo nicã nipeꞌtise Õꞌacʉ̃, mʉsã wiogʉ cʉ̃ dutisere añurõ weepeꞌoapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Niꞌcãrõacãma Õꞌacʉ̃ cʉ̃ ‘Tojo weegʉti’ níꞌquere queoro weeami. Tojo weegʉ mʉsã acawererãrẽ soocã weeami. Tojo weerã mʉsã ye diꞌta Moisé, Õꞌacʉ̃ dutisere daꞌracoꞌtegʉ, mʉsãrẽ oꞌoꞌque diꞌta, Jordã́ ape pãꞌrẽpʉ nisepʉ dajatojaaya majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Aꞌte diaꞌcʉ̃ mʉsã weecã ʉasaꞌa. Moisé cʉ̃ dutiꞌquere queoro weeya. Õꞌacʉ̃ marĩ wiogʉre maꞌi nisetiya. Cʉ̃rẽ sirutu, cʉ̃ dutisere queoro weeya. Nipeꞌtise mʉsã ẽjõpeose meꞌrã, mʉsã wãcũse meꞌrã cʉ̃ ʉaro weenuꞌcũcãꞌña”, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Narẽ werepeꞌotoja, “Õꞌacʉ̃ mʉsãrẽ añurõ weeato” ni, “Mʉsã ye wiꞌseripʉ dajatojaaya”, nicʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Cʉ̃ tojo níca beꞌro Rubén ya curuacjãrã, Gad ya curuacjãrã, Manasés ya curuacjãrã deco meꞌrã nirã́ ãpẽrã Israe curuacjãrã Silopʉ nirã́, Canaá diꞌtapʉre aꞌmerĩ duꞌu, dʉcawati, na ya diꞌta Galaad, dia Jordã́ apese pãꞌrẽpʉ pẽꞌapeꞌtia waꞌacãrã niwã. Dʉporopʉ te diꞌta Õꞌacʉ̃ Moisé meꞌrã “Mʉsãrẽ oꞌogʉti” níꞌque diꞌta nicaro niwʉ̃. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Peje cʉ̃ꞌmarĩ Õꞌacʉ̃ Israe curuacjãrãrẽ narẽ ĩꞌatuꞌtirã meꞌrã aꞌmewẽjẽ, soo nisetica beꞌro yʉꞌrʉcaro niwʉ̃. Titare Josué bʉcʉ ẽjãgʉ̃, ");
INSERT INTO tuoNT_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","nipeꞌtirã Israe curuacjãrã bʉcʉrãrẽ, wiorãrẽ, beseri masãrẽ pijionʉꞌcõ, narẽ werecasatʉocʉ niwĩ. Aꞌtiro nicʉ niwĩ: “Yʉꞌʉ bʉcʉ waro ẽjãꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Mʉsã nipeꞌtise Õꞌacʉ̃ aꞌti diꞌtacjãrã mʉsãrẽ ĩꞌatuꞌtirã weeꞌquere ĩꞌapã. Cʉ̃ta mʉsã ye niatjere aꞌmewẽjẽtamuwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Yʉꞌʉ mʉsã nipeꞌtirãrẽ to diꞌta níbocase meꞌrã nipeꞌtise curarire Õꞌacʉ̃ ĩꞌorõpʉ dʉcawaawʉ. Yʉꞌʉ mʉsã te diꞌtare aꞌmewẽjẽ wapataꞌaꞌquere dʉcawaawʉ. Tojo nicã apeye diꞌta aꞌmewẽjẽ wapataꞌanoꞌña marĩꞌque quẽꞌrãrẽ dʉcawaawʉ. Mujĩpũ mʉjãtiro dia Jordã́ meꞌrã nʉꞌcã, téé mujĩpũ sãjãrõ maajo Mediterráneo meꞌrãpʉ dʉcawaatʉowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Õꞌacʉ̃ masã te diꞌtapʉ nirãrẽ cõꞌawĩrõgʉ̃sami. Mʉsã peꞌe te diꞌtare miiwaparãsaꞌa. Õꞌacʉ̃ mʉsã wiogʉ cʉ̃ ‘Tojo weegʉti’ níꞌcaronojõta weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","”Tojo weerã wãcũtutuaya. Nipeꞌtise Moisé ojaꞌquere, cʉ̃ dutise cũuꞌquere queoro weemeꞌrĩcãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Mʉsã ãpẽrã masã, cõꞌawĩrõnoꞌña marĩrã aꞌti diꞌtapʉ dʉꞌsarã meꞌrã ne aꞌmesʉꞌaticãꞌña. Na ẽjõpeorãrẽ Õꞌacʉ̃ nitirãrẽ ne cãꞌrõacã ẽjõpeo, ejaqueꞌaticãꞌña. Na wãmerẽ pisu, wãmepeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Õꞌacʉ̃ niꞌcʉ̃rẽta cʉ̃ ʉaro wee, ẽjõpeonuꞌcũcãꞌña. Mʉsã niꞌcãrõacã weronojõta tojota añurõ weeyapaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Õꞌacʉ̃ peje curaricjãrãrẽ na tutuamicã, mʉsã ĩꞌorõpʉ cõꞌawĩrõwĩ. Aꞌtocateropʉ quẽꞌrãrẽ ne niꞌcã curua mʉsãrẽ aꞌmewẽjẽpõtẽoweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Õꞌacʉ̃ cʉ̃ níꞌcaronojõta mʉsãrẽ aꞌmewẽjẽtamuwĩ. Tojo weegʉ cʉ̃ weetamuse meꞌrã mʉsã meꞌrãcjʉ̃ niꞌcʉ̃ mil masãrẽ nʉrʉ̃stemasĩsami. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Tojo weerã mʉsã tʉꞌomasĩña. Õꞌacʉ̃ mʉsã wiogʉre queoro maꞌinuꞌcũcãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Mʉsã Õꞌacʉ̃ dutisere yʉꞌrʉnʉꞌcã, na mʉsã waꞌteropʉ dʉꞌsarã meꞌrã aꞌmesʉꞌa, nʉmoticã pũrĩcãrẽ, ");
INSERT INTO tuoNT_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","Õꞌacʉ̃ marĩ wiogʉ narẽ cõꞌanemosome majã. Na dʉꞌsarã mʉsãrẽ ñaꞌarõ waꞌacã weerãsama. Aꞌti diꞌta añurĩ diꞌta Õꞌacʉ̃ marĩrẽ oꞌóca diꞌtare ẽꞌmagʉ̃sami. Aꞌti diꞌtapʉre ninemosome majã. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","”Masã nipeꞌtirã wẽrĩwʉaronojõ cãꞌrõacã beꞌro yʉꞌʉ wẽrĩgʉ̃saꞌa. Mʉsã ẽjõpeose meꞌrã, mʉsã wãcũse meꞌrã Õꞌacʉ̃ cʉ̃ queoro weeꞌquere añurõ masĩꞌi. Ne niꞌcãrõ Õꞌacʉ̃ marĩ wiogʉ cʉ̃ ‘Añurõ weegʉti’ níꞌquere weeticã weetiwĩ. Nipeꞌtisere weepeꞌocãꞌwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Mʉsã cʉ̃rẽ yʉꞌrʉnʉꞌcãcã pũrĩcã, cʉ̃ mʉsãrẽ añurõ weeꞌcaro weronojõ mejãrõta peje ñaꞌase mʉsãrẽ waꞌacã weegʉsami. Ne niꞌcʉ̃ aꞌti diꞌta añurĩ diꞌta, marĩrẽ oꞌóca diꞌtapʉ tojasome. ");
INSERT INTO tuoNT_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Mʉsã Õꞌacʉ̃ marĩ wiogʉ meꞌrã apoꞌquere yʉꞌrʉnʉꞌcãcã, ãpẽrãnojõrẽ ejaqueꞌa ẽjõpeocã, Õꞌacʉ̃ mʉsã meꞌrã uagʉsami. Aꞌti diꞌta añurĩ diꞌta marĩrẽ oꞌóca diꞌtapʉ ninemosome majã”, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Beꞌro Josué Siquẽpʉ nipeꞌtise curari Israe curuacjãrãrẽ neocʉ niwĩ. Bʉcʉrãrẽ, wiorãrẽ, beseri masãrẽ, masãrẽ sʉꞌori nirãrẽ pijineocʉ niwĩ. Na Õꞌacʉ̃ ĩꞌorõpʉ nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Tuꞌajanʉꞌcõ, Josué narẽ nicʉ niwĩ: —Õꞌacʉ̃ marĩ Israe curuacjãrã wiogʉ aꞌtiro nimi: “Dʉporopʉre mʉsã ñecʉ̃sʉmʉa Taré, tojo nicã cʉ̃ põꞌrã Abrahã, Nacor dia Éufrates wãmetiri maa yʉꞌrʉropʉ nisetiwã. Topʉ nírã, ãpẽrãnojõrẽ ẽjõpeosetiwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Mʉsã ñecʉ̃ Abrahã ti maa yʉꞌrʉropʉ níꞌcʉre, mia weetjĩagʉ̃, nipeꞌtiro aꞌto Canaá diꞌtapʉ sʉꞌori sijawʉ. Cʉ̃rẽ pãjãrã masãputicã weewʉ. Cʉ̃ ne waro põꞌrãtigʉre Isaare oꞌowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Cʉ̃ Isaare tja cʉ̃ põꞌrã pʉarã Jacob, Esaúre oꞌowʉ. Esaúre diꞌta opa buꞌpapijaro Seir wãmetiri diꞌtare cũuwʉ̃. Jacob peꞌe cʉ̃ põꞌrã meꞌrã Egiptopʉ buꞌawã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","”Beꞌro Moisére, Aarṍrẽ to Egiptopʉta oꞌówʉ. Yʉꞌʉ tutuaro meꞌrã weeꞌquere tocjãrã Egiptocjãrãrẽ ñaꞌarõ waꞌacã weewʉ. Tuꞌajanʉꞌcõ, mʉsãrẽ topʉ níꞌcãrãrẽ miiwijawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Mʉsã ñecʉ̃sʉmʉa Egiptopʉ wijacã, Egiptocjãrã na yarã cabayua meꞌrã, na cabayua wejesepawʉ meꞌrã narẽ wẽjẽsĩꞌrĩrã sirutuwã. Téé Maa sõꞌarĩ maa tiropʉ sirututʉowã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Mʉsã ñecʉ̃sʉmʉa yʉꞌʉ weetamusere ʉarã, yʉꞌʉre sẽrĩwã. Na tojo weecã, yʉꞌʉ Egiptocjãrãrẽ cãꞌmotaꞌadutigʉ, Israe curuacjãrã, Egiptocjãrã decopʉ naꞌitĩꞌasere cũuwʉ̃. Tojo weerã Egiptocjãrã narẽ ĩꞌabocatiwã. Tojo nicã, Egiptocjãrã maarẽ pẽꞌarĩ curare, narẽ mirĩcã weewʉ. Mʉsã basu yʉꞌʉ Egiptocjãrãrẽ weeꞌquere ĩꞌamiwʉ̃ba. ”Mʉsã Egiptopʉ wijáca beꞌro peje cʉ̃ꞌmarĩ yucʉ marĩrõpʉre nicãꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Beꞌro mʉsãrẽ amorreo masã ya diꞌta, dia Jordã́ mujĩpũ mʉjãtiropʉ miipẽꞌatiwʉ. Topʉ mʉsã meꞌrã aꞌmewẽjẽmiwã. Yʉꞌʉ peꞌe mʉsãrẽ narẽ docaqueꞌacã weewʉ. Tojo weerã na ye diꞌta nimiꞌquere mʉsã miiwapawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Beꞌro Balac, Zipor, moabita masã wiogʉ macʉ̃, mʉsã meꞌrã aꞌmewẽjẽsĩꞌrĩmiwĩ. Balac apĩ Balaã, Beor macʉ̃rẽ mʉsãrẽ dojadutigʉ pijidutiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Yʉꞌʉ peꞌe Balaã mʉsãrẽ dojasĩꞌrĩcã, cãꞌmotaꞌawʉ. Mʉsãrẽ dojaronojõ oꞌogʉ, ‘Narẽ añurõ waꞌato’ ni, yʉꞌʉre sẽrĩwĩ. Tojo wee mʉsãrẽ yʉꞌrʉweticã weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","”Beꞌro mʉsã dia Jordã́rẽ pẽꞌawʉ̃. Pẽꞌaa, Jericópʉ etawʉ. Ti macãcjãrã mʉsã meꞌrã aꞌmewẽjẽmiwã. Tojo nicã, ãpẽrã ti diꞌtacjãrã amorreo, ferezeo, cananeo, hitita, gergeseo, heveo, jebuseo masã mejãrõta mʉsã meꞌrã aꞌmewẽjẽwã. Yʉꞌʉ mʉsãrẽ nipeꞌtirãrẽ docaqueꞌacã weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Sõjã amorreo masã wiorã pʉarãrẽ mʉsã diꞌpjĩrĩ, bʉacatjẽ meꞌrã docaqueꞌacã weetiwʉ. Yʉꞌʉ peꞌe narẽ uise daꞌrewʉ. Tojo weerã mʉsã na tiropʉ etati dʉporo uiwãꞌcãtojawã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Mʉsã diꞌtare daꞌratimicã, ãpẽrã na daꞌraꞌque diꞌtapʉre mʉsãrẽ oꞌowʉ. Tojo nicã macãrĩ mʉsã daꞌreꞌque mejẽtare oꞌowʉ. Mʉsã te macãrĩpʉ niseti, ʉꞌse weseri, tojo nicã olivo weseri mʉsã otetiꞌque dʉcare baꞌaꞌa”, ni werecʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Beꞌro Josué aꞌtiro ninemocʉ niwĩ: —Tere wãcũrã, wiopesase meꞌrã, diacjʉ̃ nise meꞌrã, Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro weeya. Õꞌacʉ̃ nitirãrẽ marĩ ñecʉ̃sʉmʉa dia Éufrates yʉꞌrʉropʉ, tojo nicã Egiptopʉ ẽjõpeoꞌcãrãrẽ ẽjõpeoduꞌu, cõꞌacãꞌña. Õꞌacʉ̃ diaꞌcʉ̃rẽ ẽjõpeoya. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Mʉsã Õꞌacʉ̃rẽ ẽjõpeo sirututʉꞌsatirã pũrĩcã, mʉsã basu ẽjõpeoajãrẽ beseya. Marĩ ñecʉ̃sʉmʉa Éufrates yʉꞌrʉropʉ ẽjõpeoꞌcãrãrẽ, o amorreo masã, aꞌti diꞌtapʉ nirã́ na ẽjõpeorãrẽ ẽjõpeosĩꞌrĩrã, narẽ beseya. Yʉꞌʉ pũrĩcã, ya wiꞌicjãrã quẽꞌrã Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro weerãsaꞌa, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Cʉ̃ tojo nicã tʉꞌorã, masã aꞌtiro ni yʉꞌticãrã niwã: —Ʉ̃sã Õꞌacʉ̃rẽ ẽjõpeoduꞌusome. Ãpẽrã Õꞌacʉ̃ nitirã peꞌema ne ẽjõpeosirutusome. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Marĩ wiogʉ Õꞌacʉ̃ cʉ̃ta marĩrẽ, marĩ ñecʉ̃sʉmʉa Egiptopʉ ñaꞌarõ yʉꞌrʉꞌcãrãrẽ miiwijawĩ. Cʉ̃ta tja cʉ̃ tutuaro meꞌrã añuse cʉ̃ tutuasere weeĩꞌowĩ. Nipeꞌtiro ʉ̃sã maꞌapʉ aꞌtiꞌquere, peje macãrĩcjãrã waꞌteropʉ yʉꞌrʉꞌquere mejẽcã waꞌari nígʉ̃, coꞌtewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Cʉ̃ marĩ waꞌacã, nipeꞌtise macãrĩcjãrãrẽ cõꞌawĩrõcãꞌwĩ. Amorreo masã, aꞌti diꞌtacjãrãpʉreta tojo weewĩ. Ʉ̃sã quẽꞌrã mʉꞌʉ weronojõta Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro weerãsaꞌa. Cʉ̃ta marĩ wiogʉ nimi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Na tojo nicã tʉꞌogʉ, Josué aꞌtiro nicʉ niwĩ: —Mʉsã Õꞌacʉ̃rẽ añurõ ẽjõpeo, sirutupõtẽosome. Cʉ̃ añugʉ̃ waro, ñaꞌase moogʉ̃ nimi. Cʉ̃ diaꞌcʉ̃rẽ marĩ ẽjõpeocã ʉami. Ãpẽrãnojõrẽ ẽjõpeocã, doesami. Mʉsã cʉ̃rẽ yʉꞌrʉnʉꞌcãcã, mʉsã ñaꞌarõ weesere nʉꞌcãsome. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Mʉsã Õꞌacʉ̃rẽ ẽjõpeoduꞌu, ãpẽrãrẽ ẽjõpeocã, cʉ̃ta mʉsãrẽ ñaꞌarõ waꞌacã weegʉsami. Mʉsãrẽ añurõ wééꞌcʉ nimigʉ̃, mʉsãrẽ cõꞌapeꞌogʉsami, nicʉ niwĩ Josué. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Masã Josuére aꞌtiro ni yʉꞌticãrã niwã: —Mʉꞌʉ tojo nírõnojõ waꞌasome. Ʉ̃sã Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Na tojo nisere tʉꞌogʉ, Josué nicʉ niwĩ: —Mʉsã basu nipeꞌtirã tʉꞌoropʉ “Õꞌacʉ̃rẽ ẽjõpeo siruturãti”, niapʉ. Masã “Tojota niapʉ”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Josué narẽ aꞌtiro ninemocʉ niwĩ: —To pũrĩcãrẽ ãpẽrãnojõ mʉsã ẽjõpeo yeeꞌquere mʉsã waꞌteropʉ cʉosere cõꞌapeꞌocãꞌña. Õꞌacʉ̃ marĩ Israe curuacjãrã wiogʉre nipeꞌtise mʉsã añuse wãcũse meꞌrã ẽjõpeoya. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Masã Josuére aꞌtiro yʉꞌticãrã niwã tja: —Ʉ̃sã Õꞌacʉ̃ marĩ wiogʉre ẽjõpeo, siruturãti. Cʉ̃ dutiro weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Ti nʉmʉta topʉ Siquẽpʉ Josué masã meꞌrã “Aꞌtiro weegʉti”, ni apocʉ niwĩ. Narẽ na weesetiatjere, narẽ dutiatjere cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Tere Õꞌacʉ̃ dutise cʉori turipʉ ojaõꞌocʉ niwĩ. Tere ojatoja, niꞌcãgã ʉ̃tãgã pajicjare mii, yucʉgʉ encina wãmeticjʉ dʉꞌpocã Õꞌacʉ̃ “Masã meꞌrã tojo weegʉti” níꞌquere cʉori acaro tiropʉ nʉꞌcõcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Nipeꞌtirã masãrẽ aꞌtiro nicʉ niwĩ: —Aꞌtiga ʉ̃tãgã nipeꞌtise Õꞌacʉ̃ marĩrẽ ucũꞌquere tʉꞌopeꞌoꞌcaro weronojõ aꞌtopʉ tojaꞌa. Tojo weerã mʉsã Õꞌacʉ̃ dutisere yʉꞌrʉnʉꞌcã, mʉsã queoro weetisere ĩꞌonoꞌrõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Tojo nitoja, Josué masãrẽ, na ye diꞌtapʉ nanʉcʉ̃rẽ dajatojaaduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Cãꞌrõacã beꞌro Josué, Nun macʉ̃, Õꞌacʉ̃ dutisere daꞌracoꞌtegʉ, ciento diez cʉ̃ꞌmarĩ cʉogʉ, wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Cʉ̃ ya diꞌta Timnat-sera wãmetiri macãpʉ cʉ̃rẽ yaacãrã niwã. Ti macã buꞌpapijaro Efraĩ́, ʉ̃rʉ̃gʉ̃ Gaas wãmeticjʉ yʉꞌrʉropʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Josué catiri curare, Israe curuacjãrã Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro weecãrã niwã. Cʉ̃ wẽ́rĩ́ca beꞌro bʉcʉrã nipeꞌtise Õꞌacʉ̃ Israe curuacjãrãrẽ añurõ weeꞌquere masĩrã catiro põtẽorõ tojota Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ dutiro añurõ weesirutucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","José mijĩ cʉ̃ õꞌarĩ nimiꞌquere Siquẽpʉ yaacãrã niwã. Te õꞌarĩ Egiptopʉ Israe curuacjãrã na miitiꞌque nicaro niwʉ̃. Diꞌta José pacʉ mijĩ Jacob cʉ̃ duuꞌque diꞌta nicaro niwʉ̃. Ti diꞌta cien cujiri plata wãmetise cujiri Hamor põꞌrã ʉmʉarẽ duucʉ niwĩ. Hamor, Siquem pacʉ nicʉ niwĩ. Beꞌro ti diꞌta José pãrãmerã nituriarã ya diꞌta tojaturiacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Beꞌro paꞌi Eleazar, Aarṍ macʉ̃ wẽrĩa waꞌacʉ niwĩ. Cʉ̃ wẽrĩcã, cʉ̃ macʉ̃ Finees ya diꞌtapʉ yaacãrã niwã. To Efraĩ́ ya diꞌta opa buꞌpapijaropʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Josué wẽ́rĩ́ca beꞌro Israe curuacjãrã Õꞌacʉ̃rẽ aꞌtiro ni sẽrĩtiñaꞌcãrã niwã: —¿Ʉ̃sã waꞌtero nirã́ Israe curuacjãrã dinojõ curuacjãrã cananeo masã meꞌrã aꞌmewẽjẽrã waꞌamʉꞌtãrãsari? ");
INSERT INTO tuoNT_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Õꞌacʉ̃ narẽ aꞌtiro ni yʉꞌticʉ niwĩ: —Judá ya curuacjãrã waꞌamʉꞌtãrãsama. Yʉꞌʉ aꞌti diꞌtare narẽ oꞌotojapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Cʉ̃ tojo nicã tʉꞌorã, Judá ya curuacjãrã ʉmʉa na maꞌmisʉmʉa Simeó ya curuacjãrãrẽ pijineocãrã niwã. Narẽ aꞌtiro nicãrã niwã: “Teꞌa, ʉ̃sã ya diꞌta niatjopʉ waꞌarã. Cananeo masãrẽ aꞌmewẽjẽtamurã aꞌtia. Beꞌro ʉ̃sã quẽꞌrã mʉsã ya diꞌta niatjore mʉsã meꞌrã aꞌmewẽjẽtamurã waꞌarãsaꞌa”, nicãrã niwã. Na tojo nicã tʉꞌorã, Simeó ya curuacjãrã, “Jaʉ, cananeo masãrẽ mʉsã meꞌrã aꞌmewẽjẽtamurã waꞌarãsaꞌa”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Tojo weerã Judá ya curuacjãrã na acawererã Simeó ya curuacjãrã meꞌrã cananeo masãrẽ, tojo nicã ferezeo masã meꞌrã aꞌmewẽjẽ, na ye diꞌta nimiꞌquere ẽꞌmacãrã niwã. Õꞌacʉ̃ cʉ̃ tutuaro meꞌrã tojo weecãrã niwã. Bezepʉre diez mil ʉmʉarẽ wẽjẽcãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Õꞌacʉ̃ Judá ya curuacjãrã meꞌrã nicʉ niwĩ. Tojo weerã na diꞌta opa buꞌpapijaro nirãrẽ cõꞌawĩrõ, ẽꞌmacãrã niwã. Tojo weemirã, opa paꞌtiro nirã́ peꞌere cõꞌawĩrõmasĩticãrã niwã. Na cabayua wejesepawʉ cõme meꞌrã weeꞌquepawʉ cʉocã ĩꞌarã, tojo weemasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Moisé Calere níꞌcaronojõta Hebrṍ wãmetirore oꞌocãrã niwã. Cale iꞌtiarã Anac põꞌrãrẽ cõꞌawĩrõcãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Benjamí ya curuacjãrã peꞌe jebuseo masã, Jerusalẽ́pʉ nirãrẽ cõꞌawĩrõmasĩticãrã niwã. Tojo weerã jebuseo masã, tojo nicã Benjamí ya curuacjãrã aꞌtocaterore niꞌcãrõ meꞌrã topʉ nidecotima yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","José pãrãmerã nituriarã Betecjãrã meꞌrã aꞌmewẽjẽrãtirã, majãcãrã niwã. Na tojo weecã, Õꞌacʉ̃ narẽ weetamucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Na ĩꞌaduꞌtiri masãrẽ Betepʉre oꞌócãrã niwã. Todʉporopʉ ti macã Luz wãmeticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Na ĩꞌaduꞌtiri masã ti macãcjʉ̃ niꞌcʉ̃ wijaticã ĩꞌarã, cʉ̃rẽ nicãrã niwã: “¿Ʉ̃sã macãrẽ noꞌo peꞌe sãjãcã añubosari? Ĩꞌoña. Mʉꞌʉ tojo ĩꞌocã, mʉꞌʉrẽ añurõ coꞌterãti”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Tojo weegʉ cʉ̃ macã sãjãrõrẽ ĩꞌocʉ niwĩ. Beꞌro ti macãrẽ sãjãa, nipeꞌtirã topʉ nirãrẽ wẽjẽpeꞌocãꞌcãrã niwã. Ti macã sãjãrõrẽ ĩꞌoꞌcʉma, tojo nicã cʉ̃ acawererãrẽ wẽjẽticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Beꞌro ti macã sãjãrõrẽ ĩꞌoꞌcʉ hitita masã ya diꞌtapʉ waꞌa, topʉ niꞌcã macã pãacʉ niwĩ. Ti macãrẽ Luz wãme õꞌocʉ niwĩ. Tojota wãmetidecotisaꞌa yujupʉ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã Gilgapʉ níꞌcʉ majãa, Boquĩpʉ ejacʉ niwĩ. Israe curuacjãrãrẽ aꞌtiro nicʉ niwĩ: “Yʉꞌʉ mʉsãrẽ Egiptopʉ níꞌcãrãrẽ miiwijawʉ. Aꞌti diꞌta, mʉsã ñecʉ̃sʉmʉarẽ oꞌogʉti níꞌque diꞌtapʉ miitiwʉ. Yʉꞌʉ narẽ aꞌtiro niwʉ̃: ‘Yʉꞌʉ mʉsã meꞌrã “Aꞌtiro weegʉti” níꞌquere weeduꞌusome. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Mʉsã quẽꞌrã aꞌti diꞌtacjãrã meꞌrã apo nisetisome. Na ẽjõpeose mesãrĩrẽ ʉ̃tã meꞌrã seeneocũuꞌque mesãrĩrẽ paastedijorãsaꞌa,’ nimiwʉ̃. Mʉsã peꞌe yʉꞌʉ tojo níꞌquere weetiwʉ. ¿Deꞌro weerã mʉsã tojo weetiri? ");
INSERT INTO tuoNT_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Tojo weegʉ niꞌcãrõacãrẽ mʉsãrẽ wereꞌe. Yʉꞌʉ aꞌti diꞌtacjãrãrẽ cõꞌawĩrõnemosome. Na mʉsãrẽ cariborãsama. Tojo nicã, na ẽjõpeose meꞌrã mʉsãrẽ ñaꞌarõ waꞌacã weerãsama”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã narẽ tojo ni ucṹca beꞌro, Israe curuacjãrã nipeꞌtirã ʉpʉtʉ uti, caricũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Tojo weerã to na utirore Boquim wãme õꞌocãrã niwã. Tojo wee waꞌicʉrãrẽ wẽjẽ, Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeocãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Josué cʉ̃ nícaterocjãrãpʉ wẽrĩpeꞌtia waꞌacãrã niwã. Na beꞌrocjãrã Õꞌacʉ̃rẽ, tojo nicã cʉ̃ Israe curuacjãrãrẽ añurõ weeꞌquere masĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Na noꞌo nirã́ Baal wãmetirã queosere ẽjõpeocãrã niwã. Õꞌacʉ̃ ĩꞌorõpʉre na tojo weese ñaꞌa nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Na ñecʉ̃sʉmʉa Egiptopʉ níꞌcãrãrẽ wĩorẽꞌcʉ peꞌema ẽjõpeoduꞌucãrã niwã. Na ye macãrĩ pʉꞌtocjãrã ẽjõpeorãnojõrẽ sirutu, ẽjõpeosirutucãrã niwã. Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ pũrõ uacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Cʉ̃rẽ ẽjõpeoduꞌu, ãpẽrãnojõ Baal queose, tojo nicã Astarté queose yeeꞌquere ẽjõpeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Tojo wee Õꞌacʉ̃ na meꞌrã uagʉ, yajari masã na oteꞌquere, na ye nimiꞌquere yajapeꞌocã weecʉ niwĩ. Tojo nicã, narẽ ĩꞌatuꞌtirã na tiro nirãrẽ na meꞌrã aꞌmewẽjẽ, põtẽoticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Cʉ̃ narẽ níꞌcaronojõ nipeꞌtisetiri na aꞌmewẽjẽsetirinʉcʉ̃ Õꞌacʉ̃ narẽ ñaꞌarõ waꞌacã weecʉ niwĩ. Tojo weerã na pũrõ piꞌeticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Na tojo piꞌeticã ĩꞌagʉ̃, Õꞌacʉ̃ narẽ sʉꞌori nisetiri masãrẽ cũunʉꞌcãcʉ niwĩ. Na meꞌrã Israe curuacjãrãrẽ ñaꞌarõ wee yajarãrẽ yʉꞌrʉweticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Cʉ̃ tojo weemicã, sʉꞌori nisetiri masãrẽ tʉꞌoticãrã niwã. Ãpẽrãnojõ Õꞌacʉ̃ nitirã peꞌere ẽjõpeoseticãrã niwã. Na ñecʉ̃sʉmʉa peꞌe Õꞌacʉ̃ dutisere añurõ weecãrã niwã. Na, na weronojõ weeticãrã niwã. Maata Õꞌacʉ̃rẽ ẽjõpeoduꞌucãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Israe curuacjãrãrẽ ĩꞌatuꞌtirã narẽ ñaꞌarõ wee, pũrõ piꞌeticã weecãrã niwã. Na uti caricũsere tʉꞌogʉ, Õꞌacʉ̃ narẽ pajañaꞌcʉ niwĩ. Tojo weegʉ masãrẽ sʉꞌori nisetiacjʉre cṹúgʉ̃, cʉ̃rẽ weetamucʉ niwĩ. Cʉ̃ catiro ejatuaro masãrẽ narẽ ĩꞌatuꞌtirãrẽ yʉꞌrʉweticã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Sʉꞌori nisetiri masʉ̃ wẽ́rĩ́ca beꞌro masã apaturi ñaꞌarõ weedojacãrã niwã. Na pacʉsʉmʉa yʉꞌrʉoro ñaꞌarõ weeseti, ãpẽrãnojõ Õꞌacʉ̃ nitirãnojõrẽ ẽjõpeoseticãrã niwã. Na ñaꞌarõ weesetisere ne duꞌuti, na wãcũsere dʉcayusĩꞌrĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ Israe curuacjãrã meꞌrã pũrõ uacʉ niwĩ. Aꞌtiro nicʉ niwĩ: “Ãꞌrã na ñecʉ̃sʉmʉa meꞌrã yʉꞌʉ ‘Aꞌtiro weeya’ níꞌquere yʉꞌrʉnʉꞌcãma. Yʉꞌʉ dutisere ne tʉꞌosĩꞌrĩtima. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Tojo weegʉ Josué cʉ̃ wẽrĩse dʉporo masã cõꞌawĩrõtiꞌcãrãrẽ cõꞌawĩrõsome. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Na ñecʉ̃sʉmʉa yʉꞌʉre ẽjõpeoꞌcaronojõta ẽjõpeorãsari nígʉ̃, apeye macãrĩcjãrãrẽ cõꞌasome yujupʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Tojo weegʉ Õꞌacʉ̃ maata Josuére te macãrĩcjãrãrẽ nʉrʉ̃peꞌocã weeticʉ niwĩ. Narẽ totá tojacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Israe curuacjãrã Canaá diꞌtacjãrã meꞌrã aꞌmewẽjẽcaterore pãjãrã Israe curuacjãrã pãrãmerã bajuaticãrã niwã yujupʉ. Na yʉꞌʉre ẽjõpeorãsari nígʉ̃, ãpẽrã ti diꞌtacjãrãrẽ Õꞌacʉ̃ cõꞌawĩrõticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","Maꞌmapjia aꞌmewẽjẽmasĩtirãrẽ aꞌmewẽjẽmasĩato nígʉ̃, Canaácjãrãrẽ topʉ tojacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Ãꞌrã topʉre tojacãrã niwã: Niꞌcãmocʉrã filisteo masã wiorã, nipeꞌtirã cananeo masã, sidonio masã, heveo masã ʉ̃rʉ̃pagʉ Líbano diꞌtapʉ nirã́ Canaápʉ tojacãrã niwã. Heveo masã ʉ̃rʉ̃gʉ̃ Baal-hermón wãmeticjʉ meꞌrã téé Hamat sãjãrõpʉ meꞌrã niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Õꞌacʉ̃ “¿Israe curuacjãrã na ñecʉ̃sʉmʉarẽ Moisé meꞌrã yʉꞌʉ dutise cũuꞌquere yʉꞌtirãsari?” nígʉ̃, Canaácjãrãrẽ ti diꞌtapʉ tojacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Israe curuacjãrã ãꞌrã masã waꞌteropʉ macãrĩticãrã niwã. Cananeo masã, hitita masã, amorreo masã, ferezeo masã, heveo masã, jebuseo masã tiropʉ niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Israe curuacjãrã põꞌrã sõꞌoníꞌque macãrĩcjãrã põꞌrã meꞌrã pʉ́aperi numiso, niseticãrã niwã. Tojo weerã tocjãrã ẽjõpeorã, Õꞌacʉ̃ nitirãnojõrẽ ẽjõpeo niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Israe curuacjãrã Õꞌacʉ̃rẽ wãcũti, Baal, tojo nicã Astarté wãmetirã na queose yeeꞌquere ẽjõpeocãrã niwã. Tojo weerã Õꞌacʉ̃ ĩꞌorõpʉre ñaꞌarõ weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ na meꞌrã ua, Cusán-risataim, Mesopotamia diꞌta wiogʉre wiacʉ niwĩ. Ocho cʉ̃ꞌmarĩ Cusán-risataim dutiro docapʉ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Beꞌro na Õꞌacʉ̃ weetamusere ʉpʉtʉ sẽrĩcã tʉꞌogʉ, narẽ yʉꞌrʉoato nígʉ̃, Otoniel, Cenaz macʉ̃, Caleb acabijire oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Espíritu Santu Otoniepʉre sãjãa, Israe curuacjãrãrẽ sʉꞌori nisetiri masʉ̃ sãjãcʉ niwĩ. Cʉ̃ Cusán-risataim yarã masã meꞌrã aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. Õꞌacʉ̃ Otoniere Cusán-risataĩrẽ wapataꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Beꞌro cuarenta cʉ̃ꞌmarĩ ti diꞌtapʉre aꞌmewẽjẽse marĩcaro niwʉ̃. Téé Otoniel, Cenaz macʉ̃ cʉ̃ wẽrĩcãpʉ soose nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Otoniel wẽ́rĩ́ca beꞌro Israe curuacjãrã apaturi Õꞌacʉ̃ ĩꞌorõpʉ ñaꞌarõ weeseticãrã niwã. Tojo weegʉ Õꞌacʉ̃ Moab diꞌta wiogʉ Eglṍ wãmetigʉre Israe curuacjãrã nemorõ tutuagʉ waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Cʉ̃ Eglṍ amonita masãrẽ, tojo nicã amaleca masãrẽ aꞌmewẽjẽtamudutigʉ sẽrĩcʉ niwĩ. Tojo weerã na Israe curuacjãrã meꞌrã aꞌmewẽjẽ, Jericó opa ñorĩ nirĩ macãrẽ wapataꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Dieciocho cʉ̃ꞌmarĩ Israe curuacjãrã Eglṍ dutiro doca nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Ticʉse cʉ̃ꞌmarĩ beꞌro Israe curuacjãrã Õꞌacʉ̃rẽ cʉ̃ weetamusere ʉpʉtʉ sẽrĩcãrã niwã tja. Na tojo weecã, Õꞌacʉ̃ narẽ yʉꞌrʉoacjʉ cũpecamocã meꞌrã aꞌmewẽjẽgʉ̃rẽ Aod wãmetigʉre oꞌócʉ niwĩ. Cʉ̃ Gera macʉ̃, Benjamí ya curuacjʉ̃ nicʉ niwĩ. Niꞌcã nʉmʉ Israe curuacjãrã cʉ̃rẽ na wapaseese meꞌrã Eglṍpʉ oꞌócãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Aod diꞌpjĩ pʉ́aperi osoyojaca pjĩ, niꞌcã metro deco yoari pjĩrẽ daꞌrecʉ niwĩ. Ti pjĩrẽ cʉ̃ yaro suꞌtiro doca, diacjʉ̃ca ʉsó peꞌe dʉꞌteõꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Beꞌro Israe curuacjãrãrẽ wapaseesere Eglṍrẽ wiagʉ waꞌacʉ niwĩ. Eglṍ diꞌibʉjʉgʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Te na wapaseeꞌquere Eglṍrẽ wiáca beꞌro cʉ̃ meꞌrã baꞌpatiꞌcãrã meꞌrã majãmitojaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Gilgal tiro ti macãcjãrã ẽjõpeorã yeeꞌque pʉꞌtopʉ eja, Aod majãmitojaati, Eglṍ tiropʉre aꞌtiticʉ niwĩ tja. Cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Wiogʉ, ãpẽrã tʉꞌotiro, mʉꞌʉrẽ quetire weregʉ aꞌtiapʉ. Cʉ̃ tojo nicã tʉꞌogʉ, wiogʉ cʉ̃ docacjãrãrẽ, tojo nicã cʉ̃rẽ daꞌracoꞌterãrẽ “Ucũtirãta wijaaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Na wijááca beꞌro Aod Eglṍ cʉ̃ ya wiꞌi buꞌi opa sira nirṍ tiꞌaya marĩrĩ tucũpʉ dujigʉ pʉꞌto eja, cʉ̃rẽ nicʉ niwĩ: —Queti yʉꞌʉ mʉꞌʉrẽ miitise Õꞌacʉ̃ mʉꞌʉrẽ weredutise niꞌi. Tere tʉꞌogʉ, wiogʉ dujiri cũmurõpʉ níꞌcʉ wãꞌcãnʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","Aod diꞌpjĩ diacjʉ̃ca ʉsópʉ dʉꞌteõꞌoca pjĩrẽ cũpecamocã meꞌrã wejewĩrõ, wiogʉre paagapʉ ñosẽwẽjẽcʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Beꞌro Aod ti tucũ sopere sawi meꞌrã biꞌa, ventana sopepʉ wijaacʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Beꞌropʉ wiogʉre daꞌracoꞌterã yoacã ĩꞌacũmí, cʉ̃ bajuticã ĩꞌarã, wãcũqueꞌti, “¿Deꞌro waꞌapari marĩ wiogʉre?” nírã, sawire mii, sopere pãocãrã niwã. Ti tucũpʉ sãjãa, na wiogʉre Aod wẽjẽcũꞌcʉre bocaejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Na wiogʉre coꞌteri cura Aod peꞌe duꞌtiwãꞌcã waꞌacʉ niwĩ. Tocjãrã ẽjõpeose ʉ̃tã meꞌrã yeeꞌque Gilgal cjasere yʉꞌrʉa, Seirat wãmetiropʉ duꞌtia waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Cʉ̃ Israe curuacjãrã ya diꞌtapʉre eja, Efraĩ́ curuacjãrã diꞌta opa buꞌpapijaropʉ surarare pijineogʉ̃, coronetare puticʉ niwĩ. Beꞌro Israe curuacjãrã opa buꞌpapijaropʉ níꞌcãrã cʉ̃ meꞌrã sirutubuꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","29","Aod narẽ aꞌtiro nicʉ niwĩ: “Teꞌa, yʉꞌʉre sirutuya. Õꞌacʉ̃ marĩrẽ ĩꞌatuꞌtirã moabita masãrẽ docaqueꞌacã weegʉsami”, nicʉ niwĩ. Tojo weerã cʉ̃rẽ sirutubuꞌa, dia Jordã́ ʉ̃ꞌcʉ̃atiropʉ Moab diꞌta waꞌarore cãꞌmotaꞌanʉꞌcãejacãrã niwã. Tojo weerã ne niꞌcʉ̃ yʉꞌrʉpẽꞌacã weeticãrã niwã. Titare diez mil moabita masã surara tutuarãrẽ wẽjẽpeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","To beꞌro ochenta cʉ̃ꞌmarĩ ti diꞌtapʉre aꞌmewẽjẽse marĩcaro niwʉ̃. Soose nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Aod beꞌro Samgar wãmetigʉ, Anat macʉ̃, Israe curuacjãrãrẽ sʉꞌori nisetiri masʉ̃ sãjãcʉ niwĩ. Cʉ̃ yucʉgʉ osoyojacjʉ, wecʉa nʉrʉ̃cjʉ meꞌrã seiscientos filisteo masãrẽ ñosẽwẽjẽcʉ niwĩ. Cʉ̃ quẽꞌrã Israe curuacjãrãrẽ yʉꞌrʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Aod wẽ́rĩ́ca beꞌro Õꞌacʉ̃ ĩꞌorõpʉre Israe curuacjãrã apaturi ñaꞌarõ weeseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Tojo weegʉ Õꞌacʉ̃ narẽ Jabín, cananeo masã wiogʉ dutise doca tojacã weecʉ niwĩ. Jabín Hasor wãmetiri macãpʉ masãrẽ sʉꞌori dutigʉ nicʉ niwĩ. Cʉ̃ yarã surara wiogʉ Sísara wãmetigʉ nicʉ niwĩ. Cʉ̃ Haroset-goĩpʉ macãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Jabín novecientos cabayua wejesepawʉ, cõme meꞌrã weeꞌquepawʉre cʉocʉ niwĩ. Veinte cʉ̃ꞌmarĩ Israe curuacjãrãrẽ ñaꞌabutiaro dutipecʉ niwĩ. Tojo weerã Israe curuacjãrã Õꞌacʉ̃rẽ cʉ̃ weetamusere ʉpʉtʉ sẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Titare Débora wãmetigo Õꞌacʉ̃ yere weremʉꞌtãgõ Israe curuacjãrãrẽ na aꞌpepũrĩsere apo, sʉꞌori añurõ nisetiri masõ nico niwõ. Co Lapidot nʉmo nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Co, masãrẽ besego, niꞌcã ño docapʉ dujisetico niwõ. Tiño “Débora ya ño” wãmeticaro niwʉ̃. Ʉ̃rʉ̃pagʉ Efraĩ́ wãmetiri diꞌta, Ramá, Betel decopʉ tojacaro niwʉ̃. Israe curuacjãrã na aꞌpepũrĩsere apodutirã, co tiropʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Niꞌcã nʉmʉ Débora Barac wãmetigʉre pijidutico niwõ. Cʉ̃ Abinoam macʉ̃, Quedes wãmetiri macãcjʉ̃ nicʉ niwĩ. Quedes Neftalí ya curua nirĩ macã nicaro niwʉ̃. Cʉ̃rẽ aꞌtiro nico niwõ: —Õꞌacʉ̃, Israe curuacjãrã wiogʉ, mʉꞌʉrẽ aꞌtiro dutimi: “Ʉ̃rʉ̃gʉ̃ Tabopʉ waꞌaya. Topʉ mʉꞌʉ meꞌrã diez mil ʉmʉa Neftalí, tojo nicã Zabulṍ ye curaricjãrãrẽ miaña. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Sísara, Jabín yarã surara wiogʉ, cʉ̃ yepawʉ, cʉ̃ yarã surara meꞌrã mʉꞌʉ meꞌrã aꞌmewẽjẽato nígʉ̃, dia Cisṍpʉ waꞌacã weegʉti. Topʉ cʉ̃rẽ docaqueꞌacã weegʉti”, mʉꞌʉrẽ aꞌtiro ni weredutiami Õꞌacʉ̃, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Barac Déborare aꞌtiro yʉꞌticʉ niwĩ: —Mʉꞌʉ yʉꞌʉre baꞌpaticã, waꞌagʉti. Mʉꞌʉ waꞌaticãma, waꞌasome, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","—Añurõsaꞌa; mʉꞌʉ meꞌrã waꞌagoti, nico niwõ Débora. “Mejõ mʉꞌʉ tojo níꞌque buꞌiri, masã ‘Mʉꞌʉ meꞌrã Õꞌacʉ̃ Sísarare docaqueꞌacã weeapʉ’ nisome. Numio meꞌrã pũrĩcã Õꞌacʉ̃ Sísarare docaqueꞌacã weeapʉ” nirãsama, nico niwõ. To beꞌro Débora Barac meꞌrã Quedespʉ waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Topʉ Barac Zabulṍ, Neftalí ya curuacjãrã ʉmʉarẽ pijineocʉ niwĩ. Diez mil surara cʉ̃ meꞌrã aꞌmewẽjẽtamurã waꞌacãrã niwã. Débora quẽꞌrã cʉ̃rẽ baꞌpatico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Cedes pʉꞌtopʉ, yucʉgʉ pajicjʉ encina wãmeticjʉ Zaanaípʉ nicaro niwʉ̃. Topʉ Heber, quenita masʉ̃ cʉ̃ ya wiꞌi suꞌti caseri meꞌrã wééca wiꞌi nicaro niwʉ̃. Cʉ̃ ãpẽrã quenita masã meꞌrã níꞌcʉ wijawãꞌcãcʉ niwĩ. Na quenita masã Hobab, Moisé mañecʉ̃ pãrãmerã nituriarã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Sísara peꞌe “Barac ʉ̃rʉ̃gʉ̃ Tabor wãmeticjʉre mʉjãpʉ” nicã tʉꞌogʉ, ");
INSERT INTO tuoNT_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","cʉ̃ novecientos tũrũsepawʉ, cõme meꞌrã weeꞌquepawʉre, tojo nicã nipeꞌtirã surarare neocũucʉ niwĩ. Neo, Haroset-goĩpʉ níꞌcãrã wija, Cisón wãmetiri maapʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Cʉ̃ tojo weecã ĩꞌagõ, Débora Barare aꞌtiro ni wereco niwõ: —Waꞌaya. Niꞌcãcã Õꞌacʉ̃ marĩ wiogʉ mʉꞌʉrẽ Sísarare wiagʉsami. Marĩ wiogʉ mʉsã dʉporo ʉꞌmʉtãtojacʉ niami, nico niwõ. Co tojo nicã, Barac cʉ̃ yarã surara diez mil ʉmʉa ʉ̃rʉ̃gʉ̃ Tabopʉ níꞌcãrã Sísara yarã surara meꞌrã aꞌmewẽjẽrã waꞌarã dijaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Barac yarã surara Sísara yarã meꞌrã aꞌmewẽjẽrã dijááticã, Õꞌacʉ̃ Sísara yarã surarare ʉcʉacã weecʉ niwĩ. Sísara peꞌe cʉ̃ yawʉ tũrũpjʉ cõme meꞌrã wéécawʉpʉ sãñaꞌcʉ dijaa, omaduꞌtia waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Cʉ̃ tojo weeri cura Barac yarã surarare, na yepawʉre téé Haroset-goim wãmetiropʉ narẽ wẽjẽsirutucʉ niwĩ. Nipeꞌtirã Sísara yarã surara wẽrĩpeꞌtia waꞌacãrã niwã. Ne niꞌcʉ̃ yʉꞌrʉwetiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Sísara peꞌe Jael, Heber ceneo masʉ̃ nʉmo ya wiꞌi, suꞌti caseri meꞌrã wééca wiꞌipʉ duꞌticʉ niwĩ. Heber, cʉ̃ acawererã, Sísara wiogʉ Jabín, Hasor macã wiogʉ meꞌrã añurõ aꞌmesʉꞌacʉ niwĩ. Tojo weegʉ Sísara ti wiꞌipʉ ejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Cʉ̃ etacã ĩꞌagõ, Jael cʉ̃rẽ nico niwõ: —Sãjãtia, yʉꞌʉ wiogʉ. Ne uiticãꞌña. Co tojo nicã, Sísara ti wiꞌipʉ sãjãacʉ niwĩ. Sãjãa, cʉ̃ ejaqueꞌacã, omacãjĩrõ meꞌrã cʉ̃rẽ omaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","—Acowʉosaꞌa. Yʉꞌʉre aco cãꞌrõacã tĩaña, nicʉ niwĩ. Tojo weego cabra õpẽcõrẽ cabra casero meꞌrã poseyéca ajurore pão, cʉ̃rẽ tĩaco niwõ. Tĩatoja, cʉ̃rẽ omaco niwõ tja. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sísara core aꞌtiro weeduticʉ niwĩ: —Sopepʉ nuꞌcũña. Ãpẽrã yʉꞌrʉarã, mʉꞌʉ tiro “¿Ãpẽrã marĩti?” ni sẽrĩtiñaꞌcã, “Marĩma” niña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Sísara, ʉpʉtʉ ñujũꞌcʉ niyugʉ, cãrĩyʉꞌrʉacʉ niwĩ. Cʉ̃ tojo weecã ĩꞌagõ, Jael, Heber nʉmo bʉsʉro marĩrõ ti wiꞌi cjase niꞌcãgʉ̃ yucʉgʉ ti wiꞌire tʉ̃apuanʉꞌcõꞌcʉre míí, cʉ̃ diapoare diꞌtapʉ paabiꞌpe wẽjẽco niwõ. Tojo wee wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Beꞌro Barac Sísarare aꞌmagʉ̃ etacã, Jael co ya wiꞌipʉ níꞌco wijaa, cʉ̃rẽ põtẽrĩgõ waꞌaco niwõ. —Sãjãtia. Mʉꞌʉ aꞌmagʉ̃rẽ ĩꞌogõti, nico niwõ. Co tojo nicã, Barac ti wiꞌire sãjãacʉ niwĩ. Ti wiꞌipʉ Sísara wẽrĩꞌcʉpʉ cũñacʉ niwĩ. Ti wiꞌire tʉ̃apuanʉꞌcõꞌcʉ meꞌrã cʉ̃ diapoare paabiꞌpeyʉꞌrʉtẽrĩnoꞌcʉre ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Ti nʉmʉrẽta Õꞌacʉ̃ Jabín, cananeo masã wiogʉre docaqueꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Israe curuacjãrã Jabĩ́rẽ, cananeo masã wiogʉ meꞌrã aꞌmewẽjẽrã, nemorõ tutuarã waꞌacãrã niwã. Tojo wee siapeꞌe meꞌrã narẽ wẽjẽpeꞌobutiacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Ti nʉmʉrẽta Débora, tojo nicã Barac, Abinoam macʉ̃ Sísara, cʉ̃ yarã surarare docaqueꞌacã weeꞌquere basapeocãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","Õꞌacʉ̃rẽ basapeorã, aꞌtiro ni basacãrã niwã: “Õꞌacʉ̃, nipeꞌtirã mʉꞌʉrẽ ĩꞌatuꞌtirã Sísara weronojõ wẽrĩpeꞌtia waꞌato. Mʉꞌʉrẽ mairã peꞌe tutuarã ninuꞌcũcãꞌto. Mujĩpũ ʉmʉcocjʉ̃ asistero weronojõ niato”, ni basacãrã niwã. Beꞌro ti diꞌtapʉre Israe curuacjãrã nirõpʉre cuarenta cʉ̃ꞌmarĩ aꞌmewẽjẽse marĩcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Beꞌropʉ tja Israe curuacjãrã apaturi Õꞌacʉ̃ ĩꞌorõpʉ ñaꞌarõ weecãrã niwã. Tojo weegʉ Õꞌacʉ̃ narẽ siete cʉ̃ꞌmarĩ madianita masã dutise doca tojacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Siapeꞌe meꞌrã madianita masã narẽ ñaꞌarõ daꞌradutipecãrã niwã. Tojo weerã Israe curuacjãrã narẽ uirã, ʉ̃rʉ̃pagʉpʉ, ʉ̃tã tutiripʉ duꞌtise na nisetise uꞌturire weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","4","Na otese pĩꞌrĩsetirinʉcʉ̃, madianita masã, amaleca masã, ãpẽrã mujĩpũ mʉjãtiro peꞌecjãrã Israe curuacjãrã nirõpʉ sãjãa, topʉ ejaqueꞌacãrã niwã. Nipeꞌtiro na oteꞌquere noꞌo ʉaro duꞌaste cõꞌacãꞌcãrã niwã. Téé Gaza tiropʉ tojo weetʉocãrã niwã. Israe curuacjãrã na baꞌaboꞌquere, tojo nicã na yarã ecarã ovejare, wecʉare, burroare, ne apeyenojõ dʉꞌaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Ti diꞌta cjasere dojorẽrã aꞌtirã, na yarã cameyoa pãjãrã meꞌrã, na ye wiꞌseri suꞌti meꞌrã weeꞌque wiꞌseri peje meꞌrã aꞌticãrã niwã. Mʉꞌmʉrĩwiꞌia pãjãrã otesere baꞌapeꞌorã aꞌtirã weronojõ aꞌticãrã niwã. Na pãjãrã niyucã, baꞌpaqueota basioticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Madianita masã tojo weecã, Israe curuacjãrã ʉpʉtʉ piꞌeticãrã niwã. Tojo weerã Õꞌacʉ̃rẽ cʉ̃ weetamusere ʉpʉtʉ sẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Israe curuacjãrã Õꞌacʉ̃rẽ “Madianita masãrẽ yʉꞌrʉweticã weeya”, ni sẽrĩcã, ");
INSERT INTO tuoNT_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Õꞌacʉ̃ narẽ niꞌcʉ̃ cʉ̃ yere weremʉꞌtãrĩ masʉ̃rẽ oꞌócʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: “Õꞌacʉ̃ Israe curuacjãrã wiogʉ mʉsãrẽ aꞌtiro niami: ‘Yʉꞌʉ mʉsã Egiptopʉ níꞌcãrãrẽ miiwijawʉ. Topʉre mʉsã narẽ daꞌracoꞌterã nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Mʉsã Egiptocjãrã dutise doca níꞌcãrãrẽ yʉꞌrʉweticã weewʉ. Tojo nicã nipeꞌtirã mʉsãrẽ ñaꞌarõ weeꞌcãrãrẽ tojo weewʉ. Na ye diꞌta nimiꞌquere cõꞌaõꞌo, mʉsãrẽ oꞌowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Mʉsãrẽ aꞌtiro nimiwʉ̃: “Yʉꞌʉ Õꞌacʉ̃, mʉsã wiogʉ niꞌi. Mʉsã amorreo masã ya diꞌtapʉ niꞌi. Na ẽjõpeorãrẽ ne ẽjõpeoticãꞌña,” nimiwʉ̃. Yʉꞌʉ tojo nimicã, mʉsã peꞌe yʉꞌʉ tojo dutisere ne yʉꞌtitiwʉ’ ”, ni werecʉ niwĩ Õꞌacʉ̃ yere weremʉꞌtãrĩ masʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Beꞌro Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã aꞌti, Ofra nirõpʉ yucʉ pajicjʉ docapʉ dujicʉ niwĩ. Tigʉ Joás wãmetigʉ yagʉ nicaro niwʉ̃. Joás Abiézer wãmetiri curuacjʉ̃ nicʉ niwĩ. Topʉ cʉ̃ macʉ̃ Gedeṍ trigore doque, sʉꞌaweegʉ weecʉ niwĩ. Madianita masã ĩꞌaticãꞌto nígʉ̃, na vino wéérã ʉꞌsepaga ʉꞌtatĩarõpʉ tere sʉꞌaweegʉ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã Gedeṍrẽ bajua, aꞌtiro nicʉ niwĩ: —Gedeṍ, Õꞌacʉ̃ mʉꞌʉ meꞌrã nimi. Mʉꞌʉ aꞌmewẽjẽtutuagʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Gedeṍ cʉ̃rẽ yʉꞌticʉ niwĩ: —Õꞌacʉ̃ ʉ̃sã meꞌrã nimicã, ¿deꞌro weero aꞌte ñaꞌase ʉ̃sãrẽ tojo waꞌati? Ʉ̃sã ñecʉ̃sʉmʉa Õꞌacʉ̃ tutuaro meꞌrã cʉ̃ weeꞌquere werecãrã niwã. Na “Õꞌacʉ̃ ʉ̃sã Egiptopʉ níꞌcãrãrẽ miiwijawĩ”, nicãrã niwã. Ʉ̃sã peꞌe cʉ̃ tutuasere ĩꞌaweꞌe. Õꞌacʉ̃ ʉ̃sãrẽ cõꞌawãꞌcãwĩ. Ʉ̃sãrẽ madianita masã dutise doca nicã weewĩ, nicʉ niwĩ Gedeṍ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Õꞌacʉ̃ cʉ̃rẽ majãmiĩꞌa, aꞌtiro nicʉ niwĩ: —Mʉꞌʉ tutuase meꞌrã Israe curuacjãrãrẽ madianita masã dutise doca nirãrẽ yʉꞌrʉogʉ waꞌaya. Yʉꞌʉta mʉꞌʉrẽ waꞌadutigʉ weeꞌe, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Gedeṍ cʉ̃rẽ yʉꞌticʉ niwĩ: —Wiogʉ, ¿deꞌro wee yʉꞌʉ Israe curuacjãrãrẽ yʉꞌrʉogʉsari? Ya curua Manasés pãrãmerã nituriase curari yapatiri curuacjãrã nima. Yʉꞌʉ quẽꞌrã niꞌcʉ̃ põꞌrã dʉꞌsagʉpʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ mʉꞌʉ meꞌrã nigʉ̃ti. Mʉꞌʉ nipeꞌtirã madianita masãrẽ niꞌcʉ̃ masʉ̃rẽ wẽjẽ́gʉ̃ weronojõ weegʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Cʉ̃ tojo nicã tʉꞌogʉ, Gedeṍ nicʉ niwĩ: —Yʉꞌʉre niꞌcãrõacã eꞌcatise meꞌrã ĩꞌagʉ̃, “Diacjʉ̃ta yʉꞌʉ Õꞌacʉ̃ niꞌi” nígʉ̃a, mʉꞌʉ tutuase meꞌrã apeyenojõ weeĩꞌoña. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Aꞌtota yucueya yujupʉ. Yʉꞌʉ mʉꞌʉrẽ ẽjõpeosere ĩꞌogʉ̃, apeyenojõ oꞌosĩꞌrĩsaꞌa, nicʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ “Jaʉ, mʉꞌʉrẽ yucuegʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Cʉ̃ tojo nicã, Gedeṍ waꞌa, niꞌcʉ̃ cabracãrẽ wẽjẽ, doꞌa, tojo nicã pã́ bʉcʉase meꞌrã morẽtiꞌquere apocʉ niwĩ. Tuꞌajanʉꞌcõ, diꞌirore piꞌipʉ miisãa, tecore sʉtʉwʉpʉ piosãacʉ niwĩ. Te nipeꞌtisere cʉ̃ yucʉ doca dujigʉre mia, oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Õꞌacʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, cʉ̃rẽ nicʉ niwĩ: —Diꞌiro, pã́ bʉcʉase morẽtiꞌquere ʉ̃tãgã buꞌipʉ cũuña. Tecore piostepeoya, nicʉ niwĩ. Cʉ̃ dutironojõta Gedeṍ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã cʉ̃ tuacjʉ yapa meꞌrã sĩ́oo, diꞌirore, tojo nicã pã́rẽ ñapeocʉ niwĩ. Tojo weecãta, pecameꞌe ʉ̃tãgãpʉ ʉ̃jʉ̃ñeꞌemajã waꞌacaro niwʉ̃. Ti meꞌe diꞌirore, pã́rẽ ʉ̃jʉ̃apeꞌocãꞌcaro niwʉ̃. Tojo weetoja, Õꞌacʉ̃rẽ werecoꞌtegʉ bajudutia waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Tojo waꞌacã ĩꞌagʉ̃, Gedeṍ Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcãsere masĩcʉ niwĩ. Beꞌro ʉcʉa, caricũcʉ niwĩ: —¡Acoe, yʉꞌʉ wiogʉ! Mʉꞌʉ basuta nimigʉ̃, mʉꞌʉrẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcãꞌcʉre bajuyoropʉ ĩꞌaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —Ne uiticãꞌña. Mʉꞌʉ wẽrĩsome. Wãcũqueꞌtiro marĩrõ niña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Beꞌro Gedeṍ topʉ Õꞌacʉ̃rẽ ẽjõpeogʉ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore niꞌcã mesã ʉ̃tã meꞌrã seeneocũucʉ niwĩ. Ti mesãrẽ “Õꞌacʉ̃ wãcũqueꞌtiro marĩrõ, añurõ tʉꞌoñaꞌse oꞌogʉ nimi”, ni wãmepeocʉ niwĩ. Aꞌti mesã Ofra, Abiézer ya curuacjãrã ya macãpʉ nidecotisaꞌa yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ti ñamita Õꞌacʉ̃ Gedeṍrẽ aꞌtiro nicʉ niwĩ: —Niꞌcʉ̃ wecʉ ʉmʉ mʉꞌʉ pacʉ yarã waꞌteropʉ nigʉ̃́, siete cʉ̃ꞌma cʉogʉre ñeꞌegʉ̃ waꞌaya. Baare waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoro, mʉꞌʉ pacʉ yarore paamʉtõdijogʉ waꞌaya. Tojo nicã, to pʉꞌto nirĩ tuturo Astarté queose nirĩ tuturore paacõꞌaña. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Tere cõꞌatoja, Õꞌacʉ̃ mʉꞌʉ wiogʉre niꞌcãrõ waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeoatjore niꞌcã mesã ʉ̃tã meꞌrã seeneocũuña tja. Mʉsã duꞌtiro nirĩ buꞌa dʉposãrĩpʉ seeneocũuña. Tuꞌajanʉꞌcõ, wecʉre wẽjẽ, topʉ peca, mʉsã paacõꞌaca tuturo meꞌrã Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeoya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Beꞌro Gedeṍ diez ʉmʉa, cʉ̃rẽ daꞌracoꞌterã meꞌrã Õꞌacʉ̃ cʉ̃rẽ weedutiꞌcaronojõta weecʉ niwĩ. Cʉ̃ acawererãrẽ, ti macãcjãrãrẽ uiyugʉ, ʉmʉco ʉ̃jʉ̃amorõpeosĩꞌrĩticʉ niwĩ. Tojo weegʉ ñamipʉ ʉ̃jʉ̃amorõpeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Ape nʉmʉ boꞌreacã ti macãcjãrã wãꞌcã, Baare ẽjõpeorore paamʉtõdijoꞌcarore, tojo nicã Astarté ẽjõpeori tuturo paacõꞌaca tuturore ĩꞌacãrã niwã. Apeyema tja, apero, maꞌma ʉ̃jʉ̃amorõpeoropʉ wecʉ ʉ̃jʉ̃aꞌcʉre ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Na aꞌmerĩ sẽrĩtiñaꞌcãrã niwã: “¿Noanojõ tojo weeapari?” nicãrã niwã. Na aꞌmerĩ sẽrĩtiñaꞌca beꞌro tʉꞌomasĩcãrã niwã: “Gedeṍ, Joás macʉ̃ tojo weeapĩ”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Beꞌro ti macãcjãrã ʉmʉa Joáre aꞌtiro nicãrã niwã: —Mʉꞌʉ macʉ̃rẽ ʉ̃sãrẽ oꞌoya. Cʉ̃ Baare waꞌicʉrãrẽ ʉ̃jʉ̃amorõpeorore, tojo nicã to pʉꞌto nirĩ tuturo Astartére ẽjõpeori tuturore paacõꞌacʉ niami. Tojo weese wapa wẽjẽnoꞌgʉ̃sami, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Joás, Gedeṍ pacʉ peꞌe narẽ yʉꞌticʉ niwĩ: —¿Mʉsã Baare aꞌmewẽjẽbosarãsari? ¿Cʉ̃rẽ yʉꞌrʉorãsari? Noꞌo cʉ̃rẽ aꞌmewẽjẽbosagʉ boꞌreati dʉporo wẽrĩato. “Diacjʉ̃ta Baal wiogʉ waro nimi” nígʉ̃, cʉ̃ basu aꞌmewẽjẽato. Na paamʉtõdijoꞌcaro cʉ̃ yarota nicaro niapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Ti nʉmʉ meꞌrã masã Gedeṍrẽ “Jerubaal” pisunʉꞌcãcãrã niwã. Gedeṍta Baare ẽjõpeorore paamʉtõdijocʉ niwĩ. Tojo weerã “Baal basu aꞌmewẽjẽato” nírã, tojo nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","To beꞌro nipeꞌtirã madianita masã, amaleca masã, tojo nicã ãpẽrã mujĩpũ mʉjãtiro peꞌecjãrã nerẽ, dia Jordã́rẽ pẽꞌacãrã niwã. Añurĩ pa Jezreel wãmetiropʉ ejaqueꞌa, cãrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Na tojo weecã, Espíritu Santu Gedeṍpʉre sãjãacʉ niwĩ. Sãjãa, Gedeṍ Abiézer ya curuacjãrãrẽ cʉ̃rẽ sirutudutigʉ, oveja capesaꞌrore puticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Ãpẽrã queti wererãrẽ nipeꞌtiro Manasés ya curuacjãrãrẽ nerẽdutigʉ oꞌócʉ niwĩ. Tojo nicã Aser ya curuacjãrã, Zabulṍ ya curuacjãrã, Neftalí ya curuacjãrã cʉ̃ meꞌrã aꞌmewẽjẽtamurã waꞌajãrẽ pijiduticʉ niwĩ. Tojo weerã nipeꞌtirã cʉ̃ meꞌrã nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Gedeṍ Õꞌacʉ̃rẽ aꞌtiro nicʉ niwĩ: “Mʉꞌʉ yʉꞌʉ meꞌrã Israe curuacjãrãrẽ yʉꞌrʉogʉsaꞌa níꞌcaronojõta diacjʉ̃ wéégʉ, aꞌtiro weeĩꞌobosaya. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Oveja casero añurõ poaritiri casero trigo suꞌtiweeropʉ diꞌtapʉ cũugʉ̃ti. Boꞌreacã ñocõa ʉꞌseco ti caseropʉ diaꞌcʉ̃ nicã ĩꞌagʉ̃, mʉꞌʉ yʉꞌʉre níꞌcaronojõta yʉꞌʉ meꞌrã Israe curuacjãrãrẽ yʉꞌrʉosere masĩgʉ̃saꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Tojota waꞌacaro niwʉ̃. Ape nʉmʉ Gedeṍ wãꞌcã, poari añurõ púúca caserore bocacʉ niwĩ. Ti caserore bipecã, niꞌcã pa muꞌmurõ aco wijacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Beꞌro Gedeṍ Õꞌacʉ̃rẽ nicʉ niwĩ tja: “Yʉꞌʉ meꞌrã uaticãꞌña. Niꞌcãti mʉꞌʉ weeĩꞌosere sẽrĩnemogʉ̃ti. Niꞌcãrõacãma boꞌreacã diꞌtapʉ diaꞌcʉ̃ ñocõa ʉꞌseco niato. Oveja poari peꞌe añurõ bopori casero niato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Ti ñamirẽ Õꞌacʉ̃ mejãrõta weecʉ niwĩ tja. Oveja poari diaꞌcʉ̃ aco marĩcaro niwʉ̃. Diꞌta nipeꞌtiropʉre ñocõa ʉꞌseco acoticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Ape nʉmʉ boꞌreacã Gedeṍ, na Jerubaal pisunoꞌgʉ̃, nipeꞌtirã ʉmʉa cʉ̃ meꞌrã nirã́ wãꞌcã, aco wijari pe Harod wãmetiri pepʉ waꞌacãrã niwã. Madianita masã to yʉꞌrʉro eꞌsari pa ʉ̃rʉ̃gʉ̃ More wãmeticjʉ pʉꞌtopʉ nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Õꞌacʉ̃ Gedeṍrẽ aꞌtiro nicʉ niwĩ: “Mʉꞌʉ meꞌrã nirã́ pãjãrã nima. Na pãjãrã meꞌrã yʉꞌʉ madianita masãrẽ docaqueꞌacã weecã, na ‘Ʉ̃sã tutuase meꞌrã yʉꞌrʉwʉ’, nibosama. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Tojo weegʉ narẽ aꞌtiro niña: ‘Noꞌo ui narãsãrãnojõrẽ, mʉsã ye wiꞌseripʉ dajatojaaya’, niña”, nicʉ niwĩ Õꞌacʉ̃. Cʉ̃ tojo nicã, veintidos mil ʉmʉa na ye wiꞌseripʉ dajatojaacãrã niwã. Diez mil ʉmʉa dʉꞌsacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Õꞌacʉ̃ ninemocʉ niwĩ: “Na pãjãrã nima yujupʉ. Tojo weegʉ acore sĩꞌrĩdutigʉ, narẽ aco wijari pepʉ miibuꞌaya. Topʉ yʉꞌʉ beseñaꞌgʉ̃ti. ‘Ãꞌrĩ mʉꞌʉ meꞌrã waꞌagʉsami’ ninoꞌgʉ̃ waꞌagʉsami. Apĩ ‘Ãꞌrĩ waꞌatisami’ ninoꞌgʉ̃ waꞌasome”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Tojo weegʉ Gedeṍ narẽ acore sĩꞌrĩdutigʉ, ti pepʉ pijibuꞌacʉ niwĩ. Õꞌacʉ̃ cʉ̃rẽ aꞌtiro nicʉ niwĩ: “Aꞌtiro dʉcawaaya narẽ. Na omocãrĩ meꞌrã aco waamíí, diayia weronojõ neꞌrẽ, sĩꞌrĩrãrẽ mejẽcã cũuña. Ãpẽrã ejaqueꞌa, muꞌrĩpaꞌa sĩꞌrĩrãrẽ mejẽcã cũuña”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Omocã meꞌrã diayia weronojõ neꞌrẽ, sĩꞌrĩrã trescientos nicãrã niwã. Ãpẽrã dʉꞌsarã peꞌe ejaqueꞌa, muꞌrĩpaꞌa sĩꞌrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Na tojo weecã, Õꞌacʉ̃ Gedeṍrẽ nicʉ niwĩ: “Ãꞌrã trescientos ʉmʉa meꞌrã mʉsãrẽ yʉꞌrʉogʉsaꞌa. Na meꞌrã madianita masãrẽ docaqueꞌacã weegʉti. Ãpẽrã peꞌe na ye wiꞌseripʉ tojaarãsama”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Tojo weegʉ Gedeṍ narẽ suꞌti caseri meꞌrã weeꞌque wiꞌseripʉ dajatojaaduticʉ niwĩ. Trescientos ʉmʉa cʉ̃ meꞌrã tojacãrã niwã. Ãpẽrã na waꞌase dʉporo na baꞌaboꞌquere, na ye sʉtʉparʉ, na putise oveja ʉmʉa capesaꞌrire cũucãrã niwã. Madianita masã na cãrĩrõ Gedeṍ buꞌaropʉ opa paꞌtiro pajiri papʉ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ti ñamita Õꞌacʉ̃ Gedeṍrẽ aꞌtiro nicʉ niwĩ: “Wãꞌcãnʉꞌcãña. Madianita masã meꞌrã aꞌmewẽjẽgʉ̃ buꞌaya. Narẽ mʉꞌʉrẽ wiagʉtigʉ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Mʉꞌʉ uigʉ, mʉꞌʉrẽ daꞌracoꞌtegʉ Fura meꞌrã na nirõpʉ buꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Topʉ na ucũsere tʉꞌogʉ waꞌaya. Tojo wééca beꞌro wãcũtutuase meꞌrã aꞌmewẽjẽgʉ̃saꞌa”, nicʉ niwĩ. Tojo weegʉ Gedeṍ cʉ̃rẽ daꞌracoꞌtegʉ Fura meꞌrã madianita masã nerẽrõ sumutopʉ buꞌa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Madianita masã, amaleca masã, ãpẽrã mujĩpũ mʉjãtiro peꞌecjãrã pajiri papʉ mʉꞌmʉrĩwiꞌia pãjãrã weronojõ nerẽcãrã niwã. Na yarã cameyoa maa pajiri maa sumutopʉ nucũpori weronojõ pãjãrã waro nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Gedeṍ buꞌa etacã, niꞌcʉ̃ madianita masʉ̃ cʉ̃ quẽꞌesere apĩ cʉ̃ meꞌrãcjʉ̃rẽ weregʉ weecʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Aꞌtiro quẽꞌeasʉ. Niꞌcãgã pã́ cebada meꞌrã wéécaga marĩ nirõpʉ tũrũmaacãtiasʉ. Tiga niꞌcã wiꞌi suꞌti caseri meꞌrã wééca wiꞌipʉ doquewãarõta, ti wiꞌire doquestemajã waꞌapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Cʉ̃ tojo werecã tʉꞌogʉ, cʉ̃ meꞌrãcjʉ̃ aꞌtiro ni yʉꞌticʉ niwĩ: —Mʉꞌʉ tojo quẽꞌese Gedeṍ, Joás macʉ̃, Israe curuacjʉ̃, cʉ̃ ya diꞌpjĩ, aꞌmewẽjẽrĩ pjĩ nisĩꞌrĩrõ weeꞌe. Õꞌacʉ̃ marĩ madianita masã, nipeꞌtirã aꞌtopʉ nerẽrãrẽ, tojo nicã nipeꞌtise marĩ cʉosere Gedeṍrẽ wiagʉsami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Gedeṍ cʉ̃ quẽꞌesere tʉꞌogʉ, ejaqueꞌa, Õꞌacʉ̃rẽ ẽjõpeocʉ niwĩ. Beꞌro Israe curuacjãrã nerẽrõpʉ daja, narẽ aꞌtiro nicʉ niwĩ: —Wãꞌcãnʉꞌcãña. Õꞌacʉ̃ sõjã madianita masã surarare marĩrẽ wiagʉsami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Cʉ̃ tojo níca beꞌro cʉ̃ yarã trescientos ʉmʉarẽ iꞌtia curua dʉcawaacʉ niwĩ. Nanʉcʉ̃rẽ putiatje capesaꞌrire oꞌo, tojo nicã sʉtʉparʉ ope pecameꞌe na sĩꞌaꞌque posetiseparʉre oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Beꞌro narẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉre ĩꞌaña. Na nerẽrõ ape pãꞌrẽpʉ yʉꞌʉ etacã, yʉꞌʉ weronojõta weeya. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Yʉꞌʉ, nipeꞌtirã yʉꞌʉ meꞌrã nirã́ ʉ̃sã capesaꞌrire puticã, mʉsã sumutopʉ nuꞌcũrã niꞌcãrõnojõ putibʉroya. Putitoja, “Õꞌacʉ̃rẽ, tojo nicã Gedeṍrẽ aꞌmewẽjẽbosarã”, ni caricũña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Ñami deco nicã, madianita masã surara coꞌterã dʉcayúca beꞌro Gedeṍ cien surara cʉ̃ meꞌrã nirã́ madianita masã surara nerẽrõ ape pãꞌrẽpʉ etacãrã niwã. Topʉ eta, na ye putise capesaꞌrire puti, sʉtʉparʉ na cʉoseparʉre bopecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Na iꞌtia curua niꞌcãrõ meꞌrã puticãrã niwã. Tojo nicã na ye sʉtʉparʉre bopecãrã niwã. Cũpecamocã meꞌrã na sĩꞌaꞌquere sĩomorõ, diacjʉ̃camocã meꞌrã capesaꞌrire cʉocãrã niwã. Niꞌcãrõ meꞌrã “Õꞌacʉ̃rẽ, Gedeṍrẽ aꞌmewẽjẽbosarã”, ni caricũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Israe curuacjãrã madianita masã surara nerẽrõpʉ tojo nuꞌcũbeꞌtoacãrã niwã. Madianita masã narẽ uirã, noꞌo ʉaro caricũ, duꞌtiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Trescientos capesaꞌri bʉsʉcã, Õꞌacʉ̃ na madianita masãrẽ na basu aꞌmerĩ aꞌmewẽjẽcã weecʉ niwĩ. Na surara yʉꞌrʉ̃wetiꞌcãrã yoaropʉ Bet-sita wãmetiri macã, Zerera waꞌari maꞌapʉ, téé Abel-mehola nitʉoro Tabat wãmetiri macã pʉꞌtopʉ omaduꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Tojo waꞌáca beꞌro Israe curuacjãrã Neftalí, Aser, nipeꞌtirã Manasés ya curuacjãrãrẽ pijicãrã niwã. Tojo weerã na quẽꞌrã madianita masã surarare sirutucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Gedeṍ quetiwerecoꞌterãrẽ weredutigʉ, Efraĩ́pʉ opa buꞌpa nirõpʉ oꞌócʉ niwĩ. Aꞌtiro ni queti oꞌócʉ niwĩ: “Madianita masã meꞌrã aꞌmewẽjẽrã aꞌtia. Dia Jordã́ pẽꞌarĩ maa ʉ̃ꞌcʉ̃atiropʉ Bet-bara wãmetiropʉ na dʉporo nitojaya. Na pẽꞌarĩ nírã, cãꞌmotaꞌaya”, nicʉ niwĩ. Tojo weerã Efraĩ́ ya curuacjãrã surara Gedeṍ dutiꞌquere weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Apeyema tja madianita masã surara wiorã Oreb, Zeeb wãmetirãrẽ ñeꞌecãrã niwã. Orere niꞌcãgã ʉ̃tãgãpʉ wẽjẽcãrã niwã. Tiga aꞌtocaterore “Oreb yaga” wãmetisaꞌa. Zeere cʉ̃ ʉꞌse biperopʉ wẽjẽcãrã niwã. Ãpẽrã madianita masã surarare sirutúca beꞌro Oreb, Zeeb na dʉpopare Gedeṍrẽ, dia Jordã́ ape pãꞌrẽpʉ nigʉ̃́ tiropʉ oꞌorã waꞌarã miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Beꞌro Israe curuacjãrã Gedeṍrẽ aꞌtiro nicãrã niwã: —Mʉꞌʉ ʉ̃sãrẽ madianita masã doca níꞌcãrãrẽ yʉꞌrʉowʉ. Tojo weegʉ ʉ̃sã wiogʉ sãjãña. Mʉꞌʉ põꞌrã, mʉꞌʉ pãrãmerã mʉꞌʉ beꞌro dutisirutuato, nicãrã nimiwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Gedeṍ peꞌe narẽ yʉꞌticʉ niwĩ: —Niweꞌe. Yʉꞌʉ, tojo nicã yʉꞌʉ macʉ̃ mʉsã wiogʉ nisome. Õꞌacʉ̃ peꞌe mʉsã wiogʉ nigʉ̃sami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Narẽ aꞌtiro ninemocʉ niwĩ: —Aꞌtiro peꞌe sẽrĩꞌi. Mʉsãnʉcʉ̃ mʉsã madianita masãrẽ ẽꞌmaꞌquere omopica tuusãase beꞌtorire oꞌoya, nicʉ niwĩ. Titare ismaelita masã yucʉ marĩrõcjãrã na omopica tuusãase beꞌtorire uru meꞌrã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Na “Jaʉ, mʉꞌʉrẽ eꞌcatise meꞌrã oꞌorãti”, nicãrã niwã. Tojo níca beꞌro niꞌcã suꞌticasero nucũcãpʉ sẽeocũu, na suraranʉcʉ̃ omopica tuusãase beꞌtori na bocaꞌquere ti casero buꞌipʉ peocãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Te uru meꞌrã Gedeṍ niꞌcãrõ camisa, omocãrĩ marĩrõ weecʉ niwĩ. To camisare cʉ̃ ya macã Ofrapʉ cũucʉ niwĩ. Beꞌro nipeꞌtirã Israe curuacjãrã Õꞌacʉ̃rẽ ẽjõpeoronojõ oꞌorã, to camisa peꞌere ẽjõpeocãrã niwã. Tojo weerã Gedeṍ, tojo nicã cʉ̃ acawererã ñaꞌarõ yapaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Tojo weese meꞌrã Israe curuacjãrã madianita masãrẽ docaqueꞌacã weecãrã niwã. Na ne apaturi tutuarã waꞌanemoticãrã niwã majã. Tojo weerã Gedeṍ catiri curare cuarenta cʉ̃ꞌmarĩ Israe curuacjãrã soose meꞌrã nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Madianita masãrẽ docaqueꞌacã wééca beꞌro Gedeṍ, “Jerubaal” na ninoꞌgʉ̃, cʉ̃ ya macãpʉ nisetigʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Cʉ̃ pãjãrã nʉmosãnumia cʉoyugʉ, setenta ʉmʉa põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Apego Siquẽcjõ, cʉ̃ cʉoꞌco, cʉ̃ nʉmo nitigo meꞌrã, niꞌcʉ̃ põꞌrãticʉ niwĩ. Cʉ̃rẽ Abimelec wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Gedeṍ bʉcʉ ẽjãyʉꞌrʉgʉ, wẽrĩcʉ niwĩ. Cʉ̃ pacʉ Joáre yááca tutipʉ cʉ̃rẽ sĩosõrõcũuocãrã niwã. Ti tuti Ofra, Abiézer ya curua ya macãpʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Gedeṍ wẽ́rĩ́ca beꞌro maata Israe curuacjãrã apaturi Õꞌacʉ̃rẽ ẽjõpeoduꞌu, Baal peꞌere ẽjõpeocãrã niwã tja. Niꞌcʉ̃ Baal-berit wãmetigʉre ẽjõpeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Õꞌacʉ̃ nipeꞌtirã Israe curuacjãrãrẽ ĩꞌatuꞌtiꞌcãrãrẽ docaqueꞌacã weecʉ niwĩ. Tojo weemicã, Õꞌacʉ̃ na wiogʉ níꞌcʉre acoboja waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Tojo nicã, Gedeṍ, Jerubaal na ninoꞌgʉ̃, Israe curuacjãrãrẽ peje añuse weemicã, na peꞌe cʉ̃ acawererãrẽ añurõ pajañaꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Gedeṍ wẽ́rĩ́ca beꞌro Abimelec Siquẽpʉ cʉ̃ paco acawererãrẽ ĩꞌagʉ̃ waꞌacʉ niwĩ. Narẽ, nipeꞌtirã cʉ̃ paco ya curuacjãrãrẽ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","—Mʉsã aꞌti macã Siquẽcjãrãrẽ sẽrĩtiñaꞌña: ¿Dise peꞌere mʉsã nemorõ ʉasari? ¿Setenta ʉmʉa Jerubaal põꞌrã ʉmʉa mʉsãrẽ duticã ʉasari? ¿O, niꞌcʉ̃ta mʉsãrẽ wiogʉ duticã ʉasari? Wãcũña. Yʉꞌʉ peꞌe mʉsã acaweregʉ waro niꞌi, nicʉ niwĩ Abimelec. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Cʉ̃ paco acawererã Siquẽcjãrãrẽ Abimelec ye cjasere ucũbosacãrã niwã. Na tojo nicã tʉꞌorã, Siquẽcjãrã Abimelere “Marĩ acaweregʉ nimi. Tojo weerã cʉ̃rẽ siruturãsaꞌa”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Cʉ̃rẽ setenta niyeru cujiri plata meꞌrã weeꞌque cujirire Baal-berire ẽjõpeori wiꞌi cjasere oꞌocãrã niwã. Te niyeru meꞌrã ʉmʉa ñaꞌarãrẽ wapaye, sirutuduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Beꞌro cʉ̃ pacʉ ya wiꞌi Ofrapʉ waꞌacʉ niwĩ. Topʉ niꞌcãgã ʉ̃tãgã buꞌipʉ cʉ̃ acawererã setenta Gedeṍ põꞌrãrẽ wẽjẽcãꞌcʉ niwĩ. Gedeṍrẽta Jerubaal pisucãrã niwã. Jotam, dʉꞌsagʉpʉ diaꞌcʉ̃, ãpẽrã ĩꞌatiropʉ duꞌti, yʉꞌrʉcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Beꞌro nipeꞌtirã Siquẽcjãrã, tojo nicã Bet-milocjãrã yucʉ pajicjʉ encina wãmeticjʉ pʉꞌto, ʉ̃tã meꞌrã wééca tuturo na ẽjõpeori tuturo pʉꞌto nerẽcãrã niwã. Topʉ Abimelere wiogʉ sõrõcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Na tojo weecã tʉꞌogʉ, Jotam ʉ̃rʉ̃gʉ̃ Gerizim buꞌipʉ mʉjãa, tocjãrãrẽ ʉpʉtʉ caricũcʉ niwĩ: “Mʉsã Siquẽcjãrã, Õꞌacʉ̃ mʉsãrẽ tʉꞌocã ʉarã, yʉꞌʉre tʉꞌoya. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","”Mʉsãrẽ sẽrĩtiñaꞌgʉ̃ti. ¿Mʉsã Abimelere wiogʉ sõrõrã, queoro weeati? ¿Mʉsã Gedeṍ, cʉ̃ põꞌrãrẽ queoro weeati? ¿Cʉ̃ mʉsãrẽ añurõ weeꞌcaronojõta weeati? ");
INSERT INTO tuoNT_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Yʉꞌʉ pacʉ cʉ̃ catiri ʉmʉcore maꞌitimigʉ̃, mʉsãrẽ aꞌmewẽjẽbosawĩ. Madianita masã doca nirãrẽ yʉꞌrʉogʉ, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Mʉsã peꞌe niꞌcãcã yʉꞌʉ pacʉ acawererã, cʉ̃ põꞌrã setentare niꞌcãgã ʉ̃tãgã buꞌipʉ narẽ wẽjẽ, yʉꞌrʉnʉꞌcãcãrã niapʉ. Apeyema tja mʉsã Abimelec, yʉꞌʉ pacʉre daꞌracoꞌtego macʉ̃rẽ Siquẽrẽ wiogʉ sõrõcãrã niapʉ. Cʉ̃ mʉsã acaweregʉ niyucã, tojo weecãrã niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Mʉsã niꞌcãcã Gedeṍ, cʉ̃ acawererãrẽ queoro, diacjʉ̃ nise meꞌrã wéérã, Abimelec meꞌrã eꞌcatiya. Cʉ̃ quẽꞌrã mʉsã meꞌrã eꞌcatiato. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Mʉsã queoro weeticã pũrĩcãrẽ, pecameꞌe Abimelepʉre wijaa, mʉsã Siquẽcjãrã, tojo nicã Bet-milocjãrãrẽ ʉ̃jʉ̃apeꞌocãꞌto. Mejãrõta pecameꞌe mʉsãpʉre wijaa, Abimelere ʉ̃jʉ̃acõꞌacãꞌto”, nicʉ niwĩ Jotam. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Tojo nitoja, Jotam Beer wãmetiropʉ duꞌtia waꞌacʉ niwĩ. Cʉ̃ maꞌmi Abimelere uigʉ, topʉ niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Abimelec Israe curuacjãrãrẽ iꞌtia cʉ̃ꞌma duticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","Beꞌro Õꞌacʉ̃ Abimelere, Siquẽcjãrã meꞌrã na basu aꞌmetuꞌticã weecʉ niwĩ. Tojo weerã Siquẽcjãrã Abimelere yʉꞌrʉnʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","Õꞌacʉ̃ Abimelec Gedeṍ põꞌrã ʉmʉa setentare wẽjẽꞌque wapa tojo weecʉ niwĩ. Tojo nicã Siquẽcjãrã Abimelec cʉ̃ maꞌmisʉmʉarẽ wẽjẽtamuꞌque wapa na quẽꞌrãrẽ buꞌiri daꞌrecʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","Beꞌropʉre Abimelec Siquẽpʉ ti macãcjãrã meꞌrã aꞌmewẽjẽ, wapataꞌacʉ niwĩ. Tocjãrãrẽ wẽjẽpeꞌocʉ niwĩ. Beꞌro ti macã cjasere cõꞌapeꞌocãꞌcʉ niwĩ. Tojo wééca beꞌro topʉre ne apeyenojõ pĩꞌrĩnemoticãꞌto nígʉ̃, moarẽ doquestecũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","Ãpẽrã Migdal-Siquẽcjãrã ti macã ʉꞌmʉarĩ wiꞌi, na meꞌrã aꞌmewẽjẽrã aꞌtirãrẽ coꞌtedujiati wiꞌipʉ nicãrã niwã. Abimelec Siquẽcjãrãrẽ wẽjẽcã tʉꞌorã, na ẽjõpeogʉ El-berit ẽjõpeori wiꞌipʉ duꞌtisãjãacãrã niwã. Ti wiꞌi ʉ̃tã tʉꞌrʉ yeecãꞌmotaꞌaca wiꞌi nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","48","Abimelec na topʉ nerẽcã tʉꞌogʉ, cʉ̃, cʉ̃ yarã masã meꞌrã ʉ̃rʉ̃gʉ̃ Salmón wãmeticjʉpʉ waꞌacʉ niwĩ. Cõmea meꞌrã yucʉdʉpʉrire dʉte, wʉacʉ niwĩ. Cʉ̃ yarã masãrẽ “Quero, yʉꞌʉ weronojõ weeya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","Nipeꞌtirã yucʉdʉpʉrire dʉte, Siquẽcjãrã na duꞌtiri wiꞌipʉ Abimelere sirutucãrã niwã. Topʉ nipeꞌtise dʉpʉrire seecũu, pecameꞌe wĩjãcãrã niwã. Nipeꞌtirã ti wiꞌipʉre nirã́ mil ʉmʉa, numia ʉ̃jʉ̃peꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","Tojo wééca beꞌro Abimelec Tebes wãmetiri macãpʉ waꞌa, tocjãrã meꞌrã aꞌmewẽjẽ, narẽ docaqueꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","Ti macã poꞌpeapʉ ʉꞌmʉarĩ wiꞌi, surara na coꞌtedujiri wiꞌi nicaro niwʉ̃. Ti wiꞌipʉ nipeꞌtirã ʉmʉa, numia duꞌtisãjãacãrã niwã. Ti wiꞌi sopere biꞌa, ti wiꞌi buꞌipʉ mʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","Abimelec ti wiꞌi sopepʉ eja, tore tuupãꞌrẽ, ʉ̃jʉ̃agʉ̃tigʉ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","Cʉ̃ tojo weegʉti nirĩ cura niꞌcõ numio ti wiꞌi buꞌipʉ nigṍ co trigo tuumʉtõcjare cʉ̃ dʉpoapʉ doquepeoco niwõ. Co tojo weecã, cʉ̃ dʉpoa peꞌtoro bata waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","Maata cʉ̃ wãmorẽ miacoꞌtegʉre piji, cʉ̃rẽ nicʉ niwĩ: “Mʉꞌʉ ya pjĩ miiwĩrõ, yʉꞌʉre ñosẽwẽjẽcãꞌña. ‘Numio cʉ̃rẽ wẽjẽcãꞌmo’ nicã ʉatigʉ, ‘Tojo weeya’ ”, nicʉ niwĩ. Tojo weegʉ cʉ̃rẽ daꞌracoꞌtegʉ cʉ̃rẽ ñosẽwẽjẽcʉ niwĩ. Tojo wee Abimelec wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","Cʉ̃ wẽrĩcã ĩꞌarã, Israe curuacjãrã na ye wiꞌseripʉ dajatojaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","Tojo weegʉ Abimelec cʉ̃ acawererã setentare wẽjẽ́gʉ̃, cʉ̃ pacʉre ñaꞌarõ weeꞌque wapare Õꞌacʉ̃ wapaseecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","Tojo nicã Õꞌacʉ̃ Siquẽcjãrã ʉmʉarẽ na ñaꞌarõ weeꞌque wapare tojo weecʉ niwĩ. Tojo wee Jotam, Gedeṍ macʉ̃ Siquẽcjãrãrẽ “Ñaꞌarõ waꞌarosaꞌa” níꞌque narẽ queoro waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Abimelec wẽ́rĩ́ca beꞌro Isacar ya curuacjʉ̃ Tola wãmetigʉ, Fúa macʉ̃, Dodo pãrãmi, Israe curuacjãrãrẽ narẽ ĩꞌatuꞌtirãrẽ yʉꞌrʉocʉ niwĩ. Cʉ̃ Samir wãmetiri macã Efraĩ́ buꞌpapijaropʉ macãrĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Veintitrés cʉ̃ꞌmarĩ Israe curuacjãrãrẽ duticʉ niwĩ. Beꞌro wẽrĩa waꞌa, Samipʉ yaanoꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Tola beꞌro Jair Galaad wãmetirocjʉ̃ veintidos cʉ̃ꞌmarĩ Israe curuacjãrãrẽ duticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Cʉ̃ treinta ʉmʉa põꞌrãticʉ niwĩ. Nanʉcʉ̃ na yarã burroare pesacãrã niwã. Na treinta macãrĩ Galaare duticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Jair wẽ́rĩ́ca beꞌro Camón wãmetiri macãpʉ cʉ̃rẽ yaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Israe curuacjãrã apaturi Õꞌacʉ̃ ĩꞌorõpʉ ñaꞌarõ weeseticãrã niwã. Na Baal, tojo nicã Astartére ẽjõpeocãrã niwã. Tojo nicã Siria diꞌtacjãrã na ẽjõpeorãrẽ, Sidṍcjãrã, moabita masã, amonita masã, filisteo masã na ẽjõpeorãnojõrẽ ẽjõpeocãrã niwã. Õꞌacʉ̃ peꞌere ẽjõpeoduꞌu, cʉ̃ weedutiꞌquere weeticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","Tojo weegʉ Õꞌacʉ̃ na meꞌrã ua, filisteo masã, amonita masã doca waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","Tojo waꞌari cʉ̃ꞌma meꞌrã dieciocho cʉ̃ꞌmarĩ Israe curuacjãrãrẽ ñaꞌarõ dutipe daꞌraduticãrã niwã. Nipeꞌtirã Israe curuacjãrã dia Jordã́ mujĩpũ mʉjãtiro peꞌecjãrã Galaad diꞌtapʉ nirãrẽ tojo weecãrã niwã. Ti diꞌta amorreo masã ya diꞌta nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Tojo nicã amonita masã Judácjãrã, Benjamícjãrã, Efraĩ́cjãrã meꞌrã aꞌmewẽjẽrãtirã, dia Jordã́pʉ pẽꞌaticãrã niwã. Tojo weerã Israe curuacjãrã pũrõ wioro tʉꞌoñaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Tojo waꞌacã, Israe curuacjãrã Õꞌacʉ̃ cʉ̃ weetamusere sẽrĩcãrã niwã: “Õꞌacʉ̃, mʉꞌʉrẽ ẽjõpeoduꞌu, Baal peꞌere ẽjõpeosiruturã, mʉꞌʉrẽ yʉꞌrʉnʉꞌcãpʉ”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","Õꞌacʉ̃ narẽ yʉꞌticʉ niwĩ: “Dʉporopʉ Egiptocjãrã, amorreo masã, amonita masã, filisteo masã, ");
INSERT INTO tuoNT_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","Sidṍcjãrã, amaleca masã, tojo nicã madianita masã mʉsãrẽ ñaꞌarõ weecã, mʉsã yʉꞌʉre weetamusere sẽrĩcã, yʉꞌʉ mʉsãrẽ yʉꞌrʉowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Yʉꞌʉ tojo weemicã, ãpẽrãnojõrẽ ẽjõpeorãtirã, yʉꞌʉre ẽjõpeoduꞌucãꞌwʉ̃. Tojo weegʉ mʉsãrẽ yʉꞌrʉonemosome majã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","Na mʉsã ẽjõpeorã, mʉsã beseꞌcãrãrẽ na weetamusere sẽrĩrã waꞌaya. Mʉsãrẽ mejẽcã waꞌacã, náta mʉsãrẽ yʉꞌrʉoato”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Cʉ̃ tojo nicã tʉꞌorã, Israe curuacjãrã Õꞌacʉ̃rẽ aꞌtiro nicãrã niwã: “Ʉ̃sã mʉꞌʉrẽ yʉꞌrʉnʉꞌcãpʉ. Noꞌo mʉꞌʉ ʉ̃sãrẽ weesĩꞌrĩrõnojõ weeya. Mejõ niꞌcãrõacã waroma ʉ̃sãrẽ yʉꞌrʉoya”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Na tojo níca beꞌro ape diꞌtacjãrã na ẽjõpeorãnojõ na waꞌteropʉ nirãrẽ cõꞌa, Õꞌacʉ̃rẽ apaturi ẽjõpeocãrã niwã tja. Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ na piꞌetisere ĩꞌanemosĩꞌrĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Beꞌro amonita masã Israe curuacjãrã meꞌrã aꞌmewẽjẽrãtirã, nerẽ, Galaapʉ cãrĩcãrã niwã. Israe curuacjãrã peꞌe nerẽqueꞌa, Mizpapʉ cãrĩrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Galaacjãrã wiorã aꞌmerĩ ucũcãrã niwã: “Noꞌo amonita masãrẽ sʉꞌori ʉꞌmʉtã, aꞌmewẽjẽgʉ̃nojõ, cʉ̃́ta nipeꞌtirã Galaacjãrã wiogʉ sãjãgʉ̃sami”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Jefté, Galaad diꞌtacjʉ̃, aꞌmewẽjẽtutuagʉ nicʉ niwĩ. Cʉ̃ pacʉ Galaad nicʉ niwĩ. Cʉ̃ paco peꞌe ʉmʉa meꞌrã aꞌmetãrãsijari masõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Galaad nʉmo quẽꞌrã ʉmʉarẽ põꞌrãtico niwõ. Na bʉcʉarã, Jeftére na ya wiꞌipʉ nimiꞌcʉre cõꞌawĩrõcãrã niwã. Cʉ̃rẽ aꞌtiro nicãrã niwã: “Mʉꞌʉ apego macʉ̃ niꞌi. Tojo weegʉ marĩ pacʉ cʉ̃ wẽ́rĩ́ca beꞌro cũuatjere ñeꞌesome”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Na tojo nicã, Jefté cʉ̃ acawererãrẽ duꞌtigʉ, apero Tob wãmetiropʉ macãrĩ waꞌacʉ niwĩ. Topʉ ʉmʉa noꞌo ʉaro weemaꞌarãrẽ, na tʉꞌomasĩrõ marĩrõ weesetirãrẽ neocũucʉ niwĩ. Cʉ̃ meꞌrã baꞌpatisijacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Beꞌropʉ amonita masã Israe curuacjãrã meꞌrã aꞌmewẽjẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Na tojo weeri cura Galaad wiorã Jefté Tob wãmetiropʉ nigʉ̃rẽ pijirã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","—Aꞌtia. Marĩ amonita masã meꞌrã aꞌmewẽjẽrã waꞌacã, mʉꞌʉ ʉ̃sã wiogʉ nicã ʉasaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Jefté narẽ nicʉ niwĩ: —Mʉsã yʉꞌʉre ĩꞌasĩꞌrĩti, yʉꞌʉ pacʉ ya wiꞌipʉ níꞌcʉre cõꞌawĩrõcãꞌwʉ̃. ¿Deꞌro weerã niꞌcãrõacãrẽ mʉsãrẽ mejẽcã waꞌacã, yʉꞌʉ tiropʉ aꞌtiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Galaacjãrã bʉcʉrã cʉ̃rẽ nicãrã niwã: —Tojo weeꞌcãrã nimirã, niꞌcãrõacãrẽ mʉꞌʉrẽ aꞌmarã aꞌtiapʉ. Mʉꞌʉ ʉ̃sã meꞌrã aꞌti, amonita masã meꞌrã aꞌmewẽjẽcã ʉaꞌa. Tojo nicã, mʉꞌʉ nipeꞌtirã Galaacjãrã wiogʉ sãjãcã ʉaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Jefté narẽ yʉꞌticʉ niwĩ: —Mʉsã yʉꞌʉre amonita masã meꞌrã aꞌmewẽjẽato nírã miacã, tojo nicã Õꞌacʉ̃ yʉꞌʉre narẽ docaqueꞌacã weecã, diacjʉ̃ta mʉsã wiogʉ nigʉ̃ti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Cʉ̃ tojo nicã tʉꞌorã, Galaacjãrã bʉcʉrã cʉ̃rẽ yʉꞌticãrã niwã: —Õꞌacʉ̃ marĩ ucũsere tʉꞌogʉ weemi. Nirõta mʉꞌʉ nírõnojõta weerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Tojo weegʉ Jefté Galaacjãrã bʉcʉrã meꞌrã waꞌacʉ niwĩ. Nipeꞌtirã masã cʉ̃rẽ na wiogʉ sõrõcãrã niwã. Jefté nipeꞌtise cʉ̃ narẽ níꞌquere apaturi Mizpapʉ Õꞌacʉ̃ tʉꞌoropʉ nicʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Beꞌro Jefté queti wererãrẽ amonita masã wiogʉ tiro oꞌócʉ niwĩ. Cʉ̃rẽ aꞌtiro ni sẽrĩtiñaꞌduticʉ niwĩ: “¿Ñeꞌe buꞌiri mʉꞌʉ ʉ̃sã ya diꞌtapʉ sãjãti, ʉ̃sã meꞌrã aꞌmewẽjẽsĩꞌrĩti?” ni queti oꞌócʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Amonita masã wiogʉ Jefté cʉ̃ quetiweredutigʉ oꞌóꞌcãrãrẽ yʉꞌticʉ niwĩ: “Israe curuacjãrã Egiptopʉ níꞌcãrã wijarã, dia Arnón meꞌrã nʉꞌcã, téé Jaboc, Jordã́ wãmetise maarĩ waꞌtero nise diꞌtare ẽꞌmacãrã niwã. Tojo weerã aꞌmewẽjẽse marĩrõ te diꞌtare yʉꞌʉre wiaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Tere tʉꞌogʉ, Jefté ãpẽrã queti wererãrẽ amonita masã wiogʉre oꞌócʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","Aꞌte quetire cʉ̃rẽ werenemoduticʉ niwĩ: “Jefté mʉꞌʉrẽ aꞌtiro ni weredutiami: ‘Israe curuacjãrã moabita masã ye diꞌta, tojo nicã amonita masã ye diꞌtare ẽꞌmaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Na Egiptopʉ níꞌcãrã wijarã, yucʉ marĩrõpʉ waꞌa, yʉꞌrʉacãrã niwã. Téé Maa sõꞌarĩ maajopʉ yʉꞌrʉpẽꞌa waꞌa, beꞌro Cadespʉ ejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Topʉ nírã, Israe curuacjãrã edomita masã wiogʉre queti wererãrẽ oꞌócãrã niwã. Cʉ̃rẽ aꞌtiro nicãrã niwã: “Ʉ̃sã mʉsã ya diꞌtapʉ yʉꞌrʉtẽrĩwãꞌcãcã, ‘Añurõsaꞌa’ niña”. Edomita masã wiogʉ peꞌe narẽ yʉꞌrʉtẽrĩcã ʉaticʉ niwĩ. Moabita masã wiogʉ quẽꞌrãrẽ mejãrõta sẽrĩcãrã niwã. Cʉ̃ quẽꞌrã cʉ̃ ya diꞌtare narẽ yʉꞌrʉtẽrĩcã ʉaticʉ niwĩ. Tojo weerã Israe curuacjãrã Cadespʉ tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","” ’Beꞌro na yucʉ marĩrõpʉ yʉꞌrʉtẽrĩ, Edom, Moab diꞌta sumuto yʉꞌrʉa, Moab diꞌta mujĩpũ mʉjãtiro peꞌe eja, dia Arnón ape pãꞌrẽ peꞌe tojaqueꞌacãrã niwã. Dia Arnón meꞌrã Moab diꞌta nʉꞌcãcaro niwʉ̃. Tojo weerã Moab diꞌta peꞌere sãjãtícãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","” ’Beꞌro tja Israe curuacjãrã queti wererãrẽ Sehón, amorreo masã wiogʉ, Hesbón wãmetiri macãcjʉ̃ tiropʉ oꞌócãrã niwã. Cʉ̃rẽ “Ʉ̃sã ya diꞌtapʉ waꞌacã, mʉꞌʉ ya diꞌtapʉ yʉꞌrʉtẽrĩwãꞌcãdutiya”, ni sẽrĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Sehón peꞌe Israe curuacjãrã tojo nisere ẽjõpeoticʉ niwĩ. Tojo weegʉ narẽ cʉ̃ ya diꞌtapʉ yʉꞌrʉtẽrĩcã cãꞌmotaꞌacʉ niwĩ. Cʉ̃ yarã surarare neocũu, Jahas tiropʉ tojaqueꞌacã weecʉ niwĩ. Tojo wee Israe curuacjãrã meꞌrã aꞌmewẽjẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","Beꞌro Õꞌacʉ̃, Israe curuacjãrã wiogʉ, narẽ Sehṍrẽ, cʉ̃ yarãrẽ docaqueꞌacã weecʉ niwĩ. Nipeꞌtise amorreo masã ya diꞌtare na ya diꞌta tojacã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Dia Arnón meꞌrã nʉꞌcã, téé dia Jaboc na ye diꞌta tojacaro niwʉ̃. Tojo nicã, yucʉ marĩrõ meꞌrã téé dia Jordã́pʉ nitʉocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","¿Niꞌcãrõacãrẽ Õꞌacʉ̃ amorreo masãrẽ cõꞌawĩrõꞌque diꞌtare, Israe curuacjãrãrẽ oꞌoꞌque diꞌtare ʉ̃sãrẽ cõꞌasĩꞌrĩti? ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Yʉꞌʉ mʉꞌʉrẽ ñaꞌarõ weetiapʉ. Mʉꞌʉ peꞌe ʉ̃sã meꞌrã aꞌmewẽjẽgʉ̃ aꞌtigʉ, yʉꞌʉre ñaꞌarõ weegʉ weeꞌe. Õꞌacʉ̃, nipeꞌtirãrẽ besegʉ ¿noa ye diꞌta nisari? nígʉ̃, Israe curuacjãrãrẽ, amorreo masãrẽ queoro besegʉsami’ ”, nicʉ niwĩ Jefté. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Cʉ̃ tojo nimicã, amonita masã wiogʉ Jefté níꞌquere tʉꞌosĩꞌrĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Beꞌro Espíritu Santu Jeftére sãjãacʉ niwĩ. Cʉ̃ tutuaro meꞌrã Jefté Galaacjãrã ya diꞌta, tojo nicã Manasés ya curuacjãrã ya diꞌtare yʉꞌrʉtẽrĩcʉ niwĩ. Amonita masã ya diꞌtare sãjãgʉ̃, Mizpa Galaad nirĩ macã meꞌrã yʉꞌrʉacʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Jefté amonita masã meꞌrã aꞌmewẽjẽgʉ̃ waꞌacʉ niwĩ. Õꞌacʉ̃ Jeftére narẽ docaqueꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Jefté pãjãrã cʉ̃rẽ ĩꞌatuꞌtirã meꞌrã aꞌmewẽjẽcʉ niwĩ. Veinte macãrĩcjãrãrẽ Aroer meꞌrã, téé Minit, Abel-keramimpʉ docaqueꞌacã weecʉ niwĩ. Tojo weerã Israe curuacjãrã amonita masãrẽ na doca tojacã weecãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","Jefté seis cʉ̃ꞌmarĩ Israe curuacjãrã wiogʉ nicʉ niwĩ. Cʉ̃ wẽ́rĩ́ca beꞌro Galaapʉ, cʉ̃ bajuáca macãpʉ cʉ̃rẽ yaacãrã niwã. ***** ");
INSERT INTO tuoNT_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Apaturi Israe curuacjãrã Õꞌacʉ̃ ĩꞌorõpʉ ñaꞌarõ weecãrã niwã. Na tojo weecã ĩꞌagʉ̃, Õꞌacʉ̃ narẽ filisteo masãrẽ wiacʉ niwĩ. Tojo weerã cuarenta cʉ̃ꞌmarĩ na dutise doca nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Niꞌcʉ̃ ʉmʉ Manoa wãmetigʉ Dan ya curuacjʉ̃ nicʉ niwĩ. Zoracjʉ̃ nicʉ niwĩ. Manoa nʉmo põꞌrãmarĩgõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã co tiro eta, aꞌtiro nicʉ niwĩ: “Mʉꞌʉ põꞌrãmarĩgõ niꞌi. Niꞌcãrõacãrẽ nijĩpaco waꞌa, niꞌcʉ̃ põꞌrãtigosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ne vino, siꞌbioꞌquere sĩꞌrĩticãꞌña. Tojo nicã Moisé baꞌadutitiꞌquenojõrẽ baꞌaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Mʉꞌʉ põꞌrãtiacjʉ ne poari seenoꞌña marĩgʉ̃sami. Cʉ̃ bajuati dʉporo Õꞌacʉ̃ yagʉ, Nazareo masʉ̃ cũunoꞌyutojagʉsami. Cʉ̃ Israe curuacjãrã filisteo masãrẽ daꞌracoꞌteꞌcãrãrẽ yʉꞌrʉweticã weenʉꞌcãgʉ̃sami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Cʉ̃ tojo níca beꞌro Manoa nʉmo marãpʉ tiropʉ waꞌa, aꞌtiro ni wereco niwõ: “Õꞌacʉ̃ oꞌóꞌcʉ yʉꞌʉ tiro etami. Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcãꞌcʉ bajuami. ‘¿Noꞌocjʉ̃ niti mʉꞌʉ?’ ni sẽrĩtiñaꞌtiasʉ. Cʉ̃ quẽꞌrã cʉ̃ wãmerẽ weretiami. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Aꞌtiro niami: ‘Mʉꞌʉ nijĩpaco waꞌa, niꞌcʉ̃ põꞌrãtigosaꞌa. Niꞌcãcã meꞌrã ne vinorẽ, siꞌbioꞌquere sĩꞌrĩticãꞌña. Moisé baꞌadutitiꞌquenojõrẽ baꞌaticãꞌña. Cʉ̃ wĩꞌmagʉ̃ ne bajuaꞌcʉ téé wẽrĩgʉ̃pʉ Õꞌacʉ̃ yagʉ nazarero masʉ̃ nigʉ̃sami,’ niami”, ni wereco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Co tojo nicã tʉꞌogʉ, Manoa Õꞌacʉ̃rẽ aꞌtiro ni sẽrĩcʉ niwĩ: “Õꞌacʉ̃, mʉꞌʉ ʉ̃sãrẽ oꞌóꞌcʉre apaturi ʉ̃sã tiropʉ oꞌóya tja. Cʉ̃ wĩꞌmagʉ̃ bajuacjʉre deꞌro wee masõrãsari, ni weregʉ aꞌtiato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Õꞌacʉ̃ cʉ̃ sẽrĩsere tʉꞌo, Manoa nʉmo cãpũpʉ nigõrẽ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, apaturi core bajuacʉ niwĩ. Co marãpʉ Manoa peꞌe co meꞌrã marĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Cʉ̃ bajuacã ĩꞌagõ, sojaro meꞌrã co marãpʉre werego waꞌaco niwõ: —Cãrʉ̃ yʉꞌʉ ĩꞌaꞌcʉ apaturi bajuami tja, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Co tojo nicã tʉꞌogʉ, Manoa wãꞌcãnʉꞌcã, cʉ̃ nʉmorẽ sirutuwãꞌcã, cʉ̃ tiropʉ ejacʉ niwĩ. —¿Mʉꞌʉta niti yʉꞌʉ nʉmo meꞌrã ucũꞌcʉ? ni sẽrĩtiñaꞌcʉ niwĩ. —Ʉ̃ʉ, cʉ̃ta niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Cʉ̃ tojo nicã tʉꞌogʉ, Manoa cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ wereꞌque queoro waꞌacã, ¿ʉ̃sã deꞌro wee wĩꞌmagʉ̃rẽ masõrãsari? ¿Deꞌro weerãsari cʉ̃ meꞌrã? ni sẽrĩtiñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, cʉ̃rẽ aꞌtiro yʉꞌticʉ niwĩ: —Mʉꞌʉ nʉmo nipeꞌtise yʉꞌʉ core wereꞌquere weeato. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Ne cãꞌrõ ʉꞌsedʉcaco, tojo nicã vino, siꞌbioꞌquere sĩꞌrĩticãꞌto. Te ʉꞌsepaganojõ meꞌrã weeꞌque quẽꞌrãrẽ baꞌaticãꞌto. Tojo nicã Moisé baꞌadutitiꞌquenojõrẽ baꞌaticãꞌto. Nipeꞌtise yʉꞌʉ core dutiꞌquere weeato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Beꞌro Manoa cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ ʉ̃sã meꞌrã tojáníña yujupʉ. Mʉꞌʉ baꞌacã, niꞌcʉ̃ cabracãrẽ wẽjẽ, doꞌarãtirã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Cʉ̃ peꞌe Manoarẽ yʉꞌticʉ niwĩ: —Mʉsã yʉꞌʉre tojadutimicã, mʉsã baꞌasere baꞌasome. Mejõ peꞌe Õꞌacʉ̃rẽ cabracãrẽ wẽjẽ ʉ̃jʉ̃amorõpeoya. Manoa cʉ̃ “Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcãmi”, ni masĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Beꞌro Manoa cʉ̃rẽ nicʉ niwĩ: —¿Deꞌro wãmetiti mʉꞌʉ? Mʉꞌʉ ʉ̃sãrẽ wereꞌque queoro waꞌacã ĩꞌarã, ãpẽrã tʉꞌoropʉ mʉꞌʉrẽ “Diacjʉ̃ta wereapĩ”, nirãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Cʉ̃ peꞌe Manoarẽ yʉꞌticʉ niwĩ: —¿Deꞌro weegʉ yʉꞌʉ wãmerẽ masĩsĩꞌrĩti? Yʉꞌʉ werecãma, mʉsã tʉꞌomarĩa waꞌabosaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Beꞌro Manoa cabracãrẽ wẽjẽ, tojo nicã otese dʉca perire míí, ʉ̃tã buꞌipʉ ʉ̃jʉ̃amorõpeo, Õꞌacʉ̃rẽ eꞌcatipeocʉ niwĩ. Manoa, cʉ̃ nʉmo na ĩꞌarĩ cura Õꞌacʉ̃ na ĩꞌatiꞌquenojõrẽ ĩꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Pecameꞌe oꞌme mʉjãarĩ cura Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcã, oꞌme waꞌteropʉ mʉjãa waꞌacʉ niwĩ. Tojo weecã ĩꞌarã, Manoa, cʉ̃ nʉmo diꞌtapʉ paamuꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Cʉ̃ narẽ apaturi bajuaticã, Manoa “Õꞌacʉ̃ cʉ̃ basuta nimigʉ̃, cʉ̃rẽ werecoꞌtegʉ weronojõ upʉsãjãnʉꞌcãpĩ”, ni masĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Tojo weegʉ cʉ̃ nʉmorẽ nicʉ niwĩ: —Marĩ Õꞌacʉ̃rẽ ĩꞌapʉ. Tojo weerã marĩ wẽrĩrãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Cʉ̃ nʉmo peꞌe nico niwõ: —Õꞌacʉ̃ marĩrẽ wẽjẽsĩꞌrĩgʉ̃, aꞌte marĩ ʉ̃jʉ̃amorõpeoꞌquere, tojo nicã otese dʉca peri marĩ oꞌoꞌquere ñeꞌetibopĩ. Aꞌtere ĩꞌotibopĩ. Tojo nicã, marĩrẽ aꞌtere weretibopĩ, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Beꞌro Manoa nʉmo wĩꞌmagʉ̃rẽ põꞌrãtigo, cʉ̃rẽ Sansón wãmeyeco niwõ. Wĩꞌmagʉ̃ bʉcʉacã, Õꞌacʉ̃ cʉ̃rẽ añurõ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Siapeꞌe meꞌrã bʉcʉa, niꞌcã nʉmʉ Sansón Dan ya curuacjãrã ya diꞌtapʉ nirĩ cura Espíritu Santu cʉ̃pʉre sãjãnʉꞌcãcʉ niwĩ. Zora, Estaol wãmetise macãrĩ waꞌteropʉ tojo waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Niꞌcã nʉmʉ Sansón Timnat wãmetiri macãpʉ buꞌacʉ niwĩ. Topʉ niꞌcõ numio filisteo masõrẽ ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Beꞌro wiꞌipʉ dajagʉ, cʉ̃ pacʉsʉmʉarẽ werecʉ niwĩ: —Timnapʉ niꞌcõ filisteo masõrẽ ĩꞌapʉ. Yʉꞌʉre numisẽrĩbosarã waꞌaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Cʉ̃ pacʉsʉmʉa cʉ̃rẽ yʉꞌticãrã niwã: —¿Deꞌro weegʉ mʉꞌʉ sõjã filisteo masã, Õꞌacʉ̃rẽ ẽjõpeotirã waꞌteropʉre mʉꞌʉ nʉmo niacjore aꞌmati? ¿Marĩ Israe curuacjãrã waꞌteropʉre mʉꞌʉ basucãrã numia mʉꞌʉ meꞌrã omocã dʉꞌteacjo marĩti? nicãrã niwã. Sansón peꞌe pacʉsʉmʉarẽ yʉꞌticʉ niwĩ: —Core miirã waꞌaya. Yʉꞌʉ tʉꞌsago niamo, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Õꞌacʉ̃ filisteo masãrẽ cõꞌagʉ̃ti nígʉ̃, tojo weecʉ niwĩ. Cʉ̃ pacʉsʉmʉa “Aꞌte Õꞌacʉ̃ cʉ̃ cũuꞌque nisaꞌa”, ni masĩticãrã niwã. Titapʉre filisteo masã Israe curuacjãrãrẽ duticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Beꞌro Sansón cʉ̃ pacʉsʉmʉa meꞌrã Timnapʉ buꞌacãrã niwã. Na Timnat ʉꞌse wesepʉ ejari cura, wãcũña marĩrõ yai wĩꞌmagʉ̃ Sansón tiropʉ “Jii” piꞌaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Espíritu Santu Sansṍpʉre sãjãa, tutuase cʉ̃rẽ oꞌocʉ niwĩ. Tojo weegʉ cʉ̃ omocãrĩ meꞌrã diaꞌcʉ̃ yaire wẽjẽgʉ̃, tʉ̃asurecãꞌcʉ niwĩ. Cabra wĩꞌmagʉ̃rẽ tʉ̃asurero weronojõ tojo weecʉ niwĩ. Tojo weemigʉ̃, cʉ̃ pacʉsʉmʉarẽ cʉ̃ weeꞌquere wereticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Beꞌro numio tiropʉ buꞌa, co meꞌrã ucũcʉ niwĩ. Core tʉꞌsayʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Beꞌro co meꞌrã omocã dʉꞌtegʉtigʉ buꞌagʉ, yai cʉ̃ wẽjẽꞌcʉre maꞌa ojaropʉ ĩꞌagʉ̃ waꞌacʉ niwĩ. Cʉ̃ upʉmejãrõrẽ mumia yeebiꞌaqueꞌa, na te co meꞌrã sãñacã ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Tere míí, neꞌrẽbuꞌacʉ niwĩ. Cʉ̃ pacʉsʉmʉarẽ bocaejagʉ, narẽ ecacʉ niwĩ. Na quẽꞌrã tere neꞌrẽcãrã niwã. “Topʉ miapʉ” ni wereticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Beꞌro cʉ̃ pacʉ cʉ̃ macʉ̃ nʉmo niacjore ĩꞌagʉ̃ buꞌacʉ niwĩ. Topʉ Sansón bosenʉmʉ weepeocʉ niwĩ. Na maꞌmapjia omocã dʉꞌteatji dʉporo weewʉaronojõ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Filisteo masã cʉ̃ ejacã ĩꞌarã, cʉ̃rẽ baꞌpatiajãrẽ treinta ʉmʉa oꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Sansón narẽ nicʉ niwĩ: —Mʉsãrẽ níbocapesere werema. Siete nʉmʉrĩ bosenʉmʉ nise nʉmʉrĩ queoro mʉsã níbocacã, yʉꞌʉ mʉsãnʉcʉ̃ niꞌcãrõ suꞌtiro lino meꞌrã wééca suꞌtiro, tojo nicã bosenʉmʉ sãñawʉase suꞌtinojõrẽ oꞌogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Mʉsã níbocatirã pũrĩcã, yʉꞌʉre treinta suꞌti lino meꞌrã weeꞌque suꞌti, tojo nicã ticʉse bosenʉmʉ sãñawʉase suꞌtinojõrẽ oꞌorãsaꞌa, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌorã, “Jaʉ, mʉꞌʉ níbocasere ʉ̃sãrẽ wereya”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Beꞌro narẽ werecʉ niwĩ: “Baꞌayapiꞌcʉpʉre baꞌase wijasaꞌa. Tutuagʉre iꞌpitise wijasaꞌa”, nicʉ niwĩ. Itia nʉmʉ na níbocamasĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Baꞌparitise waꞌari nʉmʉrẽ Sansón nʉmo niacjore aꞌtiro nicãrã niwã: —Mʉꞌʉ marãpʉ niacjʉre te níbocasere weredutiya. Mʉꞌʉ wereticã, mʉꞌʉrẽ, mʉꞌʉ pacʉ acawererãrẽ ʉ̃jʉ̃apeꞌocãꞌrãsaꞌa. ¿Ʉ̃sã yere yajasĩꞌrĩgõ, ʉ̃sãrẽ pijiati? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Na tojo nicã tʉꞌogo, Sansón nʉmo cʉ̃ tiropʉ waꞌa, utigota, cʉ̃rẽ nico niwõ: —Mʉꞌʉ yʉꞌʉre ʉaweꞌe. Ne yʉꞌʉre maꞌiweꞌe. Yʉꞌʉ acawererãrẽ níbocasere sẽrĩtiñaꞌcʉ niapʉ. Yʉꞌʉ peꞌere weretiapʉ, nico niwõ. Sansón core yʉꞌticʉ niwĩ: —Te níbocasere yʉꞌʉ pacʉsʉmʉa marĩcãrẽ weretiapʉ. ¿Deꞌro weegʉ mʉꞌʉ peꞌema werebosari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Cʉ̃ weretiꞌque buꞌiri ti semanarẽ utipeꞌocãꞌco niwõ. Nitʉori nʉmʉrẽ tʉꞌomí, caributi, core werecʉ niwĩ. Tere tʉꞌogo, co acawererãrẽ wereturiaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Bosenʉmʉ nitʉori nʉmʉ mujĩpũ sãjãrĩ cura, ti macãcjãrã ʉmʉa Sansṍrẽ nicãrã niwã: “Mumiaco nemorõ iꞌpitise apeyepʉa baꞌase marĩꞌi. Yai yʉꞌrʉoro tutuagʉ marĩmi”, nicãrã niwã. Na tojo nicã tʉꞌogʉ, Sansón narẽ yʉꞌticʉ niwĩ: “Yago wecʉo meꞌrã diꞌta seꞌemorẽcũuwãꞌcãtirã, níbocasere masĩtibopã”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Maata Espíritu Santu tutuaro meꞌrã cʉ̃pʉre sãjãacʉ niwĩ. Tojo weegʉ Sansón Ascalón wãmetiri macãpʉ buꞌacʉ niwĩ. Tocjãrã ʉmʉa treintare wẽjẽ, na suꞌti sãñaꞌquere ẽꞌmacʉ niwĩ. Tere cʉ̃ níbocasere wereꞌcãrãrẽ oꞌocʉ niwĩ. Na meꞌrã pũrõ uagʉ, cʉ̃ pacʉ ya wiꞌipʉ dajacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Tere ĩꞌagʉ̃, Sansón mañecʉ̃ níꞌcʉ cʉ̃ macõrẽ na omocã dʉꞌtecã coꞌteꞌcʉ peꞌere numisocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Yoáca beꞌro trigo bʉcʉatuꞌajari cura Sansón cʉ̃ nʉmorẽ ĩꞌagʉ̃ waꞌagʉ, niꞌcʉ̃ cabracãrẽ miacʉ niwĩ. Topʉ ejagʉ, aꞌtiro ni wãcũcʉ niwĩ: “Yʉꞌʉ nʉmo ya tucũpʉ sãjãagʉ̃ti”, nicʉ nimiwĩ. Co pacʉ peꞌe cʉ̃rẽ sãjãadutiticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Aꞌtiro nicʉ niwĩ: —Yʉꞌʉ aꞌtiro wãcũwʉ̃. Yʉꞌʉ macõrẽ ne ʉatisami, nimiwʉ̃. Tojo weegʉ mʉꞌʉ meꞌrãcjʉ̃rẽ core oꞌowʉ. Co acabijo co yʉꞌrʉoro añugõ nimo. Co peꞌere miaña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Sansón cʉ̃rẽ yʉꞌticʉ niwĩ: —Niꞌcãrõacã pũrĩcãrẽ filisteo masãrẽ ñaꞌarõ wéégʉ, buꞌiri moogʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Tojo weegʉ cʉ̃ trescientos zorra, diayia weronojõ bajurãrẽ ñeꞌe, pʉarẽrã na ye pĩcõrĩrẽ dʉꞌtecũucʉ niwĩ. Te cʉ̃ dʉꞌteꞌcaropʉ ope tĩarĩ õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Te tĩarĩrẽ sĩꞌayoo, filisteo masã na otese cʉoropʉ zorrare duꞌuoꞌocʉ niwĩ. Nipeꞌtise trigo na tʉ̃ꞌrẽcũuꞌque mesãrĩ, ʉꞌse weseri, olivo weseri ʉ̃jʉ̃ñeꞌepeꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Filisteo masã tere ĩꞌarã, “¿Noa tojo weeapari?” ni, aꞌmerĩ sẽrĩtiñaꞌcãrã niwã. “Sansón, Timnacjʉ̃ buji tojo weecʉ niami. Cʉ̃ nʉmorẽ cʉ̃ meꞌrãcjʉ̃rẽ oꞌoꞌque buꞌiri tojo weecʉ niami”, ni werenoꞌcãrã niwã. Tere tʉꞌorã, filisteo masã core, co pacʉre ʉ̃jʉ̃acõꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Beꞌro Sansón narẽ nicʉ niwĩ: —Mʉsã tojo weeꞌque wapa yʉꞌʉ mʉsã meꞌrã tojo aꞌpepũrĩnuꞌcũgʉ̃saꞌa. Téé mʉsãrẽ aꞌméca beꞌropʉ añugʉ̃saꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Ʉpʉtʉ uatjĩagʉ̃, na meꞌrã aꞌmewẽjẽ, pãjãrãrẽ wẽjẽcʉ niwĩ. Tojo weetuꞌajanʉꞌcõ, ʉ̃tãgã Etam wãmeticja nirĩ tutipʉ buꞌa, topʉ niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Beꞌro filisteo masã Judá diꞌtapʉ majãa, topʉ nerẽcãrã niwã. Téé Lehi pʉꞌtopʉ tuustenʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Judácjãrã narẽ sẽrĩtiñaꞌcãrã niwã: —¿Deꞌro weerã ʉ̃sã meꞌrã aꞌmewẽjẽrã aꞌtiati? Na yʉꞌticãrã niwã: —Ʉ̃sã Sansṍrẽ ñeꞌerã aꞌtirã weeapʉ. Ʉ̃sãrẽ cʉ̃ ñaꞌarõ weeꞌcaronojõta cʉ̃rẽ aꞌmerãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Tere tʉꞌorã, iꞌtiati mil ʉmʉa Judácjãrã ʉ̃tãgã Etam wãmeticja nirĩ tutipʉ buꞌacãrã niwã. Sansṍrẽ aꞌtiro nicãrã niwã: —¿Mʉꞌʉ masĩweti? Filisteo masã marĩrẽ dutirã, marĩ nemorõ tutuarã nima. ¿Deꞌro weegʉ ʉ̃sãrẽ tojo weeati? Narẽ yʉꞌticʉ niwĩ: —Na yʉꞌʉre weeꞌcaronojõta yʉꞌʉ quẽꞌrã mejãrõta weeapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Cʉ̃ tojo nicã tʉꞌorã, cʉ̃rẽ aꞌtiro nicãrã niwã: —Filisteo masãrẽ wiarãtirã, mʉꞌʉrẽ dʉꞌterã aꞌtirã weeapʉ. Sansón narẽ yʉꞌticʉ niwĩ: —Õꞌacʉ̃ wãme meꞌrã wãmepeo, “Mʉꞌʉrẽ wẽjẽsome”, niña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Cʉ̃ tojo nicã tʉꞌorã, “Jaʉ”, nicãrã niwã. “Mejõ mʉꞌʉrẽ dʉꞌte, filisteo masãrẽ wiarãti. Mʉꞌʉrẽ wẽjẽsome”, nicãrã niwã. Tojo weerã pʉa da pũnʉꞌmo dari, maꞌma dari meꞌrã cʉ̃rẽ dʉꞌtecãrã niwã. Dʉꞌte, cʉ̃rẽ ʉ̃tã tutipʉ níꞌcʉre miiwijaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Cʉ̃ Lehipʉ ejari curare filisteo masã cʉ̃rẽ ĩꞌarã, pũrõ eꞌcatise meꞌrã caricũwãꞌcãticãrã niwã. Na tojo weecã, Espíritu Santu tutuaro meꞌrã cʉ̃pʉre sãjãacʉ niwĩ. Cʉ̃pʉre sãjãcã, cʉ̃rẽ dʉꞌteꞌque dari lino ʉ̃jʉ̃ꞌque caꞌbise dari weronojõ waꞌacaro niwʉ̃. Tojo weero te dari surustedijacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Beꞌro burro ʉséca õꞌa, bopoticureri õꞌarẽ boca, ti õꞌa meꞌrã mil ʉmʉarẽ wẽjẽcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Beꞌro Sansón nicʉ niwĩ: “Burro ʉséca õꞌa meꞌrã wẽjẽ, narẽ pʉa mesã seeneocũuapʉ. Burro ʉséca õꞌa meꞌrã mil ʉmʉarẽ wẽjẽcãꞌpʉ”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Cʉ̃ tojo níca beꞌro ti õꞌarẽ cõꞌacãꞌcʉ niwĩ. Cʉ̃ aꞌmewẽjẽꞌcarore Ramat-lehi wãmeyecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Cʉ̃ aꞌmewẽjẽca beꞌro pũrõ acowʉocʉ niwĩ. Tojo weegʉ Õꞌacʉ̃rẽ ʉpʉtʉ sẽrĩcʉ niwĩ: “Yʉꞌʉ mʉꞌʉrẽ daꞌracoꞌtegʉ niꞌi. Mʉꞌʉ yʉꞌʉre filisteo masã meꞌrã aꞌmewẽjẽcã, narẽ docaqueꞌacã weeapʉ. ¿Niꞌcãrõacãma acowʉose meꞌrã wẽrĩgʉ̃sari? ¿Tojo nicã ãꞌrã mʉꞌʉrẽ ẽjõpeotirã tiropʉ wẽrĩgʉ̃sari?” nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Cʉ̃ tojo nicã tʉꞌogʉ, Õꞌacʉ̃ niꞌcã cope aco wijacã weecʉ niwĩ. Ti pe wijasepʉre Sansón aco sĩꞌrĩcʉ niwĩ. Sĩꞌrĩtoja, mejãrõta tutuagʉ waꞌacʉ niwĩ tja. Tojo weero aco wijari pe En-hacore wãmeyenoꞌcaro niwʉ̃. Topʉ Lehipʉ aco wijari pe nidecotiꞌi yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Filisteo masã na duticaterore Sansón veinte cʉ̃ꞌmarĩ Israe curuacjãrãrẽ sʉꞌori niseticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Niꞌcã nʉmʉ Sansón Gaza wãmetiri macãpʉ waꞌacʉ niwĩ. Topʉ ejagʉ, niꞌcõ numio ʉmʉarẽ aꞌmetãrãwapataꞌari masõrẽ ĩꞌacʉ niwĩ. Beꞌro co ya wiꞌipʉ co meꞌrã cãrĩgʉ̃ sãjãacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Gazacjãrã “Sansón ti macãpʉ niapʉ” nicã tʉꞌocãrã niwã. Tojo weerã ti macã sãjãrĩ sope pʉꞌto cãꞌmotaꞌanʉꞌcãeja, coꞌteboꞌreacãrã niwã. “Boꞌreacã cʉ̃rẽ wẽjẽrãti” nírã, ti ñamirẽ ne cʉ̃rẽ cariboticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Sansón peꞌe ñami deco wãꞌcã, ti macã cja sopere te botari meꞌrãta duꞌuamí, tere wʉa, ʉ̃rʉ̃gʉ̃ Hebrṍ wãmetiri macã põtẽorõ nicjʉ buꞌipʉ miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Beꞌropʉ cʉ̃ niꞌcõ numio Dalila wãmetigore ʉacʉ niwĩ. Co eꞌsari pa ʉ̃rʉ̃pagʉ deco nirĩ pa Sorec wãmetiri paꞌtirocjõ nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Tere masĩrã, filisteo masã wiorã co tiropʉ waꞌacãrã niwã. Core aꞌtiro nicãrã niwã: —Sansṍrẽ “¿Deꞌro wee tocãꞌrõ tutuati?” nígõ, weesoose meꞌrã cʉ̃rẽ weredutiya. Tojo wee ʉ̃sã cʉ̃rẽ dʉꞌte, tutuaticã weemasĩrãsaꞌa. Mʉꞌʉ tojo weecã, ʉ̃sãnʉcʉ̃ mʉꞌʉrẽ niyeru pajiro oꞌorãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Tojo weego Dalila Sansṍrẽ aꞌtiro nico niwõ: —Wereya yʉꞌʉre. ¿Deꞌro weegʉ mʉꞌʉ tocãꞌrõ tutuase cʉoti? Mʉꞌʉ tutuase moogʉ̃ waꞌacã, ¿ñeꞌe meꞌrã mʉꞌʉrẽ dʉꞌtebosari? ni sẽrĩtiñaꞌco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Sansón core yʉꞌticʉ niwĩ: —Siete dari bʉacatjẽ nise dari, bopotise dari meꞌrã yʉꞌʉre dʉꞌtecã, yʉꞌʉ tutuase peꞌtirosaꞌa. Mejõ nigʉ̃́ weronojõ tojagʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Cʉ̃ tojo nicã tʉꞌorã, filisteo masã wiorã siete dari bopotise darire core miiticãrã niwã. Te dari meꞌrã Dalila Sansṍrẽ dʉꞌteco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Filisteo masã wiorã ti tucũ bajutiropʉ nicãrã niwã. Sansṍrẽ dʉꞌtetoja, cʉ̃rẽ aꞌtiro caricũco niwõ: —¡Sansón, filisteo masã mʉꞌʉrẽ ñeꞌerã aꞌtitojama! nico niwõ. Co tojo nicã tʉꞌogʉ, Sansón te darire yuta dare ʉ̃jʉ̃asurero weronojõ surecãꞌcʉ niwĩ. Tojo weerã filisteo masã deꞌro wee cʉ̃ tutuati nisere masĩticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Tojo waꞌacã, Dalila Sansṍrẽ aꞌtiro nico niwõ: —Yʉꞌʉre bujicãꞌpã. Tojo nicã, yʉꞌʉre nisooapʉ. Wereya. ¿Ñeꞌenojõ da meꞌrã mʉꞌʉrẽ dʉꞌtebosari, mʉꞌʉ sureticã? nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Sansón core yʉꞌticʉ niwĩ: —Pũnʉꞌmo dari maꞌma dari, dʉꞌtenoꞌña marĩse dari meꞌrã yʉꞌʉre añurõ dʉꞌtecã, mejõ nigʉ̃ weronojõ tutuatigʉ tojagʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Cʉ̃ tojo nicã tʉꞌogo, Dalila maꞌma darire mii, cʉ̃rẽ dʉꞌteco niwõ. Dʉꞌtetoja, cʉ̃rẽ caricũco niwõ: —¡Sansón, filisteo masã mʉꞌʉrẽ ñeꞌerã aꞌtitojama! Filisteo masã ti tucũ bajutiropʉ nicoꞌtecãrã niwã. Co tojo nicã tʉꞌogʉ, Sansón yuta darire weronojõ te darire wejesurecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Beꞌro Dalila Sansṍrẽ aꞌtiro nico niwõ: —Mʉꞌʉ yʉꞌʉre bujicãꞌa, nisoodecotiꞌi yujupʉ. ¿Deꞌro weecã mʉꞌʉ tutuatigʉ tojagʉsari? Wereya, nico niwõ. Cʉ̃ yʉꞌticʉ niwĩ: —Suꞌti suꞌawʉaropʉ yuta paasuꞌaro weronojõ ye poarire seepaꞌtaꞌque siete darire paasuꞌatjĩagõ, dʉꞌtecũuña. Mʉꞌʉ tojo weecã, yʉꞌʉ tutuatigʉ, mejõ nigʉ̃ weronojõ tojagʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Tojo weego cʉ̃ cãrĩrĩ cura Dalila cʉ̃ poarire siete dari seepaꞌtaꞌquere suꞌti suꞌaropʉ suꞌa aꞌmesʉꞌocũuco niwõ. Tojo weetuꞌaja, tuturire diꞌtapʉ paabiꞌanʉꞌcõ, co suꞌaꞌque darire dʉꞌteñeꞌecũuco niwõ. Beꞌro apaturi Sansṍrẽ caricũco niwõ: —¡Sansón, filisteo masã mʉꞌʉrẽ ñeꞌerã aꞌtitojama! nico niwõ. Cʉ̃ cãrĩꞌcʉ nimigʉ̃, wãꞌcã, cʉ̃rẽ seepaꞌtaꞌque dari dʉꞌtecũuꞌque tuturire wejeduꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Cʉ̃ tojo weecã, co nico niwõ: —Mʉꞌʉ yʉꞌʉre ẽjõpeotigʉ, ¿deꞌro weegʉ “Mʉꞌʉrẽ maꞌiꞌi”, nimiti? Iꞌtiati yʉꞌʉre bujicãꞌgʉ̃ weeapʉ. Aꞌtiro wee tutuaꞌa nisere ne wereweꞌe, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Peje nʉmʉrĩ cʉ̃rẽ tojo cariboco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Tojo weegʉ caributicũmí, core queoro werepeꞌocãꞌcʉ niwĩ: —Yʉꞌʉ bajuase dʉporo “Õꞌacʉ̃ yagʉ nazareo cũunoꞌyutojagʉsami” ninoꞌcʉ niꞌi. Nazareo nitjĩagʉ̃, ye poari ne niꞌcãti seenoꞌña marĩꞌi. Ye poarire seecõꞌacãma, yʉꞌʉ tutuase peꞌtirosaꞌa. Mejõ nigʉ̃́ weronojõ tutuatigʉ tojagʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Dalila “Queoro werepeꞌocãꞌmi” ni masĩgõ, filisteo masã wiorãrẽ queti oꞌóco niwõ. Tere tʉꞌorã, filisteo masã wiorã na “Mʉꞌʉrẽ oꞌorãti” níꞌque niyeru meꞌrã co ya wiꞌipʉ ejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Sansón cʉ̃ nʉmo ya ʉsó buꞌipʉ dʉpoa peo, cãrĩyʉꞌrʉacʉ niwĩ. Cʉ̃ cãrĩyʉꞌrʉcã ĩꞌagõ, niꞌcʉ̃rẽ cʉ̃ poarire siete seepaꞌtaꞌque darire seedutigo pijico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Cʉ̃ seetojaca beꞌro caricũco niwõ: —¡Sansón, filisteo masã mʉꞌʉrẽ ñeꞌerã aꞌtitojama! nico niwõ. Sansón wãꞌcã, “Todʉporo weeꞌcaronojõ waꞌarosaꞌa”, ni wãcũcʉ nimiwĩ. Õꞌacʉ̃ cʉ̃rẽ wijaacã, ne masĩticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Beꞌro filisteo masã cʉ̃rẽ ñeꞌe, cʉ̃ caperire oreweecãꞌcãrã niwã. Tojo weetoja, Gaza wãmetiri macãpʉ cʉ̃rẽ miibuꞌacãrã niwã. Cõme dari meꞌrã dʉꞌtetjĩarã, buꞌiri daꞌreri wiꞌipʉ trigore ãrʉ̃aduticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Siapeꞌe meꞌrã cʉ̃ poari pĩꞌrĩwijanʉꞌcãcaro niwʉ̃ tja. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Beꞌro filisteo masã wiorã na ẽjõpeogʉ Dagṍrẽ ẽjõpeori wiꞌipʉ nerẽcãrã niwã. Na cʉ̃rẽ waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeorãtirã, tojo nicã bosenʉmʉ weepeorãtĩrã, tojo weecãrã niwã. Aꞌtiro basacãrã niwã: “Marĩ ẽjõpeogʉ marĩrẽ ĩꞌatuꞌtigʉ Sansṍrẽ marĩrẽ wiacʉ niami”. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Masã ti wiꞌipʉ nirã́ quẽꞌrã na ẽjõpeogʉ Dagṍrẽ aꞌtiro ni basapeocãrã niwã: “Marĩ ẽjõpeogʉ marĩrẽ ĩꞌatuꞌtigʉ Sansṍrẽ marĩrẽ wiacʉ niami. Cʉ̃ marĩ ye trigo weserire ʉ̃jʉ̃aꞌcʉ, pãjãrã marĩ acawererãrẽ wẽjẽꞌcʉre wiacʉ niami.” ");
INSERT INTO tuoNT_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Na pũrõ eꞌcatitjĩarã, aꞌtiro caricũcãrã niwã: “Sansṍrẽ marĩ waꞌteropʉ miitia, cʉ̃rẽ bujicãꞌrã”, nicãrã niwã. Tojo weerã cʉ̃ buꞌiri daꞌreri wiꞌipʉ níꞌcʉre na nerẽrõpʉ miiejacãrã niwã. Na tojo weecã ĩꞌarã, masã cʉ̃rẽ bujicãꞌcãrã niwã. Ti wiꞌi na ẽjõpeogʉ Dagṍrẽ ẽjõpeori wiꞌi cjase tuuñeꞌese tuturi deco cʉ̃rẽ nuꞌcũduticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Tojo wééca beꞌro Sansón maꞌmʉ cʉ̃rẽ tʉ̃awãꞌcãgʉ̃rẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉre aꞌti wiꞌi tuuñeꞌese tuturi waꞌtero nʉꞌcõña, te tuturipʉ ñatuuwãꞌcãcã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Ti wiꞌipʉre ʉmʉa, numia muꞌmuyʉꞌrʉacãrã niwã. Nipeꞌtirã filisteo masã wiorã topʉ nicãrã niwã. Tojo nicã ti wiꞌi buꞌi opa sira nirõpʉ iꞌtiati mil masã Sansṍrẽ bujicãꞌcã ĩꞌadijocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Tojo waꞌari cura Sansón Õꞌacʉ̃rẽ aꞌtiro sẽrĩcʉ niwĩ: “Yʉꞌʉre wãcũña. Niꞌcãti yʉꞌʉre tutuase oꞌonemoña tja. Ye caperire filisteo masã oreweeꞌque wapa aꞌmegʉ̃tigʉ weeꞌe”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Sansón tojo sẽrĩtoja, ti wiꞌi deco tuuñeꞌese tuturi pʉa tuturo waꞌteropʉ diacjʉ̃camocã meꞌrã niꞌcã tuturopʉ, cũpecamocã meꞌrã ape tuturopʉ ñatuunʉꞌcãejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Tojo weetoja, aꞌtiro caricũcʉ niwĩ: “¡Filisteo masã meꞌrã yʉꞌʉre wẽrĩcã weeya!” nicʉ niwĩ. Beꞌro nipeꞌtise cʉ̃ tutuase meꞌrã te tuturire tuunuadijocʉ niwĩ. Cʉ̃ tojo weecã, ti wiꞌi wiorã, tojo nicã nipeꞌtirã ti wiꞌipʉ níꞌcãrã buꞌipʉ doquepejacaro niwʉ̃. Tojo weerã wẽrĩpeꞌtia waꞌacãrã niwã. Tojo wee Sansón cʉ̃ wẽrĩrĩ nʉmʉrẽ cʉ̃ catiri ʉmʉcore wẽjẽꞌcaro yʉꞌrʉoro filisteo masãrẽ wẽjẽnemocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Beꞌro cʉ̃ acabijirã, nipeꞌtirã cʉ̃ pacʉ acawererã cʉ̃ upʉre miirã waꞌacãrã niwã. Cʉ̃ pacʉ Manoarẽ yááca tutipʉ Zora Estaol decopʉ cʉ̃rẽ yaacãrã niwã. Sansón veinte cʉ̃ꞌmarĩ Israe curuacjãrãrẽ sʉꞌori niseticʉ niwĩ. ***** ");
INSERT INTO tuoNT_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Israe curuacjãrãrẽ wiorã sʉꞌori nisetiri masã narẽ wejepeocaterore ti diꞌtapʉre acoro pejatiyucã, ʉpʉtʉ ʉjʉaboase nicaro niwʉ̃. Tojo weegʉ titare niꞌcʉ̃ Belẽcjʉ̃ Judá ya curuacjʉ̃ Elimelec wãmetigʉ “Marĩ Moab diꞌtapʉ yoaticã nisetirã waꞌarã”, nicʉ niwĩ. Cʉ̃ nʉmo Noemí, cʉ̃ põꞌrã ʉmʉa Mahlón, Quelión meꞌrã waꞌacʉ niwĩ. Na efrateo masã Belẽcjãrã nicãrã niwã. Moapʉ eta, topʉ niseticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Topʉ na nirĩ cura Elimelec, Noemí marãpʉ, wẽrĩweꞌo waꞌacʉ niwĩ. Co niꞌcõta co põꞌrã pʉarã meꞌrã tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Beꞌro na pʉarãpʉta moabita masã numiarẽ nʉmoticãrã niwã. Niꞌcõ Orfa, apego Rut wãmeticãrã niwã. Topʉre diez cʉ̃ꞌmarĩ nisetica beꞌro ");
INSERT INTO tuoNT_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mahlón, Quelión na quẽꞌrã wẽrĩa waꞌacãrã niwã. Tojo weego Noemí wapewio, põꞌrãmarĩgõ niꞌcõta tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Beꞌro Noemí Moapʉ nirĩ curare Õꞌacʉ̃ cʉ̃ yarã masã Israe curuacjãrãrẽ weetamusere tʉꞌoco niwõ. Narẽ weetamugʉ̃, na otese añurõ pĩꞌrĩ dʉcaticã weeꞌquere tʉꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tere tʉꞌoꞌco niyugo, “Apaturi Judá diꞌtapʉ dajatojaagoti tja”, ni wãcũco niwõ. Tojo weego co põꞌrã nʉmosãnumia níꞌcãrã meꞌrã na níꞌcaropʉ wija, Judá tiro waꞌari maꞌapʉ waꞌarã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Maꞌapʉ waꞌago, Noemí na numiarẽ aꞌtiro nico niwõ: —Mʉsã pacosãnumia tiropʉ dajatojaaya. Mʉsã yʉꞌʉre, yʉꞌʉ põꞌrã ʉmʉarẽ añurõ weeꞌcaronojõta Õꞌacʉ̃ mʉsãrẽ añurõ weeato. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Tojo nicã, cʉ̃ mʉsãrẽ tocjãrãrẽ apaturi marãpʉti, eꞌcati nimeꞌrĩcã weeato, nico niwõ. Tojo nitojanʉꞌcõ, Noemí narẽ weꞌeritigo, miꞌmico niwõ. Na peꞌe ʉpʉtʉ uticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Utirã, aꞌtiro nicãrã niwã: —Niweꞌe. Ʉ̃sã quẽꞌrã mʉꞌʉ meꞌrãta mʉꞌʉ ya diꞌtapʉ dajatojaarãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Noemí peꞌe narẽ ninemoco niwõ tja: —Yʉꞌʉ põꞌrã nʉmosãnumia níꞌcãrã, mʉsã ye wiꞌseripʉ tojaarãsaꞌa. ¿Deꞌro weeajã yʉꞌʉ meꞌrã waꞌasĩꞌrĩti? Yʉꞌʉ mʉsãrẽ nʉorẽdutigo, põꞌrãtinemosome. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Waꞌarãsaꞌa. Mʉsã ye wiꞌseripʉ dajatojaaya. Yʉꞌʉ bʉcʉo niꞌi. Apaturi marãpʉtimasĩtisaꞌa. Niꞌcãcã ñami yʉꞌʉ marãpʉti, ʉmʉarẽ põꞌrãticãma, ");
INSERT INTO tuoNT_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","¿na bʉcʉari curare yoacã coꞌtebosari? ¿Ãpẽrãrẽ nʉorẽtimirã, narẽ coꞌtebosari? Niweꞌe, yʉꞌʉ põꞌrã nʉmosãnumia, aꞌtenojõrẽ tojo weeticãꞌrõʉaꞌa. Õꞌacʉ̃ yʉꞌʉre ʉpʉtʉ piꞌeticã weeami. Mʉsã piꞌeticã ĩꞌagõ, nemorõ ñaꞌarõ tʉꞌoñaꞌbosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Tere tʉꞌorã, apaturi pũrõ uticãrã niwã. Beꞌro Orfa co mañecõrẽ weꞌeritigo, core miꞌmico niwõ. Tojo weetoja, dajatojaa waꞌaco niwõ. Rut peꞌe waꞌasĩꞌrĩtigo, co mañecõ meꞌrã tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Co tojo weecã ĩꞌagõ, Noemí core aꞌtiro nico niwõ: —Ĩꞌaña. Mʉꞌʉ peꞌsu níꞌco co acawererã tiro, co ẽjõpeorã tiropʉ dajatojaago weemo. Co meꞌrãta mʉꞌʉ quẽꞌrã dajatojaagosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rut peꞌe aꞌtiro ni yʉꞌtico niwõ: —Yʉꞌʉre “Tojaagosaꞌa”, niticãꞌña. Yʉꞌʉre mʉꞌʉ meꞌrã waꞌadutiya. Mʉꞌʉ noꞌo waꞌaro waꞌagoti. Mʉꞌʉ noꞌo macãrĩtiro mejãrõta macãrĩtigosaꞌa. Mʉꞌʉmasã, yarã masã nirãsama. Mʉꞌʉ wiogʉ Õꞌacʉ̃ yʉꞌʉ wiogʉ nigʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Noꞌo mʉꞌʉ wẽrĩ yaanoꞌrõ, yʉꞌʉ quẽꞌrã wẽrĩgõti. Topʉta yʉꞌʉ quẽꞌrãrẽ yaarãsama. Yʉꞌʉ “Tojo weegoti” níꞌquere weeticãma, Õꞌacʉ̃ yʉꞌʉre buꞌiri daꞌreato. Wẽ́rĩ́gõpʉ mʉꞌʉrẽ cõꞌagõti, nico niwõ Rut. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Co tojo baꞌpati yapatisĩꞌrĩcã ĩꞌagõ, Noemí core “Yʉꞌʉ meꞌrã waꞌaticãꞌña” ninemotico niwõ majã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Tojo weerã na pʉarãpʉta waꞌa, téé Belẽpʉ etacãrã niwã. Belẽpʉ sãjãcã, nipeꞌtirã ti macãcjãrã numia ĩꞌamarĩa, aꞌmerĩ sẽrĩtiñaꞌcãrã niwã: —¿Sico Noemí mejẽta nitiba? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Co peꞌe: “Yʉꞌʉre Noemí pisuticãꞌña majã. Yʉꞌʉre Mara pisuya majã. Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ yʉꞌʉre ñaꞌarõ tojacã weeami. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Aꞌti macãrẽ wijago, peje cʉomiwʉ̃. Niꞌcãrõacãma ne apeyenojõacã moogõ Õꞌacʉ̃ yʉꞌʉre miitojátiami. Õꞌacʉ̃ tutuayʉꞌrʉnʉꞌcãgʉ̃ ‘Buꞌiri cʉomo’ nígʉ̃, yʉꞌʉre piꞌeticã weeami. Tojo weerã yʉꞌʉre Noemí pisuticãꞌña”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Aꞌtiro wee Noemí Moapʉ níꞌco co macʉ̃ nʉmo níꞌco Rut, moabita masõ meꞌrã dajaco niwõ. Na Belẽpʉ etácaterore masã na oteꞌque cebadare tʉ̃ꞌrẽnʉꞌcãrĩ cura nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Noemí co marãpʉ Elimelec níꞌcʉ mijĩ Booz wãmetigʉre acaweregʉtico niwõ. Cʉ̃ peje cʉogʉ, añugʉ̃ ninoꞌgʉ̃wioro nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Niꞌcã nʉmʉ Rut Noemírẽ aꞌtiro nico niwõ: —Yʉꞌʉre cãpũpʉ na oteꞌcaropʉ waꞌacã weeya. Apetero weegʉ niꞌcʉ̃ te põꞌrãrĩ dʉteri masʉ̃ yʉꞌʉre añurõ wéégʉ, cʉ̃ beꞌro cebada dʉtestedijosere “Mʉꞌʉ seesirutucã añurõsaꞌa”, nibosami. Co mañecõ peꞌe: “Jaʉ, yʉꞌʉ macʉ̃ nʉmo níꞌco, waꞌagosaꞌa”, ni yʉꞌtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tojo weego Rut na dʉteropʉ waꞌa, cebada dʉterã beꞌro te põꞌrãrĩrẽ seesirutugo waꞌaco niwõ. Core añurõ waꞌacaro niwʉ̃. To oteꞌcaro Booz, Elimelec ya curuacjʉ̃ yaro nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Co tojo daꞌrari cura Booz, Belẽpʉ níꞌcʉ ejacʉ niwĩ. Cebada daꞌrarãrẽ añuduticʉ niwĩ: —Õꞌacʉ̃ mʉsã meꞌrã niato, nicʉ niwĩ. Na peꞌe quẽꞌrã “Õꞌacʉ̃ mʉꞌʉrẽ añurõ weeato”, ni yʉꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Beꞌro Booz, Rure ĩꞌagʉ̃, cʉ̃ yarã daꞌrarã wiogʉre sẽrĩtiñaꞌcʉ niwĩ: —¿Sico nuꞌmio noa acawerego niti? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Daꞌrari masã wiogʉ cʉ̃rẽ yʉꞌticʉ niwĩ: —Co moabita masõ nimo. Ti diꞌtapʉ níꞌco Noemí meꞌrã aꞌtico niamo, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Co yʉꞌʉre, “¿Yʉꞌʉ cebada dʉterã beꞌro na dʉtestedijosere seesirutucã añusari?” ni sẽrĩamo. Co boꞌreacã aꞌtiꞌco daꞌranaꞌiamo. Niꞌcãrõacãpʉta soori uꞌtupʉ cãꞌrõ soogo aꞌtiamo, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Tere tʉꞌogʉ, Booz Rure aꞌtiro nicʉ niwĩ: —Acawerego, yʉꞌʉ ucũsere añurõ tʉꞌoya. Ãpẽrã na oteꞌque nirõpʉ otese dʉca põꞌrãrĩrẽ seego waꞌaticãꞌña. Yʉꞌʉre daꞌracoꞌterã numia meꞌrã tojayá. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Noꞌo dʉterã na daꞌrarore ĩꞌagõ, numiarẽ sirutuya. Yʉꞌʉre daꞌracoꞌterã ʉmʉarẽ mʉꞌʉrẽ “Cariboticãꞌña”, nitojapʉ. Mʉꞌʉ acowʉogo, te sĩꞌrĩsepaa dujise tiro waꞌa, na aco waaꞌquere sĩꞌrĩña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Tere tʉꞌogo, Rut co ẽjõpeosere ĩꞌogõ, paamuꞌrĩqueꞌaco niwõ. Beꞌro Boore sẽrĩtiñaꞌco niwõ: —¿Deꞌro weegʉ yʉꞌʉ aperocjõ nimicã, yʉꞌʉre tocãꞌrõ añurõ weeti? ");
INSERT INTO tuoNT_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Core yʉꞌticʉ niwĩ: —Mʉꞌʉ marãpʉ wẽ́rĩ́ca beꞌro mʉꞌʉ mañecõrẽ añurõ weesetisere tʉꞌopeꞌocãꞌpʉ. Tojo nicã mʉꞌʉ pacʉsʉmʉarẽ, mʉꞌʉ ya diꞌtare duꞌucũu, aꞌto mʉꞌʉ todʉporo masĩtiꞌcãrã tiropʉ, macãrĩ aꞌtico niapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Õꞌacʉ̃ mʉꞌʉ tojo weeꞌquere wapayeato. Mʉꞌʉ Õꞌacʉ̃, Israe curuacjãrã ẽjõpeogʉ cʉ̃ coꞌtesere aꞌmagõ aꞌtiapã. Cʉ̃ta mʉꞌʉrẽ añurõ weeato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Cʉ̃rẽ yʉꞌtico niwõ: —Mʉꞌʉ yʉꞌʉre añurõ weeapʉ. Mʉꞌʉ ucũse yʉꞌʉre wãcũtutuacã weeꞌe. Mʉꞌʉrẽ daꞌracoꞌterã numia weronojõ nitimicã, yʉꞌʉre añurõ maꞌise meꞌrã ucũꞌu. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Baꞌaritero ejacã, Booz Rure pijicʉ niwĩ: “Aꞌto aꞌtia. Pã́rẽ cãꞌrõ míí, na yosobaꞌasere yosobaꞌaya.” Rut daꞌrari masã tiropʉ ejanujãco niwõ. Booz core cebada peri pʉ̃ꞌoꞌque perire baꞌadutigʉ oꞌocʉ niwĩ. Co tere baꞌa, co baꞌasĩꞌrĩrõ põtẽorõ baꞌaco niwõ. Baꞌase core oꞌoꞌque dʉꞌsacãꞌcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Beꞌro co apaturi cebada perire seego waꞌáca beꞌro Booz cʉ̃rẽ daꞌracoꞌteri masãrẽ aꞌtiro duticʉ niwĩ: —Co cebada dotori waꞌteropʉ te põꞌrãrĩrẽ seecã quẽꞌrãrẽ, ne core cãꞌmotaꞌaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mejõ peꞌe apeye noꞌo mʉsã ñeꞌese dotoripʉreta core seedutirã, cũuña. Core ne tuꞌtiticãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Tojo weego Rut, Booz ya cãpũpʉ cebadare seenaꞌitõꞌoqueꞌa waꞌaco niwõ. Beꞌro co seeꞌquere suꞌtiweeco niwõ. Te veinte kilo waꞌtero nʉcʉ̃caro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Beꞌro co suꞌtiweeꞌque perire wʉa, macãpʉ dajatojaaco niwõ. Tere co mañecõrẽ ĩꞌoco niwõ. Tojo nicã, co baꞌadʉꞌaꞌquere Noemírẽ oꞌoco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Noemí core sẽrĩtiñaꞌco niwõ: —¿Niꞌcãcãrẽ noꞌopʉ daꞌrati? ¿Noꞌopʉ te pejere ticʉse seeati? Mʉꞌʉrẽ tojo weetamuꞌcʉre añurõ waꞌato, nico niwõ. Rut co mañecõrẽ wereco niwõ: —Yʉꞌʉ Booz wãmetigʉ meꞌrã daꞌrapʉ, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Noemí core yʉꞌtico niwõ: —Õꞌacʉ̃ cʉ̃rẽ añurõ weeato. Õꞌacʉ̃ todʉporo wẽrĩꞌcãrãrẽ pajañaꞌcaronojõta niꞌcãrõacã catirã meꞌrã quẽꞌrãrẽ añurõ pajañaꞌa weetamunuꞌcũapĩ. Booz marĩ acaweregʉ waro nimi. Tojo weegʉ marĩrẽ añurõ coꞌtemasĩmi. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut peꞌe apeye werenemoco niwõ: —Cʉ̃ yʉꞌʉre cʉ̃rẽ daꞌracoꞌterã numia meꞌrã daꞌradutiami. Téé cebadare seepeꞌocãpʉ daꞌraduꞌudutiami. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Co tojo nicã tʉꞌogo, Noemí Rure aꞌtiro yʉꞌtico niwõ: —Cʉ̃rẽ daꞌracoꞌterã numia meꞌrã mʉꞌʉrẽ tojacã añu nitʉꞌsaꞌa. Ãpẽrã ye weseripʉ seego waꞌaticãꞌña. Ãpẽrã mʉꞌʉrẽ caribobosama, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tojo wee Rut, Boore daꞌracoꞌterã numia meꞌrã te põꞌrãrĩrẽ seego waꞌaco niwõ tja. Téé trigo põꞌrãrĩrẽ, tojo nicã cebada põꞌrãrĩrẽ tʉ̃ꞌrẽpeꞌocãpʉ daꞌratʉoco niwõ. Co topʉ daꞌrase nʉmʉrĩrẽ co mañecõ meꞌrã nisetico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Niꞌcã nʉmʉ Noemí Rure aꞌtiro nico niwõ: —Niꞌcʉ̃ mʉꞌʉ marãpʉ niacjʉre aꞌmabosagoti. Cʉ̃ mʉꞌʉrẽ añurõ eꞌcati niseticã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Mʉꞌʉ masĩsaꞌa. Booz marĩ acaweregʉ nimi. Mʉꞌʉ cʉ̃rẽ daꞌracoꞌterã numia meꞌrã daꞌraco niapʉ. Niꞌcãcã ñami cãpũpʉ cʉ̃ trigo, cebada perire suꞌtiweegʉ waꞌagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Mʉꞌʉ aꞌtiro weeya. Uꞌaya. Mʉꞌʉ upʉre ʉꞌmʉtise meꞌrã waꞌre, mʉꞌʉ yaro suꞌtiro añurõ niyʉꞌrʉnʉꞌcãrõrẽ sãñaña. Tuꞌajanʉꞌcõ, cʉ̃ suꞌtiweeropʉ waꞌaya. Mejõ cʉ̃ baꞌa, sĩꞌrĩ tuꞌajati dʉporo mʉꞌʉrẽ ĩꞌacã weeticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Cʉ̃ noꞌo cãrĩatjore añurõ ĩꞌaweꞌoya. Beꞌro cʉ̃ tiro waꞌa, cʉ̃ dʉꞌpocãrĩ omaꞌcarore pãaña. Topʉ cũñaña. Beꞌro cʉ̃ basu mʉꞌʉ weeatjere weregʉsami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut core yʉꞌtico niwõ: —Nipeꞌtise mʉꞌʉ níꞌcaronojõta weegoti, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Tojo weego Rut na suꞌtiweeropʉ waꞌa, nipeꞌtise co mañecõ dutiꞌcaronojõta weeco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Booz baꞌa, sĩꞌrĩ, añurõ eꞌcatigʉ nicʉ niwĩ. Tojo wééca beꞌro na suꞌtiwééca mesã tiro cãrĩgʉ̃ ejaqueꞌacʉ niwĩ. Beꞌro Rut diꞌtamarĩrõacã waꞌa, cʉ̃ dʉꞌpocãrĩ omáca caserore pãa, topʉ ejaqueꞌa, cũñaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ñami deco ʉcʉamajã wãꞌcã, majãmiqueꞌamigʉ̃, niꞌcõ numio cʉ̃ dʉꞌpocãrĩ tiro cũñacã ĩꞌamarĩacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Booz core “¿Noa niti mʉꞌʉ?” ni sẽrĩtiñaꞌcʉ niwĩ. —Yʉꞌʉ Rut, mejõ nigṍ niꞌi. Mʉꞌʉ yʉꞌʉ acaweregʉ diácjʉ̃, yʉꞌʉre coꞌtegʉnojõ niꞌi. Tojo weego mʉꞌʉ yʉꞌʉre nʉmoticã ʉasaꞌa, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Booz core yʉꞌticʉ niwĩ: —Õꞌacʉ̃ mʉꞌʉrẽ añurõ weeato. Mʉꞌʉ marãpʉ mijĩ wẽ́rĩ́ca beꞌrore mʉꞌʉ mañecõrẽ añurõ weesetiapʉ. Mʉꞌʉ niꞌcãrõacã yʉꞌʉre sẽrĩse peꞌe mʉꞌʉ mañecõrẽ weese nemorõ añuꞌu. Mʉꞌʉ apĩ yʉꞌʉ nemorõ maꞌmʉrẽ aꞌmaboapã. Noꞌo peje cʉogʉnojõrẽ o pajasecʉogʉnojõrẽ aꞌmaboapã. Tojo weetiapã. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ne uiticãꞌña. Nipeꞌtirã yá macãcjãrã mʉꞌʉ numio queoro weesetisere masĩpeꞌtitojama. Tojo weegʉ yʉꞌʉ nipeꞌtise mʉꞌʉ sẽrĩsere weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Diacjʉ̃ta yʉꞌʉ mʉꞌʉ acaweregʉ waro, mʉꞌʉrẽ coꞌtegʉnojõ niꞌi, nígʉ̃ peꞌe. Tojo nimicã, apĩ yʉꞌʉ nemorõ mʉꞌʉ acaweregʉ waro nimi. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Aꞌti ñamirẽ aꞌtopʉta tojáníña. Ñamiacã cʉ̃ mʉꞌʉ acaweregʉ nisetisere queoro weecã, añurõsaꞌa. Cʉ̃ mʉꞌʉrẽ nʉmotigʉsami. Cʉ̃ weeticãma, Õꞌacʉ̃ tʉꞌoropʉ “Yʉꞌʉ mʉꞌʉrẽ nʉmotigʉti”, nigʉ̃ti. Niꞌcãrõacãrẽ aꞌtopʉta cãrĩboꞌretõꞌoña. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tojo weego ti ñamirẽ Rut Booz dʉꞌpocãrĩ tiropʉ cãrĩco niwõ. Booz aꞌtiro ucũtojacʉ niwĩ: “Numio aꞌto cebada suꞌtiweeropʉ aꞌticã, ne niꞌcʉ̃ masĩticãꞌto”. Tojo weego ape nʉmʉ peꞌere ñamiñaꞌcũrõ boꞌrequeꞌati dʉporo wãꞌcãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Booz core aꞌtiro nicʉ niwĩ: —Mʉꞌʉ buꞌicjãrõ suꞌtiro sãñarõrẽ tuwee, añurõ sẽeo cʉoya. Co ti caserore tojo cʉonuꞌcũrĩ cura Booz peꞌe veinte kilos cebadare ṍrẽ́sãacʉ niwĩ. Beꞌro core wʉadutigʉ miipeocʉ niwĩ. Co te meꞌrã macãpʉ piꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut co mañecõ tiropʉ etacã, core aꞌtiro sẽrĩtiñaꞌco niwõ: —¿Yʉꞌʉ macʉ̃ nʉmo níꞌco, mʉꞌʉrẽ añurõ waꞌamiatito? Rut core nipeꞌtise Booz añurõ weetamuꞌquere wereco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Apeye quẽꞌrãrẽ werenemoco niwõ: —Aꞌte peje cebada yʉꞌʉre oꞌoami. Yʉꞌʉre aꞌtiro niami: “Mʉꞌʉ mañecõ tiropʉre apeyenojõ moogõ dajaticãꞌña”, niami, ni wereco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Tere tʉꞌogo, Noemí core nico niwõ: —Coꞌteniña yujupʉ. Deꞌro waꞌaro waꞌarosaꞌa. Cʉ̃ niꞌcãcãrẽ tere apotuꞌajanʉꞌcõgʉ̃pʉ, soogʉsami, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Beꞌro Booz ti macã sãjãrĩ sope pʉꞌtopʉ waꞌa, dujicʉ niwĩ. Topʉ masã nerẽwʉacãrã niwã. Cʉ̃ topʉ dujiri curare Booz Rure “Apĩ mʉsã acaweregʉ waro mʉsãrẽ coꞌteacjʉ nisami” níꞌcʉ yʉꞌrʉacʉ niwĩ. Booz cʉ̃rẽ ĩꞌagʉ̃, “Aꞌto dujigʉ aꞌtia”, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌogʉ, cʉ̃ tiro waꞌa, ejanujãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Beꞌro Booz diez bʉcʉrã wiorãrẽ, ti macãcjãrãrẽ pijio, dujiduticʉ niwĩ. Na dujíca beꞌro Booz cʉ̃ acaweregʉre aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","—Noemí Moab diꞌtapʉ níꞌco dajamo. Co marĩ acaweregʉ Elimelec mijĩ ya diꞌta níca diꞌtare duasĩꞌrĩgõ weeamo. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Tere masĩdutigʉ, mʉꞌʉrẽ wereꞌe. Mʉꞌʉ ti diꞌtare duusĩꞌrĩgʉ̃, ãꞌrã bʉcʉrã, ãpẽrã aꞌto dujirã tʉꞌoro “Duugʉti”, niña. Mʉꞌʉta Elimelec acaweregʉ waro niꞌi. Tojo weegʉ ti diꞌtare duumasĩꞌi. Mʉꞌʉ duusĩꞌrĩtigʉ, yʉꞌʉre wereya. Mʉꞌʉ ti diꞌtare duumʉꞌtãmasĩꞌi. Mʉꞌʉ beꞌrocjʉ̃ yʉꞌʉta niꞌi, nicʉ niwĩ Booz. Tojo nicã tʉꞌogʉ, Booz acaweregʉ peꞌe: “Ti diꞌtare duugʉti”, ni yʉꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Booz cʉ̃rẽ apeyere werecasanʉꞌcõcʉ niwĩ: —Mʉꞌʉ Noemí ya diꞌtare dúúgʉ pũrĩcã, Rut quẽꞌrãrẽ nʉmotigʉsaꞌa. Co moabita masõ wapewio nimo. Mʉꞌʉ tojo weecã, co meꞌrã mʉsã macʉ̃tigʉre, ti diꞌta wẽrĩꞌcʉ mijĩ Mahlṍrẽ wãmepeosirutunoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Tere tʉꞌogʉ, Booz acaweregʉ yʉꞌticʉ niwĩ: —Tojo nicãma, ti diꞌtare duumasĩtisaꞌa. Beꞌropʉ yʉꞌʉ põꞌrãrẽ cũuatje to waꞌatibosaꞌa. Mʉꞌʉ duusĩꞌrĩgʉ̃, duuya. Yʉꞌʉ duumasĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Titapʉre Israe curuacjãrã tiropʉre aꞌtiro weesetise nicaro niwʉ̃. Niꞌcʉ̃ diꞌtare duagʉ o oꞌoyʉꞌrʉogʉ, diꞌta cʉogʉ cʉ̃ ya sapature tuwee, apĩ duugʉre oꞌoturiamʉjãcʉ niwĩ. Na duusere, duasere ĩꞌorã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Na weesetiꞌcaronojõta wéégʉ, Booz acaweregʉ cʉ̃ ya sapature tuwee, Boore oꞌocʉ niwĩ. Beꞌro cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ peꞌe duuya. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Cʉ̃ tojo nicã tʉꞌogʉ, bʉcʉrãrẽ, ãpẽrã topʉ dujirãrẽ Booz aꞌtiro nicʉ niwĩ: —Mʉsã tʉꞌoro niꞌcãcã yʉꞌʉ Noemírẽ co marãpʉ mijĩ Elimelec, cʉ̃ põꞌrã Quelión, Mahlón ye diꞌtare duugʉ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Tojo nicã Rut moabita masõ, Mahlón mijĩ nʉmo níꞌco quẽꞌrãrẽ nʉmotigʉti. Tojo weecã, co marãpʉ wẽrĩꞌcʉ mijĩ wãme ninuꞌcũcãꞌrõsaꞌa. Cʉ̃ wãmerẽ cʉ̃ acawererã waꞌteropʉre, tojo nicã ti macãpʉre ne acobojosome. Niꞌcãcã mʉsã ʉ̃sã tojo weeꞌquere ĩꞌapʉ. Beꞌropʉre “Tojota queoro weewã”, nímasĩrãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Bʉcʉrã, nipeꞌtirã ãpẽrã topʉ nirã́ aꞌtiro yʉꞌticãrã niwã: —Ʉ̃ʉ, ʉ̃sã mʉsã weeꞌquere queorota tʉꞌoapʉ. Õꞌacʉ̃ mʉꞌʉ nʉmo mʉꞌʉ ya wiꞌipʉ miisãjãacjore pãjãrã põꞌrãticã weeato. Raquel, tojo nicã Lea weronojõ niato. Marĩ Israe curuacjãrã na numia pãrãmerã nisirutudijatirã niꞌi. Efratapʉre tocjãrãrẽ wiopesase meꞌrã ĩꞌanoꞌgʉ̃ niña. Belẽpʉre masʉ̃ bajuyoagʉ niña. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Õꞌacʉ̃ mʉꞌʉrẽ co meꞌrã pãjãrã põꞌrãticã weeato. Mʉꞌʉ põꞌrã pãjãrã waro masãputiato. Tamar, Judá na macʉ̃ Fares waꞌaꞌcaronojõ waꞌato. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Booz cʉ̃ níꞌcaronojõta, Rure cʉ̃ ya wiꞌipʉ miaa, core nʉmoticʉ niwĩ. Beꞌro co meꞌrã nicã, Õꞌacʉ̃ core nijĩpaco waꞌacã weecʉ niwĩ. Tojo wee niꞌcʉ̃ põꞌrãtico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Tojo waꞌacã ĩꞌarã, Belẽ́cjãrã numia Noemírẽ aꞌtiro nicãrã niwã: —Õꞌacʉ̃rẽ “Añuyʉꞌrʉami”, ni eꞌcatipeorã. Niꞌcãcã mʉꞌʉrẽ pãrãmiticã weeami. Cʉ̃rẽ mʉꞌʉrẽ coꞌtedutigʉ oꞌoami. Israe curuacjãrã cʉ̃rẽ añurõ ucũyʉꞌrʉnʉꞌcãto. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Cʉ̃ mʉꞌʉ pãrãmi mʉꞌʉrẽ wãcũtutuacã weegʉsami. Mʉꞌʉ bʉcʉo nirĩ curare mʉꞌʉrẽ coꞌtegʉsami. Mʉꞌʉ macʉ̃ nʉmo níꞌco cʉ̃rẽ põꞌrãtiamo. Co mʉꞌʉrẽ ʉpʉtʉ waro maꞌimo. Mʉꞌʉ siete põꞌrãtiboꞌcaro nemorõ wapatimo, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Beꞌro Noemí wĩꞌmagʉ̃rẽ wʉamii, cʉ̃rẽ ĩꞌanʉrʉ̃, coꞌte masõco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Numia co ya wiꞌi pʉꞌtocjãrã aꞌtiro nicãrã niwã: —Niꞌcãrõacãrẽ Noemí niꞌcʉ̃ wĩꞌmagʉ̃ pãrãmitimo, nicãrã niwã. Cʉ̃rẽ Obed wãme õꞌocãrã niwã. Beꞌropʉre cʉ̃ Isaí pacʉ nicʉ niwĩ. Isaí peꞌe Davi pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Aꞌticʉrã Fares pãrãmerã nisirutudijarã nicãrã niwã: Fares Hezrón pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezrón Ram pacʉ nicʉ niwĩ. Ram Aminadab pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab Naasón pacʉ nicʉ niwĩ. Nahasón Salmón pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmón Booz pacʉ nicʉ niwĩ. Booz Obed pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed Isaí pacʉ nicʉ niwĩ. Isaí Davi pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Niꞌcã nʉmʉ Õꞌacʉ̃ Joná Amitai macʉ̃rẽ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Pajiri macã Nínivepʉ waꞌa weetjĩagʉ̃, aꞌtiro weregʉ waꞌaya. Na ñaꞌarõ weesetise yʉꞌʉpʉre ejaꞌa. Tojo weegʉ yʉꞌʉ narẽ buꞌiri daꞌregʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Joná peꞌe Õꞌacʉ̃rẽ yʉꞌtironojõ oꞌogʉ, Õꞌacʉ̃rẽ duꞌtigʉ, Jope nirĩ petapʉ buꞌacʉ niwĩ. Topʉ yucʉsʉ Tarsis wãmetiri macãpʉ waꞌapjʉre bocaejacʉ niwĩ. Cʉ̃ ti macãpʉ waꞌagʉti nígʉ̃, topʉ waꞌase wapare wapayecʉ niwĩ. Wapayetoja, tiwʉpʉ mʉjãsãjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Cʉ̃ tojo weecã, Õꞌacʉ̃ ti maajo decopʉ ʉpʉtʉ wĩꞌrõ wẽe, bʉpo paacã weecʉ niwĩ. Tojo waꞌacã, tiwʉpʉ nirã́ “Yucʉsʉ batarotiro weeꞌe”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Tiwʉre daꞌracoꞌterã ʉpʉtʉ uirã, nanʉcʉ̃ na ẽjõpeorãnojõrẽ “Weetamuña”, ni sẽrĩcãrã niwã. Beꞌro tiwʉ nʉcʉ̃tipjʉ tojato nírã, na miase nʉcʉ̃sere ti maajopʉ doqueñopeꞌocãrã niwã. Joná peꞌe tojo waꞌari curare na apeyenojõ nʉrõrĩ tucũpʉ dijaa, cãrĩyʉꞌrʉqueꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Cʉ̃ tojo weecã ĩꞌagʉ̃, tiwʉre dutigʉ cʉ̃ tiropʉ dijaa, cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ wʉjabʉcʉ, ¿deꞌro weegʉ cãrĩsãñati? Wãꞌcãña. Mʉꞌʉ ẽjõpeogʉre sẽrĩña. Apetero weegʉ cʉ̃ marĩrẽ ĩꞌa, yʉꞌrʉogʉsami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Tojo waꞌari curare tiwʉpʉ daꞌrarã na basu aꞌmerĩ ucũcãrã niwã: —¿Marĩrẽ noa ye buꞌiri tojo waꞌamitito? nírã, marĩ ẽjõpeorãrẽ besedutirã, mejõ níbocarã, nicãrã niwã. Na tojo weecã, Joná buꞌiritigʉ wijacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Tojo waꞌacã ĩꞌarã, cʉ̃rẽ nicãrã niwã: —Ʉ̃sãrẽ wereya. ¿Deꞌro weero marĩrẽ tojo ñaꞌarõ waꞌamitito? ¿Mʉꞌʉ ñeꞌenojõrẽ daꞌrati? ¿Noꞌopʉ níꞌcʉ aꞌtiati? ¿Di diꞌtacjʉ̃ niti? ¿Di curuacjʉ̃ o ñamʉnojõ masʉ̃ niti mʉꞌʉ? ni sẽrĩtiñaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Joná narẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ hebreo masʉ̃ niꞌi. Õꞌacʉ̃ ʉꞌmʉsecjʉ̃, dia pajiri maa, diꞌtare weeꞌcʉre ẽjõpeoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_10","033_1_10","JON","1","10","11","Joná tiwʉ daꞌrarãrẽ “Õꞌacʉ̃rẽ duꞌtigʉ weeꞌe”, ni werecʉ niwĩ. Cʉ̃ tojo nisere tʉꞌorã, ʉpʉtʉ uicãrã niwã. Siapeꞌe meꞌrã wĩꞌrõ ʉpʉtʉ wẽe, pãꞌcõrĩ pacase wãꞌcãcã ĩꞌarã, cʉ̃rẽ sẽrĩtiñaꞌcãrã niwã: —¿Deꞌro weegʉ mʉꞌʉ tojo weeati? Ʉ̃sã aꞌti maajore diꞌtamarĩacã ʉarã, ¿mʉꞌʉrẽ deꞌro weerãsari? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Cʉ̃ narẽ yʉꞌticʉ niwĩ: —Yʉꞌʉre dia pajiri maapʉ doqueñoña. Mʉsã tojo weecã, maa diꞌtamarĩarõsaꞌa. Ye buꞌirita wĩꞌrõ wẽe, bʉpo ʉpʉtʉ paami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Cʉ̃ tojo nimicã, tiwʉre na tutuaro põtẽorõ sumutopʉ waꞌarã, wajanʉjãmicãrã niwã. Ne põtẽoticãrã niwã. Dia siapeꞌe meꞌrã nemorõ pãꞌcõrĩ wãꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Tojo waꞌacã ĩꞌarã, Õꞌacʉ̃rẽ ʉpʉtʉ sẽrĩcãrã niwã: “Õꞌacʉ̃, ʉ̃sãrẽ ãꞌrĩ ye buꞌiri wẽrĩcã weeticãꞌña. Cʉ̃ buꞌiri moocãma, ʉ̃sãrẽ ‘Na buꞌiritima’, niticãꞌña. Õꞌacʉ̃, mʉꞌʉ weesĩꞌrĩrõ weeya”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Tojo nitoja, Jonárẽ maapʉ doqueñocãrã niwã. Na tojo wééca beꞌro pãꞌcõrĩ diꞌtamarĩa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Tojo weecã ĩꞌarã, tiwʉ daꞌrarã Õꞌacʉ̃rẽ wiopesase meꞌrã tʉꞌoñaꞌcãrã niwã. Tojo weerã cʉ̃rẽ waꞌicʉre wẽjẽ, ʉ̃jʉ̃amorõpeocãrã niwã. Tojo weetoja, “Mʉꞌʉ meꞌrã aꞌtiro weerãti” ni, apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Õꞌacʉ̃ peꞌe na tojo weeri cura niꞌcʉ̃ waꞌiwʉ̃ pajigʉ Jonárẽ baꞌadutigʉ oꞌócʉ niwĩ. Joná cʉ̃ poꞌpeapʉre ʉmʉco, ñami iꞌtia nʉmʉ sãñacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Joná cʉ̃ waꞌiwʉ̃ poꞌpeapʉ sãñágʉ̃, Õꞌacʉ̃ cʉ̃ wiogʉre aꞌtiro ni sẽrĩcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Õꞌacʉ̃, yʉꞌʉ ñaꞌarõ tʉꞌoñaꞌgʉ̃, mʉꞌʉrẽ ʉpʉtʉ sẽrĩapʉ. Mʉꞌʉ yʉꞌʉ sẽrĩsere yʉꞌtiapʉ. Yʉꞌʉ wẽrĩse pʉꞌto nígʉ̃, mʉꞌʉrẽ ʉpʉtʉ sẽrĩapʉ. Mʉꞌʉ yʉꞌʉ sẽrĩsere tʉꞌoapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Yʉꞌʉre maa ʉ̃ꞌcʉ̃abutiaropʉ doqueñoapʉ. Aco põꞌrãrĩ yʉꞌʉre õꞌmaqueõꞌoapʉ. Pãꞌcõrĩ paca mʉꞌʉ oꞌóꞌque yʉꞌʉre paaqueõꞌomʉjãpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Tojo waꞌacã, mʉꞌʉ yʉꞌʉre cõꞌawãꞌcãsere tʉꞌoñaꞌpʉ. ‘Mʉꞌʉ ya wiꞌi, mʉꞌʉrẽ ẽjõpeori wiꞌi, ñaꞌase marĩrĩ wiꞌi, Jerusalẽ́ cja wiꞌire ĩꞌasome majã’, ni wãcũasʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Yʉꞌʉ aco poꞌpeapʉ nígʉ̃, wẽrĩmiasʉ. Dia pajiri maa poꞌpeapʉ niapʉ. Ti maa cjase áburi yʉꞌʉ dʉpoapʉre suꞌriwãꞌamʉjãpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Yʉꞌʉ ʉ̃ꞌcʉ̃abutiaropʉ dijatasʉ. ‘Ne wãꞌcãsome’, ni wãcũmiasʉ. Õꞌacʉ̃ mʉꞌʉ peꞌe, yʉꞌʉ wiogʉ, yʉꞌʉ wẽrĩboꞌcʉre yʉꞌrʉoapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","‘Yʉꞌʉ catiri ʉmʉco peꞌtirotiro weeꞌe’ nígʉ̃, mʉꞌʉrẽ wãcũapʉ. Yʉꞌʉ sẽrĩse mʉꞌʉpʉre mʉꞌʉ ya wiꞌi, ñaꞌase marĩrĩ wiꞌipʉ ejapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ãpẽrã masã na ẽjõpeorã yeeꞌquere ẽjõpeosiruturãnojõ, mʉꞌʉ narẽ maꞌisere masĩtisama. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Yʉꞌʉ pũrĩcã mʉꞌʉrẽ eꞌcatise oꞌogʉ, waꞌicʉrãrẽ wẽjẽ ʉ̃jʉ̃amorõpeogʉti. Mʉꞌʉrẽ ‘Yʉꞌʉ tojo weegʉti’ níꞌquere weegʉti. Õꞌacʉ̃, mʉꞌʉ niꞌcʉ̃ta masãrẽ yʉꞌrʉogʉ niꞌi”, nicʉ niwĩ Joná. ");
INSERT INTO tuoNT_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Cʉ̃ tojo níca beꞌro Õꞌacʉ̃ waꞌiwʉ̃pʉre sãñaꞌcʉre nucũporopʉ eꞌocũucã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Beꞌro Õꞌacʉ̃ apaturi tja Jonárẽ Nínivecjãrãrẽ aꞌtiro weredutigʉ oꞌócʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Nínivepʉ waꞌaya. Yʉꞌʉ mʉꞌʉrẽ weredutisere tocjãrãrẽ weregʉ waꞌaya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Tojo weegʉ Joná Nínivepʉ weregʉ waꞌacʉ niwĩ. Õꞌacʉ̃ dutiꞌcaronojõta weecʉ niwĩ majã. Ti macã pajibutiari macã nicaro niwʉ̃. Ti macãrẽ nipeꞌtiropʉ yʉꞌrʉasĩꞌrĩgʉ̃, iꞌtia nʉmʉ peꞌori macã nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Joná ti macãpʉ ne etari nʉmʉrẽ ʉpʉtʉ bʉsʉro ucũcusiacʉ niwĩ: “ ‘Cuarenta nʉmʉrĩ beꞌro aꞌti macã Nínive peꞌodijonoꞌrõsaꞌa’, nimi Õꞌacʉ̃”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Cʉ̃ tojo nicã tʉꞌorã, ti macãcjãrã nipeꞌtirã bʉcʉrã, wĩꞌmarã Õꞌacʉ̃ cʉ̃ tojo nisere ẽjõpeocãrã niwã. Tojo weerã “Beꞌtiroʉaꞌa” ni, na bʉjawetisere ĩꞌorã, suꞌti wãquĩsenojõrẽ sãñacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Nínivecjʉ̃ wiogʉ te quetire tʉꞌogʉ, cʉ̃ wiogʉ dujiri cũmurõpʉ dujiꞌcʉ wãꞌcãnʉꞌcãcʉ niwĩ. Wãꞌcãnʉꞌcã, cʉ̃ wiogʉ suꞌti sãñaꞌquere tuweecʉ niwĩ. Tuwee, suꞌti wãquĩsenojõrẽ sãña, nucũcãpʉ ejanujãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Beꞌro wiogʉ, tojo nicã cʉ̃ docacjãrã wiorã dutise ojacãrã niwã. Nipeꞌtirã ti macãcjãrãrẽ tere masĩcã weecãrã niwã. Te na ojaꞌque aꞌtiro nicaro niwʉ̃: “Ne niꞌcʉ̃ baꞌaticãꞌña. Tojo nicã, ne mʉsã yarã wecʉare, mʉsã yarã ovejare baꞌase ecati, aco na sĩꞌrĩsere tĩaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Tojo weronojõ oꞌorã, nipeꞌtirã mʉsã ecarã meꞌrãta mʉsã bʉjawetisere ĩꞌorã, suꞌti wãquĩsenojõrẽ sãñaña. Mʉsã wãcũrõ põtẽorõ Õꞌacʉ̃rẽ weetamuse ʉpʉtʉ sẽrĩña. Mʉsã basu ñaꞌarõ weesetisere duꞌuya. Mʉsã cumuca weesere duꞌuya. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Apetero weegʉ Õꞌacʉ̃ marĩrẽ pajañaꞌa, cʉ̃ uasere duꞌubosami. Tojo weecã, marĩ wẽrĩsome”, ni ojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Õꞌacʉ̃ na ñaꞌarõ weesere duꞌucã ĩꞌagʉ̃, cʉ̃ buꞌiri daꞌregʉti nimiꞌquere weeticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Õꞌacʉ̃ Nínivecjãrãrẽ buꞌiri daꞌreticã, Joná tʉꞌsati, ua waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Tojo weegʉ Õꞌacʉ̃rẽ ñubue, aꞌtiro ni ucũcʉ niwĩ: —Õꞌacʉ̃, yá diꞌtapʉ nícaterore “Aꞌtirota waꞌarosaꞌa”, nimiwʉ̃. Tojo weegʉ “Sojaro meꞌrã Tarsis wãmetiri macãpʉ duꞌtiagʉti”, nimiwʉ̃. Yʉꞌʉ masĩꞌi, mʉꞌʉ maꞌise cʉogʉ, masãrẽ añurõ pajañaꞌa. Ne uamʉñaweꞌe. Mʉꞌʉ pajañaꞌyʉꞌrʉatjĩagʉ̃, “Buꞌiri daꞌregʉti” níꞌcʉ nimigʉ̃, ne weeweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Tojo weegʉ Õꞌacʉ̃, yʉꞌʉre wẽrĩcã weeya. Yʉꞌʉ wẽrĩcã, nemorõ añurõsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Õꞌacʉ̃ cʉ̃rẽ yʉꞌticʉ niwĩ: —¿Mʉꞌʉ aꞌtiro uacã, mʉꞌʉrẽ añu niti? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Joná ti macãpʉ níꞌcʉ wija, ti macã yʉꞌrʉropʉ mujĩpũ mʉjãtiro peꞌe waꞌacʉ niwĩ. Topʉ niꞌcã wiꞌiacã bʉa, weetjĩagʉ̃, acoroadujicʉ niwĩ. “Õꞌacʉ̃ ti macãrẽ ¿deꞌro weegʉsari?” ni, coꞌtedujigʉ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Cʉ̃ to dujiri cura Õꞌacʉ̃ Joná tiropʉ niꞌcã da pĩꞌrĩcã weecʉ niwĩ. Ti da cʉ̃ dʉpoare cãꞌmotaꞌadutigʉ, añurõ tʉꞌoñaꞌdutigʉ, tojo weecʉ niwĩ. Joná ti da cãꞌmotaꞌacã, ti da meꞌrã ʉpʉtʉ eꞌcaticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ape nʉmʉ boꞌreacã peꞌe Õꞌacʉ̃ ti dare wãquĩniꞌmarãwʉ̃rẽ baꞌacã weecʉ niwĩ. Tojo wee ti da ñaia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Mujĩpũ cʉ̃ asimʉjãticã, Õꞌacʉ̃ wĩꞌrõ mujĩpũ mʉjãtiro peꞌe asi wẽetuumʉjãticã weecʉ niwĩ. Joná cʉ̃ dʉpoa diacjʉ̃ asiquepeoyucã, “Yʉꞌʉ tʉꞌomasĩse peꞌtia waꞌasaꞌa”, ni tʉꞌoñaꞌcʉ niwĩ. “Wẽrĩa waꞌaroʉasaꞌa. Yʉꞌʉ wẽrĩcã, nemorõ añurõsaꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Õꞌacʉ̃ peꞌe cʉ̃ tojo nisere tʉꞌogʉ, aꞌtiro nicʉ niwĩ: —¿Mʉꞌʉ ti da ñaise meꞌrã aꞌtiro uacã, añu niti? —Yʉꞌʉma añu niꞌi. Mejõ yʉꞌʉ uase yʉꞌrʉmajãsaꞌa, ni yʉꞌticʉ niwĩ Joná. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Tojo nicã tʉꞌogʉ, Õꞌacʉ̃ cʉ̃rẽ nicʉ niwĩ: —Mʉꞌʉ ti dare otetipã. Ti dare bʉcʉacã weetipã. Ti da seꞌsaro niꞌcã ñami bʉcʉa, ape ñami ñaidija waꞌapã. Tojo weemicã, mʉꞌʉ ti dare maꞌiapã. ");
INSERT INTO tuoNT_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Yʉꞌʉ pũrĩcã tjãgʉ̃ta Nínivecjãrãrẽ pajañaꞌa. Ti macã pajiri macãrẽ ciento veinte mil yʉꞌrʉoro wĩꞌmarã buꞌiri marĩrã nima. Waꞌicʉrã quẽꞌrã pãjãrã nima. Ti macãcjãrã pãjãrãrẽ pajañaꞌrõʉaꞌa, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aꞌti pũrĩ Jesucristo ñecʉ̃sʉmʉa wãme meꞌrã ojanʉꞌcãnoꞌo. Jesucristo Õꞌacʉ̃ macʉ̃ masʉ̃ bajuaꞌcʉ Abrahã judío masʉ̃ nimʉꞌtãꞌcʉ pãrãmi nituriagʉ nicʉ niwĩ. Tojo nicã dʉporocjʉ̃pʉ judío masã wiogʉ Davi pãrãmi nituriagʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahã Isaa pacʉ nicʉ niwĩ. Isaa quẽꞌrã Jacob pacʉ nicʉ niwĩ. Jacob Judá, tojo nicã cʉ̃ maꞌmisʉmʉa, cʉ̃ acabijirã pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Fares, Zara sʉꞌrʉaꞌcãrã pacʉ nicʉ niwĩ. Na paco Tamar wãmetico niwõ. Fares Esrom pacʉ nicʉ niwĩ. Esrom Aram pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pacʉ nicʉ niwĩ. Aminadab Naasón pacʉ nicʉ niwĩ. Naasón Salmón pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pacʉ nicʉ niwĩ. Booz paco Rahab wãmetico niwõ. Booz Obed pacʉ nicʉ niwĩ. Cʉ̃ paco Rut wãmetico niwõ. Obed Isaí pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí judío masã wiogʉ Davi pacʉ nicʉ niwĩ. Davi Urías nʉmo níꞌco meꞌrã Salomórẽ põꞌrãticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomó Roboam pacʉ nicʉ niwĩ. Roboam Abías pacʉ nicʉ niwĩ. Abías Asa pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pacʉ nicʉ niwĩ. Josafat Joram pacʉ nicʉ niwĩ. Joram Uzías pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam pacʉ nicʉ niwĩ. Jotam Acaz pacʉ nicʉ niwĩ. Acaz Ezequías pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés pacʉ nicʉ niwĩ. Manasés Amón pacʉ nicʉ niwĩ. Amón Josías pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconías, tojo nicã cʉ̃ acabijirã pacʉ nicʉ niwĩ. Titapʉre Babilonia wãmetiri diꞌtacjãrã Israe curuacjãrãrẽ ñeꞌe, na ya diꞌta Babiloniapʉ miamʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tojo waꞌáca beꞌro ãpẽrã bajuacãrã niwã. Jeconías Salatiel pacʉ nicʉ niwĩ. Salatiel Zorobabel pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiud pacʉ nicʉ niwĩ. Abiud Eliaquim pacʉ nicʉ niwĩ. Eliaquim Azor pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadoc pacʉ nicʉ niwĩ. Sadoc Aquim pacʉ nicʉ niwĩ. Aquim Eliud pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pacʉ nicʉ niwĩ. Eleazar Matán pacʉ nicʉ niwĩ. Matán Jacob pacʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José pacʉ nicʉ niwĩ. José María marãpʉ nicʉ niwĩ. Co Jesú masãrẽ yʉꞌrʉoacjʉ Cristo na nigʉ̃́ paco nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tojo weero Abrahã meꞌrã dʉꞌpocã́ti, téé Davi wiogʉ nirĩ curapʉ catorce turiricjãrã waꞌacãrã niwã. Beꞌro Davi meꞌrã ticʉseta tja nicaro niwʉ̃. Israe curuacjãrãrẽ Babilonia diꞌtapʉ na miacateropʉ nitʉocaro niwʉ̃. Beꞌro Israe curuacjãrãrẽ Babiloniapʉ miáca beꞌrore tja ticʉseta nicaro niwʉ̃. Téé Cristo cʉ̃ bajuari curapʉ nitʉocaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo bajuaꞌque aꞌtiro waꞌacaro niwʉ̃. María cʉ̃ paco José meꞌrã omocã dʉꞌtegotigo weeco niwõ. Na niꞌcãrõ meꞌrã nise dʉporo co nijĩpaco nitojaco niwõ. Espíritu Santu cʉ̃ tutuaro meꞌrã core tojo waꞌacã weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José co marãpʉ niacjʉ añurõ ẽjõpeori masʉ̃ nicʉ niwĩ. Co nijĩpaco nisere masĩmigʉ̃, core maꞌi cõꞌasĩꞌrĩtigʉ, “Wiorãpʉre weresãweꞌe”, nicʉ niwĩ. Aꞌtiro peꞌe wãcũcʉ niwĩ. “Yaꞌyioropʉ core duꞌugʉti”, nicʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cʉ̃ tojo wãcũrĩ cura cʉ̃rẽ quẽꞌerõpʉ niꞌcʉ̃ Õꞌacʉ̃rẽ werecoꞌtegʉ ʉꞌmʉsecjʉ̃ aꞌtiro nicʉ niwĩ: —José, Davi pãrãmi nituriagʉ, Maríare ñaꞌarõ wãcũticãꞌña. Espíritu Santu cʉ̃ tutuaro meꞌrã co upʉpʉ sãjãnʉꞌcã, core nijĩpaco waꞌacã weecʉ niwĩ. Tojo weegʉ bopoyaro marĩrõ core mʉꞌʉ nʉmotiya. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Co wĩꞌmagʉ̃rẽ wʉagosamo. Cʉ̃, cʉ̃ yarã masãrẽ na ñaꞌarõ weeꞌquere yʉꞌrʉoacjʉ nigʉ̃sami. Tojo weegʉ Jesú wãmeyeya, ni werecʉ niwĩ Õꞌacʉ̃rẽ werecoꞌtegʉ. Jesú nírõ, “Masãrẽ yʉꞌrʉogʉ” nisĩꞌrĩrõ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Todʉporopʉ cʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ meꞌrã Õꞌacʉ̃ cʉ̃ ucũꞌquere queoro waꞌadutigʉ tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Aꞌtiro ni ojaduticʉ niwĩ: Niꞌcõ numio ʉmʉ meꞌrã nitimigõ, nijĩpaco ni, beꞌro põꞌrãtigosamo. Cʉ̃ Emanuel wãmetigʉsami, ni ojanoꞌcaro niwʉ̃. Emanuel “Õꞌacʉ̃ marĩ meꞌrã nimi”, nisĩꞌrĩrõ weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Beꞌro José wãꞌcãgʉ̃, Õꞌacʉ̃rẽ werecoꞌtegʉ dutiꞌquere weecʉ niwĩ. Maríare cʉ̃ ya wiꞌipʉ nʉmotigʉti nígʉ̃ miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tojo weemigʉ̃, co macʉ̃ wʉati dʉporo co meꞌrã niticʉ niwĩ. Co macʉ̃ bajuáca beꞌro cʉ̃rẽ Jesú wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herode Judea diꞌta wiogʉ nirĩ cura Jesú Belẽ́ wãmetiri macãpʉ bajuacʉ niwĩ. Cʉ̃ bajuáca beꞌro ʉmʉa masĩrĩ masã mujĩpũ mʉjãtiro peꞌecjãrã Jerusalẽ́pʉ etacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Topʉ etarã, sẽrĩtiñaꞌcãrã niwã: —Judío masã wiogʉ niacjʉ wĩꞌmagʉ̃ ¿noꞌopʉ bajuapari? Ʉ̃sã ya macã mujĩpũ mʉjãtiro peꞌe dʉporopʉ ñocõawʉ̃ ʉ̃sã ĩꞌatiꞌcʉre ĩꞌawʉ̃. Cʉ̃rẽ ĩꞌarã, “Wiogʉ niacjʉ bajuatojapĩ”, niwʉ̃. Tojo weerã cʉ̃rẽ ẽjõpeorã aꞌtiapʉ, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herode na tojo nisere tʉꞌogʉ, mejẽcã pejaro tʉꞌoñaꞌcʉ niwĩ. Jerusalẽ́cjãrã quẽꞌrã nipeꞌtirã mejãrõta tʉꞌoñaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tojo weegʉ paꞌia wiorãrẽ pijiocʉ niwĩ. Tojo nicã ãpẽrã masãrẽ Moisé dutiꞌquere buꞌeri masãrẽ pijiocʉ niwĩ. Narẽ sẽrĩtiñaꞌcʉ niwĩ: —Cristo Õꞌacʉ̃ beseꞌcʉ ¿noꞌopʉ bajuagʉsari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cʉ̃ tojo nicã, na yʉꞌticãrã niwã: —Aꞌti diꞌta Judea Belẽ́ wãmetiri macãpʉ bajuagʉsami. Dʉporocjʉ̃pʉ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ cʉ̃ bajuatjere aꞌtiro ni ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belẽ́, Judea diꞌtapʉ nirĩ macã mejõ nirĩ macã mejẽta niꞌi. Ti diꞌta nise macãrĩ waꞌteropʉre ti macãcjʉ̃ niꞌcʉ̃ wiogʉ wijagʉsami. Yarã masã Israe curuacjãrãrẽ coꞌteacjʉ nigʉ̃sami, ni ojanoꞌcaro niwʉ̃, ni werecãrã niwã Herodere. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na tojo níca beꞌro Herode yaꞌyioropʉ masĩrĩ masãrẽ cʉ̃ tiropʉ pijiocʉ niwĩ. Narẽ sẽrĩtiñaꞌgʉ̃, aꞌtiro nicʉ niwĩ: —¿Deꞌro nicã waro ñocõawʉ̃ bajuabutiamirĩ cʉ̃? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“Tita bajuawĩ” tojo níca beꞌro narẽ Belẽpʉ waꞌadutigʉ aꞌtiro nicʉ niwĩ: —Topʉ wĩꞌmagʉ̃rẽ añurõ sẽrĩtiñaꞌbaqueꞌaya. Cʉ̃rẽ bocarã, yʉꞌʉre wereya. Yʉꞌʉ quẽꞌrã cʉ̃rẽ ẽjõpeogʉ waꞌagʉti weeꞌe, nisoocʉ niwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Narẽ tojo ni wéréca beꞌro masĩrĩ masã Belẽpʉ yʉꞌrʉacãrã niwã. Topʉ yʉꞌrʉarã, ñocõawʉ̃ na ya macãpʉ ĩꞌawãꞌcãtiꞌcʉta tja na dʉporo ʉꞌmʉtãwãꞌcãcʉ niwĩ. Beꞌro wĩꞌmagʉ̃ nirṍ buꞌipʉ ejagʉ, ñocõawʉ̃ tojanʉꞌcãcʉ niwĩ majã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Masĩrĩ masã ñocõawʉ̃rẽ ĩꞌarã, pũrõ eꞌcaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ti wiꞌipʉ sãjãejarã, wĩꞌmagʉ̃rẽ cʉ̃ paco María meꞌrã nigʉ̃rẽ ĩꞌacãrã niwã. Cʉ̃rẽ ĩꞌarã ẽjõpeorã, ejaqueꞌacãrã niwã. Beꞌro na miaꞌque acarire pãa, cʉ̃rẽ uru, ʉꞌmʉtise inciensore, tojo nicã apeye ʉꞌmʉtiseta tja mirra wãmetisere oꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Beꞌro narẽ quẽꞌerõpʉ Õꞌacʉ̃ “Herode tiropʉ majãmitojaaticãꞌña”, nicʉ niwĩ. Tojo weerã na ya diꞌtapʉ tojaarã, ape maꞌapʉ majãmitojaacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Masĩrĩ masã tojááca beꞌro Joseré Õꞌacʉ̃rẽ werecoꞌtegʉ ʉꞌmʉsecjʉ̃ quẽꞌerõpʉ bajua, aꞌtiro nicʉ niwĩ: —Wãꞌcãña. Wĩꞌmagʉ̃ cʉ̃ paco meꞌrã Egiptopʉ duꞌtiaya. Topʉ tojáníña. Yʉꞌʉ “Tocãꞌrõta tojatia” níca beꞌropʉ tojatia tja. Herode wĩꞌmagʉ̃rẽ wẽjẽsĩꞌrĩgʉ̃ aꞌmagʉ̃sami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cʉ̃ tojo nicã tʉꞌogʉ, José wãꞌcã, wĩꞌmagʉ̃rẽ paco meꞌrã ñamita Egiptopʉ sʉꞌori miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Topʉre Herode catiro põtẽorõ tojánícãrã niwã. Aꞌte Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ cʉ̃ ojaꞌque queoro waꞌadutiro tojo waꞌacaro niwʉ̃. Tere aꞌtiro ni ojamʉꞌtãcʉ niwĩ: “ ‘Yʉꞌʉ macʉ̃ Egiptopʉ nigʉ̃rẽ pijiwijawʉ’, tojo nicʉ niwĩ Õꞌacʉ̃”, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herode masĩrĩ masãrẽ, yʉꞌʉre bujicãꞌpã nígʉ̃, uayʉꞌrʉmajãcʉ niwĩ. Tojo uagʉ, nipeꞌtirã ʉmʉa wĩꞌmarãrẽ Belẽpʉ, tojo nicã ti macã sumutopʉ nirãrẽ pʉa cʉ̃ꞌma cʉorãrẽ, na dʉjaro cʉorãrẽ wẽjẽduticʉ niwĩ. Na masĩrĩ masã cʉ̃rẽ wereꞌcaro ejatuaro tocãꞌrõta bʉcʉasami nígʉ̃, ʉmʉa wĩꞌmarã ticʉse cʉ̃ꞌmarĩ cʉorãrẽ wẽjẽduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cʉ̃ tojo weedutisere Jeremía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ cʉ̃ ojaꞌque queoro waꞌacaro niwʉ̃. Aꞌtiro ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá wãmetiri macãpʉre masã bʉjaweti, uti caricũcã tʉꞌonoꞌrõsaꞌa. Raquel pãrãmerã nituriarãnumiapʉ Israe curuacjãrã nʉmosãnumia na põꞌrãrẽ pũrõ dʉjasewãꞌa, utirãsama. Na põꞌrãrẽ wẽjẽcã ĩꞌarã bʉjaweticã, ãpẽrã wãcũtutuase oꞌomasĩtirãsama, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode wẽ́rĩ́ca beꞌro quẽꞌerõpʉ niꞌcʉ̃ Õꞌacʉ̃rẽ werecoꞌtegʉ José Egiptopʉ nigʉ̃rẽ nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wãꞌcãña. Wĩꞌmagʉ̃rẽ cʉ̃ paco meꞌrã Israe curuacjãrã nirĩ diꞌtapʉ sʉꞌori dajatojaaya. Wĩꞌmagʉ̃rẽ wẽjẽsĩꞌrĩꞌcãrã boapeꞌtia waꞌama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tojo nicã tʉꞌogʉ, José wãꞌcã, wĩꞌmagʉ̃rẽ cʉ̃ paco meꞌrã Israe curuacjãrã nirĩ diꞌtapʉ sʉꞌori miacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Beꞌro “Herode macʉ̃ Arquelao cʉ̃ pacʉre Judea diꞌta wiogʉ dʉcayuapʉ” nicã tʉꞌogʉ, uicʉ niwĩ. Tojo weegʉ topʉre waꞌasĩꞌrĩticʉ niwĩ. Õꞌacʉ̃rẽ quẽꞌerõpʉ werenoꞌcʉ niyugʉ, Galilea wãmetiri diꞌta peꞌe yʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Topʉre etarã, Nazare wãmetiri macãpʉ tojaqueꞌacãrã niwã. Na topʉ waꞌacã, Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã na ojaꞌque queoro waꞌacaro niwʉ̃. “Masã cʉ̃rẽ ‘Nazarecjʉ̃ nimi’ nirãsama”, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesú cʉ̃ Nazarepʉ nirĩ cura Juã masãrẽ wãmeyeri masʉ̃ Judea diꞌtapʉ yucʉ marĩrõ, masã marĩrõpʉ waꞌacʉ niwĩ. Topʉ masã cʉ̃ tiropʉ ejarãrẽ buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Aꞌtiro ni werecʉ niwĩ: —Cãꞌrõacã beꞌro Õꞌacʉ̃ beseꞌcʉ pãjãrã masã wiogʉ sãjãgʉ̃sami. Tojo weerã mʉsã ñaꞌarõ weeꞌquere bʉjaweti, duꞌuya. Mʉsã wãcũsere dʉcayuya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juã ye cjasere Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Isaía aꞌtiro ojacʉ niwĩ: Niꞌcʉ̃ yucʉ marĩrõ, masã marĩrõpʉ aꞌtiro caricũnuꞌcũbajaqueꞌatigʉsami: “Marĩ wiogʉ aꞌtiatji maꞌarẽ apoyuya. Diacjʉ̃ca maꞌa añurĩ maꞌa quẽꞌrã́rõ weronojõ weeyuya”, ni ojacʉ niwĩ. Marĩ wiogʉ aꞌtiati dʉporo mʉsã nisetisere apoyuya, mʉsã wãcũsere dʉcayuya nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juã ya suꞌtiro cameyo poari meꞌrã na suꞌaꞌcaro nicaro niwʉ̃. Waꞌicʉrã casero meꞌrã ejeritucʉ niwĩ. Pajasecʉorã na baꞌasetisere poreroa, nʉcʉ̃ cjase mumia yere baꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pãjãrã Jerusalẽ́cjãrã, ãpẽrã ti diꞌta Judeapʉ nirã́ cʉ̃ tiropʉ cʉ̃ buꞌesere tʉꞌorã waꞌacãrã niwã. Tojo nicã dia Jordã́ wãmetiri maa pʉꞌtocjãrã tʉꞌorã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na ñaꞌarõ weeꞌquere wereyʉꞌrʉca beꞌro narẽ wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tojo weeri cura pãjãrã fariseo masã, ãpẽrã saduceo masã wãmeyeduticãrã niwã. Na ñaꞌarõ weeꞌquere bʉjaweti dʉcayusĩꞌrĩticã ĩꞌagʉ̃, aꞌtiro nicʉ niwĩ: —Mʉsã weetaꞌsari curuacjãrã aña weronojõ niꞌi. Aña nʉcʉ̃ ʉ̃jʉ̃cã, uiwãꞌcãsama. Mʉsã aña weronojõ buꞌiri daꞌresere uiꞌi. Tojo uirã, mʉsã ñaꞌarõ weeꞌquere bʉjaweti dʉcayusĩꞌrĩtimirã, wãmeyedutirã aꞌtiapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mʉsã, diacjʉ̃ta ʉ̃sã ñaꞌarõ weeꞌquere bʉjaweti dʉcayuapʉ nírã, mʉsã weesetise meꞌrã ĩꞌoña. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mʉsã aꞌtiro wãcũticãꞌña: “Ʉ̃sã Abrahã pãrãmerã niꞌi. Tojo weerã Õꞌacʉ̃ tiropʉ waꞌarãsaꞌa”, ni wãcũticãꞌña. Mʉsã wãcũsere dʉcayuticã, Abrahã pãrãmerã nise wapamarĩꞌi. Õꞌacʉ̃ ʉagʉ, aꞌte ʉ̃tãperi meꞌrã Abrahã pãrãmerã waꞌacã weemasĩmi. Cʉ̃ tojo weecãma, na peꞌe Õꞌacʉ̃ ʉaro weebosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Marĩ yucʉpagʉ oteꞌquepagʉ weronojõ niꞌi. Õꞌacʉ̃ mʉsãrẽ yucʉpagʉ dʉca marĩsepagʉre besecõꞌarõ weronojõ weegʉsami. Yucʉ añurõ dʉcatiticjʉre paacõꞌa, ʉ̃jʉ̃acõꞌacãꞌnoꞌsaꞌa. Tere weeꞌcaro weronojõ mʉsã wãcũsere dʉcayuticã, añurõ weesetiticã, Õꞌacʉ̃ mʉsãrẽ cõmea meꞌrã paacõꞌagʉ̃ weronojõ buꞌiri daꞌregʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yʉꞌʉ mʉsãrẽ na ñaꞌarõ weeꞌquere bʉjaweti, duꞌuama nígʉ̃, aco meꞌrã wãmeyeꞌe. Yʉꞌʉ beꞌro apĩ yʉꞌʉ nemorõ tutuagʉ aꞌtigʉsami. Cʉ̃ añugʉ̃ waro nimi. Yʉꞌʉ peꞌe mejõ nigʉ̃ tʉꞌoñaꞌa. Ne cʉ̃rẽ niꞌcãrõwijimasĩtisaꞌa. Cʉ̃ pũrĩcã Espíritu Santure mʉsãrẽ oꞌógʉsami. Cʉ̃rẽ masã meꞌrã ninuꞌcũcã weegʉsami. Ñaꞌarõrẽ ʉ̃jʉ̃aweero weronojõ mʉsãrẽ añurõ tojato nígʉ̃, ñaꞌarõ weeꞌquere cõꞌagʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yʉꞌʉ beꞌro aꞌtigʉ niꞌcʉ̃ trigo suꞌtiweeri masʉ̃ weronojõ nimi. Cʉ̃ te suꞌtire mejẽcã sʉꞌawee, cõꞌasami. Te trigo peri quẽꞌrãrẽ mejẽcã mii, te nʉrõrĩ wiꞌipʉ nʉrõsami. Te suꞌtire pecameꞌepʉ ʉ̃jʉ̃acõꞌasami. Aꞌte weronojõ cʉ̃, cʉ̃ yarã warore bese, cʉ̃ tiropʉ miagʉ̃sami. Ãpẽrãrẽ pecameꞌepʉ cõꞌabajuriogʉsami. Ti meꞌe ne peꞌtisome, ni werecʉ niwĩ Juã. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juã wãmeyeri curare Jesú Galileapʉ níꞌcʉ Jordã́ wãmetiri maapʉ waꞌacʉ niwĩ. Topʉre waꞌagʉ, Juãrẽ wãmeyedutigʉ waꞌagʉ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Topʉ cʉ̃ etacã, Juã cʉ̃rẽ wãmeyesĩꞌrĩticʉ nimiwĩ. —Yʉꞌʉ peꞌe mʉꞌʉrẽ wãmeyedutironojõ oꞌogʉ, ¿mʉꞌʉ peꞌe yʉꞌʉre wãmeyedutigʉ aꞌtiti? nicʉ niwĩ Jesure. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú “Wãmeyeya. Nipeꞌtise Õꞌacʉ̃ marĩrẽ weedutiꞌcaronojõta weeroʉaꞌa. Añucãꞌrõsaꞌa”, nicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌogʉ, Juã “Jaʉ” ni, cʉ̃rẽ wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cʉ̃rẽ wãmeyeca beꞌro cʉ̃ majãnʉꞌcãcãta, ʉꞌmʉse pãrĩcaro niwʉ̃. Jesú Espíritu Santu buja weronojõ bajugʉ cʉ̃pʉre dijatacã ejapejagʉre ĩꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tojo waꞌacã, ʉꞌmʉsepʉ cʉ̃ pacʉ Õꞌacʉ̃ ucũdijocʉ niwĩ. —Ãꞌrĩ yʉꞌʉ macʉ̃ ʉpʉtʉ yʉꞌʉ maꞌigʉ̃ nimi. Cʉ̃ meꞌrã pũrõ eꞌcatiꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesú wãmeyenoꞌca beꞌro Espíritu Santu cʉ̃rẽ yucʉ marĩrõ, masã marĩrõpʉ sʉꞌori miacʉ niwĩ. Wãtĩ Jesure cʉ̃ pacʉre yʉꞌrʉnʉꞌcãdutigʉ niquesãcʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Topʉre Jesú cuarenta nʉmʉrĩ, cuarenta ñamirĩ ne cãꞌrõ baꞌaticʉ niwĩ. Beꞌro ʉjaboayʉꞌrʉacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jesú tojo ʉjaboacã ĩꞌagʉ̃, wãtĩ cʉ̃ pʉꞌto waꞌacʉ niwĩ. Cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Mʉꞌʉ diacjʉ̃ta Õꞌacʉ̃ macʉ̃ niꞌi nígʉ̃, aꞌte ʉ̃tãperire pã́ dojorẽ baꞌaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cʉ̃ tojo nicã, Jesú aꞌtiro yʉꞌticʉ niwĩ: —Õꞌacʉ̃ ye queti ojáca pũrĩpʉ aꞌtiro ojanoꞌo: “Masã baꞌase meꞌrã diaꞌcʉ̃ catimasĩtisama. Na añurõ nisĩꞌrĩrã, nipeꞌtise Õꞌacʉ̃ ucũsere yʉꞌti ẽjõpeosama”, niwʉ̃, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Beꞌro wãtĩ cʉ̃rẽ Jerusalẽ́pʉ “Õꞌacʉ̃ ya macã”, na ninoꞌca macãpʉ miacʉ niwĩ. Topʉre Õꞌacʉ̃ wiꞌi dʉposãrĩpʉ sʉꞌori miimʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jesure nicʉ niwĩ tja: —Mʉꞌʉ diacjʉ̃ta Õꞌacʉ̃ macʉ̃ niꞌi nígʉ̃, aꞌtopʉ buꞌpudijaya. Õꞌacʉ̃ ye queti ojáca pũrĩpʉ aꞌtiro ni ojanoꞌo: Õꞌacʉ̃ cʉ̃rẽ werecoꞌterã meꞌrã mʉꞌʉrẽ coꞌtedutigʉsami. Mʉꞌʉrẽ ʉ̃tãgãpʉ doquepejari nírã, mʉꞌʉrẽ tuuñeꞌerãsama, ni ojanoꞌcaro niwʉ̃, nicʉ niwĩ wãtĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tojo nisere Jesú cʉ̃rẽ yʉꞌticʉ niwĩ: —Õꞌacʉ̃ ye queti ojáca pũrĩpʉ aꞌte quẽꞌrã ojanoꞌcaro niwʉ̃: “Mʉꞌʉ wiogʉ Õꞌacʉ̃ cʉ̃ ucũꞌquere ne niꞌcãti ¿diacjʉ̃ta nimitito? nírã, cʉ̃rẽ weeĩꞌodutiticãꞌña”, ni ojanoꞌwʉ̃, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Beꞌro wãtĩ ʉ̃rʉ̃gʉ̃ ʉꞌmʉacjʉpʉ miacʉ niwĩ tja. Topʉre nipeꞌtise aꞌti diꞌta cjase macãrĩrẽ, tojo nicã te macãrĩ cʉosere ĩꞌopeꞌocãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ĩꞌogʉ̃, cʉ̃rẽ nicʉ niwĩ: —Nipeꞌtise aꞌte mʉꞌʉrẽ ĩꞌoꞌquere oꞌogʉti mʉꞌʉ yʉꞌʉre ejaqueꞌa ẽjõpeocã, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tojo nicã tʉꞌogʉ, Jesú cʉ̃rẽ nicʉ niwĩ: —Waꞌaya, wãtĩ. Õꞌacʉ̃ ye queti ojáca pũrĩpʉ aꞌtiro ojanoꞌo: “Õꞌacʉ̃ mʉꞌʉ wiogʉ niꞌcʉ̃rẽta ẽjõpeoya. Cʉ̃ niꞌcʉ̃rẽta yʉꞌtiroʉaꞌa”, niwʉ̃, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tojo nicã tʉꞌogʉ, wãtĩ waꞌa waꞌacʉ niwĩ. Beꞌro Õꞌacʉ̃rẽ werecoꞌterã ʉꞌmʉsecjãrã Jesure weetamurã, baꞌase ecarã aꞌticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Beꞌro Jesú “Juã wãmeyeri masʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ niapʉ” nisere tʉꞌocʉ niwĩ. Tere tʉꞌogʉ, Galilea diꞌtapʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Topʉre cʉ̃ ya macã Nazarepʉre tojaqueꞌaticʉ niwĩ. Ape macã Capernau peꞌe tojaqueꞌacʉ niwĩ. Ti macã ditara sumuto Zabulṍ, tojo nicã Neftalí wãmetiro waꞌteropʉ nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aꞌte Isaía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ cʉ̃ ojaꞌque queoro waꞌadutiro tojo waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Aꞌtiro ojacʉ niwĩ: Zabulṍ, tojo nicã Neftalí wãmetise diꞌta Galilea wãmetiri ditara pʉꞌtopʉ niꞌi. Jordã́ wãmetiri maa ape pãꞌrẽpʉ niꞌi. Topʉ Galilea diꞌtapʉ judío masã nitirã nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tocjãrã masã naꞌitĩꞌarõpʉ nirã́ weronojõ Õꞌacʉ̃rẽ masĩtisama. Tojo nimirã, añurõ boꞌreyusere ĩꞌarã weronojõ narẽ yʉꞌrʉoacjʉre ĩꞌarãsama. Na Õꞌacʉ̃ yere masĩtimirã tere werecã, tʉꞌorãsama. Na buꞌiri daꞌre bajurionoꞌboꞌcãrã nimirã, masãbajuama, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Titare topʉ Jesú masãrẽ ne waro buꞌewãꞌcõcʉ niwĩ. Narẽ “Mʉsã ñaꞌarõ weesetisere bʉjaweti, duꞌuya. Mʉsã wãcũsere dʉcayuya. Cãꞌrõacã beꞌro Õꞌacʉ̃ cʉ̃ wiogʉ nimi nisere masãrẽ masĩcã weegʉsami”, ni buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Beꞌro Jesú Galilea wãmetiri ditara sumutopʉ sijabaqueꞌacʉ niwĩ. Topʉ waꞌa, niꞌcʉ̃ põꞌrã pʉarã ʉmʉarẽ bocaejacʉ niwĩ. Niꞌcʉ̃ Simó, apetero Pedro pisunoꞌgʉ̃ nicʉ niwĩ. Apĩ cʉ̃ acabiji André nicʉ niwĩ. Na waꞌi wẽjẽrĩ masã nicãrã niwã. Tojo weerã na wejecʉre ditarapʉ doqueñorã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na tojo weecã ĩꞌagʉ̃, Jesú narẽ nicʉ niwĩ: —Teꞌa yʉꞌʉ meꞌrã. Mʉsã niꞌcãrõacãrẽ waꞌi wẽjẽrĩ masã niꞌi. Beꞌropʉre majã waꞌi wẽjẽrã weronojõ masãrẽ yé quetire wererãsaꞌa. Tojo weecã, pãjãrã ẽjõpeorãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Cʉ̃ tojo nicã tʉꞌorã, maata na waꞌi wẽjẽse cʉoꞌquere duꞌucũupeꞌo, cʉ̃ meꞌrã sirutuwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cãꞌrõ yʉꞌrʉaa, ãpẽrã cʉ̃ acabiji meꞌrã nirãrẽ tja ĩꞌacʉ niwĩ. Na Zebedeo põꞌrã Santiago, Juã nicãrã niwã. Na, na pacʉ meꞌrã yucʉsʉpʉ wejecʉpagʉre dero aporã sãñacãrã niwã. Jesú na quẽꞌrãrẽ “Teꞌa”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cʉ̃ tojo nicã tʉꞌorã, na yawʉ yucʉsʉre, tojo nicã na pacʉre totá cõꞌacũu, Jesú meꞌrã sirutuwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesú nipeꞌtiro Galilea diꞌtapʉ judío masã nerẽwʉase wiꞌseripʉ buꞌecusiacʉ niwĩ. Cʉ̃ añuse queti Õꞌacʉ̃ yere, cʉ̃ wiogʉ nimi nisere buꞌecʉ niwĩ. Noꞌo na deꞌro nise dutitisere yʉꞌrʉowãꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cʉ̃ tojo weese quetire nipeꞌtiro Siria diꞌtacjãrã masĩpeꞌticãrã niwã. Tojo weerã deꞌro nise piꞌetirãrẽ cʉ̃ tiropʉ miacãrã niwã. Doꞌatirãrẽ, wãtĩ sãjãnoꞌcãrãrẽ, noꞌo ñama wẽrĩse cʉorãrẽ, tojo nicã sijamasĩtirãrẽ cʉ̃ tiro miaa, yʉꞌrʉoduticãrã niwã. Nipeꞌtirãrẽ yʉꞌrʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cʉ̃ tojo weecã tʉꞌorã, pãjãrã Galilea diꞌtacjãrã, Decápoli wãmetise macãrĩcjãrã sirutucãrã niwã. Tojo nicã Jerusalẽ́cjãrã, Judea diꞌtacjãrã, Jordã́ wãmetiri maa siaquijicjãrãpʉ sirutucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesú pãjãrã sirutucã ĩꞌagʉ̃, ʉ̃rʉ̃gʉ̃pʉ mʉjãa, ejanujãcʉ niwĩ. Tojo weecã, cʉ̃ buꞌerã cʉ̃ sumuto nerẽnujãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Beꞌro Jesú narẽ aꞌtiro buꞌenʉꞌcãcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ ‘Õꞌacʉ̃ weetamurõ meꞌrã diaꞌcʉ̃ cʉ̃ ʉaro weemasĩꞌi’ nirãnojõ eꞌcatirãsama. Tojo nirãnojõ Õꞌacʉ̃ wiogʉ nirõpʉ sãjã́árãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","”Bʉjawetirãnojõ eꞌcatima. Õꞌacʉ̃ narẽta weetamugʉ̃sami. Narẽ wãcũtutuacã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","”Noꞌo ‘Yʉꞌʉ basu ãpẽrã yʉꞌrʉoro niꞌi’ nitirãnojõ eꞌcatisama. Tojo weerã na Õꞌacʉ̃ ‘Oꞌogʉti’ níꞌque diꞌtare ñeꞌerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","”Õꞌacʉ̃ ye, diacjʉ̃ nisere masĩsĩꞌrĩrã, ʉjaboa, acowʉoꞌcãrã weronojõ nisama. Tojo ʉjaboa, acowʉorã weronojõ masĩsĩꞌrĩrãrẽ Õꞌacʉ̃ eꞌcatise oꞌogʉsami. Na Õꞌacʉ̃ yere masĩ́ca beꞌro baꞌa, sĩꞌrĩtuurã weronojõ nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","”Ãpẽrãrẽ pajañaꞌrã eꞌcatima. Õꞌacʉ̃ quẽꞌrã narẽ pajañaꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","”Noꞌo ñaꞌase moorãnojõ eꞌcatima. Náta Õꞌacʉ̃rẽ ĩꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","”Noꞌo aꞌmequẽse marĩrõ ninuꞌcũsĩꞌrĩrãnojõ eꞌcatima. Õꞌacʉ̃ narẽ ‘Yʉꞌʉ põꞌrã nima’, nigʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","”Noꞌo Õꞌacʉ̃ ʉaro weecã ñaꞌarõ weesirutunoꞌrãnojõ eꞌcatima. Náta Õꞌacʉ̃ wiogʉ nirõpʉ waꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Yʉꞌʉre ẽjõpeose buꞌiri mʉsãrẽ ãpẽrã ñaꞌarõ bujicãꞌa, piꞌetise oꞌorãsama. Noꞌo nise nisoo, nimaꞌarãsama mʉsãrẽ. Na tojo weecã, eꞌcatiya. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dʉporocjãrãpʉ Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masãrẽ mejãrõta weecãrã niwã. Mʉsã ʉꞌmʉsepʉre pajibutiaro eꞌcatise bocarãsaꞌa. Tojo weerã eꞌcatiya”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesú aꞌtiro buꞌenemocʉ niwĩ: “Marĩ baꞌarã, ʉꞌsʉato nírã moarẽ sãꞌa. Mʉsã moa weronojõ niꞌi aꞌti nucũcãpʉre. Mʉsã añurõ niseticã ĩꞌarã, ãpẽrã quẽꞌrã ĩꞌacũu, yʉꞌʉre ẽjõpeorãsama. Mʉsã tojo weeticãma, moa ocatiro weronojõ nirãsaꞌa. Moa ocaticã, ʉꞌsʉatisaꞌa. Te tojo nicã, cõꞌacãꞌnoꞌo. ¿Apaturi deꞌro wee moa ocacã weebosari tja? ");
INSERT INTO tuoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Mʉsã yʉꞌʉre ẽjõpeorã sĩꞌose weronojõ niꞌi masãrẽ. Tojo weerã mʉsã ãpẽrã yʉꞌʉre masĩtirãrẽ masĩcã weeꞌe. Niꞌcã macã ʉ̃rʉ̃gʉ̃pʉ nirĩ macã bajutiropʉ niticã weetisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Masã sĩꞌocjare apeyenojõ docapʉ sĩꞌótisama. Tojo weronojõ oꞌorã, nipeꞌtirã ti wiꞌipʉ nirãrẽ bajuato nírã ʉꞌmʉarõpʉ peosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aꞌte weronojõ bajuyoropʉ yʉꞌʉ ʉaronojõ añurõ weesetiya. Mʉsã añurõ weecã ĩꞌarã, ãpẽrã quẽꞌrã marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃rẽ ‘Añuyʉꞌrʉgʉ nimi’, ni eꞌcatirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”Aꞌtiro wãcũticãꞌña yʉꞌʉre. ‘Jesú Moisé dutiꞌquere, tojo nicã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masã na wereyuꞌquere cõꞌagʉ̃ aꞌtigʉ weepĩ’, niticãꞌña. Tere cõꞌagʉ̃ mejẽta aꞌtiwʉ. Tere queoro weepeꞌogʉ aꞌtigʉ weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Diacjʉ̃ mʉsãrẽ weregʉti. Ʉꞌmʉse, aꞌti turi nirĩ curare Õꞌacʉ̃ ne cãꞌrõacã te dutisere cõꞌasome. Nipeꞌtise cʉ̃ ‘Aꞌtiro weegʉti’ níꞌquere queoro weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tojo weegʉ noꞌo cãꞌrõacã te dutisere yʉꞌrʉnʉꞌcãgʉ̃nojõ mejõ nigʉ̃ waro nigʉ̃sami Õꞌacʉ̃ wiogʉ nirõpʉre. Tojo nicã ãpẽrãrẽ yʉꞌrʉnʉꞌcãcã weegʉnojõ mejãrõta nigʉ̃sami. Apĩ Moisé dutisere weegʉ́ peꞌe, tojo nicã ãpẽrãrẽ tere weedutigʉ peꞌe wiogʉ weronojõ nigʉ̃sami Õꞌacʉ̃ wiogʉ nirõpʉre. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉsãrẽ aꞌtiro weregʉti. Moisé dutiꞌquere buꞌeri masã, tojo nicã fariseo masã yʉꞌrʉoro Õꞌacʉ̃ dutise peꞌere añurõ weeyʉꞌrʉnʉꞌcãtirã, Õꞌacʉ̃ tiropʉ waꞌasome”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesú aꞌtiro werenemocʉ niwĩ: “Mʉsã tʉꞌopã mʉsã ñecʉ̃sʉmʉarẽ dutiꞌquere: ‘Masãrẽ wẽjẽcõꞌaticãꞌña. Noꞌo apĩrẽ wẽjẽcõꞌagʉ̃nojõ tenojõ besegʉ tiropʉ besenoꞌo, buꞌiri daꞌrenoꞌgʉ̃sami’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉꞌʉ peꞌe aꞌtiro weregʉti. Noꞌo cʉ̃ acaweregʉ meꞌrã uagʉnojõ buꞌiri daꞌrenoꞌgʉ̃sami. Noꞌo cʉ̃ acaweregʉre ‘Mʉꞌʉ wapamarĩꞌi’ ni bujicãꞌgʉ̃nojõ wiorã tiropʉ besenoꞌgʉ̃sami. Noꞌo cʉ̃ acaweregʉre ‘Waꞌicʉ weronojõ tʉꞌomasĩse moobutiaꞌa’ nigʉ̃nojõrẽ Õꞌacʉ̃ pecameꞌepʉ buꞌiri daꞌre, cõꞌatawio niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Tojo weegʉ Õꞌacʉ̃ wiꞌipʉ noꞌo Õꞌacʉ̃rẽ ẽjõpeoacjʉ apeyenojõ oꞌogʉtigʉ, ‘Yʉꞌʉ acaweregʉre ñaꞌarõ weecãti’ ni wãcũbocagʉ, aꞌtiro weeroʉaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Cʉ̃ oꞌoatjere duꞌupeo, cʉ̃rẽ acobojose sẽrĩmʉꞌtãgʉ̃ waꞌaroʉaꞌa. Beꞌro ‘Õꞌacʉ̃rẽ oꞌogʉti’ níꞌquere oꞌoroʉaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”Apeye quẽꞌrãrẽ weregʉti. Niꞌcʉ̃ mʉsãrẽ weresãsĩꞌrĩgʉ̃ besewʉaropʉ miasĩꞌrĩcã, maata topʉ waꞌase dʉporo apoweꞌocãꞌña. Tojo weecã, mʉsãrẽ beseri masʉ̃rẽ oꞌotibosami. Tojo weeticãma, beseri masʉ̃ surarapʉre oꞌo, buꞌiri daꞌreri wiꞌipʉ sõrõbosami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Diacjʉ̃ta mʉsãrẽ weregʉti. Buꞌiri daꞌreri wiꞌipʉ sãjãa wapayepeꞌoticã, ne duꞌuwĩrõsome”, ni werecʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesú aꞌtiro werenemocʉ niwĩ: “Apeyere todʉporopʉ dutiꞌquere tʉꞌopã. ‘Mʉsã nʉmosãnumia nitirãrẽ, mʉsã marãpʉsʉmʉa nitirãrẽ aꞌmetãrãticãꞌña’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉꞌʉ peꞌe aꞌtiro weregʉti. Noꞌo numiorẽ ñaꞌarõ weesĩꞌrĩ ʉaripejase meꞌrã ĩꞌagʉ̃nojõ cʉ̃ poꞌpeapʉ co meꞌrã ñaꞌarõ weetojasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","”Tojo weerã mʉsã caperi meꞌrã ñaꞌarõ weesĩꞌrĩrã, tigare orewee cõꞌaboꞌcaro weronojõ maata ĩꞌaduꞌucãꞌña. Ñaꞌarõ weeduꞌutirã, pecameꞌepʉ waꞌarãsaꞌa. Mʉsã capeare cõꞌarã, ti capea diaꞌcʉ̃rẽ bajuriorãsaꞌa. Nipeꞌtiro mʉsã upʉ pecameꞌepʉ waꞌacã, ñaꞌayʉꞌrʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mejãrõta buꞌiri bocari nígʉ̃, diacjʉ̃camocã meꞌrã ñaꞌarõ weesĩꞌrĩgʉ̃, weeduꞌucãꞌña. Tojo weecã, nipeꞌtiro upʉ pecameꞌepʉ buꞌiri bocaboꞌcaro buꞌiri daꞌrenoꞌsome”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesú ninemocʉ niwĩ: “Apeye todʉporocjãrãpʉre níꞌquere tʉꞌopã: ‘Noꞌo nʉmorẽ cõꞌagʉ̃, “Aꞌte ye buꞌiri mʉꞌʉrẽ cõꞌaꞌa” nirĩ pũrĩrẽ oja, core oꞌoroʉaꞌa’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉꞌʉ peꞌe aꞌtiro weregʉti. Niꞌcʉ̃ cʉ̃ nʉmorẽ co apĩ meꞌrã ñaꞌarõ nitimicã cõꞌagʉ̃nojõ core ʉmʉa meꞌrã ñaꞌarõ weeri masõrẽ weronojõ tojacã weesami. Noꞌo marãpʉ cõꞌanoꞌco meꞌrã nʉmotigʉnojõ quẽꞌrã ñaꞌarõ cʉ̃ nʉmo nitigo meꞌrã aꞌmetãrãgʉ̃ weronojõ tojasami”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesú aꞌtiro werenemocʉ niwĩ: “Apeyere todʉporocjãrãrẽ níꞌquere tʉꞌopã: ‘Mʉsã “Õꞌacʉ̃ wãme meꞌrã weegʉti” níꞌcaronojõta nisooro marĩrõ queoro weeya’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉꞌʉ peꞌe aꞌtiro weregʉti. Mʉsã ãpẽrãrẽ ‘Aꞌtiro weerãti’ nírã, Õꞌacʉ̃rẽ wãmepeoticãꞌña. ‘Ʉꞌmʉse meꞌrã weerãti’, niticãꞌña. Õꞌacʉ̃ nirṍ topʉta niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Aꞌti nucũcã meꞌrã niꞌi’, niticãꞌña. Õꞌacʉ̃ wééca diꞌta niꞌi. Jerusalẽ́ quẽꞌrã marĩ wiogʉ Õꞌacʉ̃ ya macã niꞌi. Tojo weerã Jerusalẽ́ meꞌrã wãmepeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tojo nicã ‘Ʉ̃sã ya dʉpoa meꞌrã niꞌi’, niticãꞌña. Mʉsã tojo nise meꞌrã niꞌcã poadare ñirĩ da o butiri da dʉcayumasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aꞌtiro diaꞌcʉ̃ niña. Diacjʉ̃ nicã, wãmepeoro marĩrõ ‘Diacjʉ̃ta niꞌi’, niña. Tojo niticã, ‘Diacjʉ̃ niweꞌe’, niña. Mʉsã ninemopeosepʉa noꞌo wãtĩ wãcũse oꞌose nibosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Apeyere todʉporocjãrãrẽ níꞌquere tʉꞌopã: ‘Niꞌcʉ̃ mʉsãrẽ capea paatĩꞌacã, mʉsã quẽꞌrã mejãrõta cʉ̃rẽ paatĩꞌaaꞌmeña’, niwʉ̃. Tojo nicã ‘Upicare paapeꞌecã, mejãrõta cʉ̃rẽ paapeꞌeaꞌmeña’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉꞌʉ peꞌe mʉsãrẽ aꞌtiro weregʉti. Mʉsãrẽ ñaꞌarõ weecã, tojo tʉꞌoñaꞌcãꞌña. Aꞌmeticãꞌña. Tojo weronojõ oꞌogʉ, mʉꞌʉrẽ niꞌcã peꞌe pãꞌrẽ diapoapʉ paacã, ape pãꞌrẽ dʉꞌsari pãꞌrẽ peꞌere majãminʉꞌcã, paadutiya tja. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Niꞌcʉ̃ beseri masã tiropʉ mʉꞌʉrẽ weresãꞌcʉ mʉꞌʉ ya camisare sẽrĩbosami. Cʉ̃ tojo weecã, buꞌicjãrõ mʉꞌʉ sãñarõ quẽꞌrãrẽ tuweeoꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Surara mʉꞌʉrẽ niꞌcã kilómetro cʉ̃ yere miabosaya nicã, mʉꞌʉ peꞌe cʉ̃ ʉacã, pʉa kilómetro miabosaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Noꞌo mʉꞌʉrẽ apeyenojõ sẽrĩcã, oꞌoya. Apeyenojõ mʉꞌʉrẽ wasocã, ‘Wasoweꞌe’, niticãꞌña”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesú werenemocʉ niwĩ: “Apeye todʉporocjãrãrẽ níꞌque quẽꞌrãrẽ tʉꞌopã: ‘Mʉsã meꞌrãcjʉ̃rẽ maꞌiña. Mʉsãrẽ ĩꞌatuꞌtigʉ peꞌere aꞌpepũrĩña’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉꞌʉ peꞌe mʉsãrẽ weregʉti. Mʉsãrẽ ĩꞌatuꞌtirãrẽ maꞌiña. Mʉsãrẽ ñaꞌarõ ucũrãrẽ ‘Añurõ waꞌato’, niña. Mʉsãrẽ ñaꞌarõ weecã, ñaꞌarõ bujicãꞌmicã, na ye niatjere Õꞌacʉ̃rẽ sẽrĩbosaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tojo weerã marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ põꞌrã niꞌi nisere ĩꞌorãsaꞌa. Cʉ̃ añurã, ñaꞌarã tiropʉ mujĩpũrẽ boꞌreyucã weemi. Mejãrõta añurõ weerã́, ñaꞌarõ weerã́ tiropʉ aco pejacã weemi. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉsãrẽ mairã diaꞌcʉ̃rẽ maꞌírã, ¿ñeꞌenojõrẽ mʉsã Õꞌacʉ̃ oꞌoatjere bocabosaʉ? Niyeru wapaseeri masã quẽꞌrã tojota weema. Na ñaꞌarã nimirã, na meꞌrãcjãrãrẽ maꞌisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉsã acawererã diaꞌcʉ̃rẽ añudutirã, ¿ñeꞌenojõrẽ añuse weerã weebosaʉ? Õꞌacʉ̃rẽ ẽjõpeotirã quẽꞌrã tojota na acawererã diaꞌcʉ̃rẽ añudutisama. Tojo weerã nipeꞌtirãrẽ aꞌmerĩ maꞌi, añudutiya. ");
INSERT INTO tuoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ ñaꞌase moogʉ̃ nimi. Mʉsã quẽꞌrã cʉ̃ weronojõ ñaꞌase moorã ninuꞌcũcãꞌña”, ni werecʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesú aꞌtiro werenemocʉ niwĩ: “Mʉsã weesere ãpẽrãrẽ ĩꞌadutirã, na ĩꞌorõpʉ diaꞌcʉ̃ añurõ weeticãꞌña. Mʉsã tojo weecãma, marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ ne cãꞌrõ añusere mʉsãrẽ oꞌosome. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tojo weerã mʉsã pajasecʉorãrẽ weetamurã, nipeꞌtirãrẽ werestepeꞌoticãꞌña. Weetaꞌsari masã na nerẽwʉasepʉ, tojo nicã macã decopʉ na weeꞌquere werestepeꞌocãꞌma. Masãrẽ añurõ ucũdutirã tojo weesama. Mʉsã na weronojõ weeticãꞌña. Diacjʉ̃ mʉsãrẽ weregʉti. Narẽ masã añurõ ucũse meꞌrã wapataꞌatojama. Tojo weerã na beꞌropʉre bocasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉsã peꞌe pajasecʉorãrẽ apeyenojõ oꞌorã, noꞌo mʉꞌʉ meꞌrãcjʉ̃ ĩꞌatiri cura oꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yaꞌyioro ãpẽrã na masĩtiro oꞌoya. Tojo weecã, marĩ pacʉ nipeꞌtise marĩ yaꞌyioro weesere ĩꞌapeꞌogʉ, mʉsãrẽ añusere oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Mʉsã ñubuerã, weetaꞌsari masã weronojõ weeticãꞌña. Na nerẽwʉase wiꞌseripʉ, tojo nicã masã pãjãrã yʉꞌrʉaropʉ nuꞌcũ, masã ĩꞌato nírã ñubuesama. Mʉsãrẽ diacjʉ̃ weregʉti. Na ãpẽrã ĩꞌase meꞌrã wapataꞌatojama. Beꞌropʉre bocasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉsã yʉꞌʉre ẽjõpeorã, mʉsã ya tucũpʉ sãjãa, sopere biꞌa, mʉsã pacʉ Õꞌacʉ̃ mʉsã meꞌrã nigʉ̃rẽ sẽrĩ, ñubueya. Tojo weecã, marĩ pacʉ noꞌo bajutiropʉ weesere ĩꞌapeꞌogʉ, mʉsãrẽ añusere oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Õꞌacʉ̃rẽ ñubuerã wãcũtimirã, pejetiri mejãrõta ñubuemʉjãticãꞌña. Õꞌacʉ̃rẽ masĩtirã, ʉ̃sãrẽ peje ucũse meꞌrã tʉꞌogʉsami nírã, tojo weesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mʉsã na weronojõ weeticãꞌña. Marĩ pacʉ mʉsã ʉasenojõrẽ sẽrĩatji dʉporo masĩtojasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tojo weerã mʉsã aꞌtiro ñubueya: ”‘Pacʉ, mʉꞌʉ ʉꞌmʉsepʉ niꞌi. Nipeꞌtirã mʉꞌʉrẽ wiopesase meꞌrã ẽjõpeoato. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aꞌti turipʉre mʉꞌʉ beseꞌcʉ maata wiogʉ sãjãgʉ̃ aꞌtiato. Ʉꞌmʉsepʉre mʉꞌʉ ʉaro diaꞌcʉ̃ weesama. Aꞌti turicjãrã quẽꞌrã mejãrõta weeato. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉ̃sãrẽ ʉmʉcorinʉcʉ̃ baꞌase oꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ʉ̃sã ñaꞌarõ weeꞌquere acobojoya. Ʉ̃sã ãpẽrãrẽ acobojoꞌcaro weronojõta ʉ̃sã quẽꞌrãrẽ acobojoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ʉ̃sã ñaꞌarõ weesĩꞌrĩsere cãꞌmotaꞌaya. Tojo nicã ñaꞌagʉ̃ ʉ̃sãrẽ niquesãcã, cãꞌmotaꞌaya. Mʉꞌʉ niꞌcʉ̃ta dutimasĩꞌi. Tutuayʉꞌrʉgʉ niꞌi. Mʉꞌʉ niꞌcʉ̃rẽta masã ẽjõpeorãsama. Mʉꞌʉ ninuꞌcũcʉ̃saꞌa’, ni sẽrĩña Õꞌacʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”Ãpẽrã mʉsãrẽ ñaꞌarõ weeꞌquere acobojocã, marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ quẽꞌrã mʉsãrẽ acobojogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tojo weeticãma, marĩ pacʉ mʉsã ñaꞌarõ weeꞌquere acobojosome”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesú narẽ buꞌenemocʉ niwĩ: “Mʉsã beꞌti ñubuerã, weetaꞌsari masã weronojõ weeticãꞌña. Na ãpẽrãrẽ añurõ wãcũduti, beꞌtima nidutirã bʉjawetirã weronojõ weesoosama. Diacjʉ̃ mʉsãrẽ weregʉti. Na masã añurõ wãcũse diaꞌcʉ̃rẽ wapataꞌatojasama. Beꞌropʉre bocasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉsã peꞌe beꞌti ñubuerã, mʉsã weewʉaronojõta weeya. Diapoa waacoe, wʉjapoameꞌrĩcãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tojo weecã, ãpẽrã mʉsã beꞌtisere masĩsome. Marĩ pacʉ diaꞌcʉ̃ marĩ yaꞌyioro weesere ĩꞌapeꞌogʉ masĩgʉ̃sami. Cʉ̃ mʉsãrẽ añusere oꞌogʉsami”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesú buꞌenemocʉ niwĩ: “Apeyenojõ aꞌti turi cjasere peje seeneocũuticãꞌña. Te butiwiji, boadija waꞌasaꞌa. Tere ãpẽrãnojõ baꞌabajuriodijocãꞌsama. Mʉsã neocũusere yajari masʉ̃ sãjãa, yajapeꞌocʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tojo weronojõ oꞌorã, ʉꞌmʉse cjase peꞌere seeneocũuyuya. Õꞌacʉ̃ ʉaronojõ weenuꞌcũcãꞌña. Tojo weerã topʉre peje añuse cʉorãsaꞌa. Topʉre mʉsã seeneocũuꞌque mʉsã cʉoatje ne butiwijisome. Ãpẽrãnojõ ne baꞌatirãsama. Yajari masã quẽꞌrã Õꞌacʉ̃ tiropʉ sãjãa, yajasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Marĩ ʉpʉtʉ maꞌisere wãcũnʉrʉ̃saꞌa. Tojo weerã aꞌti turi cjase diaꞌcʉ̃rẽ wãcũnʉrʉ̃ticãꞌña. Õꞌacʉ̃ ye peꞌere wãcũnʉrʉ̃ña”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesú aꞌtiro werenemocʉ niwĩ: “Marĩ caperi sĩꞌomʉꞌtãcja weronojõ niꞌi. Marĩ caperi añucã, añurõ ĩꞌamasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Marĩ caperi ĩꞌaejaticãma, añurõ ĩꞌatisaꞌa. Aꞌte weronojõ mʉsã Õꞌacʉ̃rẽ ẽjõpeo, cʉ̃ yere weecã, caperi añurõ weronojõ niꞌi. Mʉsã aꞌti turi cjase peꞌere wãcũnʉrʉ̃cãma, caperi ĩꞌaejatirã weronojõ niꞌi. Õꞌacʉ̃ ʉaronojõ weetirã, naꞌitĩꞌarõpʉ nirã́, cʉ̃rẽ masĩtirã weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Niꞌcʉ̃ ãpẽrãrẽ daꞌracoꞌtegʉ pʉarã dutisere weemasĩtisami. Niꞌcʉ̃rẽ maꞌígʉ̃, apĩrẽ maꞌitisami. Tojo nicã niꞌcʉ̃ dutisere yʉꞌtigʉ, apĩ dutise peꞌere yʉꞌtitisami. Ãꞌrã weronojõ niyeru, aꞌti nucũcã cjasere maꞌírã, Õꞌacʉ̃ peꞌere maꞌimasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Mʉsãrẽ aꞌtiro weregʉti: ‘¿Ñeꞌenojõ baꞌarãsari? ¿Ñeꞌenojõ sĩꞌrĩrãsari? ¿Ñeꞌenojõ sãñarãsari?’ ni wãcũqueꞌtiticãꞌña. Marĩ catise baꞌase nemorõ wapatiꞌi. Marĩ upʉ quẽꞌrã suꞌti nemorõ wapatiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mirĩcʉ̃arẽ wãcũña. Na baꞌasĩꞌrĩrã, otese capere ote, pĩꞌrĩ dʉcaticã weetisama. Te dʉcatiꞌquere baꞌase nʉrõse wiꞌseripʉ nʉrõtisama. Tojo weetimirã, ʉjaboatisama. Marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ narẽ baꞌase oꞌosami. Mʉsã peꞌere mirĩcʉ̃a nemorõ maꞌiyʉꞌrʉnʉꞌcãsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Noꞌo mʉsã ʉpʉtʉ wãcũqueꞌtirã, pajicurero bʉcʉanemotisaꞌa. Mejõ waro wãcũqueꞌtimaꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”¿Deꞌro weerã mʉsã sãñatje suꞌtire wãcũqueꞌtiti? Oꞌori, nʉcʉ̃ cjasere wãcũña. Te noꞌo ʉaro pĩꞌrĩbajaqueꞌatisaꞌa. Daꞌrati, suꞌatimirõ, suꞌti añurõ sãñarõ weronojõ bajuꞌu. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Marĩ ñecʉ̃ wiogʉ Salomó añuse suꞌti sãñacʉ niwĩ. Cʉ̃ tojo sãñamigʉ̃, oꞌorire niꞌcãrõwijiticʉ niwĩ. Te oꞌori añubutiase niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Niꞌcã nʉmʉ catíniꞌi, ape nʉmʉ ñaidija waꞌasaꞌa. Beꞌro pecameꞌepʉ ʉ̃jʉ̃acõꞌanoꞌsaꞌa. Yoaticã catimicã, Õꞌacʉ̃ta oꞌorire tojo añurõ bajumeꞌrĩcã weesami. Cʉ̃ oꞌorire añurõ coꞌtero nemorõ mʉsã peꞌere weesami. Mʉsã, mʉsã ẽjõpeotise buꞌiri wãcũqueꞌtiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tojo weerã ‘¿Ñeꞌenojõrẽ baꞌarãsari? ¿Ñeꞌenojõrẽ sĩꞌrĩrãsari? ¿Ñeꞌenojõrẽ sãñarãsari?’ ni wãcũqueꞌtiticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aꞌti turicjãrã Õꞌacʉ̃rẽ ẽjõpeotirã tere wãcũqueꞌtisama. Marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ mʉsã ʉasenojõrẽ masĩtojasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tojo weerã Õꞌacʉ̃ yere wãcũyʉꞌrʉnʉꞌcãña. Tojo nicã cʉ̃ dutisere weesirutuya. Tojo weecã, nipeꞌtise mʉsãrẽ dʉꞌsasenojõrẽ oꞌobuꞌipeogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tojo weerã ‘¿Ñamiacã deꞌro waꞌarosari?’ ni wãcũqueꞌtiticãꞌña. Niꞌcãcãrẽ mʉsã ñaꞌarõ yʉꞌrʉatje nitojaꞌa. Tojo weerã niꞌcãcã cjase diaꞌcʉ̃rẽ wãcũña. Ape nʉmʉ cjasere wãcũqueꞌtiticãꞌña. Ʉmʉcorinʉcʉ̃ Õꞌacʉ̃ mʉsãrẽ weetamugʉ̃sami”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesú ninemocʉ niwĩ: “Mʉsã ãpẽrãrẽ ‘Na ñaꞌarã nima’, ni beseweeticãꞌña. Tojo weecã, Õꞌacʉ̃ quẽꞌrã mʉsãrẽ besesome. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mʉsã ãpẽrãrẽ beseꞌcaronojõta, tojo nicã mʉsã beseꞌcaro ejatuaro Õꞌacʉ̃ mʉsã quẽꞌrãrẽ besegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mʉsã basu ñaꞌarã nimirã, ¿deꞌro weerã ãpẽrã peꞌere ‘Ñaꞌarã nima’, niti? Ãpẽrãrẽ ‘Mʉsã ñaꞌarã niꞌi’ nise dʉporo mʉsã ye peꞌere ĩꞌamʉꞌtãña. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mʉsã aꞌte weronojõ nibosaꞌa. Mʉsã acaweregʉre ‘Mʉꞌʉ ya capeapʉ cãꞌpoꞌcaroacã niꞌi’, nibosaꞌa. Mʉsã ya capeapʉ pajiri poꞌcaro peꞌere ĩꞌamʉꞌtãtimirã, tojo nibosaꞌa. Mʉsã basu mʉsã ya capeapʉ pajiri poꞌcaro cʉomirã, mʉsã acaweregʉ cãꞌrõacã cʉogʉ peꞌere ‘Mʉꞌʉ ya capeapʉ nisere miicõꞌarãti’, ¿niti? ");
INSERT INTO tuoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mʉsã tojo wéérã, weetaꞌsari masã niꞌi. Mʉsã ye caperipʉ nise peꞌere miicõꞌamʉꞌtãña yujupʉ. Tojo wééca beꞌro mʉsã acaweregʉ cãꞌrõacã caperipʉ nise peꞌere miicõꞌamasĩrãsaꞌa”, ni queose oꞌocʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Apeye ninemocʉ niwĩ tja: “Õꞌacʉ̃rẽ yabi bujicãꞌrãrẽ cʉ̃ ye queti añusere wereticãꞌña. Narẽ wererã, diayiare añusere oꞌorã weronojõ weebosaꞌa. Diayia uamarã añuse oꞌomicã, majãmiĩꞌa, cũꞌrĩsama. Mejãrõta Õꞌacʉ̃rẽ ẽjõpeosĩꞌrĩtirãrẽ añuse cʉ̃ ye cjasere wereticãꞌña. Narẽ wererã, yeseare ñaquẽ wapabʉjʉri dare doqueoꞌorã weronojõ weebosaꞌa. Yesea ti dare ʉꞌtacũu, te perire noꞌo ʉaro weestecusiasama. Na weronojõ nirãrẽ mejõ waro Õꞌacʉ̃rẽ yabi bujicãꞌrãrẽ añuse cʉ̃ ye cjasere werebosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”Õꞌacʉ̃rẽ sẽrĩña. Cʉ̃rẽ sẽrĩcã, oꞌogʉsami. Mʉsã sẽrĩ aꞌmanuꞌcũrã, bocarãsaꞌa. Mʉsã meꞌrãcjʉ̃ ya wiꞌire sope pʉꞌto pisunuꞌcũcã, cʉ̃ mʉsãrẽ pãosõrõrõ weronojõ weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Õꞌacʉ̃ cʉ̃rẽ sẽrĩrãrẽ oꞌosami. Noꞌo aꞌmagʉ̃nojõ bocagʉsami. Sope pʉꞌto pisugʉ weronojõ sẽrĩnuꞌcũgʉ̃rẽ oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”Mʉsã põꞌrã baꞌase sẽrĩcã, ne niꞌcʉ̃ narẽ ʉ̃tãpere oꞌotibosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na waꞌi sẽrĩcã quẽꞌrãrẽ, añarẽ oꞌotibosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉsã ñaꞌarã nimirã, mʉsã põꞌrãrẽ añusere oꞌomasĩꞌi. To pũrĩcãrẽ marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ cʉ̃rẽ sẽrĩrãrẽ nemorõ añusere oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Mʉsãrẽ ãpẽrã añurõ weemeꞌrĩcã ʉasaꞌa. Mʉsã quẽꞌrã tojota narẽ añurõ weemeꞌrĩcãꞌña. Moisé dutiꞌque, tojo nicã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masã ojaꞌque tojo weedutiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Mʉsã eꞌsatiri sopepʉ, eꞌsatiri maꞌapʉ sãjãaña. Pecameꞌepʉ waꞌatjo peꞌe eꞌsari sope, tojo nicã maꞌa quẽꞌrã eꞌsari maꞌajo niꞌi. Pãjãrã ti maꞌapʉre waꞌama. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ʉꞌmʉsepʉ waꞌari sope peꞌe, maꞌa eꞌsatiri maꞌacã niꞌi. Pejetirãcã ti maꞌapʉre waꞌasama. Yʉꞌʉre ẽjõpeorã cãꞌsopeacãpʉ, cãꞌmaꞌacãpʉ sãjãarã weronojõ nima. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Ãpẽrã ‘Ʉ̃sã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masã niꞌi’, nisoosama. Marĩ ĩꞌacã, na añurã bajumima. Oveja uatirã weronojõ bajuma. Na tojo bajumirã, na wãcũsepʉre yaiwa uamarã weronojõ mʉsã ẽjõpeosere dojorẽsĩꞌrĩsama. Narẽ tojo weeri nírã, añurõ ĩꞌanʉrʉ̃ña. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mʉsã narẽ na weese meꞌrã ĩꞌamasĩrãsaꞌa. Potagʉ ʉꞌse dʉcatiweꞌe. Wĩsõ quẽꞌrã ne ojo dʉcatiweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tojo weero añucjʉ yucʉgʉ añuse diaꞌcʉ̃ dʉcatiꞌi. Ñaꞌacjʉ quẽꞌrã ñaꞌasere dʉcatiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ne niꞌcãgʉ̃ yucʉgʉ añuse dʉcaticjʉ ñaꞌase dʉcatitisaꞌa. Ñaꞌase dʉcaticjʉ quẽꞌrã añuse dʉcatitisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Añuse dʉca marĩcjʉre paadijo, ʉ̃jʉ̃acõꞌacãꞌnoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tojo weerã mʉsã nisoori masãrẽ na weese meꞌrã ĩꞌamasĩrãsaꞌa”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesú narẽ werenemocʉ niwĩ: “Nipeꞌtirãpʉta noꞌo yʉꞌʉre ‘Wiogʉ’ niwʉarãnojõ ʉꞌmʉse yʉꞌʉ nirõpʉre sãjãasome. Yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ cʉ̃ ʉaro weerã́ diaꞌcʉ̃ sãjã́árãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yʉꞌʉ añurã, ñaꞌarãrẽ beseatji nʉmʉ nicã, pãjãrã yʉꞌʉre aꞌtiro nirãsama: ‘Ʉ̃sã wiogʉ, mʉꞌʉ ye cjase masãrẽ buꞌewʉ, mʉꞌʉ wãme meꞌrã wãtĩarẽ cõꞌawĩrõwʉ̃. Tojo nicã mʉꞌʉ wãme meꞌrãta peje añuse weeĩꞌowʉ̃’, nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na tojo nimicã, ‘Mʉsãrẽ ne masĩticãti. Mʉsã ñaꞌarõ weeꞌcãrã niꞌi. Waꞌarãsaꞌa’, nigʉ̃saꞌa narẽ”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesú masãrẽ aꞌtiro werecʉ niwĩ: “Yʉꞌʉ ucũsere tʉꞌóca beꞌro yʉꞌʉ dutisere weegʉnojõ tʉꞌomasĩgʉ̃, wiꞌi yeeꞌcʉ weronojõ nisami. Cʉ̃ ʉ̃ꞌcʉ̃arõpʉ seꞌesãjã, ʉ̃tãpʉ tutuari wiꞌi yeemʉjãtiꞌcʉ weronojõ nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Beꞌro acoro pejaa, dia puꞌeejasaꞌa. Ti wiꞌi wĩꞌrõ wẽecã, ʉ̃tãgã buꞌipʉ wééca wiꞌi niyuro, ne seꞌtedijatisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Apĩ peꞌe yʉꞌʉ ucũsere tʉꞌomigʉ̃, yʉꞌʉ dutisere weetisami. Cʉ̃ tʉꞌomasĩtigʉ, nucũporo õjẽrõpʉ wiꞌi weeꞌcʉ weronojõ nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Beꞌro acoro pejaa, dia puꞌeejasaꞌa. Ti wiꞌi ʉpʉtʉ wĩꞌrõ wẽecã, nucũporopʉ wééca wiꞌi niyuro, maata wẽecõꞌapeꞌocãꞌnoꞌsaꞌa. Ñaꞌabutiaro waꞌasaꞌa ti wiꞌi”, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Beꞌro Jesú buꞌetuꞌajaca beꞌro masã cʉ̃ buꞌesere ĩꞌamarĩarã, “Buꞌemeꞌrĩyʉꞌrʉami”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Cʉ̃ Moisé ojaꞌquere buꞌeri masã weronojõ buꞌeticʉ niwĩ. Dutisere cʉogʉ weronojõ narẽ buꞌecʉ niwĩ. Tojo weerã ĩꞌamarĩacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesú ʉ̃rʉ̃gʉ̃pʉ níꞌcʉ dijaticã, pãjãrã masã cʉ̃rẽ sirutucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Cʉ̃ maꞌapʉ waꞌari cura niꞌcʉ̃ cãmi boagʉ Jesú tiropʉ waꞌacʉ niwĩ. Cʉ̃ tiro ejagʉ, ejaqueꞌa, aꞌtiro nicʉ niwĩ: —Wiogʉ, mʉꞌʉ dutire yʉꞌrʉogʉ niꞌi. Yʉꞌʉre yʉꞌrʉoya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú cʉ̃rẽ ñapeo, nicʉ niwĩ: —Jaʉ. Mʉꞌʉrẽ yʉꞌrʉogʉti. Cãmi marĩgʉ̃ tojayá, nicʉ niwĩ. Cʉ̃ tojo nicãta, cʉ̃ cãmi boase yatipeꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tojo waꞌáca beꞌro Jesú cʉ̃rẽ nicʉ niwĩ: —Ne ãpẽrãrẽ wereticãꞌña. Diacjʉ̃ta paꞌi tiropʉ mʉꞌʉ ye cãmi yatiꞌquere ĩꞌogʉ̃ waꞌaya. Cʉ̃ mʉꞌʉrẽ “Mʉꞌʉ cãmi boasere peꞌtia waꞌaꞌa”, nigʉ̃sami. Cʉ̃ tojo níca beꞌro Moisé cʉ̃ Õꞌacʉ̃rẽ eꞌcatise oꞌodutiꞌquere oꞌoya. Mʉꞌʉ tojo wee yʉꞌrʉ́ca beꞌro masã meꞌrã nisetigʉsaꞌa tja, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Beꞌro Jesú Capernaupʉ ejacʉ niwĩ. Topʉ niꞌcʉ̃ wiogʉ romano masʉ̃ Jesú pʉꞌto aꞌticʉ niwĩ. Cʉ̃rẽ weetamuse sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Wiogʉ, yʉꞌʉre daꞌracoꞌtegʉ pũrõ dutitigʉ, ya wiꞌipʉ cũñami. Cʉ̃ sijamasĩtiami. Ʉpʉtʉ waro pũrĩnoꞌami, ni werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú nicʉ niwĩ: —Jaʉ. Cʉ̃rẽ yʉꞌrʉogʉ waꞌagʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Surara wiogʉ cʉ̃rẽ yʉꞌticʉ niwĩ: —Wiogʉ, ya wiꞌipʉ mʉꞌʉrẽ sãjãcã weemasĩtisaꞌa. Yʉꞌʉ mejõ nigʉ̃ niꞌi. Mʉꞌʉ waꞌatimigʉ̃, mʉꞌʉ dutioꞌose meꞌrã yʉꞌʉre daꞌracoꞌtegʉ yʉꞌrʉgʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yʉꞌʉ ãpẽrã surara docapʉ niꞌi. Na dutisere weeꞌe. Yʉꞌʉ quẽꞌrã ãpẽrã surarare dutituriaꞌa. Yʉꞌʉ docacjʉ̃rẽ “Waꞌaya” nicã, cʉ̃ waꞌasami. Apĩrẽ “Aꞌtia” nicã, aꞌtisami. Yʉꞌʉre daꞌracoꞌtegʉre “Aꞌtiro weeya” nicã, yʉꞌʉ dutiꞌquere weesami. Tojo weegʉ mʉꞌʉ yʉꞌʉre daꞌracoꞌtegʉre yʉꞌrʉduticã, yʉꞌrʉgʉsami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesú surara tojo nisere tʉꞌogʉ, tʉꞌomarĩa waꞌacʉ niwĩ. Cʉ̃rẽ to siruturã peꞌere nicʉ niwĩ: —Ãꞌrĩ romano masʉ̃ yʉꞌʉre añurõ ẽjõpeomi. Diacjʉ̃ mʉsãrẽ wereꞌe. Ãꞌrĩ weronojõ ẽjõpeogʉ ne niꞌcʉ̃ Israe curuacjʉ̃rẽ bocaejaticãti. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉsãrẽ weregʉti. Pãjãrã judío masã nitirã ãꞌrĩ weronojõ yʉꞌʉre ẽjõpeorãsama. Na nipeꞌtirocjãrã judío masã nitimirã, Õꞌacʉ̃ wiogʉ nirõpʉre nirãsama. Na quẽꞌrã ʉꞌmʉsepʉre marĩ judío masã ñecʉ̃sʉmʉa Abrahã, Isaa, Jacob meꞌrã duji baꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ãpẽrã judío masã nimirã, ẽjõpeotise buꞌiri ʉꞌmʉsepʉre waꞌaboꞌcãrã waꞌasome. Naꞌitĩꞌarõ aperopʉ Õꞌacʉ̃ narẽ cõꞌabajuriogʉsami. Topʉ na pũrĩnoꞌrã, upicari cũꞌrĩdio, utirãsama, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tojo níca beꞌro surara wiogʉre nicʉ niwĩ: —Mʉꞌʉ ya wiꞌipʉ tojaagʉsaꞌa. Mʉꞌʉ ẽjõpeoꞌcaronojõta waꞌarosaꞌa, nicʉ niwĩ. Cʉ̃rẽ tojo nirĩ curata daꞌracoꞌtegʉ cʉ̃ dutire yʉꞌrʉcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Beꞌro Jesú Pedro ya wiꞌipʉ waꞌacʉ niwĩ. Ti wiꞌipʉ sãjãtagʉ, Pedro mañecõ ujaque ʉpʉtʉ dutitigo cũñagõrẽ bocaejacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tojo weegʉ co omocãrĩrẽ ñeꞌecʉ niwĩ. Cʉ̃ tojo weeri curata maata ujaque surua waꞌacaro niwʉ̃. Beꞌro co wãꞌcãnʉꞌcã, narẽ baꞌase etico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naꞌiqueꞌari cura masã pãjãrã wãtĩ sãjãnoꞌcãrãrẽ Jesú pʉꞌtopʉ miacãrã niwã. Cʉ̃ ucũse meꞌrã wãtĩa napʉre sãjãaꞌcãrãrẽ cõꞌawĩrõcʉ niwĩ. Tojo nicã nipeꞌtirã dutitirãrẽ yʉꞌrʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesú cʉ̃ tojo weecã, dʉporocjʉ̃pʉ Isaía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ ojaꞌcaronojõta waꞌacaro niwʉ̃. Aꞌtiro ni ojacʉ niwĩ: “Marĩ tutuatisere, marĩ dutire cʉ̃ miiwapasami”, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesú pãjãrã cʉ̃ sumutopʉ nerẽnʉꞌcãcã ĩꞌagʉ̃, cʉ̃ buꞌerãrẽ aꞌtiro nicʉ niwĩ: —Teꞌa ditara siaquijipʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cʉ̃ tojo nicã, niꞌcʉ̃ Moisé dutiꞌquere buꞌeri masʉ̃ Jesú pʉꞌto waꞌa, ucũcʉ niwĩ: —Masãrẽ buꞌegʉ, mʉꞌʉ noꞌo waꞌaro mʉꞌʉrẽ sirutusijagʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesú cʉ̃rẽ yʉꞌticʉ niwĩ: —Waꞌicʉrã cãrĩrĩ tuti cʉosama. Mirĩcʉ̃a quẽꞌrã na põꞌrãtiri suꞌtiro cʉosama. Yʉꞌʉ pũrĩcã Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ ne cãꞌrõ cãrĩpesaro, yaro diácjʉ̃rẽ mooꞌo, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Apĩ Jesure ẽjõpeogʉ cʉ̃rẽ aꞌtiro nicʉ niwĩ: —Wiogʉ, yʉꞌʉ quẽꞌrã mʉꞌʉrẽ sirutugʉti. Mejõ yʉꞌʉ pacʉ tiropʉ waꞌagʉti yujupʉ. Topʉ ni, beꞌro yʉꞌʉ pacʉ wẽ́rĩ́ca beꞌro yaatojagʉpʉ mʉꞌʉ meꞌrã waꞌagʉti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesú cʉ̃rẽ yʉꞌticʉ niwĩ: —Yʉꞌʉ meꞌrã waꞌasĩꞌrĩgʉ̃, niꞌcãrõacã yʉꞌʉre sirutuya. Yʉꞌʉre ẽjõpeotirã wẽrĩꞌcãrã weronojõ nima. Náta tja ãpẽrã wẽrĩꞌcãrãrẽ aꞌmerĩ yaato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Beꞌro Jesú yucʉsʉpʉ mʉjãsãjãcʉ niwĩ. Cʉ̃ buꞌerã cʉ̃rẽ baꞌpatiwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na ditarapʉ nirĩ cura ʉpʉtʉ wĩꞌrõ aꞌticaro niwʉ̃. Tojo weero na yucʉsʉre pacase pãꞌcõrĩ paaquesãamʉjãcaro niwʉ̃. Tojo waꞌari curare Jesú cãrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tojo weerã cʉ̃ buꞌerã cʉ̃ siropʉ sãñagʉ̃rẽ wãꞌcõrã bʉrʉacãrã niwã. Cʉ̃rẽ “Wiogʉ, ʉ̃sãrẽ yʉꞌrʉoya. Marĩ mirĩdijarã weeꞌe”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Cʉ̃ wãꞌcã, narẽ yʉꞌticʉ niwĩ: —¿Deꞌro weerã tocãꞌrõ uiti? Mʉsã yʉꞌʉre cãꞌrõacã waro ẽjõpeose cʉoꞌo, nicʉ niwĩ. Tojo nitoja, wãꞌcãnʉꞌcã, wĩꞌrõrẽ, pãꞌcõrĩrẽ diꞌtamarĩacã weecʉ niwĩ. Nipeꞌtise diꞌtamarĩdijapeꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tojo waꞌacã ĩꞌarã, cʉ̃ buꞌerã ĩꞌamarĩarã, aꞌtiro nicãrã niwã: —¿Ñamʉnojõ masʉ̃ nimiticʉ̃ ãꞌrĩ? Wĩꞌrõ, pãꞌcõrĩpʉta cʉ̃rẽ tʉꞌomaatidojacãꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesú wĩꞌrõrẽ yʉsʉóca beꞌro ape pãꞌrẽpʉ pẽꞌajacãrã niwã. To Gadara wãmetiropʉ nicaro niwʉ̃. Topʉ pʉarã ʉmʉa wãtĩa sãjãnoꞌcãrã masãperi waꞌteropʉ níꞌcãrã Jesú tiro aꞌticãrã niwã. Na uarã waro niyucã, ne niꞌcʉ̃ ti maꞌapʉre yʉꞌrʉaticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na Jesure ĩꞌarã, caricũcãrã niwã: —Jesú, Õꞌacʉ̃ macʉ̃, ¿deꞌro weegʉ ʉ̃sãrẽ caribogʉ aꞌtiti? ¿Õꞌacʉ̃ cʉ̃ buꞌiri daꞌreatje dʉporo ʉ̃sãrẽ buꞌiri daꞌreyugʉ aꞌtiati? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na yʉꞌrʉro pãjãrã yesea to aubaꞌa nuꞌcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wãtĩa narẽ ĩꞌarã, Jesure nicãrã niwã: —Mʉꞌʉ ʉ̃sãrẽ cõꞌawĩrõgʉ̃, sõjã yeseapʉre sãjãaduticureya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesú “Tojota waꞌato”, nicʉ niwĩ. Cʉ̃ tojo nicãta, na masãpʉre nimiꞌcãrã yeseapʉre sãjãacãrã niwã. Yesea na wãtĩa sãjã́ca beꞌro opa tʉꞌrʉpʉ níꞌcãrã omamaati, ditarapʉ doqueñojã waꞌacãrã niwã. Topʉ mirĩboapeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yesea coꞌterã tojo waꞌacã ĩꞌarã, ʉpʉtʉ ʉcʉarã, macãpʉ omatojaacãrã niwã. Topʉ ejarã, nipeꞌtise wãtĩa sãjãnoꞌcãrãrẽ waꞌaꞌquere werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tere tʉꞌorã, macãcjãrã nipeꞌtirã Jesú tiropʉ waꞌacãrã niwã. Cʉ̃rẽ ĩꞌarã, aꞌtiro nicãrã niwã: —Aꞌtore wijawãꞌcãña. Apesepʉ waꞌaya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesú wãtĩarẽ cõꞌawĩrõca beꞌro yucʉsʉpʉ mʉjãsãjã, cʉ̃ ya macãpʉ majãmipẽꞌacʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Topʉ ãpẽrã niꞌcʉ̃ sijamasĩtigʉre Jesú tiropʉ cʉ̃ pesaro meꞌrã wʉawãꞌcãcãrã niwã. Na “Jesú ʉ̃sã meꞌrãcjʉ̃rẽ yʉꞌrʉogʉsami”, nicãrã niwã. Na ẽjõpeocã ĩꞌagʉ̃, Jesú sijamasĩtigʉre aꞌtiro nicʉ niwĩ: —Wãcũtutuaya. Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Cʉ̃ tojo nirĩ curare Moisé dutiꞌquere buꞌeri masã topʉ nicãrã niwã. Na aꞌtiro wãcũcãrã niwã: “Ãꞌrĩ cʉ̃ tojo ucũse meꞌrã Õꞌacʉ̃rẽ ñaꞌarõ ucũgʉ̃ weemi. Cʉ̃ ‘Õꞌacʉ̃ weronojõ tutuagʉ niꞌi’, ¿ni wãcũsari? Ãꞌrĩ marĩ weronojõ upʉtigʉ masã ñaꞌarõ weeꞌquere acobojomasĩtisami”, ni wãcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesú na tojo wãcũsere masĩgʉ̃, narẽ nicʉ niwĩ: —¿Deꞌro weerã mʉsã yʉꞌʉre ñaꞌarõ wãcũti? ");
INSERT INTO tuoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Deꞌro nise peꞌe diasatibutiati? ¿“Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa” o “Wãꞌcãnʉꞌcã, sijawãꞌcãña” nise peꞌe diasaweti? “Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa” nicã ĩꞌatimirã, ẽjõpeoya marĩꞌi. “Wãꞌcãnʉꞌcã, sijawãꞌcãña” nicã peꞌema, cʉ̃ sijasere ĩꞌatojarãpʉ “Diacjʉ̃ta niꞌi”, ni ẽjõpeoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tojo weegʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ yʉꞌʉ tutuasere ĩꞌogʉ̃, ãꞌrĩ sijamasĩtigʉre yʉꞌrʉogʉti. Te meꞌrã mʉsã yʉꞌʉ masã ñaꞌarõ weeꞌquere acobojomasĩsere masĩrãsaꞌa, nicʉ niwĩ. Beꞌro sijamasĩtigʉre aꞌtiro nicʉ niwĩ: —Wãꞌcãnʉꞌcãña. Mʉꞌʉ cũñaꞌcarore tuutũrẽ, miiwʉa tojaagʉsaꞌa mʉꞌʉ ya wiꞌipʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cʉ̃ tojo nicã, sijamasĩtigʉ wãꞌcãnʉꞌcã, cʉ̃ ya wiꞌipʉ tojaa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Masã cʉ̃ tojo waꞌasere ĩꞌarã, ʉpʉtʉ ʉcʉacãrã niwã. Tojo weerã Õꞌacʉ̃ ʉꞌmʉsepʉ nigʉ̃rẽ aꞌtiro nicãrã niwã: —Mʉꞌʉ tutuase masʉ̃pʉre oꞌoꞌque añuyʉꞌrʉaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesú sijamasĩtigʉre yʉꞌrʉóca beꞌro waꞌagʉ, yʉꞌʉre ĩꞌabocawĩ. Yʉꞌʉ romano masã wiogʉre niyeru wapaseebosari wiꞌipʉ daꞌragʉ dujiwʉ. Yʉꞌʉre ĩꞌagʉ̃, “Yʉꞌʉ meꞌrã aꞌtia”, niwĩ. Cʉ̃ tojo nicãta, cʉ̃ meꞌrã waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Beꞌro ya wiꞌipʉ cʉ̃ buꞌerã meꞌrã baꞌagʉ waꞌawĩ. Na baꞌari cura ãpẽrã quẽꞌrã pãjãrã niyeru wapaseeri masã, tojo nicã judío masã “Ñaꞌarõ weeri masã nima” ninoꞌrã quẽꞌrã baꞌarã ejawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseo masã tojo weecã ĩꞌarã, cʉ̃ buꞌerãrẽ sẽrĩtiñaꞌwã: —¿Deꞌro weegʉ mʉsãrẽ buꞌegʉ niyeru wapaseeri masã, ãpẽrã ñaꞌarõ weeri masã meꞌrã baꞌati? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na tojo nisere tʉꞌogʉ, Jesú aꞌtiro niwĩ: —Duti moorã ocoyedutirã duturure aꞌmatisama. Dutitirã pũrĩcã aꞌmasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Õꞌacʉ̃ ye queti ojáca pũrĩpʉ na ojaꞌquere buꞌerã waꞌaya. Õꞌacʉ̃ cʉ̃ ucũꞌquere aꞌtiro ojacãrã niwã: “ ‘Yʉꞌʉ ãpẽrãrẽ pajañaꞌdutiꞌi. Waꞌicʉrã ʉ̃jʉ̃amorõpeosere ʉaweꞌe’, nicʉ niwĩ Õꞌacʉ̃”, ni ojanoꞌwʉ̃. Yʉꞌʉ “Añurã niꞌi” nirãrẽ aꞌmagʉ̃ aꞌtitiwʉ. Ãpẽrã “Ʉ̃sã ñaꞌarã niꞌi” nirã́ peꞌere aꞌmagʉ̃ aꞌtiwʉ. Na ñaꞌarõ weeꞌquere bʉjaweti dʉcayudutigʉ aꞌtiwʉ, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Beꞌro Juã masãrẽ wãmeyeri masʉ̃ buꞌesere siruturi masã Jesú tiropʉ sẽrĩtiñaꞌrã etawã: —¿Deꞌro weerã ʉ̃sã weronojõ, tojo nicã fariseo masã weronojõ mʉꞌʉ buꞌerã peꞌe Õꞌacʉ̃rẽ ñubuerã, beꞌtiweti? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na tojo nicã, Jesú yʉꞌtiwĩ: —¿Deꞌro weeacjʉ omocã dʉꞌtegʉ na meꞌrã nígʉ̃, cʉ̃ pijioꞌcãrãrẽ bʉjaweti, beꞌtidutibosari? Beꞌro cʉ̃rẽ ãpẽrã aperopʉ miáca beꞌro pũrĩcãrẽ bʉjaweti, beꞌtirãsama. Jesú, yʉꞌʉ na meꞌrã niꞌi yujupʉ; yʉꞌʉ na meꞌrã niticã pũrĩcãrẽ, beꞌtirãsama nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Apeye queose meꞌrã narẽ ninemowĩ. Tojo nígʉ̃, maꞌma cʉ̃ buꞌese meꞌrã todʉporopʉ na weesetiꞌque aꞌmesʉꞌamasĩtisaꞌa, nigʉ̃ weewĩ. Aꞌtiro queose oꞌowĩ: —Mejã suꞌtiro maꞌma casero coeya marĩrĩ casero meꞌrã sereõꞌota basioweꞌe. Tojo weecãma, maꞌma casero coecã wejedʉꞌo, mejã suꞌtirore maata wejetʉ̃ꞌrẽsaꞌa. Nemorõ pajiri pe tʉ̃ꞌrʉ̃nemosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tojota waꞌasaꞌa maꞌma vino mejã ajuro waꞌicʉrã casero meꞌrã wééca ajuropʉ poseyecã. Pãꞌmʉyʉꞌrʉ, ti ajuro tʉ̃ꞌrʉ̃, vino piostepeꞌtia waꞌasaꞌa. Tojo waꞌacã, vino bajudutia waꞌasaꞌa. Ti ajuro quẽꞌrã cõꞌa waꞌasaꞌa. Tojo weero maꞌma vinorẽ maꞌma ajuropʉ poseyenoꞌo. Aꞌtiro weecã vino, tojo nicã ti ajuro queoro tojameꞌrĩcãꞌsaꞌa, niwĩ Jesú. Dʉporopʉ weesetiꞌque meꞌrã Jesú cʉ̃ niꞌcãrõacã maꞌma buꞌese morẽta basioweꞌe nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesú Juã wãmeyeri masʉ̃ buꞌerãrẽ ucũrĩ curare niꞌcʉ̃ judío masã nerẽrĩ wiꞌi wiogʉ etawĩ. Jesú pʉꞌto ejaqueꞌa, niwĩ: —Yʉꞌʉ macõ niꞌcãrõacã wẽrĩa waꞌamo. Tojo waꞌamicã, ya wiꞌipʉ waꞌa, core ñapeocã, masãgõsamo tja, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú cʉ̃ meꞌrã waꞌawĩ. Ʉ̃sã cʉ̃ buꞌerã quẽꞌrã baꞌpatiwãꞌcãwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Maꞌapʉ ʉ̃sã waꞌari cura niꞌcõ numio doce cʉ̃ꞌmarĩ dí mejãrẽ dutitigo aꞌtico niwõ. Co Jesú sẽꞌemapʉ aꞌti, cʉ̃ yaro suꞌtiro yapapʉ ñeꞌeñaꞌco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aꞌtiro wãcũco niwõ: “Yʉꞌʉ cʉ̃ ya suꞌtirore daꞌrañaꞌseacã meꞌrã yʉꞌrʉgosaꞌa”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Co ñeꞌeñaꞌcã tʉꞌoñaꞌgʉ̃, Jesú core majãmiĩꞌa, niwĩ: —Wãcũtutuaya. Mʉꞌʉ ẽjõpeotjĩagõ, yʉꞌrʉonoꞌcopʉ tojaꞌa, niwĩ. Cʉ̃ tojo nicãta, dí wijamiꞌque bʉꞌanʉꞌcã peꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Beꞌro Jesú wiogʉ ya wiꞌipʉ ejagʉ, na weewʉaronojõpʉma wẽrĩꞌcore yaari cura basapeorãrẽ bocaejawĩ. Tojo nicã masã quẽꞌrã ʉpʉtʉ uticã ĩꞌawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Cʉ̃ ti wiꞌi poꞌpeapʉ nirãrẽ “Wijaaya. Co wẽrĩtimo. Cãrĩgõ weemo”, niwĩ. Tere tʉꞌorã, masã cʉ̃rẽ bujicãꞌwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesú narẽ wijaadutiwĩ. Beꞌro wẽrĩꞌco pesari tucũpʉ sãjãa, co ya omocãpʉ ñeꞌecʉ niwĩ. Tojo weecã, co wãꞌcãnʉꞌcãco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Beꞌro nipeꞌtiro ti diꞌtapʉre Jesú core masõꞌque queti seꞌsa waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesú wiogʉ ya wiꞌipʉ níꞌcʉ wijaari cura pʉarã caperi ĩꞌatirã cʉ̃rẽ caricũsirutuwã. —Davi pãrãmi nituriagʉ, ʉ̃sãrẽ pajañaꞌcureya, ni caricũwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Beꞌro wiꞌipʉ sãjãcã, caperi ĩꞌatirã cʉ̃ pʉꞌtopʉ ejawã. Narẽ sẽrĩtiñaꞌwĩ: —¿Yʉꞌʉ mʉsãrẽ ĩꞌacã weemasĩsere ẽjõpeoti? niwĩ. —Ẽjõpeoꞌo, ni yʉꞌtiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na tojo nicã tʉꞌogʉ, Jesú na caperipʉ ñapeowĩ. —Mʉsã ẽjõpeoꞌcaronojõ queoro waꞌato, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tojo nicãta, na ĩꞌawã. Beꞌro “Yʉꞌʉ mʉsãrẽ tojo weesere ãpẽrãrẽ wereticãꞌña”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cʉ̃ tojo nimicã, na wijááca beꞌroacãta nipeꞌtiro ti diꞌtapʉ cʉ̃ narẽ yʉꞌrʉoꞌquere werestepeꞌocãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Caperi bajunoꞌtiꞌcãrã wijaari cura aꞌtiro waꞌawʉ. Ãpẽrã Jesú tiropʉ niꞌcʉ̃ ucũmasĩtigʉ wãtĩ sãjãnoꞌcʉre miiejawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesú cʉ̃rẽ ĩꞌagʉ̃, wãtĩ cʉ̃pʉre nigʉ̃rẽ cõꞌawĩrõwĩ. Tojo weecã, cʉ̃ ucũmasĩtiꞌcʉ ucũnʉꞌcãwĩ. Tocjãrã tere ʉpʉtʉ ĩꞌamarĩatjĩarã, aꞌtiro niwã: —Marĩ aꞌto Israe curuacjãrã tiropʉre tojo waꞌacã, ne niꞌcãti ĩꞌatirã nicãti, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo masã peꞌe aꞌtiro niwã: —Wãtĩa wiogʉ tutuaro meꞌrã ãꞌrĩ wãtĩarẽ cõꞌawĩrõsami, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesú nipeꞌtise macãrĩpʉ judío masã nerẽse wiꞌserinʉcʉ̃ buꞌecusiagʉ waꞌawĩ. Añuse queti Õꞌacʉ̃ masãrẽ yʉꞌrʉose quetire werewĩ. Tojo nicã Õꞌacʉ̃ wiogʉ nimi nise quetire weregʉ waꞌawĩ. Dutitirãrẽ deꞌro na pũrĩnoꞌsere yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masãrẽ ĩꞌagʉ̃, pũrõ pajañaꞌwĩ. Na bʉjawetirã, wãcũtutuatirã ovejare coꞌtegʉ moorã weronojõ niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tojo weegʉ Jesú ʉ̃sã cʉ̃ buꞌerãrẽ niwĩ: —Diacjʉ̃ta niꞌi. Marĩ otese peje pĩꞌrĩ dʉcatiꞌi. Tere miirã peꞌe marĩbocurema. ");
INSERT INTO tuoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tojo weerã te otese wiogʉre ãpẽrã miitamuajãrẽ sẽrĩnemoña, niwĩ Jesú. Aꞌte weronojõ Õꞌacʉ̃ ye quetire masĩsĩꞌrĩrã, pãjãrã waro nima. Mejõ te quetire wererã peꞌe pejetirãcã nima. Tojo weerã ãpẽrã cʉ̃ oꞌónemocã, Õꞌacʉ̃rẽ sẽrĩña, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesú masãrẽ buꞌéca beꞌro ʉ̃sã cʉ̃ buꞌerã docere besewĩ. Ʉ̃sãrẽ masãpʉ nirã́ wãtĩarẽ cõꞌawĩrõmasĩsere oꞌowĩ. Tojo nicã nipeꞌtise duti yʉꞌrʉomasĩsere oꞌowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ʉ̃sã cʉ̃ beseꞌcãrã doce aꞌtiro wãmetiwʉ. Ne waro Simó niwĩ. Apetero cʉ̃rẽta tja Pedro pisuwã. Beꞌro cʉ̃ acabiji André niwĩ. Cʉ̃ beꞌro Santiago, tojo nicã cʉ̃ acabiji Juã, na pʉarãpʉta Zebedeo põꞌrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Apĩ Felipe, apĩ Bartolomé, apĩ Tomás niwã. Yʉꞌʉ Mateo romano masã wiogʉre niyeru wapaseebosagʉ níꞌcʉ quẽꞌrã na meꞌrã niwʉ̃. Apĩ Santiago Alfeo macʉ̃ niwĩ. Tojo nicã Tadeo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Apĩ Simó celote curuacjʉ̃ niwĩ. Apĩ Juda Iscariote, beꞌropʉ Jesure ĩꞌatuꞌtirãpʉre oꞌoacjʉ quẽꞌrã niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Cʉ̃ beséca beꞌro ʉ̃sã docere aꞌtiro niwĩ: —Judío masã nitirã tiropʉ waꞌaticãꞌña. Tojo nicã Samaria diꞌtapʉ nise macãrĩpʉre waꞌaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israe curuacjãrã tiro peꞌe waꞌaya. Na Õꞌacʉ̃ cʉ̃ dutisere sirututirã, oveja na wiogʉre duꞌtiwija wisiꞌcãrã weronojõ nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Narẽ wererã waꞌaya. “Cãꞌrõacã beꞌro Õꞌacʉ̃ beseꞌcʉ wiogʉ sãjãgʉ̃sami”, niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dutitirãrẽ yʉꞌrʉoya. Wẽrĩꞌcãrãrẽ masõña. Cãmi boarãrẽ yʉꞌrʉoya. Wãtĩa sãjãnoꞌcãrãrẽ cõꞌawĩrõña. Yʉꞌʉ mʉsãrẽ weemasĩsere wapamarĩrõ oꞌoꞌo. Tojo weerã narẽ yʉꞌrʉorã, wapaseeticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","»Mʉsã waꞌarã, ne niyeru miaticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne ajuronojõ miaticãꞌña. Suꞌti, tojo nicã sapatu mʉsã sãñase meꞌrã diaꞌcʉ̃ waꞌaya. Tuacjʉ miaticãꞌña. Daꞌrari masã na daꞌrase wapa wapataꞌabaꞌamasĩma. Tojo weerã mʉsã buꞌerã waꞌacã, mʉsãrẽ baꞌase weetamurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","»Macãpʉ etarã, “Ãꞌrĩta añutʉꞌsami” mʉsã nigʉ̃́ tiro tojaqueꞌaya. Mʉsã to nirṍ ejatuaro cʉ̃ ya wiꞌipʉ niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cʉ̃ ya wiꞌipʉ sãjãarã, ti wiꞌicjãrãrẽ põtẽrĩ añudutiya. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉsãrẽ ñeꞌecã, “Mʉsãrẽ añurõ waꞌato”, niña. Mʉsãrẽ ñeꞌeticã, niticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉsãrẽ ñeꞌeti, mʉsã buꞌesere tʉꞌosĩꞌrĩticã, ti wiꞌipʉre wijaarã, o ti macãpʉre wijarã, ti macã cjase diꞌta mʉsãrẽ wãꞌaꞌquere paastecõꞌaña. Tojo weerã mʉsã aꞌti macãcjãrã buꞌiritima, ni ĩꞌorãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diacjʉ̃ mʉsãrẽ wereꞌe. Õꞌacʉ̃ masãrẽ beseatji nʉmʉ narẽ ʉpʉtʉ waro buꞌiri daꞌregʉsami. Todʉporopʉ Sodoma, Gomorra wãmetise macãrĩcjãrãrẽ buꞌiri daꞌreꞌcaro nemorõ narẽ buꞌiri daꞌregʉsami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cʉ̃ apaturi ninemowĩ: —Masĩña. Yʉꞌʉ mʉsãrẽ wioro waꞌteropʉ oꞌógʉ weeꞌe. Ovejare yaiwa waꞌteropʉ oꞌógʉ weronojõ oꞌóꞌo. Tojo weerã mʉsãrẽ ñaꞌarõ weeri nírã, pʉa capeatiya. Mʉsãrẽ ñaꞌarõ weemicã, añurõ weeya narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Añurõ ĩꞌaña. Mʉsãrẽ ñeꞌe, judío masã wiorã tiropʉ miarãsama. Na nerẽse wiꞌseripʉ mʉsãrẽ tãrãrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tojo nicã yʉꞌʉre ẽjõpeose buꞌiri to cjase diꞌta wiorã tiropʉ miarãsama. Narẽ yé quetire wereya. Tojo nicã ãpẽrã judío masã nitirãrẽ wererãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mʉsãrẽ miacã, mʉsã ucũatjere “¿Deꞌro waꞌarosaʉ? ¿Deꞌro nirãsari?” ni wãcũqueꞌtiticãꞌña. Mʉsã ucũrĩ cura Õꞌacʉ̃ mʉsã ucũatjere oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tojo weerã mʉsã basu mejẽta ucũrãsaꞌa. Espíritu Santu marĩ pacʉ oꞌóꞌcʉ mʉsãrẽ ucũdutisere ucũrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","»Masã yʉꞌʉre ẽjõpeocã ĩꞌarã, na acawererã warore wia, wẽjẽdutirãsama. Na põꞌrã quẽꞌrãrẽ tojota weerãsama. Põꞌrã quẽꞌrã na pacʉsʉmʉarẽ mejãrõta weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yé buꞌiri nipeꞌtirã mʉsãrẽ ĩꞌatuꞌtirãsama. Noꞌo yʉꞌʉre ẽjõpeoyapatigʉnojõ yʉꞌrʉgʉsami. Cʉ̃ yʉꞌʉ pacʉ tiropʉ catinuꞌcũcʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Niꞌcã macãpʉ mʉsãrẽ ñaꞌarõ weecã, ape macãpʉ duꞌtiya. Diacjʉ̃ta mʉsãrẽ wereꞌe. Nipeꞌtiro Israe curuacjãrã nise macãrĩpʉ mʉsã werecusiabiꞌati dʉporo yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ apaturi aꞌtigʉsaꞌa tja, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","»Ne niꞌcʉ̃ buꞌegʉ, cʉ̃rẽ buꞌegʉ yʉꞌrʉoro nímasĩtisami. Mejãrõta daꞌracoꞌtegʉ quẽꞌrã cʉ̃ wiogʉ yʉꞌrʉoro nímasĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Buꞌegʉ, cʉ̃rẽ buꞌegʉ weronojõ nigʉ̃ti, nirõʉaꞌa. Mejãrõta daꞌracoꞌtegʉ cʉ̃ wiogʉ weronojõ nigʉ̃ti, nirõʉaꞌa. Buꞌeri masʉ̃, wiogʉ, na ñaꞌarõ yʉꞌrʉcã, buꞌenoꞌgʉ̃, daꞌracoꞌtegʉ quẽꞌrã ñaꞌarõ yʉꞌrʉsama. Tojo weero yʉꞌʉ mʉsãrẽ buꞌegʉre “Beelzebú, wãtĩa wiogʉ nimi” nicã, ¿deꞌro weerã mʉsã yʉꞌʉ buꞌerãrẽ tojo nitibosabaʉ? niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesú aꞌtiro werenemowĩ: —Mʉsã yʉꞌʉ meꞌrã niꞌi. Tojo weerã mʉsãrẽ ʉatirãrẽ uiticãꞌña. Ne bajuyoropʉ weetise ĩꞌanoꞌticã weesome. Ĩꞌanoꞌrõsaꞌa. Ne ĩꞌatiropʉ weeꞌque quẽꞌrã masĩnoꞌticã weesome. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yʉꞌʉ mʉsãrẽ tʉꞌotiropʉ níꞌquere ãpẽrã tʉꞌoropʉ werestepeꞌocãꞌña. Masĩnoꞌña marĩꞌquere masãrẽ masĩcã weeya. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉsã upʉre wẽjẽcõꞌarãrẽ uiticãꞌña. Na upʉ diaꞌcʉ̃rẽ wẽjẽcõꞌamasĩsama. Õꞌacʉ̃ peꞌe upʉ, ejeripõꞌrãrẽ pecameꞌepʉ cõꞌabutiamasĩsami. Cʉ̃ tojo weegʉ́ pũrĩcãrẽ uiya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jesú queose meꞌrã cʉ̃ pacʉ marĩrẽ maꞌisere werenemowĩ: —Pʉarã mirĩcʉ̃a oꞌmajãrãcã cãꞌrõacã wapatisama. Na tojo wapatimicã, Õꞌacʉ̃ narẽ añurõ coꞌtesami. Ne niꞌcʉ̃ mirĩcʉ̃acã yucʉgʉpʉ pesagʉ marĩ pacʉ “Tocãꞌrõ wẽrĩgʉ̃sami” niticã, wẽrĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Apeyema tja Õꞌacʉ̃ marĩ poarire “Ticʉse niꞌi”, ni masĩpeꞌocãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mʉsã pãjãrã mirĩcʉ̃a yʉꞌrʉoro wapatisaꞌa. Tojo weerã mʉsãrẽ ñaꞌarõ weesĩꞌrĩrãrẽ uiticãꞌña. Õꞌacʉ̃ mʉsãrẽ añurõ coꞌtegʉsami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesú werenemowĩ: —Noꞌo masã tʉꞌoropʉ yʉꞌʉre “Ẽjõpeoꞌo” ni werecã, yʉꞌʉ quẽꞌrã narẽ yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃rẽ añurõ ucũgʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Niꞌcʉ̃ masãrẽ uigʉ, masã tʉꞌoropʉ yʉꞌʉre “Ẽjõpeoweꞌe” nigʉ̃rẽ yʉꞌʉ quẽꞌrã cʉ̃rẽ yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃rẽ “Yagʉ mejẽta nimi”, nigʉ̃saꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Apaturi werenemowĩ: —Mʉsã yʉꞌʉre “Añurõ nisetiatjere miitigʉ weepĩ”, ni wãcũticãꞌña. Yʉꞌʉ tere miititiwʉ. Yʉꞌʉ aꞌtise wapa aꞌpepũrĩato nígʉ̃ aꞌtiwʉ. Ãpẽrã yʉꞌʉre ʉatirã, yʉꞌʉre ʉarã meꞌrã aꞌmetuꞌtirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tojo weerã niꞌcʉ̃ cʉ̃ pacʉ meꞌrã aꞌmetuꞌtigʉsami. Apego quẽꞌrã co paco meꞌrã mejãrõta weegosamo. Tojo nicã macʉ̃ nʉmo co mañecõ meꞌrã aꞌmetuꞌtirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tojo weerã niꞌcã wiꞌicjãrã, yé buꞌiri aꞌmetuꞌtirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","»Yʉꞌʉre maꞌirõ nemorõ mʉsã pacʉsʉmʉa peꞌere maꞌiyʉꞌrʉnʉꞌcãrã, yarã nímasĩtisaꞌa. Tojo nicã pacʉsʉmʉa quẽꞌrã na põꞌrãrẽ maꞌiyʉꞌrʉnʉꞌcãrã, yarã nímasĩtisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apetero weegʉ niꞌcʉ̃ “Yʉꞌʉ Jesure ẽjõpeogʉ, wẽrĩbosaꞌa” ni uigʉ, yʉꞌʉre ẽjõpeoduꞌusami. Tojo weegʉnojõ yagʉ nímasĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yʉꞌʉre ẽjõpeose meꞌrã ñaꞌarõ yʉꞌrʉsĩꞌrĩtigʉ, yʉꞌʉre ẽjõpeoduꞌugʉnojõ pecameꞌepʉ buꞌiri daꞌre bajurionoꞌgʉ̃sami. Apĩ wẽjẽsere uiti, yʉꞌʉre ẽjõpeonuꞌcũgʉ̃nojõ peꞌe yʉꞌʉ meꞌrã catinuꞌcũgʉ̃sami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesú werenemowĩ: —Mʉsãrẽ eꞌcatise meꞌrã ñeꞌerã, yʉꞌʉre ñeꞌerãta weema. Yʉꞌʉre ñeꞌerã quẽꞌrã, yʉꞌʉ pacʉ yʉꞌʉre oꞌóꞌcʉre ñeꞌerãta weema. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Niꞌcʉ̃ Õꞌacʉ̃ weredutiꞌquere wereturiari masʉ̃rẽ cʉ̃ Õꞌacʉ̃ oꞌóꞌcʉ niyucã, ñeꞌegʉ̃rẽ aꞌtiro waꞌarosaꞌa. Õꞌacʉ̃ cʉ̃rẽ oꞌosenojõrẽta cʉ̃rẽ ñeꞌegʉ̃ quẽꞌrãrẽ oꞌogʉsami. Niꞌcʉ̃ masʉ̃ añugʉ̃rẽ ñeꞌegʉ̃, cʉ̃ añugʉ̃ niyucã, cʉ̃rẽ ñeꞌegʉ̃rẽ aꞌtiro waꞌarosaꞌa. Õꞌacʉ̃ masʉ̃ añugʉ̃rẽ oꞌoꞌcaronojõta cʉ̃rẽ ñeꞌegʉ̃ quẽꞌrãrẽ oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Niꞌcʉ̃ apĩrẽ Jesucristore ẽjõpeogʉ nimi nígʉ̃, acowʉogʉre acotĩagʉ̃ diacjʉ̃ta añuse bocagʉsami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesú ʉ̃sã docere wéréca beꞌro waꞌa waꞌawĩ. Galileapʉ nise macãrĩrẽ buꞌecusiagʉ waꞌawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juã masãrẽ wãmeyeri masʉ̃ buꞌiri daꞌreri wiꞌipʉ nicʉ niwĩ. Topʉ nígʉ̃, Jesú masã waꞌteropʉ weesere tʉꞌocʉ niwĩ. Tere tʉꞌogʉ, ãpẽrã cʉ̃ buꞌesere siruturãrẽ cʉ̃ tiropʉ waꞌaduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Aꞌtiro narẽ sẽrĩtiñaꞌduticʉ niwĩ: —“¿Mʉꞌʉta niti ‘Masãrẽ yʉꞌrʉoacjʉ aꞌtigʉsami’ ninoꞌcʉ, o apĩpʉre yucuerãsari yujupʉ?” ni sẽrĩtiñaꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesú tiro etarã, Juã sẽrĩtiñaꞌdutiꞌquere sẽrĩtiñaꞌwã. Na tojo nicã tʉꞌogʉ, Jesú narẽ yʉꞌtiwĩ: —Yʉꞌʉ weecã ĩꞌasere, mʉsã tʉꞌosere Juãrẽ wererã waꞌaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Caperi ĩꞌatimiꞌcãrã niꞌcãrõacãrẽ ĩꞌapãama. Sijamasĩtimiꞌcãrã sijama. Cãmi boarã yatipeꞌtianoꞌma. Oꞌmeperi tʉꞌotiꞌcãrã tʉꞌoma. Ãpẽrã wẽrĩꞌcãrã masãma. Pajasecʉorã añuse masãrẽ yʉꞌrʉose quetire tʉꞌoma. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yʉꞌʉre ẽjõpeoduꞌutigʉnojõ eꞌcatigʉsami”, ni wererã waꞌaya Juãrẽ, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na waꞌáca beꞌro Jesú Juã ye cjasere masãrẽ werenʉꞌcãwĩ: —Mʉsã masã marĩrõpʉ Juãrẽ ĩꞌarã waꞌapã. Topʉ waꞌarã, uigʉnojõrẽ, wãcũtutuatigʉre ĩꞌarã waꞌatipã. Cʉ̃ tutuatigʉ tábuti wĩꞌrõ wẽecʉaro weronojõ nitimi. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tojo nicã añuse waro suꞌti sãñagʉ̃rẽ masã marĩrõpʉ ĩꞌarã waꞌatipã. Suꞌti añuse sãñarãnojõ wiorã ye wiꞌseripʉ nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To pũrĩcãrẽ mʉsã niꞌcʉ̃ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃rẽ ĩꞌarã waꞌarã weepã. Nirõta Juã ãpẽrã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã nemorõ niyʉꞌrʉnʉꞌcãmi. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Õꞌacʉ̃ Juãrẽ oꞌóyuatjere cʉ̃ ye queti ojáca pũrĩpʉ aꞌtiro ojanoꞌwʉ̃: “Yʉꞌʉ mʉꞌʉ ye quetire wereyuacjʉre mʉꞌʉ dʉporo oꞌógʉti. Cʉ̃ mʉꞌʉ waꞌatji maꞌarẽ apoyugʉsami”, nicʉ niwĩ Õꞌacʉ̃, ni ojanoꞌcaro niwʉ̃. Maꞌa quẽꞌrã́yumʉꞌtãgʉ̃ weronojõ mʉꞌʉ waꞌati dʉporo masã wãcũsere bʉjaweti dʉcayudutigʉsami nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","»Diacjʉ̃ta mʉsãrẽ weregʉti. Todʉporopʉ, aꞌtiro nicã quẽꞌrãrẽ ne niꞌcʉ̃ Juã yʉꞌrʉoro nigʉ̃́ marĩmi. Tojo nimicã, nipeꞌtirã Õꞌacʉ̃ wiogʉ nirõpʉ nirã́ Juã yʉꞌrʉoro nima. Mejõ nigʉ̃pʉa cʉ̃ yʉꞌrʉoro nimi. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","»Juã buꞌenʉꞌcãcateropʉ, téé aꞌtocateropʉ quẽꞌrãrẽ Õꞌacʉ̃ wiogʉ nisere ʉatirã, cumuca weema. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nipeꞌtirã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masã na ojaꞌque meꞌrã, tojo nicã Moisé cʉ̃ dutise cũuꞌque meꞌrã Õꞌacʉ̃ wiogʉ nimi nisere werenuꞌcũcãrã niwã. Juã masãrẽ wãmeyeri masʉ̃pʉta weretʉocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mʉsã yʉꞌʉre ẽjõpeosĩꞌrĩcãma, aꞌtiro nigʉ̃ti. Dʉporocjʉ̃pʉ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ aꞌtiro nicʉ niwĩ: “Masãrẽ yʉꞌrʉoacjʉ aꞌtise dʉporo Elía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ weronojõ nigʉ̃́ aꞌtigʉsami”, ni ojanoꞌwʉ̃. Juã na tojo ojanoꞌcʉta nimi. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Oꞌmeperi cʉorãnojõ aꞌtere añurõ tʉꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","»Masã aꞌtocaterocjãrã, yé quetire tʉꞌosĩꞌrĩtirã ãꞌrã weronojõ nima. Wĩꞌmarã macã decopʉ apedujirã, na meꞌrãcjãrãrẽ pijirã caricũbajaqueꞌatirã weronojõ nima. Aꞌtiro caricũsama: ");
INSERT INTO tuoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ʉ̃sã wẽowʉ̃ putimicã, basarã wijatiapʉ. Ʉ̃sã bʉjawetise basacã quẽꞌrãrẽ, utitiapʉ.” Na weronojõ aꞌtocatero nirã́ noꞌo añurõ, ñaꞌarõ weecã, mejãrõta tʉꞌsatima. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juã masãrẽ wãmeyeri masʉ̃ beꞌti, vino sĩꞌrĩtisami. Cʉ̃ tojo weecã, mʉsã “Wãtĩ cʉomi”, nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Beꞌro yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ quẽꞌrãrẽ baꞌa, yʉꞌʉ vino sĩꞌrĩcã, mejãrõta ñaꞌarõ ucũꞌu. “Baꞌawãrĩgʉ̃, sĩꞌrĩwãrĩgʉ̃ nimi. Niyeru wapaseeri masã, tojo nicã ñaꞌarã meꞌrãcjʉ̃ nimi”, niꞌi yʉꞌʉre. Mʉsã niꞌcʉ̃pʉreta ẽjõpeoweꞌe. Tojo ẽjõpeotimirã, yʉꞌʉ weeĩꞌoꞌquere ĩꞌarã, “Õꞌacʉ̃ cʉ̃rẽ masĩse oꞌopĩ” ni, masĩbosaꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Beꞌro Jesú cʉ̃ tutuaro meꞌrã weeĩꞌoyʉꞌrʉnʉꞌcãꞌque macãrĩcjãrãrẽ aꞌtiro tuꞌtiwĩ. Na ñaꞌarõ weeꞌquere bʉjaweti dʉcayuticã, tojo weewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Mʉsã Corazĩ́, tojo nicã Betsaida wãmetise macãrĩcjãrãrẽ ñaꞌarõ waꞌarosaꞌa. Yʉꞌʉ weeĩꞌoꞌquere ĩꞌamirã, dʉcayuweꞌe. Yʉꞌʉ ãpẽrã judío masã nitirã tiropʉ Tiro, Sidṍ wãmetise macãrĩpʉ weeĩꞌocãma, dʉporopʉ na ñaꞌarõ weeꞌquere bʉjaweti dʉcayutojabopã. Na bʉjawetisere ĩꞌorã, na weewʉaronojõpʉma suꞌtire wãquĩsenojõrẽ sãña, nujãrẽ na dʉpoapʉ ṍrẽ́stepeobopã. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mʉsãrẽ wereꞌe. Õꞌacʉ̃ masãrẽ beseatji nʉmʉ nicã, mʉsã peꞌere Tiro, Sidṍcjãrã nemorõ buꞌiri daꞌreyʉꞌrʉnʉꞌcãgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","»Niꞌcãrõacãma Capernaucjãrãrẽ wereꞌe. “Tojowaro ʉꞌmʉsepʉ mʉjãrãti”, ni wãcũticãꞌña. Õꞌacʉ̃ mʉsãrẽ pecameꞌepʉ cõꞌabutiagʉsami. Sõꞌoníca macã Sodoma yʉꞌʉ mʉsã tiropʉ weeꞌcaronojõ weeĩꞌocãma, ti macã niꞌcãrõacãpʉ quẽꞌrãrẽ ninuꞌcũbosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mʉsãrẽ nigʉ̃ti. Õꞌacʉ̃ masãrẽ beseatji nʉmʉ nicã, Sodomacjãrãrẽ nemorõ mʉsã peꞌere Õꞌacʉ̃ buꞌiri daꞌregʉsami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Narẽ tojo níca beꞌro Jesú cʉ̃ pacʉ Õꞌacʉ̃rẽ aꞌtiro niwĩ: —Pacʉ, mʉꞌʉ ʉꞌmʉse, aꞌti turi wiogʉ niꞌi. “Masĩyʉꞌrʉnʉꞌcãrã niꞌi” nirãrẽ mʉꞌʉ ye cjasere tʉꞌomasĩcã weeweꞌe. Ãpẽrã wĩꞌmarã weronojõ maata tʉꞌo ẽjõpeorã peꞌere tere masĩcã weeꞌe. Mʉꞌʉ tojo weesere wãcũgʉ̃, “Añuꞌu”, ni eꞌcatise oꞌoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pacʉ, mʉꞌʉ ʉaꞌcaronojõta aꞌtere queoro weeꞌe, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Beꞌro Jesú masãrẽ ninemowĩ: —Yʉꞌʉ pacʉ nipeꞌtise weemasĩsere yʉꞌʉre oꞌowĩ. Cʉ̃ niꞌcʉ̃ta yʉꞌʉ nisetisere masĩpeꞌocãꞌsami. Yʉꞌʉ quẽꞌrã niꞌcʉ̃ta cʉ̃ nisetisere masĩpeꞌoꞌo. Noꞌo yʉꞌʉ masĩcã weenoꞌrã quẽꞌrã cʉ̃ nisetisere masĩsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉsã basu weetutuase meꞌrã Õꞌacʉ̃rẽ eꞌcaticã weesĩꞌrĩꞌi. Tojo weerã nʉcʉ̃sere wʉarã, daꞌra caributirã weronojõ niꞌi. Mʉsã buꞌiri tʉꞌoñaꞌrã, bʉjawetirãrẽ aꞌtiro nigʉ̃ti. Mʉsã tojo tʉꞌoñaꞌsere yʉꞌʉre wereya. Yʉꞌʉ mʉsãrẽ weetamugʉ̃ti. Mʉsã tojo weecã, yʉꞌʉ mʉsãrẽ ejerisãjãsere oꞌogʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉꞌʉ dutisere, yʉꞌʉ ʉaronojõ weeya. Mʉsã tojo weecã, weetamugʉ̃ti. Yʉꞌʉ daꞌradutipegʉ niweꞌe. Yʉꞌʉ mʉsãrẽ pajañaꞌgʉ̃, mejõ nigʉ̃ weronojõ weeꞌe. Mʉsã bʉjawetisere yʉꞌʉre werecã, mʉsãrẽ eꞌcatise dʉcayugʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉꞌʉ weetamuyucã, yʉꞌʉ dutise ʉpʉtʉ waro mʉsãrẽ tutuaweꞌe. Masã apeyenojõ caꞌrasãasere oꞌmarã weronojõ tʉꞌoñaꞌrãsaꞌa, ni werewĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Titare sauru nicã ʉ̃sã judío masã soowʉari nʉmʉ Jesú trigo wesepʉ yʉꞌrʉawĩ. Ʉ̃sã cʉ̃ buꞌerã ʉjaboarã, trigo na oteꞌquere tʉ̃ꞌrẽ, te perire baꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo masã ʉ̃sã tojo weecã ĩꞌarã, Jesure niwã: —Ĩꞌaña. Mʉꞌʉ buꞌerã niꞌcãcãnojõrẽ weedutitisere weema. Marĩ soowʉari nʉmʉrẽ daꞌradutiweꞌe, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na tojo nicã tʉꞌogʉ, Jesú niwĩ: —Mʉsã dʉporocjʉ̃ wiogʉ Davi cʉ̃ meꞌrãcjãrã meꞌrã ʉjaboarã weeꞌquere buꞌepã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na aꞌtiro weecãrã niwã. Õꞌacʉ̃ wiꞌipʉ sãjãa, pã́ “Õꞌacʉ̃ ye niꞌi” níꞌque narẽ baꞌadutitiꞌquere baꞌacãrã niwã. Paꞌia diaꞌcʉ̃rẽ baꞌata basiocaro nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Apero Moisé dutiꞌcaropʉ quẽꞌrãrẽ buꞌepã. Marĩ soowʉari nʉmʉ nicã paꞌia Õꞌacʉ̃ wiꞌipʉ daꞌrasama. Cʉ̃ ye cjasere daꞌrarã, sootisama. Na tojo sootirã, ñaꞌarõ weerã mejẽta weema. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉsãrẽ weregʉti. Aꞌtore yʉꞌʉ Õꞌacʉ̃ wiꞌi yʉꞌrʉoro niyʉꞌrʉnʉꞌcãgʉ̃ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mʉsã Õꞌacʉ̃ ye queti ojáca pũrĩpʉ níꞌquere tʉꞌomasĩweꞌe. Aꞌtiro ojanoꞌcaro niwʉ̃: “Yʉꞌʉ masãrẽ aꞌmerĩ pajañaꞌcã ʉaꞌa. Waꞌicʉrã ʉ̃jʉ̃amorõpeoꞌcaro nemorõ te peꞌere ʉasãyʉꞌrʉnʉꞌcãꞌa”, ni ojanoꞌwʉ̃. Mʉsã tere tʉꞌomasĩrã pũrĩcã, masã mejẽcã weetirãrẽ “Ñaꞌarõ weema”, nitibosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ soowʉari nʉmʉrẽ dutise nemorõ dutimasĩꞌi, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesú trigo wesepʉ níca beꞌro judío masã nerẽrĩ wiꞌipʉ sãjãawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti wiꞌi poꞌpeapʉ niꞌcʉ̃ omocã bʉꞌawiaꞌcʉ nicʉ niwĩ. Fariseo masã ¿deꞌro wee Jesure weresãrãsari? nírã, cʉ̃rẽ sẽrĩtiñaꞌwã: —¿Marĩ soowʉari nʉmʉrẽ dutitigʉre yʉꞌrʉocã añuti? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na tojo nicã tʉꞌogʉ, narẽ yʉꞌtiwĩ: —Niꞌinojõta marĩ soowʉari nʉmʉ nicã oveja copepʉ bʉrʉsãjãcã, cʉ̃rẽ wejewãꞌcõgʉ̃ waꞌaticã weetisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Niꞌcʉ̃ masʉ̃ oveja nemorõ wapatiyʉꞌrʉnʉꞌcãmi. Tojo weero marĩ soowʉari nʉmʉrẽ añuse weecã añu niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cʉ̃ tojo níca beꞌro omocã bʉꞌawiaꞌcʉre niwĩ: —Mʉꞌʉ omocãrẽ sĩ́oña, niwĩ. Tojo nicã tʉꞌogʉ, sĩ́owĩ. Cʉ̃ tojo weecãta, ape omocã weronojõ añua waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Cʉ̃ tojo weecã ĩꞌarã, fariseo masã uawijaa waꞌawã. Tojo uawijaarã, “¿Deꞌro wee Jesure wẽjẽrãsari?” ni apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesú cʉ̃rẽ wẽjẽsĩꞌrĩsere masĩgʉ̃, omocã bʉꞌawiaꞌcʉre yʉꞌrʉoꞌcaropʉ níꞌcʉ wijaawãꞌcãwĩ. Cʉ̃rẽ masã pãjãrã sirutuwã. Nipeꞌtirã dutitirãrẽ yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yʉꞌrʉo, narẽ ne cʉ̃ ye cjasere weredutitiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesú na pãjãrãrẽ yʉꞌrʉocã, Isaía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ ojaꞌque queoro waꞌawʉ. Aꞌtiro ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ãꞌrĩ yʉꞌʉre daꞌracoꞌtegʉ, yʉꞌʉ beseꞌcʉ nimi. Yʉꞌʉ maꞌigʉ̃ nimi. Cʉ̃ meꞌrã eꞌcatiꞌi. Yʉꞌʉ Espíriture cʉ̃rẽ oꞌogʉti. Cʉ̃ yʉꞌʉ nipeꞌtirã masãrẽ añurõ weesere weregʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Cʉ̃ ne dʉꞌsaso, macã decopʉ caricũsijasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Noꞌo wãcũtutuatigʉnojõ quẽꞌrãrẽ cõꞌasome. Cõꞌarõnojõ oꞌogʉ, wãcũtutuacã weegʉsami. Ẽjõpeotutuatirãrẽ tuꞌtisome. Narẽ añurõ weetamugʉ̃sami. Cʉ̃ wiogʉ sãjã́ca beꞌropʉ, cʉ̃ ñaꞌasere docaqueꞌaca beꞌropʉ tojo weeduꞌugʉsami. Cʉ̃ queoro dutimeꞌrĩcʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tojo weerã nipeꞌtirocjãrã cʉ̃ dutiatjere coꞌterãsama, tojo ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Beꞌro Jesú tiropʉ caperi bajutigʉ, ucũtigʉ wãtĩ sãjãnoꞌcʉre miiejawã. Na cʉ̃rẽ miiejacã ĩꞌagʉ̃, Jesú cʉ̃rẽ yʉꞌrʉowĩ. Tojo wééca beꞌro ĩꞌa, ucũwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wãtĩ sãjãnoꞌcʉ yʉꞌrʉcã ĩꞌarã, nipeꞌtirã masã ĩꞌamarĩawã. Na aꞌmerĩ sẽrĩtiñaꞌwã: —¿Ãꞌrĩ dʉporocjʉ̃pʉ Davi pãrãmi “Na aꞌtiacjʉ niapʉ” níꞌcʉ niti? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo masã na tojo nicã tʉꞌorã, aꞌtiro niwã: —Ãꞌrĩ wãtĩa wiogʉ Beelzebú wãmetigʉ tutuaro meꞌrã wãtĩarẽ cõꞌawĩrõcãꞌsami, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesú na tojo nisere masĩgʉ̃, narẽ niwĩ: —Niꞌcã curuacjãrã aꞌmerĩ dʉcawati aꞌmequẽrã, masãpeꞌtia waꞌasama. Tojo nicã niꞌcã macãcjãrã o niꞌcã wiꞌicjãrã na quẽꞌrã aꞌmerĩ dʉcawati aꞌmetuꞌtirã, peꞌtidija waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mejãrõta wãtĩa wiogʉ cʉ̃ yarã wãtĩarẽ cõꞌawĩrõgʉ̃, cʉ̃ basuta dʉcawatigʉ weesami. Tojo weegʉ cʉ̃ deꞌro wee tutuanemobosabe. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mʉsã yʉꞌʉre “Cʉ̃ wãtĩ Beelzebú tutuaro meꞌrã wãtĩarẽ cõꞌawĩrõmi”, niꞌi. Tojo nicãma, mʉsã buꞌesere siruturã wãtĩarẽ cõꞌawĩrõrã, ¿noa tutuaro meꞌrã cõꞌawĩrõsari? Narẽ mʉsã “Õꞌacʉ̃ tutuaro meꞌrã wãtĩarẽ cõꞌawĩrõma”, niꞌi. Tojo weero masĩnoꞌo. Mʉsã yʉꞌʉre nise diacjʉ̃ niweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yʉꞌʉ wãtĩarẽ Espíritu Santu tutuaro meꞌrã peꞌe cõꞌawĩrõꞌo. Te meꞌrã “Õꞌacʉ̃ wiogʉ nise mʉsã tiropʉre nitojaꞌa”, ninoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","»Queose meꞌrã mʉsãrẽ werenemogʉ̃ti tja. Niꞌcʉ̃ tutuamʉ ya wiꞌipʉre dʉꞌtecũutimigʉ̃, yajamasĩnoꞌña marĩꞌi. Dʉꞌtéca beꞌropʉ yajamasĩsami, niwĩ. Yʉꞌʉ wãtĩ yʉꞌrʉoro tutuayʉꞌrʉnʉꞌcãꞌa nígʉ̃, tojo niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jesú ninemowĩ: —Yʉꞌʉre ʉatirã yʉꞌʉre ĩꞌatuꞌtirã nima. Yʉꞌʉre seeneotamutigʉnojõ doquestewãꞌcãgʉ̃ weronojõ nimi. Yʉꞌʉre ẽjõpeotirã masãrẽ Õꞌacʉ̃rẽ ẽjõpeocã weetamurã mejẽta weema. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","»Tojo weegʉ mʉsãrẽ diacjʉ̃ weregʉti. Õꞌacʉ̃ masã ñaꞌarõ weesere, ñaꞌarõ ucũsere acobojogʉsami. Espíritu Santure ñaꞌarõ ucũcã pũrĩcãrẽ, acobojosome. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre ñaꞌarõ ucũcã, Õꞌacʉ̃ acobojogʉsami. Espíritu Santu peꞌere ñaꞌarõ ucũcã, Õꞌacʉ̃ acobojosome. Niꞌcãrõacã, beꞌropʉ quẽꞌrãrẽ mejãrõta acobojosome, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesú ninemowĩ: —Yucʉgʉ añucjʉ nicã, tigʉ dʉca meꞌrã “Añucjʉ niꞌi”, ninoꞌo. Yucʉgʉ ñaꞌacjʉ nírõ, tigʉ dʉca meꞌrã “Ñaꞌacjʉ niꞌi”, ni ĩꞌamasĩnoꞌo. Yucʉgʉre tigʉ dʉca meꞌrã ĩꞌamasĩnoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mʉsã aña weronojõ pũrĩrã niꞌi. Ñaꞌarã nitjĩarã, ¿deꞌro wee añusere ucũmasĩbosaʉ? Marĩrẽ ñaꞌase púúturo, ñaꞌaseta marĩ ucũse wijaꞌa. Añuse nicã, añuseta wijaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tojo weegʉ masʉ̃ añugʉ̃ añuse wãcũse cʉoyugʉ, añurõta ucũsami. Apĩ ñaꞌagʉ̃ peꞌe cʉ̃ wãcũse ñaꞌase niyucã, ñaꞌarõ ucũsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʉsãrẽ weregʉti. Õꞌacʉ̃ masãrẽ beseatji nʉmʉ nicã, mʉsã wãcũtimirã noꞌo ʉaro ucũmaꞌaꞌquenʉcʉ̃ besegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉsã añurõ ucṹca beꞌro nicã, Õꞌacʉ̃ mʉsãrẽ “Añurõ ucũpã, buꞌiri mooꞌo”, nigʉ̃sami. Mʉsã ñaꞌarõ ucṹca beꞌroma “Buꞌiri cʉoꞌo”, nigʉ̃sami, niwĩ Jesú fariseo masãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Beꞌro fariseo masã, ãpẽrã Moisé ojaꞌquere buꞌeri masã Jesure aꞌtiro niwã: —Masãrẽ buꞌegʉ, mʉꞌʉ añuse weeĩꞌocã ĩꞌasĩꞌrĩsaꞌa, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na tojo nicã tʉꞌogʉ, Jesú niwĩ: —Mʉsã aꞌtocaterocjãrã ñaꞌarã niꞌi. Mʉsã weeĩꞌoña nírã, mʉsã ẽjõpeotisere yʉꞌʉre ĩꞌoꞌo. Mʉsãrẽ weeĩꞌosome. Aꞌte diaꞌcʉ̃rẽ weregʉti. Dʉporocjʉ̃pʉ Joná Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ waꞌaꞌcaronojõ diaꞌcʉ̃rẽ ĩꞌogʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Joná waꞌiwʉ̃ pajigʉjo paaga poꞌpeapʉ iꞌtia ʉmʉco, iꞌtia ñami cʉ̃pʉre sãñacʉ niwĩ. Cʉ̃ weronojõta yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ quẽꞌrã yʉꞌʉre yááca beꞌro iꞌtia ʉmʉco, iꞌtia ñami diꞌta poꞌpeapʉ cũñagʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Joná Nínive wãmetiri macãcjãrãrẽ Õꞌacʉ̃ ye quetire werecã, na ñaꞌarõ weeꞌquere bʉjaweti, duꞌucãrã niwã. Yʉꞌʉ peꞌere Joná yʉꞌrʉoro nimicã, mʉsã ẽjõpeoweꞌe. Mʉsã na weeꞌcaronojõ ñaꞌarõ weeꞌquere bʉjawetiweꞌe. Tojo weerã Õꞌacʉ̃ masãrẽ beseatji nʉmʉ nicã, Nínivepʉ níꞌcãrã aꞌtocateropʉcjãrãrẽ “Mʉsã Jesure ẽjõpeotirã, ñaꞌarõ weewʉ”, nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Apeye quẽꞌrãrẽ weregʉti. Dʉporocjõ mujĩpũ mʉjãtiro diacjʉ̃ peꞌe nirĩ diꞌtapʉ wiogo Israe curuacjãrã wiogʉ Salomó masĩsere tʉꞌogo aꞌtico niwõ. Yʉꞌʉ Salomó yʉꞌrʉoro masĩyʉꞌrʉnʉꞌcãmicã, mʉsã peꞌe yʉꞌʉre tʉꞌosĩꞌrĩweꞌe. Tojo weego Õꞌacʉ̃ masãrẽ beseatji nʉmʉ nicã, ti diꞌta wiogo níꞌco aꞌtocateropʉcjãrãrẽ “Mʉsã Jesure ẽjõpeotirã, ñaꞌarõ weewʉ”, nigõsamo, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesú fariseo masãrẽ ninemowĩ: —Wãtĩ masʉ̃pʉre cõꞌawĩrõnoꞌca beꞌro aco marĩrõpʉ sijabaqueꞌatisami. Cʉ̃ niatjore aꞌmagʉ̃, tojo weesami. Cʉ̃ nirṍ bocatigʉ, aꞌtiro wãcũsami: ");
INSERT INTO tuoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Yʉꞌʉ wijaaꞌcʉpʉre dajasãjãagʉ̃ti tja”, nisami. Cʉ̃pʉre dajasãjãagʉ̃, wiꞌi oꞌaca wiꞌi, añurõ apóca wiꞌi weronojõ bocaejasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Beꞌro ãpẽrã wãtĩa sietere cʉ̃ yʉꞌrʉoro ñaꞌarãrẽ pijisami. Piji, beꞌro todʉporopʉ cʉ̃ wijaaꞌcʉpʉre na nipeꞌtirã sãjãasama. Tojo weegʉ masʉ̃ cʉ̃ todʉporopʉ níꞌcaro nemorõ ñaꞌarõ tojasami. Ãꞌrã quẽꞌrã yʉꞌʉre ẽjõpeotirã tojota ñaꞌabutiaro waꞌarãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesú masãrẽ tojo ucũrĩ cura cʉ̃ paco, cʉ̃ acabijirã cʉ̃ nirĩ wiꞌipʉ ejawã. Na sopepʉ tojanʉꞌcã, cʉ̃ meꞌrã ucũsĩꞌrĩwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tojo weecã, to nigʉ̃́ niꞌcʉ̃ werewĩ Jesure: —Mʉꞌʉ paco, mʉꞌʉ acabijirã sope pʉꞌtopʉ niama. Mʉꞌʉ meꞌrã ucũsĩꞌrĩama, ni werewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú cʉ̃rẽ niwĩ: —¿Noanojõ niti yʉꞌʉ paco, yʉꞌʉ acabijirã? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Beꞌro ʉ̃sã cʉ̃ buꞌerãrẽ ñupuꞌa, niwĩ: —Ãꞌrãrẽ yʉꞌʉ paco, yʉꞌʉ acawererã waro tʉꞌoñaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Noꞌo Õꞌacʉ̃ ʉaro weerãnojõ náta yʉꞌʉ acabiji, yʉꞌʉ acabijo, yʉꞌʉ paco weronojõ nima, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti nʉmʉrẽta tja Jesú wiꞌipʉ níꞌcʉ ditara sumutopʉ waꞌawĩ. Waꞌa, topʉ dujiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masã pãjãrã waro cʉ̃ tiropʉ nerẽcã ĩꞌagʉ̃, yucʉsʉpʉ mʉjãsãjãa, dujiwĩ. Masã peꞌe ditara sumutopʉ nuꞌcũwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Beꞌro Jesú queose meꞌrã narẽ buꞌewĩ: —Niꞌcʉ̃ masʉ̃ cʉ̃ ya wesepʉ otegʉ waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cʉ̃ otegʉ wẽestewãꞌcãcã, apeye otese cape maꞌapʉ doquequeꞌasaꞌa. Mirĩcʉ̃a aꞌti, te perire ĩꞌaboca, baꞌapeꞌocãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apeye ʉ̃tãpaga cãꞌrõacã diꞌta cʉoro buꞌipʉ doquequeꞌasaꞌa. Te diꞌta cãꞌrõacã niyucã, asibusu maata marã, pĩꞌrĩsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Beꞌro mujĩpũ asimʉjãtiri cura diꞌta boposãjãyʉꞌrʉa waꞌasaꞌa. Tojo weero nʉꞌcõrĩ cʉotiꞌcaro nitjĩarõ, maata ñaidija waꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apeye otese cape pota waꞌteropʉ bʉrʉqueꞌasaꞌa. Pota peꞌe tere pĩꞌrĩyʉꞌrʉa, wẽjẽcãꞌsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apeye otese cape diꞌta añurõpʉ bʉrʉqueꞌasaꞌa. Te añurõ pĩꞌrĩ, dʉcatisaꞌa. Niꞌcã ño cien peri dʉcatisaꞌa. Ape ño sesenta peri, ape ño treinta peri dʉcatisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oꞌmeperi cʉorãnojõ aꞌtere añurõ tʉꞌoya, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Beꞌro ʉ̃sã cʉ̃ buꞌerã cʉ̃ pʉꞌto waꞌa, cʉ̃rẽ sẽrĩtiñaꞌwʉ̃: —¿Deꞌro weegʉ masãrẽ queose meꞌrã buꞌeti? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesú ʉ̃sãrẽ yʉꞌtiwĩ: —Õꞌacʉ̃ mʉsãrẽ aꞌtiro weemi. Mʉsã ãpẽrã todʉporopʉ masĩña marĩmiꞌquere cʉ̃ wiogʉ nisere masĩcã weemi. Ãpẽrã yʉꞌʉre ẽjõpeotirã peꞌere masĩticã weemi. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tojo weegʉ yʉꞌʉ buꞌesere ẽjõpeorãrẽ narẽta Õꞌacʉ̃ masĩse oꞌonemogʉ̃sami. Na tʉꞌomasĩse cʉoyʉꞌrʉarãsama. Ãpẽrã yʉꞌʉ buꞌesere ẽjõpeotirã peꞌere na cãꞌrõacã masĩmiꞌquere tʉꞌomasĩticã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na yʉꞌʉ weesere ĩꞌamirã, ĩꞌatirã weronojõ nisama. Yʉꞌʉ buꞌesere tʉꞌomirã, tʉꞌomasĩtisama. Tojo weegʉ queose meꞌrã narẽ wereꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Isaía Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ cʉ̃ ojaꞌcaronojõta narẽ waꞌaꞌa. Aꞌtiro ojacʉ niwĩ: Mʉsã Õꞌacʉ̃ ye cjasere teerã, ĩꞌasĩꞌrĩsome. Õꞌacʉ̃rẽ ẽjõpeosĩꞌrĩtirã, diacjʉ̃ cjasere tʉꞌosĩꞌrĩsome. Tojo ẽjõpeotitjĩarã, yʉꞌʉre acobojose sẽrĩsome. Tojo weerã mʉsãrẽ werecã, tʉꞌorãsaꞌa, tʉꞌorã peꞌe. Mejõ ¿deꞌro nirõ weesari? ni tʉꞌomasĩsome. Mʉsã añurõ yʉꞌʉ weesere ĩꞌamirã, ĩꞌamasĩsome, ni ojacʉ niwĩ Isaía, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ʉ̃sã peꞌere niwĩ: —Mʉsã pũrĩcã yʉꞌʉre ẽjõpeorã, eꞌcatiꞌi. Yʉꞌʉ weesere ĩꞌarã, yʉꞌʉ buꞌesere tʉꞌorã, ẽjõpeoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Diacjʉ̃ mʉsãrẽ weregʉti. Pãjãrã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã, tojo nicã dʉporocjãrã masã añurã níꞌcãrã niꞌcãrõacã yʉꞌʉ mʉsãrẽ weesere ĩꞌasĩꞌrĩcãrã nimiwã. Yʉꞌʉ mʉsãrẽ weresere tʉꞌosĩꞌrĩcãrã nimiwã. Tojo weesĩꞌrĩꞌcãrã nimirã, ĩꞌati, tʉꞌotiyʉꞌrʉocãꞌcãrã niwã, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Beꞌro Jesú ʉ̃sãrẽ aꞌtiro werenemowĩ: —Oteri masʉ̃ ye queti aꞌtiro nisĩꞌrĩrõ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yʉꞌʉ aꞌti turipʉ wiogʉ nigʉ̃saꞌa nisere tʉꞌomirã, tere tʉꞌomasĩtirã, aꞌtiro weronojõ nisama. Otese cape maꞌapʉ bʉrʉqueꞌaꞌque weronojõ nisama. Wãtĩ aꞌti, na tʉꞌomiꞌquere ẽꞌmapeꞌocãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ãpẽrã ʉ̃tãpaga waꞌteropʉ doquequeꞌaꞌque peri weronojõ nisama. Yé quetire eꞌcatise meꞌrã tʉꞌosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tojo tʉꞌomirã, nʉꞌcõrĩ marĩrã weronojõ nisama. Narẽ mejẽcã waꞌacã, o ãpẽrã te quetire ẽjõpeose buꞌiri narẽ tuꞌticã, maata ẽjõpeoduꞌucãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ãpẽrã otese cape pota waꞌteropʉ bʉrʉqueꞌaꞌque weronojõ nisama. Yé quetire tʉꞌoma, tʉꞌorã peꞌe. Aꞌti ʉmʉco cjase peꞌere wãcũyʉꞌrʉnʉꞌcãsama. Noꞌo deꞌro nisere ʉaripejayʉꞌrʉasama. Na tojo niseticã, aꞌte narẽ dojorẽcãꞌsaꞌa. Na tʉꞌoꞌquere acobojo, dʉca marĩrã weronojõ nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ãpẽrã diꞌtapʉ añurõpʉ bʉrʉqueꞌaꞌque peri weronojõ nima. Yé quetire tʉꞌo, añurõ ẽjõpeo, yʉꞌʉ dutironojõ weesetirã, añurõ dʉcatirã weronojõ nima. Cien peri dʉcatiꞌcaro weronojõ añusere weesama. Ãpẽrã sesenta peri, ãpẽrã treinta peri dʉcatiꞌcaro weronojõ añusere weesama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesú apeye queose meꞌrã ʉ̃sãrẽ werenemowĩ: —Õꞌacʉ̃ wiogʉ nise aꞌtiro weronojõ niꞌi. Niꞌcʉ̃ masʉ̃ añuse capere cʉ̃ ya wesepʉ otesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Beꞌro nipeꞌtirã cã́rĩ́ca beꞌro te oteꞌcʉre ĩꞌatuꞌtigʉ cʉ̃ oteꞌcaropʉ waꞌasami. Waꞌa, trigo cape waꞌteropʉ ñaꞌase capere otesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo pĩꞌrĩmʉjã, te pupiri cura ñaꞌase cʉ̃ oteꞌque peꞌe quẽꞌrã pĩꞌrĩbajuasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tere ĩꞌarã, cʉ̃rẽ daꞌracoꞌterã na wiogʉpʉre wererã waꞌasama: “Wiogʉ, marĩ oteꞌque añuse cape diaꞌcʉ̃ nimiwʉ̃to”, nisama. “¿Deꞌro wee aꞌte ñaꞌase cape aꞌtipari?” nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na wiogʉ narẽ yʉꞌtisami: “Niꞌcʉ̃ marĩrẽ ĩꞌatuꞌtigʉ tojo weeapĩ”, nisami. Beꞌro daꞌracoꞌterã na wiogʉre sẽrĩtiñaꞌsama tja: “¿Mʉꞌʉ ʉ̃sã ñaꞌasere cureweerã waꞌacã ʉasari?” nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cʉ̃ peꞌe narẽ nisami: “Weeticãꞌña. Mʉsã cureweerã, apeye trigore duꞌacõꞌabosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Totá trigo meꞌrã bʉcʉacãꞌto. Trigo bʉcʉatuꞌajaca beꞌropʉ daꞌrari masãrẽ oꞌógʉti. Na ñaꞌase pĩꞌrĩꞌquere cureweemʉꞌtãrãsama. Curewee, tere opa dotori dʉꞌte, ʉ̃jʉ̃arãsama. Tuꞌajanʉꞌcõ, trigore na nʉrõwʉaropʉ nʉrõrãsama”, nisami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesú apeye queose meꞌrã werenemowĩ tja: —Õꞌacʉ̃ yarã pãjãrã sãjãrã́sama nise otese mostaza cape weronojõ niꞌi. Tere niꞌcʉ̃ cʉ̃ ya wesepʉ otesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostaza cape cãꞌcaperoacã waro niꞌi. Tócacaperoacã nimirõ, bʉcʉaropʉa pajibutiacjʉ yucʉgʉ pĩꞌrĩsaꞌa. Pajicjʉ waro waꞌacã ĩꞌarã, mirĩcʉ̃a aꞌti, tigʉ dʉpʉripʉ na diepeoatje suꞌtire weesama, niwĩ. Õꞌacʉ̃ wiogʉ nise cãꞌcaperoacã weronojõ nʉꞌcãsaꞌa. Beꞌro pajicjʉ bʉcʉaꞌcaro weronojõ nipeꞌtiropʉ cʉ̃ ye queti seꞌsa waꞌarosaꞌa. Tojo nicã pãjãrã cʉ̃ yarã sãjãrã́sama nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Beꞌro apeye queose meꞌrã werenemowĩ tja: —Õꞌacʉ̃ wiogʉ nise aꞌtiro weronojõ niꞌi. Niꞌcõ numio pã́ weegotigo pã́ weese harinarẽ iꞌtiapa queo, poꞌosãasamo. Te meꞌrã levadura pã́ bʉcʉacã weesere morẽsamo. Beꞌro te nipeꞌtise bʉcʉa seꞌsapeꞌtia waꞌasaꞌa, niwĩ. Levadura harinarẽ bʉcʉacã weeꞌcaro weronojõ Õꞌacʉ̃ wiogʉ nise nipeꞌtiropʉ seꞌsarosaꞌa nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesú masãrẽ buꞌégʉ, queose meꞌrã wereticã weetiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cʉ̃ tojo weecã, Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ ojaꞌque queoro waꞌawʉ. Jesú masãrẽ wereatjere aꞌtiro ojanoꞌwʉ̃: Queose meꞌrã masãrẽ weregʉsaꞌa. Õꞌacʉ̃ aꞌti ʉmʉco weecãpʉ masĩnoꞌña marĩꞌquere mʉsãrẽ were bajurẽgʉ̃ti, ni ojanoꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Beꞌro Jesú masãrẽ weꞌeriti, wiꞌipʉ sãjãawĩ. Ʉ̃sã cʉ̃ buꞌerã cʉ̃rẽ sirutusãjãwʉ̃. Topʉ cʉ̃rẽ sẽrĩtiñaꞌwʉ̃: —Mʉꞌʉ mejẽpʉ ñaꞌase cape trigo waꞌteropʉ queose wereꞌquere wereapoya. ¿Deꞌro nisĩꞌrĩrõ weeati? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ʉ̃sã tojo nicã tʉꞌogʉ, Jesú yʉꞌtiwĩ: —Añuse trigo capere oteꞌcʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ti wese peꞌe aꞌti turi nisĩꞌrĩrõ weeꞌe. Añuse cape yʉꞌʉre ẽjõpeorã Õꞌacʉ̃ põꞌrã nima, nisĩꞌrĩrõ weeꞌe. Ñaꞌase cape pĩꞌrĩꞌque peꞌe wãtĩ yarã nima, nisĩꞌrĩrõ weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti wese oteꞌcʉre ĩꞌatuꞌtigʉ ñaꞌasere oteꞌcʉ wãtĩ nimi. Trigo bʉcʉatuꞌajaca beꞌro na tʉ̃ꞌrẽse aꞌti ʉmʉco peꞌtiatje niꞌi, nisĩꞌrĩrõ weeꞌe. Trigore tʉ̃ꞌrẽrĩ masã Õꞌacʉ̃rẽ werecoꞌterã ʉꞌmʉsecjãrã weronojõ nima. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ñaꞌasere curewee ʉ̃jʉ̃acõꞌasama. Na tojo weeꞌcaro weronojõ aꞌti turi peꞌticãpʉre ñaꞌarãrẽ cõꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ yʉꞌʉre werecoꞌterãrẽ nipeꞌtiropʉ oꞌógʉsaꞌa. “Nipeꞌtirã ñaꞌarõ weerãrẽ, tojo nicã ãpẽrãrẽ ñaꞌarõ weecã weerãrẽ neoña”, nigʉ̃saꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Narẽ pecameꞌepʉ cõꞌarãsama. Topʉ na pũrĩnoꞌrã, upicari cũꞌrĩdio, utirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tojo waꞌari curare Õꞌacʉ̃ ʉaro weerã́ peꞌe aꞌtiro weerãsama. Cʉ̃ tiropʉ waꞌarã, mujĩpũ ʉmʉcocjʉ̃ weronojõ asisterãsama. Topʉ ninuꞌcũcãꞌrãsama. Oꞌmeperi cʉorãnojõ aꞌtere añurõ tʉꞌoya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesú aꞌtiro werenemowĩ: —Mʉsãrẽ Õꞌacʉ̃ wiogʉ nisere werenemogʉ̃ti. Cʉ̃ mʉsã wiogʉ nise nipeꞌtise yʉꞌrʉoro añuyʉꞌrʉnʉꞌcãꞌa. Niꞌcʉ̃ apeyenojõ wapabʉjʉsere ãpẽrã ya diꞌta poꞌpeapʉ nʉoꞌquere bocaꞌcaro weronojõ niꞌi. Tere bocáca beꞌro mejãrõpʉta yaacũusami tja. Beꞌro eꞌcatise meꞌrã waꞌa, nipeꞌtise cʉ̃ cʉosere duapeꞌocãꞌsami. Cʉ̃ duaꞌque wapa meꞌrã ti diꞌtare duumiicãꞌsami, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Apeye quẽꞌrãrẽ Jesú werenemowĩ: —Õꞌacʉ̃ wiogʉ nise niꞌcʉ̃ duari masʉ̃ añurõ asistese peri perla wãmetisere aꞌmacusiaro weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cʉ̃ wapabʉjʉri pe, niꞌcã pere bocaejagʉ, aꞌtiro weesami. Bocaeja, cʉ̃ cʉosere duapeꞌocãꞌsami. Cʉ̃ duaꞌque wapa meꞌrã ti pe wapabʉjʉri pere duumiicãꞌsami. Õꞌacʉ̃ mʉsã wiogʉ nicã, ti pe wapabʉjʉri pere bocase weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","»Beꞌropʉ Õꞌacʉ̃ masãrẽ beseatjere weregʉti. Waꞌi wẽjẽrĩ masã niꞌcãgʉ̃ wejecʉjo dia pajiri maapʉ doqueñosama. Tigʉpʉre nirãnʉcʉ̃ waꞌi suꞌriwãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tigʉ muꞌmuyʉꞌrʉcã ĩꞌarã, waꞌi wẽjẽrĩ masã dia sumutopʉ wejemajãsama. Topʉ waꞌire besedujisama. Añurãrẽ piꞌipʉ besesãasama. Ñaꞌarãrẽ doqueñocãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aꞌti ʉmʉco peꞌticã, tojota waꞌarosaꞌa. Õꞌacʉ̃rẽ werecoꞌterã ʉꞌmʉsecjãrã aꞌtirãsama. Añurã, ñaꞌarãrẽ dʉcawaanʉꞌcõrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ñaꞌarãrẽ pecameꞌepʉ cõꞌarãsama. Topʉ na pũrĩnoꞌrã, upicari cũꞌrĩdio, utirãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Beꞌro Jesú ʉ̃sãrẽ niwĩ: —¿Aꞌte yʉꞌʉ níꞌquere tʉꞌoti mʉsã? niwĩ. Ʉ̃sã “Ʉ̃ʉ, tʉꞌoꞌo”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ʉ̃sã tojo nicã, cʉ̃ niwĩ: —Nipeꞌtirã Moisé ojaꞌquere buꞌerã yʉꞌʉ wiogʉ nigʉ̃saꞌa nisere ẽjõpeorã, niꞌcʉ̃ wiꞌi cʉogʉ weronojõ nima. Cʉ̃, cʉ̃ ya wiꞌicjãrãrẽ oꞌoacjʉ, ti wiꞌipʉ cʉ̃ apeyenojõ nʉrõꞌquere maꞌmarẽ, mejãrẽ miiwĩrõmasĩsami. Cʉ̃ weronojõ yé niatjere mejã, Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã na ojaꞌquere weremasĩsama. Tojo nicã maꞌma, yʉꞌʉ buꞌese quẽꞌrãrẽ weremasĩsama nígʉ̃, tojo niwĩ ʉ̃sãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jesú te queose wéréca beꞌro to níꞌcʉ Nazare cʉ̃ masã́ca macãpʉ waꞌawĩ. Topʉ judío masã na nerẽwʉari wiꞌipʉ buꞌenʉꞌcãwĩ. Topʉ nirã́ cʉ̃ buꞌesere tʉꞌo, ĩꞌamarĩamʉjãwã. Aꞌtiro niwã: —¿Noꞌopʉ buꞌepari ãꞌrĩ tocãꞌrõ masĩgʉ̃? ¿Deꞌro wee aꞌte masã dutitirãrẽ yʉꞌrʉosenojõrẽ weeĩꞌomasĩti? ");
INSERT INTO tuoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ãꞌrĩ niꞌcʉ̃ capiteru macʉ̃ nimi. Cʉ̃ aꞌti macãcjõ María macʉ̃ nimi. Cʉ̃ acabijirã Santiago, José, Simó, Juda nima. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Cʉ̃ acabijirã numia quẽꞌrã aꞌtopʉta nima. Tojo weegʉ ¿noꞌopʉ masĩmipari cʉ̃ aꞌtere? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cʉ̃ tocjʉ̃ nise buꞌiri cʉ̃ weresere ẽjõpeosĩꞌrĩtiwã. Jesú peꞌe narẽ niwĩ: —Nipeꞌtirã niꞌcʉ̃ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃rẽ tʉꞌo ẽjõpeosama. Cʉ̃ ya diꞌtacjãrã, cʉ̃ ya wiꞌicjãrã diaꞌcʉ̃ ẽjõpeotisama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tojo weegʉ ti macãpʉre na ẽjõpeoticã ĩꞌagʉ̃, peje waro narẽ weeĩꞌotiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Titare Herode Galilea diꞌtacjãrãrẽ dutigʉ Jesú weeꞌquere tʉꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tere tʉꞌogʉ, cʉ̃ meꞌrã daꞌrarãrẽ aꞌtiro nicʉ niwĩ: —Cʉ̃ Juã masãrẽ wãmeyeri masʉ̃ yʉꞌʉ wẽjẽdutiꞌcʉ masãꞌcʉ nígʉ̃ nisami. Tojo weetigʉ mejẽta, peje waro weeĩꞌotutuayʉꞌrʉapʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Cʉ̃ Herodeta todʉporopʉre Juãrẽ ñeꞌeduticʉ niwĩ. Ñeꞌe, buꞌiri daꞌreri wiꞌipʉ dʉꞌtecũuduticʉ niwĩ. Aꞌte ye buꞌiri tojo weecʉ niwĩ. Herode cʉ̃ acabiji Felipe nʉmo, Herodía wãmetigore Felipe cʉ̃ catimicã, core ẽꞌma, nʉmoticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Cʉ̃ tojo weesere tʉꞌogʉ, Juã Herode tiropʉ waꞌa, aꞌtiro nicʉ niwĩ: —Mʉꞌʉ acabiji nʉmorẽ nʉmoticã, ñaꞌa niꞌi. Core cʉoticãꞌña, nicʉ niwĩ. Cʉ̃ tojo níꞌque buꞌiri Herode cʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ sõrõduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Cʉ̃ Juãrẽ wẽjẽsĩꞌrĩcʉ niwĩ. Masã peꞌe “Juã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ nimi”, nicãrã niwã. Tojo weegʉ yʉꞌʉ cʉ̃rẽ wẽjẽcã, masã yʉꞌʉ meꞌrã uabosama ni uigʉ, maata cʉ̃rẽ wẽjẽticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Beꞌro Herode cʉ̃ bajuáca nʉmʉrẽ bosenʉmʉ weecʉ niwĩ. Titare Herodía macõ cʉ̃ pijiꞌcãrã tiropʉ basaĩꞌogõ wijaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herode co basaĩꞌocã tʉꞌsayʉꞌrʉacʉ niwĩ. Tojo weegʉ “Ne nisooro marĩrõ noꞌo mʉꞌʉ ʉasenojõrẽ oꞌogʉti”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Co peꞌe co pacore “¿Ñeꞌenojõrẽ sẽrĩgõsariba?” nico niwõ. Co paco wéréca beꞌro Herode tiropʉ waꞌa, cʉ̃rẽ nico niwõ: —Juã masãrẽ wãmeyeri masʉ̃ dʉpoare dʉtesure, niꞌcã papʉ miiti, yʉꞌʉre oꞌoya, nico niwõ. ¿Diacjʉ̃ta Juãrẽ wẽjẽgʉ̃sari? nígõ, tojo weedutico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Co tojo nicã tʉꞌogʉ, Herode bʉjaweticʉ niwĩ. Juãrẽ wẽjẽsĩꞌrĩticʉ nimiwĩ. Cʉ̃ masã tʉꞌoropʉ “Mʉꞌʉ ʉasenojõrẽ oꞌogʉti” níꞌcʉ niyugʉ, masã yʉꞌʉre bujiri nígʉ̃, co níꞌcaronojõta weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tojo weegʉ Juã buꞌiri daꞌreri wiꞌipʉ nigʉ̃rẽ cʉ̃ dʉpoare dʉtesureduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dʉtesureca beꞌro cʉ̃ dʉpoare bapapʉ sãa, Herodía macõrẽ oꞌocãrã niwã. Co peꞌe quẽꞌrã co pacopʉre oꞌoturiaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Beꞌro Juã buꞌesere sirutuꞌcãrã cʉ̃ upʉre miirã waꞌa, yaacãrã niwã. Beꞌro Jesupʉre wererã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesú Juãrẽ wẽjẽꞌque quetire tʉꞌogʉ, aꞌtiro weewĩ. Yucʉsʉpʉ mʉjãsãjãa, apero masã marĩrõpʉ ʉ̃sã cʉ̃ buꞌerã meꞌrã waꞌawĩ. Ʉ̃sã waꞌasere tʉꞌorã, tocjãrã masã maꞌapʉ cʉ̃rẽ sirutuwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesú ape pãꞌrẽpʉ pẽꞌajagʉ, dijanʉꞌcãwĩ. Beꞌro masã pãjãrãrẽ bocaejapejawĩ. Narẽ ĩꞌagʉ̃, pajañaꞌwĩ. Dutitirã na miaꞌcãrãrẽ yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ʉ̃sã cʉ̃ buꞌerã naꞌiqueꞌari cura cʉ̃ pʉꞌto waꞌa, werewʉ: —Naꞌiqueꞌaropʉ weeꞌe. Aꞌtopʉ marĩ nirõpʉ masã marĩma. Tojo weegʉ masãrẽ macãpʉ waꞌadutiya. Topʉ duubaꞌarã waꞌato, nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ʉ̃sã tojo nicã tʉꞌogʉ, “Waꞌaticãꞌto. Mʉsã narẽ ecaya”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ʉ̃sã cʉ̃rẽ niwʉ̃: —Niꞌcãmocʉse pã́, waꞌi pʉarã diaꞌcʉ̃ cʉoꞌo, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Beꞌro “Te mʉsã cʉosere miitia”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cʉ̃ tojo nicã, cʉ̃ tiro miawʉ̃. Beꞌro Jesú masãrẽ tá buꞌipʉ dujidutiwĩ. Tuꞌajanʉꞌcõ, te pã́ niꞌcãmocʉse pagare, na waꞌi pʉarãrẽ mii, ʉꞌmʉarõpʉ ĩꞌamorõ, cʉ̃ pacʉ Õꞌacʉ̃rẽ eꞌcatise oꞌowĩ. Beꞌro pã́rẽ dʉcawaa, ʉ̃sãrẽ oꞌowĩ. Ʉ̃sã peꞌe masãrẽ tere etiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nipeꞌtirã baꞌa yapiwã. Beꞌro doce piꞌseri na baꞌadʉꞌaꞌquere seeneowʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tere baꞌarã numia, wĩꞌmarã baꞌpaqueonoꞌña marĩrõ ʉmʉa seꞌsaro niꞌcãmocʉsetiri mil niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesú masãrẽ baꞌase ecáca beꞌro ʉ̃sã cʉ̃ buꞌerãrẽ yucʉsʉ meꞌrã ditarapʉ pẽꞌayudutiwĩ. Cʉ̃ peꞌe topʉ masãrẽ weꞌeritigʉ, tojacãꞌwĩ yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Beꞌro masãrẽ weꞌeritica beꞌro ʉ̃rʉ̃gʉ̃pʉ cʉ̃ seꞌsaro ñubuegʉ mʉjãcʉ niwĩ. Topʉre ñami ẽjã́cã, niꞌcʉ̃ta nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ʉ̃sã peꞌe ditara decopʉ pẽꞌarã weewʉ. To ʉ̃sã ejacã, wĩꞌrõ ʉpʉtʉ wẽepõtẽowʉ̃. Tojo weero pãꞌcõrĩ paca yucʉsʉre wẽecʉawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Boꞌremʉjãtiri cura Jesú ʉ̃sã tiropʉ acopʉ sijawãꞌcãtiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ʉ̃sã cʉ̃rẽ ĩꞌamasĩtiwʉ. Tojo weerã cʉ̃ topʉ sijawãꞌcãticã ĩꞌarã, ʉpʉtʉ ʉcʉawʉ. Cʉ̃rẽ ĩꞌarã, “Abʉ, masʉ̃ wẽrĩꞌcʉ wãtĩ nisami”, ni caricũwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesú ʉ̃sãrẽ nʉcʉ̃adutigʉ aꞌtiro niwĩ: —Wãcũtutuaya. Yʉꞌʉ niꞌi. Yʉꞌʉre uiticãꞌña, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Beꞌro Pedro Jesure niwĩ: —Wiogʉ, mʉꞌʉ nígʉ̃, yʉꞌʉre mʉꞌʉ tiro acopʉ sijawãꞌcãdutiya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesú cʉ̃rẽ niwĩ: —To pũrĩcãrẽ aꞌtia, niwĩ. Tojo weegʉ Pedro dija, Jesú tiropʉ waꞌagʉ, sijawãꞌcãwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Beꞌro ʉpʉtʉ wĩꞌrõ wẽecã ĩꞌagʉ̃, ʉcʉa waꞌawĩ. Tojo weegʉ cʉ̃ diꞌadijagʉ, caricũwĩ: —Wiogʉ, ñeꞌegʉ̃ aꞌtia, ni caricũwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Beꞌro maata Jesú cʉ̃rẽ ñeꞌewĩ. Aꞌtiro niwĩ: —¿Mʉꞌʉ cãꞌrõacã waro ẽjõpeose cʉoti? ¿Deꞌro weegʉ yʉꞌʉ tiro aꞌtisĩꞌrĩmigʉ̃, yʉꞌʉre ẽjõpeotiati? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Beꞌro na yucʉsʉpʉ mʉjãsãjãrĩ cura wĩꞌrõ yʉsʉa waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tojo waꞌacã ĩꞌarã, ʉ̃sã tiwʉpʉ sãñarã Jesure ẽjõpeorã, ejaqueꞌawʉ. Cʉ̃rẽ niwʉ̃: —Nirõta mʉꞌʉ Õꞌacʉ̃ macʉ̃ niꞌi, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Beꞌro ʉ̃sã Genesare wãmetiropʉ pẽꞌajawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tocjãrã Jesure ĩꞌamasĩrã, topʉ cʉ̃ ejase quetire nipeꞌtiropʉ wereseꞌsabiꞌacãrã niwã. Nipeꞌtirã dutitirãrẽ yʉꞌrʉodutirã cʉ̃ tiropʉ miiejawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Mʉꞌʉ quẽꞌrã ʉ̃sãrẽ mʉꞌʉ yaro suꞌtiro sumutopʉ ñeꞌeñaꞌduticureya, niwã. Nipeꞌtirã tojo weerã́ yʉꞌrʉonoꞌpeꞌticãꞌwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Beꞌro fariseo masã Jesú tiropʉ ejawã. Tojo nicã Moisé ojaꞌquere buꞌeri masã quẽꞌrã Jerusalẽ́pʉ aꞌtiꞌcãrã Jesú tiropʉ eja, sẽrĩtiñaꞌwã: ");
INSERT INTO tuoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Deꞌro weerã mʉꞌʉ buꞌerã marĩ ñecʉ̃sʉmʉa weemʉjãtiꞌquere yʉꞌrʉnʉꞌcãti? Baꞌase dʉporo marĩ ñecʉ̃sʉmʉa weewʉaꞌcaronojõ omocoetima, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesú narẽ yʉꞌtiwĩ: —Yʉꞌʉ quẽꞌrã mʉsãrẽ sẽrĩtiñaꞌgʉ̃ti. Mʉsã ñecʉ̃sʉmʉa weemʉjãtiꞌquere weesiruturã, ¿deꞌro weerã Õꞌacʉ̃ dutiro peꞌere yʉꞌrʉnʉꞌcãti? ");
INSERT INTO tuoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Õꞌacʉ̃ aꞌtiro duticʉ niwĩ: “Mʉsã pacʉ, mʉsã pacore ẽjõpeoya.” Tojo nicã “Noꞌo cʉ̃ pacʉ, cʉ̃ pacore ñaꞌarõ ucũgʉ̃nojõ wẽrĩato”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mʉsã peꞌe mʉsã pacʉre o mʉsã pacore na apeyenojõ sẽrĩcã, weetamusĩꞌrĩtirã, narẽ aꞌtiro nisaꞌa: “Nipeꞌtise ʉ̃sã cʉose mʉsãrẽ oꞌoboꞌquere Õꞌacʉ̃rẽ oꞌotojapʉ”, nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mʉsãta aꞌtiro nirãnojõrẽ na pacʉ o na pacore weetamuta basiotisaꞌa nisere buꞌeꞌe. Aꞌtiro wéérã, Õꞌacʉ̃ dutisere tojowaro ĩꞌacõꞌabutiacãꞌa. Mʉsã ñecʉ̃sʉmʉa weemʉjãtiꞌquere weesĩꞌrĩrã, tojo weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Diacjʉ̃ wéérã weronojõ weetaꞌsaꞌa. Isaía dʉporocjʉ̃pʉ Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ mʉsãrẽ diacjʉ̃ta nisapĩ. Aꞌtiro ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ãꞌrã masã ʉsero meꞌrã diaꞌcʉ̃ yʉꞌʉre ẽjõpeoma. Na tʉꞌoñaꞌse waro peꞌe noꞌopʉ nirõ nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tojo weerã na yʉꞌʉre ñubuepeose wapamarĩꞌi. Na buꞌese yʉꞌʉ dutise mejẽta niꞌi. Masã dutise niꞌi”, nicʉ niwĩ Õꞌacʉ̃, ni ojacʉ niwĩ Isaía, ni yʉꞌtiwĩ Jesú fariseo masãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Narẽ tojo níca beꞌro Jesú masãrẽ pijio, niwĩ: —Yé cjasere tʉꞌomasĩrãti nírã, tʉꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Marĩ ʉsero meꞌrã baꞌase mejẽta Õꞌacʉ̃ ĩꞌorõpʉ marĩrẽ ñaꞌarõ waꞌacã weeꞌe. Tojo weronojõ oꞌoro, marĩrẽ ʉseropʉ wijatise peꞌe ñaꞌarõ waꞌacã weeꞌe, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tojo níca beꞌro ʉ̃sã cʉ̃ buꞌerã cʉ̃ pʉꞌto waꞌa, cʉ̃rẽ niwʉ̃: —Mʉꞌʉ tojo nisere tʉꞌorã, fariseo masã tʉꞌsatiama, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ʉ̃sã tojo nicã, Jesú queose meꞌrã yʉꞌtiwĩ: —Wese cʉogʉ ñaꞌase, topʉ pĩꞌrĩbajuasere duꞌacõꞌagʉ̃sami. Yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ nisoose meꞌrã buꞌerãrẽ mejãrõta weegʉsami. Narẽ cõꞌabutiagʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tojo weerã narẽ tojo ĩꞌacõꞌacãꞌña. Na nisoose meꞌrã buꞌérã, caperi ĩꞌatirã ãpẽrã caperi ĩꞌatirãrẽ wejemʉꞌtãrã weronojõ nima. Niꞌcʉ̃ ĩꞌatigʉ apĩ ĩꞌatigʉre wejemʉꞌtãgʉ̃, na pʉarãpʉta noꞌo nirĩ copepʉ bʉrʉsãjãsama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Beꞌro Pedro Jesure niwĩ: —Ʉ̃sãrẽ wereya. Mʉꞌʉ níꞌque ¿deꞌro nisĩꞌrĩrõ weesari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesú cʉ̃rẽ niwĩ: —¿Mʉsã quẽꞌrã aꞌtere tʉꞌomasĩweti yujupʉ? ");
INSERT INTO tuoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nipeꞌtise marĩ baꞌasõrõse paapʉ waꞌa, beꞌro yʉꞌrʉwijaa waꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Masã na ucũse, ʉseropʉ wijase peꞌe wãcũsepʉ wadatiwijatiꞌi. Aꞌte pũrĩcã Õꞌacʉ̃ ĩꞌorõpʉ masãrẽ ñaꞌarã waꞌacã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Marĩ wãcũse ñaꞌarõ wãcũsepʉ dʉꞌpocã́tiwijatiꞌi. Ãpẽrãrẽ wẽjẽcõꞌase, nʉmo nitigore aꞌmetãrãse, numio meꞌrã ñaꞌarõ weese, yajase, nisoose, ucjase aꞌte nipeꞌtise wãcũsepʉ dʉꞌpocã́tiwijatisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aꞌte peje pũrĩcã Õꞌacʉ̃ ĩꞌorõpʉre masãrẽ ñaꞌarã waꞌacã weesaꞌa. Marĩ na weewʉasenojõrẽ baꞌase dʉporo omocoetirã pũrĩcã, masãrẽ ñaꞌarã waꞌacã weetisaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beꞌro Jesú Genesarepʉ níꞌcʉ Tiro, Sidṍ wãmetise macãrĩpʉ waꞌawĩ. Tocjãrã judío masã nitiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Topʉ eja, niꞌcõ numio topʉ nigṍ Canaácjõ Jesú tiro caricũwãꞌcãtiwõ: —Yʉꞌʉ wiogʉ, Davi dʉporocjʉ̃ wiogʉ pãrãmi, yʉꞌʉre pajañaꞌña. Yʉꞌʉ macõ wãtĩ sãjãnoꞌco nitjĩagõ, pũrõ piꞌetimo, niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesú core yʉꞌtitiyʉꞌrʉocãꞌwĩ. Tojo weerã ʉ̃sã cʉ̃ buꞌerã cʉ̃ pʉꞌto waꞌa, cʉ̃rẽ niwʉ̃: —Marĩ siro ñaꞌarõ caricũwãꞌcãtisamo. Core waꞌadutiya, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Beꞌro Jesú core niwĩ: —Õꞌacʉ̃ yʉꞌʉre Israe curuacjãrã oveja bajudutiꞌcãrã weronojõ nirã́ diaꞌcʉ̃rẽ aꞌmadutigʉ oꞌówĩ, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cʉ̃ tojo nimicã, co cʉ̃rẽ ẽjõpeogo, cʉ̃ pʉꞌto ejaqueꞌawõ. Aꞌtiro niwõ: —Wiogʉ, yʉꞌʉre weetamuña, niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesú core yʉꞌtiwĩ: —Wĩꞌmarã baꞌasere ẽꞌma, diayiare doquecũucã, ñaꞌa niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Cʉ̃ tojo nimicã, co peꞌe cʉ̃rẽ niwõ: —Yʉꞌʉ wiogʉ, tojota niꞌi, nírõ. Diayiapʉta mesapʉ na wiorã baꞌastedijosere baꞌasama. Tojo nígõ, yʉꞌʉ judío masõ nitimicã, judío masã na “Diayi weronojõ nimo” nigõrẽ, judío masãrẽ mʉꞌʉ weetamudʉꞌaꞌquere weetamuña nígõ, tojo niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Co tojo nicã, Jesú niwĩ: —Mʉꞌʉ pũrĩcã ẽjõpeose cʉoyʉꞌrʉaꞌa. Tojo weero mʉꞌʉ níꞌcaronojõta waꞌato, niwĩ. Cʉ̃ tojo nirĩ curata co macõ wãtĩ cõꞌawĩrõnoꞌcopʉ tojaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesú Tiro, Sidṍpʉ níꞌcʉ wijawãꞌcãgʉ̃, Galilea wãmetiri ditara sumutopʉ yʉꞌrʉawĩ. Beꞌro ʉ̃rʉ̃gʉ̃pʉ mʉjãa, ejanujãwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pãjãrã masã cʉ̃ dujiropʉ etawã. Na opa cõꞌñerĩ sijarãrẽ, caperi bajunoꞌtirãrẽ, omocã, dʉꞌpocã dojoriwiꞌiare, ucũmasĩtirãrẽ, noꞌo duti cʉorãnojõrẽ miiejawã. Jesú tiropʉ narẽ miiejacũuowã. Narẽ yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tojo weecã, ucũmasĩtimiꞌcãrã ucũwã. Omocãrĩ, dʉꞌpocãrĩ dojoriwiꞌia yʉꞌrʉonoꞌwã. Opa cõꞌñerĩ sijaꞌcãrã diacjʉ̃ sijawã. Ĩꞌatimiꞌcãrã ĩꞌawã. Tere ĩꞌarã, masã ĩꞌamarĩawã. Beꞌro Õꞌacʉ̃rẽ “Marĩ Israe curuacjãrã wiogʉ tutuayʉꞌrʉami”, ni eꞌcatise oꞌowã. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Beꞌro Jesú ʉ̃sã cʉ̃ buꞌerãrẽ pijio, niwĩ: —Ãꞌrã masãrẽ pajañaꞌa waꞌasaꞌa. Na marĩ meꞌrã nirṍ iꞌtia nʉmʉ yʉꞌrʉꞌʉ. Tojo weerã na baꞌase toja waꞌasama. Na ʉja meꞌrã na ye wiꞌseripʉ tojaacã ʉatisaꞌa. Na baꞌatirã, maꞌapʉ tʉꞌomasĩse peꞌtiqueꞌa waꞌabosama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Cʉ̃ tojo nicã, ʉ̃sã cʉ̃rẽ niwʉ̃: —¿Deꞌro wee ʉ̃sã baꞌase bocabosari ãꞌrã pãjãrãrẽ? Aꞌtore masã marĩma, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesú ʉ̃sãrẽ niwĩ: —¿Dicʉsepaga pã́ cʉoti? niwĩ. Ʉ̃sã cʉ̃rẽ niwʉ̃: —Sietepaga pã́, tojo nicã waꞌi pejetirãcã cʉoꞌo, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ʉ̃sã tojo níca beꞌro masãrẽ dujidutiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Beꞌro pã́ sietepagare, tojo nicã waꞌire mii, cʉ̃ pacʉ Õꞌacʉ̃rẽ eꞌcatise oꞌowĩ. Tuꞌajanʉꞌcõ, pã́rẽ dʉcawaa, ʉ̃sãrẽ oꞌowĩ. Ʉ̃sã peꞌe tere masãrẽ etiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nipeꞌtirã baꞌa, yapiyʉꞌrʉawã. Beꞌro siete piꞌseri na baꞌadʉꞌaꞌquere seeneowʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tere baꞌarã numia, wĩꞌmarã baꞌpaqueonoꞌña marĩrõ ʉmʉa seꞌsaro baꞌparitisetiri mil niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Beꞌro Jesú masãrẽ weꞌeriti, ʉ̃sã yucʉsʉpʉ mʉjãsãjãa, Magdala wãmetiropʉ pẽꞌa waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ʉ̃sã Magdala wãmetiropʉ ejacã, fariseo masã, tojo nicã saduceo masã Jesure ĩꞌarã etawã. Na ¿diacjʉ̃ Õꞌacʉ̃ oꞌóꞌcʉta nimiti? nírã, cʉ̃rẽ Õꞌacʉ̃ tutuaro meꞌrã weeĩꞌodutiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesú peꞌe narẽ yʉꞌtiwĩ: —Mujĩpũ sõꞌasãjãcã, mʉsã “Añurõ cʉ̃ꞌmarõsaꞌa”, niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Boꞌreacã ñiarĩ nʉmʉjo nicã, “Aco pejarosaꞌa”, niꞌi. Ʉꞌmʉarõ cjasere ĩꞌarã, tojo bajuri nʉmʉ nirõsaꞌa nisere masĩꞌi. Tojo nimirã, Õꞌacʉ̃ aꞌtocatero cʉ̃ weeĩꞌose peꞌere masĩweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mʉsã aꞌtocaterocjãrã ñaꞌarã niꞌi. Mʉsã weeĩꞌoña nírã, mʉsã yʉꞌʉre ẽjõpeotisere ĩꞌoꞌo. Mʉsãrẽ weeĩꞌosome. Aꞌte diaꞌcʉ̃rẽ weregʉti. Dʉporocjʉ̃pʉ Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ Jonárẽ waꞌaꞌcaronojõ diaꞌcʉ̃rẽ ĩꞌogʉ̃ti, niwĩ. Tojo níca beꞌro na tiropʉ níꞌcʉ apesepʉ waꞌawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Beꞌro ʉ̃sã ape pãꞌrẽpʉ pẽꞌa waꞌawʉ. Topʉ waꞌarã, pã́ ʉ̃sã baꞌatjere acobojocãrã niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesú ʉ̃sãrẽ niwĩ: —Mʉsã fariseo masã, saduceo masã na ye levadura pã́ bʉcʉacã weesere tʉꞌomasĩña, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Cʉ̃ tojo nicã, ʉ̃sã cʉ̃ nisere tʉꞌotirã, aꞌmerĩ niwʉ̃: —Marĩ pã́rẽ miititiasʉ. Tojo weegʉ marĩrẽ tojo nisami, nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesú ʉ̃sã tojo nisere masĩgʉ̃, aꞌtiro niwĩ: —Mʉsã pã́ marĩ baꞌatjere miititiasʉ nírã, queoro wãcũweꞌe. Mʉsã ẽjõpeose moobutiaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉsã tʉꞌomasĩweti yujupʉ? ¿Yʉꞌʉ niꞌcãmocʉsepaga pã́ meꞌrã niꞌcãmocʉsetiri mil ʉmʉarẽ ecaꞌquere wãcũweti? Peje piꞌseri na baꞌadʉꞌaquere seeneowʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Cãrʉ̃ weeꞌque quẽꞌrãrẽ wãcũweti? Sietepaga pã́ meꞌrã baꞌparitisetiri mil masãrẽ ecawʉ. Tita quẽꞌrãrẽ na baꞌadʉꞌaꞌquere peje piꞌseri seeneowʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Deꞌro weerã mʉsã tʉꞌomasĩtiati? Yʉꞌʉ fariseo masã, saduceo masã ye levadurare ucũgʉ̃, pã́ mejẽtare nigʉ̃ weeapʉ, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cʉ̃ tojo nicãpʉta, ʉ̃sãrẽ tʉꞌomasĩse ejawʉ. —Marĩrẽ levadura pã́ bʉcʉacã weese mejẽtare ucũgʉ̃ weeapĩ; fariseo masã, saduceo masã na nisoose meꞌrã buꞌese peꞌere tʉꞌomasĩato nígʉ̃, tojo niapĩ, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Beꞌro Jesú Cesarea Filipo wãmetiri macãpʉ waꞌawĩ. Topʉ eja, ʉ̃sã cʉ̃ buꞌerãrẽ sẽrĩtiñaꞌwĩ: —Masã yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre ¿deꞌro ucũti? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ʉ̃sã cʉ̃rẽ yʉꞌtiwʉ: —Ãpẽrã “Juã masãrẽ wãmeyeri masʉ̃ nimi”, nima. Ãpẽrã “Dʉporocjʉ̃pʉ Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ Elía nígʉ̃ nisasami”, nima. Ãpẽrã “Jeremía nimi o apĩ Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ nígʉ̃ nisasami”, nima mʉꞌʉrẽ, ni yʉꞌtiwʉ cʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ʉ̃sã tojo nicã, niwĩ: —Mʉsã waro, ¿deꞌro wãcũti yʉꞌʉre? ni sẽrĩtiñaꞌwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Cʉ̃ tojo nicã tʉꞌogʉ, Simó Pedro cʉ̃rẽ yʉꞌtiwĩ: —Mʉꞌʉ Õꞌacʉ̃ beseꞌcʉ Cristo ʉ̃sã yoacã yucueꞌcʉ niꞌi. Õꞌacʉ̃ catinuꞌcũgʉ̃ macʉ̃ niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesú cʉ̃rẽ niwĩ: —Simó, Joná macʉ̃, mʉꞌʉ tojo ucũgʉ̃, diacjʉ̃ta ucũꞌu. Ne niꞌcʉ̃ masʉ̃ mʉꞌʉrẽ tere weretiapĩ. Yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ mʉꞌʉrẽ tere masĩse oꞌoapĩ. Tojo weegʉ eꞌcatiya. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mʉꞌʉrẽ weregʉti. Mʉꞌʉ wãme Pedro ʉ̃tãgã nisĩꞌrĩrõ weeꞌe. Mʉꞌʉ weronojõ ẽjõpeorãrẽ ya curuacjãrãrẽ waꞌacã weegʉti. Wãtĩ cʉ̃ yarã meꞌrã ya curuacjãrãrẽ docaqueꞌacã weesome. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yʉꞌʉ mʉꞌʉrẽ ʉꞌmʉsepʉ marĩ wiogʉ nirõpʉ cja sawire oꞌogʉti. Tojo weero aꞌti nucũcãpʉre mʉꞌʉ cãꞌmotaꞌacã, ʉꞌmʉsepʉ quẽꞌrãrẽ cãꞌmotaꞌanoꞌrõsaꞌa. Mʉꞌʉ aꞌti nucũcãpʉre dʉꞌtecũucã, ʉꞌmʉsepʉ quẽꞌrãrẽ dʉꞌtecũunoꞌrõsaꞌa. Aꞌti nucũcãpʉre “Tojota weeato” nicã, ʉꞌmʉsepʉ quẽꞌrãrẽ tojota waꞌarosaꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Beꞌro Jesú ʉ̃sãrẽ niwĩ: —Ne ãpẽrãrẽ “Cʉ̃ Õꞌacʉ̃ beseꞌcʉ Cristo nimi”, niticãꞌña, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tita meꞌrã Jesú ʉ̃sãrẽ aꞌtiro werenʉꞌcãwĩ: —Yʉꞌʉre Jerusalẽ́pʉ waꞌaro niꞌi. Topʉ judío masã bʉcʉrã, paꞌia wiorã, Moisé ojaꞌquere buꞌeri masã yʉꞌʉre ʉpʉtʉ piꞌeticã weerãsama. Yʉꞌʉre wẽjẽrãsama. Tojo weemicã, iꞌtia nʉmʉ beꞌro masãgʉ̃saꞌa, niwĩ ʉ̃sãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Cʉ̃ tojo nicã tʉꞌogʉ, Pedro Jesure yoacurero wejewãꞌcã, aꞌtiro tuꞌticʉ niwĩ: —Yʉꞌʉ wiogʉ, ne mʉꞌʉ tojo nise waꞌaticãꞌto. Õꞌacʉ̃ tojo waꞌacã cãꞌmotaꞌato, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Beꞌro Jesú majãminʉꞌcã, cʉ̃rẽ nicʉ niwĩ: —Wãtĩ waꞌaya. Mʉꞌʉ tojo nígʉ̃, Õꞌacʉ̃ yʉꞌʉre dutisere cãꞌmotaꞌasĩꞌrĩgʉ̃ weeꞌe. Õꞌacʉ̃ cʉ̃ ʉasere wãcũweꞌe. Masã na wãcũwʉaronojõ peꞌe wãcũꞌu, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Beꞌro Jesú ʉ̃sã ãpẽrãrẽ niwĩ: —Noꞌo yʉꞌʉre ẽjõpeosirutugʉnojõ cʉ̃ weesĩꞌrĩrõnojõ weeticãꞌto. Yʉꞌʉ ʉaro peꞌe weeato. Noꞌo yʉꞌʉre sirutusĩꞌrĩgʉ̃, “Jesure ẽjõpeogʉ, wẽrĩbosaꞌa” nitigʉta sirutuato. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yʉꞌʉre ẽjõpeose meꞌrã ñaꞌarõ yʉꞌrʉsĩꞌrĩtigʉ, yʉꞌʉre ẽjõpeoduꞌugʉnojõ pecameꞌepʉ buꞌiri daꞌre bajurionoꞌgʉ̃sami. Apĩ wẽjẽsere uiti, yʉꞌʉre ẽjõpeonuꞌcũgʉ̃nojõ peꞌe yʉꞌʉ meꞌrã catinuꞌcũgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","»Niꞌcʉ̃ aꞌti turi cjase nipeꞌtisere wapataꞌa, cʉ̃ ejeripõꞌrã peꞌere bajuriogʉ, ¿ñeꞌenojõrẽ wapataꞌabosari? Cʉ̃ pecameꞌepʉ waꞌagʉ, cʉ̃ ya ejeripõꞌrãrẽ deꞌro wee wapayewĩrõmasĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌtiro weegʉti. Yʉꞌʉ pacʉ asistese meꞌrã, cʉ̃rẽ werecoꞌterã meꞌrã aꞌti turipʉre aꞌtigʉti tja. Yʉꞌʉ apaturi aꞌtigʉ, nipeꞌtirãrẽ deꞌro na weeꞌquenʉcʉ̃rẽ wapayegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diacjʉ̃ mʉsãrẽ weregʉti. Niꞌcãrẽrã aꞌtopʉ nirã́ na wẽrĩse dʉporo aꞌtere ĩꞌarãsama. Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ wiogʉ sãjãcã ĩꞌatimirã, wẽrĩsome, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jesú “Yʉꞌʉ wiogʉ nisere ĩꞌarãsaꞌa” níca beꞌro niꞌcã semana yʉꞌrʉwʉ. Titare Pedro, Santiago, cʉ̃ acabiji Juãrẽ ʉ̃rʉ̃gʉ̃ ʉꞌmʉacjʉpʉ miacʉ niwĩ. Na seꞌsaro waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Topʉ na ĩꞌorõpʉ cʉ̃ bajusere dʉcayucʉ niwĩ. Cʉ̃ diapoare mujĩpũ ʉmʉcocjʉ̃ weronojõ asistecʉ niwĩ. Cʉ̃ ye suꞌti añurõ boꞌreyuse waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tojo waꞌari cura maata Moisé, Elía dʉporocjãrãpʉ Jesú meꞌrã ucũcã ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tere ĩꞌagʉ̃, Pedro Jesure nicʉ niwĩ: —Yʉꞌʉ wiogʉ, marĩ aꞌtopʉ nicã añuyʉꞌrʉaꞌa. Mʉꞌʉ ʉacã, ʉ̃sã iꞌtia wiꞌiacã weerãti. Niꞌcã wiꞌi mʉꞌʉ ya wiꞌi, ape wiꞌi Moisé ya wiꞌi, ape wiꞌi Elía ya wiꞌi weerãti, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro tojo ucũrĩ cura niꞌcã oꞌmecurua asisteri curua aꞌti, narẽ tuubiꞌacãꞌcaro niwʉ̃. Ti curuapʉre niꞌcʉ̃ ucũcã tʉꞌocãrã niwã: —Ãꞌrĩ yʉꞌʉ macʉ̃, yʉꞌʉ maꞌigʉ̃ nimi. Cʉ̃ meꞌrã pũrõ eꞌcatiꞌi. Cʉ̃ ucũsere tʉꞌo ẽjõpeoya, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tere tʉꞌorã, cʉ̃ buꞌerã ʉpʉtʉ ʉcʉarã, diꞌtapʉ muꞌrĩqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Beꞌro Jesú na pʉꞌto waꞌa, narẽ ñeꞌeñaꞌa, nicʉ niwĩ: —Wãꞌcãnʉꞌcãña. Uiticãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Beꞌro na ĩꞌacã, ãpẽrã ne marĩcãrã niwã. Jesú niꞌcʉ̃ta nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na tigʉpʉ níꞌcãrã dijaticã, Jesú narẽ nicʉ niwĩ: —Mʉsã niꞌcãrõacã ĩꞌaꞌquere ne ãpẽrãrẽ wereticãꞌña. Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ wẽrĩ masã́ca beꞌropʉ wereya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cʉ̃ tojo nicã, cʉ̃ buꞌerã sẽrĩtiñaꞌcãrã niwã: —¿Deꞌro weerã Moisé ojaꞌquere buꞌeri masã “Masãrẽ yʉꞌrʉoacjʉ aꞌtise dʉporo Elía aꞌtimʉꞌtãgʉ̃sami” nisari? ");
INSERT INTO tuoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesú narẽ yʉꞌticʉ niwĩ: —Mʉsã nírõnojõta Elía aꞌtimʉꞌtãgʉ̃sami. Cʉ̃ nipeꞌtisere apomʉꞌtãgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yʉꞌʉ peꞌe aꞌtiro nigʉ̃ti. Elía aꞌtitojacʉ niwĩ. Cʉ̃rẽ masã ĩꞌamasĩticãrã niwã. Na cʉ̃rẽ noꞌo ʉaro weesĩꞌrĩsere weecãrã niwã. Cʉ̃rẽ weeꞌcaronojõta yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ quẽꞌrãrẽ piꞌeticã weerãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cʉ̃ tojo nicãpʉ, cʉ̃ buꞌerã tʉꞌomasĩcãrã niwã. “Cʉ̃ Elía aꞌtitojacʉ niwĩ nígʉ̃, Juã masãrẽ wãmeyeri masʉ̃rẽ nigʉ̃ weesami”, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Beꞌro na ʉ̃rʉ̃gʉ̃pʉ níꞌcãrã masã waꞌteropʉ dijatawã. Titare niꞌcʉ̃ aꞌti, Jesú tiropʉ ejaqueꞌawĩ. Cʉ̃rẽ aꞌtiro niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Yʉꞌʉ wiogʉ, yʉꞌʉ macʉ̃rẽ pajañaꞌña. Cʉ̃ wãcũña marĩrõ wẽrĩamʉjãmi. Ʉpʉtʉ waro piꞌetiyʉꞌrʉmajãmi. Pejetiri pecameꞌepʉ doquequeꞌa, diapʉ quẽꞌrãrẽ doqueñojãmʉjãmi. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cʉ̃rẽ mʉꞌʉ buꞌerã tiropʉ miiejamiapʉ. Na cʉ̃rẽ yʉꞌrʉomasĩtiama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Beꞌro Jesú masãrẽ niwĩ: —Mʉsã ẽjõpeose moorã ñaꞌarã niꞌi. Yʉꞌʉ mʉsãrẽ yoacã buꞌemicã, ne tʉꞌomasĩweꞌe yujupʉ. ¿Noꞌocãꞌrõ yoacã mʉsã yʉꞌʉre ẽjõpeoticã wãcũtutuagʉsari? Cʉ̃ wĩꞌmagʉ̃rẽ yʉꞌʉ tiro miitia, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Topʉ miiejacã, wãtĩ wĩꞌmagʉ̃pʉ níꞌcʉre cõꞌawĩrõwĩ. Cʉ̃ tojo weeri curata wĩꞌmagʉ̃ yʉꞌrʉonoꞌcʉpʉ tojawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Beꞌro ʉ̃sã cʉ̃ buꞌerã ãpẽrã tʉꞌotiropʉ cʉ̃rẽ sẽrĩtiñaꞌwʉ̃: —¿Deꞌro weerã ʉ̃sã wãtĩrẽ cõꞌamasĩtiapari? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesú ʉ̃sãrẽ niwĩ: —Mʉsã yʉꞌʉre añurõ ẽjõpeotise ye buꞌiri cʉ̃rẽ cõꞌawĩrõmasĩtiapã. Diacjʉ̃ mʉsãrẽ weregʉti. Mʉsã mostaza capeacã weronojõ cãꞌrõacã ẽjõpeose cʉorã, aꞌtigʉ ʉ̃rʉ̃gʉ̃rẽ “Aperopʉ waꞌaya”, nímasĩbosaꞌa. Mʉsã tojo nicã, aperopʉ waꞌarosaꞌa. Mʉsã diacjʉ̃ta ẽjõpeocãma, nipeꞌtisere weeta basiorosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ãꞌrĩ wãtĩ sãjãgʉ̃nojõrẽ Õꞌacʉ̃rẽ sẽrĩ, beꞌtise meꞌrã diaꞌcʉ̃ cõꞌawĩrõta basioꞌo, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Beꞌro ʉ̃sã Galileapʉ sijarã waꞌawʉ. Topʉ Jesú ʉ̃sãrẽ niwĩ: —Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre wiorãpʉre oꞌorãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yʉꞌʉre wẽjẽrãsama. Na tojo weemicã, iꞌtia nʉmʉ beꞌro masãgʉ̃saꞌa tja, niwĩ. Ʉ̃sã cʉ̃ “Yʉꞌʉre wẽjẽrãsama” nicã tʉꞌorã, pũrõ bʉjawetiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Beꞌro Jesú, ʉ̃sã cʉ̃ buꞌerã Capernau wãmetiri macãpʉ waꞌawʉ. Ʉ̃sã topʉ ejari curare Õꞌacʉ̃ wiꞌi cjase niatjere niyeru wapaseeri masã Pedro tiropʉ waꞌawã. Aꞌtiro sẽrĩtiñaꞌcãrã niwã cʉ̃rẽ: —¿Mʉsãrẽ buꞌegʉ Õꞌacʉ̃ wiꞌi cjase niatjere niyeru wapayeweti? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro narẽ yʉꞌticʉ niwĩ: —Wapayesami, nicʉ niwĩ. Beꞌro Pedro Jesú nirĩ wiꞌipʉ sãjãejawĩ. Cʉ̃ Jesure sẽrĩtiñaꞌgʉ̃ti weeri cura Jesú peꞌe cʉ̃rẽ ucũweꞌocãꞌwĩ: —¿Deꞌro tʉꞌoñaꞌti, Simó? ¿Aꞌti ʉmʉcocjãrã wiorã niyeru ʉarã, na acawererãrẽ sẽrĩsari, o aperocjãrãpʉre sẽrĩsarine? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro cʉ̃rẽ yʉꞌtiwĩ: —Aperocjãrãpʉre wapayedutisama, niwĩ. Jesú cʉ̃rẽ niwĩ: —To pũrĩcãrẽ na acawererãrẽ sẽrĩtisama. Tojo weero yʉꞌʉ Õꞌacʉ̃ macʉ̃ niyucã, cʉ̃ ya wiꞌi cjase niatjere niyeru sẽrĩmasĩtisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tojo nimicã, narẽ mejẽcã wãcũdutitigʉ wapayegʉti. Mʉꞌʉ ditarapʉ wẽjẽrĩ da mii, waꞌi wẽjẽgʉ̃ waꞌaya. Baꞌamʉꞌtãgʉ̃rẽ wejemorõña. Cʉ̃ ʉseropʉ niyeru cujire bocagʉsaꞌa. Ti cuji meꞌrã marĩ pʉarã yere wapayegʉ waꞌaya, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Õꞌacʉ̃ wiꞌi cjase wapaseeri masãrẽ Pedro wapayegʉ waꞌacaterore ʉ̃sã Jesú tiropʉ waꞌa, cʉ̃rẽ niwʉ̃: —Ʉꞌmʉsepʉre ¿noanojõ ʉ̃sã mʉꞌʉ besecṹúꞌcãrã ãpẽrã yʉꞌrʉoro niyʉꞌrʉnʉꞌcãgʉ̃sari? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ʉ̃sã tojo nicã tʉꞌogʉ, Jesú niꞌcʉ̃ wĩꞌmagʉ̃rẽ pijio, ʉ̃sã tiropʉ nʉꞌcõwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ʉ̃sãrẽ niwĩ: —Mʉsãrẽ diacjʉ̃ weregʉti. Ãpẽrã yʉꞌrʉoro niyʉꞌrʉnʉꞌcãsĩꞌrĩsere duꞌucãꞌña. Mʉsã tere wãcũnuꞌcũrã, ãꞌrĩ weronojõ nitirã, ʉꞌmʉsepʉ yʉꞌʉ wiogʉ niatjopʉ waꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aꞌtiro niꞌi. Noꞌo ãꞌrĩ wĩꞌmagʉ̃ weronojõ ãpẽrã yʉꞌrʉoro nisere wãcũtigʉnojõ cʉ̃́ta yʉꞌʉ niatjopʉre ãpẽrã yʉꞌrʉoro niyʉꞌrʉnʉꞌcãgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Apeye quẽꞌrãrẽ weregʉti. Yʉꞌʉre maigʉ̃nojõ niꞌcʉ̃ ãꞌrĩ wĩꞌmagʉ̃rẽ ñeꞌegʉ̃ weronojõ weemi. Cʉ̃rẽ ñeꞌegʉ̃, yʉꞌʉreta ñeꞌegʉ̃ weemi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesú apeye ʉ̃sãrẽ werenemowĩ: —Noꞌo yʉꞌʉre ẽjõpeogʉ wĩꞌmagʉ̃rẽ ñaꞌarõ weecã weegʉ́ ʉpʉtʉ buꞌiri daꞌrenoꞌgʉ̃sami. Ʉ̃tãgã pajicja cʉ̃ wãmʉtapʉ dʉꞌteyoo, cʉ̃rẽ maa pajiri maapʉ doqueñocã, nemorõ añubosaꞌa. Tojo weecã, cʉ̃ maata wẽrĩa waꞌa, dojorẽnemotibosami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Masãrẽ ñaꞌarõ weecã weese ñaꞌabutiaꞌa. Ñaꞌarõ weenuꞌcũcãꞌrãsama, wéérã peꞌea. Mejõ tojo weegʉnojõ ʉpʉtʉ waro buꞌiri daꞌrenoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","»Aꞌtiro weeya. Mʉsã omocã, mʉsã dʉꞌpocã meꞌrã ñaꞌarõ weesĩꞌrĩrã, dʉtecõꞌaboꞌcaro weronojõ ñaꞌarõ weeduꞌucãꞌña. Mʉsã niꞌcã omocã meꞌrã o niꞌcã dʉꞌpocã meꞌrã ʉꞌmʉsepʉ waꞌacã, nemorõ añuꞌu. Pʉa omocã meꞌrã, pʉa dʉꞌpocã meꞌrã pecameꞌepʉ waꞌacã peꞌere, ñaꞌayʉꞌrʉabosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉsã caperi meꞌrã mejãrõta ñaꞌarõ weesĩꞌrĩrã, mʉsã caperire orewee cõꞌaboꞌcaro weronojõ ñaꞌasere ĩꞌaduꞌucãꞌña. Mʉsã niꞌcã capea meꞌrã ʉꞌmʉsepʉ waꞌacã, nemorõ añuꞌu. Mʉsã pecameꞌepʉ pʉa capea meꞌrã waꞌacã peꞌere, ñaꞌayʉꞌrʉabosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","»Ãꞌrã wĩꞌmarãnojõrẽ tojo ĩꞌacõꞌaticãꞌña. Aꞌtiro niꞌi. Ʉꞌmʉsecjãrã Õꞌacʉ̃rẽ werecoꞌterã ãꞌrã wĩꞌmarãrẽ coꞌterã yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ ĩꞌorõpʉ ninuꞌcũma. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Masã Õꞌacʉ̃rẽ wãcũtirã oveja bajudutiꞌcãrã weronojõ nima. Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ narẽ yʉꞌrʉogʉ aꞌtigʉ weewʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","»Yʉꞌʉ weresere ¿deꞌro tʉꞌoñaꞌti? Niꞌcʉ̃ cien oveja cʉogʉ niꞌcʉ̃ bajuduticã, ãpẽrã dʉꞌsarã noventa y nuevere opa buꞌpa na baꞌaropʉ cũusami. Beꞌro apĩ bajudutiꞌcʉre aꞌmagʉ̃ waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cʉ̃rẽ bocagʉ, pũrõ eꞌcatisami. Ãpẽrã noventa y nueve bajudutitiꞌcãrã nemorõ cʉ̃ meꞌrã eꞌcatisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mejãrõta marĩ pacʉ ʉꞌmʉsepʉ nigʉ̃́ ne niꞌcʉ̃ ãꞌrã wĩꞌmarãnojõrẽ pecameꞌepʉ waꞌacã ʉatimi, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesú werenemowĩ: —Mʉꞌʉ acaweregʉ mʉꞌʉrẽ ñaꞌarõ weecã, mʉꞌʉ seꞌsaro cʉ̃ tiropʉ weregʉ waꞌaya. Cʉ̃ ñaꞌarõ weeꞌquere masĩcã weeya. Cʉ̃ “Yʉꞌʉ ñaꞌarõ weeapʉ” ni tʉꞌoñaꞌcã, mʉsã apaturi aꞌmerĩ ucũ, eꞌcatirãsaꞌa tja. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cʉ̃ yʉꞌtiticãma, niꞌcʉ̃ o pʉarãrẽ pijio, cʉ̃ tiropʉ waꞌaya. Na tʉꞌoropʉ wereya cʉ̃ mʉꞌʉrẽ ñaꞌarõ weeꞌquere. Tojo weero Õꞌacʉ̃ ye queti ojáca pũrĩ níꞌcaronojõta pʉarã o iꞌtiarã tʉꞌoropʉ “Diacjʉ̃ta niꞌi”, ni masĩnoꞌrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na quẽꞌrãrẽ yʉꞌtiticã, nipeꞌtirã yʉꞌʉre ẽjõpeorã na nerẽrõpʉ wereya. Na quẽꞌrãrẽ yʉꞌtiticã, yʉꞌʉre ẽjõpeotigʉ o wiorãrẽ niyeru wapaseebosari masʉ̃rẽ weronojõ tʉꞌoñaꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","»Diacjʉ̃ mʉsãrẽ weregʉti. Noꞌo mʉsã aꞌti nucũcãpʉ dʉꞌtecũucã, ʉꞌmʉsepʉ quẽꞌrãrẽ dʉꞌtecũunoꞌrõsaꞌa. Aꞌti nucũcãpʉre “Tojota weeato” nicã, ʉꞌmʉsepʉ quẽꞌrãrẽ tojota waꞌarosaꞌa, niwĩ. Cʉ̃ tojo nígʉ̃, mʉsã “Buꞌiritimi” o “Buꞌiri marĩmi” nímasĩrãsaꞌa nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jesú ninemowĩ: —Apeyere weregʉti. Pʉarã “Marĩ aꞌtenojõrẽ Õꞌacʉ̃rẽ sẽrĩrã” nicã, yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ mʉsã sẽrĩrõnojõta weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Noꞌo pʉarã o iꞌtiarã yʉꞌʉre ẽjõpeorã nerẽcã, yʉꞌʉ na waꞌteropʉ nigʉ̃ti, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tojo nicã tʉꞌogʉ, Pedro Jesú tiro waꞌa, sẽrĩtiñaꞌwĩ: —Wiogʉ, yʉꞌʉ acaweregʉ yʉꞌʉre ñaꞌarõ weecã, ¿dicʉsetiri cʉ̃rẽ acobojogʉsari? ¿Sietetiripʉta cʉ̃ ñaꞌarõ weesere acobojosari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesú cʉ̃rẽ yʉꞌtiwĩ: —“Ticʉsetiri acobojoya”, niweꞌe. Tojo nírõnojõ oꞌogʉ, “Na ñaꞌarõ weesetisetirinʉcʉ̃ acobojoya”, nigʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","»Tojo weegʉ mʉsãrẽ yʉꞌʉ pacʉ cʉ̃ acobojose cjasere weregʉti. Cʉ̃ niꞌcã diꞌta wiogʉ weronojõ nimi. Ti diꞌta wiogʉ cʉ̃rẽ daꞌracoꞌterã na wapamoosere apogʉtigʉ pijiosami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cʉ̃ narẽ wapaseenʉꞌcãrĩ cura niꞌcʉ̃ pajiro waro wapamoogʉ̃rẽ miiwãꞌcãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cʉ̃ deꞌro wee wapayeta basioticã ĩꞌagʉ̃, wiogʉ cʉ̃rẽ, cʉ̃ nʉmorẽ, cʉ̃ põꞌrãrẽ, nipeꞌtise cʉ̃ cʉosere ãpẽrãpʉre duaturiadutisami. Cʉ̃ wapamoosere wapayedʉodutigʉ tojo weesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tere ĩꞌagʉ̃, daꞌracoꞌtegʉ wiogʉ tiro ejaqueꞌa, nisami: “Wiogʉ, yʉꞌʉre pajañaꞌcureya. Yʉꞌʉ wapayepeꞌocʉ̃ti”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Cʉ̃ tojo nicã tʉꞌogʉ, aꞌtiro weesami. Cʉ̃rẽ pajañaꞌgʉ̃, cʉ̃ wapamooꞌquere cõꞌa, cʉ̃rẽ duꞌucãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tojo wééca beꞌroacã waꞌa, apĩ cʉ̃ meꞌrãcjʉ̃ daꞌracoꞌtegʉre bocaejasami. Cʉ̃ peꞌe cʉ̃rẽ cãꞌrõacã wapamoosami. Beꞌro cʉ̃rẽ wapayedutigʉ ʉpʉtʉ wãmʉtapʉ ñeꞌesami. “Mʉꞌʉ wapamoosere wapayebaqueꞌoya”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","»Cʉ̃ tojo nicã tʉꞌogʉ, cʉ̃ weeꞌcaro weronojõ cʉ̃ dʉporo ejaqueꞌa, nisami: “Yʉꞌʉre pajañaꞌcureya. Mʉꞌʉrẽ wapayepeꞌocʉ̃ti”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Apĩ peꞌe ne ʉatisami. Maata cʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ miaa, sõrõdutisami. “Cʉ̃ wapayepeꞌocãꞌpʉ, duꞌuwĩrõña”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Beꞌro ãpẽrã daꞌracoꞌterã cʉ̃ tojo weesere ĩꞌarã, ne tʉꞌsatisama. Tojo weerã na wiogʉpʉre tere werepeꞌocãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tere tʉꞌogʉ, wiogʉ cʉ̃rẽ pijidutioꞌosami. Cʉ̃rẽ nisami: “Daꞌracoꞌtegʉ queoro weetigʉ niꞌi. Mʉꞌʉ yʉꞌʉre sẽrĩcã, nipeꞌtise mʉꞌʉ wapamooꞌque pacare acobojopeꞌocãꞌpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉꞌʉ quẽꞌrã yʉꞌʉ mʉꞌʉrẽ pajañaꞌcaronojõ mʉꞌʉ meꞌrãcjʉ̃rẽ pajañaꞌboapã”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wiogʉ ʉpʉtʉ waro uagʉ, cʉ̃rẽ pũrõ buꞌiri daꞌresami. Buꞌiri daꞌreri wiꞌipʉ cʉ̃rẽ piꞌeticã weedutisami. Téé nipeꞌtise cʉ̃ wapamoosere wapayepeꞌotigʉ, topʉ ninuꞌcũgʉ̃sami, ni werewĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Beꞌro Jesú tere wéréca beꞌro niwĩ: —Yʉꞌʉ pacʉ ʉꞌmʉsepʉ nigʉ̃́ mʉsã acawererãrẽ diacjʉ̃ acobojoticã, tojota weegʉsami mʉsãrẽ, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesú ãpẽrãrẽ aꞌmerĩ acobojosere ucṹca beꞌro ʉ̃sã aꞌtiro weewʉ. Galilea diꞌtapʉ níꞌcãrã ʉ̃sã Judea diꞌtapʉ Jordã́ wãmetiri maa mujĩpũ mʉjãtiro ape pãꞌrẽpʉ pẽꞌawʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Topʉ waꞌacã, pãjãrã masã Jesure sirutuwã. Narẽ dutitirãrẽ yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Narẽ yʉꞌrʉocã ĩꞌarã, fariseo masã Jesure buꞌiri bocasĩꞌrĩrã, cʉ̃ tiro waꞌa, sẽrĩtiñaꞌwã: —¿Niꞌcʉ̃ noꞌo mejõ niseacã meꞌrã cʉ̃ nʉmorẽ cõꞌamasĩsari? ¿Marĩrẽ dutise tojo niti? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesú narẽ yʉꞌtiwĩ: —¿Mʉsã Õꞌacʉ̃ ye queti ojáca pũrĩrẽ buꞌemirã, masĩweti? Õꞌacʉ̃ nipeꞌtise cʉ̃ ne waro weenʉꞌcãcateropʉ ʉmʉ, numio weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tuꞌajanʉꞌcõ, aꞌtiro nicʉ niwĩ: “Tojo weegʉ ʉmʉ cʉ̃ pacʉre, cʉ̃ pacore wija, cʉ̃ nʉmo meꞌrã nigʉ̃sami. Na pʉarã niꞌcã upʉ weronojõ nirãsama”, nicʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tojo weerã na pʉarã nitima. Niꞌcã upʉta nima. Tojo weerã Õꞌacʉ̃ aꞌmesʉꞌoꞌcãrãrẽ masã dʉcawaaticãꞌrõʉaꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Cʉ̃ tojo nicã tʉꞌorã, fariseo masã sẽrĩtiñaꞌwã tja: —To pũrĩcãrẽ ¿deꞌro weegʉ Moisé aꞌtiro nipari? “Niꞌcʉ̃ cʉ̃ nʉmorẽ cõꞌagʉ̃, ‘Aꞌte ye buꞌiri mʉꞌʉrẽ cõꞌaꞌa’ nirĩ pũrĩrẽ ojaoꞌoroʉaꞌa”, ni ojacʉ niwĩ, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesú narẽ niwĩ: —Mʉsã ñecʉ̃sʉmʉa ejeripõꞌrã bʉtise ye buꞌiri Moisé na nʉmosãnumiarẽ cõꞌacã, cãꞌmotaꞌaticʉ niwĩ. Tojo nimicã, Õꞌacʉ̃ ne waropʉta “Aꞌmerĩ cõꞌaña”, niticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yʉꞌʉ cʉ̃ nʉmorẽ cõꞌagʉ̃rẽ aꞌtiro nigʉ̃ti. Co apĩ meꞌrã ñaꞌarõ weetimicã, cõꞌagʉ̃nojõ apegore nʉmotigʉ, cʉ̃ nʉmo nitigo meꞌrã aꞌmetãrãgʉ̃ weronojõ tojasami. Noꞌo marãpʉ cõꞌanoꞌcore nʉorẽgʉ̃nojõ quẽꞌrã mejãrõta tja cʉ̃ nʉmo nitigore aꞌmetãrãgʉ̃ weronojõ nisami. Õꞌacʉ̃ core “Nimʉꞌtãꞌcʉ nʉmo nimo yujupʉ”, ni ĩꞌasami. Na tojo wéérã, Õꞌacʉ̃ cʉ̃ dutisere yʉꞌrʉnʉꞌcãrã weema, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Cʉ̃ tojo nicã tʉꞌorã, ʉ̃sã cʉ̃ buꞌerã niwʉ̃: —Tojo nicã pũrĩcãrẽ marĩ nʉmotiticã, nemorõ añusaꞌa, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesú ʉ̃sãrẽ niwĩ: —Nipeꞌtirã nʉmo marĩrã nímasĩtisama. Õꞌacʉ̃ nʉmo marĩrã nímasĩato níꞌcãrã diaꞌcʉ̃ nímasĩsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ãpẽrã aꞌte ye buꞌiri nʉmotitisama. Ãpẽrãrẽ dojoriwiꞌia bajuaꞌque buꞌiri nʉmotita basiotisaꞌa. Ãpẽrãrẽ nʉmotidutitirã na upʉ cjasere yejecõꞌanoꞌcãrã nisama. Tojo weerã na nʉmotimasĩtisama. Ãpẽrã Õꞌacʉ̃ ye cjase diaꞌcʉ̃rẽ weesĩꞌrĩrã nʉmotitisama. “Tojo nʉmo marĩgʉ̃ nigʉ̃ti” nigʉ̃nojõ nʉmo marĩgʉ̃ tojato, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Beꞌro ãpẽrã na põꞌrãrẽ Jesú tiropʉ miiejawã. Narẽ ñapeo, Õꞌacʉ̃rẽ sẽrĩbosadutirã tojo weewã. Na tojo weecã, ʉ̃sã wĩꞌmarãrẽ miiejarãrẽ tuꞌtiwʉ: —Cʉ̃rẽ caribotirãta, nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ʉ̃sã tojo nicã, Jesú ʉ̃sãrẽ niwĩ: —Wĩꞌmarãrẽ yʉꞌʉ tiro aꞌticã duꞌuoꞌoya. Narẽ cãꞌmotaꞌaticãꞌña. Wĩꞌmarã marĩnojõrẽ añurõ ẽjõpeoma. Ãpẽrã quẽꞌrã wĩꞌmarã weronojõ yʉꞌʉre ẽjõpeorã yʉꞌʉ pacʉ wiogʉ nirõpʉ waꞌarãsama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Beꞌro wĩꞌmarãrẽ ñapeo, sẽrĩbosawĩ. Tuꞌajanʉꞌcõ, ʉ̃sã apesepʉ waꞌa waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Beꞌro niꞌcʉ̃ maꞌmʉ Jesure ĩꞌagʉ̃ ejawĩ. Cʉ̃rẽ sẽrĩtiñaꞌwĩ: —Mʉꞌʉ masãrẽ buꞌegʉ añugʉ̃ niꞌi. Yʉꞌʉ catinuꞌcũacjʉ ¿ñeꞌenojõ añusere weegʉsari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesú cʉ̃rẽ yʉꞌtiwĩ: —¿Deꞌro weegʉ yʉꞌʉre añuse cjasere sẽrĩtiñaꞌti? Niꞌcʉ̃ta añugʉ̃ nimi. Cʉ̃ Õꞌacʉ̃ nimi. Mʉꞌʉ catinuꞌcũsĩꞌrĩgʉ̃, Õꞌacʉ̃ dutise cũuꞌquere weeya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Maꞌmʉ yʉꞌtiwĩ: —¿Disenojõrẽ weegʉsari? Jesú cʉ̃rẽ niwĩ: —Masãrẽ wẽjẽcõꞌaticãꞌña. Apĩ nʉmorẽ aꞌmetãrãticãꞌña. Yajaticãꞌña. Ãpẽrã ye cjasere nisooticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉꞌʉ pacʉre, mʉꞌʉ pacore ẽjõpeoya. Mʉꞌʉ basu maꞌirõnojõta ãpẽrãrẽ maꞌiña, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Maꞌmʉ Jesure yʉꞌtiwĩ: —Yʉꞌʉ wĩꞌmagʉ̃pʉta aꞌtere queoro weemʉjãtiwʉ. ¿Ñeꞌenojõ apeyenojõ yʉꞌʉ weenemogʉ̃sari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesú cʉ̃rẽ niwĩ: —Mʉꞌʉ Õꞌacʉ̃ dutisere weepeꞌosĩꞌrĩgʉ̃, nipeꞌtise mʉꞌʉ cʉosere duapeꞌocjʉ̃ waꞌaya. Duatoja, te duaꞌque wapare pajasecʉorãrẽ oꞌoya. Mʉꞌʉ tojo weegʉ ʉꞌmʉsepʉ peje añuse cʉogʉsaꞌa. Tojo weetojanʉꞌcõ, yʉꞌʉre sirutugʉ aꞌtia, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cʉ̃ tojo nicã tʉꞌogʉ, maꞌmʉ peje cʉogʉ nitjĩagʉ̃ tere maꞌiyʉꞌrʉgʉ, bʉjawetise meꞌrã dajatojaawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cʉ̃ waꞌáca beꞌro Jesú ʉ̃sãrẽ niwĩ: —Diacjʉ̃ mʉsãrẽ weregʉti. Peje cʉogʉ Õꞌacʉ̃ wiogʉ nirõpʉ ʉꞌmʉsepʉ waꞌacã, diasa niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Apaturi mʉsãrẽ nigʉ̃ti tja. Cameyo wãmetigʉjo awiga yuta da pĩꞌosõrõrĩ pepʉ sãjãa yʉꞌrʉtẽrĩcã, diasa niꞌi. Yʉꞌʉ pacʉ wiogʉ nirõpʉ peje cʉogʉ waꞌacã peꞌema, totá nemorõ diasa niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cʉ̃ tojo nicã tʉꞌorã, ʉ̃sã tʉꞌomarĩa waꞌawʉ. Ʉ̃sã aꞌmerĩ sẽrĩtiñaꞌwʉ̃: —To pũrĩcãrẽ ¿noanojõ peꞌe Õꞌacʉ̃ tiropʉ waꞌamasĩrãsari? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesú ʉ̃sãrẽ ĩꞌagʉ̃ta ĩꞌa, niwĩ: —Masã na basu weetutuase meꞌrã yʉꞌrʉmasĩtisama. Õꞌacʉ̃ pũrĩcãrẽ basioꞌo. Cʉ̃́ma ne apeyenojõ weeta basiotise marĩꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Cʉ̃ tojo nicã tʉꞌogʉ, Pedro niwĩ: —Wiogʉ, ʉ̃sã peꞌe mʉꞌʉrẽ siruturã, nipeꞌtise ʉ̃sã cʉomiꞌquere duꞌucũupeꞌocãꞌwʉ̃. Ʉ̃sã tojo weeꞌque wapare ¿Õꞌacʉ̃ ñeꞌenojõrẽ oꞌogʉsari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesú ʉ̃sãrẽ niwĩ tja: —Diacjʉ̃ mʉsãrẽ nigʉ̃ti. Õꞌacʉ̃ aꞌti turire ne waropʉ weeꞌcaro weronojõ apaturi weecã, yʉꞌʉ Õꞌacʉ̃ macʉ̃ wiogʉ sãjãgʉ̃́saꞌa. Tojo yʉꞌʉ weecã, mʉsã quẽꞌrã yʉꞌʉre dutitamurãsaꞌa. Tojo nicã mʉsã yʉꞌʉre ẽjõpeorã doce cururi Israe cururicjãrãrẽ dutirãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ãpẽrã nipeꞌtirã yʉꞌʉre ẽjõpeose buꞌiri na ye wiꞌserire, na acawererãrẽ, na pacʉsʉmʉarẽ, na põꞌrãrẽ, na ye diꞌtare duꞌucũuwãꞌcãrã quẽꞌrãrẽ aꞌtiro waꞌarosaꞌa. Peje waro na cõꞌawãꞌcãꞌque nemorõ ñeꞌenemorãsama. Tojo nicã Õꞌacʉ̃ meꞌrã catinuꞌcũrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tojo nimicã, pãjãrã niꞌcãrõacãrẽ wiorã weronojõ nirã́ beꞌropʉre mejõ nirã nirãsama. Pãjãrã niꞌcãrõacãrẽ mejõ nirã peꞌe quẽꞌrã beꞌropʉre wiorã weronojõ nirãsama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesú beꞌropʉ cʉ̃ oꞌoatjere queose meꞌrã werenemowĩ: —Ʉꞌmʉsepʉ yʉꞌʉre ẽjõpeorãrẽ oꞌoatje aꞌtiro weronojõ niꞌi. Niꞌcʉ̃ ʉꞌse wese cʉose weronojõ niꞌi. Cʉ̃ ñamiacãcure ʉꞌse wiꞌreajãrẽ aꞌmasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Narẽ bocagʉ, “Niꞌcã nʉmʉ wapayewʉaronojõ mʉsãrẽ wapayegʉti”, nisami. Na yʉꞌtíca beꞌro narẽ cʉ̃ ya wesepʉ daꞌradutigʉ oꞌócãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Beꞌro nueve nicã ãpẽrã daꞌrajãrẽ aꞌmanemogʉ̃ waꞌasami. Topʉ macã decopʉ daꞌrase moorã dujirãrẽ bocaejasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bocaeja, narẽ nisami: “Mʉsã quẽꞌrã ya wese ʉꞌse wesepʉ daꞌrarã waꞌaya. Mʉsãrẽ queoro wapayegʉti”, nisami. Cʉ̃ tojo nicã tʉꞌorã, na “Jaʉ” ni, na quẽꞌrã daꞌrarã waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Beꞌro dajaritero nicã, tojo nicã ñamicaꞌa tres nicã mejãrõta aꞌmagʉ̃ waꞌa, narẽ oꞌósami tja. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Beꞌro tja cinco nicã macã decopʉ waꞌasami. Topʉ ãpẽrã daꞌrase moorã nibajaqueꞌatirãrẽ bocaejasami. Bocaejagʉ, nisami: “¿Deꞌro weerã mʉsã daꞌrase niꞌcãrĩ dujinaꞌiati?” nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na yʉꞌtisama: “Ãpẽrã ʉ̃sãrẽ ‘Daꞌrarã waꞌaya’, nitiama. Tojo weerã daꞌraweꞌe”, nisama. Tojo nicã tʉꞌogʉ, wese wiogʉ narẽ nisami: “Mʉsã quẽꞌrã ya wesepʉ daꞌrarã waꞌaya. Queoro wapayegʉti”, nisami. Tojo weerã na quẽꞌrã daꞌrarã waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","»Ñamipʉ ti wese wiogʉ sʉꞌori daꞌragʉre pijio, nisami: “Daꞌrarãrẽ pijíne, wapayeya. Beꞌropʉ ejaꞌcãrãrẽ wapayemʉꞌtãña. Beꞌro ñamiacãcure daꞌranʉꞌcãꞌcãrãrẽ wapayetuꞌajanʉꞌcõña”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tojo weegʉ aꞌtiro weesami. Cinco nicãpʉ wesepʉ daꞌranʉꞌcãꞌcãrãrẽ pijiomʉꞌtãsami. Niꞌcã nʉmʉ daꞌrase wapa wapayewʉaronojõ narẽ wapayesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Beꞌro boꞌreacã daꞌranʉꞌcãꞌcãrã “Ʉ̃sã na nemorõ wapataꞌarãsaꞌa”, nimisama. Tojo nimicã, na wãcũꞌcaronojõ waꞌatisaꞌa. Na quẽꞌrã mejãrõta wapataꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tojo weerã ti wese wiogʉ meꞌrã tʉꞌsatirã, aꞌtiro nisama: ");
INSERT INTO tuoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ãꞌrã beꞌropʉ daꞌrarã ejaꞌcãrã yoaticã niꞌcã horata daꞌrama. Ʉ̃sã pũrĩcã yoacã asise poo, daꞌranaꞌitõꞌoapʉ. Tojo weemicã, ʉ̃sãrẽ wapayeꞌcaronojõta na quẽꞌrãrẽ wapayeapʉ”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wiogʉ peꞌe niꞌcʉ̃ tojo bʉsʉnuꞌcũgʉ̃rẽ aꞌtiro nisami: “Yʉꞌʉ meꞌrãcjʉ̃, mʉꞌʉrẽ ñaꞌarõ weegʉ weeweꞌe. Mʉꞌʉ daꞌrase dʉporo ‘Niꞌcã nʉmʉ daꞌrawapataꞌawʉaronojõ wapataꞌagʉsaꞌa’, ninoꞌtojapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tojo weegʉ mʉꞌʉ wapataꞌaꞌquere ñeꞌe, tojaa waꞌaya. Yʉꞌʉ ãꞌrĩ beꞌropʉ daꞌragʉ aꞌtiꞌcʉre mʉꞌʉrẽ wapayeꞌcaronojõ wapayegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yé niyeru niapʉ. Tojo weegʉ yʉꞌʉ ʉaronojõ wapayemasĩꞌi. ¿Yʉꞌʉ masãrẽ pajañaꞌcã ʉogʉ weeti?” nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","»Aꞌtiro niꞌi. Yarã sãjãmʉꞌtãꞌcãrã, na beꞌro ẽjõpeoꞌcãrã quẽꞌrãrẽ mejãrõta Õꞌacʉ̃ añusere oꞌogʉsami. Tojo weerã nimʉꞌtãꞌcãrã “Ʉ̃sãrẽ oꞌonemogʉ̃sami”, nímasĩsome, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Beꞌro ʉ̃sã Jesú meꞌrã Jerusalẽ́ waꞌari maꞌapʉ waꞌawʉ. Ʉ̃sãrẽ, cʉ̃ buꞌerã docere mejẽcã pijiawĩ. Ʉ̃sãrẽ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mʉsã ĩꞌaꞌa. Marĩ Jerusalẽ́pʉ waꞌarã weeꞌe. Topʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre aꞌtiro weerãsama. Paꞌia wiorãpʉre, tojo nicã Moisé ojaꞌquere buꞌeri masãpʉre oꞌorãsama. Na yʉꞌʉre wẽjẽdutirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Náta tja ape diꞌtacjãrã judío masã nitirã wiorãpʉre wiaturiarãsama. Yʉꞌʉre bujicãꞌa, tãrã, curusapʉ wẽjẽdutirãsama. Na tojo weemicã, yʉꞌʉ iꞌtia nʉmʉ beꞌro masãgʉ̃saꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo nʉmo co põꞌrã Santiago, Juã meꞌrã Jesú tiropʉ ejawõ. Jesure apeyenojõ sẽrĩgõ, cʉ̃ pʉꞌtopʉ ejaqueꞌawõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesú core niwĩ: —¿Ñeꞌenojõrẽ yʉꞌʉ weecã ʉasari? niwĩ. Cʉ̃rẽ yʉꞌtiwõ: —Mʉꞌʉ wiogʉ sãjãgʉ̃, ãꞌrã yʉꞌʉ põꞌrã pʉarãrẽ mʉꞌʉrẽ dutitamudutigʉ sõrõapa. Niꞌcʉ̃ mʉꞌʉ diacjʉ̃ peꞌe, apĩ cũpe peꞌe dʉpoapa, niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Co tojo nicã tʉꞌogʉ, Jesú co põꞌrãrẽ niwĩ: —Mʉsã yʉꞌʉre sẽrĩsere tʉꞌomasĩweꞌe. Yʉꞌʉ ʉpʉtʉ piꞌeti, wẽrĩgʉ̃saꞌa. ¿Mʉsã quẽꞌrã yʉꞌʉ weronojõ piꞌetimasĩti? niwĩ. Na yʉꞌtiwã: —Ʉ̃ʉ. Piꞌetimasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na tojo nicã, Jesú narẽ niwĩ: —Diacjʉ̃ta niꞌi. Mʉsã quẽꞌrã piꞌetirãsaꞌa. Tojo weemicã, diacjʉ̃ peꞌe, cũpe peꞌe mʉsãrẽ dʉpomasĩtisaꞌa. Aꞌte yʉꞌʉ weese niweꞌe. Yʉꞌʉ pacʉ beseyuꞌcãrã peꞌe topʉre dujirãsama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ʉ̃sã diez na tojo sẽrĩcã tʉꞌorã, na meꞌrã ua waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tojo weecã ĩꞌagʉ̃, Jesú ʉ̃sãrẽ pijio, niwĩ: —Mʉsã masĩsaꞌa. Aꞌti nucũcãrẽ dutirã ti diꞌtare miiwapa waꞌasama. Na docacjãrã quẽꞌrã mejãrõta dutipesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉsã pũrĩcã na weronojõ weesome. Tojo weronojõ oꞌorã, mʉsã waꞌteropʉ wiorã nisĩꞌrĩrã, ãpẽrãrẽ daꞌracoꞌterã weronojõ niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Noꞌo ãpẽrã nemorõ nisĩꞌrĩgʉ̃nojõ ãpẽrãrẽ daꞌracoꞌteri masʉ̃ weronojõ niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ weronojõ weeya. Yʉꞌʉre ãpẽrã weetamuato nígʉ̃ mejẽta aꞌtiwʉ. Yʉꞌʉ peꞌe narẽ weetamugʉ̃ aꞌtiwʉ. Tojo nicã ñaꞌarõ weeꞌque wapare pãjãrãrẽ wẽrĩbosa, wapayewĩrõgʉ̃ aꞌtiwʉ, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Beꞌro ʉ̃sã Jericó wãmetiri macãpʉre wijawãꞌcãwʉ̃. Titare pãjãrã masã Jesure sirutuwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ʉ̃sã waꞌaro ti maꞌa sumuto pʉarã caperi bajunoꞌtirã dujiwã. Jesú yʉꞌrʉasere tʉꞌoñaꞌrã, caricũwã: —Wiogʉ, Davi pãrãmi nituriagʉ, ʉ̃sãrẽ pajañaꞌña, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Masã peꞌe narẽ “Caricũticãꞌña”, nimiwã. Tojo nicãta, na peꞌe nemorõ caricũnemowã: —Wiogʉ, Davi pãrãmi nituriagʉ, ʉ̃sãrẽ pajañaꞌña, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na tojo nicã tʉꞌogʉ, Jesú tojanʉꞌcã, narẽ pijio sẽrĩtiñaꞌwĩ: —¿Deꞌro yʉꞌʉ weecã ʉasari? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na cʉ̃rẽ yʉꞌtiwã: —Ʉ̃sãrẽ caperi bajucã weeya, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tojo nisere tʉꞌogʉ, Jesú narẽ pajañaꞌgʉ̃, na caperire ñapeowĩ. Cʉ̃ tojo weeri cura na pʉarãpʉta caperi ĩꞌawã. Beꞌro na quẽꞌrã Jesure sirutuwãꞌcãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ʉ̃sã Jerusalẽ́pʉ ejase dʉporo Betfagé ʉ̃rʉ̃gʉ̃ Olivo wãmeticjʉ buꞌaropʉ ejawʉ. Topʉ eja, Jesú pʉarã ʉ̃sã meꞌrãcjãrãrẽ ti macãpʉ oꞌówĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Narẽ niwĩ: —Si macã marĩ põtẽorõ nirĩ macãpʉ waꞌarãsaꞌa. Topʉ niꞌcõ burra dʉꞌtenʉꞌcõꞌcore co macʉ̃ meꞌrã bocaejarãsaꞌa. Narẽ pãa, miitia. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Noꞌo niꞌcʉ̃ mʉsãrẽ mejẽcã nicã, aꞌtiro niña: “Marĩ wiogʉ ʉami. Maata wianoꞌrõsaꞌa tja”, niña, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dʉporocjʉ̃ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ cʉ̃ ojaꞌcaronojõta tojo waꞌawʉ. Cʉ̃ Õꞌacʉ̃ ucũꞌquere aꞌtiro ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalẽ́cjãrãrẽ aꞌtiro niña: “Ĩꞌaña. Mʉsã wiogʉ mʉsã tiropʉ aꞌtimi. Mejõ nigʉ̃́ weronojõ burra macʉ̃ wĩꞌmagʉ̃ buꞌipʉ pesawãꞌcãtimi”, ni ojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Beꞌro Jesú cʉ̃ oꞌóꞌcãrã ti macãpʉ waꞌa, cʉ̃ weedutiꞌcaronojõta weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrore cʉ̃ paco meꞌrã miiticãrã niwã. Beꞌro ʉ̃sã ye suꞌti buꞌicjasere na buꞌipʉ pũutãpeowʉ. Tuꞌajanʉꞌcõ, Jesú wĩꞌmagʉ̃ buꞌipʉ mʉjãpejawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Topʉre pãjãrã masã niwã. Na ẽjõpeosere ĩꞌorã, na ye suꞌti buꞌicjasere Jesú yʉꞌrʉaropʉ sẽeocũuwã. Ãpẽrã maꞌa sumuto pũrĩ nise querire dʉtecũuwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Masã cʉ̃ dʉporo waꞌarã, cʉ̃ beꞌrocjãrã quẽꞌrã eꞌcatise meꞌrã caricũwã: —Dʉporocjʉ̃pʉ wiogʉ níꞌcʉ Davi pãrãmirẽ eꞌcatise oꞌorã. Añurõ waꞌato ãꞌrĩ Õꞌacʉ̃ oꞌóꞌcʉre. Ʉꞌmʉsecjãrã cʉ̃rẽ “Añubutiami” ni, eꞌcatise oꞌoato, ni caricũwãꞌcãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Beꞌro Jesú Jerusalẽ́pʉ sãjãcã, topʉ nirã́ ʉcʉapeꞌtia waꞌawã. Pãjãrã sẽrĩtiñaꞌwã: —¿Noa niti cʉ̃? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Narẽ Jesú meꞌrã waꞌarã yʉꞌtiwã: —Cʉ̃ Jesú Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Nazare macã Galilea diꞌtacjʉ̃ nimi, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Beꞌro Jesú Õꞌacʉ̃ wiꞌipʉ sãjãawĩ. Topʉre waꞌicʉrã na Õꞌacʉ̃rẽ ʉ̃jʉ̃amorõpeoajã niwã. Nipeꞌtirã ti wiꞌi poꞌpeapʉ narẽ duurãrẽ, duarã quẽꞌrãrẽ ĩꞌagʉ̃, cõꞌawĩrõpeꞌocãꞌwĩ. Na niyeru dʉcayuri mesare, bujare na dua dujise quẽꞌrãrẽ tuuquecũupeꞌocãꞌwĩ. Na queoro weetise buꞌiri tojo weewĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Beꞌro narẽ niwĩ: —Õꞌacʉ̃ ye queti ojáca pũrĩpʉ aꞌtiro ojanoꞌwʉ̃: “Ya wiꞌi ‘Ñubueri wiꞌi niꞌi’, ninoꞌca wiꞌi niꞌi.” Mʉsã peꞌe queoro weetiapã. Yajarã ya wiꞌire weronojõ tojacã weeꞌe, ni tuꞌtiwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti wiꞌipʉre caperi bajunoꞌtirã, sijamasĩtirã cʉ̃ tiropʉ aꞌtiwã. Na tojo weecã ĩꞌagʉ̃, narẽ yʉꞌrʉowĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Paꞌia wiorã, Moisé ojaꞌquere buꞌeri masã peꞌe cʉ̃ añuse weeĩꞌocã ĩꞌarã, tʉꞌsatiwã. Wĩꞌmarã ti wiꞌi poꞌpeapʉ nirã́ aꞌtiro caricũwã: —Dʉporocjʉ̃pʉ wiogʉ níꞌcʉ Davi pãrãmirẽ eꞌcatise oꞌorã, niwã. Tere tʉꞌorã, paꞌia wiorã quẽꞌrã ua waꞌawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tojo weerã Jesure aꞌtiro sẽrĩtiñaꞌwã: —¿Sõjã wĩꞌmarã na nisere tʉꞌoti? —Tʉꞌoꞌo. Mʉsã Õꞌacʉ̃ ye queti ojáca pũrĩpʉ níꞌquere buꞌepã. Aꞌtiro niꞌi: “Õꞌacʉ̃, mʉꞌʉ wĩꞌmarã, tojo nicã miꞌrĩrãrẽ aꞌtiro weecã weeapʉ. Mʉꞌʉrẽ eꞌcatise oꞌorã, queoro basapeomeꞌrĩcã weeapʉ”, niꞌi, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tojo níca beꞌro paꞌia wiorãrẽ, Moisé ojaꞌquere buꞌeri masãrẽ cõꞌawãꞌcã, Betaniapʉ waꞌa waꞌawĩ. Topʉ ʉ̃sã cãrĩwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ape nʉmʉ boꞌreacã Jesú Jerusalẽ́pʉ majãmitojagʉ, ʉjaboayʉꞌrʉa waꞌawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tojo weegʉ maꞌa sumutopʉ nicjʉ higuera wãmeticjʉre ĩꞌagʉ̃, tigʉ tiro waꞌa, tigʉ dʉcare ĩꞌamaꞌgʉ̃ waꞌawĩ. Ne dʉca marĩcaro niwʉ̃. Pũrĩ peje diaꞌcʉ̃ niwʉ̃. Tojo dʉca marĩcã ĩꞌagʉ̃, Jesú tigʉre niwĩ: —Ne apaturi dʉcatinemosome, niwĩ. Cʉ̃ tojo níca beꞌro maata ñaidija waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tojo waꞌacã, ʉ̃sã cʉ̃ buꞌerã ĩꞌamarĩarã, cʉ̃rẽ sẽrĩtiñaꞌwʉ̃: —¿Deꞌro weero tigʉ maata ñaidijati? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesú ʉ̃sãrẽ yʉꞌtiwĩ: —Diacjʉ̃ mʉsãrẽ weregʉti. Mʉsã ẽjõpeose cʉorã, diacjʉ̃ta yʉꞌtigʉsami nírã, yʉꞌʉ tigʉre ñaicã weeꞌcaro weronojõ weemasĩrãsaꞌa. Aꞌte yʉꞌʉ tigʉ ñaicã weeꞌcaro yʉꞌrʉoro weemasĩrãsaꞌa. Aꞌtigʉ ʉ̃rʉ̃gʉ̃rẽ apero dia pajiri maapʉ waꞌacã weemasĩrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mʉsã ẽjõpeose cʉorã, nipeꞌtise mʉsã ñubue sẽrĩsere bocarãsaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Beꞌro Jesú Õꞌacʉ̃ wiꞌipʉ sãjãawĩ. Cʉ̃ ti wiꞌipʉ buꞌeri cura paꞌia wiorã, ãpẽrã judío masã bʉcʉrã cʉ̃ tiropʉ aꞌtiwã. Cʉ̃rẽ buꞌiri bocasĩꞌrĩrã, sẽrĩtiñaꞌwã: —¿Deꞌronojõ dutise meꞌrã mʉꞌʉ weesere tojo weeti? ¿Noa mʉꞌʉrẽ tojo weedutigʉ dutise oꞌoati? niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesú narẽ yʉꞌtiwĩ: —Yʉꞌʉ quẽꞌrã mʉsãrẽ sẽrĩtiñaꞌmegʉ̃ti. Mʉsã yʉꞌticã, yʉꞌʉ quẽꞌrã mʉsãrẽ “Aꞌte dutiro meꞌrã weeꞌe”, nigʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Noa Juãrẽ wãmeyedutigʉ oꞌópari? ¿Õꞌacʉ̃ tojo weedutiri? ¿O masã peꞌe cʉ̃rẽ tojo weedutiri? niwĩ. Beꞌro na basu aꞌmerĩ niwã: —Marĩ “Õꞌacʉ̃ Juãrẽ wãmeyedutiwĩ” nicã, cʉ̃ marĩrẽ “To pũrĩcãrẽ ¿deꞌro weerã Juãrẽ ẽjõpeotiri?” nigʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Marĩ “Õꞌacʉ̃ oꞌóticʉ niwĩ; masã cʉ̃rẽ oꞌócãrã niwã” nicã, masã marĩrẽ tuꞌtibosama. Nipeꞌtirã masã “Juã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ niwĩ”, ni ẽjõpeosama, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tojo weerã “Masĩtisaꞌa”, niyʉꞌrʉocãꞌwã. Na tojo nicã tʉꞌogʉ, Jesú narẽ niwĩ: —Yʉꞌʉ quẽꞌrã “Aꞌte dutiro meꞌrã weeꞌe”, ni wereweꞌe, niwĩ narẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Beꞌro Jesú narẽ queose meꞌrã werewĩ: —Yʉꞌʉ niꞌcãrõacã weresere ¿deꞌro tʉꞌoñaꞌrãsari mʉsã? Niꞌcʉ̃ pʉarã ʉmʉa põꞌrãtisami. Niꞌcʉ̃rẽ aꞌtiro nisami: “Macʉ̃, ya wese ʉꞌse wesepʉ daꞌragʉ waꞌaya”, nimisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Cʉ̃ tojo nicã tʉꞌogʉ, cʉ̃ macʉ̃ “Waꞌaweꞌe”, ni yʉꞌtisami. Beꞌro mejẽcã wãcũ tja, daꞌragʉ waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Beꞌro cʉ̃ pacʉ apĩ cʉ̃ macʉ̃ tiropʉ ĩꞌagʉ̃ waꞌasami. Mejãrõta cʉ̃rẽ “Daꞌragʉ waꞌaya”, nisami. Cʉ̃ macʉ̃ yʉꞌtisami: “Jaʉ, pacʉ, waꞌagʉti”, nisami. Cʉ̃ tojo níꞌcʉ nimigʉ̃, waꞌatisami, ni werewĩ Jesú paꞌia wiorã, ãpẽrã judío masã wiorãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Cʉ̃ macʉ̃ ¿niꞌinojõ peꞌe cʉ̃ ʉaro weepari? ni sẽrĩtiñaꞌwĩ narẽ. Na aꞌtiro yʉꞌtiwã: —Cʉ̃ dutimʉꞌtãꞌcʉ queoro weepĩ, ni yʉꞌtiwã. Tere tʉꞌogʉ, Jesú narẽ niwĩ: —Diacjʉ̃ mʉsãrẽ weregʉti. “Ñaꞌarã”, mʉsã nirã́, niyeru wapaseeri masã, tojo nicã ʉmʉarẽ aꞌmetãrãwapataꞌari masã numia mʉsã ʉꞌmʉsepʉ waꞌatiri cura na peꞌe waꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juã masãrẽ wãmeyeri masʉ̃ Õꞌacʉ̃ ʉaronojõ aꞌtiro añurõ nisetiroʉami nisere buꞌecã, mʉsã ẽjõpeotiwʉ. Na mʉsã “Ñaꞌarã waro nima” nirã́ pũrĩcã cʉ̃ weresere ẽjõpeo, na wãcũsere dʉcayucãrã niwã. Na tojo weecã ĩꞌamirã, mʉsã peꞌe dʉcayuti, cʉ̃ weresere ẽjõpeoticãrã niwʉ̃, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesú apaturi werewĩ: —Apeye queose meꞌrã mʉsãrẽ werenemogʉ̃ti. Tere tʉꞌoya. Niꞌcʉ̃ pajiro diꞌta cʉogʉ ʉꞌse wese weesami. Ti wesere sãꞌrĩsãsami. Topʉ na ʉꞌse bipesãati pere ʉ̃tãgãpʉ seꞌesãjãsami. Tojo nicã ʉꞌmʉarĩ wiꞌi na coꞌtedujiati wiꞌire weesami. Tojo wééca beꞌro aperopʉ waꞌagʉ, ãpẽrãrẽ ti wesere coꞌtedutigʉ cũusami. Narẽ cʉ̃ ya diꞌtare daꞌrase wapa “Tocãꞌrõ yʉꞌʉre ʉꞌse wiapa”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","»Beꞌro ʉꞌse dʉcatiri cura ãpẽrã cʉ̃rẽ daꞌracoꞌterãrẽ topʉ oꞌósami. Narẽ oꞌógʉ, “Ya diꞌta daꞌrarãrẽ yé ʉꞌsere sẽrĩrã waꞌaya”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Topʉ ejacã, ti wese coꞌterã cʉ̃ oꞌóꞌcãrãrẽ ñeꞌesama. Niꞌcʉ̃rẽ paasama. Apĩrẽ wẽjẽcõꞌasama. Apĩrẽ ʉ̃tãperi meꞌrã doquesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na tojo weecã tʉꞌogʉ, ti wese wiogʉ todʉporo oꞌómʉꞌtãꞌcãrã nemorõ oꞌósami. Na ejacã ĩꞌarã, ti wese coꞌterã na quẽꞌrãrẽ mejãrõta weesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","»Beꞌro oꞌótʉogʉpʉa majã, cʉ̃ macʉ̃rẽ oꞌósami. Aꞌtiro ni wãcũmisami: “Yʉꞌʉ macʉ̃rẽ wiopesase meꞌrã ĩꞌarãsama”, nimisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cʉ̃ macʉ̃rẽ ĩꞌarã, ti wese coꞌterã na basu aꞌmerĩ ucũsama: “Ãꞌrĩta nimi beꞌropʉ aꞌti wesere ñeꞌeacjʉ. Ma, cʉ̃rẽ wẽjẽrã. Beꞌro aꞌti wese marĩ ya wese tojarosaꞌa”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tojo níca beꞌro cʉ̃ macʉ̃rẽ ñeꞌe, ti wese sumutopʉ miaa, cʉ̃rẽ wẽjẽcõꞌasama, ni werewĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cʉ̃ wéréca beꞌro Jesú wiorãrẽ sẽrĩtiñaꞌwĩ: —To pũrĩcãrẽ ti wese wiogʉ aꞌtigʉ, ¿deꞌro weegʉsari ti wese coꞌterãrẽ? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Cʉ̃rẽ yʉꞌtiwã: —Pajañaꞌrõ marĩrõ na ñaꞌarãrẽ wẽjẽcõꞌagʉ̃sami. Beꞌro cʉ̃ ya wesere ãpẽrã peꞌere coꞌtedutigʉsami. Na peꞌe ʉꞌse dʉcatiꞌquere queoro cʉ̃ ye nisere wiarãsama, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na tojo nicã tʉꞌogʉ, Jesú niwĩ: —Mʉsã Õꞌacʉ̃ ye queti ojáca pũrĩrẽ buꞌepã. Yʉꞌʉre waꞌatjere aꞌtiro ojanoꞌwʉ̃: Ʉ̃tã pjĩrĩ meꞌrã wiꞌi yeeri masã niꞌcã pjĩ na ʉatica pjĩrẽ cõꞌarãsama. Na cõꞌáca pjĩ meꞌrã ãpẽrã peꞌe añurõ tutuari wiꞌi yeenʉꞌcãmʉjãsama. Õꞌacʉ̃ marĩ wiogʉ na cõꞌáca pjĩ meꞌrã tojo weesami. Cʉ̃ tojo weeꞌque “Añubutiaꞌa”, ni tʉꞌoñaꞌnoꞌo, ni ojanoꞌwʉ̃, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tojo weegʉ mʉsãrẽ weregʉti. Sĩꞌi wese wiogʉ sõjã coꞌterãrẽ diꞌta ẽꞌmaꞌcaro weronojõ Õꞌacʉ̃ mʉsãrẽ weegʉsami. Õꞌacʉ̃ mʉsã wiogʉ nisĩꞌrĩmiwĩ. Nipeꞌtise añuse cʉ̃ wiogʉ nirõpʉ nise mʉsã ye nibopã. Mʉsã Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masãrẽ, tojo nicã yʉꞌʉre ʉatise ye buꞌiri Õꞌacʉ̃ mʉsã cʉoboꞌquere ẽꞌmagʉ̃sami. Ãpẽrã peꞌere oꞌogʉsami. Na yʉꞌʉre ẽjõpeo, Õꞌacʉ̃ ʉaro weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ʉ̃tãgã yʉꞌʉ werecagare aꞌtiro weregʉti. Noꞌo tigapʉ bʉrʉpejagʉnojõ mʉtõdijonoꞌgʉ̃sami. Noꞌo tiga peꞌe cʉ̃ buꞌipʉ doquepejacãma, añuse poꞌcapʉ waꞌagʉsami, niwĩ. Tojo nígʉ̃, cʉ̃rẽ ʉatirã beꞌropʉ buꞌiri daꞌrenoꞌrãsama nígʉ̃, tojo niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Paꞌia wiorã, ãpẽrã fariseo masã Jesú te queose meꞌrã werecã tʉꞌorã, “Marĩrẽ tojo nigʉ̃ weesami”, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tojo weerã cʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ sõrõrãtirã ñeꞌesĩꞌrĩmiwã. Na tojo weesĩꞌrĩmirã, aꞌtiro wãcũcãrã niwã: “Masã cʉ̃rẽ ‘Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ nimi’, nisama.” Tojo weerã marĩ cʉ̃rẽ ñeꞌecã, marĩrẽ ñaꞌarõ weebosama nírã, weemasĩtiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesú apaturi queose meꞌrã wiorãrẽ werenemowĩ tja. Aꞌtiro niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Õꞌacʉ̃ masãrẽ cʉ̃ wiogʉ nirõpʉ waꞌacã weese aꞌtiro weronojõ niꞌi. Niꞌcʉ̃ diꞌta wiogʉ cʉ̃ macʉ̃ omocã dʉꞌtecã bosenʉmʉ weepeoro weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cʉ̃rẽ daꞌracoꞌterãrẽ nisami: “Yʉꞌʉ cãrʉ̃ wereꞌcãrãrẽ pijirã waꞌaya”, nisami. Beꞌro na peꞌe narẽ pijicã, “Waꞌaweꞌe”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na tojo weecã ĩꞌagʉ̃, ãpẽrãrẽ oꞌósami tja. Narẽ nisami: “Yʉꞌʉ pijiꞌcãrãrẽ wererã waꞌaya. Baꞌase tuꞌajanoꞌtojaꞌa. Yarã wecʉa, ãpẽrã ecarã diꞌiyojacã weeꞌcãrãrẽ wẽjẽdutitojapʉ. Nipeꞌtise aponoꞌtojaꞌa. Quero, bosenʉmʉ weepeorã aꞌtiato”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tojo weerã na quẽꞌrã pijirã waꞌamisama. Na quẽꞌrãrẽ yʉꞌtitiyʉꞌrʉocãꞌsama. “Waꞌaweꞌe”, nicãꞌsama. Apĩ cʉ̃ pijinoꞌcʉ cʉ̃ ya wesepʉ waꞌasami. Apĩ cʉ̃ daꞌraropʉ waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ãpẽrã, wiogʉ oꞌóꞌcãrãrẽ ñeꞌe, paa, wẽjẽcõꞌacãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na tojo weesere tʉꞌogʉ, wiogʉ ʉpʉtʉ uasami. Tojo weegʉ narẽ wẽjẽcõꞌaꞌcãrãrẽ cʉ̃ yarã surarare wẽjẽdutigʉ oꞌósami. Tojo nicã na ya macãrẽ ʉ̃jʉ̃adutisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Beꞌro ãpẽrã cʉ̃rẽ daꞌracoꞌterãrẽ nisami: “Nipeꞌtise yʉꞌʉ macʉ̃rẽ bosenʉmʉ weepeoatjere apotojapʉ. Tojo weemicã, yʉꞌʉ pijiꞌcãrã ñaꞌarã nitjĩarã aꞌtita basiotiyucã, aꞌtiticãrã niama. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tojo weerã noꞌo mʉsã macã decopʉ bocaejarãrẽ pijiya”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Beꞌro cʉ̃rẽ daꞌracoꞌterã macã decopʉ pijirã waꞌasama. Nipeꞌtirã na bocaejarã añurã, ñaꞌarãrẽ piji neocũu, wiogʉ ya wiꞌipʉ miasama. Na tojo weecã, topʉ na nerẽrĩ tucũ muꞌmua waꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","»Beꞌro wiogʉ narẽ ĩꞌagʉ̃, añudutigʉ waꞌasami. Niꞌcʉ̃ na waꞌteropʉ nigʉ̃́ na omocã dʉꞌtecã sãñawʉaronojõ sãñatigʉre ĩꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wiogʉ cʉ̃rẽ nisami: “Acaweregʉ, aꞌti bosenʉmʉrẽ ¿deꞌro wee suꞌti omocã dʉꞌtecã sãñawʉaronojõ sãñatimigʉ̃ sãjãtiati?” nisami. Cʉ̃ peꞌe yʉꞌtitiyʉꞌrʉocãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Beꞌro wiogʉ ti bosenʉmʉ sʉꞌori weerãrẽ nisami: “Cʉ̃rẽ ñeꞌe, dʉꞌpocãrĩ, omocãrĩpʉ dʉꞌtebutuaya. Wijaaro naꞌitĩꞌarõpʉ cõꞌacãꞌña. Topʉ pũrĩnoꞌgʉ̃, upicari cũꞌrĩdio, utigʉsami”, nisami wiogʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Aꞌte weronojõ niꞌi Õꞌacʉ̃ wiogʉ nise. Õꞌacʉ̃ pãjãrã masãrẽ pijimicã, pejetirãcã cʉ̃ wiogʉ nirõpʉ sãjã́árãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cʉ̃ tojo níca beꞌro fariseo masã waꞌa waꞌawã. Beꞌro na Jesure buꞌiri bocasĩꞌrĩrã, “Aꞌtiro weerã”, ni apoyucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tojo weerã na buꞌesere siruturãrẽ, tojo nicã ãpẽrã Herode ya curuacjãrã meꞌrã Jesú tiropʉ oꞌócãrã niwã. Na cʉ̃ tiropʉ etarã, niwã: —Masãrẽ buꞌegʉ, ʉ̃sã mʉꞌʉ nisetisere masĩꞌi. Mʉꞌʉ diacjʉ̃ ucũꞌu. Masã yʉꞌʉre ¿deꞌro wãcũrãsari? nirṍ marĩrõ diacjʉ̃ ucũꞌu. Õꞌacʉ̃ yere diacjʉ̃ wereꞌe. Ãpẽrã wiorã nima nirṍ marĩrõ nipeꞌtirãrẽ niꞌcãrõnojõ ĩꞌaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tojo weerã mʉꞌʉrẽ apeyenojõ sẽrĩtiñaꞌrã aꞌtiapʉ. Romano masã wiogʉre cʉ̃ niyeru wapaseesere wapayecã, marĩrẽ dutise ¿añuti, o ñaꞌa nitine? Na Jesure buꞌiri bocasĩꞌrĩrã, tojo niwã. (Jesú “Wapayeroʉaꞌa” nicãma, judío masã “Õꞌacʉ̃ niꞌcʉ̃rẽta ẽjõpeoroʉaꞌa; mʉꞌʉ tojo nise ñaꞌa niꞌi”, nibocãrã niwã. “Wapayeticãꞌrõʉaꞌa” nicã peꞌe, “Romano masã wiogʉre yʉꞌrʉnʉꞌcãgʉ̃ weeꞌe”, nibocãrã niwã.) ");
INSERT INTO tuoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tojo weegʉ Jesú na ñaꞌarõ wãcũsere ĩꞌagʉ̃, aꞌtiro niwĩ: —Mʉsã tojo nírã, weetaꞌsari masã niꞌi. ¿Deꞌro weerã yʉꞌʉre mejẽcã yʉꞌtigʉ, buꞌiri bocagʉsami nírã, sẽrĩtiñaꞌti? ");
INSERT INTO tuoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niyeru cuji romano masã wiogʉre wapayeri cujinojõrẽ miitia, niwĩ. Cʉ̃ tojo nicã tʉꞌorã, niꞌcã nʉmʉ daꞌrawapataꞌari cujinojõrẽ miitiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tojo weecã ĩꞌagʉ̃, Jesú narẽ sẽrĩtiñaꞌwĩ: —¿Noa queose, noa wãme wãꞌñati aꞌti cujipʉre? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Cʉ̃ tojo nicã tʉꞌorã, na yʉꞌtiwã: —César, romano masã wiogʉ cʉ̃ queose, cʉ̃ wãme wãꞌñaꞌa, niwã. Beꞌro Jesú narẽ niwĩ: —To pũrĩcãrẽ romano masã wiogʉ wapayedutisenojõrẽ cʉ̃rẽ oꞌoya. Õꞌacʉ̃ ye peꞌema cʉ̃rẽ oꞌoya. Cʉ̃ weedutisere weeya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cʉ̃ tojo nicã tʉꞌorã, tʉꞌomarĩa, beꞌro waꞌa waꞌawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jesure “¿Romano masã wiogʉre wapayeroʉati?” níca nʉmʉrẽta ãpẽrã paꞌia saduceo masã cʉ̃rẽ ĩꞌarã etawã. Na “Wẽrĩꞌcãrãpʉ masãsome”, ni ẽjõpeoma. Tojo weerã Jesure masãse cjasere aꞌtiro niwã: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Masãrẽ buꞌegʉ, dʉporopʉ Moisé aꞌtiro duticʉ niwĩ: “Niꞌcʉ̃ nʉmotigʉ põꞌrãtitimigʉ̃ wẽrĩcã, cʉ̃ acabiji cʉ̃ nʉmo níꞌcore nʉorẽato. Beꞌro cʉ̃ co meꞌrã ne waro põꞌrãtimʉꞌtãgʉ̃rẽ cʉ̃ maꞌmi wẽrĩꞌcʉre põꞌrãtibosato”, nicʉ niwĩ Moisé. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tojota waꞌaꞌa ʉ̃sã waꞌterore. Siete ʉmʉa niꞌcʉ̃ põꞌrã niwã. Masã maꞌmi nʉmoti, beꞌro wẽrĩa waꞌacʉ niwĩ. Põꞌrã marĩyugʉ, cʉ̃ nʉmo níꞌcore cʉ̃ acabijire cũucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cʉ̃ quẽꞌrã põꞌrãtitimigʉ̃ wẽrĩa waꞌacʉ niwĩ. Beꞌrocjʉ̃ quẽꞌrãrẽ tojota waꞌacaro niwʉ̃. Tojo diaꞌcʉ̃ waꞌaturiadijacaro niwʉ̃ téé nitʉogʉpʉre. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na nipeꞌtirã beꞌro co quẽꞌrã wẽrĩa waꞌaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na siete co meꞌrã omocã dʉꞌtecãrã niwã. Tojo weero wẽrĩꞌcãrã masãcã, ¿niꞌí nʉmo tojabutiagosari? ni sẽrĩtiñaꞌwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tojo nicã tʉꞌogʉ, Jesú narẽ yʉꞌtiwĩ: —Mʉsã wisiyʉꞌrʉaꞌa. Õꞌacʉ̃ ye queti ojáca pũrĩ cjasere ne masĩweꞌe. Õꞌacʉ̃ cʉ̃ tutuase quẽꞌrãrẽ masĩweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wẽrĩꞌcãrã na masã́ca beꞌro nʉmotisome. Põꞌrã numia quẽꞌrãrẽ numisosome. Õꞌacʉ̃rẽ werecoꞌterã ʉꞌmʉsepʉ nirã́ weronojõ nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apeyenojõ wẽrĩꞌcãrã masãsere werenemogʉ̃ti tja. Õꞌacʉ̃ cʉ̃ ye queti ojáca pũrĩpʉ mʉsãrẽ níꞌquere buꞌepã. Aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yʉꞌʉ Õꞌacʉ̃ niꞌi. Abrahã, Isaa, Jacob wiogʉ niꞌi”, nicʉ niwĩ. Cʉ̃ “Na wiogʉ niꞌi” nígʉ̃, “Yʉꞌʉ tiropʉ catima” nígʉ̃, tojo nicʉ niwĩ. Õꞌacʉ̃ catirã wiogʉ nimi. Wẽrĩbajudutiꞌcãrã marĩma, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cʉ̃ buꞌesere tʉꞌorã, masĩse meꞌrã yʉꞌticã ĩꞌarã, masã tʉꞌomarĩa waꞌawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Beꞌro Jesú saduceo masãrẽ diꞌtamarĩacã weesere fariseo masã tʉꞌocãrã niwã. Tere tʉꞌo, nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na meꞌrã niꞌcʉ̃ Moisé ojaꞌquere buꞌeri masʉ̃ Jesure mejẽcã yʉꞌticã ʉagʉ, cʉ̃rẽ sẽrĩtiñaꞌwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Masãrẽ buꞌegʉ, Moisé dutiꞌque ¿disenojõ waro apeye yʉꞌrʉoro añuyʉꞌrʉnʉꞌcãti? niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesú cʉ̃rẽ aꞌtiro yʉꞌtiwĩ: —Aꞌtiro niꞌi. “Õꞌacʉ̃ marĩ wiogʉre nipeꞌtise mʉsã ẽjõpeose meꞌrã, mʉsã wãcũse meꞌrã, mʉsã tʉꞌoñaꞌse meꞌrã maꞌiña.” ");
INSERT INTO tuoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aꞌte niꞌi apeye yʉꞌrʉoro niyʉꞌrʉnʉꞌcãse. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aꞌte beꞌrore tojocureta niꞌi, nírõ. Aꞌtiro niꞌi. “Marĩ basu maꞌirõnojõta ãpẽrãrẽ maꞌirõʉaꞌa.” ");
INSERT INTO tuoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aꞌte pʉaro dutisere wéérã, nipeꞌtise Moisé cʉ̃ dutiꞌquere, tojo nicã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã na buꞌeꞌquere yʉꞌtirãta weeꞌe, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo masã na nerẽrĩ cura Jesú narẽ sẽrĩtiñaꞌwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Mʉsã Cristo Õꞌacʉ̃ beseꞌcʉre ¿deꞌro tʉꞌoñaꞌti? ¿Noa macʉ̃ niti cʉ̃? niwĩ. Cʉ̃rẽ yʉꞌtiwã: —Dʉporocjʉ̃pʉ wiogʉ Davi pãrãmi nituriagʉ nimi, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na tojo nicã tʉꞌogʉ, Jesú narẽ niwĩ: —Cristo, Õꞌacʉ̃ beseꞌcʉ Davi pãrãmi nituriagʉ nicã, to pũrĩcãrẽ ¿deꞌro weegʉ Davi Espíritu Santu tutuaro meꞌrã ucũgʉ̃, cʉ̃rẽ “Yʉꞌʉ wiogʉ nimi”, nipari? Marĩ, marĩ pãrãmirẽ “Yʉꞌʉ wiogʉ nimi”, niweꞌe. Davi Õꞌacʉ̃ beseꞌcʉre ucũyugʉ, aꞌtiro ojacʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Õꞌacʉ̃ ʉꞌmʉsepʉ nigʉ̃́ cʉ̃ macʉ̃rẽ, yʉꞌʉre yʉꞌrʉoacjʉre aꞌtiro nicʉ niwĩ: “Yʉꞌʉ tiro wiogʉ dujiri cũmurõpʉ dujigʉsaꞌa. Mʉꞌʉ topʉ dujicã, mʉꞌʉrẽ ĩꞌatuꞌtimiꞌcãrãrẽ docaqueꞌacã weegʉti”, nicʉ niwĩ Õꞌacʉ̃, ni ojacʉ niwĩ Davi. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Deꞌro weegʉ Õꞌacʉ̃ beseꞌcʉ Cristo Davi pãrãmi nímasĩbosabe? Davi basuta cʉ̃rẽ “Yʉꞌʉ wiogʉ nimi”, nicʉ niwĩ. Tojo weegʉ cʉ̃ pãrãmi seꞌsaro nirṍnojõ oꞌogʉ, cʉ̃ wiogʉ nicʉ niwĩ, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Cʉ̃ tojo nisere tʉꞌorã, ne niꞌcʉ̃ niꞌcã ʉsero yʉꞌtimaꞌatiwã. Tita meꞌrã beꞌro majã uirã, ne sẽrĩtiñaꞌnemotiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Beꞌro Jesú masãrẽ, tojo nicã ʉ̃sã cʉ̃ buꞌerãrẽ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisé ojaꞌquere buꞌeri masã, ãpẽrã fariseo masã Õꞌacʉ̃ dutise Moisére cũuꞌquere wererã nima. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tojo weerã na weresere tʉꞌo, tere weesirutuya. Na weesetise peꞌere ĩꞌacũuticãꞌña. Na añurõ weremeꞌrĩma, wererã. Tojo weemirã, na nise peꞌere weetima. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Na dutiwʉaronojõ dutiyʉꞌrʉocãꞌsama. Masã tere põtẽotisama. Na tojo wéérã, wʉapõtẽoña marĩse nʉcʉ̃sere dʉꞌtepeorã weronojõ weesama. Na masãrẽ tere wʉapeorã weronojõ weesama. Na tere wʉadutirã, ne ãpẽrã tãꞌrĩrãrẽ weetamutirã weronojõ weesama. Ne pajañaꞌti, masãrẽ ne cãꞌrõ weetamutisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nipeꞌtise na weesere masãrẽ añurõ ĩꞌadutirã weetaꞌsasama. Masã narẽ “Õꞌacʉ̃rẽ añurõ ẽjõpeosama” nicã tʉꞌosĩꞌrĩrã, aꞌtiro weesama. Na diapoapʉ, na omocãpʉ Õꞌacʉ̃ ye queti ojáca pũrĩ cjasere pajiri casero meꞌrã ojaꞌquere dʉꞌteõꞌosama. Tojo nicã na ñubuecã ĩꞌadutirã ãpẽrã yʉꞌrʉoro na ñubuewʉari suꞌtiro sumutopʉ opa dari cʉorojore sãñasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bosenʉmʉ nicã wiorã na dujiwʉase cũmurĩpʉ dujisĩꞌrĩsama. Na nerẽse wiꞌseripʉ quẽꞌrãrẽ mejãrõta weesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Masã narẽ macã decopʉ wiopesase meꞌrã añuduticã ʉasama. Narẽ, “Ʉ̃sãrẽ buꞌerã” pisucã ʉasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","»Mʉsã pũrĩcã ãpẽrãrẽ “Mʉsã ʉ̃sãrẽ buꞌerã niꞌi”, ninoꞌticãꞌña. Aꞌtiro niꞌi. Mʉsã niꞌcʉ̃ põꞌrãta niꞌi. Yʉꞌʉ niꞌcʉ̃ta mʉsãrẽ buꞌegʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mʉsã ne niꞌcʉ̃rẽ aꞌti nucũcãpʉre “Ʉ̃sã pacʉ”, niticãꞌña. Mʉsã niꞌcʉ̃ta pacʉtiꞌi. Cʉ̃ Õꞌacʉ̃ ʉꞌmʉsepʉ nimi. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Diacjʉ̃ta mʉsã pũrĩcã “Ʉ̃sã wiogʉ”, ni pisunoꞌticãꞌña. Yʉꞌʉ Cristo Õꞌacʉ̃ beseꞌcʉ niꞌcʉ̃ta mʉsã wiogʉ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Noꞌo ãpẽrãrẽ weetamugʉ̃, cʉ̃́ta nimi ãpẽrã yʉꞌrʉoro buꞌipʉ niyʉꞌrʉnʉꞌcãgʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Noꞌo “Yʉꞌʉ ãpẽrã yʉꞌrʉoro niyʉꞌrʉnʉꞌcãꞌa” ni tʉꞌoñaꞌgʉ̃nojõ Õꞌacʉ̃ cʉ̃rẽ mejõ nigʉ̃acã waro tojacã weegʉsami. Noꞌo “Yʉꞌʉ ãpẽrã yʉꞌrʉoro niꞌi” ni tʉꞌoñaꞌtigʉ peꞌere Õꞌacʉ̃ ãpẽrã yʉꞌrʉoro tojacã weegʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","»Mʉsã Moisé ojaꞌquere buꞌeri masã, tojo nicã fariseo masã weetaꞌsari masã niꞌi. Masã yʉꞌʉre ẽjõpeosĩꞌrĩrãrẽ cãꞌmotaꞌa. Tojo wéérã, yʉꞌʉ pacʉ wiogʉ nirõpʉ waꞌari maꞌarẽ narẽ biꞌarã weeꞌe. Mʉsã basuta yʉꞌʉre ẽjõpeoweꞌe. Ãpẽrã quẽꞌrãrẽ ẽjõpeosĩꞌrĩcã ʉasãweꞌe. Tojo weero ñaꞌabutiaro waꞌarosaꞌa mʉsãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","»Mʉsã wapewia numia ye wiꞌserire ẽꞌmasaꞌa. Mʉsã ñaꞌarõ weeꞌquere wãcũdutitirã yoacã ñubuetaꞌsaꞌa. Tojo weerã mʉsã ãpẽrã nemorõ buꞌiri bocayʉꞌrʉnʉꞌcãrãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jesú aꞌtiro ninemowĩ Moisé ojaꞌquere buꞌeri masãrẽ, tojo nicã fariseo masãrẽ: —Mʉsã ʉpʉtʉ waro weetaꞌsaꞌa. Mʉsã ẽjõpeosere noꞌo niꞌcʉ̃ nigʉ̃acãrẽ mʉsã weronojõ ẽjõpeocã ʉarã, nipeꞌtiropʉ sijabiꞌaꞌa. Beꞌro tuꞌajanʉꞌcõ, cʉ̃rẽ mʉsã nemorõ ñaꞌarõ pecameꞌepʉ waꞌata basiocã weesaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","»Ñaꞌarõ waꞌarosaꞌa mʉsãrẽ. Caperi bajutirãrẽ aꞌmerĩ wejero weronojõ niꞌi. Aꞌtiro ni buꞌeꞌe masãrẽ: “Niꞌcʉ̃ ‘Aꞌtiro weegʉti’, nisami Õꞌacʉ̃rẽ. ‘Õꞌacʉ̃ wiꞌi meꞌrã tojo weegʉti’ níca beꞌro cʉ̃ níꞌquere queoro weeticã, ‘Buꞌiri marĩꞌi’ ”, nisaꞌa. “Cʉ̃ ‘Õꞌacʉ̃ wiꞌi cjase uru meꞌrã tojo weegʉti’ níꞌquere queoro weeticã pũrĩcãrẽ, ‘Ñaꞌa niꞌi’ ”, nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mʉsã tojo nírã, diacjʉ̃ wãcũweꞌe. Tʉꞌomasĩweꞌe. Uru Õꞌacʉ̃ wiꞌipʉ niyuro, Õꞌacʉ̃ ĩꞌorõpʉ añuse tojasaꞌa. Õꞌacʉ̃ wiꞌi, ti wiꞌi cjase uru nemorõ añuyʉꞌrʉnʉꞌcãꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mʉsã Õꞌacʉ̃ dutiro weesĩꞌrĩtirã, ucũmeꞌrĩse meꞌrã weetaꞌsaꞌa. Masãrẽ aꞌtiro nisaꞌa: “Mʉsã ‘Õꞌacʉ̃rẽ waꞌicʉrã ʉ̃jʉ̃amorõpeowʉaropʉ meꞌrã tojo weerãti’ níꞌquere weeticã, buꞌiri marĩsaꞌa. Waꞌicʉ Õꞌacʉ̃rẽ oꞌose topʉ peoꞌque meꞌrã pũrĩcãrẽ wapatisaꞌa”, niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mʉsã tʉꞌomasĩweꞌe. Õꞌacʉ̃rẽ oꞌose nemorõ na waꞌicʉrã ʉ̃jʉ̃amorõpeowʉaro peꞌe wapatiꞌi. Topʉ ʉ̃jʉ̃pesase meꞌrã na Õꞌacʉ̃rẽ oꞌose añuse tojasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tojo weerã mʉsã “Õꞌacʉ̃rẽ waꞌicʉrã ʉ̃jʉ̃amorõpeowʉaropʉ meꞌrã tojo weerãti” nírã, te seꞌsarore nirã weeweꞌe. “Topʉ peoatje quẽꞌrãrẽ mejãrõta weerãti”, nirã weesaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Õꞌacʉ̃ cʉ̃ ya wiꞌi, Õꞌacʉ̃ wiꞌipʉ nisami. Tojo weerã Õꞌacʉ̃rẽ “Ti wiꞌi meꞌrã tojo weerãti” nírã, “Cʉ̃ meꞌrãta tojo weerãti”, nirã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mejãrõta “Ʉꞌmʉse meꞌrã tojo weerãti” nírã, “Õꞌacʉ̃ dujiro meꞌrãta, topʉ dujigʉ meꞌrãta” nirã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","»Ñaꞌarõ waꞌarosaꞌa mʉsã Moisé ojaꞌquere buꞌeri masãrẽ, tojo nicã fariseo masãrẽ. Mʉsã weetaꞌsasebʉjʉrã niꞌi. Mʉsã otese oꞌmajãcã, menta, anís, comino wãmetise baꞌase sãamorẽsere seeneo, opa sʉ̃ꞌʉrĩ weesaꞌa. Diez sʉ̃ꞌʉrĩ cʉorã, niꞌcã sʉ̃ꞌʉ Õꞌacʉ̃ wiꞌipʉ miaa, Õꞌacʉ̃rẽ wãmepeo, paꞌire oꞌosaꞌa. Mʉsã tojo añurõ weemirã, Moisé ojaꞌque apeye pacase peꞌere weeweꞌe. Ãpẽrãrẽ queoro weesere, pajañaꞌsere, Õꞌacʉ̃rẽ ẽjõpeose peꞌere weeweꞌe. Aꞌtiro peꞌe weeya. Mʉsã otesere cʉ̃rẽ oꞌoduꞌutimirã, aꞌte añuyʉꞌrʉnʉꞌcãsere weeya. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","»Mʉsã basu diacjʉ̃ weeweꞌe. Ãpẽrã quẽꞌrãrẽ sʉꞌori diacjʉ̃ weeweꞌe. Tojo weerã mʉsã Õꞌacʉ̃ ye cjasere buꞌérã, caperi bajutirã aꞌmerĩ sʉꞌori tʉ̃awãꞌcãrã weronojõ niꞌi. Moisé cʉ̃ ojaꞌque, mejõ niseacã dutise peꞌere wãcũyʉꞌrʉrã, apeye paca peꞌere weeweꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","»Mʉsã weetaꞌsarã aꞌtiro weeꞌe. Bajuyoropʉ diaꞌcʉ̃ añurõ weeꞌe. Baparire buꞌipʉ diaꞌcʉ̃ añurõ coerã weronojõ weetaꞌsaꞌa. Ti pa poꞌpeapʉre peje ñaꞌase mʉsã ãpẽrã yere yajaꞌque, ãpẽrã yere ʉaripejayʉꞌrʉnʉꞌcãꞌque ũꞌirĩ weronojõ wãꞌñasaꞌa. Tojo weero ñaꞌabutiaro waꞌarosaꞌa mʉsãrẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉsã fariseo masã tʉꞌomasĩtirã, caperi bajunoꞌtirã weronojõ niꞌi. Ne waro poꞌpeapʉ cjase mʉsã wãcũsere dʉcayumʉꞌtãña. Beꞌro bajuyoropʉ añurã, ñaꞌase moorã tojarã́saꞌa. Bapari poꞌpeapʉ coemʉꞌtãꞌcaro weronojõ buꞌipʉ quẽꞌrã ũꞌirĩ marĩrõ tojaro weronojõ weerãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","»Mʉsã Moisé ojaꞌquere buꞌeri masã, fariseo masã weetaꞌsari masã niꞌi. Tojo weero ñaꞌabutiaro waꞌarosaꞌa mʉsãrẽ. Wẽrĩꞌcãrã masãperi weronojõ niꞌi. Buꞌipʉre añurõ bajudutirã boꞌre meꞌrã waꞌreꞌque cujirire nʉꞌcõsaꞌa. Ti pe poꞌpeapʉre wẽrĩꞌcãrã õꞌarĩ mejã, tojo nicã dicʉse na upʉ ñaꞌase boaꞌque sãñasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mʉsã aꞌtiro nisetiꞌi. Masã ĩꞌorõpʉre añurã weronojõ bajuꞌu. Poꞌpeapʉ peꞌere weetaꞌsasebʉjʉrã niꞌi. Mʉsãpʉre ñaꞌase niyʉꞌrʉaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","»Mʉsã Moisé ojaꞌquere buꞌeri masã, fariseo masã weetaꞌsasebʉcʉrã niꞌi. Mʉsã dʉporocjãrã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã masãperi buꞌipʉ añurõ bajudutirã yeenʉꞌcõꞌo. Tojo nicã ãpẽrã masã añurã níꞌcãrãrẽ masãperi buꞌipʉ mejãrõta maꞌmasuꞌanʉꞌcõꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tuꞌajanʉꞌcõ, aꞌtiro ucũsaꞌa. “Ʉ̃sã ñecʉ̃sʉmʉa Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masãrẽ wẽjẽcãrã niwã. Ʉ̃sã na catícateropʉre nírã, narẽ wẽjẽcã, wẽjẽtamutibopã”, niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mʉsã aꞌtere tojo nírã, “Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masãrẽ wẽjẽꞌcãrã pãrãmerã nituriarã niꞌi”, nirã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉsã, mʉsã ñecʉ̃sʉmʉa weemʉjãtiꞌcaronojõta weeyapaticãꞌña, ni tuꞌtiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","»Mʉsã weetaꞌsari curuacjãrã aña weronojõ niꞌi. Mʉsã deꞌro wee Õꞌacʉ̃ pecameꞌepʉ buꞌiri daꞌreatjere yʉꞌrʉwetimasĩsome. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tojo weegʉ yʉꞌʉ mʉsã tiropʉre Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã, masĩrĩ masãrẽ, buꞌeri masãrẽ oꞌógʉti. Mʉsã peꞌe na niꞌcãrẽrãrẽ wẽjẽ, ãpẽrãrẽ curusapʉ paabiꞌpenʉꞌcõrãsaꞌa. Ãpẽrãrẽ na nerẽwʉase wiꞌseripʉ paape, na noꞌo waꞌase macãrĩpʉ sirutucusiarãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tojo weero nipeꞌtirã masã añurãrẽ wẽjẽꞌque wapa mʉsãrẽ buꞌiri wãꞌaꞌa. Mʉsã ñecʉ̃sʉmʉa añugʉ̃ Abel meꞌrã ne waro wẽjẽ dʉꞌpocã́ticãrã niwã. Téé Zacaría Berequía macʉ̃ meꞌrã yapadaꞌreocãrã niwã. Cʉ̃rẽ na ñubuepeowʉaropʉ Õꞌacʉ̃ wiꞌi decopʉ wẽjẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diacjʉ̃ mʉsãrẽ weregʉti. Tojo weeꞌque wapare niꞌcãrõacã aꞌtocateropʉ nirãrẽ buꞌiri waꞌarosaꞌa, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Fariseo masãrẽ tojo níca beꞌro Jesú Jerusalẽ́cjãrã, tojo nicã todʉporopʉ ti macãpʉ níꞌcãrãrẽ wãcũgʉ̃, aꞌtiro niwĩ: —Jerusalẽ́cjãrã, mʉsã Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masãrẽ wẽjẽcõꞌaꞌa. Õꞌacʉ̃ oꞌóꞌcãrã cʉ̃ ye quetiwereri masãrẽ ʉ̃tãperi meꞌrã doquewẽjẽꞌe. Mʉsãrẽ pejetiri yʉꞌʉ maꞌígʉ̃, neocũusĩꞌrĩmiwʉ̃. Niꞌcõ cãrẽꞌquẽ co põꞌrãrẽ wʉʉse docapʉ neocũuꞌcaro weronojõ weesĩꞌrĩmiwʉ̃. Mʉsã ʉatiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tojo weero mʉsã nimiꞌque wiꞌseri masã marĩrõ tojarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aꞌtere tʉꞌomasĩña. Yʉꞌʉre apaturi ĩꞌanemosome majã. Beꞌro yʉꞌʉ aꞌti turipʉ apaturi aꞌticãpʉ, mʉsã “Õꞌacʉ̃ dʉporopʉ ‘Oꞌógʉti’ níꞌcʉ añubutiagʉ nimi” nírãpʉ ĩꞌarãsaꞌa tja, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesú Õꞌacʉ̃ wiꞌipʉ níꞌcʉ wijaa waꞌawĩ. Cʉ̃ waꞌari cura ʉ̃sã cʉ̃ buꞌerã cʉ̃ tiro waꞌa, niwʉ̃: —Ĩꞌaña aꞌti wiꞌire. Añubutiari wiꞌi, pajiri wiꞌi waro niꞌi, nimiwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ʉ̃sã tojo nicã, Jesú niwĩ: —Mʉsã aꞌte pejere ĩꞌaꞌa, ĩꞌarã. Diacjʉ̃ mʉsãrẽ weregʉti. Nipeꞌtise aꞌti wiꞌi cjase ne niꞌcã ʉ̃tãgã apega buꞌipʉ yeeturiamʉjãꞌque tojasome. Nipeꞌtise mʉtõdijonoꞌrõsaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Beꞌro ʉ̃sã waꞌa, ʉ̃rʉ̃gʉ̃ Olivo wãmeticjʉpʉ ejawʉ. Jesú topʉ ejanujãrĩ cura ʉ̃sã yaꞌyioropʉ sẽrĩtiñaꞌwʉ̃: —Ʉ̃sãrẽ wereya. ¿Deꞌro nicã tojo waꞌarosari? ¿Ñeꞌenojõ meꞌrã ĩꞌogʉ̃sari mʉꞌʉ apaturi aꞌtiatjere? Tojo nicã aꞌti ʉmʉco peꞌtiatjo dʉporo ¿deꞌro wee masĩrãsari? ni sẽrĩtiñaꞌwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesú ʉ̃sãrẽ yʉꞌtiwĩ: —Ãpẽrã mʉsãrẽ nisooticãꞌto nírã, añurõ tʉꞌomasĩyuya. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pãjãrã aꞌtiro nisoorãsama. “Yʉꞌʉ Õꞌacʉ̃ tutuaro meꞌrã weeꞌe; Õꞌacʉ̃ beseꞌcʉ Cristo niꞌi”, nirãsama. Na tojo nisere tʉꞌorã, pãjãrã siruturãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉsã aꞌmewẽjẽse quetire tʉꞌo, “Topʉ tojo waꞌaporo” nicã tʉꞌorãsaꞌa. Tere tʉꞌorã, ʉcʉaticãꞌña. Te aꞌtirota waꞌarosaꞌa. Tojo nimirõ, aꞌti ʉmʉco peꞌtiatjo dʉꞌsarosaꞌa yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Niꞌcã curuacjãrã ape curuacjãrã meꞌrã aꞌmequẽrãsama. Tojo nicã niꞌcã diꞌtacjãrã ape diꞌtacjãrã meꞌrã aꞌmewẽjẽrãsama. Peje apesepʉre ʉjaboase nirõsaꞌa. Aperopʉre peje diꞌta narãsãse nirõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aꞌte nipeꞌtise peje meꞌrã masã ne waro piꞌetiwãꞌcõse niꞌi. Numio co macʉ̃rẽ wʉase dʉporoacã pũrĩse nʉꞌcãrõ weronojõ nirõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","»Tojo waꞌacã, yʉꞌʉre ẽjõpeotirã mʉsãrẽ ñaꞌarõ weerãsama. Mʉsãrẽ ñeꞌe, wiorã tiropʉ miaa, buꞌiri daꞌredutirãsama. Mʉsãrẽ wẽjẽrãsama. Yʉꞌʉre ẽjõpeose buꞌiri nipeꞌtirocjãrã masã mʉsãrẽ ĩꞌatuꞌtirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tojo waꞌacã, pãjãrã yʉꞌʉre ẽjõpeomiꞌcãrã ẽjõpeoduꞌurãsama. Na aꞌmetuꞌti, ãpẽrã wiorãpʉre buꞌiri daꞌredutirã oꞌorãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pãjãrã “Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã niꞌi”, nisoorãsama. Pãjãrãrẽ nisoo, ẽjõpeocã weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ñaꞌase niyʉꞌrʉmajãrõsaꞌa. Tojo waꞌacã, pãjãrã aꞌmerĩ maꞌiduꞌurãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yʉꞌʉre ẽjõpeoyapatirã pũrĩcã yʉꞌrʉwetirãsama. Yʉꞌʉ pacʉ tiropʉ catinuꞌcũrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nipeꞌtiro aꞌti diꞌtapʉ Õꞌacʉ̃ masãrẽ yʉꞌrʉose quetire wereseꞌsabiꞌanoꞌrõsaꞌa. Na quẽꞌrãrẽ masĩdutiro werenoꞌrõsaꞌa. “Ñaꞌarõ weeꞌquere bʉjaweti dʉcayucã, Õꞌacʉ̃ ñeꞌegʉ̃sami”, ni werenoꞌrõsaꞌa. Aꞌte nipeꞌtiropʉ seꞌsáca beꞌro aꞌti ʉmʉco peꞌtirosaꞌa majã. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dʉporocjʉ̃pʉ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Danie wãmetigʉ aꞌti ʉmʉco peꞌtiatjo dʉporo waꞌatjere ojayucʉ niwĩ. “Ñaꞌagʉ̃, Õꞌacʉ̃ yabigʉnojõ cʉ̃ ya wiꞌi añurĩ wiꞌipʉ sãjãtígʉnojõ Jerusalẽ́ cja wiꞌipʉ sãjãagʉ̃sami”, ni ojayucʉ niwĩ. Cʉ̃ ti wiꞌipʉ nuꞌcũcã ĩꞌarã, mʉsã aꞌti pũrĩrẽ buꞌe, tʉꞌomasĩña. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tojo waꞌacã ĩꞌarã, Õꞌacʉ̃ buꞌiri daꞌregʉsami nírã, Judeapʉ nirã́ ʉ̃rʉ̃pagʉpʉ duꞌtiaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wiꞌi dʉposãrĩ opa sirapʉ soo pesagʉnojõ poꞌpeapʉ cjasere sãjãa, duretimigʉ̃, diacjʉ̃ duꞌtiaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Noꞌo wesepʉ tõꞌogʉ̃ quẽꞌrã ne wiꞌipʉ tojaa, duregʉ waꞌaticãꞌña. Sojaro meꞌrã duꞌtiaya. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tojo waꞌase nʉmʉrĩ numia nijĩpacosãnumiarẽ, tojo nicã põꞌrã miꞌrĩrã cʉorãrẽ bʉjaweose nʉmʉrĩ nirõsaꞌa. Na ʉmʉñarõ waꞌamasĩsome. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mʉsã Õꞌacʉ̃rẽ sẽrĩña: “Yʉsʉase nʉmʉrĩrẽ, soowʉari nʉmʉ ʉ̃sã judío masã yoaropʉ waꞌatiri nʉmʉrẽ waꞌaticãꞌto”, niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tojo waꞌase nʉmʉrĩrẽ ʉpʉtʉ waro piꞌetise nirõsaꞌa. Õꞌacʉ̃ aꞌti turi wééca beꞌrore tocãꞌrõ piꞌetise marĩcaro niwʉ̃. Beꞌropʉ quẽꞌrãrẽ tocãꞌrõ waro piꞌetise marĩrõsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Õꞌacʉ̃ na piꞌetise nʉmʉrĩrẽ dʉoticãma, ne niꞌcʉ̃ yʉꞌrʉwetitibutiabosami. Õꞌacʉ̃ peꞌe cʉ̃ yarã, cʉ̃ beseꞌcãrãrẽ pajañaꞌgʉ̃, tojo waꞌase nʉmʉrĩrẽ dʉogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","»Ãpẽrã mʉsãrẽ aꞌtiro nisoorãsama. “Jãa, ĩꞌaña. Õꞌacʉ̃ beseꞌcʉ Cristo aꞌto nimi.” O apetero weerã “Sõꞌopʉ nimi”, nirãsama. Na tojo nicã, ẽjõpeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pãjãrã nisoori masã aꞌtirãsama. Aꞌtiro nirãsama: “Yʉꞌʉ Õꞌacʉ̃ beseꞌcʉ Cristo niꞌi. Õꞌacʉ̃ ye quetire weremʉꞌtãrĩ masʉ̃ niꞌi”, nisoorãsama. Narẽ ẽjõpeocã weesĩꞌrĩrã, peje weeĩꞌose ĩꞌorãsama. Basiocãma, Õꞌacʉ̃ cʉ̃ beseꞌcãrãpʉreta ẽjõpeoduꞌucã weesĩꞌrĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mʉsã basu masĩña majã. Yʉꞌʉ mʉsãrẽ beꞌropʉ waꞌatjere wereyutojaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tojo weerã ãpẽrã mʉsãrẽ “Sõꞌopʉ yucʉ marĩrõpʉ Cristo nisami, ĩꞌarã waꞌaya” nicã, waꞌaticãꞌña. Ãpẽrã “Aꞌti tucũpʉ nimi, ĩꞌarã aꞌtia” nicã, ẽjõpeoticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌtiri cura aꞌtiro nirõsaꞌa. Mujĩpũ mʉjãtiro peꞌe, cʉ̃ sãjãrõ peꞌe quẽꞌrãrẽ bʉpo yaꞌbaro weronojõ nirõsaꞌa. Yaꞌyioropʉ aꞌtisome. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Apĩnojõ waꞌicʉ boacã, yuca maata masĩ, wĩjĩwãꞌcãsama. Tojo waꞌacã ĩꞌarã, “Apĩnojõ boapĩ”, ni masĩꞌi. Aꞌte weronojõ yʉꞌʉ aꞌticã, masã masĩrãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesú aꞌtiro ninemowĩ: —Te piꞌetise nʉmʉrĩ yʉꞌrʉ́ca beꞌro mujĩpũ ʉmʉcocjʉ̃ naꞌitĩꞌa waꞌagʉsami. Ñamicjʉ̃ quẽꞌrã boꞌreyusome. Ñocõa bʉrʉdijarãsama. Nipeꞌtirã ʉꞌmʉarõpʉ nirã́ narãsãcã weenoꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tojo waꞌacã, ʉꞌmʉsepʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ yʉꞌʉ aꞌtisere ĩꞌarãsama. Nipeꞌtise macãrĩcjãrã uirã, utirãsama. Yʉꞌʉ oꞌmecururipʉ tutuaro meꞌrã asistedijaticã, ĩꞌarãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yʉꞌʉre werecoꞌterã ʉꞌmʉsecjãrãrẽ nipeꞌtiro aꞌti diꞌtapʉ oꞌógʉti. Yaro coroneta ʉpʉtʉ bʉsʉcã, yʉꞌʉ beseꞌcãrã nipeꞌtiro noꞌo nirõcjãrãrẽ neorãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","»Mʉsãrẽ otese higueragʉ wãmeticjʉ meꞌrã queose oꞌogʉti. Tigʉ dʉpʉripʉ pũrĩ ñasãwijicã, “Cʉ̃ꞌma waꞌarotiro weeꞌe”, nisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aꞌte weronojõ yʉꞌʉ todʉporo níꞌque peje waꞌacã ĩꞌarã, “Cãꞌrõacã Jesú aꞌti diꞌta wiogʉ sãjãtjo dʉꞌsaꞌa”, niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Diacjʉ̃ mʉsãrẽ weregʉti. Aꞌte peje tojo waꞌari cura nirã́ wẽrĩsome. Tojo waꞌasere ĩꞌapeꞌocãꞌrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aꞌti ʉmʉco, aꞌti diꞌta peꞌtidijarosaꞌa. Yʉꞌʉ ucũse, yʉꞌʉ buꞌese pũrĩcã ninuꞌcũcãꞌrõsaꞌa. Nipeꞌtise yʉꞌʉ níꞌque queoro waꞌarosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","»Yʉꞌʉ apaturi aꞌtiatjema ti nʉmʉ nicã, ti hora nicã aꞌtigʉsaꞌa nisere ne masĩnoꞌña marĩꞌi. Õꞌacʉ̃rẽ werecoꞌterã ʉꞌmʉsecjãrã, yʉꞌʉ Õꞌacʉ̃ macʉ̃ quẽꞌrã masĩweꞌe. Yʉꞌʉ pacʉ Õꞌacʉ̃ niꞌcʉ̃ta masĩsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","»Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌtiri cura quẽꞌrãrẽ dʉporocjʉ̃pʉ Noé cʉ̃ nícateropʉ weeꞌcaronojõ weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Õꞌacʉ̃ aꞌti turi miose dʉporo masã baꞌa, sĩꞌrĩ, omocã dʉꞌte, na põꞌrã numiarẽ numisocãrã niwã. Aꞌtere weetʉocãrã niwã téé Noé cʉ̃ yucʉsʉjopʉ sãjãrĩ curapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na, ne “Mejẽcã waꞌarosaꞌa”, ni wãcũmaꞌaticãrã niwã. Beꞌro acoro pejaa, narẽ dia miorĩ curapʉ tʉꞌomasĩcãrã niwã. Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌtiri cura quẽꞌrãrẽ masã mejãrõta weerãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yʉꞌʉ aꞌtiri cura ʉmʉa pʉarã niꞌcãrõ meꞌrã wesepʉ daꞌrarã, niꞌcʉ̃ yʉꞌʉre ẽjõpeogʉ mianoꞌgʉ̃sami. Apĩ yʉꞌʉre ẽjõpeotigʉ tojagʉ́sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pʉarã numia niꞌcãrõ meꞌrã ojoca ãrʉ̃arã, niꞌcõ yʉꞌʉre ẽjõpeogo mianoꞌgõsamo. Apego yʉꞌʉre ẽjõpeotigo tojagósamo. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","»Yʉꞌʉ mʉsã wiogʉ apaturi aꞌtiatjere mʉsã masĩtisaꞌa. Tojo weerã añurõ wãcũ, tʉꞌomasĩyuya. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Apeye quẽꞌrãrẽ aꞌtiro masĩña. Yajari masʉ̃ ti hora nicã aꞌtigʉsami nígʉ̃, wiꞌi wiogʉ cãrĩtisami. Cʉ̃rẽ coꞌte, cʉ̃ ya wiꞌire yajari masʉ̃ pãosãjãacã, cãꞌmotaꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mʉsã quẽꞌrã ãꞌrĩ weronojõ niña. Mʉsã ne cãꞌrõ wãcũtibutiari cura yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌtigʉsaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesú aꞌtiro ninemowĩ: —¿Noanojõ peꞌe yʉꞌʉ dutiro weenuꞌcũgʉ̃, tʉꞌomasĩgʉ̃ waro nisari? nígʉ̃, queose meꞌrã weregʉti. Wiogʉ aperopʉ waꞌagʉ, cʉ̃ ya wiꞌire coꞌtedutigʉ niꞌcʉ̃ cʉ̃rẽ daꞌracoꞌtegʉre cũasami. “Ãpẽrã daꞌracoꞌterãrẽ noꞌo dʉꞌsasenojõrẽ baꞌase ecaya”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Beꞌro aperopʉ ejaꞌcʉ dajasami. Cʉ̃ dajacã, queoro daꞌra bocaejanoꞌgʉ̃ eꞌcatisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Diacjʉ̃ mʉsãrẽ weregʉti. Cʉ̃ queoro weese wapa wiogʉ nipeꞌtise cʉ̃ cʉosere coꞌtedutigʉ sõrõgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Cʉ̃rẽ daꞌracoꞌtegʉ ñaꞌagʉ̃, “Yʉꞌʉ wiogʉ maata dajasome” nigʉ̃nojõ pũrĩcã aꞌtiro weesami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ãpẽrã daꞌracoꞌterãrẽ ñaꞌarõ paa piꞌeticã weesami. Ãpẽrã queꞌarã meꞌrã baꞌa, sĩꞌrĩsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cʉ̃ tojo weeri cura wiogʉ wãcũña marĩrõ cʉ̃ coꞌtetiri cura dajasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cʉ̃ cũaꞌcʉre dutiꞌquere weetiꞌque wapa ʉpʉtʉ waro cʉ̃rẽ buꞌiri daꞌregʉsami. Ãpẽrã ñaꞌarã, weetaꞌsari masãrẽ waꞌaꞌcaronojõ buꞌipejasirutugʉsami. Tojo waꞌacã, cʉ̃ pũrĩnoꞌgʉ̃, upicari cũꞌrĩdio, utigʉsami, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesú cʉ̃ wiogʉ nirõpʉ ¿noanojõ sãjãarõsari? nígʉ̃, aꞌte queose meꞌrã werewĩ: —Yʉꞌʉ wiogʉ nirõpʉre sãjãatje aꞌtiro weronojõ niꞌi. Diez nuꞌmia na meꞌrãcjõ marãpʉ niacjʉ aꞌticã coꞌtesama. Nánʉcʉ̃ ʉꞌse meꞌrã sĩꞌosepare cʉosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Niꞌcãmocʉrã nipeꞌtisere añurõ apoyutisama. Ãpẽrã ticʉrãta tja añurõ apoyu, coꞌtesama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Apoyutirã numia na ye sĩꞌosepare miarã, ʉꞌse na piosãa dʉcayuatjere miatisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Apoyuꞌcãrã numia peꞌe poseyeꞌquepapʉre miasama. Tojo nicã borewaria meꞌrã ʉꞌsere mianemosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Co marãpʉ niacjʉ maata etatisami. Tojo weerã narẽ wʉja pũrĩcã, cãrĩa waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Beꞌro ñami deco ẽjã́cã, ãpẽrã peꞌe aꞌtiro caricũmʉꞌtãsama: “Co marãpʉ niacjʉ aꞌtitojami. Põtẽrĩrã aꞌtia”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na tojo caricũcã, nipeꞌtirã numia wãꞌcãpeꞌtia waꞌasama. Wãꞌcã, na ye sĩꞌosepare apobʉrosama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ʉꞌse miatiꞌcãrã numia peꞌe ãpẽrã miaꞌcãrãrẽ aꞌtiro nisama: “Ʉ̃sã quẽꞌrãrẽ cãꞌrõ sĩꞌose ʉꞌse oꞌoya. Ʉ̃sã sĩꞌosepa yatiro weeꞌe”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ʉꞌse miaꞌcãrã numia peꞌe narẽ yʉꞌtisama: “Mʉsãrẽ oꞌosome. Ʉ̃sã mʉsãrẽ oꞌocãma, ʉ̃sãrẽ ejati, mʉsã quẽꞌrãrẽ ejatibosaꞌa. Mʉsã basu na ʉꞌse duawʉaropʉ duurã waꞌaya”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na niꞌcãmocʉrã numia ʉꞌse duurã waꞌáca beꞌro na meꞌrãcjõ marãpʉ niacjʉ etasami. Ãpẽrã apoyuꞌcãrã numia peꞌe cʉ̃ meꞌrã bosenʉmʉ weeri wiꞌipʉ sãjãasama. Na sãjã́áca beꞌro ti wiꞌicjãrã sopere biꞌacãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Beꞌropʉ ʉꞌse duurã ejaꞌcãrã numia sopepʉ eta, “Wiogʉ, ʉ̃sãrẽ pãoña”, nisama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na tojo pisucã tʉꞌogʉ, na meꞌrãcjõ marãpʉ niacjʉ narẽ yʉꞌtisami: “Diacjʉ̃ta mʉsãrẽ ne masĩtisaꞌa”, nisami, ni werewĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesú te queosere wéréca beꞌro ʉ̃sãrẽ niwĩ: —Aꞌte queose weronojõ yʉꞌʉ aꞌtiatji nʉmʉrẽ mʉsã masĩweꞌe. Tojo weerã añurõ wãcũ apoyuya, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesú ʉ̃sãrẽ aꞌtiro werenemowĩ: —Yʉꞌʉ aꞌti turipʉ apaturi aꞌtigʉ, masãrẽ oꞌoatje aꞌte queose weronojõ niꞌi. Niꞌcʉ̃ masʉ̃ ape diꞌtapʉ waꞌagʉ, cʉ̃rẽ daꞌracoꞌterãrẽ pijiosami. Narẽ cʉ̃ yere coꞌtedutigʉ cũusami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","»Narẽ na daꞌratjo põtẽorõ cũubʉrosami. Niꞌcʉ̃rẽ niꞌcãmocʉsetiri mil niyeru cujiri wapabʉjʉse cujirire oꞌosami. Apĩrẽ pʉati mil cujiri oꞌosami. Apĩrẽ mil cujiri oꞌosami. Oꞌotoja, waꞌa waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cʉ̃ waꞌáca beꞌro niꞌcãmocʉsetiri mil cujiri oꞌonoꞌcʉ maata te niyeru meꞌrã daꞌra, ticʉseta wapataꞌanemosami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pʉati mil cujiri cʉoꞌcʉ quẽꞌrã mejãrõta apeye pʉati mil cujiri wapataꞌanemosami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mil cujiri ñeꞌeꞌcʉ peꞌe cope seꞌe, cʉ̃ wiogʉ daꞌradutimiꞌquere yaacãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","»Beꞌro, yoáca beꞌropʉ na wiogʉ sijagʉ ejaꞌcʉ dajasami. Cʉ̃rẽ daꞌracoꞌterãrẽ pijio, na daꞌraꞌquere aposami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Niꞌcãmocʉsetiri mil cujiri cʉoꞌcʉ ejamʉꞌtãsami. Apeye ticʉseta cʉ̃ wapataꞌaꞌquere wiagʉ, cʉ̃ wiogʉre nisami: “Yʉꞌʉ wiogʉ, yʉꞌʉre niꞌcãmocʉsetiri mil cujiri oꞌowʉ. Aꞌte cʉoꞌo. Te meꞌrã apeye ticʉseta mʉꞌʉrẽ wapataꞌabosawʉ”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","»Cʉ̃ tojo nicã tʉꞌogʉ, wiogʉ nisami: “Mʉꞌʉ añurõ weeapã. Yʉꞌʉ dutiꞌcaronojõta queoro weemeꞌrĩcãꞌpã. Yʉꞌʉ cãꞌrõacã cũuꞌque meꞌrã añurõ weeapã. Tojo weegʉ peje yʉꞌʉ cʉosere coꞌtedutigʉ sõrõgʉ̃ti. Aꞌtia. Yʉꞌʉ meꞌrã eꞌcatitamuña”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","»Beꞌro apĩ daꞌracoꞌtegʉ pʉati mil cujiri oꞌonoꞌcʉ ejasami. Wiogʉre aꞌtiro nisami: “Yʉꞌʉ wiogʉ, yʉꞌʉre pʉati mil cujiri oꞌowʉ. Aꞌte cʉoꞌo. Te meꞌrã ticʉseta tja mʉꞌʉrẽ wapataꞌabosawʉ”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","»Wiogʉ cʉ̃rẽ nisami: “Mʉꞌʉ añurõ weeapã. Yʉꞌʉ dutiꞌcaronojõta queoro weemeꞌrĩcãꞌpã. Yʉꞌʉ cãꞌrõacã cũuꞌque meꞌrã añurõ weeapã. Tojo weegʉ peje yʉꞌʉ cʉosere coꞌtedutigʉ sõrõgʉ̃ti. Aꞌtia. Yʉꞌʉ meꞌrã eꞌcatitamuña”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","»Beꞌro majã mil cujiri oꞌonoꞌcʉ eja, cʉ̃ wiogʉre aꞌtiro nisami: “Yʉꞌʉ wiogʉ, mʉꞌʉ tutuaro daꞌradutiri masʉ̃ nisere masĩwʉ̃. Mʉꞌʉ daꞌratimigʉ̃, ãpẽrã ye daꞌrase wapa meꞌrã mʉꞌʉ wapataꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tojo weegʉ uigʉ, mʉꞌʉ ye niyerure diꞌta poꞌpeapʉ yaacũuwʉ̃. Aꞌte niꞌi mʉꞌʉ yéta tja”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","»Cʉ̃ tojo nicã tʉꞌogʉ, wiogʉ aꞌtiro yʉꞌtisami: “Yʉꞌʉ cũuꞌque meꞌrã mʉꞌʉ ñaꞌarõ weeapã. Ñaꞌagʉ̃, nijĩsijagʉ niꞌi. Mʉꞌʉ yʉꞌʉre aꞌtiro wãcũwʉ̃. ‘Daꞌratimigʉ̃, ãpẽrã daꞌrase wapa meꞌrã wapataꞌami’, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mʉꞌʉ tojo wãcũgʉ̃, yé niyerure yaatimigʉ̃, niyeru nʉrõrĩ wiꞌipʉ bʉcʉamʉjãdutigʉ cũubopã. Tojo wééca beꞌro yʉꞌʉ dajagʉ, ti wiꞌipʉ cũñarõ mʉjãꞌque meꞌrã ñeꞌeboapã”, nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","»Tojo níca beꞌro ãpẽrã topʉ nirãrẽ nisami: “Cʉ̃ ye mil cujirire ẽꞌma, diez mil cʉogʉ peꞌere oꞌoya. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aꞌtiro niꞌi. Noꞌo peje cʉogʉre nemorõ oꞌonoꞌrõsaꞌa. Cʉ̃ peje cʉoyʉꞌrʉogʉsami. Apĩ moogʉ̃ peꞌere cʉ̃ cʉomiꞌqueacãpʉreta ẽꞌmapeꞌocãꞌnoꞌgʉ̃sami. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ãꞌrĩ daꞌracoꞌtegʉ queoro weetigʉre ñeꞌe, naꞌitĩꞌarõ wijáropʉ cõꞌacãꞌña. Topʉ pũrĩnoꞌgʉ̃, upicari cũꞌrĩdio, utigʉsami”, nisami na wiogʉ, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesú ʉ̃sãrẽ werenemowĩ: —Beꞌro yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ aꞌti turicjãrãrẽ dutigʉ aꞌtigʉti. Yʉꞌʉre werecoꞌterã ʉꞌmʉsecjãrã meꞌrã aꞌtigʉ, asistese meꞌrã aꞌtigʉti. Beꞌro wiogʉ dujiri cũmurõpʉ dujigʉsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nipeꞌtise diꞌtacjãrã yʉꞌʉ dujiro tiropʉ nerẽrãsama. Tojo weegʉ yʉꞌʉre ẽjõpeorãrẽ mejẽcã, ãpẽrã yʉꞌʉre ẽjõpeotirãrẽ mejẽcã dʉcawaanʉꞌcõgʉ̃ti. Niꞌcʉ̃ ecarã coꞌtegʉ ovejare mejẽcã, cabrare mejẽcã dʉcawaanʉꞌcõgʉ̃ weronojõ weegʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cʉ̃ ovejare diacjʉ̃camocã peꞌe nʉꞌcõsami. Cabra peꞌere cũpe peꞌe nʉꞌcõsami. Aꞌte weronojõ yʉꞌʉre ẽjõpeorãrẽ diacjʉ̃ peꞌe nʉꞌcõgʉ̃ti. Yʉꞌʉre ẽjõpeotirã peꞌere cũpe peꞌe nʉꞌcõgʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tojo wééca beꞌro diacjʉ̃ peꞌe nuꞌcũrãrẽ nigʉ̃ti. “Aꞌtia. Yʉꞌʉ pacʉ mʉsãrẽ añurõ weeami. Ne waropʉ cʉ̃ aꞌti turire weenʉꞌcãcateropʉ mʉsã niatjore apoyutojacʉ niwĩ. Tere ñeꞌerã aꞌtia majã. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉꞌʉ ʉjaboacã, yʉꞌʉre ecawʉ. Yʉꞌʉ acowʉocã, sĩꞌrĩse tĩawʉ̃. Yʉꞌʉ aperopʉ sijacã, yʉꞌʉre cãrĩrõ oꞌowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Suꞌti dʉꞌsacã, yʉꞌʉre sãawʉ̃. Dutiticã, yʉꞌʉre ĩꞌacusiawʉ. Ãpẽrã yʉꞌʉre buꞌiri daꞌreri wiꞌipʉ sõrõcã, yʉꞌʉre ĩꞌarã etawʉ”, nigʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tere tʉꞌorã, diacjʉ̃ peꞌe nuꞌcũrã, na ñaꞌarõ weeꞌquere acobojonoꞌcãrã aꞌtiro nirãsama: “Ʉ̃sã wiogʉ ¿deꞌro nicã mʉꞌʉrẽ ʉjaboacã, ecari? ¿Deꞌro nicã mʉꞌʉ acowʉocã, tĩarĩ? ");
INSERT INTO tuoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Deꞌro nicã aperopʉ sijacã, mʉꞌʉrẽ cãrĩrõ oꞌori o suꞌtinojõ dʉꞌsacã, mʉꞌʉrẽ sãarĩ? ");
INSERT INTO tuoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Deꞌro nicã mʉꞌʉrẽ dutitigʉre, o buꞌiri daꞌreri wiꞌipʉ nigʉ̃rẽ ĩꞌarã etari?” nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","»Na tojo nicã, narẽ yʉꞌtigʉti: “Mʉsãrẽ diacjʉ̃ weregʉti. Mʉsã yʉꞌʉre ẽjõpeorãrẽ, noꞌo mejõ nirãpʉreta añurõ wéérã, yʉꞌʉreta weerã weewʉ.” ");
INSERT INTO tuoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","»Beꞌro cũpe peꞌe nuꞌcũrãrẽ aꞌtiro nigʉ̃ti: “Mʉsã Õꞌacʉ̃ buꞌiri daꞌrenoꞌajã niꞌi. Tojo weerã aꞌtore niticãꞌña. Pecameꞌe ʉ̃jʉ̃nuꞌcũrĩ meꞌe tiropʉ waꞌaya. Ti meꞌe wãtĩ wiogʉ, cʉ̃ meꞌrã ʉꞌmʉsepʉ cõꞌadijoꞌcãrãrẽ apoyúca meꞌe niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉꞌʉ ʉjaboacã, mʉsã yʉꞌʉre ecatiwʉ. Yʉꞌʉ acowʉocã, tĩatiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉꞌʉ aperopʉ sijacã, yʉꞌʉre cãrĩse oꞌotiwʉ. Yʉꞌʉre suꞌti dʉꞌsacã, sãatiwʉ. Yʉꞌʉ dutiticã, yʉꞌʉ buꞌiri daꞌreri wiꞌipʉ nicã quẽꞌrãrẽ, ĩꞌarã waꞌatiwʉ.” ");
INSERT INTO tuoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","»Tere tʉꞌorã, aꞌtiro nirãsama: “Wiogʉ, mʉꞌʉ ʉjaboacã, acowʉocã, aperopʉ sijacã, suꞌti moocã, dutiticã, buꞌiri daꞌreri wiꞌipʉ nicã, ¿deꞌro nicãnojõ ʉ̃sã mʉꞌʉrẽ weetamutiri?” nirãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","»Yʉꞌʉ narẽ yʉꞌtigʉti: “Diacjʉ̃ mʉsãrẽ weregʉti. Mʉsã ãꞌrã mejõ nirãrẽ weetamutiwʉ. Narẽ weetamutirã, yʉꞌʉreta weetamutirã weewʉ”, nigʉ̃ti. ");
INSERT INTO tuoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","»Beꞌro narẽ buꞌiri daꞌre bajuriogʉti. Ãpẽrã ñaꞌarõ weeꞌquere acobojonoꞌcãrã peꞌe catinuꞌcũsere boca, ʉꞌmʉsepʉ waꞌarãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesú apaturi cʉ̃ aꞌtiatjere wéréca beꞌro ʉ̃sã cʉ̃ buꞌerãrẽ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mʉsã masĩꞌi, Pascua bosenʉmʉ waꞌatjo pʉa nʉmʉ dʉꞌsaꞌa. Ti bosenʉmʉ nicã, yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre wiorãpʉre oꞌo, curusapʉ paabiꞌpe wẽjẽrãsama, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Titare paꞌia wiorã, Moisé ojaꞌquere buꞌeri masã, judío masã bʉcʉrã, Caifá paꞌia wiogʉ ya wiꞌi sope pʉꞌtopʉ nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Topʉ na Jesure nisoose meꞌrã ñeꞌe, wẽjẽatjere apoyucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tere apomirã, aꞌtiro nicãrã niwã: —Bosenʉmʉ nicã weeticãꞌrã. Masã cʉ̃rẽ maꞌírã, noꞌo ʉaro caricũmaꞌa, marĩ tojo weesere dojorẽbosama, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na “Jesure wẽjẽrãti” ni apocaterore Jesú Betaniapʉ niwĩ. Simó cãmi boa, yʉꞌrʉꞌcʉ ya wiꞌipʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Topʉ cʉ̃ nicã, niꞌcõ numio cʉ̃ pʉꞌto aꞌtiwõ. Co ʉꞌmʉticja acosticjare cʉowõ. Te ʉꞌmʉtise wapabʉjʉse waro niwʉ̃. Co Jesú baꞌadujigʉre cʉ̃ dʉpoa buꞌipʉ ʉꞌmʉtise piopeowõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Co tojo weecã ĩꞌarã, ʉ̃sã cʉ̃ buꞌerã ʉpʉtʉ uawʉ. Ʉ̃sã basu aꞌmerĩ niwʉ̃: —¿Deꞌro weego tojo weeti? Mejõ waro aꞌtere bajuriogo weemo. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Co tojo weetigo, ãpẽrãrẽ pajiro duawapataꞌaboapõ. Te meꞌrã pajasecʉorãrẽ weetamuboapõ, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesú ʉ̃sã tojo nisere masĩgʉ̃, ʉ̃sãrẽ niwĩ: —¿Deꞌro weerã core cariborã weeti? Aꞌtere yʉꞌʉre tojo wéégo, añurõ weego weemo. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pajasecʉorã mʉsã waꞌteropʉ ninuꞌcũcãꞌrãsama. Yʉꞌʉ pũrĩcãrẽ mʉsã waꞌteropʉre ninuꞌcũcã ĩꞌasome. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Co yʉꞌʉre tere piopeogo, yʉꞌʉ wẽ́rĩ́ca beꞌro na yaatji dʉporo waꞌreatjere weronojõ weeyugo weemo. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diacjʉ̃ mʉsãrẽ weregʉti. Yʉꞌʉ masãrẽ yʉꞌrʉose quetire noꞌo nirṍ werecusiarã, nipeꞌtiro aꞌti diꞌtapʉre aꞌtiro weerãsama. Aꞌtigo co yʉꞌʉre weeꞌquere core wãcũdutirã wererãsama, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesú numiorẽ tojo níca beꞌro ʉ̃sã Jesú buꞌerã meꞌrãcjʉ̃ níꞌcʉ, Juda Iscariote na nigʉ̃́ aꞌtiro weewĩ. Paꞌia wiorã tiropʉ waꞌatjĩgʉ̃, ucũgʉ̃ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Narẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉ Jesure mʉsãrẽ oꞌocã, ¿noꞌocãꞌrõ niyeru yʉꞌʉre wapayerãsari? nicʉ niwĩ. Tojo nicã tʉꞌorã, na treinta niyeru cujirire oꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na wapayéca beꞌro cʉ̃ “¿Deꞌro nicã Jesure wiorãpʉre oꞌoroʉamitito yʉꞌʉre?” ni wãcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ʉ̃sã Jesú buꞌerã na pã́ bʉcʉase meꞌrã morẽtiꞌquere baꞌari bosenʉmʉ ninʉꞌcãcã, cʉ̃ tiro waꞌa, sẽrĩtiñaꞌwʉ̃: —¿Noꞌopʉ marĩ Pascua bosenʉmʉ baꞌatjore apoyucã ʉasari? niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cʉ̃ ʉ̃sãrẽ niwĩ: —Jerusalẽ́pʉ waꞌaya. Topʉ niꞌcʉ̃ nisami. Cʉ̃rẽ aꞌtiro niña. “Ʉ̃sãrẽ buꞌegʉ aꞌtiro nidutiami: ‘Yʉꞌʉ piꞌetiatjo cãꞌrõacã dʉꞌsaꞌa. Mʉꞌʉ ya wiꞌipʉ yʉꞌʉ buꞌerã meꞌrã baꞌatʉogʉti’, ni weredutiami Jesú”, niña. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tojo weerã Jesú oꞌóꞌcãrã cʉ̃ dutiꞌcaronojõta weecãrã niwã. Pascua nicã ʉ̃sã baꞌatjere apoyucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naꞌiqueꞌaca beꞌro Jesú ʉ̃sã cʉ̃ buꞌerã doce meꞌrã baꞌadujiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ʉ̃sã baꞌari cura Jesú ʉ̃sãrẽ niwĩ: —Diacjʉ̃ta mʉsãrẽ weregʉti. Niꞌcʉ̃ mʉsã waꞌteropʉ nigʉ̃́ yʉꞌʉre wiorãpʉre wẽjẽdutigʉ oꞌogʉsami, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cʉ̃ tojo nicã, ʉ̃sã ʉpʉtʉ bʉjawetiwʉ. Beꞌro aꞌmerĩ sẽrĩtiñaꞌbʉrowʉ: —Ʉ̃sã wiogʉ, yʉꞌʉta nicãꞌsaꞌaba, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesú ʉ̃sãrẽ yʉꞌtiwĩ: —Yʉꞌʉ meꞌrã aꞌti papʉ yosobaꞌagʉ cʉ̃́ta nigʉ̃sami wiorãpʉre oꞌoacjʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre Õꞌacʉ̃ ye queti ojáca pũrĩ níꞌcaronojõta waꞌarosaꞌa. Tojo waꞌacã, yʉꞌʉre wiorãpʉre oꞌogʉma ñaꞌabutiaro waꞌarosaꞌa. Cʉ̃ diacjʉ̃ta bajuatiyʉꞌrʉocã, nemorõ añubopã, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tojo níca beꞌroacã Juda Jesure wiorãpʉre oꞌoacjʉ aꞌtiro niwĩ: —Ʉ̃sãrẽ buꞌegʉ, yʉꞌʉta nicãꞌsaꞌaba, niwĩ. Jesú cʉ̃rẽ yʉꞌtiwĩ: —Mʉꞌʉta niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ʉ̃sã baꞌari cura Jesú pãgãrẽ mii, cʉ̃ pacʉ Õꞌacʉ̃rẽ eꞌcatise oꞌowĩ. Tuꞌajanʉꞌcõ, pã́rẽ dʉcawaa, ʉ̃sãrẽ ecawĩ. Dʉcawaagʉ, ʉ̃sãrẽ niwĩ: —Baꞌaya. Aꞌte yʉꞌʉ upʉ niꞌi, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Beꞌro sĩꞌrĩrĩ pare mii, Õꞌacʉ̃rẽ eꞌcatise oꞌowĩ tja. Ti pare ʉ̃sãrẽ tĩagʉ̃, aꞌtiro niwĩ: —Nipeꞌtirã aꞌti pa cjasere sĩꞌrĩpeꞌticãꞌña. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aꞌte yé dí niꞌi. Masã ñaꞌarõ weeꞌquere wẽrĩ wapayebosagʉsaꞌa. Õꞌacʉ̃ masãrẽ apeye maꞌma “Aꞌtiro weegʉti” níꞌquere cũugʉ̃sami. Tojo weegʉ yʉꞌʉ wẽrĩgʉ̃ dí oꞌmabʉrose meꞌrã pãjãrã masã ñaꞌarõ weeꞌquere acobojogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉsãrẽ weregʉti. Aꞌte ʉꞌsedʉcaco vino niꞌcãrõacã marĩ sĩꞌrĩrã weronojõ weenemosome. Beꞌro yʉꞌʉ pacʉ yʉꞌʉre wiogʉ sõrõcã, mʉsã meꞌrã apaturi maꞌma vino sĩꞌrĩnemogʉ̃saꞌa tja, niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ʉ̃sã baꞌáca beꞌro Õꞌacʉ̃rẽ basapeotojanʉꞌcõ, ti wiꞌire wijaa waꞌawʉ. Wijaa, ʉ̃rʉ̃gʉ̃ Olivo wãmeticjʉpʉ waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Topʉ waꞌagʉ, Jesú ʉ̃sãrẽ niwĩ: —Mʉsã nipeꞌtirã aꞌti ñami uirã, yʉꞌʉre cõꞌawãꞌcãpeꞌtia waꞌarãsaꞌa. Mʉsã tojo weeatje Õꞌacʉ̃ ye queti ojáca pũrĩpʉ nírõnojõta waꞌarosaꞌa. Aꞌtiro ojanoꞌwʉ̃: “Yʉꞌʉ oveja coꞌtegʉre wẽjẽnoꞌcã weegʉsaꞌa. Tojo weecã, cʉ̃ yarã oveja noꞌo ʉaro omastearãsama”, nicʉ niwĩ Õꞌacʉ̃ cʉ̃ ye queti ojáca pũrĩpʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yʉꞌʉ wẽrĩꞌcʉpʉ masã́ca beꞌro mʉsã dʉporo Galilea diꞌtapʉ waꞌayutojagʉsaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Cʉ̃ tojo nicã tʉꞌogʉ, Pedro yʉꞌtiwĩ: —Ãpẽrã mʉꞌʉrẽ cõꞌawãꞌcãcã, yʉꞌʉ pũrĩcã ne waꞌasome, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tojo nisere tʉꞌogʉ, Jesú cʉ̃rẽ niwĩ: —Diacjʉ̃ mʉꞌʉrẽ weregʉti. Niꞌcãcã ñamita cãrẽꞌquẽ uuati dʉporo iꞌtiati “Cʉ̃rẽ ne masĩweꞌe”, nigʉ̃saꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro cʉ̃rẽ yʉꞌtiwĩ: —Yʉꞌʉ pũrĩcã na yʉꞌʉre wẽjẽsĩꞌrĩcãma, “Cʉ̃ meꞌrã boagʉti”, nigʉ̃saꞌa. “Cʉ̃rẽ masĩweꞌe”, nisome, niwĩ. Beꞌro nipeꞌtirã ʉ̃sã cʉ̃ buꞌerã cʉ̃ níꞌcaronojõta nibʉrowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Beꞌro Jesú ʉ̃sã cʉ̃ buꞌerã meꞌrã masã na otero Getsemaní wãmetiropʉ etawʉ. Topʉ eta, ʉ̃sãrẽ niwĩ: —Aꞌto dujíniña yujupʉ. Sõꞌopʉ yʉꞌʉ pacʉre sẽrĩgʉ̃ waꞌagʉti, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Topʉ waꞌagʉ, Pedro, tojo nicã Zebedeo põꞌrã pʉarãrẽ miawĩ. Cʉ̃ ʉpʉtʉ waro bʉjaweti, wãcũqueꞌticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tojo weegʉ narẽ nicʉ niwĩ: —Yʉꞌʉre wẽrĩtawioro, bʉjawetise yʉꞌrʉmajãsaꞌa. Mʉsã aꞌto tojayá. Yʉꞌʉre coꞌteya. Ne cãrĩticãꞌña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cʉ̃ tojo níca beꞌro na yʉꞌrʉro yoacurero waꞌa, diꞌtapʉ muꞌrĩqueꞌaejacʉ niwĩ. Topʉ Õꞌacʉ̃rẽ sẽrĩgʉ̃, aꞌtiro nicʉ niwĩ: —Pacʉ, mʉꞌʉ ʉacã, yʉꞌʉre aꞌte ñaꞌarõ yʉꞌrʉatje waꞌaticãꞌto. Yʉꞌʉ tojo nimicã, yʉꞌʉ ʉaro weeticãꞌña. Mʉꞌʉ ʉaro peꞌe waꞌato, ni sẽrĩcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Beꞌro cʉ̃ buꞌerã iꞌtiarã tiropʉ majãmitojacʉ niwĩ. Na cãrĩꞌcãrãpʉre bocaejacʉ niwĩ. Pedrore aꞌtiro nicʉ niwĩ: —¿Ne cãꞌrõacã cãrĩtimirã, mʉsã tʉꞌsʉmasĩtisari? ");
INSERT INTO tuoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cãrĩticãꞌña. Wãtĩ ʉ̃sãrẽ niquesãticãꞌto nírã, Õꞌacʉ̃rẽ sẽrĩña. Mʉsã wãcũsepʉ meꞌrãma yʉꞌʉre ẽjõpeonuꞌcũsĩꞌrĩmisaꞌa. Mʉsã seꞌsaro tojo weesĩꞌrĩmirã, wãcũtutuamasĩtisaꞌa. Tojo weerã Õꞌacʉ̃rẽ sẽrĩña, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Beꞌro apaturi waꞌa, cʉ̃ pacʉre sẽrĩnemocʉ niwĩ tja: —Pacʉ, ñaꞌarõ piꞌetisere yʉꞌʉre cãꞌmotaꞌasĩꞌrĩtigʉ, mʉꞌʉ ʉaro weeya. Yʉꞌʉ ʉaro waꞌaticãꞌto, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Beꞌro apaturi na iꞌtiarã tiropʉ majãmitojacʉ niwĩ. Na cãrĩꞌcãrãpʉre bocaejacʉ niwĩ tja. Narẽ wʉja pũrĩyʉꞌrʉacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tojo weegʉ narẽ wãꞌcõtimigʉ̃, apaturi cʉ̃ pacʉre sẽrĩgʉ̃ waꞌacʉ niwĩ tja. Cʉ̃ sẽrĩꞌcaronojõta sẽrĩcʉ niwĩ tja. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Beꞌro na tiropʉ majãmitojagʉ, narẽ aꞌtiro nicʉ niwĩ: —Niꞌcãrõacãma sooya; cãrĩña majã. Yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉre masã ñaꞌarãpʉre oꞌoatje ejatojaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wãꞌcãnʉꞌcãña. Teꞌa na tiropʉ waꞌarã. Yʉꞌʉre oꞌoacjʉ aꞌtitojami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesú ucũrĩ cura Juda, ʉ̃sã Jesú buꞌerã meꞌrã nimiꞌcʉ etawĩ. Pãjãrã masã diꞌpjĩrĩ, yucʉpagʉ cʉoꞌcãrã cʉ̃ meꞌrã aꞌtiwã. Na paꞌia wiorã, judío masã bʉcʉrã na oꞌóꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juda Jesure oꞌoacjʉ aꞌtiro wereyutojacʉ niwĩ: —Yʉꞌʉ waꞌsuporopʉ miꞌmiacjʉ cʉ̃́ta nigʉ̃sami. Cʉ̃rẽ ñeꞌeña, ni wereyucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cʉ̃ narẽ níꞌcaronojõta weewĩ. Maata Jesú tiropʉ ejanʉꞌcãgʉ̃, “Yʉꞌʉre buꞌegʉ”, niwĩ. Tojo nígʉ̃ta, Jesure waꞌsuporopʉ miꞌmiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tojo weecã ĩꞌagʉ̃, Jesú cʉ̃rẽ niwĩ: —Yʉꞌʉ meꞌrãcjʉ̃, mʉꞌʉ weegʉ aꞌtisere weeya. Tojo níca beꞌro masã aꞌti, Jesure ñeꞌewãꞌcã waꞌawã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na cʉ̃rẽ ñeꞌewãꞌcãrĩ cura niꞌcʉ̃ Jesú buꞌegʉ cʉ̃ ya diꞌpjĩrẽ wejewee, paꞌia wiogʉre daꞌracoꞌtegʉre oꞌmepero dʉtepãꞌrẽcãꞌwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Cʉ̃ tojo weecã ĩꞌagʉ̃, Jesú cʉ̃rẽ niwĩ: —Weeticãꞌña. Mʉꞌʉ ya diꞌpjĩrẽ nʉrõña. Diꞌpjĩ meꞌrã aꞌmequẽrãnojõ diꞌpjĩ meꞌrãta wẽrĩrãsama. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mʉꞌʉ masĩweti? Yʉꞌʉ, yʉꞌʉ pacʉre sẽrĩcãma, maata doce cururi cʉ̃rẽ werecoꞌterãrẽ yʉꞌʉre weetamudutigʉ oꞌóbosami. Yʉꞌʉ tojo weemasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yʉꞌʉ tojo weecãma, Õꞌacʉ̃ ye queti ojáca pũrĩpʉ níꞌque waꞌatibosaꞌa, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesú cʉ̃rẽ ñeꞌerã aꞌtirãrẽ niwĩ: —¿Yajari masʉ̃rẽ ñeꞌerã aꞌtirã weronojõ yʉꞌʉre diꞌpjĩrĩ, yucʉpagʉ meꞌrã ñeꞌerã aꞌtiati? Nipeꞌtise nʉmʉrĩ Õꞌacʉ̃ wiꞌipʉ masãrẽ buꞌedujiwʉ. Tojo weemicã, mʉsã yʉꞌʉre ñeꞌetiwʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mʉsã niꞌcãrõacã weese Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masã yʉꞌʉre ojaꞌcaronojõta waꞌaꞌa, niwĩ Jesú. Cʉ̃rẽ ñeꞌecã ĩꞌa, niꞌcʉ̃rẽta ʉ̃sã cʉ̃ buꞌerã peꞌe cõꞌanʉꞌcõcã, duꞌtiwãꞌcãpeꞌtia waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Beꞌro Jesure paꞌia wiogʉ Caifá tiropʉ miacãrã niwã. Topʉre Moisé ojaꞌquere buꞌeri masã, tojo nicã judío masã bʉcʉrã nerẽyutojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro peꞌe Jesure yoacurero sirutucʉ niwĩ. Paꞌia wiogʉ ya wiꞌi sope pʉꞌtopʉ sirututʉocʉ niwĩ. Topʉ ti sãꞌrĩrõpʉ sãjãa, surara pʉꞌto dujicʉ niwĩ. ¿Deꞌro waꞌabutiarosari? nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paꞌia wiorã, judío masã bʉcʉrã, nipeꞌtirã wiorã Jesure wẽjẽsĩꞌrĩcãrã niwã. Tojo weerã diacjʉ̃ nitise meꞌrã cʉ̃rẽ weresãtjere aꞌmacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pãjãrã na tiro waꞌa, mejẽcã nisoomirã, ne cʉ̃rẽ “Te ye buꞌiri wẽjẽrõʉaꞌa” nisere bocaticãrã niwã. Tojo weecũmí, beꞌropʉ pʉarã nisoori masãrẽ bocacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Aꞌtiro nisoocãrã niwã: —Ãꞌrĩ masʉ̃ aꞌtiro niwĩ: “Aꞌti wiꞌi Õꞌacʉ̃ wiꞌire cõꞌapeꞌomasĩꞌi. Iꞌtia nʉmʉ beꞌro apaturi tuꞌajanʉꞌcõpeꞌomasĩꞌi tja”, niwĩ, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tojo nicã tʉꞌogʉ, paꞌia wiogʉ wãꞌcãnʉꞌcã, Jesure nicʉ niwĩ: —¿Mʉꞌʉ yʉꞌtiweti? ¿Deꞌro ni yʉꞌtigʉsari na weresãsere? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesú yʉꞌtitiyʉꞌrʉocãꞌcʉ niwĩ. Tojo weecã, Caifá cʉ̃rẽ nicʉ niwĩ: —Õꞌacʉ̃ catinuꞌcũgʉ̃ wãme meꞌrã mʉꞌʉrẽ diacjʉ̃ yʉꞌticã ʉaꞌa. Wereya. ¿Mʉꞌʉta niti Õꞌacʉ̃ macʉ̃ cʉ̃ beseꞌcʉ Cristo na nigʉ̃́? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesú cʉ̃rẽ yʉꞌticʉ niwĩ: —Cʉ̃́ta niꞌi mʉꞌʉ nírõnojõta. Apeye quẽꞌrãrẽ mʉsãrẽ werenemogʉ̃ti. Beꞌro yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ Õꞌacʉ̃ tutuayʉꞌrʉgʉ pʉꞌtopʉ dujicã ĩꞌarãsaꞌa. Tojo nicã yʉꞌʉ oꞌmecururi buꞌipʉ apaturi dijaticã ĩꞌarãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cʉ̃ tojo nicã tʉꞌogʉ, Caifá paꞌia wiogʉ uagʉ, cʉ̃ basu cʉ̃ ye suꞌtire wejetʉ̃ꞌrẽcʉ niwĩ. Aꞌtiro nicʉ niwĩ: —Ãꞌrĩ masʉ̃ tojo ucũgʉ̃, Õꞌacʉ̃rẽ ñaꞌabutiaro nigʉ̃ weemi. Ãpẽrã masã cʉ̃rẽ weresãrã ʉanemoweꞌe. Mʉsã cʉ̃ ñaꞌarõ níꞌquere tʉꞌotojapʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Deꞌro ni wãcũti? nicʉ niwĩ. Na yʉꞌticãrã niwã: —Cʉ̃ buꞌiritimi. Wẽrĩato, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tojo níca beꞌro cʉ̃ diapoapʉ ʉꞌseco eꞌowaꞌre, cʉ̃rẽ dotecãrã niwã. Ãpẽrã diapoapʉ paacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Beꞌro cʉ̃rẽ aꞌtiro ni bujipecãrã niwã: —Mʉꞌʉ Õꞌacʉ̃ beseꞌcʉ Cristo niꞌi nígʉ̃, níbocaya. ¿Noa mʉꞌʉrẽ paati? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na wiꞌi poꞌpeapʉ tojo weeri cura Pedro wijaaro sope pʉꞌtopʉ dujicʉ niwĩ. Cʉ̃ topʉ dujicã, niꞌcõ ti wiꞌi daꞌracoꞌtego cʉ̃ tiropʉ waꞌa, “Mʉꞌʉ Jesú Galileacjʉ̃ meꞌrã sijaꞌcʉta niꞌiba”, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Co tojo nicã tʉꞌogʉ, Pedro nipeꞌtirã tʉꞌoropʉ nisoogʉ, aꞌtiro ni yʉꞌticʉ niwĩ: —Mʉꞌʉ tojo ucũsere tʉꞌomasĩtisaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tojo nitoja, sãꞌrĩrõ sope pʉꞌtopʉ wijaacʉ niwĩ. To cʉ̃ wijaacã, apego cʉ̃rẽ ĩꞌabocaco niwõ tja. Topʉ nirãrẽ aꞌtiro nico niwõ: —Ãꞌrĩ quẽꞌrã Jesú Nazarecjʉ̃ meꞌrã sijaꞌcʉta nimi, nico niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mejãrõta core nisoogʉ, aꞌtiro yʉꞌticʉ niwĩ: —Õꞌacʉ̃ meꞌrã diacjʉ̃ta cʉ̃rẽ ne masĩtibutiacãꞌsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cãꞌrõacã beꞌro masã topʉ nirã́ Pedro tiro waꞌa, cʉ̃rẽ nicãrã niwã: —Mʉꞌʉ quẽꞌrã Jesú buꞌerã meꞌrã sijaꞌcʉta niꞌi. Mʉꞌʉ ucũsepʉta tʉꞌota basio niꞌi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na tojo nicã tʉꞌogʉ, cʉ̃ narẽ nisoonemopeocʉ niwĩ: —Yʉꞌʉ diacjʉ̃ta ucũticã, Õꞌacʉ̃ yʉꞌʉre buꞌiri daꞌreato. Yʉꞌʉ mʉsã ucũgʉ̃rẽ ne masĩtisaꞌa, nicʉ niwĩ. Cʉ̃ tojo nicũñarĩ cura cãrẽꞌquẽ uucʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tojo waꞌacã, Jesú cʉ̃rẽ ucũꞌquere wãcũbocacʉ niwĩ. Jesú todʉporopʉ aꞌtiro wereyucʉ niwĩ: “Cãrẽꞌquẽ uuati dʉporo mʉꞌʉ iꞌtiati yʉꞌʉre ‘Cʉ̃rẽ masĩweꞌe’, nigʉ̃saꞌa.” Tere wãcũboca wijaa, ʉpʉtʉ utiwãꞌcã waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ñamiacãcure nipeꞌtirã paꞌia wiorã, tojo nicã judío masã bʉcʉrã nerẽcãrã niwã. Nerẽ, niꞌcãrõnojõ wãcũseticãrã niwã. “¿Deꞌro wee marĩ Jesure wẽjẽrãsari?” ni apoyucãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Apotoja, Jesure cõme dari meꞌrã dʉꞌtetjĩarã, Poncio Pilato, Judea diꞌta wiogʉ tiropʉ miiejacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Beꞌro Juda “Jesure wẽjẽrãsama” nisere tʉꞌocʉ niwĩ. Tere tʉꞌogʉ, pũrõ waro bʉjaweticʉ niwĩ. Tojo weegʉ na niyeru wapayeꞌque treinta cujirire paꞌia wiorãrẽ, tojo nicã judío masã bʉcʉrãrẽ wiacãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Narẽ nicʉ niwĩ: —Yʉꞌʉ ñaꞌabutiaro weeasʉ. Masʉ̃ añugʉ̃, buꞌiri marĩgʉ̃rẽ wẽjẽdutigʉ wiorãpʉre oꞌoasʉ, nicʉ niwĩ. Na cʉ̃rẽ yʉꞌticãrã niwã: —Mʉꞌʉ tojo weese ʉ̃sã ye mejẽta niꞌi. Mʉꞌʉ ye cjase nisaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na tojo nicã tʉꞌogʉ, Juda niyerure Õꞌacʉ̃ wiꞌipʉ doquewiacãꞌcʉ niwĩ. Beꞌro waꞌa, cʉ̃ basu wãmʉtapʉ dʉꞌteyoja, wẽrĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Paꞌia wiorã niyeru cujirire seeneorã, aꞌtiro nicãrã niwã: —Aꞌte niyeru masʉ̃rẽ wẽjẽse wapa niꞌi. Tojo weerã marĩ Õꞌacʉ̃ wiꞌi niyeru cũurĩ acaropʉ cũumasĩtisaꞌa. Marĩrẽ dutise tojo weedutiweꞌe, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Beꞌro na basu aꞌmerĩ ucũ, aꞌtiro wãcũcãrã niwã: —Marĩ aꞌte niyeru meꞌrã diꞌta sʉtʉparʉ yeerãtirã na diꞌi miirõrẽ duurã. Tojo weerã marĩ aperocjãrã na wẽrĩcã yaatjo nirõsaꞌa, ni apocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Masʉ̃ wẽjẽse wapa meꞌrã duuca diꞌta nicaro niwʉ̃. Tojo weero aꞌtocatero quẽꞌrã ti diꞌta “Dí cõꞌáca diꞌta” wãmetiꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Dʉporocjʉ̃pʉta Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Jeremía cʉ̃ “Aꞌtiro waꞌarosaꞌa” níꞌque queoro waꞌacaro niwʉ̃. Cʉ̃ aꞌtiro ojacʉ niwĩ: “Israe curuacjãrã ‘Treinta niyeru cujiri wapatimi’ níꞌcaro weronojõta te niyeru meꞌrã diꞌta sʉtʉparʉ yeerãtirã na diꞌi miirõrẽ duurãsama. Õꞌacʉ̃ yʉꞌʉre ojadutiꞌcaronojõta weerãsama”, ni ojacʉ niwĩ Jeremía. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Beꞌro Jesure Judea diꞌta wiogʉ Pilato tiropʉ miacãrã niwã. Pilato cʉ̃rẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Mʉꞌʉta niti judío masã wiogʉ? nicʉ niwĩ. Jesú cʉ̃rẽ yʉꞌticʉ niwĩ: —Mʉꞌʉ nírõnojõta cʉ̃́ta niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Paꞌia wiorã, judío masã bʉcʉrã weresãse peꞌema ne yʉꞌtitiyʉꞌrʉocãꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tojo weegʉ Pilato cʉ̃rẽ nicʉ niwĩ: —¿Deꞌro weegʉ mʉꞌʉ na ucũse pejere yʉꞌtiweti? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesú ne cãꞌrõ yʉꞌtiticʉ niwĩ. Cʉ̃ yʉꞌtiticã ĩꞌagʉ̃, Pilato ĩꞌamarĩa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cʉ̃ꞌmarĩnʉcʉ̃ Pascua bosenʉmʉ nicã Judea diꞌta wiogʉ aꞌtiro weeseticũcʉ niwĩ. Niꞌcʉ̃ buꞌiri daꞌreri wiꞌipʉ nigʉ̃rẽ masã na duꞌuwĩrõdutigʉre duꞌuwĩrõcũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Titare niꞌcʉ̃ buꞌiri daꞌreri wiꞌipʉ nigʉ̃́ Barrabá wãmetigʉ nicʉ niwĩ. Nipeꞌtirã cʉ̃ ñaꞌarõ weeꞌquere masĩcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilato masã pãjãrã cʉ̃ tiropʉ nerẽcã ĩꞌagʉ̃, narẽ sẽrĩtiñaꞌcʉ niwĩ: —¿Niꞌirẽ yʉꞌʉ duꞌuwĩrõcã ʉasari? ¿Barrabáre duꞌuwĩrõsari, o Jesú na Cristo pisunoꞌgʉ̃ peꞌere duꞌuwĩrõsari? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesure masã maꞌicã ĩꞌarã, wiorã Jesure ʉocãrã niwã. Cʉ̃rẽ ʉorã, Pilatopʉre wiacãrã niwã. Na tojo ʉosere Pilato masĩcʉ niwĩ. Tojo weegʉ Jesure duꞌuwĩrõsĩꞌrĩgʉ̃, tere sẽrĩtiñaꞌcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato masãrẽ besewʉaropʉ dujicʉ niwĩ. Cʉ̃ topʉ dujicã, cʉ̃ nʉmo aꞌtiro queti oꞌóco niwõ: “Cʉ̃ masʉ̃ buꞌiri moogʉ̃rẽ mejẽcã weeticãꞌña. Ñamipʉ cʉ̃rẽ tojo waꞌatjere wiobutiaro quẽꞌeasʉ”, ni queti oꞌóco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Paꞌia wiorã, tojo nicã judío masã bʉcʉrã masãrẽ aꞌtiro niduticãrã niwã: —Barrabá peꞌere duꞌuwĩrõdutiya. Jesú peꞌere wẽjẽdutiya, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Beꞌro Pilato masãrẽ sẽrĩtiñaꞌnemocʉ niwĩ: —Ãꞌrã pʉarãrẽ ¿niꞌí peꞌere yʉꞌʉ duꞌuwĩrõcã ʉasari? nicʉ niwĩ. Na aꞌtiro yʉꞌticãrã niwã: —Barrabáre duꞌuwĩrõña, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na tojo nicã tʉꞌogʉ, Pilato nicʉ niwĩ: —To pũrĩcãrẽ Jesú na Cristo nigʉ̃rẽ ¿deꞌro weegʉsari? Nipeꞌtirã yʉꞌticãrã niwã: —Curusapʉ paabiꞌpe wẽjẽña, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tojo nicã tʉꞌogʉ, Pilato nicʉ niwĩ: —¿Deꞌro weegʉ tojo weebosari? Ãꞌrĩ ne cãꞌrõ ñaꞌarõ weeticʉ niami, nicʉ niwĩ. Cʉ̃ tojo nimicã, masã peꞌe caricũnemocãrã niwã: —Curusapʉ paabiꞌpe wẽjẽña, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Masã Pilato ucũsere tʉꞌosĩꞌrĩticãrã niwã. Tojo tʉꞌoronojõ oꞌorã, mejõ peꞌe cumuca wãꞌcõcãrã niwã. Na tojo weecã ĩꞌagʉ̃, Pilato aco miitiduticʉ niwĩ. Te meꞌrã masã ĩꞌorõpʉ omocoe, aꞌtiro nicʉ niwĩ: —Ãꞌrĩ masʉ̃ buꞌiri moogʉ̃rẽ wẽjẽcã, yʉꞌʉ buꞌiri moogʉ̃saꞌa. Mʉsã basu buꞌiritirãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cʉ̃ tojo nicã tʉꞌorã, masã nipeꞌtirã topʉ nirã́ yʉꞌticãrã niwã: —Cʉ̃ wẽrĩse wapa ʉ̃sã põꞌrã meꞌrã buꞌiri cʉorãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tojo nicã tʉꞌogʉ, Pilato Barrabáre duꞌuwĩrõcʉ niwĩ. Jesú peꞌere tãrãduticʉ niwĩ. Beꞌro curusapʉ surarare paabiꞌpe wẽjẽduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Beꞌro Pilato yarã surara cʉ̃ ya wiꞌipʉ Jesure miacãrã niwã. Topʉ nipeꞌtirã surara nerẽnʉꞌcãtjĩrã, Jesure beꞌtoanʉꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Beꞌro cʉ̃ yaro suꞌtirore tuwee, suꞌtiro sõꞌarõ wiorã sãñarõnojõrẽ sãacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cʉ̃ dʉpoapʉ niꞌcã beꞌto pota meꞌrã wééca beꞌtore peocãrã niwã. Niꞌcãgʉ̃ tuacjʉ wiorã cʉocjʉnojõrẽ Jesure diacjʉ̃camocãpʉ oꞌocãrã niwã. Tojo weetoja, cʉ̃ pʉꞌtopʉ ejaqueꞌa, cʉ̃rẽ bujicãꞌcãrã niwã. Aꞌtiro nicãrã niwã: —Eꞌcatipeoya judío masã wiogʉre, ni bujicãꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tojo nicã apeye ʉꞌseco eꞌowaꞌrecãrã niwã. Cʉ̃ tuacjʉre tʉ̃awee, dʉpoapʉ paamʉjãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na tojo bujícãꞌca beꞌro cʉ̃ sãñarĩ suꞌtiro wiogʉ ya suꞌtirore tuweecãrã niwã. Beꞌro cʉ̃ todʉporo sãñaca suꞌtirore sãacãrã niwã tja. Tuꞌajanʉꞌcõ, cʉ̃rẽ curusapʉ wẽjẽrã waꞌarã miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na Jesure wẽjẽrã waꞌarã miarĩ cura niꞌcʉ̃ masʉ̃ Simó Cirene wãmetiri macãcjʉ̃rẽ bocaejawã. Cʉ̃rẽ Jesú ya curusare wʉadutiwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tojo weewãꞌcãrã, niꞌcã buꞌa Gólgota wãmetiropʉ ejawã. Gólgota nírõ, “Masã boaweeca dʉpoa” nirõ weesaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Topʉ pũrĩse tʉꞌoñaꞌticãꞌto nírã, Jesure vino sʉ̃ꞌese meꞌrã morẽꞌquere tĩawã. Jesú cãꞌrõ sĩꞌrĩñaꞌcũmí, sĩꞌrĩduꞌucãꞌwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesure curusapʉ paabiꞌpeca beꞌro surara cʉ̃ ye suꞌtire níbocape wapataꞌaꞌcãrãrẽ dʉcawaawã. Na tojo weecã, dʉporocjʉ̃pʉ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ ojaꞌque queoro waꞌacaro niwʉ̃. Aꞌtiro ojanoꞌcaro niwʉ̃ Jesure waꞌatjere: “Yé suꞌtire na basu níbocape, dʉcawaawã”, nicaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Beꞌro curusa docapʉ surara cʉ̃rẽ coꞌterã ejanujãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesú dʉpoa buꞌipʉ niꞌcã pjĩ meꞌrã “Aꞌte ye buꞌiri cʉ̃rẽ wẽjẽꞌe” nisere ojaõꞌowã. Aꞌtiro ojanoꞌwʉ̃: “Ãꞌrĩ Jesú nimi. Cʉ̃ judío masã wiogʉ nimi”, niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesú meꞌrã ãpẽrã quẽꞌrã pʉarã yajari masã curusapʉ paabiꞌpenʉꞌcõnoꞌwã. Niꞌcʉ̃ diacjʉ̃ peꞌe, apĩrẽ cũpe peꞌe nʉꞌcõwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jesú pʉꞌto masã yʉꞌrʉarã, cʉ̃rẽ bujicãꞌrã dʉpoa yuremʉjãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Cʉ̃rẽ aꞌtiro niwã: —“Õꞌacʉ̃ wiꞌire cõꞌagʉ̃ti, iꞌtia nʉmʉ beꞌrota tuꞌajatojagʉti”, nimiwʉ̃ mʉꞌʉ. Tojo níꞌcʉ mʉꞌʉ basuta yʉꞌrʉoya. Mʉꞌʉ Õꞌacʉ̃ macʉ̃ nígʉ̃, curusapʉ wãꞌñagʉ̃ dijatia, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na weronojõta paꞌia wiorã, Moisé ojaꞌquere buꞌeri masã, tojo nicã judío masã bʉcʉrã cʉ̃rẽ bujicãꞌwã. Na basu aꞌmerĩ aꞌtiro ucũcãrã niwã: ");
INSERT INTO tuoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ãpẽrãmarĩcãrẽ yʉꞌrʉowĩ. Cʉ̃ basu peꞌe yʉꞌrʉomasĩtimi. “Israe curuacjãrã wiogʉ niꞌi”, niwĩ. To pũrĩcãrẽ curusapʉ wãꞌñagʉ̃ dijatiato. Tojo weecã, marĩ cʉ̃rẽ ẽjõpeorãsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cʉ̃ “Õꞌacʉ̃rẽ ẽjõpeoꞌo”, niwĩ. Õꞌacʉ̃ cʉ̃rẽ maꞌígʉ̃ pũrĩcã, cʉ̃rẽ yʉꞌrʉoato. Cʉ̃ marĩrẽ “Õꞌacʉ̃ macʉ̃ niꞌi”, nitojamiwĩba, ni bujicãꞌwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yajari masã Jesú meꞌrã curusapʉ paabiꞌpenʉꞌcõꞌcãrãpʉta bujicãꞌsãjãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesú curusapʉ wẽrĩrĩ cura dajaritero nicã nipeꞌtiropʉ naꞌitĩꞌa waꞌawʉ. Téé ñamicaꞌa tres nicãpʉ naꞌitĩꞌatʉowʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesú titata tres nicã ʉpʉtʉ caricũwĩ. Cʉ̃ arameo meꞌrã aꞌtiro niwĩ: —Elí, Elí, ¿lama sabactani? niwĩ. Aꞌtiro nígʉ̃, tojo niwĩ: “Õꞌacʉ̃, Õꞌacʉ̃, ¿deꞌro weegʉ yʉꞌʉre cõꞌawãꞌcãti?” niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ãpẽrã niꞌcãrẽrã topʉ nirã́ tojo nisere tʉꞌorã, aꞌtiro niwã: —Ãꞌrĩ dʉporocjʉ̃pʉ Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Elíare pisugʉ weesami, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tojo nicã, niꞌcʉ̃ topʉ nigʉ̃́ sojaro meꞌrã yosori siꞌtire miigʉ̃ waꞌawĩ. Beꞌro vino piꞌase meꞌrã morẽꞌquere yosowĩ. Yosotoja, niꞌcãgʉ̃ yucʉgʉpʉ dʉꞌteõꞌo, Jesure sĩꞌrĩato nígʉ̃ sĩomorõwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Cʉ̃ tojo weecã, ãpẽrã peꞌe aꞌtiro niwã: —Weetigʉta. Ĩꞌanirã marĩ yujupʉ. Elía yʉꞌrʉogʉ aꞌtigʉ aꞌtigʉsami cʉ̃rẽ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Beꞌro Jesú apaturi ʉpʉtʉ caricũnemo, wẽrĩa waꞌawĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cʉ̃ wẽrĩrĩ cura aꞌtiro waꞌacaro niwʉ̃. Õꞌacʉ̃ wiꞌipʉ paꞌia sãjãarõpʉ cãꞌmotaꞌayooca casero ʉꞌmʉarõ peꞌe tʉ̃ꞌrʉ̃dijati, deco meꞌrã tʉ̃ꞌrʉ̃yojacaro niwʉ̃. Tojo nicã diꞌta narãsãwʉ̃. Ʉ̃tãperi nimiꞌque bata waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ʉ̃tã tutiri masãrẽ yaaꞌque pãrĩa waꞌacaro niwʉ̃. Tojo waꞌacã, wẽrĩꞌcãrãpʉta Õꞌacʉ̃rẽ ẽjõpeoꞌcãrã masãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesú cʉ̃ masã́ca beꞌro masãperipʉ níꞌcãrã wijawã. Wijaa, Jerusalẽ́ Õꞌacʉ̃rẽ ñubuepeori macãpʉ sãjãawã. Narẽ pãjãrã ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Surara wiogʉ cʉ̃ surara meꞌrã Jesure coꞌteꞌcãrã diꞌta narãsãcã ĩꞌarã, nipeꞌtise to waꞌasere ĩꞌarã, pũrõ ʉcʉa waꞌawã. Aꞌtiro niwã: —Diacjʉ̃ta ãꞌrĩ Õꞌacʉ̃ macʉ̃ta niapĩ, niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pãjãrã numia Jesure yoaropʉ ĩꞌanuꞌcũwã. Na Galileapʉta Jesure weetamurã sirutunʉꞌcãwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na waꞌteropʉre ãꞌrã niwã: María Magdalena, tojo nicã María Santiago, José paco, apego Zebedeo nʉmo niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Naꞌiqueꞌari cura niꞌcʉ̃ José wãmetigʉ peje cʉogʉ Arimatea wãmetiri macãcjʉ̃ etacʉ niwĩ. Cʉ̃ quẽꞌrã Jesure ẽjõpeocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato tiropʉ waꞌa, Jesú ya upʉre sẽrĩcʉ niwĩ. Tojo weegʉ Pilato surarare “Jesú ya upʉre cʉ̃rẽ oꞌoya”, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Beꞌro José Jesú ya upʉre miidijoo, suꞌtiro añurĩ, ũꞌirĩ marĩrĩ casero meꞌrã omacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Omatoja, ʉ̃tã tuti maꞌma tutipʉ sĩosõrõcũuocʉ niwĩ. Ti tuti Joseré yaaboca tuti cʉ̃ seꞌedutica tuti nicaro nimiwʉ̃. Beꞌro ʉ̃tãgã pajicja meꞌrã ti tutire tuubiꞌacʉ niwĩ. Biꞌatoja, waꞌa waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ti tuti põtẽorõpʉ María Magdalena, tojo nicã apego María ĩꞌadujicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ape nʉmʉ, sauru ʉ̃sã soowʉari nʉmʉ nicã paꞌia wiorã, tojo nicã fariseo masã Pilato tiropʉ waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Topʉ etarã, Pilatore aꞌtiro nicãrã niwã: —Wiogʉ, ʉ̃sã sõꞌonícʉ catigʉpʉ nisoosepijagʉ níꞌquere wãcũꞌu. Cʉ̃ “Iꞌtia nʉmʉ yʉꞌʉ wẽ́rĩ́ca beꞌro masãgʉ̃ti”, niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tojo weegʉ mʉꞌʉ yarã surarare cʉ̃rẽ yaaꞌcaropʉ coꞌtedutigʉ oꞌóya. Iꞌtia nʉmʉ añurõ coꞌtedutiya. Tojo weeticã, cʉ̃ buꞌerã ñamipʉ cʉ̃ ya upʉre yajarã waꞌabosama. Na yajáca beꞌro masãrẽ aꞌtiro nirãsama. “Wẽrĩꞌcʉpʉ nimigʉ̃, masã waꞌacʉ niami”, nibosama. Na aꞌtiro nicãma, aꞌte todʉporo nisooꞌque nemorõ ñaꞌabutiarosaꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tere tʉꞌogʉ, Pilato narẽ nicʉ niwĩ: —Ãꞌrã nima surara. Narẽ miaña. Ti masãpe mejẽcã waꞌari nírã, noꞌo mʉsã põtẽorõ coꞌtedutiya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tojo weerã na surarare Jesure yaaꞌcaropʉ coꞌtedutirã cũucãrã niwã. Jesú buꞌerã ti tutipʉ sãjãaticãꞌto nírã ʉ̃tãgã na biꞌacaga buꞌi niꞌcã da piꞌra õꞌocãrã niwã. Na sãjãacã, ĩꞌamasĩrãti nírã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sauru ʉ̃sã soowʉari nʉmʉ beꞌro soorinʉmʉ nicã, ñamiacã ñaꞌcũrõ boꞌrestedijatiri cura María Magdalena, apego María meꞌrã Jesure yaaꞌcaropʉ ĩꞌarã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wãcũña marĩrõ diꞌta ʉpʉtʉ narãsãcaro niwʉ̃. Tojo waꞌari cura niꞌcʉ̃ Õꞌacʉ̃rẽ werecoꞌtegʉ ʉꞌmʉsecjʉ̃ dijaticʉ niwĩ. Cʉ̃ Jesure yaaꞌcaropʉ etagʉ, na biꞌáca ʉ̃tãgãrẽ pãocʉ niwĩ. Pãotoja, tiga buꞌipʉ dujicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Cʉ̃ bʉpo yaꞌbaro weronojõ asistecʉ niwĩ. Cʉ̃ yaro suꞌtiro ʉpʉtʉ buticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Surara cʉ̃rẽ ĩꞌarã, ʉpʉtʉ ui narãsã, wẽrĩꞌcãrã weronojõ bʉrʉqueꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Õꞌacʉ̃rẽ werecoꞌtegʉ sõꞌonícãrã numiarẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉre uiticãꞌña. Yʉꞌʉ masĩꞌi, mʉsã Jesú na curusapʉ paabiꞌpe wẽjẽꞌcʉre aꞌmarã weeꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aꞌtore marĩmi. Cʉ̃ níꞌcaronojõta masãtojami. Cʉ̃rẽ cũuꞌcarore ĩꞌarã aꞌtia, ni pijisãjãacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Narẽ ĩꞌotoja, “Cʉ̃ buꞌerãrẽ sojaro meꞌrã wererã waꞌaya. Aꞌtiro ni wereya narẽ: ‘Wẽrĩꞌcʉpʉ nimigʉ̃, masãtojacʉ niami. Galileapʉ mʉsã dʉporo waꞌayugʉsami. Topʉ cʉ̃rẽ ĩꞌarãsaꞌa’, ni wereya. Aꞌtere mʉsãrẽ weregʉ aꞌtiapʉ”, nicʉ niwĩ Õꞌacʉ̃rẽ werecoꞌtegʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cʉ̃ tojo nicã tʉꞌorã, numia Jesure yaaꞌcaropʉ níꞌcãrã maata waꞌa waꞌacãrã niwã. Uimirã, eꞌcatise meꞌrã waꞌacãrã niwã. Jesú buꞌerã níꞌcãrãrẽ quetiwererã waꞌarã omawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na topʉ waꞌari cura Jesú narẽ bajua, añuduticʉ niwĩ. Tojo weecã, cʉ̃ pʉꞌto waꞌa ejaqueꞌa, dʉꞌpocãrĩpʉ ñeꞌe, ẽjõpeocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Narẽ aꞌtiro nicʉ niwĩ: —Yʉꞌʉre uiticãꞌña. Yʉꞌʉ buꞌerãrẽ Galileapʉ waꞌadutirã waꞌaya. Topʉ yʉꞌʉre ĩꞌarãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Numia Jesú buꞌerãrẽ wererã waꞌari cura niꞌcãrẽrã surara Jesure yaaꞌcaropʉ coꞌteꞌcãrã macãpʉ piꞌacãrã niwã. Paꞌia wiorãrẽ nipeꞌtise topʉ waꞌaꞌquere werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na tojo nicã tʉꞌorã, paꞌia wiorã, judío masã bʉcʉrã meꞌrã nerẽcãrã niwã. Na “¿Deꞌro weeroʉati?” ni apocãrã niwã. Na niꞌcãrõnojõ wãcũ, aꞌtiro weecãrã niwã. Masãrẽ nisooato nírã surarare pajiro niyeru wapayecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aꞌtiro nicãrã niwã: —Aꞌtiro niña masãrẽ: “Ñamipʉ ʉ̃sã cã́rĩ́ca beꞌro Jesú buꞌerã ejacãrã niama. Eja, cʉ̃ ya upʉre yajawãꞌcãcãrã niama”, niña, nicãrã niwã surarare. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Apeye quẽꞌrãrẽ ninemocãrã niwã: —Pilato Judea diꞌta wiogʉ aꞌtere masĩcã, ʉ̃sã “Diacjʉ̃ta tojo waꞌacaro niapʉ”, nitamurãti. Ʉ̃sã tojo nicã, mʉsãrẽ suꞌrisome. Mʉsãrẽ buꞌiri daꞌresome, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tojo nicã tʉꞌorã, surara niyeru ñeꞌecãrã niwã. Beꞌro narẽ weredutiꞌcaronojõta weecãrã niwã. Na tojo nise seꞌsa waꞌacaro niwʉ̃. Aꞌtocateropʉ quẽꞌrãrẽ judío masã surara na nisooꞌquere ẽjõpeo ucũdecotima yujupʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Beꞌro ʉ̃sã Jesú buꞌerã once Galileapʉ waꞌawʉ. Jesú cʉ̃ wẽrĩse dʉporo ʉ̃rʉ̃gʉ̃pʉ ʉ̃sãrẽ waꞌadutiꞌcʉpʉ waꞌawʉ. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Topʉ Jesure ĩꞌawʉ̃. Cʉ̃rẽ ĩꞌa ejaqueꞌa, ẽjõpeowʉ. Tojo weemicã, ʉ̃sã niꞌcãrẽrã “¿Cʉ̃́ta nitiba?” ni wãcũwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Beꞌro Jesú ʉ̃sã pʉꞌtopʉ aꞌti, aꞌtiro niwĩ: —Õꞌacʉ̃ yʉꞌʉre wiogʉ sõrõtojami. Nipeꞌtiro ʉꞌmʉse, aꞌti diꞌtare dutimasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tojo weerã nipeꞌtirocjãrãpʉre yé quetire wererã waꞌaya. Narẽ mʉsã weronojõ yʉꞌʉ buꞌerã sãjãcã weeya. Narẽ wãmeyerã, yʉꞌʉ pacʉ, yʉꞌʉ, Espíritu Santu wãme meꞌrã wãmeyeya. ");
INSERT INTO tuoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nipeꞌtise yʉꞌʉ mʉsãrẽ dutiꞌquere narẽ yʉꞌti buꞌecã weeya. Narẽ nipeꞌtise nʉmʉrĩ yʉꞌʉ mʉsãrẽ buꞌeꞌquere wereya. Aꞌtere masĩña. Nipeꞌtise nʉmʉrĩ mʉsã meꞌrã ninuꞌcũcʉ̃saꞌa. Téé aꞌti turi peꞌticãpʉ quẽꞌrã mʉsã meꞌrã ninuꞌcũcʉ̃saꞌa, ni werewĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Õꞌacʉ̃ macʉ̃ ye, añuse queti aꞌtiro nʉꞌcãcaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dʉporocjʉ̃pʉ Isaía Õꞌacʉ̃ ye queti weremʉꞌtãrĩ masʉ̃ Õꞌacʉ̃ ucũꞌquere ojacʉ niwĩ. Cʉ̃ Jesucristo aꞌti turipʉ aꞌtiatjere aꞌtiro ojayucʉ niwĩ: Yʉꞌʉ mʉꞌʉ ye quetire wereyuacjʉre mʉꞌʉ dʉporo oꞌógʉti. Cʉ̃ mʉꞌʉ waꞌatji maꞌarẽ apoyugʉsami. Maꞌa quẽꞌrã́yumʉꞌtãgʉ̃ weronojõ masã wãcũsere bʉjaweti dʉcayudutigʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Niꞌcʉ̃ yucʉ marĩrõ, masã marĩrõpʉ aꞌtiro caricũnuꞌcũbajaqueꞌatigʉsami: “Marĩ wiogʉ aꞌtiatji maꞌarẽ apoyuya. Diacjʉ̃ca maꞌa añurĩ maꞌa quẽꞌrã́rõ weronojõ weeyuya”, ni ojacʉ niwĩ. Marĩ wiogʉ aꞌtiati dʉporo mʉsã nisetisere apoyuya, mʉsã wãcũsere dʉcayuya nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tojo weegʉ Juã wãmeyeri masʉ̃ta nicʉ niwĩ Isaía tojo ninoꞌcʉ. Cʉ̃ yucʉ marĩrõ, masã marĩrõpʉ wãmeyecusiacʉ niwĩ. Cʉ̃ masãrẽ buꞌégʉ, aꞌtiro nicʉ niwĩ: —Mʉsã ñaꞌarõ weesetisere bʉjaweti dʉcayu, wãmeyenoꞌña. Tojo weerã mʉsã ñaꞌarõ weeꞌquere acobojonoꞌrãsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pãjãrã ti diꞌta Judeapʉ nirã́, tojo nicã Jerusalẽ́cjãrã cʉ̃ buꞌesere tʉꞌorã waꞌacãrã niwã. Na ñaꞌarõ weeꞌquere wereyʉꞌrʉca beꞌro Jordã́ wãmetiri maapʉ narẽ wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Cʉ̃ ye suꞌti cameyo poari meꞌrã weenoꞌque nicaro niwʉ̃. Cʉ̃ ejerituri da waꞌicʉ casero da nicaro niwʉ̃. Cʉ̃ pajasecʉorã na baꞌasetise poreroare, nʉcʉ̃ cjase mumia yere baꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juã masãrẽ aꞌtiro werecʉ niwĩ: —Yʉꞌʉ beꞌro apĩ yʉꞌʉ nemorõ tutuagʉ aꞌtigʉsami. Cʉ̃ añuyʉꞌrʉagʉ nimi. Yʉꞌʉ peꞌe mejõ nigʉ̃ waro tʉꞌoñaꞌa. Cʉ̃ ye sapature tuweemasĩtigʉ weronojõ cʉ̃rẽ ne cãꞌrõ niꞌcãrõwijimasĩtisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yʉꞌʉ mʉsãrẽ aco meꞌrã wãmeyeꞌe. Cʉ̃ pũrĩcã Espíritu Santu meꞌrã wãmeyegʉsami. Cʉ̃ tojo wéégʉ, Espíritu Santu mʉsãpʉre dijatacã weegʉsami. Mʉsã meꞌrã ninuꞌcũcʉ̃sami, nicʉ niwĩ Juã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juã masãrẽ wãmeyeri cura Jesú aꞌtiro weecʉ niwĩ. Nazare, Galilea diꞌta nirĩ macãpʉ níꞌcʉ wijawãꞌcã, Juã tiropʉ ejacʉ niwĩ. Juã cʉ̃rẽ Jordã́ wãmetiri maapʉ wãmeyecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cʉ̃ ti maapʉ níꞌcʉ majãnʉꞌcãrĩ cura Jesú ʉꞌmʉse pãrĩcã ĩꞌacʉ niwĩ. Espíritu Santu niꞌcʉ̃ buja weronojõ bajugʉ cʉ̃pʉre dijatacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tojo waꞌari cura niꞌcʉ̃ ʉꞌmʉsepʉ aꞌtiro ucũdijocʉ niwĩ: —Mʉꞌʉ yʉꞌʉ macʉ̃ ʉpʉtʉ maꞌigʉ̃ niꞌi. Mʉꞌʉ meꞌrã pũrõ eꞌcatiꞌi, nidijocʉ niwĩ Õꞌacʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesure wãmeyeca beꞌro maata Espíritu Santu yucʉ marĩrõ, masã marĩrõpʉ cʉ̃rẽ waꞌaduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesú topʉre cuarenta nʉmʉrĩ nicʉ niwĩ. Waꞌicʉrã uamarã waꞌteropʉ nicʉ niwĩ. Wãtĩ Jesure cʉ̃ pacʉre yʉꞌrʉnʉꞌcãdutigʉ niquesãcʉ nimiwĩ. Beꞌro ʉꞌmʉsecjãrã Õꞌacʉ̃rẽ werecoꞌterã Jesure coꞌterã dijatacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Beꞌro Herode Juã masãrẽ wãmeyeri masʉ̃rẽ buꞌiri daꞌreri wiꞌipʉ sõrõduticʉ niwĩ. Titare Jesú Galilea diꞌtapʉ añuse queti Õꞌacʉ̃ yere, cʉ̃ wiogʉ nimi nisere buꞌegʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aꞌtiro nicʉ niwĩ: —Niꞌcãrõacãrẽ mʉsã todʉporopʉ yoacã coꞌteꞌcʉ etatojami. Cʉ̃ cãꞌrõacã beꞌro wiogʉ sãjãgʉ̃́sami. Tojo weerã mʉsã ñaꞌarõ weesetisere bʉjaweti, duꞌuya. Mʉsã wãcũsere dʉcayuya. Õꞌacʉ̃ masãrẽ yʉꞌrʉogʉsami nisere ẽjõpeoya, ni buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Beꞌro Jesú Galilea wãmetiri ditara sumutopʉ sijabaqueꞌacʉ niwĩ. Topʉ waꞌagʉ, Simórẽ, apĩ cʉ̃ acabiji Andrére bocaejapʉ. Na waꞌi wẽjẽrĩ masã nicãrã niwã. Ditarapʉ na wejecʉre doqueñorã weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na tojo weecã ĩꞌagʉ̃, Jesú nicʉ niwĩ: —Teꞌa yʉꞌʉ meꞌrã. Mʉsã niꞌcãrõacãrẽ waꞌi wẽjẽrĩ masã niꞌi. Beꞌrore majã waꞌi wẽjẽrã weronojõ masãrẽ yé quetire wererãsaꞌa. Tojo werecã, pãjãrã ẽjõpeorãsama, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cʉ̃ tojo nicã tʉꞌorã, maata na ye wejecʉpagʉre totá duꞌucũu, Jesú meꞌrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cãꞌrõ yʉꞌrʉa, pʉarã Zebedeo põꞌrãrẽ Santiago, cʉ̃ acabiji Juãrẽ ĩꞌacʉ niwĩ tja. Na yucʉsʉpʉ wejecʉpagʉre dero aposãñacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Narẽ ĩꞌagʉ̃ta, Jesú na quẽꞌrãrẽ tja pijicʉ niwĩ. Cʉ̃ tojo nicã tʉꞌorã, na pacʉ Zebedeore, cʉ̃rẽ daꞌracoꞌterãrẽ cõꞌawãꞌcãcãrã niwã. Cõꞌawãꞌcã, Jesú meꞌrã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Beꞌro Capernau wãmetiri macãpʉ etacãrã niwã. Saurure judío masã soowʉari nʉmʉ nicã Jesú na nerẽwʉari wiꞌipʉ sãjãacʉ niwĩ. Sãjãa, masã ti wiꞌipʉ nirãrẽ buꞌenʉꞌcãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Cʉ̃ Moisé ojaꞌquere buꞌeri masã weronojõ buꞌeticʉ niwĩ. Dutisere cʉogʉ weronojõ narẽ buꞌecʉ niwĩ. Tojo weerã masã cʉ̃ buꞌesere tʉꞌomarĩa waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti wiꞌi na nerẽrĩ wiꞌipʉ niꞌcʉ̃ masʉ̃ wãtĩ sãjãnoꞌcʉ nicʉ niwĩ. Cʉ̃ aꞌtiro caricũcʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉꞌʉ Jesú Nazarecjʉ̃, ʉ̃sãrẽ cariboticãꞌña. ¿Ʉ̃sãrẽ buꞌiri daꞌre bajuriogʉ aꞌtigʉ weeti? Mʉꞌʉrẽ ĩꞌamasĩꞌi. Õꞌacʉ̃ oꞌóꞌcʉ ñaꞌase moogʉ̃, añubutiagʉ niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Cʉ̃ tojo nicã tʉꞌogʉ, Jesú wãtĩ masʉ̃pʉre nigʉ̃rẽ tuꞌtigʉ, aꞌtiro nicʉ niwĩ: —Diꞌtamarĩaña. Cʉ̃pʉre nigʉ̃́ wijaaya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cʉ̃ tojo nicã, wãtĩ cʉ̃pʉre nigʉ̃́ masʉ̃rẽ bʉrʉqueꞌa narãsãcã weecʉ niwĩ. Ʉpʉtʉ waro caricũ, wãtĩ cʉ̃pʉre níꞌcʉ wijaacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nipeꞌtirã ti wiꞌipʉ nirã́ ĩꞌamarĩacãrã niwã. Na basu aꞌmerĩ sẽrĩtiñaꞌmʉjãcãrã niwã: —¿Ñeꞌenojõ niti aꞌte tojo waꞌase? ¿Maꞌma buꞌese niti? Ãꞌrĩ masʉ̃ wãtĩapʉreta cõꞌawĩrõmasĩsere cʉodojami. Na cʉ̃ cõꞌawĩrõcã, wijaama, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cʉ̃ tojo wééca beꞌro yoaticãta Jesú ye quetire Galilea diꞌtacjãrã tʉꞌoseꞌsapeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesú na nerẽwʉari wiꞌipʉ wijááca beꞌro Simó, André meꞌrã na ya wiꞌipʉ waꞌacʉ niwĩ. Tojo nicã Santiago, Juã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Topʉ Simó mañecõ ujaque dutitigo cãjĩco niwõ. Jesure maata “Co dutitigo weeamo”, ni werecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tojo nicã tʉꞌogʉ, Jesú co tiropʉ sãjãacʉ niwĩ. Core omocãpʉ ñeꞌe wejewãꞌcõdʉpocʉ niwĩ. Cʉ̃ tojo weeri curata ujaque surupeꞌtia waꞌacaro niwʉ̃. Beꞌro maata narẽ baꞌase ecaco niwõ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mujĩpũ sãjã́ca beꞌro ñamipʉ masã Jesú tiropʉ nipeꞌtirã dutitirãrẽ miacãrã niwã. Wãtĩa sãjãnoꞌcãrã quẽꞌrãrẽ miacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nipeꞌtirã ti macãcjãrã Jesú cʉ̃ nirĩ wiꞌi sope pʉꞌtopʉ nerẽcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nipeꞌtirã noꞌo nise duti cʉorãrẽ yʉꞌrʉopeꞌocãꞌcʉ niwĩ. Pãjãrã wãtĩa sãjãnoꞌcãrãrẽ cõꞌawĩrõcʉ niwĩ. Wãtĩa Jesú cʉ̃ Õꞌacʉ̃ macʉ̃ nisere masĩcãrã niwã. Tojo weegʉ narẽ ne cãꞌrõ ucũdutiticʉ niwĩ. Tojo nirṍ meꞌrã ucũticãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ape nʉmʉ boꞌrease dʉporo Jesú wãꞌcã, macã sumuto masã marĩrõpʉ cʉ̃ pacʉre ñubuegʉ waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Beꞌro Simó, ãpẽrã cʉ̃ meꞌrãcjãrã meꞌrã Jesure aꞌmarã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cʉ̃rẽ bocarã, aꞌtiro ni werecãrã niwã: —Nipeꞌtirã mʉꞌʉrẽ aꞌmarã weeama. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cʉ̃ narẽ yʉꞌticʉ niwĩ: —Teꞌa apero pʉꞌtoacã nise macãrĩpʉ. Topʉ quẽꞌrãrẽ yé quetire weregʉ waꞌagʉti. Aꞌtere weegʉta yʉꞌʉ aꞌti nucũcãpʉ aꞌtiꞌcʉ niꞌi, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tojo weegʉ Jesú nipeꞌtiro Galilea na nerẽwʉase wiꞌseripʉ buꞌecusiabiꞌacʉ niwĩ. Tojo nicã wãtĩarẽ cõꞌawĩrõmʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesú Galileapʉ nirĩ cura niꞌcʉ̃ masʉ̃ cãmi boagʉ Jesú tiro waꞌacʉ niwĩ. Cʉ̃ tiro ejagʉ ejaqueꞌa, aꞌtiro nicʉ niwĩ: —Mʉꞌʉ dutire yʉꞌrʉogʉ niꞌi. Yʉꞌʉre yʉꞌrʉoya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesú cʉ̃rẽ pajañaꞌgʉ̃, cʉ̃rẽ yʉꞌrʉogʉ daꞌrañaꞌa, aꞌtiro nicʉ niwĩ: —Mʉꞌʉrẽ yʉꞌrʉogʉti. Cãmi marĩgʉ̃ tojayá, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cʉ̃ tojo nirĩ curata cʉ̃ cãmi nimiꞌque yatipeꞌtia waꞌacaro niwʉ̃. Cʉ̃ aꞌti upʉ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Beꞌro Jesú cʉ̃rẽ weꞌeritigʉ, tutuaro meꞌrã “Aꞌtiro weeya”, nicʉ nimiwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ne ãpẽrãrẽ wereticãꞌña. Diacjʉ̃ta paꞌi tiropʉ mʉꞌʉ ye cãmi yatiꞌquere ĩꞌogʉ̃ waꞌaya. Cʉ̃ mʉꞌʉrẽ mʉꞌʉ cãmi boasere “Peꞌtia waꞌaꞌa”, nigʉ̃sami. Cʉ̃ tojo níca beꞌro Moisé cʉ̃ ñubuepeodutiꞌquere oꞌoya. Mʉꞌʉ tojo weecã, nipeꞌtirã mʉꞌʉ cãmi yatinoꞌquere masĩrãsama. Beꞌro na meꞌrã nisetigʉsaꞌa tja, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cʉ̃ peꞌe cʉ̃ weedutiꞌcaronojõ weeticʉ niwĩ. Waꞌa, nipeꞌtirãpʉre cʉ̃rẽ waꞌaꞌquere werecusiacʉ niwĩ. Tojo weegʉ Jesú masã ĩꞌorõ macãrĩpʉre sãjãamasĩticʉ niwĩ. Te macãrĩ sumuto, masã marĩrõpʉ sijacʉ niwĩ. Cʉ̃ tojo weemicã, nipeꞌtirocjãrã masã aꞌti, cʉ̃rẽ ĩꞌacusiacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pejeti nʉmʉrĩ cãmi boagʉre yʉꞌrʉóca beꞌro Jesú apaturi Capernaupʉ waꞌacʉ niwĩ tja. Cʉ̃ topʉ nicã, ti macãcjãrã wiꞌipʉ nimi nise quetire tʉꞌocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tojo weerã maata masã pãjãrã Jesú nirĩ wiꞌipʉ nerẽcãrã niwã. Ti wiꞌire muꞌmuyʉꞌrʉacãrã niwã. Mejãrõta sopepʉ quẽꞌrãrẽ muꞌmuyʉꞌrʉacãrã niwã. Ne sãjãata basioticaro niwʉ̃. Narẽ cʉ̃ ye buꞌesere werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tojo weeri cura Jesú tiro niꞌcʉ̃ sijamasĩtigʉre baꞌparitirã ʉmʉa wʉawãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na masã pãjãrã nise buꞌiri Jesú pʉꞌtoacãpʉ ejamasĩticãrã niwã. Tojo weerã wiꞌi buꞌipʉ mʉjãa, Jesú nirṍ buꞌipʉ niꞌcã pe seeweecãrã niwã. Ti pepʉ cʉ̃ sijamasĩtigʉre cʉ̃ cũñarõ meꞌrã duꞌudijocãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesú na ʉpʉtʉ ẽjõpeocã ĩꞌagʉ̃, dutitigʉre nicʉ niwĩ: —Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Cʉ̃ tojo nicã tʉꞌorã, topʉ dujirã Moisé ojaꞌquere buꞌeri masã aꞌtiro wãcũcãrã niwã: ");
INSERT INTO tuoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ãꞌrĩ tojo ucũticãꞌrõʉaꞌa. Tojo nígʉ̃, Õꞌacʉ̃rẽ ñaꞌarõ ucũgʉ̃ weemi. ¿Cʉ̃ ‘Õꞌacʉ̃ weronojõ tutuagʉ niꞌi’, ni wãcũsari? Õꞌacʉ̃ niꞌcʉ̃ta ñaꞌarõ weeꞌquere acobojomasĩmi. Ãꞌrĩ marĩ weronojõ upʉtigʉ masã ñaꞌarõ weeꞌquere acobojomasĩtisami”, ni wãcũcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesú cʉ̃ basu na wãcũsere ĩꞌamasĩgʉ̃, aꞌtiro nicʉ niwĩ narẽ: —¿Deꞌro weerã mʉsã yʉꞌʉre ñaꞌarõ mejẽcã wãcũti? ");
INSERT INTO tuoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Deꞌro nise peꞌe diasatibutiati? ¿“Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa” o “Wãꞌcãnʉꞌcãña, mʉꞌʉ cũñaꞌcaro meꞌrã sijawãꞌcãña” nise peꞌe diasaweti? “Mʉꞌʉ ñaꞌarõ weeꞌquere acobojonoꞌtojaꞌa” nicã ĩꞌatimigʉ̃, ẽjõpeoya marĩꞌi. “Wãꞌcãnʉꞌcã sijawãꞌcãña” nicã peꞌema, cʉ̃ sijasere ĩꞌatojagʉpʉ “Diacjʉ̃ta niꞌi”, ni ẽjõpeonoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tojo weegʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ yʉꞌʉ tutuasere ĩꞌogʉ̃, ãꞌrĩ sijamasĩtigʉre yʉꞌrʉogʉti. Te meꞌrã mʉsã yʉꞌʉ masã ñaꞌarõ weeꞌquere acobojomasĩsere masĩrãsaꞌa, nicʉ niwĩ. Beꞌro sijamasĩtigʉre aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mʉꞌʉ peꞌema aꞌtiro nigʉ̃ti. Wãꞌcãnʉꞌcãña. Mʉꞌʉ cũñaꞌcarore miiwʉa, mʉꞌʉ ya wiꞌipʉ tojaagʉsaꞌa, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cʉ̃ tojo nirĩ curata sijamasĩtigʉ wãꞌcãnʉꞌcãcʉ niwĩ. Wãꞌcãnʉꞌcã, cʉ̃ cũñaꞌcarore miiwʉa, masã nipeꞌtirã ĩꞌorõpʉ waꞌa waꞌacʉ niwĩ. Tojo weerã nipeꞌtirã ĩꞌamarĩarã, aꞌtiro nicãrã niwã: —Marĩ pacʉ Õꞌacʉ̃ tutuayʉꞌrʉami. Ne niꞌcãti ʉ̃sã aꞌtiro weesere ĩꞌatirã nicãti, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesú sijamasĩtigʉre yʉꞌrʉóca beꞌro apaturi Galilea ditara sumutopʉ waꞌacʉ niwĩ tja. Nipeꞌtirã masã cʉ̃ tiropʉ nérẽ́ca beꞌro narẽ buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ti ditarapʉ waꞌagʉ, Leví, Alfeo macʉ̃rẽ ĩꞌabocacʉ niwĩ. Cʉ̃ romano wiogʉre niyeru wapaseebosari masʉ̃ nicʉ niwĩ. Tojo weegʉ cʉ̃ daꞌrari tucũpʉ dujicʉ niwĩ. Jesú cʉ̃rẽ ĩꞌagʉ̃, aꞌtiro nicʉ niwĩ: —Teꞌa yʉꞌʉ meꞌrã. Tojo weegʉ Leví wãꞌcãnʉꞌcã, cʉ̃ meꞌrã waꞌacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Beꞌro Jesú Leví ya wiꞌipʉ baꞌagʉ waꞌacʉ niwĩ. Topʉ pãjãrã wapaseeri masã, tojo nicã “Ñaꞌarã nima” ninoꞌrãnojõ nicãrã niwã. Pãjãrã waro nanojõ Jesure sirutucãrã niwã. Tojo weerã na Jesú tiro cʉ̃ buꞌerã meꞌrã dujicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na tojo weecã ĩꞌarã, Moisé ojaꞌquere buꞌeri masã, ãpẽrã fariseo masã Jesú na pãjãrã meꞌrã baꞌacã ĩꞌarã, cʉ̃ buꞌerãrẽ aꞌtiro nicãrã niwã: —¿Deꞌro weegʉ mʉsã buꞌegʉ wapaseeri masã meꞌrã, ñaꞌarõ weeri masã meꞌrã sĩꞌrĩ, baꞌati? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesú na tojo nicã tʉꞌogʉ, aꞌtiro nicʉ niwĩ: —Duti moorã ocoyeri masʉ̃rẽ aꞌmatisama. Dutitirã pũrĩcã ocoyegʉre aꞌmasama. “Añurã niꞌi” nirãrẽ aꞌmagʉ̃ aꞌtitiwʉ. “Ñaꞌarã niꞌi” nirã́ peꞌere yʉꞌrʉogʉ aꞌtiwʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Niꞌcã nʉmʉ Juã masãrẽ wãmeyeri masʉ̃ buꞌesere siruturi masã, tojo nicã fariseo masã Õꞌacʉ̃rẽ ẽjõpeorã, beꞌticãrã niwã. Na tojo beꞌtiri cura niꞌcãrẽrã Jesú tiro waꞌa, cʉ̃rẽ sẽrĩtiñaꞌcãrã niwã: —Juã masãrẽ wãmeyeri masʉ̃ buꞌesere siruturã, tojo nicã fariseo masã buꞌesere siruturã Õꞌacʉ̃rẽ ẽjõpeorã, beꞌtima. ¿Deꞌro weerã mʉꞌʉ buꞌerã peꞌe beꞌtiweti? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesú narẽ yʉꞌticʉ niwĩ: —¿Deꞌro weeacjʉ omocã dʉꞌtegʉ na meꞌrã nígʉ̃, cʉ̃ pijioꞌcãrãrẽ bʉjaweti, beꞌtidutibosari? ");
INSERT INTO tuoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Beꞌro cʉ̃rẽ ãpẽrã aperopʉ miáca beꞌro pũrĩcãrẽ bʉjaweti, beꞌtirãsama. Jesú, yʉꞌʉ na meꞌrã niꞌi yujupʉ; yʉꞌʉ na meꞌrã niticã pũrĩcãrẽ beꞌtirãsama nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Apeyere queose meꞌrã narẽ werenemocʉ niwĩ. Tojo nígʉ̃, maꞌma cʉ̃ buꞌese meꞌrã todʉporopʉ na weesetiꞌque aꞌmesʉꞌamasĩtisaꞌa, nigʉ̃ weecʉ niwĩ. —Mejãrõ suꞌtiro maꞌma casero, coeya marĩrĩ casero meꞌrã sereõꞌota basioweꞌe. Tojo weecãma, maꞌma casero coecã, wejedʉꞌosaꞌa. Mejãrõ suꞌtiro peꞌere wejetʉ̃ꞌrẽsaꞌa. Nemorõ pajiri pe tʉ̃ꞌrʉ̃nemosaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tojota waꞌasaꞌa marĩ maꞌma vino mejã ajuro waꞌicʉrã casero meꞌrã wééca ajuropʉ poseyecã. Pãꞌmʉyʉꞌrʉ, ti ajuro tʉ̃ꞌrʉ̃, vino piostepeꞌtia waꞌasaꞌa. Tojo waꞌacã, vino bajudutia waꞌasaꞌa. Ti ajuro quẽꞌrã cõꞌa waꞌasaꞌa. Tojo weerã maꞌma vinorẽ maꞌma ajuropʉ poseyenoꞌo, nicʉ niwĩ Jesú. Dʉporopʉ weesetiꞌque meꞌrã Jesú cʉ̃ niꞌcãrõacã maꞌma buꞌese morẽta basioweꞌe nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Niꞌcã nʉmʉ judío masã na soowʉari nʉmʉ nicã, Jesú cʉ̃ buꞌerã meꞌrã trigo wesepʉ yʉꞌrʉacʉ niwĩ. Cʉ̃ buꞌerã ti wesepʉ yʉꞌrʉarã, trigore tʉ̃ꞌrẽ baꞌacãrã niwã. (Moisé cʉ̃ dutiꞌcaronojõta na tojo weese yajase mejẽta nicaro niwʉ̃.) ");
INSERT INTO tuoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tojo weecã, fariseo masã ĩꞌacãrã niwã. Tojo weerã Jesure nicãrã niwã: —Ĩꞌaña. ¿Deꞌro weerã marĩ soowʉari nʉmʉrẽ daꞌradutitimicã, mʉꞌʉ buꞌerã tojo weeti? nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesú narẽ yʉꞌticʉ niwĩ: —Mʉsã dʉporocjʉ̃ wiogʉ Davi cʉ̃ meꞌrãcjãrã ʉjaboarã weeꞌquere buꞌetojapã. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Davi Abiatar cʉ̃ paꞌia wiogʉ nirĩ cura Õꞌacʉ̃ wiꞌipʉ sãjãa, pã́ “Õꞌacʉ̃ ye niꞌi” níꞌquere baꞌacʉ niwĩ. Cʉ̃ meꞌrãcjãrã quẽꞌrãrẽ dʉcawaacʉ niwĩ. Te marĩrẽ dutise aꞌtiro niꞌi. Paꞌia diaꞌcʉ̃rẽ te pã́ baꞌata basiomicaro niwʉ̃. Yʉꞌʉ buꞌerã tere baꞌarã, yʉꞌrʉnʉꞌcãrã mejẽta weema nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesú yʉꞌtinemocʉ niwĩ tja: —Marĩ ye niatjere Õꞌacʉ̃ marĩ soowʉari nʉmʉrẽ cũucʉ niwĩ. Ti nʉmʉ mejẽta marĩrẽ dutimasĩꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tojo weegʉ yʉꞌʉ Õꞌacʉ̃ macʉ̃ masʉ̃ weronojõ upʉtigʉ soowʉari nʉmʉ dutise nemorõ dutimasĩꞌi, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesú apaturi cʉ̃ weewʉaronojõpʉma judío masã na nerẽrĩ wiꞌipʉ sãjãacʉ niwĩ. Topʉ niꞌcʉ̃ omocã bʉꞌawiaꞌcʉ nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ãpẽrã ¿marĩ soowʉari nʉmʉrẽ cʉ̃rẽ yʉꞌrʉogʉsari? nírã, Jesure ĩꞌacoꞌtecãrã niwã. Jesú yʉꞌrʉocã, weresãta basiorosaꞌa nírã, tojo ĩꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Beꞌro Jesú omocã bʉꞌawiagʉre nicʉ niwĩ: —Aꞌtia, ãꞌrã nipeꞌtirã decopʉ ejanʉꞌcãña. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tuꞌajanʉꞌcõ, to nirã́ ãpẽrãrẽ nicʉ niwĩ: —¿Marĩ soowʉari nʉmʉ nicã añusere weeroʉati o ñaꞌase peꞌere ʉati? ¿Yʉꞌrʉosere ʉati o wẽjẽcõꞌase peꞌere ʉati? nicʉ niwĩ. Na nipeꞌtirã diꞌtamarĩpeꞌtia waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na yʉꞌtiticã ĩꞌagʉ̃, ua waꞌacʉ niwĩ. Na tʉꞌosĩꞌrĩticã, bʉjawetise meꞌrã omocã bʉꞌawiagʉre nicʉ niwĩ: —Mʉꞌʉ omocãrẽ sĩ́oña, nicʉ niwĩ. Cʉ̃ tojo nicã, omocãrẽ sĩ́ocʉ niwĩ. Sĩ́oo, cʉ̃ omocãrẽ yʉꞌrʉonoꞌcʉpʉ tojacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Beꞌro fariseo masã uawija waꞌacãrã niwã. Na Herode ya curuacjãrã meꞌrã “¿Deꞌro wee marĩ Jesure wẽjẽrãsari?” ni wãcũwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesú na nerẽwʉari wiꞌipʉ níꞌcʉ cʉ̃ buꞌerã meꞌrã ditara sumutopʉ waꞌacʉ niwĩ. Pãjãrã Galilea diꞌtacjãrã cʉ̃rẽ sirutuwãꞌcãcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cʉ̃ peje añuse weecã tʉꞌorã, pãjãrã masã cʉ̃ tiropʉ waꞌacãrã niwã. Judea diꞌtacjãrã, Jerusalẽ́cjãrã, Idumea diꞌtacjãrã, Jordã́ wãmetiri maa mujĩpũ mʉjãtiro peꞌecjãrã, Tiro, Sidṍ wãmetise macãrĩcjãrã na quẽꞌrã Jesure ĩꞌarã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na pãjãrã nicã ĩꞌagʉ̃, Jesú cʉ̃ buꞌerãrẽ niꞌcãwʉ̃ yucʉsʉ cʉoyuduticʉ niwĩ. Cʉ̃rẽ masã tuutĩꞌabosama nígʉ̃, tojo weeduticʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cʉ̃ pãjãrãrẽ yʉꞌrʉocʉ niwĩ. Tojo weerã nipeꞌtirã dutitirã cʉ̃rẽ ñeꞌeñaꞌsĩꞌrĩrã, cʉ̃ tiropʉ diaꞌcʉ̃ tuuwãꞌcãcãrã niwã. Cʉ̃rẽ ñeꞌese meꞌrã yʉꞌrʉrãsaꞌa ni wãcũrã, tojo weecãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wãtĩa sãjãnoꞌcãrã Jesure ĩꞌarã, cʉ̃ pʉꞌto ejaqueꞌamʉjãcãrã niwã. Ejaqueꞌarã, aꞌtiro ni caricũcãrã niwã: —Mʉꞌʉ Õꞌacʉ̃ macʉ̃ niꞌi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesú peꞌe narẽ ne ucũdutiticʉ niwĩ. Cʉ̃ Õꞌacʉ̃ macʉ̃ nisere werebajurẽrĩ nígʉ̃, tojo weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Beꞌro Jesú ʉ̃rʉ̃gʉ̃pʉ mʉjãcʉ niwĩ. Topʉ cʉ̃ besesĩꞌrĩrãrẽ beseacjʉ pijiocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na cʉ̃ tiropʉ ejacã, cʉ̃ meꞌrã waꞌajã warore doce ʉmʉarẽ besecʉ niwĩ. Narẽ cʉ̃ ye quetire weredutioꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wãtĩarẽ cõꞌawĩrõsere oꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na aꞌticʉrã nicãrã niwã: Simó, cʉ̃rẽta Jesú peꞌe Pedro wãme õꞌocʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, tojo nicã cʉ̃ acabiji Juã na Zebedeo põꞌrã nicãrã niwã. Narẽ Boanerges wãme õꞌocʉ niwĩ. Tojo nígʉ̃, na ĩꞌoduarã niyucã, “Bʉpo Põꞌrã” nigʉ̃ weecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ãpẽrã André, Felipe, Bartolomé, Mateo, Tomás, Santiago Alfeo macʉ̃ nicãrã niwã. Tojo nicã Tadeo, Simó celote curuacjʉ̃ nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Apĩ Juda Iscariote beꞌropʉ Jesure ĩꞌatuꞌtirãrẽ oꞌoacjʉ nicʉ niwĩ. Beꞌro Jesú cʉ̃ buꞌerã meꞌrã niꞌcã wiꞌipʉ sãjãacʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Topʉre tja pãjãrã masã nerẽcãrã niwã. Tojo weerã ti wiꞌi muꞌmucã, Jesú cʉ̃ buꞌerã meꞌrã baꞌata basioticaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tojo waꞌasere Jesú acawererã tʉꞌocãrã niwã. Cʉ̃rẽ maatia waꞌasami nírã, pijirã waꞌacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ãpẽrã masã Jerusalẽ́pʉ aꞌtiꞌcãrã Moisé ojaꞌquere buꞌeri masã aꞌtiro nicãrã niwã: —Ãꞌrĩ Beelzebú wãtĩa wiogʉ sãjãnoꞌcʉ nimi. Cʉ̃ tutuaro meꞌrã wãtĩarẽ cõꞌawĩrõmi, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na tojo nicã tʉꞌogʉ, Jesú narẽ pijio, queose meꞌrã werecʉ niwĩ: —Wãtĩ cʉ̃ basu cõꞌawĩrõmasĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Niꞌcã curuacjãrã dʉcawatirã, na basu aꞌmequẽrã masãpeꞌtia waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Niꞌcã wiꞌicjãrã dʉcawatirã, na quẽꞌrã peꞌtia waꞌasama. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wãtĩ cʉ̃ yarã meꞌrã dʉcawatigʉ, cʉ̃ quẽꞌrã ninuꞌcũtisami. Te meꞌrã yapatidija waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","»Niꞌcʉ̃ tutuagʉ ya wiꞌipʉre cʉ̃rẽ dʉꞌtecũutimigʉ̃, cʉ̃ yere yajamasĩtisami. Dʉꞌtecṹúca beꞌropʉ yajamasĩsami, nicʉ niwĩ. Jesú, yʉꞌʉ wãtĩ yʉꞌrʉoro tutuagʉ niꞌi nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Beꞌro ninemocʉ niwĩ: —Diacjʉ̃ta mʉsãrẽ weregʉti. Õꞌacʉ̃ nipeꞌtise masã ñaꞌarõ weesere, ñaꞌarõ ucũsere acobojogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Espíritu Santure ñaꞌarõ ucũcã peꞌema, ne acobojotisami. Tojota acobojotiyʉꞌrʉocʉ̃sami. Buꞌiritinuꞌcũgʉ̃sami, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aꞌtere na “Wãtĩrẽ cʉomi” nise buꞌiri tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cʉ̃ tojo nirĩ cura Jesú paco, cʉ̃ acabijirã etacãrã niwã. Na sope pʉꞌtopʉ ejanʉꞌcã, Jesure pijidutisõrõcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesú pʉꞌto dujirã cʉ̃rẽ nicãrã niwã: —Mʉꞌʉ paco, mʉꞌʉ acabijirã sope pʉꞌto mʉꞌʉrẽ aꞌmarã weeapãrã, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Cʉ̃ narẽ nicʉ niwĩ: —¿Noanojõ nisari yʉꞌʉ paco, yʉꞌʉ acabijirã? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Cʉ̃ sumuto dujirãrẽ ĩꞌa, narẽ nicʉ niwĩ: —Ãꞌrã peꞌe yʉꞌʉ paco, yʉꞌʉ acabijirã weronojõ nima. ");
INSERT INTO tuoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aꞌtiro niꞌi. Noꞌo Õꞌacʉ̃ ʉaro weerãnojõ náta yʉꞌʉ acabiji, yʉꞌʉ acabijo, yʉꞌʉ paco weronojõ nima, ni ucũcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Apaturi Jesú ditara sumutopʉ buꞌecʉ niwĩ. Pãjãrã masã cʉ̃ pʉꞌtopʉ nerẽcãrã niwã. Na pãjãrã niyʉꞌrʉcã ĩꞌagʉ̃, Jesú yucʉsʉpʉ mʉjãsãjãa, ejanujãcʉ niwĩ. Masã peꞌe nucũporopʉ tojacãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Beꞌro narẽ peje queose meꞌrã buꞌecʉ niwĩ. Narẽ aꞌtiro nicʉ niwĩ: ");
INSERT INTO tuoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Niꞌcʉ̃ masʉ̃ cʉ̃ ya wesepʉ otegʉ waꞌasami. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cʉ̃ otegʉ wẽestewãꞌcãcã, maꞌapʉ apeye otese cape doquequeꞌasaꞌa. Mirĩcʉ̃a aꞌti, te perire ĩꞌaboca, baꞌapeꞌocãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Apeye ʉ̃tãpaga cãꞌrõacã diꞌta cʉoro buꞌipʉ doquequeꞌasaꞌa. Te diꞌta cãꞌrõacã niyucã, asibusu maata marã, pĩꞌrĩsaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Beꞌro mujĩpũ asimʉjãtiri cura diꞌta boposãjãyʉꞌrʉa waꞌasaꞌa. Tojo weero nʉꞌcõrĩ cʉotiꞌcaro nitjĩarõ, maata ñaidija waꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apeye otese cape pota waꞌteropʉ bʉrʉqueꞌasaꞌa. Pota peꞌe tere pĩꞌrĩyʉꞌrʉa, wẽjẽcãꞌsaꞌa. Tojo weero ne dʉcatitimirõ, boadija waꞌasaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Apeye otese cape diꞌta añurõpʉ bʉrʉqueꞌasaꞌa. Te pĩꞌrĩ, bʉcʉamʉjã, peje dʉcatisaꞌa. Niꞌcã ño treinta peri dʉcatisaꞌa. Ape ño sesenta peri dʉcatisaꞌa. Ape ño cien peri dʉcatisaꞌa. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Beꞌro narẽ nicʉ niwĩ: —Oꞌmeperi cʉorãnojõ aꞌtere añurõ tʉꞌoya, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Beꞌro Jesú cʉ̃ buꞌerã doce, tojo nicã ãpẽrã cʉ̃ pʉꞌto nirã́ meꞌrã seꞌsaro tojaqueꞌacʉ niwĩ. Cʉ̃rẽ aꞌtiro sẽrĩtiñaꞌcãrã niwã: —¿Deꞌro nisĩꞌrĩrõ weeati sõꞌoníꞌque mʉꞌʉ queose meꞌrã buꞌeꞌque? ni sẽrĩtiñaꞌcãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Cʉ̃ narẽ nicʉ niwĩ: —Õꞌacʉ̃ mʉsãrẽ ãpẽrã todʉporopʉ masĩña marĩmiꞌquere cʉ̃ wiogʉ nisere masĩcã weemi. Yʉꞌʉre ẽjõpeotirãma queose meꞌrã werenoꞌo. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tojo weerã yʉꞌʉ weesere ĩꞌamirã, ĩꞌamasĩsome. Yé cjasere tʉꞌomirã, tʉꞌomasĩtirã tojarã́sama. Na ñaꞌarõ weeꞌquere duꞌu dʉcayutitjĩarã, acobojose sẽrĩsome, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Apeye narẽ ninemocʉ niwĩ: —¿Mʉsã yʉꞌʉ queose oꞌoꞌquere tʉꞌoweti? To pũrĩcãrẽ aꞌtere tʉꞌotirã, ¿deꞌro wee apeyepʉre tʉꞌobosaʉ? ");
INSERT INTO tuoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Otese capere otegʉ, yé quetire weregʉ weronojõ nisami. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Masã ãpẽrã maꞌapʉ otese cape bʉrʉqueꞌaꞌque weronojõ nisama. Na, yé quetire tʉꞌosama. Beꞌro wãtĩ aꞌti, na tʉꞌomiꞌquere ẽꞌmapeꞌocãꞌsami. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ãpẽrã ʉ̃tãpaga waꞌteropʉ doquequeꞌaꞌque peri weronojõ nisama. Yé quetire añurõ eꞌcatise meꞌrã tʉꞌosama. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na tojo tʉꞌomirã, nʉꞌcõrĩ marĩrã weronojõ nisama. Narẽ mejẽcã waꞌacã, o ãpẽrã te quetire ẽjõpeose buꞌiri narẽ tuꞌticã, maata ẽjõpeoduꞌucãꞌsama. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ãpẽrã otese cape pota waꞌtero doquequeꞌaꞌque weronojõ nisama. Yé quetire tʉꞌoma, tʉꞌorã peꞌe. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Aꞌti ʉmʉco cjase peꞌere wãcũyʉꞌrʉoquejocãꞌsama. Noꞌo deꞌro nisere ʉaripejayʉꞌrʉasama. Na tojo niseticã, aꞌte narẽ dojorẽcãꞌsaꞌa. Na tʉꞌoꞌquere acobojo, dʉca marĩrã weronojõ tojasama. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ãpẽrã peꞌe yé quetire tʉꞌorã, añurõ ẽjõpeosama. Na tojo weerã peje dʉcatiro weronojõ nisama. Otese cape diꞌta añurõ bʉrʉqueꞌaꞌque weronojõ nisama. Ãpẽrã treinta peri dʉcatiꞌcaro weronojõ nisama. Ãpẽrã sesenta peri, ãpẽrã cien peri dʉcatiꞌcaro weronojõ nibʉrosama, ni ucũcʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Apeye queosere werenemocʉ niwĩ: —Masã sĩꞌocjare acaro docapʉ sĩꞌotisaꞌa. Tojo nicã na cãrĩrõ docapʉ sĩꞌodʉpotisama. Tojo weronojõ oꞌorã, nipeꞌtiropʉ sĩꞌodutirã ʉꞌmʉarõpʉ yoosama. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","23","Aꞌte weronojõ todʉporopʉ masã masĩnoꞌña marĩꞌquere masĩnoꞌrõsaꞌa. Yaꞌyioropʉ níꞌque quẽꞌrã bajuarosaꞌa. Oꞌmeperi cʉorãnojõ aꞌtere añurõ tʉꞌoya, nicʉ niwĩ. Yé queti masĩnoꞌña marĩmiꞌque beꞌropʉre sĩꞌocja boꞌreyuro weronojõ masĩpeꞌticãꞌnoꞌrõsaꞌa nígʉ̃, tojo nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aꞌtiro ninemocʉ niwĩ tja: —Mʉsã tʉꞌosere añurõ tʉꞌoñaꞌnʉrʉ̃ña. Yé quetire tʉꞌo ẽjõpeoꞌcaronojõta Õꞌacʉ̃ mʉsãrẽ tʉꞌomasĩsere oꞌogʉsami. Añurõ tʉꞌorãrẽ Õꞌacʉ̃ nemorõ añuse oꞌogʉsami. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yʉꞌʉ buꞌese tʉꞌo ẽjõpeonemorãrẽ Õꞌacʉ̃ masĩse oꞌonemogʉ̃sami. Ãpẽrã yʉꞌʉ buꞌesere tʉꞌosĩꞌrĩtibutiarã peꞌere na masĩmiꞌquere ẽꞌmapeꞌocãꞌnoꞌrãsama, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesú apeye queose oꞌonemocʉ niwĩ: —Yʉꞌʉ buꞌese, Õꞌacʉ̃ wiogʉ nise niꞌcʉ̃ masʉ̃ otese capere otero weronojõ niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Otetojanʉꞌcõ, cʉ̃ ĩꞌanʉrʉ̃timigʉ̃, waꞌa waꞌasami. Beꞌro ʉmʉcori, ñamirĩ yóacãta yʉꞌrʉsaꞌa. Te nʉmʉrĩrẽ, te ñamirĩrẽ cʉ̃ oteꞌque te ʉaro pĩꞌrĩ bʉcʉasaꞌa. Cʉ̃ tojo waꞌasere masĩtisami. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cʉ̃ oteꞌque ĩꞌanʉrʉ̃ña marĩrõ te diꞌtapʉre pĩꞌrĩsaꞌa. Ne waro pĩꞌrĩwijamʉꞌtãsaꞌa. Beꞌro pupi, beꞌropʉta te peri dʉca oꞌosaꞌa majã. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te peri ñaica beꞌro cʉ̃ tere tʉ̃ꞌrẽgʉ̃ waꞌasami. Tere tʉ̃ꞌrẽrĩtero ejacã, tojo weesami, nicʉ niwĩ Jesú. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesú narẽ werenemocʉ niwĩ: —Õꞌacʉ̃ yarã pãjãrã sãjãrã́sama nisere aꞌte queose meꞌrã weregʉti. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aꞌtiro niꞌi. Niꞌcã mostaza cape oteꞌque weronojõ niꞌi. Ti caperota cãꞌcaperoacã waro niꞌi. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tócapeacã nimirõ, otéca beꞌro pĩꞌrĩrõpʉa pajibutiacjʉ yucʉgʉ pĩꞌrĩsaꞌa. Pacase dʉpʉritisaꞌa. Mirĩcʉ̃a tigʉpʉ acoroápesasama. Õꞌacʉ̃ wiogʉ nise oteri pe cãꞌpeacã weronojõ nʉꞌcãsaꞌa. Beꞌro pajicjʉ bʉcʉaꞌcaro weronojõ nipeꞌtiropʉ cʉ̃ ye queti seꞌsa waꞌasaꞌa. Tojo nicã pãjãrã cʉ̃ yarã sãjãrã́sama nígʉ̃, tojo werecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesú cʉ̃ ye quetire buꞌégʉ, peje queose meꞌrã buꞌemʉjãcʉ niwĩ. Na tʉꞌomasĩrõ ejatuaro buꞌecʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Narẽ buꞌégʉ, queose marĩrõ wereticã weeticʉ niwĩ. Cʉ̃ buꞌerã peꞌere na seꞌsaro nicã, nipeꞌtisere te queosere “Aꞌtiro nisĩꞌrĩrõ weeꞌe”, ni werepeꞌomʉjãcʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesú masãrẽ otese meꞌrã queose wéréca nʉmʉrẽta naꞌisãjãri cura cʉ̃ buꞌerãrẽ aꞌtiro nicʉ niwĩ: —Teꞌa siaquiji ditara sumutopʉ, nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cʉ̃ tojo nicã tʉꞌorã, na yucʉsʉ sãñacawʉpʉ Jesure miipẽꞌacãrã niwã. Masã peꞌe na níꞌcaropʉta tojacãꞌcãrã niwã. Apeyepawʉ quẽꞌrã na meꞌrã pẽꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na pẽꞌarĩ cura wĩꞌrõ ʉpʉtʉ aꞌticaro niwʉ̃. Pãꞌcõrĩ yucʉsʉpʉre paaquesãamʉjãcaro niwʉ̃. Tojo waꞌacã, tiwʉ mirĩdijaropʉ weecaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tojo waꞌari cura Jesú peꞌe siropʉ cʉ̃ dʉpoare apeyenojõ meꞌrã ẽotutjĩagʉ̃ cãrĩsãñacʉ niwĩ. Tojo waꞌacã ĩꞌarã, cʉ̃ buꞌerã cʉ̃rẽ wãꞌcõcãrã niwã. Aꞌtiro nicãrã niwã: —¿Ʉ̃sãrẽ buꞌegʉ, mʉꞌʉ ĩꞌaweti? Marĩ mirĩrãta weeꞌeba, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na tojo nicã tʉꞌogʉ, Jesú wãꞌcãnʉꞌcã, wĩꞌrõrẽ yʉsʉocʉ niwĩ. Pãꞌcõrĩrẽ aꞌtiro nicʉ niwĩ: —Diꞌtamarĩaña, nicʉ niwĩ. Cʉ̃ tojo nicã, wĩꞌrõ diꞌtamarĩa waꞌacaro niwʉ̃. Nipeꞌtise yʉsʉdijapeꞌtia waꞌacaro niwʉ̃. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Beꞌro Jesú cʉ̃ buꞌerãrẽ nicʉ niwĩ: —¿Deꞌro weerã tocãꞌrõ uiati? ¿Mʉsãrẽ ẽjõpeose marĩbutiati? nicʉ niwĩ. ");
INSERT INTO tuoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na ʉpʉtʉ waro ʉcʉaꞌcãrã nitjĩarã, na basu aꞌmerĩ ucũcãrã niwã: —¿Noanojõ nisariba ãꞌrĩ? Cʉ̃rẽ wĩꞌrõ, pãꞌcõrĩpʉta tʉꞌomaatidojacãꞌa, nicãrã niwã. ");
INSERT INTO tuoNT_vpl VALUES ("M