﻿USE sofia;
DROP TABLE IF EXISTS sofia.tuf_vpl;
CREATE TABLE tuf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tuf_vpl WRITE;
INSERT INTO tuf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo cohtinán úchinan eyro. Jesucristo eya David chiwa cohná bahjáquinro. David eya Abraham chiwa cohná bahjáquinro. ");
INSERT INTO tuf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Récaram Abraham sícara Isaac yehnjacro. Isaac sicar Jacob yehnjacro. Jacob sicar Judá cat ey rabin cat cohnajacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá sicar Tamar ohc cut Fares cat, Zara cat cohnajacro. Fares sicar Esrom yehnjacro. Esrom sicar Aram yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram sicar Aminadab yehnjacro. Aminadab sicar Naasón yehnjacro. Naasón sicar Salmón yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón sicar Rahab ohc cut Booz yehnjacro. Booz sicar Rut ohc cut Obed yehnjacro. Obed sicar Isaí yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí sicar David yehnjacro. David cunyat israelin cara reya yehnjacro. Acsar Urías yarjác wiya ohc cut David sicar Salomón yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón sicar Roboam yehnjacro. Roboam sicar Abías yehnjacro. Abías sicar ser ajca Asa yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa sicar Josafat yehnjacro. Josafat sicar Joram yehnjacro. Joram sicar Uzías yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías sicar Jotam yehnjacro. Jotam sicar Acaz yehnjacro. Acaz sicar Ezequías yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías sicar Manasés yehnjacro. Manasés sicar Amón yehnjacro. Amón sicar Josías yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías sicar Jeconías cat, ey rabin cat cohnajacro. Jeconíasan ey rábinan cohná bécayat israelin cajc istiy ahár béjecro. Babilonia cajc cut ahár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Etar israelin cajc istiy beyi yahncút cat, Jeconías sicar Salatiel yehnjacro. Salatiel sicar Zorobabel yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel sicar Abiud yehnjacro. Abiud sícara Eliaquim yehnjacro. Eliaquim sicar Azor yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor sicar Sadoc yehnjacro. Sadoc sicar Aquim yehnjacro. Aquim sicar Eliud yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud sicar Eleazar yehnjacro. Eleazar sicar Matán yehnjacro. Matán sicar Jacob yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob sicar José yehnjacro. José eya María acu raro. María ey ohc cut bin Jesús yehnjacro. Jesús eya Cristo aw̃uro. Ey ojcor Sirat ayjac wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Etan Abraham acat cuar David tas bomcarin icar catorce cohnajacro. Eta jaw̃ David acat cuar bucáy bomcarin icar catorce cohnyat israelin cajc istiy ahár béjecro. Etar yahncút cat icar catorce cohnyat Jesucristo yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo yehnjác ojcor ehcunro. Ey ab ajcan Maríaro. Récaram Maríat José jor chaquin tew̃ chájaquinro. Eyta cuar ey jor anto cámtiro. Anto buca jor camti cuar eya yir ji rehjecro. Sir Ajcan Cámuran Ey ajc cut yir ji rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Eyta cuar Joseat yehw̃ín binat uw ubot ey ques tew̃ cun bár rehjecro. José yajcata bi yájquinro. Eyta cuar uw ubot ey cahm icar tew̃ cun bár rehjecro. Eyta rehquít, uwat istiti etí ten séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Joseat istiti etí ten séhw̃ayat, Sir cacmán ey quin wijacro. Cámsiris wijacro. Wiquír wajacro: —Joseu, David bómcaru, María séhw̃ati yehw̃i. Yehw̃ír behmá úsara bah wiya chaw̃i. Eyat besi yájtiro. Ey ohcuá sar itcháqueyan Sir Ajcan Cámuran Ey chihtá cuitar itchacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maríay sera sah yehnáyqueyra. Eyta yehnyat ajca “Jesús” chaw̃i. Jesús éyatan uwat Sir tayar yajác ques tecuac cahm síwayqueyra. Eyta bira, ajca “Jesús” chaw̃i, wajacro, Sir cacmát. ");
INSERT INTO tuf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sir chihtá ehcúquibat Cristo bitara yehnátatara úchicri ehcú bahjacro. Ehcú bahjác eyta bahnác caba yajacro. ");
INSERT INTO tuf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sir chihtá ehcúquibat uchta cuihsú bahjáquinro: Cahbár uwat questa camti bin ohcuá sar sah yehnáyqueyra. Yehnár sera sah ab ubot yehnáyqueyra. Yehnyat “Emanuel” aw̃átaro, wajacro. Ajca “Emanuel” waquíc “Siran is owatro” ojcor waquíncuano. ");
INSERT INTO tuf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José cámsiris chinay raújaquin sicor bar ajc wijacro. Ajc wiquír car, Sir cacmát ey quin bitara yajcata wajáctara eyta yajacro. María jor yehw̃jacro. Yehw̃ír usi béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yehw̃íc cuar, ey jor questa camti ítchacro. Sah yehníc ocso cuar buca jotra cámtiro. Etar sah yehnyat, Joseat ajca “Jesús” chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús Belén pueblo yehnjacro. Judea cajc cut yehnjacro. Sera ajca Herodes rey cara rehcayat yehnjacro. Eyta yehnyat, werjayín rahsa raquí wihár bin béhjecro. Cuacúr ub chihtá sínjaquin Jerusalén pueblo béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Behquir táyojocro: —¿Judío rey chácata ey buwachcuar awan yehnjacan biscanqui? Eya yehnjác chihtá ehcún ac cuacúr uba úbisti rajacro. Ub ey racayat isat itchacro. Eyta istír buwachcuar tamo sehw̃an acu usár rojocro. Eyta cuácayat eya biscántara is quin ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eyta wacayat, Herodes reyat rahjacro. Eyta rahcuír urá icar tan wan réhtiro. Ehúr wíniro. Jerusalenin bahnaquin cat éytaro. ");
INSERT INTO tuf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Etar Heródesat sacerdótein cat, bachan chihtán siw̃quin cat bahnaquin sécuajacro. Secuar eyin quin wajacro: —¿Is Uw Síuquib Sirat Cara Ayin Wajaquin biscán yehnín cuihsú bahjaqui? wajacro. ¿Sir carit cuitar bitara waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eyta wacayat wajacro: —Judea cajc cutar Belén pueblo cutar yehnáyqueyra, -wajacro-. Uchicrias Sir chihtá ehcúquibat ey ojcor uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Beléninu, ba Judá cajc cut itro. Judá cárinat ítitan, ba puébloan cuaya batro. Ba pueblo binan cara yehnáyqueyra. Yehnár uwa obir yajcáyqueyra. Bachan chihtán síw̃quinat Herodes quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Etar Heródesat werjayín quin istiti táyojocro: “¿Cuacúr ub itchác bita cuanya?” táyojocro. Ay istín ac táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Eyta tayor car eyin Belén cuwín acsar áyjacro. Ayir wajacro: —Ba acsar béowi. Buwachcuar yehnjaquey uroy béowi. Ey ityat, as quin sicor ehcwáy raw̃i. Aját cat ey tamo sehw̃ay ben acu eyta ehcwáy raw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eyinat reyat waquíc rahcuír, acsar béjecro. Eyin bequic cahmor cuacúr ub acsar bijacro. Ub récaji itchác eya eyin cohcarcám bijacro. Bir car buwachcuar yehnjác arar cujacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eyin ub chihrjác istír car ahnian cuít rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Erar cur usi cur ítitan, buwachcuar im ab jotro. Eyta istír, buwachcuar ey cac cahmar cúscara cuit ítchacro. Ey ojcor ay tew̃jacro. Eyta istír car, tew̃ír car imár ow bejec ey ricuajacro. Ricuár bucachcuar acu oro cat, incenso cat, perfume cat rácara wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Etar eyin sicor Herodes quin beti ac cámsiris cuitar ehcúr síujacro. Eyta cuácayat, istiy ibit aw̃at imár cajc cut cuwín sicor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cajc istiy werjayín be yiror, Sir cacmá José quin wijacro. Cámsiris cut wijacro. Wiquír wajacro: —Cui yehnwi. Sah cat ey abá cat béowi. Egipto cajc cut ruhcuay béowi. Aját sicor usár chic ocso tas erar ítuwi. Rey Heródesat buwachcuar ey yauwin úroro. Eyta chihtara in chásarac béowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eyta wacayat, José ajc wijacro. Ajc wiquír car buwachcuar cat abá cat chéycara cuitar béjecro. Egipto cajc cut cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Erar cur car Herodes yaric ocso tas ítchacro. Eta jaw̃ Sir chihtá ehcúquibat úchicrias cuihsú bahjác caba yajacro. Uch cuihsú bahjacro: “Aját Egipto cajc cut bin raquín as wacjá chiátaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Josein be yiror Heródesat werjayín istiti bejec ey itchacro. Werjayinát ima cayar yajác itchacro. Eyta istír abáy túrjacro. Etar Belén pueblo cutar cat, cajc intac bin cat sera sasá bahnaquin tiw̃ áyjacro. Bara bucáy cuti eyin bahnác tiw̃ áyjacro. Cajc istiy werjayinát cuacúr ub itchác caban bita réhctara eyta acat bin tiw̃ áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eta jaw̃ Jeremíasat Sir ajc cut cuihsú bahjác caba yajacro. Eyat uch wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá cajc cut rahcuít, abáy ócaro. Sácajaquin racar ócaro. Raquel bómcarinat imár sasá racar ócaro. Sas eyin bar sácajacro. Etar Raquel bomcarin to ócaro. Tan wan batro. Ub iu áytiro. ");
INSERT INTO tuf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Itchareht yájcajareht, rey Herodes yarjacro. Eyta yari yiror Sir cacúm cámsiris cutar José quin wijacro. José Egipto cajc cut cuácayat ey quin wijacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wiquír car wajacro: —Cui yehnwi. Sah cat, ey abá cat sicor israelin cajc cut sicor yehw̃ béowi. Sah ey yauwa rácara binra bar sácajacro. Etar ohbac itay béowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eyta wacayat, José yehnár sah ey cat, ey abá cat yehw̃ rojocro. Israelin cajc cut behquin rojocro. ");
INSERT INTO tuf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Israelin cajc cut behquir ráhcuitan, sera ajca Arquelos Judea cajc cut cara yehnjacro. Herodes wacjá rehquít cara yehnjacro. Eyta rahcuír, Arquelos cahm ay wini rehquít Judea cajc cut it cun bár rehjecro. Cámsiris cuitar cat Judea cajc cut it áytiro. “¿Cara eyat ba rúhw̃ajaca?” wajacro. Etar acsar Galilea cajc cut itay béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret pueblo cut itay béjecro. Eta jaw̃ úchicrias Sir chihtá béquibat cuihsú bahjacan caba yajacro. Eyat uch wajacro: “Ey ojcor nazareno aw̃áyqueyra,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Itchareht yájcajareht Juan uw rih sar siw̃quib ubach bár cuitar uw quin Sir chihtá ehcwáy yehnjacro. Judea cajc cut ehcwáy yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Eyat uw quin wajacro: —Sir cara yehnín acu bar cab cucaro. Eyta cuácayat behmarat ay bár yajác ques cue rehw̃i. Ay bár yajquíc etwi. Etar Sir tamo síhw̃awi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan uw rih sar siw̃quib ojcor Sir chihtá ehcuquib Isaíasat úchicrias wac bahjacro: Serat ubach bár cuitar cohwro. Eyat wacaro: “Cara wiquíc cahmar bahnác órowa,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan ubach bár cuit ita rabar camello anará cuiir ów̃cuano. Ruwa umá cinturon cuit questácuano. Súritan wan cat bówara anúb sihca cat yácuano. ");
INSERT INTO tuf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juanat ubach bár cuitar Sir chihtá ehcwáy yehnyat Jerusalén uw bahnaquin Juan quin béjecro. Cajc Judea uw bahnaquin cat Juan quin béjecro. Jordán rih intac itquin bahnaquin cat Juan quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Erar bequir car éyinat wajacro: —Uniro. Isat ay bár yajacro, wajacro. Eyta wacayat, Juanat eyin rih sar siw̃jacro. Eyinat ay bár yajquíc etchác ehcún acu eyin istayta acu rih sar siw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cuatán fariséoinan cat, saducéoinan cat Juan quin rih sar siw̃ín cucayat, Juanat eyin quin wajacro: —Ba cumoroán wanro. Ricumán wanro. Ba Sir cuécwata cahm ruhcuín síhw̃aro, -wajacro-. ¿Rehrát ba eyta ruhcua ayi? -wajacro-. Sir cahm rúhcuajatro -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ruhcti cuar ay yajw̃i, -wajacro-. Uwat baat ay bár yajquíc etchác istayta acu eyta yajw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cuáyatra síhw̃ati jaw̃i. Ba Abraham bómcara rehquít ¿Sirat ba cuécwajari síhw̃aqui? ¿Ba tanra eyta síhw̃aqui? Eytara batro, -wajacro-. Cuatán aját ba quin wacaro. Sirat ac ohná chajac sicar Abraham bomcar cohn cun rehquír waquít, bar cohná ucátaro, -wajacro-. Eyta bira ba Abraham bómcara reht Sirat ba cuécwajar, síhw̃ati jaw̃i. Ba tanra eyta síhw̃ati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","’Uch rahcwi. Uwat caruc ub cháctara, ub chátitara wahitro. Wahitír ub chati éyinra tac técaro. Tac tetran oc icar wahnro. Uwat caruc taquir eyta, wahnár eyta Sirat cat eyta yajcaro. Uw urá ay bár binra bahnaquin cab oc icar si ayir wahnro, wajacro, Juanat uw ricá quino. ");
INSERT INTO tuf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Baat ay bár yajác ques cue rehquír, urá tehmoyat, aját ba rih sar siw̃ro, -wajacro, Juanat-. Cuatán istiy as yahncút wicátaro. As yahncút wicata eyan urán as cuitro. Ey urán as cuít etar aját eyra bitách bútajatro, -wajacro-. Aját ey ques barcát eyi yehw̃ béyajatro, -wajacro-. Ey wiquír Sir Ajcan Cámuran Eya ba ur icar chácayqueyra, -wajacro-. Cuatán urá tehmoti éyinra cab oca icar wahnáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Síratan uwa wahitic cab cucaro. Ay yajáctara, ay yájtitara wahitic cab cucaro. Uchtaan wanro. Uwat eb súcaro, -wajacro-. Suquir bucaro. Bur car sura eyra ajquír chácaro. Cuat um ey ecar ey oc cut wahnro, -wajacro-. Eb ecari wahnár eyta, uw ur ay bár bin cat eyta wahnáyqueyra, -wajacro-. Oca tinti bi cuitar wahnáyqueyra, -wajacro-. Uwat eba bur car sura ay biyan ajquír imáy chácaro. Eyta cat ur ay bin cat Sirat imáy ajquír chácayqueyra, wajacro. Juanat uw quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juan uwa rih sar siw̃yat Jesús cat Galilea cajc cut bin Jordán rih cajc cut wijacro. Juanat ima rih sar siw̃ayta ac wijacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan quin wiquír, wajacro: —Asa rih sar siw̃i, wajacro. Etat Juanat Jesús quin wajacro: —Bahat as rih sar siw̃ata binro. ¿Icrát as quin bah rih sar siw̃ín waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eyta wacayat Jesusat wajacro: —Séhw̃ati jaw̃i. Asan eyta siw̃i. Sir ub cahmar bahnác ay yajquín ac eyta yajcátaro, wajacro. Eyta wacayat Juan Bautistat Jesús rih sar siw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Etar Jesús sicor rih sar bin waajacro. Rih sar bin waar cat cuacúr abán querat waar eyta waajacro. Etar ítitan, Sira Ajcan Cámuran Ey átcuran wan cuar Jesús arcutar wiquír ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Etar cuacúr abá sar bin Sirat tew̃ic uwat rahjacro: —Uchan as waquijró. Aját ey sehnacro. Asa ey jor tan wanro, wajacro. Cuacúr bin Sirat tew̃ic uwat eyta rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Juanat uwa siw̃yat Sir Ajcan Cámuran Eyat Jesús uwa bár cuitar áyjacro. Sisramat Jesusan cayar yájcajar ehcún acu áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ayiran Jesús uw bár cuitaran cuarenta cuanjacro. Jesús erar cur, ira yati bach yajacro. Eyta bach yajcayat cuarenta cuanyat, Jesusan yayan abáy rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Etar Sisramat Jesús acat ac yehw̃ír tew̃jacro. Tew̃ír wajacro: —Bah uní Sir waquíjtara, ac ujan irir arwi. Panir uw̃i. Yayín acu uw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Waquít Jesusat wajacro: —Sir carit cuitar wacaro. Itin acu, cuanín acu pan tecútari cuántiro. Acsar echí táyoro. Sir chihtá cuitar wan bar ítataro. Bar cuanátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eyta wacayat Sisramat Jesús Jerusalén pueblo béjecuano. Cur car Sir úbaja arcutar waajacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Sir ubaj arcutar cur wajacro: —Bahan uní Sir ima waquíchtara, behmá ic ocso usár cuar tijcawa, -wajacro-. Sir carit cuitar uchta cuihsú bahjacro, -wajacro, Sisramat-. Sirat ima cuacúr cacmá bah obir yajquín acu áyayqueyra. Eyinat bah at cut caquir bah beyáyqueyra. Eyta becayat ac cut búnojatro, cuihsú bahjacro, wajacro. Sir carit cuitar eyta wac etar ic oso usár cuar tijcawi, wajacro, Sisramat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Waquít Jesusat wajacro: —Sir carit cuitar uchta cat wacaro: Sir imát bitar yajcátatara, bahat ey istín acu Sir quin eyta yajc ayin síhw̃ati jaw̃i, wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Etar Sisramat Jesús rirar rur cut yehw̃ béjecro. Erara bin cajc istiy gobierno, cajc istiy gobierno, bahnác ehcujacro. Ey cutar icuran biyan ay bíntara bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ehcúr wajacro: —Aját bahan gobierno cara yehn áyinro, -wajacro-. Bahat itchaquey behmá quin bahnác wíquinro, -wajacro-. Bahat as quínoan “as caru,” waw̃i. Eyta wacáyatan, aját bahan cara yehn áyinro. Bahnác wíquinro, wajacro, Sisramat, Jesús quino. ");
INSERT INTO tuf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Waquít Jesusat wajacro: —Yehnár biwi, -wajacro-. Sir carit cuitar wacaro: Sira ima tamoa, cara tamoa sehw̃an acu ey ojcor conín acu waquír chájacro. Sir im istir quino “caru,” waquín acu waquír chájacro. Istiy tamo éytara síhw̃ajatro. Istiy ojcor cónajatro. Istiy quino éytara wácajatro, wacaro. Eyta waquír car Jesusat Sisrám chihtá cátiro. ");
INSERT INTO tuf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eyta cuat Sisramat Jesús quínoan acsar seo tew̃ti cham bahjacro. Eyta bahcayat Sir cuacúr cacminát eyan obir yajcáy béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Etar Jesusat rahcuít, Juan cárcel icar tunjác tew̃ic rahjacro. Eyta rahcuír, Jesús sicor Galilea cajc cut cuwín bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Galilea cur car, Nazaret pueblo birá ítiti acsar Capernaum pueblo cut itay bijacro. Capernaum pueblo Zabulonin Neftaliin cajc cutatro. Ey cajc cat riwa cajc cutatro. ");
INSERT INTO tuf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eta jaw̃ Isaías Sir chihtá ehcúquibat eyta rehquín cuihsú bahjác eyta íuti im eyta rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isaíasat úchicri wajacro: Zabulón cajca Neftalí cajca riwa cut cujaquin ibit áw̃atro. Jordán rih áw̃atro. Galilea cajc cutar judío bár bin itro. ");
INSERT INTO tuf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Uwat chéycara cut ub cuitar ístajar rehquír eyta, Galilea uwat cat éytaan wan ur icar chihtá istiti rehjecro. Eyta cuar éyinat rícara istír eyta istayta acu eyin quin chihtá ehcujacro. Wahntar cajc cuitar itquin ubot wan quir cuanjacro. Wan quir cuanír eyta, chihtá uw cucajá acat ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús Capernaum itir cat uw siw̃ay yehnjacro. Uw quin wacáy yehnjacro. Uch wajacro: —Ba urá ay bár ey tehmowi. Sira cara yehnín acu cab bar cucaro. Eyta bira Sir tayar yajác ques cue rehw̃i. Urá ay bár yajquíc etwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Riy istiy Jesús Galilea riw cajc aw̃at bijacro. Eyta be rabar serin cuisa bucáy bin itchacro. Rabin bin itchacro. Istiy ajca Simonro. Simón ojcor “Pedro” cat aw̃uro. Simón taná Andrés cat ératro. Eyin riw ruwa uquin ruóquincuano. Jesús bicayat ub acat éyinat ruwa caquin ac atarraya rih cut téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Etar Jesusat eyin quin wajacro: —As jor sinay béowi -wajacro-. Rih ruwa caquir eyta baat uw éytaan wan cácataro. As chiwa chaquin acu uw cácataro. Aját eyta yajquín ba síw̃inro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Etar éyinat atarraya rih ruwa cáquican cab rehti cham bahjacro. Cham bahr car, Jesús jor bar béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ey acsar bir biráy bár cut Santiago cat ey taná cat canar yajquíc itchacro. Santiago taná ajca Juáncuano. Santiágoin Juanin imár tet Zebedeo jor canó cuitar ruwa caquin atarraya óroro. ");
INSERT INTO tuf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Etar éyinan chiwa chaquin ac Jesusat chíjacro. Etar tetá cat, canó cat cham bahjacro. Cham bahr Jesús jor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús eyin chiwa yinín caquir car, Galilea cajca bahnác cuitar bijacro. Bir car secuac usar uw quin siw̃ot bijacro. Sir cara rehquey chaquin rehc chihtá ehcwót bijacro. Cuercurin cat, yarquin cat tan jacot bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eyta bicayat Siria cajca bahnác cut uwat rahra rahra Jesús yajquíc chihtá ehcujacro. Eyta ehcwayat, uwat cuercurin cat, cuicát ruhw̃uquin cat, yarquin cat, chohcuín cat, Jesús quin rojocro. Rocayat Jesusat sicor tan jájacro. Bahnaquin tan wan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jesusat eyta siw̃yat, uw eyta tan chácayat, uw ricán to bin ey quemir quiujacro. Galilea cajc cut bin, Decápolis cajc cut bin, Jerusalén pueblo bin, Judea cajc cut bin, Jordán rih rahray wihár bin, ricán to bin secuar Jesús chihtá rahcuay béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Uw ricán to bin quíuyat, Jesusat itchacro. Istír, cuhs yir sar bijacro. Erar cur car chihrjacro. Chihryat, im owár beya rabar sinquin eyin Jesusat siw̃quey rahcuay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eyta rahcuay yinyat, Jesusat chihtá uchta síw̃jacro: ");
INSERT INTO tuf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Bíyinat imár ojcor uchta síhw̃ayat, ohbac ítayqueyra. “Asra Sir tamo anto cábai séhw̃atiro,” síhw̃aquin éyinan óhbacro. Imár tamo eyta sihw̃ac rehquít, Sir cara rehquey cuitar cara yináyqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Biyin cuétara óhbacro. Urá cuechú rehquít, Sirat sicor tan wan chácayqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Biyin turti, tiw̃ti, técuati chácayat, eyin óhbacro. Cahujín ac turti rehquít, Sirat eyin quin cajc bahnác wícayqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Bíyinat Sir ub cahmar tayar bár yina racar cuít rehcayat, bahnác ur ay yaj cun rehcayat, óhbacro. Ur ay yaj cun rehquít, Sirat cuitar yajcáyqueyra, caba yajquín acu. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Bíyinatan cahujín tamo cue rehquír, obir yajcáyatan, óhbacro. Sirat eyin obir yajcata etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Biyin urán tayar bár rehcayat, óhbacro. Tayar bár rehquít, eyin ub cuitar Sir istáyqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Bíyinat cahujín rahra rahra tecua ayti jácayat, éyinan óhbacro. Cahujín quin rahra rahra tecua ayti rehquít, Sirat eyin ójcoran “eyin ajmár waquijró, ajmár sasaro,” wacáyqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Bíyinan ur ay yajác ques, yajcata bi yajác ques cahujinat ruhw̃úyatan óhbacro. Ruhw̃ú cuar ay yajquíc rehquít Sir owár cuacúr ítayqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Uwat as chihtá ques ba buror sisyat, ba ruhw̃uyat, ba cahm icar bitara útara sucuar tew̃yat, ba ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ba eyta ruhw̃uyat, tan wan jaw̃i. Ahní chaw̃i. Uwat úchicrias Sir chihtá ehcuquin ruhw̃úr eyta ahra uwat ba cat eyta ruhw̃uro. Eyta sehw̃ar, ba ruhw̃ú rehquít, tan wan jaw̃i. Ahní jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Baan rauwan wanro. Rauwa ruwa ay rehquín chaquir eyta uw ur ay rehquín acu uw tac icar ba cat eyta ur ay ítata binro. Rauw bahsí bár rehcáyatra, sicor bahsí waan acu icuri yájcajatro. Ey icúr acui batro. Ur ay bár ityat ba cat éytaan wan icúr acui batro. Rauwa bahsí bár ey tiw̃ tétaro. Uwat sahuwátaro. Rauw ay bár bi tiw̃ ter eyta, sahuwír eyta, ba cat ur ay bár rehcayat, Sirat ba éytaan wan tétaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Baan oca siran wanro. Cajc uch uwat oca siran ub cut istír eyta, baat cat ur ay yájqueyan eyta istáyqueyra. Pueblo cuhs arcutar bin rúhcuajar eyta, ba cat uwat baat ur ay yájqueyan istiti acura eyta rúhcuajatro. ");
INSERT INTO tuf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Uwat vela anir car cajón satra rúhctiro. Cuat vela anir car cuacúr jácaro. Usar itquin ac, wanquír cuanín ac cuacúr jácaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ba cat eyta jaw̃i. Vela uw ubot cuanír eyta, baat cat uw ubot urá ay yajw̃i. Eyta yajcayat uwat istáyqueyra. Istír car cuacúr Sir Tet ojcor ay wacáyqueyra. Ay tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Uní bár bin síhw̃ati jaw̃i. Aját bachan chihtán sutín acui wijác síhw̃ati jaw̃i. Uchicri Sir chihtá ehcúquinat cuihsú bahjac sutín acu wijác síhw̃ati jaw̃i. Chihtá eya sutín acui wítiro. Cuat ey chihtá cuitar aját icúr yajcata wac bahjáctara asa eyta bahnác caba yajquín acurun wijacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aját ba quin uní wacaro. Ahajira uch cajc cat, cuacúr abá cat im eyta cuácayat bachan chihtán tehmó báreyra. Bahnác caba yajc ocso ajca istiy tehmoti bahnác im eyta rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eyta cuácayat bíyinatan Moisesat wac bahjác chihtá conu bi waca técayatan, bíyinatan cahujín quin chihtá conu bi wacan síw̃yatan, éyinan Sir cara rehquey chácayat uwa ac chiwir rehcáyqueyra. Cuat bíyinatan chihtá ey yajcáyatan, bíyinatan caba síw̃yatan, éyinan Sir cara rehquey cuitar caran cuít rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aját ba quin uní wacaro. Baat urá ayan Fariséoan bachan chihtán síw̃quinan cuít yajcátaro. Eyta yájtieyra, cuacúr Sir quin beya báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Is cohtín quin wac bahjaquey ba rahcuít, uwa yauti jaw̃i, wacaro. Uw yaúyeyra, ey ajc tayar ques técuayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eyta wac bahjacro. Cuatán ajatrá ba quin wacaro. Biyan imár rabir ac túryatan, eyta turic ques ajc táyara técuataro. Bíyinatan imár rab quin ahsín téw̃yatan, eyin cahm ícara werjayín ubot tew̃áyqueyra. Bíyinatan rab quin “cuáyinu, cucuinu,” wacáyatan, éyinan cab oc icar beyata óraro. ");
INSERT INTO tuf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Etarwan bahat Sir usar Sir tamo sehw̃an ac ruwa wahnín rehca rabar séhw̃ata óraro. Behmát ay bár yajác ques bah rabat ténati rehc séhw̃ata óraro. ");
INSERT INTO tuf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Eyta sehw̃ar ruwa wahnti bahwi. Ibtu rab quin biwi. Ey jor sicor tan wan chaw̃i. Tan wan chaquir car sicor ruwa wahnáy raw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Istiyát bah cahm icar tew̃ín werjayín quin ahár béyata óraro. Eyta beya rabar werjayín quin cuti ehchí cuar ey jor tan wan chaw̃i. Eytair báreyra, eyat baan werjayín at icar wic báhtaro. Acsara werjayinát soldado at icar wícataro. Etar soldádoat ba cárcel icar tunátaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eyta cuácayat aját ba quin wacaro. Ba bahnác túntieyra ba úcajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Uwat tew̃ic baat rahcuít, “Istiy wiya yehw̃jaquey jor camti jaw̃i,” waquíc rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Cuat ajatrá ba quin wacaro. Bíyinatan wiw̃ín jor isár yajca rácara wahítyatan, éyinan Sirat ítitan, besir bar yajacro. Eyin urá ícara wiw̃ín eya besir bar yajác éytaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bah uba cut istír cuitar Sir táyara yajcátatara behmá ub bár bin eyta ítuwi. Tayar yajti acu ub bár bin eyta ítuwi. Cuercuran wan ub bár binan wan rehcáyatan ay baran táhnaqui batro. Cuatán orac cuar cab oc icar tiw̃ técayat, ay baran tahnacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bah at cut butar cuitar Sir tayar yajcátatara, behmá átcara bár bin eyta ítuwi. Tayar yajti ac átcara bár bin eyta ítuwi. Cuercuran wan átcara bár binan wan rehcáyatan, ay baran táhnaqui batro. Cuat orac cuar cab oc icar tiw̃ técayat ay baran tahnacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Uchicri waquít: “Serat wiya yehw̃ técayatan, carit cuitar ‘bar yehw̃ tejec,’ cuihsúr car, wiya ey at icar wícataro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Cuat ajatrá ba quin uchta wacaro. Wiyat ima ra bár bin jor besir cámtieyra, raat yehw̃ téjetro. Eyta chihtara wiyat besir yajti cuar serat ey yehw̃ técayat, Sirat ítitan, ser eyat wiya quin besir yajc ayro. Bíyinat cahujín wiya yehw̃ téjequey jor yéhw̃yeyra Sirat ítitan, éyinat cat cahujín wiya besir yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Is cohtín quin úchicri uch cat wajacro: “Bahat Sir ub cahmar sucuar tew̃ti jaw̃i. Sir ub cahmar icúr yajquín waquítara, eyta wácati yajw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Cuatán ajatrá ba quin wacaro: Baat bitara útara yajquín cuácayat, uwat baat uní waquíc istín acu uchta wati jaw̃i: “Sir ub cahmor eyta yajquín,” wati jaw̃i. “Cuacúr abá cahmor uní wacaro,” wati jaw̃i. Cuacúr abá cuitar Sir ima it cuácayat, éytara wati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Cajc uch cahmor uní wacaro,” cat wati jaw̃i. Cajc ucha Sir imáy cuácayat, éytara wati jaw̃i. “Jerusalén pueblo cahmor uní wacaro,” cat wati jaw̃i. Sir imát pueblo ey tuw̃jác cuácayat, éytara wati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Ajmár cuisa cahmor uní wacaro,” cat wati jaw̃i. Behmá chihtá cuitar cuis anará istanác bi ojca téhmojotro. Chámcara ubistán yehn áyajatro. Eyta bira “Ajmár cuisa cahmor uní wacaro,” wati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eyta wati cuar, yajquín cuácayatra “Ihyú, eyta yajquinro,” waw̃i. Yajquín bár cuácayat cat “Batro. Yájcajatro,” waw̃i. Uwat ba ria rahcuín acu acsar cuít wacata rehcáyatra, Sisrám chihtá cuit eyta rehcaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Uchicri wac bahjacan baat rahcuít: “Cahujinat bah ub ruhw̃uyat, rahra cat ey uba ruhw̃átaro. Cahujinat bah ruhr ruhw̃uyat, rahra cat ey ruhra ruhw̃átaro.” Eyta wac bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Cuatán ajatrá ba quin wacaro. Uwat ba ruhw̃ún yehnyat, ey quin ruhw̃ ayti yajti jaw̃i. Uwat atcar cut ba ac tar ey cut bucayat, bucoy rahray wihár cat buc aywi. ");
INSERT INTO tuf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Istiyát tayar icar ba camís síuyat, baat siricajá cat ey quin chaw̃ wiw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Uwat kilometro bucáy ba quin owa yehw̃ín ahár áyitara, behmár chihtá cuitar acsar eyta cat kilometro bucáy yehw̃ béowi. ");
INSERT INTO tuf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Uwat ba quin icúr bi racar chícayat, ey quin es yajti wiw̃i. Uwat ba quin raya inic chícayat ey wítira yajti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Uwat waquíc baat rahcuít, “íw̃oquin sehnác chaw̃i. Cuat quehsí bin quehsuwi.” ");
INSERT INTO tuf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eyta waquíc cuar ajatrá ba quin wacaro. Quehsí bin sehnác chaw̃i. Ba ruhw̃úqueyin cuitar Sir ojcor conwi. ");
INSERT INTO tuf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eyta sehnác chácayat, eyta conyat, ba Sir Tetá cuacúr bin urán wan rehcáyqueyra. Sir Tetá imát urá ay bin acu cat, urá ay bár bin acu cat rahsa cuan ayro. Tayar yajác eyin acu cat, tayar bár bin acu cat riwa ayro. Etarwan quehsí bin sehnác chácayat, Sir urán wan chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Baatán ba sehnác éyina sehnár yajcayat cábai yájtiro. Etana sehnár yajquíc tehmara Sirat icúr wícajatro. Urá ay bár binat cat gobierno tayar chíquinat cat im eyta yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Baat behmár rabin quínoa tew̃yat tecútara caba yájtiro. Ba urán ayan cahujinay cuitra batro. Judío bár binat cat ur ay bár binat cat eyta yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Baat acsar ba cahujín eyin sehnár yajw̃i. Eyin jor tew̃i. Sir Tetá cuacúr binat urán ayan tahnác yajcaro. Ba urá cat éytaan wan ayan tahnác sinwi. ");
INSERT INTO tuf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Acsar Jesusat uw quin wajacro: —Baat Sir tamo sihw̃a rabar urá ay yajw̃i, -wajacro-. Cuat uwat ba istayta acui yajti jaw̃i. Uwat behmár istayta acu ur ay yajcayat, Sir cuacúr binat ba tamo séhw̃atiro. Eyta yajcayat tehmár ba tuna báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Baat cuayin quin iran, oyan, rayan rácara wiquin síhw̃ayat, wiquin cahmor racar wiquey uw quin ehcuti jaw̃i. Urá bucáy binat pueblo ibit aw̃at cat, secuac úsara cat imát racar wícata ey istayta acu ehcuro. Uwat eyin ojcor ay tew̃ayta acu eyta ehcuro. Etarwan uw quin ay wijac tehmár tunic acor ítajatro. Uwat ey ojcor ay tew̃jacan caba túnjacro. Sirat acsar bi túnajatro. ");
INSERT INTO tuf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cuat baatán cuayin ac iran, oyan, rayan wiquin síhw̃ayat cahujín quin ehcuti wiw̃i. Behmár íw̃oquin quino cat ehcuti wiw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eta jaw̃ wícayat uwat istiti cuar wícaro. Istiti wiquic cuar Sirat Tetát istáyqueyra. Eyta istír eyta wijac tehmár sicor ba ac ay yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ba Sir ojcor conín yinyat, urá bucáy binat conár éytara conti jaw̃i. Eyinat secuac usar cat, ubach watar cat uw ubot conyat imaran ayan cuít sehw̃ar eyta conro. Uwat ey istír ey tamo ay síhw̃ayta acu eyta conro. Eta jaw̃ conyat ojcor aját ba quin wacaro. Eyta conic tehmár uwat eyin tamo ay síhw̃ajacro. Eyta conic tehmár, Sirat acsar icrí wica báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cuat baatrá éytara yajti jaw̃i. Baat Sir ojcor conín yinyat, behmár istir usar rauwir, quérati cay cuquír Sir ojcor, Tet ojcor conwi. Uwat istiti conwi. Eyta conyat Sirat Tetát istáyqueyra. Uwat istiti cuar, Sirat istáyqueyra. Eyta istír baat conic tehmár obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Sir ojcor conín yinyat, judío bár binat Sir chihtá sinti binat conár éytara conti jaw̃i. Eyinat conín ac ajca bucoy bucoy im eyta tew̃ro. Sirat Tetát rahcuata sihw̃ar, bucoy bucoy im eyta tew̃a rabar conro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cuat baatrá éytara conti jaw̃i, -wajacro, Jesusat uw sécuajaquin quin-. Baat Sir ojcor, Tet ojcor anto conti cuar, eyat bahnác itro. Ba icúr táyoctara itro. ");
INSERT INTO tuf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eyta cuácayat conín ac uch waw̃i: Tetú, bah cuacúr abá cuitar itro. Uwat bah tamo ay síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bah uw bahnaquin acu cara yehnwi. Cuacúr abá cuitar bahnáquinat bah chihtá cuitar yajc eyta cajc uch cuitar cat uwat eyta yajcátaro. ");
INSERT INTO tuf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuanmí cuit, cuanmí cuit is yayín acu ira wiw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Isat bah tayar yajác sicor tayar bár chaw̃i. Uwat is tayar yajaquey isat sicor tan wan ténaro. Isat tan wan tenar eyta is acu bahat cat eyta yajw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Isat ay bár yajquín síhw̃ayat is eyta yajti acu síuwi. Is ay yajquín aywi. Cuat Sisrám cahmar is obir yajw̃i. Jesusat uw quin eyta conín wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Acsar wajacro: —Uwat ba tayar yajác baat sicor bár cháquitara, Sirat cat baat tayar yajác sicor tayar bár chácayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cuat baat cahujín quin ténatitara, baat tayar yajác cat Sirat ba quin chiáyqueyra. Tena báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ba bacha yajquín yinyat, urá bucáy binat yajquír éytara yajti jaw̃i, -wajacro-. Eyinat bach yajcayat, ima ac cue binir chácaro. Uwat éyinat bach yajquíc istayta acu ac cue binir chácaro. Aját ba quin wacaro. Eyinat bacha yajquíc tehmár, uwat eyta yajquíc caba itro. Cuat acsar ey tehmár Sirat icurí wica báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cuat baat bach yajcayat, ac sucwi. Cuis anar cat órowi. ");
INSERT INTO tuf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Eyta yajcayat úwatra baat bacha yajquíc istá báreyra. Cuat Síratra bar istáyqueyra. Ub cuitar istiti binat bach yajquíc istáyqueyra. Cahujinat istiti cuar eyat istáyqueyra. Eyta istír bach yajquíc tehmár ba obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Cajc uch cuitar rayan oyan taná chin sécuanra síhw̃ati jaw̃i. Cajc uch cuitara oya rohritát ohw̃ro. Sinorát ehsuro. Ohná cat ohnro. Oyan rayan uch cajc cutra bésinat chiw̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cuat Sirat ba ac cuacúr cutar cuít wícayta acu ur ayan cuít chaw̃i. Cuacúr ba ac wiquin cháqueyan óhnajatro. Sinorát éhswajatro. Bésinat chíw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Cajc uch cutar rayan oyan to sécuayat, baat ey tamoa síhw̃ayqueyra. Cuat cuacúr cut Sirat ba quin wiquin to sécuayat ey tamoa síhw̃ayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ba uban oca siran wanro. Oca sira acat bahnác úbaro. Eyta cat baat ay istíctara bitara yajcátatara baatán itro. ");
INSERT INTO tuf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Cuat ay istiti rehquít, bitara útara ay bár yajcátaro. Etarwan ay ístajar rehcayat icúr ay yajcátatara bitách ístajatro. Ur icar checúm baquí chiran wanro. Ay síhw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Patrón bucáy bin acura cacúm bitách chácajatro. Eyta chácyera patrón istiyrá cacmát sehnác chácataro. Eyta cuar patrón istiyrá quehswátaro. Patrón sehnaquey ajcá ji béyataro. Eyta cuaquir patrón quehsuquey ajcá ji béyajatro. Eytaan wan ray behmáy secua racar isó rabar Sir chiwa bitách chácajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Eyta cuácayat aját ba quin uch wacaro. Ba icúr yáhntara, icúr yayíntara síhw̃ati jaw̃i. Ba icúr ow̃íntara síhw̃ati jaw̃i, -wajacro-. Ira yaquic tecut, oya ow̃i tecut étana Sir cac cahmar yarisra ítajatro. Acsar chihtá istiy cat síhw̃ataro. Sir tamo cat síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ruwásira itquey tamo síhw̃awi. Ruwásirat chiyra cátiro. Ira cat rítiro. Ira cat sécuatiro. Usar carót batro. Socua cat batro. Eyta cuar Síratan ruwásira yayín acu wícaro, -wajacro-. Cuatán Síratan ba ajcá jian ruwasir cuít bécaro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Behmár chihtá cuitatran cúnajatro. Sihw̃a yarit catum behmár chihtá cuitatrun acsar bitách cúnajatro. Etarwan cuayar sihw̃a yatro. ");
INSERT INTO tuf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Acsar oya ojcor wacaro. Uch síhw̃awi. Tihw̃ suw bihniquey tamo síhw̃awi, -wajacro-. Ey suwa chaquey tamo síhw̃awi. Súwatra quéjtiro. Oya cat cuíhtiro. ");
INSERT INTO tuf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Eyta cuar uwat itit, óriquenro. Suwa óriquenan oya cuitro. Aját ba quino wacaro. Carin oyin Salomonat oy óriquenan etach ów̃tiro. Salomonat oyan ay binan to ow̃jac cuara, suwa óriquenan etach cutiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Baatán Sir tamora caba síhw̃atiro. Uch síhw̃awi. Síratan tihw̃ suw óriquin óroro. Etarwan ba ácuan cuít ow̃in wícataro, -wajacro-. Riy istiy tihw̃ suw óriquin rehcaro. Cuatán cuanmí cuit oc icar wahnro. Eyta cuar Sirat tihw̃ eyan ay obir yájcuano. Sirat tihw̃ suwan eyta obir yajc eyrum ba uwan cuít obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eyta bira icúr yayíntara, icúr yáhntara síhw̃ati jaw̃i. Icúr ow̃átatara síhw̃ati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Judío bár binat sihw̃ar éytara síhw̃ati jaw̃i. Sir tamo síhw̃ati bin urán wan chati jaw̃i, -wajacro-. Uwa bahnáquinat bi yayíntara, bi yáhntara ey tamo síhw̃aro. Cuatán Sir tamora séhw̃atiro. Eyta cuar bah oya cat, ira cat táyocan Sirat itro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cuatán Sir chihtá yajquín tamoan cuít síhw̃awi. Sir chihtá yajquín síhw̃ayata, baan Síratan oya cat, ira cat wícayqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","’Cuanmí cuít ohbac ítatatara, ohbac ítajartara istiti rehquít síhw̃ati jaw̃i. Cuanmí cuit, cuanmí cuit icúr tamo síhw̃antara is acam itchácayqueyra. Ey tamo cuanmít caba síhw̃ataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Cahujín ríoti jaw̃i. Sirat ba ríoti acu cahujín ríoti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Cuat baat ríoeyra, bi ques ícara ríotara, im ey ques Sirat ba técuayqueyra. Baat cahujín bita técuatara, Sirat ba rahra cat im eyta técuayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Baan urá bucayro. Behmarat táyaran abáy yajcaro. Behmarat táyaran abáy yajquíc cuar cahujín cahm icar tew̃ro. Ay baran táhnaqui bár bi ques tew̃ro. Baat úchtaan waan yajcaro. Uwat istiy quin wacaro: “Chahrú, aját bah ub icar bin cajc bura bijaquey úquinro,” wacaro. Eyta waquíc cuar caruc tutcuar im ub ícatro. Caruc tutcuar ima ub icar cuácayat, istiy ub icar bin cajc bur ohbac bitách úcajatro. Ohbac úcajar eyta tayar ji binat éytaan wan ay baran táhnaqui bár ques ohbac bitách téw̃ajatro. Récaji im ub icar bin caruc tutcuar bijaquey ucata binro. Im ub icar bin récaji ucata eyta baat cat éytaan wan behmár ur ay bár yajquíc récaji tehmótaro. Eyta tehmár car, istiy quin ohbac wacáyqueyra, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Sir chihtá rahcuata bin quin Sir chihtá ehcuwi. Cuatán rahcuí cun bár bin quínora ehcuti jaw̃i. Uch síhw̃awi. Uwat Sir ac yaujác ruwa bayar quin wítiro. Bayar quin wícyeyra, báyarat wiquib sicor cóhyqueyra. Cuc raya cat tusín cac cahmor chátiro. Ey cac cahmar chácyeyra, tusinat ques cut sahu téyqueyra. Eytaan wan rahcuí cun bár eyin quino ehcúyeyra, ¿éyinat chihtá cat ba cat rúhw̃ajaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Icúr rácartara, Sir quin ey conwi, -wajacro-. Conyat, Sirat bar wícayqueyra. Icúr rácartara, Sir cac cahm conay biwi. Eyta conay bicayat, baat icúr úroctar bar istáyqueyra, -wajacro-. Tunjaquey waan chícayat cat, Sirat rahcuír ba acu bar waáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Biyat conictar eyin at icar wícaro. Biyat conay bíctara éyinat itro. Biyat tunjaquey waayta acu chíctara eyin ac waacaro, -wajacro, Jesúsata chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Eyta waquír wajacro-. Ba wacját ba quin pan chícayat, baat waquíj quin aqui wítiro. Pan wícaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eyta cat ba wacját rih ruwa chícayat, baat cumoroí wítiro. Rih ruwa wícaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ba urá ay bár cuara, ba wacjí quin ay bi racar wiquic sínjacro. Eyta cat Síratan Tetatán baan racar ay bi wícayqueyra. Baat ey quin chícayatan, ay bi wícayqueyra. Ur ayan tahnác reht ay bi wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Baat behmár acu cahujín quin icúr yajc ay cúntara, baat cahujín acu eyta yajw̃i. Eyta yajcayat bachan chihtán caba yajcaro. Sir chihtá ehcuquin wac bahjac caba yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Querat conu bin sicar rauwin acu yají raúwataro. Eytaan wan Sir quin rauwin acu yají raúwataro. Etar ba rauwin acu yají jaw̃i. Ibit cáctara cuít bi aw̃at ben cat urá bár bécaro. Querat cumac bi icar rauwir eyta, ur ay bár yajquíc cat éytaro. Ibit cáctara cuít bi aw̃at bir eyta, ur ay bár yajquíc cat éytaro. Urá bár yajcaro. Etar ur ay bár yájquinan ricán toro. Cab oc icar beyin binan ricán toro. ");
INSERT INTO tuf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eyta cuat querat conu bi icar rauwin, yají raúwataro. Ibit sehw̃í aw̃at ben yají bétaro. Querat conu bi icar rauwir eyta, Sir quin ben cat éytaro. Ibit sehw̃í aw̃at bir eyta, Sir quin ben cat éytaro. Yají bétaro. Etar Sir jor cuacúr ítata bin ricá birách batro. Eyta etar Sir quin rauwin acu yají jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Sir chihtá ehcúquinir bin cahmar yají jaw̃i. ¿Eyinat cuw cutar ba cayar yájcajaqui? ¿Ba quin Sir chihtá waca áyajaqui? ");
INSERT INTO tuf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Uwat chistár ub yayar cuitar chistár bitáratara istátaro. Cachá chistarat chistár ub ay binra chátiro. Eyta cat cachá chi bin cárucuat higuera ubra chátiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Caruc bitara bíntara cat éytaro. Ub wahitro. Uba áytara, uwat ítitan, caruc cat ayro. Cuat uba ay bártara, caruc cat ay batro. ");
INSERT INTO tuf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Cárucua ay biyat uban ay bár bin chaca báreyra. Cárucua ay bár biyat uban ay bi chaca báreyra. Eyta cat uw urá bitara bíntara istín acu bitara yájctara úrowi. ");
INSERT INTO tuf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Cárucua uba ay bin chátieyra, tac técuano. Taquir car oca cut wahná técuano. Eyta cat uwat urá ay bár yájqueyan cab oc icar tétaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Caruc bitara bíntara ub uror cuitar istír eyta, uwa urá cat bitar bíntara, uwat bitar yájctara wahitátaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Uwa quir binat as quin “Caru, caru,” wacaro. Etara waquíc tecutar Sir quin cuacúr itay béyajatro. Cuat bíyinatan as Sir Tetá chihtá yajcáyatan, bíyinat cuacúr itquey chihtá cácayatan, éyinan cuacúr ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cábara cab cucayat ricán to binat as quin wacátaro: “Caru, Caru, bah ajc cut isat bah chihtá uw quin ehcú bahjacro. Bah ajc cut isat cahujín sícara bin cuicá si áyjacro. Bah ajc cut isat yarquin tan jájacro,” wacátaro. ");
INSERT INTO tuf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Eyta wacayat, aját eyin quin waquinro: “Aját ba istiti binro. Ba ur ay bár yájquinu, as quin ténati quir béowi,” waquinro. ");
INSERT INTO tuf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Bíyatan as chihtá rahcuír yajcáyatan, eyan úchtaan wanro. Sera urá ji binat ubach tuw̃áy yehnro. Etar teba ocuán acu ucar usór cuíjacro. Cuiir ócsoran teba chájacro. Chaquir teb ques ac chaw̃, ica chaw̃ tajacro. Quehrti acu tajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tuw̃ tíhryatan riy istiy riwan abáy áyjacro. Rih ey cuicár cuinjacro. Sero cat abáy cajacro. Cuinyat rih ey ubach quer ques cujacro. Eyta cuar ubach eya ay tuw̃jác biro. Eyta bira rihat cuinír cuícayatan quéhrtiro, -wajacro-. Uw cat éytaan wanro. Bíyatan as chihtá rahcuír yajcáyatan éytaan wan jácayqueyra. Cuácajar rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cuatán bíyatan as chihtá rahcuí cuar yajti cuácayatan eyra úchtaan wanro. Urá bár binat ubach tuw̃jacro. Eyta cuar tebra ocuátiro. At cut quejecro. Eyta túw̃yatan, ítchareht riwa áyjacro. Rihan ey acor cuicár cuinjacro. Sero cat cajacro. ");
INSERT INTO tuf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Rihan to cuinyat, rih canarát ubach in bar cuájacro. Ubach quehr téjecro. Uw cat éytaan wanro. Bíyatan as chihtá yajti cuácayatan éytaro. Abáy cuácataro, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesusat uw quin tew̃ tihryat uwa ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesúsatra siw̃ic eyra Judío bachan chihtán síw̃quinat éytara síw̃tiro. Jesusat ajquír ay síw̃jacro. Jesusat Sir urá cut síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Etar Jesús sicor cuhs yir sar bin isu waar rajacro. Isu waar racayat uw quir binan Jesús owár bejecro. ");
INSERT INTO tuf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Etara ser istiy Jesús quin wijacro. Ser eya ruhsúc restá cájaquey cuercúrcuano. Sura ohníc restá cájaquey cuercúrcuano. Jesús quin wiquír Jesús cac cahmar cúscara cuitara chihrjacro. Imát “Jesusan ayro,” sehw̃ac ehcún acu cúscara cuitar chihrjacro. Chihrir wajacro: —Bahatán as orac chac cúntara, eyta chaquin acu urá chero, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesusat sura ohníc ey at cut butajacro. At cut butár, wajacro: —Eyta tan cha cun rehcaro. Tan wan ítuwi. Orac chaw̃i, wajacro. Jesusat eyta wacayat, bar tan jájacro. Icúr bár rehquey sícara sura bar tunjacro. Orac chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Etar Jesusat ey quin wajacro: —As chihtá rahcwa, -wajacro-. Bahnaquin quínoan icúr ehcuti jaw̃a, -wajacro-. Eyta cuar sacerdote quin in biwi. Sacerdóteat baha sura ohníc tunchác ey istayta acu biwi. Etara cat Sir quin wícata ey wiw̃i. Sir chihtá ehcuquib Moisesat icúr wícata cuihsú bahjáctara Sir quin ey wiw̃i. Eyta yajcayat uwat baha bahnác bar orac chajac istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Eyta waquír Jesusan acsar pueblo Capernaum bijacro. Capernaum cucayat, soldado Cara Jesús acam way wiquír conjacro: ");
INSERT INTO tuf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Caru, as cacúm usar yatro. Yarat bar en bicaro. Senotát rénara questajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eyta wacayat, Jesusat wajacro: —Aját ey tan jacay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Eyta wacayat, soldado carat wajacro: —Récaji biti jaw̃i. Bah ayan as cuítcuano. Bah caran tócuano. Asan bah etach batro. Bah as usi rauwin ac bahra ayan tahnacro. Eyta bira behmá biti jaw̃i. Cuatán cajc birá cuitar cuar, bahatán as cacmá tan jaw̃i. Cajc birá cuitar cuaquir, “Tan jaw̃i,” wacayat bar tan jácayqueyra, -wajacro, soldádoat Jesús quin-. ");
INSERT INTO tuf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","As cat cara chiro. Etar aját ey chihtá cácaro. Cátira bitách yájcajatro. Ajáy cacmín cat chero, -wajacro-. Cacúm istiy quin “Bahan biwi,” wacaro. Eyta wacayat, ey bar béyqueyra. Cacúm istiy quin “Raw̃i” wacaro. Eyta wacayat, ey bar racáyqueyra, -wajacro-. As usi cacúm quin “Uch yajw̃i,” wacaro. Eyta wacayat eyat bar yajcáyqueyra, wajacro, soldádoat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eyta wacayat, Jesusat ub yehw̃jacro. Etar ricá sécuajaquin quin wajacro: —Aját ba quin wacaro. Romano soldado uchat as ajcan cámuran cuít séhw̃aro. Uní séhw̃aro. Israélinat as tamo etach síhw̃atiro, -wajacro-. Romano uchan judío bár bin cuar ur icar ay séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Etarwan, aját ba quin wacaro. Uwa cajc istiy binan bisar bisar binan Sir owár cuacúr sécuayqueyra. Rahsa raquí wihara binan, rahsa rauwic wihara binan, erar sécuayqueyra. Secuar car Abrahamin owár, Isaaquin owár, Jacobin owár ira yayáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Cuatán judíoin Sir owár cuacúr sécuata bin cuar sécuatiro. Eyinan tinjac baquí chira cuitar téyqueyra. Erar cuitar uwa abáy conáyqueyra. Abáy óyqueyra. Yaran abáy rehquít ruhra cuechwáyqueyra, wajacro, Jesusat ");
INSERT INTO tuf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Uw sécuajaquin quin eyta waquír soldado cara quin wajacro: —Bah sicor tan wan biwi. Aját bah cacúm tan jácata sehw̃ac rehquít bar tan jácayqueyra, wajacro. Jesusat eyta wacayat owár, soldado cacúm sicor bar tan jájacro, ey urá cut. ");
INSERT INTO tuf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesusat eyta waquír, acsar Pedro usi bijacro. Erar cur ítitan, Pedro áw̃iya cuhmác si yatro. Tiuír yatro. ");
INSERT INTO tuf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eyta istír Jesusat Pedro áw̃iya eya at cut butajacro. Jesusat butayat, tíucan bar etchacro. Tiuír yarquey etyat eya cui yehnjacro. Cui yehnár Jesús ac ira anír wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Itchareht rahsa rauyat uwan Jesús quin béhjecro. Behquir cuicát ruhw̃úqueyin ey quin rojocro. Rocayat Jesusat eyin ur icar bin cuicá te sijacro. Ajc tew̃ír cuitar cuicá te sijacro. Yárqueyin cat bahnaquin tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Etarwan úchicrias Isaíasat Sir ajc cut wac bahjác ahra caba yajacro. Isaíasat wajacro: “Is restá cahmar, yaric cahmar is síujacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Uw Jesús quemir sécuajacro. Eyta sécuayat, Jesusat ima chiwa quin wajacro: —Bar jaw̃, riw rahray, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Anto beti cuat Moisés bachan chihtán siw̃quib Jesús quin wiquír wajacro: —Bah bir bíctara as cat bah jor erar benro. Bah jor sinay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Etat Jesusat wajacro: —As ajca rahcwi. Sinacub cat ucar chiro. Ruwasir cat chicha chiro. Cuatán asra camín acui ubach batro. Asan Uw Síuquib bísari cámajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Etat Jesús ima chiwa istiyát Jesús quin wajacro: —Caru, récaram as tetá chin ocso tas usár ítinro. As tet yáryatan chein ey ruhcuinro. Etar bah owár sinay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Etat Jesusat wajacro: —Cahujínatra as chihtá cátiro. Cati eyan chéinan wanro. Eyinat chein ruhcuátaro. Cuat bah asi jor récaji sinay biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Etar Jesús cat, chiwa cat canó sar raújacro. Rauwir rahray cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bécayat séroan abáy cab rehti cajacro. Séroan abáy cacayat riw sobásoban racyan canó icar raújacro. Eyta cuar Jesusan canó sar camro. ");
INSERT INTO tuf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Riw sobásoban raquian canó icar rauyat, chiwat Jesús quehw̃ujacro. Quehw̃úr wajacro: —In yehnwa, -wajacro-. ¡Síw̃quibu! ¡Canó riw ocso bicaro! ¡Is bar sácataro! wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús ajc wiquír yehnjacro. Yehnár ítitan, séroan abáy cajacro. Eyta cuácayat sero chihr áyjacro. Riw quin wajacro: —Soboti jaw̃i. Catoti jaw̃a, wajacro. Etatan séroa bar chihrjacro. Riwa sobasob bin sicor bar chihrjacro. Etaran Jesusat chiwa quin wajacro: —¿Bitara rehtan ay wínica? -wajacro-. Baat Sir tamo ay síhw̃ati binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Séroa chihryat, riw sobasob chihryat chiwa eyin ub yehw̃jacro. Rahra rahra wajacro: —¿Ser ucha bitara bíntara? Séroa cat riw sobasob bin ey chihtá cuitar chihrjacro. ¿Bitara bíntara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Etar Jesusin riwa rahray cujacro. Gadara cajc cujacro. Rahray cucayat, serin bucáy bin Jesús quin rojocro. Serin eyin chein ruhcuíc cuítara itro. Eyinan cuicát abáy ruhw̃uro. Eyta ruhw̃uyat, técuasan abayro. Eyin cahmar ayú rehquít, uwa ey ibit aw̃at bétiro. ");
INSERT INTO tuf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Serin éyinat cab rehti Jesús cuit cohwjacro. Cohwír wajacro: —Jesusu, bah Sir waquijró. ¿Is quin icúr sehw̃ar racyi? Anto is tecuan cab cuti cuar ¿is técuani séhw̃aqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Etat owár cajc birách bár cuitar tusina ricá to binat tihw̃á yácaro. ");
INSERT INTO tuf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eyta cuácayat serin eyin urá icar bin cuicát conjacro. Jesús quin conjacro: —Isat bah ojcor conro. Isan serin urá icar bin si téntara, tusín urá icar rauwin ajc waawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Etat Jesusat wajacro: —Béowi, wajacro. Eyta wacayat, cuicá serin ur icar bin wa béjecro. Beyar tusín sar raújacro. Rauyat tusín ricá to bin bahnác siyo ocso tijca suca béjecro. Beyar, bahnác riw icar sácajacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tusín sácayat, tusín obir yájquinan ayat quinjacro. Pueblo cuwín quinjacro. Pueblo cur car, bahnác ehcujacro. Tusín sácajac cat serin urá icar bin cuicá te sijác cat ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eyta ehcwayat pueblo itquin bahnaquin Jesús wahitay rojocro. Eyta behquír, Jesús istír ey ojcor conjacro. Conár wajacro: —Usár ítiti jaw̃i. Cajc istiy sicor biwi, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Eyta wacayat, Jesusin canó sar raújacro. Canó ey cuitar sicor riw rahray béjecro. Jesús ima pueblo cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cur car ítchareht, uwat cuercúr Jesús quin rojocro. Cuercúr ey quejtirat cuecujáquinro. Cuercúr eya caros cuitar cuar rojocro. Rojóc éyinat Jesús tamo síhw̃ajacro: “Jesusat sicor tan jácataro,” síhw̃ajacro. Eyta sihw̃ar rojocro. Rocayat Jesusat uw éyinat eyta síhw̃ajac itchacro. Eyta istír cuercúr quin wajacro: —Sahú, aját ba sehnacro. Cue rehti jaw̃i, -wajacro-. Bahat ur ay bár yajáqueyra tayar bár chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bachan chihtán siw̃quin cat ésatro. Jesusat eyta wacayat, éyinat ur icar síhw̃ajacro: “Jesusat téw̃ajar bin tew̃ro. Sir im istir binat ima tayar yajác sicor bár jácata binro,” síhw̃ajacro. “Jesúsatra eyta téw̃ajar binro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Eyta síhw̃acan Jesusat itchacro. Istír eyin quin wajacro: —¿Bitara reht ba ur icar as tamo ay bár síhw̃aqui? -wajacro-. Uch síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cuercurin quin “Bahat ur ay bár yajaqueyra tayar bár chájacro,” wacayat, chauwan cuitro. Ey quin “Cui yehnwi. Caros yehw̃ír usi biwi,” wacayat cat, chauwan cuitro. Urá conu binat eyta bitách wácajatro. ");
INSERT INTO tuf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eyta cuácayat aját ba quin ehcunro. Sirat asa Uw Síuquib quin uw tayar bár chaquin ajc waajác ehcunro. Im urá cut uw tayar bár chaquin acu ajc waajacro. Aját uchta yajquír cutar ba quin eyta ehcuro, wajacro, Jesusat bachan chihtán siw̃quin quin. Etat cuercúr quin wajacro: —Cuercuru, aját bah quin wacaro. Cui yehnwi. Caros yehw̃i. Sicor behmá usi biwi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eyta wacáyatan cuercura cui yehnjacro. Cui yehnár caros secuar ima bijacro. Usi cun bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cuercura Jesús ajc cut yehnár bicayat uwa ricán to binat itchacro. Eyta istír ub yehw̃jacro. Etar Sir ojcor ay wajacro. Sirat uw urá icar camur eyta wijac ojcor ay wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Etar Jesús úsara bin acsar bijacro. Beya rabar gobierno tayar chiquib itchacro. Gobierno tayar chiquib ajca Matéoro. Mateo gobierno ubach wátara itro. Jesusat Mateo istiran, ey quin wajacro: —As jor biwi, as chiwa chaquin acu, wajacro. “Biwi,” wacayat, Mateo yehnár Jesús owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Etar Jesusin Mateo usi yayín sécuajacro. Gobierno tayar chiquin cat, urá ay bár bin cat, Jesusin cat yayín sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jesús eyin owár yayín sécuayat fariséoinat itchacro. Eyta istír, Jesús chiwa quin wajacro: —¿Jesús gobierno tayar chiquin owár, ur ay bár bin owár, bitara reht ira yaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Eyta waquíc Jesusat rahjacro. Rahcuír wajacro: —Uch síhw̃awi. Uwa orac bin médico quin bitani béyajatro. Cuat yárqueyin médicoat sacwayta acu bécaro. ");
INSERT INTO tuf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sira carit cuitar wac bahjác chihtá sinwi. Sirat wajacro: Istiyát tayar yajác ques baat rahra técuati cuar ey cuitar síhw̃ayatan, asan ahniro. Cuat as tamo sihw̃an acu baat ruwa yauyat, as ahní etach batro, wajacro. Etarwan aját orac bin cuitar wacayi rátiro. Cuat bíyinatan imarat Sir tayar yajác síhw̃ayatan, éyinan ajmár chiwa cháquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Etar Juan uw rih sar siw̃quib chiwa Jesús quin béhjecro. Behquír táyojocro: —Isat cat, fariseo chiwat cat Sir bach cuitar ira yátiro. Cuat bah chíwatra bach yajti itro. ¿Bitar etar chihtá ajquír itqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Etat Jesús imát cat, ima chiwat cat bitar etar bach yajti ítictar ehcún acu uchta wajacro: —Sératan wiya yehw̃ín cuácayat, íw̃oquin cat, cayin cat sécuaro. Ira cuít yayín acu sécuaro. Ir ey yaya rabar ahní rehcaro. Ey cáyinatan íw̃oquinatan áhajira wiya yehw̃quib owár rehquít, bacha yájcajatro. Ey racar cuécutiro. Eytaan wan as usár chácayat, as chiwa as jor yayátaro. Etar ítchareht wiya yehw̃quib eya ahár síwataro. Síuyatan ey cayin, ey íw̃oquin bach yajcáyqueyra. Ira yati rehcáyqueyra. Ey racar cue rehcáyqueyra, -wajacro-. Wiya yehw̃quib ahár siwir eyta as cat eyta ahár questár béyayqueyra. Eyta bécayat as chiwat ira yati bacha yajcátaro, wajacro. Eyta ehcúr cuitar Jesusan ima chiwa owár rehcáyatra báchuti itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Eyta waquír car uwa siw̃in acu ehcujacro. Chihtá cahmor ey cat, awan ey cat, owárara séhw̃ati acu ehcujacro. Ima chihtá fariséoinay owár chati siw̃in acu uchta wajacro: —Oya cumar sejéc cuitar istiy cumar bin bahu chaquir quejcátaro. Cuatán oya sejequi ojcor ibsoy bin quéjtiro. Eyta quéjcyera, ibsoy quejcyey suhráyqueyra. Súhryatan oya sejequey acsar racháyqueyra. Eytaan wan chihtá récaji bi cat, chihtá awan bi cat owárai batro. Bucáy bin tamo síhw̃ajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Eyta waquír, ima chihtá awan ey sima tenti binan wan wajacro. Eyta ehcún acu uchta wajacro: —Eyta cat cabra umá sutír questaro. Questár sima ey sar chácaro. Eyta cuar umá cumar bi sar sima tenti bi chátiro. Tenti bi chácyera, sima semar ten racáyatan, umá rachátaro. Rachyat, sima ucátaro. Umá cat ay bár rehcáyqueyra. Cuatán sima tenti eyra cabra umá ibsoy bi sar chácata binro. Etatrun racha báreyra. Sima cat úcajatro. Eyta cat chihtá awan bi ajquitro. Cahmor bi cat ajquitro. Eyta bira bucáy bin cácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesusat eyta wacayat, judíoin cara Jesús quin wijacro. Cara eyat Jesús ojcor conín ac cuscar cuit chihrjacro. Chihrír wajacro: —As wacjá cuechira bi bar yarjacro. Aját bah ojcor conro. Asi jor ey quin béowi. Bahat as wacjá at cut bútawi. Bahat eyta bútayat, eya estají rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eyta conyat Jesús cara jor béjecro. Jesús chiwa cat béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jesusin bécayat, wiw̃ istiy ey questoc bijacro. Wiw̃á, eya cuercutro. Ey rih cut rauwir bara dócero. Cab eyta ácatan abir eyat yatro. Tan chati yara yehw̃ro. Eya Jesús questoc be rabar Jesús oya aca butajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Aját Jesús oya buta tecut, as sicor tan jácayqueyra,” séhw̃ajacro. Eyta sehw̃ar oya aca bútajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Oya bútayat, Jesús ey wihara ac wari cuar wajacro: —Wiw̃ú, cue rehti jaw̃i. Bahat sehw̃at, aját bah sicor tan jácata, séhw̃aro. Eyta sehw̃ac rehquít bah tan jácayqueyra, wajacro, Jesusat. Eyta wacayat cab rehti sicor bar tan jájacro, Jesús urá cut. ");
INSERT INTO tuf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Etar acsar Jesús cara usi cun bijacro. Erar cur ítitan, ricán to binan yarjaquey racar ócaro. Cahujinat tirá cucaro. ");
INSERT INTO tuf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eyta istír Jesusat eyin quin wajacro: —Etwi. Watar quir béowi. Cuechír eyra yártiro. Yarti cuar bar cámjacro, wajacro. Eyta wacayat uwat Jesús buror sischacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Etar watar waajacro. Bahnaquin watar waacayat, Jesús chein quin raújacro. Rauwir cuechír yarjaquey átcara yehw̃jacro. Jesusat atcar yehw̃yat ajc wijacro. Ajc wiquír cui yehnjacro, cuechír eya. ");
INSERT INTO tuf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Etar uwat Jesusat chein ajc wic ayjac chihtá bísaran bísaran ehcwáy yinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Etar Jesús acsar bijacro. Acsar bicayat ub bár bin cuisa bucáy bin ey questoc béjecro. Questoc beya rabar Jesús cuit cohwjacro. Cohwír wajacro: —David wihnú, is cuayin racar jaw̃i. Is cuayin obir yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Etat Jesús usi cur car raújacro. Rauyat, ub bár bin Jesús quin behjecro. Behcayat Jesusat eyin quin wajacro: —Baat sihw̃at, ¿aját ba ub chi chácataica? ¿Aját ba bar tan jácataica? ¿Baat eyta síhw̃aca? wajacro. —Ee. Cara, isat eyta síhw̃aro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Etar Jesusat eyin uban bar bútajacro. Butar wajacro: —Aját ba ub chi chácata sihw̃ac etar aját ba cuitar yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jesusat eyta wacayat eyin sicor ub chi chájacro. Ub cuitar bar istata rehjecro. Etar Jesusat eyin quin ajc uní cuitar wajacro: —Aját yajác uw quínora ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eyta wajác cuaquir, cajc ey cuitar Jesusat yajác chihtá bisar bisar tew̃ót béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesusat ub bár eyin óroyat sicor béjecro. Sicor bey yiror uwat Jesús quin sera ajc bár bi rojocro. Sera eya cuicát ruhw̃ujác etar ajc batro. ");
INSERT INTO tuf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ajc bár bi rocayat, Jesusat cuicá uc téjecro. Jesusat cuicá úcayat, ser eyat ajc chi waajacro. Eyta cuácayat, ricán to binat rahra rahra tew̃jacro: —¿Unítara? Is israelin tasar istiyati uchta yajti biro. Récaji yajti bi bar yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cuatán fariséoinat Jesús ojcor wajacro: —Cuicá cara urá cuitar Jesusat cuicá uc técaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Etan Jesús pueblo istiy cutar cat, istiy cutar cat, chihtá ehcwót bijacro. Secuac usar síw̃jacro. Sir cara rehquey ojcor wajacro. Yárqueyin cat sicor tan jájacro. Cuercurin cat orac chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cajc istiy, cajc istiy Jesús cur ítitan, uwan cue quen quen it sácaro. Uwa bíyati obir yájcajatro. Obas cayíb bár bin ruhw̃úr eyta uwa cat eyta ruhw̃uro. Eyta istír, ruhw̃úqueyin racar rehquít obir yajc cun rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ima chiwa quin wajacro: —Uwan eba rijacan wanro. Eba rijáqueyan awan semar tam rehcátaro. Eyta cat uwat Sir chihtá rahcuír awan semar cácaro. Eba tam rehcayat uwat bocuro. Eyta cat uwa quir binat Sir chihtá caquin rehcátaro. Eyin quin ehcwáy beta binro. Cuatán bíyati éhcwajatro. Chihtá ehcuquin birách batro. ");
INSERT INTO tuf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eyta cuácayat Sir ojcor conwi. Uw quin Sir chihtá siw̃ay si ayin acu conwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesusat ima acu chiwa doce cájacro. Etar éyinan ey cac cahmar behcayat, éyinat uw ur icar bin cuicá si ayin acu urá wíjacro. Yarquin cat, cuercurin cat tan jaquin acu urá wíjacro. Urá wiquír eyta yajquín ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Chiwa cájaquinan úchinan éyinro: Récaji bi Simón cájacro. Ey yahncút Andrés cat, Santiago cat, Juan cat, Felipe cat, Bartolomé cat, Tomás cat Mateo cat, Santiago cat, Lebeo cat, Simón cat, Judas Iscariote cat cájacro. Simón ajc istiy cut Pedro aw̃uro. Andrés eya Simón tanaró. Santiago eya Zebedeo waquijró. Juan eya Santiago tanaró. Mateo eya gobierno tayar chiquib chájaquinro. Santiago eya Alfeo waquijró. Lebeo eya ajc istiy Tadeoro. Simón eya cananístainro. Judas Iscariote eyat ítchareht Jesús quehsí waajacro. ");
INSERT INTO tuf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Etar cuisa doce bin quin Jesusat cahujín ajquír, cahujín ajquír, cahujín ajquír, Sir chihtá ehcwót beyin wajacro. Beyin cahmor eyin quin wajacro: —Judío bár bin cajc cut beti jaw̃i. Samaria cajc cut cat Samaria pueblo cut cat beti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cuat israelin quin ehcwáy béowi. Israelin obas íujaquinan wanro. Obas iwir imár istir cayíb quin rati eyta, israélinat cat síw̃tira éytaan wan Sir chihtá sínajatro. Eyta cuácayat eyin quin ehcwáy béowi. ");
INSERT INTO tuf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ehcwót becayat, “Sir cara yehníc bar cab cucaro,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Eyta beya rabar yarquin sicor tan wan chaw̃i. Sácajaquin sicor estají yin aywi. Ojc ohná bequin sicor orac chaw̃i. Uw ur icar bin cuicá si tewi. Tayar chiti eyta racar yajw̃i. Baat tunti cuar camur wíjacro. Eyta cuácayat acsar tayar chiti uw obir yajw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ba bécayat ata béowi. Oro cat, ray cat, yera ray cat beti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Iroc cat beti jaw̃i. Tehmón ac camís bucáy cat ques barcát cat teca cat beti jaw̃i. Cacminát canar yajquíc tehmár patronat ira wícaro. Baat cat uw quin chihtá ehcúc tehmár ráhcuiquinat ba obir yajcáyqueyra. Ba obir yajcata sehw̃ar ata béowi. ");
INSERT INTO tuf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ba bi pueblo cucayat, erar cur car Sir chihtá rahcuata eyin wahítuwi. Wahitír rahcuata eyin usi ítuwi. Acsar bequic ocso tas esar ítuwi. ");
INSERT INTO tuf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ey usar rauwa rabar, usar itquin quin “Sirat ba obir yajcáyqueyra,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ey usi itquin chihtá rahcuata bíntara, ba chihtá cuitar Sirat esar itquin tan wan chácayqueyra. Cuat éyinat chihtá ráhcuajartara, eyin quin seo tew̃ti cha bahwi. ");
INSERT INTO tuf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eyta cuara uwat ba ajcá bár chácyeyra, ba chihtá ráhctiyeyra ey pueblo cut uchta yajw̃i. Ba quescara ojcor cajc bura béquiquey, umít béquiquey yiwó ter bahwi. Uw éyinat ba ruhw̃uquey istayta ac eyta yajw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Uwat ba eyta ruhw̃úctara, aját eyin ojcor uní wacaro. Eyta ruhw̃ujác ques, cábara tinyat Sirat ey pueblo uw bahnáyqueyra. Sodomin Gomorrin bahnajác cuít bahnáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Yají jaw̃i. Ba tecuas bár bin cuar, aját ba técuasin tac icar ayro. Obas cohtóc tac icar ayir eyta ba cat éytaan wan ayro. Eyta cuácayat cuaya sinti jaw̃i. Cumoroá cuaya sinti eyta ba cat eyta cuaya sinti jaw̃i. Eyta cuar tecuas cat sinti jaw̃i. Atcurat tecuas bár jaquir eyta baat cat eyta tecuas bár jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Uwa at cahm yají jaw̃i. Uwat baan werjayín cac cahmar chaquir cahmí icar tew̃átaro. Secuac usar cat ba buquíc cat bucáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","As chihtá ques uwat baan carin cac cahmar gobernador cac cahmar ahár beyáyqueyra. Eyta bécayat eyin quino cat, judío bár bin quino cat, as chihtá ojcor tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba eyta becayat, baat eyin cahmar rooti tew̃i. Bitara tew̃átatara, bi chihtá ehcwátatara, sihw̃a sácati jaw̃i. Baat tew̃ic cab cucayat, ba ur icar bow̃ wícayqueyra. Bi ehcwata bíntara ba ur icar bow̃ wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eyta wícayat baat tew̃yat behmár chihtá cuitari téw̃tiro. Cuat Sir Ajcan Cámuran Ey chihtá cuitar tew̃áyqueyra. Eyat baat tew̃ín acu urá wícayqueyra. Eyta cuácayat rooti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Uwat ima rabin yauwin acu cahujín at icar wícayqueyra. Ima sasá cat yauwin ac wícayqueyra. Sasát cat ima tetín abín quehswáyqueyra. Quehsúr car eyin tiw̃in acu cahujín at icar wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","As chiwa chajac ques uwat ba quehswáyqueyra. Eyta cuácayat bíyinatan as chihtá wácati tan úcayatan, aját éyinan síwinro. ");
INSERT INTO tuf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pueblo istiy cuitar ba ruhw̃uyat, pueblo istiy cuitar acsar ehcwáy béowi. Etar aját ba quin wacaro. Eyta ruhw̃úc cahmar quinyat, ba anto israelin pueblo bahnác cutar beti cuat, asa Uw Síuquib cuacúr bin wiquinro. ");
INSERT INTO tuf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sinquib eyan urán ima siw̃quib urán bow̃an cuitra waájatro. Cacmá ajcan ima carin cuitra batro. ");
INSERT INTO tuf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sinquib urán siw̃quib owara waacayat cábaro. Cacmá ajca carin owara chácayat cábaro. Uch síhw̃awi. Uwat as ojcor “Eya Sisrám cáraro. Eya Beelzeburo,” wacaro. Etarwan baan as chiwa yinjác etar ba ojcor im eyta cuít tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Eyta chíhtara uw cahmar ayú rehti jaw̃i. Uch síhw̃awi. Bi chihtán uw cahmar rúhcyeyan, eyan ítchareht yájcajareht bahnáquinat istáyqueyra. Bi chihtán uw quin rahcua ayti cuácayatan eyan semar semar bahnáquinat rahcuáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aját ba quin chéycara cuitar bi chihtá ehcwayat, rícara cuitar bahnáquinat rahcuín acu waw̃i. Bi chihtá cuach cuach tew̃yat, bahnaquin cucajá acat cohwi. ");
INSERT INTO tuf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Istiyát uw yauro. Istiyát uw sibár chaw̃ ajc chaw̃ yauro. Biyat sibár eya yauwata cuácayat ey at cahm rooti jaw̃i. Eyat sibár yauwata cuar uw ajcra cuaca báreyra. Eyta etar ey at cahm rooti jaw̃i. Cuat Sir cahm ayú rehw̃i. Sirat ba sibár yauwir car ba ajc cat cab oc icar áyataro. Etar Sir ima cahm ayú rehw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ruwásira cuisa bucáy bin icar ray sencillo úbisti tunro. Ruwásira aca bár cuar, Sirat ajc waátira, cuis istiyí yara báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Uch síhw̃awi. Ba cuis anará bítatara, Síratan itro. ");
INSERT INTO tuf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eyta bira uw at cahm rooti jaw̃i. Sirat ba sehnacan ruwasir cuitro. Eyta cuácayat Sirat ba obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Uw cucajá acat bíyatan “Jesusan as cáraro,” wacáyatan, aját cat rahra ey ojcor uchta waquinro: “Eyan ajmár uwro,” waquinro, cuacúr cuitar Sir ub cahmar. ");
INSERT INTO tuf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cuat uw cac cahmar bíyatan “Jesusa as cárai batro,” wacayat, aját cat rahra uchta waquinro: “Ey ajmár uwi batro,” waquinro. Cuacúr cuitar Sir cac cahmar eyta waquinro. ");
INSERT INTO tuf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Baat sihw̃at: aját uwan cajc uch cutar tan wan chaquin rajác sihw̃ac óraro. Cuatán aját ba quin wacaro. Ajatrá uw tan wan chácayi rátiro. As raquí cuit uwan rahra rahra técuayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sérinat ima tet owár rahra rahra técuayqueyra. Wiw̃inat cat eyta ima ab owár rahra rahra técuayqueyra. Wiw̃ín cat im isó owár rahra rahra técuayqueyra, as raquí cut. ");
INSERT INTO tuf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Etarwan uwan owár ítquinan quehswáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Bíyinatan ima tetinán, abinán sehnacan as cuítara éyinan as chiwa yínajatro. Bíyinatan ima sasá sehnacan as cuítara éyinan as chiwa yínajatro. ");
INSERT INTO tuf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bíyinan as chiwa cháctara, éyinan as ques icar uwat yauwata óraro. Biyin as ques icar eyta yauwata reht as ajcá bár yehw̃ téyeyra, éyinra as chíwai chácajatro. ");
INSERT INTO tuf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uwat as chihtá cajac ques cahujín yauwáyqueyra. Bíyinatan yauwic cahm as ajcá bár yehw̃ téyeyra, éyinan Sir quin cuacúr itay beya báreyra. Cuatán uwat biyin as chihtá wácati ques yaúyatan, éyinan cuacúr Sir jor etiti ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Bíyinatan ba ajcá ji bécayat, éyinatan as ajcá ji bequir éytaro. Etar cat bíyinatan as ajcá ji bécayat, as áyjaquey ajcá ji bécaro. ");
INSERT INTO tuf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cahujinat Sir chihtá ehcuquib ria cácaro. Sir chihtá ehcúc rehquít ria cácaro. Bíyinatan eta jaw̃ ria cácayatan, Sirat ehcuquib quin tunir eyta, ey quino cat eyta túnayqueyra. Eyta cat cahujinat urá ay bin ria cácaro. Urá ay rehquít ria cácaro. Bíyinatan eta jaw̃ ria cácayatan, Sirat urá ay bin quin tunir eyta ey quino cat eyta túnayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cahujinat as chiwa conu bin quin rih yahn acu wícaro. As chiwa etar eyta wícayatan, Sirat ey quin tan chinti túnayqueyra. Aját eyta uní wacaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesusat chiwa doce bin quin eyta waquír acsar bijacro. Galilea cajc pueblo cuitar Sir chihtá ehcún bijacro. Siw̃in bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan cárcel icar cuar eyat Jesusat yajquey chihtá tew̃íc rahjacro. Eyta rahcuír ima chiwa Jesús quin áyjacro. Jesús quin tayon áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eyta ayat, eyin Jesús quin cur wajacro: —Isan Cristo ey yehníc acor itro, -wajacro-. Is quin ehcuwi. ¿Bahan eyqui? ¿Isan istiy acor ítataica? wajacro, Juan chiwat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wacayat, Jesusat wajacro: —Juan quin ehcwáy béowi. Behmár ub cuitar ítqueyan cucáj cuitar ráhcuiqueyan ey ehcwáy béowi. ");
INSERT INTO tuf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ub bár bin sicor ub ji chaquic itchaquey ehcuwi. Cuercurin sicor tan wan chaquic itchaquey ehcuwi. Uw sura ohnquin sicor orac chaquic itchaquey ehcuwi. Cucáj bár bin cat sicor cucáj ji chaquic itchaquey ehcuwi. Sácajaquin sicor estají chaquic itchaquey ehcuwi. Chihtá ay bi eyan oya bár bin quin, ray bár bin quin ehcuquic ehcuwi. Juan quin eyta ehcuwi. ");
INSERT INTO tuf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Etan rehrinatán as tamo etiti síhw̃ayatan, éyinan tan wan rehcátaro, wajacro. Jesusat Juan chiwa quino eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eyta wacayat Juan chiwa sicor bar béjecro. Juan chiwa bey yiror, Jesusat uw quin wajacro. Juan ojcor uchta wajacro: —Baan ubach bár cuitar Juan quin béjecro. Baan Juan quin icúr sihw̃ar béjectara aját ehcunro. Uch wahitay bétiro. Ecatará séroat bahcabar bahcoquey eyta uw urá cat eyta tehmoro. Eyta cuar Juan urá éytai batro. Eyta bira baat urá tehmó tehm bin wahitín acui bétiro. ");
INSERT INTO tuf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba oyin rayin wahitín acui bétiro. Oyin rayin pueblo cuitar itro. Gobierno úsiro. Ubach bár cuitar ítitiro. ");
INSERT INTO tuf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cuatán icúr wahitín acu béjectara aját ehcunro. Baatán Sir chihtá ehcuquib wahitín sihw̃ar béjecro. Juanan eyro. Juan ojcor aját ba quin wacaro. Sir chihtá ehcuquin cahujín Juan owárai cutiro. ");
INSERT INTO tuf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan ojcor úchicrias uchta cuihsú báhjacro: Aját chihtá ehcúquiban bah ben cahmor ayro. Bah cahmor éyatan ibit óroyqueyra. Bah yehníc cahmor uw quin ur ay chac áyayqueyra. Eyta cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jesusat eyta waquír uchta wajacro: —Aját ba quin wacaro. Cahmor cat ah cat Juan urá ayan uw bahnaquin cuitro. Cuatán yahncutra Sir cara rehquey cutatra urá conu binan chihtán Juan cuít chácayqueyra, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan uw rih sar siw̃quib siw̃in yehníc cuitar cuar ah acat tas Sir cara rehquey uwa abáy ruhw̃uro. Eyta cuar uw tecuas cut Sir cara rehquey ahár siwin yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan anto yehnti cuácayat récaram Sir chihtá ehcúquinat cat, Moisesat cat ey ojcor wac bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Elías yehnata chihtá wac bahjacro. Eyta cuácayat baatán rahcuátatara, aját ba quin wacaro. Juan uw rih sar siw̃quib eyan eyro. ");
INSERT INTO tuf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Biyin cucajá chítara, ey rahcwi, wajacro, uw quino. ");
INSERT INTO tuf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Eyta waquír Jesusat bucoy wajacro: —¿Ah cutar uwa icuran wántara? Aját ehcunro. Eyinan sasán wanro. Sasá rasá cuitar cuehsro. Cuehswa rabar sasát cahujín quin wacaro: ");
INSERT INTO tuf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Isat ahní rehquín acu tirá cuhjacro. Eyta cuhjác cuar, ¿bitara reht ahní chátiqui? Etar isat chein ruhcuír eyta cuehschacro. Eyta cuehsí cuar bara ¿bitara reht conti rehyi? ¿Bitara reht cuécutiqui?” wacaro, sasát cuehswa rabar. Ah acat uw cat éytaro. Sasát cahujín chihtá cut cuehsuti cuar tecuar eyta aha uw cat cahujín chihtá yajti cuar eyta técuaro. ");
INSERT INTO tuf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan rih sar siw̃quib wijacro. Wiquír ira yati bach yajacro. Bacú yahti bacha yajacro. Juanat bacha eyta yajcayat ques baatán ey cahmí icar tew̃ro. Baat wacaro: “Juan ur icar cuicá chero,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cuatán as Uw Síuquibat báchuti ira yácaro. Báchuti bacú yahcaro. Aját eyta báchuti yácayat, baat as cahmí icar cat tew̃ro. Baat wacaro: “Eya atuc sinro. Bacú bunaran cuitro. Eta jaw̃ gobierno tayar chiquin íw̃oro. Urá ay bár bin íw̃oro,” wacaro. Baatán eyta wacaro. Ah cutar uwa sasán wan tecuas sinro, -wajacro, Jesusat uw quino-. Uch síhw̃awi. Bíyinat Sir chihtá uní síhw̃actara, ítchareht éyinat caba síhw̃ajac istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Etar Jesusat bahnaquin cucajá acat pueblo cahujín itquin cahm icar tew̃jacro. Imát pueblo eyin icar Sir ajc cut yarquin cat, cuercurin cat, cuicát ruhw̃uquin cat tan wan chájacro. Eyta cuar pueblo cuitar itquin urá ay bár ey tehmótiro. Sira tamora síhw̃atiro. Etar Jesusat eyin ojcor uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Pueblo Corazín uwan Pueblo Betsaida uwan conú cuac sácayqueyra. Eyinat as chihtá cati cuácayat conú cuac sácayqueyra. Aját yajacan it cuar, as chíhtara ráhctiro. Aját eyin pueblo yarquin tan chájacro. Eyinat eyta itchác cuar, as chíhtara ráhctiro. Aját síw̃jaquey cucáj cuitar rahcuí cuar, urá icar chihtá cátiro. Cuatán Tiro pueblo ítquinra, Sidón pueblo ítquinan ur éytara batro. Aját Tiro cuitaratara Sidón cuitartara im eyta yajaquir waquít, as chihtá síw̃jaquir waquít, éyinra úchicrias ay bár yajquíc etchác ícatro. Ay bár yajác cue rehquít oya ay bár bi chajac ícatro. Oca bur imár sibará cuitar ohjoc ícatro. ");
INSERT INTO tuf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eyta bira cabar tinyat, Corazinat tayar yajác ques Betsaídainat tayar yajác ques Sirat cuít cuécwayqueyra. Cuatán Tiro uwra, Sidón uwra etach cuécwajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Acsar Capernaum pueblo uwa ojcor wajacro: —Capernaum uwat cuáyinir síhw̃aro. Imár úrara Sir quin beyata síhw̃aro. Sir jor cuacúr beyata síhw̃aro. Eyta cuar éytara beya báreyra, -wajacro-. Cuatán éyinra cab oc icar beyáyqueyra. Eyin tasar, Capernaum pueblo cut aját Sir ajc cut uw cuitar yajquír eyta Sodoma pueblo cut eyta yajaquir waquít, Sodomin urá ay bár yajquíc etchác ícatro. Eyta etyat áhajira pueblo ey echí rehcata binro. ");
INSERT INTO tuf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eyta bira cábara tinyat Capernaum pueblo uwan Sirat cuít cuécwayqueyra. Cuatán Sodóminra etach cuécwajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Etar Jesusat Sir ojcor uchta conjacro: —Siru, Tetú, bah urá ayro. Cuacúr abá cuitar, cajcan ican bahnác cuitar bah caran cuitro. Behmá urá cuitar uwa cájacro. Urán ajcan cuít binra cátiro. Cuatán sasá urán wan bin cájacro. Eyta caquir quino behmá chihtá ehcujacro. Bah cara rehquey chihtá bahnác ehcujacro. Urá cuít bin quínora ehcútiro. Cuatán sasá urán wan bin quínorun bahnác ehcujacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Waquír bucoy uw quin wajacro: —Sirat Tetát as at icar bahnác wíjacro. Biyan Sir waquíjtara uwat istiti binro. Rehratí istítiro. Cuatán Tetatrún itro. Eyta cat Tetán rehrtara uw bahnáquinatan istítiro. Cuatán wacjatrán Tetán itro. Ajatrún rehrtara itro. Wacjatán biyin quin ehcwayat, éyinat cat Tetá itro. Sira itro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bíyinan owat séojactara éyinan as quin row̃i. As quin rocayat, aját eyin tan jac áyinro. ");
INSERT INTO tuf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Asan behmár cara chaw̃i. As chihtá sinwi. Asan tecuas batro. Etar baat asan ba cara chácayat, ba ur icar tan wan cháquinro. ");
INSERT INTO tuf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Asan caran chácayat ba cuaca báreyra. As chihtá sinin chauwa táhnaqui batro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Itchareht yájcajareht tan jaquin riy cuanyat, Jesusin ritút ques tiw̃ béjecro. Eyta becayat, Jesús chiwa yayí rehjecro. Yayí rehcayat ritút quehwír cucuá cohjocro. ");
INSERT INTO tuf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eyta cohcayat fariséoinat itchacro. Istír técuajacro. Jesús quin wajacro: —¿Bah chiwat bitara reht eyta quehuca? ¿Bitara reht tan jaquin rícara canár yajqui? ¿Bitara reht bach auqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Etat Jesusat wajacro: —Behmarat cat Sir carit itro. Sir carit cuitar Davidat yajác ojcor wacaro. David cat ima chiwa cat yayí rehjecro. Eyta rehquít ");
INSERT INTO tuf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sir usar raújacro. Rauwir pana Sir ac chájaquey cohjocro. Pan eya sacerdótein imár istir binat cóhtaro. Cahujinat ey cóhjotro. Sir chihtát eyta cohti jaw̃i, wacaro. Eyta cuar éyinatra cohjor bin cohjocro. ");
INSERT INTO tuf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sir carit cuitar sacerdóteinat yajc ojcor cat wacaro. Behmarat ey itro. Sacerdóteinat tan jaquin rícara bach auro. Eyinat bach yajti Sir usi canar yajcaro. Eyta auíc cuar, Sir tayar batro. ");
INSERT INTO tuf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Etar aját ba quin wacaro. Ah uch cab cutar cara istiy yehnjacro. Yehnjaquey ajcan urán Sir úsian tahnacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sirat carit cuitar wacaro: “Baat cahujín cuayin ac ay rehcayat, asan ahnian cuitro. Cuat as tamo sehw̃an ruwa yauyat ahní etach batro,” wacaro. Baat ey chihtá rahjaquir waquít, urá ay bin cahmí icar tew̃ti jácataro. Cuayar tew̃ti jácataro. ");
INSERT INTO tuf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Canar yajti ricar cuitar icúr yajcátatara Sirat as yehn áyjacro. Asa Uw Síuquib eyta waquín yehn áyjacro wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Eyta waquír Jesusin acsar béjecro. Beyar secuac usar raújacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Rauwir ítitan, atcar cuercurin ésatro. Eyta cuácayat fariséoinat Jesús quin táyojocro. Jesusat wajác ques ey cahmí icar tew̃ín sehw̃ar ey quin táyojocro: —Ba quin táyoro. Bachan chihtán chac bahjac cutar baat ítitan: canar yajti ricar ¿yarquey tan jácataica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Táyoyat Jesusat wajacro: —Ba obas istán bin tan jaquin ricar cutar iscán ocso tijcayat, baat sicor bar úcayqueyra. Tan jaquin ricar cuaníc tacat iscán sar báhtiro. ");
INSERT INTO tuf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Behmaray obas ajcá ji rehquít úcaro. Eyta cat uwan ajcán cuít béyataro. Etarwan tan jaquin ricar cutar cat uw obir yajcata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Etar cuercurin quin wajacro: —Bah átcara cuercúr ey yehw̃ tew̃i, wajacro. Eyta wacayat, cuercuran ima átcara yehw̃ tew̃jacro. Eyta yehw̃ tew̃yat átcara orac waajacro. Rahray átcara eyta orac chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eyta cuácayatra, fariséoinat rahra rahra Jesús rioy yinjacro. Jesús yauwin ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eyta ríoyat, Jesús cajc ey cutar bin acsara béjecro. Acsar becayat ricán to binan ey owár béjecro. Beya rabar yárquinan cuercúrinan bahnáquinan tan jacot bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesusat uwa tan chaquir eyin quin wajacro: —Aját bar tan jájaquey cahujín quin ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eta jaw̃ Isaías Sir chihtá ehcúquibat ey ojcor cuihsú bahjacro. Eyta cuihsú bahjáqueya caba yajacro. Isaíasat wajáquinro: ");
INSERT INTO tuf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sirat wacaro. As chiwa cájaquey ojcor wacaro: “Aját ey sehnacro. As ur icar ey rácatro. Ey ur icar cat ajmár Ajcan Cámuran Eya cháquinro. Eyta chácayat eyat cajc istiy cajc istiy uw cucajá acat Sir tayar yajacan ahra tayar bár chaquic chihtá ehcwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eya tecuasí batro. Ajc tecuas cuitar cohwá báreyra. Ubach watar eyat ajc tecuas tew̃a báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eyat emtará quehu biquic bahnác quehuti cuar sicor ay óroyqueyra. Oca tin biquic bahnác tin ayti jácayqueyra. Eytaan wan uwat ur ay yajquít cat bahnác caba yajti bin eyat técuati cuar eyin cuitar wacáyqueyra. Uw bahnáquinat ey chihtá cuitar ur ay yajc ocso eyta yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eyta cuácayat, judío bár binan ey wic acor ítayqueyra,” wacaro, Sirat. ");
INSERT INTO tuf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bécajareht uwat Jesús quin cuicát ruhw̃ujaquey rojocro. Cuicát ruhw̃uyat eya ub batro. Tew̃ic cat téw̃ajatro. Jesús quin rocayat Jesús urá cut sicor tan jájacro. Tan jácayat, ub ji, cuw ji orac chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eyta tan jácayat, uwa bahnaquin ub yehw̃jacro. Etar rahra rahra wajacro: —¿Uyan David bómcara sicar bíntara? ¿Cara áyjaquin éyitara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Eyta wacayat, fariséoinat rahjacro. Eyta rahcuír wajacro: —Cuicá cara ajca Beelzebú urá cut camur cut Jesusat cuicá uc si ayro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Eyta sihw̃ar tew̃jacan Jesusat itchacro. Etar eyin quin wajacro: —Satanasat uw ur icar bin ima Satanás uc tétiro. Bi gobierno wahw̃úr rahra rahra tec quejcayat, ey gobierno bar bahnátaro. Eyta cat puéblotara cáyintara im owár bin rahra rahra tec quejcayat, bar sácataro. ");
INSERT INTO tuf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eyta cat Satanás chiwa bucáy wahw̃uyat rahra rahra tecuay yinyat, Satanás imár owár bahnátaro. ");
INSERT INTO tuf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Cuatán Beelzebú ajc cut ajatrán cuicá uc te siquir waquít, ¿ba chíwatra bi ajc cut uc te sic síhw̃aqui? Baat ítitan, ¿bi chihtá cuitar uc te siqui? Baatán itro. Etar behmár chiwat ba urá wahitáyqueyra. Urá wahitír cahm icar tew̃áyqueyra, -wajacro, Jesusat fariséoin quin-. ");
INSERT INTO tuf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eyta cuar Sir urá cut aját cuicá uc si ayat uch síhw̃awi. Sir cara rehquey ba ubot yehnjác, séhw̃awi, wajacro, Jesúsata. ");
INSERT INTO tuf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Etar acsar wajacro: —Uwat chihchír cuít bíjiya usi bin ohnora bes yajquín síhw̃ayat, récaji cara eyan questátaro. Questati bitách bes yájcajatro. Cuat questár cuitar, bahnác ohbac bes yajcátaro. ");
INSERT INTO tuf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Bíyinan asi jor bártara, éyinra asan quehsuro. Eyta cat bíyinatan as cuitar chihtá ehcuti rehcáyatan, éyinatan uw quin as chihtá cac áytiro. ");
INSERT INTO tuf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Etarwan aját ba quin wacaro. Uwat bitara útara Sir tayar yajcayat, Sirat sicor tayar bár chácataro. Bitara útara ahsín tew̃yat Sirat sicor tew̃ti bin eyta bar chácataro. Cuatán Sir Ajcan Cámuran Ey ojcor ahsín tew̃yat, tayar chi chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bíyatan asan Uw Síuquib cahmí icar ahsín téw̃yatan, eyat Sir tayar yajcaro. Eyta cuar eyta tayar yájcyeyra Sirat sicor tayar bár chácataro. Bíyinatan Sir Ajcan Cámuran Eya ojcor ahsín téw̃yatan, eyta tew̃yat cat Sir tayar yajcaro. Eyta cuar Sirat tayar eyra batra chátiro. Bur cut suw cut tayar chi rehcáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Cárucua ay biyat uba ay bi chácaro. Cárucua ay bár biyat uba ay bár bi chácaro. Cárucua bitara bíjitara istín ac caruc ub wahitro. Eytaan wan aját ay yajác síhw̃actara, Satanás chihtá cuitari, Sisrám chihtá cuitari ey yajác síhw̃ati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¿Bitara rehquít ahsín tew̃qui? Baan cumoroán wanro. Baan ricmán wanro. Eyta rehquít ahsín tew̃ro. Uwa urá bitáratara cuw cuitar cat im eyta tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Urá ay binat urá ay rehquít chihtá ay bi tew̃ro. Urá ay bár binat cat urá ay bár rehquít chihtá ay bár bi tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aját ba quin wacaro. Cábara tinyat uwat tayar yajác ques técuataro. Técuayat, uwat síhw̃ati tew̃jác ques Sirat ajc tecuas cut táyotaro. ");
INSERT INTO tuf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Baat ahsín téw̃titara ba técuati jácayqueyra. Cuatán ahsín tew̃jáctara Sirat ba bar técuayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Itchareht bachan chihtán síw̃quinat cat, fariséoinat cat Jesús quin wajacro: —Síw̃quibu, Sir im istir ajc cut, camur cut yajcata bi is ub acat yajw̃i. Isat Sirat bah ayjac síhw̃ayta acu eyta yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Waquít Jesusat wajacro: —Ah uch cutar uw ur ay batro. Sir tamo síhw̃atiro. Eyta rehquít éyinat Sir urá cut, camur cut bahnác yajcata ehcún acu as quin yajc ayro. Sirat as áyjactara, áytitara istín acu as quin eyta yajc ayro. Eyta yajc ayic cuar aját éytara yájtiro. Eyta yajti cuar, úchicri Sir chihtá ehcuquib Jonasat Sirat ayjac ehcúr eyta, aját cat eyta ehcunro. ");
INSERT INTO tuf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasan rih ruwa cumac bi tan sar bay cuanjacro. Bay cuanyat estají waajacro. Eyta cuaquir eyta asan Uw Síuquib cat ica tan sar bay cuaninro. ");
INSERT INTO tuf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cabar tinyat, Nínive uwat ah uch cutar uw cahm icar tew̃áyqueyra. Ah uch cutar uwat tayar yajác ehcwáyqueyra. Cahmor úchicrias Jonasat eyin quin Sir chihtá ehcujacro. Etar éyinat chihtá cájacro. Urá ay bár ey bar tehmojocro, -wajacro, Jesusat-. Cuatán asan ajcan urán Jonás cuitro. Eyta cuar, aját waquíc ráhctiro. Ah úwatra cátiro. ");
INSERT INTO tuf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Etar úchicrias chaucat yajaquey síhw̃awi. Chauc eyan uwa cara chájaquincuano. Cajc istiy binro. Cajc istiy cut bin Salomón chihtá rahcuay rajacro. Salomón urán cuít etar ey chihtá sinin ac rajacro, -wajacro, Jesusat-. Cuatán asan urá Salomón cuitro. Eyta cuar, ah uch cutar uwat aját waquíc ráhctiro. Eyta bira chauca éyatan uchin cahmí icar tew̃átaro. Cabar tinyat, úchinat tayar yajác ehcwátaro, wajacro, Jesusat fariséoin quin, bachan chihtán siw̃quin quin. ");
INSERT INTO tuf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Waquír car Jesusat bucoy wajacro: —Cuicá uw urá sar bin uquir áyatan, cuicá eyat bi cut ítatatara uroy bicaro. Uw bár cuitar wahitay bicaro. Tan jaquin ac wahitay bicaro, -wajacro-. Eyta cuar bísari ítajatro. Bir cuti tan chácajatro. ");
INSERT INTO tuf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Bísari ítajar rehquít ima ur icar séhw̃aro: “As sicor benro. Asa bírara bin uquir rajáctara as sicor erar rauway benro,” séhw̃aro, -wajacro-. Eyta sehw̃ar bicayat, rajác cut cur itit, uw eyan óhbacro. Ey ur icar istiyí batro. Uw eyan ubach uw bár bin éytaro. Uw eyan ubach uw bár cuar bahnác órojocan wanro. ");
INSERT INTO tuf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Cuicát ay órojoc istír cuicá cahujín ucay bicaro, -wajacro-. Bucoy cuicá cuisa cucuí bin ucay bicaro. Cuatán cuic éyinra técuasan cuít binro. Etar eyin roquír, sera ur icar behquír abáy ruhw̃uro. Récaram táhnaqui ruhw̃útiro. Cuatán bucoy cuitatra cuít ruhw̃uro, -wajacro-. Ah uch cutar uw cat eyta cuít ruhw̃átaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesusat uw quin tew̃yat icar im ab cat, rabin cat watar béjecro. Bequír Jesús jor tew̃ín acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eyta chícayat ser istiyát Jesús quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Eyta ehcwayat Jesusat ser ey quin wajacro: —¿As abinán, rábinan rehrinán éyinca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eyta waquír ima átcara ima chiwa wihara yehw̃ tew̃jacro. Tew̃ír wajacro: —Uyinan as abinán rábinan wanro. ");
INSERT INTO tuf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bíyinatan as Tetá cuacúr bin chihtá ráhcyatan, éyinan as abinán, rábinan as chitinán wanro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eyta waquír ey rícara Jesús usar bin acsar bijacro. Bir, riw cajc cut chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eyta chihryat uwa ricán to bin ey quemir sécuajacro. Eyta sécuayat Jesús canó icar raújacro. Rauwir chihrjacro. Canó ey riw cut chájacro. Eyta cuar uwa bahnaquin riw cajc aw̃at ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eyta cuácayat Jesús riw cut canó cuitar cuaquir uw síw̃jacro. Jesusat chiht istiy, chiht istiy siw̃in acu icúr bi ojcor tew̃jacro. Siw̃in acu uchta wajacro: —Ser istiy cucuá cuiay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cucú eyan at cut cuic cuic cuijacro. Eyta cuicayat, cucú cahují ibit aw̃at tijcajacro. Eyta tijcayat ruwásirat ey yájacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eyta cuijacan, cucú cahují wisu arcút tijcajacro. Tijcayat in bar yehnjacro. Ica ata bár etar in yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yehnyat cat, cunyat cat, ribirát sarac tíw̃jacro. Siya usón bár rehquít tínjacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eyta cuic cuic cuicayat cucuá cahují cachá tac icar tijcajacro. Eyta tijcayat cachá tihw̃án abáy yehnjacro. Cachá tihw̃á abáy yehnyat, cachát sehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eyta cuic cuic cuicayat cucú cahují ican tic bi cuitar tijcajacro. Etar eyra ay yehnjacro. Ehchí yehnjacro. Etar uban ehchí chájacro. Istiy eyran uban cien cuít chájacro. Istiy eyran uban sesenta chájacro. Istiy eyran uban treinta chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Etaran eyta waquír, acsar Jesusat wajacro: —Cucajá ji bínatra ey rahcwa, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Eyta wacayat ey chiwat ey quin wajacro: —Jesusu, bahat uw siw̃in ac uwat yajquíc búcoyan búcoyan ehcuro. ¿Eyta ehcúr cuitar síw̃tieyra, bitáraca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Táyoyat wajacro: —Behmarat Sir cara rehquey chihtá ay rahcuátaro. Cahmor istiti bi rahcuátaro. Cuatán cahujinat ay rahcti acu tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bíyinatan ay ráhcyatan, Sirat eyin cuít síw̃ayqueyra, ay rahjác etar. Etar chihtán cuít sínayqueyra. Cuatán bíyinatan ay rahcti cuácayatan, chihtá conu rahjác ey sicor bar etí téyqueyra. Bar tan chináyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aját eyta sehw̃ar icúr bi ojcor tew̃quey cuitar siw̃ro. Cahujinat ub cuitar istata cuar, ay istiti rehcayta acu eyta siw̃ro. Eyinat cucách cuit rahcuata cuar, ur icar rahcti acu eyta siw̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uchicria Isaías Sir chihtá ehcúquibat wac bahjác ahra uw éyinat yajcaro. Isaíasat uchta wajacro: Baat rahcuír car, cucajá cuitar rahcuí cuar urá cuitra rahcua báreyra. Baat istíc cat, ub cuitar istíc cuar ur cuitatra istá báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uch uwa urá bár rehjecro. Cucáj cuitar cat ráhcuajar rehjecro. Ub cuitar cat ístajar rehjecro. Eyta barir waquít, ub cuitar wahitír istátaro. Cucajá cuitar rahcuír ay rahcuátaro. Urá ji rehquír cácataro. Eyat caquir urá tehmóyqueyra. Eyta tehmoyat, Sirat imár tayar bár chácayta acu conáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Eyta waquír wajacro, ima chiwa quino: —Cahujinra eyta cuar ba ácamra ay rehcaro. Ba uba cuitatra ay itchacro. Ba cucajá cuitatra ay rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aját wacaro. Uchicri Sir chihtá ehcúquinat cat, urá ay binat cat eyta istá racar rehjecro. Ricán to binat it cun rehjecro. Baat itquey istá racar rehjéc cuar etach istítiro. Ba cucáj acat tew̃quey éyinat rahcua racar rehjéc cuar, etach ráhctiro. Cuatán baatrún bar rahjacro. Bar itchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Cucuá cuic cuic cuijác ojcor waquír cuitar bi chihtá síw̃jactara ay rahcwi. ");
INSERT INTO tuf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cucuá ibit aw̃at tijcajaquey wacayat, ibit aw̃at wacayat, uw cahujín ojcor tew̃ro. Uw éyinatan Sir chihtá cucajá cuitar rahcuí cuar, ur ícara cátiro. Rahcyat Sisrámatan chihtá ey quin cac áytiro. Bow̃ cac técaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Cucuá wisu arcút tijcajaquey wacayat, wisu ey wacayat, uw cahujín ojcor tew̃ro. Uw éyinat Sir chihtá rahcro. Rahcuír ahní cácaro. Eyta cuar ayra cátiro. ");
INSERT INTO tuf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ay cati rehquít, ítchareht waca técaro. Sir chihtá ques uwat ruhw̃áyatan, uwat técuayatan, éyinat chihtá waca técaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Cucuá cachá tac icar tijcajaquey wacayat, cachá tac icar wacayat, uw cahujín ojcor tew̃ro. Uw éyinat chihtá rahcuí cuar iran oyan rayan cuít rácatro. Ey racar rehquít Sir chihtá tamo síhw̃ati etí técaro. Urá ay ítitiro. ");
INSERT INTO tuf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Cucuá ica tic bi cuitar tijcár uba cuít cháqueyan wacayat, ica tic bi wacayat, uw cahujín ojcor tew̃ro. Uw éyinat chihtá ay rahcro. Rahcuiran, urá istanác waacaro. Urán ay chácaro. Etar cahujín éyinra urá ayan cuitro. Cahujín éyinra urán etach cutiro. Cahujín eyin cat urá ayan owáraqui batro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusat siw̃in acu uwat yajquíc uchta ehcujacro: —Sir cara rehquey úchtaan wanro. Ser istiy ima chi cuit ritút cucuá ay bi rijacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Eyta ric tihrír sera cat chiwa cat chéycara cuitar usi cámjacro. Chéycara cuitar cami yiror quehsí binat chi ey cuitar tihw̃á ay bár bi cucú cui téjecro. Ritután wan cuar tihw̃ cucú cui téjecro. Tihw̃ cucuá cuiir, cajc istiy bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Itchareht yájcajareht yehnár ritút uba chac rajacro. Ritút yehnjác ítitan, tihw̃á ey catum uba chac racaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ey istír, cacminát cara quin behquir wajacro: “Caru, bahatán cucú ay bi rijacro. Eyta cuar ¿bitara etar tihw̃á cat yehnqui?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wacayat wajacro: “As quehsí binat tihw̃ cucú cuijacro,” wajacro. “¿Bahat icúr rácarica? ¿Isat tihw̃á ey récaji cuachínica?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Batro. Eytara cuachti jaw̃i. Eyta cuáchyeyra, tihw̃ cat ritút cat cuacháyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ritút cat, tihw̃á cat im eyta chaw̃ jaw̃i. Ritút jaw̃, tihw̃á jaw̃ tam rehcáyqueyra. Ehsúc cab cuc ocso tas im eyta chaw̃ jaw̃i. Etar ehsúc cab cucayat, aját ehsuquin quin waquinro: ‘Ibtu tihw̃á cuachwi. Cuachír questawi. Questár oca cut wahnín ac ajquír jaw̃i. Cuat ritutrá ira usi socua cuitar sécuawi,’ waquinro,” wajacro. Jesusat eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Etar Jesusat siw̃in acu uwat yajquíc ojcor uchta ehcujacro: —Sir cara rehquey cutar úchtaan wanro. Bitáratara aját ey ehcunro. Sir cara rehquey cutar mostaza cucuán wanro. Uwat mostaza cucuá chi cuit ricaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cucuá eyan cónuan bahnác cuít bin cuaquir chájareht cuít cunro. Cunyat ectar ji ruwat ey cuicara taha cut chicha tuw̃ro. Sir cara rehquey cat ey cucuán wanro. Mostaza cucuán conu bi cuar yehnár cuít cunir eyta Sir cara rehquey cutar uwa récaji ricá conu cuar ítchareht éytaan wan uwan cuít rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bucoy Jesusat Sir cara rehquey ojcor wajacro: —Sir cara rehquey úchtaan wanro. Buc réhqueyan wanro. Uwat eba tajcro. Tajquír sar buc rehquey conu chácaro. Chaquir rihnoro. Rihnoyat eba bahnác buc rehcaro. Sir cara rehquey cat buc réhqueyan wanro. Buc rehquey conu chaquic cuar ítchareht bahnác buc rehquír eyta Sir cara rehquey cutar uwa récaji ricá conu cuar ítchareht cuít rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusat ricá quin uwat yajquíc ojcor ehcúr cuitar síw̃jacro. Eyta ehcútira síw̃tiro. ");
INSERT INTO tuf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eyta ehcwayat Sir chihtá ehcúquibat wac bahjác caba yajacro. Sir chihtá ehcúquibat úchicrian uchta wac bahjacro. Aját cuw cutar uwat yajquíc ojcor ehcúr cuitar siw̃ro. Récaji cajc cuanjác acat echí ah tas cuar uwat anto istiti bi aját eyta ehcúr cuitar síw̃inro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesusat eyta siw̃ir ricá sicor imár usi áyjacro. Eyta ayir ima cat im usi raújacro. Rauyat ima chiwa cat ey acor behquir wajacro: —Isat orac rahcuayta acu tihw̃á ay bár bi chi cuit rijác chihtá siw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wacayat wajacro: —Rura ay bi riquib asan eyro. As Uw Síuquiban eyro. ");
INSERT INTO tuf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chi eyan cajquey teyey eyan eyro. Rura ay biyan Sir sasán eyro. Tihw̃á ay bár biyan Sisrám chiwan eyro. ");
INSERT INTO tuf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Quehsí binat tihw̃á ay bár bi rijáqueyan Sisrám ey ojcor wacaro. Cuácayat ehsúc cab cuqueyan cábara tinyat eyan eyro. Ehsúquinan Sir cuacúr cacmín éyinan eyro. ");
INSERT INTO tuf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tihw̃á ay bár bi secuar wahnár eyta, cabar tinyat cat im eyta jácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asa Uw Síuquibat cuacúr cacmín cajc uch cutar áyayqueyra. Usár behquír Sir cara rehquey tac icar bin urá ay bár yajáqueyin secuar siáyqueyra. Ay bár yajc áyqueyan bahnác siáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sitrun cab oc icar wahná téyqueyra. Cab oc icar uwan abáy óyqueyra. Yaran abáy rehquít ruhra cuechwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Etar Sir chihtá yajquin éyinan rahs sir éytaan wan rehcáyqueyra. Sir jor Tet chor carin itir eyta ítayqueyra, -wajacro-. Bíyinan cucách chítara, chihtá ey rahcwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Sir cara rehquey úchtaan wanro. Rayan to bin uwat chi cut ruhjacro. Erar ruhcyat ítchareht yájcajareht ruhjaquin sácajacro. Etar ser istiyát chi cut canar yajcayat raya ey itchacro. Istír cat ahní rehquír sicor to ruhjacro. Chi ey cajc ey wahn sehw̃ar ruhjacro. Etar ima ojc sar oyan, cajcan, at ruwan bahnác rajacro. Rar car ray ey secuar cuitar chi ey cajc ey wahjacro. Cajc jaw̃ ray jaw̃ wahjacro. Cajc cut ray ruhjác ey wahn ac icúr bi bahnác yarsa tehmótaro. Eytaan wan Sir cara rehquey cuitar beyin tehmár icuran biyan yarsa bahnác báhtaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Sir cara rehquey úchtaan wanro. Cuc ray, cucáj ray wáquibat perla ehchí bi secuan sehw̃ar bisar bisar yajcot bicaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eyta yajcot bicayat, perla úbisti ehchian to bi itchacro. Cuc rayan ehchian to bi itchacro. Ehchian to rehquít acan tahnacro. Eyta istír ima ojc sar icuran biyan bahnác rajacro. Rar car ey ray cuitar perla ey wahjacro. Cuc raya ey wahjacro. Perla eya Sir cara rehqueyan wanro. Perla echí bi wahn ac icuran biyan bahnác yarsa tehmótaro. Eytaan wan Sir cara rehquey cuitar beyin tehmár icuran biyan bahnác yarsa báhtaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Sir cara rehquey úchtaan wanro. Atarraya cumac biyan wanro. Atarraya yacúr rih sar chácaro. Rih ruwa siin acu chácaro. Eyta chácayat ajc bahnác cácaro. Rih ruw cat, ricúm cat cácaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaquir atarraya ey bahnác cuinyat, uwat yacúr cajc cut uquin ruc rocaro. Yacúr cajc cut cur car rih ruwa ay eyan ajquír ruca sar sécuaro. Cuat ricumra ajquír ab sicaro. ");
INSERT INTO tuf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Cabar tinyat cat im eyta yajcáyqueyra. Uwat rih ruwa ajquír, ricúm ajquír chaquir eyta Sir cuacúr cacminát cat uw cat eyta chácayqueyra. Yajcata bi yajác bin ajquír, urá ay bár bin ajquír chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Eyta chaquir urá ay bár bin cab oc icar wahná téyqueyra. Cab oc icar uwan abáy óyqueyra. Yaran abáy rehquít ruhra cuechwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Eyta waquír Jesusat eyin quin táyojocro: —¿Chihtá eya bahnác bar rahcyi? wajacro. —Ee, bar rahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Etar Jesusat wajacro: —Bachan chihtán síw̃quinat Sir cara rehquey chihtá sínjactara, úchtaan wanro. Ubach cayiban wanro. Ubach cayibat ima cajón tan sar bin ibsoy bi cat, quescarir bi cat úcaro, -wajacro-. Eytaan waan bachan chihtán síw̃quinat Sir cara rehquey cat sinjac etar chihtá yahncút bi cat récaji bi cat síw̃ayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Etar Jesusat uwat yajquíc ojcor ehcúr cuitar siw̃ tihrjacro. Eyta siw̃ tihryat acsar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bir car ima pueblo cut cujacro. Ima pueblo cut cur car, secuac usi siw̃in raújacro. Jesusat siw̃yat, ricá to binat rahjacro. Rahcuír ojc sijacro. Ojc siquir rahra rahra wajacro: —Sera eyat eyta siw̃quey ¿bi cut sínjactara? ¿Bi urá cuitar ub bár bi sicor ub chi chaqui? ¿Bi urá cuitar cuicát ruhw̃ujaquey sicor tan chaqui? ");
INSERT INTO tuf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uya tetá tabla óroquibro. Uy abá Maríaro. Santiago cat, José cat, Judas cat, Simón cat ey rábinro. ");
INSERT INTO tuf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ey chitín usara is owár itro. Eyta etar ¿bi urá cut eyta yajqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eyinat Jesús ria yájtiro. Etar Jesusat eyin quin wajacro: —Uw bahnáquinat Sir chihtá ehcuquib ajcá ji bécaro. Cajc bahnác cutar ítquinat ajcá ji bécaro. Eyta cuaquir ehcuquin imár cajc cut ítquinatra, imár usi ítquinatra ajcá ji bétiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eyta cuácayat Jesusat Sir ajc cutar ricá to binra tan chátiro, uw éyinat ey tamo ay síhw̃ati etar yarquin birách bár bin tan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Itchareht yájcajareht uw bahnáquinat Jesús ojcor tew̃jacro. Uwat tew̃ican rey cara ajca Heródesat rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eyta rahcuír Herodes eyat Jesús ojcor ima chiwa quin wajacro: —Uya Juan Bautístaro. Juan chinjác cuar, sicor estají yehnjacro. Eyta cuácayat ajc cutar, camur cuitar bitara útara ay yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Récaji Juanat Herodes cahmí icar tew̃jáquinro. Heródesat ima raba Felipe wiya ajca Herodías siwir yehw̃jáquinro. Eyta siwir yehw̃jác ques Juanat tew̃jáquinro: “Bahat yéhw̃ajar bi yéhw̃yatan, Sir táyatro,” wajáquinro. Eyta tew̃yat, Heródesat ima butó Herodías racar rehquít, Juan caquin soldádoin áyjaquinro. Cárcel icar tun áyjaquinro. Eyta tunír Juan yau ay cun rehjecro. Eyta rehquíc cuar, uw ayot yaútiro. Uwat Juan itit, Sir chihtá ehcúquibro. Eyta síhw̃ayat, uw ayot yaútiro. ");
INSERT INTO tuf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Itchareht, yájcajareht, Herodes yehnjác rícara cuanyat fiesta yajacro. Gobierno cárina, soldado cárina, Galilea uwa cárina, iran cuít yayín sécuajacro. Etatan Herodías wacjá wiw̃ara rauwir eyin cac cahmar quinjacro. Quinyat Herodes ahní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eyta ahní rehquír Heródesat cahbara quin wajacro: —Bahan ay quinjacro. Bah quinjác tehmár ¿aját bah quin bi wícataca? Ehchí quinjác tehmár bah icúr rácaratara as quin waw̃i. Wacayat aját bah quin wíquinro. Aját Sir ub cahmor wacaro. As quin bahat bi chícayatan, aját ey wíquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eyta wacayat cahbár im abát tan téjecro. Tan te rabar wajacro: —Juan Bautista cuisa chiwi, wajacro. Eyta tan técayat, cahbarat Herodes quin wajacro: —As ac Juan Bautista cuisa cuic ter row̃i. Juan uw rih sar siw̃quib cuisa cuic ter row̃i, -wajacro-. Cuis ey cuiquir baycúr cuitar usár row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Juan Bautista cuisa cuiquin wacayat, Herodes cue rehjecro. Cue rehjéc cuar, uwa ub cahmor, Sir ub cahmor icúr rácaratara, ey wiquin wajáquinro. Eyta chíhtara wítira bitách yájcajatro. Etar eyta roquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Soldado cárcel beyin in áyjacro. Juan cuisa cuiquír roquín áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Etar cuisa cuijacro. Cuiquir baycúr cuitar rojocro. Roquír cahbara quin wíjacro. Etar cahbarat acsar abá quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan Bautista eyta yauyat, ima chiwat ey chein ucay behjecro. Uquir beyar ruhjacro. Ruhcuír car Jesús quin behquir ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan Bautista yaujác tew̃ic rahcuír, Jesús uw bár cuit bijacro. Canó sar rauwir uw bár cuit ajquír bijacro. Jesús uw bár cuit bijác chihtá uwat rahra rahra tew̃jacro. Eyta téw̃ican ricá to binat rahjacro. Rahcuír ey questoc béjecro. Pueblo istiy cut bin uwan, istiy cut bin uwan choni béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús riw cajc cut cur, canó sar bin riw cajc cut waajacro. Waar itit, ácaman ricán to sécuajacro. Eyta istír eyin tamo sehw̃ar cue rehjecro. Eyin tac icar yárqueyin cat tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Itchareht yájcajareht tin bicayat, ima chiwat Jesús quin wajacro: —Isan ubach bár cuitatro. Usatra uw ítitiro. Ahra bar tin bicaro. Eyta bira uwa sicor aywi. Pueblo cut beyin aywi. Imár yayín acu ira wahy aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Etat Jesusat chiwa quin wajacro: —Cajc istiy béyatai batro. Behmarat ira wiw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Etat wajacro: —Icrí wícajatro. Is pan éstacro. Rih ruwa cat bucátanro. Isat icrí wícajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Etatan Jesusat eyin quin wajacro: —Pan cat, rih ruwa cat as quin row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eyta waquír uw quin banar cuitar chihr áyjacro. Etar Jesusat pan esí bi cat, rih ruwa bucáy bi cat at cut yehw̃jacro. Yehw̃ír cuacúr wahitchacro. Pan yehw̃ír, Sir quin “Bah ur ayro,” wajacro. Eyta waquír pan cotchacro. Cotír ima chiwa at icar wíjacro. Uw owár tahw̃ún wíjacro. Wícayat, tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tahw̃uyat bahnáquinat yájacro. Uw bahnáquinat yarsa yájacro. Yaya tihryat, ira cájcaran sicor sécuajacro. Sécuajaquey chocha doce ehnchacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Serin ira yájaqueyinan saw̃ujacan cinco milro. Wiw̃ín cat, sasá cat saw̃uti sérina saw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Etar Jesusat ima chiwa quin wajacro: —Canó cuitara riw rahray as cahmor béowa, wajacro. Eyta waquiran, uw bahnaquin quin “As bar bicaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eyta waquír Sir ojcor conín acu cúbara cuitar im istir bijacro. Itchareht cónajareht tino cuitar im ístitro. ");
INSERT INTO tuf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cuat canó riw úbutro. Riw ubut cuar, canó biquic acam wihár séroan bitác bitiro. Riw cat ay bár soboro. Séroat canoan rahr owár bujacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Eyta cuácayat sisbúr cohwyat Jesús eyin ques caquin rajacro. Ica cuitar sahu sahu bir eyta, Jesús rih arcutar eyta sahu sahu rajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eyta racayat ima chiwat itchacro. Rih arcutar raquíc itchacro. Eyta istír ojc sijacro. Abáy roojocro. Eyta roor car cohwjacro. —¡Chein ajca racaro! cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Eyta cohwyat, Jesusat eyin quin wajacro: —Rooti jaw̃i. Ojc siti jaw̃i. Asro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wacayat Pédroat wajacro: —Caru, uní báhtara, as quin rih arcút bah quin bi aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Raw̃i, wajacro. Wacayat Pedro canó sar bin waajacro. Waar, rih arcutar sahu sahu bijacro, Jesús quin cuwayta. ");
INSERT INTO tuf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Rih arcutar be rabar ítitan séroan abáy cacaro. Eyta istír roojocro. Roocayat, riw icar bahr bijacro. Bahr bicayat cohwjacro: —¡Caru! ¡As uw̃i! wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Cab rehti Jesusat at cut Pedro yehw̃ cájacro. Yehw̃ caquir wajacro: —Bah urá cónuro. Aját bah síwata séhw̃ata bin yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Etar eyin owár canó sar raújacro. Jesús canó sar rauyat owár, séroan cab rehti chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Etar canó sar éyinat ey tamo síhw̃ajacro. Ey quin wajacro: —Uniro. Bahan Sir waquijró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Acsar canó cuitar béjecro. Genesaret cajc cut cujacro. ");
INSERT INTO tuf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Erar cucayat, uwat ítitan, eyan Jesusro. Eyta istír cajc bahnác ey cuitar Jesús wijác chihtá áyjacro. Eyta ayi cut yarquin bahnaquin rojocro. ");
INSERT INTO tuf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Roquír Jesús quin conjacro: —¿Bah oya bután ajc waátaica? wajacro. Etar bíyinat butajáctara, eyin bar tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Etar fariséoin cat, bachan chihtán siw̃quin cat Jesús quino béhjecro. Pueblo Jerusalén bin béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ey quin cur wajacro: —Baha chiwat werjayát bacha chajac auro. ¿Bitara rehquitca? ¿Bitara rehquít at um sucti ira yaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eyta wacayat Jesusat wajacro: —Behmarat werjáy chihtá yajquín sihw̃ar, Sir chihtá cati ruhw̃uro. ¿Bitara rehtqui? ");
INSERT INTO tuf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uch síhw̃awi. Síratra wajacro: “Bah tetín ajcá ji béowi. Bah abín ajcá ji béowi. Bíyatan ima tet cahm icar, ima ab cahm icar ajc ahsín téw̃yatan, eyta tew̃ic ques icar yauwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Eyta cuar ba fariséoinat ba bachan chihtán síw̃quinat wacaro: “Bíyinat uchta wacayat, ‘Tetú, Abú, aját bah wícata bin, Sir quin wiquin yajc chájacro,’ wacayat, baat waquít, eyin tetín abín ajcá ji bétitara bitarach batro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Etarwan behmár chihtá yajc ayin acu uw quin Sir ima chihtá tehmó ayro. ");
INSERT INTO tuf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ba urá bucáy binro. Isaías úchicria Sira chihtá ehcúquibat ba urá bucáy bin ojcor waquír cuihsujacro. Uchta úchicri uní bi cuihsujacro: ");
INSERT INTO tuf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Uch uwat cuw cutaran “Sira ur ayro,” wacaro. Eyta cuara urá ícatra Sira tamo síhw̃ati itro. ");
INSERT INTO tuf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eyinat Sir tamo sihw̃an waquíc cuaquir batro. Cahujín quin Sir chihtá siw̃ic waquíc cuar, uw imár chihtá siw̃ro. Jesusat fariséoin quin, bachan chihtán siw̃quin quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eyta waquír uw secuan acu chíjacro. Eyta chiír eyin quin wajacro: —Uch rahcwi. Rahcuír caw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Uwat cac icar yaquey cuitatrum urá ay batra rehca báreyra. Cuat uwat cac icar bin tew̃quey cuitatrun urá ay bár chácaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Etat ima chiwat ey quin behquír wajacro: —Bahat wajác ques fariséoin túrjacro. ¿Eyinat bah rúhw̃ajaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Etat Jesusat chiwa quin wajacro: —Uw éyinan caruc yehnjacan wanro. Cárucuan biyan cuacúr as Tetát riti cuar, im istir yehnjáctara, cárucua eyan burbar cuacháyqueyra. Eytaan wan uw éyinat cat imár chihtá uw quin yajc ayjac rehquít, cab oc icar téyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Eyin ria cati jaw̃i. Ub bár biyat istiy ub bár bi beyar eyta, éyinat cat eyta Sir chihtá istiti cuar, cahujín quin siw̃in wacaro. Ub bár biyat istiy ub bár bi ator bécayat, imár buc owár iscán icar yau sácayqueyra. Eytaan wan eyin cat, chiwa cat cab oc icar téyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Etat Pédroat wajacro: —Bahat ehcujác chihtá is quin siw̃i, isat orac rahcuayta acu. ");
INSERT INTO tuf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Etat Jesusat wajacro: —¿Ba cat urá barqui? ");
INSERT INTO tuf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Uwat cac icar icúr yáctara atuc cut tiw̃ bucchír cut tiw̃ bicaro. Etar wisir sícaro. Urá sehw̃a cutra rauwa báreyra. Baat eyta sínata bin yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cuatán uwat cac icar bin bitara tew̃íctara urá sar bin im eyta sihw̃ar tew̃ro. Etarwan uwat ay bár tew̃yat, ima urá ay bár rehcaro. ");
INSERT INTO tuf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Uwat urá sar ay bár síhw̃aro. Eyta ay bár sihw̃ar car, uwa yauro. Wiw̃á jor besir yajcaro. Yehw̃ti isár yajcaro. Cahujín ohnor bes yajcaro. Carin cac cahmar cahujín cahmí icar sucuar tew̃ro. Cahujín ojcor téw̃ajar bin tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eyta yajcayat Sir ub cahmar tayar yajcaro. Urá ruhw̃uro. Cuat atum sucti cuácayat bitarach batro. Atum sucti cuat, ur icar ruhw̃á báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Etar Jesús erar bin acsar bijacro. Tiro cajc cut, Sidón cajc cut cun bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Erar cucayat, wiw̃arac Jesús quin rajacro. Canaán uw Tiro cajc cut bin wiw̃arac rajacro. Wiquír cohwjacro: —¡Caru, David wihnú! As racar cue rehw̃i. As wacjá cahbara bin cuicát ruhw̃uro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Waquít Jesusat ey quin ténatiro. Cuat chiwat Jesús quin wajacro: —Eyat is cut seo cohwro. Sicor im usi aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eyta wacayat, Jesusat wiw̃ ey quin wajacro: —As israelin quin siw̃in áyjacro. Eyinan Sir sasá cuar ey chihtá íujacro. Eyta cuácayat israélina síw̃inro. Cuat cahujinra síw̃tiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Etat wajacro: —Caru, as cuitar waw̃i. As obir yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Etat Jesusat wajacro: —Pan sasát cohtá binan siwir bayar quin wícajatro, -wajacro-. Sasáy bin bayar quin witi eyta, aját Israel ac ay yajcata bi cahujín ac ey yajcátai batro. Aját bah uw cuitar yajcátai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Ee. Eyta cuaquir bayar cayibat pan cohcayat, pan cac bura ic icar tijcaro. Eyta tijcayat báyarat yehw̃ír cohcaro, -wajacro-. Eyta chihtara as cuitar conu yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Etatan Jesusat ey quin wajacro: —Chaucu. Ba urá icar sehw̃at, aját bah cuitar yajcata, séhw̃aro. Bahat eyta sehw̃ac etar, aját bah cuitar yajquinro, wajacro. Eyta wacayat owár Jesús cajc istiy cuar im urá cut ey cahbara tan wan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Etar Jesús erar bin acsar rajacro. Galilea riw cajc aw̃at rajacro. Raquiran cúbara icar wiquír ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Eyta ityat ricá to binan ey quemir sécuajacro. Uw éyinat cuercurin cat, chohcuín cat, ub bár bin cat, ajc bár bin cat rojocro. Cahujín yarquin rojocro. Roquír, Jesús quescara ojcor chájacro. Eyta chácayat, Jesusat istiy cat, istiy cat, istiy cat bahnáquinan ima urá cut tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jesusat urá cut tan jácayat, bahnaquin ub yehw̃jacro. Eyinat ítitan, ajc bár bínatan Jesús urá cut sicor ajc chi tew̃ro. Cuercurin Jesús urá cut sicor óracro. Quescara bár bin chohcuinán Jesús urá cut sicor ques cut sahu sahu bicaro. Ub bár bínatan Jesús urá cut ub cuitar wahitro. Eyta istír Jesús tamo ay síhw̃ajacro. Ub yehw̃jacro. Uw éyinat wajacro: —Israelin Siran ajcan urán tahnacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Uwa eyta sécuayat, Jesusat ima chiwa chíjacro. Chiír eyin quin wajacro: —Aját uw ricá cuitar séhw̃aro. Eyin is owár bay cuanjacro. Ahra éyinat icúr yáyajatro. Aját eyin ira yati sicor usi ay cun batro. Eyta áyeyra, yayat bar sácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Etat ima chiwat wajacro: —Usár ubach batro. Uwa ítitiro. Uwat yayín acu icrí pan bísari ístajatro. Batro. Ricán to rehquít, bi wícajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Etat Jesusat ima chiwa quin wajacro: —¿Baan pana bítaca? wajacro. —Pana cucuiro. Rih ruwa cat birách batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eyta wacayat Jesusat uw ricá quin ica sar chihr áyjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Etar Jesusat pan cucuí eyan, ruw eyan caquir wajacro: —Siru, bahat is ira wícaro. Bah ur ayro, wajacro. Eyta waquír, pana cotchacro. Cotír car, uw quin tahw̃ún ima chiwa at icar tahw̃ujacro. Etar chiwat acsar uwa bahnaquin quin tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Etar bahnáquinat yarís cohjocro. Cohr car yayar car ira cajcar ey sicor sécuajacro. Ira cajcar sécuajacan chocha cucuí binan cuin tas sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ira cóhjoquin saw̃ujacan serin cuatro mílcuano. Wiw̃ín cat, sasá cat saw̃útiro. ");
INSERT INTO tuf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Etar Jesusat uwan sicor usi áyjacro. Ayir ima chiwa owár canó cuitar rauwir, cajca Magdala cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Riy istiy fariséoin saducéoin Jesús quin béjecro. Jesús quin cur wajacro: —Is cac cahmar Sir urá cut, camur cut bahnác yajcata ehcún acu ey yajw̃i. Isat cuacúr Sir imát bah ayjac chihtá istayta acu eyta yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Etat Jesusat wajacro: —Rahs bar rau bicayat, baat waquít: “Abá buwáy tin bicaro. Etatan cuanmít ay cuanátaro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chícrias cuitar cat “Abá buwáy cuan racaro,” wacaro. “Bowarám cat abayro. Etarwan riwa áyataro,” wacaro. Baatán bowarám cat, sero cat ub cut istír, riwa áyatatara, riwa áyajartara, sihw̃ar itro. Baatán eyta itro. Cuat asa rehrát áyjactara istín acu urá batro. Baat Sir chihtá récaji ehcú bahjác itro. Ah cat Juan rih sar siw̃quibat yajác cat, aját yajquíc cat itro. Eyta ub cuitar istíc cuar, Sirat as ayjac síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ba ur ay bár binro. Sir tamo síhw̃atiro. Baat Sir urá cut, camur cut bahnác yajcata ehcún ac as quin yajc ayro. Sirat áyjactara, Sirat áytitara, istín acu as quin eyta yajc ayro. Eyta yajc ayic cuar, aját éytara yájtiro. Eyta yajti cuar úchicri Jonasat Sirat ayjac ehcúr eyta aját cat eyta ehcunro. Eyta yajquír cuitar Sir ajcan urán istáyqueyra, wajacro. Eyta waquír eyin cham bahr car acsar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Etar Jesús chiwa owár riw rahray béjecro. Rahray cur itit, pana beti tan chinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eyta cuácayat Jesusat eyin quin wajacro: —Yají chaw̃i. Cuaya sinti jaw̃i. Fariséoin saducéoin buc réhquiban bútati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eyta wacayat chiwat rahra rahra wajacro: —Isat pan roti etar, eyta wacaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Eyta rahra rahra tew̃yat, Jesusat itchacro. Eyta istír wajacro: —Uwinu, ba urá conu binro. Baat sihw̃at, ¿ajmár urá cut yarsa yayina wícajarca? ¿Bitara reht pan bahjac ojcor rahra rahra tew̃qui? ");
INSERT INTO tuf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ba ur icar anto istítica? Pan estác cuar, aját serin cuisa cinco mil yarís yayayta acu wíjacro. Eyta wícayat ira cájcara chocha bita bin cuinjáctara, ey chihtá síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bucoy cat pana cucuí etan cuar, aját serin cuisa cuatro mil yarís yayayta acu wíjacro. Eyta wícayat baat chocha bita bin cuinjáctara, ey chihtá síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bitara reht as chihtá orac ráhctiqui? Aját pan ójcotra wátiro. Fariséoin saducéoin buc réhquiban bútati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eyta wacayat, bow̃ yajquitan, Jesusat pana buc réhquiban ójcotra wátiro. Cuat fariséoinat saducéoinat siw̃quey ojcor wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Itchareht bécajareht, Jesusin Cesarea de Filipo cajc cut cujacro. Ey cajc cut cur car Jesusat ima chiwa quin táyojocro: —Uwat waquít, ¿Asa Uw Síuquiban rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Etat éyinat wajacro: —Cahujinat waquít, bahan Juan uw rih sar siw̃quíb yarjáqueyro. Cahujinat waquít, bahan úchicri Elías bijaquin sicor wijacro. Cahujinat waquít bahan Jeremías yarjaquey óraro. Uchicrias Sir chihtá ehcuquib yarjác istiy óraro. ");
INSERT INTO tuf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Etar eyin quin wajacro: —Baat waquitra, ¿asan rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Eyta táyoyat Pédroat wajacro: —Bahan Crístoro. Cuacúr Sir ima waquijró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Etar Jesusat ey quin wajacro: —Simonu, Jonás wacjú, bah ahní itro. Behmá urá cuitari eyta séhw̃atiro. Cahujínati ehcútiro. Cuat ajmár Tetá cuacúr binat bah urá icar chihtá ey wíjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ajatán bah quino wacaro. Bah ajcan Pédroro. Ajcan Pedro waquitra, aca ojcor wacaro. Is uwat ac arcutar ubach tuw̃ír eyta, bah chihtá cuitar cat uwa quir bin eyta as chiwa yináyqueyra. Yinír chiwa cahujín owár rehcáyqueyra. Aját eyta rehc áyinro, -wajacro-. Eyta yinyat Sisráminat eyin cuaca báreyra. ");
INSERT INTO tuf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aját Sir cara rehquey cuitar bahan cara yehn áyinro. Eyta cuácayat cajc uch cut bahat icúr yajquín ajc waátitara, cuacúr cat ajc waa báreyra. Cajc uch cut bahat icúr yajquín ajc waátatara, cuacúr cat im eyta ajc waáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Etar chiwa bahnaquin quin wajacro: —Istiy quinoi as ojcor ehcuti jaw̃i. Asan Cristo cuar ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Etar yahncút Jesusat ima chiwa quin bucoy uchta wajacro: —Asa Jerusalén bétaro. Erar cucayat judío werjayinatán, sacerdote cárinatan, bachan chihtán síw̃quinatan as ruhw̃áyqueyra. Ruhw̃úr as yauwáyqueyra. As yauyat bay cuanyat sicor estají yehninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eyta wacayat Pédroat ey ajquír beyar wajacro: —Batro, batro. Baha eyta cuaca báreyra, -wajacro-. Eytara tew̃ti jaw̃i. Bah eyta cuácyeyra, ay batro. Sirat eyta yajc ayti bah síwayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Etat Jesusat Pedro quin wajacro: —Baha Satanás uritro. Bahat as quin Sir chihtá yajc ayti síwata yajcaro. Eytara síuti jaw̃i. Eytara tew̃ti jaw̃i. Bahat eyta tew̃yat uw chihtá cuitar tew̃ro. Sir chihtá cuitatra éytara téw̃ajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Etat chiwa quin wajacro: —Bíyinan as chiwa yin cúntara, imár chíhtara síhw̃ati jácataro. Imár chihtá cut yajti cuar as chihtá yajcátaro. As chiwa cháqueyin as ques icar uwat yauwata óraro. Biyin as ques icar eyta yauwata tacat as wácati ajcá ji bécayat, eyin as chiwa chácataro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Cahujinat imár yauwic cahmar roocayat, as chihtá cácajar óraro. Bíyinatan eyta cati cuácayatan, eyin sácataro. As ajc rahcti reht sácataro. Cuatán as chihtá ques uwat cahujín yauwata óraro. Bíyinan as chihtá ques yaúyatan, aját eyin síwayqueyra. Síuyat eyin Sir jor cuacúr ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Uw cahujinat raya cat, oya cat, cajca cat cuít sécuata óraro. Eyta secua cuar, im eyta cab oca icar beta óraro. Eyta bécayat ¿bahnác chíw̃ajaca? Raya cat, oya cat, cajca cat chiw̃ro. Ima ajca cat chiw̃ro. Eyta cuácayat ray cat, oya cat, cajc cat icúr acui batro. Ey cuitar ba síwajatro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","As Uw Síuquiban cuacúr bin sicor wiquinro. Cuacúr cacmín owár behquinro. Sir as Tetáy wan beo beo tan cut wiquinro. Eyta wiquír car uw istiyát, uw istiyát bitara yajáctara túnayqueyra. Ay bár yajáctara, técuayqueyra. Cuat ur ay yájaquin cuitar wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aját ba quin wacaro. Asan Uw Síuquib ajmár cara yehníc ocso tas usár itquin cahujín sácati ítayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Etar teray cuanyat, Jesusin cubar icar béjecro. Pedro cat, Juan cat, Santiago cat béjecro. Etan béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Erar cur Jesús arjacro. Aryat acan rahsi sir éytaro. Oya cuasáy wan beo beo chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ey acat úchicrias cohtín Moisés cat, Elías cat waajacro. Waar car Jesús jor tew̃jacro. Rahra rahra tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eyta tew̃yat Pédroat Jesús quin wajacro: —Werjayú, isan usaran yarisro. Bahat rácartara, aját chohcha bay tuw̃inro. Istiy bah acu, istiy Moisés acu, istiy Elías acu tuw̃inro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eyta wacayat icar, bowaramát eyin ehyó cay tunjacro. Eyta cuácayat, bowarám tan sar Sirat wajacro: —Uchan as waquijró. Aját eyan sehnacan cuitro. Eyan as ac ayan cuitro. Ey ajc rahcwi. Ey chihtá caw̃i, wajacro Sirat. ");
INSERT INTO tuf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eyta wacayat Pédroin cabatao bahu chájacro. Ojc siquir cabatao bahu béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eyta cuácayat Jesusat eyin butajacro. Butar wajacro: —Cui yinwi. Ojc siti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eyta wacayat Pédroin yinír itit, cahujinra batro. Jesús im ístitro. ");
INSERT INTO tuf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Etar isu wihár sicor béjecro. Beya rabar, Jesusat eyin quin wajacro: —Baat cubar icar itcháqueyan ehcuti jaw̃i. As chinír sicor yehníc ocso tas cahujín quin ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Etat éyinat Jesús quin wajacro: —Bachan chihtán síw̃quinat wacaro: “Cristo yehnín cahmoran Elíasan ibtu wicátaro,” wacaro. ¿Icrát eyta waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Etat Jesusat wajacro: —Uní wacaro. Elías ibtu wicátaro. Cristo wiquín cahmor bahnác oron wicátaro. ");
INSERT INTO tuf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Cuatán aját ba quin wacaro. Elías bar wijacro. Eyta wijác cuar, uwat rehrtara istítiro. Istiti rehquít, éyinat ruhw̃ú cun rehquít ey ruhw̃ujacro. Ey ruhw̃úr eyta as Uw Síuquib cat eyta abáy ruhw̃áyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eyta wacayat, chiwat rahcuít, Juan Bautista ojcor wacaro. Juan uw rih sar siw̃quib ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eyin isur behquir itit, uw ricán to sécuajacro. Behcayat ser istiy Jesús acam bijacro. Bir cuscar cuitar chihrír wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Caru, as wacjá obir yajw̃i. As wacjá bucoy cat bucoy cat chinata enro. Cac sar orjir waacaro. Búcoyan búcoyan eyta enro. Búcoyan búcoyan oc icar cat, rih sar cat, yau yatro. ");
INSERT INTO tuf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aját ey ba chiwa quin rojocro. Eyinat as wacjá tan jácata sehw̃ar rojocro. Eyta sehw̃ar roquít cat, éyinat tan chátiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eyta wacayat Jesusat wajacro: —Ah cutar uwat Sir tamo síhw̃atiro. Chihtá uní bi tehmoro. As ba owár úchicri ítchacro. ¿As chihtá cuitar yajcata bin baat bitat sinin yajca? Baat sinti cuácayat, ¿aját caban bita síw̃ataca? -wajacro-. Bah wacjá usar as quin row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eyta wacayat ser eyat ima wacjá rojocro. Roquír Jesusat cuicá quin tec ajc cut wajacro: —Cuicú, sah ey urá sar bin yehnár biwi, wajacro. Eyta wacayat, cuicá sah ey tan sar bin Jesús chihtá cut wa bijacro. Etar sah cab rehti bar tan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yájcajareht, Jesusan ima chiwa owár imara becayat éyinat Jesús quin táyojocro: —¿Icrát isat cuicá ey úcajar rehyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Etat Jesusat eyin quin wajacro: —Baat Sirat bar ucata síhw̃ati rehquít, úcajar rehjecro. Aját ba quin wacaro. Mostaza cucuá conu cuar, cúmacan cuít cunro. Baat cat Sir tamo conu eyta síhw̃ayat, Sir quin chícayat tehmár cuít yajcátaro. Rirar quin baat wacayat, “Rirarú, usár bin yehnár cajc istiy béowi,” wacayat, rirará yehnár béyqueyra, -wajacro-. Sir chihtá cut baat bahnác yajcátaro. Yájcajatrun bi batro. ");
INSERT INTO tuf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Cuicá eyta bin Sir ojcor conár cuitar ira yati bach yajquír cuitar, uc teta binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yájcajareht, bécajareht sicor Galilea cajc cut sécuajacro. Eyta sécuayat Jesusat ima chiwa quin wajacro: —Asan Uw Síuquib cahujín at icar wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eyta wícayat, éyinat as bar yauwáyqueyra. Yauyat bay cuanyat sicor estají yehninro, wajacro. Eyta wacayat im chiwa ur icar cue rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Eyinan acsar Capernaum pueblo béhjecro. Behquir Sir usi tayar chíquinat Pedro quin cur wajacro: —Judío uwa istiyát cat, istiyát cat, Sir ubach oron ac raya bitác istiy túnata binro. ¿Ba síw̃quibat túntiqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Etat Pédroat wajacro: —Eyat túntira yátiro, wajacro. Etar Pedro awan usi bijacro. Usi cucayat Jesusat ey quin wajacro: —Simonu, bahat ítitan, ¿cajc uch cutar cárinat rehr quin tayar chiqui? ¿Rehr quin impuesto raya chiqui? ¿Imár sasá quin chiqui? ¿Cahujín quin chiqui? Bahat ítitan, ¿rehr quin chiqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Cahujín quin chícaro, wajacro. Etat Jesusat wajacro: —Etarwan imár sasát túnatai batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Eyta cuar isat uw tec chi cun batro. Eyta cuácayat bah riw cut biwi. Ruwa yajquíc sícari tewi. Rih ruwa récaji uquey cac sar wahítuwi. Ey cac sar ray istiy istáyqueyra. Ray eya cuitar bah tayar cat, as tayar cat tunwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Etat icar ima chiwat Jesús quin wajacro: —¿Sir cara rehquey cuitar is sicar rehrán caran cuít chácataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eyta wacayat, Jesusat sah istiy ima quin chíjacro. Sah ey wicayat, Jesusat imár tac icar chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Chaquir eyin quin wajacro: —Aját ba quin uní wacaro. Ba urá tehmowi. Sasá urán wan chaw̃i. Sasá urán wan chátieyra, ¿Sir cara cuitar baan rauw ayti síwajaqui? ");
INSERT INTO tuf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bíyatan ima tamo cuít séhw̃ati chácayatan, bíyatan sah uch ur eyta chácayatan, eyan Sir cara rehquey cuitar caran cuít chácataro. ");
INSERT INTO tuf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bíyinat as chiwa chajac rehquít, sah uchta bi ajcá ji bécayat, éyinat as cat ajcá ji bécaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Sasá cahujín conu cuar as tamo ay síhw̃aro. Bíyinatan sasá eyin quin Sir tayar yajc áyatan, eyin acu ay baran tahnác rehcátaro. Eyan anto tayar yajc ayti cuat, chinjaquir waquít yársaro. Imát sasá quin tayar yajc ayti yacúr ocso tijcaquir waquít ay baran etach batro. Anab ub tayar yajc ayquib ima cucú ques acat questár car riw ocso tijcaquir waquít ay baran etach batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Cajc uch cut itquin conú cuac sácayqueyra. Uw quin Sir tayar yajc áyata rehcayat cuero. Cahujinat uw quin Sir tayar yajc áyayqueyra. Eyta cuar rehrát eyta yajc áyictara, ey conú cuac sácayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ba at cut Sir tayar yajcata óraro. Ques cut Sir tayar yajcata óraro. At cut táyara yajcata rehquíctara átcara cuijaquir eyta jaw̃i. Ques cut táyara yajcata rehquíctara quescara cuijaquir eyta jaw̃i. Tayar yajti acu eyta jaw̃i. Cuercuran wan, átcara bár binan wan Sir jor cuacúr ítyatan ayro. Quescara bár binan wan cuar, Sir jor cuacúr ítyatan ayro. Cuat orac cuar, cab oc icar técayatan ay batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ba ub istiy cut wahitír cuitar Sir tayar yajcata óraro. Ub istiy ey cut táyara yajcata rehquíctara, ub ey újaquir eyta jaw̃i. Uquir te sijaquir eyta jaw̃i. Tayar yajti acu eyta jaw̃i. Ub istanác bin, cuercuran wan cuar, Sir jor cuacúr ítyatan ayro. Cuat ub bucáy orac bi cuar, cab oc icar técayat ay batro, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Sasá uchta bin tamo cuayin síhw̃ati jaw̃i. ¿Sirat ba técuajaqui? Aját ba quin uní wacaro. Sir cacminát sasá uch obir yájquinan cuacúr Sir jor, as Tet jor rehquít eyin cuitar wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Asa Uw Síuquibat uw íujaquin siway wijacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Uch síhw̃awi. Sera obas cuisa cienro. Obas bequit istiy sicar bin cuis istanác íujacro. Serat obas ey uroy bicaro. Obas cahují cúbara icar cham bahr íujaquey uroy bicaro. ");
INSERT INTO tuf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eyta uroy bir obas íujaquey ityat ahnian cuít rehcaro. Obas cahují íuti eyin ityat ahní etach batro. ");
INSERT INTO tuf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cuacúr as Sira Tetá cat urá éytaro. Sasá uchta bi cuis istanaqui iu cun batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Bah rabat bah ac ay bár yajcayat, ey quin biwi. Ey quin ajc uní cuitar waw̃i. Bahat rab im istir yehw̃ chiír tew̃i. Eyta tew̃yat rahcuata óraro. Eyta ráhcuayat ey jor sicor íw̃oyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cuatán eyat bah ria rahcti rehcayat, bah owár cahujín cat béowi. Cuis ístiytara, bucáytara, béowi, rab quin. Eyin owár becayat, cuisa bucayin, bayin éyinat rabat waquíc ey rahcuáyqueyra. Cuisa bucáy bay binat rahcyat, cahujinat uní síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cuisa bucáy, bay binat ajc uní cuitar waquí cuar rabat rahcti cuácayatra, Jesús chiwa owár bin quin rabat tayar yajác ehcuwi. Etar owár binat ey quin ajc uní cuitar wacáyqueyra. Eyta wacayat eyat owár bin chihtá ráhctitara, ey quin ténati jaw̃i. Judío bár bin quino ténati eyta rab ey quino cat eyta ténati jaw̃i. Roma gobierno tayar chiquib quino ténati rehquír eyta, rab ey quino cat eyta ténati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Aját ba quin uní wacaro. Uwa cajc uch cut icúr yajcata cuat baat ajc waati jácayatan, cuacúr abá cut Sirat cat im eyta ajc waa báreyra. Cuat icúr yajquín ajc waáctara, cuacúr abá cut Sirat cat im eyta yajquín ajc waáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bucoy cat ba quin wacaro. Ba cuisa bucáy binat tan owár chaquir, Sir ojcor ajc istán cut conyat, cuacúr as Tetát ajc ey rahcuáyqueyra. Rahcuír eyin cuitar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","As chiwa cuisa bucátantara bátantara bísara sécuayat, as cat eyin owár cháquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Eyta wacayat, Pédroat ey acat wajacro: —Caru, as rabat as búcoyan búcoyan tayar yajcayat, ¿aját sicor icar bita ténata binca? ¿Icara siete ténata binca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eyta táyoyat, Jesusat wajacro: —Icara cucuí étani batro. Cuat icar setenta por siete, icar cuatro cientos noventa sicor ténata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Eyta waquír Jesusat acsar wajacro: —Sir cara rehquey úchtaan wanro. Cara reyat ima cacmín cat, chiwa cat tayar bítatara istín ac saw̃ún séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eyta saw̃uyat cacúm istiy ey chíjacro. Cacúm eyat cara quin túnata táyaran cuántiro. Cacúm eyat millones de pesos táyatro. Rayan saw̃u báhnajar bi táyatro. ");
INSERT INTO tuf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tayar ey bitách túnajatro. Eyta túnajar rehquít, carat ey tayar ques cacúm ey cahujín quin ran wajacro. Ey ima cat, ey wiya cat, sasá cat, oya cat, cajca cat ran wajacro. Tayar ques eyta ran wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Eyta wacayat, cacúm eyat cara cac cahmar cuscar cuitar chihrjacro. Eyta chihrír cue rehquír abáy conjacro: “Caru, as cuáyaro. As obir yajw̃i. Ray tehmár as rati jaw̃i. Aját semar bah quin bahnác túninro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eyta wacayat, carat ey racar cue rehjecro. Eyta rehquír cahujín quin ran bin síujacro. Tayar ey cat sicor tayar bár chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Etatra cacúm ey acsar bijacro. Sicor usi be rabar ser istiy itchacro. Ser eyat cacúm ey quin táyara doscientos pésosro. Eyta cuar cacmát ser ey tayar ques técuajacro. Turir car cucuá cat caquir ahnujacro. “As tayar tunwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eyta wacayat ser eya cacúm ey cac cahmar cúscara cuitar chihrjacro. Chihrír ey quin wajacro: “Récaji as técuati jaw̃i. Aját bah tayar bar túninro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Eyta wacayat cat ria cátiro. Ria cati cuar, ser eya cárcel icar tun áyjacro. “Tayar bahnác tun tihric acat tas cárcel icar chaw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cárcel icar chácayat, chiwa cahujinat cacmát eyta yajquíc itchacro. Eyta istír cue rehjecro. Etar cara quin ehcwáy béjecro. Ser istiyá ey owár técuajac ehcwáy béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eyta ehcwayat carat cacúm ey chíjacro. Eyta chícayat ocsor wijacro. Wicayat carat ey quin wajacro: “Bah urá ahsinro. Bahat táyara yajacan ajatán tayar bár chájacro. Bahat as ojcor conyat tayar bár chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eyta cuácayat bahat cat acsar sera istiy obir yajcata binro. Aját bah obir yajquír eyta, bahat ser istiy eyta obir yajcata bin yajacro. Eyta cuar bahat ser ey ruhw̃ujacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eyta waquír cuít túrjacro. Eyta yajác rehquít, cacúm ey cárcel icar chájacro. Tayar bahnác tunic ocso tas chájacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eta jaw̃ as cuacúr Tetát im eyta yajcátaro. Baat behmár rabat tayar yajác ba ur icar sicor tena cun bár séhw̃ayat, Sirat ba cat eyta técuataro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesusat eyta wac tihrír, Galilea cajc cut bin acsar rajacro. Judea cajc cut Jordán rih rahray rajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jesús jor ricá to bin rojocro. Esar behquir Jesusat yárqueyin cuercurin sicor tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Esar fariséoin Jesús quin béjecro. Fariséoin Jesús urá wahitín ac táyojocro: —Wiyat ay bár yajcayat, ¿uwat wiya yehw̃ tétaica? ¿Moisesat bachan chihtán cuihsú bahjác cuitar eyta yehw̃ ten acu ajc waaca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Etat Jesusat wajacro: —¿Baat Moisesat cuihsú bahjác chihtá istítiica? Eyat uchta cuihsú bahjacro: “Récaram Sirat sera cat, wiw̃á cat chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Eyta cuácayat serat wiya yehw̃ír, tet cat, ab cat báhtaro. Wiya jor ítataro. Buca jor itir istanác waacaro.” ");
INSERT INTO tuf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Etarwan yehw̃ír bucáy bini batro. Sir chihtá cuitar istanác waacaro. Eyta bira ser eyan, wiy eyan uw chihtá cuitar yehw̃ teti jácataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eyta waquít fariséoinat wajacro: —Eyta cuar Moisesat uchta cat cuihsú bahjacro: “Wiya yehw̃ ten síhw̃ayat, récaji carit cuihsúr wiya wiquir car yehw̃ tétaro,” wajacro. Eyta cuácayat, ¿Moisesat eyta cuihsú bahjác ey icrát cuihsú bahyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Etat Jesusat wajacro: —Baat ur ay bár yajquíc et cun bár etar, wiya yehw̃ ten ojcor eyta wajacro. Cuat récaram wiya yehw̃ teti acu waquír chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aját ba quin wacaro. Bíyatan ima wiya yehw̃ ter car, istiy jor yehw̃yat, Sirat ítitan, wiw̃á bes yajcaro. Eyta cuar ima wiyat cahujín owár isár yajquíc ques yehw̃ ter, istiy jor yehw̃yat ay bár étai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eyta wacayat Jesús chiwat ey quin wajacro: —Eytatara, wiya yehw̃ teti acutara, récaji wiya yehw̃ti wan ayan cuitro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Etat eyat wajacro: —Uw bahnáquinatra ey chihtá cácajatro. ");
INSERT INTO tuf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Cahujinra wiya yéhw̃ajar yinjác rehquít, wiya yehw̃ti rehcaro. Cahujinra uw cahujín chihtá cuitar wiya yéhw̃ajar rehquít, wiya yehw̃ti rehcaro. Cahujinra Sir cara rehquey sehnác rehquít, wiya yehw̃ti rehcaro. Eyta cuácayat bíyinan ey chihtá cuitar ítatatara, eyta ítuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Etar uwat sasá Jesús quin rojocro. Jesusat at cut bútayta acu rojocro. Eyin cuitar conayta acu rojocro, Jesús quin. Etatra ima chiwat uwa quin taniric tew̃jacro. Uchta wajacro: —Jesús quin sasá roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesusat eyta tew̃ic rahcuír, ima chiwa quin wajacro: —Sasá rocayat, síuti jaw̃i. Imár rocáyqueyra. Roquín ajc waawi. Sasát Sir tamo sihw̃ar eyta uwat Sir tamo eyta síhw̃ayat, Sir cara rehquey cuitar cuwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eyta waquír, Jesusat im átcara sasá cuis ator chájacro. Eyta chaquir wajacro: —Síratan baan ay obir yajw̃i, wajacro. Eyta waquír acsar rajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Etar Jesús quin sibij istiy wiquír táyojocro: —Síw̃quibu, ¿aját ay bi icúr yajcátaca, cuacúr Sir jor itin acu? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Etat Jesusat wajacro: —¿Bitara etar as quin ay bi ojcor táyoqui? Istanác bin urán ayro. Bahat Sir jor it cúntara, Sir bachan chihtán cuihsú bahjaquey wácati ay yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Etat serat táyojocro: —¿Sir bachan chihtán bi yajcátaca? wajacro. Eyta táyoyat, Jesusat wajacro: —Uw yauti jaw̃i. Yehw̃ti bi jor isár yajti jaw̃i. Bes yajti jaw̃i. Cahujín cahm sucuar tew̃ti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tetín, abín ajcá ji béowi. Behmá urá cut behmán sehnác eyta cahujín cat eyta sehnác chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eyta wacayat, síbiji eyat wajacro: —Aját ey chihtá bahnác yajcaro. ¿Aját caba yajquín acu acsar aját icúr yajcátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Etat Jesusat wajacro: —Bahat caba yaj cúntara uch yajw̃i. Bah oya cat, cajc cat bahnác rawi. Rar car, rayan oya bár bin quin tahw̃uwi. Eyta rar car, rayan oya bár bin quin tahw̃úc tehmár, Sirat cuacúr ba acu cuít yajc jácayqueyra. Etar asi jor chihtá sinay biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","“Bahnác rawi,” wacayat, síbijiat rahcuír, cue rehjecro. Ima oyan, rayan, cajcan cuít rehquít, cue rehjecro. Eyta rehquír car bar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Síbiji bi yiror Jesusat chiwa quin wajacro: —Aját ba quin uní wacaro. Oyin rayin Sirat imár síwata síhw̃atiro. Oya chi, ray chi rehquít imár chihtá cutar siwin síhw̃aro. Etar eyin Sir cara rehquey cutar raúwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aját ba quin wacaro. Sir cara rehquey cuitar rauwin acu cárinat bahnác cham bah cun batro. Camello cabálloir binro. Camello sicar ucar icar bitách raúwajatro. Camello sicar ucar icar raúwajar eyta oyin rayin cat Sir quin bitách raúwajatro. Eyta cuar camello sicar ucar icar rauwin yajquír waquít canar etach batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eyta wacayat, chiwat ojc siquir ub yehw̃jacro. Ub yehw̃ír wajacro: —Eytatara ¿Sir quin cuacúr rehrí raúwajarica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eyta wacayat, Jesusat eyin wahitír eyin quin wajacro: —Uw urá cuitar bitách raúwajatro. Eyta cuar Sir ima urá cut bahnác yajcátaro. Sir urá cut Sir ima cara rehquey cut raúwajatro. Sir urá cuitar cat uwat Sirat síwata síhw̃ataro. Etar Sir ima cara rehquey cut raúwataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Etar Pédroat Jesús quin wajacro: —Isan bah chiwa chaquin acu bahnác cham bahjacro. Eyta cham bahjác tehmár ¿is quin icúr wíquina? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Eyta táyoyat, Jesusat wajacro: —Aját ba quin uní wacaro. Cajcan teyan bahnacan sicor ibsoy chácayqueyra. Ibsoy chácayatan, asan Uw Síuquib bahnaquin ayin acu caran cuít yehninro. Cajc ibsoy chácayat, as caran cuít yehnyat, baan as chiwan rehquít, carin banco doce cuitar ítayqueyra. Eyta ita rabar baan israelin urá istáyqueyra. Israelin bomcar doce bin chiwa cohná bijaquin ur istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bíyinat as chiwa chaquin acu úbachtara, rábintara, chitíntara, tetíntara, abíntara, sasátara, cájctara cham bahjáctara, eyin acu cuít wícayqueyra. Bucoy cat, bucoy cat icar cien wícayqueyra. Acsara cat Sir jor cuacúr it áyayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ah rícara cuar quir bin carin rehquír, cajcan teyan tehmár car ibsoy chácayat, éyinan chiwa chácayqueyra. Cuat chiwan carin rehcáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Sir cara rehquey úchtaan wanro. Ser istiy chícrias jat cacmín cacay bijacro. Ima chi cut canar yajcayta acu chiwa cacay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uw quin cur car, wajacro: “Riy istiy ruóc tehmár denario úbisti túninro,” wajacro. Eyta waquír cájacro. Eyta cat caquir áyjacro, ima chi cut. ");
INSERT INTO tuf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Itchareht rahsa urá cahm jat, ser eyat rasá cur itit, uwan cay batro. ");
INSERT INTO tuf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Icrí yájtiro. Eyta istír eyin quin wajacro: “Baat cat as chi cut canar yajcáy béowi. Aját cayar yajti túninro,” wajacro. Eyta wacayat acat uw eyin cat chi oc béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Itchareht rahsa urá jat cat, rahsa buia jat cat, bucoy rasá cur itit, uwan cay batro. Eyta istír eyin cat caquir áyjacro, chi oc. ");
INSERT INTO tuf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Itchareht rahsa cubar ruhr cut jat cat, bucoy rasá cur itit, uwan cay batro. Eyta istír eyin quin wajacro: “¿Bitara etar baan icúr yajti itca?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eyta wacayat wajacro: “Isan istiyati canar yajquín cati etar, icúr yajti itro,” wajacro. Eyta wacayat, eyat wajacro: “Ba cat as chi cut canar yajcáy béowi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Itchareht rahs rauyat, ser eyat cohcarcam quin wajacro: “Chiwa chiwi. Chiír car tayar tunwi. Ubara ojcor cajac eyin récaji tunwi. Cuat récaji cajac eyin úbara ojcor tunwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Etar rahsa cubar ruhr cut jat raujac eyin cat istiy quin, istiy quin, istiy quin denario úbisti túnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eyta cuácayat récaji cájaquin behquir síhw̃ajacro: “Denario úbisti cuít túnata,” síhw̃ajacro. Eyta sihw̃ac cuar, eyin quino cat denario ubistán túnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eyta tunyat, patrón quin ehrujacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ey quin wajacro: “Ubara ojcor cájaquinatra biráy ruótiro. Cuat ísatra chícrias cuat tui tas ruojocro. Ribiran abáy cuar isat eyta ruojocro. Eyta cuar eyin quino cat, is quino cat, im eyta owara túnjacro. Is cayar yajacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Eyta wacayat eyin úbisti bin quin wajacro: “Chahrú, aját bah cayar yájtiro. Bahat récajian riy istiyá ruóc tehmár denario úbisti tunin tew̃ chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bah ray ehruti cuar caw̃i. Eyta caquir cuécuti jaw̃i. Ajmár chihtá eyta tun cun rehquít, bah quin tunir eyta, úbara ojcor cajac quino cat eyta tunro. ");
INSERT INTO tuf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ray eya ajmár ojc sar binro. Eyta bira ajmár ojc sar bin etar ajmár chihtá cuit tunro. ¿Bahat ajáy sícara es yar wínica? Ey síhw̃awi. Ey sihw̃ar usi cuécuti béowi,” wajacro, serat cacmín cucajá acat. ");
INSERT INTO tuf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Etatan uch síhw̃awi. Ubara ojcor cajac éyinan récaji chácayqueyra. Cuat récaji cajac éyinan úbara ojcor chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Etar Jesús Jerusalén cuwín bijacro. Erar beya rabar chiwa doce bin Jesús owár imara béjecro. Imár beya rabar eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Uch rahcwi. Isan Jerusalén cun bécaro, -wajacro-. Jerusalén cucayat, as Uw Síuquib sacerdote carin at icar, bachan chihtán siw̃quin at icar chácayqueyra. Eyin at icar chácayat, éyinat aját Sir tayar yajác wacáyqueyra. Eyta waquír car as yauwin wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eyta waquír as judío bár bin at icar wícayqueyra. As buror sisín acu, as buquín acu, as yauwin caruc ojcor quejquín acu eyta wícayqueyra. Etar as yauwi cuar, bay cuanyat estají yehnáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bécajareht Zebedeo sasá abá Jesús quin rajacro. Sas owár Jesús quin rojocro. Ab eyat ima sasá cuitar waquín sehw̃ar rojocro. Eyta sehw̃ar, Jesús quin conín cúscara cuitar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eyta conín chihryat Jesusat ab ey quin wajacro: —¿Icúr racar rehquít eyta chihrqui? wajacro. Etat ab eyat wajacro: —Bahat récaji wac bahwi. As sasá bucáy bin bah owár uw áyata waw̃i. Bah behmá cara rehquey cuitar uw ayin yehnyat, as sasá bah cuic rahray cuitar, cuic rahray cuitar, itin ac ajc waawi. Récaji eyta wac bahwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Etat Jesusat eyin quínoan ab quínoan wajacro: —Baatán urá bár tew̃ro. Baat istiti cuar chícaro. Asa uwat yauwin yajcaro. ¿As yauwin yajquír eyta ba cat eyta yauwin yajcayat, ba cat yar yajcátaica? wajacro. Eyta wacayat éyinat wajacro: —Is cat eyta ruhw̃átatara, is cat bar yar yajcátaro. Is cat bar tan ucátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Etar eyin quin wajacro: —Ba cat eyta ruhw̃áyqueyra. Cuat biyin as cuic rahray wihár cuic rahray wihár ítatatara, aját wacátai batro. Biyin carin yinín acu, aját wacátai batro. Cuatán Sirat biyin acu waquír chájactara, éyinan eyta yinata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eyta tew̃ic chiwa ucasi binat rahjacro. Eyta rahcuír rabin bucáy bin acu túrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Turyat Jesusat ima chiwa chiír wajacro: —Baat cat judío bár bin cárinat bitara yájctara ey itro. Judío bár bin cárinat imár chihtá uw quin yajc ayro. Eyin carin cuít binat cat tecuas cuitar imár chihtá uw quin yajc ayro. ");
INSERT INTO tuf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eyta cuar bara carin eyta bini batro. Ba bíyinan carin yin cun síhw̃actara, eyin cahujín acu cacminán wan chaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bíyinan carin cuít yin cun síhw̃actara, éyinat bahnaquin cuitar yajcátaro. ");
INSERT INTO tuf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ajatán eyta yajcaro. Asan Uw Síuquib uw ayin acui rátiro. Cuat uw cuitar yajquín acu rajacro. Uwat tayar yajác tayar bár chaquin acu as chinín rajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Etar Jesús Jericó pueblo tiw̃ acsar rajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Acsara racayat ub bár bin cuisa bucáy binan ibit aw̃at chájacro. Jesús ey ibit aw̃at racayat, ub bár bin éyinat Jesús raquíc rahjacro. Eyta rahcuír, cohwjacro: —Caru, David wihnú, is tamo séhw̃awi. Is cuitar waw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eyta cohwyat, uwat eyin quin tan irujacro: —Ajc chin jaw̃i, wajacro. Eyta wácayatwan cuít cohwjacro: —Caru, David wihnú, is cuayin tamo séhw̃awi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eyta cohwyat Jesusat rahcuír biti inic ítchacro. Itir eyin yehw̃ chiír wajacro: —¿Aját ba cuitar icúr yajcátaica? ¿Icúr rácarica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eyta wacayat wajacro: —Caru, is uba sicor orac chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eyta wacayat, Jesusat cuayin eyin tamo séhw̃ajacro. Sehw̃ar eyin uba butajacro. Jesusat butayat cab rehti eyin ub ji chájacro. Etar eyin Jesús chiwa chaquin ac ey jor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesusin Jerusalén intac rocayat, Betfagé pueblo cuitara béjecro. Betfagé puébloan Olivo terá cuitatro. Esar bequir Jesusat ima chiwa bucáy bin quino wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Pueblo ácatar erar cahmor béowi, -wajacro-. Eraran cur car, asanica sah ji questa chájaquin istáyqueyra. Eyta ityat ricuár cat as ac row̃i. ");
INSERT INTO tuf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Baat roquín yinyat, uwat ey ques téw̃yatra, uchta waw̃i: “Carat inic chícaro. Biráy rehti sicor roquín wacaro.” Eyta waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jesusat chiwa quin eyta yajquín wajacro. Uchicrias Sir chihtá ehcúquibat eyta yajcata récaji ehcú bahjacro. Ehcú bahjác eyta bahnác caba yajacro. Uchta ehcú bahjacro: ");
INSERT INTO tuf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén pueblo itquin quin waw̃i. Wahítuwi. Ba cara ba quin wiquín racaro. Tecuas bár bin racaro. Asanica cutar waar car racaro. Owa yehw̃íc asanica sah cutar racaro. Uchicri Sir chihtá ehcúquibat eyta cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús ima chiwa bucáy bin beyar, Jesús imát wajác eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Eyinat asanica sah cat, ab cat rojocro. Roquír asanica icar cutara imár oya chájacro. Oya chácayat, Jesusa asanica cutar waajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Asanica cutar waacayat uw ricán to binat imár oya ibt aw̃at asujacro. Asuyat owár cahujinat sincuachir bin cay quehu siquir, ibt aw̃at chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Cohcarcám béquinat cat, questoc béquinat cat ricán to binat cohway yinjacro: —David wihnú, bahat is síwayta acu conro. Sir ajc cut rajacro. Siran ayro, tew̃ cohwjacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Eyta cohw becayat, Jesusan Jerusalén pueblo icar raújacro. Rauyat erar itquin bahnáquinat icúr yájctara wahitchacro. Wahitír táyojocro: —¿Uya rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eyta wacayat cahujinat wajacro: —Uya Jesusro. Sir chihtá ehcúquibro. Uya Nazaret pueblo bin Galilea cajc cut binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesusan Jerusalén pueblo icar rauwir, Sir usar raújacro. Ey usar rauwir itit, uwat at cut ruwa wahr car, sicor racaro. Cahujinat ray tehmoro. Eyta istír ray tehmóc mesa ab cuíjacro. Atcur raquin banco ab cuíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ab cuia rabar wajacro: —Sir carit cuitar Sirat wajaquey uchta cuihsú bahjacro: “Uwat as ubach ojcor wacáyqueyra: ‘Ey cutar Sir ojcor conín acu waquír chájacro,’ as usi eyta aw̃áyqueyra,” wacaro, Sirat. Sir carit cuitar eyta cuihsú bahjacro. Eyta waquíc cuar, ba bésinan esar itay raújacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eyta wacayat im ésara ub bár binan, chohcuinán, cuercúrinan, Jesús acor behjecro. Eyta behcayat, Jesusat ima urá cuitar ub bár binan, chohcuinán, cuercúrinan tan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Eyin tan chácayat, sasát Jesús ojcor cohwá rabar wajacro: —Sir imát David wihná bar áyjacro, tew̃ cohwjacro. Sir usi icar eyta cohwjacro. Jesusat ima urá cuitar uw tan jácayat sacerdote cárinat cat, bachan chihtán síw̃quinat cat itchacro. Sasát eyta cóhwiquey cat rahjacro. Rahcuír túrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Turir Jesús quin wajacro: —¿Bahat sasát cóhwiquey ráhctica? wajacro. Etat Jesusat wajacro: —Rahcti tew̃ cat, aját bar rahcro. ¿Baat Sir carit cuitar cuihsú bahjác istítiica? Sir carit cuitar wacaro: Siru, Caru, bahat buwáchcuarin quin, sasá quin, behm ojcor ay cohw áyjacro, wacaro. ¿Baat ey chihtá istítiica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eyta waquír Betania pueblo camay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cuanmí cut chícrias Jesús sicor Jerusalén pueblo bijacro. Bijacan ibt aw̃at cuácayat yayí rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Etar cat ibit cajc aw̃at higuera caruc itchacro. Eyta istír ub chájactara, ques acor wahitay bijacro. Ques acor cur itit, ub batro. Cahy imaro. Eyta rehquít Jesusat wajacro: —Siru, caruc ey bucoy ub chac ayti jaw̃i, wajacro. Eyta wacayat caruc ey cab rehti yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yaryat Jesús ima chiwat itchacro. Eyta istír ub yehw̃jacro. Ub yehw̃ír Jesús quin wajacro: —¿Uniqui? ¿caruc ey cab rehti icrát yaryi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eyta wacayat, Jesusat wajacro: —Aját ba quin wacaro. Baatán ur istán cut “Sirat uchta yajcata,” sihw̃a rabar Sir quin conyat, Sirat behmarat conquey yajcátaro. “Sirat yájcajar óraro,” síhw̃ati cuaquir Sirat behmarat conquey yajcátaro. Aját higuera caruc yar ayir eyta, baat cat eyta yajcátaro. Acsar cat rirar uch ojcor “Siru, rirar ey yacúr icar tewi,” wacayat, eyta téyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Urá istán Sirat wícata eyta sihw̃a rabar Sir quin icúr racar conyat, Sirat bar wícayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ibt aw̃at eyta tew̃ír acsar Jerusalén pueblo cuitar béjecro. Cur car Sir usar uw quin chihtá siw̃ay yehnjacro. Eyta siw̃yat icar sacerdote cárinat cat, judío werjayinát cat Jesús quin behquir táyojocro: —¿Bahat yajquey rehrá chihtá cuitar yajqui? ¿Bah quin rehrát eyta yajc ayi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Eyta wacayat, Jesusat wajacro: —Aját cat ba quin cat táyonro. Táyoyat aját ba quin icúr táyoctara ey ehcuwi. Baat as quin ey ehcwayat, aját rahra cat ba quin behmarat tayoc ey ehcunro. ");
INSERT INTO tuf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","As quin récaji uch ehcuwi. ¿Juanat bi chihtá cuitar uw rih sar siw̃yi? ¿Sir chihtá cuitari, uw chihtá cuitari rih sar siw̃yi? wajacro. Eyta wacayat, sacerdote cárinat cat, judío werjayinát cat imár owár rahra rahra tew̃jacro. —Isat “Sir chihtá cuitar yajacro,” wácyeyra, Jesusat is quino wacata óraro: “Eytatara, ¿ey chihtá bitara reht cática?” wacata óraro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Eyta cuar isat “Uw chihtá cuitara rih sar siw̃jacro,” wácyeyra, ¿uw ricá is acu tec yínajaqui? Uwat síhw̃atan: “Juanan Sir chihtá ehcuquib rehquít, uw rih sar siw̃jacro,” síhw̃aro, uwat. Eyta sihw̃ac etar isat uw chihtá cut siw̃jác wácyeyra, ¿is acu tec yínajaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Etar Jesús quin wajacro: —Isat istítiro, wajacro. Eyta wacayat, Jesusat wajacro: —Aját táyoyan baat as quin ehcuti etar, aját cat ba quin ehcútiro. Aját bi chihtá cuitar yajquíctara ehcútiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Eyta waquír bucoy cat wajacro: —Baat uch síhw̃awi. Ser úbistiyay sasá cuisa bucayro. Sah istiy quin wajacro: “Bahat ah rícara as chi cut ruóy biwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eyta wacayat sah eyat wajacro: “Asra bitiro,” wajacro. Eyta waquíc cuar, awan chiht istiy sehw̃ar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sah ey quin tew̃ír eyta istiy quino cat im eyta tew̃jacro. Ey quino cat “chi cut ruóy biwi,” wajacro. Eyta wacayat sah eyat wajacro: “Ihyú, bar bétaro,” wajacro. Eyta waquíc cuar bitiro. Jesusat eyta ehcujacro. Eyta ehcúr car wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Eyta cuácayat baat itit, ¿wacjá bíyatan ima tet chihtá yajcyi? wajacro. Etat sacerdote cárinat, judío werjayinát wajacro: —Cahmor ayjac éyatan tet chihtá yajacro, wajacro. Etat Jesusat quin wajacro: —Aját ba quino uní wacaro. Gobierno tayar chiquin cat, wiw̃ín isarin cat, Sir cara rehquey cuitar cuwátaro. Ba cuti cuat eyin cuwátaro. ");
INSERT INTO tuf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juanat bitara ítatatara siw̃jac tacat, baatrá ey chihtá ráhctiro. Cuatán éyinatra rahjacro. Gobierno tayar chíquinat cat, wiw̃ín isárinat cat rahcuír eyin urá ay chájacro. Ur ay bár yajquíc tehmojocro. Eyinat tehmojóc baat itchác cuar, behmár urá tehmótiro. Juan chihtá ráhctiro. Baat ur ay bár sínican etítiro. Eyta chihtara, ba cuti cuácayat, eyin cuwátaro, wajacro. Jesusat sacerdote carin quin, judío werjayín quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Eyta waquír bucoy cat wajacro: —Aját tew̃ic rahcwi. Sir chihtá siw̃in acu aját uwat bitara útara yajquíc cut ehcunro. Riy istiy serat ima cajc cut ub yaquic chistár rijacro. Riquír ey rúhracat ac quer yajacro. Eyta yajquír ub ey sawin acu, rihar ey uquin acu ac cumac bin tan oso iscán cuíhjacro. Iscán cuihir cat cuacracat rirá órojocro. Rir ey cuitar cuar chistár ub bes yajti acu uron acu órojocro. Etar bahnác yajc tihrír, chistár cat cajc cat cahujín at icar bahjacro, ruón acu. “Uba ey tihryat isat wahw̃unro,” waquír bahjacro. Eyta waquír, cajc istiy itay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Itchareht, yájcajareht chistár ub tihric cab cujacro. Ub tihric cab cucayat, ima cacmín ub riquír bahjác cajc cut áyjacro. Chistár ub imáy acat ey ucay áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cacmín ayat eyin behjecro. Eyin behcayat ruón chac bahjác éyinat cacmín ruhw̃ujacro. Cacm istiyrá bujacro. Istiyrá yaujacro. Istiyrá ac cut saújacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eyta cuácayat cacmín chiwan cuít áyjacro. Imáy acat ey ucay áyjacro. Eyta ayir behjecro. Behcayat eyin cat ruhw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ubar ojcor im wacjéy ayin séhw̃ajacro. “Uw éyinat as waquíj etar ajcá ji béyayqueyra,” sehw̃ar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ayat bijacro. Erar cucayat uw éyinat cajc cayíb wacjá ey itchacro. Istír éyinat rahra rahra wajacro: “Cayíb wacjá bar racaro. Uy yaryat cayíb cajc eyra bi acui cha báhjatro. Eyta chíhtara ey yauwátaro. Eyta yauyat, cajc eyrun isay cháquinro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eyta waquitrun, wacj ey chistara ques bin ew̃ uquir téjecro. Uquir técayat yaujacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Eyta waquír uw quin táyojocro: —Baat sihw̃at, ¿cajc cayíb wiquír, uw eyin ac bitara yajcátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eyta táyoyat, éyinat wajacro: —Cajc cayibat uw eyin séhw̃ati tíw̃ayqueyra. Bahnác sácayqueyra. Eyta tiw̃ir cat, cajc eyra cahujín at icar wícayqueyra. Chistár ub es yajti bin at icar wícayqueyra. Cayíb acat wícata bin at icar wícayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Etar Jesusat wajacro: —¿Sir carit cuitar tew̃ic uch istítiica? Sir carit cuitar wacaro: Ac ubach túw̃quinat ac cumac bi úbisti ay bár sihw̃ar, te sijacro. Eyta te sijác tacat, ac ey sicor yehw̃ roquír ácoso tebir chájacro. Sir imát eyta yajacro. Isat eyta ítitan, ayan cuít yajacro. Sir carit cuitar eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Etarwan aját ba quin wacaro. Sirat ima gobierno ba at icar bin síwayqueyra. Eyta siwir uw istiy at icar wícayqueyra. Sir chihtá cuitar urá ay yajcata bin quin wícayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ac ey arcutar biyan yau yáryatan, eyan bahnác quehu téyqueyra. Cuatán ac eya biyan arcutar tijcayat, bahnác sec téyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesusat eyta tew̃yat, sacerdote cárinat cat, fariséoinat cat rahjacro. Rahcuír ítitan, imár ojcor tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imár ojcor tew̃ic istír Jesús questár be cun rehjecro. Eyta cuar uwa ricá to bin ayot Jesús catótiro. Uwat Jesusan Sir chihtá ehcuquib sehw̃ar etar eyin ayot catótiro. ");
INSERT INTO tuf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Etar Jesusat bucoy uwat bitara útara yajquey ehcuro. Eyta ehcúr cuitar Sir chihtá siw̃ro. Siw̃in acu wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Sir cara rehquey úchtaan wanro. Cara reyat ima wacját wiya yehw̃íc cuitar fiesta yajquín órojocro. ");
INSERT INTO tuf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eyta oror cuitar uw chiín acu ima cacmín áyjacro. Récaji secuan acu cájaquin quin secuan chiín acu cacmín áyjacro. Chic cuar rótiro. ");
INSERT INTO tuf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Roti etar cacmín cahujín bucoy áyjacro. Cacmín quin wajacro: “Uw récaji fiesta cuitar roquín acu cájaquin chiay béowi. Aját bahnác órojoquey ehcwáy béowi. Vaca cat, toro cat, obas sibará wíjaquey cat yaujác ehcuwi. Bahnác bar órojoc ehcuwi. Eyin roquín ac ey ehcuwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eyta wacayat cacminát ehcwáy béjecro. Eyinat ehcwayat, uwat chihtá rahcti ruhw̃ujacro. Rahcti cuar acsar béjecro. Istiyá ima chi cut bijacro. Istiyá pueblo istiy oya ray bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Cuat cahujinat cara rey cacmín caquir tajacro. Cahujinat cacmín tiw̃ téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cacmín eyta ruhw̃uyat, cara rey túrjacro. Eyta turir, ima soldádoin áyjacro. Ayat soldádoinat bíyinat cacmín tíw̃jactara, eyin cat rahra tiw̃ téjecro. Bíyinat ruhw̃ujáctara eyin pueblo cat, ubach cat bahnác wahná téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Etar ima cacmín quin wajacro: “As wacjá wiya yehw̃íc fiesta bahnác órojocro. Eyta cuar uwa roquín chíjaquin urá ay batro. Ur ay bár rehquít, usar raúwajar binro. ");
INSERT INTO tuf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eyta chíhtara ba carretera aw̃at uw wahitay béowi. Erara beyar uwa chiwi. Cuisa bita bin istíctara, as wacjí wiya yehw̃íc fiesta cuit roquín ac chiwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eyta wacayat, cacmín ibta aw̃at uw wahitay béjecro. Uwa bita bin istíctara, eta bin chíjacro. Chíjaqueyin ur ay bin cat, ur ay bár bin cat sécuajacro. Eyta secuar fiesta yajquín ubach tan sar ricán to sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Eyta sécuayat, cara reyat cat uw wahitay usar raújacro. Rauwir ítitan, ser istiyá eyan oya fiesta cuitar ow̃ata bin ów̃tiro. ");
INSERT INTO tuf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eyta istír ser ey quin wajacro: “Chahrú, ¿bitara reht fiesta cuitar ow̃ata bin oya ów̃tiqui?” wajacro. Eyta táyoyat, ser eya ajc chin chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Etar cara reyat ima cacmín quin wajacro: “Ser eya questawi. Quescara cat, átcara cat cay questawi. Cay questár car watar uc tewi. Tinjac baquí chira cuitar uc tewi,” wajacro. “Erar técayat, ey bar óyqueyra. Erar yara abáy rehquít ruhra cat cuechwáyqueyra,” -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sirat uwan to bin ima chihtá rahcuayta acu chícaro. Eyta cuar Sir imát biráy bár bin ima chiwa yinayta acu cácaro. Eyta cuácayat uc tejec éyinan abáy óyqueyra. Yaran abáy rehquít ruhra cat cuechwáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eyta wacayat, fariséoin quir béjecro. Fariséoin quir beyar, Jesús ríojocro. Imát waquíc ques ruhw̃ún acu owár cuat ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rior car fariséoinat imár chiwa Jesús quin tayoy áyjacro. Heródesin chiwa cat áyjacro. Jesusat bitara wacátatara istín acu tayoy áyjacro. Jesús imát waquey cuitar cayar yajquín sihw̃ar tayoy áyjacro. Eyta ayat, éyinat Jesús quin wajacro: —Síw̃quibu, isat bah ítitan, bahat uw cayar yájtiro. Bahat Sir chihtá tehmoti ehcuro. Uw cahm ayú batro. Bahat séhw̃atan, uw cara cat, chiwa cat owáraro. ");
INSERT INTO tuf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eyta cuácayat is quin ehcuwi. Behmát séhw̃atan, romano cara reyat is quin tayar chícayat, ¿isat túnataica, túnajarica? ¿Sir chihtá cutar tunin ajc waaquí? Cara César gobiérnoat ray chícayat, ¿túnataica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Eyta wacayat, Jesusat eyin urá itchacro. Jesús imát waquíc ques rion acu tayoc itchacro. Eyta istír eyin quin wajacro: —¿Bitara reht ba urá bucáy wayi? ¿Bitara reht aját bitara wacátatara istá rácarica? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","As acat ray tew̃i, aját wahitín acu. Bi ray cutar ey tayar túnictara as acat tew̃i, wajacro. Etar wacayat éyinat raya ey acat uquir tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Etat Jesusat eyin quin táyojocro: —Baat ítitan, ¿raya cuitar rehr ajc cuihsuyi? ¿Rehr aquir chacyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eyta táyoyat éyinat wajacro: —Romano rey aquir chájacro, wajacro. Ey ajc cuihsujacro, wajacro. Etar eyin quin wajacro: —Eyta chíhtara romano gobierno cara acu túnata ey ima ajc cuihsujaquin ray cut tunwi. Etar cat Sir acu yajcata bin ey cat yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eyta rahcuír, ojc siquir ub yehw̃jacro. Etar Jesús bin béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Im ey rícara cuitar saducéoin Jesús quin béhjecro. Saducéoinat sihw̃at, uw sácajaquin sícotra estají yínajar síhw̃aro. Saduceo éyinat Jesús quin tayon acu wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Síw̃quibu, Moisesat chihtá is quin ehcún cuihsú bahjacro. Uchta wac bahjacro: “Uwa sasá bár cuar chinata óraro. Chein wiya bahta óraro. Eyta báhyeyra ima rabat yarjaquey wiya jor yehw̃ata” wac bahjacro. Yehw̃ír yarjaquey acu sasá cohnátaro. Rab yarjaquey acu cohnátaro. Yarjaquey wiya ojc cut sasá cohnátaro. Isat eyta yajquín acu Moisesat cuihsú bahjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eyta cuácayat is uw tac icar rábinan cucuí ojcor táyonro. Rab eyin rab cahmor bijat wiya yehw̃jacro. Yehw̃ír sah bár cuar yarjacro. Eyta cuácayat, yarjaquey rabat chein wiya báhjaquey yehw̃jacro. Yehw̃ír ey cat, sah bár cuar yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ey yar yiror, rab báwoyat chein wiya yehw̃jacro. Yehw̃ír, ey cat sah bár cuar yarjacro. Eytaan rab cucwoy tas bahnáquinat yehw̃ír, sah bár cuar sácajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Rabin bahnaquin sah istiti sacay cutar chájareht, chein wiya cat ubar ojcor yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eyta cuácayat, sácajaquin sicor estají yinátair waquít, ¿sácajaquin wiya ey sicor cat bi rabay jácataca? -táyojocro, Jesús quin-. Ey wiw̃ eyan rabin cucuí binat yehw̃jacro, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eyta wacayat Jesusat wajacro: —Baat urá bár tew̃ro. Baat Sir carit cut bitara wáctara istiti rehquít urá bár tew̃ro. Baat Sir camur chi síhw̃ati rehquít urá bár tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sácajaquin sicor estají yinyat, éyinat wiya yehw̃á báreyra. Chauninat cat ra cuaca báreyra. Etara éyinan Sir cuacúr cacmín itir eyta ítataro. ");
INSERT INTO tuf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Cuatán sácajaquin sicor estají yinátaro. Sir imát ba quin eyta ehcú bahjacro. Baat istiti cuar, Sirat wajaquey uchta cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Abrahamin, Isaaquin, Jacobin sácajac cuar Sirat wajacro: “Asan Abrahamin acu, Isaaquin acu, Jacobin acu Sitro,” wajacro. Sira chein acui Sir batro. Estají bin acu Sitro. ");
INSERT INTO tuf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eyta wacayat uw ricá to binat rahjacro. Chihtá ey rahcuír, ub yehw̃jacro. Jesusat eyta tew̃yat acat saducéoin ajc sácajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saducéoin Jesús acat ajc sácajac chihtá uwat tew̃yat, fariséoinat rahjacro. Eyta rahcuír owár sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Secuar eyin owár bin bachan chihtán síw̃quinat Jesús urá wahitín acu táyojocro: ");
INSERT INTO tuf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Síw̃quibu, Moisés chiht istiy, chiht istiy bahjác sicar ¿biyan ayan cuitca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eyta táyoyat wajacro: —Uchan ayan cuitro: “Bahat Siran sehnác chaw̃i. Bah urá istán cuitar, ajc istán cuitar, bow̃a cuitar sehnác chaw̃i.” ");
INSERT INTO tuf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chihtá eyan récaji biro. Ayan cuít biro. ");
INSERT INTO tuf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ey yahncút bi cat eyan wanro. “Behmá urá cut behmán sehnác eyta cahujín cat eyta sehnác chaw̃i.” ");
INSERT INTO tuf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chihtá eyan caba yajcayat, Moisesat chihtá bita cuihsú bahjáctara, bahnác caba yajcaro. Sir chihtá ehcúquinat chihtá bita ehcú bahjáctara bahnác caba yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Eyta waquír, fariséoin owár sécuajaquin quin Jesusat táyojocro: ");
INSERT INTO tuf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Sirat Cristo ayquey tamo baat icúr síhw̃aqui? Baat síhw̃atan, ¿rehrá wihnacá? wajacro. Etat fariséoin owár sécuajaqueyinat wajacro: —Crístoan David wihnaró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Etat wajacro: —Eyta cuácayat, ¿Bitara etar Davidat Sir Ajcan Cámuran Eya chihtá cuitar ey ojcor “cara” waquí? Davidat uchta cuihsú bahjacro: ");
INSERT INTO tuf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Sirat ajmár cara quino wajacro: “Asi jor bahan cara chaquic acor ítuwi,” wajacro, Sirat. “Aját bah quehsí bin bahnaquin burbar yajquíc acor ítuwi,” wajacro, Sirat ajmár cara quin. ");
INSERT INTO tuf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidat “ajmár cara” waquíc cuitar Cristo ima cara ehcuro. Eyta ehcujác cuar baat Crístoan “David wihná” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eyta wacayat eyin bahnaquin ajc sácajacro. Etar yahncutra istiyati ey urá istín acu táyotiro. ");
INSERT INTO tuf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Etar Jesusat ricá sécuajaquin quino cat, ima chiwa quino cat wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Bachan chihtán síw̃quinat cat, fariséoinat cat bachan chihtán uw quin siw̃in ac waquír chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eyta chihtara éyinat siw̃quey rahcwi. Eyta cuar éyinat yajquír éytara yajti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eyinat uw quin bachan abáy bi yajc ayro. Uwan ey bachat cuácaro. Uw owat cuaquir eyta, eyin bachat cat eyta cuácaro. Eyinat uw quin bach yajc ayic cuar, imáratra queni yájtiro. ");
INSERT INTO tuf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Eyinat icúr bi yajcayat, uwat imár tamo ay síhw̃ayta acu eyta yajcaro. Uwat imár tamo síhw̃ayta acu Sir chihtá ahntarír cuitar cuihsúr ub cara acat questaro. Cuic aw̃at cat questaro. Eyin oya ques ubar cuitar sohmasom ow̃ro, uwat ey wahitayta acu. ");
INSERT INTO tuf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Secuac usar báncoan ehchí cuitar chihra rácatro. Fiesta cuitar cat báncoan ehchian cuít bi cuitar chihra rácatro. ");
INSERT INTO tuf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Rasá cuitar uwat imár quin ay tena aya rácatro. Imár quino “síw̃quibu,” waca aya rácatro. ");
INSERT INTO tuf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Eyta cuar baatrá uw quin behmár ojcor “siw̃quib” aw̃ú ayti jaw̃i. Ba acu siw̃quib istanro. Ba bahnáquinan rahra rahra rábinro. ");
INSERT INTO tuf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ba acu Siran Tetán istanacro. Eya cuacúr itro. Eyta cuácayat baat cajc uch cut itquin ojcor “tetá” aw̃uti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ba acu cara istanro. Ba cara Cristo asan eyro. Eyta cuácayat, behmár ojcor “cara” aw̃ú ayti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Biyat cahujín cuitar icuran biyan yajcáyatan, eyan cáraro. ");
INSERT INTO tuf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bíyinat imár ojcor “asan caran toro,” síhw̃ayat, eyta síhw̃aqueyin Sirat cuayan wan chácayqueyra. Eyta cuar bíyinat imár ojcor “asan chíwaro,” síhw̃ayat, Sirat eyta síhw̃aqueyin cárinan cuít chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baatán uw quin Sir cara rehquey icar rau áytiro. Behmár Sir cara rehquey icar raútiro. Etar cat bíyinatan Sir cara rehquey icar rauwin yajcayat, baat eyin quin rau áytiro. ");
INSERT INTO tuf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baat sácajaquin wiya báhjaquey cayar yajcaro. Baat usar bin eyin ohnor icúr bi síuro. Eyta siwic cuar, uwat ba ur ay síhw̃ayta acu Sir ojcor conyat in cona báhntiro. Eyta rehquít Sirat ba cuít cuécwataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baatán cuis istanác binat ba chihtá cácayta acu siw̃ot bécaro. Bísaran, bísaran, cajc cutar, yacúr cuitar siw̃ot bécaro. Eyta bécayat uwat ba chihtá cácaro. Uwat ba chihtá cajac rehquitrun, cab oc icar cuácayqueyra. Ba cab oc icar cuácata eyta eyin cat eyta cuít cuac sácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Ba conú cuac sácayqueyra. Baatán chihtá sinti cuar uw quin siw̃ro. Baan ub bár binan wanro. Baan ub bár binat istiy ator béyaran wanro. Baat tan síhw̃atan úchtaro: Uwat sucuar tew̃ti istín ac uchta wacaro: “Sir úsara oro chájaquey cahmar uní wacaro.” Eyta waquíc cuara sucuar tew̃yat Sir táyatro. Cuatán istiyát waquít: “Sir ubach cahmar uní wacaro.” Baat séhw̃atan, eyta waquíc cuara sucuar tew̃yat bitarach batro. Ba tanra eyta síhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Baat eyta sihw̃ac cuar urá bár síhw̃aro. Istiti rehquít eyta síhw̃aro. Baat sihw̃at, ¿biyan ayan cuitqui? ¿Sir úbachtara, órotara, biyan ayan cuitqui? Oroa Sir usi chácayat, ay rehcaro. Sir ima óroan wan rehcaro. Cuat Sir usi chátieyra, ayan etach batro. Etarwan Sir úsian óroi ayan cuitro. ");
INSERT INTO tuf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Baat tan síhw̃atan úchtaro: Uwat sucuar tew̃ti istín ac uchta wacaro: “Sir usar yera ácara icar chajac ruwa cahmar uní wacaro,” wacata síhw̃aro. Eyta waquíc cuara sucuar tew̃yat Sir táyatro. Cuatán istiyát waquít, “Sir usar yera acar cahmar uní wacaro.” Baat séhw̃atan, eyta waquíc cuara sucuar tew̃yat bitarach batro. Ba tanra eyta síhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Baat eyta sihw̃ac cuar, urá bár síhw̃aro. Istiti rehquít eyta síhw̃aro. Baat sihw̃at, ¿biyan ayan cuitqui? ¿Acartara, ruwa ey arcutar chájaqueytara, biyan ayan cuitqui? Ruwa acar arcutar chácayat, ay rehcaro. Ayan Sir ima ruwan wan rehcaro. Cuat acar arcutar chátieyra, ayan etach batro. Etarwan yera acar eyan ruwa ayan cuitro. ");
INSERT INTO tuf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Etarwan uwat “Sir usar yera ácara cahmar uní wacaro,” wacayat, yera acar im istír ójcori wátiro. Yera acar ji, ruwa ji ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Eyta cat uwat “Sir ubach cahmar uní wacaro,” wacayat, Sir ubach im istir ójcori wátiro. Sir ubach ji, Sir ima ji ojcor wacaro. Ubach ji, ubach cayíb ji ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Eyta cat uwat “Cuacúr abá cahmar uní wacaro,” wacayat, cuacúr abá im istir ójcori wátiro. Cuacúr abá ojcor ji, Sir banco ojcor ji, Sir ima ey cutar itic ojcor ji tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baat ir icar aquibo chaquic cat saw̃úr ucasi bi sícara úbisti, ucasi bi sícara úbisti Sir quin wícaro. Eytaan caba wic cuar bachan chihtán ayan cuít eyan waca técaro. Baat uw cayar yajcaro. Uw cuitar cat yájtiro. Ba urá bucayro. Baat Sir quin eyta wícata binro. Eyta cuar chihtá ayan cuít bi cat wácati yajcata binro. Uw cat cayar yajti ítata binro. Uw cuitar yajcata binro. Ur istán chácata binro. ");
INSERT INTO tuf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Baan ub bár binat ibit ehcúquinan wanro. Baat chihtá conu bi yarsa yajcaro. Eyta cuar, chihtá ayan cuít eyra yájtiro. Baan uchan wanro. Uwat rihar icar cuiyách tijcayat úcaro. Eyta uc cuar, cabállora uti cuar yaya sicaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baat baycúr cat, toca cat cuitchiney rest ey sucro. Cuitchiney ay sucuic cuar, úsotra súctiro. Uwat ba tamo ay síhw̃ayta acu baat atum rest ey sucro. Eyta cuar baat uw cayar yajcaro. Bes yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariséoinu, ba ub bár binan wanro. Baycuran tocan usor récaji sucuata eyta ba cat récaji eyta ur ay eyta chaw̃i. Eyta chácayat uw ub cahmor cat ay chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baan chein ruhjác áwata cuasayan ehchí órojoqueyan wanro. Chein awat eyta óroyat, ub cut ítitan, óriquenro. Eyta cuar tan satra chein cáraran toro. Chein restá cat toro. ");
INSERT INTO tuf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ba cat éytaan wanro. Ub cut ba ítitan, ay binan wan itro. Eyta cuar ba tan satra, urá ay batro. Chihtá bucayro. ");
INSERT INTO tuf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Bachan chihtán síw̃quinu! ¡Fariséoinu! Ba conú cuac sácayqueyra. Ba urá bucayro. Baatán chein awat óroro. Cahmor Sir chihtá ehcuquin chein awat óroro. Uchicrias urá ay bin sácajaqueyin chein awat óriquen óroro. ");
INSERT INTO tuf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eyta oro rabar wacaro: “Isan cahmor cohtín itic acat ítchaquir waquít, cohtinát ur ay bár yajác eyta isat éytara yájcajar binro. Isat Sir chihtá ehcuquin yaúwajar binro.” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cohtinát Sir chihtá ehcuquin yaujác wacayat, baatán behmár cahm icar tew̃ro. Behmaran Sir chihtá ehcuquin yauquin bomcatro, wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Etarwan ba cohtinát récaji yajcáy yinjaquey baatán im eyta yajc bahnwi. ");
INSERT INTO tuf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ricminú, ba cumoró sasán wanro. Baan cab oc icar beti ac bitách sera waájatro. Cab oc icar bétaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eyta chihtara aját ba quin Sir chihtá ehcuquin áyinro. Urán bow̃an to bin cat, siw̃quin cat áyinro. Eyta cuar, aját eyta áyatan, baatán as chihtá ehcuquin cat, urán bow̃an to bin cat, siw̃quin cat tíw̃ayqueyra. Cahujinra caruc ojcor quejcáyqueyra. Cahujinra ba secuac usar bucáyqueyra. Cahujinra pueblo istiy cut, pueblo istiy cut ruhw̃ún acu quehw̃ú beyáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eyta yauyat, eyta ruhw̃uyat baat tayar ji rehcáyqueyra. Ur ay bin cahmor tíw̃jaquin tayar cat ba acam rehcáyqueyra. Abel ay bár yajti cuar yaujacro. Abel yauwi cuitar cuar ur ay bin istiy cat, istiy cat Zacarías ocso tas eyta tíw̃jacro. Zacarías Berequías wacjiró. Zacarías Sir usi cuácayat yaujacro. Ruwa wahníc acar ecsar cuácayat Sir ubach querat cac cahmar cuácayat uwat Zacarías yaujacro. Ur ay eyin bahnaquin tíw̃jaqueyin táyara ba acam rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aját ba quin wacaro. Ur ay eyin tiw̃jac tayar ah cutar itquin acam rehcáyqueyra, wajacro. Jesusat bachan chihtán siw̃quin quin, fariséoin quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Eyta waquír car wajacro: —Jerusaléninu, Jerusaléninu, asan ba racar cue rehcaro. Baat Sir chihtá ehcuquin cat bucoy bucoy istiy cat, istiy cat tiw̃ro. Chihtá ehcuquin Sirat ba quin ayat, baat eyin ac cut tiw̃ro, -wajacro-. Jerusaléninu, aját baan rácatro. Sisbúr ahná abinát ima sasá ectar cahmor secuar eyta, aját cat ba eyta secua racar rehjecro. Aját bucoy bucoy ba eyta secua racar rehjecro. Eyta cuar baat as chihtá cátiro. Etar asan ba racar cue rehcaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Eyta cuácayat Sirat ba uwra ajcá bár etí ten yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aját ba quin wacaro. Ahra yahncút baat as bucoy istá báreyra. Sir chihtá racar rehc ocso tas, baatán asa istá báreyra, wajacro, Jesusat judíoin quino. ");
INSERT INTO tuf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesusat judíoin quin eyta waquír, Sir usi bin watar waajacro. Waar cat beya rabar Jesús quin ima chiwat wajacro: —Sir ubach óriquenro. Wahítuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eyta wacayat Jesusat wajacro: —Sir ubach eyta tuw̃jác ojcor uch síhw̃awi. Aját ba quin uní wacaro. Ac ubach tuw̃jaquey bahnác quihu sácayqueyra. Acan arar tas tas chájaquey úbistii chati quihwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Eyta waquír cuitar Olivo terá cuitar cujacro. Erar cur chiwat Jesús ima quin táyojocro. Cahujinat rahcti cuar táyojocro: —Is quin récaji ehcuwi. ¿Bahat tew̃quey bitat cab cuwátaqui? Bahat tew̃jác ojcor bar cab cuquey isat istín acu uw acam bitara rehcátatara, is quin ey ehcuwi. Isat récaji istín acu ehcuwi. ¿Ba wiquín cahmor, cabar tinín cab cucayat, uw acam bitara rehcátaca? wajacro, ima chiwat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eyta táyoyat, Jesusat wajacro: —Yají jaw̃i. Aját tew̃quey cab racayat ¿uwat ba cayar yájcajaqui? ");
INSERT INTO tuf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uwat imár ojcoran “Asan Crístoro,” wacáyqueyra. Uwan to binat eyta wacáy yináyqueyra. Eyinat “Sirat as ayjac,” waquíc cuara, imár chihtá síw̃ayqueyra. Eyta waquír cuitar uw ricá to bin cayar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cajcan birar urar tec quejn chihtá tew̃ic rahcuáyqueyra. Usár cat tec quejn chihtá rahcuáyqueyra. Eyta rahcuí cuar rooti jaw̃i. Eyra im eyta rehcata waquír chájacro. Eyta tec quejquíc cuar ruw̃ár ojcor rehcata eyi batro. ");
INSERT INTO tuf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cajc istiy uwan istiy uw owár, istiy uw owár tec quéjqueyra. Gobiérnoan rahra rahra tec quéjqueyra. Cajc istiy, cajc istiy cuitar yayan uti siti rehcáyqueyra. Ihyara cat birar, urar yiwóyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eyta rehcayat anto récaram rehcata bin éytaro. Ey yahncutwan cuít rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Uwat ba as chiwa chajac ques quehswáyqueyra. Eyta quehsúr ba cahujín at icar wícayqueyra. Ruhw̃ún acu yauwin acu wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eyta ruhw̃uyat ayot cahujinat as chihtá waca téyqueyra. Eyta waca técayat, serat ima íw̃oquin quehsí waáyqueyra. Quehsí waar car, quehsí bin at icar chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Uw ricán to binat Sir chihtai bár ey ehcún yináyqueyra. Eyta yinír, uwan to bin cayar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Etat owár ur ay baran acsar, acsar yajcáyqueyra. Eyta cuácayat uwan rahra rahra sehnác ítchacan wacar sehnác bár rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Etat owár bíyinatan Sir chihtá wácati tan úcayatan, Sirat éyinan síwayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Etat owár Sir cara rehquey chihtá cajcan bítatara bahnác cuitar ehcwáyqueyra. Uw istiy quin, istiy quin, istiy quin, bahnaquin quin ehcwáyqueyra. Eyta ehcú tihryat, ruw̃ár ojcotrun cábara tináyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Etat owár baatán uchta istáyqueyra. Istiyát Sir usi abáy ruhw̃áyqueyra. Sir ima istir querat icar báchuti raúwayqueyra. Uwan raúwajar bin icar raúwayqueyra. Uchicrias cuat Sir chihtá ehcuquib Danielat eyta raúwayta ojcor récaji cuihsú bahjacro. Bíyatan carit uch tacáyatan ey chihtá yají rahcwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sir usi raúwajar bin icar rauyat ruhcuay biwi. Raujac chihtá rahcuír, Judea cajc cut ítquinra cubar icar ruhcuay quinwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bíyinan ubach arcutar rehcáyatan, éyinan usar tan oso oya ucay rauti quinwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bíyinan chi cut rehcáyatan, éyinan siricajá ucay usi beti quinwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wiw̃ín istir bár eyin cat cuechú cuac sácayqueyra. Sasá sut ojcor bin abín cat cuechú cuac sácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Sir ojcor uchta conwi, -wajacro-. “Bara cut cat tan jaquin rícara cat quinic cab cuan ayti jaw̃i,” Sir ojcor eyta conwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sir usi ruhw̃ayat owaran cuechú cuac sácayqueyra. Récaji Sirat cuan ayjac cuar, aha cat tas cuácayat eytay cuátiro. ");
INSERT INTO tuf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Uwan eyta cuac sácayatan, Sirat conu chihr áyayqueyra. Sirat et áytieyra rehratí sera waájatro. Eyta cuar Sir imáy cájaquin sehnác rehquít, et áyayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Uwatan ba quin “Cristo usatro,” wacáyatan, úwatan “Cristo úratro,” wacáyatan, ey ria cati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Etat ba cayar yajquín acu istiy cat, istiy cat, quir bin yináyqueyra. Yinír “Asan Crístoro,” wacáyqueyra. Cahujinat “Asan Sir chihtá ehcúquibro,” wacáyqueyra. Eyinat eyta waquíc cuar Cristo queney batro. Etar istiti bi icúr bár sícara bitara útara yajcáyqueyra. Sirat cájaqueyin cat cayar yajcátair waquít cayar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baat récaji ey istayta acu ba quin ehcuro. Eyta etar yají rahcwi. ");
INSERT INTO tuf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","’Uwat ba quin “Cristo urar ubach bár cuitatro,” wacayat, ria cati jaw̃i. Erar wahitay beti jaw̃i. Ba quin “Wahítuwi. Ubach tan sar ay ístajar quen ruhjacro,” wacayat, ria cati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","As Uw Síuquib sicor wicayat owár úchtaan wanro. Cuir cuasoyat uwat itro. Rahr owár rahs raquíc wihár ítquinat cat, rahs rauwic wihara ítquinat cat ub cuitar itro. Eytaan wan as wicayat, cajc bahnác cuitar ítquinat istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","’Chein bísara jácayat, erar bacasít quiwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Uw ruhw̃ú cab bahní cuitar rahs waa báreyra. Sihyór cat waati rehcáyqueyra. Cuacúr ub cat abá cuitar bin tijcáyqueyra. Cuacúr abá cuitar bahnác yiwóyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Etat cuacúr abá wahítitan, as wiquíc cab cujác chihtá istáyqueyra. Uw bahnáquinat istáyqueyra. Eyta istír cona sácayqueyra. Etat asa Uw Síuquiban istáyqueyra. Bowarám tan cutar raquíc istáyqueyra. Urán to raquíc istáyqueyra. Rahs churotán wan Sir churot chi wan beo beo raquíc istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Etar aját cacmín cuacúr bin áyinro. Ayir éyinat rubar cuhr cutar uw Sir imáy sécuayqueyra. Cajcan teyan bítatara bahnác cutar bin sécuayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Higuera caruc sucóc cab cuquíc síhw̃awi. Baatán higuera cárucua cay sucoyat, rita cuquic itro. Higuera caruc cuicara sucoyat, rita cuquic itro. ");
INSERT INTO tuf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eytaan wan, aját wacye bahnác eyta rehcayat, cábara tinic cab cuquic istáyqueyra. Cabar bar tinic istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aját ba quin wacaro. Ah cut itquin bahnaquin sácati cuar, aját wacye eyta rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cuacúr abá cat, cajcan teyan bahnác bahnáyqueyra. Eyta cuar as chihtán bahnác queni íuti im eyta chácayqueyra. Bahná báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Asa Uw Síuquib cat bitat sicor wicátatara, istiyati istítiro. Rahsa bita jat wicátatara istiyati istítiro. Sir cuacúr cacminát cat istítiro. As Sir ima wacját cat istítiro. Tet imatrun itro. ");
INSERT INTO tuf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Récaram Noé itic cab rehquír eyta, asa Uw Síuquiban racayat cat, éytaan wan rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Récaram etat owaran riw anto cajc bahnác cutar uhrú tas cuinti cuácayat, uwat istítiro. Uwat imár sácajar sihw̃ar ohbac ítchacro. Eyta ita rabar ira yájacro. Bacua yahjacro. Wiya cat yehw̃jacro. Cahbarin cat yehw̃ín ac ajc waajacro. Noein riwa arcutar beyin usar rauwic ocso tas eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Noein riwa arcutar beyin ubach icar rauyat, istiyati imár cuácatai bow̃ béhtiro. Riw uhrú tas cuiníc ocso tas uwat bow̃ béhtiro. Riwat eyin sacan yehw̃íc cab cuc ocso tas bow̃ béhtiro. Asa Uw Síuquib racayat cat, ima éytaan wan bow̃ behti wicáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Etat owár sera bucáy binat chi cut canar yajcaro. Canar eyta yajcayat úbistira ajmaráy béyinro. Cuatán istiyrá beti bahnro. ");
INSERT INTO tuf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wiw̃ín bucáy binat anab tajcro. Tajcyat, úbistira ajmaráy béyinro. Cuatán istiyrá beti bahnro. ");
INSERT INTO tuf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Asan bitat wicátatara baatán istítiro. Eyta bira as wiquíc cahmor síhw̃atira ítiti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Uch síhw̃awi. Ubach cayibat besin bítajat wicátatara istír waquít, camti ítata binro. Bésinat bes yajti acu camti ítata binro. ");
INSERT INTO tuf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eyta bira asa Uw Síuquib bar wicata sihw̃a rabar ítuwi. Eytair báreyra ¿as racayat baat bow̃ behti réhcajaqui? ");
INSERT INTO tuf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Biyan cacúm ay bíntara aját ey ehcunro. Cacúm ay binat carat ayquey wácati bahnác yajcaro. Cacúm eyta bin patronat bahnác obir yajcayta acu cac bahcaro. Cac bahcayat cacúm eyat cacmín cahujín quin ira wícaro. Ira wiquic cuitar cab cucayat, cacmín cahujín ac ira tahw̃uro. ");
INSERT INTO tuf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eyta cac bahr cutar patrón cajc istiy bijacro. Itchareht sicor wijacro. Sicor wiquír ítitan, cacúm eyat bi yajcata wac bahjáctara ay yajcáy raújactara eywan ayro. Cacúm ey ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aját ba quin wacaro. Cacúm eyra patronat cacmín cara cuít yehn áyayqueyra. Icuran biyan bahnacan cacúm ey at icar wícaro. Obir yajcayta acu wícaro. ");
INSERT INTO tuf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Cuatán cacmá ay bár binat uchta séhw̃aro. “As cara in wícajar bijacro,” séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Eyta séhw̃ayeyra cacmín ruhw̃áy yehnata óraro. Imara iran, bacuan báchuti, atuc sínata óraro. ");
INSERT INTO tuf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Simat yehw̃quin owár atuc sínata óraro. Eyta ruhw̃uyat icar, atuc sinyat icar, cara wicata óraro. Patrón in wícajar séhw̃ayat icar wicata óraro. Bow̃ behti cuácayat wicátaro. ");
INSERT INTO tuf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wiquír ítitan, cacúm ay bár yajcaro. Eyta yajquíc ques abáy bucáyqueyra. Urá bucáy bin owár cuécwayqueyra. Eyta cuécwayat, eyta bucayat abáy óyqueyra. Yaran abáy rehquít ruhra cuechwáyqueyra, wajacro, Jesusat ima chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Etar Jesusat acsar ima chiwa quin wajacro: —Sir cara rehquey úchtaan wan chácayqueyra. Cahbarin cuisa ucasi binan serat wiya yehw̃íc fiesta cuitar béjecro. Cahbarin éyinat imár oca soya jaw̃ béjecro. Wiya yehw̃ín ey wiquíc acor itin acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cahbarin cuisa esí éyinra urá batro. Cuatán cahujín esí éyinra urá chiro. ");
INSERT INTO tuf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Urá bár éyinat ocan anín acu aceite yarsa bétiro. Oca anín aceite bahnyat bucoy tehmár chaquin acu bétiro. ");
INSERT INTO tuf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Cuácayat urá ji éyinatra caba cuwata acat béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Eyinan fiesta yajquín usi cucayat, wiya yehw̃ín eya in wítiro. In witi rehcayat cámyarat cahbarin cuac bécaro. Eyta cuac bécajareht sarac cámjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Eyta cámjareht chey ubut chat cohwíc ajc rahjacro. “Bar racaro. Bar racaro. Ey tihráy row̃i,” cohwíc ajc rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","’Eyta cohwíc ajc rahcuír ajc béhjecro. Ajc behquir car oca anay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oca anay yinyat, cahbarin cuisa esí urá bár éyinay aceite cutiro. Cuti cuácayat cahujín eyin quin chíjacro. “Is oca bar tin bicaro. Baayí ey sícara is quin wiw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Etat urá ji éyinat wajacro: “Batro, wícajatro. Ba quin wícyeyra, isay ey cat tináyqueyra. Ba acu cat, is acu cat cuti tináyqueyra. Wícajatro. Cuatán behmarat wahy béowi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","’Eyta wacayat éyinat imár acu wahy béjecro. Aceite wahy bey yiror wiya yehw̃ín ey wijacro. Wicayat, im acor itay ocuajác eyin owár usi raújacro. Rauwir wiya yehw̃íc fiesta yajcáy yinjacro. Rauwir quérati cay tun téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","’Itchareht yájcajareht cahujín aceite ucay béjequeyin sicor béhjecro. Behquir querat acor cuar wajacro: “Caru, caru is rauwin acu quérati waawi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","’Eyta wacayat wajacro: “Aját ba quin wacaro. Ba rehríntara ajatrá istiti binro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesusat ima chiwa quin siw̃in ac eyta ehcujacro. Etar wajacro: —Eyta bira yají chaw̃i. As sicor bítajat wicátatara, caban bi cutara wicátatara, baat istítiro. Eyta chíhtara síhw̃atira ítiti jaw̃i, wajacro. As wiquíc acor ítuwi, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Sir cara rehquey úchtaan wan chácayqueyra. Cara cajc istiy ben inár ima cacmín yehw̃ chíjacro. Yehw̃ chiír car, eyin at icar ima ray to bin ruón acu tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Istiy at icar raya talento esí wíjacro. Istiy at icar raya talento bucáy wíjacro. Istiy at icar talento úbisti wíjacro. Cacmín istiy quin istiy quin orá ruota acat wíjacro. Eyta wiquir cajc istiy bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bi yiror, raya talento esí cajac éyatan ray ey cuitar icúr bi wahr car acsar rajacro. Eyta rájareht acsar cat talento esí sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eytaan wan istiyát talento bucáy wijac eyat cat icúr bi wahr car, acsar rajacro. Eyta rájareht acsar cat talento bucáy sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cuatán talento ubistán cajac éyatra raya caquir ruhjacro. Iscán cuijacro. Cuiir cara raya ey sar ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Itchareht yájcajareht cara sicor wijacro. Wiquír car cacmín bucoy yehw̃ chíjacro. Ray saw̃ún acu yehw̃ chíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chícayat récaji ray talento esí cájaquey wijacro. Wiquír, cara quin wajacro: “Caru, bahat as at icar talento esí wíjacro. Eyta wijac cuar, aját acsar cat talento esí sécuajacro. Towi. Bah quin sicor talento ucasi wícaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Eyta wacayat, carat wajacro: “Eywan yarsa yajacro. Ba urá istanác biro. Cacmá ay biro. Bahat conu bi ruhw̃uti cohn áyjacro. Eyta bira aját bah at icar acsara cuít wíquinro. Is buc owár ahní ítataro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Eyta wacayat, ray talento bucáy cájaquey wijacro. Wiquír, cacmá eyat cara quin wajacro: “Caru, bahat as at icar talento bucáy wíjacro. Eyta wijac cuar, aját acsara cat talento bucáy sécuajacro. Towi. Bah quin sicor talento bacáy wícaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eyta wacayat, cara eyat wajacro: “Eywan yarsa yajacro. Ba urá istanác biro. Cacmá ay biro. Bahat conu bi ruhw̃uti cohn áyjacro. Eyta bira aját bah at icar acsara cuít wíquinro. Is buc owár ahní ítataro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Etat talento ubistán cájaquey wijacro. Wiquír wajacro: “Caru, aját ítitan, bahan ray sar esan abayro. Behmát riti cut bin sécuaro. Behmát ruoti cut bin behmáy cácaro. ");
INSERT INTO tuf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eyta istír bah cahm ehurán to rehjecro. Ehurán to rehquít bah ray ay ruhjacro. Ica cuiir sar yajc chájacro. Towi. Bah raya im éytaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Eyta wacayat, car eyat wajacro: “Bah urá ay batro. Bah ohcan abayro. Aját riti cut bin secuac istíc cuar, as ray ruhjacro. Aját ruoti cut bin caquic istíc cuar, as ray ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿As rayan bitara reht ray yajc chaquib quin wítica? Ray yajc chaquib quin wíjaquir waquít, eyat ray ey cuitar ruota binro. Eyta ruójaquir waquít, sicor rayan cuít wícata binro. Eyta cuácayat as sicor wicayat, ajmaráy acat chaw̃, sécuajac acat chaw̃, cuít chácata binro. ");
INSERT INTO tuf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Eyta chihtara ey at icar talento wijac ey quistú uw̃i. Quistú uquir, ucasi wijac ey quin wiw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aját uní wacaro. Biyay cuítara ey quin acsara cuít wícaro. Eyta wícayat in bahná báreyra. Cuatán biyay conútara, ey ohnor bahnác cuic úcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ey cacmá icúr acui batro. Etar tinjac baquí chira cuitar uc tewi. Erar técayat conáyqueyra. Yaran abáy rehquít ruhra cat cuechwáyqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Asa Uw Síuquiban cara yehnár cajc uch cut sicor wicáyqueyra. Uw ubot wicáyqueyra. Eyta wicayat, cuacúr cacmín owár behcáyqueyra. Behquír asan cara cháquinro. ");
INSERT INTO tuf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Asan rey cara chácayat, uw bahnáquinan as cac cahm béhcayqueyra. Aját eyin urá istín acu béhcayqueyra. Behcayat, aját eyin urá istinro. Istír ur ay éyinra ajquír wahw̃unro. Obas cayibat óbasa cabir tac icar bin wahw̃úr eyta uw eyta wahw̃unro. ");
INSERT INTO tuf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aját ur ay éyinan as cuic rahray wihara cháquinro. Cuatán ur ay bár éyinra cuic rahray istiy wihara cháquinro. ");
INSERT INTO tuf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Etar asa rey carat ur ay eyin quin waquinro: “Bara as Tetát cájaquinro. As Tetát récaram anto cábara cuanti jat echí ba im sasá chaquin ac waquír chájacro. Eyta bira ey sasá chacay row̃i. ");
INSERT INTO tuf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Asa yayí cuácayat, baat as ira wíjacro. As cuc wini cuácayat, yahn acu bacú wíjacro. Asan baat istiti cuar ba quin cucayat, as ubach wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","As oya bár siati cuácayat, baat oya wíjacro. As restát yéhnajar rehcayat, as obir yajcáy béjecro. As cárcel icar cuácayat, as quin pasear yajcáy béjecro. Eyta etar as Tet sasá chacay row̃i.” Aját eyta waquinro, eyin quino. ");
INSERT INTO tuf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Eyta wacayat, ur ay éyinat wacáyqueyra: “Caru, ¿Bah yayat cuaquic isat bitat ityi? ¿Bah quin ira bitat wicyi? ¿Bah cucuát cuaquic isat bitat ityi? ¿Bah quin bacú bitat wicyi? ");
INSERT INTO tuf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bah bírari cámajar cuácayat isat bitat ityi? ¿Bah istiti cuar ubach bitat wicyi? ¿Bah oya bár cuaquic isat bitat ityi? ¿Ba oya bitat wicyi? ");
INSERT INTO tuf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ba restát cuácayat, cárcel icar cuácayat, isan bah quin bitat beyi?” wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eyta wacayat, asa cara reyat wacáyqueyra: “Aját ba quin wacaro. Baat as chiwa obir yajacan, as obir yajquír éytaan wanro. As chiwa oya bár bin cuácayat baat eyin obir yajacan, as obir yajquír éytaan wanro.” ");
INSERT INTO tuf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Eyta waquír ur ay bár eyin quínora waquinro: “Bara as owár ítiti jaw̃i. Sirat ba quehsuro. Etar cab oc icar béowi. Cab oca Sisrám acu ey cacmín acu bar órojocro. ");
INSERT INTO tuf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Asa yayí cuácayat, baat ira witi rehjecro. As cuc wini cuácayat, baat bacú witi rehjecro. Asan ba istiti cuar ba quin cucayat, as ubach witi rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","As oya bár siati cuácayat, baat oya witi rehjecro. As restát cuácayat, as obir yajcáy beti rehjecro. As cárcel icar cuácayat, as quin beti rehjecro. Eyta etar cab oc icar béowi.” ");
INSERT INTO tuf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Eyta wacayat, ur ay bár éyinat wacáyqueyra: “Caru, ¿Bah yayat cuaquic isat bitat ityi? ¿Bitat ira witi ruhw̃uyi? ¿Bah cucuát cuaquic isat bitat ityi? ¿Bitat bacú witi ruhw̃uyi? ¿Bah bírari cámajar isat bitat ityi? ¿Bah ubach witi bitat ruhw̃uyi? ¿Bah oya bár siati cuaquic isat bitat ityi? ¿Ba oya witi bitat ruhw̃uyi? ¿Ba restát cuácayat, cárcel icar cuácayat, isat bah quin beti bitat rehyi?” wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eyta wacayat, asa cara reyat waquinro: “Aját ba quin uní wacaro. Baat as chiwa obir yajti ruhw̃ujacro. Eyin ruhw̃úyatan, as ruhw̃úr éytaan wanro. As chiwa oya bár bin ruhw̃úyatan, as ruhw̃úr éytaan wanro,” waquinro. ");
INSERT INTO tuf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eyta waquír ur ay bár éyinra cab oc icar uwan cuánaan itin acu ab cuiáyqueyra. Cuatán ur ay éyinan Sir owár bur cut su cut ítayqueyra. Jesusat chiwa quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Boni cuanyat bach ajc cheycar aracat bijaquey cuanata cuanjacro. Uchicrias Siran cohtín ubach aracat uw yauti bijacro. Siran aracat uw yauti bijác ey sihw̃an acu judíoinat bach yájcuano. Bach ey ajc istiy cut Pascua fiesta aw̃uro. Boni cuanyat bach ajc cheycar aracat bijaquey cuanata cuanjacro. Eyta cuanyat, Jesusat uw quino wac tihrír, ima chiwa quino acsar wajacro: —Pascua fiesta yajquíc bar cab cucaro. Baatán eyta itro. Eyta cuanyat asa Uw Síuquib caruc ojcor quejquín cahujín at icar wícayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Eyta tew̃yat icar cajc istiy sacerdote carin cat, judío werjayín cat sacerdote cara usi sécuajacro. Sera ajca Caifás usi sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Esar secuar Jesús yauwin acu ríojocro. Uwat istiti caquir yauwin acu ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Eyta rio cuar éyinat wajacro: —Yauwata cuar fiesta cuitatra yaúwajatro. Fiesta cuitar yaúyeyra, uwat istír car, tec yináyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Eyta ríoyat icar Jesús Betania cuitar Simón usi chájacro. Simón ajc istiy cut ojc ohnquey aw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Erar chácayat mesa acor chihrjacro. Mesa acor chihryat wiw̃ istiy Jesús ocsor wijacro. Wiquír boteya rojocro. Alabastro ac boteya órojocro. Ey sar perfume chiro. Inan ehchí bi chiro. Perfume eyan acán to binro. Eya wiquír, Jesús cuis otar uhcajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eyta uhcayat Jesús chiwa túrjacro. Turir car wajacro: —¿Bitara reht eyta auqui? ");
INSERT INTO tuf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Eyta auti cuar perfume ey rata bin yajacro. Ey acan to chiata bin yajacro. Eyta rar car raya oya bár bin quin, ray bár bin quin wícata bin yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Eyinat rahra rahra tew̃yat, Jesusat rahjacro. Eyta rahcuír wajacro: —Uy wiw̃át eyta yajcayat, ¿bitara reht yájcajar bin yajc síhw̃aqui? Uy wiw̃át as acu ay yajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ba owár cuayin uwra it bahná báreyra. Cuácayat asra ba owár etach ita báreyra. Asra ba owár inic itro. ");
INSERT INTO tuf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Uwat ruhcuín acu chein cuitar perfume chaquir eyta, uch wiw̃át as ruhcuín inár perfume chácaro. ");
INSERT INTO tuf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aját ba quin uní wacaro. Cajcan teyan birar birar as chihtá ehcwáyqueyra. Birar ehcúctara, uch wiw̃át yajác ey cat ehcwáyqueyra. Uwat eyat as ac yajác tamo síhw̃ayta acu ehcwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesusat eyta waquír cuitar Judas sacerdótein quin bijacro. Judas Iscariote sacerdote carin quin bir wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Aját Jesús ba at icar wícayat tehmár, ¿as quin bita túnataca? wajacro. Eyta wacayat ray túnjacro. Yera raya treinta túnjacro. Sihyór bacáy canar yajquír cuit cácata eyta túnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eyta tuni yahncút Júdasat Jesús úrojocro. Sacerdote carin at icar bítara wícatatara ey úrojocro. ");
INSERT INTO tuf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Etar fiesta récaram yajquín riy cuanyat pan buc rehti cohquíc riy cuanyat Jesús chiwat Jesús quin táyojocro: —¿Isat Pascua fiesta cut bahat cohn acu bisar wahnátaqui? ¿Pan buc rehti cat, obas cat bisar wahnátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eyta wacayat Jesusat wajacro: —Pueblo icar béowi. Erar uw istiy ey quin waw̃i: “Is síw̃quibat uchta wac ayro: ‘Ahra as acu bar cab cujacro. As bah usi ajmár chiwa owár pan buc rehti bi yayinro.’ wacaro,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesusat ima chiwa quin icúr yajquín wajáctara éyinat eyta yajacro. Eyinat Pascua fiesta cut cohnín acu obas cat, pan cat wahnajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bar tinyat mesa cuitar Jesús ima chiwa owár yájacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eyta yaya rabar eyin quin wajacro: —Aját ba quin wacaro. Ba as chiwa sícara bin úbisti bi urá tehmóyqueyra. Tehmór as quehsí waátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eyta wacayat eyin cuecujacro. Cuecúr istiyát istiyát táyojocro: —Unian ¿aját eyta yajcataítara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eyta táyoyat Jesusat wajacro: —As owár soy sar yajc eyan urá tehmór, as quehsí waátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Uwat asa Uw Síuquib yauwáyqueyra. Sir carit cuitar ehcujác eyta yauwáyqueyra. Eyta cuar biyat as quehsuquin at icar chácayat, eyin conú cuac yaráyqueyra. Ey uw eyan récajian yéhntiir waquít ey ácuan ay chácata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eyta wacayat Júdasat wajacro. Quehsí waata eyat wajacro: —¿Aját eyta yajcataítara? wajacro. Eyta wacayat wajacro: —Ee, bahan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eyin ira yaya rabar, Jesusat pan at cut yehw̃jacro. Yehw̃ír Sir ojcor conjacro. Eyta conár cuitar istiy quin, istiy quin, ima chiwa quin cotír wíjacro. Eyta wiquir wajacro: —Towi. Cohwi. Uchan as sibatró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Eyta waquír toca cat yehw̃jacro. Toc icar chistár ub rihatro. Yehw̃ír Sir ojcor conjacro. Conár ima chiwa istiy quin, istiy quin, tahw̃ujacro. Tahw̃úr wajacro: —Ba bahnaquin uch yahwi. ");
INSERT INTO tuf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Uchan as abro. Sir imatan bitara yajquín tew̃ bahjacro. Sirat wajaquey caba rehquín acu as ab béyqueyra. As ab uw to bin ac béyqueyra. Eyinat Sir tayar yajác tunin ac béyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aját ba quin wacaro. Chistár ub rihar uchta bi aját búcoyra yáhtiro. As ba owár as Tetá cara rehquey cuitar itic ocso tas yáhtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eyta waquír, Sirat rahcuín acu tajacro. Tar car acsara béjecro. Cajc Olivo terá cut cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Erar cur Jesusat eyin quin wajacro: —Ah chéycaran baat as tamo sihw̃ar cuechín chuchin chácayqueyra. Etar as chihtá waca báhayqueyra. Sir carit cuitar ey ojcor wacaro: “Obas cayíb aját yaúwinro. Etat óbasinra bar cui béyqueyra,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eyta cuar as sicor estají yehninro. Eyta yehnár ba cahmor Galilea cajc cut benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Eyta wacayat Pédroat wajacro: —Eyin bahnáquinat bah chihtá waca bahta óraro. Cuatán ajatrá waca báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Eyta wacayat Jesusat ey quin wajacro: —Pédrou, aját bah quin wacaro. Ah chéycara bahat wacáyqueyra, “Asra Jesús chíwai batro,” wacáyqueyra. Cohcarám cohwín cahmor, ícara bay eyta wacáyqueyra, as ojcor, wajacro. Jesusat Pedro quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eyta wacayat Pédroat wajacro: —As bah jor yauwata tacat, aját “As Jesús chíwai batro,” waca báreyra, wajacro. Etat cahujinat cat im eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Etat Jesús ima chiwa owár cajc ajca Getsemaní cut béjecro. Getsemaní cut cur, Jesusat ima chiwa quin wajacro: —Usár as acor ítuwi. As úrior benro. Sir ojcor conay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eyta waquír car im ey owár Pedro cat, Zebedeo sasá cat acsara béjecro. Beyar cuecway yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Etar eyin quin wajacro: —Cueat as yarata racaro. Ba usár quir ítuwi. Camti ítuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eyta waquír acsar biráy bár cuitar bijacro. Bir car ica icar cac batabo bahujacro. Eyta bahúr Sir ojcor uchta conjacro: —Tetú, uwat as yauti ac conro. As yauti yarsa waátatara, as yau ayti síuwi. Aját eyta conic cuar as chihtai yajti jaw̃i. Behmá chihtá cutar yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Eyta conár ima chiwa cuisa bay eyin quin wijacro. Wiquír ítitan, cam sácajacro. Eyta istír Pedro quin wajacro: —¿Bitara reht ba camqui? ¿Camti íniqui ítajarica? ");
INSERT INTO tuf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Camti ítuwi. Camti ita rabar Sir ojcor conwi. Sisramat ba quin ay bár yajc ayti acu conwi. Aját wacaro. Baat ur icar ur ay yajquín sihw̃a cuar, ba sibará chihchí batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eyta waquír car bucoy Sir ojcor conay bijacro. Uchta conjacro: —Tetú, as ruhw̃útian yarsa sera waájartara behmá chihtá yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eyta conár car bucoy wiquír ítitan, chiwa cam bécaro. Cámyarat ub ánjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eyta istír, icar bawoy conay bijacro. Chiwa imara cham bahr car, Sir ojcor conay bijacro. Icara bawoy bicayat récaraman conjác eyta bawoy cat eyta conjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eyta conár car bawoy ima chiwa quin wijacro. Wiquír eyin quin wajacro: —Cámintara ahra camwi. Tan jaw̃i. Asa Uw Síuquib acu bar cab cujacro. As ur ay bár bin at icar wiquic cab cujacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cui yinwi. Bar jaw̃i. As quehsí waajaquey bar racaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesusat echí tew̃yat icar, Judas wijacro. Judas eya Jesús ima chiwa doce sicar binro. Judas owár ricán to béjecro. Espadan ator cárucuan ator béjecro. Sacerdote carin chihtá cuitar, werjayín chihtá cuitar béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Júdasat eyin quin biyan Jesústara ehcún wajáquinro. Ey ehcún acu icúr yajquíntara récaji wajáquinro: “Aját bi ac suhwíctara, eyan eyro. Ey caquir row̃i,” wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eyta wajác etar behquir Jesús cac cahmar bijacro. Cur wajacro: —Caru, as racaro, wajacro. Eyta waquír Jesús ac suhwjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Suhwyat Jesusat ey quin wajacro: —Iw̃oquinu, ¿icúr racar racyi? wajacro. Eyta wacayat, éyinat Jesús ahár cájacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eyta cácayat icar Jesús chiwa úbistiyat atcar cut espada újacro. Uquir ey cuitar sacerdote cacúm tajacro. Ey cucáj cuic téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Cucáj cuic técayat, Jesusat chiwa ey quin wajacro: —Bah espada sicor yahníc chaw̃i. Bíyinan espada cuit técuactara, éyinan espada cuit sácataro. ");
INSERT INTO tuf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Bahatra ey istítica? ¿Aját Tet quin conyat, eyat as bar síwata ey istítica? ¿As siwin ac ima cuacúr cacmín cuisa setenta mil bin áyata ey istítica? ");
INSERT INTO tuf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eyta cuar eyat as síuquir waquít, Sir carit cuitar yajquín wajác ey uní caba yájcajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Etar Jesusat uw ricá ey quin wajacro: —Baat besin caquir eyta, caruc jaw̃, espada jaw̃ as cacay rojocro. ¿Bitara reht eyta royi? Aját riy istiy, riy istiy Sir usi ba ubot siw̃in acu chihrjacro. Eyta cuar, baat as cátiro. ");
INSERT INTO tuf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Eyta cuar Sir carit cuitar ehcúquinat cuihsú bahjác ey bahnác queni íuti acu eyta caba yajcátaro, wajacro. Etar ima chiwa bahnáquinan cui béjecro. Jesús im istir bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús chiwa bey yiror, cájaquinat Jesús ahár béjecro. Sacerdote cara Caifás quin yehw̃ béjecro. Caifás usar bachan chihtán siw̃quin cat, judío werjayín cat bar sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesús bécayat Pedro quescút inara bijacro. Bir sacerdote cara usi ubach tan sar awat cuitar raújacro. Esar rauwir policia owár ítchacro. Bitara yajcátatara wahitín acu ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Etar sacerdote cárinat, bahnác sécuajaquinat Jesús cahm icar sucuar tew̃ata bin uroy áyjacro. Eyta tew̃quin chihtá cuitar Jesús yauwin sihw̃ar uroy áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eyta úroyat, ricá to binat sucuar tew̃jacro. Eyta tew̃ít cat bi ques icar yaúwajatro. Eyta tew̃ bécajareht, uw cuisa bucáy bin yinír wajacro: ");
INSERT INTO tuf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Isat ráhcuitan, ser uchat uchta wajacro: “Aját Sir ubach bahnác bar ruhw̃ú tenro,” -wajacro-. “Quihwír bay cuanyat sicor bahnác óronro,” wajacro. Isat eyta waquíc rahjacro, wajacro, cuisa bucáy binat Jesús ojcor. ");
INSERT INTO tuf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eyta wacayat sacerdote cara yehnár car Jesús quin wajacro: —Eyinat eyta tew̃yat ¿bah ajc chínica? ¿Bah cahm icar téw̃queyan unica? ¿Eyinat bi ojcor tew̃qui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Eyta táyojoc cuar, Jesusat icrí wátiro. Ajc chin chájacro. Eyta cuácayat sacerdote carat ey quin wajacro: —Aját Sir ub cahmor bah quin tew̃ ayro. Is quin ehcuwi. Bahan Crístotara, bah Sir waquíjtara ey bártara, is quin ey ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Etar Jesusat wajacro: —Ee, asan eyro. Etar aját ba quin wacaro. Asa Uw Síuquiban cuacúr urán to bin ecor itic istáyqueyra. Asan cuacúr abá cuitar bin bowarám tan icar raquíc istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Etat wacayat sacerdote caran abáy túrjacro. “Jesusat téw̃ajar bin tew̃ic,” séhw̃ajacro. Eyta sehw̃ar turir car sacerdóteat ima ow̃quey oya rachacro. Turir wajacro: —Uyat Sir ojcor téw̃ajar bin tew̃jacro. Ahsín tew̃jacro. Is cucajá ácatan eyta tew̃jacro. Isat caba rahjacro. Ey cahm icar tew̃quin ahra istiy táyotiro. ");
INSERT INTO tuf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Baat ítitan, ¿bitáraca? wajacro. Eyta wacayat, éyinat wajacro: —Sir tayar yajacro. Etarwan yauwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Etar éyinat Jesús buror sischacro. Ey ac cutar cana rihar tijcajacro. Tijcár cat cahujinat ey ac cat tajacro. Oya cumar cut ac ey, ub ey cay questár cat tajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tajcá rabar wajacro: —Bahat waquitan, bahan Crístoro. Baan Crístotara, bah biyat tajquíctara, is quin ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Eyinat Jesús buror sisyat icar aw̃at Pédroan ubach tan sar awat cuit ítchacro. Erar ityat cacúm cahbara Pedro ocsor wiquír wajacro: —Bah Jesús Galilea bin chíwaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Etat Pédroat Jesús ima chiwa wati cuar wajacro: —Asan ey chíwai batro. Bahat bi ojcor tew̃íctara, istítiro, wajacro, Pédroat bahnaquin cucajá acat. ");
INSERT INTO tuf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Eyta waquír, awat querat cu tas bijacro. Erar cucayat, cacúm wiw̃ istiyát Pedro itchacro. Istír cahujín quin wajacro: —Ser uya Jesusin Nazaret bin owár chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eyta wacayat Pédroat bucoy wajacro: —Aját Sir ub cahmor wacaro. Asan ey chíwai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","It bica rehquít cahujín Pedro ojcsor behjecro. Bequír wajacro: —Bár cat bahan ey chíwaro. Bah ajc tew̃quey ráhcuitan, eyin ajc tew̃ír eyta bahat cat eyta tew̃ro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eyta wacayat, Pédroat wajacro: —Asan ey chíwai batro. Aját uní wátitara, Sirat as bar cuécwayqueyra, wajacro. Eyta wacayat acat cohcarám cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cohwyat, Pédroat Jesusat wajác tamo séhw̃ajacro. Récaji Jesusat wajacro: “Cohcarám cohwín cahm icar bahat as ojcor ‘asra ey chíwai batro,’ wacáyqueyra. Icara bay eyta wacáyqueyra.” Jesusat wajác tamo sehw̃ar, watar waajacro. Watar waar abáy ojocro. ");
INSERT INTO tuf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Etar bahnác cuanyat sacerdote carin cat, werjayín cat bahnaquin owár binat Jesús yauwin wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eyta waquír, gobernador ajca Pilato acor questár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusan Pilato acor yauwin acu questár bécayat, Judas quehsí waajáqueyat itchacro. Istír abáy cuecujacro. Cuecúr car yera raya acan to bi treinta túnjaquey sacerdótein quin, werjayín quin sicor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Sicor beyar wajacro: —Aját Sir tayar yajacro. Aját ba at icar urá ay bin yauwin acu wícajar bin wíjacro, wajacro. Eyta wacayat, éyinat wajacro: —¿Is quin icur obír tew̃ay raca? Is acura bitarach batro. Eyra behmatan it chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eyta wacayat yera raya eya Sir usi eyin cac cahmar téjecro. Ray ter car imara acsara bijacro. Bir car, imát cucuí icar chistár cut questár chinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Júdasat ray te bahcayat, sacerdote cárinat raya ey sicor sécuajacro. Secuar rahra rahra wajacro: —Ray ucha uw yauwin tehmár túnjaquinro. Eyta rehquít Sir ray cahujéy owár chácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eyta waquír imár owár tew̃jacro. Tew̃ír car ey ray cutara, cajc wahjacro. Cajc eyan tabir ucar quemir bin wahjacro. Wahr car cajc ey cuitar judío bár bin yaryat ruhcuín wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eyta wahr cuitar cajc eyan ah acat tasan “Ab cajc” aw̃uro. Uw yauwin ray tunjac cuitar wahjác etar eyta aw̃uro. ");
INSERT INTO tuf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eyta yajquíc cuitar Jeremíasat úchicrias wac bahjacan queni íuti caba yajacro. Jeremíasat wajáquinro: “Eyinat yera raya acan to bi treinta bi sécuajacro. Israélinat sera caquin tehmár acan eyta tunro. ");
INSERT INTO tuf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ey ray cut tabir ucar quemir bin cajc wahjacro. Sirat as quin eyta yajquín wajacro,” wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Etar gobernador Pilato cac cahm cujacro. Cucayat, Pilátoat Jesús quin táyojocro: —¿Bah judíoin cáraica? ¿Judíoin réyica? wajacro. Etat Jesusat wajacro: —Ee, bahat táyocan cábaro. Asan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pilato quin eyta wajacro. Etat sacerdote cárinatan, werjayinatán ey cahm icar tew̃jacro. Eyinat tew̃yat acat, Jesús ajc chin chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ajc chin cuácayat, Pilátoat ey quin wajacro: —Eyinat bah cahm icar tew̃yat acat ¿bahat ajc chinca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Eyta wacayat cat ajc chin chájacro. Ajc istiy wátiro. Ajc istiy wati cuácayat, Pilato ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gobernadorat bár istiy bár istiy fiesta cuitar cárcel icar tunjaquin sicar úbisti uc ayro. Uwat cárcel sar bi uquin chíctara, ey uc ayro. ");
INSERT INTO tuf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ey rícara cárcel sar ser úbisti ajc Barrabáscuano. Ey ojcor tew̃ican uw bahnáquinat ráhcuitro. ");
INSERT INTO tuf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Etar uw bahnaquin sécuayat, Pilátoat eyin quin táyojocro: —Baat sihw̃at ¿aját bi ucátaica? ¿Barrabástara, Jesús Cristo aw̃úc éytara, ucátaica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilátoat ítitan, sacerdote cárinatan, werjayinatán Jesús quehsí rehquitra im at icar wíjacro. Pilátoat eyta itchác etar sacerdote carin quínora, werjayín quínora táyotiro. Ricá quínoa táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Etar cat Pilato wiyat cat ima quin wac áyjacro: —Ey ser urá ay bi ques as ayar chin cuanjacro. Eyta chíhtara ser ey ruhw̃uti jaw̃i, wac áyjacro, Pilato wiyat. Eyta cuácayat Pilátoat ricá quínora bi ucátatara táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eyta táyoyat sacerdote cárinat, werjayinát uw tan téjecro. Barrabás chiín acu uw tan téjecro. Cuatán Jesús yau ayin tan téjecro. ");
INSERT INTO tuf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Etat gobernador Pilátoat bucoy táyojocro: —Baat síhw̃atan, ¿aját sera bi ucátaica? wajacro. Eyta wacayat, uwat wajacro: —Barrabás uw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Etat Pilátoat wajacro: —¿Barrabás úcayat, Jesusra? ¿Aját icúr yajcátaca, Cristo acua? ¿Jesús Cristo aw̃úc eyra bitara acuca? wajacro. Eyta wacayat, bahnáquinat wajacro: —Eyra yauwin caruc ojcor quejcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Etat Pilátoat wajacro: —¿Icrát yauwátaca? ¿Icúr yajác ques icar yauwátaca? Eyat ay bár icrí yájtiro, wajacro. Eyta wacayat cat, éyinat acsar cuít cohwjacro: —Yauwin caruc ojcor quejcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Uwat seo cohw bécayatan, Pilátoat ítitan, uwat ima chihtá cácajatro. Cati cuar íntiney wan uw bahnaquin tecuay yinátaro. Eyta istír Pilátoat rih chiír car bahnaquin ub acat im atum sujacro. Atum sucua rabar wajacro: —Ser uch Sir tayar yájtiro. As chihtá cut yauti jaw̃i. Yaúwintara behmár chihtá cuitar yauwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eyta wacayat, uwat wajacro: —Ey yaúyeyra tayar chi rehcáyatra, is cat, is bómcara cat, tayar chi waátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eyta wacayat, Pilátoat Barrabás tunjaquey uc áyjacro. Cuatán Jesús chistár cuiir cuitar buc áyjacro. Buquír cuitar ima soldádoin at icar wíjacro. Caruc ojcor quejquín acu wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eyin at icar wícayat, éyinat Jesús gobernador ubach rauwin béjecro. Usi beyar car soldado bahnaquin sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Secuar Jesús oya sutchacro. Sutír, ey ojcúm oya buw bi chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cuis icar cat cachá chistár cuiir chájacro. Churotír chájacro. Ey at icar teca cat wíjacro. Eyta chaquir, eyta wiquir Jesús cac cahm cuscar cut chájacro. Eyta chaquir Jesús buror sisín acu wajacro: —¡Judíoin caru! ¡Judíoin caru! wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eyta waca rabar sischacro. Sisá rabar Jesús cuit cana rihar tijcajacro. Jesús ohnor tec ey cuijacro. Cuiquir Jesús cuisa bucoy cat bucoy cat bujacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eta jaw̃ buror sischacro. Buror sisír oya chájaquey sicor sutchacro. Etar sicor imáy ey chájacro. Chaquir caruc ojcor quejquín acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Soldádoinat caruc ojcor quejquín ac beya rabar, sera itchacro. Ser ajca Simonro. Cajc ajc Cirene binro. Simón eya istír cájacro. Caquir ey quin caruc ahár yehw̃ áyjacro. Jesús quejquín ac bequey ahár yehw̃ áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Acsara beyar, terá Gólgota cuitar cujacro. Ajc Gólgota wacayat, cuisa cárara cajc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Erar cur Jesús quin chistár ub rihar iwá cut rihnór wíjacro. Wícayat Jesusat cuw quin yajquír yáhtiro. ");
INSERT INTO tuf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Etar Jesús yauwin caruc ojcor quejecro. Quejquír ey oya soldádoin imár owár tahw̃ujacro. Tahw̃a rabar oya biyat bi cácatatara istín acu at sínjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Oya taw̃a rabar Jesús uron acu ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Quejquír car chihtá caruc cuitar cuihsúr Jesús cuisa aracat quejecro. Bi chihtá ques yauwíctara uwat ey istayta acu cuihsúr chájacro. “Uyan Jesús judíoin rey cáracuano,” cuihsúr chájacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús caruc ojcor quejquír cat cuic rahray wihár caruc istiy ojcor besib istiy, cuic rahray wihár caruc istiy ojcor cat besib istiy quejecro, yauwin acu. ");
INSERT INTO tuf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Etat icar uwa Jesús acor béjecro. Bequir Jesús cuit ajc ahsín cohwjacro. Eyinat Jesusat ay bár yajác sihw̃ar imár ac wir wir rehca rabar, ajc ahsín cohwjacro: ");
INSERT INTO tuf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Bahat waquít, Sir usi bahnác quihwír, bay cuanyat sicor oron wajacro. Bahat waquít éytaro. Bahat eyta yajcátair waquít, behmá cat erar bin bar sera waata óraro. Bahan unian Sir waquíjtara, caruc ojcor quejequin tijca raw̃i, wajacro. Eyta waquír sischacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Etar sacerdote cárinat cat, bachan chihtán síw̃quinat cat, werjayinát cat owár binat cohwjacro: ");
INSERT INTO tuf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Eyat cahujín yarata cahm síujacro. Cahujín síujac cuar imara síwajatro. Eya Israel rey cara wácuano. Eyir waquít bar tijca racátaro. Bah tijca raw̃i. Eyta yajcayat isat cat bah chihtá rahcuinro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eyatra Sirat im obir yajc wácuano. Eytair waquít, Sirat ey síwataro. Eyat “Asa Sir waquijró,” wácuano. Eytatara, Sirat ey sehnáctara, bar síwayqueyra, wajacro, judío cárinat. ");
INSERT INTO tuf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Etat besin ey owár quejéquinat cat Jesús quin im eyta ajc ahsín tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesús caruc ojcor quejquír, rahsa urá cuaquir, chéycara eyta cay tínjacro. Rahs buya tas eyta tínjacro. Cajc bahnác cuitar eyta tínjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rahsa bui jat Jesusat ay bár cohwjacro: —Elí, Elí, ¿lama sabactani? wajacro. Eyta cohwíc eyan uchta wajáquinro: “Siru, Siru, ¿icrát asa ajcá bár cham bahyi?” ojcor wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ey cohwyat, ey acor ítquinat rahcuír wajacro: —Eyat Elías úchicrias bin chícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eyta wacayat, istiyát chistár ub rihar bacua ihirán to bi itáy quinjacro. Istír caros ojcor siw̃jacro. Siw̃ír caruc ubar ojcor questár, yehw̃ rojocro. Roquír Jesusat suhw yayín acu yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Eyta wiquin yajcayat, cahujinat wajacro: —Witi jaw̃i. Elíasatan siway wicátatara istín ac chaw̃ jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Etar Jesusat bucoy ay bár cohwjacro. Cohwír, chinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chinyat acat, Sir usi oya wiricás rújaqueyan ima ubut oso rach bijacro. Cuacracat bi bahnác ic icar tas rach bijacro. Ihyár cat yiwojocro. Siyo cat bihnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chein ruhjaquin ucar cat sicor waajacro. Waar cat chein sicor estají yinjacro. Sir chihtá caquir sácajaqueyin cahujín sicor estají yinjacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yinír car Jesusan sicor yehníc acor ítchacro. Etar Jesús sicor yehnyat acat, yinjáqueyin pueblo Jerusalén béhjecro. Ey pueblo béhcayat, quir binat eyin itchacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús chinyat acat soldado carat ihyár yiwóc itchacro. Siyoá bihníc itchacro. Ey chiwat cat eyta itchacro. Eyta istír ojc sijacro. Ojc siquir wajacro: —Uya uní Sir waquijró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ey terá cuitar cat wiw̃inat cajc bira cuít cuar wahitchacro. Wiw̃ eyin Jesús owár cajc Galilea bin rojocro. Eyinat Jesús obir yajáquinro. ");
INSERT INTO tuf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wiw̃ istiy ajca Maríaro. Eya Magdala pueblo binro. Istiy cat ajca Maríaro. Eya Santiago Josein abró. Istiyá Zebedéoin sasá abró. ");
INSERT INTO tuf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jesús chiníc cuitar rahs rau bicayat, ser istiy Pilato quin wijacro. Sera eya ajca Josero. Carin óyinro. Eya Arimatea pueblo binro. Eya Jesús chíwaro. ");
INSERT INTO tuf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José eya Pilato quin wiquír Jesús chein ruhcuín acu chíjacro. Chícayat Pilátoat ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Etar Joseat Jesús chein lienzo wiricás timá bár bi cut bacojocro. ");
INSERT INTO tuf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bacór car ac ucar sar chájacro. Ac ucar eya José ima ruhcuín acu récaji órojoquinro. Ey sar chein anto ruhcti biro. Jesús chein ey icar chaquir car ucar canó ac ohná cumac bin chájacro. Ohná wihca beyar chájacro. Chaquir bijacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Eyta chácayat acor María Magdala bin cat, istiy María cat ácatar ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jesús chein ruhcuí cuanmí cuitara sacerdote carin cat, fariséoin cat Pilato quin béhjecro. Tan jaquin rícara cuanyat béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Behquir wajacro: —Caru, Jesús uw cayar yájquibro. Eyat anto chinti cuácayat wajacro: “As chinír bay cuanyat sicor yehninro,” wajacro. Isat eyta wajác tamo síhw̃aro. Eyta wajác chíhtara ");
INSERT INTO tuf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ey chein chiw̃ti acu uro aywi. Riya bay chein ruhjác ucar ey uro aywi. Eytair báreyra ey chiwat chein ey béyata óraro, chéycara cut. Ruhc beyar car uw quin ehcwata óraro. “Sicor estají yehnjacro,” tew̃ata óraro. Eyta téw̃yeyra ruw̃ár ojcor tew̃ír cuit uwan cuít cayar yajcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eyta wacayat Pilátoat wajacro: —Ihyú. As soldado eyin béowi. Chiw̃ti acu eyin quin yají úro aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eyta wacayat éyinat chein ruhjác cuitar soldádoin béjecro. Cur car ucar icar rauw ayti acu ohná ac aw̃at arúm chájacro. Arúm urán chájacro. Eyta chaquir soldádoinat uron ac chac bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tan jaquin rícara wa bi cuitar bucoy riy cuan bicayat, María Magdala bin, istiy María jor Jesús ruhjác cut wahitay béjecro. Semán istiy rau cuan bicayat béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wiw̃ín bécayat ihyara yiwojocro. Yiwoyat acat Sir cacúm cuacúr bin wijacro. Wiquír ac ohná chein ruhjác ucar cutar tunjaquey waar téjecro. Waar ter ohná ey cutar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sir cacúm ey ítitan, cuir cuasór sir éytaro. Ey oya cat cuasayan ehchiro. Cuasayan ábarit éytaro. ");
INSERT INTO tuf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sir cacúm wicayat, ehurát soldádoin yiwojocro. Yiwór car sacar eyta ajc tijcajacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Etar Sir cacmát wiw̃ín eyin quin wajacro: —Rooti jaw̃i. Aját ítitan, baat Jesús uroy rojocro. Caruc ojcor quejequey uroy rojocro. ");
INSERT INTO tuf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ey uroy rojóc cuar, usari batro. Eya sicor estají yehnjacro. Imát eyta yehnín wajacro. Ey chein chajac cutar uroy row̃i. ");
INSERT INTO tuf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Istír, cab yajti béowi. Jesús ima chiwa quin ehcwáy béowi. Uchta waw̃i: “Jesús chinjaquin sicor yehnjacro,” waw̃i. “Eyin cahmor Galilea ben wacaro,” waw̃i. Erar éyinat tihrata, waw̃i. Aját ba quin eyta wacaro. Sir cuacúr cacmát eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eyta wacayat wiw̃ín eyin chein ruhjác cuitar bin inchásarac béjecro. Ojc sijác cuaquir cat ahní rehjecro. Etar Jesús chiwa quin ehcwáy rojocro. ");
INSERT INTO tuf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eyin sicor rocayat acat Jesús waajacro. Waar car eyin quin wajacro, “¿Ba cat ey cutqui?” wajacro. Jesusat wacayat, eyin Jesús ocsor behjecro. Behquir ey quesa cuic cut questajacro. Questár wajacro: —Bah ayro. Bahan Sir wacjiró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Etat eyat eyin quin wajacro: —Rooti jaw̃i. As rabin quin chihtá béowi. As eyin cahmor Galilea ben, waw̃i. Eyin cat erar beyata, waw̃i. Erar cur as istáyqueyra. Aját ba quin eyta wac ayro, wajacro. Jesusat wiw̃ín quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wiw̃ín eyin bey icar aw̃at, soldádoin cahujín sacerdote carin quin ehcwáy béjecro. Imarat itchaquey ehcwáy béjecro. Ihyár yiwojóc cat, Sir cacúm wijác cat, ac ohná waar bo tejec cat ehcwáy béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Eyta ehcwayat sacerdote cárinat werjayinát owár secuar tew̃jacro. Soldádoinat acsar uw quin ehcuti acu secuar tew̃jacro. Secuar tew̃ír soldádoin quin raya to túnjacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tunir soldádoin quin wajacro: —Uw quin uchta waw̃i: “Is cámjacro. Is cami yiror, Jesús chein ima chiwat bes yajacro,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Uch tew̃jác chihtá gobernadorat rahcyat, isat ba cuitar waquinro. Gobernadorat ba ruhw̃uti acu waquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eyta wacayat soldádoinat ray ey cájacro. Ray caquir sacerdote cárinat wajác eyta uw quin im eyta tew̃jacro. “Jesús chein ima chiwat bejecro,” wajacro. Eyta tew̃yat ah tasan judíoinat im eyta tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Etar Jesusat wac ayjac eyta, Jesús ima chiwa once binan Galilea cun béjecro. Jesusat bey áyjaquey cúbara cutar béjecro. ");
INSERT INTO tuf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Erar cur car, Jesús itchacro. Istír wajacro: “Bah ayro. Bah Sir waquijró,” wajacro. Cahujinat eyta waquíc cuar cahujínatra ey istíc cuar, Jesústara, Jesús bártara, ey istiti rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Etar Jesús eyin acor wiquír wajacro: —Cuacúr cuitar cat, cajcan teyan bítatara bahnác cuitar cat Sirat asan ayquib yehn áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eyta chihtara cajc bahnác cuitar béowi. Uw quin as chiwa yinayta ac siw̃ay béowi. Eyta siw̃ir uw eyin as chiwa yinjác ehcún acu rih cut siw̃i. Tetá ajc cut, Sira wacjá ajc cut, Sir Ajcan Cámuran Ey ajc cut uw eyin rih sar siw̃i. ");
INSERT INTO tuf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eyin quin as chihtá cut bitara yajcátatara, bitara ítatatara siw̃i. Eyta siw̃a rabar uch síhw̃awi. Bur cut suw cut asan ba owár rehquinro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uchan chihtá ay biro. Jesucristo Sir wacjá ojcor tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías yaric Sir chihtá ehcúquibro. Isaíasat úchicri uchta cuihsú bahjacro: Sirat wacaro: “Bah ben cahmor aját chihtá ehcuquib ayro. Cur eyat bah cahmor bahnác óroro. ");
INSERT INTO tuf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eyat ubach bár cut wac cohwro: ‘Cara wiquín cahmor bahnác órowa,’ wac cohwro,” wacaro, Sirat. Isaíasat úchicri eyta cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Etar Juan ubach bár cut wijacro. Wiquír uw rih sar siw̃jacro. Uw quin wajacro: “Baat ay bár yajquíc etwi. Etír ba rih sar siw̃ín acu as aywi. Sirat baat ay bár yajquíc tayar bár chácayta acu eyta yajw̃i.” ");
INSERT INTO tuf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Cajc Judea uwa bahnaquin Juan quin béhjecro. Pueblo Jerusalén uwa bahnaquin Juan quin béhjecro. Erar behquir wajacro: “Isat ay bár yajacro,” wajacro. Eyta wacayat Juanat eyin rih sar siw̃jacro. Rih eya ajca Jordanro. ");
INSERT INTO tuf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanat camello anará cuir ow̃jacro. Camello cabálloan wanro. Oy eyta ey ow̃ir ruwa umá chistár cuit ima ur acat questajacro. Erar ita rabar súritan wan bin cohjocro. Bowar anúb sihc yájacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Erar eyta ita rabar eyat bahnaquin quin wajacro: —As yahncút ser istiy wicátaro. Ser eya urán as cuitro. Ey ayan as cuít etar aját ey bútajatro. Bahúr ey ques barcát chistár aját rícuajatro. ");
INSERT INTO tuf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aját ba rih sar siw̃ro. Eyta cuar éyatra ba ur icar Sir Ajcan Cámuran Eya chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Biráy bár cuanyat Jesús pueblo Nazaret cajc Galilea bin rajacro. Raquír rih Jordán wijacro. Wicayat Juanat Jesús rih sar siw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Juanat siw̃yat Jesús sicor rih sar bin yehnjacro. Yehná racayat cuacúr aba itchacro. Ititan querat waar eyta waajacro. Sir Ajcan Camur Eyan im arcutar wiquíc itchacro. Sir Ajcan Camur Eya im arcutar átcurir wicaro. ");
INSERT INTO tuf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Etar cuacúr abá sar bin Sirat wajacro: “Bahan as waquijró. Bahan sehnacro. Asan bah jor tan wanro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Etat Sir Ajcan Camur Eyat Jesús uw bár cuitar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sir Ajcan Camur Eyat ayat Jesús uw bár cutar bijacro. Cur erar riya cuarenta cuanjacro. Erar ityat Satanasat Jesusan ay bár yajcayta acu cayar yajquín yehnjacro. Banab cat, cohtoc cat ésatro. Eyta cuar Sir cuacúr cacminát Jesús obir yajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Uwat Juan cárcel icar tunjacro. Juan cárcel icar tuní yiror Jesús cajc ajca Galilea bijacro. Galilea cuitar Jesusat Sir chihtá ay bi bahnaquin quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Uchta wajacro: “Sira cara yehníc bar cab cucaro. Baat ay bár yajquey etwi. Uchta síhw̃awi: ‘Chihtá ay bi uniro,’ síhw̃awi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús riwa ajca Galilea cajc aw̃at bijacro. Be rabar Simón taná jor itchacro. Simón taná ajca Andréscuano. Simón cat, Andrés cat rih ruwa cáquincuano. Riw cuitar ruwa caquin ac atarraya técaro. ");
INSERT INTO tuf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Istír eyin quin wajacro: —As owár sinay bewi, -wajacro-. Rih ruwa caquir eyta uw cat éytaan wan cácataro. As chiwa chaquin uw cácataro. Aját eyta yajquín ba síw̃inro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Etar Simón cat, Andrés cat rih ruwa caquic atarraya cham bahjacro. Cham bahr car, Jesús jor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Acsar bir biráy bar cut, Santiago taná jor itchacro. Santiago taná ajca Juáncuano. Santiágoin Juanin tet ajcan Zebedéocuano. Eyinat canó cuitar ruwa caquic atarraya óroro. ");
INSERT INTO tuf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesusat eyin istír im owár beyin chíjacro. Chícayat éyinat imár tet cham báhjacro. Cacmín owár cham bahr Jesús owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Riy istiy sinquin cat, Jesús cat Capernaum pueblo cuitara béhjecro. Erara ityat tan jaquin ricar cuanjacro. Tan jaquin ricar cuanyat, Jesús secuac usar raújacro. Rauwir uw siw̃ay yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesusat siw̃yat uwa ub yehw̃jacro. Eyinat ítitan, Jesusat siw̃ic eyta judío bachan chihtán síw̃quinat éytara síw̃tiro. Jesusat ajquír ay síw̃jacro. Sir urá cut síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Etat icar sera istiy secuac usi wijacro. Ser eya cuicá chero. Wiquír cuicát wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesusu, ¿bahat is ac icúr yajcáy racya? -wajacro-. Nazarétinu, ¿bahatán is sutín ac racya? Ajatán baha itro. Baha urá ay biro. Sir jor binro. Aját itro, cohwjacro, cuicát Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Etat Jesusat cuicá quin wajacro: —Ajc chin jaw̃a, -wajacro-. Sera urá sar bin waa biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesusat eyta wacayat, cuicatán ser ey ehnchacro. Ehnyat ay bár cohwjacro. Cohwír, cuicá sera urá sar bin waa bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Etat bahnaquin ojc sijacro. Bahnáquinat rahra rahra táyojocro: —¿Uniqui? Jesús urán cuitro. Jesusat ima urá cuitar cuicá bar uc áyjacro. Jesusat cuicá quin “waa biwa,” wacayat, cuicá waa bicaro. ¿Ey urá bitáraca? ");
INSERT INTO tuf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eyta rehquít cajc Galilea cutar acsar, acsar uwat Jesusat yajaquey ojcor tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Etat Jesusin secuac usi waa béjecro. Waar car Simonin, Andresin usi cun béjecro. Jacob cat, Juan cat, Simón cat, Andrés cat Jesús owár bejecro. ");
INSERT INTO tuf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","Erar cucayat uwat Jesús quin wajacro: —Simón áw̃iya aw̃a yatro. Tíuitro. Quicrán abayro, wajacro. Etat Jesús Simón áw̃iya quin raújacro. Rauwir Simón áw̃iya atcar cájacro. Atcar sicar caquir ey cui yehw̃jacro. Jesusat eyta yajcayat, ey urá cut Simón áw̃iya quiquír yaric et bahjacro. Quiquír bár cuic bijacro. Bar tan jájacro. Tan chaquir, ira anir, Jesusin quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tino rahsa rauyat, uwa yarquin bahnaquin cat, uwa cuicá ji bi cat Jesús quin rojocro. Cahujinat rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Capernaum uwan bahnáquinan Simón querat acor sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Etaran Jesusat uwa restán ajquír bin, restán ajquír bin yarquin tan jájacro. Cuicá cat uw urá sar bin újacro. Cuicát Jesusan rehrtár itchacro. Eyta itchác etar Jesusat eyin quin tew̃ áytiro. ");
INSERT INTO tuf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cuanmí cut anto rahsa waati Jesús yehnjacro. Yehnár uw bár cuitar istir bijacro. Erar Sir ojcor conjacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eyta cuar Simonin Jesús wahitay béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Istír wajacro: —Jesusu, bahnáquinatan baha wahitro. Bar jaw̃, sicor as usi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Waquít Jesusat wajacro: —Sicor béjetro. Isan acsar béyataro, pueblo istiy, pueblo istiy cuwayta. Pueblo ey uw quino cat as chihtá ehcwátaro. Cajca cuitar as chihtá ehcún ac wijacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Etar Galilea cajca bahnác cuitar ehcwót bijacro. Secuac usar pueblo istiy cuitar, pueblo istiy cuitar chihtá ehcujacro. Beya rabar cuicán uw urá sar bin uc áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Eyta bicayat ser istiy Jesús quin wijacro. Ser eya ruhsúc restá cájaquey cuercúrcuano. Sura ohníc restá cájaquey cuercúrcuano. Wiquír Jesús cac cahmar cuscar cuitar chihrjacro. Imát “Jesusan ayro,” sehw̃ac ehcún ac cuscar cuitar chihrjacro. Chihrír Jesús quin conjacro: —Bahatan as tan wan chac cúntara, eyta chaquin acu urá chero, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesusat eyta rahcuír, ey racar cue rehjecro. Cue rehquír sura ohníc eya at cut butajacro. At cut butár wajacro: —Aját eyta tan cha cun rehcaro. Tan wan ítuwi. Orac chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesusat eyta wacayat, ser ey bar tan jájacro. Icúr bár sicar sura bar tunjacro. Orac rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Etat Jesusat cuercúr ey quin cahujín quino ehcuti acu tew̃jacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—As chihtá rahcwa, -wajacro-. Bahnaquin quínoan icúr ehcuti jaw̃a, -wajacro-. Eyta cuar sacerdote quin in biwi. Sacerdóteat baha sura ohníc tunchác ey istayta acu biwi. Etar cat Sir quin wícata ey wiw̃i. Moisesat icúr wícata cuihsú bahjáctara Sir quin ey wiw̃i, -wajacro-. Eyta yajcayat uwat baha bahnác bar orac chajac ey istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesusat eyta wajác cuar ser eya acsar bijacro. Be rabar istiy quin, istiy quin Jesusat yajác ey ehcujacro. Eyat cuít tew̃jác etar, Jesusra pueblo cutar uw bahnaquin ub acat ohbac bitách béyajar rehjecro. Etar ácubar ítchacro. Acubar ityat uwa pueblo istiy cut bin, pueblo istiy cut bin Jesús quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Biráy bár cuanyat, Jesús pueblo Capernaum sicor rajacro. Wicayat uwat rahra rahra wajacro: —Jesús usi wijacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Uwat eyta rahcuír ricán to bin Jesús quemir sécuajacro. Sécuayat ubach cuinjacro. Querat acor uru tasro. Jesusat uw sécuajaquin quin Sir chihtá ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ehcwayat serin cuisa bacáy binat cuercurey Jesús quin rojocro. Cuercurey quejtirat yárquinro. Etar bitách béjetro. Bejer reht serin cuisa bacáy binat Jesús quin yehw̃ rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eyta cuar ey sérinat Jesús quino bitách cúwajatro. Ricán to etar bitách cúwajatro. Cúwajar reht ubach arcutar waajacro. Waar cat Jesús arcutar ucar cuijacro. Cuir cuercúr caros cutar sámaca oso áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ser éyinat cat, cuercurat cat síhw̃ajacro: “Jesusat cuercúr tan chácayqueyra,” síhw̃ajacro. Sérinat eyta síhw̃acan Jesusat itchacro. Istír cuercúr quin wajacro: —Sahú, bahat ur ay bár yajáqueyra tayar bár chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jesusat “Ur ay bár yajáqueyra tayar bár chájacro,” wacayat, bachan chihtán síw̃quinat rahjacro. Eyin cat ésatro. Eyinat rahcuír síhw̃ajacro: ");
INSERT INTO tuf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Jesusat Sir ub cahmor téw̃ajar bin tew̃ro,” síhw̃ajacro. “ ‘Ay bár yajquíc tayar bár chájacro,’ Sir imata wacátaro,” síhw̃ajacro. “ ‘Ur ay bár yajaquéyra tayar bár chájacro,’ cahujínatra bitách wácajatro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bachan chihtán síw̃quinat eyta síhw̃aquey Jesusat itchacro. Etar wajacro: —¿Bitara reht eyta síhw̃aqui? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sir ub cahmor tayar bár chaquin acu chauwan abayro. Eyta cuara cuercúr tan wan chaquin acu cat chauwan abayro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aját ba quin ehcunro. Sirat asan Uw Síuquib quin uw tayar bár chaquin ajc waajác ehcunro. Im urá cut uw tayar bár chaquin acu ajc waajacro. Aját uchta yajquír cutar ba quin eyta ehcunro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Bachan chihtán siw̃quin quin eyta waquír, cuercúr quin wajacro: —Aját bah quin wacaro. Tan chaw̃i. Cui yehnwi. Behmá caros yehw̃i. Usi biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jesusat eyta wacayat, cuercúr cui yehnjacro. Bar tan jájacro. Uw bahnaquin ub acat cui yehnár caros yehw̃ír inchajin bijacro. Cuercúr yehnár biquic istír, uw bahnaquin ub yehw̃jacro. Etat wajacro: “Siru, bah ur ayro,” wajacro. “Isat cuercúr tan chaquic anto istiti binro. Ahra anto istiti bin bar itchacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Etat Jesús riw Galilea cajc aw̃at sicor bijacro. Erar cucayat uw ricán to bin ey quemir sécuajacro. Sécuayat Jesusat eyin síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Acsar riw cajc aw̃at be rabar Leví itchacro. Leví eya Alfeo waquijró. Gobierno tayar chíquibro. Leví gobierno ubach watar itro. Jesusat Leví istír, ey quin wajacro: —As jor biwi, as chiwa chaquin acu. “Biwi,” wacayat, Leví yehnár Jesús owár bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Etar Jesusin Leví usi yayín sécuajacro. Gobierno tayar chiquin cat, urá ay bár bin cat, Jesusin owár mesa acor sécuajacro. Ricán to bin Jesús owár rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sir bachan chihtán síw̃quinat cat, fariséoinat cat Jesús itchacro. Gobierno tayar chiquin cat, urá ay bar bin cat Jesús owár ira yayay raújacan, éyinat itchacro. Eyta istír, éyinat Jesusat siw̃quin quin wajacro: —¿Gobierno tayar chiquin owár, urá ay bár bin owár Jesúsatra bitara reht ira yaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eyta wacayat Jesusat rahcuír wajacro: —Uch síhw̃awi. Uwa orac binra médico quin bitani béyajatro. Cuat yárquinrun médicoat sacún acu bécaro. Aját orac bin cuitar wacayi rátiro. Cuat bíyinatan imarat Sir tayar yajác síhw̃ayatan, eyin ajmár chiwa cháquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Riy istiy fariséoin cat, Juanat siw̃quin cat, bacha cuitar ira yati itchacro. Etar uwat Jesús quin cur, wajacro: —Juanat síw̃quinat cat, fariséoinat síw̃quinat cat bacha cuitar ira yátiro. Eyta cuar bahat síw̃quinan éytara yajti itro. ¿Bitara etar chihtá ajquír itqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Etat Jesusat eyin quin wajacro: —Sératan wiya yehw̃ín cuácayat, íw̃oquin cat, cayin cat sécuaro. Iran cuít yayín acu sécuaro. Ira ey yaya rabar ahní rehcaro. Ey cáyinatan, íw̃oquinatan áhajira wiya yehw̃quib owár rehquít, bach yájcajatro. Eytaan wan as usár chácayat, as chiwa as jor yayátaro. ");
INSERT INTO tuf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Itchareht wiya yehw̃quib eya ahár síwataro. Síuyatan ey cayin, ey íw̃oquin bach yajcáyqueyra. Ira yati rehcáyqueyra. Ey racar cue rehcáyqueyra, -wajacro-. Wiya yehw̃quib ahár siwir eyta as cat eyta ahár questár béyayqueyra. Eyta bécayat as chiwat ira yati bach yajcátaro, wajacro. Eyta ehcúr cuitar Jesusan ima chiwa owár rehcáyatra báchuti wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Eyta waquír, uchta wajacro: —Oya cumar sejéc cuitar istiy cumar bin bahu chaquir quejcátaro. Cuatán oya sejequi ojcor ibsoy bin quéjtiro. Eyta quéjcyera ibsoy quejcyey suhráyqueyra. Súhryatan oya sejequey acsar racháyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","’Eyta cat uwat cabra umá sutír questaro. Questár sima ey sar chácaro. Eyta cuar umá cumar bi sar sima tenti bi chátiro. Tenti bi chácyera, sima semar ten racáyatan, umá racháyqueyra. Rachyat, sima cat, umá cat ruhw̃áyqueyra. Sima tenti bi umá cumar bi sar chati cuar, ibsoy bi sar chácaro. Eyta cat chihtá awan bi ajquitro. Cahmor ey ajquitro. Eyta bira bucáy bin cácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Riy istiy canar yajti ricar cuanyat ritút ques tiw̃ béjecro. Beya rabar Jesús chiwat ritút quehujacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariséoinat eyta istír, Jesús quin wajacro: —¿Bah chiwat bitara reht eyta quehuqui? ¿Bitara reht tan jaquin ricar canar yajqui? ¿Bitara reht bach auqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Etat Jesusat wajacro: —Behmarat cat Sir carit itro. Sir carit cuitar Davidat yajác ojcor wacaro. David cat, ima chiwa cat yayí rehjecro. Eyta cuar ira batro. ");
INSERT INTO tuf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Eyta rehquít Sir usar raújacro. Etat owár sera ajc Abiatar sacerdote cáraro. Rauwir pan Sir ac chájaquey cohjocro. Pan eya sacerdótein imár istir binat cóhtaro. Cahujinat eyra cohjor binro. Sir chihtá cut eyta “cohti jaw̃i,” wacaro. Davidat cohcayat im chiwa quino cat wíjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sirat canar yajti ricar uw tan jaquin acu waquír chájacro. Bach cuit cuaquin acu waquír chátiro. ");
INSERT INTO tuf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Etar canar yajti ricar cuitar icúr yajcátatar waquín acu Sirat as yehn áyjacro. Asan Uw Síuquib eyta waquín acu yehn áyjacro, wajacro, Jesusat fariséoin quin. ");
INSERT INTO tuf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Etat Jesús bucoy secuac usar raújacro. Rauwir ítitan, atcar cuercúr ésatro. ");
INSERT INTO tuf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Canár yajti rícatro. Etar uwat Jesús úrojocro. Canar yajti ricar yárqueyan tan jácatatara ey úrojocro. Ey ques icar Jesús cahmí icar tew̃ín sehw̃ar úrojocro. ");
INSERT INTO tuf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Etat Jesusat atcar cuercúr quin wajacro: —Usár uw ub acat uw úbotar yehnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Atcar cuercúr uw úbotar yehnyat, Jesusat uw quin wajacro: —¿Baat ítitan, Sir chihtá cuitar bitara waca? Canar yajti ricar cuitar ay yajcátatara, ay bár yajcátatara, baat waw̃i. Uw tan chácatatara, uw tan chácajartara, baat waw̃i. Jesusat eyta wacayat, eyin ajc sácajacro. Icuri wátiro. ");
INSERT INTO tuf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesusat uw wahitchacro. Ititan, éyinat cuercúr tamo sihw̃ar cue réhtiro. Imát icúr ojcor tew̃ictar síhw̃atiro. Jesusat eyta istiran, cue rehjecro. Etar eyin acu bar túrjacro. Etar cuercurin quin wajacro: —Bah atcar cuercúr ey yehw̃ tew̃i, wajacro. Eyta wacayat, cuercurat im átcara yehw̃ír tew̃jacro. Eyta tew̃yat atcar orac waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eyta yajcayat fariséoin watar waajacro. Watar waar fariséoinat Heródesin owár rahra rahra Jesús rioy yinjacro. Jesús yauwin ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Eyta ríoyat, Jesús riw cajc aw̃at béjecro. Imát siw̃quin owár béjecro. Galilea bin uw ricán to binan ey owár béjecro. Judea bin uw cat, ");
INSERT INTO tuf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén bin uw cat, cajc Idumea bin uw cat, rih Jordán rahray bin uw cat, cajc ajca Tiro bin uw cat, cajc Sidón bin uw cat Jesús quin rojocro. Jesusat yajaquey rahjacro. Etar ey quin rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Beya rabar yárquinan cuercúrinan ricán to bin tan jacot bijacro. Etar uw yárquinan bahnaquin Jesús bután ac uca béjecro. Eyta rehquít Jesusat ima chiwa quin wajacro: —Uw ricá to binat as ucati acu canoa row̃i. As ey cutar chihrín acu. ");
INSERT INTO tuf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Erara cat cuicá ji bin istiy cat, istiy cat Jesús istír ey cac cahmor ic icar téjecro. Ic icar ter wajacro: —Bahan Sir waquijró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Etat Jesusat eyin tecuan acu bucoy bucoy wajacro: —As rehrtara cahujín quin ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús acsar cubar icar bijacro. Erar serin biyin im chiwa yina rácaratara eyin chíjacro. Chícayat ser eyin Jesús quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cucayat, Jesusat cuisa doce bin cájacro. Im owár beyin ac cájacro. Cahujín quin ima chihtá ehcú ayin acu cájacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eyinat uw ur icar bin cuicá uc si ayin acu urá wíjacro. Urá wiquir eyta yajquín wajacro. Yarquin ey cat, cuercurin cat tan jaquin acu urá camur wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chiwa cájaquin úchinan éyinro. Récaji bi Simón cájacro. Jesusat Simón eya istiy ajca Pedro aw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago Zebedeo waquíj cat, ey taná Juan cat cájacro. Ey rabin ajca istiy Boanerges chájacro. Ey ajca wacaro: “Aba cuiran wanro,” waquíc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Etar Andrés cat, Felipe cat, Bartolomé cat, Mateo cat, Tomás cat cájacro. Santiago Alfeo wacjá cat, Tadeo cat, Simón cat cájacro. Simón eya cananístainro. ");
INSERT INTO tuf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote cat cájacro. Judas Iscariote eya ítchareht Jesús quehsí waajacro. Etat Jesús sicor usi bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cur itit, ricán to bin bucoy sécuajacro. Jesusin ira yayín yajquít cat, ricán abayro. Bitách yáyajatro. ");
INSERT INTO tuf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Etar uwat “Jesusan túraritro,” wajacro. Uwat waquíc Jesús cáyinat rahjacro. Etar Jesús ahár beyin sihw̃ar rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sir chihtá siw̃quin Jerusalén bin wijacro. Etar cat Sir chihtá siw̃quin éyinat wajacro: —Cuicá ajca Beelzebuat Jesús isó bicaro. Beelzebú ajc istiy cut Satanás aw̃uro. Cuicá cara Beelzebú urá cut Jesusat cuicá uc si ayro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Etar eyin ima quin chíjacro. Wicayat chihtá siw̃in acu eyin quin icúr bi ojcor tew̃jacro. Uchta wajacro: —Satanasat uw ur icar bin ima Satanás uc tétiro. ");
INSERT INTO tuf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gobierno istán bin bucáy wahw̃úr, rahr rahr tec quejcayat, ey gobierno bar bahnátaro. ");
INSERT INTO tuf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eyta cat puéblotara, cáyintara imár owár bin rahra rahra tec quejcayat, bar sácataro. ");
INSERT INTO tuf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eyta cat Satanás ima urá cut uw ur icar bin ima uc técayat cara yéhnajatro. Ima bar bahnátaro. ");
INSERT INTO tuf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Etar cat bucoy wajacro: —Uwat cara usi bin ohnor bahnác bes yajquín síhw̃ayat, récaji cara ey questátaro. Ey questátira bitách bes yájcajatro. Cuat questár cuitar, bahnác ohbac bes yajcátaro. ");
INSERT INTO tuf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Etarwan aját ba quin wacaro. Uwat bitara útara Sir tayar yajcayat, Sir ojcor conyat, Sirat tayar eyta bin sicor tayar bár chácataro. Bitara útara ahsín tew̃yat, Sir ojcor conyat, Sirat sicor tew̃ti bin eyta bar chácataro. ");
INSERT INTO tuf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cuatán Sir Ajcan Camur Ey ojcor ahsín tew̃yat, Sirat tayar batra chátiro. Uwat Sir tayar ey bitách tun bahná báreyra, wajacro, Jesusat, siw̃quin quin. ");
INSERT INTO tuf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Cahujinat “cuicát Jesús isó biquic” wajác rehquít, Jesusat eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesusat uw quin tew̃yat icar im ab cat, rabin cat watar béjecro. Watar chihrír Jesús jor tew̃ín acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eyta chícayat uw ricán to bin Jesús quemir ítchacro. Uw éyinat Jesús quin wajacro: —Bah abín, rabin watar itro. Bah chícaro. ");
INSERT INTO tuf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eyta wacayat Jesusat uw quin wajacro: —¿As abinán, rábinan rehrinán éyinca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eyta waquír uw ima quemir sécuajaquin wahitchacro. Eyin ita rabar wajacro: —Uyinan as abinán, rábinan, chitinán wanro. ");
INSERT INTO tuf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bíyinatan as Tet cuacúr bin chihtá ráhcyatan, éyinan as abinán, rábinan, chitinán wanro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Etat Jesús bucoy riw cajc cut bijacro. Cur uw siw̃ay yehnjacro. Eyta siw̃yat uwa ricán to bin ey quemir sécuajacro. Eyta sécuayat Jesús canó icar raújacro. Rauwir chihrjacro. Canó ey riw cut chájacro. Eyta cuar uwa bahnaquin riw cajc aw̃at ítchacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eyta cuácayat Jesús riw cut canó cuitar cuaquir uw síw̃jacro. Jesusat chiht istiy, chiht istiy siw̃in acu icúr bi ojcor tew̃jacro. Siw̃in acu Jesusat eyin quin uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Uch rahcwi, -wajacro-. Ser istiy cucú cuiay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cucú ey at cut cuic cuic cuijacro. Eyta cuicayat, cucú cahují ibit aw̃at tijcajacro. Eyta tijcayat ruwásirat ey yájacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eyta cuijacan, cucuá cahují wisu arcút tijcajacro. Tijcayat in bar yehnjacro. Ica ata bár etar in yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yehnyat cat, cunyat cat, rahs waacayat ribirát sarac tíw̃jacro. Sihyá usón bár rehquít tínjacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eyta cuic cuic cuicayat, cucú cahují cachá tac icar tijcajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eyta tijcayat cachá tihw̃án abáy yehnjacro. Cachá tihw̃á abáy yehnyat, cucú cuijac eyra ub chátiro. Cachát sehw̃jác etar ub chátiro. Eyta cuic cuic cuicayat, cucú cahují ican tic cuitar tijcajacro. Etar eyra ay yehnjacro. Ehchí yehnjacro. Etar uban ehchí chájacro. Cucú istiy eyran uban treinta chájacro. Cucú istiy eyran uban sesenta chájacro. Cucú istiy eyran uban cien cuít chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Etar eyta waquír, acsar Jesusat wajacro: —Cucajá ji bínatra ey rahcwa, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Etar uwat Jesús istir bahjacro. Istir ityat cahujinat cat, ima chiwa doce binat cat Jesús quin beyar táyojocro. Cucú ojcor tew̃jác chihtá ojcor táyojocro: —Jesusu, bahat uw siw̃in ac icúr bi ojcor bucoy bucoy tew̃ro. ¿Eyta tew̃ír cuitar síw̃tieyra, bitáraca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Táyoyat wajacro: —Behmarat Sir cara rehquey chihtá orac rahcuátaro. Cahmor istiti bi rahcuátaro. Cuatán cahujinat as chihtá cati bínatra ayra rahcti acu tew̃ro. Eyinat rahcti acu aját chihtá siw̃in acu icúr bi ojcor tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Cahujinat ub cuitar istata cuar, ay istiti rehcayta acu eyta siw̃ro. Eyinat cucách cuit rahcuata cuar, ur icar rahcti acu eyta siw̃ro. Eyta síw̃tiir waquít, eyta istiran, eyta rahcuiran, eyta cáquiran, urá tehmóyqueyra. Eyta tehmoyat, Sirat eyin tayar bár chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Acsar Jesusat eyin quin táyojocro: —¿Aját cucú rijaquey ojcor tew̃yat, bi chihtá siw̃in acu tew̃íctara ráhctica? -táyojocro-. Ey chihtá ráhctitara chihtá istiy, chihtá istiy siw̃in acu icúr bi ojcor tew̃yat, baat ey cat bitách ráhcuajatro -wajacro-. Aját uch ojcor síw̃jacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cucú cuic cuic cuíqueya wacayat, Sir chihtá ehcuquib ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Cucú ibit aw̃at tijcajaquey wacayat, ibit aw̃at wacayat, uw cahujín ojcor tew̃ro. Uw éyinatan Sir chihtá cucajá cuitar rahcuí cuar, ur ícara cátiro. Rahcyat Sisrámatan chihtá uw eyin quin cac áytiro. Bow̃ ca técaro. ");
INSERT INTO tuf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eytaan wan cucú wisu arcutar tijcajaquey wacayat, wisu ey wacayat uw cahujinan ojcor tew̃ro. Uw éyinat Sir chihtá rahcro. Rahcuír ahní cácaro. Eyta cuar ayra cátiro. ");
INSERT INTO tuf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ay cati rehquít, ítchareht waca técaro. Sir chihtá ques uwat ruhw̃áyatan, uwat técuayat, éyinat chihtá waca técaro. ");
INSERT INTO tuf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Cucú cachá tac icar tijcajaquey wacayat, cachá tac icar wacayat, uw cahujín ojcor tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Uw éyinat chihtá rahcuí cuar, iran oyan rayan cuít rácatro. Icúr biyan rácaran cuitro. Ey racar rehquít Sir chihtá tamo síhw̃ati etí técaro. Urá ay ítitiro. ");
INSERT INTO tuf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Cucú ica tic bi cuitar tijcár uba cuít chaquey ojcor wacayat, ica tic bi wacayat, uw cahujín ojcor tew̃ro. Uw éyinat chihtá rahcro. Rahcuír, cácaro. Ur istán waacaro. Urán ay chácaro. Etar cahujín éyinra urá ayan cuitro. Cahujín éyinra urán etach cutiro. Cahujín eyin cat urá ayan owáraqui batro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Acsar Jesusat wajacro: —Uwat vela anir roquír car, cajón satra rúhctiro. Camic socua cahmatra rúhctiro. Cuatán cuacúr jácaro, bahnác cuanín acu. ");
INSERT INTO tuf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Eyta cat icúr bi ruhcuíctara ítchareht uwat eyan bahnác istáyqueyra. Icuran biyan uw quin ehcútieyra semar uw bahnaquin quin ehcwáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bíyinan cucáj chítara uch chihtá rahcwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eyta waquír uchta wajacro: —Baat chihtá rahcuí eyan yají quen caw̃i, -wajacro-. Bíyinatan ay ráhcyatan, Sirat eyin quin cuít síw̃ayqueyra, ay rahjác rehquít. ");
INSERT INTO tuf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Etar chihtán cuít sínayqueyra. Cuatán bíyatan ay rahcti cuácayatan, chihtá conu rahjác ey sicor bar etí téyqueyra. Bar tan chináyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusat acsar wajacro: —Sira cara rehquey úchtaan wanro, -wajacro-. Uw istiyát cucuán ica cuit cuijacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuiir icar cam chéycatra camro. Rícatra yehnár bicaro. Eyta camyat, eyta bicayat icar awatra cucú cuijáqueyra uw imát istiti yinro. Yinín acu cucú bitara yájctara uwat ístajatro. Eyta cuar yinro. ");
INSERT INTO tuf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cucú ica cuitar chácayat, ima yinro. Cahmoran cahy ey ricuaro. Cahy ricuár cuni utar ar chácaro. Ar chaquir ub chácaro. Ub chaquir tam rehcaro. ");
INSERT INTO tuf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tam rehcayat uwat ir ey ehswáy bicaro. Bar cab cujac etar ehsuro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Etar Jesusat uchta wajacro: —Sira cara rehquey icuran wántara, ey siw̃in acu aját icúr bi ojcor ehcunro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sira cara rehquey mostaza cucuán wanro. ");
INSERT INTO tuf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Cucú eyan cónuan bahnác cuít bin ic icar rijacro. Cucú eyan cónuan bahnác cuít bin riqui cuaquir yehnár cat cuít cunro. Ey cunyat cuicar cumac bi chácaro. Ectari ruwat ey cuicar taha cuit chicha tuw̃ro. Eyta cat Sira cara rehquey ey cucuán wanro. Mostaza cucuán conu cuar yehnár cuít cunir eyta Sira cara rehquey cutar uw récaji ricá conu cuar ítchareht éytaan wan uwan cuít rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesusat Sira cara rehquey ojcor uw quin chiht istiy, chiht istiy siw̃in acu icúr bi ojcor bucoy bucoy ehcujacro. Eyta ehcútira síw̃tiro. ");
INSERT INTO tuf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eyta siw̃jac cuar ima chiwa quínora bi ojcor tew̃jactar ay ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesusat uw siw̃yat bar tínjacro. Tinyat ima chiwa quin wajacro: —Bar jaw̃ riw rahray cuwayta, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eyta waquír Jesús chiwa uw ricán to bin esar cha bahjacro. Jesús owár canó sar raújacro. Jesús canó sar bin bucoy waati cuar eyin owár béhjecro. Canó istiy cut cahujín cat béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Béjacareht séroan abáy cac yehnjacro. Séroan abáy cacayat, riw sobasob raquian canó icar raújacro. Canó sar rih bar cuinay raújacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eyta cuar Jesusan canó ubar sar camro. Cuisa cahmar ruw umá banco chaquir cuitar camro. Riw sobasob raquian canó icar rauyat, chiwat Jesús quehw̃ujacro. Quehw̃úr wajacro: —In yehnwa, -wajacro-. Síw̃quibu. Canó riw tan ocso bicaro. Is bar sácataro. ¿Is tamo séhw̃atiqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús ajc wiquír yehnjacro. Yehnár ítitan, séroan abáy cacaro. Eyta cuácayat sero chihr áyjacro. Riw quin wajacro: —Soboti jaw̃i. Catoti jaw̃a, wajacro. Etatan sero cati etchacro. Riwa sobocan soboti etchacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Etaran Jesusat chiwa quin wajacro: —¿Bitara rehtan ay wínica? -wajacro-. ¿Bitara reht aját Sir urá cuit bahnác yajcata anto baat síhw̃atiqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sero cati etyat, riw soboti etyat chiwa eyin ub yehw̃jacro. Rahra rahra wajacro: —¿Ser ucha bitara bíntara? Séroa cat, riw sobocan cat ey chihtá cuitar etchacro. ¿Bitara bíntara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ima chiwa owár riw rahray cujacro. Cajc ajca Gerasa cujacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Rahray cur canó sar bin waajacro. Waacayat ser istiy Jesús quin rajacro. Chein ruhcuíc cuitar bin Jesús quin rajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ser ey cuicát abáy ruhw̃uro. Ser ey chein ruhcuíc cuitar itro. Uwat ey yera chistár cut questán yajquít cat, bitách quéstajatro. Canarán abayro. ");
INSERT INTO tuf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Uwat cahmor bucoy bucoy atcar cat, quescar cat yera chistár cut questajacro. Questajác cuar ser eyat chistár quehujacro. Quescar cut chájaquey cat quehujacro. Quehwír bahnác buca quihujacro. Eyan bíyati bitách íw̃ojotro. ");
INSERT INTO tuf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ricar cat, cheycar cat cubar cuitar bir cohwjacro. Chein ruhcuíc cuitar bir cohwjacro. Imát ac cut ima ojc rijacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesús wicayat ser eyat bira cut cuar itchacro. Istír Jesús quin quinjacro. Cur car Jesús cac cahmar cuscar cuitar chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Etat Jesusat cuicá quin wajacro: —Cuicú, ey urá sar bin car biwa, wajacro. Jesusat eyta wajac rehquít, cuicát Jesús cuit cohwjacro. Uchta wac cohwjacro: —Jesusu, bah cuacúr Sir waquijró. ¿Icúr sehw̃ar as quin raquí? Aját Sir ub cahmor bah ojcor conro. As ruhw̃uti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Etat Jesusat ey quin táyojocro: —¿Baha ajca rehrcá? —As ajca ricácuano. Isa ricán toro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Is cajc istiy ayti jaw̃i, wac conjacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Etat icar im ey cuhs cuitar tusín chiwan to binat tihw̃án yácaro. ");
INSERT INTO tuf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eyta cuácayat ser ey ur icar bin cuicát conjacro. Jesús quin conjacro: —Isat bah ojcor conro. Isan tusín quin aywi. Tusín urá icar rauwin ac ajc waawi, wajacro, cuicát. ");
INSERT INTO tuf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Etat Jesusat cuicá quin wajacro: —Béowi, wajacro. Eyta wacayat, cuicá ser ur icar bin waa béjecro. Beyar tusín sar raújacro. Rauyat tusín ricá to bin bahnác siyo ocso tijca suca béjecro. Tijca suca beyar, bahnác riw icar sácajacro. Tusín cuisa dos mil bin bahnác sácajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tusín sácayat, tusín obir yájquinan ojc sijacro. Ojc siquir quinjacro. Pueblo cuwín quinjacro. Beya rabar uw quin bahnác ehcujacro. Cur car pueblo cutar cat bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eyta ehcwayat uwat eyta yajquey wahitay suca rojocro. Jesús wahitay rojocro. Behquír ítitan, sera cuicá ujac bi itchacro. Récaji cuicá ricán abáy bin cuar, ahra tan wan itro. Oya tas cat chájacro. Tan wan cat rehjecro. Eyta ityat ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Etar Jesusat yajaquey itcháquinat cahujín quin ehcujacro. Sera cuicá ji bin ojcor, tusín ojcor bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ehcwayat, Jesús ojcor conay yinjacro. Uchta wajacro: —Usár ítiti jaw̃i. Cajc istiy sicor biwi, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Etat Jesús canó sar rauyat, sera récaji cuicá ji bin eyat Jesús quin conjacro: —As bah owár ben acu ajc waawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Eyta cuar Jesusat ajc waátiro. Uchta wajacro: —Behmá cayin quin biwi. Iw̃oquin quin biwi. Aját baha tan jájacro, wacay biwi. Sirat bah obir yajác ojcor, Sirat bah tamo séhw̃ajac ojcor cayin quin ehcuwi, wajacro, Jesusat ey quin. ");
INSERT INTO tuf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Etat récaji cuicá ji bin eyat ehcwáy bijacro. Pueblo ucasi cuitar uw quin uchta wajacro: —Jesusat as urá sar bin cuicá újacro. As tan wan chájacro, wajacro. Eyta wacayat uwat Jesusan ayro, síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesusin canó cuitar riw rahray sicor béjecro. Rahray waacayat uw ricán to Jesús quemir sécuajacro. Riw cajc aw̃at sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Erar jácayat Jáiroat Jesús itchacro. Jairo eya secuac usi cáraro. Jáiroat Jesús istír, ey quin wijacro. Wiquír Jesús ojcor conín acu cúscara cuitar chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Cúscara cuitar chaquir Jesús quin wajacro: —As waquíj yatro. Wiw̃arac sah bar yarátaro. Asi jor ey quin béowi. Bahat as waquíj at cut bútawi, tan jaquin acu, yarti acu. ");
INSERT INTO tuf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Etat Jesús Jairo jor béjecro. Jesús quemir uw ricán to béjecro. Beya rabar úcajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uw owár wiw̃á istiyró. Wiw̃á eya cuercutro. Ey rih cut rauwir bara dócero. Cab eyta ácatan abir eyat yarjacro. Tan chati yar yehw̃ro. ");
INSERT INTO tuf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Médico istiyát cat, istiyát cat sacút cat chíhrtiro. Sacún acu ray bítatara bahnác ahujacro. Eyta cuar tan chátiro. Yaran cuitro. ");
INSERT INTO tuf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Wiw̃á eyat uwat tew̃ic rahjacro. “Jesusat uw tan chácaro,” tew̃ic rahjacro. Etar uw tac icar Jesús icar wihár wijacro. Eyat séhw̃ajacro: “Aját Jesús oya butayat, as bar tan jácataro,” séhw̃ajacro. Etar Jesús oya butajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jesús oya butayat, cab rehti ab bar chihrjacro. Etat imát ítitan “As bar tan jájacro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Etat Jesusat cat bar itchacro. Ima ajcan cámura cut uw tan jajac itchacro. Etar cab rehti ey wihara ac wari cuar wajacro: —¿As oya biyat bútayi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Etat ima chiwat Jesús quin wajacro: —Behmát ítitan uw ricán to binat úcaro. Etara ¿bitara reht “¿Biyat as bútayi?” waca? ");
INSERT INTO tuf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Etat Jesús uw wahitchacro, biyat ima oya butajáctara istín acu. ");
INSERT INTO tuf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wiw̃á imát ítitan, Jesús ajcan urán cut bar tan jajac, itchacro. Etar Jesús cac cahmar wijacro. Wiquír ayot tiu rabar Jesús cac cahmar cuscar cut chihrjacro. Chihrír wajacro: —Aját bah oya butajacro, as tan jaquin acu. ");
INSERT INTO tuf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Etat Jesusat ey quin wajacro: —Wiw̃ú, bahat sehw̃at “Jesusat as bar tan jácayqueyra,” séhw̃ajacro. Eyta séhw̃ajac etar aját bah bar tan jájacro, -wajacro-. Tan wan ítuwi. Ohbac biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesusat wiw̃á jor tew̃yat icar, uw béhjecro. Cara usi bin uw wijacro. Jairo quin wiquír wajacro: —Bah waquíj bar chinjacro, -wajacro-. Siw̃quib acsar roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Uwat eyta wajác cuar, Jesusat ria cátiro. Cati cuar Jairo secuac usi cara quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","—Ay wini rehti jaw̃i. Aját bah waquíj bar tan jácayqueyra, séhw̃awi, wajacro. Jesús acsar be rabar uw ricán ey questoc be áytiro. Pedro cat, Santiago cat, Juan cat etan eyin im owár ben acu ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo usi cujacro. Cur ítitan, uwan síhw̃anatro. ");
INSERT INTO tuf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Cahujinra ócaro. Cahujín abáy cohwro. Etat usi raújacro. Rauwir, uw quin wajacro: —Oti jaw̃i. Cohwti jaw̃i, -wajacro-. Sah chinti cuar camro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesusat eyta wacayat, uwan ey buror sischacro. Eyta cuar Jesusat uw bahnaquin watar áyjacro. Cahujín watar ayjac cuar sah tet cat, ab cat, im owár rojóqueyin cat sah chein cuitar raújacro. ");
INSERT INTO tuf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rauwir sah chinjaquey atcar yehw̃jacro. Atcar yehw̃ír wajacro: —Talita cumi, wajacro. Ey ajca uchta waquíc ojcor wacaro, “Sahú, aját wacaro, yehnwi.” ");
INSERT INTO tuf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jesusat eyta wacayat, cab rehti sah bar yehnjacro. Yehnár sahu sahu bijacro. Tetát cat, abát cat eyta istír ojc sijacro. Jesusat sah estají chácyeyan bara dócero. ");
INSERT INTO tuf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Etar Jesusat wajacro: —Cahujín quin ehcuti jaw̃i, -wajacro-. Sah quin ira wiw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús acsar bijacro. Bir car ima pueblo cut cujacro. Ima chiwa cat Jesús owár béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ima pueblo cut cur car, tan jaquin ricar cuanyat, secuac usi siw̃in raújacro. Jesusat siw̃ay yehnyat, ricá to binat rahjacro. Rahcuír ub yehw̃jacro. Ub yehw̃ír rahra rahra wajacro: —Sera eyat eyta siw̃quey ¿bi cut sínjactara? ¿Bi urá cuitar ub bár bi sicor ub chi chaqui? ¿Cuicát ruhw̃ujaquey bi urá cuitar sicor tan chaqui? ");
INSERT INTO tuf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uya tabla óroquibro. Uy abá Maríaro. Santiago cat, José cat, Judas cat, Simón cat ey acu rábinro. Ey chitín cat usár is owár itro. Etar éyinat Jesús ria cátiro. ");
INSERT INTO tuf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Etat Jesusat eyin quin wajacro: —Uw bahnáquinat Sir chihtá ehcuquib ojcor ay wacaro. Cajc bahnác cutar ítquinat eyta wacaro. Eyta cuaquir ehcuquin imár cajc cut ítquinatra étai síhw̃atiro. Imár cáyinatra, imár usi ítquinatra étai síhw̃atiro. Etai wátiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eyta cuácayat Jesusat Sir urá cutar erar ricá táhnaqui tan chátiro. Yarquin birách bár bin tan chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús ub yehw̃jacro, uwat ima tamo síhw̃ati rehquít, ima chihtá cati rehquít. Etar acsar pueblo istiy cutar cat, pueblo istiy cutar cat uw siw̃ot béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Etar Jesusat ima chiwa doce eyin ima quin chíjacro. Chiwa Jesús quin behquir Jesusat eyin bucáy awan wan cuar áyjacro. Aya rabar eyin quin cuicá uquin urá wíjacro. Camur wíjacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Ata béowi. Pan cat, iroc cat beti jaw̃i. Ba ray cat beti jaw̃i, -wajacro-. Tec étana béowi. ");
INSERT INTO tuf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ques barcat tas chaquir béowi. Camís bucayra chati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pueblo cuitar uwat ubach wícayat, im esar ítuwi. Acsar bequic ocso tas im esar ítuwi. ");
INSERT INTO tuf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eyta cuar bi pueblo cutar ba ajca bár chácyeyra, ba chihtá ráhctieyra, ey pueblo cutar uchta yajw̃i. Ba acsar bécayat, ba quescar ojcor cajc bur béquiquey, umít béquiquey quihu ter bahwi. Uw éyinat ba Sir chihtá ehcuquin ruhw̃ujác ques Sirat imár cuecwata istayta acu eyta yajw̃i, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesusat ayat chiwa béjecro. Beya rabar uw quin wajacro: —Urá tehmowi. Urá ay chaw̃i. Ay bár yajquíc etwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Beya rabar uw urá sar bin cuicán to uc si áyjacro. Uw yárqueyin cuitar aceite chájacro. Chaquir eyin tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesusat yajquíc ojcor tew̃ic rey cara ajca Heródesat rahjacro. Jesús ojcor tew̃ic uw bahnáquinat rahjacro. Cahujinat Jesús ojcor wajacro: —Uya Juanro. Uw rih sar siw̃quibro. Juan chinjác cuar, sicor yehnjacro. Eyta cuácayat ajc cutar, camur cuitar istiy icúr bi ay yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Eyta cuar cahujinat wajacro: —Uyan úchicri Elías Sir chihtá ehcúquibro, wajacro. Istiyát wajacro: —Sir chihtá ehcuquib cahmor bin eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eyta cuar Heródesat wajacro: —Eyan Juanro. Aját cuisa cuijaquey sicor yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Récaji Juanat Herodes cahmí icar tew̃jáquinro. Heródesat ima rab Felipe wiya siwir yehw̃jáquinro. Wiw̃á eya ajca Herodíasro. Eyta siwir yehw̃jác ques Juanat tew̃jáquinro. “Bahat yéhw̃ajar bi yehw̃jác rehquít, Sir táyatro,” wajáquinro. Eyta wajác rehquít Herodíasat Juan quehsujacro. Ey yau cun rehjecro. Etar Heródesat Juan caquin acu soldádoin áyjaquinro. Cárcel icar tun áyjaquinro. ");
INSERT INTO tuf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodíasat Juan yau ay cun rehjecro. Eyta cuar, Heródesat yau áytiro. Heródesat ítitan Juanat ay yajcaro. Ur ayro. Eyta istíc rehquít Juan yauwin acu ay wíniro. Ey síujacro. Juanat tew̃ic Heródesat rahcuír icúr séhw̃atatara ístajar rehjecro. Eyta cuar Juanat tew̃quey bucoy, bucoy ahní rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Itchareht, yájcajareht, Herodes yehnjác ricar cuanyat fiesta yajacro. Gobierno carin, soldado cárina, Galilea uwa cárina, iran cuít yayín sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Etatan Herodías wacjá wiw̃ara rauwir, eyin cac cahmar quinjacro. Quinyat Heródesan ahní rehjecro. Uw cat ahní rehjecro. Eyta ahní rehquír Heródesat cahbara quin wajacro: —Bah quinjác tehmár ¿aját bah quin bi wícataca? ");
INSERT INTO tuf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ehchí quinjác rehquít, bah icúr rácaratara as quin waw̃i. Wacayat aját bah quin ey wíquinro. Aját Sir ub cahmor wacaro. As quin bahat bi chícayatan, aját ey wíquinro. As cajc bitác istiy chícayatan eyta tas wíquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Etar cahbár im ab quin bir wajacro: —¿Aját icúr chiátaqui? wajacro. Etat Herodíasat Juan yau cun rehquít wajacro: —Juan uw rih sar siw̃quib cuisa cuiquír plato cuitar roquín chiwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Etat cahbár sicor inchajin bir Herodes quin wiquír wajacro: —As ac Juan uw rih sar siw̃quib cuisa cuiquir row̃i, -wajacro-. Cuis ey cuiquír plato cuitar usár row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Juan uw rih sar siw̃quib cuisa cuiquin wacayat, Herodes cuean to rehjecro. Cue rehjéc cuar, uw ub cahmor, Sir ub cahmor icúr rácaratara, ey wiquin wajáquinro. Eyta chíhtara wítira bitách yájcajatro. Imát wajaquin tehmó cun batro. Etar eyta roquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Etat soldado cárcel beyin áyjacro. Juan cuisa cuiquír ucay áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Etar soldado ey cárcel cut bijacro. Erar Juan cuisa cuijacro. Cuiquir plato cuitar rojocro. Roquír cahbár quin wíjacro. Etar cahbarat acsar ab quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan uw rih sar siw̃quib yauyat, ima chiwat rahjacro. Rahcuír ey chein ucay béjecro. Uquir beyar ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesusat chiwa áyjaquin sicor béhjecro. Behquir imarat yajáqueyan, síw̃jaqueyan Jesús quin bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús quemir uw ricán to wic bicaro. Eyta cuácayat, behquic istiti beyic istítiro. Uw ricán to rehquít Jesusin bitách yáyajatro. Etar Jesusat eyin quin wajacro: —Bar jaw̃, uw bár cuitara tan jacay. ");
INSERT INTO tuf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesusat eyta waquír, canó sar raújacro, chiwa owár. Canó cut uw bár cut béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jesusin canó cut becayat, uwan to binat eyin itchacro. Biyin bectar itchacro. Etar pueblo istiy cut bin, pueblo istiy cut bin uwan choni Jesús questoc béjecro. Quina cutar becayat eyin Jesusin cahmor cujacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús riw cajc cut cur, canó sar bin riw cajc cut waajacro. Waar itit, ácaman uw ricán to sécuajacro. Jesusat ítitan, óbasan obir yajquib tayor eyta uw cat éytaro. Obasan imár birar beyátatara ehcún acu uw tayor eyta uw eyin cat eyta uw táyoro, imár siw̃in acu. Eyta istír eyin tamo sehw̃ar cue rehjecro. Etar eyin chiht istiy, chiht istiy síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Itchareht yájcajareht tin bicayat, ima chiwat Jesús quin wajacro: —Isan ubach bár cuitatro. Usatra uw ítitiro. Ahra bar tin bicaro. ");
INSERT INTO tuf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Eyta bira uw sicor aywi. Ubach cut beyin acu aywi. Pueblo cut beyin aywi. Imár yayín acu ira wahy aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Etat Jesusat chiwa quin wajacro: —Behmarat eyin quin ira wiw̃i, wajacro. Etat chiwat wajacro: —Bahnáquinat conu yayín acu doscientos denario ahuyat cat tíhrajatro, -wajacro-. ¿Isat ey wahy beyátayica? Etat owaran canarán sihyór abi ruoyat doscientos denario túnjaquinro. ");
INSERT INTO tuf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Etat Jesusat wajacro: —¿Bayan pana bítaca? Wahitay béowi, wajacro. Etat éyinat pan bítatara wahitay béjecro. Istír Jesús quin wajacro: —Is pan esí étacro. Rih ruwa cat bucátacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Etat Jesusat uw banar cuitar chihr áyjacro. Cahujín ajquír, cahujín ajquír chihr áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chihr ayat ajquír cuisa cien awan chihrjacro. Cuisa cincuenta awan chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Etar Jesusat pan esí bin cat, rih ruwa bucáy bi cat at cut yehw̃jacro. Yehw̃ír cuacúr wahitchacro. Pan yehw̃ír, Sir quin “Bah ur ayro,” wajacro. Eyta waquír pan cotchacro. Cotír chiwa at icar pan wíjacro. Uw owár tahw̃ún acu wíjacro. Wícayat, tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Etat cat rih ruwa bahnaquin owár tahw̃ujacro. Tahw̃úr, bahnáquinat yájacro. Uw bahnáquinat yarsa yájacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yaya tihryat, pan cajcar cat, rih ruwa cajcar cat sicor sécuajacro. Sécuajac ey chocha doce cuin tas ehnchacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ira yájaqueyinan saw̃ujacan sérinan cinco milro. ");
INSERT INTO tuf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesusat pan tahw̃úr cab rehti ima chiwa quin wajacro: —Canó cuitara riw rahray as cahmor béowa. Betsaida cun béowi, wajacro. Chiwa be yiror Jesusat uw bahnaquin sicor imár usi áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eyta waquír Sir ojcor conín acu cubar cuitar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tínora Jesús riw cajc awat im ístitro. ");
INSERT INTO tuf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Canó eyra riw úbutro. Jesusat ítitan, canó beyin ac canarán tahnacro. Canó biquic acam wihár séroan bitác bitiro. Etar in béyajatro. Eyta cuácayat sisbúr cohwyat, Jesús ima chiwa ques caquin bijacro. Ica cuitar sahu sahu bir eyta, Jesús rih arcutar eyta sahu sahu bijacro. Jesusan acsar ben yajquín eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Eyta cuar ima chiwat Jesús itchacro. Riw arcutar raquíc itchacro. Bahnáquinat istír ojc sijacro. Abáy roojocro. Chein ajc síhw̃ajacro. Etar ey ayot cohwjacro: —¡Chein ajc racaro! cohwjacro. Eyta cohwyat, Jesusat eyin quin wajacro: —Rooti jaw̃i. Ojc siti jaw̃i. Asró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Etar chiwa owár canó sar raújacro. Jesús canó sar rauyat, séroan cab rehti chihrjacro. Sero chihryat éyinan ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eyinat ítitan, Jesusat pan esí bin sicar pan cohní chájacro. Eyta itíc cuar Jesusat Sir urá cut bahnác bar yajcata éyinat anto síhw̃atiro. Ay ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Acsar canó cuitar béjecro. Genesaret cajc cut cujacro. ");
INSERT INTO tuf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Erar cur car canó questajacro. Canó sar bin waajacro. Waacayat uwat ítitan, eyan Jesusro. ");
INSERT INTO tuf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eyta istír ey cajc bahnác cuitar quinjacro. Jesús wijác ehcwáy quinyat, erar itquin bahnáquinat Jesús quin yarquin cat, cuercurin cat bahnaquin rojocro. Caros cutar rojocro. Ey cutar Jesús birar bijactar tew̃ic rahcuír erar rojocro. ");
INSERT INTO tuf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bucoy bucoy pueblo cutar bicayat cat, rasá cutar bicayat cat, uw itic cutar bicayat cat uw yarquin ey ibt aw̃at chájacro. Chaquir Jesús quin conjacro: —¿Bah oya bután ajc waátaica? wajacro. Etar bíyinat butajáctara, eyin bar tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Etar fariséoin secuar Jesús quino béhjecro. Bachan chihtán siw̃quin cat pueblo Jerusalén bin fariséoin owár béhjecro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ey quin cur ítitan, Jesús chiwan atum sucti ira yácaro. Fariséoinat restá sucuír eyta éyinat restá eyta sucti ira yácaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Etat owaran fariséoin cat, judíoin cat, bahnaquin cat atum sucti yátiro. Cahmor werjayín bach auti acu ira yayín cahmor atum sucro. ");
INSERT INTO tuf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rasá cut bin wiquír, anto súctieyra ira yátiro. Bach istiy cat, istiy cat chero. Bronce toca cat, ruca cat, soya cat sucro, bach auti acu. ");
INSERT INTO tuf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eyta ityat fariséoinat cat, bach síw̃quinat Jesús quin wajacro: —Bah chiwan werjayát bach chajac chihtá cut ítitiro. ¿Bitara rehquitca? ¿Bitara rehquít atum restá ji bin cut ira yaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Etat Jesusat wajacro: —Uch síhw̃awi. Urá bucáy binu, Sir chihtá ehcuquib Isaíasat úchicri ba ojcor uchta cuihsú bahjacro: Uch uwat imár cuw cutaran “Sira ur ayro,” wacaro. Eyta cuar ur ícatra Sir tamo síhw̃ati itro. ");
INSERT INTO tuf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eyinat Sir tamo sihw̃ac waquíc cuaquir eyta cat batro. Cahujín quin Sir chihtá siw̃ic waquíc cuar, uw imár chihtá siw̃ro, Sir carit cutar eyta cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Baat werjayín chihtá yajquín acu Sir chihtá cati ruhw̃uro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Acsar Jesusat eyin quin wajacro: —Behmarat werjáy chihtá yajquín acu Sir chihtá cati ruhw̃uro. ¿Bitara rehtqui? ");
INSERT INTO tuf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Uchicrias Moisesat uchta wajacro: “Bah tetín ajcá ji béowi. Bah abín ajcá ji béowi. Bíyatan ima tet cahm icar, ima ab cahm icar ajc ahsín téw̃yatan, ey ques icar yauwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eyta cuar ba fariséoinat, ba bachan chihtán síw̃quinat uchta siw̃ro: “Bíyinat uchta wacayat: ‘Tetú, Abú, aját bah wiquin bin, Sir quin wiquin acu yajc chájacro,’ wacayat, ");
INSERT INTO tuf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","eyinat tetín abín obir yájcajatro,” wacaro, baat. ");
INSERT INTO tuf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Etarwan behmár chihtá acsar, acsar yajc ayin acu uw quin Sir ima chihtá tehmó ayro. Sir chiht istiy, chiht istiy baat eyta tehmoro, wajacro, Jesusat fariséoin quin, bachan chihtán síw̃quin quin. ");
INSERT INTO tuf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eyta waquír uw bucoy ima quin chíjacro. Eyta chiír uw becayat eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","—Bahnáquinu, aját tew̃quey rahcwi. Rahcuír caw̃i, -wajacro-. Uwat cac icar yaquey cuitatrun urá ay batra rehca báreyra. Cuat uwat cac icar bin tew̃quey cuitatrun, imát yajquey cuitatrun urá ay bár chácaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Biyin cucajá chétara ey chihtá rahcwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Etat Jesús usi raújacro. Uw ricán to bin cham bahjacro. Usi rauyat ima chiwat ey quin táyojocro: —¿Bahat siw̃jaquey bi ojcor tew̃qui? ");
INSERT INTO tuf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Etat Jesusat chiwa quin wajacro: —¿Ba cat urá bár waátaqui? ");
INSERT INTO tuf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Uwat watar bin cac icar icúr yáctara ey cut ur ay bár chácajatro. Cac icar yácayat urá bow̃ icar raútiro. Atuc sar rauro. Acsar bucchír aw̃at bicaro. Etar acsatra sicaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesusat eyta waquír cutar ira bahnacan ricúm batro. Restá batro, wajacro. Acsar uchta wajacro: —Baat eyta sínata bin yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cuatán uwat cac icar ay bár tew̃yat, ima urá ay bár rehcaro. Uwat tan icar urá sar ay bár síhw̃aro. Eyta ay bár sihw̃ar, acsar ur ay bár yajcáy yinro. Yehw̃ti bin owár isár yajcaro. Cahujín ohnor bes yajcaro. Uw yauro. Cahujinay wiya bes yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Cahujinay racar isoro. Ay bár yajcaro. Uw cayar yajcaro. Uw cahmor rooti ay bár yajcaro. Es yajcaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Carin cac cahmar cahujín cahmí icar sucuar tew̃ro. Cahujín ojcor téw̃ajar bin tew̃ro. Imaran ayan cuít síhw̃aro. Urá bár bin éytaan wan yajcaro. Túrarir yajcaro. Eyta ay bár yájqueyan uwat cahmoran urá cut eyta yajquín síhw̃aro. Eyta sihw̃ar yajcaro. Eyta yajquey uw urá ruhw̃uro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Etar Jesús erar bin acsar bijacro. Tiro cajc cut, Sidón cajc cut cun bijacro. Erar cur, usi raújacro. Uwat istiti acu usi raújacro. Eyta cuar uw cahmor bitách rúhcuajatro. ");
INSERT INTO tuf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cab rehti wiw̃arac Jesús quin rajacro. Ey wiw̃á wacjá wiw̃arac conu bin cuicá chero. Ey wiw̃á cajc istiy bin uwro. Cajca Sirofenisa uwro. Ey wiw̃át Jesús wiquíc chihtá rahjáquinro. ");
INSERT INTO tuf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Eyta rahcuír Jesús quin wiquír ey ques acor cuscar cut chihrjacro. Cuscar cut chihrír Jesús quin wajacro: —As waquíj urá sar bin cuicá uc aywi, conjacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Etat Jesusat wajacro: —Uwat imár sasá yayín acu ira ibtu wícaro. Pan sasát cohtá binan siwir bayar quin wícajatro, -wajacro-. Sasáy bin bayar quin witi eyta, aját israelin ac ay yajcata bi cahujín ac yajcátai batro. Aját bah uw cuitar yajcátai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Etat wiw̃át wajacro: —Caru, bahat uní wacaro. Eyta cuaquir sasát pan cohcayat, pan cac bur tijcác ey báyarat mesa cahmor cohcaro, -wajacro-. Eyta chihtara as cuitar conu yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Etatan Jesusat ey quin wajacro: —Chaucu, bahat ay wajacro. Etar sicor biwi. Bah waquíj ur icar bin cuicá bar waa bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Etat wiw̃á sicor usi bijacro. Usi cur ítitan, waquíj aw̃at cut camro. Cuicá bar waa bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Etar Jesús cajc Tiro bin sicor waar rajacro. Cajc Sidón tiw̃, Decápolis pueblo istiy, pueblo istiy tiw̃ Galilea riw cajc aw̃at cujacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cucayat uwat sera cucáj bár bin Jesús quin rojocro. Ser eyat cat ay téw̃ajatro. Roquír Jesús quin conjacro: —Uy cucáj chi rehquín acu, ay tew̃ín acu bahat uy cutar ba atcar cut bútawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Etat Jesusat cucáj bár bin ajquír uw bár cut béjecro. Erar cur Jesusat ima at ub sera cucáj ucar icar chájacro. Cana rihar cat tijcajacro. Tijcár seray cuw butajacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Butar cuacúr aba wahitír camur sijacro. Camur siir wajacro: “Ebata,” wajacro. Eyta waquíc eyan uch ojcor wacaro, “sarwa,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eyta wacayat cucáj bár bin cucáj bar sarjacro. Cuw cat bar tan jájacro. Ay tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Etat Jesusat uw quin wajacro: —Cahujín quin ehcuti jaw̃i, wajacro. Jesusat “ehcuti jaw̃i,” wacayat, éyinat cuít ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Uw ub yehw̃jacro. Ojc sijacro. Ub yehw̃ír wajacro: —Jesusat bahnác ay yajcaro, -wajacro-. Eyat Sir urá cut cucáj bár bin cucáj chi chácaro. Téw̃ajar bin tew̃ín acu chácaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Biráy bár cuanyat, bucoy ricán to bin Jesús quemir sécuajacro. Sécuajaqueyin ira batro. Uwa eyta sécuayat, Jesusat ima chiwa chíjacro. Chiír eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Aját uch uw tamo séhw̃aro. Eyin is owár bay cuanjacro. Ahra éyinat icurí yáyajatro. ");
INSERT INTO tuf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ira yati usi áyeyra, ibit aw̃at yayat bar cuácayqueyra. Cahujín cajcan abáy cut bin usár béhjecro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Etat ima chiwat wajacro: —Usár ubach batro. Uwa ítitiro. Uwat yayín acu icurí batro. Ricán to rehquít, bi wícajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Etat Jesusat ima chiwa quin wajacro: —¿Baan pana bítaca? wajacro. —Pana cucuiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eyta wacayat Jesusat uw ricá quin, ica sar chihr áyjacro. Etar Jesusat pan cucuí eyan caquir wajacro: —Siru, bahat is obir yajacro. Bahat isat cohn acu wíjacro, wajacro. Eyta waquír, pana cotchacro. Cotír car, uw quin tahw̃ún ima chiwa at icar wíjacro. Etar chiwat acsara uwa bahnaquin quin tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rih ruwa cat conu chero. Etar Jesusat Sir quin conjacro: —Siru, bahat is ruwa cat wícaro. Bah ur ayro, wajacro. Sir quin conár ima chiwa quin wajacro: —Rih ruwa cat uw quin tahw̃uwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eyta wacayat chiwat rih ruwa uw quin tahw̃ujacro. Etar bahnáquinat yarís cohjocro. Cohr car yayar car, ira cajcar ey sicor sécuajacro. Ira cajcar sécuajacan chocha cucuí biyan cuin tas sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ira cóhjoquin saw̃ujacan uw cuisa cuatro mílcuano. ");
INSERT INTO tuf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Etar Jesusat uwan sicor imár usi áyjacro. Ayir cab rehti ima chiwa owár canó cuitar rauwir, cajca Dalmanuta cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Riy istiy fariséoin Jesús quin béjecro. Cur tecuay yinjacro. Jesús quin uchta wajacro: —Is cac cahmar Sir urá cut, camur cut bahnác yajcata ehcún acu ey yajw̃i. Isat cuacúr Sir imát bah ayjac chihtá istín ac eyta yajw̃i, wajacro. Jesús cayar yajquín acu eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Etat Jesusan cue rehjecro. Cue rehquír camur siir wajacro: —¿Ah uch uwa bitara reht Sir urá cut, camur cut bahnác yajcata ehcún acu as quin yajc ayqui? Sirat áyjactara, Sirat áytitara, ey istín sihw̃ar as quin eyta yajc ayro. Aját ba quin wacaro. Eyta yajc ayic cuar, baat istín ac aját éytara yájtiro. ");
INSERT INTO tuf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eyta waquír eyin cham bahjacro. Canó sar raújacro. Rauwir riw rahray bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bécayat chiwat pana beti tan chinjacro. Canó sar pan ubistanacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Etar Jesusat be rabar eyin quin uch síw̃jacro: —Yají chaw̃i. Cuaya sinti jaw̃i. Fariséoin buc réhquiban bútati jaw̃i. Herodes buc réhquiban bútati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eyta wacayat chiwat rahra rahra wajacro: —Isat pan roti etar eyta wacaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eyta rahra rahra tew̃yat, Jesusat itchacro. Eyta istír wajacro: —¿Bitara reht pan bahjác ojcor rahra rahra tew̃qui? ¿Ba ur icar anto istítica? ¿Aját wajacan anto ráhctiqui? ¿Ba urá bárica? ");
INSERT INTO tuf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ba ub ji cuar ¿istítica? Cucáj chi cuar ¿ráhctica? ¿Aját yajaquey tan chinyi? ");
INSERT INTO tuf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pan estác cuar, aját serin cuisa cinco mil yarís yayín ac wíjacro. Eyta wícayat ¿ira cajcar baat chocha bita bin cuinyi? Etat éyinat wajacro: —Isat ira cájcara chocha doce cuinjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bucoy cat pana cucuí etan cuar, aját serin cuisa cuatro mil yarís yayín ac wíjacro. Eyta wícayat ira yajac cajcar baat chocha bita bin cuinyi, táyojocro. Etat éyinat wajacro: —Isat ira cajcar chocha cucuí cuinjacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Etar Jesusat wajacro: —¿Bitara reht as chihtá orac ráhctiqui? ");
INSERT INTO tuf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ey yahncút pueblo Betsaida cut cujacro. Erar cur uwat ub bár bin Jesús quin béhjecro. Behquir conjacro: —Ub bár bi ub ji rehquín acu bútawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eyta wacayat Jesusat ub bár bi eya ator béjecro. Pueblo acsar béjecro. Erar cur Jesusat cana rihar ey ub cut tijcajacro. Tijcár atcar ser ey cutar chájacro. Atcar chaquir wajacro: —¿Bahat ub cut itqui? ");
INSERT INTO tuf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Etat ser eyat cuisa yehw̃ír wahitchacro. Cuisa yehw̃ír istír wajacro: —Ee, aját uw itro. Uw it cuar eyin cárucuan wanro. Cárucuir quir cuaquir bécaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Etat Jesusat ey ub cutar atcar bucoy chájacro. Eyta chácayat serat bucoy ay wahitchacro. Etat sicor ub ji rehjecro. Bahnacan ay itchacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Etat Jesusat ey sicor im usi áyjacro. Pueblo cut tiw̃ biti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Acsar Jesús ima chiwa owár Cesarea de Filipo cajc cun béjecro. Beya rabar Jesusat ima chiwa quin táyojocro: —Uwat waquít: ¿Asan rehrcá? wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Etat éyinat wajacro: —Cahujinat waquít, bahan Juan uw rih sar siw̃quib yarjáqueyro. Cahujinat waquít, bahan úchicri Elías bijaquin sicor wijacro. Cahujinat waquít, bahan istiy úchicrias Sir chihtá ehcúquib yarjaquey óraro. ");
INSERT INTO tuf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Etat Jesusat wajacro: —Baat waquitra, ¿asan rehrcá? wajacro, ima chiwa quino. Eyta táyoyat Pédroat wajacro: —Bahan Crístoro. Sirat bah áyjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Etar chiwa bahnaquin quin wajacro: —Istiy quínoi as ojcor ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Etat Jesusat im acam bitara rehcátatar ey siw̃ay yehnjacro. Uchta wac siw̃jacro: —As Uw Síuquib uwat bitara útara ruhw̃áyqueyra. Judío werjayinatán, sacerdote cárinatan, bachan chihtán síw̃quinatan as ria yajti jácayqueyra. Etar as yauwáyqueyra. As yauyat bay cuanyat as sicor estají yehninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesusat chiwa quin ruhcti eyta ehcujacro. Eyta ehcwayat Pédroat ey ajquír béjecro. Jesusat eyta wati acu Pédroat tecuay yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Etat Jesusat ac wari cuar chiwa cahujín itchacro. Eyin istír Pedro tecua rabar wajacro: —Baha Satanás uritro. Eytara tew̃ti jaw̃i. Bahat eyta tew̃yat uw chihtá cuitar tew̃ro. Sir chihtá cuitatra éytara téw̃ajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Etar Jesusat uw ricán to bin cat ima chiwa cat chíjacro. Secuar eyin quin wajacro: —Bíyinan as chiwa yin cúntara, imár chíhtara síhw̃ati jácataro. Imár chihtá cut yajti cuar as chihtá yajcátaro. As chiwa cháqueyin as ques icar uwat yauwata óraro. Bíyinan as ques icar eyta yauwata tacat as wácati ajcá ji bécayat, eyin as chiwa chácataro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Cahujinat imár yauwic cahmar roocayat, as chihtá cácajar óraro. Bíyinatan eyta cati cuácayatan, eyin sácataro. As ajca rahcti reht sácataro. Cuatán as chihtá ques, as chihtá ay bi ehcúc ques uwat cahujín yauwata óraro. Bíyinan as chihtá ques yaúyata, aját eyin síwayqueyra. Síuyat eyin Sir jor cuacúr ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Uw cahujinat ray cat, oya cat, cajca cat cuít sécuata óraro. Eyta secua cuar, ¿im eyta cab oca icar béjeca? Eyta bahnác chiw̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Raya cat, oya cat, cajca cat chiw̃áyqueyra. Ima ajc cat chiw̃áyqueyra. Eyta cuácayat ray cat, oya cat, cajc cat icúr acui batro. Ey cuitar ba síwajatro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aha uch Sir tamo síhw̃ati bin uw, ur ay bár bin uw, bíyinan uw cahmor áywini rehquít “as Jesús chíwai bár” wacayat, as chihtá ehcuti jácayat, aját rahra cat eyin ojcor “as chíwai batro,” waquinro. Asan Uw Síuquiban cuacúr bin sicor wiquinro. Sir as Tetáy wan beo beo tan cut wiquinro. Sir cuacúr cacmín owár wiquinro. Eyta wicayat, “eyin as chíwaro,” waquín acu roótaro. ");
INSERT INTO tuf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aját ba quin wacaro. Sir cara rehquey cutar Sir iman uw ubot cámuran cuít waac ocso tas usár itquin cahujín sácati ítayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Etar teray cuanyat, Jesusin cubar icar béjecro. Pedro cat, Juan cat, Santiago cat béjecro. Etan béjecro. Erar cur eyin ub acat Jesús arjacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aryat oya cuas beo beo waajacro. Cajc bahnác cuitar oya sucuír cuasan ey owara bitách waájatro. ");
INSERT INTO tuf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Etat eyin acat úchicri cohtín Elías cat, Moisés cat waajacro. Waar car Jesús jor tew̃jacro. Rahra rahra tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Eyta tew̃yat Pédroat Jesús quin wajacro: —Síw̃quibu, isan usaran yarisro. Isat chohcha bay tuw̃ín acu ajc waawi, -wajacro-. Istiy bah acu, istiy Moisés acu, istiy Elías acu tuw̃inro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesús chiwa ojc sijacro. Etar bi wacátatar istiti rehjecro. Etar Pédroat eyta wajacro. Eyta wacayat icar, bowaramát eyin ehyó cay tunjacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eyta cuácayat, bowarám tan sar Sirat wajacro: —Uchan as waquijró. Aját eyan sehnacan cuitro. Ey ajc rahcwi. Ey chihtá caw̃i, wajacro, Sir imát. ");
INSERT INTO tuf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Etat Pédroinat wahitchacro. Ititan imarin owár cahujinra batro. Jesús im ístitro. ");
INSERT INTO tuf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Etar isur sicor béjecro. Beya rabar, Jesusat eyin quin wajacro: —Baat cubar icar itcháqueyan ehcuti jaw̃i. As chinír sicor yehníc ocso tas cahujín quin ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Etar éyinat itchaquey ojcor cahujín quin ehcútiro. Eyta cuar imarin owár wajacro: “Jesusat chinír sicor yehníc wacayat, ¿bi ojcor tew̃qui?” wajacro, rahra rahra. ");
INSERT INTO tuf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Etat éyinat Jesús quin wajacro: —Bachan chihtán síw̃quinat wacaro: “Cristo yehnín cahmoran Elíasan cahmor wicátaro,” wacaro. ¿Bitara etar eyta waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Etat Jesusat wajacro: —Uní wacaro. Elías ibtu wicátaro. Cristo yehnín cahmor bahnác oron wicátaro. Sir carit cutar uchta cat wacaro: “Uwat Uw Síuquib abáy ruhw̃áyqueyra. Ey ria yajti chácayqueyra,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aját ba quin wacaro. Elías bar wijacro. Eyta wijác cuar, uwat ey ruhw̃ú cun rehquít, ey ruhw̃ujacro. Sir carit cutar ey eyta ruhw̃ata cuihsujác eyta ruhw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eyin isur chiwa cahujín quin béhjecro. Behquir itit, eyin quemir ricán to sécuajacro. Bachan chihtán síw̃quinat eyin owár técuaro. ");
INSERT INTO tuf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús wicayat uwat ey itchacro. Istír ub yehw̃jacro. Ey acam quinír tihrjacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tihryat Jesusat eyin quin táyojocro: —¿Ba bi ojcor tew̃qui? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Etat uw tac icar bin ser istiyát wajacro: —Síw̃quibu, aját as wacjá bah quin roquiri. As waquíj cuicát ruhw̃uro. Cuicá ruhw̃úc rehquít bitách téw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cuicát as waquíj bucoy bucoy cuácaro. Bítajat cuácayat as waquíj ica wihár técaro. Técayat cac sar orjir waacaro. Ruhr cuech cuech cohcaro. Eyta sibarán bahnác sinictin bicaro. Waquíj roquír aját ba chiwa quin conjacro. Cuicá úcayta acu conjacro. Eyta cuar éyinat bitách uc áyajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eyta wacayat Jesusat wajacro: —Ah cutar uwat Sir tamo síhw̃atiro. Chihtá uní bi tehmoro. As ba owár úchicri ítchacro. ¿As chihtá cuitar yajcata bin baat bitat sinin yajca? ¿Baat sinti cuácayat, aját caban bita síw̃ataca? -wajacro-. Bah wacjá as quin row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eyta wacayat uwat ser ey wacjá Jesús quin rojocro. Rocayat cuicát Jesús itchacro. Ityat cuicát sah ey en áyjacro. Ica wihár téjecro. Ic icar yau técayat wihcajacro. Cac sar orjir waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Etat Jesusat tet quin wajacro: —¿Eyta yauwáy yehnjaquey bita cuanyi? táyojocro. Etat tetát wajacro: —Sah conu jatan im éytaro. ");
INSERT INTO tuf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Etar cat cuicát as sah yauwin acu rih sar cat técaro. Oc icar cat técaro. Eytaan bucoy bucoy técaro. Etatar bahat ey bar tan chácatatara is tamo sehw̃ar cue rehw̃i. Is cuitar yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Etat Jesusat wajacro: —Tan chácatatara, wati jaw̃i. Bíyinat aját icúr bi bar yajcata síhw̃actar eyin acu aját eyta yajquinro. Eyta síhw̃aquin acu aját icúr yájcajatrun batro. Bahnác bar yajcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Etat tetát cohwjacro: —Aját sehw̃at bahat cuicá bar uc áyataro. Eyta cuar bahat eyta áyajar séhw̃ati acu as cuitar séhw̃awi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Etat Jesusat ítitan, ricán to bin im ocsor rocaro. Eyta istír Jesusat cuicá quin taniric uchta tew̃jacro: —Cuicú, bahatan sah uchan bitách téw̃ajar chájacro. Bitách ráhcuajar chájacro. Etar aját bah quin wacaro. Sah ey urá sar bin yehnár biwi, -wajacro-. Bir car sicor ey sar rauti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eyta wacayat, cuicát cohwjacro. Cohwír sah ic icar abáy yiwó téjecro. Yiwó ter waa bijacro. Sah ey chéinan wan bahjacro. Uwat eyta istír wajacro: —Bar chinjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eyta cuar Jesusat sah atcar yehw̃jacro. Sah cui yehnín acu atcar yehw̃jacro. Yehw̃yat sah bar yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Etar yahncút Jesús usi raújacro. Rauyat ima chiwat cahujinat rahcti acu Jesús quin táyojocro: —¿Bitár etar isat cuicá ey úcajar rehyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Etat Jesusat eyin quin wajacro: —Cuicá eyta bin Sir ojcor conár cuitar uc teta binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Erar bin sicor Galilea cajc cut tiw̃ béjecro. Erar tiw̃ bécayat, ima chiwa siw̃in acu cahujinat istiti ac béjecro. Beya rabar Jesusat ima chiwa quin wajacro: —Asa Uw Síuquiban cahujín at icar wícayqueyra. Eyta wícayat, éyinat as bar yauwáyqueyra. Yauwir bay cuanyat sicor estají yehninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eyta wacayat ima chiwat bi ojcor tew̃íctara ay ráhctiro. Ay rahcti cuar, ey ojcor tayon yajquít cat ay wíniro. ");
INSERT INTO tuf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bécajareht pueblo Capernaum cujacro. Erar cur usi raújacro. Rauwir car Jesusat ima chiwa quin táyojocro: —¿Ibt aw̃at roca rabar ba rahra rahra bi ojcor tew̃yi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eyta táyoyat chiwa ajc sacac chájacro. Eyinat imár owár biyan caran cuítara ey ques técuajacro. Etar ajc sacac chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Etat Jesús chihrjacro. Chihrír chiwa doce eyin ima quin chíjacro. Béhcayat eyin quin wajacro: —Biyan caran cuít yehn cúntara eya cahujín acu chiwa chácataro. Bahnaquin cuitar yajcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eyta waquír, Jesusat sah istiy cájacro. Caquir sah ey imár tac icar chájacro. Sah ey Jesusat tanor yehw̃jacro. Yehw̃ír eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Bíyinat as chiwa chajac rehquít, sah uchta bi ajcá ji bécayat, éyinat as cat ajcá ji bécaro, -wajacro, Jesusat-. Eyta cat bíyinat as ajcá ji bécayat, éyinat as áyjaquey cat ajcá ji bécaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Etat Juanat Jesús quin wajacro: —Síw̃quibu, isat cahujín itchacro. Isat ítitan, eyat cuicá uc si ayro. Isat rahcuít, uc si ayin acu “Cuicú, Jesús ajc cut aját ba uc ayro,” wajacro. Eyta wajác rehquít isat ey técuajacro. “Eytara yajti jaw̃i,” wánora, isat. Eya is owár bini bár rehquít, eyta técuajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Etat Jesusat Juan quin wajacro: —Eyta técuajar bin técuajacro. Bíyinat as ajca waquír cuitar uwat anto istiti bi yajcayat, eyat as ojcor ay bár bitách téw̃ajatro, -wajacro-. Etara técuajar bin técuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bíyinat is técuati cuácayatan eyan is acu ay binro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Etar cat aját ba quin wacaro. Bíyinat ba as chiwa etar ba quin rih yahn acu wícayat, Sirat eyin quin tan chinti túnayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Sasá cahujín conu cuar as tamo ay síhw̃aro. Bíyinatan sasá uchta bin quin Sir tayar yajc áyatan, yajc áyqueyin acu ay baran tahnác rehcátaro. Eyan anto tayar yajc ayti cuat, chinjaquir waquít yársaro. Iman sasá quin tayar yajc ayti yacúr ocso tijcaquir waquít ay baran etach batro. Ima cucú ques acat anab ub questár car yacúr ocso tijcaquir waquít ay baran etach batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ba at cut Sir tayar yajcata óraro. At cut táyara yajcata rehquíctara atcar cuijaquir eyta jaw̃i. Tayar yajti acu eyta jaw̃i. Cuercuran wan, átcara bár binan wan Sir jor cuacúr ítyatan ayro. Cuat atcar bucáy ji cuar, cab oc icar técayatan ay batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Ba ques cut Sir tayar yajcata óraro. Ques cut táyara yajcata rehquíctara quescara cuijaquir eyta jaw̃i. Tayar yajti acu eyta jaw̃i. Cuercuran wan, quescara bár binan wan Sir jor cuacúr ítyatan ayro. Cuat quescar bucáy ji cuar, cab oc icar técayatan ay batro. ");
INSERT INTO tuf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Ba ub istiy cut wahitír cuitar Sir tayar yajcata óraro. Ub istiy ey cut tayar yajcata rehquíctara, ub ey újaquir eyta jaw̃i. Tayar yajti acu eyta jaw̃i. Ub istanác bin cuercuran wan cuar, Sir cara rehquey cutar ítyatan ayro. Cuat ub bucáy orac cuar, cab oc icar técayat ay batro. ");
INSERT INTO tuf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cab oca cuitar rihmyán yárajatro. Oca tínajatro. ");
INSERT INTO tuf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ruhmir ay rehquín acu oc cut wahnár eyta uw cat éytaan wan ay bár yajquíc etayta acu cuácataro. ");
INSERT INTO tuf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Rauwa ehchícuano. Eyta cuar rauw bahsí bár rehcáyatra, sicor bahsí waayta acu icrí yájcajatro. Baha cat rauwan bahsí binan wan chaw̃i. Cahujín owár técuati ítuwi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Etat acsara rajacro. Judea cajc cut Jordán rih rahray rajacro. Erar cat Jesús quemir ricán to bin sécuajacro. Jesusat uw bitat sécuayat, eyin síw̃jacro. Bucoy bucoy eyta síw̃jacro. Etar uw sécuayat, Jesusat eyin síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Esar siw̃yat, fariséoin Jesús quin béjecro. Fariséoin Jesús urá wahitín ac ey quin táyojocro: —¿Uwat wiya yehw̃ téjerica? ");
INSERT INTO tuf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Etat Jesusat táyojocro: —¿Moisesat bach cáritan, chihtá cáritan cuihsú bahjác cuitar eyta yehw̃ ten acu ajc waaca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Etat éyinat wajacro: —Moisesat uchta yajquín cuihsú bahjacro: “Wiya yehw̃ ten síhw̃ayat, récaji carit cuihswátaro. Cuihsúr wiya quin wiquir car yehw̃ tétaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Etat Jesusat wajacro: —Baat ur ay bár yajquíc et cun bár rehquít, wiya yehw̃ ten ojcor Moisesat eyta cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Récaramra Sirat cajc chac owár echí sera cat, wiw̃á cat chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Eyta cuácayat serat wiya yehw̃ír, tet cat, ab cat báhtaro. Wiya jor ítataro. ");
INSERT INTO tuf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Buc owár itir istanác waacaro. Etarwan yehw̃ír, bucáy bini batro. ");
INSERT INTO tuf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sir chihtá cuitar istanác waacaro. Eyta bira ser eyan, wiy eyan uw chihtá cuitar yehw̃ teti jácataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Etat usi raújacro. Rauwir Jesús chiwat bucoy ey ojcor Jesús quin táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eyta táyoyat Jesusat wajacro: —Aját ba quin wacaro. Bíyatan ima wiya yehw̃ ter car, istiy jor yehw̃yat, Sirat ítitan, ur ay bár yajcaro. Wiw̃á besir yajcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wiw̃á cat bíyatan ima sera yehw̃ tér car, istiy jor yehw̃yat, Sirat ítitan, ur ay bár yajcaro. Sera besir yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Etat owár uwat imár sasá Jesús acu rojocro. Jesusat bútayta acu rojocro. Etat ima chiwat uw quin taniric tew̃jacro. Uchta wajacro: —Jesús quin sasá roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesusat eyta tew̃íc rahcuír, ima chiwa quin wajacro: —Sasá rocayat, síuti jaw̃i. Imár rocáyqueyra. Roquín acu ajc waawi. Sasát Sir tamo sihw̃ar eyta uwat Sir tamo eyta síhw̃ayat, Sir cara rehquey cutar cuwátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aját ba quin wacaro. Bíyinan sasán wan Sir tamo síhw̃ati eyra éyinan Sir cara rehquey cutar bitách cúwajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eyta waquír, Jesusat sasán tanor yehw̃jacro. Yehw̃ír im atcar sasá cuis otar chájacro. Eyta chaquir wajacro: —Síratan baan ay obir yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Etat Jesús acsar ben acu yehnjacro. Ben yehnyat, ser istiy ey quin quinjacro. Cur cuscar cuitar chájacro. Cuscar cuitar chaquir wajacro: —Baha síw̃quiban ayro, -wajacro, Jesús quin-. ¿Aját ay bi icúr yajcátaca, -wajacro-, cuacúr Sir jor etiti ohbac itin acu? ");
INSERT INTO tuf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Etat Jesusat wajacro: —¿Bitara etar asan ay, waquí? Ur ay bin Sir ímaro. Cahujinra batro. ");
INSERT INTO tuf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sirat bachan chihtán cuihsú bahjaquey bahat itro. Uchta cuihsú bahjacro: “Uw yauti jaw̃i. Yehw̃ti bi jor isár yajti jaw̃i. Bes yajti jaw̃i. Cahujín cahm sucuar tew̃ti jaw̃i. Uw cayar yajti jaw̃i. Tetín, abín ajcá ji béowi,” cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Etat serat wajacro: —Síw̃quibu, aját ey chihtá bahnác yajcaro. Conu cuácayat echí aha ocso tas ey chihtá bahnác yajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Etat Jesusat ser ey wahitchacro. Istiran ey sehnác chájacro. Etar wajacro: —Bahat chihtá istanác ey yajcátaro. Bah oya cat, cajc cat bahnác rawi. Rar car, ray túnjaquey oya bár bin quin tahw̃uwi. Eyta tahw̃uyat Sirat cuacúr ba acu ayan cuít bi wícayqueyra. Etar asi jor chihtá sinay biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","“Bahnác rawi,” wacayat, serat rahcuír, cue rehjecro. Ima oyan, rayan, cajcan cuít rehquít cue rehjecro. Cue rehquír car bar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ser ey bi yiror Jesusat ima quemir chiwa wahitchacro. Istír eyin quin wajacro: —Oya ji bin, ray ji bin Sir imát síwata síhw̃atiro. Oya chi, ray chi rehquít imár chihtá cuit siwin síhw̃aro. Etar eyin Sir cara rehquey cutar raúwajatro. ");
INSERT INTO tuf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesusat eyta wacayat, ima chiwa ojc sijacro. Etat Jesusat wajacro: —As chiwu, Sir cara rehquey cuitar rauwin acu cárinat bahnác cham bah cun batro. ");
INSERT INTO tuf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camello cabálloir binro. Eyin sicar úcara icar bitách raúwajatro. Camello sicar ucar icar raúwajar eyta oyin rayin cat eyta Sir quin bitách raúwajatro. Eyta cuar camello sicar ucar icar rauwin yajquír waquít canar etach batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eyta wacayat, chiwat ojc siquir ub yehw̃jacro. Ub yehw̃ír wajacro: —Eytatara ¿Sir quin cuacúr rehrí béjerica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eyta wacayat, Jesusat eyin wahitír wajacro: —Uw urá cuitar bitách raúwajatro. Eyta cuar Sir urá cutar bahnác yajcátaro. Sirat bi yájcajatrum batro. Sir urá cuitar Sir ima cara rehquey cut raúwataro. Sir urá cuitar cat uwat Sirat síwata síhw̃ataro. Etar Sir ima cara rehquey cut raúwataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Etar Pédroat Jesús quin wajacro: —Isan bah chiwa chaquin acu bahnác cham bahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Etat Jesusat wajacro: —Aját ba quin wacaro. Bíyinat as chiwa chaquin ac úbachtara, rábintara, chitíntara, tetíntara, abíntara, sasátara, cájctara cham bahjáctara, eyin ac cuit wícayqueyra. Bíyinat as chihtá ay bi ehcún acu eyta cham bahjáctara aját eyin quin cuít wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Bucoy cat, bucoy cat icar cien wícayqueyra. Aha cajc uch cuitar ubach cat, rabin cat, chitín cat, cochín cat, abín cat, sasá cat, cajc cat wícayqueyra. Eyta cuar uwat eyin as chiwa rehquíc ques ruhw̃áyqueyra. Acsara cat Sir jor cuacúr it áyayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ah ricar quir bin carin rehquír, cajcan teyan Sir imát tehmár car ibsoy chácayat, éyinan chiwa chácayqueyra. Cuat chiwa cat carin rehcáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Etar Jesús chiwa Jerusalén cuwín béjecro. Jesús cat eyin cahmor bijacro. Jesús Jerusalén biquic rehquít, chiwa ojc sijacro. Cahujín cat chiwa questoc béqueyin cat ay wini rehjecro. Etar Jesusat ima chiwa doce bin ima quemir beyin sécuajacro. Beya rabar eyin quin iman uwat bitara ruhw̃átatara ehcujacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Uch rahcwi. Isan Jerusalén cun becaro, -wajacro-. Jerusalén cucayat, asan Uw Síuquib sacerdote carin at icar, bachan chihtán siw̃quin at icar wícayqueyra. Eyin at icar wícayat, éyinatan aját Sir tayar yajác wacáyqueyra. Eyta waquír as yauwin wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eyta waquír as judío bár bin at icar wícayqueyra. Judío bár bin as buror sisáyqueyra. As cuit cana rihar tijcáyqueyra. As bucáyqueyra. As yauwáyqueyra. Yauwir bay cuanyat, as sicor estají yehnáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bécajareht Zebedeo sasá Santiago cat, Juan cat Jesús quin rojocro. Behquír wajacro: —Síw̃quibu, isat bah quin icúr chíctara bahat is acu eyta yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Etat Jesusat eyin quin wajacro: —¿Aját bah acu icúr yajcá rácarica? wajacro. Etat éyinat wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Bahat récaji wac bahwi. Bah cuacúr Sir owár ayan cuít ityat, is bah ecsar itin acu ajc waawi, -wajacro-. Bah cuic rahray wihár, cuic rahray wihár itin acu ajc waawi. Récaji eyta wac bahwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Eyta chic cuar Jesusat eyin quin wajacro: —Baat istiti cuar chícaro. Biyin quin as cuic rahay wihár itin acu ajc waacayat, uwat eyin yauwin acu yajcátaro. ¿As yauwin yajquír eyta ba cat eyta yauwin yajcayat, baat cat yar yajcátaica? ¿Uwat as yauwir eyta ba eyta yauwin ajc waátaica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eyta wacayat éyinat wajacro: —Isat cat eyta bar yar yajcátaro. Isat cat eyta ajc waátaro, wajacro. Etat Jesusat wajacro: —Ba cat eyta yauwin acu yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Cuat biyin as cuic rahray wihár, cuic rahray wihár ítatatara aját wacátai batro. Biyin carin yinín acu, aját wacátai batro. Cuatán Sirat biyin acu waquír chájactara, éyinan eyta yinata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eyta tew̃yat, chiwa ucasi binat rahjacro. Eyta rahcuír rabin bucáy bin acu túrjacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Turyat Jesusat ima chiwa chiír wajacro: —Judío bár bin cárinat bitara áyictara baat itro. Eyinat imár chihtá uw quin yajc ayro. Judío bár bin cárinat cat imár chihtá uw quin yajc ayro. ");
INSERT INTO tuf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eyta cuar bara carin eyta bini batro. Bíyinan carin yin cun síhw̃actara, eyin cahujín acu cacminán wan chaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bíyinan carin cuit yin cun síhw̃actara éyinat bahnaquin cuitar yajcátaro. ");
INSERT INTO tuf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ajatán eyta yajcaro. Asan Uw Síuquib uw ayin acui rátiro. Cuat uw cuitar yajquín acu rajacro. Uwat tayar yajác tayar bár chaquin acu as chinín rajacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Etat Jesús Jericó pueblo cut tiw̃ rajacro. Pueblo sar bin ima chiwa owár uw ricán cuít bin owár béjecro. Beya yinyat Bartimeo ibit aw̃at ítchacro. Bartimeo ub bár binro. Eya Timeo waquijró. Uw quin ray buw̃uro. ");
INSERT INTO tuf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús ibit aw̃at racayat, uwat Bartimeo quin Jesús Nazaret bin raquíc ehcujacro. Bartiméoat eyta rahcuír uchta cohway yehnjacro: —Jesusu, David wihnú, as tamo séhw̃awi. As cuitar yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eyta cohwyat, uwat ey tanirujacro: —Ajc chin jaw̃i, wajacro. Eyta wacayat wan cuít cohwjacro: —David wihnú, as tamo séhw̃awi. As cuitar yajw̃i, wac cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eyta cohwyat Jesusat rahcuír biti inic itchacro. Itir uw quin wajacro: —Uw ey as quin raquín chiwi, wajacro. Etat uwat Bartimeo chíjacro. Ey quin wajacro: —Cue rehti jaw̃i. Cui yehnwi. Jesusat bah chícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eyta rahcuír ub bár bíjiyat siricajá sutír téjecro. Sutír ter car in yehnjacro. Jesús quin rajacro. ");
INSERT INTO tuf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Cucayat Jesusat wajacro: —¿Aját ba cuitar icúr yajcátaca? wajacro. Etat ub bár bíjiyat wajacro: —Caru, as ub ji chaw̃i, -wajacro-, aját istayta acu. ");
INSERT INTO tuf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eyta wacayat, Jesusat ey quin wajacro: —Sicor biwi, -wajacro-. Bahat uchta séhw̃aro: “Jesusat as ub ji chácataro,” séhw̃ajacro. Eyta sehw̃ac etar, aját bah ub ji chácaro, wajacro. Jesusat eyta wacayat, ub bár bin ub ji rehjecro. Etar Bartimeo Jesús chiwa chaquin ac ey jor ibit aw̃at béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesusin Jerusalén intac rocayat, Betfagé pueblo cuitara cat, Betania pueblo cuitara cat béhjecro. Pueblo eyan Olivo terá cuitatro. Esar behquir Jesusat ima chiwa bucáy bin cahmor ayin ac eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Pueblo ácatar erar cahmor béowi, -wajacro-. Erar cur car, asanica questa chájaquin istáyqueyra. Asanica ey cuitar anto uw waátiro, -wajacro-. Eyta istír ricuár cat as ac row̃i. ");
INSERT INTO tuf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Baat roquín yinyat, uwat táyota óraro: “¿Asanica bitán rícuaqui?” Ba quin uwat eyta táyoyat uchta waw̃i: “Carat inic chícaro. Biráy rehti sicor usár roquín wacaro.” Eyta waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Etat Jesús ima chiwa bucáy bin béjecro. Beyar ítitan, asanica itchacro. Querat acor questajacro. Ibit écsatro. Istír asanica ey ricuajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ricuayat uw esar cui ítquinat eyin quin táyojocro: —¿Baat asanica bitán rícuaqui? ");
INSERT INTO tuf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Etat éyinat Jesusat wajác eyta ehcujacro. Eyta ehcwayat beyin acu ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Etat asanica rojocro. Roquír asanica cutara imár oya chájacro. Oya chácayat, Jesús asanica arcút waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Asanica arcút waacayat, uw ricán to binat imár oya ibt aw̃at asujacro. Asuyat owár cahujinat sincuachir cahy tihw̃ cut bin ehsujaquey ibt aw̃at chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cahmor béquinat cat, questoc béquinat cat ricán to binat cohway yinjacro: —Bahat is siwin acu conro. Bah Sir chihtá cut rajacro. Sirat bah acu ay rehquín chaw̃i, -cohwjacro-. ");
INSERT INTO tuf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bahan David wihná bar racaro, cara rehquín acu. Sirat bah acu ay rehquín chaw̃i. Sir ajc cut rajacro. Siran ayro, tew̃ cohwjacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eyta cohw beyan Jesusan Jerusalén pueblo icar raújacro. Erar Sir usi raújacro. Sir usi rauwir bahnác wahitchacro. Bahnác wahityat, bar tínjacro. Eyta tinic rehquít ima chiwa doce bin owár Betania béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cuanmí cut chícrias Jesús Betania bin sicor béhjecro. Beya rabar ibit aw̃at cuácayat yayí rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yayí rehquír bira acat ibit cajc aw̃at higuera caruc itchacro. Eyta istír ub chétara, ques acor cuar wahitay bijacro. Ques acor cur itit, ub batro. Cahy imaro. Anto ub chaquic cabi cutiro. ");
INSERT INTO tuf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ub bár rehquít, Jesusat wajacro: —Siru, caruc ey bucoy ub chac ayti jaw̃i, bucoy uwat ey ub cohti acu. Jesusat eyta wacayat ima chiwat cat rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bécajareht Jerusalén cujacro. Cur car Jesusan Sir usi raújacro. Sir usi rauwir itit, uwat atcur ruwa wahr car, sicor racaro. Cahujinat ray tehmoro. Eyta istír eyin watar ayin yehnjacro. Ray tehmóc mesa ab cuíjacro. Atcur raquin banco ab cuíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Etar cat uwat Sir usar ibit chati acu esar icuran biyan bey áytiro. ");
INSERT INTO tuf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Etar uw síw̃jacro. Uchta wajacro: —Sir carit cuitar Sirat wajaquey uchta cuihsú bahjacro: “As ubach ojcor wacáyqueyra. ‘Ey sar Sir ojcor conín acu waquír chájacro. Cajc istiy cut bin uw, cajc istiy cut bin uw bahnáquinat ey sar Sir ojcor conín acu waquír chájacro.’ As ubach ojcor ‘Sir ojcor conic ubach’ aw̃áyqueyra,” wajacro, Sirat. Sir carit cuitar eyta cuihsujacro. Eyta waquíc cuar, ba bésinan esar itay yinjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesusat eyta wacayat, sacerdote cárinat cat, bachan chihtán síw̃quinat cat rahjacro. Rahcuír Jesús yauwin ac ríojocro. Uw bahnáquinatan Jesusat siw̃quey ayan cuít síhw̃ajacro. Eyta rehquít, sacerdote carin cat, bachan chihtán siw̃quin cat Jesús cahmor ay wini rehjecro. Etar yauwin ac ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Etat bar tinyat Jesusin pueblo Jerusalén bin waa béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cuanmí cut bucoy ibt aw̃at béjecro. Beya rabar ítitan, higuera caruc bar íncuatro. Bahnác sihyá tas injacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eyta istír Pédroatan Jesusat wajaquey tamo séhw̃ajacro. Eyta sehw̃ar wajacro: —Síw̃quibu, wahítuwi. Higuera cárucua bar injacro. Bahat “uwat cohti acu bucoy ub chati jaw̃i,” waquír ahra caruc ey bar injacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eyta wacayat, Jesusat wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—“Sirat bahnác bar yajcátaro,” síhw̃awi. Aját ba quin wacaro. Bíyinat ur istán cut “Sirat uchta yajcata,” sihw̃a rabar Sir quin conyat, Sirat éyinat conquey yajcátaro. “Sirat yájcajar óraro,” síhw̃ati cuaquir Sirat yajcátaro. Eyta cat bíyinat rirar uch ojcor “Siru, rirar ey yacúr icar tewi,” wacayat, eyta téyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Etar aját ba quin wacaro. Ur istán cut Sirat wícata sihw̃a rabar Sir quin icúr racar conyat, Sirat ey bar wícayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Etar cat bitat Sir ojcor cohnáy yehnyat, ba acu ay bár yajáqueyin quin sicor ténawi. Eyta ténayat ba cuacúr Tetát cat baat ay bár yajác tayar bár chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eyta cuar baat cahujín quin ténatitara, behmarat ur ay bár yajác tayar ques cat ba cuacúr Tetát ba cat cuécwayqueyra. Ba quin tena báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ibt aw̃at eyta tew̃ír acsara Jerusalén pueblo cujacro. Cur car Sir usar raújacro. Ey sar bicaro. Bécayat sacerdote carin cat, judío werjayinát cat Jesús quin béhjecro. ");
INSERT INTO tuf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Behquir táyojocro: —¿Bahat yajquey rehrá chihtá cuitar yajqui? ¿Bah quin rehrát eyta yajc ayi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eyta wacayat, Jesusat wajacro: —Aját rahra ba quin cat táyonro. Táyoyat aját ba quin icúr táyoctara baat as quin ey ehcuwi, -wajacro-. Baat ey ehcwayat, rahra aját cat ba quin behmarat tayoc ey ehcunro. ");
INSERT INTO tuf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","As quin récaji uch ehcuwi. ¿Juan bi chihtá cuitar uw rih sar siw̃yi? ¿Sir chihtá cuitari, uw chihtá cuitari rih sar siw̃yi? As quin ey ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eyta wacayat, sacerdote cárinat cat, judío werjayinát cat imár owár rahra rahra bi wacátatara uchta tew̃jacro: —Isat “Sir chihtá cuitar yajacro,” wácyeyra, Jesusat is quino wacata óraro. “Eytatara, ey chihtá ¿bitara reht cática?” wacata óraro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eyta cuar isat “Uw chihtá cuitara rih sar siw̃jacro,” wácyeyra, uw ricá is acu tec yinata óraro. Uwat síhw̃atan: “Juanan Sir chihtá ehcuquib rehquít, uw rih sar siw̃jacro.” síhw̃aro, uwat. ¿Eyta sihw̃ac etar isat uw chihtá cut siw̃jác wácyeyra is acu tec yínajaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Etar Jesús quin wajacro: —Isat istítiro, wajacro. Eyta wacayat, Jesusat wajacro: —Aját táyoyan baat as quin ehcuti cuat, aját cat ba quin ehcútiro. Aját bi chihtá cuitar yajquíctara ehcútiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Etat Jesusat chiht istiy, chiht istiy siw̃in acu uw quin icúr bi ojcor ehcujacro. Uchta wajacro: —Riy istiy serat ima cajc cut ub yaquic chistár rijacro. Riquír ey rúhracat ac quer yajacro. Eyta yajquír ub ey sawin acu, rihar ey uquin acu ac cumac bin tan oso iscán cuíhjacro. Iscán cuihir cat cuacracat rirá órojocro. Rir ey cuitar cuar chistár ub bes yajc ayti ac uron acu órojocro. Etar bahnác yajc tihrír, chistár cat, cajc cat cahujín at icar bahjacro, ruón acu. “Uba ey tihryat isat wahw̃unro” waquír bahjacro. Eyta waquír, cajc istiy itay bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Itchareht, yájcajareht chistár ub tihric cab cujacro. Ub tihric cab cucayat, ima cacmá chistár riquír bahjác cajc cut áyjacro. Chistár ub imáy acat ey ucay áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ayat cacmá ey bijacro. Cucayat, ruón chac bahjac éyinat cacmá ey abáy bujacro. Buquír sicor ata áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Etat cayibat istiy cacmá áyjacro. Cacm ey erar cucayat, erar ruóqueyinat cacmá ey cuis acat bujacro. Ahsín ruhw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Etat cayibat istiy cacmá áyjacro. Erar cucayat, erar ruóqueyinat cacmá ey yaujacro. Yahncút cat istiy cat, istiy cat áyjacro. Ayat erar ruóqueyinat cahujín abáy bujacro. Cahujín tíw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Cayibay ayin acu úbisti étanro. Eyra ima waquijró. Imát sehnác bin eyro. Etar ubar ojcor ima wacjá áyjacro. Uchta séhw̃ajacro: “Uw éyinat as waquíj etar ajcá ji béyayqueyra,” sehw̃ar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ayat bijacro. Erar cucayat uw éyinat rahra rahra wajacro: —Cayíb wacjá bar racaro. Uy yaryat cayíb cajc eyra bi acui cha báhjatro. Eyta chíhtara ey yauwátaro. Eyta yauyat, cajc eyrun ijmaray cháquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eyta waquitrun, wacj ey yaujacro. Yauwir chistara ques bin ew̃ uquir téjecro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eyta waquír uw quin táyojocro: —Baat sihw̃at, ¿cajc cayíb uw eyin ac bitara yajcátaqui? Uchta yajcáyqueyra. Cajc cayibat uw eyin séhw̃ati tíw̃ayqueyra. Bahnác sutáyqueyra. Eyta tiw̃ir cat, cajc eyra cahujín at icar wícayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—¿Sir carit cuitar tew̃iquey uch istítiica? Sir carit cuitar wacaro: Ac ubach túw̃quinat ac cumac bi úbisti ay bár sihw̃ar, te sijacro. Eyta te sijác cuar, ac ey sicor yehw̃ roquír ácoso tebir chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sir imát eyta yajacro. Isat eyta ítitan, ayan cuít yajacro. Sir carit cuitar eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesusat eyta tew̃yat, sacerdote cárinat cat, fariséoinat cat rahjacro. Eyinat rahcuír ítitan, imár cahm icar tew̃ro. Imár cahm icar tew̃ic istír, Jesús questár be cun rehjecro. Eyta cuar uwa ricá to bin ayot Jesús catótiro. Etar Jesús cham bahr imár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yahncút judío cárinat cat, fariséoinat cat, Heródesinat cat Jesús quin tayoy áyjacro. Heródesin chiwa cat áyjacro. Jesusat bitara wacátatara istín acu tayoy áyjacro. Jesusat téw̃ajar bin tew̃ayta cayar yajquín acu tayoy áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eyta ayat, éyinat Jesús quin cur wajacro: —Síw̃quibu, isat ítitan, bahat uw cayar yájtiro. Bahat Sir chihtá tehmoti ehcuro. Uw cahm ayú batro. Bahat séhw̃atan, uw cara cat, chiwa cat owáraro. Eyta cuácayat is quin ehcuwi. Romano cara reyat is quin tayar chícayat ¿isat túnataica? ¿túnajarica? ¿Sir chihtá cutar eyta tunin ajc waaquí? Cara César gobiérnoat ray chícayat, isat túnatatara, túnajartara, is quin ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eyta wacayat, Jesusat eyin urá itchacro. Jesusat ítitan, éyinat ima cayar yajquín síhw̃aro. Eyta istír eyin quin wajacro: —¿Bitara reht as cayar yajca rácarica? -wajacro-. As acu ray row̃i, aját wahitín acu, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eyta wacayat éyinat ray Jesús quin rojocro. Etat Jesusat eyin quin táyojocro: —Baat ítitan, ¿ray cuitar rehr ajc cuihsuyi? ¿Rehr aquir chacyi? wajacro. Eyta táyoyat éyinat wajacro: —Romano rey aquir chájacro, -wajacro-. Ey ajc cuihsujacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Etat Jesusat eyin quin wajacro: —Eyta chíhtara romano gobierno cara ac túnata ey ima ajc cuihsujaquin ray cut tunwi. Etar cat Sir ac yajcata bin ey cat yajw̃i, wajacro. Eyta rahcuír, ojc siquir ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Etat saducéoin Jesús quin béhjecro. Saducéoinat sihw̃at, uw sácajaquin sícotra estají yínajar, síhw̃aro. Saduceo éyinat Jesús quin tayon acu wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Síw̃quibu, Moisesat chihtá is quin ehcún cuihsú bahjacro. Uchta wac bahjacro: “Uwa sasá bár chinata óraro. Chein wiya bahta óraro. Eyta chac bahcáyatra ima rabat yarjaquey wiya yehw̃átaro,” wac bahjacro. “Yehw̃ír yarjaquey acu sasá conátaro. Yarjaquey wiya ojc cut sasá conátaro.” Isat eyta yajquín acu Moisesat cuihsú bahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","’Eyta cuácayat rábinan cucuí bin ojcor táyonro. Rab eyin rab cahmor bijat wiya yehw̃jacro. Yehw̃ír car sah bár cuar yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eyta cuácayat yarjaquey rabat chein wiya bahjaquey yehw̃jacro. Yehw̃ír ey cat sah bár cuar yarjacro. Eyta cuácayat yarjaquey rab bawoy eyat chein wiya bahjaquey yehw̃jacro. Yehw̃ír ey cat sah bár cuar yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eytaan rab cucwoy tas bahnáquinat yehw̃ír, sah bár cuar sácajacro. Rabin bahnaquin sah istiti sacay cutar chájareht, chein wiya cat ubar ojcor yarjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eyta cuácayat, sácajaquin sicor estají yinátair waquít, ¿sácajaquin wiya ey sicor cat bi rabay jácataca? -táyojocro, Jesús quin-. Ey wiw̃ eyan rabin cucuí binat yehw̃jacro, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eyta wacayat Jesusat wajacro: —Baat eyta wacayat, urá bár tew̃ro. Baat Sir carit cut bitara wáctara istítiro. Istiti rehquít, urá bár tew̃ro. Baat “Siran camur chiro,” síhw̃atiro. Eyta rehquít, urá bár tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sácajaquin sicor estají yinyat, éyinat wiya yehw̃á báreyra. Chauninat cat ra cuaca báreyra. Etar éyinan Sir cuacúr cacmín itir eyta ítataro. ");
INSERT INTO tuf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Uchicrias Sirat Moisés quin caruc sar oca cubar sar cuar tew̃jacro. Sir carit cutar eyta tew̃jaquey chihtá cuihsú bahjacro. Ey chihtá cuitar yarjaquin sicor estají yiníc ojcor uchta cuihsú bahjacro: Sirat Moisés quin wajacro: “Asan Abrahamin acu, Isaaquin acu, Jacobin acu Sitro,” wajacro. ¿Baat eyta cuihsú bahjaquey istítiqui? ");
INSERT INTO tuf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Siran chein acu Sir batro. Estají bin acu Sitro. Baat sácajaqueyin sicor yínajar síhw̃ayat, ay síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Etat bachan chihtán siw̃quib wijacro. Wiquír saducéoin Jesús chor tecuac rahjacro. Rahcuír “Jesusat ay tew̃ro,” séhw̃ajacro. Eyta sehw̃ar Jesús quin táyojocro: —Síw̃quibu, Moisesat chiht istiy, chiht istiy bahjác sicar ¿biyan ayan cuitca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Etat Jesusat wajacro: —Uchan ayan cuitro: “Israélinu, uch chihtá rahcwi. Is cara Sitro. Sir istanacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bahat Siran sehnác chaw̃i. Bah urá istán cuitar, ajc istán cuitar, bow̃a cuitar sehnác chaw̃i. Ba canar chihchir bahnác cuitar Sir sehnác chaw̃i.” Chihtá eyan ayan cuít biro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ey yahncút chihtá uy cat eyan wanro. “Behmá urá cut behmán sehnác eyta cahujín cat eyta sehnác chaw̃i.” Chihtá bucáy eyan ayan cuitro. Cahujeyra ey owár cutiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Etat bachan chihtán síw̃quibat Jesús quin wajacro: —Síw̃quibu, bahat yarsa wacaro. Bahat waquey uniro. “Sir istanacro. Sira cahujira batro. ");
INSERT INTO tuf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bah urá istán cut, bow̃ bahnác cut, canar chihchir bahnác cut sehnác chaw̃i. Behmá sehnác eyta cahujín cat eyta sehnác chaw̃i. Eyta yajcayat ayan cuitro. Sir racar wiquin ruwa yauwir wahnár wícayat etach cutiro. Ay bár yajaquey tayar tunin eyta wícayat, etach cutiro.” ");
INSERT INTO tuf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eyta wacayat Jesusat ráhcuitan ay tew̃jacro. Etar wajacro: —Baha Sira cara rehquey cutar itin acu conu táyoro. Ey yahncút uwat Jesús quin ehchí tayon yajquít cat ay wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesusat Sir usi siw̃a rabar uchta wajacro: —Bachan chihtán síw̃quinat uchta siw̃ro: “David Cristo cohtaró,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David imát Sir Ajca Cámuran Ey chihtá cuitar uchta wac bahjacro: Sirat ajmár cara quino wajacro: “Asi jor bahan cara chaquic acor ítuwi,” wajacro. “Aját bah quehsí bin bahnaquin burbar yajquíc acor ítuwi,” wajacro, Sirat, ajmár cara quin. ");
INSERT INTO tuf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidat “ajmár cara” wacayat, Crístoan ima cara ehcuro. Eyta ehcujác cuar baat Crístoan “David wihná” wacaro. Jesusat eyta wacayat, uw ricán to binat Jesusat siw̃quey ahní rahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesusat uw siw̃a rabar uchta cat wajacro: —Bachan chihtán siw̃quin cahmar yají jaw̃i, -wajacro-. Eyin oya ques acat sohmasom chaca rácatro. Bahnáquinatan ibit aw̃at imár quin ay tena aya rácatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Secuac usar báncoan ehchian cuít bi cutar chihra rácatro. Fiesta cuitar cat banco ehchí cuitar chihra rácatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eyinat sácajaquin wiya báhjaquey cayar yajcaro. Ey usar bin eyin ohnor icúr bi síuro. Eyta siwic cuara uwat imár ur ay síhw̃ayta acu Sir ojcor conyat, in cona báhntiro. Eyta rehquít, Sirat eyin cuít cuecwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Riy istiy Jesús Sir usi ray chaquic cajón ácatar ítchacro. Erar ita rabar uw ricán to bin ray chaquic wahitchacro. Ititan, cárinat rayan to chácaro. ");
INSERT INTO tuf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Etatan ray bár bin, oya bár bin yarjaquey wiya rajacro. Wiquír ray escúr bucáy tas wíjacro. Ray conu wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eyta istír Jesusat ima chiwa chíjacro. Behcayat eyin quin wajacro: —Aját uní wacaro. Sirat ítitan, yarjaquey wiyat wícyeyan cuitro. Cahujinat wícyeyan étai cutiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Cahujinra rayan toro. Rayan to cuar, conu wíjacro. Cuatán yarjác wíyatrun imayan bítatar bahnác wíjacro. Oya bár bin cuar bahnác wíjacro. Yayín acu ray yajc chajac cuar, ray ey bahnác wíjacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Etat Jesús Sir usar bin watar waajacro. Watar waacayat Jesús quin ima chiwat wajacro: —Wahítuwi. Sir ubach ehchiro. Acan ay bi anjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Etat Jesusat wajacro: —Sir ubach eyta tuw̃jác baat itro. Ac ubach tuw̃jaquey bahnác quihu sácayqueyra. Acan arar tas tas chájaquey úbisti bahti quihwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Eyta waquír cuitar Olivo terá cuitar cuwín béjecro. Olivo terá cutar cuar Sir úbachan ácatatro. Erar cur Pédroat cat, Santiágoat cat, Juanat cat, Andresat cat Jesús ima quin táyojocro. Cahujinat rahcti acu uchta táyojocro: ");
INSERT INTO tuf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Bahat téw̃queyan bítatan eyta rehcátaqui? Bahat tew̃jác ojcor bar cab cuquey isat istín acu uw acam bitara rehcátatara, is quin ey ehcuwi. Uch bahnác rehquín acu cab cucayat, ¿uw acam bitara rehcátaca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eyta táyoyat, Jesusat wajacro: —Yají jaw̃i. Aját tew̃quey cab cu racayat, ¿Uwat ba cayar yájcajaqui? ");
INSERT INTO tuf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uwat imár ójcoran “Asan Crístoro,” wacáyqueyra. Uwan to binat eyta tew̃ay yináyqueyra. Eyinat “Sirat as ayjac,” waquíc cuara, imár chihtá síw̃ayqueyra. Eyta waquír cuitar uw ricá to bin cayar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Cajcan birar urar tec quejn chihtá tew̃ic rahcuáyqueyra. Eyta rahcyat rooti jaw̃i. Eyta rehcata waquír chájacro. Tec eyta quejquíc cuar ruw̃ár ojcor rehcata eyi batro. ");
INSERT INTO tuf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cajc istiy uwan, istiy uw owár, istiy uw owár tec quéjqueyra. Gobiérnoan rahra rahra tec quéjqueyra. Ihyara cat birar, urar yiwóyqueyra. Cajc istiy cuitar, cajc istiy cuitar yayan uti siti rehcáyqueyra. Eyta rehcayat anto récaram rehcata éytaro. Ey yahncutwan cuít rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Eyta cuar yají jaw̃i. Uwat baat as chiwa chajac ques cahujín at icar wícayqueyra. Ruhw̃ún acu, yauwin acu wícayqueyra. Secuac usar cat uwat ba bar bucáyqueyra. As chihtá ques baan gobernador cac cahmar, rey carin cac cahmar chiáyqueyra. Eyta chícayat eyin quino as chihtá tew̃áyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Anto cábara tinti cuácayat Sir chihtá ay bi uw istiy quin, istiy quin, istiy quin, bahnaquin quin ehcwátaro. ");
INSERT INTO tuf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba urá istín acu carin cac cahmar ahár si bécayat, rooti jaw̃i. Anto beyin inár, icúr wacátatara síhw̃ati jaw̃i, -wajacro-. Erar cucayat Sir Ajcan Cámuran Eyat ba quin chihtá wícayqueyra. Ey chihtá tew̃i. Behmár chihtá tew̃ti jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uwat ima rabin cat yauwin acu cahujín at icar wícayqueyra. Tetinát cat ima sasá cat tiw̃in ac wícayqueyra. Sasát cat ima tetín abín quehswáyqueyra. Quehsúr car eyin tiw̃in ac cahujín at icar wícayqueyra. As chiwa chajac ques uw bahnáquinat ba quehswáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Etat owaran bíyinatan Sir chihtá wácati tan úcayatan, Síratan eyin síwayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Etat owaran baatán uchta istáyqueyra. Istiy Sir usar raúwajar bin icar báchuti raúwayqueyra. Eyta rauquey ay baran tahnacro. Uchicrias cuat Sir chihtá ehcuquib Danielat eyta raúwata ey ojcor récaji cuihsú bahjacro. Bíyatan carit uch tacáyatan uch chihtá yají rahcwi. Sir usi raúwajar bin icar istiy rauyat ruhcuay bewi. Raujác chihtá rahcuír, Judea cajc cut itquin cubar icar ruhcuay quinwi. ");
INSERT INTO tuf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bíyinan ubach arcutar rehcáyatan, éyinan oya ucay ubach tansar rauti jaw̃i. Rauti quinwi. ");
INSERT INTO tuf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bíyinan chi cut rehcáyatan, éyinan siricajá ucay usi beti cuaquir acsar quinwi. ");
INSERT INTO tuf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wiw̃ín istir bár eyin cat cuechú cuac sácayqueyra. Sasá sut ojcor bin abín cat cuechú cuac sácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sir ojcor uchta conwi, -wajacro-. “Bara cut quinic riy cuan ayti jaw̃i,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sir usi raúwajar bin icar rauyat cab owaran uwan cuechú cuac sácayqueyra. Récaji Sirat cajc chajac cuat, ah acat tas cuácayat, éytai cuechú cuátiro. ");
INSERT INTO tuf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Uwan eyta cuac sácayatan, Sirat anto bahnaquin sácati et áyayqueyra. Sirat eyta et áytieyra rehrí sera waájatro. Eyta etar Sir imáy cájaquin sehnác rehquít, eyta et áyayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Uwatan ba quin “Cristo usatro,” wacáyatan, “Cristo úratro,” wacáyatan, ey ria cati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Etat ba cayar yajquín acu istiy cat, istiy cat, quir bin yináyqueyra. Yinír “asan Crístoro,” wacáyqueyra. Cahujinat “asan Sir chihtá ehcúquibro,” wacáyqueyra. Eyinat eyta waquíc cuar Cristo queney batro. Etara cat istiti bi icúr bár sícara bitara útara yajcáyqueyra. Sirat cajac eyin cat cayar yajcátair waquít, cayar yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Etar yají jaw̃i. Baat récaji ey istín acu ehcuro, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Uw eyta ruhw̃í yahncút, rahs waa báreyra. Sihyór cat waati rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cuacúr ub cat abá cuitar bin tijcáyqueyra. Cuacúr abá cuitar bahnác yiwóyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Etat asan Uw Síuquib raquíc istáyqueyra. Bowarám tan cutar raquíc istáyqueyra. Caran to urán to raquíc istáyqueyra. Rahs churotán wan Sir churot chi wan beo beo raquíc istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Etar aját cacmín cuacúr bin áyinro. Ayir éyinat Sir ima uw sécuayqueyra. Cajcan teyan bítatara bahnác cutar bin sécuayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Chihtá sinin acu aját higuera caruc ojcor tew̃inro. Uch sinwi. Higuera caruc cay sucoyat, baat ítitan, bara bar cab cucaro. Cuicara sucoyat, bara bar cab cucaro. ");
INSERT INTO tuf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eytaan wan, aját wacyey bahnác eyta rehcayat, baat ítitan, cábara tinic bar cab cucaro. Cabar bar tinic istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aját ba quin wacaro. Ah cut itquin bahnaquin sácati cuar, aját wacyey eyta rehcáyqueyra, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cuacúr abá cat, cajcan teyan bahnác bahnáyqueyra. Eyta cuar as chihtán bahnác queni íuti im eyta chácayqueyra. Bahná báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Asan Uw Síuquib cat bitat sicor wicátatara, istiyati istítiro. Rahsa bítajat wicátatara istiyati istítiro. Sir cuacúr cacminát cat istítiro. As Sir ima wacját cat istítiro. Tet imatrun itro. ");
INSERT INTO tuf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yají jaw̃i. As wiquíc cahmor ítuwi. Asan bitat wicátatara baatán istítiro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Uchtaan wanro. Uw istiyá cajc istiy bicaro. Bicayat im ubach cat, canar cat cacmín at icar cham bahcaro. Cacmín istiy cat, istiy cat canár chi bahcaro. Etar querat úroquin quin wacaro: “Querat úrowi,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Etar cacminát yají jácataro. Ubach cayíb bitat wicátatara istítiro. Tino wicátatara, chey ubut cuitar wicátatara, sisburat cohwyat acat wicátatara, chícriasa wicátatara istítiro. ");
INSERT INTO tuf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Baan éytaan wan yají jaw̃i. Eytair báreyra ba camyat icar cayíb wicátaro. ");
INSERT INTO tuf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aját ba quin wajquey uw bahnaquin quin wacaro: “Yají jaw̃i,” wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Boni cuanyat bach ajc cheycar aracat bijaquey cuanata cuanjacro. Uchicrias Siran cohtín ubach aracat uw yauti bijacro. Siran aracat uw yauti bijác ey sihw̃an ac judíoinat bach yajcaro. Bach ey ajc istiy cut Pascua fiesta aw̃uro. Pan buc rehti bi fiesta cat aw̃uro. Boni cuanyat Pascua fiesta cuanata cuácayat, sacerdote cárinat cat, bachan chihtán síw̃quinat cat uwat istiti Jesús caquin acu ríojocro. Yauwin acu ríojocro. ");
INSERT INTO tuf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eyinat rahra rahra wajacro: —Yauwata cuar fiesta cuitatra yaúwajatro. Fiesta cuitar yaúyeyra, uwat istír car, tec yináyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Eyta ríoyat yiror, Jesús Betania cuitar Simón usi chájacro. Simón ajc istiy cut ojc ohnquey aw̃ujacro. Erar chácayat mesa acor chihrjacro. Mesa acor chihryat, wiw̃ istiy Jesús ocsor wijacro. Wiquír boteya rojocro. Boteya alabastro ac cut órojocro. Ey sar nardo perfume chiro. Inan ehchí bi chiro. Perfume eyan acán to binro. Wiw̃ eya wiquír, boteya cucara quehujacro. Quehwír Jesús cuísotar uhcajacro. Jesús mesa acor ityat cuísotar uhcajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eyta uhcayat cahujín túrjacro. Turir car wajacro: —¿Bitara reht cuayar auqui? ");
INSERT INTO tuf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Eyta auti cuar perfume ey rata bi yajacro. Ey acan to tres cientos denarios chiata bin yajacro. Eyta rar car oya bár bin quin, ray bár bin quin raya wícata bi yajacro, wajacro. Etar wiw̃á quin wajacro: —Eytara auti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eyta cuar Jesusat wajacro: —Cham jaw̃i. Uy wiw̃át eyta yajcayat, ¿bitara reht yájcajar bin yajc síhw̃aqui? Uyat as acu ay yajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ba owár oya bár bin, ray bár bin uwra it bahná báreyra. Eyin quin wiquin acu bitat chétara eyin quin etat wícayqueyra. Cuácayat asra ba owár etach ita báreyra. Asra ba owár inic itro. ");
INSERT INTO tuf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Uyat imát yajcata ey bar yajacro. Uwat ruhcuín cahmor chein cuitar perfume chaquir eyta, uch wiw̃át as ruhcuín inár perfume eyta chácaro. Anto chinti cuat chácaro. ");
INSERT INTO tuf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aját ba quin wacaro. Cajcan teyan birar birar as chihtá ehcwáyqueyra. Birar ehcúctara uch wiw̃át yajác ey cat ehcwáyqueyra. Uwat eyat as ac yajác tamo sihw̃an acu ehcwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesusat eyta waquír cuitar ima chiwa doce sícara bin úbisti sacerdótein quin bijacro. Judas Iscariote bijacro. Júdasat Jesús sacerdótein at icar chaquin sehw̃ar bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Júdasat Jesús eyin at icar chaquin wacayat, eyin ahní rehjecro. Ahní rehquír wajacro: —Isat bah ac ray túninro, wajacro. Eyta tunin wacayat, Júdasat Jesús úrojocro. Sacerdote carin at icar bitara wícatatara ey úrojocro. ");
INSERT INTO tuf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Etar fiesta récaram yajquín riy cuanjacro. Pan buc rehti cohquíc riy cuanjacro. Obas sah yauwin cuanjacro. Eyta cuanyat, Jesús chiwat Jesús quin táyojocro: —¿Isan birar bétaca? ¿Isat bahat cohn acu pan buc rehti bisar wahnátaqui? ¿Obas sah cat bisar wahnátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eyta wacayat Jesusat chiwa bucáy áyjacro. Aya rabar uchta wajacro: —Pueblo icar béowi. Erar ser istiy istáyqueyra. Rih soya ator bequic istáyqueyra. Ser ey ityat, ey questoc béowi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Birar raúwictara ey ubach cayíb quin uchta waw̃i: “Is síw̃quibat uchta wac ayro: ‘¿As bah ubach cutar bi querat icar raúwataca? As ey sar ajmár chiwa owár Pascua fiesta cutar pan buc rehti bi cohnro,’ wac ayro.” ");
INSERT INTO tuf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Baat eyta wacayat, eyat querat usi waanan cuít bi ehcwáyqueyra. Cuacúr ey ehcwáyqueyra. Ey sar icúr táyoctara bahnác órojoquey ehcwáyqueyra. Im ey sar is cohn ac bahnác wahnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesusat ima chiwa quin eyta wacayat, eyin yinír béjecro. Beyar Jerusalén cut cujacro. Erar cur ítitan, Jesusat bitara istay cuwata wajáctara, eyta itchacro. Etar éyinat Pascua fiesta cutar yayín obas cat, pan cat wahnjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tinyat Jesús ima chiwa doce eyin owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Beyar mesa acor chihrjacro. Chihrír coha rabar eyin quin wajacro: —Aját ba quin wacaro. Ba as chiwa sícara bin úbisti urá tehmóyqueyra. Is owár ira yaquey ima urá tehmóyqueyra. Tehmár as quehsí waáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eyta wacayat eyin cue rehjecro. Cue rehquír istiyát istiyát táyojocro: —Unian ¿aját eyta yajcátaitara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eyta táyoyat Jesusat wajacro: —As chiwa doce bin sicar úbisti as owár soy istán cutar pan siw̃ir yáqueyan eyan eyro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Uwat asa Uw Síuquib yauwáyqueyra. Sir carit cuitar ehcujác eyta yauwáyqueyra. Eyta cuar bíyatan quehsuquin at icar as chácayat, eyan conú cuácayqueyra. Eyan récajian yéhntiir waquít, ey ácuan ay chácata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eyinat ira yaya rabar, Jesusat pan at cut yehw̃jacro. Yehw̃ír Sir ojcor conjacro. Eyta conár cuitar ima chiwa istiy quin, istiy quin cotír wíjacro. Eyta wiquir wajacro: —Towi. Cohwi. Uchan as sibatró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Eyta waquír toca yehw̃jacro. Toc ícara chistár ub rihatro. Toca yehw̃ír Sir ojcor conjacro. Conár ima chiwa istiy quin, istiy quin tahw̃ujacro. Tahw̃úr bahnáquinat yahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Etat Jesusat wajacro: —Uchan as abro. Sir imat uw acu bitara yajquín wajacro. Sirat wajquey uní rehquín acu as ab béyqueyra. As ab uw to bin ac béyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aját ba quin wacaro. Chistár ub rihar uchta bi aját bucoy yáhtiro. As Sir cara rehquey cuitar itic ocso tas yáhtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eyta waquír, Sirat rahcuín acu tajacro. Tar car acsar béjecro. Cajc Olivo terá cut cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Erar cur Jesusat eyin quin wajacro: —Ba bahnáquinat as chihtá waca báhayqueyra. Sir carit cuitar ey ojcor wacaro: “Obas cayíb aját yaúwinro. Etat óbasinra bar cui béyqueyra,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eyta cuar as sicor estají yehninro. Yehnár ba cahmor Galilea cajc cut benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eyta wacayat Pédroat wajacro: —Eyin bahnáquinat bah chihtá waca bahta óraro. Cuatán ajatrá waca báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Etat Jesusat Pedro quin wajacro: —Pédrou, aját bah quin wacaro. Ah chéycara bahat wacáyqueyra: “Asra Jesús chíwai batro,” wacáyqueyra. Cohcarám icar bucáy cohwín cahmor, ícara bay eyta wacáyqueyra, as ojcor, wajacro. Jesusat Pedro quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eyta wacayat Pédroat wajacro: —As bah jor yauwata tacat, aját “as bah chíwai batro,” waca báreyra, wajacro. Etat bahnáquinat cat im eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Etat Jesusin cajc ajca Getsemaní cut béjecro. Getsemaní cut cur, Jesusat ima chiwa quin wajacro: —Usár as acor ítuwi. As Sir ojcor conay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eyta waquír car, im owár Pedro cat, Santiago cat, Juan cat acsara béjecro. Bir car cuecway yehnjacro. Cueat cuájacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Etar eyin quin wajacro: —Cueat as yarata racaro. Ba usár quir ítuwi. Camti ítuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eyta waquír biráy bár cut bijacro. Bir car ica icar beric tin bijacro. Beric tin bir, Sir ojcor ima yau ayti acu conjacro: ");
INSERT INTO tuf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Tetú, uwat as yauti ac conro. As yauti yarsa waátatara, as yau ayti síuwi. Aját eyta conic cuar, as chihtá yajti jaw̃i. Behmá chihtá yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eyta conár, ima chiwa bay bin quin wijacro. Wiquír ítitan, cam sácajacro. Eyta istír Pedro quin wajacro: —Simonu, ¿Bitara reht camqui? ¿Camti íniqui ítajarica? ");
INSERT INTO tuf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Camti ítuwi. Camti ita rabar Sir ojcor conwi. Sisramat ba quin ur ay bár yajc ayti acu conwi. Aját wacaro. Bahat ur icar ay yajquín sihw̃a cuar, bah sibará chihchí batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eyta waquír car bucoy Sir ojcor conay bijacro. Cahmor conjác eyta im eyta conjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eyta conár car bucoy wiquír ítitan, chiwa bucoy cat cam sácajacro. Cámyarat tec etar cam sácajacro. Jesús wicayat, chiwat acat icuri wácajatro. ");
INSERT INTO tuf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesusat chiwa cam sácajac istír, icar bawoy conay bijacro. Conár car icar bawoy ima chiwa quin wijacro. Wiquír eyin quin wajacro: —Cámintara ahra camwi. Tan jaw̃i. Ahra cábaro. Asa Uw Síuquib ac bar cab cujacro. As ur ay bár bin at icar wiquic cab cujacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cui yinwi. Bar jaw̃i. As acu quehsí waajaquey bar racaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cab rehti Jesusat echí tew̃yat icar, Judas wijacro. Judas eya Jesús ima chiwa doce sicar binro. Judas owár ricán to béjecro. Espadan ator, cárucuan ator béjecro. Sacerdote cárinat, bachan chihtán síw̃quinat, werjayinát eyin áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Júdasat eyin quin biyan Jesústara ehcún wajáquinro. Ey ehcún acu icúr yajquíntara récaji uchta wajáquinro: “Aját bi ac suhwíctara, eyan eyro. Ey caquir row̃i. Sut ayti béowa,” wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eyta wajác etar bequir Jesús cac cahmar bijacro. Cur wajacro: —Síw̃quibu, as racaro, wajacro. Eyta waquír Jesús ac suhwjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Suhwyat éyinat Jesús ahár cájacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cácayat icar érara uw istiyát espada újacro. Espada uquir sacerdote cacúm tajacro. Cacúm ey cucáj cuic téjecro. ");
INSERT INTO tuf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Etar Jesusat uw bahnaquin quin wajacro: —Baat besin caquir eyta, caruc jaw̃, espada jaw̃ as cacay rojocro. ¿Bitara reht eyta royi? ");
INSERT INTO tuf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aját riy istiy, riy istiy Sir usi ba ubot síw̃jacro. Eyta cuar, baat erar as cátiro. Eyta cuar Sir carit cuitar cuihsú bahjác ey bahnác queni íuti yajcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Etatan ima chiwa bahnáquinan cui béjecro. Jesús im istir bahjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Síbijian Jesús questoc bijacro. Síbiji eya wiricasá ojcúm bob bacór, etan ow̃jacro. Bicayat uwat ey cájacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cácayat wiricás ojcúm ey sut bahjacro. Sutír siati quinjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús caquir, sacerdote cara Caifás quin yehw̃ béjecro. Caifás usi sacerdote carin cat, judío werjayín cat, bachan chihtán siw̃quin cat bar secuay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesús bécayat Pedro questoc birar cuít cuar bijacro. Bir sacerdote cara usi ubach tan sar awat cuitar raújacro. Esar rauwir policia owár ítchacro. Eyin owár oc ow̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Etar sacerdote cárinat, bahnác sécuajaquinat Jesús cahm icar tew̃ata bin uroy áyjacro. Eyta tew̃quin chihtá cuitar Jesús yauwin sihw̃ar uroy áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Eyta úroyat, ricá to binat sucuar tew̃jacro. Eyta tew̃ít cat bi ques icar yaúwajatro. Cuisa bucáy binat chihtá istán téw̃tiro. ");
INSERT INTO tuf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eyta tew̃ beca reht, cahujinat yinír sucuar tew̃jacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Isat ráhcuitan, ser uchat uchta wajacro: “Aját Sir ubach uwat at cut tuw̃jaquey bahnác bar quihwinro, -wajacro-. Quihwír bay cuanyat istiy óronro. Eyra uwat at cut tuw̃ti binro,” wajacro. Isat eyta waquíc rahjacro, wajacro, uw cahujinat Jesús ojcor. ");
INSERT INTO tuf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eyta wajác cuar anto cuisa bucáy binat chihtá istán téw̃tiro. ");
INSERT INTO tuf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Etat sacerdote cara eyin quemir bin yehnár car, Jesús quin wajacro: —Eyinat eyta tew̃yat ¿bah ajc chínica? ¿Bah cahm icar téw̃queyan unica? ¿Eyinat bi ojcor tew̃qui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eyta táyojoc cuar, Jesusat ajc wati ítchacro. Ajc chin chájacro. Eyta cuácayat sacerdote carat bucoy ey quin wajacro: —Is quin ehcuwi. Bahan Crístotara, bahan Sir waquíjtara, ey bártara, is quin ey ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Etar Jesusat wajacro: —Ee, asan eyro. Etar asan Uw Síuquib cuacúr urán to ecor itic baat istáyqueyra. Asan cuacúr abá cuitar bin bowarám tan icar raquíc istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eyta wacayat sacerdote caran abáy túrjacro. “Jesusat téw̃ajar bin tew̃ic,” séhw̃ajacro. Eyta sehw̃ar turir ima oya rachacro. Turir wajacro: —Is cucajá ácatan Sir ojcor téw̃ajar bin tew̃jacro. Isat caba rahjacro. Ey cahm icar tew̃quin ahra istiy táyotiro. ");
INSERT INTO tuf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sir ojcor téw̃ajar bin tew̃jacan baat cat rahjacro. Baat ¿bitara síhw̃aca? ¿yaúwataitara? ¿yaúwajaritara? ¿Baat bitara síhw̃aca? Eyta táyoyat bahnáquinat wajacro: —Isat ítitan, eyat Sir tayar yajacro. Etarwan yauwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Etar éyinat Jesús ac cutar cana rihar tijcáy yinjacro. Tijcár cat cahujinat oya cumar cut ac ey, ub ey cay questajacro. Cay questár ey ac cat tajacro. Tajcá rabar wajacro: —Bah bíyati tajquíctara, is quin ehcuwi, wajacro. Etar Sir usi policia cat ey bujacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Etat icar aw̃at Pédroan cahmar ubach tan sar awat cuit ítchacro. Erar ityat sacerdote cara cacúm wiw̃át Pedro ocsor wijacro. Wiquír wahitchacro. Wahitír wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","—Bah cat Jesús Nazaret bin chíwaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Etat Pédroat wajacro: —Asra ey chíwai batro. Bahat bi ojcor tew̃íctara, istítiro. Ráhctiro, wajacro, Pédroat. Eyta waquír, awat querat cu tas bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Erar cucayat, ira ánquibat Pedro itchacro. Istír bucoy cahujín quin wajacro: —Ser uya Jesús Nazaret bin chíwaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eyta wacayat Pédroat bucoy wajacro: —Asra ey chíwai batro, wajacro. Biráy bár reht, cahujín Pedro ocsor wijacro. Wiquír wajacro: —Bah cat Galilea binro. Etar bahan ey chíwai batro, bitách wácajatro. Aját ítitan bahan ey chíwaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Eyta wacayat, Pédroat wajacro: —Asan ey chíwai batro. Aját uní wátitara, Sirat as bar cuécwayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eyta wacayat acat cohcarám bucoy cohwjacro. Cohwyat, Pédroat Jesusat wajác tamo séhw̃ajacro. Récaji Jesusat wajáquinro: “Cohcarám icar bucáy cohwín cahmor bahat as ojcor ‘asra ey chíwai batro,’ wacáyqueyra. Icara bay eyta wacáyqueyra,” wajáquinro. Jesusat wajác tamo sehw̃ar, ojocro. ");
INSERT INTO tuf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Etar bahnác cuanyat, sacerdote carin cat, werjayín cat, bachan chihtán siw̃quin cat, judío carin bahnaquin owár bin tew̃ín acu sécuajacro. Tew̃ír Jesús questajacro. Questár Pilato acor béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato cac cahm cucayat, Pilátoat Jesús quin táyojocro: —¿Bah judíoin cáraica? ¿Judíoin réyica? wajacro. Etat Jesusat wajacro: —Ee, bahat táyocan cábaro. Asan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Etat sacerdote cárinatan ey cahm icar tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Eyinat tew̃yat acat, Pilátoat Jesús quin wajacro: —Eyinat bah cahm icar tew̃yat acat ¿bahat ajc wática? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eyta wacayat cat ajc chin chájacro. Ajc chin cuácayat, Pilato ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilátoat bar istiy, bar istiy fiesta cuitar cárcel icar tunjaquin sicar bin úbisti úcaro. Uwat cárcel sar, bi uquin chíctara, ey úcaro. ");
INSERT INTO tuf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ey rícara uw cárcel icar tunjác sicar bin ser istiy ajc Barrabáscuano. Cahmor uw cahujinat gobierno owár tec quej yinjacro. Barrabás cat eyin cuitar tec quej yinjacro. Eyinat eyta tec quejcayat uw tíw̃jacro. Etar cárcel icar tunjacro. Barrabás cat eyin owár tunjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Etar ricán to binat Pilato acor béhjecro. Behquir Pilato quin wajacro: —Bar istiy, bar istiy fiesta cutar uw cárcel icar bin uquir eyta ah cat eyta uwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Etat Pilátoat eyin quin táyojocro: —¿Jesús judíoin cara ucátaica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilátoat ítitan, sacerdote cárinatan Jesús ac boran abáy rehquitra im at icar wíjacro. Eyta istír ricá quínoa táyojocro. ");
INSERT INTO tuf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eyta táyoyat sacerdote cárinat uw tan téjecro. Jesús chiti Barrabás chiín acu uw tan téjecro. ");
INSERT INTO tuf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Etat Pilátoat eyin quin bucoy wajacro: —¿Barrabás úcayat, Jesusra? ¿Aját icúr yajcátaca? ¿Baat judío rey cara aw̃úc eyra bitara ácuca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eyta wacayat, bahnáquinat bucoy wajacro: —Eyra yauwin caruc ojcor quejcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Etat Pilátoat wajacro: —¿Icrati yauwátaca? ¿Icúr yajác ques icar yauwátaca? Eyat ur ay bár icrí yájtiro, wajacro. Eyta wacayat cat, éyinat acsar cuít cohwjacro: —Yauwin caruc ojcor quejcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilátoat uwan im owár tur ay cun bár rehjecro. Etar Barrabás tunjaquey uc áyjacro. Cuatán Jesús chistár cuiir cuitar buc áyjacro. Buquír cuitar ima soldádoin at icar wíjacro. Caruc ojcor quejquín acu wíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eyin at icar wícayat, éyinat Jesús gobernador ubach cumac bi sar rauwin béjecro. Usi rauwir car soldado bahnaquin chíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Soldádoin bahnaquin secuar Jesús ojcúm oya buw bi chájacro. Cuis icar cat cachá chistár cuiir chájacro. Churotír chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eyta chaquir, Jesús cac cahm cuscar cut chájacro. Eyta chaquir Jesús buror sisín acu wajacro: —¡Judíoin caru! ¡Judíoin caru! wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eyta waca rabar sischacro. Teca cut Jesús cuisa bucoy cat, bucoy cat bujacro. Jesús cuit cana rihar tijcajacro. Ey cac cahm cuscar cut chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eta jaw̃ buror sischacro. Buror sisír oya buw bi chájaquey sicor sutchacro. Etar sicor imáy ey chájacro. Chaquir caruc ojcor quejquín acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Caruc ojcor quejquín ac beya rabar, ser istiy cájacro. Ser ey ajca Simonro. Cajc ajc Cirene binro. Ey wacj istiy ajca Alejandroro. Wacj istiy ajca Rúforo. Simón eya ácubar cuitar bin racaro. Soldádoinat ey caquir ey quin caruc ahár yehw̃ áyjacro. Jesús quejquín ac bequey ahár yehw̃ áyjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Acsara beyar, terá Gólgota cuitar cujacro. “Gólgota,” cuisa cárara cajc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Erar cur Jesús quin chistár ub rihar mirra cut rihnór wíjacro. Wiquit Jesusat yáhtiro. ");
INSERT INTO tuf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Etar Jesús yauwin caruc ojcor quejecro. Quejquír ey oya soldádoin imár owár tahw̃ujacro. Tahw̃a rabar oya biyat bi cácatatara ey istín acu at sinjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Caruc ojcor quejequin rahsan urá cahm ícatro. ");
INSERT INTO tuf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Quejcayat chihtá caruc cuitar cuihsúr, Jesús cuisa aracat quejecro. Bi chihtá ques yauwíctara ey istín acu cuihsúr chájacro. “Judíoin rey cáraro,” cuihsúr chájacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús caruc ojcor quejquír cat, cuic rahray wihár caruc istiy ojcor besib istiy, cuic rahray wihár caruc istiy ojcor cat besib istiy quejecro, yauwin acu. ");
INSERT INTO tuf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sir carit cutar uchta cuihsú bahjacro: “Eya ur ay bár bin owár chájacro.” wacaro. Etar eyta quejéc cutar Sir chihtá cutar cuihsú bahjaquey uní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Etat icar uwa Jesús acor béjecro. Bequir Jesús quin ajc ahsín cohwjacro. Eyinat Jesusat ay bár yajác ehcún ac imár ac wir wir rehca rabara, ajc ahsín cohwjacro: ");
INSERT INTO tuf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","—Bahat waquít, Sir ubach bahnác quihwír, bay cuanyat sicor oron wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bahat waquít, éytaro. Bahat eyta yajcátair waquít, behmá cat erar bin bar sera waawi, wajacro. Eyta waquír sischacro. Etar sacerdote cárinat, bachan chihtán síw̃quinat rahr rahr wajacro: ");
INSERT INTO tuf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—Eyat cahujín yarata cahm síujacro. Cahujín síujac cuar imara síwajatro. Iman Cristo wácuano. Israel rey cara wácuano. Eyir waquít bar tijca racátaro. Bah tijca raw̃i, -wajacro-. Eyta tijcayat isat istáyqueyra. Istír bah chihtá rahcuinro, wajacro, judío cárinat. Etat ey owár quejéquinat cat Jesús quin im eyta ajc ahsín tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesús caruc ojcor quejquír, rahsa urá cuaquir, chéycara eyta cay tínjacro. Rahs buya tas eyta tínjacro. Cajc bahnác cuitar eyta tínjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Rahsa bui jat Jesusat ay bár cohwjacro: —Eloi, Eloi, ¿lama sabactani? wajacro. Eyta cohwíc eyan uchta wacaro: “Siru, Siru, ¿icrát asa ajcá bár cham bahyi?” wacaro. ");
INSERT INTO tuf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ey cohwyat, acor ítquinat rahcuír wajacro: —Eyat Elías úchicrias bin chícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eyta wacayat, istiyát chistár ub rihar bacua ihirán to bi itáy quinjacro. Istír caros ojcor siw̃jacro. Siw̃ír caruc ubar ojcor questár, yehw̃ rojocro. Roquír Jesusat suhwín acu yehw̃jacro. Eyta wica rabar wajacro: —Elíasatan siway wicátatara wahitinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Etar Jesusat bucoy ay bár cohwjacro. Cohwír, chinjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chinyat acat, Sir usi oya wiricasá rújaqueya ubut oso rach bijacro. Cuacracat bi bahnác ic icar tas rach bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesús chinyat acor soldado carat ey acor cuar Jesús chiníc itchacro. Eyta istír wajacro: —Ser uya uní Sir waquijró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ey terá cuitar cat wiw̃inat cajc bira cuit cuar wahitchacro. Wiw̃ eyin Jesús owár cajc Galilea bin rojocro. Eyinat Jesús obir yajáquinro. Wiw̃ istiy ajca Maríaro. Eya Magdala pueblo binro. Istiy cat ajca Maríaro. Eya Santiago yahncút ey abró. Josein abró. Istiyá ajca Salomero. Wiw̃ín cahujín to bin cat ésatro. Jesús owár wiw̃ín eyin Jerusalén béjequinro. ");
INSERT INTO tuf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesús chiníc cuitar rahs raújacro. Tan jaquin acu oroc ricar rahs raújacro. Cuanmí cut tan jaquin ricar cuanata rehjecro. ");
INSERT INTO tuf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Etar ser istiy Pilato quin wijacro. Sera eya ajca Josero. Uwat ítitan eya ur ayro. Judío carin owár sécuaquin binro. Pueblo Arimatea binro. Eyat Sirat cara rehquíc acor itro. José eya Pilato quin wiquír, Jesús chein ruhcuín acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chícayat Pilátoat ub yehw̃jacro. Jesús bar chinjác séhw̃ati rehquít ub yehw̃jacro. Etar soldado cara chíjacro. Chiír táyojocro: —¿Jesús bar chinya? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Etat soldado carat wajacro: —Ee, bar chinjacro, wajacro. Etat Joseat chein beyin Pilátoat ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Etar Joseat lienzo wiricás wáhjacro. Wahr car Jesús chein caruc ojcor bin tijcajacro. Tijcár wiricás cut bacojocro. Bacór car ac ucar icar chájacro. Ac ucar eya chein ruhcuín acu récaji órojoquinro. Jesús chein ey icar chaquir car, ucar canó ohná cumac bi chájacro. Ohná wihca beyar chájacro. Chaquir bijacro. ");
INSERT INTO tuf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Joseat yajquíc María Magdala binat cat, istiy Maríat cat úrojocro. Etar Jesús chein biscán ruhjactar itchacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tan jaquin ricar bar tínjacro. Tinyat wiw̃inat inan ay bi wahjacro. Jesús chein cut beyin ac wahjacro, ey cutar chaquin acu. Istiy wiw̃á María Magdala binro. Istiy cat María Santiago abró. Istiy Salomero. ");
INSERT INTO tuf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Inan ay bi wahr car seman istiy rauyat, cuan bicayat, béjecro. ");
INSERT INTO tuf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Beya rabar rahra rahra wajacro: —¿Ac ohná ucar canó chájaquey is acu rehrát waca tétaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Erar cur ítitan, ac ohná chein ruhjác ucar cutar tunjaquey waar bo tejec itchacro. Ac ohná cúmacan to ey waar bo tejec itchacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eyta istír chein ruhcuíc ac ucar sar raújacro. Rauwir ítitan, síbijin ésatro. Bajít tajqui wihár itro. Ey oya cuas bin ow̃ro. Ey istír ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Etar síbijinat wiw̃ín eyin quin wajacro: —Ojc siti jaw̃i. Baat Nazaret bin Jesús uroy rojocro. Caruc ojcor quejequey uroy rojocro. Ey uroy rojóc cuar, usari batro. Eya sicor estají yehnjacro. Ey chein chajac cutar wahítuwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ey itáy rojóc cuar sicor béowi. Jesús ima chiwa quin ehcwáy béowi. Pedro quino cat ehcuwi. Uchta waw̃i: “Jesusra behmár cahmor Galilea ben wacaro. Erar baat Jesús istáyqueyra,” waw̃i. Eyat eyin quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eyta wacayat wiw̃ín eyin sicor watar waajacro. Watar waar quinjacro. Eyin ojc siquir tíuro. Etar quinjacro. Ojc sijác rehquít, ibit awat istiy quini icurí ehcútiro. ");
INSERT INTO tuf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semán récaji rícara cuanyat Jesús sicor yehnár, María Magdala bin acat waajacro. María ey ur icar bin récaram cuicá cucuí uc si ayjac biro. ");
INSERT INTO tuf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús chiwa Jesús chinjác sehná rehquít cue rehjecro. Jesús María acat waacayat, Maríat Jesús chiwa quin Jesús sicor yehnjác chihtá ehcwáy bijacro. Cur car eyin quin wajacro: —Jesús sicor yehnjacro, -wajacro-. Aját Jesús itchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maríat eyta wacayat, éyinat “uní téw̃tiro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","María acat waar yahncút, cahujín cuisa bucáy bin acat waajacro. Cuisa bucáy eyin ácubar cut tiw̃ béjecro. Erar bécayat Jesús eyin acat waajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Etat eyin chiwa cahujín quin sicor béjecro. Cur Jesús eyin acat waajác ehcujacro. Eyta cuar cahujinat “uní tew̃ti,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ruw̃ár ojcor Jesús ima chiwa once bin acor waajacro. Eyin mesa cutar cuácayat waajacro. Waar car eyin quin ajc uní cuitar wajacro. Ima sicor yehnti síhw̃ajac ques ajc uní cuitar wajacro. Uwat eyin quin ima sicor yehnjác wajác cuar, éyinat uní síhw̃ati ques ajc uní cuitar wajacro. ");
INSERT INTO tuf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Etar acsar Jesusat eyin quin wajacro: —Cajc bahnác cuitar béowi. Beya rabar uw bahnaquin quin as chihtá ay bi ehcuwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bíyinat as chihtá cácayat, as chiwa chajac ehcún ac rih sar siw̃yat, aját eyin síwayqueyra, Sir tayar ques sácati acu. Bíyinat as chihtá cátieyra aját eyin síutiro. Sir tayar ques sácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bíyinat as chihtá cájactara uchta istáyqueyra. Eyinat as urá cut cuicá uw urá sar bin te si áyayqueyra. Eyinat anto cuw sinti bin tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Eyinat cumoró yehw̃yat yara báreyra. Eyinat yeruba yácayat, yara báreyra. Eyinat yarquey cuitar atcar chácayat, yárqueyan bar tan jácayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesusat chiwa quin eyta waquír, cuacúr Sir quin bijacro. Bir Sir owár chihrjacro, uw ayin acu. ");
INSERT INTO tuf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesús bi yiror, chiwa cajc bahnác cutar béjecro. Beya rabar chihtá ay bi ehcujacro. Cara Jesusat eyin cuitar yajacro. Eyinat chihtá uní tew̃ic ehcún acu Jesús urá cut chihtá istiy, chihtá istiy ay yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teófilu, aját ba tamo séhw̃aro. Is tac icar yajaquey aját ey ehcunro. Carit cuitar cuihsúr ehcuro. Cahujinat cat im ey ojcor ehcún ac cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chihtá ehcúquinat récaram imár ub cuit itchaquey ehcujacro. Ehcwayat cahujinat rahcuír ey ojcor cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aját cat is tac icar récaram ah ocso tas yajaquey rahcuítchacro. Rahcuitír aját ey ay sínjacro. Ay itro. Eyta bijira aját bah quin acsar ehcún acu cuihsún séhw̃aro. Bah quin carit cuit ay ehcún séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bahat ey chihtá ay sínayta acu cuihsún séhw̃aro. Bah quin ehcujaquey tehmoti istayta acu ehcún séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea cajc cutar Herodes rey cara chájacro. Herodes cara rehcayat, sacerdote ajca Zacarías chájacro. Zacarías eyan Abíasin owár binro. Cohtá Abías cut Aarón bomcatró. Zacarías wiya ajca Isabelro. Isabel cat Aarón bomcatró. ");
INSERT INTO tuf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías cat, Isabel cat Sirat ítitan, urán ayro. Sir bachan chihtán ay rahcro. Wácati yajcaro. Eyta yajcayat, Sirat ítitan, ay baran icurí yájtiro. ");
INSERT INTO tuf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eyta cuar, sasá batro. Isabel sasá cóhnajar biro. Chauwíc cat bar chauwicro. Zacarías bar werjayró. ");
INSERT INTO tuf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Riy istiy Zacarías owár Sir usar ruóqueyin Sir usar ruón acu cab cujacro. Etar Zacarías Sir usar ruojocro. ");
INSERT INTO tuf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Eyta ruoyat, Zacarías Sir usar Sir ojcor conín cájacro. Está ruhw̃á aquibo wahnín cájacro. Judíoinat bara istiy jat sacerdote istiy, bara istiy jat sacerdote istiy eyta yajquín acu cájacro. Etar Zacarías cájacro. Cácayat Zacarías Sir usi eyta yajquín acu raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sir usi rauyat icar aw̃at, uw ricán to binat watar cuar Sir ojcor conjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sir usi rauyat, Sir cuacúr cacmá ey ubot waajacro. Cuacúr Sir cacmá aquibo wahníc oc acor waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaríasat Sir cacmá istír, ojc sijacro. Ehúr wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Etat Sir cuacúr cacmát Zacarías cucaj acat wajacro: —Ehúr rehti jaw̃i. Rooti jaw̃i. Cuatán bahat Sir ojcor conjacro. Conyat Sirat rahjacro. Eyta bijira bah wiya Isabelay waquíj sera sah yehnátaro. Waquíj ey ajca Juan chácataro. ");
INSERT INTO tuf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yehnyat bah cat, uw cat cue rehti ítataro. Ahní rehcátaro, -wajacro Zacarías quin-. ");
INSERT INTO tuf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sir ub cahmor, Tet ub cahmor cara yehnátaro, -wajacro-. Sima cat bow̃an abáy bira yahti ítataro, -wajacro-. Anto ab ohc cut bin yehnti cuat echí Sirat im Ajcan Camur Ey ey ur ícara chácataro. ");
INSERT INTO tuf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eyat Sir chihtá ehcwayat israélinat sicor ey rahcuátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elíasan úchicri Sir chihtá ehcúquibro. Ajcan urán cuít chájacro. Sir sah wiquín cahmor, Sir waquíj wiquín cahmor, bah wacjá cat Elías ajc eyta, ur eyta rehcáyqueyra, -wajacro Sir cuacúr cacumát Zacarías quin-. Eyta rehquír Sir chihtá ehcwáyqueyra. Ehcwayat, tetinán imár sas owár tan wan chac áyayqueyra, -wajacro-. Chihtá cati eyin quin chihtá cac áyayqueyra. Urán ay sihw̃ áyayqueyra. Eta jaw̃ Sir sah wiquín cahmar ey chiwa chaquin acu uw urá tehmó áyayqueyra. Bah sah awan yehnyat, cunír car eyat eyta yajcáyqueyra, wajacro, Sir cuacúr cacmát Zacarías quin. ");
INSERT INTO tuf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Etat Zacaríasat wajacro: —¿Aját bahat uní tew̃ic istín acu bahat icúr yajcátaqui? Cuatán asan werjayán cuitro. As wiya cat chaucan cuitro, -wajacro-. Isatra sasá bitách cóhnajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Etat Sir cacmát wajacro: —Asa ajca Gabrielro. Asan Sir cacumró. Sirat bah quin as áyjacro. Sirat bah ac chihtá áyjacro. Chihtá ay bi áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ahra uch rahcwi. Bahat aját wajaquey uní séhw̃atiro. Bahat uní séhw̃ati etar bah waquíj yehníc ocso tas bah ajc bár rehcátaro. Bahat bitách téw̃ajar ítataro. Eyta cuar bah wacjá yehníc cab cucayat, bar yehnáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eyta tew̃yat icar aw̃at, uw ricán to bin Zacarías sicor watar waaquíc acor itro. Eyta ityat uwat síhw̃ajacro: “¿Uchicri watar waati bitara étarqui?” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Itchareht sicor watar waajacro. Etat uwat itit, eyat bitách téw̃ajatro. Ajc bár rehjecro. Eyta istír car uwat síhw̃ajacro: “Eyat Sir cuacúr cacúm itchacro,” síhw̃ajacro. Etat sicor waar, cuw cut téw̃ajar rehquít at cut bácabac tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yájcajareht Zacaríasat Sir usar canar bahnajacro. Canar bahnár, sicor im usi bijacro. Usi cur ");
INSERT INTO tuf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","biráy bár cuanyat, wiya yir ji rehjecro. Isabel yir ji rehquír, sihyór esian usi ítchacro. Eyta ita rabar ur icar séhw̃ajacro: ");
INSERT INTO tuf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ahra Sir imát as tamo séhw̃ajacro. Uwat récaram as sasá bár cuácayat, as ajcá bár chájacro. Cuatán ahra uwat as ajcá ji chácayta acu Sirat as tamo séhw̃ajacro,” séhw̃ajacro, Isabelat. ");
INSERT INTO tuf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel yir ji rehquír, sihyór teray cuácayat, Síratan cacúm ajca Gabriel bucoy áyjacro. Cahbár ajca María quin áyjacro. Chihtá beyin ac áyjacro. Nazaret pueblo cuitar Galilea cajc cutar cun áyjacro. Ayat Gabriel María quin bijacro. María eya sera jor anto cámtiro. ");
INSERT INTO tuf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Eyta cuar awan José jor yehw̃ín wajáquinro. José David bomcárcuano. ");
INSERT INTO tuf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrielat María quin cur wajacro: —Maríu, as racaro. Bah ac chihtá roquiri. Sirat bah rácatro. Sirat bah cuitar wacaro. Ey wacay rajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eyta wacayat, María ay wini rehjecro. Ehúr wini rehjecro. Etar séhw̃ajacro: “Bi ojcor tew̃ictar aját ráhctiro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eyta cuácayat, Sir cacúm Gabrielat wajacro: —Mariú, rooti jaw̃i. Ay wini rehti jaw̃i. Sirat bah rácatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Awan Sir urá cuitar bah yir ji rehcátaro. Sera sah yehnáyqueyra -wajacro-. Bah waquíj yehnyat, ajcan Jesús chaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bah wacján caran cuít yehnáyqueyra. Eyta bijira bahnáquinat ey ojcor wacáyqueyra, “Eyan cuacúr Sir waquijró,” wacáyqueyra, bahnáquinat. Sir urá cuitan eyan caran cuít yehnáyqueyra. Is cohtín David cara yehnjác eyta ey cat caran eyta yehnáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eyta yehnyat israelin ey chiwa yináyqueyra. Cara yéhnyatan téhmojotro. Ey cara rehquey bur cut suw cut rehcáyqueyra, wajacro, María quino. ");
INSERT INTO tuf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Etat Maríat wajacro: —¿Uniqui? Asra ser owatra anto cámtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Etat cuacúr cacmát wajacro: —Sir Ajcan Cámuran Eya bah quin wicáyqueyra. Sir Ajcan Cámuran Eya bah jor ítayqueyra. Eyta cuácayat saha yehnyat, ur ay bár icúr bi yájtiro. Eyan Sir imáy yehnáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bah cayin Isabel tamo séhw̃awi. Isabel cat yir jiro. Chauwíc cuar sah ji it bijacro. Ahra sah it bijacan sihyór térayro, -wajacro-. Chauwíc Isabel cóhnajar wajác cuara, ahra yir jiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eyta bijira Sirat yájcajaran bii batro. Bahnác bar yajcátaro. Sir ima urá cuitar chauwíc cat saha cohnátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eyta wacayat, Maríat wajacro: —Ihyú. Asan Sir cacumró. Etar aját ey chihtá yajquinro, wajacro. Wacayat, Sir cacúm sicor cuacúr bar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sir cacúm María ac chihtá roquír sicor cuacúr bicayat, boni bay cuanyat, María bar yehnár bijacro. Judea cubar cuit in cuwín bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bir Judea pueblo cuit cur, Zacarías usi cujacro. Cur car Isabel quin ténajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabelat María ajc rahcyat, Isabel ima yir sar wacjí bar isojocro. Abáy isojocro. Etat Sirat ima Ajcan Cámuran Eya Isabel ur icar wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Eyta wícayat, Isabelat ajcyaran to tew̃jacro: —Maríu, bahan Sirat obir yajacro, -wajacro-. Wiw̃ín cahujinra étai obir yájtiro. Bahan cuít obir yajacro. Bah sah yehnata ey cat obir yajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Asra chíwaro. Bahan as cara abró. Eyta cuar ¿bah usár as quin wic waátaqui? ");
INSERT INTO tuf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bah wicayat as quin ténayatan, as wacjí yir sar eyan abáy isojocro. Ahní rehtan abáy isojocro. ");
INSERT INTO tuf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bahatan Sir cuacúr cacmát uní wajác séhw̃aro. Sir urá cut bah wacjá yehnata séhw̃aro. Bahat eyta sehw̃ac etar Síratan bah ay obir yajcátaro, wajacro, Isabelat María quino. ");
INSERT INTO tuf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Etat Maríat wajacro: Asan conú cuar Sirat as tamo séhw̃ajacro. Asan Sir cacumró. Eyta cuácayat, ajmár urá cutar as Sir tamo, ");
INSERT INTO tuf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","as Síuquib tamo, as Cara tamo sehw̃ar ahní rehcaro. ");
INSERT INTO tuf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Síratan, as Síuquibatan as tamo ay séhw̃ayatan, ay yajcáyatan, ah cut uwat cat, yáhnacat uwat cat Sirat as ay obir yajác, it wacáyqueyra. Siran ayro, -wajacro, Maríat-. ");
INSERT INTO tuf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bíyinat Tet cahmor ayú rehcáyatan, Síratan Tetatán eyin acsar acsar racar obir yajcaro, -wajacro, Maríat-. ");
INSERT INTO tuf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Sirat ima urá cut ay yajacro. Uw cahujinat imaran ayan cahujín cuít síhw̃ajacro. Eyta síhw̃ajaqueyin, Síratan im urá cut, cui si áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Reyin cat, carin cat im usar bin Sirat uc tijcajacro. Uc tijcár chiwa caquir carin yin áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yayí bin quin yayín acu, cohn acu wíjacro. Eyta cuar oya ji binra, ray ji binra sicor ata áyjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sirat im chiwa cuitar israelin cuitar yajacro. Eyin cuécuti obir yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Imát yajquín wajacan wácati yajacro. Abrahamin quin, ey bomcarin quin, is cohtín quin imát wajacan wácati yajacro. Wácati cuara eyin etiti obir yajcaro, wajacro, Maríat. ");
INSERT INTO tuf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María Isabelin owár sihyór bay ítchacro. Eyta itir sicor im usi bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","María bi yiror, ítchareht, yájcajareht, Isabel wacjí ubot wiquíc cab cujacro. Etar sera sah bar yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yehnyat intac ítquinat cat, cáyinat cat sah yehnjác chihtá rahjacro. Rahcuír síhw̃ajacro: “Sirat Isabel ac ay yajacro. Waquíj wíjacro,” síhw̃ajacro. Eyta sihw̃ar, ey owár ahní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yehnár abi cuanyat, sah ey umá cuiquíc cab cujacro. Eyta yajquín acu sécuajacro. Ey ajc chaquin yinjacro. Eyta chacay yinyat, uwat ima tet ajc eya chaquin síhw̃ajacro. Ajcan Zacarías chaquin síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eyta cuar ey abát wajacro: —Eytara chati jaw̃i. Ajcan Juan chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Etat uwat wajacro: —¿Bitara rehtqui? Bah cohtín bah cayin ajc eyta bini batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eyta waquír tet acat atcar cut bácabac tew̃ír cuit táyojocro. Ajcan bi cháquintara ey táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Táyoyat, Zacaríasat ajquey icúr cut cuihswátatara ey chíjacro. Chícayat rojocro. Rocayat Zacaríasat uchta cuihsujacro: “Ey ajcan Juan chaw̃i,” cuihsujacro. Eyta cuácayat, bahnaquin ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Etat acat Zacaríasan sicor ajc chi waajacro. Sicor tew̃jacro. Sir ojcor ay tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eyta cuácayat, intac ítquinan bahnaquin ub yehw̃jacro. Uwat rahra rahra imarat itchaquey ojcor tew̃jacro. Judea cubar cutar uw bahnáquinat rahra, rahra eyta tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bíyatan eyta tew̃ic ráhcyatan, eyin bahnáquinat eyta tew̃quey ojcor síhw̃ajacro. Sihw̃ar ítitan, Sirat sah ey cuitar yajcaro, síhw̃ajacro. Eyta sihw̃ar wajacro: —Sahan ey cunyat, caran cuít rehcata óraro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sah tet Zacaríasat sicor ajcan cuwan uchta tew̃yat, Sir Ajcan Cámuran Eyat urán cuít wíjacro. Eyta wícayat, Sir chihtá tajacro. Uch tajacro: ");
INSERT INTO tuf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israel Siran ayro. Caran ayro. Is tamo, ima uw tamo, israelin tamo séhw̃ajacro. Is cuitar wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Síratan Cáratan is acu, israelin acu Uw Síuquib urán cuít bi yehn áyjacro. Cohtá David bomcar yehn áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uchicrias chihtá ehcuquib cutar cuar uchta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Is quehsí bin ohnor, ur ay bár bin ohnor is síwata wajacro. Is cuitar wacata, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Is cohtín cuitar yajquín wajacro. Imát wajacan etiti yajquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Is cohtá Abraham quin uchta yajquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Is quehsí bin cahm siwin wajacro. Ehurí bár ima tamo síhw̃ayta acu is siwin wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Im ub cahmor ur ay rehquír cat, ay yajquír cat ehurí bár síhw̃ayta acu is siwin wajacro. Is yaric ocso tas eyta síhw̃ayta acu is siwin wajacro. Zacaríasat eyta tajacro. Zacaríasat eyta tar, ima buwachcuar quin tar wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wacjú, sahú, baha ojcor uw bahnáquinat wacátaro: “Baan Sir chihtá ehcúquibro,” wacátaro. “Cuacúr Sir chihtá ehcúquibro,” wacátaro. Baha Cara raquíc cahmor, uw quin ey ojcor siw̃ay bétaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bah uw quin bir eyin quin wacáyqueyra: “Sirat uw tayar bár chaquir car eyin síwayqueyra,” wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sirat ima urá cut is sehnacro. Etar cuacúr bin cuan ayquib is quin áyayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chiníc cahmar Tetát cuan áyataro. Chiníc cahmar ruhw̃úc cahmar ehúr bár jácataro. Tan wan jácataro. Eyta cuan áyataro, wajacro. Zacaríasat buwáchcuara quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Itchareht, yájcajareht Juan cunjacro. Urán cuít cunjacro. Cunír car uw bár cajc cut ítchacro. Acubar ítchacro. Israelin ubot waac ocso tas erar ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ey rícara cara rey cuít bíjiyat chihtá waquír áyjacro. César Augustoat bahnaquin quin ehcún waquír áyjacro. Uw bahnác cuisa bítatara saw̃ún wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uw saw̃ún wacayat icar aw̃at, Siria cajc cutar caran Cirenio jájacro. Cahmor uw eyta saw̃útiro. Ahra saw̃ún wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eyta waquíc cut uwa bahnáquinan imár cohtín pueblo cut béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josein Galilea cajc cut bin Nazaret pueblo bin Judea cajc cut cuwín béjecro. José David bomcar etar Belén pueblo cuwín béjecro. Belén cut David pueblo cut cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josein María jor saw̃ún béjecro. María ey jor yehw̃ín wajaquin etar owár béjecro. María yir ji bin bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Etar Belén cucayat, wacjí ubot wiquíc cab cujacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Etar wacjí bar yehnjacro. Quesmát yehnjacro. Sera sah yehnjacro. Yehw̃ír car, oya tamo bacojocro. Bacór car vaca chohcha cahmor cámjacro. Camic úsatra caisi etar vaca chohcha cahmor cámjacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ey pueblo intac obas cayin itro. Acubar cuitar itro. Cáyinat chéycara cuitar obas obir yajcaro. ");
INSERT INTO tuf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eyta obir yajcayat Sir cuacúr cacmá eyin ubot waajacro. Waacayat, rahs churotán wan bin Sir churot eyin rúhracat wan beo beo waajacro. Eyta waacayat istír ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Etat Sir cuacúr cacmát eyin quin wajacro: —Ojc siti jaw̃i. Rooti jaw̃i, -wajacro-. Ajatán chihtá ay bi roquiri. Ba acu chihtá ay bi roquiri, -wajacro-. Uch chihtá cuitar bahnaquin ahní rehcátaro. ");
INSERT INTO tuf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rahcwi. Ah cheycar sah yehnjacro. Sah ey Uw Síuquibro. Crístoro. Ba cáraro. Sah yehnjaquey Sirat áyjacro, -wajacro-. Cohtín David pueblo Belén cuitar yehnjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Biyan sahan éytara uchta jaw̃ istáyqueyra. Sah oya tamo bacojoquey, vaca chohcha cahmor cámjaquey istír “sah eyan eyro,” síhw̃awi, wajacro, Sir cacmát obas cayin quino. ");
INSERT INTO tuf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eyta tew̃yat icar Sir cuacúr cacmín chiwan to bin eyin quin béjecro. Bequir uchta wac tajacro: ");
INSERT INTO tuf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Cuacrár cuar Siran ayan cuitro, -wac tajacro-. Cajc cutara itquin ohbac ítuwi. Uw Sirat sehnác bin ohbac ítuwi, wac tajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Eyta tar car Sir cacmín sicor cuacúr bar béjecro. Bey yiror obas cáyinat rahra rahra wajacro: —Bar jaw̃a, isa Belén cuwayta, erar wacjí yehnjaquey wahitay. Sir cacmát is quin ehcujaquey wahitay bar jaw̃a, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Waquír car Belén in chásarac béjecro. Belén cur itit, María cat, José cat vaca chohcha cahmatro. Buwachcuar cat ey cahmar camro. ");
INSERT INTO tuf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Buwáchcuara istír imarat chihtá rahjaquey uw quin ehcujacro. Sir cuacúr cacumát buwachcuar ojcor wajaquey ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ehcwayat uwat rahjacro. Rahcuír ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Eyta cuar Maríara cuít séhw̃ajacro. Ur icar bucoy, bucoy ey tamo séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Obas cayin buwachcuar istír sicor béjecro. Beya rabar Sir ojcor ay wajacro. Sirat rahcuayta acu tajacro. Imarat rahjác ojcor, itchác ojcor “Sirat bahnác ay yajacro,” wajacro. Eyinat itit, Sir cacmát wajacan bahnacan uní wajacro. Eyta istiran “Siran ayro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Buwachcuar yehnár, abi cuanyat, umá ehsujacro. Ehsúr ajcan Jesús chájacro. Anto ab ojc cut it biti cuat echí, Sir cuacúr cacmát ajcan eyta chaquin wac bahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Saha yehnár bach yajacro. Itchareht yájcajareht sah bach bar waaquíc cab cujacro. Eyta cuanyat ab cat, tet cat sicor Sir ub cahmor orac chácayta acu Jerusalén cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sir bach cáritan chihtá cáritan cuitar uchta cuihsú bahjacro: “Quesmát sérinan Sir imáy chácataro.” Eyta yajquín cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sir chihtá cuitar atcur sasatar, ruscar sasatar bucáy yauwata cuihsú bahjacro, Sir tayar tunin eyta yauwata cuihsú bahjacro. Etar eyta yauwin béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalén cur car sera ajca Simeón itchacro. Simeón eyan Jerusalén cuitar itro. Urá istanacro. Sir tamo cuít séhw̃aro. Sir Ajcan Cámuran Eya ey ur ícatro. Eya israelin Síuquib yehníc acor itro. ");
INSERT INTO tuf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sir Ajcan Cámuran Eyat ey quin chihtá wajáquinro: “Cristo anto yehnti eyra bah yárajatro. Sirat Cara Ayin Wajaquey yehníc ocso ítataro,” wajáquinro. Eyta bira Cristo yehníc acor itro. ");
INSERT INTO tuf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Etar Sir Ajcan Cámuran Eyat Sir usi Simeón áyjacro. Ayat Simeón Sir usi bijacro. Esar ityat buwachcuar tet cat, ab cat raújacro. Buwachcuar yehw̃ír rojocro. Sir bach cáritan, Sir chihtá cáritan cutar bitara yajcata wáctara eyta yajquín acu raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Rauyat Simeonat eyin tihrjacro. Tihrír car buwachcuar tanor yehw̃jacro. Yehw̃ír Sir quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Siru, baha urá ayro. Bahat Uw Síuquib ayin wajacro. Ahra bar áyjacro. Ajmár ub cut Uw Síuquib yehnjác itchacro. Uw bahnáquinat bah chihtá istayta acu yehnjacro. Judío uw bár binat cat bah chihtá istayta ac yehnjacro. Bah chihtá istír eyin ur icar cuanjacan wan rehcáyqueyra. Israélinat “bah ayan cuít,” síhw̃ayta acu yehnjacro. Eyta cuácayat, asan ahra ohbac yarátaro, wajacro, Simeonat Sir quin. ");
INSERT INTO tuf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ima wacjá ojcor eyta wacayat, tetát cat, abát cat ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Etat Simeonat eyin cuitar Sir quin conjacro. Conár car María quin wajacro: —Rahcwi. Sah uch yehnín waquír chájacro. Sah uch yehnjaquey chihtá cuitar Israel cahujín sácataro. Cuatán cahujinra síwataro, uy chihtá cuitar. Sirat sah uch cuitar uw siwin wacaro. Eyta cuar sah uch cahm icar cahujinat tew̃áyqueyra. Quehswáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Eyta cuácayat uwat ur icar bitara síhw̃actara Sirat ey ehcwáyqueyra. Bah urán cuean to rehcáyqueyra. Uwat bah waquíj ruhw̃áyqueyra. Ruhw̃uyat bah cona chináyqueyra, wajacro, Simeonat María quino. ");
INSERT INTO tuf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simeonat eyta wacayat, wiw̃á ajca Ana cat Sir usi raújacro. Ana eya Sir chihtá ehcúquibro. Ana eya cohtín Aser bómcatro. Fanuel waquijró. Ahra chaucan cuitro. Uchicrias anto cahbár jácayat ra cuájaquinro. Ra cuaquir bara cucuí cuat ra chinjacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ahra chinjacan bara ochenta y cuátroro. Sir usi itro. Esar ita rabar ricar cat, cheycar cat Sir tamo séhw̃ajacro. Sir ojcor conjacro. Sir tamo sehw̃an ac ira yati báchujacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeonat María quin sah ojcor tew̃yat, Ana cat Sir usi raújacro. Rauwir Sir quin conjacro. “Siru, bah ur ayro. Bahat Uw Síuquib áyjacro,” wajacro, Sir quin. Acsar cat uw quin tew̃jacro. Bíyinatan Sir tamo síhw̃actar eyin quin Jesús ojcor tew̃jacro. Bíyinan Jerusalén Uw Síuquib wiquíc acor ítictara eyin quin tew̃jacro. “Sirat Uw Síuquib bar áyjacro,” wajacro, Anat. ");
INSERT INTO tuf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sir bach cáritan chihtá cáritan cuitar sah yehnyat bitara yajcátatar cuihsú bahjacro. Eyta bijira Joséinat ey chihtá bahnác yajacro. Eyta yajquír, sicor cajc Galilea cuwín béjecro. Imár pueblo Nazaret cuwín béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Erar cucayat, waquíj bar cun bicaro. Saha eyan chihchirán, canarán, urán, tanan to cun bicaro. Sirat eyan ay obir yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bar istiy, bar istiy Jesús tetinán abinán Jerusalén béjecro. Bach ajca chéycara aracat bijaquey yajcáy béjecro. Uchicrias Siran cohtín ubach aracat uw yauti bijacro. Siran aracat uw yauti bijác ey sihw̃an acu judíoinat bach yájcuano. Cheycar aracat bijaquey bach ajc istiy cut Pascua fiesta aw̃uro. Jesús tetinán Pascua fiesta Jerusalén cutar yajcáy béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús yehnár bara doce cuácayat, bucoy béjecro. Jesús cat eyin owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Etar fiesta bahnyat, sicor imár usi cuwín béjecro. Cahujín bécayat, Jesús síbiji biti ítchacro. Jerusalén ítchacro. Tetinát abinát istiti ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tetinát abinát síhw̃ajacro: “Jesusan uw owár bic,” síhw̃ajacro. “Ricá tac icar bic,” síhw̃ajacro. Etar ohbac riy istiya acat quesi béjecro. Tinyat Jesús wahitay yinjacro. Cayin owár bíctara wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Eyta cuar istítiro. Uror bár rehquít, sicor Jerusalén wahitay béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jerusalén cur úrojoreht bay cuanyat, tetinát wacjá itchacro. Sir usar itchacro. Ititan wacjá werjayín owár, siw̃quin owár itro. Werjayín chihtá rahcro. Eyin owár rahra rahra chiht istiy, chiht istiy táyoro. ");
INSERT INTO tuf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Etar cahujinat Jesusat tew̃ic rahcuír, “Jesusat ay tew̃ro,” síhw̃ajacro. “Urán toro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Etat abát tetát wacjá istír, ub yehw̃jacro. Etar abát Jesús quin wajacro: —Wacjú, ¿Bitara reht biti ityi? ¿Bitara reht is tamo séhw̃atiqui? -wajacro-. Is ojc sijacro. Bah istiti rehquít, bir cut, bir cut wahitchacro, wajacro, Maríat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Etat Jesusat wajacro: —¿Bir cut bir cut uroy waátaqui? Asan ajmár Tet usar Sir usar ítata biro, -wajacro-. ¿As usar ítata síhw̃ati waátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eyta wacayat, éyinat cucáj cuitar rahcuí cuar, bi ojcor tew̃íctara rahcti rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Etat Jesús eyin owár bijacro. Nazaret cuwín bijacro. Erara ita rabar, Jesusat eyin chihtá ay cájacro. Jesusat werjayín owár bahnác eyta yajaquey yahncút ey abát tan chinti séhw̃ajacro. Bahnác wajáqueyan urá cuitar bow̃ yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Etar ítchareht yájcajareht Jesús urán cuít sin bijacro. Bar cun bijacro. Eyta cuácayat, Sirat cat, uwat cat eyan sehnacan cuitro. ");
INSERT INTO tuf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Juan uw bár cutar ityat, Sirat ey ur icar ima chihtá chájacro. Eyta chácayat, rey ajca Tiberio cara yehnjacan bara quincero. Etat owár cat Judea cajc cutar gobernador Poncio Pilátocuano. Galilea cajc cutar gobernadoran Heródescuano. Iturea cajc cutar cat, Traconite cajc cutar cat gobernadoran Herodes rábcuano. Ey rab ajcan Felípecuano. Abilinia cajc cutar gobernador Lisaníascuano. ");
INSERT INTO tuf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jerusalén cuitar sacerdote cárinan bucayro. Istiy ajca Anás, istiy ajca Caifáscuano. Eyin carin rehcáyatan, Juan ur icar Sirat ima chihtá chájacro. Juan Zacarías waquijró. Juan erar ubach bár cuitar ítchacro. Erar ityat Sirat ey ur icar ima chihtá chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eyta cuácayat, Juan rih Jordán cajc cut cuwín bijacro. Erar Sir chihtá ehcwót bijacro. Uw quin wajacro: —Baat ur ay bár yajquíc etwi. Ur ay bár yajquíc etchác cahujinat istayta acu as quin ba rih sar siw̃ aywi. Sirat baat ay bár yajquíc tayar bár chácayta acu eyta etwi. Eyta siw̃ aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sir chihtá ehcuquib Isaíasat úchicrias carit cuitar uch cuihsú báhjacro: Serat ubach bár cuitar cohwro. Eyat wacaro: “Cara wiquín cahmar uwat bahnác órowi. Ey wiquíc cahmor ibit cat cawi. ");
INSERT INTO tuf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Rih tor arán cuhsan sicor acan wan órayqueyra. Cuhs cat, cubar cat sicor acan wan órayqueyra. Ibit quehwu quehwu eyan tuní órayqueyra. Ohcuá cat ácatar órayqueyra. Cara raquíc cahmor uwat ibit órayqueyra. Cara raquíc cahmor ibit oror eyta Sirat áyata ey yehníc cahmor cat uwat imár urá eyta órotaro. Ur ay bár chájaquey tehmótaro,” wajacro. Eyta cohwro. ");
INSERT INTO tuf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Etar cat uwat ítitan Sirat uw síwataro. Cajc bahnác cut uwan bítatara bahnáquinatan eyta istátaro. Isaíasat eyta cuihsú báhjacro. Récaram cuihsú báhjaquey ahra Sir ajc cutar bar yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eyta cuácayat uw ricán to bin Juan quin béjecro. Ubach bár cuitar Juan quin béjecro. Juanat rih sar siw̃ayta acu béjecro. Eyta bécayat Juanat uw quin wajacro: —Ba cumoroán wanro. Ricumán wanro. Ba Sirat cuécwata cahmar ruhcuín síhw̃aro, -wajacro-. ¿Rehrát ba eyta ruhcua ayi? -wajacro-. Sir cahmor rúhcuajatro -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ruhcti cuara ay yajw̃i. Uwat baat ay bár yajquíc etchác istín acu ay yajw̃i, -wajacro-. Cuáyatra séhw̃ati jaw̃i. Ba Abraham bomcar rehquít, ¿Sirat ba cuécwajari síhw̃aqui? -wajacro-. ¿Ba tanra eyta síhw̃aqui? Eytara batro. Aját ba quin wacaro. Sirat ac ohná chajac sicar Abraham bomcar cohn cun rehquír waquít, bar cohná ucátaro, -wajacro-. Eyta bira ba Abraham bomcar reht Sirat ba cuécwajatra, síhw̃ati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Uch rahcwi. Uwat cárucua ub cháctara ub chátitara wahitro. Wahitír ub chati eyra tac técaro. Tac tetran oc icar wahnro. Uwat caruc taquir eyta, wahnár eyta Sirat cat eyta yajcaro. Uw urá ay bár binra bahnaquin cab oc icar si ayir wahnro, wajacro, Juanat uw ricá quino. ");
INSERT INTO tuf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Etat uwat Juan quin cur táyojocro: —¿Eytatara isat icúr yajcátaca? ¿Isan Sir úbotan urá ay waan acu icúr yajcátaca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Etat Juanat wajacro: —Bíyayan camís bucáy rehcáyatan, oya bár bin quin úbisti wiw̃i. Bíyayan ira ji rehcayat, ira bár bin quin wiw̃i, wajacro, Juanat. ");
INSERT INTO tuf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Etar cat gobierno tayar chiquin cat Juan quin béjecro. Rih sar siw̃ ayin acu béjecro. Bequir wajacro: —Síw̃quibu, ¿ísatra icúr yajcátaca, urá ay waan acu? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Etat Juanat wajacro: —Gobiérnoat chiín wajác cuitra chiti jaw̃i. Uwa cayar yajti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Etar cat soldádoin cat ey quin cur wajacro: —¿Isatra icúr yajcátaca? ¿Sir ubot ay waan acu icúr yajcátaca? wajacro. Etat Juanat wajacro: —Bes yajti jaw̃i. Uw ahnúr cuitar eyin ohnor ray síuti jaw̃i. Uw cahmí icar cuayar tew̃ír cuitar ey ohnor ray síuti jaw̃i. Canar tayar rayan bita túnictar ray im eya caquir cuitar ahní ítuwi, wajacro. Juanat soldado quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juanat Sir chihtá ehcwayat, bahnáquinat ey tamo síhw̃ajacro. Uwan Sirat Cara Ayin Wajaquey wiquíc acor itro. In bar wicata síhw̃ajacro. Etar Juanat tew̃yat uwat síhw̃ajacro: “Juanan Sirat Cara Ayin Wajaquey óraro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Etar Juanat eyin quin wajacro: —Baat ay bár yajác ques cue rehquír urá tehmoyat, aját ba rih sar siw̃ro, -wajacro, Juanat-. Cuatán istiy as yahncút wicátaro. As yahncút wicata eyan urán as cuitro. Ey urán as cuít etar aját eyra bitách bútajatro. Aját ey ques barcát chistarwan rícuajatro, -wajacro-. Eyan wiquír Sir Ajcan Camur Eya ba cahujín ur icar chácayqueyra, -wajacro-. Cuatán urá tehmoti éyinra oc icar wahnáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Síratan uw urá wahitic cab cucaro. Ay yajáctara, ay yájtitara wahitic cab cucaro. Uchtaan wanro. Uwat eb súcaro, -wajacro-. Suquir búcaro. Bur car sur eyra ajquír chácaro. Cuat um eyra ecar eyra oc cut bo wahnro, -wajacro-. Eb ecar wahnár eyta uw ur ay bár bin cat eyta wahnáyqueyra, -wajacro-. Oca tinti bi cuitar wahnáqueyra, -wajacro-. Uwat eb bur car sura ay biyan ajquír imáy chácaro. Eyta cat ur ay bin cat Sirat eyta imáy ajquír chácayqueyra, wajacro. Juanat uw quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Etara cat búcoyan búcoyan Juanat uw eyta síw̃jacro. Eta jaw̃ Sir chihtá ay bi síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Siw̃a rabar Juanat Herodes técuajacro. Heródesat ima rab ohnor wiya bes yajacro. Rab wiya ajca Herodías yehw̃jacro. Eyta besir yehw̃jác ques Juanat Herodes técuajacro. Bitar utar bucoy bucoy ay bár yajác ques cat técuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eyta cuar Herodesat Juanat tew̃ic ey ráhctiro. Rahcti cuar ubar ojcor ay baran tahnác uchta yajacro. Juan cárcel icar tunjacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanat anto cárcel icar chati cuat uw rih sar siw̃jacro. Jesús cat rih sar siw̃jacro. Eyta siw̃yat Jesusat Sir ojcor conjacro. Jesusat Sir ojcor cónyatan, querat waar eyta cuacúr aba eyta waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Waacayat Sir Ajcan Camur Eya Jesús arcutar rajacro. Atcuran wan cuara wijacro. Wicayat cuacúr aba sar bin Sirat tew̃ic uwat rahjacro. Sirat wajacro: “Bahan as waquijró. Bahan sehnacro. Asan bah jor tan wanro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús bara treinta cuatán uw siw̃in ac yehnjacro. Uwat séhw̃atan, “Jesusan José waquijró,” séhw̃ajacro. José tetán Eliro. ");
INSERT INTO tuf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí tetán Mátatro. Matat tetán Leviro. Leví tetán Mélquiro. Melqui tetán Jánaro Jana tetán Josero. ");
INSERT INTO tuf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José tetán Matatíasro. Matatías tetán Amosro. Amós tetán Náhumro. Nahum tetán Esliro. Esli tetán Nágairo. ");
INSERT INTO tuf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tetán Maatro. Maat tetán Matatíasro. Matatías tetán Sémeiro. Semei tetán Josecro. Josec tetán Judaro. ");
INSERT INTO tuf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá tetán Joananro. Joanán tetán Résaro Resa tetán Zorobábelro. Zorobabel tetán Salatielro. Salatiel tetán Nériro. ");
INSERT INTO tuf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tetán Mélquiro. Melqui tetán Adiro Adi tetán Cósamro. Cosam tetán Elmadamro. Elmadam tetán Etro. ");
INSERT INTO tuf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tetán Josuero. Josué tetán Eliézetro. Eliezer tetán Jórimro. Jorim tetán Mátatro. ");
INSERT INTO tuf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat tetán Leviro. Leví tetán Simeonro. Simeón tetán Judaro. Judá tetán Josero. José tetán Jonamro. Jonam tetán Eliáquimro. ");
INSERT INTO tuf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim tetán Meléaro. Melea tetán Menaro. Mena tetán Matátaro. Matata tetán Natanro. ");
INSERT INTO tuf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán tetán Davidro. David tetán Isairo. Isaí tetán Obedro. Obed tetán Boozro. Booz tetán Sálaro. Sala tetán Naasonro. ");
INSERT INTO tuf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón tetán Aminádabro. Aminadab tetán Aramro. Aram tetán Esromro. Esrom tetán Fáresro. Fares tetán Judaro. ");
INSERT INTO tuf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá tetán Jacobro. Jacob tetán Isaacro. Isaac tetán Abrahamro. Abraham tetán Tarero. Taré tetán Nácotro. ");
INSERT INTO tuf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor tetán Sérugro. Serug tetán Rágauro. Ragau tetán, Pélegro. Peleg tetán Hébetro. Heber tetán Sálaro. ");
INSERT INTO tuf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala tetán Cainanro. Cainán tetán Arfáxadro. Arfaxad tetán Semro. Sem tetán Noero. Noé tetán Lámecro. ");
INSERT INTO tuf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec tetán Matusalenro. Matusalén tetán Enocro. Enoc tetán Jarédro. Jaréd tetán Mahalaleelro. Mahalaleel tetán Cainanro. ");
INSERT INTO tuf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán tetán Enosro. Enós tetán Setro. Set tetán Adanro. Adán tetán Sitro. ");
INSERT INTO tuf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Juanat Jesús rih sar siw̃yat, Jesús riha ajc Jordán cajc cutar bin sicor wijacro. Wicayat Sir Ajcan Cámuran Eyat Jesús ur ícatro. Sir Ajcan Cámuran Eyat Jesús uw bár cuitar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ayiran Jesús uw bár cuitar riya cuarenta cuanjacro. Uw bár cuitar Sisramat Jesusan ay bár yajc ayin acu cayar yajquín yehnjacro. Jesús ey cuitar ira yati ítchacro. Eyta ityat ria cuarenta cuanyat, Jesusan yayan to rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Etar Sisramat Jesús acat ac yehw̃ír wajacro: —Bah uní Sir waquíjtara, ac ujan tehmowi. Irir arwi. Pan uw̃i. Yayín acu uw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Waquít Jesusat wajacro; —Sir carit cutar wacaro. Itin acu, cuanín acu pan tecútari cuántiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eyta wacayat Sisramat Jesús wistúr yehw̃ béjecro. Erar cucayat bahnác itchacro. Etar im erar cuar cajc istiy gobierno, cajc istiy gobierno bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ehcúr wajacro: —Aját bahan gobierno cara yehn áyinro, -wajacro-. Bahat uw ayin acu aját bah cara yehn áyinro. Bahat itchaquey behmá quin bahnác wíquinro, -wajacro-. Cara yehn ayin acu as quin waquír báhjacro, -wajacro-. Eyta rehquít ajatán biyan carin yehn ay cúntara aját eyan cara yehn ayro, -wajacro, Sisramat-. ");
INSERT INTO tuf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bahat as quínoan “as caru,” waw̃i, -wajacro-. Eyta wacáyatan aját bahan cara yehn áyinro. Bahnác wíquinro, wajacro, Sisramat, Jesús quino. ");
INSERT INTO tuf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Waquít Jesusat wajacro: —Sir carit cuitar wacaro: “Sir bah Cara tamo síhw̃awi,” wacaro. “Ey chiwa chaw̃i,” wacaro. “Istiyí chiwa chati jaw̃i,” wacaro. Eyta waquír car Jesusat Sisrám chihtá cátiro. ");
INSERT INTO tuf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eyta wacayat Sisramat Jesusan Jerusalén pueblo béjecro. Erar cur car Sir úbaja arcutar waajacro. Sir ubaj arcutar cur wajacro: —Bahan Sir ima waquíjtara, behmá sicor ic ocso cuar tijcawa, -wajacro, Sisramat-. ");
INSERT INTO tuf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sir carit cuitar uchta cuihsú bahjacro: Sirat ima cuacúr cacmín bah obir yajquín acu áyayqueyra. Eyinat ba ruhw̃ú áytiro. ");
INSERT INTO tuf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Eyin at cut bah caquir beyáyqueyra. Eyta becayat ac cut búnobo áyajatro, cuihsú bahjacro. Sir carit cutar eyta waquíc etar usár cuar ic oso tijcawi, wajacro, Sisramat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Waquít Jesusat wajacro: —Sir carit cuitar uchta cat wacaro: Sir imat bitar yajcátatara bahat ey istín acu Sir quin eyta yajc ayin síhw̃ati jaw̃i, wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Etan Sisramat Jesús ay bár yajc ayin acu cayar yajcáy yehnjác etchacro. Birá cuanyat cayar yajcata sehw̃ar et bahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sisramat Jesús ay bár yajc ayin cayar yajcáy yehnjác etyat, Jesús sicor Galilea cuwín bijacro. Sir Ajcan Camur Eyat urán cuít wícayat bijacro. Eyta cuácayat ey cajc ítquinat cat, quemir ítquinat cat Jesusat yajác chihtá tew̃ic rahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Etat Jesusat secuac usar istiy cutar cat, secuac usar istiy cutar cat uw síw̃jacro. Eyta siw̃yat, bahnáquinat “Jesusan ayro. Ay siw̃ro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Etar Jesús Nazaret pueblo cuwín bijacro. Jesús iman Nazaret cuitar cun yehnjáquinro. Erar cur car tan jaquic ricar cuányatan, secuac usi raújacro. Jesusan cajc istiy, cajc istiy cucayat, secuac usi eyta rauro. Nazaret cutar secuac usi rauwir Sir carit tan acu cui yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yehnyat ey at icar istiyát carit wíjacro. Sir chihtá ehcuquib Isaíasat cuihsú bahjaquey wíjacro. Wícayat ricuajacro. Ricuár chihtá wahitchacro. Istír uw cucáj acat uchta cuihsujaquey tajacro: ");
INSERT INTO tuf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Sir Ajcan Cámuran Ey as ur ícatro, -tajacro-. Ey chiht eyan oya bár bin quin, ray bár bin quin ehcún ac as ur icar chájacro, -tajacro-. Síratan as caquir áyjacro. Cárcel sar tunjaquin quin chihtá beyin ac as áyjacro. Cárcel sar eyin sicor uc si ayin as cuit chihtá áyjacro. Ub bár bi quin chihtá beyin acu as áyjacro. Sicor ub ji jaquin as cuit chihtá áyjacro. Ruhw̃uquin siwin acu as áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Sirat uw racar reht siwic cab cujác chihtá ehcún as áyjacro. Jesusat uw quino Isaíasat cuihsú bahjaquey tajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tar car carit sicor bur buror cuar questajacro. Bur buror cuar questár cat sicor secuac usi cacmín at icar chájacro. Cacmín at icar chaw̃ jaquir, sicor uw siw̃in acu chihrjacro. Chihryat bahnáquinat Jesús wahitchacro. Secuac usar uwat sicor ub quir itay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chihrír uw quin wajacro: —Sirat úchicrias eyta wajacan ah ba ub acat bar yajacro. Aját ba cucáj acat tajaquey ahra Sirat bar yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesusat eyta wacayat, bahnáquinat ey ojcor ay tew̃jacro. Uchta wajacro: —Eyat chihtán ay bi ehcuro. ¿Uniqui? ¿Eya José wacjí báriqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Etat Jesusat wajacro: —Aját ítatan, baat urá ji bin chiht wajaquey uchta as quin waquín síhw̃aro: “Médicou, behmá sacuwi,” waquín síhw̃aro, -wajacro-. Uchta cat waquín síhw̃aro: “Bahat Sir urá cut Capernaum cajc cutar yajquír eyta usár cat eyta yajw̃i. Usár behmá cajc cutar cat eyta yajw̃i,” waquín síhw̃aro, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Acsar wajacro: —Aját bah quin wacaro. Uw bahnáquinat Sir chihtá ehcuquib ajcá ji becaro. Cajc bahnác cutar ítquinat ajcá ji bécaro. Eyta cuara, ehcuquib ima cajc cut bínatra ajcá ji bétiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aját wacaro. Uchicrias Elíasatan Sir chihtá ehcwáy yehnjacro. Etat owaran ira yéhntiro. Bara bay bacoy eyra ubut quit cuácayat ira cajc bahnác cuitar yéhntiro. Etat owár cat Israel cajc cut sácajaquin wiyin ricán toro. ");
INSERT INTO tuf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eyta cuar Sirat Elías israelin yarjaquey wiya quin áytiro. Israelin bár bin quin áyjacro. Cajc Sidón chauwíc quin áyjacro. Yarjaquey wiya ajca Sarepta quin áyjacro, wajacro, ");
INSERT INTO tuf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jesusat uw quin. ’Riy istiy Sir chihtá ehcuquib Eliséoan Israel cajc cut ítchacro. Etat owár Israel cajc cut is cajc cut uw sura ohná bíquinan ricán toro. Eyta cuar Eliséoat sura ohná biquin israélini tan chátiro. Cuatán Siria uw tan jájacro. Sera ajca Naaman sura ohná biquin sicor tan jájacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eyta wacayat, uw Jesús ac túrjacro. Eyta tew̃ic rahjáquinan bahnaquin bar túrjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Turir catrun Jesús pueblo acsar yehw̃ béjecro. Pueblo eyan sio cubar arcútatro. Yehw̃ beyar, sio terár cutar cujacro. Sio cahm oso te siquin acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Eyta cuar Jesús uw imár tac icar bin sicor wa rajacro. Wa raquír acsar bar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Etar Jesús cajc ajcan Galilea cuwín bijacro. Capernaum pueblo bijacro. Erar cur car tan jaquin ricar cuanyat uw síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Siw̃yat, uwat rahcuír car síhw̃ajacro: “Uyat ay siw̃ro. Sir urá cut siw̃ro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eyta siw̃yat icar secuac úsara cat sera cuicá ji bin wijacro. Cuicát yehnár ay bár cohwjacro: ");
INSERT INTO tuf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesusu, ¿Baha is ac icúr yajcáy racya? -wajacro-. Nazarétinu, ¿Is bahnác sutini séhw̃aqui? Ajatán bahan itro. Bahan urá ay binro. Bahan Sira jor binro. Ajatán itro, cohwjacro, cuicát Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Etat Jesusat cuicá quin wajacro: —Ajc chin jaw̃i. Sera urá sar bin car biwi, wajacro, Jesusat. Jesusat eyta wacayat cuicát ser ey ic oso téjecro. Uw ta icar téjecro. Te rabar ser ey urá sar bin bar waa bijacro. Ser ey bitar útara rehti tan wan bahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eyta cuácayatan, bahnaquin ub yehw̃jacro. Rahra cat rahra cat tew̃jacro. Uchta wajacro: —¿Uniqui? Jesús urán cuitro. Jesusat ima urá cuitar cuicá bar uc áyjacro. Ima camur cutar cuicá újacro. Jesusat cuicá quin “waa biwa,” wacayat, waa bicaro. ¿Ey urá bitáraca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Etan cajca bahnác cuitar Jesusat yajaquey ojcor tew̃jacro. Bahnáquinatan ey chihtá rahjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Etat Jesús secuac usar bin waa bijacro. Waa bir, Simón usi raújacro. Simón usi rauwir ítitan, Simón áw̃iya yatro. Tiuír yatro. Quicrán abayro. Rauyat, uwat Jesús chíjacro. Simón áw̃iya sicor tan chácayta acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chícayat, Jesús ey acor cujacro. Ey acor cur catrun tiuír chihr áyjacro. Jesusat eyta chihr ayat tíucan bar etchacro. Restá sicor bar tan jájacro. Eyta tan jaquir yehnjacro. Yehnár car Jesusin acu ira anir wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Awan rahsa rau bicáyatan, yárquinan bahnáquinat Jesús quin yehw̃ béjecro. Tan jaquin ac béjecro. Etat Jesusat ima átcaran yarquin cuitar chájacro. Eyta chácayat, restán ajquír bin, restán ajquír bin yarquin tan chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Cahujín ur icar bin cuicá újacro. Ricán to bin ur icar bin cuicá si áyjacro. Si ayat cuicát cohwjacro: “Bahan Sir waquijró,” wajacro. Eyta cuar Jesusat cuicá técuajacro. Eyta tew̃ín acu Jesusat cuicá quin ajc waátiro. Cuicát ítitan, Síratan Jesús áyjacro. Eyan Crístoro. Eyta itchác cuaquir, cuicá quin Jesusat tew̃ áytiro. ");
INSERT INTO tuf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chícrias cuitar Jesús pueblo cutar bin waa bijacro. Uw bár cuitar bijacro. Cuatán Jesús bi questoc uwat wahitay béjecro. Ey quin cur car, Jesús acsar biti ac tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Eyta cuar Jesusat uw quin wajacro: —Aját Sira cara rehquey ojcor síw̃ataro. Ey ehcwátaro. Chihtá ay bi ehcwátaro. Pueblo istiy cuitar cat, pueblo istiy cuitar cat, ey chihtá ehcwátaro. Eyta siw̃in acu as áyjacro. Eyta bira aját eyta ehcunro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Etan judíoin cajc cutara pueblo istiy cuitar, pueblo istiy cuitar eyta ehcujacro. Secuac úsaran eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Riy istiy Jesusat riw cajc cutar uw síw̃jacro. Riw ajca Genesaret cajc cutar uw síw̃jacro. Erar ricán to bi síw̃jacro. To bi sécuaquin siw̃yat rahra rahra yarji úcajacro. Sir chihtá rahcuín acu Jesús ecor it cun rehquít úcajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eyta úcayat owár Jesusat canoan bucáy bin itchacro. Riw cajc cutar itchacro. Rih ruwa cáquinra canó ey erar inic bahjáquinro. Erar bahr riw cajc cutar waajacro. Waar car atarraya sucuáy yinjacro. Atarraya sucyat icar aw̃at, ");
INSERT INTO tuf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús canó icar raújacro. Simonay icar raújacro. Rauwir, Simón quin wajacro: —Béowi. Rih cajc cutar bin conu itic béowi, wajacro. Etar rih cajc intac itic béjecro. Uwra rih cajc cutar ítchacro. Etar erar canó icar cuar Jesusat uw síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Siw̃ tihrír car, Jesusat Simón quin wajacro: —Rih usón arcutar as béowi. Erar cur car ruwa cac siin ac atarraya tiw̃ tewi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eyta wacayat Simonat wajacro: —Caru, isat rih ruwa che wan sarác yajquít cat icrí uti cuanjacro. Ubistii cátiro. Eyta cuar bah chihtá cuitar aját atarraya tenro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Etar atarraya ter cuitar, rih ruwan to cájacro. Ruwan to cácayat, atarraya bar racháy yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eyta racháy yehnyat íw̃oquin chíjacro. Owár caquin ac chíjacro. Canó istiy cuitar ruwa caquin chíjacro. Etar íw̃oquin béjecro. Iw̃oquin cur car, íw̃oquin owár ruwa sijacro. Siir canoa bucáy bin cuintas cájacro. Cuintas cuácayat, sinaratan canoa riw tanoso bahrata yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Etar Simón Pédroat ítitan, rih ruwa séhw̃anar cájacro. Eyta istír ub yehw̃jacro. Pedro owár bin cat ub yehw̃jacro. Eyta istír Pedro Jesús cac cahmar cuscar cutar chihrjacro. Cuscar cutar chihrír wajacro: —Werjayú, asan ur ay bár biro. Etar as jotra ítiti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiago cat, Juan cat ub yehw̃jacro. Santiago ji, Juan ji éyinan Zebedeo sasaro. Simonin owár rih ruwa cáquincuano. Ub yehw̃yat Jesusat Simón quin wajacro: —As cahmar rooti jaw̃i. Baat rih ruw caquir eyta yáhnacat asi jor uw éytaan wan cácataro. As chiwa chaquin acu uw cácataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Etat sicor cat riw cajc cut waajacro. Riw cajc cut waar car canoa erar cham báhjacro. Bahnác cham báhjacro. Bahnác cham bahr Jesús chor quir béjecro. Jesús chiwa yinín acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Riy istiy Jesús pueblo cuit bar cujacro. Pueblo cur itit, ser istiy ruhsúc restá cájaquey sura ohníc restá cájaquey cuercúr ésatro. Cuercurat Jesús bar itchacro. Istír car Jesús quin conjacro. Jesús cahmar cuscar cut itir cac batabo chájacro. Cac batabo cuar conjacro: —Werjayú, bahatan as tan wan chac cúntara, eyta chaquin acu urá chero, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesusat eyta rahcuír, sura ohníc ey at cut butajacro. At cut butar wajacro: —Aját eyta tan cha cun rehcaro. Tan wan ítuwi. Orac chaw̃i, wajacro. Jesusat eyta wacayat, ser ey bar tan jájacro. Icúr bár rehquey sicar sura bar tunjacro. Orac chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Etat Jesusat cuercúr ey quin, cahujín quino ehcuti acu uchta wajacro: —Aját bah quin wacaro. Cahujín quínora ehcuti jaw̃i, -wajacro, Jesusat-. Sacerdote quin biwi. Sacerdóteat bah sura ohníc tunjác ey istayta acu biwi, -wajacro-. Etar cat Sir quin wícata ey wiw̃i. Moisesat icúr wícata cuihsú bahjáctara Sir quin ey wiw̃i, -wajacro-. Eyta yajcayat uwat baha bahnác bar orac chájaquey istáyqueyra, wajacro. Jesusat cuercúr tan jájaquey quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eyta wajác cuar, cajc istiy cuitar cat, cajc istiy cuitar cat Jesusat yajquíc chihtá tew̃jacro. Etar ricán to binat Jesusat waquíc rahcuay béjecro. Imaran bitara yárictar tan jácayta acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Cuatán Jesusra riy istiy, riy istiy uw bár cuitar bijacro. Uw bár cuitar Sir quino conay bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Riy istiy cuácayat, Jesusat uw síw̃jacro. Eyta siw̃yat judío carin ésatro. Fariséoin cat ésatro. Bachan chihtán siw̃quin cat ésatro. Galilea cajc cut bin, Judea cajc cut bin, Jerusalén pueblo cut bin cat béjecro. Jesusat eyta siw̃yat, yarquin tan jaquin ac Sir camur Jesús ur ícatro. ");
INSERT INTO tuf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eyta cuácayat uwat cuercúr Jesús quin bequin ac yehw̃ rojocro. Cuercúr ey quejtirat cuecujáquinro. Caros cuitar chaquir yehw̃ rojocro. Jesús cac cahm chaquin sehw̃ar yehw̃ rojocro. ");
INSERT INTO tuf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eyta cuar, Jesús quino bitách cúwajatro. Ricán to etar bitách cúwajatro. Cúwajar reht cuacúr ubach arcutar waajacro. Ubach arcút waar car, ucar yajacro. Ubach ucar ocso cuercuran caros cutar samac oso áyjacro. Jesús cac cahmar chaquin acu uw tasar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Rojóqueyinat cat, cuercurat cat síhw̃ajacro: “Jesusat bar tan jácayqueyra,” síhw̃ajacro. Eyinat eyta sihw̃ac Jesusat itchacro. Istír car, cuercúr quin wajacro: —Seru, bahat ur ay bár yajáqueyra tayar bár chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jesusat “bahat ur ay bár yajáqueyra tayar bár chájacro.” wacayat, bachan chihtán síw̃quinat cat, fariséoinat cat sihw̃ay yinjacro: “Jesusat Sir ub cahmor téw̃ajar bin tew̃ro,” síhw̃ajacro. “ ‘Ur ay bár yajquíc tayar bár chájacro,’ Sir imata wacátaro,” síhw̃ajacro. “Cahujínatra éytara bitách wácajatro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ur icar eyta síhw̃aquey Jesusat itchacro. Eyta istír eyin quin wajacro: —¿Bitar reht eyta síhw̃aqui? ");
INSERT INTO tuf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sir ub cahmar tayar bár chaquin acu chauwan abayro. Eyta cuar cuercúr tan wan chaquin acu cat chauwan abayro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Eyta cuácayat, aját ba quin ehcunro. Sirat asa Uw Síuquib quin uw tayar bár chaquin ajc waajác ehcunro. Urá cut uw tayar bár chaquin acu ajc waajacro. Aját uchta yajquír cuitar ba quin eyta ehcunro, wajacro. Bachan chihtán siw̃quin quin eyta waquír acsar cuercúr quin wajacro: —Ajatán bah quin wacaro. Tan chaw̃i. Cui yehnwi. Behmá caros yehw̃i. Usi biwi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jesusat eyta wacayat cuercúr cui yehnjacro. Bar tan jájacro. Uw bahnaquin ub acat cui yehnár ima rojóc caros yehw̃ír bijacro. Usi tan wan bijacro. Beya rabar cuercúratan “Siran ayro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Cuercúr yehnár bic istír uw bahnaquin ub yehw̃jacro. Etat wajacro: “Siru, bah ur ayro,” wajacro. Rahra cat, rahra cat wajacro: —Ah ricar isat itcháqueyan cáhmotra istiti biro. Ayan cuitro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cuercúr tan jaquir, Jesús bar bijacro. Acsar waar ítitan, sera ajca Leví gobierno ubach watar itro. Leviat uw quin gobierno tayar chícaro. Etat Jesusat Leví quin wajacro: —Asi jor biwi, as chiwa chaquin acu. ");
INSERT INTO tuf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jesusat “biwi,” wacayat, Levian bahnác esar cham bahjacro. Bahnác cham bahr, Jesús chor yehnár bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jesús chiwa waar cutar Leviat Jesusin owár ira yayín ac ricán to sécuajacro. Gobierno tayar chiquin cat, cahujín cat yayín sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eyta secuac fariséoinat, bachan chihtán síw̃quinat itchacro. Eyta istír Jesús chiwa cuach cuach técuajacro. Uchta wajacro: —¿Gobierno tayar chiquin owár bitara reht ira yaqui? ¿Urá ay bár bin owár bitara reht ira yaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Etat Jesusat wajacro: —Uch síhw̃awi. Uw orac bin médico quin bitani béyajatro. Cuat yárqueyin médicoat sacún acu bécaro. ");
INSERT INTO tuf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aját orac bin cuitari wacay rátiro. Cuat bíyinatan imarat Sir tayar yajác síhw̃ayatan, éyinat ay bár yajquíc et ayin acu rajacro. Eyin ajmár chiwa cháquinro, wajacro, Jesusat fariséoin quin. ");
INSERT INTO tuf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Etat uwat Jesús quin wajacro: —Juan chiwa Sir bach cuitar ira yátiro. Sir ojcor cuít conro. Fariséoin chiwa cat éytaro. Eyta cuar bah chíwatra ira yácaro. Bacua yahcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eyta wacayat, Jesús imat cat, ima chiwat cat bitar étara bach yajti ítictar ehcún ac uchta wajacro: —Is uwat wiya yehw̃ín cuácayat, íw̃oquin cat, cayin cat sécuaro. Iran cuít yayín acu sécuaro. Ir ey yaya rabar ahní rehcaro. Ey cáyinatan, íw̃oquinatan áhajira wiya yehw̃quib owár rehquít, bach yájcajatro. Eytaan wan as usár chácayat, as chiwa as jor yayátaro. ");
INSERT INTO tuf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Itchareht wiya yehw̃quib eya ahár síwataro. Síuyatan ey cayin, ey íw̃oquin bach yajcáyqueyra. Ira yati rehcáyqueyra. Ey racar cue rehcáyqueyra, -wajacro-. Wiya yehw̃quib ahár siwir eyta as cat eyta ahár questár becayat, as chiwat ira yati bacha yajcátaro, wajacro. Eyta ehcúr cuitar Jesusan ima chiwa owár rehcayat, ira báchuti itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eyta waquír car uw siw̃in acu icúr bi ojcor tew̃jacro. Chihtá cahmor ey cat, awan ey cat owárara síhw̃ati acu ehcujacro. Eyta ehcúr cuitar ima chihtá awan eyan oya ibsoy eyta binan wan wajacro. Eyta siw̃in acu uchta wajacro: —Oya cumar sejéc cuitar bahu cuara quejcátaro. Cuatán oya ibsoy bi ráchtiro, sejequi cuitara bahu quejquín acu. Eyta ráchyera ibsoy ey ruhw̃uro. Etar cat cumar ey cat ibsoy ey owár ay réhtiro. Eyta cat chihtá cahmor ey cat awan ey cat owárara batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Eyta waquír, ima chihtá awan ey sima tenti binan wan wajacro. Eyta ehcún acu uchta wajacro: —Eyta cat uwat cabra um sutír questaro. Questár sima ey sar chácaro. Eyta cuar umá cumar bi sar sima tenti bi chátiro. Tenti bi chácyera, sima semar ten racáyatan, umá rachátaro. Rachyat sima cuayar úcayqueyra. Umá cat ruhw̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sima tenti bira cabra umá awan órojoc bi sar chácataro. Eyta chácayat racha báreyra. Eytaan wan cat chihtá awan ehcwáy yinjác bi ajquitro. Cahmor ehcujác bi cat ajquitro. Bucáy bin cácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eyta waquír Jesusat uw ojcor wajacro. Uwat ima chihtá cati rehquíc ojcor wajacro. Eyin ojcor waquín ac ima chihtá cahmor tew̃ti bi sima tenti binan wan bi ojcor wajacro. Uchta wajacro: —Eyta cat uwat sima tenjaquey yáhyeyra, yahncutra tenti eyra rácari batro. Cuatán eyat wacaro: “Tenjáqueyan ay biro. Téntira ay batro,” wacaro, wajacro. Eyta waquíc cutar Jesúsatan uwat bitara rehquít ima chihtá ca cun bár rehquíc ojcor wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Riy istiy Jesusan canar yajti ricar cuanyat, ritút ques tiw̃ béjecro. Eyta beya rabar Jesús chiwat ritút quehujacro. Quehwír at cut bita bit bujacro. Bur cohjocro. ");
INSERT INTO tuf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariséoinat eyta istír eyin quin wajacro: —¿Bitara reht eyta quehuqui? ¿Tan jaquin ricar yájcajar bi bitara reht yajqui? ¿Bitara reht canar yájcajar bach auqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Etat Jesusat wajacro: —Behmarat cat Sir carit itro. Sir carit cuitar Davidat yajác ojcor wacaro. David cat, ima chiwa cat yayí rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Eyta rehquít Sir usar raújacro. Rauwir pana Sir ac chájaquey uquir cohjocro. Pan eya sacerdótein imár istir binat cóhtaro. Cahujinat bitách cóhjotro. Sir chihtá cut eyta “cohti jaw̃i,” wacaro. Eyta cuar Davidat cohjor bin cohjocro. Davidat cohcayat, ima chiwa quino cat wíjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eyta cat canar yajti ricar cuitar icúr yajcátatara waquín acu Sirat as yehn áyjacro. Asan Uw Síuquib eyta waquín yehn áyjacro, wajacro, Jesusat fariséoin quino. ");
INSERT INTO tuf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Riy istiy tan jaquin ricar cuanyat Jesusan secuac usi raújacro. Rauwir erar uw síw̃jacro. Siw̃ic cutar uw cuercúr cat ésatro. Atcara tajqui wihár ey cuercutro. ");
INSERT INTO tuf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Canar yajti rícatro. Etar bachan chihtán síw̃quinat cat, fariséoinat cat Jesús úrojocro. Canar yajti ricar cuitar yárqueyan tan jácatatara ey úrojocro. Bi ques icar Jesús cahmí icar tew̃átatara sihw̃ar ey úrojocro. ");
INSERT INTO tuf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Cuatán Jesúsatan éyinat eyta sihw̃ac itchacro. Eyta cuar atcar cuercúr quin wajacro: —Raw̃i. Usár cui yehnwi, wajacro. Eyta wacayat, cuercúr erar cui yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Etat Jesusat bachan chihtán siw̃quin quin, fariséoin quin wajacro: —¿Baat ítitan, Sir Chihtá cut bitara yajqui? Canar yati ricar cutara ay yajcátatara, ay bár yajcátatara, baat waw̃i. Uw tan chácatatara, uw tan chati ruhw̃átatara, baat waw̃i. Jesusat eyta wacayat, eyin ajc sácajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesusat eyin wahitchacro. Etat cuercúr quin wajacro: —Bah átcara cuercúr ey yehw̃ tew̃i, wajacro. Eyta wacayat, cuercurat im atcar yehw̃ír tew̃jacro. Eyta tew̃yat, atcar orac waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eyta tan jácayat, bachan chihtán siw̃quin cat, fariséoin cat abáy túrjacro. Jesús ruhw̃ún ac rahra rahra ríojocro. ");
INSERT INTO tuf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Itchareht, yájcajareht Jesús cubar icar bijacro. Sir ojcor conay bijacro. Erar cur Jesusat Sir ojcor che wan sar conjacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Etar cuanír chícriasan chiwa chíjacro. Chícayat uw Jesús quin béjecro. Bequir cuisa doce cájacro. Caquir éyinan ima chihtá ehcuquin aw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Uchin cájacro: Simón cat, Simón taná Andrés cat cájacro. Simonan ajc istiy Pedro chájacro. Santiago cat, Juan cat cájacro. Felipe cat, Bartolomé cat, ");
INSERT INTO tuf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo cat, Tomás cat, Alfeo wacjá Santiago cat, Simón cat cájacro. Simón eya cananístainro. ");
INSERT INTO tuf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas cat cájacro. Judas eya Santiago waquijró. Judas Iscariote cat cájacro. Judas Iscariote eya ítchareht Jesús quehsí waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ima chihtá ehcuquin caquir, eyin owár sicor aca cuit béjecro. Sicor aca cuit bequitrun, ricán to quiujacro. Jesusin acoran chiwa to quiujacro. Cahujín cat quiujacro. Judea bin, Jerusalén bin, yacúr awat Tiro bin, Sidón bin uwan to quiujacro, Jesús chihtá rahcuín acu. Jesusat yarquin cuercurin tan jácayta ac quiujacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Eyta cuácayat Jesusat cuicát ruhw̃uquin tan wan chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesusat Sir urá cut uwa tan chájacro. Yarquin bahnaquin tan chájacro. Etar uw bahnáquinat Jesús buta cun rehjecro, tan jaquin acu. ");
INSERT INTO tuf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Etat Jesusat chiwa wahitchacro. Istír eyin quin wajacro: —Ba biyin oya bártara, ray bártara óhbacro. Sir cara rehquey cuitar baan cara yináyqueyra. Etar baan óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ba biyin aha yayí réhctara óhbacro. Yahncút caba yayáyqueyra. Etar óhbacro. Ba biyin cuétara óhbacro. Ba urá cuechú etar Sirat ahní chácayqueyra. Etar óhbacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ba bíyinan uwat quehsí jácayat, óhbacro. Ba bíyinan uwat ajc bár yehw̃ técayat, óhbacro. Uwat as chihtá ques ba biyin quin ajc ahsín tew̃yat, óhbacro. Uwat ba biyin ojcor ajc ahsín tew̃yat, óhbacro. Asan Uw Síuquib ques ba eyta ruhw̃úyatan, óhbacro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Eyta ruhw̃ú yajcayat, ahní jaw̃i. Tan wan rehw̃i. Ah ricar uwat ba ruhw̃úr eyta eyin cahmor cohtinát Sir chihtá ehcuquin cat eyta ruhw̃ujacro. Eyta sihw̃ar, ba ruhw̃ú etar tan wan jaw̃i. Ba Sir jor cuacúr ítata etar ahní jaw̃i, wajacro, Jesusat, chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jesusat chiwa quin eyta waquír, uw cahujín quin wajacro: —Ba óyinu ráyinu, conú cuac sácayqueyra. Ahra rayan oyan che cuar étana wícaro. Yahncutra wícajatro. Etar conú cuac sácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ba ira yarís yáquinu, conú cuac sácayqueyra. Ahra iran toro. Ahra yarís yaquíc cuar yahncutra yayí rehcáyqueyra. Etar conú cuac sácayqueyra. ’Ba ahní réhquinu, conú cuac sácayqueyra. Ba sisí éyinra cue jácataro. Ahra ahní it cuar yahncutra óyqueyra. Yahncutra conay yináyqueyra. Etar conú cuac sácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ba biyin ojcor uwat ay tew̃yat, conú cuac sácayqueyra. Ah ricar uwat ba ojcor ay tew̃ír eyta, ey cohtinát cat Sir chihtá ehcúquinir ojcor cat eyta tew̃jacro. Etar ba cat conú cuac sácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesusat uw quin wajacro: —Uwu, as chihtá yají quin rahcwi. Ba quehsuquin sehnác chaw̃i. Baan quehsuquin acu ay yajw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ba cahmar cuicá yájqueyin cuitar Sir quin chiwi, -wajacro-. Ba ruhw̃ujáqueyin cuitar Sir ojcor conwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Uwat atcar cut ba ac tarey cut bucayat, bucoy rahray wihár cat buc aywi. Istiyát ba siricajá bes yajcayat, baat camís cat ey quin chaw̃ wiw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Uwat ba quin icúr bi racar chícayat, ey quin es yajti wiw̃i, -wajacro-. Istiyát ba oya yehw̃ bécayat, ey quino sícotra chiti jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Baat behmár acu cahujín quin icúr yajc ay cúntara, baat cahujín acu eyta yajw̃i, wajacro, Jesusat chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Baatán ba sehnác éyina sehnár yajcayat, caba yájtiro. ¿Etana sehnár yajcayat, Sir chihtá cab yajác síhw̃ajaqui? Eyta cábai batro. Ur ay bár binat cat eta jaw̃ rahra cat sehnacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bíyatan ba ac ay yajcáyatan, baat ey ácuan rahra cat ay yajcaro. Baat eta jaw̃ rahra ay yajcayat, ¿Sir chihtá yarís cajac síhw̃aqui? Yarsi cátiro. Ur ay bár binat cat eta jaw̃ imár owár ay yajcaro. ");
INSERT INTO tuf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bíyinatan ba quin sicor wícata reht baat eyin quin inic wícaro. Baat eta jaw̃ inic wícayat, ¿Sir chihtá yarís cajac síhw̃aqui? Yarsi cátiro. Ur ay bár binat cat eta jaw̃ imár owár inic wícaro. Sicor wiquin quin inic wícaro. ");
INSERT INTO tuf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eyta cuácayat, ba quehsí binan sehnác chaw̃i. Eyin ácuan ay yajw̃i. Uwat ba quin inic chícayat, eyin quin wiw̃i. Sicor wícatatara, wícajartara síhw̃ati wiw̃i. Eyta wícayat, Sirat ba ac sicor túnayqueyra. Sicor ay wícayqueyra, -wajacro-. Sir imatan uw bahnaquin obir yajcaro. Eyta cuar cahujinat “Sirat as obir yajacro,” síhw̃atiro. Eyta cuar Sirat eyin cat obir yajcaro. Uw esan abáy bin cat obir yajcaro. Etar baat cat eta jaw̃ yajcayat, Sir ima sasá rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cuacúr Sirat ay bár bin in sac ayti obir yajcaro. Eyta bira baat cat eyta yajw̃i, wajacro, Jesusat chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Cahujín ríoti jaw̃i. Eyta cuácayat Sirat ba cat rio báreyra, -wajacro-. Cahujín cahm icar tew̃ti jaw̃i. Eyta cuácayat ba cahm icar cat tew̃a báreyra. Cahujinat ba ac ay bár yajác tayar ques técuati cuar sicor ténawi. Eyta cuácayat, Sirat ba tayar yajaquey cat cuécuti cuar sicor ténayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cahujín quin racar wiw̃i. Eyta wícayat Sirat rahra cat ba ac túnayqueyra. Ba wiquin acu ay wahcwáyqueyra. Wahcúr cuitar ubar echí wícayqueyra. Echí chaquir yiw yiw yajcáyqueyra. Yiw yiw yajquír arcutar echí chácayqueyra. Echí chaquir, ba ac wícayqueyra, -wajacro-. Baatán cahujín quin bita wícayat, Sirat cat ba ac eyta wícayqueyra, wajacro Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Etar Jesusat chiht istiy siw̃in acu icúr bi ojcor ehcujacro. Uchta wajacro: —Ub bár bíjiyat istiy ub bár bijiy ator bitách yehw̃ír béyajatro. Eyta béyeyra iscán ucar icar buca owár yau sácayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sinquib eyan ima siw̃quib urá bow̃an cuitra waájatro. Síw̃quibra urán cuitro. Eyta cuar sinquib bahnác ay sin tihrír, siw̃quib owara rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Baan urá bucayro. Behmarat táyaran abáy yajcaro. Behmarat táyaran abáy yajquíc cuar cahujín cahm icar tew̃ro. Ay baran táhnaqui bár bi ques tew̃ro. Baat úchtaan wan yajcaro. Uwat istiy quin wacaro: “Chahrú, aját bah ub icar bin cajc bur bijaquey úquinro,” wacaro. Eyta waquíc cuar caruc tútcuaran im ub ícatro. Caruc tutcuar ima ub icar cuácayat, istiy ub icar bin cajc bur ohbac bitách úcajatro. Ohbac úcajar eyta tayar ji binat éytaan wan ay baran táhnaqui bár ques ohbac bitách téw̃ajatro. Cahmor im ub icar caruc tutcuar bijaquey ucátaro. Im ub icar bin cahmor ucata eyta baat cat behmár ur ay bár yajquíc etátaro. Eyta etír car, istiy quin ohbac wacáyqueyra, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Baatán cárucuan itro. Caruc ay eyat uban ay bin chácaro. Eyta cuar caruc ay bár biyat ub ay bi chátiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Caruc ub yayar cuitar caruc bitáratara istátaro. Cachá chi bin cárucuat higuera ubra chátiro. Eyta cat cachá chistarat chistár ub ay binra chátiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Eyta cat uwan ur ay bíjiyatan ay yajcaro. Urá ay rehtan ay yajcaro, -wajacro-. Cuatán uw urá ay bár bínatra ur ay bár yajcaro. Urá ay bár rehtan ur ay bár yajcaro, -wajacro-. Eyta cuácayat urán bitáratara im eyta yajcaro. Im eyta tew̃ro, wajacro. Jesusat uw quin eyta síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Baat as quin “Caru,” wac cuar, as ajcra ráhctiro. As chíhtara cátiro. ¿Bitara rehtqui? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bíyatan as chihtá rahcuír yajcáyatan, eyan úchtaan wanro. Ey ojcor aját ba quin ehcunro. ");
INSERT INTO tuf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ser istiyát ubach tuw̃áy yehnro. Etar teba ocuán acu ucar usór cuíjacro. Cuiir ócsoran teb chájacro. Chaquir car teb ques aca chaw̃, ica chaw̃ tajacro, -wajacro-. Eyta tuw̃yat riy istiy riwan abáy áyjacro. Riwan abáy ayat rih ubach ocso abáy cuinjacro. Etar rihan cuinír canarán abáy sobojocro. Eyta sobóyatan ey ubach quer ques sobasob cujacro. Eyta cuar ubach eya ay tuw̃jác biro. Eyta bira rih sobóyatan, ubach cuácajatro, -wajacro-. Bíyatan as chihtá rahcuír yajcayat éytaan wan jácayqueyra. Cuácajar rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Cuatán biyat as chihtá rahcuíc cuar yajti cuácayatan úchtaan wanro. Istiyát ubach tuw̃jacro. Eyta cuar teb ay ocuátiro. Teb ay ocuati cuar at cut ic icar sau sau quejecro. Eyta túw̃yatan, ítchareht, riwa áyjacro. Rihan to cuinyat, rih canarát ubach in bar cuájacro. Abáy quehrjacro. Bíyatan as chihtá cati cuácayatan eyra éytaro. Abáy cuácataro, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesusan uw quin siw̃ tihrír pueblo Capernaum bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Capernaum cuitar soldado carin itro. Ey soldado cacmán yaran abayro. Bar en bicaro. Soldado cárinat cacúm yarquey sehnacan cuitro. ");
INSERT INTO tuf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Etar Jesús Capernaum pueblo cucayat, soldádoat Jesús ojcor tew̃ic rahjacro. Jesús ojcor rahcuír ey quin chihtá áyjacro. Judío werjáy cut chihtá áyjacro. Cacmá tan jaquin acu raquín wac áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Etaran judíoin Jesús quin yin beyar conjacro. Ey quin wajacro: —Soldado cuitar yajw̃i. Soldado esar eyan urá ay biro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eyat is uw sehnacro. Ey chihtá cuitar is ac secuac ubach tuw̃jác biro, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eyta wacáyatan Jesús judíoin owár bijacro. Béyaran birách bár cuácayat, soldado acam cat bar chihtá áyjacro. Iw̃oquin quin uchta wac áyjacro. “Caru, behmá as quínora rati jaw̃i. Séhw̃ati jaw̃i,” wac áyjacro. “Bah urán as cuitro. Bah caran tócuano. Asan bah etach batro. Bah as usi rauwin ac bahra ayan tahnacro,” wac áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Eyta bira behmá quínora bitiro. Ajmaratán bah chítiro. Usár rati cuar bahatán as cacmá tan chac aywi. Cajc bira cuitar, ‘tan jaw̃i,’ wacayat bar tan jácayqueyra. Bahat eyta wácayat bar tan jácayqueyra,” wac áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Asan cara chero. Etar aját ey chihtá cácaro. Cátira bitách yájcajatro. Ajáy cacmín cat chero. Eyta cuácayatan cacmín istiy quin ‘bah biwi,’ wacaro. Etatan bar béyqueyra. Cacmín istiy quin, ‘raw̃i’ wacaro. Etatan bar racáyqueyra. Etar cat as usi cacmín quin ‘uch yajw̃i,’ wacaro. Etatan bar yajcáyqueyra,” wac áyjacro, soldádoat Jesús quin. Etar soldado íw̃oquinat Jesús quin eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eyta wacayat Jesús ub yehw̃jacro. Ub yehw̃ír Jesusat ricá wihár ac waar cuar wajacro. Bahnaquin quin wajacro: —Aját ba quin wacaro. Capernaum soldádoat as tamo ay séhw̃aro. Uní séhw̃aro. Israelin urá séhw̃acan ey jotra cútiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Etar soldado eyat áyjaquin sicor usi béjecro. Sicor usi cur itit, cacmá bar tan jájacro. Ohbacro. Usi cur eyta itchacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Soldado cacmá tan jaquir, acsar Jesús pueblo Naín cun bijacro. Chiwa owár, ric owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Beyar, pueblo querat intac cujacro. Cur itit, uwat chein bécaro. Pueblo querat waa bécaro. Chein ey abayan wacján istanro. Chein ey tet cat bár yarjáquinro. Wacjá istanác bahjaquey chein ruhcuay bécaro. Eyta bécayat uw ricán to binat chein ab cuitar ruhcuay bécaro. ");
INSERT INTO tuf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Etat Jesúsata chein ab ey istír cue rehjecro. Waquíj yaryat istir cha bahcayat, Jesús cat ey racar cue rehjecro. Etar ey quin wajacro: —Oti jaw̃i. Conti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Waquír, chein bequic socua butajacro. Butayat chein yehw̃quin beti jájacro. Beti jácayat Jesusat yarjaquey quin wajacro: —Aját bah quino wacaro. Seru, cui yehnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesusat “cui yehnwi,” wacayat, chein yarjaquey sicor estají yehnjacro. Yehnár tew̃jacro. Eyta yehnár tew̃yat, Jesusat sicor ab at icar wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yarjaquey sicor estají yehnyat, ab at icar cham wícayat, uw ub yehw̃jacro. Sir ojcor ay tew̃jacro. Uchta wajacro: —Sir chihtá ehcúquiban urán bow̃an to bin wijacro. Is tac icar yehnjacro, -wajacro-. Sira ima uw quin bar wijacro. Uw siwin ac wijacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Etar Judea cajc bahnác cuitar Jesusat yajaquey chihtá tew̃jacro. Judea cajc intac binat cat, cajc istiy cuitar binat cat Jesusat yajaquey ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesusat yajaquey cat, tew̃jaquey cat Juan uw rih sar siw̃quib chiwat Juan quin ey chihtá bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Eyta wacayat, Juanat ima chiwa cuisa bucáy bin chíjacro. Chiír Jesús quin áyjacro. Jesús quin tayon áyjacro. “Isan Cristo yehníc acor itro,” waw̃i. “Is quin ehcuwi. ¿Bahan eyqui? ¿Isan istiy acor ítataica?” wac áyjacro, Juanat ima chiwa cut Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Etar sérinan Jesús quin béjecro. Ey quin cur, wajacro: —Juanat is ayir rojocro. Uw rih sar siw̃quibat uch tayo áyjacro. “Isan Cristo yehníc acor itro. Isan Sirat cara áyata ey yehníc acor itro. ¿Bahan éyiqui?” tayo áyjacro. “Bár cuácayat isan istiy yehníc acor ítinro,” waquír áyjacro, wajacro. Sérinat Jesús quínoan eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eyta wacayat, Jesusat uwa yarquin tan jájacro. Restá ji bin cat, cuercurin cat ricán quir bin tan jájacro. Cuicán to binan uw urá sar bin uc si áyjacro. Ub bár bin cat sicor ub ji chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Etat Jesusat Juan chiwa quin wajacro: —Juan quin ehcwáy béowi. Behmár ub cuitar ítqueyan cucáj cuitar ráhcuiqueyan ey ehcwáy béowi. Ub bár bin sicor ub ji chaquic itchác ey ehcuwi. Cuercurin sicor tan wan chaquic itchác ey ehcuwi. Uw sura ohnquin sicor orac chaquic itchác ey ehcuwi. Cucáj bár bin cat sicor cucáj ji chaquic itchác ey ehcuwi. Sácajaquin sicor estají chaquic itchác ey ehcuwi. Chihtá ay bi eyan oya bár bin quin, ray bár bin quin ey ehcúc rahjác ey ehcuwi. Juan quin eyta ehcuwi. ");
INSERT INTO tuf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Etan rehrinatán as tamo etiti síhw̃ayatan, éyinan tan wan rehcátaro, wajacro. Jesusat Juan chiwa quino eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Eyta wacayat, Juan chiwa sicor bar béjecro. Juan chiwa bey yiror, Jesusat uw quin wajacro. Juan ojcor uchta wajacro: —Baan ubach bár cuitar Juan quin béjecro. Baan Juan quin icúr sihw̃ar béjectara aját ehcunro. Uch wahitay bétiro. Ecatará séroat bahcabar bahcoquey eyta uw urá cat eyta tehmoro. Eyta cuar Juan úrara étai batro. Eyta bira baat urá tehmá tehm bin wahitín acui bétiro. ");
INSERT INTO tuf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ba oyin rayin wahitín acui bétiro. Oyin rayin pueblo cuitar itro. Gobierno úsiro. Ubach bár cuitar ítitiro. ");
INSERT INTO tuf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cuatán icúr wahitín acu béjectara aját ehcunro. Baatán Sir chihtá ehcuquib wahitín sihw̃ar béjecro. Juanan eyro. Juan ojcor aját ba quin wacaro. Sir chihtá ehcuquin cahujín Juan owárai cutiro. ");
INSERT INTO tuf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan ojcor úchicrias uchta cuihsú báhjacro: Aját chihtá ehcúquiban bah ben cahmor ayro. Bah cahmor eyat ibit óroyqueyra. Bah yehníc cahmor uw quin ur ay chac áyayqueyra. Eyta cuihsú bahjacro. Jesusat eyta waquír uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Aját ba quin wacaro. Cahmora cat, aha cat Juan urá ayan uw bahnaquin cuitro. Cuatán yahncutra Sir cara rehquey cutatra urá conu binan chihtán Juan cuít chácayqueyra, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesusat eyta wacayat, uwat “Siran ayro,” wajacro. Gobierno tayar chíquinat cat “Siran ayro,” wajacro. Juan chihtá cuitar eyin rih sar siw̃ áyjacro. Eyta cuácayat, uwat “Siran ayro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Cuatán fariséoin cat, bachan chihtán siw̃quin cat Juan chihtá cuitar rih sar síw̃tiro. Sir chihtá cati etar siw̃ áytiro. ");
INSERT INTO tuf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eyta waquír Jesusat bucoy wajacro: —¿Ah cutar uwa icuran wántara? ¿Biyan wántara? Aját ehcunro. Eyinan sasán wanro. ");
INSERT INTO tuf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sas rasá cuitar cuehsro. Cuehwsa rabar sasát cahujín quin wacaro: “Isat ahní rehquín acu tirá cuhjacro. Eyta cuhjác cuar, ¿bitara reht, ahní chátiqui? Etar isat chein ruhcuír eyta cuehschacro. Eyta cuehsí cuar, ¿bara bitara reht conti rehyi? ¿Bitara reht cuécutiqui?” wacaro, sasát cuehswa rabar. Aha cat uw cat éytaro. Sasát cahujín chihtá cut cuehsuti cuar tecuar eyta aha uw cat cahujín chihtá yajti cuar eyta técuaro. ");
INSERT INTO tuf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan rih sar siw̃quib wijacro. Wiquír ira yati bach yajacro. Bacua yahti bacha yajacro. Juanat bacha eyta yajcayat ques baatán ey cahmí icar tew̃ro. Baat wacaro: “Juan ur icar cuicá chero,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eyta cuar asan Uw Síuquibat báchuti ira yácaro. Báchuti bacú yahcaro. Aját eyta báchuti yajcayat, baat as cahmí icar cat tew̃ro. Baat wacaro: “Eya atuc sinro. Bacú bunaran cuitro. Eyra gobierno tayar chiquin íw̃ocro. Urá ay bár bin íw̃ocro,” wacaro. Baatán eyta wacaro. Ah cutar uwa sasán wan tecuas sinro, -wajacro, Jesusat uw quino-. ");
INSERT INTO tuf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Uch síhw̃awi. Bíyinat Sir chihtá uní síhw̃actara, ítchareht éyinat caba síhw̃ajac istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jesusat tew̃ tihrír, fariseo istiyát Jesús quin wajacro: —Bar jaw̃i, usi cuwayta. Buca owár yayay bar jaw̃i, wajacro. Eyta wacayat, Jesús ey usi bijacro. Simón usi bijacro. Erar cur ira yayín acu mesa acor chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Erar yácayat wiw̃á istiyát Jesusat yayay cujác chihtá rahjacro. Rahcuír Jesús quin rajacro. Wiw̃á eya isáribcuano. Ey wiw̃á Jesús quin bir, inan ay bi béjecro. Perfume béjecro. Ac boteya sar béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Etar erar cur, Jesús icar ojcor cujacro. Jesús quin cujacro. Ey quin cur, oy yehnjacro. Oy yehnár Jesús quescar ima ub rihar cuit sujacro. Sucuír catrun, ima cuis anará cuitar bar iw̃jacro. Jesús quescar iw̃ír, cac umá cuitar suhwujacro. Jesús quescar suhwujacro. Suhwír, perfume Jesús quescara cuitar ójocro. ");
INSERT INTO tuf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wiw̃át eyta yajquíc fariséoat itchacro. Fariseo ajca Simonat itchacro. Istír ima urá icar séhw̃ajacro: “Sirat Jesús áytiro,” séhw̃ajacro. “Cuatán Sirat áyjaquir waquít, bar istátaro. Wiw̃ eya urá bitáratara istátaro. Urá ay bár bi istátaro. Eyta istír waquít, wiw̃á quino ima but áyajatro,” séhw̃ajacro. Fariseo ajca Simonat eyta séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Cuatán Jesusat fariséoat eyta séhw̃aquey itchacro. Etar ey quin wajacro: —Simonu, aját bah quin uch chihtá waquinro, wajacro. Etat Simonat wajacro: —¿Icurcá? Werjayú, icúr waquíntara eyta waw̃i, wajacro. Etat Jesusat uw siw̃in ac uch ehcujacro: ");
INSERT INTO tuf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Serin bucáy binat tayar yajacro. Ser istiyát quinientos denarios tayar yajacro. Sera istiyát cincuenta denarios tayar yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Etar ser istiyát cat, ser istiyát cat tayar yajaquey icúr cuti túnajatro. Eyta cuácayat ráyinat eyin quin wajacro: “Aját bah quin ray wíjacan tayar chiti etinro,” wajacro. Eyta waquír tayar chiti bahnác bar etchacro. Eyta etyat ¿Sera bíyatan rayin eyan sehnacan cuít chácataqui? wajacro. Jesusat Simón quin eyta táyojocro. Etat Simonat wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Táyaran cuít yajáqueyatan ey sehnacan cuít chácata óraro, wajacro. Etat Jesusat wajacro: —Eytaro. Ay séhw̃ajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Waquír wiw̃á wihár ac waar cuar Simón quin wajacro: —Wiw̃á uch wahítuwi. As bah usi wicayat, bahatra as quescar súctiro. Cuatán éyatra ima ub rihar cuit as quescar sujacro. Sucuír car sicor ima cuis anará cuitar iw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","As usar wicayat, bahatra as aqueyra súhwtiro. Cuatán éyatra búcoyan búcoyan as quescar suhwujacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Usar wicayat bahatra as cuis ícatra aceite chátiro. Cuatán éyatra as quescar ójcoran inan ay bi ójocro. ");
INSERT INTO tuf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Etan aját bah quin wacaro. Wiw̃á uchat récaji Sir tayar cuít yajacro. Eyta cuar Sirat sicor tayar bár chájacro. Eyta bira eyat Sir sehnacan cuitro. Imát yajquey cut eyta ehcuro. Cuatán tayar conu sicor tayar bár chácayat, eyan sehnacan etach batro, wajacro, fariseo quino. ");
INSERT INTO tuf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Etar Jesusat wiw̃á quin wajacro: —Ahrun bahat ur ay bár yajáqueyra tayar bár chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eyta wacayat cahujinat rahra rahra wajacro. Jesús im owár yáquiqueyinat rahra rahra wajacro: —¿Uya rehrcá? ¿Ur ay bár yajaquey tayar bár cháqueyan rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cuatán Jesusat wiw̃á quin wajacro: —Bahat séhw̃ajacro: “As Sir tayar yajác Jesusat túnataro,” séhw̃ajacro. “Jesús chihtá cuitar Sir tayar bár jácataro,” séhw̃ajacro. Eyta séhw̃ajac rehquít bah tayar bár chájacro. Etaran ohbac biwi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Awan Jesusat puébloan bahnác cuitar siw̃ot bijacro. Sir chihtá ay bi ehcwót bijacro. Sir cara rehquey ojcor ehcwót bijacro. Ima chiwan doce bin owár béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chaunín urá sar bin cuicá újaqueyin cat béjecro. Chaunín tan jájaqueyin cat béjecro. María pueblo Magdala bin ey cat béjecro. María ey urá sar bin cuicá cucuí bin ujac biro. ");
INSERT INTO tuf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana cat, Susana cat béjecro. Juana eya sera ajca Chuza wíyaro. Chuza rey Herodes cacumró. Cahujín cat eyin owár béjecro. Bécayat imár ray cuitar, imár ira cuitar Jesusin obir yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Etar ricán to sécuajacro. Pueblo istiy bin, pueblo istiy bin sécuajacro. Jesús waquíc rahcuín sécuajacro. Eyta sécuayat Jesusat chiht istiy, chiht istiy siw̃in ac icúr bi ojcor tew̃jacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ser istiy cucú cuiay bijacro. Cucú eyan at cut cuic cuic cuijacro. Eyta cuic cuic cuicayat, cucú cahují ibit aw̃at tijcajacro. Eyta tijcayat, uwat ey sau sau ruhw̃ujacro. Ruwásirat cat ey yájacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eyta cuijacan, cucú cahují wisu arcút tijcajacro. Tijcayat bar yehnjacro. Yehnyat cat, cunyat cat, ribirát sarac tíw̃jacro. Ica suri bár reht tínjacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eyta cuic cuic cuicayat, cucú cahujeyra cachá tac icar tijcajacro. Eyta tijcayat cachá tihw̃án abáy yehnjacro. Cachá tihw̃á abáy yehnyat, cucú cuijac eyra sehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eyta cuic cuic cuicayat, cucú cahují ican tic bi cuitar tijcajacro. Etar eyra ay yehnjacro. Etar uban ehchí chájacro. Istiyán uban cien cuít chájacro, wajacro. Etaran eyta waquír, Jesusat bucoy wajacro: —Cucách ji bínatra ey rahcwa, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesusat eyta ehcwayat, ima chiwat ey chihtá ojcor táyojocro: —¿Bitara ojcor wacyi? Isat ey ay ráhctiro. ¿Cucú ojcor tew̃jác cutar bi chihtá siw̃ca? wajacro. Etat Jesusat wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—Behmarat Sir cara rehquey chihtá ay rahcuátaro. Cahmor istiti bi rahcuátaro. Cuatán cahujinat ay rahcti acu tew̃ro. Aját eyta sehw̃ar icúr bi ojcor tew̃ír cutar siw̃ro. Cahujinat ub cuitar istata cuar, ay istiti rehcayta acu eyta siw̃ro. Eyinat cucách cuit rahcuata cuar ur icar rahcti acu eyta siw̃ro, wajacro, Jesús chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Cucú cuic cuic cuijac uch chihtán siw̃in acu tew̃jacro. Cucú wacayat cucuá eya Sir chihtán wanro. ");
INSERT INTO tuf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Cucú ibit aw̃at tijcajaquey wacayat, ibit aw̃at wacayat, uw cahujín ojcor tew̃ro. Uw éyinatan Sir chihtá cucajá cuitar rahcuí cuar, ur ícari cátiro. Sisrámatan chihtá eyin quin cac áytiro. Bow̃ ca técaro. Etar éyinat Sir chihtá tamo “uniro,” síhw̃ajatro. Eyta rehquít Sirat eyin síwajatro. ");
INSERT INTO tuf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Cucú wisu arcút tijcajaquey wacayat, wisu ey wacayat, uw cahujín ojcor tew̃ro. Uw éyinat Sir chihtá rahcro. Eyta rahcuír ahní cácaro. Eyta cuar ayra cátiro. Ay cati rehquít, ítchareht waca técaro. Sir chihtá ques uwat ruhw̃ayat, éyinat chihtá waca técaro. ");
INSERT INTO tuf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Cucú cachá tac icar tijcajaquey wacayat, cachá tac icar wacayat, uw cahujín ojcor tew̃ro. Uw éyinat chihtá rahcuí cuar, ítchareht, yájcajareht iran, oyan, rayan cuít rácatro. Ey racar rehquít Sir chihtá tamo síhw̃ati etí técaro. Urá ay ítitiro. ");
INSERT INTO tuf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Cucú ica tic bi cuitar tijcár uban cuít cháqueyan wacayat, ica tic bi wacayat, uw cahujín ojcor tew̃ro. Uw éyinat chihtá ay rahcro. Ráhcuitrun urá istanác waacaro. Urán ay chácaro. Chihtá wácati itro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesusat acsar wajacro: —Uwat cheyquic sar cuanín acu vela anro. Eyta cuácayat vela ániran ruca tan icar rehratí rúhctiro. Vela ániran camic socua cahmar cat rúhctiro. Cuatán vela anír, wan quir jáquinra cuacúr chácaro. Uwat usar bahnác istayta acu chácaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Eyta cat icúr bi ruhcuítara ítchareht uwat eyan bahnác itchácayqueyra. Icuran biyan uw quin ehcuti ey semar uw bahnaquin quin ehcwáyqueyra. Ehcútiey awan bahnáquinat itchácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eyta bira yají jaw̃i. Cucáj ji chaw̃i. Ay rahcwi. Bíyatan ay ráhcyatan Sirat ey quin cuít síw̃ayqueyra. Cuatán bíyatan ay rahcti cuácayat, chihtá conu rahjác ey sicor bar etí téyqueyra. Bar tan chináyqueyra, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ima abín, ima rabin Jesús quin béjecro. Bequir ítitan, Jesús quin bitách cúwajatro. Ricán to etar raúwajar rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eyta cuácayat uwat Jesús quin wajacro: —Bah abín, rabin wátatro. Bah wahitay béjecro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eyta wacayat, Jesusat wajacro: —¿Uniqui? Bíyinatan as chihtá ráhcyatan, bíyinatan as ajc yajcáyatan, éyinan as abinró. Eyinan as rábinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Riy istiy Jesusan chiwa owár canó sar raújacro. Rauwir Jesusat eyin quin wajacro: —Bar jaw̃, riw rahray, wajacro. Etar riw rahray cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Beya rabar riw ubut cucayat, Jesusra cámjacro. Etat séroan abáy cac yehnjacro. Canó sar rih bar cuinay raújacro. Canó riw tanoso beta yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eyta cuácayat éyinat Jesús bar quehw̃ujacro. Quehw̃úr wajacro: —Síw̃quibu, Síw̃quibu. Canó riw ocso bicaro. Is bar sácataro, wajacro. Eyta wacayat, Jesús bar ajc wijacro. Ajc wiquír yehnjacro. Yehnár wajacro: —Sérou, acsar cati jaw̃i, -wajacro-. Riwu, soboti jaw̃i. Catoti jaw̃a, wajacro. Etatan sero cati etchacro. Riwa soboquin soboti etchacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Etat Jesusat chiwa quin wajacro: —¿Bitara reht aját Sir urá cut bahnác yajcata anto baat síhw̃atiqui? táyojocro, Jesusat. Sero chihryat, riw sobasob soboc chihryat, eyin ay wini rehjecro. Ub yehw̃jacro. Rahra rahra tayor wajacro: —¿Uyan rehrcá? Séroa cat, riw sobasob soboc cat chihr áyjacro. Ey chihtá cuitar chihrjacro. ¿Bitara bíntara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesusat sero caquic chihr ayir, riw rahray cujacro. Gerasa cajc cujacro. Gerasa cajc Galilea cajc ey ácatatro. ");
INSERT INTO tuf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Erar cur riw acsar ic icar waa bijacro. Waar itit, cuicá chi bin ératro. Ser eya ey pueblo binro. Siátian úchicri itro. Usatra ítitiro. Cuatán chein ruhcuíc cuitar itro. ");
INSERT INTO tuf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesús cucayat, cuicá ji eyat itchacro. Ey istír ay bár cohwjacro. Cohwiran Jesús cac cahmor cuscar cuitar chájacro. Etar Jesús quin ay bár cohwjacro: —Jesusu. Bah cuacúr Sir waquijró. ¿Icúr sehw̃ar as quin raquí? Bah ojcor conro. As ruhw̃uti jaw̃i, cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesusat récaji cuicá quin wajacro: “Ey urá sar bin car biwa,” wajacro. Eyta wajác etar cuicát eyta cohwjacro. Récaram cuicát cuan istiy, cuan istiy ser ey ruhw̃ujacro. Cahujinat ey úrojocro. Yera cuitar bucoy bucoy questajacro. Questajác cuar, yera chistara ey quit quit cuijacro. Cuiquir cuicát uw bár cuitar it áyjacro, ");
INSERT INTO tuf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Etat Jesusat wajacro: —¿Bah ajca rehrcá? wajacro. Etat cuicát wajacro: —Ricá, wajacro. Ey urá sar cuicá tócuano. Cuicán ricán abayro. Eyta cuácayat, ajca “Ricá” aw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cuicát eyta waquír, ucar usón camsom te siti acu conjacro, Jesús ojcor. ");
INSERT INTO tuf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Etat owár im ey cuhs cuitar tusín ricá to binat tihw̃á ar yacaro. Eyta cuácayat ser ey ur icar bin cuicát conjacro. Jesús quin conjacro: —Isat bah ojcor conro. Tusín urá icar rauwin ac ajc waawi, wajacro. Etat Jesusat wajacro: —Béowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Eyta ajc waacayat, cuicá ser ur icar bin waa béjecro. Beyar tusín sar raújacro. Rauyat tusín ricá to bin bahnác siyo ocso tijca suca béjecro. Beyar, riw icar sácajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tusín sácayat, tusín obir yájquinat itchacro. Istír ojc sijacro. Ojc siquir quinjacro. Pueblo cuwín quinjacro. Beya rabar uw quin bahnác ehcujacro. Cur car pueblo cutar cat bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eyta ehcwayat uwat eyta yajaquey wahitay suca rojocro. Jesús wahitay rojocro. Bequír ítitan, sera cuicá ujac bi itchacro. Ahra tan wan itro. Oya cat chájacro. Tan wan rehjecro. Eyta ityat ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Etar Jesusat yajaquey itcháquinat cahujín quin ehcujacro. Sera cuicá ji bin bitara tan chájactara, ey bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ehcwayat Gerasina ay wini rehjecro. Ay wini rehquít, Jesús quin wajacro: —Usár ítiti jaw̃i. Cajc istiy sicor biwi, wajacro, Jesús quin. Etat Jesús canó sar raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Rauyat sera cuicá bar wanictín biyat Jesús quin conjacro: —As bah owár ben acu ajc waawi, wajacro. Eyta cuar Jesusat ajc waátiro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Behmá cayin quin biwi. Aját baha tan jajac chihtá ehcway biwi. Sirat bah obir yajác chihtá ehcuwi, cayin quin. Etat récaji cuicá ji bin eyat pueblo bahnác cutar wajacro: —Jesusat as urá sar bin cuicá újacro. As tan wan chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Etar Jesús riw rahray cujacro. Erar cur ítitan, uwan ésatro. Jesús wiquíc cahmar sécuajacro. Cucayat Jesús quin ahní ténajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Uw owár erar sera ajca Jáirocuano. Jáiroan secuac usi cáraro. Eya Jesús cac cahmar bir cuscar cuitar chihrjacro. Chihrír ima usi beyin acu Jesús ojcor conjacro. Uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","—As waquíj yatro, -wajacro-. Ajáy waquíj istanacro. Eya bara dócero, -wajacro-. Restát ahra bar en bicaro, wajacro, Jáiroat Jesús quin. Eyta cónyatan Jesús ey usi cuwayta bar bijacro. Bicayat ey quemir uw ricán to béjecro. Beya rabar úcajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uw owár wiw̃á istiyró. Wiw̃á eya cuercutro. Ey rih cut rauwir bara dócero. Cab eyta ácatan abir eyat yarjacro. Wiw̃ ey rehratí sácwajatro. Rehratí tan chácajatro. ");
INSERT INTO tuf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesús ricá tac icar bicayat, wiw̃ eyan Jesús icar wihár wijacro. Wiquír Jesús oya butajacro. Butayat abir yárqueyan sicor bar tan jájacro. Bar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eyta yajcayat wajacro: —¿Rehrát as bútayi? wajacro. Etat bahnáquinat wajacro: —Batro, rehratí bútatiro, wajacro. Bahnáquinat eyta wajacro. Etat Pédroat wajacro: —Síw̃quibu, bah quemir ricán to binat úcaro. ¿Bitara reht eyta táyoqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Etat Jesusat wajacro: —Istiyát as butajacro. Ajatán itro. As urá cuitar, as camur cuitar uwa bar tan jájacro. As butár car bar tan jájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Etat wiw̃át séhw̃ajacro: “Aját yajacan Jesusat itro. Ey cahmar bitách rúhcuajatro,” séhw̃ajacro. Eyta sehw̃ar Jesús cac cahmar wijacro. Wiquír ayot tiu rabar ey cac cahmar cuscar cuitar chihrjacro. Chihrír Jesús quin ehcujacro. Ehcwayat bahnáquinat rahjacro. Uchta wajacro: —Aját bah oya butajacro. Butayat cab rehti bar tan jájacro. Ab bar chihrjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eyta wacayat Jesusat ey quin wajacro: —Wiw̃ú, bahatán “Jesusat as tan jácayqueyra,” séhw̃ajacro. Eyta séhw̃ajac etar aját bah bar tan jájacro. Ohbac biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eyta wacayat icar Jairo wacjí chinjác chihtá cat bar ehcwáy wijacro. Wiquír wajacro: —Jáirou, bah wacjí bahnác bar chinjacro, -wajacro-. Siw̃quib acsar roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesusat eyta rahcuír wajacro: —Ay wini rehti jaw̃i. Aját bah waquíj bar tan chácata séhw̃awi. Eyta séhw̃ayat bar tan jácayqueyra, wajacro. Etat bar béjecro, Jairo usi cuwayta. ");
INSERT INTO tuf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Usi cur car Jesusat cahujinra rau áytiro. Cuatán Pedro cat, Juan cat, Santiago cat, wacjá tet cat, ab cat eyin owár raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Uwa séhw̃anar bin yarjác racar oy yinjacro. Conay yinjacro. Eyta cuácayat, Jesusat wajacro: —Oti jaw̃i. Cohwti jaw̃i. Waquíj eyra yártiro. Chíntiro. Chinti cuar cámjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jesusat eyta wacayat, uwan ey buror sischacro. Cuechira yarjác ay itchacro. Etar Jesús buror sischacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Cuatán Jesusat cuechira yarjác atcar yehw̃jacro. Yehw̃ír wajacro: —Cuechiru, cui yehnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wacayat yarjác ey ajcan sicor bar wijacro. Wiquír cui bar yehnjacro. Etat Jesusat abín quin wajacro, —Cuechira ira wiw̃a, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Etan tetinát, abinát, cahujinat Jesús wahitchacro. Ub yehw̃jacro. Cuatán Jesusat cahujín quínora ehcú áytiro. ");
INSERT INTO tuf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Etar Jesusat ima chiwa doce eyin ima quin chíjacro. Chiwa Jesús quin bequir, Jesusat eyin quin urá wíjacro. Camur wíjacro. Cuicá te siayta acu, restá cat chihrayta acu, cuercúr tan chácayta acu urá wíjacro. Camur wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eyta wiquir Sir cara rehquey chihtá ehcún áyjacro. Yarquin tan jaquin áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chiwa beyin cahmor Jesusat wajacro: —Baat ehcwáy bécayat, ata béowi. Tec cat, iroc cat, ira cat beti jaw̃i. Raya cat, camís istiy cat beti jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ba pueblo istiy beyar caran, bi usi cúctara im esar ítuwi, -wajacro-. Acsar bequic ocso tas im esar ítuwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eyta cuara bi pueblo cutar uwat ba ajcá bár jácayat, ey pueblo cutar uchta yajw̃i. Ba acsar bécayat, ba quescar ojcor cajc bur béquiquey, umít béquiquey yiw yiw ter bahwi. Uw éyinat ba Sir chihtá ehcuquin ruhw̃ujác ques Sirat cuécwata ey istayta acu eyta yajw̃i, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Etat chiwa bahnaquin béjecro. Pueblo istiy, pueblo istiy ehcwót bejecro. Chihtá ay bi ehcwót béjecro. Bisar bisar bequic cut yarquin cat tan jacot béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jesusat yajaquey rey cara ajca Heródesat rahjacro. Uwat chiht istiy, chiht istiy tew̃ay yinjacro. Etar Heródesat eyta rahcuír, “¿Jesusat bi chihtá cuitar yájctara?” sehw̃ay yehnjacro. Uw cahujinat Jesús ojcor wajacro: —Uya Juan uw rih sar siw̃quibro. Juan chinjác cuar, sicor estají yehnjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Cahujinat Jesús ojcor wajacro: —Uyan úchicri Elías Sir chihtá ehcúquibro, wajacro. Istiyát wajacro: —Sir chihtá ehcuquib cahmor bin eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eyta cuar Heródesat wajacro: —Ajmár chihtá cuitar Juan yaujacro. Juan cuisa cuijacro. Eyta cuácayat ¿Jesusan bitara binca? Eyat yajquíc chihtá bucoy bucoy rahcro, wajacro. Etar im ub cuitar ita racar rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesusat chiwa áyjaquin sicor béjecro. Sicor bequir, bahnác yajáqueyan Jesús quin ehcujacro. Ehcwayat Jesusat eyin ajquír béjecro. Betsaida pueblo intac cuwayta imara béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bécayat ricá bahnáquinat itchacro. Bequic itchacro. Istír, questoc béjecro. Erar cucayat, Jesusat uwa owár ténajacro. Tenar Sir cara rehquey chihtá ehcujacro. Yárqueyin cat tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jesusat eyta ehcúr, yarquin cat tan jaquir, bar tin bicayat chiwat Jesús quin cur wajacro: —Isan ubach bár cuitatro. Usatra uw istiy ítitiro. Tini cat bar tin bicaro. Eyta bira uwa sicor aywi. Pueblo cut beyin aywi. Ubach cut beyin aywi. Ubach cat, ira cat wahitay aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Waquít Jesusat chiwa eyin quin wajacro: —Behmarat ira wiw̃i, wajacro. Waquít wajacro: —Icrí wícajatro. Is panan esí étanro. Rih ruwa bucátanro. Uw ricán to yayín acu icrí wícajatro, isat ira wahy bétitara. ");
INSERT INTO tuf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ey ricán serin saw̃ujacan cinco mílcuano, wajacro. Etatan Jesusat eyin quin wajacro: —Uwa chihr aywi. Ic icar chihr aywi, -wajacro-. Cuisa cincuenta awan ajquír, cuisa cincuenta awan ajquír chihr aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Etat éyinat uwan ic icar chihr áyjacro. Etat bahnaquin bar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Etar Jesusat pan esí bi cat, rih ruwa bucáy bi cat at cut yehw̃jacro. Yehw̃ír cuacúr wahitchacro. Cuacúr ita rabar Sir quin “Bah ur ayro,” wajacro. Eyta waquír pan cotchacro. Cotír chiwa at icar wíjacro. Uw owár tahw̃ún acu wíjacro. Wícayat, éyinat tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tahw̃úr, bahnáquinat yájacro. Uw bahnáquinat yarsa yájacro. Yaya tihryat, pan cajcar cat, rih ruwa cajcar cat sicor sécuajacro. Sécuajaquey chocha doce cuin tas ehnchacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Riy istiy Jesusat Sir ojcor conjacro. Im istír conjacro. Chiwa ecsar cuar conjacro. Conár, chiwa quin táyojocro: —Uwat waquít, ¿asan rehrcá? táyojocro, Jesusat. Etat éyinat wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Cahujinat waquít, bahan Juan uw rih sar siw̃quib yarjáqueyro. Cahujinat waquít, bahan úchicri Elías bijaquin sicor wijacro. Cahujinat waquít, bahan úchicrias Sir chihtá ehcuquib istiy yarjaquey óraro. ");
INSERT INTO tuf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Etat Jesusat wajacro: —Baat waquitra, ¿asan rehrcá? wajacro, ima chiwa quino. Eyta táyoyat Pédroat wajacro: —Bahan Crístoro. Sirat bah áyjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Etar chiwa bahnaquin quin wajacro: —Istiy quínoi as ojcor ehcuti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Acsar uchta wajacro: —Asan Uw Síuquib uwat bitara útara ruhw̃áyqueyra. Judío werjayinatán, sacerdote cárinatan, bachan chihtán síw̃quinatan as ria yajti jácayqueyra. Etar as yauwáyqueyra. As yauyat bay cuanyat sicor estají yehninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Etat Jesusat bahnaquin quin wajacro: —Bíyinan as chiwa yin cúntara, imár chíhtara síhw̃ati jácataro. Imár chihtá cut yajti cuar as chihtá yajcátaro. Cuanmí cut, cuanmí cut eyta yajcátaro. Uwat as chihtá ques eyin yauwata óraro. Bíyinan as ques icar eyta yauwata tacat as wácati ajcá ji becayat, eyin as chiwa chácataro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Cahujinat imár yauwic cahmar roocayat, as chihtá cácajar óraro. Bíyinatan eyta cati cuácayatan, eyin sácataro. As ajc rahcti reht sácataro. Cuatán as chihtá ques, uwat cahujín yauwata óraro. Bíyinan as chihtá ques yaúyatan, aját eyin síwayqueyra. Síuyat, eyin Sir jor cuacúr ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Uw cahujinat ray cat, oya cat, cajc cat cuít sécuata óraro. Eyta secua cuar, ¿im eyta cab oc icar béjeca? ¿Bahnác chíw̃ajaca? Eyta béyeyra imár ajc cat chiw̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bíyinan uw cahmor áywini rehquít, “asa Jesús chíwai batro,” wacayat, aját rahra cat ey ojcor “as chíwai batro,” waquinro. Asan Uw Síuquib cuacúr bin caran cuít yehnár sicor wiquinro. Asan Sir Tet jor cara yehnár uch cut wiquinro. Sir cuacúr cacúm carin owár wiquinro. Eyta wicayat, “eyin as chíwai batro,” waquinro. ");
INSERT INTO tuf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aját ba quin wacaro. Sir iman cara chácataro. Usár uwat cahujinat Sir eyta chaquic ey istátaro. Anto yarti cuat eyta istátaro, wajacro, Jesusat chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Eyta waquír, abi cuányatara, Jesusin cubar icar béjecro. Pedro cat, Santiago cat, Juan cat béjecro. Etan béjecro, Sir ojcor conín acu. Erar Sir ojcor cona rabar eyin ub acat Jesús arjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aryat oya cuasáy beo beo waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eyta cuácayat uw cuisa bucáy bin cat eyin acat waajacro. Uchicri cohtín Moisés cat, Elías cat waajacro. Wan beo beo waajacro. Waar Jesús owár rahra rahra tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jesús chiníc chihtá tew̃jacro. Jerusalén cuitar chinata chihtá tew̃jacro. Sir chihtá caba yajquín chinata tew̃jacro. Jesús úchicri cohtín owár eyta tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Eyta tew̃yat icar aw̃at, Pédroin cámyarat cuájacro. Etar sicor ajc wijacro. Ajc wiquír ítitan, Jesusan rahs churotír wan beo béoro. Jesusat cahujín cuisa bucáy bin owár tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Etat cuisa bucáy binan sicor beya yinyat, Pédroat Jesús quin wajacro: —Síw̃quibu, isan usaran yarisro. Isat chohcha bay tuw̃ín acu ajc waawi, -wajacro-. Istiy bah acu, istiy Moisés acu, istiy Elías acu túw̃inro, wajacro. Pédroat eyta waquíc ay séhw̃ati tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eyta wacayat icar, bowaramát eyin ehyó cay tunjacro. Bowaramát tunyat ay wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eyta cuácayat, bowarám tan sar cuar Sirat wajacro: —Uchan as waquijró. Aját ey cájacro. Cara yehnín waquír chájacro. Ey ajc rahcwi. Ey chihtá caw̃i, wajacro, Sirat. ");
INSERT INTO tuf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Etat Pédroinat wahitchacro. Ititan, imarin owár cahujinra batro. Jesús im ístitro. ");
INSERT INTO tuf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cuanmí cuit Jesusin, sicor isu wihár béjecro. Bécayat ácatar ricá to binat tihráy rojocro. ");
INSERT INTO tuf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eyta tihra rabar uw tac icar bin ser istiyát wajacro: —Síw̃quibu, aját bah ojcor conro. As waquíj wahítuwi. Eyan as wacjá istán binro. ");
INSERT INTO tuf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eya cuicát ica icar técaro. Técayat abáy cohwro. Ticji bicaro. Cac sar orjir cat waacaro. Orjir waacayat, abáy ti ti tíuro. Cuicát ey bucoy bucoy cuácaro. Et bah cun batro. ");
INSERT INTO tuf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","As waquíj roquír aját ba chiwa quin conjacro. Cuicá uquin conjacro. Eyta cuar éyinat bitách uc áyajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eyta wacayat Jesusat wajacro: —Ah cutar uwat Sir tamo síhw̃atiro. Chihtá uní bi tehmoro. As ba owár úchicri ítchacro. ¿As chihtá cuitar yajcata bin baat bitat sinin yajca? Baat sinti cuácayat, ¿aját caban bita síw̃ataca? -wajacro-. Bah wacjá as quin row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eyta wacayat, sah ey Jesús quin rojocro. Rocayat cuicát sah ey ehnchacro. Eyta cuar, Jesusat cuicá quin taniric wajacro: —Cuicú, sah ey urá sar bin yehnár biwi, wajacro. Jesusat eyta waquír, sah ey bar tan jájacro. Tan jaquir, sicor tet at icar wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Etar bahnáquinat Sir tamo ay síhw̃ajacro. “Sirat bahnác yajcátaro. Bii yájcajari batro. Bahnác yajcátaro,” síhw̃ajacro. Uwat Jesusat yajaquey chihtá tamo séhw̃ayat, Jesusat chiwa quino wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Uch rahcwi. Uch chihtá cat síhw̃awi. Asan Uw Síuquib cahujín at icar wícayqueyra, wajacro, chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eyta wacayat, ima chiwat bi ojcor tew̃íctara ayra ráhctiro. Eyinat chihtá ay rahcti acu ay ehcuti ruhjacro. Etar cat éyinat ey ojcor tayon yajquít cat ay wíniro. ");
INSERT INTO tuf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Itchareht, Jesús ima chiwa rahra rahra tecuay yinjacro. Imár owár biyan caran cuitara ey ques técuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Cuatán, Jesusat eyin urá itchacro. Bitara síhw̃actar itchacro. Eyta istír Jesusat sah istiy cájacro. Caquir im ecsar chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sah erar chaquir eyin quin wajacro: —Bíyinat as chiwa chajac rehquít, sah uch ajcá ji bécayat, éyinat as cat ajcá ji bécaro, -wajacro, Jesusat-. Eyta cat bíyinat as ajcá ji becayat, éyinat as áyjaquey cat ajcá ji bécaro. Ba biyin cahujín obir yajquín acu eyin acu cacúm chácayat, caran cuitro. ");
INSERT INTO tuf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Etat Juanat Jesús quin wajacro: —Síw̃quibu, isat cahujín itchacro, -wajacro, Jesús quin-. Isat ítitan, cahujín eyat cuicá uc si ayro. Isat rahcuít uc si ayin acu “Cuicú, aját Jesús ajc cut bah uc técaro,” wajacro. Eyta wajac etar isat ey técuajacro. “Eytara yajti jaw̃i,” wánora, isat. Eya is owár bin bár etar eyta técuajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Eyta wacayat, Jesusat Juan quin wajacro: —Eyta técuajar bin técuajacro. Biyan ba quehsuti cuácayatan, eyan ba owár binro. Etar ser ey cuicá as ajc cut úcayat técuajar binro, wajacro, Jesusat, Juan quin. ");
INSERT INTO tuf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Itchareht, yájcajareht, Jesús Jerusalén ben yehnjacro. Sir quin cuacúr ben ac bar cab cucaro. Etar Jerusalén cuwín ben yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Etar chiwan cahmor áyjacro. Samaria pueblo cuwayta cahmor áyjacro. Ubach chiín ac ira secuan ac cahmor áyjacro. Ayat béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Beyar, Samaria pueblo cucayat, erar uwat icrí wítiro. Ubach cat, ira cat wítiro. Jesusin Jerusalén bic etar wítiro. ");
INSERT INTO tuf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Samáriainat ira witi etar Jesusin becayat, Santiágoat cat, Juanat cat Jesús quin wajacro: —Caru, ¿Isat Sirat cuacúr bin oca áyayta acu chiátayica? ¿Ocat eyin sácayta acu chiátayica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Eyta wacayat, Jesusat chiwa técuajacro. Tecuar uchta wajacro: —Eytarun yajti jaw̃i. Eytarun chiti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Etat pueblo istiy cuwayta acsar béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Etar ibt aw̃at beya rabar ser istiyát Jesús quin wajacro: —Bah birar bíctara as cat bah jor erar benro. Bah jor sinay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Etat Jesusat wajacro: —As ajc rahcwi. Sinacub cat ucar chiro. Ruwasir cat chicha chiro. Cuatán asan Uw Síuquibra camín acu ubach batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Etar acsar bécayat, Jesusat istiy quin wajacro: —As jor sinay biwi. As chiwa chaw̃i, wajacro. Etat uw eyat wajacro: —Caru, récaram as tetá chiníc ocso tas usár ítinro. As tet yáryatan chein ey ruhcuinro. Etar bah owár sinay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Etat Jesusat wajacro: —Cahujinat as chíhtara cátiro. Cati éyinan chéinan wanro. Eyinat chein ruhcuátaro. Cuatán bahatra as chihtá caquir uw quin ehcuwi. Bahatra Sir cara rehquey chihtá ehcuwi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Etat istiyát Jesús quin wajacro: —Caru, as bah jor benro. Bah jor sinay benro. Eyta cuar rehcan as cayin quino ibtu benro. As usi cayin tihráy benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Etat Jesusat wajacro: —Biyinat as chihtá cácayatan éyinat bahnác cham báhtaro. Eyinat sicor war waájatro. Sicor war waáyeyra, Sir cara rehquey cuitar beya báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Itchareht Jesusat chiwa caquir áyjacro. Cuisa setenta bin caquir ima cahmor áyjacro. Bucaya awan áyjacro. Iman birar cuwíntara erar cahmor chiwa bucáy awan áyjacro. Pueblo cut cat, ácubar cuitar cat cahmor áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Beyin cahmor eyin quin wajacro: —Uwan eb rijacan wanro. Eb rijáqueyan awan semar tam rehcátaro. Eyta cat uwat Sir chihtá rahcuír, awan semar as chiwa chácataro. Eb tam rehcayat uwat eba bocuro. Eyta cat as chiwa chácata binan uw quir binro. Eyta cuar eyin quin as chihtá bíyinati éhcwajatro. Chihtá ehcuquin birách batro. Eyta cuácayat Sir ojcor conwi. Sirat uw áyayta acu conwi. Ima chihtá ehcwáy áyayta acu conwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Etar baat cat ehcwáy béowi. Ba tecuas bár bin cuar, aját ba técuasin tac icar ayro. Obasin cohtocuin tac icar ayir eyta ba cat éytaan wan ayro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bequic cat ata béowi. Ray cat beti, ucu cat beti, ques barcát cat beti, ata béowi. Beya rabar ibt aw̃at uw quin ténati jaw̃i. Ténati cuar ténoso cha béowi. ");
INSERT INTO tuf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Beyar bi usi raúwictar rauwa rabar uchta waw̃i: “Sirat usar itquin ohbac it aywi,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eyta wacayat, ey usi itquin ba quin ténayat, ba chihtá cuitar Sirat éyinan ohbac it áyayqueyra. Eyta cuara éyinat ténatieyra Sirat eyin ohbac it áyajatro. ");
INSERT INTO tuf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Etar ténaquin owár ítuwi. Baan acsar bec acat im esar ítuwi. Esar bi yayín wícayat, ey yawi. Yahn acu wícayat cat yahwi. Baat eyin quin Sir chihtá ehcuro. Sir chihtá ehcúc tehmár ira baat ohbac yayátaro. Istiy usi, istiy usi itay biti jaw̃i. Ubach istanác sar ítuwi. ");
INSERT INTO tuf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ba pueblo istiy, pueblo istiy cucayat, ba quin ténayat, bi ira wícayat, ey yawi. ");
INSERT INTO tuf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ey pueblo cuitar uw yarquin tan jaw̃i. Siran cara rehquey chihtá cat ehcuwi. Uchta waw̃i: “Siran ba ubot cara yehníc cuitar cab cucaro,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","’Eyta cuar bi pueblo cutar ba ajcá bár chácayat, ey pueblo cut uchta yajw̃i. Pueblo cuitar ibt aw̃at uchta wacay béowi: ");
INSERT INTO tuf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ba pueblo cajc bur yiw yiw ter bahcaro. As ques ojcor béquiquey yiw yiw ter bahcaro,” waw̃i, uw quin. “Baat Sir chihtá rahcti ey ehcún ac aját yiw yiw técaro,” waw̃i. “Eyta cuar baat uch síhw̃awi. Baat ey rahjaquir waquít, Sir cara rehquey cutar beta binro. Eyta cuar baat ey chihtá ráhctiro,” waw̃i, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Aját ba quin wacaro. Chihtá rahcti ques, cábara tinyat, Sir tayar yajác ques cuecuc cab cucayat, Sirat ey pueblo cut itquin cuécwayqueyra. Pueblo ey cuit itquin Sodomin cuécujac cuít cuécwayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesusat bucoy wajacro: —Pueblo Corazín uw cat, pueblo Betsaida uw cat conú cuac sácayqueyra. Eyinat as chihtá cati cuácayat conú cuac sácayqueyra. Aját yajác eyan it cuar as chíhtara ráhctiro. Aját eyin pueblo cut yarquin tan chájacro. Eyinat eyta itchacro. Itchác cuar, as chíhtara ráhctiro. Aját síw̃jaquey cucáj cuitar rahcuí cuar, urá icar chihtá cátiro. Cuatán Tiro pueblo ítquinra ur éytara batro. Aját éraran eyta yajaquir waquít, aját chihtá síw̃jaquir waquít, éyinra úchicrias ay bár yajquíc etchác ícatro. Ay bár yajác cue rehquít oya ay bár bi chajac ícatro. Oca bur imár sibará cuitar ohjoc ícatro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eyta bira cabar tinyat, Corazinat tayar yajác ques Sirat cuít cuécwayqueyra. Cuatán Tiro uwra, Sidón uwra etach cuécwajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Acsar Capernaum pueblo uw ojcor wajacro: —Capernaum uwat cuáyinir síhw̃aro. Imár úrara Sir quin béyata síhw̃aro. Eyta cuar éytara beya báreyra, -wajacro-. Cuatán éyinra cab oc icar béyayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Waquír chiwa quin wajacro: —Bíyatan baat waquíc ráhcyatan, éyatan as chihtá cat rahcro, -wajacro, Jesusat-. Eyta cat bíyatan baat waquíc chihtá cati ruhw̃uyat, éyatan as chihtá cat cati ruhw̃uro. Eyta cat biyat as chihtá cati ruhw̃uyat, éyatan Sir chihtá cati ruhw̃uro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Etar Jesusat chiwa cuisa setenta áyjacan bécajareht yájcajareht, sicor béhjecro. Sicor ahní béhjecro. Etar Jesús quin wajacro: —Caru, isat cuicá uc si áyjacro, uw ur icar bin. Bah urá cuitar, camur cuitar uw ur icar bin cuicá uc si áyjacro, wajacro, chiwat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Etat Jesusat wajacro: —Aját cuacúr itit, Sisrám Satanasan cuacúr bin bar tijcajacro. Cuir chihcuát ic oso ayir eyta Sisrám cat eyta tijcajacro. Sirat ey burbar yajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Eyta bira as chihtá rahcwi. Baat cumoró cat, carúw cat sáhuwin acu aját ba quin camur wíjacro. Etar cumoroát cat, caruwát cat ba rúhw̃ajatro. Sisramat as chihtá yajti ac ba cayar yajca racar cuar, ba cayar yajti acu aját ba quin camur wíjacro. Urá wíjacro. Etar Sisramat ba cayar yájcajatro. Rúhw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eyta cuara eyta rehquiti tahnác ahní rehti jaw̃i. Baat cuicá uc si ayic rehquiti tahnác ahní rehti jaw̃i. Cuatán uch ojcotra ahnian tahnác rehw̃i. Sirat ba ajcan cuacúr carit cuitar cuihsujacro, -wajacro, ima chiwa quin-. Baat ey chihtá cajac reht ajc cuihsujacro. Etar ba síwataro. Eyta síwata cuihsujác etar ahnian tahnác rehw̃i, wajacro, Jesusat ima chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eyta waquír, Sir Ajcan Cámuran Ey cuitar Jesusan ahní rehjecro. Eyta rehcayat Jesusat Sir quin wajacro: —Siru, Tetú, bah ur ayro. Cuacúr abá cuitar, cajcan ican bahnác cuitar bah caran cuitro. Behmá urá cuitar uw cájacro. Urán ajcan cuít binra cátiro. Cuatán sasá urán wan bin cájacro. Eyta caquir eyin quino behmá chihtá ehcujacro. Sir cara rehquey cutar bitáratar ey ojcor bahnác ehcujacro. Urá cuít bin quínora ehcútiro. Cuatán sasá urán wan quínora bahnác ehcujacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Etar uw quin wajacro: —Sirat Tetát as at icar bahnác wíjacro. Biyan Sir waquíjtara rehratí istítiro. Cuatán Tetatrún itro. Eyta cat Tetán rehrtara uw bahnáquinatan istítiro. Cuatán wacjatrún Tetán itro. Ajatrún rehrtara itro. Wacjatán biyin quin ehcwayat, éyinat cat Tetán itro. Siran itro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eyta waquír chiwa quin cahujínatra rahcti cuar uchta wajacro: —Baat behmár ub cut ay bin itchacro. Etar ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uchicri Sir chihtá ehcúquinat baat itquey it cun rehjecro. Rey cárinat cat baat itquey it cun rehjecro. Ricán to bínatan it cun rehjecro. Eyta cuar éyinat istiti rehjecro. Ba cucáj acat tew̃quey éyinatan rahcua racar rehjecro. Eyta cuar ráhctiro. Cuatán baatrún bar rahjacro. Bar itchacro, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Riy istiy judío bachan chihtán síw̃quibat Jesús quin táyojocro. Jesús cayar yajquín sihw̃ar uchta táyojocro: —Síw̃quibu, bahat ítitan, ¿Aját icúr yajcátaca? Sir quin cuwayta ¿aját icúr yajcátaca? ¿Bahat bitara séhw̃ataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Etat Jesusat rahra táyojocro: —¿Sir bach cáritan chihtá cáritan cutar icúr cuihsú bahjaca? Bahat itit, ¿bitara cuihsú bahjaca? táyojocro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eyta táyoyat bachan chihtán síw̃quibat wajacro: —Sir bachan chihtán cuihsúr bahjacan úchtaro: Siran sehnác chaw̃i. Bah urá istán cuitar, ajc istán cuitar, bah canar chihchír bahnác cuitar, bow̃ bahnác cuitar Siran sehnác chaw̃i. Eyta cat behmá urá cut behmán sehnác eyta cahujín cat eyta sehnác chaw̃i. Sir bachan chihtán éytaro, wajacro, bachan chihtán síw̃quibat. ");
INSERT INTO tuf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Etat Jesusat wajacro: —Bahat yarís wajacro. Bahatán eyta yarís yájctara, Sir quin cuwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Etat bachan chihtán síw̃quibat uw cac cahmar ay waac cun rehquít, Jesús quin bucoy táyojocro: —“Cahujín,” wacayat, ¿biyin ojcor waquí? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Biyin ojcor wáctara ehcún acu Jesusat uchta wajacro: —Ser istiy Jerusalén bin Jericó pueblo cuwín bijacro. Bicayat bésinat ey cájacro. Caquir yaran abáy tajacro. Tajquír oya cat, ray cat ey ohnor bahnác siu bejecro. Etar ser eyra ibit aw̃at cham báhjacro. Yaratan chéinan wan cuaquir cham báhjacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Etat icar sacerdote ey ibt aw̃at bijacro. Eyta bicayat, tac yehw̃jaquey itchacro. Istíc cuar ajcá yájtiro. Ecoso tiw̃ acsar bar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Etat ey questoc leví uw cat bijacro. Bicayat tac yehw̃jaquey itchacro. Istír eyat cat ajcá yájtiro. Ecoso tiw̃ acsar bar bijacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Etat bucoy Samaria uw cat ey ibt aw̃at bijacro. Bicayat tac yehw̃jaquey istír, ey rácara cue rehjecro. Cue rehquír sehnác rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eyta rehquitrun tac yehw̃jaquey quin cur ey sacujacro. Sec cat, timá cat chájacro. Chaquir cat, sacúr cat, oya cuitar questajacro. Etar ima asanica arcutar tac yehw̃jaquey yehw̃ír chájacro. Eyta chaquir camic usi cuwín béjecro. Erar cur catrun tac yehw̃jaquey obir yajacro, Samaria uwat. ");
INSERT INTO tuf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eyta yajquír cuanmí cuitrun camic ubach cayíb at icar cham báhjacro. Obir yajcayta acu cham báhjacro. Cham bahr, ubach cayíb quin “Aját récaji raya bucáy túninro,” wajacro. “Bahat tac yehw̃jaquey obir yajw̃i. Eyta yajcayat, ray echí áhuyeyra, aját sicor bah quin túninro. Obir yajquíc tayar aját sicor túninro. Aját wiquír túninro,” wajacro, Samaria uwat. Jesusat uw quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Etar bachan chihtán siw̃quib quin táyojocro: —Ey aw̃at cuisa bay bin béjecro. Bahat ítitan, ¿Biyat ima sehnác eyta tac yehw̃jaquey eyta sehnác chacyi? táyojocro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Etat bachan chihtán síw̃quibat wajacro: —Yarquey obir yajáqueyat ima sehnác eyta yarquey cat eyta sehnác chájacro. Etat Jesusat wajacro: —Bahat cat eyta yajw̃i, wajacro, bachan chihtán siw̃quib quin. ");
INSERT INTO tuf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Eyta waquír Jesusin acsar béjecro. Acsar bécayat, Jesús pueblo istiy cuit cujacro. Erar cucayat wiw̃át ubach wíjacro. Wiw̃á ajca Mártaat Jesusin quin ubach wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta taná ajca Maríacuano. Jesús usar rauyat, María Jesús ecor chihrjacro. Jesusat waquíc rahcuay raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eyta cuar Mártara ira aníc rehquít cáysiro. Eyta cuácayat Mártaat Jesús quin bir wajacro: —Caru, as tanát as cuitar yajti chac báhjacro. ¿Bahat as tamo síhw̃atiica? -táyojocro-. As taná quin as cuitar anay aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Etat Jesusat wajacro: —Mártau, Mártau, bahatra chihtá istiy, chihtá istiy sehw̃a yatro. Bahan cáysian abayro. ");
INSERT INTO tuf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cuatán istanác ey yajcáyatan ayan cuitro. Maríat eyta yajcáy raújacro. Eyta yajcáy raújaquey bíyati síwajatro, wajacro, Jesusat Marta quin. ");
INSERT INTO tuf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Riy istiy Jesusat Sir ojcor conjacro. Cona tihryat, ima chiwa istiyát wajacro: —Caru, Juanat ima chiwa quin Sir ojcor coníc síw̃jacro. Bahat cat isan eyta siw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wacayat, Jesusat chiwa quin Sir ojcor conín siw̃in ac uchta wajacro: —Baatán Sir quin conyat uchta waw̃i: Tetú, uwat bah tamoan ay séhw̃ataro. Bah uw bahnaquin acu Cara yehnwi. ");
INSERT INTO tuf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuanmí cuit, cuanmí cuit is yayín acu ira wiw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cahujinat is tayar yajcayat, isat sicor tan wan ténaro. Etar isat bah tayar yajcayat, sicor is cat tayar bár chaw̃i. Isat ay bár yajquín síhw̃ayat, is eyta yajti acu síuwi. Isat ay yajquín aywi. Jesusat eyta jaw̃ conín acu síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Acsar Jesusat eyin quin wajacro: —Iw̃oquin quin baat chey ubot ira chiay biquir waquít, ey quin wacata óraro: ");
INSERT INTO tuf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Chahrú, as ac ira wiw̃i,” wacata óraro. “Awan as cáyinan cajc istiy bin bar wijacro. Eyta cuácayat, aját ey quin icrí wícajatro,” wacata óraro. ");
INSERT INTO tuf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eyta waquír waquít usar bin eyat wacata óraro: “As quehw̃uti jaw̃i,” wacata óraro. “Querat bar tunjacro. Cay tunír sicar as bar cámjacro. Sas owár bar cámjacro,” wacata óraro. “Aját bitách wícajatro. As bitách yéhnajatro,” wacata óraro, usar eyat. ");
INSERT INTO tuf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eyan ba íw̃oquin cuar icrí wítiro. Cuatán ey quin seo chícayatra, bar wícayqueyra. Icúr chictar bar wícayqueyra, wajacro, Jesusat chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Eyta cat icúr rácartara, Sirat ey wícayta acu conwi, -wajacro-. Eyta conyat, Sirat bar wícayqueyra. Icúr rácartara, Sir cac cahm conay biwi. Eyta conay bicayat, baat icúr úroctara istáyqueyra, -wajacro-. Tunjaquey waan chícayat cat, Sirat rahcuír ba acu bar waáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Biyat coníctara, ey at icar wícaro. Biyat conay bíctara, eyat itro. Biyat tunjaquey waan chíctara, eyin ac waacaro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sasá tetinú, ba wacját ba quin rih ruwa chícayat, baat waquích quin cumoroí wítiro. Rih ruwa wícaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Eyta cat sisbúr ahná chícayat, baat caruwí wítiro. Ahná wícaro. ");
INSERT INTO tuf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ba urá ay bár cuar, ba waquíj quin ay bi racar wiquic sínjacro, -wajacro, sasá tet quin-. Eyta cat Síratan ba Tetatán cuacúr éyatan ba quin racar cuít wícayqueyra. Baat ey quin chícayatan, Síratan ima Ajcan Camur Ey ba ur icar chácayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Riy istiy Jesusat sera urá sar bi cuicá uc áyjacro. Cuicát ser ey ruhw̃ujác rehquít, ajc batro. Jesusat cuicá uc áyatan, ser ey sicor bar tew̃jacro. Sicor bar ajc chi waajacro. Ajc tew̃yat uw ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eyta cuara uw tac icar bin cahujinat wajacro: —Cuicá cara ajca Beelzebú urá cut camur cut Jesusat cuicá uc si ayro, wajacro, imár owár. ");
INSERT INTO tuf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cuatán cahujinat Jesús quin wajacro: —Is cac cahmar Sir urá cut bahnác bar yajcata ehcuwi. Siri bár binat yájcajar bi yajw̃i. Isat cuacúr Sir imát bah ayjac istayta acu eyta yajw̃i, wajacro. Jesús urá wahitín acu eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Eyta cuar uwat síhw̃acan Jesusat itchacro. Etar eyin quin wajacro: —Satanasat uw ur icar bin ima Satanás uc tétiro. Bi gobierno wahw̃úr rahr rahr tec quejcayat, ey gobierno bar bahnátaro. Eyta cat usar itquin imár owár rahra rahra tec quejcayat, bar sácataro. ");
INSERT INTO tuf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eyta cat Satanás chiwa wahw̃uyat, rahra rahra tiw̃ay yinyat, Satanás chiwan imár owár bahnátaro. Baat waquitan, ajatán Beelzebú urá cut cuicá uc si ayic, wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cuatán Beelzebú urá cut, camur cut aját cuicá uc ayquir waquít, ¿ba chíwatra bi urá cut uc ayic síhw̃aqui? Baat ítitan, ¿bi chihtá cuitar uc si ayqui? Baatán itro. Etar behmár chiwat ba urá wahitáyqueyra. Urá wahitír ba cahm icar tew̃áyqueyra, -wajacro, Jesusat uw quin-. ");
INSERT INTO tuf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eyta cuar Sir urá cut aját cuicá uc si ayat, uch síhw̃awi. Sir cara rehquey ba ubot yehnjác, síhw̃awi, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Sera chihchír bíjiyat ima ubach ay bi querat acor úroro. Tota jaw̃, bajít chaw̃ cuar úroro. Eyta úroyat oyan, rayan bitách chíw̃ajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Eyta cuar istiy chihchirán cuít bíjiyat bes yajcáy racaro. Racayat, cayíb burbar yajcátaro. Tota cat, bajít cat bahnác síuro. Cayibat tota cuit, bajít cuit chiw̃ ayti síwata síhw̃ajac cuar, im ohnor bahnác síuro, -wajacro-. Eyta siwir oya cat, ray cat bahnác ey ohnor chiw̃ro. Chiw̃ír besin imár chiwa owár tahw̃uro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Bíyinan asi jor bártara, éyinat as quehsuro. Eyta cat bíyinatan as cuitar chihtá ehcuti rehcáyatan, éyinatan uw quin as chihtá cac áytiro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Acsar Jesusat wajacro: —Cuicá uw urá sar bin uquir áyatan, cuicá eyat bir cut ítatatara uroy bicaro. Uw bár cuitar wahitay bicaro. Tan jaquin ac wahitay bicaro, -wajacro-. Eyta cuar bísari ítajatro. Bir cuti tan chácajatro. Bísari ítajar rehquít ima ur icar séhw̃aro: “As sicor benro. As birar bin uquir rajáctara as sicor erar rauway benro,” séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eyta sehw̃ar bicayat, rajác cut cur itit, ayro. Bahnác órojocan wanro. ");
INSERT INTO tuf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Cuicát ay órojoc istír cuicá cahujín ucay bicaro. -wajacro-. Bucoy cuicá cuisa cucuí bin ucay bicaro. Cuatán cuic éyinra técuasan cuít binro. Etar eyin roquír, sera ur icar bequír abáy ruhw̃uro. Récaram táhnaqui ruhw̃útiro. Cuatán bucoy cuitatra cuít ruhw̃uro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Eyta wacayat icar, wiw̃ istiyát ricá tasar bíjiyat cohwjacro. Jesús quin wajacro: —Bah sutá wíjaqueyan Síratan rácatro. Bahan bi ohcuá sar bin ubot wijactar, Síratan eyan rácatro. Bah abán Sirat obir yajcátaro, wajacro, wiw̃ istiyát. ");
INSERT INTO tuf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wiw̃át eyta cohwyat, Jesusat wajacro: —Bíyinatan Sir chihtá rahcyat, Sirat éyinan rácaran cuitro. Bíyinatan Sir chihtá cácayat, Sirat éyinan rácaran as ab cuitro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ey ricar ricán to béhjecro. Etar Jesús quemir uwan to sécuajacro. Sécuayat Jesusat uchta wajacro: —Ah uch cutar uw ur ay batro. Sir tamo síhw̃atiro. Eyta rehquít, éyinat Sir urá cut, camur cut bahnác yajcata ehcún acu as quin yajc ayro. Sirat as áyjactara, áytitara istín acu as quin eyta yajc ayro. Eyta yajc ayic cuar aját éytara yájtiro. Eyta yajti cuar, úchicri Sir chihtá ehcuquib Jonasat Sirat ayjac ehcúr eyta, aját cat eyta jaw̃ ehcunro. ");
INSERT INTO tuf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonasan rih ruwa cumac bi tan sar bay cuanjacro. Bay cuanyat, estají waajacro. Waacayat, Nínive uwat ey chihtá cájacro. Sirat ey ayjac sihw̃ar cájacro. Etarwan ah rícara, asan Uw Síuquib cat, ica tan sar bay cuaninro. Bay cuanyat estají yehninro, Sirat as ayjac ehcún acu. ");
INSERT INTO tuf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Etar cabar tinyat, Nínive uwat ah uch cutar uw cahm icar tew̃áyqueyra. Ah uch cutar uwat tayar yajác ehcwáyqueyra. Cahmor úchicrias Jonasat eyin quin Sir chihtá ehcujacro. Etar éyinat chihtá cájacro. Urá ay bár yajquíc cat bar tehmojocro, -wajacro, Jesusat-. Cuat asan ajcan urán Jonás cuitro. Eyta cuar, aját waquíc ráhctiro. Ah úwatra cátiro. Uchicrias chaucat yajaquey síhw̃awi. Chauc eya uwa cara chájaquincuano. Cajc istiy binro. Cajc istiy cut bin Salomón chihtá rahcuay rajacro. Salomón urán cuít etar ey chihtá sinin ac rahcuay rajacro, -wajacro, Jesusat-. Cuatán asan urán Salomón cuitro. Eyta cuar, ah uch cutar uwat aját waquíc ráhctiro. Eyta bira chauwíc éyatan uchin cahmí icar tew̃átaro. Cabar tinyat, úchinat tayar yajác ehcwátaro, wajacro, Jesusat uw quin. ");
INSERT INTO tuf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesusat eyta waquír wajacro: —Uwat vela ojcor oc anir cat soya cahmatra rúhctiro. Cajón satra rúhctiro. Cuatán vela ojcor oc anir cuacrár usar chácaro. Eyta chácayat, uwat usar rauyat, bahnác bar istátaro. ");
INSERT INTO tuf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ba uban ba acu oca siran wanro. Oca sira acat bahnác úbaro. Eyta cat baat ay istictar, bitara yajcata bíntara baatán itro. Eyta cuar ba ub ay bártara, baat icúr yajcata bíntara istítiro. ");
INSERT INTO tuf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eyta bira yají chaw̃i. Eytair báreyra ba urá wanquír cuanjác sihw̃ac cuar, ¿cuécuman cuít réhcajaca? Ba quin urá wijac cuar, ¿urá bár réhcajaca? ¿Bitara útara istiti rabar ay bár yájcajaca? ");
INSERT INTO tuf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Baat bitara yajquey ay istictar, ba ur icar checúm batro. Ay istátaro. Oca sira acat bahnác uba ay istír eyta ba ur icar eyta ay istátaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesusat uw quin tew̃ tihryat, fariseo istiyát Jesús quin wajacro: —Bar jaw̃, as usi ira yayay, wajacro. Eyta wacayat Jesusan ey jor yayay bijacro. Etar usi cur car ira yájacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Etat fariséoat itit, Jesusat atum sucti ira yácaro. Eyta istír ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Etat Jesusat ey quin wajacro: —Ba fariséoinat soya cat, toca cat cuitchiney rest ey sucro. Cuitchiney sucuí cuar úsotra súctiro. Uwat ba tamo ay síhw̃ayta acu baat atum rest ey sucro. Eyta cuar ba urán ay batro. Baat uw cayar yajcaro. Bes yajcaro. ");
INSERT INTO tuf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ba urá bár binu, Sirat uw cuanín waquír chájacro. Cuitchiney chi, urá chi cuanín waquír chájacro, -wajacro, fariséoin quin-. ");
INSERT INTO tuf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eyta bira ojc um restá étaqui sucti jaw̃i. Ba tan sar cat urá ay rehw̃i. Oya bár bin quin, ray bár bin quin ira cat wiw̃i, -wajacro-. Eyta yajcáyatan ba Sir ub cahmor ur ay rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Fariséoinu, ba conú cuac sácayqueyra. Baatán icuran biyan bahnác saw̃uro. Saw̃úr car Sir acu cat cahují ajquír wícaro. Baat ir icar aquibo chaquic ey cat saw̃úr ucasi bin sicar úbisti, ucasi bin sicar úbisti uquir Sir quin wícaro. Aquibo chaquic istiy sicar, istiy sicar eyta wícaro, -wajacro-. Eytaan caba wic cuar baat uw cayar yajcaro. Sir sehnác chátiro. Baat Sir quin eyta wícata bin wícaro. Eyta cuar uw cat cayar yajti ítata binro. Sir cat sehnác chácata binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Fariséoinu, ba conú cuac sácayqueyra. Ba secuac usar banco ehchian cuít bi cuitar ita racar isoro, -wajacro-. Rasá cuitar uwat behmár quin ay tena aya racar isoro, -wajacro, Jesusat fariséoin quin-. ");
INSERT INTO tuf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ba conú cuac sácayqueyra. Chein ruhjác aw̃at uwat istiti rabar sáhuro. Ba cat chein áw̃atan wanro. Etar uwat ba urá ay bár istítiro. Ba urá ay bár istiti rabar baat yajquír eyta uwat cat eyta yajcaro, wajacro, Jesusat fariséoin quin. ");
INSERT INTO tuf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Etat judío bachan chihtán síw̃quibat Jesús quin wajacro: —Síw̃quibu, bahat eyta wacáyatan, is ojcor cat ay bár wacaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Etat Jesusat wajacro: —Bachan chihtán síw̃quinu, ba conú cuac sácayqueyra. Baatán uw quin bachan abáy yajc ayro. Bachat uw cuácaro. Owat uw cuaquir eyta, bachat cat uw eyta cuácaro. Eyta cuar baatrá eyin cuitari yájtiro. Cónui yájtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Ba conú cuac sácayqueyra. Baan behmár cohtinán wanro. Ba cohtinát Sir chihtá ehcuquin tíw̃jacro. Eyta cuar ba cohtinát tiw̃jac chein ruhjác ubach baat tuw̃ro. ");
INSERT INTO tuf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ba cohtinát Sir chihtá ehcuquin tiw̃jac cuar, chein ruhjác úbachra baat tuw̃ro. Baat sihw̃at, caba tíw̃jacro. Etar chein ruhjác ubach tuw̃ro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Eyta tíw̃ata eyan récaji Sirat itchacro. Istír ey ojcor im urá cut carit cuitar uchta cuihsú báhjacro: “Aját uw quin as chihtá ehcuquin cat, as uw carin cat áyinro,” wajacro, Sirat. “Eyta cuara uwat as chihtá ehcuquin, as uw carin cahujinra tíw̃ayqueyra. Cahujinra ruhw̃áyqueyra,” cuihsú báhjacro, Sir carit cut. ");
INSERT INTO tuf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eyta bira Sir chihtá ehcuquin bahnác tiw̃jac tayar ques cuécwataro. Ah uch uw cuécwataro. ");
INSERT INTO tuf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sir chihtá ehcuquin síhw̃anar tíw̃jacro. Abel yauwi cuitar cuar istiy cat, istiy cat Zacarías ocso tas eyta tíw̃jacro. Zacarías Sir usi cuácayat yaujacro. Uw eyta tiw̃jac tayar bahnác ques cuécwataro. Aját ba quin wacaro. Eyta tayar yajáqueyan bahnác ah cutar itquin acam rehcáyqueyra, wajacro, Jesusat bachan chihtán siw̃quin quin. ");
INSERT INTO tuf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Bachan chihtán síw̃quinu, ba conú cuac sácayqueyra. Baatán uw quínoan Sir chihtá ehcuti ruhc téjecro. Behmarat Sir chíhtara yájtiro. Etar cat bíyinatan Sir chihtá caquin rehcayat, baat eyin quin cac áytiro, wajacro, Jesusat bachan chihtán siw̃quin quino. ");
INSERT INTO tuf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Eyta waquír usar bin waa bijacro. Etar fariséoinat bachan chihtán síw̃quinat Jesús ac abáy túrjacro. Turir chiht istiy ojcor, chiht istiy ojcor táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesusat cayar yajquín acu téw̃ajar bin tew̃ayta acu eyta táyojocro. Bi ques yauwátatara istín acu eyta tayor rahcuítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Etat owár Jesús quemir ricán to quiujacro. Quiwír, uwan rahra rahra úcajacro. Etat Jesusat récaji ima chiwa quino wajacro: —Yají chaw̃i. Cuayar sinti jaw̃i. Fariséoin buc rehquey bútati jaw̃i, -wajacro-. Eyin chihtá buc réhqueyan wanro. Eyin urá bucayro. Etar ey chihtá cahm yají chaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bi chihtán ur icar ruhcui eyan ítchareht yájcajareht bahnáquinat istáyqueyra. Bi chihtán uw quin rahcua ayti cuácayatan, eyan semar semar bahnáquinat rahcuáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eyta bira baat chéycara cuitar ruhcuír tew̃íc cuar, awan uwat rahcuáyqueyra. Istáyqueyra. Baat cahujín cucáj acat cuach cuach tew̃jaquey awan watar cajc birá cuitar cuar cohwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aját ba ajmaráy íw̃oquin quin wacaro. Bíyinatan ba sibár yauwin yajcayat eyin cahmar rooti jaw̃i. Eyinat sibár eyra yauwi cuar acsar bii yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cuatán rehr cahmar roótatara aját ey ehcunro. Sir cahmar roótaro. Eyat ba sibár yauwir car, ba ajc cat cab oc icar áyataro. Etar ey cahmar roótaro. -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ruwásira cuisa esí bin icar ray sencillo bucatac tunro. Ruwásira aca bár cuar, Sirat cuis istiyí tamoi tan chíntiro. ");
INSERT INTO tuf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Uch síhw̃awi. Ba cuis anar bítatara, Síratan itro. Eyta bira uw at cahm rooti jaw̃i. Sirat ba sehnacan ruwasir cuitro. Eyta cuácayat Sirat ba obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Uw cucajá acat bíyatan “Jesusan as cáraro,” wacáyatan, asan Uw Síuquibat cat rahra ey ojcor uchta waquinro: “Eyan ajmár uwro,” waquinro. Cuacúr cuitar Sir cacmín cac cahmar eyta waquinro. ");
INSERT INTO tuf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cuat uw cac cahmar bíyatan “Jesusan as cárai batro,” wacayat, aját cat rahra uchta waquinro: “Ey ajmár uwi batro,” waquinro. Cuacúr cuitar Sir cacmín cac cahm eyta waquinro. ");
INSERT INTO tuf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bíyatan asan Uw Síuquib ojcor ajc ay bár tew̃yat, eyat Sir tayar yajcaro. Eyta cuar eyta tayar yájcyeyra Sirat sicor tayar bár chácataro. Biyat Sir Ajcan Cámuran Eya ojcor ajc ay bár téw̃yeyra, eyta téw̃queyat cat Sir tayar yajcaro. Eyta cuar Sirat tayar eyra batra chátiro. Tayar chi rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Uwat ba secuac usar eyin cac cahm beyáyqueyra. Erar roquír ba cahm icar tew̃áyqueyra. Werjayín cac cahmar cat, carin cac cahmar cat ba cahm icar tew̃ay beyáyqueyra. Ba eyta becayat, baat eyin cahmar rooti tew̃i. Bitara tew̃átatara, bi chihtá ehcwátatara, sihw̃a sácati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Baat tew̃íc cab cucayat acat Sir Ajcan Cámuran Eyat baat icúr wacátatar ba quin ehcwáyqueyra. Ey chihtá ba ur icar wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Etar ricá tasar bin istiyát Jesús quin wajacro: —Werjayú. As tet bar yarjacro. Yaryat as rabat oy ey, ray ey, cajc ey imáy bahnác bar cájacro. Eyta bira bahatán as rab quin asi jor wahw̃ú aywi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eyta wacayat, Jesusat wajacro: —Uch rahcwi. Asra eyta acui batro. Asan ey wahw̃ún acui batro. Rehratí as eyta yajquín acu chátiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eyta waquír bahnaquin quin wajacro: —Yají jaw̃i. Cahujinay racar isoti jaw̃i. Oyan cuít, rayan cuít cuácayatra, ey chihtá cuitarara behmár sácati siwa báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","’Baat ey chihtá sinayta acu aját uch ehcunro. Riy istiy oyin cajc cuitatran ira uban ehchí chájacro. Iran to yehnjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eyta yehnyat, oyin eyat im urá sar séhw̃ajacro: “¿Aját icúr yajquinca?” séhw̃ajacro. “As iran toro. Bísari yehw̃ chácajatro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","’Eyta sehw̃a rabar uchta séhw̃ajacro: “Aját uchta yajquinro. Aját ira chaquic ubach quehr tenro. Quehr ter tehmár aját ubach cúmacan cuít bin istiy cat, istiy cat tuw̃inro. Tuw̃ír sar aját ira cat, oya cat ey sar yehw̃ jáquinro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Eyta jaquir, ajmár tánsara séhw̃anro: ‘As ira cat, oya cat cuitro. Yaya báhnajatro. Ow̃ báhnajatro. Eyta cuácayat canár yajti ítinro. Ira yayinro. Bacua yahnro. Ahní ítinro,’ séhw̃anro.” Oyinat eyta séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Eyta séhw̃ayat, Sirat oyin quin wajacro: “Bah chíhtara cuáyitro. Cuat ah tino bahra bar yarátaro. Bah yaryat bah oyan iran ¿rehráy cháquinca? Bahat tuw̃jaquey sécuajaquey ¿rehráy jáquinca?” wajacro, Sirat oyin quin. ");
INSERT INTO tuf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bíyinat oya cat, ray cat sécuayat, eyin cat eyta rehcátaro. Eyinat ray tamo sehw̃a rabar Sir ub cahmar ay icuri yájtiro. Etar eyin acu eyta rehcátaro, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Etat Jesusat ima chiwa quin wajacro: —Eyta cuácayat aját ba quin uch wacaro. Ba icúr yayíntara síhw̃ati jaw̃i. Ba icúr ow̃íntara síhw̃ati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ira yaquic tecut, oya ów̃i tecut étana Sir cac cahmar yarisra ítajatro. Acsar Sir tamo cat síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Rúncara itquey tamo síhw̃awi. Rúncarat chiyra cátiro. Ira cat rítiro. Ira cat sécuatiro. Usar carót cat batro. Socua cat batro. Eyta cuar Síratan rúncara yayín acu wícaro, -wajacro-. Cuatán Síratan baan ajcá jian runcar cuít bécaro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Behmár chihtá cuitatrun cúnajatro. Sihw̃a saca yajquít catum behmár chihtá cuitatrun acsar bitách cúnajatro. Etarwan cuayar sihw̃a sácaro. ");
INSERT INTO tuf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Baatán cónui yájcajatro. Etar ¿bitara reht cuít yajquín síhw̃aqui? ");
INSERT INTO tuf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Acsar oya ojcor wacaro. Uch síhw̃awi. Suw bihnquey tamo síhw̃awi, -wajacro-. Suw chaquic tamo síhw̃awi. Súwatra canar yájtiro. Quéjtiro. Oya cat cuíhtiro. Eyta cuar uwat itit, óriquenro. Suw óriquenan oya cuitro. Aját ba quino wacaro. Carin oyin Salomonat oya óriquenan etach ów̃tiro. Salomonat oyan ay binan to ow̃jac cuar, óriquinan suwa etach cutiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Baatán Sir tamo caba síhw̃atiro. Uch síhw̃awi. Síratan suw óriquen yin ayro. Eyta bira ba ácuan cuít ow̃in wícayqueyra, -wajacro-. Riy istiy tihw̃ suw óriquen rehcaro. Cuatán cuanmí cuit oc icar wahnro. Eyta cuar Sirat tihw̃ suw eyan ay obir yajcaro. Sirat tihw̃ suwan eyta obir yajc eywat ba uwan cuít obir yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eyta bira icúr yayíntara, icúr yáhntara sihw̃a sácati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sir tamo síhw̃ati binat sihw̃ar éytara baat éytara síhw̃ati jaw̃i. Sir tamo síhw̃ati bin urán wan chati jaw̃i, -wajacro-. Eyinat bi yayíntara, bi yáhntara ey tamo síhw̃aro. Cuatán Sir tamora síhw̃atiro. Eyta cuar bah oya cat, ira cat táyocan Sirat itro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cuatán Sir chihtá yajquín tamoan cuít síhw̃awi. Sir chihtá yajquín síhw̃ayat, baan Síratan oya cat, ira cat wícayqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesusat acsar chiwa quin wajacro: —Ojc siti jaw̃i. Baan as óbasan wanro. Ba ajáy bar cájacro, -wajacro-. Síratan baan carin chac cunro. Sir ima cara rehquey cutar ba carin chac cunro. ");
INSERT INTO tuf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bay icuran biyan ey rawi. Rar car ray túnjaquey ray bár bin quin chaw̃ wiw̃i. Sir ajc cut eyta wícayat, Sirat ba quin cuacúr wiquin chájaquey bahná báreyra. Sir imát ba ac cuacúr cutar wiquin chájaquey ohná báreyra. Iwa báreyra. Bes cat yajca báreyra. Rohritát ehswá báreyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Cajc uch cutar rayan oyan to sécuayat, baat ey tamoa síhw̃ayqueyra. Cuat cuacúr cut Sirat ba quin wiquin to sécuayat, ey tamoa síhw̃ayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Baan as wiquíc acor ítuwi. Bahnác oror ítuwi. Oya cat chaquir ítuwi. Oca cat anir ítuwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cacmín uchta binan wan chaw̃i. Cacmín ima cara wiquíc acor ítquinan wan chaw̃i. Cacmín eyin cara cajc istiy uwat wiya yehw̃íc fiesta cuit bijacro. Etar cacmín cara wiquíc acor itro. Itchareht cara wiquír querat acor ténayqueyra. Ténayat cab rehti waac acor itro. ");
INSERT INTO tuf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cab rehti eyta waacayat, carat ítitan, ima cacmín camti im acor itay raújacro. Biyinan imár carat eyta itic ityat, eyan ohbac ítayqueyra, -wajacro-. Aját bah quin wacaro. Car eyat ima oya timá anti acu órayqueyra. Oror im cacmín eyin acu ira anír wícayqueyra. Eyin ac ira siáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Car eya chey ubut wic tacat, buru cucayat wic tacat, carat im acor camti itic ityat ayro. Cacúm eyta itic éyinan ohbac ítayqueyra -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Uch cat síhw̃awi, -wajacro-. Ubach cayibat besin bítajat wicátatara istátair waquít, camti ítata binro. Usi icuri chiw̃ áyajar binro. ");
INSERT INTO tuf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eyta cat, tana cam asan Uw Síuquib sicor wiquinro. Uwat as wícajar síhw̃ayat icar, as bar wiquinro, -wajacro-. Eyta cuácayat as wicata sihw̃a rabar ítuwi, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Etat Pédroat wajacro: —Caru, bahat eyta ehcúqueya ¿is istir quínoa ehcuyi? ¿Bahnaquin quínoi ehcuyi? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pédroat eyta táyoyat Jesusat wajacro: —Biyan cacúm ay binan wántara aját eyin quin tew̃ro. Cacúm ay binat carat ayquey wácati bahnác yajcaro. Cacmín eyta bin patronat bahnác obir yajquín acu cac bahcaro. Cac bahcayat cacúm eyat cacmín cahujín quin ira wícaro. Ira wiquic cuitar cab cucayat, cacmín cahujín ac ira tahw̃uro. ");
INSERT INTO tuf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eyta cac bahr cutar patrón cajc istiy bijacro. Itchareht sicor wijacro. Sicor wiquír ítitan, cacúm eyat bi yajcata wac bahjáctara ay yajcáy raújactara eywan ayro. Cacúm ey ohbac ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aját bah quin wacaro. Cacúm eyra patronat cacmín cara cuít yehn áyayqueyra. Icuran biyan bahnacan cacúm ey at icar wícaro. Obir yajquín acu wícaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Eyta cuar cacmá ay bár bínatra uchta séhw̃aro: “As cara in wícajar bijacro,” séhw̃aro. Eyta séhw̃ayeyra cacmín ruhw̃áy yehnata óraro. Bucata óraro. Imara iran bacuan báchuti, atuc sínata óraro. Simat yehw̃quin owár atuc sínata óraro. ");
INSERT INTO tuf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Patrón in wícajar séhw̃ayat icar wicata óraro. Bow̃ behti cuácayat wicátaro. Wiquír ítitan, cacúm ay bár yajcaro. Eyta yajquíc ques abáy bucáyqueyra. Chihtá yajti bin owár cuécwayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Biyat patrón chihtá it cuar cati yajcayat eyan cuít bucáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eyta cuar biyat patrón chihtá istiti rabar chihtá yajti jácayat, eyra táhnaqui buca báreyra. Eytaan wan biyin quin chihtán to ehcwáyatan, éyinatan chihtá to yajcátaro. Chihtá to rahcuír yájtieyra táyaran to yajcaro. Eyta cat biyin quin chihtán to ehcwáyatan, éyinat cuít yajcátaro. Eytair báreyra Síratan eyin quin táyaran cuít chiáyqueyra. Cuít cuécwayqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Etar cat wajacro: —Asan cajc cut rajacro. Oca cut wahnáy rajacro. Ahra oca bar ánjaquir waquít, eywan ay chácataro. ");
INSERT INTO tuf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Eyta bira uwat as yauwátaro. As ruhw̃átaro. Eyta bijira as eyta yauwin cab cuwín cahmar ita rabar cue rehcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Etar baat ítitan: ¿asan cajc cutar uw tan wan chacay rajác síhw̃aqui? Aját ba quin wacaro. Aját uw tan wan chácayi rátiro. Aját uw cahujín rahra rahra wahw̃ayta acu rajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ah yahncút cat uwat imár usi itquin rahra rahra wahw̃áyqueyra. Cuisa bay binan cuisa bucáy bin owár técuayqueyra. Cuisa bucáy binan cuisa bay bin owar técuayqueyra. -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uchta jaw̃ técuayqueyra. Tetinán waquíj joran rahra rahra técuayqueyra. Abín cat ima wiw̃arac waquíj jor rahra rahra técuayqueyra. Im isó jor cat rahra rahra técuayqueyra. Cahujín as chiwa chajac ques eyta técuayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesusat uw quin uch cat wajacro: —Baat cajc uch cutar rahs rauwic cuitar bowarám istír, “Riwa racata bínitro,” wacaro. Aját ráhcuitan, uní wacaro. Riwa racátaro. ");
INSERT INTO tuf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Etar cat séroan istiy wihár bin cacayat, “Ribrán abáy chácata bínitro,” wacaro. Etar ribrán uní eyta chácaro. ");
INSERT INTO tuf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bowarám yehnyat, sero yehnyat, bitara chácatatara baatán itro. Eyta bira ba urá bucayro. Eyta rehcata eyan it cuar, ah uch uwat as rehrát áyjactar baat istítiro. Aját yajquíc ey ub cut istíc cuar, Sirat as ayjac síhw̃atiro, wajacro, Jesusat ricá quin. ");
INSERT INTO tuf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Acsar Jesusat wajacro: —Behmarat ay waan acu bitara yajcátatar ey síhw̃awi. ¿Bitara reht eyta síhw̃atiqui? ");
INSERT INTO tuf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uwat ba cahmí icar werjayín cac cahmar tew̃ay beyata óraro. Eyta beya rabar werjayín quin cuti echí cuar uw ey quin tayar tunwi. Eytair báreyra, werjayín at icar ba wícataro. Etat werjayinát ba cárcel cayíb at icar wícataro. Eyta wiquir, cárcel cayibat ba cárcel icar tunátaro. ");
INSERT INTO tuf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eyta túnyeyra aját ba quin wacaro. Baat táyari bahnác túntieyra ba úcajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Etat uw Jesús quin behjecro. Behquír, Jesús quin Galilea uw ojcor ehcujacro. Uchta wajacro: —Galiléainat Sir wiquin ruwa tiw̃ay yinjacro. Eyta tiw̃yat icar Pilátoat Galilea uw eyin im ey awat cutar tiw̃ áyjacro. Im ey awat cutar tiw̃yat, Galiléain aban ruwa ab ey istán rihnojocro, wajacro, uwat Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eyta wacayat, Jesusat wajacro: —Eyta sácajac cuar, baat cuayin uritra síhw̃ati jaw̃i. “Galiléain éyinatra Sir tayar Galiléain cahujinat cuít yajác,” síhw̃ati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aját ba quin wacaro. Ba ur ay bár ey tehmowi. Urán ay jaw̃i. Eytair báreyra, ba cat eyta sácataro, -wajacro, uw quin-. ");
INSERT INTO tuf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uch cat síhw̃awi, -wajacro-. Serin cuisa dieciocho bin arcutar ubach quehrjacro. Jerusalén pueblo cuitar Siloé cuitar ubach cuacúr cuacúr tuw̃jáquinro. Cuacúr cuacúr tuw̃jaquey uw arcutar quehrjacro. Quehryat, serin cuisa dieciocho bin bar sácajacro, -wajacro-. Eyta cuara baat cuayin uritra síhw̃ati jaw̃i. “Ubach cahm sácajac éyinan ur ay baran Jerusalén cahujín cuitra,” síhw̃ati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cuatán aját ba quin wacaro. Ba ur ay bár ey tehmowi. Urá ay waawi. Eytair báreyra, ba cat eyta sácataro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Acsar Jesusat uw siw̃in ac uch ehcujacro. Uchta wajacro: —Ser istiyát ima tihw̃ cut higuera caruc rijacro. Etar ítchareht chájareht higuera ub chájactara itay rajacro. Wiquír itit, ub batro. ");
INSERT INTO tuf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eyta cuácayat, cacúm quin wajacro: “Ahra asan bara istiy, bara istiy, bara bay tas higuera ub buwin wijacro. Eyta cuar ub úbisti chátiro,” wajacro. “Ub chati cuat ey cajc cutar acsar báhjatro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eyta wacayat, cacmát patrón quin wajacro: “Recan inic cham bahwi. Bara istiy ac cham bahwi,” wajacro. “Eyta bahcayat, aját tihw̃ ey ohnro. Ohr catrun ica uhmonro. Uhmor cuitatrun rurúm cháquinro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Eta jaw̃ óroyatan bar ub chácata óraro. Oro chaquit cat bara istiy ub chati cuat cay tac aywi,” wajacro, cacmata patrón quino. Jesusat uw quin eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tan jaquin ricar cuanyat Jesusat secuac usar síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Siw̃a rabar itit, secuac usar chauwíc yarquin cat ésatro. Chauwíc eyan cuicát bara dieciocho acat ruhw̃ becaro. Cuicát chauwíc ey ícara yar chájacro. Eyta chácayat, ey icar ey cuhru bijacro. Icar ey bahnác cuhruyat, tuní cui ay yéhnajatro. ");
INSERT INTO tuf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesusat siw̃a rabar ey yarquey itchacro. Istír wajacro: —Chaucu. Ahra cuicát bah acsar rúhw̃ajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Eyta waquír, ima atcar chauwíc icar cuitar chájacro. Eyta chácayat, in bar tan jájacro. Etar tuni cui ten bar órojocro. Eyta tan jaquir, chaucat wajacro: “Siru, bahatan as orac chájacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eyta cuar secuac usar cara túrjacro. Canar yajti ricar Jesusat yarquey tan jácayat ques túrjacro. Eyta turir uw quin wajacro: —Semán icar canar yajcata binan riya térayro. Ey rícatrun uw tan jacay row̃i. Canar yajti rícatra uw tan jacay roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eyta wacayat, Jesusat ey quin wajacro: —Ba urá bucayro. Canar yati rícatrun ba istiyát cat, istiyát cat vaca ricuár rih wicay bécaro. Asanica ricuár cat rih yahay bécaro. ");
INSERT INTO tuf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eyta cat chauwíc ey cat Sisramat ey icar questajacro. Abraham bomcaran eyta questajacro. Etar cat vaca rih wiquin ac ricuár eyta chauwíc Sisramat questajaquey cat eyta ricuata binro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesusat eyta wacayat, Jesús quehsuquin uw ubot cuayir waajacro. Cuatán cahujinra ahní rehjecro. Jesusat ay yajquíc rehquít, ahní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesusat bucoy wajacro: —Sir cara rehquey bitáratara aját ey ehcunro. Icuran wántara, aját ey siw̃in acu icúr bi ojcor ehcunro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sir cara rehquey mostaza caruc cucuán wanro. Mostaza cucuán conu quenro. Ser istiyát mostaza cucú eyan tihw̃ cuit rijacro. Ricayat yehnár cunjacro. Cunyat éctari ruwat ey cuicar taha cut chicha tuw̃ro. Sir cara rehquey cat ey cucuán wanro. Mostaza cucuán conu bi cuar yehnár cuít cunír eyta Sir cara rehquey cutar récaji uw conu cuar ítchareht éytaan wan ricán cuít rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bucoy Jesusat Sir cara rehquey ojcor wajacro: —Sir cara rehquey uchan wanro. ");
INSERT INTO tuf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Buc réhquiban wanro. Chauc istiyát eb tajcro. Tajquír sar buc rehquib conu chácaro. Chaquir rihnoro. Rihnoyat eb bahnác buc rehcaro. Sir cara rehquey cat buc réhquiban wanro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Etar Jesús acsar bijacro. Pueblo istiy tiw̃, pueblo istiy tiw̃ Jerusalén cuwín bijacro. Pueblo istiy cuitar, pueblo istiy cuitar uw siw̃ot bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bicayat istiyát Jesús quin táyojocro: —Caru, ¿Sir quin beyáyquinan uw cuisa bítaqui? ¿Biráy báriqui? táyojocro. Etat Jesusat wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Querat conu bin sicar rauwin acu yají raúwataro. Eytaan wan Sir quin rauwin acu yají raúwataro, -wajacro-. Aját ba quin wacaro. Uw ricán síhw̃anar binan rauwa racar rehcátaro. Eyta cuar raúwajar rehcátaro. Etar ba rauwin acu yají jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Riy istiy Sir quin rauwic querat cay tunátaro. Eyta cay tunyat, baan querat acor rauti watar jácayqueyra. “Caru, querat ey waawi,” wacáyqueyra. Eyta cuar, Sirat ba quin wacáyqueyra: “Ba biscán úwtara aját ba istítiro.” ");
INSERT INTO tuf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eyta wacayat baat wacáyqueyra: “Isat bah jor ira yájaquinro. Bacú yahjác biro. Is ibit cutar, is awat cutar bahat uw síw̃jaquinro,” wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eyta cuar Sirat wacáyqueyra: “Aját ba quin wacaro. Ba biscán bíntara istítiro. Ay bár binu, querat acor chati quir béowi,” wacáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ba Sir cac cahmar bin uc tijcáyqueyra. Ba uc tijcayat icar baat Abrahamin, Isaaquin, Jacobin, Sir ehcuquin éyinan istáyqueyra. Sir owár itic istáyqueyra. Eyta istír abáy óyqueyra. Ruhra cuech cuech cóhyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Uw rahs raquíc wihár bin, rahs rauwic wihár bin, rahr owár wistúr wihár bin, rahr owár isur wihár bin behcáyqueyra. Behquír Sir cara rehquey cutar ira yayáyqueyra, -wajacro-. Sir owár yáhayqueyra. Eyta cuar bara esar bin uc tijcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Uch síhw̃awi. Ah uch carin réhqueyin ey cab cuácayat, chiwa rehcáyqueyra. Cuatán ah uch chiwa réhqueyin ey cab cucayat, carin rehcáyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesusat eyta wacayat, fariséoin behquír Jesús quin wajacro: —Rey cara Heródesat bah yau cun rehcaro. Eyta bira usar ítiti jaw̃i. Cajc istiy biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Etat Jesusat wajacro: —Heródesat uw cayar yajquín to séhw̃aro. Eyta cuar Herodes quin uchta wacay béowi. Ah cat, cuanmít cat aját yarquin tan jáquinro. Cuicá uw urá sar bin uc áyinro. Etar bot aját yajcata ey yajc bahninro, waw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eyta cuar ah cat, cuanmít cat, bot cat as acsar Jerusalén benro. Sir chihtá ehcúquiban Jerusalén cuitar chinátaro. Cajc istiyrá chínajatro, waw̃i, Herodes quin. ");
INSERT INTO tuf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Eyta waquír Jesusat acsar wajacro: —Jerusaléninu, Jerusaléninu, asan ba rácaran cue rehcaro. Baatán Sir chihtá ehcuquin búcoyan, búcoyan, istiy cat, istiy cat tiw̃ro. Chihtá ehcuquin Sirat ba quin ayat, baat eyin ac cut tiw̃ro, -wajacro-. Jerusaléninu, aját baan rácatro. Sisbúr ahná abinát ima sasá ectar cahmar secuac eyta aját cat ba eyta secua racar rehjecro. Aját bucoy bucoy ba eyta secua racar rehjecro. Eyta cuar baatán as chihtá cátiro. Etar asan ba racar cue rehcaro. ");
INSERT INTO tuf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Eyta cuácayat Síratan ba uwra ajcá bár etí ten yajcaro. Aját ba quin wacaro. Baat as bucoy istá báreyra. Sir chihtá racar rehc ocso tas baatán as istá báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Canar yajti ricar Jesusan fariseo carin usi yayay bijacro. Jesús erar yayay cucayat, fariseo cahujinat ey úrojocro. Bitara yajcátatara ey úrojocro. ");
INSERT INTO tuf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesús erar cur itit, uw yarquin ésatro. Ojc cunirat yárquinro. ");
INSERT INTO tuf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eyta istír Jesusat bachan chihtán siw̃quin quin, fariséoin quin wajacro: —Ba quin táyoro. Bachan chihtán chac bahjác cutar baat ítitan, canar yajti ricar ¿yarquey tan jácataica? ¿Tan jácajarica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eyta táyoyat eyin ajc sarac chájacro. Etat Jesusat yarquey at cut cator tan jájacro. Tan jaquir car sicor áyjacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Etar bachan chihtán siw̃quin quin, fariséoin quin wajacro: —Ba asaníctara, vácatara iscán ocso tijcayat, baat sicor in bar ucátaro. Canar yajti ricar cuaníc tacat in bar ucátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eyta wacayat, eyin ajc sácajacro. Icrí wácajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesusat fariseo carin usi ira yayay bir chihra rabar uw wahitchacro. Ititan, istiyát cat, istiyát cat báncoan ayan cuít bin cutar chihrín cájacro. Imár chihtá cuitar eyta cájacro. Jesusat eyta istír eyin siw̃in acu uch ehcujacro: ");
INSERT INTO tuf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Uwat fiesta cuitar ba yayín chícayat, banco ay bin carin ac chajac ey ojcor chihrti jaw̃i, -wajacro-. Banco ay bi eyan cahujín acu chajac óraro. ");
INSERT INTO tuf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ba ey ojcor ítyeyra fiesta cara wiquír ba sicor yehn áyata óraro. “Banco eyra récaji uy quin cham wiw̃i,” wacata óraro. Eyta wacayat, ba banco ayan etach bár bi cuitar ítataro. Etat ba uw cac cahmar cuayir waátaro. ");
INSERT INTO tuf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cuatán ba fiesta cuitar yayín chícayat, banco chiwa ac chajac ey caquir cuitar chihrwi, -wajacro-. Eyta cuácayat fiesta carat ba quin wacata óraro: “Ay bár bi cuitatra ítiti jaw̃i. Banco ay bi carin ac chajac ey cuitar ítuwi,” wacata óraro. Eyta wacayat, uwat ba ojcor síhw̃ataro: “Eyan cáraro,” síhw̃ataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bíyinat imár ojcor “asan caran toro,” síhw̃ayat Sirat eyta síhw̃aqueyin cuayan wan chácayqueyra. Eyta cuar bíyinat imár ojcor “asan chíwaro,” síhw̃ayat, Sirat eyta síhw̃aqueyin cárinan cuít chácayqueyra, wajacro, Jesusat im owár yaquin quin. ");
INSERT INTO tuf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eyta waquír fiesta yajquíc cara quin wajacro: —Bahat fiesta yajcayat, ba íw̃oquinat yayín acu chiti jaw̃i, -wajacro-. Rabin cat chiti jaw̃i. Cayin cat chiti jaw̃i, -wajacro-. Intac oya ji bin cat chiti jaw̃i. Eyin chíyeyra éyinat rahra bah cat yayín chiátaro. Eta jaw̃ bah ac sicor túnataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cuatán bahat fiesta yajcayat, bahat oya bár binat, ray bár binat yayín chiwi, -wajacro-. Ub bár bin cat chiwi. Cuercúrinat cat, chohcuinát cat yayín chiwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eyinatra bah sicor imár owár yayín acu chíajatro. Sícotra túnajatro. Túnajar rehquít, cabar tinyat, Sirat sicor bah ac túnayqueyra. Ur ay bin sácajaquin sicor yinyat, Sirat sicor bah ac bar túnayqueyra, wajacro. Fiesta yajquíc cara quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesusat eyta tew̃íc rahcuír, uw istiy eyin owár yáquinat wajacro: —Bíyatan Sir cara rehquey cuitar ira yácayat, eyan ahnian cuít rehcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Etat Jesusat ey quin wajacro: —Sera istiyát fiesta yajquín sehw̃ar, iran ruwan cuít sécuajacro. Owár yayín ac ricán to récaji chíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Etat fiesta chaquic cab cuanyat, ima cacmá bucoy áyjacro. Biyin récaji chíjactar eyin quin “in row̃i,” wac áyjacro. Ayat cacúm bijacro. Bir car wajacro: “Ahran in row̃i. Yayay row̃i. Fiesta cuitar yayín acu bahnác bar órojocro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Etar eyta chícayat, istiyát, istiyát icuratan béyajartar ehcwáy yinjacro. Istiyát wajacro: “Ajáy cajc bar wahjacro. As cajc wáhjaquey wahitay bétaro. Fiesta cuitar biti ac ajc waawi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Istiyát wajacro: “Aját vaca cuisa ucasi bar wáhjacro. Aját vaca ey wahitátaro. Fiesta cuitar biti ac ajc waawa,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Istiyát wajacro: “As wiya bar yehw̃jacro. Asa bitách béjetro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Etat cacmát ima cara quin ey chihtá wacay bijacro. Cara quin ehcwayat, bar túrjacro. Turir cacúm bucoy áyjacro, uw cahujín chiayta acu. Cacúm quin uchta wajacro: “Pueblo ibit cuitar in wahitay biwi. Oya bár bin cat, ray bár bin cat, ub bár eyin cat, cuercurin cat, chohcuín cat ucay biwi,” wajacro, carat. ");
INSERT INTO tuf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Etar awan cacúm wiquír wajacro: “Caru, aját bah chihtá bar yajacro. Aját eyin bar sécuajacro. Cuat úsaran echí raúwataro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Etat carat wajacro: “Etar ácubar ibt aw̃at uw ucay biwi. As usar bahnác cay sécuawi. Cahujín raúwajar acat sécuawi. ");
INSERT INTO tuf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eyta cuar récaram uw chíjaqueyinat as ira cónui yáyajatro,” wajacro, carat. Jesusat eyta ehcujacro. Fariseo carin usi yayín ac sécuajaquin quin eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesusat uw ricán séhw̃anar bin siw̃yat, uw eyin cat Jesusin questoc béjecro. Eyta bécayat Jesusat eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Bíyinan asi jor bicáyatan, bíyinan as chiwa cha cun rehcáyatan, éyinatan asan sehnác cuít rehcátaro. Eyinatan as sehnacan tetín, abín, rabin, sasá, wiyin sehnác cuít rehcátaro. As sehnacan ima sehnác cuít rehcátaro. Eytair báreyra, as chiwa waájatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bíyinan as chiwa cháctara éyinan as ques icar uwat yauwata óraro. Biyin as ques icar eyta yauwata reht as ajcá bár yehw̃ téyeyra, éyinra as chíwai chácajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Uch síhw̃awi. Uwat ubach cumac bi tuw̃ín séhw̃ayatan, récaji ey tamo yají séhw̃aro, -wajacro-. Rayan bita ahwátatara ey tamo séhw̃aro. Ray bita bin ahwata eyan bar tihrátatara, tíhrajartara récajian ey tamo yají séhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eytair báreyra, séhw̃atieyra awat oror car, teb ocuár car bahnác tuw̃ tíhrajar óraro, -wajacro-. Eyta yájcyeyra cahujinat eyta istír ey buror sisátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Sisír wacátaro: “Uyat ubach tuw̃áy yehníc cuar tuw̃ tíhrajatro,” wacátaro. ");
INSERT INTO tuf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Uch cat síhw̃awi. Rey caran istiy owár tec quej yinro. Imayan soldádoan diez milro. Etar istiy éyayra viente mil cuaquir tec quej rocaro. Etar rey car soldado diez mil eyat síhw̃ataro. Istiyáy eyat imáy soldádoin burbar yajcátatara, yájcajartara, séhw̃ataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Etar imáy soldádoin burbar yajcata sehw̃ar, istiy quino chihtá áyataro. Ahajira birá cuít rocayat, eyin quin chihtá áyataro. Eyin owár tec quejti tenan acu chihtá áyataro. Tec quejti acu bita túnatatara ey tayoy áyataro, -wajacro, ricá quin-. ");
INSERT INTO tuf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Etar cat baat as chiwa chaquin acu behmaray icuran biyan bahnác etátaro. Eyta etítieyra ba as chíwara waájatro, wajacro, Jesusat ricá quino. ");
INSERT INTO tuf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesusat acsar wajacro: —Rauwan ehchiro. Eyta cuar rauw bahsí bár rehcáyatra, sicor bahsí wan acu icurí yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Icúr acui batro. Rurúm ohnot ica sar chaquir eyta eyta chaquin acu cat ay batro. Eyta bira tiw̃ técaro. Rehrinán cucáj jítara ey rahcwi. Sirat ba éytaan wan teti acu rahcwi, wajacro, Jesusat uw quin. ");
INSERT INTO tuf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesusat uw siw̃yat, uw urá ay bár binat eyat siw̃quey rahcuay béhjecro. Gobierno tayar chíquinat cat rahcuay béhjecro. ");
INSERT INTO tuf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ay bár binat cat rahcuay béhcayat, fariséoinan Jesús ac túrjacro. Bachan chihtán siw̃quin cat túrjacro. Turir wajacro: “Uyat urá ay bár bin quin ténaro. Urá ay bár bin owár ira yácaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eyta tew̃yat Jesusat siw̃in ac fariséoin quin, bachan chihtán siw̃quin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Uw síhw̃awi. Ba tac icar istiyán obas cuisan cien che óraro. Etar riy istiy obas úbisti bar íuwata óraro. Eyta íuyeyra, obas íujaquey uroy bicaro. Cuatán obas cahujinra ácubar cuitar cham bahcaro. Eyin cham bahr obas íuyey obas istíc ocso tas úroro. ");
INSERT INTO tuf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Istír car cuitoc cuit yehw̃ rocaro. Ahní rocaro. ");
INSERT INTO tuf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Roquír car sicor usi cur, íw̃oquin sécuaro. Intac ítquinan bahnác sécuaro. Secuar eyin quin wacaro: “Asi jor ahní rehw̃i. Asan obas íujaquey sicor bar itchacro. Etar as owaran ahní rehw̃i,” wacaro, obas cayibat. ");
INSERT INTO tuf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Acsar Jesusat wajacro: —Aját ba quin wacaro. Obas itcháqueyan wan uw urá ay bár bin úbistiyat urá tehmoyat, ay bár yajquíc etyat, Sir cuacúr cacmín ahnian cuít rehcaro. Eyta cuar ur ay binat acsar im eyta ay yajquíc reht ahnian etach cutiro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Uch cat síhw̃awi. Wiw̃ istiyayan ray escuran ucasi che óraro. Etat riy istiy ray ucasi che bi sicar úbistira bar iu teta óraro. Iu téyeyra rurumán bahnác cocaro. Vela cat anro. Etatrun ray íujaquey bar uroy yehnro. Uror esar bar itro. ");
INSERT INTO tuf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Istír cat ima íw̃oquin, ima cayin secuan chícaro. Sécuayat eyin quin wacaro: “As ray íujaquey sicor bar itchacro,” wacaro. “Eyta bira asi jor ahní rehw̃i,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ray itcháqueyan wan ur ay bár bin ey urá tehmóyatan, Sir cacminán ahnian cuitro. Ray iu téjequey istír ahní rehquír eyta Sir cacmín cat ahnian eyta rehcaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Etat Jesusat uchta cat wajacro: —Ser istiyayan wacján cuisa bucayro. Serin sasá bucayro. ");
INSERT INTO tuf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Waquíj yahncút bíjiyat tet quino wajacro: “Tetú, bah chinyat, cajc cat, ira cat, oya cat, ray cat as wic báhtaro. Cuatán ah récaji asan ey rácatro. Eyta bira áhaji as quin wiw̃i. Cajc cat, ira cat, oya cat, ray cat as quin wiw̃i,” wajacro. ’Wacját eyta wacayat, tetát eyta wíjacro. Tetát cajc cat, ira cat, oya cat, ray cat wacj ey quin wahw̃úr wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eyta wahw̃úr wícayat biráy bár cuácayat, waquíj yahncút eyat cajc rajacro. Tetát wíjaquey bahnác rajacro. Rar cuitar, oya cat, ray cat sécuajacro. Eyta secuar car cajc istiy yehnár bijacro. ’Cajc istiy bir car erar urá séhw̃ati wiw̃ín ur ay bár bin owár ur ay bár ítchacro. Eyin owár ita rabar raya bahnác ahu téjecro. Oya bár, ray bár jájacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","’Bahnác ahuwír car ítchareht yájcajareht, ey cajc cutar ira yehnti rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ira yehnti cuácayat wacj eyan yayan abáy rehjecro. Eyta cuácayat canar wahitchacro, ey cajc cútara. Etar canár itchacro. Patron itchacro. Ityat, patronat tusín obir yajquíc canar yajcáy áyjacro. Tusín ira wicay áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tusín ira wica rabar yayan to cuácayat, imát cat yaya racar rehjecro. Eyta cuar rehratí wítiro. ");
INSERT INTO tuf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ira witi cuácayat, sicor urá séhw̃ajacro: “As tet cacminán iran toro. Ira cájcara catum chero. Cuatán asra usár cuácayat, yayat bar yarátaro. ");
INSERT INTO tuf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eyta cuácayat, as tet quin benro,” séhw̃ajacro. Eyta sehw̃ar car ucha cat séhw̃ajacro: “Erar cur car, aját waquinro: ‘Tetú, aját ur ay bár yajacro. Aját Sir tayar cat, bah tayar cat yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aját eyta yajác etar bah ácuan cahujinan wanro. Behmá waquíj bár binan wanro. Eyta cuácayat, acsar asan ba waquíj bár binan wan caw̃i. Canar yajquín acu caw̃i,’ ” waquín séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eyta sehw̃ar car, sicor ima tet quin usi bijacro. Usi racayat tetát birá cut cuar bar itchacro. Wacj ey istír, tetát séhw̃ajacro: “Eyan as wacján sehnác eyro,” séhw̃ajacro. Eyta sehw̃ar ey acam quinjacro. Quinír car, wacjí cuic cut questa cájacro. Questár suhwujacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tetát suhwyat, wacját tet quin wajacro: “Tetú, aját Sir tayar cat, bah tayar cat yajacro,” wajacro. “Asa bah ácuan cahujinan wanro. Asan bah waquíj bár binan wanro,” wajacro, wacját tet ima quino. ");
INSERT INTO tuf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Eyta wacayat tetát cacmín quin wajacro: “Siricáj ayan cuít bi in row̃i. Roquír car as wacjí wiw̃i, im ow̃in acu. At ub icar anillo cat chaw̃i. Quescar icar ques barcát cat chaw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Vaca saha row̃i. Vaca saha sibarán to bi row̃i. Roquír yauwi. Isan ahní jácataro. Fiesta chácataro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Cuatán as wacján yarjáquinir cuar yártiro. Estajiro. As wacján íujaquinir cuar sicor bar wijacro.” Tetát eyta wajacro. ’Etatan bahnáquinan ahní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Uwa ahní rehcáyatan, waquíj quesmát chi cut bijáquinan sicor usi rajacro. Racayat watar wiquír rahcuít, uwat ahní tacaro. Uw ahní quinro. ");
INSERT INTO tuf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Etat eyta rahcuír cacúm istiy chíjacro. Chiír táyojocro: “¿Icurat tay ocuajaqui? ¿Bitara etar quináy ocuajaqui?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","’Etat cacmát wajacro: “Bah tanán sicor bar wijacro. Chinti wijacro. Eyta bira bah tetán ahniro. Ahní cuácayat vaca saha sibarán to bi bar yaujacro. Owár cohn yaujacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Etat waquíj quesmát ey bar túrjacro. Turir, watar ítchacro. Eyta cuácayat tet watar waajacro. Waar waquíj quesmát ey quin “Turti cuar usi raúwataro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tetát eyta wacayat, wacját wajacro: “Tetú, ajatán bara istiy, bara istiy bah ac canar ruojocro. Ajatán bah chihtá ruhw̃uti yajacro. Ajatrá wácati yajacro,” wajacro. “Eyta cuar bahat as acura cabra sáhai wítiro. As íw̃oquin owár yayini wítiro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“Cuatán behmá waquíj yahncút ey wicayat, bahat vaca sah sibarán to bi yaujacro. Wijáqueyat behmá oyan rayan bahnác ahu téjecro. Wiw̃ín isáribin owár besir cama rabar bahnác ahu téjecro,” wajacro. “Eyta cuar bahat ey acura vaca sah sibarán to bi yaujacro. Owár cohn ac yaujacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Etat tetát wajacro: “Wacjú, bahra ajmár jor úsatro. Bir cut bitiro,” wajacro. “Bahatra as báhtiro. Etar cat ajáy eyan bahnacan behmayro. ");
INSERT INTO tuf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cuatán bah tanarun yarjáquinir eyta chajac cuar yártiro. Iujaquin cuar sicor bar itchacro. Eyta bira ahní tátaro. Ahní quinátaro. Ahní rehcátaro,” wajacro, tetát waquíj quesmát bi quin. Fariséoin quin, bachan chihtán siw̃quin quin Jesusat eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Acsar Jesusat ima chiwa quin wajacro: —Cacmá istiy ojcor ehcunro. Patronat imayan icuran, biyan ima cacúm cara ey at icar bahnác chájacro. Cacúm eyat obir yajcayta acu chájacro. Cuatán riy istiy cahujinat cacúm ey cahmí icar tew̃jacro. Patrón quin wajacro: “Ray cat, cajc cat, oya cat bahnác eyat ria bár ahuro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Etar patronat cacúm cara chíjacro. Chiír car wicayat, ey quin wajacro: “Aját ráhcuitan, bahat ajáy eyan bahnác ria bár ahuro. ¿Eyta téw̃queyan uní waquí?” táyojocro. “Ajayan icuran biyan bahnác saw̃uwi. Saw̃úr cuihsuwi. Etar cat bahat as ray bahnác icúr bi icar ahujactar carit cutar cuihsuwi. Cuihsúr as quin wiw̃i,” wajacro. “Bahat as ac canar eyta yajacan acsar yájcajatro. Aját bah uc tenro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Etat chiwat séhw̃ajacro: “¿Aját icúr yajquinca? Patronat as bar uc técaro,” séhw̃ajacro. “Asan chihchír batro. Chi bitách cáajatro. Tihw̃á cat bitách ójotro. Ibt aw̃at oya bár binat ray chiir eyta ajatrá éytara chi cun batro. Eyta chiín acu as ehúr wíniro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Eyta sehw̃ar, “Aját uw uchta íw̃onro, as cuaya rehti acu,” séhw̃ajacro. “As acu ira cat, ubach cat wícayta acu uw íw̃onro,” séhw̃ajacro. “Eyta íw̃oyat patronat as uc técayat, éyinat ira cat, ubach cat as wícataro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eyta sehw̃ar catrun, patrón quin tayar yajáqueyin iw̃on acu chíjacro. Istiy cat, istiy cat iw̃on acu chíjacro. Chícayatrun ey quin béhjecro. Béhcayat wajacro: “¿Patrón tayar baatán bítaca?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Istiyát wajacro: “Aját táyaran timá mil galonesro,” wajacro. Etat cacumát wajacro: “Ihyú, tayar túnata cuihsujacan usatro. Mil galones túnata cuihsujáqueyan, sicor cahujéy tijcanro. Eyta túnata cuihsujaquey tehmowi. Etar sicor ahra quinientos galones etac túnata cuihsuwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Etar istiy quin wajacro: “¿Bahat táyaran bítaca?” wajacro. Etar uw eyat wajacro: “Aját ritután cargan doscientos túnataro,” wajacro. Etat cacumát wajacro: “Ihyú. Bah tayar cuihsujacan usatro. Docientos túnata cuihsujacan sicor cahujéy tijcanro. Eyta túnata cuihsujaquey tehmowi. Etar sicor ‘ciento cincuenta’ etac túnata cuihsuwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cacúm eyta yajác ey patronat itchacro. Istír ey quin wajacro: “Bahat as cayar yajquíc to sínjacro, cahujinat bah ajcá ji beyayta acu,” wajacro, patronat. Eytaan wan Sir chiwa bár éyinat uw cayar yajquíc to sínjacro. Cuatán Sir chiwan éytara síntiro, wajacro, Jesusat ima chiwa quino. ");
INSERT INTO tuf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Acsar Jesusat wajacro: —Aját ba quin wacaro. Ray es yajti jaw̃i. Cuatán cahujín ba obir yajcayta acu ray ahuwi. Cajc uch cut rayan, oyan cahujín obir yajquín acu ahuwi. Eyta ahúyatan, uw íw̃otaro. Eyta íw̃oyatan ba rayan oyan bahnác bahnyat, uw íw̃ojoquinat bah cuitar wacáyqueyra. Yaryat, cuacúr Sir owár itay bicayat, éyinat bah cuitar Sir ub cahmor wacáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Biyat chihtá conu bi wácati yajcáyatan, eyat cuít bi cat wácati yajcátaro. Cuatán biyat chihtá conu bi yájtieyra éyatan chihtá cuít bi cat yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Etan baat cajc uch cutar bin oyan rayan ay ahuti cuat Sirat cuacúr eywat bitách wícajatro. ");
INSERT INTO tuf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Baat cahujinay icuran biyan obir yájtieyra behmaray chácayta acu rehrati wica báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Uw patrón bucáy bin acu cacúm bitách chácajatro. Eyta chácyera patrón istiyrá cacmát sehnác chácataro. Eyta cuar, patrón istiyrá quehswátaro. Patrón sehnaquey ajcá ji béyataro. Eyta cuaquir patrón quehsuquey ajcá ji béyajatro. Eytaan wan ray behmáy secua racar isó rabar Sir chiwa bitách chácajatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eyta wacayat, Fariséoinat Jesús buror sischacro. Eyinan ray rácaran cuít reht, ey buror sischacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eyta sisyat Jesusat wajacro: —Baan uw cac cahmar urán ay waa rácatro. Cahujinat ba tamo ay síhw̃ayta acu baat bahnác yajcaro. Eyta cuar Sir imát ba urán itro. Uwat sihw̃at, icuran biyan ay síhw̃actara, Sirat ey ojcor eyta síhw̃atiro. Sirat eyra quehsuro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Récaram bachan chihtán wac báhjacro. Chihtá ehcúquibat wajác cat cuihsú báhjacro. Baatán ey chihtá yajcayta acu cuihsú báhjacro. Juan yehníc ocso tas bachan chihtán eyta ehcujacro, uwat eyta yajcayta acu. Cuat Juan yehníc yahncutra Sir cara rehquey chihtá ehcuro, uwat yajcayta acu. Ehcwayat bahnáquinat Sir cara rehquey cutar ita racar isoro. ");
INSERT INTO tuf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Eyta cuar Sir bachan chihtán tehmó báreyra. Uchicria Sir chihtá eyra bahná báreyra. Cajc cat, ica cat, abá cat sicor bár jácataro. Eyta cuar Sir bachan chihtán wac báhcyeyra bahná báreyra. Ajca istanác bahná báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Etat Jesusat uchta cat wajacro: —Biyat ima wiya cahmor ey yehw̃ ter car, bucoy istiy owár yehw̃yat, éyatan wiw̃á bes yajcaro. Sir ub cahmor wiw̃á bes yajcaro. Eyta catum biyat yehw̃ téjequey owár yehw̃yat, eyat cat Sir ub cahmora bes yajcaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesusat uchta cat ehcujacro: —Sera istiyán oyin ráyincuano. Eyat oya buw bin cat, cuas bin cat ow̃jacro. Ay bin ajcan to bin ow̃jacro. Ira cat, ruwa cat ay yájacro. Ay cohjocro. ");
INSERT INTO tuf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ser istiy eyra oya bár bin, ray bár binro. Oya bár bin ajcan Lázarocuano. Lázaro sibarán bahnác ruhsucuán abayro. Lázaro eyra oyin querat acor ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oyinat ira coh rabar cac bur ahujacro. Lázaro eyta ahujaquey coh racar rehquít erar ítchacro. Erar ityat, báyarat Lázaro ruhsúc ténjacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Itchareht Lázaro bar yarjacro. Etar Sir cuacúr cacminát ey yehw̃ béjecro. Abrahamin sácajaquin owár ítayta acu yehw̃ béjecro. Ey yahncút oyin cat bar yarjacro. Yaryat cat chein bar ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Etat chein ajc cab oc icar áyjacro. Eyta ayat yaran abáy wahnjacro. Eyta wahnyat oyin yarjáqueyat bira cuít itit, Abraham cat, Lázaro cat buca owár itro. ");
INSERT INTO tuf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eyta istír car Abraham cut cohwjacro: “Cohtú, as cuitar waw̃i. Abrahamu, as racar cue rehw̃i,” wajacro. “Lázaro as quin aywi. Ey at ub ubar cut rih cut siw̃ír cuar aywi. Rih cut as cuw sewin ac aywi. Ocat as abáy wahnro,” wajacro, Abraham quin oyin yarjáqueyat. ");
INSERT INTO tuf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Etat Abrahamat wajacro: “Wihnú, uch séhw̃awi. Bah anto yarti cuácayat, bah quin iran oyan to wíjacro. Cuat Lázaro icúr bár cuar ítchacro. Yaran abáy cuájacro. Cuat ahra eyra ay itro. Cuat bahra abáy wahnro. Abáy cuácaro. Eyta séhw̃awi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Etar cat is tasar siyoá usonro. Bitách waájatro,” wajacro. “Siyo ey ráhrayan waati ac waquír chájacro. Uch wihár biji ráhrayra bitách waájatro. Bah wihár bin cat, uch wihár bitách waájatro,” wajacro, Abrahamat. ");
INSERT INTO tuf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Etat oyin yarjáqueyat wajacro: “Eyta cuácayat, cohtú, as bah ojcor conro. As tet úsaran as taninán cuis esiro. Eyta bira Lázaro eyin quin aywi. As tanín quin ehcwáy aywi. Ocat as abáy wahníc ehcwáy aywi. Eytair báreyra, as tanín cat usár abáy wahnáy rocátaro. Abáy cuácataro,” wajacro, Abraham quin. ");
INSERT INTO tuf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Etat Abrahamat wajacro: “Ba taninatra Moisesat cuihsú bahjác chihtá yajcátaro. Uchicrias Sir chihtá ehcúquinat cuihsú bahjác chihtá yajcátaro. Bah taninát chihtá ey rahcuátaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Abrahamat eyta wacayat, oyin yarjáqueyat wajacro: “Batro. As taninát chihtá cuihsú bahjaquey cácajatro. Cuatán sácajaquin cajc cutar bin chihtá ayat as taninát bar yajcátaro. Lázaro yarjáqueyat sicor ehcwáy bicayat, ey chihtá bar rahcuátaro. Rahcuír ur tehmár ay bár yajquíc etátaro,” wajacro, Abraham quin. ");
INSERT INTO tuf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Etat Abrahamat wajacro: “Ba taninát Moisesat chihtá cuihsú bahjác yajti eyra, Sir chihtá ehcuquib chihtá yajti eyra, yarjaquey sicor ehcwáy ayit cat caca báreyra,” wajacro, Abrahamat. Jesusat uw quin eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Etar Jesusat ima chiwa quin wajacro: —Cahujinat uw quin Sir tayar yajc áyayqueyra. Eyta cuar rehrát eyta yajc áyictara, ey ácaman ahsín rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bíyinat sasá quin Sir tayar yajc áyatan, yajc ayin acam ay baran tahnác rehcáyqueyra. Eyinan anto sasá quin Sir tayar yajc ayti cuat, chinquir waquít, yarsa chinátaro. Yacúr ocso tijcaquir waquít yarsa tijcátaro. Anab ub ima cucú ques acat questár car riw ocso tijcaquir waquít, yarsa tijcátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yají jaw̃i, wajacro. ’Ba rabat ay bár yajcayat, eyta yajti acu ajc uní cuitar waw̃i, -wajacro-. Etar rabat urá tehmár ay bár yajquíc etyat, sicor im ey jor ay tenátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ba rabat ba quin “Aját ay bár yajác rehquít asan cuero. Etar aját ay bár yajquíc etinro,” wacayat, baat sicor tenátaro. Bucoy bucoy ay bár yajquír, eyta wacayat, baat bucoy bucoy tenátaro. Riy istanác icar cucuí eyta yajquír wacayat, baat eyta tenátaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Etar Jesús quin chiwat wajacro: —Isat bah tamo cuít síhw̃ayta acu urá wiw̃i. Bahat bahnác bar yajcata isat síhw̃ayta acu is quin urá wiw̃i, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eyta wacayat, Jesusat wajacro: —Mostaza cucuán conu biro. Conu éytaan wan ba urán tanan as tamo conu síhw̃aquir waquít, caruc ajc morera quin wacátaro: “Cárucuu, sihyá cuachwi. Cuachír yacúr ubut tas riw̃i. Yacúr ubut riquír yehnwi,” wacátaro. Eyta wacayat baat waquíc eyta bar yajcátaro. As tamo eyta conu síhw̃ayat, caruc quin eyta wacayat eyta yajcátaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesusat chiwa siw̃in acu uchta cat wajacro: —Uch síhw̃awi. Ba cacmá chiy cutara bijác óraro. Obas obir yajcáytara, vaca obir yajcáytara bijác óraro. Cacmá ey sicor usi wicayat, baatrá, “Raw̃i. Usar quen jaw̃i,” wátiro. “Aját bah ac ir aninro,” wátiro. ");
INSERT INTO tuf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Eyta wati cuar, “Aját yayín acu bahat ir anwi. Anir wiw̃i,” wacaro. “Oya tas chaquir ira as ac row̃i. Rocayat récaji aját ira yayinro. Bacú yahnro. Etar yahncutra behmát yayátaro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Etar yajc áyjaquey bahnác ay yajcayat, ¿patronat “oquéy, as chihtá ay cájacro,” waquí? Eytara wátiro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eyta cat baatán Sirat ayic chihtá bahnác yajquír car waw̃i: “Isra chíwaro,” waw̃i. “Isat patrón ac yajcata bin eya yajacro. Etanro,” waw̃i. Jesusat chiwa quino eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesusin Jerusalén cuwín béjecro. Bécayat, Samaria cajc cut, Galilea cajc cut tiw̃ béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pueblo cuitar cuwina becayat, Jesús acam cuercurin cuisa ucasi bin rojocro. Cuercúr eyin ruhsúc restát tínquinro. Sura ohníc restát tínquinro. Cuercurin birá cut cuar acsar beti chiquir chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chiquir chaquir Jesús cut cohwjacro: —Jesusu, caru, bahat is obir yajw̃i. Ruhsucuát is cuácaro. Is sura bar ohná bicaro, cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eyta cohwyat, Jesusat cuercurin itchacro. Istír eyin quin wajacro: —Sacerdóteinat ba sura ohníc tuncháctara istayta acu béowi, wajacro. Jesusat eyta wacayat, cuercurin sacerdote quin béjecro. Beya rabar imár sura ohníc bar orac tan chájacro. Ruhsúc bar bahnác orac waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ubistiyatan ima bar tan jajac istír, sicor Jesús quin cuwín bijacro. Sicor be rabar “Siran ayro,” wajacro. “As bar tan jájacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús quin cur Jesús cac cahmar cuscar cut chihrír wajacro: —Jesusu, bah ur ayro, -wajacro-. Bahat as bar tan jájacro, wajacro. “Bah ur ayro,” wajaquey Samaria úwcuano. Judíoini batro. ");
INSERT INTO tuf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Etar Jesusat wajacro: —Aját cuercurin ucasi bin tan jájacro, ¿Cahujín estari bin ahri? ");
INSERT INTO tuf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Samaria uw étana Sir ojcor ay waquín acu sicor wijacro. Judíoinra bétiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Etar cuercúr ey quin wajacro: —Cui yehnwi. Yehnár usi biwi, -wajacro-. Bahat aját bah bar tan jácata séhw̃ajac etar, bar tan jájacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Riy istiy cut fariséoinat Jesús quin behquír táyojocro: —¿Sir cara rehquey bita cuanyat yehnátaca? Fariséoinat eyta táyoyat Jesusat wajacro: —Siran cara uwat istiti yehnáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Uwat “Siran cara erar yehnjacro,” bitách wácajatro. “Usár yehnjacro,” bitách wácajatro, -wajacro-. Cuatán Sir cara rehquey ba tac ícatro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Etar awan Jesusat chiwa quin wajacro: —Awan semar asan Uw Síuquib istá racar rehcátaro, -wajacro-. As itchaquey im eyta sicor riy istana baat istá racar rehcátaro, -wajacro-. Eyta cuar eyta istá báreyra. ");
INSERT INTO tuf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eyta cuácayat, cahujinat ba quin wacátaro: “Sir cara rehquey erar bar yehnjacro,” wacátaro. “Usár bar yehnjacro,” wacátaro. Eyta cuar eyin chíhtara rahcti jaw̃i. Eyin owár itay beti jaw̃a, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cuir chihcuát cuasoyat, rahray wihár binat, rahray wihár binat, bahnáquinat itro. Uwat chihcuát cuasoyat istír eyta asan Uw Síuquib wicayat cat eyta istáyqueyra. As wicayat, rahray wihár binat, rahray wihár binat istáyqueyra. -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Récaraman ah uwat as bitara utar abáy ruhw̃áyqueyra. As riya yajti jácayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cohtín Noé itic ricar cut uw itir eyta as wiquíc ricar cut eyta ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cohtín Noé itic ricar cut uwat imár sácata síhw̃atiro. Sácajar sehw̃ar ira yájacro. Bacú yahjacro. Wiya cat yehw̃jacro. Síhw̃ati cuar cahbarin cat yehw̃ín acu ajc waajacro. Noé rih arcutar beyin usar rauwic ocso tas eyta yajacro. Cajc bahnác riwat cuiníc ocso tas eyta yajacro. Bahnaquin sacac ocso tas eyta yajacro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Cohtín Lot itic ricar cat eyta ítchacro. Uwan Sir tamo síhw̃ati ítchacro. Ira yájacro. Bacú yahjacro. Icuran biyan rajacro. Icuran biyan ray cuitar wahjacro. Ira rijacro. Ubach tuw̃jacro. Sácajar sihw̃ar eyta ohbac ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Etar Lot Sodoma pueblo bin acsar bar waajacro. Lot pueblo waa becayat, Sirat cuacúr bin riwa ayir eyta oca cat, azufre cat eyta áyjacro. Sodomin tiw̃in acu áyjacro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Asan Uw Síuquib wiquíc ocso tas uwat eyta síhw̃ati ítayqueyra. As wícajar sihw̃ar eyta yajcáyqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Asan Uw Síuquib eyta wicayat, biyan ubach arcút ítictar eyan usi rauti cuar acsar car biwi. Oya uquin cat rauti jaw̃i, -wajacro-. Biyan chiy cuitartara ey cat usi biti cuar, acsar car biwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cohtín Lot wiyat yajáqueyan tan chinti síhw̃awi, -wajacro-. Lot wiyat Sir chihtá rahcti chájacro. Etar Sirat chin áyjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bíyinatan imár chihtá cut ohbac itin sihw̃a rabar as ajcá bár yehw̃ téyeyra, éyinan Sir quin cuacúr ohbac itay beya báreyra, -wajacro-. Cuatán bíyinat imár chihtá yajti cuar as ajcá ji bécayat, éyinan asi jor cuacúr beyáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aját ba quin wacaro. As wiquíc cheycar cuisa bucáy bin owár camyat, úbistira ajáy yehw̃ beyátaro. Cuat istiyrá cham báhtaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wiw̃ín bucáy binat buca jor eb tajcro. Tajcyat úbistira yehw̃ beyátaro. Cuat istiyrá esar cham báhtaro. ");
INSERT INTO tuf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cuisa bucáy binat buca owár chi cácayat, úbistira yehw̃ beyátaro. Cuat istiyrá cham báhtaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesusat eyta wacayat, ima chiwat wajacro: —¿Eytaan birar rehcátaca? táyojocro. Eyta táyoyat Jesusat wajacro: —Chein bísara jácayat, bacasít erar quiwátaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Etar Jesusat uwat Sir ojcor séoti conayta acu síw̃jacro. Eyta siw̃in acu uchta ehcujacro: ");
INSERT INTO tuf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Pueblo istiy cutar juez cáraro. Juez cara éyatra Sir tamo séhw̃ati biro. Uw cat ajcá ji bétiro. ");
INSERT INTO tuf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pueblo ey cuitar cat yarjác wiya itro. Wiw̃ eyan juez quin bucoy bucoy conay bijacro. Séoti bucoy bucoy wajacro: “As cuitar waw̃i. As ruhw̃uquey bahat técuawi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juez quin bucoy bucoy coníc cuar récajira juezat ey ria cati chájacro. Cátian chin rehjecro. Yájcajareht im ur icar séhw̃ajacro: “Aját Sir tamo cat, uw tamo cat séhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Eyta cuar wiw̃át eyta seo conyat, eyat as bar séojacro. Eyta bira ahrun aját ey cuitar waquinro,” séhw̃ajacro. “Eytair báreyra bucoy bucoy as quin seo conay wicátaro. Eyta seo conay wicayat, as bar cuácataro,” séhw̃ajacro, Juezat. ");
INSERT INTO tuf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesusat eyta wajacro. Acsar uchta wajacro: —Juez ur ay bár cuar, eyat yajác tamo síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Juez eyat uw conquey rahcuictar, Síratwat cuít rahcuátaro. Eyta cuácayat, imáy cájaqueyin ricar cat, cheycar cat ima quin conyat, Sirat eyin cuitar cab rehti wacátaro. Cahujinat ruhw̃uti acu, eyin cuitar wacátaro. ");
INSERT INTO tuf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aját ba quin wacaro. Sirat eyin cuitar cab rehti in bar wacátaro. Cuatán cabar tinyat asan Uw Síuquib sicor cajc uch cuitar wicátaro, -wajacro-. ¿Wicayat, uwat as tamo síhw̃ati as chihtá bar wácajac ístajaca? Aját ba cuitar wacata chihtá etiti síhw̃awi. Etiti conwi, wajacro, Jesusat, ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesusat imár tamo cuít síhw̃aquin quin chihtá siw̃in acu icúr bi ojcor tew̃jacro. Uw eyin imárat ayan cuít yajc síhw̃aro. Eyta sihw̃ac etar, Jesusat eyin quin serin bucáy bin ojcor ehcujacro: ");
INSERT INTO tuf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Serin bucayan Sir usi béjecro. Sir quin conay béjecro. Ser istiy bijaquey fariséoincuano. Istiy bijaquey gobierno tayar chíquibcuano. ");
INSERT INTO tuf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sir usi cur, fariséoat Sir quin uchta conjacro: “Siru, oquéy. As ayro. Cahujinra as owara cutiro,” wajacro. “Asan esi batro. Asan uw cayar yájtiro. Aját cahujín wiya besir yájtiro,” wajacro. “Aját bah quin wacaro. Gobierno tayar chiquib uyat ay bár yajquír eyta aját éytara yájtiro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Semán istiy icar ajatán bachan icar bucáy yajcaro,” wajacro. “Aját ucasi bin sicar úbisti, ucasi bin sicar úbisti uquir bah quin wícaro. Icuran biyan bahnác sicar eyta uquir aját bah quin wícaro,” wajacro, fariséoinat Sir quin. ’Fariséoinat “as ayro,” conjác cuar, ");
INSERT INTO tuf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","gobierno tayar chíquibra ajquír cuar conjacro, -wajacro, Jesusat-. Imát ur ay bár yajác sehw̃ar cuacúr ub yéhw̃tiro. Im at cut ima tancar bujacro. Buca rabar Sir quin wajacro: “Siru, aját bah tayar yajacro. Eyta cuar aját tayar yajác ques técuati jaw̃i. As tamo sehw̃ar cue rehw̃i,” wajacro, gobierno tayar chíquibat. ");
INSERT INTO tuf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesusat uw quin ey ojcor ehcujacro. Acsar wajacro: —Aját ba quin wacaro. Gobierno tayar chiquib ur ay bár yajacan Sirat tayar bár jájacro. Ey urán Sir owár tan wan rehjecro. Eyta rehquír sicor usi bijacro, -wajacro-. Cuat fariséoat ur ay bár yajác tayar batra chátiro. Bíyinatan imár ojcor “asan ayan cuitro,” síhw̃ayat, Sirat eyta síhw̃aqueyin cuayan wan chácayqueyra. Eyta cuar bíyinatan imár ojcor “asan ur ay batro,” síhw̃ayatan, Sirat eyta síhw̃aqueyin cárinan cuít chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Etat owár uwat imár buwachcuar cat, sasá cat Jesús quin rojocro. Jesusat at cut bútayta acu rojocro. Etat ima chiwat eyta itchacro. Istír uw quin taniric tew̃jacro. Uchta wajacro: —Jesús quin sasá roti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesusat eyta tew̃ic rahcuír, sasá chíjacro. Chiír ima chiwa quin wajacro: —Sasá rocayat, síuti jaw̃i. Imár rocáyqueyra. Roquín acu ajc waawi. Sasát Sir tamo sihw̃ar eyta uwat Sir tamo eyta síhw̃ata binro. Eyta síhw̃ayat Sir cara rehquey cutar cuwátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aját ba quin wacaro. Bíyinan sasán wan Sir tamo síhw̃atieyra éyinan Siran cara rehquey cutar bitách cúwajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Etar carin istiyát Jesús quin wajacro: —Bahan siw̃quib ayro, -wajacro, Jesús quin-. ¿Aját ay bi icúr yajcátaca, cuacúr Sir jor etiti ohbac itin acu? táyojocro, cárinat. ");
INSERT INTO tuf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Etat Jesusat wajacro: —¿Bitara etar as ojcoran “ayro,” waqui? Ur ay binan Sir ístitro. Cahujinra batro. ");
INSERT INTO tuf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sir bachan chihtán cuihsú bahjaquey bahat itro. Uchta cuihsú bahjacro: “Yehw̃ti bi jor isár yajti jaw̃i. Uw yauti jaw̃i. Bes yajti jaw̃i. Cahujín cahm sucuar tew̃ti jaw̃i. Tetín abín ajcá ji béowi,” Eyta cuihsú bahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Etat serat wajacro: —Síw̃quibu, aját ey chihtá bahnác yajcaro. Asa conu cuácayat echí cuar aha ocso tas ey chihtá bahnác yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesusat eyta rahcuír ey quin wajacro: —Bahat acsar chihtá istanác ey yajcátaro. Bah oya cat, cajc cat bahnác rawi. Rar car, ray túnjaquey oya bár bin quin tahw̃uwi. Eyta tahw̃uyat, Sirat cuacúr ba acu ayan cuít bi wícayqueyra. Etar asi jor chihtá sinay biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","“Bahnác rawi,” wacayat, serat rahcuír, cue rehjecro. Ima oyan, rayan, cajcan cuít rehquít, cue rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Etat Jesusat ser ey ita rabar wajacro: —Oya ji bin, ray ji bin Sirat imár síwata síhw̃atiro. Oya chi, ray chi rehquít, imár chihtá cutar siwin síhw̃aro. Etar eyin Sir cara rehquey cutar raúwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sir cara rehquey cuitar rauwin acu cárinat bahnác cham bah cun batro. Camello cabálloir binro. Eyan sicar úcara icar bitách raúwajatro. Camello sicar ucar icar raúwajar eyta oyin rayin cat eyta Sir quin bitách raúwajatro. Eyta cuar camello sicar ucar icar rauwin yajquír waquít canar etach batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Uwat eyta rahjáqueyinat wajacro: —Eytatara ¿Sir quin cuacúr rehrí raúwajarica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eyta wacayat, Jesusat eyin wahitír wajacro: —Uw urá cuitari bitách raúwajatro. Eyta cuar Sir urá cutar bahnác yajcátaro. Sirat bi yájcajatrum batro. Sir urá cuitar Sir ima cara rehquey cut raúwataro. Sir urá cuitar uwat Sirat síwata síhw̃ataro. Etar Sir ima cara rehquey cut raúwataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Etar Pédroat Jesús quin wajacro: —Isan bah chiwa chaquin acu ijmaray bahnác cham bahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Etat Jesusat wajacro: —Aját ba quin wacaro. Bíyinat Sir cara rehquey chihtá ehcún ac úbachtara, wíyatara, rábintara, tetíntara, abíntara, sasátara bahcayat, eyin ac cuít wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Sirat eyin quin cuít wícayqueyra. Ah uch cutar cuít wícayqueyra. Etar cabar tinyat, Sir ima jor itin acu cat béyataro, wajacro, chiwa bahnaquin quin. ");
INSERT INTO tuf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bahnaquin quin eyta waquír, chiwa doce bin quin uchta wajacro: —Uch rahcwi. Isan Jerusalén cun becaro, -wajacro-. Jerusalén cucayat, récaram Sir chihtá ehcúquinat wac bahjác ey bahnác eyta yajcáyqueyra. Asan Uw Síuquib ojcor cuihsú bahjacan ahra eyan bahnác eyta yajcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ahra asan Uw Síuquib judío bár bin at icar wícayqueyra, -wajacro-. Judío bár binat as buror sisáyqueyra. As ruhw̃áyqueyra. As cuit cana rihar tijcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","As bucáyqueyra. As yau téyqueyra. Yauyat bay cuanyat, as sicor estají yehnáyqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eyta wacayat, éyinat rahcti rehjecro. Bi ojcor tew̃ictar istiti rehjecro. Jesusat eyta tew̃quey éyinat urá bow̃ beti ac tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesusin Jericó pueblo cuwín béjecro. Jericó pueblo cuwín intac becayat, ub bár bi ibit cucáj sar itay raújacro. Ub bár bi ibit cucáj sar ita rabar ray chíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Erar ityat uw ricán to bequic rahjacro. Eyta rahcuír táyojocro: —¿Rehrín beca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eyta táyoyat, uwat wajacro: —Jesús Nazaret bin bicaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eyta waquitrun ub bár bíjiyat cohwjacro: —¡Jesusu! ¡David wihnú! As tamo séhw̃awi. As cuitar yajw̃i, cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eyta cohwyat, cahmor béquinat ey quin tan irujacro: —Ajc chin jaw̃i, wajacro. Ub bár bi eyta técuayatwan ráhctiro. Bucoy bucoy ajcan cuít cohwjacro: —¡Jesusu! ¡David wihnú! As tamo séhw̃awi. As cuitar yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eyta cohwyat Jesusat rahcuír biti inic ítchacro. Itir ub bár bin ima quin roquín uw áyjacro. Etar cahujinat ub bár bi Jesús quin yehw̃ rojocro. Yehw̃ rocayat, Jesusat wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Aját ba cuitar icúr yajcátaca? táyojocro. Etat ub bár bíjiyat wajacro: —Caru, as ub ji chaw̃i, -wajacro-, aját istín acu. ");
INSERT INTO tuf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eyta wacayat Jesusat ey quin wajacro: —Bah ub ji chaw̃i, -wajacro-. Bahat sehw̃at, aját bah ub ji chácata, séhw̃aro. Eyta sehw̃ac etar, aját bah ub ji chácaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesusat eyta wacayat ub bár bin ub ji rehjecro. Etar Jesús chiwa chaquin ac ey jor ibt aw̃at béjecro. Be rabar “Siran ayro. As ub ji chájacro,” wajacro. Etar uwat cat ub ji chajac istír car, “Siran ayro. Sirat ub bár bin sicor ub ji chájacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Etat Jesús Jericó pueblo cutar raújacro. Erar rawot tiw̃ bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jericó pueblo cuitar sera ajca Zaqueo itro. Zaquéoan gobierno tayar chiquin cárinro. Oyin ráyinro. ");
INSERT INTO tuf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús erar tiw̃ bicayat, Zaquéoat Jesús istín yajquít cat bitách ístajatro. Uw ricán toro. Zaqueo biht cuar conu quenro. ");
INSERT INTO tuf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jesús ístajar rehquít, Jesús biquic acam cha bijacro. Acam cur car caruc ojcor waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Etar Jesús Zaqueo waajác caruc cahm bir car, cuacrár wahitchacro. Ititan Zaqueo caruc tah satro. Istír Zaqueo quin wajacro: —Zaquéou, ic oso bura cut raw̃i. Asan bah usi camátaro, wajacro, Zaqueo quin. ");
INSERT INTO tuf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wacayat, Zaqueo ic oso rajacro. Bur cut rajacro. Wiquír Zaquéoat Jesús quínoan ahní ténajacro. Tenar usi bar béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bécayat, cahujínatra rahra rahra Jesús ríojocro. Jesús besin usar camay bijác ques ríojocro. ");
INSERT INTO tuf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jesús Zaqueo usi cucayat, Zaquéoat wajacro: —Caru, ajáy icuran biyan bahnác sicar uquir bitác istiy cuayin quin wíquinro, -wajacro-. Eyta cat aját biyin cayar yajáctara, biyin ohnor bes yajáctara, aját sicor eyin quin icar bacáy túninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Etat Jesusat Zaqueo quin wajacro: —Ahra Sirat bah usar itquin bar síwataro, -wajacro-. Zaqueo cat cohtín Abraham bomcatró. Etar síwataro. ");
INSERT INTO tuf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Asan Uw Síuquibat uw wahitay wijacro. Sir chihtá waca téqueyin siway wijacro, wajacro, Zaqueo quin. ");
INSERT INTO tuf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zaqueo quin Jesusat eyta waquíc uwat cat rahjacro. Uwat eyta rahcyat icar aw̃at, Jesusat acsar chiht istiy síw̃jacro. Jerusalén intac cuar síw̃jacro. Jesusan Jerusalén intac cujac reht uwat uchta síhw̃ajacro: “Sir cara yehníc bar cab cucaro,” síhw̃ajacro. Uwat eyta sihw̃ac etar, Jesusat eyin chiht istiy siw̃in acu icúr bi ojcor uchta tew̃jacro: ");
INSERT INTO tuf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Cara wacjá cajc istiy bijacro, -wajacro-. Ey cajc cutara rey cara yehnayta acu bijacro. Cara yehnár sicor bar wicata bicaro. ");
INSERT INTO tuf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ben cahmoran cacmín ucasi chíjacro. Yehw̃ chiír béhcayat, istiy quin, istiy quin, bahnaquin quin oro ray cham wíjacro. Istiy quin ray istiy, istiy quin ray istiy wíjacro. Wica rabar wajacro: “As wiquíc ocso tasan ray uch acsar cohna aywi. Acsar waar car, sicor rar car ray bucoy bucoy cuít cohna aywi,” wajacro. Eyta wac bahr bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Eyta cuar ima cajc cutar uwat ey quehsuro. Etar bicayat, questoc chihtá áyjacro. Chihtá bequin cut uchta wacay áyjacro. “Ey sera chíhtara ca cun batro. Eyra is cara yehn ayti jaw̃i,” wacay áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Eyta cuar, cara wacjá rey cara yehnjacro. Cara yehnár sicor im cajc cut wijacro. Wiquír car cacmín chíjacro. Ray wíjaquin chíjacro. Chiír cat eyin quin táyojocro: “¿Ray wic bahjac ey cuitar baatán bucoy bita sécuayi?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eyta táyoyat, récaji cacmát wajacro: “Bah raya as quin wijac ey cuitar ray ucasi sécuajacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eyta wacayat, carat wajacro: “Yársaro. Bah urá ayro,” wajacro. “Bahat conu bi ruhw̃uti cohna áyjacro. Ay yajacro. Eyta bira pueblo ucasi cuitar bah uw cara yehn áyinro,” wajacro, cacúm quin. ");
INSERT INTO tuf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Etar cacúm istiy carin quin raújacro. Rauwir, wajacro: “Bah ray as quin wijac ey cuitar ray esí sécuajacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cacumát eyta wacayat, carat wajacro: “Yársaro. Pueblo esí cuitar bah uw cara yehn áyinro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Cacúm bahnác ubar ojcor ey wijacro. Wiquír wajacro: “Caru, bah ray usatro. As bah cahmar ehurán to rehjecro,” wajacro. “Aját ítitan, bahat tijcati tehmoti chícaro. Bahat cara reht behmáy bár bin cácaro. Bahat cahujinat rijác bi sécuaro,” wajacro. “Eyta cuácayat aját bah ray oya cumar tamo bacór yehw̃ jájacro,” wajacro, cacúm ubar ojcor eyat. ");
INSERT INTO tuf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Etat carat wajacro: “Bah chiwa ur ay batro. Bahatan as urán it séhw̃aro,” wajacro. “Bahat ítitan, ajatán cara reht ajáy bár bin cácaro. Aját cahujinat rijác bi sécuaro. ");
INSERT INTO tuf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bahat eyta itic etar as rayan ray secuac ubach sar chácata bi yajacro. Acsar cohnayta chácata bi yajacro. Ray secuac ubach sar chájaquir waquít, as sicor wicayat, éyinat sicor cuít túnata bi yajacro,” wajacro, cacúm ubar ojcor bi quin. ");
INSERT INTO tuf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Etar cahujín quin wajacro: “Ray ey ohnor quistú uw̃i. Etar ray ucasi bi quin wiw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eyta wacayat uwat wajacro: “Caru, uyra ray ucásiro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eyta cuar carat wajacro: “Aját wacaro. Bíyayan cuítara ey quin acsar cuít wícaro. Eyta cuar bíyayan conútara, ey ohnor bahnác cuic úcaro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Asan cara yehn cun bár rehjéqueyin usár as cac cahm row̃i. As quehsí bin row̃i. Roquír, as cac cahmar tiw̃i,” wajacro, carat. Jesusat uw siw̃in acu eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesusat eyta ehcúr car, ima chiwa owar Jerusalén cuwín bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesús Jerusalén bir Betfagé pueblo intac, Betania pueblo intac cujacro. Pueblo eyan Olivo terá cuitatro. Erar cur, ima chiwa bucáy bin quin ayin inár uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Pueblo ácatar erar cahmor béowi, -wajacro-. Erar cur car, asanica questa chájaquin istáyqueyra. Asanica ey cuitar uw istiyí waátiro, -wajacro-. Eyta ityat rícuawi. Ricuár cat as ac row̃i. ");
INSERT INTO tuf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Baat roquín yinyat, uwat táyota oraro: “¿Asanica bitán rícuaqui?” Ba quin uwat eyta táyoyat uchta waw̃i: “Carat inic chícaro. Biráy rehti sicor usár roquín wacaro.” Eyta waw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesusat eyta waquír ayat, bar béjecro. Etar pueblo cur itit, Jesusat ehcujác éytaro. Asanica questajacan bar itchacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Etar asanica bar ricuajacro. Ricuayat ícara cayíbinat itchacro. Istír wajacro: —¿Asanica bitán ricuaca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Etat Jesús chiwat wajacro: —Carat chícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Etar Jesús acu asanica sicor bar béjecro. Jesús quin sicor cur asanica cuitar imár oya chájacro. Chaquir Jesús ey cuitar bar waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Waar ibit aw̃at bijacro. Bicayat uwat imár oya ibit cutar asujacro. Jesús biquic cahmar ibit cuitar oya eyta asujacro. “Jesusan caran cuít” sehw̃ar asujacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliva terá ibit cutar sicor cahmoso becayat, chiwa bahnáquinat Sir ojcor cohway yinjacro. “Siran ayro,” waquín acu cohway yinjacro. Jesusat ima camur cuitar Sir urá cutar yajquíc itchác rehquít, Sirat rahcuín cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Uchta wac cohwjacro: —Bah Sir chihtá cuitar rajacro. Baha rey yehnín acu rajacro, -wajacro, Jesús quin-. Sirat ima rey car acu, bah acu ay rehquín chaw̃i. Cuacúr Sir quínoan bahnác ohbac jaw̃i. Cuacrár Sírayrun ayan tahnác wan beo beo chaw̃i, wajacro, Jesús chiwa. ");
INSERT INTO tuf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eyta wac cohwyat, fariséoin cat ricá tac ícatro. Eyinat Jesús quin wajacro: —Síw̃quibu, bah chiwa técuawi. Eytara tew̃ ayti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Etat Jesusat fariséoin quin wajacro: —Aját ba quin wacaro. Uyin ajc sácayeyra ibit aw̃at acan ajc ji waátaro. Ajc waar car cohwátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Etat acsara Jerusalén pueblo cuwín bijacro. Be rabar Jerusalén pueblo istá rabar Jesús bar ojocro. Ey racar conjacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Conár wajacro: —Jerusalén uwu, Sir jor tan wan rehquín acu sínata bi yajacro. Eyta sínjaquir waquít, baan ohbac chácata binro. Eyta cuar eyta síntiro. Ahra eyta sinic caba bar chac bahjacro. Ahra sínajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Etar awan ba quehsí binan Jerusalén pueblo rúhracat quihwáyqueyra. Jerusalén rúhracat tunáyqueyra. Rúhracat eyta tunyat, quehrír óroyqueyra. Jerusalenin acsar bitách waajar rehcáyqueyra, -wajacro-. Quehsí binat rahr owár, rahr owár eyta tunáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Etar Jerusalén ica sar quehr téyqueyra. Quer cat, ubach cat ic icar quehr téyqueyra. Etar ba ey sar itquin ba sasá cat bahnác tíw̃ayqueyra. Ac ubach chajac bahnác quehr técayat, acan istiy arcutar, istiy arcutar eyan úbisti chati bahnác quihwáyqueyra, -wajacro-. Jerusaléninat asa Sir wacjá wijác síhw̃ati ques eyta cuácayqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Eyta waca rabar, Jesús Jerusalén pueblo icar raújacro. Erar Sir usar raújacro. Sir usar rauwir itit, uwat atcur ruwa wahr car sicor racaro. Cahujinat ray tehmoro. Eyta istír eyin watar si ayin yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Watar si ayir wajacro: —Sir carit cuitar Sirat wajaquey uchta cuihsú bahjacro: “As ubach as ojcor conic úsiro,” wajacro, Sirat. Sir carit cuitar eyta cuihsú bahjacro. Eyta waquíc cuar, ba bésinan esar itay yinjacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesusat cuanmí cut, cuanmí cut Sir usar uw síw̃jacro. Eyta siw̃yat, sacerdote cárinat cat, bachan chihtán síw̃quinat cat, werjayinát cat Jesús bitara yauwátatara síhw̃ajacro. Eyta sihw̃ar imár owár ríojocro. ");
INSERT INTO tuf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Eyta cuar bitara yauwátatar istiti rehjecro. Uw bahnaquin Jesusat siw̃quey bahnác ay rahcua racar rehjecro. Eyta etar cárinat Jesús bitách yaúwajatro. ");
INSERT INTO tuf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Riy istiy Jesusat Sir usi síw̃jacro. Sir chihtá ay bi ehcujacro. Eyta ehcwayat sacerdote carin cat, bachan chihtán siw̃quin cat, judío werjayín cat Jesús quin béhjecro. ");
INSERT INTO tuf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Behquir táyojocro: —¿Bahat yajquey rehr chihtá cuitar yajqui? ¿Bah quin rehrát eyta yajc ayi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Eyta wacayat, Jesusat wajacro: —Aját rahra ba quino cat táyonro. As quin récaji uch ehcuwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juan uw riy sar siw̃quibat bi chihtá cuitar uw rih sar siw̃yi? ¿Sir chihtá cuitar, uw chihtá cuitar rih sar siw̃yi? As quin ey ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eyta wacayat, sacerdote cárinat cat, judío werjayinát cat imár owár rahra rahra bitara wacátatar uchta tew̃jacro: —Isat “Sir chihtá cuitar yajacro,” wácyeyra, Jesusat is quino wacata óraro: “Eytatara, ¿ey chihtá bitara reht cática?” wacata óraro. ");
INSERT INTO tuf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eyta cuar isat “Uw chihtá cuitara rih sar siw̃jacro,” wácyeyra, ¿uw ricát is cut aca tey yínajaca? Uwat síhw̃atan: “Juanan Sir chihtá ehcuquib rehquít, uw rih sar siw̃jacro,” síhw̃aro, uwat. ¿Eyta sihw̃ac etar isat uw chihtá cut siw̃jac wácyeyra is cut aca tey yínajaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Etar Jesús quin wajacro: —Isat istítiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eyta wacayat, Jesusat wajacro: —Aját táyoyan baat as quin ehcuti etar, aját cat ba quin ehcútiro. Aját bi chihtá cuitar yajquíctara ehcútiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Etat Jesusat chiht istiy siw̃in acu uw quin icúr bi ojcor uchta wajacro: —Riy istiy serat ima cajc cut ub yaquic chistár rijacro. Etar bahnác riquír chistár cat, cajc cat cahujín at icar bahjacro, ruoyta acu. “Uba ey tihryat, isat wahw̃unro,” waquír bahjacro. Eyta waquír, cajc istiy itay bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Itchareht, yájcajareht chistár ub tihric cab cujacro. Ub tihric cab cucayat, ima cacmá chistár riquir bahjác cajc cut áyjacro. Chistár ub imáy acat ey ucay áyjacro. Cacmá ayat bijacro. Erar cucayat ruoyta chac bahjáqueyinat cacmá ey abáy bujacro. Buquír sicor ata áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Etat cayibat istiy cacmá áyjacro. Cacmá ey erar cucayat, erar ruóqueyinat bujacro. Ahsín ruhw̃ujacro. Ruhw̃uyat sicor ata áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Etat cayibat cacmá bawoy áyjacro. Erar cucayat, erar ruóqueyinat cacmá ey buc téjecro. Buquír ew̃ uquir te sijacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Eyta cuácayat, cayibat séhw̃ajacro: “¿Aját bitara yajcátaqui?” séhw̃ajacro. “Aját ajmár waquíj sehnác bin áyinro,” séhw̃ajacro. “Uw éyinat as waquíj etar ajcá ji béyayqueyra,” sehw̃ar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ayat bijacro. Erar cucayat, uw éyinat cayíb wacjá raquíc itchacro. Istír rahra rahra wajacro: “Uya cayíb waquijró. Uy yaryat cayíb cajc uchan bi acui cha báhjatro. Eyta chíhtara ey yauwátaro. Eyta yauyat, cajc uchan ijmaray cháquinro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","’Eyta waquitrun, wacj ey chistár ques bin ew̃ uquir te sijacro. Ew̃ uquir yaujacro, wajacro, Jesusat. Eyta waquír uw quin táyojocro: —Baat sihw̃at, ¿cajc cayíb uw eyin ac bitara yajcátaqui? Uchta yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cajc cayibat uw eyin séhw̃ati tíw̃ayqueyra. Bahnác sácayqueyra. Eyta tiw̃ir cat, cajc eyra cahujín at icar wícayqueyra, wajacro, Jesusat. Eyta rahcuír uwat wajacro: —Eytara reh cun batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Etar Jesusat bucoy uw wahitír eyin quin wajacro: —Sir carit cutar cuihsú bahjáqueyan as ojcor uchta wacaro: Ac ubach túw̃quinat aca cumac bi úbisti ay bár sihw̃ar, te sijacro. Eyta te sijác cuar, aca ey sicor yehw̃ roquír ácoso tebir chájacro. Sir carit cuitar eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","’Ac ey arcutar bíyinan yau yáryatan, eyan bahnác quehu téyqueyra. Cuatán ac eya biyin arcutar tijcayat, bahnác sec téyqueyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesusat eyta wacayat, bachan chihtán síw̃quinat cat, sacerdote cárinat cat rahjacro. Rahcuír ítitan, Jesusat imár cahm icar tew̃ro. Imár cahm icar tew̃ic istír, im ey ricar cuitar Jesús caquir questa racar rehjecro. Eyta cuar uw ricá to bin ayot Jesús catótiro. ");
INSERT INTO tuf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Catoti cuar uw Jesús quin áyjacro. Ayjaquinat Jesús ub iwic uron acu, tayon acu áyjacro. Jesusat ay bár tew̃íctara, ey rahcuín síhw̃ajacro. Ay bár tew̃ic rahcuír car Jesús gobierno at icar wiquin síhw̃ajacro. Wiquír ey cahm icar tew̃ín síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eyta ayat, uw éyinat Jesús quin cur wajacro: —Síw̃quibu, isat bah ítitan, bahat Sir chihtá tehmoti ehcuro. Tehmoti siw̃ro. Uw cahm ayú batro. Bahat séhw̃atan, uw cara cat, chiwa cat owáraro. Owár sehw̃ar Sir chihtá wácati siw̃ro. ");
INSERT INTO tuf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Eyta cuácayat is quin ehcuwi. ¿Romano gobierno carat is quin tayar chiquic ey isat icúr yajcata binca? ¿Isat túnataica? ¿Isat tunti jácataica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eyta wacayat, Jesusat eyin ur icar bitara sihw̃ar cat táyoctar itchacro. Eyta istír eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Raya as quin ehcuwi, aját wahitín acu, wajacro. Ray ehcwayat, Jesusat eyin quin táyojocro: —Baat ítitan, ¿raya cuitar rehr ajc cuihsuyi? ¿Rehr aquir chacyi? wajacro. Eyta táyoyat éyinat wajacro: —Romano gobierno cara aquir chájacro. Ey ajc cuihsujacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Etat Jesusat eyin quin wajacro: —Eyta chíhtara romano gobierno cara acu túnata ey ima ajc cuihsujaquin ray cut tunwi. Etar cat Sir ac yajcata ey yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Etar éyinat uw ubot Jesús bitách cayar yájcajar rehjecro. Imát tew̃quey cuitar bitách cayar yájcajar rehjecro. Jesusat tew̃quey rahcuír, ojc siquir ub yehw̃jacro. Etar ajc sarac chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Etat saducéoin Jesús quin béhjecro. Saducéoinat sihw̃at, uw sácajaquin sícotra estají yínajar, síhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Saduceo éyinat Jesús quin tayon acu wajacro: —Síw̃quibu, Moisesat chihtá is quin ehcún cuihsú bahjacro. Uchta wac bahjacro: “Uwa sasá bár chinata óraro. Chein wiya bahta óraro. Eyta báhyeyra, ima rabat yarjaquey wiya yehw̃ata,” wac bahjacro. Yehw̃ír yarjaquey acu sasá cohnátaro. Yarjaquey wiya ohc cut sasá cohnátaro. Isat eyta yajquín acu Moisesat cuihsú bahjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eyta cuácayat, rábinan cucuí ojcor táyonro. Rab eyin rab cahmor bijat wiya yehw̃jacro. Yehw̃ír cat sah bár cuar yarjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Eyta cuácayat yarjaquey rabat chein wiya yehw̃jacro. Yehw̃ír ey cat sah bár cuar yarjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eyta cuácayat yarjaquey rab bawoy eyat chein wiya yehw̃jacro. Yehw̃ír, ey cat sah bár cuar yarjacro. Eytaan rab cucwoy tas bahnáquinat yehw̃ír, sah bár cuar sácajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Rabin bahnaquin sah istiti sacay cutar chájareht, chein wiya cat ubar ojcor yarjacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eyta cuácayat, sácajaqueyin sicor estají yinátair waquít, ¿sácajaquin wiya ey sicor cat bi rabay jácataca? -táyojocro, Jesús quin-. Ey wiw̃ eyan rabin cucuí binat yehw̃jacro, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Etar Jesusat wajacro: —Cajc uch cuitar sérinata wiya yehw̃ro. Wiw̃inat cat ra cuácaro. ");
INSERT INTO tuf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cuatán Sirat biyin quin estají yinín ajc waacayat, éyinra wiya yehw̃á báreyra. Sácajaquin sicor estají yinyat, wíyara yehw̃á báreyra, -wajacro-. Chaunín cat ra cuaca báreyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eyinan Sir cuacúr cacminán wan chácayqueyra, -wajacro-. Sicor estají yinyat, Sir sasaro. Eyin sácajac cuar sicor estají yináyqueyra. Eyta bira éyinra bucoy saca báreyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Uchicrias Sirat Moisés quin caruc sar oca cubar sar cuar tew̃jacro. Sir carit cutar eyta tew̃jaquey chihtá cuihsú bahjacro. Ey chihtá cuitar yarjaquin sicor estají yinín ojcor uchta cuihsú bahjacro. Moisesat Sir ojcor wajacro: “Abrahamin Sitro. Isaaquin Sitro. Jacobin Sitro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eyta wacayat Abraham cat, Isaac cat, Jacob cat sicor yinjác, wacaro. Siran chein Siri batro. Estají bin Sitro. Sir ácuan uw bahnacan estajiro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eyta wacayat, bachan chihtán síw̃quinat rahcuír Jesús quin wajacro: —Síw̃quibu, bahatán ay tew̃jacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Etar uwat Jesús quin bucoy táyotiro. Imár burbar ajc chiw̃ata etar acsar táyotiro. ");
INSERT INTO tuf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Eyta cuar Jesusat eyin quin uchta wajacro: —Bachan chihtán síw̃quinat uchta siw̃ro: “Davidan Cristo cohtinró,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sir chihtá carit ajca Salmo cuitar David imát uchta wac bahjacro: Sirat ajmár cara quino wajacro: “Asi jor bahan cara chaquic acor ítuwi, wajacro, Sirat. ");
INSERT INTO tuf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Aját bah quehsí bin bahnaquin burbar yajquíc acor ítuwi,” wajacro, Sirat ajmár cara quin. ");
INSERT INTO tuf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidat “ajmár cara” waquíc cuitar Cristo ima cara ehcuro. Eyta ehcujác cuar baat Crístoan “David wihná,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Uw bahnaquin cucáj acat Jesusat ima chiwa quin uchta wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Bachan chihtán siw̃quin cahmar yají jaw̃i, -wajacro-. Eyin oya ques acat sohmasom chaca rácatro. Bahnáquinatan ibit aw̃at imár quin ay tena aya rácatro, -wajacro-. Secuac usar báncoan ehchian cuít bi cutar chihra rácatro. Fiesta cuitar cat banco ehchí bi cuitar chihra rácatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eyinat sácajaquin wiya bahjaquey cayar yajcaro. Ey usar bin eyin ohnor icúr bi síuro. Eyta siwic cuara, uwat eyin ur ay síhw̃ayta acu Sir ojcor conyat, in cona báhntiro. Eyta rehquít, Sirat eyin cuít cuécwataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús Sir usi ray chaquic cajón ácatara ítchacro. Erar ita rabar ráyinat ray chaquic wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Etatan ray bár bin, oya bár bin yarjaquey wiya cat itchacro. Ititan ray escúr bin bucáy bi tas chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eyta istír Jesusat ima chiwa quin wajacro: —Aját uní wacaro. Sirat ítitan, yarjaquey wiya wícyeyan cuitro. Cahujinat wícyeyan cutiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Cahujinra rayan toro. Rayan to cuar conu wíjacro. Cuatán yarjác wíyatra ira wahn acu ray yajc chajac cuar ray ey bahnác wíjacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sir ubach wahita rabar chiwat ey ojcor wajacro: —Acan ehchí cuitar tuw̃jacro, -wajacro-. Uwat Sir ubach ehchí rehquín acu icuran biyan ay bi wíjacro. Wícayat ey cuitar ay órojocro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Chiwat eyta wacayat, Jesusat chiwa quin wajacro: —Sir ubach eyta tuw̃jác baat itro. Itchareht yájcajareht aca ubach tuw̃jaquey bahnác quihu sácayqueyra. Acan arar tas tas chájaquey úbistii bahti quihwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eyta wacayat Jesús chiwat ima quin uchta táyojocro: —Síw̃quibu, is quin récaji, ehcuwi. ¿Bahat tew̃quey bitat cab cuwátaqui? Bahat tew̃jác ojcor bar cab cuquey isat istín acu uw acam bitara rehcátatara, is quin ehcuwi. Isat récaji istín acu ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eyta táyoyat, Jesusat wajacro: —Yají jaw̃i. Aját tew̃quey cab racayat, ¿uwat ba cayar yájcajaqui? Uwat imár ójcoran, “Asan Crístoro,” wacáyqueyra. “Cristo wiquíc bar cab cujacro,” wacáyqueyra. Uwan to binat eyta wacáy yináyqueyra. Eyin chíhtara rahcti jaw̃i, -wajacro-. Eyin chiwa chati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cajcan birar urar tec quejn chihtá tew̃ic rahcuáyqueyra. Uwat imár gobierno owár rahra rahra tec quejc chihtá rahcuáyqueyra. Eyta rahcyat rooti jaw̃i. Eyta rehcata waquír chájacro. Tec eyta quejquíc cuar ruw̃ár ojcor rehcata eyi batro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Acsar cat wajacro: —Cajc istiy uwan istiy uw owár, istiy uw owár tec quéjqueyra. Gobiérnoan rahra rahra tec quéjqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ihyár cat birar urar abáy yiwóyqueyra. Cajc istiy cuitar, cajc istiy cuitar yayan uti siti rehcáyqueyra. Restá cat abáy yehnáyqueyra. Cuacúr aba cuitar ayar bi istáyqueyra. Cuacúr aba icar cabar cab cuquíc istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Eyta cuar eyta rehquín cahmoran uwat baan as chiwa chajac ques ba ahár cac siáyqueyra. Caquir ruhw̃áyqueyra. Ruhw̃úr ba cahujín at icar wícayqueyra. Secuac usar cat, cárcel icar cat ahár si beyáyqueyra. As chihtá ques baan rey carin cac cahmar, gobernador cac cahmar beyáyqueyra. Eyta becayat eyin quino as chihtá ehcwáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Anto cabar tinti cuácayat Sir chihtá ay bi uw istiy quin, istiy quin, istiy quin, bahnaquin quin ehcwátaro. ");
INSERT INTO tuf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Uch chihtá tan chinti jaw̃i. Ba ahár si beyin cahmoran icúr wacátatara síhw̃ati jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eyta si bécayat ajmár chihtá ay bi ba quin wíquinro, -wajacro-. Ba ur icar bitara wacátatara ba quin ehcunro, -wajacro-. Aját eyta ehcwayat, ba quehsí bin bii wácajar rehcáyqueyra. Baat ay tew̃yat, éyinat ba ojcor ay bár bitách wácajatro, -wajacro, chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ba tetinát cat, rábinat cat, cáyinat cat, íw̃oquinat cat ba carin quin ahár si beyáyqueyra, -wajacro-. Eyinat ba eyta ruhw̃áyqueyra. Eyta cuácayat, uwat ba sicar bin cahujín cac beyar tíw̃ayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Baat as chiwa chaquic ques icar baan eyta quehswáyqueyra. Bahnáquinat ba eyta quehswáyqueyra ");
INSERT INTO tuf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Eyta cuar ba cuácajatro. Ba cuis anár úbistii chiw̃a báreyra, -wajacro, chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Baan eyta ruhw̃ata cuar, as chihtá wácati tan ucayat, Sirat ba síwayqueyra. Ima jor itay beyin síwaqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Eyta waquír acsar wajacro: —Soldádoan Jerusalén pueblo rúhracat bécayqueyra, -wajacro-. Eyta bécayat, baat eyta istír uch síhw̃awi: “Jerusalén uw sacan cab cucaro,” síhw̃awi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Baat eyta istír, Judea cajc cutar ítquinra cubar icar in ruhcuay béyataro. Pueblo cuitar éyinan pueblo acsar béyataro, -wajacro-. Acubar éyinra pueblo cuit sicor rauti béyataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Eyta rehquíc cab cucayat, uwat Sir tayar yajaquey ques cuécwayqueyra. Carit cuitar eyta rehcata cuihsú bahjáqueyan bahnác eyta yajquíc cuitar cab cuwáyqueyra, -wajacro, Jesusat chiwa quin-. Eyta bira cubar icar ruhcuay béowi. ");
INSERT INTO tuf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wiw̃ín istír bár eyin cat cuechú cuac sácayqueyra. Sasá sut ojcor bin abín cat cuechú cuac sácayqueyra. Cajc bahnác cutar uwan abáy ruhw̃áyqueyra. Sirat uwan abáy cuécwayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Uw cahujinra tec quejcayat tec icar sácayqueyra. Cahujinra ahár questa si beyáyqueyra. Cajc istiy cut, cajc istiy cut bahnác cut questa si beyáyqueyra, -wajacro-. Ey ricar judío bár bin Jerusalén pueblo cuitar to quiuwáyqueyra. Etar Jerusalén bahnác cun waátaro. Sirat uw eyin cajc istiy ayic ocso tas eyta quiuwátaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Eyta rehquíc cab cuanyat, rahs ajquír tehmótaro. Sihyór cat ajquír tehmótaro. Cuacúr aba cutara ub cat tehmótaro. Cuat cajc cutar yacúr tucur abáy chácataro. Yacúr ajcyaran oror curcur chácataro. Eyta cuácayat cajc cutar uw bahnaquin ehurún abáy jácayqueyra. Icurat eyta tehmóctara eyta réhctara istiti rehcáyqueyra. Istiti cuácayat, ojc sicátaro. ");
INSERT INTO tuf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ehurát uw sácataro. Uw bahnác cuácata istír ehurát sácataro, -wajacro-. Cuacúr abá cuitar bahnác yiwóyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Etat asan Uw Síuquib raquíc istáyqueyra. Bowarám tan cutar raquíc istáyqueyra. Urán to raquíc istáyqueyra. Rahs churotán wan Sir churot chi wan beo beo raquíc istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bahnác ajquír tehmóy yinyat, uchta síhw̃awi. As ba siway wiquin bar cab cucaro, síhw̃awi. Eyta sihw̃ar cue rehti jaw̃i. Cue rehti cuar cuisan acan cuacúr yehw̃i, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesusat ey chihtá siw̃in acu higuera caruc ojcor tew̃jacro. Uchta wajacro: —Higuera caruc tamo síhw̃awi. Caruc bahnác tamo síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Caruc cay sucoyat, baat ítitan, bara bar cab cucaro. Cuicara sucoyat, bara bar cab cucaro. ");
INSERT INTO tuf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eytaan wan, aját wacye bahnác eyta rehcayat, baat ítitan, Sira cara yehníc bar cab cu rehcaro. ");
INSERT INTO tuf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aját ba quin wacaro. Ah cut itquin bahnaquin sácati cuar, aját wacye eyta rehcáyqueyra, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Etar cuacúr abá cat, cajcan teyan bahnác bahnáyqueyra. Eyta cuar as chihtán bahnác queni íuti im eyta chácayqueyra. Bahná báreyra, wajacro Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Eyta cuácayat, ba yají chaw̃i. Ay sihw̃ar ítuwi. Simat cat yehnti ítuwi. Ira tamoa, oya tamoa cuít síhw̃ati jaw̃i, -wajacro-. Ey ójcora síhw̃ayeyra, ¿Sir ójcotra síhw̃ati waca téjeca? Baat as wícajar síhw̃ayat icar, ¿as wícajaqui? ");
INSERT INTO tuf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Uchtaan wanro. Ruwat quibachiti bár sihw̃ar, ey cahmar rauro. ¿Ba cat éytaan wan réhcajaqui? ¿Baat as wícajar síhw̃ayat icar as wícajaqui? -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eyta bira ba urá cuitar yají úrowi, -wajacro-. Etiti Sir ojcor conwi. Sirat ba cuitar wacayta acu conwi. Sir quin bara cuitar eyta cuati ben acu chiwi, -wajacro-. Asan Uw Síuquib wiquíc cahm rooti acu conwi, wajacro, Jesusat uw quino. ");
INSERT INTO tuf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Etan Jesusat Sir usar riy istiy, riy istiy síw̃jacro. Cuat chéycatra pueblo acsara bijacro. Olivo terá cuwayta bijacro. Erar cámjacro. ");
INSERT INTO tuf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chícrias cuitatra uwan to Sir usi sécuajacro. Jesusat waquíc rahcuín acu sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Etat owár pan buc rehti bi cohquíc fiesta yajquíc cab cutatro. Pan buc rehti cohquíc fiesta ajc istiyán Pascua fiéstaro. ");
INSERT INTO tuf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Etat sacerdote cárinat cat, bachan chihtán síw̃quinat cat Jesús yauwin acu ríojocro. Uw cahmar áywini rehquít, inara úrojocro. ");
INSERT INTO tuf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Etat Sisrám Satanás Judas ur icar raújacro. Judas eyan istiy ajc Iscariote aw̃ujacro. Eya Jesús ima chiwa doce sicar binro. ");
INSERT INTO tuf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas eyan sacerdótein quin bijacro. Cur sacerdótein owár tew̃jacro. Soldado carin owár tew̃jacro. Jesús eyin at icar bitara wícatatar chihtá tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eyta tew̃yat sacerdótein cat, soldado carin cat ahní rehjecro. “Bahat is at icar chácayat, isat ray túninro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Etar Júdasat eyta yajquín wajacro. Eyta waquír sacerdótein at icar bitara wícatatara ey úrojocro. Uwat istiti ac eyin at icar bitara wícatatara ey úrojocro. ");
INSERT INTO tuf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Etar fiesta pan buc rehti cohquíc cab cujacro. Obas sah yauwata cab cuanjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Obas sah yauwin cab cucayat, Jesusat Juanin Pédroin quin wajacro: —Fiesta cutar yayín ey bahnác wahnwi. Is cahmar wahnáy béowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eyta wacayat Jesús chiwat Jesús quin táyojocro: —¿Isat bahat cohn acu pan buc rehti bisar wahnátaqui? ¿Obas sah cat bisar wahnátaqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eyta wacayat, Jesusat wajacro: —Pueblo icar béowi. Pueblo icar rauyat ser istiy istáyqueyra. Rih soya ator bequic istáyqueyra. Ser ey istír, ey questoc béowi. Eya bi usi rauyat, ba cat esar rauwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Birar raúwictara ey ubach cayíb quin uchta waw̃i: “Is síw̃quibat uchta wac ayro: ‘¿As ba ubach cutar bi querat icar raúwataca? As ey sar ajmár chiwa owár pan buc rehti bi cohnro,’ wac ayro,” waw̃i. ");
INSERT INTO tuf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Baat eyta wacayat, eyat querat usi waanan cuít bi ehcwáyqueyra. Cuacúr ey ehcwáyqueyra. Ey sar ba icúr bi táyoctara ehcwáyqueyra. Im ey sar is cohn ac bahnác wahnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eyta wacayat chiwa eyin bar béjecro. Erar cur ítitan, Jesusat bitara istáy cuwata wajáctara, eyta istáy cujacro. Etar esar obas cat, pan cat wahnajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yaquic cab cucayat, mesa acor Jesusan ima chiwa owár ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Itir Jesusat chiwa quin wajacro: —Asan ba owár Pascua fiesta cuitar uchta yaya racar rehjecro. As yauwin inár ba owár uchta yaya racar rehjecro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ba quin aját wacaro. Bucoy aját uchta ba jor yaya báreyra. Pan buc rehti ba owár yaya báreyra. Sir iman cara yehníc ocso tas eyta yati chácayqueyra, -wajacro-. Sir cara yéhnyatan pan buc rehti cohquíc fiesta chihtá caba rehcátaro. Bahnác caba yajcátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eyta waquír toca yehw̃jacro. Toc icar chistár ub rihatro. Toca yehw̃ír Sir ojcor conjacro. Conár ima chiwa quin wajacro: —Ub rihar uchan behmár owár tahw̃uwi. ");
INSERT INTO tuf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aját ba quin wacaro. Aha yahncút chistár ub rihar uch bucoy aját yah báreyra. Sir iman cara yehníc ocso tas aját bucoy yah báreyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eyta waquír pan caquir, Sir ojcor conjacro. Conár cat, pan cotchacro. Cotír cat eyin quin wíjacro. Wiquir wajacro: —Uchan as sibatró. As sibarán ba siwin acu wíquinro. As tamo sihw̃an acu acsar eyta yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pan cohr car toca yehw̃jacro. Yehw̃ír chiwa quin wajacro: —Sirat bachan chihtán cahmar wajaquey acsar tehmón wacaro. As ab cut ba siwin wacaro. Eyta waquey uní rehcayta acu as ab béyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ahra istiyát asan cahujín at icar wícayqueyra. Eyta wícata eyan asi jor ira yácaro. ");
INSERT INTO tuf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sirat as eyta chinín wac báhjacro. Eyta cuar bíyatan as quehsuquin at icar as wícayat, eyan conú cuac chináyqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesusat “Istiyát as cahujín at icar wícataro,” wacayat, imár owár chiwat rahra rahra táyojocro. Biyat Jesusan cahujín at icar wícatatara, ey imár owár táyojocro. ");
INSERT INTO tuf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Etar cat Jesús chiwan imár owár rahra rahra tew̃ay yinjacro. Biyan caran cuít yehnátatar ey tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eyta tew̃yat Jesusat chiwa quin wajacro: —Judío bár bin cárinat imár chihtá uw quin yajc ayro. Eyta cuar eyin cárinat imár ojcor wacaro: “Asan uw obir yájquibro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Cuatán baatrá éytara yajti jaw̃i. Ba biyan caran cuítara, eyan sasán wan chácataro. Biyin uw ayquib rehcáyatan, eyan cahujín acu chiwan wan chácataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uwat ítitan, ¿Biyan caran cuitqui? ¿Ira yáqueyan caran cuitqui? -wajacro-. ¿Ira siir wiquib eyan caran cuitqui? -wajacro-. Uwat ítitan, ira yáqueyan cáraro. Eyta cuar asra ba owár rehcayat, asra ba ac ira siir wíquiban wanro. Chiwan wanro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Uwat as ruhw̃ujacro. As quehsujacro. Eyta cuar bara asi jor ítchacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","As Tetatán asan cara chájacro, -wajacro-. Aját uw ayin acu asan cara chájacro. Etar aját ba cat cácaro. ");
INSERT INTO tuf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","As cara rehquey cutar asi jor yayín acu, asi jor yahn acu cácaro, -wajacro-. Asi jor carin banco cuitar chihrín cácaro. Israelin urá istín acu ba cácaro. Israelin bomcar doce bin cohná bijaquin urá istín acu ba cácaro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chiwa quin eyta waquír, Pedro quin wajacro: —Simonu, Simonu, aját bah quin wacaro. Satanasat Sisramat ba bahnaquin uro istín chíjacro. Eyat ba cayar yajcátatara, cayar yájcajartara uro istín acu chíjacro. Eb rura uro istír eyta ba cat eyta uro istín chíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eyta chícayat, aját Sir quin bah cuitar conjacro, -wajacro, Jesusat Pedro quin-. Bahat as ojcor sehw̃ac etiti ac conjacro. As chihtá wácati acu conjacro. Etar bahat as ajcá bár waca téyqueyra. Waca ter sicor ajcá chi chácayat, bahat rabin quin siw̃i. As chihtá wácati cácayta acu siw̃i, wajacro, Pedro quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eyta wacayat Pédroat wajacro: —Caru, aját bah ajcá bár waca teya báreyra. Bah jor as cat cárcel icar chac tacat bah waca teya báreyra. As bah jor yauwata tacat, aját bah waca báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eyta wacayat Jesusat Pedro quin wajacro: —Pédrou, aját bah quin wacaro. Ah sisbúr anto cohwti cuat bahat wacáyqueyra: “Asra Jesús chíwai batro,” wacáyqueyra. Icar bayan eyta wacáyqueyra, wajacro, Jesusat Pedro quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Etar Jesusat chiwa quin wajacro: —Aját récaji baan as chihtá ehcwáy áyjacro. Eyta ayat ¿baat icúr táyoyi? Aját ba ucua bár, iroc bár, ques barcát bár áyatan, ¿baat icúr táyoyi? wajacro, chiwa quin. Wacayat chiwat wajacro: —Icrí táyotiro. Is yarsa obir yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eyta wacayat, chiwa quin wajacro: —Cuatán ahra ucua che binat ucua ji béowi. Iroc che binat cat iroc chi béowi. Espada bár binat ima siricách tehmár cuit espada wawi. ");
INSERT INTO tuf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aját ba quin wacaro. Uchicrias Sir carit cuihsú báhjacan, ahra ey chihtá yajquíc cab cujacro, -wajacro-. As ojcor uchta cuihsú báhjacro: “Uwat ur ay bár bin tamo sihw̃ar eyta ey tamo cat eyta síhw̃aro,” cuihsú báhjacro, as ojcor. As ojcor eyta cuihsú báhjacan eyta rehquíc bar cab cucaro, wajacro, chiwa quin, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Etat chiwat wajacro: —Caru, espada bucáy usatro, wajacro. —Ihyú, eyan toro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Etar Jesús ima chiwa owár watar waajacro. Watar waar Olivo terá icar cuwín béjecro. Jesusan búcoyan búcoyan erar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Beyar erar cur car, Jesusat chiwa quin wajacro: —Sir ojcor conwi. Sisramat ba quin ur ay bár yajc ayti acu conwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Eyta waquír, acsar biráy bár cuitar bijacro. Bir erar Sir ojcor conín acu cuscar cuitar chihrjacro. Chihrír Sir quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Tetú, bahat as conquey rahcuí cúntara uchta yajw̃i. Uw quin as yau ayti jaw̃i. As yauti yarsa waátatara, as yau ayti síuwi. Aját eyta conic cuar, as chihtai yajti jaw̃i. Behmá chihtá cutar yajw̃i, wajacro, Sir quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sir quin conyat, Sir cuacúr cacúm Jesús quin wijacro. Wiquír Jesús quin chihchír wíjacro. Canar wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Eyta cuar im ur icar cuean toro. Cuean eyta rehquít cuít conjacro. Eyta conár, rihramat bahnác bo sujacro. Rihram eyan aban wan ic icar tijcajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Etar bahnác cona waar Jesús sicor ima chiwa quin bijacro. Eyin quin cur itit, cam sácajacro. Cueat cuácayat bar cámjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eyta istír, Jesusat eyin quin wajacro: —¿Bitara reht camqui? Cui yinwi. Sisramat ba quin ay bár yajc ayti acu conwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesusat echí tew̃yat icar, uw ricán séhw̃anar bin béjecro. Ser ajca Judas cat wijacro. Judas eya Jesús ima chiwa doce sicar binro. Eyat cahujín si rojocro. Júdasat cahujín roquír car, ac suhwín acu Jesús acor wijacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Eyta cuar Jesusat Judas quin wajacro: —Júdasu, ¿As ac suhwír cuitar bahat asan Uw Síuquib cahujín at icar wíquinica? wajacro, Jesusat Judas quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús ecsar éyinat eyta yajquíc itchacro. Istír, “Jesús bar cuácataro,” síhw̃ajacro. Eyta sihw̃ar wajacro: —Caru, ¿Isat espada cuitar técuataica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eyta wacayat, chiwa istiyát sacerdote cara cacúm istiy bujacro. Sacerdote cara cacúm cucách cuijacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eyta cuicayat, Jesusat ima chiwa quin wajacro: —Eytara yajti jaw̃i. Chaw̃ jaw̃i, wajacro. Jesusat eyta waquír, sacerdote cacúm cucách cuijaquey sicor bar órojocro. Cuiti bin eyta sicor bar anjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Anir sacerdote carin quin, Sir usar policíain quin, werjayín quin, ima cacay rojoquin quin wajacro: —Baat besin caquir eyta caruc jaw̃, espada jaw̃ as eyta cacay rojocro. ¿Bitara reht eyta royi? ");
INSERT INTO tuf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aját riy istiy, riy istiy Sir usi ba ubot síw̃jacro. Eyta cuar, baat erar as cátiro. Eyta cuar ah chéycatra baat behmár chihtá yajquín acu Sirat ajc waajacro. Sisrám checúm cuitar yajc áyqueyat ima chihtá yajquíc cab cujacro, wajacro, Jesusat sacerdótein quin. ");
INSERT INTO tuf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Etar éyinat Jesús caquir ahár béjecro. Sacerdote cara usi cuwín béjecro. Cur ey sar raújacro. Pedro cat eyin questoc birá cuít cuar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sacerdote usi ubach tan sar awat cuitar uwat oca ánjacro. Anyat cahujín oca rúhracat chihr bejecro. Etar Pedro cat cur oc acor eyin owár chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Erar chihryat, oca sir acor ityat, cacúm cahbarat itchacro. Ay wahitír wajacro: —Ser uch cat Jesús chíwaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Etat Pédroat wajacro: —Wiw̃ú, asra ey chíwai batro. Aját eyra istiti binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Etar in cuácayat, istiyát cat Pedro istír wajacro: —Bah cat ey chíwaro, wajacro. Etat Pédroat wajacro: —Batro. Asra ey chíwai batro. ");
INSERT INTO tuf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Etar ítchareht istiyát cat Pedro ojcor uw quin wajacro: —Uy cat Jesús chíwaro. Ajatán itro. Uy cat Galilea úwcuano, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Waquít, Pédroat wajacro: —Bahat bi ojcor tew̃íctara, aját istítiro. Ráhctiro, wajacro, Pédroat. Eyta wacayat acat, cab rehti, sisbúr bar cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Cohwyat, Jesusat ac wari cuar, Pedro itchacro. Ityat Pédroat séhw̃ajacro: “Aját anto eyta tew̃ti cuácayat, aját eyta tew̃ata Jesusat ehcujacro: ‘Cohcarám cohwín cahmor bahat as ojcor “asra ey chíwai batro,” wacáyqueyra. Icar bay eyta wacáyqueyra.’ Jesusat as quin eyta wacárora,” séhw̃ajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jesusat wajác tamo sehw̃ar Pedro watar waajacro. Watar waar abáy ojocro. ");
INSERT INTO tuf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Etar polcíainat Jesús buror sischacro. Sisír, ");
INSERT INTO tuf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","oya cumar cuitar ub ey cay questajacro. Cay questár aquey cutar tajacro. Etar wajacro: —Werjayú, bah biyat tajquíctara is quin ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eta jaw̃ Jesús buror sisín acu bucoy bucoy ajca ahsín bitara útara tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Etar bar cuanyat, judío werjayín bahnác sécuajacro. Sacerdote carin cat, bachan chihtán siw̃quin cat eyin owár sécuajacro. Eyin eyta secuar Jesús eyin quin rojocro. Roquír Jesús quin táyojocro: —¿Bahan Crístoiqui? ");
INSERT INTO tuf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bah Crístotara, ey bártara is quin ehcuwi, wajacro. Etat Jesusat wajacro: —Aját ba quin “asan eyro,” ehcwayat as chihtá cácajatro. Asan ey síhw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aját ba quin bitara táyoyat, baat as quin ehcuti jácataro. ");
INSERT INTO tuf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eyta cuar ah yahncút asan Uw Síuquib cuacúr Sir owár ítayqueyra. Sira urán to bi ecor chihráyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Etar bahnáquinat wajacro: —¿Eytair bahan Sir waquíj waátaqui? wajacro. —Baat wáqueyan asan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Etar éyinat wajacro: —Ey cahm icar tew̃quin ahra istiy táyotiro. Imát is cucajá ácatan Sir ojcor téw̃ajar bin tew̃jacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Etat sécuajaquinat Jesús bar béjecro. Beyan romano gobernador ajca Pilato quin cujacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cur car Pilato quino Jesús cahm icar uchta wajacro: —Isat ítitan, ser uchat is uw bahnaquin quin gobierno chihtá cac ayti síuro. Uyatan gobierno tayar is uw quin tun áytiro. Rey cara César tayar tun áytiro. Uyat wacaro: “Asan Crístoro. Rey cáraro,” wacaro. Uyat sucuar eyta tew̃ro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wacayat, Pilátoat Jesús quin wajacro: —¿Bahan judío cáraica? ¿Judíoin réyica? wajacro. Etat Jesusat wajacro: —Ee, bahat táyocan cábaro. Asan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilátoat sacerdote carin quin, ricá quin wajacro: —Aját ítitan, eyat ay bár bitarach yájtiro, wajacro, Pilátoat. ");
INSERT INTO tuf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eyta waquít éyinat bucoy wajacro: —Gobierno chihtá cat cac áytiro. Uyat judea cajc bahnác cuitar eyta tew̃jacro. Galilea cajc bahnác cuitar eyta tew̃jacro. Uch cajc cuitar cat eyta tew̃jacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilátoat eyta tew̃íc rahcuír táyojocro: —¿Jesús Galilea úwica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Táyoyat, uwat wajacro: —Ey erar bíncuano, wajacro. Galilea cajc cut bin wacayat, Pilátoat séhw̃ajacro: “Uyra Herodes cajc cut bin etar ay bár yajáctara Heródesat ey urá wahitata binro,” séhw̃ajacro. Ey rícaran Heródesan Jerusalén cuitatro. Eyta cuácayat Pilátoat Herodes quin cuwayta Jesús bey áyjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Etar eyta beyan Jesusan Herodes quin cucayat, Herodes ahní rehjecro. Heródesat Jesús istiti bin chihtara ey it cun rehjecro. Uchicri ey istá racar rehjecro. Heródesat Jesusat yajquíc ojcor tew̃ic rahjacro. Etar Jesusat Sir urá cut icúr bi yajquíc it cun rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Etar Jesús cucayat, Heródesat Jesús quin chiht istiy, chiht istiy táyojocro. Eyta táyoyat, Jesús ajc chin jájacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sacerdote carin cat, bachan chihtán siw̃quin cat ésatro. Esar cuar Jesús cahm icar Herodes quin abáy tew̃ay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heródesat cat, soldádoinat cat Jesús abáy ruhw̃ujacro. Ey buror abáy sischacro. Eyta sisír éyinat Jesús ojcúm carin oya tas chájacro. Chaquir Jesús sicor Pilato quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Beyir yahncút Pilato cat, Herodes cat rahra rahra íw̃ojocro. Cahmotra rahra rahra quehsí bin ey ricar íw̃ojocro. ");
INSERT INTO tuf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Heródesat Jesús Pilato quin sicor ayir car, Pilátoat sacerdote carin, werjayín, uw bahnaquin sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Secuar Pilátoat eyin quin wajacro: —Baat ser uch as quin rojocro. Roquír “Eyat uw quin gobierno chihtá yajc áytiro,” wajacro. Aját ey quin tayo rahcuítchacro. Ba cac cahmar eyta tayo rahcuítchacro. Eyta tayo rahcuitit, Jesusat ay baran icuri yájtiro. Baatán ey cahm icar tew̃jaquey eyat éytai yájtiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heródesat itit cat éytaro. Etar sicor áyjacro. Aját wacaro. Jesús cahm icar baat eyta tew̃íc cuar, aját itit bi chihtá quesi ícari yaúwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Eyta bijira aját ey chistár cuitar buc áyinro. Buquír cuitar uc áyinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilátoat fiesta cuitar bucoy bucoy uw cárcel sar bin uc áyjacro. Eyta cuácayat, Pilátoat Jesús eyta uc ayin wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilátoat eyta wacayat, uw bahnáquinat cohwjacro: —Isat eyra rácari batro. Is acu Barrabás cárcel sar bi uw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás eyan uw tiw̃jac biro. Eyat gobierno owár tec quej yehnjáquinro. Uw tíw̃jacro. Jerusalén pueblo cuitar eyta yajacro. Ey ques icar cárcel icar tunjác biro. ");
INSERT INTO tuf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Uwat Barrabás uquin cohwíc cuar, Pilátoat Jesús uc cun rehjecro. Etar uw quino Jesús uc ayin wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Eyta wacayat, uwat rahra ey quin cohwjacro: —Eyra yauwin caruc ojcor quejcátaro. Yauwin caruc ojcor quejcátaro, cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Etar Pilátoat icar bawoy wajacro: —¿Icrát yauwátaca? ¿Icúr yajác ques icar yauwátaca? Icúr quesi yaúwajatro. Eyta bijira aját buc ter cat uc áyinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pilátoat uw quin eyta wajác cuar, uwat ey chihtá cátiro. Cati cuar Jesús yauwin acu cuít cohwjacro. Bucoy bucoy cohwjacro. Cárucui icar quejquín acu cohwjacro. Eyta cohwíc cuitar burbar yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eyinat eyta cohw chícayat, Pilátoat eyta yajquín ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Cuatán cárcel sar Barrabasra bar uc áyjacro. Técuasibra uw tíw̃quibra bar uc áyjacro. Uwat chiquey bar uc áyjacro. Barrabás uc ayir Jesús uw at icar wíjacro. Uwat Jesús yauwin wacayat, Pilátoat bar ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pilátoat Jesús yauwin acu ajc waacayat, Jesús bar béjecro, yauwin acu. Bécayat ibt aw̃at ser istiy ajca Simón ahár cájacro. Simón eya cajc ajc Cirene binro. Uw bár cuitar bin ácubar cuitar bin racaro. Caquir Jesús quejquín ac caruc bequey ahár yehw̃ áyjacro. Caruc ey cuitoc cuit chájacro. Chácayat Simonat Jesús questoc yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesús questoc cat uw ricán séhw̃anar béjecro. Wiw̃ín cat beya rabar Jesús séhnareht ojocro. Cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eyta istír, Jesusat eyin quin wajacro: —Jerusalén wiw̃inu. As racar oti jaw̃i, -wajacro-. Cuatán behmár cuitar, behmár sasá cuitatrun uní ótaro. ");
INSERT INTO tuf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Riy istiy cuitar behmár ay bár ruhw̃úc cuitar cuanátaro. -wajacro-. Eyta cuanyat uwat wacátaro: “Sasá bár éyinwan ohbac rehcaro. Wiw̃inat sasá cohnti éyinra ohbac rehcaro. Sutá bi quínoi wícajar éyinwan ohbac rehcaro,” wacátaro, ");
INSERT INTO tuf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eyta waquíc cab cucayat, “Siyó is arcutar tijcawi,” wacátaro. “Cúbarat is bahnác tiw̃ anwi,” wacátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Asan caruc túmaran wan cuar, as uchta ruhw̃uqueywat ba caruc íncuatan wan éyinan cuít ruhw̃áyqueyra, wajacro, Jesusat wiw̃ín quin. ");
INSERT INTO tuf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesús soldádoat yauwin bécayat, cahujín urá ay bár bin cat béjecro. Besin bucáy bin béjecro. Jesús owár yauwin acu béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Béyeyan terá cutar cujacro. Terá ey ajcan cuisa cárara aw̃ujacro. Terá cutar cucayat, soldádoinat Jesús yauwin caruc ojcor quejecro. Jesús caruc ojcor quejquír cat, cuic rahray wihár caruc istiy ojcor besib istiy, cuic rahray wihár caruc istiy ojcor cat besib istiy quejecro, yauwin acu. ");
INSERT INTO tuf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eyta quejcayat, Jesusat ima yauquin cuitar Sir quin conjacro: —Tetú, as yauwic tayar ques eyin cuécuti jaw̃i. Eyinat istiti cuar yajcaro, wajacro, Jesusat Sir quin. Jesús caruc ojcor quejquír, soldádoinat Jesús oyan imár owár tahw̃ujacro. Taw̃a rabar biyat bi oya cácatatara ey istín acu at sínjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Caruc ojcor quejcayat, cahujínatra wahitchacro. Judío cárinat Jesús buror sischacro. Sisá rabar wajacro: —Eyat cahujín yarata cahm síujacro, -wajacro-. Ahra ima cat síwataro. Eyan Sir imáy Crístoir waquít, ima bar síwataro. Sirat ey áyjaquir waquít, ima síwataro, wajacro, Judío cárinat. ");
INSERT INTO tuf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldádoinat cat ey buror sischacro. Ey cac cahmar bir, chistár rihar bacua ihirán to bi ey acat tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Eyta ruhw̃úr car ey quin wajacro: —Bah uní judío reytar, caruc ojcor quejequey bahan ic oso car raw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús cuis aracat carit cuihsúr chájacro. “Uchan judíoin rey cáracuano,” cuihsúr chájacro. Hebreo cuw cutar cat, latín cuw cutara cat, griego cuw cutara cat eyta cuihsúr chájacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jesús ecor quejéc eyat Jesús quin tecua rabar wajacro: —Behmán Crístotara behmá síuwi, -wajacro-. Behmá siwir is cat síuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Cuat rahr owár wihár quejéqueyat eyta tew̃quey quin wajacro: —Eytara wati jaw̃i. ¿Bah bitara reht Sir cahm ayú báriqui? Bah catum ey owár yauwin acu quejecro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Isra ijmár oquís yauro. Ijmarat ay bár yajác etar ey tayar ques yauro, -wajacro-. Eyta cuar úyatra ay batra yájtiro, wajacro, istiy besib quino. ");
INSERT INTO tuf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Etat Jesús quin wajacro: —Jesusu, bah cara rehquey cutar cucayat, as tamo cat séhw̃awi, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Etat Jesusat wajacro: —Aját bah quin wacaro. Ahan bahan asi jor cuacúr Sir jor jácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesusat eyta wacayat, rahsan uraró. Rahsa urá cuaquir, chéycara eyta cay tínjacro. Rahs buya tas eyta tínjacro. Cajc bahnác cuitar eyta tínjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Rahsa eyta tinyat, Sir usi oya wiricás rújaqueyan ima ubut oso rach bijacro. Rach biran cay bucáy waajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Etat Jesusat ay bar cohwjacro. Uchta wajacro: —Tetú, as ajcan bah at icar wícaro, wajacro. Eyta wac cohwír bar chinjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jesús eyta cohwír chinyat, soldado carat itchacro. Istír Sir tamo ay séhw̃ajacro. Eyta sehw̃ar, wajacro: —Ser eyat bitarach yájtiro. Eyat ay bár icurí yájtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jesús chinyat, uw ricá sicor usi bahnác suca bijacro. Bahnác eyta rehjequey istír, beya rabar, cue rehquír imár tan cut bujacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesús íw̃oquinat cat, Jesús owár Galilea cuitar bin rojoquin wiw̃inat cat bar itchacro. Jesús yauwic itchacro. Birá cuit cuar wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jesús chinyat ser ajcan Joseat itchacro. José pueblo Arimatea ítquincuano. Arimatea judíoin puéblocuano. José ur ay biro. Eyat ur ay yajcaro. Judío werjayín owár sécuaro. ");
INSERT INTO tuf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Judío werjayinát Jesús yauwin síhw̃ayat, Joséatra eyta séhw̃atiro. Eyta yájtiro. Cuatán Sir cara yehníc acor itro. ");
INSERT INTO tuf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Joseat Pilato quin Jesús chinjaquey chein chiay bijacro. Ruhcuín acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato quin cur, eyta chíjacro. Chícayat, Pilátoat ajc waajacro. Ajc waacayat Jesús chein caruc ojcor quejéc Joseat tijcajacro. Tijcár lienzo wiricás tamo bacojocro. Jesús chein wiricás tamo bacór béjecro. Beyar ac ucar icar ruhjacro. Ac ucar ey icar chein anto ruhcti biro. ");
INSERT INTO tuf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesús chein ruhcuíc tínoran tan jaquin acu oroc ricar tínjacro. Im ey tínoan tan jaquic ricar rauwi cuitatro. ");
INSERT INTO tuf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Erar ac ucar icar chácayat, Galilea wiw̃inat úrojocro. Jesús chor Galilea bin rojoquin wiw̃inat Jesús chein bisar chactar itchacro. Ac ucar sar chajac itchacro. ");
INSERT INTO tuf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Eyta chaquic istír car, sicor pueblo cuwín béjecro. Pueblo cur Jesús chein cuitar chaquin acu inan ay bi órojocro. Polmadan wan cat órojocro. Etar tan jaquin ricar rauyat wiw̃ín eyin tan jájacro. Eyta tan jaquin acu wac báhjaquey éyinat wácati yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Etar semán istiy rauyat, wiw̃inan Jesús ruhjác cuitar béjecro. Chícrias uti bicayat cuan bicayat, béjecro. Inan ay bin órojoquey béjecro, Jesús chein cuitar chaquin acu. ");
INSERT INTO tuf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Beyar cur ítitan, ac ohná chein ruhjác ucar cutar tunjaquey waa tejec itchacro. Sicor bar wácajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eyta istír ucar sar raújacro. Rauwir itit, Cara Jesús chein ruhjacan ésari batro. ");
INSERT INTO tuf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chein bár cuácayat, “chein bitara yajcyi,” séhw̃ajacro. Eyta séhw̃ayat, serin bucáy eyin ecsar waajacro. Ser eyin oya wan beo beo bi tasro. ");
INSERT INTO tuf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wiw̃inat eyin istír oc sijacro. Ay wini rehjecro. Ay wini rehcayat, cuisa ica cut bahu jájacro. Eyta jácayat, sérinat eyin quin wajacro: —¿Baatán bitara reht chein ruhcuíc cuitar estají bin uroy bequi? Estají binra chein ruhcuíc cuitatra batro. ");
INSERT INTO tuf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesusra usari batro. Sicor estají yehnár bijacro, -wajacro-. Anto Galilea jácayat, behmár quin chihtá wac báhjacro. Eyta wajác tamo síhw̃awi: ");
INSERT INTO tuf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Asan Uw Síuquib uwat cahujín at icar wícataro,” wajacro, Jesusat. “Ur ay bár bin at icar wícayqueyra. Wícayat, caruc ojcor quejquír yauwáyqueyra. Yauyat ruhcuír car, bay cuanyat sicor yehninro,” wac bahjacro, Jesusat. Eyta wac bahjác tamo síhw̃awi, wajacro, sérinat wiw̃ín quin. ");
INSERT INTO tuf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eyta wacayat, Jesusat im ojcor ehcú báhjaqui tamo bar síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Eyta sihw̃ar, chein ruhcuíc cuitar bin sicor bar béjecro. Beyar car, Jesús chiwa quin bahnác ehcujacro. Cuisa once bin quin eyta ehcujacro. Cahujín quino cat ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Eyta istír ehcwáy béjequinan wiw̃ín istiy ajca Maríacuano. Eya Magdala binro. Istiy ajca Juánacuano. Istiy cat ajca Maríacuano. Eya Santiago abró. Cahujín cat eyin owár béjequinat cat Jesús chiwa quin eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chiwa quin ehcujác cuar uní tew̃ti síhw̃ajacro. Etar chihtá cátiro. ");
INSERT INTO tuf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Cuatán Pedro bar yehnár quinjacro, chein ruhjác ac ucar cuitar cuwayta. Cur car bahujacro. Bahúr ac ucar icar wahitchacro. Ititan, lienzo oya Jesús bacojocra ératro. Oyaro. Chéinra batro. Jesusra batro. Etar sicor bijacro. Bahnác eyta itchaquey tamo sehw̃a rabar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ey ricar chiwa cuisa bucáy bin béjecro. Pueblo istiy ajca Emaús cuwín béjecro. Jerusalén cuar Emaús cuwaycan once kilómetroro. ");
INSERT INTO tuf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Beya rabar Jesús chinjác chihtá imár owár tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jesús chinjác chihtá tew̃yat icar Jesús ima eyin ecsar waajacro. Waar eyin owár bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eyta cuar éyinat Jesusan rehrtár bitách ístajar rehjecro. ");
INSERT INTO tuf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Etat Jesusat eyin quin wajacro: —Ba beya rabar, ¿icúr chihtá tew̃ca? wajacro. Jesusat eyta wacayat, beti inic ítchacro. Cueat ajc yehw̃ti ítchacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eyta bequin istiy ajcan Cleófasat wajacro: —¿Bahat istítiqui? Baquír, bonir, bacar Jerusalén cuitar yajacra istítica. Jerusalén béhjequinat bahnáquinat itro. ¿Bah ístirat eyta yajáqueyan istítiqui? táyojocro, Cleófasat. ");
INSERT INTO tuf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Icúr yajaca? wajacro, chiwa bucáy bin quin. —¿Bahat Jesús istítiqui? ¿Nazaretin istítiqui? -wajacro-. Eya Sir chihtá béquibro. Eyata ima urán to cuitar chihtá ehcujacro. Ima urán to cuitar ay yajacro, -wajacro-. Sirat itit cat, uwat itit cat éytaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eyta cuara is sacerdote cárinat cat, is werjayinát cat Jesús cahujín at icar wíjacro. Eyinat yau ayin acu eyin at icar wíjacro. Etar Jesús yauwin ac caruc ojcor quejecro, -wajacro, chiwat Jesús quin-. ");
INSERT INTO tuf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Isat síhw̃ajacan: “eyat israelin cuitar wacata,” síhw̃ajacro, wajacro. Cleófasat Emaús ibt aw̃at eyta wajacro. ’Etar cat ahra Jesús yaujacan bay cuanjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Cuatán is owár wiw̃inat is ojc sijacro. Wiw̃inan chícrias cuitar chein ruhcuíc cuitar itay béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Erar beyar cur itit, chéinra istiti rehjecro. Etat sicor rojocro. Bequír, is quin wajacro: “Isat Sir cuacúr cacmín itchacro,” wajacro. “Sir cuacúr cacminát is quin wácuayra: ‘Jesús estajiro. Yártiro. Sicor bar yehnjacro,’ wácuayra, Sir cacminát.” ");
INSERT INTO tuf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wiw̃inat eyta wacayat is owár sérinat cat chein ruhcuíc cuitar wahitay béjecro. Beyar cur itit, wiw̃inat uní wajacro. Eyta cuar Jesusra istiti rehjecro, wajacro. Cleófasat Emaús ibt awat Jesús quin istiti rabar eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eyta wacayat, Jesusat eyin quin wajacro: —Baatán urá bár binan wan tew̃ro, -wajacro-. Baatrá Sir chihtá ehcúquinat úchicri cuihsujác uní síhw̃atiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristo eyta chinata wac báhjacro. Eyta chinír búcoyra cuacúr Sir jor cara yehnátaro, wajacro, chiwa quin ");
INSERT INTO tuf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesusat eyta waquír car récaram cuihsú bahjác chihtá ehcujacro. Moisesat cuihsú bahjác cat, Sir chihtá ehcuquin cahujinat cuihsú bahjác cat bahnác ehcujacro. Récaram im ojcor cuihsú bahjacan bahnác ehcujacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eyta ehcwá rabar bécayat, pueblo intac cujacro. Pueblo intac cucayat, Jesusra acsar ben yajquín eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Etat éyinat imár owár yayín acu camín acu acsar bi ayti síujacro. —Is owár camwi. Ahra bar tínjacro, wajacro. Anto Jesús istiti rabar eyta wajacro. Eyta wacayat, eyin owár raújacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rawitrun eyin owár yayín acu chihrjacro. Chihrír Jesusat pan ator yehw̃ír, Sir ojcor conjacro. Conár pan cotchacro. Cotitrun, owár tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tahw̃uyat, éyinat ítitan, Jesusro. Orac istata rehjecro. Eyta rehquír Jesús itchacro. Eyinat Jesús ityat, Jesús sicor istiti siw̃ajin jájacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Etar éyinat rahra rahra wajacro: —Ibt aw̃at is quin tew̃a rabar rocayat, is ur icar ahní rehjecro. Is quin récaram úchicrias cuihsú bahjác chihtá ehcwayat, is ur icar ahnian to rehjecro, wajacro. Cleófasat istiy chiwa jor rahra rahra eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Etat eyin sicor Jerusalén inchásarac yinír béjecro. Erar cur itit, chiwa once bin bar sécuajacro. Chiwa cahujín owár sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Secuar wajacro: —Uní wacaro. Cara Jesús sicor bar yehnjacro. Simón ub acat waajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Etat éyinat cat ibt aw̃at imarat itchac ey ehcujacro. Chihtá tew̃jác rahcuír ahní rehjéc ey ehcujacro. Beyar usi cur pan cotchác ey ehcujacro. Cotír tahw̃ujác ey ehcujacro. Eyta tahw̃uyat, Jesús rehrtár itchác ey ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eyta tew̃yat icar, Jesús eyin ubot waajacro. Waar, eyin tac icar chaquir, “ohbac rehw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jesús waacayat, chiwa oc sijacro. “Chein ajca wiquíc” sihw̃ar oc sijacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Etat Jesusat eyin quin wajacro: —Oc siti jaw̃i. Rooti jaw̃i. ¿Bitara reht as sicor yehnjác síhw̃atica? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","As atcar wahítuwi. Quescar cat wahítuwi, as sicor estají yehnjác istín acu. As catowi. As bútawi. Butar as sicor estají yehnjác istáyqueyra, -wajacro-. Chein ajcra sibár batro. Cárara cat batro. Cuatán asra chero. Etar as butar as sicor estají yehnjác istáyqueyra, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eyta waquír, ima quescaran, átcaran bahnác eyin quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Quescaran, átcaran eyta ehcúc cuar, éyinat anto sicor estají yehnjác síhw̃atiro. Ahní tahnác cuat uní cati síhw̃ati chájacro. Eyta rehcayat, Jesusat eyin quin wajacro: —¿Ira yayín acu chéica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eyta wacayat, éyinat rih ruwa wahnajacan wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wícayat, Jesusat ey caquir chiwa ubot cohjocro. ");
INSERT INTO tuf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Cohr car eyin quin wajacro: —Récaram anto chinti cuatán, aját ba quin as chinír sicor estají yehnata ehcujacro. Uchicrias Moisesat récaram as ojcor cuihsú bahjác ehcujacro. Moisesat as ojcor cuihsú bahjác bahnác uní rehcátaro. Sir chihtá ehcúquinat cat as ojcor bitara cuihsú bahjactar eyta rehcátaro. Carit Salmo icar cat as ojcor bitara cuihsú bahjactar eyta rehcátaro -wajacro-. Aját récaram ba quin eyta ehcujacro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eyta waquír úchicrias cuihsú bahjác chihtá Jesusat ima chiwa quin rahcua áyjacro. Rahcuín acu urá wíjacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Eyinat rahcuayta acu uchta wajacro: —Uch cuihsú báhjacro. Asan Crístoan yauwata cuihsú báhjacro. Yauwir bay cuanyat, sicor yehnata cat cuihsú báhjacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","As ojcor uw bahnaquin quin ehcwata cuihsú báhjacro. As ojcor ehcwá rabar uchta wacátaro: Sir tayar yajác ojcor cue rehw̃i. Cue rehquír etwi, wacátaro. As chinjác etar, Sir tayar yajquey ojcor cue rehcayat, Sirat sicor tayar bár chácaro, wacátaro, -wajacro Jesusat-. Jerusalén cuitar récaji ehcwátaro. Yahncút uwa bahnaquin quin ehcwátaro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Baatán behmár ub cut itchacro. Behmár cucách cut rahjacro. Baat itchaquey rahjaquey acsar cahujín quin yarsa ehcwátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Uch rahcwi. Sirat Tetát ba ur icar ima Ajcan Camur Eya chaquin wajacan aját ba ur icar cháquinro. Eyta chac ocso tas ba pueblo cuitar ítuwi. Ajcan Cámuran Eya cuacúr bin wicata ey ba ur icar chac ocso tas ítuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eyta waquír, chiwa Jerusalén bin acsar béjecro. Bir Betania pueblo cujacro. Jesús Betania Pueblo cur atcar cuacúr yehw̃jacro. Yehw̃ír chiwa cuitar Sir quin conjacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eyin cuitar cona rabar, eyin cha bahjacro. Cuacúr abá icar bijacro. ");
INSERT INTO tuf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesús cuacúr abá icar bicayat, éyinat wajacro: “Jesús urán ayro. Jesusan ayro,” wajacro. Etat sicor Jerusalén cun béjecro. Ahní béjecro. ");
INSERT INTO tuf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jerusalén cutrun cuanmí cut cuanmí cut Sir usi béjecro. Sir úsara bucoy, bucoy wajacro: “Siru, bah ur ayro. Bahat is obir yajacro,” wajacro.");
INSERT INTO tuf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sira bitáratara, icúr yájctara, ima wacját bahnác ehcuro. Récaram anto cajc chati cuat Sir wacjá ésatro. Eyan Sir jor ítchacro. Eyan Sir im owáraro. ");
INSERT INTO tuf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Récaram echian eyan Sir jotro. ");
INSERT INTO tuf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eyat bahnác waquír chájacro, Sir chihtá cut. Chájaquey, cuanjaquey, Sirat ey bár cuatra icrí chátiro. Bahnác eyat waquír chájacro, Sir chihtá cut. ");
INSERT INTO tuf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sir ima wacjá chihtá cut uwa ohbac etiti itro. Eya ohbac it áyqueyro. Ohbac it áyqueyat uw quin urá wícaro. Urá wícayat eyin ur icar cuanír éytaan wan chácaro. Urá wíqueya, cuan áyqueyro. ");
INSERT INTO tuf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Checúm tinyat uwat ístajar eyta Sisramat uw urá bár chácayat eyta ístajatro. Uwat ístajar cuácayat urá wíquibat cuan áyquibat uw quin urá wícaro. Urá wícayat Sisramat urá wiquib burbar yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sirat ser istiy áyjacro. Ser ey ajca Juáncuano. ");
INSERT INTO tuf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sirat ima wacjá ojcor tew̃ín acu Juan áyjacro. Sirat ayat Juan yehnjacro. Bahnáquinat urá wiquib ojcor rahcuín acu Juanat tew̃ay yehnjacro. Uwat urá wiquib tamo sehw̃ay yinayta acu yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanra cuan áyqueyi, urá wíqueyi batro. Urá wiquey ojcor tew̃ay yehjáquinro. ");
INSERT INTO tuf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cuan áyquiban, urá wíquiban cajc uch cutar rajacro. Urá wiquib quéneyro. Ey wicayat uw bahnaquin quin urá wícaro. ");
INSERT INTO tuf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Eya Sir ima waquijiró. Ey ajca Jesucrístoro. Jesucristo yehnár cajc uch cutar ítchacro. Eyat cajca waquír chájacro, Sir chihtá cut. Cajc chajac cuara, cajc cutar ítquinat eyat cajc chajac síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ima cajc cut wijacro. Ima cajc cut wijác cuara, im uw bahnáquinat ey quin ténatiro. Ajcá ji bétiro. ");
INSERT INTO tuf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Cahujinat ey quin ténajacro. Ajcá ji béjecro. Ey tamo síhw̃ajacro: “Eya is Síuquibro,” síhw̃ajacro. Bíyinat eyta síhw̃ajactara Sirat eyin ima sasá waan acu ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sasá ab ohc cut bin yehnár eyta Sir ima sasá waan acu éytara yéhntiro. Uw tetát wiya ohc cut sasá cohnár éytara cóhntiro. Sir ima sasá éytara waátiro. Sir ima urá cut ima sasá waacaro. ");
INSERT INTO tuf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sira bitáratara bahnác ehcuquib ima cajc cut wiquír uw waajacro. Uw ohc cut yehnjacro. Yehnár is owár ítchacro. Is owár ityat isat ítitan, ey ayan tahnacro. Sir Tetá ima wacjá istanác biro. Eyta rehquít ayan tahnacro. Isat ey itchacro. Ititan, wacját uw sehnár yajc báhnajatro. Eyat uní tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan yehnár ey ojcor tew̃jacro. Juanat cohwjacro: —Uchan eyro. Aját as yahncút wiquín wajacan uchan eyro. Aját wajacro: “Eyra as yahncút wicata cuara, eyra ayan as cuitro. As anto yehnti cuat eyra Sir jor chájacro. Etar ayan cuitro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eyat is sehnár yajc étajar rehquít is bahnaquin acu ay yajacro. Bucoy cat, bucoy cat is acu ay yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sirat Moisés cut cuar bach cáritan, chihtá cáritan wíjacro. Moisés cut cuar bach wijac cuara Jesucrístoat ajc uní tew̃ro. Jesucrístoat uw sehnár yajc eta báreyra. ");
INSERT INTO tuf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Istiyati imár ub cut Siran istítiro. Wacjá istán biat, Tet owár ítquibat, téw̃quibat eyat Sir bitáratara bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pueblo Jerusalén cutar judío cárinat sacerdótein cat, levitin cat Juan quin áyjacro. Ayat sacerdótein cat, levitin cat Juan quin béjecro. Cur car táyojocro. —¿Baha rehrcá? ¿Bitara binca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Táyoyat Juanat eyin cahmar ruhcti cuar uní wajacro: —Asra Sirat Cara Ayin Wajaquin eyi batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Etat éyinat wajacro: —Ey bártara, ¿rehrcá? táyojocro. ¿Bah Elíasqui? Juanat wajacro: —Asra eyi batro. —¿Bahan Sir chihtá ehcuquib yehnata quenéyica? —Asra eyi cat batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Etat éyinat wajacro: —Baha rehrtara is quin ehcuwi, -wajacro-. Is áyjaquin quin chihtá beyin ac ehcuwi, -wajacro-. ¿Behmát waquít bah rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Etat Sir chihtá ehcuquib Isaíasat bitara wajáctara Juanat im eyta wajacro: —Asan uyro. “Serat ubach bár cut cohwro. Eyat wacaro: ‘Cara wiquín cahmor bahnác órowa,’ wacaro.” Eyta téw̃queyan asan eyro. ");
INSERT INTO tuf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanat eyta wacayat fariséoinat áyjaquinat ");
INSERT INTO tuf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Juan ey quin wajacro: —Ba Sirat Cara Ayin Wajaquin bártara, Elías bártara ¿bitara reht uw rih sar siw̃ca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanat wajacro: —Ajatrá uw rih sar siw̃ro. Eyta cuar ba tac icar sera istiyró. Eyan rehrtara baat istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","As yahncút rac cuar eya ayan as cuitro. Ey ayan as cuít etar aját ey bútajatro. Aját ey ques barcát chistár cat rícuajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sacerdóteinat cat, levítinat cat Juan quin eyta táyojocro, Betania cutar, rih Jordán erar rahs raquíc wihár. Erar Juanat uw rih sar siw̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Eyta táyojoc cuanmí cut Juanat Jesús itchacro. Jesús ey raquíc itchacro. Istír Juanat wajacro: —Ser uch wahítuwi. Uyan Sir obas sahan wan rehcáyqueyra. Uwat ay bár yajác tayar tunin obas sah yauwir eyta ser uch cat eyta yauwáyqueyra. Eyta chinír cut uyat bahnáquinat ay bár yajác tayar túnayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aját uy ojcor wajacro: “As yahncút wic cuar uyra ayan as cuitro. As anto yehnti cuat uyra Sir jor chájacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Ajatrá uy rehrtara istiti binro. Ajmarát uy anto istiti cuara, uw rih sar siw̃ rajacro. Israélinat uy rehrtara istayta acu uw rih sar siw̃ rajacro,” wajacro, Juanat. ");
INSERT INTO tuf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Acsar Juanat uchta wajacro: —Aját ítitan, Ajcan Cámuran Eya cuacúr bin átcurir rajacro. Raquír car uy cutar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eyta chihrín cahmor aját uyan rehrtara istítiro. Aját istiti cuar Sirat uw rih sar siw̃in as récaji áyjacro. As ayir as quin wacárora: “Ajcan Cámuran Eya uw istiy cutar chihráyqueyra. Bi cutar chihryat, uw ur icar Ajcan Cámuran Eya eyat chácayqueyra,” wacárora, Sirat as quin. ");
INSERT INTO tuf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ajcan Cámuran Eya átcurir uy cutar chihrjacro. Chihryat aját itchacro, -wajacro, Juanat-. Aját ba quin uní wacaro. Eya Sir waquijró, wajacro, Juanat. ");
INSERT INTO tuf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cuanmí cuit Juan bucoy im érara chihrjacro. Sinquin bucáy owár chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Erara chihrír Jesús bic itchacro. Istír wajacro: —Uw racaro. Uya Sirat ima obas sahan wan áyjacro. Uwat ay bár yajác tayar tunin obas sah yauwir eyta uy cat eyta yauwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan chiwa bucáy binat eyta rahcuír, Jesús questoc béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús questoc bécayat, Jesús eyin wihár ac wari istír cat wajacro: —¿Baat icúr wahitqui? Eyinat wajacro: —Síw̃quibu, ¿Baha biscán itqui? ");
INSERT INTO tuf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusat eyin quin wajacro: —Bar jaw̃, wahitay. Jesusat “bar jaw̃,” wacayat, eyin Jesús owár béjecro. Jesús birar ítictar itchacro. Rahsan bui jat erar rahsan tui tas ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juanat wajaquey rahcuír Jesús questoc béqueyin istiy ajca Andréscuano. Andrés eya Simón Pedro rabro. ");
INSERT INTO tuf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Itay ocuajacan rahsan tui tas itir car, Andresra Simón wahitay bijacro. Istír car Simón quin wajacro: —Sirat Cara Ayin Wajaquin isat bar itchacro, wajacro. Cara Ayin Wajaquin ajc istiy Crístoro. ");
INSERT INTO tuf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Simón quin Sirat Cara Ayin Wajaquin itchác waquír, Andresat Simón Jesús quin béjecro. Jesús quin cucayat, Jesusat Simón wahitchacro. Istír wajacro: —Bahan Juan wacjá, Simonro. Aját bah ajca Cefas cháquinro, wajacro. Griego cuw cutar ajc Cefas “Pedro” wacaro. Ajc eyta eyan “aca” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Simón istír cuanmí cut Jesús cajc Galilea ben séhw̃ajacro. Bicayat Felipe itchacro. Istír Felipe quin wajacro: —As jor biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe eya pueblo Betsaida binro. Andrés cat, Pedro cat im erar binro. ");
INSERT INTO tuf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesusat “As jor biwi” wacayat, Felípeat Natanael wahitay bijacro. Istír Natanael quin wajacro: —Sir bacha cáritan chihtá cáritan cutar Moisesat cuihsujaquey ojcor isat ey itchacro. Sir chihtá ehcúquibat cat ey ojcor cuihsujacro. Isat ey itchacro, -wajacro-. Eya Jesusro. José waquijró. Nazaret binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Etat Natanaelat uní batro, séhw̃ajacro. Eyta séhw̃ajac rehquít wajacro: —Nazaret binra ay bi icuri ístajatro. Etat Felípeat wajacro: —Wahitay bar jaw̃, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eyta waquír Jesús quin béjecro. Cucayat Jesusat Natanael itchacro. Istír Natanael ojcor wajacro: —Israelin ur ay bin racaro. Eyat uw cayar yájtiro. Israélinat yajcata bin eyat bahnác ay yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Etat Natanaelat séhw̃ajacro: “Jesusat as istítiro. ¿As urá bitáratara bitara ityi?” séhw̃ajacro. Eyta sehw̃ar wajacro: —¿As bitara ityi? táyojocro. Etat Jesusat wajacro: —Aját bah higuera caruc cahmor itchacro. Felípeat bah anto chiti cuat itchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Etat Natanaelat Jesusan urán to istír wajacro: —Síw̃quibu, bah Sir waquijró. Bah israelin rey cáracuano, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusat wajacro: —Aját “Bah higuera caruc cahmor itchacro,” wacayat, bahat sehw̃at, as israel rey cara séhw̃aro, -wajacro, Jesusat Natanael quin-. Aját bah quin wacaro. Bahat aha uchta istiey acsar wan ayan cuít istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Etar cat Jesusat wajacro: —Aját ba quin wacaro. Bahat uchta istáyqueyra. Sirat cuacúr aba waacayat, bahat ima cuacúr cacmín istáyqueyra. Ititan Sir cacmín erar cuar ísuwar rocaro. Roquír sicor Sir quin bécaro. Uw Síuquib cutar roquíc bequic istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bay cuanyat pueblo Caná cajc Galilea cutar fiesta yajacro. Uwat wiya yehw̃íc fiesta yajacro. Jesús ab cat fiesta cutar ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús cat, Jesús chiwa cat chíjacro, fiesta yajcayta acu. Eyin cat ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fiesta anto bahnti cuat, chistár ub rihar bacú bar bahnajacro. Bahnyat Jesús abát Jesús quin wajacro: —Ahra chistár ub rihar bacú batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Etat Jesusat ab quin wajacro: —¿Bitara reht as quin “chistár ub rihar bacú bar bahnajacro,” waquí? Aját bahnác bar yajcata ehcún acu anto cab cutiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Etat Jesús abát cacmín quin wajacro: —Jesusat ba quin icúr yajc áyictara baat eyta yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judíoin bach cutar Sir ub cahmor ay rehquín acu sucro. Eyta sucuín acu rih cumít sar yajc chácaro. Ac cumít rih eyta cháquinan teray ésatro. Cúmacan cuitro. Cumít istiy cat, cumít istiy cat, litro cincuéntatara, litro seséntatara rauro. ");
INSERT INTO tuf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús abát cacmín quin Jesusat ayic eyta yajquín wacayat, Jesusat eyin quin wajacro: —Cumít sar rih cuin tijcawi. Eyta wacayat éyinat cumít bahnác sar rih cuin tijcajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Etar eyin quin wajacro: —Ahra rih ey sicar bin toc istiy uw̃i. Uquir ira tahw̃uquib quin béowi, wajacro. Eyta wacayat, éyinat rih újacro. Uquir ira tahw̃uquib quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ira tahw̃uquib yahn acu wíjacro. Wícayat eyat yahjacro. Chistár ub rihar bacú eya biscán bíntara istítiro. Istiti cuar yahjacro. Ira tahw̃úquibat istiti cuar cacminát itchacro. Eyinat ítitan, Jesús urá cut rihan bacú arjacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ira tahw̃úquibat bisar bíntara istiti rehquít, wiya yehw̃jaquey chíjacro. Chiír wicayat ey quin wajacro: —Cahujinat bacuá ayan cuít bi uw quin ibtu wícaro. Ay bi wiquir uwat bacuan to yahr cutar bacuá ayan étai cuti ey wícaro. Eyta cuara baat éytara wítiro. Bahat ayan cuít bi ubar ojcor wícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesusat rihan chistár ub rihar bacú eyta arjacro. Pueblo Caná cajc Galilea cutar eyta arjacro. Eyta aríc cutar, imát Sir urá cut bahnác bar yajcata ehcujacro. Anto ehcuti bin ehcujacro. Erara ima ayan tahnác eyta ehcujacro. Rih aryat, ima chiwat Jesús tamo síhw̃ajacro: “Sirat Cara Ayin Wajaquin uyan eyro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Fiesta yahncút Jesús abín owár, rabin owár, imát siw̃quin owár pueblo Capernaum bejecro. Eraran boni bay cuanjacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bach ajca chéycara aracat bijaquey biráy bár cuanyat yajcáy yehnátaro. Uchicrias Siran cohtín ubach aracat uw yauti bijacro. Siran aracat uw yauti bijác ey sihw̃an acu judíoinat bach yájcuano. Cheycar aracat bijaquey bach ajc istiy cut Pascua fiesta aw̃uro. Biráy bár cuanyat bach yajcáy yehnata rehquít Jesús Jerusalén bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalén cur car Sir usar raújacro. Rauwir ítitan, uwat vaca racaro. Obas cat, atcur cat racaro. Cahujinra mesa acor itro, ray tehmón acu. ");
INSERT INTO tuf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eyta istír Jesusat bucach yehw̃ír órojocro. Oror car ey cuitar bahnaquin sicor watur áyjacro. Obas cat, vaca cat sicor watur áyjacro. Ray tehmóquinay rayra bahnác ica sar quihu téjecro. Mesa cat ab cuijacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Atcur raquib quin wajacro: —Atcur watur béowi, -wajacro-. As Tet ubach ruwa ran acura batro. Usatra rati jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Watar ayat, ray tehmoquin mesa ab cuicayat, Jesús chiwat síhw̃ajacro. Sir carit cutar wacaro: “Siru, aját bah ubach sehnacro. Bah ubach sehná rehquít as bar cuácataro,” wacaro. Jesús chiwat eyta waquíc tamo síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Etat judío cárinat Jesús quin wajacro: —Sirat bahat eyta yajquín acu áyjactara, is quin ehcuwi. Bahat Sir urá cut bahnác yajcata ey ehcún acu yajw̃i. Bahat biyan bahnacan yájcajatrum bár is quin ehcuwi. ");
INSERT INTO tuf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Etat Jesusat wajacro: —Baat uch ubach, Sir ubach bahnác ruhw̃ú tewi. Bahnác ruhw̃ú técayat aját sicor oro yehnár riya bay cuaninro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Etat éyinat wajacro: —Uch ubach riya bay bitách túw̃ajatro. Uch tuw̃ín acu bara cuarenta y seis rehjecro. Riya bay bitách túw̃ajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eyta cuara Jesusat Sir ubach ojcor téw̃tiro. Ima sibár ojcor tew̃jacro. Im eya Sir úbachcuano. ");
INSERT INTO tuf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yájcajareht Jesús chinír bay cuanyat sicor estají yehnjacro. Yehnyat chiwat Jesusat wajác tamo síhw̃ajacro. Sir ubach sicor oron ac riya bay cuanín wajác tamo síhw̃ajacro. Eyta sihw̃ar Sir carit cutar cuihsujác im eyta rehjéc, síhw̃ajacro. Jesusat wajác im eyta rehjéc, síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús pueblo Jerusalén cutar Pascua fiesta cutar eyta yajacro. Eyta yajca rabar uwan to binat ey tamo sihw̃ay raújacro. Jesusat imát bahnác yajcata ehcujacro. Cuercurin tan chájacro. Ub bár bin quin ub wíjacro. Eyta yajcayat Jesusat icuran biyan bahnacan yájcajatrum bár bar ehcujacro. Uwat eyta ityat “Sirat Cara Ayin Wajaquin Jesusan eyro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Eyinat eyta síhw̃ajac cuara Jesusat uw urá bitáratara itro. Jesusat séhw̃ajacro. Eyinat ima tamo sihw̃ay yinjác cuar, bár waca tétaro, séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesusat cahujín quin táyotiro, uwan bitáratara istín acu. Imát uw urá itro. ");
INSERT INTO tuf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fariseo istiy ajca Nicodémoro. Nicodemo judíoin cáracuano. ");
INSERT INTO tuf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo chéycara cutar Jesús quin tew̃ay bijacro. Cur wajacro: —Síw̃quibu, isat ítitan, Sirat bah áyjacro, is siwin acu. Sirat bah áytiir waquít bahat yajquíc bitách yájcajatro. Bahat bahnác bar yajcátaro. Sirat cuitar yájtieyra bahat yajacan bitách yájcajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Etat Jesusat wajacro: —Aját wacaro. Bíyinan bucoy yéhntieyra eyin Sir quin béyajatro. Sir cara rehquey cutar béyajatro. ");
INSERT INTO tuf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Etat Nicodémoat wajacro: —Bihtín bucoy bitách yéhnajatro. Bucoy yehnín acu ab ohcuá sar búcoyra bitách raúwajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Etat Jesusat wajacro: —Rih cuitar cat, Sir Ajcan Cámuran Ey cuitar cat bucoy yehnátaro. Rih cuitar yéhntieyra, Sir Ajcan Camur Ey cuitar yéhntieyra Sir cara rehquey cutar béyajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Uw ab ohc cut bin yehnyat, uw sibár sicar binro. Uw ohc cut yehnro. Uw eyta yehníc cuar, Sir Ajcan Camur Eyat Sir ima sasá yehn ayro. Sir Ajcan Camur Eyat uwan Sir sasá yehn ayat, Sir im Ajcan Cámuran Eya uw eyin ur ícatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aját bah quin wacaro. Bahnaquin bucoy yehnátaro. Aját eyta wacayat, “uní tew̃ti” séhw̃ati jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Baat ítitan, sero rahray wihár, rahray wihár cac cac bicaro. Baat sero biquey cucách cut rahcro. Cucách cut rahcuí cuara biscán bíntara istítiro. Sir Ajcan Cámuran Eyat éytaan wan uwa Sir sasá yin ayro. ");
INSERT INTO tuf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Etat Nicodémoat wajacro: —Eyta tew̃quey bitáratara aját ay ráhctiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Etat Jesusat wajacro: —Bah israelin síw̃quibro. ¿Bahat eyta tew̃quey bitáratara ráhctica? -wajacro, Nicodemo quin-. ");
INSERT INTO tuf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aját bah quin uní wacaro. Isat it bin ojcor tew̃ro. Ijmarat ub cut itchác ojcor ehcuro. Eyta ehcúc cuar bahat is chihtá ráhctiro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aját cajc uch ojcor tew̃yat, bahat uní séhw̃atiro. Cajc uch ojcor tew̃yat, bahat ráhctieyra, aját cuacúr Sir quin bitáratara, ehcwayatwat cuar, bahat bitách ráhcuajatro, -wajacro, Nicodemo quin-. ");
INSERT INTO tuf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Istiyati cuacúr Sir quin cu bah cutiro. Uw Síuquib asan cuacúr Sir jor bin cajc uch cutar rajacro. Sicor erar bétaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cajc buru catu cut ricmát uw cohcayat uw sácajacro. Eyta sácati ac Moisesat Sir chihtá cut yera ricumír caruc ojcor cuacúr yehw̃ jájacro. Moisesat ricumír caruc ojcor cuacúr yehw̃ír eyta asa Uw Síuquib caruc ojcor eyta cuacúr yehw̃áyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","’Caruc ojcor yehw̃ír yauyat bíyinat “Eyat as bar síwataro,” síhw̃ayatan eyin Sir owár etiti ohbac ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Síratan uw bahnaquin sehnacro. Uw sehnác rehquít, ima wacjá istán ey áyjacro. Caruc ojcor yehw̃ír yauwayta acu áyjacro. Etar bíyinat “eyat as bar síwataro,” síhw̃ayatan eyin sutá báreyra. Sir owár etiti ohbac ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sirat ima wacjá cajc uch cutar uwat táyara yajác ques tecuan acui áytiro. Uw siwin acu áyjacro. Ay bár yajác táyara tunin acu áyjacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bíyinat “eya Sir waquíj etar as bar síwataro,” síhw̃ayat, eyin ay bár yajác táyara bár chácaro, -wajacro-. Bíyinat “eyra Sir waquíj batro,” síhw̃ayat eyin quin táyara chícaro. Sir wacjá úbisti ey tamo síhw̃ati rehquít, táyara chícaro. ");
INSERT INTO tuf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uch ques icar tayar chícaro. Urá wiquey, cuan ayquey cajc uch cutar itay rajacro. Wiquír uw quin imarat ay bár yajquey ehcuro. Imarat ay bár yajcáy ocuajác ey ehcujác etar urá wiquey rácari batro. Checúm cutar istiti eyta uw cat imarat ay bár yajaquey éytaan wan istiti it cunro. Ey ques icar tayar chícaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bíyinat ay bár yájctara éyinat cuan ayquey, urá wiquey quehsuro. Urá wiquey quin rátiro. Imarat icúr ay bár yajác ehcwata etar urá wiquey quin rátiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Urá wíqueyat icuran biyan Sir chihtá cutar yajc ey ehcuro. Etar bíyinat ur ay yájctara eyin urá wiquey quin racaro. Sir chihtá cutar bahnác yajc ehcwayta acu racaro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nicodemo Jesús quin wiquíc yahncút, Jesusra ima chiwa owár Jerusalén bin ácubar béjecro, cajc Judea cutar. Acubar cur car chiwa owár ítchacro. Erar ita rabar chiwat uw rih sar siw̃jacro, Jesús chihtá cut. ");
INSERT INTO tuf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanat cat pueblo Enón cutar uw rih sar siw̃ro. Pueblo Enón bin pueblo Salim cuwayta biráy batro. Erar rihan toro. Etar Juanat erar uw rih sar siw̃ro. Uwan Juan quin béjecro. Cucayat Juanat eyin rih sar siw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ey ricar Juan cárcel icar anto túntiro. ");
INSERT INTO tuf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juanat pueblo Enón cutar uw rih sar siw̃á rabar Juan chiwat judíoin owár tecuay yinjacro. Sir ub cahmor restá bitara sucuátatara ey ques técuajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tecuar Juan chiwat Juan quin wacay béjecro. Cur wajacro: —Síw̃quibu, rih Jordán rahray istiy bah jor jájacro. Bah jor chájaqueyan bahat ey ojcor uw quin ehcujacro. Eyat cat uch cut uw rih sar siw̃ro. Bahnaquin ey quin chihtá rahcuay bécaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Etar Juanat eyin quin wajacro: —Sir imát eyta yajquín ajc waátieyra bitách yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aját wajacan behmá cucách cut rahjacro. Aját wánora: “Sirat Cara Ayin Wajaquin asra eyi batro. Sirat ey cahmor as áyjacro,” wánora. ");
INSERT INTO tuf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uchtaan wanro. Uwat wiya yehw̃jacro. Yehw̃ír wíyara éyayro. Eyta cuar wiya yehw̃quib íw̃oquey cat ahní rehcaro, uw eyat wiya yehw̃jác rahcuír. Uw iw̃oc ahní rehquír eyta ahra as cat eyta ahní rehcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Acsar uwan cuít binan ey chiwa yináyqueyra. Eyta cuar as chiwat as ria yajti etáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cuacúr bin wijaquey ayan bahnaquin cuitro. Cajc uch cutar uwra cajc uwro. Cajc uwat cajc uch cutar yajquey ojcor tew̃ro. Eyta cuar cuacúr bin eyra bahnaquin cutatro. ");
INSERT INTO tuf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eyat cuacúr Sir owár ita rabar, itchác ojcor tew̃ro. Cuacúr Sir owár ita rabar rahjác ojcor tew̃ro. Ey ojcor tew̃ cuar uwat ráhctiro. Uní síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bíyinat ey chihtá rahcuíctara Sirat wajacan uní wajac ehcuro. ");
INSERT INTO tuf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sirat áyjaqueyat Sir ajca tew̃ro. Sirat ey quin ima Ajcan Cámuran Eya es yajti wíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tetát wacjá sehnacro. Ey bahnác cutar rehquín acu, eyat bahnác ayin acu wíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bíyinat síhw̃ayat: “Sir wacját as bár síwataro,” síhw̃ayat, eyin Sir owár etiti ítayqueyra. Bíyinat “Sir wacját as síwajatro,” síhw̃ayat, Sir wacjá chihtá yajti jácayat, eyin Sir quin béyajatro. Eyinat Sir tayar yajác tun báhnajatro. Sir tecat eyin cuácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Uwat tew̃ic fariséoinat rahjacro. Ráhcuitan, Jesusat chiwa cuít sécuaro. Juan chíwara Jesusay owara cutiro. Jesusat uwan cuít rih sar siw̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Uwat eyta wajác cuara, Jesús imát uw rih sar síw̃tiro. Ey chiwat uw rih sar siw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Uwat eyta tew̃ic Jesusat cat rahjacro. Rahcuír cajc Judea bin sicor Galilea cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Cajc Galilea cuwayta Samaria tiw̃ bétaro. ");
INSERT INTO tuf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jesús Samaria cajc cutar bicayat, pueblo ajc Sicar cutar cujacro. Sicar pueblo cohtín Jacob yaric cajc íntacro. Cajc eya, Jacobat úchicri José yaric quin wic bahjáquinro. ");
INSERT INTO tuf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob yaric rih iscán cajc ey cutatro. Jesús Jacob yaric rih iscán acor cujacro. Cucáyatra rahsan uraró. Ibitat bar cuájacro. Etar rih iscán acor chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ima chíwara pueblo cutar ira wahy béjecro. Jesús erar ityat Samaria wiw̃á rih ucay wijacro. Wicayat Jesusat Samaria wiw̃á quin wajacro: —As yahn acu rih wiw̃i, wajacro. Judíoinat Samaria uway toca sar bin yahti báchuro. ");
INSERT INTO tuf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Etar Jesusat riha yahn acu chícayat wiw̃át wajacro: —¿Uniqui? ¿Bah judíoin uw cuar as toca cut rih yahn chiqui? Asra Samaria uwro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Etat Jesusat wajacro: —Bahat Sirat icúr wíctara istír waquít, bahat rehr jor tew̃íctara istír waquít, as quin rih chiata binro. As quin chiquir waquít, aját bah quin rih ay bi wícataro. Rih ey bah ur icar bicayat, bah ohbac ítayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Etat wiw̃át wajacro: —Bah rih soya batro. Rih iscán ucha únruran cuántiro. ¿Rih ay bi as ohbac itin acu biscán istátaca? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Is cohtín Jacobat uch rih iscán is acu cha bahjacro. Jacobat cat, ima sasát cat, ima ruwat cat bahnáquinat uch rih iscán sar bin rih uquir yahjacro. ¿Baha urán is cohtín Jacob cuiti séhw̃aca? ");
INSERT INTO tuf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Etat Jesusat wajacro: —Bíyinat uch iscán sar bin yahcayat bucoy cuc wini rehcátaro. ");
INSERT INTO tuf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Eyta cuara bíyinat rih aját wiquey yahcayat, éyinra búcoyra cuc wini rehca báreyra. Aját ey quin rih ay bi wícayat, ey ur icar rih béncachan wan yehnáyqueyra. Rih bencach yehnár eyta ey ur icar éytaan wan yehnyat eya ohbac ítayqueyra. Sir owár etiti ítayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Etat wiw̃át wajacro: —Rih eyta ey as quin wiw̃i, -wajacro-. As bucoy cuc wini rehti acu wiw̃i, -wajacro-. Etar as bucoy cat, bucoy cat rih ucay uch cut rati ítinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Etat Jesusat wajacro: —Bah ra chiay biwi. Chiír buca jor as quin raw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Etat chaunát wajacro. —Asra ra batro, wajacro. Jesusat wajacro: —Bah ra bár wacayat, bahat uní wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bah serin esí cuájacro, -wajacro-. Ahra sera istiy jor itro. Ey jor it cuar yéhw̃tiro. Etarwan bahat uní wacaro. Etat wiw̃át wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Aját ítitan, bah Sir chihtá ehcúquibro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ijmár cohtín cajc Samaria binro. Is cohtín Samaria binat cubar uch cutar Sir tamo síhw̃ajacro. Eyta cuara baat judíoinat waquít, pueblo Jerusalén cutar Sir tamo síhw̃ataro, wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Etat Jesusat wajacro: —Chaucu, aját bah quin wacaro. Biráy bár cuanyat uwat cubar uch cutara cat, Jerusalén cutar cat beya báreyra, Sir tamo sihw̃an acu. ");
INSERT INTO tuf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ba Samaria úwatra istiti bin tamo síhw̃aro. Eyta cuar is judíoinat it bin tamo síhw̃aro. Sirat judío istiy cutar uw síwataro. Etar it bin tamo síhw̃aro. ");
INSERT INTO tuf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Biráy bár cuanyat, Jerusalén beti, uch cubar rati Sir tamo quen síhw̃aquin éyinat im ur icar Tet tamo “Siran ayro,” síhw̃ayqueyra. Ur istán cut eyta síhw̃ayqueyra. Sirat uwat ima tamo eyta sihw̃a cunro. ");
INSERT INTO tuf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sira uchta batro. Eyra ajcan cámuran quen eyro. Etar bíyinat ey tamo síhw̃ayat, imár urá cut ey tamo síhw̃ataro. Ur istán cut ey tamo síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Etat chaunát ey quin wajacro: —Aját ítitan, Sirat Cara Ayin Wajaquin yehnátaro. Cara Ayin Wajaquin Cristo aw̃uro. Cristo yehnyat is quin bahnác ehcwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Etat Jesusat wajacro: —Asan eyro. Behmá jor téw̃queyan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Etat acat Jesús chiwa sicor behjecro. Behquir itit, Jesús wiw̃á jor tew̃ro. Eyta istír ub yehw̃jacro. Ub yehw̃jác cuara wiw̃á quin “¿Bah icúr rácarica?” táyotiro. Jesús quin “¿Bah bitán ey jor tew̃qui?” táyotiro. ");
INSERT INTO tuf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Etat wiw̃át rih soya erar cham bahr car sicor pueblo cun bijacro. Pueblo cur car uw quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Aját uw istiy itchacro. Eyat aját icúr yajáctara as quin bahnác ehcujacro. Eyan Sirat Cara Ayin Wajaquin óraro, -wajacro-. Bar jaw̃ wahitay, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eyta waquír uwan to bin pueblo acsar waar car Jesús quin rojocro. ");
INSERT INTO tuf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wiw̃á pueblo bi yiror Jesús chiwat Jesús quin seo tew̃jacro: —Síw̃quibu, ira yawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Eyta waquít Jesusat wajacro. —As iran chero. Baat ir eyta eyra istiti binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jesusat iran che wacayat, chiwat rahra imár owár wajacro: —Uwan Jesús quin rajác óraro. Ira wijac óraro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chiwat uwat ira rojóc waquít Jesusat wajacro: —Aját as ayquey chihtá yajcaro. Eyta yajquey as acu iran wanro. As áyqueyat as quin icúr yajc áyjactara ey yajc bahninro, -wajacro-. Eyta yajcata ey as acu iran wanro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Baat waquít: “Ritút ehsú cuitar cab cuwín acu sihyór bacáy rehcátaro,” wacaro. Eyta cuara aját ba quin wacaro. Uw bar rocaro. Uw wahítuwi. Eyin ritút bar tám rehjequinan wanro. Eyinat as chihtá caquin acu bar cab cujacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ritút ehsúc tehmár uw quin tunro. Eyta tunir eyta Sirat cat uw túnayqueyra. Bíyinat cahujín quin as tamo “Eya Sir waquíj etar as bar síwataro,” sehw̃ay ayat aját ey quin túnayqueyra. Bíyinat as tamo “Eya Sir waquíj etar as bar síwataro,” séhw̃ayat eyin Sir owár etiti ohbac ítayqueyra. Eyta cuácayat Sir chihtá récaji ehcuquib cat, yahncút as tamo sehw̃ ayquib cat buca jor ahní rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Uwat waquey úchtaro: “Istiyát ira ricaro. Cahujinat ir ey ehsuro.” Eyta tew̃quey uní wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aját ba uw quin áyjacro. Baat uw quin as tamo sihw̃ ayin acu ba áyjacro, -wajacro-. Cahujinat récaji eyin quin Sir chihtá ehcujáquinro. Acsar baat im eyin quin as tamo sihw̃ áyjacro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wiw̃á pueblo cuwi cutara, Samaria uwan to binat Jesús tamo síhw̃ajacro. Chaunát uw quin “Eyat aját icúr yajáctara as quin bahnác ehcujacro,” wacayat, uwan to binat Jesusan Sir wacjá sihw̃ay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eyta cuácayat uwat Jesús quin behquir conjacro: —Is owár ítuwi, wajacro. Eyta wacayat Jesús eyin owár boni cuanjacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eyin síw̃jacro. Siw̃quey rahcuír uwan cuít binat Jesús tamo sihw̃ay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uwat wiw̃á quin wajacro: —Ahra bahat wajaquey chihtá cutarai isat Jesús tamo síhw̃atiro, -wajacro-. Ahra ijmarat rahcuír ítitan eya uw bahnaquin Síuquibro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesús pueblo Sicar cutar boni cuanír acsar Galilea cun béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús imát wajacro: “Sir chihtá ehcuquib im cajc cutatra uwat ajcá ji bétiro.” Eyta rehquít Galilea béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea cur car uwat ey quin ténajacro. Uw éyinat pueblo Jerusalén cutar Pascua fiesta yajcáy cu bah cujacro. Jesusat Jerusalén cutar yajaquey uwat bahnác itchacro. Etar ey quin ténajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús bucoy pueblo Caná cajc Galilea cutar bijacro. Cahmor erar bijacan riha chistár ub bacú arjacro. Pueblo Caná cutar gobierno cara istiyrá ésatro. Ey wacjá yatro. Waquíj eya pueblo Capernaum cutatro. ");
INSERT INTO tuf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gobierno carat Jesús Judea bin cajc Galilea wijaquey chihtá rahjacro. Eyta rahcuír Jesús quin bijacro. Jesús quin cur wajacro: —As wacjá bar yarátaro. Pueblo Capernaum bar jaw̃. Ey tan chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesusat gobierno cara ey quin wajacro: —Aját uw tan chácayat, bahat asan Sir wacjá séhw̃ataro, -wajacro-. Cuatán aját icúr biyan yájcajatrum bár ehcútitara bahat ey itir as tamo séhw̃atiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Etat gobierno carat wajacro: —Werjayú, as wacjá anto yarti cuat asi jor biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesusat ey quin wajacro: —Biwi. Bah wacjá yara báreyra. Bar tan jájacro, wajacro. Jesusat eyta wacayat, ser eyat Jesusat uní wajác séhw̃ajacro. Eyta sehw̃ar ria cájacro. Capernaum cun bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Usi cun bicayat im cacminát ey ibt aw̃at tihrjacro. Tihrír wajacro: —Bah wacjá bar tán jájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Etat carat wajacro: —¿As wacjá bítajat tan chayi? Cacminát wajacro: —Baquira quéswarijat tíuquey etchacro. Tan jájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eyta wacayat tetát séhw̃ajacro: “Baquira quéswarijat Jesusat as quin wacárora: ‘Bah wacjá bar tan jájacro,’ wacárora.” Tetát Jesusat wajác ojcor eyta séhw̃ajacro. Eyta séhw̃ayat tetát cat, ey wiyat cat, ey sasát cat Jesús tamo síhw̃ajacro. “Jesús Sir wacjiró,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cara wacjá tan jácayat, Jesusat eyta yajaquey cutar imát Sir urá cut bahnác bar yajcátaro, bucoy ehcujacro. Judea bin cajc Galilea cutar wicayat, eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Itchareht, yájcajareht Jesús Jerusalén bijacro. Judíoin bach yajcáy bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén cutar obas querat cutar riw órojocan ésatro. Hebreo cuw cutar riw órojoqueya Betzata aw̃uro. Riw órojoc rúhracat ubach quer bar bin esiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ey ubach cahmor yárqueyin ricán to ica sar itro. Ub bár bin cat, cuercurin cat, ojc questár yarquin cat ésatro. Eyin rih soboc acor itro. ");
INSERT INTO tuf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Cab istiy cut, cab istiy cut cuacúr bin Sir cacmát riw cata cat soboso yajcaro. Sir cacmát riw cata cat soboyat uwan riw ey sar rauyat tan chácaro. Biyan ibtu riw sar raúwictara, ey bitara yárictara, tan jácaro. ");
INSERT INTO tuf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ser istiy ésatro. Ser eya yar bijacan bara treinta y ochoro. ");
INSERT INTO tuf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús Jerusalén cut riw órojoquey Betzata cut cujacro. Cur itit, cuercúr ey ésatro. Ey quin táyojocro: —¿Bah tan jaca rácarica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Etat yárqueyat wajacro: —Bíyati as riw sar chácajatro. As uw batro. Riw cata cat soboyat bíyati as riw sar chácajatro. As riw sar rauwin yajquít cahujín as cahmor riw sar rauro. Etar as tan chátiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Etat Jesusat yarquey quin wajacro: —Cui yehnwi, -wajacro-. Bah aw̃at secuar biwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesusat eyta wacayat yarquey tan jájacro. Tan jácayat cui yehnjacro. Aw̃at secuar yehw̃jacro. Yehw̃ír bijacro. Canar yájcajar rícara eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Canar yájcajar ricar eyta yajcayat, judío cárinat tan jájaquey quin wajacro: —Ahra canar yájcajar ricar cuanjacro. Bahat canar yájcajar ricar bach auro. Aw̃at bitách yéhw̃ajatro. Bachro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eyta wacayat tan jájaqueyat wajacro: —Uw istiyát as bar tan jájacro. Eyat as quin “aw̃at secuar biwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Etat judío cárinat táyojocro: —¿Biyat bah quin “aw̃at secuar biwi,” wacyi? ");
INSERT INTO tuf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Eyta táyojoc cuara tan jáqueyat biyat ima tan chájactara istítiro. Erar uw ricán toro. Etar istítiro. Jesús ricán to tac icar car jin bijác rehquít istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yahncút Jesusat eyra Sir usar itchacro. Itir wajacro: —Wahítuwi. Bah bár tan jájacro. Ahra bah ay bár yajc etwi. Etítieyra bahan cuít cuácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Etat tan jájaquey judío carin quin bijacro. Cur wajacro: —Jesusat as bar tan jájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eyta cuácayat judío cárinat Jesús quehsujacro. Canar yájcajar ricar yarquey tan chajac etar ríojocro. ");
INSERT INTO tuf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Etat Jesusat eyin quin wajacro: —As Tetát canar yajquíc etítiro. Aját cat canar yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesusat eyta wajác rehquít, judío cárinan cuít túrjacro. Jesús yauwin cuít síhw̃ajacro. Eyat canar yájcajar ricar bach cat aujacro. Etara cat “Siran as Tetró,” wajacro. Eyta waquí cuitara iman Sir im owáraro wacaro. Iman Sir im owáraro wajác rehquít, Judío cárinat cuít quehsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Acsar Jesusat wajacro: —Aját ba quin wacaro. Sir wacját ima chihtá yájtiro. Wacját Tet wahitro. Wahitír Tetát icúr yájctara wacját cat eyta yajcaro, -wajacro. Jesusat im ojcor eyta wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tetát wacjá sehnacro. Etar imát icúr yájctara, eya waquíj quin bahnác ehcuro. Cahmor uw tan jájaquey ehcujacro. Yahncút ayan cuít ehcwátaro. Eyta ehcwayat wacját cat eyta yajcátaro. Yajcayat ba ub yehw̃átaro -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tetát uw chein sicor estají yehn ayro. Wacját cat im eyta uw estají yehn ayro. Wacját biyin estají yehn ay cúntara eyin estají yehn ayro. ");
INSERT INTO tuf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tetát uw urá wahitítiro. Eyta cuara waquíj quin wajacro: “Bahat uw urá wahítuwi,” wajacro, waquíj quin. ");
INSERT INTO tuf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eyta cuácayat bíyinat wacjá ajcá ji bécayat, éyinat Tet cat ajcá ji bécaro. Bíyinat wacjá ajcá ji bétitara éyinat Tet cat ajcá ji bétiro, wajacro, Jesusat im ojcor. ");
INSERT INTO tuf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Aját ba quin wacaro. Biyat as ajc rahcyat, biyat Sirat as ima siwin ayjac séhw̃ayat, ey Sir jor etiti ohbac ítayqueyra. Eyat ay bár yajác tayar ques cuécwajatro. Eyat tayar yajác ques sácata binan táyara bár chájacro, Sir owár ítayta acu, -wajacro, Jesusat Judío carin quin-. ");
INSERT INTO tuf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aját ba quin wacaro. Biráy bár cuanyat uwat Sir wacjá chihtá rahcuáyqueyra. Sir chihtá sinti éyinra urá bár chéinan wanro. Eyinat Sir chihtá rahcuín acu ahra bar cabro. Bíyinat Sir wacjá chihtá rahcuír yajcayat, eyin ohbac ítayqueyra. Sir owár etiti ohbac ítayqueyra, -wajacro, Jesusat judío carin quin-. ");
INSERT INTO tuf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tet urá cut uwan im owár etiti ítayqueyra. Etar cat Tet imát cat wacj ey quin ajc waajacro, uwan ey urá cut Tet owár itin acu. ");
INSERT INTO tuf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wacjá Uw Síuquibro. Etarwan Tetát waquíj quin ajc waajacro, uw urá wahitín acu. ");
INSERT INTO tuf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Uch chihtá uní batra síhw̃ati jaw̃i, -wajacro-. Biráy bár cuanyat, chéinat Uw Síuquib ajc rahcuáyqueyra. Chéinat imár ruhjaquey cutar rahcuáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Rahcyat éyinan ruhjaquey cajc cutar bin waar bétaro. Waar car ay yajáquinra Sir owár etiti ítayqueyra. Eyta cuar ay bár yájqueyin tayar yajác ques técuayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ajmár chihtá cutar aját icrí yájcajatro. Sirat as quin wajacro: “Bahat uw urá wahítuwi,” wajacro. Eyta rehquít aját uw urá wahitír uw cayar yájtiro. Ajmár chihtá cutar icúr yaj cun réhctara yájtiro. Tetát as áyqueyat icúr yaj cun réhctara ey yajcaro. Etarwan aját uw urá wahitír uw cayar yájtiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ajmár chihtá cutar ajmár ojcor tew̃quir waquít, aját tew̃quey uwat rahcua báreyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eyta cuar istiyát as ojcor tew̃ro. As Tetát as rehrtara ehcuro. Aját ítitan, as Tetát as ojcor uní wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Baatrá behmár chiwa Juan quin tayoy áyjacro. Táyoyat Juanat eyin quin as ojcor uní tew̃jacro, -wajacro, Jesusat, judío carin quin-. ");
INSERT INTO tuf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Eyta cuara “aját uní tew̃ro,” waquín acu asra uw táyotiro. Ba siwin acu Juanat wajaquey ojcor aját tew̃ro. Juanat as ojcor wajác tamo baat eyan uniro, síhw̃ayat bar síwayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanat tew̃jaquey ocan wanro. Uw oca sir acat secuar eyta, Juanat tew̃yat ey acor uwan eyta sécuajacro. Secuar Juanat tew̃quey rahcuír inic ahní rehjecro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aját uw tan chájaquey cutar aját uní wac ehcuro. Juanat as ojcor ehcujacra cutiro. Aját yajaquey cut cuít ehcuro. As Tetát as eyta yajc áyjacro. Eyta yajquír cutar Tetát as ayjac ehcuro. ");
INSERT INTO tuf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tetát as áyqueyat cat as ojcor uní tew̃ro. Baat Tet ajc cucách cut anto ráhctiro. Ey ac cat ub cut istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ba ur icar cat ey chihtá cátiro. Sirat as behmár siwin ayjac baat síhw̃atiro. Sirat áyjaquey tamo as tamo síhw̃ati rehquít, Sir chihtá yájtiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Baat Sir carit ehchí wahitro. Sir owár etiti ohbac itin acu bitara yajcátatara, Sir carit ehchí wahitro. Sir carit as ojcor tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sir carit as ojcor tew̃ cuar, baat as quínoi Sir owár etiti ohbac itin acu cóntiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Uwat ajmár quin “Bah ayro,” waquíc acor ítitiro. ");
INSERT INTO tuf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eyta cuar ba urá bitáratara aját itro. Ititan baat Sir sehnác batro. ");
INSERT INTO tuf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sirat as ayjac cuar, baat as quin ténatiro. Ajcá ji bétiro. Uw ima chihtá cutar wicayat, baat ey quin ténayqueyra. Ajcá ji beyáyqueyra, -wajacro, Jesusat judío carin quin-. ");
INSERT INTO tuf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Behmár ojcor rahra rahra ay wacayat ba ahní rehcaro. Eyta cuar Sir im istir binat ba ojcor ay wacayta acu baat icrí yájtiro. Sirat ay wacayta acu baat icrí yajti rehquít, aját ítitan, baat Sir tamo síhw̃atiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eyta cuar, baat ay bár yajác as Tet cac cahmar ajati wacata síhw̃ati jaw̃i. Ajatrá wátiro. Baat sihw̃at, Moisesat ba cuitar wacata síhw̃aro. Eyta cuara Moisesat ba cahm icar tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Baat Moisés bachan chihtán ay cájaquir waquít as tamo cat síhw̃ata binro. Eyat cat as ojcor cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Eyta cuar baat eyat cuihsujác ay ráhctiro. Moisesat cuihsujác ráhctitara aját tew̃ic cat bitách ráhcuajatro, wajacro. Jesusat judío carin owár eyta tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Itchareht, yájcajareht Jesús sicor Galilea riw rahray bijacro. Riw Galilea ajc istiy riw Tiberiasro. ");
INSERT INTO tuf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesús bi questoc ricán to bin béjecro. Jesusat Sir urá cut icúr bár sicar uw tan chaquic éyinat itchacro. Jesusat eyta yajaquey cutar bahnác bar yajcata ehcujacro. Uwat eyta itchác rehquít, ey questoc béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús ima chiwa owár cuhs cutar beyar chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Erara bijacan biráy bár cuanyat Pascua fiesta yajquín cuanátaro. Pascua judíoin fiéstaro. ");
INSERT INTO tuf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chihrír Jesusat wahitchacro. Ititan uw ricán to ima quin rocaro. Eyta istír Felipe quin wajacro: —¿Uch uw bahnáquinat yayín acu ira biscán wáhtaca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felípeat bitara wacátatara ey istín acu Jesusat eyta táyojocro. Jesús imát icúr yajquíntara it cuar táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Etat Felípeat wajacro: —Bahnáquinat conu yayín acu doscientos denario ahuyat cat tíhrajatro, wajacro. Canarán sihyór abi ruoyat doscientos denario tunro. ");
INSERT INTO tuf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Istiy chiwa Andrésa Simón Pedro tanát wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Sah istiy usatro. Eyay cebada pan conu bin esí étanro. Rih ruwa cat bucáy étanro. Eyta cuar uch ricán cuít bin yayín acu utan uyra cúwajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eyta wacayat Jesusat chiwa quin wajacro: —Uw chihr aywi, wajacro. Erara quetoc tihw̃ár cutar chihrín áyjacro. Etar uw bahnaquin chihrjacro. Serin cinco mílcuano. ");
INSERT INTO tuf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chíhryatan Jesusat pan yehw̃jacro. Yehw̃ír Sir quin “Bahat is ira wícaro. Bah ur ayro,” wajacro. Eyta waquír uw chihryat, bahnaquin quin tahw̃ú áyjacro. Pan bahnaquin owár tahw̃uyat, rih ruwa cat yehw̃jacro. Yehw̃ír Sir quin “Bahat is ruwa wícaro. Bah ur ayro,” wajacro. Eyta waquír rih ruwa uw bahnaquin owár tahw̃ujacro. Tahw̃uyat bahnáquinat yarís cohjocro. Bita ya cun rehquítara eyta yájacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bahnáquinat yarsa cohcayat, Jesusat ima chiwa quin wajacro: —Cajcar sécuawi, ira ruhw̃uti acu, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eyta wacayat chiwat cajcar sicor sécuajacro. Ira cajcar chocha doce cuin tas sécuajacro. Cebada pan conu bin esí tahw̃uyat, uw bahnáquinat yarsa yayar cutar, pan cajcar chocha doce cuinjacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesús chihtá cut pan esí bin sicar pan cohní chájacro. Eyta chácayat uw erar sécuajaqueyinat itchacro. Eyta istír wajacro: —Isat uní wacaro. Sir chihtá ehcuquib ayin wajaquin uyan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eyta cuácayat Jesusat ítitan, uwat ima cara ahár chaquin yajquíc itchacro. Eyta istír uw eyin tamar cubar cut im istir bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rahs rauyat Jesús chiwa riw cut béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Riw cut cur canó sar raújacro. Rauwir sicor riw rahray pueblo Capernaum cun béjecro, canó cutar. Riw arcút becayat bahnác tínjacro. Eyta cuar Jesús anto wítiro, eyin quin. ");
INSERT INTO tuf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tinyat acat séroan abáy cácaro. Riw cat sero canarát ayar soboro. ");
INSERT INTO tuf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chiwat riw eyan canó canelét cuitar cuicajacro. Cuica rabar kilometro esítara, téraytara riw arcút béjecro. Etat éyinat ítitan, Jesús racaro. Ica cuitar sahu sahu bir eyta Jesús riw arcutar eyta sahu sahu racaro. Riw arcút sahu sahu raquíc istír ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Etat Jesusat wajacro: —Rooti jaw̃i, -wajacro-. Asró, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eyta wacayat Jesús canó sar rauwin ajc waajacro. Jesús rauyat cab rehti, icúr bár sicar riw rahray birar cun béctara érara cujacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jesusat uw quin pan tahw̃uyat, pan cohjóqueyinra riw rahray beti im érara cuanjacro. Eyinat ítitan Jesús chiwa canó istanác ey sar riw rahray béjecro. Chiwat Jesusra canó sar beti bahjacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chiwa bey yiror canó Tiberias bin istiy cat, istiy cat wijacro. Jesusat pan wíjaquey awat intac béhjecro. Jesusat Sir quin “bah ur ayro” waquír cat uw ric quin pan wíjaquey awat intac béhjecro. ");
INSERT INTO tuf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Cuanjat uwat ítitan, Jesús érari batro. Jesús istiti rehquít, Jesús ima chiwa cat istiti rehquít pueblo Capernaum béjecro, Jesús wahitay. ");
INSERT INTO tuf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Uwan canó sar cuar riw rahray cujacro. Cur car Jesús itchacro. Istír Jesús quin wajacro: —Síw̃quibu, ¿Bah usár bitat wicyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusat wajacro: —Aját ba quin wacaro. Baat bita yayíntara yayín acu aját ba quin wijac etar, baat as úroro. Aját icúr ehcún acu, pan conu bin sicar cohní chájactara baat ey tamo síhw̃atiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ira ohnata bi eyi rácara canar yajti jaw̃i. Sir owár etiti ohbac itin acu cat canar yajw̃i. Sir owár etiti ityat ira óhnajar binan wanro. Ir eyta biyan asa Uw Síuquibat wícayqueyra. Aját Sir owár etiti ohbac itin ajc waáyqueyra. Sir owár etiti ohbac itin ajc waacayat, ir ohnajar bin wíquiran wanro. Sirat Tetát aját eyta yajquín acu ajc waajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jesusat eyta wacayat, éyinat táyojocro: —¿Isat Sir canar yajquín acu icúr yajcátaca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Etat Jesusat eyin quin wajacro: —Sirat baat uchta yajca rácatro. Imát ayjac as tamo sihw̃a rácatro. Aját ba síwata sihw̃a rácatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Etat éyinat táyojocro: —Bahat Sir urá cut bahnác yajcata ehcún acu is ub acat bitar utar yajw̃i, isat ey istín acu. ¿Bahat Sir urá cut icúr yajca? ¿Bahat is bar síwata síhw̃ayta acu icúr yajca? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Is cohtinát cajc buru cutar maná yájacro. Sir carit cutar uchta wacaro: “Sirat cuacúr bin pan is yayín acu wíjacro,” Sir carit cutar eyta cuihsú bahjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Etat Jesusat wajacro: —Aját ba quin wacaro. Moisésati ba quin cuacúr bin pan wítiro. Cuat as Tetatrá ba quin cuacúr pan queney wícaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sirat pan wiquey úchtaro. Sirat cuacúr bin Uw Síuquib áyjacro. Eya Sir cuacúr panro. Eyat Sir owár etiti ohbac itin ajc waacaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Etat éyinat wajacro: —Pan eya is quin bucoy cat, bucoy cat etiti wiw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Etat Jesusat wajacro: —Asan pan eyro, -wajacro-. Biyin as chiwa chácayat, eyin etiti ohbac ítayqueyra. Uwat bucoy bucoy ira yarsa yayar yayí bár itir eyta eyin cat éytaan wan etiti ohbac ítayqueyra. Bíyinat “Jesusat as bar síwata,” síhw̃ayat eyin etiti ohbac ítayqueyra. Uwat bucoy bucoy rih yarsa yahr cuc wini rehti itir eyta, eyin éytaan wan etiti ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Eyta cuar aját ba quin wajacro: “Baat as bar itchacro. Itchác cuar as tamo síhw̃atiro.” ");
INSERT INTO tuf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","As Tetát as quin uw wícaro. Uw éyinat as quin “bah chiwa cháquinro,” wacaro. As quin chiwa chaquin wáqueyinra aját eyin bayuti cácaro. Ubisti quínoi “as chiwa chati jaw̃i,” wátiro. Bahnaquin cácaro. ");
INSERT INTO tuf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","As cuacúr bin rajacro. Ajmár chihtá yajcáy rátiro. As áyjaquey chihtá yajcáy rajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","As áyjaqueyat uwan eyta caquin wajacro, uw as quin wíjaquey úbistii chiw̃ti acu. Cabar tinyat aját ey bahnaquin sicor estají yinayta acu as quin eyin cac áyjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","As Tetát uchta rácatro. Uw im owár etiti ita rácatro. Bíyinat ima wacjá istír, “Eyat as bar síwataro,” síhw̃ayat, as Tetát eyin im owár etiti ita rácatro, -wajacro-. Eyta ítayta acu aját eyin cabar tinyat, sicor estají yin áyinro, wajacro, Jesusat uw quin. ");
INSERT INTO tuf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesusat “asan Sir pan cuacúr bin wijác,” wacayat, judíoinat Jesús icar ajc semar cuach cuach túrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Cuach cuach tura rabar rahra rahra wajacro: —Eya Jesúscuano. José yaric waquíjcuano. Isat ey tet cat, ab cat itro. ¿Bitara reht “As cuacúr Sir owár bin rajacro,” waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Etat Jesusat eyin quin wajacro: —As icar cuach cuach turti jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tetát as áyqueyat uw quin as chiwa chaquin ayro. Tetát áytieyra uwat as chiwa chácajatro. Etar cat cabar tinyat as chiwa chájaqueyin aját sicor estají yin áyinro, Sir owár etiti ohbac ítayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sir chihtá ehcúquibat cuihsú bahjacro: “Sirat bahnaquin síw̃ayqueyra.” Bíyinat Sir chihtá rahcyat, Sirat siw̃quey sinyat, eyin as chiwa chácaro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Eyta cuar uwat ub cut Sir istítiro. Sirat áyjaqueyat ajmár ístirat Sir itchacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aját ba quin wacaro. Bíyinat as tamo “Sirat ayjac” síhw̃ayat, eyin Sir owár etiti ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aját Sir owár itin ajc waacaro. Asan Sir owár etiti itin panro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ba cohtinát cajc buru cut maná yajacro. Eyta cuar eyin sácajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Sirat áyjaquey pan eyra cuacúr binro. Ey cohr Sir owár sácati ítataro. ");
INSERT INTO tuf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Asan uw cuar Sirat cuacúr bin pan estají bi áyjaquey asan eyro. Bíyinat im ur icar Sirat as ayjac síhw̃ayat, eyin Sir owár sácati ítayqueyra. Uwat pan cohr yayat chinti eyta eyin éytaan wan Sir owár sácati ítayqueyra. Pan ey as suraro. Aját ajmár sura wícaro, uw Sir owár sácati ítayta acu, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesusat eyta wacayat, judíoinat rahra rahra ey ques tecuar wajacro: —¿Eyat ima sura uwat cohn acu bitara wícataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Etat Jesusat wajacro: —Aját bah quin wacaro. Baat asa Uw Síuquib sura cóhtieyra, as ab yáhtieyra ba ohbac ita báreyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bíyinat as sur cohcayat, bíyinat as ab yahcayat eyin Sir owár etiti ohbac ítayqueyra. Cábara tinyat aját eyin Sir owár sácati itin acu yin áyinro. ");
INSERT INTO tuf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","As sur eya ira quéneyro. As ab eya yahn acu quéneyro. ");
INSERT INTO tuf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bíyinat as sura cohcayat, bíyinat as ab yahcayat, eyin urá as icar chácaro. Rahra cat as urá eyin icar chácaro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","It áyqueyat as Tetát as áyjacro. Ey urá cut as cat itro. Bíyinat as sura cocayat, eyin as urá cut ítayqueyra. Asa Tet urá cut itir eyta eyin cat eyta as urá cut ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eytaan cuacúr bin Sir panro. Ba cohtinát maná yájaquey ajquitro. Eyinat maná yajac cuar sácajacro. Eyta cuar bíyinat pan uch cohcayat, Sir owár etiti ítayqueyra, wajacro, judíoin quin. ");
INSERT INTO tuf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesusat pueblo Capernaum cutar secuac usi siw̃a rabar eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesusat eyta wacayat, sinquin ricán to binat wajacro: —Chihtá ey caquin acu chauwan abayro, -wajacro-. Bíyati cácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús quin eyta wati cuar, sínquinat turir rahra rahra ajc cuach cuach eyta tew̃jacro. Sínquinat icúr tew̃íctara Jesusat ima urá cut itchacro. Istír eyin quin wajacro: —¿Aját tew̃yey ba cut tec yar wíniqui? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eyta túrictara ¿baat as uw síuquey sicor cuacúr biquic istátair waquít, baat icúr síhw̃ataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","’Sir Ajcan Cámuran Ey cut uwa Sir owár sácati itro. Behmár urá cut ba Sir owár etiti ohbac ita báreyra. Aját ba quin wajáqueyan Sir owár etiti ohbac ítayta acu Sir Ajcan Cámuran Eya ba ur icar chácata ojcor tew̃ro. Ba cac sar as sura cohtá ojcor téw̃tiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eyta cuar ba sicar bin cahujinat as tamo síhw̃atiro, wajacro. Jesusat ima tamo síhw̃ati eyin récaji itchacro. Iman quehsí bin at icar wícata eya récaji itchacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eyta waquír cat uchta wajacro: —Baat as tamo síhw̃ati etar aját ba quin wajacro: “Sirat baan as chiwa chac áytieyra baan as chiwa chácajatro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ey yahncút sinquin to binat Jesús ria yajti yehw̃ téjecro. Ey owár beti chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Etarwan Jesusat sinquin doce quin wajacro: —¿Sinquin to binat as ria yajti yehw̃ ter eyta baat cat eyta yehw̃ te cuni rehqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Etat Simón Pédroat wajacro: —Caru, isan rehr quinoi béyajatro. Bahat is quin Sir owár etiti ohbac itin acu chihtá siw̃ro. ");
INSERT INTO tuf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ahra isat ítitan, Sir imáy ur ay biyan bahan eyro. Isat bah tamo eyta síhw̃aro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Etat Jesusat wajacro: —Aját baan doce bin cájacro. Eyta cuar ba úbistira Sisrám chihtá cuitar itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesusat Simón Iscariote wacjá Judas ojcor tew̃jacro. Júdasan doce owár bin cuar, eyat Jesús quehsí bin at icar wícata ojcor tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ricán to binat Jesús ria yajti yehw̃ técayat, Jesús Galilea cajc cutar birar urar bijacro. Judío cárinat ey yau cun rehquít, Jesús Judea cajc cut it cun bár rehjecro. ");
INSERT INTO tuf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Biráy bár cuanyat chohcha cahmor itic bach yajcáy yinátaro. Ey bach yajca rabar judíoin chohcha cahmor itro. ");
INSERT INTO tuf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Etarwan Jesús taninát ey quin wajacro: —Bah usár ítiti jaw̃i -wajacro-. Cajc Judea biwi. Bahat síw̃queyinat bahat yajquey istayta acu Judea cajc cut biwi, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Biyat cahujín quin ima it ay cun rehcayat, eyat imát yajquíc ey rúhctiro. Eyta rehquít bahat uw tan chácayat, uw bahnaquin ub acat yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesús ima taninát “Eya Sir wacjá” síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Etar Jesusat ima tanín quin wajacro: —As ben acu anto cab cutiro. Bara bítajat bi cúntara, ba eta jatan bar beyátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cajc uch cutar uw bahnáquinat baan quéhswajatro. Eyta cuar asra quehsuro. Bucoy cat, bucoy cat uw eyin quino “Baat ay bár yajcaro,” wac etar as quehsuro. ");
INSERT INTO tuf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Baan Judea cajc cutar bach yajcáy béowi. Asra bach uch yajcáy bitiro, -wajacro-. As acu anto cab cutiro. Etar bitiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesusat eyta waquír, Galilea cutar ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Etar Jesús taninán bach yajcáy béjecro. Eyin bejec ques cut Jesús cat bijacro. Bijác cuar uw quin ima rehrtara it ayti bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Erar bach yajquíc cutar judío cárinat Jesús úroro. Eyinat táyojocro: —¿Jesusra biscántara? ");
INSERT INTO tuf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bach yajquíc cutar uwat rahra rahra Jesús ojcor tew̃jacro. Cahujinat wajacro: —Ey ur ayro, wajacro. Cuatán cahujinat ey ojcor wajacro: —Eyat uw cayar yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Rahra rahra eyta tew̃ic cuar, uw bahnaquin cucajá acat icrí wátiro. Judíoin cahmor ay wini rehquít icrí wátiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bach bitác yajcayat, Jesús Sir usar raújacro. Rauwir uw síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesusat siw̃yat judío cárinat Jesusat siw̃quey rahjacro. Rahcuír ub yehw̃ír wajacro: —¿Uniqui? -wajacro-. Eyra sinay biti binro. Eyta cuar urán bow̃an tahnacro, wajacro. Etat Jesusat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","—Aját ajmár chihtá síw̃tiro. Sirat as áyjaquey chihtá siw̃ro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bíyinat Sir chihtá yaj cun réhctara éyinat uch istátaro. Aját Sir chihtá cut síw̃ictara, ajmár chihtá cut síw̃ictara ey istátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Biyat ima chihtá cut tew̃yat, eyat im ojcor cahujinat ay wacayta acu tew̃ro. Eyta cuar biyat im ayquey ojcor cahujinat ay wacayta acu tew̃yat, eyat uní tew̃ro. Ay batra icrí yájtiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisesat ba quin Sirat wajaquey ehcujacro. Sir bach cáritan, chihtá cáritan baat yacayta acu wíjacro. Moisesat Sir bachan chihtán ehcujác cuar, ba úbisti bíyati ay báchutiro, -wajacro-. ¿Bitara reht as yau cun rehqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Etat uw ricát wajacro: —Behmá cuicát isó bicaro. Rehrát bah yauwin séhw̃atiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Etat Jesusat wajacro: —Aját icar istiy canar yájcajar ricar uw tan jácayat, ba bahnáquinat ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Baat cat tan jaquin rícara canar yajcaro. Moisés bach cáritan chihtá cáritan cut wacaro: “Sera saha yehnár abi cuanyat ey umá ehswátaro,” wacaro. Moisés cahmor ba bihtinát cat récaji eyta ehsujacro. Eyta waquíc rehquít, Moisés chihtá ruhw̃uti acu sera sah yehnár abi cuanyat baat umá ehsuro. Eyta cuar sera sah cahujín yehnár abi cuanyat, im ey rícara canar yájcajar rícara cuanata óraro. Eyta cuaníc tacat, baat ey rícara cat ehsuro. Eyta cuar ba as ac tutro. ¿Bitara reht as ac turqui, aját canar yájcajar ricar uw orac jajac ques? ");
INSERT INTO tuf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Baat cahujinat icúr ay bár yajáctara anto ay istiti cuaquir ay bár yajác tayar chiti jaw̃i. Ay bár yajác ay ityat, ay uro úcayat etat uní tew̃i. Anto ay istiti cuaquir chiti jaw̃i. ");
INSERT INTO tuf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén itquin cahujinat wajacro: —Ser uchra cárinat yauwin acu úroro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wahítuwi. Eyat uw bahnaquin cac cahmar tew̃ro. Eyta tew̃ic cuar, bíyati ey quin icrí wátiro, -wajacro-. Cárinat eyan uní Sirat Cara Ayin Wajaquin sihw̃ac óraro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Eyta cuar Sirat Cara Ayin Wajaquin biscán bin wicátatara uwat istiti rehcáyqueyra. Is bahnáquinat ser uchra biscán bíntara itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Etat Jesusat Sir usar siw̃a rabar cohwjacro: —¿Uniqui? ¿Baat as rehrtara itqui? -wajacro-. ¿As biscán bíntara itqui? -wajacro-. Eyta cuar asra ajmár chihtá cut rátiro. As áyjaquey eyan Sir quéneyro, -wajacro-. Baatrá ey istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Baat istiti cuar aját ey itro. Eyat as áyjacro. As ey owár bin rajacro. Etar aját ey itro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Eyta wacayat, Jesús caquir questán yinjacro. Eyta cuar bíyati Jesús catótiro. Ey caquir questár beyin acu anto cab cutiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ey caquir questán yinjác cuar cahujinat ricán to sicar bin Jesús tamo “Sirat Cara Ayin Wajáquinan eyan eyro,” síhw̃ajacro. Eyta sihw̃ar wajacro: —Baat sihw̃at, “¿Sirat Cara Ayin Wajaquin yehnyat, ser uchat Sir urá cut yajaquey cuít yajcata,” síhw̃aqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Uwat rahra rahra Jesús ojcor eyta tew̃jaquey fariséoinat cat rahjacro. Rahcuír sacerdote carin owár Sir usi policia Jesús caquir questáy áyjacro, cárcel sar chaquin acu. ");
INSERT INTO tuf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eyta ayic tacat, Jesusat uw quin wajacro: —As ba owár inic rehcátaro. Etat as áyjaquey quin sicor benro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Erar bicayat, baat as wahityat, ístajar rehcáyqueyra. As birar bíctara ba erar béyajar rehquít, as ístajar rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Etat Judío cárinat rahra rahra wajacro: —¿Birar bétatara, isat ey istiti acu? -wajacro-. ¿Judíoin cahujín uw pueblo cutar itquin quin bétayitara? ¿Pueblo eyin cutar griégoin siw̃ay bétayitara? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Eyat wacaro: “Baat as wahityat ístajar rehcáyqueyra.” Etar cat wacaro: “As birar bíctara ba érara béyajatro,” wacaro. Eyta wacayat isat ráhctiro. ¿Bitara wáctara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bach waan rícatra eya ayan cuít yajacro. Ey rícara Jesusan uw ubot cui yehnjacro. Cui yehnár cohwjacro. —Biyin cuc wini réhctara as quin racátaro, yahn acu, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sir carit cutar uchta wacaro: “Bíyinat as tamo síhw̃ayat, ey ur icar rih ay bi waar cuin rac éytaro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesusat eyta wajacro. Ur icar rih ay bi waar cuin rac wacayat, Sir Ajcan Cámuran Ey ojcor wacaro. Jesús tamo síhw̃aqueyin ur icar Sir Ajcan Cámuran Eya chácataro. Jesusat eyta waquíc cutar anto cuacúr bitiro. Cuacúr Sirat Jesús ojcor ay wacáyqueyra. Jesús anto cuacúr biti rehquít, Sir Ajcan Cámuran Eya uw ur icar anto chátiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesusat eyta wacayat, uw ricán to binat rahjacro. Rahcuír ey sicar bin cahujinat wajacro: —Uniro. Ser eyra Sir chihtá ehcuquib racata wajaquin eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Cahujinat cat wajacro: —Eyra Sirat Cara Ayin Wajaquin eyro, wajacro. Eyta cuar cahujinat wajacro: —Sirat Cara Ayin Wajaquin Galilea bini yéhnajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sir carit cutar wacaro: “Sirat Cara Ayin Wajaquin David bomcar yehnátaro,” wacaro. “Pueblo Belén cutar yehnátaro. Cara David itchac pueblo cutar yehnátaro,” wacaro. Etar Jesús eyi batro, wajacro, fariséoinat. ");
INSERT INTO tuf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eyta rehquít uw ricán wahw̃ujacro, Jesús ques. ");
INSERT INTO tuf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Cahujinat Jesús caquir questa beyin síhw̃ajacro, cárcel icar chaquin acu. Eyta cuar bíyati catótiro. ");
INSERT INTO tuf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sir usar policia sicor sacerdote carin quin, fariseo quin béjecro. Cucayat sacerdote cárinat cat, fariséoinat cat eyin quin táyojocro: —¿Bitara reht Jesús roti bahyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Etat éyinat wajacro: —Jesusat urán bow̃an to tew̃ír eyta cahmora uw istiyati éytara téw̃tiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Etat fariséoinat eyin quin wajacro: —¿Eyat ba cat cayar yajcyi? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Behmarat ítitan is carin ubistanati, fariséoin cat ubistanati ey tamo síhw̃atiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uch uw ricát Moisés bach cáritan chihtá cáritan síntiro. Moisés bach cáritan chihtá cáritan sinti rehquít, Sirat eyin técuayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Etat imár fariséoin owár bin Nicodémoat wajacro. Nicodemo eyra cahmor icar istiy Jesús quin wijáquinro. Jesús owár tew̃jáquinro. Eyat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Is bach cáritan chihtá cáritan cutar wacaro: “Uw ima quin táyowi, ima cuitar waquín acu. Uw imát eyta wátieyra isat ay ráhctieyra, ey quin tayar chíajatro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nicodemo eyta wacayat fariseo sicar bin cahujinat Nicodemo quin wajacro: —¿Baha cat Galilea uwqui? -wajacro-. Sir carit ay sinwi. Sinir itit Sir chihtá ehcuquib Galilea binra úbisti yéhntiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Etat uw bahnaquin imár usi béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Eyta cuar Jesusra Olivo terá cut bijacro. Erara cu bah cur ");
INSERT INTO tuf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","cuan racayat, sicor Sir usi wijacro. Esar wicayat, uw bahnaquin Jesús quemir sécuajacro. Sécuayat Jesús chihrjacro. Chihrír eyin síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Siw̃yat icar bachan chihtán síw̃quinat, fariséoin owár wiw̃á rojocro. Wiw̃á eya ima sera bár bin jor cuic cut questa cámjacro. Eyta camyat uwat itchacro. Ityat bachan chihtán síw̃quinat fariséoin owár wiw̃á eya cac béjecro. Cac beyar Jesús quin rojocro. Roquír uw bahnaquin cac cahmar chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Etar éyinat Jesús quin wajacro: —Síw̃quibu, uch wiw̃á ima ra bár bin jor camic uwat itchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","’Is bach cáritan chihtá cáritan cutar Moisesat wajacro: “Wiw̃á ima ra bár bin jor camic ityat, yauwátaro. Yauwin acu ac tétaro,” wajacro, Moisesat. ¿Ahra bahat bitara wacátaca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Fariséoinat Jesús cayar yajquín acu eyta táyojocro, Jesús rion acu. Fariseo imarat, “Jesusat ay bár wajác,” waquín acu eyta táyojocro. Eyta táyoyat, Jesús ic icar bahujacro. Bahúr at ub cut ic icar cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jesusat ic icar cuihsuyat, éyinat bucoy cat, bucoy cat ey quin seo táyojocro: —¿Bahat bitara wacátaca? ¿Wiw̃ eya ac cut yauwátayica? táyojocro. Etat Jesús sicor cuih yehnár eyin quin wajacro: —Biyat Sir tayar anto icar istiy yajti eyat récaji ac tewi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Etat eyat bucoy bahúr ic icar cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Biyat Sir tayar anto icar istiy yajti eyat ibtu ac teta wacayat, uw istiy cat, istiy cat, suca béjecro. Werjayín cahmor suca béjecro. Yahncut istiy cat, istiy cat bahnaquin sicor béjecro. Jesús im istir bahjacro. Wiw̃á cat áhajira erar cuihro. ");
INSERT INTO tuf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Uw bey yiror Jesús sicor cuih yehnjacro. Yehnár wiw̃á quin wajacro: —¿Wiw̃ú, uw biscanca, bah cahm icar tew̃jáquina? -wajacro-. ¿Uw istiyati bah ay bár yajác tayar chítiica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Uw batro. Istiyati chítiro, wajacro. Etat Jesusat wajacro: —Ihyú, éytatara aját cat bah quin ay bár yajác tayar chítiro, -wajacro-. Ahra biwa. Acsar ur ay bár yajti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesusat bucoy Sir usar uw sécuajaquin quin tew̃ír wajacro: —Cajc bahnác cutar urá wíqueyra, cuan áyqueyra asan eyro. Biyin as chiwa chácayat, eyin ur icar aját cuanír éytaan wan chácaro. Eyin quin urá wícaro. Sir owár etiti ohbac itin ac ajc waacaro. Urá bár béquinan tinjac cutar beyar éytaro. Urá wícayat, eyin bucoy éytara beya báreyra, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jesusat eyta waquít fariséoinat wajacro: —Ahra bahat behm ojcor tew̃ro. Behm ojcor tew̃quey icr acui batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Etat Jesusat wajacro: —Ajmár ojcor tew̃ cuar aját uní wacaro. As biscán bíntara, birar béntara ajmarát itro, -wajacro-. Baatrá as biscán bíntara, birar béntara istítiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Baatrá uw urá bitáratara istiti cuar, uwat yajc istír car eyin quin ay bár yajác tayar chícaro. Cuat ajatrá uw quin tayar chítiro. ");
INSERT INTO tuf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ajatrá tayar chiquir waquít, uní chiátaro. As Tetatán, as áyjaqueyatan as jor chiata rehquít, aját uní chiátaro. ");
INSERT INTO tuf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bach cáritan chihtá cáritan cutaran uchta cuihsujacro, “Cuisa bucáy binat chihtán istán téw̃yatan, uniro,” cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ajatrá ajmár ojcor tew̃ro. Tetatán as áyqueyatan cat as ojcor tew̃ro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Etat uwat Jesús quin wajacro: —¿Bah Tetrá biscanca? táyojocro. Etat Jesusat eyin quin wajacro: —Baat as istítiro, -wajacro-. As Tet cat istítiro, -wajacro-. As istír waquít, as Tetá cat it chácata binro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesusat Sir usar siw̃a rabar eyta wajacro. Sir usar ray chaquic cajón ésatro. Ey ecsar ita rabar eyta wajacro. Eyta wajác cuar, istiyati ey cárcel sar chaquin acu cátiro. Ey cárcel sar chaquin acu anto cab cutiro. ");
INSERT INTO tuf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesusat bucoy eyin quin wajacro: —As bar bicaro. Bi yahncút baat as wahitátaro. Eyta wahitic cuar, ba ay bár yajác tayar ques sácayqueyra. As birar bíctara ba erar béyajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Eyta waquít judío cárinat wajacro: —Jesusat wacaro: “As birar bíctara ba erar béyajatro,” wacaro. ¿Eyta wacayat imát yaúwini séhw̃actara? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Etat Jesusat wajacro: —Ba usár cahm binro. Asra cuacúr binro. Ba cajc uch cutar binro. As cajc uch cutar bini batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Etarwan aját ba quin wajacro: “Behmár ay bár yajác tayar chi sácataro,” wajacro. Aját ba quin as rehrtara ehcujacro. Eyta ehcujaquin baat asan ey síhw̃atiro. Asan ey síhw̃ati rehquít, ba ay bár yajác tayar chi sácataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Etat éyinat wajacro: —¿Bah rehrcá? táyojocro. Etat Jesusat wajacro: —Aját asan rehrtara récajian aha ocso tas cuar, bucoy cat, bucoy cat ba quin bar ehcujacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Baat ur ay bár yajác ojcor aját chiht istiy, chiht istiy tew̃ata cuar téw̃tiro. Ba ay bár yajác tayar chiata cuar, aját chítiro. Aját as ayquey chihtá ehcuro. Eyat uní wacaro. Eyat as quin tew̃jác uw bahnaquin quin ehcuro. Chihtá istiyrá téw̃tiro, wajacro, Jesusat uw quin. ");
INSERT INTO tuf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesusat Tetá ojcor tew̃jác uwat ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eyta rehquít Jesusat uw quin wajacro: —Baat asa Uw Síuquib caruc ojcor cuacúr yehw̃áyqueyra. Cuacúr yehw̃yat, aját behmár quin asan rehrtara ehcujaquey istáyqueyra. Asan eyro, istáyqueyra. Etat baat istáyqueyra. Aját ajmár chihtá cutar icrí yájtiro. Tetát as síw̃jaquey chiht ey tew̃ro. Chiht istiyrá téw̃tiro. Baat eyta istáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","As áyjaqueya as jotro. Eyat icúr yaj cun réhctara aját eyta yajcaro. Eyta yajc rehquít, eyat as istir báhtiro. Baat as caruc ojcor cuacúr yehw̃yat, eyta istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesusat eyta wacayat, uwan to binat ey tamo síhw̃ajacro. “Eyat is síwataro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Etar Jesusat judíoin ima tamo síhw̃aquin quin wajacro: —Aját siw̃quey yajw̃i. Eyta yajcayat, as chiwa quen bin rehcáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Baat uní queney istáyqueyra. Ey ityat ba ohbac ítayqueyra. Uwat cacmá esclavo caquir questár sicor ricuayat ricuajáqueyan ohbac itro. Ohbac itir eyta ba cat uní queney istíc rehquít ricuajáqueyan wan ohbac ítayqueyra. Etat éyinat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Isan Abraham bómcatro. Isra cacmá esclavo bíyati caquir questátiro, -wajacro-. “Is ricuajáqueyan wan ohbac ítayqueyra,” wacayat, ¿bahat bi ojcor tew̃qui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Etat Jesusat eyin quin wajacro: —Bíyinat ay bár yajcayat, eyin Sisrám esclávoro. Sisrám cacumró. Eyinat imár chihtá cut ay bár yajquíc étajatro. ");
INSERT INTO tuf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cacmá esclavo cara im ey owár etiti ítajatro. Eyta cuar wacjeyra ima tet owár etiti ítataro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Etar asan Sir wacját Sisrám ohnor ba síuyat, ba ohbac ítayqueyra. Sisramat ba bucoy síwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Baan Abraham bómcarin aját itro. Abraham bomcar cuar, baat as yauwin úroro. Aját siw̃quey chihtá rácari bár rehquít, as yauwin úroro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","As Tetát as quin ehcujác ey ehcuro. Eyta cuar baat behmár tetát wajaquey yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Etat éyinat wajacro: —Abraham is tetró, wajacro. Eyta waquít Jesusat wajacro: —Ba unian Abraham sasá rehquír waquít Abrahamat yajquír eyta bahat eyta yajcátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sirat as quin wajác ey uniro. Sirat as quin uní wajác eyra aját ba quin ehcujacro. Eyta ehcujác cuar baat as yauwin úroro, -wajacro-. Abrahámatra éytara yájtiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ba tetát yajquír eyta baat eyta yajcaro, wajacro. Etat éyinat wajacro: —Isra besir bini batro. Sir iman is tetró. Tet ístira batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Etat Jesusat eyin quin wajacro: —Siran unian ba tetír waquít, baat cat as sehnác chácata biro. As Sir jor bin usar wijác rehquít, as sehnác chácata biro, -wajacro-. Ahra as usatro. Ajmár chihtá cut rátiro. Sirat as áyjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bitara reht aját wajác ey ráhctiqui? -wajacro-. Baat rahcuí cun bár rehquít ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Behmár tet Sisramro. Baan Sisrám sasaro. Behmár tet urá cutan baatán icúr yajca rácaratara baatán eyta yaj cun rehcaro. Sisramat récaji yaujacan áhajira im eyta yauro. Icúr unítara síntiro. Im ur icar uní síntiro. Sisrama tew̃yat sínquibro. Etar uní téw̃tiro. Eya tew̃yat sini tútcuatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ajatrá ba quin uní wacaro. Aját ba quin uní wajác rehquít, baat aját wajaquey ráhctiro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","As ojcor aját ay bár yajác bíyati wácajatro. Aját uní wajacro. Eyta cuar as chihtá ráhctiro. ¿Bitara reht, as chihtá ráhctiqui? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sir sasatra Sir ajca rahcro. Eyta cuar bara Sir sasáy batro. Eyta rehquít baat ráhctiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Etat judíoinat Jesús quin wajacro: —Isat wajacro: “Bah Samaria binro. Bah cuicát isó bicaro,” wajacro. Isat wajacan uní wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Etat Jesusat wajacro: —Asra cuicát isótiro, -wajacro-. Aját as Tetá ajcá ji bécaro. Eyta cuar batra as ajcá ji bétiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ajmár chihtá cutari uw quin as ajcá ji beyin wátiro. Cuatán Síratan Tetatán uwat as ajcá ji beya rácatro. Etar cat bíyinat as ajcá ji bétieyra, Tetát eyin quin tayar chiáyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aját bah quin uní wacaro. Bíyinat as ajc rahcuír yajcayat, eyin Sir owár sácati ítayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Etat judíoinat Jesús quin wajacro: —Ahra isat ítitan, behmá cuicát isó bicaro, -wajacro-. Abraham yarjacro. Sir chihtá ehcuquin cat sácajacro. Eyta cuar bahat waquít: “Bíyinat as ajc rahcuír yajcayat, eyin sácati ítataro,” -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Is tetá Abraham yarjacro. ¿Bah urán Abraham cuiti séhw̃aca? Sir chihtá ehcuquin cat sácajacro. ¿Bahan rehr séhw̃aca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Etat Jesusat wajacro: —Ajatrá ajmár ojcor “As ayro,” waquír waquít, eyta tew̃quey icr acui batro, -wajacro-. Eyta cuar as Tetát as ojcor ay wacaro. Baat im ey ojcor “Eyan is Sitro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eyta waquíc cuara baat eyra istítiro. Ajatrá ey itro. Aját “eyra istítiro,” waquír waquít aját tew̃yat sínataro. Baat tew̃yat sinir eyta aját cat eyta tew̃yat sínataro. Aját ey ajc rahcuír yajcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bah tet Abrahamat as yehnata itchacro. As yehnata istír, ahní rehjecro, wajacro, Jesusat judíoin quin. ");
INSERT INTO tuf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Etat judíoinat wajacro: —Bah yehnjác anto bara cincuenta cutiro. Eyta cuar ¿Bahat “aját Abraham itro,” waquí? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Etat Jesusat wajacro: —Aját ba quin wacaro. Abraham anto yehnti cuat as ítchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesusat eyta wacayat, éyinat ac yehw̃jacro. Jesús cut ten acu ac yehw̃jacro. Eyta cuar Jesusra ruhcuír éyinat istiti Sir usar bin watar bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús be rabar ub bár bin itchacro. Ser eya ub bár yehnjacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ityat Jesús chiwat ey quin táyojocro: —Síw̃quibu, ¿Eya rehr chihtá rehquír ub bár yehnyi? ¿Ey tetinát ay bár yajác chihtá rehquíritara? ¿Imát ay bár yajác chihtá rehquíritara? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Etat Jesusat wajacro: —Imát ay bár yajác oquisi batro. Ey tetinát ay bár yajác oquisi batro. Sir imát ajcan urán ehcún acu ser eya ub bár yehnjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","As áyjaqueyat yajcata wajác ey isat yajcátaro. Aha eyta yajcata cab cuácayat cutar yajcátaro. Biráy bár cuat eyta yajquín acu cab waa béyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","As cajc cutar ita rabar asan cuan áyquibro. Urá wíquibro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesusat eyta waquír, caná rihar ic icar tijcajacro. Caná rihar ica cut rihnojocro. Eyta rihnór ub bár bin ub cutar ánjacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Anir ey quin wajacro: —Riw órojoc ajca Siloé cutar sucuáy biwi, wajacro. Siloé ajc istiy cut “áyjacro” aw̃uro. Jesusat ayat, ser eya sucuáy bijacro. Sucuír wicayat, sicor ub ji wijacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ub ji wicayat, ecsar ítquinat cat, ray chiquic itcháqueyinat cat táyojocro: —¿Eyra ray buw̃ún acu usár chihrír itchac éyica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Etat cahujinat wajacro: —Ee, eyan ray chi yarjáqueyro, wajacro. Eyta cuar cahujinat wajacro: —Eyan wan cuar, eyra eyi batro, wajacro. Uwat eyta wacayat, imát wajacro: —Asan eyro. Asan ub bár usár chihrír ítchaqueyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Etat éyinat wajacro: —¿Bah ub ji rehquín acu bitara yajcyi? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Etat eyat wajacro: —Ser ajc Jesusat caná rihar ica cut tijcár rihnojocro. Rihnór as ub cutar ánjacro. Anir as quin wacárora: “Siloé riw cut sucuáy biwi,” wacárora. Eyta wacayat, as érara sucuáy bijacro. Sucyat as ub ji rehjecro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Etat éyinat wajacro: —¿Ahra Jesusra bírarca? wajacro. Eyat wajacro: —Ajatwán istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Etat éyinat récaji ub bár ítchaqueyan fariséoin quin yehw̃ béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesusat ub bár ey ub ji chájacan tan jaquin ricar cuanjacro. Tan jaquin ricar cuayat caná rihar ica cut rihnór ub bár ey ub cutar ánjacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariséoin quin cucayat, fariséoinat ub ji chájaquey quin wajacro: —¿Bah ub ji rehquín acu bitara yajcyi? táyojocro. Etat eyat wajacro: —Jesusat as ub cutar caná rihar ica cut rihnór ánjacro. Anyat as sujacro. Sucuír ahra as ub jiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Etat fariséoin cahujinat wajacro: —Ser eyta yajáqueyra Sirat ayjac bini batro. Eyat canar yájcajar ricar bach auro, wajacro. Eyta cuar cahujinat wajacro: —Ay bár yájqueyat uw ub ji bitách chácajatro, wajacro. Fariséoin ey ques wahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Etar fariséoinat bucoy ub ji chájaquey quin wajacro: —Bahat waquít, Jesusat bah ub ji chájacro. ¿Bahat ítitan, ser eya rehrcá? táyojocro. Etat ub ji rehjéqueyat wajacro: —Eya Sir chihtá ehcúquibro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judío cárinat ser ey ria cac cun bár rehjecro. Ser ey ub bár yehnjác síhw̃atiro. Ub bár bi ub ji chajac síhw̃atiro. Eyta rehquít tetín abín chíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chiír cucayat eyin quin wajacro: —¿Uyan ba waquijquí? Behmarat waquít, ¿eya ub bár yehnyi? ¿Ub bár bi yehnjáctara, ahra bitara cuácayat itqui? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Etat tetinát wajacro: —Isat ítitan, eya is waquijró. Ub bár yehnjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Eyta cuar ahra bitara cuácayat, ub cut istíctara, isat istítiro. Rehrát ey ub ji chájactara, isat istítiro, -wajacro-. Ima quin táyowi, -wajacro-. Eyan bihtro. Imát bar tew̃átaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tetinát judío carin cahmar ay wini rehquít eyta wajacro. Judío cárinat imár owár tew̃ír wajacro: “Bíyinat ‘Sirat Cara Ayin Wajaquin Jesusan eyro,’ wacayat, eyin secuac usar rauw áyajatro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Judío cárinat eyta wajác rehquít, ub ji chájaquey tetinát “Eyan bihtro. Ima quin táyowi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Etar judío cárinat bucoy ub bár yehnjaquey chíjacro. Bucoy wícayat, ey quin wajacro: —Sir ub cahmor is quin uní waw̃i. Isat ítitan, Jesusan ur ay bár yájquibro, wajacro. Etat ub bár yehnjáqueyat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Jesusat ay bár yájctara, yájtitara ajatwán istítiro. Ajatrá uch itro. As ub bár yehnjacro. Ahra aját ub cuitar itro. Ub jiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Etat cárinat wajacro: —¿Bah acu icúr yajcyi? -wajacro-. ¿Bah ub ji rehquín acu bitara yajcyi? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Etat ub bár yehnjáqueyat wajacro: —Aját icar istiy ba quin bar ehcujacro. Ehcwayat baat as ria cátiro, -wajacro-. ¿Bitara etar bucoy rahcuí cun rehqui? ¿Ba cat ey chiwa cha cun rehca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Etat éyinat ub bár bi yehnjaquey ajc ahsín técuajacro. Uch cat wajacro: —Bahan ser ey chíwaro, -wajacro-. Cuatán isra Moisés chíwaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Isat ítitan, Sirat Moisés quin tew̃jacro. Ser eyra biscán bíntara istítiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Etat ub bár yehnjáqueyat wajacro: —¿Bahat istiti waátaqui? -wajacro-. Baat as quin wacárora: “Eyra biscán bíntara isat istítiro,” wacárora. Eyta wajác cuara eyat as ub ji orac chájacro, wajacro. Acsar cat ub bár yehnjaqueyat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","—Isat ítitan, Sirat ur ay bár yajquey ráhctiro. Im ajcá ji béqueyin chihtá rahcro. Im chihtá yájqueyin rahcro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Récaram cajc chajac aha ocso tas cuar, ub bár bin yehnjác istiyati ub ji chátiro, -wajacro-. Ub chi chajac ojcor tew̃ic istiyati ráhctiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eyra Sirat áytiir waquít uw ub ji bitách chácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Etat éyinat wajacro: —Baha ur ay bár yehnjacro. Bah yehnár aha ocso tas cuar ur ay bár yajcaro, -wajacro-. ¿Bahat is siw̃ini séhw̃aqui? Judío cárinat eyta waquír, ub bár bin yehnjaquey secuac usar bin ay bo téjecro. ");
INSERT INTO tuf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eyta áyjaquey chihtá Jesusat cat rahjacro. Rahcuír ub ji chájaquey wahitchacro. Istír ey quin wajacro: —¿Bahat Uw Síuquib tamo séhw̃aqui? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Etat eyat wajacro: —Uw Síuquib rehrtara as quin ehcuwi, -wajacro-. Aját ey tamo séhw̃ayta acu ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Etat Jesusat ey quin wajacro: —Bahat ey bar itchacro. Asan eyro. Bah jor téw̃queyan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Etat eyat wajacro: —Caru, aját eyta séhw̃aro: “Uw Síuquib bahan eyro,” séhw̃aro, wajacro. Eyta waquír Jesús cac cahm cuscar cut chihrjacro, “Jesusan ayro,” sehw̃ac ehcún acu. ");
INSERT INTO tuf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Etat Jesusat wajacro: —Uwat Sir tayar yajác imár quin ehcún acu as cajc uch cutar rajacro, -wajacro-. Eyta ehcwayat uw cahujinat imár ojcor síhw̃ayqueyra. “Ub bár bin birar bíctara istiti eyta, imarat cat eyta Sir tayar istiti rabara yajacro,” síhw̃ayqueyra. Eyta síhw̃aqueyin aját ub bár bin ub ji chaquir eyta eyin éytaan wan urá ji chácayqueyra. Eyta cuar cahujinat ay bár yajc cuar, imaran urá ji síhw̃aro. Eyta síhw̃aqueyin aját ub ji bin ub bár chaquir eyta eyin eyta urá bár chácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Etat fariséoin cahujinat Jesusat eyta wacayat, rahjacro. Rahcuír wajacro: —Bahat sehw̃at ¿is ub bár binan wanqui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Etat Jesusat wajacro: —Baat ub bár bin eyta urá barir waquít, ay bár yajác tacat tayar chíyajatro. Eyta cuar behmarat waquít, isan ub ji cháquiran wan urá jiro. Eyta rehquít, baat ay bár yajác tayar chiyátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Acsar Jesusat wajacro: —Aját ba quin wacaro. Uwan biyan obas querá sar querat cutar rauti cuar, bi icar, bi icar rauyat eya bésibro. Eyatra bes yajcaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Uwan biyan querat cutar rauyat, eyra obas cayibro. ");
INSERT INTO tuf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Querat úroquibat cayíb acu querat waacaro. Obasat cayíb ey ajc rahcro. Eyat im óbasan imár ajc chájaquey cut cohw chícaro. Querá sar bin watar eyin uquin acu cat cahmor bicaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Watar waar car eyin cohcarcám bicaro. Obasan ey questoc bécaro. Ey ajc rahcuír, rehrtara istíc rehquít, ey questoc bécaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Obasan cahujín quéstocra bétiro. Beti cuar cahujín ayot quinátaro. Cahujín ajc istiti rehquít quinátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesusat uw siw̃in obas ojcor eyta ehcujacro. Eyta cuar bi ojcor síw̃ictara, uwat ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Etat Jesusat acsar wajacro: —Aját ba quin wacaro. Obasa querat cutar rauwir eyta uwan eyta as cutar raúwayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tew̃yat sínquinat as cahmor wijacro. Eyinat wajacro: “Sirat is áyjacro.” Eyta tew̃yat sínjacro. Eyinan bésiban wanro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Asan quératan wanro. Biyin as cutar rauyat, as tamo síhw̃ayat, eyin bar síwayqueyra. Ohbac ítayqueyra. Síuyat óbasan wan imaran bitat quer sar rau cuntar etat rauro. Imaran bitat ira yayay watar waa cuntar etat waacaro. Banar ay bi cutar itro. Aját uw éytaan wan obir yajcaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bésinat ay yajquín séhw̃ari rátiro. Bes yajquín acu, quehwín acu, chiw̃ín acu racaro. Ajatrá eyta yajquín acui rátiro. Asan uw ohbac ítayta acu rajacro. Sir owár etiti ítayta acu rajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Obas cayíb ay biyan wan, asan eyro. Obas cayíb ay biyat, obas sehná reht chinátaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cacumatrá obas obir yajcayat, bowar bayar técuasan abáy bin raquíc istír quinro. Obas ajcá bár cham bahr quinro. Obas cham bahcayat, bowar báyarat obas cácaro. Cácayat obas cahujinra ayot cui bécaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cacúm eyra obas imáy bár rehquít bowar bayar ayot quinro. Obas ajcá ji bétiro. ");
INSERT INTO tuf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Obas cayíb ay biyan wan asan eyro. As chihtá cájaquin as óbasan wanro. As Tetát as itro. Aját cat ajmár Tet cat itro. Tetát as istír eyta, aját ajmár óbasin eyta itro. Aját as Tet istír eyta, as óbasinat cat as eyta itro. Aját eyin obir yajquín acu chinátaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","As obas cahujín cat chero. Eyinra uch quer sar anto raútiro. Aját eyin cat sécuataro. Eyinat as ajc rahcuátaro. Eyinan cahmor eyin owár istán cutar sécuataro. Eyin acu cayíb istán rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","As bucoy yehnín acu as bar chinata etar, Tetát as sehnacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","As bíyati yau áyajatro, aját ajc waátieyra. As yauwin ajmarát ajc waátaro. Ajmár urá cut sicor yehnátaro. Tetát aját eyta yajquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesusat eyta wacayat, judíoinat rahcuír bucoy ey chihtá ques wahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Uwan to binat wajacro: —¿Bitara reht ey chihtá ráhcuiqui? Ima cuicát isó bicaro. Túraritro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eyta cuar cahujinat wajacro: —Cuicát isó bíqueyinat éytara téw̃ajatro, -wajacro-. Cuicát ub bár bin sicor ub ji chácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sir ac im ubach ajquír chajac tamo sihw̃an acu fiesta yajacro, pueblo Jerusalén cutar. Ey fiesta yajquín acu bar cab cujacro, bara cutar. ");
INSERT INTO tuf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sir usar ar istiy ajc Salomón aw̃uro. Etat owár Jesús Sir usi cutar Salomón ara cahmor bicaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Salomón ara cahmor bicayat, judíoin ey quemir sécuajacro. Secuar Jesús quin wajacro: —Bah Sirat Cara Ayin Wajaquin éytara, ey bártara is quin récaji waw̃i. ¿Bahat is quin ehcún cahmor bita ítataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Etat Jesusat wajacro: —Aját ba quin bar ehcujác cuar, baat aját uní wajác síhw̃atiro, -wajacro-. Tetát yajc áyjaquey yajquír cutar ehcuro. Sirat Cara Ayin Wajaquin asan eyro, ehcuro. Caba ehcuro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Eyta cuar as obas bár eyta baan eyta as uwi batro. As uwi bár rehquít, baat asan ey síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Obasatan ima cayíb ajc rahcuír eyta, as úwatan as ajc eyta rahcro. Aját eyin itro. Etar cat eyin as owár cuiti bécaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aját eyin quin Sir owár etiti ohbac itin ac ajc waacaro. Eyinra saca báreyra. Aját eyin obir yajcayat, cahujinat eyin as ohnor síwajatro. ");
INSERT INTO tuf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","As Tetát eyin as quin wíjacro. As Tetá bahnác cuitatro. Bíyati eyin as Tet at icar bin síwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tetán as owár im istanro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesusat eyta wacayat, judíoinat bucoy Jesús cut ten acu ac yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Etat Jesusat eyin quin wajacro: —Aját ba ub acat Sir urá cut bucoy cat, bucoy cat ay yajacro. ¿Aját bi ay yajác ques icar as tecuan acu as cut ac ténica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Etat judíoinat wajacro: —Bahat ay yajác quesi isat bah cut ac teni síhw̃atiro, -wajacro-. Cuatán bahat Sir ojcor téw̃ajar bin tew̃jác ques bah cut ac ten síhw̃aro, -wajacro-. Bahan uwro. Uw cuar bahat waquít: “Sir as owár im istanro,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Etat Jesusat wajacro: —Behmár bach cáritan chihtá cáritan cutar uchta cuihsujacro: “Sirat wacaro: ‘Baan sírincuano,’ wacaro.” ’Behmár carit cutar eyta cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Isat ítitan, Sir carit cutar cuihsujaquey tehmótiro. Uní wacaro. Eyta cuácayat, Sir carit cutar uchta wacaro: “Sirat chihtá wíjaqueyinan sírincuano,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Etar cat Sirat im acu as ajquír chájacro. Ajquír chaquir, as cajc cutar itin áyjacro. Sir carit “Sirat chihtá wíjaqueyin sírincuano,” wacaro. Sirat as áyjacro. Etara aját “asan Sir wacjá” wacayat, ¿bitara reht aját “Sir ojcor téw̃ajar bin tew̃jacro,” wacyi? ");
INSERT INTO tuf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","’As Tetát yajc áyjaquey aját yájtiir waquít, aját uní wac síhw̃ati jaw̃i, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Baatán aját uní wac síhw̃ati cuar, aját as Tetát yajc áyjaquey yajcayat, baat eyta yajquey istír uchta síhw̃ataro: “Sir urá ey ícatro. Ey urá Sir ícatro,” síhw̃ataro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bucoy éyinat Jesús caquir questár beyin yinjacro. Eyta cuar Jesús cati bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús sicor rih Jordán rahray bijacro. Juanat uw rih sar siw̃jác awat cutar cujacro. Erar ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Uw ricán to Jesús quin rojocro. Roquír wajacro: —Juanat Sir urá cut bahnác bár yajcata ehcún acu icrí yájtiro. Eyta cuar Juanat sera uch ojcor wajacan bahnác uní wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Erara uw ricán to binat “Sirat Cara Ayin Wajaquin Jesusan eyro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Riy istiy ser ajca Lázaro yar bijacro. Lázaro pueblo Betania cutar ítchacro. Pueblo Betania cutar Lázaro ima chitín owár ítchacro. María owár, Marta owár ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María eya Jesús quescar ojcor aceite inan ay bi ójoqueyro. Cuis anar cut iw̃jáqueyro. ");
INSERT INTO tuf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ima coch Lázaro yaryat, chitinát Jesús quin chihtá áyjacro. Chihtá uchta wac áyjacro: —Caru, bah íw̃ocan, bah sehnác bin yatro, wac áyjacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesusat eyta rahcuír wajacro: —Eyta yaric cuar ruw̃ár ojcor yarin acu yártiro. Sir ajcan urán ehcún acu yatro, -wajacro-. Eyta yari cutar uwat as Sir wacjá ajcan urán chey istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marta cat, ey rab cat, Lázaro cat Jesús íw̃oquinro. ");
INSERT INTO tuf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iw̃oquin cuar Lázaro yaric chihtá rahcuír, im erar boni cuanjacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Boni cuanír, ima chiwa quin wajacro: —Bar jaw̃a, sicor cajc Judea cuwayta. ");
INSERT INTO tuf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Etat ima chiwat Jesús quin wajacro: —Síw̃quibu, judíoinat bah cut ten acu ac yehw̃jác biráy bár cuanjacro, -wajacro-. ¿Bahat sicor erar ben séhw̃aca? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Etat ima chinic cab anto cuti ey ehcún acu Jesusat uchta wajacro: —Rahsa waar car sicor tinín acu doce hora rehcaro, -wajacro-. Uwa ricar cutar bécayat, búnabo tétiro. Ricar cuitar wanquírcuano. Wanquír cuácayat bahnác itro. Etar búnabo tétiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Eyta cuar cheycar cutar bicayat, búnabo tétaro. Cheycar cutar wanquír bár rehquít ístajatro. Etar búnabo técaro, -wajacro-. Uwa rícara cuitar becayat búnabo teti eyta as cat eyta Judea bicayat, china báreyra. As chinic cab anto cutiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Etar cat Jesusat wajacro: —Is íw̃oquin Lázaro bar cámjacro, -wajacro-. Aját ey quehw̃ay benro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Etat im chiwat wajacro: —Caru, Lázaro cámjactara, ima bar tan jácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesusat Lázaro chinjác ojcor wajacro. Eyta cuar ima chiwat Lázaro inic camjac síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Etar Jesusat éyinat orac rahcuayta acu wajacro: —Lázaro, bahnác chinjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Asan erar rehti chájacan ba ácuan yarisro. Ahra baat as tamo cuít síhw̃ataro, -wajacro-. Bar jaw̃i, Lázaro wahitay. ");
INSERT INTO tuf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Etat Tomás wisa aw̃ujáqueyat chiwa cahujín quin wajacro: —Bar jaw̃i, siw̃quib owár sacan acu, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús Betania ima chiwa owár béjecro. Cur rahcuít Lázaro bar chinjacro. Ey chein ruhjacan bacáy cuanjacro. Cucayat ");
INSERT INTO tuf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","judíoinan to ésatro. Betania bin Jerusalén cuwayta biráy bárcuano. Kilometro bátacuano. ");
INSERT INTO tuf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Etar judíoin to binat Marta cat, María cat itáy rojocro. Coch chinjác urá cue rehjéc chihrayta acu rojocro. ");
INSERT INTO tuf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús raquíc tew̃íc Mártaat rahjacro. Rahcuír Jesús tihráy bijacro. Eyta cuar María biti usi ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ibta aw̃at ityat, Mártaat bir Jesús raquíc acat tihrír ey quin wajacro: —Caru, bah usár chájaquir waquít, as cochá yarti ítata yajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Eyta cuar aját ítitan, bahat icúr chíctara Sirat ey yajcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Etat Jesusat wajacro: —Bah cochá sicor estají bar yehnáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Etat Mártaat wajacro: —Aját eyta itro. Cábara tinyat, sácajaqueyin sicor yináyqueyra. Eyta yinyat cat Lázaro cat sicor yehnátaro. Aját itro. ");
INSERT INTO tuf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Etat Jesusat wajacro: —Asan sácajaquin sicor yin áyqueyro. Asan Sir owár etiti ohbac it áyqueyro. Bíyinat as tamo síhw̃ayat, eyin sicor yin áyinro. Eyin sácajac tacat, aját sicor yin ayir, Sir owár etiti ohbac itin ac ajc waanro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Etar cat biyin Sir owár ohbac ityat, as tamo síhw̃ayat, eyin saca báreyra, -wajacro-. ¿Ey chihtá ráhcuica? ");
INSERT INTO tuf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Etat Mártaat wajacro: —Ee, caru, aját eyta séhw̃aro, -wajacro-. Aját sehw̃at “Sirat Cara Ayin Wajaquin bahan eyro,” séhw̃aro. Bah Sir waquijró. Sirat cajc uch cutar wacjá ayin wajaquin bahan eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mártaat eyta waquír, sicor María quin rajacro. Wiquír María quin cahujinat rahcti acu cuach cuach wajacro: —Siw̃quib bar rajacro. Bah chícaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maríat eyta rahcuír, in yehnár, Jesús tihráy bijacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús anto pueblo icar raútiro. Pueblo ácubar Mártaat tihrjác cutar im ératro. ");
INSERT INTO tuf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judíoin, María coch chinjaquey urá cue rehjéc chihrín rojóqueyin María owár usi ítchacro. María yehnár inchajin biquic ityat, ey questoc béjecro. Eyinat síhw̃ajacro: “María chein ruhcuíc cuitar oy bic,” síhw̃ajacro. Eyta sehw̃ar ey questoc béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesús quin cur cuscar cut chihrjacro. Chihrír conjacro: —Caru, bah usár chájaquir waquít, as cochá yarti ítata yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesusat María conic itchacro. Judíoin María owár rojoquin conic itchacro. Conic istír, ey cat im ur icar to cuécujacro. To cuecur eyin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Bisar ruhcyi? táyojocro. Etat éyinat wajacro: —Wahitay bar jaw̃, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Etar Jesús catum ojocro. ");
INSERT INTO tuf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesús ócayat, judíoinat eyta istír wajacro: —Wahítuwi. Jesús Lázaro sehná reht ócaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eyta cuar judío cahujinat wajacro: —Jesusat ub bár bin ub ji chájacro. Ub bár bin ub ji chájactara, usár chájaquir waquít, Lázaro cat bar tan jácata bin óraro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús cue rehquír bucoy o cun rehjecro. Etat owár chein ruhjaquey cutar bijacro. Chein ac ucar icar ruhjácuano. Ucar cac sar ac ohná chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús erar cur wajacro: —Ac ohná ucar canó chájaquey waar bo tewi, wajacro. Etat chein chitá Mártaat wajacro: —Caru, baniran to óraro. Ey chinjác ahra bacáy cuanjacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Etat Jesusat Marta quin wajacro: —Aját bah quin waquiri: “Bahat as tamo séhw̃ayat, Sir ajcan cámuran istátaro,” waquiri. ");
INSERT INTO tuf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jesús chihtá cut aca ucar canó chájaquey waar bo téjecro. Waar bo ter car, Jesusat cuacúr wahitchacro. Cuacúr wahitír wajacro: —Tetú, oquéy, bah ur ayro. Bahat as ajc rahcro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aját ítitan, bahat as ajc etiti rahcro. Eyta cuar aját uch uwat as tamo bahat as ayjac séhw̃ayta acu eyta tew̃ro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesusat eyta waquír, ay bar cohwír wajacro: —Lázaru, watar waawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jesusat eyta wacayat, chein watar waajacro. Watar waar chein átcara oya tamo bacojocan im éytaro. Quescar cat oya tamo bacojóc im éytaro. Ac cutar cat oya cut questajacan im éytaro. Eyta wacayat, Jesusat wajacro: —Lázaro oya rícuawi, -wajacro-, ima ben acu. ");
INSERT INTO tuf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judíoin María urá cue rehjéc urá chihrín rojóqueyinat cat itchacro. Jesusat chein ruhjaquey sicor estají chajac itchacro. Eyta istír judíoin to binat “Jesusan Sir waquijró,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Cuatán cahujinra fariséoin quin sicor béjecro. Eyin quin cur, Jesusat yajác ey ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Eyta cuácayat fariséoinat, sacerdote cárinat werjayín carin owár secuan chíjacro. Chiír sécuajacro. Secuar wajacro: —¿Isat icúr yajcátaca? Ser eyat bahnác bar yajcata bucoy cat, bucoy cat ehcuro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Isat acsar eyat yajti acu síutieyra, uw bahnáquinat ey tamo sihw̃ay yináyqueyra. Etat romano carin bar rocáyqueyra. Roquír, Sir ubach cat chiw̃áyqueyra. Bahnác butí téyqueyra. Uw bahnaquin cat tíw̃ayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Etat eyin owár bin istiyá ajca Caifasat wajacro. Caifás eya bara ey cutar sacerdote bahnaquin cáraro. Eyat wajacro: —Baan urá batro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Baat síntiqui? Ba acu úchtaan ayan cuitro. Uw ubistán bi uw bahnaquin acu chínyatan, ba acu ayan cuitro, uw bahnaquin tiw̃ti acu, wajacro, Caifasat. ");
INSERT INTO tuf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifasat im urá cuiti wátiro. Caifasan ey bara cutar sacerdote bahnaquin cara rehquít, Sir urá cut wajacro. Jesús judíoin acu chinata récaji ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Judíoin istir bin ácua chíntiro. Judíoin acu cat, cajc istiy uw acu cat, cajc istiy uw acu cat chinátaro. Cajc bahnác cutar bin uw ur istán rehcayta acu chinátaro. Caifasat Jesús chinata récaji ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Im ey ricar yahncút judío cárinat Jesús yauwin acu ríojocro. ");
INSERT INTO tuf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Etar Jesús judíoin ub acat bitiro. Pueblo Betania bin acsar bijacro. Cajc buru intac bijacro, pueblo ajca Efraín cuwayta. Erara cur ima chiwa owár ítchacro. ");
INSERT INTO tuf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judíoin Pascua fiesta yajquín acu biráy bár cuanátaro. Etarwan uwan to bin pueblo Jerusalén rojocro. Sir ub cahmar sucuín acu rojocro, bach yajquín cahmor. ");
INSERT INTO tuf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jerusalén behquír Jesús úrojocro. Sir usar uwat rahra rahra wajacro: —¿Baat icúr síhw̃aqui? ¿Jesusat bach yajcáy wicátaitara? ¿wícajaritara? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sacerdote cárinat, fariséoinat, owár binat uw quin wajacro: —Biyat Jesús istíctara eyat is quin ehcwátaro, isat Jesús caquir questán acu, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiesta yajquín acu teray cuanata chájacro. Eyta cuácayat, Jesús sicor pueblo Betania rajacro. Lázaro Betania cutar itro. Lázaro eya chinyat, Jesusat sicor estají chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Betania cutar íw̃oquinat Jesús owár yayín acu ira anjacro. Mártaat uw quin ira tahw̃ujacro. Mártaat tahw̃uyat, Lázaro Jesús owár cohjocro. ");
INSERT INTO tuf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Etat Maríat inan ehchí bi rojocro. Perfume libra istiy rojocro. Ey inan ehchí bi acan tócuano. Roquír Jesús quescara cut uhcajacro. Perfume Jesús ques cut uhcár Maríat ima cuis anará cut iw̃jacro. Eyta uhcayat ubach bahnác cutar inan ehchí rehjecro. ");
INSERT INTO tuf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Uhcayat Judas Iscarióteat wajacro. Judas eyan Jesús ima chíwaro. Jesús quehsí bin at icar yahncút wicata eyro. Eyat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Perfume eya rata bin yajacro. Canar bar istiy yajquír ray cácata eyta tres cientos denarios rata bin yajacro. Rar car, ray oya bár bin quin, ray bár bin quin wícata bin yajacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Júdasat oya bár bin sehnác rehquiti wátiro. Ima besib rehquít eyta wajacro. Júdasan ray chaquic ucu yéhw̃quibro. Ey sar bin bes yajacro. Etar eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Etat Jesusat wajacro: —Cham jaw̃i, -wajacro-. As chein ruhcuín oron acu inan ehchí bi ey yajc jájacro. Etar cham jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ba acor usar cuayin uwra bahná báreyra. Eyta cuar asra usár ba owár etach ita báreyra. Asra ba owár inic itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús pueblo Betania wijác tew̃ic uwan to binat rahjacro. Rahcuír Betania cun béjecro. Jesús itáy béjecro. Lázaro chinjaquey sicor estají chájaquey cat itáy béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eyta cuácayat sacerdote cárinat Lázaro cat yauwin ríojocro. ");
INSERT INTO tuf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro chein sicor estají yehnjác oquís judíoin to binat imár carin chihtá waca tijcajacro, Jesús tamo sihw̃an acu. ");
INSERT INTO tuf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cheycar aracat bijaquey bach yajquín ricán to sécuajacro. Secuar cuanmí cut éyinat Jesús Jerusalén raquíc tew̃íc rahjacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jesús Jerusalén raquíc rahcuír sincuachir bin cay ehsujacro. Ehsúr yehw̃ír Jesús tihráy béjecro. Beya rabar uchta wac cohwjacro: —Bahat is siwin acu conro. Bah Sir chihtá cut rajacro. Sirat bah acu ay rehquín chaw̃i. Bah Israel cara acu Sirat ay rehquín chaw̃i, wac cohwjacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús racayat, asaníc anto síbijin itchacro. Istír ey cutar waar car rajacro. Sir carit cutar úchicrias uchta cuihsú bahjáquinro: ");
INSERT INTO tuf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusaléninu, icúr bi cahmor rooti jaw̃i. Ba cara bar racaro. Asaníc anto síbijin cutar waar car racaro, cuihsú bahjáquinro. ");
INSERT INTO tuf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesús asaníc cutar waar racayat, Sir chihtá cutar eyta cuihsú bahjaquey caba rehjecro. Ima chiwat Jesús raquíc itchacro. Ub cut itchác cuara Sir chihtá cutar cuihsú bahjaquey caba rehjéc ey istítiro. Etat owár ey istiti cuar yahncutra Jesús chinír, sicor estají ayan cuít yéhnyatrun, itchacro. Sir carit Jesús ojcor eyta cuihsú bahjaquey caba rehjéc ey itchacro. Uwat Jesús bitara tihrjactar ey tamo síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús racayat uwan to binat tihrjacro. Jesusat Sir urá cut Lázaro chein cut “Lázaro watur waawi” cohwican uwat itcháquinro. Cohwyat Lázaro sicor estají yehnjác itchacro. Uw ricán to binat itcháquinro. Jesusat yajác istír uwat cahujín quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eyta ehcwayat, Jesusat Sir urá cut Lázaro chein sicor estají chajac chihtá uwat rahjacro. Eyta rahjác rehquít, Jesús tihráy béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bécayat fariséoinat imár owár rahra rahra wajacro: —Isat uw quin “Jesús tamo síhw̃ati jaw̃i,” waquít cat batro. Uw bahnaquin ey wahitay béjecro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Uw ricán to Jerusalén cutar bach yajcáy bejequin sicar cahujinra Griego uwro. ");
INSERT INTO tuf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Griego eyin Felipe quin béjecro. Felípera pueblo Betsaida cajc Galilea cutar binro. Felipe quin cur wajacro: —Werjayú, isat Jesús it cunro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Griégoinat Jesús it cun wacayat, Felípeat Andrés quin ehcwáy bijacro. Andrés quin ehcúr buca jor Jesús quin ehcwáy béjecro. Jesús quin cur wajacro: —Griégoinat bah it cun wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ehcwayat Jesusat eyin quin wajacro: —Sirat ima Cara Ayin Wajaquin ayan cuít ehcún acu bar cab cujacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aját ba quin wacaro. Ritút sasor yehnyat cucú rijaquey ow̃ro. Eyta cuar ritút yehnjaquey uban cuít chácaro. Cuatán cucú rítieyra óhntiro. Ohntieyra im ubistán rehcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bíyinatan bahnacan im chihtá cutar yaj cun rehcayat, éyinan Sir owár ita báreyra. Bíyinat cajc uch cutar ima chihtá cutar yajti cuar, Sir chihtá cutar yaj cun rehcayat, eyin cuacúr Sir owár etiti ohbac ítayqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bíyinan as chiwa chac cúntara éyinan as cucách acor cuiti béyataro. Eyta bécayat, as birar jácayat, eyin cat erar jácayqueyra. Biyin as chiwa chácayat, as Tetát eyin ajcá ji bécaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesusat acsar wajacro: —Ahra as urá cuechín chuchinro. Aját icúr séhw̃atatara istítiro, -wajacro-. ¿Aját wacátaica, “Tetú uwat as yau ayti síuwi,” wacátaica? Eyta cuar eyta wácajatro. As yauwayta cajc uch cutar rajacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tetú, uw quin ehcuwi. Bahan ayan bahnaquin cuitatro, ehcuwi, wajacro. Etat cuacúr bin Sirat wajacro: —As ayan bahnaquin cuitar bar ehcujacro. Bucoy cat ehcunro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Uw ricán to binan erar itro. Eyinat cat ajc rahjacro. Rahcuír cahujinat wajacro: —Cuir tutro, wajacro. Cahujinat wajacro: —Sir cuacúr cacmát Jesús jor tew̃jacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Waquít Jesusat eyin quin wajacro: —Ajc eyan as acui téw̃tiro. Cuat baat rahcuín acu tew̃jacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ahra Sirat cajc uch uw quin ay bár yajác tayar chiáyqueyra. Sisrám cajc uch cutar ayquib ey uc téyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ahra as cajc uch cutar bin cuacúr caruc ojcor yehw̃yat, aját uw bahnaquin as quin roquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eyta wacayat ima bitara chinátatara ey ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Etat uwat wajacro: —Is bach carit cuihsujaquey cutar uchta wacaro: “Sirat Cara Ayin Wajaquin etiti ítataro,” wacaro. ¿Bitara reht Uw Síuquib caruc ojcor yehw̃átaro, waca? ¿Uw Síuquib rehrcá? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Etat Jesusat wajacro: —Asan cuan áyqueya, urá wíqueyan ba owár inic ítataro. As urá wiquey ba owár ityat, as chihtá caw̃i. As chihtá cácayat, ba Sir owár etiti ohbac ítayqueyra. Biyan as chihtá cátieyra éyinat Sir owár ohbac ítajar istítiro. Biyan tinchat cutar bicayat, eyin birar bíctara istítiro. As chihtá cátieyan éytaan wanro. -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Etar asa urá wíqueyan ba owár ityat, aját ba urá wícata síhw̃awi. Aját ba quin urá wícayat úchtaan wan rehcáyqueyra. Cuanyat cajc cutar uwat ay istír eyta, aját ba quin urá wícayat, baat eyta ay istáyqueyra. Urá ji rehcáyqueyra, wajacro. Eyta waquír Jesús bar bijacro. Eyin cahmor ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","38","Uchicrias Sir chihtá ehcuquib Isaíasat uchta wajacro: Caru, isat ba chihtá ehcujacan uwat ráhctiro. Sirat uw quin im ajcan urán ehcujacro. Isaíasat eyta wajacro. Jesusat judíoin ub acat ub bár bin yehnjaquey ub ji chájaquinro. Chein cat sicor estají chájaquinro. Eyta yajác cuar, Isaíasat wajác uní rehquín acu éyinat Jesús tamo Sirat Cara Ayin Wajaquin Jesusan eyro, síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Isaíasat uchta cat wajacro: Sirat eyin ub anjacro. Eyin urá bár chájacro. Eyta chátiir waquít éyinat ub cut wahitír istátaro. Urá ji rehquír cácataro. Eyta caquir urá tehmóyqueyra. Eyta tehmoyat, Sirat imár tayar bár chácayta acu conáyqueyra. Isaíasat eyta wajacro. Eyta rehquít éyinat Jesús tamo “Sirat cara ayin wajaquin eyan eyro,” síhw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaíasat Jesús ojcor eyta wajacro. Jesusan ayan cuít rehcata récaji itchacro. Eyta itchác rehquít Jesús ojcor tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ey rícaran judío carin to binat Jesús tamo síhw̃ajacro. “Sirat Cara Ayin Wajaquin Jesusan eyro,” síhw̃ajacro. Ur ícatra Jesús tamo eyta síhw̃ajac cuar fariséoin cahmar ay wini rehjecro. Ay wini rehquít uw quin ehcútiro, secuac usar rauwic síuti acu. ");
INSERT INTO tuf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Uwat eyin ajcá ji be cunan cuít síhw̃ajacro. Sirat eyin ajcá ji beyin acura etach síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesusat uchta wac cohwjacro: —Bíyinat as tamo Sirat Cara Ayin Wajaquin asan ey síhw̃ayat, éyinat as istir tamo síhw̃atiro. As áyjaquey tamo cat síhw̃aro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bíyinat as ityat, éyinat as áyjaquey cat itro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Asan cuan áyqueyro. Urá wíqueyro. As cajc uch cutar rajacro. Uwa tinjac cutar ístajar eyta aját uw quin urá wítieyra éyinat cat éytaan wan ístajatro. Urá batro. Biyin as tamo síhw̃ayat, eyin urá bár seo ítitiro. As uwan urá bár ítiti acu as rajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Uw siwin acu rajacro. Bíyinat as chihtá cucách cut rahcuír yájtieyra, eyin quin ah cutar ajatrá tayar chítiro. Ajatrá uw quin ay bár yajác tayar chiín acui rátiro. Cuatán cajc cutar uw siwin acura rajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aját chihtá tew̃jacro. Chihtá tew̃jác uwat cati etar cábara tinyat, aját tayar chiáyqueyra. Bíyinat as ria yájtieyra, as chihtá cátieyra, eyin quin tayar chiáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ajmár urá cut téw̃tiro. Tetát as áyjaqueyat as quin wajacro: “Uchta waw̃i. Uchta ehcuwi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aját ítitan, Tetát wac ayjac ey uwat cácayat, im owár etiti ohbac ítataro. Etarwan Sirat as quin icúr waquín áyjactara aját eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cuanmí cut Pascua fiesta yajquín cuanata cuanjacro. Eyta jat Jesusat ítitan, ima cajc uch cutar bin cuacúr ben bar cab cujacro. Tet quin ben bar cab cujacro. Ben acu cab cucayat, Jesusat cajc uch cutar ima chiwa sehnacro. Récaji sehnacan áhajira im eyta etiti sehnacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bach yajquín tino Jesús ima chiwa owár ira yayay yinjacro. Anto yayay yinti cuat Sisramat Judas Iscariote urá bar tan téjecro, Jesús quehsí bin at icar chácayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusat ítitan, Tetát ima quin bahnác yajquín acu ajcan urán wíjacro. Imát ítitan, Sir owár bin rajacro. Sicor cat Sir quin bétaro. ");
INSERT INTO tuf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eyta istiran Jesús mesa acor chihrjacan sicor yehnjacro. Yehnár oya cuitchiney sutchacro. Oya cuitchiney sutír im ur acat toalla questajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Questár rih soya sar rih bahjacro. Rih bahr car ima chiwa istiyáy cat, istiyáy cat ques timá sucuáy yehnjacro. Sucuír oya im urá acat questajác cut iw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Istiyáy cat, istiyáy cat suc raquian Simón Pedro quin wijacro. Wicayat Simón Pédroat Jesús quin wajacro: —Caru, bah caran to etar bah quin as ques timá suc ay cun batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Etat Jesusat wajacro: —Ahajira aját icúr yájctara bahat istítiro. Cuatán yahncút itchácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Etat Pédroat wajacro: —Caru, bahatra as ques timara sucti jaw̃i, wajacro. Etat Jesusat wajacro: —Aját bah ques timá súctieyra bah as chiwa chácajatro. ");
INSERT INTO tuf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Etat Pédroat wajacro: —Caru, súctieyra bah chiwa chácajartar, as ques timá cat, as atum cat, as cuisa cat sucwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Etat Jesusat wajacro: —Biyin bar sujáctara eyin timá batro. Ques timá etac sucuátaro, -wajacro-. Ques timá sucuír eyta, ba bahnaquin urá ay bár éytaan wan órojocro. Urá órotian istanác étanro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesusat bíyatan ima quehsí bin at icar chácatatar ey bar itchacro. Eyta itchác rehquít, “urá órotian istanacro,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesusat ima chiwa bahnáquinay ques timá sucuír, oya sutchacan sicor chájacro. Chaquir sicor mesa acor chihrjacro. Chihrír wajacro: —Aját eyta yájquican bitán yajquíctara, ba quin ehcuro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Baat as quin wacaro: “Caru, síw̃quibu,” wacaro. Eyta wacayat, yarsa tew̃ro. Asan eyro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Asan ba acu cara cuar, ba acu siw̃quib cuar, aját ba ques timá bar sujacro, -wajacro-. Etar aját ba ques timá sucuír eyta, baat cat eyta rahra rahra ques timá sucuátaro, -wajacro, ima chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Baat eyta yajc sinin acu ajatán eyta ehcujacro, baat aját yajaquey im eyta yajcayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aját ba quin wacaro. Carin cacmán ima cara owárara cutiro. Chihtá béquibra ima ayquib owárara cutiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ahra baat ey chihtá cucách cut rahjacro. Acsar chihtá rahjaquey yajquír, ahní rehcáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Aját “urá óroti” wacayat, ba bahnaquin ojcori téw̃tiro. Ajmarát chiwa cájacan ajatán eyin itro. Eyta cuácayat Sir carit cutar uchta cuihsujacan uní rehcátaro. Uchta cuihsúr wajacro: “Ser istiyát as owár ira cohjocro. As owár cohc cuar as quehsí waajacro.” Sir carit cutar eyta cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aját ba quin istiyát quehsí waata récaji ehcuro. Etat eyta rehcayat, baat síhw̃ataro, aját ba quin asan rehrtara ehcujacan asan eyro, síhw̃ataro, -wajacro, Jesusat ima chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aját ba quin wacaro. Bíyinat aját ayquey ajcá ji bécayat, éyinat as cat ajcá ji bécaro. Bíyinat as ajcá ji bécayat, as áyjaquey cat ajcá ji bécaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Eyta waquír cuean to rehjecro. Cuean to rehquír ima chiwa quin ruhcti ehcujacro: —Aját ba quin wacaro. Ba sicar bin úbistiyat as quehsí bin at icar wícataro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jesusat eyta wacayat, chiwat síhw̃ajacro: “¿Biyat Jesús quehsí bin at icar wícatatara?” síhw̃ajacro. Eyta sihw̃a rabar rahra rahra imár owár wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Asa uch cuihsuquey Jesús ima chíwaro. Asan Jesús ecsar chihrír ítchacro. Jesusat asan sehnacan cuitro. ");
INSERT INTO tuf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jesusat “istiyát as quehsí bin at icar wícataro,” wacayat, Simón Pédroat as quin at bácabac yajacro, tayon acu. As quin wajacro: —¿Rehr ojcor tew̃qui? táyowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Etat as Jesús ecor ihtíc bir car Jesús quin táyojocro: —Caru, ¿Rehrát bah quehsí bin at icar chácataca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Etat Jesusat wajacro: —Aját pan rihar sar siw̃inro. Siw̃ír aját istiy quin wíquinro. Bi quino wíctara, eyan eyro, wajacro. Eyta waquír Jesusat pan yehw̃jacro. Yehw̃ír rihar sar siw̃jacro. Siw̃ir Judas Simón Iscariote waquíj quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Wícayat Júdasat pan cájacro. Etat Sisrám Satanás Judas ur icar raújacro. Pan wiquir Jesusat Judas quin wajacro: —Bahat icúr yajquíntara, in yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesusat Judas quin eyta wacayat, cahujinat Jesusat bitán eyta tew̃jáctara istítiro. ");
INSERT INTO tuf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chiwa cahujinat síhw̃ajacro: “Judas ray ucu yéhw̃quibro. Etar Jesusat ey bach yajquín acu icúr táyoctara ey wahy ayjac óraro,” síhw̃ajacro. “Eyta bártara cuayin quin ray wiquin ayjac óraro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas pan caquir inchajin watar waajacro, cheycar cutar. ");
INSERT INTO tuf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas bi yiror Jesusat wajacro: —Ahran uwat asan Uw Síuquiban ayan tahnác istáyqueyra. Sir cat ayan tahnác asa Uw Síuquib cutar istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Asa Uw Síuquib cutar Sir ayan tahnác ehcúctara, Sirat rahra as Uw Síuquib ayan tahnác ehcwáyqueyra. As Uw Síuquib ayan tahnác ehcún acu bar cab cujacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","As sasú, as ba owár biráy ítajatro, -wajacro-. Baat as úroyqueyra, -wajacro-. Uro cuar aját judíoin quin wajacan ba quino cat wacáyqueyra. As birar bíctara ba erar béyajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aját ba quin uchta yajc áyinro. Baat anto rahcti bin chihtá uchta yajc áyinro. Rahra rahra sehnác chaw̃i. Aját ba sehnác eyta, baat cat eyta rahra rahra sehnác chaw̃i. ");
INSERT INTO tuf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Baat rahra rahra sehnác chácayat, bahnáquinat istír síhw̃ataro: “Eyin Jesús chíwaro,” síhw̃ataro, wajacro, Jesusat chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jesusat eyta wacayat, Simón Pédroat wajacro: —Caru, ¿ba birar benca? wajacro. Etat Jesusat wajacro: —Ahra as birar bíctara, bah erar as owár récaji béjetro, -wajacro-. Eyta cuar yahncutrun bah as owár béyqueyra, wajacro. Etat Pédroat wajacro: ");
INSERT INTO tuf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Caru, ¿bitara reht récaji bah owár béjerqui? -táyojocro-. As bah sehná reht bar yarátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Etat Jesusat wajacro: —¿Uní waca? ¿As quesan yarátayica? Aját bah quin uní wacaro. Cohcarám cohwín cahmor bahat as ojcor wacáyqueyra. “Asra Jesús chíwai batro,” wacáyqueyra. Icar bay eyta wacáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesusat chiwa quin wajacro: —As bírara bíctara baat sihw̃a sácati jaw̃i. Cue rehti jaw̃i. Ba urá Sir icar chaw̃i. Ba urá as icar cat chaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","As Tet itic cutar úbachan toro. Aját ba cahmor ba itic oroy benro, -wajacro-. Eyta barir waquít aját eyta wácajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bir car, ba cahmor bahnác oror car as sicor wiquinro. Sicor wiquír ba as owár béyinro. As birar ítictara, ba cat im erar itin acu sicor ba ucay wiquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","As birar bíctara erar cuwín ibit baat itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Etat Tomasat wajacro: —Caru, bah birar bíctara isat istítiro. Birar bíctara istiti etar, erar cuwín ibit bitách ístajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Etat Jesusat Tomás quin wajacro: —As cutar bétaro. Sir quin cuwín acu asan íbitan wanro. Ajc uní téw̃queyan asan eyro. Ohbac it áyqueyan asan eyro. As cutar bétieyra Sir quino cúwajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ahra baat as itchác rehquít, as Tet cat istáyqueyra. Aha yahncút as Tet bar itro. As Tet bar itchacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Etat Felípeat Jesús quin wajacro: —Caru, is quin Tet ehcuwi, -wajacro-. Tet ehcwáyatan eyan cábaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Etat Jesusat wajacro: —As ba owár úchicri rehjecro. Felípeu, bah owár úchicri rehjéc cuar, ¿bahat asa Tetá urá im eyta séhw̃atiqui? Bíyinat as istíctara, éyinat as Tet cat itro, -wajacro-. Eyta cuácayat, as quin “Tet ehcuwi,” wacayat, cuayir tew̃ro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Felípeu, ¿Bahat uchta séhw̃atiqui? As urá as Tet ícatro. Tet urá as ícatro. ¿Bahat eyta séhw̃atiqui? -wajacro, Felipe quin. Acsar Jesusat chiwa quin wajacro-. Aját ba quin wajaquey ajmár chihtá cut wátiro. Tetán as ur ícatro. Tetát as cutar ima chihtá yajcaro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aját bah quin “as urá Tet ícatro” wacayat, “Tet urá as ícatro” wacayat, aját uní wac síhw̃awi. Aját wajaquey rahcuír aját uní wajác síhw̃atitara, aját yajaquey tamo síhw̃awi. Ey tamo sihw̃ar aját uní wac síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aját bah quin wacaro. Bíyinat as tamo “Sir wacjá Jesusat as cuitar yajcáyqueyra,” síhw̃ayat, éyinat aját yajquey cat yajcáyqueyra. Aját Sir urá cut yájqueyan éyinat Sir urá cut ayan cuít yajcáyqueyra. Asan Tet quin bic rehquít, éyinat Sir urá cut ayan cuít yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aját ba conquey rahcuáyqueyra. Ba as chiwa etar baat icúr chíctara, aját ba acu ey yajquinro. As Sir wacját eyta yajc etar uwat as Tet ojcor ay tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ba as chiwa etar icúr chíctara aját ey yajquinro. ");
INSERT INTO tuf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Baat as sehnáctara as chihtá yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aját ba cuitar Tet quin coninro. Conyat Tetát ba quin cuitar yajquib istiy áyayqueyra. Ba owár etiti itin acu áyayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cuitar yajquib eya Ajcan Cámutro. Ajcan Camur Eyat Siran bitáratara uw quin tehmoti ehcuro. As chiwa bár éyinat Ajcan Cámuran Ey ístajatro. Ajcan Camur Ey istiti rehquít, éyinat imár urá sar rau áyajatro. Eyta cuar Ajcan Cámuran Eya ba owár itro. Ba ur icar ítayqueyra. Eyta rehquít baat Ajcan Cámuran Eya itro. ");
INSERT INTO tuf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Aját ba istir báhtiro. As sicor ba quin wiquinro, -wajacro, Jesusat ima chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Biráy bár cuat as chiwa bár éyinatra as bucoy istiti rehcáyqueyra. Eyta cuar baatán asan bucoy istáyqueyra. As sicor yehnár yarti itic etar ba cat Sir owár etiti ohbac ítayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","As bucoy ityat, baat uchta istáyqueyra. As urá Tet ícatro. Eyta cat as urá ba ícatro. As urá ba icar eyta, ba urá eyta as ícatro. As bucoy ityat, baata éytaan istáyqueyra, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bíyinat as ajc rahcuír yájctara, éyinat as sehnacro. Bíyinat as sehnactar, as Tetát cat eyin sehnacro. Aját cat eyin sehnác cháquinro. Eyinat as ítayta eyin quin wiquinro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Júdasat wajacro. Judas eya istiró. Simón Iscariote waquíj batro. Judas eyat wajacro: —Caru, ¿bitara etar bah istayta is quin wiquínica? ¿Bitara etar behmá chiwa bár éyinat bah istayta eyin quin wítica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Etat Jesusat wajacro: —Bíyinat as sehnáctara éyinat as ajc rahcro. As ajc rahcuíc éyinan as Tetát sehnacro. Eyin quin Tet cat, as cat roquinro, eyin owár itin acu. ");
INSERT INTO tuf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","As sehnác bár éyinat as ajc ráhctiro. Ajc eya ajmár urá cut téw̃tiro. Tetát aját eyta waquín áyjacro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","As ba owár ita rabar aját ba quin eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cuitar yajquib eya, Sir Ajcan Cámuran Eya Tetát áyayqueyra. As ajc cut áyayqueyra. Eyat ba quin bahnác síw̃ayqueyra. Aját ba quin ehcujacan tan chinti síhw̃ayta acu bow̃ wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","As bicayat, as chihtá cut ba tan wan ítayqueyra. As tan wan itir eyta, aját ba cat eyta tan wan itin ac cháquinro. As chiwa bár éyinat tan wan itin chácayatra cútiro. As bic rehquít, cuitra síhw̃ati jaw̃i. Cue rehti jaw̃i. Ayuí rehti jaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Baat as ben tew̃jác bar rahjacro. As sicor ba quin wiquin tew̃jác cat bar rahjacro. Baat as sehnactar, asa Tet quin bic etar ba ahní rehcátaro. As Tetán ayan as cuitro. Etar as Tet quin bic rehquít, ba ahní rehcátaro, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Baatán aját uní wajác síhw̃ayta ac aját ba quin récaji eyta wajacro. Eyta rehcayat, baat aját uní wajác síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ahra acsar ajatrá ba owár biráy téw̃ajatro. Cajc uch cutar ayquib, Sisrama bar racaro. Eyan as áyquibi batro. As icrí yajc áyajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Cajc uch cutar ítquinat aját Tet sehnác istayta acu aját Tet chihtá bahnác yajcaro, -wajacro-. Bar jaw̃. Usár bin acsar béyataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Asan chistár cúcara ayan cuít biyan wanro. Ba as cuicaran wanro, -wajacro, Jesusat ima chiwa quin-. Chistár cayibat imát rijaquey ay obir yajquír eyta as Tetát is eyta ay obir yajcaro. ");
INSERT INTO tuf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chistár cayibat ub chati cuicar éyinra ehsú tijcár eyta as Tetát eyta yajcaro. Bíyinat as Tet chihtá yajti jácayat, éyinan ub chati cuicaran wanro. As Tetát eyin cuicaro. Etar cat cayibat cuicar ub cháqueyin ehchí oron acu quétara ay bár eyin ehsú tijcaro, uban cuít chácayta acu. As chihtá yájqueyin cuicar ub cháqueyin wanro. As Tetát eyin urá éytaan wan óroro, ima chihtán ayan cuít yajcayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eyta cat aját ba quin chihtá ehcúr cuitar ba urá bar órojocro. Ur ay chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","As owár cuiiti ítuwi. As ba owár cuiiti itir eyta, as owár eyta cuiiti ítuwi. Chistár cucar ojcor bin cuicár cuic tijcayat, ub bitách chácajatro. Ba cat éytaro. As owár bin cuicayat, baat Sir ub cahmor ayra yájcajatro. ");
INSERT INTO tuf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Asan chistár cúcaran wanro. Baan as cuicaran wanro. Bíyinan as owár cuiiti ityat, as cat eyin owár cuiiti ityat, cuicaran uban to chaquir eyta éyinat éytaan wan as chihtán bucoy bucoy yajcaro. Baat as batra eyta yájcajatro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bíyinan as owár ítiti éyinra cuicaran ay bár biyan wanro. Cuicaran ay bár bin ínayta acu ter eyta eyin cat eyta técaro. Inyat sécuaro. Secuar oc cut wahnro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ba as owár cuiiti ítictara, aját síw̃jaquey yájctara, as Tet quin icúr chi cúntara chiwi. Chícayat Tetát bar wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Uchtaan as Tet ayan tahnác ehcuro. Cuicaran uban to chaquir eyta, ba cat éytaan wan as chihtá cutar ítuwi. Eyta ityat, as chiwa rehquey uw quin ehcuro. Eyta ehcwayat as Tetán ayan tahnác ehcuro. ");
INSERT INTO tuf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","As Tetát as sehnacro. As Tetát as sehnác eyta, aját cat eyta baan sehnacro. Aját ba sehnár yajc etiti acu as owár cuiiti ítuwi. ");
INSERT INTO tuf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Aját as Tet chihtá yajcaro. Chihtá yajcayat, as Tetát as sehnár yajc etítiro. Baat cat eyta as chihtá yajcayat, aját ba sehnár yajc eta báreyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ajmár ahní rehquír eyta, ba cat eyta ahní rehcayta acu eyta wacaro. Behmaran ahní yarsa rehcayta acu eyta wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aját baatán uchta yajquín wacaro. Rahra rahra sehnác chaw̃i. Aját ba sehnác eyta, baat cat eyta rahra rahra sehnác chaw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bíyinan ima íw̃oquin yarti acu chinyat, éyinat íw̃oquin sehnacan cuitro. Cahujín íw̃oquin sehnác ey owár cutiro. -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Baan as íw̃oquinro, as chihtá caquir yajcayat. ");
INSERT INTO tuf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Acsar aját baan cacúm aw̃útiro. Cacumát ima cara icúr yajquín séhw̃actara istítiro. Etarwan acsar baan cacúm aw̃útiro. Iw̃oquin aw̃unro. As Tetát as quin ehcujác ey aját ba quin bahnác ehcujacro. Etar íw̃oquin aw̃unro. ");
INSERT INTO tuf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Baatrá asra cátiro. Cuat aját ba cájacro. Caquir, cuicár ub cháquiran wan, baat bucoy cat, bucoy cat Sirat yajc áyjaquey yajquín acu áyjacro. Eyta yajquey úchicri rehcáyqueyra. Etar cat ba as chiwa etar icúr chíctara, Tetát wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eyta cuácayat aját ba quin uchta yajc ayro. Rahra rahra sehnác chaw̃i. ");
INSERT INTO tuf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Cajc cutar as chiwa bár éyinat ba quehsuyat, uchta síhw̃awi: “Eyinat récaji Jesús quehsujacro,” síhw̃awi, -wajacro, Jesusat ima chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ba as chiwa barir waquít, as chiwa bár éyinat ba imaray sehnác jácataro. Eyta cuar aját baan ajmár chiwa ajquír chájacro. Ba as chiwa bár eyin owár batro. Eyin owár bár rehquít, éyinat ba quehsuro. ");
INSERT INTO tuf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aját ba quin wajaquey síhw̃awi: “Cacumán ima cara owárara cutiro.” Cahujinat as ruhw̃ujactar, ba cat ruhw̃áyqueyra. As chihtá yajactar, ba chihtá cat yajcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Baan as chiwa rehquít, eyta ruhw̃áyqueyra. Eyinat as ayquib istiti rehquít, ba eyta ruhw̃áyqueyra, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aját eyin quin tew̃ay rátiir waquít, eyin ay bár yajác tayar bár rehcáyqueyra. Eyta cuar aját eyin quin tew̃ay rajác rehquít, éyinatra “Isat istiti rehquít, Sir tayar yajacro,” bitách wácajatro. ");
INSERT INTO tuf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bíyinat as quehsuyat, éyinat as Tet cat quehsuro. ");
INSERT INTO tuf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aját eyin ub acat ub bár bin yehnjaquey ub ji chájacro. Chein cat sicor estají chájacro. Cahmor cahujinat yajti ey aját eyin ub acat Sir urá cut bahnác bar yajcata ehcujacro. Eyin ub acat eyta yájtiir waquít, eyin ay bár yajác tayar bár rehcata binro. Eyta cuar éyinat aját yajaquey bar wahitchacro. Itchác cuar, as cat, as Tet cat quehsuro. ");
INSERT INTO tuf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","As cat, as Tet cat quehsujác cuar, Sir carit cutar cuihsujác uní rehcayta acu eyta yajcaro. Sir carit cutar uchta cuihsujacro: “Aját eyin acu ay batra icrí yájtiro. Eyta cuar éyinat as quehsujacro.” ");
INSERT INTO tuf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cuitar yajquib, Ajcan Cámuran Eya Tet quin bin wicáyqueyra. Aját Ajcan Camur Eya áyinro. Eyat Siran bitáratara uw quin uní ehcuro. Eyat as ojcor tew̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Baat cat as ojcor tew̃áyqueyra. Aját uw siw̃ay yehníc cutar echí ah ocso tas baan as owár rehcaro. Etar baat as ojcor tew̃áyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Baat as waca teti acu aját ba quino eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Secuac usar ba rau ayti jácayqueyra. Etar cat bíyinat ba yauyat, éyinat síhw̃ataro: “Sir ub cahmor ay yajcaro,” síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uwat as istiti rehquít, as Tet cat istiti rehquít, ba eyta ruhw̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aját ba quin eyta ruhw̃ata récaji ehcuro. Etat uwat ba eyta ruhw̃ún acu cab cucayat, baat aját récaji tew̃jaquey tamo síhw̃ayqueyra, wajacro. ’Aját anto uw siw̃ay yehnyat, ba quino eyta ehcútiro. As ba owár itic rehquít, éytara ehcútiro. ");
INSERT INTO tuf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Eyta cuar ahra as áyjaquey quin benro. Eyta cuar bíyati as quino “¿Bah bir biqui?” wátiro. ");
INSERT INTO tuf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aját ba quin eyta wajác rehquít, ba cue rehcaro. ");
INSERT INTO tuf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aját ba quin wacaro. As bicayat wan ba acu ayan cuitro. As biti rehcáyatra, cuitar yajquib eya ba quino wícajatro. As bíyeyra aját cuitar yajquib ba quino áyinro, -wajacro, Jesusat ima chiwa quino-. ");
INSERT INTO tuf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cuitar yajquib ba quin wicáyqueyra. Wicayat eyat uw quin ehcwáyqueyra. Uw imarat ay bár yajác istayta acu ehcwáyqueyra. Ay yajquín acu ay bitara yajcátatara ey cat ehcwáyqueyra. Uwat Sir tayar yajác Sirat tayar chiyata ey cat ehcwáyqueyra. Cuitar yajquib wicayat, uw quin eyta ehcwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Eyta ehcwayat uwat as tamo síhw̃ati rehquít, imarat ay bár yajác istáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","As Tet quin benro. Bicayat baat acsar as istá báreyra. Etar ay yajquín acu bitara yajcátatara ehcwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Cajc uch cutar ayquib, Sisrám quin Sirat tayar bar chíjacro. Etar uwat Sir tayar yajác Sirat tayar chiyata istáyqueyra. Cuitar yájquibat ehcwayat, eyta istáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Aját ba quin chihtán ehcú báhnajatro. Eyta cuar aha ehcwayat, ba ur icar bahnác sínajatro. Etar aha ehcútiro. ");
INSERT INTO tuf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Eyta rehquít, Sir Ajcan Camur Eya wicáyqueyra. Eya Siran bitáratara tehmoti ehcúquibro. Wicayat baat ey chihtá cut uní eyan bahnác istáyqueyra. Ima chihtai ba quino tew̃a báreyra. Cuat Tetát tew̃ic rahcuíc eyra ba quin ehcwáyqueyra. Yahncút bitara rehcátatara, eyat récaji ehcwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Sir Ajcan Camur Eyat as ayan tahnác ba quin ehcwáyqueyra. Aját tew̃quey acsar ba quin ehcwáyqueyra. Eyta ehcúc rehquít, as ayan tahnác ehcwáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tetát as quin bahnác ehcuro. Etar aját ba quin wánora: “Aját icúr tew̃ictar Sir Ajcan Camur Eyat acsar ba quin ehcwáyqueyra,” wánora. ");
INSERT INTO tuf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Biráy bár cuat baat as istá báreyra. Etar bucoy biráy bár cuat as bucoy istáyqueyra, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Eyta wacayat Jesús chiwat rahra rahra imár owár táyojocro: —¿Jesusat bitara ojcor tew̃qui? Is quin wacárora: “Biráy bár cuat baat as istá báreyra. Etar bucoy biráy bár cuat as bucoy istáyqueyra,” wacárora. Etar cat Jesusat is quin wacárora: “As Tet quin ben etar, baat as istá báreyra,” wacárora. ");
INSERT INTO tuf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Biráy bar cuanyat,” wacayat, ¿bi ojcor tew̃qui? Isat ráhctiro, wajacro, ijmár owár. ");
INSERT INTO tuf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chiwat ima quin ey ojcor tayo cun rehquíc Jesusat itchacro. Etar eyin quin wajacro: —Aját ba quin wánora: “Biráy bár cuat baat as istiti rehcáyqueyra. Etat bucoy biráy bár cuat as istáyqueyra,” wánora. ¿Baat behmár owár rahra rahra aját eyta wajác ojcor táyoqui? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aját ba quin wacaro. Ba óyqueyra. Cue rehquír conáyqueyra. Eyta cuar as chiwa bár eyin ahní rehcáyqueyra. Ba récaji cue rehcata cuar, yahncút ahní rehcáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Saha yehnín isó yehnyat, abán yaran abáy cuácayat, cue rehcaro. Eyta cuar sah yehnyat, yaran abáy jajac ojcor séhw̃atiro. Sah cajc uch cutar yehnjác rehquít, ahní rehcaro. ");
INSERT INTO tuf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sah yehnín isó yehnyat, aba cue rehquír eyta, ahra ba éytaan wan cue rehcaro. Eyta cuar aját ba bucoy tihrinro. Bucoy tihryat, sah yehnyat aba ahní rehquír eyta ba ur icar éytaan wan ahní rehcáyqueyra. Ahní rehcayat, cahujinat ba ahní rehc cuica báreyra, -wajacro, Jesusat chiwa quin-. ");
INSERT INTO tuf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","As bucoy ityat, baat as quinoi icrí chiya báreyra. Tet quin chiáyqueyra. Baat Tet quin as chiwa rehquít, icúr coníctara Tetát wícayqueyra. ");
INSERT INTO tuf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","As chiwa rehquít baat chiata cuar áhajira icrí chítiro. Ahra chiwi, -wajacro-. Chícayat bar wícayqueyra, ba ahnian cuít rehquín acu. ");
INSERT INTO tuf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Aját ba quin chihtá siw̃in acu icúr bi ojcor tew̃jacro. Eyta cuar biráy bár cuat aját ba quin icúr bi ojcor tew̃a báreyra. Icúr bi ojcor tew̃ti cuar Tet ojcor ba quin ruhcti ehcunro. ");
INSERT INTO tuf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","As bucoy ityat, as chiwa rehquít, baat Tet quin chiáyqueyra. Ajatrá ba cuitar chiinro, wátiro. Behmarat chiáyqueyra, as chiwa rehquít. ");
INSERT INTO tuf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","As Tetát ba sehnác etar, chiáyqueyra. Baat as sehnác etar, baat asan Tet quin bin wijác sihw̃ac etar Tetát ba sehnacro. ");
INSERT INTO tuf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","As Tet quin bin wijacro. Cajc uch cutar wijacro. Ahra as cajc uch cutar bin bar bicaro. Sicor Tet quin benro, wajacro, Jesusat ima chiwa quin. ");
INSERT INTO tuf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Etat chiwat Jesús quin wajacro: —Ahra bahat is quin chihtá siw̃in acu icúr bi ojcor téw̃tiro. ");
INSERT INTO tuf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Isat ítitan, bahat bahnác itro. Cahujinat anto bah quin táyoti cuat, bahat éyinat icúr tayon síhw̃actara itro. Eyta cuácayat isat sihw̃at, bah Sir owár bin wijacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Etat Jesusat chiwa quin wajacro: —¿Ahra baat as Sir owár bin wijác síhw̃aqui? -táyojocro-. ");
INSERT INTO tuf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba cui beyin acu bar cab cucaro. Ba bahnaquin behmár usi beyin acu bar cab cujacro. Baat as istir báhtaro. Eyta cuar as ístiri batro. Tetá as jor rehcayat, as ístiri batro. ");
INSERT INTO tuf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aját ba tan wan rehquín acu eyta wajacro. Ba urá as icar chácayat, tan wan rehcáyqueyra. As chiwa bár éyinat ba cuaquin acu ruhw̃áyqueyra. Eyta cuar cuécuti jaw̃i. Aját as chiwa bár eyin bar burbar yajacro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","Jesusat ima chiwa quin eyta waquír, cuacúr wahitchacro. Cuacúr wahitír, Tet ojcor conjacro: —Tetú, ahra bar cab cujacro. As bah wacjá ayan cuít uw quin ehcuwi, -wajacro-. Bahatan aját uw bahnaquin ayin acu ajc waajacro. Eyta rehquít bahat as ayan cuít uw quin ehcuwi, aját cat bah ayan cuít uw quin ehcwayta acu. Uwa baat as quin áyjacro, -wajacro, Jesusat Sir quin-. Uw eyin behm owár etiti ohbac itin acu aját ajc waanro. Behmát as quin eyta yajquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bahan Sir queney istán eyro. Bahat as áyjacro. As ajcan Jesucrístoro. Uwat bahan ítara, as cat ítara, bah owár etiti ohbac ítayqueyra, wajacro, Tet quin. ");
INSERT INTO tuf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Bahat as quin yajc áyjaquey bahnác bar yajacro. Aját yajaquey cutar baha ayan cuít cajc cutar bar ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tetú, bah ub acat asa ayan cuít chaw̃i. Anto cajc chati cuat bah ub acat asa ayan cuít chájacro. Ah cat bucoy ayan cuít im eyta chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Bahat cajc uch cutar uwa as chiwa rehquín acu as quin wíjacro. Aját eyin quin bah rehrtara bar ehcujacro. Eyinan behmá chíwaro. Behmáy etar eyin as quin wíjacro. Wícayat éyinat bah chihtá wácati yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wácati yajquír car ahra éyinat uchta itro. Bahat as quin wíjaqueyin bah at icar binro. Ahra eyta itro. ");
INSERT INTO tuf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bahat as quin chihtá ehcujaquey aját eyin quin ehcujacro. Ehcwayat éyinat rahjacro. Rahcuír éyinat ítitan, as bah owár bin rajacro. Etar cat éyinatan bahat as ayjac, síhw̃aro, wajacro, Jesusat Tet quin. ");
INSERT INTO tuf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Aját eyin cutar conro. As chiwa bár bin cutari cóntiro. Bahat as quin wíjaqueyin cutar conro. Eyin behmáy rehquít, aját eyin cutar conro, -wajacro, Jesusat-. ");
INSERT INTO tuf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","As chiwa bahnáquinan ba chíwaro. Ba chiwa bahnáquinan as chíwaro. Eyinat as ehchian cuít ehcuro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ahra as bah quin bicaro. Biráy bár cuanyat, asra cajc cutar ítajatro. Eyta cuar as chiwa cajc cutar acsar ítayqueyra. Tetú, bah ayro. Behmá ajcan urán cutar chiwa obir yajw̃i. As quin ajcan urán wijac ey cutar obir yajw̃i, -wajacro-. Ba asi jor urá istanacro. As chiwa cat eyta rahra rahra ur istán rehquín acu eyin obir yajw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Eyin owár ita rabar, aját eyin obir yajacro, bah ajc cutar. Bahat as quin wíjaqueyin obir yajacro. Aját eyin tiw̃ áytiro. Eyin bahnáquinat as waca tétiro. Bah chihtá cuihsujaquey uní rehquín acu uw ubistán eyat as waca ter chinátaro, -wajacro, Jesusat Tet quin-. ");
INSERT INTO tuf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ahra as bah quin bicaro. Bah quin anto biti cuat aját eyta conro. As chiwa imár ur icar ahní rehcayta acu eyta conro, eyin ahní caba rehcayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aját eyin quin ba chihtá bar ehcujacro. Asra ajmár chiwa bár bin owárai batro. Eyta cat as chiwa cat eyta as chiwa bár bin owárai batro. Owárai bár rehquít, as chiwa bár binat as chiwa quehsuro, -wajacro, Jesusat Tet quin-. ");
INSERT INTO tuf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bahat eyin cajc cutar bin cuacúr beyin acu cóntiro. Eyta conti cuar, bahat eyin ur ay bár yajc ayquey cahm siwin acu conro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Asa ajmár chiwa bár bin owárai bár eyta, as chiwa cat eyta as chiwa bár bin owárai batro. ");
INSERT INTO tuf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Behmá chihtá yajquín acu eyin behmáy caw̃i, behmá chihtá cutar. Bah chihtá uniro. Ey cutar cuar as chiwa behmáy caw̃i. ");
INSERT INTO tuf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bahat asa cajc uch cutar uw quin wiquín acu áyjacro. Bahat as cajc uch cutar ayjac eyta aját eyin cat eyta ayro, as chihtá uw quin ehcún acu. ");
INSERT INTO tuf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","As behmáy yehnjacro. Eyin behmáy yinayta acu as behmáy yehnjacro, bah chihtá yajquín acu. Eyin behmáy queney yinayta acu asa behmáy yehnjacro, wajacro, Jesusat Tet quin. ");
INSERT INTO tuf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Aját ajmár chiwa eyin cuitar étani cóntiro. Uyin acu cat conro. Etar cat acsar eyin chihtá rahcuír cácata eyin cutar cat, asan Sirat ayjac síhw̃ata eyin cutar cat conro. ");
INSERT INTO tuf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eyin bahnaquin rahra rahra urá istán rehcayta acu conro. Tetú, éyinan is owár ur istán chácayta acu, aját bah quin conro. Bah urá as icar chájacro. As urá cat bah icar chájacro. Eyinat cat eyta imár urá éytaan wan is icar chácayta acu conro. As chiwa rahra rahra urá istán rehcayta acu conro, as chiwa bár binat bahat as ayjac síhw̃ayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bahat as ayan cuít chájacro. Bahat as ayan cuít chaquir eyta aját cat eyin éytaan wan ayan cuít chájacro. Eyin rahra rahra ur istán rehcayta acu ayan cuít chájacro. Asa bah owár ur istán rehquír eyta, eyin cat éytaan wan rahra rahra ur istán rehcayta acu ayan cuít chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","As urá eyin ícatro. Bah urá as ícatro, eyin imár owár ur istán wácati rehcayta acu. Eyin imár owár urán istán rehcayat, as chiwa bár binat bahat as ayjac, síhw̃ataro. Bahat as sehnác eyta as chiwa cat im eyta sehnac, síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tetú, bahat as chiwa as quin wíjacro. Aját as birar ítatatara eyin cat erar as owár it cunro, éyinat as ayan cuít istayta acu. Bahat as ayan cuít chájacro. Bahat anto cajc chati cuat echí as sehná rehquít ayan cuít chájacro, wajacro, Jesusat Tet quin. ");
INSERT INTO tuf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","’Tetú, bahat uw cayar yájtiro. Bah chiwa bár binat bah istítiro. Eyta cuar aját bah itro. As chiwat ítitan, bahat as áyjacro. ");
INSERT INTO tuf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aját bah rehrtara eyin quin ehcujacro. Acsar cat ehcunro. Bahat as sehnár yajc eyta, éyinat cat im eyta rahra rahra sehnár yajcayta acu ehcunro. As cat eyin ur icar rehquín acu ehcunro. ");
INSERT INTO tuf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesusat Tet quin eyta conár, ima chiwa owár watar waa béjecro. Watar waar rih ajca Cedrón rahray béjecro. Erar caruc oliva ques itay béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesús ima chiwa owár caruc oliva im ey ques cutar bucoy cat, bucoy cat béjecro. Eyta beyar ítqueyan, Júdasat cat itro. Judas éyatan Jesús quehsí bin at icar chaquin tew̃jáqueyro. Eyat cat erar beyar ítqueyan itro. ");
INSERT INTO tuf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eyta cuácayat, Judas cat caruc oliva im ey ques bijacro. Ey owár soldádoin cat, Sir usar bin policiáin cat béjecro. Sacerdote cárinat, fariséoinat cat eyin áyjacro. Jesús quin bécayat cahujinat cárucuan ator, cahujinat espadan ator, cahujinat aceite oca soy sar anir ator, cahujinat rey cas ocan ator béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesusat ima acam bitara rehcata ey bar itchacro. Etarwan Jesús ima chiwa tac icar bin eyin acat bijacro. Bir wajacro: —¿Baat rehr úroqui? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Etat éyinat wajacro: —Jesús pueblo Nazaret bin úroro, wajacro. Etat Jesusat wajacro: —Asan eyro, wajacro. Judas Jesús quehsí bin at icar chaquey cat soldádoin owár ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesusat “Asan eyro,” wacayat, soldádoin ícarich ic icar quihujacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Etat Jesusat bucoy eyin quin wajacro: —¿Baat rehr úroqui? táyojocro. Etat éyinat wajacro: —Jesús pueblo Nazaret bin úroro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Etat Jesusat wajacro: —Aját ba quin bar ehcujacro: “Asan eyro,” waquira. As úroctara cahujín uchin imár beyayta ac ajc waawi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesusat imát wajác uní rehquín acu eyta wajacro. Jesusat récaji wajacro, “Tetú, uw bahat as quin wíjaquey ubistani yar áytiro,” wajacro. Eyta wajác uní rehquín acu “cahujín beyayta ac ajc waawi,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Etat Simón Pédroa espada chi rehquít, espada újacro. Uquir sacerdote cara cacmá ey cut tajacro. Tajcyat, bajít tajqui wihár cucajá cuic téjecro. Sacerdote cara cacmá ajca Malco cucajá cuic téjecro. ");
INSERT INTO tuf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pédroat eyta tajcyat, Jesusat Pedro quin wajacro: —Bah espada sicor umá sar yahníc chaw̃i, -wajacro-. Tetát uwat as ruhw̃ata wajacro. Tetát uwat as ruhw̃ata wacayat, as ruhw̃uti acu síutiro. Bahat tan séhw̃atan, ¿asan ruhw̃ú ayti acui séhw̃aca? Eytai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Etat soldádoinat, imár soldado car owár, judíoin policiáin owár Jesús cájacro. Caquir car atcar ey questajacro. Questár béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ibtu Anás quin béjecro. Anás eya Caifás siw̃aro. Caifás eya ey bar icar sacerdote cáraro. ");
INSERT INTO tuf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifasat récaji judíoin quin wajacro: “Ba acu úchtaan ayan cuitro. Uw ubistán ey uw bahnaquin acu chínyatan eyta ba acu ayan cuitro, uw bahnaquin sácati acu.” Caifasat récaji eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús caquir becayat, Simón Pedro cat, chiwa istiy cat Jesús questoc béjecro. Chiwa istiy eya sacerdote cara íw̃oquinro. Etarwan eya Jesús owár sacerdote usi cara ubach tan sar awat cutar raújacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro rauti cuar querat acor ítchacro. Etat chiwa istiy sacerdote cara íw̃ojoquey sicor watar bijacro. Watar bir querat cuitar cahbár quin tew̃jacro. Cahbár eya querat cuitar itic cacumró. Ey jor tew̃ír Pedro rau ayin acu chíjacro. Tew̃ír Pedro cat usar raújacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rauyat querat acor itic cahbár eyat Pedro quin táyojocro: —¿Bah cat Jesús chíwaiqui? táyojocro. —Batro. Asra eyi batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Usar rauyat cacúm cat, policiáin cat oc ow̃ro. Séroan abáy rehquít, éyinat cucúr oc anir ow̃ay ocuajacro. Etar Pedro eyin acor bir ítchacro. Eyin owár oc ow̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdote carat Jesús quin ima chiwa ojcor táyojocro. Imát icúr síw̃ictara ey ojcor táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Táyoyat Jesusat wajacro: —Aját uw bahnaquin cac cahmar bahnác ehcujacro. Aját bahnacan secuac usar cat, Sir usar cat síw̃jacro. Judíoin bahnaquin secuac cutar cat síw̃jacro. Aját ruhcuír icrí síw̃tiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Eyta rehquít, as quino ¿bitara reht aját icúr síw̃jactar táyoqui? Uw aját siw̃ic rahjaquin quin táyowi. Eyinat itro. Aját bitara wajactar eyin quin táyowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesusat eyta wacayat, erar policia istiyát Jesús at tar ey cutar bujacro. At tar ey cutar buquír wajacro: —Sacerdote cara quin ¿bitara reht eyta tew̃qui? ");
INSERT INTO tuf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Etat Jesusat wajacro: —Aját ay bár wajactar, icúr ay bár wajactar uw usár sécuajaquin cac cam ehcuwi. Eyta cuar aját ay batra wátitar ¿bitara reht as bucyi? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Etat Anasat Jesús Caifás quin áyjacro. Caifás eya sacerdote carin cáraro. Jesús atcar questajacan anto ricuátiro. ");
INSERT INTO tuf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro erar oc ow̃ayat, cahujinat Pedro quin wajacro: —¿Bah cat Jesús chíwaiqui? táyojocro. Eyta táyoyat, Pédroat Jesús ima chiwa wati cuar wajacro: —Asra Jesús chíwai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Eyta wacayat, sacerdote cara cacúm cat ésatro. Cacúm eya Pédroat ser istiy cucáj cuic téjequey cáyinro. Cacúm eyat wajacro: —Aját ítitan, caruc oliva ques bahan Jesús owárcuayra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Etat Pédroat bucoy wajacro: —Asra Jesús chíwai batro, wajacro. Pédroat eyta wacayat, cohcarám cohwjacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cuan racayat, policíainat Jesús Caifás usar bin gobernador usi béjecro. Gobernador úbachan cúmacro. Esara judíoin raútiro, bach awuti acu. Cheycar aracat bijaquey bach waar, ruwa yayata etar, gobernador usar raútiro. ");
INSERT INTO tuf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Etar Pilato watar eyin quin bijacro. Watar waar táyojocro: —Baat ítitan, ¿ser uyat icúr ay bár yajaca? ");
INSERT INTO tuf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Etat judíoinat wajacro: —Ay bár yájtiir waquít, ba quínora rócajar binro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Etat Pilátoat eyin quin wajacro: —Behmarat béowi. Behmár chihtá cuihsujaquey cutar tayar bitara chiátatar wahítuwi, wajacro. Etat judíoinat wajacro: —Ijmarat quenra uwat ay bár yajác tayar quesra yaúwajatro. Romano gobierno cárinat ajc waátiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús imát bitara chinata wajaquey uní rehquín acu eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Etat Pilato sicor im usar raújacro. Rauwir Jesús chíjacro. Wicayat táyojocro: —¿Bahan judío cáraica? ¿Judíoin rey cáraica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Etat Jesusat wajacro: —¿Behmá tan séhw̃ari eyta táyoqui? ¿Cahujinat bah quin as ojcor ehcujác etar, as quin eyta táyoqui? ");
INSERT INTO tuf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Etat Pilátoat wajacro: —¿Bitara reht as quin eyta táyoqui? Asra judíoini batro. Behmá uwat sacerdote carin owár bah as quin questár rojocro. ¿Bahat icúr yajcyi? ");
INSERT INTO tuf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Etat Jesusat wajacro: —Asra cajc uch cutar cárai batro. As cajc uch cutar bin cárair waquít, as chiwat as sicar tecuay yinátaro, as judíoin at icar chati acu. Eyta cuar as cajc uch cutar cárai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesusat eyta wacayat, Pilátoat wajacro: —¿Eytaira bahan rey cáraica? táyojocro. Etat Jesusat wajacro: —Ee, bahat táyocan cábaro. Asan eyro. As cajc uch cutar eyta yehnín acu rajacro. Cajc uch cutar uchta yajquín acu yehnjacro. Uní waquín acu yehnjacro. Biyin uní sin cuntar éyinat as chihtá rahcro, wajacro, Jesusat. ");
INSERT INTO tuf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Etat Pilátoat wajacro: —¿Icuran unica? táyojocro. Etat Pilato sicor watar judío quin waajacro. Watar waar wajacro: —Aját tayar ítitan, Jesús quin bi tayar yajác quesi chíajatro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Eyta cuácayat aját ba acu baat Pascua fiesta yajca rabar cárcel icar tunjaquin úbisti uc ayro, -wajacro-. Búcoyan, búcoyan, bar istiy, bar istiy bach yajquíc cutar eyta úcaro. ¿Ahra aját judío cara ba acu uc áyataica? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Etat uwat Pilato quin cohwjacro: —Eyra uc ayti jaw̃i, cohwjacro. Barrabás uc aywi, wajacro. Barrabás eya bésibcuano. ");
INSERT INTO tuf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Etat Pilátoat Jesús be áyjacro. Beyar soldádoat chistár cutar bucoy, bucoy icar cutar ay bar bujacro, Pilato ajc cut. ");
INSERT INTO tuf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Buquír soldádoat cachá churot cuijacro. Cuiir cachá churot Jesús cuis otar chájacro. Cárinat ow̃quin wiricasá buw bi cat Jesús ojcúm chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eyta cháquiran soldádoin Jesús cac cahmar bucoy bucoy rojocro. Roquír wajacro: —¡Judíoin caru! ¡Judíoin caru! buror sisín acu eyta wajacro. Eyta waquír, at cut Jesús ac tar bujacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Etat Pilato sicor watar waajacro. Watar waar uw ricán to bin quin wajacro: —Aját ítitan, Jesusat ay bár bitarach yájtiro. Eyta ehcún acu ba cac cahm rocaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eyta wacayat, Jesús cat watar waajacro. Cachá churot tas cuar, oya buw bi tas cuar watar waajacro. Jesús watar waacayat, Pilátoat uw quin wajacro: —Wahítuwi, -wajacro-. Ser uyan ba cac cahm usatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote cárinat cat, úroquinat cat Jesús istír cohwjacro: —Eyta yauwin caruc ojcor quejcátaro. Yauwin caruc ojcor quejcátaro, wajacro. Etat Pilátoat wajacro: —Baat ey caquir béowi. Yauwin caruc ojcor quéjquíntara, behmarat béowi, -wajacro-. Aját ítitan, eyat tayar yájtiro, ey quin chiín acu. ");
INSERT INTO tuf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Etat judíoinat wajacro: —Eyat iman Sir wacjá wajacro. Is bach carit cut chihtá carit cut éytara wácajatro, wacaro. Etar yauwátaro. ");
INSERT INTO tuf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Eyinat eyta wacayat, Pilátoat rahjacro. Rahcuír, cuít roojocro. ");
INSERT INTO tuf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Etar sicor usar raújacro. Rauwir Jesús quin táyojocro: —¿Bah biscán binca? táyojocro. Eyta táyojoc cuara, Jesusat ajc chin chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ajc chin cuácayat, Pilátoat Jesús quin wajacro: —¿Bahat as quin icrí téw̃tiqui? Uch séhw̃awi. As chihtá cut bah uc ay cuntar bar uc áyataro. As chihtá cut bah yau ay cuntar bar yau áyataro. Caruc ojcor cat bar quejc áyataro, wajacro, Pilátoat. ");
INSERT INTO tuf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusat wajacro: —Sirat as bah at icar chaquin ajc waátiir waquít, bahat as áyajatro, -wajacro-. Eyta cuácayat, biyat as bah at icar chájactar, eyan Sir táyaran bah cuitro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilátoat eyta rahcuír, Jesús uc ayin acu tew̃jacro. Pilátoat Jesús uc ayin acu tew̃yat, judíoinat Pilato quin ay bár cohwjacro: —Bahat Jesús uc ayat, bah romano cajc cut caran cuít bi íw̃oquini batro, -wajacro-. Biyat im ojcor “asan rey cáraro,” wacayat, eyan romano cajc cut caran cuít bi quehsiro. Eyta chihtara Jesús uc ayin ajc waati jaw̃i, wajacro, Pilato quin. ");
INSERT INTO tuf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilátoat eyta rahcuír, Jesús watar bey áyjacro. Watar bey ayir imara juez cara banco ojcor chihrjacro. Juez banco chájaquey awat hebreo cuw cut “Gabata” aw̃ujacro. Ey awat oron acu ac anjacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ey cuanmí cut Pascua fiesta yajquín cuanátaro. Rahsan urá chac racayat, Pilato juez banco ojcor chihrjacro. Chihrír judíoin quin wajacro: —Wahítuwi. Bah rey cara usatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Etat éyinat wajacro: —Yauwin caruc ojcor quejcátaro, wajacro. Etat Pilátoat táyojocro: —¿Aját bah rey cara caruc ojcor quejc ay cuni rehqui? táyojocro. Etat sacerdote cárinat wajacro: —Is rey cara istanacro. Romano cajc cut caran cuít bi eyan eyro. Césaran eyro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eyta wacayat, Pilátoat Jesús ima soldádoin at icar chájacro, caruc ojcor quejquín acu. Soldádoin at icar chácayat, éyinat Jesús béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús eyin owár bijacro. Caruc cuitoc cuit béjecro, ima ey cutar quejcayta acu. Caruc eya teb eyta chájacro. Teb ey cutar cuacrár erar ricar cat istiy chájacro. Eyta béyeyan cajc ajcan Cuisa Cárara cut cujacro. Ey cajc ajc Hebreo cuw cut “Gólgota” aw̃uro. ");
INSERT INTO tuf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Erar cucayat soldádoinat Jesús yauwin caruc ojcor quejecro. Quejquír Pilátoat chihtá cuihsujaquey Jesús arar caruc ojcor quejc áyjacro. Besin bucáy bin cat istiy caruc istiy ojcor, istiy caruc istiy ojcor quejecro. Quejquír caruc cui canó chájacro. Eyta chaquir Jesusan ubut ojcor chájacro. Bésinan istiy rahray wihár, istiy rahray wihár chájacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilátoat chihtá cuihsujaquey Jesús arara caruc ojcor quejequey uchta cuihsujacro: “Jesús Nazaret bin judíoin rey cáracuano,” cuihsujacro, uwat wahitín acu. ");
INSERT INTO tuf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hebreo cuw cutar cat, latín cuw cutar cat, griego cuw cutar cat eyta cuihsujacro. Jesusan caruc ojcor pueblo intac quejecro. Pueblo intac quejéc chihtara judíoin to binat Pilátoat eyta cuihsujaquey itchacro. Istír tajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tar car judío sacerdote cárinat Pilato quin wajacro: —“Judío rey cáracuano” cuihsuti jaw̃i. Eyta cuihsuti cuar “Eyat ‘asan judío rey cáraro,’ wajacro,” cuihsuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Etat Pilátoat wajacro: —Aját cuihsujáqueyan cábaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldádoinat Jesús caruc ojcor quejquír ey oya yehw̃jacro. Yehw̃ír soldádoinat bacáy bin owár tahw̃ujacro. Tahw̃úr istiyát oy istiy, istiyát oy istiy cájacro. Etar cat oya istiy yehw̃jacro. Eya oya bi osoi rícuajatro. ");
INSERT INTO tuf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ey yehw̃ír soldádoinat rahra rahra wajacro: —Eyra rachti jaw̃i. Biyat ey cáquintara ey istín acu at sínataro, wajacro. Sir carit cutar uchta cuihsujaquey uní rehquín acu eyta yajacro. “As oya eyin owár tahw̃uro. Bíyinat bi oya cáquintara ey istín acu at sinro.” Sir carit cutar eyta cuihsujác etar, soldádoinat eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús caruc ojcor quejequey acor ima ab María cat ésatro. Ab rab cat ésatro. María Cleofas wiya cat ésatro. María pueblo Magdala bin cat ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesusat caruc ojcor cuar im ab itchacro. Etar chiwa sehnacan cuít bi as cat im acor itic itchacro. Istír ima ab quin wajacro: —Uya bah acu wacján wan chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Etat Jesusat ima chiwa as quin wacárora: —Uya bah acu abán wan chaw̃i, wacárora. Ey yahncút aját Jesús abá ajmár usi béjecro, owár itin acu. ");
INSERT INTO tuf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Etat Jesusat ítitan, bahnác yajcata eyan bar caba yajc tihrjacro. Etar Sir carit cutar cuihsujaquey uní rehquín acu Jesusat wajacro: —Asan cuc wíniro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eyta wacayat acat toca ésatro. Ey toca sar chistár ub rihar bacua ihirán to binro. Jesusat cuc wini wacayat, soldádoinat caros ey bacú cut siw̃jacro. Siw̃ír caruc ajca hisopo úbara ojcor chájacro. Chaquir Jesús cac acat yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eyta yehw̃yat, Jesusat bacú suhjacro. Suhwír cat wajacro: —Bahnác yajcata eyan bar caba yajc tihrjacro, wajacro. Eyta waquír, cuisa bahujacro. Cuisa bahúr chinjacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesús caruc ojcor quejéc tan jaquin acu oroc rícatro. Ey cuanmí cut tan jaquin rícara cutar, Pascua fiesta cat cuanátaro. Etar ayan cuitro. Etar judíoinat uwa sácajaqueyin caruc ojcor tijcati im eyta bah cun batro. Eyta rehquít Pilato quin caruc ojcor quejéqueyin in sacan acu renar cárara quehwín chíjacro. Carar quehwír chein tijcán acu chíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Carar quehwín chícayat, Pilátoat ajc waajacro. Etar soldádoinat uw istiyáy cat, istiyáy cat bucáyinay renar cárara quehujacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Etat Jesús carar cat quehway rojocro. Jesús acor bequir ítitan, Jesús bar chinjác itchacro. Etar ey cáratra quéhutiro. ");
INSERT INTO tuf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eyta cuar soldado istiyát ransit cut Jesús urá rahmaram icar quejecro. Quejéc sicar ab cat, rih cat waajacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jesús yauwin bitara yajáctara bahnác itcháqueyat ey ojcor cuihsujacro. Baat cat eyta yajác uní síhw̃ayta acu uní cuihsúr ehcuro. Im ub cut itcháqueyat uní ehcuro. ");
INSERT INTO tuf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sir carit cutar uchta cuihsujaquey uní rehquín acu Jesús carar quéhutiro. “Ey carar úbistii quéhwajatro,” cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sir carit cutar uchta cat cuihsujacro. “Uwat ransit cut imarat quejequey wahitáyqueyra,” cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Etat José pueblo Arimatea binan Pilato quin bijacro. Josean Jesús chíwaro. Jesús chiwa cuar, judíoin cahmar ay wini rehquít, uw quin ehcútiro. José Pilato quin bir, Jesús chein beyin chíjacro. Joseat Jesús chein chícayat, Pilátoat ajc waajacro. Ajc waacayat Joseat Jesús chein yehw̃ béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo cat José owár béjecro. Nicodemo eya cahmor chéycara cut Jesús jor chihtá tew̃ay bijáquinro. Eyin beyar inan ay bi treinta kilo acat béjecro. Inan ay bi ajca mirra cat béjecro. Istiy ajc áloe cat béjecro. Owár rihnojoquey béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesús chein yehw̃ beyar Joséinat, Nicodémoinat Jesús chein lienzo oya cut inan ay bi cat wir wir bacojocro. Judíoinat chein ruhcuín acu eyta órocuano. ");
INSERT INTO tuf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús caruc ojcor yauwin quejequey awat intac cut caruc rijaquey quesro. Ey caruc rijaquey ques cut chein ruhcuín acu ac ucar ésatro. Ac ucar ey sar chein anto rúhctiro. ");
INSERT INTO tuf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Cuanmí cut tan jaquin rícara cuanata rehquít, ac ucar ey intac rehquít, Jesús chein ey sar ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tan jaquin rícara waar, semán istiy rauyat cuan racayat, María Magdala bin Jesús chein ruhjaquey cut bijacro. Erar cur ítitan, chein ruhjaquey ucar itchacro. Ucar ac ohná cut tunjaquey waar tejec itchacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Maríat eyta istír Simón Pedro quin, Jesús chiwa istiy quin quinjacro. Chiwa istiy eya asró. Jesusat asan sehnacan toro. María is quin quinír cur wajacro: —Is cara chein ruhjaquey bar újacro. Biscán chájactar isat istítiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Etat Pedro cat, as cat chein ruhjaquey cut béjecro. Buca jor quinjacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Asan cuít quinír ibtu cujacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chein ruhjác ac ucar cutar cur car bahujacro. Bahúr querat ucar acor cuar wahitchacro. Ititan, lienzo oya ésatro. Wahitic cuar raútiro. ");
INSERT INTO tuf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wahityat Pedro questoc raquín wiquír, ac ucar sar raújacro. Rauwir ítitan, lienzo oya ésatro. Oya Jesús chein cuisa bacojóc cat ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ey óyara istiy oya cut chátiro. Ajquír bihsúr chajac itchacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Etat ibtu cujaqueya as cat ac ucar sar raújacro. Rauwir oya itchacro. Istír séhw̃ajacro: “Uniro. Jesús sicor yehnjacro,” séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Isat Sir carit cutar Jesús sicor yehnata cuihsujác ey anto ay ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Etat is sicor ijmár camjac usi béjecro. ");
INSERT INTO tuf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Be yiror María chein ruhjaquey ac ucar watar itro. Ocaro. Erar ita rabar bahujacro. Bahúr ac ucar querat acor cuar wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ititan Sir cuacúr cacmín bucáy ésatro. Oya cuas bi ojcumro. Jesús chein chájaquey awat cut istiy cuisa chájaquey wihár chihrjacro. Istiy ques chájaquey wihár chihrjacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wahityat Sir cuacúr cacminát María quin wajacro: —Wiw̃ú, ¿icrát oca? Maríat wajacro: —Uwat as cara chein uc béjecro. Biscán chájactara aját istítiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eyta waquír ícarich waar wahitchacro. Icar wihár wahitír Jesús esar itchacro. Itchác cuar eyan Jesús séhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Etat Jesusat María quin wajacro: —¿Wiw̃ú, icrát oqui? ¿Baha rehr uroy wiqui? táyojocro. Maríat tan sehw̃at, eya caruc rijaquey obir yajquib, séhw̃ajacro. Eyta sehw̃ar wajacro: —Bahat Jesús chein béjectar, biscán chájactar as quin ehcuwi, -wajacro-. Aját chein ucay ben acu as quin biscán chájactar ehcuwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Etat Jesusat wajacro: —¡Maríu! Jesusat María im ajc cut aw̃uyat, Maríat eyan Jesús séhw̃ajacro. Jesús acat ac waar cuar wajacro: —Ráboni, wajacro. Hebreo cuw cut eyta wajacro. Eyta wáqueyan “síw̃quibu,” waquíc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Etat Jesusat wajacro: —As bútati jaw̃i, -wajacro-. As anto Tet quin cuacúr biti rehquít bútati jaw̃i, -wajacro-. Bútati cuar as tamo síhw̃aqueyin quin biwi, -wajacro-. Uchta wacay biwi. As sicor cuacúr as Tet quino, eyin Tet quino benro. As cuacúr as Sir quin, eyin Sir quin benro, waw̃i, as tamo síhw̃aqueyin quin. ");
INSERT INTO tuf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Etat María Magdala bin Jesús chiwa quin bijacro. Eyin quin cur imat Jesús itchác chihtá ehcujacro. Jesusat wac áyjaquey cat ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Im ey ricar tin bicayat, Jesús chiwa cha bahjaquin sécuajacro. Secuar querat tunír questajacro. Judíoin cahmor ay wini rehquít questajacro. Esar sécuayat Jesús eyin tasar waajacro. Eyin tasar waar ténajacro: —As racaro. Ohbac chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eyta waquír, ima atcar quejequey cat, urá rahmaram icar quejequey ehcujacro. Etar éyinat Jesús istír, chiwa ahnian to rehjecro. ");
INSERT INTO tuf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Etat Jesusat bucoy eyin quin wajacro: —Ohbac chaw̃i, -wajacro-. As Tetát asan cajc uch cutar uw quin áyjacro. As Tetát asan cajc uch cutar ayjac eyta, aját cat ba eyta áyinro, as chihtá uw quin ehcwayta acu. ");
INSERT INTO tuf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesusat eyta waquír, eyin cutar camur cuhjacro. Camur cuhwir wajacro: —Aját ba ur icar Sir Ajcan Camur Eya chácaro. Ey chihtá wácati caw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eya ba ur icar chácayat, baat uchta yajcáyqueyra. Uwat Sir tayar yajcayat, baat cahujín ojcor “sicor tayar bár chájacro,” wacáyqueyra. Eyta wacayat Sirat cat eyin ojcor “tayar bár,” wacáyqueyra. Eyta cuar cahujín ojcor “tayar ji rehcaro,” wacáyqueyra. Eyta wacayat, Sirat cat eyin ojcor “tayar ji rehcaro,” wacáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús ima chiwa quin wicayat, Tomasi eyin owár batro. Uwat Tomasan wisa aw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesús wicayat, Tomás esar bár rehquít, chiwa cahujinat Tomás quin wajacro: —Isat cara itchacro, wajacro. Eyta wajác cuar Tomasat wajacro: —Uní batro. Aját baat ey itchác séhw̃atiro. Ajatrá puntí cut ey atcar quejequey chicha istiti eyra, as at ub ucar icar chati eyra, as atcar ey urá rahmaram ícara chati eyra baat ey itchac séhw̃atiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Eyta waquír bucoy semán istiy jat chiwa bucoy sécuajacro. Usar secuar querat tunir questajacro. Tomás cat eyin owatro. Querat questajác cuar Jesús eyin tasar waajacro. Eyin tasar waar ténajacro: —As racaro. Tan wan chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bahnaquin quin eyta waquír, Tomás quin wajacro: —As atcar wahítuwi, -wajacro-. Bah at uba usár ucar icar chaw̃i, -wajacro-. Etar bah atcar tew̃ír as urá rahmaram icar chaw̃i, -wajacro-. Acsar as chinjác sicor yehnti séhw̃ati jaw̃i. As sicor yehnjacro, séhw̃awi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Etat Tomasat Jesús quin wajacro: —Bahan as cáraro. Bahan as Sitro, wajacro, Jesús quin. ");
INSERT INTO tuf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Etat Jesusat Tomás quin wajacro: —Bahat as behmá ub cut istír as sicor yehnjác, séhw̃aro, -wajacro-. Bíyinat as istiti cuar, as sicor yehnjác síhw̃ayatan, éyinan ahnian cuít rehcaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusat chiwa cac cahmar Sir urá cut bahnác bár yajcata ehcujacro. Bucoy cat, bucoy cat imát Sir urá cut yajaquey eyin quin eyta ehcujacro. Eyta cuar bahnacra carit uch cutar cuihsútiro. ");
INSERT INTO tuf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Carit uch cutar cuihsujaquey baat Sirat Cara Ayin Wajaquin Jesús ayjac síhw̃ayta acu cuihsujacro. Jesús Sir wacjá síhw̃ayta ac cuihsujacro. Jesús tamo eyta sihw̃ar, ba Sir owár etiti ohbac ítayqueyra. Baat eyta sihw̃an acu carit uch cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Itchareht yájcajareht Jesús bucoy ima chiwa cac cahmar waajacro. Riw Tiberias cajc aw̃at eyin quin bijacro. Uchtaan ey ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Riy istiy Simón Pedro Jesús chiwa cahujín owár sécuajacro. Secuar Tomás cat, Natanael cat, Zebedeo sasá bucáy bin cat, istiy chiwa bucáy cat ésatro. Tomás eya wisa aw̃ujáqueyro. Natanael eya pueblo Caná cajc Galilea cutar binro. ");
INSERT INTO tuf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Secuar Simón Pédroat wajacro: —As rih ruwa yajcáy benro, wajacro. Pédroat rih ruwa yajcáy ben wacayat, cahujinat cat wajacro: —Is cat bah owár béyinro, wajacro. Eyta waquír riw cut béjecro. Cur canó sar raújacro. Rauwir riw arcutar canó cut béjecro. Rih ruwa che wan sarac yajquít cat icrí útiro. ");
INSERT INTO tuf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cuan bicayat, riw cajc aw̃at uw itchacro. Jesús erar cui chájacro. Chiwat ey itchacro. Eyta istír cuar eyan Jesús síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Etat Jesusat eyin cuit cohwjacro: —Uwinu, ¿baat rih ruwa icrí útiqui? cohwjacro. Etat éyinat wajacro: —Batro. Ubistii útiro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Etat Jesusat eyin quin wajacro: —Atarrayan cuic bajít tajquíc wihár tewi, -wajacro-. Ey wihár técayat bar siátaro, wajacro. Eyta wacayat atarraya cumac bi owár binat téjecro. Técayat rih ruwa to cájacro. Rih ruwan to cajac rehquít, atarraya sicor canó sar yéhw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Etat Jesús chiwa sehnacan cuít biyan ajatán Pedro quin wajacro: —Eyan is cáraro, wajacro. Pédroat eyan is cara chihtá rahcuír car, oya sutchacan sicor chájacro. Chaquir riw icar tu jin bijacro. Etar riw cajc cut waajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chiwa cahujín cat canó cut riw cajc cut waajacro. Rih ruwa atarraya cuin tas caquir, canó cut rih cajc cut ruc bejecro. Riw cajc cut cuwayta biráy batro. ");
INSERT INTO tuf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Riw cajc aw̃at cur ítitan, cucúr oca ánjacro. Oca arcút rih ruwa wahnro. Pan cat ésatro. ");
INSERT INTO tuf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Etat Jesusat eyin quin wajacro: —Baat rih ruwan awan sijaquey sicar bin cahujéy row̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eyta wacayat, Simón Pedro sicor canó sar raújacro. Rauwir rih ruwa atarraya cuin tas cájaquey rih cajc cut rújacro. Rih ruwa cumac bina cájacro. Saw̃úr ítitan, ciento cincuenta y tres cájacro. To cajac cuar atarraya ráchtiro. Ey sicar bin cahujéy Jesús quin rojocro. ");
INSERT INTO tuf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Etat Jesusat eyin quin wajacro: —Ira yayay row̃i, wajacro. Eyta wacayat, chiwat Jesús quin “bahan rehrcá” wátiro. Eyinat ítitan, ijmár cáraro. Eyta itchác rehquít “¿bah rehrcá?” tayon acu ehúr wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Etar Jesusat pan yehw̃jacro. Yehw̃ír, eyin quin wíjacro. Pan wiquir car, rih ruwa cat yehw̃jacro. Yehw̃ír, eyin quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús chinír sicor yehnár ima chiwa ubot waajacro. Icar bawoy cat waar eyin cac cahmar eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ira yaya tihryat, Jesusat Simón Pedro quin wajacro: —Simonu, Juan waquijú, ¿Bahatan asan sehnacan, cahujinat cuítica? táyojocro. —Caru, éytaro. Behmát ítitan, aját bah sehnacan cuitro, wajacro. Etat Jesusat Pedro quin wajacro: —Eytatara obas sasá obir yajquír eyta as chihtá awan cájaqueyin éytaan wan obir yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Etat Jesusat bucoy wajacro: —Simonu, Juan waquijú, ¿Bahat as sehnáica? táyojocro. —Caru, éytaro. Behmát ítitan, aját bah sehnacan cuitro, wajacro. Etat Jesusat wajacro: —Eytatara óbasin obir yajquír eyta as chiwan éytaan wan obir yajw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Eyta waquír Jesusat icar bawoy Pedro quin wajacro: —Simonu, Juan waquijú, ¿Bahat as sehnáica? táyojocro. Jesusat icar bawoy ¿bahat as sehnáica? táyoyat Pedro cue rehjecro. Cue rehquír wajacro: —Caru, bahat bahnác itro. Aját bah sehnác cat itro, wajacro. Etat Jesusat Pedro quin wajacro: —Eytatara óbasin obir yajquír eyta as chiwan éytaan wan obir yajw̃i, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aját bah quin wacaro. Bah síbijin cuácayat bah oya chaquir, biscán bi cúntara erar bijacro, -wajacro-. Eyta cuar bah werjáy rehcayat, bah cuic rucáyqueyra. Cuic rucayat, cahujinat questátaro. Questár bah bi cun bár cut ahár beyátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesusat eyta wacayat, Pedro bitara chinátatara ey récaji ehcujacro. Pedro chinír cutar Siran ayan cuít ehcwata eyan récaji ehcujacro. Etat Jesusat Pedro quin wajacro: —As chiwa chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eyta wacayat Pédroat ícarich wari istír chiwa istiy itchacro. Jesusat chiwa eya sehnacan cuitro. Chiwa eya bach yajquín tino Jesús owár yaya rabar Jesús ecor ihtujáqueyro. Ihtúr uchta wajáqueyro. “Caru, ¿Rehrát bah quehsí bin at icar chácataca?” táyojoqueyan eyro. ");
INSERT INTO tuf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pédroat chiwa ey istír, as istír Jesús quin táyojocro: —Caru, ¿Uyra? ");
INSERT INTO tuf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Etat Jesusat wajacro: —Eyra as sicor wicayca acat tas yarti it ay cúntara ajmár chihtá cut yarti it áyataro. ¿Bahat bitara reht ey tamo sehw̃a yarqui? Bahatra ey tamo sehw̃a yarti jaw̃i. Ey tamo séhw̃ati cuar, as chiwa chaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","“Yarti it ay cuntar yarti it áyataro,” wajác rehquít, Jesús chiwat “chiwa eyra yárajatro,” wajacro. Acsar, acsar chiwa istiy quin, istiy quin eyta wajacro. Eyta cuara Jesusat “Eyra yárajar” ójcori wátiro. Jesusat wajacro: “Eyra as sicor wicayca acat tas yarti it ay cuntar, yarti it áyataro. ¿Bahat bitara reht ey tamo séhw̃aqui?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","As ojcor eyta tew̃jacro. Chiwa eya asan eyro. Ajatán Jesusat yajaquey chihtá ehcuro. Aját ey chihtá cat cuihsujacro. Is bahnáquinat ítitan, aját uní ehcuro. Uní cuihsujacro. ");
INSERT INTO tuf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusat yajaquey ojcor cuihsujác cuar, Jesusat yajaquey bahnác ehcú báhnajatro. Etar aját bahnác cuihsútiro. Jesusat yajáqueyan uwat bahnác cuihsuquir waquít, cáritan cajca teya bahnác cutar raúwajar acat cuihswátaro.");
INSERT INTO tuf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilu, cahmor carit bah quin bar wíjacro. Ey cuitar Jesusat siw̃jac aját bahnác cuihsú bahjacro. Jesusat yajác ojcor bahnác cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesusat siw̃ay yehnár cuacúr ben acat tas yajaquey, síw̃jaquey bahnác cuihsú bahjacro. Jesusat ima chihtá ehcuquin cájacro. Etar cuacúr ben cahmor ima chihtá ehcuquin quin chihtá ehcujacro. Sir Ajcan Cámuran Ey urá cuitar ehcú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesusan chinír sicor estají yehnjacro. Yehnár ima chihtá ehcuquin ubot waajacro. Riya cuarentan bucoy bucoy eyta waajacro. Eyta waacayat ima chihtá ehcúquinat itchacro. Ititan Jesús sicor estají yehnjacro. Jesusat eyin ubot waa rabar, Sir cara rehquey bitáratara eyin quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Etar chiwa bahnác sécuajacro. Secuar Jesusat eyin quin wajacro: —Baan pueblo Jerusalén cuitar ítuwi. Récaji cajc istiyrá beti ítuwi. Eyta ityat, Sirat ba quin istiy áyataro. Aját récaji ba quin wajác eyta Sirat áyataro. Eyta bira ey wiquíc acor ítuwi. ");
INSERT INTO tuf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Uwat Sir tamo síhw̃ayat, Juanat récaji eyin rih sar siw̃jacro. Cuatán baat Sir tamo síhw̃ayat, awan Sirat ima Ajcan Cámuran Eya ba ur icar chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Eyta cuácayat chihtá ehcuquin Olivo cuhs cut sécuajaquinat Jesús quin táyojocro: —Caru, ¿Ahran is israélinat ijmár gobierno cháquinica? ¿Ijmár carin yiníc cab bar cujaqui? táyojocro. ");
INSERT INTO tuf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Táyoyat Jesusat wajacro: —Bitat chácatatara, bitat yehnátatara anto baat istata bini batro. Ey istín acu Sirat anto ajc waátiro. Sir ima urá cut chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eyta cuar Sir Ajcan Cámuran Eya ba ur icar chácayqueyra. Eyta chácayatan ba urán cuít rehcáyqueyra. Etar Jerusalén pueblo cuitar aját yajaquey uw quin ehcwáyqueyra. Judea cajc cuitar cat ehcwáyqueyra. Samaria cajca cuitar cat ehcwáyqueyra. Cajc bahnác cuitar eyta ehcwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eyta waca rabar chiwa ubot Jesús yehnár ques anti cuacúr béjecro. Béyeyan bowarám tac icar raújacro. Bey yahncút chiwat Jesús bucoy istítiro. ");
INSERT INTO tuf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ima chiwat cuacúr tanachin wahityat, Sir cuacúr cacmín chiwa ubot waajacro. Cuisa bucáy bin oya cuasáy tas bin waajacro. Waar car wajacro: ");
INSERT INTO tuf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—¿Galilea uwu, bitara reht cuacúr wahitqui? Jesús ba ub acat cuacúr bir eyta sicor cat im eyta wicáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Etar chiwa erar terá ajca Olivo cutar bin sicor Jerusalén béhjecro. Olivo terá cutar bin pueblo Jerusalén cuwayta kilometro úbisticuano. Jerusalén behquir car ");
INSERT INTO tuf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","camic usi béjecro. Camic usi rauwir cuacúr querat icar raújacro. Pedro cat, Juan cat, Santiago cat, Andrés cat, Felipe cat, Tomás cat, Bartolomé cat, Mateo cat, Santiago cat, Simón cat, Judas cat esar raújacro. Santiago istiy Alfeo waquijró. Simón eya cananístainro. Judas eya Santiago tanaró. Bahnaquin esar querat sar raújacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bahnáquinan bucoy bucoy Sir ojcor conín acu sécuajacro. Chaunín owar, Jesús abín owár, tanín owár eyta conín acu sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Erar chiwa Sir ojcor conquin saw̃ujacan, ciento veintecuano. Jesús chiwa Jerusalén behquir, Sir ojcor conyat, Pedro eyin tac icar yehnár wajacro: ");
INSERT INTO tuf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Sir Ajcan Cámuran Eyat cahmor úchicrias David quin chihtá ehcú áyjacro. Etar Davidat récaram Júdasat yajcata cuihsujacro. Davidat cuihsujác eyta ahra Júdasat eyta yajacro. Soldádoinat Jesús cácayta acu bírartara Júdasat ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jesusat récaji is cácayat owár, Judas cat cájaquinro. Isat yajquír eyta Júdasat cat eyta yajquín acu cájaquinro. Eyta cuar Júdasat Jesusan bírartara quehsuquin quin ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ehcuí tehmár ey quin ray túnjacro. Ay bár yajquír ray cajac ey cutar cajc wahjacro. Ey cajc cutar ima yau yarjacro. Yau yaryat yir boschacro. Bosír, bucchír bahnác újacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Etar Jerusalén uwat eyta yarjác chihtá cab rehti rahjacro. Eyta rahcuír cajc ey ajc Acéldama aw̃ujacro. Eyta waquíqueyan imár cuw cutar “Ab bijaquey cajcro,” waquíc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judas ey ojcor Davidat Salmo carit cuitar cahmoran úchtaan cuihsujacro: Ey usi ima cham báhtaro. Rehrí ítajatro, ey úsara. Etar cat uchta cuihsujacro: Eyat yajti etchaquey istiyát yajcáy yehnátaro, cuihsú bahjacro, Davidat Judas ojcor. ");
INSERT INTO tuf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Carit cutar eyta cuihsú bahjác cuácayat, Júdasat yajti etchaquey yajcayta acu isat istiy cácataro. Caca rabar uch síhw̃ataro. Jesús is owár chácayat, is owár birar urar cuiti bijaquin cácataro. ");
INSERT INTO tuf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juanat récaji uw rih sar siw̃íc cuitar cuar Jesús cuacúr biquic acat tas cuaquir is owár bijaquin cácataro. Eyta bin caquin síhw̃ataro, is owár chihtá ehcuquin yehnayta acu. Eyat Jesús sicor estají yehnjác ehcwayta acu cácataro. Eyat itchaquey ehcwayta acu cácataro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eyta wacayat, chiwat cuisa bucáy bin cájacro. José cat, Matías cat cájacro. José eya ajc istiy Barsabás aw̃uro. Ajca istiy Justo aw̃uro. Caquir eyin imár cac cahmar chájacro. Etar Sir ojcor uchta wac conjacro: ");
INSERT INTO tuf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","—Siru, Tetú, bahat is cuitar waw̃i. Bahatán uw urán itro. Uw urá bitáratara itro. Uch serin bucáy sicar bin bi cáquitar is quin ehcuwi. ");
INSERT INTO tuf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Júdasat bah quehsí waar car, cab oc icar bijacro. Júdasat ehcuti báhjaquey ehcwayta acu ¿sera bi cácataca? Chihtá ehcuquib yehnayta acu ¿bi cácataca? wac conjacro. ");
INSERT INTO tuf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eyta conár car, istín acu aquey abir ica cuitar téjecro. Ey chihtá istín acu téjecro. Técayat bar itchacro. Eyta yajquír cuitar Matías cájacro. Etan Matías chihtá ehcuquin owár chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Etar birá cuanyat Pentecostés fiesta cuanjacro. Eyta cuanyat, Jesús chiwa bahnaquin usar sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Eyta secuar éyinat ráhcuitan, séroan abáy caquic ajcan wan cuacúr bin rahjacro. Ubach bahnác icar ayir ajc eyta rahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eyta rahcuír car eyin arcutar oca cúbaran wan waajacro. Oca cúbaran wan eyan istiy arcutar, istiy arcutar chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eyta chácayat owár, Sir Ajcan Cámuran Eyan eyin ur icar wijacro. Chiwa bahnaquin ur icar wijacro. Wicayat, istiyát cuw istiy, istiyát cuw istiy tew̃ay yinjacro. Sir Ajcan Cámuran Eyat bi cuw cut tew̃ay áyjactara eyta tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pentecostés fiesta eyta cuanyat, cajc istiy bin judíoin, cajc istiy bin judíoin Jerusalén cuitar ítchacro. Uw éyinat Sir tamo sihw̃ac binro. ");
INSERT INTO tuf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Uw éyinat ajcyár biquey rahjacro. Rahcuír caran, uw ricán to sécuajacro. Jesús chiwa acor sécuajacro. Secuar ráhcuitan, imár cuw cut tew̃ic rahjacro. Eyta rahcuiran ojc sijacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ub yehw̃jacro. Ub yehw̃ír rahra rahra wajacro: —Eyta téw̃quinan bahnáquinan Galilea uwro. Eyta cuar éyinat istiyát cuw istiy, istiyát cuw istiy tew̃ro. Isat ráhcuitan, ijmár cuw cut tew̃ro. ¿Eyinat bitara etar eyta tew̃íctara? -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Isan usár sécuajac cuar cuw istiy, cuw istiy téw̃quinro. ");
INSERT INTO tuf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Is cahujín Partia cajc cut binro. Cahujín Media cajc cut binro. Cahujín Elam cajc cut binro. Mesopotamia cajc cut bin cat, Judea cajc cut bin cat, Capadocia cajc cut bin cat, Ponto cajc cut bin cat, Asia cajc cut bin cat, ");
INSERT INTO tuf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia cajc cut bin cat, Panfilia cajc cut bin cat, Egipto cajc cut bin usár sécuajacro. Cahujín Africa pueblo Cirene intac binro. Cahujín pueblo Roma bin inic béjecro. Cahujina im judíoin yehnjacro. Cahujina judío bár bin cuar judío chihtá cajac binro. ");
INSERT INTO tuf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cahujina Creta cajc cut binro. Cahujina Arabia cajc cut binro. Eyta cuar is bahnáquinat ijmár cuw cutara tew̃ic rahcro. Sirat ima urá cut chihtán cuít yajác ojcor tew̃ro. Is cuw cutar eyta tew̃ro. Eyta tew̃quey isat orac rahcro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eyta waquír car ub yehw̃ír acsar rahra rahra wajacro: —¿Bitara etar eyta tew̃qui? wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eyta cuar cahujinat Jesús chiwa buror sisír wajacro: —Uw eyin simat bar béjecro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Etar chiwa once bin owár yehnár Pédroat ricá to bin quin wajacro: —Sérinu, judíoinu, Jerusalén cutar ítquinu, ba bahnáquinat aját tew̃ic yají rahcwi. ");
INSERT INTO tuf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Baatán is simat bejec sihw̃ac cuar símati bétiro. Ahajira rahsa urá cahm ícatro. Uwra uchta jat simat bétiro, -wajacro-. ");
INSERT INTO tuf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Récaji Sir chihtá ehcuquib Joelat uchta rehcata ojcor ehcujacro. Joelat récaji ehcujác ahra yajquíc cab cutar cujacro. Joelat récaji uchta wajáquinro: ");
INSERT INTO tuf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Sirat uchta wacaro: “Cábara tina cab cu racayat, aját uchta yajquinro,” wacaro, Sirat. “As Ajcan Cámuran Ey uw ur icar cháquinro. Bahnaquin ur icar cháquinro. Eyta chácayat, ba sasát Sir chihtá ehcwáyqueyra. Cámsiris istír eyta wábjirinat éytaan wan istáyqueyra. Werjayín cat cámsiris chináyqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","As cacmín ur icar as Ajcan Cámuran Ey cháquinro,” wacaro, Sirat. “Serin ur icar cat, chaunín ur icar cat cháquinro. Eyta chácayat, as chihtá ehcwáyqueyra,” wacaro, Sirat. ");
INSERT INTO tuf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","“Cuacúr abá cuitar cat uwat anto istiti bi istá áyinro. Cajc cutar cat uwat anto istiti bi yajquinro. Ab cat, oca cat, íyara cat to yehn áyinro. ");
INSERT INTO tuf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rahs cat bahnác tin áyinro. Sihyór cat aban wan buwonro,” wacaro Sirat. “Cuacúr cara yehnín cahmor eyta rehcáyqueyra. Cuacúr cara yehnín cuanyat, ey tamo bahnáquinat síhw̃ayqueyra,” wacaro. ");
INSERT INTO tuf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","“Eyta cuácayat, bíyinat cara ojcor conyat, aját eyin cuitar waquinro. Eyin obir yajquinro,” wacaro, Sirat. Joelat récaji eyta wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pédroat Joelat wajquey ehcúr acsar wajacro: —Israélinu, uch rahcwi. Jesús Nazaret pueblo bin Sir imát ayjac ba quin bar ehcujacro. Jesusat icúr bár sicar Sir urá cut bitar utar yajacro. Uwat anto istiti bi ba ub acat yajacro. Sir urá cut bahnác bar yajcata ehcujacro. Jesusat eyta yajác baatán itro. Behmár tac icar ita rabar eyta yajacro. Etar Sirat ey ayjac síhw̃ataro. ");
INSERT INTO tuf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Baat ey anto yauwin síhw̃ati cuat Sir imát eyta yauwata récaji it bin cuar, im eyta chaw̃ jájacro. Ba at icar wíjacro. Etatan baatán serin ay bár bin quin caruc ojcor yauwin quejc áyjacro. Eyta yaujacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eyta yauwi cuar, Sirat sicor estají yehn áyjacro. Eyra sicor yehnata bin etar chein ohnír eyta ohnín acu ajc waátiro. ");
INSERT INTO tuf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidat ey ojcor úchicrias wajáquinro: Aját ítitan, carin asi jotro. Eya úchicrias tehmótiro. Eyat as cuitar wacaro. As obir yajcaro. Eyta bira as ojc sítiro. Roótiro. ");
INSERT INTO tuf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","As ur icar ahniro. As cuw cutar ahní tacaro. As sibár yarir cutar Sirat as sicor estají yehn áyayqueyra. Aját eyta séhw̃aro, -wajáquinro-. ");
INSERT INTO tuf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","As chinyat, bahat asa wahntar cajc cutar cham baha báreyra, -wajáquinro, Sir quin-. Aját bah chihtá cácayat, as obir yajcaro. As sibatrá ohn aya báreyra. ");
INSERT INTO tuf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Cuatán bahat as ay itin síw̃jacro. Eyta cuácayat, bah joran asan chinti ítinro, wajáquinro, Davidat Sir quino. Pédroat Davidat wajaquey ehcúr acsar wajacro: ");
INSERT INTO tuf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Rábinu, bah quin David ojcor ehúr bár wacaro. David chinyat ruhjacro. David chein ruhjaquey awat bísartara, isat itro. ");
INSERT INTO tuf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Cuatán David Sir chihtá ehcúquibro. Davidat ítitan Sirat ima bómcara sicar caran yehn ayin wajacro. David cara yehnár eyta im bomcar cat eyta yehn ayin wajacro. Davidat eyta itchacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidat eyta itchác etar Cristo sicor yehnata récaji ehcujacro. Uchta wajáquinro: “Wahntará cajc cutara cham baha báreyra. Ey sibár ohn aya báreyra,” wajáquinro, Davidat. ");
INSERT INTO tuf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sirat Jesús yaryat sicor yehn ayin wajacan ahra sicor estají yehn áyjacro. Isat eyta itchacro, -wajacro, Pédroat-. Istír yarsa ehcuro. Is bahnáquinat itchacro, caba ehcún acu. ");
INSERT INTO tuf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Etar Jesús sicor yehnár, Sir quin Tet quin bijacro. Sir owár Tet owár cara yehn áyjacro. Sirat úchicrias imát yajquín wajacan tehmoti yajacro. Jesús cut cuar im Ajcan Cámuran ey áyjacro. Jesús cut cuar uw ur icar ima Ajcan Cámuran Ey chájacro. Behmarat rahjác eyan eyro. Itchác eyan eyro. ");
INSERT INTO tuf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Cuatán David ima sibatrá cuacúr bitiro. David imát Cristo ojcor wajáquinro: Sirat as Cara quin wajacro: “As owár cara yehnín ac ítuwi,” -wajacro, Sirat-. ");
INSERT INTO tuf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“Ba quehsí bin quin bah chihtá cac ayic ocso tas as owár ítuwi,” wajacro, Sirat as cara quin. Davidat Cristo ojcor eyta wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Israélinu, uch rahcwi, -wajacro, Pédroat-. Baatán Jesús im eyan caruc ojcor quejecro. Eyta quejquír yaujacro. Eyta cuar, Sir imát Jesusan cara chájacro. Cristo chájacro, wajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eyta wacayat, uwat rahcuír, imarat ur ay bár yajác tayar ques cuécujacro. Cueat urá cuájacro. Etar Pédroin quin wajacro: —Rábinu, ¿isat ur ay bár tayar yajác bitara ácuca? ¿Ahra isat icúr yajcátaca? wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Etat Pédroat wajacro: —Ba urá tehmowi. Ur ay waawi. Eyta waar Sir ojcor conwi, -wajacro, uw quin-. Etar aját ba rih sar siw̃inro. Ba Jesús chiwa aw̃a rabar rih sar siw̃inro. Baat Sir tayar yajacan Jesusat tayar bár chácayqueyra. Eyta cuácayat, Sir Ajcan Cámuran Ey ba ur icar chácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sir imát eyta yajquín wajacro. Ba acu cat, ba sasá acu cat, cajc istiy bin acu cat eyta yajquín wajacro. Sirat biyin imáy chaquin chícayat, eyin acu eyta yajquín wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pédroat eyta yajquín tew̃jacro. Acsar acsar ur tehmoyta acu tew̃jacro. Uchta wajacro: —Uch uw ay bár bin owárara rehti jaw̃i, -wajacro-. Eyinat yajquír eyta baat eyta yajti jaw̃i, -wajacro-. Eytair báreyra, ba cat sácayqueyra. Eyin owár sácayqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Etat ricán to binat ey chihtá cájacro. Cuisa tres mil binat cájacro. Caquir car, rih sar siw̃ áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Etat Sir chihtá cájaqueyin Jesús chihtá ehcúquinat siw̃quey sinay yinjacro. Jesús chiwa owár ur istán chájacro. Iran bajcán panan owár tahw̃úr cohjocro. Jesús tamo sihw̃a rabar cohjocro. Sir ojcor bahnáquinat owár conjacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pédroinat Sir urá cut bitara útara icúr bár sicar bin to yajacro. Uwat anto istiti bi to yajacro. Eyta yajcayat, uwat Sir tamo sihw̃ay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Etar cat chiwa owár ur istanác chájacro. Imaray icuran biyan rahra rahra tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Chiwa istiyát óyatara cájctara rajacro. Rar car rayan chiwa bahnaquin owár tahw̃ujacro. Oya bár bin, ira bár bin ac wíjacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cuanmí cuit, cuanmí cuit Sir úsian owár sécuajacro. Imár usi cat owár cohjocro. Ira yaya rabar owár bin ahní ítchacro. Rahran rahran tayar bár ira yájacro. ");
INSERT INTO tuf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Uwat “Siran ayro,” wajacro. Uw bahnáquinat cat eyin tamo ay síhw̃ajacro. Etar acsar acsar istiyát cat, istiyát cat Sir chihtá cájacro. Caquir Jesús chiwa owár sécuajacro. Sirat eyta secuan ac chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Riy istiy rahs táw̃ari jat, Pedro Juan jor Sir usi béjecro. Rahsan táw̃ari jat uwat Sir ojcor conro. Eyin beyar cat Sir usi querat acor cujacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sir ojcor conic querat eyan óriquen querat aw̃ujacro. Sir usi querat acor cur ítitan, ser istiy quescar chohcuá ésatro. Chohcuá rehquít im istir sahu sahu bitách béjetro. Eyta cuácayat, istiyát cuanmí cut, cuanmí cut erar yehw̃ béjecuano. Querat ey acor uw quin ray chiín acu chájacuano. ");
INSERT INTO tuf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Etar Pédroin Juanin Sir usi querat acor cur rauyat, chohcuát eyin itchacro. Istír eyin quin ray chíjacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chícayat éyinat wahitchacro. Istír car wajacro: —Is wahítuwi, wajacro. Eyta wacayat, chohcuát eyin wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Raya as quin wiquin yajc waátaqui,” sehw̃ar wahitchacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Eyta cuar Pédroat wajacro: —Asra ray batro. Oro batro. Eyta cuar aját bah acu icuran yajcátatara aját ey yajquinro, -wajacro-. Aját Jesucristo ajc cut bah tan jáquinro, -wajacro-. Jesucristo Nazaretin ajc cut cui yehnwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eyta waquír car, atcar sicar yehw̃ cájacro. Caquir yehw̃jacro. Yehw̃ír car quescar cat, ques ihyatruca cat canar chi rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Eyta cuácayat chohcuán quescar cat, ques ihyatruca cat chihchí rehquír ica cutar biji bura bur ten yehnjacro. Bur ten yehnár ques cut sahu sahu bijacro. Etar Pédroin owár Sir usi raújacro. Sir usi cuacrár bur ten quinót raújacro. Eyta quina rabar Sir ojcor ay tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Etar uw bahnáquinatan chohcuá tan jajac itchacro. Orac waajác itchacro. Sir ojcor ay tew̃ic rahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Eyta istír, imár ur icar síhw̃ajacro: “Ser eyat récaram ray chi yarjácuano. Querat ay bin acor it yárquincuano. Ahra bar tan jájacro,” síhw̃ajacro. Eyta sihw̃ar ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chohcuá tan jájaqueyat im at cut Pédroin Juanin sutiti cájacro. Cácayat uwa bahnaquin ub yehw̃jacro. Eyin quemir quinjacro. Salomón ara cahmar quiujacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pédroat uw eyta quiwíc istír wajacro: —Israélinu, ¿bitara reht ub yehw̃yi? ¿Bitara reht is wahitqui? ¿Isat ijmár urá cut chohcuá tan chájaqui síhw̃aca? ¿Isat bachan cuít yajquír cuitar tan chájaqui síhw̃aca? Eytai batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","’Abrahamin, Isaaquin, Jacobin is cohtín Sirat Jesucrístoan cara chájacro. Ima wacján uw ubot caran im owara chájacro, wajacro, Pédroat. ’Eyta cuaquir, israélinu, baat Jesús cájacro, -wajacro, uw quin-. Caquir soldado at icar wíjacro. Wiquir Pilato ub cahmar ruhw̃ujacro. Pilátoat im úrara uc ayin séhw̃ajacro. Pilátoatra uc ayin sehw̃ac cuaquir, baat uc ayti síujacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesucristo eya urá ayro. Sir ub cahmar ayro. Ur ay bi baat ruhw̃ujacro, -wajacro, uw quin-. Cuatán ur ay bi tehmár Pilato quin uw yauquib uc ayin chíjacro. Cuatán Jesucristo yauwin wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jesucrístoan Sir owár etiti ohbac it áyqueyro. It áyqueyan baat yaujacro. Eyta yauwi cuar, Sirat sicor estají yehn áyjacro. Jesucristo sicor yehnyat, isat ijmár ub cut itchacro. ");
INSERT INTO tuf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Im ey Jesús urá cut isat chohcuá uch tan jájacro. Quescara cuitaran yéhnajar biyan Jesús ajc cutar chihchí yehnjacro. Ahra orac waajacro, wajacro, Pédroat. ’Ahra behmár ub cut chohcuá uch tan jájaquey itro. Cahmor cat behmarat chohcuá uch it binro. Behmarat itic uyan Jesús ajc cutar yajacro. Isat síhw̃ajacro: “Jesús ajc cutar bar tan jácata,” síhw̃ajacro. Etar chohcuá quescar canar chi rehquír yehnjacro, wajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Rábinu, aját ítitan, behmarat Jesús it cuar eyan Sir wacjí síhw̃atiro. Ba cárinat cat eyta síhw̃ajacro. Eyta cuácayat, Jesús yaujacro, wajacro, uw quin. ");
INSERT INTO tuf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","’Uchicrias Sirat bar ehcujáquinro. Ima chihtá ehcuquin cuitar eyta yajcata ehcujáquinro. Sirat Cara Ayin Wajaquin uwat ruhw̃ata ehcujáquinro. Uchicri eyta yajcata ehcujaquey ahra eyta yajacro, -wajacro, Pédroat-. ");
INSERT INTO tuf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eyta cuácayat baan ur ay bár yajác ques ahra cue rehw̃i. Urá tehmowi. Ur ay bár yajquíc etwi. Sir tamo síhw̃awi. Sir tamo síhw̃ayat, baat Sir tayar yajacan Sirat tayar bár jácayqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tayar bár chaquir ba quin ténayqueyra. Ba urá tan wan rehquín acu ténayqueyra. Etatan Jesús sicor áyayqueyra. Ba acu Cara Ayin Wajaquin sicor áyayqueyra, -wajacro, uw quin-. ");
INSERT INTO tuf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ahra Jesucristo cuacratro. Inicra wícajatro. Sir jor ítataro. Anto bahnác caba orac chaquic cab cuti eyra wícajatro. Uchicrias Sir chihtá ehcúquibat eyta ehcujáquinro, wajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","’Moisesat úchicrias uchta wajáquinro: “Sirat as áyjacro. As ayir eyta chihtá ehcuquib istiy cat eyta áyayqueyra,” wajáquinro, Moisesat. “Behmár sícara bin yehn áyayqueyra,” wajáquinro, israelin quin Jesús ojcor. “Yehnyat ey chihtá bahnác yají rahcwi,” wajáquinro. ");
INSERT INTO tuf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Bíyinatan ey chihtá rahcti rehcáyatan Sirat bar sutáyqueyra. Uw sicar bin uquir sutáyqueyra,” wajáquinro, Moisesat. ");
INSERT INTO tuf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pédroat uw quin Moisesat wajacan ehcúr acsar cat wajacro: —Uchicrias Sir chihtá ehcuquin istiyát cat, istiyát cat Samuelat cat ah uch cutar bitara yajcátatara récaji ehcujacro. Samuel yahncút binat cat eyta ehcujacro. Eyinat wajác eyta ahran im eyta yajcaro, wajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","’Baan Sir chihtá ehcuquin wihnínro. Chihtá ehcuquin bomcatró. Sir imát ba acu yajcata ey ba cohtín quin chihtá wíjacro, -wajacro, uw quin-. Sirat Abraham quin uchta wajáquinro: “Bah wihná chihtá cuitar asan uw bahnaquin acu ay rehquinro. Cajca bahnác cuitar itquin ácuan asa ay rehquinro,” wajáquinro, Sirat Abraham quin. ");
INSERT INTO tuf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eyta wajác etar Sirat ima wacjá ibtu ba quin áyjacro. Ba cuitar waquín áyjacro. Baat ur ay bár yajquíc etayta acu Jesús áyjacro, wajacro, Pédroat uw quino. ");
INSERT INTO tuf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pédroinat Juáninat eyta ehcwayat icar, judíoin carin eyin acor béjecro. Sir usi soldado carin cat, sacerdótein cat, saducéoin cat béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bequir ráhcuitan Pédroinat uw quin chihtá ehcuro. Uw quin Jesús sicor estají yehnjác chihtá ehcuro. Uw sácajaquin sicor yinata chihtá ehcuro. Eyta ehcwayat judíoin túrjacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Turir car eyin caquir questajacro. Questár cárcel icar tunjacro. Bar tinjac etar cárcel icar tunjacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eyta cuar ráhcyeyinat Pédroat tew̃jác chihtá cájacro. Uwan to binat cájacro. Sérinan cinco mil binat cájacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ey cuanmí cuit judío carin Jerusalén cuitar sécuajacro. Sacerdótein, werjayín, bachan chihtán siw̃quin sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sacerdote cara ajca Anás cat, Caifás cat, Juan cat, Alejandro cat eyin owár sécuajacro. Anás cayin cat eyin owár sécuajacro. Secuar car owár tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro cat, Juan cat roc áyjacro. Rocayat eyin quin táyojocro: —Baatán eyta yajquíc eyan, ¿rehr ajc cut, rehr urá cuit eyta yajcyi? wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Eyta táyoyat Sir Ajcan Cámuran Eyat Pedro quin urá wíjacro. Uchta wac áyjacro: —Cárinu, werjayinú, ");
INSERT INTO tuf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","aját ráhcuitan baat chohcuá tan jajac ojcor táyoro. Isat chohcuá tan jajac eyan bitara tan jájactara ey táyoro. ");
INSERT INTO tuf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Etar aját ba quino cat, israelin bahnaquin quino cat ehcunro. Chohcuá ser uch tan jajac ey Jesucristo ajc cutar tan jájacro. Jesucristo urá cutaran ser uchan orac waajacro. Jesucristo Nazaret bin eya baatán caruc icar yaujacro. Yaujác cuar Sirat sicor estají yehn áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesucristo ojcor Sir carit cuitar úchicrias uchta cuihsú bahjacro: Ba ac ubach túw̃quinat ac cumac bi úbisti ay bár sehw̃ar, te sijacro. Eyta te sijác cuar ac ey Sirat sicor yehw̃ roquír ácoso tebir chájacro, cuihsú bahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ac te siquir eyta Jesús cat ria bár eyta téjecro. Baat eyta te sicayat, Síratan sicor cara yehnín chájacro. Síratan istiyát uw síwata wátiro. Cuat Jesucrístoatra ima ajcan urán tahnác bíjiyat uw síuro, wajacro, Pédroat. ");
INSERT INTO tuf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pédroat eyta wacayat, judíoinat ítitan, carin ayot rooti tew̃ro. Cuít sinti cuar, rooti tew̃ro. Eyta istír síhw̃ajacro: “Eyin Jesús owár chájaquinro,” síhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eyta síhw̃ajac cuar icurí wácajatro. Chohcuá tan jájaqueyan Pédroin Juanin owár im ératro. Eyta bira, Pédroin cahm icar bitách téw̃ajatro. ");
INSERT INTO tuf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Eyta cuácayat eyin watar inic áyjacro. Pédroinat rahcti acu inic watar si áyjacro. Pedro watar waa yiror rahra rahra usar tew̃jacro: ");
INSERT INTO tuf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—Isat uw éyinat acsar yajti acu isat bitách síwajatro, -wajacro-. Eyinat chohcuá imár urá cuit, bow̃ cuit tan jájacro. Eyta yajaquey Jerusalén uw bahnáquinat itro. Eyta cuácayat, isat “Eyinat eyta tan chátiro,” bitách wácajatro. ");
INSERT INTO tuf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","’Cuatán eyin ajc chin chácayta acu tec ajc cut ahnwátaro: “Baat Jesús ojcor bucoy uw cucajá acat ajc chin jaw̃i,” wacátaro. Uwat ey chihtá cati ácuan eyta wacátaro, wajacro, cárinat imár owár. ");
INSERT INTO tuf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eyta waquír Pédroin sicor chíjacro. Chícayat sicor raújacro. Rauyat eyin quin cárinat wajacro: —Jesús ojcor ajc chin jaw̃i. Ey chihtá acsar siw̃ti jaw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Waquít Pédroinat wajacro: —¿Isat Sir chihtá cácataica? ¿Ba chihtá cácataica? ¿Sir ub cahmor bi yajcátaica? Behmarat eyta síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Cuatán isat itchác eyra ruhcti ehcwátaro. Isat rahjác eyan ruhcti ehcwátaro. Ajc chin bitách chácajatro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Eyta wacayat cárinat tecuas cut ahnúr wajacro: —¿Baatán acsar echí ehcúyeyra isat ba cuécwajaca? wajacro. Eyta tecuar bar uc si áyjacro. Uw bahnáquinat Sir ojcor ay tew̃jacro. Eyta tew̃yat cárinan uw cahmor ay wini rehjecro. Eyta rehquít bitách técuajatro. Chohcuá Sir urá cuit tan chájaquey bara cuarenta cuítcuano. ");
INSERT INTO tuf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ucayat Pedro cat, Juan cat Jesús chiwa cahujín quin béjecro. Bequir judío cárinat wajacan bahnác ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eyta ehcwayat, bahnáquinat Sir ojcor owár conjacro. Uchta wac conjacro: —Siru, bahan Sir quéneyro. Behmatan bahnác chájacro. Cuacúr abá cat, cajca cat bahnác chájacro. Yacúr cat bahnác chájacro. Abá sar bahnác, ica cutar bahnác, rih sar icuran biyan bahnác baat chájacro. Behmatan bahnác chájacro, -wajacro, Sir quin-. ");
INSERT INTO tuf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bah Ajcan Cámuran Eyat is cohtín David quin wac áyjacro. Bah chiwa Davidat carit cuitar uchta cuihsú báhjacro: Judío bár bin cuayar tutro. Uw cuayar ríoro. Uwat Sitrun Tetrún bitách cuácajatro. ");
INSERT INTO tuf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cajc cutar carin bahnáquinat Sir tecuan acu ríojocro. Jéfein sécuajacro. Secuar Sir cuaquin ríojocro. Sirat Cara Ayin Wajaquin cuaquin ríojocro. Cárinat eyta ríojocro, cuihsú bahjacro, Davidat. ");
INSERT INTO tuf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Uchicri eyta yajcata wajaquey ahran eyta yajacro, -wajacro, chiwat Sir quin-. Rey Herodes cat, gobernador Poncio Pilato cat owár sécuajacro. Judíoin cat, judío bár bin cat sécuajacro. Eyta secuar Jesús yauwin acu ríojocro. Uch pueblo cuitar ríojocro. Bah wacjá ay bi yauwin ríojocro. Cara áyjaquey ríojocro, -wajacro, Sir quin-. ");
INSERT INTO tuf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Behmá urá cuit, bow̃ cuit récaji uwat ey yauwin wac bahjacro. Yauwin wac bahjác eyta bar yaujacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ahra éyinat bucoy is cat cuaquin wacaro. Siru, is cuaquin wajacan bahat wahítuwi, -conjacro-. Is cuitar behmát waw̃i. Isat bah chihtá uw quin ehcwayta acu is ayú bár chaw̃i. Isan bah cacminró, -wajacro, Pédroinat, Juáninat uw owár Sir quin-. ");
INSERT INTO tuf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Is quin urá wiw̃i. Etatrun isat yárqueyin tan jáquinro. Uwat anto istiti bi yajquinro. Bah urá cut bahnác bar yajcata ehcunro. Jesús urá cut, isat eyta yajquinro. Bah wacjá ayan cuít bi urá cuit eyta yajquinro, wajacro, uwat Sir quin. ");
INSERT INTO tuf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eyta conyat ey ubach yiw yiw yiwojocro. Yiwóyatan Sir Ajcan Cámuran Eya eyin ur icar chájacro. Etan Sir chihtá ayuí bár ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesús chiwa yinyat rahra rahra ur istán chájacro. Imárayan imár istir acu síhw̃atiro. Es yajti imaray icuran biyan rahra rahra tahw̃ujacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesucristo chihtá ehcuquin cat urán to rehjecro. Urán to rehca rabar Jesús sicor estají yehnjác chihtá ehcujacro. Eyta ehcwayat, Sirat bahnaquin obir yajacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Eyta cuácayat eyin sicar uwa oya bár réhtiro. Ray bár réhtiro. Cahujinat imaray sicar bin cájctara úbachtara rajacro. Eyta rar car ");
INSERT INTO tuf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ray ey Jesús chihtá ehcuquin at icar chájacro. Eyta chácayat, chihtá ehcúquinat chiwa cahujín icúr táyoctara eyin quin wíjacro. ");
INSERT INTO tuf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Eyta cuácayat ser ajc Joseat cat imáy icúr bi wíjacro. José eya cajc Chipre bíncuano. Eya cohtín Leví bomcarcuano. Jesús chihtá ehcúquinat José eyan Bernabé aw̃ujacro. Ajca Bernabeyan uchta wacaro: “Cue bin quin ahní chac ayquib” waquíc ojcor wacaro. ");
INSERT INTO tuf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Joseat ima cajc rajacro. Rar car ray sécuajacro. Secuar cahujín acu tahw̃ún ac Jesús chihtá ehcuquin at icar wíjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chiwat eyta yajcayat, ser ajca Ananíasat cat ima cajc rajacro. Ananías ey wiya ajca Safíracuano. Ananíasat Safira jor imár cajc rajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Rar car Ananíasat ray cahujeyra imáy ajquír chájacro. Eyta chaquic wiyat itchacro. Eyta chaquir, Ananías wiquír ray cahujéy chihtá ehcuquin at icar wíjacro. Bahnaqui witi cuar eyin quin bahnác wijac wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Etat Pédroat Ananías quin wajacro: —Ananíasu, Satanasat bahat ur ay bár yajcayta acu cayar yajacro. Sucuar tew̃ayta acu cayar yajacro. ¿Bitara reht bah eyta cayar yajc ayi? “Uchan ray bahnác” waca rabar cahujéy behmaray yajc jájacro. Eta jaw̃ Sir Ajcan Cámuran Eya cayar yajquín séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Cajc anto rati cuatra behmáy binro. Etar cajc rar car rayan behmaray binro. Cuatán bahnác witi cuar “bahnác wijac,” wacáyatra Sir quin sucuar tew̃ro. ¿Ba bitar reht eyta yajquín síhw̃ayi? Baat uw quínoi sucuar téw̃tiro. Sir ima quínora sucuar tew̃jacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pédroat Ananías quin eyta wajacro. Eyta wacayat Ananíasat rahcuír car ic icar quehr queni bijacro. Quehr bir chinjacro. Ananías chinjaquey chihtá uwat rahjacro. Bahnáquinatan eyta rahcuír car Sir cahmar ay wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ananías chinyat, síbijin béjecro. Bequir Ananías chein bacojocro. Bacór cat yehw̃ béjecro. Yehw̃ beyar cat ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ananías chinyat, chein ruhcuír awan tres horas cuácayat, Ananías wiya Pédroin quin wijacro. Ananíasan wiyat istiti chinjacro. Ruhcuíc cat istiti ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ey wiya wicayat Pédroat ey quin táyojocro: —¿Baatán ra jor cajc rayi? —Ee, bar rajacro. —¿Unian acan éytai rayi? —Acan eyta rajacro. Pédroat eyta táyoyat eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Etat Pédroat wajacro: —¿Bitar reht bah ra jor Sir Ajcan Cámuran Eya eyta cayar yajquín yinyi? -wajacro-. Rahcwi. Serin bah sera ruhcuay béjequin bar rocaro. Querat acor rauro. Eyinat bah chein cat yehw̃átaro. Bah cat im eyta ruhcuátaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pédroat eyta wacayat icar, Safira Pedro ques cahmar quehr queni bijacro. Quehr bir chinjacro. Etat síbijin raújacro. Rauwir Safira chein bar itchacro. Istír yehw̃ béjecro. Yehw̃ beyar sera ruhcuíc écoso ruhjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Etan Jesús chiwa ay wini rehjecro. Uwa bahnaquin rahjaquin cat ay wini rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Uw tac icar, Jesús chihtá ehcúquinat Sir urá cut búcoyan búcoyan icúr bár sicar bítara útara yajacro. Uwat anto istiti bi yajacro. Riy istiy, riy istiy Jesús chiwa Sir usar owár sécuajacro. Sir usar Salomón ara cahmar sécuajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesús chiwa bár éyinra Jesús chiwa owár sécuatiro. Ay wini rehquít eyin owár sécuatiro. Eyta cuar bahnáquinat Jesús chiwa ojcor ay tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eyta cuácayat uwan quir binat Jesús chihtá cacay yinjacro. Serin quir binat cat, wiw̃ín quir binat cat Jesús chihtá cájacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cuácayat Jesús chihtá ehcúquinat uw yarquin tan jájacro. Eyta tan jácayat uwat yarquin ibit cutar chájacro. Aw̃at cuitar chájacro. Pedro beta acat chájacro. Yarquin ar ojcor Pedro taw̃an jaquin acu eyta chájacro. Pedro taw̃a cutar, yarquin tan jácayta acu eyta chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pueblo Jerusalén intac pueblo istiy itquin, pueblo istiy itquin cat béjecro. Ricán quir bi béjecro. Uwa yarquin cat yehw̃ rojocro. Cuicát ruhw̃uquin cat rojocro. Eyta rocayat bahnáquinan bar tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Eyta cuácayat sacerdote cara cat, saducéoin cat abáy túrjacro. Uw sicar es yajacro. Es yajca rabar, to túrjacro, Jesús chihtá ehcuquin acu. ");
INSERT INTO tuf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eyta rehquít sacerdóteinat chihtá ehcuquin cájacro. Caquir cárcel icar tunjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eyta cuar cheycar cuitar Sir cacúm cuacúr bin wijacro. Wiquír car cárcel querat waajacro. Waar car Jesús chihtá ehcuquin watar si béjecro. Beyar wajacro: ");
INSERT INTO tuf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Ba sicor Sir usar béowi. Erara cur chihtá ehcuwi. Jesús chihtá cuitar uwa ohbac ítata ehcuwi. Chihtá bahnác ehcuwi, wajacro. Sir cacúm cuacúr bin wiquír eyta wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eyta wacayat, chihtá ehcúquinat ey chihtá cájacro. Cuan racáyatan Sir usi raújacro. Rauwir siw̃ay yinjacro. Eyta siw̃yat icar áwatra sacerdote cárinatra Israel werjayín chíjacro. Chiír carin bahnaquin sécuajacro. Secuar car cárcel úroquin ac chihtá áyjacro. Jesús chihtá ehcuquin roquín acu wac áyjacro. Policia áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Policia cárcel usi cur ítitan, Jesús chihtá ehcuquin esar batro. Etatan sicor carin sécuajaquin quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Eyin quin sicor cur car wajacro: —Isan cárcel usi cúwira. Cur ítitan, quérata ay questajacro. Candádoan im éytaro. Soldado cat querat acor cuar úroro. Etat isat querat waajacro. Waar ítitan, uw batro. Cárcel sar úbisti batro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eyta wacayat soldado áyquibat ub yehw̃jacro. Sacerdote carin cat ub yehw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Etar ser istiy eyin quin wijacro. Wiquír wajacro: —Rahcwi. Serin baat cárcel sar tunjaquin sicor Sir úsatro. Esar cuar sicor uw siw̃ro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eyta wacayat soldado cara jor cara cahujín béjecro. Jesús chihtá ehcuquin ucay béjecro. Técuati cuar ucay béjecro. Uw cahmoran ay wini rehquít técuati újacro. “¿Uwat is cuitar ac téjeca?” sihw̃ar técuati újacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Uquir sécuajaquin cac cahmar chájacro. Chaquir sacerdote cárinat chihtá ehcuquin quin wajacro: ");
INSERT INTO tuf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Isatra ba quin Jesús chíhtara siw̃ ayti cuar baatrá acsar echí siw̃ro. Jerusalén bahnaquin quínoan Jesús chihtá ehcuro. Baat waquitan, Jesusan judíoin chihtá cuitar yaujác wacaro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Eyta wacayat, Pédroinat wajacro: —Isatra uw chíhtara cati cuar, Sir ima chihtá cáquinro, -wajacro, Pédroinat-. ");
INSERT INTO tuf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Baatán Jesús caruc ojcor quejquír yaujacro. Jesús eyta yaujác cuar, Sir imát ey sicor estají yehn áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yehnár car Sirat im ecor sicor chájacro. Cara chájacro. Uw cuitar waquín ac chájacro. Eyta cuitar wacayat israelin ay bár yajquíc et cúntara, éyinat ay bár yajquíc tayar Sirat sicor tayar bár chácayqueyra, wajacro, Pédroinat. ");
INSERT INTO tuf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","’Isat eyta istír ehcuro. Sir Ajcan Cámuran Eyat cat eyta istír ehcuro. Sirat ima Ajcan Cámuran Eya ima chihtá cáqueyin ur icar chácaro, wajacro, Pédroat carin quino. ");
INSERT INTO tuf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Eyta wacayat, carin sécuajaquinan abáy túrjacro. Chihtá ehcuquin yau cun rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yau cun rehcáyatan fariséoin ajca Gamaliel eyin tasar cui yehnjacro. Gamalielan sécuaquin owatro. Bachan chihtán síw̃quibro. Bahnáquinat Gamaliel ajcá ji chájacro. Gamaliel yehnár, Jesús chihtá ehcúquinan watar áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eyin watar bey icar aw̃at cahujín quin wajacro: —Israélinu, yají jaw̃i. Eyin cuáyatra yauti jaw̃i. Istiti rabara eyta yajti jaw̃i, -wajacro-. Cuatán uch síhw̃awi. ");
INSERT INTO tuf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Riy istiy ser ajca Teudas yehnjacro. Teudasat waquít: “Asan cáraro,” wajácuano. Teudasat eyta waquír car, imayan chiwa ricán cuatrocientos sécuajacro. Sécuayat semar Teudas yaujacro. Yauyat chiwa bahnáquinan bar cui béjecro. Teudas chiní yiror, eyat yajquín séhw̃ajacan acsar yájtiro, wajacro, Gamalielat. ");
INSERT INTO tuf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","’Ey yahncút semar Judas cat yehnjacro. Uw saw̃ún cuanyat, Judas yehnjacro. Judas Galilea uwro. Júdasat cat chiwa séhw̃anar sécuajacro. Eyta secuar awan Judas yaujacro. Yauyat ey chiwa cat cajc istiy, cajc istiy cui béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eyta bira ahrun ser úchinra catoti jaw̃i. Eyta chácayat, éyinat imár chihtá cuitar ehcúctara semar chihtá ey bahnác bahnáyqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Cuatán Sir chihtá queney ehcúctara bitách báhnajatro. Eyta cuácayat cham chaw̃i. Eytair báreyra, Sir chihtá cuitar ehcúctara, ¿isat eyin tecuay yinyat, Sir ima jor tecuay yínajaqui? wajacro, Gamalielat sécuajaquin quin. ");
INSERT INTO tuf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamalielat eyta wacayat, uwat ajc cájacro. Jesús chihtá ehcúquinan sicor chíjacro. Chiír car chistara cuit bujacro. Buquír cat uchta técuajacro: —Jesús ójcotra búcoyra tew̃ti jaw̃i, wajacro. Eyta waquír uc si áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Uc si ayir Jesús chihtá ehcúquinan ahní rehjecro. Jesús chihtá ques icar ruhw̃ujác etar ahní bejecro. ");
INSERT INTO tuf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Etar cuanmí cuit, cuanmí cuit chihtá ehcúquinat Sir usar síw̃jacro. Istiy usi cat, istiy usi cat chihtán ay bi uchta etiti ehcujacro: “Sirat Cara Ayin Wajaquin Jesusan eyro,” wajacro. Uw quin eyta síw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Awana ítchareht uw ricán to binat Sir chihtá cájacro. Ricán to rehc bicayat, Jesús chiwa cahujinan cahujín ac imár owár túrjacro. Griego cuw téw̃quinat Hebreo cuw tew̃quin acu túrjacro. Turir griégoinat wajacro: —Ira tahw̃uyat ijmár griégoin sácajaquin wíyara conú ruhw̃uro. Eyin quínora ira conu wícaro, wajacro. Eyta bira griégoinan judíoin owár ira conu wiquic ques túrjacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eyta cuácayat, chihtá ehcúquinat chihtá cacyin sécuajacro. Secuar eyin quin wajacro: —Isat chihtá ehcwayat ira bitách táhw̃ujatro. Cáysiro. Isat Sir chihtá ehcwátaro. Eyta bira cáysiro. Isat ira tahw̃úyeyra, Sir chihtá éhcwajatro. ");
INSERT INTO tuf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eyta bira behmár sicar bin sera cuisa cucuí caw̃i, ira tahw̃ún acu. Uw ub cahmor ur ay bin caw̃i. Sir Ajcan Cámuran Ey chihtá ay cájaquin caw̃i. Ay síhw̃aquin caw̃i. ");
INSERT INTO tuf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Etat isat Sir ojcor ohbac conáyqueyra. Sir chihtá ohbac ehcwáyqueyra, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Eyta wacayat bahnaquin ahní rehjecro. Etar Esteban cat, Felipe cat, Prócoro cat, Nicanor cat, Timón cat, Parmenas cat, Nicolás cat cájacro. Estébanat Sirat bahnác yajcata séhw̃ajacro. Sir Ajcan Cámuran Eya Esteban ur ícatro. Nicolás pueblo Antioquía binro. Judío bár yehnjác cuar eyat judío chihtá cajac biro. ");
INSERT INTO tuf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Serin eyin caquir Jesús chihtá ehcuquin quin béjecro. Cucayat Jesús chihtá ehcúquinat serin eyin cuitar Sir ojcor conjacro. Conár car átcaran eyan cuis otar chájacro. Sirat eyin cajac síhw̃ajac reht eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Etat caban Jesús chihtá ojcor birar birar tew̃ic rahjacro. Jerusalén cuitar cat uw ricán to binat Sir chihtá cájacro. Sacerdótein ricán to binat cat Sir chihtá cájacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban eya serin cucuí cájaquin sicatro. Esteban Sirat ay obir yajacro. Urán to wíjacro. Etar Estébanat urán to cuácayat, uwat anto istiti bi yajacro. Icúr bár sicar Sir urá cut bitara útara yajacro. Bucoy, bucoy eyta yajacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eyta yajcayat, cahujinat Esteban quehsujacro. Esclavo ricuajaquin secuac usar binat Esteban quehsujacro. Cirene judíoinat cat, Alejandría judíoinat cat, Cilicia judíoinat cat, Asia judíoinat cat Esteban quehsujacro. Etar ey jor tecuay yinjacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tecuay yinyat, Sir Ajcan Cámuran eyat Esteban quin urán ajcan cuít wíjacro. Urán chihtán cuít wíjacro. Eyta wiquir cuitar eyat ajcan cuít tew̃jacro. Tew̃yat cahujinat icuri wácajatro. ");
INSERT INTO tuf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eyta cuácayat, judíoinat cahujín cájacro. Caquir eyin tan téjecro, Esteban cahm icar sucuar tew̃ayta acu. Tan te rabar uchta wajacro: —Uchta waw̃i: “Estébanat Sir ojcor ahsín tew̃ro,” waw̃i. “Moisés ojcor ahsín tew̃ro,” waw̃i. “Is cucách cuit eyta tew̃ic rahjacro,” waw̃i, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eyta wac tan técayat, sérinat Esteban cahm icar eyta tew̃jacro. Eyta tew̃yat, uwan Esteban acu bar túrjacro. Werjayín cat, bachan chihtán siw̃quin cat túrjacro. Turir Esteban cájacro. Caquir car judío secuac uw quin, judío carin quin béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eyin quin beyar uw Esteban cahm icar sucuar tew̃ayta acu bucoy wahitchacro. Istír Esteban cahm icar sucuar tew̃ayta acu tan téjecro. Etar sucuar téw̃quinat wajacro: —Estébanat Sir usi ayan cuít bi ojcor ajc ahsín tew̃ro. Bachan chihtá ojcor cat ajca ahsín tew̃ro. ");
INSERT INTO tuf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Isat ráhcuitan Estébanat waquít: “Jesusat Sir ubach quehráyqueyra,” wacárora. “Moisesat wac bahjác tehmóyqueyra,” wacárora. “Jesús Nazaret binat eyta yajcáyqueyra,” wacárora, Estébanat. Isat eyta rahjacro, wajacro, sucuar téw̃quinat. ");
INSERT INTO tuf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eyta wacayat, secuac uwat Esteban ítitan, Sir cuacúr cacmín acan wan beo beo eyta Esteban acan éytaro. ");
INSERT INTO tuf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Etar sacerdote cárinat Esteban quin wajacro: —¿Bah cahm icar tew̃ic uchan unica? wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eyta wacayat, Estébanat wajacro: —Rábinu, werjayinú, as ajc rahcwi. Siran Abraham ubot waajacro. Is Siran ayan cuít bin ey wan beo beo eya Abraham ubot waajacro. Abraham eya is récaraman cohtinró. Abraham Mesopotamia cajc cut ityat Siran ey ubot waajacro. Anto Harán cajc cut witi cuat waajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Waar car Sirat Abraham quin wajacro: “Cajc istiy cut yehnár biwi. Bi cajc cutar cuwátatara, aját ehcunro. Behmá cayin chaw̃ jaw̃i. Behmá cajc cat chaw̃ jaw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sirat eyta wacayat, Abraham cajc Caldea bin yehnár bijacro. Cajc Harán cun bijacro. Cur car erar ítchacro. Itchareht yájcajareht Abraham tet chinjacro. Tet chiní yiror Sirat acsar Abraham cajc uch cutar áyjacro. Ah ricar ba itic cajc uch cutar áyjacro, -wajacro, judío carin quino-. ");
INSERT INTO tuf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Eyta ayir Sirat Abraham ima quínora anto cajc wítiro. Cajcan anto cónui wítiro. Eyta cuar ima quino cat, ima bomcarin quino cat wiquin wajacro. Sirat Abraham quin eyta wacayat, Abraham áhajira sasai bár chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Eyta cuar Sirat Abraham quin uchta wajacro: “Bah bomcar cajc istiy cutar ítayqueyra. Cahujín cajc cutar ítayqueyra. Bara cuatro cientos erar ítayqueyra. Erar ityat cahujín acu cacmín jácayqueyra. Cahujinat ruhw̃áyqueyra. ");
INSERT INTO tuf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Caban etat cuat aját bah bomcar cuitar waquinro,” wajacro, Sirat Abraham quin. “Aját ba bomcar ruhw̃uquin cuécunro. Etat bah bomcar síwinro. Siwir car cajc uch cut roquinro. Roquír éyinat cajc uch cut as tamo síhw̃ayqueyra,” wajacro, Sirat Abraham quin. ");
INSERT INTO tuf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eyta waquír umá cuic áyjacro. Eyta wajác chihtá sehw̃an acu umá cuic áyjacro. Eyta yajquín wacayat, Abraham waquíj Isaac yehnyat abi cuanyat Isaac umá cuíjacro. Isaacat cat ima wacjá Jacob umá cuíjacro. Jacobat cat ima sasá doce bin umá eyta cuíjacro. Jacob sasán is cohtinró, wajacro, Estébanat judíoin sécuajaquin quin. ");
INSERT INTO tuf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Itchareht yájcajareht is cohtín Jacob sasát tet sar es yajacro. Tetát José sehnacan cuít cuácayat, is cohtinát tet sar es yajacro, José acu. Es yajquír ruhw̃ujacro. José ray tehmár rajacro. Racayat cajc egipto cut cacúm chaquin acu questa béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ima sáquinat eyta ruhw̃ujác cuar Sirat José cuitar wajacro. José urán chihtán cuít wíjacro. Etar José Egipto rey Faraón cahmar ay rehjecro. Faraonat itit, José ur ayro. Ay séhw̃aro. Eyta istír cajc Egipto cuitar cara yehn áyjacro. Im usar cara yehn áyjacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’José cara yehnyat, Egipto cajc cutar ira yéhntiro. Canaán cajc cutar cat ira yéhntiro. Uwan yayat abáy cuájacro. Is cohtín cat ira ístajar rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Etat Jacobat ráhcuitan “Egipto cajc cutar iran chi,” rahjacro. Eyta rahcuír, erar is cohtín ira ucay si áyjacro. Icar istiyí ayti binan si áyjacro. Egipto cur José itchác cuar imár taná síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Itchareht yájcajareht bucoy Egipto béjecro. Erar cucayat, Joseat ima rabin quin iman rehrtár ehcujacro. “Asan ba tanaró. Asan Josero,” wajacro. Etar Egipto rey quino cat ima cayin ojcor ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Etar Joseat ima tet chíjacro. Cayin bahnác chíjacro. Ey cayin saw̃ujacan cuisa setenta y cíncoro. ");
INSERT INTO tuf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eyta jaw̃ Jacobin Egipto cajc cut cun suca béjecro. Itchareht Jacob erar yarjacro. Is cohtín cat erar sácajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Is cohtín chein cáraran cajc uch cut yehw̃ rojocro. Siquem cuitar rojocro. Abraham ima wiya chein ruhcuín acu cajc Siquem ray cuitar wáhjaquinro. Hamor wihnín quin wáhjaquinro. Is cohtín chein roquír, Abramat wáhjaquey cajc cutar ruhjacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Itchareht yájcajareht is cohtín bómcarinan ricán to cohná bijacro. Etat Sirat Abraham quin imát yajquín wajacan yajquíc cuitar cab cujacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Etat cajc Egipto cuitar istiy rey yehnjacro. Rey eyat José istiti binro. José ojcor tew̃ic cat ráhctiro. ");
INSERT INTO tuf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eyta cuácayat rey eyat is cohtín cayar yajacro. Is bihtín ruhw̃ujacro. Is bihtinát imár buwachcuar ajcá bár ab tijcán acu wajacro. Buwachcuar eyta sácayta acu eyta ab tijcán wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Etat owár Moisés yehnjacro. Moisés yehnyat, Siran ahní rehjecro. Moisés yehnár sihyór bay tetín usi cuanjacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eyta cuanyat, Moisesan tetinát rih cajc cutar chac bahjacro. Chac bahcayat rey waquích cahbarat Moisesan ima wacjír cájacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eyta cácayat rey wihnír waajacro. Reyin owár cun yehnjacro. Cun be rabar Egíptoin chihtá bahnác sínjacro. Eyta cuácayat, urán toro. Moisesat yajquíc eyan ayro. Waquíc eyan ayro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Moisés bara cuarenta cuácayat, im uw quin israelin quin pasear yajquín séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Eyta sehw̃ar ima uw quin bijacro. Cur ítitan, Egipto serat israelin bucaro. Eyta istír Moisesat israelin cuitar yajcáy yehnjacro. Eyta tecuay yehnár Egipto uw yau téjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisesat séhw̃ajacro: “As rábinat uchta síhw̃ataro: ‘Moisesan Sirat ayjac síhw̃ataro. Imaran Egíptoin at icar bin siwin Sirat Moisés ayjac,’ síhw̃ataro,” síhw̃ajacro, Moisesat. Eyta cuar im uwat eyta cat síhw̃atiro. ");
INSERT INTO tuf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Egipto uw yauwir, cuanmí cut bucoy israelin quin bijacro. Cur ítitan, israelin imár owár técuaro. Cuisa bucáy bin rahra rahra tajcáy ocuajác itchacro. Eyta istír car sicor tan wan tenan acu tew̃jacro. Moisesat eyin quin wajacro: “Sérinu, baan rábinro. Eyta bira rahra rahra tajcti jaw̃i,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Waquít ruhw̃uquib ey túrjacro. Moisés ur bo téjecro. Ur bo ter wajacro: “¿Bahat eyta waquín acu rehrcá? Bahra is cárai batro. Isat bah cara yehn áytiro,” wajacro, ruhw̃úquibat Moisés quin. ");
INSERT INTO tuf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“Baquír bahatán egíptoin yau téjecro. ¿Ahra bahatán as cat yaúwini yajca?” wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisesat eyta waquíc rahcuír ehurát quinjacro. Cajc Madián cuwayta chajin bijacro. Cur erar ítchacro. Erar ita rabar wiya yehw̃jacro. Yehw̃ír car sera sasá bucáy cohnajacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cajc Madián cutar bara cuarenta ítchareht Sir cacúm cuacúr bin Moisés quin wijacro. Ubach bár cuitar Sinaí cubar intac wijacro. Caruc wahníc sar wijacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Etat Moisesat ítitan, ocat caruc wahníc cuar, caruc im éytaro. Eyta istír ub yehw̃jacro. Etar icrát eyta réhctara wahitay bijacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Caruc intac cucayat, Sirat Moisés quin wajacro: “Asan Sitro. Bah ruiyin Abrahamat cat, Isaacat cat, Jacobat cat as tamo síhw̃ajacro. As ojcor conjacro,” wajacro, Sirat. Eyta wacayat, ehurát Moisés tiujacro. Wahitít cat ehurán to rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Etat wajacro: “Moisesu, ques barcát chájaquey inic cuat quit bo tewi. Cajc uchan as acu ajquír chájacro,” wajacro, Sirat. Etat Moisés ques barcát sutchacro. Etat Sirat bucoy wajacro: “As ajc rahcwi. ");
INSERT INTO tuf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aját ítitan, cahujinat as uw ruhw̃uro. Egipto cuitar israelin ruhw̃uro. Aját rahcuít, as uwat as ojcor conro. Eyta bira aját eyin síwinro,” -wajacro, Sirat-. “Eyta bira bahan in yehnár biwi, Egipto cuwayta. Aját as uw siwin acu bah áyinro,” wajacro, Sirat Moisés quino. ");
INSERT INTO tuf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Israélinat Moisés ria cátiro. Moisés quin wajacro: “Bahra is cárai batro. Isat ba cara yehn áytiro,” wajacro, Moisés quin. Israel uwat eyta wajác cuar, Síratan israelin cara chájacro. Uw siwin acu cara chájacro. Eyta chaquin acu Sirat ima cacmá cuacúr bi quin Moisés cacay áyjacro. Cacmá cuacúr biyat caruc wahníc sar Moisés jor tew̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés eyat israelin cajc Egipto bin síujacro. Cajc Egipto cutar cat, yacúr ajc Buwáy cutar cat, cajc bura catu cutar cat Sir urá cuit uwat anto istiti bin yajacro. Sir urá cut bahnác bar yajcata bucoy bucoy ehcujacro. Cajc buru catu cutar bara cuarentan eyta ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés im uyat uchta wajáquinro: “Sirat ima chihtá ehcuquib istiy áyayqueyra. As ayir eyta istiy cat eyta áyayqueyra. Ba sicar bin yehn áyayqueyra. Ayat ey chihtá caw̃i,” wajáquinro, Moisesat. ");
INSERT INTO tuf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés im uyan cajc buru catu cut israelin owár sécuajacro. Is cohtín owár ítchacro. Sinaí cubar cut Sir cuacúr cacmát Sir chihtá im uyi quin ehcujacro. Ehcwayat im uyat cájacro. Chihtá sútajar bin cájacro. Is quin ehcún ac cájacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Eyta cuar is cohtinát Moisés chihtá ca cun bár rehjecro. Moisés ajcá bár chájacro. Sicor Egipto cut bey cun rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eyta rehquít is cohtinát Aarón quin wajacro: “Behmát is ac sirin órowi, sirin éyinat is sicor cajc Egipto beyayta acu. Moisesra biscántara isat istítiro. Is Egipto bin si rojóc eyra bísartara isat istítiro,” wajacro, Aarón quin. ");
INSERT INTO tuf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eyta wacayat, Aaronat sirir vaca sahan wan órojocro. Oror car ey tamo sihw̃an acu ruwa wahnajacro. Imáratra órojoquey ajcá ji beyin ac fiesta yajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eyta cuácayat, Sirat is cohtín ajcá bár etí téjecro. Uwat ima chihtá cati cuat ajc chin cham bahjacro. Eyinat cuacúr uba tamo síhw̃ajacro. Cuacúr abá cutar ub ojcor conjacro. Eyta cuácayat, Sirat semar cuecun sehw̃ar cham jájacro. Uchicrias Sir chihtá ehcúquinat ey ojcor uchta cuihsú bahjacro. Sirat wacaro: Bara cuarenta ac baatán ruwa bucoy bucoy wahnajacro. Cajc buru catu cuitar wahnjacro. Eyta cuar as ojcor conín acui wáhntiro. As tamo sihw̃an acui wáhntiro. Ruw umá ubach cat yehw̃ béjecro. Eyta cuar eyta béjequeyan ajayi batro. ");
INSERT INTO tuf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ba sirir ajca Molocay béjecro. Baan sirir ajca Refán tamo cat síhw̃ajacuano. Cuacúr aba cutar ub ajca Refán ojcor conjácuano. Sirir im eyan wan órojocro. Oror ey tamo síhw̃ajacuano. Ey ojcor conjácuano. Behmarat at cut sirir órojoc tamora síhw̃ajacro. Eyta yajquíc ques aját ba cajc istiy si áyinro, wacaro, Sirat. Chihtá ehcúquinat úchicri Sirat waquíc eyta, cuihsú bahjacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Is cohtinát Sir ruw umá úbachan yehw̃ rojócuano. Cajc buru catu cut yehw̃ rojócuano. Cohtinát Sir ruw umá ubach istír “Siran is owatro,” síhw̃ajacro. Sirat Moisés quin ruw umá ubach tuw̃ áyjacro. Bitara yajcátatara ey cat ehcujacro. Síratan bitara ehcujáctara Moisesat eyta tuw̃jacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Etar semar cóhnajareht sácajareht cohtinát ruw umá úbachan imár bómcarin at icar bahjacro. Yahncút éyinat cajc Canaán Josué jor síujacro. Ey cajc cutar itquin ohnor síujacro. Sirat ey cajc cut ítquinan cajc istiy si áyjacro, is cohtín erar ítayta acu. Is cohtinán erar itay rocayat, Sir ruw umá ubach cat yehw̃ rojocro. Roquír usár sicor tuw̃jacro. Sicor tuw̃ír David itic ocso tas im eyta rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David rey cara yehnjacro. Yehnyat Siran David jor ahní rehjecro. Davidan urá ayro. Eyta cuácayat, Davidat Jacob Sir acu ac ubach tuw̃ín séhw̃ajacro. Eyta tuw̃ín acu Sirat ajc waayta acu cohnjacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Eyta cuara Davidat túw̃tiro. Ima wacjá Salomonat Sir acu ac ubach tuw̃jacro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","’Eyta cuar cuacúr Siran ubach sar ítitiro. Uw at cut tuw̃jác sar ítitiro. Ey ojcor úchicrias chihtá ehcúquinat uchta wajáquinro: ");
INSERT INTO tuf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Sirat wacaro: “Cuacúr cuitar asan cáraro. Cajc cutar asan cáraro. Eyta cuácayat as acu icúr úbachi túw̃ajatro. As tan jaquin ac ubach táyotiro,” wacaro, Sirat. ");
INSERT INTO tuf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","“Ajmár ajc cut bahnác waquír chájacro. As chihtá cuitar bahnác chájacro,” wacaro, Síratan, Sir chihtá ehcúquinat eyta wajáquinro, wajacro, Estébanat. ");
INSERT INTO tuf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Etati baan ur ay waáticuano, -wajacro, Estébanat, judíoin quin. Ba urán judío bár bin urán wanro. Eyin wan baat cat Sir chihtá ráhctiro. Sir tamo síhw̃atiro. Ba cohtinát yajác eyta baat cat im eyta yajcaro. Sir Ajcan Cámuran Ey quehsuro. Ey ajcá bár bécaro. ");
INSERT INTO tuf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ba cohtinát úchicrias Sir chihtá ehcuquin bahnaquin ruhw̃ujacro. Ubisti tan wan báhtiro. Cristo wicata ehcuquin bahnác tíw̃jacro. Ahra baatán Cristo ima quehsí bin at icar wíjacro. Baatán Cristo yaujacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ba quin Sir imát bachan chihtán wíjacro, -wajacro, judíoin sécuajaquin quin. Cuacúr cacúm at cut ba quin áyjacro. Eyta ayi cuar, baatán cátiro, wajacro, Estébanat judíoin quino. ");
INSERT INTO tuf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Estébanat eyta wacayat, uw sécuajaquin abáy túrjacro. Turir ruhra ojcor cay cohjocro. Técatan ruhra cuech cuech túrjacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Eyta cuara Sir Ajcan Cámuran Eya Esteban ur ícatro. Etar Estébanat cuacúr wahitchacro. Ititan, Siran wan beo béoro. Jesús cat Sir jotro. Sir ecor itro. ");
INSERT INTO tuf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eyta istír wajacro: —Wahítuwi. Aját ítitan, cuacúr Sir querat bar waajacro. Siran ératro. Uw Síuquib Sir ecor itro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eyta wacayat, uw éyinat at ub cucáj icar chájacro. Rahcti acu chájacro. Chaquir ay bár cohwjacro. Esteban chihtá rahcti ac cohwjacro. Cucáj cay tunír ay bár cohwá rabar Esteban cuit yoso wir tiw̃ rojocro. ");
INSERT INTO tuf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Eyta wir tiw̃ roquír cur, Esteban cájacro. Caquir pueblo quer acsar béjecro. Beyar Esteban cut ac ab cuijacro, yauwin acu. Ac ab cuiquin éyinan Esteban cahm icar téw̃quincuano. Eyinat Esteban yauwin inár siricáj sutchacro. Siricáj sutír istiy at icar chájacro. Sera ajca Saulo at icar chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Esteban cut ac eyta ab cuicayat, Estébanat Jesús ojcor conjacro. Conár wajacro: —Caru, Jesusu, as ajqui béowi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Eyta cona rabar, cuscar cuitar chihrjacro. Chihrír wajacro: —Siru, éyinat uchta ay bár yájqueyan tayar bár chaw̃i, as ruhw̃úc tayar ques cuécuti jaw̃i, wajacro. Eyta waquír chinjacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Esteban yauyat Saúloat séhw̃atan: “Esteban yarsa yaujác,” séhw̃ajacro. Esteban yauwi yahncút uwat Jesús chiwan abáy ruhw̃áy yinjacro. Pueblo Jerusalén cuitar abáy ruhw̃áy yinjacro. Ruhw̃áy yinyat, ehurát chiwa cajc istiy, cajc istiy suca béjecro. Cahujín Judea ácubar béjecro. Cahujín Samaria cajc cut béjecro. Eyta cuar Jesús chihtá ehcúquinra bétiro. Beti cuar Jerusalén cuitar ítchacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Esteban yauyat, Sir tamo síhw̃aquinat Esteban chein ruhjacro. Ruhcuír Esteban sehná reht cue rehjecro. Cue rehquír conjacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Etatan Saúloat Jesús chiwan bahnín sehw̃ar ruhw̃áy yehnjacro. Jesús chihtá ques ruhw̃áy yehnjacro. Ruhw̃á rabar istiy usi, istiy usi raújacro. Rauwir chiwa ahár si béjecro. Ahár si beyar cárcel icar chájacro. Chaunín cat, serin cat cárcel icar chájacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Cuatán Jesús chiwa cajc istiy, cajc istiy suca béjequinan birar birar cucayat, erar cat Sir chihtá ehcujacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Suca béjequin istiy sera ajca Felípero. Felipe eya Samaria pueblo bijacro. Erar cur car uchta ehcujacro. “Sirat Cara Ayin Wajaquin Jesús bar ayjac,” wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Felípeat siw̃íc ey bahnáquinatan ay rahjacro. Felípeat Sir urá cut bahnác bar yajcata ehcujacro. Eyta yajquíc uwat itchacro. Istír Felipe ria rahjacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Uwat ítitan, cahujín urá sar bin cuicá uc si áyjacro. Eyta uc si áyatan cuicán ay bár cohwjacro. Uwat ítitan, Felípeat carar cuercurin cat, tan jájacro. Chohcuín cat sicor orac tan jájacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eyta istír Samaria uw bahnaquin ahní rehjecro. ");
INSERT INTO tuf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Samaria pueblo cutar sera ajca Simón ítchacro. Simón eyat cuicá yajquír cut bitara útara yajacro. Uwat Simonat yajquíc istír ub yehw̃jacro. Simón imát waquít, iman caran to wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Etar cuáyinat cat, cárinat cat bahnáquinat Simón chihtá cájacro. Caquir wajacro: —Simonan ajcan cámuran cuít binro. Ey ur icar ajcan cámuran eyan Sírayro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eyat cuicá yajcáy yehnjacan úchicriro. Etar uwat Simón chihtá cájacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felípeat “Sirat Cara Ayin Wajaquin Jesús bar ayjac,” ojcor siw̃yat, Sir cara rehquey ojcor siw̃yat, uwat rahcuír chihtá cájacro. Caquir rih sar siw̃ áyjacro. Sérinat cat, chauninat cat rih sar siw̃ áyjacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simonat cat ey chihtá cájacro. Caquir rih sar siw̃ áyjacro. Etar rih sar siw̃ír car, Felípein owár béjecro. Beya rabar Felípeat yajquíc itchacro. Uwat anto istiti bi yajquíc itchacro. Sir urá cut icúr bár sicar yajquíc itchacro. Istír ub yehw̃jacro. Ay séhw̃ajacro, Simonat. Urán tanan cuít séhw̃ajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria uwat Sir chihtá cajac Jerusalén cuitar tew̃jacro. Jesús chihtá ehcúquinat eyta tew̃ic rahcuír car Pedro cat, Juan cat Samaria cun áyjacro. Ayat, Pedro Juan jor béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samaria cur car, Sir ojcor conjacro: “Siru, Jesús chihtá cájaquin ur icar behmá Ajcan Cámuran Ey chaw̃i,” wac conjacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sirat im Ajcan Cámuran Ey Samaria uw ur icar anto chati etar, eyta conjacro. Eyinat Jesús chiwa chaquin acu rih sar étana siw̃jáquinro. ");
INSERT INTO tuf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Etatan Pédroat ima atcar uw cuisa otar chájacro. Juanat cat ima atcar uw cuis otar chájacro. Atcar chácayat Sir Ajcan Cámuran Ey eyin ur icar raújacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pédroinat atcar chácayat, Sir Ajcan Cámuran Ey uw ur icar rauyat, Simonat itchacro. Simonat eyta istír Pédroin quin wajacro: —Aját bah quin ray wíquinro. ");
INSERT INTO tuf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wícayat, baat yajquír eyta aját cat eyta yajquín acu as quin urá wiw̃i, -wajacro, Pedro quin, Juan quin-. As quin urá wícayat, aját biyin cutar as atcar chácayat, eyin ur icar Sir Ajcan Cámuran Ey raúwayqueyra, wajacro, Simonat. ");
INSERT INTO tuf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Etar Pédroat wajacro: —Bahan behmá ray chi cab oc icar bétaro, -wajacro, Simón quin-. Sirat racar wiquey ray cuit wahta sehw̃ac rehquít cab oc icar bétaro. ");
INSERT INTO tuf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Behm urán Sir ub cahmar ay batro. Eyta rehquít isat Sir urá cut yajquír eyta bahatra éytara yájcajatro, -wajacro, Simón quin-. ");
INSERT INTO tuf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eyta bira bahat ur ay bár sehw̃ac etwi. Etír behmát ur ay bár séhw̃ajac táyaran Sirat sicor tayar bár chácayta acu conwi. Conyat Sirat bah sicor tayar bár chácata óraro, -wajacro, Pédroat Simón quin-. ");
INSERT INTO tuf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bahatan ay bár yajca racar isoro. Ur ay bár icar chájacro, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Etat Simonat wajacro: —As cuitar Sir ojcor conwi. Behmát waquíc eyta as cuati acu as cuitar Sir quin conwi, wajacro. ");
INSERT INTO tuf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yájcajareht, éhcwajareht Pédroinat Samaria pueblo istiy cuitar, pueblo istiy cuitar Jesusat yajacan ehcwót bejecro. Imarat itchaquey ehcujacro. Eyta ehcúr sicor Jerusalén cuwín béjecro. Ibit awat pueblo istiy tiw̃, pueblo istiy tiw̃ béjecro. Jesús chihtá ay bi ehcwót béjecro. ");
INSERT INTO tuf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pédroin be yiror Sir cuacúr cacmá Felipe quin wijacro. Wiquír wajacro: —Jerusalén cut bin Gaza cuwayta ibit aw̃at 