﻿USE sofia;
DROP TABLE IF EXISTS sofia.tue_vpl;
CREATE TABLE tue_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tue_vpl WRITE;
INSERT INTO tue_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo ñecʉ̃sʉ̃mʉãye wãme ãno jóanoã. Jesucristo Abraham pãrãmi, teero biiri David pãrãmi niinʉnʉsegʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac pacʉ niiyigʉ. Isaac Jacob pacʉ niiyigʉ. Jacob Judá, cʉ̃ʉ̃ sõwʉ̃sʉ̃mʉã, cʉ̃ʉ̃ baira pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Fares pacʉ, teero biiri Zara pacʉ niiyigʉ. Cʉ̃́ã paco Tamar niiyigo. Fares Esrom pacʉ niiyigʉ. Esrom Aram pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pacʉ niiyigʉ. Aminadab Naasón pacʉ niiyigʉ. Naasón Salmón pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pacʉ niiyigʉ. Booz paco Rahab niiyigo. Booz Obed pacʉ niiyigʉ. Obed paco Rut niiyigo. Obed Isaí pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí õpʉ̃ David pacʉ niiyigʉ. David Urías nʉmo niimirigomena Salomónrẽ põnacʉtíyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboam pacʉ niiyigʉ. Roboam Abías pacʉ niiyigʉ. Abías Asa pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pacʉ niiyigʉ. Josafat Joram pacʉ niiyigʉ. Joram Uzías pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam pacʉ niiyigʉ. Jotam Acaz pacʉ niiyigʉ. Acaz Ezequías pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés pacʉ niiyigʉ. Manasés Amón pacʉ niiyigʉ. Amón Josías pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconías, teero biiri cʉ̃ʉ̃ baira pacʉ niiyigʉ. Cʉ̃́ã niiritabere Babilonia dita macãrã Israelya põna macãrãrẽ ñee, néewarucuyira cʉ̃́ãya dita Babiloniapʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cʉ̃́ãrẽ néewari siro, Jeconías Salatiel pacʉ niiyigʉ. Salatiel Zorobabel pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiud pacʉ niiyigʉ. Abiud Eliaquim pacʉ niiyigʉ. Eliaquim Azor pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadoc pacʉ niiyigʉ. Sadoc Aquim pacʉ niiyigʉ. Aquim Eliud pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pacʉ niiyigʉ. Eleazar Matán pacʉ niiyigʉ. Matán Jacob pacʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José pacʉ niiyigʉ. José María manʉ niiyigʉ. Coo Jesús paco niiwõ sáa. Jesús Cõãmacʉ̃ beserigʉ Cristo niiĩ. ");
INSERT INTO tue_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Teero tiiró, Abrahammena pʉʉtocʉti catorce põnarĩ macãrã basocáputiyira tée David bauáritomena. Too síro Daviména pʉʉtocʉti catorce põnarĩ macãrã basocáputinemoyira, tée Israelya põna macãrãrẽ Babilonia ditapʉ cʉ̃́ãrẽ ñeewari siro. Too síro cʉ̃́ãrẽ ñeewari siro, catorce põnarĩ macãrã basocáputinemoyira sũcã tée Cristo bauáritomena. ");
INSERT INTO tue_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo bauárigue biiro wáayiro. María cʉ̃ʉ̃ paco Joseména manʉcʉtigodo tiiyígo. Cʉ̃́ã pʉarã́ niiãdari sʉguero, Espíritu Santo tutuaremena niipacó niitoayigo. ");
INSERT INTO tue_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José coo manʉ niigʉ̃dʉ coo niipacó niirére ĩñagʉ̃, “coore duujã́gʉ̃da” jĩĩ wãcũmiyigʉ. Cʉ̃ʉ̃ basocʉ́ ãñugʉ̃́ niijĩgʉ̃, basocá tʉocóropʉ wedesãdʉgariyigʉ. Teero tiigʉ́, “yayióro coore duujã́gʉ̃da” jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cʉ̃ʉ̃ teero wãcũrĩ, quẽẽrṍpʉ ángele cʉ̃ʉ̃rẽ jĩĩyigʉ: —José, David pãrãmi niinʉnʉsegʉ, María ñañarõ tiiríwo. Boboré manirṍ coomena wãmosíaya. Espíritu Santo cʉ̃ʉ̃ tutuaremena coore niipacó wáari tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Coo wĩmagʉ̃rẽ apagodaco. Cʉ̃ʉ̃ wãmecʉtigʉdaqui Jesús. Cʉ̃ʉ̃ wãme “basocáre netõnégʉ̃” jĩĩdʉgaro tiia. Cʉ̃ʉ̃ basocá ñañaré tiiré wapare netõnégʉ̃daqui, jĩĩyigʉ ángele. ");
INSERT INTO tue_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tee niipetire Cõãmacʉ̃ jĩĩrirobirora wáaro tiiyíro. Profetare ateré jóadutiyigʉ: ");
INSERT INTO tue_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Sĩcõ numiṍ ʉ̃mʉmena niiñaripaco, niipacó nii, põnacʉtígodaco. Cʉ̃ʉ̃ wãme Emanuel niiãdacu, jĩĩ jóadutiyigʉ. Emanuel “Cõãmacʉ̃ marĩmena niiĩ” jĩĩdʉgaro tiia. ");
INSERT INTO tue_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José wãcãgʉ̃́, ángele dutiariguere tiiyígʉ. Maríare cʉ̃ʉ̃ya wiipʉ néewayigʉ, nʉmocʉtigʉda jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Teero tiipacʉ́, coo wĩmagʉ̃ apaadari sʉguero, coomena niiñariyigʉ. Bauári siro, cʉ̃ʉ̃rẽ “Jesús wãmecʉtigʉdaqui” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús Judea dita niirí macã Belénpʉ bauáyigʉ. Cʉ̃ʉ̃ bauárito, Herodes judíoaya dita õpʉ̃ niiyigʉ. Teebʉrecorire ʉ̃mʉã́ masĩrí basoca muĩpũ mʉãatirope macãrã Jerusalénpʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Toopʉ́ jeara, sãĩñáyira: —¿Judíoa õpʉ̃ niigʉ̃dʉ noopʉ́ bauáyiri? Ʉ̃sã pʉtopʉ muĩpũ mʉãatirope cʉ̃ʉ̃yagʉ ñocõãwʉ̃́rẽ ĩñawʉ̃. Teero tiirá, cʉ̃ʉ̃rẽ padeorá atiawʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tee quetire tʉoríra Õpʉ̃ Herodere wedera jeayira. Teeré tʉogʉ́, bayiró wãcũpatiyigʉ. Niipetira Jerusalén macãrãcã teerora wãcũpatiyira. ");
INSERT INTO tue_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes niipetira paiaré dutiráre, teero biiri Moisés jóarigue bueráre sʉocó, sãĩñáyigʉ: —¿Cõãmacʉ̃ beserigʉ noopʉ́ bauágʉdari? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cʉ̃́ã yʉʉyira: —Judea dita niirí macã Belénpʉ bauágʉdaqui. Teeré jĩĩ jóarigʉ niiwĩ profeta. Ateré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén Judea ditapʉ niirí macã bʉ́ri niirí macã mee niiã atiditapʉ́re. Tiimacã macʉ̃ õpʉ̃ wáagʉdaqui. Cõãmacʉ̃yara Israelya põna macãrãrẽ cotegʉdʉ niigʉ̃daqui, jĩĩ jóarigʉ niiwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Too síro Herodes yayióremena masĩrí basocare cʉ̃ʉ̃ pʉtopʉ sʉocó, cʉ̃́ãrẽ sãĩñáyigʉ: —¿Deero biiri peti ñocõãwʉ̃́ bauári? Ãñurõ wedeya mʉ́ãcã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wedeari siro, Belénpʉ ticoco, cʉ̃́ãrẽ jĩĩyigʉ: —Wĩmagʉ̃ bauárigʉre sãĩñárã wáaya. Cʉ̃ʉ̃rẽ bʉará, yʉʉcãrẽ wedera atiwa sũcã. Yʉʉcã cʉ̃ʉ̃rẽ padeogʉ́ wáagʉdʉ tiia, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cʉ̃ʉ̃ cʉ̃́ãrẽ wedeari siro, netõjṍãyira sũcã. Maapʉ cʉ̃́ã wáari, ñocõãwʉ̃́ cʉ̃́ãya macãpʉ cʉ̃́ã ĩñarigʉra cʉ̃́ã sʉguero sʉguewayigʉ. Wĩmagʉ̃ niirṍ sotoapʉ jeagʉra, ñocõãwʉ̃́ pʉtʉánʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Teero tiirá, ñocõãwʉ̃́rẽ bayiró ʉseniyira. ");
INSERT INTO tue_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tiiwiipʉ́ sããjeara, wĩmagʉ̃rẽ, cʉ̃ʉ̃ paco Maríamena niigʉ̃́rẽ ĩñayira. Ñicãcoberimena jeacũmu, cʉ̃ʉ̃rẽ padeoyíra. Too síro cʉ̃́ã néewaretibarire pã́õ, cʉ̃ʉ̃rẽ oro, sĩĩpẽbiro bauré sitiaãñúre, teero biiri apeyé sitiaãñúrecãrẽ “mirra” wãmecʉtirere ticoyira. ");
INSERT INTO tue_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Too síro Cõãmacʉ̃ cʉ̃́ãrẽ quẽẽrṍpʉre “Herodere ĩñarã cãmepʉtʉ́arijãña” jĩĩyigʉ. Teero tiirá, cʉ̃́ãya ditapʉ pʉtʉawara, apemapé pʉtʉajõãyira sáa. ");
INSERT INTO tue_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Masĩrí basoca pʉtʉawari siro, ángele quẽẽrṍpʉ Joseré jĩĩyigʉ sũcã: —Wãcãñá. Wĩmagʉ̃rẽ pacoménarã Egiptopʉ néedutiwaya. Toopʉ́ niijãrã wáaya ména. Yʉʉ “néepʉtʉaatiya” jĩĩrĩpʉ, néepʉtʉaatiwa sũcã. Herodes wĩmagʉ̃rẽ sĩãdʉgágʉ, ãmaãdutigʉdʉ tiii, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, ñamirã wãcã, wĩmagʉ̃rẽ pacoménarã Egiptopʉ néedutiwayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodes catiró põõtẽ́õrõ niiyira toopʉ́re. Cʉ̃́ã teero tiiríguemena Cõãmacʉ̃ jĩĩrirobirora wáaro tiiyíro. Profetare ateré jóadutiyigʉ: “Yʉʉ macʉ̃ Egiptopʉ niimirigʉre sʉowitíwʉ”, jĩĩ jóadutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Too síro Herodes “masĩrí basoca yʉʉre jĩĩditojãya” jĩĩ, bayiró cúayigʉ. Teero tiigʉ́, ʉ̃mʉã́ wĩmarãrẽ Belénpʉ niirã́rẽ, tiimacã wesapʉ niirã́cãrẽ pʉacʉ̃má dʉaró cʉoráre sĩãcõã́petidutiyigʉ. Masĩrí basoca cʉ̃ʉ̃rẽ wederirobirora “nocõrõrã bʉcʉáqui” jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cʉ̃ʉ̃ teero tiidutíriguemena profeta Jeremías jóare diamacʉ̃́ wáaro tiiyíro. Ateré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá macãpʉre basocá booritua, bayiró utiri tʉonóyira. Raquel pãrãmérã niinʉnʉsera numiãpʉ cʉ̃́ã põnarẽ bayiró utiyira. Cʉ̃́ã põnarẽ sĩãrĩ́ ĩñarã, “wãcũtutuaya” jĩĩrĩ booríyira, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes diari, José Egiptopʉra niiyigʉ ména. Toopʉ́ ángele quẽẽrṍpʉ cʉ̃ʉ̃rẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wãcãñá. Wĩmagʉ̃rẽ pacoménarã Israel ditapʉ néepʉtʉawaya. Wĩmagʉ̃rẽ sĩãdʉgámirira diapetijõãwã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, wãcã, wĩmagʉ̃rẽ pacoménarã néepʉtʉaatiyigʉ Israel ditapʉ. ");
INSERT INTO tue_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodes macʉ̃ Arquelao cʉ̃ʉ̃ pacʉre Judea dita õpʉ̃ wasoyígʉ. José tee quetire tʉogʉ́, cuiyigʉ. Judeapʉre wáadʉgariyigʉ. Cõãmacʉ̃ quẽẽrṍpʉ wedenorigʉ niijĩgʉ̃, Galilea ditare netõjṍãyigʉ sáa. ");
INSERT INTO tue_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Toopʉ́ jeagʉ, Nazaret macãpʉ niigʉ̃ wáayigʉ. Jesús toopʉ́ niiriguemena profetas jóare diamacʉ̃́ wáaro tiiyíro. Ateré jóarira niiwã: “Basocá cʉ̃ʉ̃rẽ ‘Nazaret macʉ̃ niiĩ’ jĩĩãdacua”, jĩĩ jóarira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Teebʉrecorire Juan basocáre wãmeõtiri basocʉ Judea ditapʉ basocá manirṍpʉ wáayigʉ. Toopʉ́ basocá cʉ̃ʉ̃ pʉtopʉ jearáre wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ateré jĩĩyigʉ: —Cõãmacʉ̃ dutiré marĩpʉre niiãdare jeaadaropʉ tiia. Teero tiirá, mʉ́ã ñañaré tiirére wãcũpati, wasoyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Profeta Isaías Juan tiiádarere jóarigʉ niiwĩ: Sĩcʉ̃ yucʉ manirṍ, basocá manirṍpʉ bayiró bʉsʉrómena wedegʉdaqui: “Sĩcʉ̃ õpʉ̃ atiadarimarẽ quẽnarõ tiiróbiro, marĩ Õpʉ̃ atiadari sʉguero, mʉ́ã ñañaré tiirére duujã́, ãñurõ niiyueya”, jĩĩgʉ̃daqui, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanyáro sutiró camello póarimena tiiríro niiyiro; cʉ̃ʉ̃ siatúrida wáicʉ caseroda niiyiro. Cʉ̃ʉ̃ yaaré yeseroa, macãnʉcʉ̃ macãrã mumiãoco niiyiro. ");
INSERT INTO tue_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén macãrã, paʉ Judea dita macãrã, teero biiri paʉ día Jordán wesa macãrã cʉ̃ʉ̃ wederi tʉorá wáayira. ");
INSERT INTO tue_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cʉ̃́ã ñañaré tiirére wedenetõãri siro, día Jordánpʉ cʉ̃́ãrẽ wãmeõtiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Paʉ fariseo basoca, saduceo basoca wãmeõtidutira jeari ĩñagʉ̃, cʉ̃́ãrẽ jĩĩyigʉ: —¡Mʉ́ã tiiditórepira, jĩĩditorepira niiã! “Marĩ wãmeõtinorira dícʉ niirĩ, Cõãmacʉ̃ bayiró cúare marĩrẽ jearicu”, jĩĩ wãcũremena atimiãjĩyu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diamacʉ̃́rã mʉ́ã ñañaré tiirére wãcũpati, wasorá, mʉ́ã ãñurõ tiirécʉtiremena ẽñoñá. ");
INSERT INTO tue_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Ʉ̃sã Abraham pãrãmerã niinʉnʉsera niijĩrã, Cõãmacʉ̃ ĩñacorore ãñurã́ niiã”, jĩĩ wãcũrijãña. Mʉ́ã wãcũrére wasohéri, Abraham pãrãmerã niiré wapamaníã. Cõãmacʉ̃ boogʉ́, ate ʉ̃tãperimenarã Abraham pãrãmerãrã cotowéomasĩqui. ");
INSERT INTO tue_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mʉ́ã ñañaré tiidúheri ĩñagʉ̃, Cõãmacʉ̃ mʉ́ãrẽ cõãgʉ̃daqui. Sicagʉ́ yucʉgʉ ñañaré dʉcacʉtirigʉre cõmeãmena nʉcõrĩmenapʉra páata, pecamepʉ sóecõãrõ tiiróbiro mʉ́ãrẽ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Ñañaré tiirére wãcũpati, wasoríguere ẽñorã́rẽ wãmeõtia ocoména. Ãpĩ yʉʉ siro atiqui. Cʉ̃ʉ̃ yʉʉ nemorṍ tutuagʉ niiqui. Cʉ̃ʉ̃ ãñunetõgʉ̃ niiqui. Yʉʉpeja cʉ̃ʉ̃rẽ sĩcãrĩbíridojãcu. Cʉ̃ʉ̃peja nemorṍ ãñurõ tiigʉ́daqui mʉ́ãrẽ: Espíritu Santore ticodiocogʉdaqui, mʉ́ãmena niirucujããrõ jĩĩgʉ̃. Ñañarére sóecõãrõ tiiróbiro mʉ́ã ñañaré tiirére cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cʉ̃ʉ̃ trigore ĩñanogʉ̃dʉ tiiróbiro niiĩ. Teeperire merẽã, teesatirire merẽã cṹũgʉ̃daqui. Teeperire ĩñanogʉ̃daqui cʉ̃ʉ̃ye ĩñanori wiipʉ. Teesatirire sóejãgʉ̃daqui pecame yatiherimepʉ, jĩĩyigʉ Juan. ");
INSERT INTO tue_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Too síro Jesús Galileapʉ niiãrigʉ día Jordánpʉ atiyigʉ Juan pʉtopʉ. Cʉ̃ʉ̃rẽ wãmeõtidutigʉ atiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanpe boorímiyigʉ. Cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉpe yʉʉre wãmeõtigʉno niiã. ¿Deero tiigʉ́ “wãmeõtiya yʉʉre” jĩĩĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús yʉʉyigʉ: —Teero tiijã́ña ména. Niipetire Cõãmacʉ̃ marĩrẽ tiidutírobirora tiiró booa, jĩĩyigʉ. Juan “jáʉ” jĩĩ, cʉ̃ʉ̃rẽ wãmeõtiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wãmeõtitoaari siro, Jesús maajeánʉcãyigʉ. Wãcũña manirṍ ʉ̃mʉã́se pã́õjõãyiro. Jesús Espíritu Santo sĩcʉ̃ bua tiiróbiro baugʉ́ diiátiri ĩñayigʉ. Cʉ̃ʉ̃pʉre jeapeayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Teero wáari, ʉ̃mʉã́sepʉ wedeseri tʉoyíra: —Ãni yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́ niiĩ. Cʉ̃ʉ̃mena bayiró ʉseniã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Too síro Espíritu Santo Jesuré basocá manirṍpʉ néewanetõyigʉ, wãtĩãrẽ dutigʉ́ jĩĩcõãsããrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Toopʉ́re cuarenta bʉrecori, cuarenta ñamirĩ́ yaariyigʉ. Too síro jʉabóayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wãtĩãrẽ dutigʉ́ Jesús pʉto wáa, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉ Cõãmacʉ̃ macʉ̃ niigʉ̃, atepá ʉ̃tãpáre pã cotowéoya, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cʉ̃ʉ̃pe yʉʉyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Yaaré dícʉ basocáre catiri tiiría. Niipetire Cõãmacʉ̃ye wedeserecã cʉ̃́ãrẽ catiri tiia”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Too síro wãtĩãrẽ dutigʉ́ cʉ̃ʉ̃rẽ Jerusalénpʉ “Cõãmacʉ̃ya macã” cʉ̃́ã jĩĩrí macãpʉ néewayigʉ. Toopʉ́re Cõãmacʉ̃wii sotoapʉ néemʉã, ");
INSERT INTO tue_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","cʉ̃ʉ̃rẽ jĩĩmiyigʉ: —Mʉʉ Cõãmacʉ̃ macʉ̃ niigʉ̃, ãnopʉ́mena bupudíaya. Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: Cõãmacʉ̃ cʉ̃ʉ̃yara ángeleare mʉʉrẽ cotedutigʉdaqui. Mʉʉrẽ ʉ̃tãgãpʉ ñaapeari jĩĩrã, bocañeãdacua, jĩĩ jóarigue niiã, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Cõãmacʉ̃ mʉʉ Õpʉ̃ wedeserere ‘¿diamacʉ̃́rã niimiĩto?’ jĩĩrã, cʉ̃ʉ̃rẽ tiiẽ́ñodutirijãña”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Too síro ʉ̃tãgʉ̃́ ʉ̃mʉã́netõrigʉpʉ néemʉãyigʉ sũcã. Toopʉ́ niipetire atibʉ́reco maquẽ macãrĩrẽ́, teero biiri teemacãrĩ cʉorére ẽñopetíjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Cʉ̃ʉ̃rẽ jĩĩmiyigʉ: —Mʉʉ yʉʉre ñicãcoberimena jeacũmu, “mʉʉ yʉʉ õpʉ̃ niiã” jĩĩ padeorí, ate niipetire mʉʉrẽ ticogʉda, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Wáagʉa, Satanás. Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Cõãmacʉ̃ mʉʉ Õpʉ̃ sĩcʉ̃rẽna padeoyá. Cʉ̃ʉ̃ dutiré dícʉre tiiyá”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wãtĩãrẽ dutigʉ́ wáajõãyigʉ. Ángelea Jesuré tiiápura jeayira. ");
INSERT INTO tue_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús “Juanrẽ́ peresu sõnecoayira” jĩĩrére tʉoyígʉ. Teero tiigʉ́, Galilea ditapʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret macãrẽ netõwá, Capernaumpe niigʉ̃ wáayigʉ. Capernaum Galileataro wesa, Zabulónya dita, teero biiri Neftalíya dita wesapʉ niiã. ");
INSERT INTO tue_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cʉ̃ʉ̃ toopʉ́ wáari, profeta Isaías jóarirobirora wáaro tiiyíro. Ateré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón, teero biiri Neftalícãya dita macãrã, día pairímaa wesa macãrã, día Jordán apeniñapʉ́ macãrã, teero biiri Galilea dita macãrã judíoa niihẽrã ");
INSERT INTO tue_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mʉ́ã naĩtĩãrõpʉ niirã́biro Cõãmacʉ̃yere tʉomasĩ́ricu; ãñurõ bóere ĩñarã́ tiiróbiro mʉ́ãrẽ netõnégʉ̃dʉre ĩñaãdacu. Diarira tiiróbiro niirã́ bóaneõrã niicu; mʉ́ã bóebatere ĩñarã́ tiiróbiro cʉ̃ʉ̃rẽ ĩñarã, ʉseniãdacu, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús toopʉ́ jeagʉ, basocáre buenʉcãyigʉ. “Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare jeaadaropʉ tiia. Teero tiirá, mʉ́ã ñañaré tiirére wãcũpati, wasoyá”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galileataro wesapʉ wáayigʉ. Toopʉ́ wáagʉ, sĩcʉ̃põna pʉarã́rẽ bʉajeáyigʉ. Simón, apetóre Pedro sʉonógʉ̃, cʉ̃ʉ̃ bai Andrés niiyira. Wai wasarí basoca niijĩrã, bapigʉ cõãño, wai wasara tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús jĩĩyigʉ cʉ̃́ãrẽ: —Jãmʉ yʉʉmena. Mʉ́ã mecʉ̃tígãrẽ wai wasarí basoca niiã; too síropʉre mʉ́ã basocáre yée quetire ãñurõ wederí basoca wáaadacu sáa. Teeré wederi, paʉ padeoádacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Teeré tʉorá, máata cʉ̃́ãye bapiyucʉre toorá cṹũjã, Jesuména wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Too netõwá, ãpẽrã́ pʉarã́ sĩcʉ̃põnarẽ ĩñayigʉ. Zebedeo põna Santiago, cʉ̃ʉ̃ bai Juan niiyira. Cʉ̃́ã pacʉmena dooríwʉpʉ bapiyucʉre jeesãñáyira. Jesús cʉ̃́ãcãrẽ “jãmʉ” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, máata tiiwʉré, cʉ̃́ã pacʉre cṹũ, wáajõãyira Jesuména. ");
INSERT INTO tue_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús niipetiro Galilea ditapʉ judíoa neãré wiseripʉ buewarucuyigʉ. Ãñuré queti “Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare jeaadaro tiia” jĩĩrére wedeyigʉ. Niipetire cʉ̃́ã diarecʉtire, cʉ̃́ãrẽ õpʉ̃ʉ̃rĩ pũniré netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cʉ̃ʉ̃ teero tiiré quetire niipetira Siria dita macãrã masĩpetijõãyira. Teero tiirá, niipetira diarecʉtirare cʉ̃ʉ̃ pʉtopʉ néewayira. Ãpẽrã́ merẽã biiré diarecʉtira, ãpẽrã́ õpʉ̃ʉ̃rĩ pũniré cʉoráre néewayira. Wãtĩã sããnorirare, ñamadiare cʉoráre, wáamasĩhẽrãrẽ néewayira. Jesús cʉ̃́ãrẽ netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Paʉ Galilea dita macãrã, Decápolis macãrĩ macãrã, Jerusalén macãrã, Judea dita macãrã, día Jordán apeniñapʉ́ macãrã cʉ̃ʉ̃rẽ nʉnʉyíra. ");
INSERT INTO tue_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús paʉ nʉnʉrĩ́ ĩñagʉ̃, ʉ̃tãgʉ̃pʉ́ mʉãwawi. Toopʉ́ cʉ̃ʉ̃ jeanuãrĩ, ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto neãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ateré buewi: ");
INSERT INTO tue_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—“Cõãmacʉ̃ tiiápuremena dícʉ cʉ̃ʉ̃ booré tiimasĩ́ã” jĩĩrã́no ʉseniya. Cõãmacʉ̃ dutiré cʉ̃́ãpʉre jeatoaa. ");
INSERT INTO tue_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Bóaneõrãno ʉseniya. Cõãmacʉ̃ cʉ̃́ãrẽ yeeripũnapʉ ʉsenire ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’“Ʉ̃sã ãpẽrã́ nemorṍ ʉpʉtí macãrã niiã” jĩĩ wãcũhẽrãno ʉseniya. Cʉ̃́ã Cõãmacʉ̃ “ticogʉda” jĩĩri ditare ñeeãdacua. ");
INSERT INTO tue_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Diamacʉ̃́ maquẽ, teero biiri ãñurére bayiró tiidʉgárano ʉseniya. Cõãmacʉ̃ tiiápuremena cʉ̃ʉ̃ boorére tiimasĩ́ãdacua. ");
INSERT INTO tue_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ãpẽrãrẽ́ bóaneõ ĩñarã́no ʉseniya. Cõãmacʉ̃ cʉ̃́ãrẽ bóaneõ ĩñagʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ãñuré wãcũ tʉgueñarãno ʉseniya. Cʉ̃́ã Cõãmacʉ̃rẽ ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ãñurõ niirecʉtire wáari tiiráno ʉseniya. Cõãmacʉ̃ cʉ̃́ãrẽ “yʉʉ põna niiĩya” jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Cʉ̃́ã Cõãmacʉ̃ boorére tiiré wapa ãpẽrã́ ñañarõ netõrĩ́ tiinórãno ʉseniya. Cõãmacʉ̃ dutiré cʉ̃́ãpʉre jeatoaa. ");
INSERT INTO tue_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Mʉ́ã yʉʉre padeoré wapa ãpẽrã́ mʉ́ãrẽ ñañarõ jĩĩ, ñañarõ netõrĩ́ tiiádacua. Noo ñañarõ niiré jĩĩditoadacua mʉ́ãrẽ. Cʉ̃́ã teero tiirí, mʉ́ã ʉseniãdacu. ");
INSERT INTO tue_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Too síropʉre mʉ́ã ʉ̃mʉã́sepʉ pairó wapatáre bʉaádacu. Teero tiirá, bayiró ʉseniña. Mʉ́ãrẽ tiiróbirora ñañarõ tiiáperucuyira mʉ́ã sʉguero niiriracãrẽ profetare. ");
INSERT INTO tue_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Marĩ yaaré poaaro jĩĩrã, móãrẽ sã́ãã. Mʉ́ã móãbiro niiã atibʉ́recopʉre. Móã ocare petirí, ocanemorĩ tiimasĩ́ña manicú. Tee deero tiiádare mee niicu. Teero tiirá, teeré sopepʉtópʉ cõãjãcu. Basocá cʉtadiyócua. ");
INSERT INTO tue_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Mʉ́ã sĩãwócore tiiróbiro niiã atibʉ́recopʉre. Sicamacã ʉ̃tãgʉ̃́ sotoapʉ niirí macãrẽ yayiómasĩña manicú. ");
INSERT INTO tue_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Basocá sĩãwócorigare sĩãã́ri siro, moocṹriya. Teero tiiróno tiirá, ʉ̃mʉã́rõpe péoya, niipetira tiiwiipʉ́ niirã́rẽ bóebatecoaro jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tiigá sĩãwócorobirora mʉ́ãcã basocá ĩñacoropʉre ãñurõ tiirécʉtiya. Mʉ́ã ãñurõ tiirí ĩñarã, ãpẽrãcã́ mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́rẽ “ãñunetõjõãgʉ̃ niiqui” jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Biiro wãcũrijãña yʉʉre: “Moisére dutiré cṹũrigue, teero biiri profetas jóariguere cõãgʉ̃ atigʉ tiiájĩyi”, jĩĩ wãcũrijãña. Teeré cõãgʉ̃ mee atiwʉ. Teeré “diamacʉ̃́rã biirope niiã” jĩĩgʉ̃ atiwʉ. ");
INSERT INTO tue_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ʉ̃mʉã́se, atibʉ́reco niiritabere Cõãmacʉ̃ péerogã tee dutirére cõãriqui. Niipetire cʉ̃ʉ̃ “biiro wáaadacu” jĩĩrigue diamacʉ̃́ wáaro tiiádacu. ");
INSERT INTO tue_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tee dutirére péerogã netõnʉcã́gʉ̃no bʉ́ri niigʉ̃́ niigʉ̃daqui Cõãmacʉ̃ Õpʉ̃ niirṍpʉre. Ãpẽrãrẽ́ netõnʉcã́rĩ tiigʉ́nocã teerora biigʉdaqui. Ãpĩ tee dutirére diamacʉ̃́ tiigʉ́nope, ãpẽrãrẽ́ teeré tiidutígʉnope õpʉ̃ tiiróbiro niigʉ̃daqui Cõãmacʉ̃ Õpʉ̃ niirṍpʉre. ");
INSERT INTO tue_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉ́ãrẽ ate wedea: Moisés jóarigue buerá, teero biiri fariseo basoca “ʉ̃sã Cõãmacʉ̃ boorére ãñurõ tiia” jĩĩmiya. Mʉ́ã cʉ̃́ã nemorṍ Cõãmacʉ̃ boorépere tiihéra, Cõãmacʉ̃ pʉtopʉ wáaricu. ");
INSERT INTO tue_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Tʉojĩ́yu mʉ́ã ñecʉ̃sʉ̃mʉãrẽ wederiguere: “Basocáre sĩãríjãña. Sĩãgʉ̃́no queti beserí basocʉ pʉtopʉ néewa, wedesãnogʉ̃daqui”. ");
INSERT INTO tue_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉʉpeja mʉ́ãrẽ ateré wedea: Cʉ̃ʉ̃ya wedegʉmena cúagʉno besegʉ́ pʉtopʉ néewa, wedesãnogʉ̃daqui. Cʉ̃ʉ̃ya wedegʉre “mʉʉ wapamanígʉ̃ niiã” jĩĩ buijã́gʉ̃no Judíoare Dutirá Peti pʉtopʉ néewa, wedesãnogʉ̃daqui. Cʉ̃ʉ̃ya wedegʉre “wáicʉ tiiróbiro wãcũré cʉoa mʉʉjã” jĩĩgʉ̃́norẽ pecamepʉ sóecõãrĩquio niiã. ");
INSERT INTO tue_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Teero tiigʉ́, mʉʉ Cõãmacʉ̃wiipʉ Cõãmacʉ̃rẽ padeogʉ́, apeyenó ticogʉdʉ tiicú. Ticoadari sʉguerogã, wãcũbʉacu: “Yáa wedegʉ cúa niiqui yʉʉmena; yʉʉ cʉ̃ʉ̃rẽ ñañarõ tiiátʉ”, jĩĩ wãcũcu. ");
INSERT INTO tue_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mʉʉ ticoadarere duupéo, cʉ̃ʉ̃rẽ acabóre sãĩsʉguégʉ wáaya. Teero tiiári siro, “Cõãmacʉ̃rẽ ticogʉda” jĩĩãriguere ticoya sáa. ");
INSERT INTO tue_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Mʉʉrẽ wedesãrigʉmena queti beserópʉ wáarara, boyeromena quẽnosʉguéya. Quẽnosʉguéheri, mʉʉrẽ besegʉ́pʉre ticojãgʉ̃daqui. Cʉ̃ʉ̃ surarapʉre ticojãgʉ̃daqui sáa. Cʉ̃́ãpʉra peresuwiipʉ sõnecoadacua sáa. ");
INSERT INTO tue_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yʉʉ mʉʉrẽ ateréja diamacʉ̃́rã jĩĩã: Mʉʉ wapatípetihegʉ, witiricu, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús wedenemowĩ: —Mʉ́ã ate wederiguere tʉojĩ́yu: “Ãpĩ nʉmorẽ ñeeaperijãña”. ");
INSERT INTO tue_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉʉpeja ateré diamacʉ̃́rã jĩĩã: Sĩcʉ̃ numiṍrẽ ñañaré tiidʉgáremena ĩñagʉ̃́no cʉ̃ʉ̃ wãcũrémenarã coomena ñañarõ tiiárigʉbiro niitoaqui. ");
INSERT INTO tue_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Diamacʉ̃́ macã capea ĩñaré mʉ́ãrẽ ñañarére tiirí tiibócu. Teero wáari, tiigaré odewecõãjãña. Teero tiiró, sicaróra mʉ́ãya õpʉ̃ʉ̃ macãrõ cõõrĩ́, ãñujãã. Niipetiri õpʉ̃ʉ̃ pecamepʉ cõõrĩ́peja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Diamacʉ̃́ macã wãmo mʉ́ãrẽ ñañarére tiirí tiibócu. Teero wáari, tiiwãmorẽ páatacõãjãña. Teero tiiró, sicaróra mʉ́ãya õpʉ̃ʉ̃ macãrõ cõõrĩ́, ãñujãã. Niipetiri õpʉ̃ʉ̃ pecamepʉ cõõrĩ́peja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Mʉ́ã atecã́rẽ tʉojĩ́yu: “Nʉmorẽ́ cõãgʉ̃, ‘atewapá mʉʉrẽ cõãã’ jĩĩrípũrẽ jóa, coore ticoro booa”. ");
INSERT INTO tue_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉʉpeja ateré diamacʉ̃́rã jĩĩã: Sĩcʉ̃ cʉ̃ʉ̃ nʉmo ãpĩména ñeeaperipacari, coore cõãgʉ̃, coore ʉ̃mʉã́mena ñeeapearigo tiiróbiro pʉtʉári tiiquí. Sĩcʉ̃ cõãnorigomena nʉmocʉtigʉcã ãpĩ nʉmoména ñañarõ ñeeapegʉ tiiróbiro pʉtʉáqui. ");
INSERT INTO tue_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Tʉojĩ́yu sũcã mʉ́ã ñecʉ̃sʉ̃mʉãrẽ wederiguere: “Mʉʉ ‘Cõãmacʉ̃ wãmemena tiigʉ́da’ jĩĩrirobirora jĩĩditoro manirṍ tiiyá”. ");
INSERT INTO tue_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉʉpeja ateré diamacʉ̃́rã jĩĩã: Mʉ́ã ãpẽrãrẽ́ “teerora tiigʉ́da” jĩĩrã, Cõãmacʉ̃ wãmemena jĩĩrijãña. “Ʉ̃mʉã́semena diamacʉ̃́rã jĩĩã”, jĩĩrijãña. Ʉ̃mʉã́sepʉ Cõãmacʉ̃ dutiduiqui. ");
INSERT INTO tue_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Atibʉ́recomena diamacʉ̃́rã jĩĩã”, jĩĩrijãña. Atibʉ́recocã Cõãmacʉ̃ye dʉpori pesaró tiiróbiro niirõ tiia. “Jerusalénmenacãrẽ diamacʉ̃́rã jĩĩã”, jĩĩrijãña. Tiimacãcã marĩ Õpʉ̃ tutuagʉya macã niiã. ");
INSERT INTO tue_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yáa dupumena diamacʉ̃́rã jĩĩã”, jĩĩrijãña. Mʉ́ã teero jĩĩrémena sicadá póadare ñíirida o butirída wáari tiimasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mʉ́ã tiiádara, “teerora tiiáda” jĩĩña; tiiríadara, “tiirícu” jĩĩjãña. Mʉ́ã jĩĩnemocorepʉja wãtĩ wãcũré niibocu. ");
INSERT INTO tue_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Mʉ́ã ate wederiguere tʉojĩ́yu: “Sĩcʉ̃ mʉʉrẽ capea páawari, mʉʉcã teerora cʉ̃ʉ̃rẽ páawacãmeña. Upire páaperi, teerora cʉ̃ʉ̃rẽ páapecãmeña”. ");
INSERT INTO tue_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉʉpeja ateré diamacʉ̃́rã jĩĩã: Mʉʉrẽ ñañarõ tiigʉ́norẽ teero ĩñajãña. Cãmeríjãña. Sĩcʉ̃ mʉʉrẽ wasopúro diamacʉ̃́pere páari, apeniñapécãrẽ páaaro. ");
INSERT INTO tue_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sĩcʉ̃ mʉʉrẽ queti beserí basocʉ pʉtopʉ néewa, besegʉ́re “cʉ̃ʉ̃ yʉʉre ñañarõ tiirígue wapa cʉ̃ʉ̃yaro camisare ticodutiya” jĩĩboqui. Cʉ̃ʉ̃ teero jĩĩrĩ, sotoá macãrõ mʉʉ sãñarṍcãrẽ ticojãña, tooré cʉ̃ʉ̃ booátã. ");
INSERT INTO tue_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Surara apeyenórẽ sicaburo mʉʉrẽ néewadutiri, apeburó néewabosanemoña sũcã. ");
INSERT INTO tue_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉʉrẽ sãĩgʉ̃́norẽ ticoya. Apeyenórẽ mʉʉrẽ wasodʉgari, “wasoria” jĩĩrijãña. ");
INSERT INTO tue_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Mʉ́ã ate wederiguere tʉojĩ́yu: “Mʉʉ menamacãrãrẽ maĩñá; mʉʉrẽ ĩñatutirapere ĩñatuti doocãméña”. ");
INSERT INTO tue_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉʉpeja ateré diamacʉ̃́rã jĩĩã: Mʉ́ãrẽ ĩñatutirare maĩñá. Mʉ́ãrẽ ñañarõ tiiráre Cõãmacʉ̃rẽ sãĩbosáya. ");
INSERT INTO tue_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mʉ́ã teero tiirá, mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ põna niiãdacu. Cʉ̃ʉ̃ ãñurã́ pʉtopʉ, teero biiri ñañarã́ pʉtopʉcãrẽ muĩpũ bóeri tiii. Cʉ̃ʉ̃ booré tiirá pʉtopʉ, teero biiri cʉ̃ʉ̃ booré tiihéra pʉtopʉcãrẽ oco peari tiii. ");
INSERT INTO tue_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉ́ãrẽ maĩrã́ dícʉre maĩrĩ́, wapamaníã. Romanuã õpʉ̃rẽ niyeru wapasébosari basoca teeré tiiíya. ");
INSERT INTO tue_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉ́ãya wedera dícʉre ãñurõ tiirá, ¿ñeenó ãñunemore ãpẽrãrẽ́ tiiẽ́ñogari? Cõãmacʉ̃rẽ masĩhẽrã teeré tiiíya. ");
INSERT INTO tue_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ ãñuré tiirécʉtigʉ tiiróbirora ãñuré tiirécʉtira niiña. ");
INSERT INTO tue_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Mʉ́ã Cõãmacʉ̃ye ãñurére tiirá, basocá ĩñacoropʉ dícʉ tiiẽ́ñorijãña. Mʉ́ã teero tiirécʉtiri, mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ mʉ́ã ãñuré tiiré wapa ticorénorẽ ticoriqui. ");
INSERT INTO tue_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Teero tiirá, mʉ́ã bóaneõrãrẽ tiiápura, máata ãpĩrẽ́ bayiró bʉsʉrómena mʉʉ tiiápuariguere wedebatedutirijãña. Tiiditórepira teenórẽ tiirécʉticua mʉ́ã neãré wiseripʉre, teero biiri macã decopʉre. Cʉ̃́ã tiiápucua, ãpẽrã́ “ãñuniĩ” jĩĩãrõ jĩĩrã. Yʉʉ mʉ́ãrẽ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃́ã basocá teero jĩĩré wapa wapatápetitoaya mée. ");
INSERT INTO tue_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉ́ãpe bóaneõrãrẽ tiiápuara, mʉ́ã menamacãrãrẽ wedebaterijãña. ");
INSERT INTO tue_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ticora, ĩñahẽrõpʉ ticoya. Mʉ́ã Pacʉ mʉ́ã ĩñahẽrõpʉ tiirénorẽ ĩñagʉ̃́ mʉ́ã ãñurõ tiiári siro, wapatáre ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Mʉ́ã Cõãmacʉ̃rẽ sãĩrã́, tiiditórepira tiiróbiro tiiríjãña. Cʉ̃́ã neãré wiseripʉ, macã decopʉ nucũ, basocá ĩñaãrõ jĩĩrã, sãĩcúa. Yʉʉ mʉ́ãrẽ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃́ã basocá teero ĩñaré wapa wapatápetitoaya mée. ");
INSERT INTO tue_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉ́ãpe Cõãmacʉ̃ mʉ́ã Pacʉre sãĩrã́, mʉ́ãye sawiripʉ sããwa, soperé biajã́, cʉ̃ʉ̃rẽ sãĩñá. Cʉ̃ʉ̃ ĩñabʉaya manigʉ̃́ niipacʉ, mʉ́ãmena niiqui. Cʉ̃ʉ̃ mʉ́ã ĩñahẽrõpʉ tiirénorẽ ĩñagʉ̃́ mʉ́ã ãñurõ tiiári siro, wapatáre ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cõãmacʉ̃rẽ sãĩrã́, ãñurõ wãcũripacara, sãĩnemósãrijãña. Cõãmacʉ̃rẽ masĩhẽrã teero tiicúa, “marĩrẽ pee wedeseremena tʉogʉ́daqui” jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mʉ́ãjã cʉ̃́ã tiiróbiro tiiríjãña. Mʉ́ã Pacʉ mʉ́ã boorénorẽ sãĩã́dari sʉguero, masĩtoaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Teero tiirá, biiro jĩĩ sãĩñá: Ʉ̃sã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́, mʉʉrẽ quioníremena padeoáda. ");
INSERT INTO tue_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mʉʉ dutiré ʉ̃sãpʉre niiãdare jeaaro. Ʉ̃mʉã́se macãrã mʉʉ booré dícʉre tiicúa; atibʉ́reco macãrãcã teerora tiiáro. ");
INSERT INTO tue_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉ̃sãrẽ bʉ́recoricõrõ yaaré ticoya. ");
INSERT INTO tue_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ãpẽrã́ ʉ̃sãrẽ ñañarõ tiiráre ʉ̃sã acabórobirora mʉʉcã ʉ̃sã ñañaré tiirére acabóya. ");
INSERT INTO tue_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jĩĩcõãsãrenorẽ cãmotáya. Ʉ̃sãrẽ ñañarõ wáari jĩĩgʉ̃, netõnéña. Mʉʉ sĩcʉ̃rã dutirucugʉdacu. Tutuanetõjõãgʉ̃ niiã. Mʉʉ sĩcʉ̃rã ʉsenipeogʉno niirucujãña. Teerora niiãrõ. ");
INSERT INTO tue_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ãpẽrã́ mʉ́ãrẽ ñañarõ tiirére acabóri, mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́cã mʉ́ãrẽ acabógʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mʉ́ã cʉ̃́ã ñañarõ tiirére acabóheri, mʉ́ã Pacʉcã mʉ́ã ñañaré tiirére acabóriqui. ");
INSERT INTO tue_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Mʉ́ã beti, sãĩrã́, tiiditórepira tiiróbiro tiiríjãña. Cʉ̃́ã wãcũpatirabiro baujã́cua. Jʉabóarabiro baurá wáanetõjãcua, basocá cʉ̃́ã betirére ĩñaãrõ jĩĩrã. Yʉʉ mʉ́ãrẽ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃́ã basocá teero ĩñaré wapa wapatápetitoaya mée. ");
INSERT INTO tue_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉ́ãpe beti, sãĩrã́, diapóa waacosé, ãñurõ wʉapoarira niiña, ");
INSERT INTO tue_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ãpẽrã́ mʉ́ã betirére masĩrijããrõ jĩĩrã. Mʉ́ã Pacʉ ĩñabʉaya manigʉ̃́ niipacʉ, mʉ́ãmena niiqui. Cʉ̃ʉ̃ mʉ́ã ĩñahẽrõpʉ tiirénorẽ ĩñagʉ̃́ mʉ́ã ãñurõ tiiári siro, wapatáre ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Atiditá maquẽrẽ pee néõcũrijãña. Teeré butua yaacua; cʉtawi bóajõãcu; yaarépira sããwa, yaapetíjãcua. ");
INSERT INTO tue_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Teero tiiróno tiirá, ʉ̃mʉã́sepʉ ãñuré bʉarí tiiádarepere néõcũyueya Cõãmacʉ̃ booré tiirucúremena. Teero tiirá, toopʉ́re pee ãñuré cʉoádacu. Toopʉ́re mʉ́ã néõcũrere butua tʉ́amasĩricua; cʉtawiricu; yaarépira sããwa, yaarícua. ");
INSERT INTO tue_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ʉ̃mʉã́sepʉ mʉ́ãye niirĩ, Cõãmacʉ̃ye dícʉre wãcũãdacu. ");
INSERT INTO tue_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mʉ́ãye capeari õpʉ̃ʉ̃rĩrẽ sĩãwócoriga tiiróbiro niiã. Mʉ́ã capeari ãñurĩ, ãñurõ ĩñaãdacu; ãñurõ tʉomasĩ́ãdacu; ñañaãtã, ĩñaricu; tʉomasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mʉ́ã ñañaré capeari cʉorá tiiróbiro niirĩ, mʉ́ãye õpʉ̃ʉ̃rĩpʉre naĩtĩãrõ tiiróbiro niiã. Cõãmacʉ̃yere masĩria. Tee naĩtĩãre ñañanetõjõãã. ");
INSERT INTO tue_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Sĩcʉ̃ pʉarã́rẽ padecotemasĩriqui. Sĩcʉ̃rẽ maĩríqui; ãpĩpére maĩquí. Sĩcʉ̃rẽ padeoquí; ãpĩpére netõnʉcã́qui. Mʉ́ã niyerure maĩrã́, Cõãmacʉ̃pere maĩrícu. ");
INSERT INTO tue_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Teero tiigʉ́, mʉ́ãrẽ ateré wedea: Mʉ́ã niirecʉtirere wãcũpatirijãña. “¿Ñeenó yaaadari; ñeenó sĩniã́dari; ñeenó sãñaãdari marĩ?” jĩĩ wãcũpatirijãña. Marĩ catirépe yaaré nemorṍ wapacʉtía. Marĩye õpʉ̃ʉ̃rĩpe suti nemorṍ wapacʉtía. ");
INSERT INTO tue_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minipõnárẽ ĩñañate mʉ́ã. Cʉ̃́ã oteriya. Oteré dʉca seeríya. Teedʉcare ĩñanore wiseripʉ ĩñanoriya. Teero tiirípacari, mʉ́ã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ cʉ̃́ãrẽ yaaré ticoqui. Mʉ́ãpe minipõná nemorṍ wapacʉtía. ");
INSERT INTO tue_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mʉ́ã bayiró wãcũpatira, bʉcʉánemoricu. ");
INSERT INTO tue_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Deero tiirá mʉ́ã sutipére wãcũpatii? Coori macãnʉcʉ̃ maquẽrẽ wãcũña. Tee booró wiicú. Paderipacaro, suti suaripacaro, suti ãñuré sãñaré tiiróbiro baua. ");
INSERT INTO tue_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Teero biipacari, yʉʉ ateré jĩĩã: Salomón suti ãñuré peti sãñapacʉ, coorire sĩcãrĩbíriyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sicabʉrecora tee catia; apebʉ́reco sĩniã́riguepʉ boea; too síro sóejãnoã. Teero wáapacari, Cõãmacʉ̃ teecorire ãñuré suti sãñarõ tiiróbiro baurí tiii. Mʉ́ãpereja ãñunemorõ cotequi. Mʉ́ã péerogã padeoré cʉorá niiã. ");
INSERT INTO tue_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Teero tiirá, “¿ñeenó yaaadari; ñeenó sĩniã́dari; ñeenó sãñaãdari marĩ?” jĩĩ wãcũpatirijãña. ");
INSERT INTO tue_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Atibʉ́reco macãrã Cõãmacʉ̃rẽ padeohéra tee niipetirere wãcũpatiya. Marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ mʉ́ã boorénorẽ masĩtoai mée. ");
INSERT INTO tue_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mʉ́ãpe Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere boosʉguéya. Teero biiri diamacʉ̃́ cʉ̃ʉ̃ boorére tiinʉnʉ́seya. Teero tiirí, niipetire mʉ́ãrẽ dʉsarére ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Teero tiirá, “¿ñamigãrẽ deero wáamiãdariye?” jĩĩ wãcũpatirijãña. Apebʉ́reco maquẽrẽ mʉ́ã ñañarõ netõã́darere wãcũpatisʉguerijãña. Mecʉ̃ã maquẽ dícʉre wãcũña. Mecʉ̃ãrẽ mʉ́ãrẽ wãcũpatiri tiiádare niitoaa. ");
INSERT INTO tue_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ãpẽrãrẽ́ ĩñabeserijãña. Mʉ́ã ĩñabeseheri, Cõãmacʉ̃cã mʉ́ãrẽ ĩñabeseriqui. ");
INSERT INTO tue_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mʉ́ã ãpẽrãrẽ́ wedepatirirobirora mʉ́ãcã wedepatinoãdacu. Mʉ́ã ãpẽrãrẽ́ pee ñañarõ jĩĩrĩ, queoró mʉ́ãcãrẽ jĩĩnoãdacu. ");
INSERT INTO tue_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mʉʉya wedegʉya capeapʉ pasarí manarõrẽ ĩñaã. Ĩñapacʉ, mʉʉya capeapʉ pasarí dʉcapereja ĩñaria. ");
INSERT INTO tue_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mʉʉya capeapʉ yucʉdʉca pasanopacʉ, ¿deero tiigʉ́ mʉʉya wedegʉre, “mʉʉya capeapʉ pasarí manarõrẽ néecõãma” jĩĩĩ? ");
INSERT INTO tue_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ñañagʉ̃́, tiiditórepigʉ! Mʉʉya capeapʉ niirí dʉcapere néecõãsʉgueya. Cõãtoagʉpʉ, ãñurõ ĩñagʉ̃dacu. Teero tiigʉ́, mʉʉya wedegʉya capeapʉ pasarí manarõrẽ néecõãgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Cõãmacʉ̃rẽ boohéranorẽ cʉ̃ʉ̃ye queti ãñurére wederijãña. Cʉ̃́ãnorẽ wedera, díayiare ãñurére ticora tiiróbiro tiicú. Díayia cúaãmarã ãñuré ticopacari, mʉ́ãrẽ cãmenʉcã́ bacajã́cua. Cõãmacʉ̃rẽ padeodʉgáherare cʉ̃ʉ̃ye ãñuré maquẽrẽ wederijãña. Cʉ̃́ãnorẽ wedera, yesea watoapʉ ñaquẽda wapapacáridare déecũrã tiiróbiro tiicú. Yesea tiidaré cʉtatábatejãcua. Cõãmacʉ̃rẽ boohérare bʉ́ri peti cʉ̃ʉ̃yere wedecu. ");
INSERT INTO tue_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Cõãmacʉ̃rẽ sãĩñá. Sãĩrĩ́, cʉ̃ʉ̃ mʉ́ãrẽ ticogʉdaqui. Ãñurére ãmaãrã tiiróbirora sãĩrucújãña. Sãĩrucújãrã, bʉaádacu. “Sope pã́õña yʉʉre” jĩĩgʉ̃́ tiiróbiro sãĩdúrijãña. Sãĩdúheri, “jáʉ” jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sãĩgʉ̃́no cʉogʉ́daqui. Ãmaãgʉ̃no bʉagʉ́daqui. “Pã́õña” jĩĩgʉ̃́no pã́õnogʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Mʉ́ã põna mʉ́ãrẽ wʉ́abere sãĩrĩ́, cʉ̃́ãrẽ ʉ̃tãpere ticoricu. ");
INSERT INTO tue_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wai sãĩrĩ́, ãñarẽ ticoricu. ");
INSERT INTO tue_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉ́ã ñañaré tiirá niipacara, mʉ́ã põnarẽ ãñurére ticomasĩã. Marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́pe cʉ̃ʉ̃rẽ sãĩrã́norẽ nemorṍ ãñurére ticomasĩqui. ");
INSERT INTO tue_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Mʉ́ã ãpẽrãrẽ́ mʉ́ãrẽ ãñurõ tiirí booa; mʉ́ãcã teerora cʉ̃́ãrẽ ãñurõ tiiyá. Teeré Moisére dutiré cṹũrigue, teero biiri profetas jóarigue tiidutía. ");
INSERT INTO tue_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Esahéri sopegãrẽ sããwaya. Pecamepʉ sããwari sopepe esarí sope niiã; pecamepʉ wáarima esaríma niiã. Toopére paʉ sããwaya. ");
INSERT INTO tue_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Catiré petihéropʉ sããwari sopepeja esahéri sopegã niijãã. Toopʉ́ niijearima esahérima niiã. Sĩquẽrãrã catiré petihére bʉaáya. ");
INSERT INTO tue_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ãpẽrã́ “ʉ̃sã profetas niiã” jĩĩditorare tʉoríjãña. Cʉ̃́ã ãñurã́ tiiróbiro baumíya. Oveja ãñurã́gã tiiróbiro baumíya. Teero baupacára, cʉ̃́ã wãcũrépʉre yáiwa cúaãmarã tiiróbiro wãcũũya. ");
INSERT INTO tue_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mʉ́ã cʉ̃́ãrẽ cʉ̃́ã tiirécʉtiremena ĩñamasĩãdacu. Potagʉ ʉse dʉcacʉtiria. Wĩsõcã ipitire dʉcacʉtiria. ");
INSERT INTO tue_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yucʉgʉ ãñurígʉno ãñuré dʉcacʉtia; sĩniátirigʉno ñañaré dʉcacʉtia. ");
INSERT INTO tue_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ãñurígʉno ñañaré dʉcacʉtiricu; ñañarígʉno ãñuré dʉcacʉtiricu. ");
INSERT INTO tue_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ñañaré dʉcacʉtirigʉno páata, pecamepʉ sóecõãjãnoãdacu. ");
INSERT INTO tue_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Teeré tiiróbirora jĩĩditorepirare cʉ̃́ã tiirécʉtiremena ĩñamasĩãdacu. ");
INSERT INTO tue_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Paʉ yʉʉre “Õpʉ̃” jĩĩpacara, cʉ̃́ã niipetira Cõãmacʉ̃ pʉtopʉ wáaricua. Yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ booré tiiráno dícʉ wáaadacua. ");
INSERT INTO tue_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cõãmacʉ̃ basocáre wapa tiiádari bʉreco jeari, paʉ yʉʉre jĩĩmiãdacua: “Ʉ̃sã Õpʉ̃, mʉʉ wãmemena basocáre buewʉ; mʉʉ wãmemena wãtĩãrẽ cõãwionecowʉ; mʉʉ wãmemena pee ãñuré tiiẽ́ñowʉ̃ sũcã”, jĩĩmiãdacua. ");
INSERT INTO tue_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cʉ̃́ã teero jĩĩpacari, “mʉ́ãrẽ masĩria yʉʉja” jĩĩgʉ̃dacu. “¡Mʉ́ã ñañaré tiiríra niiã; witiwaya!” jĩĩgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Teero tiigʉ́, yʉʉ wederére tʉo, yʉʉ wederirobiro tiigʉ́no masĩgʉ̃́ tiiróbiro niiĩ. Masĩgʉ̃́no wii tiigʉ́, coasã́wa, ʉ̃tãgãpʉ jea, botarí nʉcõ, wii tiimʉ́ãqui. ");
INSERT INTO tue_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Too síro oco pea, día pota, wĩno wẽẽ, tiiwiipʉ́ oco õmatucopacari, peedíaricu, ʉ̃tãgã sotoapʉ nʉcõã́ri wii niijĩrõ. ");
INSERT INTO tue_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yʉʉ wederére tʉo, yʉʉ wederirobiro tiihégʉnope tʉorírigʉ tiiróbiro niiĩ. Tʉorírigʉno wii tiigʉ́, ditatupari yepapʉ wii tiimʉ́ãqui. ");
INSERT INTO tue_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Too síro oco pea, día pota, wĩno wẽẽ, tiiwiipʉ́ oco õmatucori, jṍẽcodiacu. Jṍẽcodia mʉtãpetijõãcu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús teeré buepetiari siro, basocá cʉ̃ʉ̃ buerére tʉomaníjõãwã. ");
INSERT INTO tue_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dutiré cʉogʉ́ tiiróbiro buewi. Moisés jóarigue buerá tiiróbiro bueriwi. ");
INSERT INTO tue_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús ʉ̃tãgʉ̃pʉ́ niiãrigʉ diijeári, paʉ basocá cʉ̃ʉ̃rẽ nʉnʉyíra. ");
INSERT INTO tue_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Cʉ̃ʉ̃ maapʉ wáari, sĩcʉ̃ õpʉ̃ʉ̃ bóagʉ cʉ̃ʉ̃ pʉto wáayigʉ. Ñicãcoberimena jeacũmuyigʉ: —Õpʉ̃, mʉʉ yʉʉ diarecʉtirere netõnédʉgagʉ, netõnémasĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús cʉ̃ʉ̃rẽ ñaapeó, jĩĩyigʉ: —Netõnédʉgaga. Diaremanigʉ̃ pʉtʉáya, jĩĩyigʉ. Máata cʉ̃ʉ̃ya õpʉ̃ʉ̃ bóare yatijõãyiro. ");
INSERT INTO tue_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Ateré ãpẽrãrẽ́ wedegʉ mee tiiwá, jĩĩmiyigʉ—. Pairé ẽñogʉ̃́ wáaya, “ãñujõããyi” jĩĩdutigʉ. Too síro sũcã Cõãmacʉ̃rẽ ticoya, mʉʉ diaré netõã́rigue wapa wapatírono tiigʉ́. Teeré tiidutírigʉ niiwĩ Moisés. Mʉʉ teero tiiyá, basocá niipetira mʉʉ diaré netõã́riguere masĩãrõ jĩĩgʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaumpʉ sããwari, sĩcʉ̃ cien surara dutigʉ́ cʉ̃ʉ̃ pʉto atiwi. Cʉ̃ʉ̃rẽ tiiápure sãĩwĩ́: ");
INSERT INTO tue_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Õpʉ̃, yʉʉre padecotegʉ wiipʉ́ cõãã́wĩ. Cʉ̃ʉ̃ wáamasĩriawĩ. Bayiró peti pũnisíjããwĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Jáʉ. Netõnégʉ̃ wáagʉda, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Cien surara dutigʉ́ cʉ̃ʉ̃rẽ yʉʉwi: —Õpʉ̃, yʉʉ bʉ́ri niigʉ̃́ niiã. Teero tiigʉ́, yʉʉ mʉʉrẽ yáa wiipʉ “sããatiya” jĩĩmasĩriga. Mʉʉ sããwaripacari, “netõã́rõ” jĩĩcoremenarã yʉʉre padecotegʉ netõjṍãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yʉʉ ãpẽrã́ dutiré docapʉ niiã. Yʉʉpʉ surarare dutia sáa. Yʉʉ sĩcʉ̃rẽ “wáaya” jĩĩrĩ, wáai. Ãpĩrẽ́ “atiya” jĩĩrĩ, atii. Yʉʉre padecotegʉre “biiro tiiyá” jĩĩrĩ, tiii, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús cʉ̃ʉ̃ jĩĩrére tʉogʉ́, tʉomaníjõãwĩ. Cʉ̃ʉ̃rẽ nʉnʉrã́rẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Israelpʉre ãni tiiróbiro padeoré cʉogʉ́re bʉajeáñariga. ");
INSERT INTO tue_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉ́ãrẽ ateré wedea: Niipetiropʉ macãrã paʉ, ãni romanuãyʉ tiiróbiro Cõãmacʉ̃ Õpʉ̃ niirṍpʉ jeaadacua. Toopʉ́ Abraham, Isaac, Jacobmena yaaduiadacua. ");
INSERT INTO tue_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Paʉ Cõãmacʉ̃ sʉosʉguémirirape cʉ̃́ã padeohére wapa naĩtĩãrõpʉ cõãdioconoãdacua. Toopʉ́ pũnisíra bacadiyó, utiadacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesús cien surarare dutigʉ́re jĩĩwĩ: —Mʉʉya wiipʉ pʉtʉawagʉa. Mʉʉ padeoárirobirora wáaadacu, jĩĩwĩ. Toorá cʉ̃ʉ̃rẽ padecotegʉ netõjṍãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Pedroya wiipʉ wáayigʉ. Tiiwiipʉ́ sããjeagʉ, Pedro mañecõrẽ wiorécʉtipesagore bʉajeáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Coore wãmopʉ padeñáyigʉ. Cʉ̃ʉ̃ teero tiiríra, wioré tatijṍãyiro. Coo wʉ̃mʉnʉcã, cʉ̃́ãrẽ yaaré ecayígo. ");
INSERT INTO tue_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Náĩcũmurĩ, basocá Jesús pʉtopʉ paʉ wãtĩã sããnorirare néejeayira. Cʉ̃ʉ̃ sĩcãrĩ wedesecoremenarã wãtĩãrẽ cõãwionecoyigʉ. Niipetira diarecʉtiracãrẽ netõnépetijãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cʉ̃ʉ̃ teero tiirí, profeta Isaías jóarirobirora wáaro tiiyíro. Ateré jóarigʉ niiwĩ: “Marĩ tutuherere, marĩ diarecʉtirere cʉ̃ʉ̃peja netõnéjãwĩ”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús paʉ cʉ̃ʉ̃ pʉtopʉ neãnʉcãrĩ ĩñagʉ̃, ʉ̃sã cʉ̃ʉ̃ bueráre: —Jãmʉ, tĩãwaco iiníñapʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sĩcʉ̃ Moisés jóarigue buegʉ́ Jesús pʉto wáa, jĩĩwĩ: —Basocáre buegʉ́, noo mʉʉ wáaro yʉʉ mʉʉrẽ nʉnʉgʉ̃́da. Mʉʉ buegʉ́ niidʉgaga. ");
INSERT INTO tue_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Wáicʉra cãniré tutiri cʉoóya. Minipõná põnacʉtíre sutiri cʉoóya. Yʉʉ niipetira sõwʉ̃peja cãnirṍ cʉoría, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ãpĩ cʉ̃ʉ̃rẽ nʉnʉmíãrigʉ jĩĩwĩ: —Õpʉ̃, yʉʉ pacʉ diari siro, yaatóagʉpʉ, mʉʉmena wáagʉda sũcã, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉmena wáadʉgagʉ mecʉ̃tígãrã yʉʉre nʉnʉdóajãña. Yʉʉre padeohéra diarirapʉ tiiróbiro niitoaya. Cʉ̃́ã basiro cãmerĩ́ yaaáro, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús dooríwʉpʉ mʉãsãwĩ. Ʉ̃sã cʉ̃ʉ̃ buerá bapacʉtiwʉ. ");
INSERT INTO tue_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ʉ̃sã tĩãwari, wĩno bayiró wẽẽcʉtʉatiwʉ. Dooríwʉre ocoturí páabatesãwʉ̃. Jesupé cãnigʉ̃́ tiiwí. ");
INSERT INTO tue_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Teero tiirá, ʉ̃sã cʉ̃ʉ̃ pʉto wáa, wãcõrã́rã, cʉ̃ʉ̃rẽ jĩĩwʉ̃: —¡Ʉ̃sã Õpʉ̃, netõnéña! ¡Marĩ duadiarapʉ tiiara! jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús ʉ̃sãrẽ yʉʉwi: —¿Deero tiirá nocõrõ cuii? Mʉ́ã péerogã padeoré cʉorá niiã. Jĩĩtoa, wʉ̃mʉnʉcã, wĩnorẽ́, ocoturíre nʉcʉ̃ã́dutiwi. Nʉcʉ̃ã́petijõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ʉ̃sã ĩñamanijõãjĩrã, cãmerĩ́ wedesewʉ: —¿Ñiirũno basocʉ́ niimiĩ ãni? Cʉ̃ʉ̃rẽ wĩnopʉ́ra, ocoturípʉra yʉʉjã, netõnʉcã́ria, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús apeniñapʉ́ Gadara ditapʉ tĩãjeari, ʉ̃mʉã́ pʉarã́ masãcoperi watoapʉ niiãrira cʉ̃ʉ̃ pʉto atiwa. Cʉ̃́ã wãtĩã sããnorira niiwã. Bayiró peti cúaãmarã niiwã ména. Teero tiirá, basocá tiimapʉ́re netõwáriyira. ");
INSERT INTO tue_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesuré ĩñarã, acaribíjõãwã: —Mʉʉ Cõãmacʉ̃ macʉ̃, ʉ̃sãrẽ potocṍrijãña. ¿Ʉ̃sãrẽ ñañarõ netõrĩ́ tiigʉ́ atiarĩ? Ʉ̃sã ñañarõ netõã́daro jearia ména, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cʉ̃́ã beru paʉ yesea yaanucũwã. ");
INSERT INTO tue_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wãtĩã basocápʉre niirã́ Jesuré bayiró sãĩwã́: —Mʉʉ ʉ̃sãrẽ cõãwionecogʉja, ĩ́niã yeseapʉre sããwadutiya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús: —Teerora tiiyá, jĩĩ yʉʉwi. Cʉ̃ʉ̃ teero jĩĩrĩrã, basocápʉre niiãrira witiwa, yeseapʉre sããwatu niiwã. Niipetira yesea opatʉdipʉ cʉtʉcʉtʉ́buawa, opataropʉ ñaañuã, duajõãwã. ");
INSERT INTO tue_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yesea coterí basoca cuicocʉtʉawa. Macãpʉ jeara, wãtĩã sããnorira niimiãrirare wáaariguere wedepetirira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Teeré tʉorá, tiimacã macãrã niipetira Jesús pʉtopʉ jeawa. Cʉ̃ʉ̃rẽ ĩñarã, biiro jĩĩwã: —¡Wáagʉa! Ʉ̃sãya ditapʉre pʉtʉárijãña, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús dooríwʉpʉ mʉãsã, cʉ̃ʉ̃ya macãpʉ cãmecótĩãwĩ sũcã. ");
INSERT INTO tue_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Toopʉ́ ãpẽrã́ sĩcʉ̃ wáamasĩhẽgʉ̃rẽ cõãrṍmena Jesús pʉtopʉ ñoonéjeayira. Jesús cʉ̃́ã padeorí ĩñagʉ̃, wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: —Yáa wedegʉ, wãcũtutuaya. Mʉʉ ñañaré tiirére acabónotoaa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sĩquẽrã Moisés jóarigue buerá toopʉ́ niiyira. Cʉ̃́ã Jesús jĩĩrére tʉorá, wãcũyira: “Ãni Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiii”, jĩĩ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús cʉ̃́ã wãcũrére masĩjĩgʉ̃, sãĩñáyigʉ: —¿Deero tiirá mʉ́ã ñañarõ wãcũĩ? ");
INSERT INTO tue_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ãnirẽ́ “mʉʉ ñañaré tiirére acabónotoaa” yʉʉ jĩĩrĩ, tee cʉ̃ʉ̃rẽ acabónoãriguere ĩñaricu mʉ́ãjã. Yʉʉ “wʉ̃mʉnʉcã, wáaya” jĩĩrĩpereja, cʉ̃ʉ̃ wʉ̃mʉnʉcãrĩ ĩñaã mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉʉ niipetira sõwʉ̃ niiã. Teero tiigʉ́, atiditapʉ́re basocá cʉ̃́ã ñañaré tiirére acabómasĩã. Yʉʉ dutirére mʉ́ãrẽ ẽñogʉ̃́da, jĩĩyigʉ cʉ̃ʉ̃peja. Wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: —Wʉ̃mʉnʉcãña. Mʉʉ cõãrṍrẽ néeapa, mʉʉya wiipʉ pʉtʉawaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wáamasĩhẽgʉ̃ niimiãrigʉ wʉ̃mʉnʉcã, cʉ̃ʉ̃ya wiipʉ pʉtʉajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Basocá teero tiirí ĩñarã, cuijõãyira sáa. Cõãmacʉ̃rẽ ʉsenire ticoyira, cʉ̃ʉ̃ basocáre dutimasĩrere ticori ĩñarã. ");
INSERT INTO tue_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús too netõwágʉ, yʉʉre ĩñabʉawi. Yʉʉ romanuã õpʉ̃rẽ niyeru wapasébosari basocʉ niimiwʉ̃. Jesús yʉʉre yʉʉ paderópʉ duiri ĩña: —Jãmʉ yʉʉmena, jĩĩwĩ. Teero tiigʉ́, wʉ̃mʉnʉcã, cʉ̃ʉ̃mena wáawʉ. ");
INSERT INTO tue_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Too síro yáa wiipʉ yaaduiwi cʉ̃ʉ̃ buerámena. Cʉ̃́ã yaaritabe, ãpẽrã́ paʉ niyeru wapasébosari basoca, ãpẽrã́ ñañaré tiirá jeawa. Cʉ̃́ãmena yaaduiwa. ");
INSERT INTO tue_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseo basoca teeré ĩñarã, cʉ̃ʉ̃ bueráre sãĩñáwã: —¿Deero tiigʉ́ mʉ́ãrẽ buegʉ́ niyeru wapasébosari basocamena, ñañaré tiirámena yaai? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús teeré tʉogʉ́, jĩĩwĩ: —Diaremanirã ʉcotigʉre boorícua; diarecʉtira dícʉ ʉcotigʉre boocúa. ");
INSERT INTO tue_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cõãmacʉ̃ye queti jóaripũpʉ ate Cõãmacʉ̃ jĩĩriguere buenemorã wáaya sũcã: “Wáicʉra sóepeora dícʉre ĩñadʉgariga; ãpẽrãrẽ́ bóaneõ ĩñarépere nemorṍ ĩñadʉgaga”, jĩĩã. Yʉʉpe “ãñuré dícʉ tiia” jĩĩrã́rẽ ãmaãgʉ̃ atiriwʉ; ñañaré tiirápere ãmaãgʉ̃ atiwʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Too síro Juan buerére nʉnʉrã́ Jesús pʉto ati, cʉ̃ʉ̃rẽ sãĩñáwã: —Ʉ̃sã, teero biiri fariseo basoca betia. ¿Deero tiirá mʉʉ buerápe betiríi? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Wãmosíagʉdʉ boocórira bóaneõrã niimasĩriya, cʉ̃ʉ̃ cʉ̃́ãmena niirĩ. Too síro cʉ̃ʉ̃ néewanogʉ̃daqui. Teero wáari siro, betiádacua. ");
INSERT INTO tue_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Sĩcʉ̃ sutiró bʉcʉrore mama caseroména seeréturiqui. Teeré tiiátã, coserí, mama caserope wéedʉo, bʉcʉ caserore yigajõãrĩ tiicú. Teero tiirí, pairí cope yiganemocu. ");
INSERT INTO tue_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Teerora mama vinorẽ wáicʉra caseropori bʉcʉporimena posetínoricu. Teeré tiirí, wʉga, teepori esarí, podojõãcu. Vino píobatejõã, teeporicã cõõjṍãcu. Teero tiirá, mama vinorẽ mamapóripʉ posetínoã. Biiro tiirí, vinorẽ cʉo, tiipocãrẽ cʉorucúadacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús cʉ̃́ãmena wedesegʉ tiiríra, sĩcʉ̃ judíoa neãrí wii dutirá menamacʉ̃ jea, Jesús pʉto ñicãcoberimena jeacũmu, jĩĩwĩ: —Yʉʉ macõ mecʉ̃tígã diajõããwõ. Jãmʉ yʉʉmena. Ñaapeógʉ atiya. Mʉʉ ñaapeóri, masãgõdaco, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Teero jĩĩrĩ tʉogʉ́, Jesús cʉ̃ʉ̃mena wáawi. Ʉ̃sã cʉ̃ʉ̃ buerácã cʉ̃ʉ̃rẽ bapacʉtiwawʉ. ");
INSERT INTO tue_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ʉ̃sã cʉ̃ʉ̃ya wiipʉ wáari, sĩcõ numiṍ doce cʉ̃marĩ beti niiré teero niirucujãgõ Jesús sucubírope ati, cʉ̃ʉ̃yaro sutiró yapapʉ padeñárigo niiwõ. ");
INSERT INTO tue_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Coo wãcũyigo: “Yʉʉ cʉ̃ʉ̃yaro sutiró padeñáremenarã netõjã́gõdacu”, jĩĩ wãcũyigo. ");
INSERT INTO tue_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús cãmenʉcã́ coore ĩña, jĩĩwĩ: —Yáa wedego, wãcũtutuaya. Mʉʉ padeojĩ́gõ, netõnénoãrigopʉ pʉtʉáa, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩrĩrã, máata diaremanigõ pʉtʉáwo. ");
INSERT INTO tue_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús judíoare dutirá menamacʉ̃ya wiipʉ jeagʉ, cʉ̃́ã yaará wáaadari sʉguerogã, cʉ̃́ã utiritabere puticotéadarare ĩñarigʉ niiwĩ. Ãpẽrã́ bayiró acaribíremena utira tiitá. ");
INSERT INTO tue_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Cʉ̃́ãrẽ jĩĩrigʉ niiwĩ: —Witiwaya. Wĩmagõ diarico; cãnigṍ tiicó, jĩĩrigʉ niiwĩ. Cʉ̃́ãpe cʉ̃ʉ̃rẽ buijã́mirira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesupé cʉ̃́ãrẽ witiwadutitoa, diaarigo pesarí tatiapʉ sããwarigʉ niiwĩ. Cooya wãmorẽ ñeerigʉ niiwĩ. Cʉ̃ʉ̃ teero tiirí, coo wʉ̃mʉnurigo niiwõ. ");
INSERT INTO tue_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Niipetiro tiiditapʉre teero cʉ̃ʉ̃ tiirígue queti sesajõãriro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús too niiãrigʉ maapʉ wáawi sũcã. Cʉ̃ʉ̃ too wáari, pʉarã́ capeari ĩñahẽrã bayiró bʉsʉrómena jĩĩnʉnʉsewa: —¡David pãrãmi niinʉnʉsegʉ, ʉ̃sãrẽ bóaneõña! jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús wiipʉ́ sããjeari, capeari ĩñahẽrã cʉ̃ʉ̃rẽ nʉnʉsã́jeawa. Cʉ̃́ãrẽ sãĩñáwĩ: —¿Mʉ́ã yʉʉre “netõnémasĩjãqui” jĩĩ padeói? jĩĩwĩ. —Ʉ̃́jʉ̃, padeóa, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Too docare Jesús cʉ̃́ãye capearire ñaapeó: —Mʉ́ã padeoróbirora queoró wáaaro, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cʉ̃ʉ̃ teero jĩĩrĩrã, ĩñajõãwã. Jesús: —Ateré ãpẽrãrẽ́ wedera mee tiiádacu mʉ́ã, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cʉ̃ʉ̃ teero wedepacari, cʉ̃́ãpe cʉ̃ʉ̃ tiiríguere niipetiro tiidita macãrãpʉre wedebatejãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Capeari ĩñahẽrã niimiãrira witiwaritabe, ãpẽrã́ ãpĩrẽ́ néejeatoawa sũcã. Cʉ̃ʉ̃ wãtĩ sããnorigʉ wedesehegʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús wãtĩrẽ cõãwionecoari sirogãrã, wedesehegʉ niimiãrigʉ wedesenʉcãwĩ. Too macãrã ĩñamanijõãwã. —Ãno Israelpʉre teero wáari ĩñahẽrã niiwʉ̃ marĩ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo basocape biiro jĩĩwã: —Ãni wãtĩãrẽ dutigʉ́ tutuaremena wãtĩãrẽ cõãwionecoi, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús niipetire macãrĩ, pacamacã́rĩ, metãmacã́rĩgãpʉ wáanetõwĩ. Judíoa neãré wiseripʉ buewi. Ãñuré queti “Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare jeaadaro tiia” jĩĩrére wedewi. Niipetira diarecʉtirare, teero biiri õpʉ̃ʉ̃rĩ pũnirecʉtirare netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Basocá paʉre ĩñagʉ̃, bóaneõ ĩñawĩ. Cʉ̃́ã oveja coterí basocʉ manirã́ tiiróbiro bóaneõrã, tiiápure manirã́ niiwã. ");
INSERT INTO tue_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Teero tiigʉ́, ʉ̃sã cʉ̃ʉ̃ bueráre jĩĩwĩ: —Paʉ peti yʉʉre padeoádara niicua. Pʉarã́gã yéere wedeadarapeja niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Teero tiirá, Cõãmacʉ̃rẽ ãpẽrã́ yée maquẽrẽ wedera wáaadarare bayiró sãĩñá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús ʉ̃sã cʉ̃ʉ̃ buerá docere sʉowí. Wãtĩã basocápʉre niirã́rẽ cõãwionecomasĩrere ticowi ʉ̃sãrẽ. Niipetira diarecʉtirare, teero biiri õpʉ̃ʉ̃rĩ pũnirecʉtirare netõnémasĩrecãrẽ ticowi. ");
INSERT INTO tue_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ʉ̃sã doce cʉ̃ʉ̃ beserira wãme ate niiã: Niisʉguegʉ Simón niiwĩ. Apewãmé “Pedro” niiã. Cʉ̃ʉ̃ bai Andrés, Zebedeo põna Santiago, cʉ̃ʉ̃ bai Juan, ");
INSERT INTO tue_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (niyeru wapasébosari basocʉ niimirigʉ) Santiago (Alfeo macʉ̃) Tadeo, ");
INSERT INTO tue_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (romanuã dutiráre cõãdʉgara menamacʉ̃), Judas Iscariote (too síropʉ Jesuré ĩñatutirapʉre wedesãcotegʉdʉ), noquẽrãrã niiwʉ̃ ʉ̃sã. ");
INSERT INTO tue_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ʉ̃sã doce cʉ̃ʉ̃ beserirare ticocogʉ, “ateré tiiádacu mʉ́ã” jĩĩwĩ: —Judíoa niihẽrã niirṍpʉ wáarijãña. Samaria ditapʉ niiré macãrĩcãrẽ sããwarijãña. ");
INSERT INTO tue_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Too wáarono tiirá, Israelya põna macãrãpere wedera wáaya. Cʉ̃́ã oveja ditirira tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cʉ̃́ãrẽ ateré wedera wáaya: “Cõãmacʉ̃ dutiré marĩpʉre niiãdare jeaadaropʉ tiia”, jĩĩña. ");
INSERT INTO tue_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Diarecʉtirare netõnéña. Diaarirare masõña. Õpʉ̃ʉ̃rĩ bóarare netõnéña. Wãtĩã basocápʉre sããrirare cõãwionecoya. Yʉʉ tutuarere mʉ́ãrẽ wapamanírõ ticoa. Teero tiirá, mʉ́ãcã wapamanírõ cʉ̃́ãrẽ tiiápuya. ");
INSERT INTO tue_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mʉ́ã wáara, niyeruquiri néewarijãña. ");
INSERT INTO tue_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wasopore õmawarijãña. Suti, sapatu mʉ́ã sãñaré dícʉre néewaya. Tuurítuarigʉre néewarijãña. Paderáno cʉ̃́ã paderémena wapatá, yaamasĩya. ");
INSERT INTO tue_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Mʉ́ã pacamacã́rĩ, metãmacã́rĩgãpʉ sããjeara, “ãnirã́ ãñuĩ” cʉ̃́ã jĩĩgʉ̃́rẽ ãmaãña. Cʉ̃ʉ̃ “jáʉ” jĩĩrĩ, “nocõrõ yoari niiãda” jĩĩ, cʉ̃ʉ̃ pʉtopʉ pʉtʉácũmuña. ");
INSERT INTO tue_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wiipʉ́ sããjeara, tiiwií macãrãrẽ “Cõãmacʉ̃ mʉ́ãrẽ ãñurõ niirecʉtiri tiiáro” jĩĩ, ãñudutiya. ");
INSERT INTO tue_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉ́ãrẽ ãñurõ bocari, mʉ́ã ãñudutire teerora wáaadacu. Mʉ́ãrẽ ãñurõ bocariatã, mʉ́ã ãñudutire mʉ́ãpere pʉtʉáaro. ");
INSERT INTO tue_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Too docare mʉ́ãrẽ ñeedʉgaheri, mʉ́ã wederére tʉodʉgáheri, tiiwiiré o tiimacãrẽ witijõãña. Witiwara, tiimacã maquẽ dita mʉ́ãye dʉporipʉ túaariguere páabatecũña. ");
INSERT INTO tue_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, tiimacã macãrãrẽ bayiró ñañarõ tiigʉ́daqui. Sodoma, Gomorra macãrĩ macãrãrẽ tiiríro nemorṍ cʉ̃́ãrẽ ñañarõ tiigʉ́daqui, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús jĩĩnemowĩ: Ateré masĩña: Yʉʉ mʉ́ãrẽ quiorópʉ ticocogʉ tiia, ovejare yáiwa watoapʉ ticocogʉ tiiróbiro. Teero tiirá, ãñurõ tʉomasĩ́rã niiña. Ñañaré tiiró manirṍ niirecʉtiya. ");
INSERT INTO tue_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mʉ́ã watoa niirã́ tiiádarere ãñurõ wãcũ tʉgueñasʉgueya. Mʉ́ãrẽ dutirápʉre tico, judíoa neãré wiseripʉ tãnaã́dacua. ");
INSERT INTO tue_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mʉ́ã yʉʉre padeoré wapa dutirá, õpãrã́ pʉtopʉ wéewanoãdacu. Toopʉ́ cʉ̃́ãrẽ, teero biiri judíoa niihẽrãrẽ yée maquẽrẽ wedeadacu. ");
INSERT INTO tue_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mʉ́ãrẽ néewari, “¿deero jĩĩ wedeadari; deero jĩĩãdari marĩ?” jĩĩ wãcũpatirijãña. Mʉ́ã jearira, Cõãmacʉ̃ mʉ́ãrẽ wedemasĩãdarere ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mʉ́ã mee wedeadacu; Espíritu Santo marĩ Pacʉ ticodiocorigʉ wãcũré ticorémenape wedeadacu. ");
INSERT INTO tue_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Sĩcʉ̃põna niipacara, dutirápʉre cãmerĩ́ wedesã, sĩãrĩ́ tiiádacua. Cʉ̃́ã pacʉsʉ̃mʉã cʉ̃́ã põnarẽ teerora tiiádacua. Cʉ̃́ã põnacã cʉ̃́ã pacʉsʉ̃mʉãrẽna netõnʉcã́, sĩãrĩ́ tiiádacua. ");
INSERT INTO tue_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Niipetira basocá mʉ́ãrẽ ĩñatutiadacua yʉʉre padeoré wapa. Teero mʉ́ãrẽ cʉ̃́ã ñañarõ tiipacári, yʉʉre padeorucújãrãrẽ Cõãmacʉ̃ netõnégʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sicamacãpʉ mʉ́ãrẽ ñañarõ tiidʉgára, ĩñanʉnʉseri, apemacãpʉ́ dutijṍãña. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niipetiro Israelya põna macãrã niiré macãrĩpʉ mʉ́ã wedesesaripacari, yʉʉ niipetira sõwʉ̃ pʉtʉaatigʉdacu. ");
INSERT INTO tue_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sĩcʉ̃ buegʉ́ cʉ̃ʉ̃rẽ buegʉ́ nemorṍ masĩgʉ̃́ niimasĩriqui. Padecotegʉcã cʉ̃ʉ̃rẽ dutigʉ́ nemorṍ niimasĩriqui. ");
INSERT INTO tue_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Buegʉ́ ateré jĩĩrõ booa: “Yʉʉre buegʉ́ tiiróbiro niidʉgaga”. Padecotegʉcã “yʉʉre dutigʉ́ tiiróbiro niidʉgaga” jĩĩrõ booa. Yʉʉ mʉ́ãrẽ buegʉ́re “wãtĩãrẽ dutigʉ́ Beelzebú niiĩ” jĩĩrã, nemorṍrã ñañarõ jĩĩãdacua mʉ́ãpereja. ");
INSERT INTO tue_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Teero tiirá, basocáreja cuirijãña. Bauhéropʉ niiré bauádacu. Ĩñahẽrõpʉ tiiré masĩnoãdacu. ");
INSERT INTO tue_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yʉʉ mʉ́ãrẽ tʉohéropʉ jĩĩrére tʉocóropʉ wedebateya. Yayióropʉ jĩĩrére wii sotoápʉ niipetira tʉocóropʉ bayiró bʉsʉrómena wedebateya. ");
INSERT INTO tue_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉ́ãrẽ sĩãrã́rẽ cuirijãña. Mʉ́ã yeeripũnarẽ sĩãcõã́masĩricua. Cõãmacʉ̃ sĩcʉ̃rã mʉ́ãye õpʉ̃ʉ̃rĩ, mʉ́ã yeeripũnarẽ pecamepʉ tiidiómasĩqui. Cʉ̃ʉ̃ docare cuiya. ");
INSERT INTO tue_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Sicaqui niyeruquigãmena pʉarã́ minipõnágã sãĩnóã. Cʉ̃́ã wapamanípacari, Cõãmacʉ̃ sĩcʉ̃nogãrẽ bóaaro jĩĩripacari, yepapʉ ñaadia, bóariqui. ");
INSERT INTO tue_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mʉ́ãye póarire “noquẽ pee niiã” jĩĩmasĩjãqui. ");
INSERT INTO tue_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Teero tiirá, cuirijãña. Mʉ́ã paʉ minipõná nemorṍ wapacʉtíra niiã. ");
INSERT INTO tue_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Teero tiigʉ́, basocá ĩñacoropʉ sĩcʉ̃ yʉʉre “padeóa” jĩĩgʉ̃́rẽ yʉʉcã yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ ĩñacoropʉ “yʉʉre padeogʉ́ra niiĩ” jĩĩ wedegʉda. ");
INSERT INTO tue_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Basocá ĩñacoropʉ sĩcʉ̃ yʉʉre “cʉ̃ʉ̃rẽ padeogʉ́ mee niiã” jĩĩgʉ̃́rẽ yʉʉcã yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ ĩñacoropʉ “yʉʉre padeogʉ́ mee niiĩ” jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mʉ́ã yʉʉre “atibʉ́recopʉre ãñurõ niirecʉtire maquẽrẽ néeatigʉ tiiquí” jĩĩ wãcũrijãña. Teeré néeatigʉ mee atiwʉ. Ãpẽrã́ yʉʉre boohéra yʉʉre boorámena cãmerĩ́tutiadacua. Teero tiigʉ́, cãmerĩ́ tuudʉcáwarere néeatigʉ atiwʉ. ");
INSERT INTO tue_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sĩcʉ̃ cʉ̃ʉ̃ pacʉ yʉʉre padeorí ĩñagʉ̃, “teero padeoã́majãgʉ̃ tiia mʉʉjã” jĩĩgʉ̃daqui. Teerora wáaadacu numiṍpecãrẽ coo pacoména. Teerora wáaadacu sũcã macʉ̃ nʉmorẽ coo mañecõména. ");
INSERT INTO tue_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yʉʉre padeogʉ́norẽ cʉ̃ʉ̃ya wii macãrãrã niijããdacua cʉ̃ʉ̃rẽ bayiró ĩñatutira. ");
INSERT INTO tue_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Sĩcʉ̃no yʉʉre maĩrṍ nemorṍ cʉ̃ʉ̃ pacʉpere, cʉ̃ʉ̃ pacopére maĩnetṍnʉcãgʉ̃, yʉʉ buegʉ́ niimasĩriqui. Sĩcʉ̃no yʉʉre maĩrṍ nemorṍ cʉ̃ʉ̃ macʉ̃pére, cʉ̃ʉ̃ macõpére maĩnetṍnʉcãgʉ̃, yʉʉ buegʉ́ niimasĩriqui. ");
INSERT INTO tue_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sĩcʉ̃ “yʉʉ Jesuré padeogʉ́ja diajãbocu” jĩĩ cuigʉno yʉʉ buegʉ́ niimasĩriqui. ");
INSERT INTO tue_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ãpĩ sĩãrére cuigʉno yʉʉre “masĩria” jĩĩgʉ̃́ pecamepʉ wáagʉdaqui. Ãpĩpé yʉʉre “masĩã” jĩĩ, teewapamena cʉ̃ʉ̃rẽ sĩãrĩ́, yʉʉmena catirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Mʉ́ãrẽ bocagʉ́no yʉʉre bocagʉ tiii. Yʉʉre bocagʉ́ yʉʉre ticodiocorigʉre bocagʉ tiii. ");
INSERT INTO tue_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Profetano jeari, sĩcʉ̃ cʉ̃ʉ̃rẽ bocaboqui, “cʉ̃ʉ̃ profeta niiĩ” jĩĩgʉ̃. Cõãmacʉ̃ profetaye wapatáre ticorobiro bocagʉ́cãrẽ wapatígʉdaqui. Teerora basocʉ́ ãñugʉ̃́no jeari, sĩcʉ̃ cʉ̃ʉ̃rẽ bocaboqui, “cʉ̃ʉ̃ basocʉ́ ãñugʉ̃́ niiĩ” jĩĩgʉ̃. Cõãmacʉ̃ basocʉ́ ãñugʉ̃́ye wapatáre ticorobiro bocagʉ́cãrẽ wapatígʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Teerora yʉʉ buegʉ́no jeari, cʉ̃ʉ̃ bʉ́ri niigʉ̃́ niipacari, sĩcʉ̃ cʉ̃ʉ̃rẽ oco yʉsʉáre tĩ́ãboqui, “cʉ̃ʉ̃ Jesús buegʉ́ niiĩ” jĩĩgʉ̃. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃ʉ̃ wapatáre bʉagʉ́daqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús ʉ̃sã docere tee dutirére wedeari siro, Galilea ditapʉ niiré macãrĩpʉ buegʉ wáawi. ");
INSERT INTO tue_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan peresuwiipʉ niigʉ̃, Cristo tiiré quetire tʉoyígʉ. Teeré tʉogʉ́, cʉ̃ʉ̃ buerére nʉnʉrã́rẽ cʉ̃ʉ̃ pʉtopʉ ticocorigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Cʉ̃́ã toopʉ́ jeara, Juan sãĩñádutiariguere sãĩñáwã: —¿Mʉʉrã́ niiĩ “basocáre netõnégʉ̃dʉ atigʉdaqui” jĩĩnorigʉ o ãpĩpére yuegarite? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús cʉ̃́ãrẽ yʉʉwi: —Juanrẽ́ wedera wáaya mʉ́ã tʉoáriguere, mʉ́ã ĩñaãriguere. ");
INSERT INTO tue_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Biiro jĩĩña: “Ĩñahẽrã ĩñaãya. Wáamasĩhẽrã wáaaya. Õpʉ̃ʉ̃rĩ bóara yatijõãnoya. Tʉohéra tʉoóya. Diaarira masõnoya. Bóaneõrã ãñuré quetire wedenoya. ");
INSERT INTO tue_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yʉʉre padeodúhegʉno ʉseniqui”, jĩĩ wedera wáaya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cʉ̃́ã wáara tiirí, Jesús Juanyé maquẽrẽ basocáre wedenʉcãwĩ: —¿Mʉ́ã basocá manirṍpʉ ñeenórẽ ĩñarã jeari? ¿Cãnʉsirogʉ wĩno páapuri cãmeñarere ĩñarã jearite? ");
INSERT INTO tue_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ñeenórẽ ĩñarã jeari? ¿Ãñuré suti sãñagʉ̃́rẽ ĩñarã jearite? Suti ãñuré sãña niirã́jã õpãrãyé wiseripʉ niicua. ");
INSERT INTO tue_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ñeenópere ĩñarã jeari? ¿Profetapere ĩñarã jearite? Diamacʉ̃́rã Juanpeja profetas nemorṍ ʉpʉtí maquẽrẽ wedewi. ");
INSERT INTO tue_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cʉ̃ʉ̃ye maquẽrẽ Cõãmacʉ̃ye queti jóaripũpʉ ateré jóanoã: Yʉʉre wedesʉguegʉre mʉʉ sʉguero ticocogʉda. Cʉ̃ʉ̃ mʉʉ wáaadarimarẽ quẽnoyúegʉdaqui, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niipetira basocá watoapʉre Juan basocáre wãmeõtiri basocʉ tiiróbiro ʉpʉtí macʉ̃ niigʉ̃́ maniĩ. Tee biipacari, bʉ́ri niigʉ̃́ niipacʉ, Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉsegʉnope Juan nemorṍ ʉpʉtí macʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan buenʉcãritopʉre tée atitópʉcãrẽ Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere ĩñadʉgarare bayiró ñañarõ netõrĩ́ tiicúa. Cʉ̃́ã tutirémena cʉ̃́ãrẽ petirí tiidʉgára tiicúa. ");
INSERT INTO tue_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Niipetira profetas Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare jeaadarere wedesʉguerira niiwã. Teero biiri Moisére dutiré cṹũriguecã tee maquẽrẽna wedea. Too síro Juancã tee maquẽrẽna wedewi. ");
INSERT INTO tue_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mʉ́ã yʉʉ jĩĩãdarere padeoáda jĩĩrã, ãñurõ tʉoyá: Juanrã́ niijãgʉ̃ tiii “Elías ãnopʉ́ pʉtʉaatigʉdaqui sũcã” jĩĩnorigʉ. ");
INSERT INTO tue_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tʉodʉgárano tʉomasĩ́ãdacua. ");
INSERT INTO tue_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Ñeenó queorémena wedegʉdari yʉʉ atitó macãrãrẽ? Wĩmarã macã decopʉ apeduira tiiróbiro niiĩya. Cʉ̃́ã menamacãrãmena biiro cãmerĩ́tuticua: ");
INSERT INTO tue_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ʉ̃sã bosebʉreco tiirí, basaapuriawʉ̃. Ʉ̃sã booritua, utiri, utiapuriawʉ̃”, jĩĩcua. ");
INSERT INTO tue_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan apetóre yaariyigʉ; vinocãrẽ sĩnirídojãyigʉ. Mʉ́ãpe cʉ̃ʉ̃ teero biirecʉtiri ĩñarã, “wãtĩ cʉoi” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yʉʉ niipetira sõwʉ̃pe yaa, sĩniã. Mʉ́ã yʉʉ teero tiirí ĩñarã, “yaawãnigʉ̃, sĩniwãnígʉ̃ niiĩ; niyeru wapasébosari basoca menamacʉ̃, ñañaré tiirá menamacʉ̃ niiĩ” jĩĩã. Basocá Cõãmacʉ̃ masĩrére cʉorá cʉ̃́ã tiirécʉtiremena tee masĩrére ẽñomasĩ́ya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Too síro Jesús sĩquẽñe macãrĩ macãrãrẽ tutiwi. Cʉ̃́ã ãpẽrã́ nemorṍ cʉ̃ʉ̃ tutuaremena tiiẽ́ñoriguere ĩñarira niipacara, cʉ̃́ã ñañaré tiirére wãcũpati, wasorídojãrira niiwã. Biiro jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Bóaneõrã niiã mʉ́ã Corazín, Betsaida macãrĩ macãrã. Yʉʉ tutuaremena tiiẽ́ñoriguere ĩñarira niipacara, wasorídojãã. Tiro, Sidón macãrĩpʉ yʉʉ tiiẽ́ñoãtã, máata teemacãrĩ macãrã cʉ̃́ã ñañaré tiirére wãcũpati, wasotóabojĩya. Cʉ̃́ã wãcũpatirere ẽñorã́, wãcũpatire suti sãña, nitĩ tuusĩã́bojĩya. ");
INSERT INTO tue_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ãñurõ tʉoyá: Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, Tiro, Sidón macãrã nemorṍ mʉ́ãpere ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉ́ã Capernaum macãrãcã “Cõãmacʉ̃ pʉtopʉ ãñurõ mʉãwaadacu” jĩĩ wãcũmicu. Mʉãwaricu; pecamepe diiwáadacu. Yʉʉ mʉ́ã pʉtopʉ tiiẽ́ñorigue tiirírobiro Sodomapʉre tiiẽ́ñoãtã, tiimacã mecʉ̃tígãrẽ niibocu ména. ");
INSERT INTO tue_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ãñurõ tʉoyá: Cõãmacʉ̃ basocáre wapa tiiádari bʉreco jeari, mʉ́ãpere Sodoma macãrãrẽ tiiríro nemorṍ ñañarõ tiinóãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Too síro Jesús Cõãmacʉ̃rẽ ʉsenire ticowi: —Pacʉ, mʉʉ ʉ̃mʉã́se, atiditá Õpʉ̃ niiã. “Ʉ̃sã masĩnetõnʉcãã” jĩĩrã́rẽ mʉʉyere masĩrĩ tiiría; wĩmarã tiiróbiro mʉʉyere masĩdʉgarapere teeré masĩrĩ tiia. Teeré mʉʉ teerora wáari boocú. Teero tiigʉ́, mʉʉrẽ ʉsenire ticoa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Too síro basocápere jĩĩwĩ sũcã: —Yʉʉ Pacʉ niipetire masĩrére yʉʉre ticowi. Cʉ̃ʉ̃ sĩcʉ̃rã yʉʉ niirecʉtirere masĩĩ. Yʉʉpecã sĩcʉ̃rã cʉ̃ʉ̃ niirecʉtirere masĩã. Ãpẽrãcã́ Cõãmacʉ̃ niirecʉtirere masĩãdacua. Yʉʉ booránorẽ cʉ̃ʉ̃rẽ masĩrĩ tiigʉ́da. ");
INSERT INTO tue_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉ́ã Cõãmacʉ̃rẽ nʉnʉdʉgára bayiró pade, nʉcʉ̃ré õmarã tiiróbiro páasʉticu. Yʉʉ pʉto atiya. Yʉʉ mʉ́ãrẽ yeerisãre ticogʉda. ");
INSERT INTO tue_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mʉ́ã yʉʉ tiidutírepere tiiyá. Yʉʉ tiirécʉtirere masĩña. Yʉʉ mʉ́ãrẽ bóaneõremena ĩña, tiiápugʉ niiã. Teero tiirá, yʉʉ tiidutírere tiirá, yʉʉmena ãñurõ yeerisãre bʉaádacu. ");
INSERT INTO tue_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉʉ tiiápuremena yéere tiirí, wisióridojãã. Yʉʉ dutirére tiirécʉtirano nʉcʉ̃hẽregã õmarã tiiróbiro niiĩya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Too síro sábado ʉ̃sã yeerisãri bʉreco niirĩ, Jesús trigo oterigue watoa netõwáwi. Ʉ̃sã cʉ̃ʉ̃ buerá jʉabóajõãtʉ. Trigore tʉ̃nenʉcãwʉ̃, yaaadara. ");
INSERT INTO tue_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo basoca ʉ̃sã tee tiirí ĩñarã, Jesuré jĩĩwã: —Ĩñaña. Marĩrẽ yeerisãri bʉrecore padedutiripacari, mʉʉ buerápeja padera tiiíya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Õpʉ̃ David sicabʉreco jʉabóayigʉ. Cʉ̃ʉ̃ menamacãrã jʉabóaramena cʉ̃ʉ̃ tiiríguere mʉ́ã buerá niipacara, ¿masĩrii? ");
INSERT INTO tue_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Cõãmacʉ̃wiipʉ sããwayigʉ. Toopʉ́ pã mesa sotoa pesariguere “Cõãmacʉ̃ye niiã” jĩĩriguere yaapetijãyigʉ cʉ̃ʉ̃ menamacãrãmena. Paiá dícʉre yaaré niimiyiro. ");
INSERT INTO tue_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Paiá Cõãmacʉ̃wiipʉ paderá yeerisãri bʉreco niipacari, yeerisãriya. Yeerisãripacara, Cõãmacʉ̃ dutirére netõnʉcã́riya. Mʉ́ã teeré buerá niipacara, ¿masĩridojãĩ? ");
INSERT INTO tue_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ãñurõ tʉoyá: Ãnorẽ́ yʉʉ Cõãmacʉ̃wii nemorṍ ʉpʉtí macʉ̃ niinetõnʉcãã. ");
INSERT INTO tue_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cõãmacʉ̃ye queti jóaripũpʉ Cõãmacʉ̃ jĩĩriguere mʉ́ã tʉomasĩ́ricu. Biiro jĩĩ jóanoã: “Wáicʉra sóepeora dícʉre ĩñadʉgariga; ãpẽrãrẽ́ bóaneõ ĩñarépere nemorṍ ĩñadʉgaga”, jĩĩré niiã. Mʉ́ã teeré tʉomasĩ́rãjã, ñañaré tiihérarena “ñañaré tiiíya” jĩĩriboajĩyu. ");
INSERT INTO tue_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉʉ niipetira sõwʉ̃ yeerisãri bʉreco niirĩ, basocá tiiádarere dutimasĩã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cʉ̃ʉ̃ teero tiiári siro, Jesús cʉ̃́ã neãrí wiipʉ sããwawi. ");
INSERT INTO tue_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Toopʉ́ sĩcʉ̃ wãmo bʉʉre cʉogʉ́ niiwĩ. Fariseo basoca Jesuré wedesãdʉgara, cʉ̃ʉ̃rẽ sãĩñáwã: —¿Marĩ yeerisãri bʉreco niirĩ, diarecʉtirare netõnémasĩnogari? ");
INSERT INTO tue_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ãyagʉ oveja copepʉ ñaasãrĩ, marĩ yeerisãri bʉreco niipacari, mʉ́ã néewionecocu. ");
INSERT INTO tue_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sĩcʉ̃ basocʉ́ oveja nemorṍ wapacʉtíi. Teero tiirá, marĩ yeerisãri bʉrecore ãñurõ tiirá, Moisés dutirére netõnʉcã́rã mee tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Teero jĩĩãri siro, basocʉ́re: —Mʉʉya wãmorẽ súucoya, jĩĩwĩ. Cʉ̃ʉ̃peja súucowi. Teero tiiríra, tiiwãmo apewãmó tiiróbiro ãñurí wãmo pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseo basocape witiwa, “¿deero tii marĩ ãnirẽ́ sĩãã́dariye?” jĩĩ wedesewarira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús cʉ̃ʉ̃rẽ sĩãdʉgárere masĩjãrigʉ niiwĩ. Teero tiigʉ́, wáajõãwĩ. Cʉ̃ʉ̃ wáari, paʉ basocá cʉ̃ʉ̃rẽ nʉnʉwã́. Niipetira diarecʉtirare netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cʉ̃́ãrẽ cʉ̃ʉ̃ netõnéãriguere wededutirimiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cʉ̃ʉ̃ paʉre netõnériguemena profeta Isaías jóarigue diamacʉ̃́ wáawʉ. Biiro jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Biiro jĩĩĩ Cõãmacʉ̃: Ãni yʉʉre padecotegʉ yʉʉ beserigʉ niiĩ. Cʉ̃ʉ̃ yʉʉ maĩgʉ̃́mena ʉseniã. Yʉʉ Espíriture cʉ̃ʉ̃rẽ ticogʉda. Niipetiro macãrãrẽ wapa tiiádarere masĩrĩ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jĩĩcuaseoriqui; acaribínetõriqui. Basocá watoapʉ cʉ̃ʉ̃ tiiáriguere bayiró bʉsʉrómena wederiqui. ");
INSERT INTO tue_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wãcũtutuhegʉre cõãriqui. Cõãrõno tiigʉ́, wãcũtutuari tiigʉ́daqui. Padeotutúherare tutiriqui; cʉ̃́ãrẽ ãñurõ tiiápugʉdaqui. Cʉ̃ʉ̃ õpʉ̃ sããri siropʉ, ñañarére docacũmurĩ tiigʉ́daqui. Cʉ̃ʉ̃ diamacʉ̃́ dutigʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Niipetiro macãrã cʉ̃ʉ̃rẽ padeoádacua, jĩĩĩ Cõãmacʉ̃, jĩĩ jóarigʉ niiwĩ Isaías. ");
INSERT INTO tue_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Too síro Jesús pʉtopʉ wãtĩ sããnorigʉre néejeawa. Cʉ̃ʉ̃ capeari ĩñahẽgʉ̃, wedesehegʉ niimiwĩ. Jesús cʉ̃ʉ̃rẽ netõnéãri siro, ĩña, wedesejõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Niipetira basocá ĩñamanijõãwã. Cãmerĩ́ sãĩñáwã: —¿Ãni õpʉ̃ David pãrãmi niinʉnʉsegʉ cʉ̃́ã “atigʉdʉ niiãyigʉ” jĩĩrigʉ niigari? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo basocapeja cʉ̃́ã wedeseri tʉorá, jĩĩwã: —Ãni wãtĩãrẽ dutigʉ́ Beelzebú tutuaremena wãtĩãrẽ cõãwionecoi, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesupé cʉ̃́ã wãcũrére masĩjĩgʉ̃, cʉ̃́ãrẽ jĩĩwĩ: —Sicadita macãrã sĩcãrõména niihẽrã, cʉ̃́ã basiro cãmerĩ́quẽrã, tiidita macãrã petijṍãcua. Sicamacã macãrã o sicawií macãrã sĩcãrõména niihẽrã, cʉ̃́ã basiro cãmerĩ́quẽrã, cʉ̃́ãcã petijṍãcua. ");
INSERT INTO tue_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanás wãtĩãrẽ cõãwionecori, cãmerĩ́quẽrã, sĩcãrõména niiriya. Teero tiiró, cʉ̃ʉ̃ dutiré petijṍããdacu. ");
INSERT INTO tue_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mʉ́ã yʉʉre “Beelzebú tutuaremena wãtĩãrẽ cõãwionecoqui” jĩĩã. Teero jĩĩãtã, mʉ́ã buerére nʉnʉrã́ wãtĩãrẽ cõãwionecora, ¿noã tutuaremena cõãwionecogari? Cʉ̃́ãrẽ sãĩñárã wáaya. Mʉ́ã wisirére cʉ̃́ã ẽñoã́dacua. ");
INSERT INTO tue_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yʉʉ Cõãmacʉ̃ tutuaremena wãtĩãrẽ cõãwionecojĩgʉ̃, ateré mʉ́ãrẽ wedea: Cõãmacʉ̃ dutiré basocápʉre niiãdare jeatoaa. ");
INSERT INTO tue_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Tutuagʉya wiire ãpĩ sããwagʉ, cʉ̃ʉ̃rẽ siatúcũripacʉ, ẽmamasĩriqui; siatúcũtoagʉpʉ, cʉ̃ʉ̃ya wii maquẽrẽ ẽmamasĩqui. ");
INSERT INTO tue_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Yʉʉre boohégʉ yʉʉre ĩñatutigʉ niiĩ. Yʉʉre tiiápuhegʉ yʉʉre nʉnʉdʉgárare cãmotágʉ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Teero tiirá, ãñurõ tʉoyá: Cõãmacʉ̃ basocáre niipetire cʉ̃́ã ñañaré tiirére, ñañarõ wedeserere acabógʉdaqui. Cʉ̃ʉ̃ teero acabópacʉ, cʉ̃́ã Espíritu Santore ñañarõ wedeseripereja, acabóriqui. ");
INSERT INTO tue_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉʉ niipetira sõwʉ̃rẽ ñañarõ wedesepacari, Cõãmacʉ̃ acabógʉdaqui. Espíritu Santore ñañarõ wedeseripereja, acabóriqui. Mecʉ̃tígã, too síropʉcãrẽ teerora acabóriqui. ");
INSERT INTO tue_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Sicagʉ́ yucʉgʉ ãñurígʉ niirĩ, tiigʉ́ dʉca ãñuré niiãdacu. Apegʉ́ ñañarígʉ niirĩ, tiigʉ́ dʉca ñañaré niiãdacu. Yucʉgʉre tiigʉ́ dʉcamena ĩñamasĩnoã. ");
INSERT INTO tue_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mʉ́ã ãñaã tiiróbiro ñañarã́ niiã. Mʉ́ã ñañarã́ niipacara, ¿deero tiirá ãñurére wedesebogari? Wedesemasĩria. Ñañarã́ niinetõnʉcãrã ñañaré dícʉ wedesea. ");
INSERT INTO tue_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Basocʉ́ ãñugʉ̃́pʉre ãñuré niicu. Teero tiigʉ́, ãñuré wedesei. Basocʉ́ ñañagʉ̃́pʉre ñañaré niicu. Teero tiigʉ́, ñañaré wedesei. ");
INSERT INTO tue_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ãñurõ tʉoyá: Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, cʉ̃́ã noo booró jĩĩãmariguere sãĩñágʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ãpĩ cʉ̃ʉ̃ ãñuré wedeserigue wapa Cõãmacʉ̃ pʉtopʉ wáagʉdaqui; ãpĩpé cʉ̃ʉ̃ ñañaré wedeserigue wapa pecamepʉ wáagʉdaqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Too síro sĩquẽrã Moisés jóarigue buerá, teero biiri fariseo basoca Jesuré jĩĩwã: —Basocáre buegʉ́, Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñorĩ ĩñadʉgaga, jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cʉ̃́ãrẽ yʉʉwi: —Mʉ́ã atitó macãrã ñañaré tiirá, Cõãmacʉ̃rẽ boohéra niiã; Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere ĩñadʉgacu. Profeta Jonás tiirígue tiiróbiro niiré dícʉre ĩñaãdacu. ");
INSERT INTO tue_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás itiábʉreco, itiáñami waiwʉ̃ paigʉ́caya páaga popeapʉ sãñayigʉ. Cʉ̃ʉ̃rẽ tiirírobirora yʉʉ niipetira sõwʉ̃cã itiábʉreco, itiáñami dita popeapʉ niigʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive macãrã Jonarẽ́ tʉorá, wãcũpati, wasoyíra. Mʉ́ãpe ãnopʉ́ Jonás nemorṍ masĩgʉ̃́rẽ tʉoré peti tʉojã́ã. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, mʉ́ã cʉ̃́ã tiiróbiro tʉorírigue wapa mʉ́ãrẽ pecamepʉ cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Saba dita macãrã õpõ yoaro macõ atiyigo Salomón masĩrére tʉogó atigo. Mʉ́ãpe ãnopʉ́ Salomón nemorṍ masĩgʉ̃́rẽ tʉoré peti tʉojã́ã. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, mʉ́ã coo tiiróbiro tʉorírigue wapa mʉ́ãrẽ pecamepʉ cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Wãtĩ basocʉ́pʉre niiãrigʉ witiwagʉ, basocá manirṍpʉ wáayigʉ cʉ̃ʉ̃ niiãdaro ãmaãgʉ̃. Bʉaríyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Bʉarí, “yʉʉ witiatiriropʉ coesã́wagʉda sũcã” jĩĩ wãcũyigʉ. Jeagʉ, apeyenó manirí wii, joaári wii, ãñurõ quẽnoã́ri wii tiiróbiro bʉajeáyigʉ basocʉ́pʉre. ");
INSERT INTO tue_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Too síro wáa, siete wãtĩã cʉ̃ʉ̃ nemorṍ ñañarã́rẽ “atiya mʉ́ãcã” jĩĩyigʉ. Cʉ̃́ã niipetira basocʉ́pʉre sããwa, niiyira. Basocʉ́pe cʉ̃́ã teero tiirí, nemorṍ ñañarõ netõyígʉ. Teerora ñañarõ wáaadacu atitó macãrã ñañaré tiirácãrẽ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús basocáre wederitabe, cʉ̃ʉ̃ paco, cʉ̃ʉ̃ baira sopepʉ́ jeanʉcãrira niiwã. “Jesuména wedesedʉgaga”, jĩĩrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sĩcʉ̃ wedewi Jesuré: —¡Coe! Mʉʉ paco, mʉʉ baira sopepʉ́ jeanʉcãya, mʉʉmena wedesedʉgaayira, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Cʉ̃ʉ̃rẽ wedearigʉre jĩĩwĩ: —¿Noã niiĩ yʉʉ paco; noã niiĩ yʉʉ baira? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ʉ̃sã cʉ̃ʉ̃ buerápʉre súupuacogʉra, jĩĩwĩ: —Ãniã yʉʉ paco, yʉʉ baira tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ boorére tiiráno cʉ̃́ãrã yʉʉ bai, yʉʉ bayio, yʉʉ paco tiiróbiro niiĩya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tiibʉrecora Jesús wiipʉ́ niiãrigʉ witiwa, opataro wesapʉ jeanuãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Paʉ basocá cʉ̃ʉ̃ pʉtopʉ neãwã. Cʉ̃́ã paʉ niinetõrĩ ĩñagʉ̃, dooríwʉpʉ mʉãsã, jeanuãwĩ. Ditatuparipʉ pʉtʉáwa basocápeja. ");
INSERT INTO tue_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cʉ̃ʉ̃ wãcũrémena cʉ̃́ãrẽ pee queoré wedewi. Ate queorémena jĩĩnʉcãwĩ: —Sĩcʉ̃ basocʉ́ oteréperire wẽ́ẽbategʉ wáayigʉ, wiiáro jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cʉ̃ʉ̃ wẽ́ẽbatewari, sĩquẽñeperi maapʉ ñaacũmuyiro. Minipõná ati, teeré yaapetijãyira. ");
INSERT INTO tue_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apeyepéri ʉ̃tãyepa dita péerogã cʉorópʉ ñaacũmuyiro. Tiidita ʉ̃cʉ̃hẽ́rõgã niijĩrõ, máata manayiro. ");
INSERT INTO tue_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Muĩpũ asirí, ocobopó, nʉcõrĩ manijĩ́rõ, sĩnijṍãyiro. ");
INSERT INTO tue_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apeyepéri pota watoapʉ ñaacũmuyiro. Pota teeré wiinetṍmʉã, sĩãjã́yiro. ");
INSERT INTO tue_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apeyepéri ote ʉseniri ditapʉ ñaacũmuyiro. Tee dʉcacʉtiyiro. Sicasati cienperi, apesatí sesentaperi, apesatí treintaperi dʉcacʉtiyiro. ");
INSERT INTO tue_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Too síro ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto wáa, cʉ̃ʉ̃rẽ sãĩñáwʉ̃: —¿Deero tiigʉ́ basocáre queorémena wedei? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús yʉʉwi: —Tíatopʉ masĩña maniríguere Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere mʉ́ãrẽ masĩrĩ tiia. Cʉ̃́ãpere masĩrĩ tiiría. ");
INSERT INTO tue_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ãñurõ tʉonʉnʉ́seranorẽ Cõãmacʉ̃ nemorṍ masĩré ticogʉdaqui. Pairó masĩré cʉoádacua. Tʉodʉgáheranorẽ cʉ̃́ã masĩmiriguere ẽmajãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cʉ̃́ã ĩñapacara, ĩñamasĩhẽrãbiro niijãya; tʉopacára, tʉohérabiro niijãya; tʉorácã, tʉomasĩ́riya. Teero tiigʉ́, cʉ̃́ãrẽ queorémena wedea. ");
INSERT INTO tue_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cʉ̃́ã biiro tiirémena Isaías jóarigue diamacʉ̃́ wáaa. Ateré jóarigʉ niiwĩ: Mʉ́ã tʉopacára, mʉ́ã tʉoáriguere tʉomasĩ́ridojãcu. Ĩñapacara, mʉ́ã ĩñaãriguere ĩñamasĩridojãcu. ");
INSERT INTO tue_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Atimacã́ macãrã wãcũriya. Tʉodʉgáriya. Capeari biaríra tiiróbiro niiĩya. Teero niijĩrã, wãcũpati, wasodʉgáriya. Teero tiigʉ́, yʉʉ cʉ̃́ãrẽ netõnéria, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mʉ́ãpeja ʉseniã. Mʉ́ã ĩñarére, mʉ́ã tʉorére tʉomasĩ́ã. ");
INSERT INTO tue_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Paʉ profetas, teero biiri paʉ basocá ãñurã́ mʉ́ã ĩñarére ĩñadʉgamiyira. Ĩñaririra niiwã. Mʉ́ã tʉorére tʉodʉgámiyira. Tʉorírira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ote wẽ́ẽbategʉ wáarigue queorére mʉ́ãrẽ wedequẽnogʉ̃da: ");
INSERT INTO tue_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sĩcʉ̃ basocʉ́ Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare quetire tʉopacʉ́, teeré tʉomasĩ́hẽrĩ, wãtĩãrẽ dutigʉ́ ati, cʉ̃ʉ̃ tʉomíãriguere ẽmapetijãqui. Cʉ̃ʉ̃ ẽmaãrigue maapʉ ñaacũmuãreperibiro niiã. ");
INSERT INTO tue_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Apeyepéri ʉ̃tãyepapʉ ñaacũmucu. Tiidita tee quetire tʉogʉ́ tiiróbiro niicu. Cʉ̃ʉ̃ máata ãñurõ ʉseniremena tʉomíqui, tʉogʉ́peja. ");
INSERT INTO tue_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nʉcõrĩ manijĩ́gʉ̃, yoari ʉseniriqui. Cʉ̃ʉ̃rẽ ñañarõ tiirí, o ãpẽrã́ tee quetire padeoré wapa cʉ̃ʉ̃rẽ ñañarõ netõrĩ́ tiirí, máata padeodújãqui. ");
INSERT INTO tue_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Apeyepéri pota watoapʉ ñaacũmucu. Tiidita tee quetire tʉogʉ́biro niicu. Cʉ̃ʉ̃ tʉomíqui, tʉogʉ́peja. Atibʉ́reco maquẽpere bayiró wãcũqui. “Ãñurõ niigʉ̃dacu pee apeyé cʉogʉ́” jĩĩ wãcũmiqui. Tee niipetire cãmotájãcu tee quetire. Dʉcamanigʉ̃ tiiróbiro niiqui. ");
INSERT INTO tue_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Apeyepéri ʉseniri ditapʉ ñaacũmucu. Tiidita tee quetire tʉogʉ́biro niicu. Cʉ̃ʉ̃ tʉomasĩ́qui. Cʉ̃ʉ̃ pee dʉcacʉtirigʉ tiiróbiro niiqui. Sicasati cienperi, apesatí sesentaperi, apesatí treintaperi dʉcacʉtirigʉ tiiróbiro niiqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús apeyé queorémena basocáre wedenemowĩ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã: Sĩcʉ̃ basocʉ́ cʉ̃ʉ̃ya wesepʉ ãñuréperi wẽ́ẽbateyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Niipetira cãnipetíari siro, cʉ̃ʉ̃rẽ ĩñatutigʉ atiyigʉ. Trigo watoapʉ ñañaré táare wẽ́ẽbate, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo wiimʉ́ã, dʉcacʉtiyiro; ñañarécã wii, bauáyiro. ");
INSERT INTO tue_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cʉ̃ʉ̃rẽ padecotera teeré ĩñarã, tiiwese õpʉ̃rẽ wedera wáayira. “Ʉ̃sãrẽ dutigʉ́, mʉʉya wesepʉ ãñuréperi dícʉ wẽ́ẽbatere niimiwʉ̃to. ¿Noopʉ́ atiyiri ñañaré táaja?” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Sĩcʉ̃ yʉʉre ĩñatutigʉ tee tiijĩ́yi”, jĩĩyigʉ. Cʉ̃ʉ̃rẽ padecotera sãĩñámiyira: “¿Táa wẽẽrã́ wáari boogári?” ");
INSERT INTO tue_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cʉ̃ʉ̃pe jĩĩyigʉ: “Táa wẽẽríjãña ména; trigosatiripere wããcõãrĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Teeménarã bʉcʉájããrõ ména, tée dʉca bʉcʉ niirĩpʉ. Bʉcʉ niirĩ, paderáre ticocogʉda, táa ñañarére wẽẽsʉguédutigʉ. Opadotori siatúdutigʉdacu, sóeya jĩĩgʉ̃. Túajeanʉcõ, trigore tʉ̃ne, ĩñanodutigʉdacu ĩñanori wiipʉ”, jĩĩyigʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús apeyé queorémena cʉ̃́ãrẽ wedenemowĩ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare sicape mostazape tiiróbiro niiã. Tiipegãrẽ sĩcʉ̃ basocʉ́ cʉ̃ʉ̃ya wesepʉ néewa, oteyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Péeripegã niipacaro, wiirópʉja, apeyé oteyucʉ nemorṍ ʉ̃mʉã́rigʉ bʉcʉácu; yucʉgʉ wáajãcu. Minipõná ati, tiigʉ́ dʉpʉripʉ põnacʉtícua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Apeyé queorémena cʉ̃́ãrẽ wedenemowĩ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare pã púuri tiiré tiiróbiro niiã. Sĩcõ numiṍ pã tiigódo itiápo harinapori pairí bapacapʉ poosã́yigo. Harinamena pã púuri tiirére wʉ́oyigo, niipetire púuaro jĩĩgõ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tee niipetire Jesús basocáre queorémena wedewi. Cʉ̃́ãrẽ cʉ̃ʉ̃ wederécõrõ queorémena dícʉ wedewi. ");
INSERT INTO tue_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cʉ̃ʉ̃ teero tiirémena profeta Isaías jóarigue diamacʉ̃́ wáaro tiiyíro. Ateré jóarigʉ niiwĩ: Queorémena basocáre wedegʉdacu. Cõãmacʉ̃ atibʉ́reco tiirípʉ masĩña manirére wedegʉdacu, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús basocáre “wáagʉ tiia” jĩĩ, wiipʉ́ sããwawi. Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉtopʉ sããwa, sãĩñáwʉ̃: —Táa ñañaré trigo wesepʉ queorére wedequẽnoña. ¿Deero jĩĩdʉgaro tiiárĩ? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Cʉ̃ʉ̃ yʉʉwi: —Yʉʉ niipetira sõwʉ̃ ãñuréperi oterigʉ tiiróbiro niiã. ");
INSERT INTO tue_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Atibʉ́reco tiiwese tiiróbiro niiã. Cõãmacʉ̃rẽ nʉnʉrã́ ãñuréperi tiiróbiro niiĩya. Wãtĩãrẽ nʉnʉrã́peja ñañaré táa tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wãtĩãrẽ dutigʉ́ ñañaré táare wẽ́ẽbategʉ tiiróbiro niiĩ. Atibʉ́reco petirí, trigo tʉ̃nerítono tiiróbiro niiãdacu. Ángelea trigo tʉ̃nerã́ tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ñañarére táa wẽẽ, pecamepʉ sóecõãjãnocu. Teero tiiróbirora wáaadacu atibʉ́reco petirí. ");
INSERT INTO tue_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉʉ niipetira sõwʉ̃ ángeleare niipetiropʉ ticocogʉdacu. Cʉ̃́ã niipetira ñañaré tiirí tiiráre, teero biiri niipetira Cõãmacʉ̃ dutirére netõnʉcã́rãrẽ néõãdacua. ");
INSERT INTO tue_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cʉ̃́ãrẽ pecamepʉ cõãjããdacua. Toopʉ́ cʉ̃́ã pũnisíra bacadiyó, utiadacua. ");
INSERT INTO tue_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Too síro Cõãmacʉ̃ dutirére tiirápeja marĩ Pacʉ niirṍpʉ muĩpũ bʉ́reco macʉ̃ tiiróbiro asibatéadacua. Tʉodʉgárano tʉomasĩ́ãdacua. ");
INSERT INTO tue_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare wapapacáre oterí dita popeapʉ yaacṹre tiiróbiro niiã. Sĩcʉ̃ basocʉ́ teeré bʉa, toopʉ́ra yaacṹjãqui sũcã. Ʉseniremena wáa, niipetire cʉ̃ʉ̃ cʉorére dúapetijãqui. Tee dúa wapatáremena tiiditare sãĩnéjãqui. ");
INSERT INTO tue_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare sĩcʉ̃ dúanetõri basocʉ ãñuréperi “perla” wãmecʉtirere ãmaãnetõgʉ̃ tiiróbiro biia sũcã. ");
INSERT INTO tue_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cʉ̃ʉ̃ sicape pairó wapacʉtíripere bʉagʉ́, wáa cʉ̃ʉ̃ cʉorére dúapetijãqui. Cʉ̃ʉ̃ dúa wapatáremena tiipere sãĩnéjãqui. ");
INSERT INTO tue_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã sũcã. Wai wasará bapigʉcare día pairímaapʉ cõãñorĩ, wai noo niirã́cõrõ ñeecu. ");
INSERT INTO tue_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tiigʉ́ dadari ĩña, ditatuparigʉpʉ wéemacũmu, beseduicua. Ãñurã́rẽ piipʉ besesãcua; ñañarã́rẽ cõãjãcua. ");
INSERT INTO tue_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Atibʉ́reco petirí, teerora wáaadacu. Ángelea ati, basocá ñañarã́rẽ beseadacua ãñurã́ watoapʉ niirã́rẽ. ");
INSERT INTO tue_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ángelea cʉ̃́ãrẽ pecamepʉ cõãjããdacua. Toopʉ́ cʉ̃́ã pũnisíra bacadiyó, utiadacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús ʉ̃sãrẽ sãĩñáwĩ: —¿Tee niipetirere tʉoi mʉ́ã? jĩĩwĩ. —Ʉ̃́jʉ̃, tʉoa, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ʉ̃sãrẽ jĩĩwĩ: —Moisés jóarigue buerá sĩquẽrã Cõãmacʉ̃ dutiré cʉ̃́ãpʉre niiãdarere ãñurõ tʉomasĩ́cua. Cʉ̃́ã ãñurõ buera, masĩrã́ wáacua. Teero tiirá, cʉ̃́ã wii cʉorá tiiróbiro niicua. Cʉ̃́ã ĩñanorõpʉ niirére masĩcua. Teero tiirá, mama ãñurére, bʉcʉ ãñurére néewionecomasĩcua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús tee queoré wedeari siro, wáajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nazaret cʉ̃ʉ̃ masãri macãpʉ coepʉtʉ́awi. Toopʉ́ cʉ̃́ã neãrí wiipʉ buenʉcãwĩ. Cʉ̃ʉ̃ buerére tʉorá, tʉomaníjõã, cãmerĩ́ jĩĩrira niiwã: —¿Noopʉ́ bueyiri ãni nocõrõ masĩgʉ̃́? ¿Cʉ̃ʉ̃ deero tiigʉ́ tee tiiẽ́ñoriguere tiimasĩ́ĩ? ");
INSERT INTO tue_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ãni táboa paderigʉ macʉ̃ niiĩ; cʉ̃ʉ̃ paco María wãmecʉtiyo; Santiago, José, Simón, Judas cʉ̃ʉ̃ baira niiĩya; ");
INSERT INTO tue_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","niipetira cʉ̃ʉ̃ baira numiãcã ãno marĩ watoapʉ niiĩya, ¿teerora? ¿Noopʉ́ tee niipetirere masĩyiri? jĩĩrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Teeré wãcũrã, cʉ̃ʉ̃rẽ padeodʉgáriyira. Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Niipetira apeyé macãrĩ macãrã sĩcʉ̃ profetare padeocúa. Cʉ̃ʉ̃ya dita macãrã, cʉ̃ʉ̃ya wii macãrã doca cʉ̃ʉ̃rẽ padeorícua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Toopʉ́re cʉ̃́ã padeohéri ĩñagʉ̃, pee cʉ̃ʉ̃ tutuaremena tiiẽ́ñoriwi. ");
INSERT INTO tue_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Teebʉrecorire Herodes Galilea dita dutigʉ́ Jesús tiiré quetire tʉoyígʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Cʉ̃ʉ̃rẽ padecoterare jĩĩyigʉ: —Cʉ̃ʉ̃ Juan basocáre wãmeõtiri basocʉ niiqui. Masãgʉ̃ masãjĩyi. Teero tiiró, cʉ̃ʉ̃pʉre tutuare niicu, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes too sʉgueropʉ Juanrẽ́ peresuwiipʉ néewa, siatúcũdutiyigʉ. Herodías cʉ̃ʉ̃ bai Felipe nʉmo niimirigo ʉsenigõ niiãrõ jĩĩgʉ̃, teero tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan Herodere: —Mʉʉ coore nʉmocʉtimasĩria, jĩĩrucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes Juanrẽ́ sĩãdʉgápacʉ, basocáre cuiyigʉ. Cʉ̃́ãpe “Juan profeta niiĩ” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes cʉ̃ʉ̃ bauári bʉreco jeari, Herodías macõ cʉ̃ʉ̃ boocórira pʉtopʉ basaẽñoyigo. ");
INSERT INTO tue_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodes coo basaẽñorere bayiró tʉsayigʉ. Teero tiigʉ́, “niirṍrã” jĩĩgʉ̃, biiro jĩĩyigʉ: —Noo mʉʉ sãĩrénorẽ ticogʉda, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Coo paco wedenoãrigo niijĩgõ, Herodere jĩĩyigo: —Mecʉ̃tígãrã opasida bapamena Juan basocáre wãmeõtiri basocʉya dupure néesã, ticoya, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Coo teero jĩĩrĩ tʉogʉ́, Herodes wãcũpatiyigʉ. Cʉ̃ʉ̃ boocórira tʉocóropʉ “niirṍrã mʉʉrẽ ticogʉda” jĩĩãrigʉ niijĩgʉ̃, ticodutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Juanyá dupure páatadutiyigʉ peresuwiipʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Páataari siro, cʉ̃ʉ̃ya dupure opasida bapamena néesã, néewa, ticoyira. Coope coo pacopʉ́re ticonetõneyigo. ");
INSERT INTO tue_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan buerére nʉnʉmíãrira toopʉ́ wáa, cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ née, ʉ̃tãtutipʉ cṹũrã wáarira niiwã. Too síro Jesuré wedera jeawa. ");
INSERT INTO tue_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús tee quetire tʉogʉ́, sĩcʉ̃rã niidʉgamiyigʉ. Dooríwʉpʉ mʉãsã, basocá manirṍpʉ wáajõãwĩ. Basocápe tʉojã́rira niiwã. Teero tiirá, teemacãrĩ macãrã nʉnʉwárira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús dooríwʉpʉ sãñaãrigʉ duinʉcã́, basocá paʉre ĩñawĩ. Cʉ̃́ãrẽ bóaneõ ĩñawĩ. Diarecʉtira cʉ̃́ã néeatiarirare netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Náĩcũmuatiri, ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto wáa, jĩĩwʉ̃: —Ñamicapʉ niiã. Ãnopʉ́ macã manirṍpʉ niiã. Basocáre “nocõrõrã niiã” jĩĩña. Pʉtogã niiré macãrĩpʉ cʉ̃́ã yaaré sãĩ, yaara wáaaro, jĩĩmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Wáarijããrõ. Mʉ́ã cʉ̃́ãrẽ yaaré ecayá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Jã́ã; sicamoquẽñepa pã, wai pʉarã́rã cʉoa, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Néeatiya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Too síro Jesús basocáre táa sotoapʉ duidutiwi. Tee sicamoquẽñepa pãrẽ, wai pʉarã́rẽ née, ʉ̃mʉã́sepʉ ĩñamʉõco, Cõãmacʉ̃rẽ ʉsenire ticowi. Túajea, pãrẽ pʉatásã, ʉ̃sã cʉ̃ʉ̃ bueráre ticowi. Ʉ̃sãpe basocáre batowʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Niipetira yaa, yapijõãwã. Yaatoaari siro, doce piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpówʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Teeré yaarira ʉ̃mʉã́ dícʉre bapaqueori, cinco mil watoa niiwã. Numiã́, wĩmarã bapaqueoya maniwã́. ");
INSERT INTO tue_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Too síro Jesús ʉ̃sã cʉ̃ʉ̃ bueráre cʉ̃ʉ̃ jeaariwʉpʉ jeasãduti, tĩãwasʉguedutiwi. Ʉ̃sã wáari, cʉ̃ʉ̃pe basocáre “wáagʉ tiia” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cʉ̃́ãrẽ teeré jĩĩãri siro, ʉ̃tãgʉ̃pʉ́ cʉ̃ʉ̃ sĩcʉ̃rã Cõãmacʉ̃mena wedesegʉ mʉãwayigʉ. Náĩcũmuãri siro, sĩcʉ̃rã niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ʉ̃sãpe yoaropʉ niitoawʉ tĩãwara. Wĩno páapucãmotari, ocoturí páabatesãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bóemʉãatiri, Jesús ʉ̃sã pʉtopʉ atigʉ, oco sotoápʉ atijõãatiwi. ");
INSERT INTO tue_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ʉ̃sã cʉ̃ʉ̃rẽ oco sotoápʉ atiri ĩñarã, ʉcʉápetijõãwʉ̃. “¡Abʉ! ¡Basocʉ́ diarigʉ wãtĩ niiqui!” jĩĩmiwʉ̃. Cuira, bayiró acaribíwʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Máata Jesús ʉ̃sãrẽ jĩĩwĩ: —Wãcũtutuaya. Yʉʉ niiã. Cuirijãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro cʉ̃ʉ̃rẽ jĩĩwĩ: —Õpʉ̃, mʉʉ niigʉ̃, yʉʉre mʉʉ pʉto oco sotoápʉ wáari tiiyá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Atiya, jĩĩwĩ. Pedro diiwá, oco sotoápʉ Jesús pʉtopʉ wáamiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wĩno bayiró páapucori ĩñagʉ̃, cuiwi. Duadianʉcãgʉ̃, bayiró bʉsʉrómena: —¡Õpʉ̃, yʉʉre netõnéña! jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Máata Jesús cʉ̃ʉ̃ya wãmomena cʉ̃ʉ̃rẽ ñee, jĩĩwĩ: —Mʉʉ péerogã padeoré cʉogʉ́, ¿deero tiigʉ́ “oco sotoápʉ wáari tiimasĩ́riqui” jĩĩ wãcũãrĩ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cʉ̃́ã dooríwʉpʉ mʉãsãrĩ, wĩno netõjṍãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Teero wáari ĩñarã, ʉ̃sã tiiwʉpʉ́ niirã́ Jesuré padeorá ñicãcoberimena jeacũmuwʉ̃. Cʉ̃ʉ̃rẽ: —Niirṍrã mʉʉ Cõãmacʉ̃ macʉ̃ niiã, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ʉ̃sã tĩãjeara, Genesaretpʉ maajeáwʉ. ");
INSERT INTO tue_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Too macãrã Jesuré ĩñamasĩrã, cʉ̃ʉ̃ jeari ĩña, niipetiro tiiditapʉ wededutirira niiwã. Niipetira diarecʉtirare cʉ̃ʉ̃ pʉtopʉ néejeawa. ");
INSERT INTO tue_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesuré sãĩwã́: —Mʉʉyaro sutiró yapa dícʉre padeñáma, jĩĩwã. Niipetira padeñáãrira netõjṍãwã. ");
INSERT INTO tue_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Too síro fariseo basoca, Moisés jóarigue buerá Jerusalénpʉ atiarira Jesús pʉtopʉ jea, sãĩñáwã: ");
INSERT INTO tue_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Deero tiirá mʉʉ buerá marĩ ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere netõnʉcã́ĩ? Yaaadari sʉguero, cʉ̃́ã marĩ ñecʉ̃sʉ̃mʉã tiirucúrobiro wãmocoseriya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús cʉ̃́ãrẽ yʉʉwi: —¿Deero tiirá mʉ́ãcã Cõãmacʉ̃ dutirére netõnʉcã́ĩ? Cõãmacʉ̃ dutirére nemorṍ mʉ́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiidʉgácu. ");
INSERT INTO tue_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cõãmacʉ̃ ateré dutirigʉ niiwĩ: “Mʉʉ pacʉ, mʉʉ pacore padeoyá. Cʉ̃́ãrẽ ñañarõ wedesegʉnorẽ sĩãcõã́jããrõ”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mʉ́ãpe merẽã dutijãã. Basocáre cʉ̃́ã pacʉre, cʉ̃́ã pacore “yʉʉ mʉ́ãrẽ tiiápumasĩriga; yée niyeru mʉ́ãrẽ ticoboariguere Cõãmacʉ̃rẽ ticopetijãwʉ̃” jĩĩdutia mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mʉ́ã teero dutira, cʉ̃́ã pacʉsʉ̃mʉãrẽ “padeoríjãña” jĩĩrã tiia. Teero tiirá, Cõãmacʉ̃ dutirére teero peti ĩñacõãjãã, mʉ́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiidʉgára. ");
INSERT INTO tue_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mʉ́ã basocá ĩñahẽrõpʉ ñañaré tiirá niiã. Teero tiirá, tiiditórepira niiã. Isaías mʉ́ã mecʉ̃tígã tiirére diamacʉ̃́rã jóasʉguerigʉ niiwĩ. Cʉ̃ʉ̃ jóariguere ãñurõ tʉoádacu mʉ́ã: ");
INSERT INTO tue_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ãniã basocá ʉseromena dícʉ yʉʉre padeoóya. Cʉ̃́ã tʉgueñarepe noopʉ́ niirõ niicu. ");
INSERT INTO tue_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bʉ́ri peti neããya. Yée maquẽrẽ “bueada” jĩĩpacara, basocá jĩĩrére buejãya, jĩĩti Cõãmacʉ̃, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Cʉ̃́ãrẽ teero jĩĩãri siro, basocáre neãduti, cʉ̃́ãcãrẽ jĩĩwĩ: —Yée maquẽrẽ tʉomasĩ́ãda jĩĩrã, tʉorá atiya: ");
INSERT INTO tue_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Basocáre ʉseropʉ sããware cʉ̃́ãrẽ ñañarã́ wáari tiiría. Cʉ̃́ã ʉseropʉ witiatirepe cʉ̃́ãrẽ ñañarã́ wáari tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto wáa, jĩĩwʉ̃: —¿Mʉʉ masĩĩ? Mʉʉ teero jĩĩãriguere tʉorá, fariseo basoca cúajõããwã. ");
INSERT INTO tue_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús queorémena yʉʉwi: —Yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ cʉ̃ʉ̃ oteririgʉnorẽ nʉcõrĩmena wãã, cõãjãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Teero tiirá, cʉ̃́ãrẽ teero ĩñajãña. Cʉ̃́ã Cõãmacʉ̃ boorére masĩdʉgahera niijĩrã, ĩñahẽrã, ãpẽrã́ ĩñahẽrãrẽ wéesʉguera tiiróbiro niiĩya. Sĩcʉ̃ ĩñahẽgʉ̃ ãpĩ ĩñahẽgʉ̃rẽ wéesʉgueri, cʉ̃́ã pʉarã́pʉra copepʉ ñaacosããdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro cʉ̃ʉ̃rẽ jĩĩwĩ: —Ʉ̃sãrẽ wedeya. Mʉʉ queorémena jĩĩãrigue ¿deero jĩĩdʉgaro tiigári? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús jĩĩwĩ: —¿Mʉ́ãcã ateré tʉomasĩ́rii ména? ");
INSERT INTO tue_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Niipetire basocáre ʉseropʉ sããware páagapʉ wáa, too síro netõcówitiwacu. ");
INSERT INTO tue_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ʉseropʉ witiatirepeja cʉ̃́ã wãcũrépʉ witiaticu. Teerá basocáre ñañarã́ wáari tiia. ");
INSERT INTO tue_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Basocá popeapʉ, cʉ̃́ã wãcũrépʉre ate witiaticu: ñañarõ wãcũré, basocáre sĩãcõã́re, ãpĩ nʉmorẽ ñeeapere, apegó manʉrẽ ñeeapere, ãpẽrãména ñañarõ ñeeapere, yaaré, jĩĩditore, ãpẽrãrẽ́ ñañarõ wedesere witiaticu. ");
INSERT INTO tue_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Teerá basocáre ñañarã́ wáari tiia. Wãmocoseripacara yaari, basocáre ñañarã́ wáari tiirícu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Too niiãrigʉ witiwa, Tiro, Sidón macãrĩ wesapʉ wáawi. ");
INSERT INTO tue_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Toopʉ́ sĩcõ numiṍ cananeayo tiidita niigṍ bayiró bʉsʉrómena ati, jĩĩwõ: —Yʉʉ Õpʉ̃, David pãrãmi niinʉnʉsegʉ, yʉʉre bóaneõ ĩñaña. Yʉʉ macõ wãtĩ sããnorigo bayiró ñañarõ netõyo, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús coore yʉʉrinetõnecojãwĩ. Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ jĩĩwʉ̃: —Coore wáaduticoya; marĩ siro bayiró bʉsʉrómena sãĩnʉnʉ́seyo, jĩĩmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Cõãmacʉ̃ yʉʉre Israelya põna macãrã dícʉre tiiápudutigʉ ticodiocowi. Cʉ̃́ã oveja ditirira tiiróbiro niiĩya, jĩĩ yʉʉwi. ");
INSERT INTO tue_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Coo cʉ̃ʉ̃ pʉto jea, ñicãcoberimena jeacũmuwõ. —Õpʉ̃, yʉʉre tiiápuya, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Wĩmarãpere ecasʉguéro booa cʉ̃́ã yaadʉgarecõrõ. Cʉ̃́ã yaarére ẽma, cʉ̃́ãyara díayiare cõãcũrĩ, ãñuria, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Coocã queorémena yʉʉwo: —Õpʉ̃, tee diamacʉ̃́rã niiã. Díayia cʉ̃́ã õpãrã́ mesapʉ duirá cʉ̃́ã yaadiocore manarĩrẽ yaacua, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Mʉʉ doca padeoré cʉonetṍjõãã. Mʉʉ sãĩã́rirobirora wáaaro, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩrĩrã, máata coo macõ wãtĩ manigṍ pʉtʉárigo niiwõ. ");
INSERT INTO tue_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús too niiãrigʉ wáa, Galileataro wesapʉ netõwáwi. Ʉ̃tãgʉ̃pʉ́ mʉãwa, jeanuãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Naĩrõ paʉ basocá cʉ̃ʉ̃ pʉtopʉ jeara tiiwá. Cʉ̃́ã wáamasĩhẽrãrẽ, wãmorĩ, dʉpori posarirare, ĩñahẽrãrẽ, wedeseherare, ãpẽrã́ diarecʉtira paʉre néejeawa. Cʉ̃ʉ̃ pʉtopʉ cṹũwã. Cʉ̃́ãrẽ netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Basocá ĩñamanijõãwã. Wedesehera niiãrira wedeseri ĩñarã, wãmorĩ, dʉpori posarira netõnénorĩ ĩñarã, wáamasĩhẽrã niiãrira wáari ĩñarã, ĩñahẽrã niiãrira ĩñarĩ ĩñarã, ĩñamanijõãwã. “Marĩ Israelya põna macãrã Õpʉ̃ Cõãmacʉ̃ ãñunetõjõãĩ”, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Too síro Jesús ʉ̃sã cʉ̃ʉ̃ bueráre sʉocó, jĩĩwĩ: —Yʉʉ ãniãrẽ bóaneõ ĩñajõãga. Cʉ̃́ã yʉʉmena niirṍ itiábʉreco netõã. Teero tiirá, cʉ̃́ã yaaré petinójõãya. Yʉʉ cʉ̃́ãrẽ jʉabóaremena pʉtʉawadutidʉgariga. Maapʉ tʉomasĩ́re petijṍãbocua, jĩĩwĩ. Ʉ̃sã cʉ̃ʉ̃ buerápeja jĩĩwʉ̃: ");
INSERT INTO tue_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Marĩ ãno basocá manirṍpʉ niiã. ¿Noopʉ́ ãniã paʉre yaaré nocõrõca bʉa ecabógari? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Noquẽpa pã cʉoi? jĩĩwĩ. —Sietepa, teero biiri wai metãrãgã pʉarã́gã cʉoa, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús basocáre yepapʉ duidutiwi. ");
INSERT INTO tue_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pã sietepare, waire née, Cõãmacʉ̃rẽ ʉsenire ticowi. Túajea, pʉatásã, ʉ̃sã cʉ̃ʉ̃ bueráre ticowi. Ʉ̃sãpe basocáre batowʉ. ");
INSERT INTO tue_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Niipetira yaa, yapijõãwã. Yaatoaari siro, siete piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpówʉ. ");
INSERT INTO tue_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Teeré yaarira ʉ̃mʉã́ dícʉre bapaqueori, cuatro mil niiwã. Numiã́, wĩmarã bapaqueoya maniwã́. ");
INSERT INTO tue_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basocáre pʉtʉawadutiari siro, Jesús dooríwʉpʉ mʉãsã, Magdala wãmecʉtiropʉ wáajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo basoca, saduceo basoca Jesús pʉtopʉ jeawa. “¿Niirṍrã cʉ̃ʉ̃ Cõãmacʉ̃ ticodiocorigʉ niiĩ?” jĩĩrã, cʉ̃ʉ̃rẽ Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñodutimiwã. ");
INSERT INTO tue_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesupéja cʉ̃́ãrẽ yʉʉwi: —Muĩpũ sããwari, mʉ́ã ʉ̃mʉã́sere ĩñarã, “muĩpũ ãñurõ sõãsãĩ; teero tiiró, ñamigã ãñurõ cʉ̃maã́dacu” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bóeri ñiitiáwãcãrĩ ĩñarã, “mecʉ̃ã oco peaadacu” jĩĩã. Ʉ̃mʉã́se maquẽ ĩñarã, “biiro wáaadacu” jĩĩmasĩã. Teero masĩpacara, atitó wáarepere ĩñarã, “biiro jĩĩdʉgaro tiia” jĩĩmasĩridojãã. ");
INSERT INTO tue_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mʉ́ã atitó macãrã ñañaré tiirá, Cõãmacʉ̃rẽ boohéra niiã; Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere ĩñadʉgacu. Jonás tiirígue tiiróbiro niiré dícʉre ĩñaãdacu, jĩĩwĩ. Cʉ̃́ãrẽ cõãwagʉ, aperopʉ́ wáawi. ");
INSERT INTO tue_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ʉ̃sã cʉ̃ʉ̃ buerá apeniñapʉ́ tĩãwawʉ. Toopʉ́ jeara, pã ʉ̃sã yaaadarere acabójãrira niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús ʉ̃sãrẽ jĩĩwĩ: —Fariseo basocaye, saduceo basocaye pã púuri tiirére tʉomasĩ́rõ booa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ jĩĩãriguere tʉomasĩ́rijĩrã: —Pã marĩ néeatiriatʉ; teero tiigʉ́ teero jĩĩqui, jĩĩmiwʉ̃ ʉ̃sã basiro. ");
INSERT INTO tue_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ʉ̃sã teero jĩĩãriguere masĩjãrigʉ niiwĩ. Teero tiigʉ́, jĩĩwĩ: —¿Deero tiirá mʉ́ã “pã maniã” jĩĩ cãmerĩ́ wedesei? Mʉ́ã péerogã padeoré cʉorá niiã. ");
INSERT INTO tue_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉ́ã tʉomasĩ́rii ména? Sicamoquẽñe pãmena cinco mil ʉ̃mʉã yaaari siro, ¿noquẽ piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpóri? ¿Wãcũrii? ");
INSERT INTO tue_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Too síro siete pãmena cuatro mil ʉ̃mʉã yaaari siro, ¿noquẽ piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpóri? ¿Wãcũrii? ");
INSERT INTO tue_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Deero tiirá mʉ́ã tʉomasĩ́rii? Yʉʉ fariseo basocaye, saduceo basocaye pã púuri tiiré wedesegʉ, pã meerẽ jĩĩãwʉ̃. “Cʉ̃́ãye pã púuri tiirére tʉomasĩ́rõ booa” jĩĩãwʉ̃, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cʉ̃ʉ̃ teero jĩĩrĩpʉra, ʉ̃sãrẽ tʉomasĩ́re jeawʉ. “Marĩrẽ pã púuri tiiré wedesegʉ mee tiiáyi. ‘Fariseo basoca, saduceo basoca cʉ̃́ã jĩĩditoremena buerépere tʉomasĩ́rõ booa’ jĩĩgʉ̃ tiiáyi”, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús Cesarea Filipoya macã wesapʉ wáawi. Toopʉ́ jea, ʉ̃sãrẽ cʉ̃ʉ̃ bueráre sãĩñáwĩ: —Basocá yʉʉ niipetira sõwʉ̃rẽ ¿deero wedesei? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ʉ̃sã jĩĩwʉ̃: —Sĩquẽrã mʉʉrẽ “Juan basocáre wãmeõtiri basocʉ niiqui” jĩĩĩya. Ãpẽrã́ “Elías niiqui” jĩĩĩya. Ãpẽrã́ “Jeremías niiqui; o ãpĩ profeta niigʉ̃ niiqui” jĩĩĩya, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Mʉ́ãte “¿noã niiĩ?” jĩĩĩ yʉʉre? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro yʉʉwi: —Mʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã; Cõãmacʉ̃ catirucugʉ macʉ̃ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Simón, Jonás macʉ̃, mʉʉ teero wedesegʉ, queoróra wedesea. Sĩcʉ̃ basocʉ́ mʉʉrẽ teeré wederiajĩyi. Yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ mʉʉrẽ tee masĩrére ticoajĩyi. Teero tiigʉ́, ʉsenire cʉogʉ́ niiã mʉʉ. ");
INSERT INTO tue_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ate yʉʉ jĩĩrécãrẽ tʉoyá mʉʉ: Mʉʉ Pedro niiã. (Pedro “ʉ̃tãgã” jĩĩdʉgaro tiia.) Sicawií tiigá ʉ̃tãgã sotoapʉ tiirí wiibiro yʉʉre padeoráre sicapõna macãrã wáari tiigʉ́da. Wãtĩ cʉ̃ʉ̃yaramena yáa põna macãrãrẽ docacũmurĩ tiiríqui. ");
INSERT INTO tue_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yʉʉ mʉʉrẽ ʉ̃mʉã́sepʉ marĩ Õpʉ̃ niirṍpʉ macã sáwibiro niirére ticogʉdacu. Mʉʉ teeména atibʉ́recopʉre “Cõãmacʉ̃ dutiré mee niiã”, jĩĩ cãmotári, ʉ̃mʉã́sepʉcãrẽ cãmotánoãdacu. Teero biiri atibʉ́recopʉre mʉʉ “Cõãmacʉ̃ dutiré niiã” jĩĩrĩ, ʉ̃mʉã́sepʉcãrẽ cãmotáya maniã́dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Too sírogã jĩĩwĩ sũcã: —Yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiré maquẽrẽ ãpẽrãrẽ́ wederijãña, jĩĩ wedewi. ");
INSERT INTO tue_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ate síromena Jesús ʉ̃sã cʉ̃ʉ̃ bueráre cʉ̃ʉ̃rẽ too síro wáaadarere wedenʉcãwĩ. —Yʉʉre Jerusalénpʉ wáaro niijããdacu. Toopʉ́re bʉtoá dutirá, paiaré dutirá, Moisés jóarigue buerá yʉʉre bayiró ñañarõ netõrĩ́ tiiádacua. Yʉʉre sĩãdutíadacua. Cʉ̃́ã teero tiipacári, itiábʉreco siro masãgʉ̃dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Teeré tʉogʉ́, Pedro Jesuré ãpẽrã́ tʉohéropʉ néewa, wedenʉcãrigʉ niimiwĩ: —Yʉʉ Õpʉ̃, Cõãmacʉ̃ teero wáari jĩĩgʉ̃, cãmotáaro. Mʉʉ teero jĩĩãrigue wáarijããrõ, jĩĩrigʉ niimiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús cãmenʉcã́, Pedrore jĩĩrigʉ niiwĩ: —Satanás tiiróbiro wedesegʉ tiia mʉʉjã. “¡Satanás, wáajõãgʉa; yʉʉ pʉtore niirijãña!” jĩĩã. Pedro, mʉʉ teero jĩĩgʉ̃, Cõãmacʉ̃ yʉʉre dutirére cãmotádʉgagʉ tiia. Mʉʉ masĩria Cõãmacʉ̃ wãcũrére; basocá wãcũrõbiro wãcũã, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Too síro Jesús ʉ̃sãrẽ jĩĩwĩ: —Sĩcʉ̃ yʉʉre padeó, nʉnʉdʉgágʉno cʉ̃ʉ̃ booró tiidʉgárenorẽ tiidújããrõ. Basocá cʉ̃ʉ̃rẽ ñañarõ jĩĩpacari, yʉʉre tʉonʉnʉ́searo. Teeré tiigʉ́, curusare apagʉ́ tiiróbiro niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ãpĩ sĩãrére cuigʉno yʉʉre “masĩria” jĩĩgʉ̃́ pecamepʉ wáagʉdaqui. Ãpĩpé yʉʉre “masĩã” jĩĩ, teewapamena cʉ̃ʉ̃rẽ sĩãrĩ́, yʉʉmena catirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sĩcʉ̃ atibʉ́reco maquẽ niipetirere wapatápacʉ, cʉ̃ʉ̃ yeeripũnarẽ tiidióri, cʉ̃ʉ̃ cʉoré dee tiiádare niiricu. Cʉ̃ʉ̃ catiré petihére ñeenómena wapatíriqui. ");
INSERT INTO tue_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉʉ niipetira sõwʉ̃ yʉʉ Pacʉ asibatéremena, ángeleamena pʉtʉaatigʉdacu atibʉ́recopʉre. Pʉtʉaati, niipetirare cʉ̃́ã tiiríguecõrõrẽ wapa tiigʉ́dacu. ");
INSERT INTO tue_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩquẽrã ãnopʉ́ niirã́ cʉ̃́ã diaadari sʉguero, yʉʉ niipetira sõwʉ̃ õpʉ̃ sããgʉ̃ atiri ĩñaãdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis bʉrecori siro Jesús ʉ̃tãgʉ̃́ ʉ̃mʉã́rigʉpʉ mʉãwawi. Tiigʉpʉ́ wáagʉ, Pedro, Santiago, cʉ̃ʉ̃ bai Juanrẽ́ néewawi. ");
INSERT INTO tue_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Toopʉ́ cʉ̃́ã ĩñarĩ, Jesús cʉ̃ʉ̃ baurécʉtirere wasojṍãyigʉ. Cʉ̃ʉ̃ya diapóa muĩpũ bʉ́reco macʉ̃ tiiróbiro asiyáyiro. Cʉ̃ʉ̃ye suti bʉpo wã́ãyore tiiróbiro butiré wáayiro. ");
INSERT INTO tue_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Teero wáari, Moisés, Elías bauánʉcã, cʉ̃ʉ̃mena wedesera tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro Jesuré jĩĩyigʉ: —Ʉ̃sã Õpʉ̃, marĩ ãnopʉ́ niirĩ, ãñunetõjõãã. Mʉʉ boorí, ãno itiáwiigã tiigʉ́da; sicawiígã mʉʉya wii, apewiígã Moiséya wii, apewiígã Elíaya wii tiigʉ́da, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cʉ̃ʉ̃ wedesegʉ tiiríra, õme capemóre diiáti, cʉ̃́ãrẽ tuubiátocojãyiro. Õme watoapʉ sĩcʉ̃ wedeseri tʉoyíra: —Ãni yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́ niiĩ. Cʉ̃ʉ̃mena bayiró ʉseniã. Cʉ̃ʉ̃rẽ tʉoyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cʉ̃ʉ̃ buerá teeré tʉorá, bayiró cuira, ditapʉ diapóarire munibiácũmujeayira. ");
INSERT INTO tue_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús jea, cʉ̃́ãrẽ ñaapeó: —Wʉ̃mʉnʉcãña; cuirijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cʉ̃́ã ĩñamʉõcori, ãpẽrã́ maniyíra. Jesús dícʉre ĩñayira. ");
INSERT INTO tue_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cʉ̃́ã ʉ̃tãgʉ̃pʉ́ niiãrira diiátiri, Jesús jĩĩyigʉ: —Mʉ́ã ĩñaãriguere wederijãwa ména; tée yʉʉ niipetira sõwʉ̃ dia masãri siropʉ, wedewa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cʉ̃ʉ̃ buerá sãĩñáyira: —Too docare ¿deero tiirá Moisés jóarigue buerá “Cõãmacʉ̃ beserigʉ atiadari sʉguero, Elías atisʉguegʉdaqui” jĩĩ buei? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Elías atisʉguere, niipetire quẽnosʉguéadare diamacʉ̃́rã niiã. ");
INSERT INTO tue_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yʉʉre tʉoyá: Elías jeatoawi mée. Cʉ̃ʉ̃rẽ basocá ĩñamasĩririra niiwã. Cʉ̃ʉ̃rẽ cʉ̃́ã booró tiidʉgáriguere tiitóarira niiwã. Teero tiiróbiro yʉʉ niipetira sõwʉ̃cã cʉ̃́ã ñañarõ tiirí, ñañarõ netõgʉ̃́dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cʉ̃ʉ̃ teero jĩĩrĩpʉra, cʉ̃ʉ̃ bueráre tʉomasĩ́re jeayiro. “Juan basocáre wãmeõtiri basocʉye maquẽrẽ wedesegʉ tiiájĩyi”, jĩĩ masĩrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Too síro cʉ̃́ã paʉ basocá niirṍpʉ diijeári, sĩcʉ̃ Jesús pʉtopʉ wáa, ñicãcoberimena jeacũmu, jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Õpʉ̃, yʉʉ macʉ̃rẽ bóaneõña. Cʉ̃ʉ̃ ñama diaré cʉogʉ́ niiĩ. Bayiró peti ñañarõ netõĩ. Pee peti pecamepʉ ñaacũmu, díapʉcãrẽ ñaañuãrucui. ");
INSERT INTO tue_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉʉ bueráre néeatimiãwʉ̃. Netõnémasĩriawã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã yʉʉre padeorídojãã; ñañarã́ niiã. Yʉʉ mʉ́ãmena yoari niirucujãrĩcãrẽ, padeoríbocu. ¿Nocõrõ yoari mʉ́ãmena põõtẽ́õgʉ̃dari yʉʉ? Néeatiya ãnopé wĩmagʉ̃rẽ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús wĩmagʉ̃pʉre niiãrigʉ wãtĩrẽ witiwadutiwi. Teero tiigʉ́, witiwarigʉ niiwĩ. Máata wĩmagʉ̃ netõjṍãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Too síro ʉ̃sã Jesús buerá ãpẽrã́ tʉohéropʉ wáa, cʉ̃ʉ̃rẽ sãĩñáwʉ̃: —¿Deero tiirá ʉ̃sã wãtĩrẽ cõãwionecomasĩriayiri? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Mʉ́ã péerogã padeoré cʉorá niiã. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mostazape péeripegã niiã. Mʉ́ã padeoré tiipecõrõgã niirĩ, atigʉ́ ʉ̃tãgʉ̃rẽ́, “jõõpʉ wáaya” jĩĩboajĩyu. Mʉ́ã teero jĩĩrĩ, jõõpʉ wáaboajĩyu. Mʉ́ã padeoré cʉorí, wisióre maniã́dacu. ");
INSERT INTO tue_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ãninó wãtĩrẽ cõãwionecodʉgara, Cõãmacʉ̃rẽ sãĩ, betirémena dícʉ cõãrõ booa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Too síro ʉ̃sã Galileapʉ niiwarucuri, Jesús ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ niipetira sõwʉ̃ ãpẽrãpʉ́re ticonogʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yʉʉre sĩãã́dacua. Cʉ̃́ã teero tiipacári, itiábʉreco siro masãgʉ̃dacu, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, bayiró wãcũpatira pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Too síro ʉ̃sã Capernaumpʉ jeari, Cõãmacʉ̃wii maquẽ niiãdarere niyeru wapasébosari basoca Pedro pʉtopʉ wáa, sãĩñáyira: —¿Mʉ́ãrẽ buegʉ́ Cõãmacʉ̃wii maquẽ niiãdarere niyeru wapatírigari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Wapatíqui, jĩĩyigʉ. Wiipʉ́ sããjeari, Jesús cʉ̃ʉ̃rẽ wedesesʉguewi: —Simón, ¿ateré deero wãcũĩ mʉʉ? Atibʉ́reco macãrã õpãrã́ ¿noãrẽ́ niyeru wapasédutigari? ¿Cʉ̃́ãya wederare o aperó macãrãpʉre wapaségari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Aperó macãrãpʉre, jĩĩ yʉʉwi. Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Cʉ̃́ãya wedera wapatíricua. ");
INSERT INTO tue_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Teero biipacari, marĩ cʉ̃́ãrẽ merẽã wãcũdutihera wapatíada. Mʉʉ weerida née, iitaropʉ wai weegʉ wáaya. Wai yaasʉguegʉre weemʉõcoya. Cʉ̃ʉ̃ya ʉserore wʉ̃ãwá, niyeruquire bʉagʉ́dacu. Tiiquimena marĩ pʉarã́yere wapatígʉ wáaya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tiibʉrecora ʉ̃sã Jesús buerá cʉ̃ʉ̃ pʉto wáa, cʉ̃ʉ̃rẽ sãĩñáwʉ̃: —Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉsera ¿nii ʉ̃sã watoare nemorṍ ʉpʉtí macʉ̃ niiĩ? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús sĩcʉ̃ wĩmagʉ̃rẽ sʉocó, ʉ̃sã decopʉ nʉcõ, ");
INSERT INTO tue_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã niirecʉtirere waso, wĩmarã tiiróbiro niihẽrĩ, Cõãmacʉ̃ dutiré mʉ́ãpʉre jeaboarigue mʉ́ãrẽ jearicu. ");
INSERT INTO tue_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nemorṍ ʉpʉtí macʉ̃ Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉsegʉno ãni wĩmagʉ̃ tiiróbiro niiĩ. Ãni “yʉʉ ãpẽrã́ nemorṍ niiã” jĩĩ wãcũriqui. ");
INSERT INTO tue_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sĩcʉ̃ ãni wĩmagʉ̃biro biigʉ́re ĩña, “yʉʉ Jesuré maĩã; teero tiigʉ́ cʉ̃ʉ̃rẽ boca maĩgʉ̃́da” jĩĩ wãcũboqui. Cʉ̃ʉ̃ teero wãcũgʉ̃, cʉ̃ʉ̃rẽ maĩgʉ̃́, yʉʉcãrẽ maĩgʉ̃́ tiii. ");
INSERT INTO tue_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Yʉʉre padeorágãrẽ ñañaré tiidutígʉnorẽ ñañanemorõ wáaadacu. Cʉ̃ʉ̃rẽ ʉ̃tãgã pairígamena cʉ̃ʉ̃ wãmʉãpʉ siatúyo, día pairímaapʉ cõãñocori, nemorṍ ãñubocu. ");
INSERT INTO tue_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Basocáre ñañaré tiidutíre ñañanetõjõãã. Ñañaré tiidutíre niirucua. Ãpẽrãrẽ́ ñañaré tiidutíri tiirápe bayiró ñañarõ netõã́dacua. ");
INSERT INTO tue_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mʉʉya wãmo, mʉʉya dʉpo mʉʉrẽ ñañarére tiirí tiibócu. Teero wáari, páatacõãjãña. Sicawãmomena o sicadʉpomena catiré petihéropʉ jeagʉ, ãñujãã. Pʉawãmómena o pʉadʉpómena pecamepʉ cõãdioconorĩpeja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉʉya capea ĩñaré mʉʉrẽ ñañarére tiirí tiibócu. Teero wáari, tiigaré odewecõãjãña. Sicacapeamena catiré petihéropʉ jeagʉ, ãñujãã. Pʉacapéamena pecamepʉ mʉʉ cõãdioconorĩpeja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ãniã wĩmarãrẽ teero ĩñarijãña. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ʉ̃mʉã́sepʉ ángelea ãniãgãrẽ coterá yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́mena niirucujãya. ");
INSERT INTO tue_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉʉ niipetira sõwʉ̃ ditirirare netõnégʉ̃ atiwʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Mʉ́ã deero tʉgueñaĩ? Cien oveja cʉogʉ́ sĩcʉ̃ ditijõãrĩ, ¿deero tiigári cʉ̃ʉ̃? Noventa y nuevere ʉ̃tãgʉ̃pʉ́ cṹũ, ditiarigʉre ãmaãgʉ̃ wáaqui. ");
INSERT INTO tue_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cʉ̃ʉ̃rẽ bʉagʉ́, bayiró ʉseniqui. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ãpẽrã́ noventa y nueve dʉsaáriramena nemorṍ cʉ̃ʉ̃mena ʉseniqui. ");
INSERT INTO tue_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Teerora marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ ãniãgãrẽ sĩcʉ̃ pecamepʉ wáari booríqui. ");
INSERT INTO tue_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Mʉʉya wedegʉ mʉʉrẽ ñañaré tiirí, mʉʉ basiro cʉ̃ʉ̃ pʉtopʉ wedesegʉ wáaya. Cʉ̃ʉ̃ ñañaré tiiáriguere tʉomasĩ́rĩ tiiyá. Cʉ̃ʉ̃ “jáʉ” jĩĩrĩ, mʉ́ã cãmerĩ́ wedese ʉseniãdacu sũcã. ");
INSERT INTO tue_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cʉ̃ʉ̃ tʉoríatã, sĩcʉ̃rẽ, pʉarã́rẽ sʉowáya; mʉʉmena cʉ̃ʉ̃ pʉtopʉ wáaaro. Toopʉ́ jea, wedeya cʉ̃ʉ̃ mʉʉrẽ ñañaré tiiáriguere. Mʉʉ teero tiigʉ́, Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora tiicú. Teero tiirá, pʉarã́ o ĩtĩã́rã tee ñañaré tiiáriguere “diamacʉ̃́rã wáawʉ” o “diamacʉ̃́rã wáayu” jĩĩmasĩãdacu. ");
INSERT INTO tue_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cʉ̃́ãcãrẽ netõnʉcã́rĩ, niipetira yʉʉre padeoráre wedewa mʉ́ã neãrṍpʉ. Cʉ̃́ãcãrẽ netõnʉcã́rĩ, yʉʉre padeoráre jĩĩña: “Cõãmacʉ̃rẽ masĩhẽgʉ̃ o romanuã õpʉ̃rẽ niyeru wapasébosari basocʉre tiiróbiro cʉ̃ʉ̃rẽ ĩñaña”. ");
INSERT INTO tue_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Atibʉ́recopʉre mʉ́ã “jáʉ, teero tiiyá; ãñuniã” jĩĩrĩ, ãñuniãdacu ʉ̃mʉã́sepʉcãrẽ. Teero biiri atibʉ́recopʉre mʉ́ã “teero tiiríjãña; ñañaniã” jĩĩrĩ, ñañaniãdacu ʉ̃mʉã́sepʉcãrẽ. ");
INSERT INTO tue_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã sũcã: Mʉ́ã menamacãrã pʉarã́ sĩcãrĩbíro wãcũrémena “marĩ ateré Cõãmacʉ̃rẽ sãĩcó” jĩĩ sãĩrĩ́, yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉarã́, ĩtĩã́rã yʉʉre padeorá neãrĩ, yʉʉ cʉ̃́ã watoapʉ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro Jesús pʉtopʉ wáa, sãĩñáwĩ: —Õpʉ̃, yáa wedegʉ cʉ̃ʉ̃ yʉʉre ñañaré tiirucúri, ¿noquẽ pee cʉ̃ʉ̃rẽ acabógʉdari? ¿Sietecõrõ acabógʉdari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—“Sietecõrõ” jĩĩria. “Cʉ̃ʉ̃ ñañaré tiirécõrõ acabóya” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Mʉ́ãrẽ queorémena teeré wedegʉda: Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã. Sĩcʉ̃ õpʉ̃ cʉ̃ʉ̃ye dita dutibosara wapamórere “quẽnogʉ̃́da” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cʉ̃ʉ̃ cʉ̃́ãrẽ wapasénʉcãrĩ, sĩcʉ̃ pairó peti wapamógʉ̃rẽ néeatiyira. ");
INSERT INTO tue_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cʉ̃ʉ̃ wapatíre cʉohéri ĩñagʉ̃, cʉ̃ʉ̃rẽ, cʉ̃ʉ̃ nʉmorẽ́, cʉ̃ʉ̃ põnarẽ́, niipetire cʉ̃ʉ̃ cʉorére ãpẽrãpʉ́re dúadutiyigʉ, cʉ̃ʉ̃ wapamórere wapatídutigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Teeré ĩñagʉ̃, cʉ̃ʉ̃pe cʉ̃ʉ̃ õpʉ̃ pʉto ñicãcoberimena jeacũmu, sãĩyígʉ: “Yʉʉ õpʉ̃, yʉʉre yuesãñuña. Yʉʉ niipetire wapatípetijãgʉ̃da”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Cʉ̃ʉ̃ õpʉ̃pe cʉ̃ʉ̃rẽ bóaneõ ĩñagʉ̃, cʉ̃ʉ̃ wapamórere acabójã, cʉ̃ʉ̃rẽ “wáagʉa” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Cʉ̃ʉ̃pe wáa, ãpĩ cʉ̃ʉ̃ menamacʉ̃ cʉ̃ʉ̃ tiiróbiro dutibosagʉre bʉajeáyigʉ. Cʉ̃ʉ̃pe cʉ̃ʉ̃rẽ péerogã wapamómiyigʉ. Cʉ̃ʉ̃rẽ wapatídutigʉ, wãmʉãrẽ ñeediyo, “mʉʉ yʉʉre wapamórere wapatíya” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Cʉ̃ʉ̃pe ñicãcoberimena jeacũmu, sãĩmíyigʉ: “Yʉʉre yuesãñuña. Mʉʉrẽ wapatígʉda”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cʉ̃ʉ̃pe booríyigʉ. Cʉ̃ʉ̃rẽ peresuwiipʉ néewa, sõnecodutiyigʉ. “Cʉ̃ʉ̃ wapatípetiripʉ, wionécoya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ãpẽrã́ cʉ̃ʉ̃ menamacãrã dutibosara cʉ̃ʉ̃ teero tiirére bayiró bóaneõremena ĩñayira. Cʉ̃́ã õpʉ̃pʉre niipetire cʉ̃ʉ̃ teero tiiáriguere wedera wáayira. ");
INSERT INTO tue_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Teeré tʉogʉ́, cʉ̃́ã õpʉ̃ cʉ̃ʉ̃rẽ sʉodutíyigʉ. Cʉ̃ʉ̃rẽ jĩĩyigʉ: “¡Ñañagʉ̃́! Mʉʉ yʉʉre sãĩrĩ́, niipetire mʉʉ wapamóretõrẽ acabópetijããwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yʉʉ mʉʉrẽ bóaneõ ĩñaãrirobirora mʉʉcã mʉʉ menamacʉ̃rẽ bóaneõ ĩñaboajĩyu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cʉ̃ʉ̃ õpʉ̃ cúagʉ, peresuwii coterí basocare “cʉ̃ʉ̃rẽ bayiró ñañarõ tiiyá; tée cʉ̃ʉ̃ wapamóre wapatípetiripʉ, ñañarõ tiidúya” jĩĩyigʉ, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús ate wede yapacʉtíwi: —Yʉʉ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ teerora tiigʉ́daqui mʉ́ãrẽ, mʉ́ãya wederare bóaneõremena acabóheri, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús teeré jĩĩãri siro, Galileapʉ niiãrigʉ Judea ditapʉ día Jordán muĩpũ mʉãatirope wáawi. ");
INSERT INTO tue_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Paʉ basocá cʉ̃ʉ̃rẽ nʉnʉwã́. Cʉ̃ʉ̃ toopʉ́ diarecʉtirare netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseo basoca cʉ̃ʉ̃ pʉtopʉ jeawa. Cʉ̃ʉ̃rẽ ñañarõ jĩĩré bʉadʉgára, sãĩñáwã: —¿Sĩcʉ̃ cʉ̃ʉ̃ nʉmorẽ́ cʉ̃ʉ̃ booró cõãjãmasĩgari? ¿Marĩrẽ dutiré teerora jĩĩĩ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesupé yʉʉwi: —Mʉ́ã Cõãmacʉ̃ye queti jóaripũ buerá niipacara, ¿masĩrii? Cõãmacʉ̃ niipetire cʉ̃ʉ̃ sicato tiinʉcã́ritopʉre ʉ̃mʉ, numiṍ tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ate jĩĩrigʉ niiwĩ: “Teero tiigʉ́, ʉ̃mʉ cʉ̃ʉ̃ pacʉre, cʉ̃ʉ̃ pacore merẽã witi, cʉ̃ʉ̃ nʉmoména niigʉ̃daqui. Cʉ̃́ã pʉarã́ sicaõpʉ̃ʉ̃ tiiróbiro pʉtʉáadacua”, jĩĩrigʉ niiwĩ Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Teero tiirá, pʉarã́ niiriya. Sĩcʉ̃ tiiróbiro niiĩya. Cõãmacʉ̃ cʉ̃́ãrẽ sicaõpʉ̃ʉ̃rã tiiróbiro niirĩ tiirí siro, ãpĩ cʉ̃́ãrẽ cãmerĩ́ cõãrĩ tiiríjãrõ booa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Cʉ̃́ãpe sãĩñáwã: —Too docare ¿deero tiigʉ́ Moisés sĩcʉ̃ cʉ̃ʉ̃ nʉmorẽ́ cõãgʉ̃dʉ “atewapá mʉʉrẽ cõãã” jĩĩrípũrẽ ticodutiyiri? ");
INSERT INTO tue_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã ñecʉ̃sʉ̃mʉã Cõãmacʉ̃ dutirére tiidʉgáheri ĩñagʉ̃, Moisés “mʉ́ã nʉmosã́numiãrẽ cõãmasĩã” jĩĩrigʉ niiwĩ. Teero jĩĩpacari, sicatopʉra numiã́rẽ cõãré maniyíro. ");
INSERT INTO tue_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yʉʉ jĩĩrére tʉoyá: Sĩcʉ̃ cʉ̃ʉ̃ nʉmo ãpĩména ñañaré tiirípacari, coore cõãgʉ̃, apegoré nʉmocʉtigʉ, ñañarõ tiigʉ́ tiiquí. Nʉmo niihẽgõmena ñeeapegʉ pʉtʉáqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ʉ̃sã cʉ̃ʉ̃ buerá jĩĩwʉ̃: —Too docare nʉmomanirĩ, nemorṍ ãñucu, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ʉ̃sãrẽ jĩĩwĩ: —Niipetira nʉmomanirã niimasĩricua. Cõãmacʉ̃ “nʉmomanirã niiãdacua” jĩĩrira dícʉ niimasĩcua. ");
INSERT INTO tue_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ãpẽrã́ bauárapʉra nʉmocʉtimasĩricua. Ãpẽrãrẽ́ basocá põnamanírĩ tiiári siro, nʉmocʉtimasĩricua. Ãpẽrã́ Cõãmacʉ̃ye maquẽ dícʉre tiidʉgára nʉmocʉtiricua. “Nʉmomanigʉ̃ niigʉ̃da” jĩĩgʉ̃́no nʉmomanigʉ̃ niijããrõ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wĩmarãrẽ Jesús pʉto néeatiwa, cʉ̃́ã ñaapeó, Cõãmacʉ̃rẽ sãĩbosádutira. Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃́ãrẽ néeatirare tutimiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesupé jĩĩwĩ: —Wĩmarã yʉʉ pʉto atiaro. Cãmotárijãña. Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉserano ãniãgã tiiróbiro wãcũrã́ niiĩya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Too síro Jesús cʉ̃́ãrẽ ñaapeó, Cõãmacʉ̃rẽ sãĩbosáwi. Yaponó, aperopʉ́ wáajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Too síro sĩcʉ̃ Jesús pʉtopʉ jea, cʉ̃ʉ̃rẽ sãĩñáwĩ: —Basocáre buegʉ́, ¿yʉʉ ñeenó ãñurére tiigʉ́dari, catiré petihére bʉadʉgágʉ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Cʉ̃ʉ̃rẽ yʉʉwi: —¿Deero tiigʉ́ yʉʉre ãñuré maquẽrẽ sãĩñáĩ? Sĩcʉ̃rã ãñugʉ̃́ niiĩ. Cʉ̃ʉ̃ dutiré tiiyá, catiré petihére bʉadʉgágʉja, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ñeerẽ́ tiigári? jĩĩwĩ. Jesús jĩĩwĩ: —Basocáre sĩãríjãña. Ãpĩ nʉmorẽ ñeeaperijãña. Yaaríjãña. Ãpẽrãrẽ́ jĩĩditoremena wedesãrijãña. ");
INSERT INTO tue_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉʉ pacʉ, mʉʉ pacore padeoyá. Mʉʉ basiro maĩrṍ tiiróbirora ãpẽrãcã́rẽ maĩñá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Yʉʉ tee niipetirere tiimʉ́ãatimiwʉ̃. ¿Ñeenó yʉʉre dʉsai? jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Mʉʉ basocʉ́ ãñugʉ̃́ peti niidʉgagʉ, mʉʉ cʉorére dúapetijãgʉ̃ wáaya. Tee dúa wapatáariguere bóaneõrãrẽ batoya. Teero tiigʉ́, Cõãmacʉ̃ pʉtopʉre pee ãñuré bʉagʉ́dacu. Túajea, ati, yʉʉre nʉnʉwá, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mamʉ teero jĩĩrĩ tʉogʉ́, wãcũpati, pʉtʉajõãwĩ, pee apeyé cʉogʉ́ niijĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgari, wisió niicu. ");
INSERT INTO tue_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yʉʉ ateré jĩĩnemoã sũcã: Wáicʉ camello wãmecʉtigʉ awigá copegãpʉ sããcãmewitimasĩriqui. Toorá nemocú, pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgaripereja, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Teeré tʉorá, ʉ̃sã bayiró tʉomaníjõãwʉ̃: —Too docare ¿noãpé netõnénoãdari? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús ʉ̃sãrẽ ĩñagʉ̃rã, jĩĩwĩ: —Basocá cʉ̃́ã basiro netõnémasĩriya. Cõãmacʉ̃pereja wisióre manidójãã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro cʉ̃ʉ̃rẽ yʉʉgʉ, jĩĩwĩ: —Tʉoyá ména. Ʉ̃sãpe niipetire ʉ̃sã cʉoríguere cṹũjõãatiwʉ, mʉʉmena nʉnʉã́da jĩĩrã. Teero tiirá, ¿ʉ̃sãpe ñeenórẽ ñeeãdari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús yʉʉwi: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Atibʉ́reco petiári siro, niipetire mama wasorítabe, yʉʉ niipetira sõwʉ̃ duigʉdacu asibatéripĩrõ õpʉ̃ duirípĩrõpʉ. Yʉʉ too duiri, mʉ́ã yʉʉre nʉnʉríracã docepĩrĩ õpãrã́ duirépĩrĩpʉ duiadacu. Israelya põna doce põnarĩ macãrãrẽ beseadacu. ");
INSERT INTO tue_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sĩcʉ̃no yʉʉre padeoré wapa cʉ̃ʉ̃ye wiseri, cʉ̃ʉ̃ baira, cʉ̃ʉ̃ pacʉsʉ̃mʉã, cʉ̃ʉ̃ põna, cʉ̃ʉ̃ye ditare cṹũjõã, cʉ̃ʉ̃ cṹũwarigue nemorṍ bʉagʉ́daqui. Teero biiri apeyé Cõãmacʉ̃mena catiré petihére bʉagʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mecʉ̃tígãrẽ paʉ ʉpʉtí macãrã too síropʉre bʉ́ri niirã́ niiãdacua. Bʉ́ri niirã́ too síropʉre ʉpʉtí macãrã niiãdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús wedenemowĩ: —Mʉ́ãrẽ queorémena teeré wedegʉda: Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã. Sĩcʉ̃ ʉse wese cʉogʉ́ ñamisãñurõ cʉ̃ʉ̃ya wese padeadarare ãmaãgʉ̃ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cʉ̃́ãrẽ bʉagʉ́, “sicabʉreco padegʉ wapatárocõrõ mʉ́ãrẽ wapatígʉda” jĩĩyigʉ. Cʉ̃́ãmena quẽnotóa, cʉ̃ʉ̃ya wesepʉ padedutigʉ ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nueve niirĩ, macã decopʉ wáayigʉ. Toopʉ́ ãpẽrã́ paderipacara niirã́rẽ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cʉ̃́ãrẽ jĩĩyigʉ: “Mʉ́ãcã ʉse wesepʉ padera wáaya. Ãñurõ mʉ́ãrẽ wapatígʉda”, jĩĩyigʉ. Cʉ̃́ãcã padera wáayira. ");
INSERT INTO tue_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Coeritó niirĩ, ñamica tres niirĩ, teerora tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cinco niirĩ, macãpʉ wáa, ãpẽrã́ paderipacara niirã́rẽ bʉajeáyigʉ sũcã. Cʉ̃́ãrẽ, “¿deero tiirá mʉ́ã paderipacara niinañiõjõãĩ?” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ãpẽrã́ ʉ̃sãrẽ ‘padera atiya’ jĩĩriawã”, jĩĩyira. “Mʉ́ãcã ʉse wesepʉ padera wáaya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Náĩcũmuatiri, wese cʉogʉ́ paderáre dutigʉ́re jĩĩyigʉ: “Paderáre sʉocó, wapatíya. Too síropʉ jeaarirare wapatísʉgueya. Sʉguero jeaarirare wapatíyaponocoya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Cinco niirĩpʉ padenʉcãrira jeayira. Sicabʉreco padera wapatárocõrõ ñeeyira. ");
INSERT INTO tue_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bóeripʉ jearirape ati, “ãniã nemorṍ marĩ wapatáadacu” jĩĩ wãcũmiyira. Cʉ̃́ãcã sicabʉreco wapatárocõrõ ñeeyira. ");
INSERT INTO tue_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cʉ̃́ã tiiwese cʉogʉ́re tuticoteyira: ");
INSERT INTO tue_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ĩ́niã ʉ̃sã siropʉ padera jeaarira sica horara padeawã. Cʉ̃́ãcãrẽ ʉ̃sã wapatárocõrõrã wapatía. Ʉ̃sãpeja yoari asiró doca padenañiõjõããwʉ̃”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cʉ̃ʉ̃pe sĩcʉ̃ teero jĩĩrã́ menamacʉ̃rẽ jĩĩyigʉ: “Yʉʉ menamacʉ̃, mʉʉrẽ ñañarõ tiigʉ́ tiiría. Mʉʉ padeadari sʉguero, ‘sicabʉreco wapatárocõrõ mʉʉrẽ wapatígʉda’ jĩĩ quẽnoã́wʉ̃ mʉʉmena. ");
INSERT INTO tue_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mʉʉ wapatárere née, wáagʉa. Yʉʉ ãni too síropʉ padegʉ́ jeaarigʉre mʉʉrẽ wapatárocõrõrã wapatídʉgaga. ");
INSERT INTO tue_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yée niyeru niiã ate. Yʉʉ booró yée niyerumena tiimasĩ́ã. ¿Yʉʉ ãñurõ tiirí, mʉʉ ĩñatutigʉ tiiite?” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Teero tiirá, too síropʉ niiãrira sʉgueadacua; sʉguearira síropʉ niiãdacua, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Too síro Jesús Jerusalénpʉ mʉãwagʉ, ʉ̃sã cʉ̃ʉ̃ buerá docere merẽã sʉocó, wedewawi. Biiro jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mʉ́ã ĩñaã. Marĩ Jerusalénpʉ wáara tiia. Toopʉ́ yʉʉ niipetira sõwʉ̃ niipacari, paiaré dutirá, Moisés jóarigue buerápʉre ticoadacua. Cʉ̃́ã sĩãdutíadacua yʉʉre. ");
INSERT INTO tue_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Cʉ̃́ãrã judíoa niihẽrãpʉre ticonetõneãdacua. Yʉʉre buijã́, tãna, curusapʉ páabiatu sĩãã́dacua. Itiábʉreco siro masãgʉ̃dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo nʉmo coo põna Santiago, Juanména Jesús pʉtopʉ jeawo. Cʉ̃ʉ̃rẽ sãĩgṍdo, ñicãcoberimena jeacũmuwõ. ");
INSERT INTO tue_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Cʉ̃ʉ̃ coore: —¿Ñeenó boogári? jĩĩwĩ. —Mʉʉ õpʉ̃ sããgʉ̃, ãniã yʉʉ põna pʉarã́rẽ mʉʉ duirípĩrõ pʉtogãpʉ dʉpowa. Sĩcʉ̃ diamacʉ̃́pe, ãpĩrẽ́ acuniñape dʉpowa, jĩĩmiwõ. ");
INSERT INTO tue_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús yʉʉwi: —Yʉʉ õpʉ̃ sãããdari sʉguero wáaadarere mʉ́ã masĩria. ¿Yʉʉ ñañarõ netõã́darobirora mʉ́ãcã ñañarõ netõrã́ nʉcãbógari? jĩĩwĩ. —Ʉ̃́jʉ̃, ñañarõ netõmasĩ́ã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Mʉ́ãcã yʉʉ tiiróbiro ñañarõ netõã́dacu. Teeré wedemasĩpacʉ, “sĩcʉ̃ diamacʉ̃́pe, ãpĩ acuniñape dʉpogʉda” jĩĩmasĩriga. Tee yʉʉ dutiré niiria. Yʉʉ Pacʉ toopʉ́ duiadarare besetoawi, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ʉ̃sã pʉamóquẽñerã tee sãĩrére tʉorá, Santiago, Juanména cúawʉ. ");
INSERT INTO tue_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús ʉ̃sãrẽ sʉocó, jĩĩwĩ: —Mʉ́ã masĩã: Niipetire dita macãrãrẽ dutirá Cõãmacʉ̃rẽ masĩhẽrã cʉ̃́ã booró dutiãmajãya. Cʉ̃́ã doca macãrãcã acaribíremena dutiiya, cʉ̃́ã dutirére tiipetídutira. ");
INSERT INTO tue_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉ́ãpeja cʉ̃́ã tiiróbiro tiiríjãña. Merẽã tiirécʉtiya. Mʉ́ã ʉpʉtí macãrã niidʉgara, ãpẽrãrẽ́ tiiápuri basoca niiña. ");
INSERT INTO tue_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sĩcʉ̃ ãpẽrã́ nemorṍ niidʉgagʉno niipetirare padecotegʉ tiiróbiro niirõ booa. ");
INSERT INTO tue_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yʉʉ niipetira sõwʉ̃cã teerora tiiwʉ́: Ãpẽrã́ yʉʉre tiiápuaro jĩĩgʉ̃ mee atiwʉ. Yʉʉpe basocáre tiiápugʉ atigʉ tiiwʉ́. Teero biiri paʉ basocá ñañaré tiiré wapa diabosa netõnégʉ̃ atigʉ tiiwʉ́, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ʉ̃sã Jericó niiãrira witiwari, paʉ basocá Jesuré nʉnʉátiwa. ");
INSERT INTO tue_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ʉ̃sã wáarima wesapʉ pʉarã́ ĩñahẽrã duiwa. “Jesús too netõwái” jĩĩrére tʉorá, bayiró bʉsʉrómena jĩĩwã: —¡Õpʉ̃, David pãrãmi niinʉnʉsegʉ, ʉ̃sãrẽ bóaneõña! jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Basocápe cʉ̃́ãrẽ: —Nocõrõrã ditamaníjõãña, jĩĩ tutimiwã. Cʉ̃́ãpe jĩĩnemosãjãwã: —¡Õpʉ̃, David pãrãmi niinʉnʉsegʉ, ʉ̃sãrẽ bóaneõña! jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesupéja pʉtʉánʉcã, cʉ̃́ãrẽ sʉocó: —¿Mʉ́ãrẽ deero tiirí boogári? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Õpʉ̃, ʉ̃sãrẽ ĩñarĩ tiiyá, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús cʉ̃́ãrẽ bóaneõ ĩñagʉ̃, capearire ñaapeówi. Ñaapeórira, ĩñajõãwã sáa. Ĩña, cʉ̃ʉ̃rẽ nʉnʉátiwa. ");
INSERT INTO tue_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ʉ̃sã Jerusalénpʉ jeaadaro péero dʉsawʉ́. Betfagé macãpʉ Ʉ̃tãgʉ̃́ Olivo pʉtopʉ jeaadara tiiwʉ́. Toopʉ́ Jesús pʉarã́ ʉ̃sã menamacãrãrẽ tiimacãpʉ ticocowi. ");
INSERT INTO tue_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Cʉ̃́ãrẽ jĩĩwĩ: —Iimacã marĩ díamacʉ̃ niirí macãpʉ wáaya. Máata sĩcõ burra siatúnʉcõãrigore, wĩmagʉ̃mena bʉajeáadacu. Jõã, cʉ̃́ãrẽ néeatiya. ");
INSERT INTO tue_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sĩcʉ̃ mʉ́ãrẽ sãĩñárĩ, “marĩ Õpʉ̃ booáwĩ; máata wiyajã́gʉ̃daqui” jĩĩña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tee profeta jĩĩrirobirora wáaro tiiyíro. Ateré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén macãrãrẽ jĩĩña: “Ĩñaña. Mʉ́ã Õpʉ̃ mʉ́ã pʉtopʉ atitoai mée. Bʉ́ri niigʉ̃́ tiiróbiro burra macʉ̃ wĩmagʉ̃ sotoapʉ pesaatii”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Cʉ̃́ã Jesús ticocoarira wáa, cʉ̃ʉ̃ tiidutíarirobirora tiiríra niiwã. ");
INSERT INTO tue_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrore cʉ̃ʉ̃ pacoména néeatiwa. Cʉ̃́ã sotoapʉ cʉ̃́ãye suti sotoá maquẽrẽ tuuwépeowʉ. Jesús sĩcʉ̃ sotoapʉ mʉãpeawi. ");
INSERT INTO tue_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Paʉ toopʉ́ niirã́ cʉ̃ʉ̃rẽ padeorá, cʉ̃ʉ̃ netõwáadarimapʉ cʉ̃́ãye suti sotoá maquẽrẽ sẽ́õcũwã. Ãpẽrã́ yucʉ dʉpʉri tiimapʉ́ páatacũwã. ");
INSERT INTO tue_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Cʉ̃ʉ̃ sʉguero wáara, cʉ̃ʉ̃ siro nʉnʉrã́ bayiró bʉsʉrómena jĩĩwã: —¡David pãrãmi niinʉnʉsegʉre ʉsenire ticoada! ¡Ãni Cõãmacʉ̃ ticodiocorigʉ niiĩ! ¡Cʉ̃ʉ̃rẽ ãñurõ tiiáro! ¡Niipetira ʉ̃mʉã́se macãrã cʉ̃ʉ̃rẽ “ãñunetõjõãĩ” jĩĩ, ʉsenire ticoaro! jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalénpʉ sããjeari, niipetira toopʉ́ niirã́ ĩñamanijõã, deero jĩĩmasĩririra niiwã. —¿Noã niiĩ ãni? jĩĩ cãmerĩ́ sãĩñáwã. ");
INSERT INTO tue_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ãpẽrã́ yʉʉwa: —Cʉ̃ʉ̃ Jesús, profeta, Nazaret Galilea dita macʉ̃ niiĩ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Too síro Jesús Cõãmacʉ̃wiipʉ sããjeagʉ, niipetira dúari basocare, teeré sãĩnérãrẽ cõãwionecowi. Niyeru wasorí basocaye mesarire tuunécõãcũjãwĩ. Bua dúari basocaye duirépĩrĩcãrẽ teerora tiiwí. ");
INSERT INTO tue_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cʉ̃́ãrẽ jĩĩwĩ: —Cõãmacʉ̃ye queti jóaripũpʉ biiro jĩĩã: “Yáa wii ‘Cõãmacʉ̃mena wedeseri wii niiã’ jĩĩrí wii niiãdacu”, jĩĩ jóare niiã. Mʉ́ãpe yaarépira dúari wii niirĩ tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tiiwiipʉ́re ĩñahẽrã, wáamasĩhẽrã cʉ̃ʉ̃ pʉtopʉ atiwa. Cʉ̃́ãrẽ netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Paiaré dutirá, Moisés jóarigue buerápe cʉ̃ʉ̃ tutuaremena tiiẽ́ñorĩ ĩñarã, cúawa. Wĩmarã tiiwií popeapʉ niirã́ bayiró bʉsʉrómena “¡David pãrãmi niinʉnʉsegʉre ʉsenire ticoada!” jĩĩwã. Teecã́rẽ tʉorá, cúawa. ");
INSERT INTO tue_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesuré jĩĩwã: —¿Ĩ́niã cʉ̃́ã jĩĩrére tʉoi? jĩĩwã. —Tʉoa, jĩĩwĩ—. Mʉ́ã Cõãmacʉ̃ye queti jóaripũ buerá niipacara, ate tiipũpʉ jóarere tʉomasĩ́ria ména: Cõãmacʉ̃, mʉʉ wĩmarãrẽ, teero biiri ũpũrã́rẽ ãñurõ ʉseniremena mʉʉrẽ basapeomenirĩ tiiáwʉ̃, jĩĩ jóanoã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Cʉ̃́ãrẽ cõãwitiwa, Betaniapʉ wáawʉ. Toopʉ́ ʉ̃sã cãniwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Apebʉ́reco bóeri Jesús Jerusalénpʉ cãmepʉtʉ́agʉ, jʉabóajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maa wesapʉ higueragʉre ĩñawĩ. “Dʉcacʉticura” jĩĩgʉ̃, ĩñagʉ̃ wáamiwĩ. Pṹũrĩ dícʉ bʉawí. Teero tiigʉ́, tiigʉré: —Dʉcacʉtinemoricu sáa, jĩĩwĩ. Máata higueragʉ sĩnijṍãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Teero wáari, ʉ̃sã cʉ̃ʉ̃ buerá ĩñamanijõãrã, sãĩñáwʉ̃: —¿Deero tiiró higueragʉ máata sĩnijṍããrĩ? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús ʉ̃sãrẽ yʉʉwi: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã padeoré cʉorá, “Cõãmacʉ̃ yʉʉriboqui” jĩĩhẽrã, yʉʉ tiigʉré tiiárirobiro mʉ́ãcã tiimasĩ́ãdacu. Apeyé, mʉ́ã atigʉ́ ʉ̃tãgʉ̃rẽ́ “wáa, díapʉ ñaacoñuãña” jĩĩrĩ, teerora wáaadacu. ");
INSERT INTO tue_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mʉ́ã padeoré cʉorá, Cõãmacʉ̃rẽ sãĩrénorẽ bʉaádacu. ");
INSERT INTO tue_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Too síro Jesús Cõãmacʉ̃wiipʉ sããwawi. Cʉ̃ʉ̃ tiiwiipʉ́ bueritabe, paiaré dutirá, ãpẽrã́ bʉtoá dutirá cʉ̃ʉ̃ pʉtopʉ wáa, cʉ̃ʉ̃rẽ sãĩñáwã: —¿Noã dutirémena mʉʉ teeré tiii? ¿Noã mʉʉrẽ dutiré ticori? jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús cʉ̃́ãrẽ yʉʉwi: —Yʉʉcã mʉ́ãrẽ sãĩñágʉ̃da. Mʉ́ã yʉʉre yʉʉri, mʉ́ãrẽ “ate dutirémena tiia yʉʉ” jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Noã Juanrẽ́ wãmeõtidutigʉ ticocoyiri? ¿Cõãmacʉ̃ o basocápe ticocoyiri? jĩĩwĩ. Cʉ̃́ãpe cãmerĩ́ wedesewa: —Marĩ “Cõãmacʉ̃ ticocorigʉ niiwĩ” jĩĩrĩ, cʉ̃ʉ̃ marĩrẽ “too docare ¿deero tiirá cʉ̃ʉ̃rẽ padeoríri?” jĩĩboqui. ");
INSERT INTO tue_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Marĩ “basocá cʉ̃ʉ̃rẽ ticocorira niiwã” jĩĩmasĩria, basocáre cuira. Niipetira “Juan profeta niiwĩ” jĩĩ padeoóya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Teero tiirá, cʉ̃́ã Jesuré: —Masĩriga, jĩĩwã. Jesús cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉcã mʉ́ãrẽ “ate dutirémena teeré tiia” jĩĩ wederia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús cʉ̃́ãrẽ sãĩñáwĩ: —¿Mʉ́ã deero tʉgueñaĩ ateré? Sĩcʉ̃ pʉarã́ ʉ̃mʉã põnacʉtíyigʉ. Cʉ̃ʉ̃ sĩcʉ̃ pʉtopʉ wáa, “macʉ̃, ʉse wesepʉ padegʉ wáaya” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Cʉ̃ʉ̃ macʉ̃pé “wáaria” jĩĩyigʉ. Too síro wãcũpati, wãcũre waso, padegʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Too síro cʉ̃́ã pacʉ ãpĩ cʉ̃ʉ̃ macʉ̃ pʉtopʉ wáa, teerora jĩĩyigʉ. Cʉ̃ʉ̃pe “wáagʉda” jĩĩpacʉ, wáariyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Niipé cʉ̃́ã pacʉ booróbiro tiiyíri? jĩĩwĩ. —Cʉ̃ʉ̃ dutisʉguearigʉpe, jĩĩwã. Jesús cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niyeru wapasébosari basoca, teero biiri numiã́ ñañarã́ mʉ́ã sʉguero wãcũpati, wasoóya. Teero tiiró, Cõãmacʉ̃ dutiré basocápʉre niiãdare cʉ̃́ãrẽ mʉ́ã sʉguero jeaadacu. ");
INSERT INTO tue_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Cõãmacʉ̃ boorére mʉ́ãrẽ buepacari, cʉ̃ʉ̃rẽ padeoríwʉ. Niyeru wapasébosari basocape, teero biiri numiã́ ñañarã́pe cʉ̃ʉ̃rẽ padeowá. Cʉ̃́ã wãcũpati, wasorí ĩñapacara, mʉ́ãpe too síro wãcũpati, wasoríwʉ. Juanrẽ́ padeoríwʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús cʉ̃́ãrẽ wedewi sũcã: —Apeyé queorére tʉoyá sũcã: Sĩcʉ̃ ʉ̃mʉ dita cʉogʉ́ niiyigʉ ʉse wese oterigʉ. Otepetitoa, sãnisã́nʉcõyigʉ. Ʉse cʉ̃́ã bipesã́ãdari copere ʉ̃tãgãpʉ coayígʉ. Teero biiri ʉ̃mʉã́ri wii cʉ̃́ã coteduiadari wiire tiiyígʉ. Aperopʉ́ wáanetõgʉ̃ wáagʉ, ãpẽrãrẽ́ tiiditare wasoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ʉse dʉcacʉtirito niirĩ, cʉ̃ʉ̃rẽ padecoterare ticocomiyigʉ. Cʉ̃ʉ̃ya dita cʉ̃ʉ̃ wasorirare “ʉse cʉ̃́ã dúa wapatárere decomena ticocoaro yʉʉre” jĩĩcomiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cʉ̃́ã toopʉ́ jeari, tiidita wasorira cʉ̃́ãrẽ ñee, sĩcʉ̃rẽ páa, ãpĩrẽ́ sĩãjã́, ãpĩrẽ́ ʉ̃tãperimena déeyira. ");
INSERT INTO tue_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tiidita õpʉ̃ cʉ̃ʉ̃ ticocosʉguerira nemorṍ ticocomiyigʉ sũcã. Cʉ̃́ãcãrẽ teerora tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Too síro sáa, cʉ̃ʉ̃ macʉ̃rẽ ticocomiyigʉ sũcã. “Yʉʉ macʉ̃rẽ quioníremena ĩñaãdacua”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Õpʉ̃ macʉ̃ toopʉ́ jeari ĩñarã, tiidita wasorira cãmerĩ́ wedeseyira: “Ãnirã́ niiĩ too síropʉ atiditaré ñeegʉ̃dʉ. Jãmʉ, sĩãcó. Cʉ̃ʉ̃ manirĩ́, atiditá marĩya dita pʉtʉáadacu”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Teero tiirá, cʉ̃ʉ̃rẽ ñee, tiiwese wesapʉ néewa, sĩãcõã́jãyira. ");
INSERT INTO tue_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Too docare tiidita õpʉ̃ toopʉ́ jeagʉ, ¿deero tiigʉ́dari tiidita wasorirare? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Cʉ̃ʉ̃rẽ jĩĩwã: —Bóaneõrõ manirṍ cʉ̃́ã ñañarã́rẽ sĩãcõã́gʉ̃daqui. Too síro cʉ̃ʉ̃ya ditare cʉ̃ʉ̃rẽ wapatírucujããdarare wasogʉdaqui, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã Cõãmacʉ̃ye queti jóaripũ buerá niipacara, ate tiipũpʉ jóarere tʉomasĩ́ria ména: Wii weerira ʉ̃tãquire booríyira. Cʉ̃́ã boorípacari, tiiquira ʉpʉtí macãqui pʉtʉáwʉ tiiwiipʉ́re. Cõãmacʉ̃ marĩ Õpʉ̃ teero tiirígʉ niiwĩ. Cʉ̃ʉ̃ tiiríguere “ãñunetõjõãã” jĩĩ tʉgueñanoã, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Teero tiirá, yʉʉ ateréja jĩĩã: Cõãmacʉ̃ dutiré mʉ́ãpʉre niimiãdare ʉse wese tiiróbiro niiã. Tiiwesere mʉ́ãrẽ ẽmajãgʉ̃daqui; ãpẽrãrẽ́ ticogʉdaqui cʉ̃ʉ̃ dutirére tiiádarare. ");
INSERT INTO tue_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tiiqui sotoapʉ ñaapeagʉno mʉtãjõãgʉ̃daqui. Tiiqui sĩcʉ̃ sotoapʉ ñaapeaatã, ãñurõ mʉtãpetijõãgʉ̃daqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Paiaré dutirá, teero biiri fariseo basoca Jesús tee queorémena wederi tʉorá, “marĩrẽna teero jĩĩgʉ̃ tiiquí” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Teero tiirá, cʉ̃ʉ̃rẽ ñeeãdara tiimíyira. Ñeeriwa, basocáre cuira. Basocápe “profeta niiĩ” jĩĩ padeowá. ");
INSERT INTO tue_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús queorémena cʉ̃́ãrẽ wedenemowĩ: ");
INSERT INTO tue_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã. Sĩcʉ̃ õpʉ̃ niiyigʉ. Cʉ̃ʉ̃ macʉ̃ wãmosíari bosebʉreco tiipéoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Yʉʉ boocórirare sʉorá wáaya”, jĩĩyigʉ cʉ̃ʉ̃rẽ padecoterare. Cʉ̃ʉ̃ boocórirape “wáaria” jĩĩjãyira. ");
INSERT INTO tue_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Too síro ãpẽrãrẽ́ cʉ̃ʉ̃rẽ padecoterare ticocogʉ, jĩĩduticoyigʉ: “Yʉʉ boocórirare ateré wedera wáaya: ‘Yaaré quẽnoã́repʉ niitoaawʉ̃. Yáara wecʉá, teero biiri ecará diicʉtiri tiirírare sĩãdutítoaawʉ̃. Niipetire quẽnoã́repʉ niiã. Bosebʉreco ĩñarã atiaro’ ”, jĩĩcoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cʉ̃́ãpe yʉʉriyira. Sĩcʉ̃ cʉ̃ʉ̃ya wesepʉ wáajõãyigʉ. Ãpĩ cʉ̃ʉ̃ apeyé dúaropʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ãpẽrãpé cʉ̃́ã õpʉ̃ ticocoarirare ñee, ñañarõ jĩĩ, sĩãjã́yira. ");
INSERT INTO tue_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cʉ̃́ã õpʉ̃ cʉ̃́ã teero tiiáriguere tʉogʉ́, cúayigʉ. Cʉ̃ʉ̃yara surarare ticocogʉ, cʉ̃́ãrẽ sĩãdutíyigʉ. Cʉ̃́ãya macãrẽ sóejãdutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Too síro cʉ̃ʉ̃rẽ padecoterare jĩĩyigʉ: “Niipetire wãmosíari bosebʉreco tiiádare niipetitoaa. Yʉʉ boocómirira atihere wapa boocónemoña manirã́ niijããrõ sáa. ");
INSERT INTO tue_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Teero tiirá, macã decopʉ wáaya. Niipetira mʉ́ã bʉajeárare ‘bosebʉreco ĩñarã wáaya’ jĩĩña”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Cʉ̃ʉ̃rẽ padecotera macã decopʉ wedera wáayira. Niipetira cʉ̃́ã bʉajeárare ãñurã́rẽ, ñañarã́rẽ néõ, néewayira. Teero tiirá, tiitatiare basocá dadajõãyira. ");
INSERT INTO tue_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Too síro cʉ̃́ã õpʉ̃ bosebʉreco atiarirare ĩñagʉ̃, sããjeayigʉ. Cʉ̃́ãrẽ ĩñagʉ̃, sĩcʉ̃ cʉ̃́ã decopʉ wãmosíara sãñarṍ sãñahẽgʉ̃rẽ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Cʉ̃ʉ̃rẽ jĩĩyigʉ: “Yáa wedegʉ, ¿deero tiigʉ́ sããatiarĩ mʉʉ, wãmosíari sutiro sãñaripacʉ?” Cʉ̃ʉ̃pe yʉʉmasĩriyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Cʉ̃́ã õpʉ̃ yaaré batorare jĩĩyigʉ: “Cʉ̃ʉ̃rẽ wãmorĩpʉ, dʉporipʉ siatú, naĩtĩãrõpʉ cõãwionecoya. Toopʉ́ basocá pũnisíra bacadiyó, utiadacua”, jĩĩyigʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús jĩĩwĩ sũcã: —Cõãmacʉ̃ paʉre boocópacʉ, sĩquẽrãrẽ besequi, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Too síro fariseo basoca wáajõãwã. Cʉ̃́ã Jesús merẽã yʉʉri boorá, cʉ̃ʉ̃rẽ sãĩñáãdarere quẽnoyúerira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Too síro cʉ̃́ã buerére nʉnʉrã́rẽ, Herodere tʉonʉnʉ́seramena Jesús pʉtopʉ ticocorira niiwã. Cʉ̃ʉ̃rẽ jĩĩwã: —Basocáre buegʉ́, mʉʉ ãñugʉ̃́ niirére masĩã. Mʉʉ diamacʉ̃́rã Cõãmacʉ̃ye maquẽrẽ buea. Basocá tʉsaré dícʉre wedericu. Ʉpʉtí macãrãrẽ, bʉ́ri niirã́rẽ, niyeru cʉoráre, niyeru cʉohérare sĩcãrĩbíro ĩña, wedea mʉʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Teero tiigʉ́, ¿deero wãcũĩ mʉʉ? Ʉ̃sãrẽ wedeya: ¿Romanuã õpʉ̃rẽ cʉ̃ʉ̃ niyeru wapasédutirere wapatíadari; o wapatírigarite? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesupé cʉ̃́ã wãcũrére, cʉ̃́ã ñañaré tiidʉgárere masĩjãrigʉ niiwĩ. Teero tiigʉ́, jĩĩwĩ: —Mʉ́ã ñañarã́, tiiditórepira niiã. Mʉ́ã yʉʉre teero jĩĩ, wedesãdʉgara tiia. ");
INSERT INTO tue_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niyeruqui wapatíadariquire ẽñoñá yʉʉre, jĩĩwĩ. Tiiquire cʉ̃ʉ̃rẽ néeatiwa. ");
INSERT INTO tue_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús cʉ̃́ãrẽ sãĩñáwĩ: —¿Noãyá diapóa, noã wãme tusai? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—César romanuã õpʉ̃ye tusaa, jĩĩwã. —Too docare Césaye niirére Césare wiyayá; Cõãmacʉ̃yere Cõãmacʉ̃rẽ wiyayá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, tʉomaníjõãwã. Cʉ̃ʉ̃rẽ cõãwiti, wáajõãwã. ");
INSERT INTO tue_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tiibʉrecora sĩquẽrã saduceo basoca Jesús pʉto jeawa. Cʉ̃́ã “diarira masãmʉãricua” jĩĩĩya. Jesuré sãĩñáwã: ");
INSERT INTO tue_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Basocáre buegʉ́, Moisés jĩĩriguere jĩĩãda: “Sĩcʉ̃ põnamanígʉ̃ diaweori, cʉ̃ʉ̃ bai cʉ̃ʉ̃ nʉmo niirigore dúutuaro. Cʉ̃ʉ̃ coomena cʉ̃ʉ̃ sõwʉ̃ diarigʉre põnacʉtíbosaaro”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Teerora wáayiro ʉ̃sã watoare. Sĩcʉ̃põna siete niiyira. Cʉ̃́ã sõwʉ̃ nʉmocʉtiri siro, diajõãyigʉ. Põnamanígʉ̃rã, cʉ̃ʉ̃ nʉmo niirigore cʉ̃ʉ̃ bairé cṹũyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cʉ̃ʉ̃cãrẽ teerora wáayiro. Cʉ̃ʉ̃ baicã́rẽ teero wáayiro. Teero dícʉ wáayiro. Niitugʉpʉcãrẽ teerora wáayiro. ");
INSERT INTO tue_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Too síro cʉ̃́ã nʉmo niimirigocã diajõãyigo. ");
INSERT INTO tue_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cʉ̃́ã niipetira coore nʉmocʉtimiyira. Teero tiigó, diarira masãmʉãrĩ, ¿nii nʉmope pʉtʉágodari? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesupé cʉ̃́ãrẽ yʉʉwi: —Mʉ́ã Cõãmacʉ̃ye queti jóaripũ maquẽrẽ masĩria. Cõãmacʉ̃ tutuarecãrẽ masĩria. Teero tiirá, wisijṍãã. ");
INSERT INTO tue_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Diarira masãmʉãri siro, ʉ̃mʉã́, numiã́ wãmosíaricua. Ángelea ʉ̃mʉã́sepʉ niirã́biro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Diarira masãmʉãre maquẽrẽ mʉ́ã buepacara, tʉomasĩ́ria ména. Ateré Cõãmacʉ̃ cʉ̃ʉ̃ye queti jóaripũpʉ mʉ́ãrẽ jĩĩrigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraham, Isaac, Jacob Õpʉ̃ niiã yʉʉ”, jĩĩrigʉ niiwĩ. Cõãmacʉ̃ diarira Õpʉ̃ niirii; catirá Õpʉ̃pe niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Basocá cʉ̃ʉ̃ buerére tʉorá, tʉomaníjõãwã. ");
INSERT INTO tue_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Too síro Jesús saduceo basocare sãĩñáduri tiirí ĩñarã, fariseo basoca neãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Too síro sĩcʉ̃ cʉ̃́ã menamacʉ̃ Moisés jóariguere ãñurõ masĩgʉ̃́ Jesuré “merẽã yʉʉboqui” jĩĩgʉ̃, sãĩñáwĩ: ");
INSERT INTO tue_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Basocáre buegʉ́, ¿diiyé niiĩ Moisére dutiré cṹũrigue bayiró ʉpʉtí maquẽ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —“Cõãmacʉ̃ marĩ Õpʉ̃rẽ maĩñá. Niipetire mʉ́ã yeeripũnamena, mʉ́ã wãcũrémena cʉ̃ʉ̃rẽ maĩñá”. ");
INSERT INTO tue_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tee apeyé nemorṍ niinetõnʉcãre niiã. ");
INSERT INTO tue_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tee doca maquẽ tee dutiré tiiróbiro niiã. “Mʉʉ basiro maĩrṍ tiiróbirora ãpẽrãcã́rẽ maĩñá”. ");
INSERT INTO tue_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Marĩ tee pʉawãmé dutirére tiirá, niipetire Moisére dutiré cṹũrigue, teero biiri profetas tiidutírere yʉʉra tiicú, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo basoca Jesús pʉtopʉ neãritabe, cʉ̃́ãrẽ sãĩñáwĩ: ");
INSERT INTO tue_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Mʉ́ã Cristo Cõãmacʉ̃ beserigʉre ¿deero wãcũĩ? ¿Noã pã́rãmi niinʉnʉsegʉ niiĩ? jĩĩwĩ. —Õpʉ̃ David pãrãmi niinʉnʉsegʉ niigʉ̃daqui, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Too docare David Cristo ñecʉ̃ niipacʉ, ¿deero tiigʉ́ Espíritu Santo masĩré ticorémena wedesegʉ, “cʉ̃ʉ̃ yʉʉ Õpʉ̃ niiĩ” jĩĩyiri? David ateré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Cõãmacʉ̃ jĩĩwĩ yʉʉ Õpʉ̃rẽ: “Yáa wãmo diamacʉ̃́niñape duiya, tée mʉʉrẽ ĩñatutirare mʉʉ dutiriguere yʉʉ ãñurõ yʉʉri tiirípʉ”, jĩĩ jóarigʉ niiwĩ David. ");
INSERT INTO tue_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David “yʉʉ Õpʉ̃” jĩĩgʉ̃, Cõãmacʉ̃ beserigʉre jĩĩgʉ̃ tiirígʉ niiwĩ, cʉ̃ʉ̃ pãrãmí niipacari. Teeré ãñurõ wãcũña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Cʉ̃́ã sĩcʉ̃nopera yʉʉriwa. Tiibʉrecomena “sãĩñánemoricu sáa” jĩĩ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Too síro Jesús basocáre, ʉ̃sã cʉ̃ʉ̃ bueráre jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés jóarigue buerá, fariseo basocacã Moisére dutiré cṹũriguere wederá niiĩya. ");
INSERT INTO tue_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Teero tiirá, niipetire cʉ̃́ã wederére tiinʉnʉ́seya. Cʉ̃́ã tiirécʉtirepere ĩñacũrijãña. Cʉ̃́ã wederobiro tiiríya. ");
INSERT INTO tue_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ãpẽrãrẽ́ tiipõtẽ́õña manirére dutiiya. Nʉcʉ̃rére siatúpeora tiiróbiro tiiíya. Tee aparáre péerogã tiiápuriya. ");
INSERT INTO tue_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Niipetire cʉ̃́ã tiirére basocá ĩñaãrõ jĩĩrã, teeré tiiíya. Cõãmacʉ̃ye queti jóaripũ sã́ãretibari pacasãñuretibari cʉoóya. Teero biiri cʉ̃́ã súubuseri ĩñaãrõ jĩĩrã, ãpẽrã́ nemorṍ cʉ̃́ã súubuseri sutiro yapa opadari cʉorócare sãñaãya. ");
INSERT INTO tue_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bosebʉreco niirĩ, sʉguero maquẽ duirépʉ dícʉ duidʉgacua. Neãré wiseripʉcãrẽ teerora tiidʉgácua. ");
INSERT INTO tue_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Macã decopʉ quioníremena ãñudutiri boocúa. Cʉ̃́ãrẽ “ʉ̃sãrẽ buerá” jĩĩrĩ boocúa. ");
INSERT INTO tue_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Mʉ́ã doca “ʉ̃sãrẽ buerá” jĩĩdutirijãña. Mʉ́ãrẽ buegʉ́ sĩcʉ̃rã niiĩ. Mʉ́ã sĩcʉ̃põnarã niiã. ");
INSERT INTO tue_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Atiditapʉ́re sĩcʉ̃ basocʉ́re “ʉ̃sã pacʉ” jĩĩrijãña. Mʉ́ã sĩcʉ̃rã pacʉcʉtia; cʉ̃ʉ̃ ʉ̃mʉã́sepʉ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mʉ́ãrẽ “ʉ̃sã õpʉ̃” jĩĩrijããrõ. Cristo Cõãmacʉ̃ beserigʉ sĩcʉ̃rã mʉ́ã Õpʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉ́ã menamacʉ̃ ãpẽrãrẽ́ tiiápugʉ cʉ̃ʉ̃rã́ niiĩ ãpẽrã́ nemorṍ ʉpʉtí macʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sĩcʉ̃ cʉ̃ʉ̃ basiro “ãpẽrã́ nemorṍ yʉʉre padeorí booa” jĩĩgʉ̃́ bʉ́ri niigʉ̃́ tiinógʉ̃daqui. Teero jĩĩhẽgʉ̃nopereja Cõãmacʉ̃ ãpẽrãrẽ́ padeorí tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉserare cãmotára tiia. Mʉ́ã Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉsedʉgaricu; wãcũnʉnʉsedʉgarare cãmotáa. ");
INSERT INTO tue_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Niyeru boorá, wapewia numiãye wiserire jĩĩditoremena ẽmacu. Mʉ́ã yoari Cõãmacʉ̃mena wedesera tiiróbiro tiiditócu basocáre. Mʉ́ãrã ãpẽrã́ nemorṍ ñañarõ tiinóãdara niiã. ");
INSERT INTO tue_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Día pairímaapʉ tĩã, yoaro niiré macãrĩpʉ mʉ́ã buerére nʉnʉã́darare ãmaãrã wáaa. Sĩcʉ̃rẽ bʉa, mʉ́ã buerémena cʉ̃ʉ̃rẽ mʉ́ã nemorṍ pecamepʉ wáagʉdʉ niirĩ tiia. ");
INSERT INTO tue_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Bóaneõrã niiã mʉ́ã. Mʉ́ã ĩñahẽrã ãpẽrãrẽ́ wéesʉguera tiiróbiro niiã. Mʉ́ã basocáre ateré buea: “Sĩcʉ̃ ‘Cõãmacʉ̃wiimena diamacʉ̃́ jĩĩã’ jĩĩãri siro, cʉ̃ʉ̃ jĩĩãriguere tiihéri, wapa maniã” jĩĩcu mʉ́ã. Atepé docare “cʉ̃ʉ̃ ‘Cõãmacʉ̃wii maquẽ oromena diamacʉ̃́ jĩĩã’ jĩĩrĩ, teerora tiiáro” jĩĩcu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mʉ́ã tʉomasĩ́ridojãcu. Oro Cõãmacʉ̃wiipʉ niijĩrõ, Cõãmacʉ̃ ĩñacoropʉ ãñuré pʉtʉácu. Teero tiiró, ¿diiyépe nemorṍ ʉpʉtí maquẽ niiĩ, orope o Cõãmacʉ̃wiipe? ");
INSERT INTO tue_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mʉ́ã ateré buea: “Sĩcʉ̃ ‘Cõãmacʉ̃rẽ wáicʉra sóepeoromena diamacʉ̃́ jĩĩã’ jĩĩãri siro, cʉ̃ʉ̃ jĩĩãriguere diamacʉ̃́ tiihéri, wapa maniã” jĩĩcu mʉ́ã. Atepé docare “cʉ̃ʉ̃ ‘toopʉ́ wáicʉra Cõãmacʉ̃rẽ ticorémena diamacʉ̃́ jĩĩã’ jĩĩrĩ, teerora tiiáro” jĩĩcu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mʉ́ã tʉomasĩ́ridojãcu. Cõãmacʉ̃rẽ ticoré wáicʉra sóepeoro sotoapʉ niijĩrõ, cʉ̃ʉ̃ ĩñacoropʉ ãñuré pʉtʉácu. Teero tiiró, ¿diiyépe nemorṍ ʉpʉtí maquẽ niiĩ, Cõãmacʉ̃rẽ ticorépe o wáicʉra sóepeorope? ");
INSERT INTO tue_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Teero tiigʉ́, sĩcʉ̃ “Cõãmacʉ̃rẽ wáicʉra sóepeoromena diamacʉ̃́ jĩĩã” jĩĩgʉ̃, toopʉ́ péoarigʉmenacãrẽ teerora jĩĩgʉ̃ tiii. ");
INSERT INTO tue_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sĩcʉ̃ “Cõãmacʉ̃wiimena diamacʉ̃́ jĩĩã” jĩĩgʉ̃, Cõãmacʉ̃menacãrẽ teerora jĩĩgʉ̃ tiii. ");
INSERT INTO tue_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sĩcʉ̃ “ʉ̃mʉã́semena diamacʉ̃́ jĩĩã” jĩĩgʉ̃, Cõãmacʉ̃ duirípĩrõmena, teero biiri toopʉ́ duigʉ́menacãrẽ teerora jĩĩgʉ̃ tiii. ");
INSERT INTO tue_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Mʉ́ã oteré metãgãrẽ “menta”, “anís”, “comino” wãmecʉtire yaaré sitiaãñúre tiirénorẽ seenéõ, opaquẽrĩ tiicú. Pʉamóquẽñequẽrĩ cʉorá, sicaquẽ Cõãmacʉ̃wiipʉ néewa, “yʉʉ Cõãmacʉ̃rẽ ticoré niiã” jĩĩ, pairé ticocu. Teero tiipacára, nemorṍ ʉpʉtí maquẽrẽ tiiría. Moisére dutiré cṹũriguecãrẽ tiiría. Basocáre queoró dutiróbiro tiiría. Bóaneõre ẽñoría. Cõãmacʉ̃rẽ padeoría. Mʉ́ã oterére cʉ̃ʉ̃rẽ ticorucurobirora tee ʉpʉtí maquẽcãrẽ tiiró booa. ");
INSERT INTO tue_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mʉ́ã ĩñahẽrã ãpẽrãrẽ́ wéesʉguera tiiróbiro niiã. Bʉ́ri niirére ãñurõmena tiipetípacara, ʉpʉtí maquẽ tiirépere wãcũria. ");
INSERT INTO tue_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Baparí sotoápʉ dícʉ coseárigue tiiróbiro niiã. Popeapʉre mʉ́ã ãpẽrãyére ẽmaré, teero biiri niyeru cʉopacára boonemósãjãre dadanetõjõãã. ");
INSERT INTO tue_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉ́ã fariseo basoca tʉomasĩ́hẽrã, ĩñahẽrã tiiróbiro niiã. Popeapʉ maquẽ cosesʉguéya. Teero tiirá, bapa sotoápʉcãrẽ ãñurõ coseári bapa tiiróbiro niiãdacu. ");
INSERT INTO tue_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Mʉ́ã diarira cṹũre wiseri boremena tuusĩã́re wiseri tiiróbiro niiã. Sotoápʉre ãñurõ baucú. Popeapʉre diarira cõãrĩ́, niipetire bóarigue dadajõãcu. ");
INSERT INTO tue_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mʉ́ãcã teerora basocá ãñurã́ baucú ãpẽrã́ ĩñacoropʉ. Popeapʉpere ãñuré tiidʉgáre manicú sáa. Ñañaré niinetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri fariseo basoca. Mʉ́ã basocá ĩñacoropʉ dícʉ ãñurõ tiia. Mʉ́ã profetaye masãcoperi sotoapʉ ãñuré wiserigã tiinʉcṍã. Ãpẽrã́ basocá ãñurã́ niirirare cṹũre wiserire mamoã. ");
INSERT INTO tue_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mʉ́ã biiro jĩĩã: “Ʉ̃sã ñecʉ̃sʉ̃mʉãniãrã catiritopʉre ʉ̃sã niirãjã, merẽã tiibójĩyu. Cʉ̃́ã profetare sĩãdutíri, ʉ̃sã sĩãdutíribojĩyu”, jĩĩã. ");
INSERT INTO tue_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mʉ́ã teeré teero jĩĩrã, mʉ́ã basiro “profetare sĩãríra pãrãmerã niinʉnʉsera niiã” jĩĩrã tiia. ");
INSERT INTO tue_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Teero tiirá, mʉ́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatirirobirora tiiyapácʉtijãña. ");
INSERT INTO tue_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Mʉ́ã ãñaã tiiróbiro ñañaré tiirá niiã. Mʉ́ã deero tii Cõãmacʉ̃ pecamepʉ ñañarõ tiiádarere netõmasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Teero tiigʉ́, yʉʉ mʉ́ã pʉtopʉre profetare, Cõãmacʉ̃ dutiré masĩrã́rẽ, Cõãmacʉ̃ye bueadarare ticocogʉda. Mʉ́ãpe cʉ̃́ã sĩquẽrãrẽ sĩã, ãpẽrãrẽ́ curusapʉ páabiatu sĩãdutíadacu; ãpẽrãrẽ́ cʉ̃́ã neãré wiseripʉ tãna, cʉ̃́ã wáare macãrĩpʉ nʉnʉã́dacu. ");
INSERT INTO tue_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mʉ́ã teero tiirá, niipetira basocá ãñurã́rẽ sĩãrígue wapa mʉ́ã wapa cʉoa. Mʉ́ã ñecʉ̃sʉ̃mʉã Abel basocʉ́ ãñugʉ̃́rẽ sĩãsʉguéyira. Tée Zacarías Berequías macʉ̃rẽ sĩãyapácʉtiyira. Zacaríare sĩãyíra Ãñunetõjõãri Tatia sããwaro pʉtopʉ. ");
INSERT INTO tue_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã atitó macãrãpʉ niipetire cʉ̃́ã teero tiiríguere wapa cʉoa, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús Jerusalén macãrãrẽ wãcũgʉ̃, jĩĩwĩ: —Jerusalén macãrã, mʉ́ã profetare sĩãrã́ niiã; Cõãmacʉ̃ye wederáre ʉ̃tãperimena déesĩãrã niiã. Mʉ́ãrẽ maĩgʉ̃́, pee peti néõdʉgamiwʉ̃. Cãrẽquẽ coo põnarẽ́ wʉ́ʉre docapʉ néõcũrõbiro tiidʉgámiwʉ̃. Mʉ́ãpe booríwʉ. ");
INSERT INTO tue_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Teero tiiró, mʉ́ãya macã cõõjṍããdacu. ");
INSERT INTO tue_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yʉʉ ateré jĩĩã: Yʉʉre ĩñanemoricu; tée mʉ́ã yʉʉre “ãni Cõãmacʉ̃ ticodiocorigʉ ãñunetõjõãĩ” jĩĩrãpʉ, ĩñaãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Cõãmacʉ̃wiipʉ niiãrigʉ witiwari, ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto wáawʉ. Cõãmacʉ̃wii, teero biiri tiiwiiména niiré wiserire “ãñuré wiseri niiã” jĩĩ, cʉ̃ʉ̃rẽ wedewawʉ. ");
INSERT INTO tue_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cʉ̃ʉ̃pe ʉ̃sãrẽ jĩĩwĩ: —Mʉ́ã iye niipetire wiserire ĩñamiã. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Too síro ʉ̃tãqui apequí sotoápʉ weemʉãrigue pʉtʉáricu. Niipetire cõãnoãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Too síro Ʉ̃tãgʉ̃́ Olivopʉ jea, Jesús duirigʉ niiwĩ. Ʉ̃sã cʉ̃ʉ̃ buerá ãpẽrã́ tʉohéropʉ cʉ̃ʉ̃rẽ jea, sãĩñáwʉ̃: —Wedeya ʉ̃sãrẽ. Mʉʉ wedearigue ¿deero biiri wáaadari? ¿Ñeenómena mʉʉ pʉtʉaatiadarere, teero biiri atibʉ́reco petiádarere ĩñamasĩnoãdari? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús yʉʉwi: —Ãñurõ tʉomasĩ́ña, ãpẽrã́ jĩĩditori jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Paʉ “yʉʉrá niiã; yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩãdacua. Paʉ cʉ̃́ãrẽ nʉnʉã́dacua. ");
INSERT INTO tue_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Apeyé, “cãmerĩ́sĩãrã tiiáwã” jĩĩrĩ tʉoádacu. “Toopʉ́ cãmerĩ́sĩãrã tiiáyira” jĩĩré queticãrẽ tʉoádacu. Teeré tʉorá, cuirijãña. Tee wáaadare niijãrõ tiia. Teero wáapacari, atibʉ́reco petiádaro dʉsaádacu ména. ");
INSERT INTO tue_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sicapõna macãrã apepõná macãrãmena cãmerĩ́sĩããdacua. Teero biiri sicadita macãrã apeditá macãrãmena cãmerĩ́sĩããdacua. Jʉabóare wáaadacu. Peeditapʉre dita cãmeñare wáaadacu. ");
INSERT INTO tue_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tee niipetiremena basocáre bayiró ñañarõ netõré nʉcãã́dacu. ");
INSERT INTO tue_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Teero wáari, mʉ́ãrẽ ñee, dutirápʉre tico, ñañarõ tiidutíadacua. Mʉ́ãrẽ sĩãã́dacua. Niipetira basocá mʉ́ãrẽ ĩñatutiadacua yʉʉre padeoré wapa. ");
INSERT INTO tue_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Teero wáari, paʉ yʉʉre padeomírira padeodúadacua. Cʉ̃́ã menamacãrã niimirirare ticoadacua dutirápʉre. Cãmerĩ́ ĩñatutiadacua. ");
INSERT INTO tue_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Paʉ “yʉʉ profeta niiã” jĩĩãdacua. Paʉre jĩĩdito, padeorí tiiádacua. ");
INSERT INTO tue_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ñañaré pee niiãdacu. Teero wáari, paʉ cãmerĩ́ maĩdúadacua. ");
INSERT INTO tue_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yʉʉre padeorucújãrã docare Cõãmacʉ̃ netõnégʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Niipetiro atibʉ́recopʉ ãñuré queti “Cõãmacʉ̃ dutiré basocápʉre niiãdare jeaadaro tiia” jĩĩrére niipetiropʉ wedenoãdacu, niipetire dita macãrã masĩãrõ jĩĩrã. Tee wáari siro, atibʉ́reco petiádacu sáa. ");
INSERT INTO tue_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ñañanetõnʉcãgʉ̃rẽ Cõãmacʉ̃rẽ padeorídojãgʉ̃rẽ ĩñaãdacu mʉ́ã. Cʉ̃ʉ̃ Cõãmacʉ̃wii popeapʉ jeagʉdaqui. Profeta Daniel tee maquẽrẽ wederigʉ niiwĩ. (Ateré buegʉ́ tʉomasĩ́ãrõ.) ");
INSERT INTO tue_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Teero wáari ĩñarã, Judea ditapʉ niirã́ ʉ̃tãyucʉpʉ dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wii sotoápʉ pesagʉ́no diiwá, wii popeapʉ niirére néegʉ̃ sããwaripacʉ, dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wesepʉ́ padegʉ́cã wiipʉ́ sutiré néegʉ̃ pʉtʉawaripacʉ, dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Teero wáare bʉrecori niipacósãnumiãrẽ, põna ũpũrã́ cʉoráre bóaneõre bʉrecori niiãdacu. ");
INSERT INTO tue_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Dutiwáre bʉrecori púuriro niiré bʉrecori wáarijããrõ; yeerisãri bʉreco wáarijããrõ” jĩĩ, Cõãmacʉ̃rẽ sãĩñá. ");
INSERT INTO tue_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Teero wáare bʉrecori basocáre bayiró ñañarõ netõré bʉrecori niiãdacu. Cõãmacʉ̃ atibʉ́reco tiirí sirore, tée atitópʉre nocõrõ ñañarõ netõré maniríro niiwʉ̃. Too síropʉcãrẽ nocõrõ peti ñañarõ netõré maniã́dacu. ");
INSERT INTO tue_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tee ñañarõ netõré bʉrecorire Cõãmacʉ̃ dʉ́oriatã, sĩcʉ̃no netõrídojãgʉ̃daqui. Cõãmacʉ̃pe cʉ̃ʉ̃ beserirare tiigʉ́, teero wáare bʉrecorire dʉ́ogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Teero wáari, sĩquẽrã mʉ́ãrẽ jĩĩditoadacua: “Jã́ã, ĩñaña. Cõãmacʉ̃ beserigʉ Cristo ãno niiĩ”, jĩĩmiãdacua. “Toopʉ́ niiĩ”, jĩĩmiãdacua ãpẽrãpé. Cʉ̃́ã teero jĩĩrĩ, padeoríjãña. ");
INSERT INTO tue_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paʉ jĩĩditora niiãdacua. Sĩquẽrã “yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩmiãdacua. “Profeta niiã” jĩĩmiãdacua ãpẽrãpé. Pee tiiẽ́ñore tiiádacua, cʉ̃́ãrẽ padeoáro jĩĩrã. Cõãmacʉ̃ beserirapʉrena padeodúri tiidʉgámiãdacua. ");
INSERT INTO tue_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tee niiãdarerena mʉ́ãrẽ yʉʉ wedesʉguetoaa. ");
INSERT INTO tue_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Teero tiirá, ãpẽrã́ mʉ́ãrẽ “jõõpʉ basocá manirṍpʉ Cristo niiãwĩ” jĩĩrĩ, wáarijãña. “Atiwií macã sawipʉ niiãwĩ” jĩĩrĩ, padeoríjãña. ");
INSERT INTO tue_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Apetóre bʉpo wã́ãyori, muĩpũ mʉãatirope tée cʉ̃ʉ̃ sããwarope bóesesajõãã. Teero wáarobirora wáaadacu, yʉʉ niipetira sõwʉ̃ atiri. ");
INSERT INTO tue_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wáicʉ bóari, yucaa máata masĩcua. Cʉ̃́ã tiiróbirora yʉʉ jĩĩãrigue wáari ĩñarã, yʉʉ atiadarere máata masĩãdacu. ");
INSERT INTO tue_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Tee ñañarõ netõré bʉrecori sirogã muĩpũ bʉ́reco macʉ̃ naĩtĩãjõãgʉ̃daqui. Ñami macʉ̃cã bóeriqui. Ñocõã́ ñaacodiadacua. Niipetira ʉ̃mʉã́sepʉ niirã́ cãmeñanoãdacua. ");
INSERT INTO tue_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Teero wáari, ʉ̃mʉã́sepʉ sica ẽñoré bauádacu. Teeré ĩñarã, yʉʉ niipetira sõwʉ̃ atiadarere masĩãdacua. Teero tiirá, niipetire macãrĩ macãrã utiadacua. Yʉʉ niipetira sõwʉ̃ õmebʉrʉáripʉ tutuaremena asibatédiatiri ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Corneta bʉsʉri, ángeleare ticocogʉdacu. Cʉ̃́ã néõãdacua yʉʉ beserirare atibʉ́reco niipetiropʉ niirã́rẽ. ");
INSERT INTO tue_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Mʉ́ãrẽ oterigʉ higueragʉmena queoré ticogʉda. Tiigʉ́ pṹũrĩ wasorí, “cʉ̃ma wáaadaro péerogã dʉsaa” jĩĩmasĩã. ");
INSERT INTO tue_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Teerora niipetire yʉʉ jĩĩãrigue wáari ĩñarã, “niipetira sõwʉ̃ pʉtʉaatiadaro péerogã dʉsacú” jĩĩ masĩña. ");
INSERT INTO tue_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Atitó macãrã cʉ̃́ã diaadari sʉguero, tee niipetire yʉʉ jĩĩãrigue wáaadacu. ");
INSERT INTO tue_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ʉ̃mʉã́se, atiditá peticódiaadacu. Yʉʉ wedesere doca petirícu. Niirucujããdacu. ");
INSERT INTO tue_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Yʉʉ pʉtʉaatiadari bʉreco, tii horare masĩña maniã. Ángelea ʉ̃mʉã́se macãrã masĩriya. Yʉʉ niipetira sõwʉ̃cã masĩria. Yʉʉ Pacʉ sĩcʉ̃rã masĩqui. ");
INSERT INTO tue_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Yʉʉ niipetira sõwʉ̃ pʉtʉaatiadari sʉguerogã, Noé niirito wáarirobiro wáaadacu. ");
INSERT INTO tue_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Atibʉ́reco dúuadari sʉguero, basocá yaa, sĩni, wãmosía, cʉ̃́ã põna numiãrẽ numicũ tiiyíra. Tée Noé dooríwʉcapʉ sããwaripʉ, tiitúcoyira. ");
INSERT INTO tue_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Cʉ̃́ã “merẽã wáaricu” jĩĩ wãcũpacari, oco pea, día duanetõrĩ, diapetijõãyira. Yʉʉ niipetira sõwʉ̃ pʉtʉaatiricãrẽ, basocá teerora tiiádacua. ");
INSERT INTO tue_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Teebʉrecorire ʉ̃mʉã́ pʉarã́ wesepʉ́ niiãdacua. Sĩcʉ̃ néemʉãnogʉ̃daqui; ãpĩ pʉtʉágʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pʉarã́ numiã trigo wãñiãrã́ niiãdacua. Sĩcõ néemʉãnogõdaco; apegó pʉtʉágodaco. ");
INSERT INTO tue_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Teero tiirá, ĩñacorucujãña. Mʉ́ãcã yʉʉ mʉ́ã Õpʉ̃ pʉtʉaatiadari bʉrecore masĩricu. ");
INSERT INTO tue_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ateré masĩña: Wii õpʉ̃ “ñamirẽ tii hora niirĩ, yaarépigʉ jeagʉdaqui” jĩĩ masĩgʉ̃, cãnihẽ́gʉ̃rã coteboqui. Cʉ̃ʉ̃ya wiire pã́õsãrĩ jĩĩgʉ̃, cãmotáqui. ");
INSERT INTO tue_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Teero tiirá, mʉ́ãcã ãñurõ yueya. Mʉ́ã wãcũhẽritabe, yʉʉ niipetira sõwʉ̃ pʉtʉaatigʉdacu. ");
INSERT INTO tue_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Mʉ́ã sĩcʉ̃ ʉ̃mʉ ãñurõ masĩgʉ̃́ cʉ̃ʉ̃ õpʉ̃yere ãñurõ dutibosagʉ tiiróbiro niiña. Cʉ̃ʉ̃ õpʉ̃ aperopʉ́ wáagʉ, cʉ̃ʉ̃rẽ jĩĩqui: “Yáa wii macãrãrẽ bʉ́recoricõrõ yaaré ticoya”, jĩĩqui. ");
INSERT INTO tue_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ãñurõ dutibosagʉ cʉ̃ʉ̃rẽ dutiariguere tiirucúqui. Teero tiigʉ́, cʉ̃ʉ̃ õpʉ̃ coerí, ʉseniqui. ");
INSERT INTO tue_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃ʉ̃ ãñurõ tiiré wapa cʉ̃ʉ̃ õpʉ̃ niipetire cʉ̃ʉ̃ cʉorére dutibosagʉ sõnecogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ãpĩpé “yʉʉ õpʉ̃ máata coeríqui” jĩĩ wãcũgʉ̃, ñañarõ tiiquí. ");
INSERT INTO tue_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Padecoterare ñañarõ tiinʉcã́qui. Cũmurã́mena boseya, sĩni tiiquí. ");
INSERT INTO tue_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cʉ̃ʉ̃ õpʉ̃ cʉ̃ʉ̃ wãcũhẽritabe, coegʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cʉ̃ʉ̃ dutiriguere tiirírigue wapa bayiró ñañarõ tiigʉ́daqui. Ãpẽrã́ ĩñacoropʉ dícʉ ãñuré tiiditórirare cʉ̃ʉ̃ cʉ̃́ãrẽ cõãriropʉ cʉ̃ʉ̃cãrẽ cõãgʉ̃daqui. Toopʉ́ basocá pũnisíra bacadiyó, utiadacua. ");
INSERT INTO tue_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã. Pʉamóquẽñerã numiã cʉ̃́ã sĩãwócorepa née, cʉ̃́ã menamacõ manʉ niigʉ̃dʉre bocara wáayira. ");
INSERT INTO tue_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sicamoquẽñerã numiã tʉomasĩ́hẽrã niiyira. Ãpẽrã́ sicamoquẽñerã numiã ãñurõ masĩrã́ niiyira. ");
INSERT INTO tue_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tʉomasĩ́hẽrã numiã cʉ̃́ãye sĩãwócorepa néewapacara, ʉse too síro píosããdarere néewariyira. ");
INSERT INTO tue_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ãñurõ masĩrã́ numiãpe ʉsepa néewayira sĩãwócorepamena. ");
INSERT INTO tue_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wãmosíagʉdʉ máata jeariyigʉ. Niipetira numiãrẽ wʉgoá jeari, cãnijṍãyira. ");
INSERT INTO tue_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ñami deco acaribíri tʉoyíra: “¡Wãmosíagʉdʉ atitoai! ¡Bocara atiya!” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Niipetira numiã wãcã, cʉ̃́ãye sĩãwócorepare quẽnoyíra. ");
INSERT INTO tue_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tʉomasĩ́hẽrã numiãpe ãñurõ masĩrã́ numiãrẽ jĩĩyira: “Ʉ̃sãcãrẽ ʉse ticoya; ʉ̃sã sĩãwócorepa yatiro tiia”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ãñurõ masĩrã́ numiãpe yʉʉyira: “Ticoria. Ʉ̃sã ticori, ʉ̃sãcãrẽ jeari, mʉ́ãcãrẽ jeari tiibócu. Mʉ́ã basiro ʉse dúari basoca pʉtopʉ sãĩrã́ wáaya mʉ́ã sĩãwócoadarere”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cʉ̃́ã sãĩrã́ wáaari siro, wãmosíagʉdʉ jeayigʉ. Ãñurõ ĩñacoarira bosebʉreco tiirí wiipʉ cʉ̃ʉ̃mena sããwayira. Cʉ̃́ã sããwaari siro, sope biajṍãyiro. ");
INSERT INTO tue_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Too síropʉ ãpẽrã́ numiãpe jea, “ʉ̃sã õpʉ̃, ʉ̃sãrẽ sope pã́õña” jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Cʉ̃ʉ̃pe yʉʉyigʉ: “Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ãrẽ masĩriga”, jĩĩyigʉ, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús tee queorére wedeari siro, jĩĩwĩ: —Yʉʉ atiadari bʉrecore tii horare mʉ́ã masĩria. Teero tiirá, ãñurõ ĩñacorucujãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús ʉ̃sãrẽ wedenemowĩ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã. Sĩcʉ̃ basocʉ́ yoaropʉ wáagʉdʉ tiiyígʉ. Cʉ̃ʉ̃ wáaadari sʉguero, cʉ̃ʉ̃ye dutibosarare sʉocó, cʉ̃ʉ̃ye niyerure cʉ̃́ãmena cṹũyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sĩcʉ̃rẽ sicamoquẽñepori, ãpĩrẽ́ pʉapó, ãpĩrẽ́ sicapo niyeruquiripori ticoyigʉ. Cʉ̃́ã paderépʉre ĩñaco, ticoyucoyigʉ. Too síro wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dutibosagʉ sicamoquẽñepori ñeerigʉ tee niyerumena pade, máata apeyé sicamoquẽñepori wapatánemoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pʉapó ñeerigʉcã teerora apeyé pʉapó wapatánemoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sicapo ñeerigʉpe cope coa, cʉ̃́ãrẽ dutigʉ́ye niyerure tiicopepʉ yaacṹjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Yoari siropʉ, cʉ̃́ãrẽ dutigʉ́ coeyígʉ. Coe, cʉ̃́ãrẽ “yée niyerure ¿deero tiirí?” jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sicamoquẽñepori ñeerigʉ cʉ̃ʉ̃ pʉto jeanʉcãyigʉ. Apeyé sicamoquẽñepori cʉ̃ʉ̃ pade wapatárere néeatigʉ, jĩĩyigʉ: “Yʉʉre dutigʉ́, sicamoquẽñepori mʉʉ yʉʉre cṹũwʉ̃. Teeména nocõrõrã pade wapatánemowʉ̃. Ate niiã apeyé sicamoquẽñepori”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cʉ̃́ãrẽ dutigʉ́ cʉ̃ʉ̃rẽ jĩĩyigʉ: “Ãñurõ tiiyú. Dutibosagʉ ãñurõ diamacʉ̃́ tiigʉ́ niiã mʉʉ. Yʉʉ péerogã cṹũriguemena ãñurõ tiiyú. Mʉʉ ãñurõ tiirígue wapa pee dutigʉ́ cṹũgʉ̃da. Yʉʉmena ʉsenirucujãña”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Too síro pʉapó ñeerigʉ cʉ̃ʉ̃ pʉto jeanʉcã jĩĩyigʉ: “Yʉʉre dutigʉ́, mʉʉ yʉʉre pʉapó cṹũwʉ̃. Teeména nocõrõrã pade wapatánemowʉ̃. Ate niiã apeyé pʉapó”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cʉ̃́ãrẽ dutigʉ́ cʉ̃ʉ̃rẽ jĩĩyigʉ: “Ãñurõ tiiyú. Dutibosagʉ ãñurõ tiigʉ́ niiã mʉʉ. Yʉʉ péerogã cṹũriguemena ãñurõ tiiyú. Mʉʉ ãñurõ tiirígue wapa pee dutigʉ́ cṹũgʉ̃da. Yʉʉmena ʉsenirucujãña”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Too síro sicapo ñeerigʉcã cʉ̃ʉ̃ pʉto jeanʉcã, jĩĩyigʉ: “Yʉʉre dutigʉ́, mʉʉ tutuare padedutigʉ niirére masĩwʉ̃. Paderipacʉ, ãpẽrã́ paderémena wapatáa. ");
INSERT INTO tue_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Teero tiigʉ́, cui, mʉʉye niyerure dita popeapʉ yaacṹjãwʉ̃. Ate niiã mʉʉye”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Cʉ̃́ãrẽ dutigʉ́ cʉ̃ʉ̃rẽ yʉʉyigʉ: “Mʉʉ dutibosagʉ ñañagʉ̃́, dadegʉ́ niiã. ‘Paderipacʉ, ãpẽrã́ paderémena wapatái’ jĩĩ masĩmiyu. ");
INSERT INTO tue_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Teeré masĩgʉ̃jã, yée niyerure ĩñanori wiipʉ néewa, cṹũbojĩyu. Yʉʉ coegʉ́ tee bʉcʉáremena ñeenemoboajĩyu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Toopʉ́ niirã́rẽ jĩĩyigʉ: “Tiipore ẽmajãña. Pʉamóquẽñepori cʉogʉ́pere ticoya. ");
INSERT INTO tue_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pee cʉogʉ́norẽ nemorṍ ticonoãdacu. Pee cʉogʉ́daqui. Cʉohégʉnopere cʉ̃ʉ̃ cʉomírere ẽmajãnoãdacu. ");
INSERT INTO tue_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ãni dutibosagʉ queoró tiihégʉre naĩtĩãrõpʉ cõãwionecoya. Toopʉ́ pũnisíra bacadiyó, utiadacua”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Yʉʉ niipetira sõwʉ̃ asibatéremena pʉtʉaatiri, õpʉ̃ duirípĩrõpʉ dutiduigʉdacu. Ángelea niipetira yʉʉmena atiadacua. ");
INSERT INTO tue_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Niipetire dita macãrã yʉʉ duiró pʉtopʉ neããdacua. Teero tiigʉ́, cʉ̃́ãrẽ pʉapõná batonʉcõgʉ̃da. Sĩcʉ̃ ecará coterí basocʉ ovejare merẽã, cabrare merẽã batonʉcõgʉ̃ tiiróbiro tiigʉ́da. ");
INSERT INTO tue_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Basocá ãñurã́rẽ diamacʉ̃́pe, ãpẽrãrẽ́ acuniñape nʉcõgʉ̃́da. ");
INSERT INTO tue_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Too síro yʉʉ diamacʉ̃́pe nucũrã́rẽ jĩĩgʉ̃da: “Mʉ́ã yʉʉ Pacʉ ãñurõ tiinórira, atiya. Atibʉ́reco nʉcãrípʉ mʉ́ã niiãdarore quẽnosʉguétoarigʉ niiwĩ. Teeré ñeerã atiya sáa. ");
INSERT INTO tue_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉʉ jʉabóari, ecawʉ́. Yʉʉ oco sĩnidʉgári, tĩ́ãwʉ̃. Yʉʉ aperopʉ́ wáanetõrĩ, cãnirṍ ticowʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yʉʉ sutimanírĩ, sã́ãwʉ̃. Yʉʉ diarecʉtiri, ĩñacãmesãwʉ̃. Yʉʉ peresuwiipʉ duiri, ĩñarã jeawʉ”, jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Teero tiirá, basocá ãñurã́ jĩĩãdacua: “Ʉ̃sã Õpʉ̃, ¿deero biiri mʉʉ jʉabóari, ecarí? ¿Deero biiri oco sĩnidʉgári, tĩ́ãrĩ? ");
INSERT INTO tue_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Deero biiri aperopʉ́ wáanetõrĩ, cãnirṍ ticori? ¿Deero biiri sutimanírĩ, sã́ãrĩ? ");
INSERT INTO tue_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Deero biiri diarecʉtigʉre o peresuwiipʉ duigʉ́re ĩñarã jeari?” jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Cʉ̃́ãrẽ yʉʉgʉda: “Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã yʉʉre padeoráre ʉpʉtí macãrã niihẽrãrẽ teero tiirá, yʉʉrena tiirá tiiwʉ́”. ");
INSERT INTO tue_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Too síro acuniñape nucũrã́rẽ jĩĩgʉ̃da: “Mʉ́ã Cõãmacʉ̃ ñañarõ tiinóãdara niiã. Teero tiirá, ãnorẽ́ niirijãña. Pecame petihérimepʉ wáaya. Tiimé wãtĩãrẽ dutigʉ́re, cʉ̃ʉ̃yara ángelea ñañarã́rẽ quẽnoyúerime niiã. ");
INSERT INTO tue_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉʉ jʉabóari, ecaríwʉ. Yʉʉ oco sĩnidʉgári, tĩ́ãriwʉ. ");
INSERT INTO tue_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉʉ aperopʉ́ wáanetõrĩ, cãnirṍ ticoriwʉ. Yʉʉ sutimanírĩ, sã́ãriwʉ. Yʉʉ diarecʉtiri, peresuwiipʉ duiricãrẽ, ĩñarã jeariwʉ”, jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Cʉ̃́ãcã teerora jĩĩãdacua: “Ʉ̃sã Õpʉ̃, mʉʉ jʉabóari, oco sĩnidʉgári, aperopʉ́ wáanetõrĩ, sutimanírĩ, diarecʉtiri, o peresuwiipʉ duiri, ¿deero biiri ʉ̃sã mʉʉrẽ tiiápuriri?” jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Yʉʉ cʉ̃́ãrẽ yʉʉgʉda: “Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã yʉʉre padeoráre ʉpʉtí macãrã niihẽrãrẽ tiiápuhera, yʉʉrena tiiápuhera tiiwʉ́”, jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Cʉ̃́ã wáajõããdacua ñañarõ netõrucújããdaropʉ. Basocá ãñurã́pe catiré petihéropʉ wáaadacua, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús tee niipetire wedeari siro, ʉ̃sãrẽ jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mʉ́ã masĩã: Pascua bosebʉreco wáaadaro pʉabʉ́reco dʉsaa. Tii bosebʉreco niirĩ, yʉʉ niipetira sõwʉ̃ ãpẽrãpʉ́re ticonogʉ̃dacu. Curusapʉ páabia, sĩãdutíadacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Teebʉrecorire paiaré dutirá, teero biiri bʉtoá dutirá neãyira paiaré dutigʉ́ya wiicapʉ. Cʉ̃ʉ̃ wãmecʉtiwi Caifás. ");
INSERT INTO tue_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cʉ̃́ã Jesuré yayióremena ñeeãdarere cãmerĩ́ wedeseyira, sĩãdʉgára. ");
INSERT INTO tue_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Cʉ̃́ã jĩĩyira: —Bosebʉreco niirĩ, tiiríjããda. Basocá cʉ̃ʉ̃rẽ maĩrã́, marĩmena cúara, noo booró acaribíãmajãbocua, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betaniapʉ Simón õpʉ̃ʉ̃ bóa netõrígʉya wiipʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús yaaduiritabe, sĩcõ numiṍ sitiaãñúriga cʉogó cʉ̃ʉ̃ pʉto jeawo. Tiigá sitiaãñúre wapapacáre posecʉtíwʉ. Cʉ̃ʉ̃ya dupu sotoapʉ teeré píopeowo. ");
INSERT INTO tue_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Coo teero tiirí ĩñarã, ʉ̃sã cʉ̃ʉ̃ buerá cúawʉ. Ʉ̃sã basiro cãmerĩ́ jĩĩwʉ̃: —¿Ateré bʉ́ri peti teero tiicõã́ĩ? ");
INSERT INTO tue_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ate sitiaãñúrere dúa, pairó niyeru bʉanóboayu. Teeména bóaneõrãrẽ tiiápuro boomíãyu, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ʉ̃sã teero jĩĩrĩ tʉo, jĩĩwĩ: —¿Deero tiirá atigoré potocṍĩ? Potocṍrijãña. Ateré yʉʉre píopeogo, ãñurõ tiigó tiiyo. ");
INSERT INTO tue_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bóaneõrã mʉ́ã watoapʉ niirucujããdacua. Yʉʉpeja mʉ́ãmena niirucuricu. ");
INSERT INTO tue_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Coo ateré yʉʉre píopeogo, yáa õpʉ̃ʉ̃rẽ coari tutipʉ cṹũãdari sʉguero, sitiaãñúremena píopeore tiiróbiro tiisʉguégo tiiyo. ");
INSERT INTO tue_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niipetiro atiditapʉ́re Cõãmacʉ̃ basocáre netõnére quetire wedewarucura, atigó yʉʉre tiiáriguere wedeadacua, coore wãcũdutira, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote Jesús buerá doce menamacʉ̃ paiaré dutirá pʉtopʉ wáarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Yʉʉ Jesuré mʉ́ãrẽ ticori, ¿nocõrõ niyeru yʉʉre wapatíadari? jĩĩyigʉ. Cʉ̃́ã treinta niyeruquiri ticoyira. ");
INSERT INTO tue_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cʉ̃́ã wapatíari siro, “¿deero tii yʉʉre Jesuré ticoro boomíĩto?” jĩĩ wãcũnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Basocá pã púuri tiirémena wʉ́oya maniré yaarí bosebʉreco niinʉcãwʉ̃. Ʉ̃sã Jesús buerá cʉ̃ʉ̃ pʉto wáa, sãĩñáwʉ̃: —¿Noopʉ́ marĩ Pascua bosebʉreco yaaadarore ʉ̃sã quẽnosʉguéri boogári? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cʉ̃ʉ̃ jĩĩwĩ: —Jerusalénpʉ wáaya. Toopʉ́ sĩcʉ̃ niiqui. Cʉ̃ʉ̃rẽ ateré jĩĩña: “Ʉ̃sãrẽ buegʉ́ ateré jĩĩcoawĩ: ‘Yʉʉ ñañarõ netõã́daro péerogã dʉsaa. Mʉʉya wiipʉ yʉʉ buerámena Pascua boseyagʉdacu’ ”, jĩĩña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃ dutiarirobirora Pascua boseyaadarere quẽnoyúerira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Náĩcũmuãri siro, Jesús, ʉ̃sã cʉ̃ʉ̃ buerá docemena yaaadara jeanuãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ʉ̃sã yaaduiri, jĩĩwĩ: —Yʉʉ ateré diamacʉ̃́rã jĩĩã: Mʉ́ã menamacʉ̃ sĩcʉ̃ yʉʉre ĩñatutirapʉre ticogʉdaqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ʉ̃sã bayiró wãcũpatiwʉ. —Ʉ̃sã Õpʉ̃, ¿yʉʉ mee niiĩ? jĩĩ sãĩñánʉcãwʉ̃ ʉ̃sãcõrõ. ");
INSERT INTO tue_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús ʉ̃sãrẽ jĩĩwĩ: —Yʉʉmena atibapapʉ́ pãmena soayágʉra yʉʉre ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yʉʉ niipetira sõwʉ̃rẽ Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaadacu. Bóaneõgʉ̃ niigʉ̃daqui yʉʉre ticogʉdʉpeja. Cʉ̃ʉ̃ bauáriatã, nemorṍ ãñubojĩyu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas cʉ̃ʉ̃rẽ ticogʉdʉ jĩĩwĩ: —Ʉ̃sãrẽ buegʉ́, ¿yʉʉ mee niiĩ? jĩĩwĩ. —Ʉ̃́jʉ̃, mʉʉrã́ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ʉ̃sã yaari, Jesús pãrẽ née, Cõãmacʉ̃rẽ ʉsenire ticowi. Túajea, pʉatásã, ʉ̃sãrẽ batowi. —Yaaya. Ate yáa õpʉ̃ʉ̃biro niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vino bapare née, Cõãmacʉ̃rẽ ʉsenire ticowi. Túajea, ʉ̃sãrẽ tĩ́ãgʉ̃rã, jĩĩwĩ: —Niipetira atibapá maquẽrẽ sĩniñá. ");
INSERT INTO tue_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ate yée díibiro niiã. Yʉʉ diari, yée díi õmayudiaadacu. Yée díimena paʉ basocá ñañaré tiiré wapa acabógʉdacu. Teeména Cõãmacʉ̃ mama netõnére quetire cṹũgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yʉʉ ateréja jĩĩã: Vino sĩninemóricu sáa; tée yʉʉ Pacʉ Õpʉ̃ niirṍpʉ mama vino ĩñaña manirére mʉ́ãmena sĩnigʉ̃́dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ʉ̃sã sicawãme Cõãmacʉ̃rẽ basarére basapeotoaari siro, Ʉ̃tãgʉ̃́ Olivopʉ wáajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Toopʉ́ wáagʉ, Jesús ʉ̃sãrẽ jĩĩwĩ: —Mʉ́ã niipetira atiñamí yʉʉre cõãwapetijõããdacu. Tee Cõãmacʉ̃ye queti jóaripũpʉ niiã: “Oveja coterí basocʉre sĩãcõã́gʉ̃dacu. Teero tiirí, cʉ̃ʉ̃yara oveja cʉ̃́ã booró cʉtʉbatéjõããdacua”, jĩĩ jóarigue niiã. ");
INSERT INTO tue_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Teero wáapacari, yʉʉ diarigʉpʉ masãri siro, yʉʉ mʉ́ã sʉguero Galileapʉ jeatoagʉdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro jĩĩwĩ: —Niipetira mʉʉrẽ cõãwari, yʉʉja mʉʉrẽ cõãwaricu, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mecʉ̃ã macã ñami cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ “cʉ̃ʉ̃rẽ masĩriga” jĩĩditogʉdacu mʉʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro jĩĩwĩ: —Yʉʉja cʉ̃́ã yʉʉre sĩãdʉgáatã, mʉʉmena diagʉda; mʉʉrẽ “masĩriga” jĩĩricu, jĩĩmiwĩ. Niipetira ʉ̃sã cʉ̃ʉ̃ buerá teero dícʉ jĩĩyucomiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Too síro Jesús, ʉ̃sã cʉ̃ʉ̃ buerámena Getsemanípʉ jeawʉ. Toopʉ́ jeagʉ, ʉ̃sãrẽ jĩĩwĩ: —Mʉ́ã ãno duiyueya ména. Yʉʉ jõõpʉ yʉʉ Pacʉre sãĩgʉ̃́ wáagʉ tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrore, teero biiri Zebedeo põna pʉarã́rẽ cʉ̃ʉ̃mena néewawi. Cʉ̃ʉ̃ bayiró yeeripũnapʉ wãcũpati, bóaneõnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉre diariquioro, wãcũpatire niinetõjõãga. Mʉ́ã ãno pʉtʉáya. Cãnirã́ mee tiiwá, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cʉ̃́ã beru yoasãñurõ wáa, yepapʉ munibiácũmuyigʉ. Cõãmacʉ̃rẽ sãĩyígʉ: —Pacʉ, mʉʉ boorí, yʉʉ ñañarõ netõã́dare wáarijããrõ. Yʉʉ teero jĩĩpacari, yʉʉ boorére tiiríjãña; mʉʉ boorépe wáari tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Too síro cʉ̃ʉ̃ buerá pʉtopʉ cãmepʉtʉ́aatiyigʉ. Cʉ̃́ãrẽ cãniã́rirapʉre bʉajeáyigʉ. Pedrore jĩĩyigʉ: —¿Deero tiigʉ́ yʉʉmena péerogã ĩña tiirídojãĩ? ");
INSERT INTO tue_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cãnirã́ mee tiiyá. Wãtĩ mʉ́ãrẽ jĩĩcõãsãrijããrõ jĩĩrã, Cõãmacʉ̃rẽ sãĩñá. Mʉ́ã wãcũrémena ãñurére tiidʉgápacari, mʉ́ãye õpʉ̃ʉ̃rĩpe sĩcãrĩbíria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Opatutí wáa, cʉ̃ʉ̃ Pacʉre sãĩnemóyigʉ: —Pacʉ, ñañarõ netõrére mʉʉ cãmotádʉgaheri, mʉʉ booróbirora wáaaro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sãĩã́ri siro, cʉ̃ʉ̃ buerá pʉtopʉ cãmepʉtʉ́aatigʉ, cãniã́rirapʉre bʉajeáyigʉ sũcã. Cʉ̃́ãrẽ wʉgoá pũnijõãyiro. ");
INSERT INTO tue_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Teero tiigʉ́, cʉ̃́ãrẽ wãcõrípacʉ, cʉ̃ʉ̃ Pacʉre sãĩgʉ̃́ wáayigʉ sũcã. Cʉ̃ʉ̃ sãĩã́rirobirora sãĩyígʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Too síro cãmepʉtʉ́aatigʉ, cʉ̃ʉ̃ bueráre jĩĩyigʉ: —¿Mʉ́ã cãnirã́ tiii sũcã? ¿Cãni, yeerisãjãrã tiii? Yʉʉre ticoadaro jearo tiia. Yʉʉ niipetira sõwʉ̃rẽ ticogʉdaqui ñañaré tiirápʉre. ");
INSERT INTO tue_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wʉ̃mʉnʉcãña. Jãmʉ, yʉʉre ticogʉdʉ atitoai mée, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ʉ̃sãmena wedesegʉ tiiríra, ʉ̃sã menamacʉ̃ niimiãrigʉ Judas jeawi. Cʉ̃ʉ̃mena paʉ basocá espadapĩrĩmena, yucʉména atiwa. Cʉ̃́ã paiaré dutirá, ãpẽrã́ bʉtoá dutirá ticocoarira niirira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","“Yʉʉ wasopúro ũpũgʉ̃́ cʉ̃ʉ̃rã́ niigʉ̃daqui; cʉ̃ʉ̃rẽ ñee, néewawa”, jĩĩsʉguetoarigʉ niiwĩ Jesuré ticogʉdʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Máata Jesús pʉtopʉ jeanʉcãgʉ̃: —Yʉʉre buegʉ́, jĩĩwĩ. Teero jĩĩgʉ̃rã, cʉ̃ʉ̃ wasopúrore ũpũwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Yʉʉ menamacʉ̃, mʉʉ tiigʉ́ atiariguere tiisírotiya, jĩĩwĩ. Basocá ati, Jesuré ñeejõãwã. ");
INSERT INTO tue_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Cʉ̃ʉ̃rẽ ñeerĩ, sĩcʉ̃ Jesuména niiãrigʉ cʉ̃ʉ̃ya espadare tʉ̃ãwé, paiaré dutigʉ́re padecotegʉya cãmopérore páatacojãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Tiiríjãña. Mʉʉyapĩrẽ quẽnocṹña. Espadamena cãmerĩ́quẽrãno espadamenarã diaadacua. ");
INSERT INTO tue_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mʉʉ masĩrii? Yʉʉ yʉʉ Pacʉre sãĩã́tã, máata doce põnarĩ ángeleare yʉʉre tiiápudutigʉ ticocoboqui. ");
INSERT INTO tue_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yʉʉ teero tiiátã, Cõãmacʉ̃ye queti jóaripũ jĩĩrõbirora wáaribocu; tee jĩĩrõbirora wáaro booa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Toorá Jesús basocáre jĩĩwĩ: —¿Yaarépigʉre tiiróbiro yʉʉre espadapĩrĩmena, yucʉména ñeerã atiarĩ? Bʉ́recoricõrõ yʉʉ Cõãmacʉ̃wiipʉ bueduiwʉ. Yʉʉre ñeeriwʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mecʉ̃tígã mʉ́ã tiiré niipetire profetas yʉʉre jóarirobirora wáaro tiia, jĩĩwĩ. Ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃ sĩcʉ̃rẽna cõãnʉcõ, dutipetíjõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesuré ñeerira cʉ̃ʉ̃rẽ paiaré dutigʉ́ Caifás pʉtopʉ néewayira. Toopʉ́ Moisés jóarigue buerá, teero biiri bʉtoá dutirá neãyira. ");
INSERT INTO tue_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrope yoasãñurõ Jesuré nʉnʉyígʉ, tée paiaré dutigʉ́ya wii popea macã yepa sããwaropʉ. Toopʉ́ péero sããwanemo, Cõãmacʉ̃wii coterí basoca pʉto jeanuãyigʉ, ¿deero wáamiãdarito? jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paiaré dutirá, niipetira Judíoare Dutirá Peti “¿deero tii jĩĩditoremena cʉ̃ʉ̃rẽ wedesãrõ boomíĩto?” jĩĩyira, sĩãdʉgára. ");
INSERT INTO tue_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Paʉ jĩĩditoremena wedesãrã jeapacari, ñañaré bʉaríyira. Yoari siro, pʉarã́ wedesãrã jeayira. ");
INSERT INTO tue_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Ãni jĩĩwĩ: “Yʉʉ Cõãmacʉ̃wiire cõãdiocomasĩã. Itiábʉreco siro túajeanʉcõmasĩã”, jĩĩwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Paiaré dutigʉ́ wʉ̃mʉnʉcã, Jesuré sãĩñáyigʉ: —¿Mʉʉ deero tiigʉ́ yʉʉridojãĩ? ¿Deero jĩĩ yʉʉgʉdari cʉ̃́ã wedesãrere? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesupé yʉʉriyigʉ. Paiaré dutigʉ́ jĩĩyigʉ sũcã: —Cõãmacʉ̃ catirucugʉ wãmemena mʉʉrẽ diamacʉ̃́ yʉʉri booa. Wedeya ʉ̃sãrẽ: ¿Mʉʉ Cõãmacʉ̃ macʉ̃ cʉ̃ʉ̃ beserigʉ Cristo niiĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉ jĩĩrõbirora cʉ̃ʉ̃rã́ niiã. Yʉʉ ateréja jĩĩã: Cõãmacʉ̃ tutuare cʉonetṍgʉ̃ pʉto cʉ̃ʉ̃ diamacʉ̃́pe duigʉdacu. Too síro yʉʉ niipetira sõwʉ̃ toopʉ́ duiri ĩñaãdacu mʉ́ã. Yʉʉ õmebʉrʉáripʉ diiátiricãrẽ ĩñaãdacu mʉ́ã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Paiaré dutigʉ́ teero jĩĩrĩ tʉogʉ́, cʉ̃ʉ̃ basiro cʉ̃ʉ̃yaro sutiroré wéeyigacojãyigʉ, ãpẽrãrẽ́ “bayiró cúai” jĩĩdutigʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Cʉ̃ʉ̃ teero wedesegʉ, Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiii. Ãpẽrã́ wedesãrĩ boonemória marĩ. Mʉ́ã cʉ̃ʉ̃ Cõãmacʉ̃rẽ ñañarõ wedeserere tʉotóaa. ");
INSERT INTO tue_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Deero tʉgueñaĩ mʉ́ã? jĩĩyigʉ. —Cʉ̃ʉ̃ teero jĩĩré wapa sĩãjã́rõ booa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Cʉ̃ʉ̃rẽ ʉsecó eobatétu, ñañarõ tii, doteyira. Ãpẽrã́ cʉ̃ʉ̃rẽ diapóapʉ páara, ");
INSERT INTO tue_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jĩĩyira: —Mʉʉ “Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩgʉ̃, jĩĩbʉaya. ¿Noã mʉʉrẽ páaarĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro tiiwií popea macã yepapʉ duiyigʉ. Sĩcõ paiaré dutigʉ́re padecotego cʉ̃ʉ̃ pʉto wáa, jĩĩyigo: —Mʉʉcã Jesús Galilea macʉ̃mena wáanetõãrigʉra niiãrã, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro niipetira tʉocóropʉ: —Cʉ̃ʉ̃rẽ masĩriga; ñeenórẽ wedesego wedesecu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Teero jĩĩtoa, sopepʉ́ witiwari, apegó cʉ̃ʉ̃rẽ ĩñayigo. Toopʉ́ ĩñanucũrãrẽ wedeyigo: —Ãni Jesús Nazaret macã macʉ̃mena wáarucuarigʉra niiĩ, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Niiria. Niirṍrã cʉ̃ʉ̃rẽ masĩriga, jĩĩjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Too sírogã toopʉ́ ĩñanucũrã Pedro pʉto wáa, cʉ̃ʉ̃rẽ jĩĩyira: —Niirṍrã mʉʉcã cʉ̃́ã menamacʉ̃ niicu. Mʉʉ too macãrã tiiróbiro wedesea, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Yʉʉ diamacʉ̃́ jĩĩhẽrĩ, Cõãmacʉ̃ yʉʉre ñañarõ tiiáro. Niirṍrã cʉ̃ʉ̃rẽ masĩriga, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩritabera, cãrẽquẽ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedro Jesús jĩĩãriguere wãcũbʉayigʉ: “Cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ ‘cʉ̃ʉ̃rẽ masĩriga’ jĩĩgʉ̃dacu mʉʉ”, jĩĩwĩ. Teeré wãcũbʉagʉ, witiwa, bayiró utiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bóeri niipetira paiaré dutirá, bʉtoá dutirá neãyira. “¿Deero tii marĩ Jesuré sĩãã́dari?” jĩĩ wedeseyira. ");
INSERT INTO tue_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Quẽnotóa, Jesuré siatú, néewa, Judea dita dutigʉ́pʉre ticoyira. Cʉ̃ʉ̃ Poncio Pilato wãmecʉtiwi. ");
INSERT INTO tue_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Too síro Judas Jesuré ticoarigʉ “cʉ̃ʉ̃rẽ sĩãã́dacua” jĩĩrére tʉoyígʉ. Teeré tʉogʉ́, bayiró wãcũpatiyigʉ. Teero tiigʉ́, niyeruquiri treintaquirire paiaré dutiráre, bʉtoá dutiráre wiyajã́miyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉ ñañarõ tiiátʉ. Basocʉ́ ãñugʉ̃́, ñañaré manigʉ̃́rẽ sĩãdutígʉ ticoatʉ, jĩĩyigʉ. —Mʉʉ teero tiiré ʉ̃sãye mee niiã. Mʉʉye maquẽ niicu, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, niyerure Cõãmacʉ̃wiipʉ cõãcũyigʉ. Too síro wáa, cʉ̃ʉ̃ basiro wãmʉãpʉ siatú, ñaañumu, diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Paiaré dutirá niyeruquirire née, jĩĩyira: —Ate niyeru basocʉ́re sĩãré wapa niiã. Teero tiirá, marĩ Cõãmacʉ̃wii niyeru cṹũritibapʉ cṹũmasĩricu. Marĩrẽ dutiré teero tiidutíria, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cʉ̃́ã “¿deero tiiádari ate niyerumena?” jĩĩ wedeseari siro, sotʉparʉ weeadara cʉ̃́ã dii cope niirí ditare sãĩdutíyira. “Toopʉ́ aperó macãrã diari, cʉ̃́ãrẽ yaaádaro niiãdacu”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Teero tiiró, atitóre tiidita “Díi Dita” wãmecʉtia. ");
INSERT INTO tue_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cʉ̃́ã teero tiirémena profeta Jeremías jóarigue diamacʉ̃́ wáaro tiiyíro. Ateré jóarigʉ niiwĩ: “Cʉ̃ʉ̃ treinta niyeruquiri wapacʉtíi”, jĩĩãdacua Israelya põna macãrã. ");
INSERT INTO tue_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Cʉ̃́ã tee niyerumena sotʉparʉ weeadara cʉ̃́ã dii cope niirí ditare sãĩã́dacua. Cõãmacʉ̃ yʉʉre wededutirirobirora tiiádacua, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Too síro Jesús Judea dita dutigʉ́ díamacʉ̃ nucũyigʉ. Tiidita dutigʉ́: —¿Mʉʉrã́ niiĩ judíoa õpʉ̃? jĩĩ sãĩñáyigʉ. —Mʉʉ jĩĩrõbirora cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Paiaré dutirá, teero biiri bʉtoá dutirá cʉ̃ʉ̃rẽ wedesãrĩ, yʉʉriyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato cʉ̃ʉ̃rẽ jĩĩyigʉ: —¿Mʉʉ cʉ̃́ã wedesãrere tʉoríi? ¿Deero tiigʉ́ yʉʉridojãĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús sicawãme wedesãrere yʉʉridojãyigʉ. Cʉ̃ʉ̃ yʉʉheri ĩñagʉ̃, tiidita dutigʉ́ ĩñamanijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cʉ̃marĩcṍrõ Pascua bosebʉrecori niirĩ, tiidita dutigʉ́ sĩcʉ̃ peresuwiipʉ niigʉ̃́rẽ basocá cʉ̃́ã wionécodʉgagʉre wionécorucuwi. ");
INSERT INTO tue_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Teebʉrecorire sĩcʉ̃ peresuwiipʉ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiwi Barrabás. Niipetira cʉ̃ʉ̃ ñañaré tiiríguere masĩjĩya. ");
INSERT INTO tue_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Teero tiigʉ́, Pilato basocá paʉ cʉ̃ʉ̃ pʉtopʉ neãrĩ ĩñagʉ̃, cʉ̃́ãrẽ sãĩñáyigʉ: —¿Niirẽ́ yʉʉ wionécori boogári, Barrabáre o Jesús cʉ̃́ã “Cõãmacʉ̃ beserigʉ Cristo” jĩĩgʉ̃́pere? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesuré ĩñatutira ticoariguere Pilato masĩjãjĩyi. ");
INSERT INTO tue_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apeyé, cʉ̃ʉ̃ queti beserí basocʉ duirópʉ duiri, cʉ̃ʉ̃ nʉmo cʉ̃ʉ̃rẽ queti ticocoyigo. “Mʉʉ besegʉdʉre ñañarõ tiiríjãña. Ãñugʉ̃́ niiqui. Ñami cʉ̃ʉ̃ye maquẽrẽ bayiró quioró quẽẽãtʉ”, jĩĩcomiyigo. ");
INSERT INTO tue_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Paiaré dutirá, teero biiri bʉtoá dutirá basocáre sãĩdutíyira: “Barrabápere wionécodutiya; Jesupére sĩãdutíya”, jĩĩdutiyira. ");
INSERT INTO tue_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Too síro Pilato basocáre sãĩñánemoyigʉ: —Cʉ̃́ã pʉarã́rẽ ¿niipére wionécori boogári? jĩĩyigʉ. —¡Barrabáre! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato cʉ̃́ãrẽ jĩĩyigʉ: —Too docare Jesús cʉ̃́ã “Cõãmacʉ̃ beserigʉ Cristo” jĩĩgʉ̃́pere ¿deero tiirí boogári? jĩĩyigʉ. —¡Curusapʉ páabiatudutiya! jĩĩyira niipetira. ");
INSERT INTO tue_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Ñeenó ñañaré tiiárĩ cʉ̃ʉ̃? jĩĩyigʉ. Basocápe bayiró bʉsʉrómena: —¡Curusapʉ páabiatudutiya! jĩĩnemoyira. ");
INSERT INTO tue_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Basocá Pilato wedeserere tʉodʉgáriyira. Teero biiri noo booró acaribíãmajãyira. Pilato teeré ĩñagʉ̃, oco néeatidutiyigʉ. Basocá ĩñacoropʉ wãmocose, jĩĩyigʉ: —Ãni basocʉ́re sĩãrĩ́, yʉʉ tiiré mee niiã. Cʉ̃ʉ̃ diari, mʉ́ãye wapa niiãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cʉ̃́ã niipetira yʉʉyira: —Cʉ̃ʉ̃ diare wapa ʉ̃sã põnamena wapa cʉoáda, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Too síro Barrabáre wionécobosayigʉ. Jesuré tãnadutítoaari siro, curusapʉ páabiatu sĩãdutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Too síro Pilatoyara surara cʉ̃́ãye wiseri popea macã yepapʉ Jesuré néewayira. Toopʉ́ ãpẽrã́ niipetira surarare néõyira cʉ̃ʉ̃ pʉtopʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Cʉ̃ʉ̃yaro sutiroré tuuwé, aperó õpʉ̃ya sutiro tiiróbiro bayiró sõãrṍrẽ sã́ãyira. ");
INSERT INTO tue_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sicabeto potamena tiiári beto cʉ̃ʉ̃ya dupupʉre péoyira. Sicagʉ́ tuurítuarigʉ õpʉ̃yagʉnorẽ cʉ̃ʉ̃ diamacʉ̃́ wãmomena ñeedutiyira. Teero tiitóa, cʉ̃ʉ̃ pʉtopʉ ñicãcoberimena jeacũmu, cʉ̃ʉ̃rẽ buijã́yira. —Ʉseniã mʉʉmena, judíoa õpʉ̃, jĩĩ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cʉ̃ʉ̃rẽ ʉsecó eobatétuyira. Tuurítuarigʉre cʉ̃ʉ̃rẽ tʉ̃ãwécojã, dupupʉ pee páayira. ");
INSERT INTO tue_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Buitóa, cʉ̃́ã cʉ̃ʉ̃rẽ sã́ããrirore tuuwécojã, cʉ̃ʉ̃ sãñasʉguearirore sã́ãyira. Curusapʉ páabiatura wáara néewawa. ");
INSERT INTO tue_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesuré páabiatura wáara néewari, sĩcʉ̃ basocʉ́ Cirene macã macʉ̃rẽ bʉajeárira niiwã. Cʉ̃ʉ̃ Simón wãmecʉtiwi. Cʉ̃ʉ̃rẽ Jesús apawari curusare apadutirira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cʉ̃́ã jeawa Gólgota buropʉ. Gólgota jĩĩrõ, “Dupucoro” jĩĩrõ tiia. ");
INSERT INTO tue_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Toopʉ́ vino sʉ̃guẽrémena wʉ́oarigue tĩ́ãmiwã. Cʉ̃ʉ̃pe teeré sĩniñámi, sĩnidújãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cʉ̃ʉ̃rẽ curusapʉ páabiatuari siro, surara cʉ̃ʉ̃ye suti niimiãriguere batoadara, jĩĩbʉaapewa. Cʉ̃́ã teero tiirémena profeta jóarigue diamacʉ̃́ wáaro tiiyíro. Ateré jóarigʉ niiwĩ: Yée sutire cʉ̃́ã basiro jĩĩbʉaape batowa, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Too síro surara cʉ̃ʉ̃rẽ cotera jeanuãwã. ");
INSERT INTO tue_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesuyá dupu sotoapʉ basocá cʉ̃ʉ̃rẽ wedesããriguere jóatunoriro niiwʉ̃ táboapĩpʉre. “ÃNI JESÚS JUDÍOA ÕPɄ̃ NIIĨ”, jĩĩ jóanoriro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesuména pʉarã́ yaarépirare páabiatuwa; sĩcʉ̃ diamacʉ̃́pe, ãpĩ acuniñape nʉcõwã́. ");
INSERT INTO tue_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Basocá toopʉ́ netõwára, cʉ̃ʉ̃rẽ ñañarõ jĩĩrã, dupupá saguejṍãrucuwa. ");
INSERT INTO tue_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Cʉ̃ʉ̃rẽ jĩĩwã: —Jʉ̃́ʉ̃. Mʉʉ “Cõãmacʉ̃wiire cõãgʉ̃da” jĩĩmiwʉ̃rã. “Itiábʉreco siro apewií tiipetícojãgʉ̃da”, jĩĩmiwʉ̃rã mʉʉ. Teero jĩĩrigʉ mʉʉ basirora netõnéña. Mʉʉ Cõãmacʉ̃ macʉ̃ niigʉ̃, curusapʉ tusagʉ́ diiátiya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Paiaré dutirácã, Moisés jóarigue buerá, teero biiri bʉtoá dutirámena teerora jĩĩ buijã́wã: ");
INSERT INTO tue_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Cʉ̃ʉ̃ ãpẽrãcã́rẽ netõnéwĩ; cʉ̃ʉ̃ basirope netõnémasĩrii. “Israelya põna macãrã õpʉ̃ niiã”, jĩĩwĩ. Too docare curusapʉ tusagʉ́ cʉ̃ʉ̃ basiro diiátiaro. Cʉ̃ʉ̃ basiro diiátiri docare, padeoáda. ");
INSERT INTO tue_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cʉ̃ʉ̃ “Cõãmacʉ̃rẽ padeóa” jĩĩwĩ. “Cõãmacʉ̃ macʉ̃ niiã” jĩĩwĩ. Cõãmacʉ̃ cʉ̃ʉ̃rẽ maĩgʉ̃́, cʉ̃ʉ̃rẽ netõnéãrõ, jĩĩ buijã́wã. ");
INSERT INTO tue_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yaarépira cʉ̃ʉ̃mena curusapʉ páabianʉcõãriracã teerora cʉ̃ʉ̃rẽ ñañarõ jĩĩ buijã́wã. ");
INSERT INTO tue_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Coeritó niirĩ, niipetiro tiiditapʉ naĩtĩãjõãwʉ̃. Tée ñamica tres niirĩpʉ naĩtĩãtuwʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tii hora niirĩrã, Jesús bayiró acaribíwi: —Elí, Elí, ¿lama sabactani? jĩĩwĩ cʉ̃ʉ̃yemena. Teero jĩĩgʉ̃, “Cõãmacʉ̃, Cõãmacʉ̃, ¿deero tiigʉ́ yʉʉre cõãwai?” jĩĩgʉ̃ tiiwí. ");
INSERT INTO tue_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ãpẽrã́ sĩquẽrã toopʉ́ niirã́ teeré tʉorá, jĩĩwã: —Ĩ́ni profeta Elíare sʉocógʉ tiiquí, jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Máata sĩcʉ̃ cʉtʉwá, sicasitia née, vino piyare soanéwĩ. Sĩniã́rõ jĩĩgʉ̃, sicagʉ́ cãnʉgʉ̃pʉ siatú, cʉ̃ʉ̃rẽ súumʉõcowi. ");
INSERT INTO tue_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Cʉ̃ʉ̃ teero tiirí, ãpẽrã́ jĩĩwã: —Coteya ména. Elías cʉ̃ʉ̃rẽ netõnégʉ̃ atiboqui, jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús bayiró acaribínemo, diajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cʉ̃ʉ̃ diari, Cõãmacʉ̃wii popeapʉ Ãñunetõjõãri Tatia cãmotáyosari casero ʉ̃mʉã́rõpe yigadiati, pʉacaséropʉ jeacotuariro niiwʉ̃. Dita bayiró cãmeña, ʉ̃tãpá watijṍãriro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ʉ̃tãtutiri diarirare cṹũre tutiri tusujõãriro niiwʉ̃. Teero wáari, diarira Cõãmacʉ̃rẽ padeoríra masãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús cʉ̃ʉ̃ masãmʉããri siro, ʉ̃tãtutiripʉ niimiãrira witiwa, Jerusalénpʉ sããatiwa. Cʉ̃́ãrẽ paʉ ĩñawã. ");
INSERT INTO tue_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cien surara dutigʉ́, cʉ̃ʉ̃ suraramena Jesuré coterá dita cãmeñarĩ ĩñarã, apeyenó wáari ĩñarã, bayiró cuira, jĩĩyira: —Diamacʉ̃́rã ãni Cõãmacʉ̃ macʉ̃ niimiãyi, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Paʉ numiã́cã toopʉ́ niiwã. Cʉ̃́ã Jesuré tiiápurira niiwã. Cʉ̃ʉ̃ Galileapʉ atiri, cʉ̃ʉ̃rẽ nʉnʉátiwa. Yoaropʉ Jesuré ĩñanucũwã. ");
INSERT INTO tue_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cʉ̃́ãmena niiwã: María Magdalena; María (coo Santiago, José paco niiwõ); Zebedeo nʉmo niiwã. ");
INSERT INTO tue_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Náĩcũmurĩ, sĩcʉ̃ pee apeyé cʉogʉ́ Arimatea macã macʉ̃ jeayigʉ. Cʉ̃ʉ̃ wãmecʉtiwi José. Cʉ̃ʉ̃cã Jesuré padeogʉ́ra niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Cʉ̃ʉ̃ Pilato pʉtopʉ sããwa, Jesuyá õpʉ̃ʉ̃rẽ sãĩyígʉ. Pilato surarare “ticoya” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Too síro José Jesuyá õpʉ̃ʉ̃rẽ néedioco, sutiró ãñurí casero, jũĩrĩ́ manirí caseromena cõmayígʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Túajea, cʉ̃ʉ̃ya tuti mama tuti ʉ̃tãgãpʉ coari tutipʉ cṹũyigʉ. Tiituti José coadutíri tuti niiwʉ̃. Tiitutire ʉ̃tãqui pairíquicamena tuunéwa, biajã́, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena, apegó María tiituti díamacʉ̃pʉ ĩñaduiyira. ");
INSERT INTO tue_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Apebʉ́reco ʉ̃sã yeerisãri bʉreco niirĩ, paiaré dutirá, teero biiri fariseo basoca Pilato pʉtopʉ neãyira. ");
INSERT INTO tue_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cʉ̃ʉ̃rẽ jĩĩyira: —Ʉ̃sãrẽ dutigʉ́, ʉ̃sã jõõ niiãrigʉ jĩĩditorepigʉ catigʉpʉ jĩĩriguere wãcũã. “Yʉʉ itiábʉreco diari siro, masãgʉ̃da”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Teero tiigʉ́, surarare cʉ̃ʉ̃rẽ cṹũri tutipʉ ticocoya, ãñurõ bia, cotearo jĩĩgʉ̃. Itiábʉrecore ãñurõ cotedutiya. Teero tiihéri, cʉ̃ʉ̃ buerá cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ yaajã́bocua. Yaaári siro, basocáre “diaarigʉpʉ niipacʉ, masãjõããrigʉ niiãwĩ” jĩĩbocua. Cʉ̃́ã teero jĩĩãtã, too sʉguero jĩĩditore nemorṍ ñañaãdacu, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato cʉ̃́ãrẽ jĩĩyigʉ: —Surarare néewaya. Tiitutipʉ merẽã wáari jĩĩrã, mʉ́ã põõtẽ́õrõ ãñurõ bia, cotedutiya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Teero tiirá, ʉ̃tãqui biaríqui sotoa sicadaména wéediyoturira niiwã, cʉ̃́ã sããwari, ĩñamasĩãda jĩĩrã. Ãñurõ biaári siro, surarare cotedutira cṹũyira. ");
INSERT INTO tue_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ʉ̃sã yeerisãri bʉreco sábado netõã́ri siro, apebʉ́reco bóeri María Magdalena, apegó Maríamena tiitutire ĩñarã wáayira. ");
INSERT INTO tue_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wãcũña manirṍ dita bayiró cãmeñayiro. Ángele ʉ̃mʉã́sepʉ niiãrigʉ diiátiyigʉ. Tiitutire wáa, cʉ̃́ã biamíriquicare aperopʉ́ tuunécowayigʉ. Too síro tiiquica sotoapʉ jeanuãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Cʉ̃ʉ̃ bʉpo wã́ãyoro tiiróbiro asiyáyigʉ. Cʉ̃ʉ̃ye suti bayiró butiré capemóre niiyiro. ");
INSERT INTO tue_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Surara cʉ̃ʉ̃rẽ cui, ñapõpi, diara tiiróbiro ñaacũmuyira. ");
INSERT INTO tue_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ángele numiã́rẽ jĩĩyigʉ: —Cuirijãña. Yʉʉ masĩã: Mʉ́ã Jesuré cʉ̃́ã curusapʉ páabiatu sĩãã́rigʉre ãmaãrã tiia. ");
INSERT INTO tue_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ãnorẽ́ maniĩ. Cʉ̃ʉ̃ jĩĩrirobirora masãtoaawĩ. Jãmʉ, cʉ̃ʉ̃rẽ cṹũãrirore ĩñarã atiya. ");
INSERT INTO tue_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ĩñatoa, boyeromena cʉ̃ʉ̃ buerá niiãrirare queti wedera wáaya: “Diarigʉpʉ niipacʉ, masãjõããrigʉ niiãwĩ. Cʉ̃ʉ̃ mʉ́ã sʉguero Galileapʉ jeatoagʉdaqui. Toopʉ́ cʉ̃ʉ̃rẽ ĩñaãdacu”, jĩĩ wedeya. Teeré yʉʉ mʉ́ãrẽ wedegʉ atiawʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, tiitutipʉ niiãrira boyeromena wáajõãyira. Cuipacara, ʉseniremena cʉtʉwáyira, Jesús buerá niiãrirare wedera wáara. ");
INSERT INTO tue_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wãcũña manirṍ Jesús cʉ̃́ãrẽ bauá, ãñudutiyigʉ. Cʉ̃́ã cʉ̃ʉ̃ pʉto wáa, cʉ̃ʉ̃ye dʉporire ñaapeó, padeoyíra. ");
INSERT INTO tue_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Cuirijãña. Yʉʉ bueráre Galileapʉ wáadutira wáaya. Toopʉ́ yʉʉre ĩñaãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Numiã́ wáaritabe, sĩquẽrã surara tiitutire cotemiãrira macãpʉ jeayira. Paiaré dutiráre niipetire toopʉ́ wáaariguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Teero tiirá, paiaré dutirá, bʉtoá dutirámena neãyira. Cʉ̃́ã “¿deero tiiró booi?” jĩĩ wedeseyira. Wedeseari siro, surarare pairó niyeru tico, ");
INSERT INTO tue_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","jĩĩyira: —Ateré basocáre jĩĩña: “Ñami ʉ̃sã cãninetṍritabe, Jesús buerá jeaarira niiãwã. Cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ yaajã́ãrira niiãwã”, jĩĩña. ");
INSERT INTO tue_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilato mʉ́ã wedeariguere tʉorí, ʉ̃sã “diamacʉ̃́rã teero wáaariro niiãwʉ̃” jĩĩapuada. Ʉ̃sã teero jĩĩrĩ, mʉ́ãrẽ ñañarõ wáaricu, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Surara niyeru ñee, cʉ̃́ãrẽ wededutirirobirora wederira niiwã. Judíoa atitópʉcãrẽ surara jĩĩditoriguere wedeserucujãya. ");
INSERT INTO tue_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Too síro ʉ̃sã Jesús buerá once Galileapʉ wáawʉ. Ʉ̃tãgʉ̃pʉ́ Jesús ʉ̃sãrẽ wáadutirigʉpʉ wáawʉ. ");
INSERT INTO tue_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cʉ̃ʉ̃rẽ ĩña, padeowʉ́. Ãpẽrãpé “¿cʉ̃ʉ̃rã́ niiĩye?” jĩĩ wãcũwã. ");
INSERT INTO tue_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ʉ̃sã pʉtopʉ ati, jĩĩwĩ: —Cõãmacʉ̃ yʉʉre õpʉ̃ sõnecotoaawĩ. Niipetiro ʉ̃mʉã́se, atiditaré dutimasĩã. ");
INSERT INTO tue_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Teero tiirá, niipetiropʉ macãrãrẽ yée quetire wedera wáaya. Cʉ̃́ãrẽ mʉ́ã tiiróbiro yʉʉ buerá niirĩ tiiyá. Cʉ̃́ãrẽ wãmeõtira, yʉʉ Pacʉ, yʉʉ, Espíritu Santo wãmemena wãmeõtiya. ");
INSERT INTO tue_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Niipetire yʉʉ mʉ́ãrẽ dutiriguere cʉ̃́ãrẽ bueya, yʉʉaro jĩĩrã. Niipetire bʉrecori mʉ́ãmena niirucujãgʉ̃dacu. Tée atibʉ́reco petirípʉcãrẽ mʉ́ãmena niirucujãgʉ̃dacu, jĩĩ wedewi Jesús.");
INSERT INTO tue_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Cõãmacʉ̃ macʉ̃ye queti niinʉcãrigue. ");
INSERT INTO tue_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profeta Isaías ateré jóarigʉ niiwĩ: Yʉʉre wedesʉguegʉre mʉʉ sʉguero ticocogʉda. Cʉ̃ʉ̃ mʉʉ wáaadarimarẽ quẽnoyúegʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sĩcʉ̃ yucʉ manirṍ, basocá manirṍpʉ bayiró bʉsʉrómena wedegʉdaqui: “Sĩcʉ̃ õpʉ̃ atiadarimarẽ quẽnarõ tiiróbiro, marĩ Õpʉ̃ atiadari sʉguero, mʉ́ã ñañaré tiirére duujã́, ãñurõ niiyueya”, jĩĩgʉ̃daqui, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Teero tiigʉ́, Juan basocá manirṍpʉ niiyigʉ. Basocáre ocoména dícʉ wãmeõtinetõyigʉ. Cʉ̃ʉ̃ cʉ̃́ãrẽ wedeyigʉ: —Mʉ́ã ñañaré tiirére wãcũpati, waso, wãmeõtidutiya. Teero tiirí, Cõãmacʉ̃ mʉ́ã ñañaré tiirére acabógʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Paʉ Judea dita macãrã, ãpẽrã́ Jerusalén macãrã cʉ̃ʉ̃ wederére tʉorá wáayira. Cʉ̃́ã ñañaré tiirére wedenetõãri siro, día Jordánpʉ cʉ̃́ãrẽ wãmeõtiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Cʉ̃ʉ̃yaro sutiró camello póarimena tiiríro niiyiro; cʉ̃ʉ̃ siatúrida wáicʉ caseroda niiyiro. Cʉ̃ʉ̃ yeseroare, macãnʉcʉ̃ macãrã mumiãocore yaarucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan basocáre wedeyigʉ: —Yʉʉ siro ãpĩ yʉʉ nemorṍ tutuagʉ atigʉdaqui. Cʉ̃ʉ̃ ãñunetõgʉ̃ niiqui. Yʉʉpeja cʉ̃ʉ̃rẽ sĩcãrĩbíridojãcu. ");
INSERT INTO tue_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yʉʉ mʉ́ãrẽ ocoména wãmeõtia. Cʉ̃ʉ̃peja nemorṍ ãñurõ tiigʉ́daqui mʉ́ãrẽ: Espíritu Santore ticodiocogʉdaqui, mʉ́ãmena niirucujããrõ jĩĩgʉ̃, jĩĩyigʉ Juan. ");
INSERT INTO tue_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Teebʉrecorira Jesús Nazaretpʉ niiyigʉ. Tiimacã Galilea ditapʉ niiã. Too niiãrigʉ wáa, jeayigʉ Juan pʉtopʉ. Juan cʉ̃ʉ̃rẽ día Jordánpʉ wãmeõtiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús tiimaapʉ́ niiãrigʉ maajeánʉcãgʉ̃, máata ʉ̃mʉã́se pã́õrĩ ĩñayigʉ. Espíritu Santo sĩcʉ̃ bua tiiróbiro baugʉ́ cʉ̃ʉ̃pʉre diijeáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Teero wáari, ʉ̃mʉã́sepʉ wedeseri tʉoyíra: —Mʉʉ yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́ niiã. Mʉʉmena bayiró ʉseniã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Máata Espíritu Santo basocá manirṍpʉ Jesuré wáadutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Toopʉ́re cuarenta bʉrecori wáicʉra cúara watoapʉ niiyigʉ. Wãtĩãrẽ dutigʉ́ Satanás wãmecʉtigʉ cʉ̃ʉ̃rẽ jĩĩcõãsãmiyigʉ, ¿niirṍrã Cõãmacʉ̃rẽ netõnʉcã́rii? jĩĩgʉ̃. Ángelea Jesuré tiiápuyira. ");
INSERT INTO tue_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanrẽ́ peresu sõnecoari siro, Jesús Galileapʉ wáayigʉ. Cõãmacʉ̃ basocáre netõnére quetire wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare jeaadaropʉ tiia. Teero tiirá, mʉ́ã ñañaré tiirére wãcũpati, wasoyá. Teero biiri Cõãmacʉ̃ basocáre netõnére quetire padeoyá”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galileataro wesapʉ wáayigʉ. Toopʉ́ wáagʉ, Simónrẽ, cʉ̃ʉ̃ bai Andrére ĩñayigʉ. Wai wasarí basoca niijĩrã, bapigʉ cõãño, wai wasara tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús jĩĩyigʉ cʉ̃́ãrẽ: —Jãmʉ yʉʉmena. Mʉ́ã mecʉ̃tígãrẽ wai wasarí basoca niiã; too síropʉre mʉ́ã basocáre yée quetire ãñurõ wederí basoca wáaadacu sáa. Teeré wederi, paʉ padeoádacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Teeré tʉorá, máata cʉ̃́ãye bapiyucʉre toorá cṹũjã, Jesuména wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Too péero wáa, Zebedeo põna Santiago, cʉ̃ʉ̃ bai Juanrẽ́ ĩñayigʉ. Cʉ̃́ã dooríwʉpʉ bapiyucʉre jeesãñáyira. ");
INSERT INTO tue_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús máata cʉ̃́ãcãrẽ “jãmʉ” jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, cʉ̃́ãyawʉ dooríwʉpʉ niirã́rẽ, cʉ̃́ã pacʉ Zebedeore, cʉ̃ʉ̃rẽ padecoterare cṹũjã, wáajõãyira Jesuména. ");
INSERT INTO tue_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum macãpʉ jeayira. Judíoa yeerisãri bʉreco niirĩ, Jesús cʉ̃́ã neãrí wiipʉ sããwa, tiiwiipʉ́ niirã́rẽ buenʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Cʉ̃ʉ̃ buerére tʉorá, tʉomaníjõãyira. Dutiré cʉogʉ́ tiiróbiro bueyigʉ. Moisés jóarigue buerá tiiróbiro bueriyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tiiwií cʉ̃́ã neãrí wiipʉ sĩcʉ̃ basocʉ́ niiyigʉ. Wãtĩ cʉ̃ʉ̃pʉre niiyigʉ. Cʉ̃ʉ̃ acaribíyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉʉ Jesús Nazaret macʉ̃, ʉ̃sãrẽ potocṍrijãña. Ʉ̃sãrẽ ñañarõ tiidíogʉ atigʉ tiia. Yʉʉ mʉʉrẽ ĩñamasĩã. Cõãmacʉ̃ ticodiocorigʉ, ñañaré manigʉ̃́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","—Ditamaníjõãña; cʉ̃ʉ̃pʉre niigʉ̃́, witiwaya, jĩĩ tutiyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wãtĩ cʉ̃ʉ̃pʉre niigʉ̃́ cʉ̃ʉ̃rẽ ñaacũmu, ñapõpiri tiiyígʉ. Bayiró acaribí, witiwayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Niipetira ĩñamanijõãyira. Cʉ̃́ã basiro cãmerĩ́ sãĩñá tiiyíra: —¿Ñeenó niimiĩto ate mama bueré? Ãni basocʉ́ wãtĩã cõãmasĩrere cʉojã́ĩ. Wãtĩã cʉ̃ʉ̃ “witiwaya” jĩĩrĩ, witijõãya, jĩĩyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Máata Jesuyé queti Galileapʉre sesajõãyiro. ");
INSERT INTO tue_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Máata Jesús cʉ̃́ã neãrí wii niiãrigʉ witi, Simón, Andrécãya wiipʉ wáayigʉ. Santiago, Juan cʉ̃ʉ̃mena wáayira. ");
INSERT INTO tue_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Toopʉ́ Simón mañecõ wiorécʉtigo pesayigo. Máata teeré wedeyira Jesuré. ");
INSERT INTO tue_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús coo pʉtopʉ sããwayigʉ. Coore wãmopʉ ñee, wéemʉõdʉpocoyigʉ. Cʉ̃ʉ̃ teero tiiríra, wioré tatijṍãyiro. Coo cʉ̃́ãrẽ yaaré ecayígo. ");
INSERT INTO tue_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Muĩpũ sããwaari siro, niipetira diarecʉtirare Jesús pʉtopʉ néewayira. Wãtĩã sããnoriracãrẽ néewayira. ");
INSERT INTO tue_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Niipetira tiimacã macãrã Jesús niirí wii sopepʉtó neãyira. ");
INSERT INTO tue_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Niipetira noo niiré diaré cʉoráre netõnépetijãyigʉ. Paʉ wãtĩãrẽ cõãwionecoyigʉ. Cʉ̃́ãrẽ wedesedutiriyigʉ. Cʉ̃́ã Jesús Cõãmacʉ̃ macʉ̃ niirére masĩyira. ");
INSERT INTO tue_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Apebʉ́reco bóeadari sʉguero, Jesús wãcã, macã wesapʉ, basocá manirṍpʉ Cõãmacʉ̃mena wedesegʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón, cʉ̃ʉ̃ menamacãrãmena Jesuré ãmaãrã wáayira. ");
INSERT INTO tue_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cʉ̃ʉ̃rẽ bʉa: —Niipetira mʉʉrẽ ãmaãrã tiiáwã, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cʉ̃ʉ̃pe: —Jãmʉ pʉtogã niiré macãrĩpʉ, jĩĩyigʉ—. Toopʉ́cãrẽ yée quetire wedegʉ wáagʉda. Ateré tiigʉ́ra yʉʉ atiditapʉ́ atirigʉ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Niipetiro Galileapʉre judíoa neãré wiseripʉ wedewarucugʉ wáayigʉ. Wãtĩãrẽ cõãwionecoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sĩcʉ̃ basocʉ́ õpʉ̃ʉ̃ bóagʉ cʉ̃ʉ̃ pʉto wáa, ñicãcoberimena jeacũmuyigʉ: —Mʉʉ yʉʉ diarecʉtirere netõnédʉgagʉ, netõnémasĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús cʉ̃ʉ̃rẽ bóaneõgʉ̃, cʉ̃ʉ̃rẽ ñaapeó, jĩĩyigʉ: —Netõnédʉgaga. Diaremanigʉ̃ pʉtʉáya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Máata cʉ̃ʉ̃ya õpʉ̃ʉ̃ bóare yatijõãyiro. Diaremanigʉ̃ pʉtʉáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús cʉ̃ʉ̃rẽ máata ticocogʉ, dutiyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ateré ãpẽrãrẽ́ wedegʉ mee tiiwá, jĩĩmiyigʉ—. Pairé ẽñogʉ̃́ wáaya, “ãñujõããyi” jĩĩdutigʉ. Moisés dutirirobirora tiiwá, basocá niipetira mʉʉ diaré netõã́riguere masĩãrõ jĩĩgʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cʉ̃ʉ̃pe wáa, cʉ̃ʉ̃rẽ wáaariguere wedenʉcã, niipetiropʉ wedepetijãyigʉ. Teero tiigʉ́, Jesús macãrĩpʉ́re basocá ĩñacoropʉre wáariyigʉ. Teemacãrĩ wesapʉ, basocá manirṍpʉ wáayigʉ. Cʉ̃ʉ̃ teero tiipacári, niipetiro macãrãpʉ wáa, cʉ̃ʉ̃rẽ ĩñanetõyira. ");
INSERT INTO tue_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pee bʉrecori wáaripacari, Jesús Capernaumpʉ coepʉtʉ́ayigʉ. Tiimacã macãrã “cʉ̃ʉ̃ niirí wiipʉ niiĩ” jĩĩré quetire tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Basocá paʉ toopʉ́ neãyira. Tiiwiiré dadajõãyira, sopepʉtócãrẽ teerora. Sããwamasĩña maniyíro. Cʉ̃́ãrẽ bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Cʉ̃ʉ̃ pʉtopʉ sĩcʉ̃ wáamasĩhẽgʉ̃rẽ néejeayira. Bapari ʉ̃mʉã cʉ̃ʉ̃rẽ ñoonéyira. ");
INSERT INTO tue_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cʉ̃́ã basocá paʉ niirĩ, Jesús pʉtogãpʉ jeamasĩriyira. Teero tiirá, wii sotoápʉ mʉãwa, Jesús niirṍ sotoapʉ sicacope néeweyira. Tiicopepʉ wáamasĩhẽgʉ̃rẽ cʉ̃ʉ̃ cõãrṍmena diocóyira. ");
INSERT INTO tue_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús cʉ̃́ã padeorí ĩñagʉ̃, wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: —Yáa wedegʉ, mʉʉ ñañaré tiirére acabónotoaa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Toopʉ́ duirá Moisés jóarigue buerá wãcũyira: ");
INSERT INTO tue_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ãni deero tiigʉ́ biiro wedesei? Teero jĩĩgʉ̃, Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiii. Cõãmacʉ̃ sĩcʉ̃rã ñañaré tiirére acabómasĩĩ”, jĩĩ wãcũyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Máata Jesupé cʉ̃́ã wãcũrére masĩjãyigʉ. —¿Deero tiirá mʉ́ã teero wãcũĩ? ");
INSERT INTO tue_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ãnirẽ́ “mʉʉ ñañaré tiirére acabónotoaa” yʉʉ jĩĩrĩ, tee cʉ̃ʉ̃rẽ acabónoãriguere ĩñaricu mʉ́ãjã. Yʉʉ ãni wáamasĩhẽgʉ̃rẽ “wʉ̃mʉnʉcã, mʉʉ cõãrṍrẽ néeapa wáaya” jĩĩrĩpereja, cʉ̃ʉ̃ wʉ̃mʉnʉcãrĩ ĩñaã mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉʉ niipetira sõwʉ̃ niiã. Teero tiigʉ́, atiditapʉ́re basocá cʉ̃́ã ñañaré tiirére acabómasĩã. Yʉʉ dutirére mʉ́ãrẽ ẽñogʉ̃́da, jĩĩyigʉ cʉ̃ʉ̃peja. Wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Yʉʉ mʉʉrẽ “wʉ̃mʉnʉcãña” jĩĩã. Mʉʉ cõãrṍrẽ néeapa, mʉʉya wiipʉ pʉtʉawaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wáamasĩhẽgʉ̃ niimiãrigʉ wʉ̃mʉnʉcã, máata cʉ̃ʉ̃ cõãrṍrẽ néeapa, niipetira ĩñacoro wáajõãyigʉ. Teero tiirá, niipetira ĩñamanijõãyira. Cõãmacʉ̃rẽ ʉsenire tico, “biiro tiirére marĩ ĩñahẽrã niiãwʉ̃” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Galileataro wesapʉ wáayigʉ sũcã. Niipetira basocá cʉ̃ʉ̃ pʉtopʉ neããri siro, cʉ̃́ãrẽ bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Too netõwágʉ, Alfeo macʉ̃rẽ ĩñabʉayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Leví. Cʉ̃ʉ̃ romanuã õpʉ̃rẽ niyeru wapasébosari basocʉ niiyigʉ. Jesús cʉ̃ʉ̃ paderópʉ duiri ĩña: —Jãmʉ yʉʉmena, jĩĩyigʉ. Leví wʉ̃mʉnʉcã, cʉ̃ʉ̃mena wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Too síro Jesús Leviyá wiipʉ yaaduiyigʉ cʉ̃ʉ̃ buerámena. Paʉ niyeru wapasébosari basoca, ãpẽrã́ ñañaré tiirá cʉ̃́ãmena yaaduiyira. Paʉ peti cʉ̃́ãno Jesuré nʉnʉyíra. ");
INSERT INTO tue_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisés jóarigue buerá fariseo basoca niirã́ Jesús cʉ̃́ãmena yaari ĩñarã, cʉ̃ʉ̃ bueráre sãĩñáyira: —¿Deero tiigʉ́ mʉ́ãrẽ buegʉ́ ñañaré tiirámena, niyeru wapasébosari basocamena yaai? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesupé teeré tʉogʉ́, cʉ̃́ãrẽ jĩĩyigʉ: —Diaremanirã ʉcotigʉre boorícua; diarecʉtira dícʉ ʉcotigʉre boocúa. “Ãñuré dícʉ tiia” jĩĩrã́rẽ ãmaãgʉ̃ atiriwʉ; ñañaré tiirápere ãmaãgʉ̃ atiwʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sicabʉreco Juan buerére nʉnʉrã́, ãpẽrã́ fariseo basoca betirá tiiyíra. Cʉ̃́ã betirí, sĩquẽrã Jesús pʉto wáa, cʉ̃ʉ̃rẽ sãĩñáyira: —Juan buerére nʉnʉrã́, fariseo basoca buerére nʉnʉrã́cã betiíya. ¿Deero tiirá mʉʉ buerápe betiríi? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesupé cʉ̃́ãrẽ jĩĩyigʉ: —Wãmosíagʉdʉ boocórira cʉ̃ʉ̃rẽ “yaaria; betirá tiia” jĩĩrĩ, ñañaniã. Wãmosíagʉdʉ cʉ̃́ãmena niirĩ, betimasĩ́ña maniã. ");
INSERT INTO tue_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Too síro cʉ̃ʉ̃ néewanogʉ̃daqui. Teebʉrecorire betiádacua, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Sĩcʉ̃ sutiró bʉcʉrore mama caseroména seeréturiqui. Teeré tiiátã, coserí, mama caserope wéedʉo, bʉcʉ caserore yigajõãrĩ tiicú. Teero tiirí, pairí cope yiganemocu. ");
INSERT INTO tue_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Teerora sĩcʉ̃ mama vinorẽ wáicʉra caseropori bʉcʉporimena posetíriqui. Teeré tiirí, wʉga, teepori esarí, podojõãcu. Vino píobatejõã, teeporicã cõõjṍãcu. Teero tiirá, mama vinorẽ mamapóripʉ posetíro booa, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sicabʉreco judíoa yeerisãri bʉreco niirĩ, Jesús cʉ̃ʉ̃ buerámena trigo wesepʉ netõwáyigʉ. Too netõwára, cʉ̃ʉ̃ buerá trigore tʉ̃nenʉcãyira, yaaadara. ");
INSERT INTO tue_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo basoca cʉ̃ʉ̃rẽ jĩĩyira: —Ĩñaña. Marĩrẽ yeerisãri bʉrecore padedutiripacari, ¿mʉʉ buerápeja deero tiirá padera tiii? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Õpʉ̃ David sicabʉreco yaaré manirĩ́, jʉabóayigʉ. Cʉ̃ʉ̃ menamacãrã jʉabóaramena cʉ̃ʉ̃ tiiríguere mʉ́ã buerá niipacara, ¿masĩrii? ");
INSERT INTO tue_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cõãmacʉ̃wiipʉ sããwayigʉ. Toopʉ́ pã mesa sotoa pesariguere “Cõãmacʉ̃ye niiã” jĩĩriguere yaapetijãyigʉ cʉ̃ʉ̃ menamacãrãmena. Paiá dícʉre yaaré niimiyiro. Davipé pai niiripacʉ, teeré sãĩ, yaapetijãyigʉ. Abiatar paiaré dutigʉ́ niirito, David teero tiiyígʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús jĩĩnemoyigʉ: —Cõãmacʉ̃ yeerisãri bʉrecore cṹũrigʉ niiwĩ, basocáre tiiápugʉ. Basocápe yeerisãri bʉrecore tiiápuaro jĩĩgʉ̃ mee cṹũrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Teero tiigʉ́, yʉʉ niipetira sõwʉ̃ yeerisãri bʉreco niirĩ, basocá tiiádarere dutimasĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús cʉ̃ʉ̃ tiirucúrobirora judíoa neãrí wiipʉ sããwayigʉ sũcã. Toopʉ́ sĩcʉ̃ wãmo bʉʉre cʉogʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","“¿Marĩ yeerisãri bʉrecore cʉ̃ʉ̃rẽ netõnégʉ̃dari?” jĩĩ wãcũrã, ĩñanʉnʉseyira, wedesããdara. ");
INSERT INTO tue_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús wãmo bʉʉre cʉogʉ́re jĩĩyigʉ: —Wʉ̃mʉnʉcãña basocá decopʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús too niirã́rẽ sãĩñáyigʉ: —Marĩrẽ dutiré ¿deero tiidutíi yeerisãri bʉreco niirĩ? ¿Ãñurére o ñañarére tiidutíi? ¿Basocáre netõnérere o basocáre sĩãcõã́rere tiidutíi? jĩĩmiyigʉ. Cʉ̃́ãpe yʉʉriyira. ");
INSERT INTO tue_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Teero tiigʉ́, Jesupé cʉ̃́ãrẽ cúaremena cãmenʉcã́ ĩñayigʉ. Cʉ̃́ã tʉodʉgáheri ĩñagʉ̃, bayiró bóaneõgʉ̃ wáayigʉ. Wãmo bʉʉre cʉogʉ́re: —Mʉʉya wãmorẽ súucoya, jĩĩyigʉ. Cʉ̃ʉ̃peja súucoyigʉ. Teero tiiríra, cʉ̃ʉ̃ya wãmo sicato niirirobirora pʉtʉáyiro. ");
INSERT INTO tue_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseo basocape witiwayira. Máata Herodere tʉonʉnʉ́seramena “¿deero tii marĩ ãnirẽ́ sĩãã́dariye?” jĩĩ wedesewayira. ");
INSERT INTO tue_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús cʉ̃ʉ̃ buerámena Galileataro wesapʉ wáayigʉ. Paʉ Galilea dita macãrã cʉ̃ʉ̃rẽ nʉnʉyíra. ");
INSERT INTO tue_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cʉ̃ʉ̃ pee ãñuré tiirí tʉorá, paʉ basocá cʉ̃ʉ̃ pʉtopʉ wáayira. Judea dita macãrã, Jerusalén macãrã, Idumea dita macãrã, día Jordán muĩpũ mʉãatirope macãrã, Tiro wesa macãrĩ macãrã, Sidón wesa macãrĩ macãrã Jesuré ĩñarã wáayira. ");
INSERT INTO tue_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cʉ̃́ã paʉ niirĩ ĩñagʉ̃, Jesús cʉ̃ʉ̃ bueráre sicawʉ́ dooríwʉ cʉoyúedutiyigʉ, “tuudiyóbocua” jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cʉ̃ʉ̃ paʉ netõnéyigʉ. Teero tiirá, ãpẽrã́ diarecʉtira cʉ̃ʉ̃rẽ padeñádʉgara, cʉ̃ʉ̃rẽ tuudiyóatiyira. ");
INSERT INTO tue_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wãtĩã cʉorá Jesuré ĩñarã, cʉ̃ʉ̃ díamacʉ̃ ñicãcoberimena jeacũmu, bayiró bʉsʉrómena: —Mʉʉ Cõãmacʉ̃ macʉ̃ niiã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús wãtĩãrẽ tutuaromena dutiyigʉ: —Teeré wederijãña ãpẽrã́ tʉocóro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús ʉ̃tãgʉ̃pʉ́ mʉãwayigʉ. Toopʉ́ cʉ̃ʉ̃ tʉsaráre neãdutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cʉ̃́ã neãrirapʉre doce ʉ̃mʉãrẽ beseyigʉ cʉ̃ʉ̃mena nii bueadarare. —Yʉʉ besearira niiã mʉ́ã. Yée maquẽrẽ wedera wáaadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Cʉ̃ʉ̃ tiimasĩ́rere ticoyigʉ cʉ̃́ãrẽ, wãtĩãrẽ cõãwionecoaro jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cʉ̃́ã noquẽrã niiyira: Simón (cʉ̃ʉ̃rẽna Jesupé “Pedro” wãme tuuyigʉ), ");
INSERT INTO tue_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, cʉ̃ʉ̃ bai Juan (cʉ̃́ã Zebedeo põna niiyira. Jesús cʉ̃́ãrẽ “Boanerges” wãme tuuyigʉ. “Boanerges” cʉ̃́ã wedeseremena jĩĩrõ “bʉpo põna” jĩĩrõ tiiyíro), ");
INSERT INTO tue_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago (Alfeo macʉ̃), Tadeo, Simón (romanuã dutiráre cõãdʉgara menamacʉ̃), ");
INSERT INTO tue_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote (too síropʉ Jesuré ĩñatutirapʉre wedesãcotegʉdʉ) niiyira. ");
INSERT INTO tue_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesús wiipʉ́ sããwayigʉ. Toopʉ́re paʉ basocá neãyira sũcã. Teero tiirá, Jesús, cʉ̃ʉ̃ buerá yaamasĩriyira. ");
INSERT INTO tue_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Teeré Jesuyá wederá tʉoyíra. Cʉ̃ʉ̃rẽ “mecʉ̃jṍãqui” jĩĩrã, néerã wáayira. ");
INSERT INTO tue_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisés jóarigue buerá Jerusalénpʉ atiarirape biiro jĩĩyira: —Ãni wãtĩãrẽ dutigʉ́ Beelzebú tutuaremena wãtĩãrẽ cõãwionecoi, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús cʉ̃́ãrẽ neãduti, queorémena wedeyigʉ: —Satanás cʉ̃ʉ̃rẽ padecoterare cõãriqui. ");
INSERT INTO tue_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sicadita macãrã sĩcãrõména niihẽrã, cʉ̃́ã basiro cãmerĩ́quẽrã, tiidita macãrã petijṍãcua. ");
INSERT INTO tue_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sicawií macãrã sĩcãrõména niihẽrã, cʉ̃́ãcã petijṍãcua. ");
INSERT INTO tue_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanás cʉ̃ʉ̃rẽ padecoterare cõããtã, cʉ̃ʉ̃ dutiré petijṍãcu. Teeména yapacʉtíjõãqui. ");
INSERT INTO tue_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Sĩcʉ̃ tutuagʉya wiire sããwagʉ, cʉ̃ʉ̃rẽ siatúcũripacʉ, ẽmamasĩriqui; siatúcũtoagʉpʉ, cʉ̃ʉ̃ya wii maquẽrẽ ẽmamasĩqui. ");
INSERT INTO tue_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cõãmacʉ̃ basocáre niipetire cʉ̃́ã ñañaré tiirére, ñañarõ wedeserere acabógʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cʉ̃ʉ̃ teero acabópacʉ, cʉ̃́ã Espíritu Santore ñañarõ wedeseripereja, acabóridojãgʉ̃daqui. Cʉ̃́ã Espíritu Santore ñañarõ wedeseri, wapa petirícu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Teeré jĩĩyigʉ, cʉ̃́ã “wãtĩ cʉoi” jĩĩrĩ tʉogʉ́. ");
INSERT INTO tue_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús paco, cʉ̃ʉ̃ baira jeayira. Cʉ̃́ã sopepʉ́ jeanʉcã, Jesuré atiduticoyira. ");
INSERT INTO tue_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Cʉ̃ʉ̃ pʉto duirá cʉ̃ʉ̃rẽ jĩĩyira: —¡Coe! Mʉʉ paco, mʉʉ baira sopepʉ́ mʉʉrẽ atidutiayira, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—¿Noã niiĩ yʉʉ paco, yʉʉ baira? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Cʉ̃ʉ̃ pʉto duiráre ĩña, cʉ̃́ãrẽ jĩĩyigʉ: —Ãniã yʉʉ paco, yʉʉ baira tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cõãmacʉ̃ boorére tiiráno cʉ̃́ãrã yʉʉ bai, yʉʉ bayio, yʉʉ paco tiiróbiro niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Opatutí Jesús Galileataro wesapʉ buenʉcãyigʉ. Paʉ basocá cʉ̃ʉ̃ pʉtopʉ neãyira. Cʉ̃́ã paʉ niinetõrĩ ĩñagʉ̃, dooríwʉpʉ mʉãsã, jeanuãyigʉ. Ditatuparipʉ pʉtʉáyira basocápeja. ");
INSERT INTO tue_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cʉ̃ʉ̃ wãcũrémena pee queoré bueyigʉ cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tʉoyá ateré, jĩĩyigʉ—. Sĩcʉ̃ basocʉ́ oteréperire wẽ́ẽbategʉ wáayigʉ, wiiáro jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cʉ̃ʉ̃ wẽ́ẽbatewari, sĩquẽñeperi maapʉ ñaacũmuyiro. Minipõná ati, teeré yaapetijãyira. ");
INSERT INTO tue_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Apeyepéri ʉ̃tãyepa dita péerogã cʉorópʉ ñaacũmuyiro. Tiidita ʉ̃cʉ̃hẽ́rõgã niijĩrõ, máata manamiyiro. ");
INSERT INTO tue_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Muĩpũ asirí, ocobopó, nʉcõrĩ manijĩ́rõ, sĩnijṍãyiro. ");
INSERT INTO tue_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apeyepéri pota watoapʉ ñaacũmuyiro. Pota teeré wiinetṍmʉã, sĩãjã́yiro. Dʉcamaniyiro. ");
INSERT INTO tue_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Apeyepéri ote ʉseniri ditapʉ ñaacũmuyiro. Tee wii, bʉcʉámʉã, dʉcacʉtiyiro. Sicasati treintaperi, apesatí sesentaperi, apesatí cienperi dʉcacʉtiyiro, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Basocá wáapetiari siro, Jesús sĩcʉ̃rã niirĩ ĩñarã, cʉ̃ʉ̃ pʉtogã niiãrira, cʉ̃ʉ̃ buerá docemena cʉ̃ʉ̃rẽ sãĩñáyira: —¿Deero jĩĩdʉgaro tiii mʉʉ queorémena buearigue? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Tíatopʉ masĩña maniríguere Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere mʉ́ãrẽ masĩrĩ tiia. Yʉʉre padeohérare queorémena wedea, ");
INSERT INTO tue_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yʉʉ tiirére ĩñapacara, ĩñamasĩrijããrõ jĩĩgʉ̃; yée maquẽrẽ tʉopacára, tʉomasĩ́rijããrõ jĩĩgʉ̃. Cʉ̃́ã tʉomasĩ́rãno niirã, cʉ̃́ã ñañaré tiirére duubójĩya; acabóre sãĩbójĩya; Cõãmacʉ̃ cʉ̃́ãrẽ acabóbojĩyi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cʉ̃́ãrẽ wedequẽnoyigʉ: —¿Mʉ́ã ate queorére tʉomasĩ́rii? Too docare ¿deero tii apeyé queorére tʉomasĩ́ãdari? ");
INSERT INTO tue_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Opaperire ote wẽ́ẽbategʉ tiiróbiro niiqui Cõãmacʉ̃ye quetire wedegʉ́. ");
INSERT INTO tue_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ãpẽrã́ basocá maapʉ ñaacũmuãreperibiro niicua. Cʉ̃́ã tee quetire tʉomícua. Máata Satanás ati, cʉ̃́ã tʉomíãriguere ẽmapetijãqui. ");
INSERT INTO tue_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ãpẽrã́ ʉ̃tãyepapʉ ñaacũmuãreperibiro niicua. Tee quetire tʉorá, máata ãñurõ ʉseniremena tʉomícua, tʉorápeja. ");
INSERT INTO tue_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nʉcõrĩ manijĩ́rã, yoari ʉseniricua. Cʉ̃́ãrẽ ñañarõ tiirí, o ãpẽrã́ tee quetire padeoré wapa cʉ̃́ãrẽ ñañarõ netõrĩ́ tiirí, máata padeodújãcua. ");
INSERT INTO tue_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ãpẽrã́ pota watoapʉ ñaacũmuãreperibiro niicua. Tee quetire tʉomícua, tʉorápeja. ");
INSERT INTO tue_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Atibʉ́reco maquẽpere bayiró wãcũcua. “Ãñurõ niiãdacu pee apeyé cʉorá”, jĩĩ wãcũmicua. Bʉ́recoricõrõ apeyenórẽ bayiró boonemócua. Tee niipetire cãmotájãcu tee quetire. Dʉcamanirã tiiróbiro niicua. ");
INSERT INTO tue_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ãpẽrã́ ʉseniri ditapʉ ñaacũmuãreperibiro niicua. Tee quetire tʉorá, padeocúa. Cʉ̃́ã teero tiirá, dʉcacʉtireyucʉ tiiróbiro niicua. Ãpẽrã́ treintaperi, ãpẽrã́ sesentaperi, ãpẽrã́ cienperi dʉcacʉtireyucʉ tiiróbiro niiyucocua, jĩĩ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Apeyé queorémena wedenemoyigʉ: —Basocá sĩãwócorigare moocṹricua. Teero biiri cʉ̃́ã cãnirṍ docapʉ sĩãdʉpóricua. Teero tiiróno tiirá, ʉ̃mʉã́rõpʉ péocua, ãñurõ bóearo jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tee tiiróbirora tíatopʉ basocá masĩña maniríguere masĩnoãdacu. Bauhéropʉ niirécã bauádacu. ");
INSERT INTO tue_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Mʉ́ã tʉorére ãñurõ wãcũnʉnʉseya. Péerogã masĩdʉgara, péerogã masĩãdacu. Pairó masĩdʉgara, pairó masĩãdacu. Pairó masĩdʉgari, Cõãmacʉ̃ masĩré ticonemogʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ãñurõ tʉonʉnʉ́seranorẽ Cõãmacʉ̃ nemorṍ masĩré ticogʉdaqui. Tʉodʉgáheranorẽ cʉ̃́ã masĩmiriguere ẽmajãgʉ̃daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Apeyé queorémena wedenemoyigʉ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdare atequetí tiiróbiro niiã: Sĩcʉ̃ basocʉ́ oteréperi wẽ́ẽbatequi. ");
INSERT INTO tue_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cʉ̃ʉ̃ cãnirĩ́, cʉ̃ʉ̃ wãcãrĩ́, bʉ́recori, ñamirĩ́ teeperi tee booró mana, wiicú. “¿Deero wiigári?” jĩĩmasĩriqui. ");
INSERT INTO tue_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tiiápuro manirṍ opapũnagã súuwitinʉcã, pṹũrĩ witi, bʉcʉátuajea, dʉcacʉticu sáa. ");
INSERT INTO tue_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Teeperi bʉcʉápetiri, teesatiripe sĩnijṍãcu. Teero wáari ĩña, “tʉ̃neríto jeaa” jĩĩ, tʉ̃neneõqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cʉ̃́ãrẽ wedenemoyigʉ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere ate queorémena wedegʉda. ");
INSERT INTO tue_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sicape mostazape tiiróbiro niiã. Niipetire oteréperi dʉaró péeripegã niiã. ");
INSERT INTO tue_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Péeripegã niipacaro, oteri siro, wiirópʉja, niipetire oteyucʉ nemorṍ ʉ̃mʉã́rigʉ bʉcʉácu. Pacadʉpʉ́ri cʉocú. Minipõná teedʉpʉripʉ pesacua, muĩpũ bayiró asirí. Toopʉ́ põnacʉtícua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús cʉ̃ʉ̃ye quetire wedegʉ, pee queorémena wedeyigʉ. Cʉ̃́ã tʉomasĩ́rõ jeatuaro wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Cʉ̃́ãrẽ wederécõrõ queorémena wedeyigʉ. Cʉ̃ʉ̃ buerápere cʉ̃́ã dícʉ niirĩ, niipetirere tee queorére ãñurõ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesús tiibʉrecora náĩcũmuatiri, cʉ̃ʉ̃ bueráre: —Jãmʉ atitaró iiníñapʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cʉ̃́ã cʉ̃ʉ̃ sãñaãriwʉpʉ mʉãsã, Jesuré néetĩãyira. Basocápe cʉ̃́ã niiãriropʉra pʉtʉájãyira. Ãpẽrã́ apeyepáwʉmena cʉ̃́ãrẽ bapacʉtitĩãyira. ");
INSERT INTO tue_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cʉ̃́ã tĩãwari, wĩno bayiró wẽẽcʉtʉatiyiro. Ocoturí tiiwʉpʉ́re páabatesãyiro. Tee páabatesãrĩ, tiiwʉ́ duadiaropʉ tiimíyiro. ");
INSERT INTO tue_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesupé waatúropʉ cʉ̃ʉ̃ya dupure sutipó sotoápʉ duupéo, cãnisãñájãyigʉ. Cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ wãcõrã́rã, jĩĩyira: —¡Ʉ̃sãrẽ buegʉ́! ¿Mʉʉ ĩñarii? Marĩ duadiarapʉ tiiara, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús wʉ̃mʉnʉcã, wĩnorẽ́ nʉcʉ̃ã́rĩ tiiyígʉ. Ocoturíre: —¡Ditamaníjõãña! jĩĩyigʉ. Wĩno netõjṍãyiro. Nʉcʉ̃ã́petijõãyiro. ");
INSERT INTO tue_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cʉ̃ʉ̃ bueráre jĩĩyigʉ: —¿Deero tiirá nocõrõ cuii? ¿Mʉ́ãrẽ padeoré manidójãĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cʉ̃́ã bayiró cuirira niijĩrã, cãmerĩ́ wedeseyira: —¿Noãnó niigariye ãni? Cʉ̃ʉ̃rẽ wĩno, ocoturípʉra yʉʉjã, netõnʉcã́ria, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galileatarore Gerasa ditapʉ tĩãjeayira. ");
INSERT INTO tue_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús dooríwʉ niiãrigʉ maanʉcã́rĩ, sĩcʉ̃ diarirare cṹũre coperipʉ niiãrigʉ Jesús pʉtopʉ máata atiyigʉ. Wãtĩã cʉogʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Cʉ̃ʉ̃ diarirare cṹũre coperipʉ niijãyigʉ. Deero tii siatúmasĩña maniyígʉ. Cõmedárimenacãrẽ siatúmasĩña maniyíro. ");
INSERT INTO tue_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pee peti cõmedárimena cʉ̃ʉ̃ye wãmorĩrẽ, cʉ̃ʉ̃ye dʉporire siatúri, wéetajãyigʉ. Sĩcʉ̃no cʉ̃ʉ̃rẽ sĩcãrĩbíriyira. ");
INSERT INTO tue_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bʉ́recori, ñamirĩ́ cʉ̃ʉ̃ ʉ̃tãyucʉpʉ diarirare yaarópʉ acaribínetõgʉ̃ tiiyígʉ. Ʉ̃tãperimena cʉ̃ʉ̃ basiro cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ dote, cãmitujãgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesuré yoaropʉ ĩñagʉ̃rã, cʉtʉáti, cʉ̃ʉ̃ pʉto ñicãcoberimena jeacũmuyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesupé cʉ̃ʉ̃rẽ jĩĩyigʉ: —Wãtĩ, ãnipʉ́re niigʉ̃́, witiwaya, jĩĩyigʉ. Cʉ̃ʉ̃pe bayiró acaribíremena jĩĩyigʉ: —Jesús, Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́ macʉ̃, yʉʉre potocṍrijãña. Cõãmacʉ̃ ĩñacoropʉ bayiró sãĩã: Yʉʉre ñañarõ netõrĩ́ tiiríjãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Deero wãmecʉtii mʉʉ? jĩĩyigʉ Jesús cʉ̃ʉ̃rẽ. —Ʉ̃sã wãtĩã paʉ niiã. Teero tiigʉ́, yʉʉ “Legión” wãmecʉtia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pee peti cʉ̃ʉ̃rẽ sãĩyígʉ: —Ʉ̃sãrẽ aperopʉ́ ticocorijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ʉ̃tãgʉ̃pʉ́ paʉ yesea yaanucũyira. Wãtĩã bayiró sãĩyíra: ");
INSERT INTO tue_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—Ʉ̃sãrẽ yesea pʉto wáadutiya. Ʉ̃sã cʉ̃́ãpʉre sããwa, niiãda, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Teerora tiiyá, jĩĩyigʉ Jesús. Cʉ̃ʉ̃ teero jĩĩrĩrã, basocʉ́pʉre niiãrira witiwa, yeseapʉre sããwayira. Yeseape opatʉdipʉ cʉtʉcʉtʉ́buawa, opataropʉ ñaacoñuãyira. Cʉ̃́ã dos mil watoa niimiãrira duajõãyira. ");
INSERT INTO tue_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yesea coterí basoca cuicocʉtʉayira. Cʉ̃́ãya macã macãrãrẽ, cã́pũrĩpʉ macãrãrẽ teeré wedeyira. Cʉ̃́ã wederi tʉorá, “¿deero wáaayiri?” jĩĩ, ĩñarã wáayira. ");
INSERT INTO tue_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús pʉtopʉ jeara, paʉ wãtĩã cʉogʉ́ niimiãrigʉre duiri ĩñayira. Cʉ̃ʉ̃ suti sãña, ãñurõ wedesejãyigʉ sũcã. Tee niipetirere ĩñarã, cuiyira. ");
INSERT INTO tue_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Basocʉ́ wãtĩã cõãwionecori ĩñaãrira cʉ̃ʉ̃rẽ wáaariguere wedeyira ãpẽrãrẽ́. Yeseare wáaariguecãrẽ wedeyira. ");
INSERT INTO tue_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Teeré tʉorá, Jesuré bayiró: —¡Wáagʉa! Ʉ̃sãya ditapʉre pʉtʉárijãña, jĩĩnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús dooríwʉpʉ mʉãsãrĩ, wãtĩã cʉogʉ́ niimiãrigʉ cʉ̃ʉ̃rẽ bayiró sãĩmíyigʉ: —Yʉʉcã mʉʉmena wáagʉda, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Yʉʉmena atirijãña; mʉʉya wiipʉ pʉtʉawaya. Cõãmacʉ̃ mʉʉrẽ tiiáriguere, mʉʉrẽ bóaneõremena ĩñaãriguere wedegʉ wáaya mʉʉ pʉto niirã́rẽ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cʉ̃ʉ̃ wáa, Decápolis macãrĩpʉ niipetire Jesús cʉ̃ʉ̃rẽ tiiríguere wedenʉcãyigʉ. Niipetira cʉ̃ʉ̃ wederére tʉorá, tʉomaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús dooríwʉmena apeniñapʉ́ tĩãjeari, paʉ basocá cʉ̃ʉ̃ pʉtopʉ neãyira. Teero tiigʉ́, día wesagãpʉ pʉtʉánʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Toopʉ́re sĩcʉ̃ judíoa neãrí wii dutirá menamacʉ̃ jeayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Jairo. Jesuré ĩñagʉ̃, cʉ̃ʉ̃ pʉto ñicãcoberimena jeacũmu, ");
INSERT INTO tue_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bayiró sãĩyígʉ: —Yʉʉ macõ diagopʉ tiiáwõ. Jãmʉ yʉʉmena. Ñaapeógʉ atiya, coore netõã́rõ jĩĩgʉ̃. Mʉʉ teero tiirí, catigodaco, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús cʉ̃ʉ̃mena wáayigʉ. Paʉ basocá cʉ̃ʉ̃rẽ tuunʉnʉ́seyira. ");
INSERT INTO tue_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cʉ̃́ã watoapʉ sĩcõ numiṍ niiyigo. Doce cʉ̃marĩ beti niiré teero niirucujãyiro. ");
INSERT INTO tue_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʉcotira paʉ cʉ̃́ã ʉcotiri, teeména nemorṍ ñañarõ netõyígo. Coo niyeru cʉomíriguemena cʉ̃́ãrẽ wapatíma jĩĩgõ, petinójõãyigo. Coo diaré petiríyiro. Bayiró peti wáayigo. ");
INSERT INTO tue_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús basocáre netõnére quetire tʉoyígo. Teeré tʉogó, Jesús sucubíro basocá watoapʉ jea, cʉ̃ʉ̃yaro sutiroré padeñáyigo. ");
INSERT INTO tue_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Yʉʉ cʉ̃ʉ̃yaro padeñáremena dícʉ netõjã́gõdacu”, jĩĩ wãcũyigo. ");
INSERT INTO tue_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Coo padeñárĩrã, coo diaré máata bʉʉnʉcã́jõãyiro. Cooya õpʉ̃ʉ̃ ãñujõãriguere masĩjãyigo. ");
INSERT INTO tue_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús “yʉʉ tutuaremena netõrĩ́ tiiátʉ” jĩĩ tʉomasĩ́jãyigʉ. Máata cãmenʉcã́, sãĩñáyigʉ: —¿Noã yáaro sutiroré padeñáĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ jĩĩyira: —¿Mʉʉ ĩñarii? ¿Basocá paʉ tuunʉnʉ́seri ĩñapacʉ, “¿noã yʉʉre padeñáĩ?” jĩĩ sãĩñáĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesupé “¿noã yʉʉre padeñáĩ?” jĩĩgʉ̃, ĩñaãmayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Coope coore netõã́riguere masĩjĩgõ, cʉ̃ʉ̃ díamacʉ̃ ñicãcoberimena jeacũmuyigo. Cuigo, ñapõpiyigo. Niipetire coore wáaariguere wedeyigo. ");
INSERT INTO tue_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús coore jĩĩyigʉ: —Yáa wedego, mʉʉ padeojĩ́gõ, netõnénoãrigopʉ pʉtʉáa. Diaremanigõ ʉseniremena pʉtʉawagoa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cʉ̃ʉ̃ coomena wedesegʉ tiirí, Jairoya wii macãrã jeayira. —Mʉʉ macõ diajõããwõ mée. Buegʉ́re nocõrõrã potocṍduya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús cʉ̃́ã jĩĩãriguere tʉopacʉ́, judíoa neãrí wii dutigʉ́re jĩĩyigʉ: —Wãcũpatirijãña; diamacʉ̃́rã padeoyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús cʉ̃ʉ̃mena paʉ bapacʉtiri booríyigʉ. Noquẽrãrẽ “jãmʉ” jĩĩyigʉ: Pedrore, Santiagore, cʉ̃ʉ̃ bai Juanrẽ́. ");
INSERT INTO tue_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesús judíoa neãrí wii dutigʉ́ya wiipʉ jeayigʉ. Toopʉ́ jeagʉ, basocá uti, bóaneõremena acaribírare ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tiiwiipʉ́ sããwagʉ, too basocá niirã́rẽ jĩĩyigʉ: —¿Deero tiirá nocõrõ acaribí, utii? Wĩmagõ diarico; cãnigṍ tiicó, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cʉ̃́ãpe cʉ̃ʉ̃rẽ buijã́miyira. Jesupé niipetirare witiwadutiyigʉ. Cʉ̃́ã witiwaari siro, wĩmagõ pacʉre, pacore, cʉ̃ʉ̃mena niirã́mena coo pesarí tatiapʉ sããwayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Toopʉ́ sããjeagʉ, diarigo wãmorẽ ñee: —Talita, cumi, jĩĩyigʉ cʉ̃ʉ̃ye arameomena. Biiro jĩĩgʉ̃, “wĩmagõ, wʉ̃mʉnʉcãña” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Máata wĩmagõ doce cʉ̃marĩ cʉogó wʉ̃mʉnʉcã, wáayigo. Coo masãrĩ ĩñarã, bayiró ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús bayiró wededutiriyigʉ teeré. —Coore yaaré ecayá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Too niiãrigʉ cʉ̃ʉ̃ masãri macãpʉ coepʉtʉ́ayigʉ. Cʉ̃ʉ̃ buerácã cʉ̃ʉ̃mena wáayira. ");
INSERT INTO tue_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Judíoa yeerisãri bʉreco jeari, Jesús cʉ̃́ã neãrí wiipʉ buenʉcãyigʉ. Paʉ basocá cʉ̃ʉ̃ buerére tʉorá tʉomaníjõã, cãmerĩ́ jĩĩyira: —Ãni teeré ãnopʉ́ bueriwi. Ãpĩ cʉ̃ʉ̃ masĩrére ticojĩyi. Tee masĩrémena tiiẽ́ñoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ãni María macʉ̃ táboa padegʉ́ niiĩ; Santiago, José, Judas, Simón sõwʉ̃ niiĩ; cʉ̃ʉ̃ baira numiãcã ãno marĩ watoapʉ niiĩya, ¿teerora? jĩĩ wedeseyira. Teeré wãcũrã, cʉ̃ʉ̃rẽ padeodʉgáriyira. ");
INSERT INTO tue_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesupé cʉ̃́ãrẽ jĩĩyigʉ: —Niipetira apeyé macãrĩ macãrã sĩcʉ̃ profetare padeocúa. Cʉ̃ʉ̃ya dita macãrã, cʉ̃ʉ̃ya wedera, cʉ̃ʉ̃ya wii macãrã doca cʉ̃ʉ̃rẽ padeorícua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Toopʉ́re cʉ̃ʉ̃ tutuaremena tiiẽ́ñomasĩriyigʉ. Sĩquẽrã diarecʉtira dícʉre ñaapeóyigʉ, cʉ̃́ã diarecʉtire netõã́rõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Basocá padeohéri ĩñagʉ̃, ĩñamanijõãyigʉ. Too pʉto niiré macãrĩpʉ buenetõgʉ̃ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cʉ̃́ã docere cʉ̃ʉ̃ pʉtopʉ neãduti, pʉarã́cõrõ dícʉ ticoconʉcãyigʉ. Wãtĩãrẽ cõãmasĩrere ticoyigʉ cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Mʉ́ã wáara, apeyenó néewarijãña, jĩĩyigʉ—. Mʉ́ã tuurítuarigʉ dícʉre néewaya. Wasopo, pugue, niyeru néewarijãña. ");
INSERT INTO tue_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapatu, suti, mʉ́ã sãñaré dícʉre néewaya. Apeyé mʉ́ã suti wasoádarere néewarijãña, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mʉ́ã wiipʉ́ jeara, tiimacãpʉ mʉ́ã niiãdaro jeatuaro pʉtʉácũmuña. ");
INSERT INTO tue_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Apemacãpʉ́re mʉ́ãrẽ ñeedʉgaheri, mʉ́ã wederére tʉodʉgáheri, tiimacãrẽ netõjṍãña. Tooré netõwára, tiimacã maquẽ dita mʉ́ãye dʉporipʉ túaariguere páabatecũña. Teero tiirá, mʉ́ã “atimacã́ macãrã wapa cʉoóya” jĩĩrã tiiádacu, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Cʉ̃́ã wáajõãyira, basocáre “mʉ́ã ñañaré tiirére wãcũpati, wasoyá” jĩĩnetõrã wáara. ");
INSERT INTO tue_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Teero biiri paʉ wãtĩãrẽ cõãwionecoyira. Paʉ diaré cʉoráre ʉsemena tuusĩã́, cʉ̃́ãrẽ netõnéyira. ");
INSERT INTO tue_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Niipetiropʉ Jesús tiirére tʉosesájõãyira. Herodes Galilea dita dutigʉ́cã tee quetire tʉogʉ́ jĩĩyigʉ: —Juan basocáre wãmeõtiri basocʉ masãgʉ̃ masãjĩyi. Teero tiiró, cʉ̃ʉ̃pʉre tutuare niicu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","—Elías niiqui, jĩĩyira ãpẽrã́. —Tíato macãrã profetas tiiróbiro niigʉ̃́ niiqui, jĩĩyira ãpẽrãpé. ");
INSERT INTO tue_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, Herodepe jĩĩyigʉ: —Tiibʉreco yʉʉ dupure páatadutirigʉ Juan niiqui. Cʉ̃ʉ̃rã́ mecʉ̃tígãrẽ masãqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes too sʉgueropʉ Herodías ʉsenigõ niiãrõ jĩĩgʉ̃, Juanrẽ́ peresuwiipʉ néewa, siatúcũdutiyigʉ. Herodías cʉ̃ʉ̃ bai Felipe nʉmo niimiyigo. Teero niipacari, Herodepe coore ẽma, nʉmocʉtijãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Teeré ĩñagʉ̃, Juan Herodere: —Mʉʉ bai nʉmorẽ nʉmocʉtimasĩria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Teero tiigó, Herodías Juanména bayiró cúadoajĩgõ, cʉ̃ʉ̃rẽ sĩãdutídʉgamiyigo. Teero wãcũpaco, sĩãdutímasĩriyigo. ");
INSERT INTO tue_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodepe Juanrẽ́ cuiyigʉ. Cʉ̃ʉ̃ basocʉ́ ãñugʉ̃́ niirére, cʉ̃ʉ̃ Cõãmacʉ̃yere tiinʉnʉ́serere masĩyigʉ. Juan wederére tʉogʉ́, bayiró wãcũpatiyigʉ. Teero wãcũpatipacʉ, ãñurõ ʉseniremena tʉoyígʉ, tʉogʉ́peja. Teero tiigʉ́, coo ñañarõ tiidʉgárere tiidutírimiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodes cʉ̃ʉ̃ bauári bʉreco jeari, bosebʉreco tiipéoyigʉ. Tiibʉrecore Herodías Juanrẽ́ coo sĩãdʉgárere bʉajeáyigo. Herodes bosebʉreco tiigʉ́, cʉ̃ʉ̃mena paderáre, teero biiri surara dutiráre, Galilea dita macãrã ʉpʉtí macãrãrẽ néõco, cʉ̃́ãmena boseyayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cʉ̃́ã yaarópʉ Herodías macõ sããwa, basaẽñoyigo. Coo basaẽñorere Herodes, ãpẽrã́ cʉ̃ʉ̃mena yaaduira bayiró tʉsayira. Teero tiigʉ́, Herodes coore jĩĩyigʉ: —Noo mʉʉ boorénorẽ sãĩrĩ́, ticogʉda, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Coore jĩĩyigʉ sũcã: —Niirṍrã jĩĩã: Noo yʉʉ dutiré dita decomena mʉʉ dutidʉgari, ticojãgʉ̃da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Coo paco pʉtopʉ witiwa: —¿Ñeenórẽ sãĩgṍdari yʉʉ? jĩĩyigo. Coo pacopé: —Juan basocáre wãmeõtiri basocʉya dupure, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Máata cʉtʉcʉtʉ́sã, cʉ̃́ã õpʉ̃rẽ sãĩyígo: —Mecʉ̃tígãrã opasida bapamena Juan basocáre wãmeõtiri basocʉya dupure néesã, ticoya, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Coo teero jĩĩrĩ tʉogʉ́, Herodes bayiró wãcũpatiyigʉ. Cʉ̃ʉ̃ boocórira tʉocóropʉ “niirṍrã mʉʉrẽ ticogʉda” jĩĩãrigʉ niijĩgʉ̃, “ticoria” jĩĩmasĩriyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Máata sĩcʉ̃ surarare Juanyá dupure páata, néeatidutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Surara peresuwiipʉ wáa, cʉ̃ʉ̃ya dupure páata, opasida bapamena néesã, coore ticoyigʉ. Coope coo pacopʉ́re ticoyigo. ");
INSERT INTO tue_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanrẽ́ teero tiiré quetire tʉorá, cʉ̃ʉ̃ buerére nʉnʉmíãrira toopʉ́ wáa, cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ née, ʉ̃tãtutipʉ cṹũrã wáayira. ");
INSERT INTO tue_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús beserira buenetõãri siro, coe, Jesús pʉtopʉ neãyira. Niipetire cʉ̃́ã tiiáriguere, basocáre bueariguere cʉ̃ʉ̃rẽ wedeyira. ");
INSERT INTO tue_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cʉ̃́ã pʉtopʉ naĩrõ paʉ jeará, ãpẽrã́ wáara niirĩ, péerogã yeerisã, yaa tiimasĩ́riyira. Teero tiigʉ́, Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Jãmʉ, wáaco marĩ dícʉ basocá manirṍpʉ. Toopʉ́ yeerisãco péero, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cʉ̃́ã sesaro dooríwʉpʉ mʉãsã, basocá manirṍpʉ wáajõãmiyira. ");
INSERT INTO tue_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Paʉ cʉ̃́ã wáari ĩñayira. Jesuré ĩñarira cʉ̃ʉ̃ wáaropʉ niipetire macãrĩ macãrã cʉtʉnʉnʉ́sewayira. Cʉ̃́ã sʉguero cʉ̃́ã tĩãjeaadarore yuetoayira. ");
INSERT INTO tue_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús dooríwʉpʉ sãñaãrigʉ duinʉcã́, basocá paʉre ĩñayigʉ. Oveja coterí basocʉ manirã́ tiiróbiro niirĩ ĩñagʉ̃, bóaneõ ĩñayigʉ. Teero tiigʉ́, cʉ̃́ãrẽ pee buenʉcãyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamicapʉ niirĩ, cʉ̃ʉ̃ buerá cʉ̃ʉ̃ pʉto jea, jĩĩyira: —Ñamicapʉ niiã. Ãnopʉ́ macã manirṍpʉ niiã. ");
INSERT INTO tue_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Basocáre “nocõrõrã niiã” jĩĩña. Pʉtogã niiré macãrĩpʉ, cã́pũ niiré wiseripʉ cʉ̃́ã yaaré sãĩ, yaara wáaaro, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Mʉ́ã cʉ̃́ãrẽ yaaré ecayá, jĩĩyigʉ. Cʉ̃́ãpe “¿deero tiigʉ́ teero jĩĩgari?” jĩĩmasĩrijĩrã, sãĩñáyira: —Ʉ̃sã cʉ̃́ãrẽ ecarí, ocho muĩpũrã pade wapatáremena yaaré sãĩnóbocu, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Noquẽpa pã cʉoi mʉ́ã? Ĩñarã wáaya, jĩĩyigʉ. Cʉ̃́ã ĩñatoa, cʉ̃ʉ̃rẽ: —Sicamoquẽñepa pã, wai pʉarã́ niiĩya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","—Basocá táa sotoapʉ opaburi duiaro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Basocá sĩquẽburire cien, apeyebúrire cincuenta jeanuãyira. ");
INSERT INTO tue_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús tee sicamoquẽñepa pãrẽ, wai pʉarã́rẽ née, ʉ̃mʉã́sepʉ ĩñamʉõco, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, pãrẽ pʉatásã, cʉ̃ʉ̃ bueráre basocápʉre batodutigʉ ticoyigʉ. Waicãrẽ teerora tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Niipetira yaa, yapijõãyira. ");
INSERT INTO tue_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yaatoaari siro, pã, wai cʉ̃́ã yaadʉaariguere doce piseri seesã́ dadodʉpóyira. ");
INSERT INTO tue_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Teeré yaarira ʉ̃mʉã́ dícʉre bapaqueori, cinco mil niiyira. ");
INSERT INTO tue_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús máata cʉ̃ʉ̃ bueráre cʉ̃ʉ̃ jeaariwʉpʉ jeasãduti, Betsaidapʉ tĩãwasʉguedutiyigʉ. Cʉ̃́ã wáari, cʉ̃ʉ̃pe basocáre “wáagʉ tiia” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cʉ̃́ãrẽ teeré jĩĩãri siro, ʉ̃tãgʉ̃pʉ́ Cõãmacʉ̃mena wedesegʉ mʉãwayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Náĩcũmuãri siro, dooríwʉ tiitaro decopʉ niiyiro; Jesupé burusotoápʉ sĩcʉ̃rã niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wĩno páapucãmotari, cʉ̃́ã waawámasĩhẽrĩ ĩñayigʉ. Bóemʉãatiri, Jesús cʉ̃́ã pʉtopʉ wáagʉ, oco sotoápʉ wáayigʉ. Cʉ̃́ãrẽ netõjṍãgʉ̃dʉ tiiróbiro tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cʉ̃ʉ̃rẽ oco sotoápʉ wáari ĩñarã, ʉcʉápetijõãyira. “¡Abʉ! ¡Basocʉ́ diarigʉ wãtĩ niiqui!” jĩĩ wãcũmiyira. Bayiró acaribíyira. ");
INSERT INTO tue_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Niipetira cʉ̃ʉ̃rẽ ĩña, ʉcʉápetijõãyira. Máata Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Wãcũtutuaya. Yʉʉ niiã. Cuirijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cʉ̃́ãyawʉpʉ mʉãsãyigʉ. Cʉ̃ʉ̃ mʉãsãrĩ, wĩno netõjṍãyiro. Teero wáari ĩñarã, bayiró ʉcʉá, ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pãmena cʉ̃ʉ̃ tiiẽ́ñoãriguere cʉ̃́ã “¿deero jĩĩrõ tiigári tee?” jĩĩmasĩriyira. Wãcũmasĩriyira. Teero tiirá, bayiró peti ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cʉ̃́ã tiitaropʉre tĩã, Genesaretpʉ jeayira. Cʉ̃́ãyawʉ dooríwʉre siatúpaso, maajṍãyira. ");
INSERT INTO tue_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Toopʉ́ cʉ̃́ã maajeánʉcãrĩ, too macãrã máata Jesuré ĩñamasĩyira. ");
INSERT INTO tue_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Teero tiirá, cʉ̃́ã niipetiropʉ cʉtʉwá, diarecʉtirare cʉ̃́ã cõãrémena néewayira. ");
INSERT INTO tue_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Noo cʉ̃ʉ̃ wáaropʉre, metãmacã́rĩgãpʉre, pacamacã́rĩpʉre, cã́pũpʉre, cʉ̃ʉ̃ netõwáadaropʉre diaráre néewa, cṹũ, yueyira. Jesuré sãĩyíra: —Mʉʉyaro sutiró yapa dícʉre padeñáma, jĩĩyira. Niipetira padeñáãrira netõjṍãyira. ");
INSERT INTO tue_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sicabʉreco fariseo basoca, teero biiri sĩquẽrã Moisés jóarigue buerá Jerusalénpʉ niiãrira jea, Jesús pʉtopʉ neãyira. ");
INSERT INTO tue_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Toopʉ́ neãrã, sĩquẽrã Jesús buerá yaari ĩñayira. “Jũĩrĩpíre wãmorĩmena yaara tiiíya” jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseo basoca, teero biiri niipetira judíoa wãmocosera, cʉ̃́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiinʉnʉ́seya. Teeré tiihéra, yaariya. ");
INSERT INTO tue_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Macã decopʉ jeaariracã teerora tiiíya. Cʉ̃́ã sĩniré baparire, píosãreparʉre, cõmepárʉre, cʉ̃́ã yeerisãduirere coseéya.) ");
INSERT INTO tue_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Teero tiirá, fariseo basoca, Moisés jóarigue buerá cʉ̃ʉ̃rẽ sãĩñáyira: —¿Deero tiirá mʉʉ buerá marĩ ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiinʉnʉ́serii? Jũĩrĩpíre wãmorĩmena yaara tiiíya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Mʉ́ã basocá ĩñahẽrõpʉ ñañaré tiirá niiã. Teero tiirá, tiiditórepira niiã. Isaías mʉ́ã mecʉ̃tígã tiirére diamacʉ̃́rã jóasʉguerigʉ niiwĩ. Cʉ̃ʉ̃ jóariguere ãñurõ tʉoádacu mʉ́ã: Ãniã basocá ʉseromena dícʉ yʉʉre padeoóya. Cʉ̃́ã tʉgueñarepe noopʉ́ niirõ niicu. ");
INSERT INTO tue_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bʉ́ri peti neããya. Yée maquẽrẽ “bueada” jĩĩpacara, basocá jĩĩrére buejãya, jĩĩti Cõãmacʉ̃, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mʉ́ã Cõãmacʉ̃ dutirépere duujã́ã. Mʉ́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiinʉnʉ́sera tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesús cʉ̃́ãrẽ jĩĩnemoyigʉ: —Bayiró ãñuré wãcũrémena Cõãmacʉ̃ dutirére jĩĩcãmotamasĩã, mʉ́ãyepere ãñurõ tiimʉ́ãnʉcããdara. ");
INSERT INTO tue_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Cõãmacʉ̃ Moisémena ate dutiyigʉ: “Mʉʉ pacʉ, mʉʉ pacore padeoyá. Cʉ̃́ãrẽ ñañarõ wedesegʉnorẽ sĩãcõã́jããrõ”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mʉ́ãpe merẽã dutijãã. Basocáre cʉ̃́ã pacʉre, cʉ̃́ã pacore “yʉʉ mʉ́ãrẽ tiiápumasĩriga; yée niyeru mʉ́ãrẽ ticoboariguere Cõãmacʉ̃rẽ ticopetijãwʉ̃” jĩĩdutia mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mʉ́ã teero dutira, cʉ̃́ã pacʉsʉ̃mʉãrẽ tiiápurere cãmotára tiia. ");
INSERT INTO tue_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mʉ́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere tiidutíra, Cõãmacʉ̃ dutirére wapamaníre tiiróbiro tiirá tiia. Apeyé pee ate tiiróbiro tiinʉnʉ́sera tiia mʉ́ã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cʉ̃́ãrẽ teero jĩĩãri siro, basocáre neãdutiyigʉ sũcã. Cʉ̃́ãcãrẽ jĩĩyigʉ: —Mʉ́ã niipetira yée maquẽrẽ tʉomasĩ́ãda jĩĩrã, tʉorá atiya, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Basocáre ʉseropʉ sããware cʉ̃́ãrẽ ñañarã́ wáari tiiría. Cʉ̃́ã popeapʉ witiatirepe cʉ̃́ãrẽ ñañarã́ wáari tiia. ");
INSERT INTO tue_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús paʉ watoapʉ niiãrigʉ wiipʉ́ sããwayigʉ. Toopʉ́ cʉ̃ʉ̃ buerá cʉ̃ʉ̃ queorémena wedeariguere sãĩñáyira. ");
INSERT INTO tue_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —¿Mʉ́ãcã ateré tʉomasĩ́rii? Niipetire basocáre ʉseropʉ sããware cʉ̃́ãrẽ ñañarã́ wáari tiiría. ");
INSERT INTO tue_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tee wãcũrépʉ sããwaricu; páagapʉ sããwacu. Too síro netõcówitiwacu, jĩĩyigʉ. Teero jĩĩgʉ̃, “niipetire yaaré ãñuré niiã” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús wedenemoyigʉ: —Basocá wãcũrépʉ witiatirepe cʉ̃́ãrẽ ñañarã́ wáari tiia. ");
INSERT INTO tue_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Basocá wãcũrépʉre ate witiaticu: ñañarõ wãcũré, ãpẽrãména ñañarõ ñeeapere, yaaré, basocáre sĩãcõã́re, ");
INSERT INTO tue_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ãpĩ nʉmorẽ ñeeapere, apegó manʉrẽ ñeeapere, apeyeré boonemósãre, ñañaré tiiré, ãpẽrãrẽ́ tiiditóre, ñañaré tiidúhere, ĩñatutire, ãpẽrãrẽ́ ñañarõ wedesere, “ãpẽrã́ nemorṍ ãñugʉ̃́ niiã” jĩĩ tʉgueñare, noo booró tiiã́mare witiaticu. ");
INSERT INTO tue_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tee niipetire ñañaré popeapʉ witiatia. Teerá basocáre ñañarã́ wáari tiia, jĩĩ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Too niiãrigʉ witiwa, Tiro, Sidón macãrĩ wesapʉ wáayigʉ. Toopʉ́re ãpẽrã́ masĩrijããrõ jĩĩgʉ̃, sicawiipʉ́ sããwamiyigʉ. Teero tiipacʉ́, masĩjãnoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Máata wãtĩ sããnorigo paco “Jesús toopʉ́ niiãyigʉ” jĩĩrére tʉoyígo. Coo cʉ̃ʉ̃ pʉtopʉ wáa, ñicãcoberimena jeacũmuyigo. ");
INSERT INTO tue_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Coo judíoayo mee niiyigo. Sirofenicia ditapʉ bauárigo niiyigo. Jesuré sãĩyígo: —Wãtĩrẽ cõãwionecoya yʉʉ macõrẽ, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús coore queorémena wedeyigʉ: —Wĩmarãpere ecasʉguéro booa cʉ̃́ã yaadʉgarecõrõ. Cʉ̃́ã yaarére ẽma, cʉ̃́ãyara díayiare cõãcũrĩ, ãñuria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Coocã queorémena yʉʉyigo: —Õpʉ̃, tee diamacʉ̃́rã niiã. Díayiapʉra mesa doca duirá wĩmarã yaadiocore manarĩrẽ yaacua, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cʉ̃ʉ̃ jĩĩyigʉ: —Mʉʉ ãñurõ yʉʉa. Teero tiigó, mʉʉya wiipʉ pʉtʉawaya. Wãtĩ mʉʉ macõpʉre niiãrigʉ wititoaqui sáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Coo wiipʉ́ pʉtʉajõãyigo. Toopʉ́ pʉtʉajeago, macõrẽ́ coo cõãrṍpʉ pesari ĩñayigo. Wãtĩ coopʉre niimiãrigʉ witijõãtoayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro wesapʉ niiãrigʉ witi, wáajõãyigʉ. Wáa, Sidón netõwá, Decápolis niiré macãrĩ netõwá, Galileataropʉ jeayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Toopʉ́ sĩcʉ̃ tʉohégʉre, ãñurõ wedesehegʉre Jesús pʉto néejeayira. Jesuré sãĩyíra: —Cʉ̃ʉ̃rẽ ñaapeóya, netõã́rõ jĩĩgʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús cʉ̃ʉ̃rẽ aperopʉ́, basocá ĩñahẽrõpʉ néewayigʉ. Toopʉ́ Jesús cʉ̃ʉ̃ye wãmosṹãrĩmena tʉohégʉye cãmopérire súusõnecoyigʉ. Ʉsecó eopéo, cʉ̃ʉ̃ya ñemerõrẽ padeñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ʉ̃mʉã́sepʉ ĩñamʉõco, yeerisã, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Efata, jĩĩyigʉ. “Tusuya” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cʉ̃ʉ̃ jĩĩrĩrã, pʉacãmopéropʉ tʉo, cʉ̃ʉ̃ya ñemerõmena máata ãñurõ wedesemasĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús basocáre jĩĩyigʉ: —Ãpẽrãrẽ́ wederijãña, jĩĩmiyigʉ. Cʉ̃́ãrẽ “wederijãña” jĩĩpacari, nemorṍ wedebatejãyira. ");
INSERT INTO tue_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bayiró ĩñamanijõãrã, jĩĩyira: —Niipetirere ãñurõ tiii. Basocá tʉohéracãrẽ tʉorí tiii. Wedeseheracãrẽ wedeseri tiii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Teebʉrecorire paʉ basocá neãrĩ, cʉ̃́ã yaaré petirí ĩñagʉ̃, Jesús cʉ̃ʉ̃ bueráre sʉocó, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Yʉʉ ãniãrẽ bóaneõ ĩñajõãga. Cʉ̃́ã yʉʉmena niirṍ itiábʉreco netõã. Teero tiirá, cʉ̃́ã yaaré petinójõãya. ");
INSERT INTO tue_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cʉ̃́ãye wiseripʉ yʉʉ pʉtʉawadutiri, jʉabóara, maapʉ tʉomasĩ́re petijṍãbocua. Ãpẽrã́ yoaropʉ atiarira niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Marĩ ãno basocá manirṍpʉre ¿deero tii ãniã paʉre yaaré bʉa, ecabógari? jĩĩyira cʉ̃ʉ̃ buerápeja. ");
INSERT INTO tue_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Noquẽpa pã cʉoi? jĩĩyigʉ. —Sietepa cʉoa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús basocáre yepapʉ duidutiyigʉ. Pã sietepare née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, pʉatásã, cʉ̃ʉ̃ bueráre batodutigʉ ticoyigʉ. Cʉ̃́ã basocápʉre batoyira. ");
INSERT INTO tue_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wai metãrãgã pʉarã́gã cʉoyíra. Jesús cʉ̃́ãcãrẽ Cõãmacʉ̃rẽ ʉsenire ticotoa, teerora batodutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Niipetira yaa, yapijõãyira. Yaatoaari siro, siete piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpóyira. ");
INSERT INTO tue_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Teeré yaarira cuatro mil watoa niiyira. Too síro cʉ̃́ãrẽ cʉ̃́ãye wiseripʉ pʉtʉawadutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Máata Jesús cʉ̃ʉ̃ buerámena dooríwʉpʉ mʉãsã, Dalmanuta macã wesapʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Cʉ̃́ã jeari siro, fariseo basoca Jesuména cãmerĩ́tutira jeayira. “¿Niirṍrã cʉ̃ʉ̃ Cõãmacʉ̃ ticodiocorigʉ niiĩ?” jĩĩrã, cʉ̃ʉ̃rẽ Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñodutimiyira. “Cʉ̃ʉ̃ teeré tiimasĩ́riqui”, jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesupé bayiró bóaneõremena jĩĩyigʉ: —¿Deero tiirá atitó macãrã tiiẽ́ñodutigari? Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ãrẽjã tiiẽ́ñoridojãgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cʉ̃́ãrẽ cõãwagʉ, dooríwʉpʉ mʉãsãyigʉ sũcã. Apeniñapʉ́ tĩãjõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Apeniñapʉ́ tĩãwara, Jesús buerá cʉ̃́ã yaaadarere acabójãyira. Pã sicagára cʉoyíra. ");
INSERT INTO tue_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús cʉ̃́ãrẽ wedemiyigʉ: —Fariseo basocaye pã púuri tiirére, Herodeye pã púuri tiirére tʉomasĩ́rõ booa, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃ jĩĩãriguere tʉomasĩ́hẽrã: —Pã marĩ cʉohéri, teero jĩĩqui, jĩĩmiyira cʉ̃́ã basiro. ");
INSERT INTO tue_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús cʉ̃́ã teero jĩĩãriguere masĩjãyigʉ. Teero tiigʉ́, jĩĩyigʉ: —¿Deero tiirá mʉ́ã “pã maniã” jĩĩ cãmerĩ́ wedesei? ¿Mʉ́ã tʉomasĩ́rii ména? ¿Mʉ́ãrẽ wãcũré manidójãĩ? ");
INSERT INTO tue_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Capeari cʉorá niipacara, ĩñaria mʉ́ã. Cãmopéri cʉorá niipacara, tʉoría. Yʉʉ tiirére wãcũria mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tiibʉrecopʉ cinco mil ʉ̃mʉãrẽ sicamoquẽñepa pãmena ecawʉ́. ¿Noquẽ piseri cʉ̃́ã yaadʉaariguere seesã́ dadodʉpóri? jĩĩyigʉ. —Doce piseri, jĩĩyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Apeyecã́rẽ sietepa pãmena cuatro mil basocáre ecawʉ́. Tiibʉrecore ¿noquẽ piseri seesã́ dadodʉpóri? jĩĩyigʉ. —Siete piseri, jĩĩyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Too docare teeré masĩpacara, ¿tʉomasĩ́rii ména? jĩĩyigʉ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida macãpʉ tĩãjeayira. Toopʉ́ Jesús pʉto sĩcʉ̃ ĩñahẽgʉ̃rẽ néejeayira. Cʉ̃́ã Jesuré sãĩyíra: —Ãnirẽ́ ñaapeóya, netõã́rõ jĩĩgʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Teero tiigʉ́, Jesús ĩñahẽgʉ̃ya wãmopʉ ñee, macã wesapʉ néewayigʉ. Cʉ̃ʉ̃ capearipʉ ʉsecó eopéo, ñaapeó, sãĩñáyigʉ: —¿Mʉʉrẽ apeyenó baumíĩto? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cʉ̃ʉ̃pe ĩñapõnʉcãjea, jĩĩyigʉ: —Basocáre ĩñaã, ĩñagʉ̃peja. Cʉ̃́ã yʉʉ ĩñarĩ, wáanetõrã yucʉbiro bauúya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús cʉ̃ʉ̃ye capearipʉ ñaapeónemoyigʉ. Teero tiiári siropʉ, cʉ̃ʉ̃ ĩñarĩ, cʉ̃ʉ̃ capeari quẽnojeá, ãñurõ bauyíro sáa. Niipetirere ãñurõ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesupé jĩĩyigʉ cʉ̃ʉ̃rẽ: —Mʉʉya wiipʉ diamacʉ̃́rã coecópʉtʉaya. Macãpʉre pʉtʉawarijãña. Teero biiri macã macãrãrẽ wederijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Too niiãrira Jesús, cʉ̃ʉ̃ buerá Cesarea Filipoya macã pʉto niiré macãrĩpʉ wáayira. Cʉ̃́ã too wáaropʉ cʉ̃ʉ̃ bueráre sãĩñáyigʉ: —¿Basocá “¿noã niiĩ cʉ̃ʉ̃?” jĩĩĩ yʉʉre? ");
INSERT INTO tue_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Cʉ̃́ãpe jĩĩyira: —Sĩquẽrã mʉʉrẽ “Juan basocáre wãmeõtiri basocʉ niiqui” jĩĩĩya. Ãpẽrã́ “Elías niiqui” jĩĩĩya. Ãpẽrã́ “profetas menamacʉ̃ niigʉ̃ niiqui” jĩĩĩya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Mʉ́ãte “¿noã niiĩ?” jĩĩĩ yʉʉre? jĩĩyigʉ. Pedro yʉʉyigʉ: —Mʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Teeré ãpẽrãrẽ́ wederijãña, jĩĩyigʉ cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cʉ̃́ãrẽ buenʉcãyigʉ sũcã. —Yʉʉ niipetira sõwʉ̃rẽ bayiró ñañarõ netõrṍ niirõ tiiádacu. Bʉtoá dutirá, paiaré dutirá, Moisés jóarigue buerá yʉʉre booríadacua. Sĩãdutíadacua. Cʉ̃́ã teero tiipacári, itiábʉreco siro masãgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cʉ̃́ãrẽ tʉomasĩ́rõrã wedemiyigʉ. Teeré tʉogʉ́, Pedro Jesuré ãpẽrã́ tʉohéropʉ néewa, wedenʉcãyigʉ: —Teeré jĩĩrijãña, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús cãmenʉcã́, cʉ̃ʉ̃ bueráre ĩña, Pedrore jĩĩyigʉ: —Satanás tiiróbiro wedesegʉ tiia mʉʉjã. “¡Satanás, wáajõãgʉa; yʉʉ pʉtore niirijãña!” jĩĩã. Pedro, mʉʉ masĩria Cõãmacʉ̃ wãcũrére; basocá wãcũrõbiro wãcũã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Basocáre neãduti, cʉ̃́ãrẽ, cʉ̃ʉ̃ bueráre wedeyigʉ: —Sĩcʉ̃ yʉʉre padeó, nʉnʉdʉgágʉno cʉ̃ʉ̃ booró tiidʉgárenorẽ tiidújããrõ. Basocá cʉ̃ʉ̃rẽ ñañarõ jĩĩpacari, yʉʉre tʉonʉnʉ́searo. Teeré tiigʉ́, curusare apagʉ́ tiiróbiro niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ãpĩ sĩãrére cuigʉno yʉʉre “masĩria” jĩĩgʉ̃́ pecamepʉ wáagʉdaqui. Ãpĩpé yʉʉre “masĩã” jĩĩ, yée quetire wedegʉ́pe teewapamena cʉ̃ʉ̃rẽ sĩãrĩ́, yʉʉmena catirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sĩcʉ̃ atibʉ́reco maquẽ niipetirere wapatápacʉ, cʉ̃ʉ̃ yeeripũnarẽ tiidióri, cʉ̃ʉ̃ cʉoré dee tiiádare niiricu. ");
INSERT INTO tue_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Cʉ̃ʉ̃ catiré petihére ñeenómena wapatíriqui. ");
INSERT INTO tue_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Atiditá macãrã ñañaré tiirá yʉʉre padeohéra niiĩya. Sĩcʉ̃ cʉ̃́ã watoapʉ niigʉ̃, yʉʉre “padeóa” jĩĩ, yée buerére “nʉnʉã” jĩĩgʉ̃́no boboríjããrõ. Too síro yʉʉ niipetira sõwʉ̃ yʉʉ Pacʉ asibatéremena, ángeleamena pʉtʉaatigʉdacu. Pʉtʉaatigʉ, yʉʉre bobosã́ririgʉre yʉʉcã cʉ̃ʉ̃rẽ bobosã́ricu; yʉʉre “masĩria” jĩĩrigʉre yʉʉcã “cʉ̃ʉ̃rẽ masĩria” jĩĩgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩquẽrã ãnopʉ́ niirã́ cʉ̃́ã diaadari sʉguero, Cõãmacʉ̃ dutiré cʉ̃́ãpʉre niiãdare tutuaremena atiri ĩñaãdacua, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis bʉrecori siro Jesús ʉ̃tãgʉ̃́ ʉ̃mʉã́rigʉpʉ mʉãwayigʉ. Tiigʉpʉ́ wáagʉ, Pedro, Santiago, Juan cʉ̃́ã dícʉre néewayigʉ. Toopʉ́ cʉ̃́ã ĩñarĩ, Jesús cʉ̃ʉ̃ baurécʉtirere wasojṍãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cʉ̃ʉ̃ye suti bayiró butiré capemóre wáayiro. Ãnopʉ́re teero butiré tiiróbiro basocá suti coseríya. ");
INSERT INTO tue_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Teero wáari, Elías, Moisémena bauánʉcã, Jesuména wedesera tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Cʉ̃ʉ̃ buerá ʉcʉánetõjõãyira. Pedro ãñurõ wãcũripacʉ, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, marĩ ãnopʉ́ niirĩ, ãñunetõjõãã. Itiáwiigã tiicó; sicawiígã mʉʉya wii, apewiígã Moiséya wii, apewiígã Elíaya wii tiicó, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Õme diiáti, cʉ̃́ãrẽ tuubiátocojãyiro. Õme watoapʉ sĩcʉ̃ wedeseri tʉoyíra: —Ãni yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́ niiĩ. Cʉ̃ʉ̃rẽ tʉoyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Máata cʉ̃́ã cãmenʉcã́ ĩñarĩ, ãpẽrã́ cʉ̃́ãmena niiãrira maniyíra; Jesús dícʉre ĩñayira. ");
INSERT INTO tue_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cʉ̃́ã ʉ̃tãgʉ̃pʉ́ niiãrira diiátiri, Jesús jĩĩyigʉ: —Mʉ́ã ĩñaãriguere wederijãwa ména; tée yʉʉ niipetira sõwʉ̃ dia masãri siropʉ wedewa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ãpẽrãrẽ́ wederiyira. Cʉ̃́ã basiro cãmerĩ́ sãĩñáyira: —¿Deero jĩĩdʉgaro tiigári cʉ̃ʉ̃ diari siropʉ masãré? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jesuré sãĩñáyira: —¿Deero tiirá Moisés jóarigue buerá “Cõãmacʉ̃ beserigʉ atiadari sʉguero, Elías atisʉguegʉdaqui” jĩĩ buei? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Elías atisʉguere, niipetire quẽnosʉguéadare diamacʉ̃́rã niiã. Yʉʉ niipetira sõwʉ̃rẽ profetas jóariguecã diamacʉ̃́rã niiã. Biiro jóare niiã: “Niipetira sõwʉ̃ ñañarõ netõgʉ̃́daqui; cʉ̃ʉ̃rẽ booríadacua”, jĩĩã. ");
INSERT INTO tue_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yʉʉre tʉoyá: Elías jeatoawi. Cʉ̃ʉ̃rẽ profetas jĩĩrirobirora diamacʉ̃́ wáariro niiwʉ̃. Basocá cʉ̃ʉ̃rẽ cʉ̃́ã booró tiidʉgáriguere tiitóarira niiwã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús buerá niirṍpʉ diijeára, paʉ basocá niirĩ ĩñayira. Moisés jóarigue buerá, Jesús buerámena bayiró cãmerĩ́tutiyira. ");
INSERT INTO tue_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús jeari ĩñarã, bayiró ĩñamanijõãyira. Máata cʉ̃ʉ̃ pʉtopʉ cʉtʉáti, cʉ̃ʉ̃rẽ ãñudutiyira. Cʉ̃ʉ̃ cʉ̃́ãrẽ sãĩñáyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—¿Mʉ́ã ñeenórẽ cãmerĩ́tutira tiiárĩ cʉ̃́ãmena? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sĩcʉ̃ paʉ watoapʉ niigʉ̃́ yʉʉyigʉ: —Ʉ̃sãrẽ buegʉ́, yʉʉ macʉ̃ wãtĩ cʉogʉ́re mʉʉrẽ néeatiawʉ̃. Wãtĩ cʉ̃ʉ̃rẽ wedeseheri tiii. ");
INSERT INTO tue_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cʉ̃ʉ̃ wáaro ñee, cõãcũĩ. Cʉ̃ʉ̃pe sobotu, bacadiyó, bʉʉcócũmuãĩ. Yʉʉ mʉʉ bueráre “cõãwionecobosaya” jĩĩmiãwʉ̃. Cõãmasĩriawã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã yʉʉre padeorídojãã. Yʉʉ mʉ́ãmena yoari niirucujãrĩcãrẽ, padeoríbocu. ¿Nocõrõ yoari mʉ́ãmena põõtẽ́õgʉ̃dari yʉʉ? Wĩmagʉ̃rẽ néeatiya yʉʉ pʉto, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cʉ̃ʉ̃ pʉtopʉ néejeayira. Wãtĩ Jesuré ĩñagʉ̃, máata wĩmagʉ̃rẽ ñaacũmurĩ tiiyígʉ. Cʉ̃ʉ̃pe ñaacũmu, tũnumecʉ̃́, sobotuyigʉ. Jesús cʉ̃ʉ̃ pacʉre sãĩñáyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Deero biiripʉ ate wáanʉcãrĩ? jĩĩyigʉ. —Wĩmagʉ̃pʉra, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pee peti wãtĩ cʉ̃ʉ̃rẽ sĩãdʉgágʉ, pecamepʉ ñaacũmu, díapʉ ñaañuãrucuri tiii. Mʉʉ tiiápumasĩgʉ̃, ʉ̃sãrẽ bóaneõ ĩñagʉ̃, tiiápuya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¿Deero tiigʉ́ “mʉʉ tiiápumasĩgʉ̃” jĩĩĩ? Padeoráre niipetire tiiápumasĩnoã, jĩĩyigʉ Jesupéja. ");
INSERT INTO tue_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Máata cʉ̃ʉ̃ pacʉpe bayiró bʉsʉrómena jĩĩyigʉ: —Padeóa. Nemorṍ yʉʉre padeorí tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús basocá paʉ cʉ̃́ã pʉtopʉ cʉtʉátiri ĩñagʉ̃, wãtĩrẽ tuti, jĩĩyigʉ: —Wãtĩ wedeseheri, tʉohéri tiigʉ́, yʉʉ mʉʉrẽ witiwadutia. Mʉʉ wĩmagʉ̃pʉre niigʉ̃́, witiwaya; cʉ̃ʉ̃pʉre sããwanemorijãña sáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wãtĩ acaribí, wĩmagʉ̃rẽ tũnumecʉ̃́rĩ tii, witiyigʉ. Diaarigʉ tiiróbiro pʉtʉáyigʉ. Ãpẽrã́ cʉ̃ʉ̃rẽ “diajõãĩ” jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús cʉ̃ʉ̃rẽ wãmopʉ ñee, wéemʉõnʉcõrĩ, wʉ̃mʉnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Too síro Jesús wiipʉ́ sããwari, cʉ̃ʉ̃ buerá ãpẽrã́ tʉohéropʉ cʉ̃ʉ̃rẽ sãĩñáyira: —¿Deero tiirá ʉ̃sã wãtĩrẽ cõãwionecomasĩriayiri? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ãninó wãtĩrẽ cõãwionecodʉgara, Cõãmacʉ̃rẽ sãĩ, betirémena dícʉ cõãrõ booa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Too niiãrira Galilea ditapʉ netõwáyira. Cʉ̃́ã too wáariguere ãpẽrãrẽ́ masĩrĩ booríyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Cʉ̃ʉ̃ buerá dícʉre buegʉ tiiyígʉ. —Yʉʉ niipetira sõwʉ̃ ãpẽrãpʉ́re ticonogʉ̃dacu. Yʉʉre sĩãã́dacua. Cʉ̃́ã teero tiipacári, itiábʉreco siro masãgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cʉ̃́ãpe cʉ̃ʉ̃ jĩĩãriguere tʉomasĩ́riyira. Tʉomasĩ́ripacara, cuira, sãĩñáriyira. ");
INSERT INTO tue_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaumpʉ jeayira. Wiipʉ́ cʉ̃́ã niirĩ, Jesús cʉ̃́ãrẽ sãĩñáyigʉ: —Mʉ́ã maa atira, ¿ñeenórẽ wedesera tiiárĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Cʉ̃́ãpe yʉʉriyira. Maapʉ atira, “¿nii marĩ watoare nemorṍ ʉpʉtí macʉ̃ niiĩ?” jĩĩ wedeseatiyira. ");
INSERT INTO tue_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Teero tiigʉ́, Jesús jeanuã, cʉ̃ʉ̃ buerá docere neãduti, jĩĩyigʉ: —Sĩcʉ̃ ʉpʉtí macʉ̃ niidʉgagʉ, niipetirare padecotegʉ tiiróbiro niirõ booa. Teero biiri niipetirare tiiápuro booa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sĩcʉ̃ wĩmagʉ̃rẽ cʉ̃́ã decopʉ nʉcõ, cʉ̃ʉ̃rẽ néeapa, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Sĩcʉ̃ ãni wĩmagʉ̃biro biigʉ́re ĩña, “yʉʉ Jesuré maĩã; teero tiigʉ́ cʉ̃ʉ̃rẽ boca maĩgʉ̃́da” jĩĩ wãcũboqui. Cʉ̃ʉ̃ teero wãcũgʉ̃, cʉ̃ʉ̃rẽ maĩgʉ̃́, yʉʉcãrẽ maĩgʉ̃́ tiii. Yʉʉre boca maĩgʉ̃́, yʉʉ dícʉre maĩgʉ̃́ mee tiii; yʉʉre ticodiocorigʉcãrẽ teerora maĩgʉ̃́ tiii, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan Jesuré wedeyigʉ: —Ʉ̃sãrẽ buegʉ́, sĩcʉ̃ mʉʉ wãmemena wãtĩãrẽ cõãwionecori ĩñaãwʉ̃. Cʉ̃ʉ̃ marĩ menamacʉ̃ mee niiãwĩ. Teero tiirá, cʉ̃ʉ̃rẽ cãmotáawʉ̃, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesupé cʉ̃ʉ̃rẽ yʉʉyigʉ: —Cãmotárijãña. Sĩcʉ̃ yʉʉ tutuaremena teenórẽ tiiẽ́ñonetõnegʉ̃, too síro yʉʉre ñañarõ wedesemasĩriqui. ");
INSERT INTO tue_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Marĩrẽ cãmotáhegʉ marĩrẽ tiiápugʉ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ mʉ́ãrẽ “Cõãmacʉ̃ beserigʉ nʉnʉrã́ niiĩya” jĩĩ, oco tĩ́ãgʉ̃, wapatáre bʉagʉ́daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús jĩĩnemoyigʉ: —Yʉʉre padeorágãrẽ ñañaré tiidutígʉnorẽ ñañanemorõ wáaadacu. Cʉ̃ʉ̃rẽ ʉ̃tãgã pairígamena cʉ̃ʉ̃ wãmʉãpʉ siatúyo, día pairímaapʉ cõãñocori, nemorṍ ãñubocu. ");
INSERT INTO tue_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mʉʉya wãmo mʉʉrẽ ñañarére tiirí tiibócu. Teero wáari, páatacõãjãña. Sicawãmomena catiré petihéropʉ jeari, ãñujãã. Pʉawãmómena pecamepʉ wáaripeja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mʉʉya dʉpo mʉʉrẽ ñañarére tiirí tiibócu. Teero wáari, páatacõãjãña. Sicadʉpomena catiré petihéropʉ jeari, ãñujãã. Pʉadʉpómena pecamepʉ mʉʉ cõãdioconorĩpeja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mʉʉya capea ĩñaré mʉʉrẽ ñañarére tiirí tiibócu. Teero wáari, tiigaré odewecõãjãña. Sicacapeamena Cõãmacʉ̃ Õpʉ̃ niirṍpʉ jeari, ãñujãã. Pʉacapéamena pecamepʉ mʉʉ cõãdioconorĩpeja, ñañanetõjõãcu. ");
INSERT INTO tue_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pecamepʉ becoa diariya. Pecamecã yatiria. ");
INSERT INTO tue_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Pecame móã tiiróbiro niicu: Ñañaré maniré wáari tiicú. Teero biiri bóari tiirícu. ");
INSERT INTO tue_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Móã ocare yaari, ãñuniã. Tee móã ocaheri, nemo ocari tiimasĩ́ña manicú. Mʉ́ã móã ocare tiiróbiro niiña. Cãmerĩ́quẽre manirṍ ãñurõ niirecʉtiya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Too niiãrigʉ Judea ditapʉ wáa, día Jordán apeniñapʉ́ jeayigʉ. Toopʉ́re basocá neãyira sũcã. Cʉ̃ʉ̃ tiirucúrobirora cʉ̃́ãrẽ bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseo basoca cʉ̃ʉ̃ pʉtopʉ jeayira. Cʉ̃ʉ̃rẽ ñañarõ jĩĩré bʉadʉgára, sãĩñáyira: —¿Sĩcʉ̃ cʉ̃ʉ̃ nʉmorẽ́ cõãjãmasĩgari? ¿Marĩrẽ dutiré teerora jĩĩĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesupé sãĩñáyigʉ: —¿Moisés deero dutiyiri? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cʉ̃́ãpe yʉʉyira: —Moisés sĩcʉ̃ cʉ̃ʉ̃ nʉmorẽ́ “atewapá mʉʉrẽ cõãã” jĩĩrípũrẽ jóatoa, cõãmasĩnoã, jĩĩ jóarigʉ niiwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús jĩĩyigʉ: —Mʉ́ã ñecʉ̃sʉ̃mʉã Cõãmacʉ̃ dutirére tiidʉgáheri ĩñagʉ̃, Moisés tee dutirére cṹũrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cõãmacʉ̃ niipetire cʉ̃ʉ̃ sicato tiinʉcã́ritopʉre ʉ̃mʉ, numiṍ tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Teero tiigʉ́, ʉ̃mʉ cʉ̃ʉ̃ pacʉre, cʉ̃ʉ̃ pacore merẽã witi, cʉ̃ʉ̃ nʉmoména niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cʉ̃́ã pʉarã́ sicaõpʉ̃ʉ̃ tiiróbiro pʉtʉáadacua”, jĩĩrigʉ niiwĩ Cõãmacʉ̃. Teero tiirá, pʉarã́ niiriya. Sĩcʉ̃ tiiróbiro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cõãmacʉ̃ cʉ̃́ãrẽ sicaõpʉ̃ʉ̃rã tiiróbiro niirĩ tiirí siro, ãpĩ cʉ̃́ãrẽ cãmerĩ́ cõãrĩ tiiríjãrõ booa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wiipʉ́ coerá, Jesús buerá cʉ̃ʉ̃rẽ sãĩñáyira sũcã tee maquẽrẽ. ");
INSERT INTO tue_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Cʉ̃́ãrẽ yʉʉyigʉ: —Cʉ̃ʉ̃ nʉmorẽ́ cõãgʉ̃, apegoré nʉmocʉtigʉno cʉ̃ʉ̃ nʉmo niisʉguerigomena ñañarõ tiigʉ́ tiiquí. ");
INSERT INTO tue_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Numiṍcã coo manʉrẽ cõã, ãpĩména manʉcʉtigo, coo manʉ niisʉguerigʉmena ñañarõ tiigó tiicó. Tee Cõãmacʉ̃rẽ netõnʉcã́re niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wĩmarãrẽ Jesús pʉto néewayira ñaapeódutira. Cʉ̃́ãrẽ néewarare cʉ̃ʉ̃ buerá tutimiyira. ");
INSERT INTO tue_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cʉ̃́ã teero tiirí ĩñagʉ̃, Jesús cʉ̃́ãmena cúayigʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Wĩmarã yʉʉ pʉto atiaro. Cãmotárijãña. Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉserano ãniãgã tiiróbiro wãcũrã́ niiĩya. ");
INSERT INTO tue_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ãniãgã tiiróbiro Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉse tiihéranorẽ cʉ̃ʉ̃ dutiré cʉ̃́ãpʉre jeaboarigue cʉ̃́ãrẽ jearicu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Teeré jĩĩtoa, wĩmarãrẽ néeapa, cʉ̃́ãrẽ ñaapeó, Cõãmacʉ̃rẽ: —Ãniãrẽ ãñurõ tiiyá, jĩĩ sãĩbosáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús wáagʉdʉ tiirí, sĩcʉ̃ cʉtʉjeáyigʉ. Cʉ̃ʉ̃ pʉto ñicãcoberimena jeacũmu, sãĩñáyigʉ: —Basocáre buegʉ́ ãñugʉ̃́, ¿yʉʉ ñeenó tiigʉ́dari, catiré petihére bʉadʉgágʉ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Mʉʉ yʉʉre “ãñugʉ̃́” jĩĩã. Cõãmacʉ̃ sĩcʉ̃rã ãñugʉ̃́ niiĩ. ");
INSERT INTO tue_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mʉʉ Cõãmacʉ̃ dutiré cṹũriguere masĩcu. “Basocáre sĩãríjãña. Ãpĩ nʉmorẽ ñeeaperijãña. Yaaríjãña. Ãpẽrãrẽ́ jĩĩditoremena wedesãrijãña. Ãpẽrãyére ẽmarijãña. Mʉʉ pacʉ, mʉʉ pacore padeoyá”, jĩĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Ʉ̃sãrẽ buegʉ́, yʉʉ wĩmagʉ̃pʉra tee niipetirere tiimʉ́ãatimiwʉ̃, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús cʉ̃ʉ̃rẽ maĩrémena ĩña, jĩĩyigʉ: —Mʉʉrẽ sicawãme dʉsaa. Mʉʉ cʉorére dúapetijãgʉ̃ wáaya. Tee dúa wapatáariguere bóaneõrãrẽ batoya. Teero tiigʉ́, Cõãmacʉ̃ pʉtopʉre pee ãñuré bʉagʉ́dacu. Túajea, ati, yʉʉre nʉnʉwá, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, tʉsarijõãyigʉ. Pee apeyé cʉojĩ́gʉ̃, wãcũpati, pʉtʉajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús cʉ̃ʉ̃ pʉto ĩñabate, cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgari, wisió niicu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃ jĩĩãriguere tʉorá, tʉomaníjõãyira. Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Yáa wedera, Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgari, wisió niicu. ");
INSERT INTO tue_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wáicʉ camello wãmecʉtigʉ awigá copegãpʉ sããcãmewitimasĩriqui. Toorá nemocú, pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgaripereja, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Teeré tʉorá, bayiró tʉomaníjõãrã, cãmerĩ́ sãĩñáyira: —Too docare ¿noãpé netõnénoãdari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús cʉ̃́ãrẽ ĩñagʉ̃rã, jĩĩyigʉ: —Basocá cʉ̃́ã basiro netõnémasĩriya. Cõãmacʉ̃pereja wisióre manidójãã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedrope jĩĩnʉcãyigʉ: —Tʉoyá ména. Ʉ̃sãpe niipetire ʉ̃sã cʉoríguere cṹũjõãatiwʉ, mʉʉmena nʉnʉã́da jĩĩrã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús yʉʉyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ yʉʉre maĩgʉ̃́ cʉ̃ʉ̃ya wii, cʉ̃ʉ̃ baira, cʉ̃ʉ̃ pacʉsʉ̃mʉã, cʉ̃ʉ̃ põna, cʉ̃ʉ̃ye ditare cṹũjõã, “basocáre netõnére quetire wedegʉ wáagʉda” jĩĩgʉ̃́nope ");
INSERT INTO tue_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cʉ̃ʉ̃ cṹũwarigue nemorṍ bʉagʉ́daqui. Atibʉ́recopʉre nemorṍ wiserí, cʉ̃ʉ̃ya wedera, pacosã́numiã, põna, dita bʉagʉ́daqui. Ãpẽrã́ cʉ̃ʉ̃rẽ ñañarõ tiipacári, teeré bʉagʉ́daqui. Too síropʉcãrẽ Cõãmacʉ̃mena catiré petihére bʉagʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mecʉ̃tígãrẽ paʉ ʉpʉtí macãrã too síropʉre bʉ́ri niirã́ niiãdacua. Bʉ́ri niirã́ too síropʉre ʉpʉtí macãrã niiãdacua, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cʉ̃́ã Jerusalénpʉ mʉãwari, Jesús cʉ̃́ãrẽ sʉgueyigʉ. Cʉ̃ʉ̃ buerá ĩñamanijõãyira. Basocá cʉ̃́ã siro nʉnʉrã́cã cuiyira. Jesús cʉ̃ʉ̃ buerá docere sʉowá, cʉ̃ʉ̃rẽ wáaadarere wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Mʉ́ã ĩñaã: Marĩ Jerusalénpʉ wáara tiia. Toopʉ́ yʉʉ niipetira sõwʉ̃ niipacari, paiaré dutirá, Moisés jóarigue buerápʉre ticoadacua. Cʉ̃́ã sĩãdutíadacua yʉʉre. Cʉ̃́ãrã judíoa niihẽrãpʉre ticonetõneãdacua. ");
INSERT INTO tue_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yʉʉre buijã́, ʉsecó eobatétu, tãna, sĩãã́dacua. Itiábʉreco siro masãgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago, Juan Zebedeo põna Jesús pʉtopʉ jea, cʉ̃ʉ̃rẽ sãĩyíra: —Ʉ̃sãrẽ buegʉ́, ʉ̃sã sãĩã́darere mʉʉ ticori boogá, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ñeenó yʉʉ tiirí boogári? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Mʉʉ õpʉ̃ sããgʉ̃, mʉʉ duirípĩrõ pʉtogãpʉ dʉpowa ʉ̃sãrẽ. Sĩcʉ̃ diamacʉ̃́pe, ãpĩrẽ́ acuniñape dʉpowa, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉ õpʉ̃ sãããdari sʉguero wáaadarere mʉ́ã masĩria. ¿Yʉʉ ñañarõ netõã́darobirora mʉ́ãcã ñañarõ netõrã́ nʉcãbógari? ¿Yʉʉre cʉ̃́ã sĩãã́darobirora mʉ́ãcã cʉ̃́ã sĩãrĩ́ nʉcãbógari? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ʉ̃́jʉ̃, ñañarõ netõ, diamasĩã, jĩĩyira. Jesús jĩĩyigʉ: —Mʉ́ãcã yʉʉ tiiróbiro posa, diaadacu. ");
INSERT INTO tue_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Teeré wedemasĩpacʉ, “sĩcʉ̃ diamacʉ̃́pe, ãpĩ acuniñape dʉpogʉda” jĩĩmasĩriga. Tee yʉʉ dutiré niiria. Cõãmacʉ̃ toopʉ́ duiadarare besetoawi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cʉ̃́ã menamacãrã pʉamóquẽñerã Santiago, Juan sãĩrĩ́ tʉorá, cúayira. ");
INSERT INTO tue_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús cʉ̃́ãrẽ sʉocó, jĩĩyigʉ: —Mʉ́ã masĩã: Niipetire dita macãrãrẽ dutirá Cõãmacʉ̃rẽ masĩhẽrã cʉ̃́ã booró dutiãmajãya. Cʉ̃́ã doca macãrãcã acaribíremena dutiiya, cʉ̃́ã dutirére tiipetídutira. ");
INSERT INTO tue_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉ́ãpeja cʉ̃́ã tiiróbiro tiiríjãña. Merẽã tiirécʉtiya. Mʉ́ã ʉpʉtí macãrã niidʉgara, ãpẽrãrẽ́ tiiápuri basoca niiña. ");
INSERT INTO tue_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sĩcʉ̃ ãpẽrã́ nemorṍ niidʉgagʉno niipetirare padecotegʉ tiiróbiro niirõ booa. ");
INSERT INTO tue_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yʉʉ niipetira sõwʉ̃ niipacʉ, ãpẽrã́ yʉʉre tiiápuaro jĩĩgʉ̃ mee atiwʉ. Yʉʉpe basocáre tiiápugʉ atigʉ tiiwʉ́. Teero biiri paʉ basocá ñañaré tiiré wapa diabosa netõnégʉ̃ atigʉ tiiwʉ́ jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cʉ̃́ã Jerusalénpʉ maawára, Jericópʉ jeasʉgueyira. Tiimacãpʉ Jesús cʉ̃ʉ̃ buerámena netõwári, paʉ basocá cʉ̃ʉ̃rẽ nʉnʉyíra. Sĩcʉ̃ capeari baunóhẽgʉ̃ maa wesapʉ niyeru sãĩduíyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Bartimeo, Timeo macʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Jesús Nazaret macã macʉ̃ atii” jĩĩrĩ tʉogʉ́, Bartimeo bayiró bʉsʉrómena jĩĩnʉcãyigʉ: —¡Jesús, David pãrãmi niinʉnʉsegʉ, yʉʉre bóaneõña! jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Paʉ cʉ̃ʉ̃rẽ: —Nocõrõrã ditamaníjõãña, jĩĩ tutimiyira. Cʉ̃ʉ̃pe jĩĩnemosãjãyigʉ: —¡David pãrãmi niinʉnʉsegʉ, yʉʉre bóaneõña! jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesupéja pʉtʉánʉcã: —Atiaro, jĩĩyigʉ. Cʉ̃́ã cʉ̃ʉ̃rẽ jĩĩyira: —Ãñuãdacu. Wʉ̃mʉnʉcãcoya. Mʉʉrẽ atidutii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Teeré tʉogʉ́, sutiró sotoá macãrõrẽ tuuwécojã, bupucʉtʉ́a, Jesús pʉto wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿Mʉʉrẽ deero tiirí boogári? jĩĩyigʉ Jesús. —Basocáre buegʉ́, yʉʉre ĩñarĩ tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉ padeojĩ́gʉ̃, netõnénoãrigʉpʉ pʉtʉáa. Ãñurõ wáaya, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩrĩrã, ĩñajõãyigʉ sáa. Ĩña, maapʉ Jesuré nʉnʉwáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús cʉ̃ʉ̃ buerámena Jerusalénpʉ jeaadaro péero dʉsayíro. Betfagé, Betania macãrĩpʉ jeayira. Teemacãrĩ Ʉ̃tãgʉ̃́ Olivo pʉto niiã. Toopʉ́ cʉ̃ʉ̃ buerá pʉarã́rẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Iimacã marĩ díamacʉ̃ niirí macãpʉ wáaya. Toopʉ́ jeara, máata sĩcʉ̃ burro wĩmagʉ̃ siatúnʉcõãrigʉre bʉajeáadacu. Cʉ̃ʉ̃ pesaya manigʉ̃́ niiqui ména. Cʉ̃ʉ̃rẽ jõã, néeatiya. ");
INSERT INTO tue_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mʉ́ãrẽ “¿deero tiirá cʉ̃ʉ̃rẽ jõãĩ?” jĩĩrĩ, “marĩ Õpʉ̃ booáwĩ; máata wiyajã́gʉ̃daqui” jĩĩña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Cʉ̃́ã wáa, maapʉ siatúnʉcõãrigʉre bʉajeáyira. Wii díamacʉ̃pʉ niiyigʉ. Cʉ̃ʉ̃rẽ jõãyíra. ");
INSERT INTO tue_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Toopʉ́ nucũrã́: —¿Deero tiirá cʉ̃ʉ̃rẽ jõãĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Cʉ̃́ãpe Jesús dutiarirobirora yʉʉyira. —Néewaya, jĩĩyira cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesús pʉto néewayira. Burro sotoapʉ cʉ̃́ãye suti sotoá maquẽrẽ tuuwépeoyira. Jesús cʉ̃ʉ̃ sotoapʉ mʉãpeayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cʉ̃ʉ̃rẽ padeorá, paʉ cʉ̃ʉ̃ netõwáadarimapʉ cʉ̃́ãye suti sotoá maquẽrẽ sẽ́õcũyira. Ãpẽrã́ yucʉ dʉpʉri pṹũrĩcʉtire cʉ̃́ã páata néeatiariguere cṹũsʉgueyira. ");
INSERT INTO tue_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cʉ̃ʉ̃ sʉguero wáara, cʉ̃ʉ̃ siro nʉnʉrã́ bayiró bʉsʉrómena jĩĩyira: —¡Marĩ Õpʉ̃rẽ ʉsenire ticoada! ¡Ãni Cõãmacʉ̃ ticodiocorigʉ niiĩ! ¡Cʉ̃ʉ̃rẽ ãñurõ tiiáro! ");
INSERT INTO tue_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cʉ̃ʉ̃ õpʉ̃ sããrĩ, ãñurõ wáaaro! ¡Marĩ ñecʉ̃ David õpʉ̃ niiriro tiiróbiro ãñurõ wáaaro! ¡Niipetira ʉ̃mʉã́se macãrã cʉ̃ʉ̃rẽ “ãñunetõjõãĩ” jĩĩ, ʉsenire ticoaro! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús Jerusalénpʉ jeagʉ, Cõãmacʉ̃wiipʉ sããwayigʉ. Toopʉ́ niipetire tiiwií maquẽrẽ ĩñapetijãyigʉ. Naĩrõpʉ tiiyíro. Teero tiigʉ́, Betaniapʉ cʉ̃ʉ̃ buerá docemena wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Apebʉ́reco bóeri Betaniapʉ niiãrira cãmepʉtʉ́ari, Jesús jʉabóayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Higueragʉ ãñurõ pṹũrĩcʉtirigʉre yoaropʉ ĩñayigʉ. “Dʉcacʉticura” jĩĩgʉ̃, ĩñagʉ̃ wáamiyigʉ. Pṹũrĩ dícʉ bʉayígʉ. Butirítono niiriyiro. ");
INSERT INTO tue_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús tiigʉré jĩĩyigʉ: —Ãpẽrã́ atigʉ́ dʉcare yaanemoricua sáa, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩrĩ, cʉ̃ʉ̃ buerá tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Too síro Jerusalénpʉ jeayira. Jesús Cõãmacʉ̃wiipʉ sããjeagʉ, dúari basocare, teeré sãĩnérãrẽ cõãwionecoyigʉ. Niyeru wasorí basocaye mesarire tuunécõãcũjãyigʉ. Bua dúari basocaye duirépĩrĩcãrẽ teerora tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Niipetirare apeyenómena Cõãmacʉ̃wiipʉ sããcãmewitidʉgarare cãmotáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Basocáre bueyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ biiro jĩĩã: “Yáa wii ‘niipetire dita macãrã Cõãmacʉ̃mena wedeseri wii niiã’ jĩĩrí wii niiãdacu”, jĩĩ jóare niiã. Mʉ́ãpe yaarépira dúari wii niirĩ tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Paiaré dutirá, ãpẽrã́ Moisés jóarigue buerá Jesús jĩĩãriguere tʉoyíra. Teero tiirá, cʉ̃́ã “¿deero tii marĩ ãnirẽ́ sĩãã́dari?” jĩĩ ãmaãnʉcãyira. Basocá Jesús buerére tʉomaníjõãyira. Teero wáari ĩñarã, paiaré dutirá, Moisés jóarigue buerá cʉ̃ʉ̃rẽ cuiyira. ");
INSERT INTO tue_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Náĩcũmuatiri, Jesús tiimacã niiãrigʉ witi, pʉtʉajõãyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Apebʉ́reco bóeri wáara, higueragʉre nʉcõrĩpʉra sĩniã́rigʉre ĩñayira. ");
INSERT INTO tue_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro Jesús higueragʉre jĩĩãriguere wãcũgʉ̃, jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, ĩñaña. Iigʉ́ mʉʉ tutiarigʉ sĩnijṍããyu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Cõãmacʉ̃rẽ padeoyá, jĩĩyigʉ Jesús cʉ̃́ãrẽ—. ");
INSERT INTO tue_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Apetó tiigʉ́, sĩcʉ̃no atigʉ́ ʉ̃tãgʉ̃rẽ́ “wáa, díapʉ ñaacoñuãña” jĩĩboqui. Cʉ̃ʉ̃ “teerora wáaadacu” jĩĩ padeorí, cʉ̃ʉ̃ jĩĩãrirobirora wáaadacu. “Ṍba, wáaricura” jĩĩrijãrõ booa. ");
INSERT INTO tue_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Teero tiirá, ãñurõ tʉoyá: Mʉ́ã apeyenó Cõãmacʉ̃rẽ sãĩrã́, “diamacʉ̃́rã ticogʉdaqui” jĩĩ padeorá, cʉoádacu. ");
INSERT INTO tue_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mʉ́ã Cõãmacʉ̃rẽ sãĩrã́, ãpẽrã́ mʉ́ãrẽ ñañarõ tiiríguere acabóya. Mʉ́ã teero tiirí ĩñagʉ̃, marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́cã mʉ́ã ñañaré tiirére acabógʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mʉ́ãrẽ ñañarõ tiiráre mʉ́ã acabóheri, cʉ̃ʉ̃cã mʉ́ã ñañaré tiirére acabóriqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Opatutí Jerusalénpʉ jeayira. Jesús Cõãmacʉ̃wiipʉ wáanetõrĩ, paiaré dutirá, Moisés jóarigue buerá, ãpẽrã́ bʉtoá dutirá Jesús pʉtopʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesuré sãĩñáyira: —¿Noã dutirémena mʉʉ teeré tiii? ¿Noã mʉʉrẽ dutiré ticori, mʉʉ teeré tiirí? jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Yʉʉcã mʉ́ãrẽ sãĩñágʉ̃da. Mʉ́ã yʉʉre yʉʉri, mʉ́ãrẽ “ate dutirémena tiia yʉʉ” jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Noã Juanrẽ́ wãmeõtidutigʉ ticocoyiri? ¿Cõãmacʉ̃ o basocápe ticocoyiri? Yʉʉya, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cʉ̃́ãpe cãmerĩ́ wedeseyira: —Marĩ “Cõãmacʉ̃ ticocorigʉ niiwĩ” jĩĩrĩ, cʉ̃ʉ̃ marĩrẽ “too docare ¿deero tiirá cʉ̃ʉ̃rẽ padeoríri?” jĩĩboqui. ");
INSERT INTO tue_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Marĩ “basocá cʉ̃ʉ̃rẽ ticocorira niiwã” jĩĩmasĩriga, jĩĩyira. Basocáre cuiyira. Niipetira “Juan profeta niiwĩ” jĩĩ padeoyíra. ");
INSERT INTO tue_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Teero tiirá, cʉ̃́ã Jesuré: —Masĩriga, jĩĩyira. Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉcã mʉ́ãrẽ “ate dutirémena teeré tiia” jĩĩ wederia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús cʉ̃́ãrẽ queorémena wedenʉcãyigʉ: —Sĩcʉ̃ ʉ̃mʉ niiyigʉ ʉse wese oterigʉ. Otepetitoa, sãnisã́nʉcõyigʉ. Ʉse cʉ̃́ã bipesã́ãdari copere ʉ̃tãgãpʉ coayígʉ. Teero biiri ʉ̃mʉã́ri wii cʉ̃́ã coteduiadari wiire tiiyígʉ. Aperopʉ́ wáanetõgʉ̃ wáagʉ, ãpẽrãrẽ́ tiiditare wasoyigʉ. Waso, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ʉse dʉcacʉtirito niirĩ, sĩcʉ̃ cʉ̃ʉ̃rẽ padecotegʉre ticocomiyigʉ. Cʉ̃ʉ̃ya dita cʉ̃ʉ̃ wasorirare “ʉse cʉ̃́ã dúa wapatárere decomena ticocoaro yʉʉre” jĩĩcomiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cʉ̃ʉ̃ toopʉ́ jeari, tiidita wasorira cʉ̃ʉ̃rẽ ñee, páa, péerogã ticoripacara, pʉtʉócojãyira. ");
INSERT INTO tue_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ãpĩ cʉ̃ʉ̃rẽ padecotegʉre ticocomiyigʉ sũcã. Cʉ̃ʉ̃rẽjã dupupʉ cãmitu, ñañarõ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Too síro ãpĩrẽ́ ticocomiyigʉ sũcã. Cʉ̃ʉ̃rẽjã diamacʉ̃́rã sĩãjã́yira sáa. Paʉ ticocomiyigʉ. Ãpẽrãrẽ́ páayira; ãpẽrãrẽ́ sĩãjã́yira. ");
INSERT INTO tue_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Cʉ̃ʉ̃ macʉ̃ cʉ̃ʉ̃ bayiró maĩgʉ̃́ dícʉ dʉsayígʉ. Cʉ̃́ã siropʉ cʉ̃ʉ̃rẽ ticocomiyigʉ. “Yʉʉ macʉ̃rẽ quioníremena ĩñaãdacua”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Õpʉ̃ macʉ̃ cʉ̃́ã pʉtopʉ jeari, tiidita wasorira cãmerĩ́ wedeseyira: “Ãnirã́ niiĩ too síropʉ atiditaré ñeegʉ̃dʉ. Jãmʉ, sĩãcó. Cʉ̃ʉ̃ manirĩ́, atiditá marĩya dita pʉtʉáadacu”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Teero tiirá, cʉ̃ʉ̃rẽ ñee, sĩã, tiiwese wesapʉ cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ cõãjãyira. ");
INSERT INTO tue_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Tiidita õpʉ̃ cʉ̃́ãrẽ tiiádarere mʉ́ãrẽ wedegʉda. Cʉ̃ʉ̃ ati, cʉ̃ʉ̃ya dita wasorirare sĩãcõã́peti, ãpẽrãrẽ́ tiiditare ticojãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Mʉ́ã Cõãmacʉ̃ye queti jóaripũ buerá niipacara, ate tiipũpʉ jóarere tʉomasĩ́ria ména: Wii weerira ʉ̃tãquire booríyira. Cʉ̃́ã boorípacari, tiiquira ʉpʉtí macãqui pʉtʉáwʉ tiiwiipʉ́re. ");
INSERT INTO tue_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cõãmacʉ̃ marĩ Õpʉ̃ teero tiirígʉ niiwĩ. Cʉ̃ʉ̃ tiiríguere “ãñunetõjõãã” jĩĩ tʉgueñanoã, jĩĩ jóanoã, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Cʉ̃́ãpeja “tee queorémena marĩrẽ jĩĩtutigʉ tiiquí” jĩĩ masĩjãyira. Teero tiirá, cʉ̃ʉ̃rẽ ñeeãdara tiimíyira. Basocáre cui, ñeemasĩri, wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cʉ̃́ã aperopʉ́ wáa, sĩquẽrã fariseo basocare, Herodere tʉonʉnʉ́serare sãĩñádutira ticocoyira. Cʉ̃́ã Jesús merẽã yʉʉri boomíyira. ");
INSERT INTO tue_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jesús pʉtopʉ jea, cʉ̃ʉ̃rẽ jĩĩyira: —Basocáre buegʉ́, mʉʉ ãñugʉ̃́ niirére masĩã. Mʉʉ basocáre diamacʉ̃́rã ãñurõ buegʉ́ niiã. Cʉ̃́ã tʉsaré dícʉre wedericu. Ʉpʉtí macãrãrẽ, bʉ́ri niirã́rẽ, niyeru cʉoráre, niyeru cʉohérare sĩcãrĩbíro ĩña, wedea mʉʉjã. Cõãmacʉ̃ cʉ̃́ãrẽ tiidutírere ãñurõ diamacʉ̃́ buea. Teero tiigʉ́, ʉ̃sãrẽ wedeya: ¿Romanuã õpʉ̃rẽ cʉ̃ʉ̃ niyeru wapasédutirere wapatíadari; o wapatírigarite? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesupé cʉ̃́ã wãcũrére, cʉ̃́ã ñañaré tiidʉgárere masĩjãyigʉ. Teero tiigʉ́, jĩĩyigʉ: —Mʉ́ã yʉʉre teero jĩĩ, wedesãdʉgara tiia. Niyeruquire néeatiya; ĩñagʉ̃dʉ tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tiiquire néeatiyira. —¿Noãyá diapóa, noã wãme tusai? jĩĩyigʉ. —César romanuã õpʉ̃ye tusaa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Too docare Césaye niirére Césare wiyayá; Cõãmacʉ̃yere Cõãmacʉ̃rẽ wiyayá, jĩĩyigʉ. Cʉ̃ʉ̃ teero yʉʉri, cʉ̃ʉ̃rẽ tʉomaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sĩquẽrã saduceo basoca Jesús pʉto jeayira. Cʉ̃́ã “diarira masãmʉãricua” jĩĩcua. Jesuré sãĩñáyira: ");
INSERT INTO tue_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Basocáre buegʉ́, Moisés dutirére jĩĩãda. “Sĩcʉ̃ põnamanígʉ̃ diaweori, cʉ̃ʉ̃ bai cʉ̃ʉ̃ nʉmo niirigore dúutuaro. Cʉ̃ʉ̃ coomena cʉ̃ʉ̃ sõwʉ̃ diarigʉre põnacʉtíbosaaro”, jĩĩ jóarigʉ niiwĩ Moisés. ");
INSERT INTO tue_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sĩcʉ̃põna siete niiyira. Cʉ̃́ã sõwʉ̃ nʉmocʉtiyigʉ. Põnamanígʉ̃rã diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Cʉ̃ʉ̃ siro macʉ̃ cʉ̃ʉ̃ sõwʉ̃ nʉmorẽ dúutumiyigʉ. Cʉ̃ʉ̃cã põnamanígʉ̃rã diajõãyigʉ. Cʉ̃́ã siro macʉ̃cã coore dúutu, põnamanígʉ̃rã diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Teero dícʉ wáayiro. Niitugʉpʉcãrẽ teerora wáayiro. Too síro cʉ̃́ã nʉmo niimirigocã diajõãyigo. ");
INSERT INTO tue_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cʉ̃́ã siete coore nʉmocʉtimiyira. Diarira masãmʉãrĩ, ¿nii nʉmope pʉtʉágodari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesupé cʉ̃́ãrẽ yʉʉyigʉ: —Mʉ́ã Cõãmacʉ̃ye queti jóaripũ maquẽrẽ masĩria. Cõãmacʉ̃ tutuarecãrẽ masĩria. Teero tiirá, wisijṍãã. ");
INSERT INTO tue_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Diarira masãmʉãri siro, ʉ̃mʉã́, numiã́ wãmosíaricua. Ángelea ʉ̃mʉã́sepʉ niirã́biro niiĩya. ");
INSERT INTO tue_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Diarira masãmʉãre maquẽrẽ mʉ́ã buepacara, tʉomasĩ́ria ména. Mʉ́ã Moisés jóaripũpʉ jʉ̃ʉ̃rísati queti buemijĩyu. Tiisatipʉ Cõãmacʉ̃ Moisére jĩĩrigʉ niiwĩ: “Abraham, Isaac, Jacob Õpʉ̃ niiã yʉʉ”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Cõãmacʉ̃ diarira Õpʉ̃ niirii; catirá Õpʉ̃pe niiĩ. Teero tiirá, mʉ́ã wisinetṍjõãã, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sĩcʉ̃ Moisés jóarigue buegʉ́ toopʉ́ niiyigʉ. Jesús saduceo basocamena wedeserere tʉoyígʉ. Jesús ãñurõ yʉʉmenirĩ ĩñagʉ̃, cʉ̃ʉ̃ pʉto jea, sãĩñáyigʉ: —¿Diiyé niiĩ Moisére dutiré cṹũrigue bayiró ʉpʉtí maquẽ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Bayiró ʉpʉtí maquẽ ate niiã: “Israelya põna macãrã, ãñurõ tʉoyá: Cõãmacʉ̃ marĩ Õpʉ̃ sĩcʉ̃rã niiĩ. ");
INSERT INTO tue_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Teero tiirá, Cõãmacʉ̃ marĩ Õpʉ̃rẽ maĩñá. Niipetire mʉ́ã yeeripũnamena, mʉ́ã wãcũrémena, mʉ́ã tutuaremena cʉ̃ʉ̃rẽ maĩñá”. ");
INSERT INTO tue_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tee doca maquẽ dutiré ate niiã: “Mʉʉ basiro maĩrṍ tiiróbirora ãpẽrãcã́rẽ maĩñá”. Ate pʉawãmé niipetire apeyé dutiré nemorṍ ʉpʉtí maquẽ niiã, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Moisés jóarigue buegʉ́pe jĩĩnemoyigʉ sũcã: —Ãñuniã, basocáre buegʉ́. Mʉʉ diamacʉ̃́ wedea. Cõãmacʉ̃ sĩcʉ̃rã niiĩ. Ãpĩ cʉ̃ʉ̃ tiiróbiro niigʉ̃́ maniquí. ");
INSERT INTO tue_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cõãmacʉ̃rẽ marĩ yeeripũnamena, marĩ wãcũrémena, marĩ tutuaremena maĩrṍ booa. Teero biiri marĩ basiro maĩrṍ tiiróbirora ãpẽrãcã́rẽ maĩrṍ booa. Marĩ Cõãmacʉ̃wiipʉ tiiré, wáicʉrare sĩã sóeditiore, Cõãmacʉ̃rẽ apeyenó ticoré ãñuniã. Ãñupacari, maĩrépe nemorṍ ʉpʉtí maquẽ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesupé cʉ̃ʉ̃ diamacʉ̃́ yʉʉri ĩñagʉ̃, jĩĩyigʉ: —Cõãmacʉ̃ dutiré mʉʉpʉre niiãdaro péerogã dʉsaa, jĩĩyigʉ. Too síro cʉ̃ʉ̃rẽ tʉorá “sãĩñária sáa” jĩĩ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Cõãmacʉ̃wiipʉ buegʉ, basocáre sãĩñáyigʉ: —¿Deero tiirá Moisés jóarigue buerá “Cõãmacʉ̃ beserigʉ David pãrãmi niiĩ” jĩĩĩ? ");
INSERT INTO tue_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David basirora Espíritu Santo masĩré ticorémena jóarigʉ niiwĩ: Cõãmacʉ̃ jĩĩwĩ yʉʉ Õpʉ̃rẽ: “Yáa wãmo diamacʉ̃́niñape duiya, tée mʉʉrẽ ĩñatutirare mʉʉ dutiriguere yʉʉ ãñurõ yʉʉri tiirípʉ”, jĩĩ jóarigʉ niiwĩ David. ");
INSERT INTO tue_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David “yʉʉ Õpʉ̃” jĩĩgʉ̃, Cõãmacʉ̃ beserigʉre jĩĩgʉ̃ tiirígʉ niiwĩ, cʉ̃ʉ̃ pãrãmí niipacari. Teeré ãñurõ wãcũña, jĩĩyigʉ. Basocá paʉ toopʉ́re niirã́ Jesús wederére ʉseniremena tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús basocáre buegʉ, jĩĩyigʉ: —Moisés jóarigue buerá tiirére tʉomasĩ́rõ booa. Cʉ̃́ã suti yoaretõ sãña, wáaʉseniya. Macã decopʉ quioníremena ãñudutiri boocúa. ");
INSERT INTO tue_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Neãré wiseripʉ sʉguero maquẽ duirépʉ dícʉ duidʉgacua. Bosebʉreco tiirópʉcãrẽ teerora tiidʉgácua. ");
INSERT INTO tue_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wapewia numiãye wiserire jĩĩditoremena ẽmacua. Cʉ̃́ã yoari Cõãmacʉ̃mena wedesera tiiróbiro tiiditóya basocáre. Cʉ̃́ãrã ãpẽrã́ nemorṍ ñañarõ tiinóãdara niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús Cõãmacʉ̃wiipʉ niigʉ̃, niyeru sã́ãretibari díamacʉ̃ duiyigʉ. Teetibaripʉ niyeru sã́ãrĩ, ĩñacoduiyigʉ. Paʉ niyeru cʉorá pairó sã́ãyira. ");
INSERT INTO tue_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sĩcõ wapewio bóaneõgõ jea, pʉaquí wapamanírequiri sã́ãyigo. ");
INSERT INTO tue_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús cʉ̃ʉ̃ bueráre atiduti, jĩĩyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã, jĩĩyigʉ—. Cõãmacʉ̃ ĩñacoropʉ igo wapewio bóaneõgõ niipetira nemorṍ ticonetõnʉcãyo. ");
INSERT INTO tue_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ĩ́niãpeja cʉ̃́ãrẽ dʉsaríguere ticooya. Coopeja coo cʉomíãrigue, coo yaaré sãĩbóariguegãrẽ ticopetijãyo, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Cõãmacʉ̃wiipʉ witiwari, sĩcʉ̃ cʉ̃ʉ̃ buegʉ́ tee wiserire ĩña, jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, ate wiseri cʉ̃́ã ʉ̃tãquiritõmena weeriguere ĩñaña. Ãñuré wiseri niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesupé jĩĩyigʉ: —Mʉʉ weere wiserire ĩñamiã. Too síro ʉ̃tãqui apequí sotoápʉ weemʉãrigue pʉtʉáricu. Niipetire cõãnoãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús cʉ̃ʉ̃ buerámena Ʉ̃tãgʉ̃́ Olivo Cõãmacʉ̃wii díamacʉ̃ niirígʉpʉ wáayigʉ. Toopʉ́ duiri, Pedro, Santiago, Juan, Andrés ãpẽrã́ tʉohéropʉ cʉ̃ʉ̃rẽ sãĩñáyira: ");
INSERT INTO tue_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Wedeya ʉ̃sãrẽ. Mʉʉ wedearigue ¿deero biiri wáaadari? ¿Ñeenómena ĩñamasĩnoãdari, ate wáaadari sʉguerogãrẽ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Ãñurõ tʉomasĩ́ña, ãpẽrã́ jĩĩditori jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Paʉ “yʉʉrá niiã; yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩãdacua. Paʉ cʉ̃́ãrẽ nʉnʉã́dacua. ");
INSERT INTO tue_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’“Cãmerĩ́sĩãrã tiiáwã” jĩĩrĩ tʉoádacu. “Toopʉ́ cãmerĩ́sĩãrã tiiáyira” jĩĩré queticãrẽ tʉoádacu. Teeré tʉorá, cuirijãña. Tee wáaadare niijãrõ tiia. Teero wáapacari, atibʉ́reco petiádaro dʉsaádacu ména. ");
INSERT INTO tue_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sicapõna macãrã apepõná macãrãmena cãmerĩ́sĩããdacua. Teero biiri sicadita macãrã apeditá macãrãmena cãmerĩ́sĩããdacua. Peeditapʉre dita cãmeñare wáaadacu. Jʉabóare wáaadacu. Teeména basocáre bayiró ñañarõ netõré nʉcãã́dacu. ");
INSERT INTO tue_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Mʉ́ã basiro ãñurõ wãcũ tʉgueñaña. Mʉ́ãrẽ dutirápʉre tico, judíoa neãré wiseripʉ tãnaã́dacua. Mʉ́ã yʉʉre padeoré wapa dutirá, õpãrã́ pʉtopʉ néewanoãdacu. Toopʉ́ jeara, yée maquẽrẽ wedemasĩãdacu. ");
INSERT INTO tue_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Atibʉ́reco petiádari sʉguero, niipetire dita macãrã Cõãmacʉ̃ basocáre netõnére queti tʉosesáadare niirõ tiia. ");
INSERT INTO tue_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mʉ́ãrẽ dutirá pʉtopʉ néewari, “¿deero jĩĩãdari cʉ̃́ãrẽ?” jĩĩ wãcũhẽrãrã wáawa. Mʉ́ã jearira, Cõãmacʉ̃ mʉ́ãrẽ wãcũré ticogʉdaqui. Teeré wedeseya. Mʉ́ã mee wedeseadacu; Espíritu Santo wedesegʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sĩcʉ̃põna dutirápʉre cãmerĩ́ wedesã, sĩãrĩ́ tiiádacua. Cʉ̃́ã pacʉsʉ̃mʉãcã cʉ̃́ã põnarẽ dutirápʉre wedesããdacua. Cʉ̃́ã põnacã teerora cʉ̃́ã pacʉsʉ̃mʉãrẽ netõnʉcã́, diari tiiádacua. ");
INSERT INTO tue_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Niipetira basocá mʉ́ãrẽ ĩñatutiadacua yʉʉre padeoré wapa. Teero mʉ́ãrẽ cʉ̃́ã ñañarõ tiipacári, yʉʉre padeorucújãrãrẽ Cõãmacʉ̃ netõnégʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ñañanetõjõãgʉ̃rẽ Cõãmacʉ̃rẽ padeorídojãgʉ̃rẽ ĩñaãdacu mʉ́ã. Cõãmacʉ̃wiipʉ too cʉ̃ʉ̃rẽ niidutiherore nucũrĩ ĩñaãdacu. (Ateré buegʉ́ tʉomasĩ́ãrõ.) Too cʉ̃ʉ̃ nucũrĩ ĩñarã, Judea ditapʉ niirã́ ʉ̃tãyucʉpʉ dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wii sotoápʉ pesagʉ́no diiwá, wii popeapʉ niirére néegʉ̃ sããwaripacʉ, dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wesepʉ́ padegʉ́cã wiipʉ́ sutiré néegʉ̃ pʉtʉawaripacʉ, dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Teero wáare bʉrecori niipacósãnumiãrẽ, põna ũpũrã́ cʉoráre bóaneõre bʉrecori niiãdacu. ");
INSERT INTO tue_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Tee púuriro niiré bʉrecori wáarijããrõ” jĩĩ, Cõãmacʉ̃rẽ sãĩñá. ");
INSERT INTO tue_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Teero wáare bʉrecori basocáre ñañarõ netõré bʉrecori niiãdacu. Cõãmacʉ̃ atibʉ́reco tiirí sirore, tée atitópʉre nocõrõ ñañarõ netõré maniríro niiwʉ̃. Too síropʉcãrẽ nocõrõ peti ñañarõ netõré maniã́dacu. ");
INSERT INTO tue_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tee ñañarõ netõré bʉrecorire Cõãmacʉ̃ dʉ́oriatã, sĩcʉ̃no netõrídojãgʉ̃daqui. Cõãmacʉ̃pe cʉ̃ʉ̃ beserirare tiigʉ́, teero wáare bʉrecorire dʉ́ogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Teero wáari, sĩquẽrã mʉ́ãrẽ jĩĩditoadacua: “Jã́ã, ĩñaña. Cõãmacʉ̃ beserigʉ Cristo ãno niiĩ”, jĩĩmiãdacua. “Toopʉ́ niiĩ”, jĩĩmiãdacua ãpẽrãpé. Cʉ̃́ã teero jĩĩrĩ, padeoríjãña. ");
INSERT INTO tue_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Paʉ jĩĩditora niiãdacua. Sĩquẽrã “yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩmiãdacua. “Profeta niiã”, jĩĩmiãdacua ãpẽrãpé. Pee tiiẽ́ñore tiiádacua, cʉ̃́ãrẽ padeoáro jĩĩrã. Cõãmacʉ̃ beserirapʉrena padeodúri tiidʉgámiãdacua. ");
INSERT INTO tue_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mʉ́ã ãñurõ tʉomasĩ́ña. Tee niipetire niiãdarerena mʉ́ãrẽ yʉʉ wedesʉguetoaa, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús wedenemoyigʉ: —Tee ñañarõ netõré bʉrecori siro muĩpũ bʉ́reco macʉ̃ naĩtĩãjõãgʉ̃daqui. Ñami macʉ̃cã bóeriqui. ");
INSERT INTO tue_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ñocõã́ ñaacodiadacua. Niipetira ʉ̃mʉã́sepʉ niirã́ cãmeñanoãdacua. ");
INSERT INTO tue_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Teero wáari, yʉʉ niipetira sõwʉ̃ õmebʉrʉáripʉ tutuaremena asibatédiatiri, basocá ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Too síro ángeleare ticocogʉdacu. Cʉ̃́ã néõãdacua yʉʉ beserirare atibʉ́reco niipetiropʉ niirã́rẽ. ");
INSERT INTO tue_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Mʉ́ãrẽ oterigʉ higueragʉmena queoré ticogʉda. Tiigʉ́ pṹũrĩ wasorí, “cʉ̃ma wáaadaro péerogã dʉsaa” jĩĩmasĩã. ");
INSERT INTO tue_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tee tiiróbirora yʉʉ jĩĩãrigue wáari ĩñarã, “niipetira sõwʉ̃ pʉtʉaatiadaro péerogã dʉsacú” jĩĩmasĩña. ");
INSERT INTO tue_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Atitó macãrã cʉ̃́ã diaadari sʉguero, tee niipetire yʉʉ jĩĩãrigue wáaadacu. ");
INSERT INTO tue_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉ̃mʉã́se, atiditá peticódiaadacu. Yʉʉ wedesere doca petirícu. Niirucujããdacu. ");
INSERT INTO tue_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Yʉʉ pʉtʉaatiadari bʉreco, tii horare masĩña maniã. Ángelea ʉ̃mʉã́se macãrã masĩriya. Yʉʉ niipetira sõwʉ̃cã masĩria. Yʉʉ Pacʉ sĩcʉ̃rã masĩqui. ");
INSERT INTO tue_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mʉ́ãcã tiibʉrecore masĩria. Teero tiirá, ãñurõ wãcũtutua, ĩñacoya. ");
INSERT INTO tue_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mʉ́ãrẽ queorémena wedegʉda. Sĩcʉ̃ basocʉ́ niiyigʉ yoaropʉ wáagʉ. Cʉ̃ʉ̃ wáaadari sʉguero, cʉ̃ʉ̃rẽ padecoterare cʉ̃ʉ̃ya wiire “coteya” jĩĩyigʉ. Cʉ̃́ãcõrõrẽ cʉ̃́ã padeadarere cṹũyigʉ. Sope coterí basocʉre ãñurõ ĩñacodutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cʉ̃́ã tiiróbiro mʉ́ãcã ĩñacorucujãña. Mʉ́ãcã mʉ́ã Õpʉ̃ coeádari bʉrecore masĩricu. Náĩcũmurĩ, ñami deco, cãrẽquẽ wederi, o bóeritabe niiboqui. ");
INSERT INTO tue_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yʉʉ wãcũña manirṍ pʉtʉaatigʉ, mʉ́ãrẽ cãnirã́rẽ bʉajeádʉgariga. ");
INSERT INTO tue_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yʉʉ mʉ́ãrẽ jĩĩrére niipetirare jĩĩgʉ̃da: Ãñurõ ĩñacorucujãña, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pʉabʉ́reco dʉsayíro Pascua bosebʉreco wáaadaro. Tii bosebʉreco niirĩ, pã púuri tiiré wʉ́oya maniré yaanoã. Paiaré dutirá, Moisés jóarigue buerámena Jesuré yayióremena cʉ̃́ã ñeeãdarere cãmerĩ́ wedeseyira, sĩãdʉgára. ");
INSERT INTO tue_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Bosebʉreco niirĩ, tiiríjããda. Basocá cʉ̃ʉ̃rẽ maĩrã́, marĩmena cúara, noo booró acaribíãmajãbocua, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betaniapʉ Simón õpʉ̃ʉ̃ bóa netõrígʉya wiipʉ niiyigʉ. Jesús yaaduiritabe, sĩcõ numiṍ sitiaãñúriga cʉogó jeayigo. Tiigá sitiaãñúre “nardo” wãmecʉtire wapapacáre posecʉtíyiro. Tiigá ñacõrẽ tuupécojã, cʉ̃ʉ̃ya dupu sotoapʉ píopeoyigo. ");
INSERT INTO tue_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ãpẽrã́ toopʉ́ niirã́ coo teero tiirí ĩñarã, cúajõãyira. Cʉ̃́ã cãmerĩ́ jĩĩyira: —¿Ate sitiaãñúre wapapacáre bʉ́ri peti teero tiicõã́ĩ? ");
INSERT INTO tue_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ate sitiaãñúrere dúa, sicacʉ̃ma padegʉ wapatárocõrõ bʉanóboayu. Teeména bóaneõrãrẽ tiiápuro boomíãyu, jĩĩyira. Coore tutiyira. ");
INSERT INTO tue_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —¿Deero tiirá coore potocṍĩ? Potocṍrijãña. Ateré yʉʉre píopeogo, ãñurõ tiigó tiiyo. ");
INSERT INTO tue_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bóaneõrã mʉ́ã watoapʉ niirucujããdacua. Mʉ́ã boorítono cʉ̃́ãrẽ ãñurõ tiiápumasĩã. Yʉʉpeja mʉ́ãmena niirucuricu. ");
INSERT INTO tue_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Atigó yʉʉre coo jeatuaro ãñurõ tiiyo. Coo sitiaãñúrere píopeogo, yʉʉre yaará sitiaãñúre tuusĩã́ãdaro tiiróbiro tiiyúetoayo. ");
INSERT INTO tue_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niipetiro atiditapʉ́re Cõãmacʉ̃ basocáre netõnére quetire wedewarucura, atigó yʉʉre tiiáriguere wedeadacua, coore wãcũdutira, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote Jesús buerá doce menamacʉ̃ wáa, paiaré dutiráre jĩĩyigʉ: —Yʉʉ mʉ́ãpʉre Jesuré ticogʉda, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Teeré tʉorá, bayiró ʉseniyira. —Mʉʉrẽ niyeru wapatíada, jĩĩyira. Teero tiigʉ́, “¿deero tii yʉʉre Jesuré ticoro boomíĩto?” jĩĩ wãcũnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Basocá pã púuri tiirémena wʉ́oya maniré yaarí bosebʉreco niinʉcãyiro. Tiibʉreco niirĩ, oveja Pascua macʉ̃ niigʉ̃dʉre sĩãyíra. Tiibʉrecore Jesús buerá cʉ̃ʉ̃rẽ sãĩñáyira: —¿Noopʉ́ ʉ̃sã Pascua boseyaadarere quẽnobosára wáagari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesús pʉarã́ cʉ̃ʉ̃ bueráre ticocoyigʉ. —Jerusalénpʉ wáaya, jĩĩyigʉ—. Toopʉ́ sĩcʉ̃ basocʉ́ ocogá turupeogʉre bʉajeáadacu. Cʉ̃ʉ̃rẽ nʉnʉwáwa. ");
INSERT INTO tue_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cʉ̃ʉ̃ sããwaro tiiwií õpʉ̃rẽ jĩĩwa: “ ‘¿Noopʉ́ niigari yʉʉ buerámena Pascua boseyaadari tatia?’ jĩĩãwĩ ʉ̃sãrẽ buegʉ́”, jĩĩwa. ");
INSERT INTO tue_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Cʉ̃ʉ̃ ʉ̃mʉã́rõ macã tatia quẽnoã́ri tatiacapʉ ẽñogʉ̃́daqui. Toopʉ́ quẽnoyúewa, jĩĩcoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Cʉ̃ʉ̃ buerá wáa, Jerusalénpʉ jeayira. Toopʉ́ jeara, Jesús cʉ̃́ãrẽ jĩĩãrirobirora niipetirere bʉayíra. Toopʉ́ cʉ̃́ã Pascua boseyaadarere quẽnoyíra. ");
INSERT INTO tue_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Náĩcũmuãri siro, Jesús, cʉ̃ʉ̃ buerá docemena tiiwiipʉ́re jeayigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cʉ̃́ã yaaduiri, Jesús jĩĩyigʉ: —Yʉʉ ateré diamacʉ̃́rã jĩĩã: Mʉ́ã menamacʉ̃ sĩcʉ̃ yʉʉmena yaaduigʉ yʉʉre ĩñatutirapʉre ticogʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cʉ̃́ã bayiró wãcũpatiyira. —¿Yʉʉ mee niiĩ? jĩĩ sãĩñánʉcãyira cʉ̃́ãcõrõ. ");
INSERT INTO tue_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Sĩcʉ̃ mʉ́ã doce menamacʉ̃ yʉʉmena atibapapʉ́ pãmena soayágʉra niiĩ. ");
INSERT INTO tue_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yʉʉ niipetira sõwʉ̃rẽ Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaadacu. Bóaneõgʉ̃ niigʉ̃daqui yʉʉre ticogʉdʉpeja. Cʉ̃ʉ̃ bauáriatã, nemorṍ ãñubojĩyu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jesús cʉ̃́ãmena yaagʉ, pãrẽ née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, pʉatásã, batogʉra, jĩĩyigʉ: —Yaaya. Ate yáa õpʉ̃ʉ̃biro niiã. ");
INSERT INTO tue_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vino bapare née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, cʉ̃ʉ̃ bueráre tĩ́ãyigʉ. Niipetira tiibapa maquẽrẽ sĩniyíra. ");
INSERT INTO tue_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cʉ̃́ãrẽ tĩ́ãgʉ̃, jĩĩyigʉ: —Ate yée díibiro niiã. Yʉʉ diari, yée díi õmayudiaadacu, paʉ basocá ñañaré tiirére cosebosáaro jĩĩgʉ̃. Teeména Cõãmacʉ̃ mama netõnére quetire cṹũgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Vino sĩninemóricu sáa; tée Cõãmacʉ̃ Õpʉ̃ niirṍpʉ mama vino ĩñaña manirére sĩnigʉ̃́dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sicawãme Cõãmacʉ̃rẽ basarére basapeotoaari siro, Ʉ̃tãgʉ̃́ Olivopʉ wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã niipetira yʉʉre cõãwapetijõããdacu. Tee Cõãmacʉ̃ye queti jóaripũpʉ niiã: “Oveja coterí basocʉre sĩãcõã́gʉ̃dacu. Teero tiirí, cʉ̃ʉ̃yara oveja cʉ̃́ã booró cʉtʉbatéjõããdacua”, jĩĩ jóarigue niiã. ");
INSERT INTO tue_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Teero wáapacari, yʉʉ diarigʉpʉ masãri siro, yʉʉ mʉ́ã sʉguero Galileapʉ jeatoagʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro jĩĩyigʉ: —Niipetira mʉʉrẽ cõãwari, yʉʉja mʉʉrẽ cõãwaricu, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mecʉ̃ã macã ñami pʉarĩ́ cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ “cʉ̃ʉ̃rẽ masĩriga” jĩĩditogʉdacu mʉʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro jĩĩyigʉ: —Yʉʉja cʉ̃́ã yʉʉre sĩãdʉgáatã, mʉʉmena diagʉda; mʉʉrẽ “masĩriga” jĩĩricu, jĩĩmiyigʉ. Niipetira cʉ̃ʉ̃ buerá teero dícʉ jĩĩyucomiyira. ");
INSERT INTO tue_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Too síro Getsemanípʉ jeayira. Jesús cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Mʉ́ã ãno duiyueya ména. Yʉʉ Pacʉre sãĩgʉ̃́ wáagʉ tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedro, Santiago, Juanrẽ́ cʉ̃ʉ̃mena néewayigʉ. Cʉ̃ʉ̃ bayiró peti yeeripũnapʉ wãcũpati, bóaneõnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Yʉʉre diariquioro, wãcũpatire niinetõjõãga. Mʉ́ã ãno pʉtʉáya. Cãnirã́ mee tiiwá, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cʉ̃́ã beru yoasãñurõ wáa, yepapʉ munibiácũmuyigʉ. Tee ñañarõ netõré jearijããrõ jĩĩgʉ̃, Cõãmacʉ̃rẽ sãĩyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Sãĩgʉ̃́, jĩĩyigʉ: —Pacʉ, niipetirere tiimasĩ́ã mʉʉ. Yʉʉ ñañarõ netõã́darere netõnéña. Yʉʉ teero jĩĩpacari, yʉʉ boorére tiiríjãña; mʉʉ boorépe wáari tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Too síro cʉ̃ʉ̃ buerá pʉtopʉ cãmepʉtʉ́ayigʉ. Cʉ̃́ãrẽ cãniã́rirapʉre bʉajeáyigʉ. —Simón, ¿mʉʉ cãnigʉ̃́ tiii? ¿Deero tiigʉ́ péerogã ĩña tiirídojãĩ? jĩĩyigʉ Pedrore—. ");
INSERT INTO tue_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cãnirã́ mee tiiyá. Wãtĩ mʉ́ãrẽ jĩĩcõãsãrijããrõ jĩĩrã, Cõãmacʉ̃rẽ sãĩñá. Mʉ́ã wãcũrémena ãñurére tiidʉgápacari, mʉ́ãye õpʉ̃ʉ̃rĩpe sĩcãrĩbíria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cãmepʉtʉ́agʉ, cʉ̃ʉ̃ Pacʉre sãĩã́rirobirora sãĩyígʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sãĩã́ri siro, cʉ̃ʉ̃ buerá pʉtopʉ cãmepʉtʉ́agʉ, cãniã́rirapʉre bʉajeáyigʉ sũcã. Cʉ̃́ãrẽ wʉgoá pũnijõãyiro. Cʉ̃ʉ̃rẽ deero yʉʉmasĩriyira. ");
INSERT INTO tue_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ĩtĩã́rĩ cãmepʉtʉ́agʉ cʉ̃́ãrẽ jĩĩyigʉ: —¿Mʉ́ã cãnirã́ tiii sũcã? ¿Cãni, yeerisãjãrã tiii? Nocõrõrã niiã. Yʉʉre ticoadaro jearo tiia. Yʉʉ niipetira sõwʉ̃rẽ ticogʉdaqui ñañaré tiirápʉre. ");
INSERT INTO tue_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wʉ̃mʉnʉcãña. Jãmʉ, yʉʉre ticogʉdʉ atitoai mée, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús cʉ̃́ãmena wedesegʉ tiiríra, máata cʉ̃́ã menamacʉ̃ niimiãrigʉ Judas jeayigʉ. Cʉ̃ʉ̃mena paʉ basocá espadapĩrĩmena, yucʉména atiyira. Cʉ̃́ã paiaré dutirá, Moisés jóarigue buerá, ãpẽrã́ bʉtoá dutirá ticocoarira niiyira. ");
INSERT INTO tue_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","“Yʉʉ wasopúro ũpũgʉ̃́ cʉ̃ʉ̃rã́ niigʉ̃daqui. Cʉ̃ʉ̃rẽ ñee, ãñurõ siatú, néewawa”, jĩĩsʉguetoayigʉ Jesuré ticogʉdʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Máata Jesús pʉtopʉ jeagʉ: —Yʉʉre buegʉ́, jĩĩyigʉ. Teero jĩĩgʉ̃rã, cʉ̃ʉ̃ wasopúrore ũpũyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Teero tiirí ĩñarã, Jesuré ñeejõãyira. ");
INSERT INTO tue_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cʉ̃ʉ̃rẽ ñeerĩ, sĩcʉ̃ toopʉ́ nucũgʉ̃́ cʉ̃ʉ̃ya espadare tʉ̃ãwé, paiaré dutigʉ́re padecotegʉya cãmopérore páatacojãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —¿Yaarépigʉre tiiróbiro yʉʉre espadapĩrĩmena, yucʉména ñeerã atiarĩ? ");
INSERT INTO tue_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bʉ́recoricõrõ yʉʉ Cõãmacʉ̃wiipʉ mʉ́ãmena niiwʉ̃, buegʉ. Yʉʉre ñeeriwʉ. Mʉ́ã mecʉ̃tígã tiiré Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaro tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃ sĩcʉ̃rẽna cõãnʉcõ, dutipetíjõãyira. ");
INSERT INTO tue_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sĩcʉ̃ mamʉ Jesús siro nʉnʉátiyigʉ. Cãnigʉ̃́ cõmarí caseromena dícʉ cõmarígʉ niiyigʉ. Cʉ̃́ã cʉ̃ʉ̃rẽ ñeemiyira. ");
INSERT INTO tue_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cʉ̃ʉ̃rẽ ñeema jĩĩrã, cʉ̃ʉ̃ cõmarí casero dícʉ wéepãnecojãyira. Cʉ̃ʉ̃pe sutimanígʉ̃ dutijṍãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesuré ñee, paiaré dutigʉ́ pʉtopʉ néewayira. Toopʉ́ niipetira paiaré dutirá, ãpẽrã́ bʉtoá dutirá, teero biiri Moisés jóarigue buerá neãyira. ");
INSERT INTO tue_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrope yoasãñurõ Jesuré nʉnʉyígʉ. Paiaré dutigʉ́ya wii popea macã yepapʉ pʉtʉáyigʉ. Toopʉ́ Cõãmacʉ̃wii coterí basoca pʉto jeanuã, cʉ̃́ãmena pecame sũmaduíyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Paiaré dutirá, niipetira Judíoare Dutirá Peti “¿deero tii cʉ̃ʉ̃rẽ wedesãrõ boomíĩto?” jĩĩyira, sĩãdʉgára. Cʉ̃ʉ̃rẽ sĩãdʉgápacara, ñañaré bʉaríyira. ");
INSERT INTO tue_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paʉ jĩĩditoremena cʉ̃ʉ̃rẽ wedesãmiyira. Cʉ̃́ã wedesãre queoró jeariyiro. ");
INSERT INTO tue_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ãpẽrã́ wʉ̃mʉnʉcã, jĩĩditoremena cʉ̃ʉ̃ jĩĩriguere wedesãyira: ");
INSERT INTO tue_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—“Yʉʉ atiwií Cõãmacʉ̃wiire basocá tiirí wiire cõãgʉ̃da. Itiábʉreco siro apewií túajeanʉcõgʉ̃da. Tiiwií basocá tiirí wii mee niiãdacu”, jĩĩwĩ ãni, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Teero jĩĩpacara, sĩcãrĩbíro wedeseriyira. ");
INSERT INTO tue_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Paiaré dutigʉ́ cʉ̃́ã watoapʉ wʉ̃mʉnʉcã, Jesuré sãĩñáyigʉ: —¿Mʉʉ deero tiigʉ́ yʉʉridojãĩ? ¿Deero jĩĩ yʉʉgʉdari cʉ̃́ã wedesãrere? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Cʉ̃ʉ̃pe yʉʉriyigʉ. Paiaré dutigʉ́ sãĩñánemoyigʉ: —¿Mʉʉrã́ niiĩ “Cõãmacʉ̃ beserigʉ Cristo, Cõãmacʉ̃ ãñugʉ̃́ macʉ̃” cʉ̃́ã jĩĩgʉ̃́? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús jĩĩyigʉ: —Yʉʉrá niiã. Cõãmacʉ̃ tutuare cʉonetṍgʉ̃ pʉto cʉ̃ʉ̃ diamacʉ̃́pe duigʉdacu. Yʉʉ niipetira sõwʉ̃ toopʉ́ duiri ĩñaãdacu mʉ́ã. Yʉʉ õmebʉrʉáripʉ diiátiricãrẽ ĩñaãdacu mʉ́ã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Paiaré dutigʉ́ teero jĩĩrĩ tʉogʉ́, cʉ̃ʉ̃ basiro cʉ̃ʉ̃yaro sutiroré wéeyigacojãyigʉ, ãpẽrãrẽ́ “bayiró cúai” jĩĩdutigʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Ãpẽrã́ wedesãrĩ boonemória marĩ. ");
INSERT INTO tue_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mʉ́ã cʉ̃ʉ̃ Cõãmacʉ̃rẽ ñañarõ wedeserere tʉotóaa. ¿Deero tʉgueñaĩ mʉ́ã? jĩĩyigʉ. Niipetira: —Cʉ̃ʉ̃ teero jĩĩré wapa sĩãjã́rõ booa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ãpẽrã́ cʉ̃ʉ̃rẽ ʉsecó eobatétunʉcãyira. Cʉ̃ʉ̃ capearire biaápeyira. Cʉ̃ʉ̃rẽ ñañarõ tii, páayira. —Jĩĩbʉaya. ¿Noã mʉʉrẽ páaarĩ? jĩĩyira. Cõãmacʉ̃wii coterí basocacã cʉ̃ʉ̃rẽ páayira. ");
INSERT INTO tue_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pedro tiiwií popea macã yepapʉ pecame sũmagʉ̃́ tiirí, sĩcõ paiaré dutigʉ́re padecotego jeayigo. Coo cʉ̃ʉ̃rẽ ĩñagõrã ĩña: —Mʉʉcã Jesús Nazaret macã macʉ̃mena wáarucuarigʉra niiãrã, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Cʉ̃ʉ̃rẽ masĩriga. Ñeenórẽ wedesego wedesecu; tʉomasĩ́riga, jĩĩyigʉ. Cʉ̃ʉ̃ sopepʉ́ witijeari, cãrẽquẽ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Paiaré dutigʉ́re padecotego cʉ̃ʉ̃rẽ ĩñagõ, toopʉ́ ĩñanucũrãrẽ jĩĩnemoyigo: —Ãni cʉ̃́ã menamacʉ̃ niiĩ, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Cʉ̃ʉ̃pe: —Niiria, jĩĩyigʉ. Too sírogã toopʉ́ ĩñanucũrã Pedrore jĩĩyira: —Niirṍrã mʉʉcã cʉ̃́ã menamacʉ̃ niicu. Mʉʉ Galilea macʉ̃ niijĩĩ; cʉ̃́ã tiiróbiro wedesea, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Cʉ̃ʉ̃ jĩĩyigʉ: —Yʉʉ diamacʉ̃́ jĩĩhẽrĩ, Cõãmacʉ̃ yʉʉre ñañarõ tiiáro. Yʉʉ mʉ́ã wedesegʉre masĩriga, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cʉ̃ʉ̃ teero jĩĩritabera, cãrẽquẽ wedeyigʉ sũcã. Pedro Jesús jĩĩãriguere wãcũbʉayigʉ: “Cãrẽquẽ pʉarĩ́ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ ‘cʉ̃ʉ̃rẽ masĩriga’ jĩĩgʉ̃dacu mʉʉ”, jĩĩyigʉ. Teeré wãcũbʉagʉ, bayiró utiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bóeri paiaré dutirá, ãpẽrã́ bʉtoá dutirá, Moisés jóarigue buerá, teero biiri niipetira Judíoare Dutirá Peti neãyira. Jesuré sĩãdutíadarere wedeseyira. Wedesetoa, Jesuré siatú, néewa, Pilatopʉre ticoyira. ");
INSERT INTO tue_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato cʉ̃ʉ̃rẽ sãĩñáyigʉ: —¿Mʉʉrã́ niiĩ judíoa õpʉ̃? jĩĩyigʉ. —Mʉʉ jĩĩrõbirora cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Paiaré dutirá pee wedesãyira cʉ̃ʉ̃rẽ. ");
INSERT INTO tue_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato Jesuré sãĩñánemoyigʉ: —Cʉ̃́ã mʉʉrẽ pee wedesãrã tiiíya. ¿Mʉʉ yʉʉridojãĩ? jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús yʉʉriyigʉ. Teero tiigʉ́, Pilato ĩñamanijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cʉ̃marĩcṍrõ Pascua bosebʉrecori niirĩ, Pilato sĩcʉ̃ peresuwiipʉ niigʉ̃́rẽ basocá cʉ̃́ã wionécodʉgagʉre wionécorucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Teebʉrecorire sĩcʉ̃ ʉ̃mʉ peresuwiipʉ duiyigʉ cʉ̃ʉ̃ menamacãrãmena. Cʉ̃ʉ̃ wãmecʉtiyigʉ Barrabás. Cʉ̃́ã romanuã dutiráre cõãdʉgara, cãmerĩ́sĩãyira. ");
INSERT INTO tue_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Basocá Pilato pʉtopʉ wáa: —Mʉʉ tiirucúrobirora tiiyá, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato cʉ̃́ãrẽ sãĩñáyigʉ: —¿Mʉ́ã judíoa õpʉ̃rẽ yʉʉ wionécori boogári? jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paiaré dutirá ĩñatutira Jesuré ticoariguere masĩjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Paiaré dutirá basocáre acaribíri tiiyíra, Barrabápere wionécodutira. ");
INSERT INTO tue_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato cʉ̃́ãrẽ sãĩñánemoyigʉ: —Mʉ́ã “judíoa õpʉ̃ niiĩ” jĩĩgʉ̃́pere ¿deero tiirí boogári? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—¡Cʉ̃ʉ̃rẽ curusapʉ páabiatudutiya! jĩĩ acaribíyira. ");
INSERT INTO tue_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Ñeenó ñañaré tiiárĩ cʉ̃ʉ̃? jĩĩyigʉ. Basocápe bayiró bʉsʉrómena: —¡Curusapʉ páabiatudutiya! jĩĩnemoyira. ");
INSERT INTO tue_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato basocámena ãñurõ pʉtʉádʉgagʉ, Barrabáre wionécobosayigʉ. Jesuré tãnadutítoaari siro, curusapʉ páabiatu sĩãdutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Teero tiirá, surara cʉ̃́ãye wiseri popea macã yepapʉ cʉ̃ʉ̃rẽ néewayira. Toopʉ́ ãpẽrã́ niipetira surarare néõyira. ");
INSERT INTO tue_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cʉ̃́ã Jesuré sicaró õpʉ̃ya sutiro tiiróbiro sõã ñiisãñúrõca sã́ãyira. Sicabeto potamena tiiári beto cʉ̃ʉ̃ya dupupʉre péoyira. ");
INSERT INTO tue_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—Ʉseniã mʉʉmena, judíoa õpʉ̃, jĩĩ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sicagʉ́ cãnʉgʉ̃mena cʉ̃ʉ̃ya dupupʉre páayira. Cʉ̃ʉ̃rẽ ʉsecó eobatétu, ñicãcoberimena jeacũmu, buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cʉ̃́ã cʉ̃ʉ̃rẽ buitóa, sõã ñiisãñúrõrẽ tuuwécojã, cʉ̃ʉ̃ sãñasʉguearirore sã́ãyira. Curusapʉ páabiatura wáara néewayira. ");
INSERT INTO tue_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sĩcʉ̃ Cirene macã macʉ̃ cã́pũpʉ niiãrigʉ pʉtʉaatigʉ tiiyígʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Simón. Pʉarã́ pacʉ niiyigʉ: Alejandro, Rufo pacʉ. Cʉ̃ʉ̃ too netõwári ĩñarã, Jesús apawari curusare cʉ̃ʉ̃rẽ apadutiyira. ");
INSERT INTO tue_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesuré Gólgota buropʉ néewayira. Gólgota jĩĩrõ, “Dupucoro” jĩĩrõ tiia. ");
INSERT INTO tue_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Toopʉ́ vino “mirra” wãmecʉtire wʉ́oariguemena tĩ́ãmiyira. Sĩniríyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cʉ̃ʉ̃rẽ curusapʉ páabiatuyira, diaaro jĩĩrã. Surara cʉ̃ʉ̃ye suti niimiãriguere batoadara, jĩĩbʉaapeyira, ¿noãrẽ́ pʉtʉáadari? jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cʉ̃ʉ̃rẽ curusapʉ páabiaturi, bóeri nueve niirĩ niiyiro. ");
INSERT INTO tue_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Basocá cʉ̃ʉ̃rẽ wedesããriguere jóatunoyiro táboapĩpʉre: “JUDÍOA ÕPɄ̃ NIIĨ”, jĩĩyiro. ");
INSERT INTO tue_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuména pʉarã́ yaarépirare páabiatuyira; sĩcʉ̃ diamacʉ̃́pe, ãpĩ acuniñape nʉcõyíra. ");
INSERT INTO tue_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cʉ̃́ã teero tiirí, Cõãmacʉ̃ye queti jóaripũpʉ jóarigue diamacʉ̃́ wáayiro. “ ‘Dutirére netõnʉcã́rã menamacʉ̃ niiĩ’ jĩĩ wãcũũya basocá cʉ̃ʉ̃rẽ”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Basocá toopʉ́ netõwára, cʉ̃ʉ̃rẽ ñañarõ jĩĩrã, dupupá saguejṍãrucuyira. —Jʉ̃́ʉ̃. Mʉʉ “Cõãmacʉ̃wiire cõãgʉ̃da” jĩĩmiwʉ̃rã. “Itiábʉreco siro apewií tiipetícojãgʉ̃da”, jĩĩmiwʉ̃rã mʉʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Teero jĩĩrigʉ mʉʉ basirora netõnéña. Curusapʉ tusagʉ́ diiátiya, jĩĩ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paiaré dutirácã, Moisés jóarigue buerámena teerora jĩĩ buijã́yira: —Cʉ̃ʉ̃ ãpẽrãcã́rẽ netõnéwĩ; cʉ̃ʉ̃ basirope netõnémasĩrii. ");
INSERT INTO tue_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cõãmacʉ̃ beserigʉ Cristo Israelya põna macãrã õpʉ̃ niigʉ̃jã, curusapʉ tusagʉ́ cʉ̃ʉ̃ basiro diiátiaro. Cʉ̃ʉ̃ basiro diiátiri docare, padeoáda, jĩĩyira. Cʉ̃ʉ̃mena curusapʉ páabianʉcõãriracã teerora cʉ̃ʉ̃rẽ ñañarõ jĩĩ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Coeritó jeari, niipetiro tiiditapʉ naĩtĩãjõãyiro. Tée ñamica tres niirĩpʉ naĩtĩãtuyiro. ");
INSERT INTO tue_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tii hora niirĩrã, Jesús bayiró acaribíyigʉ. —Eloi, Eloi, ¿lama sabactani? jĩĩyigʉ cʉ̃ʉ̃yemena. Teero jĩĩgʉ̃, “Cõãmacʉ̃, Cõãmacʉ̃, ¿deero tiigʉ́ yʉʉre cõãwai?” jĩĩgʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ãpẽrã́ sĩquẽrã toopʉ́ niirã́ teeré tʉorá, jĩĩyira: —¡Coe! Tʉoyá. Profeta Elíare sʉocógʉ tiiquí, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sĩcʉ̃ cʉtʉwá, sicasitia vino piyare soayígʉ. Sĩniã́rõ jĩĩgʉ̃, sicagʉ́ cãnʉgʉ̃pʉ siatú, cʉ̃ʉ̃rẽ súumʉõcogʉra, basocáre jĩĩmiyigʉ: —Coteya ména. Elías cʉ̃ʉ̃ curusapʉ tusagʉ́re néediocogʉ atiboqui, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús bayiró acaribí, diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cʉ̃ʉ̃ diari, Cõãmacʉ̃wii popeapʉ Ãñunetõjõãri Tatia cãmotáyosari casero ʉ̃mʉã́rõpe yigadiati, pʉacaséropʉ jeacotuariro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cien surara dutigʉ́ Jesús doca nucũgʉ̃́, cʉ̃ʉ̃ teero wáa diari ĩñagʉ̃, jĩĩyigʉ: —Diamacʉ̃́rã ãni Cõãmacʉ̃ macʉ̃ niimiãyi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Numiã́ yoaropʉ Jesuré ĩñanucũyira. Cʉ̃́ãmena niiyira: María Magdalena; apegó María (coo José cʉ̃ʉ̃ bai Santiago paco niiyigo); apegó Salomé niiyira. ");
INSERT INTO tue_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cʉ̃́ã Jesuré nʉnʉríra numiã niiyira. Cʉ̃ʉ̃ Galileapʉ niirĩ, cʉ̃ʉ̃rẽ ãñurõ tiiápurira niiyira. Ãpẽrã́ numiã paʉ Jesús Jerusalénpʉ wáari nʉnʉríracã toopʉ́ ĩñanucũyira. ");
INSERT INTO tue_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Judíoa yeerisãri bʉreco sʉguero macã bʉreco niiyiro. Teero tiiró, cʉ̃́ã yeerisãri bʉreco maquẽ quẽnorí bʉreco niiyiro. Náĩcũmurĩ, José Arimatea wãmecʉtiri macã macʉ̃ jeayigʉ. Cʉ̃ʉ̃ Judíoare Dutirá Peti menamacʉ̃ cʉ̃́ã padeogʉ́ niiyigʉ. Cʉ̃ʉ̃cã Cõãmacʉ̃ dutiré basocápʉre niiãdarere coteyigʉ. Teero tiigʉ́, cuiro manirṍ wãcũtutuaremena Pilato pʉtopʉ sããwayigʉ. Sããwa, Jesuyá õpʉ̃ʉ̃rẽ sãĩyígʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato Jesús diaariguere tʉogʉ́, tʉomaníjõãyigʉ. Cien surara dutigʉ́re atiduti, “¿deero biiri diaarĩ?” jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cien surara dutigʉ́ cʉ̃ʉ̃rẽ wedeari siro, Jesuyá õpʉ̃ʉ̃rẽ Joseré ticodutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José sutiró ãñurí caserore sãĩ, Jesuyá õpʉ̃ʉ̃rẽ néedioco, tiicaseromena cõmayígʉ. Túajea, sicatuti ʉ̃tãgãpʉ coari tutipʉ cṹũyigʉ. Tiitutire ʉ̃tãquicamena tuunéwa, biajã́yigʉ. ");
INSERT INTO tue_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, María (José paco) Jesuré cṹũãrirore ĩñayira. ");
INSERT INTO tue_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cʉ̃́ã yeerisãri bʉreco sábado netõã́ri siro, María Magdalena, María (Santiago paco), Salomé sitiaãñúre sãĩyíra. Teeména Jesuyá õpʉ̃ʉ̃rẽ píopeora wáara tiimíyira. ");
INSERT INTO tue_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ʉ̃sã yeerisãri bʉreco síro macã bʉreco niirĩ, ñamisãñurõgã Jesuré cṹũri tutipʉ wáayira. ");
INSERT INTO tue_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cʉ̃́ã toopʉ́ wáara, cãmerĩ́ sãĩñáyira: —¿Noã tuunécobosaadari tiituti biaríquicare? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Toopʉ́ jea, ĩñacora, tiiquicare aperopʉ́ nucũrĩ ĩñayira. Pairíquica peti niiyiro. ");
INSERT INTO tue_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tiitutipʉ sããwara, wãmo diamacʉ̃́niñape sĩcʉ̃ mamʉ duiri ĩñayira. Cʉ̃ʉ̃ sutiró butiró yoaroca sãñayigʉ. Cʉ̃́ã cʉ̃ʉ̃rẽ ĩñarã, bayiró ʉcʉáyira. ");
INSERT INTO tue_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: —Ʉcʉárijãña. Mʉ́ã Jesús Nazaret macã macʉ̃rẽ cʉ̃́ã curusapʉ páabiatu sĩãã́rigʉre ãmaãrã tiia. Cʉ̃ʉ̃ masãtoaawĩ. Ãnorẽ́ maniĩ. Cʉ̃ʉ̃rẽ cṹũãrirore ĩñarã atiya. ");
INSERT INTO tue_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cʉ̃ʉ̃ bueráre, Pedrore wedera wáaya: “Cʉ̃ʉ̃ mʉ́ã sʉguero Galileapʉ jeatoagʉdaqui. Cʉ̃ʉ̃ jĩĩrirobirora toopʉ́ cʉ̃ʉ̃rẽ ĩñaãdacu”, jĩĩwa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tiitutipʉ niiãrira ʉcʉá ñapõpirara dutijṍãyira. Cuira, ãpẽrãrẽ́ wederiyira. ");
INSERT INTO tue_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yeerisãri bʉreco niirĩ, Jesús cʉ̃ʉ̃ masããri siro, María Magdalenarẽ bauásʉgueyigʉ. Coorena too sʉgueropʉ siete wãtĩãrẽ cõãwionecoyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesuména wáanetõrirare wedego wáamiyigo. Cʉ̃ʉ̃rẽ booritua, utira tiiyíra. ");
INSERT INTO tue_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Jesús catiawĩ; yʉʉ cʉ̃ʉ̃rẽ ĩñaãwʉ̃, jĩĩmiyigo. Padeoríyira. ");
INSERT INTO tue_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Too síro Jesús pʉarã́ cʉ̃ʉ̃mena wáanetõãrirare bauáyigʉ cã́pũpʉ wáarare. Cʉ̃ʉ̃ ãpĩbíro biigʉ́ bauáyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cʉ̃́ã ãpẽrã́ Jesuména wáanetõãrirare wedera wáamiyira. Cʉ̃́ãcãrẽ padeoríyira. ");
INSERT INTO tue_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Too síro Jesús cʉ̃ʉ̃ buerá oncere bauáyigʉ cʉ̃́ã mesapʉ duiráre. Cʉ̃́ãrẽ jĩĩyigʉ: —¿Deero tiirá cʉ̃́ã wederi, yʉʉ masãré quetire tʉopacára, padeoríarĩ? Pairó wãcũtutuare cʉoría mʉ́ã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Niipetiropʉ niipetirare yʉʉ basocáre netõnére quetire wedera wáaya. ");
INSERT INTO tue_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yʉʉre padeó, wãmeõtinogʉ̃no netõnénogʉ̃daqui. Yʉʉre padeohégʉno ñañarõ tiinógʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Yʉʉre padeorá yʉʉ dutirémena wãtĩãrẽ cõãwionecomasĩãdacua. Ãpẽrãyére wedesemasĩripacara, wedeseadacua. Cʉ̃́ã ãñaãrẽ ñeerĩ, teero biiri pũniré sĩnirĩ́, merẽã wáaricu. Diaráre ñaapeóri, netõã́dacua. Yʉʉre padeorá cʉ̃́ã padeorére ẽñorã́, teeré tiimasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Marĩ Õpʉ̃ Jesús cʉ̃́ãrẽ wedeari siro, ʉ̃mʉã́sepʉ néecomʉãnoyigʉ. Cõãmacʉ̃ya wãmo diamacʉ̃́niñape jeanuãyigʉ. ");
INSERT INTO tue_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cʉ̃ʉ̃ buerá niipetiropʉ cʉ̃ʉ̃ netõnére quetire wedera wáawa. Cʉ̃́ã wederi, Jesús cʉ̃ʉ̃ basirora cʉ̃́ãrẽ tiiápurigʉ niiwĩ. Cʉ̃́ã wederére “diamacʉ̃́rã niiã” jĩĩgʉ̃, ãñurére cʉ̃́ãrẽ tiiẽ́ñorĩ tiirígʉ niiwĩ.");
INSERT INTO tue_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Niipetire ʉ̃sã watoapʉ wáariguere ĩñarira Jesús “wedera wáaya” jĩĩcorira ʉ̃sãrẽ buewa. Paʉ cʉ̃́ã buerirobirora jóanʉcãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yʉʉcã ate niipetire Jesús sicatopʉ tiinʉcã́riguere masĩpetidʉgagʉ ãñurõ buewʉ. Teero tiigʉ́, Teófilo, yʉʉ teeré jóaa, ");
INSERT INTO tue_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mʉʉrẽ ãpẽrã́ bueriguere “diamacʉ̃́rã niiã” jĩĩmasĩdutigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judea dita macãrã õpʉ̃ niiritore, sĩcʉ̃ pai Zacarías wãmecʉtigʉ niiyigʉ. Cʉ̃ʉ̃ Abíaya põna macʉ̃ niiyigʉ. Cʉ̃ʉ̃ nʉmo Isabel wãmecʉtiyigo. Coo Aarón pãrãmeõ niinʉnʉsego niiyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cʉ̃́ã pʉarã́pʉra Cõãmacʉ̃ ĩñacorore basocá ãñurã́ niiyira. Cʉ̃ʉ̃ dutirére ãñurõ tiiyíra. Teero tiirá, basocá cʉ̃́ãrẽ “wapa cʉoóya” jĩĩmasĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Cʉ̃́ã põnamaníyira. Isabel põnamanígõno niiyigo. Cʉ̃́ã bʉtoá niiyira. ");
INSERT INTO tue_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sicabʉreco Zacarías pai paderé padegʉ tiiyígʉ Cõãmacʉ̃wiipʉ. Cʉ̃ʉ̃ya põna macãrã paderé bʉrecori niiyiro. ");
INSERT INTO tue_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Paiá tiirucúrobirora sĩcʉ̃rẽ beseyira sitiaãñúre sóegʉdʉre. Tiibʉrecore Zacaríare beseyira. Teero tiigʉ́, cʉ̃ʉ̃pe Ãñurí Tatia pʉto macã tatiapʉ sóegʉ sããwayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sóeritono niirĩ, niipetira basocá sopepʉ́ Cõãmacʉ̃rẽ sãĩrã́ tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sĩcʉ̃ ángele cʉ̃ʉ̃rẽ bauáyigʉ. Cʉ̃ʉ̃ sóemʉõcoro diamacʉ̃́pe nucũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías cʉ̃ʉ̃rẽ ĩñagʉ̃, ʉcʉájõãyigʉ. Bayiró cuiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ángele cʉ̃ʉ̃rẽ jĩĩyigʉ: —Cuirijãña, Zacarías. Cõãmacʉ̃ mʉʉ sãĩrére tʉoi. Mʉʉ, mʉʉ nʉmo Isabelmena sĩcʉ̃ põnacʉtíadacu. Cʉ̃ʉ̃rẽ Juan wãme tuuya. ");
INSERT INTO tue_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mʉʉ cʉ̃ʉ̃mena bayiró ʉsenigʉ̃dacu. Paʉ cʉ̃ʉ̃ bauári, ʉseniãdacua. ");
INSERT INTO tue_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cõãmacʉ̃ ĩñacoropʉre bʉ́ri niigʉ̃́ mee niigʉ̃daqui. Vinorẽ, sibiorére sĩnirígʉdaqui. Cʉ̃ʉ̃ paco páatipʉra Espíritu Santo cʉ̃ʉ̃mena niitoagʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Paʉ Israelya põna macãrã Cõãmacʉ̃ cʉ̃́ã Õpʉ̃rẽ padeodúrirare padeorí tiigʉ́daqui sũcã. ");
INSERT INTO tue_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Marĩ Õpʉ̃ sʉguero jeagʉdaqui. Elías tiiróbiro Espíritu Santo tutuare cʉogʉ́daqui. Teeména pacʉsʉ̃mʉãrẽ cʉ̃́ã põnamena ãñurõ niirecʉtiri tiigʉ́daqui. Netõnʉcã́rãrẽ basocá ãñurã́ tiiróbiro wãcũrĩ tiigʉ́daqui. Basocáre “marĩ Õpʉ̃rẽ ãñurõ niiyueya” jĩĩgʉ̃daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Cʉ̃ʉ̃ teero jĩĩrĩ, Zacarías sãĩñáyigʉ: —¿Deero tii yʉʉ masĩgʉ̃dari mʉʉ yʉʉre jĩĩrére? Yʉʉ bʉcʉ niiã. Yʉʉ nʉmocã bʉcʉó niiyo, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángele cʉ̃ʉ̃rẽ yʉʉyigʉ: —Yʉʉ Gabriel niiã Cõãmacʉ̃ pʉto macʉ̃. Cʉ̃ʉ̃ yʉʉre ticodiocoawĩ, mʉʉrẽ queti wededutigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yʉʉ jĩĩrére mʉʉ padeoría. Teero tiigʉ́, wedesemasĩhẽgʉ̃ pʉtʉágʉdacu. Yʉʉ jĩĩrõbirora wáaadacu. Tee niipetire wáari siropʉ, wedesegʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cʉ̃́ã wedesera tiirí, basocápe Zacaríare yuera tiiyíra. Cʉ̃ʉ̃ Cõãmacʉ̃wiipʉ pearí, ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cʉ̃ʉ̃ witijeagʉ, wedesemasĩriyigʉ. “Cõãmacʉ̃wiipʉ apeyenó cʉ̃ʉ̃rẽ bauáajĩyu”, jĩĩyira. Wãmorĩmena cʉ̃́ãrẽ wẽ́ẽtuyigʉ. Wedesemasĩhẽgʉ̃ pʉtʉáyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Paiá paderé bʉrecori petirí, cʉ̃ʉ̃ya wiipʉ coecópʉtʉayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Too síro cʉ̃ʉ̃ nʉmo Isabel niipacó niinʉcãyigo. Sicamoquẽñe muĩpũrã “wiipʉ́ niijãgõda” jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Coo wãcũyigo: “Cõãmacʉ̃ yʉʉ põnamanígõ niiãrigore tiiápuawĩ. Basocá teero ĩñacõãrĩ jĩĩgʉ̃, yʉʉre ãñurõ tiii”, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis muĩpũrã Isabel niipacó niirṍ netõyíro. Cõãmacʉ̃ ángele Gabrielre Nazaretpʉ ticodiocoyigʉ. Nazaret Galilea ditapʉ niiã. ");
INSERT INTO tue_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sĩcõ ʉ̃mʉmena niiñahẽgõrẽ queti wededutiyigʉ. Õpʉ̃ David pãrãmi niinʉnʉsegʉmena José wãmecʉtigʉmena wãmosíagodo tiiyígo. Coo wãmecʉtiyigo María. ");
INSERT INTO tue_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángele coo niirṍpʉ sããwa, ãñudutiyigʉ: —Sã́ã. ¿Niiĩ mʉʉ? Marĩ Õpʉ̃ mʉʉrẽ “ãñurõ tiigʉ́da” jĩĩãwĩ. Cʉ̃ʉ̃ mʉʉmena niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ángele jĩĩrére tʉogó, bayiró wãcũyigo. “¿Deero jĩĩdʉgaro tiigári cʉ̃ʉ̃ ãñudutire?” jĩĩ wãcũyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ángele jĩĩyigʉ: —Cuirijãña, María. Mʉʉ Cõãmacʉ̃ ãñurõ tiirére bʉaa. ");
INSERT INTO tue_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Teero tiigó, mʉʉ niipacó pʉtʉágodacu. Sĩcʉ̃ põnacʉtígodacu. Cʉ̃ʉ̃ wãmecʉtigʉdaqui Jesús. ");
INSERT INTO tue_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cʉ̃ʉ̃ ãpẽrã́ nemorṍ ʉpʉtí macʉ̃ niigʉ̃daqui. “Cõãmacʉ̃ ʉ̃mʉã́se niigʉ̃́ macʉ̃ niiĩ”, jĩĩnogʉ̃daqui. Õpʉ̃ David cʉ̃ʉ̃ ñecʉ̃ niisotoapeogʉre tiirírobiro Cõãmacʉ̃ cʉ̃ʉ̃rẽ Õpʉ̃ cṹũgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israelya põna macãrãrẽ dutirucujãgʉ̃daqui. Cʉ̃ʉ̃ dutiré petirícu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María ángelere sãĩñáyigo: —¿Deero wáabogari ate? Yʉʉ manʉ manigṍ niiã, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángele coore yʉʉyigʉ: —Espíritu Santo mʉʉpʉre diijeágʉdaqui. Cõãmacʉ̃ ʉ̃mʉã́se macʉ̃ tutuare mʉʉpʉre õmebʉrʉá tiiróbiro diiáti, tuubiáadacu. Teero tiigʉ́, mʉʉ macʉ̃ ãñugʉ̃́ “Cõãmacʉ̃ macʉ̃ niiĩ” jĩĩnogʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mʉʉya wedego Isabel sĩcʉ̃ põnacʉtígodaco, bʉcʉó niipaco. “Põnamanígõno niiyo”, jĩĩmiwã basocá. Seis muĩpũrã wáaa, coo wĩmʉ bʉaári siro. ");
INSERT INTO tue_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cõãmacʉ̃rẽ tiimasĩ́hẽreno maniã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María jĩĩyigo: —Yʉʉ Cõãmacʉ̃rẽ padecotego niiã. Cõãmacʉ̃ mʉʉ jĩĩrõbirora yʉʉre tiiáro, jĩĩyigo. Ángele coo pʉto niiãrigʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Teebʉrecorire María boyeromena wáajõãyigo Judea ditapʉ. Ʉ̃tãyucʉ watoa niirí macãpʉ jeayigo. ");
INSERT INTO tue_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Toopʉ́ jea, Zacaríaya wiipʉ sããwa, Isabelre ãñudutiyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tee ãñudutire tʉorí, coo macʉ̃ páatipʉ sãñagʉ̃́ cãmeñayigʉ. Isabelmena Espíritu Santo niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Teero tiigó, coo bayiró bʉsʉrémena wedeseyigo: —Niipetira numiã nemorṍ Cõãmacʉ̃ mʉʉrẽ ãñurõ tiii. Mʉʉ macʉ̃cãrẽ ãñurõ tiii. ");
INSERT INTO tue_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yʉʉ bʉ́ri niigṍ niipacari, mʉʉ yʉʉ Õpʉ̃ paco yʉʉre ĩñagõ atiayu. ");
INSERT INTO tue_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yʉʉ mʉʉ ãñudutirere tʉorí, yʉʉ macʉ̃ páatipʉ sãñagʉ̃́ ʉseniremena cãmeñaãti. ");
INSERT INTO tue_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cõãmacʉ̃ mʉʉrẽ jĩĩrirobirora “wáaadacu” jĩĩ padeoyú mʉʉ. Ateména Cõãmacʉ̃ mʉʉrẽ ʉsenirĩ tiiquí, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María jĩĩyigo: “Yʉʉ Õpʉ̃rẽ ‘ãñuniã mʉʉ’ jĩĩ, ʉsenire ticoa. ");
INSERT INTO tue_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cõãmacʉ̃ yʉʉre netõnégʉ̃mena bayiró ʉsenigõ niiã. ");
INSERT INTO tue_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yʉʉ bʉ́ri niigṍrẽ Cõãmacʉ̃ beseyi. Mecʉ̃ãmena niipetira yʉʉre ‘Cõãmacʉ̃ ãñurõ tiiyí coore’ jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Cõãmacʉ̃ niipetire tiimasĩ́gʉ̃ yʉʉre ãñurére tiiyí. Cʉ̃ʉ̃ ãñuré dícʉre tiiquí. ");
INSERT INTO tue_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Cʉ̃ʉ̃rẽ quioníremena ĩñarã́rẽ bóaneõrucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cʉ̃ʉ̃ tutuaremena pee ãñuré tiii. Basocá ‘ʉ̃sã ãpẽrã́ nemorṍ niiã’ jĩĩ wãcũrã́rẽ cõãjãqui. ");
INSERT INTO tue_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Õpãrã́ duirépĩrĩpʉ duiráre cõãjãqui. Bʉ́ri niirã́pere ʉpʉtí macãrã niirĩ tiiquí. ");
INSERT INTO tue_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jʉabóarare pee ãñuré ticoqui. Pee cʉoráre ticoripacʉ, pʉtʉawadutiqui. ");
INSERT INTO tue_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israelya põna macãrã cʉ̃ʉ̃rẽ padecoterare tiiápuqui. Cʉ̃́ãrẽ wãcũjĩgʉ̃, bóaneõqui. ");
INSERT INTO tue_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Marĩ ñecʉ̃ Abrahamrẽ, teero biiri niipetira cʉ̃ʉ̃ pãrãmérã niinʉnʉserare ‘tiiápugʉda’ jĩĩrigʉ niiwĩ”, jĩĩyigo María. ");
INSERT INTO tue_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María ĩtĩã́rã muĩpũrã coo pʉtopʉ pʉtʉáyigo. Too síro cooya wiipʉ coecópʉtʉayigo. ");
INSERT INTO tue_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabel põnacʉtírito jeari, coo macʉ̃ bauáyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cooya wii pʉto niirã́, cooya wedera Cõãmacʉ̃ coore ãñurõ bóaneõrigue quetire tʉorá, coore ʉseniapuyira. ");
INSERT INTO tue_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho bʉrecori cʉ̃ʉ̃ bauári siro, cʉ̃ʉ̃ cõnerígʉ yapa macã caseróre widecõã́rã jeayira. Cʉ̃ʉ̃ pacʉ tiiróbiro Zacarías tuudʉgamiyira. ");
INSERT INTO tue_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cʉ̃ʉ̃ paco cʉ̃́ãrẽ jĩĩyigo: —Niiria. Cʉ̃ʉ̃ Juan wãmecʉtigʉdaqui, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cʉ̃́ãpe: —Mʉʉya wedera teero wãmecʉtira maniĩ́ya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cʉ̃ʉ̃ pacʉre wãme sãĩñárã, wẽ́ẽtuyira. ");
INSERT INTO tue_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Cʉ̃ʉ̃pe sicapĩ jóaripĩ sãĩyígʉ. Tiipĩpʉ “Juan wãmecʉtigʉdaqui” jĩĩ jóayigʉ. Niipetira teeré ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Máata Zacarías wedesejõãyigʉ sũcã. Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cʉ̃ʉ̃ teero tiirí, cʉ̃́ãya macã pʉto niirã́ cuipetijõãyira. Niipetiro too Judea dita ʉ̃tãyucʉ watoapʉ macãrã teero wáariguere wedeseyira. ");
INSERT INTO tue_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Niipetira teeré tʉorá bayiró wãcũyira. —Cʉ̃ʉ̃ wĩmagʉ̃ bʉcʉ niigʉ̃, ¿deero niigʉ̃́no niigʉ̃dari? jĩĩyira. Cõãmacʉ̃ tutuare Juanména niiyiro. ");
INSERT INTO tue_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cʉ̃ʉ̃ pacʉ Zacaríamena Espíritu Santo niiyigʉ. Teero tiigʉ́, Cõãmacʉ̃ wededutirere wedeyigʉ. Biiro jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cõãmacʉ̃rẽ ʉsenire ticoco. Cʉ̃ʉ̃ marĩ Israelya põna macãrã Õpʉ̃ niiĩ. Marĩ cʉ̃ʉ̃ beserirare netõnégʉ̃ atii. Marĩrẽ tiiápurucujãĩ mée. ");
INSERT INTO tue_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Marĩrẽ netõnégʉ̃dʉ tutuagʉre ticodiocoqui. David cʉ̃ʉ̃rẽ padecotegʉ pãrãmi niinʉnʉsegʉ niiqui. ");
INSERT INTO tue_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tíatopʉ ‘teero tiigʉ́da’ jĩĩyigʉ. Teeré profetas ãñurã́ jóarira niiwã. ");
INSERT INTO tue_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Cõãmacʉ̃ niipetira marĩ wãpãrãrẽ, marĩrẽ ĩñatutirare cãmotá, marĩrẽ netõnébosagʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Marĩ ñecʉ̃sʉ̃mʉãrẽ ‘mʉ́ãrẽ bóaneõgʉ̃da’ jĩĩyigʉ. Cʉ̃́ãrẽ ‘ãñurõ tiigʉ́da mʉ́ãrẽ’ jĩĩrigue ãñurére acabóriqui. ");
INSERT INTO tue_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Cõãmacʉ̃ too síro tiiádarere wedeyigʉ Abraham marĩ ñecʉ̃rẽ. ‘Biiro tiigʉ́da’ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Mʉ́ãrẽ ĩñatutirare cãmotá, mʉ́ãrẽ netõnébosagʉdacu. Yʉʉ teero tiirí, mʉ́ã cuiro manirṍ yʉʉ dutirére tiimasĩ́ãdacu. ");
INSERT INTO tue_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Bʉ́recoricõrõ yʉʉ ĩñacoropʉ ãñuré tiiádacu’, jĩĩyigʉ Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Macʉ̃, mʉʉrẽ basocá ‘Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́yagʉ profeta niiĩ’ jĩĩãdacua. Mʉʉ marĩ Õpʉ̃ atiadari sʉguero, maarẽ quẽnosʉguérobirora quẽnosʉguégʉ niigʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mʉʉ Cõãmacʉ̃ beserirare cʉ̃́ã ñañaré tiirére Cõãmacʉ̃rẽ acabóre sãĩdutígʉdacu. Teeména Cõãmacʉ̃ netõnérere cʉ̃́ãrẽ masĩrĩ tiigʉ́dacu. ");
INSERT INTO tue_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cõãmacʉ̃ marĩrẽ bóaneõremena ĩñagʉ̃́ niijĩgʉ̃, marĩrẽ netõnégʉ̃dʉre ticodiocogʉdaqui. Muĩpũ mʉãatiro tiiróbiro niigʉ̃daqui cʉ̃ʉ̃ marĩrẽ. ");
INSERT INTO tue_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Marĩ naĩtĩãrõpʉ niirã́biro niiã. Pecamepʉ wáaborira niiã. Cʉ̃ʉ̃ bóecoremena marĩrẽ ãñurõ niirecʉtire ẽñogʉ̃́daqui”, jĩĩyigʉ Zacarías. ");
INSERT INTO tue_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wĩmagʉ̃ bʉcʉájõãyigʉ. Jõõpemena Cõãmacʉ̃rẽ padeomʉ́ãnʉcãyigʉ. Basocá manirṍpʉ niisodeaatiyigʉ. Toopʉ́re niituyigʉ, tée Israelya põna macãrãrẽ cʉ̃ʉ̃ wedenʉcãritopʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tíatore niipetira romanuã õpʉ̃ Augusto basocáre bapaqueogʉdʉ, cʉ̃́ã wãmerẽ jóatudutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cirenio niirito, sicato jóature niinʉcãyiro. Cirenio Siria dita dutigʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Niipetirare cʉ̃́ã ñecʉ̃sʉ̃mʉã bauáre macãrĩpʉ jóatura wáadutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Teero tiigʉ́, José, Nazaret Galilea ditapʉ niiãrigʉ, Belén Judea ditapʉ wáayigʉ. Cʉ̃ʉ̃ ñecʉ̃ David Belénpʉ bauáyigʉ. Cʉ̃ʉ̃ David pãrãmi niinʉnʉsegʉ niijĩgʉ̃, toopʉ́ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cʉ̃ʉ̃mena cʉ̃ʉ̃ wãmosíagodo María wáayigo. Niipacó niiyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cʉ̃́ã Belénpʉ niirĩ, María põnacʉtíre bʉrecori jeayiro. ");
INSERT INTO tue_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toopʉ́re cʉ̃́ã cãnirí wii bʉaríyira. Teero tiirá, ecará cãnirí wiipʉ wáayira. Toopʉ́ coo sicato wĩmagʉ̃ apayigo. Cʉ̃ʉ̃rẽ suti caserimena cõma, ecará yaarícoropʉ sã́ãyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén wesapʉ oveja coterí basoca niiyira. Cã́pũpʉ cʉ̃́ãyarare coteboejõãrucuyira. ");
INSERT INTO tue_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wãcũña manirṍ cʉ̃́ãrẽ sĩcʉ̃ ángele bauáyigʉ. Cõãmacʉ̃ asibatére cʉ̃́ã pʉtopʉ ãñurõ bóesesajõãyiro. Bayiró cuiyira. ");
INSERT INTO tue_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ángele cʉ̃́ãrẽ jĩĩyigʉ: —Cuirijãña. Mʉ́ãrẽ ãñuré queti wedegʉ atia. Niipetira tee quetire tʉorá, ʉseniãdacua. ");
INSERT INTO tue_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mecʉ̃ã ñami Daviyá macã Belénpʉ mʉ́ãrẽ netõnégʉ̃dʉ bauáawĩ. Cʉ̃ʉ̃ Cõãmacʉ̃ beserigʉ Cristo marĩ Õpʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cʉ̃ʉ̃ wĩmagʉ̃rẽ suti caserimena cõmaã́rigʉre bʉajeáadacu. Wáicʉra yaarícoropʉ sãñagʉ̃́rẽ ĩñaãdacu. Mʉ́ã teeré ĩñarã, “diamacʉ̃́rã wedeayi” jĩĩãdacu, jĩĩyigʉ ángele. ");
INSERT INTO tue_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wãcũña manirṍ cʉ̃ʉ̃ pʉto paʉ ángelea bauáyira. Cʉ̃́ã Cõãmacʉ̃rẽ ʉsenire ticora, biiro jĩĩyira: ");
INSERT INTO tue_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ʉ̃mʉã́sepʉ niirã́ Cõãmacʉ̃rẽ ‘ãñunetõjõãĩ’ jĩĩ, ʉsenire ticoaro. Atiditapʉ́re cʉ̃ʉ̃ ãñurõ tiinórã ãñurõ niirecʉtiaro”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ángelea cʉ̃́ãmena niiãrira ʉ̃mʉã́sepʉ mʉãwaari siro, oveja coterí basoca cãmerĩ́ wedeseyira: —Jãmʉ too docare Belénpʉ. Toopʉ́ wáaariguere Cõãmacʉ̃ marĩrẽ wededutiariguere ĩñaco, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Teero tiirá, boyeromena macãpʉ piyayira. Toopʉ́ piyajeara, María, Joseré bʉajeáyira. Wĩmagʉ̃rẽ wáicʉra yaarícoropʉ sãñagʉ̃́rẽ ĩñayira. ");
INSERT INTO tue_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cʉ̃ʉ̃rẽ ĩñaãri siro, ángele wĩmagʉ̃ maquẽrẽ wedeariguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Niipetira cʉ̃́ã wederére tʉorá, tʉomaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríape tee niipetirere coo wãcũrépʉ ĩñanoyigo. Bayiró teeré wãcũyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oveja coterí basoca cʉ̃́ã tʉoárigue, cʉ̃́ã ĩñaãrigue ángele wedearirobiro wáayiro. Teero tiirá, Cõãmacʉ̃rẽ ʉsenire tico, “cʉ̃ʉ̃ ãñunetõjõãĩ” jĩĩ wedesepʉtʉayira. ");
INSERT INTO tue_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesús bauári siro, ocho bʉrecori netõrĩ́, cʉ̃ʉ̃ cõnerígʉ yapa macã caseróre widecõã́yira. Cʉ̃ʉ̃rẽ Jesús wãme tuuyira. Tiiwãmerẽ ángele Maríare, coo niipacó niiãdari sʉgueropʉ, tuudutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Coo põnacʉtíari siro, Moisére dutiré cṹũrigue jĩĩrõbirora cuarenta bʉrecori yueyira. Too síro wĩmagʉ̃rẽ Jerusalénpʉ néewayira. Toopʉ́ Cõãmacʉ̃rẽ “mʉʉyagʉ niiĩ” jĩĩ ẽñorã́ wáayira. ");
INSERT INTO tue_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“Niipetira ʉ̃mʉã bauásʉguera Cõãmacʉ̃yara niirõ booa”, jĩĩ jóanoã Cõãmacʉ̃ye queti jóaripũpʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tiipũpʉ jóarirobirora pʉarã́ buabiro baurá o pʉarã́ bua wĩmarã Cõãmacʉ̃rẽ ticoadara wáayira. ");
INSERT INTO tue_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Teebʉrecorire sĩcʉ̃ Simeón wãmecʉtigʉ Jerusalénpʉ niiyigʉ. Cʉ̃ʉ̃ basocʉ́ ãñugʉ̃́, Cõãmacʉ̃rẽ padeogʉ́ niiyigʉ. Israelya põna macãrãrẽ netõnégʉ̃dʉre yuegʉ tiiyígʉ. Espíritu Santo Simeónmena niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Cʉ̃ʉ̃ cʉ̃ʉ̃rẽ wedetoayigʉ: “Cristo Cõãmacʉ̃ beserigʉre ĩñaripacʉ, mʉʉ diaricu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santo masĩrĩ tiirémena Cõãmacʉ̃wiipʉ sããwayigʉ. Jesús pacʉsʉ̃mʉã cʉ̃ʉ̃gãrẽ néesãwayira, Moisére dutiré cṹũriguepʉ jóarirobirora cʉ̃ʉ̃rẽ tiibosára. ");
INSERT INTO tue_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Néesãwari, Simeón cʉ̃ʉ̃rẽ néeapayigʉ. Néeapa, Cõãmacʉ̃rẽ ʉsenire ticogʉ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yʉʉ Õpʉ̃, mʉʉ yʉʉre wederirobirora tiia mecʉ̃tígãrẽ. Teero tiigʉ́, yʉʉ mʉʉrẽ padecotegʉ ʉseniremena diamasĩã. ");
INSERT INTO tue_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ãni basocáre netõnégʉ̃dʉre yʉʉ capearimena ĩñatoaa. ");
INSERT INTO tue_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mʉʉ ãnirẽ́ ticodiocoayu, niipetira basocá masĩãrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ãni sĩãwócogʉ tiiróbiro niigʉ̃daqui, judíoa niihẽrã diamacʉ̃́ maquẽrẽ masĩãrõ jĩĩgʉ̃. Niipetira mʉʉyara Israelya põna macãrãrẽ ‘Cõãmacʉ̃ marĩrẽ ãñurõ tiiáwĩ’ jĩĩrĩ tiigʉ́daqui”, jĩĩyigʉ Simeón. ");
INSERT INTO tue_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, Jesús pacʉ, paco tʉomaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón cʉ̃́ãrẽ: —Cõãmacʉ̃ mʉ́ãrẽ ãñurõ tiiáro, jĩĩyigʉ. María Jesús pacore jĩĩyigʉ: —Tʉoyá. Cõãmacʉ̃ ãni wĩmagʉ̃mena paʉ Israelya põna macãrãrẽ cõãrĩ tiigʉ́daqui; ãpẽrãrẽ́ cʉ̃ʉ̃mena netõnégʉ̃daqui. Paʉ cʉ̃ʉ̃rẽ ñañarõ jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Teero tiirémena paʉ wãcũrére masĩnoãdacu. Mʉʉpe espadamena sadero tiiróbiro pũniré tʉgueñagõdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Toopʉ́ sĩcõ profeta niiyigo. Coo Ana wãmecʉtiyigo. Fanuel macõ, Aserya põna macõ niiyigo. Bʉcʉó peti niiyigo. Mamo niigõ, wãmosíayigo. Coo wãmosíari siro, siete cʉ̃marĩ coo manʉmena niiyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cʉ̃ʉ̃ diari siro, wapewio niirucuyigo. Ochenta y cuatro cʉ̃marĩ cʉoyígo. Cõãmacʉ̃wiipʉre witiriyigo. Toopʉ́ ñamirĩ́, bʉ́recori beti, súubuseyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón Maríare, Joseré wedeseri, Ana jeayigo. Jesuré ĩña, Cõãmacʉ̃rẽ ʉsenire ticoyigo. Too síro niipetira Jerusalén macãrã basocáre netõnégʉ̃dʉre coteráre Jesuyé maquẽrẽ wedeyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cʉ̃́ã niipetire Cõãmacʉ̃ dutirére tiitóa, cʉ̃́ãya macã Nazaret Galilea ditapʉ coecópʉtʉayira. ");
INSERT INTO tue_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wĩmagʉ̃ masãyigʉ tutuagʉ, masĩgʉ̃́. Cõãmacʉ̃ cʉ̃ʉ̃rẽ ãñurõ tiiápuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús pacʉsʉ̃mʉã cʉ̃marĩcṍrõ Pascua bosebʉreco niirĩ, Jerusalénpʉ wáarucuyira. ");
INSERT INTO tue_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce cʉ̃marĩ cʉorí, cʉ̃́ã tiirucúrobirora toopʉ́ wáayira. ");
INSERT INTO tue_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bosebʉreco petirí, cʉ̃́ãya macãpʉ coecópʉtʉamiyira. Cʉ̃ʉ̃ pacʉsʉ̃mʉã masĩrõ manirṍ Jesús Jerusalénpʉ pʉtʉájãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cʉ̃́ã Jesuré “ãpẽrã́ marĩ menamacãrãmena wáaqui” jĩĩ wãcũrã, sicabʉreco maapʉre wáayira. Too síro cʉ̃́ãya wedera, cʉ̃́ã ĩñamasĩrã watoapʉ cʉ̃ʉ̃rẽ ãmaãmiyira. ");
INSERT INTO tue_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bʉaríyira. Teero tiirá, cʉ̃ʉ̃rẽ ãmaãrã, Jerusalénpʉ cãmecópʉtʉayira. ");
INSERT INTO tue_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Itiábʉreco siro Cõãmacʉ̃wiipʉ cʉ̃ʉ̃rẽ bʉayíra. Cʉ̃ʉ̃ judíoare buerá watoapʉ duiyigʉ. Cʉ̃ʉ̃ cʉ̃́ãrẽ tʉo, sãĩñágʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Niipetira cʉ̃ʉ̃rẽ tʉorá, cʉ̃ʉ̃ masĩrére, cʉ̃ʉ̃ yʉʉmenirere tʉomaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cʉ̃ʉ̃rẽ ĩñarã, cʉ̃ʉ̃ pacʉsʉ̃mʉã ĩñamanijõãyira. Cʉ̃ʉ̃ paco cʉ̃ʉ̃rẽ jĩĩyigo: —Macʉ̃, ¿deero tiigʉ́ teero tiiárĩ mʉʉ ʉ̃sãrẽ? Mʉʉ pacʉ, yʉʉ bayiró wãcũrémena mʉʉrẽ ãmaãwʉ̃, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —¿Deero tiirá yʉʉre ãmaãrĩ? “Yʉʉ Pacʉya wiipʉ, cʉ̃ʉ̃yere tiiró booa” jĩĩrére ¿mʉ́ã masĩriarĩ? ");
INSERT INTO tue_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩrére tʉomasĩ́riyira. ");
INSERT INTO tue_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Too síro cʉ̃́ãmena wáa, Nazaretpʉ pʉtʉawayigʉ. Cʉ̃́ãrẽ ãñurõ yʉʉrucuyigʉ. Cʉ̃ʉ̃ paco tee niipetirere coo wãcũrépʉ ãñurõ ĩñanoyigo. ");
INSERT INTO tue_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús nemorṍ masĩgʉ̃́, nemorṍ ʉ̃mʉã́gʉ̃ wáayigʉ. Cõãmacʉ̃ cʉ̃ʉ̃rẽ “ãñuniĩ” jĩĩ ĩñayigʉ. Basocácã cʉ̃ʉ̃rẽ ãñurõ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quince cʉ̃marĩ Tiberio romanuã õpʉ̃ niirĩ, noquẽrã cʉ̃ʉ̃rẽ duticotera niiyira: Poncio Pilato Judea dita dutigʉ́ niiyigʉ; Herodes Galilea dita dutigʉ́ niiyigʉ; Herodes bai Felipe Iturea, Traconite dita dutigʉ́ niiyigʉ; Lisanias Abilinia dita dutigʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás paiaré dutirá niiyira. Cʉ̃́ã niipetira niirito, Juan Zacarías macʉ̃ basocá manirṍpʉ niiyigʉ. Toopʉ́ Cõãmacʉ̃ cʉ̃ʉ̃yere wededutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan día Jordán wesa niipetiropʉ wáayigʉ. Basocáre wedeyigʉ: —Mʉ́ã ñañaré tiirére wãcũpati, waso, wãmeõtidutiya. Teero tiirí, Cõãmacʉ̃ mʉ́ã ñañaré tiirére acabógʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Profeta Isaías cʉ̃ʉ̃ jóaripũpʉ ateré jóarigʉ niiwĩ: Sĩcʉ̃ yucʉ manirṍ, basocá manirṍpʉ bayiró bʉsʉrómena wedegʉdaqui: “Sĩcʉ̃ õpʉ̃ atiadarimarẽ quẽnarõ tiiróbiro, marĩ Õpʉ̃ atiadari sʉguero, mʉ́ã ñañaré tiirére duujã́, ãñurõ niiyueya. ");
INSERT INTO tue_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Niipetire ditatʉdiri yaajã́, sĩcãrĩbíro tiinóãdacu. Niipetire ʉ̃tãyucʉ ãñuri yepa tiinóãdacu. Maapã́rĩrẽ diamacʉ̃́ tiinóãdacu. Maapã́rĩ maquẽ coperire yaanóãdacu. ");
INSERT INTO tue_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Niipetira Cõãmacʉ̃ basocáre netõnérere ĩñaãdacua”, jĩĩgʉ̃daqui, jĩĩ jóayigʉ Isaías. ");
INSERT INTO tue_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Paʉ basocá Juan pʉtopʉ cʉ̃ʉ̃rẽ wãmeõtidutira wáayira. Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: —¡Mʉ́ã tiiditórepira, jĩĩditorepira niiã! “Marĩ wãmeõtinorira dícʉ niirĩ, Cõãmacʉ̃ bayiró cúare marĩrẽ jearicu”, jĩĩ wãcũremena atimiãjĩyu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Diamacʉ̃́rã mʉ́ã ñañaré tiirére wãcũpati, wasorá, mʉ́ã ãñurõ tiirécʉtiremena ẽñoñá. “Ʉ̃sã Abraham pãrãmerã niinʉnʉsera niijĩrã, Cõãmacʉ̃ ĩñacorore ãñurã́ niiã”, jĩĩ wãcũrijãña. Mʉ́ã wãcũrére wasohéri, Abraham pãrãmerã niiré wapamaníã. Cõãmacʉ̃ boogʉ́, ate ʉ̃tãperimenarã Abraham pãrãmerãrã cotowéomasĩqui. ");
INSERT INTO tue_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mʉ́ã ñañaré tiidúheri ĩñagʉ̃, Cõãmacʉ̃ mʉ́ãrẽ cõãgʉ̃daqui. Sicagʉ́ yucʉgʉ ñañaré dʉcacʉtirigʉre cõmeãmena nʉcõrĩmenapʉra páata, pecamepʉ sóecõãrõ tiiróbiro mʉ́ãrẽ tiigʉ́daqui, jĩĩyigʉ Juan. ");
INSERT INTO tue_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Basocá cʉ̃ʉ̃rẽ sãĩñáyira: —¿Too docare deero tiiádari? ");
INSERT INTO tue_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Cʉ̃́ãrẽ yʉʉyigʉ: —Pʉaró sutiró cʉogʉ́ cʉohégʉre sicaró ticoaro. Yaaré cʉogʉ́ yaaré cʉohégʉre ticoaro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Romanuã õpʉ̃rẽ niyeru wapasébosari basocacã wãmeõtidutira jeayira. Cʉ̃ʉ̃rẽ sãĩñáyira: —Ʉ̃sãrẽ buegʉ́, ¿ʉ̃sã deero tiiádari? ");
INSERT INTO tue_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Cʉ̃́ãrẽ yʉʉyigʉ: —Romanuã cʉ̃́ã wapasé dutirobirora wapaséya. Nemorṍ wapasérijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suraracã cʉ̃ʉ̃rẽ sãĩñáyira: —¿Ʉ̃sãte deero tiiádari? Cʉ̃́ãrẽ yʉʉyigʉ: —Basocáre cuiri tiiríjãña. Jĩĩditoremena wedesãrijãña, cʉ̃́ãyere ẽmadʉgara. Mʉ́ã wapatáremena ʉseniña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Basocá Cõãmacʉ̃ beserigʉre yuera tiiyíra. “Apetó tiigʉ́, Juan Cristo marĩ yoari yuerigʉ niiboqui”, jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan cʉ̃́ã wãcũrére yʉʉyigʉ: —Yʉʉ mʉ́ãrẽ ocoména wãmeõtia. Ãpĩ yʉʉ nemorṍ tutuagʉ atigʉdaqui. Cʉ̃ʉ̃ ãñunetõgʉ̃ niiqui. Yʉʉpeja cʉ̃ʉ̃rẽ sĩcãrĩbíridojãcu. Cʉ̃ʉ̃peja nemorṍ ãñurõ tiigʉ́daqui mʉ́ãrẽ: Espíritu Santore ticodiocogʉdaqui, mʉ́ãmena niirucujããrõ jĩĩgʉ̃. Ñañarére sóecõãrõ tiiróbiro mʉ́ã ñañaré tiirére cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cʉ̃ʉ̃ trigore ĩñanogʉ̃dʉ tiiróbiro niiĩ. Teeperire merẽã, teesatirire merẽã cṹũgʉ̃daqui. Teeperire ĩñanogʉ̃daqui cʉ̃ʉ̃ye ĩñanori wiipʉ. Teesatirire sóejãgʉ̃daqui pecame yatiherimepʉ, jĩĩyigʉ Juan. ");
INSERT INTO tue_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pee cʉ̃ʉ̃ teero jĩĩ wederémena ãñuré quetire wedenemoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Teebʉrecorire Herodes Galilea dita dutigʉ́ niiyigʉ. Cʉ̃ʉ̃ bai nʉmorẽ ẽma, nʉmocʉtiyigʉ. Coo wãmecʉtiyigo Herodías. Cʉ̃ʉ̃ teero tiiré wapa apeyé pee cʉ̃ʉ̃ ñañaré tiiré wapa Juan cʉ̃ʉ̃rẽ tutirémena wedemiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes teeré tʉogʉ́, ñañaré tiinemóyigʉ: Juanrẽ́ peresuwiipʉ sõnecodutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan, cʉ̃ʉ̃rẽ peresuwiipʉ sõnecoadari sʉguero, paʉ basocáre wãmeõtiyigʉ. Jesucã́rẽ wãmeõtiyigʉ. Wãmeõtiari sirogã, Jesús Cõãmacʉ̃rẽ ʉsenire ticori, ʉ̃mʉã́se pã́õyiro. ");
INSERT INTO tue_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Santo sĩcʉ̃ bua tiiróbiro baugʉ́ cʉ̃ʉ̃pʉre diijeáyigʉ. Teero wáari, ʉ̃mʉã́sepʉ wedeseri tʉoyíra: —Mʉʉ yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́ niiã. Mʉʉmena bayiró ʉseniã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús basocáre buenʉcãgʉ̃, treinta cʉ̃marĩ cʉoyígʉ. Basocá cʉ̃ʉ̃rẽ “José macʉ̃ niiĩ” jĩĩ wãcũmiyira. José Elí macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat macʉ̃ niiyigʉ. Matat Leví macʉ̃ niiyigʉ. Leví Melqui macʉ̃ niiyigʉ. Melqui Jana macʉ̃ niiyigʉ. Jana José macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías macʉ̃ niiyigʉ. Matatías Amós macʉ̃ niiyigʉ. Amós Nahúm macʉ̃ niiyigʉ. Nahúm Esli macʉ̃ niiyigʉ. Esli Nagai macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat macʉ̃ niiyigʉ. Maat Matatías macʉ̃ niiyigʉ. Matatías Semei macʉ̃ niiyigʉ. Semei Josec macʉ̃ niiyigʉ. Josec Judá macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán macʉ̃ niiyigʉ. Joanán Resa macʉ̃ niiyigʉ. Resa Zorobabel macʉ̃ niiyigʉ. Zorobabel Salatiel macʉ̃ niiyigʉ. Salatiel Neri macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui macʉ̃ niiyigʉ. Melqui Adi macʉ̃ niiyigʉ. Adi Cosam macʉ̃ niiyigʉ. Cosam Elmadam macʉ̃ niiyigʉ. Elmadam Er macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Jesús macʉ̃ niiyigʉ. Jesús Eliezer macʉ̃ niiyigʉ. Eliezer Jorim macʉ̃ niiyigʉ. Jorim Matat macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví macʉ̃ niiyigʉ. Leví Simeón macʉ̃ niiyigʉ. Simeón Judá macʉ̃ niiyigʉ. Judá José macʉ̃ niiyigʉ. José Jonam macʉ̃ niiyigʉ. Jonam Eliaquim macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea macʉ̃ niiyigʉ. Melea Mena macʉ̃ niiyigʉ. Mena Matata macʉ̃ niiyigʉ. Matata Natán macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David macʉ̃ niiyigʉ. David Isaí macʉ̃ niiyigʉ. Isaí Obed macʉ̃ niiyigʉ. Obed Booz macʉ̃ niiyigʉ. Booz Salmón macʉ̃ niiyigʉ. Salmón Naasón macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab macʉ̃ niiyigʉ. Aminadab Admin macʉ̃ niiyigʉ. Admin Arni macʉ̃ niiyigʉ. Arni Esrom macʉ̃ niiyigʉ. Esrom Fares macʉ̃ niiyigʉ. Fares Judá macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob macʉ̃ niiyigʉ. Jacob Isaac macʉ̃ niiyigʉ. Isaac Abraham macʉ̃ niiyigʉ. Abraham Taré macʉ̃ niiyigʉ. Taré Nacor macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug macʉ̃ niiyigʉ. Serug Ragau macʉ̃ niiyigʉ. Ragau Peleg macʉ̃ niiyigʉ. Peleg Heber macʉ̃ niiyigʉ. Heber Sala macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán macʉ̃ niiyigʉ. Cainán Arfaxad macʉ̃ niiyigʉ. Arfaxad Sem macʉ̃ niiyigʉ. Sem Noé macʉ̃ niiyigʉ. Noé Lamec macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén macʉ̃ niiyigʉ. Matusalén Enoc macʉ̃ niiyigʉ. Enoc Jared macʉ̃ niiyigʉ. Jared Mahalaleel macʉ̃ niiyigʉ. Mahalaleel Cainán macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós macʉ̃ niiyigʉ. Enós Set macʉ̃ niiyigʉ. Set Adán macʉ̃ niiyigʉ. Adán Cõãmacʉ̃ cʉ̃ʉ̃ sicato tiirígʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús día Jordánpʉ niiãrigʉ pʉtʉawayigʉ. Espíritu Santo cʉ̃ʉ̃mena niigʉ̃, cʉ̃ʉ̃rẽ basocá manirṍpʉ néewanetõyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Toopʉ́re cuarenta bʉrecori niiyigʉ. Wãtĩãrẽ dutigʉ́ cʉ̃ʉ̃rẽ jĩĩcõãsãmiyigʉ, Cõãmacʉ̃rẽ netõnʉcã́ãrõ jĩĩgʉ̃. Teebʉrecorire yaariyigʉ. Too síro jʉabóayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wãtĩãrẽ dutigʉ́ cʉ̃ʉ̃rẽ: —Mʉʉ Cõãmacʉ̃ macʉ̃ niigʉ̃, atigá ʉ̃tãgãrẽ pã cotowéoya, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesupé cʉ̃ʉ̃rẽ yʉʉyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Yaaré dícʉ basocáre catiri tiiría”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jesuré ʉ̃mʉã́rõpʉ néewa, máata niipetire atibʉ́reco maquẽ macãrĩrẽ́ ẽñopetíjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Cʉ̃ʉ̃rẽ jĩĩmiyigʉ: —Yʉʉ mʉʉrẽ niipetire atemacã́rĩ dutigʉ́ sõnecogʉda. Teemacãrĩpʉ ãñuré peti niirémena mʉʉ ʉsenigʉ̃dacu. Ate yʉʉre ticorigue niiã. Yʉʉ ticodʉgagʉre ticogʉda. ");
INSERT INTO tue_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","“Mʉʉ yʉʉ õpʉ̃ niiã” mʉʉ jĩĩ padeorí, ate niipetire mʉʉrẽ ticogʉda, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús yʉʉyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Cõãmacʉ̃ mʉʉ Õpʉ̃ sĩcʉ̃rẽna padeoyá. Cʉ̃ʉ̃ dutiré dícʉre tiiyá”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Too síro wãtĩãrẽ dutigʉ́ Jerusalénpʉ néewa, Cõãmacʉ̃wii sotoapʉ néemʉã, cʉ̃ʉ̃rẽ jĩĩmiyigʉ: —Mʉʉ Cõãmacʉ̃ macʉ̃ niigʉ̃, ãnopʉ́mena bupudíaya. ");
INSERT INTO tue_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: Cõãmacʉ̃ cʉ̃ʉ̃yara ángeleare mʉʉrẽ cotedutigʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mʉʉrẽ ʉ̃tãgãpʉ ñaapeari jĩĩrã, bocañeãdacua, jĩĩ jóarigue niiã, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ ate jóarigue niiã: “Cõãmacʉ̃ mʉʉ Õpʉ̃ wedeserere ‘¿diamacʉ̃́rã niimiĩto?’ jĩĩrã, cʉ̃ʉ̃rẽ tiiẽ́ñodutirijãña”, jĩĩ jóarigue niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wãtĩãrẽ dutigʉ́ jĩĩcõãsãre petinógʉ̃, cʉ̃ʉ̃ pʉto niiãrigʉ wáajõãyigʉ ména. ");
INSERT INTO tue_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús Espíritu Santo tutuaremena Galileapʉ pʉtʉawayigʉ. Cʉ̃ʉ̃yere niipetiro Galilea macãrĩpʉ wedeseyira. ");
INSERT INTO tue_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús judíoa neãré wiseripʉ bueyigʉ. Niipetira cʉ̃ʉ̃rẽ “ãñunetõĩ” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús Nazaret cʉ̃ʉ̃ masãri macãpʉ pʉtʉawayigʉ. Judíoa yeerisãri bʉreco cʉ̃ʉ̃ tiirucúrobirora cʉ̃́ã neãrí wiipʉ sããwayigʉ. Cõãmacʉ̃ye queti jóaripũrẽ buegʉdʉ, wʉ̃mʉnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Cʉ̃ʉ̃rẽ “Isaías jóaripũrẽ bueya” jĩĩrã, ticoyira. Tiipũrẽ pã́õ, biiro jóariguere bʉayígʉ: ");
INSERT INTO tue_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Espíritu Santo marĩ Õpʉ̃ ticodiocorigʉ yʉʉmena niiĩ. Cʉ̃ʉ̃ ãñuré quetire bóaneõrãrẽ yʉʉre wededutigʉ besewi. Peresuwiipʉ niirã́rẽ ‘wionécori bʉreco jeaadaro tiia’ jĩĩdutiwi. Capeari ĩñahẽrãrẽ ĩñarĩ tiidutíwi. Ãpẽrã́ ñañarõ tiiáperare wionécodutigʉ ticocowi. ");
INSERT INTO tue_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Cõãmacʉ̃ basocáre netõnérito jeatoaa’ jĩĩrére wededutigʉ ticocowi”, jĩĩ jóariguere bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tiipũrẽ biatóa, teepũrĩrẽ ĩñanogʉ̃rẽ wiyayígʉ. Wiyatóa, cʉ̃́ã tiirucúrobirora jeanuãyigʉ buegʉdʉ. Niipetira tiiwiipʉ́ niirã́ cʉ̃ʉ̃rẽ ĩñaduriyira. ");
INSERT INTO tue_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Cʉ̃́ãrẽ wedesenʉcãyigʉ: —Mecʉ̃ã tee jóarigue mʉ́ã ĩñacoropʉ diamacʉ̃́ wáaa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niipetira cʉ̃ʉ̃rẽ ãñurõ wedeseyira. Cʉ̃ʉ̃ ãñuré wederére tʉorá, tʉomaníjõãyira. Cãmerĩ́ jĩĩyira: —¡Acuéi! Ãni José macʉ̃ niiĩ, ¿teerora? ");
INSERT INTO tue_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Apetó tiirá, yʉʉre ate queorére jĩĩãdacu: “Ʉcotigʉ, mʉʉ basiro ʉcotiya”. “Mʉʉ Capernaumpʉ tutuaremena tiiẽ́ñoriguere ʉ̃sã tʉowʉ́. Toopʉ́ mʉʉ tiirírobirora ãno mʉʉya macãpʉcãrẽ tiiẽ́ñoña” jĩĩãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ profetare cʉ̃ʉ̃ya dita macãrã ãñurõ bocaricua. ");
INSERT INTO tue_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mʉ́ãrẽ ateré masĩrĩ tiidʉgága: Elías niiritopʉre, Israel ditare paʉ wapewia numiã niiyira. Toopʉ́re itiácʉ̃ma apecʉ̃má deco oco peariyiro. Teero tiirá, niipetira tiidita macãrã bayiró jʉabóayira. ");
INSERT INTO tue_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Teero wáapacari, sĩcõ Israelya põna macõ wapewiore tiiápudutigʉ Cõãmacʉ̃ Elíare ticocoriyigʉ. Wapewio Sarepta macã Sidón pʉto macã macõrẽ tiiápudutigʉ ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Profeta Eliseo niiritore, tee tiirírobirora wáayiro. Israelpʉre paʉ õpʉ̃ʉ̃rĩ bóara niiyira. Teero niipacari, Eliseo sĩcʉ̃ tiidita macʉ̃rẽ netõnériyigʉ. Naamán Siria dita macʉ̃pere netõnéyigʉ, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Niipetira tiiwiipʉ́ neãrira teeré tʉorá, bayiró cúayira. ");
INSERT INTO tue_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wʉ̃mʉnʉcã, cʉ̃ʉ̃ tiimacã niiãrigʉre cõããdara néewayira. Tiimacã wesa niirí tʉdipʉ néewayira, cʉ̃ʉ̃rẽ tuunédiocodʉgara. ");
INSERT INTO tue_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesupé cʉ̃́ãrẽ netõwá, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús Capernaumpʉ búawayigʉ. Tiimacã Galilea ditapʉ niicu. Toopʉ́ judíoa yeerisãri bʉreco niirĩ, basocáre bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cʉ̃ʉ̃ buerére tʉorá, tʉomaníjõãyira. Dutiré cʉogʉ́ tiiróbiro bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tiiwiipʉ́re sĩcʉ̃ basocʉ́ niiyigʉ. Wãtĩ cʉ̃ʉ̃pʉre niiyigʉ. Bayiró acaribíyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Mʉʉ Jesús Nazaret macʉ̃, ʉ̃sãrẽ potocṍrijãña. Ʉ̃sãrẽ ñañarõ tiidíogʉ atigʉ tiia. Yʉʉ mʉʉrẽ ĩñamasĩã. Cõãmacʉ̃ ticodiocorigʉ ñañaré manigʉ̃́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—Ditamaníjõãña; cʉ̃ʉ̃pʉre niigʉ̃́, witiwaya, jĩĩ tutiyigʉ Jesús. Wãtĩ cʉ̃ʉ̃pʉre niigʉ̃́ cʉ̃́ã ĩñacoropʉ ñaacũmurĩ tii, witiwayigʉ. Cʉ̃ʉ̃rẽ ñañarõ tiirípacʉ, witiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Niipetira ĩñamanijõãyira. Cʉ̃́ã basiro cãmerĩ́ wedeseyira: —¿Ate dutiré ñeenó niimiĩto? Cʉ̃ʉ̃ dutirémena, cʉ̃ʉ̃ tutuaremena wãtĩã cõãwionecori, witiwaya, jĩĩyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Niipetiro tiiditapʉ Jesuyé queti sesajõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús tiiwií niiãrigʉ witijõãyigʉ. Simónya wiipʉ sããwayigʉ. Simón mañecõ bayiró wioré diago tiiyígo. Teero tiirá, Jesuré “netõnéña” jĩĩ sãĩyíra. ");
INSERT INTO tue_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús coo pʉto jeanʉcã munibiá, wiorére tatidutíyigʉ. Cʉ̃ʉ̃ teero tiirí, wioré tatijṍãyiro. Máata coo wʉ̃mʉnʉcã, cʉ̃́ãrẽ yaaré ecayígo. ");
INSERT INTO tue_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Muĩpũ sããwari, niipetira basocá cʉ̃́ã pʉtopʉ niirã́ deero niiré diarecʉtirare cʉ̃ʉ̃rẽ néewayira. Jesús cʉ̃́ãcõrõrẽ ñaapeó, netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wãtĩã paʉ basocápʉre niiãrira witiwayira. Cʉ̃́ã witiwara, bayiró bʉsʉrómena jĩĩyira: —Mʉʉ Cõãmacʉ̃ macʉ̃ niiã, jĩĩyira. Wãtĩã “Cristo Cõãmacʉ̃ beserigʉ niiĩ” jĩĩrére masĩyira. Teero tiigʉ́, Jesús cʉ̃́ãrẽ tuti, wedesedutiriyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bóecũmurĩ, Jesús tiimacãpʉ niiãrigʉ wáa, basocá manirṍpʉ jeayigʉ. Basocá cʉ̃ʉ̃rẽ ãmaã, bʉa, “wáarijãña” jĩĩrã, ñeedʉgamiyira. ");
INSERT INTO tue_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Apeyé macãrĩpʉcãrẽ Cõãmacʉ̃ dutiré basocápʉre niiãdarere yʉʉre wedegʉ wáaro booa. Ateré tiigʉ́dʉre yʉʉre ticodiocowi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Judíoa neãré wiseripʉ tiidita niiré macãrĩpʉ wedewarucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sicabʉreco Jesús Genesaretaro wesapʉ niiyigʉ. Paʉ basocá cʉ̃ʉ̃ pʉto tuuwáyira, Cõãmacʉ̃yere tʉodʉgára. ");
INSERT INTO tue_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ditatuparipʉ dooríwʉ pʉawʉ́ pasari ĩñayigʉ. Wai wasara jeaarira teepawʉre too paso, cʉ̃́ãye bapiyucʉre coserá tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sicawʉ́pʉ Jesús mʉãsãyigʉ. Simónyawʉ niiyiro. Cʉ̃ʉ̃rẽ: —Decosãñurõ súuwionecoya, jĩĩyigʉ. Jeanuã, tiiwʉpʉ́ sãñagʉ̃rã basocáre bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cʉ̃́ãrẽ bueari siro, Simónrẽ jĩĩyigʉ: —Decopʉ waawáya. Toopʉ́ mʉ́ãye bapiyucʉre cõãñoña, wai ñeeãdara, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón cʉ̃ʉ̃rẽ yʉʉyigʉ: —Basocáre buegʉ́, ʉ̃sã ñamirẽ wasaboemiãwʉ̃. Bʉarídojããtʉ. Mʉʉrẽ tiigʉ́, mʉʉ dutirobirora bapiyucʉre cõãñogʉ̃da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cʉ̃́ã teeyucʉre cõãñorĩ, paʉ wai sããyira. Teeyucʉ yigaropʉ tiiyíro. ");
INSERT INTO tue_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Teero wáari ĩñarã, cʉ̃́ãmena paderá apewʉpʉ́ niirã́rẽ tiiápudutira bʉ́aneyira. Cʉ̃́ã jea, waire néesãapuyira. Teepawʉ duadiaadaro péerogã dʉsayíro. ");
INSERT INTO tue_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro teero wáari ĩñagʉ̃, Jesús pʉto ñicãcoberimena jeacũmu, jĩĩyigʉ: —Õpʉ̃, yʉʉ ñañagʉ̃́ niiã. Yʉʉmena niirijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cʉ̃ʉ̃, cʉ̃ʉ̃mena niirã́ niipetira ĩñamanijõãyira, wai paʉ ĩñarã. ");
INSERT INTO tue_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cʉ̃ʉ̃mena wai dúari basoca Santiago, Juan Zebedeo põnacã ĩñamanijõãyira. Jesús Simónrẽ jĩĩyigʉ: —Cuirijãña. Mecʉ̃ãmena mʉʉ wai wasa néõgʉ̃ tiiróbiro yʉʉre padeoádarare néõgʉ̃ niigʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Too síro cʉ̃́ã doorépawʉre wéemʉõnecũ, niipetire cṹũjã, Jesuména wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús sicamacãpʉ niirĩ, sĩcʉ̃ bayiró õpʉ̃ʉ̃ bóagʉ toopʉ́ niiyigʉ. Jesuré ĩñagʉ̃, ditapʉ munibiácũmujea, jĩĩyigʉ: —Õpʉ̃, mʉʉ yʉʉ diarecʉtirere netõnédʉgagʉ, netõnémasĩã. ");
INSERT INTO tue_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús cʉ̃ʉ̃rẽ ñaapeó, jĩĩyigʉ: —Netõnédʉgaga. Diaremanigʉ̃ pʉtʉáya, jĩĩyigʉ. Máata cʉ̃ʉ̃ya õpʉ̃ʉ̃ bóare yatijõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús cʉ̃ʉ̃rẽ dutiyigʉ: —Ateré wederijãña, jĩĩmiyigʉ—. Pairé ẽñogʉ̃́ wáaya, “ãñujõããyi” jĩĩdutigʉ. Moisés dutirirobirora tiiwá, basocá niipetira mʉʉ diaré netõã́riguere masĩãrõ jĩĩgʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesús “wederijãña” jĩĩpacari, cʉ̃ʉ̃ye jõõpemena sesawaro tiiyíro. Paʉ basocá cʉ̃ʉ̃rẽ tʉoádara, cʉ̃́ã diaré netõnédutiadara neãyira. ");
INSERT INTO tue_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesupé basocá manirṍpʉ naĩrõ wáarucuyigʉ, Cõãmacʉ̃mena wedesegʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sicabʉreco Jesús basocáre buegʉ tiiyígʉ. Toopʉ́ sĩquẽrã fariseo basoca, ãpẽrã́ Moisés jóarigue buerá duiyira. Cʉ̃́ã niipetire macãrĩ macãrã niiyira: Galilea dita, Judea dita, Jerusalén macãrã niiyira. Jesús Cõãmacʉ̃ tutuare cʉoyígʉ diaráre netõnégʉ̃dʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesús basocáre bueri, ãpẽrã́ sĩcʉ̃ wáamasĩhẽgʉ̃rẽ cõãrṍmena ñoonéjeayira. Cʉ̃́ã Jesús pʉtopʉ néesãwa, cṹũdʉgamiyira. ");
INSERT INTO tue_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Basocá paʉ niirĩ, deero tii cʉ̃ʉ̃rẽ néesãwamasĩriyira. Teero tiirá, wii sotoápʉ mʉãwa, sicacope néeweyira. Basocá deco Jesús niirṍpʉ cõãrṍmena cʉ̃ʉ̃rẽ diocóyira. ");
INSERT INTO tue_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús cʉ̃́ã padeorí ĩñagʉ̃, wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: —Mʉʉ ñañaré tiirére acabónotoaa. ");
INSERT INTO tue_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moisés jóarigue buerá, fariseo basoca wãcũyira: “Ãni Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiii. Cõãmacʉ̃ sĩcʉ̃rã ñañaré tiirére acabómasĩĩ”, jĩĩ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús cʉ̃́ã wãcũrére masĩjãjĩgʉ̃, jĩĩyigʉ: —¿Deero tiirá mʉ́ã teero wãcũĩ? ");
INSERT INTO tue_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ãnirẽ́ “mʉʉ ñañaré tiirére acabónotoaa” yʉʉ jĩĩrĩ, tee cʉ̃ʉ̃rẽ acabónoãriguere ĩñaricu mʉ́ãjã. Yʉʉ “wʉ̃mʉnʉcã, wáaya” jĩĩrĩpereja, cʉ̃ʉ̃ wʉ̃mʉnʉcãrĩ ĩñaã mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉʉ niipetira sõwʉ̃ niiã. Teero tiigʉ́, atiditapʉ́re basocá cʉ̃́ã ñañaré tiirére acabómasĩã. Yʉʉ dutirére mʉ́ãrẽ ẽñogʉ̃́da, jĩĩyigʉ cʉ̃ʉ̃peja. Wáamasĩhẽgʉ̃rẽ jĩĩyigʉ: —Yʉʉ mʉʉrẽ “wʉ̃mʉnʉcãña” jĩĩã. Mʉʉ cõãrṍrẽ néeapa, mʉʉya wiipʉ pʉtʉawaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Máata wáamasĩhẽgʉ̃ niimiãrigʉ cʉ̃́ã ĩñacoro wʉ̃mʉnʉcã, cʉ̃ʉ̃ cõãrṍrẽ néeapa, Cõãmacʉ̃rẽ ʉsenire ticogʉra, cʉ̃ʉ̃ya wiipʉ pʉtʉajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Niipetira teero wáaariguere ĩñamanijõã, Cõãmacʉ̃rẽ ʉsenire ticoyira. Bayiró cuiremena jĩĩyira: —Mecʉ̃ãrẽ ĩñaña manirére ĩñaã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Too síro Jesús wáajõãyigʉ. Wáagʉ, sĩcʉ̃ romanuã õpʉ̃rẽ niyeru wapasébosari basocʉre ĩñayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Leví. Cʉ̃ʉ̃ paderópʉ duiri ĩña: —Jãmʉ yʉʉmena, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví wʉ̃mʉnʉcã, niipetire cʉ̃ʉ̃ paderére duujã́, cʉ̃ʉ̃mena wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Too síro Leví cʉ̃ʉ̃ya wiipʉ Jesuré bosebʉreco tiipéoyigʉ. Paʉ niyeru wapasébosari basoca, ãpẽrã́ cʉ̃́ãmena yaayira. ");
INSERT INTO tue_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseo basoca, Moisés jóarigue buerá Jesús bueráre wedepatira, jĩĩyira: —¿Deero tiirá mʉ́ã niyeru wapasébosari basocamena, ñañaré tiirámena yaa, sĩniĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Diaremanirã ʉcotigʉre boorícua; diarecʉtira dícʉ ʉcotigʉre boocúa. ");
INSERT INTO tue_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Ãñuré dícʉ tiia” jĩĩrã́rẽ ãmaãgʉ̃ atiriwʉ; ñañaré tiirápere ãmaãgʉ̃ atiwʉ; cʉ̃́ãpere “wãcũpati, wasoyá” jĩĩgʉ̃ atiwʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesuré jĩĩnemoyira: —Juan buerére nʉnʉrã́ naĩrõ beti, súubuseya. Fariseo basoca buerére nʉnʉrã́cã teerora tiiíya. Mʉʉ buerápe sĩni, yaa tiiíya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesupé cʉ̃́ãrẽ jĩĩyigʉ: —Wãmosíagʉdʉ boocórirare betidutímasĩña maniã, cʉ̃ʉ̃ cʉ̃́ãmena niirĩ. ");
INSERT INTO tue_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Too síro cʉ̃ʉ̃ néewanogʉ̃daqui. Teebʉrecorire betiádacua. ");
INSERT INTO tue_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Cʉ̃́ãrẽ queorémena wedenemoyigʉ: —Sĩcʉ̃ mamarṍ sutiroré taane, sutiró bʉcʉropʉ seeréturiqui. Teeré tiigʉ́, sutiró mamarṍrẽ ñañogʉ̃́ tiiquí. Sutiró mamarṍrẽ toopʉ́ seeréturi, ãñurõ jearia. ");
INSERT INTO tue_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Teerora sĩcʉ̃ mama vinorẽ wáicʉra caseropori bʉcʉporimena posetíriqui. Teeré tiirí, wʉga, teepori esarí, podojõãcu. Vino píobatejõã, teeporicã cõõjṍãcu. ");
INSERT INTO tue_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Teero tiirá, mama vinorẽ mamapóripʉ posetíro booa. ");
INSERT INTO tue_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sĩcʉ̃ vino bʉcʉ sĩnirípoarigʉ mama tiiáriguepere sĩnidʉgáriqui. “Vino bʉcʉpe nemorṍ ãñuã”, jĩĩqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sicabʉreco judíoa yeerisãri bʉreco niirĩ, Jesús trigo wesepʉ netõwáyigʉ. Cʉ̃ʉ̃ buerá trigore tʉ̃ne, teeperire sãquẽ, yaayira. ");
INSERT INTO tue_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sĩquẽrã fariseo basoca jĩĩyira: —Marĩrẽ yeerisãri bʉrecore padedutiripacari, ¿mʉ́ãpeja deero tiirá padera tiii? ");
INSERT INTO tue_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Õpʉ̃ David sicabʉreco jʉabóayigʉ. Cʉ̃ʉ̃ menamacãrã jʉabóaramena cʉ̃ʉ̃ tiiríguere mʉ́ã buerá niipacara, ¿masĩrii? ");
INSERT INTO tue_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Cõãmacʉ̃wiipʉ sããwayigʉ. Toopʉ́ pã mesa sotoa pesariguere “Cõãmacʉ̃ye niiã” jĩĩriguere née, yaapetijãyigʉ cʉ̃ʉ̃ menamacãrãmena. Paiá dícʉre yaaré niimiyiro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Yʉʉ niipetira sõwʉ̃ yeerisãri bʉreco niirĩ, basocá tiiádarere dutimasĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jesús sica yeerisãri bʉreco niirĩ, judíoa neãrí wiipʉ sããwa, basocáre bueyigʉ. Toopʉ́ sĩcʉ̃ wãmo bʉʉre cʉogʉ́ niiyigʉ. Diamacʉ̃́ macã wãmo niiyiro. ");
INSERT INTO tue_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés jóarigue buerá, fariseo basoca Jesuré ãñurõ ĩñanʉnʉseyira. “¿Marĩ yeerisãri bʉrecore netõnégʉ̃dari cʉ̃ʉ̃?” jĩĩ wãcũyira. Cʉ̃ʉ̃rẽ wedesãrere ãmaãrã tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesupé cʉ̃́ã wãcũrére masĩjãyigʉ. Wãmo bʉʉre cʉogʉ́re: —Wʉ̃mʉnʉcãña basocá decopʉ, jĩĩyigʉ. Wʉ̃mʉnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús too niirã́rẽ jĩĩyigʉ: —Mʉ́ãrẽ sãĩñágʉ̃da. Marĩrẽ dutiré ¿deero tiidutíi yeerisãri bʉreco niirĩ? ¿Ãñurére o ñañarére tiidutíi? ¿Basocáre netõnérere o basocáre sĩãcõã́rere tiidutíi? jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Niipetirare ĩña, wãmo bʉʉre cʉogʉ́re: —Mʉʉya wãmorẽ súucoya, jĩĩyigʉ. Cʉ̃ʉ̃peja súucoyigʉ. Teero tiiríra, cʉ̃ʉ̃ya wãmo sicato niirirobirora pʉtʉáyiro. ");
INSERT INTO tue_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cʉ̃́ãpe cúanetõjõãyira. “¿Marĩ deero tiiádari ãnirẽ́?” jĩĩ cãmerĩ́ sãĩñáyira. ");
INSERT INTO tue_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Teebʉrecorire Jesús sicabʉreco ʉ̃tãgʉ̃pʉ́ wáa, Cõãmacʉ̃mena wedeseboejõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bóecũmuãri siro, cʉ̃ʉ̃ bueráre neãdutiyigʉ. Cʉ̃́ãpʉre doce beseyigʉ. Cʉ̃́ãrẽ: —Yʉʉ besearira niiã mʉ́ã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Noquẽrã niiyira: Simón (cʉ̃ʉ̃rẽna Jesupé “Pedro” wãme tuuyigʉ), Andrés (Simón bai), Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO tue_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago (Alfeo macʉ̃), Simón (romanuã dutiráre cõãdʉgara menamacʉ̃), ");
INSERT INTO tue_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Santiago bai), Judas Iscariote (too síropʉ Jesuré ĩñatutirapʉre wedesãcotegʉdʉ) niiyira. ");
INSERT INTO tue_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ʉ̃tãgʉ̃pʉ́ niiãrigʉ cʉ̃ʉ̃ beseariramena diiátiyigʉ. Toopʉ́ diiátigʉ, ʉ̃tãgʉ̃́ pʉʉto macã yepapʉ pʉtʉánʉcãyigʉ. Toopʉ́ cʉ̃ʉ̃ buerá paʉ niiyira. Cʉ̃́ãmena aperó macãrãpʉ paʉ niiyira: Judea dita macãrã, ãpẽrã́ Jerusalén macãrã, ãpẽrã́ Sidón, Tiro pairímaa wesa niirí dita macãrã niiyira. Cʉ̃́ã Jesús buerére tʉoádara, cʉ̃́ã diarére netõnédutiadara jeayira. ");
INSERT INTO tue_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wãtĩã sããnorirare netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Niipetira cʉ̃ʉ̃rẽ padeñádʉgayira. Cʉ̃ʉ̃ tutuaremena niipetira cʉ̃ʉ̃rẽ padeñárãrẽ netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús cʉ̃ʉ̃ bueráre ĩña, jĩĩyigʉ: —Mʉ́ã bóaneõrã ʉseniña. Cõãmacʉ̃ dutiré mʉ́ãpʉre jeatoaa. ");
INSERT INTO tue_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Mʉ́ã mecʉ̃tígã jʉabóara ʉseniña. Too síropʉre yapiadacu. ’Mʉ́ã mecʉ̃tígã utirá ʉseniña. Too síropʉre buiádacu. ");
INSERT INTO tue_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Basocá mʉ́ãrẽ ĩñatuti, mʉ́ãrẽ sũna, mʉ́ãrẽ ñañarõ jĩĩ, mʉ́ã wãmerẽ doorémena jĩĩãdacua. Mʉ́ã yʉʉ niipetira sõwʉ̃ye niiãdarere tiiré wapa cʉ̃́ã teero tiirí, ʉseniña. ");
INSERT INTO tue_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Too síropʉre mʉ́ã ʉ̃mʉã́sepʉ pairó wapatáre bʉaádacu. Teero tiirá, cʉ̃́ã teero tiirí, bayiró ʉseniña. Cʉ̃́ã mʉ́ãrẽ tiiróbirora cʉ̃́ã ñecʉ̃sʉ̃mʉãcã tiiyíra profetare. ");
INSERT INTO tue_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Bóaneõrã niiã mʉ́ã pee apeyé cʉorá. Mʉ́ã ʉsenitoaa mée. ");
INSERT INTO tue_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Bóaneõrã niiã mʉ́ã yapirá. Too síropʉre jʉabóaadacu. ’Bóaneõrã niiã mʉ́ã ʉseni buirá. Too síropʉre bayiró utiadacu. ");
INSERT INTO tue_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Bóaneõrã niiã mʉ́ã niipetira ãñurõ wedesenorã. Too sʉgueropʉ “profetas niiã ʉ̃sã” jĩĩditorirare mʉ́ã pacʉsʉ̃mʉã teerora ãñurõ diamacʉ̃́ cʉ̃́ãrẽ wedesepadeoyira. ");
INSERT INTO tue_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Yʉʉre tʉoráre ateré jĩĩã: Mʉ́ãrẽ ñañarõ tiidʉgárare maĩñá. Mʉ́ãrẽ ĩñatutirare ãñurõ tiiyá. ");
INSERT INTO tue_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉ́ãrẽ “ñañarõ wáaaro” jĩĩrã́rẽ “mʉ́ãrẽ ãñurõ wáaaro” jĩĩña. Mʉ́ãrẽ ñañarõ jĩĩrã́rẽ Cõãmacʉ̃rẽ sãĩbosáya. ");
INSERT INTO tue_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sĩcʉ̃ mʉʉrẽ wasopúro páari, “apeniñacã́rẽ páaya” jĩĩña. Sĩcʉ̃ mʉʉyaro sutiró sotoá macãrõrẽ néewari, camisacãrẽ ticoya, tooré cʉ̃ʉ̃ booátã. ");
INSERT INTO tue_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Niipetira mʉ́ãrẽ sãĩrã́rẽ ticoya. Mʉ́ãyere néewarare “wiyayá” jĩĩrijãña. ");
INSERT INTO tue_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mʉ́ã ãpẽrãrẽ́ mʉ́ãrẽ ãñurõ tiirí booa; mʉ́ãcã teerora cʉ̃́ãrẽ ãñurõ tiiyá. ");
INSERT INTO tue_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉ́ãrẽ maĩrã́ dícʉre maĩrĩ́, wapamaníã. Ñañaré tiirácã teerora cʉ̃́ãrẽ maĩrã́rẽ maĩĩ́ya. ");
INSERT INTO tue_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mʉ́ãrẽ ãñurõ tiirá dícʉre ãñurõ tiirí, tee wapamaníã. Ñañaré tiirácã teerora tiiíya. ");
INSERT INTO tue_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mʉ́ã ãpẽrãrẽ́ apeyenó wasora, “cʉ̃́ã wiyaádacua” jĩĩrã́ dícʉre ticori, tee wapamaníã. Ñañaré tiirácã teerora cʉ̃́ã menamacãrãrẽ wasooya, “cʉ̃́ã marĩ ticoarirocõrõ wiyaádacua” jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Teero tiirá, mʉ́ãrẽ ñañarõ tiidʉgárare maĩñá. Ãñurõ tiiyá. “Yʉʉ wasoré wapa ¿ñeenó ticoadari?” jĩĩ wãcũripacara, wasoya. Teero tiirá, wapatáre ãñuré bʉaádacu. Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́ põna niiãdacu. Cʉ̃ʉ̃rẽ “ãñuã” jĩĩhẽrãrẽ, teero biiri ñañaré tiiráre ãñurõ tiii. ");
INSERT INTO tue_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Marĩ Pacʉ bóaneõrõbirora mʉ́ãcã bóaneõña. ");
INSERT INTO tue_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ãpẽrãrẽ́ ĩñabeserijãña. Mʉ́ã ĩñabeseheri, Cõãmacʉ̃cã mʉ́ãrẽ ĩñabeseriqui. Ãpẽrãrẽ́ “cʉ̃́ã wapa cʉoóya” jĩĩrijãña. Mʉ́ã jĩĩhẽrĩ, Cõãmacʉ̃ mʉ́ãrẽ “cʉ̃́ã wapa cʉoóya” jĩĩriqui. Ãpẽrã́ mʉ́ãrẽ ñañarõ tiirí, acabóya. Mʉ́ã cʉ̃́ãrẽ acabóri, Cõãmacʉ̃ mʉ́ãrẽ acabógʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ãpẽrãrẽ́ ticoya. Mʉ́ã cʉ̃́ãrẽ ticori, Cõãmacʉ̃ mʉ́ãrẽ ticogʉdaqui. Sicapo ãñurõ dadarípo, ñaadiyóaripo tiiróbiro ticogʉdaqui. Mʉ́ã ãpẽrãrẽ́ ãñurõ tiirí, Cõãmacʉ̃ mʉ́ãrẽ ãñurõ tiigʉ́daqui. Mʉ́ã ãpẽrãrẽ́ ñañarõ tiirí, Cõãmacʉ̃ mʉ́ãrẽ ñañarõ tiigʉ́daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ate queorémenacãrẽ wedeyigʉ: —Mʉ́ã tʉgueñarĩ, ¿sĩcʉ̃ ĩñahẽgʉ̃ ãpĩ ĩñahẽgʉ̃rẽ sʉguemasĩgari? Cʉ̃́ã pʉarã́pʉra copepʉ ñaacosããdacua. ");
INSERT INTO tue_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sĩcʉ̃ buegʉ́ cʉ̃ʉ̃rẽ buegʉ́ nemorṍ masĩgʉ̃́ niimasĩriqui. Cʉ̃ʉ̃ buerére buepetigʉpʉ, cʉ̃ʉ̃rẽ buegʉ́ tiiróbiro masĩgʉ̃́ niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Mʉʉya wedegʉya capeapʉ pasarí manarõrẽ ĩñaã. Ĩñapacʉ, mʉʉya capeapʉ pasarí dʉcapereja ĩñaria. ");
INSERT INTO tue_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mʉʉya capeapʉ niirí dʉcare ĩñaripacʉ, ¿deero tiigʉ́ mʉʉya wedegʉre “mʉʉya capeapʉ pasarí manarõrẽ néecõãma” jĩĩĩ? ¡Ñañagʉ̃́, tiiditórepigʉ! Mʉʉya capeapʉ niirí dʉcapere néecõãsʉgueya. Cõãtoagʉpʉ, ãñurõ ĩñagʉ̃dacu. Teero tiigʉ́, mʉʉya wedegʉya capeapʉ pasarí manarõrẽ néecõãgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Yucʉgʉ ãñuré dʉcacʉtirigʉ ñañaré dʉcacʉtiria. Yucʉgʉ ñañaré dʉcacʉtirigʉ ãñuré dʉcacʉtiria. ");
INSERT INTO tue_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yucʉcṍrõrẽ tiigʉ́ dʉcamena ĩñamasĩnoã. Potagʉ pica dʉcacʉtiria. Yucʉsati ʉse dʉcacʉtiria. ");
INSERT INTO tue_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Teero biiri basocʉ́ ãñugʉ̃́pʉre ãñuré niicu. Teero tiigʉ́, ãñuré wedesei. Basocʉ́ ñañagʉ̃́pʉre ñañaré niicu. Teero tiigʉ́, ñañaré wedesei. Cʉ̃ʉ̃pʉre pairó niinetõnʉcãrere wedesequi. ");
INSERT INTO tue_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Deero tiirá yʉʉre “yʉʉ Õpʉ̃” jĩĩpacara, yʉʉ dutirére tiiríi? ");
INSERT INTO tue_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yʉʉre ati, yʉʉ wederére tʉo, yʉʉ wederirobiro tiigʉ́, ate tiiróbiro niiĩ: ");
INSERT INTO tue_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wii tiigʉ́dʉ ʉ̃cʉ̃ã́rõpʉ coasã́wa, ʉ̃tãgãpʉ jea, botarí nʉcõ, wii tiiquí. Día potari, tiiwiipʉ́ oco õmatucori, ãcũricu, ʉ̃tãgãpʉ nʉcõrí wii niijĩrõ. ");
INSERT INTO tue_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ãpĩpé yʉʉ wederére tʉo, yʉʉ wederirobiro tiihégʉ, ate tiiróbiro niiĩ: Wii tiigʉ́dʉ ʉ̃cʉ̃hẽ́rõgã coasã́wa, botarí nʉcõ, wii tiiquí. Día õmatucori, máata peecódiacu; peedía, mʉtãpetijõãcu, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús basocáre bueari siro, Capernaumpʉ pʉtʉawayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Toopʉ́ cien surara dutigʉ́ niiyigʉ. Cʉ̃ʉ̃rẽ padecotegʉ cʉ̃ʉ̃ bayiró maĩgʉ̃́ diagʉ́pʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cien surara dutigʉ́ Jesús tiirére tʉogʉ́, judíoa bʉtoá dutiráre cʉ̃ʉ̃ pʉtopʉ ticocoyigʉ. Cʉ̃ʉ̃rẽ padecotegʉre netõnégʉ̃ atidutigʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Cʉ̃́ã Jesús pʉtopʉ jeara, tiiápure sãĩbosáyira: —Ʉ̃sãrẽ ticocoarigʉ basocʉ́ ãñugʉ̃́ niiĩ. Cʉ̃ʉ̃ marĩ judíoare ãñurõ maĩĩ. Cʉ̃ʉ̃rã́ ãñurõ tiigʉ́, ʉ̃sã neãrí wiire tiidutíwi. Teero tiigʉ́, tiiápurijã tiiríjãña, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Teeré tʉogʉ́, Jesús cʉ̃́ãmena wáayigʉ. Wiipʉ́ jeagʉdʉ tiirí, cien surara dutigʉ́ ãpẽrã́ cʉ̃ʉ̃ menamacãrãrẽ ticocoyigʉ Jesuré biiro wededutigʉ: —“Õpʉ̃, mʉʉrẽ potocṍnemodʉgariga. Yʉʉ bʉ́ri niigʉ̃́ niiã. Teero tiigʉ́, yʉʉ mʉʉrẽ yáa wiipʉ ‘sããatiya’ jĩĩmasĩriga. ");
INSERT INTO tue_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Teero tiigʉ́, yʉʉ basiro mʉʉmena wedesegʉ wáariawʉ̃. Mʉʉ ‘netõã́rõ’ jĩĩcoremenarã yʉʉre padecotegʉ netõjṍãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉʉ ãpẽrã́ dutiré docapʉ niiã. Yʉʉpʉ surarare dutia sáa. Yʉʉ sĩcʉ̃rẽ ‘wáaya’ jĩĩrĩ, wáai. Ãpĩrẽ́ ‘atiya’ jĩĩrĩ, atii. Yʉʉre padecotegʉre ‘biiro tiiyá’ jĩĩrĩ, tiii”, jĩĩãwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús teeré tʉogʉ́, teeré jĩĩcoarigʉre tʉomaníjõãyigʉ. Cʉ̃ʉ̃rẽ nʉnʉrã́rẽ cãmenʉcã́ ĩña, jĩĩyigʉ: —Yʉʉre tʉoyá: Israelpʉre ãni tiiróbiro padeoré cʉogʉ́re bʉajeáñariga, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Too síro cʉ̃ʉ̃ ticocoarira wiipʉ́ pʉtʉajõãyira. Pʉtʉajeara, cʉ̃ʉ̃rẽ padecotegʉre netõã́rigʉpʉre bʉajeáyira. ");
INSERT INTO tue_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Too síro Jesús Naín wãmecʉtiri macãpʉ wáayigʉ. Cʉ̃ʉ̃ buerá, ãpẽrã́ paʉ basocá cʉ̃ʉ̃mena wáayira. ");
INSERT INTO tue_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tiimacã cʉ̃ʉ̃ jeaatiri, sĩcʉ̃ diaarigʉre ñoonéwayira yaará wáara. Cʉ̃ʉ̃ wapewio macʉ̃ sĩcʉ̃ niigʉ̃́ niiyigʉ. Paʉ tiimacã macãrã coore bapacʉtiyira. ");
INSERT INTO tue_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Coore ĩñagʉ̃, marĩ Õpʉ̃ bóaneõ ĩñagʉ̃, coore: —Utirijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jea, cʉ̃ʉ̃rẽ ñoonéwari caserore padeñáyigʉ. Cʉ̃ʉ̃ teero tiirí, ñoonéwara pʉtʉánʉcãyira. Diaarigʉre jĩĩyigʉ: —Yʉʉ mʉʉrẽ dutia: Wʉ̃mʉnʉcãña. ");
INSERT INTO tue_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cʉ̃ʉ̃ teero jĩĩrĩrã, diaarigʉ wʉ̃mʉnu, wedesenʉcãyigʉ. Jesús cʉ̃ʉ̃ pacore wiyayígʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Teeré ĩñarã, niipetira cuiyira. Cõãmacʉ̃rẽ ʉsenirã, jĩĩyira: —Sĩcʉ̃ profeta tutuanetõgʉ̃ marĩ watoapʉre bauái, jĩĩyira—. Cõãmacʉ̃ cʉ̃ʉ̃yarare tiiápugʉ atigʉ tiiájĩyi, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Niipetiro Judea ditapʉre, too wesapʉre cʉ̃ʉ̃rẽ masõre queti sesajõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan buerére nʉnʉrã́ niipetire Jesús tiirére cʉ̃ʉ̃rẽ wedeyira. Teeré tʉogʉ́, pʉarã́ cʉ̃ʉ̃ buerére nʉnʉrã́rẽ atiduti, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Jesús pʉtopʉ wáa, sãĩñáña: “¿Mʉʉrã́ niiĩ ‘basocáre netõnégʉ̃dʉ atigʉdaqui’ jĩĩnorigʉ; o ãpĩpére yuegarite?” jĩĩña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cʉ̃́ã cʉ̃ʉ̃ pʉtopʉ jea, jĩĩyira: —Juan basocáre wãmeõtiri basocʉ ʉ̃sãrẽ mʉʉrẽ sãĩñáduticoawĩ. “¿Mʉʉrã́ niiĩ ‘basocáre netõnégʉ̃dʉ atigʉdaqui’ jĩĩnorigʉ; o ãpĩpére yuegarite?” jĩĩãwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Cʉ̃́ã jearira, Jesús paʉ diaráre, ñañarõ netõrã́rẽ netõnéyigʉ. Wãtĩã sããnorirare cõãwionecoyigʉ. Paʉ ĩñahẽrãrẽ ĩñarĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Teero tiitóa, cʉ̃́ãrẽ yʉʉyigʉ: —Juanrẽ́ wedera wáaya mʉ́ã ĩñaãriguere, mʉ́ã tʉoáriguere. Biiro jĩĩña: “Ĩñahẽrã ĩñaãya. Wáamasĩhẽrã wáaaya. Õpʉ̃ʉ̃rĩ bóara yatijõãnoya. Tʉohéra tʉoóya. Diaarira masõnoya. Bóaneõrã ãñuré quetire wedenoya. ");
INSERT INTO tue_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yʉʉre padeodúhegʉno ʉseniqui”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan ticocoarira wáaari siro, Jesús Juanyé maquẽrẽ basocáre wedenʉcãyigʉ: —¿Mʉ́ã basocá manirṍpʉ ñeenórẽ ĩñarã jeari? ¿Cãnʉsirogʉ wĩno páapuri cãmeñarere ĩñarã jearite? ");
INSERT INTO tue_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ñeenórẽ ĩñarã jeari? ¿Ãñuré suti sãñagʉ̃́rẽ ĩñarã jearite? Suti ãñuré sãña niirã́jã õpãrãyé wiseripʉ niicua. ");
INSERT INTO tue_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ñeenópere ĩñarã jeari? ¿Profetapere ĩñarã jearite? Diamacʉ̃́rã Juanpeja profetas nemorṍ ʉpʉtí maquẽrẽ wedewi. ");
INSERT INTO tue_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cʉ̃ʉ̃ye maquẽrẽ Cõãmacʉ̃ye queti jóaripũpʉ ateré jóanoã: Yʉʉre wedesʉguegʉre mʉʉ sʉguero ticocogʉda. Cʉ̃ʉ̃ mʉʉ wáaadarimarẽ quẽnoyúegʉdaqui, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yʉʉre tʉoyá: Niipetira basocá watoapʉre Juan nemorṍ niigʉ̃́ maniĩ. Tee biipacari, Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉsegʉnope bʉ́ri niigʉ̃́ niipacʉ, Juan nemorṍ ʉpʉtí macʉ̃ niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cʉ̃ʉ̃ teero jĩĩrére tʉorá, niipetira basocá, niyeru wapasébosari basocacã Juan wãmeõtinorira “Cõãmacʉ̃ diamacʉ̃́ maquẽrẽ tiigʉ́ niiĩ” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo basoca, Moisés jóarigue buerá Juan wãmeõtinoririrape Cõãmacʉ̃ cʉ̃́ãrẽ ãñurõ tiidʉgárere booríyira. Jesús jĩĩnemoyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—¿Ñeenó queorémena wedegʉdari yʉʉ atitó macãrãrẽ? ¿Ñeenó tiiróbiro niiĩ? ");
INSERT INTO tue_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wĩmarã macã decopʉ apeduira tiiróbiro niiĩya. Cʉ̃́ã menamacãrãmena biiro cãmerĩ́tuticua: “Ʉ̃sã bosebʉreco tiirí, basaapuriawʉ̃. Ʉ̃sã booritua, utiri, utiapuriawʉ̃”, jĩĩcua. ");
INSERT INTO tue_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan basocáre wãmeõtiri basocʉ apetóre pã yaariyigʉ; vinocãrẽ sĩnirídojãyigʉ. Mʉ́ãpe cʉ̃ʉ̃ teero biirecʉtiri ĩñarã, “wãtĩ cʉoi” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yʉʉ niipetira sõwʉ̃pe yaa, sĩniã. Mʉ́ã yʉʉ teero tiirí ĩñarã, “yaawãnigʉ̃, sĩniwãnígʉ̃ niiĩ; niyeru wapasébosari basoca menamacʉ̃, ñañaré tiirá menamacʉ̃ niiĩ” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Basocá Cõãmacʉ̃ masĩrére cʉorá cʉ̃́ã tiirécʉtiremena tee masĩrére ẽñomasĩ́ya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sĩcʉ̃ fariseo basocʉ Jesuré: —Yʉʉ pʉtopʉ yaagʉ wáaya, jĩĩyigʉ. Jesús cʉ̃ʉ̃ya wiipʉ sããwa, yaagʉdʉ jeanuãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tiimacãpʉre sĩcõ numiṍ ñañagṍ niiyigo. “Jesús fariseo basocʉya wiipʉ yaagʉdaqui” jĩĩrére tʉoyígo. Teero tiigó, sitiaãñúrigare née, toopʉ́ wáayigo. ");
INSERT INTO tue_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Cʉ̃ʉ̃ sucubírope cʉ̃ʉ̃ye dʉpori pʉto jeanʉcã, utiyigo. Coo yaco oco cʉ̃ʉ̃ye dʉporipʉ ñaapeanʉcãyiro. Teero tiigó, cooya póañapõmena teeré coseyígo. Cʉ̃ʉ̃ye dʉporire ũpũyigo. Sitiaãñúrere dʉporipʉ píopeoyigo. ");
INSERT INTO tue_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Coo teero tiirí ĩñagʉ̃, fariseo basocʉ Jesuré yaadutiarigʉ wãcũyigʉ: “Cʉ̃ʉ̃rẽ padeñágõ ñañagṍ niiyo. Ãni profeta niigʉ̃jã, teeré masĩtoaboajĩyi”, jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús fariseo basocʉre jĩĩyigʉ: —Simón, mʉʉrẽ apeyenó wededʉgaga. —Wedeya, ʉ̃sãrẽ buegʉ́, jĩĩyigʉ cʉ̃ʉ̃pe. ");
INSERT INTO tue_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús cʉ̃ʉ̃ wãcũrémena ate queoré wedeyigʉ: —Niyeru wasorí basocʉ pʉarã́rẽ niyeru wasoyigʉ. Sĩcʉ̃ pʉacʉ̃má padegʉ wapatárocõrõ, ãpĩ pʉarã́ muĩpũrã padegʉ wapatárocõrõ wapamóyira. ");
INSERT INTO tue_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cʉ̃́ã dee tii wapatímasĩhẽrĩ ĩñagʉ̃, cʉ̃́ã wapamórere teero acabójãyigʉ. Mʉʉ yʉʉre wedeya: ¿Niipé niyeru wasogʉ́re maĩ netõnʉcã́gari? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón yʉʉyigʉ: —Yʉʉ tʉgueñarĩ, pairó wapamógʉ̃ acabónoãrigʉpe, jĩĩyigʉ. Jesús jĩĩyigʉ: —Mʉʉ diamacʉ̃́rã yʉʉa. ");
INSERT INTO tue_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús numiṍrẽ ĩña, Simónrẽ jĩĩyigʉ: —Mʉʉ atigoré ĩñaña. Yʉʉ mʉʉya wiipʉ sããatiawʉ̃; mʉʉ yʉʉre oco dʉpo coseádare néeatidutiriawʉ̃. Atigopé yaco ocoména yée dʉporire púuri tii, cooya póañapõmena tuucoséyo. ");
INSERT INTO tue_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉʉ yʉʉre ãñudutigʉ, yʉʉ wasopúrore ũpũriawʉ̃. Atigopé yʉʉ sããjearipʉ, maĩrémena yée dʉporire ũpũduriyo ména. ");
INSERT INTO tue_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉʉ yáa dupupʉre ʉse píopeoriawʉ̃. Atigopé yée dʉporipʉre sitiaãñúre píopeoyo. ");
INSERT INTO tue_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Teero tiigʉ́, yʉʉre tʉoyá: Coo pee ñañaré tiirére acabónotoayo. Coo biiro tiirémena bayiró maĩrére ẽñoyo. Ãpĩ péerogã ñañaré tiirére acabónogʉ̃, péerogã maĩrére ẽñoĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Too síro coore jĩĩyigʉ: —Mʉʉ ñañaré tiirére acabónotoaa. ");
INSERT INTO tue_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Cʉ̃ʉ̃mena yaaduira cãmerĩ́ sãĩñánʉcãyira: —¿Noã niiĩ ãni ñañaré tiirére acabógʉ? ");
INSERT INTO tue_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cʉ̃ʉ̃pe numiṍrẽ jĩĩyigʉ: —Mʉʉ padeojĩ́gõ, netõnénoãrigopʉ pʉtʉáa. Ʉseniremena pʉtʉawagoa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Too síro Jesús niipetire macãrĩ, pacamacã́rĩ, metãmacã́rĩgãpʉ wáanetõyigʉ. Ãñuré queti Cõãmacʉ̃ dutiré basocápʉre niiãdarere wedeyigʉ. Cʉ̃ʉ̃ buerá doce cʉ̃ʉ̃rẽ bapacʉtiyira. ");
INSERT INTO tue_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sĩquẽrã numiã́cã cʉ̃ʉ̃rẽ bapacʉtiyira. Cʉ̃́ã Jesús wãtĩã cõãnorira, diaré netõnénorira numiã niiyira. Sĩcõ María, cʉ̃́ã “Magdalena” jĩĩgṍ, siete wãtĩã cõãnorigo niiyigo. ");
INSERT INTO tue_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apegó Juana niiyigo. Coo manʉ Cuza wãmecʉtiyigʉ. Cʉ̃ʉ̃ Herodeyere dutibosagʉ niiyigʉ. Apegó Susana niiyigo. Ãpẽrã́ paʉ numiã́ cʉ̃́ã cʉorémena tiiápuyira. ");
INSERT INTO tue_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Paʉ basocá peemacãrĩ macãrã Jesuré ĩñarã jeayira. Jesús cʉ̃́ã paʉ neãrĩ ĩñagʉ̃, cʉ̃ʉ̃ wãcũrémena ate queoré wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sĩcʉ̃ basocʉ́ oteréperire wẽ́ẽbategʉ wáayigʉ, wiiáro jĩĩgʉ̃. Cʉ̃ʉ̃ wẽ́ẽbatewari, sĩquẽñeperi maapʉ ñaacũmuyiro. Basocá teeré cʉtadiyójãyira. Minipõná teeré yaapetijãyira. ");
INSERT INTO tue_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sĩquẽñeperi ʉ̃tãyepapʉ ñaacũmuyiro. Mana, sĩnijṍãyiro, oco manijĩ́rõ. ");
INSERT INTO tue_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sĩquẽñeperi pota watoapʉ ñaacũmuyiro. Potape teeména wiimʉ́ã, sĩãjã́yiro. ");
INSERT INTO tue_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sĩquẽñeperi ote ʉseniri ditapʉ ñaacũmuyiro. Tee wii, cienperi dʉcacʉtiyiro, jĩĩyigʉ. Teeré jĩĩtoa, bayiró wedeseremena: —Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Too síro cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ sãĩñáyira: —¿Deero jĩĩdʉgaro tiii mʉʉ queorémena wedearigue? ");
INSERT INTO tue_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Cʉ̃́ãrẽ jĩĩyigʉ: —Tíatopʉ masĩña maniríguere Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere mʉ́ãrẽ masĩrĩ tiia. Ãpẽrãrẽ́ queorémena wedenoã, yʉʉ tiirére ĩñapacara, ĩñamasĩrijããrõ jĩĩgʉ̃; yée maquẽrẽ tʉopacára, tʉomasĩ́rijããrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Yʉʉ queorémena wedearigue biiro jĩĩdʉgaro tiia: Cõãmacʉ̃ye queti niiã oteréperi. ");
INSERT INTO tue_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Basocá tee quetire tʉorá maapʉ ñaacũmuãreperibiro niicua. Cʉ̃́ã tʉomíãrigue wãcũrépʉ niirére Satanás ati, ẽmapetijãqui, cʉ̃́ã teeré padeorí jĩĩgʉ̃, Cõãmacʉ̃ netõnérĩ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ãpẽrã́ tee quetire ãñurõ ʉseniremena tʉorá ʉ̃tãyepapʉ ñaacũmuãreperibiro niicua. Cʉ̃́ã nʉcõrĩ maniréyucʉ tiiróbiro niicua. Padeorucúmi, cʉ̃́ãrẽ ñañarõ wáari, padeodújãcua. ");
INSERT INTO tue_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ãpẽrã́ tee quetire tʉorá pota watoapʉ ñaacũmuãreperibiro niicua. Tʉopacára, atibʉ́reco maquẽpere bayiró wãcũcua; pee cʉodʉgácua; atibʉ́reco ʉsenirere bayiró wãcũcua. Tee niipetire cãmotájãcu tee quetire. Cʉ̃́ã dʉcamanireyucʉ tiiróbiro niicua. ");
INSERT INTO tue_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ãpẽrã́ tee quetire tʉorá ʉseniri ditapʉ ñaacũmuãreperibiro niicua. Cʉ̃́ã ãñurõ tʉonʉnʉ́se, Cõãmacʉ̃ booró diamacʉ̃́ tiidʉgácua. Cʉ̃́ãrẽ ñañarõ wáari, teero wãcũtutuajãcua. Cʉ̃́ã pee dʉcacʉtireyucʉ tiiróbiro niicua. ");
INSERT INTO tue_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Basocá sĩãwócorigare sĩãã́ri siro, cõmerʉména bʉ́atoricua; cʉ̃́ã cãnirṍ docapʉ dʉporicua. Ʉ̃mʉã́rõpʉ péocua, toopʉ́ sããwarare ãñurõ bóearo jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tee tiiróbirora tíatopʉ basocá masĩña maniríguere masĩnoãdacu. Bauhéropʉ niirécã baurocá masĩnoãdacu. ");
INSERT INTO tue_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Teero tiirá, mʉ́ã tʉorére ãñurõ tʉonʉnʉ́seya. Ãñurõ tʉonʉnʉ́seranorẽ Cõãmacʉ̃ nemorṍ masĩré ticogʉdaqui. Tʉodʉgáheranorẽ cʉ̃́ã “tʉomasĩ́ã” jĩĩmiriguere ẽmajãgʉ̃daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús paco, cʉ̃ʉ̃ baira cʉ̃ʉ̃ niirṍpʉ jeayira. Basocá paʉ niirĩ, cʉ̃ʉ̃ pʉtopʉ jeamasĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Toopʉ́ niirira Jesuré wedeyira: —¡Coe! Mʉʉ paco, mʉʉ baira sopepʉ́ jeanʉcããyira. Mʉʉrẽ ĩñadʉgaayira, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús yʉʉyigʉ: —Cõãmacʉ̃ye quetire tʉo, cʉ̃ʉ̃ dutirére tiirá, cʉ̃́ãrã yʉʉ paco, yʉʉ baira niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sicabʉreco Jesús cʉ̃ʉ̃ buerámena dooríwʉpʉ mʉãsãyigʉ. —Jãmʉ atitaró iiníñapʉ, cʉ̃ʉ̃ jĩĩrĩ, tĩãwanʉcãyira. ");
INSERT INTO tue_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cʉ̃́ã tĩãwari, Jesús cãnijṍãyigʉ. Tiitaropʉre wĩno bayiró wẽẽcʉtʉatiyiro. Teero tiiró, ocoturí páabatesãyiro. Duadiariquioro wáayiro. ");
INSERT INTO tue_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Teero wáari ĩñarã, Jesús pʉto wáa, cʉ̃ʉ̃rẽ wãcõrã́rã, jĩĩyira: —¡Ʉ̃sãrẽ buegʉ́, ʉ̃sãrẽ buegʉ́! ¡Marĩ duadiarapʉ tiiara! Jesús wʉ̃mʉnʉcã, wĩnorẽ́, ocoturíre nʉcʉ̃ã́rĩ tiiyígʉ. Netõjṍãyiro. Nʉcʉ̃ã́jõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cʉ̃́ãrẽ jĩĩyigʉ: —¿Mʉ́ã padeoré deero wáamiĩto? Cʉ̃́ã cui, ĩñamanijõãrã, cãmerĩ́ wedeseyira: —¿Noãnó niigariye ãni, wĩnorẽ́, ocoturíre dutigʉ́? Tee cʉ̃ʉ̃ dutiri, yʉʉjã, netõnʉcã́ria, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Too síro Gerasa ditapʉ tĩãjeayira. Tiidita Galilea dita apeniñapʉ́ niicu. ");
INSERT INTO tue_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús maanʉcã́rĩ, too pʉtogã niirí macã macʉ̃ cʉ̃ʉ̃ pʉto atiyigʉ. Wãtĩã cʉogʉ́ niiyigʉ. Suti yoari sãñariyigʉ. Wiipʉ́ niiriyigʉ. Diarirare cṹũre coperipʉ niisodeaatiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Pee peti wãtĩ basocʉ́re ñeejãyigʉ. Basocá cʉ̃ʉ̃ye wãmorĩrẽ, cʉ̃ʉ̃ye dʉporire cõmedárimena siatúmiyira. Siatúpacari, cʉ̃ʉ̃pe wéetajãyigʉ. Wãtĩ cʉ̃ʉ̃rẽ basocá manirṍpʉ wáari tiirucúyigʉ. Jesuré ĩñagʉ̃, acaribí, cʉ̃ʉ̃ pʉto ñicãcoberimena jeacũmujeayigʉ. Jesús wãtĩ cʉ̃ʉ̃pʉre niigʉ̃́rẽ witiwadutiyigʉ. Cʉ̃ʉ̃pe bayiró acaribíremena jĩĩyigʉ: —Jesús Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́ macʉ̃, yʉʉre potocṍrijãña. Mʉʉrẽ bayiró sãĩã: Yʉʉre ñañarõ netõrĩ́ tiiríjãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Deero wãmecʉtii mʉʉ? jĩĩyigʉ Jesús cʉ̃ʉ̃rẽ. Wãtĩã cʉ̃ʉ̃pʉre sããwarira paʉ niirĩ: —Legión wãmecʉtia, jĩĩyigʉ—. ");
INSERT INTO tue_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ʉ̃sãrẽ niiditidiari copepʉ cõãdiocorijãña, jĩĩ bayiró sãĩyíra. ");
INSERT INTO tue_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ʉ̃tãgʉ̃pʉ́ paʉ yesea yaanucũyira. Wãtĩã bayiró sãĩyíra: —Cʉ̃́ãpʉre sããwama, jĩĩyira. —Teerora tiiyá, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cʉ̃ʉ̃ teero jĩĩrĩrã, basocʉ́pʉre niiãrira witiwa, yeseapʉre sããwayira. Yeseape opatʉdipʉ cʉtʉcʉtʉ́buawa, opataropʉ ñaacoñuã, duajõãyira. ");
INSERT INTO tue_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Teero wáari ĩñarã, yesea coterí basoca cuicocʉtʉayira. Cʉ̃́ãya macã macãrãrẽ, cã́pũrĩpʉ macãrãrẽ teeré wedeyira. ");
INSERT INTO tue_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Cʉ̃́ã wederi tʉorá, “¿deero wáaayiri?” jĩĩ ĩñarã wáayira. Jesús pʉtopʉ jeara, wãtĩã witinoãrigʉre cʉ̃ʉ̃ pʉto duiri ĩñayira. Cʉ̃ʉ̃ suti sãña, ãñurõ wedesejãyigʉ sũcã. Tee niipetirere ĩñarã, cuiyira. ");
INSERT INTO tue_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wãtĩã witinoãrigʉre netõnérĩ ĩñaãrira jearáre wedeyira. ");
INSERT INTO tue_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Niipetira Gerasapʉ niirã́ bayiró cuira, Jesuré “wáagʉa” jĩĩyira. Teero tiigʉ́, Jesús dooríwʉpʉ mʉãsãyigʉ pʉtʉawagʉdʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wãtĩã witinoãrigʉ cʉ̃ʉ̃rẽ bayiró sãĩmíyigʉ: —Yʉʉcã mʉʉmena wáagʉda, jĩĩmiyigʉ. Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mʉʉya wiipʉ pʉtʉawa, Cõãmacʉ̃ mʉʉrẽ tiiáriguere wedegʉ wáaya. Cʉ̃ʉ̃ wáa, niipetiro tiimacãpʉ Jesús cʉ̃ʉ̃rẽ tiiríguere wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús tĩãjeari, basocá ʉseniremena cʉ̃ʉ̃rẽ bocayira. Niipetira cʉ̃ʉ̃rẽ yuera tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Judíoa neãrí wii dutirá menamacʉ̃ toopʉ́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Jairo. Cʉ̃ʉ̃ Jesús pʉto ati, jeacũmu, bayiró sãĩyígʉ: —Jãmʉ yáa wiipʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sĩcõrã põnacʉtíyigʉ doce cʉ̃marĩ cʉogó. Diago tiiyígo. Jesús cʉ̃ʉ̃ pʉtopʉ wáari, paʉ cʉ̃ʉ̃rẽ tuunʉnʉ́seyira. ");
INSERT INTO tue_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cʉ̃́ã watoapʉ sĩcõ numiṍ niiyigo. Doce cʉ̃marĩ beti niiré teero niirucujãyiro. Paʉ coore ʉcotipacari, netõríyiro. ");
INSERT INTO tue_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesús sucubírope wáa, cʉ̃ʉ̃yaro sutiró yapapʉ padeñáyigo. Coo padeñárĩrã, coo diaré máata bʉʉnʉcã́jõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús sãĩñáyigʉ: —¿Noã yʉʉre padeñáĩ? Niipetira: —Padeñária, jĩĩyira. Teero tiigʉ́, Pedro jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, paʉ mʉʉrẽ tuunʉnʉ́sera tiiíya. ");
INSERT INTO tue_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús jĩĩyigʉ: —Sĩcõ yʉʉre padeñáãto. Coore yʉʉ tutuaremena netõrĩ́ tiiátʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Coo deero dutimasĩ́hẽgõ, ñapõpigora, Jesús pʉto ati, ñicãcoberimena jeacũmuyigo. Niipetira tʉocóropʉ coo deero tiigó padeñáãriguere wedeyigo. Coo máata netõã́riguecãrẽ wedeyigo. ");
INSERT INTO tue_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús coore jĩĩyigʉ: —Yáa wedego, mʉʉ padeojĩ́gõ, netõnénoãrigopʉ pʉtʉáa. Ʉseniremena pʉtʉawagoa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cʉ̃ʉ̃ coomena wedesegʉ tiirí, sĩcʉ̃ Jairoya wii macʉ̃ jeayigʉ. —Mʉʉ macõ diajõããwõ mée. Buegʉ́re nocõrõrã potocṍduya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús teeré tʉo, Jairore jĩĩyigʉ: —Wãcũpatirijãña; diamacʉ̃́rã padeoyá. Mʉʉ macõ netõjã́gõdaco. ");
INSERT INTO tue_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tiiwiipʉ́ jeagʉ, ãpẽrãrẽ́ sããwadutiriyigʉ. Pedro, Santiago, Juan, coo pacʉsʉ̃mʉã dícʉre sããwadutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Niipetira bayiró utira tiiyíra. Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Utirijãña. Coo diarico; cãnigṍ tiicó. ");
INSERT INTO tue_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Cʉ̃́ãpe cʉ̃ʉ̃rẽ buijã́miyira, coo diaariguere masĩjĩrã. ");
INSERT INTO tue_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús cooya wãmorẽ ñee, bayiró wedeseremena jĩĩyigʉ: —Wĩmagõ, wʉ̃mʉnʉcãña. ");
INSERT INTO tue_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yeeripũna coejṍã, máata wʉ̃mʉnʉcãyigo. Jesús: —Coore yaaré ecayá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Coo pacʉsʉ̃mʉã ĩñamanijõãyira. Jesús ãpẽrãrẽ́ wededutiriyigʉ teero wáaariguere. ");
INSERT INTO tue_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús cʉ̃ʉ̃ buerá docere néõyigʉ. Cʉ̃́ãrẽ tutuarere, dutirére ticoyigʉ. Teeména wãtĩãrẽ cõã, diaráre netõnémasĩrĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","“ ‘Cõãmacʉ̃ dutiré basocápʉre niiãdacu’ jĩĩrére wedera wáaya; diarecʉtirare netõnérã wáaya”, jĩĩ ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã wáara, apeyenó néewarijãña. Tuurítuarigʉ, wasopo, pugue, niyeru, suti wasoádare néewarijãña. ");
INSERT INTO tue_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mʉ́ã wiipʉ́ jeara, tiimacãpʉ mʉ́ã niiãdaro jeatuaro pʉtʉácũmuña. ");
INSERT INTO tue_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Apemacãpʉ́re mʉ́ãrẽ ñeedʉgaheri, tiimacãrẽ netõjṍãña. Tooré netõwára, tiimacã maquẽ dita mʉ́ãye dʉporipʉ túaariguere páabatecũña. Teero tiirá, mʉ́ã “atimacã́ macãrã wapa cʉoóya” jĩĩrã tiiádacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Cʉ̃́ã wáajõãyira. Wáa, Jesuyé ãñuré quetire wedeyira. Diarecʉtirare netõnéyira. ");
INSERT INTO tue_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes Galilea dita dutigʉ́ niipetire Jesús tiirére wedeseri tʉoyígʉ. Teeré tʉogʉ́, deero jĩĩmasĩriyigʉ. Sĩquẽrã “Juan masãjĩyi” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ãpẽrã́ “Elías bauájĩyi” jĩĩyira. Ãpẽrã́ “tíatopʉ macãrã profetas menamacʉ̃ masãjĩyi” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodepe jĩĩyigʉ: —Yʉʉrá Juanyá dupure páatadutiwʉ. Too docare ¿noã niigari cʉ̃́ã nocõrõ wedesegʉ? Teero tiigʉ́, Herodes Jesuré ĩñadʉgamiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús beserira coe, wedeyira cʉ̃́ã tiiáriguere. Too síro Jesús cʉ̃́ã dícʉre sʉowáyigʉ Betsaida macãpʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Basocápe tʉojã́yira. Teero tiirá, cʉ̃ʉ̃rẽ nʉnʉwáyira. Jesús cʉ̃́ãrẽ bocañe, “Cõãmacʉ̃ dutiré basocápʉre niiãdacu” jĩĩrére wedeyigʉ. Diarecʉtirare netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñamicapʉ niirĩ, cʉ̃ʉ̃ buerá doce cʉ̃ʉ̃ pʉto wáa, cʉ̃ʉ̃rẽ jĩĩyira: —Basocáre “nocõrõrã niiã” jĩĩña. Pʉtogã niiré macãrĩpʉ, cã́pũ niiré wiseripʉ yaaré, cãnirṍ ãmaãrã wáaaro. Ãnopʉ́ macã manirṍpʉ niiã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Mʉ́ã cʉ̃́ãrẽ yaaré ecayá, jĩĩyigʉ. —Ʉ̃sã sicamoquẽñepa pã, wai pʉarã́rã cʉoa. ¿Ʉ̃sã cʉ̃́ã niipetirare yaaré sãĩbosára wáaro booite? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ʉ̃mʉã́ dícʉre bapaqueori, cinco mil watoa niiyira. Jesús cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Basocáre sicapõnarẽ cincuenta duidutiya. ");
INSERT INTO tue_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cʉ̃́ã teerora niipetirare duidutiyira. ");
INSERT INTO tue_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús tee sicamoquẽñepa pãrẽ, wai pʉarã́rẽ née, ʉ̃mʉã́sepʉ ĩñamʉõco, Cõãmacʉ̃rẽ ʉsenire tico, pʉatásã, cʉ̃ʉ̃ bueráre basocápʉre batodutigʉ ticoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Niipetira yaa, yapijõãyira. Yaatoaari siro, doce piseri cʉ̃́ã yaadʉaariguere seesã́yira. ");
INSERT INTO tue_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sicabʉreco Jesús cʉ̃ʉ̃ sesaro Cõãmacʉ̃mena wedesegʉ tiiyígʉ. Cʉ̃ʉ̃ buerá cʉ̃ʉ̃mena niiyira. Cʉ̃́ãrẽ sãĩñáyigʉ: —¿Basocá “¿noã niiĩ cʉ̃ʉ̃?” jĩĩĩ yʉʉre? ");
INSERT INTO tue_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Cʉ̃́ãpe yʉʉyira: —Sĩquẽrã mʉʉrẽ “Juan basocáre wãmeõtiri basocʉ niiqui” jĩĩĩya. Ãpẽrã́ “Elías niiqui” jĩĩĩya. Ãpẽrã́ “tíatopʉ macãrã profetas menamacʉ̃ masãrigʉ niigʉ̃ niiqui” jĩĩĩya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—¿Mʉ́ãte “¿noã niiĩ?” jĩĩĩ yʉʉre? jĩĩyigʉ. Pedro yʉʉyigʉ: —Mʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Teeré ãpẽrãrẽ́ wederijãña, jĩĩyigʉ Jesús—. ");
INSERT INTO tue_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yʉʉ niipetira sõwʉ̃rẽ bayiró ñañarõ netõrṍ niirõ tiiádacu. Bʉtoá dutirá, paiaré dutirá, Moisés jóarigue buerá yʉʉre booríadacua. Sĩãdutíadacua. Cʉ̃́ã teero tiipacári, itiábʉreco siro masãgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niipetirare jĩĩyigʉ: —Sĩcʉ̃ yʉʉre padeó, nʉnʉdʉgágʉno cʉ̃ʉ̃ booró tiidʉgárenorẽ tiidújããrõ. Basocá cʉ̃ʉ̃rẽ ñañarõ jĩĩpacari, yʉʉre tʉonʉnʉ́searo. Teeré tiigʉ́, bʉ́recoricõrõ curusare apagʉ́ tiiróbiro niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ãpĩ sĩãrére cuigʉno yʉʉre “masĩria” jĩĩgʉ̃́ pecamepʉ wáagʉdaqui. Ãpĩpé yʉʉre “masĩã” jĩĩ, teewapamena cʉ̃ʉ̃rẽ sĩãrĩ́, yʉʉmena catirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sĩcʉ̃ atibʉ́reco maquẽ niipetirere wapatápacʉ, cʉ̃ʉ̃ yeeripũnarẽ tiidióri, cʉ̃ʉ̃ cʉoré dee tiiádare niiricu. ");
INSERT INTO tue_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sĩcʉ̃ bobogʉ́no yʉʉre “masĩã” jĩĩdʉgahegʉre, yée bueré maquẽrẽ “padeóa” jĩĩdʉgahegʉre yʉʉcã cʉ̃ʉ̃rẽ “masĩriga” jĩĩgʉ̃dacu. Yʉʉ niipetira sõwʉ̃ yʉʉ asibatéremena, yʉʉ Pacʉ asibatéremena, ángeleamena pʉtʉaatigʉdacu. Pʉtʉaatigʉ, yʉʉre bobosã́ririgʉre yʉʉcã cʉ̃ʉ̃rẽ bobosã́ricu; yʉʉre “masĩria” jĩĩrigʉre yʉʉcã “cʉ̃ʉ̃rẽ masĩria” jĩĩgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩquẽrã ãnopʉ́ niirã́ cʉ̃́ã diaadari sʉguero, Cõãmacʉ̃ dutiré cʉ̃́ãpʉre niiãdare atiri ĩñaãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Teeré cʉ̃ʉ̃ wederi siro, sica semana netõrĩ́, Jesús ʉ̃tãgʉ̃pʉ́ Cõãmacʉ̃mena wedesegʉ mʉãwayigʉ. Tiigʉpʉ́ wáagʉ, Pedro, Santiago, Juanrẽ́ néewayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cõãmacʉ̃mena wedeseri, cʉ̃ʉ̃ya diapóa bauré wasojṍãyiro. Cʉ̃ʉ̃ye suti ãñurõ butiré, bayiró capemóre wáayiro. ");
INSERT INTO tue_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pʉarã́ ʉ̃mʉã cʉ̃ʉ̃mena wedeseyira. Moisés, Elías niiyira. ");
INSERT INTO tue_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Asibatéremena bauáyira. Jesús diaadarere, Cõãmacʉ̃ jĩĩrirobirora Jerusalénpʉ cʉ̃ʉ̃rẽ wáaadarere wedeseyira. ");
INSERT INTO tue_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, cʉ̃ʉ̃ menamacãrã wʉgoá pũninetõpacari, ĩñayira. Wãcã, Jesús asibatérere, cʉ̃ʉ̃mena nucũrã́rẽ ĩñayira. ");
INSERT INTO tue_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jesuména niiãrira wáara tiirí, Pedro ãñurõ wãcũripacʉ, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, marĩ ãnopʉ́ niirĩ, ãñunetõjõãã. Itiáwiigã tiicó; sicawiígã mʉʉya wii, apewiígã Moiséya wii, apewiígã Elíaya wii tiicó, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cʉ̃ʉ̃ wedesegʉ tiiríra, õme diiáti, cʉ̃́ãrẽ tuubiátocojãyiro. Cʉ̃́ãrẽ õme tuubiári, cuijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Õme watoapʉ sĩcʉ̃ wedeseri tʉoyíra: —Ãni yʉʉ macʉ̃ yʉʉ beserigʉ niiĩ. Cʉ̃ʉ̃rẽ tʉoyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wedeseari siro, Jesús sĩcʉ̃rã niiyigʉ sáa. Teebʉrecorire cʉ̃ʉ̃ buerá cʉ̃́ã ĩñariguere ãpẽrãrẽ́ wederiyira ména. ");
INSERT INTO tue_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Apebʉ́recope ʉ̃tãgʉ̃pʉ́ niiãrira diijeári, paʉ basocá Jesuré bocayira. ");
INSERT INTO tue_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sĩcʉ̃ cʉ̃́ã watoapʉ niigʉ̃́ bayiró bʉsʉrómena Jesuré wedeseyigʉ: —Ʉ̃sãrẽ buegʉ́, mʉʉrẽ bayiró sãĩã: Yʉʉ macʉ̃rẽ ĩñagʉ̃ atiya. Sĩcʉ̃ niigʉ̃́ niiĩ. ");
INSERT INTO tue_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wãtĩ cʉ̃ʉ̃pʉre niigʉ̃́ ñee, acaribíri tiii. Ñaacũmu, tũnumecʉ̃́, soboturi tiirucúi. Cʉ̃ʉ̃rẽ ñañarõ netõrĩ́ tiii. Duudʉgárii. ");
INSERT INTO tue_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉʉ bueráre “cõãwionecobosaya” jĩĩmiãwʉ̃. Cõãmasĩriawã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã yʉʉre padeorídojãã; ñañarã́ niiã. Yʉʉ mʉ́ãmena yoari niirucujãrĩcãrẽ, padeoríbocu. ¿Nocõrõ yoari mʉ́ãmena põõtẽ́õgʉ̃dari yʉʉ? Mʉʉ macʉ̃rẽ ãnopé néeatiya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wĩmagʉ̃ cʉ̃ʉ̃ pʉto wáari, wãtĩ cʉ̃ʉ̃rẽ ñaacũmu, bayiró tũnumecʉ̃́rĩ tiiyígʉ. Cʉ̃ʉ̃ teero tiirí, Jesús wãtĩrẽ witiwaduti, wĩmagʉ̃rẽ netõné, cʉ̃ʉ̃ pacʉre wiyayígʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Niipetira basocá Cõãmacʉ̃ ʉpʉtí macʉ̃ peti tiiẽ́ñorere ĩñamanijõãyira. Niipetira niipetire cʉ̃ʉ̃ tiiáriguere ĩñamanijõãrĩ, cʉ̃ʉ̃ bueráre jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Yʉʉ ateréja diamacʉ̃́rã jĩĩã; acabórijãña: Yʉʉ niipetira sõwʉ̃ ãpẽrãpʉ́re ticonogʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cʉ̃́ãpe cʉ̃ʉ̃ jĩĩãriguere tʉomasĩ́riyira. Cõãmacʉ̃ cʉ̃́ãrẽ tʉomasĩ́hẽrĩ tiiyígʉ ména. Cʉ̃́ã Jesuré “wedequẽnoña” jĩĩdʉgapacara, cuira, jĩĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesús buerá “¿nii marĩ watoare nemorṍ ʉpʉtí macʉ̃ niiĩ?” jĩĩ wedesenʉcãyira. ");
INSERT INTO tue_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús cʉ̃́ã wãcũrére ĩñamasĩyigʉ. Teero tiigʉ́, sĩcʉ̃ wĩmagʉ̃rẽ cʉ̃ʉ̃ pʉto nʉcõ, ");
INSERT INTO tue_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","cʉ̃́ãrẽ jĩĩyigʉ: —Sĩcʉ̃ “yʉʉ Jesuré maĩã; teero tiigʉ́, ãni wĩmagʉ̃rẽ boca maĩgʉ̃́da” jĩĩ wãcũboqui. Cʉ̃ʉ̃ teero wãcũgʉ̃, cʉ̃ʉ̃rẽ maĩgʉ̃́, yʉʉcãrẽ maĩgʉ̃́ tiii. Yʉʉre boca maĩgʉ̃́, yʉʉre ticodiocorigʉcãrẽ maĩgʉ̃́ tiii. Mʉ́ã watoapʉ bʉ́ri niigʉ̃́ cʉ̃ʉ̃rã́ niiĩ ʉpʉtí macʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan jĩĩyigʉ: —Ʉ̃sãrẽ buegʉ́, sĩcʉ̃ mʉʉ wãmemena wãtĩãrẽ cõãwionecori ĩñaãwʉ̃. Cʉ̃ʉ̃ marĩ menamacʉ̃ mee niiãwĩ. Teero tiirá, cʉ̃ʉ̃rẽ cãmotáawʉ̃, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesupé cʉ̃ʉ̃rẽ yʉʉyigʉ: —Cãmotárijãña. Marĩrẽ cãmotáhegʉ marĩrẽ tiiápugʉ niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús ʉ̃mʉã́sepʉ mʉãwaadare niiatiri, cuiro manirṍ “Jerusalénpʉ wáagʉdʉ” jĩĩgʉ̃, quẽnonʉcã́yigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cʉ̃ʉ̃ sʉguero ãpẽrãrẽ́ ticocoyigʉ. Cʉ̃́ã wáa, Samaria dita niirí macãpʉ jeamiyira, cʉ̃ʉ̃ jeaadarore quẽnoã́dara. ");
INSERT INTO tue_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tiimacã macãrãpe Jerusalénpʉ Jesús wáari ĩñarã, cʉ̃ʉ̃rẽ ñeedʉgariyira. ");
INSERT INTO tue_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cʉ̃́ã teero tiirí ĩñarã, cʉ̃ʉ̃ buerá Santiago, Juan jĩĩyira: —Ʉ̃sã Õpʉ̃, cʉ̃́ãrẽ sĩãã́dara, ¿ʉ̃mʉã́se macã pecamerẽ diiátidutiri boogári? Profeta Elías teero tiiyígʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús cʉ̃́ãrẽ ĩña, tutiyigʉ: —Mʉ́ã wãcũré Espíritu Santo wãcũré ticoré mee niiã. ");
INSERT INTO tue_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yʉʉ niipetira sõwʉ̃ basocáre ñañarõ tiigʉ́ atiriwʉ; cʉ̃́ãrẽ netõnégʉ̃ atigʉ tiiwʉ́, jĩĩyigʉ. Too síro apemacãpʉ́ wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cʉ̃́ã maapʉ wáari, sĩcʉ̃ basocʉ́ Jesuré jĩĩyigʉ: —Noo mʉʉ wáaro yʉʉ mʉʉrẽ nʉnʉgʉ̃́da. Mʉʉ buegʉ́ niidʉgaga. ");
INSERT INTO tue_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Wáicʉra cãniré tutiri cʉoóya. Minipõná põnacʉtíre sutiri cʉoóya. Yʉʉ niipetira sõwʉ̃peja cãnirṍ cʉoría, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús ãpĩrẽ́: —Jãmʉ yʉʉmena. Mʉʉrẽ yʉʉ buegʉ́ niirĩ boogá, jĩĩyigʉ. Cʉ̃ʉ̃pe yʉʉyigʉ: —Õpʉ̃, yʉʉ pacʉ diari siro, yaatóagʉpʉ, mʉʉmena wáagʉda sũcã, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Yʉʉre padeohéra diarirapʉ tiiróbiro niitoaya. Cʉ̃́ã basiro cãmerĩ́ yaaáro. Mʉʉpe Cõãmacʉ̃ dutiré basocápʉre niiãdarere wedegʉ wáaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ãpĩpé jĩĩmiyigʉ: —Ʉ̃sã Õpʉ̃, yʉʉ mʉʉrẽ nʉnʉgʉ̃́da, mʉʉ buegʉ́ niidʉgagʉ. Yáa wii macãrãrẽ “wáagʉ tiia” jĩĩgʉ̃ wáasʉguema. ");
INSERT INTO tue_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Sĩcʉ̃ cʉ̃ʉ̃ paderére padepacʉ, apeyenó wãcũgʉ̃, ãñurõ tiiríqui. “Cõãmacʉ̃ dutirére tiigʉ́da” jĩĩpacʉ, apeyenó wãcũgʉ̃, dee tiigʉ́dʉ niiridojãĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Too síro Jesús ãpẽrã́ setenta y dos beseyigʉ. Cʉ̃́ãrẽ pʉarã́cõrõ dícʉ ticocoyigʉ. Niipetire macãrĩpʉ cʉ̃ʉ̃ wáaadaropʉ cʉ̃ʉ̃ sʉguero ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Cʉ̃́ãrẽ wedeyigʉ: —Paʉ peti yʉʉre padeoádara niicua. Pʉarã́gã yéere wedeadarapeja niiĩya. Teero tiirá, Cõãmacʉ̃rẽ ãpẽrã́ yée maquẽrẽ wedera wáaadarare bayiró sãĩñá. ");
INSERT INTO tue_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mʉ́ã wáaya. Yʉʉ mʉ́ãrẽ quiorópʉ ticocogʉ tiia corderoare yáiwa watoapʉ ticocogʉ tiiróbiro. ");
INSERT INTO tue_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mʉ́ã wáara, wasopo, niyeru sã́ãripo, sapatu apebá néewarijãña. Maapʉ pʉtʉánʉcã, ãpẽrãména wedeserijãña. ");
INSERT INTO tue_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mʉ́ã wiipʉ́ sããwara, tiiwií macãrãrẽ ãñudutira, jĩĩsʉgueya: “Cõãmacʉ̃ mʉ́ãpʉre ãñurõ niirecʉtire ticoaro”. ");
INSERT INTO tue_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tiiwií macãrã ãñurõ niirecʉtirere cʉoátã, mʉ́ã ãñudutire teerora wáaadacu. Cʉ̃́ã ãñurõ niirecʉtirere cʉoríatã, teero wáaricu. ");
INSERT INTO tue_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mʉ́ã jeaari wiira pʉtʉáya. Cʉ̃́ã yaarére, cʉ̃́ã sĩnirére cʉ̃́ãmena yaa, niijãña. Paderáno cʉ̃́ã paderémena wapatá, yaamasĩya. Apeyé wiseripʉ́ niirã wáarijãña. ");
INSERT INTO tue_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Mʉ́ã macãpʉ jeari, too macãrã bocari, cʉ̃́ã ecarére yaaya. ");
INSERT INTO tue_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tiimacãpʉ diarecʉtirare netõnéña. “Cõãmacʉ̃ dutiré marĩpʉre niiãdare jeaatitoaa” jĩĩ wedeya cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apetó tiirá, apemacãpʉ́ jeari, too macãrã bocaribocua. Teero tiirí, macã decopʉ wáa, biiro jĩĩña: ");
INSERT INTO tue_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉ́ãya macã maquẽ dita ʉ̃sãye dʉporipʉ túaariguere páabatecõãã. Mʉ́ã wapa cʉorére ẽñorã́, teero tiia”, jĩĩña. Cʉ̃́ãrẽ jĩĩnemoña: “Mʉ́ã ateré masĩña: Cõãmacʉ̃ dutiré mʉ́ãpʉre niimiãdare jeaatitoamiãyu”, jĩĩña. ");
INSERT INTO tue_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yʉʉre tʉoyá: Cõãmacʉ̃ basocáre wapa tiiádari bʉreco jeari, tiimacã macãrãrẽ Sodoma macãrãrẽ tiiríro nemorṍ ñañarõ tiinóãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús apeyé macãrĩ macãrãrẽ jĩĩyigʉ: —Bóaneõrã niiã mʉ́ã Corazín, Betsaida macãrĩ macãrã. Yʉʉ tutuaremena tiiẽ́ñoriguere ĩñarira niipacara, wasorídojãã. Tiro, Sidón macãrĩpʉ yʉʉ tiiẽ́ñoãtã, máata tee macãrĩ macãrã cʉ̃́ã ñañaré tiirére wãcũpati, wasotóabojĩya. Cʉ̃́ã wãcũpatirere ẽñorã́, wãcũpatire suti sãña, nitĩpʉ duibojĩya. ");
INSERT INTO tue_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, Tiro, Sidón macãrã nemorṍ mʉ́ãpere ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mʉ́ã Capernaum macãrã “Cõãmacʉ̃ pʉtopʉ ãñurõ mʉãwaadacu” jĩĩ wãcũmicu. Wáaricu. Pecamepʉ diiwáadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cʉ̃ʉ̃ bueráre wedenemoyigʉ: —Mʉ́ã buerére tʉogʉ́no yʉʉre tʉogʉ́ tiii. Mʉ́ãrẽ boohégʉno yʉʉre boohégʉ tiii. Yʉʉre boohégʉno yʉʉre ticodiocorigʉcãrẽ boohégʉ tiii, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesús ticocorira setenta y dos ʉseniremena coerá, jĩĩyira: —Ʉ̃sã Õpʉ̃, wãtĩãcã ʉ̃sã mʉʉ wãmemena dutiri, ʉ̃sã dutirobirora tiiáwã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Satanárẽ bʉpo wã́ãyoro tiiróbiro ʉ̃mʉã́sepʉ ñaadiatiri ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yʉʉ mʉ́ãrẽ tutuarere ticotoawʉ, ãñaãrẽ, cutiapare cʉtapéoaro jĩĩgʉ̃; niipetire Satanás tutuarere netõnʉcã́ãrõ jĩĩgʉ̃. Mʉ́ã teeré tiirí, mʉ́ãrẽ merẽã wáaricu. ");
INSERT INTO tue_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wãtĩã mʉ́ã dutirobirora tiiré dícʉre ʉsenirijãña. Cõãmacʉ̃ pʉtopʉ mʉ́ã wãme “jóatunorira niiã” jĩĩrĩ, ʉseniña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Toorá Jesús Espíritu Santo ʉsenire ticorémena cʉ̃ʉ̃ Pacʉre jĩĩyigʉ: —Pacʉ, mʉʉ ʉ̃mʉã́se, atiditá Õpʉ̃ niiã. “Ʉ̃sã masĩnetõnʉcãã” jĩĩrã́rẽ mʉʉyere masĩrĩ tiiría; wĩmarã tiiróbiro mʉʉyere masĩdʉgarapere teeré masĩrĩ tiia. Teeré mʉʉ teerora wáari boocú. Teero tiigʉ́, mʉʉrẽ ʉsenire ticoa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Too síro basocápere jĩĩnemoyigʉ: —Yʉʉ Pacʉ niipetire masĩrére yʉʉre ticowi. Cʉ̃ʉ̃ sĩcʉ̃rã yʉʉ niirecʉtirere masĩĩ. Yʉʉpecã sĩcʉ̃rã cʉ̃ʉ̃ niirecʉtirere masĩã. Yʉʉ masĩrére ticonorã cʉ̃ʉ̃rẽ masĩcua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cʉ̃ʉ̃ bueráre ĩña, cʉ̃́ã sesarore jĩĩyigʉ: —Mʉ́ãpeja yʉʉ tiirére ĩñajĩrã, ʉseniã. ");
INSERT INTO tue_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yʉʉre tʉoyá: Paʉ profetas, teero biiri õpãrã́ mʉ́ã ĩñarére ĩñadʉgamiyira. Ĩñaririra niiwã. Mʉ́ã tʉorére tʉodʉgámiyira. Tʉorírira niiwã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sĩcʉ̃ Moisés jóarigue buegʉ́ wʉ̃mʉnʉcãyigʉ. Jesuré merẽã yʉʉri boogʉ́, sãĩñáyigʉ: —Basocáre buegʉ́, ¿yʉʉ ñeenó tiigʉ́dari, catiré petihére bʉadʉgágʉ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —¿Moisére dutiré cṹũriguepʉ deero jóanoĩto? ¿Mʉʉ teeré buegʉ, deero tʉoi? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Cʉ̃ʉ̃pe yʉʉyigʉ: —Biiro jóanoã: “Cõãmacʉ̃ marĩ Õpʉ̃rẽ maĩñá. Niipetire mʉʉ yeeripũnamena, mʉʉ tutuaremena, mʉʉ wãcũrémena cʉ̃ʉ̃rẽ maĩñá. Mʉʉ basiro maĩrṍ tiiróbirora ãpẽrãcã́rẽ maĩñá”, jĩĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉ diamacʉ̃́ peti yʉʉa. Mʉʉ teeré tiigʉ́, catiré petihére bʉagʉ́dacu. ");
INSERT INTO tue_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cʉ̃ʉ̃pe “yʉʉ Moisére dutiré cṹũriguere tiipetía” jĩĩ wãcũdʉgagʉ sãĩñáyigʉ: —¿Noã niiĩ “ãpẽrãcã́rẽ maĩñá” jĩĩnorã? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús atequetiména yʉʉyigʉ: —Sĩcʉ̃ Jerusalén niiãrigʉ Jericópʉ búawagʉ tiiyígʉ. Maapʉ wáari, yaarépira cʉ̃ʉ̃rẽ ñee, cʉ̃ʉ̃ néewarere ẽmajã, sutiré tuuwénejã, páasĩãcũ, wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sĩcʉ̃ pai tiimapʉ́ búawagʉ tiiyígʉ. Wáa, cʉ̃ʉ̃rẽ ĩñabʉa, aperopé sodea, netõjṍãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cʉ̃ʉ̃ siro levita basocʉ toopʉ́ra jeayigʉ. Cʉ̃ʉ̃cã cʉ̃ʉ̃rẽ ĩña, aperopé sodea, netõjṍãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sĩcʉ̃ samaritanoãyʉ tiimapʉ́ra búawagʉ tiiyígʉ. Cʉ̃ʉ̃rẽ ĩña, bóaneõ ĩñagʉ̃, ");
INSERT INTO tue_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","cʉ̃ʉ̃ pʉtopʉ jea, cʉ̃ʉ̃ cãmirẽ vinomena cose, ʉsemena ʉcoti, suti caserimena dʉdʉa tiiyígʉ. Túajea, cʉ̃ʉ̃ pesarigʉ burro sotoapʉ néepeo, néejõãyigʉ. Basocá wáara cãnirí wiipʉ cʉ̃ʉ̃rẽ néejea, coteyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Apebʉ́reco cʉ̃ʉ̃ wáaadari sʉguero, pʉaquí niyeruqui néewioneco, tiiwií dutigʉ́re ticogʉ, jĩĩyigʉ: “Cʉ̃ʉ̃rẽ ãñurõ coteya. Mʉʉ cʉ̃ʉ̃rẽ cotegʉ, mʉʉye niyerumena tiinemórĩ, nemoatígʉ, wapatígʉda”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús sãĩñáyigʉ: —¿Niipé yaarépira cãmituarigʉre maĩyíri? ");
INSERT INTO tue_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Cʉ̃ʉ̃pe yʉʉyigʉ: —Cʉ̃ʉ̃rẽ bóaneõ ĩñarigʉpe, jĩĩyigʉ. —Mʉʉcã teerora tiigʉ́ wáaya, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Cʉ̃́ã maapʉ wáara, sicamacãgãpʉ jeayira. Sĩcõ Jesuré boca, cãnirṍ ticoyigo. Coo wãmecʉtiyigo Marta. ");
INSERT INTO tue_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Coo bayio wãmecʉtiyigo María. Coo Jesús wedeserere tʉogó, cʉ̃ʉ̃ye dʉpori pʉtogãpʉ duiyigo. ");
INSERT INTO tue_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martape pee paderé cʉojĩ́gõ, bayiró wãcũyigo. Coo Jesús pʉto wáa, jĩĩyigo: —Õpʉ̃, yʉʉ bayio padedujãyo. ¿Mʉʉ teeré ĩñarii? Yʉʉre tiiápudutiya, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús coore yʉʉyigʉ: —Marta, mʉʉ pee tiirére bayiró peti wãcũjãã; ");
INSERT INTO tue_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","sicawãmerã ʉpʉtí maquẽ niiã. María ãñuré petire beseyo. Ãpẽrã́ teeré ẽmamasĩricua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sicabʉreco Jesús aperopʉ́ Cõãmacʉ̃mena wedesegʉ tiiyígʉ. Wedesetoari, sĩcʉ̃ cʉ̃ʉ̃ buegʉ́ jĩĩyigʉ: —Ʉ̃sã Õpʉ̃, Juan cʉ̃ʉ̃ buerére nʉnʉrã́rẽ Cõãmacʉ̃mena wedeserere bueyigʉ. Mʉʉcã ʉ̃sãrẽ bueya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús yʉʉyigʉ: —Mʉ́ã Cõãmacʉ̃mena wedesera, biiro jĩĩña: Ʉ̃sã Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́, mʉʉrẽ quioníremena padeoáda. Mʉʉ dutiré ʉ̃sãpʉre niiãdare jeaaro. Ʉ̃mʉã́se macãrã mʉʉ booré dícʉre tiicúa; atibʉ́reco macãrãcã teerora tiiáro. ");
INSERT INTO tue_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉ̃sãrẽ bʉ́recoricõrõ yaaré ticoya. ");
INSERT INTO tue_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Niipetira ʉ̃sãrẽ ñañarõ tiiráre ʉ̃sã acabóa. Teero tiigʉ́, mʉʉcã ʉ̃sã ñañaré tiirére acabóya. Jĩĩcõãsãrenorẽ cãmotáya. Ʉ̃sãrẽ ñañarõ wáari jĩĩgʉ̃, netõnéña, jĩĩña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús jĩĩnemoyigʉ: —Apetó tiigʉ́, sĩcʉ̃ mʉ́ã tiiróbiro niigʉ̃́ cʉ̃ʉ̃ya wedegʉya wiipʉ ñami decopʉ wáa, jĩĩboqui: “Yáa wedegʉ, itiága pã yʉʉre wasoya. ");
INSERT INTO tue_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yʉʉ menamacʉ̃ aperopʉ́ wáagʉ yáa wiipʉ jeaawĩ. Cʉ̃ʉ̃rẽ ecaré cʉoríga”, jĩĩboqui. ");
INSERT INTO tue_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ãpĩpé wii popeapʉ yʉʉboqui: “Yʉʉre potocṍrijãña. Sope biajã́noãwʉ̃. Yʉʉ põnamena yʉʉ cãnirṍpʉ cãnigʉ̃́ tiia. Mʉʉrẽ wʉ̃mʉnʉcã, ticogʉ wáamasĩriga”, jĩĩboqui. ");
INSERT INTO tue_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yʉʉre tʉoyá: Cʉ̃ʉ̃ya wedegʉ niipacari, wʉ̃mʉnʉcã, ticogʉ wáariqui. Potocṍnemorijããrõ jĩĩgʉ̃, wʉ̃mʉnʉcã, cʉ̃ʉ̃ boorécõrõ ticogʉ wáaqui. ");
INSERT INTO tue_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Yʉʉre tʉoyá: Mʉ́ãcã Cõãmacʉ̃rẽ sãĩñá. Sãĩrĩ́, cʉ̃ʉ̃ mʉ́ãrẽ ticogʉdaqui. Ãñurére ãmaãrã tiiróbirora sãĩrucújãña. Sãĩrucújãrã, bʉaádacu. “Sope pã́õña yʉʉre” jĩĩgʉ̃́ tiiróbiro sãĩdúrijãña. Sãĩdúheri, “jáʉ” jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sãĩgʉ̃́no cʉogʉ́daqui. Ãmaãgʉ̃no bʉagʉ́daqui. “Pã́õña” jĩĩgʉ̃́no pã́õnogʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Mʉ́ã põna yaaré sãĩrĩ́, ʉ̃tãpere ticoricu. Wai sãĩrĩ́, ãñarẽ ticoricu. ");
INSERT INTO tue_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Cãrẽquẽ diye sãĩrĩ́, cutiapare ticoricu. ");
INSERT INTO tue_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉ́ã ñañaré tiirá niipacara, mʉ́ã põnarẽ ãñurére ticomasĩã. Marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́pe nemorṍ ãñuré ticomasĩqui. Cʉ̃ʉ̃rẽ sãĩrã́rẽ Espíritu Santore ticogʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús wãtĩrẽ cõãwionecogʉ tiiyígʉ. Wãtĩ basocʉ́re wedeseheri tiiyígʉ. Cʉ̃ʉ̃ witiwaari siro, basocʉ́ wedesejõãyigʉ. Teeré basocá ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sĩquẽrã jĩĩyira: —Ãni wãtĩãrẽ dutigʉ́ Beelzebú tutuaremena wãtĩãrẽ cõãwionecoi, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ãpẽrã́ “¿niirṍrã cʉ̃ʉ̃ Cõãmacʉ̃ ticodiocorigʉ niiĩ?” jĩĩrã, cʉ̃ʉ̃rẽ Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñodutimiyira. ");
INSERT INTO tue_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesupé cʉ̃́ã wãcũrére masĩjĩgʉ̃, cʉ̃́ãrẽ jĩĩyigʉ: —Sicadita macãrã sĩcãrõména niihẽrã, cʉ̃́ã basiro cãmerĩ́quẽrã, tiidita macãrã petijṍãcua. Sicawií macãrã sĩcãrõména niihẽrã, cʉ̃́ãcã petijṍãcua. ");
INSERT INTO tue_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanás cʉ̃ʉ̃rẽ padecoterare cõãwionecori, cʉ̃ʉ̃ dutiré petijṍããdacu. Mʉ́ã yʉʉre “Beelzebú tutuaremena wãtĩãrẽ cõãwionecoqui” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Teero jĩĩãtã, mʉ́ã buerére nʉnʉrã́ wãtĩãrẽ cõãwionecora, ¿noã tutuaremena cõãwionecogari? Cʉ̃́ãrẽ sãĩñárã wáaya. Mʉ́ã wisirére cʉ̃́ã ẽñoã́dacua. ");
INSERT INTO tue_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yʉʉ Cõãmacʉ̃ tutuaremena wãtĩãrẽ cõãwionecojĩgʉ̃, ateré mʉ́ãrẽ wedea: Cõãmacʉ̃ dutiré basocápʉre niiãdare jeatoaa. ");
INSERT INTO tue_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Sĩcʉ̃ tutuagʉ pee besumena cʉ̃ʉ̃ya wiire coteri, cʉ̃ʉ̃yere merẽã tiirícua. ");
INSERT INTO tue_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","“Ate pee besumena ãñuniãdacu” jĩĩ wãcũpacari, ãpĩ nemorṍ tutuagʉ ati, cʉ̃ʉ̃rẽ netõnʉcã́qui. Cʉ̃ʉ̃ye besure ẽma, cʉ̃ʉ̃yere née, cʉ̃ʉ̃ menamacãrãrẽ batojãqui, jĩĩyigʉ. Jesús jĩĩnemoyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Yʉʉre boohégʉ yʉʉre ĩñatutigʉ niiĩ. Yʉʉre tiiápuhegʉ yʉʉre nʉnʉdʉgárare cãmotágʉ niiĩ. ");
INSERT INTO tue_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Wãtĩ basocʉ́pʉre niiãrigʉ witiwagʉ, basocá manirṍpʉ wáayigʉ cʉ̃ʉ̃ niiãdaro ãmaãgʉ̃. Bʉaríyigʉ. Bʉarí, “yʉʉ witiatiriropʉ coesã́wagʉda sũcã” jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jeagʉ, joaári wii, ãñurõ quẽnoã́ri wii tiiróbiro bʉajeáyigʉ basocʉ́pʉre. ");
INSERT INTO tue_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Too síro wáa, siete wãtĩã cʉ̃ʉ̃ nemorṍ ñañarã́rẽ “atiya mʉ́ãcã” jĩĩyigʉ. Cʉ̃́ã niipetira basocʉ́pʉre sããwa, niiyira. Basocʉ́pe cʉ̃́ã teero tiirí, nemorṍ ñañarõ netõyígʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús teeré wedeseri, sĩcõ numiṍ basocá paʉ watoapʉ niigṍ bayiró bʉsʉrómena cʉ̃ʉ̃rẽ wedeseyigo: —Mʉʉrẽ põnacʉtí masõrigo ãñurõ ʉsenico, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesupé coore jĩĩyigʉ: —Nemorṍ ʉsenicua Cõãmacʉ̃ wedesere tʉo, cʉ̃ʉ̃ dutirére tiirápeja, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesús cʉ̃ʉ̃ pʉto paʉ peti neãrã tiirí, wedesenʉcãyigʉ: —Mʉ́ã atitó macãrã ñañaré tiirá niiã; Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere ĩñadʉgacu. Jonás tiirígue tiiróbiro niiré dícʉre ĩñaãdacu. ");
INSERT INTO tue_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínive macãrã cʉ̃ʉ̃ tiiríguere ĩñarigue tiiróbiro mʉ́ã yʉʉ niipetira sõwʉ̃ tiirére ĩñaãdacu. ");
INSERT INTO tue_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Saba dita macãrã õpõ yoaro macõ atiyigo Salomón masĩrére tʉogó atigo. Mʉ́ãpe ãnopʉ́ Salomón nemorṍ masĩgʉ̃́rẽ tʉoré peti tʉojã́ã. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, mʉ́ã coo tiiróbiro tʉorírigue wapa mʉ́ãrẽ pecamepʉ cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive macãrãcã Jonarẽ́ tʉorá, wãcũpati, wasoyíra. Mʉ́ãpe ãnopʉ́ Jonás nemorṍ masĩgʉ̃́rẽ tʉoré peti tʉojã́ã. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, mʉ́ã cʉ̃́ã tiiróbiro tʉorírigue wapa mʉ́ãrẽ pecamepʉ cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Basocá sĩãwócorigare sĩãã́ri siro, bauhéropʉ dʉporiya; moocṹricua. Teero tiiróno tiirá, ʉ̃mʉã́rõpʉ péoya, toopʉ́ sããjeara ĩñaãrõ jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Capeari mʉ́ãye õpʉ̃ʉ̃rĩrẽ sĩãwócoriga tiiróbiro niiã. Mʉ́ã capeari ãñurĩ, ãñurõ ĩñaãdacu; ãñurõ tʉomasĩ́ãdacu; ñañaãtã, ĩñaricu; tʉomasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ateré tʉomasĩ́rõ booa: Mʉ́ã “ãñurõ ĩñaã” jĩĩpacara, ãñurõ ĩñaribocu. ");
INSERT INTO tue_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mʉ́ã ãñurõ ĩña, ãñurõ tʉomasĩ́dʉgara, ãñurõ tʉomasĩ́ãdacu. Sĩãwócoriropʉ niirã́ tiiróbiro ãñurõ ĩñaãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús wedeseari siro, sĩcʉ̃ fariseo basocʉ cʉ̃ʉ̃ya wiipʉ yaadutigʉ sʉowáyigʉ. Jesús sããwa, yaagʉdʉ jeanuãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo basoca cʉ̃́ã yaaadari sʉguero, cʉ̃́ã ñecʉ̃sʉ̃mʉã tiimʉ́ãatiriguere padeorá, wãmocosetoa, yaayira. Jesupé cʉ̃́ã tiirucúrobiro tiiríyigʉ. Fariseo basocʉ cʉ̃ʉ̃ teero tiirí ĩñagʉ̃, ĩñamanijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Marĩ Õpʉ̃ cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉ́ã fariseo basoca ãpẽrã́ ĩñacoropʉ dícʉ ãñurõ tiia. Baparí sotoápʉ dícʉ coseárigue tiiróbiro niiã. Popeapʉre mʉ́ã ãpẽrãyére ẽmaré, apeyé ñañaré dadanetõjõãã. ");
INSERT INTO tue_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mʉ́ã tʉomasĩ́ridojãã. Sotoá maquẽrẽ tiirígʉra popea maquẽcãrẽ tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mʉ́ã popeapʉ ãñurã́ niidʉgara, bóaneõrãrẽ ticoya. Teeré tiirá, popeapʉ coserá tiiróbiro niiãdacu. ");
INSERT INTO tue_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Bóaneõrã niiã mʉ́ã fariseo basoca. Mʉ́ã oteré metãgãrẽ “menta”, “ruda” wãmecʉtire, teero biiri niipetire yaaré sitiaãñúre tiirénorẽ seenéõ, opaquẽrĩ tiicú. Pʉamóquẽñequẽrĩ cʉorá, sicaquẽ Cõãmacʉ̃wiipʉ néewa, “yʉʉ Cõãmacʉ̃rẽ ticoré niiã” jĩĩ, pairé ticocu. Teero tiipacára, diamacʉ̃́ maquẽrẽ tiiría; Cõãmacʉ̃rẽ maĩría. Mʉ́ã oterére cʉ̃ʉ̃rẽ ticorucurobirora tee ʉpʉtí maquẽcãrẽ tiiró booa. ");
INSERT INTO tue_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Bóaneõrã niiã mʉ́ã fariseo basoca. Mʉ́ã neãré wiseripʉre sʉguero maquẽ duirépʉ dícʉ duidʉgaa. Macã decopʉ quioníremena ãñudutiri booa. ");
INSERT INTO tue_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá, teero biiri mʉ́ã fariseo basoca. Tiiditórepira niiã. Mʉ́ã masãcoperi bauhére coperi tiiróbiro niiã. Teecoperi sotoa basocá netõwára, popeapʉ bóarere masĩriya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sĩcʉ̃ Moisés jóarigue buegʉ́ jĩĩyigʉ: —Basocáre buegʉ́, mʉʉ teeré jĩĩgʉ̃, ʉ̃sãcãrẽ ñañarõ jĩĩgʉ̃ tiigá. ");
INSERT INTO tue_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Bóaneõrã niiã mʉ́ã Moisés jóarigue buerácã. Ãpẽrãrẽ́ tiipõtẽ́õña manirére tiidutía. Teeré tiidutípacara, mʉ́ãpe tiiría. ");
INSERT INTO tue_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Bóaneõrã niiã mʉ́ã. Mʉ́ã profetaye masãcoperi sotoapʉ ãñuré wiserigã tiinʉcṍã. Cʉ̃́ãrẽna mʉ́ã ñecʉ̃sʉ̃mʉã sĩãyíra. ");
INSERT INTO tue_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cʉ̃́ã sĩãríguere mʉ́ã tiirémena “ʉ̃́jʉ̃, masĩã; ãñunetõjõãã” jĩĩrã tiia. Cʉ̃́ã sĩãyíra; mʉ́ãpe wiserígã tiinʉcṍã. ");
INSERT INTO tue_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Cõãmacʉ̃ cʉ̃ʉ̃ masĩrémena jĩĩyigʉ: “Yʉʉ profetare, yée maquẽrẽ wedeadarare ticocogʉda. Sĩquẽrãrẽ sĩãã́dacua. Ãpẽrãrẽ́ ñañarõ tiidʉgára, cʉ̃́ã wáaro nʉnʉã́dacua”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Teero tiirá, atibʉ́reco nʉcãrípʉ profetare sĩãnʉcã́yira. Paʉre sĩãyíra. Mʉ́ã atitó macãrãpʉ cʉ̃́ã teero tiiríguere wapa cʉoa. ");
INSERT INTO tue_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelre sĩãríguere tée Zacaríare sĩãríguere mʉ́ã wapa cʉoa. Zacaríare sĩãyíra Ãñurí Tatia sããwaro pʉtopʉ. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã atitó macãrãpʉ cʉ̃́ã teero tiiríguere wapa cʉoa. ");
INSERT INTO tue_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Bóaneõrã niiã mʉ́ã Moisés jóarigue buerá. Mʉ́ã “ãpẽrã́ Cõãmacʉ̃ye queti jóaripũrẽ buerijããrõ” jĩĩ wãcũcu. Teero wãcũpacara, tiipũrẽ ãñurõ bueria. Tiipũ maquẽrẽ masĩdʉgarare cãmotájãã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús wáari, Moisés jóarigue buerá, teero biiri fariseo basoca bayiró cúayira. Pee cʉ̃ʉ̃rẽ sãĩñá potocṍnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Cʉ̃ʉ̃ merẽã yʉʉri boomíyira, wedesããda jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Basocá paʉ peti Jesús pʉtopʉ neãyira. Paʉ niijĩrã, cãmerĩ́ cʉtadiyóyira. Jesús cʉ̃ʉ̃ buerá dícʉre wedesʉgueyigʉ: —Fariseo basocaye pã púuri tiirére tʉomasĩ́rõ booa. Tee jĩĩditoremena padeoré niicu. ");
INSERT INTO tue_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bauhéropʉ niiré bauádacu. Ĩñahẽrõpʉ tiiré masĩnoãdacu. ");
INSERT INTO tue_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Teero tiirá, ñamipʉ ãpẽrã́ tʉohéropʉ jĩĩrigue niipetira tʉocóropʉ wedenoãdacu. Wii popeapʉ yayióropʉ jĩĩrigue wii sotoápʉ niipetira tʉocóropʉ bayiró bʉsʉrómena wedenoãdacu. ");
INSERT INTO tue_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Mʉ́ã yʉʉ menamacãrã, yʉʉre tʉoyá: Basocáre sĩãrã́rẽ cuirijãña. Mʉ́ãye õpʉ̃ʉ̃rĩrẽ sĩãã́ri siro, mʉ́ãrẽ deero tii masĩricua. ");
INSERT INTO tue_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yʉʉ mʉ́ãrẽ “¿niipére cuiro booi?” jĩĩ wedegʉda: Sĩcʉ̃ dícʉ mʉ́ã catirére petirí tii, pecamepʉcãrẽ cõãmasĩĩ. Yʉʉre tʉoyá: Cʉ̃ʉ̃ docare cuiya. ");
INSERT INTO tue_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Pʉaquígã niyeruquirigãmena sicamoquẽñerã minipõnágã sãĩnóã. Cʉ̃́ã wapamanípacari, Cõãmacʉ̃pe cʉ̃́ãcõrõrẽ ĩñanʉnʉsei. ");
INSERT INTO tue_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mʉ́ãye póarire “noquẽ pee niiã” jĩĩmasĩjãqui. Teero tiirá, cuirijãña. Mʉ́ã paʉ minipõná nemorṍ wapacʉtíra niiã. ");
INSERT INTO tue_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yʉʉre tʉoyá: Basocá ĩñacoropʉ sĩcʉ̃ yʉʉre “padeóa” jĩĩgʉ̃́rẽ yʉʉ niipetira sõwʉ̃cã ángelea ʉ̃mʉã́se macãrã ĩñacoropʉ “yʉʉre padeogʉ́ra niiĩ” jĩĩ wedegʉda. ");
INSERT INTO tue_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Basocá ĩñacoropʉ sĩcʉ̃ yʉʉre “cʉ̃ʉ̃rẽ padeogʉ́ mee niiã” jĩĩgʉ̃́rẽ yʉʉcã ángelea ĩñacoropʉ “yʉʉre padeogʉ́ mee niiĩ” jĩĩgʉ̃da. ");
INSERT INTO tue_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Sĩcʉ̃ niipetira sõwʉ̃rẽ ñañarõ wedesepacari, Cõãmacʉ̃ acabógʉdaqui. Espíritu Santore ñañarõ wedeseripereja, acabóriqui. ");
INSERT INTO tue_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ãpẽrã́ mʉ́ãrẽ wedesããdacua. Judíoa neãré wiseripʉ, queti beserí basoca pʉtopʉ, dutirá pʉtopʉ mʉ́ãrẽ néewari, “¿deero yʉʉadari; deero jĩĩãdari?” jĩĩ wãcũhẽrãrã wáawa. ");
INSERT INTO tue_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mʉ́ã wedeseadarere Espíritu Santo mʉ́ãrẽ masĩrĩ tiigʉ́daqui, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sĩcʉ̃ basocá watoapʉ niigʉ̃́ Jesuré jĩĩyigʉ: —Basocáre buegʉ́, ʉ̃sã pacʉ diagʉ cṹũriguere yʉʉ sõwʉ̃ cʉoquí. “Mʉʉ baiyére ticoya”, jĩĩbosaya cʉ̃ʉ̃rẽ. ");
INSERT INTO tue_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Yʉʉ mʉ́ãrẽ queti beserí basocʉ, mʉ́ãyere batogʉ atirigʉ mee niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Basocáre jĩĩyigʉ: —Ãñurõ tiiyá. Apeyeré boonemósãrijãrõ booa. Mʉ́ã cʉoré, pairó niipacaro, mʉ́ãrẽ catiré ticonemoricu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cʉ̃ʉ̃ wãcũrémena ate queoré wedeyigʉ. —Sĩcʉ̃ pee apeyé cʉogʉ́ niiyigʉ. Cʉ̃ʉ̃ya ditapʉre pee ote dʉcacʉtiyiro. ");
INSERT INTO tue_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cʉ̃ʉ̃ wãcũyigʉ: “¿Deero tiigʉ́dariye yʉʉ? Ate oteré dʉcare ĩñanorõ maniã”. ");
INSERT INTO tue_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cʉ̃ʉ̃ basiro jĩĩyigʉ: “Biiro tiigʉ́da: Yʉʉ yaaré ĩñanore wiserire weebatédioco, nemorṍ pacawiséri tiigʉ́da. Tee wiseripʉ niipetire ote dʉcare, apeyé yʉʉ cʉorére ĩñanogʉ̃da. ");
INSERT INTO tue_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Túajea, yʉʉ basiro jĩĩgʉ̃da: ‘Peecʉ̃marĩ maquẽ niiãdare ĩñanotoaa. Teero tiigʉ́, yeerisã, boseya, sĩni, ʉseni tiigʉ́da’ ”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Cõãmacʉ̃ cʉ̃ʉ̃rẽ jĩĩyigʉ: “Mʉʉ tʉomasĩ́ridojãã. Mecʉ̃ã macã ñamirã diajõãgʉ̃dacu. Mʉʉ ĩñanorigue ãpẽrãrẽ́ pʉtʉáadacu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Teerora wáaa sĩcʉ̃ Cõãmacʉ̃rẽ wãcũhẽgʉ̃ cʉ̃ʉ̃ye niiãdarere seenéõ cʉogʉ́re. Cõãmacʉ̃ ĩñacoropʉre bóaneõgʉ̃ peti niiqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Teero tiigʉ́, mʉ́ãrẽ ateré wedea: Mʉ́ã niirecʉtirere wãcũpatirijãña. “¿Ñeenó yaaadari; ñeenó sãñaãdari marĩ?” jĩĩ wãcũpatirijãña. ");
INSERT INTO tue_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Marĩ catirépe yaaré nemorṍ wapacʉtía. Marĩye õpʉ̃ʉ̃rĩpe suti nemorṍ wapacʉtía. ");
INSERT INTO tue_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minipõná maquẽrẽ wãcũña ména. Cʉ̃́ã oteriya. Oteré dʉca seeríya. Yaaré ĩñanore wiseri cʉorícua. Teero cʉorípacari, Cõãmacʉ̃ cʉ̃́ãrẽ yaaré ticoqui. Mʉ́ãpe minipõná nemorṍ wapapacánetõnʉcãã. ");
INSERT INTO tue_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mʉ́ã bayiró wãcũpatira, bʉcʉánemoricu. ");
INSERT INTO tue_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mʉ́ã teero wãcũpatipacara, tee bʉ́ri niirére tiimasĩ́ria. Teero tiimasĩ́ripacara, ¿deero tiirá pee wãcũpatii? ");
INSERT INTO tue_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Coori macãnʉcʉ̃ maquẽrẽ wãcũña. Tee booró wiicú. Paderipacaro, suti suaripacaro, suti ãñuré sãñaré tiiróbiro baua. Teero biipacari, yʉʉ ateré jĩĩã: Salomón suti ãñuré peti sãñapacʉ, coorire sĩcãrĩbíriyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sicabʉrecora tee catia; apebʉ́reco sĩniã́riguepʉ boea; too síro sóejãnoã. Cõãmacʉ̃ teecorire ãñuré suti sãñarõ tiiróbiro baurí tiii. Nemorṍ mʉ́ãpereja ãñurõ cotequi. Mʉ́ã péerogã padeoré cʉorá niiã. ");
INSERT INTO tue_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mʉ́ã yaaadarere, mʉ́ã sĩniã́darere wãcũpatirijãña. ");
INSERT INTO tue_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Niipetire dita macãrã Cõãmacʉ̃rẽ padeohéra tee niipetirere wãcũpatiya. Marĩ Pacʉ ʉ̃mʉã́sepʉ niigʉ̃́ mʉ́ã boorénorẽ masĩtoai mée. ");
INSERT INTO tue_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mʉ́ãpe Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere boosʉguéya. Teero tiirí, mʉ́ãrẽ dʉsarére ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Mʉ́ã yáara oveja tiiróbiro niiã. Mʉ́ã paʉ niiripacara, cuirijãña. Mʉ́ã Pacʉ cʉ̃ʉ̃ dutiré mʉ́ãpʉre niiãdarere mʉ́ãrẽ jeari bootóai mée. ");
INSERT INTO tue_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mʉ́ã cʉorére dúa, bóaneõrãrẽ ticoya. Ʉ̃mʉã́se maquẽ Cõãmacʉ̃ye niiãdarere padeya. Teero tiirí, ʉ̃mʉã́se maquẽ mʉ́ã wapatáre petirícu. Ʉ̃mʉã́sepʉ mʉ́ãye niiré petiría. Toopʉ́re mʉ́ãyere yaamasĩ́ricua. Butuacã teeré tʉ́amasĩricua. ");
INSERT INTO tue_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ʉ̃mʉã́sepʉ mʉ́ãye niirĩ, Cõãmacʉ̃ye dícʉre wãcũãdacu. ");
INSERT INTO tue_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Mʉ́ã ãñurõ quẽno, suti sãña, sĩãwócoriga sĩã, yuerá tiiróbiro niiña. ");
INSERT INTO tue_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Padecotera ãñurã́ tiiróbiro tiiyá. Cʉ̃́ã õpʉ̃ wãmosíari bosebʉreco wáarigʉ pʉtʉajeagʉ, sʉorí, máata pã́õsõnecoada jĩĩrã, cotecua. ");
INSERT INTO tue_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Padecotera ãñurã́ cʉ̃́ãrẽ dutirére tiirucúcua. Teero tiirá, cʉ̃́ã õpʉ̃ pʉtʉajeari, ʉsenicua. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃́ã õpʉ̃ basirora cʉ̃́ãrẽ yaaré batogʉdʉ quẽnogʉ̃́daqui. “Yaaadara jeanuãña” jĩĩ, cʉ̃́ãrẽ batogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ñami deco, bóeri, cʉ̃ʉ̃ pʉtʉajeari, cʉ̃ʉ̃ dutirére tiirá, ʉseniãdacua. ");
INSERT INTO tue_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wii õpʉ̃ “tii hora niirĩ, yaarépigʉ jeagʉdaqui” jĩĩ masĩgʉ̃, cãniríboqui. Cʉ̃ʉ̃ya wiire pã́õsãrĩ jĩĩgʉ̃, cãmotáqui. ");
INSERT INTO tue_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mʉ́ãcã ãñurõ yueya. Mʉ́ã wãcũhẽritabe, yʉʉ niipetira sõwʉ̃ pʉtʉaatigʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro sãĩñáyigʉ: —Ʉ̃sã Õpʉ̃, ¿mʉʉ teeré ʉ̃sã dícʉre wedegʉ tiiárĩ, o niipetirare wedearĩte? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús queorémena yʉʉyigʉ: —Sĩcʉ̃ ʉ̃mʉ ãñurõ masĩgʉ̃́ cʉ̃ʉ̃ õpʉ̃yere ãñurõ dutibosagʉ niiqui. Mʉ́ã cʉ̃ʉ̃ tiiróbiro niiña. Cʉ̃ʉ̃ õpʉ̃ aperopʉ́ wáagʉ, cʉ̃ʉ̃rẽ jĩĩqui: “Yáa wii macãrãrẽ bʉ́recoricõrõ yaaré ticoya”, jĩĩqui. ");
INSERT INTO tue_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ãñurõ dutibosagʉ cʉ̃ʉ̃rẽ dutiariguere tiirucúqui. Teero tiigʉ́, cʉ̃ʉ̃ õpʉ̃ coerí, ʉseniqui. ");
INSERT INTO tue_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cʉ̃ʉ̃ ãñurõ tiiré wapa cʉ̃ʉ̃ õpʉ̃ niipetire cʉ̃ʉ̃ cʉorére dutibosagʉ sõnecogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ãpĩpé “yʉʉ õpʉ̃ máata coeríqui” jĩĩ wãcũgʉ̃, ñañarõ tiiquí. Padecotera ʉ̃mʉã́rẽ, numiã́rẽ ñañarõ tiinʉcã́qui. Boseya, sĩni, cũmujãqui. ");
INSERT INTO tue_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cʉ̃ʉ̃ õpʉ̃ cʉ̃ʉ̃ wãcũhẽritabe, coegʉ́daqui. Cʉ̃ʉ̃ dutiriguere tiirírigue wapa bayiró ñañarõ tiigʉ́daqui. Cõãmacʉ̃rẽ padeohérare cõãriropʉ cʉ̃ʉ̃rẽ cõãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ãpĩ dutibosagʉ cʉ̃ʉ̃ õpʉ̃ boorére masĩpacʉ, ãñurõ quẽno, ĩñacoriqui. Cʉ̃ʉ̃ dutiariguere tiiríqui. Teero tiigʉ́, bayiró tãnanógʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ãpĩpé cʉ̃ʉ̃ õpʉ̃ boorére masĩhẽgʉ̃, boohérenorẽ tiijã́qui. Teero tiigʉ́, péerosãñurõ tãnanógʉ̃daqui. Pee masĩré ticonogʉ̃ nemorṍ wapasénogʉ̃daqui. Teero biiri “nemorṍ ãñurõ tiigʉ́daqui” jĩĩnogʉ̃ nemorṍrã “teero tiiró booa” jĩĩnogʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Yʉʉ atibʉ́recopʉ basocá ñañaré tiirére cõãgʉ̃ atiwʉ ñañarére sóecõãrõ tiiróbiro. Mecʉ̃tígãrẽ basocá ñañaré tiirére cõãnoãrirapʉ niirĩ tiitóadʉgamiga ñañarére sóecõãre tiiróbiro. ");
INSERT INTO tue_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉʉre ñañarõ netõrṍ niirõ tiia ména. Yʉʉ ñañarõ netõã́darere wãcũgʉ̃, bayiró wãcũpatia. ");
INSERT INTO tue_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Atibʉ́recopʉre ãñurõ niirecʉtire maquẽrẽ néeatigʉ tiiquí”, ¿jĩĩ wãcũĩ mʉ́ã yʉʉre? Teeré néeatigʉ mee tiiwʉ́. Cãmerĩ́ tuudʉcáwarere néeatigʉ tiiwʉ́. ");
INSERT INTO tue_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mecʉ̃ãmena sicamoquẽñerã sicawií macãrã cãmerĩ́ tuudʉcáwaadacua. Ĩtĩã́rã pʉarã́mena ĩñadʉgariadacua. Pʉarã́ ĩtĩã́rãmena ĩñadʉgariadacua. ");
INSERT INTO tue_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pacʉ macʉ̃ména ĩñadʉgarigʉdaqui; macʉ̃ pacʉména ĩñadʉgarigʉdaqui. Paco macõména ĩñadʉgarigodaco; macõ pacoména ĩñadʉgarigodaco. Mañecṍ coo macʉ̃ nʉmoména ĩñadʉgarigodaco; macʉ̃ nʉmo mañecõména ĩñadʉgarigodaco, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús basocáre jĩĩnemoyigʉ: —Oco ñiimʉ́ãatiri, “oco peaadaro tiia” jĩĩã. Mʉ́ã jĩĩãrirobirora oco peaa. ");
INSERT INTO tue_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Muĩpũ bayiró asimʉ́ãatiri, “mecʉ̃ã cʉ̃maã́daro tiia” jĩĩã. Mʉ́ã jĩĩãrirobirora cʉ̃maã. ");
INSERT INTO tue_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉ́ã tiiditórepira niiã. Atiditá maquẽ, teero biiri ʉ̃mʉã́se maquẽ ĩñarã, “biiro wáaadacu” jĩĩmasĩã. Teero masĩpacara, atitó wáarepere ĩñarã, “biiro jĩĩdʉgaro tiia” jĩĩmasĩridojãã. ");
INSERT INTO tue_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Mʉ́ã basiro diamacʉ̃́ maquẽrẽ besemasĩrõ booa. ");
INSERT INTO tue_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sĩcʉ̃ mʉʉrẽ wedesãgʉ̃ queti beserópʉ néewaboqui. Mʉ́ã wáarara, “máata quẽnojã́co” jĩĩña. Quẽnohẽ́rĩ, mʉʉrẽ queti beserí basocʉ pʉtopʉ wéewagʉdaqui. Queti beserí basocʉ surarapʉre wiya, cʉ̃ʉ̃pe peresuwiipʉ sõnecogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yʉʉre tʉoyá: Mʉʉ wapatípetihegʉ, witiricu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Teebʉrecorire sĩquẽrã basocá Jesuré Pilato tiiríguere wedeyira: —Galilea macãrã wáicʉra sĩã, Cõãmacʉ̃rẽ ticoadara tiirí, Pilato cʉ̃́ãrẽ sĩãdutíyigʉ. Basocá diari, cʉ̃́ãye díi wáicʉraye díimena wʉ́ojõãyiro, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —“Cʉ̃́ã sĩãnórira niijĩrã, ãpẽrã́ Galilea macãrã nemorṍ ñañaré tiiríra niijĩya”, jĩĩ wãcũcu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Niiria. Yʉʉre tʉoyá: Mʉ́ã ñañaré tiirére wãcũpatihera, wasohéra, mʉ́ã niipetira cʉ̃́ã tiiróbiro diaadacu. ");
INSERT INTO tue_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloé Wii ʉ̃mʉã́ri wii jṍẽdiari, dieciocho diayira. “Cʉ̃́ã niipetira Jerusalénpʉ niirira nemorṍ ñañaré tiiríra niijĩya”, jĩĩ wãcũbocu. ");
INSERT INTO tue_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Niiria. Yʉʉre tʉoyá: Mʉ́ã ñañaré tiirére wãcũpatihera, wasohéra, mʉ́ã niipetira cʉ̃́ã tiiróbiro diaadacu, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús cʉ̃ʉ̃ wãcũrémena ate queoré wedeyigʉ: —Sĩcʉ̃ basocʉ́ cʉ̃ʉ̃ya ditapʉ sicagʉ́ higueragʉ oterigʉ cʉoyígʉ. “¿Dʉcacʉtimiĩto?” jĩĩgʉ̃, ĩñagʉ̃ wáayigʉ. Tiigʉpé dʉcamaniyiro. ");
INSERT INTO tue_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tiidita coterí basocʉre jĩĩyigʉ: “Ĩñaña. Yʉʉ atigʉ́ ‘dʉcacʉticu’ jĩĩgʉ̃, itiácʉ̃ma ĩñagʉ̃ jeamiã. Dʉcamaniã. Tiigʉré páatacõãjãña. Bʉ́ri peti cãmotá nucũã”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tiidita coterí basocʉpe jĩĩyigʉ: “Yʉʉre dutigʉ́, aticʉ̃marẽ́ nʉcõjĩ́ña ména. Yʉʉ dita ãñurõ coacṹ, nuãtuñagʉ̃dʉ tiia ména. ");
INSERT INTO tue_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Biiro tiirí, dʉcacʉtibocu. Dʉcamanirĩ docare, páatacõãjãdutiwa”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sicabʉreco judíoa yeerisãri bʉreco niirĩ, Jesús cʉ̃́ã neãrí wiipʉ buegʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Toopʉ́ sĩcõ numiṍ niiyigo. Wãtĩ coore dieciocho cʉ̃marĩ opamutĩrõ niirĩ tiiyígʉ. Diamacʉ̃́ nucũmasĩriyigo. ");
INSERT INTO tue_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús coore ĩña, atidutiyigʉ. —Mʉʉ diarére netõnénotoaa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Teero jĩĩgʉ̃rã, coore ñaapeóyigʉ. Máata diamacʉ̃́ jeaconʉcãyigo. “Cõãmacʉ̃ ãñunetõjõãgʉ̃ niiĩ”, jĩĩ, ʉsenire ticoyigo. ");
INSERT INTO tue_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesús yeerisãri bʉreco niirĩ coore netõnérĩ ĩñagʉ̃, tiiwií dutigʉ́ cúayigʉ. Basocáre jĩĩyigʉ: —Paderé bʉrecori seis bʉrecori niiã. Teebʉrecorire netõnédutira atiya. Yeerisãri bʉreco niirĩ, atirijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Tiiditórepira niiã mʉ́ã. ¿Deero tiigári mʉ́ã yeerisãri bʉreco niirĩ? Mʉ́ãyagʉ wecʉ, mʉ́ãyagʉ burrore ãñurõ tiirá, jõã, oco tĩ́ããdara wéewacu. ");
INSERT INTO tue_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Atigó Abraham pãrãmeõrẽ wãtĩ dieciocho cʉ̃marĩ siatúarigobiro cʉoárigʉ niiãwĩ. Atigoré yeerisãri bʉreco niipacari, ãñugṍ wáari tiiró booa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús teero jĩĩrĩ tʉorá, niipetira cʉ̃ʉ̃rẽ ĩñatutira bobooro wáayira. Ãpẽrã́ niipetira Jesús pee ãñurõ tiiẽ́ñorere ĩñarã, ʉseniyira. ");
INSERT INTO tue_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Too síro Jesús jĩĩyigʉ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere ate queorémena wedegʉda. ");
INSERT INTO tue_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sicape mostazape tiiróbiro niiã. Tiipegãrẽ sĩcʉ̃ basocʉ́ cʉ̃ʉ̃ya wesepʉ néewa, oteyigʉ. Tiipe wii, bʉcʉáropʉja, pairígʉ yucʉgʉ wáajãyiro. Minipõná tiigʉ́ dʉpʉripʉ põnacʉtíyira, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús wedenemoyigʉ: —Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere ate queorémena wedegʉda. ");
INSERT INTO tue_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pã púuri tiiré tiiróbiro niiã. Sĩcõ numiṍ pã tiigódo itiápo harinapori pairí bapacapʉ poosã́yigo. Harinamena pã púuri tiirére wʉ́oyigo, niipetire púuaro jĩĩgõ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús Jerusalénpʉ wáagʉ, pacamacã́rĩ, metãmacã́rĩgãpʉ buenetõwayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sĩcʉ̃ Jesuré sãĩñáyigʉ: —Ʉ̃sã Õpʉ̃, ¿Cõãmacʉ̃ pʉto wáaadara pʉarã́gã niiĩ? Jesús yʉʉyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yʉʉre tʉoyá: Paʉ Cõãmacʉ̃ pʉtopʉ sããwadʉgaadacua. Sããwadʉgapacara, sããwamasĩricua. Sããwaro esahéri sopegã tiiróbiro niiã. Sããwaro wisiópacari, sããwaada jĩĩrã, Cõãmacʉ̃yere tiirucújãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Biarítono jeari, wii õpʉ̃ wʉ̃mʉnʉcã, sopepãmarẽ biajã́gʉ̃daqui. Too síro mʉ́ã sopepʉ́ niirã́ jĩĩãdacu: “Ʉ̃sã õpʉ̃, pã́õña ʉ̃sãrẽ”. Cʉ̃ʉ̃pe yʉʉgʉdaqui: “¿Mʉ́ã noã niiĩ? Yʉʉ mʉ́ãrẽ masĩriga”. ");
INSERT INTO tue_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mʉ́ãpe jĩĩãdacu: “Marĩ sĩcãrõména yaa, sĩniwʉ̃́; mʉʉ ʉ̃sãya macãpʉre buenetõwʉ̃”. ");
INSERT INTO tue_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Cʉ̃ʉ̃pe yʉʉgʉdaqui: “Masĩriga. ¡Wáaya; mʉ́ã niipetira ñañaré tiirá niiã!” jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mʉ́ã cõãnoãrira ãpẽrãrẽ́ Cõãmacʉ̃ Õpʉ̃ niirṍpʉ niirĩ ĩñaãdacu. Abraham, Isaac, Jacob, niipetira profetare toopʉ́ niirĩ ĩñarã, pũnisíra bacadiyó, utiadacu. ");
INSERT INTO tue_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Niipetiropʉ macãrã Cõãmacʉ̃ Õpʉ̃ niirṍpʉ jeaadacua. Toopʉ́ cʉ̃ʉ̃mena yaaduiadacua. ");
INSERT INTO tue_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sĩquẽrã atitó macãrã bʉ́ri niirã́ too síropʉre ʉpʉtí macãrã niiãdacua. Ʉpʉtí macãrãpe bʉ́ri niirã́ niiãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Toorá sĩquẽrã fariseo basoca jea, cʉ̃ʉ̃rẽ jĩĩyira: —Ãnorẽ́ niirijãña. Herodes mʉʉrẽ sĩãdʉgáawĩ. ");
INSERT INTO tue_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Herodes basocʉ́ ñañagʉ̃́rẽ ateré wedera wáaya: “ ‘Bʉ́recoricõrõ wãtĩãrẽ cõãwionecogʉda; diarecʉtirare netõnégʉ̃da. Apebʉ́recope tiitúgʉda’, jĩĩãwĩ”, jĩĩña. ");
INSERT INTO tue_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mecʉ̃ã, apebʉ́reco, ñamigã bóeari bʉreco yʉʉ paderére peotíjãgʉ̃da ména. Tee petirí, Jerusalénpʉ wáagʉda. Apemacãpʉ́ profetare diamasĩña maniã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús Jerusalén macãrãrẽ wãcũgʉ̃, jĩĩyigʉ: —Jerusalén macãrã, mʉ́ã profetare sĩãrã́ niiã. Cõãmacʉ̃ye wederáre ʉ̃tãperimena déesĩãrã niiã. Mʉ́ãrẽ maĩgʉ̃́, pee peti néõdʉgamiwʉ̃. Cãrẽquẽ coo põnarẽ́ wʉ́ʉre docapʉ néõcũrõbiro tiidʉgámiwʉ̃. Mʉ́ãpe booríwʉ. ");
INSERT INTO tue_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Teero tiirá, mʉ́ãya macã cõõjṍããdacu. Yʉʉ ateré jĩĩã: Yʉʉre ĩñanemoricu; tée mʉ́ã yʉʉre “ãni Cõãmacʉ̃ ticodiocorigʉ ãñunetõjõãĩ” jĩĩrãpʉ ĩñaãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sicabʉreco judíoa yeerisãri bʉreco niirĩ, Jesús sĩcʉ̃ fariseo basocʉ Judíoare Dutirá Peti menamacʉ̃ya wiipʉ yaagʉ jeayigʉ. Tiiwií niirã́ Jesuré ãñurõ ĩñacoteyira. ");
INSERT INTO tue_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Toopʉ́ sĩcʉ̃ õpʉ̃ʉ̃ docadʉpógʉ Jesús díamacʉ̃pʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús Moisés jóarigue bueráre, fariseo basocare sãĩñáyigʉ: —¿Marĩ yeerisãri bʉreco niirĩ, diarecʉtirare netõnémasĩnogari; o netõnémasĩña manigárite? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Cʉ̃́ãpe yʉʉriyira. Jesús diagʉ́re ñaapeó, netõné, “wáagʉa” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Túajea, cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ãyagʉ burro, wecʉ copepʉ ñaasãrĩ, yeerisãri bʉreco niipacari, mʉ́ã máata néewionecocu. ");
INSERT INTO tue_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Cʉ̃ʉ̃ teero jĩĩrĩ, yʉʉmasĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo basocʉ boocónoãrira sʉguero maquẽ duirépʉ bese, duiri ĩñagʉ̃, Jesús cʉ̃́ãrẽ queorémena wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mʉ́ãrẽ wãmosíari bosebʉreco niirĩ boocóri, sʉguero maquẽ duirépʉ duirijãña. Apetó tiigʉ́, mʉ́ãrẽ boocóarigʉ menamacʉ̃ peti jeaboqui. ");
INSERT INTO tue_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mʉ́ãrẽ boocóarigʉ ati, mʉʉrẽ “ãnirẽ́ mʉʉ duiró ticoya” jĩĩboqui. Mʉʉpe boborémena niituripĩrõpʉ duigʉ wáabocu. ");
INSERT INTO tue_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Teero tiigʉ́, mʉʉrẽ boocóri, niituripĩrõpʉ jeanuãña. Mʉʉ teero tiirí ĩñagʉ̃, mʉʉrẽ boocóarigʉ jĩĩboqui: “Yʉʉ menamacʉ̃, ãnosãñúrõpe jeanuãña”. Cʉ̃ʉ̃ teero jĩĩrĩ, niipetira mʉʉmena duirá padeorémena mʉʉrẽ ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sĩcʉ̃ cʉ̃ʉ̃ basiro “ãpẽrã́ nemorṍ yʉʉre padeorí booa” jĩĩgʉ̃́ bʉ́ri niigʉ̃́ tiinógʉ̃daqui. Teero jĩĩhẽgʉ̃pereja Cõãmacʉ̃ ãpẽrãrẽ́ padeorí tiigʉ́daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús cʉ̃ʉ̃rẽ boocóarigʉre jĩĩyigʉ: —Mʉʉ boseyagʉdʉ, mʉʉ menamacãrãrẽ, mʉʉ sõwʉ̃sʉ̃mʉãrẽ, mʉʉ bairare, mʉʉya wederare, mʉʉya wii pʉto macãrã pee apeyé cʉoráre boocórijãña. Mʉʉ cʉ̃́ãrẽ boocóri, cʉ̃́ãcã mʉʉrẽ boocócãmeãdacua. Cʉ̃́ã teero tiirí, mʉʉ tiiárigue wapatíro tiiróbiro pʉtʉáadacu. ");
INSERT INTO tue_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Teero tiiróno tiigʉ́, mʉʉ bosebʉreco tiigʉ́, bóaneõrãrẽ, posarirare, wáamasĩhẽrãrẽ, ĩñahẽrãrẽ boocóya. ");
INSERT INTO tue_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Cʉ̃́ã mʉʉrẽ wapatímasĩricua. Teero tiigʉ́, Cõãmacʉ̃ mʉʉrẽ bayiró ʉsenire ticogʉdaqui. Basocá diarira ãñurã́ masãri bʉreco niirĩ, ãñuré ñeegʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sĩcʉ̃ cʉ̃́ãmena duigʉ́ Jesús jĩĩrére tʉogʉ́, jĩĩyigʉ: —Cõãmacʉ̃ Õpʉ̃ niirṍpʉ yaadutigʉ boocónoãrigʉ bayiró ʉsenigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús cʉ̃ʉ̃rẽ queorémena wedeyigʉ: —Sĩcʉ̃ basocʉ́ boseyagʉdʉ paʉ basocáre boocóyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Niipetire quẽnoã́repʉ niirĩ, cʉ̃ʉ̃rẽ padecotegʉre wedegʉ wáadutiyigʉ. “ ‘Quẽnoã́repʉ niiãwʉ̃; yaara atiya’ jĩĩña”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Cʉ̃́ã niipetirapʉra “wáamasĩriga” jĩĩyira. Niisʉguegʉ jĩĩyigʉ: “Dita sãĩã́wʉ̃. Tiiditare ĩñagʉ̃ wáagʉdʉ tiia. Teeré mʉʉrẽ dutigʉ́re wedeya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ãpĩ jĩĩyigʉ: “Wecʉá pʉamóquẽñerã sãĩã́wʉ̃. Cʉ̃́ãrẽ ĩñagʉ̃ wáagʉdʉ tiia. Teeré mʉʉrẽ dutigʉ́re wedeya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ãpĩ jĩĩyigʉ: “Yʉʉ nʉmocʉtijõããwʉ̃. Teero tiigʉ́, wáamasĩriga”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Padecotegʉ pʉtʉawa, cʉ̃ʉ̃rẽ dutigʉ́re cʉ̃́ã jĩĩãriguere wedeyigʉ. Dutigʉ́ cúagʉ, cʉ̃ʉ̃rẽ jĩĩyigʉ: “Macã decopʉ boyeromena wáagʉa. Bóaneõrãrẽ, posarirare, ĩñahẽrãrẽ, wáamasĩhẽrãrẽ sʉoátiya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Padecotegʉ jeagʉ, cʉ̃ʉ̃rẽ jĩĩyigʉ: “Mʉʉ dutiarirobirora tiiáwʉ̃. Duiré dʉsajã́ã ména”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dutigʉ́ cʉ̃ʉ̃rẽ jĩĩyigʉ: “Maapã́rĩpʉ wáagʉa. Mʉʉ bʉajeárare duucṹrõ manirṍ sʉoátiya, wii dadaaro jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yʉʉre tʉoyá: Yʉʉ boocósʉguerira yʉʉ boseyarere yaañaricua”, jĩĩyigʉ, jĩĩ wedeyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesuré paʉ basocá nʉnʉrã́ tiiyíra. Cʉ̃́ãrẽ cãmenʉcã́ ĩña, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Yʉʉ buerére nʉnʉgʉ̃́no yʉʉre bayiró maĩrṍ booa. Yʉʉre maĩpacʉ́, cʉ̃ʉ̃ pacʉre, cʉ̃ʉ̃ pacore, cʉ̃ʉ̃ nʉmorẽ́, cʉ̃ʉ̃ põnarẽ́, cʉ̃ʉ̃ya wederare, teero biiri cʉ̃ʉ̃ catirére bayiró maĩgʉ̃́no yʉʉ buegʉ́ niimasĩriqui. ");
INSERT INTO tue_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sĩcʉ̃ “yʉʉ Jesuré padeogʉ́ja diajãbocu” jĩĩ cuigʉno yʉʉ buegʉ́ niimasĩriqui. ");
INSERT INTO tue_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Sĩcʉ̃ wii pairí wii tiiádari sʉguero, cʉ̃ʉ̃ sãĩã́darere quẽnosʉguéqui. Teero tiigʉ́, cʉ̃ʉ̃ niyeru cʉorémena “wii peotígʉdacu” jĩĩmasĩqui. ");
INSERT INTO tue_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Quẽnohẽ́gʉ̃ péero tiinʉcã́, peotímasĩriboqui. Cʉ̃ʉ̃ peotíheri ĩñarã, niipetira buijã́bocua. ");
INSERT INTO tue_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Cʉ̃ʉ̃ wii tiinʉcã́miãyi; peotímasĩriayi”, jĩĩbocua. ");
INSERT INTO tue_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Teero biiri sicadita macãrã õpʉ̃ apeditá macãrã õpʉ̃mena cãmerĩ́sĩãgʉ̃ wáaadari sʉguero, dui, ãñurõ wãcũqui. “Yʉʉ diez mil suraramena veinte mil surara cʉogʉ́mena cãmerĩ́sĩãgʉ̃ wáagʉ, ¿sĩcãrĩbígʉdari?” jĩĩ wãcũqui. ");
INSERT INTO tue_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Sĩcãrĩbíricu” jĩĩgʉ̃jã, apeditá macãrã õpʉ̃ yoaropʉ niirĩrã, queti ticocoqui. “Marĩ ãñurõ niirecʉtiada jĩĩrã, ¿yʉʉ deero tiirí boogári mʉʉ?” jĩĩcoqui. ");
INSERT INTO tue_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Teero tiirá, mʉ́ãcõrõ niipetire mʉ́ã cʉorére duudʉgáhera, yʉʉ buerá niimasĩricu. ");
INSERT INTO tue_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Móã ocare yaari, ãñuniã. Móã ocaheri, nemo ocari tiimasĩ́ña manicú. ");
INSERT INTO tue_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Oterére ãñurõ wiirí tiirícu. Cõãjãrõ booa. Mʉ́ã móã ocaherebiro niirijãña. Tʉodʉgárano tʉomasĩ́ãdacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Paʉ romanuã õpʉ̃rẽ niyeru wapasébosari basoca, ãpẽrã́ ñañaré tiirá Jesús wederére tʉoádara jeayira. ");
INSERT INTO tue_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseo basoca, Moisés jóarigue buerá cʉ̃ʉ̃rẽ wedepatiyira: —Ãni ñañaré tiiráre ñee, cʉ̃́ãmena yaarucui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús cʉ̃́ãrẽ queorémena wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Cien oveja cʉogʉ́ sĩcʉ̃ ditiri ĩñagʉ̃, ¿deero tiigári cʉ̃ʉ̃? Noventa y nuevere cã́pũpʉ cṹũ, ditiarigʉre ãmaãgʉ̃ wáaqui, tée bʉagʉ́pʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bʉa, ʉsenigʉ̃, cʉ̃ʉ̃ wãmʉãpʉ néepeoqui. ");
INSERT INTO tue_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wiipʉ́ coegʉ́, cʉ̃ʉ̃ menamacãrãrẽ, cʉ̃ʉ̃ya wii pʉto macãrãrẽ sʉocó, jĩĩqui: “Yʉʉmena ʉseniña. Yáagʉ oveja ditiarigʉre bʉaáwʉ̃”, jĩĩqui. ");
INSERT INTO tue_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yʉʉre tʉoyá: Ate tiiróbiro sĩcʉ̃ ñañaré tiigʉ́ cʉ̃ʉ̃ ñañaré tiirére wãcũpati, wasorí, Cõãmacʉ̃ pʉtopʉ ʉsenire niinetõjõããdacu. Noventa y nueve wãcũpati, wasotóarirare ĩñarã, ʉseniãdacua. Cʉ̃́ãmena ʉsenirõ nemorṍ ʉseniãdacua, sĩcʉ̃ ñañaré tiigʉ́ wãcũpati, wasorí, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Apeyé wedenemoyigʉ: —Apetó tiigó, sĩcõ numiṍ pʉamóquẽñe niyeruquiri wapapacárequiri cʉobóco. Coore sicaqui ditiri, ãñurõ ãmaãpetijãboco. Sĩãwócorigare sĩãwóco, wiiré joaã́maboco, tée bʉagópʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bʉatóa, coo menamacãrãrẽ, cooya wii pʉto macãrãrẽ sʉocó, jĩĩco: “Yʉʉmena ʉseniña. Niyeruqui ditiariquire bʉaáwʉ̃”, jĩĩco. ");
INSERT INTO tue_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yʉʉre tʉoyá: Teerora ʉseniya ángelea Cõãmacʉ̃yara sĩcʉ̃ ñañaré tiigʉ́ cʉ̃ʉ̃ ñañaré tiirére wãcũpati, wasorí, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Apeyé wedenemoyigʉ sũcã: —Sĩcʉ̃ basocʉ́ pʉarã́ põnacʉtígʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cʉ̃ʉ̃ baipé cʉ̃ʉ̃ pacʉre jĩĩyigʉ: “Pacʉ, yée mʉʉ diagʉ cṹũãdarere máata ticoweojãña”. Pacʉpé teeré tʉogʉ́, cʉ̃ʉ̃ cʉorére cʉ̃́ã pʉarã́rẽ batoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","’Yoeri sirogã, cʉ̃ʉ̃ baipé niipetire cʉ̃ʉ̃yere née, yoaropʉ apeditapʉ́ wáajõãyigʉ. Toopʉ́ cʉ̃ʉ̃ néewariguere cʉ̃ʉ̃ booró ñañarõ tiibatéjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cʉ̃ʉ̃ teero tiiári siro, tiiditapʉre jʉabóare bayiró wáayiro. Cʉ̃ʉ̃ ñañarõ netõnʉcã́yigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Teero tiigʉ́, sĩcʉ̃ tiidita macʉ̃rẽ paderé sãĩgʉ̃́ wáayigʉ. Cʉ̃ʉ̃rẽ cã́pũpʉ yesea ecadutígʉ ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cʉ̃ʉ̃ yapidʉgagʉ, yesea yaaré yaadʉgamiyigʉ. Cʉ̃ʉ̃rẽ ecaríyira. ");
INSERT INTO tue_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Toopʉ́ cʉ̃ʉ̃rẽ wãcũré jeayiro: “Yʉʉ pacʉya wiipʉre padecotera paʉ niipacara, pee yaaré cʉocúa. Yʉʉpe ãnopʉ́re jʉabóa, diagʉ tiigá. ");
INSERT INTO tue_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yʉʉ pacʉ pʉtopʉ pʉtʉawagʉda. Cʉ̃ʉ̃rẽ jĩĩgʉ̃da: ‘Pacʉ, Cõãmacʉ̃rẽ netõnʉcã́tʉ; mʉʉcãrẽ teerora netõnʉcã́tʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cõãmacʉ̃rẽ, teero biiri mʉʉrẽ netõnʉcã́re wapa yʉʉre mʉʉ macʉ̃ tiiróbiro ĩñarijãña. Sĩcʉ̃ padegʉ́re tiiróbiro yʉʉre ĩñaña’, jĩĩgʉ̃da”, jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Teeré wãcũ, cʉ̃ʉ̃ pacʉ pʉtopʉ coecópʉtʉayigʉ. ’Cʉ̃ʉ̃ coepʉtʉ́aatiri, cʉ̃ʉ̃ yoaropʉ niirĩrã, cʉ̃ʉ̃ pacʉ cʉ̃ʉ̃rẽ ĩñayigʉ. Bayiró bóaneõ ĩñayigʉ. Cʉtʉwá, cʉ̃ʉ̃rẽ boca, páabʉa, cʉ̃ʉ̃ wasopúrore ũpũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Cʉ̃ʉ̃ pacʉre jĩĩyigʉ: “Pacʉ, Cõãmacʉ̃rẽ netõnʉcã́tʉ; mʉʉcãrẽ teerora netõnʉcã́tʉ. Cõãmacʉ̃rẽ, teero biiri mʉʉrẽ netõnʉcã́re wapa yʉʉre mʉʉ macʉ̃ tiiróbiro ĩñarijãña”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pacʉpé cʉ̃ʉ̃rẽ padecoterare dutiyigʉ: “Boyero suti ãñuré petire néeati, cʉ̃ʉ̃rẽ sã́ãña. Sicabeto wãmo sã́ãri beto sã́ãña; sapatu sã́ãña. ");
INSERT INTO tue_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wecʉ wĩmagʉ̃ diicʉtigʉre néeati, sĩãñá. Cʉ̃ʉ̃rẽ yaa, yʉʉ macʉ̃rẽ bosebʉreco tiipéoada. ");
INSERT INTO tue_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ãni yʉʉ macʉ̃ marĩ ‘diajõãjĩyi’ jĩĩmiãrigʉ catii. Cʉ̃ʉ̃ ditiarigʉre marĩ ĩñaã sũcã”, jĩĩyigʉ. Teero tiirá, bosebʉreco tiinʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Wesepʉ́ cʉ̃ʉ̃ macʉ̃ niisʉguegʉpe niiyigʉ. Pʉtʉaati, wii pʉtopʉ jeagʉ, basaré bʉsʉri tʉoyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sĩcʉ̃ cʉ̃ʉ̃ pacʉre padecotegʉre sʉocó, sãĩñáyigʉ: “¿Wiipʉ́re deero tiirá tiiárĩ?” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mʉʉ bai pʉtʉajeaawĩ. Cʉ̃ʉ̃ diaremanigʉ̃ niirĩ ĩña, mʉʉ pacʉ wecʉ wĩmagʉ̃ diicʉtigʉre sĩãdutíawĩ”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cʉ̃ʉ̃pe cúagʉ, sããwadʉgariyigʉ. Teero tiigʉ́, cʉ̃ʉ̃ pacʉ “sããatiya” jĩĩgʉ̃, witiwamiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cʉ̃ʉ̃pe cʉ̃ʉ̃ pacʉre jĩĩyigʉ: “Yʉʉ peecʉ̃marĩ mʉʉrẽ sĩcãrĩ netõnʉcã́rõ manirṍ padetusamiã. Sĩcʉ̃ marĩ ecagʉ́re ticoridojãã, yʉʉ menamacãrãmena ‘bosebʉreco tiiyá’ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ĩ́ni mʉʉ macʉ̃ numiã́ ñañarã́mena mʉʉyere tiibatéyigʉ. Cʉ̃ʉ̃ pʉtʉajeari, cʉ̃ʉ̃pere wecʉ wĩmagʉ̃ sĩãbosádutiayu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Cʉ̃ʉ̃ pacʉ cʉ̃ʉ̃rẽ yʉʉyigʉ: “Macʉ̃, bʉ́recoricõrõ mʉʉ yʉʉmena niiã. Niipetire yʉʉ cʉoré mʉʉye dícʉ niiã. ");
INSERT INTO tue_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Marĩ bosebʉreco tii ʉsenirõ booa. Mʉʉ bai marĩ ‘diajõãjĩyi’ jĩĩmiãrigʉ catii. Cʉ̃ʉ̃ ditiarigʉre marĩ ĩñaã sũcã”, jĩĩyigʉ, jĩĩ wedeyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús cʉ̃ʉ̃ wãcũrémena cʉ̃ʉ̃ bueráre ate queoré wedenemoyigʉ: —Sĩcʉ̃ basocʉ́ niyeru pairó cʉogʉ́ cʉ̃ʉ̃yere dutibosagʉ cʉoyígʉ. Ãpẽrãpé wáa, cʉ̃ʉ̃pʉre wedesãyira: “Mʉʉye niyerure tiibatégʉ tiii”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Cʉ̃ʉ̃rẽ dutigʉ́ cʉ̃ʉ̃rẽ atiduti, jĩĩyigʉ: “Mʉʉrẽ wedesããwã. Mʉʉ paderé jóaturipũrẽ yʉʉre wiyayá. Mʉʉ yéere dutibosagʉ niiricu sáa”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Cʉ̃ʉ̃pe wãcũyigʉ: “Yʉʉre dutigʉ́ yʉʉre cõãgʉ̃dʉ tiii. ¿Yʉʉ deero tiigʉ́dari? Yʉʉ tutuaro paderére põõtẽ́õricu sáa. Ãpẽrãrẽ́ niyeru sãĩduígʉ, bobo niigʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jã́ã, yʉʉ tiiádarere masĩtoaa. Biiro yʉʉ tiirí, yʉʉ paderé manirĩ́, yʉʉ masĩrã́ cʉ̃́ãye wiseripʉ ‘sããati, niijãña’ jĩĩãdacua yʉʉre”, jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Teero tiigʉ́, cʉ̃ʉ̃ wãcũãrirobirora tiiyígʉ: Cʉ̃ʉ̃rẽ dutigʉ́re wapamórã niipetirare sĩquẽrã dícʉ atidutiyigʉ. Jeasʉguegʉre sãĩñáyigʉ: “Mʉʉ yʉʉre dutigʉ́re ¿noquẽ wapamóĩ?” ");
INSERT INTO tue_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Yʉʉ ʉse cienpa posecʉtírepare wapamóã”, jĩĩyigʉ. “Ãjã, mʉʉ wapamóre jóaturipũ atipṹ niiã. Ãno duiya. Ateré boyeromena wasojã́ña. Ʉse cincuentapa dícʉre jóatuya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","’Cʉ̃ʉ̃mena wedeseari siro, ãpĩrẽ́ sãĩñáyigʉ: “Mʉʉte ¿noquẽ wapamóĩ?” “Cienpori trigopori wapamóã”, jĩĩyigʉ. “Ãjã, mʉʉ wapamóre jóaturipũ atipṹ niiã. Ateré wasojã́ña. Ochentapori dícʉre jóatuya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Niyeru pairó cʉogʉ́, cʉ̃ʉ̃yere dutibosagʉ ñañagʉ̃́ cʉ̃ʉ̃ tiimenírere masĩgʉ̃, “meninetṍjõããyi” jĩĩyigʉ. ’Atibʉ́reco macãrã Cõãmacʉ̃rẽ padeohéra ãñurõ meniĩ́ya cʉ̃́ã tiirére. Cʉ̃́ã Cõãmacʉ̃rẽ padeorá nemorṍ meniĩ́ya, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cʉ̃́ãrẽ wedenemoyigʉ: —Yʉʉre tʉoyá: Mʉ́ã atibʉ́reco maquẽ niyeru, apeyé cʉocú. Teeména ãpẽrãrẽ́ tiiápuya. Mʉ́ãrẽ maĩã́dacua. Mʉ́ã cʉoré petiári siro, mʉ́ã tiiápurira Cõãmacʉ̃ pʉtopʉ mʉ́ãrẽ bocaadacua. ");
INSERT INTO tue_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Bʉ́ri niirére ãñurõ tiigʉ́no ʉpʉtí maquẽcãrẽ ãñurõ tiii. Bʉ́ri niirére ãñurõ tiihégʉnope ʉpʉtí maquẽcãrẽ ãñurõ tiiríi. ");
INSERT INTO tue_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Teero biiri mʉ́ã atibʉ́reco maquẽmena ãñurõ tiihéra, Cõãmacʉ̃yere ãñurõ tiirícu. ");
INSERT INTO tue_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mʉ́ã ãpĩyére ãñurõ cotebosahera, mʉ́ãye niiboariguere ñeericu. ");
INSERT INTO tue_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Sĩcʉ̃ pʉarã́rẽ padecotemasĩriqui. Sĩcʉ̃rẽ maĩríqui; ãpĩpére maĩquí. Sĩcʉ̃rẽ padeoquí; ãpĩpére netõnʉcã́qui. Mʉ́ã niyerure maĩrã́, Cõãmacʉ̃pere maĩrícu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesús jĩĩrére fariseo basoca tʉoyíra. Cʉ̃́ã niyeru maĩrã́ niijĩrã, cʉ̃ʉ̃rẽ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã basocá ĩñacoropʉ ãñurã́ tiiróbiro niimiã. Cõãmacʉ̃pe mʉ́ã ñañarõ wãcũrére masĩjãqui. Basocá ñañarére “ãñuré niiã” jĩĩrére Cõãmacʉ̃ boorídojãqui. ");
INSERT INTO tue_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Moisére dutiré cṹũrigue, profetas jóarigue mʉ́ãrẽ dutiré niiriro niiwʉ̃, Juan jeaadari sʉguero. Cʉ̃ʉ̃ jearémena Cõãmacʉ̃ dutiré mʉ́ãpʉre niiãdarere wedenoã. Cʉ̃ʉ̃ dutiré niirṍpʉ niipetira bayiró sããwadʉgacua. ");
INSERT INTO tue_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ʉ̃mʉã́se, atibʉ́reco petijṍããdacu. Petipacári, Cõãmacʉ̃ye queti jóaripũpʉ niiré petirícu. Diamacʉ̃́ maquẽ niirucujããdacu. ");
INSERT INTO tue_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Sĩcʉ̃ cʉ̃ʉ̃ nʉmorẽ́ cõãgʉ̃, apegoré nʉmocʉtigʉ, ñañarõ tiigʉ́ tiiquí. Manʉ cõãnorigomena nʉmocʉtigʉcã ñañarõ tiigʉ́ tiiquí, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús atequetiré wedeyigʉ: —Sĩcʉ̃ basocʉ́ pee apeyé cʉogʉ́ niiyigʉ. Ãñuré suti wapapacáre dícʉ sãñayigʉ. Bʉ́recoricõrõ boseyarucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sĩcʉ̃ bóaneõgʉ̃ cʉ̃ʉ̃ya wii sããwaro yepapʉ duirucuyigʉ. Cʉ̃ʉ̃ya õpʉ̃ʉ̃ niipetiro cãmi bóayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Lázaro. ");
INSERT INTO tue_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Cʉ̃ʉ̃ pee apeyé cʉogʉ́ya mesapʉ tiibatédiocorere yaa, yapidʉgamiyigʉ. Díayia jea, cʉ̃ʉ̃ cãmirẽ neniyíra. ");
INSERT INTO tue_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Sicabʉreco diajõãyigʉ. Ángelea cʉ̃ʉ̃rẽ néewayira Abraham pʉtopʉ. Too síro pee apeyé cʉogʉ́cã diajõãyigʉ. Cʉ̃ʉ̃rẽ yaajã́yira. ");
INSERT INTO tue_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pee cʉogʉ́ niimiãrigʉ diariraniãrã niirṍpʉ jea, ñañarõ netõgʉ̃́ tiiyígʉ. Toopʉ́ cʉ̃ʉ̃ ĩñamʉõcogʉ, yoaropʉ Abrahamrẽ ĩñayigʉ. Lázaro cʉ̃ʉ̃mena niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Cʉ̃ʉ̃rẽ ĩñagʉ̃, bayiró wedeseremena jĩĩyigʉ: “Pacʉ Abraham, yʉʉre bóaneõ ĩñaña. Yʉʉ pʉtopʉ Lázarore ticocoya. Cʉ̃ʉ̃ ati, cʉ̃ʉ̃ya wãmosṹãmena oco soa, yʉʉ ñemerõrẽ yʉsʉásãrĩ tiigʉ́ atiaro. Yʉʉ atipecámepʉ ñañarõ netõgʉ̃́ tiigá”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Abraham cʉ̃ʉ̃rẽ yʉʉyigʉ: “Yáa wedegʉ, wãcũña: Mʉʉ catigʉ, ãñuré cʉotóaawʉ̃. Lázarope bayiró ñañarõ netõwĩ́. Mecʉ̃tígã cʉ̃ʉ̃ ãnopʉ́re yeeripũna ʉsenire ñeeĩ. Mʉʉpe ñañarõ netõgʉ̃́ tiia. ");
INSERT INTO tue_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dee tii ticocomasĩriga: Marĩ decopʉre ʉ̃cʉ̃ã́ri coaca niijãã. Ʉ̃sãmena niirã́ mʉ́ã pʉtopʉ wáadʉgari, dee tii masĩña maniã. Mʉ́ã pʉtopʉ niirã́cã ʉ̃sã pʉtopʉ atimasĩriya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Pee cʉogʉ́ niimiãrigʉ jĩĩyigʉ: “Too docare yʉʉ mʉʉrẽ sãĩã, pacʉ. Lázarore yʉʉ pacʉya wiipʉ ticocoya. ");
INSERT INTO tue_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Toopʉ́re yʉʉ sicamoquẽñerã baira cʉoa. Cʉ̃́ãrẽ wedegʉ wáaaro, ãno yʉʉ ñañarõ netõrṍpʉ atirijããrõ jĩĩgʉ̃”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","’Abraham jĩĩyigʉ: “Cʉ̃́ã Moisés jóariguere, profetas jóariguere cʉocúa. Teeré padeoáro”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","’Pee cʉogʉ́ niimiãrigʉ yʉʉyigʉ: “Teerora niiã, niirõpeja, pacʉ Abraham; sĩcʉ̃ diarigʉpʉ bauá wederi, cʉ̃́ã ñañaré tiirére wãcũpati, wasoádacua”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","’Abraham cʉ̃ʉ̃rẽ yʉʉyigʉ: “Moisés jóariguere, profetas jóariguere padeohéra, diarigʉpʉ bauá wederi, nemorṍ padeorícua”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Ãpẽrãrẽ́ ñañarõ jĩĩcõãsãre niirucujããdacu. Ñañarõ jĩĩcõãsãgʉ̃norẽ ñañanemorõ wáaadacu. ");
INSERT INTO tue_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cʉ̃ʉ̃ yʉʉre padeorágãrẽ ñañaré tiidutíri, cʉ̃ʉ̃rẽ nemorṍ ñañarõ wáaadacu. Cʉ̃ʉ̃rẽ ʉ̃tãgã pairígamena cʉ̃ʉ̃ wãmʉãpʉ siatúyo, día pairímaapʉ cõãñocori, nemorṍ ãñubocu. ");
INSERT INTO tue_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mʉ́ãrẽ wedetoaa mée. ’Mʉʉya wedegʉ mʉʉrẽ ñañaré tiirí, cʉ̃ʉ̃rẽ “mʉʉ ñañaré tiiáwʉ̃” jĩĩ wedeya. Cʉ̃ʉ̃ wãcũpati, wasorí, cʉ̃ʉ̃rẽ acabóya. ");
INSERT INTO tue_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cʉ̃ʉ̃ sietecõrõ sicabʉreco mʉʉrẽ ñañaré tiirí, sietecõrõ mʉʉrẽ acabóre sãĩrĩ́, acabóya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús beserira cʉ̃ʉ̃rẽ sãĩyíra: —Ʉ̃sãrẽ padeoré ticonemoña, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Marĩ Õpʉ̃ yʉʉyigʉ: —Mostazape péeripegã niiã. Mʉ́ã padeoré tiipecõrõgã niirĩ, atigʉ́ yucʉgʉ pairígʉre “wããwa, día pairímaa decopʉ nucũrõ wáaya” jĩĩbojĩyu. Mʉ́ã padeorí, tiigʉ́ mʉ́ã dutirobirora wáabojĩyu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús apeyé queorémena wedenemoyigʉ: —Apetó tiirá, mʉ́ã sĩcʉ̃ padecotegʉ cʉobócu. Cʉ̃ʉ̃ otegʉdʉ ditare coacṹgʉ̃ jeaarigʉ o oveja cotegʉ jeaarigʉ coerí, ¿deero jĩĩgari cʉ̃ʉ̃rẽ? “Sããatiya. Duiya, yaagʉdʉ jĩĩgʉ̃”, jĩĩricu. ");
INSERT INTO tue_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Biirope jĩĩcu: “Yʉʉre yaaré quẽnobosáya. Sutiró sotoá macãrõ sãña, yʉʉ yaaadarere, yʉʉ sĩniã́darere batoya. Yʉʉ yaaari siropʉ yaa, sĩnimasĩ́ã mʉʉjã”, jĩĩcu. ");
INSERT INTO tue_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Padecotegʉ mʉʉ dutirére tiirí ĩñapacʉ, cʉ̃ʉ̃rẽ “mʉʉmena ãñurõ ʉseniã” jĩĩricu. ");
INSERT INTO tue_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Teero tiirá, mʉ́ãcã cʉ̃ʉ̃ tiiróbirora niipetire Cõãmacʉ̃ dutirére tiipetítoara, “ʉ̃sã padecotera bʉ́ri niirã́ niiã; ʉ̃sãrẽ dutiré dícʉre tiiáwʉ̃” jĩĩña, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús cʉ̃ʉ̃ buerámena Jerusalénpʉ wáara, Galilea, Samaria pʉaditá watoapʉ netõwáyira. ");
INSERT INTO tue_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sicamacãpʉ cʉ̃́ã jeari, ʉ̃mʉã́ pʉamóquẽñerã õpʉ̃ʉ̃rĩ bóara bocayira. Yoaropʉ pʉtʉánʉcã, ");
INSERT INTO tue_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sʉoyíra: —Jesús basocáre buegʉ́, ʉ̃sãrẽ bóaneõ ĩñaña, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús cʉ̃́ãrẽ ĩñagʉ̃: —Paiaré ẽñorã́ wáaya, jĩĩyigʉ. Cʉ̃́ã maapʉ wáari, cʉ̃́ãye õpʉ̃ʉ̃rĩ bóare yatipetijõãyiro. ");
INSERT INTO tue_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sĩcʉ̃ yatiri ĩñagʉ̃, cãmepʉtʉ́ayigʉ. Bayiró bʉsʉrómena Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús pʉto jea, ditapʉ munibiácũmu, cʉ̃ʉ̃rẽ ʉsenire ticoyigʉ. Cʉ̃ʉ̃ Samaria dita macʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús jĩĩyigʉ: —Pʉamóquẽñerãrẽ netõnéãwʉ̃. Ãpẽrã́ nuevepe ¿noopʉ́ niigari? ");
INSERT INTO tue_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ãni judíoayʉ niihẽgʉ̃ dícʉ Cõãmacʉ̃rẽ “ãñunetõjõãĩ” jĩĩ, ʉsenire ticogʉ pʉtʉaatiayi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cʉ̃ʉ̃rẽ jĩĩyigʉ: —Wʉ̃mʉnʉcãña; wáagʉa. Mʉʉ padeojĩ́gʉ̃, netõnénoãrigʉpʉ pʉtʉáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo basoca Jesuré sãĩñáyira: —Cõãmacʉ̃ dutiré basocápʉre niiãdare ¿deero biiri jeanʉcããdari? jĩĩyira. Cʉ̃́ãrẽ yʉʉyigʉ: —Cõãmacʉ̃ dutiré basocápʉre niiãdare baurocá jearicu. ");
INSERT INTO tue_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Ãnopʉ́ niiã; jõõpʉ niiã” jĩĩña maniã́dacu. Cõãmacʉ̃ dutiré basocápʉre niiãdare mʉ́ã watoapʉ niitoaa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Too síro yʉʉ niipetira sõwʉ̃ atiditapʉ́ pʉtʉaatiri bayiró boomíãdacu mʉ́ã. “Cʉ̃ʉ̃rẽ sicabʉreco marĩ ĩñarĩ, ãñujãboayu”, jĩĩpacara, yʉʉre ĩñaricu. ");
INSERT INTO tue_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ãpẽrã́ mʉ́ãrẽ “ãno niiãwĩ; jõõ niiãyigʉ” jĩĩãdacua. Cʉ̃́ã teero jĩĩrĩ, wáarijãña; cʉ̃́ãrẽ nʉnʉríjãña. ");
INSERT INTO tue_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Apetóre bʉpo wã́ãyori, muĩpũ mʉãatirope tée cʉ̃ʉ̃ sããwarope bóesesajõãã. Teero wáarobirora wáaadacu yʉʉ niipetira sõwʉ̃ atiadari bʉreco. ");
INSERT INTO tue_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Teero wáaadari sʉguero, yʉʉre bayiró ñañarõ netõrṍ niirõ tiia ména. Atitó macãrã yʉʉre booríadacua. ");
INSERT INTO tue_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Yʉʉ niipetira sõwʉ̃ pʉtʉaatiadari sʉguerogã, Noé niirito wáarirobiro wáaadacu. ");
INSERT INTO tue_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé dooríwʉcapʉ sããwaadari sʉguero, basocá yaa, sĩni, wãmosía, cʉ̃́ã põna numiãrẽ numicũ tiiyíra. Cʉ̃ʉ̃ sããwari bʉrecore día duanetõrĩ, diapetijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","’Lot niiritocãrẽ teerora yaa, sĩni, sãĩ, dúa, ote, wiserí tii tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodoma macãpʉ niimiyigʉ. Cʉ̃ʉ̃ cʉtʉwári bʉrecore pecame, bayiró asiréperi ñaapeayiro. Teeména basocá diapetijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yʉʉ niipetira sõwʉ̃ pʉtʉaatiadari bʉrecore teerora tiiádacua. ");
INSERT INTO tue_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tiibʉrecore sĩcʉ̃ wii sotoápʉ pesaboqui. Cʉ̃ʉ̃ye wii popeapʉ niirére diiwá, néegʉ̃ sããwaripacʉ, dutijṍããrõ. Wesepʉ́ padegʉ́cã wiipʉ́ pʉtʉawaripacʉ, dutijṍããrõ. ");
INSERT INTO tue_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot nʉmorẽ wáariguere wãcũña. ");
INSERT INTO tue_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sĩcʉ̃ cʉ̃ʉ̃ catirí bʉrecorire maĩgʉ̃́, catiré petihére bʉarígʉdaqui. Cʉ̃ʉ̃ catirí bʉrecorire maĩhẽ́gʉ̃pe catiré petihére bʉagʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Yʉʉre tʉoyá: Teero wáaadari ñami pʉarã́ cõãrṍpʉ cõãã́dacua. Sĩcʉ̃ néemʉãnogʉ̃daqui; ãpĩ pʉtʉágʉdaqui. ");
INSERT INTO tue_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pʉarã́ numiã sĩcãrõména trigo wãñiãrã́ niiãdacua. Sĩcõ néemʉãnogõdaco; apegó pʉtʉágodaco. ");
INSERT INTO tue_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pʉarã́ sĩcãrõména wesepʉ́ niiãdacua. Sĩcʉ̃ néemʉãnogʉ̃daqui; ãpĩ pʉtʉágʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cʉ̃ʉ̃rẽ sãĩñáyira: —Ʉ̃sã Õpʉ̃, ¿noopʉ́ teero wáaadari? jĩĩyira. “Niipetira masĩãdacua” jĩĩgʉ̃, queorémena yʉʉyigʉ: —Bóara niirṍpʉ yucaa neãcua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús cʉ̃ʉ̃ bueráre “duucṹrõ manirṍ Cõãmacʉ̃rẽ sãĩrucújãña” jĩĩgʉ̃, ate queorémena wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Sicamacãpʉ sĩcʉ̃ queti beserí basocʉ niiyigʉ. Cʉ̃ʉ̃ Cõãmacʉ̃rẽ cuiriyigʉ. Basocáre teero ĩñajãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tiimacãpʉre sĩcõ wapewio niiyigo. Coo cʉ̃ʉ̃ pʉtopʉ wáarucuyigo, coore ñañarõ tiigʉ́mena quẽnodutígodo. ");
INSERT INTO tue_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yoari tiiápuriyigʉ. Too síro wãcũyigʉ: “Yʉʉ Cõãmacʉ̃rẽ cuiri, basocáre teero ĩñajãpacʉ, ");
INSERT INTO tue_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","atigó wapewioyere quẽnogʉ̃́da. Yʉʉ teero tiirí, yʉʉre potocṍdujãgõdaco. Teero tiihégʉ, coo naĩrõ atiri, põõtẽ́õribocu”, jĩĩyigʉ, jĩĩ wedeyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Marĩ Õpʉ̃ wedenemoyigʉ: —Queti beserí basocʉ ñañagʉ̃́ tiirére wãcũña. Cʉ̃ʉ̃ ñañagʉ̃́ niipacʉ, wapewiore tiiápuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nemorṍ Cõãmacʉ̃pe cʉ̃ʉ̃ beserirare tiiápugʉdari? ¿Ñamirĩ́, bʉ́recori cʉ̃ʉ̃rẽ sãĩrã́rẽ máata yʉʉgʉdari? ");
INSERT INTO tue_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yʉʉre tʉoyá: Pearó manirṍ cʉ̃́ã sãĩrére yʉʉgʉdaqui. Cʉ̃ʉ̃ teero yʉʉpacari, yʉʉ niipetira sõwʉ̃ atibʉ́recopʉ pʉtʉaatiri, ¿basocá padeorémena sãĩrã́rẽ bʉagʉ́dari? Bʉarícu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús pʉto ãpẽrã́ tʉorá jeayira. Cʉ̃́ã “Cõãmacʉ̃ ĩñacoropʉ ãñuré tiirá niiã” jĩĩ wãcũmiyira. Cʉ̃́ã teero wãcũjĩrã, ãpẽrãrẽ́ booríyira. Teero tiigʉ́, ate queorémena cʉ̃́ãrẽ wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pʉarã́ ʉ̃mʉã Cõãmacʉ̃wiipʉ súubusera sããwayira. Sĩcʉ̃ fariseo basocʉ niiyigʉ. Ãpĩ romanuã õpʉ̃rẽ niyeru wapasébosari basocʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo basocʉ nucũ, súubusegʉ jĩĩyigʉ: “Cõãmacʉ̃, yʉʉ ãpẽrã́ tiiróbiro niiria. Teero tiigʉ́, mʉʉrẽ ʉsenire ticoa. Cʉ̃́ã ãpẽrãyére tiiditóremena néejãcua; ñañaré tiihérare wedesãcua; nʉmocʉtira niipacara, ãpẽrã́ numiã́mena ñeeapecua. Yʉʉ ĩ́ni niyeru wapasébosari basocʉ tiiróbiro niiria. ");
INSERT INTO tue_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉʉ sica semanarẽ pʉabʉ́reco betia. Cien wapatágʉ, pʉamóquẽñe yʉʉ wapatárere mʉʉrẽ ticoa”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Niyeru wapasébosari basocʉpe yoaropʉ pʉtʉánʉcã, ĩñamʉõcoriyigʉ. Bayiró wãcũpatijĩgʉ̃, cʉ̃ʉ̃ cutirore páa, jĩĩyigʉ: “Cõãmacʉ̃, yʉʉre bóaneõ ĩñaña; yʉʉ ñañarére tiijã́miã”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesús jĩĩnemoyigʉ: —Yʉʉre tʉoyá: Niyeru wapasébosari basocʉ Cõãmacʉ̃ acabónoãrigʉpʉ cʉ̃ʉ̃ya wiipʉre coeyígʉ. Fariseo basocʉpe acabónoriyigʉ. “Yʉʉ ãpẽrã́ nemorṍ basocʉ́ ãñugʉ̃́ niiã” jĩĩ wãcũgʉ̃rẽ “bʉ́ri niigʉ̃́ niiã mʉʉ” jĩĩgʉ̃daqui Cõãmacʉ̃. Teero jĩĩ wãcũhẽgʉ̃pereja Cõãmacʉ̃ ãpẽrãrẽ́ padeorí tiigʉ́daqui, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wĩmarãrẽ Jesús pʉto néewayira ñaapeódutira. Jesús buerá teero tiirí ĩñarã, cʉ̃́ãrẽ néewarare tutimiyira. ");
INSERT INTO tue_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesupé cʉ̃́ãrẽ atiduti, jĩĩyigʉ: —Wĩmarã yʉʉ pʉto atiaro. Cãmotárijãña. Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉserano ãniãgã tiiróbiro wãcũrã́ niiĩya. ");
INSERT INTO tue_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ãniãgã tiiróbiro Cõãmacʉ̃ dutirére ãñurõ wãcũnʉnʉse tiihéranorẽ cʉ̃ʉ̃ dutiré cʉ̃́ãpʉre jeaboariguere cʉ̃́ãrẽ jearicu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Judíoare Dutirá Peti menamacʉ̃ Jesuré sãĩñáyigʉ: —Basocáre buegʉ́ ãñugʉ̃́, ¿yʉʉ ñeenó tiigʉ́dari, catiré petihére bʉadʉgágʉ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús cʉ̃ʉ̃rẽ yʉʉyigʉ: —Mʉʉ yʉʉre “ãñugʉ̃́” jĩĩã. Cõãmacʉ̃ sĩcʉ̃rã ãñugʉ̃́ niiĩ. ");
INSERT INTO tue_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mʉʉ Cõãmacʉ̃ dutiré cṹũriguere masĩcu. “Ãpĩ nʉmorẽ ñeeaperijãña. Basocáre sĩãríjãña. Yaaríjãña. Ãpẽrãrẽ́ jĩĩditoremena wedesãrijãña. Mʉʉ pacʉ, mʉʉ pacore padeoyá”, jĩĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Yʉʉ wĩmagʉ̃pʉra tee niipetirere tiimʉ́ãatimiwʉ̃, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉrẽ sicawãme dʉsajã́ã ména. Mʉʉ cʉorére dúapetijãña. Tee dúa wapatáariguere bóaneõrãrẽ batoya. Teero tiigʉ́, Cõãmacʉ̃ pʉtopʉre pee ãñuré bʉagʉ́dacu. Túajea, ati, yʉʉre nʉnʉwá, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, tʉsarijõãyigʉ. Cʉ̃ʉ̃ pee peti apeyé cʉogʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cʉ̃ʉ̃ tʉsarijõãrĩ ĩñagʉ̃, Jesús jĩĩyigʉ: —Pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgari, wisió niicu. ");
INSERT INTO tue_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wáicʉ camello wãmecʉtigʉ awigá copegãpʉ sããcãmewitimasĩriqui. Toorá nemocú, pee apeyé cʉoráno Cõãmacʉ̃ dutirére ãñurõ tiinʉnʉ́sedʉgaripereja, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Cʉ̃ʉ̃ jĩĩrére tʉorá sãĩñáyira: —Too docare ¿noãpé netõnénoãdari? ");
INSERT INTO tue_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Basocá cʉ̃́ã basiro netõnémasĩriya. Cõãmacʉ̃pereja wisióre manidójãã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro jĩĩyigʉ: —Tʉoyá ména. Ʉ̃sãpe niipetire ʉ̃sã cʉoríguere cṹũjõãatiwʉ, mʉʉmena nʉnʉã́da jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Cʉ̃ʉ̃ cʉ̃́ãrẽ yʉʉyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ yʉʉre maĩgʉ̃́ cʉ̃ʉ̃ya wii, cʉ̃ʉ̃ nʉmo, cʉ̃ʉ̃ baira, cʉ̃ʉ̃ pacʉsʉ̃mʉã, cʉ̃ʉ̃ põnarẽ́ cṹũjõã, “Cõãmacʉ̃ dutiré basocápʉre niiãdare quetire wedegʉ wáagʉda” jĩĩgʉ̃́nope ");
INSERT INTO tue_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cʉ̃ʉ̃ cṹũwarigue nemorṍ bʉagʉ́daqui atibʉ́recopʉre. Too síropʉcãrẽ Cõãmacʉ̃mena catiré petihére bʉagʉ́daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús cʉ̃ʉ̃ buerá docere sʉowá, jĩĩyigʉ: —Mʉ́ã ĩñaã: Marĩ Jerusalénpʉ wáara tiia. Toopʉ́ profetas jóariguebirora wáaadacu. Niipetire cʉ̃́ã “biiro wáaadacu niipetira sõwʉ̃rẽ” jĩĩrirobirora yʉʉre wáaadacu. ");
INSERT INTO tue_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Toopʉ́ yʉʉ niipetira sõwʉ̃rẽ judíoa niihẽrã dutirápʉre ticoadacua. Yʉʉre buijã́, ñañarõ jĩĩ, ʉsecó eobatétu, ");
INSERT INTO tue_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tãna, sĩãã́dacua. Itiábʉreco siro masãgʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cʉ̃ʉ̃ buerá teeré tʉomasĩ́riyira. “Ñeenórẽ wedesegʉ tiii”, jĩĩmasĩriyira. Tʉomasĩ́ña maniréno niiyiro. ");
INSERT INTO tue_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó pʉtopʉ jeagʉdʉ tiirí, sĩcʉ̃ maa wesapʉ niyeru sãĩduíyigʉ. Cʉ̃ʉ̃ capeari baunóhẽgʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Paʉ basocá wáari tʉogʉ́: —¿Deero wáai? jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesús Nazaret macã macʉ̃ netõwágʉ tiii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Teero tiigʉ́, bayiró bʉsʉrómena jĩĩyigʉ: —¡Jesús, David pãrãmi niinʉnʉsegʉ, yʉʉre bóaneõña! jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Cʉ̃ʉ̃ pʉto netõwára: —Nocõrõrã ditamaníjõãña, jĩĩ tutimiyira. Cʉ̃ʉ̃pe jĩĩnemosãjãyigʉ: —¡David pãrãmi niinʉnʉsegʉ, yʉʉre bóaneõña! jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesupéja pʉtʉánʉcã, cʉ̃ʉ̃rẽ néeatidutiyigʉ. Cʉ̃ʉ̃ pʉto jeari, cʉ̃ʉ̃rẽ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mʉʉrẽ deero tiirí boogári? jĩĩyigʉ. —Õpʉ̃, yʉʉre ĩñarĩ tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Jáʉ. Ĩñaña sáa. Mʉʉ padeojĩ́gʉ̃, netõnénoãrigʉpʉ pʉtʉáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Cʉ̃ʉ̃ teero jĩĩrĩrã, ĩñajõãyigʉ sáa. Ĩña, Jesuré nʉnʉwágʉra, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Niipetira cʉ̃ʉ̃rẽ teero wáari ĩñarã, Cõãmacʉ̃rẽ ʉsenire ticoyira. ");
INSERT INTO tue_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericópʉ jea, netõwágʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Toopʉ́ sĩcʉ̃ pee apeyé cʉogʉ́ niiyigʉ. Romanuã õpʉ̃rẽ wapasébosari basoca dutigʉ́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Zaqueo. ");
INSERT INTO tue_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","“¿Deero biigʉ́ niiĩ Jesús?” jĩĩ, ĩñadʉgamiyigʉ. Cʉ̃ʉ̃ ʉ̃mʉhẽ́gʉ̃gã niijĩgʉ̃, deero ĩñamasĩriyigʉ. Paʉ basocá niiyira. ");
INSERT INTO tue_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","“Jesuré ĩñagʉ̃dʉ” jĩĩgʉ̃, cʉ̃ʉ̃ netõwáadaropʉ cʉtʉwáyigʉ. Cʉtʉwá, sicagʉ́ yucʉgʉpʉ mʉãwayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús too netõwágʉ, ĩñamʉõco, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Zaqueo, boyero diiátiya. Mecʉ̃ãrẽ mʉʉya wiipʉ pʉtʉácũmugʉ̃da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Boyeromena diiwá, Jesuré ʉseniremena bocagʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Niipetira teeré ĩñarã, wedepatiyira: —Jesús ñañaré tiirépigʉya wiipʉ pʉtʉácũmugʉ̃ wáaawĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Too síro Zaqueo wʉ̃mʉnʉcã, marĩ Õpʉ̃rẽ jĩĩyigʉ: —Ʉ̃sã Õpʉ̃, tʉoyá ména. Yʉʉ cʉorére decomena bóaneõrãrẽ ticogʉda. Yʉʉ jĩĩditoremena yaarírare baparicõrõ nemorṍ wiyagʉ́da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mecʉ̃ãmena mʉʉ, mʉʉya wii macãrã ñañaré tiirére netõnénoã. Mʉʉcã Abraham pãrãmi niinʉnʉsegʉ niiã. ");
INSERT INTO tue_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉʉ niipetira sõwʉ̃ pecamepʉ wáaborirare ãmaã, netõnégʉ̃ atiwʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Zaqueomena wedeseri, too niirã́ tʉoyíra. Cʉ̃ʉ̃ Jerusalénpʉ jeagʉdʉ tiiyígʉ mée. Teero tiirá, cʉ̃́ã “máata Cõãmacʉ̃ basiro dícʉ dutiréno marĩ pʉtopʉre niiãdaropʉ tiia mée” jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cʉ̃́ã wãcũrére masĩgʉ̃, queorémena wedeyigʉ: —Sĩcʉ̃ basocʉ́ ʉpʉtí macʉ̃ niiyigʉ. Cʉ̃ʉ̃ õpʉ̃ sõneconogʉ̃dʉ tiiyígʉ. “Pʉtʉaatigʉda” jĩĩ, õpʉ̃ niiré sããgʉ̃ wáajõãyigʉ yoaropʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cʉ̃ʉ̃ wáaadari sʉguero, pʉamóquẽñerã cʉ̃ʉ̃ye dutibosarare atidutiyigʉ. Cʉ̃́ã sĩquẽrãrẽ sĩquẽñequiri niyeruquiri ticoyigʉ. Teequiri pairó wapacʉtíre niiyiro. Cʉ̃́ãrẽ jĩĩyigʉ: “Atequírimena apeyé sãĩ, dúa, wapatánemoña, tée yʉʉ coerípʉ”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cʉ̃ʉ̃ya dita macãrã cʉ̃ʉ̃rẽ booríyira. Teero tiirá, cʉ̃ʉ̃ wáari siro, “ ‘cʉ̃ʉ̃ ʉ̃sã õpʉ̃ sããrĩ booríga’ jĩĩ wedera wáaya” jĩĩ ticocomiyira ãpẽrãrẽ́. ");
INSERT INTO tue_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Cʉ̃́ã teero jĩĩpacari, cʉ̃ʉ̃ cʉ̃́ã õpʉ̃ sõneconoyigʉ. Too síro coepʉtʉ́aatiyigʉ. Pʉtʉajea, cʉ̃ʉ̃ niyeruquiri ticorirare atidutiyigʉ. Cʉ̃́ãrẽ sãĩñáyigʉ: “¿Niyeru nocõrõ wapatánemorĩ?” ");
INSERT INTO tue_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jeasʉguegʉ jĩĩyigʉ: “Yʉʉ õpʉ̃, mʉʉ ticoriquimena pʉamóquẽñequiri wapatánemowʉ̃”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Cʉ̃ʉ̃ õpʉ̃ cʉ̃ʉ̃rẽ yʉʉyigʉ: “Ãñurõ tiiyú. Dutibosagʉ ãñurõ tiigʉ́ niiã mʉʉ. Yʉʉ péerogã cṹũremena mʉʉ ãñurõ tiiyú. Teero tiigʉ́, mʉʉrẽ pʉamóquẽñe macãrĩ dutigʉ́ sõnecogʉda”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Too síro ãpĩ jeayigʉ. “Yʉʉ õpʉ̃, mʉʉ ticoriquimena sicamoquẽñequiri wapatánemowʉ̃”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cʉ̃ʉ̃cãrẽ yʉʉyigʉ: “Mʉʉrẽ sicamoquẽñe macãrĩ dutigʉ́ sõnecogʉda”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Too síro ãpĩ jeayigʉ. “Ãjã, yʉʉ õpʉ̃, mʉʉyaqui; sutiró caseromena cõma, ĩñanojãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yʉʉ masĩã: Mʉʉ bóaneõ ĩñaré cʉoría. Mʉʉ tiirípacʉ, ãpẽrã́ paderémena wapatáa. Mʉʉ oteripacʉ, ãpẽrã́ oteriguere néeã. Teero tiigʉ́, mʉʉrẽ cuiwʉ”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Cʉ̃́ã õpʉ̃ cʉ̃ʉ̃rẽ jĩĩyigʉ: “Mʉʉ dutibosagʉ ñañagʉ̃́ niiã. Mʉʉ wedeseremena mʉʉ ñañaré tiirére besenotoaa. Mʉʉ yʉʉ bóaneõ ĩñaré cʉohérere masĩãyu. Yʉʉ tiirípacʉ, ãpẽrã́ paderémena wapatárere masĩãyu. Yʉʉ oteripacʉ, ãpẽrã́ oteriguere néerere masĩãyu. ");
INSERT INTO tue_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Teeré masĩpacʉ, ¿deero tiigʉ́ yée niyerure niyeru ĩñanori wiipʉ bʉcʉádutigʉ cṹũriri? Mʉʉ cṹũrĩ, yʉʉ coegʉ́, tiiwiipʉ́ bʉcʉáremena ñeenemoboajĩyu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Toopʉ́ niirã́rẽ jĩĩyigʉ: “Tiiquire ẽmajãña. Pʉamóquẽñequiri cʉogʉ́pere ticoya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Cʉ̃́ã jĩĩyira: “Ʉ̃sã õpʉ̃, cʉ̃ʉ̃ pʉamóquẽñequiri cʉotóai”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Cʉ̃́ã õpʉ̃ jĩĩyigʉ: “Yʉʉre tʉoyá: Pee cʉogʉ́norẽ nemorṍ ticonoãdacu. Cʉohégʉnopere cʉ̃ʉ̃ cʉomírere ẽmajãnoãdacu. ");
INSERT INTO tue_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mecʉ̃tígã yʉʉ õpʉ̃ sããrĩ boorírirare ãnopʉ́ néeatiya. Yʉʉ ĩñacoropʉ cʉ̃́ãrẽ sĩãñá”, jĩĩyigʉ, jĩĩ wedeyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús teeré jĩĩtoa, Jerusalénpʉ wáagʉ, cʉ̃́ãrẽ sʉgueyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Toopʉ́ wáagʉ, Betfagé, Betania macãrĩpʉ jeagʉdʉ tiiyígʉ. Teemacãrĩ Ʉ̃tãgʉ̃́ Olivo pʉto niiã. Toopʉ́ cʉ̃ʉ̃ buerá pʉarã́rẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Iimacã marĩ díamacʉ̃ niirí macãpʉ wáaya. Toopʉ́ jeara, sĩcʉ̃ burro wĩmagʉ̃ siatúnʉcõãrigʉre bʉajeáadacu. Cʉ̃ʉ̃ pesaya manigʉ̃́ niiqui ména. Cʉ̃ʉ̃rẽ jõã, néeatiya. ");
INSERT INTO tue_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mʉ́ãrẽ “¿deero tiirá cʉ̃ʉ̃rẽ jõãĩ?” jĩĩrĩ, “marĩ Õpʉ̃ booáwĩ” jĩĩña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cʉ̃ʉ̃ ticocoarira wáa, cʉ̃ʉ̃ jĩĩãrirobirora bʉajeáyira. ");
INSERT INTO tue_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cʉ̃́ã burrore jõãrã́ tiirí, cʉ̃ʉ̃ õpãrã́ cʉ̃́ãrẽ: —¿Deero tiirá cʉ̃ʉ̃rẽ jõãĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Marĩ Õpʉ̃ booáwĩ, jĩĩ yʉʉyira. ");
INSERT INTO tue_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesús pʉto néewa, burro sotoapʉ cʉ̃́ãye suti sotoá maquẽrẽ tuuwépeoyira. Jesuré cʉ̃ʉ̃ sotoapʉ mʉãpeadutiyira. ");
INSERT INTO tue_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús cʉ̃ʉ̃ sotoapʉ pesawari, basocá cʉ̃ʉ̃rẽ padeorá, cʉ̃́ãye suti sotoá maquẽrẽ maapʉ sẽ́õcũyira. ");
INSERT INTO tue_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesús Ʉ̃tãgʉ̃́ Olivo diiwáropʉ jeari, niipetira cʉ̃ʉ̃ buerére nʉnʉrã́ cʉ̃́ã ĩñariguere wãcũrã, ʉseninʉcãyira. Niipetire Jesús tutuaremena tiiẽ́ñoriguecãrẽ wãcũrã, bayiró bʉsʉrómena Cõãmacʉ̃rẽ ʉsenire ticoyira. ");
INSERT INTO tue_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Cõãmacʉ̃ ticodiocorigʉ marĩ Õpʉ̃rẽ ãñurõ tiiáro! ¡Ʉ̃mʉã́sepʉre ãñurõ niirecʉtiaro! ¡Niipetira Cõãmacʉ̃rẽ “ãñunetõjõãĩ” jĩĩ, ʉsenire ticoaro! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sĩquẽrã fariseo basoca toopʉ́ niirã́ Jesuré jĩĩyira: —Basocáre buegʉ́, mʉʉrẽ nʉnʉrã́rẽ ditamanídutiya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús yʉʉyigʉ: —Yʉʉre tʉoyá: Cʉ̃́ã ditamaníãtã, Cõãmacʉ̃ ate ʉ̃tãperire bayiró bʉsʉrómena wedeseri tiigʉ́daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén pʉtopʉ jea, tiimacãrẽ ĩñacogʉ, utiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tiimacã macãrãrẽ, too síro macãrãrẽ wãcũgʉ̃, jĩĩyigʉ: —Mecʉ̃ãrẽ mʉ́ã ãñurõ niirecʉtirere Cõãmacʉ̃ ticorére masĩrĩ, ãñuboajĩyu. Mʉ́ã masĩdʉgahere wapa masĩricu. ");
INSERT INTO tue_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mʉ́ãrẽ ñañarõ netõré bʉrecori atiadacu. Teebʉrecorire mʉ́ãrẽ ĩñatutira atimacãrẽ́ niipetireniñarĩpʉ cãmotáadacua, mʉ́ãrẽ witiwari jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Niipetire mʉ́ãyere cõããdacua. Mʉ́ãrẽ sĩãpetíjããdacua. Mʉ́ã weere wiserire ʉ̃tãqui apequí sotoápʉ weemʉãrigue pʉtʉáricu. Mʉ́ã Cõãmacʉ̃ netõnéri bʉreco jeari ĩñamasĩhẽre wapa teero wáaadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús Cõãmacʉ̃wiipʉ sããjeagʉ, dúari basocare cõãwionecoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cʉ̃́ãrẽ jĩĩyigʉ: —Cõãmacʉ̃ye queti jóaripũpʉ biiro jĩĩã: “Yáa wii ‘Cõãmacʉ̃mena wedeseri wii niiã’ jĩĩrí wii niiãdacu”, jĩĩ jóare niiã. Mʉ́ãpe yaarépira dúari wii niirĩ tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bʉ́recoricõrõ Jesús Cõãmacʉ̃wiipʉ bueyigʉ. Paiaré dutirá, Moisés jóarigue buerá, ãpẽrã́ ʉpʉtí macãrã “¿cʉ̃ʉ̃rẽ deero tii sĩãrṍ booi?” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Basocá niipetira Jesús wedeserere tʉonʉnʉ́sera tiiyíra. Teero tiirá, cʉ̃ʉ̃rẽ dee tii masĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sicabʉreco Jesús Cõãmacʉ̃wiipʉ basocáre buegʉ tiiyígʉ. Cʉ̃ʉ̃ye ãñuré quetire wedegʉ tiiyígʉ. Paiaré dutirá, Moisés jóarigue buerá Jesús pʉtopʉ jeayira bʉtoá dutirámena. ");
INSERT INTO tue_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Cʉ̃ʉ̃rẽ sãĩñáyira: —Ʉ̃sãrẽ wedeya: ¿Noã dutirémena mʉʉ teeré tiii? ¿Noã mʉʉrẽ dutiré ticori? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Yʉʉcã mʉ́ãrẽ sãĩñágʉ̃da. Mʉ́ã yʉʉre wedeya: ");
INSERT INTO tue_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Noã Juanrẽ́ wãmeõtidutigʉ ticocoyiri? ¿Cõãmacʉ̃ o basocápe ticocoyiri? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Cʉ̃́ãpe cãmerĩ́ wedeseyira: —Marĩ “Cõãmacʉ̃ ticocorigʉ niiwĩ” jĩĩrĩ, cʉ̃ʉ̃ marĩrẽ “too docare ¿deero tiirá cʉ̃ʉ̃rẽ padeoríri?” jĩĩboqui. ");
INSERT INTO tue_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Marĩ “basocá cʉ̃ʉ̃rẽ ticocorira niiwã” jĩĩãtã, niipetira marĩrẽ ʉ̃tãperimena déesĩããdacua. “Juan profeta niiwĩ” jĩĩ padeoóya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Teero tiirá, Jesuré: —Ticocorigʉre masĩriga, jĩĩjãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉcã mʉ́ãrẽ “ate dutirémena teeré tiia” jĩĩ wederia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús basocáre ate queorémena wedenʉcãyigʉ: —Sĩcʉ̃ ʉ̃mʉ niiyigʉ ʉse wese oterigʉ. Oteri siro, ãpẽrãrẽ́ tiiditare wasoyigʉ. Wasoari siro, aperopʉ́ wáayigʉ yoari niigʉ̃ wáagʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ʉse dʉcacʉtirito niirĩ, sĩcʉ̃ cʉ̃ʉ̃rẽ padecotegʉre ticocomiyigʉ. Cʉ̃ʉ̃ya dita cʉ̃ʉ̃ wasorirare “ʉse cʉ̃́ã dúa wapatárere decomena ticocoaro yʉʉre” jĩĩcomiyigʉ. Cʉ̃ʉ̃ toopʉ́ jeari, tiidita wasorira cʉ̃ʉ̃rẽ páa, péerogã ticoripacara, pʉtʉócojãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ãpĩ cʉ̃ʉ̃rẽ padecotegʉre ticocomiyigʉ sũcã. Cʉ̃ʉ̃cãrẽ páa, ñañarõ buijã́, péerogã ticoripacara, pʉtʉócojãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Too síro ãpĩrẽ́ ticoconemoyigʉ sũcã. Cʉ̃ʉ̃cãrẽ cãmitu, cõãjãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tiidita õpʉ̃ “¿deero tiigʉ́dari yʉʉ?” jĩĩ wãcũnʉcãyigʉ. “Yʉʉ macʉ̃ yʉʉ bayiró maĩgʉ̃́rẽ ticocogʉda. Apetó tiirá, cʉ̃ʉ̃rẽ quioníremena ĩñabocua”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Õpʉ̃ macʉ̃ toopʉ́ jeari ĩñarã, tiidita wasorira cãmerĩ́ wedeseyira: “Ãnirã́ niiĩ too síropʉ atiditaré ñeegʉ̃dʉ. Cʉ̃ʉ̃rẽ sĩãcó. Cʉ̃ʉ̃ manirĩ́, atiditá marĩya dita pʉtʉáadacu”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Teero tiirá, cʉ̃ʉ̃rẽ ñee, tiiwese wesapʉ néewa, sĩãcõã́jãyira, jĩĩ wedeyigʉ. Jesús basocáre sãĩñáyigʉ: —Tiidita õpʉ̃ cʉ̃́ãrẽ tiiádarere mʉ́ãrẽ wedegʉda. ");
INSERT INTO tue_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cʉ̃ʉ̃ ati, cʉ̃ʉ̃ya dita wasorirare sĩãcõã́peti, ãpẽrãrẽ́ tiiditare ticojãgʉ̃daqui, jĩĩyigʉ. Teeré tʉorá: —¡Teero wáarijããrõ! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús cʉ̃́ãrẽ ĩña, jĩĩyigʉ: —Wáaadacu. Cõãmacʉ̃ye queti jóaripũ jĩĩrére tʉoyá: Wii weerira ʉ̃tãquire booríyira. Cʉ̃́ã boorípacari, tiiquira ʉpʉtí macãqui pʉtʉáwʉ tiiwiipʉ́re. ");
INSERT INTO tue_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tiiqui sotoapʉ ñaapeagʉ mʉtãjõãgʉ̃daqui. Tiiqui cʉ̃ʉ̃ sotoapʉ ñaapeaatã, ãñurõ mʉtãpetijõãgʉ̃daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Moisés jóarigue buerá, paiaré dutirá, “tee queorémena marĩrẽ jĩĩtutigʉ tiiquí” jĩĩ masĩjãyira. Toorá “¿cʉ̃ʉ̃rẽ deero tii ñeerõ booi?” jĩĩmiyira. Basocáre cuira, ñeemasĩriyira. ");
INSERT INTO tue_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Teero tiirá, cʉ̃ʉ̃rẽ ãñurõ ĩñanʉnʉse, ãpẽrãrẽ́ ĩñadutira ticocoyira. Cʉ̃́ãrẽ basocá ãñurã́ tiiróbiro niidutiyira. Cʉ̃́ã Jesús merẽã yʉʉri boomíyira. Teeména tiidita dutigʉ́pʉre wedesã ticodʉgamiyira. ");
INSERT INTO tue_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Teero tiirá, cʉ̃́ã ticocoarira Jesús pʉto wáa, sãĩñáyira: —Basocáre buegʉ́, ʉ̃sã masĩã: Mʉʉ diamacʉ̃́rã wedea; diamacʉ̃́rã buea. Basocá niipetirare sĩcãrĩbíro ĩñaã. Cõãmacʉ̃ dutirére diamacʉ̃́ buea. ");
INSERT INTO tue_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Teero tiigʉ́, ʉ̃sãrẽ wedeya: ¿Romanuã õpʉ̃rẽ cʉ̃ʉ̃ niyeru wapasédutirere wapatíadari; o wapatírigarite? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesupé cʉ̃́ã ñañarõ tiidʉgárere masĩjãyigʉ. Teero tiigʉ́, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Niyeruquire ẽñoñá yʉʉre. ¿Noãyá diapóa, noã wãme tusai? jĩĩyigʉ. —César romanuã õpʉ̃ye tusaa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Too docare Césaye niirére Césare wiyayá; Cõãmacʉ̃yere Cõãmacʉ̃rẽ wiyayá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesuré basocá tʉocóropʉ merẽã yʉʉrére bʉaríyira. Cʉ̃́ã cʉ̃ʉ̃ yʉʉrére tʉomaníjõãrã, ditamaníjõãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sĩquẽrã saduceo basoca Jesús pʉto jeayira. Cʉ̃́ã “diarira masãmʉãricua” jĩĩcua. Jesuré sãĩñáyira: ");
INSERT INTO tue_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Basocáre buegʉ́, Moisés dutirére jĩĩãda: “Sĩcʉ̃ põnamanígʉ̃ diaweori, cʉ̃ʉ̃ bai cʉ̃ʉ̃ nʉmo niirigore dúutuaro. Cʉ̃ʉ̃ coomena cʉ̃ʉ̃ sõwʉ̃ diarigʉre põnacʉtíbosaaro”, jĩĩ jóarigʉ niiwĩ Moisés. ");
INSERT INTO tue_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sĩcʉ̃põna siete niiyira. Cʉ̃́ã sõwʉ̃ nʉmocʉtiyigʉ. Põnamanígʉ̃rã diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Cʉ̃ʉ̃ siro macʉ̃ cʉ̃ʉ̃ sõwʉ̃ nʉmorẽ dúutumiyigʉ. Cʉ̃ʉ̃cã põnamanígʉ̃rã diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Cʉ̃́ã siro macʉ̃cã coore dúutu, põnamanígʉ̃rã diajõãyigʉ. Niipetira cʉ̃́ã siro macãrãcã teerora wáayira. Cʉ̃́ã siete põnamanípacara, diapetijõãyira. ");
INSERT INTO tue_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Too síro cʉ̃́ã nʉmo niimirigocã diajõãyigo. ");
INSERT INTO tue_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cʉ̃́ã siete coore nʉmocʉtimiyira. Teero tiigó, diarira masãmʉãrĩ, ¿nii nʉmope pʉtʉágodari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesupé cʉ̃́ãrẽ yʉʉyigʉ: —Atibʉ́recopʉre ʉ̃mʉã́, numiã́ nʉmocʉti, manʉcʉtiya. ");
INSERT INTO tue_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cõãmacʉ̃ beserira dia masãmʉãri siro, ʉ̃mʉã́, numiã́ wãmosíaricua. ");
INSERT INTO tue_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ángelea tiiróbiro niiĩya. Dianemoricua sáa. Cõãmacʉ̃ masõrira niijĩrã, Cõãmacʉ̃ põna niiĩya. ");
INSERT INTO tue_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Diarira masãmʉãrere Moisécã cʉ̃ʉ̃ jóariguemena ẽñorígʉ niiwĩ. Yucʉʉ jʉ̃ʉ̃rísati quetipʉ Cõãmacʉ̃ “Abraham, Isaac, Jacob Õpʉ̃ niiã yʉʉ” jĩĩriguere jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cõãmacʉ̃ diarira Õpʉ̃ niirii; catirá Õpʉ̃pe niiĩ. Cʉ̃ʉ̃ ĩñacoropʉ niipetira catiiya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sĩquẽrã Moisés jóarigue buerá Jesuré jĩĩyira: —Basocáre buegʉ́, mʉʉ diamacʉ̃́ peti wedesea. ");
INSERT INTO tue_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Too síro cʉ̃ʉ̃rẽ apeyé sãĩñánemodʉgariyira sáa, “marĩrẽ netõnʉcã́boqui sũcã” jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús basocáre sãĩñáyigʉ: —¿Deero tiirá “Cõãmacʉ̃ beserigʉ David pãrãmi niiĩ” jĩĩĩ? ");
INSERT INTO tue_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David basirora Salmopũpʉ jóarigʉ niiwĩ: Cõãmacʉ̃ jĩĩwĩ yʉʉ Õpʉ̃rẽ: “Yáa wãmo diamacʉ̃́niñape duiya, ");
INSERT INTO tue_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tée mʉʉrẽ ĩñatutirare mʉʉ dutiriguere yʉʉ ãñurõ yʉʉri tiirípʉ”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David “yʉʉ Õpʉ̃” jĩĩgʉ̃, Cõãmacʉ̃ beserigʉre jĩĩgʉ̃ tiirígʉ niiwĩ, cʉ̃ʉ̃ pãrãmí niipacari. Teeré ãñurõ wãcũña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Niipetira basocá tʉocóropʉ Jesús cʉ̃ʉ̃ bueráre wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moisés jóarigue buerá tiiróbirora tiirucúrijãña. Cʉ̃́ã suti yoaretõ sãña, wáaʉseniya. Macã decopʉ quioníremena ãñudutiri boocúa. Neãré wiseripʉ sʉguero maquẽ duirépʉ dícʉ duidʉgacua. Bosebʉreco tiirópʉcãrẽ teerora tiidʉgácua. ");
INSERT INTO tue_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Niyeru boorá, wapewia numiãye wiserire jĩĩditoremena ẽmacua. Cʉ̃́ã yoari Cõãmacʉ̃mena wedesera tiiróbiro tiiditóya basocáre. Cʉ̃́ãrã ãpẽrã́ nemorṍ ñañarõ tiinóãdara niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ĩñacogʉ, niyeru cʉorá niyeru sã́ãretibaripʉ pairó niyeru sã́ãrĩ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sĩcõ wapewio bóaneõgõ pʉaquí wapamanírequiri sã́ãrĩ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Teeré ĩñagʉ̃, jĩĩyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cõãmacʉ̃ ĩñacoropʉre igo wapewio bóaneõgõ niipetira nemorṍ ticoyo. ");
INSERT INTO tue_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ĩ́niãpeja cʉ̃́ãrẽ dʉsaríguere ticooya. Coopeja coo cʉomíãrigue, coo yaaré sãĩbóariguegãrẽ ticopetijãyo, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sĩquẽrã cʉ̃ʉ̃ buerá Cõãmacʉ̃wii maquẽrẽ wedeseyira: —Ʉ̃tãquiritõ ãñurémena tiirí wii ãñunetõjõãri wii niiã. Cʉ̃́ã mamorecã ãñunetõjõãre niiã, jĩĩyira. Jesús cʉ̃́ã jĩĩrére tʉogʉ́, jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mʉ́ã ãno ĩñaré too síro ʉ̃tãqui apequí sotoápʉ weemʉãrigue pʉtʉáricu. Niipetire cõãnoãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Too síro cʉ̃ʉ̃rẽ sãĩñáyira: —Ʉ̃sãrẽ buegʉ́, mʉʉ wedearigue ¿deero biiri wáaadari? ¿Ñeenómena ĩñamasĩnoãdari, ate wáaadari sʉguerogãrẽ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús cʉ̃́ãrẽ yʉʉyigʉ: —Ãñurõ tʉomasĩ́ña, ãpẽrã́ jĩĩditori jĩĩrã. Paʉ “yʉʉrá niiã; yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã” jĩĩãdacua. “Atibʉ́reco petiádaro péerogã dʉsaa”, jĩĩãdacua. Cʉ̃́ãrẽ padeó nʉnʉríjãña. ");
INSERT INTO tue_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Cãmerĩ́sĩãrã tiiáwã” jĩĩrĩ tʉoádacu. “Toopʉ́ basocá cʉ̃́ã õpãrãrẽ́ cõãrã tiiíya” jĩĩrécãrẽ tʉoádacu. Teeré tʉorá, cuirijãña. Tee wáasʉgueadare niirõ tiia. Teero wáapacari, atibʉ́reco petiádaro dʉsaádacu ména, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cʉ̃́ãrẽ jĩĩnemoyigʉ: —Sicapõna macãrã apepõná macãrãmena cãmerĩ́sĩããdacua. Teero biiri sicadita macãrã apeditá macãrãmena cãmerĩ́sĩããdacua. ");
INSERT INTO tue_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bayiró dita cãmeñare wáaadacu. Peeditapʉre jʉabóare, diaré wáaadacu. Ʉ̃mʉã́sepʉre quioré, merẽã bauré bauáadacu. ");
INSERT INTO tue_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Tee wáaadari sʉguero, ãpẽrã́ mʉ́ãrẽ ñee, ñañarõ tiiádacua. Mʉ́ãrẽ judíoa neãré wiseripʉ néewa, queti beseadacua. Peresuwiipʉ sõnecoadacua. Õpãrã́, dutirá pʉtopʉ néewa, queti beseadacua. Tee niipetirere tiiádacua mʉ́ã yʉʉre padeoré wapa. ");
INSERT INTO tue_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Cʉ̃́ã teero tiirí, yʉʉ mʉ́ãrẽ tiirére wedemasĩãdacu. ");
INSERT INTO tue_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Cʉ̃́ãrẽ yʉʉadarere wãcũsʉguerijãña. ");
INSERT INTO tue_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉʉ mʉ́ãrẽ masĩrĩ tiigʉ́da cʉ̃́ãrẽ yʉʉadarere. Teeména mʉ́ãrẽ ĩñatutira mʉ́ã wedeserere sĩcãrĩbíricua. “Tee diamacʉ̃́ niiria”, jĩĩmasĩricua. ");
INSERT INTO tue_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mʉ́ã pacʉsʉ̃mʉã, mʉ́ãya wedera, mʉ́ã menamacãrã mʉ́ãrẽ dutirápʉre wedesããdacua. Cʉ̃́ã teero tiirí, mʉ́ã sĩquẽrãrẽ sĩãjã́ãdacua. ");
INSERT INTO tue_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Niipetira basocá mʉ́ãrẽ ĩñatutiadacua yʉʉre padeoré wapa. ");
INSERT INTO tue_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Teero tiipacári, mʉ́ãrẽ merẽã wáaãmaricu. ");
INSERT INTO tue_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yʉʉre padeodúrijãña. Wãcũtutuarucujãña. Teero tiirá, catiré petihére bʉaádacu. ");
INSERT INTO tue_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Mʉ́ã surara Jerusalénrẽ niisodeari ĩñarã, “tiimacãrẽ cõããdaro péerogã dʉsaa” jĩĩmasĩãdacu. ");
INSERT INTO tue_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Teero wáari ĩñarã, Judea ditapʉ niirã́ ʉ̃tãyucʉpʉ dutijṍããrõ. Jerusalénpʉ niirã́ aperopʉ́ wáaaro. Cã́pũpʉ niirã́ tiimacãpʉ pʉtʉawarijããrõ. ");
INSERT INTO tue_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Teebʉrecori Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaadacu: Cõãmacʉ̃ Jerusalén macãrãrẽ ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Teero wáare bʉrecori niipacósãnumiãrẽ, põna ũpũrã́ cʉoráre bóaneõre bʉrecori niiãdacu. Atiditapʉ́re bayiró ñañarõ netõré niiãdacu. Cõãmacʉ̃ basocáre bayiró peti ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ãpẽrã́ cãmerĩ́sĩãrõpʉ sĩãnóãdacua. Ãpẽrã́ ñee, niipetire ditapʉ néewanoãdacua. Apeditá macãrã judíoa niihẽrã Jerusalénrẽ cõãdioco, cʉtamʉtṍãdacua. Cõãmacʉ̃ cʉ̃́ãrẽ dutiriro jeatuaro teero tiiádacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús wedenemoyigʉ: —Teero wáaadari sʉguero, muĩpũ bʉ́reco macʉ̃, ñami macʉ̃, ñocõã́ pee merẽã bauré wasoádacu. Atibʉ́reco niipetiropʉ macãrã día pairímaa, ocoturíre bayiró bʉsʉri tʉorá, ʉcʉára, dee tii masĩriadacua. ");
INSERT INTO tue_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Basocá atibʉ́recopʉre wáaadarere wãcũrã, bayiró cuira, tʉomasĩ́re petijṍããdacua. Niipetira ʉ̃mʉã́sepʉ niirã́ cãmeñanoãdacua. ");
INSERT INTO tue_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Teero wáari, yʉʉ niipetira sõwʉ̃ õmebʉrʉápʉ tutuaremena asibatédiatiri ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tee niipetire wáanʉcãrĩ, wãcũtutua, ʉseniña. Ʉ̃mʉã́sepʉ ĩñamʉõcoya. Mʉ́ãrẽ netõnéãdaro péerogã dʉsaádacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ate queorémena wedeyigʉ: —Higueragʉ, teero biiri niipetire yucʉ biirecʉtirere wãcũña. ");
INSERT INTO tue_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pṹũrĩ wasorí, “cʉ̃ma wáaadaro péerogã dʉsaa” jĩĩmasĩnoã. ");
INSERT INTO tue_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tee tiiróbirora yʉʉ jĩĩãrigue wáari ĩñarã, “Cõãmacʉ̃ dutiré basocápʉre niiãdare jeaadaro péerogã dʉsacú” jĩĩ masĩña. ");
INSERT INTO tue_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Atitó macãrã cʉ̃́ã diaadari sʉguero, yʉʉ jĩĩãrigue niipetire wáaadacu. ");
INSERT INTO tue_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉ̃mʉã́se, atiditá peticódiaadacu. Yʉʉ wedesere doca petirícu. Niirucujããdacu. ");
INSERT INTO tue_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Yʉʉ pʉtʉaatiadari bʉrecore mʉ́ã masĩricu. Teero tiirá, mʉ́ã ãñurõ niiyueya. Mʉ́ã ñañaré tiirére tiirípori jĩĩrã, tiiríjãña. Cũmurijãña. Atibʉ́reco maquẽrẽ wãcũpatirijãña. Mʉ́ã wãcũña manirṍ yʉʉ pʉtʉaatiadari bʉreco jeaadacu. ");
INSERT INTO tue_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tiibʉrecore niipetiropʉ macãrã tãmuãdacua. Teero tiirá, tʉomasĩ́ña. ");
INSERT INTO tue_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mʉ́ã ãñurõ ĩñacoya. “Tee ʉ̃sã ñañarõ netõã́darere netõnéña” jĩĩrã, Cõãmacʉ̃rẽ sãĩrucújãña. Yʉʉ niipetira sõwʉ̃rẽ cuiro manirṍ bocaada jĩĩrã, sãĩrucújãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús bʉ́recoricõrõ Cõãmacʉ̃wiipʉ bueyigʉ. Ñamirĩrẽ́ Ʉ̃tãgʉ̃́ Olivopʉ wáa, niirucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bóerigã basocá niipetira Cõãmacʉ̃wiipʉ cʉ̃ʉ̃rẽ tʉorá wáarucuyira. ");
INSERT INTO tue_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pã púuri tiiré wʉ́oya maniré yaarí bosebʉreco wáaadaro péero dʉsayíro. Tii bosebʉreco wãmecʉtia Pascua. ");
INSERT INTO tue_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Paiaré dutirá, Moisés jóarigue buerá “¿deero tii Jesuré sĩãrṍ boomíĩto?” jĩĩyira. Cʉ̃ʉ̃rẽ sĩãdʉgápacara, basocáre cui niiyira. ");
INSERT INTO tue_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas cʉ̃́ã “Iscariote” jĩĩgʉ̃́rẽ Satanás sããyigʉ. Jesús buerá doce menamacʉ̃ niimiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cʉ̃ʉ̃ paiaré dutirá, Cõãmacʉ̃wii coterí basocare dutirá pʉtopʉ wáayigʉ. Toopʉ́ jea, Jesuré ticoadarere cʉ̃́ãmena wedeseyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Cʉ̃ʉ̃ jĩĩrére tʉorá, bayiró ʉseniyira. —Mʉʉrẽ niyeru wapatíada, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Jáʉ, teerora tiiwá, jĩĩyigʉ. Teero tiigʉ́, basocá ĩñahẽrõ cʉ̃́ãpʉre Jesuré ticogʉdʉ coteyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Too síro pã púuri tiirémena wʉ́oya maniré yaarí bʉreco jeayiro. Tiibʉreco niirĩ, sĩcʉ̃ corderore cʉ̃́ã Pascua boseyagʉdʉre sĩãnóã. ");
INSERT INTO tue_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Teebʉrecorire Jesús Pedrore, Juanrẽ́ biiro jĩĩcoyigʉ: —Marĩ Pascua boseyaadarere quẽnoyúera wáaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Noopʉ́ ʉ̃sã quẽnorĩ́ boogári? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã macãpʉ wáaya. Toopʉ́ jeara, sĩcʉ̃ basocʉ́ ocogá turupeogʉre bʉajeáadacu. Cʉ̃ʉ̃rẽ nʉnʉwáwa. Cʉ̃ʉ̃ sããwari wiipʉ sããwawa. ");
INSERT INTO tue_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tiiwií õpʉ̃rẽ jĩĩwa: “ ‘¿Noopʉ́ niigari yʉʉ buerámena Pascua boseyaadari tatia?’ jĩĩãwĩ ʉ̃sãrẽ buegʉ́”, jĩĩwa. ");
INSERT INTO tue_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Cʉ̃ʉ̃ ʉ̃mʉã́rõ macã tatia quẽnoã́ri tatiacapʉ ẽñogʉ̃́daqui. Toopʉ́ quẽnoyúewa, jĩĩcoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Cʉ̃́ã wáa, toopʉ́ Jesús cʉ̃́ãrẽ jĩĩãrirobirora niipetirere bʉayíra. Toopʉ́ cʉ̃́ã Pascua boseyaadarere quẽnoyíra. ");
INSERT INTO tue_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yaarítono jeari, Jesús cʉ̃ʉ̃ beseriramena yaaadara jeanuãyira. ");
INSERT INTO tue_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉ mʉ́ãmena ate Pascua boseyarere bayiró yaadʉgaa, yʉʉ diaadari sʉguero. ");
INSERT INTO tue_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yʉʉre tʉoyá: Mecʉ̃ãmena Pascua yaarére yaanemoricu sáa, tée yʉʉ Õpʉ̃ sããri siropʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Teero jĩĩãri siro, vino bapare née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Cʉ̃ʉ̃ bueráre jĩĩyigʉ: —Ateré cãmerĩ́ bato, sĩniñá. ");
INSERT INTO tue_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yʉʉre tʉoyá: Mecʉ̃ãmena yʉʉ vino sĩninemóricu sáa, tée yʉʉ Õpʉ̃ sããri siropʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pãrẽ née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, pʉatásã, batogʉra, jĩĩyigʉ: —Ate pã yʉʉ mʉ́ãrẽ diabosaadari õpʉ̃ʉ̃biro niiã. Ateré tiiyá, yʉʉ mʉ́ãrẽ diabosarere wãcũrã. ");
INSERT INTO tue_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yaaari siro, teerora tiiyígʉ sĩnirí bapamena. Cʉ̃ʉ̃ bueráre tĩ́ãgʉ̃, jĩĩyigʉ: —Atibapá maquẽ yée díibiro niiã. Yʉʉ diari, yée díi õmayudiaadacu, mʉ́ã ñañaré tiirére cosebosáaro jĩĩgʉ̃. Teeména Cõãmacʉ̃ mama netõnére quetire cṹũgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tʉoyá: Ãno yʉʉmena yaaduii yʉʉre ĩñatutirapʉre ticogʉdʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yʉʉ niipetira sõwʉ̃rẽ Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaadacu. Bóaneõgʉ̃ niigʉ̃daqui yʉʉre ticogʉdʉpeja, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Cʉ̃ʉ̃ buerá cʉ̃́ã basiro cãmerĩ́ sãĩñáyira: —¿Noã niigariye teero tiigʉ́dʉ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Too síro Jesús buerá cʉ̃́ã basiro bayiró cãmerĩ́ wedeseyira. —¿Nii marĩ watoare ʉpʉtí macʉ̃ niiĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Teero tiigʉ́, Jesús cʉ̃́ãrẽ jĩĩyigʉ: —Atibʉ́reco macãrã õpãrã́ cʉ̃́ã booró dutiãmajãya. Cʉ̃́ãye dita macãrãrẽ “ʉ̃sãrẽ ãñurõ tiiápura niiĩya” jĩĩrĩ boocúa. ");
INSERT INTO tue_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉ́ãpeja cʉ̃́ã tiiróbiro tiiríjãña. Biirope tiiyá. Mʉ́ã menamacʉ̃ ʉpʉtí macʉ̃ niigʉ̃́ niitugʉ tiiróbiro niirecʉtiaro. Mʉ́ãrẽ dutigʉ́ padecotegʉ tiiróbiro niirecʉtiaro. ");
INSERT INTO tue_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mʉ́ã tʉgueñarĩ, ¿niipé ʉpʉtí macʉ̃ niiĩ? ¿Yaaduigʉpe o cʉ̃ʉ̃rẽ yaaré péocotegʉpe? Yaaduigʉpe ʉpʉtí macʉ̃ niiĩ. Yʉʉ doca mʉ́ãmena niigʉ̃, yaaré péocotegʉ tiiróbiro niiã. ");
INSERT INTO tue_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Mʉ́ã niiã yʉʉmena niirucujãrã. Yʉʉre merẽã wáari, mʉ́ãcã ñañarõ netõápua. ");
INSERT INTO tue_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Teero tiigʉ́, yʉʉcã yʉʉ Pacʉ yʉʉre Õpʉ̃ sõnecorirobirora mʉ́ãrẽ õpãrã́ sõnecogʉda. ");
INSERT INTO tue_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Biiro tiirí, mʉ́ã yʉʉ Õpʉ̃ niirṍpʉ boseya, duiadacu. Mʉ́ã õpãrã́ duirépĩrĩpʉ duiadacu, Israelya põna macãrã doce põnarĩrẽ dutiadara, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús jĩĩnemoyigʉ: —Simón, tʉoyá. Satanás mʉ́ã padeorére duurí tiijĩ́gʉ̃, ñañodʉgáqui. Teero tiigʉ́, mʉ́ãrẽ sãĩã́rigʉ niiãwĩ. ");
INSERT INTO tue_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Cʉ̃ʉ̃ mʉʉrẽ ñañodʉgári ĩñagʉ̃, yʉʉpe padeodúrijããrõ jĩĩgʉ̃, Cõãmacʉ̃rẽ sãĩbosáawʉ̃. Teeré mʉʉ netõã́ri siro, padeó, mʉʉya wedera yʉʉre padeoráre wãcũtutuari tiiyá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro yʉʉyigʉ: —Õpʉ̃, mʉʉrẽ peresuwiipʉ néewara, yʉʉcãrẽ néewaaro. Mʉʉrẽ sĩãrã́, yʉʉcãrẽ sĩãã́rõ, jĩĩjãmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Pedro, yʉʉ jĩĩrére tʉoyá: Mecʉ̃ã macã ñami cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ “cʉ̃ʉ̃rẽ masĩriga” jĩĩditogʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Apeyé cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ãrẽ yʉʉ wasopori manirã́, niyeru sã́ãrepori manirã́, sapatu apebá manirã́ ticocoritore, ¿apeyenó dʉsarí? jĩĩyigʉ. —Dʉsaríwʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cʉ̃́ãrẽ jĩĩyigʉ: —Mecʉ̃ãmena wasopo cʉogʉ́ néewaaro; niyeru sã́ãripo cʉogʉ́cã néewaaro. Espada cʉohégʉ cʉ̃ʉ̃yaro sutiró sotoá macãrõrẽ dúa, espadare sãĩã́rõ. ");
INSERT INTO tue_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yʉʉre tʉoyá: Cõãmacʉ̃ye queti jóaripũpʉ yée maquẽrẽ jóarigue diamacʉ̃́ wáaadare niirõ tiia. Ate jóanoã: “ ‘Cʉ̃ʉ̃cã dutirére netõnʉcã́gʉ̃ niiĩ’ jĩĩ wãcũmiwã basocá cʉ̃ʉ̃rẽ”, jĩĩ jóanoã. Niipetire yée maquẽrẽ jóarigue diamacʉ̃́ wáaadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Jã́ã, ʉ̃sã Õpʉ̃, ate espada pʉapĩ́ niiã, jĩĩyira. —Ãñuãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús witiwa, cʉ̃ʉ̃ tiirucúrirobiro Ʉ̃tãgʉ̃́ Olivopʉ wáayigʉ. Cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ nʉnʉyíra. ");
INSERT INTO tue_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Toopʉ́ jeagʉ, cʉ̃́ãrẽ jĩĩyigʉ: —Wãtĩ mʉ́ãrẽ jĩĩcõãsãrijããrõ jĩĩrã, Cõãmacʉ̃rẽ sãĩñá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Teero jĩĩtoa, cʉ̃́ã sʉguero ʉ̃tãpe déecogʉ jearócõrõ yoaro wáayigʉ. Toopʉ́ ñicãcoberimena jeacũmu, Cõãmacʉ̃rẽ sãĩyígʉ. Sãĩgʉ̃́ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Pacʉ, mʉʉ boogʉ́, yʉʉ ñañarõ netõã́darere netõnéña. Yʉʉ teero jĩĩpacari, yʉʉ boorére tiiríjãña; mʉʉ boorépe wáaaro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sĩcʉ̃ ángele ʉ̃mʉã́se macʉ̃ cʉ̃ʉ̃rẽ bauáyigʉ. Bauá, cʉ̃ʉ̃rẽ tutuari tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cʉ̃ʉ̃ ñañarõ netõã́dare wãcũpatigʉ niijĩgʉ̃, nemorṍ Cõãmacʉ̃rẽ sãĩyígʉ. Cʉ̃ʉ̃ ʉsotíre paca díi tiiróbiro oco tabidiayiro. ");
INSERT INTO tue_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cʉ̃ʉ̃ Cõãmacʉ̃rẽ sãĩã́ri siro, wʉ̃mʉnʉcã, cʉ̃ʉ̃ buerá pʉtopʉ cãmepʉtʉ́ayigʉ. Cʉ̃́ãrẽ cãniã́rirapʉre bʉajeáyigʉ. Cʉ̃́ã bayiró wãcũrecʉtiarira niijĩrã, cãnijṍãyira. ");
INSERT INTO tue_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Cʉ̃́ãrẽ jĩĩyigʉ: —¿Deero tiirá nocõrõ cãniĩ? Wʉ̃mʉnʉcãña. Cõãmacʉ̃rẽ sãĩñá, wãtĩ mʉ́ãrẽ jĩĩcõãsãrijããrõ jĩĩrã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús cʉ̃́ãmena wedesegʉ tiiríra, paʉ basocá atiyira. Jesús buerá doce menamacʉ̃ niimiãrigʉ Judas wãmecʉtigʉ cʉ̃́ãrẽ sʉosʉguéyigʉ. Jea, Jesús pʉto atiyigʉ, cʉ̃ʉ̃ wasopúrore ũpũgʉ̃dʉ tiirí. ");
INSERT INTO tue_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —¿Judas, ũpũrémena yʉʉ niipetira sõwʉ̃rẽ yʉʉre ĩñatutirapʉre ticoi? ");
INSERT INTO tue_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ ñeeãdarere ĩñarã, sãĩñáyira: —Ʉ̃sã Õpʉ̃, ¿espadapĩrĩmena cʉ̃́ãrẽ cãmotágari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sĩcʉ̃ Jesús buegʉ́ paiaré dutigʉ́re padecotegʉre páatacojãyigʉ. Diamacʉ̃́ macã cãmopérore páatayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús cʉ̃ʉ̃ bueráre: —Nocõrõrã tiiyá, jĩĩyigʉ. Cãmopérore ñaapeó, netõnéyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cʉ̃ʉ̃rẽ ñeerã jeará niiyira: Paiaré dutirá, Cõãmacʉ̃wii coterí basocare dutirá, bʉtoá dutirácã niiyira. Jesús cʉ̃́ãrẽ jĩĩyigʉ: —¿Yaarépigʉre tiiróbiro yʉʉre espadapĩrĩmena, yucʉména ñeerã atiarĩ? ");
INSERT INTO tue_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bʉ́recoricõrõ yʉʉ Cõãmacʉ̃wiipʉ mʉ́ãmena niirĩ, ñeeriwʉ. Mecʉ̃tígã mʉ́ã booró tiirítono jeaa. Satanás naĩtĩãrõpʉ niigʉ̃́ dutirépere tiia mʉ́ã, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesuré ñeeãri siro, néewayira. Paiaré dutigʉ́ya wiipʉ néesãwayira. Pedrope yoasãñurõ cʉ̃ʉ̃rẽ nʉnʉyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Basocá paiaré dutigʉ́ya wii popea macã yepa decopʉ pecame dioyíra. Dioári siro, duiyira. Pedro cʉ̃́ãmena duiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sĩcõ tiiwií padecotego Pedro toopʉ́ duiri ĩñayigo. Cʉ̃ʉ̃rẽ ĩñagõrã ĩña: —Ãnicã́ ĩ́nimena wáarucuarigʉra niiĩrã, jĩĩyigo. Cʉ̃ʉ̃pe coore: ");
INSERT INTO tue_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","—Cʉ̃ʉ̃rẽ masĩriga, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Too sírogã ãpĩ cʉ̃ʉ̃rẽ ĩña: —Mʉʉcã ĩ́ni menamacʉ̃ niiã, jĩĩyigʉ. Pedrope cʉ̃ʉ̃rẽ: —Niiria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sica hora siro ãpĩ jĩĩnemojãyigʉ: —Niirṍrã ãnicã́ ĩ́nimena niijĩyi. Cʉ̃ʉ̃cã Galilea macʉ̃rã niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedrope yʉʉyigʉ: —Ñeenórẽ wedesegʉ wedesecu, jĩĩyigʉ cʉ̃ʉ̃rẽ. Cʉ̃ʉ̃ wedesegʉ tiiríra, cãrẽquẽ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesús Pedrore cãmeñácoyigʉ. Toorá Pedro marĩ Õpʉ̃ cʉ̃ʉ̃rẽ jĩĩãriguere wãcũbʉayigʉ: “Mecʉ̃ã macã ñami cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ ‘cʉ̃ʉ̃rẽ masĩriga’ jĩĩgʉ̃dacu mʉʉ”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Teeré wãcũbʉagʉ, witiwa, bayiró utiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesuré coterá cʉ̃ʉ̃rẽ buijã́, páayira. ");
INSERT INTO tue_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cʉ̃ʉ̃ capearire biaápeyira. Teero tii, cʉ̃ʉ̃rẽ sãĩñáyira: —Jĩĩbʉaya. ¿Noã mʉʉrẽ páaarĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pee apeyé jĩĩnemo, cʉ̃ʉ̃rẽ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bóeri bʉtoá dutirá, paiaré dutirá, Moisés jóarigue buerá neãyira. Teero tiirí, Jesuré Judíoare Dutirá Peti neãrí wiipʉ néewayira. Toopʉ́ jeari, cʉ̃ʉ̃rẽ sãĩñáyira: ");
INSERT INTO tue_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Wedeya ʉ̃sãrẽ: ¿Mʉʉ Cõãmacʉ̃ beserigʉ Cristo niiĩ? jĩĩyira. Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉ mʉ́ãrẽ “cʉ̃ʉ̃rã́ niiã” jĩĩrĩ, padeorícu. ");
INSERT INTO tue_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yʉʉ mʉ́ãrẽ sãĩñárĩ, yʉʉricu. ");
INSERT INTO tue_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ateré mʉ́ãrẽ wedegʉda: Mecʉ̃ãmena yʉʉ niipetira sõwʉ̃ Cõãmacʉ̃ tutuare cʉonetṍgʉ̃ pʉto cʉ̃ʉ̃ diamacʉ̃́pe duigʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Cʉ̃́ã niipetira sãĩñáyira: —¿Too docare mʉʉ Cõãmacʉ̃ macʉ̃ niiĩ? jĩĩyira. —Mʉ́ã jĩĩrõbirora cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Cʉ̃́ã jĩĩyira: —Ãpẽrã́ cʉ̃ʉ̃rẽ wedesãrã ãmaãnemorõ booríga. Marĩ basirora cʉ̃ʉ̃ “yʉʉrá niiã” cʉ̃ʉ̃ jĩĩrére tʉotóaa, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cʉ̃́ã niipetira wʉ̃mʉnʉcã, Jesuré Pilatopʉre néewayira. ");
INSERT INTO tue_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Toopʉ́ jea, cʉ̃ʉ̃rẽ wedesãnʉcãyira: —Ãnirẽ́ bʉaáwʉ̃, ʉ̃sã judíoare ñañogʉ̃́rẽ. Cʉ̃ʉ̃ romanuã õpʉ̃rẽ wapatírere “ticorijãña” jĩĩĩ. “Yʉʉ Cõãmacʉ̃ beserigʉ Cristo niiã; yʉʉ mʉ́ã õpʉ̃ niiã”, jĩĩrucui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato cʉ̃ʉ̃rẽ sãĩñáyigʉ: —¿Mʉʉrã́ niiĩ judíoa õpʉ̃? jĩĩyigʉ. —Mʉʉ jĩĩrõbirora cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato paiaré dutiráre, basocá niipetirare jĩĩyigʉ: —Ãnirẽ́ ñañaré tiiárigue bʉaríga, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Cʉ̃́ãpe tutuaromena jĩĩnemoyira: —Cʉ̃ʉ̃ niipetira Judea macãrãrẽ cʉ̃ʉ̃ buerémena atiditá dutirére netõnʉcã́rĩ tiigʉ́ tiii. Galileapʉ teero tiinʉcã́yigʉ. Mecʉ̃tígãrẽ atimacãpʉ́re teerora tiigʉ́ jeai, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Teeré tʉogʉ́, sãĩñáyigʉ: —¿Cʉ̃ʉ̃ Galilea macʉ̃ niiĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Cʉ̃ʉ̃rã́ niiĩ, jĩĩyira. “Herodes dutiré dita macʉ̃ niiĩ” jĩĩrére tʉogʉ́, cʉ̃ʉ̃ pʉtopʉ ticocoyigʉ. Teebʉrecorire cʉ̃ʉ̃ Jerusalénpʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes Jesuré ĩñagʉ̃, bayiró ʉseniyigʉ, yoari ĩñadʉgarigʉ niijĩgʉ̃. Cʉ̃ʉ̃ye maquẽrẽ wedeseri tʉoyígʉ. Cʉ̃ʉ̃ tutuaremena tiiẽ́ñorĩ ĩñadʉgamiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Teero tiigʉ́, cʉ̃ʉ̃rẽ pee sãĩñámiyigʉ. Cʉ̃ʉ̃pe yʉʉriyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paiaré dutirá, Moisés jóarigue buerá too ĩñanucũyira. Cʉ̃́ã bayiró Jesuré wedesãrã peti tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes cʉ̃ʉ̃yara suraramena Jesuré ñañarõ tiiápeyira. Cʉ̃ʉ̃rẽ buijã́rã, sotoá macãrõ ãñurṍrẽ sã́ãyira. Tooména Pilato pʉtopʉ ticocoyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tiibʉrecora Herodes Pilatomena cãmerĩ́ quẽnoyíra. Too sʉgueropʉre cãmerĩ́ ĩñadʉgariyira. ");
INSERT INTO tue_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Too síro Pilato paiaré dutiráre, Judíoare Dutirá Petire, tiimacã macãrã basocáre néõyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã ãnirẽ́ yʉʉ pʉtopʉ néeatiawʉ̃. “Basocáre ñañogʉ̃́ tiii”, jĩĩãwʉ̃. Yʉʉ mʉ́ã ĩñacoropʉ cʉ̃ʉ̃rẽ sãĩñámiãwʉ̃. Mʉ́ã wedesããriguere ñañaré bʉaríga. ");
INSERT INTO tue_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodecã bʉaríarigʉ niiãwĩ. Marĩrẽ opatutí ticocoarigʉ niiãwĩ. Wapa cʉ̃ʉ̃rẽ sĩãrĩ́ tiiréno maniã. ");
INSERT INTO tue_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Teero tiigʉ́, cʉ̃ʉ̃rẽ tãnaã́ri siro, wionécogʉda, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato Pascuaricõrõ basocá ʉsenirĩ boogʉ́, sĩcʉ̃ peresuwiipʉ niigʉ̃́rẽ wionécorucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Cʉ̃ʉ̃ jĩĩrére tʉorá, niipetira sĩcãrõména acaribíyira: —¡Jesuré sĩãdutíya! ¡Barrabápere wionécodutiya! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás romanuã dutiráre cõãdʉgagʉ, cãmerĩ́sĩãyigʉ. Basocáre sĩãyígʉ. Teewapa peresutinoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesuré wionécodʉgamiyigʉ. Teero tiigʉ́, basocáre wedesenemoyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cʉ̃́ãpe acaribíyira: —¡Curusapʉ cʉ̃ʉ̃rẽ páabiatu sĩãdutíya! jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ĩtĩã́rĩ jĩĩgʉ̃ tiiyígʉ sáa: —¿Ñeenó ñañaré tiiárĩ cʉ̃ʉ̃? Wapa cʉ̃ʉ̃rẽ sĩãrĩ́ tiiréno bʉaríatʉ. Teero tiigʉ́, cʉ̃ʉ̃rẽ tãnaã́ri siro, wionécogʉda, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Basocápe pʉtʉáriyira. Bayiró acaribíyira. Cʉ̃ʉ̃rẽ curusapʉ páabiatu sĩãdutíyira. Cʉ̃́ã Pilatore docacũmurĩ tiiyíra. ");
INSERT INTO tue_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Teero tiigʉ́, cʉ̃́ã sãĩrére tiidutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Basocá wionécodutiarigʉre wionécoyigʉ. Cʉ̃ʉ̃ dutiráre cõãdʉgare wapa, basocáre sĩãré wapa peresuwiipʉ sõnecorigʉ niipacari, wionécoyigʉ. Jesuré wiyayígʉ, cʉ̃́ã booró tiidutígʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesuré sĩãrã́ wáara néewayira. Cʉ̃́ã too wáari, sĩcʉ̃ Cirene macã macʉ̃ cã́pũpʉ niiãrigʉ pʉtʉaatigʉ tiiyígʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Simón. Cʉ̃ʉ̃rẽ ñee, Jesús apawari curusare cʉ̃ʉ̃ siro apanʉnʉse dutiyira. ");
INSERT INTO tue_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesuré paʉ basocá nʉnʉyíra. Numiã́ bóaneõrã bayiró uti acaribínʉnʉseyira. ");
INSERT INTO tue_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús cãmenʉcã́ ĩña, cʉ̃́ãrẽ jĩĩyigʉ: —Jerusalén macãrã numiã, yʉʉre utirijãña. Mʉ́ãrẽ wáaadarere utiya. Mʉ́ã põnarẽ utiya. ");
INSERT INTO tue_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Too síro mʉ́ã ñañarõ netõã́dacu. Teebʉrecorire mʉ́ã jĩĩãdacu: “Põnamanírã numiã, põnacʉtíñahẽrã, ũpũõñáhẽrã ʉsenicua”, jĩĩãdacu. ");
INSERT INTO tue_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Teero wáari, basocá jĩĩãdacua: “Ʉ̃tãyucʉ ʉ̃sãpʉre ñaapeaaro; opaburi ʉ̃sãrẽ ñañarõ tiirére cãmotáaro”, jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yʉʉ wapa cʉohégʉre ñañarõ tiirá, wapa cʉorápere nemorṍ ñañarõ tiiádacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pʉarã́ basocá ñañarã́rẽ Jesuména sĩãã́dara néewayira. ");
INSERT INTO tue_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","“Dupucoro” wãmecʉtiropʉ jeayira. Toopʉ́ jea, Jesuré curusapʉ páabiatuyira. Basocá ñañarã́rẽ sĩcʉ̃ diamacʉ̃́pe, ãpĩ acuniñape nʉcõyíra. ");
INSERT INTO tue_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús jĩĩyigʉ: —Pacʉ, ãniãrẽ acabóya. Cʉ̃́ã teero tiirére tʉomasĩ́riya. Surara cʉ̃ʉ̃ye suti niimiãriguere batoadara, jĩĩbʉaapeyira. ");
INSERT INTO tue_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Basocá toopʉ́ ĩñanucũyira. Judíoare Dutirá Peti Jesuré buirá jĩĩyira: —Ãpẽrãcã́rẽ netõnéwĩ. Diamacʉ̃́rã Cõãmacʉ̃ beserigʉ Cristo niigʉ̃jã, cʉ̃ʉ̃ basiro netõnéãrõ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suraracã cʉ̃ʉ̃rẽ buijã́yira. Cʉ̃ʉ̃ pʉto wáa, cʉ̃ʉ̃rẽ vino piyare tĩ́ãrã, jĩĩyira: ");
INSERT INTO tue_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Mʉʉ judíoa õpʉ̃ niigʉ̃, mʉʉ basiro netõnéña, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cʉ̃ʉ̃ya dupu sotoapʉ sicapĩ tuunoyiro. “ÃNI JUDÍOA ÕPɄ̃ NIIĨ”, jĩĩ jóanoyiro. ");
INSERT INTO tue_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sĩcʉ̃ basocʉ́ ñañagʉ̃́ curusapʉ tusagʉ́ Jesuré ñañarõ jĩĩyigʉ: —Mʉʉ diamacʉ̃́rã Cõãmacʉ̃ beserigʉ niigʉ̃, mʉʉ basiro netõnéña; ʉ̃sãcãrẽ netõnéña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ãpĩ toopʉ́ tusagʉ́pe cʉ̃ʉ̃rẽ tutigʉ jĩĩyigʉ: —¿Mʉʉ Cõãmacʉ̃rẽ cuiridojãĩ? Marĩrẽ, cʉ̃ʉ̃rẽ sĩcãrõména ñañarõ tiirá tiiíya. ");
INSERT INTO tue_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Marĩrẽ diamacʉ̃́rã ñañarõ tiirá tiiíya, marĩ ñañaré tiirígue wapa. Cʉ̃ʉ̃ doca ñañaré tiirímiyigʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesuré jĩĩyigʉ: —Jesús, mʉʉ Õpʉ̃ sããgʉ̃, yʉʉre wãcũwa. ");
INSERT INTO tue_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Cʉ̃ʉ̃rẽ yʉʉyigʉ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mecʉ̃ãrã yʉʉmena ãñunetõjõãrõ niirṍpʉ niigʉ̃dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Too síro coeritó jeari, niipetiro tiiditapʉ naĩtĩãjõãyiro. Muĩpũ bʉ́reco macʉ̃ bóeriyigʉ. Tée ñamica tres niirĩpʉ naĩtĩãtuyiro. Teero wáari, Cõãmacʉ̃wii popeapʉ Ãñunetõjõãri Tatia cãmotáyosari casero yigadiati, pʉacaséropʉ jeacotuayiro. ");
INSERT INTO tue_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús bayiró acaribíyigʉ: —Pacʉ, yáa yeeripũnarẽ bocañeña, jĩĩyigʉ. Teero jĩĩgʉ̃rã, diajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cien surara dutigʉ́ teero wáari ĩñagʉ̃, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. —Diamacʉ̃́rã ãni wapa cʉohégʉ niimiãyi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Niipetira toopʉ́ ĩñarã jeaarira teero wáari ĩñarã, bayiró wãcũpatiyira. Teero tiirá, cʉ̃́ã cutirore páarara, pʉtʉawayira. ");
INSERT INTO tue_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Niipetira Jesús menamacãrã, Galileapʉ cʉ̃ʉ̃rẽ nʉnʉátirira numiãcã yoaropʉ teero wáarere ĩñanucũyira. ");
INSERT INTO tue_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Sĩcʉ̃ Judea macʉ̃ Arimatea macã macʉ̃ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ José. Cʉ̃ʉ̃ ãñugʉ̃́, diamacʉ̃́ tiigʉ́ niiyigʉ. Cõãmacʉ̃ dutiré basocápʉre niiãdarere coteyigʉ. Cʉ̃ʉ̃cã Judíoare Dutirá Peti menamacʉ̃ niiyigʉ. Teero niipacʉ, cʉ̃́ã Jesuré sĩãdutíri boorímiyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Cʉ̃ʉ̃ Pilato pʉto sããwa, Jesuyá õpʉ̃ʉ̃rẽ sãĩyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Too síro curusapʉ tusagʉ́re néedioco, sutiró ãñurí caseromena cõmayígʉ. Túajea, ʉ̃tãgãpʉ coari tutipʉ cṹũyigʉ. Tiituti sĩcʉ̃no cṹũnoña manirí tuti niiyiro. ");
INSERT INTO tue_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Cʉ̃́ã yeerisãri bʉreco maquẽ quẽnorí bʉreco niiyiro. Yeerisãri bʉreco jeaadaro péero dʉsayíro. ");
INSERT INTO tue_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jesuména Galileapʉ atirira numiã tiitutire ĩñayira. Jesuyá õpʉ̃ʉ̃rẽ cṹũrĩ ĩñayira. ");
INSERT INTO tue_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ĩñaãri siro, coerá, sitiaãñúre quẽnocṹyira. Túajea, Moisére dutiré cṹũrigue jĩĩrõbirora judíoa yeerisãri bʉrecore yeerisãyira. ");
INSERT INTO tue_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cʉ̃́ã yeerisãri bʉreco netõã́ri siro, bóerigã cʉ̃́ã sitiaãñúre quẽnocṹãriguere néewa, cʉ̃ʉ̃rẽ cṹũri tutipʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Toopʉ́ jeara, tiituti biamíriqui ʉ̃tãquicare aperopʉ́ nucũrĩ ĩñayira. ");
INSERT INTO tue_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sããjeara, Jesuyá õpʉ̃ʉ̃rẽ bʉaríyira. ");
INSERT INTO tue_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Teero tiirá, deero jĩĩmasĩriyira. Wãcũña manirṍ pʉarã́ ʉ̃mʉã suti asiyáre sãñarira cʉ̃́ã pʉtopʉ nucũrĩ ĩñayira. ");
INSERT INTO tue_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cʉ̃́ã bayiró cui, munibiáyira. Ʉ̃mʉã́ cʉ̃́ãrẽ jĩĩyira: —¿Deero tiirá catigʉ́re diarira cṹũrõpʉre ãmaãĩ? ");
INSERT INTO tue_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ãnorẽ́ maniĩ. Masãtoaawĩ. Galileapʉ niigʉ̃, mʉ́ãrẽ cʉ̃ʉ̃ wederiguere wãcũña: ");
INSERT INTO tue_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yʉʉ niipetira sõwʉ̃rẽ ñañaré tiirápʉre ticonogʉ̃dacu. Cʉ̃́ã yʉʉre curusapʉ páabiatu sĩãã́dacua. Itiábʉreco siro masãmʉãgʉ̃dacu”, jĩĩmiwĩrã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Teero jĩĩrĩ tʉorá, cʉ̃ʉ̃ wederiguere wãcũbʉayira. ");
INSERT INTO tue_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cʉ̃ʉ̃rẽ cṹũri tutipʉ jeaarira pʉtʉajeara, Jesús beserira oncere niipetirere wedeyira. Teero biiri ãpẽrã́ niipetirare wedeyira. ");
INSERT INTO tue_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jesús beserirare queti wederira noquẽrã niiyira: María Magdalena, Juana, María (Santiago paco), ãpẽrã́ numiã niiyira. ");
INSERT INTO tue_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cʉ̃́ã wedeariguere padeoríyira. “Teero jĩĩjãrã tiicúa”, jĩĩ wãcũjãyira. ");
INSERT INTO tue_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, Pedro cʉtʉwáyigʉ, cʉ̃ʉ̃rẽ cṹũri tutipʉ ĩñagʉ̃ wáagʉ. Toopʉ́ munibiá, ĩñasõnecogʉ, Jesuré cõmarí casero dícʉre ĩñayigʉ. Teero wáariguere ĩñamanijõã, cʉ̃ʉ̃ niirí wiipʉ pʉtʉajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tiibʉrecora pʉarã́ cʉ̃ʉ̃rẽ padeorá Emaús macãpʉ wáara tiiyíra. Jerusalén niiãrira wáari, Emaúspʉ jeaadaro once kilómetros niiã. ");
INSERT INTO tue_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cʉ̃́ã niipetire wáaariguere wedesewayira. ");
INSERT INTO tue_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Teeré wedesera tiirí, Jesurá quẽmʉ, cʉ̃́ãmena wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Cʉ̃ʉ̃rẽ ĩñapacari, Cõãmacʉ̃ cʉ̃́ãrẽ ĩñamasĩhẽrĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús cʉ̃́ãrẽ sãĩñáyigʉ: —¿Ñeenórẽ wedesewara tiii? jĩĩyigʉ. Cʉ̃́ã bayiró bóaneõrã pʉtʉánʉcãyira. ");
INSERT INTO tue_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofas wãmecʉtigʉ yʉʉyigʉ: —¿Mʉʉ sĩcʉ̃rã Jerusalénpʉ wáanetõãrigʉ atebʉ́recori toopʉ́ wáaariguere masĩricotei? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Cʉ̃ʉ̃pe cʉ̃́ãrẽ sãĩñáyigʉ: —¿Deero wáaarĩ? Cʉ̃́ãpe jĩĩyira: —Jesús Nazaret macʉ̃rẽ wáaariguere wedesera tiiáwʉ̃. Cʉ̃ʉ̃ profeta niimiwĩ. Cʉ̃ʉ̃ Cõãmacʉ̃ ĩñacoropʉ, niipetira ĩñacoropʉre cʉ̃ʉ̃ tiirígue, cʉ̃ʉ̃ wedeseriguemena tutuanetõjõãmiwĩ. ");
INSERT INTO tue_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paiaré dutirá, Judíoare Dutirá Peti curusapʉ páabiatu sĩãdutíra, romanuãpʉre ticowa. ");
INSERT INTO tue_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ʉ̃sã cʉ̃ʉ̃rẽ “romanuã dutirére cõã, marĩ Israelya põna macãrã õpʉ̃ sããgʉ̃daqui” jĩĩ wãcũmiwʉ̃. Cʉ̃ʉ̃rẽ sĩãrí siro, itiábʉreco netõã. ");
INSERT INTO tue_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sĩquẽrã numiã ʉ̃sã menamacãrã ʉ̃sãrẽ bayiró ʉcʉanére wedeawã. Mecʉ̃ã bóeri cʉ̃ʉ̃rẽ cṹũri tutipʉ jeaarira niimiãwã. ");
INSERT INTO tue_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ bʉaríarira niiãwã. Pʉtʉajea, “ángelea bauáawã; ‘Jesús catii’, jĩĩãwã” jĩĩ queti wedeawã. ");
INSERT INTO tue_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cʉ̃́ã wedeari siro, ãpẽrã́ ʉ̃sã menamacãrã cʉ̃ʉ̃rẽ cṹũri tutipʉ ĩñarã jeaarira niimiãwã. Cʉ̃́ã numiã́ jĩĩãrirobirora bʉajeáarira niiãwã cʉ̃́ãcã. Cʉ̃ʉ̃pere ĩñariarira niiãwã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã tʉomasĩ́ria. ¿Nocõrõ yoari mʉ́ã profetas jóariguere padeohéra niiãdari? ");
INSERT INTO tue_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“Cõãmacʉ̃ beserigʉ Cristo, cʉ̃ʉ̃ Õpʉ̃ sãããdari sʉguero, ñañarõ netõgʉ̃́daqui”, jĩĩ jóarira niiwã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niipetire Cõãmacʉ̃ye queti jóaripũpʉ cʉ̃ʉ̃ye wedeserere wedeyigʉ. Moisés cʉ̃ʉ̃ jóariguemena wedenʉcãyigʉ. Tée profetas jóariguemena wede yapacʉtíyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cʉ̃́ã wáari macãpʉ jeaadara tiirí, Jesús tiimacãrẽ netõwágʉdʉ tiiróbiro tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Cʉ̃́ãpe cʉ̃ʉ̃rẽ bayiró sãĩyíra: —Ʉ̃sãmena pʉtʉáya. Ñamicapʉ niiã; náĩjõãrõpʉ tiia, jĩĩyira. Jesús sããwayigʉ cʉ̃́ãmena pʉtʉágʉdʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Too síro cʉ̃́ãmena yaagʉ, pãrẽ née, Cõãmacʉ̃rẽ ʉsenire ticoyigʉ. Túajea, pʉatásã, cʉ̃́ãrẽ ticoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Toorá “Jesús niiĩ” jĩĩ ĩñamasĩyira. Cʉ̃ʉ̃pe ditijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cʉ̃́ã cãmerĩ́ jĩĩyira: —Marĩ maapʉ atira, cʉ̃ʉ̃ Cõãmacʉ̃ye queti jóaripũ maquẽrẽ bueri, ãñurõ peti tʉgueñaãwʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nocõrõrã Jerusalénpʉ cãmecópʉtʉayira. Toopʉ́ jeara, Jesús beserira oncere, ãpẽrã́ cʉ̃́ã menamacãrãmena neããrirare bʉajeáyira. ");
INSERT INTO tue_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Too neããrirape cʉ̃́ãrẽ jĩĩyira: —Niirṍrã marĩ Õpʉ̃ Jesús diarigʉpʉ masããrigʉ niiãwĩ. Simónrẽ bauáarigʉ niiãwĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cʉ̃́ãcã maapʉ cʉ̃́ãrẽ wáaariguere wedeyira. Jesús pã pʉatásãrĩ cʉ̃́ã ĩñamasĩãriguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cʉ̃́ã teeré wedesera tiirí, Jesús cʉ̃́ã decopʉ bauáyigʉ. Cʉ̃́ãrẽ ãñudutigʉ jĩĩyigʉ: —Ãñurõ niirecʉtire mʉ́ãpʉre niiãrõ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cʉ̃ʉ̃rẽ ĩña, bayiró cuiyira. “Diarigʉ wãtĩ niiqui”, jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: —¿Deero tiirá cuii? ¿Deero tiirá “Jesús mee niiĩ” jĩĩ wãcũĩ? ");
INSERT INTO tue_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ĩñaña yée wãmorĩrẽ, yée dʉporire. Yʉʉrá niiã. Yʉʉre padeñárã atiñate. Diarigʉ wãtĩ õpʉ̃ʉ̃cʉtiriqui. ");
INSERT INTO tue_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Teero jĩĩgʉ̃rã, cʉ̃ʉ̃ye wãmorĩrẽ, cʉ̃ʉ̃ye dʉporire ẽñoyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cʉ̃́ã ʉseni ĩñamanijõãrã, padeoríyira ména. Teero tiigʉ́: —¿Yaaré cʉoi? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wai cããrĩõã́ri dʉcare ticoyira. ");
INSERT INTO tue_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Cʉ̃ʉ̃pe ñee, cʉ̃́ã ĩñacoro yaayigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉre wáariguere tíatopʉ mʉ́ãmena niigʉ̃, wedewʉ: “Niipetire Moisére dutiré cṹũrigue, profetas jóarigue, Salmopũpʉ jóarigue yʉʉre wáaadare niirõ tiia”, jĩĩ wedemiwʉ̃rã yʉʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Teeré jĩĩtoa, Cõãmacʉ̃ye queti jóaripũ maquẽrẽ cʉ̃́ãrẽ tʉomasĩ́rĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Biiro jóanowʉ̃, jĩĩyigʉ—. “Cõãmacʉ̃ beserigʉ Cristo diagʉdaqui. Itiábʉreco siro masãmʉãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cristo basocáre tiibosárere wedenoãdacu. ‘Mʉ́ã ñañaré tiirére acabóri boorá, wãcũpati, wasoyá’, jĩĩ wedenoãdacu. Teeré Jerusalénpʉ wedenʉcã, too síro niipetiropʉ wedenoãdacu”, jĩĩ jóanowʉ̃. ");
INSERT INTO tue_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mʉ́ã teeré wedeadara niiã. ");
INSERT INTO tue_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yʉʉ Pacʉ mʉ́ãrẽ too sʉgueropʉ jĩĩrirobirora Espíritu Santore yʉʉ ticocogʉda. Teero tiirá, yuejĩña ména atimacãpʉ́. Espíritu Santo jeagʉ, mʉ́ãrẽ tutuare ticogʉdaqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Too síro Jesús cʉ̃́ãrẽ Betania wesapʉ néewayigʉ. Toopʉ́ jea, cʉ̃ʉ̃ye wãmorĩrẽ súumʉõco, “niipetire mʉ́ãrẽ ãñurõ wáaaro” jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Teero jĩĩgʉ̃rã, cʉ̃́ãrẽ toorá cṹũ, ʉ̃mʉã́sepʉ néecomʉãwanoyigʉ. ");
INSERT INTO tue_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cʉ̃́ã cʉ̃ʉ̃rẽ padeoári siro, bayiró ʉseniremena Jerusalénpʉ pʉtʉajõãyira. ");
INSERT INTO tue_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cõãmacʉ̃wiipʉ naĩrõ wáa, Cõãmacʉ̃rẽ “ãñugʉ̃́ niiã” jĩĩrucujãyira.");
INSERT INTO tue_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sicatopʉra Cõãmacʉ̃ wãcũrére marĩrẽ wedegʉdʉ niitoarigʉ niiwĩ. Cõãmacʉ̃mena niirigʉ niiwĩ. Cʉ̃ʉ̃rã́ Cõãmacʉ̃ niijãrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cʉ̃ʉ̃ sicatopʉra Cõãmacʉ̃mena niitoarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cõãmacʉ̃ cʉ̃ʉ̃menarã niipetirare, niipetirere tiirígʉ niiwĩ. Niipetira, niipetire cʉ̃ʉ̃menarã tiirígue niiã. ");
INSERT INTO tue_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cʉ̃ʉ̃ catiré petihérere ticogʉdʉ niirigʉ niiwĩ. Tee catiré ticogʉ́ra basocáre sĩãwócore tiiróbiro niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Basocá niirṍ naĩtĩãrõpʉ tiiróbiro niiriro niiwʉ̃. Cʉ̃ʉ̃ sĩãwócogʉ toopʉ́re sĩãwócoqui. Naĩtĩãre tee sĩãwócorere cãmotámasĩricu. ");
INSERT INTO tue_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cõãmacʉ̃ sĩcʉ̃ basocʉ́re ticocosʉguerigʉ niiwĩ. Cʉ̃ʉ̃ wãmecʉtiwi Juan. ");
INSERT INTO tue_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Cʉ̃ʉ̃ sĩãwócogʉye quetire wedegʉ atirigʉ niiwĩ, niipetira tee quetire padeoáro jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Cʉ̃ʉ̃ sĩãwócogʉ mee niirigʉ niiwĩ. Teero tiigʉ́, sĩãwócogʉye quetipere wedegʉ atirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sĩãwócogʉ peti atigʉdʉ tiirígʉ niiwĩ atibʉ́recopʉre. Cʉ̃ʉ̃ niipetirare tʉomasĩ́re ticogʉdʉ niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cõãmacʉ̃ cʉ̃ʉ̃mena atibʉ́recore tiirígʉ niipacari, cʉ̃ʉ̃ ãnopʉ́ niirĩ, atibʉ́reco macãrãpe cʉ̃ʉ̃rẽ ĩñamasĩririra niiwã. ");
INSERT INTO tue_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cʉ̃ʉ̃ya ditapʉ jeawi. Too macãrã cʉ̃ʉ̃ya dita macãrãpe cʉ̃ʉ̃rẽ bocariwa. ");
INSERT INTO tue_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sĩquẽrã cʉ̃ʉ̃rẽ boca, padeowá. Cõãmacʉ̃ niipetirare cʉ̃ʉ̃rẽ padeoráre cʉ̃ʉ̃ põna wáari tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cõãmacʉ̃ põna niiré marĩ pacʉsʉ̃mʉã põnacʉtíre tiiróbiro niiria. Marĩ pacʉsʉ̃mʉã cʉ̃́ã tiirémena, teero biiri cʉ̃́ã põnacʉtídʉgaremena põnacʉtícua. Cõãmacʉ̃ põna niirépe merẽã niiã. Cõãmacʉ̃ cʉ̃ʉ̃ boorémena basocáre cʉ̃ʉ̃ põna wáari tiiquí. ");
INSERT INTO tue_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cõãmacʉ̃ wãcũrére marĩrẽ wedegʉdʉ basocʉ́ bauárigʉ niiwĩ. Cʉ̃ʉ̃ ʉ̃sãmena niiwĩ. Basocáre ãñurõ peti tiijã́wĩ. Niipetire cʉ̃ʉ̃ wedeserigue, cʉ̃ʉ̃ tiirígue diamacʉ̃́ niiwʉ̃. Cʉ̃ʉ̃ asibatérere, cʉ̃ʉ̃ ʉpʉtí macʉ̃ niirecʉtirere ĩñawʉ̃. Tee ʉpʉtí maquẽrẽ Cõãmacʉ̃ macʉ̃ sĩcʉ̃ niigʉ̃́ dícʉ cʉoquí. ");
INSERT INTO tue_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan cʉ̃ʉ̃ye quetire wedegʉ, bayiró bʉsʉrómena biiro jĩĩ wedewi: —Ãnirã́ niiĩ yʉʉ mʉ́ãrẽ wedeserigʉ. Biiro jĩĩwʉ̃: “Ãpĩ yʉʉ siro atiqui. Cʉ̃ʉ̃ yʉʉ bauáadari sʉgueropʉre niitoayigʉ. Teero tiigʉ́, cʉ̃ʉ̃ yʉʉ nemorṍ niiqui”, jĩĩãwʉ̃, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cʉ̃ʉ̃ marĩrẽ ãñurõ peti tiijã́qui. Teero tiigʉ́, marĩrẽ ãñurére ticorucujãqui. ");
INSERT INTO tue_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cõãmacʉ̃ Moisémena cʉ̃ʉ̃ dutirére ticorigʉ niiwĩ. Jesucristomenape cʉ̃ʉ̃ basocáre ãñuré ticorére, teero biiri diamacʉ̃́ niirére masĩrĩ tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sĩcʉ̃nopera Cõãmacʉ̃rẽ ĩñariqui. Cʉ̃ʉ̃ macʉ̃ sĩcʉ̃ niigʉ̃́ cʉ̃ʉ̃mena niirucugʉ cʉ̃ʉ̃ Pacʉre marĩrẽ masĩrĩ tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén macãrã judíoare dutirá Juan pʉtopʉ paiaré, teero biiri levita basocare sãĩñádutira ticocorira niiwã. Cʉ̃́ãpeja cʉ̃ʉ̃ pʉtopʉ jeara: —¿Ñiirũno basocʉ niimiĩ mʉʉ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Cʉ̃ʉ̃pe cʉ̃́ãrẽ yayióro manirṍ, diamacʉ̃́rã wedewi: —Yʉʉ Cõãmacʉ̃ beserigʉ Cristo mee niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—Too docare ¿ñiirũno niiĩ? ¿Mʉʉ Elías niiĩ? jĩĩwã. —Niiria yʉʉja, jĩĩwĩ. —¿Mʉʉ profeta, basocá cʉ̃́ã “atigʉdaqui” jĩĩrigʉ niiĩ? jĩĩwã. —Niiria, jĩĩwĩ cʉ̃ʉ̃peja sũcã. ");
INSERT INTO tue_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Teero tiirá, cʉ̃́ãpeja sãĩñánemowã: —Too docare ¿ñiirũno niiĩ mʉʉ? Ʉ̃sãrẽ yʉʉya; ʉ̃sãrẽ ticocoarirare wedeadara tiia. ¿Mʉʉ basiro deero tʉgueñaĩ? jĩĩ sãĩñáwã sũcã. ");
INSERT INTO tue_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Cʉ̃́ãrẽ cʉ̃ʉ̃pe yʉʉwi: —Yʉʉ niiã yucʉ manirṍ, basocá manirṍpʉ bayiró bʉsʉrómena wedegʉ́. Profeta Isaías wederirobirora ateré wedea yʉʉcã: Sĩcʉ̃ õpʉ̃ atiadarimarẽ quẽnarõ tiiróbiro, marĩ Õpʉ̃ atiadari sʉguero, mʉ́ã ñañaré tiirére duujã́, ãñurõ niiyueya, jĩĩã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanrẽ́ sãĩñárã jeaarira fariseo basoca ticocoarira niirira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ sãĩñánemowã sũcã: —Too docare mʉʉ Cõãmacʉ̃ beserigʉ Cristo o Elías o profeta cʉ̃́ã “atigʉdaqui” jĩĩrigʉ niiripacʉ, ¿deero tiigʉ́ wãmeõtii? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Yʉʉ ocoména wãmeõtia. Ãpĩpé mʉ́ã watoapʉre mʉ́ã ĩñamasĩhẽgʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Cʉ̃ʉ̃ yʉʉ siro atigʉdʉpe ãñunetõgʉ̃ niiqui. Yʉʉpeja cʉ̃ʉ̃rẽ sĩcãrĩbíridojãcu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tee Betania wãmecʉtiro día Jordán apeniñapʉ́ teero wáawʉ. Toopʉ́ Juan basocáre wãmeõtiwi. ");
INSERT INTO tue_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Apebʉ́recope Juan Jesús atiri ĩñagʉ̃, jĩĩwĩ: —¡Ĩñaña! Ãnirã́ Cõãmacʉ̃ ticodiocorigʉ, cordero tiiróbiro niigʉ̃́ niiĩ. Cʉ̃ʉ̃ diarémena atibʉ́reco macãrã ñañaré tiirére petirí tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yʉʉ mʉ́ãrẽ ateré wedeawʉ̃: “Sĩcʉ̃ basocʉ́ yʉʉ siro atigʉdaqui. Cʉ̃ʉ̃ yʉʉ bauáadari sʉgueropʉ niitoayigʉ. Teero tiigʉ́, cʉ̃ʉ̃ yʉʉ nemorṍ niiqui”, jĩĩãwʉ̃. Ãnirẽ́na wedeseawʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“¿Noã niiĩ?” jĩĩmasĩritʉ ména. Masĩripacʉ, Israelya põna macãrã cʉ̃ʉ̃rẽ masĩãrõ jĩĩgʉ̃, cʉ̃́ãrẽ ocoména wãmeõtigʉ atiwʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan wedenemowĩ: —Espíritu Santo sĩcʉ̃ bua tiiróbiro baugʉ́ ʉ̃mʉã́sepʉ diiátiri ĩñawʉ̃. Ãnipʉ́re jeapeawi. ");
INSERT INTO tue_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“¿Noã niiĩ?” jĩĩmasĩritʉ ména. Yʉʉre ocoména wãmeõtidutigʉ yʉʉre biiro jĩĩti: “Mʉʉ Espíritu Santo diiáti, sĩcʉ̃pʉre jeapeari ĩñagʉ̃dacu. Cʉ̃ʉ̃rã́ Espíritu Santore ticodiocogʉdʉ niiĩ”, jĩĩti. ");
INSERT INTO tue_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cʉ̃ʉ̃ teero jĩĩrirobirora yʉʉ ĩñawʉ̃. Teero tiigʉ́, ateré wedea: Ãnirã́ niiĩ Cõãmacʉ̃ macʉ̃, jĩĩwĩ Juan. ");
INSERT INTO tue_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Apebʉ́reco Juan toopʉ́ niiwĩ sũcã. Ʉ̃sã pʉarã́ cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ bapacʉtiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan Jesús netõwári ĩñagʉ̃, ʉ̃sãrẽ jĩĩwĩ: —¡Ĩñaña! Ãnirã́ Cõãmacʉ̃ ticodiocorigʉ, cordero tiiróbiro niigʉ̃́ niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, ʉ̃sã pʉarã́ Jesuré nʉnʉwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús cãmenʉcã́, ʉ̃sã nʉnʉrĩ́ ĩñagʉ̃: —¿Ñeenórẽ ãmaãĩ, yʉʉre nʉnʉrã́? jĩĩwĩ. —Rabí, jĩĩwʉ̃ ʉ̃sãpe—. (Rabí “basocáre buegʉ́” jĩĩdʉgaro tiia.) ¿Noopʉ́ niiãrĩ mʉʉ? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Jãmʉ, ĩñarã atiya, jĩĩwĩ ʉ̃sãrẽ. Ʉ̃sã cʉ̃ʉ̃mena wáa, cʉ̃ʉ̃ niirṍpʉ ĩñarã jeawʉ. Ñamicapʉ niiwʉ̃. Teero tiirá, cʉ̃ʉ̃mena niinañiõjõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yʉʉmena Jesuré nʉnʉgʉ̃́ Andrés wãmecʉtiwi. Cʉ̃ʉ̃cã Juan basocáre wãmeõtigʉ wederiguere tʉowí. Cʉ̃ʉ̃ Simón Pedro bai niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés cʉ̃ʉ̃ sõwʉ̃ Simónrẽ máata bʉajeá, cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mesías Cõãmacʉ̃ “ticodiocogʉda” jĩĩrigʉre bʉajeáawʉ̃, jĩĩyigʉ. (Mesías “Cristo Cõãmacʉ̃ beserigʉ” jĩĩdʉgaro tiia.) ");
INSERT INTO tue_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Cʉ̃ʉ̃rẽ Jesús pʉtopʉ sʉojeáwi. Jesús cʉ̃ʉ̃rẽ ĩñagʉ̃, jĩĩwĩ: —Mʉʉ Simón niiã Jonás macʉ̃. Too síro mʉʉrẽ “Cefas” jĩĩãdacua, jĩĩwĩ. (Cefas ãpẽrãyémena Pedro niiã.) ");
INSERT INTO tue_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Apebʉ́reco Jesús “Galileapʉ wáaada” jĩĩ wãcũrigʉ niiwĩ. Cʉ̃ʉ̃ toopʉ́ wáaadari sʉguero, Felipere bʉajeá: —Jãmʉ yʉʉmena, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida macã macʉ̃ niiwĩ. Andrés, Pedro too macãrãrã niiwã. ");
INSERT INTO tue_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe Natanaelre bʉajeá, jĩĩyigʉ: —Moisés jóaripũpʉ jĩĩrigʉre bʉajeáawʉ̃. Profetacã cʉ̃ʉ̃ye maquẽrẽna jóarira niiwã. Jesús Nazaret macʉ̃, José macʉ̃ cʉ̃́ã jĩĩnogʉ̃ niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael jĩĩyigʉ: —Nazaretpʉre sĩcʉ̃ ãñugʉ̃́no maniĩ. Felipe yʉʉyigʉ: —Jãmʉ, ĩñaco marĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús Natanael atiri ĩñagʉ̃: —Ãni Israelya põna macʉ̃ peti, tiiditóre manigʉ̃́ niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael cʉ̃ʉ̃rẽ sãĩñáwĩ: —¿Deero tii mʉʉ yʉʉre masĩĩ? jĩĩwĩ. —Felipe mʉʉrẽ sʉoádari sʉguero, yʉʉ mʉʉrẽ ĩñatoaawʉ̃ mée. Yucʉgʉ higueragʉ docapʉ niiãwʉ̃ mʉʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Rabí, mʉʉ Cõãmacʉ̃ macʉ̃ niiã. Israelya põna macãrã õpʉ̃ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—¿“Higueragʉ docapʉ niiãwʉ̃ mʉʉ” yʉʉ jĩĩrére tʉogʉ́, yʉʉre padeói? Too síropʉre mʉʉ tee nemorṍ ãñuré petire ĩñagʉ̃dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús jĩĩnemowĩ: —Yʉʉ mʉ́ãrẽ ateréja diamacʉ̃́rã jĩĩã: Too síropʉ mʉ́ã ʉ̃mʉã́se pã́õrĩ ĩñaãdacu. Ángelea Cõãmacʉ̃yara yʉʉ niipetira sõwʉ̃ pʉtopʉ mʉãwa, diiátiri ĩñaãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Itiábʉreco wáaro tiirí, Caná Galilea ditapʉre wãmosíari bosebʉreco tiipéowa. Jesús paco toopʉ́ jeawo. ");
INSERT INTO tue_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuré, ʉ̃sã cʉ̃ʉ̃ buerácãrẽ boocórira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cʉ̃́ã bosebʉreco tiirí, vino petijṍãwʉ̃. Teero tiigó, Jesús pacopéja cʉ̃ʉ̃rẽ jĩĩwõ: —Macʉ̃, vino petijṍããyu. ");
INSERT INTO tue_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Cʉ̃ʉ̃peja coore yʉʉwi: —Paco, ¿deero tiigó yʉʉre wedei? Yʉʉ teeré tiirítono jearia ména, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Coopeja tii bosebʉreco tĩ́ãcoterare: —Cʉ̃ʉ̃ dutiró tiiyá, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Toopʉ́ seisparʉ ʉ̃tãparʉ niiwʉ̃. Ʉ̃sã judíoare dutirobirora jũĩrĩrẽ́ coseádare oco posetíre niiwʉ̃. Pacapárʉ niiwʉ̃: Sicarʉ́re pairó oco cincuenta o setenta litros sããwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús tĩ́ãcoterare: —Atepárʉpʉ ocoré píosãdadodʉpoya, jĩĩwĩ. Teeparʉre píosãdadorira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Teero tiiári siro, Jesús cʉ̃́ãrẽ jĩĩwĩ: —Bosebʉreco tiipéogʉre péero waané, néewaya. Cʉ̃́ã “jáʉ” jĩĩ, néewawa. ");
INSERT INTO tue_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bosebʉreco tiipéogʉ tee oco vino cotowéoariguere sĩniñáwĩ. Jesús tiiáriguere masĩririgʉ niiwĩ ména. Tĩ́ãcoterape teeparʉre píosãdadojĩrã, masĩwã. Sĩniñáãri siro, wãmosíagʉre sʉocó, ");
INSERT INTO tue_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","jĩĩwĩ: —Niipetira sicato vino tĩ́ãrã, ãñurére tĩ́ãsʉguecua. Pairó sĩniã́ri siropʉ, bʉ́ri niirére tĩ́ãcua. Mʉʉpe ãñuré vinopere síropʉ tĩ́ãdutiayu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús Caná Galilea ditapʉ teeré tiiwí. Tee cʉ̃ʉ̃ tutuaremena sicato tiiẽ́ñonʉcãre niiwʉ̃. Teeména cʉ̃ʉ̃ tutuarere ẽñowĩ́. Teeré ĩñarã, ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃rẽ padeowʉ́. ");
INSERT INTO tue_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Too síro Jesús Capernaum macãpʉ búawawi. Cʉ̃ʉ̃ paco, cʉ̃ʉ̃ baira, ʉ̃sã cʉ̃ʉ̃ buerá cʉ̃ʉ̃mena wáawʉ. Ʉ̃sã tiimacãpʉre sĩquẽ bʉrecori niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua judíoa bosebʉreco jeaadaro péerogã dʉsawʉ́. Teero tiigʉ́, Jesús Jerusalénpʉ wáawi. ");
INSERT INTO tue_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Toopʉ́ jeagʉ, Cõãmacʉ̃wiipʉ wáawi. Tiiwií wesa macã yepapʉre wáicʉra dúari basocare bʉajeáwi. Toopʉ́re wecʉaré, ovejare, buare dúawa. Ãpẽrã́ apeyé dita maquẽ niyerure wasorí basoca toopʉ́ duiwa. ");
INSERT INTO tue_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Cʉ̃́ã teero tiirí ĩñagʉ̃, Jesús tãnarídare quẽnowĩ́. Tiidaména dúari basocare, cʉ̃́ãyara ovejare, wecʉaré tãnawíonecowi. Niyeru wasorí basocaye niyerure maabatéwi. Cʉ̃́ãye mesarire tuunécõãcũjãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Buare dúari basocare jĩĩwĩ: —Ãniãrẽ néewitiwaya. Yʉʉ Pacʉya wiire dúari wii tiiríjãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cʉ̃ʉ̃ teero tiirí ĩñarã, Cõãmacʉ̃ye queti jóaripũpʉ ate jóariguere ʉ̃sã wãcũwʉ̃: “Cõãmacʉ̃, yʉʉ mʉʉya wiire maĩnetṍre yʉʉ popeapʉ jʉ̃ʉ̃witiro tiiróbiro tʉgueñaga”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judíoare dutirápeja cʉ̃ʉ̃ cõãwionecori ĩñarã, cʉ̃ʉ̃rẽ jĩĩwã: —¿Noã dutirómena cõãwionecoi? Cõãmacʉ̃ dutirómena tiigʉ́ja, tiiẽ́ñoña ʉ̃sãrẽ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesupéja cʉ̃́ãrẽ jĩĩwĩ: —Atiwiiré cõãjãña. Itiábʉreco siro yʉʉ quẽnogʉ̃́da sũcã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judíoare dutirápeja jĩĩwã: —Atiwiiré tiirá cuarenta y seis cʉ̃marĩ peawá. ¿Mʉʉpeja itiábʉreco siro quẽnogʉ̃́dari? Tiimasĩ́ricu sáa, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesupéja wiiré wedesegʉ, cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ wáaadarere wedesegʉ tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Teero tiirá, cʉ̃ʉ̃ dia masãri siropʉ, tee cʉ̃ʉ̃ wedeseriguere ʉ̃sã wãcũwʉ̃. Teeré wãcũrã, Cõãmacʉ̃ye queti jóaripũpʉ jóariguere, teero biiri Jesús wedeseriguecãrẽ padeowʉ́. ");
INSERT INTO tue_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paʉ Jerusalénpʉ Pascua bosebʉreco neãwã. Cʉ̃́ã Jesús tutuaremena pee tiiẽ́ñorere ĩñawã. Teeré ĩñarã, “Cõãmacʉ̃ ticodiocorigʉ niiqui” jĩĩrã, cʉ̃ʉ̃rẽ padeowá. ");
INSERT INTO tue_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jesupé cʉ̃́ãrẽ ĩñamasĩpetijãgʉ̃, ãpẽrã́ wedero manirṍ cʉ̃ʉ̃ basiro basocá niipetira cʉ̃́ã wãcũrére masĩpetijãwĩ. Teero tiigʉ́, “cʉ̃́ã ‘padeóa’ jĩĩpacari, diamacʉ̃́ padeorá mee niiĩya” jĩĩmasĩjãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sĩcʉ̃ fariseo basocʉ niiwĩ. Cʉ̃ʉ̃ wãmecʉtiwi Nicodemo. Cʉ̃ʉ̃ judíoare dutirá menamacʉ̃ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sicañami Nicodemo Jesuré ĩñagʉ̃ jeawi. Cʉ̃ʉ̃rẽ jĩĩwĩ: —Basocáre buegʉ́, Cõãmacʉ̃ mʉʉmena niiqui. Teero tiigʉ́, cʉ̃ʉ̃ tutuare ticorémena mʉʉ tiiẽ́ñomasĩã. Mʉʉ tiiẽ́ñore ĩñarã, ʉ̃sã ateré masĩã: Cõãmacʉ̃ mʉʉrẽ ticodiocojĩyi ʉ̃sãrẽ buedutigʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉ mʉʉrẽ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ sicatopʉ bauárirobiro bauánemoripacʉ, Cõãmacʉ̃ dutiré jeaboarigue cʉ̃ʉ̃pʉre jearicu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo cʉ̃ʉ̃rẽ sãĩñáwĩ: —¿Deero tii marĩ bʉcʉári siro, marĩ pacoya páatipʉ sããwa, bauábogari sũcã? Sããwa, bauámasĩricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ ocoména, teero biiri Espíritu Santomena bauáheri, Cõãmacʉ̃ dutiré jeaboarigue cʉ̃ʉ̃pʉre jearicu. ");
INSERT INTO tue_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Basocá põna basocára niicua. Cʉ̃́ãrã Espíritu Santomena bauára, Cõãmacʉ̃ põna sããcua. ");
INSERT INTO tue_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Teero tiigʉ́, mʉʉ “niipetira sicato bauárirobiro bauánemorõ booa” jĩĩrére tʉogʉ́, tʉomanírijãña. ");
INSERT INTO tue_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mʉʉ masĩã: Wĩno noo booró páapucu. Wĩno bʉsʉri tʉopacʉ́, ¿noopé atii; noopé wáai? jĩĩmasĩricu. Espíritu Santomena bauári tiiré tee tiiróbiro wáaa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo jĩĩwĩ: —¿Deero tiiró teero wáabogari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Mʉʉ Israelya põna macãrãrẽ Cõãmacʉ̃ye maquẽrẽ buegʉ́ niipacʉ, ¿teeré masĩrii? ");
INSERT INTO tue_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ʉ̃sã masĩrére, ʉ̃sã ĩñariguere mʉ́ãrẽ wedea. Mʉ́ãpe ʉ̃sã wederére padeorícu. ");
INSERT INTO tue_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Atibʉ́recopʉ wáarere yʉʉ wederi, mʉ́ã padeoría. Ʉ̃mʉã́sepʉ wáarepereja yʉʉ wedericãrẽ, nemorṍrã padeorícu. ");
INSERT INTO tue_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Sĩcʉ̃ basocʉ́ ʉ̃mʉã́sepʉ mʉãwarigʉ maniquí. Yʉʉ niipetira sõwʉ̃ ʉ̃mʉã́sepʉ niirigʉ diiátiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tíatopʉre yucʉ manirṍpʉ Moisés ãña cõmeména tiirígʉre yucʉgʉpʉ néemʉõnʉcõyigʉ. Cʉ̃ʉ̃ ãñarẽ néemʉõnʉcõrirobirora yʉʉ niipetira sõwʉ̃cã néemʉõnʉcõnogʉ̃dʉ niiã. ");
INSERT INTO tue_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Biiro yʉʉre tiirémena niipetira yʉʉre padeorá catirucujããdacua, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Cõãmacʉ̃ atibʉ́reco macãrãrẽ bayiró maĩjĩ́gʉ̃, cʉ̃ʉ̃ macʉ̃ sĩcʉ̃ niigʉ̃́rẽ ticodiocorigʉ niiwĩ. Teero tiirá, niipetira cʉ̃ʉ̃ macʉ̃rẽ padeorá pecamepʉ wáaricua; cʉ̃ʉ̃mena catirucujããdacua. ");
INSERT INTO tue_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cõãmacʉ̃ atibʉ́reco macãrãrẽ “ñañarõ tiigʉ́da” jĩĩgʉ̃ mee cʉ̃ʉ̃ macʉ̃rẽ ticodiocorigʉ niiwĩ; cʉ̃́ãrẽ netõnéãrõ jĩĩgʉ̃ ticodiocorigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Cõãmacʉ̃ cʉ̃ʉ̃ macʉ̃rẽ padeoráre ñañarõ tiiríqui. Cʉ̃ʉ̃rẽ padeohérape ñañarõ tiinóãdara niitoaya mée Cõãmacʉ̃ macʉ̃ sĩcʉ̃ niigʉ̃́rẽ padeohére wapa. ");
INSERT INTO tue_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cõãmacʉ̃ macʉ̃ sĩãwócore néeatigʉ tiiróbiro atibʉ́recopʉre atiwi. Basocápe ñañaré tiirá niijĩrã, sĩãwócore néeatigʉre booríyira. Ñañarére tiidʉgájĩrã, naĩtĩãrõpʉ pʉtʉádʉgayira. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃́ãrẽ ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ñañaré tiigʉ́ sĩãwócore cʉogʉ́re booríqui. Cʉ̃ʉ̃ ñañaré tiirére bauanérĩ boohégʉ, sĩãwócore pʉtopʉ jeadʉgariqui. ");
INSERT INTO tue_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Diamacʉ̃́rã ãñuré tiigʉ́pe sĩãwócore néeatigʉre nʉnʉrucúqui. Ãñuré tiigʉ́ sĩãwócore pʉtopʉ niirĩ, basocá cʉ̃ʉ̃ tiirére ĩñaãya. Cʉ̃ʉ̃ Cõãmacʉ̃ booróbiro tiirí, ĩñanoã. ");
INSERT INTO tue_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Too síro Jesús ʉ̃sã cʉ̃ʉ̃ buerámena Judea ditapʉ wáawʉ. Toopʉ́re basocáre wãmeõtira, yoari mee niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Enón wãmecʉtiropʉ niiyigʉ. Enón Salim wãmecʉtiri macã pʉtogã niiwʉ̃. Toopʉ́re oco niirṍ niiwʉ̃. Teero tiigʉ́, toopʉ́re wãmeõtigʉ tiiyígʉ. Basocá cʉ̃ʉ̃ pʉtopʉ wãmeõtidutira wáayira. ");
INSERT INTO tue_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juan cʉ̃ʉ̃rẽ peresuwiipʉ sõnecoadari sʉguero, toopʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sicabʉreco Juan buerére nʉnʉrã́ sĩcʉ̃ judíoare dutirá menamacʉ̃mena bayiró cãmerĩ́ wedeseyira. Cʉ̃́ãrẽ dutiré jĩĩrõbirora cosedutíre maquẽrẽ cãmerĩ́ wedeseyira. ");
INSERT INTO tue_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Too síro cʉ̃́ã Juan pʉtopʉ wáa, cʉ̃ʉ̃rẽ jĩĩyira: —Ʉ̃sãrẽ buegʉ́, jõõ niirito, día Jordán apeniñapʉ́ mʉʉmena niirigʉ, ʉ̃sãrẽ mʉʉ wederigʉ mecʉ̃tígãrẽ wãmeõtigʉ tiiáwĩ. Niipetira cʉ̃ʉ̃rẽ nʉnʉrã́ tiiáwã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan cʉ̃́ãrẽ yʉʉyigʉ: —Sĩcʉ̃no ãñurére tiirí, Cõãmacʉ̃ cʉ̃ʉ̃rẽ ticorigue niiã. ");
INSERT INTO tue_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mʉ́ã yʉʉ wederiguere tʉotóawʉ. Yʉʉpeja “Cõãmacʉ̃ beserigʉ Cristo mee niiã” jĩĩwʉ̃. Yʉʉ cʉ̃ʉ̃ sʉguero ticocorigʉ niiã. ");
INSERT INTO tue_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Queorémena teeré wedegʉda: Wãmosíagʉdʉ nʉmo cʉ̃ʉ̃yago niico. Cʉ̃ʉ̃ menamacʉ̃ cʉ̃ʉ̃ wedeserere tʉoquí. Teeré tʉogʉ́, bayiró ʉseniqui. Teero tiigʉ́, yʉʉ wãmosíagʉdʉ menamacʉ̃ ʉsenirõbirora bayiró ʉseniã. ");
INSERT INTO tue_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Basocá ĩñacoropʉ cʉ̃ʉ̃ yʉʉ nemorṍ ʉpʉtí macʉ̃ wáaro booa; yʉʉpe bʉ́ri niigʉ̃́ pʉtʉágʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ʉ̃mʉã́sepʉ atirigʉ niipetira nemorṍ niiĩ. Atibʉ́reco macãrãpe atibʉ́reco maquẽ dícʉre masĩcua; teeré wedesecua. Ʉ̃mʉã́sepʉ atirigʉpe niipetira nemorṍ niiĩ. ");
INSERT INTO tue_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Cʉ̃ʉ̃ ʉ̃mʉã́sepʉ cʉ̃ʉ̃ ĩñariguere, cʉ̃ʉ̃ tʉoríguere wedesei. Cʉ̃ʉ̃ wedeserere padeoráno manicúa. ");
INSERT INTO tue_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Cʉ̃ʉ̃ wedeserere padeogʉ́nope Cõãmacʉ̃ wedeserecãrẽ padeoquí. “Cõãmacʉ̃ wedesere diamacʉ̃́ niiã”, jĩĩqui. ");
INSERT INTO tue_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Cõãmacʉ̃ Espíritu Santore cãmotáro manirṍ ticorigʉ niiwĩ Jesuré. Teero tiigʉ́, Jesús Cõãmacʉ̃ wãcũrére wedesei. ");
INSERT INTO tue_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cõãmacʉ̃ cʉ̃ʉ̃ macʉ̃rẽ maĩgʉ̃́, niipetirere, niipetirare dutimasĩrere ticoyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cʉ̃ʉ̃ macʉ̃rẽ padeogʉ́no catiré petihére cʉoquí. Cʉ̃ʉ̃rẽ tʉohégʉnope catiré petihére bʉarígʉdaqui. Cõãmacʉ̃ bayiró cúaremena cʉ̃ʉ̃rẽ ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Paʉ basocá Jesuré nʉnʉwã́. Juan wãmeõtiri basocʉ nemorṍ ʉ̃sã Jesús buerápe basocáre wãmeõtiwʉ. Jesús basiro cʉ̃́ãrẽ wãmeõtiriwi. Paʉ basocá Jesuré nʉnʉré quetire, teero biiri cʉ̃́ã wãmeõtire quetire fariseo basoca tʉoyíra. Jesús “cʉ̃́ã tee quetire tʉoáyira” jĩĩrére tʉoári siro, ");
INSERT INTO tue_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ʉ̃sã Judeapʉ niiãrira Galileapʉ wáawʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Toopʉ́ wáara, Samaria ditapʉ netõwáro niirõ tiiwʉ́. ");
INSERT INTO tue_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tiiditapʉre Sicar wãmecʉtiri macãpʉ jeawʉ. Tiimacã pʉto tíato macʉ̃ Jacob sicadita sãĩyígʉ. Too síro tiidita cʉ̃ʉ̃ macʉ̃ Joseré pʉtʉáyiro. ");
INSERT INTO tue_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tiiditapʉ oco waarí cope Jacob tiirí cope niiwʉ̃. Jesús yoaro wáa, páasʉtigʉ, tiicope wesapʉ jeanuãwĩ. Coeritó niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Cʉ̃ʉ̃ toopʉ́ duiritabe, ʉ̃sã yaaré sãĩrã́ wáara, macãpʉ piyawawʉ. Ʉ̃sã toopʉ́ wáaari siro, sĩcõ numiṍ Samaria dita macõ tiicopepʉ oco waagó jearigo niiwõ. Jesús coore jĩĩyigʉ: —Yʉʉre oco tĩ́ãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judíoa Samaria dita macãrãmena cãmerĩ́ ĩñadʉgariya. Teero tiigó, coope cʉ̃ʉ̃rẽ jĩĩyigo: —¿Deero tiigʉ́ mʉʉ judíoayʉ niipacʉ, yʉʉ Samaria dita macõrẽ oco sãĩĩ? jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús yʉʉyigʉ: —Mʉʉ Cõãmacʉ̃ basocáre ticorére masĩria. Yʉʉcãrẽ masĩricu. Mʉʉ masĩgõjã, yʉʉre sãĩbóajĩyu. Mʉʉ sãĩrĩ́, yʉʉpe oco catiri tiiré petire ticoboajĩyu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Coope yʉʉyigo: —Mʉʉ ocoré waanérirʉ cʉoría. Aticopé ʉ̃cʉ̃ã́ri cope niiã. ¿Noopʉ́ mʉʉ oco catiri tiirére bʉabógari? ");
INSERT INTO tue_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Marĩ ñecʉ̃ Jacob aticopé maquẽrẽ sĩniyígʉ. Cʉ̃ʉ̃ põna, cʉ̃ʉ̃yara ecarácã sĩniyíra. Cʉ̃ʉ̃ marĩrẽ aticoperé cṹũyigʉ. ¿Mʉʉpeja cʉ̃ʉ̃ nemorṍ niiĩ? jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Cʉ̃ʉ̃pe jĩĩyigʉ: —Niipetira aticopé maquẽ ocoré sĩnirã́ sĩnidʉgáadacua sũcã. ");
INSERT INTO tue_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yʉʉ ticorépere sĩnigʉ̃́no sĩnidʉgánemoriqui. Cʉ̃ʉ̃pʉre cʉ̃ʉ̃ya yeeripũnapʉ oco õmayucoro tiiróbiro niiãdacu. Teeména catirucujãgʉ̃daqui, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Too docare yʉʉre teeocore ticoya. Mʉʉ yʉʉre ticori, yʉʉ oco sĩnidʉgánemoricu. Teero biiri aticopepʉ́re oco waadʉgágo ĩñanucũnemoricu sáa, jĩĩyigo coopeja. ");
INSERT INTO tue_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Too docare mʉʉ manʉrẽ sʉogó wáaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Yʉʉ manʉ manigṍ niiã, jĩĩyigo coopeja. Cʉ̃ʉ̃pe jĩĩyigʉ sáa: —Mʉʉ “manʉ maniã” jĩĩgõ, diamacʉ̃́rã jĩĩã. ");
INSERT INTO tue_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mʉʉ sicamoquẽñerã ʉ̃mʉã́mena manʉcʉtirigo niimiwʉ̃. Mecʉ̃tígã mʉʉmena niigʉ̃́cã mʉʉ manʉ díamacʉ̃ niirii. Mʉʉ wedesere diamacʉ̃́rã niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Coope cʉ̃ʉ̃rẽ yʉʉyigo sáa: —Yʉʉ tʉgueñarĩ, mʉʉ sĩcʉ̃ profeta niicu. ");
INSERT INTO tue_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ʉ̃sã ñecʉ̃sʉ̃mʉã Samaria dita macãrã iigʉ́ ʉ̃tãgʉ̃pʉ́ Cõãmacʉ̃rẽ padeoyíra. Mʉ́ã judíoape “Jerusalénpʉ Cõãmacʉ̃rẽ padeoró booa” jĩĩã, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús coore jĩĩyigʉ: —Yʉʉ wederére tʉoyá: Iigʉ́ ʉ̃tãgʉ̃pʉ́ wáaripacara, Jerusalénpʉ wáaripacara, mʉ́ã Cõãmacʉ̃rẽ padeoríto jeaadaro tiia. ");
INSERT INTO tue_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉ́ã Samaria dita macãrã mʉ́ã padeorére ãñurõ tʉomasĩ́ricu. Ʉ̃sãpeja ʉ̃sã padeorére masĩã. Biiro biia: Cõãmacʉ̃ judíoayʉmena basocáre netõnégʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Basocá Cõãmacʉ̃rẽ diamacʉ̃́rã padeorá cʉ̃́ãye yeeripũnarĩpʉ padeoríto jeaadaro tiia; jeatoaa mée. Cõãmacʉ̃ cʉ̃ʉ̃rẽ padeoráre teerora padeorí booquí. ");
INSERT INTO tue_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cõãmacʉ̃ bauhégʉ niiĩ. Cʉ̃ʉ̃rẽ padeorá yeeripũnarĩpʉ diamacʉ̃́rã padeoró booa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Coopeja jĩĩyigo: —Yʉʉ masĩã: Mesías, ãpẽrã́ “Cristo” jĩĩgʉ̃́, atigʉdaqui. Cʉ̃ʉ̃ atigʉ, marĩrẽ niipetirere wedegʉdaqui, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Yʉʉ mʉʉmena wedesegʉ cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cʉ̃́ã teero jĩĩ wedeseritabe, ʉ̃sã jeawʉ. Ʉ̃sã Jesús numiṍmena wedeseri ĩñarã, ĩñamanijõãwʉ̃. Sĩcʉ̃nopera cʉ̃ʉ̃rẽ “¿ñeenórẽ boogó tiiárĩ?” o “¿ñeenó maquẽrẽ wedesera tiiárĩ?” jĩĩ sãĩñáriwʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Coope coo oco waarírʉre toopʉ́ra duudʉpójã, macãpʉ wáajõãwõ. Toopʉ́re jeago, basocáre wedeyigo: ");
INSERT INTO tue_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jõõpʉ sĩcʉ̃ ʉ̃mʉ niiãwĩ. Cʉ̃ʉ̃ yʉʉ tiiríguere wedepetijããwĩ. Mʉ́ãcã ĩñarã atiya. Mʉ́ã wãcũrĩ, ¿cʉ̃ʉ̃ Cristo Cõãmacʉ̃ beserigʉra niigari? jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Coo teeré wederi tʉorá, cʉ̃́ã Jesús pʉtopʉ ĩñarã jeawa. ");
INSERT INTO tue_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cʉ̃́ã jearitabe, ʉ̃sã Jesuré yaadutimiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Cʉ̃ʉ̃ ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ yaaré cʉoa. Mʉ́ã masĩricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Teero tiirá, ʉ̃sã cʉ̃ʉ̃ buerá cãmerĩ́ sãĩñáwʉ̃: —¿Apetó tiirá, ãpẽrã́ cʉ̃ʉ̃rẽ yaaré néeati, ecatóaayirite? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús ʉ̃sãrẽ jĩĩwĩ: —Yʉʉre ticodiocorigʉ booróbiro tiirí, teero biiri cʉ̃ʉ̃ dutirére tiipetíri, yʉʉre yaaré tiiróbiro niiã. ");
INSERT INTO tue_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mʉ́ã biiro jĩĩ wãcũã: “Bapari muĩpũrã dʉsaa oterigue dʉcacʉtiadaro”. Teero jĩĩrõno tiirá, jõõpe ĩñacoya. Jõõ atirá oterigue butiré tiiróbiro niiĩya padeoádara. ");
INSERT INTO tue_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oterigue dʉcare seenéõcũgʉ̃ cʉ̃ʉ̃ paderé wapa wapatínogʉ̃dʉ niiĩ. Catiré petihérere bʉará cʉ̃ʉ̃ye dʉca seenéõcũre tiiróbiro niiĩya. Cʉ̃́ã padeorí ĩñarã, oterigʉ seenéõcũrigʉmena ʉseniãdacua. ");
INSERT INTO tue_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ate diamacʉ̃́ jĩĩré niiã: “Sĩcʉ̃ otequi; ãpĩ seenéõcũqui”. ");
INSERT INTO tue_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yʉʉ mʉ́ãrẽ seenéõcũrã tiiróbiro ticocoa ãpẽrã́ oteriropʉre. Ãpẽrã́ oterira tiiróbiro yée maquẽrẽ buesʉgueyira; mʉ́ãpe seenéõcũrã tiiróbiro basocá yʉʉre padeorí ĩñaãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria dita macõ cooya macã macãrãrẽ “jõõ niiãrigʉ niipetire yʉʉ tiiríguere wedepetijããwĩ” jĩĩ wedeyigo. Teeré tʉorá, paʉ cʉ̃ʉ̃rẽ padeoríra niiwã. ");
INSERT INTO tue_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Teero tiirá, Jesús pʉtopʉ jea, cʉ̃ʉ̃rẽ cʉ̃́ã pʉtopʉ pʉtʉádutiwa. Ʉ̃sã cʉ̃́ã pʉtopʉre pʉabʉ́reco pʉtʉácũmuwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ãpẽrã́ paʉ Jesús wederére tʉorá, padeoríra niiwã. ");
INSERT INTO tue_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tiimacã macãrã coore jĩĩwã: —Ʉ̃sã mʉʉ wedeariguemena dícʉ cʉ̃ʉ̃rẽ padeoría. Ʉ̃sã basiro cʉ̃ʉ̃rẽ tʉoáwʉ̃. Teero tiirá, cʉ̃ʉ̃rẽ padeóa. Mecʉ̃tígã ʉ̃sã ate diamacʉ̃́ maquẽrẽ masĩã: Cʉ̃ʉ̃rã́ atibʉ́reco macãrãrẽ netõnégʉ̃ niiĩ, jĩĩ wedesewa. ");
INSERT INTO tue_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉabʉ́reco Samaria dita macãrãmena niiãri siro, ʉ̃sã Jesuména Galilea ditapʉ wáawʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Too sʉgueropʉ Jesús ʉ̃sãrẽ biiro jĩĩwĩ: “Profetare cʉ̃ʉ̃ya dita macãrã padeorícua”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea dita macãrãcã Jerusalénpʉ Pascua ĩñarã jearira niiwã. Toopʉ́ niipetire Jesús cʉ̃ʉ̃ tutuaremena tiiẽ́ñoriguere ĩñawã. Teero tiirá, Jesús Galileapʉ jeari, cʉ̃ʉ̃rẽ ãñurõ bocawa. ");
INSERT INTO tue_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús Canápʉ coewí. Caná Galilea ditapʉ niiã. Tiimacãpʉ cʉ̃ʉ̃ too sʉgueropʉ ocoré vino wáari tiiwí. Teebʉrecorire sĩcʉ̃ dutigʉ́ Capernaum macʉ̃ niiwĩ. Cʉ̃ʉ̃ Galilea dita õpʉ̃ doca macʉ̃ niiwĩ. Cʉ̃ʉ̃ macʉ̃ diarecʉtigʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cʉ̃ʉ̃ “Jesús Judeapʉ niiãrigʉ Galileapʉ jeaayigʉ” jĩĩrére tʉogʉ́, Jesús pʉtopʉ jea, jĩĩwĩ: —Yʉʉ macʉ̃rẽ diaré netõnébosagʉ búaatiya. Cʉ̃ʉ̃ diaró pʉtogãpʉ niiãwĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesupé cʉ̃ʉ̃rẽ jĩĩwĩ: —Mʉ́ãjã yʉʉ tutuaremena tiiẽ́ñorere ĩñahẽrã, padeoría, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Cʉ̃ʉ̃pe jĩĩwĩ: —Õpʉ̃, jãmʉ, búawaco, yʉʉ macʉ̃ diaadari sʉguero, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesupé cʉ̃ʉ̃rẽ jĩĩwĩ: —Mʉʉya wiipʉ pʉtʉawagʉa. Mʉʉ macʉ̃ catiqui, jĩĩwĩ. Jesús teero jĩĩrére padeogʉ́, cʉ̃ʉ̃ya wiipʉ pʉtʉawawi. ");
INSERT INTO tue_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Búawa, cʉ̃ʉ̃ya wiipʉ jeagʉdʉ tiirí, cʉ̃ʉ̃rẽ padecotera maapʉ bocayira. —Mʉʉ macʉ̃ catiawĩ, jĩĩ wedeyira. ");
INSERT INTO tue_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Deero biiri cʉ̃ʉ̃ ãñunʉcããrĩ? jĩĩ sãĩñáyigʉ cʉ̃ʉ̃pe. —Ñamica coeritó siro wioré tatijṍããwʉ̃, jĩĩyira cʉ̃́ãpeja. ");
INSERT INTO tue_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“Jesús yʉʉre tii horara ‘mʉʉ macʉ̃ catiqui’ jĩĩãwĩ”, jĩĩ wãcũgʉ̃, Jesuré padeoyígʉ. Teero tiirá, niipetira cʉ̃ʉ̃ya wii macãrãcã Jesuré padeoyíra. ");
INSERT INTO tue_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Teeména Jesús Judeapʉ niiãrigʉ Galileapʉ jeari siro, pʉarĩ́ cʉ̃ʉ̃ tutuaremena tiiẽ́ñore wáaro tiiwʉ́ sáa. ");
INSERT INTO tue_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Too síro Jesús Jerusalénpʉ judíoa bosebʉreco ĩñagʉ̃ cãmepʉtʉ́awawi sũcã. ");
INSERT INTO tue_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalénpʉ sããwaro sicasope Oveja wãmecʉtiri sope niiwʉ̃. Tiisopepʉto cusaáda jĩĩrã quẽnorítaro niiwʉ̃. Tiitaro hebreoayemena Betesda wãmecʉtiwʉ. Tiitaro wesapʉre sicamoquẽñe tatiari biayá maniré tatiari niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Teetatiaripʉre paʉ basocá yepapʉ cõãwã́. Cʉ̃́ã diarecʉtira, ĩñahẽrã, opayuriri wáara, bʉʉré ñicãrĩ cʉorá niiwã. Tiitaropʉre wãcũña manirṍ sĩquẽtaberi ángele diijeáyigʉ. Diijeá, ocoré cãmeñarĩ tiiyígʉ. Cʉ̃ʉ̃ teero tiiári siro, tiitaropʉ ñaañuãsʉguegʉ netõnénoyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Toopʉ́re sĩcʉ̃ diarecʉtigʉ niiwĩ. Treinta y ocho cʉ̃marĩ wáayiro, cʉ̃ʉ̃ diaré bʉarí siro. ");
INSERT INTO tue_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús tiitaro pʉtopʉ netõwágʉ cʉ̃ʉ̃rẽ ĩñawĩ. Cʉ̃ʉ̃ toopʉ́ yoari cõãrére masĩwĩ. Teero tiigʉ́, cʉ̃ʉ̃rẽ sãĩñáwĩ: —¿Mʉʉ netõnérĩ boogári? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Cʉ̃ʉ̃pe yʉʉwi: —Yʉʉre tiiápugʉno maniĩ. Oco cãmeñarĩcõrõ yʉʉ tiitaropʉ ñaañuãgʉ̃dʉ tiirí, ãpĩ yʉʉ sʉguero ñaañuãsʉguerucui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesupé jĩĩwĩ: —Wʉ̃mʉnʉcãña. Mʉʉ cõãrṍrẽ néeapa, wáagʉa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Máata netõnénoãrigʉpʉ pʉtʉáwi. Cʉ̃ʉ̃ cõãrṍrẽ néeapa, wáanʉcãwĩ. Cʉ̃ʉ̃rẽ netõnéri bʉreco sábado niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Teero tiirá, judíoare dutirápeja netõnénoãrigʉre jĩĩyira: —¿Deero tiigʉ́ mʉʉ mecʉ̃ã marĩrẽ yeerisãdutiri bʉreco niipacari, mʉʉ cõãrṍrẽ apawai? Marĩrẽ teero tiidutíria, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cʉ̃ʉ̃pe yʉʉyigʉ: —Yʉʉre netõnéãrigʉ “mʉʉ cõãrṍrẽ néeapa, wáagʉa” jĩĩãwĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Cʉ̃́ãpeja sãĩñáyira sũcã: —¿Noã niiãrĩ mʉʉrẽ “mʉʉ cõãrṍrẽ néeapa, wáagʉa” jĩĩãrigʉ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cʉ̃ʉ̃pe masĩriyigʉ. Jesús paʉ basocá watoapʉ netõwáwi. ");
INSERT INTO tue_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Too síro Jesús Cõãmacʉ̃wiipʉ cʉ̃ʉ̃rẽ bʉajeágʉ, jĩĩwĩ: —Ãñurõ tiiwá. Mʉʉ netõnénoãrigʉpʉ niiã. Nemorṍ ñañarõ netõrĩ́ jĩĩgʉ̃, ñañaré tiinemógʉ̃ mee tiiwá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Cʉ̃ʉ̃pe judíoare dutiráre wedegʉ wáarigʉ niiwĩ. —Yʉʉre netõnéãrigʉ Jesús niiãwĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesús sábado niirĩ teero tiiré wapa judíoare dutirápeja cʉ̃ʉ̃rẽ ĩñatutinʉcãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesupéja cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ Pacʉ paderucujãqui; yʉʉcã paderucujãã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, nemorṍrã cʉ̃ʉ̃rẽ sĩãdʉgáyira. Cʉ̃́ã tʉgueñarĩ, cʉ̃ʉ̃ judíoa yeerisãri bʉreco tiidutírere peotígʉ tiirígʉ niiwĩ. Teero biiri cʉ̃ʉ̃ Cõãmacʉ̃rẽ “yʉʉ Pacʉ niiĩ” jĩĩrémena nemorṍ cúayira. Teero jĩĩgʉ̃, “yʉʉ Cõãmacʉ̃mena sĩcãrĩbíro niiã” jĩĩdʉgagʉ tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Teero tiigʉ́, Jesús cʉ̃́ãrẽ yʉʉwi: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉ Cõãmacʉ̃ macʉ̃ yʉʉ basiro yʉʉ booró tiiría. Yʉʉ Pacʉ tiirére ĩña, tee dícʉre tiia. Biiro niiã: Niipetire yʉʉ Pacʉ tiirénorẽ yʉʉcã tiia. ");
INSERT INTO tue_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉʉ Pacʉ yʉʉre maĩgʉ̃́, niipetire cʉ̃ʉ̃ tiirénorẽ yʉʉre ẽñoĩ. Yʉʉre ẽñorígue nemorṍ too síro yʉʉre ẽñogʉ̃́daqui. Tee cʉ̃ʉ̃ ẽñoã́darere yʉʉ tiiẽ́ñorĩ, mʉ́ã ĩñamanijõããdacu. ");
INSERT INTO tue_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉʉ Pacʉ basocá diarirare masõ, catiré ticorobirora yʉʉcã cʉ̃ʉ̃ macʉ̃ niijĩgʉ̃, catirére yʉʉ ticodʉgara dícʉre ticoa. ");
INSERT INTO tue_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Basocáre wapa tiiádari bʉreco jeari, yʉʉ Pacʉ wapa tiiríqui. Yʉʉre basocá tiirére besedutitoawi, ");
INSERT INTO tue_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","niipetira yʉʉre padeoáro jĩĩgʉ̃. Cʉ̃ʉ̃rẽ padeoróbirora yʉʉre padeoáro. Yʉʉre padeohégʉno yʉʉ Pacʉcãrẽ padeoríqui. Cʉ̃ʉ̃rã́ yʉʉre ticodiocowi. ");
INSERT INTO tue_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉ jĩĩrére tʉogʉ́no, teero biiri yʉʉre ticodiocorigʉre padeogʉ́no catiré petihére cʉoquí. Cʉ̃ʉ̃ ñañarõ tiinóriqui. Cʉ̃ʉ̃ pecamepʉ wáaboarigʉ catiré petihére cʉotóai. ");
INSERT INTO tue_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Basocá diarira tiiróbiro niirã́ yʉʉ Cõãmacʉ̃ macʉ̃ wedeserere tʉoádacua. Cʉ̃́ã tʉorítono jeaadaro tiia; jeatoaa mée. Yʉʉ wedeserere yʉʉráno catirucuadacua. ");
INSERT INTO tue_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yʉʉ Pacʉra basocáre catiré petihére ticomasĩĩ. Cʉ̃ʉ̃rã́ basocáre catiré petihére ticomasĩrere yʉʉre ticoi. ");
INSERT INTO tue_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Basocáre wapa tiiádari bʉreco jeari, yʉʉ basocáre wapa tiigʉ́dacu. Yʉʉ niipetira sõwʉ̃ niirĩ, yʉʉ Pacʉ yʉʉre teero tiidutíwi. ");
INSERT INTO tue_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mʉ́ã teeré tʉorá, tʉomanírijãña. Niipetira masãcoperipʉ niirã́ yʉʉ wedeseri tʉoádacua. Cʉ̃́ã tʉoríto jeaadaro tiia. ");
INSERT INTO tue_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yʉʉ wedeseri tʉorá, masãcoperipʉ niimiãrira witiatiadacua. Ãñurõ tiirécʉtirira masã, catirucuadacua. Ñañaré tiirírapeja masã, ñañarõ tiinóãdacua. ");
INSERT INTO tue_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yʉʉ basocá tiirére ĩñagʉ̃, “ñañaniã” o “ãñuniã” jĩĩmasĩã yʉʉ Pacʉ dutirobirora. Yʉʉ basiro apeyenó tiiría. Yʉʉ booró tiidʉgária; yʉʉ Pacʉ yʉʉre ticodiocorigʉ booróbiro tiia. Tee tiiró, yʉʉ jĩĩré diamacʉ̃́ niiã. ");
INSERT INTO tue_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yʉʉ basiro yʉʉ niirecʉtirere wederi, “mʉʉ wederé wapamaníã” jĩĩbocu mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ãpĩ niiĩ yʉʉ niirecʉtirere wedegʉ́. Cʉ̃ʉ̃rã́ yʉʉ Pacʉ niiĩ. Yʉʉ masĩã: Yʉʉ niirecʉtirere wedegʉ, diamacʉ̃́rã wedei. ");
INSERT INTO tue_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉ́ã Juan wãmeõtiri basocʉpʉre sãĩñádutira ticocorira niiwʉ̃. Cʉ̃ʉ̃cã yʉʉ niirecʉtirere diamacʉ̃́ wedegʉ́ niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Basocá yʉʉ niirecʉtirere wedeserere ãmaãgʉ̃ mee tiia. Mʉ́ãrẽ netõã́rõ jĩĩgʉ̃, Juan wederiguere mʉ́ãrẽ wãcũrĩ tiia. ");
INSERT INTO tue_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan sĩãwócoriga tiiróbiro niiwĩ. Sĩãwócoriga ãñurõ jʉ̃ʉ̃boeropʉ basocá neãcua. Mʉ́ãcã jeawʉ, cʉ̃ʉ̃ wederi tʉorá. Tʉo, yoari mee ʉseniwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉʉ tiiré Juan wederigue nemorṍ yʉʉ niirecʉtirere ẽñoã. Yʉʉ tiiré yʉʉ Pacʉ tiidutírera niiã. Teero tiirémena “yʉʉ Pacʉ diamacʉ̃́rã yʉʉre ticodiocowi” jĩĩrére ẽñoã. ");
INSERT INTO tue_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉʉ Pacʉ yʉʉre ticodiocorigʉcã yʉʉ niirecʉtirere wedei. Mʉ́ã cʉ̃ʉ̃ wederére tʉoría; cʉ̃ʉ̃ baurécãrẽ ĩñaria. ");
INSERT INTO tue_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cʉ̃ʉ̃ ticodiocorigʉre padeoría. Teero tiiró, cʉ̃ʉ̃ wederé mʉ́ãrẽ sããria. ");
INSERT INTO tue_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mʉ́ã Cõãmacʉ̃ye queti jóaripũrẽ quioníremena buea, “toopʉ́ catiré petihére bʉaádacu” jĩĩ wãcũrã. Mʉ́ã tiipũ maquẽrẽ buera, yée maquẽrẽna buemiã. ");
INSERT INTO tue_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Teero wãcũpacara, yʉʉpere padeonʉnʉ́sedʉgaria. Yʉʉre padeonʉnʉ́sera dícʉ catiré petihére cʉoádacua. ");
INSERT INTO tue_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Basocá yʉʉre ãñurõ wedeserere ãmaãgʉ̃ mee tiia. ");
INSERT INTO tue_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yʉʉ mʉ́ãrẽ ĩñamasĩã. Mʉ́ã Cõãmacʉ̃rẽ maĩría. ");
INSERT INTO tue_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉʉ Pacʉ wãmemena yʉʉ atipacari, mʉ́ã yʉʉre ãñurõ bocaria. Ãpĩ cʉ̃ʉ̃ basiro cʉ̃ʉ̃ wãmemena atigʉ́pere mʉ́ã ãñurõ bocabocu. ");
INSERT INTO tue_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mʉ́ã basirora mʉ́ã tiirére “ãñuã” jĩĩrĩ booa. Cõãmacʉ̃ sĩcʉ̃ niigʉ̃́ mʉ́ãrẽ “ãñuã” jĩĩrépere ãmaãria. Teero tiirá, ¿deero tii mʉ́ã yʉʉre padeobóataʉ? ");
INSERT INTO tue_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉ́ã yʉʉre “Cõãmacʉ̃pʉre marĩrẽ wedesãgʉ̃daqui” jĩĩ wãcũrijãña. “Moisés jóariguere tiirá, Cõãmacʉ̃mena ãñurõ niiãdacu”, jĩĩ wãcũmiã mʉ́ã. Moiséra mʉ́ãrẽ wedesãqui. ");
INSERT INTO tue_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés yée maquẽrẽ jóarigʉ niiwĩ. Teero tiirá, cʉ̃ʉ̃ jóariguere padeorá yʉʉcãrẽ padeobócu. ");
INSERT INTO tue_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Cʉ̃ʉ̃ jóariguere padeohérapeja ¿deero tii mʉ́ã yʉʉ wederére padeobóataʉ? Padeorídojãã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Too síro Jesuména Galileataro apeniñapʉ́ tĩãwawʉ. Tiitaro wãmecʉtia Tiberias. ");
INSERT INTO tue_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Basocá cʉ̃ʉ̃ tiiẽ́ñoremena diarecʉtirare netõnérĩ ĩñajĩrã, paʉ cʉ̃ʉ̃rẽ nʉnʉwã́. ");
INSERT INTO tue_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ʉ̃sã apeniñapʉ́ tĩãjeara, ʉ̃tãgʉ̃pʉ́ mʉãwa, duiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Teebʉrecorire Pascua judíoa bosebʉreco wáaadaro péerogã dʉsawʉ́. ");
INSERT INTO tue_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús paʉ basocá cʉ̃ʉ̃rẽ nʉnʉrĩ́ ĩñagʉ̃, Felipere jĩĩwĩ: —¿Noopʉ́ marĩ yaaré sãĩrã́ wáaadari cʉ̃́ã paʉre ecaádara? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felipere ¿deero yʉʉgʉdari? jĩĩgʉ̃, teero sãĩñáwĩ. Jesupé cʉ̃ʉ̃ tiiádarere masĩtoarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe cʉ̃ʉ̃rẽ yʉʉwi: —Ocho muĩpũrã pade wapatáremena marĩ pã sãĩ, pʉatáco, batori, jeatuaricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ʉ̃sã menamacʉ̃ Andrés (Simón Pedro baipéja) Jesuré jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ãnorẽ́ sĩcʉ̃ wĩmagʉ̃ niiĩ. Cʉ̃ʉ̃ sicamoquẽñepa pã cebadamena tiiárigue cʉoi. Teero biiri wai pʉarã́ cʉoi. Ate yaaré ãniã paʉre jeatuaricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús ʉ̃sãrẽ jĩĩwĩ: —Basocáre duidutiya, jĩĩwĩ. Toopʉ́re táa pee niiwʉ̃. Teero tiirá, niipetira duiwa. Cinco mil ʉ̃mʉã niiwã. ");
INSERT INTO tue_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Too síro Jesús pãrẽ née, Cõãmacʉ̃rẽ ʉsenire ticowi. Too síro duiráre batodutiwi. Waimenacãrẽ teerora tiiwí. Ʉ̃sã cʉ̃́ã yaadʉgarocõrõ batowʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cʉ̃́ã yaa, yapiari siro, Jesús ʉ̃sãrẽ jĩĩwĩ: —Cʉ̃́ã yaadʉarere cõõrĩ́ jĩĩrã, teeré seesã́ña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sicamoquẽñepa pã niimiãrigue ʉ̃sã yaadʉaariguere seesã́rĩ, doce piseri dadodʉpówʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Basocá Jesús cʉ̃ʉ̃ tutuaremena tee tiiẽ́ñorĩ ĩñarã, jĩĩwã: —“Profeta atigʉdʉ niiãyigʉ” cʉ̃́ã jĩĩrigʉ ãnirã́ niiĩ. Diamacʉ̃́rã niiyu, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cʉ̃́ã cʉ̃ʉ̃rẽ bayiró tutuaremena néewa, õpʉ̃ sõnecodʉgamiwã. Cʉ̃ʉ̃peja cʉ̃́ã teero tiidʉgárere ĩñagʉ̃, sĩcʉ̃rã ʉ̃tãgʉ̃pʉ́ mʉãjõãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Too síro náĩcũmuatiri, ʉ̃sã opataropʉ búawawʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Náĩcũmuãri siro, Jesús bauríwi. Teero tiirá, Capernaumpʉ wáara, dooríwʉpʉ mʉãsã, tiitarore tĩãwanʉcãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ʉ̃sã tĩãwari, wĩno bayiró páapuatiwʉ. Teero wáari, ocoturí paca atiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ʉ̃sã yoaro sicamoquẽñe kilómetros wáaari siro, Jesús ʉ̃sã pʉtopʉ atigʉ, oco sotoápʉ atijõãatiwi. Cʉ̃ʉ̃rẽ ĩñarã, bayiró cuiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Cʉ̃ʉ̃ ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ niiã. Cuirijãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Teero tiirá, ʉseniremena cʉ̃ʉ̃rẽ boca, mʉãsãdutiwʉ. Máata ʉ̃sã wáaropʉ jeasirotiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Apebʉ́recope basocá apeniñapʉ́ pʉtʉáarira ĩñaco, jĩĩyira: “Sicawʉ́ra niimiãwʉ̃; Jesús cʉ̃ʉ̃ buerámena tiiwʉré mʉãsãriawĩ; cʉ̃ʉ̃ buerá dícʉ tĩãwaawã”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Cʉ̃́ã teero jĩĩcõãtori, apeyepáwʉ jeayiro. Teepawʉ ʉ̃sã yaaariropʉ jeayiro. (Ʉ̃sã toopʉ́ yaawʉ, Jesús cʉ̃ʉ̃ Pacʉre ʉsenire ticoari siro.) Tee Tiberias wãmecʉtiri macã maquẽpawʉ niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesús, teero biiri ʉ̃sã cʉ̃ʉ̃ buerá manirĩ́ ĩñarã, basocá teepawʉpʉ mʉãsã, Capernaumpʉ Jesuré ãmaãrã atirira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cʉ̃́ã atiniñapʉ́ tĩãjeara, Jesuré bʉajeára, cʉ̃ʉ̃rẽ sãĩñáwã: —Basocáre buegʉ́, ¿deero biiri mʉʉ tĩãjeaarĩ ãnopʉ́re? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesupé yʉʉwi: —Yʉʉ mʉ́ãrẽ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã pã yaa, yapiarigue wapa yʉʉre ãmaãã. Yʉʉ tutuaremena tiiẽ́ñoriguepere mʉ́ã tʉomasĩ́ria. Teeré tʉomasĩ́rãpeja, teewapa yʉʉre ãmaãboajĩyu. ");
INSERT INTO tue_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yaarére bayiró booríjãrõ booa; yaaré petijṍãcu. Teero tiiróno tiirá, yaaré catiré petihére ticorépere ãmaãrõ booa. Cõãmacʉ̃ yʉʉ Pacʉ yʉʉre cʉ̃ʉ̃ ticodiocorigʉ niirére mʉ́ãrẽ ẽñotóaawĩ. Teero tiigʉ́, yʉʉ niipetira sõwʉ̃ tee yaaré catiré petihére mʉ́ãrẽ ticogʉda, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teero tiirá, cʉ̃́ãpe sãĩñáwã: —¿Deero tiiádari ʉ̃sã, Cõãmacʉ̃ tiidutírere ãñurõ tiiádara? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Cʉ̃ʉ̃peja yʉʉwi: —Cõãmacʉ̃ mʉ́ãrẽ tiidutíre biiro niiã: Yʉʉre cʉ̃ʉ̃ ticodiocorigʉre padeodutíi, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Teero tiirá, cʉ̃́ãpeja sãĩñáwã sũcã: —¿Ñeenómena ẽñogʉ̃́dari, ʉ̃sã mʉʉrẽ padeorí? ¿Deero bauré tiigʉ́dari? ");
INSERT INTO tue_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Marĩ ñecʉ̃sʉ̃mʉã yucʉ manirṍpʉ maná wãmecʉtirere yaayira. Cõãmacʉ̃ye queti jóaripũpʉ ate jóanoã: “Cʉ̃ʉ̃ cʉ̃́ãrẽ yaarigue ʉ̃mʉã́se maquẽrẽ ticoyigʉ”, jĩĩ jóanoã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Teero tiigʉ́, Jesupé jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Ʉ̃mʉã́se maquẽ yaariguere Moisés mee ticoyigʉ; yʉʉ Pacʉpe basocáre yaaré ʉ̃mʉã́se maquẽ petire ticoi. ");
INSERT INTO tue_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cʉ̃ʉ̃ ticoré ʉ̃mʉã́sepʉ diiátire niiã. Basocáre catiré petihére ticoa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Õpʉ̃, tee yaarére ʉ̃sãrẽ ticorucujãña, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús jĩĩwĩ: —Yʉʉrá niiã yaaré catiré petihére ticogʉ́. Yʉʉre padeonʉnʉ́serano jʉabóara tiiróbiro niinemoricua; oco sĩnidʉgára tiiróbiro niinemoricua. ");
INSERT INTO tue_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉ́ãrẽ ateré jĩĩtoawʉ: Mʉ́ã yʉʉre ĩñapacara, padeoría. ");
INSERT INTO tue_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Niipetira yʉʉ Pacʉ yʉʉre ticorá yʉʉre padeonʉnʉ́seadacua. Yʉʉre padeoráre ñeerijã tiirícu. ");
INSERT INTO tue_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yʉʉ ʉ̃mʉã́sepʉ niirigʉ yʉʉ booré tiigʉ́ mee atiwʉ; yʉʉre ticodiocorigʉ boorépere tiigʉ́ atiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yʉʉ Pacʉ biiro booi: Yʉʉre ticorirare tiidióri booríi; cʉ̃́ãrẽ pecamepʉ wáari booríi. Atibʉ́reco petirí, yʉʉ cʉ̃́ãrẽ masõrĩ booi. ");
INSERT INTO tue_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yʉʉ Pacʉ biiro booi: Niipetira yʉʉre ĩñarã́, yʉʉre padeorá catiré petihére cʉorí booi. Yʉʉ atibʉ́reco petirí, cʉ̃́ãrẽ masõgʉ̃dacu, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judíoare dutirápeja Jesuré wedepatinʉcãwã. “Yʉʉrá niiã yaaré ʉ̃mʉã́sepʉ diiátirigʉ” jĩĩrĩ tʉorá, ñañarõ wedesenʉcãwã. ");
INSERT INTO tue_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Ãni teero wedesegʉ Jesús José macʉ̃ mee niiĩ? Cʉ̃ʉ̃ pacʉ, cʉ̃ʉ̃ pacore marĩ masĩã. ¿Deero tiigʉ́ cʉ̃ʉ̃ “ʉ̃mʉã́sepʉ niirigʉ diiátiwʉ” jĩĩĩ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Wedepatirijãña. ");
INSERT INTO tue_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sĩcʉ̃no cʉ̃ʉ̃ booró yʉʉre padeonʉnʉ́semasĩriqui; yʉʉ Pacʉ yʉʉre ticodiocorigʉ yʉʉre ticoráno dícʉ padeonʉnʉ́secua. Atibʉ́reco petirí, yʉʉ cʉ̃́ãrẽ masõgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cõãmacʉ̃ye queti jóaripũpʉ ate jóanoã: “Cõãmacʉ̃ niipetirare bue, tʉomasĩ́rĩ tiigʉ́daqui”, jĩĩ jóanoã. Teero tiirá, niipetira yʉʉ Pacʉ wederére tʉo, tʉomasĩ́rã, yʉʉre padeonʉnʉ́seya. ");
INSERT INTO tue_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Sĩcʉ̃no yʉʉ Pacʉre ĩñarii. Yʉʉ Cõãmacʉ̃mena niirigʉ niiã. Teero tiigʉ́, yʉʉ dícʉ cʉ̃ʉ̃rẽ ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉre padeoráno catirucuadacua. ");
INSERT INTO tue_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉʉrá niiã yaaré catiré petihére ticogʉ́. ");
INSERT INTO tue_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉ́ã ñecʉ̃sʉ̃mʉã yucʉ manirṍpʉ maná wãmecʉtirere yaayira. Teeré yaapacara, diajõãyira. ");
INSERT INTO tue_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉʉpe yaaré ʉ̃mʉã́sepʉ diiátirepere wedesea. Teeré yaaráno diaricua. ");
INSERT INTO tue_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Tee yaaré catiré petihére ticoré ʉ̃mʉã́sepʉ diiátirigue yʉʉrá niiã. Teeré yaaráno catirucujããdacua. Yʉʉ yaaré ticoré yáa õpʉ̃ʉ̃ niiã. Yáa õpʉ̃ʉ̃rẽ atibʉ́recopʉ niirã́ catirucuaro jĩĩgʉ̃, ticogʉda, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judíoare dutirápeja cãmerĩ́ wedesewa: —¿Deero tii marĩrẽ ãni cʉ̃ʉ̃ya õpʉ̃ʉ̃rẽ yaadutibogari? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Teero tiigʉ́, Jesupéja cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã yʉʉ niipetira sõwʉ̃ya õpʉ̃ʉ̃rẽ yaaripacara, yée díire sĩnirípacara, catiré petihére cʉorícu. ");
INSERT INTO tue_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yáa õpʉ̃ʉ̃rẽ yaagʉ́nope, yée díire sĩnigʉ̃́nope catiré petihére cʉoquí. Atibʉ́reco petirí, cʉ̃ʉ̃rẽ masõgʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yáa õpʉ̃ʉ̃ yaaré peti niiã; yée díi sĩniré peti niiã. ");
INSERT INTO tue_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yáa õpʉ̃ʉ̃rẽ yaaráno, yée díire sĩnirã́no yʉʉmena niiĩya; yʉʉcã cʉ̃́ãmena niiã. ");
INSERT INTO tue_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉʉ Pacʉ yʉʉre ticodiocorigʉ catii. Cʉ̃ʉ̃ catirémena yʉʉ catia. Teero tiiróbiro yáa õpʉ̃ʉ̃ yaaráno yʉʉ catirémena catiadacua. ");
INSERT INTO tue_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yʉʉrá yaaré ʉ̃mʉã́sepʉ diiátiriguere wedesea. Maná mʉ́ã ñecʉ̃sʉ̃mʉã yaarigue tiiróbiro niiria. Cʉ̃́ã teeré yaapacara, diajõãyira. Yáa õpʉ̃ʉ̃rẽ yaaránopeja catirucujããdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús cʉ̃́ãrẽ teeré Capernaumpʉ judíoa neãrí wiipʉ buewi. ");
INSERT INTO tue_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Paʉ cʉ̃ʉ̃rẽ nʉnʉmíãrira cʉ̃ʉ̃ buerére tʉorá, cãmerĩ́ jĩĩwã: —Cʉ̃ʉ̃ wederé wisiónetõjõãã. Tʉomasĩ́ña maniã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús cʉ̃́ã wedepatirere masĩgʉ̃, jĩĩwĩ: —¿Mʉ́ã yʉʉ wederére ñañarõ tʉgueñagari? ");
INSERT INTO tue_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Deero wáabogari yʉʉ niipetira sõwʉ̃ too sʉgueropʉ yʉʉ niiriropʉ mʉãwari sũcã? Mʉ́ã teeré ĩñarã, ¿deero tʉgueñabogari? ");
INSERT INTO tue_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu Santo catirére ticoi. Marĩye õpʉ̃ʉ̃rĩ marĩrẽ catiré ticoria. Yʉʉ yaaré, sĩniré maquẽrẽ wedegʉ, popeapʉ yeeripũna maquẽrẽ wedegʉ tiia. Yʉʉ wederére padeoráno catirucujããdacua. ");
INSERT INTO tue_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ãpẽrã́ mʉ́ã menamacãrã yʉʉ wedepacari, yʉʉre padeoríya ména, jĩĩwĩ. Jesús cʉ̃ʉ̃rẽ padeohérare sicatopʉra masĩtoarigʉ niiwĩ. Teero biiri too síropʉ cʉ̃ʉ̃rẽ ĩñatutirapʉre wedesãgʉ̃dʉcãrẽ masĩtoarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Cʉ̃ʉ̃ jĩĩnemowĩ: —Teero tiigʉ́, meepʉ mʉ́ãrẽ wedemiãwʉ̃: “Sĩcʉ̃no cʉ̃ʉ̃ booró yʉʉre padeonʉnʉ́semasĩriqui; yʉʉ Pacʉ yʉʉre ticoráno dícʉ padeonʉnʉ́secua”, jĩĩãwʉ̃, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tiibʉrecomena paʉ cʉ̃ʉ̃rẽ nʉnʉmíãrira cʉ̃ʉ̃rẽ bapacʉtidujãwã. ");
INSERT INTO tue_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Cʉ̃́ã teero tiirí ĩñagʉ̃, Jesús ʉ̃sã cʉ̃ʉ̃ bueráre sãĩñáwĩ: —¿Mʉ́ãcã yʉʉre cõãjõãdʉgai? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedropeja cʉ̃ʉ̃rẽ yʉʉwi: —Ʉ̃sã Õpʉ̃, ¿noãpére nʉnʉbógari? Mʉʉ wedesere catiré petihére ticoa. ");
INSERT INTO tue_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ʉ̃sã mʉʉrẽ padeotóaa. Ʉ̃sã masĩã: Mʉʉ Cõãmacʉ̃ ticodiocorigʉ, ñañaré manigʉ̃́ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesupé ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ mʉ́ã docere besewʉ. Yʉʉ teero tiirí siro niipacari, sĩcʉ̃ mʉ́ã menamacʉ̃ wãtĩyagʉ niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús teero jĩĩgʉ̃, Judas, Simón Iscariote macʉ̃rẽ jĩĩgʉ̃ tiiwí. Judas ʉ̃sã menamacʉ̃ niimiwĩ. Teero niipacʉ, too síropʉre Jesuré wedesãgʉ̃dʉ niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Too síro Jesús Galileapʉ ĩñacãmesãwĩ. Judeapʉre ĩñacãmesãdʉgariwi. Toopʉ́re Judíoa dutirá cʉ̃ʉ̃rẽ ãmaãyira, sĩãdʉgára. ");
INSERT INTO tue_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judíoa bosebʉreco ʉ̃sã wiserígã tii, niiãdari bosebʉreco jeaadaro tiiwʉ́. ");
INSERT INTO tue_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Teero tiirá, Jesús baira cʉ̃ʉ̃rẽ jĩĩwã: —Ãnopʉ́re pʉtʉárijãña. Mʉʉ buerére tʉonʉnʉ́sera toopʉ́ niirã́cã mʉʉ tutuaremena tiiẽ́ñorere ĩñaãrõ jĩĩgʉ̃, Judeapʉ bosebʉrecore ĩñagʉ̃ wáaya. ");
INSERT INTO tue_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Basocá mʉʉrẽ masĩãrõ jĩĩgʉ̃, yayióropʉ tiiẽ́ñorijãrõ booa. Mʉʉ tiirére niipetira ĩñacoropʉ tiiẽ́ñogʉ̃ wáaya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cʉ̃ʉ̃ bairapʉra cʉ̃ʉ̃rẽ padeoríwa. ");
INSERT INTO tue_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ toopʉ́ wáaadaro jearia ména. Mʉ́ãpeja mʉ́ã booró wáamasĩã. ");
INSERT INTO tue_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Atibʉ́reco macãrã ñañaré tiirá mʉ́ãrẽ ĩñatutiriya. Yʉʉ cʉ̃́ã ñañarõ niirecʉtirere wedea. Teero tiirá, yʉʉre ĩñatutiya. ");
INSERT INTO tue_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉ́ã bosebʉrecore ĩñarã wáaya. Yʉʉja wáaria ména. Yʉʉ toopʉ́ wáarito jearia ména, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Teero jĩĩ, Galileapʉra pʉtʉájãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cʉ̃ʉ̃ baira Jerusalénpʉ bosebʉreco ĩñarã wáari siro, Jesucã́ wáawi. Basocá yʉʉre ĩñamasĩrijããrõ jĩĩgʉ̃, noo niigʉ̃́biro wáacãmesãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tii bosebʉrecopʉ judíoare dutirá Jesuré ãmaãyira. “¿Jõõ niirigʉte noopʉ́ niigari?” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Paʉ basocá Jesuyé maquẽrẽ wedeseyira. Ãpẽrã́ “ãñugʉ̃́ niiĩ” jĩĩyira. Ãpẽrãpé “niirii; cʉ̃ʉ̃ tiiẽ́ñoremena basocáre tiiditógʉ tiiquí” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judíoare dutiráre cuira, niipetira tʉocóropʉ “Jesús biiro biii” jĩĩ wedeseriwa. ");
INSERT INTO tue_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bosebʉreco decocʉtirito, Jesús Cõãmacʉ̃wiipʉ sããwa, basocáre buewi. ");
INSERT INTO tue_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Cʉ̃ʉ̃ buerére tʉorá, judíoare dutirá tʉomaníjõãwã. —Ãni bueripacʉ, ¿deero tiigʉ́ nocõrõca masĩĩ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús cʉ̃́ãrẽ yʉʉwi: —Yʉʉ mʉ́ãrẽ bueré yʉʉ wãcũré mee niiã; yʉʉ Pacʉ yʉʉre ticodiocorigʉyepe niiã. ");
INSERT INTO tue_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cõãmacʉ̃ boorére tiidʉgágʉno yʉʉ buerére “diamacʉ̃́rã niiã” jĩĩmasĩqui. “Cõãmacʉ̃ dutiróbiro buei o cʉ̃ʉ̃ wãcũrére buei”, jĩĩ besemasĩqui. ");
INSERT INTO tue_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sĩcʉ̃ cʉ̃ʉ̃ wãcũrémena wedesegʉ “ãñurõ wedesei” jĩĩrĩ tʉodʉgáqui. Cõãmacʉ̃ booró wedesegʉpe “Cõãmacʉ̃ ãñunetõjõãĩ” jĩĩrĩ tʉodʉgáqui. Cʉ̃ʉ̃peja diamacʉ̃́ wedesegʉ niiqui; cʉ̃ʉ̃pʉre ñañaré bʉarícu. ");
INSERT INTO tue_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés Cõãmacʉ̃ dutirére mʉ́ãrẽ ticorigʉ niiwĩ. Teero ticopacari, mʉ́ã sĩcʉ̃no tee dutirére tiiría. ¿Deero tiirá mʉ́ã yʉʉre sĩãdʉgái? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Basocápe cʉ̃ʉ̃rẽ jĩĩwã: —Mʉʉ wãtĩ cʉogʉ́ niijĩgʉ̃, mecʉ̃gʉ̃́ tiia. ¿Noã mʉʉrẽ sĩãdʉgái? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesupé cʉ̃́ãrẽ yʉʉwi: —Mʉ́ã yʉʉ diarecʉtigʉre netõnérĩ ĩñawʉ̃. Yeerisãri bʉrecore yʉʉ teero tiirí, ĩñamanijõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés mʉ́ãrẽ cõnerígʉ yapa macã caseróre widecõã́dutirigʉ niiwĩ. (Cʉ̃ʉ̃ dícʉre teeré dutiririgʉ niiwĩ; mʉ́ã ñecʉ̃sʉ̃mʉãpʉ máata teero tiimʉ́ãatitoarira niiwã.) Mʉ́ã cʉ̃ʉ̃ dutiré tiirá, marĩ yeerisãri bʉreco niipacari, mʉ́ã põnarẽ widecõã́cu. ");
INSERT INTO tue_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mʉ́ã Moisés dutirére niipetiro tiidʉgájĩrã, yeerisãri bʉreco niipacari, widecõã́cu. Mʉ́ã teero tiirá niipacara, ¿deero tiirá yʉʉ yeerisãri bʉreco niirĩ, sĩcʉ̃ niipetiri õpʉ̃ʉ̃rẽ netõnérĩ ĩñarã, yʉʉmena cúai? ");
INSERT INTO tue_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ãñurõ wãcũtoarapʉ, basocá tiirére diamacʉ̃́rã ĩñabeseya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Teero tiirá, sĩquẽrã Jerusalén macãrã jĩĩwã: —Ĩ́nirã niiĩ cʉ̃́ã sĩãdʉgágʉ, ¿teerora? ");
INSERT INTO tue_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Ĩñaña! Niipetira ĩñacoropʉ buegʉ tiii. Cʉ̃́ã cʉ̃ʉ̃rẽ merẽã jĩĩriya. ¿Apetó tiirá, Judíoare Dutirá Peti “ãni Cõãmacʉ̃ beserigʉ Cristo niiĩ” jĩĩ wãcũgari? ");
INSERT INTO tue_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ãni Cõãmacʉ̃ beserigʉ niiriqui. Cʉ̃ʉ̃ya macãrẽ marĩ masĩã. Cõãmacʉ̃ beserigʉpe atiri, cʉ̃ʉ̃ya macãrẽ masĩña manibójĩyu, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Teero tiigʉ́, Jesús Cõãmacʉ̃wiipʉ buegʉ, bayiró bʉsʉrómena wedewi: —Mʉ́ã yʉʉ masãri macãrẽ masĩpacara, yʉʉ atiriro petipʉre masĩria. Yʉʉ booró mee atiwʉ atibʉ́recopʉre. Sĩcʉ̃ diamacʉ̃́ niigʉ̃́ yʉʉre ticodiocowi. Mʉ́ã yʉʉre masĩria. Yʉʉre ticodiocorigʉcãrẽ masĩria. Yʉʉpe cʉ̃ʉ̃rẽ masĩã. Yʉʉ cʉ̃ʉ̃ pʉtopʉ niirigʉ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, cʉ̃ʉ̃rẽ peresuwiipʉ néewadʉgamiwã. Cʉ̃ʉ̃rẽ ñeerí bʉreco jeariwʉ ména. Teero tiirá, sĩcʉ̃no cʉ̃ʉ̃rẽ ñeeriwa. ");
INSERT INTO tue_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cʉ̃́ã teero tiidʉgápacari, paʉ toopʉ́ neãrã́pe cʉ̃ʉ̃rẽ padeowá. Cʉ̃́ãpeja cãmerĩ́ sãĩñáwã: —Too docare Cõãmacʉ̃ beserigʉ Cristo atigʉpeja, ¿ãni tiiẽ́ñore nemorṍ tiigʉ́dari? Tiiríqui, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Basocá wedeserere fariseo basoca tʉoyíra. Teero tiirá, paiaré dutirámena wedeseari siro, Cõãmacʉ̃wii coterí basocare Jesuré ñeedutira ticocorira niimiwã. ");
INSERT INTO tue_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús jĩĩwĩ: —Yʉʉ mʉ́ãmena péero niigʉ̃dacu. Too síro yʉʉre ticodiocorigʉ pʉtopʉ wáagʉdacu. ");
INSERT INTO tue_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉʉre ãmaãnʉnʉsepacara, bʉarícu. Yʉʉ wáaropʉre mʉ́ã wáamasĩricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judíoare dutirá cãmerĩ́ sãĩñáwã: —Ãni “yʉʉre bʉarícu” jĩĩgʉ̃, ¿noopʉ́ wáagʉdari? ¿Marĩya wedera apeyé ditapʉ wáarira pʉtopʉ wáagʉdari? ¿Toopʉ́re judíoa niihẽrãrẽ buecãmesãgʉ̃dari? ");
INSERT INTO tue_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Cʉ̃ʉ̃ “yʉʉre ãmaãnʉnʉsepacara, bʉarícu; yʉʉ wáaropʉre mʉ́ã wáamasĩricu” jĩĩãrigue ¿deero jĩĩdʉgaro tiigári? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tii bosebʉreco niituri bʉreco ʉpʉtí niirí bʉreco niiwʉ̃. Jesús tiibʉrecore wʉ̃mʉnʉcã, bayiró bʉsʉrómena jĩĩwĩ: —Oco sĩnidʉgárano yʉʉ pʉtopʉ sĩnirã́ atiya. ");
INSERT INTO tue_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yʉʉre padeogʉ́ya yeeripũnapʉ oco õmayucorobiro niiãdacu. Tee oco catiré ticoré niiãdacu Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cʉ̃ʉ̃ oco õmayucorere wedesegʉ, Espíritu Santo tiiádare maquẽrẽ wedesegʉ tiiwí. Espíritu Santo Jesuré padeorápʉre too síropʉ jeagʉdʉ tiirígʉ niiwĩ. Jesús dia masãmʉãririgʉ niiwĩ ména. Teero tiigʉ́, Espíritu Santo ticodiocoya manirígʉ niiwĩ ména. ");
INSERT INTO tue_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ãpẽrã́ Jesús wederére tʉorá, biiro jĩĩwã: —Ãnirã́ niiqui profeta, basocá cʉ̃́ã “atigʉdʉ niiãyigʉ” cʉ̃́ã jĩĩrigʉ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ãpẽrã́: —Ãni Cõãmacʉ̃ beserigʉ Cristo niiĩ, jĩĩwã. Ãpẽrãpé: —Cõãmacʉ̃ beserigʉ ¿deero Galilea macʉ̃ niibogari? ");
INSERT INTO tue_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cõãmacʉ̃ beserigʉ David tiiróbiro Belén macʉ̃ niigʉ̃daqui. Cʉ̃ʉ̃ pãrãmí niinʉnʉsegʉpʉ niigʉ̃daqui. Cõãmacʉ̃ye queti jóaripũ teero jĩĩã, ¿teerora? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Basocá Jesuré sĩcãrĩbíro wãcũriwa sáa. Teero tiirá, batajṍãwã. ");
INSERT INTO tue_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ãpẽrã́ cʉ̃ʉ̃rẽ peresuwiipʉ néewadʉgamiwã. Teero tiidʉgápacara, sĩcʉ̃no cʉ̃ʉ̃rẽ ñeeriwa. ");
INSERT INTO tue_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Cõãmacʉ̃wii coterí basoca cãmepʉtʉ́awawa paiaré dutirá, fariseo basoca pʉtopʉ. Jeari, cʉ̃́ãrẽ jĩĩyira: —¿Deero tiirá cʉ̃ʉ̃rẽ néeatiriarĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Cʉ̃́ãpe yʉʉyira: —Sĩcʉ̃no cʉ̃ʉ̃ tiiróbiro ãñurére wedeseri tʉohéra niiãtʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseo basoca cʉ̃́ãrẽ jĩĩyira: —¿Mʉ́ãcãrẽ jĩĩditoarĩ? ");
INSERT INTO tue_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ãñurõ tʉomasĩ́ña: Sĩcʉ̃ Judíoare Dutirá Peti menamacʉ̃, sĩcʉ̃ fariseo basocʉ cʉ̃ʉ̃rẽ padeoríqui. ");
INSERT INTO tue_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Cʉ̃ʉ̃rẽ tʉorá Moisére dutiré cṹũriguere masĩridojãya. Cõãmacʉ̃ cʉ̃́ãrẽ ñañarõ tiigʉ́daqui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo too sʉgueropʉ Jesuré ĩñagʉ̃ jearigʉ cʉ̃́ã menamacʉ̃ niiwĩ. Cʉ̃́ãrẽ biiro wedeyigʉ: ");
INSERT INTO tue_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Sĩcʉ̃rẽ sĩãdutíadari sʉguero, cʉ̃ʉ̃ wedeserere, cʉ̃ʉ̃ tiiáriguere besesʉguero booa. Teero jĩĩã marĩrẽ dutiré, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Cʉ̃́ãpe cʉ̃ʉ̃rẽ jĩĩyira: —¿Mʉʉcã Galilea macʉ̃ niiĩ? Mʉʉ Cõãmacʉ̃ye queti jóaripũrẽ buepetigʉ, ateména pʉtʉágʉdacu: Sĩcʉ̃ profeta Galileapʉ atiriqui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Niipetira basocá Jerusalénpʉ bosebʉreco jeaarira cʉ̃́ãye wiseripʉ coepʉtʉ́awawa. ");
INSERT INTO tue_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesupé Ʉ̃tãgʉ̃́ Olivopʉ wáawi. ");
INSERT INTO tue_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Apebʉ́reco bóeri Cõãmacʉ̃wiipʉ coewí sũcã. Basocá niipetira cʉ̃ʉ̃ pʉtopʉ neãwã. Cʉ̃ʉ̃ jeanuã, cʉ̃́ãrẽ buewi. ");
INSERT INTO tue_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Cʉ̃ʉ̃ bueri, Moisés jóarigue buerá, teero biiri fariseo basoca cʉ̃ʉ̃ pʉtopʉ jeawa. Cʉ̃́ã sĩcõ numiṍ ãpĩ coo manʉ niihẽgʉ̃mena tãmuãrigore néejeawa. Basocá ĩñacoropʉ coore nʉcõwã́. ");
INSERT INTO tue_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesuré jĩĩwã: —Basocáre buegʉ́, atigó coo manʉ niihẽgʉ̃mena ñañaré tiigó tãmuãwõ. ");
INSERT INTO tue_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés teero tiigónorẽ ʉ̃tãperimena déesĩãdutirigʉ niiwĩ. ¿Mʉʉpe deero jĩĩĩ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ teeré sãĩñáwã, ¿deero yʉʉgʉdari? jĩĩrã. “Cʉ̃ʉ̃ merẽã yʉʉri, dutiráre wedesããdacu”, jĩĩ wãcũrira niimiwã. Jesupé munibiá, cʉ̃ʉ̃ya wãmosṹãmena ditapʉ jóanʉcãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cʉ̃́ã cʉ̃ʉ̃rẽ sãĩñáduheri ĩñagʉ̃, wʉ̃mʉnʉcã, cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã watoapʉ niigʉ̃́ sĩcãrĩ ñañaré tiihégʉno ʉ̃tãpe née, coore déesʉguearo, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Too síro munibiá, jóanemowĩ sũcã. ");
INSERT INTO tue_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, wáanʉcãwã. Bʉcʉ peti wáasʉguewi. Cʉ̃ʉ̃ siro ãpĩ bʉcʉ, cʉ̃ʉ̃ siro ãpĩ, cʉ̃ʉ̃ siro ãpĩ wáa, wáapetijõãwã. Jesús sĩcʉ̃rã pʉtʉáwi. Numiṍ toopʉ́ra nucũwõ ména. ");
INSERT INTO tue_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Cʉ̃ʉ̃ wʉ̃mʉnʉcã, coore jĩĩwĩ: —¿Mʉʉrẽ wedesãmiãrira wáapetijõããrĩ? ¿Sĩcʉ̃no mʉʉ ñañaré tiiré wapa déeriarĩ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Sĩcʉ̃nope déeriawã, jĩĩwõ coopeja. —Yʉʉcã mʉʉrẽ ñañarõ tiiría. Wáagoa. Ñañaré tiinemórijãña, jĩĩwĩ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús basocáre wedenemowĩ: —Yʉʉrá niiã atibʉ́reco macãrãrẽ sĩãwócore tiiróbiro. Yʉʉre padeonʉnʉ́segʉno naĩtĩãrõpʉ niigʉ̃́ tiiróbiro niinemoriqui. Sĩãwócoropʉ niigʉ̃́pe catiré petihére cʉogʉ́daqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Teero tiirá, fariseo basocapeja cʉ̃ʉ̃rẽ jĩĩwã: —Mʉʉ basiro dícʉ mʉʉyere wedea. Ãpĩ mʉʉ wederére “teerora niiã” jĩĩgʉ̃́no maniquí. Teero tiiró, mʉʉ wederé wapamaníã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesupé cʉ̃́ãrẽ yʉʉwi: —Yʉʉ basiro yéere wedepacari, yʉʉ wederé wapacʉtía. Yʉʉ niiriropʉ, teero biiri yʉʉ pʉtʉawaadaropʉre masĩã. Mʉ́ãjã yʉʉ niiriropʉ, yʉʉ pʉtʉawaadaropʉre masĩridojãã. ");
INSERT INTO tue_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉ́ã atibʉ́reco macãrã wãcũrémena basocá tiirére ĩña, “ñañaniã” jĩĩã. Yʉʉpeja sĩcʉ̃rẽ teeré jĩĩria. ");
INSERT INTO tue_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yʉʉ teeré jĩĩgʉ̃, yʉʉ Pacʉ yʉʉre ticodiocorigʉmena basocá tiirére ĩña, “ñañaniã” jĩĩgʉ̃dacu. Yʉʉ sĩcʉ̃rã teeré jĩĩria. Teero tiigʉ́, yʉʉ jĩĩré diamacʉ̃́ niiã. ");
INSERT INTO tue_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉ́ãrẽ dutiré biiro jĩĩã: “Pʉarã́ sĩcãrĩbíro cʉ̃́ã ĩñariguere wederi, padeoró booa”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉʉ wedeserecã teerora niiã: Yée maquẽrẽ yʉʉ wedesea; yʉʉ Pacʉ yʉʉre ticodiocorigʉcã yée maquẽrẽ wedesei, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Teero tiirá, cʉ̃́ã sãĩñáwã: —Too docare ¿mʉʉ pacʉ noopʉ́ niigari? jĩĩwã. Cʉ̃ʉ̃pe cʉ̃́ãrẽ yʉʉwi: —Mʉ́ã yʉʉre masĩria; yʉʉ Pacʉcãrẽ masĩria. Yʉʉre masĩrãjã, yʉʉ Pacʉcãrẽ masĩboajĩyu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús Cõãmacʉ̃wiipʉ buerito, cʉ̃́ãrẽ teero wedesewi. Niyeru sã́ãretibari pʉtopʉ niiwĩ. Cʉ̃ʉ̃rẽ ñeerí bʉreco jeariwʉ ména. Teero tiirá, sĩcʉ̃no cʉ̃ʉ̃rẽ ñeeriwa. ");
INSERT INTO tue_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús cʉ̃́ãrẽ wedenemowĩ: —Yʉʉ wáagʉ tiia. Yʉʉ wáari siro, mʉ́ã yʉʉre ãmaãmiãdacu. Mʉ́ã ñañaré tiirére acabónoña manirã́ diaadacu. Yʉʉ wáaadaropʉre mʉ́ã wáamasĩricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judíoape cãmerĩ́ sãĩñáwã: —Cʉ̃ʉ̃ basiro sĩã, diaboqui. Teero tiigʉ́, “mʉ́ã yʉʉ wáaadaropʉre wáamasĩricu” jĩĩĩ, ¿teerora? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús cʉ̃́ãrẽ jĩĩwĩ sũcã: —Mʉ́ã atiyepá macãrã niiã; yʉʉpe ʉ̃mʉã́se macʉ̃ niiã. Mʉ́ã atibʉ́reco macãrã niiã; yʉʉpe atibʉ́reco macʉ̃ mee niiã. ");
INSERT INTO tue_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Teero tiigʉ́, “mʉ́ã ñañaré tiirére acabónoña manirã́ diaadacu” jĩĩãwʉ̃ mʉ́ãrẽ. Yʉʉ basiro yée maquẽrẽ wedeseri, “yʉʉrá niiã” jĩĩrére mʉ́ã padeoría. Teero tiirá, mʉ́ã acabónoña manirã́ diaadacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Teero tiirá, cʉ̃́ãpeja sãĩñáwã: —¿Noãnó niiĩ mʉʉ? jĩĩwã. Jesupé yʉʉwi: —Buenʉcãgʉ̃pʉ mʉ́ãrẽ wedetoamiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yʉʉ mʉ́ã ñañaré tiirére, mʉ́ãrẽ yʉʉ wapa tiiádarere pee wededʉgapacʉ, wederia ména. Yʉʉre ticodiocorigʉpʉ diamacʉ̃́ wedei. Teero tiigʉ́, cʉ̃ʉ̃ wederi, yʉʉ tʉoárigue dícʉre mʉ́ãrẽ atibʉ́reco macãrãrẽ wedea, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Cʉ̃ʉ̃ teero wedesegʉ, cʉ̃ʉ̃ Pacʉ Cõãmacʉ̃rẽna wedesegʉ tiimíwĩ. Cʉ̃́ãpe teeré tʉomasĩ́riwa. ");
INSERT INTO tue_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Teero tiigʉ́, Jesús cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã yʉʉ niipetira sõwʉ̃rẽ néemʉõnʉcõripʉ, “yʉʉrá niiã” jĩĩrére masĩãdacu. “Cʉ̃ʉ̃ booró tiiríjĩyi; cʉ̃ʉ̃ Pacʉ buerigue dícʉre wedejĩyi”, jĩĩ masĩãdacu. ");
INSERT INTO tue_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉʉre ticodiocorigʉ yʉʉmena niiĩ. Yʉʉ cʉ̃ʉ̃ tʉsaré dícʉre tiia. Teero tiigʉ́, yʉʉ Pacʉ yʉʉre sĩcʉ̃rã cṹũrii, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús teero jĩĩrĩ tʉorá, paʉ cʉ̃ʉ̃rẽ padeowá. ");
INSERT INTO tue_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús judíoa cʉ̃ʉ̃rẽ padeomírirare biiro jĩĩwĩ: —Mʉ́ã yʉʉ buerére yʉʉrucura, yʉʉre padeonʉnʉ́sera peti niiãdacu. ");
INSERT INTO tue_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Diamacʉ̃́ maquẽrẽ masĩãdacu. Teeré masĩrã, ñañaré tiirére tiidúmasĩãdacu. Teero tiirá, dutiapenori basoca witirira tiiróbiro niiãdacu. ");
INSERT INTO tue_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Cʉ̃́ã cʉ̃ʉ̃rẽ jĩĩwã: —¿Deero tiigʉ́ mʉʉ “dutiapenori basoca witirira tiiróbiro niiãdacu” jĩĩĩ? Ʉ̃sã Abraham pãrãmerã niinʉnʉsera niiã. Ʉ̃sã sĩcãrĩ dutiapenori basoca niiritoawʉ. ");
INSERT INTO tue_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Niipetira ñañaré tiiráno dutiapenori basoca tiiróbiro niicua. Dutiapenori basoca witimasĩricua. Teerora ñañaré tiirácã ñañarére tiidúmasĩricua. ");
INSERT INTO tue_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sĩcʉ̃ dutiapenori basocʉ cʉ̃ʉ̃ õpʉ̃ya wiipʉre niirucuriqui; tiiwií õpʉ̃ macʉ̃pe tiiwiipʉ́re niirucuqui. ");
INSERT INTO tue_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Teero tiigʉ́, yʉʉ Cõãmacʉ̃ macʉ̃ peti niijĩgʉ̃, mʉ́ãrẽ dutiapenori basoca tiiróbiro niirã́rẽ witiri tiimasĩ́ã. Yʉʉ teero tiirí, witirira peti niiãdacu sáa. ");
INSERT INTO tue_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yʉʉ mʉ́ã Abraham pãrãmerã niinʉnʉsera niirére masĩtoaa. Teero niipacara, yʉʉ wedeserere padeodʉgáricu. Teero tiirá, yʉʉre sĩãdʉgácu. ");
INSERT INTO tue_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉʉ Pacʉ yʉʉre ẽñoríguere mʉ́ãrẽ wedemiã. Mʉ́ãpeja mʉ́ã pacʉ tiidutírere tiicú, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ yʉʉwa: —Ʉ̃sã pacʉ Abraham niiĩ, jĩĩwã. Cʉ̃ʉ̃pe jĩĩwĩ: —Mʉ́ã Abraham pãrãmerã peti niirã, cʉ̃ʉ̃ tiirírobiro tiibócu. ");
INSERT INTO tue_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Teero tiiróno tiirá, yʉʉ diamacʉ̃́ maquẽ yʉʉ Pacʉ bueriguere wedegʉ́ niipacari, sĩãdʉgáa. Abraham teero tiirírigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉ́ãpe mʉ́ã pacʉ tiiróbirora tiia, jĩĩwĩ cʉ̃ʉ̃peja. Cʉ̃́ã cʉ̃ʉ̃rẽ yʉʉwa: —Ʉ̃sãjã pacʉ manirã́ bauáririra niiwʉ̃. Cõãmacʉ̃ sĩcʉ̃rã ʉ̃sã Pacʉ niiĩ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesupéja jĩĩwĩ: —Cõãmacʉ̃ mʉ́ã Pacʉ niiãtã, yʉʉre maĩbócu. Yʉʉ cʉ̃ʉ̃mena niirigʉra atiwʉ. Yʉʉ booró atiriwʉ. Cʉ̃ʉ̃ yʉʉre ticodiocowi. ");
INSERT INTO tue_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mʉ́ã ¿deero tiirá yʉʉ wederére tʉomasĩ́rii? Yée maquẽrẽ tʉodʉgária. ");
INSERT INTO tue_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉ́ã pacʉ wãtĩãrẽ dutigʉ́ niiĩ; mʉ́ã cʉ̃ʉ̃yara niiã. Teero tiirá, mʉ́ã pacʉ booró tiidʉgáa. Cʉ̃ʉ̃ sicatopʉra basocáre sĩãgʉ̃́ niirigʉ niiwĩ. Péerogã diamacʉ̃́ maquẽrẽ tiiríi. Cʉ̃ʉ̃ wedesegʉ, diamacʉ̃́ maquẽrẽ sĩcãrĩ wedeseriqui. Jĩĩditorepigʉ, jĩĩditosʉguerigʉ niiĩ. Teero jĩĩditogʉ, cʉ̃ʉ̃ niirecʉtirere ẽñoquí. ");
INSERT INTO tue_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉʉpeja diamacʉ̃́ maquẽrẽ wedea. Teero tiirá, mʉ́ã yʉʉre padeoría. ");
INSERT INTO tue_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mʉ́ã watoapʉre ¿noã yʉʉ ñañaré tiirére ẽñomasĩ́ĩ? Ẽñomasĩ́ria. Yʉʉ diamacʉ̃́ maquẽrẽ wedepacari, ¿deero tiirá yʉʉre padeoríi? ");
INSERT INTO tue_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cõãmacʉ̃ põna cʉ̃ʉ̃ wederére tʉoóya. Mʉ́ãpe cʉ̃ʉ̃ põna mee niiã. Teero tiirá, yʉʉ wederére tʉodʉgária, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judíoare dutirápeja jĩĩwã: —Mʉʉ Samaritanoãyʉ niicu. Diamacʉ̃́rã niiã ʉ̃sã jĩĩré: Wãtĩ cʉogʉ́ niijĩgʉ̃, mecʉ̃gʉ̃́ tiia mʉʉjã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesupé cʉ̃́ãrẽ yʉʉwi: —Wãtĩ cʉogʉ́ niiria. Yʉʉ tiirémena yʉʉ Pacʉre padeorére ẽñoã. Mʉ́ãpe yʉʉ tiirére ĩña, yʉʉre ñañarõ buijã́ã. ");
INSERT INTO tue_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Basocá yʉʉre ãñurõ wedesearo” jĩĩrére ãmaãgʉ̃ mee tiia. Teero niipacari, sĩcʉ̃ niiĩ yʉʉre ãñurõ wedesegʉ. Cʉ̃ʉ̃rã́ basocá tiirére queoró wedegʉdʉ niiĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉ wedeseri tʉo, teeré tiigʉ́no diariqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judíoare dutirápeja jĩĩwã: —Ʉ̃sã jĩĩãrirobirora teerora niiã: “Wãtĩ cʉogʉ́ niijĩgʉ̃, mecʉ̃gʉ̃́ tiia”. Abraham diajõãyigʉ. Profetacã diajõãyira. Mʉʉpeja biiro jĩĩã: “Yʉʉ wedeseri tʉo, teeré tiigʉ́no diariqui”. ");
INSERT INTO tue_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mʉʉ ʉ̃sã ñecʉ̃ Abraham nemorṍ niiria. Cʉ̃ʉ̃ diajõãyigʉ. Profetacã diajõãyira. Mʉʉpeja ¿ñiirũno niiĩ teero jĩĩ wedesegʉ? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesupéja cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ basiro yʉʉ tiirére ãñurõ wedeseri, wapamaníã. Yʉʉ Pacʉ (mʉ́ã “Cõãmacʉ̃ ʉ̃sã Pacʉ” jĩĩgʉ̃́rã) yʉʉ tiirére ãñurõ wedesei. ");
INSERT INTO tue_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉ́ã cʉ̃ʉ̃rẽ masĩricu. Yʉʉpeja cʉ̃ʉ̃rẽ masĩã. Yʉʉ “cʉ̃ʉ̃rẽ masĩria” jĩĩgʉ̃, mʉ́ã tiiróbiro jĩĩditorepigʉ niibocu. Diamacʉ̃́rã jĩĩã: Yʉʉ cʉ̃ʉ̃rẽ masĩã; cʉ̃ʉ̃ wedeseri tʉo, teeré tiia. ");
INSERT INTO tue_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉ́ã ñecʉ̃ Abraham yʉʉ atiadarere “ĩñagʉ̃da” jĩĩ, ʉseniwĩ. Teeré ĩñagʉ̃, bayiró ʉseniwĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Cʉ̃́ãpeja jĩĩwã: —Mʉʉ cincuenta cʉ̃marĩ cʉorípacʉ, ¿Abrahamrẽ ĩñarĩ? Ĩñaridojãjĩyu, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesupé yʉʉwi: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Abraham bauáadari sʉgueropʉ, “yʉʉrá niiã”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, cʉ̃ʉ̃rẽ déesĩããda jĩĩrã, ʉ̃tãperire néemiwã. Cʉ̃ʉ̃peja cʉ̃́ãrẽ dutijã́, Cõãmacʉ̃wiipʉ niiãrigʉ wáajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús netõwá, sĩcʉ̃ ʉ̃mʉ capeari ĩñahẽgʉ̃rẽ ĩñawĩ. Cʉ̃ʉ̃ wĩmagʉ̃pʉra capeari ĩñahẽgʉ̃ bauáyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ʉ̃sã Jesuré sãĩñáwʉ̃: —Ʉ̃sãrẽ buegʉ́, ¿deero tiigʉ́ ãni capeari ĩñahẽgʉ̃ bauáyiri? ¿Noãyé wapa niiĩ? ¿Cʉ̃ʉ̃ye wapa, cʉ̃ʉ̃ pacʉsʉ̃mʉãye wapa niiĩ? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús ʉ̃sãrẽ jĩĩwĩ: —Cʉ̃ʉ̃ ñañaré tiiré wapa mee niiã. Teero biiri cʉ̃ʉ̃ pacʉsʉ̃mʉãye wapa mee niiã. Cʉ̃ʉ̃mena Cõãmacʉ̃ cʉ̃ʉ̃ ãñurõ tiirére ẽñodʉgágʉ, cʉ̃ʉ̃rẽ teero baugʉ́ bauári tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yʉʉre ticodiocorigʉ padedutirere mecʉ̃tígã marĩrẽ tiiró booa. Too síro ñami tiiróbiro niiãdacu. Ñami jeari, sĩcʉ̃no pademasĩriqui. ");
INSERT INTO tue_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yʉʉ atibʉ́recopʉ niigʉ̃, basocáre sĩãwócore tiiróbiro niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús teero jĩĩãri siro, yepapʉ ʉsecóre eocṹ, dita ococʉtíre maané, capearipʉ tuusĩã́, ");
INSERT INTO tue_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","cʉ̃ʉ̃rẽ jĩĩwĩ: —Siloétaropʉ mʉʉye capearire cosegʉ́ wáaya, jĩĩwĩ. (Siloé jĩĩrõ, “ticoconorigʉ” jĩĩdʉgaro tiia.) Teero tiigʉ́, cʉ̃ʉ̃ toopʉ́ wáa, cʉ̃ʉ̃ capearire coserígʉ niiwĩ. Cʉ̃ʉ̃ wiipʉ́ pʉtʉaatigʉ, ãñurõ ĩñarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cʉ̃ʉ̃ya wii pʉto macãrã, ãpẽrã́ cʉ̃ʉ̃ niyeru sãĩduíri ĩñarucurira cãmerĩ́ sãĩñáyira: —¿Ãni niyeru sãĩduírucuarigʉra niiĩrã? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sĩquẽrã “cʉ̃ʉ̃rã́ niiĩ” jĩĩyira. Ãpẽrãpé “niirii; ãpĩ cʉ̃ʉ̃biro baugʉ́ niiĩ” jĩĩyira. —Yʉʉrá niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Deero tiigʉ́ mʉʉ mecʉ̃tígãrẽ ãñurõ ĩñaĩ? jĩĩyira cʉ̃́ãpe. ");
INSERT INTO tue_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jõõ niiãrigʉ Jesús wãmecʉtigʉ dita ococʉtíremena yʉʉ capearire tuusĩã́, Siloétaropʉ yʉʉre cosedutíati. Teero tiigʉ́, wáa, yʉʉ coseári siro, ãñurõ ĩñaãwʉ̃, jĩĩ yʉʉyigʉ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Noopʉ́ niigari cʉ̃ʉ̃? jĩĩyira. —Masĩriga. Noopʉ́ niigʉ̃ niiqui, jĩĩyigʉ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Capeari ĩñahẽgʉ̃ niimiãrigʉ fariseo basoca pʉtopʉ néewanorigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús dita ococʉtíremena cʉ̃ʉ̃rẽ ĩñarĩ tiirí bʉreco ʉ̃sã yeerisãri bʉreco niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Teero tiirá, fariseo basocapeja cʉ̃ʉ̃rẽ sãĩñáyira: —¿Deero tiigʉ́ mʉʉ ãñurõ ĩñaĩ? jĩĩyira. —Sĩcʉ̃ yʉʉ capearire dita ococʉtíremena tuusĩã́ãti. Yʉʉ coseári siro, ãñurõ ĩñaãwʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sĩquẽrã fariseo basoca jĩĩyira: —Cʉ̃ʉ̃rẽ teero tiiárigʉre Cõãmacʉ̃ ticocorijĩyi. Marĩ yeerisãri bʉrecore netõnʉcã́gʉ̃ tiii, jĩĩyira. Ãpẽrãpé jĩĩyira: —Cʉ̃ʉ̃ ñañaré tiigʉ́no niigʉ̃jã, ãñurére tiiẽ́ñoriboajĩyi, jĩĩyira. Cʉ̃́ã cʉ̃ʉ̃rẽ sĩcãrĩbíro wãcũriyira sáa. Teero tiirá, batajṍãyira. ");
INSERT INTO tue_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Teero tiirá, cʉ̃́ã capeari ĩñahẽgʉ̃ niimiãrigʉre sãĩñáyira sũcã: —Mʉʉte ¿deero jĩĩĩ mʉʉrẽ ĩñarĩ tiiárigʉre? jĩĩyira. —Yʉʉja “profeta niiĩ” jĩĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judíoare dutirá capeari ĩñahẽgʉ̃ niimiãrigʉye quetire padeodʉgáriyira. Teero tiirá, cʉ̃ʉ̃ pacʉsʉ̃mʉãrẽ sʉocó, ");
INSERT INTO tue_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","sãĩñáyira: —¿Ãni mʉ́ã macʉ̃ niiĩ? ¿“Wĩmagʉ̃pʉra capeari ĩñahẽgʉ̃ bauárigʉ” mʉ́ã jĩĩrigʉra niiĩ? ¿Deero tiigʉ́ cʉ̃ʉ̃ mecʉ̃tígãrẽ ĩñaĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Cʉ̃ʉ̃ pacʉsʉ̃mʉãpe yʉʉyira: —Ʉ̃́jʉ̃, ʉ̃sã macʉ̃rã niiĩ. Cʉ̃ʉ̃ capeari ĩñahẽgʉ̃ bauámiwĩ. Tee dícʉre ʉ̃sã masĩã. ");
INSERT INTO tue_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cʉ̃ʉ̃ mecʉ̃tígã ĩñarére masĩriga. Cʉ̃ʉ̃rẽ ĩñarĩ tiiárigʉcãrẽ masĩriga. Cʉ̃ʉ̃ basiro yʉʉmasĩĩ; wĩmagʉ̃ mee niiĩ. Cʉ̃ʉ̃rẽ sãĩñáña, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cʉ̃ʉ̃ pacʉsʉ̃mʉã cuira, teero jĩĩyira. Judíoare dutirá too sʉgueropʉ ateré jĩĩyira: “Jõõ niiãrigʉre ‘Cõãmacʉ̃ beserigʉ Cristo niiĩ’ jĩĩgʉ̃́norẽ marĩ neãrí wiipʉ cõãwioneconoãdacu; marĩmena niinemoriqui”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Teero tiirá, cʉ̃ʉ̃ pacʉsʉ̃mʉã “wĩmagʉ̃ mee niiĩ; cʉ̃ʉ̃rẽ sãĩñáña” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Judíoare dutirápeja capeari ĩñahẽgʉ̃ niimiãrigʉre sʉocóyira sũcã. Cʉ̃ʉ̃rẽ jĩĩyira: —Cõãmacʉ̃ tʉocóropʉre diamacʉ̃́ wedeseya. Ʉ̃sã masĩã: Jõõ niiãrigʉ ñañaré tiigʉ́ niiĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Cʉ̃ʉ̃pe yʉʉyigʉ: —Cʉ̃ʉ̃ ñañaré tiigʉ́ niigʉ̃ niiqui; yʉʉ masĩriga. Ate dícʉre masĩã: Yʉʉ capeari ĩñahẽgʉ̃ niipacʉ, mecʉ̃tígãrẽ ĩñaã sáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ sãĩñánemoyira: —¿Deero mʉʉrẽ tiiárĩ? ¿Ñeenómena mʉʉrẽ ĩñarĩ tiiárĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Cʉ̃ʉ̃pe yʉʉyigʉ: —Mʉ́ãrẽ wedetoamiãwʉ̃; yʉʉre tʉorícu. ¿Deero tiirá wedenemorõ booi sũcã? ¿Mʉ́ãcã cʉ̃ʉ̃rẽ nʉnʉdʉgágari? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ tutiyira: —Mʉʉ cʉ̃ʉ̃rẽ nʉnʉñá. Ʉ̃sãpeja Moisés dutirére nʉnʉã́da. ");
INSERT INTO tue_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ʉ̃sã masĩã: Cõãmacʉ̃ Moisére wedeseyigʉ. Cʉ̃ʉ̃rẽjã “too macʉ̃pʉ niiĩ” jĩĩmasĩriga, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Cʉ̃ʉ̃peja cʉ̃́ãrẽ jĩĩyigʉ: —¡Ayo! ¿Mʉ́ã cʉ̃ʉ̃rẽ “noo macʉ̃pʉ niiĩ” jĩĩmasĩrigari? ¡Cʉ̃ʉ̃rã́ yʉʉre capeari ĩñarĩ tiiáwĩ! ");
INSERT INTO tue_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Marĩ ateré masĩã: Cõãmacʉ̃ ñañaré tiiráre cʉ̃́ã sãĩrére yʉʉriqui. Cʉ̃ʉ̃rẽ padeoránorẽ, cʉ̃ʉ̃ booré tiiránorẽ yʉʉqui. ");
INSERT INTO tue_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sĩcãrĩ “sĩcʉ̃ wĩmagʉ̃pʉra capeari ĩñahẽgʉ̃ bauárigʉre ĩñarĩ tiiáyigʉ” jĩĩrĩ tʉoyá maniwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cõãmacʉ̃ cʉ̃ʉ̃rẽ ticocoriatã, yʉʉre capeari ĩñarĩ tiiríboajĩyi, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ jĩĩyira: —Mʉʉ sicatopʉra ñañagʉ̃́ bauárigʉ niipacʉ, ʉ̃sãrẽ buemasĩricu sáa, jĩĩyira. Cʉ̃ʉ̃ cʉ̃́ãmena niimiãrigʉre cõãwionecojãyira. ");
INSERT INTO tue_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús capeari ĩñahẽgʉ̃ niimiãrigʉre cʉ̃́ã cõãwionecori tʉowí. Cʉ̃ʉ̃rẽ bʉajeágʉ, jĩĩwĩ: —¿Mʉʉ niipetira sõwʉ̃rẽ padeói? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Noã niiĩ cʉ̃ʉ̃? Yʉʉ cʉ̃ʉ̃rẽ padeodʉgága, jĩĩ yʉʉwi. ");
INSERT INTO tue_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Mʉʉ cʉ̃ʉ̃rẽ ĩñatoaa. Yʉʉ mʉʉmena wedesegʉ cʉ̃ʉ̃rã́ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Õpʉ̃, mʉʉrẽ padeóa, jĩĩ, cʉ̃ʉ̃ pʉto ñicãcoberimena jeacũmuwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesupé jĩĩwĩ: —Yʉʉ atibʉ́recopʉre basocáre cʉ̃́ã ñañaré tiirére masĩãrõ jĩĩgʉ̃ atiwʉ. Teero wáari, capeari ĩñahẽrã tiiróbiro ĩñaãdacua; capeari ĩñarã́ capeari ĩñahẽrã tiiróbiro wáaadacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sĩquẽrã fariseo basoca cʉ̃ʉ̃ pʉtopʉ niirã́peja cʉ̃ʉ̃rẽ tʉo, jĩĩwã: —Ʉ̃sãcãrẽ “capeari ĩñahẽrã tiiróbirora niiã mʉ́ã” ¿jĩĩgʉ̃ tiii? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesupéja cʉ̃́ãrẽ yʉʉwi: —Mʉ́ã capeari ĩñahẽrã tiiróbiro niirãjã, yʉʉ tiirére ĩñaribojĩyu. Teero tiirá, wapa cʉoríbojĩyu. Mʉ́ã “ĩñamasĩã” jĩĩ wãcũjĩrã, wapa cʉorá niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús queorémena wedewi: —Yʉʉ ateré diamacʉ̃́rã jĩĩã: Sĩcʉ̃ oveja niirí sãnirõ soperé sããwahegʉ, tiisãnirõrẽ mʉãnetõsãwagʉ, yaarépigʉ niiqui. ");
INSERT INTO tue_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Soperé sããwagʉpe oveja coterí basocʉ niiqui. ");
INSERT INTO tue_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sope sããwaro coterí basocʉ cʉ̃ʉ̃rẽ pã́õsõnecoqui. Cʉ̃ʉ̃yara oveja cʉ̃ʉ̃ wedeseri tʉomasĩ́cua. Cʉ̃́ãcõrõrẽ cʉ̃́ã wãmemena sʉo, néewitiwaqui. ");
INSERT INTO tue_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cʉ̃ʉ̃yarare witiwapetiri ĩña, cʉ̃́ãrẽ sʉguewaqui. Cʉ̃ʉ̃ wedeseri tʉomasĩ́jĩrã, cʉ̃ʉ̃rẽ nʉnʉcúa. ");
INSERT INTO tue_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ãpĩ cʉ̃́ã ĩñamasĩhẽgʉ̃rẽ nʉnʉrídojãcua. Cʉ̃ʉ̃ wedeseri tʉomasĩ́rijĩrã, cʉ̃ʉ̃rẽ dutibatéjõãcua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Fariseo basoca cʉ̃ʉ̃ cʉ̃́ãrẽ queorémena wederi, “biirope jĩĩdʉgaro tiicú” jĩĩmasĩriwa. ");
INSERT INTO tue_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Cʉ̃́ã tʉohéri ĩñagʉ̃, Jesús cʉ̃́ãrẽ jĩĩnemowĩ: —Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉrá oveja sããwari sope tiiróbiro niiã. ");
INSERT INTO tue_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Niipetira yʉʉ sʉguero atirira ñañarã́, ovejare yaarépira tiiróbiro niiĩya. Teero tiirá, oveja cʉ̃́ãrẽ nʉnʉrírira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉʉrá sope tiiróbiro niiã. Yʉʉpʉre sããwarano netõnénoãdacua. Oveja tiiróbiro sããwa, witiwa, táa bʉará tiiróbiro niiãdacua. ");
INSERT INTO tue_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Yaarépigʉ cʉ̃́ãrẽ yaagʉ́dʉ, sĩãgʉ̃́dʉ dícʉ atiqui. Yʉʉpeja cʉ̃́ãrẽ catiré ticogʉ atiwʉ, ãñurõ peti niiãrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Yʉʉrá ovejare ãñurõ coterí basocʉ tiiróbiro niiã. Ovejare ãñurõ coterí basocʉ cʉ̃ʉ̃yarare diabosaqui. ");
INSERT INTO tue_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ãpĩpé cʉ̃ʉ̃ õpʉ̃yarare ĩñanʉnʉsegʉ dícʉ niiqui; oveja coterí basocʉ peti mee niiqui. Cʉ̃ʉ̃yara mee niicua. Teero tiigʉ́, yái atiri ĩña, ovejare cõãnʉcõjã, dutijṍãqui. Yáipe cʉ̃́ãrẽ ñee, ãcũbatejãqui. ");
INSERT INTO tue_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ovejare ĩñanʉnʉsegʉ dícʉ niijĩgʉ̃, cʉ̃́ãrẽ wãcũriqui. Ãñunicu cʉ̃ʉ̃rẽjã. ");
INSERT INTO tue_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Yʉʉpeja ovejare ãñurõ coterí basocʉ tiiróbiro niiã. Yʉʉ Pacʉ yʉʉre masĩĩ; yʉʉcã cʉ̃ʉ̃rẽ masĩã. Teerora yʉʉcã yáarare masĩã; cʉ̃́ãcã yʉʉre masĩĩya. Yáarare diabosa, netõnégʉ̃dacu. ");
INSERT INTO tue_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yʉʉ ãpẽrã́ ovejare cʉoa; cʉ̃́ã atisãnírõ macãrã mee niiĩya. Cʉ̃́ãcãrẽ néeatigʉda. Cʉ̃́ãcã yʉʉ wedeseri tʉo, yʉʉadacua. Teero tiirá, sĩcʉ̃põna niiãdacua; teero biiri sĩcʉ̃rã cʉ̃́ãrẽ cotegʉ́ niigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yáarare diabosa, too síro masãgʉ̃dacu. Teero tiigʉ́, yʉʉ Pacʉ yʉʉre maĩĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sĩcʉ̃ yʉʉre diari tiimasĩ́riqui; yʉʉ booró diagʉda. Yʉʉ diamasĩã; too síro masãmasĩã. Yʉʉ Pacʉ yʉʉre biirora tiidutíwi, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judíoape cʉ̃ʉ̃ wedeseri tʉorá, cʉ̃ʉ̃rẽ sĩcãrĩbíro wãcũriwa sũcã. Teero tiirá, batajṍãwã. ");
INSERT INTO tue_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Paʉ cʉ̃ʉ̃rẽ jĩĩwã: —¿Deero tiirá mʉ́ã cʉ̃ʉ̃rẽ tʉoi? Wãtĩ cʉogʉ́ niiĩ; teero biiri mecʉ̃gʉ̃́ peti tiii, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ãpẽrãpéja jĩĩwã: —Wãtĩ sããnorigʉ teero wedeseriboqui. Wãtĩ sããnorigʉ capeari ĩñahẽgʉ̃rẽ ĩñarĩ tiimasĩ́riqui, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Púuriro niirĩ, Jerusalénpʉ ʉ̃sã judíoa bosebʉreco tiiwʉ́. Too sʉguero macãrãpʉ Cõãmacʉ̃wiire yaponóãri siro, bosebʉreco tiipéoyira. Tii bosebʉreco ʉ̃sã wãcũnʉnʉseri bʉreco niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús Cõãmacʉ̃wiipʉ biayá manirí tatiapʉ wáawi. Tiitatia wãmecʉtia Pórtico de Salomón. ");
INSERT INTO tue_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Toopʉ́ judíoare dutirápeja cʉ̃ʉ̃rẽ ãñurõ sodeanʉcãjõãwã. Cʉ̃ʉ̃rẽ sãĩñáwã: —¿Dee biiripʉ ʉ̃sãrẽ diamacʉ̃́ maquẽrẽ wedegʉdari? Mʉʉ Cõãmacʉ̃ beserigʉ Cristo niigʉ̃, diamacʉ̃́rã ʉ̃sãrẽ wedeya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesupé cʉ̃́ãrẽ yʉʉwi: —Wedemiwʉ̃; mʉ́ã tʉoríwʉ. Yʉʉ Pacʉ wãmemena tiiẽ́ñore yʉʉ niirecʉtirere ãñurõ ẽñoã. ");
INSERT INTO tue_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mʉ́ã yáara oveja niiria. Teero tiirá, yʉʉre padeoría. ");
INSERT INTO tue_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yáara ovejapeja yʉʉ wedeserere tʉomasĩ́ya. Yʉʉcã cʉ̃́ãrẽ masĩã. Cʉ̃́ã yʉʉre nʉnʉʉ̃́ya. ");
INSERT INTO tue_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yʉʉ cʉ̃́ãrẽ catiré petihére ticoa. Cʉ̃́ã pecamepʉ wáaricua. Sĩcʉ̃no yʉʉ cʉoráre yʉʉre ẽmamasĩriqui. ");
INSERT INTO tue_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Cʉ̃́ãrẽ yʉʉ Pacʉ ticorigʉ niiwĩ. Cʉ̃ʉ̃ niipetira nemorṍ tutuagʉ niiĩ. Teero tiigʉ́, sĩcʉ̃no yʉʉ Pacʉ cʉoráre ẽmamasĩriqui. ");
INSERT INTO tue_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ʉ̃sã yʉʉ Pacʉmena sĩcʉ̃rã niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, judíoare dutirápeja ʉ̃tãperire néemiwã sũcã, cʉ̃ʉ̃rẽ déesĩããda jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ Pacʉ tutuaremena mʉ́ã ĩñacoropʉ pee ãñuré tiiẽ́ñowʉ̃. ¿Ñeenó tiiré wapape yʉʉre déesĩãdʉgai? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Cʉ̃́ãpe yʉʉwa: —Mʉʉ ãñurõ tiiré wapa déesĩãricu. Mʉʉ basocʉ́ra niipacʉ, “yʉʉ Cõãmacʉ̃ niiã” jĩĩré wapa mʉʉrẽ sĩãã́da. Mʉʉ Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiia, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã dutiré watoapʉre Cõãmacʉ̃ jĩĩriguere biiro jóanoã: “Mʉ́ã Cõãmacʉ̃ tiiróbirora niirã́ niiã”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Marĩ masĩã: Cõãmacʉ̃ye queti jóaripũ maquẽrẽ “diamacʉ̃́ maquẽ niiria” jĩĩmasĩña maniã. Cõãmacʉ̃ye wederirare “mʉ́ã Cõãmacʉ̃ tiiróbirora niirã́ niiã” jĩĩ jóadutirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Teero tiigʉ́, “yʉʉ Cõãmacʉ̃ macʉ̃ niiã” jĩĩmasĩã. Mʉ́ãpe yʉʉ teero jĩĩré wapa yʉʉre “Cõãmacʉ̃rẽ ñañarõ wedesegʉ tiia” jĩĩã. Teero niiria. Cõãmacʉ̃ yʉʉre besewi; yʉʉre atibʉ́recopʉre ticodiocowi. ");
INSERT INTO tue_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉʉ Pacʉ tiirére yʉʉ tiihéri, yʉʉre padeoríjãña. ");
INSERT INTO tue_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Cʉ̃ʉ̃ tiirére tiirípereja, yʉʉre padeorípacara, yʉʉ tiiẽ́ñorere padeoyá. Mʉ́ã teeré padeorá, “yʉʉ Pacʉ yʉʉpʉre niiĩ” jĩĩrére masĩãdacu. Teero biiri “yʉʉ cʉ̃ʉ̃pʉre niiã” jĩĩrére tʉomasĩ́ãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Cʉ̃́ãpeja cʉ̃ʉ̃rẽ peresuwiipʉ néewadʉgamiwã sũcã. Cʉ̃ʉ̃pe cʉ̃́ãrẽ dutijṍãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Too síro Jesús día Jordán apeniñapʉ́ tĩãwawi. Toopʉ́re Juan wãmeõtiri basocʉ wãmeõtiriropʉ pʉtʉácũmuwĩ. ");
INSERT INTO tue_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Paʉ Jesuré ĩñarã jeara, jĩĩwã: —Juan Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñoriwi. Tiiẽ́ñoripacʉ, niipetire ãniyé maquẽrẽ wedegʉ, diamacʉ̃́rã wedeyi, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Toopʉ́re paʉ Jesuré padeowá. ");
INSERT INTO tue_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Sĩcʉ̃ basocʉ́ diarecʉtigʉ niirigʉ niiwĩ. Cʉ̃ʉ̃ wãmecʉtiwi Lázaro. Cʉ̃ʉ̃, teero biiri cʉ̃ʉ̃ sõwõsãnumiã María, Marta Betania macã macãrã niiwã. ");
INSERT INTO tue_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maríara niiwõ Jesuyé dʉporipʉre sitiaãñúre píopeo, coo póañapõmena tuucosérigo. Coo bai Lázaro diarecʉtigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro sõwõsãnumiã Jesuré queti ticocorira niiwã: —Õpʉ̃, mʉʉ menamacʉ̃ diagʉ tiii, jĩĩcoyira. ");
INSERT INTO tue_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesupé tee quetire tʉogʉ́, jĩĩwĩ: —Cʉ̃ʉ̃ diarecʉtiremena diadoariqui. Cʉ̃ʉ̃ diarémena Cõãmacʉ̃ tutuarere ẽñonóãdacu. Yʉʉ Cõãmacʉ̃ macʉ̃cãrẽ basocá “cʉ̃ʉ̃ tutuagʉ niiĩ” jĩĩãdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús cʉ̃́ã María, Marta, teero biiri cʉ̃́ã bai Lázarore maĩrígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Teero tiigʉ́, cʉ̃ʉ̃ diarecʉtire quetire tʉogʉ́, cʉ̃ʉ̃ niirṍpʉ pʉabʉ́reco pʉtʉácũmunemowʉ̃ sũcã. ");
INSERT INTO tue_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Too síro ʉ̃sã cʉ̃ʉ̃ bueráre: —Jãmʉ Judeapʉ sũcã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ʉ̃sãpe cʉ̃ʉ̃rẽ jĩĩwʉ̃: —Ʉ̃sãrẽ buegʉ́, yoawaria ména judíoare dutirá ʉ̃tãperimena mʉʉrẽ déesĩãdʉgamiwã. ¿Mʉʉ toopʉ́ wáadʉgagari sũcã? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesupé queorémena yʉʉwi: —Wãcũpatirijãña. Mʉ́ã masĩã: Sicabʉrecore doce horari bóea. Bʉ́reco wáagʉno bóeremena ĩñamasĩqui. Teero tiigʉ́, ñaacũmuriqui. ");
INSERT INTO tue_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Naĩtĩãrõpʉ wáagʉnopeja cʉ̃ʉ̃ wáaro sĩãwócore maniré wapa dʉpotua, ñaacũmuqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Teero jĩĩãri siro, ʉ̃sãrẽ jĩĩwĩ: —Marĩ menamacʉ̃ Lázaro cãnijṍãjĩyi. Yʉʉ cʉ̃ʉ̃rẽ wãcõgʉ̃́ wáagʉda, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Õpʉ̃, cʉ̃ʉ̃ cãniã́rigʉ, ãñujõãgʉ̃daqui, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús “Lázaro cãnijṍãjĩyi” jĩĩgʉ̃, “diajõãjĩyi” jĩĩdʉgagʉ tiiwí. Ʉ̃sãpe cãniré petire wãcũjãmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ʉ̃sã tʉohéri ĩñagʉ̃, Jesús ʉ̃sãrẽ tʉomasĩ́rõrã wedewi: —Lázaro diajõããjĩyi. ");
INSERT INTO tue_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Marĩ toopʉ́ niihẽrĩ, ãñuã. Yʉʉ ʉseniã; ãñuniãdacu mʉ́ãrẽ. Toorá mʉ́ã nemorṍ padeoádacu. Jãmʉ, cʉ̃ʉ̃rẽ ĩñarã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás (“sʉdʉárigʉ” ʉ̃sã jĩĩgʉ̃́) ʉ̃sãrẽ jĩĩwĩ: —Jãmʉ marĩcã. Marĩrẽ buegʉ́re cʉ̃́ã sĩãrĩ́, cʉ̃ʉ̃menarã diara wáaada, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús Lázaroya macãpʉ jeagʉdʉ tiirí, ʉ̃tãtutipʉ cṹũrigue quetire tʉowí. Cʉ̃ʉ̃rẽ cṹũãri siro, bapari bʉrecori netõyíro mée. ");
INSERT INTO tue_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania Jerusalén pʉtogã niiwʉ̃. Pʉa kilómetro, ape kilómetro deco yoaro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Teero tiirá, paʉ Jerusalén macãrã cʉ̃́ã bai diari tʉorá, Marta, Maríare wãcũtutuaaro jĩĩrã, cʉ̃́ã pʉtopʉ ĩñarã jearira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","“Jesús atitoai mée” jĩĩrĩ tʉogó, Marta cʉ̃ʉ̃rẽ bocago atiwo. Maríape wiipʉ́ pʉtʉáyigo. ");
INSERT INTO tue_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesús pʉto jeago, cʉ̃ʉ̃rẽ jĩĩwõ: —Õpʉ̃, mʉʉ ãnopʉ́ niirĩ, yʉʉ bai diariboajĩyi. ");
INSERT INTO tue_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mecʉ̃tígãcãrẽ Cõãmacʉ̃ niipetire mʉʉ sãĩrénorẽ ticoqui. Teeré masĩã, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús coore jĩĩwĩ: —Mʉʉ bai masãgʉ̃daqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Coopeja yʉʉwo: —Yʉʉ masĩã: Atibʉ́reco petirí, niipetira diarira masãripʉ, masãgʉ̃daqui, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesupé jĩĩwĩ: —Yʉʉrá diarirare masõ, catiré ticogʉ́ niiã. Yʉʉre padeogʉ́ diapacʉ, catigʉdaqui sũcã. ");
INSERT INTO tue_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mecʉ̃tígãrẽ catirá yʉʉre padeorá diari siro, dianemoricua. ¿Mʉʉ teeré padeói? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Coope yʉʉwo: —Õpʉ̃, ateré padeóa: Mʉʉ Cõãmacʉ̃ beserigʉ Cristo, Cõãmacʉ̃ macʉ̃ niiã. Mʉʉ “sĩcʉ̃ basocʉ́ atigʉdʉ niiãyigʉ” cʉ̃́ã jĩĩrigʉ niiã, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta Jesuména wedeseari siro, coo bayio Maríare sʉogó wáawo. Coore ãpẽrã́ tʉohéropʉ wedeyigo: —Marĩrẽ buegʉ́ jeatoaawĩ. Mʉʉrẽ sʉodutíawĩ, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Coo teero jĩĩrĩ tʉogó, cʉ̃ʉ̃ pʉtopʉ máata atirigo niiwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús Marta bocaariropʉ niiwĩ. Macãpʉre piyawariwi ména. ");
INSERT INTO tue_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judíoa wiipʉ́ Maríare wãcũtutuari tiirá tiiyíra. Cʉ̃́ã coo boyeromena witiwari ĩñarã, coore nʉnʉyíra. “Cṹũãri tutipʉ utigo wáago tiicó”, jĩĩ wãcũmiyira. ");
INSERT INTO tue_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maríape Jesús pʉto jea, cʉ̃ʉ̃rẽ ĩña, cʉ̃ʉ̃ye dʉpori pʉtopʉ munibiácũmuwõ. —Õpʉ̃, mʉʉ ãnopʉ́ niiãtã, yʉʉ bai diariboajĩyi, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús coo utiri ĩñagʉ̃, teero biiri judíoa coore nʉnʉátiariracã utiri ĩñagʉ̃, bayiró wãcũpati, ñañarõ yeeripũnacʉtiwi. ");
INSERT INTO tue_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Noopʉ́ cʉ̃ʉ̃rẽ cṹũãrĩ? jĩĩ sãĩñáwĩ. —Jãmʉ, ĩñagʉ̃ atiya, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús utiwi. ");
INSERT INTO tue_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cʉ̃ʉ̃ utiri ĩñarã, judíoa cãmerĩ́ jĩĩwã: —Ĩñaña. Cʉ̃ʉ̃rẽ bayiró maĩjã́miãyiri cʉ̃ʉ̃, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sĩquẽrã jĩĩwã: —Ãni jõõ niirigʉ capeari ĩñahẽgʉ̃rẽ netõnérigʉra niiĩrã. ¿Lázarocãrẽ diari tiiríboayiri? jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús Lázarore cṹũri tutipʉ jeagʉ, bayiró wãcũpatiremena niiwĩ sũcã. Tiituti ʉ̃tãtuti niiwʉ̃. Tiituti sopepʉtó ʉ̃tãquicamena bianówʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús cʉ̃́ãrẽ: —Tiiquire néecoya, jĩĩwĩ. Marta diaarigʉ sõwõpe cʉ̃ʉ̃rẽ jĩĩwõ: —Õpʉ̃, ʉ̃ni niiqui. Cʉ̃ʉ̃ diaari siro, bapari bʉrecori netõã, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús coore jĩĩwĩ: —“Yʉʉre padeogó, Cõãmacʉ̃ tutuarere ĩñagõdacu”, jĩĩ wedeawʉ̃ mʉʉrẽ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Teero tiirá, cʉ̃́ã tiituti biaríquicare néecowa. Jesús ĩñamʉõco, Cõãmacʉ̃rẽ jĩĩwĩ: —Pacʉ, yʉʉ sãĩrére mʉʉ tʉoa. Teero tiigʉ́, mʉʉrẽ ʉsenire ticoa. ");
INSERT INTO tue_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉʉ masĩã: Mʉʉ yʉʉre tʉorucújãã. Ãniã ãnopʉ́ nucũrã́ye maquẽrẽ bʉsʉrómena mʉʉmena wedesea. “Yʉʉ mʉʉ ticodiocorigʉ niiã” jĩĩrére masĩãrõ jĩĩgʉ̃, teero tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cʉ̃ʉ̃ teero jĩĩãri siro, bayiró bʉsʉrómena jĩĩwĩ: —Lázaro, witiatiya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Cʉ̃ʉ̃ teero jĩĩrĩrã, diaarigʉ niimiãrigʉ witiatiwi. Cʉ̃ʉ̃ye wãmorĩ, cʉ̃ʉ̃ye dʉporire sutiména dʉdʉanorigʉ niiwĩ. Cʉ̃ʉ̃ya diapóacã suti caseromena cõmanórigʉ niiwĩ. Jesús cʉ̃́ãrẽ jĩĩwĩ: —Cʉ̃ʉ̃rẽ jõãñá, witiatiaro jĩĩrã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judíoa Maríare ĩñarã jeaarira cʉ̃ʉ̃ teero tiiríguere ĩñarã, paʉ cʉ̃ʉ̃rẽ padeowá. ");
INSERT INTO tue_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ãpẽrãpé Jesús tiiríguere fariseo basocapʉre wedera wáayira. ");
INSERT INTO tue_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Teeré tʉoári siro, paiaré dutirá, teero biiri fariseo basoca, Judíoare Dutirá Petimena neãyira. Neããri siro, jĩĩyira: —¿Deero tiiádari marĩ? Jõõ niiãrigʉ pee tiiẽ́ñorere tiigʉ́ tiiquí. ");
INSERT INTO tue_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Marĩ cʉ̃ʉ̃rẽ teero ĩñajãrĩ, niipetira cʉ̃ʉ̃rẽ padeoádacua. Romanuã ati, Cõãmacʉ̃wiire cõããdacua. Teero biiri marĩ dutiré cʉorére petirí tiiádacua, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sĩcʉ̃ cʉ̃́ã menamacʉ̃ wãmecʉtiwi Caifás. Cʉ̃ʉ̃ tiicʉ̃marẽ paiaré dutigʉ́ niiwĩ. Cʉ̃ʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã tʉomasĩ́ridojãã. ");
INSERT INTO tue_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Niipetira basocá marĩya dita macãrã diari, ñañanibocu. Biiro tiirípe, ãñucu: Sĩcʉ̃ marĩ niipetiraye niiãdarere diabosari, marĩrẽ ãñuãdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás cʉ̃ʉ̃ basiro wãcũrémena teero jĩĩriyigʉ. Tiicʉ̃ma cʉ̃ʉ̃ paiaré dutigʉ́ niirĩ, Cõãmacʉ̃ cʉ̃ʉ̃rẽ teero wãcũré ticoyigʉ. Teero jĩĩgʉ̃, “marĩ niipetiraye niiãdarere Jesús diabosagʉdaqui” jĩĩsʉgueyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesús judíoa dícʉre diabosariyigʉ. Niipetira Cõãmacʉ̃ põna cʉ̃ʉ̃rẽ padeoádarare, apeyé ditapʉ niirã́cãrẽ diabosayigʉ. Sicapõna macãrã sĩcʉ̃põna tiiróbiro niiãrõ jĩĩgʉ̃, teero tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Teero tiirá, cʉ̃́ã tiibʉrecora “¿deero tiiádari marĩ cʉ̃ʉ̃rẽ sĩãã́dara?” jĩĩ wãcũnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Teero tiigʉ́, Jesús paʉ judíoa watoapʉre wáanetõnemoriwi. Too niiãrigʉ yucʉ manirṍ wesapʉ wáawi. Efraín wãmecʉtiri macãpʉ jea, toopʉ́ ʉ̃sãmena pʉtʉáwi. ");
INSERT INTO tue_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pascua judíoa bosebʉreco jeaadaro tiirí, paʉ basocá Jerusalénpʉre jeawa. Cʉ̃́ã tii bosebʉreco sʉguero cʉ̃́ã ñañaré tiiríguere cosesʉguéra jeara tiiyíra. ");
INSERT INTO tue_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesuré ãmaãcãmesãyira. Cõãmacʉ̃wii wesa macã yepapʉ niirã, cãmerĩ́ sãĩñáyira: —¿Mʉ́ã deero tʉgueñaĩ? ¿Cʉ̃ʉ̃ bosebʉrecore ĩñagʉ̃ atigʉdari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Paiaré dutirá, fariseo basocamena too sʉgueropʉ basocáre biiro dutiyira: —Mʉ́ã “jõõ niiãrigʉ toopʉ́ niiãyigʉ” jĩĩrĩ tʉorá, ʉ̃sãrẽ wedeya, jĩĩyira. Cʉ̃ʉ̃rẽ ñee, peresuwiipʉ néewadʉgayira. ");
INSERT INTO tue_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua bosebʉreco wáaadaro seis bʉrecori dʉsarí, Jesús cʉ̃ʉ̃ buerámena Betaniapʉ wáawi. Too sʉguero tiimacãpʉra Jesús Lázaro diarigʉpʉre masõwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Toopʉ́ Jesuré bosebʉreco tiipéowa. Marta yaarére batowo. Lázaro, ãpẽrãcã́ Jesuména yaaduiwa. ");
INSERT INTO tue_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Teero tiigó, María sicagá sitiaãñúrigare Jesús pʉto néeatiwo. Tee sitiaãñúre “nardo” wãmecʉtire wapapacáre niiwʉ̃. Cʉ̃ʉ̃ye dʉporipʉ píopeo, cooya póañapõmena tuucoséwo. Tiiwií niipetiropʉ sitiaãñúsesajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Judas Iscariote jĩĩwĩ: —Ate sitiaãñúrere sicacʉ̃ma padegʉ wapatárocõrõ dúaro boomíãyu. Tee niyerure bóaneõrãrẽ ticonoboajĩyu, jĩĩwĩ. Cʉ̃ʉ̃ Jesús buegʉ́ too síropʉ cʉ̃ʉ̃rẽ ĩñatutirapʉre wedesãgʉ̃dʉ niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Diamacʉ̃́ bóaneõrãrẽ tiiápudʉgagʉ mee tee jĩĩwĩ. Biiro wedesegʉ niyeru yaadʉgágʉ, teero jĩĩwĩ. Cʉ̃ʉ̃ ʉ̃sã niyeru sã́ãripore cotegʉ́ niimiwĩ. Tiipo maquẽ niyerure yaajã́rucurigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —¿Deero tiigʉ́ coore potocṍĩ? Potocṍgʉ̃ mee tiiyá. Coo ateré ĩñanocũrigo niiwõ yʉʉ diaadari bʉreco maquẽrẽ. ");
INSERT INTO tue_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bóaneõrã mʉ́ã watoapʉ niirucujããdacua. Yʉʉpeja mʉ́ãmena niirucuricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Paʉ judíoa Jesús Betaniapʉ niiré quetire tʉoyíra. Teero tiirá, cʉ̃ʉ̃rẽ ĩñarã jeawa. Cʉ̃ʉ̃ dícʉre ĩñarã jeariwa. Cʉ̃ʉ̃ masõrigʉ Lázarocãrẽ ĩñarã jeawa. ");
INSERT INTO tue_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Paʉ judíoa cʉ̃ʉ̃ masãrigue quetire tʉorá, paiaré dutirá dutirére duujã́, Jesuré padeowá. Teero tiirá, paiaré dutirá: —Lázarocãrẽ sĩãã́da, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Apebʉ́reco Jerusalénpʉ paʉ bosebʉrecore ĩñarã jeará “Jesús atiqui mée” jĩĩré quetire tʉoríra niiwã. ");
INSERT INTO tue_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Teero tiirá, iquiquerire páata, cʉ̃ʉ̃rẽ bocara atiwa. Bayiró wedeseremena jĩĩatiwa: —¡Marĩ Õpʉ̃rẽ ʉsenire ticoada! ¡Ãni Cõãmacʉ̃ ticodiocorigʉ niiĩ! ¡Cʉ̃ʉ̃rẽ ãñurõ tiiáro! ¡Cʉ̃ʉ̃ marĩ Israelya põna macãrã Õpʉ̃ niiĩ! jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús burro wĩmagʉ̃rẽ bʉajeá, cʉ̃ʉ̃ sotoapʉ mʉãpeawi. Cʉ̃ʉ̃ teero tiiríguere Cõãmacʉ̃ye queti jóaripũpʉ jóanoã: ");
INSERT INTO tue_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mʉ́ã Jerusalén macãrã, cuirijãña. Ĩñaña: Mʉ́ã Õpʉ̃ atitoai mée; cʉ̃ʉ̃ burra macʉ̃ wĩmagʉ̃ sotoapʉ pesaatii, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tee jóariguere ʉ̃sã cʉ̃ʉ̃ buerá sicatopʉre “Jesuyé queti niicu” jĩĩ tʉomasĩ́riwʉ. Too síro ʉ̃mʉã́sepʉ cʉ̃ʉ̃ mʉãwari siropʉ, ʉ̃sã wãcũbʉawʉ. Teero tiirá, “Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora cʉ̃ʉ̃rẽ diamacʉ̃́rã wáawʉ” jĩĩ cãmerĩ́ wedesewʉ. ");
INSERT INTO tue_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Paʉ Jesús Lázarore masõrĩ ĩñarira tee quetire wedesesajõãyira. “Lázaro ʉ̃tãtutipʉ niimiãrigʉre sʉowíonecowi”, jĩĩ wedeyira. ");
INSERT INTO tue_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Teero tiirá, paʉ tee tiiẽ́ñoriguere tʉoríra Jesuré bocara atiwa. ");
INSERT INTO tue_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseo basocapeja cãmerĩ́ jĩĩyira: —Marĩ deero tiimasĩ́ritu niiã. ¿Ĩñamiĩ mʉ́ã? Niipetira cʉ̃ʉ̃mena wáara tiiíya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bosebʉreco ĩñarã jeará watoapʉ sĩquẽrã griegoa niiwã. Cʉ̃́ãcã Cõãmacʉ̃rẽ padeorá atirira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cʉ̃́ã Felipe pʉto jeayira. Felipe Betsaida Galilea ditapʉ niirí macã macʉ̃ niiwĩ. Cʉ̃́ã cʉ̃ʉ̃rẽ jĩĩyira: —Jesuré ĩñarã wáadʉgaga. ");
INSERT INTO tue_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe Andrére wedegʉ wáayigʉ. Cʉ̃́ã pʉarã́pʉ Jesuré wedera jeawa. ");
INSERT INTO tue_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús cʉ̃́ãrẽ queorémena yʉʉwi: —Máata niipetira sõwʉ̃ ʉpʉtí macʉ̃ niirére ẽñonóãdacu. ");
INSERT INTO tue_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ oteré capere oteriatã, teero pʉtʉájãcu. Teeperi oteri docare, ditapʉ bóa, wii, bʉcʉá, pee dʉcacʉticu. ");
INSERT INTO tue_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Atibʉ́recopʉre cʉ̃ʉ̃ catirí bʉrecorire maĩnetṍnegʉ̃no pecamepʉ ñañarõ tiinógʉ̃daqui. Cʉ̃ʉ̃ catirí bʉrecorire maĩhẽ́gʉ̃nope ʉ̃mʉã́sepʉ catiré petihére bʉagʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yʉʉ dutirére tiidʉgágʉno yʉʉre nʉnʉã́rõ. Yʉʉ niiãdaropʉre yʉʉmena niigʉ̃daqui. Yʉʉ dutirére tiinʉnʉ́segʉnorẽ yʉʉ Pacʉ ãñurõ tiigʉ́daqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesús jĩĩnemowĩ: —Mecʉ̃tígã yʉʉ bayiró wãcũpatia. Teero tiigʉ́, yʉʉ deero jĩĩmasĩriga. “Pacʉ, yʉʉre ñañarõ wáaadarere netõnéña”, ¿jĩĩgʉ̃dari? Jĩĩricu. Teero ñañarõ tiinógʉ̃dʉra atiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pacʉ, “mʉʉ ãñunetõjõãã” jĩĩrére ẽñoñá, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩãri siro, ʉ̃mʉã́sepʉ wedeseri tʉowʉ́: —“Yʉʉ ãñunetõjõãã” jĩĩrére ẽñotóawʉ; ẽñonemógʉ̃da sũcã, jĩĩti. ");
INSERT INTO tue_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Basocá toopʉ́ niirã́ cʉ̃ʉ̃ wedeseri tʉorá: —Bʉpo bʉsʉati, jĩĩwã. Ãpẽrã́: —Ángele cʉ̃ʉ̃rẽ wedeseati, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉre tʉodutígʉ mee wedeseati; mʉ́ãpere tʉodutígʉ wedeseati. ");
INSERT INTO tue_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mecʉ̃tígãrẽ Cõãmacʉ̃ atibʉ́reco macãrãrẽ wapa tiigʉ́daqui. Mecʉ̃tígãcãrẽ atibʉ́reco macãrãrẽ dutigʉ́re cõãwionecogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yʉʉpere basocá néemʉõnʉcõãdacua, niipetirare yʉʉ ãñurõ tiibosáremena ʉgaripéaatiaro jĩĩgʉ̃, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Teero jĩĩgʉ̃, “biiro tiirí, diagʉdacu” jĩĩgʉ̃ tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Basocá cʉ̃ʉ̃rẽ jĩĩwã: —Cõãmacʉ̃ye queti jóaripũpʉ cʉ̃́ã bueẽñorĩ, biiro tʉonówʉ̃: “Cõãmacʉ̃ beserigʉ Cristo catirucujãgʉ̃daqui”. Tee diamacʉ̃́ niirĩ, ¿deero tiigʉ́dʉ mʉʉpe “niipetira sõwʉ̃rẽ néemʉõnʉcõrõ booa” jĩĩĩ? Niipetira sõwʉ̃ ¿niipé niiĩ? jĩĩ sãĩñáwã. ");
INSERT INTO tue_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesupé cʉ̃́ãrẽ jĩĩwĩ: —Yʉʉ atibʉ́reco macãrãrẽ sĩãwócore tiiróbiro niiã. Yʉʉ basocáre Cõãmacʉ̃yere ãñurõ masĩrĩ tiia. Mʉ́ãmena péerogã niigʉ̃dacu. Yʉʉ ãnopʉ́ niirĩ, mʉ́ã yʉʉ buerére padeoyá. Teero tiirá, mʉ́ã wãcũña manirṍ naĩtĩãrõpʉ wáara tiiróbiro wáaricu. Yʉʉre padeohégʉno naĩtĩãrõpʉ niigʉ̃́ tiiróbiro niiĩ. Teero tiigʉ́, ãñurépere besemasĩriqui. ");
INSERT INTO tue_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉʉ sĩãwócore tiiróbiro niigʉ̃́ mʉ́ãmena niiã. Yʉʉ mʉ́ãmena niirĩ, yʉʉre padeoyá. Teero tiirá, mʉ́ãcã sĩãwócoropʉ niiãdacu; Cõãmacʉ̃yere ãñurõ masĩãdacu, jĩĩwĩ. Jesús cʉ̃́ãrẽ teero jĩĩãri siro, dutijṍãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús cʉ̃ʉ̃ tutuaremena pee tiiẽ́ñopacari, judíoare dutirá cʉ̃ʉ̃rẽ padeoríwa. ");
INSERT INTO tue_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cʉ̃́ã padeoríriguemena profeta Isaías jóarirobirora wáaro tiiwʉ́. Ateré jóarigʉ niiwĩ: Ʉ̃sã Õpʉ̃, noãnópe ʉ̃sã wederére padeorá padeojĩ́ya. Niipetira padeopetíriya. Cõãmacʉ̃ tutuaremena tiiẽ́ñorĩ ĩñapacara, padeoríya, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Teero tiirá, cʉ̃́ã padeomasĩ́riwa. Isaías atecã́rẽ jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Cõãmacʉ̃ cʉ̃́ãrẽ capeari ĩñahẽrã tiiróbiro tiiyígʉ. Cʉ̃ʉ̃yere tʉomasĩ́hẽrĩ tiiyígʉ. Teero tiirá, ãñurõ cʉ̃ʉ̃ tiirére ĩñapacara, ĩñamasĩriyira. Cʉ̃ʉ̃ buerére tʉopacára, tʉomasĩ́riyira. Cʉ̃ʉ̃ buerére padeorá niirãpeja, cʉ̃́ã ñañaré tiirére duujã́, acabóre sãĩbójĩya. Cʉ̃ʉ̃ cʉ̃́ãrẽ netõnébojĩyi, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías Jesús ʉpʉtí macʉ̃ niirére ĩñasʉgueyigʉ. Teero tiigʉ́, cʉ̃ʉ̃ye maquẽrẽ wedeseyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Teero jóari siro niipacari, paʉ judíoa, judíoare dutirápʉcã Jesuré padeomíwã. Marĩ neãrí wiipʉ niirã́rẽ cõãwionecori jĩĩrã, baurocápʉ Jesuré padeorére wedeseriwa. Fariseo basocare cuiyira. ");
INSERT INTO tue_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jesuré padeopacára, basocápere nemorṍ ãñurõ wãcũrĩ boojĩ́ya. Cõãmacʉ̃pereja “ãñuniya” jĩĩsʉguero booríjĩya. ");
INSERT INTO tue_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús bayiró bʉsʉrómena jĩĩwĩ: —Yʉʉre padeoráno yʉʉ dícʉre padeoríya; yʉʉ Pacʉ yʉʉre ticodiocorigʉcãrẽ padeoóya. ");
INSERT INTO tue_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉʉre ĩñarã́no yʉʉre ticodiocorigʉcãrẽ ĩñaãya. ");
INSERT INTO tue_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉʉ sĩãwócore tiiróbiro niiã. Atibʉ́recopʉre atiwʉ, yʉʉre padeoráno naĩtĩãrõpʉ pʉtʉárijããrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yʉʉ buerére tʉo, teeré yʉʉheranorẽ yʉʉpe ñañarõ tiiría. Yʉʉ atibʉ́recopʉ niirã́rẽ ñañarõ tiigʉ́ atiriwʉ; cʉ̃́ãrẽ netõnégʉ̃ atiwʉ ");
INSERT INTO tue_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉʉre boohérano, yʉʉ buerécãrẽ yʉʉherano ñañarõ tiinóãdarapʉ niitoaya. Atibʉ́reco petirí, yʉʉ wederé cʉ̃́ãrẽ ñañarõ wáari tiiádacu. ");
INSERT INTO tue_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉʉ booró wederia. Yʉʉ Pacʉ yʉʉre ticodiocorigʉ “teero jĩĩ wedeya” jĩĩ dutirómena wedea. ");
INSERT INTO tue_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yʉʉ masĩã: Yʉʉ Pacʉ dutirére padeorá catirucujããdacua. Teero tiigʉ́, cʉ̃ʉ̃ wededutirobirora basocáre wedea, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua bosebʉreco wáaadaro péero dʉsawʉ́. Jesús cʉ̃ʉ̃ atibʉ́recopʉ niirigʉ máata cʉ̃ʉ̃ Pacʉ pʉtopʉ wáaadarere masĩtoawi. Ʉ̃sã cʉ̃ʉ̃ buerá atibʉ́recopʉ niirã́rẽ maĩnetṍnejãwĩ. Ʉ̃sãrẽ cʉ̃ʉ̃ bayiró maĩrére ẽñoã́daro péerogã dʉsawʉ́. ");
INSERT INTO tue_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Wãtĩãrẽ dutigʉ́ Judas Iscariote (Simón macʉ̃rẽ) wãcũré ticotoarigʉ niiwĩ. Jesuré wedesãdutirigʉ niiwĩ. Jesupéja Cõãmacʉ̃ pʉtopʉ atirigue, cʉ̃ʉ̃ toopʉ́ cãmepʉtʉ́awaadarere masĩtoarigʉ niiwĩ. Teero biiri cʉ̃ʉ̃ Pacʉ cʉ̃ʉ̃rẽ niipetire dutiré ticoriguere masĩtoarigʉ niiwĩ. Teeré masĩgʉ̃, ʉ̃sã yaaduiri, wʉ̃mʉnʉcã, cʉ̃ʉ̃yaro sutiró sotoá sãñaãrirore tuuwéwi. Õpʉ̃ʉ̃ decopʉ oco tuucoséri caserore siatúwi. ");
INSERT INTO tue_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Too siro ocoré bapapʉ́ píosã, ʉ̃sãye dʉporire cosenʉcã́wĩ. Cʉ̃ʉ̃ siatúari caseromena ocoré tuucoséwi. ");
INSERT INTO tue_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cʉ̃ʉ̃ Simón Pedroye dʉporire cosegʉ́dʉ tiirí, Pedropeja cʉ̃ʉ̃rẽ jĩĩwĩ: —¿Õpʉ̃, yée dʉporire mʉʉ cosegʉ́dari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Mecʉ̃tígã yʉʉ tiirére mʉʉ tʉomasĩ́ricu; too síropʉ tʉomasĩ́gʉ̃dacu, jĩĩ yʉʉwi. ");
INSERT INTO tue_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Cʉ̃ʉ̃peja: —Yée dʉporire mʉʉ coserídojãgʉ̃dacu, jĩĩmiwĩ. —Yʉʉ mʉʉrẽ coseríatã, mʉʉ yʉʉ menamacʉ̃ niiricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro jĩĩwĩ: —Too docare yée dʉporire cosegʉ́, yée wãmorĩ, yáa dupucãrẽ coseyá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesupéja jĩĩwĩ: —Marĩ cusaári sirogã, jũĩrĩmanírã niipacara, cusanemóña manicú. Wáaari siro, dʉpori dícʉre cosenócu. Mʉ́ã jũĩrĩmanírã tiiróbiro niiã. Teero niipacari, sĩcʉ̃ mʉ́ã watoapʉre ñañagʉ̃́ jũĩrĩcʉtígʉ tiiróbiro niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús cʉ̃ʉ̃rẽ wedesãgʉ̃dʉre masĩtoarigʉ niiwĩ. Teero tiigʉ́, “sĩcʉ̃ mʉ́ã watoapʉre jũĩrĩcʉtígʉ tiiróbiro niiĩ” jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ʉ̃sãye dʉporire coseári siro, cʉ̃ʉ̃ tuuwéarirore sãña, jeanuã, ʉ̃sãrẽ jĩĩwĩ: —¿Yʉʉ mʉ́ãrẽ tiiáriguere tʉomasĩ́ĩ? ");
INSERT INTO tue_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉ́ã yʉʉre “ʉ̃sãrẽ buegʉ́”, teero biiri “ʉ̃sã Õpʉ̃” jĩĩã. Yʉʉ teerora niiã mʉ́ã jĩĩrõbirora. ");
INSERT INTO tue_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yʉʉ mʉ́ã Õpʉ̃, mʉ́ãrẽ buegʉ́ niipacʉ, mʉ́ãye dʉporire coseáwʉ̃. Teero tiirá, mʉ́ãcã teerora mʉ́ãye dʉporire cãmerĩ́ coseyá. ");
INSERT INTO tue_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʉ́ãrẽ yʉʉ tiiáriguere ĩñacũ, tiinʉnʉ́searo jĩĩgʉ̃, tee queorére tiiẽ́ñoãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Sĩcʉ̃ padecotegʉno cʉ̃ʉ̃rẽ dutigʉ́ nemorṍ niiriqui. Sĩcʉ̃ ticoconorigʉcã cʉ̃ʉ̃rẽ ticocorigʉ nemorṍ niiriqui. ");
INSERT INTO tue_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mʉ́ã yʉʉ wedeariguere masĩ, teeré tiirá, ʉseniãdacu. ");
INSERT INTO tue_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Yʉʉ mʉ́ã niipetirapʉre wederia. Yʉʉ beserirare yʉʉ masĩã. Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora diamacʉ̃́ wáaro tiiádacu. Ateré jóanoã: “Yʉʉmena yaaduiarigʉ yʉʉre ĩñatutigʉ peti niiĩ”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yʉʉ mʉ́ãrẽ wedesʉguegʉ tiia. Teero tiirá, too síro yʉʉ jĩĩãriguere diamacʉ̃́ wáari ĩñarã, “yʉʉrá niiã” jĩĩrére padeoádacu. ");
INSERT INTO tue_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉ ticocoarigʉre bocagʉ́no yʉʉcãrẽ bocagʉdaqui. Yʉʉre bocagʉ́no yʉʉre ticodiocorigʉcãrẽ bocagʉdaqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús teeré ʉ̃sãrẽ wedeari siro, bayiró wãcũpatiwi. Tʉomasĩ́rõrã wedemiwĩ: —Yʉʉ ateré diamacʉ̃́rã jĩĩã: Mʉ́ã menamacʉ̃ sĩcʉ̃ yʉʉre ĩñatutirapʉre ticogʉdaqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ʉ̃sã cãmerĩ́ ĩña, “¿noãpére teero jĩĩgʉ̃ tiii?” jĩĩmasĩriwʉ. ");
INSERT INTO tue_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉʉ Juan Jesús maĩnógʉ̃ cʉ̃ʉ̃ pʉtogã duiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Teero tiigʉ́, Simón Pedro súupuaremena yʉʉre sãĩñádutiwi: “¿Noãrẽ́ wedesegʉ tiii?” ");
INSERT INTO tue_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yʉʉ cʉ̃ʉ̃ pʉtogã munijeátua, cʉ̃ʉ̃rẽ sãĩñáwʉ̃: —¿Õpʉ̃, noã niiĩ cʉ̃ʉ̃? jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús yʉʉre jĩĩwĩ: —Yʉʉ pã soa, ticogʉ́ra niiĩ, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩãri siro, Judare (Simón Iscariote macʉ̃rẽ) soa, ticowi. ");
INSERT INTO tue_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas pãrẽ ñeeãri sirogã, Satanás cʉ̃ʉ̃rẽ sããrigʉ niiwĩ. Jesús Judare: —Mʉʉ tiiádarere máata tiisírotiya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ʉ̃sã niipetira toopʉ́ yaaduira cʉ̃ʉ̃ teero jĩĩrére tʉomasĩ́riwʉ. ");
INSERT INTO tue_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sĩquẽrã biiro wãcũwʉ̃: “Judas niyeru sã́ãripore cotegʉ́ niirĩ, cʉ̃ʉ̃rẽ apeyenó bosebʉreco maquẽrẽ sãĩdutígʉ tiiájĩyi; o bóaneõrãrẽ niyeru ticodutigʉ ticodutiajĩyi”, jĩĩ wãcũmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas pãrẽ ñeeãri sirogã, witijõãwĩ. Ñamipʉ niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas witiwari siro, Jesús ʉ̃sãrẽ jĩĩwĩ: —Mecʉ̃tígã yʉʉ niipetira sõwʉ̃ ʉpʉtí macʉ̃ niirére ẽñonóãdacu. Yʉʉmena “Cõãmacʉ̃ ʉpʉtí macʉ̃ niiĩ” jĩĩrécãrẽ ẽñonóãdacu. ");
INSERT INTO tue_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yʉʉ “Cõãmacʉ̃ ʉpʉtí macʉ̃ niiĩ” jĩĩrére ẽñorĩ́, cʉ̃ʉ̃cã yʉʉ ʉpʉtí macʉ̃ niirére máata ẽñogʉ̃́daqui. ");
INSERT INTO tue_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉʉ menamacãrã, yʉʉ péerogã mʉ́ãmena niinemogʉ̃dacu. Mʉ́ã yʉʉre ãmaãmiãdacu. Yʉʉ judíoare dutiráre jĩĩrirobirora mʉ́ãrẽ mecʉ̃tígã jĩĩã: “Yʉʉ wáaadaropʉre mʉ́ã wáamasĩricu”. ");
INSERT INTO tue_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mʉ́ãrẽ mama dutirére cṹũã: Cãmerĩ́ maĩñá; yʉʉ mʉ́ãrẽ maĩrṍbirora mʉ́ãcã cãmerĩ́ maĩñá. ");
INSERT INTO tue_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉ́ã cãmerĩ́ maĩrĩ́, ãpẽrã́ niipetira mʉ́ãrẽ yʉʉ buerá niirére masĩãdacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro cʉ̃ʉ̃rẽ sãĩñáwĩ: —Õpʉ̃, ¿noopʉ́ wáagʉdari? jĩĩwĩ. Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Mecʉ̃tígã yʉʉ wáaadaropʉre mʉʉ wáamasĩricu. Too síropʉ yʉʉre nʉnʉgʉ̃́dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedropeja cʉ̃ʉ̃rẽ sãĩñáwĩ sũcã: —Õpʉ̃, ¿deero tiigʉ́ yʉʉ mʉʉmena máata wáamasĩrigari? Mʉʉye wapamena yʉʉ diari, ãñuniãdacu, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —¿Yée wapamena diabosagʉdari? Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Cãrẽquẽ wedeadari sʉguero, yʉʉre ĩtĩã́rĩ “cʉ̃ʉ̃rẽ masĩriga” jĩĩditogʉdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús ʉ̃sãrẽ jĩĩwĩ: —Mʉ́ã bayiró wãcũpatirijãña. Cõãmacʉ̃rẽ padeoyá. Yʉʉcãrẽ padeoyá. ");
INSERT INTO tue_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉʉ Pacʉ pʉtopʉ mʉ́ã niiãdare wiseri pee niiã. Tee wiseri maniã́tã, mʉ́ãrẽ wedeboajĩyu. Toopʉ́ mʉ́ã niiãdarore quẽnosʉguégʉ wáagʉ tiia. ");
INSERT INTO tue_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mʉ́ã niiãdarore quẽnoã́ri siro, mʉ́ãrẽ néegʉ̃ atigʉda. Teero tiirá, yʉʉ niirṍpʉre mʉ́ãcã niiãdacu. ");
INSERT INTO tue_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yʉʉ wáaropʉ niirímarẽ mʉ́ã masĩcu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás cʉ̃ʉ̃rẽ jĩĩwĩ: —Õpʉ̃, mʉʉ wáaadarore masĩriga. ¿Ʉ̃sã deero tii tiimarẽ́ masĩbogari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉrá tiimá tiiróbiro niiã; basocáre diamacʉ̃́ maquẽrẽ masĩrĩ tiigʉ́ niiã; teero biiri catiré petihére ticogʉ́ niiã. Yʉʉre padeonʉnʉ́sera dícʉ yʉʉ Pacʉ pʉto jeaadacua. ");
INSERT INTO tue_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mʉ́ã yʉʉre masĩrã, yʉʉ Pacʉcãrẽ masĩãdacu. Mecʉ̃ãmena cʉ̃ʉ̃rẽ masĩã; cʉ̃ʉ̃rẽ ĩñarã́ tiiróbiro niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe Jesuré jĩĩwĩ: —Õpʉ̃, mʉʉ Pacʉre ẽñoñá ʉ̃sãrẽ. Cʉ̃ʉ̃rẽ ĩñarémena dícʉ ʉ̃sãrẽ ãñutoaadacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesupéja cʉ̃ʉ̃rẽ yʉʉwi: —Felipe, yʉʉ mʉ́ãmena yoari niiã mée. ¿Yʉʉre ĩñamasĩrii ména? Yʉʉre ĩñagʉ̃́no yʉʉ Pacʉcãrẽ ĩñaĩ. ¿Deero tiigʉ́ “mʉʉ Pacʉre ẽñoñá” jĩĩĩ? ");
INSERT INTO tue_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Yʉʉ Pacʉpʉre niiã yʉʉ; cʉ̃ʉ̃ yʉʉpʉre niiĩ” jĩĩrére ¿padeoríi? Yʉʉ mʉ́ãrẽ wederére yʉʉ booró wederia. Yʉʉ Pacʉ yʉʉpʉre niigʉ̃́rã yʉʉmena cʉ̃ʉ̃ booró tiii. ");
INSERT INTO tue_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Yʉʉ Pacʉpʉre niiã yʉʉ” jĩĩrére padeoyá. Teero biiri “yʉʉ Pacʉ yʉʉpʉre niiĩ” jĩĩrécãrẽ padeoyá. Mʉ́ã teeré padeomasĩ́hẽrã, yʉʉ tiirépere yʉʉ Pacʉ tutuaremena tiirí ĩña, padeosãñúña. ");
INSERT INTO tue_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Yʉʉre padeoráno yʉʉ tiirírobirora tiinʉnʉ́seadacua. Yʉʉ Pacʉ niirṍpʉ yʉʉ wáagʉda. Teero tiirá, yʉʉre padeoráno yʉʉ tiiríro nemorṍ tiiádacua. ");
INSERT INTO tue_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Niipetire mʉ́ã sãĩrére yʉʉ wãmemena sãĩrĩ́, tiigʉ́da. Yʉʉ teeré tiigʉ́, yʉʉ Pacʉ ʉpʉtí macʉ̃ niirére ẽñogʉ̃́dacu. ");
INSERT INTO tue_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉʉ wãmemena mʉ́ã sãĩrénorẽ tiigʉ́da. ");
INSERT INTO tue_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Mʉ́ã yʉʉre maĩrã́, yʉʉ dutirére tiiádacu. ");
INSERT INTO tue_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mʉ́ãrẽ yʉʉ Pacʉre sãĩboságʉda. Yʉʉ sãĩrĩ́, cʉ̃ʉ̃ mʉ́ãrẽ ãpĩ tiiápugʉdʉre ticodiocogʉdaqui. Mʉ́ãmena niirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cʉ̃ʉ̃rã́ Espíritu Santo, diamacʉ̃́ maquẽrẽ wedegʉ́ niiĩ. Atibʉ́reco macãrã cʉ̃ʉ̃rẽ ĩñaricua; cʉ̃ʉ̃rẽ masĩricua. Teero tiirá, cʉ̃ʉ̃rẽ boorícua. Mʉ́ãpeja cʉ̃ʉ̃rẽ masĩã. Cʉ̃ʉ̃ mʉ́ãmena niiĩ; mʉ́ãpʉre niirucujãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Yʉʉ mʉ́ãrẽ cõãwaricu. Mʉ́ãmena niigʉ̃ atigʉda sũcã. ");
INSERT INTO tue_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Péero dʉsaa yʉʉ wáaadaro. Yʉʉ wáari siro, atibʉ́reco macãrã yʉʉre ĩñariadacua. Mʉ́ãpeja ĩñaãdacu. Yʉʉ catirucujãã; teero tiirá, mʉ́ãcã catirucujããdacu. ");
INSERT INTO tue_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yʉʉ Pacʉ mʉ́ãrẽ Espíritu Santore ticodiocoari siro, “yʉʉ Pacʉpʉre yʉʉ niiã” jĩĩrére masĩãdacu. Teero biiri “mʉ́ã yʉʉpʉre niiã; yʉʉ mʉ́ãpʉre niiã” jĩĩrécãrẽ masĩãdacu. ");
INSERT INTO tue_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉʉ dutirére tiigʉ́no yʉʉre maĩgʉ̃́rã niiqui. Yʉʉre maĩgʉ̃́norẽ yʉʉ Pacʉ maĩgʉ̃́daqui. Yʉʉcã cʉ̃ʉ̃rẽ maĩgʉ̃́dacu; yʉʉ niirecʉtirere ẽñogʉ̃́dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ãpĩ Judas (Iscariote niihẽgʉ̃pe) Jesuré jĩĩwĩ: —Õpʉ̃, ¿deero tiigʉ́ mʉʉ niirecʉtirere ʉ̃sã dícʉre ẽñogʉ̃́dari? ¿Deero tiigʉ́ atibʉ́reco macãrãrẽ ẽñorígari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉre maĩrã́no yʉʉ wedeseri tʉonʉnʉ́secua. Yʉʉ Pacʉ cʉ̃́ãrẽ maĩgʉ̃́daqui. Ʉ̃sã pʉarã́pʉra cʉ̃́ãmena niiãdacu. ");
INSERT INTO tue_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉʉre maĩhẽ́rãnopeja yʉʉ wederére tʉorícua. Yʉʉ wederé yée mee niiã; yʉʉ Pacʉ yʉʉre ticodiocorigʉ wededutire niiã. ");
INSERT INTO tue_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Yʉʉ mʉ́ãmena niiã ména; teero tiigʉ́, teeré mʉ́ãrẽ wedea. ");
INSERT INTO tue_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Too síro yʉʉ Pacʉ Espíritu Santore yʉʉ wãmemena ticodiocogʉdaqui. Cʉ̃ʉ̃ mʉ́ãrẽ tiiápugʉ niigʉ̃daqui. Cʉ̃ʉ̃ niipetirere mʉ́ãrẽ buegʉdaqui. Niipetire yʉʉ mʉ́ãrẽ bueriguere teero wãcũrĩ tiirucújãgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yʉʉ mecʉ̃tígã mʉ́ãrẽ “wáagʉ tiia” jĩĩgʉ̃da. Ãñurõ niirecʉtire mʉ́ãmena niiãrõ. Yʉʉ ãñurõ niirecʉtirere cʉoa. Teeré mʉ́ãcãrẽ ticoa. Atibʉ́reco macãrã ãñurõ niirecʉtirere ticooya, ticorapeja. Yʉʉ cʉ̃́ã ticoré tiiróbiro ticoria. Teero tiirá, wãcũpatirijãña; cuirijãña. ");
INSERT INTO tue_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yʉʉ Pacʉ pʉtopʉ wáagʉ tiia” jĩĩrĩ, mʉ́ã tʉotóaawʉ̃. “Too síro yʉʉ mʉ́ãmena niigʉ̃ atigʉda sũcã” jĩĩrĩcãrẽ tʉoáwʉ̃. Yʉʉ Pacʉ yʉʉ nemorṍ niiĩ. Teero tiirá, “yʉʉ Pacʉ pʉtopʉ wáagʉ tiia” jĩĩrĩ tʉojĩ́rã, yʉʉre diamacʉ̃́rã maĩrã́, ʉseniboajĩyu. ");
INSERT INTO tue_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yʉʉ mʉ́ãrẽ wedesʉguegʉ tiia. Teero tiirá, yʉʉ mʉ́ãrẽ wedesʉgueriguere queoró wáari, “diamacʉ̃́rã jĩĩyi” jĩĩãdacu. ");
INSERT INTO tue_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Wãtĩãrẽ dutigʉ́ atibʉ́reco macãrãrẽ dutigʉ́ atitoaqui mée. Teero tiigʉ́, yʉʉ mʉ́ãmena péero wedesegʉda. Cʉ̃ʉ̃ yʉʉre péerogã netõnʉcã́masĩripacʉ, dutimigʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉʉpeja cʉ̃ʉ̃rẽ tʉoría. Yʉʉ Pacʉ dutirépere tiia, atibʉ́reco macãrã “yʉʉ Pacʉre maĩã” jĩĩrére masĩãrõ jĩĩgʉ̃. Wʉ̃mʉnʉcãña. Jãmʉ, wáaco, jĩĩwĩ ʉ̃sãrẽ. ");
INSERT INTO tue_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús queorémena ʉ̃sãrẽ wedewi: —Yʉʉ ʉsegʉ peti tiiróbiro niiã. Yʉʉ Pacʉ tiigʉré cotegʉ́ tiiróbiro niiĩ. ");
INSERT INTO tue_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yée dʉpʉri dʉcamanire dʉpʉrire páatacõãjãĩ. Dʉcacʉtire dʉpʉripere nemorṍ dʉcacʉtiaro jĩĩgʉ̃, ñañaré dʉpʉrire páatawenemoqui. ");
INSERT INTO tue_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yʉʉ mʉ́ãrẽ wederémena ñañaré dʉpʉrire páatawenorira tiiróbiro niiã. ");
INSERT INTO tue_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉʉmena niirucujãña yʉʉ mʉ́ãmena niirucujãrõbirora. Sicadʉpʉ ʉsegʉpʉ niirucuripacaro, dʉcacʉtiricu. Ate tiiróbiro mʉ́ã yʉʉmena niirucuripacara, ãñuré tiimasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yʉʉ ʉsegʉ tiiróbiro niiã. Mʉ́ã tiigʉ́ dʉpʉri niiã. Yʉʉmena niirucurano yʉʉ cʉ̃́ãmena niirĩ, pee ãñuré tiimasĩ́cua. Mʉ́ã yʉʉmena niihẽrã, ãñuré tiimasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yʉʉmena niihẽrãno páatare dʉpʉri tiiróbiro cõãnoãdacua. Páatacõãre dʉpʉri sĩnijṍãcu. Sĩniré dʉpʉrire see, pecamepʉ sóecõãnocu. ");
INSERT INTO tue_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mʉ́ã yʉʉmena niirĩ, yʉʉ buerére wãcũrĩ, Cõãmacʉ̃ mʉ́ã cʉ̃ʉ̃rẽ sãĩrénorẽ wáari tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mʉ́ã pee ãñuré tiirémena “Cõãmacʉ̃ ãñunetõjõãĩ” jĩĩrére ẽñoã́dacu. Teero biiri “mʉ́ã yʉʉ buerá niiã” jĩĩrére ẽñoã́dacu. ");
INSERT INTO tue_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉʉ Pacʉ yʉʉre maĩrṍbirora yʉʉcã mʉ́ãrẽ maĩã. Teero tiirá, yʉʉ mʉ́ãrẽ maĩrére masĩjĩrã, yʉʉre maĩrucújãña. ");
INSERT INTO tue_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉʉ Pacʉ dutirére yʉʉ tiiwʉ́; cʉ̃ʉ̃ yʉʉre maĩrucúi. Cʉ̃ʉ̃ tiiróbirora mʉ́ã yʉʉ dutirére tiirí, yʉʉcã mʉ́ãrẽ maĩrucúgʉdacu. ");
INSERT INTO tue_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Yʉʉ ʉsenirõbirora mʉ́ãrẽ ʉseniãrõ jĩĩgʉ̃, teeré wedea. Teero tiirá, mʉ́ã ʉseninetõjõããdacu. ");
INSERT INTO tue_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yʉʉ dutiré ate niiã: Yʉʉ mʉ́ãrẽ maĩrṍbirora cãmerĩ́ maĩñá. ");
INSERT INTO tue_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sĩcʉ̃ cʉ̃ʉ̃ menamacãrãrẽ diabosagʉno cʉ̃́ãrẽ maĩnetṍnequi; nemorṍ maĩmasĩ́ña maniã. ");
INSERT INTO tue_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mʉ́ã yʉʉ dutirére tiirá, yʉʉ menamacãrã niiã. ");
INSERT INTO tue_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yʉʉ mʉ́ãrẽ “yʉʉre padecotera niiĩya” jĩĩnemoricu. Padecotera cʉ̃́ãrẽ dutigʉ́ tiirére masĩricua. Niipetire yʉʉ Pacʉ yʉʉre jĩĩriguere mʉ́ãrẽ wedepetijãã. Teero tiigʉ́, mʉ́ãrẽ “yʉʉ menamacãrã niiĩya” jĩĩã. ");
INSERT INTO tue_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉ́ã yʉʉre beseriwʉ; yʉʉpe mʉ́ãrẽ besewʉ. Mʉ́ã yʉʉ boorére tiiáro jĩĩgʉ̃, teero biiri mʉ́ã tiiré petiríjããrõ jĩĩgʉ̃, mʉ́ãrẽ besewʉ. Mʉ́ã yʉʉ boorére tiirí, mʉ́ã yʉʉ wãmemena yʉʉ Pacʉre sãĩrénorẽ cʉ̃ʉ̃ ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ateré mʉ́ãrẽ dutia: Cãmerĩ́ maĩñá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús ʉ̃sãrẽ jĩĩnemowĩ: —Atibʉ́reco macãrã mʉ́ãrẽ ĩñatutiri, yʉʉre ĩñatutisʉgueriguere wãcũña. ");
INSERT INTO tue_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mʉ́ã atibʉ́reco macãrã peti niiãtã, cʉ̃́ã menamacãrãrẽ maĩrṍbirora mʉ́ãcãrẽ maĩbócua. Yʉʉ mʉ́ãrẽ cʉ̃́ã watoapʉ niirã́rẽ besewʉ. Yʉʉ besenorira niijĩrã, atibʉ́reco macãrã peti niiria. Teero tiirá, cʉ̃́ã mʉ́ãrẽ ĩñatutiya. ");
INSERT INTO tue_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yʉʉ mʉ́ãrẽ jĩĩriguere wãcũña: Sĩcʉ̃ padecotegʉno cʉ̃ʉ̃rẽ dutigʉ́ nemorṍ niiriqui. Yʉʉre ñañarõ tiirá, mʉ́ãcãrẽ teerora ñañarõ tiiádacua. Yʉʉ wederi tʉorá, mʉ́ãcãrẽ tʉoádacua. ");
INSERT INTO tue_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mʉ́ã yʉʉre nʉnʉrĩ́ ĩñarã, tee niipetire ñañarére mʉ́ãrẽ tiiádacua. Yʉʉre ticodiocorigʉre cʉ̃́ã masĩhẽre wapa teero tiiádacua. ");
INSERT INTO tue_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Yʉʉ cʉ̃́ãrẽ wedegʉ atiriatã, wapa cʉoríbocua. Cʉ̃́ã mecʉ̃tígãrẽ deero jĩĩmasĩricua; wapa cʉojã́ya. ");
INSERT INTO tue_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉʉre ĩñatutirano yʉʉ Pacʉcãrẽ ĩñatutiya. ");
INSERT INTO tue_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cʉ̃́ã pʉtopʉre pee ĩñaña manirére tiiẽ́ñomiwʉ̃. Yʉʉ tiiẽ́ñohẽri siro niiãtã, wapa cʉoríbocua. Cʉ̃́ã yʉʉ tiiríguere ĩñawã. Teeré ĩñapacara, yʉʉre ĩñatutiwa. Teero biiri yʉʉ Pacʉcãrẽ ĩñatutiwa. ");
INSERT INTO tue_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cʉ̃́ã teero tiirémena Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora diamacʉ̃́ wáaro tiia. Ateré jóanoã: “Bʉ́ri peti yʉʉre ĩñatutiwa”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Espíritu Santo mʉ́ãrẽ tiiápugʉ atigʉdaqui. Cʉ̃ʉ̃ diamacʉ̃́ maquẽrẽ wedegʉ́ niiĩ. Cʉ̃ʉ̃rẽ yʉʉ Pacʉmena niigʉ̃́rẽ ticodiocogʉdacu. Cʉ̃ʉ̃ atigʉ, yée maquẽrẽ mʉ́ãrẽ wedegʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mʉ́ãcã yʉʉ buenʉcãripʉra yʉʉmena niiwʉ̃. Teero tiirá, yée maquẽrẽ wedeadacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús ʉ̃sãrẽ jĩĩnemowĩ sũcã: —Tee niipetirere mʉ́ãrẽ wedeawʉ̃, yʉʉre padeodúrijããrõ jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judíoare dutirá mʉ́ãrẽ cʉ̃́ã neãré wiseripʉ niirã́rẽ cõãwionecoadacua. Too síro mʉ́ãrẽ sĩãcõã́rã, “marĩ Cõãmacʉ̃ booró tiirá tiia” jĩĩ wãcũmiãdacua. ");
INSERT INTO tue_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cʉ̃́ã yʉʉ Pacʉre, teero biiri yʉʉre masĩrijĩrã, mʉ́ãrẽ teero tiiádacua. ");
INSERT INTO tue_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yʉʉ mʉ́ãrẽ wedesʉguegʉ tiia. Teero tiirá, diamacʉ̃́ teero wáari, mʉ́ã “teerora jĩĩwĩ” jĩĩ wãcũãdacu. ’Yʉʉ mʉ́ãmena niijĩgʉ̃, sicatopʉre máata teeré wederiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mecʉ̃tígã yʉʉre ticodiocorigʉ pʉtopʉ wáagʉ tiia. Yʉʉ teeré jĩĩpacari, mʉ́ã sĩcʉ̃nopera yʉʉre “¿noopʉ́ wáai?” jĩĩ sãĩñária. ");
INSERT INTO tue_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yʉʉ jĩĩãriguere tʉojĩ́rã, bóaneõrã niijãã. ");
INSERT INTO tue_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yʉʉ mʉ́ãrẽ diamacʉ̃́ maquẽrẽ jĩĩã: Yʉʉ wáari, mʉ́ãrẽ nemorṍ ãñuãdacu. Yʉʉ wáariatã, mʉ́ãrẽ tiiápugʉ atiriqui. Yʉʉ wáagʉ, cʉ̃ʉ̃rẽ mʉ́ãrẽ ticodiocogʉdacu. ");
INSERT INTO tue_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cʉ̃ʉ̃ atigʉ, atibʉ́reco macãrãrẽ cʉ̃́ã ñañaré tiirére tʉomasĩ́rĩ tiigʉ́daqui. Diamacʉ̃́ maquẽrẽ tʉomasĩ́rĩ tiigʉ́daqui. Teero biiri cʉ̃́ã ñañaré tiiré wapa Cõãmacʉ̃ cʉ̃́ãrẽ ñañarõ tiiádarecãrẽ tʉomasĩ́rĩ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Espíritu Santo cʉ̃́ãrẽ cʉ̃́ã ñañaré tiirére masĩãrõ jĩĩgʉ̃, ateré tʉomasĩ́rĩ tiigʉ́daqui: Cʉ̃́ã yʉʉre padeohére wapa ñañaré tiirá niicua sáa. ");
INSERT INTO tue_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Diamacʉ̃́ tiirécãrẽ masĩãrõ jĩĩgʉ̃, ateré tʉomasĩ́rĩ tiigʉ́daqui: Yʉʉ diamacʉ̃́ tiigʉ́ niijĩgʉ̃, yʉʉ Pacʉ pʉtopʉ wáaa. Toopʉ́ wáari, mʉ́ã yʉʉre ĩñanemoricu sáa. ");
INSERT INTO tue_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Teero biiri “Cõãmacʉ̃ ñañaré tiiráre ñañarõ tiigʉ́daqui” jĩĩrécãrẽ masĩãrõ jĩĩgʉ̃, ateré cʉ̃́ãrẽ tʉomasĩ́rĩ tiigʉ́daqui: Wãtĩãrẽ dutigʉ́ ñañarõ tiinógʉ̃dʉ niitoai. ");
INSERT INTO tue_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yʉʉ mʉ́ãrẽ pee wededʉgamiga. Mecʉ̃tígã wederi, mʉ́ã tʉomasĩ́ribocu. ");
INSERT INTO tue_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Espíritu Santope atigʉ, niipetire diamacʉ̃́ maquẽrẽ mʉ́ãrẽ wedegʉdaqui. Cʉ̃ʉ̃ diamacʉ̃́ maquẽrẽ wedegʉ́ niiĩ. Cʉ̃ʉ̃ wãcũrémena wederiqui; yʉʉ Pacʉ wederi tʉogʉ́, wedegʉdaqui. Too síropʉ wáaadarecãrẽ mʉ́ãrẽ wedegʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yéere mʉ́ãrẽ masĩrĩ tiigʉ́daqui. Cʉ̃ʉ̃ teero masĩrĩ tiirémena mʉ́ã yʉʉre nemorṍ padeoádacu. ");
INSERT INTO tue_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Niipetire yʉʉ Pacʉ cʉoré yée niiã. Teero tiigʉ́, ateré mʉ́ãrẽ wedetoaawʉ̃: Espíritu Santo yéere mʉ́ãrẽ masĩrĩ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Péerogã siro mʉ́ã yʉʉre ĩñaricu; too síro yʉʉre ĩñaãdacu sũcã, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ʉ̃sã sĩquẽrã cãmerĩ́ sãĩñáwʉ̃: —Cʉ̃ʉ̃ “péerogã siro mʉ́ã yʉʉre ĩñaricu; too síro yʉʉre ĩñaãdacu sũcã” jĩĩrére tʉoríga. Teero biiri “yʉʉ Pacʉ pʉtopʉ wáaa” jĩĩrécãrẽ tʉoríga. ");
INSERT INTO tue_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Cʉ̃ʉ̃ “péerogã siro” jĩĩré ¿deero jĩĩdʉgaro tiigári? Ñeenórẽ wedesegʉ wedesequi, masĩriga, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ʉ̃sã cʉ̃ʉ̃rẽ sãĩñádʉgarere masĩjĩgʉ̃, ʉ̃sãrẽ jĩĩwĩ: —“Péerogã siro mʉ́ã yʉʉre ĩñaricu; too síro yʉʉre ĩñaãdacu sũcã”, jĩĩãwʉ̃. ¿Teeré cãmerĩ́ sãĩñárã tiii? ");
INSERT INTO tue_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã uti, boorituara niiãdacu. Atibʉ́reco macãrãpe ʉseniãdacua. Mʉ́ã bóaneõmiãdacu. Bóaneõrã niimiãrira ʉseniãdacu. ");
INSERT INTO tue_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Queorémena wedegʉda: Sĩcõ niipacó coo wĩmagʉ̃ apaadari sʉguerogã, bayiró pũninogõ, bóaneõco. Coo apaari siro, coo macʉ̃ bauári ĩñagõ, ʉsenigõ, coore pũniãriguere wãcũrico. ");
INSERT INTO tue_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Coo tiiróbiro mʉ́ã mecʉ̃tígã bóaneõmiã. Too síro yʉʉ mʉ́ãrẽ ĩñagʉ̃da sũcã. Toorá mʉ́ã ʉseninetõjõããdacu. Sĩcʉ̃no mʉ́ã ʉsenirere petirí tiimasĩ́riqui. ");
INSERT INTO tue_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Teero wáaadari bʉreco jeari, yʉʉre sãĩñáriadacu. Yʉʉ ateréja diamacʉ̃́rã jĩĩã: Mʉ́ã yʉʉ wãmemena yʉʉ Pacʉre sãĩrénorẽ cʉ̃ʉ̃ ticogʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mʉ́ã yʉʉ wãmemena sãĩría ména. Sãĩñá. Mʉ́ã sãĩrã́, bʉaádacu. Teeména bayiró ʉseniãdacu. ");
INSERT INTO tue_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Yʉʉ mʉ́ãrẽ pee queorémena wedewʉ. Too síro queoré manirṍ tʉomasĩ́rõrã yʉʉ Pacʉye maquẽrẽ wedegʉdacu. ");
INSERT INTO tue_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Teero wáaadari bʉreco jeari, mʉ́ã yʉʉ wãmemena yʉʉ Pacʉre sãĩã́dacu. Yʉʉ teero jĩĩgʉ̃, “yʉʉ Pacʉre mʉ́ãrẽ sãĩboságʉda” jĩĩgʉ̃ mee tiia. ");
INSERT INTO tue_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Cʉ̃ʉ̃rã́ mʉ́ãrẽ maĩĩ. Biiro biia: Mʉ́ã yʉʉre maĩã. Teero biiri mʉ́ã yʉʉre “Cõãmacʉ̃ pʉtopʉ atirigʉ niiĩ” jĩĩ padeóa. Teero tiigʉ́, Cõãmacʉ̃ mʉ́ãrẽ maĩjĩ́gʉ̃, mʉ́ãrẽ yʉʉgʉdaqui. ");
INSERT INTO tue_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉʉ Pacʉmena niirigʉ atibʉ́recopʉre atiwʉ. Ãnopʉ́ niiãrigʉ yʉʉ Pacʉ pʉtopʉ coepʉtʉ́awagʉda sũcã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ʉ̃sã cʉ̃ʉ̃rẽ jĩĩwʉ̃: —Mecʉ̃tígãrẽ mʉʉ queorémena wederipacʉ, tʉomasĩ́rõrã wedejãã. ");
INSERT INTO tue_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mecʉ̃tígã ʉ̃sã masĩã: Mʉʉ niipetirere masĩpetijãã. Ʉ̃sã mʉʉrẽ sãĩñáãdari sʉguero, masĩtoaa. Teero tiirá, mʉʉ “Cõãmacʉ̃ pʉtopʉ atirigʉ niiã” jĩĩrére padeóa, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús ʉ̃sãrẽ jĩĩwĩ: —¿Niirṍrã; mʉ́ã padeói? ");
INSERT INTO tue_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mʉ́ã dutiwáadaro jearo tiia; jeatoaa mée. Mʉ́ã sĩquẽrã wáabateadacu. Yʉʉre sĩcʉ̃rã cõãnʉcõãdacu. Sĩcʉ̃rã niiria, niigʉ̃peja. Yʉʉ Pacʉ yʉʉmena niiĩ. ");
INSERT INTO tue_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yʉʉ mʉ́ãrẽ yʉʉmena ãñurõ niirecʉtire cʉoáro jĩĩgʉ̃, tee niipetirere wedeawʉ̃. Mʉ́ã atibʉ́recopʉre ñañarõ netõã́dacu. Yʉʉ atibʉ́reco maquẽrẽ docacũmurĩ tiitóawʉ. Teero tiirá, wãcũtutuaya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús teero jĩĩãri siro, ĩñamʉõco, jĩĩwĩ: —Pacʉ, mʉʉ “teero wáaadacu” jĩĩrí bʉreco jeatoaa mée. Basocáre ẽñoñá yʉʉ mʉʉ macʉ̃ ʉpʉtí macʉ̃ niirére. Mʉʉ teero tiirí, yʉʉ mʉʉ ʉpʉtí macʉ̃ niirére ẽñogʉ̃́dacu. ");
INSERT INTO tue_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mʉʉ yʉʉre dutirére ticowʉ. Teeména basocá niipetirare dutimasĩã. Teero tiigʉ́, niipetira mʉʉ yʉʉre ticorirare catiré petihére ticomasĩã. ");
INSERT INTO tue_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Cʉ̃́ã mʉʉ diamacʉ̃́ niigʉ̃́rẽ sĩcʉ̃ niigʉ̃́rẽ masĩrã́, teero biiri yʉʉ Jesucristo mʉʉ ticodiocorigʉcãrẽ masĩrã́ catiré petihére cʉoádacua. ");
INSERT INTO tue_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Mʉʉ yʉʉre tiidutírere tiipetíjãwʉ̃. Teeména yʉʉ atibʉ́recopʉre mʉʉ ʉpʉtí macʉ̃ niirére ẽñowʉ̃́. ");
INSERT INTO tue_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pacʉ, atibʉ́reco tiiádari sʉguero, yʉʉ mʉʉmena niiwʉ̃. Mʉʉmena niigʉ̃, mʉʉ tiiróbiro ʉpʉtí macʉ̃ niiwʉ̃. Mecʉ̃tígãrẽ mʉʉ niirṍpʉ niigʉ̃dacu sũcã. Yʉʉre ʉpʉtí macʉ̃ niirére ticoya sũcã. ");
INSERT INTO tue_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mʉʉ ãniãrẽ yʉʉre ticowʉ. Cʉ̃́ã atibʉ́reco macãrã watoapʉ niirira niiwã. Mʉʉ niirecʉtirere cʉ̃́ãrẽ masĩrĩ tiiwʉ́. Cʉ̃́ã mʉʉyara niirirare yʉʉre ticowʉ. Cʉ̃́ã mʉʉ wedecorere ãñurõ tʉojĩ́rã, yʉʉwa. ");
INSERT INTO tue_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mecʉ̃tígãrẽ cʉ̃́ã ateré masĩĩya: Niipetire yʉʉ niirecʉtire mʉʉ ticorigue niiã. ");
INSERT INTO tue_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉʉ yʉʉre wederiguere cʉ̃́ãrẽ wedewʉ. Cʉ̃́ã teeré padeowá. Cʉ̃́ã diamacʉ̃́rã yʉʉ mʉʉ pʉtopʉ atiriguere padeowá. Teero biiri mʉʉ yʉʉre ticodiocoriguecãrẽ padeowá. ");
INSERT INTO tue_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Yʉʉ cʉ̃́ãye niiãdarere mʉʉrẽ sãĩã. Atibʉ́reco macãrãpereja sãĩbosária. Yʉʉre mʉʉ ticorirapere sãĩbosáa; cʉ̃́ã mʉʉyara niiĩya. ");
INSERT INTO tue_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Niipetira mʉʉyara, yáara niiĩya. Yáaracã mʉʉyara niiĩya. Cʉ̃́ã tiirémena, cʉ̃́ã padeorémena yʉʉ ʉpʉtí macʉ̃ niirére masĩrĩ tiia. ");
INSERT INTO tue_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yʉʉ mʉʉ pʉtopʉ wáagʉdʉ tiia; atibʉ́recopʉ pʉtʉáricu. Yʉʉ buerápeja pʉtʉáadacua. Pacʉ ãñugʉ̃́, mʉʉ tutuaremena mʉʉ yʉʉre ticorirare coteya. Mʉʉ teero tiirí, marĩ sĩcãrõména niirõbirora cʉ̃́ãcã sĩcãrõména niiãdacua. ");
INSERT INTO tue_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yʉʉ cʉ̃́ãmena niigʉ̃, mʉʉ tutuare ticoriguemena cʉ̃́ãrẽ cotewʉ. Sĩcʉ̃norẽ ditiri tiiríwʉ. Mʉʉye queti jóaripũpʉ jĩĩrõbirora diamacʉ̃́ wáaro tiiwʉ́: “Ditigʉdaqui” jĩĩrigʉ dícʉ ditiwi. ");
INSERT INTO tue_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Mecʉ̃tígã yʉʉ mʉʉ pʉtopʉ wáagʉdʉ tiia. Yʉʉ atibʉ́recopʉ niigʉ̃, mʉʉye quetire wedea. Cʉ̃́ã yʉʉ tiiróbiro ʉseniãrõ jĩĩgʉ̃, wedea. ");
INSERT INTO tue_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉʉ wederiguere cʉ̃́ãrẽ wedewʉ. Cʉ̃́ã yʉʉ tiiróbiro atibʉ́reco macãrã peti niiriya. Teero tiirá, atibʉ́reco macãrã cʉ̃́ãrẽ ĩñatutiya. ");
INSERT INTO tue_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Cʉ̃́ã atibʉ́reco macãrã watoapʉ niirã́rẽ mʉʉ pʉtopʉ máata néewaya”, jĩĩ sãĩría. Atepére sãĩã: “Wãtĩãrẽ dutigʉ́re cãmotáya cʉ̃́ãrẽ”, jĩĩã. ");
INSERT INTO tue_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yʉʉ atibʉ́reco macʉ̃ peti niiria. Teero tiiróbiro cʉ̃́ãcã atibʉ́reco macãrã peti niiriya. ");
INSERT INTO tue_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉʉ wederé diamacʉ̃́ maquẽ niiã. Teeména cʉ̃́ãrẽ mʉʉ booré tiiádara peti wáari tiiyá. ");
INSERT INTO tue_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yʉʉre mʉʉye quetire atibʉ́reco macãrãrẽ wededutigʉ ticodiocowʉ. Teero tiiróbiro yʉʉcã cʉ̃́ãrẽ atibʉ́reco macãrãrẽ wededutigʉ ticocoa. ");
INSERT INTO tue_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cʉ̃́ãye niiãdarere tiigʉ́, yʉʉ mʉʉ booróbirora tiia. Cʉ̃́ãcã mʉʉ booróbiro tiiáro jĩĩgʉ̃, cʉ̃́ã diamacʉ̃́ maquẽrẽ masĩnemoãrõ jĩĩgʉ̃, teero tiia. ");
INSERT INTO tue_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Yʉʉ cʉ̃́ã dícʉre sãĩbosária. Too síropʉ cʉ̃́ã wederi tʉo, yʉʉre padeoádaracãrẽ sãĩbosáa. ");
INSERT INTO tue_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cʉ̃́ã sĩcãrõména niiãrõ jĩĩgʉ̃, sãĩã. Pacʉ, mʉʉ yʉʉmena niirõbirora yʉʉcã mʉʉmena niiã. Cʉ̃́ãcã marĩmena niiãrõ. Teero wáari ĩñarã, atibʉ́reco macãrã “yʉʉ mʉʉ ticodiocorigʉ niiã” jĩĩrére padeoádacua. ");
INSERT INTO tue_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mʉʉ yʉʉre ʉpʉtí macʉ̃ niirére ticowʉ. Yʉʉcã cʉ̃́ãrẽ teerá ticowʉ, cʉ̃́ã sĩcãrõména niiãrõ jĩĩgʉ̃. Marĩ sĩcãrõména niirõbirora cʉ̃́ãcã sĩcãrõména niiãrõ. ");
INSERT INTO tue_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉʉ cʉ̃́ãmena niirĩ, mʉʉ yʉʉmena niirõbirora cʉ̃́ãcã sĩcãrõména niiãdacua. Teero wáari ĩñarã, atibʉ́reco macãrã ateré masĩãdacua: Mʉʉ cʉ̃́ãrẽ maĩã yʉʉre maĩrṍbirora; teero biiri “yʉʉ mʉʉ ticodiocorigʉ niiã” jĩĩrére masĩãdacua. ");
INSERT INTO tue_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Atibʉ́reco tiiádari sʉguero, mʉʉ yʉʉre maĩwʉ̃́. Teero tiigʉ́, mʉʉ ʉpʉtí macʉ̃ niirére yʉʉre ticowʉ. Pacʉ, mʉʉ yʉʉre ticorirare yʉʉmena niirĩ boogá. Yʉʉmena niirã, yʉʉ ʉpʉtí macʉ̃ niirére ĩñaãdacua. ");
INSERT INTO tue_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pacʉ, mʉʉ diamacʉ̃́ tiigʉ́ niiã. Atibʉ́reco macãrã mʉʉrẽ masĩriya; yʉʉpe mʉʉrẽ masĩã. Ãniã yʉʉ buerá mʉʉ yʉʉre ticodiocoriguere masĩĩya. ");
INSERT INTO tue_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉʉ niirecʉtirere cʉ̃́ãrẽ masĩrĩ tiiwʉ́; teero masĩrĩ tiirucújãgʉ̃da. Yʉʉ teero tiirucúri, mʉʉ yʉʉre maĩrṍbirora cʉ̃́ãcã cãmerĩ́ maĩã́dacua; teero biiri yʉʉ cʉ̃́ãmena niigʉ̃dacu, jĩĩ sãĩwĩ́. ");
INSERT INTO tue_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús cʉ̃ʉ̃ Pacʉre sãĩã́ri siro, ʉ̃sã Jerusalénpʉ niiãrira witiwawʉ. Cedrón wãmecʉtirimaarẽ tĩãwawʉ. Tiimaá apeniñapʉ́ olivo yucʉre cʉ̃́ã oteriropʉ jeawʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas Jesuré ticogʉdʉ olivo niirṍrẽ masĩtoarucuwi. Jesús too sʉgueropʉre ʉ̃sãrẽ toopʉ́ dícʉ sʉowárucuwi. ");
INSERT INTO tue_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Teero tiigʉ́, suraramena Judas jeawi. Ãpẽrã́ sĩquẽrã Cõãmacʉ̃wii coterí basoca cʉ̃́ãmena jeawa. Paiaré dutirá, fariseo basoca cʉ̃́ãrẽ ticocorira niiwã. Cʉ̃́ã ãñurõ wãmocʉtírirapʉ niiwã. Sĩãwócore yucʉ, sĩãwócorepamena atirira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús cʉ̃ʉ̃rẽ wáaadarere masĩtoarigʉ niiwĩ. Teero tiigʉ́, sʉguewa, sãĩñáwĩ: —¿Noãrẽ́ ãmaãĩ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazaret macʉ̃rẽ ãmaãã, jĩĩwã. —Yʉʉrá niiã, jĩĩwĩ. Judas Jesuré wedesãrigʉcã cʉ̃́ãmena niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús “yʉʉrá niiã” jĩĩrĩ tʉorá, cʉ̃́ã dúudicʉtʉa, ñaacũmujõãwã. ");
INSERT INTO tue_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús sãĩñáwĩ sũcã: —¿Noãrẽ́ ãmaãĩ? jĩĩwĩ. —Jesús Nazaret macʉ̃rẽ ãmaãã, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Mʉ́ãrẽ wedetoaawʉ̃ mée: Yʉʉrá niiã. Too docare yʉʉre ãmaãrãjã, ãniãpereja “wáaya” jĩĩña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesús cʉ̃ʉ̃ Pacʉre wedesearigue diamacʉ̃́ wáaaro jĩĩgʉ̃, teeré jĩĩwĩ. Cʉ̃ʉ̃ biiro wedesewi cʉ̃ʉ̃ Pacʉre: “Mʉʉ yʉʉre ticorirare sĩcʉ̃no ditiri tiiríwʉ”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Too síro Simón Pedro cʉ̃ʉ̃ya espadare néewionecowi. Paiaré dutigʉ́re padecotegʉre diamacʉ̃́ macã cãmopérore páatacojãwĩ. Cʉ̃ʉ̃ wãmecʉtiwi Malco. ");
INSERT INTO tue_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Cʉ̃ʉ̃ teero tiirí ĩñagʉ̃, Jesupé Pedrore jĩĩwĩ: —Mʉʉyapĩrẽ quẽnocṹña. Yʉʉ Pacʉ yʉʉre ñañarõ netõdutírirobirora ñañarõ netõgʉ̃́dacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Too síro surara, cʉ̃́ãrẽ dutigʉ́, ãpẽrã́ Cõãmacʉ̃wii coterí basoca Jesuré ñee, siatúwa. ");
INSERT INTO tue_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anásya wiipʉ néewasʉguewa. Cʉ̃ʉ̃ Caifás mañecʉ̃́ niiwĩ. Caifás tiicʉ̃marẽ paiaré dutigʉ́ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cʉ̃ʉ̃rã́ too sʉgueropʉre judíoare dutiráre ateré jĩĩyigʉ: “Sĩcʉ̃ niipetiraye niiãdarere diabosari, marĩrẽ ãñuãdacu”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Cʉ̃́ã Jesuré néewari, Simón Pedromenarã yʉʉcã cʉ̃́ãrẽ nʉnʉwáwʉ. Paiaré dutigʉ́ yʉʉre masĩwĩ. Teero tiigʉ́, yʉʉ Jesuré néewaramena wii popea macã yepapʉre sããwawʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrope sopepʉtó sããatiropʉ pʉtʉánʉcãwĩ. Cʉ̃ʉ̃ teero tiirí ĩñagʉ̃, yʉʉ sopepʉtó coterí basocomena wedese, cʉ̃ʉ̃rẽ sããatidutiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sope coterí basoco Pedrore sãĩñáwõ: —¿Mʉʉ ĩ́nimena buegʉ́ mee niiĩ? jĩĩwõ. —Niiria, jĩĩwĩ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yʉsʉá niiwʉ̃. Teero tiirá, tiiwií padecoteri basoca, ãpẽrã́ Cõãmacʉ̃wii coterí basoca pecame diosũmárã tiiwá. Pedrocã cʉ̃́ãmena sũmagʉ̃́ tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Paiaré dutigʉ́ Jesuré sãĩñáwĩ: —¿Mʉʉ buerá, ñiirũnoã basoca peti niiĩ? ¿Ñeenórẽ buei mʉʉ cʉ̃́ãrẽ? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesupé cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉ niipetira tʉocóropʉ buewʉ. Judíoa neãré wiseripʉ, ãno niirí wii Cõãmacʉ̃wiipʉcãrẽ niipetira judíoa neãrṍpʉ buewʉ. Yayióropʉ bueriwʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Yʉʉre deero tiigʉ́ sãĩñáĩ? Yʉʉ bueriguere tʉorírapere sãĩñáña. Cʉ̃́ã masĩcua. Cʉ̃́ã mʉʉrẽ wedeadacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús teero jĩĩrĩ tʉogʉ́, sĩcʉ̃ Cõãmacʉ̃wii coterí basocʉ Jesuyá diapóare páawi. Cʉ̃ʉ̃rẽ jĩĩwĩ: —Paiaré dutigʉ́re teero yʉʉrijãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesupé yʉʉwi: —Yʉʉ ñañarõ jĩĩãriguere wedeñate. “Ateré ñañarõ jĩĩãwʉ̃”, jĩĩña. Yʉʉ diamacʉ̃́ maquẽrẽ jĩĩãri siro niipacari, ¿deero tiigʉ́ yʉʉre páai? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesús siatúarigʉpʉ niitoawi. Anás Jesuré ticocowi Caifás paiaré dutigʉ́ pʉtopʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro pecame wesapʉra sũmanucṹwĩ ména. Toopʉ́ niirã́ cʉ̃ʉ̃rẽ sãĩñáwã: —¿Mʉʉ ĩ́nimena buegʉ́ mee niiĩ? jĩĩwã. —Niiria, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Toopʉ́ sĩcʉ̃ paiaré dutigʉ́re padecotegʉ sũmanucṹwĩ. Cãmopéro páatanorigʉya wedegʉ niiwĩ. Cʉ̃ʉ̃ Pedrore sãĩñáwĩ: —Yʉʉ mʉʉrẽ olivo yucʉ oteriropʉ cʉ̃ʉ̃mena niirĩ ĩñatu niiãwʉ̃rã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Niiria; yʉʉ mee niiãwʉ̃, jĩĩwĩ sũcã. Cʉ̃ʉ̃ teero jĩĩrĩrã, cãrẽquẽ wedewi. ");
INSERT INTO tue_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Too síro Jesuré Caifáya wiipʉ niiãrigʉre tiidita dutigʉ́ niiré wiseri pʉtopʉ néewawa. Bóeropʉ tiiwʉ́. Judíoare dutirá tee wiseri popea macã yepapʉre sããwariwa. Toopʉ́ sããwaraja, Pascua bosebʉreco niirĩ, yaarénorẽ yaaribojĩya. ");
INSERT INTO tue_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Cʉ̃́ã sããwaheri ĩñagʉ̃, Pilato cʉ̃́ãmena wedesegʉ witiatiwi. Cʉ̃́ãrẽ sãĩñáwĩ: —¿Mʉ́ã ãnirẽ́ ñeenó wapare wedesãrã tiii? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Cʉ̃ʉ̃ ñañaré tiihégʉ niiãtã, mʉʉ pʉto cʉ̃ʉ̃rẽ néeatiriboajĩyu, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato cʉ̃́ãrẽ jĩĩwĩ: —Cʉ̃ʉ̃rẽ néewaya. Mʉ́ãrẽ dutiré jĩĩrõbirora mʉ́ã basiro cʉ̃ʉ̃ tiiáriguere besera wáaya, jĩĩmiwĩ. Judíoape yʉʉwa: —Ʉ̃sã judíoa mʉ́ã romanuã tiiróbiro sĩãdutímasĩriga, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Too sʉgueropʉre Jesús “cʉ̃́ã teero tiirí, diagʉdacu” jĩĩ wedesʉguetoarucuwi. Cʉ̃ʉ̃ wedeserigue diamacʉ̃́ wáaaro jĩĩrã, judíoa romanuãrẽ cʉ̃ʉ̃rẽ sĩãdutíwa. ");
INSERT INTO tue_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato cãmecócʉtʉsãwawi sũcã. Jesuré sʉocó, sãĩñáyigʉ: —¿Mʉʉrã́ niiĩ judíoa õpʉ̃? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesupé yʉʉyigʉ: —¿Mʉʉ wãcũrémena sãĩñáĩ? ¿Ãpẽrã́ mʉʉrẽ yée maquẽrẽ wedearĩte? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatope jĩĩyigʉ: —Yʉʉ judíoayʉ mee niiã. Mʉʉya dita macãrã judíoa, teero biiri paiaré dutirá mʉʉrẽ néeatiawã. ¿Deero tiiárĩ mʉʉ? jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesupé cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉ Õpʉ̃ niiré atibʉ́reco maquẽ niiria. Atibʉ́reco maquẽ niiãtã, yʉʉre nʉnʉrã́ cãmerĩ́sĩãboajĩya, judíoare dutirá ñeewarijããrõ jĩĩrã. Yʉʉ Õpʉ̃ niiré ãnopʉ́ mee niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato jĩĩyigʉ: —¿Too docare õpʉ̃ niiĩ mʉʉ? jĩĩyigʉ. Jesupé cʉ̃ʉ̃rẽ yʉʉyigʉ: —Mʉʉ jĩĩrõbirora õpʉ̃ niiã. Yʉʉ diamacʉ̃́ maquẽrẽ wedegʉda jĩĩgʉ̃, ãnopʉ́ ati, bauáwʉ. Niipetira diamacʉ̃́ maquẽrẽ boorá yʉʉ wederére tʉoóya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—Diamacʉ̃́ maquẽ ¿ñeenó niirõ niicu? masĩña maniã, jĩĩyigʉ Pilato. Pilato teero jĩĩãri siro, judíoare dutirámena wedesegʉ witiatiwi sũcã. Cʉ̃́ãrẽ wedewi: —Yʉʉ cʉ̃ʉ̃ ñañaré tiiáriguere bʉaríatʉ. ");
INSERT INTO tue_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Too docare biirope tiigʉ́da: Pascua bosebʉreco niirĩ, mʉ́ã tiimʉ́ãatirigue tiiróbirora tiigʉ́da: Sĩcʉ̃ peresuwiipʉ niigʉ̃́rẽ wionécobosagʉda. ¿Mʉ́ã judíoa õpʉ̃rẽ wionécori boogári? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Niipetira acaribíjõãwã: —¡Cʉ̃ʉ̃rẽ wionécorijãña! ¡Barrabápere wionécoya! jĩĩwã. Barrabás yaarépigʉ niirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Teero tiigʉ́, Pilato Jesuré tãnadutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tãnaã́ri siro, surara potamena cʉ̃́ã tiiári betore cʉ̃ʉ̃ya dupupʉre péorira niiwã. Sicaró õpʉ̃ya sutiro tiiróbiro sõã ñiisãñúrõca sã́ãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Ʉseniã mʉʉmena, judíoa õpʉ̃, jĩĩ buijã́yira. Teero jĩĩrãrã, cʉ̃ʉ̃rẽ pee páajãrira niiwã. ");
INSERT INTO tue_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato popeapʉ niiãrigʉ witiatiwi sũcã. Basocáre jĩĩwĩ: —Yʉʉ cʉ̃ʉ̃rẽ ñañaré tiiáriguere bʉaríatʉ. Teero tiigʉ́, mʉ́ã pʉto sʉowitíatigʉda. Mʉ́ã ĩñaãdacu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Too síro Jesús witiatiwi. Cʉ̃ʉ̃ pota betore pesawi. Õpʉ̃yaro tiiróbiro sõã ñiisãñúrõ cʉ̃́ã sã́ããrirore sãñawitiatiwi. Pilato basocáre jĩĩwĩ: —¡Ĩñaña! Ãni niiĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Paiaré dutirá, Cõãmacʉ̃wii coterí basoca cʉ̃ʉ̃rẽ ĩñarã, acaribíjõãwã: —¡Cʉ̃ʉ̃rẽ curusapʉ páabiatu sĩãdutíya; sĩãdutíya! jĩĩwã. Pilatope jĩĩwĩ: —Mʉ́ã basiro cʉ̃ʉ̃rẽ curusapʉ páabiatu sĩãrã́ wáaya. Yʉʉja cʉ̃ʉ̃rẽ ñañaré tiiáriguere bʉaríatʉ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judíoare dutirápeja cʉ̃ʉ̃rẽ jĩĩwã: —“Yʉʉ Cõãmacʉ̃ macʉ̃ niiã”, jĩĩwĩ cʉ̃ʉ̃jã. Ʉ̃sãrẽ dutiré teero wedesegʉnorẽ sĩãdutía, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato teeré tʉogʉ́, bayiró cuiyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Cʉ̃ʉ̃ye wiseri popea macã yepapʉ cãmecósãwawi sũcã. Jesuré sãĩñáyigʉ: —¿Noo macʉ̃ niiĩ mʉʉ? jĩĩyigʉ. Jesupé cʉ̃ʉ̃rẽ yʉʉriyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato jĩĩyigʉ: —¿Deero tiigʉ́ yʉʉre yʉʉrii? ¿Mʉʉ masĩrii? Yʉʉ mʉʉrẽ wionécogʉ wionécomasĩã. Sĩãdutígʉcã sĩãdutímasĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesupé cʉ̃ʉ̃rẽ yʉʉyigʉ: —Cõãmacʉ̃ mʉʉrẽ dutigʉ́ sõnecorigʉ niiwĩ. Cʉ̃ʉ̃ sõnecoriatã, mʉʉ deero sĩãdutímasĩriboajĩyu. Teero tiigʉ́, yʉʉre mʉʉ pʉtopʉ ticocoarigʉ mʉʉ nemorṍ wapa cʉoquí, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, Pilato Jesuré, “¿deero tii yʉʉ ãnirẽ́ wionécogʉdariye?” jĩĩ wãcũmiyigʉ. Judíoare dutirápeja bayiró acaribíremena jĩĩwã: —Mʉʉ cʉ̃ʉ̃rẽ wionécogʉ, romanuã õpʉ̃ menamacʉ̃ niiricu. Sĩcʉ̃ “yʉʉ mʉ́ã õpʉ̃ niiã” jĩĩgʉ̃́no romanuã õpʉ̃rẽ netõnʉcã́gʉ̃ tiii, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, Pilato Jesuré sʉowitíatidutiwi. Too síro cʉ̃ʉ̃ queti beserópʉ wáa, duiwi. Cʉ̃ʉ̃ duiró niirí yepa ʉ̃tãmena weeri yepapʉ niiwʉ̃. Hebreoayemena Gabata wãmecʉtiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Judíoa Pascua bosebʉreco maquẽ quẽnorí bʉreco niiwʉ̃. Coeritó sʉguerogã niiwʉ̃. Pilato judíoare dutiráre jĩĩwĩ: —Mʉ́ã õpʉ̃rẽ ĩñaña, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Cʉ̃́ãpe acaribíjõãwã sũcã: —¡Cʉ̃ʉ̃rẽ sĩãjã́ãrõ; sĩãjã́ãrõ! ¡Curusapʉ páabiatu sĩãdutíjãña! jĩĩwã. Pilatope jĩĩwĩ: —¿Mʉ́ã õpʉ̃rẽ curusapʉ páabiatu sĩãdutígʉdari? jĩĩwĩ. Paiaré dutirápeja jĩĩwã: —Ʉ̃sã õpʉ̃ sĩcʉ̃rã romanuã õpʉ̃ dícʉ niiĩ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, Jesuré cʉ̃́ãrẽ wiyawí, curusapʉ páabiatuaro jĩĩgʉ̃. Surarape cʉ̃ʉ̃rẽ néewawa. ");
INSERT INTO tue_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús curusare apawagʉ, “Dupucoro” wãmecʉtiropʉ wáawi. Hebreoayemena wãmecʉtia Gólgota. ");
INSERT INTO tue_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Toopʉ́ cʉ̃ʉ̃rẽ curusapʉ páabiatuwa. Ãpẽrã́ pʉarã́cãrẽ teerora tiiwá. Jesuré cʉ̃́ã deco nʉcõwã́, sĩcʉ̃rẽ diamacʉ̃́pe, ãpĩrẽ́ acuniñape. ");
INSERT INTO tue_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato cʉ̃ʉ̃ jóadutiariguere curusapʉ tuudutirigʉ niiwĩ. Biiro jóanoriro niiwʉ̃: “JESÚS NAZARET MACɄ̃ JUDÍOA ÕPɄ̃ NIIĨ”. ");
INSERT INTO tue_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tee jóariguere hebreoaye, griegoaye, latínmena jóadutirigʉ niiwĩ. Cʉ̃́ã Jesuré páabiaturiro Jerusalén pʉtogã niiwʉ̃. Teero tiirá, paʉ judíoa tee jóaturiguere bueĩñawã. ");
INSERT INTO tue_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Cʉ̃́ã bueĩñarĩ ĩñarã, paiaré dutirá Pilato pʉtopʉ wáa, cʉ̃ʉ̃rẽ jĩĩyira: —Mʉʉ “judíoa õpʉ̃ niiĩ” jĩĩ jóariboajĩyu. “ ‘Judíoa õpʉ̃ niiã’, jĩĩãwĩ”, jĩĩ jóaboajĩyu, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato yʉʉyigʉ: —Yʉʉ jóatoaawʉ̃; yʉʉ jóaarirobirora pʉtʉáadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Too síro bapari surara Jesuré páabiatuarira cʉ̃ʉ̃ye sutire seenéõwã. Seenéõ, cʉ̃́ãcõrõ batowa. Cʉ̃ʉ̃ya sutiró docasãñariwʉcã sua cãmeyioriro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Teero tiirá, surara cãmerĩ́ jĩĩyira: —Ãnorẽ́jã yigarijããda. ¿Noãrẽ́ pʉtʉáadari? jĩĩrã, jĩĩbʉaapeada, jĩĩyira. Cʉ̃́ã teero tiirí, Cõãmacʉ̃ye queti jóaripũpʉ jóarigue diamacʉ̃́ wáaro tiiwʉ́. Biiro jóanoã: “Yée sutire batowa; sicaróre jĩĩbʉaapewa”, jĩĩ jóanoã. Tee jóarirobirora surara teerora tiiwá. ");
INSERT INTO tue_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuyá curusa pʉtopʉ cʉ̃ʉ̃ paco, cʉ̃ʉ̃ bʉgo, apegó María (coo Cleofas nʉmo niiwõ), María Magdalena nucũwã. ");
INSERT INTO tue_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús cʉ̃ʉ̃ pacore, teero biiri yʉʉ Juan cʉ̃ʉ̃ bayiró maĩgʉ̃́rẽ coo wesa nucũrĩ ĩñagʉ̃, coore jĩĩwĩ: —Paco, ãni mʉʉ macʉ̃ pʉtʉái, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Too síro yʉʉre jĩĩwĩ: —Atigó mʉʉ paco pʉtʉáyo, jĩĩwĩ. Cʉ̃ʉ̃ teero jĩĩãri siro, coore yáa wiipʉ néepʉtʉawawʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Too síro Jesús cʉ̃ʉ̃rẽ tiidutíriguere masĩjĩgʉ̃, “niipetire peotítoaa” jĩĩ wãcũrigʉ niiwĩ. Teero tiigʉ́, Cõãmacʉ̃ye queti jóaripũpʉ jóarigue wáaaro jĩĩgʉ̃: —Yʉʉ sĩnidʉgága, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Toopʉ́ sicarʉ́ vino piyare dadarírʉ duiwʉ. Teero tiirá, surara sicasitia soa, “hisopo” dʉpʉpʉ siatú, súumʉõcowa. ");
INSERT INTO tue_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cʉ̃ʉ̃ teeré sĩniã́ri siro: —Niipetire peotítoaa, jĩĩwĩ. Teero jĩĩãri siro, cʉ̃ʉ̃ya dupu ñaañumu, diajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua bosebʉreco wáaadaro sicabʉreco dʉsawʉ́. Tii bosebʉreco ʉ̃sãrẽ ʉpʉtí niirí bʉreco niiwʉ̃. Tiibʉrecore judíoare dutirá diaarirare curusaripʉre niirĩ boorírira niiwã. Teero tiirá, judíoare dutirá Pilato pʉtopʉ wáa, cʉ̃ʉ̃yara surarare cʉ̃́ãrẽ máata diaaro jĩĩrã, cʉ̃́ãye ñicãrĩrẽ páapedutiyira. Too síro cʉ̃́ãye õpʉ̃ʉ̃rĩrẽ néedioco, aperopʉ́ néewadutiyira. ");
INSERT INTO tue_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Teero tiirá, surara toopʉ́ jea, sĩcʉ̃rẽ páapesʉguewa. Ãpĩ Jesuména páabiatunoãrigʉcãrẽ teerora tiiwá. ");
INSERT INTO tue_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesupére diaarigʉpʉre bʉajeáwa. Teero tiirá, cʉ̃ʉ̃rẽ páaperiwa. ");
INSERT INTO tue_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Páaperono tiigʉ́, sĩcʉ̃ surara Jesuré warupãmarẽ sadewi. Cʉ̃ʉ̃ teero tiirí, máata díi ocoména witiwʉ. ");
INSERT INTO tue_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉʉ teero wáari ĩñawʉ̃. Teero tiigʉ́, yʉʉ masĩã: Yʉʉ jóare diamacʉ̃́rã niiã. Mʉ́ãcãrẽ teeré padeoáro jĩĩgʉ̃, tee diamacʉ̃́ maquẽrẽ wedea. ");
INSERT INTO tue_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cõãmacʉ̃ye queti jóaripũpʉ jĩĩrõbirora wáaaro jĩĩrõ, teero wáawʉ. Biiro jóanoã: “Cʉ̃ʉ̃ye cõãrĩ́ sicacõãno páapeya maniã́dacu”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tiipũpʉre aperopʉ́ jóanoã sũcã: “Cʉ̃́ã sadearigʉpʉre ĩñaãdacua”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Too síro José Arimatea wãmecʉtiri macã macʉ̃ Pilatore Jesuyá õpʉ̃ʉ̃rẽ sãĩyígʉ. José Jesuré padeogʉ́ niiwĩ. Cʉ̃ʉ̃ judíoare dutiráre cuigʉ, yayióropʉ padeogʉ́ niirigʉ niiwĩ. Pilato “jáʉ” jĩĩrĩ tʉogʉ́, José wáa, Jesuyá õpʉ̃ʉ̃rẽ néedioco, néewawi. ");
INSERT INTO tue_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo ñamipʉ Jesuména wedesegʉ jearigʉcã jeawi. Cʉ̃ʉ̃ treinta kilos sitiaãñúrere néejeawi. Tee ate niiwʉ̃: “Mirra” wãmecʉtire, “áloe” wãmecʉtiremena wʉ́origue niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José Nicodemomena suti caseri sitiaãñúre tuusĩã́remena Jesuyá õpʉ̃ʉ̃rẽ cõmawã́. Judíoa diaarirare cṹũri tutipʉ cṹũãdari sʉguero tiirucúrere tiiwá. ");
INSERT INTO tue_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesuré curusapʉ páabiaturiro pʉto oteré oteriro niiwʉ̃. Tee oteriro deco mama tuti, ʉ̃tãgãpʉ coari tuti niiwʉ̃. Tiitutipʉ sĩcãrĩ diaarirare cṹũña maniríro niiwʉ̃ ména. ");
INSERT INTO tue_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Muĩpũ sããwari, ʉ̃sã yeerisãri bʉreco jearopʉ tiiwʉ́. Teero tiirá, tiicope pʉtogã niirĩ, Jesuyá õpʉ̃ʉ̃rẽ toopʉ́ néewa, cṹũwã. ");
INSERT INTO tue_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ʉ̃sã yeerisãri bʉreco síro macã bʉreco niirĩ, bóeadari sʉguero, María Magdalena cʉ̃ʉ̃rẽ cṹũri tutipʉ wáayigo. Tiituti biamíriquicare aperopʉ́ nucũrĩ ĩñayigo. ");
INSERT INTO tue_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Teero tiigó, ʉ̃sã pʉtopʉ cʉtʉpʉtʉ́aatirigo niiwõ. Yʉʉ Jesús bayiró maĩnógʉ̃, Simón Pedromena niiwʉ̃. Ʉ̃sãrẽ jĩĩwõ: —Marĩ Õpʉ̃rẽ aperopʉ́ néejõããrira niiãwã. Noopʉ́ néewara néewaajĩya, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Coo teero jĩĩrĩ tʉorá, yʉʉ, Simón Pedromena cʉ̃ʉ̃rẽ cṹũriropʉ ĩñarã wáawʉ. ");
INSERT INTO tue_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ʉ̃sã toopʉ́ wáara, yʉʉ Pedro nemorṍ cʉtʉbayíwʉ. Teero tiigʉ́, yʉʉ cʉ̃ʉ̃ sʉguero jeawʉ. ");
INSERT INTO tue_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Toopʉ́ jea, tiicopepʉ munibiá, ĩñasõnecowʉ. Sããwaripacʉ, cʉ̃ʉ̃rẽ cõmaré caseri pesari ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Too síropʉ Simón Pedro yʉʉre nʉnʉjeáwi. Cʉ̃ʉ̃jã sããjõãwĩ. Cʉ̃ʉ̃cã teecaserire toopʉ́ niirĩ ĩñawĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Aperó Jesuré dupure cʉ̃́ã cõmarí caserocã aperopʉ́ pesari ĩñawĩ. Tuupéari casero niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yʉʉ tiitutipʉre jeasʉguerigʉcã sããwawʉ. Niipetirere ĩñagʉ̃, padeowʉ́. ");
INSERT INTO tue_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ʉ̃sã Cõãmacʉ̃ye queti jóaripũ maquẽrẽ “Jesús diarigʉpʉ masãgʉ̃daqui” jĩĩrére masĩriwʉ ména. ");
INSERT INTO tue_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ĩñaãri siro, ʉ̃sãya wiipʉ pʉtʉawawʉ. ");
INSERT INTO tue_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalenape tiituti díamacʉ̃pʉ utigo pʉtʉáwo. Utigora, tiitutipʉ munibiá, ĩñasõnecoyigo. ");
INSERT INTO tue_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ángelea pʉarã́ suti butiré sãñarã́rẽ duiri ĩñayigo. Cʉ̃́ã Jesuré cṹũmiriropʉ duiyira, sĩcʉ̃ dupu niimirirope, ãpĩ dʉpori niimirirope. ");
INSERT INTO tue_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Cʉ̃́ã coore sãĩñáyira: —¿Deero tiigó utii? jĩĩyira. Cʉ̃́ãrẽ yʉʉyigo: —Yʉʉ Õpʉ̃rẽ néejõããrira niiãwã. Noopʉ́ néewara néewaajĩya, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Coo teero jĩĩãri siro, aperopé cãmenʉcã́yigo. Jesús coo pʉto nucũrĩ ĩñayigo. “Jesús niiĩ” jĩĩ ĩñamasĩriyigo ména. ");
INSERT INTO tue_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Cʉ̃ʉ̃pe coore sãĩñáyigʉ: —¿Deero tiigó utii? ¿Noãrẽ́ ãmaãĩ? jĩĩyigʉ. “Oteré coterí basocʉ niiqui”, jĩĩ wãcũgõ, jĩĩyigo: —Mʉʉ cʉ̃ʉ̃rẽ néewaarigʉ wedeya. ¿Noopʉ́ cṹũãrĩ? Yʉʉ cʉ̃ʉ̃rẽ néegõ wáagoda, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús coore jĩĩyigʉ: —¡María! Cʉ̃ʉ̃ teero jĩĩrĩ tʉogó, cãmenʉcã́: —¡Raboni! jĩĩyigo. (Hebreoayemena “basocáre buegʉ́” jĩĩdʉgaro tiia.) ");
INSERT INTO tue_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús coore jĩĩyigʉ: —Ñeerijãña yʉʉre. Yʉʉ Pacʉ pʉtopʉ mʉãwaria ména. Yʉʉre padeoráre wedego wáaya. “Biiro jĩĩãwĩ”, jĩĩña: “ ‘Yʉʉ Pacʉ pʉtopʉ mʉãwagʉdʉ tiia; yʉʉ Pacʉ mʉ́ã Pacʉ niiĩ; yʉʉ Õpʉ̃ mʉ́ã Õpʉ̃ niiĩ’, jĩĩãwĩ”, jĩĩ wedeya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogó, María Magdalena ati, ʉ̃sã cʉ̃ʉ̃ bueráre wedewo: —Marĩ Õpʉ̃rẽ ĩñaãwʉ̃, jĩĩwõ. Cʉ̃ʉ̃ coore wedeariguere wedewo. ");
INSERT INTO tue_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Teero wáari bʉreco ʉ̃sã yeerisãri bʉreco síro macã bʉreco niiwʉ̃. Tiibʉreco ñamipʉ ʉ̃sã cʉ̃ʉ̃ buerá niirira neãwʉ̃. Ʉ̃sã judíoare dutiráre cuira, ãñurõ biacósãwʉ̃. Ʉ̃sã toopʉ́ niirĩ, Jesús ʉ̃sã decopʉ bauánʉcãwĩ. Ʉ̃sãrẽ ãñudutiwi: —Ãñurõ niirecʉtire mʉ́ãpʉre niiãrõ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cʉ̃ʉ̃ teero jĩĩãri siro, cʉ̃ʉ̃ye wãmorĩrẽ, warupãmarẽ ẽñowĩ́. Ʉ̃sã cʉ̃ʉ̃rẽ ĩñarã, bayiró ʉseniwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ʉ̃sãrẽ jĩĩnemowĩ: —Ãñurõ niirecʉtire mʉ́ãpʉre niiãrõ. Yʉʉ Pacʉ yʉʉre ticodiocorirobirora yʉʉcã yée quetire wededutigʉ mʉ́ãrẽ ticocoa, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Teero jĩĩãri siro, cʉ̃ʉ̃ ʉ̃sãrẽ wĩãpũpeo, jĩĩwĩ: —Mʉ́ãmena Espíritu Santo niiãrõ. ");
INSERT INTO tue_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mʉ́ã ãpẽrãrẽ́ cʉ̃́ã ñañaré tiirére acabóri, acabónoãrira pʉtʉáadacua. Mʉ́ã cʉ̃́ãrẽ acabóheri, acabóya manirã́ pʉtʉáadacua, jĩĩwĩ Jesús. ");
INSERT INTO tue_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás ʉ̃sã menamacʉ̃ (“sʉdʉárigʉ” ʉ̃sã jĩĩgʉ̃́) Jesús ʉ̃sã pʉtopʉ bauáritore, maniwĩ́. ");
INSERT INTO tue_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teero tiirá, ʉ̃sã cʉ̃ʉ̃rẽ jĩĩwʉ̃: —Marĩ Õpʉ̃rẽ ĩñaãwʉ̃. Tomapé ʉ̃sãrẽ jĩĩwĩ: —Yʉʉ cʉ̃ʉ̃ye wãmorĩpʉ cʉ̃́ã páabiare coperire ĩñahẽgʉ̃, teecoperipʉ yáa wãmosṹãrẽ súusõnecohegʉ, teerora yáa wãmorẽ cʉ̃ʉ̃ warupãmapʉcãrẽ súusõnecohegʉ, padeorícu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sica semana siro ʉ̃sã cʉ̃ʉ̃ buerá niirira tiiwiipʉ́ neãwʉ̃ sũcã. Tomás ʉ̃sãmena niiwĩ sáa. Ʉ̃sã ãñurõ biacósãpacari, Jesús ʉ̃sã decopʉ bauánʉcãwĩ sũcã. Ʉ̃sãrẽ ãñudutiwi: —Ãñurõ niirecʉtire mʉ́ãpʉre niiãrõ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Too síro Tomarẽ́ jĩĩwĩ: —Ĩñaña yée wãmorĩrẽ; mʉʉya wãmosṹãrẽ ãno súusõnecoya. Yáa warupãmapʉcãrẽ mʉʉya wãmorẽ súusõnecoya. Padeoré manigʉ̃́ niirijãña. Padeoyá, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomapé jĩĩwĩ: —Mʉʉ yʉʉ Õpʉ̃ niiã; mʉʉ Cõãmacʉ̃ yʉʉ padeogʉ́ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesupé jĩĩwĩ: —Tomás, mʉʉ yʉʉre ĩñatoagʉpʉ padeóa. Ãpẽrã́ yʉʉre ĩñaripacara padeorápe ʉseninemorã niiĩya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús ʉ̃sã ĩñacoropʉ pee apeyenó cʉ̃ʉ̃ tutuaremena tiiẽ́ñowĩ. Tee niipetirere yʉʉ atipũpʉ́re jóaria. ");
INSERT INTO tue_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yʉʉ atipũpʉ́ Jesús sĩquẽ cʉ̃ʉ̃ tutuaremena tiiẽ́ñoriguere jóaa. Mʉ́ãrẽ “Jesús Cõãmacʉ̃ beserigʉ cʉ̃ʉ̃ macʉ̃ niiĩ” jĩĩrére padeodutígʉ jóaa. Mʉ́ã cʉ̃ʉ̃rẽ padeorá catiré petihére cʉoádacu. ");
INSERT INTO tue_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Too síro Jesús Tiberiataro wesapʉ ʉ̃sãrẽ bauánemowĩ. Biiro wáawʉ: ");
INSERT INTO tue_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ʉ̃sã toopʉ́re niirã́ noquẽrã niiwʉ̃: Simón Pedro, Tomás (“sʉdʉárigʉ” ʉ̃sã jĩĩgʉ̃́), Natanael (cʉ̃ʉ̃ Caná Galilea dita macʉ̃ niiwĩ), ʉ̃sã Zebedeo põna, ãpẽrã́ ʉ̃sã menamacãrã pʉarã́ niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ʉ̃sã toopʉ́ niirĩ, Simón Pedro ʉ̃sãrẽ jĩĩwĩ: —Wai wasagʉ wáagʉ tiia. —Ʉ̃sãcã mʉʉmena wáaada, jĩĩwʉ̃. Ʉ̃sã wáa, dooríwʉpʉ mʉãsãwʉ̃. Tiiñamirẽ wai sĩãbóejõãmiwʉ̃. Bʉarítʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bóecũmurĩ, Jesús tiitaro wesapʉ nucũwĩ. Ʉ̃sã cʉ̃ʉ̃rẽ ĩñamasĩriwʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Cʉ̃ʉ̃ ʉ̃sãrẽ jĩĩwĩ: —¿Wai bʉaárĩ? —Bʉaríatʉ, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Dooríwʉ diamacʉ̃́pe cõãñoña mʉ́ãya bapigʉre sũcã. Toopé bʉaádacu, jĩĩwĩ. Cʉ̃ʉ̃ jĩĩrirobirora tiiwʉ́. Paʉ peti sããrĩ, bapigʉre wéemʉõcobayiritʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Teero wáari ĩñagʉ̃, yʉʉ Jesús bayiró maĩnógʉ̃ Pedrore jĩĩwʉ̃: —Marĩ Õpʉ̃ niiĩ. Simón Pedro “marĩ Õpʉ̃ niiĩ” jĩĩrĩ tʉogʉ́, cʉ̃ʉ̃yaro sutiroré máata sãñawĩ; peesutimena pademasĩriwi. Sãña, tiitaropʉ ñaacoñuãwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ʉ̃sã pasaró wesapʉ jeaadaro cien metrora yoaro niiwʉ̃. Teero tiirá, dooríwʉmena wesapʉ waire wéepãwawʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Toopʉ́ pããjeara, pecame cʉ̃ʉ̃ dioárimerẽ ĩñawʉ̃. Tiimepʉ́ sĩcʉ̃ wai cããrĩõã́rigʉ pesawi. Teero biiri pã niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús ʉ̃sãrẽ jĩĩwĩ: —Wai mʉ́ã bʉaárirare néeatiya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro dooríwʉpʉ mʉãsã, bapigʉre wéemaatiwi. Wai pacaramena dadajõãwʉ̃. Ciento cincuenta y tres sããrira niiwã. Paʉ sããpacari, bapigʉ yigariwʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús ʉ̃sãrẽ jĩĩwĩ: —Yaawãcãrã atiya. Ʉ̃sã cʉ̃ʉ̃rẽ ĩñamasĩtoawʉ. Teero tiirá, sĩcʉ̃nopera, “¿noã niiĩ mʉʉ?” jĩĩ sãĩñáriwʉ. ");
INSERT INTO tue_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús pãrẽ née, ʉ̃sãrẽ batowi. Waicãrẽ teerora tiiwí. ");
INSERT INTO tue_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús dia masãri siro, pʉarĩ́ ʉ̃sãrẽ bauátoawi. Ateména ĩtĩã́rĩ wáaro tiiwʉ́ sáa. ");
INSERT INTO tue_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ʉ̃sã yaaari siro, Jesús Simón Pedrore sãĩñáwĩ: —Simón, Jonás macʉ̃, ¿mʉʉ ãniã nemorṍ yʉʉre maĩĩ? jĩĩwĩ. —Ʉ̃́jʉ̃, yʉʉ Õpʉ̃. Mʉʉ masĩã yʉʉ mʉʉrẽ maĩrére, jĩĩwĩ. —Too docare yʉʉre padeoráre bueya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pedrore sãĩñánemowĩ sũcã: —Simón, Jonás macʉ̃, ¿yʉʉre maĩĩ? jĩĩwĩ. —Ʉ̃́jʉ̃, yʉʉ Õpʉ̃. Mʉʉ masĩã yʉʉ mʉʉrẽ maĩrére, jĩĩwĩ. —Too docare yʉʉre padeoráre coteya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Too síro jĩĩnemowĩ sũcã: —Simón, Jonás macʉ̃, ¿yʉʉre maĩĩ? Pedro ĩtĩã́rĩ cʉ̃ʉ̃rẽ sãĩñárĩ ĩñagʉ̃, bayiró bóaneõgʉ̃ wáawi. Cʉ̃ʉ̃rẽ jĩĩwĩ: —Õpʉ̃, mʉʉ niipetirere masĩã. Mʉʉ masĩã yʉʉ mʉʉrẽ maĩrére, jĩĩwĩ. Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Too docare yʉʉre padeoráre bueya. ");
INSERT INTO tue_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mʉʉrẽ ateréja diamacʉ̃́rã jĩĩã: Mʉʉ mamʉ niigʉ̃ ména, mʉʉ booró sutiré sãña, mʉʉ noo wáadʉgaropʉ wáawʉ. Bʉcʉ wáagʉpe, mʉʉye wãmorĩrẽ súumʉõcogʉdacu. Ãpĩ mʉʉrẽ suti sã́ã, mʉʉ wáadʉgaheropʉ mʉʉrẽ néewagʉdaqui, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jesús teero jĩĩgʉ̃, “Pedro biiro wáa, diagʉdaqui” jĩĩgʉ̃ tiiwí. “Cʉ̃ʉ̃ diarémena basocá Cõãmacʉ̃rẽ ãñurõ wedeseadacua” jĩĩgʉ̃, teero jĩĩwĩ.) Teero jĩĩãri siro, Jesús cʉ̃ʉ̃rẽ jĩĩwĩ: —Yʉʉre padeonʉnʉ́serucujãña, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Too síro Pedro cãmenʉcã́, yʉʉ cʉ̃́ã siro nʉnʉrĩ́ ĩñawĩ. Yʉʉ Jesús maĩnógʉ̃ niiwʉ̃. Yʉʉrá too sʉgueropʉre ʉ̃sã yaaritore, Jesús pʉtogã duigʉ, cʉ̃ʉ̃rẽ sãĩñáwʉ̃: “Õpʉ̃, ¿noã mʉʉrẽ ĩñatutirapʉre ticogʉdari?” jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro yʉʉre ĩñagʉ̃, Jesuré sãĩñáwĩ: —Õpʉ̃, ¿ãnirẽ́ deero wáaadari? jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesupé cʉ̃ʉ̃rẽ yʉʉwi: —Yʉʉ pʉtʉaatiripʉ cʉ̃ʉ̃ catiricãrẽ, tee mʉʉye maquẽ mee niiã. Teeré wãcũrijãña. Mʉʉ yʉʉpere wãcũnʉnʉseya, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, Jesuré padeorá “Juan diariqui” jĩĩré sesajõãmiwʉ̃. Jesús yʉʉre “cʉ̃ʉ̃ diariqui” jĩĩgʉ̃ mee tiiwí. Biirope jĩĩgʉ̃ tiiwí: “Yʉʉ pʉtʉaatiripʉ cʉ̃ʉ̃ catiricãrẽ, tee mʉʉye maquẽ mee niiã”. ");
INSERT INTO tue_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yʉʉ Juan niiã, Jesús buegʉ́ niirigʉ. Yʉʉ ĩñariguere jóaa. Teero tiigʉ́, “diamacʉ̃́rã niiã” jĩĩmasĩnoã. ");
INSERT INTO tue_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Apeyé Jesús tiirígue pee niiã. Yʉʉ tʉgueñarĩ, cʉ̃ʉ̃ tiiríguecõrõ jóaatã, peepũrĩ peti wáabojĩyu. Teepũrĩ atibʉ́recore dadajõãbojĩyu.");
INSERT INTO tue_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, mʉʉrẽ sicapũ too sʉgueropʉre jóawʉ. Tiipũpʉre niipetire Jesús basocáre buerucuriguere, cʉ̃ʉ̃ tiirucúriguere wedewʉ. Sicato cʉ̃ʉ̃ buenʉcãriguere, ");
INSERT INTO tue_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tée cʉ̃ʉ̃ bueyapacʉtiriguere wedewʉ. Teero biiri cʉ̃ʉ̃ ʉ̃mʉã́sepʉ mʉãwariguere wedewʉ. Jesús ʉ̃mʉã́sepʉ mʉãwaadari sʉguero, cʉ̃ʉ̃ buerá cʉ̃ʉ̃ beserirare dutiré cṹũyigʉ cʉ̃́ã tiiádarere. Espíritu Santo masĩré ticorémena teeré dutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cʉ̃ʉ̃ dia masãri siro, Jesús bauáyigʉ. Cuarenta bʉrecorire pee bauáyigʉ cʉ̃́ãrẽ. Teero tiirá, cʉ̃ʉ̃rẽ ĩñarã, “marĩ ‘diajõããwĩ’ jĩĩãrigʉra catii” jĩĩyira. Cõãmacʉ̃ dutiré basocápʉre niiãdare jeariguere wedenemoyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesús cʉ̃́ãmena niigʉ̃, cʉ̃́ãrẽ Jerusalénpʉ niidutiyigʉ ména. Cʉ̃́ãrẽ jĩĩyigʉ: —Yʉʉ Pacʉ mʉ́ãrẽ too sʉgueropʉ jĩĩrirobirora Espíritu Santore ticodiocogʉdʉre yueya. Teeré wedetoawʉ. ");
INSERT INTO tue_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan mʉ́ãrẽ ocoména wãmeõtiwi. Yʉʉ Pacʉpeja nemorṍ ãñurõ tiigʉ́daqui mʉ́ãrẽ: Péerogã siro Espíritu Santore ticodiocogʉdaqui, jĩĩyigʉ Jesús. ");
INSERT INTO tue_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cʉ̃ʉ̃mena neããrira cʉ̃ʉ̃rẽ sãĩñáyira: —Ʉ̃sã Õpʉ̃, ¿mʉʉ mecʉ̃tígãrẽ romanuãrẽ cõãjãgʉ̃dari? Teero biiri ¿ãpẽrã́ marĩya wederare diamacʉ̃́rã marĩrẽ dutirá sããrĩ tiigʉ́dari? jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Cʉ̃ʉ̃ yʉʉyigʉ: —Marĩ Pacʉ sĩcʉ̃rã masĩqui. Cʉ̃ʉ̃ “teerora wáaaro” jĩĩrĩ, teerora wáaadacu. Ate masĩré mʉ́ãye maquẽ niiria. ");
INSERT INTO tue_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Teero niipacari, marĩ Pacʉ cʉ̃ʉ̃ tutuarere mʉ́ãrẽ ticogʉdaqui, Espíritu Santo mʉ́ãpʉre atiri. Mʉ́ã cuiro manirṍ, wãcũtutuaremena yée quetire basocáre wedera wáaadacu. Jerusalén macãrãrẽ, Judea dita macãrãrẽ, Samaria dita macãrãrẽ, niipetiro atibʉ́recopʉ niirã́rẽ wedera wáaadacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Teero jĩĩ wedetoaari siro, cʉ̃ʉ̃rẽ cʉ̃ʉ̃ Pacʉ néemʉãwayigʉ ʉ̃mʉã́sepʉ. Cʉ̃ʉ̃ mʉãwari, cʉ̃ʉ̃ buerá ĩñanʉnʉseyira. Cʉ̃ʉ̃rẽ õmebʉrʉá tuubiácojãyiro. Teero tiirá, cʉ̃ʉ̃rẽ ĩñanemoriyira sáa. ");
INSERT INTO tue_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cʉ̃́ã Jesús mʉãwari ĩñanucũrĩ, cʉ̃́ã decopʉ ʉ̃mʉã́ pʉarã́ suti butiré sãñarira bauánʉcãjeayira. ");
INSERT INTO tue_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Cʉ̃́ãrẽ jĩĩyira: —Mʉ́ã Galilea macãrã, ¿deero tiirá ʉ̃mʉã́sepʉ ĩñamʉõconucũĩ? Ãni Jesús mʉ́ãmena niiãrigʉ mecʉ̃tígã ʉ̃mʉã́sepʉ mʉãwaarigʉra atibʉ́recopʉre atigʉdaqui sũcã. Mʉ́ã cʉ̃ʉ̃rẽ mʉãwari ĩñaãrirobirora atigʉdaqui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Teero tiiári siro, Jesús beserira Ʉ̃tãgʉ̃́ Olivopʉ niiãrira diiwá, Jerusalénpʉ coepʉtʉ́awayira. Tiimacã pʉtogã niiã tiigʉ́ sica kilómetro wáaro. ");
INSERT INTO tue_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalénpʉ pʉtʉajeara, cʉ̃́ã cãnirí wiipʉ wáayira. Tiiwií casacʉtiri wii niiyiro. Sicatatia ʉ̃mʉã́rõ macã tatiapʉ sããwayira. Cʉ̃́ã niiyira: Pedro, Santiago, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago (Alfeo macʉ̃), Simón (romanuã dutiráre cõãdʉgara menamacʉ̃ niimirigʉ), Judas (Santiago macʉ̃) niiyira. ");
INSERT INTO tue_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Cʉ̃́ã sĩcãrõména neã, Cõãmacʉ̃rẽ sãĩrucúyira. Jesús baira, cʉ̃ʉ̃ paco María, ãpẽrã́ numiã́cã cʉ̃́ãmena neãyira. ");
INSERT INTO tue_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Teebʉrecorire Jesuré padeorá neãyira sũcã. Ciento veinte watoa niiyira. Pedro wʉ̃mʉnʉcã, cʉ̃́ãrẽ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yáa wedera, too sʉgueropʉ marĩ ñecʉ̃ David Espíritu Santo masĩré ticorémena Judare wáaadarere jóasʉguerigʉ niiwĩ. Cõãmacʉ̃ye queti jóaripũ maquẽ diamacʉ̃́rã wáaadare niirõ tiiwʉ́. Teero tiigʉ́, ãpẽrãrẽ́ Judas néewa, cʉ̃́ãrẽ Jesuré ẽñowĩ́. Cʉ̃́ãpe Jesuré ñee, néewawa. ");
INSERT INTO tue_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ʉ̃sã menamacʉ̃rã niimiwĩ. Jesús cʉ̃ʉ̃cãrẽ basocáre buerére cṹũmiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Cʉ̃ʉ̃ ñañarõ tii wapatáriguemena sicadita sãĩnóyiro. Too síro dupupe ñaacũmu, cʉ̃ʉ̃ páaga podo, cʉtamisĩ witibatejõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Niipetira Jerusalén macãrã teeré tʉoyíra. Cʉ̃́ã tiiditare Acéldama jĩĩyira. Acéldama “Díi Dita” jĩĩrõ tiicú cʉ̃́ãyemena. ");
INSERT INTO tue_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","’Tíatopʉ Salmopũpʉre jóagʉ teeré biiro jóarigʉ niiwĩ: Cʉ̃ʉ̃ye niimirigue cõãjãnoãrõ. Cʉ̃ʉ̃ jóarigʉ niiwĩ sũcã: Ãpĩ cʉ̃ʉ̃ pademiriguere wasoáro, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Marĩmena sĩquẽrã niipetiropʉ wáanetõrira niiĩya, marĩ Õpʉ̃ Jesús marĩmena niirĩ. Juan Jesuré wãmeõtiri, tée Cõãmacʉ̃ cʉ̃ʉ̃rẽ ʉ̃mʉã́sepʉ néemʉãrĩ, ĩñarira niiĩya. Ãniãpʉre sĩcʉ̃ besero booa ʉ̃sã oncemena niigʉ̃dʉre. Cʉ̃ʉ̃ ʉ̃sã tiiróbiro Jesús diarigʉpʉ masãrigue quetire wedegʉ́ wáagʉdaqui, jĩĩ wedeyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tiitatiapʉ niirã́ pʉarã́rẽ beseyira. Sĩcʉ̃ José Barsabáre beseyira. Cʉ̃ʉ̃ wãmesotoapeore griegoayemena Justo niiyiro. Ãpĩ Matíare beseyira. ");
INSERT INTO tue_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Too síro marĩ Õpʉ̃rẽ sãĩrã́, biiro jĩĩyira: —Ʉ̃sã Õpʉ̃, mʉʉ niipetira basocá wãcũrére masĩã. Judas wasogʉ́dʉre besetoajĩyu. Ʉ̃sãrẽ ẽñoñá. ¿Nii niigari? Judas mʉʉ dutiré cṹũriguere duujã́wĩ, ñañarã́ cʉ̃́ã ñañarõ netõrṍpʉ wáagʉ, catigʉ cʉ̃ʉ̃ ãñurõ tiirírigue wapa, jĩĩ sãĩyíra. ");
INSERT INTO tue_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Too síro pʉapé ʉ̃tãpepʉ Matías, Barsabás wãmerẽ jóayira. ¿Nii marĩ Õpʉ̃ beserigʉ niiĩ? jĩĩrã, piipʉ sã́ã, sicape née, ĩñayira. Matías wãme jóaturipe niiyiro. —Jã́ã, ãni Matías Judas wasogʉ́ niiĩ, jĩĩyira. Cʉ̃ʉ̃ ãpẽrã́ oncemena Jesucristoye quetire wedegʉ́ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cincuenta bʉrecori Pascua netõrí siro, Pentecostés wãmecʉtiri bosebʉreco wáayiro. Tii bosebʉreco niirĩ, niipetira Jesuré padeorá sĩcãrõména neãyira. ");
INSERT INTO tue_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tiiwiipʉ́ cʉ̃́ã duiri, wãcũña manirṍ wĩno bayiró atiro tiiróbiro ʉ̃mʉã́sepʉ bʉsʉdiatiyiro. Tiiwií bʉsʉsesajõãyiro. ");
INSERT INTO tue_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Teero wáari, pecame jʉ̃ʉ̃rípõnabiro bauré cʉ̃́ãcõrõrẽ pesayucoyiro. ");
INSERT INTO tue_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Niipetiramena Espíritu Santo niinʉcãgʉ̃ jeayigʉ. Cʉ̃ʉ̃ dutirémena ãpẽrã́ basocáye wedeserere masĩripacara, wedesenʉcãyira. ");
INSERT INTO tue_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Teebʉrecorire Jerusalénpʉre paʉ judíoa apeyé dita macãrãpʉ niiyira. Cʉ̃́ã Cõãmacʉ̃rẽ quioníremena padeorá niiyira. ");
INSERT INTO tue_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cʉ̃́ã tee bʉsʉri tʉorá, toopʉ́ neãwayira. Deero jĩĩmasĩriyira, cʉ̃́ã pʉtopʉ jeara. Cʉ̃́ã basocácõrõ cʉ̃́ãye wedeseremena Jesús bueráre wedeseri tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tʉomaníjõãrã, cãmerĩ́ jĩĩyira: —Niipetira ãniã wedesera ¿Galilea macãrã mee niimiĩ? ");
INSERT INTO tue_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Deero tiirá marĩyere ãñurõ wedeseri tʉoi? ");
INSERT INTO tue_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Marĩ aperó macãrã niiã. Partia macãrã, Media macãrã, Elam macãrã, Mesopotamia macãrã, Judea macãrã, Capadocia macãrã, Ponto macãrã, Asia macãrã niiã marĩ. ");
INSERT INTO tue_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia macãrã, Panfilia macãrã, Egipto macãrã, Cirene pʉto macãrã niiã marĩ. Cirene Libia ditapʉ niiã. Sĩquẽrã Roma atirá niiĩya. ");
INSERT INTO tue_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cʉ̃́ã sĩquẽrã judíoa niiĩya. Ãpẽrã́ judíoa niihẽrã Cõãmacʉ̃rẽ padeoóya. Ãpẽrã́ Creta macãrã, Arabia macãrã niiĩya. Marĩ niipetira marĩye wedeseremena tʉorá tiia Cõãmacʉ̃ ãñuré tiirére, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Niipetira tʉomaníjõãyira. —¿Ate deero jĩĩdʉgaro tiii? jĩĩ cãmerĩ́ sãĩñáyira. ");
INSERT INTO tue_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sĩquẽrã cʉ̃́ãrẽ buijã́yira. —Ãniã cũmurã tiiíya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, Pedro ãpẽrã́ once Jesús beseriramena wʉ̃mʉnʉcã, bayiró bʉsʉrómena wedeyigʉ: —Yáa wedera, niipetira Jerusalén niirã́, yʉʉ jĩĩrére ãñurõ tʉoyá. ");
INSERT INTO tue_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Ãniã cũmurã tiiíya” jĩĩ wãcũmiã mʉ́ã. Cũmurã mee tiiíya. Mecʉ̃tígã ñamisãñurõgã nueve niiã. ");
INSERT INTO tue_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mʉ́ã mecʉ̃tígã tʉorére too sʉgueropʉ profeta Joel jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Atibʉ́reco petiádari sʉguero, Espíritu Santore niipetirare ticodiocogʉda, jĩĩrigʉ niiwĩ Cõãmacʉ̃. Espíritu Santore ticodiocori, mʉ́ã põna ʉ̃mʉã́, numiã́ yʉʉ wededutirere wedeadacua. Bʉtoáre, mamarã́rẽ cʉ̃́ã quẽẽrṍpʉ ẽñogʉ̃́dacu too síropʉ wáaadarere. ");
INSERT INTO tue_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yʉʉre padecoterare Espíritu Santore ticodiocogʉdacu. Cʉ̃́ãcã yʉʉ wededutirere wedeadacua. ");
INSERT INTO tue_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ʉ̃mʉã́sepʉre merẽã bauré tiigʉ́dacu. Atiditapʉ́re díi, pecame, õme yʉʉ tiiẽ́ñore niiãdacu. ");
INSERT INTO tue_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Muĩpũ bʉ́reco macʉ̃ naĩtĩãjõãgʉ̃daqui. Muĩpũ ñami macʉ̃ díi tiiróbiro sõãgʉ̃́ wáagʉdaqui. Marĩ Õpʉ̃ jeaadari bʉreco sʉguero teero wáaadacu. Quioníri bʉreco niiãdacu. Bʉ́ri niirí bʉreco mee niiãdacu. ");
INSERT INTO tue_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sĩcʉ̃: “Yʉʉ Õpʉ̃, yʉʉre netõnéña” jĩĩ sãĩgʉ̃́no netõnénogʉ̃daqui, jĩĩ jóarigʉ niiwĩ Joel, jĩĩ wedeyigʉ Pedro—. ");
INSERT INTO tue_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Yáa wedera, yʉʉ jĩĩrére ãñurõ tʉoyá, jĩĩyigʉ sũcã—. Jesús Nazaret macã macʉ̃rẽ mʉ́ã ĩñajĩyu. Cõãmacʉ̃ cʉ̃ʉ̃mena pee ãñuré tiirígʉ niiwĩ. Bayiró tutuaremena tiiẽ́ñore tiirígʉ niiwĩ cʉ̃ʉ̃mena. Teeré mʉ́ã ãñurõ masĩã. ");
INSERT INTO tue_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mʉ́ã cʉ̃ʉ̃rẽna curusapʉ sĩãdutíra, ñañarã́pʉre ticowʉ. Cõãmacʉ̃ tíatopʉ “teero wáaadacu” jĩĩrirobirora wáawʉ. ");
INSERT INTO tue_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Cõãmacʉ̃ Jesuré diarigʉpʉre masõrigʉ niiwĩ. Cʉ̃ʉ̃ diadoaririgʉ niiwĩ. Masãgʉ̃dʉ niigʉ̃ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tíatopʉ David jóasʉguerigʉ niiwĩ Cristo Cõãmacʉ̃mena wedeseadarere: Yʉʉ yʉʉ Õpʉ̃rẽ yʉʉ díamacʉ̃pʉ ĩñarucujãwʉ̃. Cʉ̃ʉ̃ yʉʉ diamacʉ̃́pe niirĩ, cuiria. ");
INSERT INTO tue_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Teero tiigʉ́, yʉʉ bayiró ʉsenigʉ̃ wedesea. Yáa ʉseromena bayiró ʉsenigʉ̃ basaa. Yáa yeeripũnarẽ diarira ĩñanorõpʉ mʉʉ cṹũdoaricu. Yʉʉre “bóarijããrõ” jĩĩgʉ̃dacu mʉʉ, yʉʉre maĩgʉ̃́. Teero tiigʉ́, yʉʉ ãñurõ cuire manirṍ niijãgʉ̃dacu, mʉʉrẽ yuegʉ. ");
INSERT INTO tue_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yʉʉre catiré petihére bʉanʉcã́rĩ tiiwʉ́. Mʉʉrẽ ĩñagʉ̃, ʉseniremena niigʉ̃dacu, jĩĩ jóarigʉ niiwĩ David. ");
INSERT INTO tue_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Yáa wedera, ãñurõ tʉojĩ́ña ména marĩ ñecʉ̃ Daviyé maquẽrẽ. Cʉ̃ʉ̃ diajõãyigʉ. Cʉ̃ʉ̃ diari, cʉ̃ʉ̃rẽ yaaríra niiwã. Cʉ̃ʉ̃ diari yaarí cope masãcope marĩ pʉtopʉra niiã ména. ");
INSERT INTO tue_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David catigʉ, profeta niirigʉ niiwĩ. Cõãmacʉ̃ too síropʉ tiiádarere masĩjĩgʉ̃, wederigʉ niiwĩ: “Mʉʉ pã́rãmi niinʉnʉsegʉpʉ mʉʉ dutirobirora atiditaré Õpʉ̃ niigʉ̃daqui”, jĩĩrigʉ niiwĩ Cõãmacʉ̃ quioníremena. ");
INSERT INTO tue_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Teero tiigʉ́, David Cõãmacʉ̃ beserigʉ diarigʉpʉre masõriguere ĩñagʉ̃ tiiróbiro jóarigʉ niiwĩ: “Mʉʉ yʉʉre diarira ĩñanorõpʉ cõãdoaricu. Yáa õpʉ̃ʉ̃ bóaricu”. ");
INSERT INTO tue_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesuré wáaadarere jóarigʉ niiwĩ. Cõãmacʉ̃ cʉ̃ʉ̃rẽna masõrigʉ niiwĩ. Teeré ʉ̃sã niipetira ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cõãmacʉ̃ cʉ̃ʉ̃rẽ ʉ̃mʉã́sepʉ néemʉãrigʉ niiwĩ, cʉ̃ʉ̃ diamacʉ̃́pe duiaro jĩĩgʉ̃. Cʉ̃ʉ̃ Pacʉ tíatopʉ jĩĩrirobirora cʉ̃ʉ̃rẽ Espíritu Santore ticoyigʉ. Cʉ̃ʉ̃pe ʉ̃sãrẽ ticonetõnecoarigʉ niiãwĩ. Teerá niiã mʉ́ã ĩñaãrigue, mʉ́ã tʉoárigue. ");
INSERT INTO tue_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davipé cʉ̃ʉ̃ya õpʉ̃ʉ̃mena ʉ̃mʉã́sepʉre mʉãwaririgʉ niiwĩ. Mʉãwaripacʉ, ateré jóarigʉ niiwĩ: Cõãmacʉ̃ jĩĩwĩ yʉʉ Õpʉ̃rẽ: “Yáa wãmo diamacʉ̃́niñape duiya, ");
INSERT INTO tue_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tée mʉʉrẽ ĩñatutirare mʉʉ dutiriguere yʉʉ ãñurõ yʉʉri tiirípʉ”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Teero tiirá, judíoa niipetira tʉomasĩ́ãrõ. Mʉ́ã Jesuré curusapʉ páabiatu sĩãdutípacari, Cõãmacʉ̃ cʉ̃ʉ̃rẽna marĩ Õpʉ̃ wáari tiirígʉ niiwĩ. Cõãmacʉ̃ cʉ̃ʉ̃rẽ ticodiocorigʉ niiwĩ, marĩrẽ netõnéãrõ jĩĩgʉ̃, jĩĩ wedeyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, bayiró wãcũpati, sãĩñáyira: —Ʉ̃sãya wedera, ¿ʉ̃sã deero tiiádari? jĩĩyira Pedrore, ãpẽrã́ Jesús beserirare. ");
INSERT INTO tue_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro cʉ̃́ãrẽ yʉʉyigʉ: —Wãcũpati, wasoyá mʉ́ã ñañaré tiirére. Jesucristore padeó, wãmeõtidutiya. Mʉ́ã teero tiirí, mʉ́ã ñañaré tiirére Cõãmacʉ̃ acabógʉdaqui. Espíritu Santo mʉ́ãpʉre niigʉ̃ jeari tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cõãmacʉ̃ marĩ Õpʉ̃ tíatopʉ jĩĩrirobirora mʉ́ãrẽ, mʉ́ã põna niinʉnʉserare, yoaro macãrãcãrẽ, niipetira cʉ̃ʉ̃ beseráre Espíritu Santore ticogʉdaqui, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cʉ̃ʉ̃ tee dícʉ wederiyigʉ. Cʉ̃́ãrẽ wãcũtutuare tico, ãñurõ quioníremena wedenemoyigʉ: —Atibʉ́reco macãrã ñañaré tiirére dutijṍãña. Cõãmacʉ̃ netõnérepere ñeeña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro wedeariguere padeorá wãmeõtinoyira. Tiibʉrecora Jesuré padeorámena tres mil watoa basocá niinemoyira. ");
INSERT INTO tue_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Cʉ̃́ã Jesús beserira buerére tʉorucúyira. Niipetira Jesuré padeorá cãmerĩ́ wéepeo niijãyira. Sʉoyá, Cõãmacʉ̃rẽ sãĩ tiirucúyira. ");
INSERT INTO tue_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús beserira diarecʉtirare netõné, apeyé pee Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñoyira. Cʉ̃́ã tiirére ĩñarã, basocá niipetira cuirucuyira. ");
INSERT INTO tue_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesuré padeorá sicapõna macãrã tiiróbiro niiyira. Cʉ̃́ã cʉorére cãmerĩ́ batorucuyira. ");
INSERT INTO tue_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Peedita cʉorá, apeyenó pee cʉorá teeré dúayira. Cʉ̃́ã dúa wapatáriguere apeyenó cʉohérare batoyira. ");
INSERT INTO tue_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bʉ́recoricõrõ niipetira súubusera neãyira Cõãmacʉ̃wiipʉ. Cʉ̃́ãye wiseripʉ ʉseniremena cãmerĩ́ sʉoyárucuyira. ");
INSERT INTO tue_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Cõãmacʉ̃rẽ ʉsenire ticorucujãyira. Ãpẽrãcã́ cʉ̃́ãrẽ ãñurõ ĩña padeoyíra. Bʉ́recoricõrõ Cõãmacʉ̃ padeorí tiiyígʉ cʉ̃ʉ̃rẽ padeohérare. Jõõpemena Jesuré paʉ padeomʉ́ãnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sicabʉreco coeritó siro tres niirĩ, Pedro, Juan Cõãmacʉ̃wiipʉ wáara tiiyíra. Tiiwiipʉ́re bʉ́recoricõrõ tii horare Cõãmacʉ̃rẽ basocá súubuseyira. ");
INSERT INTO tue_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Toopʉ́ sĩcʉ̃ basocʉ́ wáamasĩhẽgʉ̃ duiyigʉ. Sicato bauágʉpʉra posarigʉ niiyigʉ. Bʉ́recoricõrõ Cõãmacʉ̃wii sope sããwaro cʉ̃ʉ̃rẽ néewa dʉpoyira. Tiisope wãmecʉtia Ãñurí Sope. Too sããwarare niyeru sãĩduíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro, Juan sããwaadara tiirí ĩñagʉ̃, cʉ̃́ãrẽ niyeru sãĩyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pʉarã́pʉra cʉ̃ʉ̃rẽ ĩñayira. Pedrope: —Ʉ̃sãrẽ ĩñaña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Cʉ̃ʉ̃ cʉ̃́ãrẽ bayiró ĩñayigʉ. “Yʉʉre niyeru, apeyenó ticoadara tiicúa”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro cʉ̃ʉ̃rẽ jĩĩyigʉ: —Niyeru cʉoría yʉʉ. Teeré cʉorípacʉ, mʉʉrẽ tiiápugʉda. Jesucristo Nazaret macã macʉ̃ tutuaremena mʉʉrẽ jĩĩã: Wʉ̃mʉnʉcã, wáaya. ");
INSERT INTO tue_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tee jĩĩgʉ̃rã, cʉ̃ʉ̃ duigʉ́re diamacʉ̃́ macã wãmorẽ ñee, wéemʉõcoyigʉ. Cʉ̃ʉ̃ wéemʉõcorira, máata cʉ̃ʉ̃ye dʉpori, cʉ̃ʉ̃ ãñayepa tutuajõãyiro. ");
INSERT INTO tue_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Bupucʉtʉ́a, wʉ̃mʉnʉcã, wáanʉcãyigʉ. Wáagʉra, bupuwá, Cõãmacʉ̃wiipʉ cʉ̃́ãmena sããwayigʉ. Ʉsenire ticoyigʉ Cõãmacʉ̃rẽ. ");
INSERT INTO tue_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Niipetira Cõãmacʉ̃wiipʉ niirã́ cʉ̃ʉ̃rẽ ĩñamasĩyira. —Ĩ́ni jõõ bupuwágʉ, Cõãmacʉ̃rẽ ʉsenire ticogʉ́ Ãñurí Sopepʉ niyeru sãĩduíarigʉra niiĩrã, jĩĩyira. Cʉ̃ʉ̃rẽ wáarere ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wáamasĩhẽgʉ̃ niiãrigʉ cʉ̃́ãrẽ duuríyigʉ. Basocá cʉ̃ʉ̃rẽ ĩñamanijõã, Pedro, Juan pʉtopʉ cʉtʉsã́jeayira. Too cʉ̃́ã neãrṍ biayá manirí tatia niiã. Tiitatia wãmecʉtia Pórtico de Salomón. ");
INSERT INTO tue_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cʉ̃́ã cʉtʉsã́jeari ĩñagʉ̃, Pedro cʉ̃́ãrẽ jĩĩyigʉ: —Yáa wedera, ¿deero tiirá mʉ́ã nocõrõca ĩñamanijõãĩ? ¿Deero tiirá mʉ́ã ʉ̃sãrẽ bayiró ĩñaĩ? Mʉ́ã ʉ̃sãrẽ “ĩ́niã basocá ãñurã́ niijĩrã, cʉ̃́ã tutuaremena wáari tiiíya” jĩĩ wãcũã. ");
INSERT INTO tue_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Marĩ ñecʉ̃sʉ̃mʉã Abraham, Isaac, Jacob, ãpẽrã́ marĩ ñecʉ̃sʉ̃mʉã Õpʉ̃ niirigʉ niiĩ Cõãmacʉ̃. Cʉ̃ʉ̃rã́ “Jesús ʉpʉtí macʉ̃ niiĩ; ãñuniĩ” jĩĩ, ẽñorígʉ niiwĩ. Jesuré mʉ́ãrẽ dutirápʉre ticowʉ. Pilato ĩñacoro mʉ́ã cʉ̃ʉ̃rẽ booríwʉ. Cʉ̃ʉ̃ “ĩ́nirẽ wionécogʉdʉ tiia” jĩĩpacari, mʉ́ã “wionécorijãña” jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús ñañaré manigʉ̃́, ãñuré tiigʉ́re mʉ́ã booríwʉ. Basocá sĩãgʉ̃́pere wionécodutiwʉ Pilatore. ");
INSERT INTO tue_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jesús marĩrẽ catiré ticogʉ́pere sĩãdutíwʉ. Cõãmacʉ̃ cʉ̃ʉ̃rẽ diarigʉpʉre masõrigʉ niiwĩ. Ʉ̃sã teeré ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesús cʉ̃ʉ̃ tutuaremena ãni mʉ́ã ĩñamasĩgʉ̃rẽ wáari tiiárigʉ niiãwĩ. Jesús ʉ̃sã cʉ̃ʉ̃rẽ padeorí ĩñagʉ̃, mʉ́ã ĩñacoro ãnirẽ́ ãñurõ netõnéãrigʉ niiãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yáa wedera, mʉ́ã “Cõãmacʉ̃ macʉ̃ niiĩ” jĩĩ masĩrijĩrã, cʉ̃ʉ̃rẽ sĩãdutíwʉ. Marĩrẽ dutirácã teerora tiiwá. ");
INSERT INTO tue_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cõãmacʉ̃pe Cristo cʉ̃ʉ̃ beserigʉ ñañarõ netõã́darere wedetoarigʉ niiwĩ. Niipetira profetas teeré jóarira niiwã. Mʉ́ã cʉ̃ʉ̃rẽ ñañarõ tiiríguemena teeré wáari tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mʉ́ã ñañaré tiirére wãcũpati, wasoyá. Cõãmacʉ̃ booróbirora tiiyá. Teero tiirí, Cõãmacʉ̃ mʉ́ã ñañaré tiirére acabó, ãñurõ niirecʉtiri tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jesucã́rẽ ticodiocogʉdaqui sũcã. Cʉ̃ʉ̃ Cõãmacʉ̃ beserigʉ Cristo niiĩ. ");
INSERT INTO tue_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mecʉ̃tígã cʉ̃ʉ̃rẽ ʉ̃mʉã́sepʉ pʉtʉáro booa, tée Cõãmacʉ̃ niipetirere wasorípʉ. Teeré Cõãmacʉ̃ cʉ̃ʉ̃yara profetas ãñurã́mena wedesʉguerigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés biiro jóarigʉ niiwĩ: “Too síropʉ marĩ Õpʉ̃ Cõãmacʉ̃ profetare ticocogʉdaqui. Yʉʉ tiiróbiro tiigʉ́daqui. Cʉ̃ʉ̃ marĩya wedegʉ niigʉ̃daqui. Niipetire cʉ̃ʉ̃ wederére tʉopetíjãña mʉ́ã. ");
INSERT INTO tue_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ãpẽrã́ cʉ̃ʉ̃ dutirére tiidʉgáherano judíoamena niinemoricua; sĩãjã́noãdacua”, jĩĩ jóarigʉ niiwĩ Moisés. ");
INSERT INTO tue_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Samuel, ãpẽrã́ profetas mecʉ̃tígã wáarere jóasʉguerira niiwã. ");
INSERT INTO tue_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Cõãmacʉ̃ cʉ̃ʉ̃yara profetamena mʉ́ãrẽ wederigʉ niiwĩ. Cõãmacʉ̃ mʉ́ã pacʉsʉ̃mʉãrẽ, teero biiri mʉ́ãrẽ cʉ̃ʉ̃ netõnére quetire ticowi. Tee quetire ticogʉ, Abrahamrẽ ateré jĩĩrigʉ niiwĩ: “Mʉʉ pã́rãmi niinʉnʉsegʉmena niipetira atiditá macãrãrẽ ãñurõ tiigʉ́da”, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Cõãmacʉ̃ cʉ̃ʉ̃ macʉ̃ diarigʉpʉre masõ, marĩrẽ ticocosʉguerigʉ niiwĩ. Teeména marĩrẽ ãñurõ tiirígʉ niiwĩ. Marĩ ñañaré tiirére duudutírigʉ niiwĩ, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro, Juan basocáre wedera tiirí, paiá, ãpĩ Cõãmacʉ̃wii coterí basocare dutigʉ́, ãpẽrã́ saduceo basoca jeayira. ");
INSERT INTO tue_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro, Juanména jĩĩyigʉ: —Cõãmacʉ̃ Jesuré diarigʉpʉre masõrigʉ niiwĩ. Teero tiirá, marĩcã diaari siro, masããdacu, jĩĩyigʉ. Saduceo basoca, cʉ̃́ãmena jeaarira tee buerére tʉorá, bayiró cúayira. ");
INSERT INTO tue_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Cúa, Pedro, Juanrẽ́ ñeewayira. Muĩpũ sããritopʉ niirĩ ĩñarã, cʉ̃́ãrẽ ñeewa, peresu sõnecoyira. ");
INSERT INTO tue_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Cõãmacʉ̃wiipʉ cʉ̃́ã bueariguere tʉoárira paʉ Jesuré padeonʉcã́yira. Jesuré padeorámena niirã, ʉ̃mʉã́ dícʉre bapaqueori, cinco mil niiyira. ");
INSERT INTO tue_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Apebʉ́recope judíoare dutirá, ãpẽrã́ bʉtoá dutirá, teero biiri Moisés jóarigue buerá tiimacã Jerusalénpʉ neãyira. ");
INSERT INTO tue_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Cʉ̃́ãmena ãpẽrã́ neãyira: Anás (cʉ̃ʉ̃ paiaré dutigʉ́ niiyigʉ), Caifás, Juan, Alejandro, ãpẽrã́ paiaré dutiráya wedera. ");
INSERT INTO tue_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Neãtoa, Pedro, Juanrẽ́ cʉ̃́ã pʉtopʉ néeatidutiyira. Cʉ̃́ã pʉto jeari: —¿Noã dutirémena teeré tiiárĩ mʉ́ã? jĩĩ sãĩñáyira. ");
INSERT INTO tue_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro, Espíritu Santo cʉ̃ʉ̃mena niirĩ, cʉ̃́ãrẽ yʉʉyigʉ: —Ʉ̃sãrẽ dutirá, teero biiri bʉtoá dutirá, ");
INSERT INTO tue_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mʉ́ã mecʉ̃ã ʉ̃sãrẽ sãĩñáã, ʉ̃sã ãñurõ tiiárigue maquẽrẽ masĩdʉgara. Mʉ́ã “¿ñeenómena cʉ̃ʉ̃rẽ wáamasĩhẽgʉ̃ niimiãrigʉre netõnéãrĩ?” jĩĩ sãĩñárã tiicú. ");
INSERT INTO tue_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mʉ́ã sãĩñáãriguere yʉʉgʉda, mʉ́ã niipetira, teero biiri niipetira Israelya põna macãrã masĩãrõ jĩĩgʉ̃. Jesucristo Nazaret macã macʉ̃ mʉ́ã curusapʉ páabiatudutirigʉ tutuaremena ãni mʉ́ã ĩñacoropʉ niigʉ̃́rẽ netõnéãwʉ̃. Cõãmacʉ̃ cʉ̃ʉ̃rẽ diarigʉpʉre masõrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús ʉ̃tãqui mʉ́ã cõãriqui tiiróbiro niiĩ. Profeta tiiqui maquẽrẽ jóarigʉ niiwĩ: “Wii weerira ʉ̃tãquire booríyira. Cʉ̃́ã boorípacari, tiiquira ʉpʉtí macãqui pʉtʉáwʉ tiiwiipʉ́re”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ãpẽrãpʉ́ja netõnémasĩricua. Cʉ̃ʉ̃ sĩcʉ̃rã petihérimepʉ wáaborirare netõnémasĩĩ, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dutirá cʉ̃́ã cuiro manirṍ wederi ĩñarã, tʉomaníjõãyira. Cʉ̃́ã basiro cãmerĩ́ wedeseyira: —Ĩ́niã bʉ́ri niirã́, buerira mee niiĩya. Marĩ cʉ̃́ãrẽ ĩñamasĩã; Jesuména wáanetõrira niiĩya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pedro, Juan netõnéãrigʉ cʉ̃́ãmena nucũrĩ ĩñarã, deero jĩĩnemomasĩriyira. ");
INSERT INTO tue_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Cʉ̃́ãrẽ witiwadutiyira ména. Cʉ̃́ã sesaro cãmerĩ́ wedeseyira: ");
INSERT INTO tue_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Deero tiiádari marĩ ĩ́niãrẽ? Niipetira ãno Jerusalén macãrã cʉ̃́ã tiiẽ́ñoãriguere ĩñapetijããrira niiãwã. Teero tiirá, marĩ “tiiríawã” jĩĩmasĩricu. ");
INSERT INTO tue_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Basocá aperó macãrãpʉ teeré tʉonemórĩ tiiríjããda. “Mʉ́ã Jesuyére wedenemorĩ, mʉ́ã ñañarõ tiinóãdacu” jĩĩco cʉ̃́ãrẽ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wedesetoa, cʉ̃́ãrẽ sããatidutiyira sũcã. Cʉ̃́ã, cʉ̃́ã pʉtopʉ jeari, jĩĩyira: —¡Ãñurõ tʉoyá mʉ́ã! Jesuyére péerogã wedenemorijãña; buenemorijãña sáa, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro, Juan yʉʉyira: —¿Cõãmacʉ̃ ĩñacorore ʉ̃sã mʉ́ã dutirére o cʉ̃ʉ̃ dutirépere tiirí booi? Mʉ́ã basiro beseya. ");
INSERT INTO tue_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ʉ̃sã ĩñariguere, ʉ̃sã tʉoríguere wederipacara, niimasĩriga, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dutirápe bayiró tutuaremena dutinemoyira, cʉ̃́ãrẽ cuiaro jĩĩrã. Basocá cʉ̃ʉ̃rẽ wáaariguere ĩñarã, Cõãmacʉ̃rẽ ʉsenire ticoyira. Teero tiirá, cʉ̃́ãrẽ ñañarõ tiimasĩ́ri, wionécojãyira. ");
INSERT INTO tue_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cʉ̃́ã netõnéãrigʉ cuarenta cʉ̃marĩ nemorṍ cʉoyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cʉ̃́ãrẽ wionécoari siro, Jesuré padeorá niirṍpʉ wáayira. Paiaré dutirá, ãpẽrã́ bʉtoá dutirá jĩĩãriguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cʉ̃́ã wederi tʉorá, sĩcãrõména Cõãmacʉ̃rẽ jĩĩyira: —Ʉ̃sã Õpʉ̃, mʉʉ ʉ̃mʉã́se, atiyepá, día pairímaa, niipetire atibʉ́reco niirére tiirígʉ niiã. ");
INSERT INTO tue_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tíatopʉ Espíritu Santo wãcũré ticorémena mʉʉ ʉ̃sã ñecʉ̃ Daviré wededutirigʉ niiwʉ̃. David mʉʉ wededutiriguere biiro jóarigʉ niiwĩ: Judíoa niihẽrã Cõãmacʉ̃mena cúara ñañarã́ wáajãya. Judíoapeja “marĩ biiro tiiáda Cõãmacʉ̃rẽ” jĩĩãmajãya. ");
INSERT INTO tue_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Atibʉ́reco macãrã õpãrã́ neããya, Cõãmacʉ̃rẽ netõnʉcã́ cʉ̃ʉ̃rẽ ñañarõ tiidʉgára. Cʉ̃ʉ̃ beserigʉcãrẽ teerora ñañarõ tiidʉgáya, jĩĩ jóarigʉ niiwĩ David. ");
INSERT INTO tue_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Cʉ̃ʉ̃ jóarirobirora wáawʉ. Atimacãpʉ́re Herodes, Poncio Pilato, ãpẽrã́ judíoa niihẽrã, judíoamena neãwã. “Cʉ̃ʉ̃rẽ ñañarõ tiiáda” jĩĩrira niiwã mʉʉ macʉ̃ Jesús mʉʉ beserigʉre ñañarõ tiiádara. ");
INSERT INTO tue_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tíatopʉ mʉʉ “teerora wáaadacu” jĩĩrirobirora tiiríra niiwã. ");
INSERT INTO tue_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ʉ̃sã Õpʉ̃, cʉ̃́ã ʉ̃sãrẽ bayiró tutuaremena dutiawã, cuiaro jĩĩrã. Cʉ̃́ã jĩĩãriguere wãcũña. Ʉ̃sã mʉʉrẽ padecotera niiã. Ʉ̃sãrẽ mʉʉye quetire cuire manirémena wederi tiiyá. ");
INSERT INTO tue_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mʉʉ tutuaremena diarecʉtirare netõnéña. Mʉʉ sĩcʉ̃rã Jesús mʉʉ macʉ̃ cʉ̃ʉ̃ tutuaremena tiiẽ́ñodutiya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cʉ̃́ã tee jĩĩãri siro, cʉ̃́ã niirṍ cãmeñayiro. Espíritu Santo cʉ̃́ãpʉre niiyigʉ. Teero tiirá, Cõãmacʉ̃ye quetire cuiro manirṍ wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Jesús cʉ̃ʉ̃yere wededutigʉ beserira bayiró tutuaremena basocáre wedeyira: “Marĩ Õpʉ̃ Jesús diari siro, masãrigʉ niiwĩ. Cʉ̃ʉ̃ masãri siro, cʉ̃ʉ̃rẽ ĩñawʉ̃”, jĩĩyira. Niipetira Jesuré padeorá sĩcãrĩbíro wãcũré cʉoyíra. Cʉ̃́ã cʉorére “yée dícʉ niiã” jĩĩriyira. Teero tiirá, cʉ̃́ã cʉorére cãmerĩ́ batoyira. Cõãmacʉ̃ cʉ̃́ãrẽ bayiró tiiápuyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Wiserí, dita cʉorá dúayira. Cʉ̃́ã dúa wapatáariguere Jesús beserirare ticoyira. Jesús beserirape cʉ̃́ã ticoariguere cʉ̃́ã menamacãrãrẽ apeyenó cʉohérare batoyira. Teero tiirá, cʉ̃́ãya põna macãrã bóaneõrã maniyíra. ");
INSERT INTO tue_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Teebʉrecorire sĩcʉ̃ José wãmecʉtigʉ niiyigʉ. Chipre nʉcʉ̃rõ macʉ̃, Leviyá põna macʉ̃ niiyigʉ. Jesús beserirape cʉ̃ʉ̃rẽ Bernabé jĩĩyira. Bernabé griegoayemena “ãñurõ wãcũtutuari tiigʉ́” jĩĩrõ tiicú. ");
INSERT INTO tue_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Sicadita cʉ̃ʉ̃ye oteré ditare dúayigʉ. Cʉ̃ʉ̃ dúa wapatáariguere Jesús beserirare ticopetijãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ãpĩ Ananías wãmecʉtigʉ, cʉ̃ʉ̃ nʉmo Safiramena sicadita dúayira. ");
INSERT INTO tue_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías cʉ̃ʉ̃ dúa wapatáariguere néedʉo, dʉsarére ticoyigʉ Jesús beserirare. Cʉ̃ʉ̃ nʉmoména “biiro tiiáda” jĩĩtoayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro cʉ̃ʉ̃rẽ jĩĩyigʉ: —Ananías, ¿deero tiigʉ́ mʉʉ Satanárẽ yʉʉarĩ? Mʉʉ Espíritu Santore jĩĩditoayu, mʉʉ dúa wapatáariguere néedʉogʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tiidita mʉʉ dúaadari sʉguero, mʉʉya dita niiwʉ̃. Tee mʉʉ dúare wapa mʉʉye niyeru niiãjĩyu. ¿Deero tiigʉ́ “jĩĩditogʉda” jĩĩ wãcũãrĩ mʉʉ? Mʉʉ basocá dícʉre jĩĩditogʉ mee tiia; Cõãmacʉ̃cãrẽ jĩĩditogʉ tiia. ");
INSERT INTO tue_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Teeré tʉogʉ́ra, Ananías ñaacũmu, diajõãyigʉ. Ãpẽrã́ tee quetire tʉorá, cuipetijõãyira. ");
INSERT INTO tue_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Cʉ̃ʉ̃ diari, mamarã́ tiiwiipʉ́ sããwa, suti caserimena cõma, néewayira, cʉ̃ʉ̃rẽ yaará wáara. ");
INSERT INTO tue_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Itiá hora siro Safira cʉ̃ʉ̃ nʉmo niimiãrigo sããjeayigo. Teero wáaariguere masĩriyigo. ");
INSERT INTO tue_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro coore sãĩñáyigʉ: —Wedeya yʉʉre. ¿Mʉ́ãya dita dúara, nocõrõrã niyeru wapatáarĩ? jĩĩyigʉ. —Nocõrõrã wapatáawʉ̃ ʉ̃sã, jĩĩyigo. ");
INSERT INTO tue_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro coore jĩĩyigʉ: —¿Deero tiirá mʉ́ã sĩcãrĩbíro wãcũrémena “marĩ Õpʉ̃ Espíritu marĩrẽ ñañarõ tiiríqui” jĩĩ wãcũmiãrĩ? Mecʉ̃tígãrã mʉʉ manʉ niimiãrigʉre yaará jeaarira pʉtʉajeara tiiíya. Mʉʉcãrẽ teerora yaaádara néewaadacua, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cʉ̃ʉ̃ teero jĩĩrĩrã, máata coocã Pedro pʉto ñaacũmu, diajõãyigo. Coo manʉ niimiãrigʉre yaará jeaarira diaarigopʉre bʉajeáyira. Cʉ̃́ãrã coore néewa, yaará wáayira coo manʉnígʉ̃ pʉtopʉra. ");
INSERT INTO tue_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Niipetira Jesuré padeorá, ãpẽrã́ niipetira tee quetire tʉorá, bayiró cuiyira. ");
INSERT INTO tue_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Teebʉrecorire Jesús beserirare Cõãmacʉ̃ cʉ̃ʉ̃ sĩcʉ̃rã tiimasĩ́remena pee tiiẽ́ñorĩ tiiyígʉ basocá watoapʉre. Niipetira Jesuré padeorá Pórtico de Salomón tatiapʉ sĩcãrõména neãyira. ");
INSERT INTO tue_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ãpẽrã́ cʉ̃́ãmena bapacʉti, cui niiyira. Cʉ̃́ãrẽ bapacʉti, cuipacara, Jesuré padeoráre ãñurõ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ʉ̃mʉã́, numiã́ paʉ Jesuré padeomʉ́ãnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Diarecʉtirare maa wesapʉ néewa, cõãré caseri sotoapʉ cṹũyira. “Pedro netõwágʉ, cʉ̃ʉ̃ wãtĩcõãtucoro cʉ̃́ã sotoa netõwári, cʉ̃́ã diaré netõã́dacu”, jĩĩ wãcũyira. ");
INSERT INTO tue_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalén wesa niiré macãrĩ macãrãcã diarecʉtirare néewayira. Wãtĩã ñañarõ tiinórãcãrẽ néewayira. Niipetira netõnénoyira. ");
INSERT INTO tue_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Cʉ̃́ã teero tiirí tʉorá, paiaré dutigʉ́, niipetira cʉ̃ʉ̃ menamacãrã saduceo basoca ĩñatutiyira cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Teero tiirá, Jesús beserirare ñee, néewa, peresuwiipʉ sõnecomiyira. ");
INSERT INTO tue_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tiiñamirã ángele peresuwii sopepãmarẽ pã́õ, cʉ̃́ãrẽ néewitiatiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Cõãmacʉ̃wiipʉ basocáre wedera wáaya, jĩĩyigʉ—. “Jesuré padeoráre Cõãmacʉ̃ ãñurõ niirecʉtiri tiigʉ́daqui”, jĩĩ wedeya, jĩĩyigʉ ángele. ");
INSERT INTO tue_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cʉ̃ʉ̃ jĩĩãrirobirora bóemʉãatiri, Cõãmacʉ̃wiipʉ sããwa, bueyira. Tiibʉrecora paiaré dutigʉ́, cʉ̃ʉ̃ menamacãrãmena, judíoare dutirá, teero biiri bʉtoá dutiráre neãdutiyira. Cʉ̃́ã neãpetiari siro, peresuwiipʉ niirã́rẽ néeatidutimiyira. ");
INSERT INTO tue_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cõãmacʉ̃wii coterí basoca peresuwiipʉ jeara, cʉ̃́ãrẽ bʉaríyira. Cʉ̃́ã manirĩ́ ĩñarã, wedera wáayira. ");
INSERT INTO tue_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Toopʉ́ jea, cʉ̃́ãrẽ wedeyira: —Peresuwii ãñurõ biaári wii niimiãwʉ̃. Tiisope coterí basocacã ãñurõ cotemiãwã. Tiisopere pã́õ ĩñarĩ, sĩcʉ̃no maniã́wĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cʉ̃́ã teeré tʉorá, Cõãmacʉ̃wii coterí basocare dutigʉ́, paiaré dutirá dee tii masĩriyira. —¿Deero yapacʉtíadari ate? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cʉ̃́ã wãcũrã tiirí, sĩcʉ̃ jea, wedeyigʉ: —Tʉoyá ména. Mʉ́ã peresuwiipʉ sõnecomiãrira Cõãmacʉ̃wiipʉ basocáre buera tiiáwã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cʉ̃ʉ̃ wederi tʉorá, Cõãmacʉ̃wii coterí basoca cʉ̃́ãrẽ dutigʉ́mena cʉ̃́ãrẽ ñeerã wáayira. “Basocá cʉ̃́ãrẽ maĩrã́ marĩrẽ ʉ̃tãperimena déebocua” jĩĩrã, cʉ̃́ãrẽ néewara, ñañarõ tiiríyira. ");
INSERT INTO tue_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cʉ̃́ãrẽ judíoare dutirá decopʉ néejeari, paiaré dutigʉ́ cʉ̃́ãrẽ jĩĩyigʉ: ");
INSERT INTO tue_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ʉ̃sã mʉ́ãrẽ “cʉ̃ʉ̃ye maquẽrẽ buenemorijãña” jĩĩmiãwʉ̃. Ʉ̃sã mʉ́ãrẽ buedutiripacari, niipetiro ãno Jerusalénpʉre mʉ́ã bueré sesajõãtoaa. Mʉ́ã buerémena ʉ̃sãpere “cʉ̃́ã cʉ̃ʉ̃rẽ sĩãrĩ́ tiiwá” jĩĩrĩ tiidʉgára tiia, jĩĩyigʉ paiaré dutigʉ́. ");
INSERT INTO tue_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro, ãpẽrã́ Jesús beseriramena cʉ̃ʉ̃rẽ yʉʉyigʉ: —Basocá dutiré Cõãmacʉ̃ dutiré niihẽrĩ, Cõãmacʉ̃ dutirépere tiiró booa. ");
INSERT INTO tue_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Cõãmacʉ̃ marĩ ñecʉ̃sʉ̃mʉã Õpʉ̃ Jesuré diarigʉpʉre masõrigʉ niiwĩ. Jesús niiĩ mʉ́ã curusapʉ páabiatu diari tiirígʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Cʉ̃ʉ̃rẽna masõtoa, ʉ̃mʉã́sepʉ néemʉã, cʉ̃ʉ̃ya wãmo diamacʉ̃́niñape dʉpoyigʉ. Marĩrẽ netõnérigʉ, marĩ Õpʉ̃ niiãrõ jĩĩgʉ̃, teero tiirígʉ niiwĩ. Marĩ judíoa ñañaré tiirére wãcũpati, wasorí, marĩrẽ acabógʉdaqui. ");
INSERT INTO tue_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ʉ̃sã Jesús tiiríguere ĩñarira niijĩrã, teeré wedea. Espíritu Santocã ĩñarigʉ niiwĩ. Cõãmacʉ̃ cʉ̃ʉ̃ dutiré tiiráre Espíritu Santore ticoqui, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cʉ̃ʉ̃ tee jĩĩrĩ tʉorá, bayiró peti cúayira. Cʉ̃́ãrẽ sĩãdʉgámiyira. ");
INSERT INTO tue_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Cʉ̃́ã cúari ĩña, Gamaliel judíoare dutirá menamacʉ̃ wʉ̃mʉnʉcã: —Ãniãrẽ sʉowitíwaya ména, jĩĩyigʉ. Gamaliel fariseo basocʉ, Moisés jóarigue buegʉ́ niiyigʉ. Basocá “ãñuniĩ” jĩĩ padeogʉ́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Cʉ̃́ã sʉowitíwari siro, toopʉ́ niirã́rẽ jĩĩyigʉ: —Yáa wedera, ãñurõ wãcũña mʉ́ã cʉ̃́ãrẽ tiidʉgárere. ");
INSERT INTO tue_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tíatopʉre sĩcʉ̃ Teudas wãmecʉtigʉ “yʉʉ dutigʉ́ niiã” jĩĩ wãcũmiyigʉ. Cuatrocientos basocá cʉ̃ʉ̃ buerére nʉnʉyíra. Too síro cʉ̃ʉ̃rẽ ãpẽrã́ sĩãjã́yira. Cʉ̃ʉ̃rẽ sĩãã́ri siro, cʉ̃ʉ̃rẽ yʉʉmiãrira cʉ̃́ã booró wáabatejõãyira. Nocõrõrã cʉ̃ʉ̃ buemiãrigue petijṍãyiro. ");
INSERT INTO tue_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Too síro basocáre cʉ̃́ã bapaqueore bʉrecori niirĩ, ãpĩ Judas Galilea macʉ̃ niiyigʉ. Paʉ basocá cʉ̃ʉ̃rẽ nʉnʉrĩ́ tiimíyigʉ. Too síro cʉ̃ʉ̃cãrẽ sĩãjã́yira. Cʉ̃ʉ̃rẽ sĩãã́ri siro, cʉ̃ʉ̃rẽ yʉʉmiãriracã cʉ̃́ã booró wáabatejõãyira. ");
INSERT INTO tue_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Teero tiigʉ́, mʉ́ãrẽ wedea. Cʉ̃́ãrẽ teero ĩñajãña. Basocá dutirémena cʉ̃́ã bueri, petijṍããdacu. ");
INSERT INTO tue_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Cõãmacʉ̃ dutirémena cʉ̃́ã bueri docare, mʉ́ã sĩcãrĩbíricu. Mʉ́ã cʉ̃́ãrẽ cãmotára, Cõãmacʉ̃rẽ netõnʉcã́rã tiibócu, jĩĩyigʉ Gamaliel. ");
INSERT INTO tue_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Cʉ̃ʉ̃rẽ “jáʉ” jĩĩyira. Jesús beserirare sʉocó, tãna, “Jesuyé quetire wedenemorijãña” jĩĩ, cʉ̃́ãrẽ wionécojãyira. ");
INSERT INTO tue_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Cʉ̃́ã judíoare dutirá pʉtopʉ niiãrira witiyira ʉseniremena. Cãmerĩ́ wedeseyira: —Cõãmacʉ̃ marĩrẽ “ãpẽrã́ cʉ̃́ãrẽ ñañarõ buijã́pacari, Jesuyére bueduricua” jĩĩ masĩjĩyi, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bʉ́recoricõrõ Cõãmacʉ̃wiipʉ, wiseripʉ́ “Jesús Cõãmacʉ̃ beserigʉ niiĩ” jĩĩ wederucujãyira. ");
INSERT INTO tue_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jõõpemena paʉ Jesuré padeonʉcã́rã tiiyíra. Teebʉrecorire griegoaye wedesera hebreoaye wedeseramena cúayira. —Ʉ̃sãya wedera wapewia numiãrẽ bʉ́recoricõrõ péerogã yaaré ticorá niiãwʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Teero tiirá, cʉ̃́ã doce Jesús beserira Jesuré padeorá niipetirare wedeadara neãdutiyira. —Ʉ̃sã Cõãmacʉ̃yere wededu, yaaré batori, ãñuria. ");
INSERT INTO tue_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Teero tiirá, siete ʉ̃mʉã mʉ́ãmena niirã́rẽ beseya. “Cʉ̃́ãrã basocá ãñuũya” jĩĩrã́, Espíritu Santo dutiré tiirucúra, ãñurõ masĩrã́ niiãrõ. Mʉ́ã beseadarare yaaré batodutiadacu. ");
INSERT INTO tue_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ʉ̃sãpe Cõãmacʉ̃rẽ sãĩ, cʉ̃ʉ̃yere buerucujããdacu, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Niipetira: —Teerora wáaaro, jĩĩyira. Teero tiirá, sĩcʉ̃ Esteban wãmecʉtigʉre beseyira. “Cʉ̃ʉ̃ ãñurõ Cõãmacʉ̃rẽ padeói; cʉ̃ʉ̃mena Espíritu Santo niiqui”, jĩĩyira. Ãpẽrãrẽ́ Felipe, Prócoro, Nicanor, Timón, Parmenas, Nicolás beseyira. Nicolás Antioquía macʉ̃ judíoayʉ niiripacʉ, cʉ̃́ã tiiróbiro Cõãmacʉ̃rẽ padeogʉ́ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cʉ̃́ãrẽ besetoa, Jesús beserira pʉto néewayira. Cʉ̃́ã néejeari, Cõãmacʉ̃rẽ sãĩbosáyira. Cʉ̃́ã besearirare ñaapeóyira, Cõãmacʉ̃ mʉ́ãrẽ tiiápuaro jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Too síro Cõãmacʉ̃yere paʉ basocá masĩpetijõãrã tiiyíra. Jerusalén macãrã paʉ Jesuré padeorá niinʉcãyira. Paiacã́ paʉ Jesuyére tiinʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanrẽ Cõãmacʉ̃ ãñurõ tiiápuyigʉ. Teero tiigʉ́, tutuaremena Cõãmacʉ̃ dícʉ tiimasĩ́rere basocá ĩñacoropʉ tiiẽ́ñoyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Cʉ̃ʉ̃ pʉto ãpẽrã́ jeayira. Judíoa niiyira. Cʉ̃́ã dutiapenori basoca niimirira niiyira. Teero tiiró, cʉ̃́ã neãrí wii “Libertado” wãmecʉtiyiro. Ãpẽrã́ cʉ̃́ã menamacãrã judíoa Cirene macãrã, Alejandría macãrã, Cilicia dita macãrã, Asia dita macãrã niiyira. Cʉ̃́ã cúaremena Estebanrẽ sãĩñáyira. ");
INSERT INTO tue_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Estebanpe Espíritu Santo cʉ̃ʉ̃rẽ ãñuré masĩré ticorémena wedeseyigʉ. Teero tiirá, cʉ̃́ã cʉ̃ʉ̃mena wedese sĩcãrĩbíriyira. ");
INSERT INTO tue_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sĩcãrĩbíri, ãpẽrãrẽ́ niyeru tico, jĩĩyira: —Jĩĩditora wáaya. “Esteban Moisére dutiré cṹũriguere ñañarõ wedeseawĩ; Cõãmacʉ̃cãrẽ ñañarõ wedeseawĩ”, jĩĩ wedewa basocáre, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cʉ̃́ã jĩĩditoariguere tʉorá, niipetira basocá, ãpẽrã́ bʉtoá dutirá, teero biiri Moisés jóarigue buerá cúayira. Cʉtʉjeá, cʉ̃ʉ̃rẽ ñee, judíoare dutirá pʉtopʉ néewayira. ");
INSERT INTO tue_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jĩĩditoracãrẽ néewa, wedesedutiyira: —Ãni Cõãmacʉ̃wiire ñañarõ jĩĩãwĩ. Moisére dutiré cṹũriguecãrẽ teerora jĩĩãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Jesús Nazaret macã macʉ̃ Cõãmacʉ̃wiire cõãgʉ̃daqui; Moisés marĩrẽ tiidutíriguere wasojã́gʉ̃daqui” jĩĩrĩ tʉoáwʉ̃, jĩĩditoyira. ");
INSERT INTO tue_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Teeré tʉorá, judíoare dutirá, too duirá niipetira Estebanrẽ bayiró ĩñayira. Cʉ̃ʉ̃ya diapóa cʉ̃́ã ĩñarĩ, ángeleya diapóa tiiróbiro bauyíro. ");
INSERT INTO tue_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Paiaré dutigʉ́ Estebanrẽ sãĩñáyigʉ: —¿Diamacʉ̃́rã niiĩ ãniã mʉʉrẽ wedesãre? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban yʉʉyigʉ: —Yáa wedera, yʉʉ pacʉsʉ̃mʉã, ãñurõ tʉoádacu mʉ́ã, yʉʉ wederi. Cõãmacʉ̃ ãñurõ asibatégʉ marĩ ñecʉ̃ Abrahamrẽ bauáyigʉ, Mesopotamiapʉ cʉ̃ʉ̃ niirĩ. Harán macãpʉ cʉ̃ʉ̃ niigʉ̃ wáaadari sʉguero, cʉ̃ʉ̃rẽ wedeseyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Mʉʉya ditare, mʉʉya wederare cṹũjã, wáagʉa. Mʉʉ wáari, mʉʉ niiãdari ditare ẽñogʉ̃́da”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","’Teeré tʉogʉ́, Abraham caldeoaya ditapʉ niiãrigʉ Haránpʉ niigʉ̃ wáayigʉ. Toopʉ́ cʉ̃ʉ̃ pacʉ diaweojõãyigʉ. Cʉ̃ʉ̃ pacʉ diaweori siro, Cõãmacʉ̃ cʉ̃ʉ̃rẽ atiditá atitó marĩ niirṍrẽ atidutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cʉ̃ʉ̃ ãnopʉ́ jeari, dita ticoriyigʉ ména. Ticoripacʉ, “too síropʉ mʉʉye, mʉʉ pã́rãmerã niinʉnʉseraya dita niiãdacu” jĩĩyigʉ. Cõãmacʉ̃ teeré wederitore, Abraham põnamaníyigʉ ména. ");
INSERT INTO tue_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Cõãmacʉ̃ cʉ̃ʉ̃rẽ apeyé wedenemoyigʉ: “Mʉʉ pã́rãmerã niinʉnʉsera ãpẽrãyé ditapʉ niiãdacua ména. Dutiapenori basoca niiãdacua. Cuatrocientos cʉ̃marĩ cʉ̃́ãrẽ padeduti, ñañarõ tiiápeadacua. ");
INSERT INTO tue_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Cʉ̃́ãrẽ teero tiirí, yʉʉ tiidita macãrãrẽ ñañarõ tiigʉ́dacu. Yʉʉ teero tiiári siro, mʉʉ pã́rãmerã niinʉnʉsera witiadacua. Witi, atiditapʉ́ jea, yʉʉ dutiré tiiádacua”, jĩĩyigʉ Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Cõãmacʉ̃ Abrahamrẽ wedecũyigʉ: “Niipetira ʉ̃mʉãrẽ cʉ̃́ã cõnerígʉ yapa macã caseróre widecõã́ña. Ate yʉʉ jĩĩrére tiirá, mʉ́ã yʉʉmena niirére ẽñoã́dacu”, jĩĩyigʉ Cõãmacʉ̃. Teero tiigʉ́, Abraham cʉ̃ʉ̃ macʉ̃ Isaare ocho bʉ́recori cʉ̃ʉ̃ bauári siro, cʉ̃ʉ̃ cõnerígʉ yapa macã caseróre widecõã́yigʉ. Isaacã teerora tiiyígʉ cʉ̃ʉ̃ macʉ̃ Jacoré. Jacob teerora tiiyígʉ cʉ̃ʉ̃ põna doce põnarĩ pacʉsʉ̃mʉã niiãdarare. ");
INSERT INTO tue_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Jacob põna marĩ ñecʉ̃sʉ̃mʉã cʉ̃́ã bai Joseré ĩñatutira, Egiptopʉ wáarare dúayira. Cõãmacʉ̃pe cʉ̃ʉ̃mena niijãyigʉ, ");
INSERT INTO tue_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","niipetire cʉ̃ʉ̃rẽ ñañarõ netõbóarere netõrĩ́ tiigʉ́dʉ. Faraón Egipto dita macãrã õpʉ̃mena wedeseri, Cõãmacʉ̃ Joseré masĩré ticoyigʉ. Cõãmacʉ̃ Faraónrẽ ʉsenirĩ tiiyígʉ Joseména. Teero tiigʉ́, Faraón cʉ̃ʉ̃rẽ cʉ̃ʉ̃ doca macʉ̃ dutigʉ́ sõnecoyigʉ. Apeyeré, Faraón cʉ̃ʉ̃ya wii maquẽ paderé dutigʉ́ cṹũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Too síro niipetiro Egiptopʉre, Canaánpʉcãrẽ jʉabóare wáayiro. Teero tiirá, basocá teeditapʉ niirã́ bayiró ñañarõ netõrã́ tiiyíra. Marĩ ñecʉ̃sʉ̃mʉãcã yaaré bʉamasĩ́riyira. ");
INSERT INTO tue_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob “Egiptopʉ yaaré dúare niiãyiro” jĩĩré quetire tʉogʉ́, cʉ̃ʉ̃ põnarẽ́, marĩ ñecʉ̃sʉ̃mʉã niiãdarare, “yaaré sãĩrã́ wáaya” jĩĩcoyigʉ. Cʉ̃ʉ̃ sicato ticocogʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Cʉ̃́ã nemo jeari, José “yʉʉ mʉ́ã bai niiã” jĩĩ wedeyigʉ cʉ̃ʉ̃ sõwʉ̃sʉ̃mʉãrẽ. Faraóncã “cʉ̃́ã José sõwʉ̃sʉ̃mʉã niiãwã” jĩĩrĩ tʉoyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José, cʉ̃ʉ̃ sõwʉ̃sʉ̃mʉãmena queti ticocoyigʉ cʉ̃ʉ̃ pacʉpʉre. “Marĩ pacʉ, niipetira marĩya wederamena atiaro ãnopʉ́”, jĩĩcoyigʉ. Cʉ̃ʉ̃ya wederape “setenta y cinco” niiyira. ");
INSERT INTO tue_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacob “jáʉ” jĩĩ, Egiptopʉ wáajõãyigʉ. Toopʉ́ diayigʉ. Cʉ̃ʉ̃ põna marĩ ñecʉ̃sʉ̃mʉãcã toopʉ́ra diayira. ");
INSERT INTO tue_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacob diarigʉ õpʉ̃ʉ̃rẽ Siquempʉ néewayira. Toopʉ́ Abraham cʉ̃ʉ̃ Hamor põnarẽ́ ʉ̃tãtuti sãĩrítutipʉ cṹũyira. ");
INSERT INTO tue_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Abrahamrẽ Cõãmacʉ̃ jĩĩrigue jeaatiri, marĩ ñecʉ̃sʉ̃mʉã paʉ basocáputiyira Egiptopʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Cʉ̃́ã toopʉ́ niirĩrã, ãpĩ õpʉ̃ sããyigʉ. Cʉ̃ʉ̃ Josenígʉ̃ tiiríguere masĩriyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cʉ̃ʉ̃ marĩ ñecʉ̃sʉ̃mʉãrẽ jĩĩdito, ñañarõ tiiápeyigʉ. Cʉ̃́ã põna bauárare diaaro jĩĩgʉ̃, cõãdutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Teebʉrecorira Moisés bauáyigʉ. Cʉ̃ʉ̃ Cõãmacʉ̃ ĩñarĩ, ãñugʉ̃́gã niiyigʉ. Cʉ̃ʉ̃ pacʉsʉ̃mʉã ĩtĩã́rã muĩpũrã cʉ̃́ãya wiipʉ cʉ̃ʉ̃rẽ masõmiyira. ");
INSERT INTO tue_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dee tii masĩri, cʉ̃ʉ̃rẽ cõãjãyira. Cõããri sirogã, Faraón macõ cʉ̃ʉ̃rẽ ĩñabʉayigo. Ĩñabʉa, néema, coo macʉ̃ tiiróbiro cʉ̃ʉ̃rẽ masõyigo. ");
INSERT INTO tue_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egipto macãrã ãñurõ masĩrã́yere bueyira Moisére. Teero tiigʉ́, cuiro manirṍ wedesegʉ, õpʉ̃ tiiróbiro tiirécʉtigʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Moisés cuarenta cʉ̃marĩ cʉogʉ́, cʉ̃ʉ̃ya wedera Israelya põna macãrãrẽ ĩñadʉgagʉ, cʉ̃́ã pʉtopʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Toopʉ́ jeagʉ, sĩcʉ̃rẽ Egipto macʉ̃ páari ĩñayigʉ. Cʉ̃ʉ̃rẽ cãmeboságʉ, Egipto macʉ̃rẽ páasĩãjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Cʉ̃ʉ̃ basirope wãcũmiyigʉ: “Yʉʉmenarã Cõãmacʉ̃ yáa wederare dutiapenori basoca niirã́rẽ witiri tiigʉ́daqui. Cʉ̃́ã ateré masĩcua”, jĩĩ wãcũmiyigʉ. Cʉ̃́ã cʉ̃ʉ̃ tiiróbiro wãcũriyira. ");
INSERT INTO tue_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Apebʉ́reco ãpẽrã́ cʉ̃ʉ̃ya wedera pʉarã́ cãmerĩ́quẽrã tiirí bʉajeáyigʉ. Cʉ̃́ãrẽ cãmerĩ́quẽduri tiidʉgágʉ, “mʉ́ã sĩcʉ̃ya wedera niiã. ¿Deero tiirá cãmerĩ́ ñañarõ tiii?” jĩĩ wedemiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ãpĩrẽ́ bayiró ñañarõ tiigʉ́pe Moisére tuunécojãyigʉ. “Mʉʉ ʉ̃sãrẽ dutigʉ́ mee niiã; ʉ̃sãrẽ queti besegʉ́ mee niiã. ");
INSERT INTO tue_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mʉʉ ñamica Egipto macʉ̃rẽ sĩãã́rirobirora yʉʉre sĩãdʉgágʉ tiii sũcã?” jĩĩ yʉʉtutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, Moisés dutijṍãyigʉ. Madián ditapʉ wáa, aperó macʉ̃pʉ tiiróbiro nii, pʉarã́ ʉ̃mʉã põnacʉtíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Moisés tiiditapʉre cuarenta cʉ̃marĩ niiyigʉ. Sicabʉreco basocá manirṍ Sinaí ʉ̃tãgʉ̃́ pʉtopʉ wáayigʉ. Toopʉ́ yucʉsati jʉ̃ʉ̃rĩ ĩñayigʉ. Pecame jʉ̃ʉ̃rípõna decopʉ ángele bauáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés teeré ĩñagʉ̃, ĩñamanijõãyigʉ. “¿Deero tiiró tee wáamiĩto?” jĩĩ, pʉtogãsãñurõ ĩñaquẽnogʉ̃ wáayigʉ. Cʉ̃ʉ̃ pʉtogãpʉ jeari, Cõãmacʉ̃ tiimé decopʉ cʉ̃ʉ̃rẽ wedeseyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yʉʉ Cõãmacʉ̃ niiã. Mʉʉ ñecʉ̃sʉ̃mʉã Abraham, Isaac, Jacob Õpʉ̃ niiã”, jĩĩyigʉ. Moisés ñapõpiyigʉ. Cuigʉ, ĩñadujãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Cʉ̃ʉ̃rẽ wedesenemoyigʉ: “Mʉʉ yʉʉ pʉtora nucũã. Teero tiigʉ́, mʉʉ sapature tuuwéya. Tuuwégʉ, yʉʉre padeorére ẽñogʉ̃́dacu. ");
INSERT INTO tue_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yáara basoca Egiptopʉ niirã́rẽ ñañarõ tiiáperi ĩñaã. Cʉ̃́ã pũnisíre tʉoa. Cʉ̃́ãrẽ netõnégʉ̃dʉ diiátiawʉ̃. Teero tiigʉ́, mʉʉrẽ Egiptopʉ ticocogʉda”, jĩĩyigʉ Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Moisére boorírira too sʉgueropʉ jĩĩyira: “Mʉʉ ʉ̃sãrẽ dutigʉ́ mee niiã; ʉ̃sãrẽ queti besegʉ́ mee niiã”. Cʉ̃́ã tee jĩĩpacari, Cõãmacʉ̃pe Moisére cʉ̃́ãrẽ dutigʉdʉ, netõnégʉ̃dʉ sõnecoyigʉ sáa. Cõãmacʉ̃ ángelere jʉ̃ʉ̃rísatipʉ teeré wederi tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moiséra cʉ̃́ãrẽ néewitiwayigʉ. Cʉ̃ʉ̃rã́ Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñoyigʉ Egiptopʉre. Día Sõãrímaa pairímaapʉcãrẽ teerora tiiẽ́ñoyigʉ. Cuarenta cʉ̃marĩ basocá manirṍpʉ cʉ̃́ã wáari, teerora tiiẽ́ñorucujãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Cʉ̃ʉ̃rã́ Israelya põna macãrãrẽ wederigʉ niiwĩ: “Too síropʉ Cõãmacʉ̃ profetare ticocogʉdaqui. Cʉ̃ʉ̃ marĩya wedegʉ niigʉ̃daqui. Yʉʉ tiiróbiro tiigʉ́daqui”, jĩĩ jóarigʉ niiwĩ Moisés. ");
INSERT INTO tue_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés basocá manirṍpʉ marĩ ñecʉ̃sʉ̃mʉã neãrĩ, cʉ̃́ãmena niiyigʉ. Sinaí ʉ̃tãgʉ̃pʉ́ ángele cʉ̃ʉ̃rẽ wedeseyigʉ. Moisés Cõãmacʉ̃ dutiré petihérere ñeeyigʉ, marĩrẽ ticogʉdʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Cʉ̃ʉ̃rẽ marĩ ñecʉ̃sʉ̃mʉã tʉodʉgáriyira. Cʉ̃ʉ̃rẽ boohéra, Egiptopʉ cãmecópʉtʉadʉgamiyira. ");
INSERT INTO tue_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Teero tiirá, Aarónrẽ jĩĩyira: “Jõõ niiãrigʉ marĩrẽ Egiptopʉ néeatirigʉ cʉ̃ʉ̃ bauhéro yoajõãã. ¿Deero wáaayiri? Marĩ masĩria. Teero tiirá, ʉ̃sã padeoádarare weebosaya. Cʉ̃́ãrẽ marĩ apasʉgueadacu. Cʉ̃́ã marĩ wáaadarimarẽ ẽñoã́dacua”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Teebʉrecorire sĩcʉ̃ wecʉ wĩmagʉ̃ tiiróbiro baugʉ́ weeyira. Bosebʉreco tii, ecaráre sĩã, sóeditioyira cʉ̃́ã weearigʉre tiipéora. ");
INSERT INTO tue_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Cʉ̃́ã teero tiirí ĩñagʉ̃, Cõãmacʉ̃ cʉ̃́ã booró tiiáro jĩĩgʉ̃, cʉ̃́ãmena niiãrigʉ cõãjõãyigʉ. Cʉ̃́ã booró muĩpũrãrẽ, ñocõãrẽ́ padeoyíra. Teeré profetas jóarira niiwã: Cõãmacʉ̃ cʉ̃́ãrẽ jĩĩyigʉ: Mʉ́ã Israelya põna macãrã, basocá manirṍpʉre cuarenta cʉ̃marĩ niirã, ecaráre sĩã sóeditioriwʉ, yʉʉre padeorá. ");
INSERT INTO tue_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ãpĩ Moloc queorére padeorá, suti caserimena tiirí wiire apacãmesãwʉ̃. Ãpĩ Refán ñocõãwʉ̃́ mʉ́ã weerigʉcãrẽ padeorá, teerora tiiwʉ́. Ãniãrẽ mʉ́ã basirora weewʉ, padeoádara. Teero tiigʉ́, mʉ́ãrẽ ñee, néewadutigʉda Babilonia berupʉ, jĩĩyigʉ Cõãmacʉ̃, jĩĩ jóarira niiwã. ");
INSERT INTO tue_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Esteban wedenemoyigʉ: —Marĩ ñecʉ̃sʉ̃mʉã basocá manirṍpʉ Cõãmacʉ̃ basocámena niirí wiire cʉoyíra. Tiiwiiré Cõãmacʉ̃ Moisére cʉ̃ʉ̃ ẽñorírobirora tiidutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Marĩ ñecʉ̃sʉ̃mʉã niinʉnʉseraya wii pʉtʉáyiro. Josuémena néeatiyira tiiwiiré. Cʉ̃́ã atiditá ñeerã atiri, Cõãmacʉ̃ atiditá macãrãrẽ ãcũcoyigʉ. Cʉ̃́ã wáaweorepʉre niiyira. Yoari tiiwií ãnopʉ́ niiyiro, tée David cʉ̃ʉ̃ õpʉ̃ sããri siropʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David Cõãmacʉ̃ ãñurõ tiirére bʉagʉ́ jĩĩyigʉ: “Mʉʉ yʉʉ ñecʉ̃ Jacob padeorígʉya wiire mʉʉ niiãdari wiire tiibosádʉgaga”, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Cʉ̃ʉ̃ tiibosádʉgapacari, cʉ̃ʉ̃ macʉ̃ Salomónpʉ tiiwiiré tiibosáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́ basocá tiiré wiseripʉ niirii. Profeta teeré jóarigʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yʉʉ boorí, ʉ̃mʉã́se yʉʉ duirípĩrõ tiiróbiro niiãdacu; atiditapʉ́ yée dʉpori yeerisãgʉ̃dacu. Teero tiirá, yáa wii niiãdari wiire tiimasĩ́ria mʉ́ã. Yʉʉ yeerisããdaro tiimasĩ́ria. ");
INSERT INTO tue_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yʉʉ ate niipetirere tiiwʉ́, jĩĩyigʉ Cõãmacʉ̃, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban cʉ̃́ãrẽ jĩĩnemoyigʉ: —Mʉ́ã Cõãmacʉ̃ dutirére netõnʉcã́netõjõãã. Cʉ̃ʉ̃rẽ masĩhẽrã tiiróbiro cʉ̃ʉ̃ wederére tʉodʉgária. Espíritu Santo dutirére tiidʉgária. Mʉ́ã ñecʉ̃sʉ̃mʉã tiirírobirora tiijã́ã. ");
INSERT INTO tue_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mʉ́ã ñecʉ̃sʉ̃mʉã niipetira profetare ñañarõ netõrĩ́ tiiyíra. Marĩrẽ netõnégʉ̃dʉ atiadarere wedesʉguerirare sĩãjã́yira. Cʉ̃́ã wedesʉguerigʉ ãñugʉ̃́ jeari, mʉ́ã cʉ̃ʉ̃rẽ jĩĩditoremena wedesã, sĩãdutírira niiã. ");
INSERT INTO tue_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mʉ́ãrẽ Cõãmacʉ̃ ángeleamena cʉ̃ʉ̃ dutirére cṹũyigʉ. Teeré cṹũnorira niipacara, mʉ́ã netõnʉcã́netõjõãã, jĩĩyigʉ Esteban. ");
INSERT INTO tue_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cʉ̃ʉ̃ tee jĩĩrĩ tʉorá, cʉ̃́ãpe bayiró cúayira. Cʉ̃́ã cúare ẽñorã́, upire bacadiyóyira. ");
INSERT INTO tue_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebanpe Espíritu Santo cʉ̃ʉ̃mena niirĩ, ʉ̃mʉã́sepʉ ĩñamʉõco, Cõãmacʉ̃ ãñurõ asibatérere ĩñayigʉ. Cõãmacʉ̃ diamacʉ̃́pe Jesús nucũrĩ ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Cʉ̃ʉ̃ cʉ̃́ãrẽ ĩñagʉ̃, jĩĩyigʉ: —Jã́ã, ʉ̃mʉã́se pã́õrĩ ĩñaã; Cõãmacʉ̃ diamacʉ̃́pe niipetira sõwʉ̃ nucũrĩ ĩñaã yʉʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Cʉ̃ʉ̃ tee jĩĩrĩ tʉorá, bayiró acaribí, tʉodʉgáhera cʉ̃́ãye cãmopéri paabiáyira. Cʉ̃ʉ̃ pʉto sĩcãrõména cʉtʉjeá, cʉ̃ʉ̃rẽ ñee, tiimacã wesapʉ cõãjãyira. Cʉ̃́ãye suti sotoá sãñarére tuuwé, ticoyira sĩcʉ̃ mamʉrẽ cotedutira. Cʉ̃ʉ̃ wãmecʉtiyigʉ Saulo. Ticotoa, Estebanrẽ ʉ̃tãperimena déesĩãyira. ");
INSERT INTO tue_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cʉ̃́ã déesĩãrã tiirí, cʉ̃ʉ̃pe Cõãmacʉ̃rẽ sãĩyígʉ: —Jesús yʉʉ Õpʉ̃, yʉʉ yeeripũnarẽ ñeeña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ñicãcoberimena jeacũmujea, bayiró acaribíremena jĩĩyigʉ sũcã: —Õpʉ̃, acabóya ãniãrẽ ate cʉ̃́ã ñañaré tiirére, jĩĩyigʉ. Tee jĩĩtoa, diajõãyigʉ sáa. ");
INSERT INTO tue_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo Estebanrẽ sĩãrĩ́ ĩñagʉ̃, “ãñuã” jĩĩyigʉ. Tiibʉrecora Jerusalénpʉre Jesuré padeoráre ñañarõ netõrĩ́ tiinʉcã́yira. Niipetira Judea ditapʉ, Samaria ditapʉ dutibatéjõãyira. Jesús beserira dícʉ wáariyira. ");
INSERT INTO tue_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ãpẽrã́ ʉ̃mʉã́ Cõãmacʉ̃rẽ quioníremena padeorá Estebanrẽ yaayíra. Cʉ̃ʉ̃rẽ yaa, bayiró boorituayira. ");
INSERT INTO tue_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulope Jesuré padeoráre nemorṍ ñañarõ tiinetṍnʉcãyigʉ. Cʉ̃́ãye wisericõrõ sããwa, ʉ̃mʉã́rẽ, numiã́rẽ ñee, néewa, biadʉpóyigʉ peresuwiipʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Dutibatéwarira cʉ̃́ã wáaro Jesuyé quetire wedewayira. ");
INSERT INTO tue_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe Samaria dita niirí macãpʉ wáayigʉ. Toopʉ́ jea, “Jesús Cõãmacʉ̃ beserigʉ niiĩ” jĩĩrére wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñoyigʉ. Wãtĩã paʉ basocápʉre sããrirare witidutiyigʉ. Witiatira, bayiró acaribíyira. Paʉ wáamasĩhẽrãrẽ, opayuriri wáarare netõnéyigʉ. Cʉ̃ʉ̃ teero tiirí ĩñarã, niipetira cʉ̃ʉ̃ wederére ãñurõ tʉonʉnʉ́seyira. ");
INSERT INTO tue_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tiimacãpʉre bayiró ʉseniyira. ");
INSERT INTO tue_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Toopʉ́re sĩcʉ̃ basocʉ́ yái tiiróbiro niigʉ̃́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Simón. Cʉ̃ʉ̃ tiirémena Samaria dita macãrãrẽ ʉcʉanére tiiyígʉ. Cʉ̃́ãrẽ “ʉpʉtí macʉ̃ niiĩ” jĩĩ wãcũrĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ʉpʉtí macãrã, bʉ́ri niirã́ niipetira cʉ̃ʉ̃ jĩĩrére ãñurõ tʉonʉnʉ́seyira. “Ãni Cõãmacʉ̃ tutuare cʉogʉ́ niiqui”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yoari pee tiiẽ́ñoremena cʉ̃́ãrẽ ʉcʉanére tiiẽ́ñoyigʉ. Teero tiirá, cʉ̃ʉ̃rẽ tʉonʉnʉ́semiyira. ");
INSERT INTO tue_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe jea, Cõãmacʉ̃ dutiré basocápʉre niiãdare jeariguere bueyigʉ. “Jesús Cõãmacʉ̃ beserigʉ basocáre netõnégʉ̃ niiĩ” jĩĩrére bueyigʉ too macãrãrẽ. Ʉ̃mʉã́, numiã́ Jesuyé maquẽrẽ tʉo, padeotóa, wãmeõtidutiyira. ");
INSERT INTO tue_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón “yʉʉcã Jesuré padeóa” jĩĩ, wãmeõtiduti, Felipe wáaro cʉ̃ʉ̃rẽ nʉnʉyígʉ. Felipe Cõãmacʉ̃ sĩcʉ̃rã tiimasĩ́rere tiiẽ́ñojãgʉ̃ tiiyígʉ. Simón teeré ĩñagʉ̃, ĩñamanijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesús beserira Jerusalénpʉ niirã́ “Samaria dita macãrã Cõãmacʉ̃yere ãñurõ padeoáyira” jĩĩré quetire tʉoyíra. Teero tiirá, Pedro, Juanrẽ́ ticocoyira toopʉ́re. ");
INSERT INTO tue_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cʉ̃́ã toopʉ́ jea, cʉ̃́ãrẽ Cõãmacʉ̃rẽ sãĩbosáyira, cʉ̃́ãpʉre Espíritu Santo niigʉ̃ jeaaro jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Cʉ̃́ãmena Espíritu Santo niiriyigʉ ména. Jesús wãmemena dícʉ wãmeõtinorira niiyira. ");
INSERT INTO tue_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Cʉ̃́ãrẽ ñaapeóri, Espíritu Santo cʉ̃́ãpʉre niigʉ̃ jeayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón teeré ĩñagʉ̃, Jesús beserirare niyeru ticomiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Ate tiimasĩ́rere ticoya yʉʉcãrẽ, yʉʉ ñaapeórare Espíritu Santo cʉ̃́ãpʉre niigʉ̃ jeari, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro cʉ̃ʉ̃rẽ jĩĩyigʉ: —Mʉʉ Cõãmacʉ̃ tutuare ticorére “niyerumena sãĩgʉ̃́da” jĩĩ wãcũmiãjĩyu. Mʉʉmenarã tee niyeru pecamepʉ jʉ̃ʉ̃tẽrĩjããrõ. ");
INSERT INTO tue_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Cõãmacʉ̃ ĩñarĩ, mʉʉ diamacʉ̃́ wãcũria. Ate ʉ̃sã tiirére tiimasĩ́ria mʉʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Yʉʉ ĩñarĩ, mʉʉ ĩñatutire, mʉʉ ñañaré tiirípore niinetõjõãã mʉʉrẽ. Teero tiigʉ́, mʉʉ ñañaré wãcũrére wãcũpati, wasoyá. Cõãmacʉ̃rẽ acabóre sãĩñá. Apetó tiigʉ́, mʉʉ ñañarõ wãcũrére acabóboqui, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón jĩĩyigʉ: —Tee mʉ́ã jĩĩãrigue yʉʉre wáarijããrõ jĩĩrã, mʉ́ã yʉʉre Cõãmacʉ̃rẽ sãĩbosáya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Too síro Jesús beserira Jesús tiiríguere cʉ̃ʉ̃ bueriguere wedeyira. Teeré wedetoa, Samaria dita niiré macãrĩ macãrãrẽ Jesuyé ãñuré quetire wedepʉtʉayira, Jerusalénpʉ pʉtʉara. ");
INSERT INTO tue_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Felipere sĩcʉ̃ ángele bauá, wedeyigʉ: —Jerusalén niiwarima Gaza macã búarimapʉ wáaya. Tiimá basocá manirṍpʉ niiwacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe tiimapʉ́ búayigʉ. Toopʉ́ wáagʉ, sĩcʉ̃ Etiopía dita macʉ̃rẽ bʉajeáyigʉ. Tiidita õpõ doca macʉ̃ niipetire cooye niyerure coterí basocʉ niiyigʉ. Jerusalénpʉ Cõãmacʉ̃rẽ padeogʉ́ jearigʉ ");
INSERT INTO tue_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","coepʉtʉ́agʉ tiiyígʉ. Cʉ̃ʉ̃yawʉ tũnuríwʉ caballoa wéeriwʉpʉ sãñawayigʉ. Profeta Isaías jóariguere buegʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu Santo Felipere: —Iiwʉré quẽmʉ, tiiwʉ́ pʉtogã wáaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe tiiwʉ́ pʉtogãpʉ cʉtʉjeágʉ, Isaías jóariguere bueri tʉoyígʉ. Teeré tʉogʉ́: —¿Mʉʉ buerére tʉogári? jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Cʉ̃ʉ̃pe cʉ̃ʉ̃rẽ yʉʉyigʉ: —Tʉoríga. Yʉʉre wedegʉ́ maniĩ. Jãmʉ, mʉãsãña; yʉʉ pʉto sãñagʉ̃ atiya, jĩĩyigʉ. Cʉ̃ʉ̃ mʉãsãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Cõãmacʉ̃ye queti jóaripũ maquẽ cʉ̃ʉ̃ buearigue ate niiyiro: Oveja cʉ̃́ã sĩãgʉ̃́dʉre ñeewaro tiiróbiro basocʉ́re ñeewayira. Oveja wĩmagʉ̃rẽ póare cʉ̃́ã súari cʉ̃ʉ̃ ditamanírõbirora basocʉ́cã ditamaníyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Cʉ̃ʉ̃rẽ buijã́yira. Cʉ̃ʉ̃ ñañaré tiirípacari, cʉ̃ʉ̃rẽ wionécori booríyira. Cʉ̃́ã ñañarõ tiiríguere deero wedemasĩña maniã. Atiditapʉ́ cʉ̃ʉ̃ niiré petirí tiiyíra, jĩĩ jóariguere bueyigʉ. Ateré buegʉ tiiyígʉ Etiopía macʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía macʉ̃ teeré buetoanʉcõ, Felipere sãĩñáyigʉ: —¿Isaías cʉ̃ʉ̃ jĩĩgʉ̃́ noã niigari? ¿Cʉ̃ʉ̃ basirope o ãpĩ niigari? jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe cʉ̃́ã bueariguere wedesʉgue, niipetire Jesuyé quetire wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Maapʉ wáara, oco niirṍpʉ jeayira. Etiopía macʉ̃ jĩĩyigʉ: —Ĩñaña. Jõõ oco niiã. ¿Mʉʉ yʉʉre wãmeõtiri, ñeenó cãmotábogari? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Mʉʉ Jesucristore ãñurõ padeorí, cãmotáre manicú, jĩĩyigʉ Felipe. —Yʉʉ Jesuré padeóa. Cʉ̃ʉ̃rã́ Cõãmacʉ̃ beserigʉ niiĩ, jĩĩyigʉ Etiopía macʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Caballoa wéeriwʉ waatúgʉre pʉtʉánʉcãdutiyigʉ. Tiiwʉré pʉtʉánʉcõtoa, cʉ̃́ã pʉarã́ diinʉcã́, oco niirṍpʉ búa, wabawía, Felipe cʉ̃ʉ̃rẽ wãmeõtiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cʉ̃́ã wabapã́rĩ, Espíritu Santo Felipere aperopʉ́ néecocʉtʉayigʉ. Teero tiigʉ́, Etiopía macʉ̃ Felipere ĩñanemoriyigʉ. Ʉseniremena cʉ̃ʉ̃ wáarimapʉ wáayigʉ sáa. ");
INSERT INTO tue_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipepe aperopʉ́ bauágʉ, “Azotopʉ niiã” jĩĩ ĩñamasĩyigʉ. Tiimacãrẽ netõwá, macãrĩcṍrõ Jesuyé ãñuré quetire wedewarucu, Cesarea macãpʉ wedejeayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulope Jesuré padeoráre ĩñatutigʉ, cʉ̃́ãrẽ sĩãjã́gʉ̃da jĩĩgʉ̃, paiaré dutigʉ́re ĩñagʉ̃ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Cʉ̃ʉ̃rẽ sãĩyígʉ: —Yʉʉ Damascopʉ wáagʉ tiia. Dutirépũrĩrẽ jóabosaya yʉʉre. Teepũrĩrẽ judíoa neãré wiseri macãrã dutirápʉre wiyagʉ́dʉ tiia. Mama bueré padeorá ʉ̃mʉã́, numiã́rẽ ñeegʉ̃da. Cʉ̃́ãrẽ néeatigʉda ãno Jerusalénpʉ peresu tiigʉ́dʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Too síro teepũrĩmena Damascopʉ wáajõãyigʉ. Toopʉ́ jeagʉdʉ tiirí, wãcũña manirṍ ʉ̃mʉã́sepʉ cʉ̃ʉ̃ pʉto bóediatiyiro. ");
INSERT INTO tue_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Teero wáari, ñaacũmu, sĩcʉ̃ cʉ̃ʉ̃rẽ wedeseri tʉoyígʉ: —Saulo, ¿deero tiigʉ́ yʉʉre ñañarõ tiinʉnʉ́sei? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—¿Noã niiĩ mʉʉ? jĩĩyigʉ Saulo. —Yʉʉ Jesús, mʉʉ ñañarõ tiinʉnʉ́segʉra niiã. Mʉʉ basirope ñañarõ tiigʉ́ tiia, yʉʉre teero tiigʉ́, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo cui, ñapõpigʉ, jĩĩyigʉ: —Õpʉ̃, ¿deero yʉʉ tiirí boogári? Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Wʉ̃mʉnʉcãña. Iimacãpʉ wáaya. Toopʉ́ sĩcʉ̃ wedegʉdaqui mʉʉ tiiádarere, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulomena wáarira wedesere tʉorá, wedesemasĩrijõãyira. Teeré tʉopacára, wedesegʉre ĩñariyira. ");
INSERT INTO tue_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo wʉ̃mʉnʉcã, cʉ̃ʉ̃ capearire ĩñapõmiyigʉ. Baunóriyigʉ. Cʉ̃́ã cʉ̃ʉ̃ya wãmorẽ ñee, Damascopʉ tʉ̃ãwáyira. ");
INSERT INTO tue_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Itiábʉreco ĩñari, yaari, sĩniríyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascopʉre sĩcʉ̃ Jesuré padeogʉ́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Ananías. Cʉ̃ʉ̃ cãnirípacari, quẽẽrṍpʉ tiiróbiro Jesús cʉ̃ʉ̃rẽ wedeseyigʉ: —Ananías, jĩĩyigʉ. —¿Deero jĩĩĩ, yʉʉ Õpʉ̃? jĩĩ yʉʉyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Diamacʉ̃́ niiwarimapʉ wáaya. Toopʉ́ Judaya wiipʉ Tarso macʉ̃rẽ sãĩñáña. Cʉ̃ʉ̃ wãmecʉtii Saulo. Cʉ̃ʉ̃ yʉʉre sãĩgʉ̃́ tiii. ");
INSERT INTO tue_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Cʉ̃ʉ̃ quẽẽgʉ̃ tiiróbiro ate ĩñaãwĩ: Sĩcʉ̃ Ananías wãmecʉtigʉ cʉ̃ʉ̃ pʉtopʉ sããati, cʉ̃ʉ̃rẽ ñaapeó tiiáwĩ, ĩñaãrõ jĩĩgʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías jĩĩyigʉ: —Õpʉ̃, paʉ basocá queti wedeawã. Cʉ̃ʉ̃ Jerusalénpʉ niigʉ̃, mʉʉrẽ padeoráre ñañarõ tiigʉ́ tiiáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ãno macãrãcãrẽ mʉʉrẽ padeoráre ñeegʉ̃ jeaayigʉ. Paiaré dutirá dutirigue cʉoáyigʉ, jĩĩyigʉ Ananías. ");
INSERT INTO tue_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jesús cʉ̃ʉ̃rẽ jĩĩyigʉ: —Wáagʉa. Yʉʉ cʉ̃ʉ̃rẽ yée quetire wedegʉdʉre besetoawʉ. Cʉ̃ʉ̃ niipetire dita macãrãrẽ, cʉ̃́ã õpãrãrẽ́, Israelya põna macãrãrẽ wedewarucugʉ wáagʉdaqui. ");
INSERT INTO tue_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","“Jesuré padeóa” cʉ̃ʉ̃ jĩĩrémena cʉ̃ʉ̃ bayiró ñañarõ netõã́darere yʉʉ basiro cʉ̃ʉ̃rẽ masĩrĩ tiigʉ́da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Cʉ̃ʉ̃ teero jĩĩãri siro, Ananías toopʉ́ wáa, tiiwiipʉ́ sããwa, Saulore ñaapeó, jĩĩyigʉ: —Yáa wedegʉ, marĩ Õpʉ̃ Jesús, mʉʉ maapʉ atiri bauárigʉ, yʉʉre ticocoawĩ, mʉʉrẽ “ĩñaãrõ sũcã” jĩĩgʉ̃. “Espíritu Santo mʉʉmena niiãrõ”, jĩĩcoawĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Máata cʉ̃ʉ̃ capearipʉ wai nʉtʉ̃rĩ́ tiiróbiro bauré tusaarigue ñaacodiayiro. Ãñurõ ĩñayigʉ sũcã. Ĩña, wʉ̃mʉnʉcã, wãmeõtinoyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Too síro yaa, tutuajõãyigʉ sũcã. Jesuré padeorá Damascopʉ niirã́mena yoasãñurĩ pʉtʉáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Máata judíoa neãré wiseripʉ “Jesús Cõãmacʉ̃ macʉ̃ niiĩ” jĩĩrére wedenʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Niipetira cʉ̃ʉ̃ wederi tʉorá, tʉomaníjõãyira. —Ãni Jerusalénpʉ niigʉ̃, Jesuré padeoráre ñañarõ tiirígʉra niiĩrã. Ãnopʉ́cãrẽ Jesuré padeoráre ñeegʉ̃ atigʉ tiimíãyigʉ, Jerusalénpʉ cʉ̃́ãrẽ néewa, paiaré dutirápʉre ticogʉdʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulope cʉ̃ʉ̃ wederécõrõ jõõpemena nemorṍ wedemʉãnʉcãyigʉ. Wãcũtutuaremena “Jesús diamacʉ̃́rã Cõãmacʉ̃ beserigʉ niiĩ” jĩĩ ẽñopetíjãyigʉ. Ateména Damasco macãrã judíoare jĩĩwisiojãrucuyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yoari siro, judíoa neã, Saulore sĩãdutíadarere wedeseyira. ");
INSERT INTO tue_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Cʉ̃ʉ̃pe cʉ̃ʉ̃rẽ sĩãã́dare quetire tʉojã́yigʉ. Cʉ̃́ã bʉ́recori, ñamirĩ́, tiimacã witiwarepʉ cotemiyira, cʉ̃ʉ̃rẽ sĩãã́dara. ");
INSERT INTO tue_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Teero tiirá, ñamipʉ Saulo buerá cʉ̃ʉ̃rẽ “dutiwáya” jĩĩ, pairí piimena cʉ̃ʉ̃rẽ sãã, tiimacã sãnirõ macã sopegãpʉ duunʉnʉ́sediocoyira. ");
INSERT INTO tue_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cʉ̃ʉ̃ Jerusalénpʉ jeagʉ, ãpẽrã́ Jesuré padeorámena niidʉgamiyigʉ. Niipetira “cʉ̃ʉ̃ Jesuré padeogʉ́ mee niiĩ” jĩĩ, cuiyira. ");
INSERT INTO tue_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Cʉ̃́ã cuipacari, Bernabé cʉ̃ʉ̃rẽ tiiápugʉ, Jesús beserira pʉtopʉ néewayigʉ. Toopʉ́ jea, Saulo maapʉ Jesuré ĩñariguere, cʉ̃ʉ̃ cʉ̃ʉ̃mena wedeseriguere, cʉ̃ʉ̃ Damascopʉ Jesuyé quetire wãcũtutuaremena wederiguere wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bernabé wederipʉ, Saulo cʉ̃́ãmena niinʉcãyigʉ. Jerusalénpʉcãrẽ wãcũtutuaremena Jesuyé quetire wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ãpẽrã́ judíoa griegoaye wedeseramena cãmerĩ́ sãĩñá, wedeseyigʉ. Cʉ̃́ãpe cʉ̃ʉ̃rẽ sĩãdʉgápacara, deero tii sĩãmasĩ́riyira. ");
INSERT INTO tue_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cʉ̃́ã teero tiidʉgári ĩñarã, ãpẽrã́ Jesuré padeorá cʉ̃ʉ̃rẽ néebuayira Cesareapʉ. Toopʉ́mena cʉ̃ʉ̃rẽ Tarsopʉ ticocoyira sáa. ");
INSERT INTO tue_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Teebʉrecorimena Jesuré padeorá yeerisãyira. Jõõpemena niipetira Judea, Galilea, Samaria macãrã nemorṍ wãcũtutua, padeonemóyira. Jesús dutirére quioníremena tiirucújãyira. Espíritu Santo tiiápuremena paʉ ãpẽrã́ Jesuré padeohéra niiãrira padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro niipetire macãrĩpʉre ĩñanetõgʉ̃, Jesuré padeorá Lida macãpʉ niirã́rẽ ĩñagʉ̃ jeayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Toopʉ́ sĩcʉ̃ bʉajeáyigʉ. Ocho cʉ̃marĩ netõyíro cʉ̃ʉ̃ wáamasĩhẽgʉ̃ pesaró. Cʉ̃ʉ̃ wãmecʉtiyigʉ Eneas. ");
INSERT INTO tue_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro cʉ̃ʉ̃rẽ jĩĩyigʉ: —Eneas, Jesucristo mʉʉrẽ netõnéĩ. Wʉ̃mʉnʉcãña. Mʉʉ cõãrṍrẽ ĩñanoña, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩrĩrã, máata Eneas wʉ̃mʉnʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Niipetira Lida, Sarón macãrĩ macãrã cʉ̃ʉ̃rẽ ĩñarã, cʉ̃́ãcã Jesuré padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope wãmecʉtiri macãpʉ sĩcõ numiṍ Jesuré padeogó niiyigo. Coo wãmecʉtiyigo Tabita. Griegoayemena coo wãme Dorcas niiyiro. Coo ãñurõ tiirucújãyigo. Bóaneõrãrẽ ãñurõ tiiápuyigo. ");
INSERT INTO tue_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Teebʉrecorire diarecʉti, diajõãyigo. Coo diaari siro, cʉ̃́ã tiirucúrobirora cooya õpʉ̃ʉ̃rẽ coseyíra. Cosetóanʉcõ, sicatatia ʉ̃mʉã́rõ macã tatiapʉ péoyira. ");
INSERT INTO tue_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope Lida pʉtogã niicu. Teero tiirá, Jope macãrã Jesuré padeorá “Pedro Lidapʉ niiãyigʉ” jĩĩrĩ tʉorá, ʉ̃mʉã́ pʉarã́rẽ “Pedro boyero atiaro” jĩĩ duticoyira. ");
INSERT INTO tue_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Cʉ̃́ã Lidapʉ jeari, máata Pedro cʉ̃́ãmena wáayigʉ. Toopʉ́ jeari, coo diaarigo pesarí tatiapʉ cʉ̃ʉ̃rẽ néemʉãwayira. Tiitatiapʉ wapewia numiã Pedro wesa neãnʉcãyira. Cʉ̃́ã utirara, docasãñare, apeyé suti sotoá sãñaré coo catigo cʉ̃́ãrẽ jeebosáriguere ẽñoyíra. ");
INSERT INTO tue_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro niipetirare witiwadutiyigʉ. Cʉ̃́ã witiwaari siro, ñicãcoberimena jeacũmu, Cõãmacʉ̃rẽ sãĩyígʉ. Sãĩtóa, cãmenʉcã́, diaarigore jĩĩyigʉ: —Tabita, wʉ̃mʉnʉcãña. Cʉ̃ʉ̃ teero jĩĩrĩrã, coo capearire ĩñapõ, Pedrore ĩñagõrã, jeaconuãyigo. ");
INSERT INTO tue_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Cooya wãmopʉ ñee, coore wéemʉõnʉcõyigʉ. Wapewia numiãrẽ, ãpẽrã́ Jesuré padeorámena sããatiduti, catigópʉ wiyayígʉ. ");
INSERT INTO tue_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Niipetiro Jopepʉ tʉosesájõãyira. Teero tiirá, paʉ Jesuré padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro Jopepʉre peebʉrecori Simón wáicʉra caseri quẽnogʉ̃́ya wiipʉ pʉtʉáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesareapʉ sĩcʉ̃ cien surara dutigʉ́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Cornelio. Tii põna macãrã surara wãmecʉtiyira Italiano. ");
INSERT INTO tue_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio ãñuniyigʉ. Cʉ̃ʉ̃ya wii macãrã niipetira Cõãmacʉ̃rẽ quioníremena ĩña, padeorá niiyira. Cornelio judíoa bóaneõrãrẽ niyeru ticorucuyigʉ. Cõãmacʉ̃rẽ sãĩrucújãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sicabʉreco ñamica tres niirĩ, cãnirípacʉ, quẽẽgʉ̃ tiiróbiro ĩñayigʉ. Ángele cʉ̃ʉ̃ pʉto sããjeari ãñurõ ĩñajãyigʉ. —Cornelio, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio bayiró cuiremena ĩñayigʉ cʉ̃ʉ̃rẽ. —¿Deero jĩĩĩ? jĩĩ yʉʉyigʉ. Ángele cʉ̃ʉ̃rẽ jĩĩyigʉ: —Cõãmacʉ̃ mʉʉ sãĩrucúrere “jáʉ” jĩĩãwĩ. Mʉʉ bóaneõrãrẽ niyeru ticorécãrẽ ʉseniremena ĩñaãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jope wãmecʉtiri macãpʉ mʉʉ ʉ̃mʉã́rẽ ticocoya. Simón Pedro wãmecʉtigʉre atidutiya. ");
INSERT INTO tue_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Cʉ̃ʉ̃ wáicʉra caseri quẽnogʉ̃́ya wiipʉ niiqui. Cʉ̃ʉ̃cã wãmecʉtii Simón. Cʉ̃ʉ̃ya wii pairímaa wesapʉ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángele cʉ̃ʉ̃rẽ wedetoa, wáajõãyigʉ. Cʉ̃ʉ̃ wáaari siro, Cornelio cʉ̃ʉ̃ya wii padecotera pʉarã́rẽ, sĩcʉ̃ surara cʉ̃ʉ̃rẽ ãñurõ tiiápugʉre atidutiyigʉ. Suraracã Cõãmacʉ̃rẽ padeogʉ́ra niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Niipetire cʉ̃́ãrẽ wedetoa, Jopepʉ ticocoyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Apebʉ́reco coeritó niirĩ, cʉ̃́ã Jopepʉ jeaadaara tiiyíra. Pedro cʉ̃ʉ̃ niirí wii sotoapʉ Cõãmacʉ̃rẽ sãĩgʉ̃́ mʉãwayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jʉabóanʉcãgʉ̃, yaadʉgayigʉ. Tiiwií macãrã cʉ̃́ã yaaré doarí, cãnirípacʉ, quẽẽgʉ̃ tiiróbiro ĩñayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ʉ̃mʉã́se pã́õrĩ ĩñayigʉ. Toopʉ́ sicaró sutiróbiro baurí caseroca ditapʉ diiátiyiro. Bapari wesari siaríro niiyiro. ");
INSERT INTO tue_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tiicasero popeapʉre niipetiracõrõ wáicʉra páira, yepapʉ wéera, wʉʉrá sãñayira. ");
INSERT INTO tue_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sĩcʉ̃ cʉ̃ʉ̃rẽ wedeseri tʉoyígʉ: —Jã́ã, Pedro, ãniãrẽ sĩãyáya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrope cʉ̃ʉ̃rẽ yʉʉyigʉ: —Yaaria, yʉʉ Õpʉ̃. Ñañarã́ ʉ̃sã judíoa yaaya manirã́no niiĩya. Yʉʉ ãniãnorẽ yaahegʉ niitʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wedeseri tʉonemóyigʉ: —Cõãmacʉ̃ cʉ̃ʉ̃ “ãñurã́ niiĩya” jĩĩrã́rẽ mʉʉpe “ñañarã́, yaaya manirã́no niiĩya” jĩĩrijãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ĩtĩã́rĩ wedeseari siro, máata tiicasero ʉ̃mʉã́sepʉ mʉãjõãyiro sũcã. ");
INSERT INTO tue_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro bayiró wãcũrecʉtiyigʉ. “¿Deero jĩĩdʉgaro tiigári tee yʉʉ quẽẽgʉ̃ tiiróbiro ĩñaãrigue?” jĩĩ wãcũyigʉ. Teeré cʉ̃ʉ̃ wãcũgʉ̃ tiirí, Cornelio ticocoarira jeayira. “Simónya wii ¿noopʉ́ niiĩ?” jĩĩ sãĩñáãri siro, cʉ̃ʉ̃ya wiipʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jea, bayiró bʉsʉrómena sãĩñáyira: —¿Simón Pedro wãmecʉtigʉ atiwiiré niiĩ? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro cʉ̃ʉ̃ ĩñaãriguere wãcũgʉ̃ tiirí, Espíritu Santo cʉ̃ʉ̃rẽ jĩĩyigʉ: —Ĩtĩã́rã ʉ̃mʉã mʉʉrẽ ãmaãrã tiiíya. ");
INSERT INTO tue_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Boyero diiwágʉa. Cʉ̃́ãmena wáagʉa. “Cʉ̃́ã judíoa mee niiĩya; yʉʉ cʉ̃́ãmena wáari, ñañanibocu”, jĩĩ wãcũrijãña. Yʉʉ cʉ̃́ãrẽ ticocoawʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro diiwá: —Yʉʉ niiã mʉ́ã ãmaãgʉ̃. ¿Deero tiirónomena atiarĩ mʉ́ã? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Cʉ̃́ã yʉʉyira: —Sĩcʉ̃ cien surara dutigʉ́ Cornelio wãmecʉtigʉ ticocoawĩ. Cʉ̃ʉ̃ basocʉ́ ãñugʉ̃́, Cõãmacʉ̃rẽ quioníremena ĩñagʉ̃́ niiĩ. Cʉ̃ʉ̃rẽ niipetira judíoa “ãñuniĩ” jĩĩĩya. Sĩcʉ̃ ángele cʉ̃ʉ̃rẽ bauá, cʉ̃ʉ̃ya wiipʉ mʉʉrẽ atiaro jĩĩyigʉ, mʉʉ wederére tʉoáro jĩĩgʉ̃, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Cʉ̃́ã jĩĩãriguere tʉogʉ́, Pedro cʉ̃́ãrẽ sããatiduti, cʉ̃ʉ̃ niirí wiipʉ cãnidutíyigʉ. Apebʉ́reco cʉ̃́ãmena wáajõãyigʉ. Ãpẽrã́ tiimacã Jope macãrã Jesuré padeorá cʉ̃ʉ̃rẽ bapacʉtiwayira. ");
INSERT INTO tue_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Apebʉ́recope jeayira Cesareapʉre. Corneliope cʉ̃ʉ̃ya wederare, cʉ̃ʉ̃ menamacãrãrẽ néõ, yueyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro toopʉ́ jeari, Cornelio cʉ̃ʉ̃rẽ bocagʉ witiwayigʉ. Toopʉ́ quioníremena cʉ̃ʉ̃rẽ padeogʉ́, ñicãcoberimena jeacũmumiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro cʉ̃ʉ̃rẽ wéemʉõco: —Nucũña; yʉʉcã basocʉ́ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedro cʉ̃ʉ̃mena wedeapugʉ sããwayigʉ. Toopʉ́ sããjeagʉ, paʉ basocá neããrirare bʉajeáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Cʉ̃́ãrẽ jĩĩyigʉ: —Ʉ̃sã judíoare dutirére mʉ́ã ãñurõ masĩcu. Mʉ́ã judíoa niihẽrãye wiseripʉre naĩrõ sããwadutiria. Mʉ́ãrẽ naĩrõ bapacʉtidutiria. Teero niipacari, yʉʉre Cõãmacʉ̃ apepõná macãrãrẽ “ñañarã́ niiĩya” jĩĩdutiriawĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Teero tiigʉ́, ãniã yʉʉre “jãmʉ” jĩĩrĩ, atiawʉ̃. “Wáaria”, jĩĩriawʉ̃. Yʉʉ masĩdʉgaga; mʉ́ã ¿deero tiiádara yʉʉre atidutiarĩ? jĩĩ sãĩñáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio cʉ̃ʉ̃rẽ yʉʉyigʉ: —Mecʉ̃ãmena bapari bʉrecori netõã, ate wáari siro: Yʉʉ ati horanorã atiwií yáa wiipʉ beti, Cõãmacʉ̃rẽ sãĩgʉ̃́ tiiáwʉ̃. Wãcũña manirṍ sĩcʉ̃ ʉ̃mʉ suti asiyáre sãñarigʉ bauáawĩ yʉʉ pʉtopʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Cʉ̃ʉ̃ yʉʉre jĩĩãwĩ: “Cornelio, Cõãmacʉ̃ mʉʉ sãĩrére tʉoáwĩ. Mʉʉ bóaneõrãrẽ niyeru ticorécãrẽ ʉseniremena ĩñaãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Teero tiigʉ́, Jopepʉ mʉʉ ʉ̃mʉã́rẽ ticocoya. Simón Pedro wãmecʉtigʉre atidutiya. Cʉ̃ʉ̃ wáicʉra caseri quẽnogʉ̃́ya wiipʉ niiqui. Cʉ̃ʉ̃cã wãmecʉtii Simón. Cʉ̃ʉ̃ya wii pairímaa wesapʉ niiã”, jĩĩ wedeawĩ yʉʉre. ");
INSERT INTO tue_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Teero tiigʉ́, máata atidutigʉ ticocoawʉ̃. Mʉʉ ãñurõ tiigʉ́ atiayu. Marĩ niipetira Cõãmacʉ̃ ĩñacoropʉ niiã. Niipetire mʉʉrẽ Cõãmacʉ̃ wededutiariguere wedeya. Tʉoádara tiia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro wedeyigʉ: —Yʉʉ mecʉ̃tígã tʉomasĩ́ã: Cõãmacʉ̃ niipetirare sĩcãrĩbíro ĩñaqui. ");
INSERT INTO tue_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Niipetire põnarĩ macãrã cʉ̃ʉ̃rẽ quioníremena ĩñarã́rẽ, cʉ̃ʉ̃ booré tiiráre bocaqui. ");
INSERT INTO tue_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mʉ́ã masĩcu: Cõãmacʉ̃ Israelya põna macãrãrẽ cʉ̃ʉ̃ye quetire ticocorigʉ niiwĩ, Jesucristomena ãñurõ niirecʉtirere bʉaáro jĩĩgʉ̃. Jesucristo niipetira Õpʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Niipetiropʉ ʉ̃sã judíoa niirí ditapʉ wáariguere tʉojĩ́yu mʉ́ãcã. Teeré tiinʉcã́wʉ̃ Galileapʉ, Juan basocáre “wãmeõtidutiya” jĩĩãri siro. ");
INSERT INTO tue_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Cõãmacʉ̃ Jesús Nazaret macã macʉ̃rẽ tutuare ticorigʉ niiwĩ. Espíritu Santo cʉ̃ʉ̃mena niirĩ tiirígʉ niiwĩ. Jesús cʉ̃ʉ̃ noo wáaro ãñuré tiiwáwi. Niipetira wãtĩ ñañarõ tiirírare netõnéwĩ. Teeré tiiwí, Cõãmacʉ̃ cʉ̃ʉ̃mena niirĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","’Ʉ̃sã judíoa niirí ditapʉre, Jerusalénpʉre cʉ̃ʉ̃ tiiríguere ʉ̃sã ĩñapetijãwʉ̃. Cʉ̃ʉ̃rẽna ãpẽrã́ curusapʉ páabiatu sĩãdutíwa. ");
INSERT INTO tue_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Cõãmacʉ̃pe itiábʉreco siro cʉ̃ʉ̃rẽ masõrigʉ niiwĩ. Masõãri siro, ʉ̃sã pʉtopʉ cʉ̃ʉ̃rẽ bauánemorĩ tiirígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Basocá niipetirare bauáriwi. Ʉ̃sãrẽ bauáwi. Ʉ̃sãrẽ tíatopʉ Cõãmacʉ̃ beserigʉ niiwĩ, Jesús tiiádarere ĩñapetijããrõ jĩĩgʉ̃. Cʉ̃ʉ̃rẽ masõãri siro, ʉ̃sã cʉ̃ʉ̃mena yaa, sĩni tiiwʉ́. ");
INSERT INTO tue_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ʉ̃sãrẽ cʉ̃ʉ̃ye quetire wededutiwi. “Basocá catiráre, diarirare wapa tiigʉ́dʉre cṹũrigʉ niiwĩ Cõãmacʉ̃ Jesuré” jĩĩrére wededutiwi ʉ̃sãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Cõãmacʉ̃ niipetira Jesuré padeoráre cʉ̃ʉ̃mena cʉ̃́ã ñañaré tiirére acabógʉdaqui. Teeré jóarira niiwã niipetira profetas, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro teero jĩĩrĩrã, Espíritu Santo diijeáyigʉ Pedro wederére tʉorápʉre. ");
INSERT INTO tue_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Teero tiirá, cʉ̃́ã ãpẽrãyémena wedesenʉcãyira masĩripacara. Cõãmacʉ̃rẽ “ãñuniã mʉʉ” jĩĩ, ʉsenire ticoyira. Judíoa Pedrore bapacʉtiatiarira teeré tʉorá, tʉomaníjõãyira. —¡Acuéi! Judíoa niihẽrãpʉcãrẽ Cõãmacʉ̃ Espíritu Santore niigʉ̃ jeari tiii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedro jĩĩyigʉ: —Cõãmacʉ̃ Espíritu Santore ticoi ãniãcãrẽ marĩ judíoare tiirírobirora. Teero tiirá, “wãmeõtirijãña” jĩĩ cãmotámasĩria, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Teero tiigʉ́, cʉ̃́ãrẽ Jesucristo wãmemena wãmeõtidutiyigʉ. Too síro cʉ̃́ã cʉ̃ʉ̃rẽ jĩĩyira: —Ãnopʉ́ pʉtʉácũmuña ména sĩquẽ bʉrecori ʉ̃sãmena, jĩĩyira. Teero tiigʉ́, cʉ̃́ãmena pʉtʉáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesús beserira, Jesuré padeorá Judeapʉ niirã́ atequetí tʉoyíra: “Judíoa niihẽrã Cõãmacʉ̃ye quetire booáyira” jĩĩrére tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Teero tiirá, Pedro Jerusalénpʉ pʉtʉajeari, judíoa Jesuré padeorá sĩquẽrã cʉ̃ʉ̃rẽ sãĩñáyira: ");
INSERT INTO tue_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—Mʉʉ judíoa niihẽrãya wiipʉ sããwayiro. Cʉ̃́ãmena yaayiro, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro cʉ̃ʉ̃rẽ toopʉ́ wáariguere ãñurõ wedemʉãnʉcãyigʉ cʉ̃́ãrẽ: ");
INSERT INTO tue_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Yʉʉ Jopepʉ niigʉ̃, súubusegʉ tiiwʉ́. Yʉʉ cãnirípacʉ, quẽẽgʉ̃ tiiróbiro ĩñawʉ̃. Ʉ̃mʉã́sepʉ sicaró sutiróbiro baurí caseroca yʉʉ pʉtopʉ diiátiwʉ. Too bapari wesari siaríro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yʉʉ tiicasero popeapʉ niirére ĩña, “¿ñeenó niiĩ?” jĩĩ wãcũgʉ̃, ĩñaquẽnowʉ̃. Niipetira wáicʉra páira, macãnʉcʉ̃ macãrã, yepapʉ wéera, wʉʉrá sãñawã. ");
INSERT INTO tue_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yʉʉ teeré ĩñarĩ, sĩcʉ̃ yʉʉre wedeseri tʉowʉ́: “Jã́ã, Pedro, ãniãrẽ sĩãyáya”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yʉʉpe cʉ̃ʉ̃rẽ yʉʉwʉ: “Yaaria, yʉʉ Õpʉ̃. Ñañarã́ ʉ̃sã judíoa yaaya manirã́no niiĩya. Yʉʉ ãniãnorẽ yaahegʉ niitʉ”, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ʉ̃mʉã́sepʉ wedesegʉ yʉʉre jĩĩnemowĩ: “Cõãmacʉ̃ cʉ̃ʉ̃ ‘ãñurã́ niiĩya’ jĩĩrã́rẽ mʉʉpe ‘ñañarã́, yaaya manirã́no niiĩya’ jĩĩrijãña”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ĩtĩã́rĩ wedeseari siro, niipetiremena ʉ̃mʉã́sepʉ mʉãjõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","’Teero wáarira, ĩtĩã́rã ʉ̃mʉã Cesarea macãrã yʉʉ pʉto ticocoarira jearira niiwã yʉʉ niirí wiipʉre. ");
INSERT INTO tue_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Santo yʉʉre cʉ̃́ãmena wáadutiwi. “ ‘Cʉ̃́ã judíoa mee niiĩya; yʉʉ cʉ̃́ãmena wáari, ñañanibocu’, jĩĩ wãcũrijãña”, jĩĩwĩ. Ãniã seis Jesuré padeorá yʉʉmena jeawa. Ʉ̃sã toopʉ́ jea, yʉʉre boocórigʉya wiipʉ sããjeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ʉ̃sã toopʉ́ sããjeari, tiiwií macʉ̃ ʉ̃sãrẽ wedewi: “Sĩcʉ̃ ángele yáa wiipʉ nucũrĩ ĩñaãwʉ̃. Cʉ̃ʉ̃ yʉʉre jĩĩãwĩ: ‘Jopepʉ mʉʉ ʉ̃mʉã́rẽ ticocoya. Cʉ̃́ãrẽ Simón Pedro wãmecʉtigʉre atidutiya. ");
INSERT INTO tue_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Cʉ̃ʉ̃ Cõãmacʉ̃yere mʉʉrẽ wedegʉdaqui. Mʉʉ, mʉʉya wii macãrãmena netõnéãdare quetire wedegʉdaqui’, jĩĩ wedeawĩ yʉʉre ángele”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","’Yʉʉ cʉ̃́ãrẽ wedesenʉcãrĩrã, sicato marĩrẽ diijeárirobirora Espíritu Santo diijeárigʉ niiwĩ cʉ̃́ãpʉre. ");
INSERT INTO tue_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Teeré ĩñagʉ̃, Jesús marĩ Õpʉ̃ jĩĩriguere wãcũwʉ̃: “Juan mʉ́ãrẽ ocoména wãmeõtiwi. Yʉʉ Pacʉpeja nemorṍ ãñurõ tiigʉ́daqui mʉ́ãrẽ. Péerogã siro Espíritu Santore ticodiocogʉdaqui”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Teero tiigʉ́, yʉʉ wãcũtʉ: “Cõãmacʉ̃ marĩrẽ ticodiocorirobirora cʉ̃́ãrẽ ticodiocorigʉ niiwĩ, cʉ̃́ã Jesucristo marĩ Õpʉ̃rẽ padeorí. Teero tiigʉ́, yʉʉ Cõãmacʉ̃rẽ netõnʉcã́masĩritʉ”, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cʉ̃ʉ̃ tee jĩĩrĩ tʉorá, cʉ̃ʉ̃rẽ jĩĩnemoriyira sáa. Cõãmacʉ̃rẽ ʉsenire ticoyira: —Judíoa niihẽrãcã cʉ̃́ã ñañaré tiirére wãcũpati, wasorá, Cõãmacʉ̃ netõnérira niiãdacua. Cʉ̃́ãcãrẽ catiré petihére ticogʉdaqui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Judíoa Estebanrẽ sĩãrí siro, Jesuré padeoráre ñañarõ netõrĩ́ tiiyíra. Teero tiirá, dutibatéjõãyira. Ãpẽrã́ Fenicia ditapʉ, ãpẽrã́ Chipre nʉcʉ̃rõpʉ, ãpẽrã́ Antioquíapʉ jeayira. Cʉ̃́ã toopʉ́ jeara, judíoa dícʉre Jesuyé quetire wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Sĩquẽrã cʉ̃́ãmena dutiwárira Antioquíapʉ jea, judíoa niihẽrãcãrẽ wedeyira. Cʉ̃́ã Chipre macãrã, Cirene macãrã niiyira. “Jesús marĩrẽ netõnégʉ̃ niipetira Õpʉ̃ niiĩ”, jĩĩ wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Cõãmacʉ̃ cʉ̃́ãrẽ ãñurõ tiiápuyigʉ. Teero tiirá, paʉ too macãrã Jesuré padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalén macãrã Jesuré padeorá tee quetire tʉoyíra. Teeré tʉorá, Bernabére Antioquíapʉ ticocoyira. ");
INSERT INTO tue_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cʉ̃ʉ̃ tiimacãpʉ jea, Cõãmacʉ̃ cʉ̃́ãrẽ tiiápurere ĩña, bayiró ʉseniyigʉ. Cʉ̃́ãrẽ wãcũtutuare tico, wedeyigʉ: —Jesuré mʉ́ã wãcũdurijãña. Cʉ̃ʉ̃ dutirére ãñurõ tiirucújãña, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Cʉ̃ʉ̃ ãñuniwĩ. Espíritu Santo cʉ̃ʉ̃mena niirigʉ niiwĩ. Ãñurõ Cõãmacʉ̃rẽ padeorucúrigʉ niiwĩ. Paʉ basocá cʉ̃ʉ̃ wedeserere tʉorá Jesuré padeoyíra. ");
INSERT INTO tue_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bernabé Antioquíapʉ niigʉ̃, Tarsopʉ Saulore ãmaãgʉ̃ jeayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Cʉ̃ʉ̃rẽ bʉajeá, Antioquíapʉ néepʉtʉayigʉ. Cʉ̃́ã tiimacãpʉre Jesuré padeorámena sicacʉ̃ma niiyira. Paʉ basocáre bueyira. Toopʉ́ Jesuré padeoráre “cristiano” jĩĩnʉcãyira. ");
INSERT INTO tue_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Teebʉrecorire Jerusalén macãrã profetas Antioquíapʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sĩcʉ̃ cʉ̃́ãmena jearigʉ wãmecʉtiyigʉ Agabo. Cʉ̃ʉ̃ Espíritu Santo masĩré ticorémena wedeyigʉ: —Niipetiropʉ jʉabóare wáaadacu, jĩĩyigʉ. Jʉabóare wáawʉ Claudio romanuã õpʉ̃ niirito. ");
INSERT INTO tue_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Teeré tʉorá, Jesuré padeorá cãmerĩ́ wedeseyira: —Marĩ niyeru ticocoada Judeapʉ niirã́rẽ Jesuré padeoráre. Marĩ cʉoró jeatuaro ticocoada, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cʉ̃́ã jĩĩrirobirora niyerure néõ, Bernabé, Saulomena ticocoyira Judeapʉre. Cʉ̃́ãrẽ jĩĩyira: —Ateré ticowa bʉtoá dutiráre, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Teebʉrecorire Herodes Judea dita õpʉ̃ niiyigʉ. Cʉ̃ʉ̃ sĩquẽrã Jesuré padeoráre ñañarõ tiiápeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juan sõwʉ̃ Santiagore espadamena sĩãdutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Cʉ̃ʉ̃rẽ sĩãrĩ́ ĩñarã, judíoa ʉseniyira. Cʉ̃́ã ʉsenirĩ ĩñagʉ̃, Pedrore ñeeduti, peresuwiipʉ sõnecodutiyigʉ. Baparipõna surara waso, cʉ̃ʉ̃rẽ coterucuyira. Sicapõna macãrã bapari dícʉ niiyira. Pascua bʉrecori niirĩ, Herodes teero tiiyígʉ. “Pascua bʉrecori siro Pedrore néewioneco, basocá ĩñacoropʉ sĩãdutígʉda”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Teero tiirá, Pedrore cotemiyira peresuwiipʉ. Cʉ̃ʉ̃ toopʉ́ niirĩ, Jesuré padeorápe Cõãmacʉ̃rẽ bayiró sãĩrã́ tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes cʉ̃ʉ̃rẽ sĩãdutíadari sʉguero macã ñamirẽ Pedro surara pʉarã́ decopʉ cãnigʉ̃́ tiiyígʉ. Cõmedá pʉadámena siatúnoyigʉ. Ãpẽrã́ surara sopepʉ́ peresuwiire cotera tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wãcũña manirṍ sĩcʉ̃ ángele cʉ̃ʉ̃ niirṍpʉ bauáyigʉ. Ãñurõ bóejõãyiro. Cʉ̃ʉ̃rẽ warupʉ paacaré, wãcõyígʉ. —Boyero wʉ̃mʉnʉcãña, jĩĩyigʉ ángele. Cʉ̃ʉ̃ teero jĩĩrĩrã, cõmedári Pedroye wãmorĩrẽ siatúaredari jõãcódiayiro. ");
INSERT INTO tue_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","—Sitũrṹda siatúya. Mʉʉye sapature sãñaña, jĩĩyigʉ. Pedro cʉ̃ʉ̃ jĩĩrirobirora tiiyígʉ. —Mʉʉyaro sutiró sotoá macãrõ sãñaña. Jãmʉ, yʉʉre nʉnʉñá, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro cʉ̃ʉ̃ siro nʉnʉwitíwayigʉ. “¿Diamacʉ̃́rã niigari ate ángele yʉʉre néewitiware? Apetó tiigʉ́, quẽẽgʉ̃ tiibócu”, jĩĩ wãcũmiyigʉ cʉ̃ʉ̃peja. ");
INSERT INTO tue_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Surara niisʉguerare netõwáyira. Too síro surara ãpẽrãrẽ́ netõwáyira. Tiiwií sããwaro cõme sopepãma niirṍpʉ jeayira. Tiipãma basiro pã́õjõãyiro. Cʉ̃́ã tiisopere witiwayira. Maapʉ yoasãñurõ wáa, ángele ditijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pedro ãñurõ tʉomasĩ́nʉcãjea, wãcũyigʉ: “Diamacʉ̃́rã niiãyu yʉʉ ĩñaãrigue. Niirṍrã Cõãmacʉ̃ yʉʉre netõnégʉ̃dʉ ángelere ticocoayi, Herodes sĩãríjããrõ jĩĩgʉ̃. Judíoa niipetire yʉʉre ñañarõ wáare ĩñadʉgarere cãmotáayi”, jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Teeré masĩtoa, wáajõãyigʉ Juan Marcos pacoya wiipʉ. Coo wãmecʉtiyigo María. Tiiwiipʉ́re paʉ basocá neã, Cõãmacʉ̃rẽ sãĩrã́ tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Toopʉ́ jea, sicato sããrõ macã sopepãmapʉ doteyigʉ. Tiiwií padegó, Rode wãmecʉtigo, “¿noã niiĩ?” jĩĩ sãĩñágõ wáayigo. ");
INSERT INTO tue_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro wedeserere tʉomasĩ́, bayiró ʉseniyigo. Ʉsenipaco, pã́õriyigo. Cãmecʉtʉ́sã, cʉ̃́ãrẽ: —Pedro sopepʉ́ niiãti, jĩĩ wedemiyigo. ");
INSERT INTO tue_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","—Mʉʉ teero jĩĩãmajãgõ tiia, jĩĩyira. —Diamacʉ̃́rã jĩĩã, jĩĩyigo. —Too docare Pedrore cotegʉ́ ángele niiqui, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Cʉ̃́ã teero jĩĩcõãtorito, Pedro dotejãgʉ̃ tiiyígʉ. Cʉ̃́ã wáa, pã́õ, Pedrore ĩña, ĩñamanijõãyira. ");
INSERT INTO tue_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Cʉ̃́ãrẽ wãmomena wẽ́ẽtucoyigʉ, nocõrõ wedeseya jĩĩgʉ̃. Cõãmacʉ̃ cʉ̃ʉ̃rẽ peresuwiipʉ néewitiwaariguere wedeyigʉ. —Santiagore, ãpẽrã́ Jesuré padeoráre teeré wedeya, jĩĩyigʉ. Tiiwií niiãrigʉ witi, wáajõãyigʉ aperopʉ́. ");
INSERT INTO tue_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bóeri surara Pedro manirĩ́ ĩñarã, bayiró wãcũpatiyira. “¿Deero wáaayiriye?” cãmerĩ́ jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes “Pedro maniã́wĩ” jĩĩrĩ tʉogʉ́, surarare “ãmaãrã wáaya” jĩĩcoyigʉ. Cʉ̃́ã ãmaãmiyira. Bʉaríyira. Herodes Pedrore cotemiãrirare bayiró sãĩñárucu, cʉ̃́ãrẽ sĩãjã́dutiyigʉ. Too síro Herodes Judea ditapʉ niiãrigʉ Cesareapʉ niigʉ̃ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes bayiró cúayigʉ Tiro, Sidón macãrĩ macãrãmena. Cʉ̃́ã Herodeya ditapʉ yaaré sãĩrucúyira. Cʉ̃ʉ̃ cʉ̃́ãmena cúagʉ, yaaré dúadutiriyigʉ. Teero tiirá, cʉ̃ʉ̃rẽ ĩñarã wáayira. Herodeyere dutibosagʉmena tiiápure bʉayíra. Cʉ̃ʉ̃ wãmecʉtiyigʉ Blasto. Cʉ̃ʉ̃ tiiápuremena ãñurõ niirecʉtirere sãĩyíra Herodere. ");
INSERT INTO tue_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","—Tiibʉreco niirĩ, mʉ́ãrẽ wedegʉda, jĩĩyigʉ Herodepe. Cʉ̃ʉ̃ jĩĩri bʉreco jeari, Herodes cʉ̃ʉ̃ye õpʉ̃ suti ãñurére sãña, õpʉ̃ duirípĩrõpʉ dui, basocáre wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Cʉ̃ʉ̃ teero wederi, basocá acaribíyira: —Ate sĩcʉ̃ cõãmacʉ̃ wederé niiã; basocʉ́ wederé mee niiã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Cʉ̃ʉ̃pe “niiria; yʉʉ basocʉ́ niiã; cõãmacʉ̃ mee niiã” jĩĩriyigʉ. Teero tiigʉ́, wãcũña manirṍ ángele cʉ̃ʉ̃rẽ diarecʉtiri tiiyígʉ. Teero tiirá, cʉ̃ʉ̃rẽ becoa yaasĩãjãyira. ");
INSERT INTO tue_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Niipetiropʉ Jesuyé queti sesajõãyiro. Teero tiirá, paʉ Jesuré padeonemóyira. ");
INSERT INTO tue_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé, Saulomena Jerusalénpʉ Jesuré padeoráre tiiáputoa, cãmecópʉtʉayira Antioquíapʉ. Juan Marcore cʉ̃́ãmena néewayira. ");
INSERT INTO tue_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquíapʉre Jesuré padeorámena niiyira profetas, ãpẽrã́ Jesuyére buerá. Noquẽrã niiyira: Bernabé, Simón (cʉ̃ʉ̃rẽna “Ñíigʉ̃” jĩĩyira), Lucio (Cirene macã macʉ̃), Manaén (Herodes Galilea õpʉ̃mena sĩcãrõména masãrigʉ), Saulo niiyira. ");
INSERT INTO tue_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sicabʉreco cʉ̃́ã beti, Cõãmacʉ̃rẽ sãĩ, ʉsenire ticora tiirí, Espíritu Santo cʉ̃́ãrẽ jĩĩyigʉ: —Bernabé, Saulore beseya, yʉʉ cʉ̃́ãrẽ “tiiyá” jĩĩrére tiirá wáari, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Teero jĩĩrĩ tʉo, beti, Cõãmacʉ̃rẽ sãĩã́ri siro, cʉ̃́ãrẽ ñaapeó, “wáaya” jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Teero tiirá, Espíritu Santo ticocoarira niijĩrã, wáayira. Seleucia macãpʉ búawasʉgueyira. Too macãrã dooríwʉmena wáa, Chipre nʉcʉ̃rõpʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salaminapʉ niirã, judíoa neãré wiseripʉ Jesuyé quetire bueyira. Juan Marcos cʉ̃́ãrẽ tiiápugʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tiimacã niiãrira wáa, tiinʉcʉ̃rõpʉre Jesuyé quetire buesʉgocojãyira. Tée apeniñá Pafos macãpʉ buejeayira. Tiimacãpʉre sĩcʉ̃ judíoayʉ yái tiiróbiro niigʉ̃́rẽ bʉajeáyira. Cʉ̃ʉ̃ wãmecʉtiyigʉ Barjesús. “Yʉʉ profeta niiã”, jĩĩditonetõyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tiinʉcʉ̃rõ dutigʉ́ bayiró masĩgʉ̃́ menamacʉ̃ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Sergio Paulo. Cʉ̃ʉ̃ Cõãmacʉ̃ye quetire tʉodʉgágʉ, Bernabé, Saulore sʉodutíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Cʉ̃́ã jeari, yái tiiróbiro biigʉ́ cʉ̃́ã buerére cãmotádʉgamiyigʉ. Cʉ̃ʉ̃rẽ Elimas jĩĩyira griegoayemena. Cʉ̃ʉ̃ tiinʉcʉ̃rõ dutigʉ́ Jesuré padeorí booríyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo, ãpẽrã́ “Pablo” jĩĩgʉ̃́, Espíritu Santo cʉ̃ʉ̃mena niirĩ, cʉ̃ʉ̃rẽ bayiró ĩña, ");
INSERT INTO tue_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","jĩĩyigʉ: —Mʉʉ jĩĩditorebʉcʉ, mʉʉ booró tiigʉ́, wãtĩ tiiróbiro tiigʉ́, ãñuré tiirére ĩñatutigʉ niiã mʉʉ. Cõãmacʉ̃ diamacʉ̃́ wederére “diamacʉ̃́ niiria” jĩĩ wedewisiogʉ tiia. ");
INSERT INTO tue_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mʉʉrẽ mecʉ̃tígã Cõãmacʉ̃ ñañarõ tiigʉ́daqui. Mʉʉ capeari ĩñahẽgʉ̃ pʉtʉágʉdacu; yoari muĩpũ bóerere ĩñaricu, tée Cõãmacʉ̃ booró jeatuaro, jĩĩyigʉ Pablo. Máata cʉ̃ʉ̃rẽ naĩtĩãjõãyiro. Paaã́manucũ, cʉ̃ʉ̃rẽ wéewaadarare ãmaãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Teero wáari ĩñagʉ̃, tiinʉcʉ̃rõ dutigʉ́ quioníremena Jesuyé buerére ĩñamanijõãgʉ̃, Jesuré padeonʉcã́yigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo, cʉ̃ʉ̃ menamacãrãmena Pafopʉ niiãrira tĩãwa, Panfilia ditapʉ jeayira. Tiiditapʉ jea, Pergepʉ wáayira. Cʉ̃́ã Pergepʉ jeari, Juan Marcos cʉ̃́ãrẽ toorá cṹũ, coecópʉtʉayigʉ Jerusalénpʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tiimacãpʉ niiãrira wáayira apemacã́ Antioquíapʉ. Tiimacã Pisidia ditapʉ pʉtʉáa. Judíoa yeerisãri bʉreco niirĩ, cʉ̃́ã neãrí wiipʉ sããwa, duiyira. ");
INSERT INTO tue_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisére dutiré cṹũriguere, profetas jóariguere buetoari, tiiwií dutirá cʉ̃́ãrẽ wededutiyira: —Ʉ̃sãya wedera, basocáre wededʉgara, wedeya, cʉ̃́ãrẽ wãcũtutuaaro jĩĩrã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo “jáʉ” jĩĩ, wʉ̃mʉnʉcã, wãmo wẽ́ẽtuyigʉ, ditamaníña jĩĩgʉ̃. Teero tiitóa, cʉ̃́ãrẽ wedeyigʉ: —Yáa wedera Israelya põna macãrã, Cõãmacʉ̃rẽ quioníremena ĩñarã́cã, yʉʉre tʉoyá: ");
INSERT INTO tue_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Cõãmacʉ̃ Israelya põna macãrã Õpʉ̃ niirigʉ niiwĩ. Cʉ̃ʉ̃ ʉ̃sã ñecʉ̃sʉ̃mʉãrẽ besecũrigʉ niiwĩ. Cʉ̃́ã ãpẽrãyé dita Egiptopʉ niirĩ, cʉ̃́ãrẽ paʉ basocáputiri tiirígʉ niiwĩ. Too síro cʉ̃́ã tiiditapʉ niirã́rẽ cʉ̃ʉ̃ tutuaremena néewitiatirigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Cuarenta cʉ̃marĩ basocá manirṍpʉ cʉ̃́ã cʉ̃ʉ̃rẽ netõnʉcã́riguere nʉcãrígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Too síro cʉ̃́ã Canaán ditapʉ jeari, tiidita macãrã siete põnarĩ macãrãrẽ cõãrĩ tiirígʉ niiwĩ. Tiiditare ʉ̃sã ñecʉ̃sʉ̃mʉãrẽ cṹũrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tiiditapʉ cʉ̃́ãrẽ cṹũãri siro, cuatrocientos cincuenta cʉ̃marĩ niiyira. ’Cʉ̃́ã toopʉ́ niirĩ, Cõãmacʉ̃ cʉ̃́ãrẽ queti beseadarare cṹũyigʉ. Tée profeta Samuel niiré bʉrecoripʉ dutituyira. ");
INSERT INTO tue_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel niirito, basocá sĩcʉ̃ cʉ̃́ã õpʉ̃ niigʉ̃dʉre sãĩyíra. Cõãmacʉ̃ cʉ̃́ã õpʉ̃rẽ sõnecoyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Saúl. Cʉ̃ʉ̃ pacʉ Cis wãmecʉtiyigʉ. Cʉ̃́ã Benjamínya põna macãrã niiyira. Saúl cuarenta cʉ̃marĩ cʉ̃́ã õpʉ̃ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cõãmacʉ̃ cʉ̃ʉ̃rẽ õpʉ̃ niiré wionécoari siro, Daviré cʉ̃́ã õpʉ̃ sõnecoyigʉ. Cõãmacʉ̃ Daviyé maquẽrẽ wedeyigʉ basocáre: “Yʉʉ ĩñarĩ, David, Isaí macʉ̃, yʉʉ tʉsarére tiii. Niipetire yʉʉ tiidutírere tiigʉ́dʉ niiĩ”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Sĩcʉ̃ David pãrãmi niinʉnʉsegʉpʉ Israelya põna macãrãrẽ netõnégʉ̃dʉre ticocogʉda”, jĩĩ wedeyigʉ Cõãmacʉ̃ ʉ̃sã ñecʉ̃sʉ̃mʉãrẽ. Jesús Cõãmacʉ̃ jĩĩrigʉra niiĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús buenʉcããdari sʉguero, Juan Israelya põna macãrãrẽ bueyueyigʉ: “Mʉ́ã ñañaré tiirére wãcũpati, waso, wãmeõtidutiya”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan cʉ̃ʉ̃ tiiré petiádaro tiirí, jĩĩyigʉ: “Yʉʉ mʉ́ã wãcũgʉ̃ mee niiã. Yʉʉ siro ãpĩ atiqui. Cʉ̃ʉ̃ ãñunetõgʉ̃ niiqui. Yʉʉpe cʉ̃ʉ̃ dʉaró bʉ́ri niigʉ̃́ niiã”, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Yáa wedera Abraham pãrãmerã niinʉnʉsera, Cõãmacʉ̃rẽ quioníremena ĩñarã́cã, tʉoyá. Cõãmacʉ̃ marĩrẽ cʉ̃ʉ̃ netõnére quetire ticocorigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén macãrã, cʉ̃́ãrẽ dutirácã Jesuré ĩñamasĩriyira. Cʉ̃́ã yeerisãre bʉrecoricõrõ profetas jóariguere buepacara, tʉomasĩ́riyira. Jesuré sĩãdutíri, tee jóaripũ jĩĩrõbirora tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Cʉ̃ʉ̃rẽ sĩãrĩ́ tiiréno wapa bʉarípacara, Pilatore “sĩãdutíya cʉ̃ʉ̃rẽ” jĩĩ sãĩyíra. ");
INSERT INTO tue_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cõãmacʉ̃ye queti jóaripũ jĩĩrõbirora cʉ̃ʉ̃rẽ tiipetíra, curusapʉ niigʉ̃́rẽ néedioco, ʉ̃tãtutipʉ cṹũmiyira. ");
INSERT INTO tue_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Cõãmacʉ̃pe cʉ̃ʉ̃rẽ diarigʉpʉre masõrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesús cʉ̃ʉ̃ masãri siro, pee bʉrecori bauáyigʉ cʉ̃ʉ̃mena Galileapʉ nii, Jerusalénpʉ bapacʉti jearirare. Cʉ̃́ãrã cʉ̃ʉ̃ masãrigʉre ĩñarira basocáre wedeeya. ");
INSERT INTO tue_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Ʉ̃sãcã mʉ́ãrẽ teeréna wedea. Cõãmacʉ̃ marĩ ñecʉ̃sʉ̃mʉãrẽ cʉ̃ʉ̃ jĩĩrirobirora ");
INSERT INTO tue_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","marĩrẽ cʉ̃́ã pãrãmérã niinʉnʉserapʉre teeré tiiẽ́ñoyigʉ. Tee Jesús diarigʉpʉre masõrigue niiã. Salmopũcãrẽ teeré biiro jóanoã: “Mʉʉ yʉʉ macʉ̃ niiã. Mecʉ̃ãmena yʉʉ mʉʉ pacʉ niirére masĩãdacua”, jĩĩ jóarigue niiã. ");
INSERT INTO tue_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Cʉ̃ʉ̃ diarigʉpʉ masõãdare, cʉ̃ʉ̃ya õpʉ̃ʉ̃ bóariadarecãrẽ biiro jóanoã: “Niipetire yʉʉ Daviré jĩĩriguecõrõ mʉʉrẽ ãñurõ tiiboságʉdacu”, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Salmopũpʉ David biiro jóarigʉ niiwĩ sũcã: “Mʉʉ ‘bóarijããrõ’ jĩĩgʉ̃dacu mʉʉ maĩgʉ̃́rẽ”, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davipé Cõãmacʉ̃ dutirére tii, cʉ̃ʉ̃ dutirito macãrãrẽ tiiápu, too síro diajõã, cʉ̃ʉ̃rẽ yaaári siro, bóawejõãjĩyi. ");
INSERT INTO tue_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Cõãmacʉ̃ masõrigʉpe bóaweririgʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Yáa wedera, yʉʉ mʉ́ãrẽ wederére masĩrĩ booa. Mʉ́ã Moisére dutiré cṹũriguere tiipacára, acabóre bʉarícu. Jesuména, cʉ̃ʉ̃rẽ padeorá, tee niipetire acabóya maniríguere acabóre bʉamasĩ́cu. ");
INSERT INTO tue_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Profetas jóarigue mʉ́ãrẽ wáari jĩĩrã, ãñurõ wãcũña. Biiro jóarira niiwã: ");
INSERT INTO tue_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Mʉ́ã Cõãmacʉ̃rẽ buijã́rã, ãñurõ tiiyá. Mʉ́ã catiré bʉrecorire yʉʉ tiiádarere ẽñogʉ̃́da. Ãpẽrã́ mʉ́ãrẽ teeré ãñurõ wedepacari, padeorídojãcu. Teero tiirá, ĩñamanijõã, diajõããdacu mʉ́ã, jĩĩ jóarira niiwã, jĩĩ wedeyigʉ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Cʉ̃́ã witiwari, cʉ̃́ãrẽ sãĩyíra: —Ape yeerisãri bʉreco niirĩ, ateré buewa sũcã ʉ̃sãrẽ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tiiwií neããrira witibatewara, paʉ judíoa, judíoa niihẽrã Cõãmacʉ̃rẽ ʉseniremena padeorá cʉ̃́ãmena bapacʉtiwayira. Pablo, Bernabé cʉ̃́ãrẽ jĩĩyira: —Cõãmacʉ̃ mʉ́ãrẽ ãñuré ticorére wãcũdurijãña. Cʉ̃ʉ̃rẽ padeorucújãña, jĩĩ wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Apesemána yeerisãri bʉreco niirĩ, niipetira tiimacã macãrã Cõãmacʉ̃ye quetire tʉoádara neãyira. ");
INSERT INTO tue_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Paʉ neãrĩ ĩñarã, judíoa bayiró pesucʉtiyira. Teero tiirá, ñañarõ wedeseremena Pablo buerére “diamacʉ̃́ niiria” jĩĩ buijã́yira. ");
INSERT INTO tue_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablo, Bernabé teeré tʉorá, cuiro manirṍ cʉ̃́ãrẽ jĩĩyira: —Mʉ́ã judíoare ãpẽrã́ sʉguero Cõãmacʉ̃ye quetire bueró niirõ tiiwʉ́. Mʉ́ã teeré tʉopacára, booría. “Cõãmacʉ̃ catiré petihére ticorére cʉobórano mee niiã”, jĩĩrã tiia mʉ́ã. Teero tiirá, ʉ̃sã mecʉ̃tígãrẽ judíoa niihẽrãrẽ Cõãmacʉ̃ye quetire bueadacu sáa. ");
INSERT INTO tue_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Cõãmacʉ̃ teeré jĩĩ dutirigʉ niiwĩ ʉ̃sãrẽ cʉ̃ʉ̃ye maquẽ jóaripũpʉre: Yʉʉ mʉʉrẽ sĩãwócore tiiróbiro cṹũã judíoa niihẽrãpʉre. Yʉʉ netõnére quetire buegʉdacu niipetire macãrĩpʉ, jĩĩ jóarigue niiã, jĩĩyigʉ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Teeré tʉorá, judíoa niihẽrã bayiró ʉseniyira. “Cõãmacʉ̃ye queti ãñunetõjõãã”, jĩĩyira. Cõãmacʉ̃ catiré petihére ticonoãdara padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tiiditapʉre Jesuyé quetire wedewarucuyira. ");
INSERT INTO tue_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Judíoape Pablo, Bernabére cõãdʉgayira. Cʉ̃́ã masĩrã́ numiãrẽ cúari tiiyíra. Cʉ̃́ã numiã́ cʉ̃́ãmena naĩrõ súubusera neãrã́ niiyira. Basocá ãñurã́ numiã niiyira. Ʉ̃mʉã́cãrẽ teerora cúari tiiyíra. Cʉ̃́ã ʉ̃mʉã́ ʉpʉtí macãrã niiyira tiimacãpʉre. Pablo, Bernabére ñañarõ tiinʉcã́rĩ tii, cʉ̃́ãya ditapʉ niiãrirare cõãjãyira. ");
INSERT INTO tue_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Cʉ̃́ãpe tiimacã maquẽ dita cʉ̃́ãye dʉpori túaariguere páabatecõãyira. “Mʉ́ã basiro wapa cʉoa” jĩĩrã, teero tiiyíra. Iconio macãpʉ wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesuré padeorá Espíritu Santo cʉ̃́ãmena niirĩ, bayiró ʉseniremena pʉtʉáyira. ");
INSERT INTO tue_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo, Bernabé Iconiopʉre judíoa neãrí wiipʉ sããwa, wedeyira. Cʉ̃́ã tʉoríãñuremena wederi, paʉ judíoa, ãpẽrã́ judíoa niihẽrã Jesuré padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judíoa Jesuré padeohéra judíoa niihẽrãrẽ cúari tii, ñañarõ wãcũrĩ tiiyíra Pablo, Bernabére. ");
INSERT INTO tue_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Teero tiirá, Pablo, Bernabé yoari pʉtʉáyira tiimacãpʉre. Cuiro manirṍ marĩ Õpʉ̃yere wedeyira. Cõãmacʉ̃pe “diamacʉ̃́rã wedeeya” jĩĩgʉ̃, cʉ̃ʉ̃ tutuaremena tiiẽ́ñorĩ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tiimacã macãrã pʉapõná batoyira. Ãpẽrã́ judíoa tiiróbiro wãcũyira; ãpẽrãpé Jesús beserira tiiróbiro wãcũyira. ");
INSERT INTO tue_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Teero tiirá, judíoa niihẽrã, judíoa, cʉ̃́ãrẽ dutirámena neã, wedeseyira: —Jãmʉ, Pablo, Bernabére ñañarõ jĩĩ, ʉ̃tãperimena déesĩããda marĩ, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablo, Bernabé cʉ̃́ãrẽ ñañarõ tiidʉgárere tʉorá, dutijṍãyira. Licaonia ditapʉ jea, too maquẽ macãrĩ Listra, Derbe, apeyé macãrĩpʉcãrẽ jeayira. ");
INSERT INTO tue_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Toopʉ́re Jesuyé ãñuré quetire wedewarucuyira sũcã. ");
INSERT INTO tue_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listrapʉ sĩcʉ̃ basocʉ́ wáamasĩhẽgʉ̃ duiyigʉ. Sicato bauágʉpʉra dʉpori posarigʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Toopʉ́ duigʉ, Pablo basocáre wederére tʉoyígʉ. Pablo cʉ̃ʉ̃rẽ ĩña, “ãni Jesuré cʉ̃ʉ̃ye dʉpori netõnémasĩrere padeói” jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Teero tiigʉ́, bayiró wedeseremena: —Mʉʉ dʉporimena ãñuripĩ wʉ̃mʉnʉcãña, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩrĩrã, bupucʉtʉ́a, wáanʉcãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo teero tiirí ĩñarã, Licaonia macãrã cʉ̃́ãyemena bayiró bʉsʉrómena wedeseyira: —Cõãpõna basocá tiiróbiro õpʉ̃ʉ̃cʉtira marĩ pʉtopʉ diijeáaya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabére cʉ̃́ãyagʉ cõãmacʉ̃ Zeus wãmecʉtigʉ wãme tuuyira. Pablopere, cʉ̃ʉ̃ wederi ĩñarã, ãpĩ cʉ̃́ãyagʉ cõãmacʉ̃ Hermes wãmecʉtigʉ wãme tuuyira. ");
INSERT INTO tue_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tiimacã witiwaropʉ Zeure padeorí wii niiyiro. Tiiwií macʉ̃ pai wecʉá ʉ̃mʉãrẽ coorimena mamoãrirare tiimacã sããwaropʉ néeatidutiyigʉ. Pai, ãpẽrã́ too macãrã Pablo, Bernabére padeoádara, wecʉaré sĩãdʉgámiyira. ");
INSERT INTO tue_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Cʉ̃́ã teeré tiidʉgári tʉorá, Pablo, Bernabé cʉ̃́ã basiro cʉ̃́ãye sutire wéeyigajãyira. “Mʉ́ã tiiádare bayiró ñañaã” jĩĩrã, teero tiiyíra. Cʉ̃́ã paʉ decopʉ cʉtʉwá, cʉ̃́ãrẽ bayiró bʉsʉrómena jĩĩyira: ");
INSERT INTO tue_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Mʉ́ã ʉ̃sãrẽ teeré tiiríjãña! Ʉ̃sãcã mʉ́ã tiiróbirora basocá niiã. Mʉ́ã biiro tiirécʉtirere nocõrõrã duujã́ña. Mʉ́ã padeoré wapamaníã. Cõãmacʉ̃ catigʉ́pere padeonʉcã́ña. Cʉ̃ʉ̃ ʉ̃mʉã́se, atiditá, día pairímaa, niipetire atibʉ́reco niirére tiirígʉ niiwĩ. Teeré mʉ́ãrẽ wedera atira tiiáwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Cõãmacʉ̃ tíatopʉre niipetire dita macãrĩ macãrã cʉ̃́ã booró tiirí, cãmotáririgʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Basocá cʉ̃ʉ̃rẽ padeorípacari, cʉ̃ʉ̃ niirecʉtirere cʉ̃ʉ̃ ãñuré tiirémena ẽñoĩ niipetirare. Cʉ̃ʉ̃ oco peari tiirémena ote dʉcacʉtiri tiii. Marĩrẽ ãñurõ yaaré tico, ʉseniremena niirĩ tiii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wáicʉrare sĩã, cʉ̃́ãrẽ padeoádara tiimíyira. Péerogã dʉsaátiri, Pablo, Bernabé cʉ̃́ãrẽ cãmotájãyira. ");
INSERT INTO tue_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Antioquía macãrã, ãpẽrã́ Iconio macãrã jeayira toopʉ́re. Judíoa niiyira cʉ̃́ã. Basocáre wãcũre wasorí tiiyíra. Pablore ʉ̃tãperimena dée, “diajõãĩ” jĩĩmiyira. Macã wesapʉ wéewa, cṹũjãyira. ");
INSERT INTO tue_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jesuré padeorá cʉ̃ʉ̃rẽ ĩñasodeanʉcãyira. Cʉ̃ʉ̃pe wʉ̃mʉnʉcã, macãpʉ piyajõãyigʉ sũcã. Apebʉ́reco Bernabémena Derbepʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Cʉ̃́ã toopʉ́ jea, Jesuyé ãñuré quetire wedeyira. Too macãrã paʉ cʉ̃́ã buerére padeonʉcã́yira. Too síro cʉ̃́ã cãmepʉtʉ́aatiyira Listrapʉ. Too macãrã Iconiopʉ, too macãrã Antioquíapʉ pʉtʉajeayira. ");
INSERT INTO tue_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Teemacãrĩpʉre Jesuré padeoráre wãcũtutuare ticoyira. “Jesuré padeorucújãña”, jĩĩyira. “Marĩ Cõãmacʉ̃ Õpʉ̃ niirṍpʉ wáaadari sʉguero, pee ñañaré wáari, wãcũbayijãrõ booa”, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jesuré padeoré põnarĩcõrõ bʉtoá dutiráre beseyira. Cʉ̃́ãrẽ cṹũrã, beti, Cõãmacʉ̃rẽ sãĩyíra. “Marĩ Õpʉ̃ mʉ́ã padeogʉ́ tiiápuaro mʉ́ãrẽ” jĩĩ, wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pablo, Bernabé Pisidia ditapʉ netõwá, Panfilia ditapʉ jeayira. ");
INSERT INTO tue_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pergepʉ wedetoa, Atalia macãpʉ búajeayira. ");
INSERT INTO tue_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Too macãrã dooríwʉmena wáayira Antioquíapʉ wáara. Tiimacã macãrã cʉ̃́ãrẽ sicato ticocora, “Cõãmacʉ̃ mʉ́ãrẽ ãñurõ cotearo” jĩĩ ticocoyira. Cõãmacʉ̃ tiidutírere tiirá wáadutiyira. Cʉ̃́ãpe teeré tiipetítoa, pʉtʉajeajõãyira. ");
INSERT INTO tue_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tiimacãpʉ coerá, Jesuré padeoráre néõ, Cõãmacʉ̃ cʉ̃́ãmena tiiríguere wedeyira. “Cõãmacʉ̃ judíoa niihẽrãcãrẽ netõnérere ticowi”, jĩĩ wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Cʉ̃́ã yoari pʉtʉáyira Jesuré padeorámena. ");
INSERT INTO tue_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Cʉ̃́ã toopʉ́ niirĩ, ãpẽrã́ Judea dita macãrã cʉ̃́ã pʉtopʉ jeayira. Jesuré padeoráre bueyira: —Mʉ́ã Moisére dutiré cṹũrigue tiihéri, mʉ́ã cõnerígʉ yapa macã caseróre widecõã́hẽrĩ, Cõãmacʉ̃ mʉ́ãrẽ netõnériqui, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo, Bernabé cʉ̃́ãmena bayiró cãmerĩ́ wedeseyira. Teero tiirá, Antioquía macãrã Jerusalénpʉ ticocoadara, Pablo, Bernabé, ãpẽrã́ too macãrãrẽ beseyira. Cʉ̃́ãrẽ jĩĩyira: —Jerusalénpʉ wáaya. Jesús beseriramena, ãpẽrã́ bʉtoá dutirámena wedesera wáaya tee marĩ wedesere maquẽrẽ, jĩĩ ticocoyira. ");
INSERT INTO tue_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jesuré padeorá cʉ̃́ãrẽ ticocori, Fenicia dita, Samaria ditapʉ netõwáyira. Teemacãrĩpʉ netõwára, judíoa niihẽrã cʉ̃́ã Jesuré padeonʉcã́rigue quetire wedeyira. Tee quetire tʉorá, niipetira Jesuré padeorá bayiró ʉseniyira. ");
INSERT INTO tue_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cʉ̃́ã Jerusalénpʉ jeari, Jesuré padeorá, Jesús beserira, ãpẽrã́ bʉtoá dutirá cʉ̃́ãrẽ bocayira. Cʉ̃́ãrẽ Cõãmacʉ̃ cʉ̃́ãmena tiiríguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Toopʉ́re sĩquẽrã fariseo basoca Jesuré padeorá niiyira. Cʉ̃́ã wʉ̃mʉnʉcã, wedeseyira: —Judíoa niihẽrã cʉ̃́ã Jesuré padeorí, cʉ̃́ã cõnerígʉ yapa macã caseróre widecõã́dutiro booa. Moisére dutiré cṹũriguere tiidutíro booa, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Teero tiirá, Jesús beserira, ãpẽrã́ bʉtoá dutirá neã, wedeseyira tee maquẽrẽ. ");
INSERT INTO tue_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Cʉ̃́ã yoari cãmerĩ́ sãĩñá wedeseari siro, Pedro wʉ̃mʉnʉcã, cʉ̃́ãrẽ jĩĩyigʉ: —Yáa wedera, mʉ́ã masĩã: Cõãmacʉ̃ jõõ niiritopʉ, judíoa niihẽrãrẽ cʉ̃ʉ̃ye quetire wededutigʉ, yʉʉre beserigʉ niiwĩ. Cʉ̃́ãcãrẽ teeré tʉo, “Jesuré padeoáro” jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Cõãmacʉ̃ niipetire basocá wãcũrére masĩgʉ̃́ “yáara niiĩya cʉ̃́ã” jĩĩrére ẽñogʉ̃́, Espíritu Santore ticorigʉ niiwĩ cʉ̃́ãrẽ marĩrẽ cʉ̃ʉ̃ ticorirobirora. ");
INSERT INTO tue_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Marĩrẽ cʉ̃́ãmena tuudʉcáwaririgʉ niiwĩ. Cʉ̃́ãcãrẽ Jesuré padeorí, cʉ̃́ã ñañaré tiirére acabórigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mʉ́ã Cõãmacʉ̃rẽ “mʉʉ cʉ̃́ãrẽ netõnémasĩricu, cʉ̃́ã Moisére dutiré cṹũriguere tiihéri” jĩĩrã tiicú. Marĩ ñecʉ̃sʉ̃mʉã Moisére dutiré cṹũriguere tii sĩcãrĩbíriyira; marĩcã sĩcãrĩbíricu. ");
INSERT INTO tue_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Cõãmacʉ̃ judíoa niihẽrãrẽ tiiróbiro marĩrẽ netõnéqui. Jesús marĩ Õpʉ̃rẽ padeorí, wapa booró manirṍ marĩcãrẽ netõnéqui, jĩĩyigʉ Pedro. ");
INSERT INTO tue_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Teeré tʉorá, niipetira ditamaníjõãyira. Bernabé, Pablo wedeserecãrẽ ãñurõ tʉoyíra. Judíoa niihẽrã pʉtopʉ Cõãmacʉ̃ cʉ̃́ãmena tiiẽ́ñonetõriguere wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cʉ̃́ã wedetoari, Santiago wedeyigʉ: —Yáa wedera, tʉoyá. ");
INSERT INTO tue_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Cõãmacʉ̃ judíoa niihẽrãpʉre cʉ̃ʉ̃yara niiãdarare besesʉgueriguere wedeawĩ Simón Pedro. ");
INSERT INTO tue_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Profetas teerora jóarira niiwã. Cʉ̃́ã jóariguere ãñurõ tʉoyá: ");
INSERT INTO tue_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“David dutirigue petirí siro, cʉ̃ʉ̃ pãrãmérã niinʉnʉsera dutirigue petirí siropʉ, sĩcʉ̃ David pãrãmi niinʉnʉsegʉre yʉʉ cʉ̃́ã õpʉ̃ sõnecogʉdacu sũcã. ");
INSERT INTO tue_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Teero tiirá, judíoa niihẽrã yʉʉre padeoádacua, yʉʉ beserira niijĩrã”, ");
INSERT INTO tue_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","jĩĩrigʉ niiwĩ Cõãmacʉ̃. Tíatopʉ teeré jĩĩrigʉ niiwĩ Cõãmacʉ̃, basocáre masĩdutigʉ, jĩĩ jóarira niiwã. ");
INSERT INTO tue_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Too docare judíoa niihẽrã Jesuré padeonʉcã́rãrẽ “dutipotocõrijããda sáa” jĩĩ wãcũã yʉʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ateré jóaada cʉ̃́ãrẽ: Wáicʉra dii cʉ̃́ã padeoráre ticoariguere yaarijãña. Ãpẽrãména ñañarõ ñeeaperijãña. Wáicʉra dii díi cõãña maniré diiré yaarijãña. Wáicʉra díire sĩniríjãña, jĩĩ jóaada. ");
INSERT INTO tue_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mʉ́ã masĩã: Tíatopʉ marĩ yeerisãre bʉrecoricõrõ Moisére dutiré cṹũriguere wedenʉcãjĩya. Marĩcã atitóre buedecocʉtia. Teeré niipetire macãrĩpʉ judíoa neãré wiseripʉ bueeya, jĩĩyigʉ Santiago. ");
INSERT INTO tue_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Teero tiirá, Jesús beserira, ãpẽrã́ bʉtoá dutirá, niipetira Jesuré padeorámena jĩĩyira: “Marĩ ticocoadarare beseri, ãñuãdacu. Pablo, Bernabémena cʉ̃́ãrẽ ticococo Antioquíapʉ”, jĩĩyira. Judare beseyira. Cʉ̃ʉ̃rẽna ãpẽrã́ Barsabás jĩĩyira. Ãpĩ Silas niiyigʉ. Cʉ̃́ã pʉarã́ cʉ̃́ã ãñurõ padeorá niiyira. ");
INSERT INTO tue_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Cʉ̃́ãmena atipṹ ticocoyira: “Ʉ̃sã Jesús cʉ̃ʉ̃yere wededutigʉ beserira, ãpẽrã́ bʉtoá dutirá mʉ́ã judíoa niihẽrãrẽ ãñudutia. Mʉ́ã ʉ̃sã baira tiiróbiro niirã́ Antioquíapʉ, Siriapʉ, Ciliciapʉ niirã́rẽ jóaa. ");
INSERT INTO tue_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sĩquẽrã ãno macãrã ʉ̃sã menamacãrã ʉ̃sã dutiró manirṍ mʉ́ã pʉtopʉ wáayira. Mʉ́ãrẽ potocṍãyira. Cʉ̃́ã wederémena mʉ́ãrẽ wedewisioayira. ");
INSERT INTO tue_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Teeré tʉorá, ʉ̃sã sĩcãrĩbíro wãcũrémena ʉ̃mʉã́ sĩquẽrãrẽ mʉ́ã pʉtopʉ bese, ticocori, ‘ãñuãdacu’ jĩĩãwʉ̃. Cʉ̃́ã wáaadacua Bernabé, Pablo marĩ bayiró maĩrã́mena. ");
INSERT INTO tue_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bernabé, Pablo sĩãrĩ́quioro tiiyíra, Jesucristo marĩ Õpʉ̃yere buera. ");
INSERT INTO tue_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judas, Silas ʉ̃sã ticocora wedeadacua atipṹ maquẽrẽ. ");
INSERT INTO tue_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ʉ̃sãrẽ Espíritu Santo wãcũré ticorobirora pee dutiré mʉ́ãrẽ cṹũricu. Ate bayiró booré dícʉre mʉ́ãrẽ cṹũãda: ");
INSERT INTO tue_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Wáicʉra dii cʉ̃́ã weerirare ticoariguere yaarijãña. Wáicʉra díire sĩniríjãña. Wáicʉra dii díi cõãña maniré diiré yaarijãña. Ãpẽrãména ñañarõ ñeeaperijãña. Mʉ́ã ate dutirére tiirá, diamacʉ̃́ tiirá niiãdacu. Nocõrõrã niiã”, jĩĩ jóayira. ");
INSERT INTO tue_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Cʉ̃́ã “wáara tiia” jĩĩ, Antioquíapʉ wáajõãyira. Toopʉ́ jea, basocáre neãduti, tiipũrẽ wiyayíra. ");
INSERT INTO tue_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tiipũrẽ bueri tʉorá, wãcũtutuare ñeerã, ãñurõ ʉseniyira. ");
INSERT INTO tue_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas, Silas profetas niijĩrã, yoari wedeyira. Ãñurõ wãcũtutuare, ãñurõ yeeripũnacʉtire ticonemoyira cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yoasãñurĩ niiyira cʉ̃́ãmena. Too síro “wáara tiia” jĩĩ, wáajõãyira. Too macãrãpe “Cõãmacʉ̃mena wáaya mʉ́ãrẽ ticocorira pʉtopʉ” jĩĩcoyira. ");
INSERT INTO tue_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silape “wáagʉ tiia” jĩĩpacʉ, “yʉʉ ãno pʉtʉágʉda” jĩĩ, pʉtʉájãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo, Bernabécã too Antioquíapʉ pʉtʉájãyira. Paʉ ãpẽrãména too macãrãrẽ Jesuyé quetire bueyira. ");
INSERT INTO tue_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nocõrõ yoari siro, Pablo Bernabére jĩĩyigʉ: —Jãmʉ sũcã, wáaco marĩ Jesuyé quetire bueré macãrĩcõrõ. Jesuré padeonʉcã́rirare ĩñanetõãda, ¿deero niirecʉtimiĩ cʉ̃́ã? jĩĩrã, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé néewadʉgamiyigʉ Juan Marcore. ");
INSERT INTO tue_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablope jĩĩyigʉ: —Too sʉgueropʉ bueyapacʉtiriwi cʉ̃ʉ̃. Panfiliapʉ marĩ niirĩ, cõãcopʉtʉaatiwi. Marĩmena wáanemorĩ booríga, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Cʉ̃́ã basiro bayiró cãmerĩ́ wedese, cúa, cãmerĩ́ cõãjãyira. Bernabépe dooríwʉmena Chipre nʉcʉ̃rõpʉ Marcore néewayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablope Silare beseyigʉ. Jesuré padeorá “Cõãmacʉ̃ cʉ̃ʉ̃ ãñuré ticorémena mʉ́ãrẽ cotearo” jĩĩ sãĩbosáari siro, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wáa, Siria, Cilicia ditapʉ netõwáyigʉ. Jesuré padeoráre wãcũtutuare ticonemoyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo Derbe, Listra macãrĩpʉre jeayigʉ. Toopʉ́ sĩcʉ̃ Jesuré padeogʉ́re bʉajeáyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Timoteo. Cʉ̃ʉ̃ judíoayo Jesuré padeogó macʉ̃ niiyigʉ. Pacʉpé griegoayʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jesuré padeorá Listra, Iconio macãrã cʉ̃ʉ̃rẽ “ãñuniĩ” jĩĩ wedeseyira. ");
INSERT INTO tue_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo cʉ̃ʉ̃rẽ bapacʉtiaro jĩĩgʉ̃, néewadʉgayigʉ. Judíoare tiigʉ́, Pablo Timoteo cõnerígʉ yapa macã caseróre widecõã́dutiyigʉ. Judíoa niipetira tiidita macãrãpe Timoteo pacʉ griegoayʉ niirére masĩyira. ");
INSERT INTO tue_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Teero tiitóa, macãrĩpʉ́re netõwáyira. Jerusalén macãrã Jesús beserira, ãpẽrã́ bʉtoá dutirá dutiré cṹũriguere wede, “teeré tiiyá” jĩĩnetõwayira. ");
INSERT INTO tue_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Teero tiirá, Jesuré padeorá wãcũtutuanemoyira. Jesuré padeodúriyira. Bʉ́recoricõrõ ãpẽrãcã́ Jesuré padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Too síro cʉ̃́ã Asia ditapʉ Jesuyé quetire buera wáadʉgarare Espíritu Santo cãmotáyigʉ. Teero tiirá, Frigia, Galacia ditape tã́ãtãwa, ");
INSERT INTO tue_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia dita táariropʉ jeayira. Toopʉ́ jea, Bitinia ditapʉ wáajõãmiyira. Espíritu Santo toopʉ́cãrẽ wáadutiriyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Teero tiirá, Misia netõwá, búawayira Troaspʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Toopʉ́ ñami Pablo quẽẽgʉ̃ tiiróbiro sĩcʉ̃ Macedonia dita macʉ̃ cʉ̃ʉ̃ pʉto wedesenucũrĩ ĩñayigʉ: —Ʉ̃sã Macedonia macãrãrẽ tiiápugʉ tĩãatiya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Cʉ̃ʉ̃ quẽẽrṍpʉ tiiróbiro ĩñaãri siro, máata ʉ̃sãrẽ néewaadariwʉre ãmaãwʉ̃. “Cõãmacʉ̃ marĩrẽ Macedonia macãrãrẽ Jesuyé ãñuré quetire wededutigʉ tiiájĩyi”, jĩĩ wãcũwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ʉ̃sã Troaspʉ niiãrira dooríwʉmena diamacʉ̃́rã Samotracia nʉcʉ̃rõpʉ wáajõãwʉ̃. Apebʉ́reco Neápolis macãpʉ wáawʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Too macãrã Filipospʉ maajeáwʉ. Romanuã tiirí macã niiã. Macedonia ditapʉre Filipos bʉ́ri niirí macã mee niiã. Tiimacãpʉre sĩquẽ bʉrecori pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Judíoa yeerisãri bʉreco niirĩ, tiimacãrẽ witiwa, día wesapʉ jeawʉ. “Judíoa súubusero toopʉ́ niibocu”, jĩĩ wãcũwʉ̃. Numiã́ neããrirare bʉajeá, cʉ̃́ãmena dui, wedewʉ cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Toopʉ́re sĩcõ Tiatira macã macõ niiwõ. Coo suti wapapacáre sõã ñiisãñúre dúago niiwõ. Cõãmacʉ̃rẽ padeogó niiwõ. Coo wãmecʉtiwo Lidia. Coo Pablo wederére tʉorí, Cõãmacʉ̃ coore ãñurõ tʉonʉnʉ́seri tiiwí. ");
INSERT INTO tue_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Coore, cooya wii macãrãrẽ wãmeõtiari siro, ʉ̃sãrẽ jĩĩwõ: —Yʉʉre “diamacʉ̃́rã Jesuré padeogó niiyo” jĩĩ wãcũrã, jãmʉ, yáa wiipʉ pʉtʉáya, jĩĩwõ. Coo bayiró pʉtʉádutiri tʉorá, pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sicabʉreco ʉ̃sã Cõãmacʉ̃rẽ súubuseropʉ wáara, sĩcõ numiṍ wãtĩ sããnorigore bocawʉ. Coo ãpẽrãrẽ́ dutiapenori basoco niiwõ. Wãtĩ masĩré ticorémena too síropʉ wáaadarere wedemasĩwõ. Coo teero wederémena coore dutiapera pairó niyeru wapaséwa. ");
INSERT INTO tue_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pablore, ʉ̃sãrẽ bayiró bʉsʉrómena jĩĩnʉnʉsewo: —Ãniã Cõãmacʉ̃ ʉ̃mʉã́sepʉ niigʉ̃́rẽ padecotera niiĩya. Cõãmacʉ̃ basocáre netõnére quetire wedeeya, jĩĩwõ. ");
INSERT INTO tue_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pee bʉrecori teero jĩĩnʉnʉsewo. Pablope páasʉti, cãmenʉcã́, wãtĩ coomena niigʉ̃́rẽ jĩĩwĩ: —Mʉʉ coomena niigʉ̃́rẽ Jesucristo wãmemena witiwadutia, jĩĩwĩ. Máata witijõãrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Coore dutiapera “deero tii niyeru wapatánemoricu coomena” jĩĩwã. Teero tiirá, Pablo, Silare ñee, tiimacã decopʉ dutirápʉre néewawa. ");
INSERT INTO tue_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Queti beserí basoca pʉtopʉre néejea, jĩĩwã: —Ãniã judíoa niiĩya. Marĩya macã macãrãrẽ wedeñañorã tiiíya. ");
INSERT INTO tue_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Apeyé niirecʉtirere bueeya. Marĩ romanuã niijĩrã, teero niirijãrõ booa. Marĩ teeré tiimasĩ́ria, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Toopʉ́ neããriracã Pablo, Silamena cúajõãwã. Queti beserí basoca Pablo, Silare cʉ̃́ãye sutire tuuwéduti, tãnadutíwa. ");
INSERT INTO tue_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Cʉ̃́ãrẽ bayiró tãnatóa, peresuwiipʉ tuunécosõnecowa. Tiiwií coterí basocʉre dutiwitíwari jĩĩrã, ãñurõ biajã́dutiwa. ");
INSERT INTO tue_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cʉ̃́ã teero jĩĩrĩ tʉogʉ́, peresuwii coterí basocʉ niituri tatiapʉ tuunécosõnecoyigʉ cʉ̃́ãrẽ. Pʉagʉ́ yucʉgʉ tusure coperi watoapʉ cʉ̃́ãye dʉporire súucũduti, siatú, biadʉpójãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ñami deco Pablo, Silas Cõãmacʉ̃rẽ sãĩ, basapeoyira. Ãpẽrã́ peresu niirã́ cʉ̃́ã basari tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wãcũña manirṍ dita bayiró cãmeñayiro. Cʉ̃́ã niirí wii maquẽ botarí cãmeñayiro. Máata tiiwií biare sopepãmarĩ pã́õpetijõãyiro. Niipetira peresuwiipʉ niirã́rẽ cõmedárimena siatúarigue jõãpetíjõãyiro. ");
INSERT INTO tue_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tiiwií coterí basocʉ wãcã, tee pã́õãrigue soperire ĩña, “dutipetíjõããya” jĩĩ wãcũmiyigʉ. Teero tiigʉ́, cuigʉ, cʉ̃ʉ̃ basiro espada née, sĩãgʉ̃́dʉ tiimíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablope cʉ̃ʉ̃rẽ bayiró wedeseremena jĩĩyigʉ: —Mʉʉ basiro ñañarõ tiiríjãña. Ʉ̃sã ãnopʉ́ niipetijãã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Teero jĩĩrĩ tʉogʉ́, cʉ̃́ãrẽ coterí basocʉpe sĩãwócore néeatiduti, sĩãcʉtʉ́sãyigʉ Pablo, Silas niirṍpʉ. Cuigʉ, bayiró ñapõpigʉra, cʉ̃́ã pʉto ñicãcoberimena jeacũmuyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Too síro wʉ̃mʉnʉcã, cʉ̃́ãrẽ néewitiwa, sãĩñáyigʉ: —¿Deero tiibógari yʉʉ, Cõãmacʉ̃ yʉʉre netõnéãrõ jĩĩgʉ̃? ");
INSERT INTO tue_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Cʉ̃́ã yʉʉyira: —Mʉʉ ʉ̃sã Õpʉ̃ Jesuré padeogʉ́, netõnénogʉ̃dacu. Mʉʉya wii macãrãcã padeorá, netõnénoãdacua, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Cʉ̃ʉ̃rẽ, cʉ̃ʉ̃ya wii macãrãrẽ Cõãmacʉ̃ye quetire wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ñami tii horara cʉ̃́ã tãnaã́rigue cãmirẽ cosegʉ́dʉ néewayigʉ. Coseári siro, máata cʉ̃ʉ̃, cʉ̃ʉ̃ya wii macãrã wãmeõtinoyira. ");
INSERT INTO tue_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tiiwií coterí basocʉ cʉ̃ʉ̃ya wiipʉ néemʉãwa, cʉ̃́ãrẽ yaaré ecayígʉ. Cʉ̃ʉ̃, cʉ̃ʉ̃ya wederamena bayiró ʉseniyira Cõãmacʉ̃rẽ padeonʉcã́rã. ");
INSERT INTO tue_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bóeri queti beserí basoca tiimacã coterí basocare jĩĩyira: —Ĩ́niãrẽ wionécodutira wáaya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tiimacã coterí basoca toopʉ́ jea, cʉ̃́ã jĩĩãriguere tiiwií coterí basocʉre wedeyira. Teeré tʉo, cʉ̃ʉ̃pʉ Pablore wedeyigʉ sáa: —Mʉ́ãrẽ queti beserí basoca “wionécoaro” jĩĩãrira niiãwã. Teero tiirá, ãñurõ wáaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablope tiimacã coterí basocare jĩĩyigʉ: —Ʉ̃sã romanuã niipacari, queti beserí basoca ʉ̃sã tiiáriguere beseripacara, ʉ̃sãrẽ basocá ĩñacoropʉ tãnarĩ́ tiiáwã. Peresuwiipʉ tuunésõnecori tiiáwã. Mecʉ̃tígã ʉ̃sãrẽ basocá ĩñahẽrõpʉ wionécodʉgacua. Niiria. Cʉ̃́ã basiro atijĩrã, ʉ̃sãrẽ néewionecora atiaro, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tiimacã coterí basoca queti beserí basocare wedera wáayira. —Ĩ́niã “romanuã niiã ʉ̃sã” jĩĩ wedeawã, jĩĩyira. Teeré tʉorá, queti beserí basoca cuiyira. ");
INSERT INTO tue_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tiiwiipʉ́ jea, cʉ̃́ãrẽ acabóre sãĩyíra. Sãĩtóa, cʉ̃́ãrẽ peresuwiipʉ niirã́rẽ néewioneco: —Atimacãrẽ́ niirijãña; wáaya, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo, Silas peresuwiipʉ niiãrira wáa, Lidiaya wiipʉ sããwayira sũcã. Toopʉ́ Jesuré padeoráre ĩña, wãcũtutuare tico, wáajõãyira. ");
INSERT INTO tue_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo, Silas netõwáyira Anfípolis, Apolonia macãrĩrẽ. Too netõwá, jeayira Tesalónica macãpʉ. Tiimacãpʉre judíoa neãrí wii niiyiro. ");
INSERT INTO tue_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo cʉ̃ʉ̃ tiirucúrobirora tiiwiipʉ́ sããwayigʉ. Itiá semana cʉ̃́ã yeerisãre bʉrecoricõrõ Cõãmacʉ̃ye queti jóaripũ maquẽrẽ wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tiipũ maquẽrẽ cʉ̃́ãrẽ wede, “Cõãmacʉ̃ beserigʉre ñañarõ netõ diari siro, masãgʉ̃daqui” jĩĩ wedeyigʉ. —Jesús yʉʉ mʉ́ãrẽ jĩĩãrigʉ Cõãmacʉ̃ beserigʉra niiĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Cʉ̃ʉ̃ wederi tʉorá, sĩquẽrã judíoa “teerora niiã” jĩĩ, Pablo, Silamena niinʉcãyira. Teero biiri paʉ griegoa Cõãmacʉ̃rẽ padeorá, paʉ ʉpʉtí macãrã numiã cʉ̃́ãmena niinʉcãyira. ");
INSERT INTO tue_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Teero tiirá, ãpẽrã́ judíoa ĩñatutiyira Pablo, Silare. Teero tiirá, ʉ̃mʉã́ daderáre, ñañarã́ niisodeaatirare néõ, tiimacã macãrãrẽ cúaaro jĩĩrã, acaribídutiyira. Cʉ̃́ã cúara, Jasónya wiipʉ wáayira. Pablore, Silare basocá decopʉ néewaadara ãmaãrã wáamiyira. ");
INSERT INTO tue_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bʉaríyira. Cʉ̃́ãrẽ bʉahéra, Jasónrẽ, ãpẽrã́ Jesuré padeoráre ñee, wéewayira. Acaribíwa, tiimacã dutirá pʉtopʉ jea, wedesãyira: —Ãniã niipetiro cʉ̃́ã wáaropʉre wedemecʉ̃õrã tiicúa. Marĩya macãrẽ teerora tiijeáaya. ");
INSERT INTO tue_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón cʉ̃́ãrẽ cʉ̃ʉ̃ya wiipʉ cʉoárigʉ niiãwĩ. Cʉ̃́ã niipetire romanuã õpʉ̃ dutirére netõnʉcã́rã tiiáwã. “Ãpĩ õpʉ̃ niiĩ, Jesús wãmecʉtigʉ” jĩĩrã tiiáwã, jĩĩyira acaribíremena. ");
INSERT INTO tue_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Cʉ̃́ã teero jĩĩrĩ tʉorá, niipetira, cʉ̃́ãrẽ dutirácã dee tii masĩriyira. ");
INSERT INTO tue_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasónrẽ, cʉ̃ʉ̃ menamacãrãrẽ niyeru cṹũdutiyira cʉ̃́ãmena. —Ate wisióre quẽnojeáripʉ, wiyaáda mʉ́ãrẽ tee niyerure, jĩĩyira. Niyeru cṹũãri siro, cʉ̃́ãrẽ duujã́yira. ");
INSERT INTO tue_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Máata tiiñamirã Jesuré padeorá Pablo, Silare wáadutiyira Berea macãpʉ. Toopʉ́ jea, judíoa neãrí wiipʉ sããwayira. ");
INSERT INTO tue_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea macãrãpe Tesalónica macãrã nemorṍ basocá ãñurã́ niiyira. Cʉ̃́ã wederére tʉoʉséniyira. Teeré tʉorá, ¿diamacʉ̃́rã niimiĩ? jĩĩ masĩdʉgara, bʉ́recoricõrõ Cõãmacʉ̃ye queti jóaripũrẽ teero buerucujãyira. ");
INSERT INTO tue_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Teero tiirá, paʉ Jesuré padeonʉcã́yira. Basocá ãñurã́ griegoa numiã́, ʉ̃mʉã́cã paʉ padeonʉcã́yira. ");
INSERT INTO tue_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesalónica macãrã judíoa Pablo Bereapʉ “Cõãmacʉ̃ye quetire wedegʉ tiiáyigʉ” jĩĩrére tʉoyíra. Teero tiirá, toopʉ́ wáayira. Wedemecʉ̃õ, cúari tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Teero tiirí ĩñarã, Jesuré padeorá máata Pablore día pairímaapʉ wáadutiyira. Silas, Timoteo tiimacãpʉra pʉtʉájãyira. ");
INSERT INTO tue_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablore néewarira Atenaspʉ jea, cʉ̃ʉ̃rẽ toopʉ́ cṹũjã, cãmecópʉtʉayira. Cʉ̃́ãmenarã Pablo queti ticocoyigʉ: —Boyero Silas, Timoteo atiaro ãnopʉ́, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo Atenaspʉ cʉ̃́ãrẽ yuegʉ, tiimacã macãrã pee cʉ̃́ã padeorá weerirare ĩñagʉ̃, bayiró wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Teero tiigʉ́, judíoa neãrí wiipʉ sããwa, judíoamena, ãpẽrã́ Cõãmacʉ̃rẽ padeorámena wedeseyigʉ. Bʉ́recoricõrõ macã decopʉ cʉ̃ʉ̃ bʉajeáramena wedeseyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ãpẽrã́ epicúreoyere buerá, estoicoyere buerá Pablomena wedeseyira. Cʉ̃ʉ̃ Jesuyé quetire, diarirapʉ masãrére wedeyigʉ cʉ̃́ãrẽ. Cʉ̃́ã basiro cãmerĩ́ sãĩñáyira: —¿Deero jĩĩdʉgagʉ tiii ãni, teero wedeseãmajãgʉ̃? jĩĩyira. Ãpẽrãpé jĩĩyira: —Apeditá macãrã cʉ̃́ã padeoráye maquẽrẽ wedesegʉ niitu niiĩ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","“Jãmʉ” jĩĩ, cʉ̃ʉ̃rẽ néewayira Areópago buropʉ, dutirá neãrucuropʉ. Cʉ̃ʉ̃rẽ jĩĩyira: —Mʉʉ mama bueré wederére tʉodʉgága. ");
INSERT INTO tue_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mʉʉ tʉoyá maniríguere wedesea. Teeré masĩdʉgaga. ¿Deero jĩĩdʉgaro tiii? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas macãrã, aperó macãrã toopʉ́ jea niirã́ mama queti dícʉre tʉo, wedese ʉsenicua. ");
INSERT INTO tue_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pablo Areópagopʉ neãrã́ decopʉ wʉ̃mʉnʉcã, jĩĩyigʉ: —Mʉ́ã Atenas macãrã, mʉ́ãyarare bayiró padeóa, yʉʉ ĩñarĩ. ");
INSERT INTO tue_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Yʉʉ ĩñanetõgʉ̃, mʉ́ã súubuserere ĩñagʉ̃, sicaró mʉ́ã súubuseropʉ jóaturiguere ĩñaãwʉ̃: “MASĨÑA MANIGɄ̃́RẼ SÚUBUSERO NIIÃ”, jĩĩ jóaturigue niiãwʉ̃. Mʉ́ã masĩripacara súubusegʉrena yʉʉ mʉ́ãrẽ wedea. ");
INSERT INTO tue_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Cõãmacʉ̃ atibʉ́recore, atibʉ́recopʉ niirécãrẽ tiirígʉ niiwĩ. Ʉ̃mʉã́se, atiyepá Õpʉ̃ niiĩ. Teero tiigʉ́, basocá cʉ̃́ã tiiré wiserire niiriqui. ");
INSERT INTO tue_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Marĩ paderémena cʉ̃ʉ̃rẽ tiiápumasĩña manicú. Apeyenó dʉsarícu cʉ̃ʉ̃rẽ. Cʉ̃ʉ̃ niipetirare catiré, yeerisãre, apeyé niipetirere ticoqui. ");
INSERT INTO tue_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Sĩcʉ̃ basocʉ́menarã niipetire põnarĩ macãrã wáari tiirígʉ niiwĩ. Cʉ̃́ãrẽ atibʉ́reco niipetiropʉ wáa, niirĩ tiirígʉ niiwĩ. Cʉ̃ʉ̃rã́ niipetire põnarĩrẽ “atiditapʉ́ nocõrõ yoari niiãdacua” jĩĩ cṹũrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Cõãmacʉ̃ teero tiirígʉ niiwĩ, cʉ̃ʉ̃rẽ ãmaããrõ jĩĩgʉ̃. Ãñurõ ãmaãmasĩhẽrã niipacara, bʉabócua. Cʉ̃ʉ̃ marĩ sĩquẽrã pʉtogã niiqui. Yoaropʉ niiriqui. ");
INSERT INTO tue_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Cʉ̃ʉ̃ tutuaremena marĩ cati, wáamasĩ, niiã. Mʉ́ã basarére jóarira biiro jóarira niiwã: “Marĩcã cʉ̃ʉ̃ põna niiã”. ");
INSERT INTO tue_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Marĩ Cõãmacʉ̃ põna niijĩrã, oro, plata, ʉ̃tãmena tiirírare “Cõãmacʉ̃ niiĩ” jĩĩ wãcũrijãrõ booa. Marĩ wãcũrémena Cõãmacʉ̃ queorére tiimasĩ́ricu. ");
INSERT INTO tue_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Cõãmacʉ̃ too sʉguero macãrãpʉre cʉ̃ʉ̃rẽ masĩrijĩrã, cʉ̃ʉ̃ dutirére tiihérare teero ĩñajãrigʉ niiwĩ. Atitóre niipetirare niipetiropʉre cʉ̃́ã ñañaré tiirére wãcũpati, wasodutíqui. ");
INSERT INTO tue_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Cõãmacʉ̃ niipetirare wapa tiiádari bʉrecore besetoayigʉ. Tiibʉreco jeari, queoró jĩĩrémena wapa tiigʉ́daqui. Cʉ̃ʉ̃ beserigʉmena teero tiigʉ́daqui. “Cʉ̃ʉ̃rã́ mʉ́ãrẽ wapa tiigʉ́dʉ niiĩ” jĩĩ ẽñogʉ̃́, diarigʉpʉre masõrigʉ niiwĩ, jĩĩyigʉ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Diarirapʉ masãrére wederi tʉorá, sĩquẽrã buijã́yira. Ãpẽrãpé: —Too síro mʉʉ wedeseri tʉoáda teeréja, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pablo cʉ̃́ã too niirĩrã, wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sĩquẽrã Jesuré padeó, Pablore nʉnʉyíra. Sĩcʉ̃ Areópagopʉ dutirámena neãrucugʉ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Dionisio. Apegó Dámaris wãmecʉtiyigo. Ãpẽrã́ cʉ̃́ãmena niiyira. ");
INSERT INTO tue_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Too síro Pablo Atenaspʉ niiãrigʉ Corinto macãpʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Toopʉ́ jeagʉ, judíoayʉ Ponto dita macʉ̃rẽ bʉajeáyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Aquila. Pablo toopʉ́ wáaadari sʉguero, Claudio romanuã õpʉ̃ judíoa Romapʉ niirã́rẽ witidutiyigʉ. Aquila, cʉ̃ʉ̃ nʉmo Priscilamena Italiapʉ niiãrira witi, jeayira tiimacã Corintore. Pablo cʉ̃́ãrẽ ĩñagʉ̃ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Cʉ̃ʉ̃ cʉ̃́ã paderénorã padegʉ́ niijĩgʉ̃, cʉ̃́ãmena padegʉdʉ pʉtʉáyigʉ. Wáicʉra caserimena wiseri tiirá niiyira. ");
INSERT INTO tue_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Judíoa yeerisãre bʉrecoricõrõ cʉ̃́ã neãrí wiipʉ wedegʉ wáayigʉ. Judíoare, judíoa niihẽrãrẽ padeodʉgári tiidʉgágʉ tiimíyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas, Timoteo Macedoniapʉ niiãrira jeari, Pablo wederé dícʉ wedeyigʉ. “Jesús Cõãmacʉ̃ beserigʉ niiĩ”, jĩĩ wedemiyigʉ judíoare. ");
INSERT INTO tue_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Cʉ̃́ãpe cʉ̃ʉ̃ wederére cãmotánʉcãyira. Cʉ̃ʉ̃rẽ ñañarõ jĩĩyira. Teero tiigʉ́, Cõãmacʉ̃ cʉ̃́ãrẽ ñañarõ tiiádarere ẽñogʉ̃́, cʉ̃ʉ̃ sotoá sãñaãrirore, tuuwé páabateyigʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã pecamepʉ wáari, mʉ́ãye wapa niiãdacu; yée wapa mee niiãdacu. Teero tiigʉ́, mecʉ̃ãmena judíoa niihẽrãrẽ wedegʉ wáagʉda, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tiiwií niiãrigʉ witiwayigʉ. Apewií pʉtogã niirí wiipʉ sããwayigʉ. Tiiwií Ticio Justoya wii niiyiro. Cõãmacʉ̃rẽ padeogʉ́ niiyigʉ cʉ̃ʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Judíoa neãrí wii dutigʉ́, cʉ̃ʉ̃ya wii macãrãmena Jesuré padeoyíra. Cʉ̃ʉ̃ wãmecʉtiyigʉ Crispo. Paʉ too macãrãcã Pablo wederére tʉorá, Jesuré padeoyíra. Padeó, wãmeõtinoyira. ");
INSERT INTO tue_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sicañami Pablo cãnirípacʉ, quẽẽgʉ̃ tiiróbiro Jesús cʉ̃ʉ̃rẽ wederi tʉoyígʉ. Cʉ̃ʉ̃rẽ jĩĩyigʉ: —Cuirijãña. Yéere wederucujãña. Wededujã tiiríjãña. ");
INSERT INTO tue_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yʉʉ mʉʉmena niirucujãã. Basocá mʉʉrẽ ñañarõ tiimasĩ́ricua. Atimacãrẽ́ paʉ yʉʉre padeoádara niiĩya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Teero tiigʉ́, Pablo sicacʉ̃ma apecʉ̃má deco toopʉ́ pʉtʉáyigʉ. Cõãmacʉ̃ye quetire bueyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Teebʉrecorire sĩcʉ̃ Acaya dita dutigʉ́ niiyigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Galión. Cʉ̃ʉ̃ dutigʉ́ niirito, judíoa sĩcãrĩbíro wãcũrã Pablore ñee, queti beserópʉ néewayira. ");
INSERT INTO tue_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Galiónrẽ jĩĩyira: —Ãni Cõãmacʉ̃rẽ padeodutíre romanuã õpʉ̃ dutirére netõnʉcã́re niiã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo wedegʉdʉ tiirí, Galión judíoare wedesʉguecojãyigʉ: —Ãni apeyenó ñañoã́tã, basocáre ñañarõ tiiátã, mʉ́ãrẽ ãñurõ tʉobóajĩyu. ");
INSERT INTO tue_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mʉ́ãye, mʉ́ã judíoa dutiré niirĩ, mʉ́ã basiro quẽnoñá. Yʉʉ teenórẽ besegʉdʉ mee niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Cʉ̃́ã queti beserópʉ niiãrirare cõãwionecojãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Niipetira Sóstenes judíoa neãrí wii dutigʉ́re ñee, queti beserí wii díamacʉ̃ páayira. Galiónpe “cʉ̃́ã booró tiiáro” jĩĩjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo peebʉrecori pʉtʉáyigʉ Corintopʉ. Too síro Jesuré padeoráre “wáagʉ tiia” jĩĩ, dooríwʉmena wáajõãyigʉ Siria ditapʉ wáagʉ. Priscila, Aquila cʉ̃ʉ̃mena wáayira. Cencreapʉ búawasʉgueyira. Toopʉ́ Pablo Cõãmacʉ̃rẽ “biiro tiigʉ́da” jĩĩrirobirora tiigʉ́, cʉ̃ʉ̃ póare pedecõãjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Too macãrã Éfesopʉ tĩãjeayira. Tiimacãpʉ Pablo cṹũyigʉ Priscila, Aquilare. Cʉ̃ʉ̃pe judíoa neãrí wiipʉ sããwa, judíoare wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Cʉ̃ʉ̃rẽ yoasãñurĩ pʉtʉádutimiyira. Cʉ̃ʉ̃pe booríyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","—Jerusalénpʉ yʉʉre wáaro booa, bosebʉreco ĩñagʉ̃ wáagʉ. Mʉ́ãrẽ ĩñagʉ̃ atinemogʉ̃dacu, Cõãmacʉ̃ boorí, jĩĩyigʉ. “Wáagʉ tiia” jĩĩ, wáajõãyigʉ dooríwʉmena. ");
INSERT INTO tue_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesareapʉ jea, Jerusalénpʉ maawáyigʉ. Toopʉ́ Jesuré padeoráre ãñudutiyigʉ. Too macʉ̃ Antioquíapʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Toopʉ́re péero nii, wáajõãyigʉ sũcã. Galacia dita maquẽ macãrĩrẽ́, Frigia dita maquẽ macãrĩrẽ́ netõwáyigʉ. Niipetira Jesuré padeoráre wãcũtutuare ticonemoyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tíatore judíoayʉ Alejandría macã macʉ̃ Éfesopʉ jeayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Apolos. Cʉ̃ʉ̃ ãñurõ wedemenigʉ̃ niiyigʉ. Cõãmacʉ̃ye queti jóaripũ maquẽrẽ ãñurõ masĩgʉ̃́ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Marĩ Õpʉ̃ “biiro niirecʉtiro booa” jĩĩrére buenorigʉ niiyigʉ. Juan basocáre wãmeõtigʉ buerigue dícʉre masĩpacʉ, diamacʉ̃́ Jesuyére bueyigʉ ʉseniremena. ");
INSERT INTO tue_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Cʉ̃ʉ̃ judíoa neãrí wiipʉ cuire manirṍmena wedenʉcãyigʉ. Priscila, Aquila cʉ̃ʉ̃rẽ tʉo, néewa, Cõãmacʉ̃ye quetire ãñurõ diamacʉ̃́ wedenemoyira. ");
INSERT INTO tue_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Cʉ̃ʉ̃ Acayapʉ “wáagʉdʉ tiia” jĩĩrĩ, Jesuré padeorá “ãñurõ wáaya” jĩĩyira. Cʉ̃ʉ̃rẽ paperapũ jóabosayira. Jesuré padeorá Acayapʉ niirã́rẽ “Apolore ãñurõ bocaya” jĩĩ jóayira. Cʉ̃ʉ̃ toopʉ́ jeagʉ, Cõãmacʉ̃ tiiápuremena Jesuré padeoráre ãñurõ tiiápuyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Cʉ̃ʉ̃ niipetira ĩñacoropʉ judíoare cʉ̃ʉ̃ wedemeniremena docacũmurĩ tiiyígʉ. Cõãmacʉ̃ye queti jóaripũpʉ cʉ̃́ãrẽ bue, “Jesús Cõãmacʉ̃ beserigʉ niiĩ” jĩĩrére ẽñoyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corintopʉ niirito, Pablope ʉ̃mʉã́reburire netõwá, Éfesopʉre jeayigʉ. Toopʉ́ sĩquẽrã Cõãmacʉ̃rẽ padeoráre bʉajeáyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Cʉ̃́ãrẽ sãĩñáyigʉ: —Mʉ́ã Cõãmacʉ̃rẽ padeorí, ¿Espíritu Santo mʉ́ãmena niinʉcãrĩ? jĩĩyigʉ. Cʉ̃́ãpe yʉʉyira: —Ṍba. Ʉ̃sã Espíritu Santo niirére tʉohéra niitʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","—Too docare ¿noã wederiguere padeojĩ́rã, wãmeõtidutiri? jĩĩyigʉ. —Juan wederiguere padeojĩ́rã, wãmeõtidutiwʉ, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo jĩĩnemoyigʉ: —Juan basocáre wãmeõtiyigʉ. Teeména cʉ̃́ã ñañaré tiirére wãcũpati, wasorére ẽñoyíra. Juan biiro wedeyigʉ: “Yʉʉ siro ãpĩ atigʉdaqui. Cʉ̃ʉ̃rẽ padeoyá”, jĩĩyigʉ. Cʉ̃ʉ̃ teero jĩĩ wederigʉra niiĩ Jesús, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, Jesús wãmemena wãmeõtidutiyira. ");
INSERT INTO tue_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo cʉ̃́ãrẽ ñaapeóri, Espíritu Santo cʉ̃́ãpʉre niigʉ̃ diijeáyigʉ. Ãpẽrã́ basocáye wedeserere masĩripacara, wedesenʉcãyira. Cõãmacʉ̃ wededutirere wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Cʉ̃́ã niipetira niirã, doce ʉ̃mʉã niiyira. ");
INSERT INTO tue_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo tiimacãpʉ judíoa neãrí wiipʉ wáarucuyigʉ. Ĩtĩã́rã muĩpũrã tiiwiipʉ́re cuire manirṍmena wedeyigʉ. “Cõãmacʉ̃ dutiré basocápʉre niiãdare jeatoaa” jĩĩrémena Jesuré padeorí tiijã́dʉgagʉ tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Sĩquẽrã cʉ̃ʉ̃ wederére tʉodʉgáriyira. Padeoríyira. Mama buerére basocá tʉocóropʉ ñañarõ wedeseyira. Teero tiigʉ́, Pablo witiweojõãyigʉ; Jesuré padeoráre néewitiwayigʉ. Bʉ́recoricõrõ Tiranoya wiipʉ neãyira. Tiiwií buerí wiipʉ bueyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pʉacʉ̃má bueyigʉ. Teero tiirá, tiidita Asia macãrã tʉopetíjõãyira Jesuyé quetire. Judíoa, judíoa niihẽrãcã teeré tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Cõãmacʉ̃ cʉ̃ʉ̃ sĩcʉ̃rã tiimasĩ́rere Pablomena tiiẽ́ñoyigʉ. Cʉ̃ʉ̃mena ĩñaña manirére tiiyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Cʉ̃ʉ̃ paacõã́re caserire, cʉ̃ʉ̃ya õpʉ̃ʉ̃ pẽniã́rigue caserire néewayira diarecʉtirare. Teeména netõnéyira; wãtĩã sããnorirare cõãwionecoyira. ");
INSERT INTO tue_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Sĩquẽrã judíoa wáanetõrã wãtĩãrẽ cõãwionecora niiyira. Cʉ̃́ã marĩ Õpʉ̃ Jesús wãmemena wãtĩãrẽ cõãwionecodʉgamiyira. —Jesús Pablo wedewarucugʉ wãmemena mʉ́ãrẽ witiwadutia, jĩĩmiyira wãtĩãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Teerora tiirá tiimíyira Esceva põnacã. Esceva judíoayʉ, paiaré dutigʉ́ niiyigʉ. Cʉ̃ʉ̃ põna siete niiyira. ");
INSERT INTO tue_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Cʉ̃́ã teero tiirí, wãtĩ cʉ̃́ãrẽ yʉʉyigʉ: —Jesuré yʉʉ masĩã. Pablocãrẽ masĩã. ¿Mʉ́ãpeja noãnó niiĩ? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Basocʉ́ wãtĩ sããnorigʉ cʉ̃́ãpʉre bupuñápeayigʉ. Cʉ̃́ã niipetira nemorṍ tutuanetõnʉcãjãyigʉ. Cʉ̃́ãrẽ ñañarõ peti tiiyígʉ. Sutimanírã, cãmicʉtira tiiwií niiãrira cʉtʉcówitiwayira. ");
INSERT INTO tue_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Cʉ̃́ãrẽ teero wáare quetire Éfeso macãrã tʉopetíjõãyira. Niipetira judíoa, judíoa niihẽrãcã tʉoyíra. Bayiró cuiyira sáa. Marĩ Õpʉ̃ Jesuyére ãñurõ quioníremena wedeseyira sáa. ");
INSERT INTO tue_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Paʉ too sʉgueropʉ Jesuré padeonʉcã́rira jea, cʉ̃́ã ñañaré tiirére wedeyira. ");
INSERT INTO tue_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Paʉ yaso doarira cʉ̃́ã bueré papera tutirire néeneõ, sóecõãjãyira niipetira ĩñacoropʉ. Teetutiri wapa cʉ̃́ã bapaqueori, “cincuenta mil” niyeruquiri plataquiri wapacʉtímiyiro. ");
INSERT INTO tue_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ateména marĩ Õpʉ̃ye queti sesajõãrõ tiiyíro. Cõãmacʉ̃ tutuaremena paʉ padeonemórã tiiyíra. ");
INSERT INTO tue_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ate wáari siro, Pablo wãcũyigʉ: “Yʉʉ Jerusalénpʉ pʉtʉawagʉda. Toopʉ́ wáaadari sʉguero, Macedonia, Acaya ditapʉ ĩñanetõgʉ̃ wáagʉda. Jerusalénpʉ jea, niiãri siro, Romapʉ ĩñagʉ̃ wáaro boocú”, jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Teero tiigʉ́, pʉarã́ cʉ̃ʉ̃rẽ tiiápurare ticocosʉgueyigʉ Macedoniapʉ. Cʉ̃́ã niiyira Timoteo, Erasto. Cʉ̃ʉ̃pe pʉtʉájãyigʉ ména toopʉ́ Asia ditapʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tíatorena mama bueré padeorémena bayiró cúasore wáayiro. ");
INSERT INTO tue_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Cúasori tiinʉcã́yigʉ sĩcʉ̃ plata padegʉ́. Cʉ̃ʉ̃ wãmecʉtiyigʉ Demetrio. Platamena cʉ̃́ã padeogóya wii tiiróbiro biiré wiserigã tii, dúagʉ niiyigʉ. Cʉ̃́ã padeogó weerigo wãmecʉtiyigo Artemisa. Tee wiserigãrẽ dúara, Demetrio, cʉ̃ʉ̃rẽ padecoteracã pairó wapatárucuyira. ");
INSERT INTO tue_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Cʉ̃ʉ̃rẽ padecotera, ãpẽrã́ plata paderáre néõyigʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã ãñurõ masĩã: Marĩ ate paderémena ãñurõ wapatá niijãmiã. ");
INSERT INTO tue_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ãno Éfesopʉre Pablo paʉre cʉ̃ʉ̃ wederémena nʉnʉrĩ́ tiitóai mée. Ãno Asiapʉcãrẽ mʉ́ã ĩñarõbirora, teero biiri mʉ́ã tʉoróbirora paʉ niicua. Basocá tiiríraja “padeorá mee niiĩya” jĩĩãwĩ cʉ̃ʉ̃du. ");
INSERT INTO tue_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ate bayiró quioa. Marĩ tiiré bʉ́ri niiré pʉtʉábocu. Artemisa ãñunetõjõãgõya wiicã bʉ́ri niirí wii pʉtʉábocu. Coo Asia macãrã padeogó niipetira atibʉ́reco macãrã padeogó niiyo. Coo ʉpʉtí macõ niirére basocá ñañarõ wedesenʉcãrĩ, bʉ́ri niiré pʉtʉábocu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, bayiró cúa, acaribíyira: —Artemisa ãñunetõjõãgõ Éfeso macãrã padeogó niiyo, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Cʉ̃́ã acaribíri, paʉ tiimacã macãrãcã “¿deero wáai?” jĩĩ masĩripacara, acaribípetijõãyira. Sĩcãrõména cʉ̃́ã neãrṍpʉ cʉtʉwáyira. Pablomena bapacʉtiwarirare bayiró ñee, néewayira. Cʉ̃́ã niiyira Gayo, Aristarco. Macedonia macãrã niiyira. ");
INSERT INTO tue_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo basocá decopʉ sããwadʉgamiyigʉ. Jesuré padeorápe cʉ̃ʉ̃rẽ wáadutiriyira. ");
INSERT INTO tue_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ãpẽrã́ Pablore maĩrã́ queti ticocoyira. Cʉ̃́ã sĩquẽrã Asia macãrã dutirá niiyira. “Pablo ʉ̃sã neãrṍpʉ sããatirijããrõ”, jĩĩcoyira. ");
INSERT INTO tue_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Toopʉ́ niirã́ ãpẽrã́ cʉ̃́ã booró acaribíyira. Ãpẽrã́ apeyenó acaribíyira. Ãpẽrãcã́ teerora jĩĩãmajãyira. “¿Marĩ ãnopʉ́ deero tiirá neããrĩ?” jĩĩ masĩriyira. ");
INSERT INTO tue_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ãpẽrã́ judíoa Alejandrore ĩñabʉayira. Basocá díamacʉ̃pʉ cʉ̃ʉ̃rẽ tuunéconʉcõcoyira, wedearo jĩĩrã. Cʉ̃́ãrẽ “ditamaníjõãña” jĩĩdʉgagʉ, wẽ́ẽtucomiyigʉ. “Ʉ̃sã wapa cʉoría”, jĩĩdʉgamiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","“Cʉ̃ʉ̃ judíoayʉ niiĩ”, jĩĩ ĩñamasĩrã, acaribínemoyira. Pʉa hora sĩcãrĩbíro acaribíyira. —Artemisa ãñunetõjõãgõ Éfeso macãrã padeogó niiyo, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Sĩcʉ̃ tiimacã macãrãrẽ dutigʉ́ too acaribírare ditamanírĩ tiiyígʉ. Cʉ̃́ãrẽ jĩĩyigʉ: —Mʉ́ã Éfeso macãrã, yʉʉre tʉoyá. Niipetiro macãrã ateré masĩcua: Marĩ atimacã́ Éfeso macãrã Artemisa ãñunetõjõãgõ padeorí wiire coterá niiã. Coo queoré ʉ̃mʉã́sepʉ diiátiriguere coterá niiã. ");
INSERT INTO tue_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sĩcʉ̃ “teero mee niiã” jĩĩmasĩriqui. Teero tiirá, nocõrõrã acaribíya. Ãñurõ wãcũsʉgueya, noo booró tiiã́marĩ jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ãniã mʉ́ã néeatiarira apeyé marĩ padeorí wii maquẽrẽ yaaríarira niiãwã. Marĩ padeogóre ñañarõ wedeseriarira niiãwã. ");
INSERT INTO tue_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio, ãpẽrã́ plata paderámena wedesãre cʉogʉ́, queti beserópʉ wáaaro. Tee niiãdarerena queti beseró, queti beserí basocacã niiĩya. Toopʉ́ cãmerĩ́ wedesããrõ. ");
INSERT INTO tue_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mʉ́ã apeyenó sãĩdʉgára, atimacã́ macãrã dutirámena cʉ̃́ã neãrṍpʉ wedesera wáaya. Cʉ̃́ã mʉ́ãrẽ wedeadacua. ");
INSERT INTO tue_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mecʉ̃ã marĩ acaribíariguere romanuã dutirá marĩrẽ wedesãrĩquioro tiirá tiia. Marĩ teero peti acaribíro bauró acaribíãmajãrã tiiáwʉ̃. Teero tiirá, romanuã cʉ̃́ã wedesãrĩ, marĩrẽ deero jĩĩ yʉʉmasĩña maniã́dacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Teero wedeseyapacʉti: —Nocõrõrã niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Cúasore petiári siro, Pablo Jesuré padeoráre neãdutiyigʉ. Cʉ̃́ãrẽ wãcũtutuare tico, “wáagʉ tiia” jĩĩ, Macedoniapʉ wáajõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Too maquẽ macãrĩpʉ netõwágʉ, too macãrãrẽ cʉ̃ʉ̃ wederémena wãcũtutuare ticonemowayigʉ. Teero tii, jeayigʉ Greciapʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Toopʉ́ ĩtĩã́rã muĩpũrã pʉtʉáyigʉ. Cʉ̃ʉ̃ Siriapʉ dooríwʉmena wáagʉdʉ, judíoa cʉ̃ʉ̃rẽ sĩãdʉgáre quetire tʉoyígʉ. Teero tiigʉ́, “Macedonia wáarimapʉra cãmepʉtʉ́awagʉda sũcã” jĩĩ wãcũyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Cʉ̃ʉ̃ wáari, ãpẽrã́ cʉ̃ʉ̃rẽ bapacʉtiwarira niiwã. Cʉ̃́ã niiwã: Sópater Berea macã macʉ̃ (cʉ̃ʉ̃ Pirro wãmecʉtigʉ macʉ̃ niiwĩ); Segundo, Aristarco (cʉ̃́ã pʉarã́ Tesalónica macãrã niiwã); Gayo Derbe macã macʉ̃; Timoteo; Tíquico, Trófimo (cʉ̃́ã pʉarã́ Asia macãrã niiwã). ");
INSERT INTO tue_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Cʉ̃́ã ʉ̃sã sʉguero wáa, Troaspʉ ʉ̃sãrẽ yuerira niiwã. ");
INSERT INTO tue_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ʉ̃sã Filipospʉ pʉtʉáwʉ. Toopʉ́ pã púuri tiirémena wʉ́oya maniré pãrẽ yaarí bosebʉreco ĩñawʉ̃. Nocõrõrã nii, wáajõãwʉ̃ dooríwʉmena. Cinco bʉrecori siro jeawʉ Troaspʉ. Toopʉ́ sica semana pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Yeerisãri bʉreco niirĩ, ʉ̃sã neãwʉ̃ bocaadara. Apebʉ́recope Pablo wáagʉdʉ niijĩgʉ̃, cʉ̃́ãrẽ wedewi. Ñami deco niirĩ, wedegʉ tiiwí ména. ");
INSERT INTO tue_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ʉ̃mʉã́rõ macã tatia ʉ̃sã neãrí tatiapʉ pee sĩãwócorepa niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Sĩcʉ̃ mamʉ ventana sopepʉ duigʉ́ wʉgoá jeanowĩ. Cʉ̃ʉ̃ wãmecʉtiwi Eutico. Pablo yoari peti wedegʉ tiirí, cãnicónuãrigʉ niiwĩ. Yepapʉ ñaacodiawi. Cʉ̃ʉ̃ duiariro itiácasa sotoapʉ niiwʉ̃. Cʉ̃́ãpe cʉtʉdiwá, diaarigʉpʉre néemʉõcowa. ");
INSERT INTO tue_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablocã diiwáwi. Cʉ̃ʉ̃ sotoa munibiá, cʉ̃ʉ̃rẽ ñeediyo, cʉ̃́ãrẽ jĩĩwĩ: —Nocõrõca ʉcʉárijãña. Catijãĩ ména, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mʉãwa, cʉ̃́ãrẽ pã bato, yaa, wedeseboejõã, wáajõãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mamʉpere wiipʉ́ néejõãwã. Cʉ̃ʉ̃ catiri, ãñurõ yeeripũnacʉtira niiwã sũcã. ");
INSERT INTO tue_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo ʉ̃sãrẽ jĩĩrirobirora dooríwʉmena cʉ̃ʉ̃ sʉguero Asopʉ wáajõãwʉ̃. Pablo ʉ̃sãrẽ: —Yʉʉ maapʉ wáa, Asopʉ mʉ́ãrẽ bocagʉda, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asopʉ ʉ̃sãmena bʉajeá, ʉ̃sã atiriwʉpʉ sããwĩ. Too síro Mitilenepʉ tĩãwawʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Too macãrã apebʉ́reco Quío nʉcʉ̃rõ díamacʉ̃pʉ tĩãjeawʉ. Maawáriwʉ. Too macãrã apebʉ́reco Samospʉ tĩãjeawʉ. Too macãrã apebʉ́reco Miletopʉ jeajõãwʉ̃ sáa. ");
INSERT INTO tue_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ʉ̃sã Miletopʉ wáara, Éfesore diamacʉ̃́ netõjṍãwʉ̃. Pablo Asiapʉ yoari pʉtʉádʉgariwi. Cʉ̃ʉ̃rẽ basioatã, Jerusalénpʉ Pentecostés bosebʉreco ĩñadʉgawi. ");
INSERT INTO tue_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pablo Miletopʉ niigʉ̃, Éfeso macãrã Jesuré padeorá bʉtoá dutiráre atiduticowi. ");
INSERT INTO tue_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Cʉ̃́ã jeari ĩña, cʉ̃́ãrẽ jĩĩwĩ: —Mʉ́ã ãñurõ masĩcu yʉʉ mʉ́ã watoapʉre tiirécʉtiriguere. Yʉʉ sicato Asiapʉ jeagʉ, tée yʉʉ niitugʉpʉ tiitúcoriguere ãñurõ masĩcu. ");
INSERT INTO tue_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yʉʉ marĩ Õpʉ̃ dutiró tiigʉ́, “ãpẽrã́ nemorṍ ãñuré tiia” jĩĩ wãcũriwʉ. Mʉ́ãmena utiwʉ. Judíoa yʉʉre ñañarõ tiidʉgári, ñañarõ netõwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Niipetire mʉ́ã ãñurõ niiãdarere wedepetijãwʉ̃. Basocá neãrṍpʉ, mʉ́ãye wiseripʉ teero wederucujãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judíoare, judíoa niihẽrãcãrẽ ateré sĩcãrĩbíro wedewʉ: “Mʉ́ã ñañaré tiirére wãcũpati, wasoyá; Cõãmacʉ̃yere ãñurõ tiinʉcã́ña; Jesús marĩ Õpʉ̃rẽ padeoyá”, jĩĩ wederucujãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yʉʉ mecʉ̃tígã wáagʉ tiia Jerusalénpʉ Espíritu Santo yʉʉre dutirirobirora. Toopʉ́ yʉʉre deero wáaro wáaadacu masĩriga. ");
INSERT INTO tue_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ate dícʉre masĩã: Basocá ñañarõ netõrĩ́ tii, yʉʉre peresuwiipʉ sõnecoadacua. Ateré macãrĩcṍrõ Espíritu Santo yʉʉre wedei. ");
INSERT INTO tue_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ateré masĩpacʉ, wãcũpatiria. Yʉʉ catirére maĩría. Marĩ Õpʉ̃ Jesús cʉ̃ʉ̃ paderé cṹũriguere peotídʉgaga. Cõãmacʉ̃ basocáre netõnére quetire wededutiwi yʉʉre. ");
INSERT INTO tue_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Yʉʉ mʉ́ã pʉtopʉ niigʉ̃, Cõãmacʉ̃ dutiré basocápʉre niiãdare jeariguere wedewarucuwʉ. “Mʉ́ã sĩcʉ̃no yʉʉre ĩñanemoricu sáa”, jĩĩ tʉgueñajãga. ");
INSERT INTO tue_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Teero tiigʉ́, mecʉ̃ã mʉ́ãrẽ wedea: Yʉʉ wederiguere tʉoríra pecamepʉ wáari, yée wapa niiricu. ");
INSERT INTO tue_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Yʉʉ mʉ́ãrẽ niipetire Cõãmacʉ̃ye quetire wederijã tiiríwʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Teero tiirá, mʉ́ã basiro coteya. Jesuré padeorí põna macãrãcãrẽ ãñurõ cote, buenemoña. Mʉ́ãrẽ Espíritu Santo cṹũrigʉ niiwĩ, cʉ̃́ãrẽ ĩñanʉnʉsearo jĩĩgʉ̃. Cõãmacʉ̃ cʉ̃ʉ̃ macʉ̃ye díimena cʉ̃́ãrẽ cʉ̃ʉ̃yara wáari tiirígʉ niiwĩ. Teero tiirá, oveja coterí basoca tiiróbiro cʉ̃́ãrẽ tiiápuya. ");
INSERT INTO tue_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yʉʉ tʉgueñarĩ, yʉʉ wáari siro, ãpẽrã́ jĩĩditorepira mʉ́ãmena niirã jeaadacua. Yáiwa ovejare sĩãrã́ tiiróbiro mʉ́ã Jesuré padeorére petirí tiidʉgáadacua. ");
INSERT INTO tue_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sĩquẽrã mʉ́ã menamacãrãcã wedewisioadacua, Jesuré padeorá cʉ̃́ãrẽ tʉonʉnʉ́searo jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Teero tiirá, ãñurõ tʉomasĩ́ niiña. Mʉ́ã ateré acabóricu: Itiácʉ̃ma mʉ́ã niipetirare ãñurõ tiiádarere bóaneõremena bʉ́recori, ñamirĩ́ wedewʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Yʉʉ wáagʉ tiia. Cõãmacʉ̃ mʉ́ãrẽ ãñurõ cotearo. Cʉ̃ʉ̃ maĩré quetimena mʉ́ãrẽ tutuare ticoaro. Tee queti mʉ́ãrẽ wãcũtutuari, padeonemórĩ tiimasĩ́cu. Tee quetire padeorí, ãpẽrã́ Jesuré padeorámena mʉ́ãrẽ ãñuré ticogʉdaqui Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ãpẽrãyé niyeru, oro, suti boonemósãriwʉ yʉʉ. ");
INSERT INTO tue_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mʉ́ã masĩcu: Yée wãmorĩmena padewʉ. Teeména yʉʉ, yʉʉ menamacãrã booríguenorẽ bʉawʉ́. ");
INSERT INTO tue_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Niipetire yʉʉ tiiríguemena mʉ́ãrẽ ẽñowʉ̃́. Marĩ paderémena bóaneõrãrẽ tiiápuro booa. Marĩ Õpʉ̃ Jesús cʉ̃ʉ̃ jĩĩriguere wãcũrõ booa: “Ticogʉ́pe ñeegʉ̃́ nemorṍ ʉseniqui”, jĩĩyigʉ, jĩĩwĩ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Teeré jĩĩtoanʉcõ, cʉ̃́ã niipetiramena ñicãcoberimena jeacũmu, Cõãmacʉ̃rẽ sãĩwĩ́. ");
INSERT INTO tue_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Niipetira bayiró utiwa. Cʉ̃ʉ̃rẽ páabʉa, wasopúro ũpũ tiiwá. ");
INSERT INTO tue_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Cʉ̃ʉ̃ “mʉ́ã yʉʉre ĩñanemoricu sáa” jĩĩãriguere wãcũrã, nemorṍ bóaneõrã pʉtʉáwa. Too síro dooríwʉpʉ cʉ̃ʉ̃rẽ cṹũcora wáawa. ");
INSERT INTO tue_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ʉ̃sã Éfeso macãrã bʉtoá dutiráre “wáara tiia” jĩĩtoa, dooríwʉpʉ mʉãsã, wáajõãwʉ̃. Wáa, diamacʉ̃́ wáa, Cos macãpʉ jeawʉ. Apebʉ́reco Rodas macãpʉ, too macãrã Pátara macãpʉ jeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Toopʉ́ Feniciapʉ wáariwʉcare bʉajeáwʉ. Tiiwʉpʉ́ mʉãsã, wáajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Wáa, Chipre nʉcʉ̃rõrẽ ĩñawa, tiinʉcʉ̃rõ acuniñape pʉtʉáwʉ. Too netõwá, Siria ditapʉre jeawʉ. Jea, Tiro macãpʉ maajeáwʉ. Toopʉ́ tiiwʉ́ macãrã apeyé cʉ̃́ã néewariguere apamonecoadara tiiwá. ");
INSERT INTO tue_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Toopʉ́ ʉ̃sã Jesuré padeoráre ãmaã, bʉajeáwʉ. Cʉ̃́ãmena sica semana pʉtʉáwʉ. Cʉ̃́ã Espíritu Santo masĩré ticorémena Pablore “Jerusalénpʉ wáarijãña” jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Cʉ̃́ã teero jĩĩpacari, tii semana petirí, wáajõãwʉ̃ sũcã. Cʉ̃́ã niipetira, cʉ̃́ã nʉmosã́numiã, cʉ̃́ã põna ʉ̃sãrẽ bapacʉtibuawa macã wesapʉ. Ditatuparipʉ ñicãcoberimena jeacũmu, Cõãmacʉ̃rẽ sãĩwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sãĩtóa, “wáara tiia” jĩĩ, dooríwʉcapʉ mʉãsãwʉ̃. Cʉ̃́ãpe cʉ̃́ãye wiseripʉ pʉtʉajõãwã. ");
INSERT INTO tue_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiropʉ niiãrira wáa, Tolemaida macãpʉ jeawʉ. Toopʉ́ Jesuré padeoráre ãñuduti, sicabʉreco pʉtʉáwʉ cʉ̃́ãmena. ");
INSERT INTO tue_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Apebʉ́reco wáa, Cesareapʉ jeawʉ. Toopʉ́ jeara, Felipe Jesuyé queti wedegʉ́ya wiipʉ sããwawʉ. Felipe Jesuré padeorá siete yaaré batorira menamacʉ̃ niirigʉ niiwĩ. Cʉ̃ʉ̃ pʉtopʉ pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Cʉ̃ʉ̃ põna numiã manʉmanirã bapari niiwã. Cʉ̃́ã profetas niiwã. ");
INSERT INTO tue_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yoari ʉ̃sã niiripacari, sĩcʉ̃ Judeapʉ niiãrigʉ jeawi. Profeta niiwĩ. Cʉ̃ʉ̃ wãmecʉtiwi Agabo. ");
INSERT INTO tue_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ʉ̃sã pʉto jea, Pabloyada siatúridare née, cʉ̃ʉ̃ basiro cʉ̃ʉ̃ye dʉpori, cʉ̃ʉ̃ye wãmorĩpʉ siatúwi. Siatútoa, ʉ̃sãrẽ jĩĩwĩ: —Espíritu Santo jĩĩãwĩ yʉʉre: “Judíoa Jerusalénpʉ atidá õpʉ̃rẽ siatúadacua ãno mʉʉ siatúro tiiróbiro. Cʉ̃ʉ̃rẽ judíoa niihẽrãpʉre ticoadacua”, jĩĩwĩ Agabo. ");
INSERT INTO tue_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Cʉ̃ʉ̃ teero jĩĩrĩ tʉorá, ʉ̃sã Pablore: —Jerusalénpʉ wáarijãña, jĩĩmiwʉ̃. Cesarea macãrãcã: —Wáarijãña, jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Cʉ̃ʉ̃pe jĩĩwĩ: —Utirijãña. Yʉʉre bayiró wãcũpatiri tiirá tiia. Jerusalénpʉ Jesuyé wapa yʉʉre siatú, sĩãdʉgápacari, wáagʉda, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Cʉ̃ʉ̃ “jáʉ, ãñuã” jĩĩhẽrĩ ĩñarã: —Cõãmacʉ̃ booró tiiáro, jĩĩjãwʉ̃. Nocõrõrã ditamanírã pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ʉ̃sã too niiãrira ʉ̃sãye ĩñanotoa, wáajõãwʉ̃ Jerusalénpʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sĩquẽrã Cesarea macãrã Jesuré padeorá wáawa ʉ̃sãmena. Cʉ̃́ã ʉ̃sãrẽ néewawa Mnasónya wiipʉ. Cʉ̃ʉ̃ Chipre macʉ̃ niirigʉ niiwĩ. Yoari Jesuré padeogʉ́ niiwĩ. Toopʉ́ cãniwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ʉ̃sã Jerusalénpʉ jeari, Jesuré padeorá ʉseniremena bocawa ʉ̃sãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Apebʉ́reco Pablo ʉ̃sãmena Santiagore ĩñagʉ̃ wáawi. Toopʉ́ niipetira bʉtoá dutirá niiwã. ");
INSERT INTO tue_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo cʉ̃́ãrẽ ãñudutiwi. Judíoa niihẽrãrẽ Cõãmacʉ̃ cʉ̃ʉ̃mena tiiríguecõrõ dʉaró manirṍ wedemʉãnʉcãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Teeré tʉo, Cõãmacʉ̃rẽ ʉsenire ticowa. Pablore jĩĩwã: —Ʉ̃sãya wedegʉ, mʉʉ masĩcu: Paʉ peti judíoa Jesuré padeorá niiĩya. Cʉ̃́ã “Moisére dutiré cṹũriguere tiipetíro booa” jĩĩrã tiiíya. ");
INSERT INTO tue_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Cʉ̃́ã ate wedepatirere tʉoáyira: Mʉʉ judíoa niihẽrãye ditapʉ niigʉ̃, judíoa toopʉ́ niirã́rẽ Moisés dutirére “tiiríjãña” jĩĩyiro. Cʉ̃́ã põnarẽ cõnerígʉ yapa macã caseróre “widecõã́rijãña” jĩĩyiro. Teero biiri marĩ judíoa tiirécʉtirenocãrẽ “tiiríjãña” jĩĩyiro. Teeré tʉoyíra. ");
INSERT INTO tue_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“¿Deero tiigʉ́dari cʉ̃ʉ̃?” jĩĩ wedeseawʉ̃ ʉ̃sã mʉʉrẽ. Cʉ̃́ã mʉʉ “ãnopʉ́ jeaayigʉ” jĩĩrére tʉoádacua. ");
INSERT INTO tue_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Teero tiirá, ʉ̃sã biiro wãcũãwʉ̃: Ʉ̃mʉã́ bapari Cõãmacʉ̃rẽ “biiro tiiáda” jĩĩãrira niiãwã. ");
INSERT INTO tue_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mʉʉ cʉ̃́ãmena Cõãmacʉ̃wiipʉ wáari, ãñubocu. Mʉʉcã cʉ̃́ã tiiróbirora tiiyá. Cʉ̃́ã marĩ tiirénorẽ tiirá tiiáwã. Atebʉ́recorire ñañaré tiiáriguere acabóre sãĩrã́ tiiáwã. Niipetire wáicʉra cʉ̃́ã Cõãmacʉ̃rẽ ticoadarare mʉʉ sãĩbosáya. Mʉʉ teero tiiári siro, cʉ̃́ã póare pedecõãdutiadacua. Mʉʉ biiro tiiáriguere masĩrã, niipetira judíoa mʉʉye quetire “teero jĩĩãmajãrã tiijĩ́ya” jĩĩãdacua. “Cʉ̃ʉ̃cã Moisére dutiré cṹũriguere ãñurõ tiigʉ́ niiĩ”, jĩĩãdacua. ");
INSERT INTO tue_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jesuré padeorá judíoa niihẽrãpere “biiro tiirí ãñuãdacu” marĩ jĩĩriguere jóacotoawʉ: Wáicʉra dii cʉ̃́ã padeoráre ticoariguere yaarijãña. Wáicʉraye díire sĩniríjãña. Wáicʉra dii díi cõãña maniré diiré yaarijãña. Ãpẽrãména ñañarõ ñeeaperijãña, jĩĩ jóawʉ, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Apebʉ́recope Pablo cʉ̃́ã baparire néewawi. Pablo cʉ̃ʉ̃ ñañaré tiiáriguere acabóre sãĩtóari, Cõãmacʉ̃wiipʉ sããwayira. Pablo pairé wedeyigʉ: —Sica semana dʉsaa ãniã ñañaré tiiáriguere acabóre sãĩã́daro. Niituri bʉrecore cʉ̃́ãcõrõ wáicʉrare sĩãdutí, ticoadacua Cõãmacʉ̃rẽ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Cʉ̃́ã siete bʉrecori peotíadara tiirí, judíoa Asia macãrã Pablore Cõãmacʉ̃wiipʉ niirĩ ĩñayira. Cʉ̃ʉ̃rẽ ĩñarã, ãpẽrãrẽ́ cúarosãrĩ tiiyíra. Cʉ̃́ã cʉ̃ʉ̃rẽ ñee, acaribíyira: ");
INSERT INTO tue_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","—Ʉ̃sãya wedera, tiiápura atiya. Ãnirã́ niiĩ niipetiropʉ niipetirare ñañarõ buewarucugʉ. Cʉ̃ʉ̃ marĩ judíoa maquẽrẽ, Moisére dutiré cṹũriguere, teero biiri atiwií maquẽrẽ ñañarõ wedesewarucuyigʉ. Apeyeréja, griegoare atiwiipʉ́re néesããwĩ. Cʉ̃ʉ̃ biiro tiigʉ́, atiwií ñañaré manirí wiire ñañogʉ̃́ tiii, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ate sʉguero Trófimo Éfeso macʉ̃ Pablomena macãpʉ niirĩ ĩñayira. Teero ĩñarira niijĩrã, cʉ̃́ã “cʉ̃ʉ̃rẽ Cõãmacʉ̃wiipʉ néesããjĩyi” jĩĩ wãcũrira niimiwã. ");
INSERT INTO tue_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Cʉ̃́ã wedesãrĩ tʉorá, niipetira tiimacã macãrã acaribíbatejõãwã. Cʉtʉjeáwa. Pablore ñee, wéecowitiawa, tée Cõãmacʉ̃wii sopepʉtópʉ. Máata sopepãmarĩrẽ biajã́wã. ");
INSERT INTO tue_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pablore sĩãã́darapʉ tiirí, ãpẽrã́ basocá surara dutigʉ́pʉre wedera wáarira niiwã: —Niipetira atimacã́ Jerusalén macãrã neã, cúa, acaribíra tiiáwã, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Cʉ̃ʉ̃ tee quetire tʉogʉ́, cʉ̃ʉ̃yara surarare, cʉ̃́ãrẽ dutiráre néõ, diiáti, cʉtʉátiwa cʉ̃́ã pʉtopʉ. Surara dutigʉ́ suraramena cʉtʉátiri ĩñarã, Pablore páarira duujã́wã. ");
INSERT INTO tue_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Surara dutigʉ́ Pablo pʉtopʉ jea, surarare ñeeduti, pʉadá cõmedaména siatúdutiwi. Basocáre sãĩñáwĩ: —¿Noã niiĩ ãni? ¿Deero tiiárĩ? jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Basocápe ãpĩ merẽã, ãpẽrãcã́ merẽã noo booró acaribíãmajãwã. Teero tiigʉ́, surara dutigʉ́pe ãñurõ tʉobʉ́ariwi. Cʉ̃ʉ̃yara surarare néewadutiwi cʉ̃́ã niirí wiicapʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tiiwií mʉãwaropʉ jeari, basocá bayiró tuudiyówa. Teero tiirá, surara Pablore néeapa néecomʉãwã. ");
INSERT INTO tue_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Niipetira cʉ̃́ã siro tuudiyóatira: —Sĩãcõã́jãña, jĩĩ acaribíwa. ");
INSERT INTO tue_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tiiwiipʉ́ sõnecoadara tiirí, Pablo surara dutigʉ́re sãĩñáyigʉ: —Yʉʉ mʉʉmena wedeseri, ¿ãñuniãdari? jĩĩyigʉ. Cʉ̃ʉ̃rẽ yʉʉyigʉ: —¡Ayo! Mʉʉcã griegoayere wedesemasĩjããyo. ");
INSERT INTO tue_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Mʉʉ Egipto macʉ̃ ʉ̃sã romanuãrẽ cõãdʉgamirigʉ mee niiĩ? Cʉ̃ʉ̃ cuatro mil basocáre sĩãrépira dutigʉ́ niiyigʉ. Cʉ̃ʉ̃yarare néõ, basocá manirṍpʉ néewayigʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo yʉʉyigʉ: —Yʉʉ cʉ̃ʉ̃ mee niiã. Judíoayʉ niiã. Tarso Cilicia ditapʉ niirí macã macʉ̃ niiã. Bʉ́ri niirí macã macʉ̃ mee niiã. Yʉʉ ãniãrẽ wededʉgaga. Mʉʉ boorí, wedegʉda, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Surara dutigʉ́ “jáʉ” jĩĩyigʉ. Teero tiigʉ́, too mʉãwaropʉ nucũgʉ̃rã, wẽ́ẽtucowi. Cʉ̃́ã ditamanírĩ ĩña, hebreoayemena wedewi cʉ̃́ãrẽ: ");
INSERT INTO tue_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Yáa wedera, yʉʉ pacʉsʉ̃mʉã, yʉʉre tʉoyá ména. Yʉʉ mʉ́ãrẽ yée maquẽrẽ wedegʉda, mʉ́ã yʉʉre “wapa cʉoríi” jĩĩãrõ jĩĩgʉ̃, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Cʉ̃ʉ̃ hebreoayemena wederi tʉorá, nemorṍ ditamaníjõãwã. Pablo cʉ̃́ãrẽ jĩĩwĩ: ");
INSERT INTO tue_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Yʉʉ judíoayʉ niiã. Tarso Cilicia ditapʉ niirí macãpʉ bauáwʉ. Atimacãpʉ́ masãwʉ̃. Gamaliel yʉʉre buewi. Cʉ̃ʉ̃ Moisés marĩ ñecʉ̃sʉ̃mʉãrẽ dutiré niipetirere buepetijãwĩ yʉʉre. Mʉ́ã atitóre Cõãmacʉ̃ dutirére tiirécʉtirobirora yʉʉcã ãñurõ tiirucújãã. ");
INSERT INTO tue_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Yʉʉ tiibʉrecopʉ mama buerére padeoráre ñañarõ tiirucúwʉ. Sĩquẽrãrẽ sĩãdutíwʉ. Ʉ̃mʉã́, numiã́rẽ ñee, cʉ̃́ãrẽ peresuwiipʉ sõnecodutirucuwʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Paiaré dutigʉ́, niipetira Judíoare Dutirá Peti “teerora tiiwí” jĩĩ masĩcua. Cʉ̃́ãrã yʉʉre dutirépũrĩrẽ jóabosarira niiwã. Teepũrĩrẽ née, marĩya wedera Damascopʉ niirã́rẽ ticogʉdʉ tiimíwʉ̃. “Mama buerére padeoráre ñee, siatú, néewagʉda Jerusalénpʉ, cʉ̃́ãrẽ ñañarõ tiidutígʉdʉ”, jĩĩmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Maa wáagʉ, Damascopʉ jeagʉdʉ tiirí, coeritó niirĩ, wãcũña manirṍ ʉ̃mʉã́sepʉ bóediati yʉʉ pʉto bayiró capemórõ bóewʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Teero wáari, yʉʉ ditapʉ ñaacũmujõãwʉ̃. Sĩcʉ̃ yʉʉre wedeseri tʉowʉ́: “Saulo, ¿deero tiigʉ́ yʉʉre ñañarõ tiinʉnʉ́sei?” jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“¿Noã niiĩ mʉʉ?” jĩĩwʉ̃. “Yʉʉ Jesús Nazaret macã macʉ̃ mʉʉ ñañarõ tiinʉnʉ́segʉra niiã”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yʉʉmena wáariracã tee bóediatiriguere ĩña, “cuijõããwʉ̃” jĩĩwã. Cʉ̃ʉ̃ yʉʉmena wedeseriguere “tʉoríatʉ” jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yʉʉ cʉ̃ʉ̃rẽ sãĩñáwʉ̃: “Õpʉ̃, ¿deero tiirí boogári?” jĩĩwʉ̃. Cʉ̃ʉ̃ yʉʉre yʉʉwi: “Wʉ̃mʉnʉcãña. Damascopʉ wáaya. Toopʉ́ mʉʉrẽ sĩcʉ̃ wedegʉdaqui niipetire mʉʉ tiiádare Cõãmacʉ̃ quẽnorére”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Yʉʉmena wáarira yʉʉre tʉ̃ãwáta, Damascopʉ wáara. Yʉʉre asibatére capeari bauhéri tiiwʉ́. ");
INSERT INTO tue_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Tiimacãpʉre Ananías wãmecʉtigʉ niiwĩ. Cõãmacʉ̃rẽ quioníremena padeogʉ́, Moisére dutiré cṹũriguere tiigʉ́ niiwĩ. Niipetira judíoa tiimacã niirã́ cʉ̃ʉ̃rẽ “ãñuniĩ” jĩĩ ĩñawã. ");
INSERT INTO tue_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yʉʉre ĩñagʉ̃ jea, yʉʉ wesapʉ nucũ, yʉʉre jĩĩwĩ: “Yáa wedegʉ Saulo, ĩñamʉõcoya sũcã”, jĩĩwĩ. Wãcũña manirṍ cʉ̃ʉ̃rẽ ĩñamʉõcowʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yʉʉre jĩĩnemowĩ: “Tíatopʉ Cõãmacʉ̃ marĩ ñecʉ̃sʉ̃mʉã padeorígʉ mʉʉrẽ besetoayigʉ, cʉ̃ʉ̃ boorére mʉʉrẽ masĩãrõ jĩĩgʉ̃. Cʉ̃ʉ̃ macʉ̃ ãñugʉ̃́rẽ ĩña, cʉ̃ʉ̃ wedeserere tʉoáro jĩĩgʉ̃, beseyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mʉʉ cʉ̃ʉ̃yere wedegʉ wáagʉdacu. Niipetirare niipetiropʉ mʉʉ ĩñaãriguere, mʉʉ tʉoáriguere wedewarucugʉ wáagʉdacu. ");
INSERT INTO tue_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Teero tiigʉ́, yoari yuerijãña mʉʉ. Wʉ̃mʉnʉcãña. Marĩ Õpʉ̃rẽ padeojĩ́gʉ̃, mʉʉ ñañaré tiirére acabóre sãĩñá. Sãĩtóa, wãmeõtidutiya”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Too síro Jerusalénpʉ pʉtʉajeagʉ, Cõãmacʉ̃wiipʉ cʉ̃ʉ̃rẽ sãĩgʉ̃́ jeawʉ. Yʉʉ cʉ̃ʉ̃rẽ sãĩgʉ̃́ tiirí, cãnirípacʉ, quẽẽrṍpʉ tiiróbiro Jesuré ĩñawʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jesús yʉʉre jĩĩwĩ: “Boyero atimacã́ Jerusalénrẽ witiwaya. Ãno macãrã yée quetire mʉʉ wederi, booríadacua”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Yʉʉ cʉ̃ʉ̃rẽ jĩĩwʉ̃: “Õpʉ̃, cʉ̃́ã ãñurõ masĩcua: Niipetire judíoa cʉ̃́ã neãré wiseripʉ mʉʉrẽ padeoráre tãnadutí, peresuwiipʉ sõnecorucuwʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Esteban mʉʉye queti wederigʉre cʉ̃́ã sĩãrítore, yʉʉcã toopʉ́ra ĩñanucũwʉ̃. Cʉ̃ʉ̃rẽ sĩãrã́ye suti sotoá maquẽrẽ cotebosawʉ. ‘Ãñurõ tiirá sĩãã́ya’, jĩĩ wãcũmiwʉ̃”, jĩĩ wedemiwʉ̃ Jesuré. ");
INSERT INTO tue_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Cʉ̃ʉ̃ yʉʉre jĩĩwĩ: “Wáaya. Yʉʉ aperopʉ́ yoaropʉ ticocogʉdacu mʉʉrẽ judíoa niihẽrã pʉtopʉ”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nocõrõrã ãñurõ tʉotúwa. Teeré tʉorá, bayiró acaribíwa sũcã. —Cʉ̃ʉ̃rẽ sĩãcõã́jãña. Cʉ̃ʉ̃rẽ boorídojãã, jĩĩ acaribíwa. ");
INSERT INTO tue_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Acaribíra, cʉ̃́ã cúarere ẽñorã́, cʉ̃́ãye suti sotoá sãñarére tuuwé, wẽ́ẽtuwa. Dita maané, déebatecowa. ");
INSERT INTO tue_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Cʉ̃́ã teero tiirí ĩñagʉ̃, surara dutigʉ́ Pablore sõnecojãdutiyigʉ cʉ̃́ãya wii popeapʉ. Sõnecotoanʉcõ, Pablore “¿deero tiirá basocá mʉʉrẽ acaribíi?” jĩĩ wederi tiidʉgágʉ, cʉ̃ʉ̃rẽ tãnagʉ̃́dʉ siatúdutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Siatúari siro, Pablope cʉ̃ʉ̃ pʉto nucũgʉ̃́ cien surara dutigʉ́re jĩĩyigʉ: —Mʉ́ã yʉʉre bʉ́ri peti tãnamasĩ́ricu; romanuãrẽ dutiré teero tiidutíria. Yʉʉ romanuãyʉ niiã; queti beserí basoca yʉʉ tiiáriguere beseriya ména, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cʉ̃ʉ̃ teero jĩĩrĩ tʉogʉ́, cien surara dutigʉ́ cʉ̃ʉ̃rẽ dutigʉ́pʉre wedegʉ wáayigʉ. —Mʉʉ ãñurõ tiiyá. Jõõ niiãrigʉ “romanuãyʉ niiã” jĩĩãwĩ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Teeré tʉogʉ́, surara dutigʉ́ sãĩñágʉ̃ wáayigʉ: —¿Niirṍrã mʉʉ romanuãyʉ niiĩ? jĩĩyigʉ. —Ʉ̃́jʉ̃, cʉ̃ʉ̃rã́ niiã, jĩĩyigʉ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Surara dutigʉ́pe: —Yʉʉ pairó niyeru wapatíwʉ, romanuãyʉ niirére sããgʉ̃dʉ, jĩĩyigʉ. —Yʉʉja máata bauágʉpʉra romanuãyʉ niirigʉ niiwʉ̃, jĩĩyigʉ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Teeré tʉorá, cʉ̃ʉ̃rẽ tãnaã́dara tiimíãrira máata aperopé jeaconʉcãyira. Surara dutigʉ́cã cui niiyigʉ. “Romanuãyʉre ‘tãnañá’ jĩĩgʉ̃, siatúdutimiãyu” jĩĩ wãcũgʉ̃, cuijõãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Teero tiigʉ́, judíoa cʉ̃ʉ̃rẽ wedesãre diamacʉ̃́ maquẽrẽ masĩdʉgagʉ, apebʉ́recope paiaré dutiráre, teero biiri niipetira Judíoare Dutirá Petire néõyigʉ. Pablore jõãdutí, néediati, cʉ̃́ã ĩñacoropʉ nucũdutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo Judíoare Dutirá Petire ĩña, jĩĩyigʉ: —Yáa wedera, yʉʉ catiré bʉrecorire tée mecʉ̃ãpʉmena Cõãmacʉ̃ ĩñacoropʉ ãñurõ yeeripũnacʉtia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananías paiaré dutigʉ́ teeré tʉogʉ́, Pablo wesa nucũrã́rẽ ʉseropʉ páadutimiyigʉ cʉ̃ʉ̃ teero jĩĩré wapa. ");
INSERT INTO tue_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Teero tiigʉ́, Pablo cʉ̃ʉ̃rẽ jĩĩyigʉ: —Cõãmacʉ̃ mʉʉrẽ ñañarõ tiigʉ́daqui. Mʉʉ tiiditórepigʉ niiã. Mʉʉ too duia, yʉʉre queti besegʉdʉ Moisés dutiré jĩĩrõbirora. Mʉʉ basirora tee dutirére netõnʉcã́gʉ̃ tiia, yʉʉre páadutigʉpeja, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Too nucũrã́ cʉ̃ʉ̃rẽ jĩĩyira: —Biiro ñañarõ wedeserijãrõ booa paiaré dutigʉ́ Cõãmacʉ̃ cṹũrigʉre, jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo cʉ̃́ãrẽ jĩĩyigʉ: —Yáa wedera, cʉ̃ʉ̃ paiaré dutigʉ́ niirére yʉʉ masĩriatʉ. Cõãmacʉ̃ye queti jóaripũpʉ biiro jóare niiã: “Mʉ́ãya macã macãrãrẽ dutigʉ́re ñañarõ wedeserijãña”, jĩĩã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pablo too niirã́ saduceo basoca, ãpẽrã́ fariseo basoca niirĩ ĩñagʉ̃, bayiró bʉsʉrómena wedeseyigʉ: —Yáa wedera, yʉʉ fariseo basocʉra niiã yʉʉ pacʉsʉ̃mʉã tiiróbirora. Basocá diarira masãrére yʉʉ padeóa. Ate yʉʉ padeoré wapa mʉ́ã yʉʉre ãno queti beserópʉ néeatia, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Teeré tʉorá, fariseo basoca, saduceo basocamena bayiró cãmerĩ́ jĩĩyira. Teero tiirá, sĩcãrõména niimiãrira batajṍãyira. ");
INSERT INTO tue_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceo basoca diarirapʉ masãrére, teero biiri ángelea, wãtĩã niirére padeoríya. Fariseo basocape teeré padeoóya. ");
INSERT INTO tue_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Cʉ̃́ã bayiró acaribíyira. Teero tiirá, sĩquẽrã Moisés jóarigue buerá wʉ̃mʉnʉcãyira. Fariseo basoca niiyira. Bayiró cúasoremena wedemiyira: —Ãnirẽ́ wapa ñañaré bʉaría. Apetó tiigʉ́, ángele cʉ̃ʉ̃rẽ wedesejĩyi, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Cʉ̃́ã bayiró cãmerĩ́ jĩĩnemorĩ ĩñagʉ̃, surara dutigʉ́ Pablore wéetamʉtõrĩ jĩĩgʉ̃, cuiyigʉ. Teero tiigʉ́, Pablo cʉ̃́ã watoapʉ niigʉ̃́rẽ surarare néeatidutiyigʉ. Cʉ̃́ã niirí wiicapʉ néewadutiyigʉ sũcã. ");
INSERT INTO tue_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tiiñami Jesús Pablo pʉto bauá, jĩĩyigʉ: —Wãcũtutuaya. Atimacã́ Jerusalénpʉ yée quetire wedearirobirora Romapʉcãrẽ wedegʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Apebʉ́recope ãpẽrã́ judíoa yayióropʉ neã, “Pablore sĩãã́da” jĩĩmiyira. “Mecʉ̃ãmena yaari, sĩnirínʉcããda; Pablore sĩãtóarapʉ, yaaada. Cʉ̃ʉ̃rẽ sĩãríatã, Cõãmacʉ̃ marĩrẽ ñañarõ tiiáro”, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Teero wedesera cuarenta nemorṍ niiyira. ");
INSERT INTO tue_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Cʉ̃́ã paiaré dutirá, ãpẽrã́ bʉtoá dutirá pʉtopʉ wáa, cʉ̃́ãrẽ jĩĩyira: —Ʉ̃sã Cõãmacʉ̃ ĩñacoropʉ yaarinʉcããwʉ̃; Pablore sĩãã́dari sʉguero, yaaria. ");
INSERT INTO tue_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Teero tiirá, mʉ́ã, niipetira mʉ́ãmena dutirá surara dutigʉ́re queti ticocoya. Cʉ̃ʉ̃ Pablore néediatiaro. “Ʉ̃sã cʉ̃ʉ̃ tiiáriguere ãñurõ sãĩñádʉgaga”, jĩĩcoya. Pablo mʉ́ã pʉto jeaadari sʉguero, cʉ̃ʉ̃rẽ sĩãã́dara, cũmuãdacu, jĩĩmiyira. ");
INSERT INTO tue_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pablo bayio macʉ̃ cʉ̃́ã sĩãdʉgáre quetire tʉogʉ́, surara niirí wiicapʉ sããwa, Pablore queti wedeyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablope cʉ̃ʉ̃ wederi tʉogʉ́, sĩcʉ̃ cien surara dutigʉ́re atiduti, jĩĩyigʉ: —Ãnirẽ́ mʉʉ dutigʉ́ pʉtopʉ néewaya. Queti wedegʉdʉ tiiáyigʉ cʉ̃ʉ̃rẽ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Cʉ̃ʉ̃rẽ surara dutigʉ́ pʉtopʉ néewa, jĩĩyigʉ: —Pablo marĩ peresu cʉogʉ́ yʉʉre atiduti, ãnirẽ́ mʉʉ pʉtopʉ néeatidutiawĩ. Queti wedegʉdʉ tiiáyigʉ mʉʉrẽ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Surara dutigʉ́ mamʉrẽ wãmopʉ ñee, néewa, basocá tʉohéropʉ sãĩñáyigʉ: —¿Ñeenó queti wededʉgai yʉʉre? jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mamʉpe cʉ̃ʉ̃rẽ wedeyigʉ: —Judíoa mʉʉrẽ queti ticocoadacua. Niipetira “biiro tiiáda” jĩĩãyira. Pablore ñamigã Judíoare Dutirá Peti neãrṍpʉ néewadutiadacua mʉʉrẽ. “Cʉ̃ʉ̃ tiiáriguere ãñurõ sãĩñádʉgaga”, jĩĩditoadacua. ");
INSERT INTO tue_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Cʉ̃́ãrẽ tʉoríjãña. Cʉ̃́ã menamacãrã cuarenta nemorṍ ʉ̃mʉã́ cʉ̃ʉ̃rẽ duti, coteadacua. Cʉ̃́ã yaari, sĩniríadacua; cʉ̃ʉ̃rẽ sĩãtóarapʉ, yaaadacua. Cʉ̃́ã “marĩ teero tiiríatã, Cõãmacʉ̃ ñañarõ tiiáro” jĩĩãyira. Quẽnotóaayira cʉ̃́ã tiiádarere. Mecʉ̃tígã mʉʉ “jáʉ” jĩĩré dícʉre yuera tiicúa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Surara dutigʉ́pe jĩĩyigʉ: —Sĩcʉ̃norẽ “teeré cʉ̃ʉ̃rẽ wedeawʉ̃” jĩĩrijãña. Nocõrõrã niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Surara dutigʉ́ cien surara dutirá pʉarã́rẽ atiduti, wedeyigʉ: —Surarare quẽnodutíya. Cʉ̃́ã mecʉ̃ã ñami nueve niirĩ, wáaadacua Cesareapʉ. Doscientos surara dʉpomena wáaaro; setenta caballoamena pesawaaro; doscientos saderéyucʉre néewaaro. ");
INSERT INTO tue_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pablo cʉ̃ʉ̃ pesawaadara caballoacãrẽ quẽnoã́rõ. Apeyenó merẽã wáaro manirṍ Félix atiditá dutigʉ́pʉre néewaya, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Wedetoa, paperapũ jóayigʉ. Ate cʉ̃ʉ̃ jóarigue tiiróbiro niiã: ");
INSERT INTO tue_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Yʉʉ Claudio Lisias, mʉʉ Félix Judea dita dutigʉ́re ãñudutia. ");
INSERT INTO tue_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yʉʉ mʉʉrẽ ticocogʉre judíoa ñeejããwã. Cʉ̃ʉ̃rẽ sĩãã́dara tiimíãwã. Yʉʉ cʉ̃ʉ̃ romanuãyʉ niirére tʉogʉ́, suraramena cʉ̃ʉ̃rẽ netõnéãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","‘¿Ñeenó wapa cʉ̃ʉ̃rẽ wedesãĩ?’ jĩĩ masĩdʉgagʉ, Judíoare Dutirá Peti neãrṍpʉ cʉ̃ʉ̃rẽ néediwaawʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Judíoare dutiré maquẽ dícʉre ‘netõnʉcã́ãwĩ’ jĩĩ wedesããwã. Tee dícʉre cʉ̃ʉ̃rẽ wedesãrĩ, ñeenó wapa sĩãmasĩ́ña maniã́wʉ̃; cʉ̃ʉ̃ ñañarõ tiirípacari, peresuwiipʉ sõnecomasĩña maniã́wʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ãpẽrã́ judíoa ‘cʉ̃ʉ̃rẽ sĩãã́da’ jĩĩré queti yʉʉpʉre jeaawʉ̃. Teero tiigʉ́, máata mʉʉpʉre ticocoa. Cʉ̃ʉ̃rẽ ãnopʉ́ wedesããrirare mʉʉpʉre ‘wedesãrã wáaya’ jĩĩãwʉ̃. Nocõrõrã niiã”, jĩĩ jóayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tiiñami surara cʉ̃ʉ̃ dutiarirobirora Pablore néewa, néejeayira Antípatris macãpʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Apebʉ́recope surara dʉpomena wáarira toorá cãmecópʉtʉaatiyira cʉ̃́ãya wiicapʉra sũcã. Caballoamena wáarira dícʉ Pablomena netõwáyira. ");
INSERT INTO tue_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cʉ̃́ã Cesareapʉ jea, surara dutigʉ́ jóaripũrẽ ticoyira tiidita dutigʉ́re. Pablocãrẽ cʉ̃ʉ̃pʉre ticoyira. ");
INSERT INTO tue_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Cʉ̃ʉ̃ tiipũrẽ buetoa, Pablore sãĩñáyigʉ: —¿Noo macʉ̃pʉ niiĩ mʉʉ? jĩĩyigʉ. —Cilicia macʉ̃ niiã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","—Mʉʉrẽ wedesãrã ãnopʉ́ jeari, mʉʉrẽ tʉogʉ́da, jĩĩyigʉ. Teero jĩĩtoa, Pablore Herodeniiya wiicapʉ cotedutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sicamoquẽñe bʉrecori siro paiaré dutigʉ́ Ananías, sĩquẽrã bʉtoá dutirámena Cesareapʉ jeayira. Basocáre wedesãrirare wedesebosagʉ cʉ̃́ãmena jeayigʉ. Cʉ̃ʉ̃ wãmecʉtiyigʉ Tértulo. Félixpʉre Pablore wedesãyira. ");
INSERT INTO tue_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pablore néejeari, Tértulo cʉ̃ʉ̃rẽ wedesãnʉcãyigʉ: —Ʉ̃sãrẽ dutigʉ́, mʉʉ dutirémena ãñurõ niirecʉtia ʉ̃sã. Mʉʉ masĩrémenarã atiditá ãñurí dita wáaro tiia. ");
INSERT INTO tue_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Niipetiropʉ niipetire mʉʉ ʉ̃sãrẽ tiibosárere ʉseniremena ĩñaã. ");
INSERT INTO tue_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mʉʉrẽ páasʉtiri tiidʉgáriga. Teero tiigʉ́, péero wedesecogʉda. Ʉ̃sãrẽ péero tʉocójĩña ména. ");
INSERT INTO tue_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ʉ̃sã ĩñarĩ, ãni ñañoĩ. Niipetiropʉ judíoare sĩcãrõména niimirirare cãmerĩ́ batarí tiinetṍĩ. Nazaret macʉ̃ buerigue nʉnʉrã́rẽ sʉguegʉ́ niiĩ. ");
INSERT INTO tue_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Cõãmacʉ̃wiire ñañodʉgámiyigʉ. Teero tiirá, ʉ̃sã cʉ̃ʉ̃rẽ peresu ñeewʉ̃. Ʉ̃sã judíoare queti beserobirora cʉ̃ʉ̃rẽ queti besedʉgamiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ʉ̃sã teero tiiádara tiirí, Lisias surara dutigʉ́ ʉ̃sã pʉto sããati, tutuaromena cʉ̃ʉ̃rẽ néejõãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ʉ̃sã cʉ̃ʉ̃rẽ wedesãrere mʉʉpʉre wedesãdutiwi. Mʉʉ basiro cʉ̃ʉ̃rẽ sãĩñáte. Teero tiigʉ́, ate niipetire ʉ̃sã wedesãrere “niirṍrã niicu” jĩĩ masĩgʉ̃dacu mʉʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Judíoa “ʉ̃́jʉ̃, teerora wáawʉ” jĩĩnemocoyira. ");
INSERT INTO tue_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Félix Pablore ĩñayigʉ, wedeseya jĩĩgʉ̃. Pablo wedeseyigʉ: —Yʉʉ masĩã: Mʉʉ yoari atiditá macãrãrẽ queti beserí basocʉ niiã. Teero tiigʉ́, ʉseniremena mʉʉrẽ wedegʉda yée maquẽrẽ. ");
INSERT INTO tue_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Niipetire yʉʉ tiiríguere, mʉʉ sãĩñárĩ, paʉ basocá mʉʉrẽ wedemasĩcua. Doce bʉrecori netõã, yʉʉ Jerusalénpʉ jeari siro. Toopʉ́ Cõãmacʉ̃rẽ padeogʉ́ jeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ãniã yʉʉre ãpẽrãména cãmerĩ́ ñañarõ jĩĩrĩ bʉajeáriwa. Cõãmacʉ̃wiipʉ, ʉ̃sã neãré wiseripʉ, teero biiri macãpʉ yʉʉ basocáre cúari tiirí bʉajeáriwa. ");
INSERT INTO tue_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Cʉ̃́ã wedesãrere “biiro tiiáwĩ” jĩĩmasĩriya. ");
INSERT INTO tue_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yʉʉ tiirére wedegʉda. Mama bueré jĩĩrõbirora yʉʉ Cõãmacʉ̃ ʉ̃sã ñecʉ̃sʉ̃mʉã padeorígʉre padeóa. Ãniã mama buerére padeorí booríya. Yʉʉ doca niipetire Moisére dutiré cṹũriguere, teero biiri profetas jóariguere padeóa. ");
INSERT INTO tue_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Yʉʉ ãniã tiiróbirora Cõãmacʉ̃ tiiádarere yuea. Cʉ̃ʉ̃ basocá diarirapʉ masõgʉ̃daqui, ãñuré tiiráre, ñañaré tiiráre teerora. ");
INSERT INTO tue_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Teero tiigʉ́, yʉʉ masĩrõ jeatuaro wapa cʉohégʉ niidʉgaga, Cõãmacʉ̃ ĩñacoropʉ, basocá ĩñacoropʉ teerora. ");
INSERT INTO tue_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Yʉʉ peecʉ̃marĩ aperopʉ́ wáanetõãrigʉ Jerusalénpʉ jeawʉ sũcã. Judíoa bóaneõrãrẽ niyeru ticogʉ jeawʉ. Teero biiri Cõãmacʉ̃rẽ padeogʉ́ apeyenó ticogʉ jeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yʉʉ teeré tiigʉ́ tiirí, sĩquẽrã Asia macãrã judíoa yʉʉre bʉajeáwa Cõãmacʉ̃wiipʉ. Yʉʉpe too sʉgueropʉ Moisés cosedutírirobirora cosetóawʉ. Yʉʉre bʉarí, paʉ basocá maniwã́. Acaribíre maniwʉ̃́. ");
INSERT INTO tue_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Cʉ̃́ã yʉʉre bʉajeárira mʉʉpʉre atiro booa, yʉʉre wedesãdʉgaraja, yʉʉre wedesãre cʉorája. ");
INSERT INTO tue_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Cʉ̃́ã atiheri, ãniã wedearo. Yʉʉ Judíoare Dutirá Peti pʉtopʉ nucũrĩ, cʉ̃́ã ñañaré bʉaríguere wedesããrõ. ");
INSERT INTO tue_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ate docare yʉʉre wedesãmasĩya. Yʉʉ cʉ̃́ã pʉtopʉ niigʉ̃, bayiró bʉsʉrómena jĩĩwʉ̃: “Basocá diarira masãrére padeóa yʉʉ. Ate yʉʉ padeoré wapa mʉ́ã mecʉ̃ã yʉʉre ãno queti beserópʉ néeatia”, jĩĩwʉ̃, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Félix mama bueré maquẽrẽ ãñurõ masĩgʉ̃́ niijĩgʉ̃, cʉ̃́ãrẽ jĩĩyigʉ: —Nocõrõrã tʉogʉ́da. Lisias surara dutigʉ́ jearipʉ, mʉ́ã wedesãre maquẽrẽ nemorṍ ãñurõ sãĩñágʉ̃da, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Teero jĩĩtoa, cien surara dutigʉ́re jĩĩrigʉ niiwĩ: —Ãnirẽ́ ãñurõ cotedutiya. Cʉ̃ʉ̃ niirṍpʉ wáanetõ, niijããrõ. Cʉ̃ʉ̃ menamacãrã cʉ̃ʉ̃rẽ tiiápudʉgari, cãmotárijãña, jĩĩrigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pee bʉrecori wáaripacari, Félix, cʉ̃ʉ̃ nʉmo Drusilamena jeayigʉ sũcã. Coo judíoayo niiyigo. Pablore néeatidutiyigʉ. Jesucristore padeorére wederi, tʉoyígʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablo wedegʉ, jĩĩyigʉ: —Cõãmacʉ̃ marĩ ãñurõ tiirí booi. Marĩ ñañarére tiidʉgápacara, tiiríjãrõ booa. Atibʉ́reco petirí, Cõãmacʉ̃ wapa tiigʉ́daqui, jĩĩyigʉ. Félix teero jĩĩrĩ tʉogʉ́, cuijõãyigʉ. Pablore wáadutigʉ jĩĩyigʉ: —Apetó apeyenó tiiré manirĩ́, mʉʉrẽ atidutigʉda sũcã, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Naĩrõ Félix Pablore atiduti, cʉ̃ʉ̃mena wedeseyigʉ. “Cʉ̃ʉ̃ yʉʉre niyeru ticori boomíga, cʉ̃ʉ̃rẽ wionécogʉdʉ”, jĩĩ wãcũmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pʉacʉ̃má siro Félix dutigʉ́ niirére witijãyigʉ. Cʉ̃ʉ̃ wasoró sããgʉ̃́ wãmecʉtiyigʉ Porcio Festo. Félix judíoamena ãñurõ pʉtʉádʉgagʉ, Pablore toopʉ́ra cṹũjãyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo tiiditapʉ jeayigʉ, dutigʉ́ niiré sããgʉ̃ jeagʉ. Itiábʉreco siro Cesareapʉ niiãrigʉ Jerusalénpʉ wáayigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Toopʉ́ paiaré dutirá, ãpẽrã́ judíoa ʉpʉtí macãrã Pablore cʉ̃́ã wedesãriguere wedeyira cʉ̃ʉ̃rẽ sũcã. ");
INSERT INTO tue_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Cʉ̃ʉ̃rẽ tutuaremena sãĩyíra: —Ʉ̃sãrẽ tiiápuya. Pablore ãno Jerusalénpʉ néeatidutiya, jĩĩmiyira. Cʉ̃́ã cʉ̃ʉ̃rẽ maapʉ atigʉ́re sĩãã́darere quẽnorã́ tiimíyira. ");
INSERT INTO tue_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festo cʉ̃́ãrẽ jĩĩyigʉ: —Pablo Cesareapʉ cotenoqui. Yʉʉ máata pʉtʉawagʉda toopʉ́re. ");
INSERT INTO tue_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Teero tiirá, mʉ́ã menamacãrã teeré ãñurõ wedesemasĩrã yʉʉmena wáaaro. Cʉ̃ʉ̃ ñañaré tiigʉ́ niirĩ, toopʉ́ wedesããrõ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo pʉamóquẽñe bʉrecori dʉaró niiyigʉ toopʉ́re. Too síro pʉtʉajõãyigʉ Cesareapʉ. Cʉ̃ʉ̃ pʉtʉajeari bʉreco, apebʉ́recope queti beserí basocʉ duirópʉ dui, Pablore néeatidutiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pablo toopʉ́ sããjeari, judíoa Jerusalénpʉ atiarira cʉ̃ʉ̃ pʉtopʉ neãnʉcãyira. Pee ñañanetõjõãre cʉ̃ʉ̃rẽ wedesãmiyira. Cʉ̃́ã wedesãrere “diamacʉ̃́rã niiã” jĩĩ ẽñomasĩ́riyira. ");
INSERT INTO tue_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pablo “yʉʉ wapa cʉoría” jĩĩgʉ̃, wedeyigʉ: —Judíoa dutirére netõnʉcã́gʉ̃ mee niiã yʉʉ. Cõãmacʉ̃wiire ñañoríwʉ. Romanuã õpʉ̃rẽ netõnʉcã́riwʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festope judíoamena ãñurõ pʉtʉádʉgagʉ, Pablore sãĩñáyigʉ: —¿Jerusalénpʉ wáadʉgagari? Mʉʉ wáari, yʉʉ toopʉ́ mʉʉye maquẽrẽ besegʉdacu, jĩĩmiyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo cʉ̃ʉ̃rẽ yʉʉyigʉ: —Yʉʉ ãno romanuãrẽ queti beserópʉ nucũã. Ãnopʉ́ra yʉʉre besero booa. Mʉʉ ãñurõ masĩcu: Yʉʉ judíoare ñañarõ tiiríwʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yʉʉ ñañaré tiirígʉno niigʉ̃jã, “cʉ̃ʉ̃rẽ sĩãrṍ booa” jĩĩrĩ docare, “ãñurõ diagʉda” jĩĩjãbocu. Cʉ̃́ã wedesãre diamacʉ̃́ niihẽrĩrã, sĩcʉ̃nopera yʉʉre judíoapʉre ticomasĩrii. Teero tiigʉ́, romanuã õpʉ̃ yʉʉre besearo sáa, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festo cʉ̃ʉ̃rẽ tiiápuri basocamena wedesetoa, jĩĩyigʉ: —Mʉʉ romanuã õpʉ̃pʉre beseri booa. Too docare mʉʉ cʉ̃ʉ̃pʉre besedutigʉ wáagʉdacu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pee bʉrecori wáaripacari, tiidita õpʉ̃ Agripa, Berenicemena Cesareapʉ wáayigʉ Festore ãñudutigʉ wáagʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Cʉ̃́ã toopʉ́ peebʉrecori niirĩ, Festo Agripare wedeyigʉ Pabloye maquẽrẽ. —Félix peresu cṹũrigʉ sĩcʉ̃ niiĩ. ");
INSERT INTO tue_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yʉʉ Jerusalénpʉ niirĩ, paiaré dutirá, judíoa bʉtoá dutirá cʉ̃ʉ̃rẽ wedesãwã yʉʉpʉre. “Cʉ̃ʉ̃rẽ sĩãdutíya”, jĩĩmiwã. ");
INSERT INTO tue_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yʉʉ cʉ̃́ãrẽ yʉʉwʉ: “Ʉ̃sã romanuã teero peti ‘sĩãjã́ña’ jĩĩmasĩriga. Sĩcʉ̃ wedesãnorigʉ, cʉ̃ʉ̃rẽ wedesãriramena queti beserópʉ wedesesʉguero booa. Cʉ̃́ã wedesãrigʉre ‘wederijããrõ’ jĩĩrĩ, queti besemasĩña maniã”, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Teero tiigʉ́, cʉ̃́ã ãno jeari bʉreco apebʉ́recope pearó manirṍ yʉʉ queti beserí basoca duirópʉ duijĩgʉ̃, cʉ̃ʉ̃rẽ néeatidutiwʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","“Too nucũrã́ pee ñañaré cʉ̃ʉ̃rẽ wedesããdacua”, jĩĩ wãcũmiwʉ̃. Maniríro niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Cʉ̃́ã padeoré maquẽ dícʉre cʉ̃ʉ̃rẽ wedesãwã. Apeyé, sĩcʉ̃ Jesús wãmecʉtigʉ cʉ̃ʉ̃ diarigʉ niipacari, Pablope “catii” jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Yʉʉ ateré deero tii masĩhẽgʉ̃, Pablore sãĩñáwʉ̃: “¿Jerusalénpʉ wáadʉgagari? Mʉʉ wáari, toopʉ́ mʉʉye maquẽrẽ besenoãdacu”, jĩĩmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Cʉ̃ʉ̃pe “romanuã õpʉ̃ yʉʉre besearo” jĩĩwĩ. Teero tiigʉ́, cʉ̃ʉ̃rẽ ãnorã́ cṹũjãdutiwʉ sũcã, tée marĩ õpʉ̃pʉre ticocoripʉ, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa Festore jĩĩyigʉ: —Yʉʉcã cʉ̃ʉ̃ wedeseri tʉodʉgága, jĩĩyigʉ. —Jáʉ, ñamigã tʉogʉ́dacu, jĩĩyigʉ cʉ̃ʉ̃pe. ");
INSERT INTO tue_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Apebʉ́reco Agripa, Berenicemena cʉ̃́ã ãñuré õpãrã́ suti sãñarira niiwã. Basocá ĩñacoropʉ ãñurõ tiiẽ́ñowa, sããwawa neãrí tatiacapʉ. Surara dutirá, ʉpʉtí macãrã too macãrã cʉ̃́ãmena sããwawa. Cʉ̃́ã neãpetiri, Festo néeatidutiwi Pablore. ");
INSERT INTO tue_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Cʉ̃ʉ̃ sããjeari, Festo jĩĩwĩ: —Ʉ̃sã õpʉ̃ Agripa, mʉ́ã niipetira ʉ̃sãmena neãrã́ tʉoyá. Ãnirã́ niiĩ niipetira judíoa wedesãrigʉ. Jerusalén macãrã, teero biiri ãno macãrã yʉʉpʉre “sĩãrṍ booa” jĩĩ acaribíwa. ");
INSERT INTO tue_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Cʉ̃́ã teero jĩĩpacari, ñeenó wapa sĩãmasĩ́ña maniwʉ̃́, yʉʉ tʉgueñarĩ. Cʉ̃ʉ̃ basiro “romanuã õpʉ̃ yʉʉre besearo” jĩĩrĩ, “toopʉ́ra ticocogʉda” jĩĩwʉ̃ cʉ̃ʉ̃rẽ. ");
INSERT INTO tue_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Yʉʉ cʉ̃ʉ̃rẽ ticocogʉ, marĩ õpʉ̃rẽ ñeenó jóamasĩriga. Teero tiigʉ́, cʉ̃ʉ̃rẽ néeatidutiawʉ̃ mʉ́ã pʉtopʉ. Mʉʉrẽ tiigʉ́, néeatidutiawʉ̃, ʉ̃sã õpʉ̃ Agripa. Marĩ cʉ̃ʉ̃mena wedeseari siro, cʉ̃ʉ̃rẽ wedesãre maquẽrẽ ãñurõ jóabocu. ");
INSERT INTO tue_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Peresupʉ niigʉ̃́rẽ ticocogʉ, “ate wedesãwã cʉ̃ʉ̃rẽ” jĩĩ jóacoheri, ñañaniã, yʉʉ wãcũrĩ, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa Pablore jĩĩwĩ: —Mecʉ̃tígã yʉʉya mʉʉrẽ cʉ̃́ã wedesãrere, jĩĩwĩ. Pablo wedegʉda jĩĩgʉ̃, wãmorẽ wẽ́ẽtu, wedewi: ");
INSERT INTO tue_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Ʉ̃sã õpʉ̃ Agripa, mecʉ̃tígã mʉʉ yʉʉre wededutiri, ãñurõ ʉseniã. Teero tiigʉ́, judíoa yʉʉre wedesãre niipetirere mʉʉrẽ wedegʉda. ");
INSERT INTO tue_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mʉʉ judíoa niirecʉtirere, teero biiri ʉ̃sã sĩcãrĩbíro padeohérecãrẽ masĩpetijãgʉ̃ niirĩ, bayiró ʉseniã. Teero tiigʉ́, yʉʉre ãñurõ tʉocóduiya. ");
INSERT INTO tue_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Niipetira judíoa yáa dita macãrã, Jerusalén macãrã yʉʉ mamʉpʉra cʉ̃́ãmena niirecʉtiriguere masĩĩya. ");
INSERT INTO tue_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Cʉ̃́ãcã yʉʉ fariseo basocʉ niirére yoari masĩĩya. Fariseo basocʉ niijĩgʉ̃, ãpẽrã́ judíoa nemorṍ Moisés dutirére ãñurõ tiipetíjãwʉ̃. Cʉ̃́ã mʉʉrẽ wededʉgara, teeré wedemasĩya. ");
INSERT INTO tue_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Cõãmacʉ̃ ʉ̃sã ñecʉ̃sʉ̃mʉãrẽ cʉ̃ʉ̃ tiiádarere wedeyigʉ. Yʉʉ cʉ̃ʉ̃ tiiádarere padeoré wapa judíoa yʉʉre queti besedutiwa. ");
INSERT INTO tue_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Teeréna yuera tiia ʉ̃sã doce põnarĩ macãrã. Teero tiirá, bʉ́recori, ñamirĩ́ Cõãmacʉ̃rẽ padeorucújãã. Yʉʉcã teeré yuegʉ tiia. Ʉ̃sã õpʉ̃, tee yʉʉ yueré wapara judíoa yʉʉre wedesãrã tiiíya. ");
INSERT INTO tue_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mʉ́ãpe ¿deero tiirá Cõãmacʉ̃ basocá diarirapʉre masõrére padeoríi? ");
INSERT INTO tue_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Yʉʉja too sʉgueropʉ Jesús Nazaret macã macʉ̃rẽ padeoráre “ñañarõ tiiró boocú yʉʉre” jĩĩ wãcũmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jerusalénpʉ teero tiimíwʉ̃. Paiaré dutirá cʉ̃́ã dutiriguemena paʉ Jesuré padeoráre ñee, peresu tiirucúmiwʉ̃. Cʉ̃́ãrẽ sĩãrĩ́, “teerora sĩãrṍ booa” jĩĩrucumiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pee judíoa neãré wiseripʉ wáa, Jesuré padeodúaro jĩĩgʉ̃, ñañarõ tiirucúmiwʉ̃. Bayiró cʉ̃́ãmena cúagʉ, tée apeyé ditapʉ cʉ̃́ãrẽ ñañarõ tiinʉnʉ́semiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Teeré tiigʉ́, wáamiwʉ̃ Damascopʉre paiaré dutirá yʉʉre dutirépũrĩ jóabosariguemena. ");
INSERT INTO tue_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Maapʉ yʉʉ wáari, coeritó niirĩ, ʉ̃mʉã́sepʉ muĩpũ bʉ́reco macʉ̃ bóero nemorṍ bóediatiri ĩñawʉ̃. Yʉʉ pʉto yʉʉmena wáarira pʉtopʉcãrẽ bóesesajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Teero wáarira, ʉ̃sã niipetira ñaacũmujõãwʉ̃ ditapʉ. Sĩcʉ̃ yʉʉre hebreoayemena wedeseri tʉowʉ́: “Saulo, ¿deero tiigʉ́ yʉʉre ñañarõ tiinʉnʉ́sei? Mʉʉ basirope ñañarõ tiigʉ́ tiia, yʉʉre teero tiigʉ́”, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“¿Noã niiĩ mʉʉ?” jĩĩwʉ̃ cʉ̃ʉ̃rẽ. “Yʉʉ Jesús mʉʉ ñañarõ tiinʉnʉ́segʉra niiã. ");
INSERT INTO tue_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Wʉ̃mʉnʉcãña. Yʉʉ mʉʉrẽ ‘wedecotearo’ jĩĩgʉ̃, mʉʉrẽ bauáa. Mecʉ̃tígã mʉʉ ĩñarére, yʉʉ mʉʉrẽ too síropʉ bauáadarere wedegʉ wáagʉdacu. ");
INSERT INTO tue_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Judíoa, judíoa niihẽrã mʉʉrẽ ñañarõ tiirí, yʉʉ mʉʉrẽ netõnégʉ̃dacu. Mʉʉrẽ cʉ̃́ãpʉre ticocoa. ");
INSERT INTO tue_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mʉʉ yéere wedegʉ, cʉ̃́ã capearire ĩñapõrĩ tiigʉ́ tiiróbiro niigʉ̃dacu. Naĩtĩãrõpʉ tiiróbiro wáarare bóeropʉ wáari tiinʉcã́gʉ̃dacu mʉʉ. Cʉ̃́ã Satanás dutirére duujã́, Cõãmacʉ̃ dutirépere tiiáro jĩĩgʉ̃, mʉʉrẽ ticocoa yʉʉ. Cʉ̃́ã ñañaré tiirére acabóre ñeeãrõ jĩĩgʉ̃, ticocoa. Cʉ̃́ã yʉʉre padeorámena niiãrõ jĩĩgʉ̃, ticocoa”, jĩĩwĩ yʉʉre. ");
INSERT INTO tue_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Teero tiigʉ́, ʉ̃sã õpʉ̃ Agripa, ʉ̃mʉã́sepʉ dutirigue quẽẽrṍpʉ tiiróbiro yʉʉ tʉoríguere netõnʉcã́riwʉ. ");
INSERT INTO tue_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Wedenʉcãwʉ̃ Damasco macãrãrẽ. Too síro Jerusalén macãrãrẽ, niipetiro Judea dita macãrãrẽ, teero biiri judíoa niihẽrãcãrẽ wedewʉ. Cʉ̃́ãrẽ “mʉ́ã ñañaré tiirére wãcũpati, wasoyá” jĩĩwʉ̃. “Cõãmacʉ̃rẽ padeonʉcã́ña”, jĩĩwʉ̃. “Mʉ́ã ãñuré tiirémena mʉ́ã wasorére ẽñoñá”, jĩĩwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yʉʉ teeré wederé wapa judíoa Cõãmacʉ̃wiipʉ yʉʉ niigʉ̃́rẽ ñee, sĩãdʉgámiwã. ");
INSERT INTO tue_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Cʉ̃́ã teero tiidʉgápacari, Cõãmacʉ̃pe yʉʉre tiiápurucujãĩ. Teero tiigʉ́, yʉʉ atitóre ʉpʉtí macãrãrẽ, ãpẽrã́ bʉ́ri niirã́cãrẽ Cõãmacʉ̃ye quetire wedea. Tíatopʉ Moisés, ãpẽrã́ profetas síropʉ wáaadarere jóarira niiwã. Cʉ̃́ã jĩĩrirobirora yʉʉ wedea: ");
INSERT INTO tue_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","“Cristo Cõãmacʉ̃ beserigʉre ñañarõ netõã́daro niirõ tiiyíro. Diatoa, cʉ̃ʉ̃rã́ diarigʉpʉ masãsʉguegʉdaqui. Teero tiigʉ́, cʉ̃ʉ̃ netõnére maquẽrẽ wedegʉdaqui judíoare, judíoa niihẽrãrẽ”, jĩĩ jóarira niiwã, jĩĩ wedewi Pablo. ");
INSERT INTO tue_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Cʉ̃ʉ̃ teero jĩĩrĩrã, Festo bayiró wedeseremena jĩĩwĩ: —Pablo, mʉʉ mecʉ̃gʉ̃́ tiia. Mʉʉ basiro pee buenetõjĩgʉ̃, mecʉ̃gʉ̃́ tiia, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pablope jĩĩyigʉ: —Ʉ̃sãrẽ dutigʉ́ Festo, yʉʉ mecʉ̃gʉ̃́ mee tiia. Yʉʉ wederé diamacʉ̃́rã niiã. Quioníremena wedea. ");
INSERT INTO tue_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Marĩ õpʉ̃ Agripa tee maquẽrẽ ãñurõ masĩqui. Teero tiigʉ́, cuiro manirṍ wedea cʉ̃ʉ̃rẽ. Ate yʉʉ wedeariguere tʉopetíjãjĩyi. Yayióropʉ wáariyiro. ");
INSERT INTO tue_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mʉʉte ʉ̃sã õpʉ̃ Agripa, ¿mʉʉ profetas jóariguere padeói? Yʉʉ masĩã: Mʉʉ padeocú, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","—¡Nocõrõgã wedepacʉ, yʉʉre Jesuré padeogʉ́ wáari tiidʉgácu! jĩĩwĩ Agripa Pablore. ");
INSERT INTO tue_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","—Cõãmacʉ̃ boorí, péerogã o pairó wedepacʉ, teeré padeogʉ́ wáari tiidʉgága. Mʉʉ, teero biiri niipetira yʉʉre mecʉ̃ã tʉorá yʉʉ tiiróbiro niirĩ boogá. Peresu niiré dícʉre mʉ́ãrẽ boosã́riga, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Agripa, Festo wʉ̃mʉnʉcãrĩ, Berenice, cʉ̃́ãmena duirácã wʉ̃mʉnʉcãwã. ");
INSERT INTO tue_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Witiwa, cãmerĩ́ wedeseyira: —Ĩ́ni cʉ̃ʉ̃ tiirémena peresu tiimasĩ́ña maniã. Teero tiirá, ¿ñeenó wapa cʉ̃ʉ̃rẽ sĩãbógari? jĩĩyira. ");
INSERT INTO tue_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa Festore jĩĩyigʉ: —Ĩ́ni “romanuã õpʉ̃ yʉʉre besearo” jĩĩriatã, cʉ̃ʉ̃rẽ wionécoboajĩyu, jĩĩyigʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Festo Italiapʉ ticocomasĩrĩ ĩñagʉ̃, Pablore, teero biiri ãpẽrã́ peresu niirã́rẽ Julio cien surara dutigʉ́re cotedutiwi. Julio romanuã õpʉ̃ya põna macãrã surara dutigʉ́ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ʉ̃sã Adramitio macãwʉ dooríwʉpʉ mʉãsãwʉ̃. Tiiwʉ́ Asia dita maquẽ petaripʉ wáaadaro tiiwʉ́. Sĩcʉ̃ Tesalónica macã macʉ̃ ʉ̃sãmena wáawi. Cʉ̃ʉ̃ wãmecʉtiwi Aristarco. Cʉ̃ʉ̃ya macã Macedonia ditapʉ niiyiro. ");
INSERT INTO tue_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Apebʉ́reco Sidónpʉre jeawʉ. Julio Pablore ãñurõ tiiwí; cʉ̃ʉ̃rẽ cʉ̃ʉ̃ menamacãrã niirira pʉtopʉ ĩñagʉ̃ wáadutiwi, cʉ̃ʉ̃ boorénorẽ “ticoaro” jĩĩgʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Too niiãrira tiiwʉména wáawʉ sũcã. Wĩno ʉ̃sã díamacʉ̃pe bayiró páapuwʉ. Teero tiirá, Chipre nʉcʉ̃rõrẽ diamacʉ̃́pe netõwáwʉ. Toopé wĩno páapubayiriwʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilicia, Panfilia dita netõwá, Mirapʉ jeawʉ Licia ditapʉre. ");
INSERT INTO tue_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Toopʉ́ cien surara dutigʉ́ Italiapʉ wáaadariwʉre bʉajeárigʉ niiwĩ. Alejandría macãwʉ niiwʉ̃. Ʉ̃sãrẽ tiiwʉpʉ́ cṹũwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wáa, peebʉrecori ãñurõgã wáawʉ. Bayiró ñañarõ netõrémena jeawʉ Gnido macã díamacʉ̃pʉre. Wĩno bayiró páapucãmotawʉ ména. Teero tiirá, Creta nʉcʉ̃rõpʉre wáa, Salmónrẽ netõwá, Creta acuniñape sodeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bayiró ñañarõ netõrémena sicapeta Ãñurí Peta wãmecʉtiri petapʉ jeawʉ. Tiipeta Lasea macã pʉto niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ʉ̃sã yoari pearémena péerogã dʉsawʉ́ púuriro, wĩno bayiró páapure wáaadari sʉguero. Teero tiiró, bayiró quiowʉ́, wáari. Teeré masĩgʉ̃, Pablo cʉ̃́ãrẽ wedemiwĩ: ");
INSERT INTO tue_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Marĩ netõwári, quio niiãdacu, yʉʉ tʉgueñarĩ. Mʉ́ã néeware, mʉ́ãyawʉ, marĩ catirécãrẽ tiidióbocu, jĩĩmiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Cʉ̃ʉ̃ teero jĩĩpacari, cien surara dutigʉ́ Pablo wedeariguere padeoríwi. Tiiwʉ́ waatúgʉ, tiiwʉ́ dutigʉ́pere padeowí. ");
INSERT INTO tue_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tiipetape púuriro niirĩ, ñañaniyiro. Teero tiirá, paʉ tiiwʉ́ macãrã “Fenicepʉ wáañaãda, púuriro netõã́da jĩĩrã” jĩĩmiwã. Fenice macã peta Cretapʉ niiyiro. Tiipeta muĩpũ sããwaro niirí peta niijĩrõ, wĩno bayiró páapuriyiro. ");
INSERT INTO tue_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Wĩno aperopé péero páapuatiri, “jãmʉ, jeajõããdacu” jĩĩmiwã. Teero tiirá, tiiwʉpʉ́ mʉãsã, Creta wesagãpʉ wáamiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ʉ̃sã péerogã wáaari siro, wãcũña manirṍ wĩno bayiró tiinʉcʉ̃rõ pʉtope páapuatiwʉ, Nordeste cʉ̃́ã jĩĩré. ");
INSERT INTO tue_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wĩno ʉ̃sãrẽ aperopé néejõãwʉ̃. Wĩno atirópe deero tii ʉ̃sã wáamasĩriwʉ. Teero tiirá, “teerora too wáajõããrõ” jĩĩ, wĩno noo páapucorope wáajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cauda nʉcʉ̃rõpʉ netõwáwʉ. Tiinʉcʉ̃rõ apeniñapé wáari, wĩno bayiró jeariwʉ. Toopʉ́ yucusóro cʉ̃́ã siatú wéeriwʉre bayiró paderémena wéecowʉ pairíwʉ wesapʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wéemʉõcotoa, siatúpeowʉ. Ʉ̃sã wáariwʉcare watirí jĩĩrã, cʉ̃́ã pũũgʉ̃dʉpórimena siatúdiyowa. Sirte ditatupari niirṍcapʉ páapucori jĩĩrã, cui niiwã. Teero tiirá, wĩno ñeeré caserire jõãdíocowa. Cʉ̃́ã jõãã́ri siro, wĩno páapucorope wáawʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Apebʉ́reco oco pea, páapu, ocoturí paca niirĩ ĩñarã, apeyé cõãdʉowa. ");
INSERT INTO tue_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Itiábʉreco wáaromena, cʉ̃́ã basiro tiiwʉ́ maquẽrẽ cõãdʉowa sũcã. ");
INSERT INTO tue_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Pee bʉrecori muĩpũ bʉ́reco macʉ̃, ñocõã́ bauríwa. Oco pea, teerora páapujãwʉ̃. Teero tiirá, “deero tii marĩ catiricu” jĩĩ wãcũmiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Yoari yaaheri ĩñagʉ̃, Pablo cʉ̃́ã decopʉ jeanʉcã, jĩĩwĩ: —Yʉʉ menamacãrã, mʉ́ã yʉʉre tʉoátã, ãñuniboajĩyu; Cretare witiriboajĩyu; dooríwʉ maquẽrẽ ñañoríboajĩyu; marĩ cõããriguere cʉobóajĩyu ména. ");
INSERT INTO tue_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Marĩrẽ teero wáapacari, wãcũtutuaya. Sĩcʉ̃ diaricu. Atiwʉ́ dícʉre tiidióadacu. ");
INSERT INTO tue_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Yʉʉ Cõãmacʉ̃rẽ padeogʉ́ niiã. Cʉ̃ʉ̃ dutirére tiia. Cʉ̃ʉ̃ ñami yʉʉ pʉtopʉ ángelere ticocoarigʉ niiãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ángele yʉʉre wedeawĩ: “Pablo, cuirijãña. Mʉʉrẽ romanuã õpʉ̃ pʉtopʉ jearo booa. Mʉʉrẽ tiigʉ́, Cõãmacʉ̃ mʉʉ menamacãrãrẽ netõnégʉ̃daqui sĩcʉ̃ diaro manirṍ”, jĩĩãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Teero tiirá, mʉ́ã wãcũtutuaya. Yʉʉ Cõãmacʉ̃rẽ padeóa. Cʉ̃ʉ̃ yʉʉre jĩĩãrirobirora wáaadacu. ");
INSERT INTO tue_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Teero ãñurõ wáapacari, atiwʉ́ nʉcʉ̃rṍpʉ súuñacũmuãdacu, jĩĩwĩ Pablo. ");
INSERT INTO tue_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pʉa semana ʉ̃sã Cretare witiwari siro, pairímaa Adriáticopʉ wĩno bayiró páapucoremena wáawʉ. Ñami deco tiiwʉ́ macãrã paderá “marĩ dita pʉtopʉ jeara tiitú niiã” jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Cʉ̃́ã ¿nocõrõ ʉ̃cʉ̃ãmiĩ? jĩĩrã, opada cãnotí, duudíoco, queoñáwã. “Treinta y seis metros ʉ̃cʉ̃ãã”, jĩĩ ĩñawã. Péero wáa, queoñáwã sũcã. “Veintisiete metros ʉ̃cʉ̃ãã”, jĩĩwã sáa. ");
INSERT INTO tue_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ʉ̃tãpapʉ́ ñaapeari jĩĩ, cuiwa. Teero tiirá, bapari cõmepĩ́rĩ teeyapupʉ siatúredarimena cõãñowã, waatúrope wéeñepasoaro jĩĩrã. “Boyero bóeri boomíga”, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tiiwʉ́ macãrã paderá dutijṍãdʉgamiwã. “Ʉ̃sã cõmepĩ́rĩrẽ waasʉguérope cõãñoãdara tiia”, jĩĩdito, péeriwʉgãrẽ néediocora tiimíwã díapʉ. ");
INSERT INTO tue_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pablope cien surara dutigʉ́re, suraracãrẽ jĩĩwĩ: —Ãniã atiwʉpʉ́ pʉtʉáheri, mʉ́ã sĩcʉ̃ catiricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Teero tiirá, surarape wéeñeredarire páata, tiiwʉ́gãrẽ ñaañorĩ tiiwá. ");
INSERT INTO tue_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bóeadari sʉguero, Pablo ʉ̃sãrẽ “yaaya” jĩĩgʉ̃, niipetirare jĩĩwĩ: —Pʉa semana netõã, mʉ́ã ãñurõ yaaripacara, “¿deero wáaadari marĩ?” jĩĩcotero. ");
INSERT INTO tue_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Teero tiirá, mʉ́ã ãñurõ niiãda jĩĩrã, yaaro booa. Mecʉ̃tígã marĩrẽ ñañarõ wáapacari, mʉ́ãrẽ merẽã wáaricu, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Teeré jĩĩ, pãrẽ née, niipetira ĩñacoropʉ Cõãmacʉ̃rẽ ʉsenire tico, pãrẽ pʉatá, yaanʉcãwĩ. ");
INSERT INTO tue_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wãcũtutua, cʉ̃́ãcã yaawa. ");
INSERT INTO tue_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ʉ̃sã niipetira tiiwʉpʉ́ niirã́ doscientos setenta y seis niiwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Cʉ̃́ã yaadʉgarere yaaari siro, trigoporire cõãñojãwã, tiiwʉ́ nʉcʉ̃hẽriwʉ pʉtʉáaro jĩĩrã. ");
INSERT INTO tue_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bóecũmurĩ, ditare ĩñarã, “¿Noopʉ́ niiĩ?” jĩĩmasĩriwa. Opacoca ditatuparigʉ niirṍrẽ ĩñawã. —Toopʉ́ wáaada; ditatuparigʉpʉ súumacũmubocu, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Teero tiirá, cõmepĩ́rĩrẽ cõõtẽ́rĩjããrõ jĩĩrã, wéeñeãredarire widetácodiocowa. Waarípĩrĩ waatúgʉ waatúrepĩrĩrẽ jõãdíocowa. Waasʉguéro niirí caserore wéemʉõtucowa, wĩno néewaaro jĩĩrã. Teero tiirá, tiiwʉré ditatuparipʉ ticocomiwã. ");
INSERT INTO tue_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Wáa, wãcũña manirṍ ditatupari buro oco watoa niirí buropʉ sʉgacopeawʉ waasʉguérope. Cãmeñariwʉ. Waatúrope ocoturí páapusãcori, watijṍãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Teero wáari ĩñarã, surara jĩĩwã: —Jãmʉ, marĩ peresu tiiráre sĩãjã́co; cʉ̃́ã báapã dutijṍãbocua, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Cien surara dutigʉ́pe “Pablore sĩãbócua” jĩĩgʉ̃, cãmotáwi. Báamasĩrãrẽ: —Ñaañuãsʉgue, ditapʉ báapãña, jĩĩwĩ—. ");
INSERT INTO tue_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ãpẽrã́ táboapĩrĩmena, tiiwʉ́ maquẽ watiárepĩrĩmena pasapãwaya, jĩĩwĩ. Teero tiirá, ditapʉ jea, niipetira netõpetíjãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ʉ̃sã ditapʉ jeapetira, tʉowʉ́: Tiinʉcʉ̃rõ Malta wãmecʉtiwʉ. ");
INSERT INTO tue_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Too macãrã basoca ãñurõ tiiwá ʉ̃sãrẽ. Oco pea, yʉsʉári ĩñarã, pecame diobosáwa. —Sũmarã́ atiya mʉ́ã niipetira, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pablo peca seegʉ́ wáa, néeati, cʉ̃ʉ̃ wã́ãtĩãrĩ, ãña tiidotopʉ niiãrigʉ asiré cuigʉ, witiwi. Pabloya wãmopʉ bacañáñumuwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tiinʉcʉ̃rõ macãrã ãña cʉ̃ʉ̃ya wãmopʉre tusari ĩñarã, cãmerĩ́ jĩĩwã: “Ãni basocá sĩãrígʉ niiqui. Cʉ̃ʉ̃ día pairímaapʉ netõã́rigʉ niipacʉ, cʉ̃ʉ̃ ñañaré tiiré wapa diagʉdaqui”, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Cʉ̃ʉ̃pe pecamepʉ wẽ́ẽbatesoewi ãñarẽ. Pũniriwi cʉ̃ʉ̃rẽ. ");
INSERT INTO tue_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Too macãrãpe wãcũmiyira: “Bipijṍããdacu. Bipiríatã, wãcũña manirṍ ñaacũmu, diajõãgʉ̃daqui”, jĩĩmiyira. Cʉ̃́ã yoari yuemi, cʉ̃ʉ̃rẽ merẽã wáaheri ĩña, merẽã wãcũyira sũcã. “Ãni basocʉ́ mee niiqui; sĩcʉ̃ basocá padeogʉ́ niigʉ̃ niiãti”, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Too pʉtogã tiinʉcʉ̃rõ macãrã dutigʉ́ya dita niiwʉ̃. Cʉ̃ʉ̃ wãmecʉtiyigʉ Publio. Cʉ̃ʉ̃ ʉ̃sãrẽ bocawi. Itiábʉreco ʉ̃sã cʉ̃ʉ̃ pʉto niirĩ, ãñurõ tiiwí. ");
INSERT INTO tue_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publio pacʉ wioré, yoopote diagʉ pesawi. Pablo cʉ̃ʉ̃ niirṍpʉ sããwa, Cõãmacʉ̃rẽ sãĩbosá, cʉ̃ʉ̃rẽ ñaapeó, netõnéwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Cʉ̃ʉ̃ teero tiirí ĩñarã, ãpẽrã́ tiinʉcʉ̃rõ macãrãcã diará atirucuwa. Netõnénowã. ");
INSERT INTO tue_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ʉ̃sãrẽ pee apeyenó ticowa. Too síro ʉ̃sã wáaadara tiirí, ʉ̃sãrẽ dʉsarécõrõ ticowa. ");
INSERT INTO tue_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ĩtĩã́rã muĩpũrã niiwʉ̃ ʉ̃sã toopʉ́re. Alejandría macã macãwʉ tée púuriro wáapetiripʉ niiwʉ̃ tiinʉcʉ̃rõpʉre. Tiiwʉ́ ẽquẽãpʉ cʉ̃́ã padeorá Cástor, Pólux queoré cʉ̃́ã páateture tusawʉ. Ʉ̃sã tiiwʉpʉ́ mʉãsã, wáajõãwʉ̃. ");
INSERT INTO tue_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wáa, Siracusa macã petapʉ jeawʉ. Toopʉ́ itiábʉreco pʉtʉáwʉ. ");
INSERT INTO tue_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Too macãrã tiinʉcʉ̃rõ wesa wáa, Regio macãpʉ jeawʉ. Sicabʉreco siro ʉ̃sã sirope wĩno páapuatiwʉ. Pʉabʉ́reco siro Puteoli macãpʉ jeawʉ. ");
INSERT INTO tue_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Toopʉ́re ãpẽrã́ Jesuré padeoráre bʉajeáwʉ. Cʉ̃́ã ʉ̃sãrẽ: —Sica semana ʉ̃sã pʉto pʉtʉáya, jĩĩwã. Too pʉtʉáari siro, maapʉ wáa, Romapʉ jeawʉ sáa. ");
INSERT INTO tue_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ãpẽrã́ Roma macãrã Jesuré padeorá ʉ̃sã Romapʉ wáare quetire tʉotóayira. Teeré tʉo, tée Foro de Apio macãpʉ ʉ̃sãrẽ bocara jeawa. Ãpẽrãcã́ Tres Tabernas wãmecʉtiropʉ ʉ̃sãrẽ bocawa. Pablo cʉ̃́ãrẽ ĩñagʉ̃, Cõãmacʉ̃rẽ ʉsenire tico, wãcũtutuare bʉanemówĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ʉ̃sã Romapʉ jeari, too macãrã dutirá jĩĩwã: —Pablo merẽã niidʉgari, ãñuniãdacu. Cʉ̃ʉ̃mena surara sĩcʉ̃ cʉ̃ʉ̃rẽ cotegʉdʉre cṹũwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Itiábʉreco siro Pablo judíoa ʉpʉtí macãrãrẽ neãdutiwi. Cʉ̃́ã neãtoari, jĩĩwĩ: —Yáa wedera, yʉʉ marĩya wederare, marĩ ñecʉ̃sʉ̃mʉã tiirécʉtiriguere netõnʉcã́riwʉ. Netõnʉcã́ripacari, Jerusalénpʉ judíoa yʉʉre ñee, romanuãrẽ dutirápʉre tico, yʉʉre peresu tiidutíwa. ");
INSERT INTO tue_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romanuãrẽ dutirá yʉʉre sãĩñápeti, sĩãrĩ́ tiiréno wapa bʉaríwa. Wionécodʉgamiwã. ");
INSERT INTO tue_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Judíoape booríwa. Teero tiigʉ́, yʉʉ “romanuã õpʉ̃ yʉʉre queti besearo” jĩĩwʉ̃. Yʉʉpe yáa wederare wedesãre cʉoríwʉ. ");
INSERT INTO tue_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Teero tiigʉ́, mʉ́ãrẽ ĩña, wedesegʉda jĩĩgʉ̃, boocóawʉ̃. Cõãmacʉ̃ beserigʉ marĩ Israelya põna macãrã yoari yuerigʉyere yʉʉ wederé wapa atidá cõmedá siatúarigʉ niiã, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Cʉ̃́ã cʉ̃ʉ̃rẽ jĩĩwã: —Ʉ̃sã sicapũ Judea macãrã mʉʉye maquẽrẽ cʉ̃́ã jóaripũrẽ ñeeriwʉ. Teero biiri too macãrã marĩya wedera ãnopʉ́ jeara, ñañarõ wedeseriwa mʉʉrẽ. ");
INSERT INTO tue_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ʉ̃sã masĩã: Niipetiropʉre mama buerére “ñañaniã” jĩĩcua. Ʉ̃sã mʉʉ padeorére tʉodʉgága, jĩĩwã. ");
INSERT INTO tue_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Cʉ̃́ã neããdari bʉrecore wedecũjã, wáajõãwã. Tiibʉreco niirĩ, paʉ basocá cʉ̃ʉ̃ niirí wiipʉ jeawa. Bóeri wedenʉcãrigʉ wedenañiõjõãwĩ. Cõãmacʉ̃ dutiré basocápʉre niiãdare jeariguere wedewi. Moisére dutiré cṹũriguemena, profetas jóariguemena wedeyapono, “Jesús Cõãmacʉ̃ beserigʉ niiĩ” jĩĩ padeorí tiijã́dʉgagʉ tiimíwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sĩquẽrã Pablo wederére tʉorá “niirṍrã niiã” jĩĩwã. Ãpẽrãpé padeoríwa. ");
INSERT INTO tue_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Cãmerĩ́ wedesetoa, sĩcãrĩbíro wãcũri, wáajõãwã. Cʉ̃́ã wáaadari sʉguerogã, Pablo jĩĩwĩ: —Profeta Isaías mʉ́ã ñecʉ̃sʉ̃mʉãrẽ jóariguere tʉoyá. Diamacʉ̃́ maquẽrẽ Espíritu Santo biiro cʉ̃ʉ̃rẽ jóari tiirígʉ niiwĩ: ");
INSERT INTO tue_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Basocáre wedegʉ wáaya: “Mʉ́ã tʉopacára, tʉomasĩ́riadacu; ĩñapacara, ĩñamasĩriadacu”, jĩĩña cʉ̃́ãrẽ. ");
INSERT INTO tue_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Cʉ̃́ãpe ãñurõ wãcũdʉgaricua; tʉodʉgáricua; ĩñadʉgaricua. Cʉ̃́ã ãñurõ tʉo, ãñurõ ĩña, wãcũré wasoátã, yʉʉ cʉ̃́ãrẽ netõnéboajĩyu, jĩĩ wedeya, jĩĩ jóarigʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Teero tiirá, ãñurõ masĩña mʉ́ã: Cõãmacʉ̃ cʉ̃ʉ̃ basocáre netõnére quetire judíoa niihẽrãrẽ wedenoãdacu. Cʉ̃́ãpe tʉoádacua, jĩĩwĩ. ");
INSERT INTO tue_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Cʉ̃ʉ̃ teero jĩĩãri siro, judíoa cʉ̃́ã basiro bayiró cãmerĩ́ wedeseco, witiwawa. ");
INSERT INTO tue_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pʉacʉ̃má Pablo cʉ̃́ã waso, wapatídutiri wiipʉ niiwĩ. Toopʉ́ cʉ̃ʉ̃rẽ ĩñarã jearáre ʉseniremena bocarucuwi. ");
INSERT INTO tue_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Cuiro manirṍ Cõãmacʉ̃ dutiré basocápʉre niiãdare jeariguere, teero biiri marĩ Õpʉ̃ Jesucristoyere wederucujãwĩ ãpẽrã́ cãmotáro manirṍ.");
INSERT INTO tue_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yʉʉ Pablo, Jesucristore padecotegʉ, cʉ̃ʉ̃yere wededutigʉ beserigʉ niiã. Cʉ̃ʉ̃ yʉʉre Cõãmacʉ̃ netõnére quetire wededutigʉ boorígʉ niiwĩ. ");
INSERT INTO tue_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Profetamenapʉra “netõnére quetire ticogʉda” jĩĩ wedesʉguetoarigʉ niiwĩ. Tee maquẽrẽ marĩ buea Cõãmacʉ̃ye queti jóaripũpʉ. ");
INSERT INTO tue_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tee queti Cõãmacʉ̃ macʉ̃ye maquẽrẽ wedea. Cʉ̃ʉ̃ marĩ tiiróbiro biigʉ́, õpʉ̃ David pãrãmi niinʉnʉsegʉ niiyigʉ. ");
INSERT INTO tue_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ñañaré tiihégʉ niiyigʉ. Cʉ̃ʉ̃ diari siro, Cõãmacʉ̃ cʉ̃ʉ̃rẽ masõyigʉ. Teero cʉ̃ʉ̃ masõriguemena Cõãmacʉ̃ basocáre “yʉʉ macʉ̃ niiĩ” jĩĩriguere tutuaremena ẽñoyígʉ. Cʉ̃ʉ̃ macʉ̃ marĩ Õpʉ̃ Jesucristo niiĩ. ");
INSERT INTO tue_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesús yʉʉre ãñuré ticorigʉ niiwĩ. Yʉʉre cʉ̃ʉ̃yere wededutigʉ besewi. Niipetiropʉ basocá Jesuré padeoáro jĩĩgʉ̃, cʉ̃ʉ̃ dutirére tiiáro jĩĩgʉ̃, yʉʉ cʉ̃ʉ̃ye quetire wedebatea. Niipetira Jesuré maĩã́rõ cʉ̃́ãcã jĩĩgʉ̃, wedebatea. ");
INSERT INTO tue_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Cõãmacʉ̃ mʉ́ãcãrẽ boorígʉ niiwĩ Jesucristomena niiãdarare. ");
INSERT INTO tue_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mʉ́ã Cõãmacʉ̃ maĩrã́rã niiã. Mʉ́ãrẽ beserigʉ niiwĩ cʉ̃ʉ̃ põna niiãdarare. Teero tiigʉ́, yʉʉ niipetira mʉ́ã Roma macãrãrẽ ãñudutia. Cõãmacʉ̃ marĩ Pacʉ, teero biiri marĩ Õpʉ̃ Jesucristo mʉ́ãrẽ ãñuré ticoaro; ãñurõ niirecʉtiri tiiáro. ");
INSERT INTO tue_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ateré mʉ́ãrẽ wedesʉguea: Niipetiro macãrãpʉ mʉ́ã Jesuré padeorére wedesecua. Teeré tʉogʉ́, Jesucristo wãmemena Cõãmacʉ̃rẽ ʉsenire ticoa. ");
INSERT INTO tue_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Cõãmacʉ̃rẽ maĩrémena padecotea. Teero tiigʉ́, cʉ̃ʉ̃ macʉ̃ye netõnére quetire wedebatea. Cʉ̃ʉ̃ masĩqui: Yʉʉ cʉ̃ʉ̃mena wedeserecõrõ mʉ́ãye maquẽrẽ sãĩbosárucua. ");
INSERT INTO tue_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Teero biiri ateré cʉ̃ʉ̃rẽ sãĩrucújãã: “Cõãmacʉ̃, mʉʉ boorí, yʉʉ Romapʉ wáagʉda; too macãrã mʉʉrẽ padeoráre ĩñadʉgamiga”, jĩĩ sãĩmíã. Yoajõãã yʉʉ mʉ́ã pʉtopʉ wáadʉgamiriro. ");
INSERT INTO tue_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mʉ́ãrẽ nemorṍ wãcũtutuare bayiró boosã́jĩgʉ̃, Espíritu Santo yʉʉre masĩré ticorémena mʉ́ãrẽ tiiápudʉgaga. Teeré tiigʉ́, toopʉ́re wáadʉgamiga. ");
INSERT INTO tue_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Marĩ cãmerĩ́ tiiápuadacu. Mʉ́ã yʉʉ Jesuré padeorére ĩñarã, nemorṍ padeó, wãcũtutuaadacu. Yʉʉcã mʉ́ã padeorére ĩñagʉ̃, teerora wãcũtutuagʉdacu. ");
INSERT INTO tue_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yáa wederabiro niirã́, mʉ́ãrẽ ateré masĩrĩ boogá: Sĩcãrĩ mee mʉ́ã pʉtopʉ “wáagʉda” jĩĩmiã. Dee tii wáamasĩña maniã ména. Aperopʉ́ macãrã judíoa niihẽrãrẽ yʉʉ Jesuré padeoré boosã́rirobirora mʉ́ãcãrẽ Jesuré padeoré boosã́gʉ̃ wedegʉ wáadʉgamiga. ");
INSERT INTO tue_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Cõãmacʉ̃ cʉ̃ʉ̃ye quetire niipetirare yʉʉre wededutiwi. Griegoaye wedeserare, griegoaye wedesemasĩhẽrãcãrẽ wededutiwi. Masĩrã́rẽ, masĩhẽrãcãrẽ wededutiwi. ");
INSERT INTO tue_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Tee tiigʉ́, mʉ́ã Romapʉ niirã́rẽ Cõãmacʉ̃ netõnére queti cṹũriguere bayiró wededʉgaga. ");
INSERT INTO tue_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Yʉʉ Cõãmacʉ̃ netõnére quetire boboró manirṍ wedea, tee queti tutuare cʉorí ĩñagʉ̃. Cõãmacʉ̃ niipetirare tee quetire padeoráre netõnéqui. Judíoare netõnéqui; judíoa niihẽrãcãrẽ teerora netõnéqui. ");
INSERT INTO tue_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Tee quetimena marĩ ateré masĩã: Cõãmacʉ̃ Jesuré padeoráre “ãñurã́rã niiĩya” jĩĩ ĩñaqui. Jesuré padeorá dícʉre teero ĩñaqui. Teero padeoráre Cõãmacʉ̃ye queti jóaripũpʉ biiro jóanowʉ̃: Cõãmacʉ̃ cʉ̃ʉ̃rẽ padeogʉ́norẽ “ãñugʉ̃́rã niiĩ” jĩĩ ĩñaqui; cʉ̃ʉ̃rẽ catiré petihére ticogʉdaqui, jĩĩ jóanowʉ̃. ");
INSERT INTO tue_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Marĩ masĩã: Cõãmacʉ̃ cʉ̃ʉ̃rẽ netõnʉcã́rãrẽ, teero biiri ñañaré tiiráre ñañarõ tiiquí. Cʉ̃́ã ñañaré tiirémena ãpẽrã́ diamacʉ̃́ maquẽrẽ masĩrĩ tiirícua. Cʉ̃́ã teero tiiré wapa Cõãmacʉ̃ ʉ̃mʉã́sepʉmenarã cʉ̃ʉ̃ bayiró cúarere marĩrẽ ẽñogʉ̃́ tiiquí. ");
INSERT INTO tue_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Cʉ̃́ã Cõãmacʉ̃ye maquẽ sĩquẽrẽ masĩmicua. Cʉ̃ʉ̃ basiro teeré ãñurõ masĩrĩ tiirígʉ niimiwĩ. ");
INSERT INTO tue_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Cõãmacʉ̃ atibʉ́reco maquẽ tiiríguere ĩñarã, cʉ̃ʉ̃rẽ ĩñaripacara, “niiqui” jĩĩmasĩnoã. Cʉ̃ʉ̃ tiiríguemena cʉ̃ʉ̃ tutuare cʉonetṍjõãre baucú. Teero tiirá, deero jĩĩmasĩricua; wapa cʉojã́cua. ");
INSERT INTO tue_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Cʉ̃́ã “cʉ̃ʉ̃jã teero biigʉ́no niiqui” jĩĩ masĩpacara, cʉ̃ʉ̃rẽ quioníremena ĩñariyira. Sĩcãrĩno cʉ̃ʉ̃rẽ ʉsenire ticoriyira. “Cʉ̃ʉ̃jã teero biigʉ́no niiqui” jĩĩrõno tiirá, queoró wáari tiihérepere wãcũyira. Jõõpemena nemorṍ ñañarõ wãcũãmajãyira. ");
INSERT INTO tue_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Cʉ̃́ã “masĩnetõjõãã” jĩĩrã́ niipacara, tʉomasĩ́hẽrã wáayira. ");
INSERT INTO tue_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Cõãmacʉ̃ catirucugʉre asibatére cʉogʉ́pere booríyira. Cʉ̃ʉ̃pere booróno tiirá, basocá cʉ̃́ã weerirapere padeoyíra. Basocá bóadiaadara queorére, minipõná queorére, wáicʉra queorére, pĩnoã queorére wee, padeoyíra. ");
INSERT INTO tue_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Cʉ̃́ã teero tiiré wapa Cõãmacʉ̃ cʉ̃́ã booró tiidʉgárenorẽ tiijã́ãrõ jĩĩgʉ̃, cõãjõãrigʉ niiwĩ. Teero tiirá, ñeeapera, cʉ̃́ã basirora basocá tiinóña manirénorẽ tiicãmésãjãyira. ");
INSERT INTO tue_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Cõãmacʉ̃ye queti diamacʉ̃́ niirépere booríyira. Jĩĩditorepere booyíra. Niipetire tiirígʉpere súubusepeoriyira. Cʉ̃ʉ̃pere súubusepeorono tiirá, cʉ̃ʉ̃ tiiríguepere súubusepeoyira. Marĩrẽ Cõãmacʉ̃rẽ ʉsenipeorucujãrõ booa. Teerora tiiró booa. ");
INSERT INTO tue_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Teero tiigʉ́, Cõãmacʉ̃ cʉ̃́ã bayiró ʉgaripéarere tiijã́ãrõ jĩĩgʉ̃, cʉ̃́ãrẽ cõãjõãyigʉ. Numiã́pʉra ʉ̃mʉã́mena dícʉ ñeeaperenorẽ duujã́, cʉ̃́ã basiro numiã́ sesaro ñañaré tiiyíra. ");
INSERT INTO tue_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Teerora ʉ̃mʉã́cã numiã́mena dícʉ ñeeaperenorẽ duujã́, ãpẽrã́ ʉ̃mʉã́ sesaro bayiró ñeeapedʉgayira. Ʉ̃mʉã́ basirora ãpẽrã́ ʉ̃mʉã́mena ñeeape, bobooro wáari tiirére tiiyíra. Teero tiirá, cʉ̃́ã ñañaré tiiré wapa cʉ̃́ãye õpʉ̃ʉ̃rĩpʉre, teero biiri cʉ̃́ã wãcũrépʉre ñañarõ wáari tiiyíra. ");
INSERT INTO tue_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","“Marĩ Cõãmacʉ̃rẽ wãcũre wapamaníã”, jĩĩyira. Teero tiigʉ́, Cõãmacʉ̃pe cʉ̃́ã basiro wãcũrére “wapamaníre niijããdacu” jĩĩyigʉ. Toorá nemorṍ ñañarõ tiiã́majãrucuyira sáa. ");
INSERT INTO tue_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Niipetire ñañaré tiirénorẽ tiirucújãcua. Ãpẽrãrẽ́ ñañarõ netõrĩ́ tiiádarere wãcũcua. Apeyenó cʉopacára, boonemójãcua. Ate niipetire ñañarére tiidʉgácua. Doecua. Cãmerĩ́sĩãcua. Cãmerĩ́tuti, cãmerĩ́quẽcua. Tiiditócua. Ñañaré tiidʉgárere tiirucúcua. Wedepaticua. ");
INSERT INTO tue_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ãpẽrãrẽ́ ñañarõ wáari tiidʉgára, wedesããmajãcua. Cõãmacʉ̃ doonórã niicua. “Marĩ ʉpʉtí macãrã niijĩrã, marĩ tiidʉgárere tiiáda”, jĩĩ wãcũcua. “Marĩ ãpẽrã́ nemorṍ niinetõnʉcãã”, jĩĩ wãcũcua. “Biiro biiráno niiã ʉ̃sãjã”, jĩĩcua. Ñañarére tiibʉ́ajãcua. Cʉ̃́ã pacʉsʉ̃mʉãrẽ netõnʉcã́jãcua. ");
INSERT INTO tue_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ãñurõ diamacʉ̃́ wãcũricua. Cʉ̃́ã “teerora tiijã́ãda” jĩĩmiãriguere tiirícua. Cʉ̃́ãya wederare maĩrénorẽ masĩricua. Bóaneõ ĩñaricua. ");
INSERT INTO tue_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ateré ãñurõ masĩmicua: Cʉ̃́ãnorẽ cʉ̃́ã teero tiiré wapa Cõãmacʉ̃ cʉ̃́ãrẽ pecamepʉ cõãgʉ̃daqui. Teeré masĩpacara, ñañarére tiirucújãcua. Ãpẽrãrẽ́ ñañaré tiirí ĩñarã, “ãñuniã” jĩĩcua. ");
INSERT INTO tue_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Mʉ́ãcã basocára niipacara, ãpẽrãrẽ́ “cʉ̃́ã ñañarã́ niiĩya” jĩĩ ĩñabeserijãña. “Cʉ̃́ã wapa cʉoóya” jĩĩrã, mʉ́ã basiropecã wapa cʉoádarara niirã tiia. Mʉ́ãcã cʉ̃́ã tiiróbirora tiicú. Teero tiirá, Cõãmacʉ̃rẽ deero jĩĩ netõnʉcã́masĩricu; mʉ́ãcã wapa cʉorára niicu. ");
INSERT INTO tue_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ateré marĩ masĩã: Cõãmacʉ̃jã ñañaré tiiráre diamacʉ̃́rã wapa tiigʉ́, diamacʉ̃́rã tiigʉ́ tiiquí. ");
INSERT INTO tue_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Mʉ́ã ãpẽrãrẽ́ “cʉ̃́ã ñañarã́ niiĩya” jĩĩpacara, cʉ̃́ã tiiróbirora tiijã́ã. Teero tiirá, “Cõãmacʉ̃ ʉ̃sãpereja ‘mʉ́ã ñañarã́ niiã’ jĩĩriqui” jĩĩ wãcũrijãña. “Mʉ́ãcã ñañarã́rã niiã”, jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Cõãmacʉ̃ mʉ́ãrẽ bóaneõ ĩñagʉ̃́ máata ñañarõ tiiríqui ména. Cʉ̃ʉ̃ mʉ́ãrẽ bóaneõ ĩñapacari, mʉ́ã cʉ̃ʉ̃rẽ teero ĩñajãã. Ateré mʉ́ã tʉomasĩ́ricu: Cõãmacʉ̃ mʉ́ã ñañaré tiirére wãcũpati, wasoáro jĩĩgʉ̃, ãñugʉ̃́ niijĩgʉ̃, máata ñañarõ tiiríqui ména. ");
INSERT INTO tue_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Cʉ̃ʉ̃ teero tiipacári, mʉ́ã ñañaré tiirére wãcũpati, wasodʉgáricu. Mʉ́ã jõõpemena ñañarére tiinemósãjãjĩrã, Cõãmacʉ̃rẽ cúarosãrĩ tiirá tiia. Too síro basocáre wapa tiiádari bʉreco jeari, Cõãmacʉ̃ bayiró cúagʉ mʉ́ãrẽ wapa tiiádarere ẽñogʉ̃́daqui. ");
INSERT INTO tue_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Basocácõrõ tiiríguepʉre ĩñaco, wapa tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ãñuré tiirucúranopere cʉ̃ʉ̃ pʉtopʉ catiré petihére ticogʉdaqui. Cʉ̃́ã Cõãmacʉ̃mena niirucujãrere boocúa. Cõãmacʉ̃ cʉ̃́ãrẽ “ãñurõ tiiáwʉ̃” jĩĩrére tʉodʉgácua. ");
INSERT INTO tue_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ãpẽrãménapere Cõãmacʉ̃ bayiró cúagʉdaqui. Cʉ̃́ã Cõãmacʉ̃rẽ netõnʉcã́rã, cʉ̃́ã booré dícʉre tiidʉgácua. Diamacʉ̃́ maquẽrẽ boohéra, ñañarépere tiinʉnʉ́secua. ");
INSERT INTO tue_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Niipetira ñañaré tiirécʉtirano ñañarõ netõã́dacua; teero biiri ñañarõ tʉgueñarucujããdacua. Judíoare teero wáaadacu; judíoa niihẽrãcãrẽ teerora wáaadacu. ");
INSERT INTO tue_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Niipetira ãñurõ tiirécʉtirapere Cõãmacʉ̃ “mʉ́ã ãñurõ tiiwʉ́” jĩĩgʉ̃daqui. Niipetira ĩñacoropʉ cʉ̃́ãrẽ ãñurõ tiigʉ́daqui. Cʉ̃́ãrẽ ãñurõ niirecʉtiri tiigʉ́daqui. Judíoare teero tiigʉ́daqui; judíoa niihẽrãcãrẽ teerora tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Cõãmacʉ̃ sicadita macãrãrẽ “mʉ́ã dícʉ ãñurã́ niiã” jĩĩriqui; niipetire dita macãrãrẽ sĩcãrĩbíro ĩñaqui. ");
INSERT INTO tue_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Niipetirare Moisére dutiré cṹũriguere cʉorípacari, cʉ̃́ã ñañaré tiirécʉtire wapa pecamepʉ wáarora niijããdacu. Tee dutirére cʉorápecãrẽ netõnʉcã́re wapa diamacʉ̃́rã wapa tiinóãdacua tee dutiré jĩĩrõbirora. ");
INSERT INTO tue_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Tee dutirére tʉorémena dícʉ Cõãmacʉ̃ ĩñacoropʉre ãñurã́ mee niiĩya. Tee dutirébirora tiirí siro niiãtã, “ãñurã́rã niiĩya” jĩĩgʉ̃daqui Cõãmacʉ̃. ");
INSERT INTO tue_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Judíoa niihẽrã Moisére dutiré cṹũriguere ticonoripacara, cʉ̃́ã basiro ãñurére tiirá, tee dutirénorẽna tiirá tiicúa. Cʉ̃́ã basiro tiirémena tee dutirére masĩrã́ tiiróbiro niiĩya, tee dutirére cʉorípacara. ");
INSERT INTO tue_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ãñuré tiirémena cʉ̃́ã diamacʉ̃́ wãcũrére ẽñocúa. Tee dutirére masĩrã́ tiiróbiro niicua. Ãñurõ yeeripũnacʉtira niicua. Teero tiirá, ãñurére tiiárira “ãñuniãwʉ̃” jĩĩmasĩcua; ñañarére tiiárira “ñañaniãwʉ̃” jĩĩmasĩcua. ");
INSERT INTO tue_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Teero tiigʉ́, Cõãmacʉ̃ cʉ̃ʉ̃ basocáre wapa tiiádari bʉreco jeari, Jesucristore wapa tiidutígʉdaqui. Tiibʉreco jeari, Jesucristo niipetira cʉ̃́ã ñañaré wãcũré wapa, teero biiri cʉ̃́ã ãpẽrã́ ĩñahẽrõpʉ tiirígue wapacãrẽ cʉ̃́ãrẽ wapa tiigʉ́daqui. Yʉʉ Cõãmacʉ̃ netõnére queti cṹũriguere wedegʉ, teeré wederucua. ");
INSERT INTO tue_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Apetó tiirá, mʉ́ã judíoa wãcũbocu: “Ʉ̃sã judíoa niiã; Moisére dutiré cṹũriguere cʉoa; Cõãmacʉ̃ ʉ̃sã judíoayagʉra niiĩ; teero tiirá, ʉ̃sã dícʉ Cõãmacʉ̃ põna niiã”, jĩĩ wãcũmicu. ");
INSERT INTO tue_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","“Ʉ̃sã Cõãmacʉ̃ boorénorẽ masĩã. Moisére dutiré cṹũriguere masĩrã́ niijĩrã, ʉ̃sã ãñuré petire besemasĩã”, jĩĩ wãcũmicu. ");
INSERT INTO tue_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","“Capeari bauhérare wéewasʉguera tiiróbiro judíoa niihẽrãrẽ buemasĩjãã. Naĩtĩãrõpʉ niirã́rẽ sĩãwócora tiiróbiro Moisére dutiré cṹũriguere masĩhẽrãrẽ wedemasĩã”, jĩĩ wãcũmicu. ");
INSERT INTO tue_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","“Ʉ̃sã Moisére dutiré cṹũriguere cʉojĩ́rã, diamacʉ̃́ maquẽrẽ masĩã. Teero tiirá, tʉomasĩ́hẽrãrẽ, sicato buemʉõcorare buemasĩã”, jĩĩ wãcũmicu. ");
INSERT INTO tue_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Mʉ́ã “ãpẽrãrẽ́ buerá niiã” jĩĩrã, mʉ́ã basirope buesʉguero booa ména. Ãpẽrãrẽ́ “yaaríjãña” jĩĩ wedepacara, ãpẽrãyére yaajã́cu. ");
INSERT INTO tue_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","“Mʉ́ã nʉmosã́numiã niihẽrãrẽ, mʉ́ã manʉsʉ̃mʉã niihẽrãrẽ ñeeaperijãña” jĩĩpacara, ñeeapejãcu. Mʉ́ã ãpẽrã́ weerirare, cʉ̃́ã padeoráre doopacára, cʉ̃́ã padeoré wiseripʉ niirére yaajã́cu. ");
INSERT INTO tue_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","“Ʉ̃sã Moisére dutiré cṹũriguere cʉojĩ́rã, ãpẽrã́ nemorṍ niiã”, jĩĩ wãcũmicu. Teero wãcũpacara, tee dutirére netõnʉcã́jãcu. Ãpẽrã́ mʉ́ã netõnʉcã́rĩ ĩñajĩrã, Cõãmacʉ̃pere ñañarõ wedesecua. ");
INSERT INTO tue_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Cõãmacʉ̃ye queti jóaripũpʉ mʉ́ã teero tiirénorẽ biiro jóanowʉ̃: “Mʉ́ã tiibuyére wapa judíoa niihẽrãpe Cõãmacʉ̃rẽ ñañarõ wedesecua”, jĩĩ jóanowʉ̃. ");
INSERT INTO tue_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Mʉ́ã Moisére dutiré cṹũriguebirora tiiátã, mʉ́ã cõnerígʉ yapa macã caseróre widecõã́recã wapacʉtía. Mʉ́ã tee dutirére netõnʉcã́rã doca, widecõã́noña manirã́ tiiróbiro pʉtʉácu. ");
INSERT INTO tue_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Apetóre sĩcʉ̃ widecõã́noña manigʉ̃́pe Moisére dutiré cṹũriguere tiiquí. Teeré tiigʉ́, Cõãmacʉ̃ ĩñacoropʉre widecõã́norigʉ tiiróbiro niiqui. ");
INSERT INTO tue_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mʉ́ã judíoa Moisére dutiré cṹũriguere cʉomíã. Widecõã́norira niipacara, tee dutirére netõnʉcã́jãcu. Ãpĩ widecõã́noña manigʉ̃́ niipacʉ, tee dutirére masĩripacʉ, tee dutiré jĩĩrõbirora tiiquí. Cʉ̃ʉ̃ teero tiirí, niipetira mʉ́ã wapa cʉorére ãñurõ ĩñamasĩjãnoãdacu. ");
INSERT INTO tue_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","“Judíoayʉ peti niiã” jĩĩgʉ̃́no sotoá maquẽ dícʉre tiinórigʉ mee niiqui. Cʉ̃ʉ̃ye õpʉ̃ʉ̃ maquẽ dícʉre widecõã́norigʉ mee niiqui. ");
INSERT INTO tue_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Judíoayʉ peti niigʉ̃́pe cʉ̃ʉ̃ wãcũrépʉre Cõãmacʉ̃ dutirére ʉseniremena tiiquí. Cʉ̃ʉ̃pe ñañarõ wãcũrére widecõã́norigʉ tiiróbiro niiqui. Espíritu Santo marĩ wãcũrére wasorí tiiquí. Tee dutirére tiirémenape marĩ basiro wasomasĩ́ricu. Basocá teero wasonórirare “ãñurã́rã niiĩya” jĩĩripacari, Cõãmacʉ̃pe teeré jĩĩgʉ̃daqui. ");
INSERT INTO tue_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yʉʉ teero jĩĩgʉ̃, “judíoa niiré wapamaníã” jĩĩgʉ̃ mee tiiáwʉ̃. Teero biiri “cõnerígʉ yapa macã caseróre widecõã́recã wapamaníã” jĩĩgʉ̃ mee tiiáwʉ̃. ");
INSERT INTO tue_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Teero wapacʉtírucujãã. Ateré wedesʉguegʉda: Cõãmacʉ̃ marĩ judíoarena cʉ̃ʉ̃ye quetire wedearo jĩĩgʉ̃, cṹũyigʉ. ");
INSERT INTO tue_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ãpẽrã́ judíoa Cõãmacʉ̃ dutirére tiidújãmicua. Cõãmacʉ̃cã cʉ̃́ã tiiróbirora cʉ̃ʉ̃ “tiigʉ́da” jĩĩriguere ¿tiidújãgari? ");
INSERT INTO tue_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Tiidúriqui. Ateré wãcũrucujãña: Cõãmacʉ̃ cʉ̃ʉ̃ jĩĩrirobirora queoró tiirucúqui. Marĩpe niiã “tiiáda” jĩĩmiãriguere tiihérapeja. Cʉ̃ʉ̃ye queti jóaripũpʉ tee maquẽrẽ biiro jóanowʉ̃: Mʉʉ jĩĩré diamacʉ̃́rã niijãrõ tiia. Teero tiirá, mʉʉrẽ wedesãmasĩña maniã. Mʉʉrẽ wedesãpacari, netõnʉcã́rucujãgʉ̃dacu, jĩĩ jóanowʉ̃. ");
INSERT INTO tue_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Teero tiigʉ́, sĩcʉ̃ ñañarõ wãcũgʉ̃no biiro wãcũboqui: “Yʉʉ ñañaré tiirémena Cõãmacʉ̃ ãñurõ tiirépe nemorṍ ãñurõ baujã́ãdacu sáa”, jĩĩmiqui. Too síro jĩĩnemoboqui: “Yʉʉ teero tiiárigue wapa niipacari, Cõãmacʉ̃ yʉʉmena cúagʉ, ñañarõ tiiquí”, jĩĩ wãcũboqui. ");
INSERT INTO tue_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Teero mee niiã. Cʉ̃ʉ̃ teero jĩĩréno diamacʉ̃́ niiréno niiãtã, Cõãmacʉ̃ sĩcʉ̃norẽ cʉ̃ʉ̃ ñañaré tiiré wapa diamacʉ̃́ bese, ñañarõ tiimasĩ́riboqui. ");
INSERT INTO tue_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ãpĩ ñañarõ wãcũgʉ̃no jĩĩnemojãboqui: “Yʉʉ jĩĩditoremena Cõãmacʉ̃ diamacʉ̃́ wedeserepere ãñurõ wedesenoãdacu. Yʉʉ jĩĩditoremena ãñurõ wedesenopacʉ, ¿deero tiigʉ́ Cõãmacʉ̃ yʉʉre yʉʉ jĩĩditore wapa ñañarõ tiibógari?” jĩĩmiqui. Cʉ̃ʉ̃ teero jĩĩré jĩĩãmare niiã. ");
INSERT INTO tue_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Cʉ̃ʉ̃ teero jĩĩréno diamacʉ̃́ niiréno niiãtã, biirope pʉtʉáboyu: “Marĩ ñañaré tiirí, Cõãmacʉ̃ ãñurõ tiirére nemorṍ masĩãdacua. Teero tiirá, ãñuré wáaaro jĩĩrã, ñañarépere tiiáda”, jĩĩjãbocu. Ãpẽrã́ yʉʉre, yʉʉ menamacãrãrẽ merẽã wãcũãrõ jĩĩrã, “Pablo teeré buequi” jĩĩditocua. Cʉ̃́ã teero jĩĩditore wapa Cõãmacʉ̃ cʉ̃́ãrẽ diamacʉ̃́rã wapa tiigʉ́, ñañarõ tiigʉ́daqui. ");
INSERT INTO tue_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Too docare ¿deero pʉtʉánoãdari sáa? ¿Cõãmacʉ̃ ĩñacoropʉre marĩ judíoa ãpẽrã́ nemorṍ ãñurã́ niinetõnʉcãĩ? Niiria. Niipetira judíoa, judíoa niihẽrã Cõãmacʉ̃rẽ netõnʉcã́rã niijĩrã, sĩcãrĩbíro wapa cʉorá dícʉ niiã. Mʉ́ãrẽ teeréna wedetoawʉ. ");
INSERT INTO tue_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Tee maquẽrẽ Cõãmacʉ̃ye queti jóaripũpʉ jóanoã: Sĩcʉ̃no ãñuré tiigʉ́ maniĩ. ");
INSERT INTO tue_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Sĩcʉ̃no Cõãmacʉ̃ye maquẽrẽ tʉomasĩ́gʉ̃ maniĩ. Sĩcʉ̃no Cõãmacʉ̃rẽ masĩdʉgarii; cʉ̃ʉ̃rẽ wãcũnʉnʉsedʉgarii. ");
INSERT INTO tue_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Niipetira Cõãmacʉ̃yere duujã́, posapetijõãya. Niipetira ñañaré tiiíya. Sĩcʉ̃no ãpẽrãrẽ́ ãñurõ tiigʉ́no maniĩ. ");
INSERT INTO tue_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Cʉ̃́ã wedesere masãcope tusuri copepʉ ʉ̃niwiónecoro tiiróbiro niiã. Tee ʉ̃niwiónecore tiiróbiro basocá ñañarére wedeseya. Jĩĩditorucuya. Ãñaã ʉseropʉ nima cʉorá tiiróbiro bayiró pũnirṍ wedeseya. ");
INSERT INTO tue_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ãpẽrãrẽ́ doajãya; bayiró tutiiya. ");
INSERT INTO tue_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Cʉ̃́ã basocáre sĩãdʉgára, boyeromena sĩãrã́ wáaaya. ");
INSERT INTO tue_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Cʉ̃́ã wáaro basocáre ñañarõ peti tiiíya. Cʉ̃́ãyere ñañopetíjã, bóaneõrã pʉtʉári tiiíya. ");
INSERT INTO tue_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ãpẽrãrẽ́ ãñurõ niirecʉtiri tiiríya. ");
INSERT INTO tue_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Cõãmacʉ̃rẽ quioníremena ĩñariya. Cʉ̃ʉ̃rẽ cuiriya, jĩĩ jóanoã. ");
INSERT INTO tue_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Marĩ masĩã: Cõãmacʉ̃ye queti jóaripũ maquẽ marĩ judíoarena jĩĩjãrõ tiia, “ãñurã́ niiã ʉ̃sã” jĩĩrijããrõ jĩĩrõ. Niipetirapʉra wapa cʉorá dícʉ niijãcu. ");
INSERT INTO tue_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Moisére dutiré cṹũriguemenarã marĩ ñañaré tiiríra Cõãmacʉ̃rẽ “ʉ̃sã mʉʉ dutirére netõnʉcã́jãtʉ” jĩĩmasĩnoã. Teero tiigʉ́, Cõãmacʉ̃ sĩcʉ̃norẽ “mʉʉ tee dutirére tiipetíjãrigʉ niijĩgʉ̃, ãñugʉ̃́rã niiã” jĩĩ ĩñariqui. ");
INSERT INTO tue_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Atitóre Cõãmacʉ̃ Jesuré padeoráre “ãñurã́rã niiĩya” jĩĩ ĩñaqui. Marĩ “Moisére dutiré cṹũrigue jĩĩrõbirora tiiáwʉ̃” jĩĩripacari, “ãñurã́rã niiĩya” jĩĩ ĩñaqui. Moisés, teero biiri profetas Cõãmacʉ̃ teero marĩrẽ tiibosáadarere cʉ̃ʉ̃ye queti jóaripũpʉ jóarira niiwã. ");
INSERT INTO tue_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Niipetirare Jesucristore padeorémena Cõãmacʉ̃ “ãñurã́rã niiĩya” jĩĩ ĩñaqui. Cõãmacʉ̃ niipetirare sĩcãrĩbíro ĩñaqui. ");
INSERT INTO tue_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Marĩ niipetira ñañaré tiirá niiã. Marĩ niipetirare pairó dʉsaa; marĩ ãñurã́ niiridojãã Cõãmacʉ̃ niiré tiiróbiro. ");
INSERT INTO tue_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Teero niipacari, Cõãmacʉ̃ marĩrẽ ãñuré ticogʉ́ Jesucristo wapatíbosariguemena marĩrẽ “wapa cʉohéra pʉtʉáaro” jĩĩyigʉ. Tee wapatíbosariguere teerora ticojãyigʉ. ");
INSERT INTO tue_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Too sʉguero macãrãpʉre cʉ̃́ã ñañaré tiipacári, ñañarõ tiiríyigʉ. Bóaneõ ĩñaré cʉojĩ́gʉ̃, cʉ̃́ãmena cʉ̃ʉ̃ cúarere ẽñoríyigʉ ména; teerora ĩñajãyigʉ. Too síro Cõãmacʉ̃ Jesuré marĩrẽ diabosari tiirí, cʉ̃ʉ̃ye díi õmayudiayiro. Marĩ cʉ̃ʉ̃ diabosariguere padeorí, Cõãmacʉ̃ marĩmena cúanemoriqui. Teeména Cõãmacʉ̃ cʉ̃ʉ̃ “diamacʉ̃́rã tiigʉ́ niiã” jĩĩrére ẽñoyígʉ. ");
INSERT INTO tue_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Atitócãrẽ Cõãmacʉ̃ cʉ̃ʉ̃ “diamacʉ̃́rã tiigʉ́ niiã” jĩĩrére ẽñoquí. Diamacʉ̃́rã tiirécʉtijĩgʉ̃, Jesuré padeoráre “wapa cʉohérara niiĩya” jĩĩ ĩñamasĩqui. ");
INSERT INTO tue_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Teero tiirá, marĩ “biiro tiirécʉtirano niiã ʉ̃sãjã” jĩĩmirigue wapamaníã. Marĩ Moisére dutiré cṹũriguere tiipetírapeja, teeré jĩĩmasĩnobojĩyu. Cõãmacʉ̃ marĩ Jesuré padeorípere ĩña, “ãñurã́rã nii