﻿USE sofia;
DROP TABLE IF EXISTS sofia.tuc_t_vpl;
CREATE TABLE tuc_t_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tuc_t_vpl WRITE;
INSERT INTO tuc_t_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Muuŋ, saawe imin maata kat, Maaron ighur sambam ve taan tomania gabua naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Saawe tana, nugh ŋginaaŋa mon, ve gabua eta igheen tuŋia ila niia soone. Yaa mon ta ipavon nugh, ve ndoroom tiina ikau nugh. Ve Maaron Avuvu ilala ilamlam izala te paavo. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ra Maaron isaav ighe: “Ghazooŋa aat ivot.” Tauvene ghazooŋa ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Maaron ighita ghazooŋa tawe poia, ve ivalaghi ila soghan pa ndoroom. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ghazooŋa tana, i iwaato ighe “mataaz,” ve ndoroom i iwaato ighe “mboŋ.” Mboŋ tana ila ve nughizau, ene uraat imin ee isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Maaron isaav muul ighe: “Gabua ariaaŋa eta aat ivot, leso ivalagh yaa imin ru. Sirivu igheen izaa saaŋa, ve sirivu igheen izi siiŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tauvene gabua tawe ivot itaghon i tauu aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Gabua ariaaŋa tana, i iwaato ighe “sambam saamba.” Mboŋ tana ila ve nughizau, ene uraat imin ru isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Maaron isaav muul ighe: “Yaa tau igheen ila sambam saamba na, aat ila ilup ghi ila niia eemon, ve nugh imamaas.” Tauvene gabua tawe ivot itaghon i tauu aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nugh mamaasa tana, i iwaato ighe “taan.” Ve yaa tau ila ilup ghi ila niia eemon, ene i iwaato ighe “te.” Ve Maaron ighita poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Maaron isaav muul ighe: “Ai maata maata, tomania waar, kikiliiŋ ve aniiŋ maata maata aat tivot pa taan, ve titum tizaa ve tiyanooŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tauvene gabua naol isov tawe titum tizaa, itaghon i tauu aliiŋa. Ve Maaron ighita poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mboŋ tana ila ve nughizau, ene uraat imin tol isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Maaron isaav muul ighe: “Gabua siriv aat tivot ila sambam saamba. Leso tisul taan, ve tivalagh mboŋ ve mataaz, ve timin ilaal pa kaiyo, ndaman, ve saawe siriv paam.” Tauvene gabua naol tawe tivot itaghon i tauu aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Maaron ighur gabua tintiina ru tomania pitum. Gabua tiina kat ighaaz pa mataaz, ve gabua tau imuul mon na ighaaz pa mboŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Maaron ighur gabua naol tana ila sambam saamba. Leso tisul taan pa mboŋ ve mataaz, ve tivalagh ndoroom ve ghazooŋa. Ve Maaron ighita poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mboŋ tana ila ve nughizau, ene uraat imin paaŋ isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Maaron isaav muul ighe: “Te aat ivon pa iigh tomania gabua maata maata tau matazi yaryaare na. Ve man naol tivot ve tiroov ila taitai saamba.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tauvene Maaron ighur gabua tintiina to te, tomania gabua maata maata tau tileep ila te ve yaa lolozi. Ve ighur man ta naol ne paam. Ve Maaron ighita poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ve ighur poia tooni izaa toozi ighe: “Yam gabua tau aleep ila te ve yaa na, apoop ve amasa amin naol. Leso apavon te ve yaa. Ve yam man amasa amin naol ve aleep irau taan isov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mboŋ tana ila ve nughizau, ene uraat imin liim isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Maaron isaav muul ighe: “Taan aat ivon pa ŋgai maata maata to su ve nughei, tomania gabua geegeu tau tikakarau ila taan.” Tauvene gabua naol isov tawe tivot itaghon i tauu aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Maaron ighur ŋgai maata maata to su ve nughei, tomania gabua naol isov tau tikakarau ila taan. Ve Maaron ighita poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ragha Maaron isaav muul ighe: “Iit aat tagharaat tamtamon timin iit tauun, leso tigham naghoon ve tiŋgin taan, ve iigh to te, man tau tirovroov ila taitai saamba, ŋgai maata maata, ve gabua naol isov tau tikakarau ila taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tauvene Maaron ighur tamtamon timin i tauu. Ighur zi tigham i tauu naagho. Ighur zitamoot ve zilivaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ve Maaron ighur poia tooni izaa toozi, ve isaav pazi ighe: “Yam apoop ve amasa amin naol, leso apavon taan. Yam aat agham uratoini ve aŋgin poghania. Ve aŋgin iigh to te, man tau tirovroov ila taitai saamba, ve gabua matazi yaryaare naol tau tileep izi taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Maaron isaav pazi muul ighe: “Aghita. Yau nagham saiŋ, aniiŋ, ve ai maata maata tau titum izi taan na anoŋazi timin lemim aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ve ŋgai tau tileep izi taan, ve man tau tirovroov ila taitai saamba, ve gabua naol tau tilaghlaagh ve tikakarau ila taan na, yau nagham kikiliiŋ ve ai raua imin lezi aniiŋ.” Ve gabua tana ivot itaghon i tauu aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Maaron ighita gabua naol tau i ighur zi na, paghunazi kat. Mboŋ tana ila ve nughizau, ene uraat imin liim ve ee isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ene eez tau Maaron ighur sambam, taan, ve gabua naol isov tivotiir. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Saawe tau imin liim ve ru, ene Maaron imariau. Pasaa, i ipasovuur uraat tooni naol isov wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tauta Maaron ipakur saawe tau imin liim ve ru na, ve ighur poia tooni igheen izala, ve ighuru imin umbom patabuyaaŋ. Pasaa, saawe tana, i imariau pa uraat tooni tau ighur sambam, taan, ve gabua naol isov na. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ene sinaiŋ tau isavia saawe tau Maaron Yoova ighur sambam saamba ve taan tomania gabua naol isov tivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Saawe tau Maaron Yoova ighur sambam ve taan, gabua eta itum soone. Ai itum soone, kikiliiŋ itum soone. Taan ŋginiiŋa mon. Pasaa, i igham uman izi taan soone, ve tamtamon eta ileep ila taan to igham uratoini soone. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Eemon yaa tau igheen ila taan loolo, tauta ivotvot ve ipapaluum taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Maaron Yoova ikor taan ila niima, ibuuda, ve igharaata imin tamtamon, ra iviv avuvu maata yaryaare ila uuzu, ve tamtamon tawe iburig maata iyaryaar. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Taan sirivu ee ta igheen ila pa aaz izaa pani, eeza Eden. Maaron Yoova ighur gabua popoia titum ila uum tawe loolo le paghuuna kat. Ra ighur tamtamon tau i tauu igharaata na ila ileep ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Maaron Yoova ighur ai maata maata titum ila uum tana loolo. Ai tawe, popoia pa ghitooŋ, ve anoŋazi popoia pa ghaniiŋ paam. Ila bodbodaaŋ to uum, ai ru tiyozyooz. Ai ee, to igham ghiit taleep mataan yaryaare. Ve ai ite, ene to igham ghiit taghilaal ŋgar poia ve ŋgar saghati. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yaa ee ivot pa uum tana ve ipaluum taan. Yaa tawe ireer ve ivalaghi imin booga paaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Booga ee, eeza Pison. Ene ireer irau taan Avila isov. Taan Avila, gol popoia tomania maet popoia siriv tau timin kuaz na, tigheen ila taan loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ve booga ite imin ru, eeza Gion. Ene ireer irau taan Kus isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ve booga ite imin tol, eeza Tigris. Ene ireer ila pa taan Asiria ziige tau igheen ila pa aaz izaa. Ve booga tau imin paaŋ, eeza Euprates. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Maaron Yoova igham tamtamon tana, ve ighuru ila uum Eden, leso iŋgini ve igham uratoini. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","17","Ve isaav pani ighe: “Ai anoŋazi ta naol ne, yo irau ughan zi le tisov. Eemon ai tau irau igham ghom ughilaal ŋgar poia ve ŋgar saghati, ai eemon tawe, ughan anooŋa sov. Pa saawe tau ighe ughani, yo aat umaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ra Maaron Yoova maata iŋgal ighe: “Tamtamon tane zigani ileep, ene poia mako. Yau aat naghur le iitete eta to iuule.” ");
INSERT INTO tuc_t_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tauvene Maaron Yoova ikor taan ila niima, ibuuda, ve igharaat ŋgai maata maata tau tilaghlaagh ila taan, ve man tau tirovroov ila taitai saamba na. Le isov, ra ilup zi ve igham zi tila to tamtamon tana, leso ighita: Pale iwatoor ezazi mindai? Ve ezazi tau tamtamon tana iwaat zi na, ene imin gabua naol tawe ezazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I iwaat ŋgai maata maata to nughei ve su ezazi, ve iwaat man ezazi paam. Eemon gabua eta ighur pani leso imin iitete to iuule ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tauvene Maaron Yoova igham tamoot igheen imaat, ve ipas raŋraaŋo sirivu ee ivot, ve ipoon mulin niia pa miiza. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ra igham tamoot raŋraaŋo tawe, ve igharaata imin livaa, ve ighuru ila to tamoot. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tamoot ighita livaa tana, ve isaav ighe: “Aa ŋgarig gha leg etag ee! Tuua, ene yau tuag. Ve miiza, ene yau mizag. Yau aat nawaato naghe ‘livaa.’ Pasaa, i ivot ila to yau tamoot.” ");
INSERT INTO tuc_t_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Puughu tane ta tamoot eta ighe ivai, i aat ipul taama gha tiina, ve yesuru azaawa tivalupu zi timin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Saawe tana, tamoot yesuru azaawa tinizi ŋginaaŋa. Eemon mayazi pa tauzi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Moot ilepleep izi uum paam. I le ŋgar tiina kat pa ghamuuŋ karom iliiv ŋgai naol isov tau Maaron Yoova ighur zi na. Saawe ee, i ighason livaa ighe: “Mindai? Ai anoŋazi naol tau tigheen ila uum loolo ne, Maaron Yoova iŋgalsekin gham ighe aghan zi sov. Ene onoon?” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Livaa iyol aliiŋa ighe: “Mako. Maaron isaav ighe: Ai naol tau tiyooz ila uum loolo ne, yei irau nighan anoŋazi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ai eemon geeg tau iyooz ila bodbodaaŋ to uum, tauta i iŋgalsekin ghei pani ighe nighani sov, ve nikisi sov. Pa ighe nighani, ma nikisi, ene aat nimaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Moot isaav pani muul ighe: “Mako. Yamru irau amaat mako. Maaron iwatagh: Isaav ighe yamru aghan ai tawe anooŋa, ene aat matamim pakia ve ŋgar tsiam ighazooŋ, le amin i tauu, ve aghilaal ŋgar poia ve ŋgar saghati.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Livaa ighita ai anooŋa tawe paghuuna kat pa maata ve poia pa ghaniiŋ paam. I loolo pani kat pasaa, ighe ai anooŋa tana pale igham ŋgar tooni ighazooŋ. Tauvene ighamu gha ighani, ve igham sirivu pa azaawa gha aana ighan paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yesuru tighani le isov, ra matazi pakia ve tighilaal tighe tinizi ŋginaaŋa. Tauvene yesuru tila tigham ai raua, gha tidagini, ve tipoon zi pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ravrav izi gha nugh iluum, ra yesuru tilooŋ Maaron Yoova ilaghlaagh ila uum loolo. Tauvene tila tiyooŋ pani ila ai loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Maaron ipaiyo tamoot ighe: “Ou, taum sindei?” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tamoot iyol aliiŋa ighe: “Yau nalooŋ aghem luutu ila uum loolo, tauvene naroi payo ve nayooŋ. Pasaa, tinig ŋginaaŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tauvene Maaron ighasoni ighe: “Sei isaav payo ighe tinim ŋginaaŋa? Ai tau yau naŋgalsekin ghom pani na, aat yo ughan anooŋa eta wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tamoot iyol Maaron aliiŋa ighe: “Yau mako. Livaa tau yo ugham payau ughe yeiru nileep na, tauta igham ai tawe anooŋa sirivu payau gha naghani.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tauvene Maaron Yoova isaav pa livaa aana ighe: “Yo ugham ŋgar tane pasaa?” Livaa iyol Maaron aliiŋa ighe: “Yau mako. Moot itombaan ghau, tauta naghani.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tauvene Maaron Yoova isaav pa moot ighe: “Yo ta umin puughu pa sosor tane. Tauta pataŋani tiina kat pale izaa tsio iliiv ŋgai naol isov to nughei ve su. Yo aat ukarau ila gargarim ve ughan ŋgaupup to taan ila ila le irau mateegh tsio. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ve yau aat naghur koi isap yo ve livaa sosomim. Ve paaghu tsio ve paaghu tooni tauvene paam. Koi pale isap sosozi. Paaghu to livaa pale ivaghaaz valaghin dabam. Ve yo pale uŋaaŋ aaghe guubu.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ra Maaron isaav pa livaa ighe: “Yau aat naghur pataŋani payo tauvene: Isaav ighe yo apom, ene pale pataŋani tiina igham ghom. Ve saawe tau ighe upoop, na yo aat uyamaan yavyavuuŋ tiina kat. Eemon lolom pale igheen ariaaŋ ila to azuwam, ve uleep ila i saamba.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ra Maaron isaav pa tamoot ighe: “Yo ulooŋ azuwam aliiŋa, ve ughan ai anooŋa tau yau naŋgalsekin ghom pani na. Tauvene yau aat navaghamunia taan. Lepogham izi taan tane, yo aat ugham uraat tiina, ve uyamaan katin pataŋani, o ughita anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pasaa, oot sasaghati ve waar tuatua pale titum tizaa ve tivaghamunia uum tsio. Eemon yo pale ughan ila uum tana. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tauvene yo pale urav taum pa uraat le ughun punitam, o ughita uraat tsio anooŋa ve ughan. Ve pataŋani tauvene aat ikiskis ghom le irau mateegh tsio. Pasaa, yau nagharaat ghom pa taan. Tauvene yo aat umuul ula umin taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tamoot iwaat azaawa eeza Eva. Pasaa, i pale imin eval tisov tau tileep taan ne tinazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Murei ra, Maaron Yoova igharaat ŋgai uuli imin nonoghiiŋa pa Adam yesuru azaawa, ve inonogh zi pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ra Maaron Yoova isaav ighe: “Laak. Tamtamon ŋgar toozi ivot imin iit, ve tighilaal ŋgar poia ve ŋgar saghati wa. Tauvene iit irau tapul zi tileep uum tane muul mako. Pa ighe nimazi ila pa ai to igham zi tileep matazi yaryaare, ve tighani paam, ene pale tileep tauvene taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tauvene Maaron Yoova iziir zi pa uum Eden. Leso tila tigham uratoi taan tau yesuru tivot pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","I iziir zi gha tivot tila, ra ighur aŋela ariaŋazi siriv tila tiyooz ila uum ziige tau aaz izaa pani. Yes tiyozyooz tomania mbuzaagh ee tau yav ighanghan ila ve itortoor ghi. Leso tipoon eez tau ila pa ai to mataan yaryaare. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Murei ra, Adam yesuru azaawa tigheen ve Eva aapo. I ipoop naatu tamoot ve iwaat eeza Kain. Ve isaav ighe: “Maaron iuul ghau, tauta napoop natug tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tilepleep le murei ra, Eva ipoop Kain taazi Avel. Yesuru timin zolman, mako Avel iŋginŋgin sipsip, ve Kain ighamgham uraat pa uum. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Saawe ee, Kain igham aniiŋ anooŋa siriv tau ivot ila uum tooni na imin watooŋrau pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ve Avel paam irav sipsip tooni natŋa aidabazŋa siriv, ve igham sirivu tau popoia kat na ila pa Yoova imin watooŋrau pani. Yoova loolo poia pa Avel tomania watooŋrau tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Eemon Kain tomania watooŋrau tooni, ene Yoova irere pani. Tauta Kain aate yavyav kat le naagho isaghat. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tauvene Yoova ighason Kain ighe: “Puughu mindai ta atem yavyav le naghom isaghat? ");
INSERT INTO tuc_t_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Isaav ighe yo ugham ŋgar duduuŋa, ene pale lolog poia payo ve tintinim. Eemon isaav ighe ugham ŋgar tau iduduuŋ mako, na uyamaan ghom. Pasaa, ŋgar saghati ileep ataman tsio aavo, ve isasaŋan ghom ighe igham ghom umin le. Tauvene yo aat uyooz ariaaŋ ve utatan ŋgar saghati tana izi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Murei ra Kain isaav pa taazi Avel ighe: “Ulam ituru tala talaghlaagh uum loolo.” Yesuru tila ta sewe, ra Kain iburig ve irav taazi Avel imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tauvene Yoova ighason Kain ighe: “Kain, tazim Avel ileep sindei?” Kain iyol aliiŋa ighe: “Yau nakankaan pani. Mindai, yau namin ŋginiiŋ to tazig?” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ra Yoova isaav pani muul ighe: “Yo ugham ŋgar tane pasaa? Ulooŋ. Tazim siŋ tooni tau imaliŋ izi taan na, tauta iboboob izalam payau. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yo urav tazim imaat, ve taan tane ighun siŋ tooni wa. Tauvene yau aat naghur pataŋani tane iŋarui ghom: Yo irau uleep muul izi taan tane mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ve isaav ighe yo uvazogh aniiŋ izila taan to nugh ite paam, ene pale ughita anooŋa eta mako. Yo aat irau uleep tuŋia izi nugh eta mako. Pale uvalaghlaagh irau taan naol.” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ilooŋ saveeŋ tane, ve isaav pa Yoova ighe: “Atuya to sosor tsiau tau yo ughuru payau, ene pataŋani kat. Irau nabaado mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ughita. Aazne yo uziir ghau pa taan tane ve nala naleep soghan payo. Ve ughe yau irau naleep tuŋia izi nugh eta mako. Pale navalaghlaagh irau taan naol, ve ighe ŋeer eta indeeŋ ghau, i pale irav ghau namaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Eemon Yoova iyol aliiŋa muul ighe: “Mako. Isaav ighe ŋeer eta irav ghom umaat, ene pale nayat ŋeer tana sosor tooni irau pai liim ve ru.” Ra Yoova ighur ilaal ee izaa to Kain. Leso tamtamon tighita ve tiravu sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kain ipul Yoova, ve ilaagh ila ivot taan sirivu ee, eeza Nod, ve ileep ta sewe. Taan tawe igheen uum Eden ziige ila pa aaz izaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Murei ra, Kain yesuru azaawa tigheen, ve livaa aapo ve ipoop naatu aidaaba, eeza Anok. Ra Kain igharaat nugh tiina ee, ve iwaat naatu Anok eeza pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Anok naatu Irad, Irad naatu Mehuyael, Mehuyael naatu Metusael, ve Metusael naatu Lamek. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ivai zilivaa ru. Ee eeza Ada, ve ite eeza Zila. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Lamek azaawa Ada ta ipoop Yabal. Yabal paaghu tooni, ene yes tau tilaghlaagh tomania ŋgai toozi, ve tilepleep ila balbaal tau tigharaata pa ŋgai uuli. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal taazi, eeza Yubal. Paaghu tooni, ta tighagharaat mboi to vivuuŋ ve gabua siriv imin gita. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek azaawa ite Zila ipoop Tuval-Kain. Tuval-Kain paaghu tooni, ta tighagharaat ain ve baras imin gabua siriv to uraat. Tuval-Kain liivu eeza Naama. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Saawe ee, Lamek isaav pa azauŋa ru ighe: “Ada yamru Zila, alooŋ aliŋag. Yau Lamek azuwagŋa ta yamru. Aghur taliŋamim pa saveeŋ tsiau. Ighe ŋeer eta irav ghau le siŋig izi, ene aat naravu imaat. Ve isaav ighe ŋeer paaghu eta iposai paŋag, ene pale naravu imaat paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Alooŋ. Ighe tamtamon eta irav Kain imaat, ene pale tiyatu irau pai liim ve ru. Eemon yau, isaav ighe tirav matin ghau, ene pale tiyatu irau pai tamoot tol saŋavul liim ve ru (77).” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam yesuru azaawa Eva tigheen muul, ve Eva aapo, ve ipoop tamoot ite. I iwaat eeza Set, ve isaav tauvene: “Kain irav taazi Avel gha imaat, tauta Maaron igham leg tamtamon ite tane, leso iyoli.” ");
INSERT INTO tuc_t_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Murei ra, Set yesuru azaawa tipoop tamoot ee, ve Set iwaat eeza Enos. Saawe tana, tamtamon tipaburigin ŋgar to suŋuuŋ pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ene pitiiŋ to Adam ve paaghu tooni: Saawe tau Maaron ighur tamtamon, ighur zi timin i tauu. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ighur tamoot ve livaa. Ve ighur poia tooni izaa toozi ve iwaat zi ighe “tamtamon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam ndaman tooni irau 130, ra yesuru azaawa tipoop natuzi ee. I igham taama naagho. Yesuru raratezi kat. Adam iwaat eeza ighe Set. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set izi, ve Adam ileep muul irau ndaman 800, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tauvene Adam ileep irau ndaman 930, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ndaman tooni irau 105, ve yesuru azaawa tipoop natuzi aidaaba, eeza Enos. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos izi, ve Set ileep muul irau ndaman 807, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tauvene Set ileep irau ndaman 912, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos ndaman tooni irau 90, ve yesuru azaawa tipoop natuzi aidaaba, eeza Kenan. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan izi, ve Enos ileep muul irau ndaman 815, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tauvene Enos ileep irau ndaman 905, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ndaman tooni irau 70, ve yesuru azaawa tipoop natuzi aidaaba, eeza Malalel. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malalel izi, ve Kenan ileep muul irau ndaman 840, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tauvene Kenan ileep irau ndaman 910, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalel ndaman tooni irau 65, ve yesuru azaawa tipoop natuzi aidaaba, eeza Yared. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yared izi, ve Malalel ileep muul irau ndaman 830, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tauvene Malalel ileep irau ndaman 895, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared ndaman tooni irau 162, ve yesuru azaawa tipoop natuzi aidaaba, eeza Enok. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok izi, ve Yared ileep muul irau ndaman 800, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tauvene Yared ileep irau ndaman 962, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok ndaman tooni irau 65, ve yesuru azaawa tipoop natuzi aidaaba, eeza Metusela. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Metusela izi, ve Enok ileep muul irau ndaman 300, ve tipoop natuzŋa zitamoot ve zilivaa siriv. Enok lepoogh tomania laghooŋ tooni, i maata iŋgalŋgal Maaron ve itaghon eez tooni irau saawe. Tauvene ileep irau ndaman 365, ra Maaron ighamu gha izala, ve tighita muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ndaman tooni irau 187, ve yesuru azaawa tipoop natuzi aidaaba, eeza Lamek. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek izi, ve Metusela ileep muul irau ndaman 782, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tauvene Metusela ileep irau ndaman 969, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek ndaman tooni irau 182, ve yesuru azaawa tipoop natuzi aidaaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek isaav ighe: “Maaron ivaghamunia taan, tauta nigham uraat tiina kat to niil lemai aniiŋ. Eemon natumai tane pale igham uleeŋ ivot payei pa uraat pataŋani tau nighamghamu pa nimamai ne.” Tauta iwaat naatu eeza Noa. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa izi, ve Lamek ileep muul irau ndaman 595, ve tipoop natuzŋa zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tauvene Lamek ileep irau ndaman 777, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa ndaman tooni 500, ra yesuru azaawa tipoop natuzŋa zitamoot tol, ezazi Sem, Ham, ve Yapet. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Saawe tau tamtamon timasa timin naol izi taan, Maaron natŋa tighita tamtamon natuzlivaŋa paghunazi kat. Tauvene tigham zi irau tauzi lolozi, ve tivai zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yoova ighita gabua tana, ve isaav ighe: “Tamtamon, ene yes taan sorok. Avuvug irau ileep tomani zi, ve tileep matazi yaryaare le alok ne mako. Pale tileep irau ndaman ndiŋndiŋ ee tamoot ee (120) mon, ve saawe toozi isov ve timaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Saawe tana ve ilam, tamtamon tau anoŋazi tintiina ve tapirizi kat tivot ve tileep izi taan. Tamazŋa, ene Maaron natŋa. Ve tinazŋa, ene tamtamon to taan natuzlivaŋa. Zeran tawe tileep muuŋ. Yes tapirizi tiina ve zeran to malmal, ve varuzi ilaan irau nugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yoova ighita tamtamon tau tileep izi taan na, gabuazi isaghat kat, ve ŋgar toozi iyaryaaŋ pa ŋgar sasaghati mon irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Tauvene loolo ipataŋan kat pa tamtamon tau i tauu ighur zi tizi taan na, ve isaav pa tauu ighe: “Wais, nagharaat zi mako, kanaŋ poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tambaaŋo. Yau aat napasov tamtamon le tisov pa taan. Ve yes mon mako. Ŋgai, man, ve gabua naol isov tau tikakarau izi taan na paam, yau aat napasov zi pa taan ve tisov tilalez. Onoon, yau taug naghur zi. Eemon tigham ŋgar sasaghati naol. Tauta tigham ghau tinig imum pazi kat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Eemon Noa, Yoova ighita ighe i ŋeer poia, ve loolo pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ene sinaiŋ to Noa tomania paaghu tooni. Saawe to Noa, i mon ta ŋeer duduuŋa, ve le sosor mako. Lepoogh to Noa tomania laghooŋ tooni, i maata iŋgalŋgal Maaron, ve itaghon eez tooni irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa natŋa tol, ezazi Sem, Ham, ve Yapet. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Saawe tana, Maaron ighita ŋgar sasaghati kat ivot irau taan isov. Ve ŋgar to ghamuuŋ malmal paam, ivot tiina le irau nugh. Tauvene i ighita taan isaghat kat. Pasaa, tamtamon tisov tivaghamunia lepoogh toozi izi taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tauvene Maaron isaav pa Noa ighe: “Ulooŋ. Yau naghita tamtamon tighamgham malmal irau taan isov. Tauta nagham ŋgar naghe napasov tamtamon pa taan. Yau pale navaghamun zi tomania taan ve gabua naol tau tileep ve tigheen izi taan na, le tisov tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tauvene yo aat uvaghuz lem waaŋ eta. Ughita ai ariaŋazi, ve usap zi, leso uvaghuz waaŋ pani. Urav motmotin waaŋ loolo imin naol. Ve uŋgal zimir ila waaŋ loolo ve muuri paam. Leso te iloŋ ila sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ene eez tau yo aat utaghoni: Malaua to waaŋ, uroova irau roov tamoot tol saŋavul ve liim (133 mita), ve tuuku tooni irau roov saŋavul ve ru (22 mita), ve loolo izala saaŋa ve izilam siiŋa, ene irau roov liim ve ru (13 mita). ");
INSERT INTO tuc_t_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ve urau waaŋ ruuma. Eemon urav didiiŋ izala koŋia sov. Upul sooso rig. Leso yaghur tomania ghazooŋa itaghoni. Ve ughur ataman ila waaŋ ziige. Saawe tau yo uvaghuz waaŋ, ughur loolo imin sosoor tol: ee igheen siiŋa, ite igheen bodbodaaŋ, ve ite igheen saaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ulooŋ. Yau naghe nagham yaa ivon toman tapiri tiina le itavtav taan. Leso irewaar gabua tau matazi yaryaare ne tisov tilalez. Gabua naol isov tau tileep izi taan, aat tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Eemon yau aat nambu saveeŋ ariaaŋ tomani ghom, leso tavalupu ghiit tamin eemon. Tauvene yo aat ugham azuwam, ve natumŋa tol toman azuazŋa, ve yamŋa aloŋ ala waaŋ loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ve uyau gabua maata maata tau matazi yaryaare na, ve asov aloŋ ala waaŋ loolo. Ugham ŋgai, man, ve gabua naol tau tikakarau ila taan paam. Ugham ruŋaruŋa, tamoot ve upin. Leso timaat sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ve uyau aniiŋ maata maata ve ughuru iloŋ ila waaŋ loolo paam. Leso yam ve gabua naol tau yamŋa aleep ila waaŋ loolo na, lemim aniiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Maaron isavia saveeŋ tana le isov, ra Noa ila ve igham uratoi gabua isov tau Maaron isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Murei ra, Yoova isaav pa Noa ighe: “Yau naghita tamtamon tau tileep pa saawe tane na, yo zigom ta duduŋam ila matag. Tauvene uburig, ugham azuwam toman natumŋa tol ve azuazŋa, ve yamŋa aloŋ ala waaŋ loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ve ŋgai maata maata tau popoiazi pa watooŋrau na, ugham zitamoot liim ve ru ve upin liim ve ru, tiloŋ tila waaŋ loolo. Ve gabua siriv tau popoiazi pa watooŋrau mako na, ugham ruŋruŋa, tamoot ee ve upin ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ve ugham man maata maata tau tirovroov ila taitai saamba na paam. Ugham zitamoot liim ve ru, ve upin liim ve ru. Leso timaat sov, ve murei na tipoop, ve timasa timin naol, ve tirau taan muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pasaa, mboŋ liim ve ru tane isov, mako nagham uman tiina izi taan le irau mboŋ tamoot ru. Leso napasov gabua matazi yaryaare naol isov tau naghur zi na, ve tisov pa taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yoova isavia saveeŋ tane le isov, ve Noa ila igham uratoi gabua isov tau Maaron isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ndaman tooni irau 600, ra yaa ivon izi taan toman tapiri tiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tauvene Noa yesuru azaawa, natŋa, ve raulivaŋa, tisov tiloŋ tila waaŋ loolo. Leso yaa ivaghamun zi sov, ve tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ve ŋgai maata maata tau popoiazi pa watooŋrau, tomania gabua naol tau irau tigham zi pa watooŋrau mako na, ve man tau tirovroov, tomania gabua naol tau tikakarau ila taan, ene ruŋruŋa, tamoot ve upin, tila tivot to Noa, ve yesŋa Noa tiloŋ tila waaŋ loolo itaghon saveeŋ tau Maaron isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tiloŋ tila waaŋ loolo, ve tileep mboŋ liim ve ru le isov, ra yaa ivon toman tapiri tiina, le itav taan naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tauvene indeeŋ Noa ndaman tooni irau 600, kaiyo imin ru, ve mboŋ imin saŋavul liim ve ru, ra taan aavo ikaak, ve yaa tiina tau igheen taan loolo na, bolokia izaa toman tapiri tiina. Ve sambam saamba tauvene paam. Aavo ikaak ve yaa tau igheen saaŋa na, izi toman tapiri tiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tauvene uman tiina kat izi taan le irau mataaz tamoot ru ve mboŋ tamoot ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Saawe duduuŋ tana, Noa yesuru azaawa, ve natŋa tol, Sem, Ham ve Yapet, tomania azuwazŋa, tiloŋ tila waaŋ loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ve ŋgai maata maata to nughei ve su, tomania gabua maata maata tau tikakarau ila taan, ve man maata maata titaghon zi gha yesŋa tiloŋ tila waaŋ loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Tauvene gabua naol isov tau matazi yaryaare na, ruŋruŋa, tamoot ve upin, tiloŋ tila waaŋ loolo itaghon Maaron aliiŋa. Ra Noa aana iloŋ ila ve Yoova tauu ipoon ataman to waaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Yaa ivon izaa le itavtav taan irau mboŋ tamoot ru, ve ipapot waaŋ gha izaa ipot. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yaa izaa izaa le waaŋ imoghan. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yaa izaa le ivon toman tapiri tiina kat le itavtav loloz tintiina naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Yaa ivon izala le iliiv loloz dabazi naol isov irau roov paaŋ (8 mita). ");
INSERT INTO tuc_t_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tauvene gabua tau tilepleep izi taan na, timataar tisov. Ŋgai to nughei, ŋgai to su, man, ve gabua naol tau tikakarau ila taan na, tomania tamtamon paam timataar le tisov kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Gabua naol isov tau tileep izi taan ve tighamgham yaghur, tauta tisov tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ene eez tau Maaron ipasovuur gabua naol isov pa taan. Tamtamon, ŋgai, gabua tau tikakarau ila taan, ve man tau tirovroov ila taitai saamba, eta ileep muul mako. Tisov tilalez. Eemon yes tau tileep tomania Noa ila waaŋ loolo na, yes mon ta tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tauvene yaa itav taan, ve ipot irau mboŋ 150 (kaiyo liim ma vene). ");
INSERT INTO tuc_t_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Eemon Maaron maata iŋgalŋgal Noa ve gabua naol isov to su ve nughei tau tileep tomania ila waaŋ loolo na. Tauvene igham yaghur ilaan izala yaa paavo to ivuvuur yaa leso imaak. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ve taan aavo tau yaa ivotvot pani tomania sambam saamba aavo tau yaa izi pani na, tivool muul, ve uman imot. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Tauta yaa imaak poipoi irau mboŋ 150. Indeeŋ kaiyo imin liim ve ru, ve mboŋ imin saŋavul liim ve ru, waaŋ ilot izala loloz ee to taan Ararat daaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yaa imaak izizi le kaiyo saŋavul, ve mboŋ imin maata, ra loloz dabazi peria. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Mboŋ tamoot ru paam ilam ila, ra Noa ikaak sooso rig tau papazoge ighuru pa yaghur itaghoni na, ve imbaaŋ man kool ee ila. Man tawe ivarovroov le yaa imaak kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noa ighe iwatagh: Yaa imaak wa, ma soone? Tauvene imbaaŋ mbuun ee ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Eemon yaa imaak kat soone. Tauvene mbuun tawe irau indeeŋ niia poia eta to mariaoŋ mako, ve iroov imuul ila pa waaŋ. Noa izuzuun niima ivot ila muuri, ve mbuun iroov ilam imbutur izala, ve Noa ighamu iloŋ ila waaŋ loolo muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa isaŋan le mboŋ liim ve ru isov, ra imbaaŋ mbuun iroov muul ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ila irovroov le ravrav izi, ra iŋaaŋ ai oliv mbiila ee ila dadabu, ve iroov imuul ila pa waaŋ. Tauvene Noa iwatagh ighe yaa imaak wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa isaŋan le mboŋ liim ve ru muul isov, ra ipul mbuun iroov muul ila. Saawe tana, ila le imuul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tauvene indeeŋ Noa ndaman tooni irau 601, kaiyo imin maata ve mbooŋi imin maata, ene taan imamaas wa. Tauvene Noa ipas atov siriv pa waaŋ gha itiir nugh, ve ighita taan imamaas. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Indeeŋ kaiyo imin ru, ve mbooŋi imin tamoot ee liim ve ru, taan igorgor kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Tauvene Maaron isaav pa Noa ighe: “Yo tomania azuwam, natumŋa, ve rawamlivaŋa, apul waaŋ, ve avot ala muuri. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ve ugham gabua matazi yaryaare naol tau yamŋa aleep ila waaŋ loolo na tivot tila muuri paam. Leso tilaagh irau taan ve timasa timin naol, ve tileep irau taan muul.” ");
INSERT INTO tuc_t_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tauvene Noa yesuru azaawa, natŋa, ve raulivaŋa tipul waaŋ, ve tivot tila muuri. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ve ŋgai maata maata, man, gabua naol isov tau tikakarau ila taan, ene tisov tighur zi ila sosoor toz toz, ve tipul waaŋ gha tivot muuri paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ra Noa indou maet imin artaal pa Yoova. Ve ŋgai ve man tisov tau popoiazi pa watooŋrau na, i igham eŋaeŋa ve irav zi timaat. Ra ighur zi tizala artaal paavo gha yav ighan dodolin zi imin watooŋrau pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yoova inuŋuz watooŋrau tawe vaazi poia kat, ve isaav ila loolo ighe: “Murei, yau aat irau navaghamunia taan pa sosor to tamtamon muul mako. Pasaa, yau nawatagh: Saawe tau yes geegeu ve ilam, ene ŋgar sasaghati igheen ariaaŋ ila lolozi. Tauvene yau aat irau navaghamunia gabua matazi yaryaare muul imin tau aazne naghamu ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Aazne ve ila, saawe to vazoghiiŋ aniiŋ, ve saawe to mariri, saawe to nugh iyauŋ, ve saawe to nugh ituntun, ragh ve yavaar, mboŋ ve mataaz. Gabua naol tana irau tisov ne mako. Pale tighengheen tauvene mon taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Maaron ighur poia tooni izaa to Noa tomania natŋa, ve isaav pazi ighe: “Apoop, ve amasa amin naol, ve aleep irau taan muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ŋgai maata maata tau tileep izi taan, tomania man, iigh, ve gabua soroksorok tau tikakarau ila taan, ene aat matazi izaa ve tiroi payam. Yau naghur zi tilat nimamim. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Muuŋ, naghur gabua tau titum ila taan timin aniiŋ payam. Ve aazne, yau napul gabua matazi yaryaare ta naol ne payam paam, leso aghan zi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Gabua eemon tau yau naŋgalsekin gham pani. Gabua miiza tau siŋ igheen ila na, yam aghani sov. Pasaa, siŋ ta imin puughu pa gabua tileep matazi yaryaare. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tauvene isaav ighe ŋeer eta, ma ŋgai eta irav tamtamon imaat, yau Maaron naghur atuya pani tauvene: I aat imaat paam. Leso iyat siŋ tau i iliŋi na. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tauvene ŋeer eta isaav ighe irav tamtamon ite imaat, ene pale i paam tiravu imaat. Leso iyat siŋ tau i iliŋ na. Pasaa, Maaron ighur tamtamon tigham i tauu naagho. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","8","Ra Maaron isaav muul pa Noa toman natŋa ighe: “Yam apoop, ve amasa amin naol kat, ve aleep irau taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ve alooŋ. Yau naghe nambu saveeŋ pa yam, ve paaghu tsiam tau pale tivot murei. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ve yam mon mako. Gabua matazi yaryaare naol isov to nughei ve su tau tileep tomani gham ila waaŋ loolo, ve yamŋa avot ala muuri gha aazne aleep izi taan ne, saveeŋ mbuaaŋ tsiau tane iŋarui zi paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yau nambu saveeŋ ariaaŋ payam tauvene: Irau nagham yaa ivon muul toman tapiri tiina to navaghamunia gabua matazi yaryaare mako. Ve taan tauvene paam. Yaa irau ivaghamunia muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ve Maaron isaav muul ighe: “Taliŋbuuz tsiau tau igheen izala taitai, ene naghuru imin ilaal pa saveeŋ mbuaaŋ tsiau tane. Saveeŋ tane, yau nambua tomani gham, ve gabua matazi yaryaare isov tau tileep tomani gham izi taan. Saveeŋ tane pale iyooz ariaaŋ taghon taghon gha ila. Tauvene taliŋbuuz pale imin ilaal pa saveeŋ mbuaaŋ tau yau nambua tomania gabua naol isov tau tileep izi taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Murei, isaav ighe yau naghur taitai iyooz tomania taliŋbuuz, ene aat matag iŋgal saveeŋ tau nambua tomani gham ve gabua matazi yaryaare isov. Saveeŋ mbuaaŋ tauvene: Yaa irau ivon le ivaghamun gham muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tauvene taliŋbuuz ighe ivot tomania taitai, ene aat naghita, ve matag iŋgal saveeŋ tau nambua tomania gabua matazi yaryaare isov tau tileep izi taan. Saveeŋ tane pale iyooz tauvene taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tauvene Maaron isaav pa Noa ighe: “Taliŋbuuz, ene imin ilaal pa saveeŋ tau yau nambua tomania gabua matazi yaryaare isov tau tileep izi taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa natŋa tol tau yesŋa tileep waaŋ loolo ve tivot muuri na, ezazi tauvene: Sem, Ham, ve Yapet. Ham naatu, ene Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Eval tisov tau tileep izi taan, ene tivot ila to Noa natŋa tol tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa, i ŋeer to ghamuuŋ uraat pa uum, ve i ta ivazogh vaen imin maata. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Saawe ee, i ighun vaen le iyamaan tauu mako, ve kawaal tooni imaruat. Tauvene igheen tiini ŋginaaŋa ila balbaal tooni loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Noa naatu Ham, tau Kanaan taama na, ighita taama igheen tiini ŋginaaŋa, ve ivot ila muuri gha ipaes pa tooghŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Eemon Sem yesuru Yapet tigham uuli ee, ve tisiki izala avarazi, ve tilaagh pa murizi tila, ve tipoon tamazi pani. Pasaa, lolozi pa tighita tamazi tiini ŋginaaŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Saawe tau Noa iburig gha ŋgar tooni ighazooŋ, ilooŋ tighe naatu Ham ighita igheen tiini ŋginaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tauvene isaav pani ighe: “Pataŋani tane pale iŋarui Kanaan. I tomania paaghu tooni pale timin besooŋa sorok pa toŋvetaz toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","Ve Noa ighur poia izaa to Sem gha Yapet tauvene: “Iit tapakur Yoova. I Maaron to Sem. Kanaan paaghu tooni pale timin uraata sorok pa paaghu to Sem. Ve Yapet paaghu tooni, Maaron pale igham zi timasa timin naol, ve izuur taan toozi ila imin tiina. Yesŋa Sem paaghu tooni pale tilup zi timin eemon. Eemon yes Kanaana pale timin uraata sorok pa Yapet paaghu tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Yaa ivon toman tapiri tiina le isov, ra Noa ileep muul irau ndaman 350. Tauvene ndaman tooni imin 950, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ene pitiiŋ to Noa tomania natŋa ve paaghu toozi. Noa natŋa, ene: Sem, Ham, ve Yapet. Yaa ivon toman tapiri tiina le isov, ra paaghu toozi tivot tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapet natŋa, ene: Gomer, Magog, Madai, Yaban, Tubal, Mesek, ve Tiras. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer natŋa, ene: Askenaz, Ripat, ve Togarma. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaban natŋa, ene: Elisa, Tarsis, Kitim, ve Dodanim. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yes tane ta Yapet timŋa. Yes tivot timin naol, ve tila tileep irau nari ve sisi. Puughu toozi eŋaeŋa tila tileep irau nugh toz toz, ve tisavia tauzi aliŋazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham natŋa, ene: Kus, Isip, Put, ve Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ve Kus natŋa, ene: Seba, Avila, Sapta, Rama, ve Sapteka. Rama natŋa, ene: Siba ve Dedan. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus naatu ite, eeza Nimrot. Nimrot, eeza tiina kat pasaa, i irau kat pa ŋgar to ghamuuŋ malmal. Iliiv eval tiina to taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ve i ŋeer to ilooŋ ŋgai sagsag. Tauvene murei, isaav ighe tipait ŋeer eta eeza, mako tiparim pani tauvene: ‘Ŋeer tane, Yoova igham le ŋgar tiina pa ilooŋ ŋgai sagsag imin Nimrot.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrot iŋgin taan sirivu tiina ee, eeza Sinar. Taan tawe, nugh tintiina tol tigheen ila, ezazi Babel, Erek, ve Akad. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Murei ra, Nimrot ipul taan to Babilon, ve ila pa taan sirivu to Asiria, ve ipaburigin nugh tintiina paaŋ, ezazi Ninive, Reobot-Ir, Kala, ve Resen. Nugh Resen, ene igheen bodbodaaŋ pa nugh tiina Ninive ve nugh Kala. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isip natŋa, ene: Lud, Anam, Leap, Naptu, Patrus, Kaslu, ve Kaptor. Kaslu ta yes Pilistia tivot ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","19","Kanaan naatu aidaaba Sidon, ve tazŋa, ene: Het, Yebus, Amor, Girgas, Hiv, Aki, Sini, Arvad, Semar, ve Amat. Murei, ra paaghu to Kanaan timbiriis, ve tila tileep tirau nugh toz toz. Taan toozi ila imuul ta nugh Sidon, ve itaghon nari ila imuul nugh Gerar ve nugh Gaza. Ra imbutu iloŋ ila pa taan to nugh Sodom, Gomora, Adma, ve Seboim, le malmali ila ivool pa nugh Lasa. Ene taan to yes Kanaana. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yes tana, ta tivot ila to Ham. Yes tivot timin naol, ve puughu toozi eŋaeŋa tila tileep irau nugh toz toz, ve tisavia aliŋazi ite ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yapet toogha Sem natŋa timasa timin naol, ve timin puughu pa Eber. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem natŋa, ene: Elam, Asur, Apaksad, Lud, ve Aram. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram natŋa, ene: Uz, Ul, Geter, ve Mas. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apaksad naatu Sela. Ve Sela naatu, Eber. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber natŋa ru. Ee eeza Peleg, ve ite eeza Yoktan. Saawe tau Peleg ileep izi taan, tamtamon to taan tivalagh tauzi, ve tila tileep lez lez. Tauta tiwaat eeza Peleg. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Yoktan natŋa, ene: Almodad, Selep, Azamavet, Yera, Adoram, Uzal, Dikla, Obal, Abimael, Seba, Opir, Avila, ve Yobab. Yes tisov tane Yoktan natŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Taan toozi, nugh Mesa imin ŋgat pani, ve ila imuul loloz to taan Separ tau igheen ila pa aaz puughu. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yes tana ta tivot ila to Sem. Yes tivot timin naol, ve puughu toozi eŋaeŋa tila tileep irau nugh toz toz, ve tisavia aliŋazi ite ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yes tane, Noa natŋa paaghu toozi. Yaa ivon toman tapiri tiina le isov, ra timasa timin naol, ve tila tileep irau taan ta naol ne, ve timin puughu pa eval tisov to taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Muuŋ, tamtamon tau tileep izi taan na, tisov tisavia aliŋazi eemon, ve saveeŋ toozi raraate. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yes tileep izi nugh eemon mako. Tizurzuur tiŋarui aaz puughu tila, le tivot taan duduuŋa ee tau igheen ila taan sirivu to Sinar, ve tighur niazi to lepoogh ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ra tivasavo zi tighe: “Laak! Iit aat tabuud taan ve tamozi ila yav. Leso iyaryaaŋ kat imin maet ve tagharaat ruum pani.” Tigham tauvene, ve lezi gabua ivot pa raoŋ ruum. Ve tigham gabua ite imin zimir to ikis maet tawe le tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ra tisaav tighe: “Laak! Iit aat tagharaat leen nugh tiina eta, ve tagharaat rumei tiina eta tau daaba izala lee ikis taitai. Leso ezaan imin tiina. Ve gabua ite. Uraat tiina tane pale ilup ghiit tamin eemon. Mako pale tambiriis ve taleep leen leen irau taan ta naol ne.” ");
INSERT INTO tuc_t_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yes tigham gabua tane le isov, ra Yoova izilam ighe ighita nugh toozi tiina tawe ve rumei tau tirao izala le izala kat na. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","I ighit zi ve isaav ighe: “Wai, tamtamon tilup zi timin eemon wa! Ve tisavia aliŋazi eemon, ve aazne tipaburigin uraat tiina tane paam. Murei, isaav ighe lolozi ighur pa uraat tintiina siriv, pale matazi sorok ve tighamu mon. Pasaa, gabua eta irau ipoon zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tauvene iit aat tazila ve tatoor aliŋazi ila ite ite. Leso tivaloŋai aliŋazi muul sov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Eez tane ta Yoova igham zi tipul uraat igheen, ve ivarewai zi tila tileep irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nugh tiina tawe, tiwaat eeza tighe ‘Babel.’ Pasaa, indeeŋ saawe tau tamtamon tisov to taan tilup zi izi nugh tana, Yoova itoor aliŋazi, ve ivarewai zi gha tighau tila tileep lez lez irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ene pitiiŋ to Sem toman paaghu tooni: Yaa ivon toman tapiri tiina le isov, ve ndaman ru ilam ila, ra Sem naatu aidaaba Apaksad izi. Saawe tana, Sem ndaman tooni irau ndiŋndiŋ ee (100). ");
INSERT INTO tuc_t_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apaksad izi, ve Sem ileep muul irau ndaman 500, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apaksad ndaman tooni irau 35, ve naatu aidaaba izi, eeza Sela. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela izi ve Apaksad ileep muul irau ndaman 403, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ndaman tooni irau 30, ve naatu aidaaba izi, eeza Eber. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber izi ve Sela ileep muul irau ndaman 403, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber ndaman tooni irau 34, ve naatu aidaaba izi, eeza Peleg. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg izi, ve Eber ileep muul irau ndaman 430, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ndaman tooni irau 30, ve naatu aidaaba izi, eeza Reu. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu izi ve Peleg ileep muul irau ndaman 209, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ndaman tooni irau 32, ve naatu aidaaba izi, eeza Seruk. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk izi ve Reu ileep muul irau ndaman 207, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk ndaman tooni irau 30, ve naatu aidaaba izi, eeza Naor. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naor izi ve Seruk ileep muul irau ndaman 200, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naor ndaman tooni irau 29, ve naatu aidaaba izi, eeza Tera. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera izi ve Naor ileep muul irau ndaman 119, ve natŋa zitamoot ve zilivaa siriv tizi, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ndaman tooni irau 70, ra natŋa tol tizi, ezazi Abram, Naor, ve Aran. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ene sinaiŋ to Tera ve paaghu tooni: Tera natŋa, ene: Abram, Naor, ve Aran. Aran naatu Lot. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera ilepleep soone, ve naatu Aran imaat izi tauu nugh tooni Ur tau igheen izi taan sirivu to Kaldia. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ivai Sarai, ve Naor ivai Milka. Milka yesuru Yiska tamazi Aran. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai, i ipoop mako. Pasaa, i uupa ");
INSERT INTO tuc_t_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Murei ra, Tera igham naatu Abram, tiimbu Lot tau Aran naatu na, ve rauliva Sarai tau Abram azaawa na, ve tipul nugh Ur tau igheen ila taan sirivu to Kaldia na, ve tighe tila pa taan Kanaan. Eemon tila tivot nugh Aran, ve tizi tileep ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ndaman tooni irau 205, ra imaat izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Saawe ee, Yoova ivot to Abram ve isaav pani ighe: “Abram, uburig, upul taan tsio ve tamam nugh tooni, tomania ziiri waaro tsio, ve ula. Yau aat natotoi ghom pa taan ee tau naghe uleep pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yau aat nagham paaghu tsio tivot timin naol, ve poia tsiau izaa tsio, ve nagham ezam ivot imin tiina. Ve yo pale umin eez to poia tsiau izaa to tamtamon tisov. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yes tau ighe tigham poghani ghom, ene pale poia tsiau izaa toozi. Ve yes tau tighur pataŋani payo, ene pale naghur pataŋani pazi. Ve yo pale umin eez to poia tsiau izaa to nughmariŋ to taan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yoova isavia saveeŋ tane le isov, ve Abram itaghon aliiŋa, ve iburig gha ipul nugh Aran. Lot paam iburig ve ila tomania. Saawe tana, Abram ndaman tooni irau 75 wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tauvene Abram igham azaawa Sarai, waagha Lot, ve yauyauŋ toozi tomania besooŋa tau tigham zi izi nugh Aran na, ve tiburig gha tila. Tilaghlaagh tila le tivot izi taan Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Saawe tau tivot izi Kanaan, tilaagh tila le tivot izi nugh Sekem. Nugh tawe, ai tiina ee iyozyooz, eeza More. Saawe tana, yes Kanaana tilepleep izi nugh tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ra Yoova ivot to Abram ta sewe, ve isaav pani ighe: “Paaghu tsio to murei, yau pale nagham taan tane pazi.” Tauvene Abram indou maet izi nugh tawe imin artaal pa Yoova. Pasaa, Yoova ivot tooni izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ra Abram ipul Sekem, ve ilaagh taghon loloz le ila igharau Betel. Ra ighur niia to lepoogh izi bodbodaaŋ pa nugh Betel ve nugh Ai. Nugh Betel, ene igheen ila pa yavaar, ve nugh Ai igheen ila pa ragh. Abram igharaat artaal izi ta sewe, ve isuŋ pa Yoova ve ipakur eeza. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ra Abram tomania tamtamon tooni tipaburigin laghooŋ toozi muul gha tila tivot taan sirivu to Negev tau igheen ila pa daudau puughu. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tilepleep ta sewe, le pitool tiina kat ivot izi nugh tawe. Tauvene Abram tomania tamtamon tooni tighau tizila pa Isip. Tighe tila tileep ta sewe le pataŋani to pitool isov, o timuul tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tila le tigharau Isip, ve Abram isaav pa azaawa Sarai ighe: “Ulooŋ. Yau nawatagh yo livaa paghunam kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tauvene isaav ighe yes Isipa tighit ghom, ene pale tigham ŋgar tighe: ‘Ewe Abram azaawa.’ Mako tirav ghau namaat, ve yo uzi uleep tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tauvene saawe tau tala tavot, yo aat usaav pazi ughe yo livum yau. Leso yo ndamom payau, ve tigham poghani ghau, ve naleep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Saveeŋ to Abram tane, onoon. Saawe tau tila tivot Isip, yes Isipa tighita Sarai tighe i livaa paghuuna kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tauvene yes daaba tau tiŋgin uraat to kinik na tighita, ve tila tisaav pa kinik tighe: “Aa kinik, yei nighita livaa poia ee ilepleep!” Ra tila tigham Sarai, ve tighuru ila ruum to kinik. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai ndaamo pa Abram, tauta kinik igham poghania. I igham Abram le sipsip, mekmek, makau, doŋki, ve kamel, tomania besooŋa, zitamoot ve zilivaa siriv. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Eemon Yoova ivaghamunia kinik tomania zeran tau tileep ruum tooni na pa moroghooŋ sasaghati maata maata. Pasaa, i igham Abram azaawa Sarai. ");
INSERT INTO tuc_t_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Tauvene kinik ipoi Abram ilam, ve iyaoni ighe: “Yo ugham karom payau pasaa? Sarai ene yo azuwam! Mindai ta usaav ughe yo livum? Yau naghur ila aliŋam, tauta naghamu naghe imin azuwag. Aiyo, ugham azuwam, ve yamru aghau ala!” ");
INSERT INTO tuc_t_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ra kinik isaav ariaaŋ pa yes uraata tooni ighe tiziir Abram yesuru azaawa timuul tila. Tauvene tigham Abram yesuru Sarai, ve besooŋa toozi, tomania gabua toozi naol isov, ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram yesuru azaawa, ve waagha Lot tigham gabua toozi, tipul Isip, ve timuul tila tivot taan sirivu to Negev. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram, i kuaz tauu kat. I le ŋgai ve maet silva ve gol katini. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","I ipul taan sirivu to Negev, ve ilaagh muul. Ila ivot izi nugh ee, ve imariau ta sewe. Mako ipaburigin laghooŋ muul, ve ila ivot nugh ite. Ilaghlaagh tauvene le ila ivot izi nugh tau igheen bodbodaaŋ pa nugh Betel ve nugh Ai. Ra isuŋ pa Yoova izi ta sewe. Nugh tawe, ta muuŋ i ileep pani, ve igharaat artaal ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram waagha Lot tau yesuru tilaghlaagh na, i paam, ŋgai tooni katini, ve yes besooŋa tooni naol. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tauvene yesuru irau tilup zi izi nugh eemon mako. Pasaa, yesuru lezi gabua katini, ve taan irau zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tauta Lot besooŋa tooni ve Abram besooŋa tooni tiburig ve tivazorai zi. (Saawe tana, yes Kanaana ve yes Peresa tilepleep nugh tawe paam.) ");
INSERT INTO tuc_t_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tauvene Abram isaav pa Lot ighe: “Ituru siŋ eemon. Tauvene lolog pa koi isap sosoon mako. Ve besooŋa toit paam, lolog pa koi isap sosozi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ughita. Taan tiina ighengheen. Yo aat upul ghau, ve ughita lem taan sirivu eta, leso uleep pani. Isaav ighe yo ula uleep ila pa tapir, o yau aat nala naleep ila pa ŋas. Ve ighe ula pa ŋas, o yau nala pa tapir.” ");
INSERT INTO tuc_t_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tauvene Lot maata ila ve igabiiz nugh, ve ighita taan duduuŋa tau igheen yaa Yordan ziige ve ila imuul izi nugh Zoar. Taan tawe poia, ve le yaa katini imin uum to Maaron, ma taan to yes Isipa tau paghuuna kat. Pasaa, saawe tana, Yoova ivaghamunia nugh Sodom ve Gomora soone. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tauvene Lot ipul Abram, ve ila ileep soghan. I ighe igham taan duduuŋa isov tau igheen ila yaa Yordan ziige na imin le. Tauvene iburig ve ilaagh ila pa taan ziige tau igheen ila pa aaz izaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ve Abram, i ileep izi taan Kanaan. Lot izurzuur balbaal tooni izi taan duduuŋa tawe, ve ila ila le igharau nugh Sodom, ra ileep ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Saawe tana, yes tamtamon to nugh Sodom tighamgham ŋgar sasaghati naol, le tisosor tiina ila Yoova maata. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot ipul Abram, ra Yoova isaav pa Abram ighe: “Uburig ve ugabiiz nugh. Matam ivot ila, iloŋ ila, ve matam izala ve izila. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Taan isov tau yo ughita ne, yau aat nagham pa yo tomania paaghu tsio tau murei pale tivot. Leso aleep pani taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yau aat nagham paaghu tsio timasa timin naol imin ŋgaupup to taan. Tamtamon eta irau inin zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tauvene uburig, ve ulaagh irau taan tane ve ughita. Pasaa, yau aat nagham taan isov tane imin lem.” ");
INSERT INTO tuc_t_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tauvene Abram iburig, ve izurzuur balbaal tooni ila ila le ivot izi nugh Ebron. Ra ighur niia to lepoogh igharau ai tintiina siriv to Mamre, ve igharaat artaal pa Yoova ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Saawe tana, Bera, i kinik to nugh Sodom. Birsa, i kinik to nugh Gomora. Sinap, i kinik to nugh Adma. Semeba, i kinik to nugh Zebo. Ve Kedorlaomer, i kinik to nugh Elam. Kedorlaomer iŋgin kinik paaŋ tawe tomania kinik to nugh Bela (eeza ite Zoar) irau ndaman saŋavul ve ru wa. Ve ndaman ite imin saŋavul ve tol, ene kinik liim tawe tiburig ve tizoor kinik Kedorlaomer aliiŋa. Tauvene ndaman imin saŋavul ve paaŋ, kinik Kedorlaomer imbaaŋ ila pa zeetŋa tol ve tilam. Ezazi tauvene: Amrapel, i kinik to nugh Sinar, Ariok, i kinik to nugh Elasa, ve Tidal, i kinik to nugh Goi. Kinik paaŋ tawe tomania zaaba toozi tila, ve yesŋa yes zeran to Repaim tigham malmal izi nugh Asterot-Karnaim le tiliiv zi. Ra tila pa nugh Am, ve yesŋa zeran to Zuzim tigham malmal le tiliiv zi paam. Ra tila pa taan duduuŋa to Kiriataim, ve yesŋa zeran to Enim tigham malmal le tiliiv zi. Mako tila pa taan Seir loloza, ve yesŋa zeran to Or tigham malmal le tiliiv zi, ve tinaan zi tila pa nugh El Paran, tau igheen igharau nugh ŋginaaŋa. Isov ra, timuul tila pa nugh Kades tau eeza ite En Mispat. Ve yesŋa zeran to Amalek, ve zeran to Amor tau tileep izi nugh Azezon Tamar na, tigham malmal le tiliiv zi paam. Kedorlaomer tomania zeetŋa tiliiv yes kinik tana le isov, ra kinik liim to Sodom, Gomora, Adma, Zebo, ve Bela tilup zi, ve tila pa taan duduuŋa tau eeza Sidim. Tileep ta sewe ve tisaŋan Kedorlaomer tomania zeetŋa leso yesŋa tigham malmal. Tipaburigin malmal ta sewe, ve Kedorlaomer tomania zeetŋa tiliiv kinik liim tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Taan to Sidim le puura katini tau kolta igheen ila. Tauvene saawe tau kinik to Sodom ve kinik to Gomora tomania zaaba toozi tighau, tamtamon toozi siriv titaptap tizila taan puura tawe. Ve siriv tighau tizala pa loloz. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Malmal tana isov, ra Kedorlaomer tomania zeetŋa tila tiyau lezi aniiŋ, tomania gabua isov to nugh Sodom ve Gomora, ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram waagha Lot ilepleep izi nugh Sodom paam. Tauta tighamu tomania gabua tooni isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eemon ŋeer ee ighau pa malmal, ve ila ivot to Abram tau Hibru tamazi na, ve ipaes pani pa ŋgar tau ivot na. Saawe tana, Abram ilepleep igharau nugh tau ai tintiina siriv tiyozyooz pani na. Ai tawe to ŋeer ee, eeza Mamre. I tamtamon to Amor, ve tazŋa ezazi Eskol ve Aner. Abram yesŋa zeran tol tawe, lupuuŋ toozi eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram ilooŋ paesiiŋ tighe tigham waagha Lot gha tila, tauvene ipoi besooŋa tooni irau 318 tau zeran to malmal na, ve yesŋa tiburig gha tigham taghon kinik paaŋ tawe tila. Yes besooŋa tawe, saawe tau tinazŋa tipoop zi le timin zolman, yes tileep tomania Abram, ve i itotoi zi pa ŋgar to ghamuuŋ malmal. Tila le tizaa to kinik paaŋ tawe izi nugh Dan. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tileep le mboŋ izi, ra Abram ivalagh zaaba tooni, ve tipaburigin malmal pa kinik paaŋ tawe le tiliiv zi. Tinaan zi tila tila le timalaaŋ pa nugh Damaskus, ve tila tivot nugh Oba. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ra Abram igham mulin waagha Lot tomania gabua tooni, ve zilivaa ve tamtamon siriv tau kinik paaŋ tawe tiyau zi na, tomania gabua toozi tisov. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram iliiv Kedorlaomer tomania kinik siriv tana, ra imuul ilam, ve kinik to Sodom ilam izaa tooni izi taan duduuŋa tau eeza Save. (Taan tawe, eeza ite ‘Taan duduuŋa to yes kinik.’) ");
INSERT INTO tuc_t_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kinik to nugh Salem paam, eeza Melkizedek, igham mberet tomania vaen ve ilam. Melkizedek, i ŋeer to watooŋrau, ve ibesbees pa Maaron Tiina Tau Iliiv Zimaronŋa Tisov na. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","I ighur palotiiŋ izaa to Abram ve isaav pani ighe: “Abram, Maaron Tiina tau ighur sambam ve taan ve iliiv zimaronŋa tisov na, i tauu pale ighur poia tooni izaa tsio. Iit tapakuru. Pasaa, i ighur koiamŋa tila nimam gha uliiv zi wa.” Ra Abram iburig, ve ivalagh gabua naol isov tau i iyau zi ila to koiŋa na, irau ŋgun saŋavul, ve ighur ŋgun ee ila pa Melkizedek imin paitooŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ra kinik to Sodom isaav pa Abram ighe: “Gabua naol tana, ugham zi timin lem. Eemon upul tamtamon tsiau tilam, ve yeŋa nila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eemon Abram iyol aliiŋa ighe: “Ee-e, vene mako. Yoova, i Maaron Tiina Tau Iliiv Zimaronŋa Tisov ve ighur sambam ve taan. Yau nambu saveeŋ ariaaŋa ila i eeza tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","Yau irau nagham gabua tsio ŋgiira rigta imin waar iimu, ma waar to zuzuuŋa to aghem ne mako. Mako kat. Gabua tau zaaba tsiau tighani, tauta ena. Ve zetagŋa tol tau titaghon ghau ve yeŋa nilam, Aner, Eskol, ve Mamre, ene yau leg saveeŋ eta pazi mako. Yes tauzi. Isaav ighe lolozi pa ghamuuŋ lezi gabua siriv, ene poia. Tighamu.” Abram isaav tauvene pasaa, iroi pa murei pale kinik to Sodom ipakur ghi ighe: “Yau ta nagham Abram ivot gha imin kuaz tauu.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Gabua tana isov ve murei ra, Maaron ivot to Abram ila vivuuŋ, ve isaav pani ighe: “Abram, uroi sov. Yau aat navool tsio ve namin sigheu payo. Ve yo aat ugham lem atuya tiina kat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Eemon Abram iyol aliiŋa ighe: “O Yoova, Maaron tsiau, pale ugham saa payau? Ughita. Yau leg natug eta mako. Tauvene mbesooŋa tsiau Eliezer to nugh Damaskus aat igham niag, ve igham gabua tsiau isov imin le.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ve Abram iseeŋ saveeŋ tooni muul ighe: “Yo ugham leg paaghu eta mako. Tauvene besooŋa tsiau tau tiina ipoopa izi ruum tsiau na, aat igham niag ve iyooz pa gabua tsiau ta naol ne.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tauvene Yoova isaav pa Abram muul ighe: “Mako. Besooŋa tsio tana irau igham niam, ve iyooz pa gabua tsio mako. Yamru azuwam pale apoop lemim natumim ee. I pale igham niam, ve iyooz pa gabua tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ra Maaron igham Abram gha tivot tila muuri, ve isaav pani ighe: “Matam izala ve ughita pitum tau tigheen izala sambam saamba we. Irau unin zi? Paaghu tsio pale timasa timin naol kat imin pitum tawe.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ilooŋ saveeŋ tane, ve ighur ila ighe Maaron saveeŋ tooni pale ighur anooŋa. Tauta Maaron ighita ighe i ŋeer duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ra Maaron isaav pani muul ighe: “Yau Yoova, Maaron tsio. Yau ta nagham ghom upul nugh tsio Ur tau igheen ila taan sirivu to yes Kaldia, leso nagham taan tane imin lem.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eemon Abram iyol aliiŋa ighe: “O Yoova, Maaron tsiau, pale ugham saa imin ilaal payau, leso nawatagh kat naghe: Taan tane pale imin leg motot?” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tauvene Maaron isaav pani ighe: “Ugham makau upin ee tau ndaman tooni tol, mekmek upin ee tau ndaman tooni tol, ve sipsip tamoot ee tau ndaman tooni tol na, tomania mbuun ru tilam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tauvene Abram ila iyau gabua tawe tisov tilam, ve irav zi timaat. Ra ipaal zi timin ru, ve iraar zi tizi. Ve man ru tawe, i irav zi paam. Eemon ipaal zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ra manbog siriv tilam tighe tighan gabua tawe. Eemon Abram inaan zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Aaz ighe izila, ve Abram izi igheen le loolo iveegh kat. Malau mako ve ndoroom tiina kat izi ikauu, le roiŋ tiina ighamu. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ra Maaron isaav pani ighe: “Mboŋ aazne, yau aat nasavia gabua tau murei pale ivot pa paaghu tsio. Yes pale tila tileep izi nugh ite timin loom. Nugh tawe tamtamona pale tigham zi timin besooŋa sorok, ve titatan zi ve tigham saghatin zi irau ndaman ndiŋndiŋ paaŋ (400). ");
INSERT INTO tuc_t_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Eemon murei, yau pale naghur atuya pa nugh tawe tamtamona. Ve paaghu tsio pale tiyauur lezi gabua naol to zeran tawe, ve tipul taan toozi, ve timuul tilam taan tane. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Eemon yo pale uleep poia mon le umin kooŋ kat, o umaat ve titavi ghom. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tauvene paaghu tsio pale irau timuul tilam pa taan tane rekia mako. Pale tileep malau izi nugh tawe, le saas toozi tivot, o timuul tilam. Pasaa, yes Amora tau tilepleep taan tane, pale tighamgham sosor ila ila le saawe tau naghita sosor toozi imin tiina kat, o naghur atuya pazi, ve naziir zi tila. Leso paaghu tsio tigham taan tane imin lezi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Saawe tau aaz izila ve nugh ndoroom kat, uur ee tau yav mbuasa izazaa pani, tomania sul ee tau yav ighanghan ila na, tivot ve tilaghlaagh ila gabua tau Abram irav zi na sosozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mboŋ tana, Yoova imbu saveeŋ tomania Abram ighe: “Taan isov tane, yau nagham pa paaghu tsio. Taan tsiam pale izi yaa to yes Isipa, ve ila imuul yaa tiina Euprates. ");
INSERT INTO tuc_t_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Taan tawe, ene to yes Kenia, Kenisa, Kadmona, Hita, Peresa, Repa, Amora, Kanaana, Girgasa, ve Yebusa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram azaawa Sarai, i ipoop Abram le naatu eta soone. Eemon i le besooŋa livaa ee to Isip, eeza Agar. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saawe ee, Sarai isaav pa Abram ighe: “Ulooŋ. Yoova ipoon ghau, tauta napoop mako. Tauvene yo ula to besooŋa tsiau livaa Agar, ve yamru agheen. Ighe ugham tauvene, ene aat imin eez to nagham natugŋa tivot ila tooni.” Abram ilooŋ Sarai aliiŋa ve itaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tauvene Sarai igham besooŋa tooni livaa tau Isip tinazi na, ve ighuru ila to Abram imin azaawa zazagheeŋ. Saawe tana, Abram ileep izi Kanaan irau ndaman saŋavul wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram yesuru Agar tigheen le Agar aapo. Saawe tau iwatagh ighe i aapo, ipakur tauu ve maata tatanin tiina tooni Sarai. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tauvene Sarai izi ve isuk saveeŋ pa Abram ighe: “Pataŋani tau aazne izaa tsiau, ene yo umin puughu pani! Onoon, yau taug naghur besooŋa tsiau livaa ilat tsio. Eemon saawe tau iwatagh ighe i aapo, maata tatanin ghau kat. Maaron tauu pale igabiiz ghiit, ve ighur atuya iŋarui sei tau igham sosor!” ");
INSERT INTO tuc_t_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram iyol aliiŋa ighe: “Ughita. Besooŋa tsio livaa tawe, i ileep ila taum nimam. Saa ŋgar tau yo ughe ugham pani, na ughamu mon.” Tauvene Sarai igham saghatin Agar, le Agar iburig gha ighau. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Agar ilaagh ila pa nugh ŋginaaŋa le ivot izi yaa ee, tau bolokbolokia izazaa igharau eez tau ila pa taan sirivu to Sur. I ila ivot ta sewe, ve Mbaŋooŋa to Yoova ivot tooni, ve ighasoni ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Agar, besooŋa livaa to Sarai, yo uleep sindei ta ulam? Ve ughe ula sindei?” Agar iyol aliiŋa ighe: “Yau naghau pa tiina tsiau Sarai.” ");
INSERT INTO tuc_t_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mbaŋooŋa to Yoova isaav pani muul ighe: “Umuul ula pa tiina tsio Sarai, ve uleep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yau pale nagham paaghu tsio timasa timin naol. Irau to tinin zi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ve Mbaŋooŋa to Yoova isaav pani muul ighe: “Yo apom. Ve pale upoop natum tamoot. Yo aat uwaat eeza Ismael. Pa Maaron ilooŋ taŋiiz tsio wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Natum tana pale ivalaghlaagh imin ŋgai sagsag, ve ighur koi pa tamtamon tisov. Ve tamtamon tisov pale tighur koi pani paam. Tauvene i tomania toŋvetaz tooni, koi pale isap sosozi, ve tileep soghan soghan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yoova isavsaav tomania Agar le isov, ra Agar igham ŋgar pa gabua tau ivot pani na, ve isaav ighe: “I tau ighitghit ghau irau saawe, tauta yau naghita izi sene.” Tauvene iwaat Yoova eeza ighe ‘El-Roi.’ Saveeŋ tane, puughu tauvene: ‘Maaron tau ighitghit ghau.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tauta tiwaat yaa naliu to nugh tawe tighe: ‘Yaa bolokbolokia to Maaron maata yaryaare tau ighitghit ghau.’ Yaa tawe igheen bodbodaaŋ pa nugh Kades ve nugh Bered. ");
INSERT INTO tuc_t_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Abram ndaman tooni 86, ve Agar ipoop Abram le naatu tamoot. Ve Abram iwaat eeza Ismael. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","2","Abram ilepleep le ndaman tooni irau 99, ra Yoova ivot tooni muul, ve isaav pani ighe: “Yau Maaron Saksaki Tau Naliiv Zimaronŋa Tisov. Laghooŋ tsio, yo aat matam iŋgal ghau, ve utaghon ŋgar duduuŋa mon ila yau matag. Leso napariaaŋ saveeŋ mbuaaŋ tsiau tomani ghom, ve ituru talup ghiit tamin eemon, ve nagham paaghu tsio timasa timin naol.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ilooŋ saveeŋ tane, ve iput aaghe ve ighur naagho izila pa taan. Ra Maaron isaav pani muul ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Ulooŋ. Saveeŋ mbuaaŋ tsiau tomani ghom, ene vene: Yo pale umin nughmariŋ tamazi. Pasaa, yau pale nagham paaghu tsio tivot timin nugh nugh pughuzi. Tauvene aazne ve ila, yo aat ezam Abram muul mako. Ezam paaghu, ene Abaram. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yau pale nagham paaghu tsio timasa timin naol, ve timin nugh nugh pughuzi. Ve siriv pale timin kinik. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Saveeŋ tau aazne nambua tomani ghom, murei pale napariaaŋa muul tomania natumŋa, timbumŋa, ve iseeŋga taghon taghon gha ila. Tauvene saveeŋ mbuaaŋ tane pale iyooz ariaaŋ tauvene le alok. Saveeŋ tauvene: Yau aat namin Maaron tsio, ve Maaron to paaghu tsio tau murei pale tivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ve taan isov to Kanaan tau aazne uleep umin loom pani ne, yau pale nagham payo ve paaghu tsio tau murei pale tivot. Taan tane pale imin lemim to aleep pani taghon taghon gha ila. Ve yau pale namin Maaron to paaghu tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Maaron isaav muul pa Abaram ighe: “Yo tomania paaghu tsio aat matamim iŋgalŋgal saveeŋ mbuaaŋ tsiau tane ve ataghoni irau saawe. Ilaal to saveeŋ mbuaaŋ tane, ene vene: Yo tomania paaghu tsio zitamoot tisov tau pale tivot murei na, aat arav waromim. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Ulimim tau ipoon waromim maata na, arav motin zi. Leso imin ilaal pa saveeŋ mbuaaŋ toit. Saveeŋ tane pale igheen tauvene le alok. Tauvene aazne, ve taghon taghon gha ila, isaav ighe natumimŋa zitamoot tizi le mboŋizi imin liim ve tol, mako arav warozi. Ve besooŋa tsiam tau tinazŋa tipoop zi izi ruum tsiam, tomania besooŋa tsiam siriv tau aghol zi izi nugh ite ve agham zi tilam na, ene yes paam, arav warozi. Tauvene ilaal to saveeŋ mbuaaŋ tsiau aat igheen ilat tsiam taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","“Isaav ighe tamoot eta, loolo pa tirav waaro mako, i aat irau ileep tomani gham muul mako. Aziire ila ileep soghan payam. Pasaa, i izoor saveeŋ mbuaaŋ tsiau tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ra Maaron isaav muul pa Abaram ighe: “Yo irau uwaat azuwam eeza Sarai muul mako. Aazne ve ila, uwaat eeza Sara. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Pa poia tsiau pale ipaloti, leso ipoop lem natum tamoot eta. Ve paaghu tooni pale tivot timin katini, ve timin nugh nugh puughu toozi. Ve kinik siriv pale tivot ila toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abaram ilooŋ saveeŋ tane, ra iput aaghe ve ighur naagho izila taan, eemon iŋiŋ ve loolo ighur ighe: “Wai, ene yau namin kooŋ wa. Isaav ighe ŋeer eta ndaman tooni irau ndiŋndiŋ ee (100), pale irau yesuru azaawa tipoop? Ve Sara paam, ndaman tooni irau tamoot paaŋ saŋavul (90). Pale irau ipoop?” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tauvene Abaram isaav pa Maaron ighe: “Poia. Eemon natug Ismael ilepleep. Yau naghe poia tsio izaa tooni ve uŋgin ileep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eemon Maaron iyol aliiŋa ighe: “Mako. Azuwam Sara tauu pale ipoop lem natum tamoot. Natum tawe, yo aat uwaat eeza Isak. Yau pale napariaaŋ saveeŋ mbuaaŋ tsiau tomania i tauu ve paaghu tooni tau pale tivot murei na, ve iseeŋga taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Eemon yo ughason ghau ughe matag pa Ismael paam, tauvene yau aat nagham tauvene. Poia tsiau pale izaa tooni, ve nagham paaghu tooni tivot timin naol, ve ezazi tintiina. Daaba saŋavul ve ru pale tivot ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Saawe tane ighe ivot muul pa ndaman murei, mako Sara ipoop Isak. Ve natum tana, ta pale napariaaŋ saveeŋ mbuaaŋ tsiau ila tooni ve paaghu tooni paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Maaron isavsaav tomania Abaram le isov, ra ipuli ve ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aaz eemon tana, Abaram iburig gha irav yes zitamoot tooni tisov warozi itaghon Maaron aliiŋa. Irav naatu Ismael waaro, ve yes besooŋa tooni tisov warozi paam. Yes tau tinazŋa tipoop zi ila ruum tooni, tomania yes tau i ighol zi tilam na paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Tauvene Abaram ndaman tooni irau 99, ve naatu Ismael ndaman tooni irau saŋavul ve tol (13), ra tirav yesuru warozi. Ve saawe tana, tirav besooŋa tooni tisov warozi paam. Yes tau tinazŋa tipoop zi ila Abaram ruum tooni, tomania yes tau i ighol zi tilam na paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Murei ra, Yoova ila ivot to Abaram igharau ai tintiina to nugh Mamre. Saawe tana, zegmatuugh ve aaz ighaaz le nugh ituntun kat. Tauvene Abaram mboole izi balbaal tooni naagho ve ilepleep. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abaram maata ila, le ighita zeran tol tiyozyooz. Tauvene rekia mon ila toozi, ve iput aaghe, ve naagho izila pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ra isaav pa toozi ee ighe: “Tiina tsiau, yau besooŋa tsio. Ighe lolom payau, na usal payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Alam aleep tomani ghau ve amariau rig, o ala. Alam tala ai tawe ve mbolemim izi ila ai yavyaava, ve besooŋa tsiau tigham yaa rigta ilam to amin aghemim pani, ve tigham lemim aniiŋ rigta. Leso ipalot gham, ve alaagh muul. Pa alam avot to besooŋa tsiam wa.” Yes tiyol aliiŋa tighe: “Poia. Aat nitaghon aliŋam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tauvene Abaram ilaagh rekia mon iloŋ ila balbaal tooni loolo, ve ipasul Sara ighe: “Ugham palawa poia, ve nimam rekia pa gharatooŋ mberet irau yes tol.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ra Abaram ilaan ila pa nugh tau makau tooni tileep pani na, ve igham makau naatu ee toman tumbuuŋa, ve ighuru ila to besooŋa tooni ee. Besooŋa tawe iravu, ve rekia mon igharaata ve ipamazozaini. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Le isov, ra Abaram igham makau miiza tawe, tomania tuz to makau, ve tuz siriv tau tigharaata imin sis na, ila pa zeran tol tawe gha tighan. Abaram iyozyooz tomani zi ila ai saamba, ve yes tighanghan. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tighan le isov, ve tighason Abaram tighe: “Azuwam Sara ileep sindei?” Abaram iyol aliŋazi ighe: “I ilepleep balbaal loolo we.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Toozi ee isaav pani ighe: “Onoon kat, yau nasaav payo. Saawe tane ighe ivot muul pa ndaman murei, yau aat namuul nalam. Ve saawe tau nalam soone, azuwam Sara aat ipoop lem natum tamoot.” I isavsaav, ve Sara iyozyooz ila ŋeer tawe muuri izi balbaal aavo, ve ighurghur taliiŋa pa saveeŋ toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abaram gha Sara timin zikooŋ, ve Sara saawe tooni to popaaŋ isov wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tauvene Sara ilooŋ tighe i pale ipoop, ve iŋiŋ ve isaav ila loolo ighe: “Wai, yeiru azuwag nimin zikooŋ ve tapirimai imbool wa. Pale lolomai pa nilup ghei pa ghenooŋ muul mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tauvene Yoova ighason Abaram ighe: “Puughu mindai ta Sara iŋiŋ, ve isaav ighe i imin kooŋ wa, ve irau ipoop mako? ");
INSERT INTO tuc_t_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yau Yoova. Gabua eta ikeek ghau mako. Tauvene saawe tane ivot muul pa ndaman murei, yau aat namuul nalam. Ve saawe tau nalam soone, azuwam Sara aat ipoop lem natum tamoot.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara ilooŋ Yoova aliiŋa, ve iroi. Tauvene ipaisamun tauu ighe: “Wai, yau naŋiŋ mako!” Eemon Yoova isaav pani ighe: “Mako. Yo uŋiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ra zeran tol tana tighe tipaburigin laghooŋ muul. Tauvene Abaram paam ilaagh tomani zi ila ighe ighur zi. Tilaagh tila rig, ra tiyooz ve matazi izila pa nugh Sodom. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yoova isaav pa tauu ighe: “Gabua tau naghe naghamu, pale naŋgooza pa Abaram, ma navotia pani? Mako. Aat navotia pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Pasaa murei, paaghu tooni pale timasa timin naol ve ezazi tintiina. Ve i pale imin eez to poia tsiau izaa to nughmariŋ to taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yau taug nasiigho imin leg wa. Leso navotia ŋgar tsiau ila tooni, ve aana isakia ila to paaghu tooni tomania tamtamon tooni. Leso yes paam titaghon eez tsiau ve tigham ŋgar poia ve ŋgar duduuŋa, ve saveeŋ tau nambua tomania Abaram na anooŋa ivot.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","Ra Yoova isaav pa Abaram ighe: “Tamtamon to Sodom ve Gomora tinoknok ghamuuŋ ŋgar saghati kat. Ve sosor toozi vaaru tomania taŋiiz tiina to yes tau Sodom ve Gomora tighamgham saghatin zi na, ene izalam gha nalooŋa wa. Tauvene yau naghe nazila ve naghit zi. Leso nawatagh kat: Varuzi ve taŋiiz tiina tau izazalam gha naloŋlooŋa ne, ene onoon, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tauvene Yoova zeetŋa ru tilaagh malmalizi tizila pa nugh Sodom. Ve Yoova izi iyooz rig tomania Abaram. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abaram ila igharauu, ve ighasoni ighe: “Saveeŋ tsio poia. Eemon mindai? Pale uvaghamunia zeran duduŋazi tomania zeran sasaghati? ");
INSERT INTO tuc_t_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Isaav ighe zeran duduŋazi tamoot ru saŋavul (50) tileep izi nugh tawe, pale uvaghamunia nugh? Mako. Yo aat lolom isaghatin zi ve upul zi tileep. Pa zeran duduŋazi tawe ndamozi pa nugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Maaron, yo mon ta gabizooŋ tauu to tamtamon tisov to taan. Yo aat ugabiiz zi itaghon ŋgar duduuŋa. Ughita. Isaav ighe zeran duduŋazi tamoot ru saŋavul (50) tileep izi nugh tawe ve uvaghamunia nugh, ene pale urav tamtamon duduŋazi tomania yes sasaghatizi. Ighe ugham tauvene, pale iduduuŋ wa? Yo irau ughur atuya raraate pa zeran duduŋazi ve sasaghatizi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Maaron iyol Abaram aliiŋa tauvene: “Isaav ighe yau naghita zeran duduŋazi irau tamoot ru saŋavul (50) tileep izi nugh Sodom, yes aat ndamozi pa nugh tawe, ve irau navaghamun zi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ra Abaram isaav muul ighe: “O Tiina tsiau, yau avav ve ŋgaupup sorok to taan. Irau nasaav tauvene mako. Eemon nasaav wa. Tauta aat naseeŋ saveeŋ tsiau muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Isaav ighe zeran duduŋazi irau tamoot ru geege liim (45) mon tileep izi nugh Sodom, ene pale mindai? Pale uvaghamunia nugh dodoli tawe? Pa ene zeran liim mon ta mako.” Maaron iyol aliiŋa ighe: “Mako. Isaav ighe naghita zeran duduŋazi tamoot ru geege liim (45), ene irau navaghamunia nugh tawe mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abaram iseeŋ ghasoniiŋ tooni muul ighe: “Ve isaav ighe zeran tamoot ru mon tileep, ene pale mindai?” Maaron iyol aliiŋa tauvene: “Isaav ighe naghita zeran duduŋazi tamoot ru tileep, ene irau navaghamunia nugh mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tauvene Abaram isaav muul ighe: “O Tiina tsiau, atem yavyav payau sov. Yau naghe naghason ghom muul. Ighe ughita zeran duduŋazi tamoot ee saŋavul (30) mon tileep ta sewe, ene pale mindai?” Maaron iyol aliiŋa ighe: “Ene pale mako paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tauvene Abaram isaav muul ighe: “Tiina tsiau, yau nawatagh: Nakaria ghasoniiŋ ghom wa. Eemon ighe yo ughita zeran duduŋazi tamoot ee (20) mon tileep, pale mindai?” Maaron isaav pani ighe: “Ene aat mako paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ra Abaram isaav muul ighe: “O Tiina tsiau, atem yavyav payau sov. Naghe naghason ghom pai eemon tane, ve isov. Isaav ighe ughita zeran duduŋazi saŋavul mon tileep, ene pale mindai?” Maaron iyol aliiŋa ighe: “Isaav ighe tamtamon duduŋazi saŋavul tileep nugh tawe, ene pale ndamozi pa nugh, ve irau navaghamunia mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yesuru tisavsaav le isov, ra Yoova ipuli ve ila, ve Abaram imuul ila pa nugh tau ilepleep pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aŋela ru tana tilaagh tila le ravrav izi. Ra tila tivot izi nugh Sodom. Saawe tana, Lot ilepleep izi lupuuŋ niia tau igheen eez maata to nugh Sodom. Maata ila le ighita zeran ru tana tilam. Tauvene iburig ve iŋarui zi ila, ve iput aaghe, ighur naagho izila pa taan, ");
INSERT INTO tuc_t_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ve isaav pazi ighe: “O zolman tsiau, yau besooŋa tsiam. Yamru alam tala pa ruum, ve agharaat taumim, ve amariau. Itiŋa taleep, pale mboŋoozo, o alaagh muul.” Yesuru tiyol aliiŋa tighe: “Mako. Mboŋ aazne, yeiru aat nileep sorok izi ta lupuuŋ niia ne.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Eemon Lot isaav ariaaŋ pazi ighe tileep sorok izi muuri sov. Tauvene yesuru tilooŋ aliiŋa, ve titaghoni tiloŋ tila ruum tooni, leso Lot iŋgin zi ta sewe. Ra tigharaat mberet tau le yis mako na tomania aniiŋ popoia siriv, ve tigham pa yesuru gha tighan. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yesuru tighan le isov, ra tighe tigheen. Malau mako ve yes zitamoot paghpaaghu tomania zolman to Sodom, tisov tilam tilivutin ruum to Lot, ");
INSERT INTO tuc_t_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ve tipoi izala pani tighe: “Zeran ru tau ravrav tilam tsio na, tileep sindei? Usaav pazi tivot tilam muuri, leso nimogheer pazi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Tauvene Lot ivot ila, ve ipoon ataman, ve isaav pazi ighe: “O zeran tsiau, lolog pa agham ŋgar saghati tauvene mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aghita. Natug livaŋa ru ta tilepleep ne. Tamoot eta igheen tomani zi soone. Yau aat nagham zi tivot tilat tsiam. Ve saa ŋgar tau aghe agham pazi, na aghamu. Eemon agham gabua eta pa zeran ru tau tilam tileep tomani ghau ila ruum tsiau ne sov. Pa yesuru loomba. Tauvene yau aat naŋgin poghani zi le naghur zi timuul tila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yes tilooŋ saveeŋ tane, ve tisaav tighe: “Ŋeer tane nugh tauu? I loom mon. Ve aazne, ighe imin tiina ve igabiiz ghiit?” Ra tisaav pani tighe: “Ughau ula pa ziige! Yei nighe nigham ŋgar saghati pa zeran ru tana. Ve yo pale nivaghamun ghom kat!” Ra tisipiir Lot ila ziige, ve tighe tirav valaghin ataman. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Eemon zeran ru tau tileep ruum loolo na, tikaak ataman, ve tikis Lot niima, ve tigherevu iloŋ ila ruum loolo, ve tipoon ataman. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ra tigham yes tau tileep muuri we matazi ikumkuum. Tauvene titaŋtaaŋ ve tiil ataman. Tiil tiil le mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ra zeran ru tana tisaav pa Lot tighe: “Mindai, lem zetamŋa siriv tau tileep izi nugh tane? Ugham natum livaŋa, rawamŋa, ve tamtamon tsio tisov tau tileep izi nugh tane, ve yamŋa aburig ta aazne, ve aghau! ");
INSERT INTO tuc_t_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pa nugh tane vaaru saghati kat, tomania taŋiiz tiina to yes tau nugh tane tighamgham saghatin zi na, ene izala pa Yoova gha ilooŋa wa. Tauta aate yavyav kat pazi, ve imbaaŋ ghei nilam to nireu nugh tane ilale.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tauvene Lot ila to rauŋa ru tau tighe tivai natlivaŋa na, ve isaav pazi ighe: “Ai, rekia aburig ve apul nugh tane! Pa Yoova ighe ireua ilale!” Eemon yesuru tighur ila Lot aliiŋa mako. Tighe pa i igham saveeŋ mogheraaŋ pazi mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nughizau ve aŋela ru tana tipasul Lot tighe: “Uburig rekia, ve ugham azuwam tomania natum livaŋa ru, ve apul nugh tane, ve aghau ala! Mako pale alalemim tomani zi. Pa paita Yoova ireu nugh tane pa sosor toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Eemon Lot izuar pa burigiiŋ. Tauvene zeran ru tana tikis Lot gha azaawa ve natlivaŋa ru nimazi, ve tigherev zi tivot tila soghan pa nugh. Pasaa, Yoova loolo isaghatin Lot ve ighe iuule. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Aŋela ru tana, toozi ee ipasul zi ighe: “Aŋguaaz taumim ve aghau rekia ala! Matamim imulmuul sov. Apul nugh raraate tane, ve aghau azala pa loloz. Ala aleep izi eez livuugha sov. Malmalimim ala! Mako pale Yoova ipasov gham tomania tamtamon to nugh tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Eemon Lot isaav ighe: “Aa tiina tsiau, yau narao mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Onoon, yo lolom isaghav ghau kat ve lolom isaghatin ghau, tauta ugham mulin ghau ve naleep poi. Eemon loloz tawe igheen malau kat. Irau nazala rekia mako. Tauvene ighe nazuar pa laghooŋ, ve ureu nugh, pataŋani tawe aat igham ghau namaat paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ughita nugh tawe. Igheen tataŋgan. Irau rekia mon ve nala navot. Ewe nugh tiina mako, marani mon. Ighe uyok payau ve nala ta sewe, pale naleep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Aŋela iyol aliiŋa ighe: “Poia. Yau nayok pa aliŋam. Nugh marani tawe, yau aat nareua mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eemon yam alaagh rekia! Pa yau irau nagham gabua eta ivot soone, le ala avot nugh tawe.” Nugh marani tawe, eeza Zoar. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Saawe tau Lot ila ivot nugh Zoar, aaz izalam wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ra Yoova igham yav tomania maet salfa tuntunu tau vaazi saghati kat na titaptap tizi, le ireu Sodom ve Gomora. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","I ivaghamunia nugh tintiina ru tana, tomania taan raraate tau tigheen ila, ve tamtamon tisov tau tileep ila taan sirivu tawe, tomania gabua naol isov tau titum tizaa ta sewe, le tisaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Saawe tau tighau, Lot azaawa ilaagh murei ve maata imuul, le rekia mon itoor ghi imin maet tetewai ve iyooz. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","28","Mboŋoozo tana, Abaram iburig gha izala nugh mbua tau noor yesuru Yoova tileep pani ve tisavsaav na. I maata izila pa Sodom ve Gomora tomania taan raraate tau igheen siiŋa we, le ighita yav mbuasa imbuŋ izazaa le ikau taan sirivu tawe imin yav tiina ighan nugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tauvene saawe tau Maaron ireu nugh tisov tau tigheen siiŋa ila taan raraate tawe, i maata iŋgal Abaram, tauta igham mulin Lot pa pataŋani tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot loolo pa ileep malau izi nugh Zoar mako. Pasaa, iroi. Tauvene igham natlivaŋa ru, ve tighau tizala pa loloz, ve tileep ila maet puura ee loolo ta sewe imin niazi to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tilepleep le saawe ee, livaa olman isaav pa tazliva ighe: “Ughita. Tamaan imin kooŋ tane. Ve tamoot eta ileep izi taan sirivu tane to ivai ghiit mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tauvene ulooŋ. Ituru aat tapaghun tamaan pa vaen le ŋgar tooni ivaghamgham, mako tala tooni ve itiŋa tagheen. Tagham tauvene, o paaghu toit tivot ila tooni, ve siŋ toit iseeŋga taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tauvene mboŋ tana, yesuru tipaghun tamazi pa yaa vaen, le ŋgar tooni ivaghamgham. Ra livaa olman ila ve yesuru taama tigheen. Ŋgar tau i ighamu na, taama iwataghi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nughizau, livaa olman isaav pa tazliva ighe: “Noor mboŋ, yeiru tamaan nigheen wa. Tauvene mboŋ aazne, ituru aat tapaghunu pa vaen muul, ve anam ula ve yamru agheen. Leso tagham paaghu toit tivot ila tooni, ve siŋ toit iseeŋga taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tauvene mboŋ tana, yesuru tipaghun tamazi pa vaen muul, ra livaa muria aana ila gha yesuru taama tigheen. I paam, ŋgar tau ighamu na, taama iwataghi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Eez tane, ta Lot natlivaŋa ru apozi ila to tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Livaa olman aapo ve ipoop tamoot, ve iwaat eeza Moap. Yes tau tiwaat zi tighe Moapa, ene tivot ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Livaa muria ipoop tamoot paam, ve iwaat eeza Ben-Ami. Yes tau tiwaat zi tighe Amona, ene tivot ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abaram ipul nugh Mamre, ve ilaagh ila pa taan Negev, ve ighur niia to lepoogh izi bodbodaaŋ pa nugh Kades ve nugh Sur. Ileep malau rig izi ta sewe, ra iburig muul, ve ila ileep imin loom izi nugh Gerar. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Saawe tau Abaram ilepleep izi nugh Gerar, isavsaav pazi pa azaawa ighe: “Sara, ene yau livug.” Tauvene Abimelek, tau kinik to nugh Gerar na, imbaaŋ besooŋa tooni siriv tila, ve tigham Sara ila ruum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Eemon mboŋ ee, Maaron ivot tooni ila vivuuŋ, ve isaav pani ighe: “Abimelek, ulooŋ. Paita umaat! Pasaa, livaa tau ughamu na, i livaa vaivaiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Eemon Abimelek ila igharau Sara soone. Tauvene iyol aliiŋa ighe: “Wai Maaron, pale urav zeran tau lezi sosor mako ne? Abaram tauu isaav payau ighe livaa tane, i liivu. Ve Sara paam isaav ighe i liivu Abaram. Tauvene nimag igham sosor eta mako. Yau nagham gabua tane tomania ŋgar duduuŋa mon. Pasaa, yau nawatagh zi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Maaron isaav pani muul ighe: “Yau nawatagh: Yo ugham gabua tane tomania ŋgar ŋgalaaŋa mon. Puughu tane, ta napul ghom ula ugharau Sara mako, ve napoon ghom pa ghamuuŋ sosor ila yau matag. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Aazne, rekia mon ve ughur Sara imuul ila to azaawa Abaram. Pa ŋeer tawe, i propet ee. I pale ighur ghom ila suŋuuŋ tooni, leso umaat sov. Eemon isaav ighe yo ughur Sara imuul ila to azaawa mako, ene pale yo tomania tamtamon tsio asov amataar.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mboŋoozo geeg, Abimelek iburig ve ipoi besooŋa tooni tisov tilam tilup zi, ve ipaes pazi pa saveeŋ isov tau Maaron isavia pani na. Yes tilooŋ saveeŋ tooni, le roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Ra Abimelek ipoi Abaram ilam, ve iyaoni ighe: “Puughu mindai ta ugham ŋgar tane payei? Rigmon kanaŋ nagham sosor tiina kat. Yau nagham saa sosor payo, ta ugham ghau tomania tamtamon tsiau nisosor tiina ila Maaron maata? Ŋgar tau yo ugham payau na, ene iduduuŋ mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abaram iyol aliiŋa ighe: “Saawe tau yau nalam nugh tsio soone, matag iŋgal naghe: ‘Zeran to nugh tawe tiwatagh Maaron mako, ve tiroi pani mako. Pale tirav ghau namaat, ve tigham azuwag.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Saveeŋ tau nasavia payo naghe Sara, i livug, ene onoon. Pasaa, yeiru tamamai eemon. Ve tiinmaiŋa ite ite. Tauta yau irau naghamu imin azuwag. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Muuŋ, saawe tau nalepleep tomania tamaŋ, Maaron isaav payau ighe napul nugh to tamaŋ, ve nala nalaghlaagh pa taan sirivu ite. Saawe tana, yau nasaav pa Sara tauvene: Isaav ighe lolom isaghav ghau kat ve ughe ugham poghani ghau, na nugh sindei tau ituru tala pani, ve ighe tighason ghom payau, mako usaav pazi ughe: ‘Abaram, ene yau livug.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abaram isavsaav le isov, ra Abimelek igham le sipsip, mekmek, ve makau, tomania besooŋa siriv, ve ighur Sara imuul ila to Abram. ");
INSERT INTO tuc_t_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ve isaav pa Abaram ighe: “Ughita. Taan tane, ene yau tsiau. Nugh sindei tau yo ughe uleep pani, ene poia mon. Saveeŋ eta mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ve Abimelek isaav pa Sara ighe: “Ughita. Yau nagham livum le maet silva irau ndiŋndiŋ ndiŋndiŋ ee (1,000). Leso napaghazoŋai ezam ila yes tau yamŋa alaghlaagh na matazi, ve tiwatagh tighe yo lem sosor eta mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ra Abaram isuŋ pa Maaron, ve Maaron igharaat Abimelek yesuru azaawa tomania besooŋa tooni zilivaa. Leso tipoop muul. Pasaa, saawe tau Abimelek igham Abaram azaawa Sara ila ruum tooni ve ilam, zilivaa tisov tau tileep izi Abimelek ruum tooni na, ene Yoova ipoon zi pa popaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Yoova maata iŋgal Sara, ve iuule itaghon saveeŋ mbuaaŋ tooni. Tauta Sara aapo, ve indeeŋ saawe tau Maaron ighuru pani pa popaaŋ na, i ipoop olman Abaram le naatu tamoot ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abaram iwaat naatu tau Sara ipoopa na, eeza Isak. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Naatu tawe mbooŋi imin liim ve tol, ra Abaram irav waaro itaghon Maaron aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Saawe tau Sara ipoop Isak, Abaram ndaman tooni irau ndiŋndiŋ ee (100) wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara loolo poia kat, ve isaav ighe: “Maaron igham lolog poia ve naŋiŋ. Ve tamtamon tisov tau tilooŋ varug, ene pale yeŋa niŋiŋ ve tintinmai.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ve Sara isaav muul ighe: “Muuŋ, sei irau isaav pa Abaram ighe: ‘Azuwam Sara pale ipoop ve ipaghun tauu naatu?’ Mako. Eemon aazne, Abaram imin kooŋ wa, ve yau napoop le naatu tamoot ee.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tilepleep le saawe tau natuzi Isak ipul tuz, ra Abaram igham ghanghaniiŋ tiina pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saawe tana, Agar tau Isip tinazi na naatu Ismael igham ŋalalaŋ, ve iŋiŋiŋ pa Sara naatu Isak. Sara ighita gabua tana, le irau loolo mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tauvene isaav pa Abaram ighe: “Uziir besooŋa livaa tawe yesuru naatu tighau tila soghan! Besooŋa livaa tawe naatu irau ileep tomania natug Isak, ve tiyooz pa gabua tsio mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eemon Ismael, i Abaram naatu paam. Tauvene Abaram ilooŋ saveeŋ tane, le loolo ipataŋan kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Eemon Maaron isaav pani ighe: “Lolom ipataŋan pa besooŋa livaa yesuru naatu sov. Utaghon Sara ŋgar tooni. Pa paaghu tsio duduuŋ pale tivot ila to natum Isak mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Eemon paaghu to besooŋa livaa naatu paam, yau pale nagham zi timasa timin eval. Pasaa, i paaghu tsio paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tauvene nughizau, mboŋoozo geeg, ve Abaram iburig gha igham Agar le mberet ve yaa tomania paatu imin tamaz, ve iiti izala avaara, ve ighur yesuru naatu Ismael gha tila. Yesuru tila ve tivalaghlaagh izi nugh ŋginaaŋa to Ber-Seba. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Saawe tau yaa toozi isov, Agar ipul naatu Ismael izi ai marani ee puughu, ve ilaagh ila soghan rig pani. Ra mboole izi, ve itaŋ toman aliiŋa tiina. Pasaa, loolo pa ighita naatu imaat mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Maaron ilooŋ Agar naatu taŋiiz tooni, tauvene aŋela to Maaron ileep sambam, ve ipoi izilam pa Agar ighe: “Agar, mindai? Uroi sov. Natum tau ilepleep, ve itaŋtaŋ we, Maaron ilooŋ taŋiiz tooni wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Uburig ula, ve uiti izaa ve uŋgin poghania. Pa yau pale nagham paaghu tooni tivot timin naol ve ezazi tintiina.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ra Maaron igham Agar maata pakia, ve maata ila le ighita yaa taiŋ ee. Tauvene igham yaa paatu toozi ila itivu le ivon, ve imuul ila ipaghun naatu. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Maaron ileep tomania Ismael, ve itum le imin olman. Ismael ilepleep izi nugh ŋginaaŋa, ve i niima mamaan pa vaneghuuŋ gabua pa paneegh. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ismael ilepleep izi nugh ŋginaaŋa Paran, ve tiina igham Isip tinazi ee pani gha ivaii. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Saawe tana, kinik Abimelek yesuru ŋeer tau iŋgin yes zaaba tooni na eeza Pikol, tila to Abaram, ve Abimelek isaav pani ighe: “Yau naghilaal naghe Maaron ileep tomani ghom pa gabua naol isov tau yo ughamu. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tauvene aazne, yau naghe yo umbu saveeŋ ariaaŋa tomani ghau ila Maaron maata tauvene: Yo irau ugham karom eta pa yau, ma natugŋa, ma paaghu tsiau tau pale tivot murei ne mako. Yo aat ugham poghani ghau ve tamtamon to taan tau uleep umin loom pani ne paam. Pasaa, yau nagham poghani ghom, ve lupuuŋ toit eemon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abaram iyol Abimelek aliiŋa ighe: “Poia. Yau nambu saveeŋ ariaaŋa ila Maaron maata imin tau yo usaav na.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Eemon Abaram le saveeŋ tomania Abimelek paam. Pasaa, yaa taiŋ ee tau besooŋa tooni titaii na, ene besooŋa to Abimelek tighamu imin lezi, ve tipoon besooŋa to Abaram pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abaram ipaesia pataŋani tawe pa Abimelek, ve i iyol aliiŋa ighe: “Wai, saveeŋ tane, aazne mon ra nalooŋa. Mindai ta yo upaesia saveeŋ tane payau rekia mako? Ŋeer tau igham ŋgar tane, yau nawataghi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ra Abaram igham sipsip tomania makau siriv pa Abimelek, ve yesuru timbu saveeŋ ariaaŋa to tilup zi timin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ve Abaram ighur sipsip upin paghpaaghu liim ve ru paam tila soghan. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Tauvene Abimelek ighasoni ighe: “Puughu mindai ta yo ughur sipsip tawe tila soghan?” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abaram iyol aliiŋa ighe: “Yau naghe yo ugham sipsip tawe timin lem. Leso itotoi ighe yo uyok ughe yau natai yaa tawe.” ");
INSERT INTO tuc_t_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","32","Tauta tiwaat nugh tawe eeza Ber-Seba. Pasaa, yesuru tileep ta sewe, ve timbu saveeŋ ariaaŋa to tilup zi timin eemon. Timbu saveeŋ izi Ber-Seba le isov, ra Abimelek yesuru Pikol timuul tila pa nugh toozi tau igheen ila taan sirivu to Pilistia. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abaram iŋgun ai tamarisk ee izi Ber-Seba, ve ai tawe imin niia to suŋuuŋ. I ileep ta sewe, ve isuŋ pa Yoova, i Maaron tau ileep irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abaram ileep imin loom izi taan to yes Pilistia le malau. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Murei ra, Maaron itoov Abaram. Saawe ee, i ipoii ighe: “Abaram!” Abaram iyok pa aliiŋa ighe: “Taug ene.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Maaron isaav pani ighe: “Natum eemon Isak tau lolom igheen tooni kat na, yau naghe ughamu, ve yamru ala pa taan sirivu to Moria. Ala avot ta sewe, o azala pa loloz ee tau yau pale natotoia payo. Mako uravu imaat, ve ughuru izala yav gha ighan dodolini imin watooŋrau payau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tauvene mboŋ le nughizau, ndoromroome soone, ve Abaram iburig, ve igharaat doŋki tooni pa laghooŋ ve ipaal ai to indavu pa watooŋrau. Ra iturwaaka, ve ighuru izala doŋki paavo. Ra igham naatu Isak tomania besooŋa tooni ru, ve yesŋa tiburig gha tila pa nugh tau Maaron isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tilaagh irau mataaz ru, ve ite imin tol, ra Abaram maata ila, ve ighita nugh tau tighe tila pani na, igharau rig. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tauvene isaav pa besooŋa tooni ru tawe ighe: “Yamru aleep ta sene tomania doŋki. Yeiru natug pale nizala nugh tawe ve nisuŋ le isov, o nimuul nizilam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ra Abaram igham ai to ndavuuŋ yav pa watooŋrau, ve iiti ila naatu Isak avaara gha ibaado. Ve i igham yav tomania mbuzaagh ve yesuru tinau tizala. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tilaghlaagh tila, ve Isak isaav pa taama Abaram ighe: “Wai tamaŋ!” Abaram iyol aliiŋa ighe: “Natug, mindai?” Ra Isak ighasoni ighe: “Iit tagham yav ve ai. Eemon sipsip sindei ta pale tagham watooŋrau pani?” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abaram iyol aliiŋa ighe: “Natug, Maaron tauu pale iuul ghiit ve igham leen sipsip eta pa watooŋrau.” Abaram isaav tauvene, ve yesuru tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yesuru tilaagh tila tivot nugh tau Maaron isavia pa Abaram na, ve Abaram indou maet imin artaal, ve ighur ai izala paavo. Ra ikau naatu Isak pa waar, ve ighuru izala ai paavo. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ra igham mbuzaagh ve iit niima izaa pa ŋgaliiŋ naatu. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Eemon Mbaŋooŋa to Yoova ileep sambam ve iboob izila pani ighe: “Abaram, Abaram!” Abaram iyok pa aliiŋa ighe: “Taug ene.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mbaŋooŋa tawe isaav pani ighe: “Nimam itut natum sov. Ugham gabua eta pani sov! Aazne, yau nawatagh ghom kat: Yo uroi pa Maaron, ve utaghon katin ŋgar tooni. Pasaa, natum eemon tau lolom igheen tooni kat na, yo uŋguruuta pani mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ra Abaram maata izaa le ighita sipsip tamoot ee tau zooŋa ilot ila ai marani ee booga. Tauvene ila ighamu gha iyol naatu pani, ve indav yav gha ighan dodolini imin watooŋrau pa Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abaram iwaat nugh tawe eeza ighe ‘Yoova pale iuul ghiit ve igham leen gabua.’ Tauta aazne paam, tamtamon tisavsaav tighe: “Yoova pale iuul ghiit ve igham leen gabua popoia izi loloz tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mbaŋooŋa to Yoova ileep sambam, ve iboob izila pa Abaram muul ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ene Yoova tauu aliiŋa ta ilat na. Yo ulooŋ i aliiŋa, ve uŋguruut natum eemon tana pani mako. Tauvene i imbu saveeŋ ariaaŋa tomani ghom ila i tauu eeza tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ighe: ‘Yau aat naghur poia tsiau tiina kat izaa tsio, ve nagham paaghu tsio timasa timin naol timin pitum to sambam saamba, ve sausau to nari. Ve paaghu tsio pale tiyooz ariaaŋ pa malmal le tiliiv koiazŋa, ve tigham nugh toozi imin lezi. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pasaa, yo ulooŋ yau aliŋag. Tauvene paaghu tsio pale timin eez to poia tsiau izaa to nughmariŋ to taan.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mbaŋooŋa to Yoova isavsaav le isov, ra Abaram yesuru naatu Isak timuul tizila to besooŋa tooni ru, ve yesŋa tiburig gha timuul tila pa nugh Ber-Seba, ve Abaram ighur niia to lepoogh ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Murei ra, Abaram ilooŋ paesiiŋ tighe taazi Naor azaawa Milka ipoop natŋa siriv wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","Ezazi tauvene: Uz (i aidaaba), tazŋa Bus, ve Kemuel tau Aram taama, ve Kesed, Aso, Pildas, Yidlap, ve muria kat, ene Betuel tau Rebeka taama. Yes liim ve tol tane, ta Abaram taazi Naor yesuru azaawa Milka natuzŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naor ivai livaa ite imin azaawa zazagheeŋ, eeza Reuma. Reuma ipoop natŋa paaŋ: Teba, Gaam, Taas, ve Maaka. ");
INSERT INTO tuc_t_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara ilepleep le ndaman tooni irau 127, ra saawe tooni isov ve imaat izi nugh Kiriat Arba tau igheen ila taan sirivu to Kanaan. (Kiriat Arba eeza ite Ebron). Tauvene Abaram loolo ipataŋan pa azaawa ve itaŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Itaŋtaŋ le isov, ra iburig, ipul azaawa paata izi, ve ila isavsaav tomania yes Hita. Isaav pazi ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Aghita. Yau leg taan eta mako. Naleep namin loom ila yam sosomim. Mindai, irau aghita leg taan sirivu eta leso imin nugh to naghur azuwag paata ila?” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Yes Hita tiyol aliiŋa tighe: “Olman, yo ŋeer tiina ee tau uleep tomani ghei, ve nighilaal ghom nighe Maaron ileep tomani ghom. Ulooŋ, mateegha tsiei niazi katini. Ughita poia eta tau irau lolom, o ughur azuwam paata ila. Tamtamon tsiei eta irau iŋguruuta payo mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abaram ilooŋ saveeŋ toozi le loolo poia. Tauvene iburig ve itud pazi imin pakuruuŋ zi, ve isaav ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","“Poia. Isaav ighe yam ayok payau to naghur mateegh tsiau izi nugh tane, o ala to Zoar naatu Epron, ve aghasoni pa maet puura tau igheen izi taan tooni Makpela ziige na. Nugh tawe ta naghe nagholi imin leg, ve naghuru imin mateegha tsiei niazi. Atuya piiz tau i ighuru, ene aat naghol suvinia ila yam asov matamim.” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Abaram isavsaav tomania yes Hita izi lupuuŋ niia tau igheen eez maata, ve Epron tauu ilepleep paam. Tauvene iburig ve iyooz ila eval tiina matazi, ve iyol Abaram aliiŋa ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tiina tsiau, ulooŋ. Yau lolog pa ughol taan tsiau tawe mako. Yau aat nagham payo sorok. Ve maet puura tau igheen ila taan tawe paam, aat nagham payo sorok ila eval tisov tane matazi. Ula utavia mateegh tsio ta sewe.” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abaram ilooŋ saveeŋ tane, ve itud pazi muul imin pakuruuŋ zi, ve isaav pa Epron ila eval tisov matazi ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","“Ene poia. Eemon ughur taliŋam payau. Yau naghe naghol duduŋai taan tsio tawe. Tauvene taan atuya aat ilat nimam muuŋ, o nala natavia mateegh tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron iyol Abaram aliiŋa ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tiina tsiau, ulooŋ! Taan tawe atuya irau maet silva 400 ma vene. Eemon tambaaŋo paam. Ugholi pasaa? Ituru tavawataghi ghiit. Ula ve utavia azuwam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abaram ilooŋ Epron aliiŋa, ve inin le maet silva irau 400 itaghon saveeŋ tau Epron isavia ila eval tawe matazi na. ");
INSERT INTO tuc_t_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Tauvene taan to Epron tau igheen izi Makpela igharau nugh Mamre, tomania maet puura ve ai tisov tau tiyooz ila taan tawe, ene Abaram ighol motin zi timin le. Ve yes Hita tisov tau tileep ila lupuuŋ tana, tilooŋ saveeŋ mbuaaŋ to yesuru, ve tighita pa matazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ra Abaram ila ighur azaawa Sara paata iloŋ ila maet puura tau igheen ila taan Makpela igharau nugh Mamre izi taan Kanaan. (Nugh Mamre eeza ite Ebron.) ");
INSERT INTO tuc_t_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tauvene taan tawe tomania maet puura tau igheen ila, ene yes Hita tipuli imin Abaram le, ve i ila igharaata imin mateegha tooni niazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yoova ighur poia tooni izazaa to Abaram tomania gabua tooni ta naol ne, ve ila ila le Abaram imin kooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Saawe ee, Abaram isaav pa besooŋa tooni ee tau olman ve imuuŋ pa ŋginiiŋ gabua tooni naol isov na ighe: “Ulooŋ. Yau naghe yo ughur nimam ila ŋgoig ve umbu saveeŋ ariaaŋa tomani ghau ila Maaron tau iŋgin sambam ve taan na eeza tauvene: Yes Kanaana tau itiŋa talepleep ne, yo irau ugham natuzlivaŋa eta pa natug Isak mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Yo aat umuul ula pa nugh tsiau ve ziiri waaro tsiau, ve ughita livaa eta, ve ughamu ilam. Leso ivai natug.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Besooŋa tooni ighasoni ighe: “Isaav ighe livaa tawe tiini imum pa ipul nugh tooni ve ilam sene, ene pale nagham mindai? Pale namuul nalam nagham natum, ve naghuru ila ileep izi nugh tsio puughu tawe?” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abaram iyol aliiŋa ighe: “Mako kat! Yo irau ughur natug imuul ila nugh tsiau puughu mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Pasaa, Maaron Yoova tau iŋgin sambam na, igham ghau napul ziiri waaro to tamaŋ ve nugh tsiau puughu, ve imbu saveeŋ ariaaŋa tomani ghau ighe i pale igham taan tane payau ve paaghu tsiau tau pale tivot murei. I tauu pale imbaaŋ aŋela tooni imuuŋ payo. Tauvene yo pale irau ugham livaa eta pa natug ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Eemon isaav ighe livaa tana tiini imum pa yamru alam sene, ene saveeŋ mbuaaŋ tsio tane irau ikis ghom mako. Eemon matam iŋgal: Ugham natug imuul ila nugh tsiau puughu sov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Abaram isavsaav le isov, ra besooŋa tana ighur niima ila Abaram ŋgoi, ve imbu saveeŋ ariaaŋa pani ighe i aat igham uratoi tiina tooni aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ra besooŋa tana igham kuaz maata maata to tiina tooni Abaram, ve ighuru izala kamel saŋavul pavozi, ve ipaburigin laghooŋ gha ila pa Naor nugh tooni tau igheen izi Mesopotamia. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ilaghlaagh ila le ravrav ee, ila ivot, ve ighita yaa taiŋ ee igheen igharau nugh tawe. Tauvene igham kamel tooni tila tigharau yaa tawe ziige, gha timariau. Ravrav ta naol ne, zilivaa to nugh tawe tila titivtiv yaa ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Besooŋa tana isuŋ ila loolo ighe: “O Yoova, Maaron to tiina tsiau Abaram, aazne naghe utotoi poia tsio pa tiina tsiau, ve ugham uraat tsiau ighur anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aazne, yau nayozyooz igharau yaa taiŋ tane, ve ene saawe to zilivaa paghpaaghu to nughei tilam pa tivuuŋ yaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tauvene yau aat nasaav pa livaa eta naghe: ‘Uit uur tsio izi, upaŋgeua, ve naghun leg yaa rigta.’ Ve isaav ighe i iyol aliŋag ighe: ‘Poia. Ughun lak. Ve yau aat nativ pa kamel tsio paam.’ Ighe i iyol aliŋag tauvene, ene livaa tana tau yo taum usiigho pa besooŋa tsio Isak. Leso nawatagh naghe lolom isaghav tiina tsiau Abaram ve ughe uule itaghon saveeŋ mbuaaŋ tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I isuŋsuŋ soone, ve ighita livaa ee ibaad uur ila avaara, ve ilam peria. Livaa tawe eeza Rebeka. Taama Betuel, i Abaram taazi Naor gha Milka natuzliva. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka, i mbiu. Tamoot eta ila tooni soone. Ve i livaa paghuuna kat. I izila yaa taiŋ tawe gha itiv yaa ila uur tooni le isov, ve imuul izalam. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ra besooŋa tana ilaan iŋaruini ila, ve isaav pani ighe: “Ai, irau naghun yaa rigta ila uur tsio?” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebeka iyol aliiŋa ighe: “Tiina tsiau, poia. Ughun lak!” Ve rekia mon iit uur tooni izi, ipaŋgeua, ve besooŋa tana ighun. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ighun le isov, ve Rebeka isaav pani muul ighe: “Yau aat nativ yaa pa kamel tsio paam, leso tighun le irau zi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tauvene rekia mon iliŋ yaa izila oon tau ŋgai tighunghun ila na, ve imuul izila pa tivuuŋ yaa. Ighamgham tauvene le kamel tisov tighun yaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Besooŋa le saveeŋ mako. Ineneeŋ mon, ve maata ilala pani ighe ighita: Pale Yoova igham laghooŋ tooni ighur anooŋa, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamel tighun yaa le isov, ra iwaan ŋoor milmilia ee, ve mbi milmilia ru tau tigharaat zi pa gol na, ve igham pa Rebeka. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ve ighasoni ighe: “Usaav ghazooŋa payau. Tamam sei? Mindai, irau yei nilat ruum tsiam, ve nileep tomani gham pa mboŋ?” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka iyol aliiŋa ighe: “Yau tamaŋ Betuel. Tibugŋa ta Naor gha Milka. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ruum tsiei sooso tiina. Irau aleep tomani ghei. Ve aniiŋ katini to kamel paam ighengheen.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Besooŋa tana ilooŋ saveeŋ tane, ve iput aaghe, ighur naagho izila pa taan, ve ipakur Yoova ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Yau napait Yoova, Maaron to tiina tsiau Abaram, pa poia tooni. Pasaa, i loolo isaghav tiina tsiau ve iuluule itaghon saveeŋ mbuaaŋ tooni. Tauta igham pooz payau le nalam navot ruum to ziiri waaro tooni duduuŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ra Rebeka ilaan imuul ila ruum to tiina, ve ipaes pazi pa gabua isov tana. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka liivu eeza Laban. I ighita ŋoor ve mbi milmilia tau Rebeka ighur zi ila uuzu ve niima na, ve ilooŋ paesiiŋ tooni, ra iburig ve ilaan ila pa yaa taiŋ ighe ighita ŋeer tana. Ila ivot, ve ighita besooŋa to Abaram iyozyooz tomania kamel tooni ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban isaav pani ighe: “Poia to Yoova igheen tomani ghom. Mindai ta uyozyooz sorok izi sene? Ulam tala pa ruum. Niamim to ghenooŋ ve kamel niazi paam, nagharaat zi wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tauvene besooŋa tana igham kamel tooni ve yesŋa tila pa ruum to Laban. Tila tivot, ra Laban iyau yauyauŋ izi pa kamel, ve igharaat niazi, ve igham lezi kikiliiŋ ve aniiŋ. Ve igham yaa ila pa besooŋa to Abaram tomania uraata siriv tau yesŋa tilam na. Leso timin aghezi pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ra tigharaat aniiŋ ve tighuru izi besooŋa to Abaram naagho. Leso ighan. Eemon i isaav pazi ighe: “Poia. Aniiŋ aat igheen o. Yau aat nasavia saveeŋ tsiau payam imin maata.” Laban iyol aliiŋa ighe: “Poia. Usaav lak.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Besooŋa tana ipaburigin saveeŋ tooni ighe: “Yau besooŋa to Abaram. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yoova ighur poia tiina izaa to tiina tsiau. Tauvene i eeza tiina, ve kuaz tauu kat. I le makau, sipsip, mekmek, doŋki, ve kamel katini kat. Ve i le maet gol ve silva katini, ve besooŋa zitamoot ve zilivaa katini paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tiina tsiau azaawa Sara imin kooŋ, ra ipoop Abaram le naatu tamoot ee. Murei, naatu tawe pale iyooz pa gabua naol isov to taama. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tiina tsiau isaav payau gha nambu saveeŋ ariaaŋa tomania tauvene: Yes Kanaana tau yeŋa nilepleep tomani zi we, irau nagham natuzlivaŋa eta pa naatu Isak mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","I ighe nala pa tauu ziiri waaro tooni, ve nail livaa eta pa naatu. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Saawe tau naghe napaburigin laghooŋ tsiau, naghason tiina tsiau naghe: ‘Isaav ighe nandeeŋ livaa eta, ve tiini imum pa ilam tomani ghau, ene pale nagham mindai?’ ");
INSERT INTO tuc_t_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","I iyol aliŋag ighe: ‘Lepoogh tsiau tomania laghooŋ tsiau, yau matag iŋgalŋgal Yoova ve nataghon eez tooni irau saawe. I tauu pale imbaaŋ aŋela tooni ilat tomani ghom, ve iuul ghom. Leso uraat tsio ighur anooŋa. Tauvene yo aat ugham livaa eta to ziiri waaro to tamaŋŋa pa natug Isak. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eemon isaav ighe ula uvot to ziiri waaro tsiau, ve tiyok payo mako, ene saveeŋ mbuaaŋ tane irau ikis ghom mako.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Aiyo. Aazne ravrav, yau nalam navot izi yaa taiŋ to nugh tsiam tane, ve nasuŋ naghe: O Yoova, yo Maaron to tiina tsiau Abaram. Aazne, naghason ghom naghe ugham laghooŋ tsiau tane ighur anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","Ughita. Yau nayozyooz igharau yaa taiŋ tane. Isaav ighe livaa paaghu eta ilam pa tivuuŋ yaa, yau aat naghasoni tauvene: ‘Irau naghun yaa rigta ila uur tsio?’ Ve ighe i iyol aliŋag ighe: ‘Poia. Ughun lak. Ve yau aat nativ pa kamel tsio paam.’ Ighe iyol aliŋag tauvene, ene livaa tana, ta yo taum usiigho pa tiina tsiau naatu Isak.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Nasuŋsuŋ soone, ve naghita Rebeka ibaad uur ila avaara ve ilam peria. I izila itiv yaa le isov, ve imuul izalam, ra yau nasaav pani naghe: ‘Ai, irau ugham yaa rigta ilam naghun?’ ");
INSERT INTO tuc_t_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Rekia mon ve i ighur uur tooni izi, ve isaav payau ighe: ‘Poia. Ughun lak. Ve yau aat nativ yaa pa kamel tsio paam.’ Tauvene yau naghun le isov, ve i itiv pa kamel tsiau paam, ve tisov tighun le irau zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ra naghasoni naghe: ‘Yo tamam sei?’ “I iyol aliŋag ighe: ‘Yau tamaŋ Betuel. Ve tibugŋa ta Naor gha Milka.’ Nalooŋ saveeŋ tane, ve naghur ŋoor ee ila uuzu, ve nazuz mbi ru ila niima. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ra naput agheg, ve naghur naghog izila pa taan, ve napakur Yoova, Maaron to tiina tsiau Abaram, ve napaiti pa poia tooni. Pasaa, i igham pooz payau le nalam navot duduuŋ to tiina tsiau naatu Betuel natliva. Leso naghamu ila pa naatu Isak. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tauvene aazne, isaav ighe lolomim isaghav tiina tsiau Abaram, ve aghe agham poghania itaghon eez to ziiri waaro, na asaav ghazooŋa payau gha nalooŋa. Ighe mako, pale nail eez ite paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban yesuru Betuel tiyol aliiŋa tighe: “Gabua tane ivot ila to Yoova tauu. Tauta yeiru irau nisavia saveeŋ eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ilepleep. Ughamu ve ala. Leso imin tiina tsio naatu azaawa itaghon Yoova aliŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Besooŋa to Abaram ilooŋ saveeŋ toozi, ve iput aaghe, ighur naagho izila pa taan, ve ipakur Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ra iwaan kuaz milmilia siriv tau tigharaat zi pa gol ve silva na, tomania uuli popoia siriv, ve igham zi pa Rebeka. Ve Rebeka liivu Laban yesuru tiina paam, besooŋa tana igham lezi gabua popoia siriv tau atuyazi tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ra tomania zeetŋa siriv tau yesŋa tilam na, tighan ma tighun le isov, ve tigheen. Mboŋoozo ra, mbesooŋa to Abaram iburig ve isaav pa Laban ighe: “Aiyo, yau naghe namuul nala pa tiina tsiau. Mindai, yam ayok?” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Eemon Rebeka liivu Laban ve tiina tiyol aliiŋa tighe: “Ee-e, ula rekia sov. Livaa paaghu ileep tomani ghei rig irau mboŋ saŋavul ma vene, o ala.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Eemon besooŋa to Abaram iyol aliŋazi ighe: “Aŋguruut ghau sov. Ayok payau, ve namuul nala pa tiina tsiau. Pa Yoova ipaduduŋai ghau gha laghooŋ tsiau ighur anooŋa wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tauvene yesuru tisaav pani tighe: “Ighe vene, o tapoi Rebeka tauu ilam, ve taghasoni.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tauvene tipoi Rebeka ilam, ve tighasoni tighe: “Laak, lolom mindai? Yamru ŋeer tane aburig aazne ve ala, ma?” I iyol aliŋazi ighe: “Vee, yau naghe nala.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ra tighur Rebeka tomania besooŋa livaa tau iŋginŋgini na, ve yesŋa besooŋa to Abaram ve zeetŋa tau yesŋa tilam na, tipaburigin laghooŋ toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ve tighur poia to Maaron izaa to Rebeka tighe: “Livumai, yo aat umin tamtamon ndiŋndiŋ ndiŋndiŋ tinazi. Ve paaghu tsio pale tiliiv koiazŋa, ve tigham taan toozi imin lezi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ra Rebeka yesŋa besooŋa tooni zilivaa siriv tizaa kamel, ve tiburig gha tila. Ene eez tau besooŋa to Abaram igham Rebeka ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Saawe tana, Isak ipul taan sirivu tau yaa taiŋ Beer Lai Roi igheen pani na, ve imuul ila pa taan sirivu to Negev. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ravrav ee, i ila ilaghlaagh izi nugh ŋginaaŋa, ve ighamgham ŋgar. Maata izaa le ighita kamel tilaagh tilam. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka paam, maata ila le ighita Isak. Tauvene rekia mon izi pa kamel tooni, ");
INSERT INTO tuc_t_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ve ighason besooŋa to Abaram ighe: “Saa ŋeer tau ilaagh ilam we?” Besooŋa iyol aliiŋa ighe: “Ewe tiina tsiau.” Tauvene Rebeka igham uuli sirivu ve ipoon naagho pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Isak ila ivot toozi, ve besooŋa tana ipaesia gabua isov tau ivot pani izi Mesopotamia na. ");
INSERT INTO tuc_t_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ra Isak igham Rebeka imin azaawa, ve tileep ila balbaal to tiina Sara. Isak loolo igheen to Rebeka kat. Tauta irav Isak aate, ve loolo ipataŋan pa mateegh to tiina Sara muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Murei ra, Abaram ivai livaa ite eeza Ketura. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura ipoop natŋa liim ve ee. Ezazi tauvene: Simran, Yoksan, Medan, Midian, Isbak, ve Sua. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan natŋa, ene: Seba ve Dedan. Dedan paaghu tooni, ene yes Asura, Letusa, ve Leuma. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian natŋa, ene: Epa, Eper, Anok, Abida, ve Elda. Yes tane, ta tivot ila to Abaram gha Ketura. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abaram ipul gabua tooni naol isov ila to naatu Isak. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Eemon saawe tau Abaram ilepleep maata yaryaare soone, irei gabua tooni siriv pa natŋa zitamoot to Agar ve Ketura paam. Ra ighur zi tila pa taan sirivu tau igheen ila pa aaz puughu na. Leso tileep tigharau naatu Isak sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abaram lepoogh tooni poia mon le imin kooŋ kat. Ndaman tooni irau 175, ra imaat, ve ila ileep tomania ziiri waaro tooni tau timaat muuŋ na. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Abaram natŋa ru, Isak ve Ismael, tighur paata iloŋ ila maet puura tau igheen ila taan Makpela igharau nugh Mamre. Muuŋ, taan tawe to Zoar naatu Epron. Zoar, i Hit tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abaram ighol taan tawe ila to yes Hita. Ve titavia Sara yesuru Abaram izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Saawe tau Abaram imaat, poia to Maaron ila ivool to naatu Isak. Saawe tana, Isak ilepleep igharau yaa Beer Lai Roi. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","15","Ene pitiiŋ to Abaram naatu Ismael tomania paaghu tooni. Agar, i besooŋa livaa to Sara. I Isip tinazi tau ipoop Abaram naatu Ismael. Ismael natŋa, ene: Nebaiot, Kedar, Adbel, Mipsam, Misma, Duma, Masa, Adad, Tamar, Yetur, Napis, ve Kedema. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael natŋa paaghu toozi timasa timin naol, ve timin rumei saŋavul ve ru, ve tila tileep izi taan toz toz. Tauta tiwaat Ismael natŋa ezazi pa nugh ve taan toozi tawe. Ismael natŋa saŋavul ve ru tawe tisov timin daaba pa rumei toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael ndaman tooni irau 137, ra imaat, ve ila ileep tomania ziiri waaro tooni siriv tau timaat muuŋ na. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ve paaghu tooni tila tileep ila taan sirivu tau igheen bodbodaaŋ pa taan Avila ve taan Sur. Taan tawe igharau yes Isipa taan toozi ziige, ve eez tiina tau ila pa Asiria. Ismael paaghu tooni tivalupu zi mako. Tilepleep soghan soghan pa tauzi. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ene sinaiŋ to Abaram naatu Isak tomania paaghu tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ndaman to Isak irau tamoot ru (40), ra ivai Rebeka. Rebeka taama eeza Betuel. I puughu tooni ivot ila to Aram, ve ileep izi taan sirivu to Mesopotamia. Rebeka liivu eeza Laban. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka, i livaa uupa. Tauvene Isak isuŋ pa Yoova ve ighasoni ighe iuule. Yoova ilooŋ suŋuuŋ tooni, ve iuul Rebeka gha aapo. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebeka iyamaan imin natŋa tipaparav ila aapo loolo. Tauvene isaav pa tauu ighe: “Wai, mindai ta pataŋani tane ivot payau ne?” Ra ila isuŋ pa Yoova, ve ighasoni to ipaghazoŋai pataŋani tawe puughu pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yoova isaav pani ighe: “Tamtamon puughu toozi ru ta tileep ila apom loolo. Ŋgun ru pale tivot ilat tsio, ve tivalagh zi. Ŋgun ee pale tapiri iliiv ite. Ve ŋeer olman pale imin besooŋa pa ŋeer muria.” ");
INSERT INTO tuc_t_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka saawe tooni to popaaŋ ivot, ve ipoop zitamoot bogboogŋa ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ŋeer olman tiini siŋsiŋai, ve bide ooro. Tauta tiwaat eeza Esau. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ra taazi ikis toogha aaghe guubu ve aana izi. Tauvene tiwaat eeza Yakop. Saawe tau Rebeka ipoop geegeu ru tawe, Isak ndaman tooni irau tamoot tol (60). ");
INSERT INTO tuc_t_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tilepleep le geegeu ru tana timin zolman. Esau, i ŋeer to laghlaghooŋ ila su ve iŋgalŋgal ŋgai sagsag. Ve Yakop, i ŋeer marowa, ve ighamgham uraat izi nughei mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak loolo igheen to Esau. Pasaa, i loolo pa ghaniiŋ ŋgai sagsag to su. Ve Rebeka, i loolo igheen to Yakop. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Saawe ee, Yakop igharaat sur poia, ve Esau ileep su gha ivot. I pitoola kat le tapiri isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Tauvene isaav pa Yakop ighe: “Aiss, yau pitool ghau le nasaghat kat. Sur siŋsiŋai tana, uzoov leg rigta ilam naghun!” (Tauta tiwaat Esau eeza ite tighe Edom.) ");
INSERT INTO tuc_t_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Eemon Yakop isaav pani ighe: “Poia. Eemon ituru taparavol pa niaan muuŋ, ve nagham niam namin ŋeer aidaaba, o nazoov lem sur.” ");
INSERT INTO tuc_t_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau iyol aliiŋa ighe: “Aiss, paita namaat tane. Niag to ŋeer aidaaba, ene kaut sorok. Iuul ghau mindai? Rekia ugham sur tana ilam naghun.” ");
INSERT INTO tuc_t_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakop isaav pani muul ighe: “Yo aat umbu saveeŋ tomani ghau muuŋ ve upariaaŋa le iyaryaaŋ kat, o nagham payo.” Tauvene Esau imbu saveeŋ tomania, ve ipariaaŋa le iyaryaaŋ kat ighe yesuru tiparavolia niazi, leso Yakop igham i niia gha imin ŋeer aidaaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","I imbu saveeŋ tomania taazi le isov, ra Yakop igham le mberet tomania sur, gha ighan ma ighun, ve iburig gha ila. Ŋgar tau Esau ighamu na, ene itotoia ighe i maata veleghin niia to ŋeer aidaaba ighe ene kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Saawe siriv ilam ila, ra pitool tiina ivot muul izi taan sirivu to Kanaan, imin muuŋ ivot pa saawe to Abaram. Tauvene Isak iburig ighe ighau izila pa Isip. I ilaagh ila le ivot nugh Gerar. Nugh tawe igheen ila taan to yes Pilistia, ve kinik Abimelek iŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Isak ilepleep ta sewe, ve Yoova ivot tooni, ve isaav pani ighe: “Uzila pa Isip sov. Uleep izi taan tau yau naghe yo uleep pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tauvene uleep umin loom izi ta sene. Yau aat naleep tomani ghom, ve naghur poia tsiau izaa tsio. Pasaa, yau naghe nagham taan isov tane payo ve paaghu tsio tau murei pale tivot. Leso nagham saveeŋ tau muuŋ nambua tomania Abaram na anooŋa ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yau aat nagham paaghu tsio tivot timin naol kat imin pitum to sambam saamba, ve nagham taan tane isov imin lezi. Ve paaghu tsio pale timin eez to poia tsiau izaa to nughmariŋ to taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Pasaa, tamam Abaram, i iloŋlooŋ aliŋag ve itaghon eez tsiau. Tutuuŋ tsiau, tomania saveeŋ isov tau yau naghuru pani ve avog iyaryaaŋ pani naghe itaghoni, ene i maata kisini ve itaghon duduŋaini.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tauta Isak izila Isip mako. I ileep mon izi nugh Gerar. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tilepleep ta sewe, ve saawe tau zitamoot to nugh tawe tighason Isak pa azaawa, i iyol aliŋazi ighe: “Ene yau livug.” I isaav tauvene pasaa, Rebeka, i livaa paghuuna kat. Tauvene Isak iroi ighe pale tiravu imaat ve tigham azaawa. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak ileep malau rig izi nugh tawe. Saawe ee, Abimelek tau kinik to yes Pilistia na, ilepleep ruum loolo, ve maata ivot ila, le ighita Isak isaghav Rebeka. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tauvene Abimelek ipoi Isak ilam, ve isaav pani: “Wai, livaa tana, yo azuwam! Puughu mindai ta yo usaav ughe yo livum?” Isak iyol aliiŋa ighe: “Yau naroi naghe pale arav ghau namaat ve agham azuwag. Tauta nasaav naghe ene livug.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tauvene Abimelek iyaoni ighe: “Wai, utombaan ghei tauvene pasaa? Imin ta zitamoot tsiei eta ila to azuwam, ene pale yo taum umin puughu pa sosor tau yei nighamu ne.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ra Abimelek isaav ariaaŋ pa tamtamon tooni tisov ighe: “Alooŋ! Isaav ighe tamtamon eta igham saghatin ŋeer tane, ma azaawa, ene i aat imaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ndaman tana, Isak ivazogh aniiŋ ila taan tawe le aniiŋ pugh eŋaeŋa anoŋazi tivot irau ndiŋndiŋ ee (100). Pasaa, Yoova ighur poia tiina izaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tauvene Isak le aniiŋ ve gabua katini, ve eeza tiina. Gabua tooni ivotvot, le i imin kuaz tauu kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","I le sipsip, mekmek, ve makau katini. Ve besooŋa tooni paam, katini. Yes Pilistia tighita gabua tooni le ireu lolozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tauta tilal mulin yaa taiŋ tisov tau muuŋ yes besooŋa to Abaram titai zi na. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ra kinik Abimelek isaav pa Isak ighe: “Upul taan tsiei, ve ughau ula. Pa tapirim iliiv ghei wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tauvene Isak ipul zi, ve ila ivot taan raraate to Gerar, ve ighur niia to lepoogh izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ve yaa taiŋ tau muuŋ yes besooŋa to Abaram titai zi ve yes Pilistia tilal zi na, i itai mulin zi, ve iwaat ezazi tau muuŋ taama Abaram iwaat zi na. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ra yes besooŋa tooni tila titai puura ite izi nugh tawe le yaa bolokia izaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Eemon yes ŋginiiŋ ŋgaia to nugh Gerar tomania yes ŋginiiŋ ŋgaia to Isak tivazorai zi pa yaa tawe. Yes Gerara avozi iyaryaaŋ tighe ene yaa toozi. Tauta Isak iwaat yaa taiŋ tana eeza Esek. Pasaa, tiŋooŋ pa yaa tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tauvene yes besooŋa to Isak tila titai yaa paaghu. Eemon zeran siriv tilam ve yesŋa besooŋa to Isak tiparzoor pa yaa tawe paam. Tauvene Isak iwaat yaa tana eeza Sitna. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak ipul nugh tawe, ve ila itai yaa ite muul imin tol. Yaa taiŋ tawe, le saveeŋa mako. Tauvene Isak iwaat eeza Reobot, ve isaav ighe: “Aa ŋgarig gha Yoova ighur sooso tiina pait to taleep pani! Ene pale taleep poia izi taan tane, ve tamasa tamin naol.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Murei ra, Isak iburig muul, ve izala pa nugh Ber-Seba. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ila ivot ta sewe, ve mboŋ, Yoova ivot tooni, ve isaav pani ighe: “Yau Maaron to tamam Abaram. Uroi sov. Pa yau naleep tomani ghom. Tamam Abaram tau besooŋa tsiau na ndaamo payo, tauta yau aat naghur poia tsiau izaa tsio, ve nagham paaghu tsio timasa timin naol.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tauvene Isak indou maet imin artaal, ve isuŋ pa Yoova izi nugh tawe. Ve ighur niia to lepoogh ta sewe, ve besooŋa tooni titai yaa ite paam izi nugh tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Murei ra, Abimelek ipul nugh Gerar, ve ilam ighe ighita Isak. I ilam tomania ŋeer ŋgara ee, eeza Ausat, ve daaba to yes zaaba tooni, eeza Pikol. Yes tol tilam tivot to Isak, ");
INSERT INTO tuc_t_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ve i ighason zi ighe: “Yam aghur koi payau, ve aziir ghau pa taan tsiam wa. Mindai ta alam payau muul?” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yes tiyol aliiŋa tighe: “Yei nighilaal nighe: Yoova ileep tomani ghom. Tauvene nighe itiŋa tambu saveeŋ ariaaŋa to tavalupu ghiit tamin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ve nighe yo umbu saveeŋ payei ughe irau uvaghamun ghei mako. Ughita. Yei nigham saghatin ghom mako, ve nigham ŋgar popoia mon payo, le nighur ghom ula toman lolom poia. Ve aazne, poia to Yoova ighengheen tomani ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tauvene Isak igharaat aniiŋ tiina, ve yesŋa tighanghan. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mboŋ le nughizau, mboŋoozo geeg, ve tiburig gha tipariaaŋ saveeŋ mbuaaŋ toozi le iyaryaaŋ kat. Ra Isak ighur zi timuul tila pa nugh toozi toman lolozi poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Aaz eemon tana, besooŋa to Isak tilam ve tipaes pani tighe: “Tiina tsiei, puura tau yei nitaii na, nighita yaa bolokbolokia izaa pani!” ");
INSERT INTO tuc_t_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tauvene Isak iwaat yaa tawe eeza Seba. Tauta tiwaat nugh tau igheen igharau yaa tawe eeza Ber-Seba. Eeza tane ighengheen soone. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ndaman tooni irau tamoot ru (40), ra ivai Hit tinazi ru, ezazi Yudit, ve Basemat. Yudit, i Beri natliva. Ve Basemat, i Elon natliva. ");
INSERT INTO tuc_t_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Eemon loom tinazi ru tawe ŋgar toozi irau rawazi Isak ve rawazliva Rebeka lolozi mako. Tauta tigham lolozi ipataŋan kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Olman Isak imin kooŋ wa. Ve maata ikumkuum, le irau ighita nugh muul mako. Saawe ee, i ipoi naatu olman Esau ighe: “Natug!” Esau iyok pa aliiŋa ighe: “Taug ene. Saa?” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ra olman Isak isaav pani ighe: “Ulooŋ. Yau namin kooŋ wa, ve nakankaan pa mateegh tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tauvene ugham paneegh tsio, ve ula pa su gha uil leg aniiŋ ziigha. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Leso ugharaat leg sur poia tau lolog pani kat na, ve ughamu ilam naghun. Mako naghur poia to Maaron izaa tsio. O ighe namaat, na namaat lak.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Isak yesuru naatu Esau tisavsaav, ve olman tinazi Rebeka taliiŋa isaut saveeŋ toozi. Tauvene Esau ila pa su ighe iil aniiŋ ziigha, ve Rebeka isaav pa naatu Yakop ighe: “Ŋgarig nalooŋ tamam isaav pa togham ighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Esau, ugham aniiŋ ziigha eta to su ilam ve ugharaat leg sur poia tau lolog pani kat na, ve ughamu ilam naghun. Mako naghur palotiiŋ tsiau izaa tsio ila Maaron maata. O ighe namaat, na namaat lak.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tauvene natug, ulooŋ aliŋag, ve utaghon saveeŋ tsiau tane. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ula nugh tau ŋgai toit tilepleep pani we, ve ughita mekmek paghpaaghu ruta tomania tumbuŋazi, ve ugham zi tilam. Yau aat nagharaat tamam le sur poia tau i loolo pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Leso ughamu ila pani gha ighun. Ve ighur poia to Maaron izaa tsio le isov, o imaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Eemon Yakop iyol tiina aliiŋa ighe: “Tinaŋ, aliŋam poia. Eemon toghag Esau, i tiini ororomai. Ve yau mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ighe tamaŋ itut ghau rig, ene pale ighilaal ghau, ve igham ŋgar ighe yau nagham mogheraaŋ pani. Mako ighur poia to Maaron izaa tsiau mako, ve ighur pataŋani izaa tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Eemon tiina isaav pani ighe: “Natug, ugham ŋgar naol sov. Ulooŋ aliŋag tane, ve utaghoni. Ighe i ighur pataŋani izaa tsio, ene pale yau nabaad pataŋani tana. Ula ugham mekmek tilam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tauvene Yakop iburig, ve ila igham mekmek ru tilam pa tiina. Rebeka niima rekrekia pa gharatooŋ sur poia tau Isak loolo pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Le isov, ve ila igham nonoghiiŋa poia kat to naatu olman Esau tau igheen balbaal tooni loolo na, ve ighamu ila to Yakop, leso inonogh ghi pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ra ikau mekmek uuli ila Yakop luua ve ila niima paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ve igham sur tomania mberet tau i igharaata na, ve ighuru ila to Yakop. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakop ila to taama, ve ipoii ighe: “Tamaŋ, nalam wa!” Taama Isak ighe: “Natug, taug ene. Ve yo sei?” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakop isaav pani muul ighe: “Yau Esau, natum aidaaba. Sur tomania aniiŋ ziigha tau yo usaav payau pani na, tauta naghamu nalam. Uburig gha ughun, ve ughur poia to Maaron izaa tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak ilooŋ saveeŋ tane, ve ighasoni ighe: “Wai, natug, mindai ta yo undeeŋ gabua rekia mon?” Yakop iyol aliiŋa ighe: “Maaron tsio Yoova iuul ghau. Tauta rekia mon ve nandeeŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ra Isak isaav pani muul ighe: “Natug, ulam ugharau ghau, ve nataaŋ ghom. Leso nawatagh kat: Yo natug Esau, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tauvene Yakop ila igharauu, ve taama itaaŋo, ra isaav pani ighe: “Aliŋam imin Yakop aliiŋa. Eemon nimam imin Esau niima.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Isak ighilaal Yakop mako. Pasaa, niima ororomai imin toogha Esau. Tauvene Isak ighe ighur poia to Maaron izaa tooni. Eemon loolo ruru soone. Tauvene ighasoni muul ighe: “Onoon, natug Esau taum tane?” Yakop iyol aliiŋa ighe: “Vee, yau taug tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tauvene Isak isaav pani ighe: “Natug, ugham sur tana ilam. Lolog pa ghunuuŋ sur tau yo ugharaata tomania ziigha to su na. Naghun le isov, mako naghur poia to Maaron izaa tsio.” Tauvene Yakop igham sur ila to taama Isak gha ighun. Ve igham le yaa vaen paam ila ighun. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Taama Isak ighun le isov, ve isaav pani ighe: “Natug, ulam usaghav ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tauvene Yakop ila isaghav taama. Isak inuŋuz Esau vaazi tau igheen ila nonoghiiŋa tooni, ve ighur poia to Maaron izaa to Yakop ighe: “Aa, natug tane vaazi, imin su tau poia to Maaron igheen pani na! ");
INSERT INTO tuc_t_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Maaron aat igham uwam tiina to sambam izi payo, ve ipabees taan tsio. Leso ŋgoreeŋa tiina, ve aniiŋ ve vaen katini tivot payo. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nugh nugh pale tibees payo. Ve taan siriv tamtamona pale tiput aghezi payo ve tipakur ghom. Yo pale umin tiina pa toŋvetaz tsio, ve tinam natŋa tiput aghezi payo. Tamtamon tisov tau tighur saveeŋ pataŋani izaa tsio, ene pale tauzi tindeeŋ pataŋani. Ve yes tau tighason Maaron to ighur poia tooni izaa tsio, ene pale poia tooni izaa toozi paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak ighur poia to Maaron izaa to Yakop le isov, ra Yakop ipuli, ve ivot gha ila. Malau mako ve toogha Esau ileep su gha ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","I paam igharaat sur poia kat, ve ighamu ila pa taama, ve isaav pani ighe: “Tamaŋ, yau nagharaat sur tsio tomania ziigha to su, tauta naghamu ilam wa! Uburig gha ughun, ve ughur poia to Maaron izaa tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak ilooŋ saveeŋ tooni, ve ighasoni ighe: “Wai, yo sei paam?” Esau iyol aliiŋa ighe: “Yau Esau, natum aidaaba.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak ilooŋ saveeŋ tane le tiini irur kat, ve isaav pani ighe: “Waii, yo ulam soone, ve ŋeer ee igham sur tomania ziigha to su ilam gha naghun. Sei ne? Yau naghur poia to Maaron izaa tooni wa. Ve onoon kat, palotiiŋ tawe aat igheen tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ilooŋ taama saveeŋ tooni, le loolo isaghat pa tauu, ve itaŋ tiina, ve itaŋ rarai taama ighe: “O tamaŋ, ughur poia to Maaron izaa tsiau paam!” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Eemon Isak isaav pani ighe: “Wai, palotiiŋ tau naghe nagham payo, tauta tazim ilam itombaan ghau gha ighamu ila wa!” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tauvene Esau isaav ighe: “Oyais, ŋeer tawe, tiwaat eeza Yakop le iduduuŋ kat! Pasaa, i itombaan ghau pai ru wa! Muuŋ, itombaan ghau gha igham niag imin ŋeer aidaaba. Ve aazne, ium palotiiŋ tsiau paam.” Ra Esau ighason taama muul ighe: “Tamaŋ, mindai? Lem palotiiŋ eta payau mako?” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak iyol aliiŋa ighe: “Wai, yau naghur tazim imin tiina payo, ve naghur toŋvetaz tsiam tisov timin besooŋa pani wa. Ve naghason Maaron to igham aniiŋ ve vaen anoŋazi katini tivot pani, leso ileep poi. Tauvene natug, gabua eta igheen muul to nagham payo ne mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eemon Esau itaŋ rarai taama muul ighe: “Tamaŋ mindai? Palotiiŋ tsio eemon geeg tawe? Ite paam mako? O tamaŋ, ughur poia to Maaron izaa tsiau paam!” Ra Esau itaŋ muul toman aliiŋa tiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Taama Isak iyol aliiŋa ighe: “Nugh tsio to lepoogh, pale igheen malau pa taan ŋgoreeŋa, ve uwam to sambam irau izi payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yo aat uparav pa mbuzaagh, o uleep poi. Ve yo pale umin besooŋa pa tazim. Eemon murei pale uzoor pooz tooni, ve irau iŋgin ghom muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ikis aatyavyav tooni pa Yakop ariaaŋ. Pasaa palotiiŋ tooni, tauta taama ighuru izaa to Yakop wa. Tauvene igham ŋgar ila loolo ighe: “Malau mako pale tamamai imaat. Moŋiiŋ tooni ighe isov, mako narav tazig Yakop imaat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Eemon titig Rebeka taliiŋa pa ŋgar tau Esau ighe ighamu. Tauvene ipoi Yakop ilam, ve isaav pani ighe: “Natug, ulooŋ. Togham Esau ighe irav ghom umaat, o loolo poia ve aate izi. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tauvene ulooŋ aliŋag, ve uburig rekia mon, ve ughau ula pa livug Laban tau ileep izi nugh Aran we. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ula uleep tomania le togham aate izi o. ");
INSERT INTO tuc_t_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Isaav ighe loolo iluum, ve loolo iveegh pa ŋgar tau ugham pani na, ene pale nambaaŋ ilat payo, o umuul ulam. Pasaa, yau naroi: Pale yamru aparav ve amaat pa saawe eemon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ra Rebeka isaav pa Isak: “Oyai, rauaan livaŋa tau Hita tinazi ne, tinig imum pazi kat. Lolog pa Yakop ivai livaa eta to taan tane imin yes tane mako. Mako le mako kat. Ighe i igham tauvene, poia to namaat gha nala. Naleep pasaa?” ");
INSERT INTO tuc_t_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tauvene Isak ipoi Yakop ilam, ve ighur poia to Maaron izaa tooni, ra aavo iyaryaaŋ pani ighe: “Yo irau uvai Kanaan tinazi eta mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Uburig ula pa taan sirivu to Mesopotamia, ve ula ruum to timbum Betuel, o uvai wagham Laban natliva eta. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na, pale ighur poia tooni izaa tsio, ve igham paaghu tsio tivot timin naol, ve rumei katini tivot ilat tsio. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Poia tooni tau muuŋ izaa to Abaram na, aat izaa tsio ve paaghu tsio paam. Leso taan tau aazne uleep umin loom pani ne, imin lem. Pasaa, taan tane, Maaron ighuru imin timbum Abaram le.” ");
INSERT INTO tuc_t_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak isavsaav pa Yakop le isov, ra ighuru ila pa Mesopotamia. Leso ileep tomania waagha Laban tau Betuel naatu na. Laban tane, puughu tooni ivot ila to Aram. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ilooŋ tighe Isak ighur poia to Maaron izaa to Yakop, ve ighuru ila pa Mesopotamia, leso ivai ta sewe. Ve aavo iyaryaaŋ pani ighe ivai Kanaan tinazi eta sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau ighita Yakop itaghon taama ma tiina aliŋazi ve ila pa Mesopotamia, ");
INSERT INTO tuc_t_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ra ighilaal ighe Kanaan tinazi ru tau i ivai zi na, taama Isak loolo pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tauvene Esau ipul taama ma tiina, ve ila to taama Ismael, ra ivai livaa ite, eeza Maalat. Maalat liivu eeza Nebaiot. Maalat ve Nebaiot, ene Ismael natŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakop iburig, ipul nugh Ber-Seba, ve ighe ila pa nugh Aran. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I ilaagh ila le ivot nugh ee, ve mboŋ izi pani. Tauvene igham maet ee imin ali pani, ve izi igheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I iviv, ve ighita gabua ee imin ndeet tau iyooz izi taan, ve izala pa sambam. Ve yes aŋela to Maaron tiyesyes taghoni tizizi ve tizazaa. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ra ighita Maaron tauu iyooz izi ziige, ve isaav pani ighe: “Yau Yoova. Yau Maaron to timbum Abaram, ve Maaron to Isak. Taan tau yo ugheen pani ne, ene yau aat nagham payo tomania paaghu tsio. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Paaghu tsio pale timasa timin naol imin ŋgaupup to taan, le tirau nugh. Siriv pale tila pa ragh puughu, ve siriv tila pa yavaar puughu, ve siriv tila pa daudau puughu, ve siriv tila pa kaagu puughu. Ve yo tomania paaghu tsio pale amin eez to poia tsiau izaa to nughmariŋ to taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ulooŋ. Nugh sindei tau yo ula uleep pani, ene yau aat naleep tomani ghom ve matag payo. Ve murei, yau pale nagham ghom umuul ulam pa taan tane. Tauvene yau irau napul ghom mako. Pale naleep tomani ghom le nagham saveeŋ mbuaaŋ tsiau tane anooŋa ivot payo.” ");
INSERT INTO tuc_t_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ra Yakop iburig maata iyaryaar, ve isaav pa tauu ighe: “Wai, onoon kat, Yoova ileep izi nugh tane, ve yau nawataghi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tauvene roiŋ tiina ighamu, ve isaav ighe: “Yau naroi kat. Pasaa, nugh tane patabuyaaŋ! Onoon kat, ene Maaron tauu niia. Ataman to nugh sambam igheen ta sene.” ");
INSERT INTO tuc_t_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakop izi igheen muul le nughizau. Ra iburig, igham maet tau iyalia imin ali na, ve ipayooze imin ilaal pa nugh tawe, ve iliŋ ŋgoreeŋ izala paavo. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","I iwaat nugh tana eeza Betel. Muuŋ, nugh tana eeza Lus. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ra Yakop imbu saveeŋ ariaaŋ ila loolo tauvene: “Isaav ighe Maaron ileep tomani ghau, ve maata payau pa laghooŋ tsiau tane, ve igham leg aniiŋ toman nonoghiiŋa to nanonogh ghau pani, ve isaav ighe naleep poia mon le irau namuul nala pa ruum to tamaŋ, ene aat Yoova imin Maaron tsiau, ve nabees pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Maet tau napayooze ne, pale itotoi ighe nugh tane, ene Maaron niia.” Ra imbu saveeŋ tomania Maaron ighe: “Onoon kat, gabua naol isov tau yo ugham payau na, yau aat navalagh zi timin ŋgun saŋavul, ve naghur ŋgun ee ilat payo.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakop ipaburigin laghooŋ tooni muul, ve ilaagh ila ivot nugh ee to yes tau taan toozi igheen ila pa aaz puughu na. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Maata ila le ighita sipsip ŋgun tol tighengheen tigharau yaa taiŋ ee. Pasaa, monmon tamtamon titivtiv yaa tawe ve tipapaghun sipsip toozi. Yaa taiŋ tawe, tipoon aavo pa maet babaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nugh tawe gabuazi tauvene: Isaav ighe ravrav izi, ve sipsip tisov tila tivot yaa tawe ziige, mako ŋginiiŋ ŋgaia tilam ve tizuur maet babaaŋa tana ighau ila soghan. Leso titiv yaa ve tipaghun sipsip. Le isov, mako tipoona muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakop iŋarui yes ŋginiiŋ ŋgaia tawe ila, ve ighason zi ighe: “Zeran tsiau, yam to saa nugh?” Yes tiyol aliiŋa tighe: “Yei to nugh Aran.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tauvene Yakop ighason zi muul ighe: “Yam awatagh Laban tau Naor tiimbu, ma mako?” Yes tighe: “Vee, yei niwataghi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakop ighason zi muul ighe: “Mindai, lepoogh tooni poia?” Yes tiyol aliiŋa tighe: “Vee, i ileep poia. Ughita. Natliva Rael tomania sipsip toozi, ta ŋgarig gha tilam we.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ra Yakop isaav pazi muul ighe: “Aghita. Ene aaz tiina, ve sipsip irau tiloŋ tila olol loolo soone. Agham yaa pazi ve tighun le isov, o agham zi timuul tila tighan kikiliiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Eemon yes tisaav pani tighe: “Ee-e, vene mako. Yei aat nilepleep ve nisaŋan sipsip tisov tilam peria, o nizuur maet tane ila pa ziige, ve nitiv yaa gha nipaghun zi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakop tomania yes ŋginiiŋ ŋgaia tana tisavsaav soone, ve Rael igherev sipsip to taama gha tilam tivot. Pasaa, i ta monmon iŋginŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakop ighita waagha Laban natliva Rael tomania sipsip tooni, ve iburig ila pa yaa taiŋ tana, izuur maet babaaŋa ila soghan pa yaa aavo, ve itiv yaa pa sipsip gha tighun. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakop loolo poia kat pa ighita liivu. Tauta isaghavu ve itaŋ aliiŋa tiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ve ivotia tauu pani ighe: “Yau tane ziiri waaro to tamam! Yau tinaŋ Rebeka.” Rael ilooŋ saveeŋ tane, ve rekia mon ilaan ila peria to taama, ve ipaes pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ilooŋ waagha Yakop vaaru, tauvene iburig ve ilaan ila ighe ighita. Ila ivot tooni, ve isaghavu toman tintini. Ve ighamu, gha yesuru timuul tila pa ruum. Ra Yakop ipaesia laghooŋ tooni gha Laban ilooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yakop ipaes le isov, ve Laban isaav pani ighe: “Onoon kat, ituru siŋ eemon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yakop ileep tomania Laban irau kaiyo ee, ra Laban izi ve isaav pani ighe: “Onoon, yo ziiri waaro tsiau duduuŋ. Eemon ugham uraat payau sorok, ene poia mako. Tauvene usaav ghazooŋa payau. Ughe nagham saa gabua imin lem atuya?” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban natlivaŋa ru. Olman eeza Lea, ve muria eeza Rael. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea naagho paghuuna geeg mako. Ve Rael, i livaa paghuuna kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakop loolo igheen to Rael. Tauvene isaav pa Laban ighe: “Yau naghe navai natumliva Rael. Isaav ighe yo uyok payau, o nagham uraat payo irau ndaman liim ve ru.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban iyol aliiŋa ighe: “Yau lolog pa nagham Rael pa ŋeer ite paam mako. Isaav ighe nagham payo ve uvaii, ene poia kat. Tauvene uleep tomani ghau ve ugham uraat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakop igham uraat pa Laban irau ndaman liim ve ru, leso ivai Rael. Eemon i ighita ndaman liim ve ru tana imin saawe malau mako. Pasaa, loolo igheen to Rael kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ndaman liim ve ru tana isov, ra Yakop isaav pa Laban ighe: “Saawe tau yo ughuru payau, tauta napasovu wa. Ugham livaa tana ilam gha navaii!” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tauvene Laban igham marewaaŋ tiina, ve ipoi tamtamon tisov to nugh tawe tilam tilup zi pa ghanghaniiŋ to vaiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Eemon mboŋ tana, i igham karom, ve ighur natliva olman Lea ila to Yakop ve yesuru tigheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ve igham besooŋa tooni livaa ee, eeza Silpa pa Lea, leso ibesbees pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mboŋoozo, Yakop iburig ve maata izi le ighilaal Lea ighengheen izi ziige! Tauvene ila isaav pa Laban: “Wai, ugham ŋgar tane payau pasaa? Yau nagham uraat payo leso navai Rael. Puughu mindai ta yo utombaan ghau?” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban iyol aliiŋa ighe: “Mako. Ta muuŋ ve ilam, tutuuŋ tsiei igheen tauvene: Livaa muria irau ivai imuuŋ pa livaa olman mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tauvene yo uleep le irau ghanghaniiŋ to Lea isov, o naghur Rael paam ilat. Eemon yo aat ugham uraat payau irau ndaman liim ve ru muul.” ");
INSERT INTO tuc_t_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakop ilooŋ saveeŋ tane, ve itaghoni mon. Tauvene mboŋ liim ve ru to ghanghaniiŋ to vaiŋ tana, i ileep tomania Lea. Ra Laban ighur natliva Rael paam ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ve ighur besooŋa tooni livaa ite, eeza Bila, ila to Rael, leso ibesbees pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tauvene Yakop yesuru Rael tigheen paam. Yakop loolo igheen to Rael kat. Eemon Lea, Yakop loolo pani kat mako. Yakop ileep tomania Laban, ve igham uraat pani irau ndaman liim ve ru muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yoova ighita Yakop loolo pa Lea kat mako. Tauvene iuul Lea le aapo. Eemon Rael, i uupa. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea ipoop naatu aidaaba, ve isaav ighe: “Yoova ighita pataŋani tsiau, tauta igham leg natug tane. Aazne, aat azuwag loolo igheen tsiau.” Tauvene iwaat naatu tawe eeza Ruben. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tilepleep le Lea aapo muul, ve ipoop naatu tamoot ite. Tauvene isaav ighe: “Yoova ilooŋ taŋiiz tsiau, ve iwatagh ighe azuwag loolo igheen tsiau kat mako. Tauta igham leg natug ite tane.” Tauvene Lea iwaat naatu tawe eeza Simeon. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tilepleep le Lea aapo muul, ve ipoop naatu tamoot ite imin tol. Tauvene isaav ighe: “Aazne, aat azuwag loolo isaghav ghau rig. Pasaa, napoop le natŋa zitamoot tol wa.” Tauta iwaat naatu tawe eeza Levi. ");
INSERT INTO tuc_t_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tilepleep le Lea aapo muul, ve ipoop naatu tamoot ite imin paaŋ. Tauvene isaav ighe: “Aazne, yau napakur Yoova.” Tauta iwaat naatu tawe eeza Yuda. Lea ipoop Yuda, ra popaaŋ tooni imot, ve ileep le malau. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rael ighita ighe i irau ipoop Yakop le naatu eta mako. Tauvene iriu toghliva, ve isaav pa Yakop ighe: “Ugham leg natug eta lak! Ighe mako, yau aat namaat!” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakop ilooŋ saveeŋ tane, le aate yavyav. Tauvene isaav pa Rael ighe: “Wai! Yau Maaron gha leso nagharaat apom ve upoop? Maaron tauu, ta ipoon apom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rael isaav pani muul ighe: “Poia. Ughita. Besooŋa tsiau livaa Bila ilepleep. Ughamu ve yamru agheen. Leso ipoop leg natug eta.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tauvene Rael ighur besooŋa tooni livaa ila to Yakop ve yesuru tigheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ra Bila aapo, ve ipoop Yakop le naatu tamoot ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tauvene Rael isaav ighe: “Aa, ŋgarig gha Maaron igabiiz ghau ighe yau leg sosor eta mako. Pa i ilooŋ suŋuuŋ tsiau, ve igham leg natug tamoot tane.” Tauta iwaat naatu tawe eeza Dan. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tilepleep le Bila aapo muul, ve ipoop naatu ite imin ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tauvene Rael isaav ighe: “Yeiru toghag liva nivatovai tapirimai ve naparav ariaaŋ le naliivo wa.” Tauta iwaat naatu tawe eeza Naptali. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ighita ighe saawe tooni to popaaŋ, ene isov. Tauvene ighur besooŋa tooni livaa Silpa ila to Yakop leso imin zazagheeŋ ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","11","Ra Silpa aapo, ve ipoop Yakop le naatu ee. Tauvene Lea isaav ighe: “Ene gabua poia tau ivot payau!” Tauta iwaat naatu tawe eeza Gat. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tilepleep le Silpa, tau besooŋa livaa to Lea na, ipoop Yakop le naatu tamoot ite imin ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tauvene Lea isaav ighe: “Aazne, yau lolog poia kat! Ve yes zilivaa to nughei paam pale lolozi poia tomani ghau.” Tauta Lea iwaat naatu tawe eeza Aser. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Saawe ee tau tiluplup wit anooŋa, Ruben ilaghlaagh ila uum loolo, le ighita waar anooŋa siriv, ve iyau zi ila pa tiina Lea. Gabua tawe, yes tighur ila tighe ipazaagh zitamoot ve zilivaa, leso tigheen ve zilivaa apozi. Rael ighita, ve isaav pa Lea ighe: “Ai, kaut tau natum ighamu na, ugham leg siriv ilam!” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Eemon Lea iyol aliiŋa ighe: “Wai! Yo ugham azuwag ipul ghau wa. Ve aazne ughe ugham gabua to natug tane paam? Ene aat mako kat!” Tauvene Rael isaav pani muul ighe: “Poia. Ugham leg siriv. Ve mboŋ aazne, yau aat nasaav pa Yakop ilat yamru agheen imin gholiiŋ waar anooŋa tau natum ighamu ne atuya.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ravrav izi, ra Yakop imuul ilam nughei, ve Lea iŋaruini ila, ve isaav pani ighe: “Ulooŋ. Mboŋ aazne, yo aat ulam tsiau. Pa yau naghol ghom pa waar anooŋa to natug wa.” Tauvene mboŋ tana, Yakop ila to Lea, ve yesuru tigheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Maaron ilooŋ suŋuuŋ to Lea, ve ighamu aapo muul, ve ipoop naatu tamoot ite imin liim. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tauvene Lea isaav ighe: “Yau naghur besooŋa tsiau livaa ila to azuwag, tauta Maaron igham leg atuya poia tane.” Tauvene iwaat naatu tawe eeza Isakar. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tilepleep le Lea aapo muul, ve ipoop naatu tamoot ite imin liim ve ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ve isaav ighe: “Aazne, Maaron igham leg gabua poia ee. Tauvene azuwag aat loolo imuul payau ve ipakur ghau. Pasaa, yau napoop le natŋa liim ve ee wa.” Tauta iwaat naatu tawe eeza Zebulun. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Murei ra, Lea ipoop livaa ee, ve iwaat eeza Dina. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Ra Maaron maata iŋgal Rael paam, ve ilooŋ suŋuuŋ tooni. Tauvene iuul Rael gha aapo, ve ipoop naatu tamoot ee. Tauta Rael isaav ighe: “Aa, ŋgarig gha Yoova igham leg natug ve mayag isov! ");
INSERT INTO tuc_t_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Eemon naghe i igham leg natug tamoot ite paam, o poia.” Tauvene iwaat naatu tawe eeza Yosep. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rael ipoop Yosep le isov, ra Yakop isaav pa Laban ighe: “Olman, naghe uyok payau, leso namuul nala pa nugh tsiau ve taan tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yo uwatagh: Yau nakaria uraat payo wa. Tauvene upul azuwagŋa toman natugŋa leso niburig nila. Pa uraat tau nagham payo na, tauta naghol zi ilat tsio wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Eemon Laban iyol aliiŋa ighe: “Wai waghag! Ituru taleep rig o. Pa yau naghe nasaav payo pa gabua ee. Gabua siriv tivot timin ilaal payau, ve naghilaal naghe yo ndamom payau, tauta poia to Maaron izaa tsiau ve leg gabua naol. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tauvene naghe naŋguruut ghom uleep tomani ghau. Aiyo, usaav ghazooŋa payau. Lolom ughe nagham saa gabua imin lem atuya leso ituru taleep?” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakop iyol aliiŋa ighe: “Taum uwatagh wa. Yau nakaria uraat payo. Tauta ŋgai tsio timasa timin naol. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Muuŋ, lem ŋgai naol mako. Eemon yau nalam naleep tomani ghom, tauta ŋgai tsio timasa timin naol kat. Tauvene yau, tauta poia to Maaron tau izaa tsio. Pale ŋeez o nagham uraat to nauul azuwagŋa ve natugŋa?” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Tauvene Laban ighasoni muul ighe: “Yo ughe nagham lem saa?” Yakop iyol aliiŋa ighe: “Yo irau ugham leg gabua eta ta aazne mako. Ve mindai? Irau uyok payau ta aazne, ve nala nagham sipsip natŋa gabgabuai, ve mekmek galgaliiŋ tisov timin leg? Ene atuya tau yau lolog pani. Isaav ighe uyok pa aliŋag tane, o naleep ve naŋgin ŋgai tsio muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ve murei, yo irau ulam ughita ŋgai tau tileep tomani ghau ne, leso uwatagh ughe yau ŋeer to umbuuŋ mako. Ene atuya tau yo ugham payau na. Ve isaav ighe ughita mekmek eta tau galgaliiŋ mako, ma sipsip eta tau gabgabuai mako tilaghlaagh tomania ŋgai tsiau, ene yo irau uwatagh ughe yau naumbu.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ilooŋ saveeŋ to Yakop, ve iyok pani ighe: “Poia. Aat nataghon aliŋam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Eemon Laban itaghon saveeŋ toozi mako. Pasaa, saawe tana, i iburig ila igham mekmek zitamoot tisov tau tinizi butbutuuŋ na, ve mekmek upin tisov tau galgaliiŋ na, ve sipsip natuzŋa tisov tau gabgabuai na. Ŋgai tisov tawe, i iŋguaaz zi tila to tauu natŋa, leso tiŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Toman natŋa tigham ŋgai tana, ve tilaagh irau mboŋ tol. Tilaghlaagh tila le tivot nugh ee, ra tileep ve tiŋgin ŋgai toozi izi ta sewe.” Ve Yakop ileep, ve iŋgin ŋgai siriv tau Laban ipul zi tizi tileep na. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Eemon Yakop igham ai booga mbitai siriv, ve iso ulizi le timin butbutuuŋ pisosooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Ra ipayooz zi tigharau oon tau ŋgai tighunghun yaa ila na. Pasaa, i iwatagh: ene saawe to ŋgai zitamoot tiip pa ŋgai upin. Tauvene saawe tau mekmek ve sipsip tilam pa ghunuuŋ yaa, tighita ai soaaŋ butbutuuŋ tawe, mako ŋgai zitamoot tiip pa ŋgai upin igharau ai tawe. Ve murei, saawe to popaaŋ, ene tipoop natuzŋa butbutuuŋ ve galgaliiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakop ighur natuzŋa tawe tileep soghan pa Laban ŋgai tooni, leso timin le. Ve sipsip tauvene paam. Saawe tau zitamoot tighe tiip pa ŋgai upin, Yakop ighur naghozi ila pa Laban mekmek tooni tau butbutuuŋ ve gabgabuai na, leso tipoop natuzŋa butbutuuŋ ve gabgabuai. I ighamgham tauvene, le ŋgai tooni timasa timin naol kat. Ve ighur zi tila tileep soghan pa Laban tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tauvene saawe tau ŋgai tumbuŋazi tighe tiip pa ŋgai upin, Yakop ipapayooz ai booga butbutuuŋ igharau oon tau ŋgai tighunghun yaa ila na. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Eemon saawe tau ŋgai koŋkoŋizi tighe tiip pa ŋgai upin, i ipaspas ai booga tawe tighau. Tauvene Yakop le ŋgai tumbuŋazi mon. Ve Laban tooni, ene koŋkoŋizi mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Eez tane ta Yakop imin kuaz tauu. I irau kat pa mekmek, sipsip, besooŋa tooni zilivaa ve zitamoot, kamel, ve doŋki. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Murei ra, tipaes pa Yakop tighe Laban natŋa tisavsaav tighe: “Yakop tawe, i iyauur gabua naol isov to tamaan timin le wa. Gabua tooni ta naol we, tisov tivot ila to tamaan mon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ve Yakop ighita Laban paam, ighur dadabu pani. Loolo poia pani imin muuŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ra Maaron isaav pa Yakop ighe: “Uburig, ve umuul ula pa taan to tamamŋa ve timbumŋa, ve uleep tomani zi. Yau aat naleep tomani ghom ve matag payo.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tauvene Yakop imbaaŋ ila pa Rael gha Lea ighe tila tivot tooni izi nugh ziige tau i iŋginŋgin ŋgai pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yesuru tila tivot tooni, ve i isaav pazi ighe: “Alooŋ. Aazne, yau naghita tamamim loolo poia payau imin muuŋ mako. Eemon Maaron to tamaŋ ilepleep tomani ghau ve maata payau. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","7","Yamru awatagh: Ndaman ndaman, yau narav taug pa uraat to tamamim. Ve saawe naol, i igham karom payau, ve itortoor aliiŋa pa atuya tsiau. Eemon Maaron ipoona, tauta i irau ivaghamun ghau kat mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Saawe tau tamamim isaav payau ighe: ‘Mekmek galgaliiŋ pale timin lem atuya’, mekmek tisov tipoop galgaliiŋ mon. Ve saawe tau i ighe: ‘Mekmek butbutuuŋ pale timin lem atuya’, ene mekmek tisov tipoop butbutuuŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Eez tane, ta Maaron ipas ŋgai to tamamim, ve igham zi timin leg. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Saawe tau ŋgai tighe tipiraak, yau nagheen ve naghita vivuuŋ tauvene: Mekmek zitamoot tau tiip pa mekmek upin, ene butbutuuŋ ve galgaliiŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ra aŋela to Maaron ipoi ghau ighe: ‘Yakop!’ Ve yau nayok pa aliiŋa naghe: ‘Taug ene.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“I isaav payau muul ighe: ‘Ŋgar isov tau Laban ighamgham payo na, yau naghita wa. Matam ila ve ughita. Mekmek zitamoot tau tiip pa mekmek upin, ewe butbutuuŋ ve galgaliiŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","‘Maaron tau ivot payo izi nugh Betel, ene yau taug tane. Saawe tau uleep ta sewe, yo upayooz maet ve uliŋ ŋgoreeŋ izala paavo, ve umbu saveeŋ ariaaŋa payau. Yau nasaav payo: Uburig ta aazne, upul nugh tane, ve umuul ula pa nugh tau tinam ipoop ghom ve matam igheen pani na.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yakop ipaes pazi le isov, ra Rael yesuru Lea tisaav pani tighe: “Tamamai, murei pale ipul gabua tooni eta imin lemai? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I maata iŋgal ghei muul mako. I ighit ghei nimin suumbu eta natŋa. Yo uvai ghei sorok mako. Ughol ghei wa. Ve atuya tiina tau yo ugham pani na, i tauu ighan suvinia wa. Yei nighita ŋgiira rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kuaz naol isov tau Maaron ipas zi pa tamamai, ene iit toman natuunŋa gabua toit mon. Poia, utaghon Maaron aliiŋa tau i isavia payo na.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tauvene Yakop iburig, ve iyauur ŋgai tooni tomania gabua tooni naol isov tau i igham zi izi Mesopotamia na. Ra ighur azauŋa tomania natŋa tizala kamel tooni pavozi, ve yesŋa tiburig gha tila pa Yakop taama Isak tau ilepleep izi Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Saawe tana, Laban ileep nughei mako. I ila pa ravuuŋ sipsip tooni orozi. Tauvene Rael ila ium maaron karom anunuzi to taama Laban tau ighur zi to tiŋgin ruum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakop ipaesia burigiiŋ toozi pa Laban mako. Yes tiburig imin yoŋgaaŋ, ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tauvene Yakop iyauur gabua tooni naol isov, ve yesŋa tamtamon tooni tisov tighau. Yes tila timbut yaa tiina Euprates ve tivool pa paaŋa ite, ve tilaagh tiŋarui taan sirivu Gileat loloza gha tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mboŋ ru ila, ve ite imin tol, ra tamtamon siriv tipaes pa Laban tighe waagha Yakop ighau ila wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tauvene Laban iburig, iyau ziiri waaro tooni siriv, ve yesŋa tilaan taghon zi. Titaghon zi tila tila le irau mboŋ liim ve ru. Ra tila tigharau zi izi taan sirivu to Gileat loloza. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Eemon mboŋ tana, Maaron ivot to Laban tau Aramea tamazi na ila vivuuŋ, ve isaav pani ighe: “Matam imomoos pa aliŋam. Usik saveeŋ ariaaŋa eta to uparoi Yakop sov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakop ighur niia to lepoogh izi nugh Gileat, ve yesŋa tamtamon tooni tileep ta sewe. Tauvene Laban tomania ziŋeera tilam tivot toozi, ve tighur niazi to lepoogh izi ta sewe paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban iburig ve iyaon Yakop ighe: “Ai, yo ugham ŋgar tane payau pasaa? Yo ugham karom payau, ve uŋguaaz natug livaŋa tighau payau imin yes zaaba tighamgham pa yes zilivaa to koiazŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","28","Mindai ta yo ughau imin yoŋgaaŋ payau? Imin ta usaav payau, kanaŋ nigham ghanghaniiŋ toman narogho, ve nighur gham ala toman lolomai poia. Eemon yo upaes payau mako. Tauta natak natug livaŋa tomania tibugŋa nimazi mako, ve apul ghau. Ŋgar tau ugham payau ne, ene iduduuŋ mako. Ugham ŋgar imin yes borauŋa! ");
INSERT INTO tuc_t_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yau tapirig irau navaghamun gham. Eemon mboŋ, Maaron to tamam isaav payau ighe: ‘Matam imomoos pa aliŋam. Usik saveeŋ ariaaŋa eta to uparoi Yakop sov.’ Tauta tambaaŋo, aat ula. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yau nawatagh: Ŋgar tsio iyaryaaŋ kat ughe umuul ula pa tamam ve nugh tsio. Tauta upul ghau. Eemon puughu mindai ta uum maaron tsiau anunuzi tau tiŋginŋgin ruum tsiau ne?” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakop iyol Laban aliiŋa ighe: “Yau naroi naghe yo aat uŋguruut natum livaŋa payau. Tauta naghau imin yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Eemon yau nakankaan pa maaron tsio anunuzi. Isaav ighe yo undeeŋ tamtamon eta tau ium zi, i aat imaat. Tauvene taum ulaagh, ve utiir gabua tsiei ta naol ne ila tamtamon toit tane matazi, ve uil zi. Isaav ighe undeeŋ gabua tsio eta, na ughamu.” Saawe tau Rael ium taama Laban maaron tooni anunuzi, Yakop ighita mako. Tauta ikankaan pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tauvene Laban iburig, ve iloŋ ila Yakop balbaal tooni, Lea balbaal tooni, ve balbaal to yes besooŋa zilivaa ru, ve itiir gabua naol isov. Eemon indeeŋ maaron tooni anunuzi mako. Ra iloŋ ila balbaal to Rael paam ve iil gabua tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Eemon Rael iŋgooz maaron karom anunuzi tawe iloŋ ila pepeel, ve ighuru ituuk ila kamel tooni ziige, ve mboole izala paavo. Tauvene Laban itirtiir gabua naol isov tau tigheen ila balbaal to Rael loolo na, le mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ra Rael isaav pa taama ighe: “O tiina tsiau, atem yavyav payau sov. Yau irau naburig mako. Pasaa, moroghooŋ to zilivaa igham ghau.” Tauta Laban iil iil le mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ra Yakop aate yavyav kat, ve iyaon Laban ighe: “Yau namalaaŋ pa saa tutuuŋ, ve nagham saa sosor, ta atem yavyav ve utaghon ghau? ");
INSERT INTO tuc_t_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aazne, yo utiir ve utaaŋ gabua tsiei naol isov. Isaav ighe undeeŋ gabua tsio eta, na ughuru ivot ghazooŋa ila tamtamon toit tisov tane matazi ve tighita, leso tigabiiz saveeŋ toit. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Yau naleep tomani ghom irau ndaman tamoot ee (20) wa. Saawe isov tana, sipsip ve mekmek tsio popaaŋ toozi poia mon. Ve yau naghan sipsip tsio eta sorok mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Saawe tau gabua sagsag irav sipsip tsio eta ve ighani, yau nagham sipsip tawe ilat ve natotoia payo mako. Mako kat. Yau nayoli pa taug sipsip tsiau. Pasaa, yo avom iyaryaaŋ payau tauvene: Ighe gabua tsio eta ilale pa mataaz, ma mboŋ, ene aat yau taug nayoli. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mataaz, aaz ighaaz katin ghau. Ve mboŋ, yauŋa igham ghau naŋgo tiina, ve naghenov matag rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“Yau naleep tomani ghom ve nabesbees payo irau ndaman tamoot ee wa. Yau nagham uraat irau ndaman saŋavul ve paaŋ to nagham natum livaŋa ru. Ve nagham uraat payo irau ndaman liim ve ee muul, leso ugham leg sipsip ve mekmek. Ve saawe naol, yo utoor aliŋam pa atuya tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","“Maaron to tibug Abaram, i Maaron tau tamaŋ Isak iroi pani ve ibesbees pani paam. Imin ta i ivool tsiau mako, kanaŋ yo ughur ghau nalam toman nimag ŋginaaŋa. Eemon Maaron ighita pataŋani tsiau ve uraat tiina tau nagham payo na. Tauta mboŋ ivot tsio ve iyaon ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yakop isavsaav le isov, ra Laban iyol aliiŋa ighe: “Zilivaa tane, ene yau natug livaŋa. Ve yes geegeu tane, ene yau tibugŋa. Natug livaŋa ta tipoop zi. Ve sipsip tomania mekmek tisov tane, ene yau tsiau paam. Tauvene gabua naol isov tau aazne yo ughit zi ne, ene yau tsiau mon. Eemon aazne, pale nagham mindai pazi? Tambaaŋo, timin lem wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tauvene aazne, yau naghe tambu saveeŋ ariaaŋ, leso talup loloon imin eemon. Ve tagham ŋgar eta, leso tapariaaŋ saveeŋ mbuaaŋ toit ve mataan iŋgali.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tauta Yakop igham maet malaua ee, ve ipayooze imin ilaal pa saveeŋ mbuaaŋ toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ra isaav pa zeran tooni ighe tila tindou maet siriv. Yes tila tindou zi le isov, ra tilup zi, ve tigham ghanghaniiŋ igharau maet ndouŋ tawe ziige. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Maet ndouŋ tana, Laban iwaat eeza ila yes Aramea aliŋazi ighe Yegar Saduta. Ve Yakop iwaat maet tana eeza Galet. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban isaav ighe: “Aazne, maet ndouŋ tane igheen ila ituru sosoon to ipariaaŋ saveeŋ mbuaaŋ toit.” Tauta tiwaat maet ndouŋ tana eeza Galet. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Ve tiwaat eeza ite Mizpa. Pasaa, Laban isaav tauvene: “Ituru aat tavaghito ghiit muul mako. Pale taleep soghan soghan pa tauun. Eemon Maaron tauu pale ighit ghiit irau saawe. Tauvene isaav ighe yo ureu saveeŋ mbuaaŋ toit, ve ugham sosor pa natug livaŋa, ma uvai livaa ite paam, na uyamaan ghom. Pa Maaron ilooŋ saveeŋ mbuaaŋ toit wa. Ve saa ŋgar tau iit taghamu imin ŋgozaaŋ, ve tamtamon tiwataghi mako, ene i ighita.” ");
INSERT INTO tuc_t_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ve Laban isaav pa Yakop muul ighe: “Ughita maet ndouŋ ve maet payozeeŋ tau naghur zi tigheen ila sosoon ne. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Gabua ru tane pale tipei ŋgar toit. Leso mataan iŋgal saveeŋ mbuaaŋ toit. Saveeŋ tauvene: Ituru irau tamalaaŋ pa maet ndouŋ tane, ve yau nalat navaghamun ghom, ma yo ulam uvaghamun ghau ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Maaron to Abaram ve Maaron to Naor pale tighit ghiit ve tigabiiz ghiit. Isaav ighe toit eta igham sosor, ene aat tighur atuya pani.” Laban isavsaav le isov, ve Yakop aana iwaat Maaron tau taama Isak iroi ve ibesbees pani na eeza to ipariaaŋ saveeŋ mbuaaŋ toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ra Yakop irav ŋgai ee, ve imozi izala loloz daaba imin watooŋrau pa Maaron. Ve ipoi ziiri waaro toozi tisov tilam, ve yesŋa tilup zi pa ghanghaniiŋ. Tighanghan le isov, ra tigheen izi ta sewe pa mboŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mboŋoozo ndoroome, ve Laban iburig, itak natlivaŋa ve timŋa nimazi, ve ipalot zi pa saveeŋ siriv, ra ipul zi, ve imuul ila pa nugh tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban ipul zi ve ila, ve Yakop paam ipaburigin laghooŋ tooni muul. Ilaagh ila le aŋela siriv to Maaron tivot tooni izi eez livuugha. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakop ighit zi, ve isaav ighe: “Wai! Ene zaaba to Maaron niazi to lepoogh.” Tauvene iwaat nugh tawe eeza Mahanaim. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ra imbaaŋ tamtamon siriv ighe tigham aavo ve timuuŋ tila pa toogha Esau tau ilepleep izi taan sirivu to Seir. Taan tawe, eeza ite Edom. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I isaav ariaaŋ pazi ighe: “Yam ala avot to tiina tsiau Esau, mako asaav pani aghe: ‘Besooŋa tsio Yakop isaav tauvene: Yesuru waagha Laban tikaria lepoogh wa. Tauta aazne, i ighe imuul ilam. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I le makau, doŋki, sipsip, mekmek, ve besooŋa zitamoot ve zilivaa katini. Tauvene imbaaŋ ghei nilam to nipaes payo, leso ughamu toman lolom poia.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yakop isavsaav pazi le isov, ve tila tighita Esau. Tighita le isov, ra timuul tila to Yakop ve tipaes pani tighe: “Yei nila nivot to togham, ta nimuul nilam. Ve ulooŋ! I tomania tamtamon tooni 400 tilaghlaagh tilam tighe tighit ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakop ilooŋ saveeŋ toozi, le roiŋ tiina ighamu ve igham ŋgar naol. Tauvene ivalagh tamtamon tooni tomania ŋgai tooni timin ŋgun ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Pasaa, maata iŋgal tauvene: “Isaav ighe Esau ilam, ve ipaburigin malmal ve irav ŋgun ee timaat, ene pale ŋgun ite irau tighau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ra Yakop isuŋ pa Maaron ighe: “O Yoova, yo Maaron to tibug Abaram ve tamaŋ Isak. Ulooŋ. Muuŋ, yo taum usaav payau ughe namuul nala pa taan tsiau tomania ziiri waaro tsiau. Ve usaav ughe yo pale ugham poghani ghau ve naleep poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Maaron, yau besooŋa tsio. Muuŋ, saawe tau nambut yaa Yordan ve nala, yau leg gabua eta mako. Nakis titi mon ve nalaagh. Eemon yo lolom isaghav ghau, ve ugham poghani ghau kat itaghon saveeŋ mbuaaŋ tsio. Tauta aazne, namuul nalam tomania ŋgun tintiina ru tane. Yau poiag irau to ugham ŋgar tauvene payau mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Maaron, yau naghason ghom. Ugham mulin ghau ila toghag Esau niima. Pa yau naroi pani kat. Pale ilam ve ipaburigin malmal payau tomania azuwagŋa ve natugŋa, ve irav ghei nisov nimatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Maaron, matam iŋgal saveeŋ tau umbua tomani ghau. Yo usaav payau ughe pale ugham poghani ghau, ve ugham paaghu tsiau timasa timin naol le irau tinin zi mako, imin sausau to te.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakop isuŋ le isov, ve ileep izi nugh tawe pa mboŋ. Mboŋoozo ra, ivureer ŋgai siriv tila soghan ighe ipamuuŋ zi tila pa toogha Esau. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ŋgai tauvene: Mekmek upin tamoot saŋavul (200), ve zitamoot tamoot ee (20). Sipsip upin tamoot saŋavul (200), ve zitamoot tamoot ee (20). ");
INSERT INTO tuc_t_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kamel upin tamoot ee saŋavul (30) tomania natuzŋa. Makau upin tamoot ru (40), ve zitamoot saŋavul (10). Ve doŋki upin tamoot ee (20) ve zitamoot saŋavul (10). ");
INSERT INTO tuc_t_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakop ighur ŋgai tawe tila ŋgun ŋgun, ve ighur zi tila besooŋa tooni siriv nimazi, ve isaav pazi ighe: “Yam amuuŋ. Eemon alup gham pa laghooŋ sov. Alaagh soghan soghan pa taumim.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ve Yakop isaav ariaaŋ pa besooŋa tau ilaagh muŋgaaŋ na tauvene: “Isaav ighe toghag Esau ilam le izaa tsio, ve ighason ghom ighe: ‘Yo besooŋa to sei? Ve ula sindei? Ve ŋgai ŋgun tana to sei?’ ");
INSERT INTO tuc_t_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ighe i ighason ghom tauvene, o uyol aliiŋa ughe: ‘Ŋgai tane, to besooŋa tsio Yakop. I ighe igham zi sorok pa tiina tooni Esau. I tauu ilaghlaagh murei.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakop igham saveeŋ raraate pa besooŋa tooni tau imin ru na, ve ite tau imin tol, ve besooŋa tooni tisov tau matazi pa ŋgai ŋgun ŋgun tana ve tigham zi gha tila. Ve isaav pazi tauvene: “Yam ala azaa to toghag Esau, mako asavia saveeŋ raraate mon pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ve asaav pani aghe: ‘Tiina, besooŋa tsio Yakop ilaghlaagh murei.’” Yakop igham tauvene pasaa, maata iŋgal ighe: “Yau aat nagham gabua naol tane imuuŋ ila pani sorok. Leso nagharaat loolo, ve saawe tau nala peria tooni, i aat loolo poia payau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tauvene gabua naol tau Yakop ighe igham pa toogha na, i ipamuuŋ zi timuuŋ tila. Eemon i tauu ileep izi nugh tana pa mboŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mboŋ eemon tana, Yakop iburig, ve igham azauŋa tauu ru tomania azauŋa zazagheeŋ ru, ve natŋa saŋavul ve ee. Tila titaghon maghat to yaa Yabok ve tila tivool pa paaŋa ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","I ila ighur zi tizi, ve imuul ila isaav pa besooŋa tooni tigham yauyauŋ tooni siriv, ve titaghon zi tila tivool. Ve i zigani ileep ta sewe pa mboŋ. Ilepleep, ve ŋeer ee ilam ve yesuru Yakop tivatovai tapirizi izi ta sewe le nughizau. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ŋeer tawe ighita ighe i tapiri irau to iliiv Yakop mako. Tauvene irav Yakop ŋgoi le seŋgaaŋa imazugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ra isaav pani ighe: “Upul ghau nala. Pa nughizau tane.” Eemon Yakop isaav pani ighe: “Mako. Yau aat nakiskis ghom tauvene le irau ughur palotiiŋ izaa tsiau, o napul ghom ula.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tauvene ŋeer tana ighasoni ighe: “Ezam sei?” Yakop iyol aliiŋa ighe: “Yau ezag Yakop.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ŋeer tana isaav pani muul ighe: “Yo aat ezam Yakop muul mako. Aat tiwaat ghom Israel. Pasaa, yamru Maaron ve tamtamon avatovai tapirimim le uliiv zi wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ra Yakop ighason ŋeer tana ighe: “Ezam sei?” Ŋeer tana iyol aliiŋa ighe: “Mindai ta yo ughason ghau pa ezag?” Ra ighur palotiiŋ izaa to Yakop, ve ipuli gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakop iburig ve isaav ighe: “Aazne, yau naghita Maaron naagho pa matag, eemon namaat mako.” Tauvene iwaat nugh tawe eeza Peniel. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aaz izaa peria, ve Yakop ipul nugh Peniel, ve ilaagh sadiŋ sadiŋia gha ila. Pasaa, ŋgoi seŋgaaŋa imazugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Puughu tane, ta muuŋ ve ilam aazne, yes Israela irau tighan ŋgai miiza tau ipaak ila tuua to ŋgoi ne mako. Pasaa, ŋeer tawe irav Yakop ŋgoi le imazugh. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakop ilaagh ila, ve maata ila le ighita toogha Esau ilam tomania tamtamon tooni 400. Tauvene Yakop ivalagh natŋa to Lea, Rael, ve besooŋa tooni zilivaa ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I ighur besooŋa tooni zilivaa ru tomania natuzŋa timuuŋ, ve Lea tomania natŋa titaghon zi, ve Rael yesuru naatu Yosep tilaagh murei kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","4","Ve Yakop tauu imuuŋ pazi, ve iŋarui toogha Esau ila. Ilaghlaagh ve iputput aaghe pani irau pai liim ve ru. I ighamgham tauvene, ve toogha ilaan ilam gha isaghavu ve yesuru titaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","6","Ra Esau maata ila le ighita yes zilivaa tomania natuzŋa. Tauvene ighason Yakop ighe: “Ewe savunugha tau yamŋa alam ne?” Yakop iyol aliiŋa ighe: “Tiina tsiau, ewe yau besooŋa tsio natugŋa. Maaron igham zi payau itaghon poia tooni.” I isavsaav, ve besooŋa tooni zilivaa ru tomania natuzŋa tilam tivot, ve tiput aghezi pa Esau. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ve Lea tomania natŋa tilam ve tiput aghezi pani. Ra Yosep yesuru tiina Rael tilaagh murei tilam, ve yes paam tiput aghezi pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ighason Yakop muul ighe: “Laak, yes eval tau tilaagh tomania ŋgai ila ŋgun ŋgun gha tilam tivot tsiau ne, puughu mindai?” Yakop iyol aliiŋa ighe: “Tiina tsiau, yau nagham zi payo, leso ugham ghau toman lolom poia.” ");
INSERT INTO tuc_t_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Eemon Esau isaav pani ighe: “Wai tazig, yau narao pa gabua ta naol ne. Gabua tsio igheen pa taum.” ");
INSERT INTO tuc_t_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Eemon Yakop izoornugh ighe: “Ee-e toghag, isaav ighe lolom poia payau, na ughamuur gabua isov tau yau nagham zi payo na. Pasaa, yo utotoi ŋgar to Maaron payau, ve lolom isaghatin ghau ve ugham ghau toman lolom poia. Tauta naghita naghom, ene imin naghita Maaron naagho. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tauvene ugham gabua tau nagham zi payo na. Pa Maaron igham poghani ghau ve igham leg gabua katini.” Yakop izoornugh, tauta Esau iyok pa ŋgar tooni, ve igham gabua tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ra Esau isaav ighe: “Poia, aburig gha itiŋa tala.” ");
INSERT INTO tuc_t_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Eemon Yakop isaav pani ighe: “Mako. Tiina tsiau, yo umuuŋ. Ughita. Geegeu tane, tapirizi irau tilaagh rekia mako. Ve sipsip ve mekmek tane tighunghun tuz soone, ve tikaria laghooŋ wa. Tapasul zi sov. Isaav ighe tagham zi tilaagh malau pa aaz eemon, ene aat tisov timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tauvene tiina tsiau, yo umuuŋ, ve yau tomania yes geegeu ve ŋgai pale nitaghon ghom. Pale nilaghlaagh poi taghon geegeu ve ŋgai tapirizi, le nilat peria tsio izi nugh Seir.” ");
INSERT INTO tuc_t_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tauvene Esau iyok pa Yakop saveeŋ tooni ighe: “Poia. Ighe tauvene, yau aat napul tamtamon tsiau siriv tileep tomani ghom. Leso tiŋgin gham ve yamŋa alam.” Eemon Yakop iyol aliiŋa ighe: “Tiina tsiau, aliŋam poia. Eemon yo utotoi ŋgar popoia naol payau wa. Ugham ŋgar naol sov. Tamtamon tsiau tilepleep.” ");
INSERT INTO tuc_t_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tauvene aaz eemon tana, Esau imuul ila pa Seir. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Eemon Yakop ila Seir mako. Ilaagh ila pa nugh ite, eeza Sukot. Ila ivot ta sewe, ve ipayooz le ruum ee, ve igharaat dur siriv pa ŋgai tooni paam. Tauta tiwaat nugh tawe eeza Sukot. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Saawe tau Yakop ipul taan sirivu to Mesopotamia, ve imuul ilam taan to Kanaan, i ighur niia to lepoogh igharau nugh Sekem. ");
INSERT INTO tuc_t_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ve ighol taan tau i ilepleep pani na ila to yes ziiri waaro to Amor pa maet milmilia ndiŋndiŋ ee (100). (Amor, i Sekem taama). ");
INSERT INTO tuc_t_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ve Yakop igharaat artaal ee izi ta sewe, ve iwaat eeza ighe El Eloe Israel. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Saawe ee, Yakop yesuru Lea natuzliva Dina ila ighe ighita zilivaa paghpaaghu siriv to nugh Sekem. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Amor tau daaba to nugh tawe, naatu Sekem ighita Dina, ve ila isaghavu ve imogheer pani. Amor, i Hep tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem loolo pa Dina kat. Tauvene isavia saveeŋ popoia siriv pani, leso irav aate, ve ighamu loolo poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ve isaav pa taama Amor ighe: “Tamaŋ, yau lolog pa livaa paaghu tawe kat. Ula to ziiri waaro tooni, ve yamŋa agharaat saveeŋ gha leso navaii.” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakop ilooŋ ŋgar mayaŋa tau Sekem igham pa natliva na, eemon isavia saveeŋ eta rekia mako. Pasaa, natŋa zitamoot tila nugh ite ve tigham uraat pa ŋginiiŋ ŋgai tooni ta sewe. Tauvene iyai ghi ve isaŋan zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","I isasaŋan zi gha ilepleep, ve Sekem taama Amor ila ivot tooni ighe yesuru tigharaat saveeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakop natŋa tilooŋ ŋgar saghati tau Sekem igham pa livuzi na, ve timuul tilam tivot nughei. Lolozi poia mako. Atezi yavyav kat. Pasaa, lolozi pa ŋgar tawe ivot pazi mako. Tighita tighe Sekem igham mayaŋa tiina pa yes Israela. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amor isaav pazi ighe: “Alooŋ. Natug Sekem, i itaŋ pa natumliva kat. Mindai, irau ayokia, ve ivai natug? ");
INSERT INTO tuc_t_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Yau naghita naghe ene poia to paaghu toit tivavai zi. Yei pale nivai natmimlivaŋa, ve yam avai natmailivaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Aghita. Taan tiina ighengheen. Yam taumim aghita lemim taan sirivu to aleep pani. Leso itiŋa tavalupu ghiit, ve taparavolia gabua toit ila ilam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ra Sekem iburig ve isaav pa Dina taama Yakop tomania livŋa tauvene: “Isaav ighe lolomim tomania ŋgar tsiam ilam tsiau, saa gabua tau lolomim pani na, yau aat nagham payam. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tauvene asavia livaa atuya payau. Izi, ma izaa, yau pale nagham payam. Eemon ayok payau to naghamu imin azuwag.” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Eemon Yakop natŋa atezi yavyav kat pa Sekem pa ŋgar mayaŋa tau i igham pa livuzi Dina na. Tauvene tisik saveeŋ sorok imin tombanooŋ Sekem gha taama Amor tighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Vene mako. Tamoot tau ighe tirav waaro mako, ene irau niyok pani to ivai livumai mako. Pa igham mayaŋa payei. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Eez eemon ta ighengheen. Yam irau ataghon yei gabuamai, ve arav zitamoot tsiam tisov warozi le amin yei, o niyok pa saveeŋ tsiam, ");
INSERT INTO tuc_t_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ve niyok payam to itiŋa tavavai ghiit, ve nileep izi nugh tane, ve tavalupu ghiit tamin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Eemon isaav ighe yam ayok pa ravuuŋ waromim mako, ene aat nilat nigham livumai, ve nighau nila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Amor yesuru naatu Sekem tilooŋ saveeŋ tane, ve tiyok pani tighe ene ŋgar poia. Tauvene rekia mon, ve Sekem ipaburigin gabua tana saveeŋa. Pasaa, i loolo pa Yakop natliva kat. Sekem, ziiri waaro to taama tisov titandagh pani ve tiloŋlooŋ aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tauvene Amor yesuru naatu Sekem tila pa nugh to lupuuŋ tau igharau eez maata na, ve tisaav pa yes zitamoot tisov to nugh Sekem tighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Zeran tawe, zeran to marowa, ve tighe itiŋa tavalupu ghiit tamin eemon. Iit taan toit tiina. Irau tapul sirivu pazi. Leso tilaghlaagh pani, ve tiraukol pa gabua toozi, ve itiŋa irau tavavai ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Eemon yes tiyooz ariaaŋ pa gabua eemon tane. Tighe tarav zitamoot toit tisov warozi le raraate imin yes, o tiyok pa tileep tomani ghiit, ve itiŋa tavalupu ghiit tamin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ighe tataghon ŋgar toozi, ene pale imin eez pait to tagham ŋgai toozi, tomania yauyauŋ toozi tisov timin iit leen. Aiyo, yam taumim asaav. Mindai, tayok pa ŋgar toozi, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yes to nughei tilooŋ saveeŋ to Sekem yesuru taama Amor, ve tiyok. Tauvene tirav zitamoot toozi tisov warozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Uraat to ravuuŋ warozi isov, ve mboŋ imin tol ve zitamoot to nugh Sekem tilepleep toman yavyavuuŋ tiina soone. Ra Yakop natŋa ru, Simeon ve Levi tau Dina livŋa na, tiburig toman mbuzaagh toozi, ve tiloŋ tila nugh Sekem. Yes to nughei tikankaan pa ŋgar tau yesuru tighe tighamu. Yesuru tila, ve tirav zitamoot tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Amor ve naatu Sekem paam, tirav yesuru pa mbuzaagh gha timaat. Ra tigham livuzi Dina, ve tipul ruum to Sekem, ve tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","29","Ra Yakop natŋa siriv anazi tiburig, ve tiloŋ tila nugh Sekem, ve tiyauur saveeŋ mariŋ to yes tau tirav zi timaat na, imin yatuuŋ ŋgar saghati tau tigham pa livuzi Dina na. Tigham makau, doŋki, ve sipsip toozi, tomania kuaz ve gabua toozi siriv tau igheen ruum loolo na. Gabua toozi tau igheen nughei, ve gabua to uum paam, eta igheen muul mako. Tiyauur zi le tisov. Ve tiyauur zilivaa toozi tomania natuzŋa paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yes tigham ŋgar tana, tauta Yakop iyaon Simeon yesuru Levi ighe: “Yamru avaghamunia ezag wa. Yes Kanaana ve Peresa tau tilepleep taan sirivu tane pale tighit ghau tighe yau saghatig kat, ve tighur koi payau. Isaav ighe tilup zi ve tigham malmal pait, ene pale tirav ghiit tasov tamatmaat. Pasaa, iit eval mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Eemon yesuru tiyol aliiŋa tighe: “Livumai, i livaa eta to eez, ta ŋeer tawe igham ŋgar tauvene pani ne?” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Murei ra, Maaron isaav pa Yakop ighe: “Uburig uzala pa nugh Betel, ve uleep ta sewe. Ve ugharaat artaal eta payau. Yau Maaron tau navot tsio indeeŋ saawe tau yo ughau pa togham Esau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tauvene Yakop isaav pa zeran tooni tomania tamtamon siriv tau yesŋa tilepleep na, ighe: “Yam asuruuv maaron tsiam anunuzi tisov tilalez, ve agharaat taumim leso aŋgalaaŋ ila Maaron maata, ve ayol gham pa nonoghiiŋa tsiam popoia. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mako taburig ve tazala pa nugh Betel. Yau naghe nagharaat artaal pa Maaron izi ta sewe. Pasaa, saawe tau pataŋani igham ghau, i ilooŋ suŋuuŋ tsiau ve igham mulin ghau. Ve nugh sindei tau nala naleep pani na, i ileep tomani ghau ve maata payau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tauvene tiyauur maaron karomŋa toozi anunuzi ve tigham zi tilam, ve tizugh padood tizi pa taliŋazi, ve tighur zi tila to Yakop. Ra i itavi zi ila ai tiina ee puughu. Ai tawe iyooz igharau nugh Sekem. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ra tiburig gha tila. Tamtamon tisov tau tileep tigharau nugh Sekem na, Maaron igham roiŋ tiina ivot pazi. Tauvene toozi eta itaghon zi pa malmal mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakop tomania tamtamon tooni tisov tilaagh tila le tivot nugh Lus. Lus igheen ila taan sirivu to Kanaan. Eeza ite Betel. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ra Yakop igharaat artaal ee, ve iwaat nugh tawe eeza El Betel. Pasaa, saawe tau i ighau pa toogha Esau, Maaron ivot tooni ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tileep ta sewe ve Debora, besooŋa livaa to Yakop tiina Rebeka imaat. Saawe tau Rebeka marani ve ilam, Debora iŋgini. Yes titavia izi ai tiina ee puughu tau iyooz igharau nugh tawe. Tauvene tiwaat ai tana eeza tighe “Ai to taŋiiz.” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Saawe tau Yakop ipul Mesopotamia, ve imuul ilam ivot taan to Kanaan, Maaron ivot tooni, ve ighur poia izaa tooni ighe: “Yo ezam Yakop. Eemon aazne ve ila, irau tiwaat ghom Yakop muul mako. Aat tiwaat ghom Israel.” Tauvene iwaat Yakop eeza paaghu Israel. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ve Maaron iseeŋ saveeŋ tooni ighe: “Yau Maaron Saksaki Tau Naliiv Zimaronŋa Tisov. Paaghu tsio aat timasa timin naol, ve timin nugh nugh pughuzi. Ve kinik siriv pale tivot ila to paaghu tsio. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Taan tane, muuŋ nambu saveeŋ tomania Abaram ve Isak naghe pale nagham pazi. Ve aazne, nagham taan tane payo ve paaghu tsio tau pale tivot murei.” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Maaron isavsaav tomania Yakop le isov, ra ipuli, ve imuul izala. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakop ipayooz maet malaua ee izi nugh tau Maaron isavsaav pani na, leso imin ilaal pa nugh tawe. Ve iliŋ vaen izala maet tawe paavo imin watooŋrau, ve iliŋ ŋgoreeŋ izala paavo paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ve iwaat nugh tawe eeza Betel. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ra Yakop tomania tamtamon tooni tipul Betel. Tilaagh tila tigharau nugh Eprata soone, ve Rael aapo yavyav ighe ipoop. Popaaŋ tooni ipataŋan kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Saawe tau yavyavuuŋ tiina kat ighamu, livaa tau ipapoopa na, isaav pani ighe: “Uroi sov! Ene upoop tamoot ite.” ");
INSERT INTO tuc_t_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rael igharau ighe imaat, ra iyavaghan, ve iwaat naatu tawe eeza Benoni. Eemon Yakop itoor eeza muul ighe Benyamin. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tauvene Rael imaat, ve titavia izi eez tau ila pa nugh Eprata na ziige. (Eprata, eeza ite Betelem.) ");
INSERT INTO tuc_t_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ra Yakop ipayooz maet ee imin ilaal pa naal to Rael. Maet tawe iyozyooz soone. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel iburig muul, ve ilaagh ila ivot nugh ee. Nugh tawe, ruum daaba malaua ee iyozyooz, eeza Eder. Yakop ipul ruum tawe ve ila rig, ra ighur niia to lepoogh ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tilepleep izi nugh tawe, ve Ruben ila to Bila tau taama azaawa zazagheeŋ na, ve yesuru tigheen. Ŋgar tau ighamu na, taama Israel ilooŋ vaaru paam. Yakop natŋa zitamoot saŋavul ve ru tivot tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ipoop Ruben, i Yakop naatu aidaaba, mako Simeon, Levi, Yuda, Isakar, ve Zebulun. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rael ipoop Yosep yesuru Benyamin. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bila tau besooŋa livaa to Rael na, i ipoop Dan yesuru Naptali. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ve Silpa tau besooŋa livaa to Lea na, i ipoop Gat yesuru Aser. Saawe tau Yakop ilepleep izi Mesopotamia, tipoop natŋa tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakop iburig muul, ve ila ivot to taama Isak izi nugh Mamre tau igharau nugh Kiriat Arba. (Kiriat Arba eeza ite Ebron. Nugh tawe, ta muuŋ Abaram yesuru Isak tileep timin loom pani.) ");
INSERT INTO tuc_t_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak ilepleep le imin kooŋ kat, ra imaat ve ila ileep tomania ziiri waaro tooni tau timaat muuŋ na. Ndaman tooni irau ndiŋndiŋ ee tamoot paaŋ (180), ra imaat ve natŋa ru, Esau gha Yakop, titavia. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ene pitiiŋ to Esau tomania paaghu tooni. (Esau eeza ite Edom.) ");
INSERT INTO tuc_t_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ivai Kanaan tinazi ru: Ada ve Oholibama. Ada, i Elon natliva. Elon, i Hit tamazi. Oholibama taama Ana, ve tiimbu Zibeon. Zibeon, i Ep tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau ivai Basemat paam. Basemat, i Ismael natliva, ve Nebaiot liivu. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada yesuru Esau tipoop Elipas, ve Basemat yesuru Esau tipoop Reuel. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama ipoop Yeus, Yalam, ve Kora. Esau natŋa tawe, ta tipoop zi izi taan Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Murei ra, Esau iburig igham azauŋa, natŋa, ve tamtamon tooni tisov tau tilepleep tomania, ve ŋgai ma yauyauŋ tooni naol isov tau i igham zi izi Kanaan na, ve ila ileep soghan pa taazi Yakop. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pasaa, Yakop yesuru Esau ŋgai toozi katini, ve taan irau zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tauvene Esau ila ileep izi taan sirivu to Seir loloza. (Esau eeza ite Edom.) ");
INSERT INTO tuc_t_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ene pitiiŋ to Esau paaghu tooni. Esau imin puughu pa yes Edoma tau tileep izi taan sirivu to Seir loloza. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau natŋa tivot tauvene: Yesuru azaawa Ada tipoop Elipas, ve yesuru azaawa Basemat tipoop Reuel. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Esau naatu Elipas natŋa ene: Teman, Omar, Sepo, Gatam, ve Kenas. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipas ivai livaa ite paam imin azaawa zazagheeŋ, eeza Timna, ve i ipoop Amalek. Ene Esau paaghu tooni tau tivot ila to azaawa Ada. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel natŋa, ene: Naat, Sera, Samma, ve Miza. Ene Esau paaghu tooni tau tivot ila to azaawa Basemat. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau azaawa ite Oholibama. I Ana natliva, ve Zibeon timliva. Yesuru Esau tipoop natuzŋa tol: Yeus, Yalam, ve Kora. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau paaghu tooni tawe tila tileep izi nugh toozi eŋaeŋa, ve timin zimaronŋa pa rumei toz toz. Esau naatu aidaaba Elipas natŋa, ene: Teman, Oman, Sepo, Kenas, Kora, Gatam, ve Amalek. Elipas paaghu tooni tawe tileep izi taan sirivu to Edom, ve timin zimaronŋa pa rumei toz toz. Ena Esau paaghu tooni tau tivot ila to azaawa Ada. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau naatu Reuel natŋa, ene: Naat, Zera, ve Samma. Yes paam tila tileep lez lez izi taan sirivu to Edom, ve timin zimaronŋa pa rumei toz toz. Ena Esau paaghu tooni tau tivot ila to azaawa Basemat. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau azaawa Oholibama ipoop Yeus, Yalam, ve Kora. Yes paam timin zimaronŋa pa rumei toz toz. Oholibama, i Ana natliva. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tamtamon tisov tane, ene Esau paaghu tooni. Yes tisov timin zimaronŋa pa rumei toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ŋeer ee ileep izi taan sirivu to Edom paam, eeza Seir. I Or tamazi. Seir natŋa, ene: Lotan, Sobal, Zibeon, Ana, Dison, Ezer, ve Disan. Yes tila tileep lez lez izi taan sirivu to Edom, ve timin zimaronŋa pa yes Ora. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan natŋa zitamoot, ene Ori ve Omam. Ve Lotan liivu eeza Timna. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal natŋa, ene: Alban, Manaat, Ebal, Sepo, ve Onam. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon natŋa, ene: Aya ve Ana. Ana tane, ta iŋginŋgin doŋki to taama izi nugh ŋginaaŋa, ve indeeŋ yaa tuntunu ee ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ipoop natŋa ru. Tamoot eeza Dison, ve livaa eeza Oholibama. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison natŋa, ene: Emdan, Esban, Itran, ve Keran. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer natŋa, ene: Bilan, Zaaban, ve Akan. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ve Disan natŋa, ene: Uz ve Aran. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Tauvene Or paaghu tooni tau tivot ve timin zimaronŋa pa rumei toz toz, ene Lotan, Sobal, Zibeon, Ana, Dison, Ezer, ve Disan. Yes tana, ta tiŋgin yes Ora, ve tileep lez lez izi taan sirivu to Seir. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Muuŋ, saawe tau yes Israela lezi kinik eta soone, yes kinik tane tiŋgin taan sirivu to Edom. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor naatu Bela, i kinik tau iŋgin taan sirivu to Edom imin maata. Nugh tooni eeza Dinaaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela imaat, ve Zera naatu Yobab igham niia. Yobab nugh tooni Bosra. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab imaat, ve Usam igham niia. Usam ilam pa taan sirivu to yes Temana. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Usam imaat, ve Bedat naatu Adad igham niia. Adad nugh tooni Abit. Yesŋa yes Midiana tiparav izi taan sirivu to Moap, le i iliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Adad imaat, ve Samla igham niia. Samla nugh tooni Masereka. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla imaat, ve Saul igham niia. Saul nugh tooni Reobot. Nugh tawe igharau yaa tiina Euprates. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul imaat, ve Akbor naatu Bal-Anan igham niia. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal-Anan imaat, ra Adad igham niia. Adad nugh tooni Pau, ve azaawa eeza Meetabel. Meetabel tiina eeza Matret, ve timliva eeza Me-Zaab. ");
INSERT INTO tuc_t_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Tauvene Esau paaghu tooni tau tila tileep izi nugh toz toz, ve timin zimaronŋa pa rumei toz toz, ene Timna, Alba, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibzar, Magdiel, ve Iram. Yes tana, ta timin zimaronŋa pa yes Edoma, ve tiŋgin taan toz toz. Esau paaghu tooni tana, ta tivot ve timin puughu to yes Edoma. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakop ighur niia to lepoogh izi taan to Kanaan tau muuŋ taama Isak ileep imin loom pani na. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ene sinaiŋ to Yakop tomania natŋa. Saawe tau Yakop naatu Yosep ndaman tooni irau saŋavul liim ve ru (17), yesŋa tooghŋa siriv tau Yakop azauŋa zazagheeŋa Bila gha Silpa natuzŋa na, tiŋginŋgin ŋgai toozi. Saawe siriv, ighe tooghŋa tigham gabua eta isosor, mako ila ipaes pa tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakop loolo pa Yosep iliiv natŋa tisov. Pasaa, i imin olman, ra azaawa Rael ipoopa. Tauvene Yakop igharaat Yosep le nonoghiiŋa malaua ee tau ŋgereeta paghuuna kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yosep tooghŋa tighita tamazi loolo pa Yosep iliiv zi, tauvene ireu lolozi, ve tisavia saveeŋ poia eta pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Mboŋ ee, Yosep igheen le iviv. Ra ivotia vivuuŋ tooni pa tooghŋa ighe: “Ou, alooŋ vivuuŋ tsiau ee ne. Yau naviv tauvene: Iit talepleep izi uum, ve tagham uraat pa posaaŋ aniiŋ. Malau mako ve aniiŋ poos tsiau iburig iyooz duduuŋ, ve pospoos tsiam tisov tilam tiyooz tilivut tsiau, ve tiput aghezi pani.” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yosep tooghŋa tilooŋ saveeŋ tane, ve tisaav pani tighe: “Wai! Yo upakur ghom pasaa! Yo ughe umin tiina payei ve uŋgin ghei?” Tauvene saveeŋ tau i isavia pa vivuuŋ tooni na, igham zi atezi yavyav kat pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Murei ra, i iviv muul. Ve ipaesia vivuuŋ tana paam pa tooghŋa ighe: “Ou, alooŋ vivuuŋ tsiau ite. Yau naviv tauvene: Anunug nayozyooz, ve aaz, kaiyo, ve pitum saŋavul ve ee tilam tiput aghezi payau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yosep taama ve tooghŋa tilooŋ vivuuŋ tooni tawe, ve taama iyaoni ighe: “Wai! Saa vivuuŋ ee tauvene? Yo ughe yau gha tinam, tomania toghamŋa, ve tazim marani pale nisov nilam niput aghemai payo?” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tauvene Yosep tooghŋa atezi yavyav pani kat ve tighur koi pani. Eemon taama Yakop maata kisin Yosep saveeŋ tooni, ve ighamgham ŋgar pa puughu. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tilepleep le saawe ee, Yosep tooghŋa tila nugh Sekem ziige, leso matazi pa ŋgai to tamazi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tauvene olman Israel isaav pa Yosep ighe: “Ulooŋ. Toghamŋa tiŋginŋgin ŋgai toit ta nugh Sekem ziige we. Yau naghe nambaaŋ ghom ula ugig zi.” Yosep iyol aliiŋa ighe: “Poia. Yau aat nala.” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tauvene taama Israel isaav pani muul ighe: “Ula ughita toghamŋa ve ŋgai toit. Lepoogh toozi mindai? Tileep poi, ma mako? O, umuul ulam upaes payau.” Saawe tana, olman Israel tomania natŋa tilepleep taan raraate to Ebron. Tauvene Yosep ilaagh ila ivot nugh Sekem, ve iil tooghŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","I ilaghlaagh ila le ŋeer ee izaa tooni ve ighasoni ighe: “Aa, yo uil sei?” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosep iyol aliiŋa ighe: “Yau nail toghagŋa tomania ŋgai tsiei. Isaav ighe yo ughit zi tileep pa ziige eta, o usavi zi payau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ŋeer tawe isaav pani ighe: “Oyai, ulam rekia, kanaŋ ughit zi. Mako gha tipul nugh tane, ve tisakia tila wa. Eemon nalooŋ tighe tila pa nugh Dotan.” Tauvene Yosep itaghon tooghŋa ila, le indeeŋ zi izi nugh Dotan. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ilaghlaagh malau soone, ve tooghŋa matazi ila le tighita. Tauvene tivasavo zi pa ravuuŋni imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tighe: “Aghita! Ŋeer tau ighita vivuuŋ naol, tauta ilam we! ");
INSERT INTO tuc_t_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tala taravu imaat, ve tasiki izila puura to yaa taiŋ eta. Ighe tighason ghiit pani, o taghe: ‘Yei nikankaan pani. Aat ŋgai sagsag eta ighani wa.’ Mako taleep ve taghita: Vivuuŋ tooni pale ighur anooŋa mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Eemon Ruben ilooŋ saveeŋ toozi, ve ighe ipaghau Yosep pa nimazi. Tauvene isaav pazi ighe: “Mako. Taravu imaat sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Taumim aliŋ siŋ pani, ene poia mako. Aghita. Ene nugh ŋginaaŋa. Tasiki izila puura to yaa taiŋ tane. Taravu imaat sov.” Ruben isavia saveeŋ tane, pa ighe ipaghau Yosep pa tooghŋa. Leso murei na, ighuru imuul ila to tamazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosep ila peria toozi, ra tiburig, tisaghavu, ve tizuzuum nonoghiiŋa tooni malaua tau ŋgereeta paghuuna na, izi. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ra tighamu tila, ve tisiki izila puura to yaa taiŋ tau Ruben isavia na. Puura tawe, loolo ŋginaaŋa. Yaa ipot ila mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ruben ipul zi, ve ila ilaghlaagh malau rig, ve yes siriv mbolezi izi pa ghaniiŋ aniiŋ. Malau mako, matazi ila le tighita tamtamon siriv to Ismael tilam. Zeran tawe tilam pa taan sirivu to Gileat, ve tighe tizila Isip pa raukoliiŋ. Kamel toozi tighuuz gabua maata maata tau vazizi popoia ve atuyazi tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda ighita zeran tana, ve isaav pa tooghŋa ve tazŋa ighe: “Aghita. Isaav ighe iit tarav taziin tane imaat ve taŋgooza, pale iuul ghiit mindai? ");
INSERT INTO tuc_t_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tagholia ila to yes Ismaela tawe. Irau tauun taliŋ siŋ pani mako. Pasaa, i taziin, ve iit siŋ eemon.” Yes tilooŋ saveeŋ tooni tane, ve tisov tiyok pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tauvene yes zeran to Midian tau tilaagh pa raukoliiŋ na, tila tivot toozi, ra Yosep tooghŋa tiyauu izaa pa puura tana, ve tigholia ila to yes Midiana pa maet silva irau tamoot ee. Ra yes Midiana tighamu, ve yesŋa tizila pa Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","30","Malau mako, ve Ruben imuul ilam peria puura to yaa taiŋ tana. I ighita taazi Yosep naagho mako, le loolo ipataŋan kat. Tauvene iraŋgat nonoghiiŋa tooni, ve ila isaav pa tazŋa ighe: “Wai, ŋeer marani ilale wa! Pale nagham mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ra tiburig gha tirav mekmek naatu ee, ve tigham nonoghiiŋa to Yosep, ve tikumu pa siŋ to mekmek. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ra tiburig gha timuul tila pa tamazi, ve tisaav pani tighe: “Tamamai, yei nindeeŋ nonoghiiŋa tane. Ughilaalo. To natum Yosep, ma to ŋeer ite paam?” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tamazi ighilaal nonoghiiŋa tawe, ve isaav ighe: “Wai, ene natug raa, nonoghiiŋa tooni. Onoon kat, ŋgai sagsag eta aat iraŋgati gha ighani ila wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakop loolo ipataŋan kat pa naatu Yosep. Tauvene iraŋgat nonoghiiŋa tooni, ve imoŋ pani ve itaŋtaŋ irau saawe malau. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natŋa ve natlivaŋa tisov tila tooni, ve titoova to tirav aate. Eemon i ilooŋ zi mako. Itaŋtaŋ, ve isavsaav ighe: “Yau aat nataŋtaŋ pa natug tauvene le namaat ve nataghoni nazila nugh to mateegha paam.” Tauvene Yakop loolo iveghai naatu mako. Inoknok taŋiiz pani ve ilepleep. ");
INSERT INTO tuc_t_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yes Midiana tila tivot Isip, ra anazi tigholia Yosep ila imin besooŋa sorok to ŋeer ee, eeza Potipar. Potipar, i uraata ee to kinik to Isip, ve i daaba to yes zaaba tau tiŋgin kinik ruum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Saawe tana, Yakop naatu Yuda ipul toŋvetaz tooni, ve ila ileep tomania ŋeer ee to nugh Adulam, eeza Ira. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Ilepleep ta sewe, ve ighita livaa ee ve loolo pani, tauvene ivaii. Livaa tawe, taama eeza Suwa. I to Israel mako. I to Kanaan. Yuda yesuru azaawa tigheen ve livaa aapo, ve ipoop naatu tamoot ee. Yuda iwaat eeza Er. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Murei ra, livaa aapo muul, ve ipoop naatu tamoot ite, ve iwaat eeza Onan. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yesuru tilepleep izi nugh marani Kezib, ve azaawa ipoop naatu tamoot ite imin tol, ve iwaat eeza Sela. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Tilepleep le saawe tau Yuda naatu aidaaba Er ighe ivai, ra taama igham Kanaan tinazi ee pani, eeza Tamar. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eemon Yoova ighita ighe Er, i ŋeer saghati ee. Tauvene iravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ra Yuda isaav pa naatu Onan ighe: “Yo aat utaghon tutuuŋ toit, ve uvai naar to togham. Leso yamru apoop togham tau imaat na le paaghu eta, ve eeza iyozyooz.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Eemon Onan iwatagh: Isaav ighe tipoop, naatu tana irau igham i niia mako. Pale igham toogha niia. Tauvene saawe isov tau yesuru livaa tana tigheen, i ipulpul yaa tooni imamaliŋ izila taan. Leso igham paaghu eta pa toogha sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yoova ighita ighe Onan ŋgar tooni tana poia mako. Tauvene Yoova irav Onan gha imaat paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tauta Yuda isaav pa rauliva Tamar ighe: “Ughita. Azuwam imaat, ve yo umin naar. Umuul ula uleep to tamam, ve usaŋan natug Sela le imin olman irau vaiŋ, mako uvaii.” I isaav tauvene pasaa, iroi pa naatu Sela pale imaat paam imin tooghŋa ru. Tauvene ighur rauliva Tamar gha ila ileep to taama. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tileep le saawe malau rig, ra Yuda azaawa tau Suwa natliva na, aana imaat. Yuda ilepleep le saawe tooni to moŋiiŋ isov, ra yesuru iitete Ira, tau to nugh Adulam na, tila pa nugh Timna tighe tighita yes uraata tooni. Yes tila tileep ta sewe pa ravuuŋ sipsip tooni orozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","14","Saawe tana, Yuda naatu Sela irau vaiŋ wa. Eemon Tamar ighilaal ighe Yuda iyok pani to ivai naatu Sela mako. I ilooŋ tighe raawa Yuda ila nugh Timna pa ghitooŋ yes uraata tau tirav sipsip tooni orozi na. Tauvene izuzuum nonoghiiŋa tooni to moŋiiŋ izi, inonogh ghi pa nonoghiiŋa tooni ite, ve igham uuli sirivu gha ipoon naagho pani. Ra ila mboole izi eez maata to nugh Enaim igharau eez tiina tau ila pa nugh Timna, ve isaŋan raawa. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Malau mako ve raawa Yuda ilam peria. I ighita rauliva mboole izi eez ziige, eemon ighilaalo mako. Ighe pa i livaa eta to eez. Pasaa, Tamar ipoon naagho. Tauvene Yuda ila tooni, ve imbuura ighe: “Ai, irau ituru tala tagheen?” Tamar iyol aliiŋa ighe: “Poia. Eemon pale ugham leg saa imin atuya tsiau?” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda isaav pani ighe: “Murei pale nayambaar mekmek naatu eta ilat payo.” Tamar iyok pa aliiŋa ighe: “Poia. Eemon yo aat ugham leg gabua tsio eta ta aazne imin ilaal pa saveeŋ mbuaaŋ tsio, ve nakisi le saawe tau ighe uyambaar mekmek ilam, o napamuul gabua tsio ilat.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda ighasoni ighe: “Wai, ighe tauvene, pale nagham lem saa?” Tamar iyol aliiŋa ighe: “Ugham leg gabua tau mosim igheen ila, tomania waara tau umbitu ila luam na, ve titi tsio tau ukiskisi na.” Tauvene Yuda igham gabua tol tawe pani, ve yesuru tila gha imogheer pani. Tauta Tamar aapo ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ra Tamar iburig ila, ve izuzuum uuli tau ipoon naagho pani na izi, inonogh ghi pa nonoghiiŋa tooni to moŋiiŋ muul, ve imuul ila pa nughei. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Murei ra, Yuda ighur mekmek naatu ee ila to iitete, ve imbaaŋo ila to livaa tawe. Leso igham mekmek tana pani, ve igham mulin gabua tooni tau i igham pani imin ilaal pa saveeŋ mbuaaŋ tooni na. Eemon i ila iilo le mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tauvene ighason nugh tauŋa siriv ighe: “Ou, livaa to eez tau muuŋ ilepleep izi eez ziige tane na, ila mindai?” Yes tiyol aliiŋa tighe: “Ee-e, livaa eta tauvene ileep sene mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tauvene i imuul ila, ve ipaes pa Yuda ighe: “Nala nail livaa tawe le mako. Ve naghason nugh tauŋa siriv, ve yes tighe livaa to eez eta ileep izi sewe mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tauvene Yuda isaav pani ighe: “Tambaaŋo paam. Ileple. Tanoknok ghasoniiŋ, pale tamtamon tiŋiŋ pait. Gabua tsiau tau livaa tawe igham zi na, igheen gha imin le. Pasaa, yau natoova to nayambaar le mekmek naatu, eemon yo undeeŋa mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaiyo tol ilam ila, ra Tamar vaaru ivot, ve tipaes pa Yuda tighe: “Rawamliva ilaghlaagh sorok gha aapo wa.” Yuda ilooŋ saveeŋ tane, ve iburig gha isaav ariaaŋ ighe: “Ala aghamu ivot ila muuri, andav yav, ve asiki ila yav ighani!” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Eemon saawe tau tigham Tamar tivot tila, i igham gabua tol tau raawa ipul zi tizi tooni na, ve iyambaar zi timuul tila pani tomania aliiŋa tauvene: “Yau apog sorok mako. Yau apog ila to ŋeer tau moosi tomania waara ve titi tooni tane. Taum ughita. To sei?” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ighita ve ighilaal tauu gabua tooni. Tauvene isaav ighe: “Onoon kat. Ene sosor to livaa tawe mako. Ene yau ta namin puughu pani. Pa imin ta nagham natug Sela pani gha ivaii, kanaŋ pataŋani tane irau ivot mako.” Tauvene tigham gabua eta pa Tamar mako. Ve murei, Yuda ila tooni muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Saawe tau Tamar ighe ipoop, tighilaal tighe bogboogŋa ru tileep ila aapo ");
INSERT INTO tuc_t_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","I ipoop bogboogŋa tana, ve ee niima ivot peria. Tauvene livaa tau ipapoop Tamar na, imbit waar siŋsiŋai ila marani tawe niima, ve isaav ighe: “Ene ŋeer aidaaba tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Eemon marani tana niima goroŋia imuul ila, ve malau mako iitete imuuŋ izi. Tauvene livaa tau ipapoop Tamar na isaav ighe: “Wai, yo ugiriŋ etam ite ila, ve uzoornugh gha uvot ulam!” Tauta tiwaat eeza Peres. ");
INSERT INTO tuc_t_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ra iitete tau timbit waar siŋsiŋai ila niima na, aana izi. Ve tiwaat eeza Zera. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yes Ismaela tigham Yosep gha tizila tivot Isip, ra tigholia imin besooŋa sorok ila to Potipar. Potipar, i uraata ee to kinik to Isip. I daaba to yes zaaba tau tiŋgin kinik ruum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","4","Yoova ilepleep tomania Yosep, ve ighurghur poia tooni izazaa tooni. Tauvene uraat tooni tau i ighamghamu izi ruum to Potipar na, ilaan poia mon. Potipar ighita ighe Maaron ileep tomania Yosep, ve iuluule le uraat tooni isov ilaan poia. Tauvene Potipar loolo pani, ve ighuru imin ŋginiiŋ pa ruum tooni, tomania gabua tooni naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Saawe tana ve ila, Maaron ighur poia tooni izaa to Potipar, tomania ruum, ŋgai, uum, ve gabua tooni naol isov. Pasaa, Yosep ndaamo pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tauvene Potipar ipul gabua tooni naol isov ila Yosep niima to iŋgin zi, ve maata ila pani muul mako. Aniiŋ tau i tauu ighani, tane mon ta Potipar iŋgini. Yosep, i ŋeer ee. Tumbuuŋ tooni tomania naagho, ene paghuuna kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Saawe ee, Potipar azaawa ighan maata pani, ighe itoova. Tauvene imbuura ighe yesuru tigheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Eemon Yosep ilooŋa mako, ve iyol aliiŋa ighe: “Ee-e, vene mako. Pa tiina tsiau Potipar, i inumeer ghau kat. Tauta ipul gabua tooni naol isov tau tigheen ila ruum tooni loolo ne ila nimag, ve maata ila pani muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yau namin daaba pa ruum tane imin i tauu. Ve yo mon, ta i iŋgalsekin ghau payo. Gabua ite paam mako. Pasaa, i azaawa yo. Isaav ighe nataghon aliŋam ve nagham ŋgar saghati tane, pale poia? Mako. Ene pale nagham sosor tiina ila Maaron maata.” ");
INSERT INTO tuc_t_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Saawe naol, Potipar azaawa inoknok mburaaŋ Yosep ighe yesuru tigheen. Eemon Yosep ilooŋa mako. Ve ila igharauu paam mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tilepleep le saawe ee, Yosep iloŋ ila ruum loolo ighe igham uraat tooni. Ve saawe tana besooŋa ite paam ileep mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tauvene Potipar azaawa ilaagh ŋaruini ila, ituuk pa nonoghiiŋa tooni, ve isaav pani ighe: “Aa, ulam gha ituru tagheen lak!” Eemon Yosep ipul nonoghiiŋa tooni tawe izi, ve ighau ivot ila muuri. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potipar azaawa ighita Yosep ipul nonoghiiŋa tooni igheen ila i niima, ve ighau ivot ila pa muuri. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","Tauvene iboob pa besooŋa siriv tilam, ve isaav pazi ighe: “Ai, aghita gabua tane! Azuwag igham Hibru tamazi tawe ilam ileep tomani ghiit, ve aazne i igham mayaŋa tiina kat pait. Pasaa, i ilam ighe imogheer payau. Eemon yau naboob aliŋag tiina, tauta iroi gha ipul nonoghiiŋa tooni tane izi, ve ighau ivot ila muuri.” ");
INSERT INTO tuc_t_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ra ikis nonoghiiŋa to Yosep, ve isaŋan azaawa Potipar ilam. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Potipar ilam ivot, ve azaawa ipaes pani ighe: “Ai, Hibru tamazi tau yo ughamu ilam ileep tomani ghiit ne, i igham mayaŋa tiina kat pait. Pasaa, i ilam ighe imogheer payau. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Eemon yau naboob aliŋag tiina, tauta iroi, ve ipul nonoghiiŋa tooni tane izi, ve ighau ivot ila muuri. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ene ŋgar tau besooŋa tsio tawe igham payau.” Potipar ilooŋ saveeŋ tooni, le aate yavyav kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tauvene ikis Yosep, ve ighuru iloŋ ila ruum to yavyavuuŋ. Ruum tawe, yes tau tizorzoor kinik aliiŋa na, tizeev zi tiloŋ tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yosep ilepleep ila ruum to yavyavuuŋ loolo. Eemon Yoova ipuli mako. Ilepleep tomania, ve iuluule. Tauta daaba tau iŋgin ruum to yavyavuuŋ na loolo poia pa Yosep. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ve ighuru to iŋgin zeetŋa siriv tau yesŋa tileep ila ruum to yavyavuuŋ loolo. Saa uraat tau ighe ivot, ene Yosep ighamgham pooz pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Daaba tau iŋgin ruum to yavyavuuŋ na, ipul uraat isov ila Yosep niima, ve maata ila pani muul mako. Pasaa, Yoova ilepleep tomania Yosep. Tauvene uraat isov tau Yosep ighamu, ene ilaan poia mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Saawe siriv ilam ila, ra uraata ru to kinik to Isip tigham sosor pani. Uraata ru tawe, ee iŋgin yaa vaen to kinik, ve ite iŋgin uraat to moziiŋ mberet. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Yesuru tigham kinik aate yavyav kat. Tauvene i ighur zi tiloŋ tila ruum to yavyavuuŋ loolo. Ruum tawe, yes zaaba tau tiŋgin ruum to kinik na, daaba toozi maata pani. Ve Yosep ileep ila ruum tawe loolo paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tauvene daaba tawe ighur Yosep to iŋgin zeran ru tana. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Uraata ru tana tilepleep le mboŋ ee, yesuru tiviv. Eemon vivuuŋ to yesuru, raratezi mako. Pughuzi ite ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mboŋoozo, Yosep ila igig zi. I ighita naghozi, ve ighilaal ighe yesuru lezi pataŋani. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tauvene ighason zi ighe: “Yau naghit gham naghomim poia mako. Mindai, lemim pataŋani eta?” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yesuru tiyol aliiŋa tighe: “Mboŋ, yeiru niviv. Eemon tamtamon eta ileep sene to ivotia vivuuŋ tsiei pughuzi ne mako.” Yosep isaav pazi ighe: “Saveeŋ tsiam, ene onoon. Maaron mon ta irau ivotia vivuuŋ puughu. Poia. Apaesia vivuuŋ tsiam payau ve nalooŋ zi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tauvene uraata tau iŋgin yaa vaen to kinik na, isavia vivuuŋ tooni pa Yosep ighe: “Vivuuŋ tsiau tauvene: Yau naghita ai vaen ee iyooz ila naghog. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ai tawe isalun izaa ve ighur booga tol. Ra rekia mon iruŋ gha anooŋa ivot ve ibulbuul. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ra nagham siriv gha napiis suuru izila rubruub to kinik, ve naghamu nala, ve nazuzuuna ila to kinik.” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosep ilooŋ vivuuŋ tooni tawe, ve isaav pani ighe: “Vivuuŋ tsio, puughu tauvene: Ai vaen tau ighur booga tol, ene izaa to mboŋ tol. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mboŋ tol ilam ila, mako tintinim. Pasaa, kinik pale loolo poia payo, ve igham ghom umuul ula pa uraat tsio. Tauvene yo aat uŋgin yaa vaen, ve ugham pani gha ighun imin muuŋ ughamghamu na. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ve ulooŋ. Saawe tau lepoogh tsio poia muul, matam iŋgal ghau, ve usavia pataŋani tsiau tane pa kinik. Leso uul ghau, ve anag napul ruum to yavyavuuŋ tane, ve navot paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pasaa, taug lolog ve nalam nugh tane mako. Yau naleep izi taan to yes Hibrua, ve timin umbuuŋ ghau. Tauta nalam sene. Ve nagham sosor eta ta sene paam mako. Tighur ghau naloŋ nalam ruum to yavyavuuŋ tane sorok.” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Uraata tau iŋgin uraat to moziiŋ mberet na, ilooŋ Yosep ivotia iitete vivuuŋ tooni puughu le poia, tauvene aana isavia vivuuŋ tooni pa Yosep ighe: “Yau paam naghita vivuuŋ ee. Vivuuŋ tsiau, ene vene: Anunug nalup nakaral tol ve nagud zi. Nakaral tol tawe, mberet tizila le tivon. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nakaral tau igheen saaŋa na, mberet maata maata to kinik tigheen ila loolo. Eemon man tiroov tilam, ve tighanghan mberet tawe le isov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosep ilooŋ vivuuŋ tooni, ve isaav pani ighe: “Ai, vivuuŋ tsio tane, puughu tauvene. Nakaral tol, ene izaa to mboŋ tol. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mboŋ tol ilam ila, mako kinik irav motin luam, ve tisaron patam izala ituuk ila ai. Mako man tiroov tilat, ve tighanghan mizam le isov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Saveeŋ to Yosep tane ighur anooŋa. Mboŋ tol ilam ila, ra tizaa pa saawe to kinik tiina ipoopa. Tauvene kinik igham marewaaŋ tiina, ve ipoi uraata tooni tisov tilam tilup zi pa ghanghaniiŋ. Ra imbaaŋ pa uraata tau iŋgin yaa vaen tooni na, tomania iitete tau iŋgin uraat to moziiŋ mberet na, ighe yesuru tilam paam. Tilam peria, ra kinik ipayooz zi ila eval tiina matazi, ");
INSERT INTO tuc_t_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ve ighur ŋeer tau iŋgin yaa vaen na, imuul ila pa uraat tooni. Tauvene i ighur rubruub ila kinik niima imin muuŋ ighamghamu. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Eemon iitete tau iŋgin uraat to moziiŋ mberet na, tiravu imaat ve tisaron paata izala ituuk ila ai. Tauvene gabua tau ivot na, ene iduduuŋ pa Yosep saveeŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Eemon ŋeer tau iŋgin yaa vaen to kinik na, maata iŋgal Yosep mako. Loolo iveegh pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Ndaman ru ilam ila, ra kinik to Isip ighita vivuuŋ. Iviv ighe anunu iyozyooz izi yaa Nil ziige, ve ighita makau liim ve ru tau paghunazi kat toman tumbuŋazi. Tileep yaa loolo gha tizaa, ve tighanghan pizpiiz ila yaa ziige. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Malau mako ve makau liim ve ru paam, tau koŋkoŋizi ve naghozi saghati, anazi tileep yaa loolo gha tizaa. Ra tiŋarui makau toman tumbuŋazi tawe tila, ve tiyooz tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Makau koŋkoŋizi tawe tiburig ve tighan suvinia makau tau paghunazi toman tumbuŋazi na. Kinik iviv tauvene le isov, ve iburig gha maata iyaryaar. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ra izi igheen muul, ve ighita vivuuŋ ite. Ighita yagoŋ anooŋa liim ve ru tivot ila aia eemon. Yagoŋ anooŋa tawe, popoia kat, tintiina, ve vonvonizi. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Malau mako ve yagoŋ anooŋa liim ve ru paam tivot. Yagoŋ anooŋa tawe, geegeu ve kapazi kat, ve tivaghamgham pa tumbuuŋ. Pasaa, yaghur tuntunu ta ilaagh ilam, ve irav zi le timalai. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ra yagoŋ kapazi tawe tiburig ve titoon suvinia yagoŋ anooŋa tau vonvonizi na. Kinik iviv tauvene, ra iburig gha maata iyaryaar, ve isaav ighe: “Wai, yau aat naviv.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nughizau, ra kinik igham ŋgar naol pa vivuuŋ tooni ru tawe. Tauvene imbaaŋ ila pa zeran mura tomania zeran ŋgara to Isip tisov tilam. Yes tilam tivot tooni, ra isavia vivuuŋ tooni ru pazi gha tilooŋa, ve ighason zi ighe tivotia pughuzi pani. Eemon toozi eta irau ivotia mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tighamgham ŋgar pa vivuuŋ tooni ve tilepleep, ve besooŋa tau iŋgin yaa vaen to kinik na, maata iŋgal Yosep. Tauvene iburig ve isaav pa kinik ighe: “O kinik, ŋgarig gha matag iŋgal sosor tsiau ee. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Muuŋ, yeiru besooŋa tsio tau iŋgin uraat to moziiŋ mberet na, nigham ghom atem yavyav rig. Tauvene yo ughur ghei niloŋ nila ruum to yavyavuuŋ tau daaba to yes zaaba iŋgini na. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nilepleep ta sewe, ve mboŋ ee, yeiru niviv. Eemon vivuuŋ tsiei ru raratezi mako. Pughuzi ite ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Saawe tana, ŋeer paaghu ee to yes Hibrua ileep tomani ghei. I besooŋa to daaba to yes zaaba tau tiŋgin ruum tsio. Yeiru nisavia vivuuŋ tsiei ru pani, ve i ivotia pughuzi payei. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Le saveeŋ tooni ighur anooŋa. Yo ughur ghau namuul nalam pa uraat tsiau muul. Ve etag ite, ene yo uravu imaat, ve tisaron paata izala ituuk ila ai.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kinik ilooŋ saveeŋ tane, ve imbaaŋ uraata tooni tila ighe tigham Yosep ilam. Tauvene rekia mon tila tighamu ivot pa ruum to yavyavuuŋ. Yosep igharaat ghi le isov, ra ila ivot to kinik. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kinik ighita, ve isaav pani ighe: “Yau naghita vivuuŋ ru, ve tamtamon eta irau ivotia pughuzi payau mako. Eemon tipaesi ghom payau tauvene: Isaav ighe ulooŋ vivuuŋ to tamtamon eta, yo irau uvotia puughu.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosep iyol aliiŋa ighe: “Yau taug narao mako. Eemon Maaron, i irau ivotia vivuuŋ tsio. Leso uwatagh eez to uleep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tauvene kinik ipaesia vivuuŋ tooni pa Yosep ighe: “Yau naviv naghe anunug nayozyooz izi yaa Nil ziige, ");
INSERT INTO tuc_t_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ve naghita makau liim ve ru tau paghunazi kat toman tumbuŋazi, tileep yaa loolo gha tizaa, ve tighanghan pizpiiz ila yaa ziige. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Malau mako ve makau liim ve ru tau koŋkoŋizi ve naghozi saghati kat, anazi tileep yaa loolo gha tizaa. Ta muuŋ ve ilam, yau naghita makau saghati eta tauvene ileep izi taan Isip ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Makau koŋkoŋizi tawe, tiburig le tighan suvinia makau tau toman tumbuŋazi na. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Eemon tipasaria apozi rigta mako. Koŋkoŋizi raraate mon imin muuŋ. Tauvene tamtamon eta irau iwatagh ighe yes tighan makau tau toman tumbuŋazi ne mako. Yau naghita vivuuŋ tane le isov, ve naburig gha matag iyaryaar. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ra nazi nagheen, ve naviv muul. Naghita yagoŋ anooŋa liim ve ru tivot ila aia eemon. Yagoŋ anooŋa tawe, popoia kat ve vonvonizi. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Malau mako ve naghita yagoŋ anooŋa liim ve ru paam tivot. Yagoŋ anooŋa tawe, geegeu ve kapazi kat, ve tivaghamgham pa tumbuuŋ. Pasaa, yaghur tuntunu ilaagh ilam, ve irav zi le timalai. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yagoŋ anooŋa kapazi tawe tiburig ve titoon suvinia yagoŋ anooŋa popoiazi le tisov. Naghita vivuuŋ ru tane, le nagham ŋgar naol. Tauta nambaaŋ ila pa yes mura tilam, ve nasavia vivuuŋ tsiau ru tane pazi. Eemon toozi eta irau ivotia pughuzi payau mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosep ilooŋ vivuuŋ ru tawe, ve isaav pa kinik ighe: “Vivuuŋ tsio ru, pughuzi eemon. Ene Maaron itotoi ghom pa gabua tau i ighe ighamu ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Makau liim ve ru tau paghunazi kat, ve yagoŋ anooŋa liim ve ru tau popoia na, pughuzi eemon. Ene izaa to ndaman liim ve ru. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ve makau sasaghati liim ve ru tau koŋkoŋizi kat ve ughit zi tivot murei na, tomania yagoŋ anooŋa kapazi liim ve ru tau yaghur tuntunu ilaagh pa nugh ŋginaaŋa ilam ve irav zi gha timalai na, ene paam izaa to ndaman liim ve ru. Ndaman liim ve ru tana, pitool tiina pale ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Gabua tane, ene imin tau nasaav payo. Maaron itotoi gabua tau i ighe ighamu ivot na payo. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","“Ulooŋ. Ndaman liim ve ru tane, mariri tiina kat pale tivot irau taan isov to Isip, ve yam arau kat pa aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Ndaman liim ve ru tane isov, mako pitool tiina kat ivot, ve igheen irau ndaman liim ve ru muul. Pitool tawe pale ivaghamunia taan tsiam, ve tamtamon tisov to Isip pale lolozi iveegh pa saawe to mariri tiina tau muuŋ ivot na. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Maaron, ŋgar tooni iyaryaaŋ kat ighe malau mako, pale igham gabua tane ivot. Tauta igham ghom ughita vivuuŋ ru tau pughuzi eemon. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“O kinik, yo irau ughita ŋeer eta tau ŋgar tooni poia ve irao pa gabizooŋ gabua. Leso ughuru imin ŋginiiŋ pa taan to Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ve yo aat ughur le palotiiŋa siriv paam. Leso tiuule pa uraat to ŋginiiŋ taan tiina to Isip. Ndaman liim ve ru to mariri tiina, yes aat tigoog aniiŋ siriv to iŋgin gham pa murei. Yes aat titaghon eez tauvene: Tindou aniiŋ imin ŋgun limliimŋa, mako tighurghur ŋgun eŋaeŋa ilala pa ruum siriv to lupuuŋ aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tauvene ndaman liim ve ru to mariri tintiina, yes palotiiŋa tawe aat tigham naghom, ve tigogoog aniiŋ, tiluplupu ila nugh tintiina to Isip, ve tiŋgin poghania. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Leso aniiŋ tawe igheen ve isaŋan pa ndaman liim ve ru tau pitool tiina pale ivot izi Isip na. Isaav ighe ataghon ŋgar tauvene, ene yes Isipa irau pitool zi ve timatmaat mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kinik tomania zeran ŋgara tau tiŋgin uraat tooni na, tilooŋ Yosep saveeŋ tooni tana, ve tiyok pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ra kinik iburig, ve isaav pazi ighe: “Yau naghita naghe ŋeer tane, Maaron avuvu ileep tomania ve ighamgham pooz pani. Tail ŋeer ite paam, pale irau i tane? Aat mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ra isaav pa Yosep ighe: “Yo, ta Maaron ipaghazoŋai ghom pa gabua tane. Irau nandeeŋ ŋeer ite paam tau ŋgar tooni poia ve irao pa gabizooŋ gabua imin yo ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tauvene yau aat naghur ghom umin ŋginiiŋ pa taan tsiau isov. Tamtamon tsiau tisov aat tilooŋ aliŋam, ve titaghoni. Ve yau kinik mon, ta yo uleep ila sambag. Ŋeer ite paam iŋgin ghom mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ra isaav pa Yosep muul ighe: “Aazne, yau naghur ghom umin ŋginiiŋ pa taan isov to Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ve ipas ring tooni ta tauu moosi igheen ila na, ve ighuru ila Yosep niima ŋguruuŋa. Ve igham Yosep le nonoghiiŋa pisosooŋa tau poia kat na, gha inonogh ghi pani, ve ighur gabua imin namatabub tau tigharaata pa gol na ila Yosep luua. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ra ipul karis tooni ite imin Yosep le, ve Yosep ilanlaan pani, ve yes uraata to kinik timuŋmuuŋ pani, ve tiboboob tighe: “Alooŋ! Tiina tsiam, tauta ilam ne! Yam asov aput aghemim pani!” Kinik igham tauvene leso eval tisov to Isip tiwatagh tighe i ighur Yosep imin ŋginiiŋ pa taan isov to Isip wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ve kinik isaav pa Yosep ighe: “Ulooŋ. Yau kinik to Isip. Aazne ve ila, tamtamon to Isip irau tigham gabua eta sorok muul mako. Yo aat uyok pazi, o tighamu.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Kinik iwaat Yosep eeza paaghu Zapenat-Panea. Ve igham ŋeer ee, eeza Potipera, natliva Asenat ila imin Yosep azaawa. Potipera tawe, i ŋeer to watooŋrau to nugh On. Saawe tau Yosep ndaman tooni irau tamoot ee saŋavul (30), i ipaburigin uraat tau kinik to Isip ighuru ila niima na. Tauvene ipul kinik, ve ilaghlaagh irau nugh nugh to Isip, ve ighitghit zi pa uraat toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","48","Ndaman liim ve ru to mariri tiina, aniiŋ tau ivot izi Isip na, sorok mako. Katini kat. Saawe tana, Yosep igogoog aniiŋ, ve iluplupu ilala ruum naol to lupuuŋ aniiŋ tau tiyooz izi nugh tintiina to Isip na. I ighamgham tauvene: Aniiŋ tau ighe itum igharau nugh tiina eta, ene uraata tooni tighuru iloŋ ila ruum to lupuuŋ aniiŋ to nugh tana. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tauvene Yosep igogoog aniiŋ ve iluplupu le katini kat imin sausau to te, le irau tinini mako. Pasaa, aniiŋ katini kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yosep azaawa Asenat, tau Potipera natliva na, ipoop Yosep le natŋa ru, ra pitool tiina ivot. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosep iwaat naatu aidaaba eeza Manase. Pasaa, igham ŋgar ighe: “Maaron igham ghau lolog iveghai pataŋani tsiau tomania ziiri waaro tsiau wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ve naatu muria, Yosep iwaat eeza Epraim. Pasaa, igham ŋgar ighe: “Yau nalepleep ta sene, ve pataŋani naol ivot payau. Eemon Maaron igham gabua popoia tivot ilam tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","55","Mariri tiina ivot izi Isip irau ndaman liim ve ru le isov, ra ndaman liim ve ru to pitool ivot itaghon Yosep saveeŋ tooni. Pitool tawe, tiina kat. Ivot irau nughmariŋ. Ve yes Isipa mon, ta lezi aniiŋ. Eemon murei ra, pitool tawe ivaghamun zi paam. Tauvene titaŋ rarai kinik pa lezi aniiŋ. Eemon i isaav pazi ighe: “Alam tsiau sov. Malmalimim ala to Yosep. Ve saa saveeŋ tau ighe i isavia payam, na alooŋa ve ataghoni mon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pitool ivot imin tiina kat le irau nugh naol isov to Isip, ra Yosep ikaak ataman pa ruum to lupuuŋ aniiŋ, ve yes Isipa tila tighol lezi aniiŋ. Pasaa, pitool ivaghamunia tamtamon kat irau nugh naol isov to Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pitool ivot izi taan to Isip mon mako. Ivot irau taan naol isov le ivaghamun zi kat. Tauvene nughmariŋ tilala Isip ve tigholghol lezi aniiŋ ila to Yosep. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakop ilepleep izi taan Kanaan, ve ilooŋ tighe aniiŋ ighengheen izi Isip. Tauvene isaav pa natŋa ighe: “Ai, yam avamarari gham ve alepleep pasaa? ");
INSERT INTO tuc_t_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yau nalooŋ tighe aniiŋ igheen izi Isip. Aburig gha azila aghol leen aniiŋ. Leso tamaat sov, ve taleep mataan iyaryaar.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tauvene Yosep tooghŋa saŋavul tigharaat zi pa laghooŋ, ve tiburig gha tizila pa Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Eemon Yakop iŋguruut Yosep taazi Benyamin ileep. Pasaa, aate kania pani ighe yesŋa tila, ene pale gabua eta ivaghamunia izi eez livuugha. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tauvene Yakop natŋa tomania nugh siriv tamtamonazi tilaagh tizila pa Isip pa gholiiŋ lezi aniiŋ. Pasaa, pitool tiina ivot izi taan Kanaan paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Saawe tana, Yosep imin ŋginiiŋ pa taan to Isip. Tauvene nugh nugh tau tilamlam Isip pa gholiiŋ lezi aniiŋ na tilala tooni. Tauta saawe tau Yosep tooghŋa tilam tivot Isip, yes paam tiŋaruini tila, ve tiput aghezi pani, ve tighur naghozi izila pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosep ighita tooghŋa, ve rekia mon ighilaal zi. Eemon ivotia tauu pazi mako. Igham tauu imin i ŋeer to nugh ite ve ikankaan pazi. Tauvene isaav ariaaŋ pazi imin ŋarooŋ zi ighe: “Ai, yam to saa nugh? Alam pasaa?” Yes tiyol aliiŋa tighe: “Yei to taan Kanaan. Nilam to nighol lemai aniiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosep ighilaal tooghŋa. Eemon yes tighilaalo mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","I maata iŋgal vivuuŋ tooni tau muuŋ ighita na, ve isaav pazi ighe: “Yam atoom. Yam zeran to padewaaŋ! Yam alam to apadeu pa taan tsiei. Leso awatagh ziige sindei tau tirao pa malmal mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yes tiyol aliiŋa tighe: “Wai, tiina tsiei, yei nilam pa ŋgar tauvena mako. Yei besooŋa tsio, nilam pa gholiiŋ lemai aniiŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yei tamtamon to padewaaŋ mako. Yei nisov tane, tamamai eemon. Yei zeran to karom mako. Avomai onoon mon.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosep isaav pazi ighe: “Mako. Yam alam to apadeu pa taan tsiei. Leso awatagh ziige sindei tau tirao pa malmal mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yes tiyol aliiŋa tighe: “O tiina tsiei, yei tane, olman ee to Kanaan natŋa. Muuŋ, yei saŋavul ve ru. Eemon tazimai ee, ta ilale. Ve tazimai ite tau muria kat, i ileep tomania tamamai izi Kanaan.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosep isaav pazi muul ighe: “Saveeŋ tauta nasavia payam wa. Yam zeran to padewaaŋ! Tauvene yau nasaav ariaaŋ payam ila kinik to Isip eeza tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Yau aat natoov gham, ve nakis gham aleep ta sene, le irau tazimim muria tau yam asavia na ilam ivot tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tauvene ambaaŋ tamtamon tsiam eta imuul ila igham tazimim tawe ilam. Ve yam siriv, aat asov aloŋ ala ruum to yavyavuuŋ, ve aleep ve asaŋan zi le tilam tivot. Ene eez tau yau naghe natoov gham pani. Leso nawatagh: Saveeŋ tsiam onoon, ma karom? Ighe tazimim ilam ivot sene mako, ene yau nasaav ariaaŋ payam ila kinik eeza tauvene: Yam zeran to padewaaŋ!” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","I isavsaav tomani zi le isov, ra ighur zi tiloŋ tila ruum to yavyavuuŋ, ve tileep irau mboŋ tol. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mboŋ tol tana isov, ra Yosep ila igig zi, ve isaav pazi ighe: “Alooŋ. Yau tane, naroi pa Maaron ve naghe nataghon ŋgar tooni. Tauvene yau aat naghur lemim eez ite. Eez tane, ighe yam ataghoni, ene aat aleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Isaav ighe avomim onoon, ve agham karom payau mako, ene yau aat nakis tamtamon tsiam ee ileep ila ruum to yavyavuuŋ loolo. Ve yam siriv avot ala, aghol lemim aniiŋ, ve aghamu amuul ala pa zeetmimŋa tau tilepleep toman pitool we. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mako agham tazimim tau muria kat na, ve yamŋa amuul alam. Leso nawatagh naghe saveeŋ tsiam onoon, ve irau amaat mako.” Yes tilooŋ saveeŋ tooni, ve tiyok pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ra tiburig ve tivasavo zi tighe: “Onoon kat. Sosor tau muuŋ tagham pa taziin, tauta aazne atuya izaa toit. Pa saawe tau taghur pataŋani pani, i itaŋ rarai ghiit ighe loloon isaghatini. Eemon iit talooŋa mako. Tauta aazne, pataŋani iŋarui ghiit.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tauvene Ruben isaav pazi ighe: “Laak, yau nasaav payam mako? Naghe agham sosor pa taziin sov. Eemon yam alooŋ ghau mako. Tauta aazne, siŋ tooni atuya izaa toit.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Saawe tau tisavsaav, Yosep ineneeŋ, ve iloŋlooŋ zi. Eemon yes tiwataghi mako. Pasaa, i ighamgham imin i iwatagh aliŋazi mako, ve isavsaav pazi ila ŋeer ite tau itortoor saveeŋ ila yes aliŋazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I ilooŋ zi tisavsaav, le loolo isaghat, ve ighe itaŋ. Tauvene itoor ghi, ighur muuri ila pazi, ve itaŋ. Itaŋ le isov, ve itoor ghi naagho ila pazi, ve isavsaav tomani zi muul. Ra isaav pa yes zaaba gha tikau Simeon niima ila matazi, ve tighamu tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosep isaav pa yes besooŋa tooni ighe tinonogh aniiŋ ila tooghŋa nakaral toozi le tivoniir. Ve tipamuul yes eŋaeŋa maet toozi ila tauzi nakaral toozi. Ve tigham lezi aniiŋ imin tamaz pa eez paam. Tauvene yes besooŋa tila tigham uratoi Yosep aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ra Yosep tooghŋa tipadid aniiŋ tomania yauyauŋ toozi izala doŋki toozi pavozi, ve tipaburigin laghooŋ toozi tighe timuul tila pa Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tilaghlaagh tila le mboŋ izi, tauvene tizi gha tigharaat niazi pa ghenooŋ. Toozi ee ikaak nakaral tooni aavo ighe igham doŋki tooni le aniiŋ. Maata izila le ighita maet tooni ighengheen. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tauvene isaav pa yes siriv ighe: “Wai! Alam aghita gabua ee ne. Maet tsiau, tighur mulini ila nakaral tsiau loolo.” Yes tilooŋ aliiŋa, le tisov tirur ve roiŋ tiina igham zi, ve tighe: “Wai, mindai ta Maaron igham pait tauvene?” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yes timuul tila tivot to tamazi Yakop izi Kanaan, ra tipaes pani pa gabua isov tau ivot pazi izi Isip na. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Tighe: “Wai tamamai, daaba tau iŋginŋgin taan to Isip we, i ŋeer poia mako. I isavia saveeŋ ariaaŋa imin ŋarooŋ ghei, ve ighe yei nila to nipadeu pa taan toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Eemon yei nisaav pani nighe: ‘Ee-e, yei tane zeran to padewaaŋ mako. Yei zeran to saveeŋ onoon. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yei nisov tane, tamamai eemon. Muuŋ, yei saŋavul ve ru. Eemon tazimai ee, ta ilale. Ve tazimai ite tau muria kat, ta ileep tomania tamamai izi Kanaan.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","34","“Yei nisaav pa daaba tawe tauvene, ve i iburig ve isaav payei ighe: ‘Yam aat apul tsiam ee izi ileep tomani ghau, ve yam siriv aghol lemim aniiŋ, ve aghamu ala pa zeetmimŋa tau tilepleep toman pitool we. Eemon saawe tau aghe amuul alam, matamim iŋgal tazimim tau muria kat na, ve yamŋa alam. Leso nawatagh naghe yam zeran to padewaaŋ mako, ve avomim onoon mon. Mako napul ŋeer tsiam tau ileep ila ruum to yavyavuuŋ loolo ne ivot, ve imuul ilat payam. Ve nayok payam to alaghlaagh izi nugh tane ve araraukol.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tipaes pa tamazi le isov, ra tigham nakaral toozi tighe tiliŋ aniiŋ izi. Eemon matazi izila nakaral toozi lolozi, le yes eŋaeŋa tighita maet toozi igheen ila nakaral toz toz. Yesŋa tamazi tighita gabua tawe, le roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ve tamazi Yakop isaav pazi ighe: “Yam agham ghau namin maanduat pa natugŋa ru tau tilalez wa. Yosep ilale kat, ve aazne Simeon aana. Ve ene aghe agham Benyamin paam. Aghita. Pataŋani naol ta izazaa tsiau!” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tauvene Ruben isaav pani ighe: “Tamaŋ, ulooŋ. Yo irau unumeer ghau, ve upul Benyamin ila nimag gha yeiru nila. Yau aat naghamu imuul ilam payo. Ighe mako, yo aat urav natugŋa ru timaat timin atuya.” ");
INSERT INTO tuc_t_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakop iyol aliiŋa ighe: “Mako le mako kat! Natug tane irau ilat tomani gham mako. Pasaa, toogha Yosep, ta ilale wa. Ve aazne, i zigani kat. Yau namin kooŋ ve moom izaa payau wa. Ighe i ilat tomani gham, ve pataŋani eta ivot pani izi eez livuugha, ene pale lolog isaghat kat, ve namaat gha nazila nugh to mateegha.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Saawe tana, pitool ivot imin tiina kat izi Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tauvene Yakop tomania tamtamon tooni tighanghan aniiŋ tau natŋa tighamu izi Isip na le isov, ra Yakop isaav pa natŋa ighe tizila muul Isip, ve tighol lezi aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Eemon Yuda isaav pani ighe: “Tamaŋ, ŋeer tawe imogheer saveeŋ mako. I isaav ariaaŋ payei ighe nigham tazimai tane ve yeŋa nila. Ighe mako, ene yei irau nila peria tooni muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tauvene ighe yo uyokia Benyamin payei, ene aat nizila muul ve nighol lem aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ve ighe mako, ene yei irau nila mako. Pasaa, daaba tawe isaav ariaaŋ payei. Ighe nigham tazimai gha yeŋa nila mako, ene irau nila peria tooni muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakop ilooŋ saveeŋ tane, ve iyaon zi ighe: “Puughu mindai ta apaesia tazimim ila to daaba tawe? Ene agham pataŋani tiina kat payau!” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yes tiyol aliiŋa tighe: “Ŋeer tawe ighason rarai ghei pa ziiri waaro tsiei ighe: ‘Tamamim ilepleep, ma imaat wa? Ve tazimim ite paam ilepleep, ma mako?’ Tauta yei niyol ghasoniiŋ tooni. Ve ŋgar tooni tau ighe yei nigham tazimai tane gha yeŋa nizila, ene yei nikankaan pani.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ra Yuda isaav pa taama Israel muul ighe: “Tamaŋ, uyokia ŋeer paaghu tane payau lak! Leso yeŋa nizila pa Isip, ve nighol leen aniiŋ. Mako pale pitool ghiit ve tasov tamatmaat. Yo tomania timbumŋa, ve yei paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yau nambu saveeŋ ariaaŋa tomani ghom tauvene: Yau taug aat matag pani le irau naghuru imuul ilam tsio. Ve isaav ighe naghamu imuul ilam iyooz ila yo naghom mako, ene aat imin leg puughu, ve nabaad saveeŋ tooni le irau saawe tsiau isov ve namaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ughita! Imin ta yo ukis ghei pa savsaveeŋ mako, kanaŋ nizila gha nimuul nizalam imin pai ru wa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tauvene tamazi isaav pazi ighe: “Tambaaŋo. Ighe leen eez ite paam mako, o aghamu gha yamŋa ala. Ve agham gabua popoia siriv to taan tane imin naunauŋ tau vazizi popoia na, tomania ai anooŋa popoia, tok suuru, aŋar, ve gabua siriv paam, ve anonogh zi tila nakaral tsiam, ve aghamu ala. Leso agham pa daaba tawe ve arav aate. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ve agham maet tsiam muŋgaana tau tipamuule izila nakaral tsiam lolozi na, tomania maet siriv paam, ve ala. Maet muŋgaana tawe, aghuru imuul ila pazi. Pa yes aat matazi ikankaan, tauta tighur maet tsiam izila nakaral tsiam lolozi muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ve agham tazimim tane paam gha yamŋa aburig ve ala pa daaba tawe. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na, pale igham ŋeer tawe loolo isaghatin gham, ve iyokia Simeon yesuru tazimim tane payam. Leso yamŋa amuul alam. Ve ighe mako, tambaaŋo. Namin maanduat lak.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","16","Tauvene yes tiburig, ve tigham gabua popoia siriv to tirav daaba to Isip aate, tomania maet muŋgaana ve paaghu siriv paam, ve yesŋa Benyamin tizila pa Isip. Tila tivot to Yosep ve tiyooz ila naagho, ve i ighita Benyamin ilam tomani zi paam. Tauvene isaav pa besooŋa tooni tau iŋgin ruum tooni na ighe: “Ugham zeran tane tila ruum tsiau, ve urav ŋgai eta, ve ugharaat lemai aniiŋ. Leso yeŋa nighan pa zegmatuugh.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tauvene besooŋa tawe itaghon Yosep aliiŋa, ve igham Yosep tooghŋa ve taazi tila pa ruum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tila tivot ruum, le roiŋ tiina igham zi, ve lolozi bubu tighe: “Wai! Maet tau tipamuule izila nakaral toit, tauta aat saveeŋ igham ghiit. Aat puughu tane, ta tigham ghiit talam ruum tooni. Aazne, pale daaba tawe iburig ikis ghiit, ve igham ghiit tamin besooŋa tooni sorok, ve iyau doŋki toit paam timin le.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tauvene tila peria ataman aavo, ve tisaav pa besooŋa tau iŋgin Yosep ruum tooni na tighe: ");
INSERT INTO tuc_t_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","22","“Tiina tsiei, yei lemai saveeŋ rig payo. Muuŋ, yei nilam sene, ve nighol lemai aniiŋ. Eemon saawe tau nimuul nila ve nimariau izi eez livuugha, nikaak nakaral tsiei, ve nighita maet tsiei isov ighenaar ila nakaral tsiei avozi. Yei nikankaan pa sei ta ipamuule. Tauvene nigham maet muŋgaana tawe nilam nighe nighuru imuul ilat. Ve nilam tomania maet tsiei siriv paam to nighol lemai aniiŋ pani.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Eemon besooŋa tawe iyol aliŋazi ighe: “Ai, agham ŋgar naol sov. Atemim izi. Maet tsiam tau muuŋ aghamu alam aghol aniiŋ pani na, ene yau naghamu wa. Maaron tsiam tau yamŋa tamamim abesbees pani na, i tauu aat iŋgooz kuaz tana izila nakaral tsiam lolozi.” Yesŋa tisavsaav le isov, ra besooŋa tana ila igham Simeon ivot, ve ighuru ila toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","25","Ra igham zi tiloŋ tila ruum, ve igham yaa ilam timin aghezi, ve ipan doŋki toozi. Ve ipaes pazi ighe zegmatuugh, o yesŋa tiina tooni tighanghan. Tauvene yes tigharaat gabua popoia siriv tau tighe tigham pa Yosep na, ve tisaŋan. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Zegmatuugh, ra Yosep ilam peria ruum. Tooghŋa ve taazi tigham gabua popoia siriv tau tigham zi tilam na, ve tighur zi ila naagho, ra tiput aghezi pani, ve tighur naghozi izila pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosep ighason zi pa lepoogh toozi, ve ighason zi pa tamazi ighe: “Mindai, tamamim tau muuŋ apaesia payau na, i ileep poi, ma mako? Olman imaat, ma ilepleep?” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yes tiyol aliiŋa tighe: “Tiina tsiei, tamamai tau besooŋa tsio na, gabua eta ighamu mako. I ileep poi.” Ra tighur naghozi izila pa taan muul to tipakuru. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosep maata ila le ighita taazi Benyamin tau yesuru tinazi eemon na. Tauvene ighason zi ighe: “Tazimim tau muuŋ asavia payau na, tauta ena?” Ra isaav pani ighe: “Aa natug, poia to Maaron izaa tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","I isaav tauvene, le loolo isaghat tiina pa taazi, ve rigmon kanaŋ itaŋ ila naghozi. Tauvene rekia mon ipul zi, ve iloŋ ila ruum loolo ite ve itaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Itaŋ le isov, ra imin naagho, ipariaaŋ tauu, ve ivot ila toozi muul, ve isaav pa yes besooŋa gha tigham aniiŋ ilam. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Saawe tau tigham aniiŋ ilam, tighur Yosep le izala boor tooni, ve tooghŋa ve taazi lezi izala boor ite. Ve yes Isipa tau yesŋa tighanghan na, aniiŋ toozi izala boor ite paam. Pasaa, yes Isipa lolozi pa ghanghaniiŋ tomania yes Hibrua mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Saawe tau yes besooŋa tighur Yosep tooghŋa ve taazi pa lepoogh, tighur zi mbolezi izi tipartaghon le raraate imin tau tinazŋa tipoop zi na. Ŋeer aidaaba imuuŋ, ve ila ila le imuul izi ŋeer tau muria kat. Tauvene Yosep tooghŋa ve taazi avozi ikaak, ve tivamarari zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosep ivureer aniiŋ popoia siriv ila tauu boor tooni, ve besooŋa tooni tighamu ila, gha tireii pa tooghŋa ve taazi. Eemon aniiŋ popoia tau tigham pa Benyamin na, ene iliiv kat pa tooghŋa toozi. Tiŋgal aniiŋ pani pai liim. Tauvene Yosep tomania tooghŋa ve taazi tighanghan ve tighunghun toman lolozi poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosep tomania tooghŋa ve taazi tighanghan le isov, ra i isaav pa besooŋa tooni tau iŋgin ruum tooni na ighe: “Unonogh aniiŋ izila nakaral toozi lolozi le tivoniir, ve ughur tamtamon eŋaeŋa maet toozi imuul izila nakaral toozi avozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ve ugham rubruub tsiau tau tigharaata pa silva na, tomania maet to ŋeer muria, ve ughuru izila nakaral tooni aavo.” Tauvene besooŋa tawe ila igham gabua itaghon Yosep aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tigheen le nughizau, ra yes besooŋa to Yosep tighur Yosep tooghŋa ve taazi tomania doŋki toozi gha timuul tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Yes tipul nugh tiina, ve tilaagh tila rig, ra Yosep isaav pa besooŋa tooni tau iŋgin ruum tooni na ighe: “Uburig ve ulaan taghon zi ula. Saawe tau uzaa toozi, usaav pazi ughe: ‘Ai, tiina tsiau itotoi ŋgar poia payam. Puughu mindai ta ayoli pa ŋgar saghati? ");
INSERT INTO tuc_t_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yam aum rubruub tooni tau i ighunghun pani, ve ighitghita gabua tau murei pale ivot. Ŋgar tau aghamu na, ene saghati kat!’” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yosep isavsaav pani le isov, ra besooŋa tawe iburig gha ilaan itaghon Yosep tooghŋa ve taazi ila, le izaa toozi. Ra isavia Yosep aliiŋa pazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yes tilooŋ saveeŋ tooni, ve tiyol aliiŋa tighe: “Wai tiina, yo ughit ghei mindai, ta ugham saveeŋ tauvene payei? Yei besooŋa tsio irau nigham ŋgar eta tauvena mako. Mako le mako kat! ");
INSERT INTO tuc_t_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ughita. Saawe tau nimuul nila nivot taan Kanaan ve nikaak nakaral tsiei, yei nirur pa maet tsiei isov ighenaar izila nakaral tsiei avozi. Eemon maet tawe, nighamu imuul ilat wa. Tauvene pale nium silva ve gol ila ruum to tiina tsio loolo pasaa? ");
INSERT INTO tuc_t_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tiina, ighe yo undeeŋ rubruub tawe igheen to yei tane eta, ene aat tamtamon tana imaat, ve yei siriv nimin besooŋa pa tiina tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Besooŋa tana iyol aliŋazi ighe: “Saveeŋ tsiam poia. Eemon isaav ighe nandeeŋ rubruub tana igheen to tamtamon tsiam eta, ene i zigani ta pale imin besooŋa payau. Ve yam siriv, lemim saveeŋ mako. Irau ala.” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tauvene rekia mon yes eŋaeŋa tisur nakaral toz toz izi taan, ve tikaak avozi. Leso besooŋa tana itiir zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","I itiir to ŋeer olman imin maata, ve itaghoni ila ila le indeeŋ rubruub tana igheen ila ŋeer muria Benyamin nakaral tooni loolo. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tooghŋa tighita gabua tana le atezi imot. Tauta tiraŋgat nonoghiiŋa toozi, ve tiit yauyauŋ toozi izala doŋki toozi pavozi muul, ve timuul tila pa nugh tiina. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosep ilepleep ruum tooni, ve isasaŋan zi. Yuda tomania tooghŋa ve tazŋa tilam peria tooni muul, ve titap tizi ila Yosep naagho, ve tighur naghozi izila pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosep isaav pazi ighe: “Puughu mindai ta agham ŋgar tane? Yam akankaan payau? Tamtamon tau imin yau ne, i irau iwatagh gabua ŋgozaaŋa paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda iyol aliiŋa ighe: “Oo tiina tsiei, yei lemai saveeŋ mako. Pasaa, sosor tsiei ta igheen mataghare wa. Pale nisaav mindai? Pa aazne, Maaron tauu, ta itotoi sosor tsiei ivot ighazooŋ. Tauvene tiina, yei nisov aat nimin besooŋa payo, yeŋa tazimai tau rubruub tsio igheen tooni na.” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Eemon Yosep isaav pazi ighe: “Ee-e, irau nagham tauvene ne mako. Ŋeer tau rubruub tsiau igheen tooni na, i zigani mon ta aat ileep ve imin besooŋa payau. Ve yam siriv, amuul ala pa tamamim. Yau leg saveeŋ payam mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ra Yuda ila igharau Yosep, ve isaav pani ighe: “O tiina tsiau, yau besooŋa tsio. Yo ezam tiina imin kinik tauu. Eemon naghe nasavia saveeŋ tsiau rig payo. Atem raa, yavyav payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Muuŋ, yo ughason ghei ughe: ‘Tamamim ilepleep? Ma lemim tazimim ite paam, ma mako?’ ");
INSERT INTO tuc_t_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","“Ve yei niyol ghasoniiŋ tsio nighe: ‘Vee. Tiina tsiei, tamamai yesuru tazimai muria, ta tilepleep we. Tazimai tawe, tamamai imin olman, ra tiina ipoopa. Ve tinamai tawe, i ipoop natŋa ru mon. Ŋeer olman, i imaat wa. Tauvene ŋeer muria mon ta ilepleep. Tamamai ipulpuli mako. Pasaa, i loolo igheen tooni kat.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tiina, yo ulooŋ saveeŋ tsiei tana, tauta usaav payei ughe nigham tazimai tane ilam, leso ughita pa taum matam. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Ve yei niyol aliŋam nighe: ‘Tazimai tawe pale irau ipul tamamai ne mako. Pa ighe ipuli, ene pale tamamai loolo isaghat pani, ve imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Eemon avom iyaryaaŋ payei ughe yei aat nigham tazimai tane gha yeŋa nimuul nilam. Ighe mako, ene irau nilam peria tsio muul mako.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Saawe tau nimuul nila nivot to tamamai, yei nipaesia aliŋam isov tana pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nilepleep le murei ra, tamamai imbaaŋ ghei muul ighe nilam tsio, ve nighol lemai aniiŋ rigta. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tauvene yei nisaav pani nighe: ‘Tamamai, yei irau nizila sorok mako. Pa ighe yeŋa tazimai nizila mako, ene aat irau nila nivot to daaba tawe mako. Tauvene uyokia tazimai payei, o nizila. Ve ighe uŋguruuta, ene aat nileep.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tauvene tamamai tau besooŋa tsio na, isaav payei ighe: ‘Yam awatagh: Azuwag Rael ipoop leg natugŋa ru mon. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ve ee ipul ghau alok wa. Aat gabua sagsag eta ighani ila wa. Pasaa, saawe tana ve ilam, yau naghita naagho muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aghita. Yau namin kooŋ ve moom izaa payau wa. Isaav ighe yam agham natug tane gha ala, ve pataŋani eta ivot pani izi eeze, ene pale igham lolog isaghat kat ve namaat gha nazila nugh to mateegha.’ “Tamamai aliiŋa, tauta ene. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Tauvene tiina tsiau, ughita. Tamamai, raa, imin kooŋ ve moom izaa pani. Isaav ighe namuul nala tooni, ve i ighita tazimai tane naagho mako, ene aat loolo isaghat kat ve imaat. Pasaa, loolo igheen to naatu tane kat. Ve yei tane pale nimin puughu pa mateegh tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tiina tsiau, yau taug nambu saveeŋ ariaaŋa tomania tamamai naghe yau aat matag pa tazimai tane le irau naghamu imuul ila peria tooni. Ve ighe naghamu imuul ila mako, ene aat imin leg puughu, ve nabaad saveeŋ tooni ila tamamai maata le irau saawe tsiau isov ve namaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tiina, mindai? Irau upul tazig marani tane tomania tooghŋa siriv timuul tila to tamamai? Ve yau aat nagham niia, ve naleep ta sene, ve namin besooŋa payo. ");
INSERT INTO tuc_t_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Pa ighe tazig tane ilam tomani ghau mako, pale namuul nala to tamaŋ mindai? Yau lolog pa naghita pataŋani tauvene izaa tooni mako.” ");
INSERT INTO tuc_t_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yuda isavia saveeŋ tane, le Yosep irau ipariaaŋ tauu pa taŋiiz muul mako. Tauvene isaav aliiŋa tiina pa yes uraata tooni tau yesŋa tiyozyooz na, ighe: “Yam asov avot ala muuri!” Yes tivot tila, ve i tomania tooghŋa ve taazi zigazi tileep, ra ivotia tauu pazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I itaŋ toman aliiŋa tiina. Tauvene tamtamon siriv to Isip tau tileep tigharau zi na, tilooŋa ve tila tipaesia vaaru pa kinik. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosep isaav pa tooghŋa ve taazi ighe: “Yau Yosep! Taug tane! Onoon, tamaŋ ilepleep?” Eemon yes irau tiyol aliiŋa mako. Pasaa, tirur le toozi ilale. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tauvene Yosep isaav pazi muul ighe: “Alam agharau ghau.” Yes tila tigharauu, ve i isaav pazi muul ighe: “Yau Yosep! Yau tazimim tau muuŋ yam agholi ghau nala to yes zeran to raukoliiŋ. Zeran tawe, ta tigham ghau nalam naleep izi Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Eemon lolomim ipataŋan ve avasuku saveeŋ pa taumim sov. Onoon, yam agholi ghau. Tauta tigham ghau nalam naleep ta sene. Eemon yam agham ŋgar tana sorok mako. Maaron tauu, ta imbaaŋ ghau namuuŋ payam nalam. Leso nauul tamtamon katini ve timaat sov, ve nakis zi tileep matazi yaryaare. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Pitool tane igheen irau ndaman ru wa. Ve ndamana liim paam ighengheen naghoon soone. Ndaman liim tana, pale vazoghiiŋ aniiŋ mako, ve taitaiŋ mako paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Maaron imbaaŋ ghau namuuŋ payam nalam to nauul gham, leso amaat sov. Tauta aazne, aleep poi. Ve murei paam, paaghu tsiam pale tileep poi, ve iseeŋga tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tauvene yam ambaaŋ ghau nalam nugh tane mako. Maaron tauu, ta imbaaŋ ghau nalam. Ve i ighur ghau namin daaba pa kinik uraat tooni. Tauta aazne, naŋgin gabua tooni naol isov tomania taan isov to Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Yau naghe yam rekia amuul ala to tamaŋ, ve asavia aliŋag pani aghe: ‘Natum Yosep aliiŋa ilat payo ighe: ‘Maaron ighur ghau namin tiina, ve naŋgin taan dodoli to Isip. Yau naghe yo upul taan Kanaan, ve rekia mon uzilam tsiau. Uzuar sov. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tauvene yamŋa natumŋa ve timbumŋa, asov aburig, ve ayau ŋgai tsiam tomania yauyauŋ tsiam naol isov, ve alam. Leso aleep agharau ghau izi taan sirivu to Gosen. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Pa pitool tiina tane, ndaman liim ighengheen soone. Eemon yau taug pale naŋgin gham pa aniiŋ. Tauvene yamŋa tamtamon tsio irau ambool pa gabua eta mako.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ra Yosep isaav pazi muul ighe: “Yam asov aghit katin ghau wa. Ve tazig Benyamin paam, i ighit ghau. Yau Yosep. Taug ta nasavsaav tomani gham ne. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tauvene yam ala ve asaav pa tamaŋ tauvene: ‘Natum Yosep eeza imin tiina kat izi taan Isip.’ Ve apaes pani pa gabua naol isov tau yam aghita izi nugh tane. Mako aghamu ve rekia mon amuul azilam tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","I isavsaav pazi le isov, ve yesuru taazi Benyamin tivasaghavu zi, ve titaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ra Yosep isaghav tooghŋa tisov, ve yesŋa titaŋ. Titaŋ le isov, ra lolozi poia ve avozi ibees. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Saawe tau kinik to Isip yesŋa uraata tooni tilooŋ tighe toŋvetaz to Yosep tila tivot tooni, ene igham zi lolozi poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tauvene kinik isaav pa Yosep ighe: “Usaav pa tazim ve toghamŋa to tipadid aniiŋ izala doŋki toozi, ve timuul tila pa taan Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mako tigham tamamim, tomania azuwazŋa ve natuzŋa, ve yesŋa timuul tilam tivot tsiau. Yau aat napul taan sirivu to Isip tau poia kat na imin lezi. Leso tileep poi, ve lezi aniiŋ popoia katini. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ve usavia aliŋag pazi tauvene: Yes aat tigham karis siriv to Isip ve tila. Leso tighur tamamim tomania azuwazŋa ve natuzŋa tizaa, ve timuul tilam. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Isaav ighe tipul gabua toozi siriv izi Kanaan, na matazi ila pani sov. Pasaa, yau taug aat nayoli pa gabua popoia siriv to nugh tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakop natŋa tila tigham uraat itaghon kinik aliiŋa le isov, ra Yosep igham lezi karis siriv, ve igham lezi tamaz paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ve irei lezi nonoghiiŋa paghpaaghu le irau zi. Eemon Benyamin, Yosep igham le nonoghiiŋa paghpaaghu liim, ve maet silva irau ndiŋndiŋ tol (300). ");
INSERT INTO tuc_t_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yosep ipadid gabua popoiazi to Isip izala doŋki zitamoot saŋavul pavozi, ve iyambaar zi ila pa taama Yakop. Ve iyambaar doŋki upin saŋavul tomania aniiŋ maata maata paam. Leso saawe tau timuul tilam, mako imin tamaz pa taama. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ra Yosep ighur tooghŋa ve taazi tila. Ve isaav pazi ighe: “Ala ve akokook izi eez livuugha sov.” ");
INSERT INTO tuc_t_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tauvene yes tipul taan to Isip, ve tilaagh tila tivot to tamazi Yakop izi Kanaan. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ra tipaes pani tighe: “Tamamai, ulooŋ! Natum Yosep, i imaat mako. Ilepleep ta Isip we. Ve i imin tiina, ve iŋgin taan isov to Isip.” Yakop ilooŋ saveeŋ toozi, le irur ve ŋgar tooni imbool. Eemon ighur ila mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ve saawe tau tipaesia Yosep aliiŋa pani, ve ighita karis tau Yosep iyambaar zi tila pazi leso tizaa ve tizila pa Isip na, tiini izaa ve loolo poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tauvene isaav ighe: “Onoon kat. Ŋgarig gha naghur ila. Natug Yosep imaat mako. I ilepleep. Yau aat nala ve naghita pataghaaŋ. O ighe namaat, namaat lak!” ");
INSERT INTO tuc_t_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tauvene Yakop iyau gabua tooni naol isov, ve toman natŋa ve timŋa tiburig gha tizila pa Isip. Tilaagh tila le tivot nugh Ber-Seba, ra i igham watooŋrau pa Maaron to taama Isak ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mboŋ tana, itandagh ighe Maaron ilam tooni, ve ipoii ighe: “Yakop, Yakop!” Yakop iyok pa aliiŋa ighe: “Taug ene.” ");
INSERT INTO tuc_t_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","Ra Maaron isaav pani ighe: “Yau Yoova. Yau Maaron to tamam Isak. Uroi pa uzila taan Isip sov. Pa yau aat nalat tomani ghom pa laghooŋ tsio, ve nagham paaghu tsio timasa timin eval kat ta sewe. Ve murei, yau aat nagham gham amuul alam taan tane. Ve saawe to mateegh tsio, natum Yosep tauu pale ileep zigem ve igharaat ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Tauvene Yakop tomania natŋa, timŋa, ve raulivaŋa tizaa karis tau kinik to Isip iyambaar zi pazi na, ve tipaburigin laghooŋ toozi muul. Tipul nugh Ber-Seba, ve tilaagh tomania ŋgai ve saveeŋ mariŋ toozi tau tigham zi izi Kanaan na, ve tizila pa Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakop paaghu tooni tau yesŋa tizila pa Isip na ezazi tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben, i Yakop naatu aidaaba. Ruben natŋa, ene: Anok, Palu, Ezron, ve Karmi. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ve Simeon natŋa, ene: Yemuel, Yamim, Oat, Yakin, Zoar, ve Saul. Saul tiina, i Kanaan tinazi. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi natŋa, ene: Gerson, Koat, ve Merari. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ve Yuda natŋa, ene: Er, Onan, Sela, Peres, ve Zera. Eemon Er yesuru Onan timaat izi Kanaan. Yuda naatu Peres, i ipoop natŋa zitamoot ru, ezazi Ezron gha Amul. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar natŋa, ene: Tola, Pua, Yop, ve Simron. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ve Zebulun natŋa, ene: Seret, Elon, ve Yalel. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yakop yesuru azaawa Lea tilepleep izi taan sirivu to Mesopotamia, ve tipoop natuzŋa zitamoot tane tomania natuzliva Dina. Tauvene Lea natŋa ve timŋa, yes irau tamoot ee saŋavul ve tol (33). ");
INSERT INTO tuc_t_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gat natŋa, ene: Zipion, Agi, Suni, Ezbon, Eri, Arodi, ve Areli. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ve Aser natŋa, ene: Imna, Isva, Isvi, ve Beria. Ve livuzi eeza Sera. Aser naatu Beria natŋa, ene: Eber gha Malkiel. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tamtamon saŋavul liim ve ee (16) tane, ene Lea besooŋa tooni livaa Silpa yesuru Yakop natuzŋa ve timbuzŋa. Silpa tane, Lea taama Laban igham pani imin besooŋa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakop yesuru azaawa Rael natuzŋa, ene: Yosep gha Benyamin. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Saawe tau Yosep ilepleep izi Isip, yesuru azaawa Asenat tipoop natuzŋa ru, ezazi Manase gha Epraim. Yosep azaawa Asenat, i Potipera natliva. Potipera, i ŋeer to watooŋrau to nugh On. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin natŋa, ene: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Upim, ve Art. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tamtamon saŋavul ve paaŋ (14) tane, ene Yakop yesuru azaawa Rael natuzŋa ve timbuzŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ipoop naatu eemon, eeza Usim. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ve Naptali natŋa, ene: Yazil, Guni, Yezer, ve Silem. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tamtamon liim ve ru tane, ene Rael besooŋa tooni livaa Bila yesuru Yakop natuzŋa ve timbuzŋa. Bila tane, Rael taama Laban igham pani imin besooŋa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tauvene Yakop natŋa ve timŋa tau yesŋa tizila pa Isip na, yes irau tamoot tol liim ve ee (66). Ve raulivaŋa, ene tinin zi tomani zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ve isaav ighe talup Yakop tauu, natŋa, ve timŋa, tomania Yosep ve natŋa ru tau yesuru azaawa Asenat tipoop zi izi Isip na, ene timin tamoot tol saŋavul (70). Yes tane ta tilup zi ve tileep izi Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakop tomania natŋa ve timŋa tila tigharau Isip, ra imbaaŋ naatu Yuda imuuŋ ila, ve isavia varuzi pa Yosep ighe taama ilam ivot taan sirivu to Gosen wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Tauvene Yosep isaav pa uraata tooni gha tigharaat karis pani, ra izaa ve ila pa Gosen ighe ighita taama. Ila ivot tooni, ra isaghavu ve itaŋ pani le malau. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ra Yakop isaav pani ighe: “Aa natug, yau naghe pa yo umaat wa. Eemon mako. Aazne, naghit ghom uleep matam yaryaare. Ighe namaat, namaat lak!” ");
INSERT INTO tuc_t_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ra Yosep isaav pa tooghŋa ve taazi, tomania tamtamon toozi siriv tau yesŋa tilam na ighe: “Yau aat namuul nala to kinik, ve napaes pani naghe: ‘Tamaŋ, tazig ve toghagŋa tipul taan Kanaan, ve tilam tivot wa. ");
INSERT INTO tuc_t_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yes zeran to ŋginiiŋ ŋgai. Tauvene tiyauur ŋgai tomania saveeŋ mariŋ toozi, ve tilam.’ ");
INSERT INTO tuc_t_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Yau aat nala tooni ve nasaav pani tauvene. Ve alooŋ. Yes Isipa lolozi pa tilup zi tomania yes zeran to ŋginiiŋ ŋgai mako kat. Tauvene saawe tau kinik ipoi gham ala tooni, ve ighason gham pa uraat tsiam, yam asaav pani tauvene aghe: ‘O tiina tsiei, saawe tau yei kukuamai ve ilam aazne, yei tamtamon to ŋginiiŋ ŋgai imin timbumaiŋa.’ Ighe asaav pani tauvene, i pale iyok payam to aleep izi taan sirivu to Gosen tane.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosep ila to kinik ve ipaes pani ighe: “O kinik, tamaŋ, tazig ve toghagŋa tipul taan Kanaan, ve tilam tivot Isip wa. Yes tilam tomania ŋgai ve saveeŋ mariŋ toozi, ve aazne tileep izi Gosen. Tauta nagham tamtamon toozi siriv tilam, leso ughit zi.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ra igham tooghŋa liim tila tiyooz ila kinik naagho. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kinik ighit zi, ve ighason zi ighe: “Yam aghamgham saa uraat?” Yes tiyol aliiŋa tighe: “Tiina tsiei, yei zeran to ŋginiiŋ ŋgai imin timbumaiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pitool tiina ivot izi taan Kanaan, ve nugh tawe le kikiliiŋ irau ŋgai tsiei tighan ne mako. Tauta nilam nighe nileep nimin loom izi nugh tsio tane. Tiina tsiei, mindai? Irau uyok payei to nileep izi taan sirivu to Gosen, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kinik ilooŋ saveeŋ toozi, ve isaav pa Yosep ighe: “Aazne, taum tamam ve toŋvetaz tsio, tauta tilam tivot leso tileep tomani ghom. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Taan isov to Isip tau igheen ila yo nimam wa. Tauvene taum ughita taan sirivu eta tau poia kat, ve ughur zi tileep pani. Isaav ighe lolozi pa tileep izi taan Gosen, ene poia. Ve isaav ighe tamtamon toozi siriv tirau kat pa uraat to ŋginiiŋ ŋgai, o ughur zi to tiŋgin ŋgai tsiau paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ra Yosep igham taama Yakop ilam, ve ighuru iyooz ila kinik naagho paam, ve Yakop ighur poia to Maaron izaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Le isov, ve kinik ighasoni ighe: “Aa olman tsiau, ndaman tsio irau piiz?” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakop iyol aliiŋa ighe: “Yau naleep namin loom izi taan irau ndaman ndiŋndiŋ ee tamoot ee saŋavul (130) wa. Ndaman tsiau katini imin to tibugŋa mako. Ve lepoogh tsiau poia mako. Pataŋani naol indeeŋ ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakop isavsaav pa kinik le isov, ve ighur poia to Maaron izaa tooni muul, ra ipuli, ve ivot ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosep ila igharaat lepoogh to taama, tooghŋa, ve taazi, tomania azuwazŋa ve natuzŋa itaghon kinik aliiŋa. I igham lezi taan sirivu poia kat tau igheen izi taan sirivu to Ramses. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ve i tauu iŋgin taama tomania toŋvetaz tooni pa lezi aniiŋ, itaghon tamtamon piiz tau tileep ila ruum eŋaeŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Saawe tana, pitool ivot tiina le tiina kat, ve ivaghamunia yes Isipa ve yes Kanaana le tisaghat kat. Pasaa, lezi aniiŋ rigta igheen muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tauvene tilala to Yosep pa gholiiŋ lezi aniiŋ, ve i iyauyau maet toozi, ve ighurghuru ilala to kinik. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tighamgham tauvene, le Yosep iyauur yes Isipa ve yes Kanaana maet toozi le isov kat. Ra yes Isipa tila to Yosep, ve titaŋ raraini tighe: “O tiina tsiei, maet tsiei raa, isov kat. Ugham lemai aniiŋ sorok! Ighe yo uul ghei mako, ene aat nisov nimataar izi naghom.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosep iyol aliŋazi ighe: “Isaav ighe maet tsiam isov kat, o agham ŋgai tsiam tilam, ve aparavol pa lemim aniiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tauvene ndaman eemon tana, yes tighamgham ŋgai toozi maata maata tilala to Yosep, ve i ighamgham lezi aniiŋ, le iyau suvinia hos, doŋki, makau, sipsip, ve mekmek toozi tisov. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ndaman tana ilam ila ve ndaman ite, ra yes Isipa timuul tila to Yosep, ve tisaav pani tighe: “O tiina tsiei, pataŋani tsiei, irau niŋgooza payo mako. Ughita. Pitool tane ighengheen soone. Eemon maet tsiei tomania ŋgai tsiei, tauta yo uyauur zi tisov wa. Ve lemai gabua eta muul to nigham payo ne mako. Yei taumai mon ta nilepleep, tomania taan tsiei. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tiina tsiei, paita nisov nimatmaat izi naghom pa pitool. Tauvene ughol ghei tomania taan tsiei, ve ugham lemai aniiŋ to nighan, ve ugham lemai uuv, leso nitoov vazoghiiŋ zi. Yei nisov aat nimin besooŋa pa kinik, ve taan tsiei paam imin i le. Leso nimaat sov, ve nileep matamai yaryaare. Ighe yo uul ghei mako, ene pale nisov nimataar, ve taan tsiei igheen sorok.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","21","Tauvene Yosep ighol taan isov to yes Isipa gha imin kinik le. Pasaa, pitool ivaghamun zi le tisaghat kat. Tauta tamtamon tisov to Isip tigholia taan toozi isov ila pa kinik, ve timin besooŋa pani. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eemon yes zeran to watooŋrau, yes tigholia taan toozi ila pa Yosep mako. Taan toozi igheen to tauzi. Pasaa, yes tilepleep ila kinik tauu niima. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","24","Yes Isipa tau Yosep ighol taan toozi na, i isaav pazi ighe: “Aazne, yau naghol gham tomania taan tsiam, ve amin besooŋa to kinik wa. Tauvene yau aat nagham lemim aniiŋ uuve to vazoghiiŋ. Murei, isaav ighe aniiŋ anooŋa ivot, yam aat avalaghi imin ŋgun liim, ve aghur ŋgun ee imuul ila pa kinik, ve ŋgun paaŋ imin lemim. Aghan sirivu, ve sirivu igheen pa vazoghiiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yes tilooŋ Yosep saveeŋ tooni, ve tiyok pani tighe: “Tiina tsiei, yo ugham poghani ghei kat. Imin ta yo uul ghei mako, kanaŋ nisov nimataar. Tauvene yei aat nimin besooŋa pa kinik, ve nibees pani toman lolomai poia.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tauta Yosep ighur tutuuŋ ee pa yes Isipa tauvene: Murei, ighe mariri ivot, yes aat tilup aniiŋ, mako tivalaghi imin ŋgun liim, ve tighur ŋgun ee imuul ila pa kinik. Eemon yes zeran to watooŋrau, aniiŋ isov tau itumtum ila taan toozi, ene igheen to tauzi. Pasaa, kinik ighol taan toozi imin le mako. Tutuuŋ tane titataghoni soone. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tauvene yes Israela tizila Isip, ve tila tileep izi taan sirivu to Gosen. Tileep ta sewe, ve tamtamon tomania gabua toozi timasa le timin naol kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakop ileep izi Isip irau ndaman saŋavul liim ve ru, le ndaman tooni irau ndiŋndiŋ ee, tamoot ru, ve liim ve ru (147). ");
INSERT INTO tuc_t_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Ra iyamaan ghi ighe saawe tooni to mateegh ilam igharau wa. Tauvene ipoi naatu Yosep ilam, ve isaav pani ighe: “O natug, saawe tau ighe namaat, yau naghe namuul nala nagheen izi taan tau tamaŋ ve tibugŋa tigheen pani we. Tauvene isaav ighe lolom igheen tsiau, na ughur nimam ila ŋgoig, ve umbu saveeŋ tomani ghau tauvene: Yo irau utavi ghau izi taan tane mako. Yo aat ugham patag ila Kanaan, ve utavi ghau ta sewe. Isaav ighe utaghon aliŋag tane, ene pale itotoi ighe lolom isaghav ghau kat, ve ugham ŋgar poia payau itaghon saveeŋ mbuaaŋ tsio.” Yosep iyol aliiŋa ighe: “Tamaŋ, ugham ŋgar naol sov. Yau aat nataghon aliŋam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakop isaav pani muul ighe: “Saveeŋ tau yo umbua tomani ghau na, yau naghe upariaaŋa ila Maaron maata le iyaryaaŋ kat.” Tauvene Yosep ipariaaŋ saveeŋ mbuaaŋ tooni tawe. Ra Yakop ileep ila niia to ghenooŋ, ve itud ve ipait Maaron toman loolo poia. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tilepleep ila, ve tipaes pa Yosep tighe: “Tamam imorooŋ.” Tauvene Yosep igham natŋa ru, Manase gha Epraim, ve yesŋa tila tighe tighita taama Yakop. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tila peria, ve tamtamon siriv tipaes pa Yakop tighe: “Olman, natum Yosep ilam wa.” Olman Yakop ilooŋ saveeŋ tane, ve ipariaaŋ ghi, iburig mboole izi niia to ghenooŋ, ");
INSERT INTO tuc_t_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","ve isaav pa Yosep ighe: “Ulooŋ. Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na, ivot tsiau izi nugh Lus tau igheen ila taan to Kanaan, ve ighur poia tooni izaa tsiau, ve isaav payau ighe: ‘Yau aat nagham paaghu tsio timasa timin eval kat, ve rumei katini tivot ilat tsio. Ve yau aat nagham taan tane imin lezi. Leso tileep pani taghon taghon gha ila.’” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakop iseeŋ saveeŋ tooni ighe: “Natumŋa ru, Manase gha Epraim, yau nalam taan to Isip soone, ve yamru azuwam apoop zi izi sene. Yau naghe nagham zi timin leg ve tiyooz pa gabua tsiau raraate imin Ruben gha Simeon tau taug natugŋa duduuŋ na. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ve isaav ighe yo upoop muul, ene aat timin yo taum lem, ve tileep ila toghazŋa ru Epraim gha Manase sambazi, ve tigham gabua ila toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Saawe tau napul taan Mesopotamia, ve namuul nalam Kanaan le nagharau nugh Eprata, tinam Rael imaat izi eez livuugha, ve natavia ta sewe.” (Nugh Eprata, eeza ite Betelem.) ");
INSERT INTO tuc_t_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakop isavia saveeŋ tane le isov, ra maata ila le ikus Yosep natŋa ru. Tauvene ighasoni ighe: “Savunugha tana?” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","10","Yosep iyol aliiŋa ighe: “Ene natugŋa ru tau Maaron igham zi payau izi ta sene.” Yakop ighilaal zi mako pasaa, i imin kooŋ kat, ve maata irau ighita nugh muul mako. Ra Yakop isaav pa Yosep muul ighe: “Ugham yesuru tilam tigharau ghau. Leso naghur poia to Maaron izaa toozi.” Tauvene Yosep igham natŋa ru tila tigharau timbuzi Yakop, ve i isaghav zi. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ra isaav pa Yosep ighe: “Muuŋ, naghe irau naghita naghom muul mako. Eemon Maaron igham poghani ghau, tauta aazne naghit ghom, ve naghita natumŋa paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ra Yosep igham natŋa ru tila soghan rig pa taama, ve aana iput aaghe pa taama, ve ighur naagho izila pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Igham tauvene le isov, ra iburig iyooz, niima ŋas ikis naatu aidaaba Manase, ve ighuru ileep ila taama niima tapir, ve niima tapir ikis naatu Epraim, ve ighuru ileep ila taama niima ŋas. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Eemon Yakop iparavolia niima, le niima tapir izala ŋeer muria daaba, ve niima ŋas izala ŋeer olman daaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ra ighur poia to Maaron izaa to Yosep tomania natŋa ighe: “O Maaron, yo Maaron to tibug Abaram yesuru tamaŋ Isak. Lepoogh tomania laghooŋ toozi, yesuru matazi iŋgalŋgal ghom ve titaghon eez tsio. Saawe tau tinaŋ ipoop ghau, ve ilam aazne, yo uŋginŋgin ghau, ve matam payau. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ve uvot tsiau imin aŋela, ve ugham mulin ghau pa pataŋani tsiau ta naol ne. Aazne, suŋuuŋ tsiau iŋarui ghom naghe ughur poia tsio izaa to geegeu ru tane. Leso paaghu toozi timasa timin naol izi taan, ve yeiru tamaŋ Isak ve tibug Abaram ezamai iseeŋga taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosep ighita taama ighur niima tapir izala naatu muria Epraim daaba, le irau loolo mako. Tauvene iit taama niima tapir pa naatu muria, ve ighe ighuru ila naatu olman Manase daaba. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ve isaav pa taama ighe: “Tamaŋ, ugham vena sov. Nimam tapir ila ŋeer olman daaba, o poia.” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Eemon Yakop ilooŋ Yosep aliiŋa mako. Isaav pani ighe: “Natug, ŋgar tau yau naghamu ne, nakankaan pani mako. Yau nawataghi. Natum Manase, paaghu tooni pale timasa timin naol, ve eeza imin tiina paam. Eemon taazi eeza pale iliivo. Pasaa, paaghu tooni pale timasa timin eval tiina kat, ve rumei katini aat tivot ila tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tauvene saawe tana, Yakop ighur poia to Maaron izaa to Yosep natŋa ru, ve isaav pazi ighe: “Murei, isaav ighe yes Israela tighur poia to Maaron izaa to tamtamon, ene pale tiwaat ezamim tighe: ‘Maaron pale ighur poia tooni izaa tsiam imin igham pa Epraim gha Manase.’” Tauvene i iit Epraim eeza izaa le iliiv toogha Manase. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yakop ighur poia to Maaron izaa to yesuru le isov, ra isaav pa Yosep muul ighe: “Ulooŋ. Saawe tsiau to mateegh ilam igharau wa. Eemon Maaron pale ileep tomani gham. Ve murei, i pale igham gham amuul ala pa taan to timbumimŋa ve tamamimŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ve ulooŋ. Muuŋ, yau nagham paneegh tomania mbuzaagh tsiau, ve yeŋa yes Amora niparav le naliiv zi. Tauta nagham nugh mbua Sekem imin leg. Yau naghe nait ezam iliiv toghamŋa ezazi. Tauvene aazne, yau aat napul taan tawe imin yo lem. Ve taan sirivu, ene pale napuli ila pa toghamŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakop isavsaav tomania Yosep le isov, ra ipoi natŋa siriv tilam, ve isaav pazi ighe: “Alam agharau ghau. Leso navotia gabua tau murei pale ivot payam. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yam Yakop natŋa, tamamim Israel ta yau. Alam alup gham izi naghog, ve alooŋ saveeŋ tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, yo natug aidaaba. Saawe tau paghug ve tapirig ighengheen, yau napoop ghom imin maata. Tauta tapirig izaa tsio, ve ezam ve tapirim iliiv tazimŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Eemon yo irau uŋgin taum mako. Yo umin yaa tau ivot toman tapiri tiina. Yo uroron pa tamam mako, ve upamayaŋin ghau. Pasaa, uzala niag to ghenooŋ, ve umogheer pa azuwag. Tauvene ezam irau imuuŋ pa tazimŋa muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon yesuru taazi Levi, ŋgar toozi raraate. Yesuru zeran to ravuuŋ tamtamon sorok pa mbuzaagh toozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tauvene lolog pa ŋgar toozi mako, ve lolog pa lupuuŋ tomani zi mako. Pasaa, yesuru atezi tuuku, ve tiravrav sorokin tamtamon timatmaat. Ve ŋgai paam, tivaghamun zi sorok. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maaron tauu pale ighur pataŋani iŋarui zi. Pasaa, aatyavyav toozi, ene tiina kat. Irau lolozi isaghatin tamtamon rigta mako. Tauvene yau aat nareu zi tomania paaghu toozi le timbiriis tila tileep ila toŋvetaz toozi sosozi. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, toghamŋa ve tazimŋa pale tipait ezam. Pasaa, yo aat ukis koiamŋa luazi. Tauvene toghamŋa ve tazimŋa pale tiput aghezi payo, ve tipakur ghom. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, yo umin laion paaghu tau tapiri tiina ve tamtamon tiroiroi pani. Yo umin laion tau ighan ŋgai sagsag siriv le isov, ve izi igheen. Sei irau iroi mako ve imogheer pani? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda tomania paaghu tooni pale tikis titi to kinik, ve tighamgham pooz ila le irau titi tawe tamtamona duduuŋ ilam ivot. Mako i tauu ikisi, ve nugh nugh tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","12","Yuda paaghu tooni pale tileep poia izi taan toozi, ve tirau kat pa lezi aniiŋ ve vaen, ve titum toman naghozi popoia. Irau timbool pa gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun paaghu tooni pale tileep tigharau te, ve lezi aavo poia to waaŋ tilooŋ tila. Taan toozi pale ila imuul izi nugh Sidon. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isakar paaghu tooni pale timin doŋki tau bide tapiri. Eemon i igheen sorok ila bodbodaaŋ to nakaral tau aniiŋ igheen ila. Pale tighita tighe taan toozi, ene poia to tileep pani ve tigham uraat. Tauvene yes pale tigham uraat tiina. Ve tamtamon toozi siriv pale timin besooŋa sorok, ve tigham uraat pataŋani. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","17","Dan paaghu tooni pale timin rumei marani ee to yes Israela, ve tigham uraat pa gharatooŋ pataŋani to tamtamon. Yes eval mako. Eemon pale tivaghamunia koiazŋa imin moot saghati tau ileep eez ziige ve isasaŋan. Ighe tamtamon eta ilaan tomania hos tooni ilam, ene rekia mon iŋaaŋ hos aaghe, ve ŋeer tau ileep izala paavo na, itap izi taan. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Yoova, yau nasaŋan ghom to ugham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gat paaghu tooni koiazŋa pale tilam tighe tireu zi. Eemon yes pale tiparav ariaaŋ, ve tinaan zi tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Taan to Aser pale ŋgoreeŋa tiina, ve aniiŋ popoia maata maata tau kinik lolozi pani na, titum ila. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali, paaghu tsio pale timin mekmek sagsag tau tilaghlaagh sorok titaghon tauzi lolozi, ve tipopoop natuzŋa tau paghunazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosep paaghu tooni pale timin ai vaen tau iyooz igharau yaa, ve booga titum tila soghan le tiliiv sirsiir, ve ighur anooŋa popoia katini. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yosep koiŋa tipaburigin malmal pani, ve tinaano tighe tivaneghi gha imaat. Eemon tirao mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pasaa, Maaron saksaki to Yakop, i ŋginiiŋ to yes Israela, ve imin niazi ariaaŋa to yoŋgaaŋ. Tauta Yosep niima tuŋia pa paneegh tooni, ve ivanegh rekrekia. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yosep, Maaron to tamam aat iuul ghom. Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na, pale ighur poia tooni izaa tsio tomania paaghu tsio, ve igham uman to sambam izi payam, ve igham yaa to taan loolo izaa payam paam. Ve ighur poia tooni izaa to zilivaa tsiam, leso tipoop natmimŋa katini. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yo tamam yau. Poia tau Maaron ighuru izaa tsiau, ene tiina kat. Itav loloz tintiina tau tiyozyooz irau saawe. Iliiv poia tooni tau muuŋ izaa to tibugŋa. Poia tauvene pale izaa to Yosep tomania paaghu tooni, ve ipabood zi imin moghar ndamoonda izala dabazi. Pasaa, i imin daaba pa tooghŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin, i imin ŋgavuun sagsag tau pitoola ve ilaghlaagh. Mboŋoozo ta naol ne, i ighanghan gabua tau i iravrav zi na. Ve ravrav isov, ivavalagh gabua tau i igham zi na, ve ireireii pa zeetŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ene yes Israela rumei toozi saŋavul ve ru. Saawe tau tamazi Yakop ighe imaat, i ighur poia to Maaron izaa toozi. Ve saveeŋ tau i isavia pa natŋa, ene: iduduuŋ pa yes eŋaeŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Yakop ighur poia to Maaron izaa to natŋa le isov, ra aavo iyaryaaŋ pazi ighe: “Yau naghe napul gham tane, ve nala naleep tomania ziiri waaro tsiau tau timaat wa. Saawe tau ighe namaat, yam agham ghau nala, ve aghur ghau naloŋ nala maet puura tau igheen izi taan Makpela. Leso nagheen tomania tamaŋ ve tibug. Maet puura tawe, muuŋ tibug Abaram igholi ila to Epron, i ŋeer to yes Hita. Igheen igharau nugh Mamre ta Kanaan we. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Pasaa, maet puura tawe, ta tighur Abaram yesuru azaawa Sara, ve Isak yesuru azaawa Rebeka tiloŋ tila. Ve yau naghur azuwag Lea aana iloŋ ila paam. ");
INSERT INTO tuc_t_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tauvene maet puura tau Abaram igholi ila to yes Hita na, yau naghe aghur ghau naloŋ nala nagheen ta sewe paam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Olman Yakop ighur saveeŋ izi to natŋa le isov, ra iyoot aaghe izala niia to ghenooŋ, iyavaghan, ve imaat. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosep ighita taama Yakop imaat, ve itap izala paavo, isaghavu, ve itaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Itaŋ le isov, ra isaav pa yes besooŋa tooni tau tighamgham uratoi yes mateegha patazi na, gha tigharaat taama paata. Leso isaghat rekia sov, ve igheen malau. Tauvene yes tila ve tigham uratoi Yakop paata itaghon gabuazi, le irau mboŋ tamoot ru (40). Pasaa, uraat tawe ikis zi saawe malau tauvene. Yes Isipa paam titaŋ pa olman Yakop, ve tileep ila moŋiiŋ le irau mboŋ tamoot tol saŋavul (70). ");
INSERT INTO tuc_t_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tilepleep le saawe to moŋiiŋ isov, ra Yosep isaav pa yes uraata tau tiŋgin kinik ruum tooni na ighe: “Isaav ighe lolomim payau, na agham naghog, ve ala asavia aliŋag pa kinik tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Saawe tau tamaŋ ileep maata yaryaare, i isaav payau gha nambu saveeŋ ariaaŋa pani ila Maaron maata tauvene: Saawe tau i imaat, yau aat nagham paata ila taan Kanaan, ve naghuru iloŋ ila maet puura tau i tauu igharaata ta sewe. Tauvene naghe naghason kinik. Irau iyok payau, ve nala natavia tamaŋ paata ta sewe? Natavia le isov, o namuul nalam.” ");
INSERT INTO tuc_t_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kinik ilooŋ ghasoniiŋ tooni, ve iyok pani ighe: “Poia. Ula utavia tamam izi taan Kanaan itaghon saveeŋ mbuaaŋ tsio tau ugham pani na.” ");
INSERT INTO tuc_t_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Tauvene Yosep tomania tooghŋa, taazi, ve tamtamon toozi siriv tiburig, ve tigham tamazi Yakop paata tighe tila titavia izi taan Kanaan. Yes uraata to kinik tau tiŋginŋgin ruum tooni na, tomania yes daaba to Isip tisov tiburig tomani zi, ve yesŋa tila. Siriv tizaa hos, siriv tizaa karis, ve siriv tilaagh taan. Tauvene yes tau tilaagh tomania Yosep na, yes eval kat. Eemon Yosep tomania tooghŋa ve taazi tipul azuazŋa tomania natuzŋa ve ŋgai toozi tizi tileep izi taan Gosen. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tilaagh tila le tivot nugh to losiiŋ wit tau igheen igharau nugh Atat izi yaa Yordan paaŋa ite. Ra tipaburigin taŋiiz muul pa Yakop, ve titaŋtaŋ tauvene le irau mboŋ liim ve ru. Titaŋ tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tauvene yes Kanaana tau tileep nugh tawe tilooŋ taŋiiz toozi, ve tighe: “Wai, ewe yes Isipa lolozi isaghat tiina kat, tauta titaŋtaŋ we.” Puughu tane ta tiwaat nugh tawe eeza ‘Abel Mizraim.’ Nugh tawe igheen ila yaa Yordan paaŋa ite. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Tauvene Yakop natŋa titaghon aliiŋa, ve tigham tamazi paata ila taan Kanaan, ve tighuru iloŋ ila maet puura tau igheen izi taan Makpela na. Taan tau maet puura tawe igheen ila na, muuŋ Abaram igholi ila to Epron, i ŋeer to yes Hita. Leso titavia mateegha toozi ta sewe. Maet puura tawe igheen igharau nugh Mamre. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tighur Yakop paata iloŋ ila maet puura tawe le isov, ra Yosep tomania tooghŋa, taazi, ve yes eval tau tilaagh tomani zi na, timuul tizila pa Isip. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yakop imaat, ra roiŋ igham Yosep tooghŋa ve tighe: “Aiss, tamaan imaat wa. Isaav ighe Yosep maata iŋgal ŋgar saghati tau muuŋ tagham pani na ve ighe iyatu, saa pale ivot pait? Pale tagham mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tauvene aliŋazi ila pa Yosep tighe: “Tamaan imaat soone, ve ighur saveeŋ izi tsiei tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yam ala ve asavia aliŋag pa natug Yosep tauvene: Yo irau lolom isaghatin toghamŋa, ve upul sosor toozi, ve lolom iveghai ŋgar saghati tau tigham payo na.’ Tamaan isaav tauvene, tauta yei besooŋa to Maaron tau tamaan ibesbees pani na, nitaŋ rarai ghom nighe: Lolom isaghatin ghei, ve upul sosor tsiei.” Yosep ilooŋ saveeŋ toozi, ve itaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ra tooghŋa tauzi tila tivot tooni, ve titap tizi ila naagho, ve tisaav pani tighe: “Ulooŋ. Yei tane pale nisov nimin besooŋa payo.” ");
INSERT INTO tuc_t_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Eemon Yosep isaav pazi ighe: “Yam aroi sov. Yau namin Maaron, leso naghur atuya payam? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Muuŋ, yam aghe avaghamun ghau. Eemon ŋgar tsiam saghati tana, Maaron itoora imin gabua poia. Ene eez tau i iuul tamtamon katini. Tauta timaat mako, ve aazne tileep matazi yaryaare. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tauvene yam aroi sov. Yau taug aat naŋgin gham, tomania azuwamimŋa ve natmimŋa, ve nauul gham pa lemim aniiŋ ma saa gabua tau ambool pani.” Yosep isavia saveeŋ luuma tane pa tooghŋa, tauta irav atezi, ve lolozi poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosep tomania tooghŋa ve taazi tilepleep izi Isip, le Yosep ndaman tooni irau ndiŋndiŋ ee ve saŋavul (110). ");
INSERT INTO tuc_t_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","I ighita timŋa ve gaabŋa to Epraim, ve ighita Manase naatu Makir natŋa paam, ve irarar pazi imin i tauu tooni. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosep iyamaan ghi ighe saawe tooni to mateegh igharau, ve isaav pa tooghŋa ve taazi ighe: “Saawe tsiau to mateegh igharau wa. Eemon Maaron tauu aat maata payam, ve iŋgin gham aleep poi. Ve murei, i pale igham gham apul nugh tane, ve amuul ala aleep izi taan Kanaan itaghon saveeŋ ariaaŋa tau i imbua tomania Abaram, Isak, ve Yakop.” ");
INSERT INTO tuc_t_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ra aavo iyaryaaŋ pazi ighe: “Maaron aat maata payam ve iuul gham, leso apul nugh tane, ve amuul ala pa taan Kanaan. Saawe tana ighe ivot, mako agham tuag ve alaagh tomania.” Yes tilooŋ saveeŋ tooni tane, ve timbu saveeŋ pani tighe yes aat titaghon aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tauvene Yosep ndaman tooni irau ndiŋndiŋ ee ve saŋavul (110), ra imaat. Yes Isipa tigharaat paata leso imbuuz sov, ve tizeeva ila ndawawa loolo ta Isip we. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Yes Israela tau yesŋa tamazi Yakop, ve azuwazŋa ma natuzŋa tizila pa Isip na ezazi tauvene: Ruben, Simeon, Levi, Yuda, Isakar, Zebulun, Benyamin, Dan, Naptali, Gat ve Aser. Yakop eeza ite ta Israel. Paaghu tooni tau yesŋa tizila Isip na, yes irau tamoot tol saŋavul (70). Ve naatu Yosep, i imuuŋ ila ileep pataghaaŋ wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosep imaat ve taazi tomania tooghŋa ve tamtamon toozi siriv tau yesŋa tizila Isip pa saawe tana na, tileep ta sewe le tisov timataar paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Eemon yes Israela tipopoop, ve paaghu toozi timasa le timin eval kat ve tipavon taan isov to yes Isipa. Tauvene tapirizi ighe iliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yes Israela tileep ta sewe irau ndaman ndaman, ra kinik paaghu ee ivot ve igham pooz izi Isip. Kinik paaghu tawe, i iwatagh Yosep uraat tooni rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Tauvene isaav pa yes Isipa ighe: “O, aghit ghiit wa? Aazne, yes Israela timasa timin naol, ve paita tapirizi iliiv ghiit tane. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tauvene iit aat tagham ŋgar poi, ve tail eez eta to tatatan tapirizi. Mako pale tivot timin eval kat ve tiliiv ghiit. Ve isaav ighe malmal eta iburig, ene pale tila tipaak koiaanŋa, ve tiparav tomani ghiit ve tiliiv ghiit, mako tipul taan toit ve tighau tila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tauvene yes Isipa tigham yes Israela timin saghati pazi, ve tighur ŋginiiŋa ariaŋazi to tiŋgin zi. Yes ŋginiiŋa tawe tighur uraat pataŋani kat pazi, leso titatan zi. Tigham zi tipaburigin nugh paghpaaghu ru, leso tilup aniiŋ tomania gabua siriv to kinik ta sewe. Nugh ee, eeza Pitom, ve ite eeza Ramses. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yes Isipa tigham saghatin yes Israela ve tighur uraat pataŋani naol pazi. Leso titatan zi ve tapirizi isov. Eemon tirao mako. Yes Israela tivotvot timin naol, ve tila tileep irau taan isov to yes Isipa. Tauvene yes Isipa tiroi pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tauta tiŋgal matazi pa uraat siriv paam tau pataŋani le pataŋani kat. Lolozi isaghatin zi rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tigham le yes Israela lepoghazi isaghat kat. Pasaa, tighurghur uraat pataŋani kat pazi. Tigham zi tigharaat brik ve tirau ruum, ve tigham uraat ariaaŋa pa uum paam. Ve saawe isov tau yes Israela tighamgham uraat, yes Isipa lolozi isaghatin zi rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","16","Ra kinik to Isip ipoi Hibru tinazi ru tilam. Ee eeza Sipra, ve ite eeza Pua. Yesuru lezi uraat to tipapoop zilivaa to yes Hibrua. Kinik isaav pazi ighe: “Alooŋ. Saawe tau apapoop yes Hibru tinazi, na aghita natuzŋa. Isaav ighe zitamoot, na arav zi timaat. Ve ighe zilivaa, o apul zi tileep.” ");
INSERT INTO tuc_t_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Eemon zilivaa ru tawe tiroi pa Maaron. Tauvene titaghon kinik aliiŋa mako, ve tipuliir geegeu zitamoot tileep. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tauvene kinik ipoi yesuru timuul tilam, ve ighason zi ighe: “Puughu mindai ta yamru azoor aliŋag, ve apulpul geegeu zitamoot to yes Hibrua tileep?” ");
INSERT INTO tuc_t_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Yesuru tiyol aliiŋa tighe: “Wai, yes Hibru tinazi, popaaŋ toozi imin yes Isip tinazi mako. Pasaa, yes zilivaa ariaŋazi, ve tipopoop rekia mon. Saawe tau yeiru nilaghlaagh soone, yes tipoop wa!” ");
INSERT INTO tuc_t_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Zilivaa ru tana tiroi pa Maaron ve titaghon ŋgar tooni. Tauvene i igham poghani zi le anazi tipoop lezi natuzŋa paam. Ve yes Israela tivotvot le timin eval le eval kat. Ve tapirizi paam ivot imin tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tauvene kinik isaav ariaaŋ pa eval tiina to Isip ighe: “Geegeu zitamoot tau Hibru tinazi tipoop zi na, asik zi tisov tizila yaa Nil. Ve ighe zilivaa, mako apul zi tileep.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Saawe tana, tamoot ee ve livaa ee to Israel, yesuru tivai. Puughu toozi eemon, yes tivot ila to Levi. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Livaa aapo, ve ipoop tamoot. I ighita naatu poia kat. Tauvene iŋgooza ileep irau kaiyo tol le imin olman rig. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ra irau iŋgooza muul mako. Tauvene igham ti tau tivavaii pa gabua imin pizpiiz, ve iŋgal gabua imin zimir ma bagil ila ipoon ti tawe puura puura, leso yaa iloŋ ila sov. Ra ipagheen naatu iloŋ ila, ve ighamu ila ighuru ila pizpiiz loolo tau itum itaghon yaa Nil ziige na. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ŋeer marani liivu iyooŋ soghan, ve maata ilala pani ighe ighita: Saa gabua pale ivot pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Saawe duduuŋ tana, kinik to Isip natliva tomania besooŋa tooni zilivaa siriv, tizila pa yaa Nil, leso kinik natliva iririu. Tauvene besooŋa tooni zilivaa tilaghlaagh taghon yaa ziige, ve i iriririu. I maata ila le ighita ti tawe ipotpot ila pizpiiz loolo. Tauvene imbaaŋ besooŋa tooni livaa ee ila ighamu ilam. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kinik natliva ikaak ti aavo, ve ighita ŋeer marani ighengheen ila loolo ve itaŋtaŋ. Tauvene loolo isaghatini, ve isaav ighe: “Alei, ene aat Hibru tinazi eta naatu!” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Rekia mon ve ŋeer marani liivu ilam peria toozi, ve ighason kinik natliva ighe: “Mindai? Irau nala nail livaa eta to yes Hibrua, ve naghamu ilam? Leso iŋgin marani tana payo, ve igham payamyam pani.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kinik natliva iyok pa ŋgar tooni ighe: “Poia kat. Ula.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Tauvene i ila igham tiina duduuŋ, ve yesuru timuul tila to kinik natliva. Ra kinik natliva isaav pa ŋeer marani tiina ighe: “Ugham marani tane ula, ve uŋgini payau ve ugham payamyam pani. Pale nagharaat ghom.” Tauvene ŋeer marani tauu tiina ighamu ila, ve igham payamyam pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ŋeer marani itum le imin olman rig, ra tiina ighuru imuul ila to kinik natliva, gha ighamu imin naatu. Kinik natliva iwaat marani tana eeza Mose. Pasaa, maata iŋgal ighe: “Marani tane, i ileep yaa ziige ve naghamu izaa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose itum le imin olman. Saawe ee, i ila ighe ighita zeetŋa Hibrua. Ila ivot toozi ve ighita uraat pataŋani tau tighamghamu na. Ve ighita ŋeer ee to Isip irav toŋvetaz tooni ee to Hibru. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose maata ines, le ighita tamtamon eta mako. Tauvene ila ivool to iitete, ve irav Isip tamazi tawe imaat. Ra ilal paata pa sausau, leso iŋgooza. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mboŋ le nughizau, ra i ila ighe igig zeetŋa tawe muul. Ilaghlaagh ila le ighita Hibrua ru tipaparav. Tauvene ighason ŋeer tau igham sosor ve ipaburigin malmal na ighe: “Wai, urav sorokin etam ite pasaa?” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","I iyol aliiŋa ighe: “Yo sei ighur ghom umin tiina to uŋgin ghei ve ugharaat pataŋani tsiei? Ma mindai? Yo ughe urav ghau namaat imin Isip tamazi tau noor uravu imaat na?” Mose ilooŋ saveeŋ tane ve maata iŋgal ighe: “Wai, ŋgar tau yau naghamu na, tamtamon aat tiwataghi wa.” Tauvene iroi ve ighau. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Saawe tau kinik to Isip ilooŋ Mose vaaru pa ŋgar tau ighamu na, iilo ighe iravu imaat. Eemon Mose ighau ila pa yes Midiana taan toozi wa. Ila ivot ta sewe, ve izi imariau igharau yaa taiŋ ee ziige. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nugh tawe, ŋeer ee ilepleep, eeza Reguel. Reguel eeza ite Yetro. I ighamgham uratoi watooŋrau to yes Midiana, ve natlivaŋa irau liim ve ru. Saawe tau Mose ileep igharau yaa tawe ziige, Reguel natlivaŋa tilam tighe titiv yaa ve tipaghun sipsip ve mekmek toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Malau mako ve ŋginiiŋ ŋgaia siriv tilam tivot, ve tighe tiziir zilivaa tawe tighau. Eemon Mose iburig ivool toozi, ve ipaghun sipsip tomania mekmek toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ra zilivaa tana timuul tila pa tamazi Reguel. I ighit zi, ve ighason zi ighe: “Wai, mindai ta ŋgarig gha ala ve rekia mon amuul alam?” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Yes tiyol aliiŋa tighe: “Yei nila nivot yaa, ve ŋginiiŋ ŋgaia siriv tilam tighe tiziir ghei. Eemon ŋeer ee to Isip ivool tsiei, ve iuul ghei pa tivuuŋ yaa, ve ipaghun sipsip ve mekmek toit paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tamazi ilooŋ saveeŋ toozi, ve ighason zi ighe: “Wai, tauu sindei? Puughu mindai ta apuli ileep? Aghamu gha yamŋa alam mako? Rekia mon amuul ala, ve aghamu ilam. Leso itiŋa taghan.” Tauvene tila tigham Mose gha yesŋa timuul tilam. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Reguel ighe Mose ileep tomani zi. Tauvene Mose iyok pa ŋgar tooni, ve Reguel igham natliva ee pa Mose gha ivaii. Eeza Sipora. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Yesuru tileep le Sipora aapo, ve ipoop naatu tamoot, ve Mose iwaat eeza Gersom. Pasaa, maata iŋgal ighe: “Muuŋ, naleep namin loom ta sewe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ndaman katini ilam ila, ra kinik to yes Isipa imaat. Eemon yes Isipa tighamgham saghatin yes Israela, ve tighurghur uraat pataŋani pazi soone. Tigham le matazi siŋ izaa. Tauvene yes Israela titaŋtaŋ ve tipasawal pa lezi uleeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Maaron ilooŋ taŋiiz toozi, ve maata iŋgal imuul ila pa saveeŋ tau muuŋ i imbua tomania timbuzŋa Abaram, Isak ve Yakop na. ");
INSERT INTO tuc_t_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","I ighita yes Israela tileep ila pataŋani tiina loolo. Tauvene igham ŋgar tiina pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose iŋginŋgin sipsip ve mekmek to raawa Yetro. Yetro, i ŋeer tau ighamgham uratoi watooŋrau to yes Midiana. Saawe ee, Mose igham sipsip ve mekmek to Yetro, ve ila pa nugh ŋginaaŋa. Ipul nugh tau monmon ilaghlaagh pani na, ve isakia laghooŋ ila ivot loloz Orep puughu. Loloz tawe, ene loloz patabuyaaŋ to Maaron. Eeza ite Sinai. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mose ilepleep ta sewe, ve Mbaŋooŋa to Yoova ivot tooni imin yav ighan izala ai marani ee. Mose ighita yav tawe iyaryaar kat, eemon ighan ai mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tauvene igham ŋgar naol ighe: “Wai, ewe saa kaut? Gabua tawe, ghitooŋa ite kat. Puughu mindai ta yav iyaryaar izala ai tawe, eemon ighani mako? Yau aat nala nagharauu, ve naghit poghania.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tauvene Mose ilaagh ŋarui ai tawe ila ighe ighit poghania. Eemon Yoova ileep ila ai tawe ve ighita Mose ilam, ra ipoii ighe: “Mose, Mose!” Mose iyok pa aliiŋa ighe: “Taug ene.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yoova isaav ila pani ighe: “Ulam ugharau sov! Uyooz ta sena, ve upas zuzuuŋa to aghem izi. Pa taan tau yo uyozyooz izala ne, ene patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yau Maaron to tamam. Ve yau Maaron to Abaram, Isak, ve Yakop.” Mose ilooŋ saveeŋ tane, ve rekia mon ipoon naagho. Pasaa, iroi pa ghitooŋ Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yoova isaav pani muul ighe: “Tamtamon tsiau tau tileep izi Isip we, yau naghita pataŋani toozi wa. Yes daaba tau tiŋgin zi pa uraat na, tighamgham saghatin zi, le matazi siŋ izaa, ve titaŋ tiina. Eemon taŋiiz toozi, yau nalooŋa wa. Tauvene pataŋani toozi, yau nakankaan pani mako. Nawataghi le isov. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","“Tauta aazne, nazilam to nagham mulin zi ila yes Isipa nimazi. Yau aat nagham zi tipul Isip, ve tila tileep izi taan to yes Kanaana, Hita, Amora, Peresa, Hivia, ve Yebusa. Pasaa, taan tawe, sooso tiina ve ŋgoreeŋa tiina kat. Ve igham gabua isov titum poia. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Tauvene taŋiiz to Israela ilam ivot tsiau gha nalooŋa wa. Ve pataŋani tau yes Isipa tighurghuru pazi to titatan zi na, yau naghita wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tauvene aazne, yau naghe nambaaŋ ghom umuul ula pa Isip ve ughita kinik toozi, leso ugham tamtamon tsiau Israela tipul taan Isip ve tilam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Eemon Mose isaav pa Maaron ighe: “Wai! Yau saa ŋeer, ta irau nala nayooz ila kinik naagho, ve nagham yes Israela tipul Isip? Yau naghita naghe irau nagham uraat tauvene mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Maaron isaav pani muul ighe: “Yau taug pale naleep tomani ghom ve napalot ghom. Tauvene yo aat ugham tamtamon tsiau Israel tipul Isip, ve yamŋa alam avot ta sene, ve asuŋ ve abees payau izi loloz tane puughu. Saawe tau gabua tana ighe ivot, mako uwatagh ughe yau taug ta nambaaŋ ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose iyol Maaron aliiŋa ighe: “Ene poia. Ve isaav ighe namuul nala, ve nasaav pa yes Israela naghe: ‘Maaron to timbuunŋa, ta imbaaŋ ghau nalam payam,’ yes aat tighason ghau tighe: ‘Saa Maaron tana. Eeza sei?’ Pale nayol ghasoniiŋ toozi mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Maaron isaav pani ighe: “YAU TAUG NALEPLEEP. Ene yau ezag ve gabuag. Tauvene usaav pa yes Israela ughe: ‘I TA ILEPLEEP’ tauta imbaaŋ ghau payam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ve Maaron isaav pa Mose muul ighe: “Usaav pa yes Israela tauvene: ‘Yoova, Maaron to timbuunŋa Abaram, Isak, ve Yakop, ta imbaaŋ ghau nalam payam. I eeza “YAU TAUG NALEPLEEP.” ’ Ezag tane pale igheen le alok. Tauvene tamtamon tau pale tivot murei na, aat matazi iŋgal ezag tane taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tauvene yo ula ulup zolman to yes Israela, ve usaav pazi tauvene: ‘Yoova, Maaron tau timbuunŋa Abaram, Isak, ve Yakop tibesbees pani na, tauta ivot tsiau, ve aliiŋa ilat payam ighe: I maata payam irau saawe. Tauvene ŋgar sasaghati naol tau yes Isipa tighamgham payam na, i ighit zi wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ve i isaav tauvene: Taan Isip tau aazne andeeŋ pataŋani tiina pani na, i aat igham gham apuli, ve ala aleep izi taan to yes Kanaana, Hita, Amora, Peresa, Hivia, ve Yebusa. Taan tawe ŋgoreeŋa tiina ve igham gabua naol titum poi.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Tauvene yo ula usavia aliŋag tane pa zolman to yes Israela. Yes pale tilooŋ ghom. Mako ugham zi gha yamŋa ala avot to kinik to yes Isipa, ve asaav pani aghe: ‘Yoova, Maaron to yei Hibrua, i ivot tsiei wa. Tauvene nighe yo uyok payei, leso nila nugh ŋginaaŋa ve nigham watooŋrau pani izi ta sewe. Pale nilaagh irau mboŋ tol, mako nila nivot.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Eemon yau nawatagh: Kinik to Isipa, i irau iyok payam rekia mako. Yau aat natotoi tapirig pani, o iyok payam. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tauvene yau aat natotoi tapirig pa yes Isipa, ve nagham gabua ŋgeretazi tintiina tau matazi ite kat na tivot ila sosozi. Leso natatan tapirizi, ve kinik toozi ipul gham ala. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Saawe tau yam apaburigin laghooŋ, yau aat nagham yes Isipa lolozi payam, ve tirei lemim gabua siriv. Leso ala toman nimamim ŋginaaŋa sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tauvene zilivaa tsiam tisov aat tila ve tighason yes Isip tinazi tau tileep tomani zi na, to tigham lezi nonoghiiŋa popoiazi tomania kuaz toozi siriv tau tigharaat zi pa gol ma silva. Yes pale tigham payam. Gabua toozi tawe pale tisov timin natmimŋa lezi to tinonogh zi pani. Tauvene yam aat ayauur gabua toozi le isov, o aburig ala.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Yoova isavsaav le isov, ve Mose isaav pani ighe: “Poia. Eemon isaav ighe yes Israela tighur ila saveeŋ tsiau mako, ve tilooŋ ghau mako, ve tisaav payau tighe: ‘Waa, Yoova ivot tsio onoon, ma ugham karom?’ Ene pale nasaav pazi mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tauvene Yoova ighasoni ighe: “Yo ukiskis saa tana?” Mose isaav pani ighe: “Ene titi tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yoova isaav pani muul ighe: “Usiki izi taan.” Tauvene Mose isik titi tooni izi taan, le itoor ghi imin moot. Mose ighita moot tawe, le irur pani, ve ighau ila soghan. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yoova isaav pani muul ighe: “Nimam izi ukis iighu.” Saawe tau Mose niima izi ikis moot iighu, ene itoor ghi imin titi muul ila i niima. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ra Yoova isaav pani ighe: “Ulooŋ. Saawe tau yo ula uvot to yes Israela, na ugham tauvene. Leso tighur ila tighe: Yau Yoova, Maaron to timbumimŋa Abaram, Isak ve Yakop, ta navot tsio, ve tilooŋ aliŋam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ve Yoova isaav pani muul ighe: “Uzeev nimam iloŋ ila nonoghiiŋa tsio.” Mose igham tauvene, ve saawe tau ipas niima ivot, ighita kolekole igham niima le isaghat ve ipisosooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yoova isaav pani muul ighe: “Uzeev nimam imuul iloŋ ila.” Tauvene Mose izeev niima iloŋ ila nonoghiiŋa tooni muul. Ve saawe tau ipasu ivot, ighita niima poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ra Yoova isaav pani tauvene: “Isaav ighe yes Israela tighur ila saveeŋ tsio mako, na ugham gabua ŋgereeta ivot pa titi imin maata, leso itotoi ighe yau naleep tomani ghom. Ve isaav ighe tighur ila soone, na utotoi ite tana pazi, leso tighita ve tighur ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ve isaav ighe gabua ŋgeretazi ru tana igham zi tighur ila saveeŋ tsio mako, na utiv yaa Nil rigta, ve uliŋi izi taan gorgori. Yaa tana pale imin siŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ra Mose isaav pa Yoova ighe: “O Tiina, yau tane, ŋeer to savsaveeŋ mako. Muuŋ ve ilam, avog ipataŋan pa savsaveeŋ. Ve aazne paam, yo uvot tsiau ve usavsaav tomani ghau, eemon avog ipapataŋan soone.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tauvene Yoova isaav pani ighe: “Sei ighur tamtamon avozi? Ve sei igham tamtamon taliŋazi ipam, ve avozi ivool? Ve sei igham tamtamon tileep matazi yaryaare ve tighita nugh, ve igham matazi ikumkuum? Yau Yoova mon. Ite paam mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tauvene aazne, uburig ve ula. Yau taug pale naleep tomani ghom, ve napariaaŋ ghom pa savsaveeŋ. Ve yau pale napaghazoŋai ŋgar tsio, leso uwatagh saa saveeŋ tau naghe usavia.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Eemon Mose iyol Maaron aliiŋa ighe: “Aa Tiina tsiau, yau narao mako. Umbaaŋ tamtamon ite paam ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tauvene Yoova aate yavyav pa Mose, ve isaav pani ighe: “Ve mindai pa togham Aron? I siŋ to Levi paam. Yau nawataghi: I ŋeer to savsaveeŋ. Ulooŋ. I ilaagh taghon eez ilam ighe ighit ghom. Saawe tau ilam peria ve ighit ghom, i pale loolo poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tauvene saa saveeŋ tau yau nasavia payo, na yo aat usavia pani gha ilooŋa. Mako i aana igham avom, ve ivotia aliŋam pa tamtamon. Yau taug pale napariaaŋ gham pa savsaveeŋ, ve napaghazoŋai gham pa saa ŋgar tau pale aghamu. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tauvene Aron pale igham avom ve ivotia aliŋam pa eval tiina. Yamru pale ataghon ŋgar imin yau Maaron naghamgham pa yes propet tsiau. Pasaa, yo pale usavia aliŋam ila tooni, mako i aana isavia ila pa eval tiina. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","“Ve matam iŋgal titi tsio paam. Ukisi ve ula. Pa yo pale ugham gabua ŋgeretazi siriv ivot pani. Gabua tana pale itotoi ighe yau naleep tomani ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose yesuru Yoova tisavsaav le isov, ra imuul ila to raawa Yetro, ve ighasoni ighe: “Olman, naghe namuul nala Isip ve nagig toŋvetaz tsiau. Tisov tilepleep, ma siriv timatmaat wa?” Raawa iyok pani ighe: “Poia. Ula toman lolom poia.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Saawe tau Mose ileep izi Midian, Yoova isaav pani ighe: “Umuul ula pa Isip. Pa zeran tau muuŋ tighe tirav ghom umaat na, tisov timataar wa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tauvene Mose igham azaawa tomania natŋa, ighur zi tizala doŋki, ve ikis titi to Maaron, ve tipaburigin laghooŋ toozi tighe tizila pa Isip. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tilaghlaagh tila, ve Yoova isaav pani ighe: “Yau naghur tapirig izaa tsio, leso ugham gabua ŋgeretazi maata maata. Saawe tau yo ula uvot Isip, na ugham gabua ŋgeretazi tana tisov tivot ila kinik toozi naagho. Eemon yau aat nagham ŋgar tooni iyaryaaŋ kat. Leso ipul yam Israela ala rekia sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Murei, o uvotia aliŋag pani ughe: ‘Yoova isaav payo tauvene: “Tamtamon to Israel, yes timin natug aidaaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Yau nasaav payo wa naghe: ‘Upul natugŋa tilam, leso tibees payau ve tisuŋ payau.’ Eemon yo uzoor aliŋag, ve uŋguruut zi. Tauvene yau aat narav natum aidaaba imaat.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mose yesuru azaawa ve natŋa tilaghlaagh tila le mboŋ izi, mako tigheen izi mariaoŋ niia ee. Saawe tana, Yoova ivot to Mose ve ighe iravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Eemon Mose azaawa Sipora rekia mon igham gharghar ve irav motin naatu waaro uuli, ve ighuru ila Mose aaghe, ve isaav pani ighe: “Yo azuwag duduuŋ. Pasaa, siŋ izala pavom wa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Yoova ighita gabua tana, tauta irav Mose imaat mako, ve ipuli ileep. Ra tipaburigin laghooŋ toozi muul gha tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mose toogha Aron ileep izi Isip, ve Yoova ila ivot tooni, ve isaav pani ighe: “Uburig ula pa nugh ŋginaaŋa, mako ughita tazim Mose ta sewe.” Tauvene Aron iburig ila, ve izaa to Mose izi loloz to Maaron puughu. I ighita taazi Mose, le loolo poia kat ve iyaŋin pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ra Mose ipaes pani pa saveeŋ isov tau Yoova imbaaŋo to ivotia na. Ve ipaesia gabua ŋgeretazi tau Yoova isaav pani to igham zi na paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","30","Ra yesuru tilaagh muul. Tila tila le tivot Isip, ra tipoi zolman tisov to yes Israela tilam gha yesŋa tilup zi, ve Aron ipaes pazi pa saveeŋ isov tau Yoova isavia pa Mose na. Ve itotoi gabua ŋgeretazi siriv tana paam ila eval tiina matazi ve tighita, leso tighur ila tighe Yoova ileep tomani zi pa uraat toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tauvene eval tiina tighur ila saveeŋ toozi. Saawe tau eval tiina tilooŋ tighe Yoova ighita pataŋani toozi ve ighe iuul zi, yes tiput aghezi, ve tipait Maaron eeza. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mose yesuru Aron tilup yes Israela le isov, ra tila tighita kinik to Isip, ve tisaav pani tighe: “O kinik, ulooŋ. Yoova, to Maaron to yei Israela na, aliiŋa ilat payo ighe: Upul tamtamon tooni tila pa nugh ŋginaaŋa. Leso tilup zi ta sewe, ve tigham suŋuuŋ tiina pani.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Eemon kinik isaav pazi ighe: “Yoova, i sei, ta pale nalooŋ aliiŋa ve napul yam Israela ala? Yau nawatagh Yoova mako. Tauvene irau nalooŋ aliiŋa, ve napul yam Israela ala ne mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tauvene tisaav pani muul tighe: “O kinik, Yoova tau Maaron to yei Hibrua, i ivot tsiei wa. Tauvene nighe yo upul ghei nila pa nugh ŋginaaŋa. Leso nilup ghei pa suŋuuŋ izi ta sewe, ve nigham watooŋrau pani. Pale nilaagh irau mboŋ tol, o nila nivot. Isaav ighe nila tooni mako, i pale igham moroghooŋ saghati eta ivot payei ve ivaghamun ghei, ma igham malmal ivot ve tirav ghei pa mbuzaagh.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Eemon kinik iyol aliŋazi ighe: “Puughu mindai ta yamru aghe agham tamtamon tipul uraat toozi? Rekia mon ve amuul ala pa uraat tsiam! ");
INSERT INTO tuc_t_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Aazne, yam loomba sorok amasa amin eval kat. Tauta yamru aghe agham zeetmimŋa tipul uraat toozi ne?” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","7","Aaz eemon tana, kinik to Isip iburig ve isaav ariaaŋ pa tauu uraata tooni siriv tau tighurghur uraat pa yes Israela, tomania Israela siriv tau tiŋgin zetazŋa pa uraat na ighe: “Alooŋ. Wit ve bali ayazi tau Israela tikepu tomania pirpir ve tigharaat brik pani na, auul zi ve agham pazi muul sov. Aleep, ve tauzi tila tiil ve tighamu. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Eemon uraat tau aghuru pazi na, azuure izi sov. Igheen toman niia. Pasaa, yes tapirgomŋa kat. Tauta titaŋ rarai ghau tighe napul zi tila leso tigham watooŋrau pa Maaron toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tauvene yam aghur uraat pataŋani kat pazi. Leso tigham ŋgar pa saveeŋ karom muul sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kinik isavsaav tomani zi le isov, ra yes uraata tooni tawe yesŋa yes Israela tau tiŋginŋgin zetazŋa pa uraat na, tila tivot to eval tiina to Israel, ve tipaes pazi tighe: “Kinik aliiŋa ilat payam tauvene: I irau iuul gham pa wit ve bali ayazi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Aazne ve ila, i ipul uraat tana ila yam taumim nimamim. Tauvene yam ala pa nugh sindei tau irau andeeŋ gabua ayazi pani, ve ayau lemim. Eemon uraat tau yei nighuru payam na, ene irau nizuure izi mako. Brik piiz tau yei nighuru payam na, yam aat agharaat zi le raraate imin tau muuŋ na.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tauvene yes Israela tiparmbiriis tirau taan isov to Isip, ve tiyauyau wit ve bali ayazi tau tirav motmotin zi. Leso tikepu tomania pirpir, ve tigharaat brik pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ve yes daaba tau tighurghur uraat pazi na, tipasul zi tighe: “Ai, yam avaghamgham kat pa uraat! Mataaz ta naol ne, brik piiz tau yei nisaav payam to agharaat zi, na yam aat apasovuur zi, imin muuŋ, saawe tau yei niuluul gham pa gabua ayazi na.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ve yes daaba tawe tila to yes Israela tau tiŋginŋgin zetazŋa pa uraat na, gha tilosiir zi, ve tisaav pazi tighe: “Muuŋ, brik piiz tau yei nisaav payam to agharaat zi, na yam aghagharaat zi ve apapasov zi. Mindai ta noor ve aazne, ninin brik tsiam le imbool?” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Tauvene yes Israela tau tiŋgin zetazŋa pa uraat na, tila to kinik, ve titaŋ raraini tighe: “Tiina tsiei, yei besooŋa tsio. Puughu mindai ta ugham ŋgar tane payei? ");
INSERT INTO tuc_t_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Aazne, tilosiir ghei le naghomai isaghat. Pasaa, tighe yei nigham uraat irao mako. Ve sei imin puughu pani? Ene yes uraata tsio. Pasaa, yes tisaav pa yei besooŋa tsio tighe nigharaat brik raraate imin muuŋ. Eemon tiuul ghei pa gabua ayazi muul mako. Tauta nigharaat naol mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Kinik iyaon zi ighe: “Yam tapirgomŋa le tapirgomŋa kat. Arau uraat mako. Tauta anoknok saveeŋ payau aghe napul gham ala, leso agham watooŋrau pa Maaron tsiam Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Eemon aat mako. Rekia mon amuul ala pa uraat tsiam. Irau tiuul gham pa gabua ayazi muul mako! Ve brik piiz tau tighuru payam to agharaat zi na, yam aat apasov zi.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Yes tilooŋ saveeŋ tana, ve tighilaal tighe yes tileep ila pataŋani tiina loolo wa. Pasaa, kinik isaav pazi ighe: Brik piiz tau tighuru pazi to tigharaat zi na, irau tizuure izi mako. Yes aat tipasov zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ra tipul kinik ve tivot tila, le tindeeŋ Mose gha Aron. Pasaa, yesuru tileep muuri ve tisasaŋan zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Tighit zi, ve tiyaon zi tighe: “Ŋgar tau agham payei na, Yoova ighita wa. Ve i tauu pale ighur atuya payam! Pasaa, yamru ta agham kinik tomania yes uraata tooni atezi yavyav kat payei. Yes tighit ghei tighe yei sasaghatmai kat. Aazne, yamru aghur mbuzaagh ila nimazi, leso tirav ghei nisov nimatmaat.” ");
INSERT INTO tuc_t_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tauvene Mose imuul ila ve ighason Yoova ighe: “O Tiina, puughu mindai ta yo ugham pataŋani tiina tauvene ivot pa tamtamon tsio? Yo umbaaŋ ghau nalam sene pasaa? ");
INSERT INTO tuc_t_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Saawe imin maata tau yau nala navotia aliŋam pa kinik to Isip, ve ilam aazne, i ighurghur pataŋani naol pa yes Israela. Eemon yo uul zi rigta pa pataŋani toozi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tauvene Yoova isaav pa Mose ighe: “Aazne, yo aat ughit katin ŋgar tau yau pale nagham pa kinik to Isip. Yau pale natotoi tapirig tiina pani, leso ipul yes Israela tila. I pale ighit katin yau tapirig le isov, o iziir gham aghau pa nugh tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ve Maaron isaav pa Mose muul ighe: “Yau Yoova nalepleep. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Muuŋ, saawe tau navot to Abaram, Isak, ve Yakop, navotia taug pazi naghe: Yau Maaron Saksaki Tau Naliiv Zimaronŋa Tisov. Eemon ezag Yoova, ene navotia pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ve nambu saveeŋ tomani zi naghe yeŋa pale nivalupu ghei nimin eemon, ve nagham taan to yes Kanaana tau tileep timin loom pani na, imin lezi motot. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","“Aazne, yes Israela titaŋ tiina pasaa, yes Isipa tighamgham saghatin zi, ve tighurghur pataŋani naol pazi. Eemon taŋiiz toozi, yau nalooŋa wa. Ve matag iŋgalŋgal saveeŋ mbuaaŋ tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Tauvene yo aat ula ve uvotia aliŋag pa yes Israela ughe: ‘Yau Yoova nalepleep. Aazne, yam amin besooŋa pa yes Isipa, ve tapirizi itatan gham le lemim eez eta mako. Eemon yau aat nagham gabua ŋgeretazi tintiina siriv, leso nagham mulin gham ila yes Isipa nimazi. Pale natotoi tapirig tiina ivot ighazooŋ, ve naghur atuya iŋarui zi pa sosor toozi. Leso napas gham avot pa pataŋani tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ve yau pale nagham gham amin tamtamon tsiau, ve yau Yoova namin Maaron tsiam. Ve yam pale awatagh katin ghau, ve aghazooŋ pa gabuag tomania ŋgar tsiau. Pasaa, uraat tau naghe nagham payam, ene pale ipaghazoŋai ŋgar tsiam payau. Onoon, aazne yes Isipa tapirizi itatan gham. Eemon yau aat nagham mulin gham ila nimazi, ve nagharaat eez payam, leso apul nugh toozi ve ala. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Muuŋ, yau nambu saveeŋ ve napariaaŋa le iyaryaaŋ kat naghe nagham taan to yes Kanaana pa Abaram, Isak, ve Yakop imin lezi motot. Tauvene yau pale nagham gham ala avot taan tawe, ve naghamu imin lemim kat, leso aleep pani taghon taghon gha ila. Pasaa, yau Yoova nalepleep.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Yoova isavia saveeŋ tane le isov, ra Mose ila ipaesia Yoova aliiŋa pa yes Israela. Eemon uraat pataŋani tau yes tighamghamu na, ene itatan zi le tapirizi isov kat. Tauvene lolozi pa loŋaaŋ saveeŋ tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ra Yoova isaav pa Mose muul ighe: “Ula ughita kinik to Isip, ve usaav pani to iyok pa yes Israela, leso tipul taan tooni ve tila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Eemon Mose iyol Yoova aliiŋa ighe: “Yau ŋeer to savsaveeŋ mako. Isaav ighe yes Israela tilooŋ saveeŋ tsiau mako, ene pale kinik paam, irau ilooŋ ghau mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ra Yoova isaav pa Mose gha Aron ighe timuul tila to yes Israela ve kinik to Isip. Ve ighur uraat pa yesuru ighe tigham yes Israela tipul Isip ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ene pitiiŋ to yes Israela timbuzŋa siriv. Yakop naatu aidaaba eeza Ruben. Ve Ruben natŋa, ene: Anok, Palu, Ezron, ve Karmi. Yes tana tivot timin eval, ve murei ra, tivalagh tauzi timin rumei paaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Yakop naatu Simeon natŋa, ene: Yemuel, Yamin, Oat, Yakin, Zoar, ve Saul. (Saul tiina, i Kanaan tinazi.) Yes tana ta tivot ila to Simeon le timin eval, ve murei ra, tivalagh tauzi timin rumei liim ve ee. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yakop naatu Levi natŋa ezazi, ene: Gerson, Koat, ve Merari. Levi ileep irau ndaman 137, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerson natŋa, ene: Libni ve Simei. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koat natŋa, ene: Amram, Izar, Ebron, ve Usiel. Koat ileep irau ndaman 133, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari natŋa, ene: Mali gha Musi. Yes tana ta tivot ila to Levi le timin eval, ve murei ra, tivalagh tauzi timin rumei rumei. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ivai waghliva Yokopet. Ve Yokopet ipoop Aron yesuru Mose. Amram ileep irau ndaman 137, ra imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izar natŋa, ene: Kora, Nepek, ve Zikri. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ve Usiel natŋa, ene: Misael, Elzapan, ve Sitri. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron ivai Eliseba tau Aminadap natliva, i Nason liivu. Eliseba yesuru Aron tipoop paaŋ: Nadap, Abiu, Eleasar, ve Itamar. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora natŋa, ene: Asir, Elkana, ve Abiasap. Kora natŋa tol tana tivot timin eval, ve murei ra, tivalagh tauzi timin rumei tol. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron naatu Eleasar ivai Putiel natliva, ve tipoop Pineas. Yes tane ta Levi paaghu tooni, ve timin daaba pa rumei toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","27","Ene Aron yesuru Mose puughu toozi. Yoova ighur yesuru to timuuŋ pa yes Israela, ve tigham zi tipul Isip, ve tilaagh ila ŋgun ŋgun itaghon rumei toz toz, ve tila pa taan Kanaan. Ve yesuru, ta tisaav pa kinik to Isip tighe i iyok pazi leso tigham yes Israela tipul nugh Isip ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Saawe tau Mose ilepleep izi taan Isip, Yoova isaav pani ighe: “Yau Yoova nalepleep. Saveeŋ isov tau yau nasavia payo na, yo aat usavia pa kinik to yes Isipa leso ilooŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Eemon Mose isaav pa Yoova ighe: “Yau ŋeer to savsaveeŋ mako. Pale kinik ilooŋ ghau mindai?” ");
INSERT INTO tuc_t_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yoova isaav pa Mose muul ighe: “Ulooŋ. Yau Maaron ta naghur ghom to ugham naghog, ve uyooz ila kinik to Isip naagho. Ve togham Aron pale imin propet tsio, ve ivotia aliŋam pa kinik. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tauvene saa saveeŋ tau ighe yau nasavia payo, yo aat usavia pa Aron. Leso aana isavia aliŋag ila to kinik. I aat isaav pa kinik leso iyok pa yes Israela ve tipul nugh tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Eemon yau aat nagham kinik ŋgar tooni iyaryaaŋ kat. Leso leg sooso to natotoi tapirig izi taan to yes Isipa, ve nagham zi tighilaal tighe yau nalepleep. Pale nagham gabua ŋgeretazi naol tau ite kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tauvene kinik to Isip irau ilooŋ gham rekia mako. Pale ikis gham rig. Eemon murei yau aat natotoi nimag pa yes Isipa, ve naghur pataŋani tintiina izaa toozi imin atuya pa sosor toozi. Mako nagham tamtamon tsiau Israela tipul taan to Isip ve tila. Pale tilaagh ila ŋgun ŋgun imin yes zaaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","“Saawe tau natotoi tapirig ivot ighazooŋ pa yes Isipa, ve nagham yes Israela tipul nugh toozi, ene yes Isipa paam pale tighilaal tighe: Yau Yoova nalepleep, ve tighazooŋ pa gabuag tomania ŋgar tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Yoova isavsaav le isov, ra Mose yesuru Aron tila ve titaghon duduŋai saveeŋ tau i ighuru pazi na. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Saawe tana, Mose ndaman tooni irau tamoot paaŋ (80). Ve Aron ndaman tooni irau tamoot paaŋ ve tol (83). ");
INSERT INTO tuc_t_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yoova isaav pa Mose yesuru Aron ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Alooŋ. Isaav ighe kinik to Isip isaav pa yamru to agham gabua ŋgereeta eta, na usaav pa Aron to igham titi tooni, ve isiki izi taan ila kinik naagho. Titi tooni pale imin moot.” ");
INSERT INTO tuc_t_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tauvene yesuru tila tivot to kinik, ve titaghon duduŋai saveeŋ tau Yoova isavia pazi na. Aron isik titi tooni izi taan ila kinik tomania uraata tooni naghozi, le titi tooni imin moot. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kinik ighita gabua tana, ve ipoi tamtamon ŋgara siriv tomania yes mura siriv to Isip tilam, ve yes paam tigham mur toozi le ivot raraate imin Aron ighamu. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yes eŋaeŋa tisik titi toz toz tizi taan, ve titi toozi timin moot. Eemon titi to Aron tau imin moot na, itoon moot toozi tawe tisov. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kinik ighita gabua ŋgereeta tana pa tauu maata. Eemon ŋgar tooni iyaryaaŋ kat ighe izoor Mose yesuru Aron aliŋazi. Ŋgar tau i ighamu na, ene iduduuŋ kat pa saveeŋ tau muuŋ Yoova isavia pa yesuru na. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Murei ra, Yoova isaav pa Mose muul ighe: “Kinik to Isip, ŋgar tooni iyaryaaŋ kat ighe i irau ipul yes Israela tila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bogzo mboŋoozo, i pale izila yaa Nil. Tauvene yo ugham titi tau imin moot na, ve umuuŋ uzila usaŋani izi yaa ziige. Saawe tau i ilat peria, ");
INSERT INTO tuc_t_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","mako usaav pani ughe: ‘Yoova tau Maaron to yei Hibrua na, imbaaŋ ghau nalam ve nasavia aliiŋa payo wa. I ighe yo upul tamtamon tooni Israel tila, leso tibees pani ve tisuŋ pani izi nugh ŋginaaŋa. Eemon saawe tana ve ilam aazne, yo ulooŋ aliiŋa rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","18","Tauvene Yoova aliiŋa ilat payo muul ighe: I aat igham ŋgar ite paam. Leso uwatagh ughe i ilepleep, ve ughazooŋ pa gabua tomania ŋgar tooni. Ughita. Yau aat nalos yaa Nil pa titi tsiau tau nakiskisi ne, mako yaa Nil imin siŋ, ve iigh tau tileep ila yaa loolo ne tisov timataar. Ve yaa pale vaazi isaghat kat. Tauvene tamtamon to Isip pale lolozi pa ghunuuŋ muul mako.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ve Yoova isaav muul pa Mose ighe: “Usaav pa togham Aron to igham titi tooni, ve itotoia iŋarui yaa tisov to yes Isipa. Yaa tintiina, ve yaa geegeu tau tirereer taghon uum lolozi na, yaa naliu, ve yaa toozi to ghunuuŋ tau ighenaar izila uur ve rubruub lolozi na paam. Yaa tawe pale tisov timin siŋ mon. Tauvene siŋ pale irau taan isov to Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tauvene Mose yesuru Aron tila ve titaghon duduŋai saveeŋ tau Yoova isavia pazi na. Aron ila iyooz ila kinik to Isip tomania yes uraata tooni naghozi, ve iit titi tooni izaa, ra ilos yaa Nil pani, ve yaa Nil imin siŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tauvene iigh tau tileep ila yaa loolo na, tisov timataar le yaa vaazi. Yaa to yes Isipa, eta poia muul mako. Tisov timin siŋ mon. Tauvene yes Isipa irau tighun yaa Nil muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Eemon yes mura to Isip tiburig, ve anazi tigham mur toozi pa yaa, le ivot raraate imin tau Mose gha Aron tighamu na. Tauvene kinik ŋgar tooni iyaryaaŋ muul, ve ilooŋ yesuru saveeŋ toozi mako. Ŋgar tau i ighamu, ene iduduuŋ kat pa saveeŋ tau Yoova isavia pa Mose gha Aron imin maata na. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ra kinik itoor ghi, ve imuul ila pa ruum tooni, ve maata ila pa gabua tana muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Yes Isipa irau tighun yaa Nil muul mako. Tauvene titai puura katini itaghon yaa Nil ziige, leso titiv lezi yaa pa ghunuuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yoova ivaghamunia yaa Nil, ve igheen tauvene irau mboŋ liim ve ru. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mboŋ liim ve ru tana isov, ra Yoova isaav pa Mose ighe: “Ula ughita kinik to Isip muul, ve usaav pani ughe: ‘Yoova aliiŋa ilat payo ighe: Upul tamtamon tooni Israel tila, leso tibees pani ve tisuŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Isaav ighe yo uŋguruut zi, na uyamaan ghom. Pa i aat ivaghamunia taan dodoli to Isip pa gob. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Gob ndiŋndiŋ ndiŋndiŋ pale tivot ila yaa Nil, ve tipul yaa ve tiŋarui ruum tsio tilat. Mako tiloŋ tila ruum, ve tiyaat tizala niam to ghenooŋ paam. Ve tiloŋ tila ruum to uraata tsio, ve tiyaat tizala eval tiina to Isip pavozi paam. Ve gob pale tiloŋ tila niamim to naznazuuŋ, ve tiyaat tiloŋ tila uur to kepuuŋ mberet lolozi paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tauvene yo yamŋa uraata tsio, ve eval tiina to Isip paam, gob pale tiyatyaat tizala pavomim.’” Yoova isavsaav le isov, ra Mose ila ipaesia aliiŋa tana pa kinik. Eemon kinik ilooŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Tauvene Yoova isaav pa Mose muul ighe: “Usaav pa Aron to iit titi tooni izaa, ve itotoia iŋarui yaa tisov to Isip: Yaa tintiina, ve yaa geegeu tau tirereer taghon uum lolozi na, ve yaa naliu paam. Leso gob tivot pa yaa ta naol ne, ve tileep irau taan isov to Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tauvene Aron iit titi tooni izaa, ve itotoia iŋarui yaa tisov to yes Isipa. Ra gob ndiŋndiŋ ndiŋndiŋ tivot, le tileep irau taan isov to yes Isipa. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Eemon yes mura to Isip tigham mur toozi, ve yes paam tigham gob katini tivot izi taan to Isip. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ra kinik to Isip ipoi Mose yesuru Aron tilam, ve isaav pazi ighe: “Yamru aghason Yoova to iziir gob tane tighau payau ve tamtamon tsiau paam! Leso napul yes Israela tila tigham watooŋrau pa Yoova.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose isaav pani ighe: “Poia. Yo taum ughur saawe eta to nasuŋ pa Yoova. Leso loolo isaghatin ghom tomania yes uraata tsio, ve eval tiina to Isip, ve iziir gob tighawaar pa ruum tsiam. Eemon gob tau tileep yaa Nil ziige na, pale tileep mon ta sewe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Tauvene kinik isaav pani ighe: “Bogzo, o usuŋ.” Mose isaav pani ighe: “Poia. Pale nataghon aliŋam. Leso uwatagh kat ughe: Yoova, Maaron to yei Israela, i Maaron tauu. I raraate imin zimaronŋa siriv mako. Bogzo o, gob tisov tipul ghom tomania ruum tsio, ve tipul yes uraata tsio, ve eval tiina to Isip paam, ve tisov tighau tila. Eemon gob tau tileep yaa Nil ziige na, pale tileep mon ta sewe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tauvene Mose yesuru Aron tipul kinik, ve timuul tila, ra Mose itaŋ rarai Yoova ighe gob tau iŋgal kinik maata pani na, iziir zi tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ve Yoova ilooŋ suŋuuŋ tooni. Tauvene gob tisov tau tileep ila ruum to yes Isipa lolozi, ve taghon ruum zigezi, ve ila uum lolozi na, tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ra yes Isipa tindou zi ila ŋgun ŋgun, ve timbuzaar le vazizi ikau nugh. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Saawe tau kinik to Isip ighita pataŋani to gob isov, i isaav ighe: “Aa saleem! Aazne ra, nimariau!” Eemon ŋgar tooni iyaryaaŋ muul ighe izoor Yoova aliiŋa. Tauvene ilooŋ Mose yesuru Aron aliŋazi mako, ve iŋguruut yes Israela muul. Ŋgar tau i ighamu, ene iduduuŋ pa saveeŋ tau Yoova isavia pa Mose gha Aron na. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Saawe siriv ilam ila, ra Yoova isaav pa Mose ighe: “Usaav pa Aron to igham titi tooni, ve ilos taan. Leso ŋgaupup irau taan isov to Isip imin suum.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","18","Tauvene yesuru titaghon Maaron aliiŋa. Saawe tau Aron igham titi tooni ve ilos taan pani, ŋgaupup isov to Isip imin suum ve tiŋut yes Isipa tomania ŋgai toozi le tisaghat kat. Ra yes mura anazi tighe titoov tapirizi leso tigham suum tivot. Eemon tirao mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tauvene tila tipaes pa kinik tighe: “Wai, gabua tane ivot ila Maaron tauu niima.” Eemon kinik ŋgar tooni iyaryaaŋ kat ighe izoor Maaron aliiŋa. Tauvene ilooŋ Mose yesuru Aron mako. Ene iduduuŋ kat pa Yoova aliiŋa ta muuŋ isavia na. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Murei ra, Yoova isaav pa Mose ighe: “Bogzo ndoroome, ve uburig uzila yaa Nil ziige, ve usaŋan kinik to Isip. Ighe ilam ivot, mako uŋaruini ula, ve usaav pani ughe: Yoova aliiŋa ilat payo ighe: Upul tamtamon tooni tila, leso timbees pani ve tisuŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Isaav ighe yo uŋguruut zi, na uyamaan ghom. Pa i aat imbaaŋ nimnim tintiina ndiŋndiŋ ndiŋndiŋ tilat, ve tiŋut ghom tomania yes uraata tsio, ve eval tiina to Isip paam. Nugh tsiam tomania ruum tsiam pale tivon pa nimnim tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Eemon i aat ipoon taan sirivu to Gosen tau tamtamon tooni Israel tileep ila na, ve nimnim eta irau ivot pazi mako. Leso yo uwatagh ughe i ileep izi taan tsio paam. Pasaa, i pale itaghon ŋgar ite ite pa tamtamon tooni ve tamtamon tsio. Bogzo, o igham gabua ŋgereeta tane ivot, leso itotoi tapiri payo.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tauvene Yoova itaghon aliiŋa tane, ve igham anooŋa ivot. I igham nimnim tintiina ndiŋndiŋ ndiŋndiŋ tivot. Nimnim tawe tiloŋ tila kinik ruum tooni, ve ruum to yes uraata tooni, ve tipavon taan dodoli to yes Isipa. Tivaghamunia yes Isipa le tisaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tauvene kinik imbaaŋ pa Mose yesuru Aron tilam, ve isaav pazi ighe: “Irao lak! Yam Israela ala agham watooŋrau pa Maaron tsiam. Eemon ala nugh malau sov. Aleep tataŋgan izi taan to yei Isipa, ve agham uraat tana.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Eemon Mose isaav pani ighe: “Vene mako. Isaav ighe nirav ŋgai tsiei imin watooŋrau pa Maaron tsiei Yoova ila yes Isipa matazi, ene pale irao ŋgar toozi mako, ve tiburig gha tirav ghei pa maet. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tauvene nighe yo uyok payei, leso nila nugh ŋginaaŋa, ve nigham watooŋrau pa Maaron tsiei Yoova izi ta sewe itaghon saveeŋ tau i tauu ighuru payei na. Pale nilaagh irau mboŋ tol, o nila nivot.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kinik ilooŋ saveeŋ tane, ve isaav ighe: “Poia. Yau nayok. Yam irau ala nugh ŋginaaŋa ve agham watooŋrau pa Maaron tsiam Yoova. Eemon ala nugh malau sov. Ve matamim iŋgal ghau paam ila suŋuuŋ tsiam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose iyol aliiŋa ighe: “Ulooŋ. Yau naghe naburig nala tane. Saawe tau napul ghom ve nala, yau aat nasuŋ pa Yoova, leso bogzo iziir nimnim tane tighau payam. Yo tomania uraata tsio, ve eval tiina to Isip paam, nimnim pale tighawaar pa yam asov. Eemon kinik, yau nasaav payo: Ugham karom payei ve uŋguruut ghei muul sov. Upul ghei nila nigham watooŋrau pa Yoova.” ");
INSERT INTO tuc_t_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ra Mose ipul kinik, ve ila isuŋ pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yoova ilooŋ suŋuuŋ tooni, ve iziir nimnim tisov tighawaar pa kinik tomania uraata tooni ve eval tiina to Isip, le nimnim eta ivot muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Eemon kinik ŋgar tooni iyaryaaŋ muul ighe ikis yes Israela tileep. Tauta ipul zi tila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Saawe siriv ilam ila, ra Yoova isaav pa Mose ighe: “Ula to kinik to Isip, ve usaav pani ughe: Yoova, Maaron to yei Hibrua, aliiŋa ilat payo ighe: Upul tamtamon tooni tila, leso tibees pani ve tisuŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Isaav ighe yo uzoor saveeŋ, ve upul zi tila mako, ve unoknok ŋgurutaaŋ zi, na uyamaan ghom. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Pa Yoova pale itotoi tapiri payam, ve ighur moroghooŋ saghati kat pa ŋgai tsiam maata maata tau tilaghlaagh muuri na. Hos, doŋki, kamel, makau, sipsip, ve mekmek tsiam pale timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Eemon ŋgai to yes Israela, eta irau imaat mako. Pasaa, Yoova pale igham ŋgar ite ite pa yes Israela ŋgai toozi ve yam Isipa ŋgai tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ve Yoova ighur saawe ighe bogzo, o igham gabua tane ivot izi taan tane.” ");
INSERT INTO tuc_t_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ve onoon, mboŋ nughizau, ra Yoova igham gabua tana anooŋa ivot le yes Isipa ŋgai toozi katini timatmaat. Eemon yes Israela, ŋgai toozi eta imaat mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kinik to Isip imbaaŋ tamtamon siriv tila titiir nugh, ve yes tighita ŋgai to yes Isipa mon ta timatmaat. Ve Israela toozi, popoiazi mon. Eta imaat mako. Eemon gabua tawe ipaburigin ŋgar to kinik mako. Ŋgar tooni iyaryaaŋ kat ighe iŋguruut yes Israela tileep. Tauta ipul zi tila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Murei ra, Yoova isaav pa Mose yesuru Aron muul ighe: “Yamru ala nugh tau tipatuntun uur na, ve akor avav le nimamim ivon, o ala aghita kinik to Isip. Ala avot tooni, mako Mose iyooz ila kinik naagho ve itir avav izaa. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Avav tana pale imbiriis irau taan isov to yes Isipa. Ve saawe tau itap izala tamtamon ma ŋgai pavozi, ene pale sambor tomania mbotmboot sasaghati igham zi.” ");
INSERT INTO tuc_t_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yoova isavsaav le isov, ra yesuru tila nugh tau tipatuntun uur na, ve tikor avav. Yesuru tila tiyooz ila kinik naagho, ve Mose itir avav izaa le imbiriis. Saawe tau itap izala tamtamon ve ŋgai pavozi, sambor tomania mbotmboot sasaghati igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Yes mura paam, sambor igham zi le tisaghat kat, raraate imin eval tiina to Isip. Tauvene tapirizi irau Mose mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Eemon Yoova igham kinik ŋgar tooni iyaryaaŋ le iyaryaaŋ kat. Tauvene i ilooŋ Mose yesuru Aron mako. Ŋgar tau kinik ighamu, ene iduduuŋ pa Yoova aliiŋa tau muuŋ isavia pa Mose na. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","14","Pataŋani to mbotmboot isov ve murei ra, Yoova isaav pa Mose ighe: “Bogzo mboŋoozo, o uburig ula ve usaŋan kinik to Isip. Saawe tau i ilam ivot, mako usaav pani ughe: Yoova, Maaron to yei Hibrua, aliiŋa ilat payo ighe: Upul tamtamon tooni tila, leso tibees pani ve tisuŋ pani. Isaav ighe yo upul zi tila mako, na uyamaan ghom. Pa i aat iŋgal yo tomania uraata tsio ve eval tiina to Isip matamim pa pataŋani siriv tau tintiina kat. Leso yo uwatagh kat ughe: Maaron eta to taan raraate imin i mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Imin ta itotoi katin tapiri payo, kanaŋ ivaghamun ghom tomania tamtamon tsio pa moroghooŋ tiina, ve ipasov gham pa taan alok wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Eemon igham tauvene mako. Pasaa, i ighur ghom pa puughu tane: I ighe itotoi tapiri ivot le ighazooŋ payo, leso murei tamtamon tivotia vaaru irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","“Aazne, yo upakur ghom, ve utatan tamtamon tooni, ve uŋguruut zi ughe tila sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tauvene bogzo mboŋoozo, saawe tauvene, i aat igham ais paatu paatu titaptap tizi. Saawe tau timbumŋa tipaburigin Isip imin nugh paaghu, ve ilam aazne, ais paatu paatu tauvene titap tizi nugh tsiam pai eta soone. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tauvene usaav pa uraata tsio tigham ŋgai tsio tomania gabua tsio tau tigheen muuri na, ve tighur zi tisov tiloŋ tila ruum, leso ruum ipoon zi. Gabua eta igheen muuri sov. Pa ais paatu paatu tau pale tizi ne, ene aat tiravuur gabua naol isov tau tileep muuri na le timatmaat.” Yoova isavsaav pa Moses le isov, ra Mose ila ipaesia Yoova aliiŋa pa kinik. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yes uraata to kinik tau tighur ila Yoova aliiŋa ve tiroi pani na, rekia mon tighur ŋgai ve besooŋa toozi tisov tiloŋ tila ruum. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Eemon yes tau tighur ila mako na, tipul besooŋa ve ŋgai toozi tileep muuri. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ra Yoova isaav pa Mose ighe: “Uraraav nimam izaa, leso ais paatu paatu titaptap tizi irau taan isov to yes Isipa, ve tiravuur gabua isov tau tigheen muuri na: tamtamon, ŋgai, ve aniiŋ isov to uum paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tauvene Mose iit titi tooni izaa, ra Yoova igham nugh ighani milia, ve lalaav iŋgal izizi pa taan toman luutu tiina, ve ais paatu paatu titaptap tizi irau taan isov to yes Isipa. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ais paatu paatu tintiina kat titap tizizi, ve nugh ighani milmilia le nugh isaghat kat. Saawe tau yes Isipa timbuzŋa tipaburigin Isip imin nugh paaghu ve ilam na, gabua tauvene ivot pa nugh toozi pai eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tauvene ais paatu paatu titaptap tizi irau taan isov to yes Isipa, ve iravuur gabua tisov tau tileep ve tigheen izi muuri na: Tamtamon, ŋgai, ve aniiŋ isov to uum. Ve irav ai tisov paam le bogazi tipolpol. Tauvene gabua naol isov tisaghat. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nugh eemon geeg ta ais izi pani mako. Ene taan sirivu to Gosen tau yes Israela tileep pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tauvene kinik to Isip imbaaŋ pa Mose gha Aron tilam, ve isaav pazi ighe: “Irao lak! Aazne, naghilaal naghe nagham sosor wa. Yoova ŋgar tooni, ene iduduuŋ. Ve yau tomania tamtamon tsiau nisosor. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tauvene yamru ala ve asuŋ pa Yoova. Pa ais paatu paatu ve lalaav tane ivaghamun ghei le nisaghat kat. Yau aat napul gham ala. Irau naŋguruut gham muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose isaav pani ighe: “Poia. Yau aat napul nugh tiina ve navot nala muuri, o nararaav nimag izaa, ve nasuŋ pa Yoova. Leso irav motin lalaav, ve ais paatu paatu titap muul sov. Saawe tau gabua ru tana timot, yo aat uwatagh ughe: Taan naol isov tane, ene taan to Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Eemon yau nawatagh: Yo tomania uraata tsio aroi pa Yoova Maaron tsiei soone.” ");
INSERT INTO tuc_t_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Saawe tau ais paatu paatu tawe titaptap tizi, tirav aniiŋ bali ve gabua ite tau tighagharaat nonoghiiŋa tomania gabua siriv pani na, le tisaghatiir. Pasaa, bali itum izaa gha anooŋa ighe ivot, ve gabua ite tawe iruŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Eemon aniiŋ wit tomania aniiŋ toozi ite tau tiwaato tighe ‘spelt’ na, tipaar soone. Tauta ais paatu paatu tana ivaghamun zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mose ipul kinik, ve ivot ila pa nugh tiina ziige, ra iraraav niima izaa, ve isuŋ pa Yoova. Tauvene Yoova irav motin uman tomania lalaav ve ais paatu paatu, ve titap muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Eemon saawe tau kinik ighita uman tomania lalaav ve ais imot, i igham sosor muul. Yesŋa uraata tooni ŋgar toozi iyaryaaŋ muul tighe tiŋguruut yes Israela tileep. Lolozi pa tilooŋ Maaron aliiŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kinik ŋgar tooni iyaryaaŋ kat. Tauta iŋguruut yes Israela muul. Ŋgar tau i ighamu, ene iduduuŋ kat pa Yoova aliiŋa ta Mose isavia na. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Murei ra, Yoova isaav pa Mose ighe: “Ula ughita kinik to Isip muul. Pa yau taug ta nagham i tomania uraata tooni ŋgar toozi iyaryaaŋ. Leso nagham gabua ŋgeretazi tintiina tivot ila sosozi, ve natotoi tapirig pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ve murei imin sinaiŋ pa yam Israela, leso asavia pa natmimŋa ve timbumimŋa, ve asaav pazi aghe: ‘Muuŋ, Yoova itotoi tapiri pa yes Isipa. I igham gabua ŋgeretazi tintiina tivot ila sosozi, ve ipamogherai zi le tivaghamgham kat.’ Ve yam asov pale awatagh aghe yau Yoova nalepleep, ve aghazooŋ pa gabuag tomania ŋgar tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Yoova isavsaav le isov, ra Mose yesuru Aron tila tivot to kinik, ve tisaav pani tighe: “Yoova, Maaron to yei Hibrua, aliiŋa ilat payo muul ighe: Yo ukaria zoraaŋ saveeŋ wa. Pale ŋeez o uput aghem pani ve uleep ila i saamba? Upul tamtamon tooni tila, leso tibees pani ve tisuŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Isaav ighe uŋguruut zi muul, na uyamaan ghom. Pa bogzo mboŋoozo, i aat igham siis tivot, ve tivaghamunia nugh tsio. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Siis tau pale tivot, ene sorok mako. Pale tipavon taan tsiam le irau aghita sooso eta muul mako. Tauvene aniiŋ ŋgirŋgiira tau ais ivaghamunia mako na, siis pale tipasov zi le tisov kat. Ve ai isov tau titum ila uum tsiam lolozi na paam, siis pale tighan suvinia rauazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Yo yamŋa uraata tsio ve eval tiina to Isip paam, ruum tsiam pale tivon kat pa siis. Saawe imin maata tau timbumimŋa tilam tigham nugh tane, ve ilam aazne, aghita siis tauvene tivot pai eta soone.” Mose isavia saveeŋ tane le isov, ra itoor ghi ve ipul kinik, gha ivot ila pa muuri. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yes uraata to kinik tisaav pani tighe: “O kinik, pai piiz ta yo ughe upul ŋeer tawe ighamgham pataŋani pait? Yo uwatagh mako? Nugh to Isip isaghat wa. Upul zitamoot to Israel tila tisuŋ pa Maaron toozi Yoova.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tauvene tila tigham Mose yesuru Aron timuul tilam, ve kinik isaav pazi ighe: “Aazne, yau nayok payam to ala asuŋ pa Maaron tsiam Yoova. Eemon naghe nawatagh: Savunugha kat ta pale tila?” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose iyol aliiŋa ighe: “Yei nisov pale nila. Zolman, geegeu, natmaiŋa zitamoot ve zilivaa, tomania sipsip, mekmek, ve makau tsiei tisov paam. Pa nighe nila nigham suŋuuŋ tiina pa Yoova.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tauvene kinik isaav pani muul ighe: “Yau nawatagh: Isaav ighe nayok payam to ala, ene aat Yoova ileep tomani gham ve poia tooni izaa tsiam. Eemon irau napul azuwamimŋa ve natmimŋa tila tomani gham ne mako. Mako le mako kat! Pa ŋgar saghati eta aat igheen ila lolomim. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tauvene yam zitamoot mon irau ala ve asuŋ pa Yoova. Pa gabua tana, tauta yamru azonokai ghau pani.” I isavsaav pazi le isov, ra iziir Aron yesuru Mose tighau pa naagho, ve tivot tila muuri. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ra Yoova isaav pa Mose ighe: “Uit nimam izaa, ve utotoi iŋarui taan isov to yes Isipa. Leso siis ndiŋndiŋ ndiŋndiŋ tivot, ve tivaghamunia aniiŋ tomania gabua siriv tau titum ila taan toozi. Saa gabua tau ais ivaghamunia mako, ene pale siis tipasovu.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tauvene Mose iit titi tooni izaa, ve itotoi iŋarui taan isov to yes Isipa. Ra Yoova igham yaghur tiina ilaan pa taan ziige tau aaz izaa pani na, ve ilam. Yaghur ilaagh pa mataaz le ila mboŋ gha nughizau muul. Tauta ivuvuur siis tivot. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Siis tau tivot na, sorok mako. Katini kat. Ve tileep irau taan dodoli to Isip, ve tivaghamunia nugh toozi. Muuŋ ve ilam, siis tauvene tivot izi Isip pai eta soone. Ve murei paam, irau tivot muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tauvene siis titav taan isov to yes Isipa, ve tigham taan gabgabuuŋ. Ve tighan suvinia gabua naol isov tau ais ivaghamun zi mako na le tisov kat. Tighan kikiliiŋ, saiŋ, aniiŋ, ai rauazi, ve anoŋazi paam. Taan isov to yes Isipa, gabua mbitai eta igheen muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tauvene rekia mon kinik to Isip imbaaŋ pa Mose yesuru Aron tilam, ve isaav pazi ighe: “Yau nagham sosor tiina kat pa Maaron tsiam Yoova, ve nagham sosor pa yamru paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Lolomim isaghatin ghau muul, ve apul sosor tsiau tane. Irau nagham sosor muul mako. Ve asuŋ Maaron tsiam Yoova to iziir pataŋani tane payei. Mako pale nisov nimataar.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tauvene Mose ipul kinik ileep, ve ila isuŋ pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yoova ilooŋ suŋuuŋ tooni, ve itoor yaghur gha ilaan pa aaz izila ve ilam toman tapiri, le ivuvuur siis tawe tisov tila pa Te Siŋsiŋai. Eta ileep muul izi Isip mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Eemon Yoova igham kinik ŋgar tooni iyaryaaŋ muul. Tauvene ipul yes Israela tila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Murei ra, Yoova isaav pa Mose ighe: “Uit nimam izaa, leso ndoroom tiina ikau Isip. Ndoroom tiina tau pale ivot na, ene maata ite. Pale igham yes Isipa titaŋtaaŋ imin yes tau matazi kumkuuma, ve tiyamaana poia mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tauvene Mose iit niima izaa, ve ndoroom tiina ikau Isip, le igheen irau mboŋ tol ve mataaz tol. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ndoroom tiina tawe ivot le yes Isipa irau tivaghito zi mako. Tauvene mboŋ tol ve mataaz tol tana, yes irau tilaagh mako. Tileep ila ruum toozi mon. Eemon nugh tau yes Israela tileep pani na, ene ghazooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tauvene kinik to Isip ipoi Mose imuul ilam, ve isaav pani ighe: “Yam Israela ala asuŋ pa Yoova. Tomania azuwamimŋa ve natmimŋa asov ala. Eemon yam aat apul makau, sipsip, ve mekmek tsiam tilepaar izi Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","26","Eemon Mose isaav pani ighe: “Ee-e, vene mako. Yei aat niburig tomania ŋgai tsiei tisov. Irau nipul eta ileep mako. Pa yei taumai nikankaan pa saa gabua tau pale nigham zi timin watooŋrau pa Maaron tsiei Yoova. Tauvene yei aat niyauur zi tisov tila tomani ghei. Nila nivot nugh sindei tau Yoova ighe nileep pani ve nisuŋ, mako i tauu isaav payei pa saa gabua tau pale nigham zi timin watooŋrau pani. Gabua siriv, pale nimoz sirivu mon imin watooŋrau. Ve siriv, yav pale ighan dodolin zi.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Eemon Yoova igham kinik ŋgar tooni iyaryaaŋ muul. Tauvene loolo pa ipul yes Israela tila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ve iziir Mose ighe: “Ughau pa matag. Ve umuul ulam sene sov! Isaav ighe naghit ghom muul, yo aat umaat.” ");
INSERT INTO tuc_t_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tauvene Mose iyol aliiŋa ighe: “Poia. Saveeŋ tauta usavia na. Irau ughita naghog muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Murei ra, Yoova isaav pa Mose ighe: “Yau aat naŋgal kinik tomania eval tiina to Isip matazi pa pataŋani ite paam. Murei pa pataŋani tane, i pale iyok payam to ala. I pale iziir gham, ve ipasul gham ighe rekia ve asov ala. Irau tsiam eta ileep mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tauvene aazne, yo ula ve usaav pa Israela tisov, zitamoot ve zilivaa, tauvene: Yes aat tila tighason yes Isipa tau tileep tigharau zi na, leso tigham lezi kuaz siriv tau tigharaat zi pa gol ma silva na.” ");
INSERT INTO tuc_t_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yoova isaav tauvene pasaa, i igham yes Isipa lolozi poia pa yes Israela. Ve Mose paam, yes uraata to kinik tomania eval tiina to Isip tighita tighe i ŋeer tiina ee ve titandagh pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tauvene Mose isaav pa kinik ighe: “Ulooŋ! Yoova aliiŋa ilat payo tauvene. Ighe: ‘Mboŋ anooŋa, yau aat nazilam ve nalaagh irau taan isov to Isip. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ve natumimŋa aidabazŋa tisov pale timataar. Irau napul eta ileep mako. Ve yo tau ulepleep ila niam to ghamuuŋ pooz na, taum natum aidaaba pale imaat. Ve itaghon tauvene ila ila le yes besooŋa zilivaa tau lezi ezazi mako ve timumum wit imin palawa na natuzŋa paam. Tamtamon tisov to Isip natuzŋa aidabazŋa, tomania ŋgai toozi natŋa tau tinazŋa tipoop zi imin maata na, aat tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tauvene taŋiiz tiina pale ivot irau taan isov to Isip. Muuŋ ve ilam, taŋiiz tiina tauvene ivot izi nugh tsiam pai eta soone. Ve murei paam, irau ivot muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Eemon yes Israela tomania ŋgai toozi tisov aat tileep poi. Ŋgavuun eta irau ipaŋal mako. Leso yo uwatagh kat ughe: Yau Yoova nagham ŋgar raraate pa tamtamon tsiau Israel ve yam Isipa mako. Naghamgham ŋgar ite ite.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ve Mose isaav muul ighe: “O kinik, gabua tane ighe ivot, uraata tsio tane pale tisov tilam tiput aghezi payau, ve titaŋ rarai ghau tighe: ‘Yo tomania tamtamon tisov tau titaghon ghom na, apul ghei ve aghau ala!’ Murei pa gabua tana ivot, yau aat napul ghom.” Mose aate yavyav kat. Tauvene ipul kinik ileep, ve ivot ila muuri. ");
INSERT INTO tuc_t_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ra Yoova isaav pani ighe: “Kinik to Isip irau ilooŋ aliŋam mako. Ve ene poia. Pasaa, ighur sooso payau, leso nagham gabua ŋgeretazi naol izi Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tauvene Mose yesuru Aron tigham gabua ŋgeretazi naol ila kinik to Isip maata. Gabua tawe ite kat. Eemon Yoova igham kinik ŋgar tooni iyaryaaŋ le iyaryaaŋ kat. Tauta iyok pa yes Israela to tipul taan tooni ve tila ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mose yesuru Aron tilepleep izi taan to Isip, ve Yoova isaav pazi ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kaiyo tane, ene iliiv kaiyo tisov. Pasaa, kaiyo tane, yau aat nagham gabua paaghu ivot payam. Tauvene yam Israela aat aghur kaiyo tane imuuŋ pa ndaman tsiam tisov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Yamru ala alup Israela tisov, ve asaav pazi tauvene: Mboŋ imin saŋavul to kaiyo tane, mako zitamoot tisov aat timbit sipsip ma mekmek paghpaaghu eŋaeŋa irau ruum toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yam eŋaeŋa aat agabiiz poghania sipsip tau ambit zi na: Tamtamon piiz kat ta irau tighani le tipasovu? Isaav ighe ruum eta tamtamona naol mako, ve tigham ŋgar tighe zigazi irau tighan suvinia sipsip toozi mako, yes aat tisaav pa zetazŋa tau tileep tigharau zi na tilam ve yesŋa tilup zi pa ghanghaniiŋ. Leso tipasovu. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yam aat aghita sipsip ma mekmek zitamoot tau popoiazi mon ve ndaman toozi eŋaeŋa, o ambit zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","7","Aŋgin zi poi le mboŋ imin saŋavul ve paaŋ (14) to kaiyo tane, ve ravrav izi, saawe tau taghit sapirin ghiit, mako arav zi. Ve ruum sindei tau aleep ila na, agham gabua tau arav zi na siŋizi, ve akumu izala didiiŋaia to ataman. Ila ziige ru, ve izaa pa saaŋa paam. Leso imin ilaal pa yam tamtamon to Yoova tau alup gham pa ghanghaniiŋ ila ruum tana loolo. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“Mboŋ eemon tana, amoz sipsip tana izala yav, ve aghan tomania mberet tau le yis mako na, ve saiŋ papaii. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sipsip miiza tau ighe mbitai ma nazuuŋ, na aghani sov. Aghan moziiŋ mon. Tauvene amoz sipsip anooŋa dodoli, tomania daaba, ve ŋgoi, ve kodkooda izala yav, ve aghan suvinia. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Apul sirivu igheen imin ŋaar sov. Isaav ighe aghan le apomim isuŋ, ve sirivu igheen, mako aghuru ila yav ighan suvinia le isov o nughizau. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ve agharaat taumim pataghaaŋ pa laghooŋ. Akat nonoghiiŋa tsiam imin tuuku, aghur zuzuuŋa to aghemim, ve akis titi tsiam paam. Mako mbolemim izi pa ghanghaniiŋ. Eemon aghan rekia. Aniiŋ tana, ene aniiŋ to Pasova. Yam aat aghani, leso matamim iŋgal saawe tau yau Yoova nasal payam, ve nala narav yes Isipa natuzŋa timataar. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mboŋ tana, yau pale nalaagh irau taan isov to Isip, ve naravuur natuzŋa aidabazŋa, tomania ŋgai toozi natŋa tau tinazŋa tipoop zi imin maata na, le tisov timataar. Leso naghur atuya pa maaron karomŋa toozi, ve natatan tapirizi. Pasaa, yau Yoova nalepleep. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tauvene siŋ tau akumu ila didiiŋaia to ataman to ruum tsiam, ene pale itotoi ruum tsiam payau. Saawe tau nalaghlaagh pa ravuuŋ yes Isipa, ve naghita siŋ tana, yau aat nasal payam ve navool pa ruum ite. Leso nakari gham sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Saawe tane, ene saawe tiina ve patabuyaaŋ. Tauvene yam Israela yamŋa paaghu tsiam tau pale tivot murei na, aat apakur saawe tane, ve matamim iŋgalŋgali irau saawe. Yau naghur tutuuŋ payam tauvene: Ndaman isov, isaav ighe azaa pa saawe tane, na yam aat agham lupuuŋ tiina, ve asuŋ payau toman lolomim poia. Tutuuŋ tane pale iyaryaaŋ tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Saawe to lupuuŋ tiina tane, isaav ighe lolomim pa ghaniiŋ mberet, na aghan mberet tau tighur yis ila mako na. Yam aat aghan mberet tauvene mon irau mboŋ liim ve ru. Tauvene saawe tau lupuuŋ tiina tane ighe ivot, yam aat agham yis isov tau igheen ila ruum tsiam lolozi na, ve asiki ilale. Apul rigta igheen sov. Mboŋ liim ve ru to lupuuŋ tiina tane, isaav ighe tsiam eta izoor saveeŋ ve ighan mberet tau tikepu tomania yis, na aziire ighau ila soghan pa yam Israela. Ilup ghi tomani gham muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Saawe imin maata tau lupuuŋ tiina tane iburig, ve saawe imin liim ve ru tau isov pani, na yam Israela aat asov alam alup gham ve agham suŋuuŋ tiina. Saawe ru tana, ene umbom patabuyaaŋ. Agham uraat eta sov. Eemon aniiŋ, o yam irau agharaata. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Lupuuŋ tiina to mberet tau le yis mako na, ndaman isov, yam aat matamim iŋgali ve ataghoni. Pa saawe duduuŋ tane, ta yau nagham gham alaagh ila sosoor sosoor imin yes zaaba, ve apul taan to yes Isipa. Tauta naghur tutuuŋ ariaaŋa pa yam ve paaghu tsiam tau pale tivot murei na tauvene: Ndaman isov, yam aat matamim iŋgal saawe tane, ve alup gham ve agham suŋuuŋ tiina payau. Tutuuŋ tane aat igheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","19","“Tauvene ndaman isov, kaiyo tau ivot imin maata na, mbooŋi imin saŋavul ve paaŋ (14), ve ravrav tooni, ene saawe tau lupuuŋ tiina tane iburig, ve ila isov pa ravrav to mboŋ imin tamoot ee ve geege ee (21). Mboŋ liim ve ru tana, isaav ighe aghan mberet, na aghan mberet tau tighur yis ila mako na. Tauvene saawe tana, yis eta igheen ruum tsiam lolozi sov. Isaav ighe taumim eta, ma loom eta tau ileep ila sosomim na izoor saveeŋ, ve ighan mberet tau tikepu tomania yis ila saawe tana loolo, na aziire ighau ila soghan pa yam Israela. Ilup ghi tomani gham muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tauvene mboŋ liim ve ru tana, nugh sindei tau ighe yam aleep pani, na aghan gabua eta tau yis igheen ila na sov. Agharaat mberet tau le yis mako na mon.” ");
INSERT INTO tuc_t_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Yoova isavsaav tomania Mose le isov, ra Mose ila ve ilup zolmana tisov to Israel, ve isaav pazi ighe: “Ala rekia mon, ve apas lemim sipsip paghpaaghu irau ruum ruum, ve arav zi. Leso agharaat aniiŋ to Pasova. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Sipsip tana siŋizi, awatoa ila oon, ve agham ai ‘isop’ booga, ve azeeva ila siŋ tana. Mako akumu ila didiiŋaia to ataman tsiam. Ila ziige ru, ve izala pa saaŋa paam. Tsiam eta ivot ila muuri sov. Yam asov aleep ila ruum tsiam tsiam lolozi mon le nughizau. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Saawe tau Yoova izilam, ve ilaagh pa ravuuŋ yes Isipa natuzŋa ve gabua toozi, ighe ighita siŋ tana igheen ila didiiŋaia to ataman tsiam, i pale isal payam, ve ila ivool pa ruum ite. Irau ipul aŋela to ravuuŋ tamtamon iloŋ ilat ruum tsiam ve irav gham mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Tutuuŋ tau aazne nasavi zi payam ne, ene ariaŋazi. Pale tighengheen tauvene le alok. Tauvene yamŋa paaghu tsiam tau pale tivot murei na matamim kisin zi, ve ataghon duduŋai zi taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Saawe tau ala avot taan tau Yoova imbu saveeŋ ighe igham payam na, matamim iŋgalŋgal lupuuŋ tiina to Pasova, ve ataghon duduŋai ŋgara izi ta sewe. Apuli sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ve saawe tau natmimŋa tighason gham pa lupuuŋ tane puughu, mako apaes pazi tauvene. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Aghe: ‘Iit tarav gabua tane imin watooŋrau pa Yoova. Leso tapaiti, ve mataan iŋgal saawe to Pasova tau Yoova isal pa ruum toit izi Isip, ve ipul ghiit taleep, ve ila irav yes Isipa natuzŋa.’” Yes Israela tilooŋ saveeŋ tana, ve tiput aghezi, ve tipait Yoova eeza. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ra tila ve titaghon duduŋai tutuuŋ isov tau Yoova isavi zi pa Mose yesuru Aron na. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Yes tileep le mboŋ anooŋa, ra Yoova izilam, ve iravuur yes Isipa natuzŋa aidabazŋa tisov timataar. Ipul eta ileep mako. Kinik tau igham pooz pa taan Isip na naatu aidaaba, ve ila ila le yes tau tileep ila ruum to yavyavuuŋ loolo na natuzŋa aidabazŋa paam, tisov timataar. Ve Isipa ŋgai toozi paam. I iravuur natuzŋa tau tinazŋa tipoop zi imin maata na, le tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tauvene mboŋ tana, kinik tomania uraata tooni ve eval tiina to Isip, tiburig le tighita natuzŋa tau timaat na. Ra taŋiiz tiina iburig irau ruum ruum. Pasaa, mateegh irau ruum to yes Isipa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","32","Mboŋ tana, kinik imbaaŋ pa Mose yesuru Aron tilam tooni, ve isaav pazi ighe: “Rekia mon ve aburig apul nugh tsiau, ve aghau ala! Ve yamru mon mako. Eval tiina to Israel paam. Yam asov ayau sipsip, mekmek, ve makau tsiam, ve ala agham suŋuuŋ pa Yoova itaghon ghasoniiŋ tsiam. Apul tamtamon tsiau, ve aghau ala! Ve aghason Maaron tsiam to igham poghani ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Yes Isipa tipasul yes Israela tighe tipul nugh toozi rekia mon. Pa tigham ŋgar tauvene: “Isaav ighe yes Israela tileep tomani ghiit, ene pale tasov tamatmaat.” ");
INSERT INTO tuc_t_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ra yes Israela tigham oon toozi tau palawa igheen iloŋ ila na, ve tizunua zi pa uuli, leso tibaad zi ila avarazi. Palawa tawe, tikepu tomania yis soone. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ve titaghon Mose aliiŋa ve tighason yes Isipa pa lezi kuaz maata maata tau tigharaat zi pa gol ma silva na, ve tighason zi pa lezi nonoghiiŋa paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yoova igham yes Isipa lolozi poia pa yes Israela. Tauvene gabua isov tau yes Israela tighason zi pani, yes Isipa tigham pazi mon. Tauta yes Israela tipasov zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Tauvene yes Israela tiburig gha tipul nugh Ramses, ve tila tivot nugh ee eeza Sukot. Yes eval le eval kat. Zitamoot toozi tau tirao pa malmal, yes irau 600,000 ma vene. Ve yes zilivaa tomania natuzŋa, tinin zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Yes Israela lezi sipsip, mekmek, ve makau katini kat. Tauta tiyauur zi ve tilaagh tomani zi. Ve nugh nugh siriv tau Israela mako na tiburig tila tomani zi paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tilaagh tila le tivot nugh ee, ra timariau. Tileep ta sewe, ve tigham palawa toozi tau tigharaata izi Isip na, ve timozi gha imin lezi tamaz. Palawa tawe, ŋginaaŋa. Tikepu tomania yis mako. Pasaa, saawe tau tiburig, yes Isipa tipasul zi. Tauta lezi saawe eta to tigharaat poghania tamaz toozi mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yes Israela tileep izi Isip irau ndaman 430, ra tipul Isip ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tauvene saawe duduuŋ tau ndaman 430 tana isov, ra yes Israela tisov tiburig, gha tipul Isip ve tila. Tilaagh ila ŋgun toz toz imin yes zaaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mboŋ tawe ta Yoova maata iŋgal yes Israela, ve igham zi tipul Isip itaghon saveeŋ mbuaaŋ tooni. Tauta ndaman isov, saawe to Pasova ighe ivot, yes Israela tisov aat timamaat ve matazi iŋgal gabua tau ivot pa mboŋ tana, ve tipait Yoova. Ŋgar tane aat igheen tauvene taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yoova isaav pa Mose yesuru Aron ighe: “Ene tutuuŋ siriv tau iŋarui ghanghaniiŋ to Pasova. Nugh nugh tau ighe tilam tileep ila yam Israela sosomim na, toozi eta irau ighan sorokin aniiŋ to Pasova mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","Ve isaav ighe agham tamtamon to nugh ite imin lemim uraata, ene i paam, irau ighan sorokin aniiŋ to Pasova mako. Eemon isaav ighe aghol tamtamon to nugh eta imin lemim besooŋa ve arav waaro, ene i irau ighan. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Isaav ighe alup gham pa ghanghaniiŋ to Pasova ila ruum eta loolo, na aghan suvinia sipsip tsiam ta sena. Agham miiza sirivu rigta ivot ila muuri sov. Ve tuua tauvene paam, aŋgoor eta sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tamtamon to Israel tisov irau matazi iŋgalŋgal lupuuŋ tiina to Pasova ve titaghon duduŋai ŋgara. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Isaav ighe ŋeer eta to nugh ite ilam ileep ila sosomim, ve ighe ileep tomani gham pa ghanghaniiŋ to Pasova, na yam aat arav ŋeer tana tomania zeetŋa zitamoot tisov tau tileep ila ruum tooni na warozi. Leso aghit zi aghe yes raratezi imin yam Israela duduuŋ. Le isov o, yes irau tighan. Eemon sei tau ighe tirav waaro mako, ene irau ighan aniiŋ to Pasova mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tutuuŋ tane aat igham pooz pa yam asov. Yes tau siŋ duduuŋ to Israel, ve yes loomba tau tileep ila sosomim na paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tauvene yes Israela tisov titaghon duduŋai tutuuŋ isov tau Yoova isavia pa Mose yesuru Aron na. ");
INSERT INTO tuc_t_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ve saawe duduuŋ tana, Yoova igham zi tipul Isip. Tilaagh ila ŋgun toz toz, ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yoova isaav pa Mose muul ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Yam Israela aat aghur natmimŋa aidabazŋa tomania ŋgai tsiam natŋa tau tinazŋa tipoop zi imin maata na tisov timin yau leg.” ");
INSERT INTO tuc_t_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose isaav pa yes Israela ighe: “Matamim iŋgal saawe tane. Muuŋ, yam amin besooŋa sorok izi taan Isip. Eemon aazne, Yoova itotoi tapiri tiina, ve ipas gham ila yes Isipa nimazi gha apul nugh toozi wa. Tauta aazne amin besooŋa muul mako. Tauvene ndaman isov, saawe tane ighe ivot, na yam aghan gabua eta tau yis igheen ila na sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Matamim iŋgal kaiyo Abib tane. Pa kaiyo tane, ta yam apul taan to yes Isipa. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","6","Muuŋ, Yoova imbu saveeŋ tomania timbumimŋa ighe i pale igham taan to yes Kanaana, Hita, Amora, Hivia, ve Yebusa imin lemim. Taan tawe ŋgoreeŋa ve poia pa gabua naol titum pani. Tauvene murei, saawe tau Yoova igham gham ala avot ta sewe, na matamim iŋgal to ataghon ŋgar tauvene: Ndaman isov, ighe tazaa pa kaiyo Abib, na yam aat alup gham ve asuŋ pa Yoova. Mboŋ liim ve ru, yam aghan mberet tau le yis mako na mon. Ve mboŋ imin liim ve ru tau lupuuŋ tiina tana isov pani na, yam aat alup gham ve agham suŋuuŋ tiina, ve apait Yoova eeza toman lolomim poia. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mboŋ liim ve ru tana, ighe aghan mberet, na aghan mberet tau le yis mako. Tauvene saawe tana, yis eta igheen ila yam Israela nugh tsiam loolo sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Isaav ighe saawe to lupuuŋ tiina tane ivot, na yam eŋaeŋa apaesia puughu pa natmimŋa aghe: ‘Iit tataghon ŋgar tane, leso mataan iŋgalŋgal saawe tau Yoova igham uraat tiina pait, ve igham ghiit tapul Isip ve talam.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Lupuuŋ tiina tane pale imin ilaal tau igheen ila nimamim ve ndamomim, ve ipei mulin ŋgar tsiam pa saawe tau Yoova itotoi tapiri tiina, ve igham gham apul nugh to yes Isipa ve alam. Leso lolomim iveegh pani sov, ve avomim ibesbees pa saveeŋ tau i igham pait na irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tauvene Yoova ighur tutuuŋ payam tauvene: Ndaman isov, isaav ighe saawe to lupuuŋ tane ivot, na yam alup gham pa suŋuuŋ ve ataghon ŋgar tane.” ");
INSERT INTO tuc_t_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Mose isaav muul ighe: “Yoova pale igham gham ala avot izi taan Kanaan. Taan tawe, i ighe ipuli imin lemim motot, itaghon saveeŋ mbuaaŋ tooni ariaaŋa tau imbua tomania timbumimŋa. Saveeŋ tana iŋarui gham paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Saawe tau ala aleep izi taan tawe, yam aat ataghon ŋgar tauvene: Natmimŋa aidabazŋa, tomania ŋgai tsiam natŋa tau tinazŋa tipoop zi imin maata na, yam aat aghur zi tisov timin Yoova le. Tauvene ŋgai tsiam natŋa zitamoot tau tipoop zi imin maata na, arav zi tisov timataar imin watooŋrau pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eemon doŋki natuzŋa zitamoot tau tipoop zi imin maata na, arav zi imin watooŋrau pa Yoova sov. Ayol zi pa sipsip, ve arav sipsip tana imin watooŋrau. Ve isaav ighe ayol zi pa sipsip mako, na aŋgoor luazi gha timaat. Ve natmimŋa aidabazŋa zitamoot tauvene paam. Ayol zi tisov pa sipsip ma gabua siriv, ve agham gabua tana pa Maaron imin watooŋrau. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Murei, isaav ighe natmimŋa tighason gham pa ŋgar tane puughu, mako apaes pazi aghe: ‘Muuŋ, iit tamin besooŋa sorok izi Isip. Eemon Yoova itotoi tapiri tiina, ve igham ghiit tapul nugh tawe. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Saawe tana, kinik to yes Isipa, ŋgar tooni iyaryaaŋ kat ighe tapul nugh tooni sov. Eemon Yoova iravuur yes Isipa natuzŋa aidabazŋa tomania ŋgai toozi natuzŋa tau tinazŋa tipoop zi imin maata na, le tisov timataar. Tauta aazne, ŋgai toit natŋa zitamoot tau tipoop zi imin maata na, iit tarav zi tisov timatmaat timin watooŋrau pa Yoova. Ve natuunŋa aidabazŋa timin Yoova le paam. Eemon tarav zi imin watooŋrau mako. Tayol zi pa sipsip ma gabua siriv, ve tagham gabua tana pa Yoova imin watooŋrau. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ŋgar tane, ene imin ilaal tau igheen ila nimaan ve ndamoon ve ipei mulin ŋgar toit pa saawe tau Yoova itotoi tapiri tiina, ve igham ghiit tapul nugh to yes Isipa ve talam. Leso loloon iveegh pani sov, ve mataan iŋgalŋgali irau saawe.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Saawe tau kinik to Isip ipul yes Israela tila, Yoova imuuŋ ve itotoi eez pazi. Eemon i igham zi titaghon eez tuuku tau itaghon taan to yes Pilistia ne mako. Pasaa, igham ŋgar tauvene: “Isaav ighe yes Israela titaghon eez tuuku tawe, ve tizaa to koiazŋa rekia ve malmal iburig, ene pale titoor ŋgar toozi, ve tighau timuul tila pa Isip.” ");
INSERT INTO tuc_t_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","19","Tauta i ipamuul zi tila titaghon eez malaua tau itaghon nugh ŋginaaŋa le ila ivot Te Siŋsiŋai. Saawe tau yes Israela tipul Isip, tigharaat zi pataghaaŋ pa malmal ve tilaagh. Ve Mose igham Yosep tuua ve tilaagh tomania. Pasaa, muuŋ kat, Yosep isaav pa yes Israela timbuzŋa tauvene: “Murei, Maaron pale igham mulin gham ve apul nugh to yes Isipa. Saawe tana ighe ivot, mako agham tuag ve alaagh tomania. Leso atavia izi Kanaan.” Ve yes Israela timbu saveeŋ ariaaŋ tomania Yosep tighe yes pale titaghon ŋgar tooni tana. Tauta Mose maata iŋgal saveeŋ mbuaaŋ toozi tawe, ve itaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yes Israela tipul nugh Sukot, ve tila tivot nugh ŋginaaŋa ziige, ra timariau izi nugh ee, eeza Etam. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mataaz isov, Yoova ileep ila taitai loolo ve imuuŋ pazi, leso itotoi eez pazi. Taitai tawe malaua. Izaa ve izi. Ve mboŋ isov, i imin yav yaama tau ighan izaa ve isul, leso itotoi eez pazi. Tauvene yes irau tilaagh pa mboŋ ve mataaz. ");
INSERT INTO tuc_t_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Taitai ve yav yaama tawe tipulpul zi mako. Timuŋmuuŋ pazi pa mboŋ ve mataaz. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ra Yoova isaav pa Mose ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Usaav pa yes Israela titoor zi, ve timuul tila tivot nari to nugh Pi Airot. Nugh tawe igheen nugh Migdol ziige tau igheen ila pa te, ve igharau nugh Bal Zepon. Tila tivot, mako tigharaat niazi izi ta sewe ve timariau. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Leso kinik to Isip igham ŋgar ighe yam asosor pa eez, ve avalaghlaagh izi nugh ŋginaaŋa, ve lemim eez eta to aghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Yau aat nagham ŋgar tooni iyaryaaŋ muul, leso itaghon gham. Saawe tau i ilam peria tsiam, yau aat natotoi tapirig pani, ve natatan i tomania zaaba tooni gha tisov tilalez. Leso nagham ezag ivot imin tiina, ve yes Isipa tighilaal tighe: Yau Yoova nalepleep.” Tauvene yes Israela titaghon saveeŋ tau Yoova isavia pazi na. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Saawe tau tipaes pa kinik to Isip tighe yes Israela tighawaar tila wa, i yesŋa uraata tooni titoor ŋgar toozi muul, ve tighe: “Wai, iit tagham ŋgar to borauŋa! Tapul yes Israela tila pasaa? Aazne, savunugha pale timin besooŋa pait?” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tauvene kinik isaav, ve tigharaat hos tomania karis tooni to malmal. Ve iyau zaaba tooni to malmal, leso tila tomania. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ve igham karis ariaŋazi to malmal tomania hos irau 600, ve tigham karis tomania hos siriv paam to yes Isipa, ve yes malmala tau tilandoov karis na. Ra tomania zaaba tooni tisov tiburig gha titaghon yes Israela tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Saawe tau yes Israela tipul Isip, lolozi poia kat, ve tigham ŋgar tighe Maaron toozi iliiv yes Isipa wa. Tauvene tilaagh toman pakuruuŋ. Eemon Yoova igham kinik to Isip ŋgar tooni iyaryaaŋ muul. Tauta iyau zaaba tooni, ve titaghon yes Israela gha tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Tauvene yes zaaba to Isip tigham karis tomania hos, ve yes malmala siriv gha titaghon yes Israela tila, le tivot toozi igharau niazi to mariaoŋ tau igheen izi nari to nugh Pi Airot ve nugh Bal Zepon. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yes Israela matazi ila le tighita kinik to Isip tomania yes zaaba tooni tiŋarui zi tilam. Tauvene roiŋ tiina igham zi, ve titaŋ rarai Yoova to iuul zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ve tiŋooŋ pa Mose tighe: “Ugham ghei nipul Isip pasaa? Mindai, naal to yes Isipa irau ghei mako, tauta ugherev ghei nilam nugh ŋginaaŋa tane, leso nimatmaat izi ta sene? ");
INSERT INTO tuc_t_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ŋgar tane, ta niroi pani. Tauta saawe tau talepleep izi Isip, yei nisaav payo nighe: ‘Tambaaŋo. Upul ghei nileep, ve nigham uraat pa yes Isipa.’ Eemon yo ulooŋ ghei mako. Imin ta nileep izi Isip gha nibesbees pazi, kanaŋ poia. Eemon mako. Aazne, aat nisov nimataar izi nugh ŋginaaŋa tane.” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Eemon Mose irav motin saveeŋ toozi ighe: “Aroi sov. Ayooz ariaaŋ! Aazne, yam pale aghit katin Yoova uleeŋ tooni. Pasaa, i tauu pale ivool tsiam ve igham mulin gham. Yes Isipa tau aazne matamim ila pazi we, murei aat aghit zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tauvene atemim izi ve aghur matamim mon. Pa Yoova tauu pale iparav payam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ra Yoova isaav pa Mose ighe: “Mindai ta yo utaŋ rarai ghau ne? Usaav pa yes Israela tiburig gha tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mako uit titi tsio izaa, ve uzuzuuna ivot ila pa te. Leso te ivalagh ghi. Sirivu ila pa ŋas, ve sirivu ila pa tapir, ve ighur eez pa yes Israela, ve tilaagh ila taan mamaasa, ve tila tivool pa ziige ite. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Yau aat nagham yes Isipa ŋgar toozi iyaryaaŋ ve titaghon gham. Mako natotoi tapirig pa kinik to Isip tomania zaaba tooni tau tilaagh taan, ve yes tau tilandoov hos ve karis na, ve natatan zi le tisov kat. Leso nagham ezag ivot imin tiina, ve yes Isipa tighilaal tighe: Yau Yoova nalepleep.” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ra aŋela to Maaron tau imuŋmuuŋ pa yes Israela na, ipul niia ta muŋgaaŋ we, ve imuul ila pa murizi. Ve taitai malaua tau imuŋmuuŋ pazi na paam, imuul ila iyooz izi murizi, ");
INSERT INTO tuc_t_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ve isap yes Israela ve yes Isipa sosozi. Mboŋ izi, ve taitai tawe ighur ndoroom tiina pa yes Isipa, ve ghazooŋa ila pa yes Israela. Tauvene mboŋ tana, yes Isipa irau tila tigharau yes Israela mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","22","Ra Mose iit niima izaa, ve itotoi ila pa te, ve Yoova igham yaghur tiina ilaan pa taan ziige tau ila pa aaz izaa ve ilam. Yaghur ilaagh mboŋ mboŋ le nughizau, ve ivuvuur te le ivalagh ghi imin ru. Sirivu ila pa tapir, sirivu ila pa ŋas, ve taan mamaasa ivot. Te ziige ru tawe tiyooz duduuŋ imin didiiŋ, ve yes Israela tilaagh ila bodbodaaŋ. Tauvene tilaagh taghon taan mamaasa tawe, ve tila tivool pa ziige ite. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ra zaaba tisov to Isip tomania hos ve karis toozi titaghon zi le tilam tivot izi bodbodaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Aaz izaa rig, ve Yoova ileep ila taitai paatu malaua ve yav yaama loolo, ve maata izi pa yes Isipa, ra ikau ŋgar toozi le tivaghamgham. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ve igham hos tomania karis toozi aghezi tiptipia, leso tizuar pa landooŋ. Ve igham karis aghezi paspas ve titaptap tizizi. Tauvene yes Isipa tisaav tighe: “Ee-e, tala sov! Tamuul! Ene Yoova tauu, ta ivool to yes Israela ve iparav tomani ghiit ne.” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ra Yoova isaav pa Mose ighe: “Uit nimam izaa, ve utotoi ila pa te. Leso te ila ivool muul, ve itav yes zaaba to Isip tawe tomania karis ve hos toozi, le tisov timataar.” ");
INSERT INTO tuc_t_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","28","Tauvene aaz ipul te gha izaa rig, ra Mose iit niima muul izaa, ve itotoi ila pa te. Ra te ipol ilam ilup ghi muul. Yes Isipa tau titaghon yes Israela na, titoova to tighau timuul tila. Eemon tirao mako. Te itav zaaba to kinik tomania karis ve hos toozi, le tisov tilalez. Eta ileep mako. Eez tane, ta Yoova ipazalia zaaba tisov to Isip tizila te loolo gha timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Eemon yes Israela tilaagh ila taan mamaasa tau igheen bodbodaaŋ to te na, le tila tivool pa ziige ite. Te ziige ru tawe tiyooz duduuŋ imin didiiŋ. Sirivu ila pa tapir ve sirivu ila pa ŋas. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ene eez tau Yoova igham mulin yes Israela ila yes Isipa nimazi. Yes Isipa tau timaat na, yes Israela tighita patazi tivaghengheen taghon nari. ");
INSERT INTO tuc_t_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Onoon kat, Yoova itotoi tapiri tiina pa yes Isipa, ve yes Israela tighita pa matazi. Tauta tiroi pa Yoova, ve tighur ila tooni. Ve tighur ila to besooŋa tooni Mose paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ra Mose tomania yes Israela timbou mbouŋ tane to tipait Yoova. “Yau aat nambou to napait Yoova. I eeza tiina le tiina kat. I iparav ariaaŋ le iliiv koiŋa. I isik hos toozi tomania yes tau tilandoov zi na tizila te loolo gha tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yoova ipapalot ghau, tauvene nambou mbouŋ to napaiti. Yau irau nalaleg. Eemon i igham mulin ghau. I mon ta Maaron tsiau. Tauvene naghe napait eeza pa poia tooni. Muuŋ, tamaŋ ibesbees pani. Ve yau paam napakur eeza izala le izala kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tiina tsiau, i ŋeer ariaaŋa to malmal. I eeza Yoova. I ilepleep irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","I isik kinik to Isip zaaba tooni tomania karis toozi tisov tizila te loolo gha tilalez. Ve yes daaba tau tirau kat pa ghamuuŋ malmal na, yes paam tighun te gha tisov timataar izi Te Siŋsiŋai. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Te itav zi ve tizal tizila imin maet. Tizila kat ta mazavan belbeluuŋa loolo we. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Yoova, nimam tapir, ene tapiri tiina le tiina kat. Nimam tapir irav mbirisai koiamŋa le tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Yo ezam tiina kat. Uliiv gabua naol isov. Koiamŋa tau tiburig tighe tizoor ghom na, yo ureu mbirisai zi. Utotoi aatyavyav tsio pazi ve ivaghamun zi imin yav ighan kikiliiŋ gorgori. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Yo atem yavyav pazi kat. Tauta ugham yaghur tiina iburig ve ivalagh te. Sirivu ila pa ŋas, ve sirivu ila pa tapir. Ziige ru tawe tigud tizaa ve tiyooz duduuŋ ve imin didiiŋ. Te to mazavan iyooz le iyaryaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Koiamaiŋa tigham tinizi tighe: ‘Yei aat nigham taghon yes Israela le nikis zi. Mako niyauur saveeŋ mariŋ toozi ve nireii irau ghei. Saa pataŋani tau nighe nigham pazi, ene aat nighamu mon. Tauvene yei pale nipas mbuzaagh tsiei, ve nitotoi tapirimai pazi, ve nireu mbirisai zi.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Eemon Yoova, yo uviv avuvum imin yaghur ve ivuvuur te. Tauta itav zi le tisov tizal tizila mazavan loolo rekia mon imin maet tau pataŋani le pataŋani kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","A Yoova, saa maaron ta irau ghom? Eta mako. Yo paghunam ve patabuyaaŋ kat. Ve ugham uraat tintiina tomania gabua ŋgeretazi. Tauta tamtamon tiroi payo, ve tipait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Yo urav koiamŋa pa nimam tapir, ve ugham taan aavo ikaak, ve itoon zi tisov. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Yoova, yo lolom isaghav tamtamon tsio, ve uluul zi itaghon saveeŋ mbuaaŋ tsio. Tauta uvool toozi, ve ugham mulin zi pa pataŋani toozi. Ve yo umuuŋ ve utotoi eez pazi. Tauvene yo aat uŋgin zi pa tapirim ve ugham pooz pazi le tila tivot izi niam patabuyaaŋ to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yes nugh nugh tilooŋ uraat tsio vaaru, le tirur pani ve atezi iparav. Yes Pilistia, roiŋ tiina igham zi ve tisaŋeeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ve daaba tisov to Edom paam, tiroi tiina. Yes pooza to Moap tilooŋ varum, le tinizi irur, ve lolozi bubu. Ve yes Kanaana tapirizi isov kat ve tinizi imatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","O Yoova, yes tiwatagh: Tapirim, ene tiina kat. Tauta roiŋ tiina igham zi, ve atezi ipaparav. Yo taum ugham mulin yei Israela gha nimin lem motot. Tauvene nugh nugh tileep mon imin maet, ve timarar ghei, ve nimbut naghozi gha nila nigham taan tsiei. Irau tigham gabua eta payei mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Yoova, yo ugham ghei nilam nileep poia izi loloz tsio. Loloz tane, ene niam patabuyaaŋ to lepoogh. Pasaa, yo upayooz rumei tsio izala. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yoova, i kinik tiina kat. I pale igham pooz taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tauvene Yoova ivalagh Te Siŋsiŋai, gha sirivu ila pa ŋas ve sirivu ila pa tapir, ve yes Israela titaghon taan mamaasa tau igheen bodbodaaŋ na, ve tila tivool pa ziige ite. Eemon saawe tau zaaba to kinik tomania hos ve karis toozi titaghon zi, Yoova igham te ila ivool muul, ve itav zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aron liivu Miriam, i propet livaa ee. I igham kakaap tooni gha imuuŋ, ve zilivaa tisov to Israel anazi tigham kakaap toozi ve titaghoni, ve yesŋa tigham narogho. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ve Miriam iit mbouŋ tane pazi ighe: “Ambou ve apait Yoova. I eeza tiina le tiina kat. I iparav ariaaŋ le iliiv koiŋa. Hos toozi tomania yes tau tilandoov zi na, i ipazali zi tizila te loolo gha tilalez.” ");
INSERT INTO tuc_t_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Murei ra, Mose isaav pa yes Israela gha tiburig tilaagh muul. Tipul nari to Te Siŋsiŋai, ve tilaagh tiloŋ tila pa nugh ŋginaaŋa tau tiwaato tighe ‘Sur.’ Tilaagh izi ta sewe irau mboŋ tol, eemon tindeeŋ yaa eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ra tivot nugh marani ee, eeza Mara. Nugh tawe, yaa igheen. Eemon yaa tawe papaii. Tauvene yes Israela irau tighunu mako. Puughu tane ta tiwaat nugh tawe eeza tighe ‘Mara.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yes Israela tiburig ve tiŋooŋ pa Mose tighe: “Ai, ŋgarsuamai igorgor kat wa. Pale nighun saa?” ");
INSERT INTO tuc_t_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tauvene Mose itaŋ rarai Yoova pa uleeŋ, ve Yoova itotoi ai sirivu ee pani. Mose igham ai tawe ve isiki izila yaa, ra yaa ipapa muul mako, ve yes irau tighun. Tilepleep ta sewe, ve Yoova ighur tutuuŋ siriv pazi ve ipaghazoŋai zi pa eez to titaghoni leso tilaagh duduuŋ ila i maata. I igham tauvene to itoov zi. Leso ighita: Pale titaghon duduŋai aliiŋa, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I isaav pazi ighe: “Yau Yoova, Maaron tsiam. Alooŋ aliŋag ve ataghoni, ve agham ŋgar tau iduduuŋ mon ila yau matag. Isaav ighe aghur taliŋamim poi pa tutuuŋ tisov tau naghur zi na, ve ataghon duduŋai zi, ene yau irau naghur moroghooŋ saghati eta payam imin tau nagham pa yes Isipa ne mako. Pasaa, yau Yoova ta naghagharaat gham pa moroghooŋ tsiam gha tinimim popoia.” ");
INSERT INTO tuc_t_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ra yes Israela tilaagh tila tivot nugh Elim. Nugh tawe, le taan puura saŋavul ve ru tau yaa ivotvot pazi. Ve ai det tamoot tol saŋavul (70) titum ta sewe paam. Ai tawe anoŋazi poia pa ghaniiŋ. Tauvene tighur niazi ta sewe ve timariau. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Murei ra, yes Israela tiburig gha tipul nugh Elim, ve tilaagh tila tivot nugh ŋginaaŋa tau eeza ‘Siin.’ Nugh tawe igheen bodbodaaŋ pa Elim ve Sinai. Saawe tau tipaburigin laghooŋ toozi izi Isip ve tilam tivot izi Siin, yes tilaagh irau kaiyo ee ve mboŋ saŋavul ve liim wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tilepleep ta sewe, ve eval tiina to Israel tiŋooŋ pa Mose yesuru Aron muul tighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Imin ta Yoova irav ghei nimaat izi Isip pataghaaŋ, kanaŋ poia! Pa saawe tau nileep izi sewe, lepoogh tsiei poia kat. Nidaag ghei nilepleep, ve nighanghan aniiŋ tiina tomania ziigha le apomai isuŋ. Mindai, yamru aghe arav ghei nimatmaat pa pitool, tauta agherev ghei nilam nugh ta ŋginaaŋa ne?” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tauvene Yoova isaav pa Mose ighe: “Aazne ve ila, yau aat nagham aniiŋ itap sambam ve izilat payam. Mboŋoozo ta naol ne, pale itap sambam ve izilat. Tauvene isaav ighe yam ala ayau lemim, na ayau tiina sov. Ayau irau to aghan pa aaz eemon. Yau nagham tauvene to natoov gham. Leso naghita: Pale ataghon aliŋag, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Isaav ighe uraat imin liim ve ee, na ayau tiina rig, irau aghan pa mataaz ru, ve anazu pataghaaŋ ve igheen.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","7","Tauvene Mose yesuru Aron tisaav pa tamtamon tisov to Israel tighe: “Yei nigham saa, ta atemim yavyav ve ayau avomim payei? Yei nisaav ta talam ne? Yam aŋooŋ payei, eemon Yoova ilooŋ ŋoŋaaŋ tsiam wa. Tauvene ravrav izi, mako i igham ŋgar eta payam. Leso awatagh kat aghe i tauu, ta igham gham apul Isip ve alam sene. Ve nughizau, o itotoi tapiri ve poia tooni payam, ve aghita pa taumim matamim.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ra Mose isaav pazi muul ighe: “Yei sei, ta aŋooŋ payei? Saawe tau ayau avomim payei na, yam aŋooŋ payei mako. Aŋooŋ pa Yoova. Ve ŋoŋaaŋ tsiam tana, i ilooŋa wa. Tauvene ravrav izi, o i tauu pale igham lemim man to aghan. Ve mboŋoozo, mako igham lemim aniiŋ, leso aghan ve apomim isuŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ra Mose isaav pa Aron ighe: “Ula usaav pa yes Israela tauvene: ‘Yoova ilooŋ ŋoŋaaŋ tsiam wa. Tauvene yam asov alam alup gham ila Yoova naagho.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aron isavsaav pa eval tiina to Israel, ve matazi ila pa nugh ŋginaaŋa, le tighita Yoova mbonari isul ila taitai loolo. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ra Yoova isaav pa Mose ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ŋoŋaaŋ to yes Israela, yau nalooŋa wa. Tauvene usaav pazi: Ravrav aaz izila goroŋia, o lezi aniiŋ ziigha izilat. Ve bogzo pale aniiŋ izilat, ve tighan le apozi isuŋ. Leso tiwatagh kat tauvene: Yau Yoova, Maaron tsiam, nalepleep.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Yes Israela tileep le ravrav izi, ra man katini tivot le nugh tau tileep pani na ivon. Mboŋ le nughizau, ve uwam izi irau nugh tau tileep pani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Uwam imamaas, ve yes Israela tighita gabua pisosooŋa itav nugh toozi le ivool. Ghitooŋa imin iigh anavu. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tighita gabua tawe, ve tikankaan pani. Tauvene tivaghasoni zi tighe: “Ene saa?” Mose isaav pazi ighe: “Ene aniiŋ tau Yoova igham payam pa ghaniiŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ve i ighur tutuuŋ payam tauvene: Tamtamon piiz tau tilup zi ila balbaal eemon, na tipavon uur geegeu eŋaeŋa le irau zi. Atezi ipas pa yauŋ aniiŋ sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Tauvene yes Israela tila, ve tiyau lezi aniiŋ. Siriv tiyau tiina, ve siriv tiyau ŋgiira. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Eemon saawe tau titoov aniiŋ ve tighita piiz tau tiyauu, tighita yes tisov lezi aniiŋ irau zi. Tauvene yes tau tiyau tiina na, tighan le tipasovu. Avozi muuri rigta igheen mako. Ve yes tau tiyau ŋgiira mon na, tauvene paam. Timbool mako. Tighan le apozi isuŋ. Tauvene aniiŋ tau tiyau zi na, ene irau zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose isaav pazi ighe: “Aniiŋ tane, aghani le isov. Aghur siriv imin ŋaar pa bogzo sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Eemon tamtamon siriv tizoor Mose aliiŋa, ve tighur aniiŋ siriv imin ŋaar. Ŋaar toozi tawe igheen le nughizau, ve iŋaraaŋ. Ve tighita motmoot igheen ila. Mose ighita ŋgar tau tighamu na, le aate yavyav kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tauvene mboŋoozo ta naol ne, yes Israela tilala ve tiyauyau lezi aniiŋ irau zi. Ve aniiŋ sirivu tau tipuli izi igheen ila taan na, saawe tau aaz izalam gha nugh ituntun, ene ireer gha ilale. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ve uraat imin liim ve ee, ene tiyau aniiŋ irau to tighan pa mataaz ru. Tauvene ŋginiiŋa to yes Israela tila tighita Mose, ve tipaesia gabua tana pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","I isaav pazi ighe: “Alooŋ. Yoova isaav tauvene: Bogzo, ene umbom patabuyaaŋ. Tauvene iit aat tamariau. Irau tagham uraat eta mako. Tauvene aazne, yam aat atartar pa lemim aniiŋ pataghaaŋ. Isaav ighe anazu, ma amozi, ene igheen to taumim. Aghan sirivu aazne, ve sirivu igheen pa bogzo.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tauvene yes Israela titaghon Mose aliiŋa, ve tighur aniiŋ toozi sirivu imin ŋaar. Mboŋ le nughizau, ra tighita ŋaar toozi tawe poia. Iŋaraaŋ mako, ve motmoot igheen ila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose isaav pazi ighe: “Aazne, yam irau aghita aniiŋ eta igheen izala taan paavo mako. Pasaa, ene umbom patabuyaaŋ tau Yoova ighuru pait leso tamariau. Tauvene ŋaar tsiam tau noor aghuru na, ene aghani. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Uraat imin ee, ila imuul uraat imin liim ve ee, aniiŋ pale ivotvot tauvene, leso ayau lemim. Eemon saawe imin liim ve ru, ene aat mako. Pasaa, ene umbom patabuyaaŋ tau Yoova ighuru pait, leso tamariau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Eemon tamtamon siriv tizoor Mose aliiŋa. Saawe imin liim ve ru tau umbom patabuyaaŋ na, yes tila tighe tiyau lezi aniiŋ. Eemon matazi ines le mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tauvene Yoova isaav pa Mose ighe: “Yam taliŋamim mako? Pale ŋeez o apul ŋgar tsiam to zoraaŋ saveeŋ, ve ataghon duduŋai saveeŋ tsiau tomania tutuuŋ tsiau? ");
INSERT INTO tuc_t_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Aghita. Yau naghur umbom patabuyaaŋ payam, leso imin lemim saawe to mariaoŋ. Tauvene wik ta naol ne, isaav ighe uraat imin liim ve ee, ene yau aat nagham lemim aniiŋ tau irao pa mataaz ru pataghaaŋ. Ve saawe tau imin liim ve ru na, yam asov aat aleep mon ila niamim. Ala nugh eta sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tauta saawe imin liim ve ru, yes Israela titaghon Maaron aliiŋa tana, ve timariau. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Aniiŋ tau Yoova igham pa yes Israela na, tiwaat eeza tighe ‘manna.’ Aniiŋ manna, ene pisosooŋa ve ghitooŋa imin gabua siriv uvezi. Ve ghaniiŋa poia kat, imin palawa tau tikepu tomania tok suuru. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose isaav pa yes Israela muul ighe: “Yoova isaav ariaaŋ pait ighe tagham uur ee, ve tapavoni pa aniiŋ manna tane, ve takisi igheen. Leso imin maatmur pa paaghu toit tau murei pale tivot na. Ighe tighita, yes pale tiwatagh: Saawe tau Yoova igham timbuzŋa tipul Isip ve tilaghlaagh izi nugh ŋginaaŋa na, i ipanpan zi pa aniiŋ tauvene.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Tauvene Mose isaav pa Aron ighe: “Ugham uur eta, ve ula upavoni pa aniiŋ manna. Le isov o, ughuru igheen izi Yoova naagho. Leso takisi igheen tauvene taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tauvene Aron itaghon saveeŋ tana, ve ighur manna siriv ila uur, ve tighuru igheen izi Bokis to Saveeŋ Mbuaaŋ imin maatmur. ");
INSERT INTO tuc_t_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Yes Israela tighanghan aniiŋ manna irau ndaman tamoot ru. Tileep ila manna mon le irau tila tivot taan Kanaan ziige. Ra aniiŋ tana izi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ra eval tiina to Israel tipaburigin laghooŋ toozi muul. Tipul nugh ŋginaaŋa tau eeza ‘Siin’ na, ve tilaghlaagh itaghon Yoova aliiŋa. Tighamgham tauvene le tila tivot nugh ee, eeza Repidim. Ra timariau izi ta sewe. Eemon nugh tawe, le yaa mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tauvene tiŋooŋ pa Mose tighe: “Ughita lemai yaa gha nighun lak!” Mose iyol aliŋazi ighe: “Puughu mindai ta atemim yavyav ve aŋooŋ payau ne? Yam aghe atoov Yoova tapiri?” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Eemon Israela murun zi le tisaghat kat. Tauvene tiyau avozi pa Mose tighe: “Puughu mindai ta ugham ghei nipul Isip, ve ugherev ghei nilam nugh tane? Ughe yei tomania natmaiŋa ve ŋgai tsiei nisov nimatmaat pa yaa ta sene?” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tauvene Mose itaŋ rarai Yoova ighe: “O Yoova, ughita. Paita tamtamon tane tirav ghau pa maet! Pale nagham mindai pazi?” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","6","Yoova iyol Mose aliiŋa ighe: “Ugham zolmana siriv to yes Israela, ve yamŋa amuuŋ alam tsiau izi loloz Sinai puughu. Saawe tau ulam na, matam iŋgal titi tsio tau ulos yaa Nil pani na, ve ukisi. Yau aat naleep izala maet tiina ee paavo, ve nasaŋan gham. Yam alam avot, mako ugham titi tsio, ve ulos maet tau nalepleep izala na. Yaa pale ireer ivot pani, leso eval tiina to Israel tighun.” Tauvene Mose igham zolman siriv gha yesŋa tila, ve tighita Mose ilos maet tiina tawe pa titi tooni itaghon Yoova aliiŋa, ve yaa ireer ivot. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Nugh tawe, Mose iwaat eeza ighe ‘Masa’ ve ‘Meriba.’ Pasaa, saawe tau yes Israela tileep ta sewe, tiŋooŋ pani, ve titoov Yoova tighe: “I ileep tomani ghiit onoon, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yes Israela tilepleep izi nugh Repidim, ve yes Amaleka tilam tighe tiparav tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tauvene Mose isaav pa Yosua ighe: “Uvureer tamtamon toit siriv tau tirao pa malmal, ve yamŋa agharaat gham. Leso bogzo ala aparav tomania yes Amaleka. Yau aat nakis titi to Maaron, ve nazala nayooz izala nugh mbua tawe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tauvene Yosua itaghon Mose aliiŋa, ve igham yes Israela gha tila tiparav tomania yes Amaleka. Ve Mose yesuru Aron ve ŋeer ite, eeza Hur, yes tol tizala tiyooz ila nugh mbua. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Saawe tau Mose niima izaa, mako yes Israela tiliiv yes Amaleka. Eemon saawe tau niima ipaspas gha izi, mako yes Amaleka anazi tiliiv yes Israela. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose niima izaa ila ila le niima ipaspas kat. Tauvene Aron yesuru Hur tighita maet ee, ve tighur Mose mboole izala. Ra tiit niima ru izaa, ve ee ipalot niima tapir, ve ite ipalot ŋas. Tipaloti tuŋia, ve niima izazaa tauvene vene le aaz izila. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tauta Yosua yesŋa yes Israela tiparav ariaaŋ pa mbuzaagh toozi, le tiliiv yes Amaleka. ");
INSERT INTO tuc_t_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ra Yoova isaav pa Mose ighe: “Ulooŋ. Murei, yau aat napasov yes Amaleka pa taan le irau tamtamon matazi iŋgal zi muul mako. Aliŋag tane, uboode ila rau. Leso yes Israela matazi iŋgalŋgali taghon taghon gha ila. Ve usaav ariaaŋ pa Yosua, leso maata kisini paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Yoova isavsaav le isov, ra Mose igharaat artaal ee, ve iwaat eeza ighe: ‘Yoova, i pilak tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ve Mose isaav muul ighe: “Yes Amaleka tigham tinizi ve titotoi nimazi pa Yoova. Tauvene i tauu pale iparav tomani zi taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mose raawa Yetro, i ŋeer tau ighamgham uratoi watooŋrau to yes Midiana. I ileep izi nugh tooni, ve ilooŋ Mose yesŋa tamtamon tooni Israela varuzi pa uraat tintiina naol tau Maaron igham pazi, ve eez tau Yoova igham zi tipul taan to yes Isipa. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Tauvene ighe ila ighita Mose. Saawe tana, Mose azaawa Sipora toman natŋa ru tilepleep tomania Yetro. Pasaa, Mose ighur zi tila tileep tomania alok rig wa. Tauvene saawe tau Yetro iburig ila pa ghitooŋ raawa, i igham zi ve yesŋa tila. Mose natŋa ru. Ee eeza Gersom, ve ite eeza Eliezer. Ezazi tane, lezi pughuzi. Saawe tau naatu aidaaba izi, Mose isaav ighe: “Muuŋ, naleep imin loom tau ipul tauu nugh tooni.” Tauvene iwaat naatu olman eeza Gersom. Ve saawe tau tipoop natuzi ite, Mose isaav ighe: “Maaron to tamaŋ iuul ghau ve ipaghau ghau pa kinik to Isip mbuzaagh tooni maata.” Tauta iwaat naatu muria eeza Eliezer. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Tauvene Yetro igham Mose azaawa tomania natŋa ru, ve yesŋa tila tivot to Mose izi nugh ŋginaaŋa tau igharau Maaron loloz tooni. Saawe tana, yes Israela timariau ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetro imbaaŋ ila pa raawa Mose ighe: “Yau nagham azuwam tomania natumŋa ru, ve yeŋa nilam nivot wa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose ilooŋ saveeŋ tane, ve iburig gha ila ighe ighita raawa. Ila ivot toozi, ve iput aaghe pa Yetro. Ra iburig iyooz ve iyaŋin pani, ve tivaghasoni zi pa lepoghazi. Le isov, ra Mose igham zi gha tila pa balbaal tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose ipaes pani pa pataŋani naol tau Yoova ighuru pa kinik tomania eval tiina to Isip, imin uleeŋ yes Israela. Ve ipaes pani paam pa pataŋani naol tau ivotvot pazi izi eez livuugha, ve eez tau Yoova igham mulin zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro ilooŋ saveeŋ tooni, le loolo poia kat pa ŋgar popoia naol tau Yoova ighamgham pa yes Israela, ve eez tau igham mulin zi ila yes Isipa nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","11","Tauvene isaav pa Mose ighe: “Yau napait Yoova pa poia tooni! Muuŋ, saawe tau yam aleep ila kinik to Isip tomania tamtamon tooni sambazi, yes titatan gham ve tigham saghatin gham kat. Eemon Yoova igham mulin gham ila nimazi wa. Tauvene aazne, yau naghilaal kat naghe: Yoova, i iliiv zimaronŋa tisov!” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ra Mose raawa Yetro igham gabua siriv, ve irav zi timin watooŋrau pa Maaron. I indav dodolin ee, ve imoz siriv, leso tamtamon tighan ve yesŋa Maaron tivalupu zi timin eemon. Tauvene Yetro, Mose ve Aron tomania zolmana to Israela, tisov tilup zi ila Maaron naagho pa suŋuuŋ toman ghanghaniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mboŋ nughizau, ra Mose ipaburigin uraat tooni to gharatooŋ pataŋani to tamtamon. Eval tiina tiyozyooz livutini, ve tisasaŋani pa gharatooŋ saveeŋ toozi mboŋoozo ila le ravrav izi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yetro ighita uraat tau raawa Mose ighamghamu to iuul yes Israela, ene tiina kat. Tauvene isaav pani ighe: “Wai, yo ugham saa uraat pa yes tamtamon tane? Mindai ta zigom ugharaat saveeŋ toozi? Ughita. Eval tiina tane tiyozyooz livutin ghom, ve tisasaŋan mboŋoozo le ravrav izi.” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose iyol aliiŋa ighe: “Tamtamon tighe tiwatagh ŋgar tau Maaron loolo pani, tauta tilam tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ve isaav ighe tivazorai zi pa saveeŋ eta, ene tilam tsiau, leso nalooŋ pataŋani toozi ve nagharaata. Ve yau leg uraat to napaghazoŋai zi pa saveeŋ to Maaron ve tutuuŋ tooni paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tauvene raawa Yetro isaav pani ighe: “Ene poia. Eemon naghita eez tau yo utaghoni pa uraat tsio, ene pataŋani. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Pasaa, uraat tane, tiina kat. Zigom aat urao mako. Pale unoknoki tauvene le tapirim isov. Ve tamtamon paam, pale tisaŋan tisaŋan le saŋaniiŋ isooŋ zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","“Ulooŋ. Yau naghe nauul ghom pa ŋgar siriv, leso uraat tane iraurau payo. Eez tau naghe nasavia payo ne, isaav ighe utaghoni, ene pale Maaron ileep tomani ghom, ve iuul ghom pa uraat tsio. Aiyo, isaav ighe tamtamon siriv tivazorai zi pa gabua eta, yo aat ugham naghozi, ve usavia pataŋani toozi ila pa Maaron. Ve saa saveeŋ tau ighe i isavia payo na, yo upaesia pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ve yo aat upaghazoŋai zi pa saveeŋ to Maaron ve tutuuŋ tooni. Ve upaduduuŋ zi, leso laghooŋ toozi poia ila Maaron maata, ve titaghon ŋgar tau Maaron ighe tighamu. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ve yo aat ugabiiz poghania tamtamon tisov to Israel, ve uvureer tamtamon popoiazi siriv, leso tiuul ghom pa uraat to ŋginiiŋ eval tiina tane. Yes tau avozi karom, ma matazi aniiŋ na, ughur zi sov. Ughita yes tau avozi onoon, ve tiroi pa Maaron ve titaghon ŋgar tooni, o ughur zi to tiuul ghom pa uraat. Ughur siriv to tiŋgin tamtamon ndiŋndiŋ ndiŋndiŋ ee (1,000), siriv to tiŋgin ndiŋndiŋ ee (100), siriv to tiŋgin tamoot ru saŋavul (50), ve siriv to tiŋgin tamtamon saŋavul mon. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Uraat to gharatooŋ saveeŋ ve pataŋani to tamtamon, ene pale imin daaba tisov tana lezi uraat. Yes pale tigharaat saveeŋ raurauai, leso tiuul ghom pa uraat tane, ve iraurau payo. Eemon saveeŋ pataŋani, ene yes aat tipuli ilat yo nimam, leso taum ugharaata. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ŋgar tane, Maaron ighe yo utaghoni. Isaav ighe ugham tauvene, ene aat uraat ipataŋan payo geeg mako. Ve tamtamon tisov tau tilam tomania pataŋani toozi na, pale timuul tila pa niazi toman lolozi poia.” ");
INSERT INTO tuc_t_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose ilooŋ raawa aliiŋa, ve itaghon ŋgar isov tau i isavia na. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","I igabiiz tamtamon tisov to yes Israela, ve ivureer yes tau lezi ŋgar popoia ve tirau uraat to ghamuuŋ pooz na, ve ighur zi timin daaba, leso tiuule pa uraat to gharatooŋ saveeŋ. Siriv tiŋgin tamtamon ndiŋndiŋ ndiŋndiŋ ee (1,000), siriv tiŋgin ndiŋndiŋ ee (100), siriv tiŋgin tamoot ru saŋavul (50), ve siriv tiŋgin tamtamon saŋavul mon. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tauvene mataaz ta naol ne, yes tiloŋlooŋ saveeŋ to tamtamon, ve tighagharaat pataŋani toozi ŋgiira ŋgiira. Eemon pataŋani tintiina, ene tipul zi ila Mose niima, leso tauu igharaat zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yetro ileep rig tomania Mose, ra Mose ighuru imuul ila pa nugh tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Yes Israela tiburig muul gha tipul nugh Repidim, ve tilaagh tila tivot nugh ŋginaaŋa Sinai. Laghooŋ toozi tau tipul Isip ve tilam na, igham kaiyo ru wa. Ve ite imin tol pani, mbooŋi imin maata, ra tila tivot loloz Sinai puughu, ve timariau izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose ipul zi tileep, ve izala pa loloz, leso yesuru Maaron tisavsaav. Yoova ileep loloz daaba, ve iboob izila pani ighe: “Usaav pa yes Israela tau paaghu to Yakop na tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ŋgar tau yau nagham pa yes Isipa na, yam Israela aghita pa taumim matamim wa. Yam awatagh: Yau nabaad gham imin manbog ibaad natŋa izala baage, ve nagham gham alam avot tsiau izi ta sene. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Aazne, isaav ighe yam alooŋ aliŋag, ve matamim iŋgal saveeŋ mbuaaŋ tsiau, ve ataghon duduŋai ŋgara, ene pale amin leg kat, ve itiŋa tavalupu ghiit tamin eemon. Onoon, taan isov tomania tamtamona, ene yau tsiau mon. Ve yam o, taug nasiigh gham, ve nagham gham amin leg motot. Yau naghe yam asov aleep ila pooz tsiau saamba, ve abees payau imin zeran to watooŋrau. Leso amin tamtamon tsiau patabuyaaŋa.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yoova isavsaav le isov, ra Mose imuul izila to yes Israela. Ila ivot toozi, ve ipoi zolmana toozi tilam tilup zi, ve ipaesia Yoova aliiŋa isov tana pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Yes tilooŋ saveeŋ tooni, ve tisov tilup avozi tighe: “Poia, saveeŋ isov tau Yoova isavia na, yei aat nitaghoni.” Tauvene Mose imuul izala to Yoova, ve ipaesia yokiiŋ toozi pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yoova isaav pani ighe: “Ulooŋ! Yau aat naleep ila taitai gabgabuai loolo ve nalat tsio, ve nasavsaav tomani ghom ve eval tiina tilooŋa. Leso tighur ila saveeŋ tsio ve titaghoni irau saawe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Mose ipaesia yes Israela aliŋazi pa Yoova le isov, ve Yoova isaav pani ighe: “Umuul uzila, ve usaav pazi tauvene: Aazne ve bogzo, yes aat timin oliŋazi, ve tigharaat zi gha leso tiŋgalaaŋ ila yau Yoova matag, ve tisaŋan. Pa ezau, mako yes Israela tisov tighit ghau nazilam ve naleep izala loloz Sinai daaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Tauvene ughur bubuaaŋ ilivutin loloz puughu, leso tamtamon tileep soghan. Ve usaav ariaaŋ pazi leso tizala loloz sov, ve titut loloz puughu rigta sov. Isaav ighe tamtamon eta ilaagh ila le ivaghaaz loloz puughu, na aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ve eez to ravuuŋ, ene aravu pa nimamim sov. Aleep soghan, ve aravu pa maet, ma avaneghi. Tauvene isaav ighe tamtamon eta, ma ŋgai eta itut loloz puughu, ene irau ileep mako. Yam aat aravu imaat. Saveeŋ tane pale iyooz tauvene le irau alooŋ tavuur itaŋ le malau, mako yam irau azala loloz.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Yoova isavsaav le isov, ra Mose ipul loloz daaba, ve imuul izila to yes Israela, ve isaav pazi ighe timin nonoghiiŋa toozi ve tigharaat tauzi poi, gha leso tiŋgalaaŋ ila Yoova maata, ve tisaŋan. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ve ipaes pazi ighe: “Aazne ve bogzo, yam aat agharaat taumim ve asaŋan. Agheen tomania zilivaa sov. Pa ezau, mako Yoova izilam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tilepleep le mboŋ ru isov, ve mboŋoozo, ra taitai gabgabuai ilam itav loloz daaba. Ve nugh ighani milmilia, ve lalaav guruŋguruŋia. Ve gabua ee itaŋ imin tavuur, eemon luutu tiina kat. Tauvene yes Israela tisov tiroi le tapirizi isov. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose igham zi tipul nugh toozi to lepoogh, ve tila tiyooz tigharau loloz puughu, leso yesŋa Maaron tilup zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","19","Ra Yoova izilam tomania yav tiina izala loloz Sinai daaba, ve mbuas tiina ikau loloz le tighita muul mako. Ve yogyoog tiina itok le loloz ilala ilamlam. Ve gabua tau itaŋtaŋ imin tavuur na, itaŋtaŋ ve izurzuur ilam ilam le luutu ivot imin tiina kat. Ra Mose isavsaav tomania Maaron. Ve saawe tau Maaron iyol saveeŋ tooni, aliiŋa imin lalaav luutu. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Tauvene Yoova izilam ileep izala loloz Sinai daaba, ve ipoi Mose ighe izala tooni ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Tauvene Mose izala tooni, ve Yoova isaav pani ighe: “Umuul uzila, ve uveveen eval tiina tawe tauvene: Tizoornugh to tizalam tighit ghau sov. Pa ighe tizalam, ene pale tamtamon katini timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Yes zeran to watooŋrau paam. Isaav ighe lolozi tighe tilam tigharau ghau, ene yes aat tigharaat tauzi le tiŋgalaaŋ kat. Le isov o, tilam tivot tsiau. Ighe tigharaat tauzi poi mako, ene pale ateg yavyav pazi, ve narav zi tilalez.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose isaav pa Yoova ighe: “Tamtamon eta irau izalam loloz tane mako. Pasaa, yo taum usaav ariaaŋ payei ughe nighur bubuaaŋ ilivutin loloz puughu, leso tamtamon tighita loloz tane imin nugh patabuaaŋ ve tiroron pani.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yoova isaav pani muul ighe: “Poia. Umuul uzila ugham togham Aron, ve yamru mon azalam. Eemon yes zeran to watooŋrau tomania eval tiina to Israel tizoornugh to tizalam tighit ghau sov. Ighe tizalam, ene pale ateg yavyav pazi, ve narav zi tilalez.” ");
INSERT INTO tuc_t_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Yoova isavsaav le isov, ra Mose imuul izila, ve ipaesia aliiŋa pa yes Israela. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Maaron isavia saveeŋ isov tane iŋarui yes Israela eŋaeŋa ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yau Yoova, Maaron tsio. Muuŋ, yo umin besooŋa sorok izi taan to Isip. Eemon yau nagham mulin ghom, tauta upul nugh to pataŋani tawe. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Yo aat ubees pa yau zigau. Ughur maaron ite paam imuuŋ payau ve ubees pani sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ve ugharaat gabua eta ve ughuru imin Maaron payo sov. Saa gabua tau tileep sambam, taan, ma te loolo na, ugharaat eta naagho, ve ughuru imin maaron payo, ve ubees pani sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","6","Uput aghem pa gabua eta tauvene ve ubees pani sov. Pa yau Yoova mon, ta Maaron tsio. Matag pariuriu. Naghe tamtamon tsiau tibees pa yau zigau mon. Yes tau tighur koi payau, ene pale matag kisin sosor toozi, ve naghur atuya izaa to yes tauzi, tomania natuzŋa, timbuzŋa, ve gabazŋa. Eemon yes tau tighur lolozi payau ve titataghon tutuuŋ tsiau, ene pale lolog isaghav zi tomania paaghu toozi, ve poia tsiau izazaa toozi, taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Yau Yoova, Maaron tsio. Uwaat sorokin ezag sov. Pa tamtamon tau ighe iwaat sorokin ezag, ma ipariaaŋ saveeŋ karom ila yau ezag, ene irau naghurghuru mako. Yau aat naghur atuya iŋaruini pa sosor tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Matam iŋgal umbom to Maaron ve upatab pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","10","Tauvene uraat imin ee, ila imuul uraat imin liim ve ee, ene saawe to ugham uraat tsio. Ve saawe imin liim ve ru, na yo aat upul uraat tsio naol isov igheen, ve upatab pani. Pa ene umbom patabuyaaŋ to Yoova, Maaron tsio. Tauvene yo tomania natumŋa, besooŋa tsio, ŋgai tsio, ve yes loomba tau tileep tomani ghom na paam, yam asov aat apul uraat tsiam isov ighenaar, ve amariau. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pasaa, saawe tau yau Yoova naghur sambam, taan, ve te, tomania gabua naol isov, nagham uraat irau mboŋ liim ve ee mon, ve napasovuur uraat tana. Ve saawe tau imin liim ve ru na, yau namariau. Tauta napakur saawe tana, ve naghuru imin umbom patabuyaaŋ, ve naghur poia tsiau igheen izala. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Matam loŋloŋai pa tamam gha tinam, ve utandagh pazi. Leso uleep malau izi taan tau yau Yoova, Maaron tsio, pale nagham payo. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Urav tamtamon imaat sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Ughur boog sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Uum sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Upariaaŋ saveeŋ karom to uvaghamunia etam ite sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Lolom ighaar pa zetamŋa ruum toozi sov. “Ve lolom ighaar pa azuwazŋa, besooŋa, ŋgai, ma gabua toozi ite paam sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yes Israela tilooŋ lalaav luutu, ve tighita nugh ighani milmilia, ve tilooŋ gabua tau itaŋtaŋ imin tavuur na, ve tighita yav mbuasa gabgabuai ikau loloz, le tiroi ve tinizi irur. Tauvene tiyooz soghan pa loloz puughu, ");
INSERT INTO tuc_t_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ve tisaav pa Mose tighe: “Yo aat ugham Maaron aavo, ve upaesia aliiŋa payei. Pa yei niroi. Isaav ighe i tauu isavsaav tomani ghei, ene pale nisov nimataar!” ");
INSERT INTO tuc_t_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose isaav pazi ighe: “Aroi sov. Aazne, Maaron izilam itaghon eez tane, to itotoi tapiri payam leso awatagh katini ve aroi pani, ve agham sosor muul sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tauvene eval tiina to Israel tiyooz soghan pa loloz puughu, ve Mose zigani imuul izala, le ila igharau taitai gabgabuai tau Maaron ileep ila na. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ra Yoova isaav pa Mose ighe ipaesia aliiŋa pa yes Israela tauvene: “Yam taumim aghita wa. Yau naleep sambam, ve aliŋag izilat payam. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Abees payau mon. Alup ghau tomania maaron karom eta sov. Tauvene agharaat maaron karom eta pa silva ma gol ve abees pani sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Yam aat andou taan, ve agharaata imin artaal payau, leso agham watooŋrau tsiam izala. Sipsip ve makau tsiam tau arav zi timin watooŋrau na, aghur siriv tizala yav leso yav ighan dodolin zi. Ve siriv, amoz zi ve taumim aghan zi to itiŋa tavalupu ghiit tamin eemon. Nugh sindei tau ighe yau naghuru payam to imin lemim suŋuuŋ niia, yam aat alup gham pa suŋuuŋ ve apait ezag izi ta sewe. Leso matamim iŋgal ghau, ve nalam naleep tomani gham, ve naghur poia tsiau izaa tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ve isaav ighe andou maet imin artaal payau na, ayau maet tau dodoli mon. Maet tau ighe agharaata ve asap ziige na, aghamu pa artaal tsiau sov. Maet tauvene, ene poia pa artaal mako. Pasaa, ene nugh patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Isaav ighe agharaat artaal eta, na izala geeg sov. Pa ighe ataghon ndeet azala, ene pale tighita mbolemim.” ");
INSERT INTO tuc_t_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Maaron iseeŋ saveeŋ tooni muul ighe: “Ene tutuuŋ siriv tau naghe usavia pa yes Israela. Leso ipaduduuŋ zi pa saa ŋgar tau pale titaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Isaav ighe ughol Hibru tamazi eta imin lem besooŋa, i pale ibees payo irau ndaman liim ve ee. Ve isaav ighe ndaman imin liim ve ru, na yo aat upuli ila. Ve upoi pa lem atuya sov. Pa uraat tooni, tauta iyol mulin maet tau papazoge yo upuli pa gholiiŋni. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Isaav ighe muuŋ i ivai mako, ve yo ugholi imin lem, na saawe tau ighe upuli ila, yo aat upul zigani ila. Ve isaav ighe muuŋ i ivai, ve yo ughol yesuru azaawa timin lem, na yo aat upul yesuru tila. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ve isaav ighe besooŋa eta daaba tooni igham livaa eta pani imin azaawa, ve livaa tana ipoop, saawe tau ighe besooŋa tamoot uraat tooni isov, ene aat zigani ila. Azaawa tomania natŋa pale tileep tomania daaba tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Eemon isaav ighe besooŋa tana isaav ghazooŋa ighe: “Yau lolog igheen to daaba tsiau, azuwag, ve natugŋa. Irau napul zi tileep ve zigau nala mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ene pale daaba tooni ighamu gha yesuru tila tivot Maaron naagho ila nugh tau tisuŋsuŋ pani na, ve ipaak besooŋa tana taliiŋa ila ataman, ma didiiŋaia to ataman ziige. Mako igham kiruuŋ, ve irav purusai taliiŋa. Leso imin ilaal pani ighe murei, i irau ipul uraat mako. Pale ileep tomania daaba tooni, le irau saawe tooni to mateegh. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Isaav ighe tamoot eta igholia natliva ila pa ŋeer ite to imin besooŋa pani, ene livaa tawe aat ileep tomania ŋeer tana. Isaav ighe murei daaba tooni ighe ipuli ila, ene irau itaghon ŋgar tau tighamgham pa yes besooŋa zitamoot ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Isaav ighe ŋeer tau igham livaa tana imin le na, loolo pani muul mako, ene i irau isakia gholiaaŋni ila nugh ite paam mako. I aat igholia imuul ila pa livaa tana tauu siŋ tooni. Pa saveeŋ mbuaaŋ tooni tomania livaa tana, i itaghoni mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Isaav ighe ŋeer tawe igham livaa tana pa naatu eta, i aat igham poghania imin ta i tauu natliva. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ve isaav ighe ŋeer tawe ivai livaa tana, ve murei ivai livaa ite paam, i aat maata iŋgalŋgal livaa tau ighamu imin maata na pa le aniiŋ, ve oliiŋa, ve yesuru tiluplup zi pa ghenooŋ paam. Ipuli ileep sorok sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Isaav ighe i itaghon ŋgar tol tane mako, i aat ipul livaa tana ila. Ve irau ipoi pa le atuya mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Isaav ighe tamtamon eta irav iitete imaat, na yam aat aravu imaat paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Eemon isaav ighe i iwaat ravuuŋni mako, na aravu sov. Pa yau Maaron ta napul pataŋani tana ivot. Tamtamon tauvene irau ighau ila pa nugh siriv to yoŋgaaŋ tau murei pale natotoia payam, leso ileep poia. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Eemon isaav ighe tamtamon eta aate yavyav pa iitete, ve iwaat ravuuŋni gha imaat, ve murei ighau ila pa artaal puughu, leso artaal ndaamo pani ve ileep poi, na aghuru sov. Ala asasaara ivot ila muuri, ve aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Isaav ighe tamtamon eta irav taama, ma tiina, na aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ve isaav ighe ŋeer eta isan tamtamon ite, ve igholia ila to tamtamon ite paam, ma tauu ikisi imin le besooŋa, na aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Isaav ighe tamtamon eta aate yavyav pa taama, ma tiina, ve isik saveeŋ saghati pazi, na aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Isaav ighe zitamoot ru tiparav, ve ee irav katin iitete pa maet ma niima, le naagho isaghat. Eemon imaat mako. Imin narape mon. I tau iravu na, aat ighol iitete tana pa saawe tau i imin narape ve irau igham uraat mako. Ve i aat iŋgini ve ibees pani le tiini poia muul. Isaav ighe iitete tana ikis titi ve iburig ilaagh, ene isov. Sosor tooni, i igharaata wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Isaav ighe tamtamon eta ilos besooŋa tooni tamoot ma livaa eta pa ai sirivu, ve besooŋa tooni imaat pataghaaŋ, na yam aat aghur atuya pa tamtamon tana. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Eemon isaav ighe besooŋa tooni imaat rekia mako, ve ileep mboŋ ee, ma ru, ra imaat, na aghur atuya pani sov. Pa besooŋa tawe, i ileep ila tamtamon tana niima. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Isaav ighe livaa eta aapo, ve saawe tooni duduuŋ to popaaŋ soone. Ve ighe zitamoot siriv tiparav, ve toozi eta isik niima le irav sorokin livaa tana, ve murei ipoop le naatu imazugh, ve i tauu poia. Ene aat atuya piiz tau azaawa tomania yes pooza tighuru pa ŋeer tana, i aat igholi. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","“Eemon isaav ighe livaa tau aapo na, igham saghat, na yam aat aghur atuya pa tamoot tana itaghon sosor tau i ighamu na. Tauvene isaav ighe i irav livaa tana imaat, na yam aat arav ŋeer tana imaat paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ve ighe ivaghamunia maata, yam aat avaghamunia ŋeer tana maata. Ve ighe ivaghamunia liivo, ma niima, ma aaghe, na yam aat agham ŋgar raraate mon pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ve isaav ighe i itun livaa tana pa yav, na yam aat anamim atun ŋeer tana paam. Ve ighe imbutu, ma iravu le tiini itiŋgal, na ataghon ŋgar eemon pa ŋeer tana. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","“Isaav ighe tamtamon eta irav besooŋa tooni tamoot ma livaa eta le maata isaghat, ma liivo ipol, i aat ipuli ila. Irau imin besooŋa pani muul mako. Ene eez to igharaat sosor tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Isaav ighe makau tamoot eta iŋgal tamoot ma livaa eta pa zooŋa le imaat, na yam aat arav makau tana paam pa maet le imaat. Eemon aghani sov. Ve aghita makau taama aghe i imin puughu pa pataŋani tana sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Eemon isaav ighe makau eta monmon iŋgalŋgal tamtamon pa zooŋa, ve makau taama iwataghi wa. Eemon i iŋgin poghania makau tooni mako, ve igham tauvene muul pa tamtamon eta, na yam aat arav makau tana pa maet le imaat. Ve makau taama paam, yam aat aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Eemon isaav ighe i tau imaat na zeetŋa lolozi isaghatin makau taama, ve tiyok pani to igharaat sosor tooni, ene atuya piiz tau tighuru pani na, i aat igholi. Leso igham mulin tauu, ve imaat sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Isaav ighe makau eta ivaghamunia ŋeer marani, ma livaa marani eta, na yam aat ataghon ŋgar raraate mon. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ve isaav ighe makau tamoot eta iŋgal besooŋa tamoot ma livaa eta pa zooŋa, na makau taama aat ighol maet silva tamoot ee saŋavul (30) ila pa daaba to besooŋa tana. Ve yam aat arav makau tana pa maet le imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","“Isaav ighe ŋeer eta itai puura ve ipoona mako, ma ireu gabua tau tipoon puura aavo pani na, ve ighe makau ma doŋki eta itap izila gha imaat, ene ŋeer tana aat igharaat ŋgai taama. Ve ŋgai aat igheen gha imin i tau igham sosor na le. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Isaav ighe makau to ŋeer eta ivaghamunia makau to iitete eta gha imaat, ene aat zeran ru tana tigholia makau tau poia na, ve tivalagh maeta. Ve makau tau imaat na, yesuru aat tipaalo bodbodaaŋ, ve ee igham le sirivu, ve ite igham sirivu. ");
INSERT INTO tuc_t_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Eemon isaav ighe makau tana monmon ighamgham tauvene, ve makau taama iŋgin poghania mako, ve igham tauvene muul, i aat iravol makau tau imaat na, pa tooni eta tau raraate, ve makau maate tana igheen imin le. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Isaav ighe ŋeer eta ium makau ma sipsip eta, ve iravu gha ighani, ma igholia ila pa tamtamon ite, i aat iyol gabua tau iumbu na, ve igham siriv paam izala paavo. Leso igharaat sosor tooni. Isaav ighe ium makau, i aat iyoli ve igham makau paaŋ izala paavo. Ve ighe ium sipsip, i aat iyoli, ve igham sipsip tol izala paavo. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Isaav ighe ŋeer umbuuŋa eta ireu ruum pa mboŋ ve iloŋ ila, ve tamtamon eta ighita gha iravu imaat, ene i le saveeŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Eemon isaav ighe ŋeer eta irav umbuuŋa eta le imaat pa mataaz, ene i igham sosor. Tauvene yam aat aghur atuya pani imin monmon aghurghuru pa yes tau tirav tamtamon timaat na. “Isaav ighe tamtamon eta ium gabua, i aat igharaat gabua tau iumbu na ila to gabua tawe taama. Ve isaav ighe i irau igharaata mako, ene aat tigholia tamtamon tana ila imin besooŋa pa tamtamon siriv, ve tigham maeta ila pa gabua tawe taama. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Isaav ighe ŋeer eta ium doŋki, ma makau, ma sipsip eta, ve ighe tindeeŋ gabua tawe imaat mako ve ilepleep ila ŋeer tana niima, i aat ipamuule, ve igham tauu tooni eta ila tomania, leso igharaat sosor tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Isaav ighe ŋeer eta ipul ŋgai tooni tila tivool pa uum to tamtamon ite ve tivaghamunia, i aat iyol aniiŋ ve vaen tau ŋgai tooni tivaghamunia na pa aniiŋ ve vaen popoiazi kat tau itum ila uum tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ve isaav ighe ŋeer eta itun nugh, ve yav ighan uum to tamtamon ite, ve ivaghamunia wit tooni paghpaaghu, ma wit matuugha tau ndouŋ na, i aat iyol suvinia wit tau yav ighani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Isaav ighe ŋeer eta ipul maet tooni, ma yauyauŋ tooni siriv ila tamtamon ite niima to iŋgin zi. Ve ighe umbuuŋa eta ium gabua tawe ila ruum tooni, ve murei tindeeŋa, saa gabua tau i iumbu na, i aat ipamuule, ve ighur ite paam izala paavo to igharaat sosor tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Eemon isaav ighe andeeŋ umbuuŋa tana mako, na yam aat agham ŋeer tau iŋgin gabua tana, ve ala apayooze ila Maaron naagho. Mako asuŋ pa Maaron, leso ipaghazoŋai ŋeer tana: I niima isosor pa gabua to iitete, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Ve isaav ighe tamtamon ru tivazorai zi pa makau, doŋki, sipsip, nonoghiiŋa, ma gabua ite paam. Ve ee ighe i tooni, ve ite ighe i tooni. Na agham yesuru gha ala avot Maaron naagho, ve tisavia saveeŋ toozi izi ta sewe. Mako asuŋ pa Maaron, leso itotoi sei tau igham sosor. I tau igham sosor na, aat ipamuul gabua tau tivazorai zi pani na ila pa iitete, ve ighur ite paam izala paavo to igharaat sosor tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Isaav ighe ŋeer eta ipul doŋki, makau, sipsip, ma ŋgai tooni ite paam ila iitete niima to iŋgini. Ve ighe gabua tana imaat, ma isaghat, ma umbuuŋa tiumbu, ve ighe tamtamon eta ighita gabua tana mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ene aat gabua tana taama yesuru iitete tau iŋgin gabua tooni na, tila tiyooz ila Yoova naagho. Ve ighe i tau iŋgin gabua na, isaav ighe: ‘Onoon kat, Maaron ighit ghau ve nasaav: Yau nimag isosor pa gabua to etag ite tane mako.’ Saawe tau gabua tana taama ilooŋ saveeŋ ghazooŋa tauvene, ene aat le saveeŋ muul mako, ve i irau ighur maata pa iitete tana to iyol gabua tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","“Eemon isaav ighe iitete iŋgin poghania gabua tana mako, ve umbuuŋa tiumbu, i aat iyol gabua tau ilale na imuul ila pa gabua tana taama. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ve isaav ighe gabua sagsag eta ighan ŋgai tana ve iraŋgati, ene aat ŋeer tau iŋgini na, igham sirivu ila, ve itotoia pa ŋgai tana taama. Leso iwatagh ighe iitete tana ium ŋgai tooni mako. Gabua sagsag eta ivaghamunia. Tauvene iitete tana irau iyoli mako. Pa i le sosor mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Isaav ighe ŋeer eta ighason iitete pa bapolo tooni, leso iuule pa uraat. Ve ighe bapolo taama ileep mako, ve bapolo tawe imaat, ma gabua eta ivaghamunia, ene ŋeer tana aat iyoli. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Eemon isaav ighe bapolo taama ilepleep, ve pataŋani tauvene ivot, ene ŋeer tau igham bapolo tana pa uraat na irau iyoli mako. Ve isaav ighe igharaat bapolo taama pataghaaŋ wa, ve pataŋani tauvene ivot, ene paam, irau iyoli mako. Pa atuya tau i igholi imin maata na, tauta igharaata. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Isaav ighe ŋeer eta igherev livaa mbiu eta tau tisiigho soone, ve imogheer pani, i aat ighol livaa tana ve ivaii. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ve isaav ighe livaa taama iyok pazi to tivai mako, ene aat yesuru tivai mako. Eemon ŋeer tana aat igharaat livaa taama, raraate imin tau tigholghol zilivaa mbiu. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Zilivaa tau tikis mur na, apul zi tileep sov. Arav zi timaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Isaav ighe tamoot eta imogheer pa ŋgai livaa eta, ma livaa eta itotoi tauu pa ŋgai tamoot leso ŋgai imogheer pani, na aravu imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Yam aat agham watooŋrau pa Yoova mon. Isaav ighe tamtamon eta igham watooŋrau pa maaron karom eta, na aravu ilale. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Loomba tau tileep ila sosomim na, yam agham saghatin zi, ma agham pataŋani pazi sov. Yam aat agham poghani zi. Pa matamim iŋgal: Muuŋ, yam aleep amin loom izi Isip. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ve yes zinaara ve parooŋa tauvene paam. Agham saghatin zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pa ighe agham tauvene pazi, ve titaŋ payau to nauul zi, yau aat nalooŋ taŋiiz toozi ve nauul zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ve yau pale ateg yavyav kat payam, ve narav gham amatmaat pa mbuzaagh tsiau, ve azuwamimŋa timin zinaara, ve natumimŋa timin parooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Isaav ighe tamtamon tsiau eta mbolaaŋ ighamu ve igham bun ilat tsio, na utaghon ŋgar imin yes zeran tau tighamgham maet pa tamtamon leso tigham lezi geege izala paavo na sov. Tauvene i tau igham bun ilat tsio na, isaav ighe murei iyatu, ene i aat iyat maet anooŋa mon tau yo ugham pani na. Upoi pa geege izala paavo sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ve isaav ighe ugham nonoghiiŋa tooni to ŋgoaaŋ igheen tsio, leso maata iŋgal bun tooni ve iyatu, na ravrav ta naol ne, yo aat ugham nonoghiiŋa tooni imuul ila pani le isov, o mboŋ izi. Ve mboŋoozo, i aat ighamu imuul ilat. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Pa i le gabua ite paam to ikaukau ghi pani mako. Tauvene isaav ighe ukis nonoghiiŋa tooni pa mboŋ, ene pale ŋgoaaŋ ighamu, ve igheen poi mako. Ve isaav ighe i itaŋ rarai ghau to nauule, ene yau aat nalooŋ taŋiiz tooni. Pasaa, yes tau tileep ila pataŋani loolo na, yau lolog isasaghatin zi, ve nauluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Uvelegh Maaron sov, ve usik saveeŋ saghati pa daaba eta tau iŋgin gham na sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Aniiŋ tomania vaen ve oliv tsio maata, uŋguruuta payau sov. Ughamu ilam payau. Ve natum tamoot aidaaba tauvene paam, upuli imin leg. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ve makau ve sipsip tsio tau tinazŋa tipoop zi timin maata na paam. Upul zi tileep tomania tinazŋa irau mboŋ liim ve ru. Ve mboŋ imin liim ve tol, mako ugham zi tilam, ve urav zi timin watooŋrau payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Yam aat ataghon ŋgar patabuyaaŋ. Pa yau nagham gham amin leg wa. Tauvene ŋgai tau ighe gabua sagsag eta iraŋgati ve iravu imaat na, aghani sov. Asiki ila ŋgavuun tighani.” ");
INSERT INTO tuc_t_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Isaav ighe ulooŋ gabua eta vaaru, na ulandoov saveeŋ tana rekrekia sov. Pa aat karom ma vene. Ve isaav ighe tamtamon eta igham ŋgar saghati, ve tipayooze pa savsaveeŋ, na uvool tooni, ve usavia saveeŋ karom to uule sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Isaav ighe eval tiina tilup zi to tigham ŋgar saghati eta, na upaak zi sov. Ve saawe to gharatooŋ saveeŋ, isaav ighe eval tiina tisavia saveeŋ karom to tikau saveeŋ, na yo ula tomani zi ve upariaaŋ karom toozi tawe sov. Yo aat usavia saveeŋ onoon mon. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“Isaav ighe tipayooz mbolaaŋa eta pa savsaveeŋ, na uvool tooni sorok sov. Ulooŋ poghania saveeŋ tooni puughu le isov, o ugabiiza itaghon ŋgar duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Isaav ighe ughita makau ma doŋki to koiam eta ilaghlaagh muuri, na ughamu imuul ila pa tauŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ve isaav ighe ughita doŋki to koiam eta tau ibaad gabua pataŋani ve itap izi ighengheen, na upuli sov. Ula ve uul koiam tana ve yamru apaburigin doŋki tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Isaav ighe yo daaba to nugh, ve mbolaaŋa eta le pataŋani, ve ighuru ila nimam to ugharaata, na utatan saveeŋ tooni sov. Yo aat ulooŋ saveeŋ tooni, ve ugharaat poghania. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ve isaav ighe tamtamon tiŋgal saveeŋ pa ŋeer eta, ve tipayooze sorok pa savsaveeŋ, na upaak zi pa saveeŋ toozi tawe sov. Uleep soghan pazi. Tamtamon duduuŋa tau le sosor eta mako, na uravu imaat sov. Pa yes tau tigham sosor tauvene, ene irau naghurghur zi mako. Pale naghur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Isaav ighe tamtamon eta ighe ighol ghom leso uule pa karom tooni, na uyok pani sov. Pa ŋgar tauvene ikaukau ŋgar to tamtamon. Yes tau tighazooŋ pa ŋgar poia na paam, pale ikau ŋgar toozi. Tauvene saawe tau tigharaat saveeŋ, yes pale tivool to yes tau tighol zi na, ve tikau saveeŋ to yes tau titaghon ŋgar duduuŋa na. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ugham saghatin yes loomba sov. Pa muuŋ, yam paam aleep amin loom izi Isip. Tauvene pataŋani to yes loomba, taumim ayamaana wa. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Uvavazogh aniiŋ ila taan tsio, ve uyauyauu le irau ndaman liim ve ee. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ve ighe ndaman imin liim ve ru, na upul taan tana igheen imin zeŋam. Ndaman tana, yes mbolaaŋa tau tileep ila sosomim na, pale tila zeŋam tsio tana, ve tiil lezi nakapoŋa pa ghaniiŋ. Ve isaav ighe tipul aniiŋ siriv igheen, ene aat imin gabua sagsagŋa lezi. Ndaman isov tau imin liim ve ru na, yo aat utaghon ŋgar tauvene. Ve utaghon ŋgar raraate mon pa oliv ve vaen tsio paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Uraat imin ee, ila imuul liim ve ee, ene saawe tsio to ugham uraat. Ve saawe imin liim ve ru, na yo aat upul uraat tsio naol isov igheen, ve umariau. Leso makau ve doŋki tsio, tomania yes besooŋa tau tinazŋa tipoop zi ila ruum tsio na, ve yes loomba tau yamŋa alepleep na, timariau ve vuvuŋazi ila. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Saveeŋ isov tau yau nasavia payam na, matamim kisini ve ataghon duduŋaini. Ve asuŋ pa maaron karomŋa sov, ve ezazi ivot ila avomim rigta sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ndaman isov, lupuuŋ tintiina tol to suŋuuŋ pale tivot. Saawe toozi ighe ivot, mako yo yamŋa eval tiina to Israel alup gham pa suŋuuŋ, ve apait ghau. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Lupuuŋ tau ivot imin maata, ene to Pasova. Ene pale ivot pa kaiyo Abib. Pasaa, kaiyo tana, ta nagham gham apul taan to yes Isipa ve avot. Saawe tana, yam aat alup gham pa suŋuuŋ, ve aghan mberet tau le yis mako na irau mboŋ liim ve ru, itaghon saveeŋ tau muuŋ yau naghuru payam na. “Tamtamon eta niima ŋginaaŋa, ve ilam ivot naghog to isuŋ payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Lupuuŋ imin ru, ene Saawe to Aniiŋ Maata. Uvazogh aniiŋ ila uum tsio, ve usasaŋan le ighe aniiŋ maata imatuugh, mako lupuuŋ tiina tane ivot. Tauvene ulaagh tomania aniiŋ tsio maata ulam, ve yamŋa eval tiina to Israel alup gham pa suŋuuŋ. “Lupuuŋ imin tol, ene Saawe to Mariri. Ndaman igharau ighe isov, ve utai aniiŋ ila uum tsio, mako lupuuŋ tiina tane ivot. Tauvene yam asov aat alup gham pa suŋuuŋ, ve apait ghau pa mariri tau nagham payam na. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Yau Yoova, Maaron tsiam. Tauvene ndaman ta naol ne, saawe tol tane tighe tivot, mako zitamoot tsiam tisov tilup zi ila naghog, ve tisuŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Isaav ighe urav gabua eta imin watooŋrau payau, na ulup gabua tau yis igheen ila na, tomania sov. Ve saawe tau yamŋa eval tiina alup gham pa suŋuuŋ ve ugham watooŋrau payau, na yav aat ighan suvinia watooŋrau tsio tana miiza tomania ŋgoreeŋa. Ŋgiira rigta igheen mboŋ nughizau sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Yau Yoova, Maaron tsio. Aniiŋ tsio maata tau ivot ila taan tsio na, yo aat uvureer popoia mon ve ughamu ilam rumei tsiau. “Isaav ighe unaz mekmek naatu eta, na unazu tomania tuz to tiina sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Alooŋ! Yau aat nambaaŋ aŋela tsiau ilat, leso imuuŋ payam, ve iŋgin gham pa eez. I pale igham gham ala avot taan tau yau naghuru payam pataghaaŋ to aleep pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Aghur taliŋamim pani poi, ve alooŋ saveeŋ tooni. Azoor aliiŋa sov. Pa isaav ighe yam azoor aliiŋa, ene i irau ighurghur gham mako. Pale ighur pataŋani izaa tsiam. Pasaa, i igham yau naghog ve ezag igheen tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Eemon isaav ighe yam alooŋ aliiŋa, ve ataghon duduŋai saveeŋ isov tau yau nasavia, ene pale naghur koi pa yes tau tighur koi payam, ve naparav tomania yes tau tiparav tomani gham. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Tauvene aŋela tsiau tane pale imuuŋ payam, ve igham gham ala avot taan to yes Amora, Hita, Peresa, Kanaana, Hivia, ve Yebusa. Ve yau taug pale narav zi tilalez, leso agham taan toozi imin lemim. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“Saawe tau ala aleep izi taan Kanaan, ataghon zi pa ŋgar toozi sov. Tauvene aput aghemim pa maaron karomŋa toozi ve abees pazi sov. Arav mbirisai zi. Ve maet toozi patabuyaaŋa tau tiyozyooz ila nugh toozi to suŋuuŋ na, tauvene paam. Arav mbirisai zi le timbiriis ŋgiira ŋgiira. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Yau Yoova, Maaron tsiam. Yam aat abees payau mon. Leso poia tsiau izazaa tsiam, ve nagham lemim aniiŋ ve yaa, ve naziir moroghooŋ ighau payam. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ve zilivaa tsiam tisov, popaaŋ toozi pale poia mon. Eta irau iuup mako, ve marani eta tau igheen ila tiina aapo loolo na irau imazugh mako. Ve yau aat matag payam, leso aleep malau izi taan tau naghe nagham payam na. Irau amaat rekia mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Saawe tau yam alaagh ala, yau taug pale namuuŋ payam, ve naghur roiŋ tiina ivot pa yes nugh nugh tau pale ala avot toozi. Leso nagham koiamimŋa ŋgar toozi ivaghamgham, ve tiroi payam ve tighau. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ve yau pale nambaaŋ ŋgururuuv ndiŋndiŋ ndiŋndiŋ timuuŋ payam. Leso tireu yes Hivia, Kanaana, ve Hita tighau. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Eemon irau naziir zi tisov tighau pa ndaman eemon mako. Pa ighe nagham tauvene, ene pale taan toozi igheen sorok, ve gabua sagsagŋa timasa timin naol izi nugh toozi, ve tivaghamun gham. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Tauvene yau aat naziir zi poipoi ve tila, le irau yam avot amin naol, mako agham taan toozi isov imin lemim. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Taan tau naghe nagham payam na ziige ee, ene itaghon nari to Te Siŋsiŋai, le ila imuul izi nari to Te Mediterenian tau yes Pilistia tileep pani. Ve ziige ite, ene itaghon nugh ŋginaaŋa tau sausau mon, le ila imuul yaa Euprates. Yau pale naghur taan tawe tamtamona ila yam nimamim, leso aziir zi tighau, ve agham taan toozi imin lemim. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tauvene yamŋa ambu saveeŋ to avalupu gham amin eemon sov. Ve maaron karomŋa toozi tauvene paam. Ambu saveeŋ tomani zi to yamŋa avalupu gham sov. Aleep soghan pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ve ayok pazi to tileep tomani gham ila taan tsiam tawe sov. Pale tiyes gham pa ŋgar toozi sasaghati, ve agham sosor ila yau matag. Ve aghita. Isaav ighe tigherev gham gha abees pa maaron karomŋa toozi ve asuŋ pazi, ene pale imin liis payam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yoova isaav pa Mose ighe: “Yamru togham Aron, tomania natŋa ru Nadap gha Abiu, ve daaba tamoot tol saŋavul (70) to yes Israela azalam tsiau ta loloz daaba ne. Eemon alam agharau ghau geeg sov. Aleep soghan rig, ve aput aghemim, ve asuŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Le isov o, yes siriv tileep ta sewe, ve yo zigom ulam ugharau ghau. Ve yes eval tiina to Israel tauvene paam. Tizalam tigharau ghau sov. Tileep soghan.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tauvene Mose imuul izila to yes Israela, ve ipaes pazi pa saveeŋ ve tutuuŋ isov tau Yoova isavia na. Isavsaav pazi le isov, ra tilup avozi tighe: “Saveeŋ naol tau Yoova isavia na, yei pale nitaghoni.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ra Mose ibood saveeŋ isov to Yoova ila rau. Mboŋ nughizau, ra Mose iburig, ve indou maet siriv izi loloz puughu imin artaal, ve ipayooz maet saŋavul ve ru imin ilaal pa rumei saŋavul ve ru to yes Israela. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ra imbaaŋ geegeu toozi siriv tila tigham watooŋrau pa Yoova. Yes tigham gabua siriv ve tighur zi tizala yav gha ighan dodolin zi. Ve timoz makau paghpaaghu siriv ve tighan zi, leso yesŋa Yoova tivalupu zi timin eemon. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose iwato gabua tau tirav zi imin watooŋrau na siŋizi, ve iliŋ sirivu ila oon siriv lolozi, ve igham sirivu, ve itirtiri izala artaal. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ra igham rau tau saveeŋ mbuaaŋ toozi tomania Yoova igheen ila na, iraraava, ve iwaato gha eval tiina tilooŋa. Tilooŋa le isov, ra tisaav tighe: “Saveeŋ isov tau Yoova isavia na, yei aat nitaghon duduŋaini.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ra Mose igham siŋ tau igheen ila oon lolozi na, ve itirtiri izala eval tiina pavozi, ve isaav pazi ighe: “Aazne, Yoova imbu saveeŋ tomani gham ve yamŋa avalupu gham amin eemon. Siŋ tane, ene to ipariaaŋ saveeŋ mbuaaŋ tsiam tomania Yoova. Lupuuŋ toit tomania Yoova, ene iyooz izala saveeŋ tau i igham pait. Isaav ighe tataghon duduŋaini, ene pale lupuuŋ toit tomania Yoova ighengheen tauvene taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ra Mose igham Aron, Nadap, Abiu, ve daaba tamoot tol saŋavul (70) to yes Israela, ve yesŋa tizala pa loloz. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Tila tivot ta sewe, ra tighita Maaron to Israela. I iyooz izala gabua ee paavo. Gabua tawe babaaŋa, ve mazavaniiŋa imin sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yes zolman to Israela tileep ila Maaron naagho ve tighan ma tighun izi ta sewe. Onoon kat, yes tighita Maaron. Eemon i ivaghamun zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Murei pa gabua tana, Yoova isaav pa Mose ighe: “Malmalim uzalam tsiau ta loloz daaba ne, ve uleep ta sene. Pa yau narav saveeŋ ve tutuuŋ tsiau ila maet babaŋazi wa. Leso ipaghazoŋai yes Israela pa ŋgar to titaghoni. Ve naghe naghur maet tane ila nimam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Tauvene Mose isaav pa yes daaba tana ighe: “Yam aleep ta sene, ve asaŋan yeiru Yosua. Aron yesuru Ur ta tilepleep ne. Isaav ighe lemim pataŋani eta, yesuru irau tigharaata.” Isavsaav pazi le isov, ra igham uleeŋa tooni Yosua gha yesuru tinau tizala rig. Ra Mose ipul Yosua izi, ve i zigani malmali izala pa loloz daaba ighe ighita Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Saawe tana, taitai izilam ikau loloz Sinai daaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ve Yoova mbonari isul izala loloz daaba. Taitai tawe ikau loloz irau mboŋ liim ve ee. Eval tiina to Israel tau tileep siiŋa na, matazi izala pa loloz, ve tighita Yoova mbonari isul imin yav tiina ighanghan izala loloz daaba. Saawe imin liim ve ru, ra Yoova ileep taitai loolo, ve isaav izila pa Mose ighe izala pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tauvene Mose izala loloz daaba kat, le iloŋ ila taitai loolo. Ve ileep ta sewe irau mboŋ tamoot ru. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mose ileep malau izi loloz Sinai daaba. Tauvene yes Israela tisaŋani le mako, ra tila tilivut Aron, ve tisaav pani tighe: “Aron, ugharaat leen maaron eta! Leso imuuŋ pait ve iŋgin ghiit. Pa ŋeer tau igham gherev pait gha tapul taan to yes Isipa ve talam na, yei nikankaan pani. Gabua eta aat ivot pani wa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron ilooŋ saveeŋ toozi, ve isaav pazi ighe: “Poia. Yam ala agoog padood to azuwamimŋa ve natumimŋa tau tigharaat zi pa gol na, ve agham zi tilam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tauvene eval tiina tizugh padood toozi pa taliŋazi, ve tigham zi ila to Aron. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ra i igham gol toozi tawe, ve igharaata imin makau anunu. Eval tiina tighita makau anunu tawe, ve tisaav tighe: “A yam Israela, aghita. Ene maaron toit tau igham ghiit tapul Isip ve talam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron ighita ŋgar toozi tawe, ve igharaat artaal ee ila gabua tawe naagho, ve isaav pazi ighe: “Bogzo, aat talup ghiit pa suŋuuŋ, ve tapait Yoova!” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mboŋ le nughizau, ra eval tiina tiburig, ve tiyau gabua toozi siriv tila, leso tigham watooŋrau pa maaron toozi tawe. Watooŋrau siriv, yav ighan dodolin zi. Ve tigham siriv, leso yesŋa maaron toozi tawe tivalupu zi timin eemon. Ra mbolezi izi pa ghanghaniiŋ. Tighanghan ma tighunghun, ve malau mako tipaburigin narogho, ve mogheraaŋ tomania ŋgar sasaghati naol ivot. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","8","Tighamgham tauvene, ve Yoova isaav pa Mose ighe: “Ai, rekia mon uzila! Pa tamtamon tsio tau ugham zi tipul Isip ve yamŋa alam na, ŋgar toozi isaghat ve tivaghamgham. Eez tau avog iyaryaaŋ pazi naghe titaghoni, ene tipuli wa. Ulooŋ. Tigharaat lezi makau anunu, ve tiput aghezi pani, ve tigham watooŋrau pani. Ve tisavsaav tighe: ‘Yam Israela, aghita. Maaron toit tau igham ghiit tapul Isip ve talam, tauta ene!’ ");
INSERT INTO tuc_t_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Zeran tawe, yau nawatagh zi wa. Matazi zoraaŋ saveeŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tauvene ateg yavyav pazi kat, ve aazne naghe napasov zi tilalez. Ve yo uŋgalsekin ghau sov. Pa naghe naghur yo tomania paaghu tsio agham niazi. Yau aat nagham gham amasa amin naol, ve ezamim tintiina.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Eemon Mose itoova to irav Maaron tooni Yoova aate. Ighe: “Aa Yoova, puughu mindai ta atem yavyav kat pa tamtamon tsio? Yo taum ta utotoi tapirim ve ugham gabua ŋgeretazi tintiina, tauta ugham zi tipul Isip ve tilam. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Isaav ighe yo uvaghamun zi, ene pale yes Isipa tisaav tighe: ‘Laak, Maaron to yes Israela ighe ivaghamun zi ve ipasov zi pa taan. Tauta itombaan zi, ve igham zi tipul ghiit, ve tila nugh tau bide loloza, leso iravuur zi ta sewe.’ Tauvene uvaghamun zi sov. Onoon, atem yavyav kat. Eemon utatan atem, ve utoor ŋgar tsio. Lolom imuul pa tamtamon tsio, ve ukari zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Matam iŋgal besooŋa tsio Abaram, Isak, ve Yakop. Muuŋ, yo umbu saveeŋ tomani zi, ve upariaaŋa le iyaryaaŋ kat ughe: Yo aat ugham paaghu toozi timasa timin naol imin pitum to sambam saamba. Ve ugham taan Kanaan isov imin lezi motot, leso tileep pani taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Onoon, Yoova ŋgar tooni iyaryaaŋ ighe ivaghamunia yes Israela. Eemon Mose isuŋ ariaaŋ, tauta Yoova itatan aate, ve itoor ŋgar tooni gha irav tamtamon tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Ra Mose igham maet babaaŋa ru tau Maaron iŋgeret tutuuŋ tooni ila na, ve imuul izila to yes Israela. Maet ru tawe, Maaron tauu igharaat zi, ve iŋgeret tutuuŋ tooni ila. Ve bodeeŋ igheen ila zigezi ru. Tutuuŋ tawe, ene to ipariaaŋ yes Israela, leso matazi kisin saveeŋ tau yesŋa Maaron timbua na, ve titaghon eez tooni. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosua tau uleeŋa to Mose na, isasaŋani izi loloz livuugha. Mose izila ivot tooni, ve yesuru malmalizi tizila. Tigharau nugh tau eval tiina tilepleep pani na, ra Yosua ilooŋ oroor tiina. Tauvene isaav pa Mose ighe: “Wai, ewe aat malmal eta?” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Eemon Mose isaav pani ighe: “Mako. Oroor tawe imin pakuruuŋ to yes zaaba tau tiliiv malmal ne mako. Ve imin taŋiiz to zaaba tau koiazŋa tiliiv zi na mako paam. Mbouŋ tau nalooŋa we, tamtamon aat tintinizi pa gabua eta.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mose ivot toozi ta loloz puughu we, ve ighit zi titortor livutin makau anunu, le aate yavyav kat ve isik maet babaaŋa ru tau ikiskis zi na, tizi taan, le tivavaal ŋgiira ŋgiira. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ra ila igham makau anunu tana, ve isiki izala yav ighani, ve itutu ila le imbiriis imin avav. Ra, itiri izila yaa, ve isaav ariaaŋ pa yes Israela gha tighunu. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ra iyaon Aron ighe: “Laak, zeran tane tigham mindai payo, ta ulooŋ zi, ve ugherev zi gha tigham sosor tiina tane?” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron iyol aliiŋa ighe: “Wai, tiina tsiau, atem yavyav payau sov. Yo uwatagh: Zeran tane, monmon lolozi ipapazaagh zi pa ghamuuŋ ŋgar sasaghati naol. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Yes tisaav payau tighe: ‘Ugharaat leen maaron eta lak! Leso imuuŋ pait ve iŋgin ghiit. Pa ŋeer tau igham gherev pait gha tapul taan to yes Isipa ve talam ne, yei nikankaan pani. Gabua eta aat ivot pani wa.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Yes tisaav payau tauvene, tauta nasaav pazi naghe: ‘Poia. Sei tau ighe ipabood tauu pa gol na, izughu, ve ighamu ilam.’ Tauvene yes tila tiyauur gol toozi ilam tsiau, ve nasuruuv zi tizala yav, ve rekia mon makau anunu ivot!” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose ighita ighe Aron iŋgin poghania yes Israela mako, ve ipul zi tivaghamgham, tauta tigham ŋgar sasaghati naol. Tauvene iroi: Isaav ighe koiazŋa tilam ve tighit zi, ene pale tivelegh zi ve tiŋiŋ pazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tauta ila iyooz ila eez maata, ve iboob ighe: “Alooŋ! Sei tau ighe itaghon Yoova, na ilam tsiau!” Tauvene yes to rumei Levi tisov tila tilup zi ila Mose naagho, ");
INSERT INTO tuc_t_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ve Mose isaav pazi ighe: “Yoova tau Maaron to iit Israela, aliiŋa ilat payam ighe agham mbuzaagh tsiam, ve alaagh taghon nugh loolo, ve arav yes tau tiput aghezi pa gabua tana, le tisov timataar. Ighe toŋvetaz tsiam, ma zeetmimŋa, ma yes tau tileep tigharau gham na, aghurghur zi sov. Mbuzaagh ighaniir zi mon.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tauvene yes Levia titaghon Mose aliiŋa, ve saawe tana tirav zitamoot irau ndiŋndiŋ ndiŋndiŋ tol (3,000) pa mbuzaagh gha timataar. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ra Mose isaav pazi ighe: “Yam rumei to Levi, alooŋ. Onoon, ene ipataŋan pa yam arav natumimŋa ve toŋvetaz tsiam timaat. Eemon yam aghurghur zi mako, ve ataghon duduŋai Yoova aliiŋa. Tauta aazne, i igham gham amin uraata tooni, ve ighur poia tooni izaa tsiam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mboŋ nughizau, ra Mose isaav pa eval tiina ighe: “Alooŋ! Sosor tau yam aghamu na, ene tiina le tiina kat. Eemon yau aat namuul nazala to Yoova, ve natoova to nagharaat saveeŋ tomania, ve naghita: Pale irau ilooŋ ghau, ve ipul sosor tsiam tane, ma mako?” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tauvene Mose imuul izala to Yoova, ve isaav pani ighe: “O Yoova, eval tiina tawe tigham sosor tiina kat payo. Pasaa, tigharaat lezi maaron karom pa gol. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Eemon aazne, naghason ghom to lolom isaghatin zi, ve upul sosor toozi. Ighe mako, o yau ezag tau uboode ila rau tsio na, umusu ighau paam.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yoova iyol aliiŋa ighe: “Ena aat mako. Tamtamon tau ighe izoor ghau ve igham sosor payau, i tana ta pale namus eeza ighau pa rau tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tauvene uburig umuul uzila toozi, ve ugham zi gha yamŋa ala pa nugh tau muuŋ nasavia payam na. Aŋela tsiau pale imuuŋ payam, ve yamŋa ala. Eemon murei, yau aat naghur atuya pazi pa sosor toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tauta murei, Yoova igham moroghooŋ saghati ivot pazi, ve iyat ŋgar toozi tau tizoornugh pa Aron gha igharaat lezi makau anunu imin maaron karom. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ra Yoova isaav muul pa Mose ighe: “Yo yamŋa yes Israela tau ugham zi tipul Isip ve alam na, aburig apul nugh tane, ve alaagh muul ala pa taan Kanaan. Pa muuŋ, yau nambu saveeŋ tomania Abaram, Isak, ve Yakop, ve napariaaŋa le iyaryaaŋ kat naghe yau aat nagham taan tawe pa paaghu toozi. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Yau aat nambaaŋ aŋela tsiau ee imuuŋ payam, to iziir taan tawe tamtamona tighau. Ene yes Kanaana, Amora, Hita, Peresa, Hivia, ve Yebusa. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Leso agham taan toozi imin lemim, ve aleep pani. Taan tawe ŋgoreeŋa tiina, ve gabua naol titum poi pani. Eemon yau taug irau itiŋa tala mako. Pasaa, yam matamim zoraaŋ saveeŋ. Isaav ighe itiŋa tala ve agham ŋgar saghati ite paam izi eez livuugha, ene pale apas ateg, mako napasov gham asov ta sewe.” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Eval tiina tilooŋ saveeŋ ariaaŋa tane, le lolozi ipataŋan kat ve titaŋ tiina. Titiik tauzi muul mako. Tipul tauzi imin timoŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pasaa, Yoova isaav pa Mose ighe: “Usaav pa yes Israela tauvene: ‘Yam matamim zoraaŋ saveeŋ. Irau itiŋa tala mako. Pa ighe naleep tomani gham pa sooso ŋgiira rigta mon, ve apas ateg muul, ene aat napasov gham. Tauvene gabua tsiam popoia naol tau atiik taumim pani na, azuzuum zi tisov tizi, o matag iŋgal saa ŋgar ta pale nagham payam.’” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tauvene saawe tau yes Israela tipul loloz Sinai, ve ilam, yes titiik tauzi pa gabua popoia muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Saawe tau yes Israela tilaghlaagh izi nugh ŋginaaŋa, ve ighe timariau izi eez livuugha, mako Mose ipayooz balbaal ee ila soghan pa balbaal siriv. Balbaal tawe, tiwaato tighe ‘Balbaal to lupuuŋ.’ Tamtamon tisov tau tighe tighason Yoova pa gabua eta na, tilala ta sewe, ve tighurghur aliŋazi ila to Mose leso aana isavia ila to Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","9","Saawe isov tau Mose ighe ilaagh ila pa balbaal tana, eval tiina tisov tiburig, tiyooz irau balbaal toz toz naghozi, ve matazi itaghoni le iloŋ ila balbaal loolo. Mako taitai izuur izilam gha ipoon balbaal naagho, ve Mose yesuru Yoova tisavsaav. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Saawe tau eval tiina tighita taitai tawe izilam gha ipoon balbaal naagho, tiput aghezi, ve tisuŋ irau balbaal toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ve Yoova yesuru Mose tivaghito zi, ve tisavsaav imin tamtamon ru avozi ibesbees. Tisavsaav le isov, mako Mose ivot, ve imuul ila pa Israela niazi to lepoogh. Eemon Yosua tau Nun naatu na, ipulpul balbaal tana mako. Iŋginŋgini irau saawe. Yosua, i ŋeer paaghu ve imin uleeŋa to Mose. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Tilepleep le saawe ee, ra Mose isaav pa Yoova ighe: “Laak, yo usaav payau ughe nagherev eval tiina tane gha yeŋa nila pa taan Kanaan. Ve ughe tinim irav ilam tsiau ve ugham ghau namin etam duduuŋ. Eemon sei tau yo ughe umbaaŋo ilam tomani ghau to iuul ghau, ene yo upaghazoŋai ghau pani soone. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Isaav ighe onoon tinim irav ilam tsiau, na upaduduuŋ ghau pa ŋgar tomania eez tsio. Leso nawatagh katin ghom, ve laghooŋ tsiau poia ila yo matam. Aa Yoova, matam iŋgal eval tiina tawe paam. Pa yes tamtamon tsio. Yo taum usiigh zi timin lem.” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yoova iyol aliiŋa ighe: “Ugham ŋgar naol sov. Yau taug pale nalat tomani ghom, leso nagham ghom atem izi ve umariau.” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose ilooŋ saveeŋ tane, ve isaav pani ighe: “Ene poia to ulam tomani ghei. Pa ighe yo taum ulam tomani ghei mako, yei irau nipul nugh tane mako. Aat nileep mon ta sene. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pa ighe ulam tomani ghei mako, ene pale saa gabua igham tamtamon tighilaal tighe yo lolom payei, ve poia tsio ighengheen tomani ghei? Mako. Eemon isaav ighe ulam tomani ghei, ene pale yes tiwatagh tighe yo usiigh ghei nimin lem, ve yo taum upet ghei nivot soghan pa nughmariŋ to taan.” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Tauvene Yoova isaav pa Mose ighe: “Poia. Gabua tau yo ughason ghau pani na, yau aat naghamu. Pasaa, tinig irav ilat tsio, ve nagham ghom umin etag duduuŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose ilooŋ saveeŋ tane, ve ighason Maaron muul ighe: “Aa Yoova, ighe tauvene, na utotoi taum tomania tapirim ve poia tsio payau, ve naghit katin ghom!” ");
INSERT INTO tuc_t_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yoova iyol aliiŋa ighe: “Yau aat natotoi suvinia poia tsiau payo, ve navotia ezag Yoova tomania gabuag ila naghom. Isaav ighe lolog poia pa tamtamon eta ve naghe nagham poghania, ene aat nagham poghania. Ve isaav ighe lolog isaghatin tamtamon eta ve lolog pa uleeŋni, ene aat nauule. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Eemon yo irau ughita naghog mako. Pa ighe tamtamon eta ighit katin ghau, i irau ileep mako. Pale imaat. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ughita nugh ee ta igheen zigeg ne. Ulam uyooz izala maet paavo tane. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Saawe tau nalam ve naghe natotoi taug tomania tapirig ve poia tsiau payo, ene pale naghur ghom uloŋ ula maet puura tane, ve napoon ghom pa nimag, le irau nasal payo gha nala. ");
INSERT INTO tuc_t_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mako nimag ighau, ve ughita ndumeg. Eemon naghog, tamtamon eta irau ighita mako.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ra Yoova isaav pa Mose muul ighe: “Ugharaat maet babaaŋa ru, le raraate imin tau papazoge nagharaat zi ve usik zi tizi gha tivavaal na. Leso naŋgeret saveeŋ raraate imin tau muuŋ naŋgeret zi na. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ugharaat zi pataghaaŋ, leso bogzo, mboŋoozo, mako ugham zi, ve uzalam uvot tsiau ta loloz tane daaba. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tamtamon ite paam ilam tomani ghom sov. Ve lolog pa naghita tamtamon eta ilaghlaagh taghon loloz ziige mako. Ve ŋgai tauvene paam. Tilaagh tigharau loloz puughu sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Yoova isavsaav le isov, ra Mose ila igharaat maet babaŋazi ru, le raratezi imin tau papazoge Yoova igham pani na. Mboŋ nughizau ta ndoromroome soone, ve Mose iburig, igham maet ru tawe, ve inau izala pa loloz Sinai daaba itaghon Yoova aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ra Yoova ileep iloŋ ila taitai loolo, ve izilam iyooz igharau Mose, ve ivotia tauu eeza ve gabua. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","7","I ilaagh imbut Mose naagho, ve isaav ighe: “Yau Yoova. Ezag tauta ene: Yoova. Yau Maaron tau lolog isasaghatin besooŋa tsiau, ve naghamgham poghani zi. Ateg yavyav rekrekia mako. Poia tsiau, ene tiina kat. Lolog isaghav tamtamon tsiau ariaaŋ ve nauluul zi, ve nataghon saveeŋ mbuaaŋ tsiau irau saawe. Ŋgar tau lolog isaghav tamtamon tsiau ve nauluul zi, ene natotoia pa tamtamon ndiŋndiŋ ndiŋndiŋ. Ve ŋgar toozi to zoraaŋ saveeŋ, tomania ŋgar toozi siriv tau isapir pa tutuuŋ tsiau na, sosor toozi naol tawe, monmon yau nareureu zi. Eemon yes tau lezi sosor na, yau naleleel zi mako. Naghurghur atuya pa yes tauzi, tomania natuzŋa, timbuzŋa, ve gabazŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose ilooŋ saveeŋ tane, le rekia mon iput aaghe, naagho izila taan, ve isuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ighe: “Aa Yoova, isaav ighe lolom poia payau, ve ughe ugham poghani ghau, na ulam tomani ghei ve itiŋa tala. Onoon, eval tiina tawe, dabazi ariaaŋa, ve tiloŋlooŋ saveeŋ mako. Eemon lolom isaghatin ghei, ve ureu sosor tsiei. Ŋgar tsiei naol tau isapir pa tutuuŋ tsio na, ureu zi tilalez. Ve ugham ghei nimin lem kat.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mose isavsaav le isov, ra Yoova isaav pani ighe: “Aazne, yau naghe nambu saveeŋ tomania yam Israela, leso itiŋa tavalupu ghiit tamin eemon muul. Yau aat nagham gabua ŋgeretazi tintiina ila tamtamon tsio tisov matazi. Uraat tau naghe nagham zi, ene pale ite kat. Muuŋ ve ilam, nughmariŋ tau tileep irau taan isov na, tighita gabua eta tauvene pai eta soone. Tauvene nugh nugh tau tileep tigharau na, isaav ighe tighit zi, ene pale roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tutuuŋ tau aazne naghuru payam ne, yam asov aat matamim kisini, ve ataghon duduŋaini. Leso namuuŋ payam ve naziir yes Amora, Kanaana, Hita, Peresa, Hivia, ve Yebusa tau tileep izi taan Kanaan na, tisov taghawaar. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Eemon matamim imomoos poi pa taumim. Yamŋa taan tawe tamtamona ambu saveeŋ to avalupu gham sov. Aleep soghan pazi. Pa isaav ighe yamŋa avalupu gham, ene pale timin liis payam, ve tigherev gham pa ghamuuŋ ŋgar saghati. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Tauvene alup gham tomani zi sov. Ve gabua toozi naol isov to suŋuuŋ, ene areu mbirisai zi. Artaal toozi, tomania maet toozi patabuyaaŋa tau tipayooz zi igharau niazi to suŋuuŋ na, arav valaghin zi. Ve ai tau tiluplup zi ila sambazi ve tipait maaron livaa toozi Asera na, nakavasi ighan zi tizi. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Yam abees pa maaron ite paam sov. Pa yau Yoova ta Maaron tsiam. Matag pariuriu, ve naghe yam abees pa yau mon. Tauta tiwatwaat ezag tighe ‘I tau maata pariuriu.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Tauvene ambu saveeŋ tomania taan tawe tamtamona to avalupu gham sov. Pa isaav ighe yes tigham watooŋrau pa maaron karomŋa toozi, ve tilup zi pa ghanghaniiŋ, ve tipoi gham to ala tomani zi, ene aat yamŋa aghan aniiŋ to watooŋrau toozi tawe. Ve isaav ighe agham tauvene, yam amin maaron karomŋa toozi tawe lezi, ve aghur murimim payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Natumimŋa tauvene paam. Tivai zeran tawe natuzlivaŋa sov. Pa isaav ighe zilivaa tawe tibees pa maaron karomŋa toozi, ene pale tigherev natumimŋa to tila tibees pa maaron karomŋa tawe, ve tighur murizi payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Agham ain, gol, ma silva, ve agharaat gabua eta imin maaron payam to apakuru sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ve matamim iŋgal lupuuŋ tiina to ghaniiŋ mberet tau le yis mako na. Yam apul Isip pa kaiyo Abib. Tauvene ndaman isov, ighe tazaa pa kaiyo tana, yam aat alup gham pa ghaniiŋ mberet tau le yis mako na irau mboŋ liim ve ru itaghon aliŋag. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Natmimŋa zitamoot tau aidabazŋa na, tomania ŋgai tsiam natŋa tau tipoop zi imin maata na, ene tisov timin leg mon. Tauvene ŋgai tsiam natŋa zitamoot tau tipoop zi imin maata na, arav zi tisov timataar timin watooŋrau payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Eemon doŋki natŋa tau tipoop zi imin maata na, arav zi timin watooŋrau payau sov. Aravol zi pa sipsip, ve arav zi timin watooŋrau payau. Leso agham mulin doŋki tsiam. Ve isaav ighe aravol zi mako, na arav polin luazi timaat. Ve natmimŋa aidabazŋa tauvene paam. Aravol zi pa sipsip, leso agham mulin zi. “Tamtamon eta niima ŋginaaŋa, ve ilam ivot naghog to isuŋ payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Uraat imin ee, ila imuul uraat imin liim ve ee, yam aat agham lemim uraat. Eemon saawe imin liim ve ru, yam agham uraat sov. Amariau. Saawe to vazoghiiŋ ve taitaiŋ paam, yam aat matamim iŋgal saawe tana ve amariau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ndaman isov, saawe to Pasova ighe isov, ve wik liim ve ru ilam ila ve aniiŋ wit maata ivot, mako yam asov alup gham pa suŋuuŋ. Ve isaav ighe ndaman igharau ighe isov, ve saawe to mariri ivot, na yam asov alup gham pa suŋuuŋ muul. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Yau Yoova tau Tiina to yam Israela. Tauvene ndaman isov, isaav ighe tazaa pa saawe tintiina tol tane, mako zitamoot tsiam tisov aat tilam tilup zi ila naghog, ve tisuŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“Yau pale namuuŋ payam ve naziir tamtamon tisov tighau pa taan tau naghe nagham payam na, leso imin lemim motot. Ve yau aat naseeŋ taan tsiam imin tiina. Isaav ighe saawe tintiina tol tane tivot, ve yam asov apul nugh tsiam tsiam, ve alam alup gham ila naghog pa suŋuuŋ, na agham ŋgar naol pa taan tsiam sov. Pa tamtamon eta irau loolo ipazaagha pa ghamuuŋni sorok mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Siŋ to watooŋrau tau yam aghe agham payau na, alupu tomania mberet tau yis igheen ila na sov. Ve saawe tau alup gham pa ghanghaniiŋ to Pasova, ve arav gabua siriv imin watooŋrau, na apul sirivu igheen le nughizau sov. Ighe sirivu igheen, aghuru ila yav ighan suvinia le isov, o nughizau. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Aniiŋ maata tau ivot ila taan tsiam na, yam aat avureer popoia mon, ve agham zi tilam rumei to Maaron tsiam Yoova. “Isaav ighe anaz mekmek naatu eta, na anazu tomania tuz to tiina sov.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yoova isaav muul pa Mose ighe: “Saveeŋ tsiau isov tane, taum ubodeer zi. Pa saveeŋ tau itiŋa tambua to tavalupu ghiit tamin eemon, ene iyooz izala saveeŋ tane.” ");
INSERT INTO tuc_t_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose ileep tomania Yoova izi loloz daaba irau mboŋ tamoot ru (40). Saawe tana, i ileep sorok. Ighan aniiŋ eta mako, ve ighun yaa mako. Ve iŋgeret tutuuŋ saŋavul ila maet babaŋazi ru. Tutuuŋ tawe isavia eez to titaghoni, leso lupuuŋ toozi tomania Maaron igheen tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mose igham maet babaŋazi ru tau tutuuŋ saŋavul igheen ila na, ve imuul izila. Maet ru tawe, to ipalot yes Israela, leso matazi kisin saveeŋ mbuaaŋ toozi tomania Yoova ve titaghon duduŋaini. Saawe tau Mose ipul loloz Sinai daaba ve izila, naagho isul tiina kat. Eemon i tauu iwataghi mako. Naagho isul pasaa, yesuru Yoova tilup zi ve tisavsaav. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mose ila ivot to yes Israela, ve Aron tomania eval tiina tighita naagho isul. Tauvene tiroi pani, le tila tigharauu mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Eemon i ipoi zi ighe tilam, tauta Aron igham yes daaba to Israel, ve yesŋa tila to Mose. Ra Mose isavsaav tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Le isov, ra eval tiina anazi tilam tigharauu, ve i ipaesia saveeŋ isov tau Yoova isavia pani izi loloz Sinai daaba na, ve aavo iyaryaaŋ pazi leso titaghon duduŋai saveeŋ tana. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Isavsaav pazi le isov, ra ipoon naagho pa uuli. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Eemon saawe isov tau ighe iloŋ ila balbaal to Yoova, mako igham uuli tawe izi pa naagho, ve yesuru Yoova tisavsaav. Tisavsaav le isov, mako ivot ila muuri, ve ipaesia saveeŋ tau Yoova isavia pani na pa yes Israela gha tilooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Saawe tau i ivot ila muuri, mako yes Israela tighitghita naagho isul. Tauta Mose iponpoon naagho, ve ilepleep le saawe tau ighe imuul iloŋ ila balbaal, mako igham uuli tawe izi pa naagho, ve yesuru Yoova tisavsaav. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ra Yoova isaav pa Mose ighe: ");
INSERT INTO tuc_t_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ndaman tau naghoon ne, kaiyo tau imuuŋ pani, ve saawe imin maata, mako upayooz balbaal patabuyaaŋ. Leso imin niag to lepoogh, ve itiŋa taluplup ghiit iloŋ ila pa savsaveeŋ. Ugham tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Bokis to Saveeŋ Mbuaaŋ tau tutuuŋ tsiau igheen ila loolo na, ughuru imuuŋ iloŋ ila balbaal loolo ta muŋgaaŋ we. Tutuuŋ tana isavia eez to ataghoni leso lupuuŋ toit igheen tuŋia. Mako udaad uuli tiina ila balbaal loolo to ipoon bokis tawe. Balbaal loolo tiina tau igheen potla na ene patabuyaaŋ. Ve loolo marani tau bokis tana igheen pani na, ene patabuyaaŋ le patabuyaaŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","“Udaad uuli le isov, mako ughur boor to mberet patabuyaaŋ iloŋ ila balbaal loolo tiina tau igheen potla na, ve ughur mberet patabuyaaŋ izala. “Le isov, mako upayooz lam aia iloŋ ila, ve ughur lam liim ve ru ila niazi. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Mako ugham artaal gol marani to tunuuŋ gabua tau vazizi popoia na, ve ughuru iloŋ ila balbaal loolo tiina izaŋar Bokis to Saveeŋ Mbuaaŋ. Uyauur saveeŋ mariŋ to balbaal loolo iloŋ ila le isov, mako udaad uuli tiina ite gha ipoon balbaal naagho. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Mako ughur artaal tiina to watooŋrau igheen soghan rig pa balbaal naagho, ");
INSERT INTO tuc_t_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ve ughur oon tiina to ririwaaŋ igheen bodbodaaŋ pa balbaal naagho ve artaal tiina, ve uliŋ yaa ila loolo. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Mako udaad uuli mamalaua ilivutin balbaal, ve udaad uuli ariaaŋa ila sirsiir aavo imin ataman pani. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Upasov uraat naol tana le isov, mako ugham ŋgoreeŋ, ve uliŋi izala balbaal tomania saveeŋ mariŋ tau tigheen iloŋ ila loolo na, leso ughur zi timin leg. Gabua isov tana, ena patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","11","Le isov, mako uliŋ ŋgoreeŋ izala artaal tiina to watooŋrau, tomania saveeŋ mariŋ to uraat, ve oon to ririwaaŋ, tomania boor tau oon tana igheen izala paavo na paam. Leso ughur zi timin leg. Artaal tana, ene patabuyaaŋ le patabuyaaŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Upasov uraat naol tana le isov, mako ugham Aron tomania natŋa zitamoot tilam tigharau ataman aavo to balbaal patabuyaaŋ, ve urughuuz zi. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Urughuuz zi le isov, mako unonogh Aron pa nonoghiiŋa tooni patabuyaaŋ to uraat, ve uliŋ ŋgoreeŋ izala daaba to ughuru imin leg. Leso imin ŋeer to watooŋrau ve ibesbees payau. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mako ugham natŋa anazi tilam, ve unonogh zi pa nonoghiiŋa toozi to uraat paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ve uliŋ ŋgoreeŋ izala dabazi imin ugham pa tamazi. Leso timin zeran to watooŋrau ve tibees payau. Yesŋa paaghu toozi tau murei pale tivot na, aat tikis uraat tane, taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Yoova isavsaav le isov, ra Mose ipaburigin uraat. I igham uratoi gabua naol isov tawe itaghon saveeŋ tau Yoova isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tauvene saawe tau yes Israela tivool pa ndaman paaghu, saawe imin maata to kaiyo tau imuuŋ pa ndaman tana na, tipayooz balbaal patabuyaaŋ to Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","19","Tipayooz rir, mako tighur didiiŋaia izala pavozi. Ve tizeev sandiiŋ itaghon puura tau kiriiŋ pataghaaŋ ila didiiŋaia na, leso ikis didiiŋaia tiyooz tuŋia. Ve tipayooz rir mamalaua paaŋ ila pa balbaal naagho, ve tiraraav uuli tintiina siriv izala balbaal paavo, itaghon Yoova aliiŋa tau isavia ila to Mose na. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ra Mose igham maet ru tau tutuuŋ to Yoova igheen ila na, ve ighur zi ila Bokis to Saveeŋ Mbuaaŋ loolo. Maet ru tawe, ene to ipalot yes Israela, leso matazi kisin saveeŋ mbuaaŋ toozi tomania Yoova ve titaghoni. Ve Mose izeev siŋ ru itaghon niazi tau igheen Bokis To Saveeŋ Mbuaaŋ ziige leso tibaado. Ve ipagud bokis aavo. Bokis aavo tawe, ene tiwaato tighe ‘Nugh To Rewaaŋ Sosor.’ ");
INSERT INTO tuc_t_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ra Mose ighur Bokis to Saveeŋ Mbuaaŋ iloŋ ila balbaal loolo, ve idaad uuli tiina ee, leso ipoona itaghon Yoova aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","23","Le isov, ra ighur boor to mberet patabuyaaŋ iloŋ ila balbaal loolo tiina tau igheen potla na. Igheen ila ziige ila pa kaagu. Ve ighur mberet patabuyaaŋ izala, leso igheen ila Yoova naagho, itaghon Yoova aliiŋa tau isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ra igham lam aia iloŋ ila balbaal loolo tiina, ve ipayooze ila ziige tau ila pa daudau, ve itoora le izaŋar boor to mberet patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ve iraar lam liim ve ru izala, leso tisul ila Yoova naagho, itaghon Yoova aliiŋa tau isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ra ighur artaal gol marani to tunuuŋ gabua tau vaazi poia na ila igharau uuli tiina tau iŋgat balbaal loolo. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ve itun gabua tau vaazi popoia izala, itaghon Yoova aliiŋa tau isavia pani na. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mose igharaat balbaal tomania gabua naol isov tau tigheen iloŋ ila na le isov, ra idaad uuli tiina gha ipoon ataman aavo, ve igham uraat to muuri. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ighur artaal igharau sirsiir to balbaal patabuyaaŋ atamana, ve igham watooŋrau siriv itaghon Yoova aliiŋa tau isavia pani na. I indav ŋgai siriv izala artaal, ve indav aniiŋ wit siriv imin watooŋrau paam. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","32","Le isov, ra ighur oon tiina igheen bodbodaaŋ pa balbaal naagho ve artaal tiina, ve iliŋ yaa ila loolo. Leso saawe tau i tauu, ma Aron, ma Aron natŋa tiloŋ tila balbaal loolo, ma tigharau artaal, mako timin nimazi ve aghezi pa yaa tawe. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Igham uraat tana le isov, ra idaad uuli mamalaua ilivutin balbaal tomania artaal tiina imin sirsiir, ve idaad uuli ariaaŋa ee imin ataman to sirsiir tawe. Tauvene uraat naol isov tau Yoova isavia na, Mose igham uratoini le isov. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Ra taitai tau Yoova ileep ila na, izilam le itav balbaal patabuyaaŋ, ve Yoova mbonari isul toman tapiri tiina irau balbaal loolo. Tauvene Mose irau iloŋ ila mako. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Saawe tau yes Israela tilaghlaagh izi nugh ŋginaaŋa, matazi ilala pa taitai tawe. Isaav ighe ipul balbaal patabuyaaŋ paavo ve izuur ila, ene yes paam tiburig, tiyauyau, ve tilaagh titaghoni. Ve isaav ighe iyooz tuŋia izala balbaal paavo, ene irau tilaagh mako. Tileep ve tisasaŋan le tighita taitai izuur muul, mako tiburig tilaagh. ");
INSERT INTO tuc_t_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tauvene saawe tau yes Israela tilaghlaagh izi nugh ŋginaaŋa, matazi ilala pa taitai tawe ve titataghoni. Ighe mataaz, mako tisov tighita taitai tau Yoova ileep ila na, iyozyooz izala balbaal patabuyaaŋ paavo. Ve ighe mboŋ, mako tighita taitai tawe isul imin yav. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Muuŋ kat, yes Israela lezi kinik mako, ve tamtamon toozi siriv timin daaba pazi ve tiŋgin zi. Saawe ee, pitool tiina ivot. Saawe tana, ŋeer ee ilepleep, eeza Elimelek, ve azaawa eeza Naimi. Ve natuzŋa zitamoot ru, ee eeza Malon, ve ite eeza Kilion. Rumei toozi Eprata. Nugh toozi, ene Betelem tau igheen ila taan sirivu to Yuda. Saawe tau pitool tiina tana ivot, Elimelek yesuru azaawa ve natuzŋa ru tipul Betelem, ve tila tileep izi taan sirivu to Moap. Tilepleep ta sewe irau ndaman siriv. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ra Elimelek imaat, ve Naimi tomania natŋa ru tana, yes mon tileep. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Naimi natŋa tivai Moap tinazi ru. Ee eeza Opa, ve ite eeza Rut. Yes tileep ta sewe irau ndaman saŋavul, ra Malon yesuru Kilion anazi timaat. Tauvene Naimi imin naar ve imin kakam. Le azaawa mako, ve le natŋa paam mako. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naimi ilepleep izi Moap, ve ilooŋ tighe Yoova iuul tamtamon tooni Israela gha igham mariri tiina ivot pazi. Tauvene Naimi tomania raulivaŋa ru tiburig tipul taan to Moap, ve tighe timuul tila pa nugh puughu to Naimi. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tipul nugh tau tilepleep pani na, ve titaghon eez tau ila pa taan sirivu to Yuda. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Tilaghlaagh tila ve Naimi isaav pa raulivaŋa ru ighe: “Aa, yamru amuul ala pa tinamimŋa ve aleep tomani zi. Yamru tane lolomim isaghav ghau tomania zeran toit tau timaat ne, ve agham poghani ghei kat. Tauvene yau nasuŋ Yoova naghe i igham poghani gham paam. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","10","I tauu pale iuul gham ve avai muul. Leso azuwamimŋa matazi payam ve aleep poia.” Naimi isavia saveeŋ tane le isov, ve tomania raulivaŋa tivasaghavu zi ve titaŋ tiina. Titaŋtaŋ le isov, ra raulivaŋa tisaav pani tighe: “Mako. Itiŋa tala pa ziiri waaro tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Eemon Naimi iyol aliŋazi ighe: “Natuglivaŋa, yamru amuul ala pa nugh tsiam. Azoornugh aghe itiŋa tala pasaa? Aghita. Yau irau napoop zitamoot ruta muul to tivai gham ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Amuul ala pa nugh tsiam. Pa yau namin olman tinazi wa. Irau navai muul mako. Isaav ighe yau navai pa mboŋ ta aazne ve napoop zitamoot ru, ");
INSERT INTO tuc_t_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","irau yamru alepleep ve asasaŋan zi le timin zolman, o avai zi? Mako. Aa natuglivaŋa, yau lolog isaghat kat. Pasaa, pataŋani tiina tau Yoova igham payau, ene izaa tsiam paam.” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Yesuru tilooŋ saveeŋ tooni tane, ve tipaburigin taŋiiz muul. Titaŋtaŋ le isov, ra Opa isaghav rauliva, ve ipul zi, ve imuul ila pa nugh tooni. Eemon Rut loolo isaghav rauliva Naimi kat. Tauta loolo pa ipuli mako. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tauvene Naimi isaav pani muul ighe: “Ughita! Tazimliva imuul ila pa tamtamon tooni ve maaron tooni wa. Utaghoni ula.” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Eemon Rut iyol aliiŋa ighe: “Uzoornugh ughe napul ghom pasaa? Yau irau napul ghom ve namuul nala mako. Nugh sindei tau yo ughe ula pani, yau aat nala paam. Ve nugh tau yo uleep pani, ene yau aat naleep pani paam. Tamtamon tsio, ene yau tamtamon tsiau paam. Ve Maaron tsio, ene Maaron tsiau paam. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Saa nugh tau yo uleep pani ve umaat, ene yau paam aat namaat ve titavi ghau tomani ghom izi ta sena. Saveeŋ isov tau yau nasavia ne, isaav ighe nataghoni mako, ene aat Yoova tauu ighur atuya izaa tsiau. Tauvene mateegh mon ta pale irav motin ghiit.” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naimi ighita ighe Rut ŋgar tooni iyaryaaŋ kat ighe yesuru tila. Tauvene i le saveeŋ eta muul mako, ve iyok pani gha yesuru tila. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yesuru tilaagh tila le tivot nugh Betelem. Eval tiina to Betelem tighit zi ve tisaŋeeŋ pazi. Ve zilivaa siriv tighason tighe: “Wai, aghita. Ewe Naimi?” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Eemon Naimi iyol aliŋazi ighe: “Yam awaat ezag Naimi muul sov. Awaat ezag ‘Mara.’ Pa Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na, igham lepoogh tsiau isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Saawe tau yau napul nugh tane ve nala, narao pa gabua ta naol ne. Eemon aazne, Yoova igham ghau namuul nalam toman nimag ŋginaaŋa. Tauta naghe awaat ezag Naimi sov. Pa Maaron Saksaki Tau Iliiv Zimaronŋa Tisov na ighur pataŋani tiina izaa tsiau ve ivaghamun ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ene sinaiŋ to Naimi tau ipul taan to yes Moapa, ve yesuru rauliva Rut tau Moap tinazi na, timuul tila pa Betelem. Saawe tana, ene saawe to tiyau aniiŋ bali anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ŋeer ee ilepleep Betelem, eeza Boas. Yesuru Naimi azaawa Elimelek, siŋ eemon. Boas, i kuaz tauu, ve eval tiina titandagh pani tighe i eeza tiina. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Saawe ee, Rut isaav pa Naimi ighe: “Ene saawe to ravuuŋ aniiŋ bali. Mindai, irau nala nataghon yes uraata siriv ve isaav ighe lolozi isaghatin ghau, o nayau leen bali siriv tau titaptap tizi?” Naimi iyol aliiŋa ighe: “Natugliva, ene poia. Ula.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tauvene Rut ila uum bali ee, ve itaghon yes uraata, ve iyau le bali. I iwatagh uum tawe taama mako. Eemon i ila le iduduuŋ pa uum bali to Boas. Boas yesuru Elimelek, yes siŋ eemon. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Malau mako ve Boas ipul Betelem ve ila ighe ighita yes uraata tooni. I ila ivot toozi, ve isaav pazi ighe: “Yoova ileep tomani gham.” Yes tiyol aliiŋa tighe: “Poia to Yoova izaa tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ra Boas ighason besooŋa tooni tau iŋginŋgin yes uraata na ighe: “Saa livaa paaghu tawe? I ileep to sei?” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Besooŋa tana iyol aliiŋa ighe: “Ewe Moap tinazi tau ipul nugh tooni ve yesuru Naimi tilam. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","I ighason ghau ighe irau ila itaghon yes uraata ve iyau le bali siriv tau titaptap izi taan na. Tauta nayok pani. Ta mboŋoozo kat ve ilam, i inoknok ghamuuŋ uraat. Tauta ŋgarig gha ila yavyaav ve imariau.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boas ilooŋ saveeŋ tane, ve ila isaav pa Rut ighe: “Natugliva, ulooŋ. Yo irau upul uum tane, ve ula uum bali to ŋeer ite paam mako. Uleep ta sene mon, ve yamŋa uraata tsiau zilivaa agham uraat. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Matam ila pa uraata tsiau mon. Isaav ighe tiburig muul pa ravuuŋ bali sindei, mako ula utaghon zi. Yau naŋgalsekin uraata tsiau wa. Irau tigham saghatin ghom mako. Ve isaav ighe murun ghom, na ula ughun yaa tau besooŋa titivu izila yaa paatu gha ighengheen we.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut ilooŋ saveeŋ tane, ve iput aaghe, naagho izila pa taan, ve isaav pa Boas ighe: “Wai, yau loom tinazi. Mindai ta yo ugham ŋgar tiina payau ve ughe ugham poghani ghau?” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas iyol aliiŋa ighe: “Yau nalooŋ varum wa. Saawe tau azuwam imaat ve ilam, yo ugham poghania rawam livaa kat. Ve yo upul tamam, tinam, taan tsio ve nugh tsio, ve ulam uleep tomania tamtamon tau muuŋ yo uwatagh zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Yo ulam uleep ta sene, leso Yoova tau Maaron to yes Israela na, maata payo ve uyooŋ ila niima saamba. I iwatagh ŋgar poia tau yo ughamu na. Tauvene i aat igham lem atuya poia kat, ve igham poghani ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut iyol Boas aliiŋa ighe: “Tiina tsiau, yo ugham poghani ghau kat. Yau livaa sorok. Yau namin uraata tsio zilivaa tawe ne mako. Eemon lolom isaghatin ghau, ve usavia saveeŋ popoia payau. Tauta ugham lolog poia kat.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Saawe to tighan aniiŋ, Boas ipoi Rut ighe: “Ai, ulam ugham lem mberet siriv, ve uzeeva ila sur loolo, ve ughan.” Tauvene Rut yesŋa yes uraata mbolezi izi, ve Boas igham bali mazooza siriv pani. Rut ighamu ve ighani le aapo isuŋ, ve aniiŋ tooni sirivu igheen. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Tighan le isov, ve Rut imuul ila pa uraat. Boas isaav ariaaŋ pa yes uraata tooni ighe: “Isaav ighe Rut iyau bali ila le igharau pa bali poos eta, na ayau avomim pani sov. Apuli ve iyau. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ve saawe tau apoos bali, na apas siriv ve asuruuv zi tizi taan. Leso i ilat iyau zi. Ve matamim iŋgal: Ayau avomim pani sov.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Tauvene Rut iyauyau bali le ravrav izi. Ra indou zi, ve ilos zi gha anoŋazi timburur tizi, ve ikor zi ila nakaral loolo. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ra igudu ve imuul ila pa nughei, gha itotoia pa rauliva. Ve aniiŋ mazooza tau i ighani ve sirivu igheen na, i igham pani paam. ");
INSERT INTO tuc_t_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tauvene Naimi ighasoni ighe: “Laak, aazne yo uyau bali tane izi sindei? Yo ugham uraat ila uum to sei? Ŋeer tau maata iŋgal ghom ve iuul ghom na, poia to Yoova aat izaa tooni.” Rut iyol aliiŋa ighe: “Aazne, yau nagham uraat ila uum to ŋeer ee, eeza Boas.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Tauvene Naimi isaav pani ighe: “Yoova pale ighur poia tooni izaa to Boas ve igham poghania! Ŋgar to Yoova tau loolo isaghav tamtamon tooni ve iuluul zi, ene isov mako. Saawe isov, i maata iŋgalŋgal yes mateegha ve iit tau talepleep ne paam.” Ve Naimi isaav muul ighe: “Ŋeer tawe, yesuru Elimelek toŋvetaz. Yesuru siŋ eemon. I aat iyooz pait ve iuul ghiit pa pataŋani toit.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ra Rut isaav muul ighe: “Ve gabua ite. Boas isaav payau ighe irau yeŋa uraata tooni zilivaa nighamgham uraat tauvene le saawe to bali isov.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naimi isaav pa Rut ighe: “Natugliva, ughita. Ene poia kat. Yamŋa uraata zilivaa to Boas aghamgham uraat ila uum tooni mon. Ula pa uum to ŋeer ite paam sov. Pa undeeŋ pataŋani ma vene.” ");
INSERT INTO tuc_t_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tauvene Rut yesŋa uraata zilivaa to Boas tighamgham uraat le saawe to ravuuŋ bali ve wit isov. Saawe tana, Rut ileep tomania rauliva. Ipuli mako. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Tilepleep le saawe ee, Naimi isaav pa Rut ighe: “Natugliva, yau naghe nail lem ŋeer eta leso iŋgin ghom ve uleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ulooŋ. Boas, tau yamŋa uraata tooni zilivaa aghamgham uraat na, i yesuru rawam Elimelek siŋ eemon. Mboŋ aazne, i pale igham uraat izi nugh to tiriiŋ bali. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Tauvene ula uririu, ve ugham naunauŋ vaazi poia ila tinim, ve unonogh ghom pa nonoghiiŋa poia eta. Ugharaat ghom le isov, mako ula ughita Boas izi nugh to tiriiŋ bali. Eemon ula utotoi taum pani rekia sov. Ulepleep ve matam ilala pani. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Saawe tau i igham uraat tooni isov, ve ighan ma ighun le isov ve ighe igheen, mako matam kisin nugh tooni to ghenooŋ. Usaŋani le igheen loolo iveegh, mako ula uit kaukauŋa pa aaghe izaa, ve ugheen izi aaghe puughu. Ve ighe i isavia saveeŋ eta payo, mako ulooŋ aliiŋa ve utaghoni.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut iyol aliiŋa ighe: “Poia. Saveeŋ isov tau yo usavia ne, pale nataghoni.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Tauvene Rut iburig, ve izila pa nugh to tiriiŋ bali, ve igham gabua isov imin tau rauliva isaav pani. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas ighan ma ighun le isov, ra loolo poia kat, ve ila igheen izi bali ndouŋ ziige. Ra Rut ipas ghi poipoi ila gha iit kaukauŋa pa Boas aaghe izaa, ve izi igheen ta Boas aaghe puughu. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Boas ighengheen le mboŋ anooŋa, ra irur iburig ve ighe itoor ghi, le ighita livaa ee ighengheen izi aaghe puughu! Tauvene ighasoni ighe: ");
INSERT INTO tuc_t_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Aa, yo sei?” Rut iyol aliiŋa ighe: “Tiina, ene yau, besooŋa tsio Rut. Irau yo utir kaukauŋa tsio maata izala pavog? Pa yamru Elimelek siŋ eemon. Tauvene yo aat uyooz payau ve uul ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas isaav pani ighe: “Natugliva, poia to Yoova pale izaa tsio. Ŋgar tau yo ughamu ne, ene itaghon katin ŋgar to loloon isaghav ziiri waaro toit. Ve iliiv ŋgar popoia siriv tau yo ughamgham pa rawamliva Naimi. Pasaa, zitamoot paghpaaghu katini tilepleep. Siriv kuaz tauŋa, ve siriv mbolaaŋa. Eemon yo ugham ŋgar pa toozi eta mako. Yo uŋarui ghau pasaa, yau ziiri waaro to azuwam. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Natugliva, uroi ve ugham ŋgar naol sov. Gabua isov tau yo ughason ghau pani na, yau aat naghamu. Pasaa, tamtamon to nugh tane tisov tiwatagh tighe yo livaa poiam kat. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Saveeŋ tsio, ene onoon. Yau yeiru azuwam tau imaat na, puughu tsiei eemon. Tauvene yau irau nayooz payo ve nauul ghom. Eemon puughu tsiau soghan rig. Ve ŋeer ite ilepleep. Puughu tooni igharau kat pa azuwam. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Uleep ta sene le nughizau. Mboŋoozo, yau pale nala napalooŋ ŋeer tawe: Pale itaghon ŋgar to toŋvetaz ve iuul ghom, ma mako? Ighe gabua ighur poi, ene poia. Ve ighe mako, yau taug pale nayooz payo ve nauul ghom. Saveeŋ tane, yau nambua iyaryaaŋ ila Yoova tau Maaron maata yaryaare na maata. Aiyo, yo aat ugheen ta sene le nughizau, o ula.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tauvene Rut igheen izi Boas aaghe puughu le nughizau. Mboŋoozo, ta ndoroome soone, ve i iburig ighe imuul ila pa nughei. Leso tamtamon eta ighita sov. Pasaa, Boas isaav pani ighe: “Yau lolog pa tamtamon tiwatagh tighe yo ulam tsiau izi nugh to uraat ne mako.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ve Boas isaav pani ighe: “Ugham nonoghiiŋa tsio to ŋgoaaŋ ve uraraava.” Tauvene Rut iraraav nonoghiiŋa tooni, ve Boas ikor bali anooŋa izila le ivon. Ra iiti izala Rut daaba, ve i igudu gha imuul ila pa nughei. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut ila ivot to rauliva, ve i ighasoni ighe: “Natugliva, taum tana? Mindai?” Ra Rut ipaesia gabua isov tau Boas igham pani. ");
INSERT INTO tuc_t_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ve isaav muul ighe: “Ughita. I igham leen bali anooŋa tane paam. Pasaa, loolo pa nimag ŋginaaŋa ve namuul nalam tsio sov.” ");
INSERT INTO tuc_t_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naimi ilooŋ saveeŋ tooni, ve isaav pani ighe: “Natugliva, atem izi. Uleep ve taghita saa ŋgar tau pale ivot. Aazne, Boas irau mboole izi mako lee igharaat saveeŋ tane gha iduduuŋ.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Saawe tana, Boas malmali ila nugh to lupuuŋ tau igheen igharau eez maata na, ve mboole izi ta sewe. Malau mako ve ŋeer tau Boas isavia pa Rut na, ilam. Ŋeer tawe, yesuru Elimelek siŋ eemon. Boas ighita, ve isaav ila pani ighe: “Ai toghag, ulam mbolem izi. Pa yau leg saveeŋ payo.” I ilooŋ aliiŋa, ve ila mboole izi. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ra Boas ila iyau zolman saŋavul to nugh Betelem tilam, ve isaav pazi ighe: “Alam mbolemim izi ta sene.” Tauvene zeran tawe tila mbolezi izi tomania. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ra Boas ipaburigin saveeŋ pa toogha tana ighe: “Ughita. Naimi ta ŋgarig ipul taan to yes Moapa ve imuul ilam na, i ighe igholia taan to ziiri waaro toit Elimelek. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Tauta nasaav payo pani. Ighe lolom pa taan tawe, na ugholi ila yes zolman ve tamtamon siriv tau itiŋa talepleep ne matazi. Pa puughu tsio igharau kat pa Elimelek, ve yau nataghon ghom. Tamtamon ite paam mako. Tauvene yo irau ughol taan tooni. Ve isaav ighe lolom pa taan tawe mako, usaav ghazooŋa payau ve nalooŋa. Leso nagholi.” Ŋeer tana iyol aliiŋa ighe: “Poia. Pale nagholi.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Tauvene Boas isaav pani muul ighe: “Poia. Isaav ighe ughol taan tawe ila to Naimi, na yo aat ugham naar Rut, tau Moap tinazi na paam imin azuwam, ve uŋgini. Leso taan tawe tauŋa tau timaat na, ezazi iyozyooz pa taan toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ŋeer tana ilooŋ saveeŋ tane, ve isaav ighe: “Ee-e, yau irau nagholi mako. Onoon, yau irau nayooz pa Naimi ve nauule. Eemon irau nasakia taan ma gabua tsiau siriv ila pa ŋeer ite natŋa mako. Tambaaŋo, yau naleep, ve yo ugholi.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Muuŋ, yes Israela gabuazi tauvene: Isaav ighe tighol taan eta, ma tiparavol pa gabua siriv, ene toozi ee ipas zuzuuŋa to aaghe izi, ve ighamu ila to iitete tau yesuru tiparavolia gabua toozi na. Leso ipariaaŋ saveeŋ mbuaaŋ toozi.) ");
INSERT INTO tuc_t_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Tauvene Boas toogha tau irau iyooz pa Naimi na, isaav pani ighe: “Yo taum ughol taan tawe.” Ve ipas zuzuuŋa to aaghe gha igham pa Boas. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ra Boas isaav pa yes zolman ve tamtamon siriv tau tileep tomani zi na ighe: “Aazne, yam aghita pa matamim wa. Gabua isov to Elimelek toman natŋa ru Malon gha Kilion, ene yau aat nagholi ila to Naimi. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ve Moap tinazi Rut tau Malon naar tooni, i paam, yau aat naghamu imin azuwag. Leso Elimelek ve natŋa ru tau timaat na, ezazi iyozyooz pa taan toozi, ve toŋvetaz toozi tomania nugh toozi puughu paam matazi kisin ezazi taghon taghon gha ila. Aazne, yam asov aghita pa matamim.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yes zolman ve tamtamon siriv tau yesŋa tilepleep nugh to lupuuŋ tawe tighe: “Onoon! Yei nighita pa matamai wa. Azuwam paaghu tawe, ighe ilat ruum tsio, ene Yoova pale iuule ve ipoop tamtamon naol imin muuŋ igham pa timbuun livaŋa ru, Rael gha Lea, tau tipoop iit Israela puughu toit. Ve yo pale umin tiina izi Eprata, ve lem ezam tiina izi Betelem. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Yoova pale igham azuwam paaghu tana ipoop lem natumŋa katini. Leso ziiri waaro tsio timasa timin naol imin Yuda gha Tamar natuzi Peres paaghu tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Tauvene Boas igham Rut gha imin azaawa. Yoova iuul Rut gha aapo, ve ipoop naatu tamoot ee. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Tauvene Betelem tinazi tisaav pa Naimi tighe: “Tapait Yoova eeza! Pa i ipul ghom uleep sorok mako. Aazne, igham lem timbum poia ee. Murei, marani tane ighe imin olman, i aat iyooz payo ve maata payo. Ve yes Israela pale tighita tighe i eeza tiina. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Rawamliva Rut loolo igheen tsio kat. Onoon, yo lem natum tamoot eta muul mako. Ve isaav ighe yo lem natumŋa zitamoot liim ve ru, yes irau tiuul ghom imin rawamliva tane mako. Ughita. Aazne, i ipoop lem timbum poia ee. Murei, saawe tau umin kooŋ, yo aat uleep ila timbum tane niima, ve lepoogh tsio pale poia kat.” ");
INSERT INTO tuc_t_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ra Naimi iburig gha imbaraar marani tana, ve igham payamyam pani. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Tauvene Betelem tinazi tisaav tighe: “A ŋgarig gha Naimi igham le paaghu ee wa.” Ve tiwaat marani tana eeza Obet. Obet tane ta naatu Yesi. Ve Yesi naatu, ene kinik David. ");
INSERT INTO tuc_t_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Ene pitiiŋ to Peres paaghu tooni: Peres naatu, ene Ezron, Ezron naatu Ram, Ram naatu Aminadap, Aminadap naatu Nason, Nason naatu Salmon, Salmon naatu Boas, Boas naatu Obet, Obet naatu Yesi, ve Yesi naatu, ene David, tau imin kinik tiina to Israel. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Sei ta poia to Maaron izazaa tooni ve tintini? Ene ŋeer tau izorzor zeran sasaghatizi ŋgar toozi. Ve yes tau tisosor pa eez to Maaron na, i itaghon ŋgar toozi mako. Ve zeran tau tivevelegh Maaron paam, i ipaak zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Saveeŋ to Maaron tomania tutuuŋ tooni, ene ighamu loolo poia le poia kat. Ve ighamgham ŋgar pani irau mboŋ ve mataaz. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Tamtamon tauvene, i imin ai tau tivazoghi igharau yaa tau irereer. Saawe tooni to iyanooŋ, ene aat anooŋa popoia. Ve saawe to aaz tiina, raua irau imalai mako. Tamtamon tauvene, uraat tooni isov ilaan poia mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Eemon zeran sasaghatizi, lepoogh toozi tauvene mako. Yes timin pen tau ighe yaghur izaa, mako ivuvuura gha ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tauvene saawe tau Maaron igabiiz tamtamon ve ighur atuya pazi, zeran sasaghatizi pale lezi saveeŋ mako, ve titud mon. Zeran to ghamuuŋ sosor irau tileep tomania tamtamon duduŋazi ila lupuuŋ toozi ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Tauvene tamtamon duduŋazi, Maaron maata pazi, ve iŋginŋgin zi pa laghooŋ toozi. Eemon zeran tau titaghon eez saghati na, yes pale tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Puughu mindai ta nugh nugh timbu saveeŋ tighe tipaburigin malmal? Tamtamon tiliil eez to tigham taliiŋzizi pasaa? Ŋgar toozi tawe, tighamu sorok. Irau ighur mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Yes kinik to taan tigham aghezi tighe tigham malmal. Ve yes pooza tilup zi, ve tiil eez to tizoor Yoova ŋgar tooni ve titatan ŋeer tau i ighuru imin kinik. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Yes tighe: “Aiyo! Takuup ravraav tomania sen toozi tau tikau ghiit pani ne, ve tasik zi tila. Leso tiŋgin ghiit muul sov.” ");
INSERT INTO tuc_t_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Eemon Yoova, i ileep ila niia to ghamuuŋ pooz izi nugh sambam, ve iŋiŋ pazi. Ve maata veleghin ŋgar toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ra isaav ariaaŋ pazi toman aate yavyav, ve iparoi zi toman naagho isaghat. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ighe: “Yau naghur tamtamon tsiau ee igham naghog ve imin kinik. I ileep izi loloz tsiau patabuyaaŋ Zion, ve ighamgham pooz.” ");
INSERT INTO tuc_t_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kinik to iit Israela isaav tauvene: “Yau aat navotia saveeŋ tau Yoova imbua tomani ghau. I isaav payau ighe: ‘Yau natug yo. Yo tamam ta yau. Aazne, yau naghur ghom pa uraat. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ughason ghau, o yau nagham nughmariŋ timin lem. Tamtamon tau tileep irau taan ziige ta naol ne pale timin lem, ve uŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Pooz tsio pale ariaaŋa kat, imin titi to kinik tau tigharaata pa ain na. Yo aat urav matin kinik tisov tapirizi, imin uur tau tiravu le imbiriis ŋanŋania.’” ");
INSERT INTO tuc_t_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Tauvene, yam kinik asov agham ŋgar poi. Ve yam pooza to taan, alooŋ saveeŋ ve ayamaan gham. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Aroi pa Yoova ve abees pani. Atandagh pani ve apaiti toman tintinmim. ");
INSERT INTO tuc_t_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Aput aghemim pa Naatu, ve aleep ila i saamba. Mako pale Maaron aate yavyav payam, ve iburig ireu gham gha asov alalemim. Pasaa, i aate tuuku. Eemon yes tau tiyooŋ ila tooni na, poia tooni pale izaa toozi, ve tileep toman tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau David ighau pa naatu Absalom. O Yoova, yau koiagŋa katini. Eval tiina kat tiburig tighe tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Yes tisavsaav payau tighe: “Maaron ipul muuri pani wa. Irau iuule muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Eemon Yoova, yo umin sigheu payau ve upoon ghau. Yau tinig izaa pasaa, yo ugham ezag imin tiina, ve upalot ghau le naliiv koiagŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Yau nataŋ rarai Yoova toman aliŋag tiina naghe iuul ghau. Ve i ileep izi loloz tooni patabuyaaŋ, ve ilooŋ ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Tauvene yau nazi le nagheen kat. Pasaa, Yoova tauu iŋgin ghau pa ghenooŋ tsiau le naburig muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Isaav ighe koiagŋa ndiŋndiŋ ndiŋndiŋ saŋavul (10,000) tilivut ghau to tigham malmal payau, ene yau irau naroi pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","O Yoova, rekia mon uburig gha uul ghau! Urav koiagŋa azezi le livozi ipolpol. Ve urav matin tapirizi le isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yoova, yo mon ta irau ugham mulin ghau. Ughur poia tsio izaa to tamtamon tsio tisov, leso tintinizi ve tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Mbouŋ to David Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane O Maaron, yau nataŋ rarai ghom. Lolom isaghatin ghau, ve ulooŋ suŋuuŋ tsiau. Pasaa, pataŋani igham ghau ve leg eez mako. Upas ghau navot pa pataŋani tane. Leso upaghazoŋai ghau ila tamtamon matazi ughe ŋgar tsiau iduduuŋ ila yo matam. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Oyai, yam tamtamon tau atatan ghau ve avaghamunia ezag na, ŋeez o apul ŋgar tsiam tana? Yam aghur lolomim pa ŋgar soroksorok tau le anooŋa mako na, ve ataghon ŋgar karom. Ŋeez o apuli? ");
INSERT INTO tuc_t_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Yam awatagh: Yes tau lolozi isaghav Yoova ariaaŋ ve titaghon eez tooni na, i isiigh zi timin i tauu le wa. Tauvene saawe tau yau nataŋ raraini, i aat ighur taliiŋa payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Aroi pa Maaron, ve agham sosor muul sov. Saawe tau yam aleep ila niamim to ghenooŋ, aneneeŋ, ve matamim iŋgal taumim, ve agham ŋgar poi pa saveeŋ tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Anumeer Yoova ve agham watooŋrau pani toman lolomim. Leso watooŋrau tsiam iduduuŋ ila i maata. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Tamtamon naol tipasawal tighe: “Oyai, ŋeez o tagham lepoogh poia!” Eemon yau naghe: “Yoova, lolom poia payei, ve utotoi taum payei.” ");
INSERT INTO tuc_t_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Yo ugham ghau tintinig ve lolog poia kat, iliiv yes tau aniiŋ ve vaen anooŋa katini tivotvot ila uum toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Tauvene yau ateg izi ve nazi nagheen le lolog iveegh. Irau naroi mako. Pasaa, Yoova, yo taum matam payau ve uŋgin ghau naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Mbouŋ to David O Yoova, ughur taliŋam pa aliŋag, ve ulooŋ taŋiiz tsiau tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Yo kinik tsiau ve Maaron tsiau. Saawe isov, suŋuuŋ tsiau iŋaŋarui ghom. Tauvene ughur taliŋam pa taŋiiz tsiau tane ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yoova, mboŋoozo ta naol ne, yo uloŋlooŋ avog lutluutu. Ighe nughizau, yau naghurghur ghasoniiŋ tsiau iŋarui ghom, ve naghur matag payo to uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Maaron, yo lolom pa ŋgar saghati mako kat. Zeran sasaghatizi irau tileep tomani ghom mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ve zeran pakuruuŋa irau tiyooz ila yo naghom mako. Pasaa, yo ughurghur koi pa tamtamon tisov tau tighamgham ŋgar saghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Yes tau avozi karom na, yo ureu zi tilalez. Ve zeran tombanooŋa ve yes tau tiliŋliŋ siŋ pa tamtamon na, yo lolom pazi rigta mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Eemon yo lolom isaghav ghau ariaaŋ ve uluul ghau itaghon saveeŋ mbuaaŋ tsio. Tauta yau irau naloŋ nalat rumei tsio. Yau naroron payo, ve naput agheg payo ila rumei tsio patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Yoova, ŋgar tsio, ene iduduuŋ mon. Ugham pooz payau, ve upaghazoŋai ghau pa eez tsio, leso nataghon duduŋaini. Pa koiagŋa tighe tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Saveeŋ onoon eta irau ivot ila avozi ne mako. Lolozi isaghav ŋgar saghati mon to tivaghamun tamtamon. Yamazi itortoor saveeŋ. Avozi imin naal tau aavo ikakaak. Tisasavia saveeŋ ŋgoreeŋ naol to titombaan tamtamon ve tivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O Maaron, uvotia sosor toozi ivot ighazooŋ, ve ughur atuya pazi. Ŋgar sasaghati tau tighamghamu na, upamuule ila pa tauzi ve ivaghamun zi. Saawe isov, yes timamalaaŋ pa tutuuŋ tsio. Tauvene uziir zi tilalez. Pa yes tizorzoor ghom, ve tighamgham taliiŋzizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Eemon tamtamon tisov tau tiyooŋ ilat tsio, ene aat tintinizi. Yes pale timbou toman lolozi poia irau saawe. Yes tau lolozi igheen tsio na, uvool toozi ve upoon zi. Leso lolozi poia kat ve tipait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","O Yoova, poia tsio izazaa to yes tau titaghon duduŋai saveeŋ tsio. Yo lolom pazi ve poia tsio imin sigheu pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Mbouŋ to David Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane O Yoova, uyaon ghau toman atem yavyav sov. Ve isaav ighe yo ughur pataŋani iŋarui ghau to upaduduuŋ ghau, na ughamu toman atem yavyav kat sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yoova, yau besooŋa tsio. Lolom isaghatin ghau ve uul ghau lak! Pa tapirig isov wa. O Maaron, ugham ghau tinig poia. Pa tuag isov iyavyav. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Yoova, lolog ipataŋan kat. Pale upul ghau tauvene ila ila le ŋeez o isov? ");
INSERT INTO tuc_t_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yoova, yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Tauvene matam iŋgal ghau muul, ve upas ghau navot pa pataŋani tane. Ugham mulin ghau lak. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Pa mateegha irau matazi iŋgal ghom muul mako. Sei ta pale ighengheen ila naal ve ipait ghom? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Yau nayakyak le tapirig isov. Mboŋ ta naol ne, nataŋtaŋ le matag suuru ipot ila moogh tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Lolog ipataŋan kat ve nataŋ tiina le matag isarsar. Pasaa, koiagŋa katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Yam zeran tau aghamgham ŋgar sasaghati na, asov aghau payau! Pa taŋiiz tsiau, Yoova ilooŋa wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Yau nataŋ rarai Yoova pa uleeŋ, ve i ilooŋ suŋuuŋ tsiau. Ghasoniiŋ tsiau, i aat iyok pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Pale igham koiagŋa tisov tiroi tiina ve mayazi. Yes pale tivaghamgham, ve titoor zi rekia mon, ve titud mon ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Mbouŋ to David Ŋeer ee, eeza Kus. Puughu tooni ivot ila to Benyamin. I iŋgal saveeŋ sorok pa David, ve David imbou mbouŋ tane Yoova, yo Maaron tsiau. Yau nayooŋ ilat tsio. Zeran sasaghati tigham taghon ghau tighe tivaghamun ghau. Uul ghau ve ugham mulin ghau ila nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Ighe mako, yes pale tirav ghau, ve tivaghamun ghau imin laion iraŋgat tamtamon, le ŋgiira ŋgiira. Pasaa, leg etag eta to igham mulin ghau ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yoova, Maaron tsiau, zeran tau tighe tigham saghatin ghau, yau nagham sosor eta pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Tamtamon tau yeŋa nimbu saveeŋ to nivalupu ghei nimin eemon na, yau nagham ŋgar saghati eta pazi mako. Ve yes tau tighur koi payau sorok na, yau naum gabua toozi eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Isaav ighe yau nagham sosor tauvene, ene poia pa koiagŋa tigham taghon ghau ve tikis ghau, ve tivaghaaz ghau ila taan ve nagheen ila ŋgaupup. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yoova, uburig toman atem yavyav, ve ureu koiagŋa. Pa atezi yavyav kat payau. Maaron tsiau, uburig rekia mon ve uul ghau. Ughur atuya iŋarui koiagŋa pa ŋgar tau yes tighamu na. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Uyau tamtamon tisov tilam tilup zi ila yo naghom. Uleep ila niam to ghamuuŋ pooz izi nugh sambam, ve ugham pooz pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yoova, yo ugabiiz tamtamon to nugh nugh, ve ughur atuya pazi. Ugabiiz ghau ve upaghazoŋai ghau ila tamtamon matazi, leso tiwatagh tighe yau ŋeer duduŋag, ve gabuag tomania ŋgar tsiau isov, ene poia mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Maaron, ŋgar tau yo ughamghamu na, ene iduduuŋ mon. Ve yo uwatagh katin tamtamon lolozi ve ŋgar toozi. Zeran sasaghati tau tighamgham malmal na, upasov ŋgar toozi saghati tawe. Ve upalot zeran duduŋazi, leso tiyooz ariaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Maaron, yo mon ta umin sigheu payau. Yes tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na, yo ugham mulin zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Maaron, gabizooŋ tsio, ene iduduuŋ mon. Saawe isov, yo utotoi aatyavyav tsio pa zeran sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Tamtamon tau ighe titoor ŋgar toozi mako, ene pale Maaron ipot mbuzaagh ve iyool paneegh tooni to ighur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","I igharaat zaab tooni pataghaaŋ to irav zi. Ve igharaat paneegh tooni natŋa toman yav, leso ivanegh zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Zeran sasaghati timin livaa tau aapo ve ighe ipoop. Pasaa, lolozi ivon pa ŋgar sasaghati naol tau tighe tigham pa tamtamon. Ve murei, mako anooŋa to ŋgar tau igheen ila lolozi na ivot ighazooŋ. Ene karom naol to tivaghamunia tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ŋeer tau ighe itai puura pa tamtamon eta, ene pale tauu itap izila puura tana. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ŋgar saghati tau i ighe igham pa tamtamon, ene pale imuul pa tauu. Ve malmal tau i ighe igham pazi, ene pale ivaghamunia i tauu. ");
INSERT INTO tuc_t_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Yau lolog poia pa Yoova, ve napakuru pa ŋgar tooni duduuŋa. Yau nambou mbouŋ to napait i eeza. Pa Yoova, i Maaron tiina kat tau iliiv zimaronŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","O Yoova, Tiina tsiei, yo utotoi ezam tiina irau taan isov. Yo upabood taum pa mbonarim tau tiina kat. Iliiv gabua isov to sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Yo ughur yes geegeu ve yes tau siŋsiŋaiŋazi to tipait ezam ve titotoi tapirim. Leso ugham koiamŋa tineneeŋ, ve upoon yes zeran to taliiŋzizi avozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Matag izala pa sambam saamba, ve naghita nimam muuri ighengheen. Yau naghita kaiyo ve pitum tau yo taum ughur zi tila niazi na, ");
INSERT INTO tuc_t_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ve naghe: “Yei tamtamon to taan, nimin saa kaut poia, ta yo matam iŋgalŋgal ghei? Mindai ta yo matam payei? ");
INSERT INTO tuc_t_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Yo ughur ghei nizi rigmon pa yes aŋela ve yo taum. Ve upakur ghei, ve ugham ezamai ivot imin tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yo ughur ghei to niŋgin yo nimam muuri, ve ughur gabua isov ila yei sambamai: ");
INSERT INTO tuc_t_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ŋgai maata maata to nughei, ve gabua tisov tau tileep izi su, ");
INSERT INTO tuc_t_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","man tisov tau tirovroov ila taitai saamba, ve iigh tisov tau tilaghlaagh ila te loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Yoova, Tiina tsiei, yo utotoi ezam tiina irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Mbouŋ to David. Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Mbouŋ tane aliiŋa ‘Almut Laben’ (o ‘Mateegh to naatu.’) O Yoova, yau napait ghom pa poia tsio toman lolog isov. Ve naghe navotia uraat ŋgeretazi tau yo ughamgham zi na. Uraat tana, maata ite. Tamtamon tighita le ŋgar toozi imbool. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Yau lolog poia kat ve tintinig payo. Yo Maaron tiina tau uliiv zimaronŋa tisov. Tauvene yau aat nambou ve napait yo ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Saawe tau koiagŋa tighit katin tapirim, yes titoor zi ve tighe tighau. Eemon titaptap tizi le tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Yo uleep ila niam to ghamuuŋ pooz, ve ugagabiiz tamtamon. Ve gabizooŋ tsio, ene iduduuŋ mon. Yo ughit ghau ughe ŋgar tsiau ene iduduuŋ. Tauta uul ghau pa saveeŋ tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Yo uyaon nugh nugh tau tiwatagh ghom mako na, ve ureu tamtamon sasaghatizi gha tilalez. Yo umus ezazi ilale wa. Irau tamtamon matazi iŋgal zi muul ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Koiagŋa tisaghat wa. Pale tileep tauvene taghon taghon gha ila. Ve nugh toozi paam, yo ureu mbirisai zi le tisov tilalez. Tauvene tamtamon pale lolozi iveghai zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yoova ileep ila niia to ghamuuŋ pooz ve iŋginŋgin gabua irau saawe. I igharaat niia tawe ve isasaŋan pa gabizooŋ tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","I igagabiiz tamtamon tisov to taan, ve ighagharaat pataŋani toozi itaghon ŋgar duduuŋa. Ve igham pooz pa nughmariŋ itaghon ŋgar raraate mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yoova imin ruum ariaaŋa to ipoon yes tau koiazŋa tighur pataŋani pazi na. Ighe pataŋani ivot, mako i imin lezi nugh to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Yoova, yes tau tiwatagh katin ghom na, tinumeer ghom. Pasaa, zeran tau tizuari zi payo, yo irau ughur murim pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Ambou mbouŋ to apakur Yoova. I ileep izi nugh Zion, ve ighamgham pooz. Uraat tintiina tau i ighamgham zi na, avotia varuzi le irau nughmariŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Yes tau tiliŋ siŋ pa tamtamon na, Yoova irau ighurghur zi mako. Pale iyat ŋgar toozi tawe. Ve tamtamon tau tinumeera ve tibadbaad pataŋani na, i irau loolo iveghai taŋiiz toozi mako. I pale iuul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yoova, ughita pataŋani tau koiagŋa tigham payau ne! Yes tivaghamun ghau kat le naghe namaat. Lolom isaghatin ghau, ve upas ghau navot pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Leso nayooz ila ataman to nugh Zion, ve nasavia uraat tintiina tisov tau yo ughamgham zi payau. Ve napait ghom toman tintinig. Pasaa, yo ta ugham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Nugh nugh tau tiwatagh ghom mako na, titai puura leso tikis tamtamon. Eemon tauzi titap tizila. Puugh tau tiraaro pa saghavuuŋ tamtamon na, ene tauzi tighoon ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yoova igabiiz tamtamon ve ighur atuya pazi itaghon ŋgar duduuŋa. Leso itotoi tauu pa tamtamon ve tiwataghi. Liis tau zeran sasaghati tighuru na, iliis tauzi. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Zeran sasaghati ve nugh nugh tau tighur murizi pa Maaron, yes pale tisov timaat gha tizila mateegha niazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Eemon yes mbolaaŋa tau tirau gabua eta mako na, Maaron irau loolo iveegh pazi ne mako. Ve yes tau tibadbaad pataŋani ve tighurghur matazi pa uleeŋ to Maaron na, i irau ipul zi tileep saghat le alok ne mako. I pale iuul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yoova, ughita. Tamtamon sorok to taan tigham aghezi payo. Upul zi tigham taliiŋzizi sov. Utatan zi. Upayooz yes nugh nugh ila yo naghom, ugabiiz zi, ve ughur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O Yoova, ugham ŋgar eta pazi. Leso tiroi payo, ve tiwatagh tighe yes tamtamon sorok to taan mon. Tapirizi irau ghom mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O Yoova, mindai ta uyooz soghan payau ve uul ghau mako? Mindai ta naleep ila pataŋani loolo, ve uyooŋ payau ne? ");
INSERT INTO tuc_t_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Zeran sasaghati tipapait tauzi, ve tinanaan yes mbolaaŋa tau tirau gabua eta mako na. Eemon ŋgar toozi saghati tau matazi iŋgali na, ene pale imuul pa tauzi ve ivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Zeran sasaghati tipakur zi pa ŋgar saghati tau tighamghamu. Monmon tighamgham ŋgar to tigham lezi gabua katini, ve tisiksik saveeŋ sosor pa Yoova, ve tiveleghi. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Zeran sasaghati tawe, tipakur tauzi pa ŋgar toozi. Tauta lolozi pa tiwatagh Maaron mako. Ŋgar toozi iyaryaaŋ tighe: “Maaron irau ighur pataŋani payau mako. Pa Maaron eta ileep mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Ve saawe isov, uraat toozi ilaan poia mon. Tauta tinizi izaa, ve tigham ŋgar pa saawe tau Maaron pale igabiiz zi ve ighur atuya pazi ne mako. Ve matazi veleghin koiazŋa kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ve matazi iŋgal tighe: “Gabua eta irau igham ghei nirur ne mako. Ve pataŋani eta irau ivot payei paam mako. Yei aat nileep poia mon taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Saveeŋ sasaghati naol, tomania karom, ve paroiŋ ivotvot ila avozi irau saawe. Saawe tau tisavia ŋgar sasaghati ve pataŋani tau tighe tigham pa tamtamon, ene igham zi lolozi poia kat imin tighan aniiŋ poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Yes tiyoŋyooŋ ila nugh ziige, ve tisasaŋan pa tamtamon popoiazi. Tiŋgooz tauzi ve matazi inesnes pa yes tau tirau malmal mako na. Leso tisaghav zi, ve tirav zi timaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Yes tiyoŋyooŋ ve tisasaŋan imin laion tau ileep ila su loolo ve maata ivotvot. Tisasaŋan, leso tisaghav yes tau tirau malmal mako na. Ighe tisaghav zi ila puugh toozi, ene tikis zi ve tigherev zi tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Tauvene tineneeŋ ve tisasaŋan pa saghavuuŋ zi. Saawe tau ighe eta peria, mako tisaghavu. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ve matazi iŋgal tighe: “Maaron maata ilam payei mako. Ŋgar tau yei nighamu, ene i irau ighita mako, ve iwataghi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Oyai, Yoova, uburig utotoi tapirim pazi lak! Maaron tsiei, yes tau tinumeer ghom ve tibadbaad pataŋani na, lolom iveegh pazi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Maaron, mindai ta yo upul zeran sasaghati tivelegh ghom? Yes tisavsaav ila lolozi tighe: “Ŋgar tau yei nighamu ne, Maaron irau ipayooz ghei pa savsaveeŋ mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Eemon Maaron, yo ughita gabua isov tau tighamu na. Ŋgar sasaghati ve pataŋani maata maata tau yes tigham pa tamtamon na, yo uwatagh zi tisov ve igheen ila yo nimam. Pasaa, yes mbolaaŋa tau tirau gabua eta mako na, tighur tauzi ila yo nimam ve tinumeer ghom. Yo taum ta umin uleeŋa pa yes parooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ve zeran sasaghati tau tighamgham taliiŋzizi na, urav matin tapirizi. Uyat ŋgar toozi sasaghati. Leso ivot muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yoova, i kinik tiina tau ighamgham pooz ta aazne, ve taghon taghon gha ila. Nugh nugh tau tiwataghi mako ve tileep ila taan tooni na, i pale ipasov zi le tisov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Yoova, yes tau tinumeer ghom ve tibadbaad pataŋani na, yo uwatagh lolozi wa. Yo aat ughur taliŋam pa taŋiiz toozi, ve upalot zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Yes parooŋa ve yes tau koiazŋa tighur pataŋani pazi na, yo taum uyooz pazi ve uul zi, ve ughur atuya pa koiazŋa. Leso tamtamon sorok to taan tiparoi nugh muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Mbouŋ to David Yau nanumeer Yoova ve nayooŋ ila tooni. Mindai ta asaav saveeŋ to borauŋa payau aghe: “Ughau uzala pa loloz, imin man tau iroi ve ighau izala na. ");
INSERT INTO tuc_t_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Ughita! Zeran sasaghati tiyooŋ ila ndoroom loolo, ve tiyool paneegh toozi, tighur paneegh naatu ila ool, ve tisasaŋan tighe tivanegh yes tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na.” ");
INSERT INTO tuc_t_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Oyai, ŋgar ve tutuuŋ naol tau timin puughu pa lepoogh poia na, aazne tamtamon tivaghamunia le isaghat wa. Tauvene ŋeer duduuŋa pale igham mindai? ");
INSERT INTO tuc_t_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Eemon Yoova, i ileep iloŋ ila rumei tooni patabuyaaŋ. I kinik to sambam tau ileep ila niia to ghamuuŋ pooz. Ve maata ighita tamtamon tisov, ve igagabiiz ŋgar toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yoova igagabiiz tamtamon duduŋazi ve yes sasaghatizi paam. Leso iwatagh ŋgar toozi. Yes tau lolozi pa ŋgar to ravuuŋ tamtamon na, i loolo pazi rigta mako. Ighur koi pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Tauvene i pale igham yav ŋgilaaŋi tomania maet salfa tuntunu tau vaazi saghati na titap tizi, ve tivaghamunia zeran sasaghatizi. Ve igham yaghur tuntunu kat ilam, leso ivaghamun zi. Ene atuya toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Pasaa, Yoova itataghon ŋgar duduuŋa mon. Tauvene i loolo pa yes tau tighamgham ŋgar duduuŋa. Yes tau titaghon ŋgar poia na, ene pale tileep tomania, ve tighita naagho. ");
INSERT INTO tuc_t_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Mbouŋ to David O Yoova, uul ghei lak! Pa tamtamon tau lolozi isaghav ghom ariaaŋ ve titaghon eez tsio na, tisov wa. Yes tau avozi onoon na, eta ileep tomani ghei muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Tamtamon tisov tighamgham karom, ve tisasavia saveeŋ tau le anooŋa mako pa zetazŋa. Yamazi itortoor saveeŋ naol. Saveeŋ tau ivotvot ila avozi, ene poia. Eemon ŋgar tau igheen ila lolozi, ene ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","4","Yoova, zeran tau tisasavia saveeŋ ŋgoreeŋ pa tamtamon to tigham lolozi na, upoon avozi. Yes tipapakur tauzi tighe: “Sei ta imin daaba payei ve iŋgin ghei? Yei avomai maata. Saa ŋgar tau ighe nisavia, ene aat tamtamon titaghoni mon.” O Yoova, ugham zi tineneeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Tauvene Yoova isaav ighe: “Yes mbolaaŋa tau tirau gabua eta mako, ve yes tau koiazŋa tivaghamun zi na, yau nalooŋ taŋiiz toozi wa. Yes tipasawal pa lepoogh poia. Tauvene aazne, yau aat naburig ve nauul zi. Yau aat nagham mulin zi ila koiazŋa nimazi, ve nauul zi tileep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yoova saveeŋ tooni, ene onoon mon. Karom eta igheen ila loolo mako. Saveeŋ tooni, ene imin silva tau tighuru izala yav pai liim ve ru, leso muun ighau pani le iŋgalaaŋ kat. Tauvene iit irau taghur ila saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Onoon, aazne zeran sasaghati tipapakur zi ve tilaagh irau nugh nugh. Ve eval tiina tipapait ŋgar saghati. Eemon Yoova, yo matam payei, ve uŋgin ghei nileep poi. Ve uponpoon ghei pa zeran tauvene irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Mbouŋ to David Oyai Yoova, pataŋani tiina tane ikis ghau malau wa. Ŋeez o uul ghau? Pale lolom iveegh payau taghon taghon gha ila? Mindai ta uŋgooz naghom payau? Ŋeez o matam ilam payau muul? ");
INSERT INTO tuc_t_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Saawe isov yau naghamgham ŋgar naol pa pataŋani tsiau, mboŋ ve mataaz lolog isaghat naghe nataŋ. Pale koiagŋa tiliiv ghau taghon taghon gha ila? Ŋeez o ulam uul ghau? ");
INSERT INTO tuc_t_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","4","Yoova, Maaron tsiau, matam ilam payau, ve ughur taliŋam pa suŋuuŋ tsiau tane. Uul ghau ve ugham tapirig ivot muul. Mako pale pataŋani tane itatan ghau gha namaat, ve koiagŋa tipakur tauzi tighe tiliiv ghau. Isaav ighe yau natap ve nagham saghat, ene pale koiagŋa tighita ve tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Eemon yau nanumeer ghom. Pasaa, yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Yau lolog poia kat. Pasaa, yau nawatagh: Yo pale ugham mulin ghau pa pataŋani tsiau tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Tauvene yau aat nambou mbouŋ ve napait Yoova eeza. Pasaa, i igham poghani ghau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Mbouŋ to David Yes kankanooŋa tau lolozi iveegh pa Maaron na, tigham ŋgar ila lolozi tighe: “Maaron eta ileep mako.” Zeran tauvene, Maaron loolo pazi mako kat. Pasaa, Ŋgar toozi isaghat wa. Tauta tighamgham ŋgar sasaghati naol. Eta igham ŋgar poia mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yoova ileep izi sambam, ve maata izizi pa tamtamon to taan. I ighe ighita: Toozi eta pale ighilaalo, ma mako? Ve eta izuari ghi leso iwatagh Maaron? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Tisov tipul eez tooni ve tisaghat wa. Eta igham ŋgar poia mako. Mako le mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Tauvene Yoova igham ŋgar naol ighe: “Yes tau tinoknok ghamuuŋ ŋgar sasaghati na, lezi ghilalooŋ, ma mako? Ŋeez o ŋgar toozi ivot? Saawe isov, yes titombaan tamtamon tsiau ve tipasov gabua toozi le isov kat, imin yes tau tighan aniiŋ popoia, ve tipasovu. Matazi iŋgal ghau ve tisuŋ payau mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Eemon murei, roiŋ tiina kat pale igham zi. Pasaa, Maaron pale ivool to tamtamon duduŋazi tau titaghon eez tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Yes mbolaaŋa tau tirau gabua eta mako na, yam zeran sasaghati aponpoon eez pazi. Tauta ŋgar toozi le anooŋa mako. Eemon Yoova tauu pale imin lezi niazi to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Oyai, Maaron tau ileep izi nugh Zion na iuul yes Israela, ve ipas zi tivot pa pataŋani toozi, o poi! Isaav ighe Yoova iuul tamtamon tooni ve tileep poia muul, ene pale tintinizi. Onoon kat, Yakop paaghu tooni pale lolozi poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Mbouŋ to David Yoova, sei ta irau ileep tomani ghom ila niam patabuyaaŋ to suŋuuŋ? Ve sei irau ileep izi loloz tsio patabuyaaŋ Zion, ve isuŋ payo? ");
INSERT INTO tuc_t_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Tamtamon tau le sosor eta mako, ve laghooŋ tooni poia mon. I ighamgham ŋgar duduuŋa ve isasavia saveeŋ onoon mon toman loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","I ivaghamunia tamtamon ezazi mako, ve igham ŋgar saghati eta pa zeetŋa mako. I iŋgal saveeŋ pa toŋvetaz tooni mako, ve isinai zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Zeran sasaghati tau Maaron ighur muuri pazi na, i paam ighur muuri pazi. Ve yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, i ipapait zi. Saa saveeŋ tau i imbua, ene irau loolo iveghaini mako. Ighe ipataŋan pani pa taghoniiŋni, ene poia. Eemon i aat itaghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Ve isaav ighe zeetŋa tigham bun ila tooni, saawe to tiyatu, yes tiyat maet duduuŋ tau tighamu na. I irau ipoi pa maet geege ite paam izala paavo mako. Ve isaav ighe tamtamon tighe tigholi, leso iŋgal saveeŋ pa yes tau lezi sosor mako, ene i irau iyok pazi mako. Yes tau titaghon ŋgar naol tane, ene aat tiyooz ariaaŋ. Gabua eta irau igham zi tirur ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Mbouŋ to David O Maaron, umin sigheu payau ve uŋgin ghau naleep poi. Pasaa, yau nanumeer ghom ve nayooŋ ilat tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Yau nasaav pa Yoova: “Yo Tiina tsiau. Isaav ighe naleep soghan payo, ene irau nandeeŋ gabua poia eta mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Tamtamon patabuyaaŋa to Yoova tau tilepleep izi taan, yes popoiazi kat. Isaav ighe naleep tomani zi, yes tigham lolog poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Eemon zeran tau tibesbees pa maaron karomŋa na, pataŋani naol pale izazaa toozi. Yau irau napaak zi pa watooŋrau toozi mako. Ve avog irau itut maaron toozi ezazi rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yau naghita Yoova naghe i imin taan poia ee tau tipuli payau to naleep ila. Irau nambool pa gabua eta mako. Pasaa, yau naleep ila i niima. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Gabua naol tau yau nagham zi ilat tsio, ene popoiazi mon. Onoon kat, lepoogh tsiau tau Yoova igham payau ne, ene poia kat. Imin naleep ila taan paghuuna ee tau tipuli payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yau napait Yoova pa poia tooni. Pasaa, i ighamgham pooz payau, leso nataghon eez poia. Mboŋ paam, ŋgar tau i ighuru ila lolog ne, itotoi eez payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Saawe isov, matag iŋgalŋgal naghe Yoova ileep tomani ghau. I ilepleep ila zigeg tapir ve ipapalot ghau. Tauvene gabua eta irau igham ghau narur ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Tauta tintinig ve lolog poia kat. Irau naroi mako. Pasaa, yo aat uŋgin ghau naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Irau ughur murim payau, ve upul ghau namaat gha nazila mateegha niazi ne mako. Pasaa, yau tamtamon tsio. Lolog isaghav ghom ariaaŋ, ve nataghon eez tsio. Irau upul patag imbuuz ila naal loolo ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Yo utotoi eez to lepoogh poia payau. Isaav ighe naleep tomani ghom, ene pale lolog poia le poia kat. Ighe naleep ila nimam tapir, ene aat nayamaan poia tsio taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Mbouŋ to David O Yoova, ulooŋ taŋiiz tsiau tane, ve uul ghau. Upaghazoŋai ghau ila tamtamon matazi ughe yau ŋeer duduŋag. Leso tiwatagh tighe yau nagham sosor eta mako. Yau nasuŋ ghom ila avog uuli mon mako. Nasuŋ ghom toman lolog. Tauvene ughur taliŋam pa suŋuuŋ tsiau tane, ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Yo ughita gabua naol isov, ve yo uwatagh ughe yau nataghon ŋgar tau iduduuŋ ila yo matam. Tauvene uvool tsiau ve upaghazoŋai ghau ila tamtamon matazi ughe yau nagham sosor eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Yo ugabiiz poghani ghau, ve utoov ghau. Ve ulam utiir ghau pa mboŋ paam. Tauta uwatagh katin lolog. Yo ugabiiz katin ghau, ve ughita ŋgar saghati eta igheen ila lolog mako. Pa ŋgar tsiau iyaryaaŋ naghe avog igham sosor eta sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Yau nataghon ŋgar tau zeran siriv tighamghamu ne mako. Pasaa, matag kisin saveeŋ tsio. Tauvene zeran sasaghati tau tighamgham malmal na, yau napaghau taug pa eez toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Saawe isov, nataghon eez tsio mon. Agheg isapir pani rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Maaron, yau nawatagh: Saawe isov, yo uloŋlooŋ suŋuuŋ tsiau. Tauvene nataŋ rarai ghom naghe uul ghau. Ughur taliŋam payau, ve ulooŋ aliŋag tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Tauvene ugham uraat ŋgeretazi tintiina to uul ghau. Yes tau tiyooŋ ilat tsio na, nimam tapir aat igham mulin zi ila koiazŋa nimazi, ve tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Uŋgin poghani ghau imin yo uŋgin taum matam. Upoon ghau imin tatareek ipagud natŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Pa zeran sasaghati tizuari zi tighe tivaghamun ghau. Koiagŋa tilivutin ghau, ve tighe tirav ghau namaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Lolozi isaghatin tamtamon mako. Ve tipapait tauzi ezazi toman aliŋazi tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Yes titaghon ghau tilam gha tilivutin ghau wa. Ve tidaad matazi payau tighe tisik ghau nazi taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Yes timin laion tau pitoola ve ighe iraŋgat gabua leso ighani. Yes timin laion paaghu tau iyooŋ ila su loolo ve isasaŋan. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yoova, uburig urav koiagŋa lak! Uyooz umin sigheu payau, upoon zi, ve utatan tapirizi. Ukas zi pa mbuzaagh tsio, ve ugham mulin ghau pa zeran sasaghati tane. Leso naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Zeran tawe tigham ŋgar tighe gabua to taan, ene gabua tauu. Utotoi nimam pazi, ve ugham mulin ghau ila nimazi. Atuya tau yo ughe ugham pazi na, upasovu pataghaaŋ. Leso tiyamaana kat! Ve ugham tauvene pa natuzŋa ve iseeŋga ila izaa to timbuzŋa paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Eemon yau ŋeer duduŋag. Tauvene yau aat naghita naghom. Saawe tau naburig, yau aat naleep ila yo naghom, ve nayamaan naghe: Aa, gabua ta nazuari ghau pani, tauta naghamu wa! ");
INSERT INTO tuc_t_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Mbouŋ to David, besooŋa to Yoova. Saawe tau Yoova igham mulin David ila Saul ve koiŋa tisov nimazi, i imbou mbouŋ tane pa Yoova. O Yoova, yau lolog igheen tsio kat, ve naghamgham tapirig ilat tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yoova iponpoon ghau pa koiagŋa imin maetaaz tau izala kat. Ve i imin ruum ariaaŋa pa nayooŋ ila loolo. Saawe isov, i ighamgham mulin ghau pa pataŋani tsiau. Maaron tsiau iponpoon ghau pa zaab imin maet tintiina, ve yau nayoŋyooŋ ila tooni. I imin sigheu payau, ve i Uleeŋa tsiau ariaaŋa. I imin didiiŋ ariaaŋa tau ilivut ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Iit aat tapait Yoova eeza! Yau napoii pa uleeŋ, ve i igham mulin ghau ila koiagŋa nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Liis to mateegh, rigmon kanaŋ iliis ghau. Pataŋani naol titatan ghau imin dibom tintiina tipol izala pavog. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ve ravraav ariaaŋa to mateegh ikaukau ghau, ve rigmon kanaŋ igherev ghau nazila mateegha niazi. Tauvene liis to mateegh, naghita igheen ila naghog. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Saawe tau naleep ila pataŋani tawe loolo, yau napoi Yoova pa uleeŋ. Nataŋ rarai Maaron tsiau naghe ilam iuul ghau. Taŋiiz tsiau iŋaruini, ve ighur taliiŋa pani. I ileep ila rumei tooni loolo, ve ilooŋ aliŋag. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Tauvene igham yogyoog itok taan le taan katkatia, ve loloz tisov pughuzi irur paam. Pasaa, i aate yavyav kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Mbuas ivot pa uuzu puura, ve yav yaama tomania ŋgilaaŋi ivot pa aavo, ve ighan suvinia gabua. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ra sambam saamba ikaak, ve i iyooz izala taitai gabgabuai, ve izilam. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","I ileep izala aŋela tooni ariaaŋa nduume, ve iroov ilam. Yaghur ibaado, ve ikaleel gha ilam. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","I ipoon tauu pa ndoroom, leso imin le niia to yoŋgaaŋ. Taitai gabgabuai ikauu, ve iŋgooz tauu ila loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","I ileep ta sewe toman mbonari tiina, ve igham nugh ighani milmilia. Tauta lalaav iŋgalŋgal izi, ve ais paatu paatu tomania yav ŋgilaaŋi titaptap tizi pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yoova ileep izi sambam, ve isaav toman aliiŋa tiina kat, imin lalaav luutu. Maaron Tiina Tau Iliiv Zimaronŋa Tisov na aliiŋa ivot. Ve yav ŋgilaaŋi tomania ais paatu titaptap tizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","I igham lalaav iŋgal koiŋa imin paneegh natŋa tooni. Tauta roiŋ tiina igham zi, ve tighawaar mbiriis. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yoova, saawe tau yo utotoi aatyavyav tsio pazi, yaghur tiina ivot pa uzum, ve ivuvuur te ila soghan, le sausau ivot ighazooŋ. Ve taan puughu tau igheen izila siiŋa kat na ivot peria. Gabua eta ipoona muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ra Yoova ileep saaŋa, ve izuzuun niima izilam ikis ghau, ve indai ghau nazaa pa mazavan belbeluuŋa loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Koiagŋa tapirizi tiina, ve yau narau zi mako. Yes tighur koi payau kat. Eemon Yoova iuul ghau, ve ipas ghau ila nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Saawe tau naleep ila pataŋani loolo, yes tipaburigin malmal payau. Eemon Yoova ipoon ghau ve ipalot ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","I ipas ghau navot pa pataŋani tsiau, ve ighur ghau nala naleep izi nugh poia. Pasaa, i loolo payau kat. Tauta igham mulin ghau ve naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yau nataghon ŋgar tau iduduuŋ ila Yoova maata. Tauta i loolo payau ve igham poghani ghau. Nimag igham sosor eta mako. Tauta i igham leg atuya poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Pasaa, saawe isov, yau nataghon eez to Yoova. Irau nagham ŋgar saghati ve naghur murig pa Maaron tsiau ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Pasaa, matag kisin tutuuŋ tooni tisov. Tutuuŋ tooni tau tigheen pataghaaŋ na, naghur murig pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Tauta leg sosor eta ila i maata mako. Yau naŋgin taug poi, tauta nagham gabua eta isosor mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Yau naghamgham ŋgar duduuŋa ve ŋgar ŋgalaaŋa mon ila Yoova maata. Tauta i loolo payau ve igham leg atuya poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yoova, isaav ighe tamtamon eta loolo isaghav ghom ariaaŋ ve itaghon eez tsio, yo pale lolom isaghavu paam ve uule irau saawe. Tamtamon tau ighe le sosor eta mako ve ŋgar tooni isov popoia mon, ene pale yo upamuul ŋgar poia pani paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ve isaav ighe ŋeer eta ighamgham ŋgar ŋgalaaŋa mon, ene pale yo paam ugham ŋgar ŋgalaaŋa pani. Eemon yes tau lezi ŋgar tiina pa ghamuuŋ karom ve ŋgar saghati, na yo lem eez naol to uyat ŋgar toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Tamtamon tau titatan tauzi na, yo ughamgham mulin zi pa pataŋani toozi. Eemon yes tau tipapait tauzi ve tivelegh ghom na, yo utatan zi tizi timin kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yoova, Maaron tsiau, yo ugham ghazooŋa tsio isul ghau, ve uziir ndoroom ighau payau, leso naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Yo upapalot ghau. Tauta yau irau naparav tomania koiagŋa le naliiv zi. Maaron tsiau ilepleep tomani ghau. Tauvene yau irau nayaat maloŋon didiiŋ ariaaŋa tau ilivut koiagŋa nugh toozi, ve naloŋ nala. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Maaron eez tooni, ene poia le poia kat. Ve saveeŋ tooni, ene onoon mon. Irau taghur ila kat. Tamtamon tisov tau tiyooŋ ila tooni na, i imin sigheu pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yoova mon ta Maaron tauu. Ite paam mako. I mon ta iponpoon ghiit imin maet tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","I ipapalot ghau pa tauu tapiri, tauta nayooz tuŋia. Ve i iŋginŋgin ghau pa laghooŋ tsiau, ve itotoi eez payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","I igham agheg tuŋia ila taan, ve nalaan ariaaŋ imin mekmek sagsag. Tauvene saawe tau nalaagh ila nugh sapsapu, irau agheg pusukia ve natap mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","I itotoi ŋgar to ghamuuŋ malmal payau, ve ipalot nimag. Tauta yau irau nadaad paneegh ariaaŋa tau tigharaata pa mbaras. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yoova, yo umin sigheu payau, ve ugham mulin ghau ila koiagŋa nimazi. Ve nimam tapir, tauta ipapalot ghau. Yo uluul ghau, tauta ezag imin tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Yo ugharaat poghania agheg niia. Tauta agheg pusukia mako, ve nayooz tuŋia pa ghamuuŋ malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Yau nalaan taghon koiagŋa nala le nazaa toozi. Ve naravuur zi le tisov kat. Eta ileep muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Yau narav zi le tisov titaptap tizi agheg puughu. Eta irau iburig muul to igham malmal payau ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Pasaa, yo upapalot ghau pa taum tapirim. Tauta nayooz ariaaŋ pa malmal. Yo ughur koiagŋa tila nimag ve naliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Yo ugham zi titoor zi, ve tighau tila. Yes tau tighur koi payau ne, yau napasov zi le tisov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Yes tipoi pa uleeŋ. Eemon eta iuul zi mako. Taŋiiz toozi iŋarui Yoova paam. Eemon i ilooŋ zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Yau narav mbirisai zi, le timin ŋgaupup tau yaghur ivuvuura gha ilale. Ve navaghaaz zi imin tiiŋ tau igheen ila eeze. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Saawe tau tamtamon tiburig ve tizoor aliŋag, yo uvool tsiau, ve ugham mulin ghau ila nimazi. Ve ughur ghau namin daaba pa nugh nugh. Tamtamon to taan siriv tau yau nawatagh zi mako na, aazne tileep ila sambag ve tibesbees payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ighe tilooŋ aliŋag, ene rekia mon ve titaghoni. Nugh nugh tilam ve tiput aghezi payau toman roiŋ tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Pasaa, tighilaal tighe tirau gabua eta mako. Tauvene roiŋ tiina igham zi, ve tipul ruum toozi ariaŋazi tau tiyoŋyooŋ ila lolozi na, ve tilam tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Onoon kat, Yoova ilepleep! I iponpoon ghau imin maet tiina. I Uleeŋa tsiau. Tauvene yau napakuru ve napait eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","I ivool tsiau, ve iyat ŋgar sasaghati tau koiagŋa tigham payau na. Ve ighur nughmariŋ tileep ila yau sambag. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","I ipas ghau ila koiagŋa nimazi, ve iuul ghau le naliiv zi. I igham mulin ghau ila yes tau tiliŋliŋ siŋ pa tamtamon na nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Tauvene Yoova, yau aat nayoor ezam ila tamtamon to nugh nugh sosozi, ve nambou to napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yoova iuluul yes tau i ighur zi timin kinik. Tauta tilivliiv malmal tintiina. I tauu ighur David to igham pooz. Tauvene loolo isaghavu, ve pale ighur poia tooni izazaa to David tomania paaghu tooni taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Mbouŋ to David Gabua naol isov tau tighenaar ila sambam saamba na titotoi ghiit tighe Maaron eeza tiina. Gabua ta saaŋa we, ene i niima muuri. Tauta titotoi Maaron tapiri tomania ŋgar ve poia tooni pait. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Mataaz ta naol ne, tisavsaav pait. Ve mboŋ ta naol ne, tipaghazoŋai ghiit pa ŋgar tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Yes lezi avozi to tisavsaav mako. Irau talooŋ avozi luutu mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Eemon aliŋazi ila irau taan isov. Saveeŋ toozi ila irau taan ziige ta naol ne. Maaron ighur aaz le niia ila sambam saamba to igheen pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Aaz pisikia izaa imin ŋeer tau ivai paaghu, ve ipul ruum tooni ve ivot toman tintini. Ve imin tamtamon to landooŋ tau igharaat ghi to ilaan toman loolo poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Aaz izaa pa taan ziige ee, ve imalaaŋ ila izi pa ziige ite. Ve gabua eta irau iyooŋ pa maata ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Saveeŋ isov tau Yoova igham pait, ene poia kat ve iduduuŋ mon. Ve ipariaaŋ ghiit ve igham tapiriin ivot muul. Eez tau Yoova ighuru pa tamtamon tooni na, igheen tuŋia tauvene. Irau itoora muul mako. Ve ipaghazoŋai yes tau lezi ŋgar tiina mako na, le ŋgar toozi ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Tutuuŋ naol tau Yoova ighur zi pait, ene duduŋazi mon, ve tigham ghiit loloon poia kat. Tutuuŋ to Yoova imin ghazooŋa pait, ve igham ghiit taghilaal. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Ŋgar to taroi pa Yoova ve tataghon ŋgar tooni, ene poia. Ŋgar tauvene, ene iŋgalaaŋ ila i maata, ve igheen tauvene taghon taghon gha ila. Ve gabizooŋ to Yoova, ene iduduuŋ ve onoon mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Tamtamon tighita maet gol tighe ene gabua tiina, ve lolozi pani. Eemon Yoova saveeŋ tooni iliiv kat pa gol katini tau ŋgalaŋazi na. Ve tok suuru tauvene paam, poia ve imonmoon ila avoon. Eemon Yoova saveeŋ tooni, ene poia kat le iliiv tok suuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yoova, yau besooŋa tsio. Saveeŋ tsio ipaghau ghau pa pataŋani naol. Yes tau titaghon saveeŋ tsio, ene aat tigham lezi atuya tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Sei irau ighilaal sosor tooni isov? Mako. O Yoova, sosor naol tau naghilaal zi mako ve nagham zi na, lolom isaghatin ghau ve upul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Yau besooŋa tsio. Sosor tau naghilaal zi na, upaghau ghau pazi. Pa lolog pa ŋgar tauvene igham pooz payau mako. Leso nagham sosor tiina eta sov, ve ŋgar tsiau iduduuŋ ila yo matam. ");
INSERT INTO tuc_t_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Tauvene yau naghe le saveeŋ tau ivot ila avog, ve ŋgar tau igheen ila lolog ne, isov iduduuŋ ila yo matam, ve igham ghom lolom poia. O Yoova, yo Uleeŋa tsiau ve uponpoon ghau imin maet tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Mbouŋ to David Saawe tau ighe yo uleep ila pataŋani loolo, Yoova pale ilooŋ suŋuuŋ tsio ve iuul ghom. Maaron to Yakop, i eeza tiina pa tapiri ve poia tooni. I pale imin sigheu payo ve iŋgin ghom uleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Maaron ileep ila rumei tooni patabuyaaŋ izi loloz Zion. I pale iuul ghom ve ipalot ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","I aat maata iŋgal watooŋrau tsio tisov. Irau loolo iveegh pazi mako. Watooŋrau tsio tau yav ighan dodolin zi, ene tighamu loolo poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ve gabua tau yo lolom pani na, i aat igham payo. Ve ŋgar isov tau lolom ighur ughe ugham zi na, i pale igham anooŋa ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Murei, saawe tau yo uliiv koiamŋa, yei pale lolomai poia kat ve nisir. Pale nigham pilak tsiei ve nisik zi ilala ilamlam, ve nipait Maaron toit eeza toman tintinmai. Gabua naol isov tau yo ughason Yoova pani na, i pale ilooŋ ghom ve igham payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Ŋgarig gha nawatagh: Yoova pale iuul kinik tau i tauu ighuru pa uraat na. I pale ileep izi nugh tooni patabuyaaŋ sambam, ve ilooŋ suŋuuŋ tooni, ve ipaloti pa tauu tapiri. Leso iliiv koiŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Zeran siriv tinumeer karis toozi to malmal, ve siriv tipakur zi pa hos toozi. Eemon yei ninumeer Maaron tsiei Yoova. I eeza tiina pa tapiri ve poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Tauvene koiamaiŋa pale aghezi pusukia ve titaptap. Eemon yei pale niburig ve niyooz tuŋia pa malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Yoova, ughur taliŋam pa taŋiiz tsiei tane, ve uul kinik tsiei. Leso iliiv koiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Mbouŋ to David O Yoova, kinik tsiei loolo poia kat. Pasaa, yo upaloti pa taum tapirim. Yo uule pa malmal le iliiv koiŋa. Tauta tintini kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Gabua tau i loolo pani ve ighason ghom pani na, yo uŋguruuta mako. Yo ugham pani wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Yo ula uvot tooni, ve upakuru pa gabua popoia naol. Ve ughur moghar ndamoonda milmilia izala daaba. Moghar tawe, tigharaata pa gol tau poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","I ighason ghom to uŋgini poi ila saawe to malmal, leso imaat sov, ve ileep poia taghon taghon gha ila. Ve yo ulooŋ suŋuuŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Yo uule gha iliiv malmal, tauta eeza ivot imin tiina. Ve upaboode pa tapirim ve poia tsio. Tauta vaaru ilaan irau nugh nugh, ve tamtamon tipaiti tighe i eeza tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Onoon kat, poia tsio pale izazaa tooni taghon taghon gha ila. Ve yo uleep tomania. Tauta loolo poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Kinik tsiei inumeer Yoova. Tauvene gabua eta irau ighamu itap ne mako. Pasaa, Maaron Tiina Tau Iliiv Zimaronŋa Tisov na, loolo isaghavu ariaaŋ, ve iuluule itaghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","O kinik, nimam pale ikisiir koiamŋa tisov. Yes tau tighur koi payo na, nimam tapir pale isaghav zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Saawe tau utotoi tapirim ivot ighazooŋ, yo pale uvaghamun zi kat imin yav tiina ighan gabua. Onoon kat, aatyavyav to Yoova pale izaa toozi, ve yav tooni ighaniir zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Natuzŋa paam, yo pale uravuur zi, ve upasov zi pa taan. Tauvene murei, paaghu toozi eta irau ileep muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Onoon, yes tiil eez payo, ve timbu saveeŋ tighe tivaghamun ghom. Eemon ŋgar toozi saghati tawe irau ighur anooŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Saawe tau tighita yo ughur paneegh naatu iŋarui zi, yes pale tiroi ve tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yoova, uburig ve utotoi tapirim ivot ighazooŋ. Leso nimbou ve nipait ezam pa tapirim. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Mbouŋ to David Maaron tsiau, Maaron tsiau, puughu mindai ta ughur murim payau? Pataŋani tsiau igham ghau nataŋ tiina. Puughu mindai ta yo uul ghau mako, ve uleep soghan payau? ");
INSERT INTO tuc_t_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Maaron tsiau, mataaz ta naol ne, nataŋ rarai ghom. Eemon yo usavia leg saveeŋ eta mako. Ve mboŋ tauvene paam. Namariau mako. Nanoknok taŋiiz. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Eemon Maaron, yau nawatagh: Yo patabuyaaŋ. Yo uleep ila niam to ghamuuŋ pooz, ve yes Israela tipapait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Muuŋ ve ilam, timbumaiŋa tinumeer ghom. Yes tighur ilat tsio, ve yo upas zi tivot pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Saawe tau titaŋ rarai ghom, yo ugham mulin zi pa pataŋani toozi. Yes tinumeer ghom, ve yo uul zi. Tauvene tighur matazi payo sorok mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Eemon yau, tamtamon tighit ghau tighe yau tamtamon mako. Matazi tatanin ghau, ve tivelegh ghau tighe yau kaut sorok imin motmoot to taan lolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Tamtamon tisov tau tighit ghau ne, titurun luazi payau ve tighe: ‘Aa, ughita wa?” Ve tiŋiŋ payau, ve tisik saveeŋ veleghiiŋ naol payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Tisavsaav payau tighe: “Yo ughe unumeer Yoova? Poia. Ighe tauvene, o taleep ve taghita. Isaav ighe i loolo payo kat, i aat iuul ghom, ve igham mulin ghom pa pataŋani tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Eemon Yoova, yo ta ughur ghau navot poi ila tinaŋ aapo. Ve saawe tau naghunghun tuz, yo urarar payau poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Saawe tau tinaŋ ipoop ghau, tighur ghau nalat namin yo lem, leso uŋgin ghau. Tauta saawe tawe ve ilam, yau nanumeer ghom naghe yo Maaron tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Tauvene uleep soghan payau sov. Pa aazne, pataŋani tiina ighe ivot payau. Ve leg tamtamon eta to iuul ghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Ughita. Koiagŋa katini tilam tilivutin ghau. Tapirizi tiina imin makau zitamoot to Basan tau bide tapirizi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Yes timin laion tau tikakaak avozi ve livozi imasis ilam payau. Ve lolozi ŋuria tighe tiraŋgat ghau ve tighan ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Tauvene tapirig isov kat, imin yaa tau igheen ila uur loolo ve tiliŋi ilale. Tuag tisov goloŋia. Tauvene nayamaan taug naghe irau nagham gabua eta mako. Ve roiŋ tiina igham ghau ve lolog imin waar mbuaaŋ. Naghe paita namaat tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Ŋgarsuag igorgor kat. Yo upul ghau ve nagheen ila ŋgaupup loolo ve naghe paita namaat tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Koiagŋa katini tilam tilivutin ghau imin ŋgavuun umbaal ve tivaraŋgatin agheg ma nimag. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ve tuag isov peria. Tauvene koiagŋa tiyooz ve timarar ghau, ve lolozi poia kat. Pasaa, nasaghat wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Yes tighe pa namaat wa. Tauta tighe tivalagh nonoghiiŋa tsiau tomania gabua tsiau siriv irau zi. Tauvene tipayooz mbuur, leso tighita sei ta pale igham saa gabua. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yoova, uleep soghan payau sov. Uleeŋa tsiau, ulam rekia ve uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Upoon ghau pa mbuzaagh to mateegh. Upaghau ghau pa ŋgavuun sasaghati tane. Mako pale tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Ugham mulin ghau pa laion tane aavo, ve upasali ghau pa makau sagsagŋa tane zoŋazi. Aa, ŋgarig gha naghita naghe yo ulooŋ ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Tauvene yau aat navotia gabua tau yo ugham payau ne pa zetagŋa. Saawe tau tamtamon tsio tilup zi pa suŋuuŋ, yau aat nala tomani zi ve nayoor ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Yam tau aroi pa Yoova ve ataghon ŋgar tooni na, apakuru. Yam siŋ to Yakop, apait Yoova eeza pa tapiri ve poia tooni. Yam Israela asov, aroron ve aroi pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Pa yes tau tibadbaad pataŋani ve tighur matazi pa Yoova na, i irau ighita pataŋani toozi imin kaut sorok ne mako. Pale iuul zi. Irau ivelegh zi, ma ighur muuri pazi ne mako. Tauvene saawe tau titaŋ raraini pa lezi uleeŋ, i aat ilooŋ taŋiiz toozi ve iuul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Yoova, isaav ighe tamtamon tsio tilup zi pa suŋuuŋ tiina, yau aat nayoor ezam ila naghozi, ve napait ghom pa ŋgar tau yo ugham payau na. Yau pale nataghon saveeŋ mbuaaŋ tsiau, ve nagham watooŋrau payo ila yes tau tiroi payo ve titaghon ŋgar tsio na matazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Watooŋrau tau nagham pa paitooŋ Yoova na, yes mbolaaŋa pale tighan sirivu, le apozi isuŋ. Ve yes tau tizuari zi pa Yoova na, pale tipaiti. I tauu pale igham poghani zi ve tileep poia taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Tamtamon irau taan ziige ta naol ne pale matazi iŋgal Yoova, ve titoor ŋgar toozi imuul ila pani. Nughmariŋ pale tisov tiput aghezi pani ve tipaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Pasaa, Yoova, i kinik tiina. I iŋgin tamtamon tisov to taan, ve ighamgham pooz pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Tauvene kuaz puughu to taan tau tipapakur tauzi na, pale tisov tiput aghezi pani ve tipaiti. Ve ila ila le yes tau tigharau tighe timaat ve timin ŋgaupup na, yes paam pale tiput aghezi pani ve tipaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Paaghu toit pale tibees pa Yoova. Yes tau tivot murei na, pale tilooŋ Yoova vaaru. ");
INSERT INTO tuc_t_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yes tau tipoop zi murei na, ene pale tisavia ŋgar duduuŋa to Yoova pazi, ve tipaes pazi pa eez tau i igham mulin tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Mbouŋ to David Yoova, i ŋginiiŋ tsiau poia. Irau nambool pa gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","I ighegherev ghau nala pa kikiliiŋ popoia tau igheen yaa naliu ziige na. Leso naghan, naghun yaa luuma, ve namariau. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","I igham tapirig ivot muul, ve ipaduduuŋ ghau le nataghon eez tau iduduuŋ ila i maata. Leso ipaghazoŋai eeza tiina ivot ighazooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yoova, ighe nalaagh ila nugh sapsapu to mateegh, ve ndoroom tiina ikau ghau, ene irau naroi mako. Pasaa, yo uleep tomani ghau. Yau naghit ghom ukis zaab tsio tomania titi to upaduduuŋ sipsip pani, tauvene ateg izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Yau nalam namin loom payo, ve yo upakur ghau kat. Yo ugham marewaaŋ tiina payau ila koiagŋa matazi. Ve uliŋ ŋgoreeŋ izala dabag, ve ugham poghani ghau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Onoon kat, saawe isov tau naleep izi taan, yo lolom isaghav ghau, ve poia tsio izazaa tsiau itaghon saveeŋ mbuaaŋ tsio. Rumei tsio aat imin niag to lepoogh le irau saawe tsiau isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Mbouŋ to David Taan tomania gabua naol isov tau tileep ve tigheen ila, ene to Yoova. Nugh tisov tomania tamtamon tau tilepaar ila, ene i tooni mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Pasaa, i ta ighur taan ipot izala te paavo. Ve ipariaaŋ taan puughu igheen tuŋia izila te loolo ta siiŋa geeg. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Sei irau izala loloz to Yoova ve isuŋ pani? Ve sei irau iloŋ ila rumei tooni patabuyaaŋ ve iyooz ila i naagho? ");
INSERT INTO tuc_t_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Tamtamon tauvene: I igham sosor eta mako. Ve ŋgar isov tau igheen ila loolo na, ene iŋgalaaŋ mon. I ipait maaron karomŋa mako, ve iwaat Maaron eeza sorok to ipalot saveeŋ karom mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Tamtamon tauvene, poia to Yoova aat izaa tooni. Maaron tau Uleeŋa tooni na, pale igham mulini ve ileep poi, ve ipaghazoŋaini ighe i ŋeer duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Zeran tauvene tizuari zi pa Maaron. Yes tighe tila tivot to Maaron to Yakop naagho, ve tisuŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","O yam ataman, akaak ve tinimim izaa. Yam ataman to muuŋ geeg, tinimim izaa, ve akaak le akaak kat. Leso sooso irau kinik tau eeza tiina pa tapiri ve poia tooni na itaghoni iloŋ ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Laak, kinik tau eeza tiina pa tapiri ve poia tooni na, ene sei? Ene Yoova. I saksaki, ve tapiri tiina. Ve i irau kat pa ghamuuŋ malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","O yam ataman, akaak ve tinimim izaa. Yam ataman to muuŋ geeg, tinimim izaa, ve akaak le akaak kat. Leso sooso irau kinik tau eeza tiina pa tapiri ve poia tooni na itaghoni iloŋ ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Laak, kinik tau eeza tiina pa tapiri ve poia tooni na, ene sei? Ene Yoova. I Maaron saksaki, ve iŋgin gabua naol isov. Onoon kat, i kinik tau eeza tiina pa tapiri ve poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Mbouŋ to David O Yoova, naghur taug nalat tsio, ve nasuŋ payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Maaron tsiau, yau nanumeer ghom. Upul koiagŋa titatan ghau sov. Pale tipakur zi tighe tiliiv ghau, ve tigham ghau mayag. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Tamtamon tisov tau tisaŋan ghom pa uleeŋ na, irau tighur matazi payo sorok ve mayazi ne mako. Eemon yes tau tighur murizi payo na, yes pale mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yoova, utotoi eez tsio payau. Upaghazoŋai ŋgar tsiau pani, leso nataghon duduŋaini. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Ugham pooz payau, leso laghooŋ tsiau iduduuŋ pa saveeŋ tsio. Ve upaghazoŋai ghau pa ŋgar tsio. Pasaa, yo Maaron tsiau ve Uleeŋa tsiau. Mboŋoozo ila le ravrav izi, yau naghurghur matag payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yoova, muuŋ ve ilam, yo lolom isaghatin tamtamon ve uluul zi. Ve lolom isaghav tamtamon tsio ariaaŋ ve poia tsio izazaa toozi. Matam iŋgal ŋgar tsio tana. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Sosor ve ŋgar to taliiŋzizi tau yau kukuag ve naghamgham zi na, matam iŋgal zi sov. Yoova, yo poiam, ve lolom isaghav tamtamon tsio ariaaŋ ve uluul zi itaghon saveeŋ mbuaaŋ tsio. Tauvene matam iŋgal ghau ve uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yoova ŋgar tooni, ene poia ve iduduuŋ mon. Tauvene zeran tau tisapir pa ŋgar tooni na, i ipapaduduuŋ zi pa eez tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ve yes tau titatan tauzi ve tinumeer Maaron mon na, i ighegherev zi ve itotoi eez tooni pazi, leso titaghon ŋgar duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Yes tau matazi kisin saveeŋ mbuaaŋ toozi tomania Yoova, ve titaghon eez tau i ighuru pa tamtamon tooni na, i loolo isaghav zi ariaaŋ ve iuluul zi itaghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O Yoova, yau nagham sosor katini kat. Eemon yo ezam tiina pa ŋgar tsio tau lolom isasaghatin yei tamtamon. Tauvene ureu sosor tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Tamtamon tisov tau tiroi pa Yoova ve tighe titaghon ŋgar tooni na, i pale itotoi eez pazi. Leso tiwatagh eez sindei tau yes aat titaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Zeran tauvene, lepoogh toozi pale poia kat. Ve natuzŋa paam, pale tileep poia izi taan tau Yoova igham pa tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, timin i zeetŋa duduuŋ. Tauvene i ivovotia ŋgar tooni yoŋgaaŋa pazi, ve ipaghazoŋai zi pa eez to yesŋa tivalupu zi timin eemon itaghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Saawe isov, yau naghurghur matag pa Yoova naghe i aat iuul ghau. I pale ipas agheg pa liis tau koiagŋa tighuru payau ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Yoova, yau besooŋa tsio. Tauvene matam imuul ilam payau. Lolom isaghatin ghau, ve uul ghau pa pataŋani tsiau. Pa yau zigau kat. Leg etag eta to iuul ghau pa pataŋani tsiau tane mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Lolog ipataŋan kat ve nagham ŋgar naol. Pasaa, yau leg eez eta mako. Upas ghau navot pa pataŋani tsiau tane loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Ughita pataŋani ve saghatiiŋ tiina tau ivot payau ne, ve uul ghau. Ve ureu sosor tsiau tisov tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ughita. Koiagŋa, yes eval. Ve atezi yavyav payau kat. Tighe le tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Eemon yau nanumeer ghom naghe yo aat ugham mulin ghau ila koiagŋa nimazi, ve uŋgin ghau naleep poi. Yau nayooŋ ilat tsio. Tauvene upul zi tiliiv ghau sov. Ighe mako, pale mayag. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Yoova, ŋgar tsiau iyaryaaŋ naghe nataghon ŋgar popoia tau iduduuŋ mon ila yo matam. Tauvene yo aat upoon ghau pa gabua sasaghati ta naol ne. Pasaa, yau naghurghur matag pa uleeŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Maaron, upas tamtamon tsio Israel tivot pa pataŋani toozi naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Mbouŋ to David O Yoova, yau naghe yo upaghazoŋai ghau ila tamtamon matazi ughe yau ŋeer duduŋag. Pasaa, laghooŋ tsiau, yau nataghon ŋgar duduuŋa mon. Ve naghur ilat tsio ariaaŋ. Lolog ruru payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yoova, ugabiiz ghau, ve utoov ghau. Utiir poghania lolog ve ŋgar tsiau, ve ughita: Naduduuŋ ila yo matam, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Monmon matag iŋgalŋgal ŋgar tsio tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Yo utaghon saveeŋ tsio irau saawe. Gabuam tana ipapalot ghau pa laghooŋ tsiau, tauta nataghon eez tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Yau yeŋa zeran karomŋa niluplup ghei mako. Yes tau tipamir tauzi pa ghuruuŋ ila toozi na, yau napaak zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Yau naghur koi pa yes tau tighamgham ŋgar sasaghati, ve naleep soghan pazi. Isaav ighe zeran sasaghati tilup zi, ene irau naleep tomani zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O Yoova, yau nataghon ŋgar duduuŋa mon. Tauta namin nimag, leso itotoi ighe yau leg sosor eta mako. Ve nalaagh livutin artaal tau tighamgham watooŋrau payo izala na, ve nasuŋsuŋ payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Yau aat nambou mbouŋ toman lolog poia ve napait ghom, ve navotia uraat tsio ŋgeretazi tau maata ite kat na. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yoova, yau lolog pa rumei tsio kat. Pa ene niam to lepoogh. Yo utotoi tapirim ve mbonarim tomania poia tsio ivotvot ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Yes tau tisosor pa eez tsio na, upasov ghau tomani zi sov. Ve yes tau tiliŋliŋ siŋ pa tamtamon na, urav ghau namaat tomani zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Zeran tauvene, nimazi igharghaar pa ghamuuŋ ŋgar sasaghati naol. Ve isaav ighe tighol zi to tigham ŋgar saghati eta, ene aat tiyok mon ve tighamu. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Eemon laghooŋ tsiau, yau nataghon ŋgar duduuŋa mon. O Yoova, yau besooŋa tsio. Lolom isaghatin ghau ve ugham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Yau nayooz tuŋia ila taan duduuŋa. Irau natap mako. Tauvene saawe tau tamtamon tsio tilup zi pa suŋuuŋ, yau aat nala tomani zi, ve napait ghom pa poia tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Mbouŋ to David Yoova imin ghazooŋa payau, ve i Uleeŋa tsiau. Pale naroi pa sei? Mako. Pasaa, yau nanumeer Yoova. I imin ruum ariaaŋa to nayooŋ ila loolo. Tauta naroi pa gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Isaav ighe zeran sasaghati tipaburigin malmal payau, ve koiagŋa tighe tikari ghau, ene pale Yoova igham aghezi ilot, ve titap. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Isaav ighe zaaba katini tilam tilivutin ghau to tigham malmal, ene irau lolog bubu ve naroi pazi mako. Isaav ighe malmal iburig ve koiagŋa tiŋarui ghau tilam, yau aat nanumeer Maaron ve nayooz ariaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Gabua eemon geeg ta yau lolog pani kat. Tauta naghe naghason Yoova pani. Saawe isov tau naleep izi taan, yau naghe le naleep toman Yoova ila rumei tooni loolo, ve naghita poia tooni. Yau naghe naleep ila rumei tooni loolo, leso naghasoni to itotoi tauu ve ŋgar tooni payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Isaav ighe pataŋani tiina eta ivot payau, i aat iŋgin ghau naleep poi ila niima saamba. I pale iŋgooz ghau ila rumei tooni loolo. Ve i pale isur ghau nazala maetaaz ta saaŋa we, leso koiagŋa tigham gabua eta payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Onoon, aazne, koiagŋa timeke tilam tilivutin ghau. Eemon naroi mako. Pasaa, Yoova pale iuul ghau ve naliiv zi. Tauvene nayoor eeza toman tintinig. Nagham watooŋrau pani ila rumei tooni loolo, ve nambou ve narav gita to napait eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yoova, ighe nataŋ rarai ghom pa uleeŋ, na ulooŋ taŋiiz tsiau. Lolom isaghatin ghau ve uul ghau. Pa yau besooŋa tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Yo usaav payau ughe: “Ulam usuŋ payau, leso natotoi taug payo.” Tauta lolog naghe nalat tsio, ve upatooŋ taum payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Yau besooŋa tsio. Uŋgooz naghom payau sov. Atem yavyav ve umbuzir payau sov. Maaron, muuŋ ve ilam, yo mon ta Uleeŋa tsiau. Tauvene upul ghau, ve ughur murim payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Isaav ighe tamaŋ ve tinaŋ tighur murizi payau, ene pale Yoova tauu igham ghau ve iŋgin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yoova, upaghazoŋai ghau pa eez tsio. Umuuŋ payau ve utotoi ghau pa eez duduuŋa. Pa koiagŋa katini tisasaŋan ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Upul ghau nala nimazi sov! Pa yes tiŋgalŋgal saveeŋ karom naol payau, ve tighamgham saveeŋ paroiŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Eemon yau naghur ila naghe yes irau tivaghamun ghau mako. Yau aat naleep matag yaryaare, ve naghita poia to Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Tauvene yo tau ughur ila to Yoova na, yau nasaav payo naghe: “Unumeer Yoova, ve ughur matam pani. Uroi sov. Lolom eemon, uyooz ariaaŋ, ve usaŋan pa uleeŋ tooni.” ");
INSERT INTO tuc_t_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Mbouŋ to David Yoova, yo uponpoon ghau pa koiagŋa imin maet tiina. Tauvene taŋiiz tsiau ilat payo. Ughur taliŋam pa suŋuuŋ tsiau tane ve uul ghau lak! Ighe ulooŋ ghau mako, ve uneneeŋ mon, ene pale namin yes tau timaat gha tizila puura to yes mateegha. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Aazne, yau nait nimag izaa iŋarui rumei tsio loolo tau patabuyaaŋ kat na, ve nataŋ rarai ghom pa uleeŋ. Ulooŋ taŋiiz tsiau tane ve lolom isaghatin ghau. Pa yau besooŋa tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Saawe tau yo ughur atuya pa zeran sasaghati, na ugherev ghau nala tomani zi sov. Yes tau tinoknok ghamuuŋ sosor na, nalaleg tomani zi sov. Zeran tawe tisasavia saveeŋ poia pa zetazŋa tighe lolozi pazi. Eemon ŋgar tau igheen ila lolozi na, ene ite. Tighe tivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Yes tikaria ghamuuŋ sosor wa. Tauvene ughur atuya pazi ve uŋgal matazi. Leso uyat ŋgar toozi saghati tawe. Ugham tauvene, o iduduuŋ. Pasaa, ŋgar tau tighamghamu na, poia mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Uraat tintiina tau Yoova niima ighamgham zi na, yes tigham ŋgar pani mako. Tauvene i pale ireu mbirisai zi gha tilalez kat, imin ruum tau tireu mbirisaini, ve irau tirao muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yau napait Yoova pa poia tooni. Pasaa, yau nataŋ raraini to iuul ghau, ve i ilooŋ taŋiiz tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yau naghamgham tapirig ila to Yoova, ve i imin sigheu payau. Yau naghur ila tooni ariaaŋ ila lolog, ve i iuluul ghau. Tauvene lolog poia le poia kat, ve napait eeza pa poia tooni ila mbouŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yoova tamtamon tooni tighamgham tapirizi ila tooni. Ve kinik tau Yoova tauu ighuru pa uraat tooni na, i iuluule ve iponpoona pa koiŋa imin didiiŋ ariaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Yoova, tamtamon tsio timin lem motot. Ugham mulin zi pa pataŋani toozi, ve ughur poia tsio izaa toozi. Matam pa sipsip tsio, ve uŋgin zi poi. Ta aazne, ve taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Mbouŋ to David Yam aŋela ariaŋamim to sambam, apakur Yoova. Apait eeza pa tapiri ve poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Apait Yoova! Pa i eeza tiina kat. I ipabood tauu pa ŋgar tooni patabuyaaŋ. Tauvene aput aghemim pani ve apaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yoova aliiŋa ila irau te ziige ta naol ne. Maaron tau eeza tiina na aliiŋa, ene imin lalaav luutu. Yoova isaav toman aliiŋa tiina izala te paavo. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yoova aliiŋa, ene tapiri tiina. Aliiŋa itotoia ighe i eeza tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yoova aliiŋa iŋgalŋgal valaghin ai mezepur tintiina to Lebanon. Aliiŋa iŋgalŋgal mbirisai zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yoova aliiŋa itok loloz tintiina to Lebanon, le tiyatyaat imin makau natŋa paghpaaghu tau tintinizi. Ve itok loloz Ermon, le iyatyaat imin bapolo sagsagŋa natuzŋa tau tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yoova aliiŋa igham nugh ighani milia, ve yav ighan. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Ve itok taan to nugh ŋginaaŋa le irur. Igham nugh ŋginaaŋa to Kades katkatia ilala ilamlam. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yoova aliiŋa igham mekmek sagsagŋa tau apozi na, tirur le tipoop pataghaaŋ. Ve igham ai raua tisov timburur tizi. Tauvene tamtamon tisov tau tilup zi pa suŋuuŋ ila rumei tooni loolo na, tisaav toman aliŋazi tiina tighe: “Tapait Yoova eeza. Pa i tapiri tiina kat!” ");
INSERT INTO tuc_t_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Muuŋ, yaa ivot toman tapiri ve itav taan. Saawe tana, Yoova ileep ila niia to ghamuuŋ pooz ve iŋgin gabua. Ve aazne paam, i kinik tau ileep ila niia to ghamuuŋ pooz. Pooz tooni pale ighengheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yoova ighamgham tapiri pa tamtamon tooni. I pale ighur poia tooni izazaa toozi, ve iŋgin zi tileep poi toman lolozi luuma. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau tigharaat Rumei Tiina ve tighuru imin Maaron le O Yoova, yau napait ezam. Pasaa, saawe tau naleep ila pataŋani tiina loolo, yo ugham mulin ghau, ve uit ghau nazaa muul. Imin ta yo upul ghau namaat, kanaŋ koiagŋa lolozi poia ve tipakur zi tighe tiliiv ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Yoova, Maaron tsiau, yau nataŋ rarai ghom to uul ghau. Ve yo upasov moroghooŋ tsiau, ve tinig poia wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Rigmon kanaŋ namaat gha nazila mateegha niazi. Eemon yo uul ghau, tauta naburig muul, ve aazne naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yam tamtamon to Yoova tau lolomim isaghavu ariaaŋ ve ataghon eez tooni na, apaiti ila mbouŋ tsiam. Yoova, i patabuyaaŋ. Tapiri ve ŋgar tooni, ene ite kat. Tauvene lolomim poia pani ve apait eeza pa poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Aatyavyav tooni ighengheen malau mako. Igheen rig, ve isov. Eemon poia tooni, ene izazaa toit irau saawe tau taleep izi taan. Isaav ighe tataŋ pa mboŋ, ene pale mboŋoozo, i igham ghiit loloon poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Saawe tau lepoogh tsiau poia mon, yau nasaav naghe: “Pataŋani eta irau ivot payau ve itok ghau ne mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Pasaa, yo ughamgham poghani ghau ve upapalot ghau. Tauta napakur taug naghe yau aat naleep tuŋia tauvene irau saawe, imin loloz tintiina. Eemon saawe tau yo uŋgooz naghom payau, roiŋ tiina igham ghau le nasaŋeeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Saawe tana, napoi ghom ve nataŋ rarai ghom naghe lolom isaghatin ghau ve uul ghau. Yau nasaav payo naghe: ");
INSERT INTO tuc_t_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“O Yoova, isaav ighe namaat gha nazila mateegha niazi, ene pale mateegh tsiau imin saa poia? Ughita. Mateegha tau tizila taan loolo gha timin ŋgaupup na, toozi eta irau ipait ghom? Ma toozi eta irau ivotia ŋgar tsio tau utataghon saveeŋ mbuaaŋ tsio? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Tauvene Yoova, ulooŋ suŋuuŋ tsiau tane. Lolom isaghatin ghau ve uul ghau lak! Pa yau besooŋa tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Aa ŋgarig gha upasov taŋiiz tsiau! Tauvene yau aat tintinig ve nator. Yo upasov pataŋani tsiau, ve uzuzuum uuli to moŋiiŋ izi pa tinig. Yo ugham ghau lolog poia kat, ve naleep ila poia tsio loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Tauvene irau naneneeŋ mako. Yau aat nambou ve napait ezam toman lolog isov. Yoova, yo Maaron tsiau. Yau aat napait ghom pa poia tsio ta aazne, ve taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Mbouŋ to David O Yoova, yau nanumeer ghom ve nayooŋ ilat tsio. Upul koiagŋa titatan ghau sov. Pa ighe tiliiv ghau, ene pale mayag. Ŋgar tsio iduduuŋ. Tauvene ugham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ughur taliŋam pa suŋuuŋ tsiau, ve rekia uul ghau! Yo Uleeŋa tsiau ariaaŋa. Yo uponpoon ghau imin maetaaz tau izala kat. Ve umin ruum ariaaŋa to nayooŋ ila loolo. Leso gabua eta ivaghamun ghau sov, ve naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Onoon kat. Yo Uleeŋa tsiau ariaaŋa. Yo uponpoon ghau imin maetaaz tau izala kat. Ve umin ruum ariaaŋa to nayooŋ ila loolo. Umuuŋ payau ve utotoi eez payau, leso upaghazoŋai ezam tiina ivot ighazooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ughita liis tau koiagŋa tighuru payau na, ve upasali ghau pani. Pa yo ta umin niag to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Yoova, yo Maaron tau utataghon saveeŋ mbuaaŋ tsio. Aazne, yau naghur taug ila nimam. Ugham mulin ghau pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Yau nanumeer Yoova mon. Tauvene yes tau tighurghur gabua soroksorok imin maaron pazi ve tibesbees pazi, na yau naghurghur koi pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Yau tintinig ve lolog poia payo. Pasaa, yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Saawe tau lolog ipataŋan kat, ve ateg ipaparav, yo ughita pataŋani tsiau ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Yo upul ghau nala koiagŋa nimazi mako. Yo upas ghau navot pa pataŋani tsiau, ve ughur ghau naleep poia ila nugh ghazooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yoova, yau besooŋa tsio. Lolom isaghatin ghau ve uul ghau lak! Pa aazne, pataŋani tiina igham ghau le lolog ipataŋan. Yau nataŋ tiina le matag isarsar, ve tapirig isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Lolog ipataŋan kat ve nayakyak irau saawe. Pataŋani tane aat iŋgoor saawe tsiau ilam tuuku. Igham ghau nayamaan taug naghe tapirig isov. Yau nakoŋkoŋ kat le tuag isov peria. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Koiagŋa tisov tigham ŋalalaŋ payau. Ve yes tau tileep tigharau ghau ne paam, tipaŋiŋizai ghau. Zetagŋa lolozi pa tilam tigharau ghau mako. Ve yes tau tighit ghau izi eeze na, tiroi ve tilaagh eez ziige ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Tamtamon matazi iŋgal ghau muul mako. Tighit ghau imin ta namaat wa. Yau namin uur tau ivavaal ve tisiki ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Yau nalooŋ eval tiina tivakamunai zi payau. Koiagŋa tilup zi ve tiil eez to tirav ghau namaat. Tauvene pataŋani naol ilivutin ghau le roiŋ tiina igham ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Eemon Yoova, yau nanumeer ghom. Tauta nasaav payo naghe: “Yo mon ta Maaron tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Saawe tau naleep izi taan, saa gabua ma ŋgar tau ighe ivot payau, ene yau naleep ila yo nimam. Upas ghau ila koiagŋa nimazi, ve upoon ghau pa yes tau tighamgham lilin ghau ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Yau besooŋa tsio. Lolom poia payau ve ugham poghani ghau. Yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Tauvene ugham mulin ghau pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yoova, yau nataŋ rarai ghom to uul ghau. Upul koiagŋa tiliiv ghau ve tipamayaŋin ghau sov. Utatan zeran sasaghati tawe tapirizi, leso mayazi. Ve usik zi tizila mateegha niazi, leso tineneeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Upoon avozi. Pa yes zeran to karom. Tipapait tauzi, ve tivevelegh tamtamon duduŋazi, ve tisiksik saveeŋ sasaghati naol pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","O Yoova, poia tsio, ene tiina le tiina kat. Yes tau tiroi payo ve titaghon eez tsio na, yo ughur lezi gabua popoia katini isasaŋan zi. Yes tau tinumeer ghom ve tiyoŋyooŋ ilat tsio na, yo pale ugham poghani zi ila eval tiina matazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Yo uŋgooz zi ila zigem. Tauvene koiazŋa tau tiliil eez pa ravuuŋ zi timaat na, irau tigham gabua eta pazi mako. Yo uŋgin zi tileep poi ila nimam saamba. Tauvene saveeŋ sasaghati tau koiazŋa tisiksiki pazi na, irau ivaghamun zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yau napait Yoova pa poia tooni. Pasaa, loolo isaghav ghau ariaaŋ, ve igham ŋgar poia kat payau. Saawe tau koiagŋa tilivutin ghau to tigham malmal payau, i iuul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Imin maata yau naroi naghe Yoova aat iziir ghau naghau pa maata wa. Eemon mako. Yau nataŋ raraini to iuul ghau, ve i ilooŋ taŋiiz tsiau, ve igham mulin ghau pa pataŋani tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Yam tamtamon to Yoova tau lolomim isaghavu ariaaŋ ve ataghon eez tooni na, aghur lolomim pani kat. Yes tau titaghon i aliiŋa na, i pale iŋgin zi tileep poi. Eemon yes tau tiveleghi ve tipapait tauzi na, i pale ighur atuya pazi, ve iyat katin ŋgar toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Tauvene yam tau anumeer Yoova ve aghurghur matamim pani na, aroi sov. Apariaaŋ taumim, ve ayooz ariaaŋ! ");
INSERT INTO tuc_t_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Mbouŋ to David Tamtamon tau ighe izoor Maaron aliiŋa ve isosor pa eez tooni, ighe Maaron ireu sosor tooni ilale, i aat tintini pa poia to Maaron tau izaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Onoon kat, tamtamon tau ighe ŋgar to karom eta igheen ila loolo mako, ve Yoova ighita ighe i le sosor eta mako, i aat tintini pa poia to Maaron tau izaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Saawe tau naŋgooz sosor tsiau, tuag tisov tiparyavyav le tapirig isov. Ve nayakyak irau mboŋ ve mataaz. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","O Yoova, onoon kat, saawe tana, nayamaan katin nimam irau mboŋ ve mataaz. Tauta igham ghau tapirig isov kat imin yaa tau aaz ighaaz le imaak. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Naleep le mako, ra navotia sosor tsiau payo. Ŋgar tsiau saghati, naŋgooza muul mako. Saawe tana, yau naghe: “Ŋgar tsiau to zoraaŋ Yoova aliiŋa, yau aat navotia ila tooni.” Tauvene navotia sosor tsiau payo, ve ureua ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Tauvene tamtamon tisov tau lolozi isaghav ghom ariaaŋ ve titaghon eez tsio na, isaav ighe pataŋani eta igham zi, ene yes aat tisuŋ payo. Isaav ighe pataŋani tiina kat ivot pazi imin yaa tau ivot toman tapiri, yo pale uul zi, leso pataŋani itatan zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Maaron, yo umin niag to yoŋgaaŋ. Yo uponpoon ghau pa pataŋani naol isov, ve ugham mulin ghau. Tauta eval tiina tau tilivut ghau ne, timbou ve tipait ezam toman aliŋazi tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Ve Yoova isaav payau ighe: “Yau aat napaghazoŋai ŋgar tsio, ve natotoi ghom pa eez to utaghoni. Yau aat matag payo, ve napaduduuŋ ghom pa ŋgar poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Tauvene ugham ŋgar poi. Dabam iyaryaaŋ imin hos ma doŋki sov. Yes lezi ŋgar mako. Tauta tamtamon tighurghur ain sirivu tomania waar ila avozi, leso tipaduduuŋ zi pa laghooŋ, ve titaghon ŋgar toozi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Zeran sasaghati, pataŋani naol pale igham zi. Ve yes tau tinumeer Yoova na, i pale loolo isaghav zi ariaaŋ, ve tileep ila poia tooni loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Yam zeran tau ataghon ŋgar duduuŋa, lolomim poia ve tintinmim pa poia to Yoova. Yam tau ŋgar poia igheen ariaaŋ ila lolomim na, asov lolomim poia pa Yoova ve ayoor eeza toman aliŋamim tiina! ");
INSERT INTO tuc_t_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Yam tau ataghon ŋgar duduuŋa na, lolomim poia pa Yoova, ve ayoor eeza toman aliŋamim tiina. Yam tau aghamgham ŋgar poia na, apait Yoova eeza, o iduduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Arav ambam ve gita, ve apakur Yoova. Arav gabua maata maata, ve apaiti ila mbouŋ tau aliiŋa poia na. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Ambou mbouŋ paaghu pani, ve arav poghania ambam ve gita. Leso mbouŋ tsiam paghuuna. Ambou tiina, ve apaiti toman lolomim poia! ");
INSERT INTO tuc_t_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Pa saveeŋ to Yoova, ene onoon ve iduduuŋ mon. Uraat naol tau ighamgham zi na, ene itotoia ighe i itataghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","I loolo pa ŋgar duduuŋa ve ŋgar to gharatooŋ pataŋani to tamtamon le iduduuŋ. Ve loolo isaghav tamtamon tooni ariaaŋ ve iuluul zi. Ŋgar tane, i itotoia irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Muuŋ, saveeŋ to Yoova mon, tauta gabua to sambam saamba tisov tivot. Aavo isaav, ve aaz, kaiyo, ve pitum tisov tivot ila sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","I igham te ila ilup ghi ila niia eemon. Mazavan tau muuŋ geeg itav taan na, ene i ighur poghania ila niia. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Yam tau aleep irau taan na, aroi pa Yoova ve ataghon ŋgar tooni. Yam nughmariŋ, aroi pani ve apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Pa i isaav mon, ve sambam ve taan tivot itaghon i tauu aliiŋa. I isaav ariaaŋ, ve gabua tisov tivot ve tigheen tuŋia ila niazi niazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Nugh nugh matazi iŋgal ŋgar katini tighe tigham zi. Eemon Yoova iponpoon eez pazi. Tauta ŋgar toozi tawe imin kaut sorok, ve le anooŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Eemon Yoova, isaav ighe maata iŋgal ŋgar eta, ene pale ŋgar tana iyooz tauvene irau saawe. Saa ŋgar tau ighe loolo ighur pani, ene pale ighengheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Yes Israela Maaron toozi, ene Yoova. Tauta tintinizi pa poia tooni tau izazaa toozi. I tauu isiigh zi, ve igham zi timin le motot. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yoova ileep izi sambam, ve maata izizi pa eval tiina to taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","I ileep ila niia to ghamuuŋ pooz, ve ighitghita tamtamon tisov tau tileep izi taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","I ta ighurghur ŋgar ila tamtamon eŋaeŋa lolozi. Ve ŋgar naol tau tamtamon tighamgham zi na, i iwatagh zi tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Isaav ighe kinik eta le zaaba katini, irau zaaba tana zigazi tiliiv pa malmal mako. Zaaba ariaŋazi paam. Irau tauzi tapirizi ve tiliiv koiazŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Ve hos tau zaaba tilandoov zi pa malmal na, tauvene paam. Isaav ighe tighur matazi pazi to tiuul zi ve tiliiv koiazŋa, ene aat tighur matazi pazi sorok. Onoon, hos tapirizi. Eemon irau tiuul zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Onoon kat, yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, i maata pazi. Yes tau tinumeer Yoova tighe i loolo isaghav tamtamon tooni ariaaŋ ve iuluul zi na, i iŋgin zi tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","I iuluul zi, ve igham mulin zi pa pataŋani toozi. Leso tileep poi. Ve isaav ighe pitool tiina ivot, i aat iuul zi, ve igham lezi aniiŋ ve tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Tauvene iit tanumeer Yoova ve taghur mataan pani. Pasaa, i Uleeŋa toit, ve imin sigheu pait. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","I mon, tauta loloon poia kat ve tintiniin. I patabuyaaŋ ve eeza tiina. Tauta taghur ila tooni ariaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yoova, yei nighur matamai payo to uul ghei. Ughur poia tsio izaa tsiei itaghon ŋgar tsio tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Mbouŋ to David Muuŋ, David ileep tomania Abimelek ve igham karom imin ŋgar tooni ivaghamgham. Tauvene Abimelek iziire ila. Mbouŋ tane iŋarui saawe tana Yau aat napait Yoova pa poia tooni irau saawe. Irau naneneeŋ mako. Monmon avog pale ipapaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Yau lolog poia pa Yoova, ve napakuru pa ŋgar popoia tau i igham payau na. Yes tau tinumeer Yoova ve tibadbaad pataŋani na, irau tilooŋ aliŋag tane, leso lolozi poia paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Yam alam itiŋa talup ghiit, ve tapakur Yoova. Itiŋa tapait eeza. Pasaa, i eeza tiina le tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Suŋuuŋ tsiau iŋarui Yoova, ve i ilooŋ ghau. Tauta igham mulin ghau pa gabua naol isov tau naroiroi pazi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Yes tau tighur matazi pani to iuul zi, ene pale lolozi poia ve tintinizi. I aat iuul zi. Irau tighur matazi pani sorok ve mayazi ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Muuŋ, pataŋani tiina igham ghau. Tauvene nataŋ rarai Yoova to iuul ghau. Ve i ilooŋ suŋuuŋ tsiau, ve igham mulin ghau pa pataŋani tsiau naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, aŋela tooni ilepleep tomani zi, ve iŋginŋgin zi. I ighamgham mulin zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yoova, i poia kat. Taumim atoova ve aghita. Yes tau tinumeera ve tiyoŋyooŋ ila tooni na, poia tooni izazaa toozi, le lolozi poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Yam tamtamon patabuyaaŋa to Yoova, aroi pani ve ataghon ŋgar tooni. Pa yes tau tighamgham tauvene, irau timbool pa gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion paghpaaghu, tapirizi tiina. Eemon saawe siriv, lezi aniiŋ mako ve pitool zi. Ve yes tau tizuari zi pa Yoova, ene irau timbool pa gabua poia eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Natugŋa, alam alooŋ saveeŋ tsiau tane. Yau naghe napaghazoŋai gham pa eez to aroi pa Yoova ve ataghon ŋgar tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Mindai, yo ughe uleep poia, ve uleep malau izi taan toman lolom poia? ");
INSERT INTO tuc_t_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ighe tauvene, o uŋgin poghania avom. Saveeŋ saghati, ma karom eta ivot ila avom sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ve ughur murim pa ŋgar saghati, ve ugham ŋgar poia mon. Uzuari ghom pa taghoniiŋ ŋgar luuma, ve uil eez to yamŋa tamtamon avalupu gham ve aleep poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Tamtamon duduŋazi, Yoova maata pazi, ve ighurghur taliiŋa pa taŋiiz toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Eemon zeran sasaghati, i ighurghur koi pazi. I pale ipasov zi pa taan le tisov kat. Murei pale tamtamon matazi iŋgal zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Saawe tau tamtamon duduŋazi titaŋ rarai Yoova pa uleeŋ, i iloŋlooŋ zi ve ighamgham mulin zi pa pataŋani toozi naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yes tau pataŋani igham zi le lolozi isaghat kat na, Yoova ileep igharau zi. Tamtamon tau ighe pataŋani itatani le tapiri isov, ene pale Yoova iuule. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Onoon, tamtamon duduŋazi, pataŋani naol ivotvot pazi. Eemon Yoova pale igham mulin zi pa pataŋani toozi ta naol ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","I pale iŋgin poghani zi kat. Irau tuazi eta ipol mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Eemon yes tau tizorzoor Yoova aliiŋa na, ŋgar toozi sasaghati pale imuul pa tauzi, ve irav zi timaat. Yes tau tighurghur koi pa tamtamon duduŋazi, ene pale Yoova ighur atuya pazi, leso iyat ŋgar toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yoova ighamgham mulin besooŋa tooni pa pataŋani toozi, leso tileep poia. Yes tau tinumeera ve tiyoŋyooŋ ila tooni na, i irau ighur atuya pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Mbouŋ to David O Yoova, uul ghau ve utatan koiagŋa tau aazne yeŋa nivazorai ghei ve tiŋoŋooŋ payau ne. Yes tau tighe tigham malmal payau ne, uvool tsiau ve uparav tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Unonogh ghom pa gabua tsio to malmal, ve ukis sigheu tsio, ve uburig ulam uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Upas iiz ve zaab tsio, ve upoon ghau pa yes tau tigham lilin ghau ne. Yau naghe nalooŋ ghom usaav payau ughe: “Yau Uleeŋa tsio. Yau aat nauul ghom.” ");
INSERT INTO tuc_t_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Yoova, yes tau tighe tirav ghau namaat ne, utatan tapirizi, ve ugham zi mayazi ve tighau tila. Yes tau tiil eez to tivaghamun ghau ne, ugham ŋgar toozi ivaghamgham, ve timuul tila toman mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yoova, naghe aŋela tsio inaan zi gha tighawaar, imin yaghur ivuvuur ŋgaupup. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Aŋela tsio tawe igham taghon zi, ve tilaan ila ndoroom loolo taghon eez tau pusukpusukia na, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Pasaa, yau nagham sosor eta pazi mako. Eemon yes tiraar puugh tighe tisaghav ghau. Ve titai puura tau izila kat, leso natap nazila. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Yoova, upateeŋ zi pa saghatiiŋ tiina eta. Ugham zi tighoon ila tauzi puugh toozi. Ve ugham zi titaptap tizila puura tau titaii payau na. Leso saghatiiŋ igham zi le tisaghat kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Yoova, ighe ugham tauvene, ene pale lolog poia kat payo, ve tintinig pa uleeŋ tau ugham payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Yau aat napait ezam toman lolog, ve naghe: “Yoova, sei ta imin yo? Eta mako! Pasaa, yes tau tapirizi imbool na, yo ugham mulin zi ila yes tau tapirizi tiina na nimazi. Yes mbolaaŋa ve yes tau tileep ila pataŋani loolo na, yo aat uvool toozi, ve ugham mulin zi ila umbuuŋa nimazi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Tamtamon naol tiburig ve tiŋgal saveeŋ karom payau tighe tivaghamun ghau. Eemon saveeŋ ŋgaliiŋ tau tinoknok ghasoniiŋ ghau pani ne, ene yau nakankaan pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Yau nagham ŋgar poia pazi. Eemon yes tipamuul ŋgar saghati payau. Tauta lolog ipataŋan kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Eemon saawe tau yes timorooŋ le tisaghat, lolog ipataŋan pazi, ve nagharaat taug mako. Ve naŋgun taug pa ghaniiŋ aniiŋ, ve naghur zi ila suŋuuŋ tsiau. Eemon suŋuuŋ tsiau tane, yo ugham anooŋa ivot mako. Tauta lolog ipataŋan kat, ve nataŋ pazi imin zetagŋa, ma toŋvetaz tsiau duduuŋ. Ve nalaagh matag izaa mako. Natudtud ve nataŋtaŋ, imin ŋeer tau loolo ipataŋan pa tiina imaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Eemon saawe tau pataŋani igham ghau gha naleep saghat, yes lolozi poia, ve tilup zi to tivaghamun ghau. Yes tau tighe tigham malmal payau ne, yau nawatagh zi mako. Nakankaan pa ŋgar toozi. Yes tinoknok ŋgaliiŋ saveeŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ve tisiksik saveeŋ veleghiiŋ naol payau. Atezi yavyav payau kat, ve tiŋaaŋ maripazi tighe le tikari ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Yoova, puughu mindai ta umamarar zi ve tighamgham ŋgar tauvene payau? Pale ŋeez o uul ghau? Yes timin laion tau tisasaŋan pa raŋgatiiŋ ghau. Tauvene ugham mulin ghau ila nimazi, leso naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ve ighe uul ghau, mako saawe tau tamtamon tsio tilup zi pa suŋuuŋ, yau aat nala tomani zi, ve napait ghom toman lolog poia. Pale napait varum ila eval tiina tawe naghozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Koiagŋa, muuŋ yeŋa lupuuŋ tsiei eemon. Eemon aazne, tighur koi payau sorok. Tauvene uul ghau lak! Mako pale tiliiv ghau ve tipakur zi. Ve tighan matazi payau, ve tighe: “Aa, ŋeer ta ivaghamgham wa!” O Yoova, ŋgar tauvene ivot sov! ");
INSERT INTO tuc_t_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Yes tisavia saveeŋ luuma eta to tilup tamtamon ve tileep poi ne mako. Tiŋgalŋgal saveeŋ naol pa tamtamon marowa to taan tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ve aliŋazi izazaa sorok, ve tisavsaav ila matag tighe: “Aa, ŋgarig gha nighit ghom!” ");
INSERT INTO tuc_t_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yoova, ŋgar toozi sasaghati ta naol ne, yo ughit zi wa. Uneneeŋ pazi sov! Tiina tsiau, uleep soghan payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Maaron, yo Tiina tsiau. Uburig ve uvool tsiau. Uyooz payau, ve utatan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yoova, Maaron tsiau, ŋgar tsio iduduuŋ mon. Tauvene uyooz payau, ve upaghazoŋai ghau ila tamtamon matazi ughe yau leg sosor eta mako. Uul ghau. Mako pale koiagŋa tipakur zi pa pataŋani tau igham ghau ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Mako lolozi poia ve tisaav tighe: “Aa, isov! Ŋgar tau taghe tagham pani, tauta ivot pani gha isaghat wa!” ");
INSERT INTO tuc_t_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Yoova, yes tau tipakur zi pa pataŋani tau igham ghau ne, ugham zi tivaghamgham, ve tighau tila toman mayazi. Yes tau tivelegh ghau ve tipapait tauzi na, upamayaŋin zi le mayazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Eemon yes tau tighe yo uul ghau ve upaghazoŋai ghau ila tamtamon matazi ughe yau leg sosor eta mako na, yes pale lolozi poia ve tintinizi, ve tiyoor ezam toman aliŋazi tiina. Ve tisavsaav tighe: “Yoova eeza tiina kat! Isaav ighe besooŋa tooni ileep poi, ene pale i paam loolo poia.” ");
INSERT INTO tuc_t_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Tauvene mboŋoozo ila le ravrav izi, avog pale ivotia ŋgar duduuŋa tau yo ughamghamu na, ve napapait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Mbouŋ to David, besooŋa to Yoova Ŋgar to zoraaŋ Maaron aliiŋa tau igheen ila zeran sasaghati lolozi, ene isavsaav pazi, ve ighamgham pooz pazi. Tauta matazi iŋgal Maaron mako, ve tiroi pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Sosor toozi tawe, ikau ŋgar toozi. Tauta tipapakur tauzi, ve matazi iŋgal sorok tighe Maaron ighita sosor toozi mako, ve irau ighur atuya pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Saveeŋ karom ve saveeŋ sasaghati mon ta ivotvot ila avozi. Ŋgar tau iuul ghiit to taleep poia, ene tipuli wa. Tauta tigham ŋgar poia eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ŋgar toozi iyaryaaŋ kat. Tighe le tigham ŋgar saghati mon. Mboŋ ta naol ne, tighengheen ila moogh toozi, ve matazi iŋgalŋgal pa saa ŋgar saghati tau pale tighamu. Eez saghati tawe, lolozi pa tipuli mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yoova, yo lolom isaghav tamtamon tsio, ve uluul zi irau saawe. Ŋgar tsio tana, ene tiina le tiina kat. Izala le ikis sambam saamba. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tsio paam. Izala le ikis taitai. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Ŋgar tsio duduuŋa, ene imin loloz tintiina. Ve ŋgar tsio tau ugabiiz tamtamon itaghon ŋgar duduuŋa ve ughur atuya pazi, ene paam tiina kat, imin mazavan belbeluuŋa tau izila le izila kat. Yoova, yo uŋgin tamtamon ve gabua maata maata to su ve nughei, ve uluul zi, tauta tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Maaron, gabuam tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi, ene gabua tauu. Tamtamon tisov tiyooŋ ila nimam saamba, imin tatareek natŋa tiyooŋ ila tinazi baage saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Rumei tsio, ene ivon pa gabua popoia maata maata. Tauvene tamtamon tighan le isooŋ zi. Poia tsio izazaa toozi imin yaa tiina tau irereer. Yo upaghun zi pani, ve tiyamaana poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Yo ta umin puughu pa gabua naol isov tau tileep matazi yaryaare. Ve ghazooŋa tsio isul ghei, tauta matamai ighazooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Yoova, lolom isaghav yes tau tiwatagh ghom. Yes tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na, utotoi poia tsio pazi, ve uul zi itaghon ŋgar tsio duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Tauvene yes tau tipapait tauzi ezazi ve tivelegh tamtamon tsio na, upul zi titatan ghau sov. Ve upul zeran sasaghati tinaan ghau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Aghita. Yes tau tinoknok ghamuuŋ ŋgar saghati, tauta Maaron irav zi titaptap tizi, le patazi tivaghengheen izala taan paavo. Irau tiburig muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Mbouŋ to David Zeran sasaghati tau aazne tipapakur zi na, ugham ŋgar naol pazi sov. Ve yes to ghamuuŋ sosor na, lolom ighaar pa gabua toozi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Pale tileep rig, mako tisaghat imin kikiliiŋ tau aaz ighaazo gha imalai. Pale timin gabua raua tau mbitaizi, ve tigorgor gha titaptap tizizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Unumeer Yoova, ve ugham ŋgar poia mon. Leso gabua eta ivaghamun ghom sov, ve uleep poia izi taan tau i igham pa tamtamon tooni na. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Lolom poia pa Yoova tauu. I pale igham gabua ivot payo itaghon yo lolom. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Saa ŋgar tau yo ughe ughamu na, unumeer Yoova, ve ughur taum ila i niima. I pale iuul ghom, ve itotoi ghom pa eez to utaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","I pale igham ŋgar tsio duduuŋa igheen ghazooŋa kat ila tamtamon matazi, imin aaz mbonari. Tauvene tamtamon pale tighilaal tighe yo lem sosor eta mako, ve ŋgar tsio poia mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Isaav ighe uraat to zeran sasaghati ilaan poia, ve tiyau lezi gabua naol ila eez saghati, na ugham ŋgar naol pazi sov. Atem izi, ve usaŋan Yoova. I tauu pale ighur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Tauvene atem yavyav ve ugham ŋgar naol sov. Uyai ghom ve utatan atem. Mako pale aate yavyav tsio tana igherev ghom, ve ugham sosor. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Pasaa, Yoova pale ipasov zeran sasaghati gha tilalez. Eemon yes tau tinumeer Yoova ve tighur matazi pani na, pale tileep poia ila taan tau i igham pa tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Malau mako pale zeran sasaghati tisov tilalez. Isaav ighe uil naghozi, ene pale irau ughit zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Eemon yes tau titatan tauzi ezazi ve tinumeer Yoova, yes pale tileep poia ila taan tau i igham pa tamtamon tooni. I pale igham zi tileep poia kat toman tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Zeran sasaghati tilup zi ve tiil eez to tivaghamunia tamtamon duduŋazi. Atezi yavyav kat ve tiŋaaŋ maripazi ila pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Eemon Yoova, i iŋiŋ pazi. Pasaa, i iwatagh: Malau mako pale saawe toozi ivot gha tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Zeran sasaghati tipas mbuzaagh toozi to tirav yes mbolaaŋa tau tirau gabua eta mako na. Ve tidaad paneegh toozi to tivanegh zi. Tighe tirav yes tau titaghon eez duduuŋa na. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Eemon Yoova pale ipamuul mbuzaagh toozi imuul pa tauzi. Ve paneegh toozi pale ipolpol. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Isaav ighe tamtamon duduuŋa eta le gabua ŋgiira mon, ene irau. Lepoogh tooni pale poia iliiv zeran sasaghati naol tau lezi gabua katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Pasaa, Yoova pale ipasov zeran sasaghati tapirizi. Eemon i ipapalot tamtamon duduŋazi, ve iŋgin zi tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yes tau lezi sosor ila Maaron maata mako na, Yoova iwatagh lepoogh toozi, ve maata pazi. Ve gabua tau i igham pazi motot na, ene pale igheen toozi taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Saawe tau ighe pataŋani ivot, yes pale tileep poi. Isaav ighe pitool ivot, ene pale tirau kat pa aniiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Eemon zeran sasaghati pale tisov tilalez. Yoova koiŋa pale timatmaat imin manman ruuŋgu tau timalai ve timburur tizi. Pale tisov imin yav mbuasa tau imbuŋ izaa, ve imbiriis gha ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Zeran sasaghati tighamgham bun, ve tiyatu mako. Eemon tamtamon duduŋazi, yes tireirei gabua toozi pa yes mbolaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Yes tau poia to Yoova izazaa toozi na, pale tileep poia ila taan tau i igham pa tamtamon tooni. Eemon yes tau aatyavyav tooni igheen toozi na, i pale ipasov zi gha tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yes tau titaghon eez to Yoova na, tighamu loolo poia kat. Ve i pale itotoi eez pazi, ve ipalot zi pa laghooŋ toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Tamtamon tauvene, isaav ighe aaghe ilot pa gabua eta, ene irau itap mako. Pasaa, Yoova ikiskis niima ve ipapaloti. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Saawe tau yau kukuag gha ilam aazne namin kooŋ ne, yau naghita Yoova ighur muuri pa tamtamon duduŋazi pai eta soone. Ve naghita toozi eta naatu pitoola, ve isuŋsuŋ tamtamon pa le aniiŋ soone. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Tamtamon duduŋazi matazi reiŋ gabua, ve tiyokyok pa tamtamon to tigham bun ila toozi. Ve natuzŋa paam timin eez to tamazŋa tighita poia to Yoova izaa to tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ughur murim pa ŋgar saghati, ve ugham ŋgar poia mon. Leso uleep poi ila taan tau Yoova igham payo na taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Pasaa, Yoova loolo pa ŋgar duduuŋa. Tauvene tamtamon tooni tau lolozi isaghavu ariaaŋ ve titaghon eez tooni na, i irau ighur muuri pazi mako. I pale iŋgin poghani zi taghon taghon gha ila. Eemon zeran sasaghati natuzŋa, i pale ipasov zi gha tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Zeran duduŋazi pale tigham taan tau Yoova igham pa tamtamon tooni na, ve tileep poia ta sewe irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Saveeŋ tau ivotvot ila tamtamon duduŋazi avozi, ene ŋgar poia igheen ila. Yes tisasavia ŋgar duduuŋa mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Tutuuŋ to Maaron toozi igheen ariaaŋ ila lolozi ve ŋgar toozi. Tauta irau titap mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Zeran sasaghati tighamgham lilin tamtamon duduŋazi. Tizuari zi tighe le tirav zi timaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Eemon Yoova ivolvool to tamtamon tooni. Irau ipul zi tileep ila koiazŋa nimazi ne mako. Ve isaav ighe tamtamon tipayooz zi pa savsaveeŋ, ene pale Yoova tauu iyooz ila murizi, ve ipaghazoŋai zi ighe lezi sosor mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Tauvene atem izi, ughur matam pa Yoova, ve utaghon duduŋai eez tooni. Leso ipakur ghom, ve ezam pa taan tau i igham pa tamtamon tooni na. Ve yo pale ughita Yoova ivaghamunia zeran sasaghati gha tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","36","Muuŋ, yau nawatagh ŋeer saghati ee. Saawe isov, i ipaparoi tamtamon, ve itatan zi le tileep saghat. Ŋeer tawe tapiri tiina kat. I imin ai mezepur tiina to Lebanon. Eemon murei, nalaagh izi nugh tooni, ve naghita ŋeer tana ileep muul mako. Nail naagho le mako. Aat ila mindai? ");
INSERT INTO tuc_t_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Matam ila pa yes tau lezi sosor mako, ve ugham ŋgar pa yes tau ŋgar toozi popoia mon na, ve ughita saa ŋgar ta ivotvot pazi. Ŋeer marowa tau ilup tamtamon timin eemon ve iuluul zi to tileep poia, i tomania paaghu tooni pale tileep poia taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Eemon yes to zoraaŋ Maaron aliiŋa, Yoova pale irav zi tisov timatmaat. Ve paaghu toozi paam. I pale ipasov zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yoova, i Uleeŋa to tamtamon duduŋazi. Isaav ighe pataŋani ivot pazi, i pale imin lezi niazi to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","I iuluul zi, ve ipaspas zi pa pataŋani toozi. I ighamgham mulin zi ila zeran sasaghati nimazi, ve tileep poi. Pasaa, yes tiŋaruini tila, leso tiyooŋ ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Mbouŋ to David Saawe tau tamtamon tigham watooŋrau ve tighason Maaron to maata iŋgal zi, timbou mbouŋ tane O Yoova, uyaon ghau toman atem yavyav sov. Ve isaav ighe upaduduuŋ ghau, na uŋgal matag sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Yo uvanegh ghau pa paneegh tsio natŋa, ve nimam itatan katin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Atem yavyav payau kat. Tauta tinig isov isaghat wa. Anoŋag sirivu eta igheen poi mako. Sosor tsiau, tauta tuag isov iyavyav gha nasaghat. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Pataŋani to sosor tsiau itatan ghau kat imin dibom tintiina tipolpol izala pavog. Tauta igham pataŋani tiina payau le irau nabaado mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Yau nagham ŋgar imin yes borauŋa ve nazoor aliŋam. Tauta aazne, mbotmboot toman nanagh tau vaazi saghati ne igham ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Yavyavuuŋ tiina igham ghau, ve natudtud ve nayakyak. Tauvene mboŋoozo ila le rabrab izi, lolog ipataŋan ve nataŋtaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Tinig ituntun kat, ve anoŋag isov isaghat wa. Anoŋag sirivu eta igheen poi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Moroghooŋ tane iŋgoor katin ghau le tapirig isov kat. Tauvene lolog ipataŋan ve nayakyak. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Yoova, yo uwatagh: Yau naghe yo uul ghau leso tinig poia. Yau lolog ipataŋan ve nataŋtaŋ. Gabua tane iyooŋ payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Aazne, ateg ipaparav ve tapirig imbool. Tauvene naghog poia muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Zetagŋa ve yes tau ruum toozi igharau ghau ne, tighita moroghooŋ tsiau tane, le tileep soghan payau. Tigharau ghau muul mako. Ve ziiri waaro tsiau tauvene paam. Tilam tigig ghau rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Koiagŋa tau tizuari zi pa ravuuŋ ghau namaat na, tighur liis katini payau. Mboŋoozo ila le ravrav izi, yes tisavsaav pa eez to tivaghamun ghau, Lolozi ighurghur pa eez yoŋgaaŋa to tikari ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Eemon matag ila pa saveeŋ toozi tawe mako. Yau naneneeŋ mon imin tamtamon tau aavo ve taliiŋa ivool, ve irau isavsaav mako, ve iloŋlooŋ saveeŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Onoon kat, yau namin tamtamon tau taliiŋa ivool ve iloŋlooŋ saveeŋ mako, ve irau iyol saveeŋ eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","O Yoova, Maaron tsiau, yau naghur matag payo ve nasaŋan ghom. Yau nanumeer ghom naghe yo pale ulooŋ suŋuuŋ tsiau tane ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Maaron, upul pataŋani tane iliiv ghau sov. Pa ighe natap, ene pale koiagŋa tintinizi, ve tipakur tauzi tighe tiliiv ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ughita. Yavyavuuŋ tane ipul ghau rigta mako. Moroghooŋ tane irav matin tapirig le naghe natap. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Onoon, yau nazoor aliŋam. Tauta aazne, lolog ipataŋan ve navotia sosor tsiau payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Koiagŋa, yes eval kat, ve tapirizi tiina. Ŋgar tau tigham payau ne, iduduuŋ mako. Pasaa, yau nagham sosor eta pazi mako. Yes tighur koi payau sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Ŋgar popoia tau muuŋ yau naghamgham pazi na, aazne tiyoli pa ŋgar saghati. Yes tighurghur koi payau pasaa, yau nazuari ghau pa ŋgar poia mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yoova, ughur murim payau sov. Maaron tsiau, uleep soghan payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yoova, yo ta Uleeŋa tsiau. Ulam rekia, ve uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Mbouŋ to David David itoor mbouŋ tane pa Yedutun, i ŋeer tau imuŋmuuŋ pa mbouŋ Yau nasaav pa taug naghe: “Yau aat naŋgin taug poi. Leso avog isosor sov. Isaav ighe naleep tomania zeran sasaghati, yau aat naŋgin avog poi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Tauvene napoon avog, ve nasavia saveeŋ eta mako. Nayai ghau, ve naneneeŋ mon. Eemon nagham ŋgar naol ila ila le lolog ipazaagh ghau naghe nasaav. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Pasaa, nagham ŋgar naol kat, le ateg basbasuuŋ. Tauta irau naneneeŋ muul mako, ve naghason Maaron naghe: ");
INSERT INTO tuc_t_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Yoova, upaghazoŋai ghau. Ndaman tsiau piiz ta ighengheen soone? Pale ŋeez o namaat ve nasov pa taan? Uul ghau leso naghilaal naghe: Malau mako pale lepoogh tsiau to taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Yo ughur leg saawe tuuku mon to naleep izi taan. Saawe to lepoogh tsiau izi taan, ene imin gabua sorok ila yo matam. Onoon kat, tamtamon tisov to taan lepoogh toozi, ene imin avuvuun tau ivot ila avoon. Tileep rig ve tisov. Irau taghit zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Tamtamon tilaghlaagh pa uraat naol. Eemon lepoogh toozi, ene tuuku imin ai yavyaava tau ighe aaz izila, ene taghita muul mako. Matazi imin naol, ve tilala tilamlam pa uraat tighe tindou lezi gabua katini. Eemon tirav tauzi sorok. Pasaa, tikankaan pa sei ta pale ighamuur gabua toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Yoova, saa gabua ta pale naghur matag pani to iuul ghau? Gabua eta mako. Yau naghur matag payo mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Yau nazoor aliŋam ve nagham sosor. Upul sosor tsiau isov, ve ugham mulin ghau pa pataŋani to sosor tsiau. Mako pale yes kankanooŋa tau tiwatagh ghom mako na tisik saveeŋ veleghiiŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Aazne, yau naneneeŋ mon. Irau saveeŋ eta ivot ila avog mako. Pasaa, yo taum ta ugham pataŋani tane ivot payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Maaron, uŋgal matag irao! Nimam ighanghan ghau le tapirig isov wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Isaav ighe tamtamon tigham ŋgar saghati, na yo uyaon zi ve uloslos zi to upaduduuŋ zi. Ve gabua toozi popoia tau lolozi pani kat na, yo uvavaghamunia imin up ivaghamunia uuli. Ene imin tau yau nasavia ila wa. Yei tamtamon to taan nimin kaut sorok. Nileep rigmon ve nisov, imin avuvumai tau ivotvot ila avomai ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yoova, upoon taliŋam pa taŋiiz tsiau sov. Ughur taliŋam payau, ulooŋ suŋuuŋ tsiau tane, ve uul ghau. Pa saawe tsiau to naleep izi taan, ene malau mako. Saawe tuuku tau naleep izi taan tane, yau naleep namin loom payo, raraate imin tibugŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Lolom isaghatin ghau ve upul ghau. Uŋgal matag irao. Leso saawe tuuku tau naleep izi taan ne, naleep toman lolog poia, mako namaat ve nasov pa taan.” ");
INSERT INTO tuc_t_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Mbouŋ to David Saawe tau pataŋani igham ghau, ateg izi ve nasaŋan Yoova. Ve i ighur taliiŋa pa taŋiiz tsiau, ve iuul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Muuŋ, lepoogh tsiau imin yau naleep ila puura to yes mateegha loolo. Eemon Yoova indai ghau nazaa. Agheg brusia ila tiiŋ tiina, ve naghe pale nazal nazila. Eemon i ipas ghau nazaa, ve ighur ghau nayooz ila taan ariaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ve ipaburigin ghau ve nambou mbouŋ paaghu. Ene mbouŋ to tapait Maaron toit eeza. Ŋgar tau Yoova igham payau na, pale igham eval tiina tighilaal. Tauvene yes pale tiroi, ve tighur ila tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Tamtamon tau ighe inumeer Yoova, ene pale tintini ve poia to Yoova izazaa tooni. Tamtamon tauvene, i ipaak yes tau tipapait tauzi ezazi ne mako. Ve yes tau tipul eez to Maaron, ve tibesbees pa maaron karomŋa na, i ileep soghan pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yoova, yo Maaron tsiau. Eta irau ghom mako. Pasaa, yo ughamgham uraat ŋgeretazi naol to uul ghei. Uraat tana, maata ite kat. Ve lolom ighur pa ŋgar popoia naol tau ughe ugham payei. Isaav ighe natoova to nanin zi tisov ve nasavi zi, ene aat narao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ŋgar to ravuuŋ gabua imin watooŋrau payo, tomania ŋgar to ghamuuŋ aniiŋ payo imin paitooŋ, ene yo lolom pani mako. Ve ŋgar to ghuruuŋ gabua izala artaal leso yav ighan dodolini, tomania ŋgar to ravuuŋ gabua pa rewaaŋ sosor to tamtamon, ene paam, yo ughur matam pani mako. Yo ugham taliŋag ikaak, leso nalooŋ aliŋam. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Tauta nasaav payo naghe: “Maaron, yau taug ene. Nataghon saveeŋ tau tiboode iŋarui ghau ila rau tsio, tauta nalam.” ");
INSERT INTO tuc_t_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Maaron tsiau, isaav ighe nataghon duduŋai yo lolom, ene igham ghau lolog poia le poia kat. Pasaa, tutuuŋ tau yo ugham payei na, igheen ariaaŋ ila lolog. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Yoova, yo uwatagh: Uleeŋ ve ŋgar tsio duduuŋa, yau naneneeŋ pani mako. Saawe tau eval tiina tilup zi pa suŋuuŋ, nasasavia varum pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Onoon kat, uleeŋ ve ŋgar duduuŋa tau utotoia payau na, yau naŋgooza igheen to taug mon mako. Ve gabuam tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi, ene paam, naŋgooza pa tamtamon tsio mako. Saawe tau tilup zi pa suŋuuŋ, yau nasasavia gabuam tana pazi. Ŋgar tsio tau uluul tamtamon itaghon saveeŋ mbuaaŋ tsio, ene navovotia pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yoova, matam kisin sosor tsiau sov. Lolom isaghatin ghau ve upul sosor tsiau. Ŋgar tsio tau lolom isaghav tamtamon tsio ariaaŋ ve utataghon saveeŋ mbuaaŋ tsio, ene aat imin sigheu payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Ughita. Aazne, pataŋani naol tilivutin ghau. Irau nanin zi mako. Ŋgar tsiau sasaghati atuya, tauta iŋarui ghau ne. Tauvene naghita naghe leg eez eta muul mako. Sosor tsiau, katini kat. Iliiv dabag rau. Tauvene naroi ve tapirig isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O Yoova, lolom isaghatin ghau ve ugham mulin ghau pa pataŋani tane! Ulam rekia mon ve uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Yes tau tiliil eez to tirav ghau namaat na, utatan zi ve ugham ŋgar toozi ivaghamgham, leso mayazi. Ve yes tau tighita pataŋani tsiau tane ve tintinizi pani na paam. Upamuul zi tila toman mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ve yes tau tisavsaav payau tighe: “Aa, ughita wa? Ŋgar tau nighe ivot payo, tauta ivot wa!” Zeran tauvene, utatan zi ve ugham zi tivaghamgham. Leso mayazi pa ŋgar tau tighamu na. ");
INSERT INTO tuc_t_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Eemon tamtamon tisov tau tizuari zi tighe le tiwatagh katin ghom na, yes aat lolozi poia ve tintinizi payo. Ve yes tau lolozi pa uleeŋ tsio, ene pale lolozi poia kat, ve monmon tisavsaav tighe: “Tapait Yoova. Pa i eeza tiina le tiina kat.” ");
INSERT INTO tuc_t_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Yoova, matam ilam payau lak! Pa pataŋani tane itatan ghau le tapirig imbool. Narau gabua eta muul mako. Yo mon ta irau uul ghau ve ugham mulin ghau. Maaron tsiau, uzuar sov. Ulam rekia mon ve uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Mbouŋ to David Isaav ighe tamtamon eta maata iŋgalŋgal yes mbolaaŋa ve iuluul zi, ene pale poia to Yoova izazaa tooni ve tintini. Ve isaav ighe pataŋani eta ivot pani, ene pale Yoova iuule. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yoova tauu pale imin sigheu pani ve iŋgini. Leso imaat sov, ve ileep poia. I pale ileep izi taan tau Yoova igham pa tamtamon tooni na, ve poia to Yoova izazaa tooni. Yoova irau ipuli ila koiŋa nimazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ve isaav ighe i imorooŋ ve ighengheen, ene pale Yoova tauu iŋgini, ve ipasov moroghooŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Yau nasaav naghe: “Yoova, yau nagham sosor payo wa. Lolom isaghatin ghau ve upasov moroghooŋ tsiau. Pa yau besooŋa tsio.” ");
INSERT INTO tuc_t_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Koiagŋa tisasavia saveeŋ sasaghati iŋarui ghau tighe: “Ŋeer tawe, ŋeez o imaat leso eeza ilale ve loloon iveegh pani?” ");
INSERT INTO tuc_t_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ve saawe tau tamtamon tilam tigig ghau, tisavia saveeŋ toman lolozi mako. Yes tilam to tigig ghau pa moroghooŋ tsiau mon. Ve saawe tau timuul tila, tisasavia varug sorok irau nugh tighe: “Paita imaat.” ");
INSERT INTO tuc_t_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Yes tau tighur koi payau ne, tisov tighe le nasaghat kat. Tauvene tikakamuun payau tighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Aa, ŋeer tawe, moroghooŋ saghati kat ighamu. Irau maata pakia ve iburig muul ne mako. Paita imaat.” ");
INSERT INTO tuc_t_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ve etag ite tau nanumeera kat naghe yeiru lupuuŋ tsiei eemon, ve niluplup ghei pa ghanghaniiŋ na, i paam ighur muuri payau, ve imin koiag. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Yoova, lolom isaghatin ghau ve uul ghau. Pa yau besooŋa tsio. Upasov moroghooŋ tsiau ve ugham tinig poia muul. Leso nayat ŋgar saghati tau koiagŋa tigham payau ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Yoova, aazne yau nawatagh naghe yo lolom poia payau. Pasaa, koiagŋa titatan ghau mako. Tauvene irau aliŋazi izaa sorok tighe yes tiliiv ghau ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Yau nataghon ŋgar duduuŋa mon. Tauta yo upalot ghau ve nayooz ariaaŋ. Ve yo pale ugham ghau naleep tomani ghom taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Tapait Yoova pa poia tooni! I Maaron to iit Israela. Tapait eeza ta aazne, ve taghon taghon gha ila. Onoon le onoon kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Mbouŋ to yes Kora Maaron, yau naghe le naleep nagharau ghom, o poia. Eemon aazne, naleep malau payo. Tauvene napasawal payo imin ŋgai sagsag tau murunu, ve iliil yaa tau irereer leso ighun. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Yoova, yo Maaron tau uleep matam yaryaare. Yau lolog payo kat imin tamtamon tau murun matini, ve iliil yaa pa ghunuuŋ. Pale ŋeez o nalat peria tsio muul, ve nayooz ila naghom ve nasuŋ payo? ");
INSERT INTO tuc_t_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mboŋoozo ila le ravrav izi, tamtamon tinoknok veleghiiŋ ghau tighe: “Maaron tsio ileep sindei?” Saveeŋ toozi tawe igham ghau nataŋtaŋ ve naghunghun matag suuru irau mboŋ ve mataaz. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Yau matag iŋgal imuul ila pa ŋgar tau muuŋ naghamghamu na, tauta navotia lolog ila to Yoova. Saawe tana, yau namuŋmuuŋ pa eval tiina, ve yeŋa nizazala pa Maaron rumei tooni, leso nilup ghei pa suŋuuŋ. Yei nimboumbou toman lolomai poia kat, ve niyoryoor Maaron eeza pa poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Tauta naghason taug naghe mindai ta aazne lolog isaghat? Lolog ipataŋan ve nagham ŋgar naol pasaa? Yau aat naghur ila to Maaron ariaaŋ, ve naghur matag pani. Pasaa, i Maaron tsiau ve Uleeŋa tsiau. Tauvene yau aat napaiti muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Onoon, aazne lolog ipataŋan kat, ve napasawal payo. Pasaa, naleep nagharau ghom mako. Yau naleep izi yaa Yordan daaba tau igheen izi loloz Ermon ziige tau ila pa loloz Mizar. Eemon yau aat matag iŋgal imuul ila pa ŋgar tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Pataŋani tau yo upuli ivot payau ne, ene itatan ghau kat. Ene imin yaa tau irereer toman luutu tiina na, iyatyaat izala pavog ve imbelmbeluut ghau. Ve imin dibom tintiina to mazavan tipolpol izala pavog. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Eemon mataaz ta naol ne, Yoova loolo isaghav ghau ve iuluul ghau. Tauvene mboŋ ta naol, yau namboumbou to napakuru. Suŋŋuuŋ tsiau iŋaŋarui Maaron. Pasaa, i ta iŋgin lepoogh tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Maaron, i Volaaŋa tsiau ariaaŋa. I iponpoon ghau imin maetaaz tau izala kat. Tauvene naghasoni naghe: “Puughu mindai ta lolom iveegh payau? Mindai ta upul koiagŋa titatan ghau, ve tigham ghau lolog isaghat?” ");
INSERT INTO tuc_t_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Saawe isov koiagŋa tisasavia saveeŋ veleghiiŋ payau. Ve tinoknok ghasoniiŋ ghau tighe: “Maaron tsio ileep sindei?” Saveeŋ toozi tawe iŋgalŋgal ghau imin iiz. ");
INSERT INTO tuc_t_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Tauta naghason taug naghe mindai ta lolog isaghat? Lolog ipataŋan ve nagham ŋgar naol pasaa? Yau aat naghur ila to Maaron ariaaŋ ve naghur matag pani. Pasaa, i Maaron tsiau ve Uleeŋa tsiau. Tauvene yau aat napaiti muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Maaron, yes tau matazi iŋgalŋgal ghom mako na, tighamgham pataŋani payau. Uyooz payau, ve upaghazoŋai ghau ila matazi ughe yau nagham sosor eta mako. Upas ghau ila zeran karomŋa ve zeran sasaghati tane nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Pa yo Maaron tsiau, ve yau nayooŋ ilat tsio. Puughu mindai ta ughur murim payau? Mindai ta upul koiagŋa titatan ghau, ve tigham ghau lolog isaghat? ");
INSERT INTO tuc_t_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Naghe ugham ghazooŋa tsio isul ghau ve upaghazoŋai ghau pa saveeŋ tsio onoon. Pasaa, gabua ru tawe pale titotoi eez payau ve tigham pooz payau, leso nazala pa niam to lepoogh tau igheen izi loloz tsio patabuyaaŋ daaba. ");
INSERT INTO tuc_t_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Mako naŋarui artaal tsio, ve nayooz ila naghom ve napait ghom. Pasaa, yo Maaron tsiau, ve yo ta ugham ghau lolog poia kat. Tauvene yau aat narav gita, ve nambou to napait ezam. Pasaa, yo Maaron tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Tauta naghason taug muul naghe mindai ta aazne lolog isaghat? Lolog ipataŋan ve nagham ŋgar naol pasaa? Yau aat naghur ila to Maaron ariaaŋ, ve naghur matag pani. Pasaa, i Maaron tsiau ve Uleeŋa tsiau. Tauvene yau aat napaiti muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Mbouŋ to yes Kora Maaron, muuŋ saawe to timbumaiŋa, yo ughamgham uraat tintiina pazi. Tauta tisisinaia ilam ilam le aazne, yei nilooŋa pa taumai taliŋamai paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Yes nugh nugh tau muuŋ tileep izi taan tane, ila taum tapirim, yo uziir zi tighau tila, ve upalepoghai timbumaiŋa tileep izi taan tane gha imin lezi motot. Yo utatan yes Kanaana le tapirizi isov kat, ve ugham timbumaiŋa tileep poia izi taan tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Onoon, timbumaiŋa tigham malmal pa taan tane. Eemon tauzi tapirizi ve mbuzaagh toozi igham zi tiliiv koiazŋa ne mako. Yo uleep tomani zi ve matam pazi, ve utotoi tapirim pa koiazŋa ve uparav tomani zi. Tauta timbumaiŋa tiliiv zi, ve tigham taan toozi imin lezi. Pasaa, yo lolom pazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Yoova, yo kinik tsiau ve Maaron tsiau. Yo usaav ariaaŋ ughe yei Israela tau siŋ to Yakop pale niliiv koiamaiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ila yo tapirim, yei nitatan koiamaiŋa. Yei nighur ilat tsio, ve suŋuuŋ tsiei iŋaŋarui ghom. Tauta yo uul ghei, ve nirav zi ve nivaghaaz zi ila aghemai saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Yau nanumeer paneegh tsiau mako. Ve mbuzaagh tsiau paam, ene irau igham mulin ghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Yo mon ta uluul ghei, ve ughamgham mulin ghei ila koiamaiŋa nimazi. Yo ugham zi tivaghamgham, ve tighau tila toman mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Maaron, yo uluul ghei, tauta monmon nipapakur ghom, ve lolomai poia payo. Yei aat nipait ezam taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Eemon aazne, yo ughur murim payei, ve upaak zaaba tsiei muul mako. Ve upul koiamaiŋa tiliiv ghei le mayamai kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Yo ugham ghei tapirimai imbool. Tauta nipul malmal ve nighawaar, ve koiamaiŋa tiyauur gabua tsiei isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Yo ughur ghei nila nimazi, imin sipsip tau timbit zi pa ravuuŋ zi. Ve ureu ghei nimbiriis irau nugh nugh. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Yei tamtamon tsio. Eemon aazne, ugholia ghei nila koiamaiŋa nimazi gha nimin besooŋa pazi. Ve ugham gabua tiina eta ila nimazi mako. Yo ughur atuyamai izi geeg, imin yei kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Yes tau tileep tigharau ghei na, tighita ŋgar tau yo ugham payei, le tiŋiŋ ve tigham ŋalalaŋ payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Yes nugh nugh tau tiwatagh ghom mako na, tighit ghei nimin mogheraaŋ. Ve tiŋiŋiŋ payei, ve tililiit dabazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Saawe isov, mboŋoozo ila le ravrav izi, tamtamon tipapamayaŋin ghau. Tauvene matag izaa mako. Mayag, ve natudtud mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Pasaa, tamtamon tighita ŋgar tau koiagŋa tiyoli payau na, ve tisiksik saveeŋ veleghiiŋ ve saveeŋ mayaŋa naol payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Yau nagham ŋgar naol naghe puughu mindai ta yo upul pataŋani naol tane ivot payei? Pasaa, yei lolomai iveghai ghom mako. Ve saveeŋ tau nimbua tomani ghom na, yei nireua mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Yei nighur murimai payo mako. Ve laghooŋ tsiei, nisosor pa eez tsio mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Eemon yo uvaghamun ghei kat, le nugh tsiei ŋginaaŋa imin gabua sagsagŋa niazi to lepoogh. Lepoogh tsiei, ene imin ndoroom tiina ikau ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","21","Maaron tsiei, yo uwatagh: Lolomai iveghai ghom mako, ve nisuŋ pa maaron karom eta mako. Imin ta nigham ŋgar tauvene, kanaŋ yo uwataghi. Pasaa, ŋgar ŋgozaaŋa isov tau igheen ila lolomai ne, eta iyooŋ payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Yei nibesbees pa yo mon. Tauta mboŋoozo ila le ravrav izi, koiamaiŋa tiravrav ghei nimatmaat. Tighit ghei nimin sipsip tau timbit zi pa ravuuŋ zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Yoova, ugheen irao! Uburig! Ugham ŋgar eta to uul ghei lak! Pale ughur murim payei tauvene taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Puughu mindai ta uŋgooz naghom payei? Ughita. Koiamaiŋa titatan ghei gha nisaghat wa. Pataŋani tiina tau nibadbaado ne, lolom iveegh pani sov! ");
INSERT INTO tuc_t_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Aazne, koiamaiŋa titatan ghei kat. Tauvene nitap nizi taan ve nigheen ila ŋgaupup loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Maaron, uburig! Ulam uul ghei lak! Yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Tauvene upas ghei nivot pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Mbouŋ to yes Kora Ŋeer tau imuŋmuuŋ pa mbouŋ na aat isaav pa tamtamon to timbouia itaghon aliiŋa ‘manman ruuŋgu pisosooŋa.’ Ene mbouŋ to tamoot ve livaa tau lolozi pa tauzi Lolog ipazaagh ghau pa saveeŋ popoia, tauta natoor mbouŋ tane iŋarui kinik. Avog raurau pa toraaŋ mbouŋ, imin ŋeer tau niima poia pa bodeeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","O kinik, yo paghunam kat uliiv tamtamon tisov. Ve saveeŋ popoia tau ivotvot ila avom, ene igham poghania tamtamon. Tauvene poia to Maaron aat igheen tomani ghom irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Yo ariaŋam ve urau kat pa ghamuuŋ malmal. Ezam tiina, ve upabood taum le paghunam kat. Ugham mbuzaagh tsio, ve ugharaat ghom pa malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Yo ezam tiina kat. Uzaa hos tsio, ve ula uparav tomania koiamŋa le uliiv zi. Uparav ariaaŋ pa saveeŋ onoon, ŋgar to tatatan tauun, ve ŋgar duduuŋa. Nimam tapir pale igham uraat tintiina. Leso koiamŋa tighita ve tiroi. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Kinik tsiei, paneegh tsio natŋa matazi kat. Tauta tiŋgal koiamŋa le tiyamaan katini. Tauvene yes nugh nugh pale tilam ve titaptap izi aghem saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Maaron, pooz tsio irau isov ne mako. Pale uleep ila niam to ghamuuŋ pooz irau saawe. Ŋgar duduuŋa tau ughamgham pa tamtamon na, ene imin ilaal pa pooz tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Pasaa, yo lolom pa ŋgar duduuŋa, ve ughurghur koi pa ŋgar saghati. Tauvene Maaron tsio ipakur ghom le uliiv zetamŋa siriv, ve iliŋ ŋgoreeŋ izala pavom to ighur ghom umin kinik. Tauta igham ghom lolom poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Nonoghiiŋa tsio mamalaua, ene tighur naunauŋ vaazi popoia maata maata ila. Ruum tsio, tipaboode pa gabua popoia tau tigharaat zi pa gabua zoŋazi. Yes to ravuuŋ gita ve gabua siriv tau lutuzi popoia na, tileep tomani ghom ila ruum tsio loolo, ve mbouŋ toozi igham ghom lolom poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Zilivaa tau lezi ezazi na tilam tileep tomani ghom ila ruum tsio paam. Ve toozi siriv, ene kinik natuzlivaŋa. Livaa paaghu tau iyooz ila pa nimam tapir ve ughe uvaii, i garwaat. I itiik tauu pa gabua popoia le paghuuna kat. Gabua tawe, tigharaat zi pa gol poia kat tau ilam pa taan sirivu to Opir na. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Natugliva, yo ughe uvai kinik. Tauvene ughur taliŋam poi ve ulooŋ aliŋag tane. Ugham ŋgar pa tamtamon tsio ve ziiri waaro tsio muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Yo paghunam kat. Pale usan kinik aate. I ta imin tiina tsio. Tauvene yo aat ulooŋ aliiŋa ve uleep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Tamtamon to nugh Tiro pale tigham lem gabua popoia katini. Yes tau kuaz tauŋa kat na, pale tigham lem gabua popoia maata maata. Leso matam iŋgal zi ve lolom poia pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Livaa garwaat tau ighe ivai kinik na, ileep ila ruum tooni loolo. I paghuuna le paghuuna kat. Nonoghiiŋa tooni, ene tisaii pa teret tau tigharaata pa gol. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","I inonogh ghi pa nonoghiiŋa tau ŋgeretazi popoia na, ve tighamu ila to kinik. Yesŋa zeetŋa zilivaa paghpaaghu tilaagh tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Tamtamon tintinizi, ve tigherev zi toman lolozi poia, gha tiloŋ tila ruum to kinik. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","O kinik, yo pale upoop natumŋa zitamoot katini, leso tiyol timbuzŋa. Ve yo pale ughur zi to tigham pooz pa nughmariŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Mbouŋ tsiau tane, tamtamon pale timbouia, ve matazi iŋgal ezam taghon taghon gha ila. Tauvene nughmariŋ pale tipait ezam irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Mbouŋ to yes Kora Maaron imin niaan ariaaŋa to yoŋgaaŋ, ve ipapalot ghiit. Isaav ighe pataŋani eta ivot pait, i pale ileep zigeen ve iuul ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Tauvene irau taroi mako. Isaav ighe yogyoog itok taan, ve loloz tipolpol tizila te loolo, ");
INSERT INTO tuc_t_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ve te isaghat gha dibom tipaparav, ve tisasabur loloz puughu le loloz tirurur, ene poia. Irau tasaŋeeŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Maaron Tiina Tau Iliiv Zimaronŋa Tisov na, nugh tooni patabuyaaŋ, i le yaa tau monmon irereer. Yaa tawe igham tamtamon to nugh tooni tileep poia toman tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Maaron ilepleep ila nugh tawe ve iŋginŋgini. Tauvene gabua eta irau itok nugh tawe mako. Isaav ighe pataŋani eta ivot pazi, Maaron irau isaŋan le mboŋoozo mako. Pale iuul zi rekia mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Nugh nugh, roiŋ tiina igham zi ve tisaŋeeŋ. Kinik to taan tapirizi isov, le nugh toozi tivaghamgham. Ve Maaron isaav aliiŋa tiina imin lalaav luutu, le taan ituntun ve ireer imin yaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yoova, i Maaron saksaki ve iŋgin gabua naol isov. I ileep tomani ghiit irau saawe. Maaron to Yakop imin niaan ariaaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Alam aghita uraat tintiina tau Yoova igham zi na. Uraat tooni igham tamtamon tiroi ve avozi ikaak. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","I ipapasov malmal irau taan ziige ta naol ne. Ve iŋgoor polpolin paneegh ve iiz, ve isan sigheu to malmal, ve isuruuv zi tizala yav. ");
INSERT INTO tuc_t_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","I isaav pa tamtamon ighe: “Aparav irao! Atemim izi, ve aghilaal ghau. Yau mon ta Maaron. Nughmariŋ pale tipait ghau, ve ezag imin tiina irau taan isov.” ");
INSERT INTO tuc_t_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yoova, i Maaron saksaki ve iŋgin gabua naol isov. I ileep tomani ghiit irau saawe. Maaron to Yakop imin niaan ariaaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Mbouŋ to yes Kora Yam nughmariŋ, tintinmim ve aposai nimamim! Yam asov ayoor Maaron eeza, ve ambou mbouŋ to apakuru! ");
INSERT INTO tuc_t_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Pa Yoova, i Maaron Tiina Tau Iliiv Zimaronŋa Tisov. Aroi pani ve ataghon ŋgar tooni. Onoon kat, i kinik tiina. Tamtamon tisov to taan tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","I itatan nugh nugh, ve ighur zi tileep ila sambamai. Yes tau tiwataghi mako na, i irav zi tizi, ve nivaghaaz zi ila aghemai saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Iit siŋ to Yakop, Yoova loolo igheen toit kat. Tauta irav motin taan sirivu, ve igham pait imin leen motot. Iit tintiniin ve tapakur ghiit pa taan tau i igham pait. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Maaron izala niia to ghamuuŋ pooz ve ileep ta sewe. Tauvene tavuur itaŋtaŋ, ve tamtamon tisirsir toman lolozi poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Ambou, ambou! Ambou ve apakur Maaron! Ambou ve apait kinik toit eeza! ");
INSERT INTO tuc_t_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Pa Maaron, i kinik tiina. Tamtamon tisov to taan tileep ila i saamba. Tauvene ambou mbouŋ to apakuru! ");
INSERT INTO tuc_t_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Maaron ileep ila niia patabuyaaŋ to ghamuuŋ pooz, ve iŋginŋgin nughmariŋ. Tamtamon tisov tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Daaba to nugh nugh tilup tomania iit tau tabesbees pa Maaron to Abaram na, ve itiŋa tapait eeza. Pasaa, pooza tisov to taan tileep ila i niima. Tapait eeza izala le izala kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","2","Mbouŋ to yes Kora Yoova eeza tiina kat. Tauvene iit tau taleep ila nugh tooni ne, aat tapait eeza izala le izala kat. Nugh tooni, ene igheen izala loloz tooni patabuyaaŋ Zion. Loloz tawe, ene paghuuna ve izala kat. Tamtamon tisov to taan lolozi poia pa loloz Zion ve tipaiti. Pasaa, ene Maaron tauu niia to lepoogh. Nugh to kinik tiina igheen ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Tamtamon tiwatagh: Maaron iponpoon nugh tooni imin didiiŋ ariaaŋa. I ilepleep ta sewe ve imin sigheu pazi. Tauta tamtamon to nugh tawe tileep poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","5","Kinik siriv tilup zi tighe tigham malmal pa Maaron nugh tooni. Eemon saawe tau tilam tighita, yes tirur pani, ve tiroi, ve tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","7","Roiŋ tiina igham zi le tisaŋeeŋ imin zilivaa tau apozi iyavyav pa popaaŋ. Ve yo uvaghamun zi le tisaghat kat, imin waaŋ tintiina to nugh Tarsis tau tighaughau tila, ve ragh izaa le irav mbirisai zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Yoova, i Maaron tsiei saksaki ve iŋgin gabua naol isov. Muuŋ, niloŋlooŋ uraat tooni tintiina varuzi mon. Eemon aazne, nileep ila nugh tooni, ve i igham uraat tauvene ivot muul, le nighit katini pa taumai matamai. Maaron ipapalot nugh tooni. Tauvene nugh tawe pale iyooz ariaaŋ taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Maaron, yei nileep ila rumei tsio loolo, ve matamai iŋgalŋgal gabuam tau lolom isaghav tamtamon tsio ve uluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Maaron, varum ilaan irau taan ziige ta naol ne. Tauta nughmariŋ tipapait ezam. Yo utotoi tapirim, leso upalot ŋgar duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Gabizooŋ tsio, ene iduduuŋ mon. Tauvene tamtamon tisov to nugh Zion, tomania nugh nugh to Yudea lolozi poia kat ve tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Yam aburig ve alaghlaagh ila nugh Zion loolo. Ala aghita didiiŋ ariaaŋa tau ilivut nugh na. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Anin ruum dabazi mamalaua tau yes zaaba tiyozyooz ila to tiyeel koiazŋa. Ve matamim ila pa ruum ariaŋazi to zaaba tiyooŋ ila ve tigham malmal. Leso yam aat asavia nugh tane pa paaghu tsiam tau pale tivot murei. ");
INSERT INTO tuc_t_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Pale asaav pazi tauvene: “Maaron toit tane, i ariaaŋa imin nugh Zion. I ileep irau saawe. Ve i pale imuuŋ pait, ve itotoi eez pait taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","2","Mbouŋ to yes Kora Yam nughmariŋ, alooŋ saveeŋ tsiau tane. Yam tamtamon tau aleep irau taan na, aghur taliŋamim payau poi. Yam tau lemim ezamim mako, ve yam tau ezamim tintiina na paam. Ve yam tau kuaz tauŋa, ve yam mbolaaŋa paam. Yam asov alooŋ poghania aliŋag tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Pa avog pale ivotia ŋgar popoia siriv tau igheen ila lolog ne. Saveeŋ tsiau tane irau ipaburigin ŋgar tsiam, leso aghilaal ŋgar poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Yau naghe nasavia saveeŋ palelaaŋ siriv payam. Le isov o, narav gita ve napaghazoŋai puughu payam. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Isaav ighe saawe saghati eta ivot, ve zeran sasaghati tomania zeran karomŋa tilivutin ghau to tivaghamun ghau, ene irau naroi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Onoon, yes tindoundou lezi gabua katini. Tauta tinumeer gabua toozi tawe, ve tipakur zi pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","8","Eemon gabua toozi tawe irau igham mulin zi pa mateegh mako. Pasaa, tamtamon eta irau ighol Maaron leso ipaghau mateegh pani ve lepoogh tooni to taan iseeŋga taghon gha ila ne mako. Ŋgar tauvene, tapuli ileple. Pa lepoogh tauvene, atuya ite kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Tauvene kuaz toit eta irau ipoon ghiit pa mateegh mako. Gabua eta to taan irau igham ghiit taleep le alok ne mako. Mako kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Iit taghita yes ŋgara timatmaat raraate imin yes kankanooŋa tau lezi ŋgar mako na. Ve saawe tau timaat, yes pale tipuliir gabua toozi naol isov izi ileple, ve gabua tawe imin tamtamon siriv lezi. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Saawe tau tileep matazi yaryaare, yes ezazi tintiina. Pasaa, lezi taan tiina ve gabua katini. Eemon saawe tau timaat, naal toozi imin lezi niazi irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Tauvene isaav ighe tamtamon eta eeza tiina, ve le gabua popoia katini, ene poia. Eemon gabua tooni irau ipaghau mateegh pani ne mako. Pale ileep rigmon, ve isov. Pale imaat gha ilale, raraate imin ŋgavuun ve ŋgai. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Ene eez to yes tau tigham ŋgar to borauŋa ve tipakur zi pa gabua toozi. Aghita ŋgar tau ivotvot pazi ve yes tau titaghon zi pa ŋgar toozi, o aghilaal. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Yes timin sipsip tau timbit zi pa ravuuŋ zi. Mateegh pale imin ŋginiiŋ pazi, ve igherev zi gha tizila mateegha niazi, ve patazi imbuuz ta sewe. Ve mboŋoozo, mako zeran duduŋazi pale tighit zi ve lolozi poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Eemon yau, nugh to mateegha le tapiri to ikis ghau mako. Pasaa, Maaron pale igham mulin ghau pa mateegh. I pale ipas ghau pa mateegh, ve igham ghau nala yeiru nileep. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Tauvene isaav ighe tamtamon eta indoundou le kuaz, ve gabua popoia katini ivon ila ruum tooni, na ugham ŋgar naol pani sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Pa saawe tau i imaat, i irau ikis gabua tooni eta ve ila ne mako. Gabua popoia naol tau i eeza tiina pani na, irau ila tomania mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","19","Saawe tau tamtamon tana ileep maata yaryaare, i ileep poia toman tintini. Ve eval tiina tipait eeza pasaa, tighita tighe i irao. Eemon i pale imaat, ve ileep tomania timŋa ila ndoroom loolo. Yes to nugh tawe irau tighita ghazooŋa muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Tauvene tamtamon tau ighe eeza tiina ve le gabua katini, ene poia. Eemon i ighilaal mako. Murei, i pale imaat gha ilale, raraate imin ŋgavuun ve ŋgai. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Mbouŋ to Asap Yoova, i Maaron saksaki. Aliiŋa ilat pa yam tamtamon to taan. I ipoi gham ighe yam asov alam alup gham ila naagho. Yam tau aleep ila pa aaz izaa, ve yam tau aleep ila pa aaz izila na paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Nugh Zion, ene paghuuna le paghuuna kat. Maaron ileep ta sewe, ve mbonari isul ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Maaron toit ighe ilam tane. Irau ineneeŋ muul mako. Yav ighan imuuŋ pani, ve yaghur tiina toman uman ilivuti. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","I ipoi sambam ve taan ighe tilam, leso tighita igabiiz tamtamon tooni ve ighur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Ve isaav ighe: “Tamtamon tsiau tau lolozi isaghav ghau ve titaghon ŋgar tsiau na, ayau zi tisov tilam tilup zi ila naghog. Ene yes tau tigham watooŋrau payo, ve timbu saveeŋ tomani ghau tighe yeŋa nivalupu ghei nimin eemon.” ");
INSERT INTO tuc_t_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Maaron igagabiiz tamtamon ve ighurghur atuya pazi. Ve gabua to sambam saamba tipaghazoŋaini tighe gabizooŋ tooni, ene iduduuŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Yam tamtamon tsiau Israel, alooŋ saveeŋ tau naghe nasavia payam. Pasaa, yau ta Maaron tsiam. Aazne, yau aat nasaav ila matamim, ve navotia sosor tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Watooŋrau tau aghamgham zi payau ne, yau nayaon gham pani mako. Monmon naghit gham aghurghur watooŋrau izala artaal, leso yav ighan dodolin zi. Ene poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Eemon yau irau nagham makau, ma mekmek tau tileep ila olol tsiam loolo ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Pasaa, yau nambool pa gabua eta mako. Gabua naol isov tau tilaghlaagh ila su loolo, ve makau tau tileep irau loloz ta naol ne, ene tsiau mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Ve man tau tirovroov ila taitai saamba na, yau nawatagh zi tisov ve naŋgin zi. Ve gabua naol isov tau tilaghlaagh ila regh loolo na paam, ene yau tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Isaav ighe pitool ghau, ene irau nasaav payam mako. Pasaa, taan tomania gabua naol isov tau tileep ve tigheen ila na, ene yau tsiau mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Mindai, yam aghe yau naghanghan makau miiza, ma naghunghun mekmek siiŋi? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Watooŋrau tau yau lolog pani, ene tauvene: Lolomim poia payau, ve apait ghau pa poia tsiau. Ve saveeŋ tau ambua tomania Maaron tsiam tau ileep saaŋa le saaŋa kat na, agham uratoini le anooŋa ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ve isaav ighe pataŋani igham gham, na ataŋ rarai ghau pa uleeŋ. Leso nagham mulin gham, ve apait ezag pa tapirig ve poia tsiau.” ");
INSERT INTO tuc_t_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Eemon yes zeran sasaghati, Maaron isaav pazi ighe: “Tutuuŋ tsiau tau naghur zi pataghaaŋ na, yam awatwaat zi sorok pasaa? Ve puughu mindai ta asasavia saveeŋ tau nambua tomania tamtamon tsiau ne?” ");
INSERT INTO tuc_t_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Pa saawe tau yau napaduduuŋ gham, yam ambuzir pa aliŋag. Ve azorzoor saveeŋ tsiau ve aveleghi imin kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Isaav ighe aghita umbuuŋa eta, na yam lolomim poia pani, ve aghamu imin etamim. Ve yes tau tighurghur boog na, yam apaak zi ve yamŋa alaghlaagh. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Saveeŋ sasaghati ve karom naol, ta ivotvot ila avomim. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Yam aŋgalŋgal saveeŋ pa ziiri waaro tsiam, ve avavaghamunia toŋvetaz tsiam ezazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Mindai, yam aghamgham tauvene ve aghita naneneeŋ, tauta aghe yau nayok pa ŋgar tsiam tana? Yam aghe itiŋa rarateen? Mako! Tauta aazne, yau nayaon gham, ve nasaav ila matamim, ve navotia sosor tsiam ivot ighazooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Tauvene yam tau lolomim iveghveegh payau na, ayamaan gham! Mako pale naburig, ve navaghamun gham kat. Ve eta irau ipas gham ila nimag mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Tauvene lolomim poia payau, ve apait ghau pa poia tsiau. Pa watooŋrau tauvene, tauta igham ezag imin tiina. Tamtamon tau maata iŋgal tauu pa laghooŋ tooni, ene pale natotoi uleeŋ tsiau pani, ve nagham mulini. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau David igham sosor tiina ve propet Natan ila iyaoni 2Sam 12:1+ O Maaron, yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Tauvene lolom isaghatin ghau ve upul sosor tsiau. Yau nazoor aliŋam. Eemon poia tsio, ene tiina kat, ve lolom isaghatin tamtamon tsio kat. Tauvene ureu sosor tsiau isov ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Yau nasosor pa eez tsio, ve nagham ŋgar saghati ila yo matam. Urughuuz ghau, ve ugham ghau naŋgalaaŋ ila yo matam muul. Ureu sosor tsiau isov ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Pa yau naghilaal sosor tsiau wa. Yau nazoor aliŋam ve nasosor pa eez tsio. Saawe isov, sosor tsiau ighengheen tomani ghau, ve matag iŋgalŋgali. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Sosor tau naghamu ne, ene iŋarui ghom mon. Yau nagham ŋgar saghati ila yo matam. Tauvene isaav ighe uvotia sosor tsiau ivot ighazooŋ, ene iduduuŋ. Onoon kat, isaav ighe ugabiiz ghau ve ughur atuya payau, ene sosor mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Saawe tau tinaŋ ipoop ghau ve ilam, yau nasosor pa eez tsio. Saawe tau tinaŋ inaam ghi payau, saghati ikis ghau pataghaaŋ wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Maaron, yo ughe yau nataghon saveeŋ onoon toman lolog. Tauvene taum upaghazoŋai ghau pa ŋgar popoia. Leso nakisi tuŋia ila lolog. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ureu sosor tsiau isov ilale. Leso naŋgalaaŋ ila yo matam. Urughuuz ghau le naŋgalaaŋ kat imin taitai pisosooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Yau naghe nalooŋ ghom usaav ughe yo ureu sosor tsiau wa. Leso tintinig ve lolog poia muul. Yo ughur pataŋani tiina kat iŋarui ghau pa sosor tsiau. Uul ghau, leso tintinig muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ŋgar tsiau naol tau isosor pa eez tsio na, matam ila pani muul sov. Ureu sosor tsiau isov ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Maaron, ugham ŋgar ŋgalaaŋa ivot ila lolog, ve upalot ghau. Leso nayooz tuŋia muul ve nataghon duduŋai ŋgar tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Uziir ghau pa naghom sov. Ve usan Avuvum Patabuyaaŋ ighau payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Muuŋ, yo ugham mulin ghau le lolog poia kat. Aazne, naghe ugham tauvene payau muul. Upaburigin ghau, leso matag loŋloŋai payo irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ighe ugham tauvene, yau aat napaduduuŋ yes tau tizorzoor aliŋam, ve yes tau tighamgham sosor na, pale titoor ŋgar toozi imuul ilat payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Maaron, sosor tsiau to naliŋ siŋ, ene tiina kat. Irau to namaat pani. Eemon yo Maaron tsiau ve Uleeŋa tsiau. Tauvene ugham mulin ghau, ve ureu sosor tsiau ilale. Leso lolog poia kat, ve nambou toman aliŋag tiina, ve napait ezam pa ŋgar tsio duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Yau mayag pa sosor tsiau, ve naneneeŋ mon. Tauvene ureu sosor tsiau ilale. Leso avog pakia, ve napait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Maaron, yo lolom pa nagham ŋgai imin watooŋrau payo mako. Watooŋrau tau yav ighan dodolini na paam. Imin ta igham ghom lolom poia, kanaŋ naghamu. Eemon yo lolom pa ŋgar tauvene kat mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Watooŋrau tau yo lolom pani na, ene tauvene: Yau aat natatan taug, ve lolog ipataŋan pa sosor tsiau. Ene watooŋrau tauu. Tamtamon tau ighe itatan tauu, ve loolo ipataŋan pa sosor tooni, ene yo irau ughur murim pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Maaron, ugham poghania nugh Zion itaghon taum lolom. Ugharaat mulin didiiŋ ariaaŋa tau ilivut Yerusalem na, le izaa iyooz muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Leso nigham watooŋrau tau iduduuŋ ila yo matam. Pale niyau makau tilam, ve nighur zi izala artaal tsio ve yav ighan dodolin zi. Leso ughita ve lolom poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau Doeg tau Edom tamazi na ila ipaes pa Saul ighe David ileep tomania Ahimelek Yo ŋeer ariaŋam, mindai ta aliŋam izazaa, ve upakur ghom pa ŋgar saghati tau ugham pa Maaron tamtamon tooni? Poia, ughamu lak! Eemon saawe isov, Maaron loolo isaghav tamtamon tooni ve iuluul zi. Ŋgar tooni tawe irau isov ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Yo ŋeer to karom! Monmon, uiliil eez to uvaghamunia tamtamon. Ve saveeŋ isov tau ivotvot ila avom, ene imin gharghar tau maata kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ŋgar poia ve saveeŋ onoon, yo lolom pani mako. Ve ŋgar saghati ve saveeŋ karom, yo lolom pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Yo avom karom. Ve saveeŋ sasaghati naol tau ivaghamunia tamtamon na, yo lolom pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Tauvene Maaron pale ivaghamun ghom le usaghat kat. Irau uburig muul mako. I pale iloŋ ila ruum tsio loolo, ve isasaar ghom uvot ula muuri, mako ipas ghom ila yes tau matazi yaryaare na sosozi, ve isik ghom uzila nugh to mateegha. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ŋgar tau Maaron pale igham payo na, ighe zeran duduŋazi tighita, ene pale tiroi. Mako tiŋiŋ payo, ve tisaav tighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Aghita. Ene ŋeer tau loolo pa igham uleeŋ ila to Maaron ve iyooŋ ila tooni mako. I kuaz tauu kat. Ve inumeer gabua tooni naol tawe toman ŋgar tooni saghati ighe pale ighamu ileep poi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Eemon yau pale nayooz tuŋia ve naleep malau izi taan, imin ai oliv tau iyooz iloŋ ila Rumei to Maaron sirsiira. Pasaa, yau nanumeer Maaron naghe i pale loolo isaghav tamtamon tooni ve iuul zi taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Maaron, yau lolog poia kat pa ŋgar tau yo ughamu na. Tauvene yau aat napait ghom pa poia tsio taghon taghon gha ila. Ve napait ezam ila yes tau lolozi isaghav ghom ariaaŋ na matazi, ve nasavi ghom pazi naghe: Yo poiam le poiam kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Mbouŋ to David Yes kankanooŋa tau tiwatagh Maaron mako na, tigham ŋgar ila lolozi tighe: “Maaron eta ileep mako.” Zeran tauvene, Maaron loolo pazi mako kat. Pasaa, ŋgar toozi isaghat wa. Tauta tighamgham ŋgar sasaghati naol. Eta igham ŋgar poia mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Maaron ileep izi sambam, ve maata izizi pa tamtamon. I ighe ighita: Toozi eta ighilaalo, ve izuari ghi ighe le iwatagh katini, ma mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Eemon tisov tipul murizi pani, ve tisaghat wa. Toozi eta igham ŋgar poia mako. Mako le mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Tauvene Maaron igham ŋgar naol ighe: “Zeran tau tinoknok ghamuuŋ ŋgar sasaghati na, lezi ghilalooŋ ma mako? Saawe isov, yes tipapasov tamtamon tsiau, le gabua toozi isov kat, imin yes tau luazi itaŋ pa ghaniiŋ aniiŋ popoia, ve tighan suvinia. Ve matazi iŋgal ghau ve tisuŋ payau mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Zeran tauvene aat tiyamaan zi. Pasaa murei, roiŋ tiina kat pale igham zi. Muuŋ, tiroi tauvene mako. Eemon tipaburigin malmal payam, tauta Maaron pale irav zi timatmaat, ve tuazi igheen imin ŋgiriis. Tauvene yam pale aliiv zi, ve mayazi. Pasaa, Maaron ighur muuri pazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Oyai, Maaron tau ileep izi nugh Zion na, iuul yes Israela ve igham mulin zi pa pataŋani toozi, o poi! Isaav ighe Maaron iuul tamtamon tooni, ve tileep poia muul, ene pale tintinizi. Onoon kat, Yakop paaghu tooni pale lolozi poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau tamtamon to nugh Zip tila to Saul, ve tipaes pani tighe David iyoŋyooŋ ila sosozi. Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane O Maaron, yo ezam tiina pa tapirim ve poia tsio. Uvool tsiau ve upas ghau navot pa pataŋani tsiau tane! Utotoi tapirim pa koiagŋa, ve ugham mulin ghau ila nimazi. Leso upaghazoŋai ghau ila tamtamon matazi ughe yau nagham sosor eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Maaron, ughur taliŋam pa suŋuuŋ tsiau. Ulooŋ aliŋag tane ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Pa zeran sasaghati to nugh malau tilam tipaburigin malmal payau. Yes tau tizuari zi pa ravuuŋ ghau namaat ne, tamtamon tiroi pazi. Pasaa, lolozi isaghatin tamtamon rigta mako. Yes tipapakur tauzi, ve matazi iŋgal Maaron mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Eemon Maaron, i Uleeŋa tsiau. Yau naleep ila Tiina tsiau niima, tauta aazne naleep matag yaryaare. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ŋgar saghati tau koiagŋa tigham payau ne, upamuule ila pa tauzi. Upasov zi le tisov kat itaghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Yoova, yo poiam kat! Tauvene lolog poia payo, ve naghe nagham watooŋrau to napait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Pasaa, yo uul ghau ve upas ghau navot pa pataŋani tsiau naol isov. Yo utatan koiagŋa ila taug matag, ve naliiv zi wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Mbouŋ to David Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane O Maaron, ughur taliŋam pa suŋuuŋ tsiau. Yau nataŋ rarai ghom: Lolom isaghatin ghau ve uul ghau. Uŋgooz naghom payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ulooŋ suŋuuŋ tsiau tane, ve uul ghau. Pa pataŋani naol igham ghau le isooŋ ghau kat. Tauta lolog bubu ve tapirig isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Koiagŋa aliŋazi izazaa, ve tigham saveeŋ paroiŋ payau. Zeran sasaghati tawe tigham pataŋani tiina payau tighe titatan ghau. Atezi yavyav payau, ve tighur koi payau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Paita namaat tane. Tauvene ateg ipaparav, ve naroi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Roiŋ tiina igham ghau le tinig irur, ve punitag izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Tauvene napasawal naghe: “Oyai, leg bageg imin mbuun, o poi! Leso naroov naghau nala nugh malau, ve namariau. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Pale nala nala le nala nugh ŋginaaŋa ta malau geeg we, ve nail niag poia eta to naleep pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Onoon kat, imin ta leg bageg imin man, kanaŋ rekia mon naghau nala ve nail niag eta to yoŋgaaŋ. Leso naleep ta sewe, ve nasaŋan le pataŋani tane isov. Pasaa, ene imin naleep ila uman ve yaghur tiina loolo.” ");
INSERT INTO tuc_t_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Tiina tsiau, ukau zeran sasaghati tawe saveeŋ toozi, leso ighur anooŋa sov. Ve upasov zi gha tilalez. Pa yau naghita ŋgar to ghamuuŋ malmal ve zoraaŋ saveeŋ ivon kat ila nugh tiina tane loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Mboŋ ve mataaz, ŋgar tauvene ivotvot ila nugh loolo. Nugh tane ivon kat pa ŋgar sasaghati naol ve pataŋani. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Onoon kat, tamtamon tivaghamunia lepoogh to nugh le isaghat kat. Tamtamon to nugh tane, isaav ighe tilup zi izi maaran to tigharaat saveeŋ, ma tiraukol, ene monmon titatan zetazŋa ve titombaan zi, leso tium gabua toozi. Ŋgar toozi tawe, tipulpuli mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Imin ta koiag eta ivelegh ghau, kanaŋ poia. Pataŋani tauvene, yau irau nabaado. Ve imin ta tamtamon ite paam tau ighur koi payau na, maata tatanin ghau, kanaŋ poia. Pasaa, tamtamon tauvene, yau irau nayooŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Eemon mako. Ena yo ta muuŋ, naghit ghom naghe ituru ŋgar toit eemon. Ve naghe pa yo ŋeer tsiau, ve etag duduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Ve tinig irav ilat tsio, ve naghita ituru lupuuŋ toit poia. Ve muuŋ, itiŋa eval tiina taluplup ghiit pa suŋuuŋ ila Maaron rumei tooni loolo. Eemon aazne, yo uzi gha umin koiag. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Maaron, koiagŋa lolozi ve ruum toozi, ene ivon pa ŋgar sasaghati naol. Upateeŋ zi pa mateegh, o poia. Naghe tileep matazi yaryaare ve tizila nugh to mateegha. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Tauvene yau aat napoi Maaron to iuul ghau. Yau nawatagh: Yoova pale igham mulin ghau pa pataŋani tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Saawe isov, yau nataŋ raraini pa mboŋoozo, zegmatuugh, ve ravrav, ve navotia pataŋani tsiau pani. Ve i pale ilooŋ aliŋag, ve iuul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Onoon, koiagŋa katini tilup zi tighe tigham malmal payau, ve titatan ghau. Eemon Maaron pale ipas ghau ila nimazi, ve naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","I pale ilooŋ suŋuuŋ tsiau, ve itatan zi. Pasaa, muuŋ geeg ve ilam, i ilepleep ila niia to ghamuuŋ pooz. Ve itortoor ŋgar tooni mako. Tauvene yes tau tiroi pani mako, ve ŋgar toozi iyaryaaŋ tighe tizoor i aliiŋa na, i pale itatan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Etag tau muuŋ yeiru niluplup ghei na, ighita saveeŋ mbuaaŋ tooni imin kaut sorok. Tauta ireu saveeŋ tooni, ve igham malmal pa zeetŋa tau muuŋ yesŋa lupuuŋ toozi eemon na. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Saveeŋ tooni, ene poia ve ŋgoreeŋa kat. Eemon ila loolo, i ighe igham malmal. Talooŋ saveeŋ tooni tawe, ve taghe pa i ighe igham loloon poia. Eemon mako. Saveeŋ tau ivot ila aavo na, iŋgal tamtamon imin mbuzaagh. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Saa gabua ma pataŋani tau ighe ivot payo na, ughur zi tila Yoova niima. I pale ipariaaŋ ghom, ve ikis ghom uleep poi. Pasaa, i maata iŋgalŋgal zeran duduŋazi. Irau ipul zi titap pa tovaaŋ eta ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Eemon zeran karomŋa, ve yes tau tiliŋliŋ siŋ pa tamtamon na, Maaron, yo pale urav motin saawe toozi tuuku, ve usik zi tizila nugh to mateegha. Ve yau, o nanumeer ghom naghe pale uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau yes Pilistia tikis David izi nugh Gat. Aliiŋa tauvene: ‘Mbuun tau ileep nugh malau ve ineneeŋ mon.’ O Maaron, yau besooŋa tsio. Lolom isaghatin ghau, ve uul ghau lak! Pa koiagŋa tinanaan ghau ne. Mboŋ ve mataaz, tamtamon tizuari zi tighe le titatan ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Saawe isov, yes tau tiŋgalŋgal saveeŋ payau ne, tighamgham lilin ghau tighe tirav ghau namaat. Yes tau tighamgham malmal payau ne, eval kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Maaron, yo Maaron Tiina Tau Uliiv Zimaronŋa Tisov. Saawe tau roiŋ tiina igham ghau, yau aat nanumeer ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Yau napakur Maaron pa saveeŋ mbuaaŋ tooni, ve naghur ila tooni ariaaŋ. Irau naroi mako. Pasaa, tamtamon to taan tapirizi igheen sindei, leso tivaghamun ghau? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Saveeŋ tsiau, ene poia. Eemon saawe isov, ta mboŋoozo ila le ravrav izi, koiagŋa titortoor aliŋag muul imin saveeŋ saghati. Ve tiliil eez tighe le tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Tilup zi ve tipapadeu pa laghooŋ tsiau, ve tisasaŋan tighe tirav ghau namaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Maaron, puughu mindai ta upul zeran sasaghati tawe tileep? Uyat ŋgar toozi tawe lak! Utotoi aatyavyav tsio pazi, ve utatan zi, leso tapirizi isov kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Yo uwatagh: Yau nabaad pataŋani naol ve nataŋtaŋ. Eemon pataŋani tsiau isov, yo ubood zi ila rau tsio wa. Ve naghe matag suuru paam, uwatoa ila yaa paatu tsio, ve ughuru igheen. Leso matam iŋgalŋgal ŋgar ma pataŋani tau ivotvot payau ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Maaron, yau nawatagh: Yo uvolvool tsiau. Tauvene saawe tau ighe nataŋ rarai ghom pa uleeŋ, yo pale uul ghau, ve ugham koiagŋa titoor zi, ve tighau muul tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","11","Tauvene yau napakur Maaron pa saveeŋ mbuaaŋ tooni, ve naghur ila tooni ariaaŋ. Irau naroi mako. Pasaa, tamtamon to taan tapirizi igheen sindei, leso tivaghamun ghau? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Maaron, yau naghe nagham watooŋrau payo itaghon saveeŋ mbuaaŋ tsiau. Pasaa, yo uul ghau ve ugham lolog poia kat. Tauvene yau aat nagham watooŋrau, ve napait ghom pa poia tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Pasaa, yo ugham mulin ghau pa mateegh, ve uul ghau le naliiv koiagŋa. Tauta yes irau tigham ghau natap mako. Yo ugham tauvene, leso naghilaal naghe yo uleep tomani ghau pa lepoogh ve laghooŋ tsiau, ve ghazooŋa tsio isul ghau ve naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau David ighau pa Saul, ve iyooŋ ila maet puura. Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Mbouŋ tane aliiŋa, ene: ‘Ureua sov.’ O Maaron, yau besooŋa tsio. Lolom isaghatin ghau ve uul ghau lak! Yau naŋarui ghom naghe nayooŋ ilat tsio. Upoon ghau imin tatareek ipagud natŋa ila baage saamba, le irau pataŋani tane isov. Pa aazne, lepoogh tsiau, ene imin naleep ila uman ma yaghur tiina loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Yau nataŋ rarai Maaron Tiina Tau Iliiv Zimaronŋa Tisov na, naghe iuul ghau. Pasaa, ŋgar tooni ighurghur anooŋa. Saa ŋgar tau i ighe ivot payau, ene aat ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","I pale ileep izi sambam, ve igham uleeŋ payau, ve igham mulin ghau. Pale iyooz payau, ve itatan koiagŋa tau tinanaan ghau ne. Pasaa, i loolo isaghav tamtamon tooni ve iuluul zi, ve saawe isov itataghon saveeŋ mbuaaŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Koiagŋa tilivutin ghau wa. Yes timin laion tau luazi isaghat pa ghaniiŋ tamtamon. Livozi maata kat imin paneegh natŋa ve iiz. Ve yamazi paam, maata kat imin mbuzaagh to malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Maaron, ugham ilaal eta ivot ila sambam saamba. Leso tamtamon tighita ve tighilaal ghom tighe yo ezam tiina kat. Ve utotoi tapirim ve poia tsio le irau taan isov paam! ");
INSERT INTO tuc_t_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Pataŋani tane itatan ghau kat. Pasaa, koiagŋa tiraar puugh payau tighe tisaghav ghau. Ve titai puura ila eez tsiau, leso natap nazila. Eemon mako. Tauzi titap tizila. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Maaron, lolog ruru payo mako. Lolog isaghav ghom ariaaŋ. Tauvene yau aat nambou ve narav gita to napakur ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Lolog ighur naghe nughitun, o naburig, ve nagharaat taug, ve narav ambam tsiau ve gita ila ila le aaz pisikia izaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Tiina tsiau, yau aat napait ghom pa poia tsio ila tamtamon to nugh nugh matazi. Pale yeŋa tamtamon to nughmariŋ nilup ghei pa suŋuuŋ, ve nait mbouŋ to napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","O Yoova, yo lolom isaghav tamtamon tsio, ve uluul zi. Ŋgar tsio tana, ene tiina le tiina kat. Izala izala le ikis sambam. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tsio tauvene paam. Izala le ikis taitai. ");
INSERT INTO tuc_t_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Maaron, ugham gabua eta ivot ila sambam saamba imin ilaal pa tamtamon. Leso tighita, ve tipait ezam izala le izala kat. Ve utotoi tapirim ve poia tsio irau taan isov! ");
INSERT INTO tuc_t_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Mbouŋ to David Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Mbouŋ tane aliiŋa, ene: ‘Ureua sov.’ Yam daaba, alooŋ. Ŋgar tau yam asasavia na, ene iduduuŋ? Ve isaav ighe agabiiz saveeŋ to tamtamon ve aghur atuya pazi, yam ataghon ŋgar duduuŋa? Mako kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Lolomim ariaaŋ pa ŋgar saghati mon, ve avavaghamunia tamtamon irau nugh nugh. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Zeran sasaghati, saawe isov, tisosor pa eez poia. Saawe tau tinazŋa tipoop zi ve ilam, avozi karom, ve tisosor pa Maaron eez tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","5","Saveeŋ tau ivotvot ila avozi na, ene ivavaghamunia tamtamon imin moot saghati. Ve isaav ighe tatoova to tapaduduuŋ zi, ene irau tilooŋ ghiit mako. Pasaa, tipoon taliŋazi. Yes timin moot to malmal tau taliŋazi puura mako. Tauvene isaav ighe moot tawe taama iviv pirai, leso ighamu loolo poia ve imogheer, i irau ilooŋ pirai luutu mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Maaron, zeran tawe timin laion paghpaaghu tau matazi ghamuuŋ malmal. Arav polpolin livozi, ve apas zi! Leso tivaghamun tamtamon sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Upasov zi gha tilalez, imin yaa tau ireer ila le imaak. Uvaghaaz zi ila aghem saamba imin tamtamon tivaghaaz kikiliiŋ le igorgor. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Ugham zi timin golgool tau timaat ve timbuuz. Naghe timin geegeu tau tinazŋa tipoop zi ve timin siŋ mon. Irau tileep ve tighita aaz mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Maaron pale rekia mon iŋgoor saawe toozi tuuku, imin gabua gorgori tau yav ighani rekia. Aatyavyav tooni pale izaa toozi, ve ipasov zi gha tilalez, imin pen tau yaghur ivuvuura ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Isaav ighe tamtamon duduŋazi tighita Maaron ighur atuya pa zeran sasaghati ve iyat ŋgar toozi, ene pale lolozi poia. Zeran sasaghati siŋ toozi pale ireer izi ve ipot izala taan paavo, ve tamtamon duduŋazi tilaagh ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Mako tamtamon tisaav tighe: “Onoon kat, Maaron ilepleep, ve igagabiiz tamtamon to taan, ve ighurghur atuya pazi. Ve yes tau titaghon ŋgar duduuŋa na, i ighamgham lezi atuya popoia.” ");
INSERT INTO tuc_t_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau kinik Saul imbaaŋ uraata tooni siriv tila ruum to David, to tipadeu pani ve tiravu imaat. Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Mbouŋ tane aliiŋa, ene: ‘Ureua sov.’ Maaron tsiau, uul ghau ve upas ghau ila koiagŋa nimazi. Ughur ghau nazaa saaŋa, ve matam payau. Leso koiagŋa tivaghamun ghau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Ugham mulin ghau, ve upas ghau ila zeran sasaghati tane nimazi. Pa yes zeran to liŋiiŋ siŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","4","Maaron, ughita! Yes tau tapirizi tiina na, tilup zi ve tigham lilin ghau tighe tirav ghau namaat. Yes lolozi isaghatin tamtamon mako. Ve yau leg sosor eta mako. Nazoor saveeŋ eta mako, ve nagham ŋgar saghati eta mako. Eemon aazne, tigharaat tauzi tighe tigham malmal payau. Maaron, uburig uvool tsiau, ve ughit zi! ");
INSERT INTO tuc_t_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Yo mon ta Maaron to Israel. Yes nugh nugh tau aazne tighur koi payau ne, muuŋ lupuuŋ tsiei eemon. Ve aazne tighur koi payau. Uburig ve ughur atuya pazi. Ughurghur zi sov! Pa yes zeran sasaghatizi, ve avozi karom. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ravrav ta naol ne, koiagŋa tilamlam, ve tilaghlaagh ila nugh loolo. Tiŋaaŋ maripazi ve lolozi ŋurŋuria imin ŋgavuun tau ighe ighan tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Ughita. Saveeŋ sasaghati mon ta ivotvot ila avozi. Yamazi, ene imin mbuzaagh maata. Ve tisavsaav tighe: “Sei pale ilooŋ ghei?” ");
INSERT INTO tuc_t_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Eemon Yoova, yo ughit zi, ve uŋiŋ pazi. Yes nugh nugh tau tiwatagh ghom mako na, yo uvelegh zi ve ughe tirau saa? ");
INSERT INTO tuc_t_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Maaron, yau naghamgham tapirig ilat tsio. Tauvene naghurghur matag payo, ve nasasaŋan mon. Koiagŋa irau tigham gabua eta payau mako. Pasaa, yo uponpoon ghau pazi imin maetaaz tau izala kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Maaron tsiau, yo lolom isaghav tamtamon tsio ve uluul zi. Yo aat ulam tomani ghau, ve utatan koiagŋa, ve naghita pa taug matag. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Eemon urav zi timaat rekia sov. Upul zi tileep toman pataŋani. Leso tamtamon tsiau matazi kisin ŋgar tsio tau ughurghur atuya pa zeran sasaghatizi. Maaron, yo umin sigheu payei. Utatan zi pa tapirim le tivaghamgham, ve ureu zi le timbiriis tilalez lez. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Pa saveeŋ tau ivotvot ila avozi na, poia mako. Monmon avozi isosor. Yes tighamgham karom pa tamtamon, ve tisiksik saveeŋ sasaghati naol pazi. Eemon ŋgar toozi tau tipapait tauzi ve tivelegh ghom, ene pale imin liis pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Tauvene utotoi aatyavyav tsio pazi, ve uvaghamun zi. Maaron, upasov zi le tisov kat. Leso tamtamon irau taan ziige ta naol ne, tighilaal ghom tighe yo ughamgham pooz pa yei tau Yakop paaghu tooni ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Ravrav ta naol ne, koiagŋa tilamlam, ve tilaghlaagh ila nugh loolo. Tiŋaaŋ maripazi, ve lolozi ŋurŋuria imin ŋgavuun tau ighe ighan tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Yes timin ŋgavuun tau tilaghlaagh ve tiliil aniiŋ. Ve isaav ighe tighan irao mako, ene aat tinoknok taŋiiz. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Eemon yau aat nambou, ve napait ezam pa tapirim tiina. Mboŋoozo ta naol ne, yau aat nambou ve napait ghom pa ŋgar tsio tau lolom isaghav tamtamon tsio ve uluul zi. Pasaa, yo uponpoon ghau imin maetaaz tau izala kat. Isaav ighe pataŋani ivot payau, yo pale umin didiiŋ ariaaŋa payau, leso nayooŋ ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Maaron, yau naghamgham tapirig ilat tsio. Tauvene nambou ve napait ezam. Maaron tsiau, yo uponpoon ghau imin maetaaz tau izala kat. Ve yo lolom isaghav ghau, ve uluul ghau irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Mbouŋ to David Timbou mbouŋ tane to tipaduduuŋ tamtamon. Mbouŋ tane iŋarui saawe tau David yesŋa yes Aramea, ve Mesopotamia, ve yes Soba tigham malmal, ve Yoab imuul ila ve irav yes Edoma 12,000 izi nugh duduuŋa tau sol igheen ila. Maaron, yo atem yavyav payei, ve ughur murim payei. Tauta koiamaiŋa tireu mbirisai didiiŋ ariaaŋa tau ilivut nugh tsiei ne, ve tiloŋ tilam. Tiina tsiei, matam imuul ilam payei, ve ugham lepoogh tsiei poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Malmal tau ivot ne, ene imin ugham taan tsiei irur le ivavaal, ve aavo ikaak. Nugh tsiei isaghat wa. Tauvene nitaŋ rarai ghom nighe ugharaat mulin nugh tsiei. Mako pale nisaghat le nisaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Yei tamtamon tsio. Eemon yo ugham pataŋani tiina kat ivot payei. Nighita saawe tane saghati kat. Aatyavyav tsio izaa tsiei, le igham ghei nivaghamgham imin upaghun ghei pa yaa ariaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Saawe tau saghatiiŋ tane ighe ivot payei, yo utotoi pilak tsio pa yei tau niroi payo ve nitaghon ŋgar tsio. Leso niŋarui ghom nilat, ve upoon ghei pa koiamaiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Maaron, yei niwatagh: Yo lolom igheen tsiei kat. Ulooŋ suŋuuŋ tsiei tane, ve utotoi tapirim ve uul ghei. Ugham mulin ghei pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Muuŋ, Maaron ileep nugh tooni patabuyaaŋ, ve isaav ighe: “Yau naparav le naliiv koiagŋa wa. Tauta tintinig ve navalagh taan Sekem ve nugh duduuŋa to Sukot, ve nareii irau tamtamon tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Taan sirivu to Gileat, ve taan to yes Manase paam, ene yau tsiau. Rumei to yes Epraima timin hat ariaaŋa to napoon dabag pa malmal. Ve rumei to yes Yuda timin titi tau nakisi imin ilaal pa pooz tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Taan sirivu to yes Moapa, ene imin oon tsiau to ririwaaŋ. Ve taan sirivu to yes Edoma, ene nugh tau nasik zuzuuŋa to agheg izala. Ve yes Pilistia, yau naparav tomani zi le naliiv zi. Tauta tintinig ve nasir.” ");
INSERT INTO tuc_t_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Sei irau igham ghau naliiv koiagŋa ve naloŋ nala nugh toozi tau didiiŋ ariaaŋa ilivuti na? Sei pale imuuŋ payau, ve igherev ghau nala navot taan sirivu to yes Edoma? Ite paam mako. Yo mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Eemon Maaron, aazne yo ughur murim payei, ve upaak zaaba tsiei muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Maaron, uul ghei, leso niliiv koiamaiŋa. Pa uleeŋ tau nighamghamu ila to tamtamon, ene irao mako. Ene kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Eemon isaav ighe Maaron ilam tomani ghei, ene aat niliiv zi. I irau itatan zi le tapirizi isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Mbouŋ to David Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane O Maaron, ulooŋ taŋiiz tsiau. Ughur taliŋam pa suŋuuŋ tsiau tane, ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Pa aazne, yau naleep malau kat pa nugh tsiau, ve roiŋ tiina igham ghau le tapirig isov. Tauvene napoi ghom naghe uul ghau. Ugham ghau nazala maetaaz ta saaŋa we. Leso gabua eta ivaghamun ghau sov, ve naleep poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Pa yo ta umin niag to yoŋgaaŋ. Yo uponpoon ghau pa koiagŋa imin ruum ariaaŋa tau daaba malaua na. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Yau naŋuzuuv naghe le naleep ila balbaal tsio loolo, ve namin loom payo irau saawe. Yau naghe nalat tsio ve upoon ghau imin tatareek ipagud natŋa ila baage saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Maaron, saveeŋ tau nambua tomani ghom na, yo ulooŋa wa. Yes tau tiroi payo ve titaghon ŋgar tsio na, yo ughamgham gabua popoia pazi imin lezi motot. Gabua tawe, yo ugham payau paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","O Maaron, useeŋ saawe to kinik tsiei. Nighe i ileep tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Nighe i ileep ila niia to ghamuuŋ pooz ila naghom, ve igham pooz irau saawe. Yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Ve saawe isov, utataghon saveeŋ mbuaaŋ tsio. Tauvene matam pa kinik tsiei, ve uŋgini ileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Isaav ighe yo ugham tauvene, yau aat nambou to napait ezam irau saawe. Ve mataaz ta naol ne, yau pale nagham uratoi saveeŋ tau nambua tomani ghom na, leso anooŋa ivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Mbouŋ to David Timbou mbouŋ tane itaghon ŋgar to Yedutun, i ŋeer tau imuŋmuuŋ pa mbouŋ Yau lolog bubu mako. Ateg izi, ve nasaŋan Maaron to iuul ghau. Pasaa, yau nawatagh: I mon ta irau igham mulin ghau pa pataŋani tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Onoon kat, i mon ta Uleeŋa tsiau ariaaŋa. I iponpoon ghau imin maetaaz tau izala kat, ve imin ruum ariaaŋa to nayooŋ ila loolo. Tauvene gabua eta irau ivaghamun ghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Yam tau aghe avaghamun ghau ne, ŋeez o apul ŋgar tsiam saghati tana? Yam asov azuari gham pa ravuuŋ ghau pasaa? Aghita. Tapirig isov wa. Yau namin olol muŋgaana tau puughu imbuuz ve ighe imatit. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Yau leg ezag. Tauta ireu lolomim ve azuari gham aghe atatan ghau nazi. Yam zeran to karom kat! Agham karom, o lolomim poia. Yam asavsaav ila avomim uuli aghe Maaron ighur poia tooni izaa tsiau. Ve lolomim, aghe Maaron ivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Eemon yau lolog bubu mako. Ateg izi ve nasaŋan Maaron to iuul ghau. Yau naghurghur matag pani mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Onoon kat, i mon ta Uleeŋa tsiau. I iponpoon ghau pa koiagŋa imin maetaaz tau izala kat, ve imin ruum ariaaŋa to nayooŋ ila loolo. Tauvene gabua eta irau igham ghau narur ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Yau nanumeer Maaron naghe i pale igham mulin ghau pa pataŋani tsiau, ve igham ezag ivot imin tiina. Irau naroi mako. Pasaa, i ta imin niag to yoŋgaaŋ, ve iponpoon ghau imin maetaaz ariaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Yam tamtamon to Maaron, anumeera irau saawe. Avotia lolomim pani, ve asavia pataŋani tsiam isov ila tooni. Pa i ta imin niaan to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Tamtamon tisov timin kaut sorok. Yes tau lezi ezazi mako, ve yes tau ezazi tintiina na paam. Tileep rigmon ve tisov, imin avuvuun tau ivotvot ila avoon ne. Irau tanumeer zi mako. Isaav ighe tagabiiz zi poi, ene tirau gabua eta mako. Pasaa, tomania uraat ve gabua toozi rekia mon tilalez imin avuvuun tau ivotvot ila avoon ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Tauvene ŋgar to ghamuuŋ malmal leso tayau leen gabua to tamtamon, anumeera sov. Ve ŋgar to umbuuŋ paam, aghur matamim pani to igham gham aleep poia na sov. Ve isaav ighe maet ma kuaz tsiam ivot imin naol, na aghur lolomim pani sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Saawe naol, yau nalooŋ Maaron isaav ighe i mon ta le tapiri tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Tiina tsiei, yo lolom isaghav tamtamon tsio ve uluul zi irau saawe. Ve yo ughurghur atuya pa tamtamon tisov itaghon ŋgar toz toz. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Mbouŋ to David Mbouŋ tane iŋarui saawe tau David ileep izi nugh ŋginaaŋa to Yudea O Maaron, yo Maaron tsiau. Mboŋoozo geeg, suŋuuŋ tsiau iŋarui ghom naghe ulam uleep zigege. Yau napasawal naghe le nalat nagharau ghom, o poi. Pasaa, aazne naleep soghan payo. Yau lolog payo kat, imin ŋeer tau ilaghlaagh ila nugh tau le yaa mako na, ve murun matini. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Pasaa, matag iŋgal imuul ila pa saawe tau naghit ghom ila rumei tsio patabuyaaŋ loolo, ve naghit katin tapirim tomania mbonarim. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Lepoghag to taan, ene poia. Eemon naghita naghe ŋgar to lolom isaghav tamtamon tsio ve uluul zi, ene gabua tau poia le poia kat. Tauvene yau aat nayoor ezam ve napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Pale napait ezam pa poia tsio ila ila le lepoogh tsiau to taan isov. Pale nait nimag izaa, ve nasuŋ payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Pasaa, yo ugham lolog poia kat, imin naleep ila ghanghaniiŋ, ve naghan aniiŋ tau poia ve ŋgoreeŋa kat le isooŋ ghau kat. Tauta lolog poia kat, ve nambou mbouŋ to napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Saawe tau nazi nagheen, matag iŋgalŋgal ghom. Naghamgham ŋgar payo mboŋ ila le nughizau. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Pasaa, yo ta Uleeŋa tsiau. Yau naleep poi ila nimam saamba imin tatareek natŋa tiyooŋ ila baage saamba. Tauta namboumbou toman tintinig. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Yau lolog isaghav ghom kat, ve nimam tapir ipapalot ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Yes tau tizuari zi pa ravuuŋ ghau namaat na, tauzi pale timaat ve tizila nugh to mateegha. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Pale mbuzaagh ighan zi gha timatmaat, ve ŋgavuun sagsagŋa tighan patazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Eemon kinik tsiei, Maaron pale iuule ve ighamu loolo poia kat. Ve tamtamon tisov tau tiwaat Maaron eeza to tipariaaŋ saveeŋ mbuaaŋ toozi ve titaghoni na, yes paam pale tipait Maaron eeza pa tapiri ve poia tooni. Eemon yes tau avozi karom na, Maaron pale ipoon avozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Mbouŋ to David O Maaron, yau nataŋ rarai ghom naghe uul ghau. Ulooŋ aliŋag tane, ve upoon ghau pa koiagŋa. Pasaa, yes tigham ghau naroi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Zeran sasaghati tilup zi ve tiliil eez to tivaghamun ghau. Upaghau ghau pazi: Mako pale tivaghamun ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Saveeŋ tau tisiksiki payau ne, poia mako. Yamazi, ene imin mbuzaagh tau tipoti le maata kat. Saveeŋ tau tiŋgalŋgali payau ne, ene imin paneegh natŋa tau tikum gabua lilia ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Yes tiyoŋyooŋ, ve tisasaŋan yes tau lezi sosor mako na. Ve saawe tau tilam peria, mako rekia ve tivanegh zi. Pasaa, yes tiroi pa gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Yes tipapazaagh tauzi pa ghamuuŋ ŋgar sasaghati. Ve tivasavo zi pa nugh sindei tau pale tiŋgooz liis toozi pani ve tisaghav tamtamon. Ve tighe: “Ŋgar tau taghe taghamu ne, sei pale iwataghi?” ");
INSERT INTO tuc_t_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Yes tiil eez pa ŋgar saghati tau tighe tighamu, ve tipait tauzi tighe: “Yei nirau kat pa ŋgar! Tauvene ŋgar to nighe nighamu, ene pale ighur.” Oyai, iit tamtamon, taŋgooz ŋgar sasaghati naol ila loloon! ");
INSERT INTO tuc_t_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Eemon Maaron pale ivanegh zi pa paneegh tooni natŋa. Pale rekia mon ve ivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Saveeŋ sasaghati tau ivotvot ila avozi, ene pale imuul pa tauzi ve ivaghamun zi. Ŋgar tau Maaron pale igham pazi na, pale tamtamon tighita, ve tililiit dabazi pazi ve tivelegh zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ŋgar tau Maaron igham pazi na, ene pale igham tamtamon tisov tiroi, ve tigham ŋgar tiina pani, ve tisavia vaaru. ");
INSERT INTO tuc_t_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Tauvene zeran duduŋazi pale lolozi poia pa Yoova, ve tiyooŋ ila tooni. Yes tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na, pale tipaiti toman tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Mbouŋ to David Maaron, yei pale nilat nugh Zion ve nipait ghom, ve nigham uratoi saveeŋ tau nimbua tomani ghom. Ŋgar tauvene, ene iduduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Pasaa, yo uloŋlooŋ suŋuuŋ to tamtamon ve uluul zi. Tamtamon tisov to taan aat tilat tilup zi ila naghom, ve tipait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Ighe ŋgar to zoraaŋ saveeŋ ve ŋgar sasaghati ikau ghei ve itatan ghei kat, yo ureu sosor tsiei. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Yes tau yo usiigh zi timin lem, ve ugham zi tilat tileep tigharau ghom ila sirsiir to rumei tsio loolo, ene pale lolozi poia kat ve poia tsio izazaa toozi. Yei nighe le nileep ila sirsiir to rumei tsio patabuyaaŋ loolo. Pasaa, rumei tsio, ene ivon pa gabua popoia naol. Tauvene saawe tau nileep sewe, ene igham ghei lolomai poia le poia kat, ve niyamaan nighe nirao wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","O Maaron, yo Uleeŋa tsiei. Yo uloŋlooŋ suŋuuŋ tsiei, ve ughamgham uraat ŋgeretazi tintiina. Tamtamon tighit zi le tiroi. Ugham mulin ghei itaghon ŋgar tsio duduuŋa. Tamtamon tau tileep irau taan tiina ve yes tau tileep irau sisi paam, tisov tinumeer ghom ve tighurghur matazi payo pa uleeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Tapirim ilivut ghom imin nonoghiiŋa tsio. Ila yo tapirim, ugham loloz tisov tivot, ve tiyooz tuŋia ila niazi niazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Isaav ighe te isaghat, ve dibom ipolpol toman luutu tiina, yo irau ughamu aate izi. Ve tamtamon tauvene paam. Isaav ighe tipaburigin malmal toman oroor tiina, yo irau upasov malmal toozi, ve ugham zi atezi izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Tamtamon tau tileep irau taan ziige ta naol ne, tighita gabua ŋgeretazi tintiina tau yo ughamgham zi na, le roiŋ tiina igham zi. Yes tau tileep ila pa aaz izaa, ve yes tau tileep ila pa aaz izila na paam, yo ugham zi lolozi poia kat. Tauvene tiyoor ezam toman aliŋazi tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Yo ta uŋgin taan, ve ugham uman izizi, leso taan ibees. Ve yo ta ugham taan ŋgoreeŋa tiina ivotvot. Yaa to Maaron, ene ivon ve irereer tauvene. Irau imaak mako. Yo ugharaat taan itaghon taum ŋgar tsio. Leso aniiŋ katini ivot pa tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Yo ugham uman izizi, leso ser ibees, ve aniiŋ anooŋa katini ivotvot. Yo ututur taan le ibees kat. Ve poia tsio, tauta igham aniiŋ itum poi izaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Yo poiam kat. Pasaa, ndaman tane, ugham mariri tiina ivot payei. Aniiŋ tau itum ila uum tsiei, ene ipaboode imin moghar ndamoonda to yes kinik. Nugh sindei tau ighe yo ula pani, ene gabua popoia katini tivotvot. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Yo ugham kikiliiŋ popoia titum ila nugh ŋginaaŋa, leso ŋgai maata maata tighan. Ve uum popoia tau tigheen izala loloz na, ene upabood zi le paghunazi kat. Tauta loloz ta naol ne lolozi poia ve tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Nugh tau kikiliiŋ igheen ila na, makau ve sipsip tivon ila. Ve aniiŋ katini titumtum ila nugh raapa. Tauvene tamtamon lolozi poia, ve timbou ve tiyoor ezam toman aliŋazi tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Yam tau aleep irau taan isov na, lolomim poia pa Maaron, ve ayoor eeza toman aliŋamim tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Ambou ve apait eeza pa tapiri ve poia tooni. Apakuru kat, pa i eeza tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Asaav pa Maaron aghe: “Uraat tintiina tau yo ughamgham zi na, tamtamon tighit zi le tiroi. Pasaa, tapirim tiina le tiina kat. Tauta koiamŋa tiroi payo kat, ve tiput aghezi ila naghom, ve titaŋ rarai ghom tighe lolom isaghatin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Ve yes mon mako. Tamtamon tau tileep irau taan isov, pale tiput aghezi payo, ve timbou ve tipakur ghom. Lolozi poia kat ve timbou to tipait ezam.” ");
INSERT INTO tuc_t_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Alam aghita uraat tau Maaron ighamu na. I igham uraat tintiina to iuul tamtamon. Uraat tawe itotoi katin tapiri. Tauta tamtamon tighita, le roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Muuŋ, i ivalagh te le sirivu ila pa ŋas, sirivu ila pa tapir, ve taan mamaasa ivot. Tauta timbuunŋa tilaagh taghoni, ve tila tivool pa ziige ite. Tauvene iit loloon poia ve tintiniin pa ŋgar tau i igham pazi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","I tapiri tiina kat. Pale igham pooz taghon taghon gha ila. Saawe isov, i maata pa tamtamon to nughmariŋ, ve igagabiiz zi. Tauvene yam to zoraaŋ saveeŋ, azoor pooz tooni muul sov. Aleep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Yam nugh nugh, apait Maaron tsiei pa poia tooni. Apakuru toman aliŋamim tiina, leso tamtamon tilooŋ paitooŋ tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Pa i ta ikiskis ghiit taleep mataan yaryaare. Ve i iŋginŋgin ghiit, tauta tatap mako, ve tayooz tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Onoon kat, Maaron yo utoov ghei pa pataŋani siriv to ugham ghei niŋgalaaŋ ila yo matam, imin silva tau tighuru ila yav, leso yav ighani gha muun ighau, ve iŋgalaaŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Yo ugham ghei nighoon ila puugh tsio, ve ughur pataŋani tiina kat izaa tsiei. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Yo upul koiamaiŋa tiliiv ghei, ve karis toozi to malmal tilaan izala pavomai. Pataŋani tsiei, ene imin nilaagh ila yav tau ighanghan na loolo, ve nilaagh ila yaa tau ivon le tapiri tiina. Eemon yo upas ghei nivot pa pataŋani tsiei, ve ugham ghei nileep poia, ve nirau kat pa gabua naol. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Saawe tau naleep ila pataŋani loolo, yau nasaav payo naghe: “Isaav ighe yo uul ghau, yau aat nagham watooŋrau payo.” Tauta aazne, nataghon saveeŋ mbuaaŋ tsiau tana, ve nalam rumei tsio naghe naghur watooŋrau tsiau izala artaal, leso yav ighan dodolini. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Yau aat nagham gabua tumbuŋazi, ve narav zi timin watooŋrau payo, ve yav ighan zi le tisov. Yav pale ighan sipsip tsiau zitamoot, ve vazizi poia izalat payo. Ve tane mon mako. Pale nagham watooŋrau pa makau ve mekmek paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Yam tau aroi pa Maaron ve ataghon ŋgar tooni na, asov alam ve alooŋ saveeŋ tsiau tane. Yau naghe navotia uraat tiina tau i igham payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Yau nataŋ raraini pa uleeŋ, ve avog ipaiti paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Saawe tana, imin ta nakis ŋgar saghati eta igheen ila lolog, kanaŋ Ŋeer Tiina irau ilooŋ suŋuuŋ tsiau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Eemon i ighur taliiŋa payau, ve ilooŋ suŋuuŋ tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Tauta napait Maaron pa poia tooni. Pasaa, i imbuzir pa suŋuuŋ tsiau mako, ve ipas poia tooni payau mako. Ŋgar tooni tau loolo isaghav tamtamon tooni ve iuluul zi, tauta itotoia payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane. Timbou mbouŋ tane to tapakur Maaron Maaron igham poghani ghiit ve ighur poia tooni izaa toit. I pale loolo poia pait, ve ghazooŋa tooni isul ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Leso tamtamon tau tileep irau taan na tiwatagh ŋgar tooni, ve nughmariŋ tighilaalo tighe i mon ta irau igham mulin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Maaron, nighe tamtamon to nugh nugh tipakur ghom. Nughmariŋ tipait ezam, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Nighe tamtamon to nugh nugh lolozi poia ve timbou toman tintinizi to tipakur ghom. Pasaa, yo ugagabiiz tamtamon, ve ughagharaat pataŋani toozi itaghon ŋgar duduuŋa. Ve yo ta ughamgham pooz pa nughmariŋ tau tileep irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Maaron, nighe tamtamon to nugh nugh tipakur ghom. Nughmariŋ tipait ezam, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Mariri poia ivot ila taan toit wa. Poia to Maaron toit pale igheen tomani ghiit tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Onoon kat, Maaron ighur poia tooni izaa toit. Leso tamtamon tau tileep irau taan ziige ta naol ne tiroi pani, ve titaghon ŋgar tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Mbouŋ to David Maaron aat iburig ve ireu mbirisai koiŋa. Yes tau tighur koi pani, i pale iziir zi tighau pa naagho. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","I aat ipasov zi le tisov kat, imin yav mbuasa tau izaa, ve yaghur ivuvuura gha ilale. Isaav ighe zeran sasaghati tileep ila Maaron naagho, i pale ivaghamun zi gha tilalez, imin bagil tau igheen igharau yav ziige, ve yav ighamu ireer ila, le isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Eemon zeran duduŋazi, yes pale lolozi poia kat. Pale tileep ila Maaron naagho, ve tiyoor eeza toman tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Ambou pa Maaron. Ambou ve apait eeza, ve agharaat eez pani. I Ŋeer tau ileep ila taitai paavo, ve ilandoova. I eeza Yoova. Alup gham ila naagho, ve tintinmim pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Maaron ileep ila niia patabuyaaŋ, ve iŋginŋgin yes parooŋa imin tamazi. I ivolvool to yes zinaara ve iyozyooz pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Yes tau zigazi tileep, ene pale Maaron igham tamtamon siriv timin zetazŋa, leso yesŋa tilup zi ve tileep. Ve yes tau koiazŋa tizeev zi sorok tiloŋ tila ruum to yavyavuuŋ na, i ipaspas zi tivot, ve imuuŋ pazi, ve ighegherev zi tila, leso tigham lepoogh poia. Tauvene yes timbou toman tintinizi, ve titaghoni gha tila. Eemon yes tau tighamgham taliiŋzizi na, pale tileep saghat ila taan gorgori tau le yaa mako na. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","8","Maaron, saawe tau yo umuuŋ pa tamtamon tsio Israela, ve yamŋa alaagh izi nugh ŋginaaŋa na, yogyoog itok taan, ve uman tiina itap sambam saamba gha izi. Maaron to Israel, nugh tsio to ghamuuŋ pooz, ene loloz Sinai. Yo utotoi taum uvot ughazooŋ ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Maaron, taan tau yo ugham pa tamtamon tsio na, isaav ighe aaz tiina ve igorgor, na yo ughamgham uman tiina izizi to ipabees taan, leso gabua titum muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Tamtamon tsio tigham taan tane imin lezi nugh to lepoogh. Yei mbolaaŋa. Lemai gabua eta mako. Eemon Maaron, yo poia puughu. Tauta ugham taan tane payei, leso iuul ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Ŋeer Tiina ivotia malmal vaaru ighe i iliiv koiŋa wa. Tauvene zilivaa eval tilaan tila, ve tibobaini tighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Ou alooŋ! Yes kinik tomania zaaba toozi tila wa. Tisov tighawaar wa! Tauta zaaba toit tiyau gabua to koiaanŋa tilam, ve tigham pa zilivaa tau tileep nughei we, leso tivarei zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Zilivaa tsiei tipabood zi pa silva ma gol le paghunazi kat, imin mbunumoor tau tigharaata pa silva, ve tipaak gol milmilia ila baage. Puughu mindai ta yam siriv ala pa malmal mako, ve aleep sorok nughei tomania sipsip?” ");
INSERT INTO tuc_t_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Saawe tau Maaron saksaki ireu mbirisai yes kinik, i igham ais paatu paatu titaptap tizi ila loloz Zalmon. Tauta inaan zi gha tighawaar. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Loloz to nugh Basan, ene tiina ve daaba izala kat, ve le mbua ve sapsapu katini. Daaba izala kat, tauta i le eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Loloz to nugh Basan, yo lem mbua naol. Puughu mindai ta ughita Maaron igham loloz Zion imin niia to lepoogh, ve ireu lolom? Tauta lolom isaghat pani ne? Onoon kat, i pale ileep izi loloz tane taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Ŋeer Tiina ipul loloz Sinai, ve ilaagh tomania karis tooni ndiŋndiŋ ndiŋndiŋ to malmal, le tila tivot niia patabuyaaŋ ta Zion we. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Maaron, yo ugherev koiamŋa katini tau uliiv zi na, gha titaghon ghom ve yamŋa azala loloz tsio daaba ta saaŋa we. Tamtamon tigham lem gabua popoia maata maata. Yes tau tizorzoor aliŋam na paam, tiput aghezi payo, ve tigham lem gabua. Onoon kat, Maaron toit Yoova, monmon i ilepleep izi loloz tooni tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Tapait Ŋeer Tiina pa poia tooni! Saawe isov, i iuluul ghiit pa badooŋ pataŋani toit. Maaron toit, i Maaron tau ighamgham mulin ghiit pa pataŋani toit. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Maaron toit, i Maaron to uleeŋ. Onoon kat, Maaron toit Yoova, i ighamgham mulin ghiit. Tauta tamaat mako, ve taleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Maaron pale irav valaghin koiŋa dabazi. Yes tau titaghon eez saghati ve tighamgham sosor na, i pale irav mbirisai dabazi rubruuba, le tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Ŋeer Tiina isaav ighe: “Koiagŋa irau tighau mako. Isaav ighe tileep izi loloz to nugh Basan, ma tileep siiŋa kat izila mazavan, ene aat nagham zi tisov timuul tilam. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Siŋizi pale ireer izi, ve ipot ila taan paavo, leso awai ila. Ve ŋgavuun tsiam pale tighunu, le isooŋ zi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Maaron, yo kinik tsiau. Yo uliiv koiamŋa wa. Tauta aazne, ulam toman lolom poia, ve uloŋ ula rumei tsio patabuyaaŋ ila eval tiina matazi. Yo umuuŋ, ve tamtamon tsio titaghon ghom gha yamŋa aloŋ ala. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Yes to mbouŋ timuuŋ, ve zilivaa paghpaaghu tau titoktok kakaap na titaghon zi. Ve yes to ravuuŋ ambam, ve vivuuŋ mboi ve tavuur ma gabua siriv paam tilaagh murei. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Yam Israela tau avot ila to Yakop na, alup gham ila Maaron naagho ve apaiti pa poia tooni. Yam asov apait Yoova eeza! ");
INSERT INTO tuc_t_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Aghita. Rumei to Benyamin tau eval mako na, timuuŋ. Mako yes daaba to Yuda tomania tamtamon toozi titaghon zi. Ve yes daaba to Sebulun ve Naptali tilaagh murei. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Maaron, yo usaav ariaaŋ pataghaaŋ ughe yei Israela aat lemai tapirimai tiina ve niyooz ariaaŋ. Utotoi tapirim payei muul, imin muuŋ utotoia payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Yes kinik to taan pale tilam tivot Yerusalem, ve tigham lem gabua popoia iloŋ ila rumei tsio patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Yes Isipa tilepleep ila pizpiiz loolo ta yaa Nil ziige we imin poghai. Ve yes kinik to nugh siriv tilaghlaagh tomania zaaba toozi timin makau umbaal tau tiketkeet tomania natuzŋa. Uyaon koiamaiŋa tawe, leso tiput aghezi payo, ve tighur maet silva toozi imin lem to tipakur ghom. Nugh nugh tau lolozi pa ghamuuŋ malmal na, ureu mbirisai zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Kinik to yes Isipa pale imbaaŋ uraata tooni tilam Yerusalem, leso yeŋa nisavsaav pa lupuuŋ tsiei. Ve yes to Etiopia paam, pale rekia tiit nimazi izaa, ve tisuŋ pa Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Yam kinik to taan tomania tamtamon tsiam, ambou pa Maaron. Ambou mbouŋ pani ve apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","I Ŋeer tau ileep izala taitai paavo, ve ilandoova ila sambam saamba tau igheen muuŋ geeg ve ilam. Alooŋ. I isavsaav toman tapiri tiina. Aliiŋa luutu tiina imin lalaav. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Tauvene yam avotia Maaron tapiri. I kinik tiina tau ighamgham pooz pa iit Israela, ve itotoi tapiri ivotvot ila sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Maaron to iit Israela, i ilepleep iloŋ ila rumei tooni patabuyaaŋ ve itotoi tapiri. Tauvene tamtamon tighita ve tiroi. I ireirei tapiri pa tamtamon tooni ve ipapalot zi. Tapait Maaron pa poia tooni! ");
INSERT INTO tuc_t_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Mbouŋ to David Ŋeer tau imuŋmuuŋ pa mbouŋ na aat isaav pa tamtamon to timbou mbouŋ tane itaghon aliiŋa tauvene: ‘manman ruuŋgu pisosooŋa.’ O Maaron, uul ghau lak! Pa yaa ivon izalam imuul luag gha naghe nazal tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Aazne, agheg brusia ila tiiŋ tiina. Leg taan ariaaŋa eta to nayooz izala ne mako. Yau naleep izila mazavan loolo. Lepoogh tsiau ta aazne, ene imin yaa ivot toman tapiri, ve izugh ghau gha nalaleg. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Maaron, yau nasaghat wa. Taŋiiz tsiau iŋaŋarui ghom le aliŋag imarmaar. Yau naghurghur matag payo naghe yo pale uul ghau. Eemon mako. Tauta tapirig isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Tamtamon tau tighurghur koi payau ne, yes eval le eval kat. Tiliiv dabag raua. Irau nanin zi mako. Koiagŋa tau tighe tivaghamun ghau na, tapirizi tiina, ve tiŋgalŋgal saveeŋ karom naol payau. Yau naum gabua toozi eta mako. Eemon tisavsaav payau tighe napamuul gabua toozi. Pale napamuul saa? ");
INSERT INTO tuc_t_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Maaron, yo uwatagh: Yau nagham ŋgar sasaghati naol imin yes borauŋa. Sosor tsiau ta naol ne, eta iyooŋ payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Uul ghau lak! Mako pale nagham mayaŋa pa yes tau tinumeer ghom ve tighurghur matazi payo na. Maaron to Israel, yau nagham ŋgar tiina pa yes tau tizuari zi tighe le tiwatagh katin ghom. Isaav ighe yo uul ghau pa pataŋani tsiau tane mako, ene pale mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Yau nabesbees payo, tauta tamtamon tisiksik saveeŋ veleghiiŋ payau. Yes tigham ghau mayag ve natudtud mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Taug siŋ tsiau tighit ghau imin yau ŋeer suumbu. Ve toŋvetaz tsiau duduuŋ tau tinamai eemon na, tighur murizi payau imin yau to nugh ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Ŋgar tsiau iyaryaaŋ naghe le nagharaat rumei tsio. Eemon ŋgar tane, ta aazne imin puughu pa nabaad pataŋani tiina imin yav ighan ghau. Yes tau tivelegh ghom na, tivelegh ghau paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Saawe tau natatan taug, ve naŋgun taug pa ghaniiŋ aniiŋ, tamtamon matazi veleghin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ve saawe tau lolog ipataŋan, ve nagharaat taug mako, ve nanonogh ghau pa uuli to moŋiiŋ, tiŋiŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Yes tau tiluplup zi ila maaran aate na, tisisinai ghau. Ve yes ghunuuŋa timboumbou ghau imin ŋalalaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Eemon suŋuuŋ tsiau iŋaŋarui ghom mon. Yoova, poia tsio, ene tiina le tiina kat. Lolom isaghatin ghau ve uul ghau lak! Lolom isaghav tamtamon tsio, ve uluul zi irau saawe. Tauvene saawe sindei tau ughita poia, na ulooŋ suŋuuŋ tsiau tane, ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Upas ghau navot pa pataŋani tiina tane. Mako pale agheg brusia ila tiiŋ ve malmalig nazila! Ugham mulin ghau ila koiagŋa nimazi. Uit ghau nazaa pa mazavan loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Uul ghau. Mako pale yaa ivot toman tapiri ve izugh ghau, ve igherev ghau gha nalaleg! Ughita. Paita nazal nazila mazavan loolo tane. Aazne, yau naleep izila puura to yes mateegha, ve aavo ighe ivool tane. Upas ghau navot. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yoova, yo poiam. Lolom isaghav tamtamon tsio ve uluul zi irau saawe. Tauvene ulooŋ suŋuuŋ tsiau tane ve uul ghau. Yo lolom isaghatin ghei kat. Tauvene matam imuul ilam payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Yau besooŋa tsio. Uŋgooz naghom payau sov. Pa aazne naleep ila pataŋani tiina loolo. Tauvene ulooŋ suŋuuŋ tsiau, ve uul ghau rekia. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Ulam uyooz ila zigeg, ve uul ghau. Ugham mulin ghau ila koiagŋa nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Ŋgar tau koiagŋa tighamgham payau ne, yo uwataghi wa. Yes tivevelegh ghau, ve tipamayaŋin ghau, ve tivaghamunia ezag kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Saveeŋ veleghiiŋ tau tisiksiki payau, ene igham lolog ipataŋan kat. Naghita naghe irau poiag muul mako. Yau naghe pale tamtamon lolozi isaghatin ghau, ve tilam tirav ateg. Eemon mako. Eta ilam peria tsiau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Saawe tau pitool ghau, koiagŋa tighur gabua lilia ila aniiŋ tsiau. Ve saawe tau murun ghau, tigham leg vaen papaii. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Tauvene suŋuuŋ tsiau iŋarui ghom naghe: Saawe tau koiagŋa yesŋa zetazŋa tilup zi pa ghanghaniiŋ, na ugham boor tau aniiŋ toozi igheen izala na, imin liis pazi ve ivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ugham matazi ikumkuum, leso tighita nugh muul sov. Ve ugham tapirizi isov, ve aghezi imatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Naghe uŋgal matazi ve tiyamaan katin aatyavyav tsio. Aatyavyav tsio tana izaa toozi ve ivaghamun zi kat, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Upasov zi le nugh toozi balim. Balbaal toozi ta naol ne, tamtamon eta ileep ila muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Pasaa, tamtamon tau yo ulosi ve ughur pataŋani pani na, zeran sasaghati tawe tighur pataŋani izaa tooni muul, ve tisisinaii pa pataŋani tau ivot pani na. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Sosor to zeran tawe, lolom iveegh pani sov. Matam kisini, ve ughur atuya pazi le tiyamaana kat! Ughurghur zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Umus ezazi pa rau to lepoogh maata yaryaare. Rau tau zeran duduŋazi ezazi igheen ila na, yes tawe ezazi ila tomani zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","O Maaron, aazne nabaad pataŋani ve nayamaan yavyavuuŋ tiina. Tauvene ulam uul ghau. Uŋguaaz ghau nazala saaŋa. Leso naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Yau aat nambou ve napait Maaron eeza. Pasaa, i igham ghau lolog poia kat. Tauvene yau naghe napakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ŋgar tauvene, ene igham Yoova loolo poia kat le iliiv makau katini tau tighamgham zi pa watooŋrau na. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Yes tau tinumeer Maaron ve tibadbaad pataŋani na, isaav ighe tighita Maaron iuul ghau, ene pale tintinizi. Ve yes tau tizuzuari zi pa Maaron na paam. Ighe tighita uleeŋ tau i igham payau ne, ene pale ipalot zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Pasaa, yes tau tibadbaad pataŋani ve tinumeer Yoova na, i iloŋlooŋ suŋuuŋ toozi. Tamtamon tooni tau tileep ila koiazŋa nimazi na, i irau loolo iveegh pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Sambam saamba, taan, ve te, tomania gabua naol isov tau tilepaar ila na, yam asov apait Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Pa i pale igham mulin nugh Zion, ve ipaburigin nugh tisov to Yudea muul. Leso tamtamon tooni timuul tila ta sewe, ve tigham mulin taan toozi, ve tileep ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Ve murei, taan toozi pale izi pa paaghu toozi, ve tighamu imin lezi, ve tileep ila. Tauvene yes tau lolozi igheen to Maaron na, pale tileep poia izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Mbouŋ to David Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Saawe tau tamtamon tigham watooŋrau ve tighason Maaron to maata iŋgal zi, timbou mbouŋ tane O Maaron, upas ghau navot pa pataŋani tsiau tane. Yoova, ulam uul ghau rekia lak! ");
INSERT INTO tuc_t_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Yes tau tigham lilin ghau ne, ukau ŋgar toozi. Leso ŋgar toozi ivaghamgham, ve tighau tila toman mayazi. Ve yes tau tighita pataŋani tsiau tane ve lolozi poia pani na, yes paam, upamuul zi tila toman mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Zeran tawe tipaŋiŋizai ghau tighe: “Aa! Saghatiiŋ tau taghe ivot pani, tauta ivot wa!” Tauvene utatan zi, ve ugham zi mayazi ve tighau tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Eemon tamtamon tisov tau tizuzuari zi payo na, yes pale tintinizi ve lolozi poia payo. Yes tau lolozi pa uleeŋ tsio kat, ene pale monmon tisavsaav tighe: “Maaron, i eeza tiina le tiina kat!” ");
INSERT INTO tuc_t_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Yoova, pataŋani tane itatan ghau le tapirig isov kat. Narau gabua eta muul mako. Ve yo mon ta Uleeŋa tsiau. Yau naghur matag payo to upas ghau navot pa pataŋani tane. Tauvene uzuar sov. Rekia ulam uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yoova, yau nanumeer ghom ve nayooŋ ilat tsio. Upul koiagŋa titatan ghau sov. Pa ighe tiliiv ghau, ene pale mayag. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Yo utataghon ŋgar duduuŋa. Tauvene uul ghau ve upas ghau navot pa pataŋani tsiau tane. Ughur taliŋam payau ve uul ghau lak. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Yo Uleeŋa tsiau ariaaŋa. Uponpoon ghau pa koiagŋa imin maetaaz tau izala kat. Ve umin ruum ariaaŋa to nayooŋ ila loolo. Saawe isov, yau irau naŋarui ghom, leso gabua eta ivaghamun ghau sov, ve naleep poia. Aliŋam ilam pataghaaŋ wa ughe yo pale ugham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Maaron tsiau, ugham mulin ghau ila zeran sasaghati nimazi. Pa yes zeran to sosor, ve lolozi isaghatin tamtamon eta mako. Isaav ighe tikis ghau, ene pale tivaghamun ghau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Yoova, yau naghurghur matag payo to uul ghau. Tiina tsiau, saawe tau kukuag ve ilam, yau nanumeer ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Saawe tau naleep ila tinaŋ aapo ve ilam, yau naleep ila yo nimam. Tauvene saawe tau tinaŋ ipoop ghau, yo uŋgin ghau. Tauta monmon napapait ghom pa poia tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Eval tiina tigham ŋgar naol payau. Pasaa, tighita ŋgar tau ivotvot payau ne, le tighilaal katin ghom. Yo umin niag ariaaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Tauvene mboŋoozo ila le ravrav izi, lolog poia kat payo, ve avog ipapait ezam pa tapirim ve poia tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Aazne, namin kooŋ wa. Eemon ughit ghau namin gabua saghati tau tamtamon tisiki ilale na sov. Tapirig imbool wa. Ughur murim payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Pa koiagŋa tilup zi, ve tiliil eez pa ravuuŋ ghau namaat. Saawe tau tiyoŋyooŋ ve tisasaŋan pa ravuuŋ ghau, tisavsaav tighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","“Aa, Maaron ighur muuri pani wa! Tataghoni ve takisi. Pa i le tamtamon eta to iuule mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Maaron, uleep soghan payau sov! Maaron tsiau, rekia ulam uul ghau! ");
INSERT INTO tuc_t_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Koiagŋa tau tiŋgalŋgal saveeŋ payau na, ugham zi mayazi, ve urav zi le tisov. Yes tau tighe tivaghamun ghau na, utatan zi, ve ugham zi mayazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Eemon yau aat naghur matag payo irau saawe, ve nasaŋan ghom to uul ghau. Yau naghe napait ghom le napait ghom kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Avog pale ivovotia ŋgar tsio duduuŋa pa tamtamon. Mboŋoozo ila le ravrav izi, yau aat nasasavia uraat tintiina tau yo ughamgham zi pa uleeŋ tamtamon. Uraat tawe, isaav ighe natoova to nanin zi, ene aat narao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Yoova, yo utotoi tapirim ila uraat tintiina. Tauvene yau aat nala ve navotia uraat tsio tana pa tamtamon leso matazi iŋgali. Naghe nasavia ŋgar duduuŋa tau yo ughamghamu na. Lolog pa nasavia gabua ite paam mako. Naghe nasavia ŋgar tsio duduuŋa mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Saawe tau kukuag ve ilam aazne, yo upaghazoŋai ghau pa ŋgar tsio. Tauta navovotia uraat tsio ŋgeretazi pa tamtamon. Uraat tawe, maata ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O Maaron, aazne namin kooŋ, ve moom igham dabag wa. Eemon ughur murim payau sov! Uleep tomani ghau le irau navotia tapirim ve uraat tsio tintiina pa natmaiŋa, timbumaiŋa, ve iseeŋga taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Maaron, tapirim ve ŋgar tsio duduuŋa, ene tiina le tiina kat. Izala izala le ikis sambam. Ve uraat naol tau yo ughamgham zi na, tauvene paam. Ene tintiina kat. Sei irau ghom? Eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Onoon, yo upul pataŋani naol ivot ve ivaghamun ghau. Eemon yo pale ugham ghau naleep poia muul. Paita namaat gha nazila naal tane. Eemon yo pale ugham mulin ghau. Irau namaat mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ve yo pale upakur ghau, ve ugham ezag ivot imin tiina, ve urav ateg, leso lolog poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Tauvene yau aat narav gita ve napait ezam. Pasaa, yo utataghon saveeŋ mbuaaŋ tsio. Maaron tsiau, yo Maaron patabuyaaŋ to yes Israela. Yau aat narav gita tsiau, ve nambou mbouŋ to napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Pale avog iyoor ezam toman lolog poia kat, ve nambou to napait ghom. Pale napakur ghom toman lolog. Pasaa, yo ta ugham mulin ghau pa pataŋani tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Tauvene saawe isov, mboŋoozo ila le ravrav izi, yau aat nasavia ŋgar tsio duduuŋa. Pasaa, yes tau tighe tivaghamun ghau na, yo utatan zi le tapirizi isov, ve upamuul zi tila toman mayazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Mbouŋ to Solomon O Maaron, upaduduuŋ kinik tsiei, ve uule to itaghon ŋgar tsio duduuŋa. Leso iyooz pa tamtamon tsio, ve igharaat pataŋani toozi le iduduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ve igabiiz poghania tamtamon tsio, ve igharaat saveeŋ toozi itaghon ŋgar duduuŋa. Ve iyooz pa yes mbolaaŋa ve yes tau lezi ezazi mako na, ve iuul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Nighe lepoogh poia ivot irau loloz tisov to nugh tane. Ve nugh mbua mbua tighita anooŋa to ŋgar duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Ugham kinik tsiei iyooz pa yes tau lezi ezazi mako na, ve iparav pazi ariaaŋ. Ve yes tau mbolaaŋ igham zi na, i aat iuul zi. Eemon yes tau titatan tamtamon ve tighurghur pataŋani pazi na, i aat itatan zi le tapirizi isov kat, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Maaron, tamtamon tsio pale tiroi payo ve titaghon ŋgar tsio taghon taghon gha ila, imin aaz ve kaiyo tau tigheen irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Nighe kinik tsiei iuul tamtamon tileep poi, imin uman tau itap izi ila uum, ve ipabees taan, ve igham aniiŋ itum poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Saawe tau i iŋgin ghei, nighe ŋgar duduuŋa ve ŋgar luuma ivotvot imin tiina. Leso tamtamon tileep poi ila ila le saawe isov, ve taghita kaiyo muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Kinik tsiei aat iŋgin nugh tiina kat. Te ziige ee pale imin ŋgat pani, ve ila ivool pa te ziige ite. Ve yaa Euprates pale imin ŋgat pani, ve ila ila le irau taan ziige ta naol ne. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Yes tau tileep izi nugh ŋginaaŋa na, pale tilam ve tiput aghezi pani. Ve koiŋa pale titap tizi ila naagho ve tipel zi ila ŋgaupup. Pasaa, tirau gabua eta muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Ve yes kinik to Tarsis tomania yes kinik tau tileep irau sisi tisov na pale tilam ve tigham gabua popoia siriv pa kinik tsiei to tipakuru. Yes kinik tau tiŋgin taan sirivu to Arabia ve Etiopia paam, pale tilam ve tigham gabua popoia pani. Leso titotoi tighe yes pale tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Nighe kinik tisov tilam tiput aghezi pa kinik tsiei, ve tileep ila i saamba. Nughmariŋ tibees pani, o poia ");
INSERT INTO tuc_t_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Pasaa, saawe tau yes mbolaaŋa tipoii pa uleeŋ, i ilooŋ taŋiiz toozi. Ve yes tau tileep saghat ve lezi uleeŋa eta mako na, i iuluul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","I loolo isaghatin yes mbolaaŋa ve yes tau tapirizi imbool na, ve ighamgham mulin zi pa pataŋani toozi. Leso tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Isaav ighe tamtamon titatan zi ve tivaghamun zi, i iyozyooz pazi, ve ighamgham mulin zi ila koiazŋa tawe nimazi. Pasaa, i loolo pazi kat. Tauvene irau imarar zi ve siŋ toozi imaliŋ sorok ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Maaron, upalot kinik tsiei, leso ileep malau izi taan. Ve yes Arabia aat tigham le maet gol tau ŋgalaaŋa kat. Ve saawe isov, tamtamon aat tighur kinik tsiei ila suŋuuŋ toozi, ve tighason Maaron to ipaloti ve ighur poia tooni izaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Maaron, ugham aniiŋ katini ivot ila taan tsiei le irao uum tsiei ta loloz we. Ve wit anooŋa katini ivot ve ayazi kalkalia ilala ilamlam, imin yes Lebanon toozi. Ve tamtamon tauvene paam. Nugh tsiei tisov aat timasa timin naol, imin kikiliiŋ tau isaas le itav taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Kinik tsiei eeza pale ighengheen tauvene taghon taghon gha ila. Eeza tiina pale igheen irau saawe isov, imin aaz tau monmon ighazghaaz. Pasaa, i pale imin eez pa nughmariŋ, leso poia to Maaron izaa toozi. Nugh nugh pale tighita kinik tsiei ve tipaiti tighe poia to Maaron igheen tomani. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Tapait Yoova! I Maaron to iit Israela! I mon ta ighamgham uraat ŋgeretazi tintiina. Uraat tana, maata ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Tapait eeza pa tapiri ve poia tooni irau saawe! Tamtamon tau tileep irau taan na, pale tighilaalo tighe i eeza tiina pa tapiri ve poia tooni. Onoon le onoon kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Suŋuuŋ to Yesi naatu David, tauta ilam imuul ta sene. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Mbouŋ to Asap Onoon kat, Maaron ighamgham ŋgar poia pa yes Israela. Yes tau ŋgar ŋgalaaŋa igheen ariaaŋ ila lolozi na, i igham poghani zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Eemon yau, saawe ee agheg pusukia, ve rigmon kanaŋ natap. Onoon kat, saawe tana, rigmon kanaŋ napul ghuruuŋ ila tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Pasaa, naghita zeran sasaghati tau tipapait tauzi ve tivelegh Maaron na, lepoogh toozi poia kat. Tauvene nagham ŋgar pa gabua tane, le irau lolog mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Yes titum le tinizi poia kat. Lezi pataŋani mako, ve tileep poia mon ila le irau mateegh toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Pataŋani naol to taan tau ighamgham tamtamon siriv na, igham zi mako. Yes lezi pataŋani eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Ŋgar to pakuruuŋ tauzi, ene titotoia ivot ighazooŋ ila tamtamon matazi, imin namatabub tau tamtamon tighuru ila luazi. Ve ŋgar toozi to ghamuuŋ malmal, yes tipulpuli mako, imin nonoghiiŋa tau monmon tinonogh zi pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Lepoogh toozi, poia mon. Tauvene titum kat. Lolozi ivon pa ŋgar sasaghati naol, ve monmon tiliil eez to tivaghamun tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Monmon tivevelegh tamtamon, ve tisiksik saveeŋ sasaghati pazi. Ve tipapait tauzi ezazi, ve tiparoi tamtamon tighe yes pale titatan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yes tipakur tauzi, ve tisiksik saveeŋ veleghiiŋ pa Maaron to sambam. Ve zetazŋa tau tileep izi taan ne, zeran tawe matazi veleghin zi, ve tighe titatan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Yes tigherev tamtamon to Maaron paam, gha titaghon zi pa ŋgar toozi tawe. Eval tiina tighe le tiloŋlooŋ saveeŋ toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Zeran sasaghati tawe tisavsaav tighe: “Ah, Maaron tau ileep saaŋa kat na, i le ŋgar? Ŋgar tau nighamghamu ne, Maaron iwataghi mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Aghita. Zeran sasaghati, lepoogh toozi tauvene. Lezi pataŋani eta mako, ve tindoundou lezi gabua katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Muuŋ, yau nagham ŋgar tauvene pa lepoogh toozi. Tauta nasaav pa taug naghe: “Yau tane, nazuari ghau naghe le leg sosor eta sov, ve ŋgar ŋgalaaŋa mon igheen ila lolog. Eemon ŋgar tau nataghoni ne, anooŋa eta mako. Naghamghamu sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Pasaa saawe isov, ta mboŋoozo ila le ravrav izi, Maaron ighurghur pataŋani payau. Mboŋoozo ta naol ne, i iloslos ghau.” ");
INSERT INTO tuc_t_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Maaron, ŋgar tsiau saghati tane, imin ta nasavia ivot ighazooŋ gha tamtamon tilooŋa, kanaŋ nagham karom pa tamtamon tsio, ve nakau ŋgar toozi. Tauta igheen to taug mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Yau nagham ŋgar naol pa lepoogh poia to zeran sasaghati, ve nail puughu. Eemon narao mako. Tauta igham lolog ipataŋan kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Murei ra, naloŋ nala rumei patabuyaaŋ to Maaron ve nasuŋ. Saawe tana ra, naghilaal ve ŋgar tsiau ivot pa gabua tau murei pale ivot pa zeran sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Onoon kat, yo pale ugham zi tilaagh ila eez tau pusukpusukia. Leso ugham zi titap, ve saghatiiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Pale upasov zi rekia mon, ve ureu mbirisai zi gha tilalez. Ve mateegh toozi, pale toman roiŋ tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Maaron, isaav ighe yo uburig ve uvaghamun zi, ene pale upasov zi kat. Eta irau ileep muul mako. Pale timin gabua tau taghita ila vivuuŋ, ve mboŋoozo taburig loloon iveegh pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","22","Saawe tau nagham ŋgar pa zeran sasaghati, ene ireu lolog ve igham ghau ateg yavyav. Ve ŋgar tsiau ikaukau, ve navaghamgham. Yau namin ŋgai sagsag tau le ŋgar payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Eemon yo upul ghau mako. Monmon ulepleep tomani ghau, ve ukis nimag tapir, ve upalot ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Yo ugham pooz payau, leso nataghon ŋgar tsio. Ve murei, yo pale upakur ghau, ve ugham ghau nalat naleep tomani ghom ila mbonarim loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Yau nagham ŋgar pa gabua eta to nugh sambam mako. Yo mon ta nagham ŋgar payo. Yo ulepleep tomani ghau, tauvene nail saa gabua muul izi taan? Mako. Pasaa, yo mon ta urao. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Isaav ighe tapirig isov, ve ŋgar tsiau imbool, ene pale Maaron ipalot ghau. Tauvene yau naghita Maaron naghe i gabua tauu. Yau naghamgham tapirig ila tooni, ve naleep ila tooni imin taan poia ee tau tipuli payau to naleep ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Yes tau lolozi igheen soghan payo, ene pale tilalez. Ve yes tau tighur murizi payo na, yo pale upasov zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Eemon yau, saawe tau naleep nagharau ghom, nayamaan naghe ene poia kat. Yoova, yo Maaron tsiau. Yau nanumeer ghom ve nayooŋ ilat tsio. Yau naghe navotia uraat tisov tau ughamgham zi na pa tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Mbouŋ to Asap O Maaron, mindai ta ughur murim payei kat? Pale upul ghei nileep tauvene taghon taghon gha ila? Yei sipsip tsio, ve yo ŋginiiŋ tsiei. Puughu mindai ta atem yavyav kat payei tauvene? ");
INSERT INTO tuc_t_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Yei tamtamon tsio. Muuŋ, yo usiigh timbumaiŋa timin lem kat, ve uyozyooz pazi, ve ughamgham mulin zi pa pataŋani toozi. Tauvene matam iŋgal ghei muul. Ve matam iŋgal niam to lepoogh tau igheen izi loloz Zion na paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Taum ulam ve ulaagh ila nugh loolo ve ughita. Isaghat wa! Irau poia muul mako. Koiamaiŋa tireu mbirisai rumei tsio patabuyaaŋ, ve tivaghamunia gabua naol isov tau tigheen ila loolo na. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Nugh tau muuŋ itiŋa taluplup ghiit iloŋ ila na, koiamŋa tiloŋ tila ve tighamu imin lezi, ve tisir toman aliŋazi tiina. Ve tipayooz pilak toozi iloŋ ila, leso itotoi ighe tiliiv ghei wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","6","Yes tivaghamunia Rumei Tiina imin yes tau tigham nakavasi toozi gha tila su to tiŋgor ai. Ai popoiazi naol tau tisap gabua anunuzi ila to tipabood rumei tsio na, tigham nakavasi gha tipalpaal zi, ve tiravrav berekai zi pa hama toozi tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Ve titun rumei tsio patabuyaaŋ, le yav ighan suvinia. Tauvene taum niam to lepoogh tau ezam ighengheen ila na, tivaghamunia imin gabua sorok, le isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Yes tighe titatan ghei ve tivaghamun ghei kat. Tauvene nugh tisov to taan tsiei tau tamtamon tiluplup zi ila ve tisuŋsuŋ payo na, titunuur zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Aazne, yei nighita gabua eta tau itotoi ighe yo ulepleep tomani ghei ne mako. Ve propet eta ileep muul to ipaghazoŋai ghei pa ŋgar tsio ne mako. Ve tsiei eta iwatagh mako: Pale ŋeez o, pataŋani tane isov? ");
INSERT INTO tuc_t_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Maaron, aazne koiamaiŋa tiŋiŋiŋ payo, ve tivevelegh ezam. Mindai, pale upul zi tigham tauvene taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Puughu mindai ta ughur nimam ila murim, ve umamarar ghei mon? Irau uul ghei mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Maaron, muuŋ ve ilam, yo kinik tsiei ve Uleeŋa tsiei. Ve yo ughamgham uraat tintiina izi taan to uul ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Muuŋ, taum tapirim ta uvalagh te gha sirivu ila pa ŋas, ve sirivu ila pa tapir. Ve gabua sasaghati siriv tau tilepleep ila te loolo na, yo urav valaghin dabazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Leviatan paam, gabua saghati tiina tau ilepleep ila te loolo na, yo urav valaghin daaba ta naol ne, ve ugham anooŋa, ve upan gabua sagsagŋa tau tileep nugh ŋginaaŋa na pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Nugh siriv, yo ugham yaa ivotvot pa taan ve irereer. Ve yaa tintiina to nugh siriv tau tirereer irau saawe na, yo ugham zi timakmaak. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Yo ta ughur mboŋ ve mataaz, ve uŋginŋgin zi. Ve yo ughur aaz ve kaiyo tigheen ila niazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Yo ughur taan seŋgaaŋa, ve ughur saawe to nugh tuntunu, ve saawe to nugh yauŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Yoova, matam iŋgal saveeŋ veleghiiŋ tau koiamŋa tisiksiki payo na. Aazne, yes kankanooŋa tau tiwatagh ghom mako na, tivavaghamunia ezam, ve tighit ghom umin kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Koiamaiŋa ŋgar toozi imin gabua sagsagŋa. Lolozi isaghatin tamtamon eta mako. Ve yei tamtamon tsio tapirimai irau gabua eta mako Tauvene upul ghei nila nimazi sov. Lolom iveegh payei sov. Pa yes titatan ghei le nileep saghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Muuŋ, yo umbu saveeŋ tomani ghei ughe yo pale umin Maaron tsiei, ve yei nimin tamtamon tsio. Matam iŋgal saveeŋ mbuaaŋ tsio tana, ve uul ghei. Ughita. Aazne, taan tsiei ivon pa zeran sasaghati tau tiyoŋyooŋ ila ndoroom loolo, ve tisasaŋan pa liŋiiŋ siŋ pa tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Upul zeran sasaghati titatan tamtamon ve tipamayaŋin zi sov. Uul yes mbolaaŋa ve yes tau tileep saghat na. Leso tipait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","23","Maaron, yei tamtamon tsio. Uburig ve uyooz payei lak! Koiamŋa tipapakur tauzi toman aliŋazi tiina. Mataaz ta naol ne, mboŋoozo ila le ravrav izi, yes kankanooŋa tau tiwatagh ghom mako na, tighamgham oroor tiina ve tivevelegh ghom. Lolom iveegh sov. Matam iŋgal ŋgar tau tighamghamu na, ve ughur atuya pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Mbouŋ to Asap Paesiiŋ ila pa ŋeer tau imuŋmuuŋ pa mbouŋ na tauvene: Mbouŋ tane aliiŋa ‘Uvaghamunia sov’ Maaron, yei lolomai poia payo, ve nipakur ghom pa poia tsio. Pasaa, monmon yo ulepleep ugharau ghei. Tauvene yei nipapait ezam, ve nivovotia uraat ŋgeretazi tau ughamgham zi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ve Maaron isaav ighe: “Yau taug naghur saawe to nagabiiz tamtamon ve naghur atuya pazi. Ve gabizooŋ tsiau, ene pale iduduuŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Isaav ighe yogyoog itok taan ve tamtamon tisov tisaŋeeŋ, yau aat nakis taan puughu, leso igheen tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Yes tau tipapait tauzi ezazi na, yau nasaav pazi naghe: ‘Apait taumim irao!’ Ve nasaav pa zeran sasaghati naghe: ‘Tapirimim igheen sindei? Apait tapirimim irao! ");
INSERT INTO tuc_t_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Tauvene apakur taumim sov, ve asik saveeŋ veleghiiŋ payau sov!’” ");
INSERT INTO tuc_t_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Pa tamtamon to aaz izaa, ma tamtamon to aaz izila, ma tamtamon to nugh siriv paam, ene irau tigham tamtamon eta eeza ivot imin tiina ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Maaron mon ta igham tamtamon ezazi ivot imin tiina. Pasaa, i ta igagabiiz tamtamon ve ighurghur atuya pazi. Tamtamon siriv, i itatan zi. Ve siriv, i ipakur zi le ezazi tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yoova ikis rubruub ee ila niima. Rubruub tawe ivon pa vaen ariaaŋa. Vaen tawe, ene aatyavyav tooni. Zeran sasaghati tau tileep izi taan ne, i pale iliŋ vaen tawe, ve ipaghun zi pani, le tisov tighunu le isov. Rabrab tau igheen ila rubruub mboole na, pale tighunu paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Eemon yau navovotia uraat tintiina to Yoova irau saawe. Pale namboumbou mbouŋ, ve napapait Maaron to Yakop eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Pasaa, i isaav ighe: “Zeran sasaghati, yau aat napasov tapirizi. Ve zeran duduŋazi, yau aat napakur zi ve napalot zi, leso tapirizi ivot imin tiina.” ");
INSERT INTO tuc_t_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Mbouŋ to Asap Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to tirav gita ve timbou mbouŋ tane Yes tau tileep izi taan sirivu to Yuda na, tiwatagh Maaron. Ve yes tau tileep ila taan sirivu to Israel na, tipakuru paam, pa i eeza tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Rumei to Maaron igheen izi Yerusalem. Ve loloz Zion, ene Maaron niia to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Saawe tau koiŋa tigham malmal pani ta sewe, i iŋgoor polpolin paneegh natŋa tau yav ighanghan ila matazi na, tomania mbuzaagh toozi, ve irav valaghin sigheu toozi. Tauvene gabua toozi to malmal, i ivaghamun zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O Maaron, yo mbonarim tiina. Yo paghunam ve ezam tiina kat. Uliiv loloz tintiina tau tigheen irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Koiamaiŋa, zeran ariaŋazi. Tiroiroi mako. Eemon yo uparav tomani zi le uliiv zi. Tauta tamtamon tsio tila tiyau gabua toozi to malmal isov imin lez. Yo urav koiamŋa tisov timataar, ve patazi tivaghengheen ila taan. Onoon, yes zeran ariaŋazi. Tirau kat pa ghamuuŋ malmal. Eemon irau tigham gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Maaron to Yakop, yo uparoi zi ve uyaon zi, le yes tau tilandoov hos tomania karis tisov titaptap tizi le timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","O Maaron, yo mon ta tamtamon tisov tiroiroi payo. Pa ighe atem yavyav, sei irau iyooz ila naghom? ");
INSERT INTO tuc_t_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Yes tau koiazŋa tighamgham pataŋani pazi ve titatan zi na, yo uyooz pazi, ve ugham mulin zi tisov. Yo uleep sambam, ve aliŋam izilam ve usavia atuya tau pale ughuru pa koiazŋa na. Ve saawe tau ughur atuya tana pazi, tamtamon tisov to taan tighita, le roiŋ igham zi, ve tineneeŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Onoon kat. Aatyavyav to tamtamon paam, ene irau imin eez to utotoi tapirim. Tauta tamtamon tipait ghom. Ve yes tau aatyavyav tsio ivaghamun zi mako na, yes pale tilivutin ghom, leso tisuŋ payo ve tipait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Yam tau ambu saveeŋ aghe agham gabua pa Maaron tsiam Yoova na, matamim iŋgal saveeŋ tsiam ve ataghoni. Ve yam nugh nugh tau aleep agharau na, tauvene paam. Agham gabua tsiam popoia siriv ilam pa Ŋeer tau tamtamon tiroiroi pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Yes pooza tau tinumeer tauzi tapirizi na, Maaron itatan zi. Tauta yes kinik to taan tiroiroi pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Mbouŋ to Asap Ŋeer tau imuuŋ pa mbouŋ na, aat isaav pa tamtamon to timbou mbouŋ tane itaghon aliiŋa ‘Yedutun’ Yau nataŋ rarai Maaron. Taŋiiz tsiau iŋaruini naghe ighur taliiŋa pa suŋuuŋ tsiau tane, ve iuul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Saawe tau naleep ila pataŋani tiina loolo, yau nazuari ghau naghe le nagham uleeŋ ila to Maaron. Mboŋ ve mataaz, naitiit nimag izaa, ve nasuŋsuŋ pani. Irau namariau mako. Eemon gabua eta irau irav ateg mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Yau matag iŋgalŋgal Maaron, ve lolog isaghat ve nataŋ. Naghamgham ŋgar naol. Tauta lolog ipataŋan ve tapirig isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Mboŋ ta naol ne, Maaron ipul ghau nagheen poi mako. Lolog ipataŋan kat le irau nasavia saveeŋ eta mako. Naneneeŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Pasaa, matag iŋgal imuul ila pa ndaman katini tau ila wa. Ve naŋuzuuv ŋgar tau muuŋ Maaron ighamgham pa tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Tauvene mboŋ ta naol ne, nagham ŋgar tiina ila lolog, ve matag iŋgalŋgal naghe: ");
INSERT INTO tuc_t_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Mindai, pale Maaron ighur muuri payei, ve ipul ghei nileep saghat taghon taghon gha ila? Irau loolo poia payei muul mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Ŋgar to loolo isaghav tamtamon tooni ve iuluul zi, ene isov wa? Ve saveeŋ katini tau i imbua tomani ghei na, pale izi imin kaut sorok taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Ma Maaron aate yavyav kat, le ighamu loolo iveghai poia tooni? Tauta loolo isaghatin ghei muul mako ne?” ");
INSERT INTO tuc_t_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Nagham ŋgar tauvene, tauta nasaav pa taug naghe: “Lolog ipataŋan kat pasaa, Maaron tau ileep saaŋa le saaŋa kat na, itoor ŋgar tooni wa. Taghita tapiri ilam ilam le aazne, taghita muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Yoova, yau aat matag iŋgal imuul ila pa uraat tsio tintiina, ve gabua ŋgeretazi tau muuŋ ughamgham zi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Yau aat matag iŋgal uraat tsio ariaŋazi ta naol ne, ve nagham ŋgar pazi poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O Maaron, yo ughamgham ŋgar patabuyaaŋ mon. Ŋgar tsio ve gabuam, ene maata ite kat. Maaron ite paam eeza tiina imin yo ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Yo Maaron tau ughamgham gabua ŋgeretazi tintiina. Utotoi tapirim ivot ighazooŋ ila nugh nugh matazi gha tighit katini wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Yakop ve Yosep paaghu toozi, ene tamtamon tsio. Muuŋ, ila taum tapirim, yo upas yes Israela tivot pa pataŋani toozi wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O Maaron, saawe tau yaa tintiina tighit ghom, roiŋ tiina igham zi. Ve te tau igheen izila siiŋa we, iroi paam, ve imbelmbeluut ghi ilala ilamlam. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Saawe tana, taitai gabgabuuŋ ve uman tiina izi. Ve lalaav lutluutu tiina, ve ighani milmilia ilala ilamlam. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Yo ugham yaghur tiini ililiit, ve lalaav lutluutu tiina kat. Ve nugh ighani milia, ve mbonari isul nugh. Ve yogyoog itok taan gha ilala ilamlam. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Eez tsio imbut te ve ila pa ziige ite. Yo uvalagh mazavan, le sirivu ila pa ŋas, ve sirivu ila pa tapir, ve ulaagh ila bodbodaaŋ. Eemon tighita aghem niia mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Yo umuuŋ pa tamtamon tsio imin ŋginiiŋ to sipsip. Ve ughur Mose yesuru Aron tigham naghom, ve tigherev zi gha tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Mbouŋ to Asap Yam tamtamon tsiau, aghur taliŋamim pa saveeŋ tau naghe napaduduuŋ gham pani ne. Saveeŋ tau naghe nasavia payam ne, yam asov alooŋ poghania. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Yau pale nakaak avog, ve nasavia saveeŋ palelaaŋ siriv payam. Pale nasavia gabua siriv tau muuŋ tivot na. Gabua tawe, pughuzi iyooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Sinaiŋ tane, timbuunŋa tisavia payei gha nilooŋa, tauta niwataghi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Muuŋ, Yoova itotoi tapiri ivot ighazooŋ. I igham gabua ŋgeretazi ve uraat tintiina ivotvot. Tauta tamtamon tipait eeza pa tapiri ve poia tooni. Uraat tooni tawe, irau taŋgooza pa natuunŋa mako. Iit aat tasavia pazi. Leso paaghu toit tau murei pale tivot na, tiwataghi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Eez to itiŋa Maaron tavalupu ghiit tamin eemon, muuŋ i ivotia pa timbuunŋa tau Yakop paaghu tooni na. I isavia tutuuŋ tooni pa yes Israela, ve isaav ariaaŋ pa timbuunŋa ighe tipaduduuŋ natuzŋa pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Leso yes paam tiwataghi, ve anazi tisavia pa natuzŋa, ve iseeŋga tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Tauvene paaghu toozi irau lolozi iveegh pa uraat tintiina tau Maaron igham zi ne mako. Ve yes pale tinumeera, ve matazi iŋgal tutuuŋ tooni, ve titaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Leso tigham ŋgar imin timbuzŋa sov. Pasaa timbuzŋa, ŋgar toozi iyaryaaŋ kat. Lolozi pa titoor ŋgar toozi mako. Monmon tighamgham taliiŋzizi ve tizorzoor Maaron aliiŋa. Lolozi ikisi tuŋia mako. Ve saveeŋ tau yesŋa Maaron timbua na, titaghoni mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Paaghu to Epraim, yes tirao pa vaneghuuŋ pa paneegh. Eemon saawe tau malmal iburig, tiroi ve tighawaar. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Ve saveeŋ tau yesŋa Maaron timbua na, matazi kisini ve titaghoni mako. Laghooŋ toozi, lolozi pa taghoniiŋ tutuuŋ tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Ve uraat tintiina tomania gabua ŋgeretazi tau muuŋ Maaron igham zi ila matazi na, yes lolozi iveghaini kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Saawe tau timbuzŋa tileep izi Isip, Maaron igham gabua ŋgeretazi tintiina izi taan raraate to Zoan, ve tighita pa tauzi matazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ve saawe tau tila tivot Te Siŋsiŋai, i ivalagh te, le sirivu ila pa ŋas, ve sirivu ila pa tapir. I igham te iyooz imin didiiŋ. Tauta eez ivot pazi, ve titaghoni tila tivool pa ziige ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Mataaz, i igham taitai ivot, leso itotoi eez pazi. Ve mboŋ, i igham yav ivot, leso imuuŋ pazi ve titaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Saawe tau tileep izi nugh ŋginaaŋa, Maaron irav valaghin maet, ve igham yaa ivot pani. I igham yaa ireer tiina, leso tighun. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Onoon kat, i igham yaa katini tivot ila maet, ve tireer tizi le timin yaa tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Eemon yes tinoknok ghamuuŋ sosor pa Maaron Tiina Tau Iliiv Zimaronŋa Tisov na. Saawe tau tilaghlaagh izi nugh ŋginaaŋa, tizorzoor aliiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Yes titovtoov Maaron tapiri. Tauta tisaav pani tighe igham lezi aniiŋ tau luazi itaŋtaŋ pani na. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","20","Ve tivelegh Maaron tighe: “Laak, Maaron tapiri irau igham lemai aniiŋ izi nugh ŋginaaŋa tane? Onoon, i irav valaghin maet, ve yaa tiina iyaat ivot toman tapiri ve ireer izi. Eemon irau igham tamtamon tooni lezi aniiŋ toman ziigha?” ");
INSERT INTO tuc_t_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yoova ilooŋ saveeŋ toozi tawe, le ipas aate. Tauvene igham yav izi ighan Yakop paaghu tooni. Aate yavyav kat pa yes Israela, ve ivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Pasaa, yes tighur ila tooni mako. Tinumeer tighe tapiri irau iuul zi ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Tauvene Maaron isaav ariaaŋ, ve ataman to sambam saamba ikaak, ");
INSERT INTO tuc_t_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","ve igham aniiŋ manna izi pazi. I igham aniiŋ to sambam pazi leso tighan. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Onoon kat, tamtamon tighan aniiŋ to yes aŋela. Maaron igham lezi aniiŋ katini, ve tighan le isooŋ zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Ra ipaburigin yaghur kaaguragh ilam. Tauu tapiri igham yaghur tiina izaa pa ragh puughu. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Ve igham man umbaal tiroov tilam, ve titaptap tizi nugh tau tilepleep pani na. Man tawe, sorok mako kat. Yes timin sausau to nari. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Maaron igham zi titaptap tizi nugh tau tamtamon tooni tilepleep pani na, le tilivutin balbaal toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Tauvene yes Israela tighan le isooŋ zi. Pa gabua tau luazi itaŋ pani, tauta i igham pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","31","Yes Israela tighanghan man tawe le tipasovu soone ve Maaron aatyavyav tooni izaa toozi, ve irav tamtamon toozi ariaŋazi gha timatmaat. Geegeu toozi paghpaaghu tau popoiazi kat na, i ipasov zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Yes Israela tighita gabua naol isov tawe. Eemon tinoknok ghamuuŋ sosor soone. Tikaria ghitooŋ gabua ŋgeretazi. Eemon tighur ila to Maaron mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Tauta i iŋgoor saawe toozi tuuku. Lepoogh toozi isov rekia mon imin yaghuraan tau ivotvot ila avoon. Mateegh ipateeŋ zi, le roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Onoon, saawe tau Maaron irav tamtamon toozi siriv, rekia mon ve eval tiina tighilaal, ve titoor ŋgar toozi imuul ila pani, ve tisuŋ pani ariaaŋ tighe loolo isaghatin zi ve ireu sosor toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Ve matazi iŋgal muul tighe: Maaron, i iponpoon zi imin maetaaz tau izala kat. Maaron Tiina Tau Iliiv Zimaronŋa Tisov na, i ta Uleeŋa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Eemon tipaiti pa avozi uuli mon. Saveeŋ tau ivotvot ila avozi na, tisavia toman lolozi mako. Tigham karom. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Lolozi ikis Maaron ariaaŋ mako. Ve saveeŋ tau yesŋa Maaron timbua na, matazi kisini ve titaghoni mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Eemon Maaron loolo isasaghatin zi, ve ireureu sosor toozi. Tauta ivaghamun zi kat mako. Onoon, saawe naol, i aate yavyav pazi kat. Eemon iyai ghi, ve itatan aatyavyav tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Pasaa, maata iŋgal ighe: Yes to taan mon. Tapirizi tiina mako. Tileep rig, ve tilalez, imin yaghur tau talooŋ luutu ilam, ve isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Saawe tau tileep izi nugh ŋginaaŋa, tizoor Maaron aliiŋa pai katini. Yes tilaghlaagh ila nugh tau sausau mon, ve tighamgham Maaron loolo ipataŋan. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Maaron Patabuyaaŋ to yes Israela, yes tinoknok tovaaŋni. Tauta tipas aate, le aate yavyav kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Yes lolozi iveghveegh pa Maaron tapiri. Matazi iŋgal saawe tau i igham mulin zi ila koiazŋa nimazi na mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Muuŋ, i igham gabua ŋgeretazi katini ivotvot izi Isip to itotoi tapiri pazi. I ighamgham uraat tintiina izi taan raraate to Zoan. Uraat tawe, tamtamon tighita le ŋgar toozi imbool. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","I itoor yaa tintiina to yes Isipa timin siŋ. Tauvene yes Isipa lezi yaa eta to ghunuuŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Ve igham nimnim tintiina tau tiŋutŋut tamtamon na tivot izi nugh toozi, ve tiŋut zi le tisaghat kat. Ve igham gob katini tivot le tivaghamun zi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Ve igham siis tivot le titav nugh toozi, ve tighan aniiŋ toozi. Uum tau tighun punitazi pani na, siis tighaniir gabua to uum tawe le isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ve igham ais paatu paatu titaptap tizi, le ivaghamunia ai vaen toozi. Ve uman tiina tomania ais izi le ivaghamunia ai fik toozi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","I igham ais paatu paatu titaptap tizi, ve irav makau toozi timatmaat. Ve igham lalaav iŋgalŋgal sipsip toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","50","Maaron aate yavyav le yavyav kat. Loolo basbasuuŋ, ve irau aate izi muul mako. Tauta ighur yes Isipa muul mako, ve aatyavyav tooni izaa toozi kat. I imbaaŋ aŋela tooni eval tila tivaghamun zi pa moroghooŋ saghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","I irav yes Isipa natuzŋa aidabazŋa, le tisov timataar. Natuzŋa tau tipoop zi imin maata, tauta tisov. Eta ileep muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Ra igham tamtamon tooni tipul Isip. I imuuŋ pazi imin ŋginiiŋ to sipsip, ve yesŋa tilaghlaagh izi nugh ŋginaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","I imuŋmuuŋ pazi ve iŋginŋgin zi. Tauvene tiroi pa gabua eta mako, ve tileep poia mon. Eemon koiazŋa, te itav zi, le tisov timataar ila te loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","I igherev zi tila tigharau taan tooni patabuyaaŋ ziige, ve loloz tau i iparav pani ve ighamu imin le na. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Ve iziir nugh nugh tau tileep ila taan tawe na tighawaar, leso tamtamon tooni tila tigham taan toozi imin lezi motot. Ve irei taan tawe tomania ruum tau tighenaar ila na, le irau rumei rumei to yes Israela, ve tighamu imin lezi to tileep ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","57","Eemon tizi ve titoov Maaron Tiina Tau Iliiv Zimaronŋa Tisov na muul. Tizorzoor aliiŋa, ve eez tau i ighuru pazi na, titaghoni mako. Yes tamtamon tooni. Eemon tighur murizi pani, ve tireu saveeŋ mbuaaŋ tau timbua tomania Maaron na raraate imin timbuzŋa. Tauvene i irau inumeer zi mako. Yes timin paneegh tau ool ipas pani, ve le uraat mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Maaron iriu zi pasaa, tighagharaat maaron karomŋa anunuzi. Yes tiluplup zi izala nugh mbua ta naol ne, ve tisuŋsuŋ pa maaron karomŋa. Tauta tipas Maaron aate. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Maaron ighita ŋgar toozi tawe, le aate yavyav ve ighur muuri pazi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Saawe tana, i ipul balbaal tooni patabuyaaŋ tau igheen izi nugh Silo na, izi ileple. Niia to lepoogh tau igheen ila tamtamon tooni sosozi na, i ileep ila muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ve Bokis to Saveeŋ Mbuaaŋ tau imin ilaal pa tapiri ve mbonari na, i ipuli ila yes Israela koiazŋa nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","63","Aate yavyav kat pa tamtamon tooni. Tauvene ipul zi tila koiazŋa nimazi ve timbut zi pa mbuzaagh, le geegeu toozi paghpaaghu timataar. Zilivaa toozi paghpaaghu irau timbou mbouŋ to vaiŋ muul mako. Pasaa, zitamoot tileep ve tivai zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Zeran to watooŋrau paam, mbuzaagh ighan zi gha timatmaat. Ve azuwazŋa zilivaa tau tileep timin zinaara na, irau titaŋ pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Ra Maaron igham ŋgar imin tamtamon tau igheen gha iburig. I imin tamtamon ariaaŋa to malmal tau ighun le ivaghamgham. Mako maata pakia ve iburig ila igham malmal muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","I itatan koiŋa, ve tighau tila toman mayazi. Mayaŋa tawe pale ighengheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Maaron ighur muuri pa Yosep paaghu tooni. Ve niia to lepoogh paam, igheen tomani zi muul mako. Irau igham yes Epraima pa uraat tiina eta muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Ve isiigh rumei to Yuda, leso tigham pooz pa tamtamon tooni. Ve igham loloz Zion imin i le. Loloz tawe, i loolo pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","I irau rumei tooni patabuyaaŋ izala, leso imin niia to lepoogh. Rumei tawe iyaryaaŋ kat imin sambam. Pale iyooz tuŋia tauvene taghon taghon gha ila, imin taan tau i ighuru na. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Ve i isiigh besooŋa tooni David to imin kinik. David iŋginŋgin sipsip ila olol loolo, ve Maaron ighuru pa uraat tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","I maata pa sipsip tinazŋa tomania natuzŋa tau tighunghun tuz na, ve Maaron ighamu imin ŋginiiŋ to yes Israela tau Yakop paaghu tooni na. ");
INSERT INTO tuc_t_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Tauvene David iŋgin zi itaghon ŋgar duduuŋa, ve igham pooz pazi poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Mbouŋ to Asap O Maaron, aazne nugh nugh tau tiwatagh ghom mako na, tilam taan tsio tane, ve tighe tighamu imin lezi. Yes tivaghamunia rumei tsio patabuyaaŋ le isaghat, ve tireu mbirisai nugh tiina Yerusalem. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Yes tirav besooŋa tsio timatmaat, ve tipul patazi tivaghengheen taghon taan paavo, leso man tighan zi. Tamtamon tsio tau lolozi isaghav ghom ariaaŋ ve titaghon eez tsio, tauta mizazi imin gabua sagsagŋa lezi to tighani. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Koiamaiŋa tirav tamtamon tsiei katini, ve siŋ toozi ireer imin yaa irau Yerusalem loolo. Ve tsiei eta ileep to itavi zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Tauvene nugh nugh tau tileep tigharau ghei ne, tighit ghei, ve tighamgham ŋalalaŋ payei. Yes tiŋiŋiŋ payei, ve tivevelegh ghei kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O Yoova, pale ŋeez o lolom imuul ilam payei? Pale uriuriu ghei, ve aatyavyav tsio ighanghan ghei imin yav irau saawe? Pale aatyavyav tsio izazaa tsiei tauvene taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Ugham aatyavyav tsio izaa to nugh nugh tau tiwatagh ghom mako na, ve tiyamaan katini. Ughur atuya iŋarui yes tau tisuŋsuŋ payo mako na, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Pasaa, yei tau Yakop paaghu tooni na, tiravuur ghei nisov. Ve tivaghamunia taan tane, le nugh tsiei ŋginaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Sosor tau muuŋ timbumaiŋa tighamgham zi na, ughur atuya izaa tsiei sov. Lolom isaghatin ghei, ve rekia ulam uul ghei. Pa aazne, saghatiiŋ tiina ivot payei gha nisaghat wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Maaron, yo ta Uleeŋa tsiei. Uul ghei lak! Leso eval tipait ezam pa tapirim ve poia tsio. Upas ghei nivot pa pataŋani tane, ve ureu sosor tsiei. Pasaa, gabuam tauvene. Tauta tamtamon tipapait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Maaron, isaav ighe uul ghei mako, ene pale nugh nugh tisavia saveeŋ veleghiiŋ payei tighe: “Laak, Maaron tsiam ileep sindei?” Maaron, yes tau tiliŋliŋ siŋ pa besooŋa tsio na, uyat ŋgar toozi tawe, ve nighita. Leso nugh nugh tiwatagh tighe yo ughurghur atuya pa ŋgar saghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Ulooŋ taŋiiz to yes tau tileep ila koiazŋa nimazi na. Yes tau koiazŋa tighe tirav zi timaat na, ugham mulin zi. Pa yo tapirim tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Maaron, nugh nugh tisiksik saveeŋ veleghiiŋ payo. Ŋgar toozi tawe, uyatu le uyat katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ighe ugham tauvene, ene pale yei tamtamon tsio lolomai poia payo, ve nipait ezam pa poia tsio irau saawe. Pale nisinai uraat tsio taghon taghon gha ila. Pasaa, yei sipsip tsio, ve yo ŋginiiŋ tsiei. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Mbouŋ to Asap O Maaron, yo ŋginiiŋ to yei Israela, ve yei sipsip tsio. Yo ta umuŋmuuŋ pa yei paaghu to Yosep. Ughur taliŋam pa suŋuuŋ tsiei tane. Yo uleep ila niam to ghamuuŋ pooz tau igheen izala aŋela ariaŋazi avarazi na. Utotoi mbonarim ivot ighazooŋ payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Yo saksakim ve ariaŋam. Uburig ve utotoi tapirim ila Epraim, Benyamin, ve Manase paaghu toozi matazi. Ulam uul ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O Maaron, uul ghei ve upalot ghei. Lolom poia payei, ve ugham poghani ghei. Leso nileep poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Yei tamtamon tsio. Eemon atem yavyav payei, ve ulooŋ suŋuuŋ tsiei mako. Pale ŋeez o aatyavyav tsio isov? ");
INSERT INTO tuc_t_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Yo ugham ghei nibaad pataŋani tiina le isooŋ katin ghei. Tauvene nitaŋ tiina, ve nighun matamai suuru imin lemai yaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Yo ughur murim payei. Tauvene nugh nugh tau tileep tigharau ghei ne, tivazorai zi pa taan tsiei tighe tighamu imin lezi. Ve koiamaiŋa tivevelegh ghei, ve tiŋiŋiŋ payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Yo Maaron saksakim ve uŋgin gabua naol isov. Uul ghei ve upalot ghei. Lolom poia payei, ve ugham poghani ghei. Leso nileep poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Muuŋ, ai vaen ee iyooz ila taan to yes Isipa. Yo usuru, ve ughamu ilam ta sene, ve uziir nugh tane tamtamona tighau, ve uvazoghi ila taan toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ve uzavaan puughu, leso itum poi. Tauvene waria izila taan loolo kat, ve booga titum tila mamalau, le titav taan tane isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ai vaen tane itum izaa izaa, le itav loloz to nugh tane, ve imin yavyaav pazi. Ve ai mezepur tintiina tiyooz ila saamba paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Booga siriv tiraraav zi tila le tivot nari to te Mediterenian. Ve siriv tiraraav zi tila le peria yaa tiina Euprates. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Mindai ta aazne ureu didiiŋ tau muuŋ ilivutin uum vaen tsio na? Ughita. Tamtamon tau tilaghlaagh sorok na, tisov tilam tiloŋ tila ve tiyumyum anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Ve ŋgai sagsag tisusus puughu ve tivavaghaaza, ve gabua naol to su tighanghan anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","15","O Maaron, yo saksakim ve uŋgin gabua naol isov. Matam imuul ilam payei. Uleep sambam ve matam izilam ughita ai vaen tau nimam tapir ivazoghi na. Isaghat wa! Tauvene ulam ugharaata! Leso itum poi muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Aazne, koiamŋa tiŋgor ai vaen tsio izi, ve tisuruuva izala yav. Ughit zi ve uyaon zi, ve upasov zi gha tilalez! ");
INSERT INTO tuc_t_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Eemon tamtamon tsio tau ileep ila nimam tapir na, uŋgin poghania ila nimam saamba. Kinik tsiei tau yo taum usiigho ve ughuru pa uraat na, matam pani ve upaloti, leso igham uraat payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ighe ugham tauvene, ene yei aat irau nighur murimai payo muul mako. Tauvene uul ghei nileep poia muul. Leso nibees payo ve nipait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Uul ghei ve upalot ghei. Lolom poia payei, ve ugham poghani ghei. Leso nileep poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Mbouŋ to Asap Lolomim poia pa Maaron, ve ambou pani. Pa iit taghamgham tapiriin ila tooni. Tintinmim pa Maaron to Yakop, ve ayoor eeza toman aliŋamim tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Ait mbouŋ ve ambou. Ve atok kakaap, ve arav gita ve gabua siriv, leso agham mbouŋ paghuuna. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Saawe to kaiyo izaa paaghu, ve saawe to kaiyo dodoliiŋ, ene saawe to talup ghiit ve tasuŋ. Tauvene aviv tavuur ve apaburigin suŋuuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Pa ŋgar tauvene, ene itaghon tutuuŋ tau Maaron ighuru pa iit Israela alok wa. Maaron to Yakop ighe tataghon tutuuŋ tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Saawe tau i igham malmal pa yes Isipa, i isaav pa iit Israela to tataghon tutuuŋ tane, leso itiŋa tavalupu ghiit tamin eemon. Yau nalooŋ ŋeer ee aliiŋa ilam. Ta muuŋ ve ilam, nalooŋ aliiŋa tauvene mako. Isaav ighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Yau ta nazugh yauyauŋ pataŋani izi pa avaramim, ve nagham gham amariau pa badooŋ gabua. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Muuŋ, yam aleep ila pataŋani tiina loolo, ve ataŋ rarai ghau to nauul gham. Ve yau nalooŋ taŋiiz tsiam, ve napas gham avot pa pataŋani tsiam. Yau nayooŋ ila taitai gabgabuai tau lalaav lutluutu ivotvot pani na, ve nayol aliŋamim. Ve yau natoov gham izi yaa ziige to nugh Meriba. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Yam tamtamon tsiau, alooŋ saveeŋ ariaaŋa tau naghe nasavia payam ne. Yam Israela, aghur taliŋamim pa aliŋag tane ve ataghoni, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Maaron ite paam ileep ila sosomim ve abees pani sov. Yau mon, o abees payau. Tauvene aput aghemim pa maaron karomŋa to nugh siriv sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Pa yau Yoova ta Maaron tsiam. Yau ta nagham gham apul Isip. Yau nasaav payam naghe: Akaak avomim tiina. Leso napavoni pa gabua popoia. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Eemon tamtamon tsiau tilooŋ aliŋag mako. Yes Israela timbuzir payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ŋgar toozi iyaryaaŋ kat. Lolozi pa loŋaaŋ saveeŋ mako. Tauta napul zi titaghon tauzi ŋgar toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Yau napasawal naghe le tamtamon tsiau tilooŋ aliŋag, ve titaghon eez tsiau! ");
INSERT INTO tuc_t_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Leso rekia mon ve koiazŋa tiyamaan nimag, ve natatan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Yes tau tighurghur koi payau na, pale tilam titap izi naghog toman roiŋ tiina. Ve atuya tau pale izaa toozi, ene aat ighengheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Eemon yam Israela, pale napan gham pa aniiŋ popoia, ve napaghun gham pa tok to su suuru le isooŋ gham.” ");
INSERT INTO tuc_t_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Mbouŋ to Asap Maaron ileep ila niia to ghamuuŋ pooz, ve yes daaba to nugh sambam tilup zi ila naagho. I ipayooz zimaronŋa pa savsaveeŋ, ve igabiiz zi pa uraat toozi. Ighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“Yam tane, eez tsiam to ghamuuŋ pooz, iduduuŋ mako. Pale ŋeez o apul ŋgar tana? Saawe tau daaba to taan tigharaat saveeŋ to tamtamon, yam apul zi tivolvool to zeran sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Yam aat apaburigin zi, leso tigharaat saveeŋ to yes tau tapirizi imbool ve yes parooŋa, le iduduuŋ mon. Ve tiyooz pa yes tau tileep ila pataŋani loolo, ve yes tau lezi uleeŋ eta mako na, ve tiuul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Tauvene yes tau tapirizi imbool, ve yes mbolaaŋa, yam irau matamim pazi, ve agham mulin zi ila zeran sasaghati nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Eemon yam aghamgham tauvene mako. Lemim ghilalooŋ mako. Ŋgar tsiam ivot soone. Laghooŋ tsiam, yam ataghon ŋgar to ndoroom. Tauta ŋgar ve tutuuŋ naol tau timin puughu pa lepoogh poia izi taan na, yam avaghamunia le isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Onoon, muuŋ yau nawaat gham naghe ‘zimaronŋa.’ Ve nasaav payam naghe: ‘Yam asov amin Maaron Tiina Tau Iliiv Zimaronŋa Tisov na natŋa.’ ");
INSERT INTO tuc_t_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Eemon yam pale asov amatmaat raraate imin eval tiina to taan. Pale atap imin yes daaba to taan, ve lemim ezamim muul mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Maaron, uburig ve ughur atuya pa zeran sasaghati tau tileep izi taan na. Pasaa, nughmariŋ to taan tomania gabua toozi, ene yo tsio mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Mbouŋ to Asap O Maaron, mindai ta avom luutu mako ve uneneeŋ mon? Mindai ta uput nimam ve ulepleep sorok? ");
INSERT INTO tuc_t_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Ughita. Koiamŋa tighe tipaburigin malmal. Yes tau tighurghur koi payo na, tipakur tauzi ve tighamgham aghezi payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Tamtamon tsio tau lolom pazi kat na, koiamŋa tawe tilup zi, ve tiil eez to tivaghamun zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Tighe: “Alam tala ve tapasov yes Israela le tisov kat. Leso ezazi igheen muul sov, ve tamtamon lolozi iveegh pazi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Onoon kat, koiamŋa tawe tilup lolozi ve ŋgar toozi imin eemon, ve timbu saveeŋ tighe tigham malmal payo ve tivaghamunia tamtamon tsio. Yes tamtamon to nugh tane: ");
INSERT INTO tuc_t_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Yes Edoma tomania Ismael paaghu tooni, ve yes Moapa tomania yes Agri, ");
INSERT INTO tuc_t_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ve yes to taan sirivu to Gebal tomania yes Amona ve Amaleka, ve yes Pilistia ve tamtamon to nugh Tiro. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Ve yes Asiria paam tau zeran ariaŋazi to malmal na, tivool to yes Amona ve Moapa tau Lot paaghu tooni na, leso tiuul zi pa malmal. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Tauvene yei nitaŋ rarai ghom nighe ugham ŋgar raraate pa yes tawe imin tau muuŋ ugham pa yes Midiana, ve murei ugham pa Sisera yesuru Yabin izi yaa Kison na. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Saawe tana, yo urav zi timataar izi nugh Endor, ve patazi tivaghengheen taghon taan paavo gha timbuzaar. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Yes daaba to koiamaiŋa, ugham ŋgar raraate pazi imin tau muuŋ ugham pa Oreb yesuru Zeeb na. Ve yes pooza toozi tauvene paam. Utatan zi imin tau muuŋ utatan Zeba yesuru Zalmuna na. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Zeran ru tawe, muuŋ tisaav tighe: “Maaron taan tooni, le kikiliiŋ popoia. Tala taghamu imin leen.” ");
INSERT INTO tuc_t_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Maaron tsiau, ureu zi le timbiriis imin ŋgaupup ve rabrab tau yaghur ivuvuura gha ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Uvaghamun zi imin yav tau ighan suvinia regh, ve imin yav tau ighan izala loloz, le ipasov su. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Ugham uman tiina izi, ve yaghur tiina izaa, leso tiroi ve tighau. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O Yoova, utatan zi. Leso mayazi kat, ve tighilaal tighe yo ezam tiina, ve tisuŋ payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ugham zi tivaghamgham, ve tileep toman mayazi taghon taghon gha ila. Upamayaŋin zi, ve upasov zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Leso tighilaal tighe: Yoova, yo mon ta ezam tiina. Yo Maaron Tiina Tau Uliiv Zimaronŋa Tisov, ve uŋgin taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Mbouŋ to yes Kora O Yoova, yo saksakim ve uŋgin gabua naol isov. Yau lolog pa rumei tsio kat. Pa ene paghuuna kat ve imin niam to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Yau napasawal naghe le naleep ila sirsiir to rumei tsio loolo, o poia. Maaron, yo uleep matam yaryaare irau saawe. Tauvene lolog ve ŋgar tsiau isov iŋaŋarui ghom, ve lolog poia kat ve namboumbou payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yoova, yo saksakim ve uŋgin gabua naol isov. Yo kinik tsiau ve Maaron tsiau. Man tau tileep ila sirsiir to rumei tsio loolo na, lolozi poia kat. Ve maetbooga tiraurau rumazi ila rumei tsio loolo, leso tileep tigharau artaal tsio, ve tipoop natuzŋa ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Yes tau tilepleep ila rumei tsio loolo na, poia tsio izazaa toozi ve lolozi poia kat. Tauta timboumbou ve tipapait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Yes tau tighamgham tapirizi ilat tsio na, poia tsio izazaa toozi ve lolozi poia kat. Lolozi iyaryaaŋ tighe le titaghon eez tau ila pa loloz Zion na, leso tisuŋ payo izi ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Saawe tau tilaagh ila taan raraate tau le yaa mako na, yaa katini bolokbolokia ila taan ve tizazaa. Maaron igham uman izi pa taan tawe, tauta yaa ipot irau nugh. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Tauvene tamtamon tooni tapirizi ivotvot, ve tilaghlaagh taghon eez, le tila tivot Maaron naagho izi loloz Zion. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Ulooŋ suŋuuŋ tsiau tane. Maaron to Yakop, ughur taliŋam payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Maaron, suŋuuŋ tsiei iŋarui ghom pa kinik tsiei tau yo taum usiigho na. Matam pani ve ughur poia tsio izaa tooni. Pa i ta imin sigheu payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Isaav ighe yau naleep ila sirsiir to rumei tsio loolo pa aaz eemon geeg, ene igham ghau lolog poia iliiv saawe ndiŋndiŋ ndiŋndiŋ tau naleep izi nugh siriv. Yau lolog pa naleep tomania zeran sasaghati ila ruum toozi mako. Yau naghe le naleep ataman aavo to Maaron tsiau rumei tooni, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Maaron toit Yoova, ghazooŋa tooni isul ghiit imin aaz, ve i imin sigheu pait. I ighamgham poghani ghiit, ve igham ezaan ivot imin tiina. Yes tau laghooŋ toozi iduduuŋ ila maata na, i irau iŋguruut gabua poia eta pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Yoova, yo saksakim ve uŋgin gabua naol isov. Yes tau tinumeer ghom na, poia tsio izazaa toozi ve lolozi poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Ene mbouŋ to ŋeer tau imuuŋ pa mbouŋ Mbouŋ to yes Kora O Yoova, muuŋ yo ughamgham poghania nugh tsio. Yei tau Yakop paaghu tooni ne, saawe tau nileep ila pataŋani loolo, yo uul ghei ve ugham ghei nileep poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ve saawe tau tamtamon tsio tigham sosor, yo upul sosor toozi. Ŋgar toozi tau isosor ila yo matam na, yo ureua isov ilale. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Yo utatan aatyavyav tsio, ve lolom iluum pazi muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ve aazne, nitaŋ rarai ghom muul. Maaron, yo Uleeŋa tsiei. Matam imuul payei ve uul ghei, leso nileep poia muul. Atem yavyav payei muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Mindai, pale aatyavyav tsio izazaa tsiei irau saawe? Pale ighengheen tauvene taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Yei tamtamon tsio. Tauvene matam imuul ilam payei, ve upaburigin ghei muul. Leso lolomai poia payo, ve nipait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Yoova, lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Utotoi ŋgar tana payei muul, ve ugham mulin ghei. Leso nileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Yau aat naghur taliŋag poi pa saveeŋ tau Maaron ighe ivotia pa tamtamon tooni. Pasaa, yau nawatagh: Yoova pale isavia saveeŋ luuma pait. Tamtamon tooni tau lolozi isaghavu ariaaŋ ve titaghon eez tooni na, i pale iuul zi, leso tileep poia muul. Eemon yes aat tiyamaan zi. Ŋgar to borauŋa tau muuŋ tighamghamu na, tighamu muul sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Onoon kat. Yes tau tiroi pa Maaron ve titaghon ŋgar tooni na, i ilepleep igharau zi ve isasaŋan pa uleeŋ zi. I aat ileep tomani ghiit, ve itotoi tapiri ve poia tooni ivot ighazooŋ izi taan tsiei tane ");
INSERT INTO tuc_t_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Maaron loolo isaghav tamtamon tooni ariaaŋ ve iuluul zi, ve yes titaghon tutuuŋ tooni. Tauta yesŋa tilup zi timin eemon. Yes titaghon ŋgar duduuŋa, ve i igham zi tileep poia toman lolozi luuma. Tauta lupuuŋ toozi eemon. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Ŋgar to taghoniiŋ saveeŋ onoon, ene ivotvot izi taan. Ve Maaron ileep izi sambam, ve maata pait itaghon ŋgar tooni duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Onoon kat, Yoova pale igham lemai gabua popoia. I pale igham mariri poia ivot ila taan tsiei. ");
INSERT INTO tuc_t_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Ŋgar duduuŋa, ta imuŋmuuŋ pani, ve ighagharaat eez pani to ilam. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Mbouŋ to David O Yoova, ughur taliŋam payau. Ulooŋ suŋuuŋ tsiau tane, ve uul ghau. Pa yau naleep ila pataŋani loolo ve nailiil eez. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Yau besooŋa tsio, ve nanumeer ghom. Lolog isaghav ghom, ve nataghon eez tsio. Yo Maaron tsiau. Tauvene uvool tsiau, ve ugham mulin ghau. Mako pale namaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Tiina tsiau, lolom isaghatin ghau ve uul ghau! Pa saawe isov, ta mboŋoozo ila le ravrav izi, taŋiiz tsiau iŋaŋarui ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Yoova, yau besooŋa tsio. Yau nasuŋ payo toman lolog. Ugham lolog poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Tiina tsiau, yo poiam kat, ve upulpul sosor to tamtamon. Tamtamon tisov tau tisuŋsuŋ payo na, lolom isaghav zi ariaaŋ, ve uluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Tiina tsiau, ughur taliŋam pa suŋuuŋ tsiau. Ulooŋ taŋiiz tsiau tane ve uul ghau. Pa yau besooŋa tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Saawe tau naleep ila pataŋani loolo, yau nataŋ rarai ghom. Pasaa, yau nawatagh: Yo aat ulooŋ suŋuuŋ tsiau ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Tiina tsiau, yo mon ta Maaron tauu. Maaron ite paam raraate imin yo mako. Eta irau igham uraat tintiina imin yo ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Yoova, yo ughur tamtamon tisov tileep irau nugh toz toz. Nughmariŋ pale tilam tiput aghezi payo, ve tipait ezam pa tapirim ve poia tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Pasaa, yo ezam tiina, ve ughamgham gabua ŋgeretazi tintiina. Tauvene yo mon ta Maaron tauu. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O Yoova, utotoi eez tsio payau Leso laghooŋ tsiau iduduuŋ mon itaghon saveeŋ tsio onoon. Ve ugham ghau naghur lolog isov iŋarui ghom. Leso naroi payo, ve nataghon aliŋam. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Tiina, yo Maaron tsiau. Yau lolog poia payo, ve napakur ghom toman lolog isov. Yau aat napait ezam pa tapirim ve poia tsio irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Pasaa, yo lolom isaghav ghau ariaaŋ ve uluul ghau. Muuŋ, rigmon kanaŋ nazila mateegha niazi. Eemon yo ugham mulin ghau, tauta namaat mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Maaron, ughita. Aazne, zeran sasaghati tiburig tighe tivaghamun ghau. Yes to taliiŋzizi tilup zi, ve tighe tirav ghau namaat. Lolozi isaghatin tamtamon eta mako, ve matazi iŋgal ghom rigta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Tiina, yo Maaron tau lolom isasaghatin ghei, ve ughamgham poghani ghei. Atem yavyav rekrekia mako. Poia tsio, ene tiina kat. Yo lolom isaghav ghei ariaaŋ ve uluul ghei, ve utaghon saveeŋ tsio irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Tauvene matam imuul ilam payau, ve lolom isaghatin ghau. Upalot ghau. Pa yau besooŋa tsio. Yau nabesbees payo imin tinaŋ ibesbees payo. Tauvene ugham mulin ghau pa pataŋani tsiau tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","O Yoova, ugham ŋgar eta leso itotoi ighe yo lolom poia payau. Pasaa, ighe yo uul ghau, ve ugham ghau ateg izi, ene pale koiagŋa tighita tighe onoon yo lolom payau. Mako mayazi ve tineneeŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Mbouŋ to yes Kora Yoova tauu ipayooz nugh tooni izi loloz tooni patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","I loolo pa nugh Zion kat iliiv nugh naol tau Yakop paaghu tooni tileep ila na. ");
INSERT INTO tuc_t_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O Yerusalem, yo Maaron nugh tooni. Tauta tamtamon tipait varum kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Maaron isaav ighe: “Yes Isipa ve Babilona pale tiwatagh ghau, ve nawaat zi ‘tamtamon tsiau.’ Ve yau aat nasaav pa yes Pilistia, yes to nugh Tiro, ve yes to Etiopia paam tauvene: ‘Yam amin Yerusalem tamtamona, raraate imin yes tau tipoop zi izi ta sene.’” ");
INSERT INTO tuc_t_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Onoon kat, pale tisavia nugh Zion tighe: “Maaron Tiina Tau Iliiv Zimaronŋa Tisov na igham tamtamon to nughmariŋ timin Yerusalem tamtamona. Nugh tawe, i tauu ipayooze.” ");
INSERT INTO tuc_t_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Tauvene saawe tau Yoova ibood tamtamon tooni ezazi ila rau, i pale ibood saveeŋ to ipaghazoŋai nughmariŋ tawe ighe: “Yes nugh tauu to Yerusalem.” ");
INSERT INTO tuc_t_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Tauvene tamtamon pale timboumbou, ve titortor toman lolozi poia, ve tisaav tighe: “A Yerusalem, yo umin puura tau yaa bolokbolokia pani. Pasaa, yo, tauta gabua popoia katini ivotvot payei!” ");
INSERT INTO tuc_t_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Mbouŋ to yes Kora Heman, tau paaghu to Ezra na itoor mbouŋ tane Yoova, yo Maaron tsiau ve Uleeŋa tsiau. Mataaz ta naol ne, nataŋtaŋ toman aliŋag tiina iŋarui ghom naghe uul ghau. Ve mboŋ paam, nalam naleep ila naghom, ve nasuŋsuŋ payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Ulooŋ suŋuuŋ tsiau tane. Ughur taliŋam pa taŋiiz tsiau, ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Pa pataŋani naol itatan ghau, ve naghita naghe naleep ila naal aavo wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Tamtamon tighit ghau tighe paita namaat ve nazila nugh to mateegha tane. Pa tapirig isov kat wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Tamtamon tighit ghau imin namaat wa. Tauta lolozi iveegh payau, ve zigau naleep. Yau namin zeran tau tirav zi timatmaat, ve tisuruuv patazi izila naal. Ve namin yes mateegha tau yo lolom iveghai zi ve irau uul zi muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Yo ughur ghau nazila puura to mateegha tau izila le izila kat. Naleep siiŋa kat ila ndoroom loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Aatyavyav tsio itatan ghau kat, imin dibom tintiina tipolpol izala pavog ve titavtav ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Yo ugham zetagŋa timoghaagh payau. Lolozi pa tighit ghau mako. Pasaa, ŋgar tau ugham payau ne, ene igham zi tighit ghau namin gabua saghati. Lepoogh tsiau, ene imin naleep ila ruum to yavyavuuŋ loolo, ve leg eez to navot mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Yoova, mataaz ta naol ne, yau naitiit nimag izazaa, ve nataŋtaŋ rarai ghom to uul ghau. Lolog ipataŋan kat, ve nataŋ tiina le matag isarsar. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Laak, yo ugham gabua ŋgereeta eta pa yes mateegha leso uul zi? Ma mateegha irau tiburig ve tipait ezam? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Ve yes tau tigheen ila naal loolo na, tisasavia ŋgar tsio tau lolom isaghav tamtamon tsio ve uluul zi? Ma yes tau tileep ila nugh to saghatiiŋ na, tisavsaav pa ŋgar tsio to utataghon saveeŋ mbuaaŋ tsio? Mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Ve yes tau tileep ila ndoroom loolo na, tiwatagh gabua ŋgeretazi tau ughamgham zi ne? Ma mateegha tau tamtamon lolozi iveghai zi na, matazi iŋgalŋgal ŋgar tsio duduuŋa? Mako kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Eemon yau, o nataŋtaŋ payo naghe uul ghau. Yoova, mboŋoozo ta naol ne, suŋuuŋ tsiau iŋaŋarui ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Yoova, mindai ta ughur murim payau, ve uŋgooz naghom payau? ");
INSERT INTO tuc_t_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Saawe tau kukuag ve ilam, nabadbaad pataŋani tiina, ve nalepleep ila naal aavo. Yo ughurghur pataŋani payau, ve upaparoi ghau imin koiam yau. Tauta lolog ipataŋan kat, ve naghita naghe narau gabua eta muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Pasaa, aatyavyav tsio itatan ghau kat. Yo uvaghamun ghau le naroi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Saawe isov ta mboŋoozo ila le ravrav izi, lepoogh tsiau, ene imin dibom ipol toman tapiri, ve rigmon kanaŋ izugh ghau gha nalaleg. Pataŋani naol tilivutin ghau, ve leg eez to napaghau taug mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Yo ugham zetagŋa ve toŋvetaz tsiau timoghaagh payau. Yes tau muuŋ yeŋa lupuuŋ tsiei eemon na, tigharau ghau muul mako. Aazne, ndoroom tiina ikau ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Mbouŋ tane to Etan, i Ezra paaghu tooni O Yoova, yau aat nambou ve napait ghom irau saawe. Pasaa, yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Ve ŋgar tsio to taghoniiŋ saveeŋ mbuaaŋ tsio tauvene paam. Avog pale ivovotia pa tamtamon ta aazne ve iseeŋga taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Pale navoti ghom pa tamtamon naghe: Ŋgar tau lolom isaghav tamtamon tsio ve uluul zi, ene pale ighengheen tauvene le alok. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tsio paam, ene igheen tuŋia irau saawe, imin sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","4","Muuŋ, yo usaav ughe: “Yau nasiigh besooŋa tsiau David ve nambu saveeŋ tomania. Saveeŋ tane, napariaaŋa le iyaryaaŋ kat naghe: ‘Yau pale napalot paaghu tsio, ve naghur zi timin kinik irau saawe. Yes pale tileep ila niam to ghamuuŋ pooz, ve tiŋgin yes Israela taghon taghon gha ila.’” ");
INSERT INTO tuc_t_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yoova, yes aŋela patabuyaaŋa tiluplup zi izi sambam, ve tipapait ezam pa gabua ŋgeretazi tau ughamgham zi na. Yes tipapakur ghom pasaa, yo utataghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Yoova, sei ta irau ghom? Yes tau tileep izi sambam na, yo uliiv zi tisov. Aŋela eta irau ghom mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Saawe tau yes daaba to aŋela patabuyaaŋa tilup zi pa savsaveeŋ izi nugh sambam, yes tiyooz livutin ghom toman roiŋ tiina, ve tipakur ghom. Pasaa, yo tapirim tiina ve uliiv zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yoova, yo Maaron saksakim ve uŋgin gabua naol isov. Sei tapiri tiina kat imin yo? Eta mako. Ve yo utortoor ŋgar tsio mako. Saawe isov, utataghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Yo ta uŋgin te. Isaav ighe yaghur tiina izaa ve ipei dibom tintiina, yo irau ugham dibom imaat, ve taun izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Muuŋ geeg, yo urav valaghin Rahab daaba gha imaat. Nimam pataŋani. Tauta urav matin koiamŋa, ve ureu mbirisai zi tighawaar. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Sambam ve taan, ene yo tsio. Pasaa, yo ta ughur zi tomania gabua naol isov tau tileep ve tigheen ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Yo ughur taan tau igheen ila pa ragh, ve ila imuul yavaar puughu. Loloz Tabor ve loloz Hermon timboumbou toman lolozi poia ve tipait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Yo saksakim ve tapirim tiina. Nimam tapir, ene saghati. Tauta urav koiamŋa ve uliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ŋgar duduuŋa tomania ŋgar to gabizooŋ tamtamon itaghon ŋgar duduuŋa, tauta imin puughu pa pooz tsio. Ve ŋgar isov tau ughamgham zi na, itotoi ighe: Yo lolom isaghav tamtamon tsio ariaaŋ ve uluul zi, ve utataghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Yes tau tilup zi pa suŋuuŋ toman lolozi poia ve tiyoryoor ezam na, tilaghlaagh ila ghazooŋa tsio, ve poia tsio izazaa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Yes tiwatagh ghom tomania ŋgar tsio. Tauvene saawe isov, ta mboŋoozo ila le ravrav izi, lolozi poia kat, ve tipapait ezam pa ŋgar tsio duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Yei nigham tapirimai ilat tsio, tauta tinimai izaa ve ezamai imin tiina. Poia tsio, tauta igham tapirimai ivot le niliiv koiamaiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Yoova, yo usiigh ŋeer tau imin sigheu payei. I ta iponpoon koiamaiŋa. Maaron patabuyaaŋ to yei Israela, yo ughur lemai kinik to igham pooz payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yes tau lolozi isaghav ghom ariaaŋ ve titaghon eez tsio na, muuŋ geeg, yo upaghazoŋai zi pa ŋgar tau ughe ughamu. Yo usaav pazi ila tandaghiiŋ ughe: “Zaaba ariaaŋa ee ilepleep ila sosomim. Yau taug nasiigho ve naghuru imin kinik. Tauta nauule ve nagham eeza ivot imin tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Yau naghita besooŋa tsiau David, i irao. Tauta naliŋ ŋgoreeŋ tsiau patabuyaaŋ izala daaba, ve naghuru pa uraat. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","I pale ileep ila yau nimag, ve napaloti irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Tauvene koiŋa irau tiliivo mako, ve zeran sasaghati irau titatani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Pasaa, yau taug pale namuuŋ pani, ve natatan koiŋa le tapirizi isov. Yes tau tighur koi pani na, yau aat narav zi tisov timataar. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Yau aat nataghon saveeŋ mbuaaŋ tau nagham pani na, ve lolog isaghavu ariaaŋ, ve naghur poia tsiau izazaa tooni. Pale naleep tomania ve napaloti, leso tapiri ivot imin tiina ve iliiv koiŋa. Tauvene eeza pale imin tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Yau aat nagham eval tiina tileep ila i saamba. Yes tau tileep izi nari to Te Mediterenian, ve ila imuul yaa Euprates ziige. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","I pale isaav payau ighe: ‘Yau Tamaŋ yo. Yo ta Maaron tsiau, ve Uleeŋa tsiau ariaaŋa. Yo uponpoon ghau pa koiagŋa imin maet tiina.’ ");
INSERT INTO tuc_t_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ve yau pale naghamu imin natug aidaaba. Tauvene i pale eeza tiina kat le iliiv kinik tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Pale lolog isaghavu ariaaŋ ve nauule irau saawe. Ve saveeŋ tau nambua pani na, tauvene paam. Pale igheen ariaaŋ tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ziiri waaro tooni irau isov mako. Pale naŋgin paaghu tooni, ve tileep poi taghon taghon gha ila imin sambam saamba. Pale tileep ila David niia to ghamuuŋ pooz, ve tiŋgin yes Israela irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Eemon isaav ighe paaghu tooni tighur murizi pa saveeŋ tsiau, ve laghooŋ toozi isapir pa tutuuŋ tau naghuru na, ");
INSERT INTO tuc_t_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ma tivelegh tutuuŋ tsiau tau igheen pataghaaŋ na imin kaut sorok, ve timalaaŋ pa tutuuŋ tsiau ŋgara, ");
INSERT INTO tuc_t_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ene pale naŋgal matazi pa ŋgar toozi to zoraaŋ saveeŋ, ve nalos matin zi pa sosor toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","34","Eemon ŋgar tau lolog isaghav David ve paaghu tooni ve nauluul zi, ene irau napuli mako. Pale ighengheen tauvene taghon taghon gha ila. Ve saveeŋ tau nambua pani na, irau nareua mako. Saveeŋ tau ivot ila taug avog, ene irau natoora mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Pasaa, yau Maaron patabuyaaŋ. Tauvene saveeŋ mbuaaŋ tsiau tau napariaaŋa le iyaryaaŋ kat, ene pale igheen tauvene taghon taghon gha ila. Irau natombaan David mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Paaghu tooni irau tisov mako. Siŋ toozi pale iparseeŋ taghon taghon gha ila. Pale matag pazi ve pooz toozi iyaryaaŋ imin aaz, ve ighengheen tauvene. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Pooz toozi pale tuŋia irau saawe imin kaiyo. Kaiyo tau igheen ila sambam saamba, ene imin ilaal ighe saveeŋ mbuaaŋ tsiau tane, ene onoon.” ");
INSERT INTO tuc_t_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Yoova, muuŋ yo umbu saveeŋ ariaaŋa tauvene pa David ve paaghu tooni. Eemon aazne, atem yavyav kat pa kinik tsiei tau taum usiigho ve ughuru pa uraat na. Yo lolom pani muul mako, ve ughur murim pani kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Saveeŋ mbuaaŋ tau muuŋ ugham pa besooŋa tsio na, aazne yo ureua wa. Ve uzugh moghar ndamoonda tooni izi pa daaba, ve usiki ila ŋgaupup. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Didiiŋ ariaaŋa tau ilivutin nugh tooni na, yo ureu mbirisaini izi. Ve uvaghamunia ruum tooni ariaŋazi paam, le tisov timbiriis. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Tauvene tamtamon tisov tau tilala tilamlam na, tiyumyum gabua tooni. Ve yes nugh nugh tau tileep tigharauu na, tiveveleghi ve tighamgham ŋalalaŋ pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Yoova, yo taum upalot kinik tsiei koiŋa ve tiparav ariaaŋ le tiliivo. Tauta tisov lolozi poia ve tipakur zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Saawe tau kinik tsiei igham malmal, yo upaloti mako, ve upamuul mbuzaagh tooni maata imuul pa tauu. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Tauvene gabua tooni popoia tau i eeza tiina pani na, yo uwalaav zi pani, ve ureu niia to ghamuuŋ pooz izi taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","I ŋeer paaghu. Eemon yo ugham koiŋa tiliivo, tauta igharaat tauu mako ve ipul tauu. Taghita imin kooŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O Yoova, pale ŋeez o matam ilam payei muul? Mindai, pale uŋgooz naghom payei, ve aatyavyav tsio izazaa tsiei taghon taghon gha ila? ");
INSERT INTO tuc_t_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yoova, matam iŋgal: Yei tamtamon to taan nileep malau mako. Onoon, yo taum ughur ghei. Eemon, pale nisov nimataar nimin kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Sei irau imaat mako, ve ileep maata yaryaare taghon taghon gha ila? Ma sei irau ipasalia tauu pa mateegh? Eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Yoova, muuŋ yo umbu saveeŋ pa David ve upariaaŋa le iyaryaaŋ kat ughe yo pale lolom isaghavu ve uule irau saawe. Eemon aazne, poia tsio tana igheen sindei? Mindai ta utaghon saveeŋ mbuaaŋ tsio muul mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","O Yoova, yau besooŋa tsio. Matam iŋgal ghau ve uul ghau lak! Pa aazne, nugh nugh tipamayaŋin ghau, ve tivevelegh ghau le lolog isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yoova, yo taum usiigh ghau ve ughur ghau namin kinik. Ughita. Nugh sindei tau nala pani, ene koiamŋa tipaŋiŋizai ghau, ve tisiksik saveeŋ veleghiiŋ payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Tapait Yoova pa poia tooni irau saawe. Onoon le onoon kat! ");
INSERT INTO tuc_t_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Suŋuuŋ to Mose, i Maaron tamtamon tooni O Tiina, muuŋ ve ilam, yo umin niamai to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Yo Maaron tau uleep irau saawe. Muuŋ geeg, saawe tau ugham taan ve loloz tivot soone, yo ulepleep. Ve yo pale ulepleep tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Yo ugham yei tamtamon to nimaat nimin ŋgaupup. Yo usaav payei ughe yei aat nimaat ve nizila nimin taan muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Yo ughita ughe ndaman ndiŋndiŋ ndiŋndiŋ ee (1,000), ene saawe tuuku mon. Ila ŋgar tsio, ene imin noor ve ilam aazne. Ve imin saawe tuuku to mboŋ tau yes zaaba tiyooz, ve timamaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","6","Yo upasov lepoghamai, imin tamtamon igheen ve iviv, ve isov. Yei nimin manman tau ighe aaz izaa, ene ruuŋgu iravalagh ve ghitooŋa poia. Ve ighe ravrav izi, ene imalai ve itap. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Aatyavyav tsio, ene ipapasov ghei. Lolom basbasuuŋ pa sosor tsiei ve ughurghur atuya payei. Tauta roiŋ tiina igham ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Pasaa, ŋgar tsiei isov tau isapir pa ŋgar tsio, ene yo matam kisin zi. Sosor tsiei tau ŋgozaaŋ na, tisov tigheen ghazooŋa ila yo matam. Eta iyooŋ mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Tauvene saawe isov tau nileep izi taan ne, aatyavyav tsio izazaa tsiei. Tauta nileep saawe tuuku mon, mako yaghuramai isov, ve nimaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nileep irau ndaman tamoot tol saŋavul (70) mon, ve nimaat. Ve ighe tapirimai irao, o nileep irau ndaman tamoot paaŋ (80) ma vene. Ve ndaman tsiei ta naol ne, niravrav ghei pa uraat, ve nibadbaad pataŋani. Saawe saghati, ve saawe poia paam. Nighamgham tauvene ila le rekia mon nizaa pa saawe tsiei, mako nisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Maaron, sei ighilaal katin aatyavyav tsio tapiri? Aatyavyav tsio tau iŋaŋarui ghei ne, sei ighazooŋ pani, leso iroi payo ve itaghon aliŋam? Eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Tauvene ugham ghei nighilaal nighe lepoogh tsiei to taan, ene tuuku kat. Leso ŋgar tsiei ivot, ve nighilaal eez to nileep poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Yoova, ŋeez o utoor ŋgar tsio ve matam ilam payei muul? Lolom isaghatin ghei ve uul ghei. Pa yei besooŋa tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Mboŋoozo ta naol ne, nighe upavon ghei pa poia tsio, ve utotoi ŋgar tsio tau lolom isaghav tamtamon tsio ve uluul zi. Leso lolomai poia ve tintinmai, ve nimboumbou ila le saawe tsiei isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ugham saawe poia ivot. Leso lolomai poia, ve iyat ndaman katini tau ughurghur pataŋani payei ve nileep saghat na. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Yei besooŋa tsio nighe nighit ghom ugham uraat tintiina tivot muul. Ve paaghu tsiei tau pale tivot murei na paam, nighe utotoi tapirim pazi tomania poia tsio tau ezam tiina pani na, ve tighita. ");
INSERT INTO tuc_t_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Yoova, yo Maaron tsiei. Lolom poia payei ve ughur poia tsio izaa tsiei. Leso uraat tau nighamghamu pa nimamai ne ilaan poia. Upalot uraat tsiei. Leso ighur anooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Ighe tamtamon eta iyooŋ ila to Maaron Ariaŋa Tau Iliiv Zimaronŋa Tisov na, i pale ileep poi ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","I irau isaav pa Yoova ighe: “Maaron tsiau, yau nanumeer ghom. Yoova, yo umin niag to yoŋgaaŋ, ve uponpoon ghau pa koiagŋa imin didiiŋ ariaaŋa.” ");
INSERT INTO tuc_t_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Onoon kat, i pale ipasalia aghem pa liis tau koiamŋa tighuru payo. Ve ipaghau moroghooŋ saghati payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","I pale iŋgin ghom ila niima saamba imin tatareek ipagud natŋa ila baage saamba. Yes tau tiyooŋ ila tooni na, pale tileep poi. Pasaa, i itataghon saveeŋ mbuaaŋ tooni. Ŋgar tana pale imin sigheu payo, ve ipoon ghom pa gabua sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Tauvene yo irau uroi pa gabua sasaghati to mboŋ mako. Ve mataaz paam, irau uroi pa koiamŋa paneegh toozi natŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Tauvene moroghooŋ sasaghati tau ighamgham tamtamon pa mboŋ, ve pataŋani tau iravrav zi pa mataaz na, yo irau uroi pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Isaav ighe tamtamon ndiŋndiŋ ndiŋndiŋ ee (1,000) timatmaat ve titaptap ila zigem, ma tamtamon ndiŋndiŋ ndiŋndiŋ saŋavul (10,000) tau tilivut ghom na timataar, na uroi sov. Pa gabua saghati eta irau ilam igharau ghom mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Atuya tau izaa to zeran sasaghati na, yo pale ulepleep, ve ughit katini pa taum matam. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Pasaa, yo uyoŋyooŋ ila to Yoova, ve i imin niam to lepoogh. Maaron Tiina Tau Iliiv Zimaronŋa Tisov na iŋginŋgin ghom, tauta uleep poi ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Tauvene gabua saghati eta irau ivaghamun ghom mako, ve moroghooŋ saghati eta irau igharau niam to lepoogh mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Pasaa, Maaron pale imbaaŋ aŋela tooni to tiŋgin ghom. Nugh sindei tau ighe yo ula pani, yes pale matazi payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Yes pale tikis ghom pa nimazi, ve tipalot ghom. Leso utut aghem ila maet sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Isaav ighe utut laion paaghu, ma uvaghaaz moot saghati eta, ene irau tigham gabua eta payo mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Pasaa, Yoova isaav ighe: “Yes tau lolozi isaghav ghau ve titaghon eez tsiau na, yau aat napas zi tivot pa pataŋani toozi. Ve yau aat naghur zi tizala saaŋa ve matag pazi. Leso gabua eta ivaghamun zi sov. Pasaa, yes tiwatagh ghau, ve lolozi igheen ilam tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Isaav ighe titaŋ rarai ghau, yau aat nalooŋ zi. Saawe tau tileep ila pataŋani loolo, yau aat naleep tomani zi. Pale nauul zi, ve napakur zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Yau pale naseeŋ saawe toozi ila malau, leso tileep toman lolozi poia. Ve natotoi uleeŋ tsiau ivot ighazooŋ pazi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Mbouŋ to umbom patabuyaaŋ Yoova, yo Maaron Tau Uliiv Zimaronŋa Tisov. Isaav ighe yau napakur ghom pa poia tsio, ve nambou to napait ezam, ene igham lolog poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Mboŋoozo ta naol ne, navovotia ŋgar tsio tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi. Ve mboŋ, yau navovotia gabuam tau utataghon saveeŋ mbuaaŋ tsio. Ŋgar tauvene igham lolog poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Yau naravrav gita ve kulele, ve namboumbou to napakur ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Pasaa, Yoova, uraat tsio igham lolog poia kat. Matag ilala pa gabua naol tau nimam igharaat zi na, ve nambou toman tintinig. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yoova, uraat tau yo ughamgham zi, ene tintiina kat. Ve ŋgar tsio paam, puughu ariaaŋa. Ila le ila kat. Tauvene nagham ŋgar pani, eemon narao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Eemon yes kankanooŋa tighilaal mako. Ŋgar toozi imin borauŋa. Tauta pataŋani tau pale ivot pa zeran sasaghati na, yes tigham ŋgar pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Onoon, aazne, zeran sasaghati tivot timin naol imin oot sasaghati tau isaas le itav taan. Ve yes tau tinoknok ghamuuŋ sosor na, taghita taghe lepoogh toozi, ene poia kat. Eemon murei, yo pale upasov zi, le tisov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","O Yoova, yo uleep saaŋa, ve ughamgham pooz irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Onoon kat, koiamŋa tau tighamgham ŋgar saghati na, yo pale ureu mbirisai zi gha tisov tilalez. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Eemon yau, yo upakur ghau, ve ugham tapirig ivot tiina imin makau sagsag. Ve poia tsio izazaa tsiau, imin tiliŋ ŋgoreeŋ poia izala pavog. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Yo utatan koiagŋa ve naghit katin saghatiiŋ toozi. Yo uvaghamunia zeran sasaghatizi tawe, ve nalooŋ katin taŋiiz toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Eemon zeran duduŋazi pale tileep poia, ve ŋgar popoia katini ivotvot ila sosozi imin niu tau irav kat. Ve irau tisaghat mako. Pale tiyooz tuŋia ve tileep malau, imin ai mezepur tintiina to Lebanon. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Yes timin ai tau tivazogh zi ila rumei patabuyaaŋ to Yoova ziige. Pale tileep poia iloŋ ila Maaron toit rumei tooni sirsiira. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Ve saawe tau timin zikooŋ, tapirizi ighengheen soone, ve tighamgham ŋgar popoia ivotvot, imin ai paghpaaghu tau anoŋazi katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Ve tivovotia saveeŋ tauvene tighe: “Yoova iponpoon ghau imin maetaaz tau izala kat. Sosor eta igheen tooni mako. Ŋgar tooni isov, ene iduduuŋ mon.” ");
INSERT INTO tuc_t_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yoova, i kinik tiina tau ighamgham pooz pa gabua naol isov. Mbonari tomania tapiri, tauta ilivuti imin nonoghiiŋa tooni. Muuŋ geeg, i ighur taan le puughu iyaryaaŋ kat. Tauta gabua eta irau izuure mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Yoova, muuŋ geeg, saawe tau ughur gabua eta ivot soone, yo uleep pataghaaŋ wa. Saawe tawe ve ilam, pooz tsio igheen ariaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yoova, te iburig toman tapiri ighe ireu nugh, ve luutu tiina imin lalaav. Dibom ipol ve ighel taan toman luutu tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Eemon Yoova, yo saksakim. Yo uleep saaŋa, ve ughamgham pooz pa gabua naol isov. Te tau luutu tiina imin lalaav na, yo tapirim iliivo. Ve dibom tauvene paam, tapirim iliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","O Yoova, eez tau yo ughuru pa tamtamon tsio leso yamŋa avalupu gham amin eemon, ene igheen tuŋia tauvene irau saawe. Irau utoora mako. Ŋgar patabuyaaŋ pale ipabood rumei tsio taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O Yoova, yo Maaron tau uyatyat ŋgar saghati to tamtamon. Utotoi ŋgar tsio duduuŋa ivot ighazooŋ, ve ughur atuya pa zeran sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Pa yo ta ugagabiiz tamtamon tisov to taan ve ughurghur atuya pazi. Tauvene uburig gha ughur atuya iŋarui yes tau tipapakur tauzi na. Upamuul ŋgar toozi sasaghati imuul ila pa tauzi, o iduduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O Yoova, zeran sasaghati tighamgham tinizi, ve lolozi poia pa ŋgar tau tighamghamu we. Pale ŋeez o upasov ŋgar toozi tawe? ");
INSERT INTO tuc_t_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Yes tau tighamgham ŋgar saghati na, saveeŋ pakuruuŋ naol ivotvot ila avozi. Aliŋazi izazaa, ve tipapait tauzi pa ŋgar toozi tighe yes tirao. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yoova, ughita. Yes tighamgham saghatin tamtamon tsio. Yes tau yo ugham zi timin lem na, zeran tawe tighamgham pataŋani tiina pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Ve tiravrav zinaara ve yes parooŋa timatmaat. Ve loomba tau tileep tomani ghei izi nugh tsiei ne, tirav zi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Ve matazi veleghin ghom tighe: “Ah, Yoova ighit ghiit? Ŋgar tau taghamghamu ne, Maaron to Yakop irau maata ila pani mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Yam zeran sasaghatmim, lemim ŋgar mako imin borauŋa! Pale ŋeez o ŋgar tsiam ivot ve aghilaal? ");
INSERT INTO tuc_t_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Maaron ta igharaat taliŋamim. Irau ilooŋ saveeŋ tsiam mako? Ve i ta igharaat matamim. Irau ighit gham mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","I ighurghur pataŋani pa tamtamon to nughmariŋ, leso ipaduduuŋ zi. Pale ighurghur gham? Ve i ta ighamgham tamtamon lezi ŋgar. Mindai, aghe i le ŋgar mako? ");
INSERT INTO tuc_t_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Ŋgar naol tau igheen ila iit tamtamon loloon na, Yoova iwataghiir zi tisov. Ve i iwatagh: Ŋgar toit katini, pale anooŋa mako. Ene isov rekia mon imin yaghuraan tau ivotvot ila avoon. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yoova, tamtamon tau ighe yo ughur pataŋani pani to upaduduuŋa, ve upaghazoŋaini pa tutuuŋ tsio, ene aat poia tsio tau izaa tooni, ve loolo poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Tamtamon tauvene, isaav ighe ileep ila pataŋani, yo pale uule. Leso aate izi, ve isasaŋan le irau titai puura pa yes zeran sasaghati ve titap tizila. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Yoova irau ighur muuri pa tamtamon tooni ne mako. Yes tau i igham zi timin le na, loolo iveghai zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ve i pale ipaduduuŋ yes pooza, leso tigharaat pataŋani to tamtamon itaghon ŋgar duduuŋa. Ve tamtamon tisov tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na, yes pale tipalot ŋgar tauvene paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Isaav ighe tamtamon tigham saghatin ghau, sei pale iyooz payau ve iuul ghau? Ve sei ta iponpoon ghau pa zeran sasaghatizi? Ite paam mako. Yoova mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Imin ta Yoova iuul ghau mako, kanaŋ namaat rekia mon gha nala nugh tau le oroora mako na. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Yoova, saawe tau naghe pale natap pa ghuruuŋ ila tsiau, ŋgar tsio tau lolom isaghav tamtamon tsio ariaaŋ ve uluul zi na, tauta ipalot ghau gha nayooz tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Ve saawe tau lolog ipataŋan ve nagham ŋgar naol, yo urav ateg, ve ugham lolog poia muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Yes pooza sasaghati tau tighurghur tutuuŋ naol to tivaghamunia tamtamon na, yo irau upaak zi pa ŋgar toozi tawe mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Yes tilup zi ve timbu saveeŋ to tivaghamunia zeran duduŋazi. Ve yes tau lezi sosor mako na, yes pooza tawe tighur saveeŋ tighe yes aat timaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Eemon Yoova, i imin didiiŋ ariaaŋa payau, leso nayooŋ ila. Maaron tsiau iponpoon ghau imin maetaaz tau izala kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","I pale ipamuul ŋgar sasaghati to zeran tawe imuul pa tauzi ve ivaghamun zi. I pale ipasov zi tomania ŋgar toozi sasaghati tawe. Yoova tau Maaron toit, pale ipasov zi le tisov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Alam tambou ve tapakur Yoova. Tintiniin, ve tayoor eeza. Pa i Uleeŋa toit ariaaŋa tau iponpoon ghiit pa koiaanŋa imin maet tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Alam tala tayooz ila naagho, ve tapakuru pa poia tooni. Aliŋaan izaa, ve tambou toman tintiniin, ve tapaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Pasaa, Yoova, i Maaron tiina. I kinik tiina kat tau iliiv zimaronŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Gabua naol isov to taan tigheen ila i niima. Taan puughu ta siiŋa we, le izala loloz daaba paam, ene i iŋginiir zi tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Te tomania taan, ene gabua tooni mon. Pasaa, i niima ta ighur zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yam alam talup ghiit ve tasuŋ pa Yoova. Tatud pani ve taput agheen ve tapakuru. Pasaa, i ta ighur ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","I Maaron toit, ve iit sipsip tooni. I iŋginŋgin ghiit ve maata pait. Taleep ila i niima, ve i tauu ipanpan ghiit. Aazne, ighe yam alooŋ Yoova aliiŋa ve ataghoni, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","I isaav payam ighe: “Apoon lolomim payau ve agham taliiŋzizi imin muuŋ timbumimŋa tighamu izi nugh ŋginaaŋa to Meriba ve Masa na sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Saawe tana, yau nagham uraat tintiina ila sosozi, ve tighita pa tauzi matazi wa. Eemon tighur ilam tsiau mako. Ve tinoknok tovaaŋ ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Tauta lolog pazi mako kat irau ndaman tamoot ru. Ve nasaav naghe: ‘Zeran tawe, lolozi pa titaghon ŋgar tsiau mako. Monmon tisosor pa eez tsiau.’ ");
INSERT INTO tuc_t_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Tauta nasaav ariaaŋ pazi toman ateg yavyav, ve napariaaŋ saveeŋ tsiau naghe: ‘Onoon kat. Nugh to mariaoŋ tau yau naghuru pazi na, yes irau tiloŋ tila mako le mako kat!’” ");
INSERT INTO tuc_t_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Ambou mbouŋ paaghu pa Yoova! Yam tamtamon tau aleep irau taan na, ambou pa Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Ambou mbouŋ pani, ve apait eeza pa poia tooni. Uraat tintiina tau i ighamgham zi to iuul ghiit na, saawe isov asasavi zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Avotia eeza tiina tomania tapiri ve poia tooni irau nugh naol isov. Ve uraat tooni ŋgeretazi tau maata ite na, asavi zi ila irau nughmariŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Pasaa, Yoova, i eeza tiina kat. Tauvene iit aat tapait vaaru le tapaiti kat, ve taroi pani iliiv zimaronŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Pasaa, zimaronŋa tisov tau nugh nugh tibesbees pazi na, ene maaron karomŋa mon. Ve Yoova, i Maaron tauu ta ighur sambam tomania gabua naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","I eeza tiina kat ve mbonari ilivuti. Tapiri ve poia tooni ipavon rumei tooni loolo, ve ipaboode le paghuuna kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Tauvene yam tamtamon to nughmariŋ, ŋgar tsiam ivot ve aghilaal Yoova! Ŋgar tsiam pakia ve apakuru. Pa i le eeza, ve tapiri tiina kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","I eeza tiina le tiina kat. Tauvene yam apaiti, o iduduuŋ. Alam tomania paitooŋ tsiam, ve aloŋ ala sirsiir to rumei tooni loolo. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Yoova ipabood tauu pa ŋgar tooni patabuyaaŋ. Tauvene aput aghemim pani ve apaiti. Yam tamtamon to taan, asov aroi pani, ve atatan taumim ila naagho. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Asaav pa nughmariŋ aghe: “Yoova, i kinik tiina tau iŋgin gabua naol isov! Muuŋ, i ighur taan le puughu iyaryaaŋ kat. Tauta gabua eta irau izuure mako. I pale igabiiz nughmariŋ, ve ighur atuya pazi. Ve gabizooŋ tooni, ene iduduuŋ mon.” ");
INSERT INTO tuc_t_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Yam gabua to sambam ve taan, lolomim poia ve tintinmim. Ve te tomania gabua naol isov tau tileep ila loolo na paam, aliŋamim izaa tiina ve apait Yoova. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Ve uum tomania gabua naol isov tau titum ila loolo na, lolomim poia ve tintinmim. Ve ai tomania gabua naol isov to su loolo paam, aliŋamim izaa, ve ayoor Yoova eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Pasaa, i ighe ilam. Leso igabiiz tamtamon tisov to taan ve ighur atuya pazi. I pale iŋgin tamtamon tisov to taan, ve igabiiz zi. Ve gabizooŋ tooni, ene iduduuŋ ve onoon mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yoova, i kinik tiina tau iŋgin gabua naol isov. Tauvene yam tamtamon tau aleep irau taan na, lolomim poia. Ve yam sisia tauvene paam, tintinmim. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","I iŋgozŋgooz tauu ila taitai gabgabuai, ve ndoroom ikaui. Ŋgar duduuŋa tomania ŋgar to uleeŋ, tauta imin puughu pa pooz tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","I igham yav ighan imuuŋ pani, ve ighaniir koiŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","I igham nugh ighani milmilia irau taan. Tauvene taan ighita, le irur. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yoova, i tiina tau iŋgin taan isov. Saawe tau i ilam ve itotoi tapiri, loloz tisov tireer ve timbiriis ila i naagho. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Gabua naol tau tighenaar ila sambam saamba na, tipaghazoŋai Yoova tighe ŋgar tooni iduduuŋ mon. Nughmariŋ tighita gabua tawe, ve tighilaal tighe Yoova, i eeza tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Tamtamon tisov tau tibesbees pa maaron karomŋa anunuzi na, Yoova igham zi mayazi. Pasaa, maaron karomŋa toozi tirau gabua eta mako. Maaron toozi tawe pale tisov tiput aghezi pa Yoova ve tipakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Maaron, yes to Zion tilooŋ varum pa uraat tau yo ughamghamu na, le lolozi poia. Ve nugh nugh to Yuda paam, tisov tintinizi. Pasaa, yo uyozyooz pa tamtamon tsio, ve uluul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Yoova, yo Maaron Tiina. Tamtamon tisov to taan tileep ila yo sambam. Yo ezam tiina le tiina kat. Uliiv zimaronŋa tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yoova loolo pa yes tau tighurghur koi pa ŋgar saghati. Tamtamon tooni tau lolozi isaghavu ariaaŋ, ve titaghon eez tooni na, i imin sigheu pazi, leso gabua eta ivaghamun zi sov. Ve ighamgham mulin zi ila zeran sasaghati nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","I ighurghur ghazooŋa pa zeran duduŋazi. Yes tau ŋgar duduuŋa igheen ariaaŋ ila lolozi na, i igham zi lolozi poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Yam zeran duduŋamim, tintinmim pa Yoova! Apaiti pa poia tooni, ve apakur eeza patabuyaaŋ! ");
INSERT INTO tuc_t_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Ambou mbouŋ paaghu pa Yoova! Pa gabua ŋgeretazi tau i ighamgham zi na, maata ite kat. Niima tapir iparav ariaaŋ le iliiv koiŋa wa. I itotoi tapiri patabuyaaŋ, ve igham mulin tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yoova ivotia uleeŋ tiina tau i igham pa tamtamon tooni. I itotoi ŋgar tooni duduuŋa ila nughmariŋ matazi gha tighit katini wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Saveeŋ tau i imbua tomania yes Israela na, i maata iŋgalŋgali ve itataghoni. Tauta loolo isaghav zi ariaaŋ ve iuluul zi. Maaron toit iparav ariaaŋ gha igham mulin ghiit ila nughmariŋ matazi, ve tighita wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Yam nughmariŋ asov lolomim poia pa Yoova ve ayoor eeza. Tintinmim pani, ve ait mbouŋ to apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Arav ambam tomania gita, ve ambou to apait Yoova! Arav ambam tomania gita le luutu poia, ve apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Yoova, i kinik tiina. Aviv tavuur tomania trampet ila naagho, ve ayoor eeza toman tintinmim. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Te tomania gabua naol isov tau aleep ila loolo na, aliŋamim izaa ve apait Yoova! Ve taan tomania tamtamona ve gabua naol isov tau aleep ila na paam. Aliŋamim izaa ve apaiti! ");
INSERT INTO tuc_t_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Ve yaa paam, asov aposai nimamim pani ve apakuru. Ve yam loloz asov alup avomim, ve ambou toman lolomim poia izi Yoova naagho, ve ayoor eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Pa i ighe ilam. Leso igabiiz tamtamon tisov to taan ve ighur atuya pazi. I pale igabiiz nughmariŋ to taan. Ve gabizooŋ tooni, ene iduduuŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yoova, i kinik tiina tau iŋgin gabua naol isov. Yam nughmariŋ asov aroi pani ve tinimim irur. I ileep ila niia to ghamuuŋ pooz tau igheen izala aŋela ariaŋazi avarazi na. Tapiri igham taan irur ve ilala ilamlam imin yogyoog itoktok. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yoova ilepleep izi nugh tooni Zion. Eeza tomania tapiri, ene tiina kat. Nughmariŋ tisov tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Yoova, yo ezam tiina, ve tapirim paam, tiina kat. Ve yo patabuyaaŋ. Tauta tamtamon tisov aat tiroi payo ve tipait ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Yo kinik saksakim ve ariaŋam, ve lolom pa ŋgar duduuŋa kat. Yo ta umin puughu pa ŋgar duduuŋa. Yo upapalot ŋgar duduuŋa, le igheen ariaaŋ ila yes Israela sosozi, ve uluul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Tapait Yoova, i Maaron toit. Tala taput agheen ila niia to ghamuuŋ pooz naagho ve tapakuru. Pa i patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Muuŋ, Mose gha Aron timin zeran to watooŋrau. Yes tau titaŋ rarai Maaron pa uleeŋ na, propet Samuel, i toozi ee paam. Ve Yoova ilooŋ suŋuuŋ toozi, ve iuul yes Israela. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Saawe tau yes Israela tilaghlaagh izi nugh ŋginaaŋa, Yoova ileep ila taitai loolo, ve isavsaav pazi. I ighur tutuuŋ pazi, leso yesŋa tivalupu zi timin eemon. Ve matazi kisin tutuuŋ tawe tomania tutuuŋ siriv tau i igham pazi na, ve titaghon zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yoova, yo Maaron tsiei. Yo uloŋlooŋ suŋuuŋ to tamtamon tsio, ve upulpul sosor toozi. Eemon ughurghur atuya pa sosor toozi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Tapait Yoova, i Maaron toit. Taput agheen pani izi loloz tooni patabuyaaŋ, ve tapakuru. Pasaa, Maaron toit Yoova, i patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Mbouŋ to tapait Maaron pa poia tooni Yam tamtamon to aleep irau taan isov, tintinmim pa Yoova, ve apaiti toman aliŋamim tiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Abesbees pani toman lolomim poia. Alam alup gham ila i naagho, ve amboumbou pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Lolomim iveegh pa Yoova sov. Aghilaal aghe: I mon ta Maaron tauu. I ta ighur ghiit, ve iit tamtamon tooni. Iit sipsip tooni. Tauta maata pait ve iŋginŋgin ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Lolomim poia pani ve ataghon ataman to Rumei Tiina gha aloŋ ala. Apaiti ve aloŋ ala sirsiir tooni loolo. Lolomim poia pani ve apakur eeza pa poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Pasaa, Yoova, ŋgar tooni poia mon. I loolo isaghav tamtamon tooni ariaaŋ, ve iuluul zi irau saawe. Ve itataghon saveeŋ mbuaaŋ tooni, taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Mbouŋ to David O Yoova, yau nambou mbouŋ tane to napait ghom. Pasaa, yo utaghon ŋgar duduuŋa mon. Ve lolom isaghav tamtamon tsio, ve uluul zi itaghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Yau naghe le ŋgar tsiau isov iduduuŋ mon ila yo matam. Tauvene yau aat nataghon ŋgar duduuŋa mon ila ruum tsiau, ve nagham pooz pa tamtamon tsiau itaghon ŋgar duduuŋa tsio. Ve ŋeez o ulam uul ghau? ");
INSERT INTO tuc_t_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Yau irau nayok pa gabua saghati eta igheen ila naghog mako. Ve yes tau tisosor pa eez tsio na, yau naghurghur koi pazi ve nazirziir zi tighaughau. Irau tipaak ghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Yau aat naleep soghan pa ŋgar karom. Ŋgar tauvene, eta irau igheen tsiau mako. Ve ŋgar saghati tauvene paam, irau matag ila pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Yes tau tiŋgalŋgal saveeŋ pa zetazŋa imin ŋgozaaŋ na, yau aat navaghamun zi, leso napoon avozi. Ve yes tau tipakur tauzi tighe ezazi tintiina, ve tivelegh zetazŋa ve titatan zi, ene irau napul zi tileep mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Eemon taan tane tamtamona tau avozi onoon ve titaghon eez tsio na, yau nailiil zi naghe tilam tileep tomani ghau. Ve yes tau laghooŋ toozi iduduuŋ mon, ene pale nagham zi timin besooŋa tsiau, ve tiuul ghau pa uraat. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Eemon zeran karomŋa irau tileep tomani ghau ila ruum tsiau ne mako. Isaav ighe ŋeer eta aavo karom, ene irau iyooz ila yau naghog mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Mboŋoozo ta naol ne, yau aat navaghamunia tamtamon sasaghatizi tisov tau tileep izi taan tane. Yes tau tighamgham ŋgar saghati, ene aat naziir zi tighau pa Yoova nugh tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Ene suŋuuŋ to ŋeer tau ibaad pataŋani tiina le tapiri isov kat. Tauvene isavia loolo ve itaŋ rarai Maaron to iuule O Yoova, taŋiiz tsiau ilat payo. Ulooŋ suŋuuŋ tsiau tane ve uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Uŋgooz naghom payau sov. Pa yau naleep ila pataŋani tiina loolo. Ighe poiŋ tsiau ilat, na ughur taliŋam payau. Ulooŋ suŋuuŋ tsiau ve rekia mon uul ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Paita namaat tane. Lepoogh tsiau, ene imin yav mbuasa tau imbuŋ izaa, ve imbiriis gha ilale. Tinig ituntun kat, ve tuag isov iparyavyav. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Yau namin kikiliiŋ tau tamtamon tivaghaaza gha igorgor. Tauvene lolog pa ghaniiŋ aniiŋ muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Yau nayamaan yavyavuuŋ ve nayak tiina. Ve nakoŋkoŋ le nakoŋkoŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Yau naghita naghe zigau kat. Yau namin man to mboŋ tau zigani ileep izi nugh ŋginaaŋa, ma ileep izi nugh tau muuŋ tamtamon tilepleep pani ve tipuli gha isaghat na. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Yau irau nagheen mako. Namamaat le nughizau. Yau raa zigau kat. Namin man ta zigani ileep izala ruum paavo. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Saawe isov, mboŋoozo ila le ravrav izi, koiagŋa tisiksik saveeŋ veleghiiŋ payau ve tiŋiŋiŋ payau. Ve isaav ighe tighur saghatiiŋ pa tamtamon eta, ene tiwatwaat sorokin yau ezag tighe: Pataŋani tau igham ghau ne, ene pale igham tamtamon tana paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Yo atem yavyav payau kat. Tauta usik ghau nala ziige imin pen. Avav imin leg aniiŋ, ve matag suuru imin leg yaa to ghunuuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Lepoogh tsiau to taan, ene imin aaz izila ve yavyaava ilam. Tapirig isov imin kikiliiŋ tau raua imalai ve igorgor. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Eemon Yoova, yo kinik tau ulepleep ila niam to ghamuuŋ pooz. Muuŋ, aazne, ve taghon gha ila. Tauvene tamtamon paaghu tau murei pale tivot na, yes pale tiwatagh tighe ezam tiina ighengheen tauvene, taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Yo lolom isaghatin nugh tsio Zion. Tauvene yo pale uburig ve uule. Pasaa, saawe to ughur poia tsio izaa tooni, tauta ivot wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Onoon, tireu mbirisai nugh Zion gha gabua naol isov imbiriis ilale wa. Maet popoiazi tau tirau ruum pani na, ene tisik zi tila soghan soghan imin gabua sorok. Eemon besooŋa tsio lolozi pa nugh tawe kat. Tauta tighita gabua tana, le lolozi isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","16","Eemon murei, Yoova pale igharaat mulin nugh Zion, ve itotoi tauu tomania tapiri ve poia tooni ivot ighazooŋ. Mako yes to nugh nugh tomania kinik toz toz tighilaal tighe Yoova eeza tiina pa tapiri ve poia tooni, ve tiroi pani, ve tileep ila i saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Tamtamon tooni tau tileep sorok kat na, i irau imbuzir pa taŋiiz toozi ne mako. I pale ilooŋ suŋuuŋ toozi ve iuul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Gabua tau Yoova ighamu na, uboode ila rau. Leso tamtamon tooni tau murei pale tivot na, tiwataghi ve tipait eeza. Ubood saveeŋ tauvene: ");
INSERT INTO tuc_t_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Yoova ilepleep izi nugh tooni patabuyaaŋ, ve maata ilala ilamlam. I ileep izi sambam, ve maata izizi pa taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Tauvene yes tau tileep ila koiazŋa nimazi ve tiyakyak na, i iloŋlooŋ taŋiiz toozi ve iuluul zi. Ve yes tau tisaŋan saawe to koiazŋa tirav zi timaat na, i ipaghau zi pa mateegh. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Leso murei, yes nugh nugh tomania kinik toz toz tilam tilup zi pa suŋuuŋ izi Yerusalem, ve tivotia Yoova vaaru. Yes pale tipait eeza izi loloz tooni Zion. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Yau namin olman kat soone. Eemon aazne Yoova igham ghau tapirig isov, ve iŋgoor saawe tsiau tuuku. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Tauvene nasaav pani naghe: “Maaron tsiau, ugham ghau rekia sov. Pa namin kooŋ soone! Ve yo, o lepoogh tsio ighengheen tauvene taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Yoova, muuŋ geeg, yo ugharaat taan puughu le tuŋia. Ve sambam saamba paam, ene nimam muuri. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","27","Eemon murei, sambam saamba ve taan pale tisaghat gha tilalez, imin uuli muŋgaana tau perekperekia na. Tauvene yo pale usik zi tilalez, ve uyol zi pa sambam saamba paaghu ve taan paaghu. Eemon yo ulepleep tauvene. Utortoor gabuam ve ŋgar tsio mako, ve saawe tsio irau isov mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Yei tau nibesbees payo ne, yo pale uŋgin natmaiŋa ve tileep poia. Ve paaghu toozi tau tivot murei na paam, yo pale ugham zi tiyooz ariaaŋ, ve tileep poia ila yo naghom irau saawe.” ");
INSERT INTO tuc_t_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Mbouŋ to David Yau nasaav pa taug naghe yau aat napait Yoova pa poia tooni. Onoon kat, ila lolog ve ŋgar tsiau isov, yau aat napakur Yoova eeza patabuyaaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Nayol aliŋag muul. Yau aat napait Yoova pa poia tooni. Ŋgar ve gabua popoiazi naol tau i ighamgham zi payau ne, irau lolog iveegh pa eta ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","I irewaar sosor tsiau, ve ipasovuur moroghooŋ tsiau naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","I igham mulin ghau pa mateegh. Tauta namaat mako. I igham ghau lolog poia kat imin tamtamon tau tighuru imin kinik. Pasaa, ŋgar tooni tau loolo isaghav tamtamon tooni ariaaŋ ve iuluul zi, ene i itotoia payau paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Lepoogh tsiau to taan, i ighamgham leg gabua popoiazi maata maata le narao kat. Ve igham ghau namin paaghu muul, le tapirig tiina imin manbog. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Ŋgar tau Yoova ighamghamu, ene iduduuŋ mon. Tauvene tamtamon tisov tau koiazŋa titatan zi ve tigham saghatin zi na, i iyozyooz pazi, ve iuluul zi pa pataŋani toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Muuŋ, Yoova ivotia gabua ve ŋgar tooni pa Mose. Ve itotoi uraat tintiina toman tapiri ila yes Israela matazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yoova loolo isasaghatin ghiit, ve ighamgham poghani ghiit. Irau aate yavyav rekrekia mako. Poia tooni, ene tiina kat. I loolo isaghav ghiit ariaaŋ, ve iuluul ghiit irau saawe. Ve monmon itaghon saveeŋ tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Onoon, pai siriv, i iŋgal mataan pa sosor toit. Eemon igham tauvene monmon mako. Ve irau ikis aatyavyav tooni le malau ne mako. Igheen rig, ve isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Onoon, isaav ighe tagham ŋgar tau isapir pa tutuuŋ tooni, ene Maaron irau iyat sosor toit ve ighur atuya pait. Eemon i ighamgham tauvene mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Yes tau tiroi pani ve titaghon ŋgar tooni na, Yoova loolo isaghav zi, ve poia tooni tiina izazaa toozi itaghon saveeŋ mbuaaŋ tooni. Loolo poia tana, ene tiina kat, imin sooso to taan ve izala pa sambam. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Ve sosor toit tau tazorzoor Maaron aliiŋa ne, ene Yoova ipaghau zi tila malau kat pait, irau sooso to taan ziige tau ila pa aaz izaa, ve ila pa aaz izila. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, i loolo isasaghatin zi, imin tamaanŋa lolozi isasaghatin ghiit. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Pasaa, i tauu ta igharaat ghiit. Tauta monmon maata iŋgalŋgal ighe: Iit tamin ŋgaupup mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Lepoogh to iit tamtamon to taan, ene malau mako. Taleep rig, ve talaleen imin kikiliiŋ. Iit tamin manman ruuŋgu. Mboŋoozo, isaav ighe aaz izaa, ene iravalagh. Ve ravrav izi, ene imalai. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Ve ighe yaghur ivuvuura, ene pale itap izi, ve niia ŋginaaŋa. Taghita muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","18","Eemon yes tau tiroi pa Yoova ve titaghon ŋgar tooni na, i loolo isaghav zi ve iuluul zi irau saawe. Aazne ve taghon taghon gha ila. Ve natuzŋa ve timbuzŋa paam. I itotoi ŋgar duduuŋa pazi ve iseeŋga taghon gha ila. Tauvene yes tau matazi kisin saveeŋ tau yesŋa Maaron timbua, ve matazi iŋgal tutuuŋ tooni ve titaghoni na, i pale loolo isaghav zi, ve iuul zi taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yoova ighur niia to ghamuuŋ pooz igheen tuŋia izi sambam. I kinik tau ighamgham pooz pa gabua naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Tauvene yam aŋela to Yoova, yam asov apaiti pa poia tooni. Yam aŋela ariaŋamim tau aloŋlooŋ Yoova aliiŋa ve atataghoni na, apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yam zaaba to sambam tau abesbees pa Maaron ve ataghon ŋgar tooni na, apait Yoova pa poia tooni! ");
INSERT INTO tuc_t_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Yam gabua to sambam ve taan tau Yoova igharaat gham ve aleep ila i saamba na, yam asov apaiti pa poia tooni. Ve yau paam, aat napait Yoova pa poia tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","2","Yau nasaav pa taug naghe yau aat napait Yoova pa poia tooni. O Yoova, Maaron tsiau, yo ezam tiina kat. Tapirim tiina tomania mbonarim, ve gabuam naol isov tau ezam tiina pani na, ene ipabood ghom imin nonoghiiŋa to yes kinik. Muuŋ geeg, yo ugharaat sambam saamba imin niam to lepoogh irau moogh balbaala tau tamtamon tiraraava leso tileep ila saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ve upayooz ruum tsio izala yaa tau igheen ila sambam saamba na paavo. Yo ugham taitai imin lem karis, leso uyooz izala paavo ve ughau. Tauvene yaghur ibaad ghom, ve ughaughau ila sambam saamba. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Yo ugham yaghur imin lem mbaŋooŋa. Ve yav yaama, ene imin lem besooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Muuŋ, yo ughur taan iyooz tuŋia ila puughu. Tauta irau izuur mako. Ighengheen tauvene. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Saawe tana, ugham te itav taan tomania loloz naol isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ra aliŋam izaa, ve uyaon te gha ighau. Aliŋam tapiri tiina imin lalaav luutu. Tauta te ilooŋ ghom, ve rekia mon ighau ila ilup ghi ila ziige ee, ve taan peria. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Tauvene te imaak, ve loloz peria, ve imaak izi izi le nugh rapazi peria paam. Tauta aazne, yaa ve te tigheen duduuŋ ila niazi niazi tau yo taum ughuru pazi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ve yo ughur ŋgat pa te ve taan. Leso te itav taan ve ireu nugh muul sov. Ŋgat tawe, te irau imalaaŋ pani mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Yo ugham yaa tivot ila taan puura tau tighenaar taghon loloz zigezi, ve tireer taghon sariipa tizila pa nugh duduŋazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Yaa tawe tighenaar, leso gabua naol to su tighun. Doŋki sagsagŋa paam. Isaav ighe murun zi, ene pale tighunu le isooŋ zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Man tirau rumazi ila ai tau tiyooz ila yaa zigezi na bogazi, ve tileep ila ve titaŋtaŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Yo uleep ila niam ta saaŋa we, ve ugham uman izizi ila loloz. Uraat tsio tana, tauta igham taan ŋgoreeŋa ivot ve gabua popoia naol titum poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Yo ugham kikiliiŋ itum, leso makau, sipsip ve gabua siriv paam tighan. Ve ughur gabua maata maata to iuul tamtamon paam. Leso tivazogh zi ve tigham uratoi zi. Yo ugham aniiŋ anooŋa ivotvot ila taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Ve ughur ai vaen, leso tamtamon tigharaata ve tighun suuru, ve igham zi lolozi poia. Ve ugham ai oliv pazi paam. Leso tigham ŋgoreeŋa, ve tisop tinizi ma naghozi pani, le milmilia. Ve ugham aniiŋ maata maata pazi, ve tighani to ipalot zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yoova, ai tsio mezepur tau uvazogh zi izi Lebanon na, yo uŋgin zi poi, ve ugham uman izizi pazi. Tauta aazne tizaa timin tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Ai tawe, man tirau rumazi izala bogazi. Ve man ŋgau, o tighagharaat rumazi ila ai tau imin yar na bogazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Loloz mamalaua dabazi, ene mekmek sagsagŋa niazi to lepoogh. Ve gabua siriv tau imin momot, ma uzuuv ma vene, ene tiyoŋyooŋ iloŋ ila maet tintiina sosozi izala loloz. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Yo ughur kaiyo to iŋgat saawe to ndaman. Ve aaz, ene iwatagh saawe sindei to izaa, ve saawe sindei to izila. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Yo ugham mboŋ izi le nugh ndoroom, leso gabua sagsagŋa to su tilaagh. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Tauvene laion paghpaaghu aliŋazi izazaa ve tilaghlaagh, ve tiliil lezi gabua to tighan. Ve Maaron tau igham pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Saawe tau aaz izaa, mako timuul tila pa niazi to ghenooŋ, ve tizi tigheen. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Mako tamtamon anazi tivot tila pa ghamuuŋ uraat. Tighamgham uraat ila ila le ravrav izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Yoova, yo ughur gabua maata maata. Ve gabua naol tau yo ugharaat zi na, titotoi ghom tighe ŋgar tsio tiina le tiina kat. Taan ivon kat pa gabua ndiŋndiŋ ndiŋndiŋ tau yo ugharaat zi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ve nagham ŋgar pa te paam. Ene tiina kat. Ve gabua ndiŋndiŋ ndiŋndiŋ tau matazi yaryaare na tileep ila. Siriv tintiina, ve siriv geegeu. Gabua tawe, tanin zi, ene aat tarao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Waaŋ tiravraav ila te paavo, ve Leviatan ilaghlaagh ila te loolo. Gabua tana, tiina le tiina kat. Muuŋ geeg, yo ugharaata, leso imomogheer ila te. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Gabua naol tawe tighurghur matazi payo to ugham lezi aniiŋ. Saawe tau pitool zi, yo taum upanpan zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Yes tilepaar ila yo nimam. Isaav ighe ugham aniiŋ pazi, yes pale tighamu. Ighe ukaak nimam to upan zi, ene pale tighan gabua popoia le apozi isuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ve isaav ighe uŋgooz naghom pazi, ene pale tiroi ve tivaghamgham. Ve isaav ighe upas avuvuzi ighau, ene pale timatmaat ve timin ŋgaupup muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Gabua naol tau tileep izi taan ne, yo uviv Avuvum ila pazi, tauta tileep matazi yaryaare. Ve saawe tau timaat, yo ugham paaghu toozi tivot izi taan, leso tigham niazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yoova eeza tiina aat igheen taghon taghon gha ila. Ve i loolo poia pa gabua naol tau i igharaat zi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","I tapiri tiina kat. Isaav ighe maata izi pa taan, ene pale taan irur. Ve isaav ighe itut loloz eta, ene pale yav ighan loloz tana. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Tauvene saawe tau naleep matag yaryaare, yau aat nambou mbouŋ to napait Yoova. Pale lolog poia pani, ve napakuru pa mbouŋ ila ila le lepoogh tsiau to taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Yoova igham ghau lolog poia kat. Tauvene saawe tau naleep ve naghamgham ŋgar pani, naghe i ighit ghau ve loolo poia pa ŋgar tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Eemon zeran sasaghatizi tau tighamgham sosor ila Yoova maata na, poia to i ipasov zi pa taan gha tilalez. Ve yau ene, nasaav pa taug naghe yau aat napait Yoova pa poia tooni. Aleluia! Tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Apait Yoova pa poia tooni, ve avotia eeza tiina. Asavia ŋgar tau i ighamghamu na irau nugh nugh, leso tiwataghi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ambou pani. Ambou ve apakuru. Avotia uraat tooni ŋgeretazi ta naol ne. Uraat tana, maata ite kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Yoova, i eeza patabuyaaŋ. Apaiti toman lolomim poia. Yes tau tizuari zi pani, ene pale lolozi poia kat ve tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Suŋuuŋ tsiam iŋarui Yoova. Leso ipalot gham pa tapiri. Azuari gham to ala aleep ila naagho irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Yam tau avot ila to Maaron besooŋa tooni Abaram, yam siŋ to Yakop tau Maaron isiigh gham amin i le na, matamim iŋgal gabua ŋgeretazi ve uraat tintiina tau Yoova ighamgham zi na. Uraat tooni tawe maata ite kat. Ve matamim iŋgal saawe naol tau i igabiiz tamtamon ve ighur atuya pazi na. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yoova, i mon ta Maaron toit. Uraat to gabizooŋ tamtamon ve ghuruuŋ atuya pazi, ene i itotoia irau taan isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","I monmon maata iŋgalŋgal saveeŋ mbuaaŋ tooni, ve itataghoni. Tutuuŋ tau Maaron isavia na, pale iyaryaaŋ tauvene, ve anooŋa ivotvot taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Muuŋ, i imbu saveeŋ tomania Abaram ighe yesuru tivalupu zi timin eemon. Ra ipariaaŋ saveeŋ mbuaaŋ tawe ila to Isak le iyaryaaŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","11","Murei, ra ipariaaŋ saveeŋ tana muul ila to Yakop, ighe saveeŋ tane aat iyaryaaŋ taghon taghon gha ila. Ve isaav pa Yakop ighe: “Yau pale nagham taan Kanaan imin lem. Taan tana pale imin yo yamŋa paaghu tsio lemim motot.” ");
INSERT INTO tuc_t_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Saawe tana, yes eval mako. Ŋgiira mon. Ve tileep timin loom pa taan tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Laghooŋ toozi, titaghon ŋgar tauvene: Tileep rig izi nugh ee, mako tiburig muul ve tila tileep izi nugh ite. Tila tivot nugh to kinik ee ve tileep tomani zi. Le isov, o tipul zi, ve tila tivot to kinik ite, ve tileep tomani zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","15","Laghooŋ toozi, ene Maaron tauu iŋginŋgini. I ipul tamtamon to nugh eta titatan zi ve tigham saghatin zi ne mako. I maata iŋgalŋgal zi, tauta iyaon kinik siriv ighe: “Yes tau nasiigh zi ve naghur zi timin uraata tsiau na, abugil zi sov! Pasaa, yes tana, yau naghur zi timin propet tsiau. Tauvene avaghamun zi sov.” ");
INSERT INTO tuc_t_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Murei, ra Yoova igham pitool tiina ivot izi taan Kanaan. Saawe tana, Yakop tomania natŋa lezi aniiŋ mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Eemon Yoova imbaaŋ toozi ee imuuŋ pazi ila Isip. Ene Yosep tau tigholia ila gha imin mbesooŋa sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Yes Isipa tizeeva iloŋ ila ruum to yavyavuuŋ, ve tikau aaghe pa sen, ve tighur ain liliita ila luua. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yoova itovtoov Yosep tauvene, le irau Yosep ivotia gabua siriv pa yes Isipa, le saveeŋ tooni anooŋa ivot. Tauvene saveeŋ tau Yoova isavia pani, ene ipaghazoŋai Yosep ighe i igham sosor mako, ve ŋgar tooni iduduuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Ra kinik to yes Isipa tau iŋgin nugh naol na, imbaaŋ ila ighe tipul Yosep ivot pa ruum to yavyavuuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Ve ighur Yosep imin daaba to Isip, ve ipuliir ruum tooni tomania gabua tooni naol isov ila i niima, leso iŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Tauta Yosep imin daaba pa yes tau tighamgham uraat pa kinik na. I ipaduduuŋ yes tau tiuluul kinik pa ŋgar na, ve ipaghazoŋai zi pa ŋgar poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Eez tane ta yes Israela tau siŋ to Yakop na tila tivot izi Isip, ve tileep timin loom ila taan to Ham. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yoova ipapalot zi, tauta tivot timin eval, le tapirizi iliiv koiazŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Ra i itoor ŋgar to yes Isipa, ve tighur koi pa tamtamon tooni. Tauvene tiil eez to titombaan besooŋa tooni ve tigham saghatin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Tauta Yoova imbaaŋ besooŋa tooni ru, Mose gha Aron, leso tiuul yes Israela. Aron tane, Yoova tauu ighuru to igham uraat tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Maaron ighe itotoi tapiri pa yes Isipa. Tauta ipalot Mose gha Aron, ve tigham gabua ŋgeretazi naol ve uraat tintiina ila yes Isipa sosozi. Uraat tau ivot izi taan to Ham, ene maata ite kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yoova igham ndoroom tiina ikau taan to yes Isipa. Pasaa, yes tizoor aliiŋa, ve tiŋguruut tamtamon tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ve i itoor yaa toozi isov imin siŋ, le iigh tisov timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Ra igham gob ndiŋndiŋ ndiŋndiŋ tivot le taan toozi ivon pazi. Ruum loolo to kinik tauu, ene ivon pa gob paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Ve Yoova isaav, ve lasom tomania suum katini tivot, le tirau taan to yes Isipa. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ve saawe tau uman ighe izi, ene uman izi mako. Yoova igham ais paatu paatu izi le ivaghamunia nugh. Ve igham nugh ighani milia, ve lalaav iŋgalŋgal gabua irau taan toozi isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Tauta ivaghamunia ai vaen tomania ai fik toozi, ve iŋgal ai siriv tipolpol paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Ra isaav, ve siis tivot le katini kat. Tanin zi, aat tarao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Ve tighan aniiŋ tau yes Isipa tivazogh zi na raua tomania gabua siriv tau titum ila taan toozi na le isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Murei ra, Yoova iravuur natuzŋa aidabazŋa timataar irau taan toozi isov. Natuzŋa tau tipoop zi imin maata, tauta tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Ra Yoova igham yes Israela tipul Isip, ve tivot tila. Saawe tau tiburig, tighamuur gol to yes Isipa tomania silva toozi, ve tila tomania. Ve laghooŋ toozi, tilaagh toman tapirizi. Toozi eta tapiri isov ve itap mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Saawe tau yes Israela tipul Isip ve tila, yes Isipa lolozi poia kat. Pasaa, yes Israela tau timin puughu pa pataŋani tau ivotvot pazi ne. Tauta roiŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Mataaz, Yoova igham taitai ivot gha ipoon aaz maata pa yes Israela. Ve mboŋ, i igham yav tiina ighan le isul nugh. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Saawe tau tighasoni pa lezi aniiŋ, i igham man kayau katini tivot, ve igham aniiŋ katini sambam ve izilam pazi. Tauvene tighamu gha tighan le apozi isuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Yoova igham maet ivavaal le aavo ikaak, ve yaa prisia toman tapiri ivot. Yaa tawe ireer tiina izi nugh ŋginaaŋa tau le yaa mako na. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Yoova igham gabua naol tana pasaa, maata iŋgalŋgal saveeŋ tooni patabuyaaŋ tau imbua tomania besooŋa tooni Abaram. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Tauvene Yoova igherev tamtamon tooni Israel tau i tauu isiigh zi na, gha tipul Isip. Timboumbou ve tilolool toman lolozi poia ve tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Murei, ra i igham taan to nugh siriv pazi. Tauvene nugh tawe uraat toozi anooŋa, imin ruum, uum, ai, ve gabua toozi siriv paam, tauta isov imin yes Israela lezi. ");
INSERT INTO tuc_t_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Yoova igham tauvene pazi, leso tikis saveeŋ tooni tuŋia, ve matazi kisin tutuuŋ tooni ve titaghoni. Aleluia! Tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Aleluia! Tapait Yoova pa poia tooni toman loloon poia. Pasaa, i poia kat. I loolo isaghav tamtamon tooni, ve iuluul zi irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Sei irau isavia uraat tintiina tau Yoova ighamgham zi na? Ve sei irau ipaiti pa ŋgar popoia naol tau i ighamgham zi na ve ipasov zi? Eta irao mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Yes tau tighagharaat pataŋani to tamtamon ve titaghon ŋgar duduuŋa irau saawe, ene pale lolozi poia kat, ve poia to Maaron izazaa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","5","O Yoova, saawe tau ugham poghania tamtamon tsio ve ugham mulin zi pa pataŋani toozi, na matam iŋgal ghau ve uul ghau paam. Maaron, yo taum usiigh yes Israela timin lem motot. Yes tamtamon tsio. Tauvene naghe taug naghit zi tileep poi. Leso yeŋa nilup ghei toman tintiinmai ve nipait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Yei nisosor wa. Nisosor pa eez tsio, raraate imin timbumaiŋa. Yei nighamgham ŋgar saghati. Ŋgar tsiei iduduuŋ ila yo matam mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Saawe tau timbumaiŋa tileep izi Isip na, yo ugham gabua ŋgeretazi tintiina ivotvot. Eemon tighilaal zi mako. Saawe naol, yo utotoi poia tsio pazi, itaghon ŋgar tsio tau lolom isaghav tamtamon tsio ve uluul zi. Eemon yes tigham ŋgar pa uleeŋ tsio tana mako. Saawe tau tila tivot Te Siŋsiŋai, tizoor aliŋam, ve tighur murizi payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Eemon Yoova, i eeza tiina pa tapiri ve poia tooni, ve ighe igham zi tighilaal katin tapiri. Tauta igham mulin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Saawe tana, i isaav ariaaŋ pa Te Siŋsiŋai le ivalagh ghi imin ru. Sirivu ila pa tapir, sirivu ila pa ŋas, ve taan mamaasa ivot. Ra igherev yes Israela, ve tilaagh ila maghat tau igheen izila siiŋa kat na, gha tila tivool pa ziige ite. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Tauvene i igham mulin zi ila koiazŋa nimazi. I iyooz pazi, ve iuul zi. Tauta yes tau tighur koi pazi na irau tivaghamun zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Saawe tana, te itav koiazŋa le tisov timataar. Eta ileep muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Maaron igham tauvene, tauta yes Israela tighur ila saveeŋ mbuaaŋ tooni, ve timbou mbouŋ to tipaiti. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Eemon rekia mon ve lolozi iveegh pa gabua ŋgeretazi tau i igham zi na. Yes tisaŋan Maaron to ivotia ŋgar tooni pazi ne mako. Tigham gabua itaghon tauzi ŋgar toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Saawe tau tilepleep izi nugh ŋginaaŋa, luazi itaŋ tighe le tighan aniiŋ popoia imin tau muuŋ tighanghani izi Isip. Tauvene titoov Yoova tapiri izi nugh ŋginaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Ve Maaron ilooŋ taŋiiz toozi ve igham lezi gabua tau tighason pani na. Eemon i igham moroghooŋ saghati ivot le ivaghamun zi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Saawe tau tilepleep ila niazi to lepoogh izi nugh ŋginaaŋa, tamtamon toozi siriv tiburig ve tiŋooŋ pa Mose yesuru toogha Aron tau Yoova besooŋa tooni patabuyaaŋ na. Tighe tigham uraat raraate imin yesuru, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Tauvene taan ikaak, ve Datan gha Abiram tomania ziiri waaro toozi tisov titaptap tizila, ve taan aavo ila ivool muul. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Ra yav ivot, ve ighan tamtamon siriv tau titaghon zi pa ŋgar toozi tawe. Zeran sasaghati tawe, yav yaama ighaniir zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Saawe tau yes Israela tilepleep izi loloz Sinai puughu, tigham gol ve tigharaat makau naatu tamoot anunu, ve tiput aghezi pani ve tipakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Tauvene Maaron toozi tau eeza tiina pa tapiri ve poia tooni na, yes tighur murizi pani. Ve tighur gabua tau ighanghan kikiliiŋ na anunu igham Maaron niia. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Onoon kat, Maaron toozi tau igham uraat tintiina ivotvot izi Isip ve igham mulin zi na, lolozi iveghaini kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","I igham gabua ŋgeretazi tintiina izi taan to yes Isipa, ve igham uraat tintiina izi Te Siŋsiŋai ziige paam. Uraat tawe, tamtamon tighit zi le roiŋ tiina igham zi. Eemon yes Israela tigham ŋgar pa gabua tana mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Tauvene Maaron ighe ivaghamun zi le tisov. Eemon besooŋa tooni Mose tau i tauu isiigho na, iyooz ila Maaron naagho imin sigheu pa yes Israela. Tauta itatan Maaron aatyavyav tooni, ve Maaron ivaghamunia tamtamon tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Saawe tau yes Israela tigharau taan Kanaan, yes tirere pa taan poia tau Yoova ighe igham pazi na. Pasaa, tighur ila saveeŋ mbuaaŋ tooni mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Yes lolozi pa loŋaaŋ Yoova aliiŋa mako. Tilepleep iloŋ ila balbaal toozi, ve lolozi ŋurŋuria pa Maaron. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","27","Tauta Yoova niima izaa, ve imbu saveeŋ ariaaŋ ighe: I pale irav zi tisov timataar izi nugh ŋginaaŋa, ve ivarewai paaghu toozi gha timbiriis tirau nugh nugh. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Murei, ra yes Israela tila tivot loloz Peor. Saawe tana, tipaak yes tau tibesbees pa maaron karom Baal. Pasaa, aniiŋ tau zeran tawe tigham pa maaron maate toozi tawe, yes Israela tighani paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Ŋgar tau tighamu na, ipas Yoova aate, le aate yavyav kat. Tauta igham moroghooŋ saghati ivot pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Tauvene Pineas iburig ve irav tamtamon ru tau tizoor Maaron aliiŋa na gha timatmaat. Ra moroghooŋ saghati tawe isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Ŋgar tooni tawe, tauta Maaron ighita ighe i ŋeer duduuŋa. Ve Maaron pale maata iŋgalŋgali tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Yes Israela tila tivot yaa Meriba, ve tigham Yoova aate yavyav muul. Saawe tana, tigham pataŋani pa Mose paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Pasaa, yes tizoora kat le tipas aate. Tauta igham ŋgar poi mako, ve isik aliiŋa isosor. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Saawe tau tiloŋ tila taan Kanaan, Yoova isaav ariaaŋ pazi ighe tirav yes tau tileep ta sewe na, tisov timataar. Eemon titaghon Yoova aliiŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Yesŋa Kanaana tiluplup zi, ve titaghon ŋgar toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Yes tibesbees pa maaron karomŋa toozi, ve ŋgar tawe imin liis pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Ve tigham tauzi natuzŋa zitamoot ve zilivaa, gha tirav zi timaat, imin watooŋrau pa avuvu sasaghati. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Onoon kat, natuzŋa zitamoot ve zilivaa tau lezi sosor eta mako na, ene yes tirav zi timaat imin watooŋrau pa maaron karomŋa to yes Kanaana. Siŋ toozi tau imaliŋ na, ivaghamunia taan toozi le isaghat ila Maaron maata. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ŋgar tau tighamu na, igham zi tisaghat kat ila Yoova maata. Yes tighur murizi pani, imin livaa tau ipul azaawa ve ila ighurghur boog. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Ŋgar tau tamtamon tooni Israela tighamu na, ene igham Yoova aate yavyav kat, ve loolo pazi mako le mako kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Tauta ipul zi tila nugh nugh nimazi. Yes tileep ila koiazŋa sambazi ve anazi tiŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Koiazŋa tawe tighur pataŋani naol pazi, ve titatan zi pa tapirizi, ve tigham zi timin besooŋa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Pai katini, Yoova ipas yes Israela pa pataŋani toozi. Eemon tighilaal uleeŋ tooni mako, ve tizorzoor aliiŋa, ve titaghon tauzi ŋgar toozi. Ŋgar toozi saghati tawe igham zi tivaghamgham. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Eemon Yoova ighita pataŋani toozi, ve ilooŋ taŋiiz toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","46","Pasaa, maata iŋgal saveeŋ tau imbua tomania timbuzŋa na, ve loolo isaghav tamtamon tooni ve iuluul zi. Tauta itatan aatyavyav tooni, ve igham yes tau tikiskis yes Israela na lolozi isaghatin zi ve tigham poghani zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O Yoova, Maaron tsiei, ugham mulin ghei ila koiamaiŋa nimazi! Ughita. Aazne, nileep irau nugh nugh. Uyau ghei, ve ulup ghei ila taan tsiei muul. Leso lolomai poia payo, ve nipait ezam patabuyaaŋ. Ve matamai iŋgal yo ezam ve tapirim tiina irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Iit tapait Yoova pa poia tooni. I Maaron to iit Israela. Tapaiti ta aazne, ve taghon taghon gha ila! Ve eval tiina aat tisaav tighe: “Onoon kat.” Aleluia! Tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Lolomim poia pa Yoova ve apaiti. Pasaa, i poia kat. Loolo isaghav tamtamon tooni ariaaŋ, ve iuluul zi irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Yes tau Yoova igham mulin zi ila koiazŋa nimazi na, irau tisavia saveeŋ tane. Pasaa, i iyooz pazi ve ipas zi tivot pa pataŋani toozi, ve igham zi tileep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Muuŋ, koiazŋa tigham zi tila tileep irau nugh nugh. Siriv tileep ila pa nugh tau aaz izazaa pani, ve siriv tileep ila pa nugh tau aaz izila. Siriv tileep ila pa ragh puughu, ve siriv tileep ila pa yavaar puughu. Eemon Yoova iyau zi timuul tilam pa tauzi nugh toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Tamtamon siriv, tivalaghlaagh izi nugh ŋginaaŋa tau le yaa mako na. Ve tiliil eez tighe tila nugh eta, leso tileep ta sewe. Eemon tindeeŋ eez eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Pitool zi, ve murun zi, le tapirizi isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Tauvene tileep saghat. Eemon saawe tau titaŋ rarai Yoova pa uleeŋ, i iuul zi pa pataŋani toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ve itotoi zi pa eez tau duduuŋa ve tuuku. Tauta titaghoni ve rekia tila tivot nugh poia ve tileep ta sewe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Tauvene yes irau lolozi poia pa Yoova ve tipaiti pa poia tooni. Pasaa, i loolo isaghav iit tamtamon ve iuluul ghiit. Ve ighamgham uraat ŋgeretazi to iuul iit tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Yes tau murun zi, i ighamgham yaa pazi to tighun ve isooŋ zi. Ve yes tau pitool zi, i irao zi pa gabua popoia le tirau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Tamtamon siriv, yes tileep ila ndoroom tiina loolo, ve rigmon kanaŋ timaat. Yes tileep ila ruum to yavyavuuŋ loolo, ve ravraav tomania sen ighan nimazi ma aghezi le tisaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Pasaa, tizorzoor Maaron aliiŋa. Maaron Tiina Tau Iliiv Zimaronŋa Tisov na, yes tivevelegh saveeŋ tooni imin kaut sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Tauta i ighur uraat pataŋani kat izaa toozi, leso itatan zi. Yes irau tilaagh duduuŋ mako, ve titaptap tizizi. Pasaa, tibadbaad gabua pataŋani. Ve lezi tamtamon eta to iuul zi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Tauvene tileep saghat. Eemon saawe tau titaŋ rarai Yoova pa uleeŋ, i iuul zi pa pataŋani toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","I ipas zi tivot pa ndoroom tiina tawe loolo, ve igham zi tivot tila ghazooŋa. Ve ikuup motin ravraav tomania sen pa nimazi ma aghezi. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Tauvene yes irau lolozi poia pa Yoova ve tipaiti pa poia tooni. Pasaa, i loolo isaghav iit tamtamon ve iuluul ghiit. Ve ighamgham uraat ŋgeretazi to iuul iit tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Ataman ariaŋazi to ruum to yavyavuuŋ tau tigharaat zi pa mbaras na, i irav valaghin zi. Ve ain ariaŋazi tau tipapalot ataman na, i iŋgoor polpolin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Tamtamon siriv, yes tighamgham ŋgar to borauŋa ve tinoknok zoraaŋ saveeŋ. Yes tighamgham sosor, tauvene timorooŋ ve yavyavuuŋ tiina igham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Lolozi pa ghaniiŋ aniiŋ eta mako. Isaav ighe tighita aniiŋ eta, ene pale atezi inaunau ve tilulu. Tauvene tileep ila naal aavo wa. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Yes tileep saghat. Eemon saawe tau titaŋ rarai Yoova pa uleeŋ, i iuul zi pa pataŋani toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","I isaav, ve tinizi popoia muul. Muuŋ, tileep ila naal aavo. Ve i igham mulin zi pa mateegh. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Tauvene yes irau lolozi poia pa Yoova ve tipaiti pa poia tooni. Pasaa, i loolo isaghav iit tamtamon ve iuluul ghiit. Ve ighamgham uraat ŋgeretazi to iuul iit tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Tauvene yes aat lolozi poia pa uraat tintiina tau i igham pazi na, ve tigham watooŋrau pani. Ve timbou toman aliŋazi tiina to tipakuru, ve tisavia uraat tooni tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Tamtamon siriv, yes tizaa waaŋ, ve tiraav tila nugh malau to tiraukol. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Yes tighit katin Yoova tapiri, ve uraat tintiina tau i ighamghamu ila te paavo. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Pasaa, i isaav ariaaŋ, ve yaghur tiina izaa, le ipei dibom tintiina. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Dibom tintiina tawe iit waaŋ toozi izala kat, ve ipuli izi le rigmon kanaŋ izal izila mazavan tiina loolo. Tauvene roiŋ tiina igham zi le tapirizi isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Ve tivataptap imin tamtamon tau ighun gha ivaghamgham. Yes to te tiwatagh ghamuuŋ pooz. Eemon tirau gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Tauvene tileep saghat. Eemon saawe tau titaŋ rarai Yoova pa uleeŋ, i iuul zi pa pataŋani toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","I igham yaghur aate izi, ve dibom imaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Yes tighita taun izi, le lolozi poia. Ve Yoova igham zi tila tilooŋ nugh tau tighe tila pani na. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Tauvene yes irau lolozi poia pa Yoova ve tipaiti pa poia tooni. Pasaa, i loolo isaghav iit tamtamon ve iuluul ghiit. Ve ighamgham uraat ŋgeretazi to iuul iit tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Tauvene isaav ighe eval tiina tilup zi pa suŋuuŋ, zeran tawe aat tila tomani zi ve tiyoor Yoova eeza. Ve saawe tau yes ŋginiiŋa tilup zi, zeran tawe aat tipait Yoova eeza ila naghozi paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yoova irau igham yaa tintiina timaak le tigorgor kat, imin nugh tau le yaa mako na. Ve yaa tau tivotvot ila taan loolo na paam, i irau ipoon zi le taan loolo igorgor. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Isaav ighe nugh eta tinoknok ghamuuŋ ŋgar saghati, i irau ivaghamunia taan toozi tau ŋgoreeŋa tiina na, leso isaghat, ve gabua eta itum ila muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ve isaav ighe nugh eta le yaa mako, i irau igham yaa ivot pani, ve ireer tiina. Taan tau loolo gorgori na, i irau igham yaa ivot pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Yes tau pitool zi na, i igham zi tila tileep ila taan poia tawe, ve tighamu imin lezi nugh to lepoogh. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Tauvene yes tivazogh aniiŋ ve vaen ila, le tighita anooŋa katini tivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yoova ighur poia tooni izazaa toozi, tauta timasa timin eval. Ve maata pa makau, mekmek, ve sipsip toozi paam, le timasa timin naol. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Isaav ighe tamtamon to Maaron koiazŋa titatan zi le tapirizi isov, ve tigham saghatin zi le tileep saghat toman lolozi ipataŋan, ");
INSERT INTO tuc_t_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","ene pale Yoova iuul zi, ve itatan daaba to koiazŋa tawe. Pale igham zi tivaghamgham, ve tivalaghlaagh izi nugh ŋginaaŋa tau eez eta igheen ila mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Eemon yes tau tileep ila pataŋani loolo ve mbolaaŋ igham zi na, i ipaghau zi pa pataŋani toozi, ve maata pazi le timasa timin eval. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Ŋgar tooni tawe, zeran duduŋazi tighita, le lolozi poia kat. Ve zeran sasaghati tisov lezi saveeŋ eta muul mako. Saveeŋ toozi isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Tamtamon tau ighe le ŋgar, i aat igham ŋgar poi pa gabua tane, ve maata iŋgalŋgal ŋgar to Yoova tau loolo isaghav tamtamon tooni ve iuluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Mbouŋ to David Maaron, lolog ruru payo mako. Lolog isaghav ghom, ve naghur ilat tsiam ariaaŋ. Tauvene nasaav pa taug naghe: “Uburig ve umbou to upait Maaron!” ");
INSERT INTO tuc_t_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Lolog ighur naghe nughitun, o naburig, ve nagharaat taug, ve naravrav ambam tomania gita ila ila le aaz pisikia izaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Tiina tsiau, yau aat napait ghom pa poia tsio ila tamtamon to nugh nugh matazi. Pale yeŋa tamtamon to nughmariŋ nilup ghei pa suŋuuŋ, ve nait mbouŋ to napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","O Yoova, yo lolom isaghav tamtamon tsio, ve uluul zi. Ŋgar tsio tana, ene tiina le tiina kat. Izala izala le ikis sambam. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tsio tauvene paam. Izala le ikis taitai. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Maaron, eval tiina aat tipait ezam izala le izala kat, iliv sambam saamba. Ve tipakur ghom pa tapirim ve poia tsio irau taan isov! ");
INSERT INTO tuc_t_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Maaron, yei tamtamon tsio. Lolom igheen tsiei kat. Ulooŋ suŋuuŋ tsiau tane, ve utotoi tapirim ve uul ghei. Ugham mulin ghei pa pataŋani tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Muuŋ, Maaron ileep izi nugh tooni patabuyaaŋ, ve isaav ighe: “Yau naparav le naliiv koiagŋa wa. Tauta lolog poia ve navalagh taan Sekem ve nugh duduuŋa to Sukot, ve nareii irau tamtamon tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Taan sirivu to Gileat, ve taan to yes Manase paam, ene yau tsiau. Yes Epraima timin hat ariaaŋa to ipoon dabag pa malmal. Ve yes Yuda timin titi tau nakisi imin ilaal pa pooz tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Taan sirivu to Moap, ene imin oon tsiau to ririwaaŋ. Ve taan sirivu to Edoma, ene nugh tau nasik zuzuuŋa to agheg pani. Ve yes Pilistia, yau naparav tomani zi le naliiv zi. Tauta tintinig ve aliŋag izaa.” ");
INSERT INTO tuc_t_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Sei irau igham ghau naliiv koiagŋa ve naloŋ nala nugh toozi tau didiiŋ ariaaŋa ilivuti na? Sei pale imuuŋ payau, ve igherev ghau nala navot taan sirivu to yes Edom? ");
INSERT INTO tuc_t_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Ite paam mako. Yo mon. Eemon Maaron, aazne yo ughur murim payei, ve upaak zaaba tsiei muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Maaron, uul ghei, leso niliiv koiamaiŋa. Pasaa, uleeŋ tau nighamghamu ila to tamtamon, ene anooŋa mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Eemon isaav ighe Maaron ilam tomani ghei, ene aat niliiv zi. I irau itatan zi, le tapirizi isov kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Mbouŋ to David O Maaron, saawe isov yau napapait ghom. Ulooŋ suŋuuŋ tsiau. Uneneeŋ sov! ");
INSERT INTO tuc_t_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Pasaa, zeran sasaghati tau avozi karom na, tighurghur koi payau, ve tiŋgalŋgal saveeŋ karom naol payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Koiagŋa tawe tisiksik saveeŋ sasaghati payau, ve tivaghamunia ezag sorok. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Muuŋ, yau lolog pazi, ve naghamgham ŋgar poia pazi. Eemon tiyat ŋgar poia ta nagham pazi na pa ŋgar saghati, ve tiŋgalŋgal saveeŋ naol payau. Eemon yau ŋeer to suŋuuŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ŋgar poia tau yau naghamgham pazi na, yes tiyatu pa ŋgar saghati. Yau lolog pazi. Eemon yes tighur koi payau, ve tighe: ");
INSERT INTO tuc_t_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","7","“Taghur tamtamon saghati eta iyooz ila ziige to iŋgal saveeŋ pani. Leso saawe tau tipayooze pa savsaveeŋ, tighita tighe i isosor, ve tighur atuya pani. Ve nighe suŋuuŋ tooni paam, ene isosor ila Maaron maata. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ŋeer tawe ileep malau izi taan sov. Tamtamon ite paam aat igham niia ve igham uraat tooni, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Azaawa pale imin naar, ve natŋa timin parooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Pale tireu natŋa ruum toozi tizi, ve tinaan zi tighawaar. Leso tivaghamgham, tivalaghlaagh, ve tisuŋsuŋ lezi gabua. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Isaav ighe ŋeer tawe igham bun ila to tamtamon eta, ene pale tamtamon tana ilam ve iyauur gabua tooni isov imin le. Gabua tau i ighun punita pani na, zeran to nugh ite pale tilam ve tighamuur zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Tamtamon eta igham poghania ŋeer tawe sov. Ve natŋa tau timin parooŋa na, tamtamon eta loolo isaghatin zi ve iuul zi sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Natŋa timataar le tisov, o poia. Leso ŋeer tawe eeza igheen muul sov, ve tamtamon lolozi iveegh pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Ŋgar saghati to timŋa, tamtamon pale tisavia pa Yoova, leso maata iŋgalŋgali. Ve sosor to tiina paam, Yoova ireua sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Tauvene sosor to ŋeer tawe tomania ziiri waaro tooni, Yoova pale maata iŋgalŋgali irau saawe, ve ipasovuur zi pa taan. Leso tamtamon lolozi iveghai zi kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Pasaa, ŋeer tawe maata iŋgal ve igham ŋgar poia eta pa tamtamon mako. Yes mbolaaŋa ve yes tau tileep ila pataŋani loolo na, i ighamgham saghatin zi, ve iravrav zi timatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ŋgar to avoon saghati pa tamtamon, i loolo pani kat. Eemon saveeŋ tooni saghati tawe pale imuul pa tauu, ve ivaghamunia. Ŋgar to tasuŋ Maaron leso ighur poia tooni izaa to tamtamon, ŋeer tawe loolo pani mako. Tauvene poia to Maaron pale igheen malau pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ŋgar to avoon saghati pa tamtamon, i ipulpuli mako. Ene imin nonoghiiŋa tau i loolo pani kat, ve inonogh ghi pani irau saawe. Eemon saveeŋ tooni saghati tawe pale imuul pa tauu, ve izila loolo imin yaa, ve ila irau tuua ta naol ne imin ŋgoreeŋ, ve ivaghamunia. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Saveeŋ tooni saghati tawe, pale imuul pa tauu ve ikauu, imin kawaal tau i ikawaala ila ŋgaali ve ipuusa pa puus irau saawe.” ");
INSERT INTO tuc_t_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","O Yoova, saveeŋ sasaghati tau koiagŋa tiŋgalŋgali payau ne, upamuule ila pa tauzi. Leso uyat ŋgar toozi tawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Yoova, yo Maaron tsiau. Ezam tiina pa poia tsio ve uleeŋ tsio. Yo lolom isaghav tamtamon tsio ve uluul zi irau saawe. Tauvene uyooz payau, ve upas ghau navot pa pataŋani tsiau tane. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Pasaa, aazne naleep saghat, ve leg eez eta mako. Tauvene ateg ipaparav ve lolog isaghat kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Yau namin gabua yavyaava tau ighe aaz izila, mako taghita muul mako. Yau namin siis tau yaghur ivuvuura gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Yau naŋgun taug pa ghaniiŋ aniiŋ alok wa. Tauvene nakoŋkoŋ, ve tuag isov peria, ve agheg imatmaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Isaav ighe koiagŋa tighit ghau, ene tivevelegh ghau ve tiŋiŋiŋ payau. Ve titurun luazi payau ve tighe: “Aa, ughita wa?” ");
INSERT INTO tuc_t_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yoova, yo Maaron tsiau. Uul ghau lak! Ugham mulin ghau pa pataŋani tsiau tane. Pasaa, lolom isaghav tamtamon tsio, ve uluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ugham koiagŋa tiwatagh yo nimam. Utotoi tapirim pazi ve tighit katini pa matazi. Leso tighilaal tighe yo ta Volaaŋa tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Onoon, yes avozi saghati payau. Eemon yo pale ughur poia tsio izaa tsiau. Isaav ighe koiagŋa tipaburigin malmal payau, yo pale utatan zi, ve upamuul zi tila toman mayazi. Leso ugham besooŋa tsio loolo poia ve tintini. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Tauvene yes tau tiŋgalŋgal saveeŋ payau ne, ugham zi tivaghamgham, ve tighau tila toman mayazi. Mayaŋa tana pale imin lezi nonoghiiŋa to tinonogh zi pani irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Eemon yau aat lolog poia kat pa Yoova, ve avog ipaiti pa poia tooni toman aliŋag tiina. Saawe tau yeŋa eval tiina nilup ghei pa suŋuuŋ, yau aat nayoor eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Pasaa, yes tau tileep ila pataŋani loolo ve titaŋ raraini pa uleeŋ na, i iyozyooz zigezi to iuul zi. Ve yes tau koiazŋa tiŋgalŋgal saveeŋ pazi ve tighe tirav zi timaat na, i igham mulin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Mbouŋ to David Yoova isaav pa Tiina tsiau ighe: “Ulam mbolem izi ila pa nimag tapir, le irau natatan koiamŋa ve tapirizi isov kat, ve uvaghaaz zi ila aghem saamba.” ");
INSERT INTO tuc_t_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","O kinik, aazne yo ulepleep izi nugh Zion, ve Yoova igham titi to kinik payo to ipapalot ghom. Tauta tapirim tiina ve pooz tsio ila irau nugh nugh. Yoova isaav payo ighe: “Utatan koiamŋa tau tilivutin ghom na, ve ugham zi tileep ila sambam.” ");
INSERT INTO tuc_t_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Isaav ighe uburig ughe ula pa malmal, tamtamon tsio ndiŋndiŋ ndiŋndiŋ pale lolozi ipazaagh zi tighe tilat gha yamŋa ala. Isaav ighe aaz pisikia izaa, geegeu tsio tau tirao pa malmal na, pale timeke tilat, ve tileep tirau loloz patabuyaaŋa tau tilivutin Yerusalem na, imin uwam to mboŋoozo itav kikiliiŋ. ");
INSERT INTO tuc_t_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yoova imbu saveeŋ tomani ghom, ve ipariaaŋa le iyaryaaŋ kat. Irau itoor ŋgar tooni mako. Isaav payo ighe: “Yo ŋeer to watooŋrau imin Melkizedek. Ve yo aat uleep tauvene taghon taghon gha ila.” ");
INSERT INTO tuc_t_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Maaron ileep ila pa nimam tapir ve ipapalot ghom. Saawe to aatyavyav tooni ighe ivot, i pale ipaburigin malmal ve iravuur yes kinik tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Pale ighur atuya pa nugh nugh, ve irav zi timataar le patazi tizi tivaghengheen ila taan. Tauvene yes pooza tau tileep irau taan na, i pale iravuur zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ve kinik tsiei, i pale ighun yaa tau ireer igharau eez ziige na, le tapiri ivot muul. Tauvene i pale iliiv malmal, ve tiini izaa. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Aleluia, tapait Yoova! Isaav ighe zeran duduŋazi tilup zi pa suŋuuŋ, yau aat nala tomani zi, ve napakur Yoova toman lolog isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Pasaa, Yoova ighamgham uraat tintiina. Tauvene yes tau lolozi pa uraat tooni kat na, tighamgham ŋgar pa uraat tooni irau saawe tighe le tiwatagh katini. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Uraat tooni itotoi ighe i tapiri tiina ve poia kat. Tauta tamtamon titandagh pani. Ŋgar tooni duduuŋa pale ighengheen tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","I ipaburigin ŋgar toit, leso mataan kisin uraat tooni ŋgeretazi. I loolo isasaghatin tamtamon tooni, ve ighamgham poghani zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Yes tau tiroi pani ve titaghon ŋgar tooni na, i ighamgham lezi aniiŋ. Ve saveeŋ tau yesŋa tamtamon tooni timbua to tivalupu zi timin eemon na, i maata iŋgalŋgali ve itataghoni irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Muuŋ, i igham uraat tintiina ila tamtamon tooni matazi, leso itotoi tapiri pazi. Saawe tana, i igham taan to nugh nugh imin lezi to tileep ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Uraat naol tau i igham zi na, ene itotoia ighe i itataghon saveeŋ mbuaaŋ tooni, ve ŋgar tooni iduduuŋ mon. Tauvene tutuuŋ isov tau i ighur zi na, iit aat taghur ila ve tataghon duduŋai zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Tutuuŋ naol tawe pale iyaryaaŋ tauvene taghon taghon gha ila. Yoova ighur tutuuŋ tawe itaghon saveeŋ mbuaaŋ tooni ve ŋgar duduuŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Muuŋ, i ipas tamtamon tooni tivot pa pataŋani toozi. Ve saawe tau yesŋa timbu saveeŋ to tivalupu zi timin eemon, aavo iyaryaaŋ pazi ighe titaghon saveeŋ mbuaaŋ toozi tawe ŋgara irau saawe. I tapiri tiina ve eeza patabuyaaŋ kat. Tauta taroi pani, ve tataghon ŋgar tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Ŋgar to taroi pa Yoova ve tataghon ŋgar tooni, ene imin puughu pa ŋgar poia. Yes tau titaghon saveeŋ tooni na, tiwatagh eez to tigham lepoogh poia. Tauvene iit aat tapakuru irau saawe! ");
INSERT INTO tuc_t_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Aleluia, tapait Yoova! Ŋeer tau ighe iroi pa Yoova ve itaghon ŋgar tooni, ve tutuuŋ to Yoova ighamu loolo poia, ene aat tintini ve poia to Maaron izazaa tooni. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Ve paaghu tooni pale timin zeran tau ezazi tintiina. Tauvene yes tau tiduduuŋ ila Maaron maata na, tamtamon to taan tane pale titandagh pa paaghu toozi ve poia to Maaron izazaa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Zeran duduŋazi, ruum toozi ivon kat pa kuaz ve gabua popoia katini. Ve ŋgar toozi duduuŋa pale igheen ariaaŋ tauvene taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Isaav ighe ŋeer duduuŋa eta ileep ndoroom tiina loolo, ene pale ghazooŋa to Maaron isulu. Tamtamon tauvene, loolo isasaghatin tamtamon, ve ighamgham poghani zi, ve itotoi ŋgar duduuŋa pazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Tamtamon tau ighe maata reiŋ gabua, ve iyokia gabua tooni pa uleeŋ tamtamon, ve itaghon ŋgar duduuŋa mon pa uraat tooni, ene pale ileep poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Tamtamon duduuŋa tauvene, tovaaŋ eta irau ighamu itap ne mako. Ve tamtamon pale matazi iŋgalŋgali pa ŋgar poia tooni tawe taghon taghon gha ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Isaav ighe ilooŋ gabua saghati eta vaaru, i irau iroi mako. Pasaa, inumeer Yoova ve ghuruuŋ ila tooni iyaryaaŋ kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Tauvene roiŋ irau ighamu mako. Iyozyooz ariaaŋ, le ighita Maaron itatan koiŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","I maata iŋgalŋgal yes mbolaaŋa, ve ireirei gabua pazi. Ŋgar tooni duduuŋa pale igheen ariaaŋ tauvene taghon taghon gha ila. Tauvene eeza pale imin tiina, ve tamtamon titandagh pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Zeran sasaghati tighita ŋgar tau ivotvot pani na, le atezi yavyav ve tiŋaaŋ maripazi pani. Eemon irau tigham ŋgar eta pani mako. Pale saghatiiŋ ivot pazi ve tilalez. Tauvene gabua popoia tau tighurghur matazi pani na, ene irau ivot pazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Aleluia, tapait Yoova! Yam besooŋa to Yoova, apakuru, ve apait eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Apait Yoova pa poia tooni ta aazne, ve taghon taghon gha ila! ");
INSERT INTO tuc_t_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Yam tau aleep ila pa aaz izaa, ve ila pa yam tau aleep ila pa aaz izila, apait Yoova eeza! ");
INSERT INTO tuc_t_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yoova ileep saaŋa kat, ve nughmariŋ tileep ila i saamba. Eeza ve tapiri iliiv gabua naol isov to sambam. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Sei ta irao Maaron tsiei Yoova? Eta imin i mako. I ilepleep ila niia to ghamuuŋ pooz tau igheen saaŋa kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Tauvene i aat maata izila le izila kat ta siiŋa geeg we, o ighita gabua to sambam saamba ve taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","8","Eemon yes tau lezi ezazi mako, ve yes mbolaaŋa tau monmon tilala nugh to sikiiŋ pen ve tiliil lezi aniiŋ na, i loolo iveghai zi mako. I ipapakur zi ve iuluul zi, leso tileep poi toman tintinizi. Tauvene yes irau tileep tomania yes daaba tau tighamgham pooz pa tamtamon. ");
INSERT INTO tuc_t_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ve yes zilivaa tau upazi na, i ighamgham lezi niazi popoia to lepoogh, ve ighamgham lezi natuzŋa. Tauvene tileep tomania natuzŋa tawe, ve lolozi poia kat. Aleluia, tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Muuŋ, Israela tipul Isip ve tila. Yakop paaghu tooni tipul tamtamon tau aliŋazi ite na, ve tivot. ");
INSERT INTO tuc_t_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Indeeŋ tana, yes Yuda timin Yoova niia patabuyaaŋ to lepoogh. Ve yes Israela, tileep ila i niima ve iŋgin zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Saawe tau Te Siŋsiŋai ighita Yoova tamtamon tooni tilam, i iroi ve ighau. Ve yaa Yordan ighit zi, le ipamuule iloŋ ila ve ipot imin yaa naliu. ");
INSERT INTO tuc_t_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Ve loloz tauvene paam. Yogyoog itok le tiyatyaat imin mekmek. Ve nugh mbua mbua tiyatyaat imin sipsip natŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","O te, saa gabua ivot payo, ta ughau? Ve yaa Yordan, puughu mindai ta utoor ghom ve umuul uzala? ");
INSERT INTO tuc_t_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ve yam loloz ve nugh mbua mbua, ayatyaat pasaa? ");
INSERT INTO tuc_t_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","O taan, uyamaan ghom! Malau mako pale Yoova ilam. Paita Maaron to Yakop ilam, ve itotoi tapiri payo. ");
INSERT INTO tuc_t_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","I ta igham yaa ivot ila maet, ve izi ipot imin yaa naliu. Onoon kat, i igham yaa ivot ila maet ariaaŋa, ve ireer izi. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","O Yoova, yei lolomai pa tamtamon tipait ezamai mako. Tipait yo ezam pa tapirim ve poia tsio, o poi. Pasaa, lolom isaghav tamtamon tsio ve uluul zi, ve utaghon saveeŋ mbuaaŋ tsio irau saawe. Tauvene utotoi tapirim ve uul ghei. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Mako pale nugh nugh tivelegh ghom, ve tisaav payei tighe: “Aa, Maaron tsiam ileep sindei?” ");
INSERT INTO tuc_t_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Eemon yei niwatagh: Maaron tsiei, i ileep izi sambam. Ve saa ŋgar tau i ighe ighamu, ene ighamu mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Nugh nugh tighagharaat maaron toozi pa silva ma gol. Maaron karomŋa tawe, tamtamon tigharaat zi pa nimazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Yes lezi avozi. Eemon tisavsaav mako. Ve lezi matazi. Eemon tighita nugh mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Yes lezi taliŋazi. Eemon tilooŋ saveeŋ mako. Ve lezi uzuzi. Eemon tinuŋuz gabua eta vaazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Yes lezi aghezi. Eemon irau tilaagh mako. Ve lezi nimazi. Eemon irau tikis gabua eta ve tiyamaana mako. Onoon kat, saveeŋ ma taŋiiz eta ivot pa avozi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Tamtamon tau tighagharaat maaron karomŋa tauvene ve tinumeer zi, ene tisov timin maaron toozi tawe. Tirau gabua eta mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Yam eval tiina to Israel, anumeer Yoova. Pasaa, i ta Uleeŋa tsiam, ve imin sigheu payam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Ve yam to watooŋrau tau avot ila to Aron na paam, anumeer Yoova! Pasaa, i ta Uleeŋa tsiam, ve imin sigheu payam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Tauvene yam tau aroi pa Yoova ve ataghon ŋgar tooni na, yam asov anumeera. Pasaa, i ta Uleeŋa tsiam, ve imin sigheu payam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yoova maata iŋgalŋgal ghei. Ve i pale ighur poia tooni izaa tsiei. Pale ighur poia tooni izaa to yes to watooŋrau tau tivot ila to Aron na, ve ighur poia tooni izaa to eval tiina to Israel paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Tauvene yes tau tiroi pani ve titaghon ŋgar tooni na, i pale ighur poia tooni izaa toozi tisov. Yes tau lezi ezazi mako, ve yes tau ezazi tintiina na paam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Yoova pale igham gham tomania paaghu tsiam amasa amin naol. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yoova ta ighur sambam ve taan. I pale ighur poia tooni izaa tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Sambam, ene Yoova nugh tooni. Ve taan, ene i igham pa iit tamtamon to taleep ila. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Yes tau timaat gha tizila mateegha niazi na, eta aavo luutu mako. Tineneeŋ mon. Irau tipait Yoova muul mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Eemon iit tau taleep mataan yaryaare, o loloon poia pa Yoova, ve tapaiti pa poia tooni. Ta aazne, ve taghon taghon gha ila. Aleluia, tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","2","Yau lolog igheen to Yoova kat pasaa, i ilooŋ taŋiiz tsiau. Yau nataŋ raraini pa uleeŋ, ve i ighur taliiŋa payau ve iuul ghau. Tauvene saawe tau naleep izi taan, suŋuuŋ tsiau aat iŋaruini irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Liis to mateegh, rigmon kanaŋ igham ghau. Ravraav to mateegh ikaukau ghau, ve ighe igherev ghau nazila nugh to mateegha. Tauvene igham lolog ipataŋan, ve roiŋ tiina igham ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Tauta nataŋ rarai Yoova naghe: “O Yoova, paita namaat tane. Uul ghau lak!” ");
INSERT INTO tuc_t_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yoova loolo isasaghatin ghiit, ve ighamgham poghani ghiit. Ŋgar tooni, ene iduduuŋ mon. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yes tau irau tiuul tauzi mako na, Yoova tauu iŋgin zi, ve iuluul zi. Imin yau. Saawe tau pataŋani itatan ghau le tapirig imbool, i ilam ve igham mulin ghau. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Tauta aazne, ateg izi ve lolog poia muul. Pasaa, Yoova igham poghani ghau kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","9","Onoon kat, i igham mulin ghau pa mateegh, ve ipasov taŋiiz tsiau. Ve i ta ikiskis ghau. Tauta natap mako, ve aazne naleep matag yaryaare. Ve laghooŋ tsiau, nazuari ghau naghe le nataghon ŋgar tau iduduuŋ ila Yoova maata. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Muuŋ, yau nasaav pa taug naghe: “Pataŋani tiina igham ghau le naleep saghat.” Eemon nakis ghuruuŋ ila tsiau tuŋia. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Pataŋani tawe igham ghau nail eez. Tauvene nasik saveeŋ sorok naghe: “Tamtamon tisov, avozi karom mon. Irau nanumeer eta mako.” ");
INSERT INTO tuc_t_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Pale nagham saa pa Yoova to nayat ŋgar popoia maata maata tau i ighamgham zi payau ne? ");
INSERT INTO tuc_t_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Yau aat nagham rubruub vaen, ve naliŋi izala watooŋrau tsiau paavo to napaiti, ve nasuŋ pani toman lolog poia. Pasaa, i igham mulin ghau pa pataŋani tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Tauvene saawe tau Yoova tamtamon tooni tilup zi pa suŋuuŋ, yau aat nataghon saveeŋ tau nambua pani na, ve nagham uratoini ila matazi. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yes tau lolozi isaghav Yoova ariaaŋ ve titaghon eez tooni na, i loolo igheen toozi kat. Tauvene i irau ighita mateegh to toozi eta imin kaut sorok ne mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Yoova, yau besooŋa tsio. Nabesbees payo imin muuŋ tinaŋ ibesbees payo. Muuŋ, naleep saghat imin tikau ghau pa ravraav. Eemon yo upoola payau, tauta aazne naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Tauvene yau aat nagham watooŋrau payo, ve nasuŋ payo toman lolog poia, ve napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","19","Saawe tau Yoova tamtamon tooni tizala Yerusalem, ve tilup zi pa suŋuuŋ iloŋ ila sirsiir to rumei tooni loolo, yau aat nataghon saveeŋ mbuaaŋ tsiau tane, ve nagham uratoini ila matazi. Aleluia, tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Yam tamtamon to nugh nugh, apait Yoova! Yam tau aleep irau taan na, asov ayoor eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Pasaa, poia tooni, ene tiina le tiina kat. I loolo isaghav tamtamon tooni ve iuluul zi irau saawe. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tooni paam, ighengheen tauvene, taghon taghon gha ila. Aleluia, tapait Yoova! ");
INSERT INTO tuc_t_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Lolomim poia pa Yoova ve apaiti! Pasaa, i poia kat. I loolo isaghav tamtamon tooni ve iuluul zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Yam eval tiina to Israel, alup avomim ve asaav aghe: “I loolo isaghav tamtamon tooni, ve iuluul zi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Ve yam to watooŋrau tau avot ila to Aron na paam, asaav aghe: “I loolo isaghav tamtamon tooni, ve iuluul zi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Tauvene yam tau aroi pa Yoova ve ataghon ŋgar tooni na, asov asaav aghe: “I loolo isaghav tamtamon tooni, ve iuluul zi.” ");
INSERT INTO tuc_t_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Muuŋ, yau naleep ila pataŋani tiina loolo ve leg eez mako. Tauvene nataŋ rarai Yoova pa uleeŋ. Ve i ilooŋ aliŋag, ve ipas ghau navot pa pataŋani tsiau. Tauta aazne naleep ila nugh ghazooŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Isaav ighe Yoova ileep zigeg, yau irau naroi mako. Pasaa, tamtamon pale tigham saa payau? ");
INSERT INTO tuc_t_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yoova ivool tsiau, ve iuluul ghau. I aat itatan koiagŋa ila matag, ve naliiv zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Iit tanumeer tamtamon to taan sov. Tanumeer Yoova ve tayooŋ ila tooni, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Yes daaba tau tighamgham pooz na paam, tanumeer zi sov. Tanumeer Yoova ve tayooŋ ila tooni, o poia. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Muuŋ, nugh nugh tilam tilivutin ghau tighe tigham malmal payau. Eemon Yoova, tauta napasov zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Tiŋarui ghau tilam, ve tilivutin ghau, le leg sooso eta to naghau mako. Eemon Yoova, tauta napasov zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Yes timorau ghau imin ŋgururuuv. Eemon Yoova, tauta napasov zi, le tapirizi isov. Yes timin yav tau ighan regh gha iyaryaar, ve rekia mon imaat. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Yes tipaburigin malmal payau, ve rigmon kanaŋ titatan ghau. Eemon Yoova iuul ghau, tauta tivaghamun ghau mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Pasaa, i Uleeŋa tsiau ariaaŋa. Yau naghamgham tapirig ila tooni, ve i imin sigheu payau. Tauta nambou mbouŋ to napait eeza. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Alooŋ. Zeran duduŋazi tilepleep ila balbaal toz toz, ve tiyoryoor Yoova eeza toman lolozi poia. Pasaa, i iliiv koiazŋa wa. Tisavsaav tighe: “Yoova niima tapir, ene pataŋani. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Niima iparav ariaaŋ kat. I igharaat ghi pa malmal, ve iparav le iliiv koiŋa!” ");
INSERT INTO tuc_t_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Yau irau namaat soone. Pale naleep matag yaryaare. Leso navotia uraat tintiina tau Yoova ighamgham zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Onoon, i ilos katin ghau. Eemon ipul ghau namaat mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Tauvene akaak ataman to zeran duduŋazi payau. Leso nataghoni naloŋ nala, ve napait Yoova pa ŋgar tau i igham payau na. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Ene ataman to Yoova. Yes tau tiduduuŋ ila i maata, o titaghoni tiloŋ tila. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Yoova, yo ulooŋ suŋuuŋ tsiau, ve ugham mulin ghau pa pataŋani tsiau. Tauvene lolog poia payo ve napait ghom. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Maet tau yes to raoŋ ruum matazi veleghini ve tisiki ilale, tauta imin puughu pa ruum, leso ipaloti ve ruum iyooz ariaaŋ izala paavo. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Maaron tauu igham gabua tane ivot. Ve yei nighita imin gabua ŋgereeta ee ila matamai. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Saawe ta aazne, Yoova ighuru. Tauvene tintiniin ve loloon poia pani. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","O Yoova, lolom isaghatin ghei ve ugham mulin ghei! Uul ghei, leso gabua naol isov ivot poi payei. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Ŋeer tane ilam pa Yoova eeza. Tauvene poia to Yoova aat izaa tooni. Yei tau nileep ila Yoova rumei tooni loolo na, nighasoni nighe ighur poia tooni izaa tsiam. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yoova, i Maaron tauu! I igham poghani ghiit, ve ghazooŋa tooni isul ghiit. Akis tuum raua ve ala alivutin artaal ve apakuru. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Yo Maaron tsiau. Yau lolog poia payo ve napait ghom pa poia tsio. Onoon kat, yo ta Maaron tsiau. Tauvene yau aat nayoor ezam. ");
INSERT INTO tuc_t_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Apait Yoova pa poia tooni toman lolomim poia. Pasaa, i poia kat. I loolo isaghav tamtamon tooni, ve iuluul zi irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Yes tau tighamgham sosor mako, ve laghooŋ toozi iduduuŋ mon itaghon saveeŋ to Yoova, ene aat poia tooni izazaa toozi ve tintinizi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","3","Yes tau matazi kisin eez tau Maaron ighuru pa tamtamon tooni na, ve titaghoni irau saawe, ve tighur lolozi isov iŋarui Maaron, ve tizuari zi to tiwataghi kat, ve yes tau tighamgham sosor mako, ve laghooŋ toozi, titaghon Maaron eez tooni, ene pale tintinizi pa poia to Maaron tau izaa toozi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Yoova, yo ughe nitaghon tutuuŋ tsio eŋaeŋa ŋgara le nitaghoni kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Tutuuŋ tsio tau tigheen pataghaaŋ na, yau naghe le nayaryaaŋ pa taghoniiŋ zi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Pa ighe matag iŋgalŋgal tutuuŋ tsio tisov, ene irau mayag ila eval tiina matazi mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Eez tsio to gabizooŋ gabua, ene iduduuŋ mon. Isaav ighe upaghazoŋai ghau pani, ene aat lolog poia payo, ve napait ghom toman lolog ŋgalaaŋa. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Tutuuŋ tsio naol tau tigheen pataghaaŋ na, yau aat matag kisin zi ve nataghon zi irau saawe. Tauvene ughur murim payau sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Isaav ighe ŋeer paaghu eta maata iŋgal tauu ve ighe laghooŋ tooni iŋgalaaŋ mon ila yo matam, ene pale igham saa? I aat maata iŋgal aliŋam ve itaghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Yau naghur lolog isov iŋarui ghom, ve nazuari ghau naghe le nawatagh katin ghom. Tauvene upul ghau nasapir pa tutuuŋ tsio sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Yau naghita aliŋam imin gabua tauu. Tauvene naghur poghania ila lolog. Leso ipalot ghau, ve nagham sosor payo sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Yoova, yau napait ghom pa poia tsio. Upaghazoŋai ghau pa tutuuŋ tsio naol tau tigheen pataghaaŋ na. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Tutuuŋ tsio naol tau yo uvoti zi na, avog pale isavi zi le tisov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Eez tau yo ughuru payei na, saawe tau nataghoni, ene igham lolog poia kat, imin yes tau tipakur zi pa kuaz to taan. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Matag itaghon tutuuŋ tsio eŋaeŋa ŋgara naghe le naghazooŋ pazi. Ve matag iŋgalŋgal eez tsio irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Tutuuŋ tsio naol tau tigheen pataghaaŋ na, tigham lolog poia le poia kat. Irau lolog iveegh pa aliŋam mako. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","O Yoova, yau besooŋa tsio. Utotoi poia tsio payau. Leso naleep poia, ve nataghon aliŋam irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Upaghazoŋai ŋgar tsiau, leso naghilaal ŋgar popoia naol tau tighenaar ila saveeŋ tsio loolo na. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Taan tane, ene nugh tsiau duduuŋ mako. Yau naleep namin loom pani mon. Tauvene ugham ghau naghazooŋ pa tutuuŋ tsio naol ŋgara. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Saawe isov, yau napasawal naghe le utotoi ghau pa eez tsio to gabizooŋ gabua, o poi! ");
INSERT INTO tuc_t_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Yes tau tivelegh ghom ve tipapait tauzi na, yo uyaonyaon zi, ve aatyavyav tsio izazaa toozi. Pasaa, tisasapir pa tutuuŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ve yau, o matag kisin eez tau yo ughuru payei na, ve nataghoni irau saawe. Tauvene saveeŋ veleghiiŋ ve mayaŋa tau tisiksik zi payau ne, upaghau zi payau. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Yes daaba tau tighamgham pooz na paam, tilup zi ve tiliil eez tighe tivaghamun ghau. Eemon yau besooŋa tsio. Tauvene yau aat matag itaghon tutuuŋ tsio naol tau tigheen pataghaaŋ na, ve nagham ŋgar pazi poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Eez tau yo ughuru payei, ene igham ghau lolog poia le poia kat. Ve ipaduduuŋ ghau, leso nawatagh saa ŋgar tau pale nataghoni. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Yau tapirig isov, ve rigmon kanaŋ namaat ve nagheen ila ŋgaupup. Upaburigin ghau, ve ugham tapirig ivot muul itaghon saveeŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ŋgar isov tau naghamgham zi, ene yau navoti zi payo. Tauta ulooŋ suŋuuŋ tsiau ve uul ghau. Upaghazoŋai ghau pa tutuuŋ tsio naol tau tigheen pataghaaŋ na. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Tutuuŋ naol tau yo ughur zi na, upaghazoŋai ghau pa eez to taghoniiŋ zi. Ve yau aat matag itaghon uraat tsio ŋgeretazi, ve nagham ŋgar pazi poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Yau lolog ipataŋan le tapirig isov. Upalot ghau itaghon saveeŋ mbuaaŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Uul ghau to naleep soghan pa ŋgar karom. Saveeŋ tsio, ene imin eez to poia tsio izaa tsiau. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Yau lolog ighur naghe yau aat nataghon eez to saveeŋ onoon. Ve matag iŋgalŋgal eez tsio to gabizooŋ gabua. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Yoova, eez tau yo ughuru payei na, yau nakisi igheen tuŋia ila lolog. Tauvene upul ghau sov! Pale mayag. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Yo upaghazoŋai ghau pa gabua katini. Tauta tinig izaa pa taghoniiŋ eez to tutuuŋ tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Yoova, tutuuŋ tsio naol tau tigheen pataghaaŋ na, upaghazoŋai ghau pa eez to taghoniiŋ zi. Leso matag kisin zi, ve nataghon zi ila ila le saawe tsiau isov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Upaghazoŋai ghau pa saveeŋ tsio ŋgara. Leso matag kisini, ve nataghoni toman lolog irau saawe. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Umuuŋ ve utotoi eez payau, leso nataghon tutuuŋ tsio. Pa eez tana, ta igham lolog poia le poia kat. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Upaburigin lolog, leso nataghon eez tau yo ughuru payei na, ve nagham ŋgar pa ndouŋ leg kuaz to taan sov. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Upaghau matag pa gabua soroksorok to taan tau anoŋazi mako na, ve upalot ghau to nataghon eez tsio. Leso naleep poi. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Yau besooŋa tsio. Tauvene matam iŋgal saveeŋ mbuaaŋ tsio, ve ugham anooŋa ivot payau. Saveeŋ tsio tana iŋarui tamtamon tisov tau tiroi payo ve titaghon ŋgar tsio. ");
INSERT INTO tuc_t_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Saveeŋ saghati tau koiagŋa tisiksiki payau na, ene igham ghau naroi. Pa isaav ighe tamtamon tighur ila saveeŋ toozi tawe, ene pale m