﻿USE sofia;
DROP TABLE IF EXISTS sofia.tuc_o_vpl;
CREATE TABLE tuc_o_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tuc_o_vpl WRITE;
INSERT INTO tuc_o_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Muuŋ kat, Maaron ighur sambam ve taan toman mbeb tisob tivot muuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Sawa tonenen, ndug balim, ve mbeb eta ineep tuŋia ila ina sone. Ya moghon to ivon le irau ndug, ve ndoroom tiina ikau ndug. Ve Maaron Avuvu ilala inimnim izala te pogho. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ghoro Maaron isaav ighaze: “Ghazooŋa ivot.” Tovenen ghazooŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Maaron ighita ghazooŋa tonowen poia, ve ivalagi ila saguan pa ndoroom. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ghazooŋa tonenen, ye iwaata ighaze “ndag,” ve ndoroom, ye iwaata ighaze “mboŋ.” Mboŋ tonenen ila ve ndugizau, nene ndag to ivot muuŋ ne isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Maaron isaav muul ighaze: “Mbeb ariaŋa eta ivot, leso ivalag ya inim ru. Suruvu ineep izala sala, ve suruvu ineep izi sila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tovenen mbeb tonenen ivot itaghon ye tau aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mbeb ariaŋa tonowen, ye iwaata ighaze “sambam paroŋania.” Mboŋ tonenen ila ve ndugizau, nene ndag inim ru isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Maaron isaav muul ighaze: “Ya to ineep ila sambam paroŋania, ila ilup ila dige ee moghon, ve ndug imamaas.” Tovenen mbeb tonenen ivot itaghon ye tau aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ndug mamaasa tonowen, ye iwaata ighaze “taan.” Ve ya to ila ilup ila dige eez, nene ye iwaata ighaze “te.” Ve Maaron ighita poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Maaron isaav muul ighaze: “Ai naol naol, toman waar, kikiliiŋ, ve aniiŋ naol naol tivot pa taan, ve titub tiza ve anoŋadi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tovenen mbeb tonowen titub tiza, itaghon ye tau aliŋa. Ve Maaron ighita poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mboŋ tonenen ila ve ndugizau, nene ndag inim tol isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Maaron isaav muul ighaze: “Mbeb pida tivot ila sambam paroŋania. Leso tisul taan, ve tivalag ndag ve mboŋ, ve tinim ghilalooŋ pa kaiyo, ndaman, ve sawa pida paam.” Tovenen mbeb naol tonowen tivot titaghon ye tau aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Maaron ighur mbeb tintina ru toman pitum. Mbeb tiina kat ighaaz pa ndag, ve mbeb tiina ite ighaaz pa mboŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Maaron ighur mbeb naol tonenen tila sambam paroŋania. Leso tisul pa mboŋ ve ndag, ve tivalag ndoroom ve ghazooŋa. Ve Maaron ighita poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mboŋ tonenen ila ve ndugizau, nene ndag inim paaŋ isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Maaron isaav muul ighaze: “Te ivon pa iigh toman mbeb naol naol to matadi iyaryaar. Ve man naol tivot ve tiroov ila tata paroŋania.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tovenen Maaron ighur mbeb tintina to te, toman mbeb naol naol to tineep ila te ve ya lolodi. Ve ighur man to naol ne paam. Ve Maaron ighita poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ve ighur poia toni iza todi ighaze: “Yam mbeb to aneep ila te ve ya, apoop ve amasa anim naol. Leso apavonin te ve ya. Ve yam man amasa anim naol ve aneep irau taan isob.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mboŋ tonenen ila ve ndugizau, nene ndag inim liim isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Maaron isaav muul ighaze: “Taan ivon pa ŋgai naol naol to su ve paanu, toman mbeb gegegeu to tindandarab ila taan.” Tovenen mbeb naol tonowen tivot titaghon ye tau aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Maaron ighur ŋgai naol naol to su ve paanu, toman mbeb tisob to tindandarab ila taan. Ve Maaron ighita poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ghoro Maaron isaav muul ighaze: “Iit tagharaat tamtoghon tinim iit tauud, leso tigham naghood ve tiŋgin taan, ve iigh to te, man to tirovroov ila tata paroŋania, ŋgai naol naol, ve mbeb tisob to tindandarab ila taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tovenen Maaron ighur tamtoghon tinimale ye tau. Ighur di tigham ye tau nagho. Ighur nditamoot ve ndiliva. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ve Maaron ighur poia toni iza todi, ve isaav padi ighaze: “Yam apoop ve amasa anim naol, leso apavonin taan. Ve yam irau agham uraat pani, ve aŋgin poiani. Ve aŋgin iigh to te, man to tirovroov ila tata paroŋania, ve mbeb matadi yaryaara naol to tinepneep izi taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Maaron isaav padi muul ighaze: “Aghita. You nagham ndoor, aniiŋ, ve ai naol naol to titub izi taan ne anoŋadi tinim amim aniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ve ŋgai to tinepneep izi taan, ve man to tirovroov ila tata paroŋania, ve mbeb naol to tilaghlaagh ve tindandarab ila taan, you nagham kikiliiŋ ve ai raua inim adi aniiŋ.” Ve mbeb tonenen ivot itaghon ye tau aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Maaron ighita mbeb naol to ye ighur di ne, paghunadi kat. Mboŋ tonenen ila ve ndugizau, nene ndag inim liim ve eez isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nenen ataam to Maaron ighur sambam, taan, ve mbeb to naol ne tisob tivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sawa to inim liim ve ru pani, Maaron ate izi. Pasa, ye ipasob uraat toni isob wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tauto Maaron ipait sawa to inim liim ve ru pani, ve ighur poia toni ineep izala, ve ighuri inim umbom patabuaŋ. Pasa, sawa tonenen, ye ate izi pa uraat toni to ighur sambam, taan, ve mbeb tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nenen kamos to isavia sawa to Maaron Yoova ighur sambam paroŋania ve taan toman mbeb to naol ne tisob tivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Sawa to Maaron Yoova ighur sambam ve taan, mbeb eta itub sone. Ai itub sone, kikiliiŋ itub sone, taan ŋginiŋa moghon. Pasa, ye igham uman izi taan sone, ve tamtoghon eta ineep izi taan pa igham uraat pani sone. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Eemoghon ya to ineep ila taan lolo, tauto ivotvot ve ipapaluum taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Maaron Yoova ikor taan ila nima, ipoli, ve igharaata inim tamtoghon, ghoro ivib avuvu mata yaryaara ila uzu, ve tamtoghon tonowen imundig mata iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Taan suruvu eez to ineep ila pa ndag iza, iza Eden. Maaron Yoova ighur mbeb popoiadi titub ila uum tonowen lolo le paghuna kat. Ghoro ighur tamtoghon to ye tau igharaata ila ineep tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Maaron Yoova ighur ai naol naol titub ila uum tonenen lolo. Ai tonowen, popoiadi pa ghitooŋ, ve anoŋadi popoiadi pa ghaniiŋ paam. Ila bodbodaaŋ to uum, ai ru tiyondyood. Ai eez, igham ghiit taneep mataad iyaryaar. Ve ai ite, igham ghiit taghilaal ŋgar poia ve ŋgar samia. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ya eez ivot ila uum tonenen ve ipaluum taan. Ya tonowen ireer ve ivalagi inim boga paaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Boga eez, iza Pison. Nene ireer irau taan Avila isob. Taan Avila, gol popoia toman yaam popoia pida to tinim mbaliiŋ, tineep ila taan lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ve boga ite inim ru, iza Gion. Nene ireer irau taan Kus isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ve boga ite inim tol, iza Tigris. Nene ireer ila pa taan Asiria dige to ila pa ndag iza. Ve boga to inim paaŋ, iza Euprates. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Maaron Yoova igham tamtoghon tonenen, ve ighuri ila uum Eden, leso iŋgini ve igham uraat pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","17","Ve isaav pani ighaze: “Ai anoŋadi to naol ne, yom irau ughan di le tisob. Eemoghon ai to irau igham ghom ughilaal ŋgar poia ve ŋgar samia, ai ee moghon tonowen, ughan anoŋa malep. Pasa, sawa to ighaze ughani, yom pale umaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ghoro Maaron Yoova mata iŋgal ighaze: “Tamtoghon tonene eŋgeni ineep, nene poia maau. You irau naghur le ita ite eta pa iuuli.” ");
INSERT INTO tuc_o_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tovenen Maaron Yoova ikor taan ila nima, ipoli, ve igharaat ŋgai naol naol to tilaghlaagh ila taan, ve man to tirovroov ila tata paroŋania. Le isob, ghoro ilup di ve igham di tila to tamtoghon tonenen, leso ighita: Pale iwaat izadi vena? Ve izadi to ye iwaat di, nene tinim mbeb tonowen izadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ye iwaat ŋgai naol naol to paanu ve su izadi, ve iwaat man izadi paam. Eemoghon mbeb eta ighur pani leso inim ita ite pa iuuli ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tovenen Maaron Yoova igham tamoot igheenmaat, ve ipas raŋoraŋo eez ivot, ve ipoona muul pa minda. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ghoro igham tamoot raŋoraŋo tonowen, ve igharaata inim liva, ve ighuri ila to tamoot. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tamoot ighita liva tonowen, ve isaav ighaze: “Aa ghara leg itag ite! Tua, nene you tuag. Ve minda, nene you mindag. You pale nawaata naghaze ‘liva.’ Pasa, ye ivot ila to you tamoot.” ");
INSERT INTO tuc_o_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Pughu tonene to tamoot eta ighaze ivai, ye pale ipul tama yesuru tina, ve yesuru azuwa tilup di tinim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Sawa tonenen, tamoot yesuru azuwa tinidi ŋginiŋa. Eemoghon mayadi pa taudi maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Moot inepneep izi uum paam. Ye le ŋgar tiina kat pa ghamuuŋ kaarom ilib pa ŋgai tisob to Maaron Yoova ighur di. Sawa eez, ye ighason liva ighaze: “Vena? Ai anoŋadi naol to tineep ila uum lolo, Maaron Yoova iŋgalsekin gham padi ighaze aghan di malep. Nene onoon?” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Liva ipamuul aliŋa ighaze: “Maau. Maaron isaav ighaze: Ai naol to tiyoon ila uum lolo, yei irau nighan anoŋadi le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ai ee moghon kat to iyoon ila bodbodaaŋ to uum, tauto ye iŋgalsekin ghei pani ighaze nighani malep, ve nikisi malep. Pasa, ighaze nighani, ma nikisi, nene pale nimaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Moot isaav pani muul ighaze: “Maau. Yamru irau amaat maau. Maaron iwatag: Ighaze yamru aghan ai tonowen anoŋa, nene pale matamim pakia ve ŋgar tiam ighazooŋ, le anim ye tau, ve aghilaal ŋgar poia ve ŋgar samia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Liva ighita ai anoŋa tonowen paghuna kat pa mata ve poia pa ghaniiŋ paam. Ye lolo pani kat pasa, ighaze ai anoŋa tonenen pale igham ŋgar toni ighazooŋ. Tovenen ighami ve ighani, ve igham pida pa azuwa ve ana ighan paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yesuru tighani le isob, ghoro matadi pakia ve tighilaal tighaze tinidi ŋginiŋa. Tovenen yesuru tila tigham ai raua ve tidagini, ve tipoon di pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Rabrab izi ve ndug iluum, ghoro yesuru tilooŋ Maaron Yoova ilaghlaagh ila uum lolo. Tovenen tila tiyooŋ pani ila ai lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Maaron ipoi tamoot ighaze: “Ou, taum sine?” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tamoot ipamuul aliŋa ighaze: “You nalooŋ aghem avolutu ila uum lolo, tovenen namatughez payom ve nayooŋ. Pasa, tinig ŋginiŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tovenen Maaron ighasoni ighaze: “Sei isaav payom ighaze tinim ŋginiŋa? Ai to you naŋgalsekin ghom pani, yom avaat ughan anoŋa eta wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tamoot ipamuul Maaron aliŋa ighaze: “You maau. Liva to yom ugham payou ughaze yeru nineep, tauto igham ai tonowen anoŋa pida payou ve naghani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tovenen Maaron Yoova isaav pa liva ana ighaze: “Yom ugham ŋgar tonene pasa?” Liva ipamuul Maaron aliŋa ighaze: “You maau. Moot itombaan ghou, tauto naghani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tovenen Maaron Yoova isaav pa moot ighaze: “Yom to unum pughu pa sosor tonene. Tauto pataŋani tiina kat pale iza tiom ilib pa ŋgai tisob to paanu ve su. Yom pale undarab ila atem, ve ughan ghavuur to taan ila ila le irau mateeŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ve you pale naghur koi ineep ila yom ve liva sosomim. Ve paghu tiom ve paghu toni tovene paam. Koi pale ineep ila sosodi. Paghu to liva pale ivazag dabam ve imumi. Ve yom pale uŋaaŋ aghe gudu.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ghoro Maaron isaav pa liva ighaze: “You pale naghur pataŋani payom tovene: Ighaze yom apom, nene pale pataŋani tiina igham ghom. Ve sawa to ighaze upoop, yom pale uyamaan yabyabuuŋ tiina kat. Eemoghon lolom pale ineep ariaŋa ila to azuwam, ve uneep ila ye samba.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ghoro Maaron isaav pa tamoot ighaze: “Yom ulooŋ azuwam aliŋa, ve ughan ai anoŋa to you naŋgalsekin ghom pani. Tovenen you pale nawaghamun taan. Nepooŋam izi taan, yom pale ugham uraat tiina, ve uyamaan katin pataŋani, ghoro ughita anoŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pasa, su samsamia ve waar mata mata pale titub tiza ve tiwaghamun uum tiom. Eemoghon yom pale ughan ila uum tonanan. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tovenen yom pale urab taum pa uraat le ughun wadedeŋam, ghoro ughita uraat tiom anoŋa ve ughan. Ve pataŋani tovene pale ikiskis ghom le irau mateeŋ tiom. Pasa, you nagharaat ghom pa taan. Tovenen yom pale umuul ula unum taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tamoot iwaat azuwa iza Eva. Pasa, ye pale inim ival tisob to tineep izi taan ne tinandi. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Muri ghoro, Maaron Yoova igharaat ŋgai uli inim nonogiiŋa pa Adam yesuru azuwa, ve indud di pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ghoro Maaron Yoova isaav ighaze: “Laak. Tamtoghon ŋgar todi ivot inimale iit, ve tighilaal ŋgar poia ve ŋgar samia wa. Tovenen iit irau tapul di tineep uum tonene muul maau. Pasa, ighaze nimadi ila pa ai to igham di tineep matadi iyaryaar ne anoŋa ve tighani paam, nene pale tineep tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tovenen Maaron Yoova indiir di pa uum Eden. Leso tila tigham uraat pa taan to yesuru tivot pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ye indiir di tivot tila, ghoro ighur aŋela ariaŋadi pida tila tiyoon ila uum dige to ndag iza pani. Yes tiyondyood toman buza eez to yab ighanghan ila mata ve itortoora. Leso tipoon ataam to ila pa ai to mataad iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Muri ghoro, Adam yesuru azuwa tigheen ve Eva apo. Ye ipoop natu tamoot ve iwaat iza Kain. Ve isaav ighaze: “Maaron iuul ghou, tauto napoop natug tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tinepneep le muri ghoro, Eva ipoop Kain tazi Abel. Yesuru tinim ndolman, ghoro Abel iŋginŋgin sipsip, ve Kain ighamgham uraat pa uum. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sawa eez, Kain igham aniiŋ anoŋa pida to tivot ila uum toni inim watooŋrau pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ve Abel paam irab sipsip toni ndinatu aidaba pida, ve igham suruvudi to popoia kat ila pa Yoova tinim watooŋrau pani. Yoova lolo poia pa Abel toman watooŋrau toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Eemoghon Kain toman watooŋrau toni, Yoova irere pani. Tauto Kain ate yabyab kat le nagho isami. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tovenen Yoova ighason Kain ighaze: “Pughu vena to atem yabyab ve naghom isami? ");
INSERT INTO tuc_o_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ighaze yom ugham ŋgar deŋia, pale lolog poia payom ve tinim iza. Eemoghon ighaze ugham ŋgar to deŋia maau, yom upatum ghom. Pasa, ŋgar samia inepneep ataam tiom avo, ve isasaŋan ghom ighaze igham ghom unum le. Tovenen yom irau uyoon ariaŋa ve utatan ŋgar samia tonanan izi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Muri ghoro, Kain isaav pa tazi Abel ighaze: “Unum ituru tala talaghlaagh uum lolo.” Yesuru tila tonowe, ghoro Kain imundig ve irab tazi Abel imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tovenen Yoova ighason Kain ighaze: “Kain, tazim Abel ineep sine?” Kain ipamuul aliŋa ighaze: “You nakankaan pani. Vena, you nanim ŋginiiŋ to tazig?” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ghoro Yoova isaav pani muul ighaze: “Yom ugham ŋgar tovene pasa? Ulooŋ. Tazim siŋ toni to imaliŋ izi taan, tauto imboboob iza inim tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yom urab tazim imaat, ve taan tonene ighun siŋ toni wa. Tovenen you pale naghur pataŋani tonene iŋarua ghom: Yom irau uneep muul izi taan tonene maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ve ighaze uvazog aniiŋ izila taan to ndug ite paam, nene pale ughita anoŋa eta maau. Yom pale irau uneep tuŋia izi ndug eta maau. Pale uwalaghlaagh irau taan naol.” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ilooŋ saveeŋ tonene, ve isaav pa Yoova ighaze: “Atia to sosor tiou to yom ughuri payou, nene pataŋani kat. Irau nambaada maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ughita. Aazne, yom undiir ghou pa taan tonene ve ughaze nala naneep saguan payom. Ve ughaze you irau naneep tuŋia izi ndug eta maau. Pale nawalaghlaagh irau taan naol, ve ighaze ŋgeu eta ighita ghou, ye pale irab ghou namaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Eemoghon Yoova isaav pani muul ighaze: “Maau. Ighaze ŋgeu eta irab ghom umaat, nene pale nayat ŋgeu tonanan sosor toni irau pa liim ve ru.” Ghoro Yoova ighur ghilalooŋ eez iza to Kain. Leso tamtoghon tighita ve tirabi sob. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kain ipul Yoova, ve ilaagh ila ivot taan suruvu eez, iza Nod, ve ineep tonowe. Taan tonowen ineep uum Eden dige ila pa ndag iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Muri ghoro, Kain yesuru azuwa tigheen, ve liva apo ve ipoop natu aidaba, iza Anok. Ghoro Kain igharaat ndug tiina eez, ve iwaat natu Anok iza pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Anok natu Irad, Irad natu Mehuyael, Mehuyael natu Metusael, ve Metusael natu Lamek. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ivai ndiliva ru. Eez iza Ada, ve ite iza Zila. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Lamek azuwa Ada to ipoop Yabal. Yabal papaghu toni, nene yes to tilaghlaagh toman ŋgai todi, ve tinepneep ila mbeez to tigharaat di pa ŋgai ulidi. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal tazi, iza Yubal. Papaghu toni, to tighagharaat sab to vibiiŋ ve mbeb pida tinimale gita. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek azuwa ite Zila ipoop Tuval-Kain. Tuval-Kain papaghu toni, to tighagharaat ain ve baras tinim mbeb pida to uraat. Tuval-Kain livu iza Naama. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sawa eez, Lamek isaav pa ndizuwa ru ighaze: “Ada yamru Zila, alooŋ aliŋag. You Lamek ndizwag to yamru. Aghur taliŋamim pa saveeŋ tiou. Ighaze ŋgeu eta irab ghou le siŋ tiou izi, you pale narabi imaat. Ve ighaze pain eta ipambar ghou, nene pale narabi imaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Alooŋ. Ighaze tamtoghon eta irab Kain imaat, nene pale tiyat ŋgar toni irau pa liim ve ru. Eemoghon you, ighaze tirab ghou namaat, nene pale tiyat ŋgar todi irau pa tamoot tol saaŋgul liim ve ru (77).” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam yesuru azuwa Eva tilup di muul, ve Eva apo, ve ipoop tamoot ite. Ye iwaat iza Set, ve isaav ighaze: “Kain irab tazi Abel imaat, tauto Maaron igham leg tamtoghon ite tonene leso igham ina.” ");
INSERT INTO tuc_o_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Muri ghoro, Set yesuru azuwa tipoop tamoot eez, ve Set iwaat iza Enos. Sawa tonenen, tamtoghon tipamundigin ŋgar to suŋuuŋ pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nene pitiiŋ to Adam toman papaghu toni. Sawa to Maaron ighur tamtoghon, ighur di tinimale ye tau. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ighur tamoot ve liva. Ve ighur poia toni iza todi ve iwaat di ighaze “tamtoghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam ndaman toni irau 130, ghoro yesuru azuwa tipoop natudi eez. Ye igham tama nagho. Yesuru raratedi kat. Adam iwaat iza Set. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set izi, ve Adam ineep muul irau ndaman 800, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tovenen Adam ineep irau ndaman 930, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ndaman toni irau 105, ve yesuru azuwa tipoop natudi aidaba, iza Enos. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos izi, ve Set ineep muul irau ndaman 807, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tovenen Set ineep irau ndaman 912, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos ndaman toni irau 90, ve yesuru azuwa tipoop natudi aidaba, iza Kenan. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan izi, ve Enos ineep muul irau ndaman 815, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tovenen Enos ineep irau ndaman 905, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ndaman toni irau 70, ve yesuru azuwa tipoop natudi aidaba, iza Malalel. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malalel izi, ve Kenan ineep muul irau ndaman 840, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tovenen Kenan ineep irau ndaman 910, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalel ndaman toni irau 65, ve yesuru azuwa tipoop natudi aidaba, iza Yared. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yared izi, ve Malalel ineep muul irau ndaman 830, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tovenen Malalel ineep irau ndaman 895, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared ndaman toni irau 162, ve yesuru azuwa tipoop natudi aidaba, iza Enok. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok izi, ve Yared ineep muul irau ndaman 800, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tovenen Yared ineep irau ndaman 962, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok ndaman toni irau 65, ve yesuru azuwa tipoop natudi aidaba, iza Metusela. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Metusela izi, ve Enok ineep muul irau ndaman 300, ve tipoop ndinatudi nditamoot ve ndiliva pida. Enok nepooŋ toman laghooŋ toni, ye mata iŋgalŋgal Maaron ve itaghon ataam toni irau sawa isob. Tovenen ineep irau ndaman 365, ghoro Maaron ighami izala, ve tighita muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ndaman toni irau 187, ve yesuru azuwa tipoop natudi aidaba, iza Lamek. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek izi, ve Metusela ineep muul irau ndaman 782, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tovenen Metusela ineep irau ndaman 969, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek ndaman toni irau 182, ve yesuru azuwa tipoop natudi aidaba. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek ighaze: “Maaron iwaghamun taan, tauto nigham uraat tiina kat pa nikaal amai aniiŋ. Eemoghon natumai tonene pale igham ulaaŋ ivot payei pa uraat pataŋani to nighamghami pa nimamai.” Tauto iwaat natu tonowen iza Noa. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa izi, ve Lamek ineep muul irau ndaman 595, ve tipoop ndinatudi nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tovenen Lamek ineep irau ndaman 777, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa ndaman toni 500, ghoro yesuru azuwa tipoop ndinatudi nditamoot tol, izadi Sem, Ham, ve Yapet. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Sawa to tamtoghon timasa tinim naol izi taan, Maaron ndinatu tighita tamtoghon ndinatudi liva paghunadi kat. Tovenen tigham di irau taudi lolodi, ve tivai di. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yoova ighita mbeb tonenen, ve isaav ighaze: “Tamtoghon, nene yes taan sorok. Avuvug irau ineep toman di ve tineep matadi iyaryaar le alok ne maau. Pale tineep irau ndaman tamoot liim tamoot eez (120) moghon, ve sawa todi isob ve timaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sawa tonenen ve inim, tamtoghon to anoŋadi tintina ve tapiridi kat, tivot ve tineep izi taan. Nditamandi, nene Maaron ndinatu. Ve nditinandi, nene tamtoghon to taan ndinatudi liva. Ndiran tonowen tineep muuŋ. Yes tapiridi tintina ve ndiran to malmal, ve varudi ilaan irau ndug. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yoova ighita tamtoghon to tineep izi taan ne, gabuadi isami kat, ve ŋgar todi iyaryaaŋ pa ŋgar samsamia moghon irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Tovenen lolo ipataŋan kat pa tamtoghon to ye tau ighur di tizi taan, ve ikausim muul pa tau ighaze: “Wais, nagharaat di pasa? Nagharaat di maau, tone poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tambaŋa. You pale napasob tamtoghon le tisob pa taan. Ve yes moghon maau. Ŋgai, man, ve mbeb to tindandarab izi taan ne paam, you pale napasob di pa taan ve tisob tilaledi. Onoon, you taug nagharaat di. Eemoghon tighamgham ŋgar samsamia naol. Tauto tigham ghou tinig imum padi kat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Eemoghon Noa, Yoova ighita ighaze ye ŋgeu poia, ve lolo pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nene kamos to Noa toman papaghu toni. Sawa to Noa, ye moghon to ŋgeu deŋia, ve le sosor maau. Nepooŋ to Noa toman laghooŋ toni, ye mata iŋgalŋgal Maaron ve itaghon ataam toni irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa ndinatu tol, izadi Sem, Ham, ve Yapet. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Sawa tonenen, Maaron ighita ŋgar samsamia naol tivotvot irau taan isob. Ve ŋgar to ghamuuŋ malmal paam, ivot tiina le irau ndug tisob. Tovenen ye ighita taan isami kat. Pasa, tamtoghon tisob tiwaghamun nepooŋ todi izi taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tovenen Maaron isaav pa Noa ighaze: “Ulooŋ. You naghita tamtoghon tighamgham malmal irau taan isob. Tauto matag iŋgal naghaze napasob tamtoghon pa taan. You pale nawaghamun di toman taan ve mbeb naol to tineep izi taan le tisob tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tovenen yom irau ughuz lem waaŋ eta. Ughita ai ariaŋadi, ve usap di, leso ughuz waaŋ pani. Urab motmotin waaŋ lolo inim naol. Ve uŋgal ndimir ila waaŋ lolo ve pumuri paam. Leso te ilooŋ ila sob. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nene ataam to yom irau utaghoni: Mala to waaŋ, uroova irau roov tamoot tol saaŋgul ve liim (133 mita), ve tuku toni irau roov saaŋgul ve ru (22 mita), ve lolo izala sala ve izi inim sila, nene irau roov liim ve ru (13 mita). ");
INSERT INTO tuc_o_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ve urei waaŋ ruuma. Eemoghon urab didiiŋ izala tuŋia malep. Upul soso ris inim marai saambu. Leso yaghur toman ghazooŋa itaghoni. Ve ughur ataam ila waaŋ dige. Sawa to ughuz waaŋ, ughur lolo inim sosoor tol: eez ineep sila, ite ineep bodbodaaŋ, ve ite ineep sala. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Ulooŋ. You naghaze nagham ya ivon toman tapiri tiina le itatab taan. Leso ireu mbeb to matadi yaryaara tisob tilaledi. Mbeb to tineep izi taan, pale tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Eemoghon you pale nambua saveeŋ ariaŋa toman ghom, leso talup ghiit tanim ee moghon. Tovenen yom irau ugham azuwam, ndinatum tol toman ndizwadi ve yamŋa alooŋ ala waaŋ lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ve uyou mbeb naol naol to matadi iyaryaar ne, ve asob alooŋ ala waaŋ lolo. Ugham ŋgai, man, ve mbeb naol to tindandarab ila taan ne paam. Ugham ruŋaruŋa, tamoot ve paŋgaar. Leso timaat sob. ");
INSERT INTO tuc_o_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ve uyou aniiŋ naol naol ve uzeev di tilooŋ tila waaŋ lolo. Leso yam ve mbeb naol to yamŋa aneep ila waaŋ lolo ne, amim aniiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Maaron isavia saveeŋ tonenen le isob, ghoro Noa ila ve igham uraata. Saveeŋ to Maaron isavia pani, ye itaghoni le isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Muri ghoro, Yoova isaav pa Noa ighaze: “You naghita tamtoghon to tineep pa sawa tonene, yom eŋgengom to utaghon ŋgar deŋia ila matag. Tovenen umundig, ugham azuwam toman ndinatum tol ve ndizwadi, ve yamŋa alooŋ ala waaŋ lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ve ŋgai naol naol to popoiadi pa watooŋrau, ugham nditamoot liim ve ru ve paŋgaar liim ve ru, tilooŋ tila waaŋ lolo. Ve mbeb pida to popoiadi pa watooŋrau maau, ugham ruŋaruŋa, tamoot eez ve liva eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ve ugham man naol naol to tirovroov ila tata paroŋania paam. Ugham nditamoot liim ve ru, ve paŋgaar liim ve ru. Leso timaat sob, ve muri tipoop, ve timasa tinim naol, ve tirau taan muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pasa, mboŋ liim ve ru tonene isob, ghoro nagham uman tiina izi taan le irau mboŋ tamoot ru. Leso napasob mbeb matadi yaryaara to naghur di le tisob pa taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yoova isavia saveeŋ tonene le isob, ghoro Noa ila igham uraata. Saveeŋ to Maaron isavia pani, ye itaghoni le isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ndaman toni irau 600, ghoro ya ivon izi taan toman yawaaŋa tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tovenen Noa yesuru azuwa, ndinatu, ve ndirawa liva tisob tilooŋ tila waaŋ lolo. Leso yawaaŋa iwaghamun di sob, ve tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ve ŋgai naol naol to popoiadi pa watooŋrau, toman mbeb naol to irau tigham watooŋrau padi maau ne, ve man to tirovroov, toman mbeb naol to tindandarab ila taan, nene ruŋaruŋa, tamoot ve paŋgaar, tila tivot to Noa, ve yesŋa Noa tilooŋ tila waaŋ lolo itaghon saveeŋ to Maaron isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tilooŋ tila waaŋ lolo, ve tineep mboŋ liim ve ru le isob, ghoro ya ivon toman yawaaŋa tiina, le itatab taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tovenen indeeŋ Noa ndaman toni irau 600, kaiyo inim ru pani, ve mboŋ inim saaŋgul liim ve ru pani, ghoro taan avo ikaak, ve ya tiina to ineep taan lolo, bokia iza toman tapiri tiina. Ve tata tovene paam. Avo ikaak, ve ya to ineep sala, imaliŋ izi toman tapiri tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tovenen uman tiina kat izi taan le irau ndag tamoot ru ve mboŋ tamoot ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Sawa kat tonenen, Noa yesuru azuwa, ve ndinatu tol, Sem, Ham ve Yapet, toman ndizwadi, tilooŋ tila waaŋ lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ve ŋgai naol naol to paanu ve su, toman mbeb naol naol to tindandarab ila taan, ve man naol naol titaghon di ve yesŋa tilooŋ tila waaŋ lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Tovenen mbeb tisob to matadi iyaryaar, ruŋaruŋa, nditamoot ve paŋgaar, tilooŋ tila waaŋ lolo, titaghon Maaron aliŋa. Ghoro Noa ana ilooŋ ila, ve Yoova tau ipoon ataam to waaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ya ivon iza, le itatab taan irau mboŋ tamoot ru, ve ipapotin waaŋ ve iza ipot. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ya iza iza le waaŋ imoghan. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ya iza le ivon toman tapiri tiina kat, le itatab lolooz tintina tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ya ivon izala le ilib pa lolooz to naol ne dabadi irau roov paaŋ (8 mita). ");
INSERT INTO tuc_o_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tovenen mbeb to tinepneep izi taan, tisob timatmaat. Ŋgai to paanu, ŋgai to su, man, ve mbeb naol to tindandarab ila taan, toman tamtoghon paam timatmaat le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mbeb to tineep izi taan ve tighamgham yaghur, tauto tisob tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nene ataam to Maaron ipasob mbeb tisob pa taan. Tamtoghon, ŋgai, mbeb to tindandarab ila taan, ve man to tirovroov ila tata paroŋania, eta ineep muul maau. Tisob tilaledi. Eemoghon yes to tineep toman Noa ila waaŋ lolo, yes moghon to tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tovenen ya itatab taan, ve ipot irau mboŋ 150 (kaiyo liim ma venen). ");
INSERT INTO tuc_o_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Eemoghon Maaron mata iŋgalŋgal Noa ve mbeb naol tisob to su ve paanu to tineep tomani ila waaŋ lolo. Tovenen igham yaghur ilaagh izala ya pogho, leso iviviir ya ve izi. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ve taan avo to ya ivotvot pani toman tata avo to ya izi pani, nene tivool muul, ve uman imot. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Tauto ya izizi poipoi irau mboŋ 150. Indeeŋ kaiyo inim liim ve ru, ve ndag to inim saaŋgul liim ve ru pani, waaŋ ilot izala lolooz eez to taan Ararat daba. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ya izizi le kaiyo saaŋgul, ve ndag to ivot muuŋ, ghoro lolooz dabadi perperia. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Mboŋ tamoot ru paam inim ila, ghoro Noa ikaak marai saambu, ve imbaaŋ man kool eez ila. Man tonowen iwarovroov le ya imaak. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noa ighaze iwatag: Ya imaak wa, ma sone? Tovenen imbaaŋ man mbaluuz eez ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Eemoghon ya imaak kat sone. Tovenen man mbaluuz tonowen irau indeeŋ ina poia eta pa ate izi maau, ve iroov imuul ila pa waaŋ. Noa izuzuun nima ivot ila pumuri, ve man mbaluuz tonenen iroov inim le imbutur izala, ve Noa ighami ilooŋ ila waaŋ lolo muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa isaŋan le mboŋ liim ve ru isob, ghoro imbaaŋ man mbaluuz tonenen iroov muul ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ila irovroov le rabrab izi, ghoro iŋaaŋ ai oliv mbila eez ila dadabu, ve iroov imuul ila pa waaŋ. Tovenen Noa iwatag ighaze ya imaak wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa isaŋan le mboŋ liim ve ru muul isob, ghoro ipul man mbaluuz iroov muul ila. Sawa tonenen, ila le imuul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tovenen sawa to Noa ndaman toni irau 601, kaiyo to ivot muuŋ, ve ndag inim mata, taan imamaas wa. Tovenen Noa ipas atob pida pa waaŋ ve iŋgig ndug, ve ighita taan imamaas. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Indeeŋ kaiyo inim ru, ve mboŋi inim tamoot ee liim ve ru, taan imamaas kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Tovenen Maaron isaav pa Noa ighaze: “Yamru azuwam, ndinatum, ve ndirawam liva, apul waaŋ, ve avot ala pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ve ugham mbeb matadi yaryaara naol to yamŋa aneep ila waaŋ lolo tivot tila pumuri paam. Leso tilaagh irau taan ve timasa tinim katindi, ve tineep irau taan muul.” ");
INSERT INTO tuc_o_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tovenen Noa yesuru azuwa, toman ndinatu ve ndirawa liva tipul waaŋ, ve tivot tila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ve ŋgai naol naol, man, ve mbeb to tindandarab ila taan, nene tisob tighur di tila ketooŋadi, ve tipul waaŋ, ve tivot tila pumuri paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ghoro Noa indou yaam inim artaal pa Yoova. Ve ŋgai ve man tisob to popoiadi pa watooŋrau, ye igham eŋaeŋa ve irab di timaat. Ghoro ighur di tizala artaal pogho, ve yab ighan suvun di tinim watooŋrau pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yoova iyaaz watooŋrau tonowen vuzi poia kat, ve isaav ila lolo ighaze: “Muri, you irau nawaghamun taan pa sosor to tamtoghon muul maau. Pasa, you nawatag: Sawa to yes ndipain papaghu ve inim, ŋgar samsamia iyaryaaŋ ila lolodi. Tovenen you irau nawaghamun mbeb matadi yaryaara muul inimale aazne naghami ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Aazne ve ila, sawa to vazogiiŋ aniiŋ, ve sawa to taitaiŋ, sawa to ndug yauŋa, ve sawa to ndug tuntunu, rag ve yavaar, mboŋ ve ndag. Mbeb naol tonowen irau tisob maau. Pale tineep tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Maaron ighur poia toni iza to Noa toman ndinatu, ve isaav padi ighaze: “Apoop, ve amasa anim naol, ve aneep irau taan muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ŋgai naol naol to tineep izi taan, toman man, iigh, ve mbeb soroksorok to tindandarab ila taan, nene pale matadi iza ve timatughez payam. You naghur di tilat nimamim. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Muuŋ, naghur mbeb naol to titub ila taan tinim aniiŋ payam. Ve aazne, you napul mbeb matadi yaryaara to naol ne payam paam, leso aghan di.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mbeb ee moghon to you naŋgalsekin gham pani. Mbeb minda to siŋ ineep ila, yam aghani malep. Pasa, siŋ to inim pughu pa mbeb tineep matadi iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tovenen ighaze ŋgeu eta, ma ŋgai eta irab tamtoghon imaat, you Maaron naghur atia pani tovene: Ye pale imaat paam. Leso iyat siŋ to tamtoghon tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tovenen ighaze ŋgeu eta irab tamtoghon eta imaat, nene pale ye paam tirabi imaat. Leso iyat siŋ to tamtoghon tonenen. Pasa, Maaron ighur tamtoghon tigham ye tau nagho. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","8","Ghoro Maaron isaav muul pa Noa toman ndinatu ighaze: “Yam apoop, ve amasa anim naol kat ve aneep irau taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ve alooŋ. You naghaze nambua saveeŋ pa yam ve papaghu tiam to pale tivot muri. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ve yam moghon maau. Mbeb matadi yaryaara tisob to paanu ve su to tineep toman gham ila waaŋ lolo, ve yamŋa avot ala pumuri, ve aazne tineep izi taan, saveeŋ mbuaaŋ tiou tonene iŋarua di paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","You nambua saveeŋ ariaŋa payam tovene: Irau nagham ya ivon muul toman yawaaŋa tiina pa nawaghamun mbeb matadi yaryaara maau. Ve taan tovene paam. Ya irau iwaghamuni muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ve Maaron isaav muul ighaze: “Maalraŋgo tiou to ineep ila yaghur tae ve izi, aazne naghuri inim ghilalooŋ pa saveeŋ mbuaaŋ tiou tonene. Saveeŋ tonene, you nambua toman gham, ve mbeb matadi yaryaara tisob to tineep toman gham izi taan. Saveeŋ tonene pale iyoon ariaŋa itaghoni taghoni gha ila. Tovenen maalraŋgo pale inim ghilalooŋ pa saveeŋ mbuaaŋ to you nambua toman mbeb tisob to tineep izi taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Muri, ighaze you naghur yaghur tae iyoon toman maalraŋgo, nene pale matag iŋgal saveeŋ to nambua toman gham ve mbeb matadi yaryaara tisob. Saveeŋ mbuaaŋ tovene: Ya irau ivon le iwaghamun gham muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tovenen maalraŋgo ighaze ivot toman yaghur tae, nene pale naghita, ve matag iŋgal saveeŋ to nambua toman mbeb matadi yaryaara tisob to tineep izi taan. Saveeŋ tonene pale iyoon tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tovenen Maaron isaav pa Noa ighaze: “Maalraŋgo, nene inim ghilalooŋ pa saveeŋ to you nambua toman mbeb matadi yaryaara tisob to tineep izi taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa ndinatu tol to yesŋa tineep ila waaŋ lolo ve tivot tila pumuri ne, izadi tovene: Sem, Ham, ve Yapet. Ham natu, iza Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ival tisob to tineep izi taan, yes tivot ila to Noa ndinatu tol tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa, ye ŋgeu to ghamuuŋ uraat pa uum, ve ye to ivazog vaen muuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sawa eez, ye ighun vaen le iyamaan tau maau, ve uli toni imaruat. Tovenen igheen tini ŋginiŋa ila mbeez toni lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Noa natu Ham, to Kanaan tama, ighita tama igheen tini ŋginiŋa, ve ivot ila pumuri ve ipaes pa nditogha. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Eemoghon Sem yesuru Yapet tigham uli eez, ve tipiyaava izala avaradi, ve tilaagh pa muridi tila, ve tipoon tamandi pani. Pasa, lolodi pa tighita tamandi tini ŋginiŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sawa to Noa imundig ve ŋgar toni ighazooŋ, ilooŋ tighaze natu Ham ighita igheen tini ŋginiŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tovenen isaav pani ighaze: “Pataŋani tonene pale iŋarua Kanaan. Ye toman papaghu toni pale tinim mbesooŋa sorok pa toŋvetaz todi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","Ve Noa ighur poia iza to Sem ve Yapet tovene: “Iit tapait Yoova. Ye Maaron to Sem. Kanaan papaghu toni pale tinim uraata sorok pa papaghu to Sem. Ve Yapet papaghu toni, Maaron pale igham di timasa tinim naol, ve induur taan todi ila inim tiina. Yesŋa Sem papaghu toni pale tilup di tinim ee moghon. Eemoghon yes Kanaana pale tinim uraata sorok pa Yapet papaghu toni.” ");
INSERT INTO tuc_o_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Yawaaŋa tiina ivot le isob, ghoro Noa ineep muul irau ndaman 350. Tovenen ndaman toni inim 950, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nene pitiiŋ to Noa ndinatu ve papaghu todi. Noa ndinatu, nene: Sem, Ham, ve Yapet. Yawaaŋa tiina ivot le isob, ghoro papaghu todi tivot tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapet ndinatu, nene: Gomer, Magog, Madai, Yaban, Tubal, Mesek, ve Tiras. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer ndinatu, nene: Askenaz, Ripat, ve Togarma. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaban ndinatu, nene: Elisa, Tarsis, Kitim, ve Dodanim. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yes tonene to Yapet nditimbu. Yes tivot tinim naol, ve tila tineep irau naari ve mutu. Pughudi eŋaeŋa tila tineep irau ndug todi todi, ve tisavia taudi aliŋadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham ndinatu, nene: Kus, Isip, Put, ve Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ve Kus ndinatu, nene: Seba, Avila, Sapta, Rama, ve Sapteka. Rama ndinatu, nene: Siba ve Dedan. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus natu ite, iza Nimrot. Nimrot iza tiina pasa, ye iraua kat pa ŋgar to ghamuuŋ malmal. Ilib pa ival tiina to taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ve ye ŋgeu to kalooŋ ŋgai sagsag. Tovenen muri, ighaze tipait ŋgeu eta iza, ghoro tiparim pani tovene: “Ŋgeu tonene, Yoova igham le ŋgar tiina pa kalooŋ ŋgai sagsag inimale Nimrot.” ");
INSERT INTO tuc_o_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrot iŋgin taan suruvu tiina eez, iza Sinar. Taan tonowen, ndug tintina tol tineep ila, izadi Babel, Erek, ve Akad. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Muri ghoro, Nimrot ipul taan to Babilon, ve ila pa taan suruvu to Asiria, ve ipamundigin ndug tintina paaŋ, izadi Ninive, Reobot-Ir, Kala, ve Resen. Ndug Resen, nene ineep bodbodaaŋ pa ndug tiina Ninive ve ndug Kala. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isip ndinatu, nene: Lud, Anam, Leap, Naptu, Patrus, Kaslu, ve Kaptor. Kaslu to yes Pilistia tivot ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","19","Kanaan natu aidaba Sidon, ve nditazi, nene: Het, Yebus, Amor, Girgas, Hiv, Aki, Sini, Arvad, Semar, ve Amat. Muri ghoro, papaghu to Kanaan timbiriis, ve tila tineep irau ndug todi todi. Taan todi ila imuul to ndug Sidon, ve itaghon naari ila imuul ndug Gerar ve ndug Gaza. Ghoro imbuti ilooŋ ila pa taan to ndug Sodom, Gomora, Adma, ve Seboim, le malmali ila ivool pa ndug Lasa. Nene taan to yes Kanaana. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yes tonenen, to tivot ila to Ham. Yes tivot tinim naol, ve pughudi eŋaeŋa tila tineep irau ndug todi todi, ve tisavia taudi aliŋadi eŋaeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yapet togha Sem ndinatu timasa tinim naol, ve tinim pughu pa Eber. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem ndinatu, nene: Elam, Asur, Apaksad, Lud, ve Aram. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ndinatu, nene: Uz, Ul, Geter, ve Mas. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apaksad natu Sela. Ve Sela natu, Eber. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ndinatu ru. Eez iza Peleg, ve ite iza Yoktan. Sawa to Peleg ineep izi taan, tamtoghon to taan tivalag taudi, ve tila tineep ledi ledi. Tauto tiwaat iza Peleg. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Yoktan ndinatu, nene: Almodad, Selep, Azamavet, Yera, Adoram, Uzal, Dikla, Obal, Abimael, Seba, Opir, Avila, ve Yobab. Yes tisob tonene Yoktan ndinatu. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Taan todi, ndug Mesa inim ŋgat pani, ve ila imuul lolooz to taan Separ to ineep ila pa ndag iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yes tonenen to tivot ila to Sem. Yes tivot tinim naol, ve pughudi eŋaeŋa tila tineep irau ndug todi todi, ve tisavia taudi aliŋadi eŋaeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yes tonene, Noa ndinatu papaghu todi. Yawaaŋa tiina ivot le isob, ghoro yes timasa tinim naol, ve tila tineep irau taan to naol ne, ve tinim ival tisob to taan pughudi ");
INSERT INTO tuc_o_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Muuŋ, tamtoghon to tineep izi taan, tisob tisavia aliŋadi ee moghon, ve saveeŋ todi raraate. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yes tineep izi ndug ee moghon maau. Tindurnduur tilala pa ndag iza, le tivot izi taan raapa eez to ineep ila taan suruvu to Sinar, ve tighur inadi to nepooŋ tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ghoro tiwasavon di tighaze: “Laak! Iit irau tapol taan ve tamozi ila yab. Leso iyaryaaŋ kat inimale yaam ve tagharaat ruum pani.” Tigham tovene, ve ledi mbeb ivot pa reiŋ ruum. Ve tigham mbeb ite inimale ndimir pa ikor yaam tonowen le tuŋia. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ghoro tisaav tighaze: “Laak! Iit irau tagharaat leed ndug tiina eta, ve tarei rumai tiina eta to daba izala le ikis tata. Leso izaad ivot inim tiina. Ve mbeb ite. Uraat tiina tonene pale ilup ghiit tanim ee moghon. Pa vene, tambiriis ve taneep leed leed irau taan to naol ne.” ");
INSERT INTO tuc_o_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yes tigham mbeb tonene le isob, ghoro Yoova izi inim ighaze ighita ndug todi tiina tonowen ve rumai to tireii izala le izala kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ye ighita di, ve isaav ighaze: “Wai, tamtoghon tilup di tinim ee moghon wa! Ve tisavia aliŋadi ee moghon, ve aazne tipamundigin uraat tiina tonene paam. Muri, ighaze tigham ŋgar pa uraat tintina pida, pale matadi sorok ve tighami moghon. Pasa, mbeb eta irau ila muridi maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tovenen iit tazila ve tatoor aliŋadi inim naol. Leso tiwaloŋan aliŋadi muul sob.” ");
INSERT INTO tuc_o_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ataam tonene to Yoova igham di tipul uraat ineep, ve ireu di tila tineep irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ndug tiina tonowen, tiwaat iza tighaze ‘Babel.’ Pasa, indeeŋ sawa to tamtoghon tisob to taan tilup di izi ndug tonowen, Yoova itoor aliŋadi, ve ireu di tighau tila tineep ledi ledi irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nene pitiiŋ to Sem toman papaghu toni. Yawaaŋa tiina ivot le isob, ve ndaman ru inim ila, ghoro Sem yesuru azuwa tipoop natudi aidaba, iza Apaksad. Sawa tonenen, Sem ndaman toni irau tamoot liim (100). ");
INSERT INTO tuc_o_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apaksad izi, ve Sem ineep muul irau ndaman 500, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apaksad ndaman toni irau 35, ve yesuru azuwa tipoop natudi aidaba, iza Sela. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela izi, ve Apaksad ineep muul irau ndaman 403, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ndaman toni irau 30, ve yesuru azuwa tipoop natudi aidaba, iza Eber. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber izi, ve Sela ineep muul irau ndaman 403, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber ndaman toni irau 34, ve yesuru azuwa tipoop natudi aidaba, iza Peleg. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg izi, ve Eber ineep muul irau ndaman 430, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ndaman toni irau 30, ve yesuru azuwa tipoop natudi aidaba, iza Reu. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu izi ve Peleg ineep muul irau ndaman 209, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ndaman toni irau 32, ve yesuru azuwa tipoop natudi aidaba, iza Seruk. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk izi, ve Reu ineep muul irau ndaman 207, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk ndaman toni irau 30, ve yesuru azuwa tipoop natudi aidaba, iza Naor. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naor izi, ve Seruk ineep muul irau ndaman 200, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naor ndaman toni irau 29, ve yesuru azuwa tipoop natudi aidaba, iza Tera. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera izi, ve Naor ineep muul irau ndaman 119, ve tipoop ndinatudi nditamoot ve ndiliva pida, ghoro imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ndaman toni irau 70, ghoro yesuru azuwa tipoop ndinatudi tol, izadi Abram, Naor, ve Aran. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nene kamos to Tera toman papaghu toni. Tera ndinatu, Abram, Naor, ve Aran. Aran natu Lot. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera inepneep sone, ve natu Aran imaat izi tau ndug toni Ur to ineep izi taan suruvu to Kaldia. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ivai Sarai, ve Naor ivai Milka. Milka yesuru Yiska tamandi Aran. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai, ipoop maau. Pasa, ye uupa. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Muri ghoro, Tera igham natu Abram, timbu Lot to Aran natu, ve rawa liva Sarai to Abram azuwa, ve tipul ndug Ur to ineep ila taan suruvu to Kaldia, ve tighaze tila pa taan Kanaan. Eemoghon tila tivot ndug Aran, ve tizi tineep tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ndaman toni irau 205, ghoro imaat tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Sawa eez, Yoova ivot to Abram ve isaav pani ighaze: “Abram, umundig, upul taan tiom ve tamam ndug toni, toman siŋ tiom, ve ula. You pale napatooŋ ghom pa taan to naghaze uneep pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","You pale nagham papaghu tiom tivot tinim naol, ve poia tiou iza tiom, ve nagham izam ivot inim tiina. Ve yom pale unum ataam pa poia tiou iza to tamtoghon tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yes to tigham poian ghom, nene pale poia tiou iza todi. Ve yes to tighur pataŋani payom, nene pale naghur pataŋani padi. Ve yom pale unum ataam pa poia tiou iza to ndug tisob to taan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yoova isavia saveeŋ tonene le isob, ghoro Abram itaghon aliŋa, ve imundig ipul ndug Aran. Lot paam imundig ve ila tomani. Sawa tonenen, Abram ndaman toni irau 75 wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tovenen Abram igham azuwa Sarai, wagha Lot, ve mburuguuŋ todi toman mbesooŋa to tigham di izi ndug Aran, ve timundig tila. Tilaghlaagh tila le tivot izi taan Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Sawa to tivot izi Kanaan, tilaagh tila le tivot izi ndug Sekem. Ndug tonowen, ai tiina eez iyondyood, iza More. Sawa tonenen, yes Kanaana tinepneep izi ndug tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ghoro Yoova ivot to Abram tonowe, ve isaav pani ighaze: “Papaghu tiom to muri, you pale nagham taan tonene padi.” Tovenen Abram indou yaam izi ndug tonowen inim artaal pa Yoova. Pasa, Yoova ivot toni tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ghoro Abram ipul Sekem, ve ilaagh taghon lolooz le ila igharau Betel. Ghoro ighur ina to nepooŋ izi bodbodaaŋ pa ndug Betel ve ndug Ai. Ndug Betel, nene ineep ila pa yavaar, ve ndug Ai ineep ila pa rag. Abram igharaat artaal tonowe, ve isuŋ pa Yoova ve ipait iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ghoro Abram yesŋa tamtoghon toni tipamundigin laghooŋ todi muul, ve tila tivot taan suruvu to Negev to ineep ila pa daudau pughu. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tinepneep tonowe, le pitool tiina kat ivot izi ndug tonowen. Tovenen Abram toman tamtoghon toni tighau tizila pa Isip. Tighaze tila tineep tonowe le pataŋani to pitool isob, ghoro timuul tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tila le tigharau Isip, ve Abram isaav pa azuwa Sarai ighaze: “Ulooŋ. You nawatag yom liva paghunam kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tovenen ighaze yes Isipa tighita ghom, nene pale tigham ŋgar tighaze: ‘Nowe Abram azuwa.’ Ghoro tirab ghou namaat, ve yom uzi uneep toman di. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tovenen sawa to tala tavot, yom irau usaav padi ughaze yom livum you. Leso yom ndamom payou, ve tigham poian ghou, ve naneep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Saveeŋ to Abram tonene, onoon. Sawa to tila tivot Isip, yes Isipa tighita Sarai tighaze ye liva paghuna kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tovenen yes daba to tiŋgin uraat to kinik tighita, ve tila tisaav pa kinik tighaze: “Aa kinik, yei nighita liva poia eez inim inepneep toman ghiit!” Ghoro tila tigham Sarai, ve tighuri ila ruum to kinik. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai ndamo pa Abram, tauto kinik igham poiani. Ye igham Abram le sipsip, mekmek, makau, esele, ve kamel, toman mbesooŋa, nditamoot ve ndiliva pida. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Eemoghon Yoova iwaghamun kinik toman ndiran to tineep ruum toni ne pa moroghooŋ samsamia naol. Pasa, ye igham Abram azuwa Sarai. ");
INSERT INTO tuc_o_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Tovenen kinik ipoi Abram inim, ve iyaana ighaze: “Yom ugham kaarom payou pasa? Sarai nene yom azuwam! Pughu vena to usaav ughaze yom livum? You naghur ila aliŋam, tauto naghami naghaze inim azuwag. Yo, ugham azuwam, ve yamru aghau ala!” ");
INSERT INTO tuc_o_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ghoro kinik isaav ariaŋa pa yes uraata toni ighaze tizurun Abram yesuru azuwa tila. Tovenen tigham Abram yesuru Sarai, ve mbesooŋa todi, toman mbeb todi tisob, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram yesuru azuwa ve wagha Lot tigham mbeb todi, ve tipul Isip, ve timuul tila tivot taan suruvu to Negev. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram, ye mbaliiŋ tau kat. Ye le ŋgai ve yaam silva ve gol katindi. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Ye ipul taan suruvu to Negev, ve ilaagh muul. Ilaagh ila ivot izi ndug eez, ve ate izi tonowe. Ghoro ipamundigin laghooŋ muul, ve ila ivot ndug ite, ve ate izi tonowe. Ilaghlaagh tovene, le ila ivot izi ndug to ineep bodbodaaŋ pa ndug Betel ve ndug Ai. Ghoro isuŋ pa Yoova tonowe. Ndug tonowen, to muuŋ ye ineep pani, ve igharaat artaal eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram wagha Lot to yesuru tilaghlaagh, ye paam, ŋgai toni katindi, ve yes mbesooŋa toni naol. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tovenen yesuru irau tilup di izi ndug ee moghon maau. Pasa, yesuru ledi mbeb katindi, ve taan irau di maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tauto Lot mbesooŋa toni ve Abram mbesooŋa toni timundig ve tiwazoran di. (Sawa tonenen, yes Kanaana ve yes Peresa tinepneep ndug tonowen paam.) ");
INSERT INTO tuc_o_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tovenen Abram isaav pa Lot ighaze: “Ituru siŋ ee moghon. Tovenen lolog pa taghur koi pa tauud malep. Ve mbesooŋa toit paam, lolog pa tighur koi pa taudi malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ughita. Taan tiina inepneep. Yom irau upul ghou, ve ughita lem taan eta, leso uneep pani. Ighaze yom ula uneep taan dige venawe, ghoro you naneep ila pa dige vene. Ve ighaze yom unum pa dige vene, ghoro you nalat pa dige vana.” ");
INSERT INTO tuc_o_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tovenen Lot mata ila ve iŋgabiiz ndug, ve ighita taan raapa to ineep ya Yordan dige ve ila imuul izi ndug Zoar. Taan tonowen poia, ve le ya katindi inimale uum to Maaron, ma taan to yes Isipa to paghuna kat. Pasa, sawa tonenen, Yoova iwaghamun ndug Sodom ve Gomora sone. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tovenen Lot ipul Abram, ve ila ineep saguan. Ye ighaze igham taan raapa isob to ineep ila ya Yordan dige inim le. Tovenen imundig ve ilaagh ila pa taan dige to ineep ila pa ndag iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ve Abram, ye ineep izi taan Kanaan. Lot indurnduur mbeez toni izi taan raapa tonowen ve ila ila le igharau ndug Sodom, ghoro ineep tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sawa tonenen, yes tamtoghon to ndug Sodom tighamgham ŋgar samsamia naol, le tisosor tiina ila Yoova mata. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot ipul Abram, ghoro Yoova isaav pa Abram ighaze: “Umundig ve uŋgabiiz ndug. Matam ilooŋ ivot, ve iza izi. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Taan isob to ughita ne, pale nagham pa yom toman papaghu tiom to muri pale tivot. Leso aneep pani itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","You pale nagham papaghu tiom timasa tivot tinim naol tinimale ghavuur to taan. Tamtoghon eta irau inin di maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tovenen umundig, ve ulaagh irau taan tonene ve ughita. Pasa, you pale nagham taan isob tonene inim lem.” ");
INSERT INTO tuc_o_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tovenen Abram imundig, ve indurnduur mbeez toni ila ila le ivot izi ndug Ebron. Ghoro ighur ina to nepooŋ igharau ai tintina pida to Mamre, ve igharaat artaal pa Yoova tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Sawa tonenen, Bera, ye kinik to ndug Sodom. Birsa, ye kinik to ndug Gomora. Sinap, ye kinik to ndug Adma. Semeba, ye kinik to ndug Zebo. Ve Kedorlaomer, ye kinik to ndug Elam. Kedorlaomer iŋgin kinik paaŋ tonowen toman kinik to ndug Bela (iza ite Zoar), irau ndaman saaŋgul ve ru wa. Ve ndaman ite inim saaŋgul ve tol, nene kinik liim tonowen timundig ve tizoor kinik Kedorlaomer aliŋa. Tovenen ndaman inim saaŋgul ve paaŋ, kinik Kedorlaomer imbaaŋ ila pa ndita tol ve tinim. Izadi tovene: Amrapel, ye kinik to ndug Sinar, Ariok, ye kinik to ndug Elasa, ve Tidal, ye kinik to ndug Goi. Kinik paaŋ tonowen toman ndaaba todi tila, ve yesŋa yes ndiran to Repaim tigham malmal izi ndug Asterot-Karnaim le tilib padi. Ghoro tila pa ndug Am, ve yesŋa ndiran to Zuzim tigham malmal le tilib padi paam. Ghoro tila pa taan raapa to Kiriataim, ve yesŋa ndiran to Enim tigham malmal le tilib padi. Ghoro tila pa taan Seir dige to lolooza katindi, ve yesŋa ndiran to Or tigham malmal le tilib padi, ve tinaan di tila pa ndug El Paran, to ineep igharau ndug balim. Ghoro, timuul tila pa ndug Kades to iza ite En Mispat. Ve yesŋa ndiran to Amalek, ve ndiran to Amor to tineep izi ndug Azezon Tamar, tigham malmal le tilib padi paam. Kedorlaomer toman ndita tilib pa yes kinik tonenen le isob, ghoro kinik liim to Sodom, Gomora, Adma, Zebo, ve Bela tilup di, ve tila pa taan raapa to iza Sidim. Tineep tonowe ve tisaŋan Kedorlaomer toman ndita leso yesŋa tigham malmal. Tipamundigin malmal tonowe, ve Kedorlaomer toman ndita tilib pa kinik liim tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Taan to Sidim le saambu katindi to kolta ineep ila. Tovenen sawa to kinik to Sodom ve kinik to Gomora toman ndaaba todi tighau, tamtoghon todi pida titaptap tizila taan saambu tonowen. Ve pida tighau tizala pa lolooz. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Malmal tonenen isob, ghoro Kedorlaomer toman ndita tila tiyou adi aniiŋ toman mbeb tisob to ndug Sodom ve Gomora, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram wagha Lot inepneep izi ndug Sodom paam. Tauto tighami toman mbeb toni tisob, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eemoghon ŋgeu eez ighau pa malmal, ve ila ivot to Abram to Hibru taamdi, ve ipaes pani pa ŋgar to ivot. Sawa tonenen, Abram inepneep igharau ndug to ai tintina pida tiyondyood pani. Ai tonowen to ŋgeu eez, iza Mamre. Ye tamtoghon to Amor, ve nditazi izadi Eskol ve Aner. Abram yesŋa ndiran tol tonowen, lupuuŋ todi ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram ilooŋ paesiiŋ tighaze tigham wagha Lot ve tiŋguaaza tila, tovenen ipoi mbesooŋa toni irau 318 to ndiran to malmal, ve yesŋa timundig ve tigham taghon kinik paaŋ tonenen tila. Yes mbesooŋa tonowen, sawa to nditinandi tipoop di le tinim ndolman, yes tineep toman Abram, ve ye ipatooŋ di pa ŋgar to ghamuuŋ malmal. Tila le tivot to kinik paaŋ tonenen izi ndug Dan. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tineep le mboŋ izi, ghoro Abram ivalag ndaaba toni, ve tipamundigin malmal pa kinik paaŋ tonowen le tilib padi. Tinaan di tila tila le tilib pa ndug Damaskus, ve tila tivot ndug Oba. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ghoro Abram igham mulin wagha Lot toman mbeb toni, ve ndiliva ve tamtoghon pida to kinik paaŋ tonenen tiŋguaaz di ne, toman mbeb todi tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram ilib pa Kedorlaomer toman kinik pida tonenen, ghoro imuul inim, ve kinik to Sodom ila ivot toni izi taan raapa to iza Save. (Taan tonowen, iza ite ‘Taan raapa to yes kinik.’) ");
INSERT INTO tuc_o_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kinik to ndug Salem paam, iza Melkizedek, igham mberet toman vaen ve inim. Melkizedek, ye ŋgeu to watooŋrau, ve imbesmbees pa Maaron Tiina To Ilib Pa Ndimaronŋa Tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Ye ighur palotiiŋ iza to Abram ve isaav pani ighaze: “Abram, Maaron Tiina to ighur sambam ve taan ve ilib pa ndimaronŋa tisob, ye tau pale ighur poia toni iza tiom. Iit tapaiti. Pasa, ye ighur koiamŋa tila nimam ve ulib padi wa.” Ghoro Abram imundig, ve ivalag mbeb tisob to ye iyou di ila to koia ne, tinim ndouŋ saaŋgul, ve ighur ndouŋ eez ila to Melkizedek inim paitooŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ghoro kinik to Sodom isaav pa Abram ighaze: “Mbeb naol tonanan, ugham di tinim lem. Eemoghon upul tamtoghon tiou tinim, ve yeiŋa nila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eemoghon Abram ipamuul aliŋa ighaze: “Ee-e, vana maau. Yoova, ye Maaron Tiina To Ilib Pa Ndimaronŋa Tisob, ve ighur sambam ve taan. You nambua saveeŋ ariaŋa ila ye iza tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","You irau nagham mbeb tiom ŋgiira rita inimale imita ma waar to duduuŋa to aghem ne maau. Maau kat. Mbeb to ndaaba tiou tighani, tau tonene. Ve nditag tol to titaghon ghou ve yeiŋa ninim, Aner, Eskol, ve Mamre, nene you leg saveeŋ eta padi maau. Yes taudi. Ighaze lolodi pa tigham ledi mbeb pida, nene poia. Tighami.” Abram isaav tovene pasa, imatughez pa muri pale kinik to Sodom ipakur tau ighaze: “You to nagham Abram ivot a inim mbaliiŋ tau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mbeb tonenen isob ve muri ghoro, Maaron ivot to Abram ila vibiiŋ, ve isaav pani ighaze: “Abram, umatughez malep. You pale navool tiom ve nanim sigeu payom. Ve yom pale ugham lem atia tiina kat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Eemoghon Abram ipamuul aliŋa ighaze: “O Yoova, Maaron tiou, pale ugham sa payou? Ughita. You leg natug eta maau. Tovenen mbesooŋa tiou Eliezer to ndug Damaskus pale igham inag, ve igham mbeb tiou tisob tinim le.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ve Abram iseeŋ saveeŋ toni muul ighaze: “Yom ugham oliag eta maau. Tovenen mbesooŋa tiou to tina ipoopa izi ruum tiou, pale igham inag ve iyoon pa mbeb tiou to naol ne.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tovenen Yoova isaav pa Abram muul ighaze: “Maau. Mbesooŋa tiom tonanan irau igham inam ve iyoon pa mbeb tiom maau. Yamru azuwam pale apoop lemim natumim eez. Ye pale igham inam, ve iyoon pa mbeb tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ghoro Maaron igham Abram ve tivot tila pumuri, ve isaav pani ighaze: “Matam izala ve ughita pitum to tineep izala sambam paroŋania we. Irau unin di? Papaghu tiom pale timasa tinim naol kat tinimale pitum tonowen.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ilooŋ saveeŋ tonene, ve ighur ila ighaze Maaron saveeŋ toni pale anoŋa ivot. Tauto Maaron ighita ighaze ye ŋgeu deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ghoro Maaron isaav pani muul ighaze: “You Yoova, Maaron tiom. You to nagham ghom upul ndug tiom Ur to ineep ila taan suruvu to yes Kaldia, leso nagham taan tonene inim lem.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eemoghon Abram ipamuul aliŋa ighaze: “O Yoova, Maaron tiou, pale ugham sa inim ghilalooŋ payou, leso nawatag kat naghaze: Taan tonene pale inim leg?” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tovenen Maaron isaav pani ighaze: “Ugham makau paŋgaar eez to ndaman toni tol, mekmek paŋgaar eez to ndaman toni tol, ve sipsip tamoot eez to ndaman toni tol, toman man mbaluuz ru tinim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tovenen Abram ila iyou mbeb tonowen tisob tinim, ve irab di timaat. Ghoro ipaal balagin di tinim ruŋruŋa, ve irau di tizi. Ve man ru tonowen, ye irab di paam. Eemoghon ipaal di maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ghoro manbog pida tinim tighaze tighan mbeb tonowen. Eemoghon Abram inaan di. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ndag ighaze izila, ve Abram izi igheen le igheen kat. Mala maau ve ndoroom tiina kat izi ikaui, le matughezaaŋ tiina ighami. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ghoro Maaron isaav pani ighaze: “Mboŋ aazne, you pale nasavia mbeb to muri pale ivot pa papaghu tiom. Yes pale tila tineep izi ndug ite tinim loomba. Ndug tonowen tamtoghona pale tigham di tinim mbesooŋa sorok, ve titatan di ve tigham samin di irau ndaman 400. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Eemoghon muri, you pale naghur atia pa ndug tonowen tamtoghona. Ve papaghu tiom pale tiyou ledi mbeb naol to ndiran tonowen, ve tipul taan todi, ve timuul tinim taan tonene. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Eemoghon yom pale uneep poia moghon le unum olman waat, ghoro umaat ve titavia ghom. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tovenen papaghu tiom pale irau timuul tinim pa taan tonene rikia maau. Pale tineep mala izi ndug tonowen, le saas todi tivot, ghoro timuul tinim. Pasa, yes Amora to tinepneep izi taan tonene, pale tighamgham sosor ila ila le sawa to naghita sosor todi inim tiina kat, ghoro naghur atia padi, ve nandiir di tila. Leso papaghu tiom tigham taan tonene inim ledi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sawa to ndag izila ve ndug ndoroom kat, uur eez to yab mbuasa izaza pani, toman sul eez to yab ighanghan ila, tivot ve tilaghlaagh ila mbeb to Abram irab di ne sosodi. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mboŋ tonenen, Yoova imbua saveeŋ toman Abram ighaze: “Taan isob tonene, you naghami inim papaghu tiom ledi. Taan tiam tonene, mata pale izi ya to yes Isipa, ve ila imuul izi ya tiina Euprates. ");
INSERT INTO tuc_o_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Taan tonene to yes Kenia, Kenisa, Kadmona, Hita, Peresa, Repa, Amora, Kanaana, Girgasa, ve Yebusa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram azuwa Sarai, ye ipoop Abram le natu eta sone. Eemoghon ye le liva mbesooŋa eez to Isip, iza Agar. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sawa eez, Sarai isaav pa Abram ighaze: “Ulooŋ. Yoova ipoon ghou, tauto napoop maau. Tovenen yom ula to liva mbesooŋa tiou Agar, ve yamru agheen. Ighaze ugham tovene, nene pale inim ataam pa nagham ndinatug tivot ila toni.” Abram ilooŋ Sarai aliŋa ve itaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tovenen Sarai igham liva mbesooŋa toni to Isip tidi, ve ighuri ila to Abram inimale ye azuwa ite. Sawa tonenen, Abram ineep izi Kanaan irau ndaman saaŋgul wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram yesuru Agar tigheen le Agar apo. Sawa to Agar iwatag ighaze ye apo, ipakur tau ve mata izi pa tiina toni Sarai. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tovenen Sarai izi ve isuk saveeŋ pa Abram ighaze: “Pataŋani to aazne iza tiou ne, yom unum pughu pani! Onoon, you taug naghur liva mbesooŋa tiou ilat tiom. Eemoghon sawa to iwatag ighaze ye apo, mata izi payou kat. Maaron tau pale iŋgabiiz ghiit, ve ighur atia iŋarua sei to igham sosor!” ");
INSERT INTO tuc_o_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram ipamuul aliŋa ighaze: “Ughita. Liva mbesooŋa tiom tonowen, ye ineep ila taum nimam. Sa ŋgar to yom ughaze ugham pani, ghoro ughami.” Tovenen Sarai igham samin Agar, le Agar imundig ve ighau. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Agar ilaagh ila pa ndug balim le ivot izi ya eez, to bokbokia izaza igharau ataam to ila pa taan suruvu to Sur. Ye ila ivot tonowe, ve Mbaŋooŋa to Yoova ivot toni, ve ighasoni ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Agar, liva mbesooŋa to Sarai, yom uneep sine to unum? Ve ughaze ula sine?” Agar ipamuul aliŋa ighaze: “You naghau pa tiina tiou Sarai.” ");
INSERT INTO tuc_o_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mbaŋooŋa to Yoova isaav pani ighaze: “Umuul ula to tiina tiom Sarai, ve uneep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","You pale nagham papaghu tiom timasa tinim naol. Irau tinin di maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ve Mbaŋooŋa to Yoova isaav pani muul ighaze: “Yom apom. Ve pale upoop natum tamoot. Pain tonanan, yom uwaat iza Ismael. Pasa, Maaron ilooŋ taŋiiz tiom wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Natum tonanan pale iwalaghlaagh inimale ŋgai sagsag, ve ighur koi pa tamtoghon tisob. Ve tamtoghon tisob pale tighur koi pani paam. Tovenen yesŋa toŋvetaz toni, pale tighur koi pa taudi, ve tineep saguan saguan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yoova isavsaav toman Agar le isob, ghoro Agar igham ŋgar pa mbeb to ivot pani, ve isaav ighaze: “Ye to ighita ghou irau sawa isob, tauto taug naghita sualen.” Tovenen iwaat Yoova iza ighaze ‘El-Roi.’ Saveeŋ tonene, pughu tovene: ‘Maaron to ighita ghou.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tauto tiwaat ya naliu to ndug tonowen tighaze ‘Ya bokbokia to Maaron mata yaryaara to ighita ghou.’ Ya tonowen ineep bodbodaaŋ pa ndug Kades ve ndug Bered. ");
INSERT INTO tuc_o_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Abram ndaman toni 86, ve Agar ipoop Abram le natu tamoot. Ve Abram iwaat iza Ismael. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","2","Abram inepneep le ndaman toni irau 99, ghoro Yoova ivot toni muul, ve isaav pani ighaze: “You Maaron Ariaŋag To Nalib Pa Ndimaronŋa Tisob. Laghooŋ tiom, yom irau matam iŋgal ghou, ve utaghon ŋgar deŋia moghon ila matag. Leso napariaaŋ saveeŋ mbuaaŋ tiou toman ghom, ve ituru talup ghiit tanim ee moghon, ve nagham papaghu tiom timasa tinim naol.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ilooŋ saveeŋ tonene, ve iput aghe ve ighur nagho izila taan. Ghoro Maaron isaav pani muul ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Ulooŋ. Saveeŋ mbuaaŋ tiou toman ghom, nene vene: Yom pale unum ndug ndug tamandi. Pasa, you pale nagham papaghu tiom tivot tinim ndug ndug pughudi. Tovenen aazne ve ila, yom pale izam Abram muul maau. Izam paghu, nene Abaram. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","You pale nagham papaghu tiom timasa tinim naol, ve tinim ndug ndug pughudi. Ve pida pale tinim kinik. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Saveeŋ to aazne nambua toman ghom, muri pale napariaaŋa muul toman ndinatum, nditimbum, ve iseeŋga itaghoni taghoni gha ila. Tovenen saveeŋ mbuaaŋ tonene pale ineep ariaŋa tovene le alok. Saveeŋ tovene: You pale nanim Maaron tiom, ve Maaron to papaghu tiom to muri pale tivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ve taan isob to Kanaan to aazne uneep unum loom pani, you pale nagham pa yom ve papaghu tiom to muri pale tivot. Taan tonene pale inim lemim, leso aneep pani itaghoni taghoni gha ila. Ve you pale nanim Maaron to papaghu tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Maaron isaav muul pa Abaram ighaze: “Yom toman papaghu tiom irau matamim iŋgal saveeŋ mbuaaŋ tiou tonene ve ataghoni irau sawa isob. Ghilalooŋ to saveeŋ mbuaaŋ tonene, nene vene: Yom toman papaghu tiom nditamoot tisob to muri pale tivot, pale azir gham. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Tovenen yam irau azir nditamoot tiam. Leso inim ghilalooŋ pa saveeŋ mbuaaŋ toit. Saveeŋ tonene pale ineep tovene le alok. Tovenen aazne, ve itaghoni taghoni gha ila, ighaze ndinatumim nditamoot tizi le mboŋidi inim liim ve tol, ghoro azir di. Ve mbesooŋa tiam to nditinandi tipoop di izi ruum tiam, toman mbesooŋa tiam pida to aghol di izi ndug ite ve agham di tinim, yes paam, azir di. Tovenen ghilalooŋ to saveeŋ mbuaaŋ tiou pale ineep ilat tiam itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ighaze tamoot eta, lolo pa tiziri maau, ye irau ineep toman gham muul maau. Azuruni ila ineep saguan payam. Pasa, ye izoor saveeŋ mbuaaŋ tiou tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ghoro Maaron isaav muul pa Abaram ighaze: “Yom irau uwaat azuwam iza Sarai muul maau. Aazne ve ila, uwaat iza Sara. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Pasa, poia tiou pale ipaloti, leso ipoop lem natum tamoot eta. Ve papaghu toni pale tivot tinim katindi, ve tinim ndug ndug pughudi. Ve kinik pida pale tivot ila todi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abaram ilooŋ saveeŋ tonene, ghoro iput aghe ve ighur nagho izila taan, eemoghon iŋiŋ ve lolo ighur ighaze: “Wai, nene you nanim olman waat wa. Ighaze ŋgeu eta ndaman toni irau tamoot liim (100), pale irau yesuru azuwa tipoop? Ve Sara paam, ndaman toni irau tamoot paaŋ saaŋgul (90). Pale irau ipoop?” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tovenen Abaram isaav pa Maaron ighaze: “Poia. Eemoghon natug Ismael inepneep. You naghaze poia tiom iza toni ve uŋgini ineep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eemoghon Maaron ipamuul aliŋa ighaze: “Maau. Azuwam Sara tau pale ipoop lem natum tamoot. Natum tonowen, uwaat iza Isak. You pale napariaaŋ saveeŋ mbuaaŋ tiou toman ye tau ve papaghu toni to muri pale tivot, ve iseeŋga itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Eemoghon yom ughason ghou ughaze matag pa Ismael, tovenen you pale nagham tovene. Poia tiou pale iza toni, ve nagham papaghu toni tivot tinim naol, ve izadi tintina. Daba saaŋgul ve ru pale tivot ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Sawa tonene ighaze ivot muul pa ndaman muri, ghoro Sara ipoop Isak. Ve natum tonanan to pale napariaaŋ saveeŋ mbuaaŋ tiou ila toni ve papaghu toni paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Maaron isavsaav toman Abaram le isob, ghoro ipuli ve ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ndag ee moghon tonenen, Abaram imundig ve izir yes nditamoot toni tisob itaghon Maaron aliŋa. Izir natu Ismael, ve yes mbesooŋa toni tisob paam. Yes to nditinandi tipoop di ila ruum toni, toman yes to ye ighol di tinim ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Tovenen Abaram ndaman toni irau 99, ve natu Ismael ndaman toni irau saaŋgul ve tol (13), ghoro tizir yesuru. Ve sawa tonenen, tizir mbesooŋa toni tisob paam. Yes to nditinandi tipoop di ila Abaram ruum toni, toman yes to ye ighol di tinim ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Muri ghoro, Yoova ila ivot to Abaram igharau ai tintina to ndug Mamre. Sawa tonenen, ndag iza inim bobodaaŋ, ve ndag ighaaz le ndug ituntun kat. Tovenen Abaram mbole izi mbeez toni avo ve inepneep. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abaram mata ila, le ighita ndiran tol tiyondyood. Tovenen rikia moghon ila todi, ve iput aghe, ve nagho izila taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ghoro isaav pa todi eez ighaze: “Tiina tiou, you mbesooŋa tiom. Ighaze lolom payou, ghoro usalib payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Anim aneep toman ghou ve atemim izi ris, ghoro ala. Anim tala ai tonowen, ve mbolemim izi ila ai yavyaava, ve mbesooŋa tiou tigham ya rita inim pa amen aghemim pani, ve tigham amim aniiŋ rita. Leso ipalot gham, ve alaagh muul. Pasa, anim avot to mbesooŋa tiam wa.” Yes tipamuul aliŋa tighaze: “Poia. Pale nitaghon aliŋam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tovenen Abaram ilaagh rikia moghon ilooŋ ila mbeez toni lolo, ve ipasul Sara ighaze: “Ugham palawa poia, ve nimam rikia pa gharatooŋ mberet irau yes tol.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ghoro Abaram ilaan ila pa ndug to makau toni tineep pani, ve igham makau natu eez to tubu kat, ve ighuri ila to mbesooŋa toni eez. Mbesooŋa tonowen irabi, ve rikia moghon igharaata ve imozi. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Le isob, ghoro Abaram igham makau minda tonowen, toman tuz to makau, ve tuz pida to tigharaata inim sis ne, ila pa ndiran tol tonowen, ve tighan. Abaram iyondyood toman di ila ai samba, ve yes tighanghan. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tighan le isob, ghoro tighason Abaram tighaze: “Azuwam Sara ineep sine?” Abaram ipamuul aliŋadi ighaze: “Ye inepneep mbeez lolo we.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Todi eez isaav pani ighaze: “Onoon kat, you nasaav payom. Sawa tonene ighaze ivot muul pa ndaman muri, you pale namuul nanim. Ve sawa to navot sone, azuwam Sara pale ipoop lem natum tamoot.” Ye isavsaav, ve Sara iyondyood ŋgeu tonowen muri ila mbeez avo, ve ighurghur taliŋa pa saveeŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abaram yesuru Sara tinim ndolman watwaat, ve Sara sawa toni to popaaŋ isob wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tovenen Sara ilooŋ tighaze ye pale ipoop, ve iŋiŋ ve isaav ila lolo ighaze: “Wai, yeru azuwag ninim ndolman watwaat ve tapirimai isob wa. Pale lolomai pa nilup ghei pa ghenooŋ muul vena?” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tovenen Yoova ighason Abaram ighaze: “Pughu vena to Sara iŋiŋ, ve isaav ighaze ye inim liva waat wa, ve irau popaaŋ maau? ");
INSERT INTO tuc_o_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","You Yoova. Mbeb eta irau ila murig maau. Tovenen sawa tonene ighaze ivot muul pa ndaman muri, you pale namuul nanim. Ve sawa to navot sone, azuwam Sara pale ipoop lem natum tamoot.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara ilooŋ Yoova aliŋa, ve imatughez. Tovenen ipesamun tau ighaze: “Wai, you naŋiŋ maau!” Eemoghon Yoova isaav pani ighaze: “Maau. Yom uŋiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ghoro ndiran tol tonenen tighaze tipamundigin laghooŋ muul. Tovenen Abaram paam ilaagh toman di ila ighaze ighur di. Tilaagh tila ris, ghoro tiyoon ve matadi izila pa ndug Sodom. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yoova isaav pa tau ighaze: “Mbeb to naghaze naghami, pale naŋgooza pa Abaram, ma navotia pani? Maau. Pale navotia pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Pasa muri, papaghu toni pale timasa tinim naol ve izadi tintina. Ve ye pale inim ataam pa poia tiou iza to ndug tisob to taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","You taug nasia inim leg wa. Leso navotia ŋgar tiou ila toni, ve ana isakia ila to papaghu toni toman tamtoghon toni pida. Leso yes paam titaghon ataam tiou ve tigham ŋgar poia ve ŋgar deŋia, ve saveeŋ to nambua toman Abaram ne anoŋa ivot.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","Ghoro Yoova isaav pa Abaram ighaze: “Tamtoghon to Sodom ve Gomora tinoknok ghamuuŋ ŋgar samsamia kat. Ve sosor todi varu toman taŋiiz tiina to yes to Sodom ve Gomora tighamgham samin di ne, iza inim nalooŋa wa. Tovenen you naghaze nazila ve naghita di. Leso nawatag kat: Varudi ve taŋiiz tiina to iza inim ve naloŋlooŋa, nene onoon, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tovenen Yoova ndita ru tilaagh malmalidi tizila pa ndug Sodom. Ve Yoova izi iyoon ris toman Abaram. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abaram ila igharaui, ve ighasoni ighaze: “Saveeŋ tiom poia. Eemoghon vena? Pale uwaghamun ndiran deŋiadi toman ndiran samsamiadi? ");
INSERT INTO tuc_o_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ighaze ndiran deŋiadi tamoot ru saaŋgul (50) tineep izi ndug tonowen, pale uwaghamun ndug? Maau. Yom irau lolom samin di ve upul di tineep. Pasa, ndiran deŋiadi tonowen ndamodi pa ndug. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Maaron, yom moghon to gabizooŋ tau to tamtoghon tisob to taan. Yom irau uŋgabiiz di itaghon ŋgar deŋia. Ughita. Ighaze ndiran deŋiadi tamoot ru saaŋgul (50) tineep izi ndug tonowen ve uwaghamun ndug, nene pale urab tamtoghon deŋiadi toman yes samsamiadi. Ighaze ugham tovene, pale deŋia wa? Yom irau ughur atia raraate pa ndiran deŋiadi ve samsamiadi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Maaron ipamuul Abaram aliŋa tovene: “Ighaze you naghita ndiran deŋiadi irau tamoot ru saaŋgul (50) tineep izi ndug Sodom, yes pale ndamodi pa ndug tonowen, ve irau nawaghamun di maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ghoro Abaram isaav muul ighaze: “O Tiina tiou, you avab ve ghavuur sorok to taan. Irau nasaav tovene maau. Eemoghon nasaav wa. Tauto pale naseeŋ saveeŋ tiou muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ighaze ndiran deŋiadi irau tamoot ru avua liim (45) moghon tineep izi ndug Sodom, pale vena? Pale uwaghamun ndug dodoli tonowen? Pasa, nene ndiran liim moghon to maau.” Maaron ipamuul aliŋa ighaze: “Venen maau. Ighaze naghita ndiran deŋiadi tamoot ru avua liim (45), nene irau nawaghamun ndug tonowen maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abaram iseeŋ ghasoniiŋ toni muul ighaze: “Ve ighaze ndiran deŋiadi tamoot ru moghon tineep, pale vena?” Maaron ipamuul aliŋa tovene: “Ighaze naghita ndiran deŋiadi tamoot ru tineep, nene irau nawaghamun ndug maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tovenen Abaram isaav muul ighaze: “O Tiina tiou, atem yabyab payou malep. You naghaze naghason ghom muul. Ighaze ughita ndiran deŋiadi tamoot ee saaŋgul (30) moghon tineep tonowe, pale vena?” Maaron ipamuul aliŋa ighaze: “Nene pale maau paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tovenen Abaram isaav muul ighaze: “Tiina tiou, you nawatag: Nakaria ghasoniiŋ ghom wa. Eemoghon ighaze yom ughita ndiran deŋiadi tamoot ee (20) moghon tineep, pale vena?” Maaron isaav pani ighaze: “Nene paam maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ghoro Abaram isaav muul ighaze: “O Tiina tiou, atem yabyab payou malep. Naghason ghom pa ee moghon tonene, ve isob. Ighaze ughita ndiran deŋiadi saaŋgul moghon tineep, pale vena?” Maaron ipamuul aliŋa tovene: “Ighaze tamtoghon deŋiadi saaŋgul tineep ndug tonowen, nene pale ndamodi pa ndug, ve irau nawaghamuni maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yesuru tisavsaav le isob, ghoro Yoova ipuli ve ila, ve Abaram imuul ila pa ndug to ineep pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aŋela ru tonenen tilaagh tila le rabrab izi. Ghoro tila tivot izi ndug Sodom. Sawa tonenen, Lot inepneep ila lupuuŋ ina to ineep ataam avo to ndug Sodom. Mata ila le ighita ndiran ru tonenen tinim. Tovenen imundig ve iŋarua di ila, ve iput aghe, ighur nagho izila taan, ");
INSERT INTO tuc_o_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ve isaav padi ighaze: “Ndolman tiou, you mbesooŋa tiam. Yamru anim tala pa ruum, ve agharaat taumim ve atemim izi. Itiŋa taneep pale mboŋmaagh, ghoro alaagh muul.” Yesuru tipamuul aliŋa tighaze: “Maau. Mboŋ aazne, yeru pale nineep sorok izi to lupuuŋ ina ne.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Eemoghon Lot isaav ariaŋa padi ighaze tineep sorok izi pumuri malep. Tovenen yesuru tilooŋ aliŋa, ve titaghoni tilooŋ tila ruum toni, leso Lot iŋgin di tonowe. Ghoro tigharaat mberet to le yis maau, toman aniiŋ popoia pida, ve tigham pa yesuru ve tighan. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yesuru tighan le isob, ve tighaze tigheen. Mala maau ve yes nditamoot papaghudi toman ndolman to Sodom, tisob tila tiluvut ruum to Lot, ");
INSERT INTO tuc_o_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ve tipoi izala pani tighaze: “Ndiran ru to rabrab tilat tiom, tineep sine? Usaav padi tivot tinim pumuri, leso nimogheer padi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Tovenen Lot ivot ila, ve ipoon ataam, ve isaav padi ighaze: “O ndiran tiou, lolog pa agham ŋgar samia tovene malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aghita. Ndinatug liva ru tinepneep. Tamoot eta igheen toman di sone. You pale nagham di tivot tilat tiam. Ve sa ŋgar to aghaze agham padi, ghoro aghami. Eemoghon agham mbeb eta pa ndiran ru to tinim tineep toman ghou ila ruum tiou ne malep. Pasa, yesuru loomba. Tovenen you irau naŋgin poian di le naghur di timuul tila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yes tilooŋ saveeŋ tonene, ve tisaav tighaze: “Ŋgeu tonene ndug tau? Ye loom moghon. Ve aazne, ighaze inim tiina ve iŋgabiiz ghiit?” Ghoro tisaav pani tighaze: “Ughau ula pa dige! Yei nighaze nigham ŋgar samia pa ndiran ru tonanan. Ve yom pale niwaghamun ghom kat!” Ghoro tisipiir Lot ila dige, ve tighaze tirab balagin ataam. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Eemoghon ndiran ru to tineep ila ruum lolo, tikaak ataam, ve tikis Lot nima, ve tiweua ilooŋ ila pa ruum lolo muul, ve tipoon ataam. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ghoro tigham yes to tineep pumuri we matadi ipis. Tovenen tiwandabndab pa kalooŋ ataam. Tikaal tikaal le maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ghoro ndiran ru tonenen tisaav pa Lot tighaze: “Vena, lem nditam pida to tineep izi ndug tonene? Ugham ndinatum liva, ndirawam, ve tamtoghon tiom tisob to tineep izi ndug tonene, ve yamŋa amundig to aazne, ve aghau! ");
INSERT INTO tuc_o_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pasa, ndug tonene varu samia kat, toman taŋiiz tiina to yes to ndug tonene tighamgham samin di, nene izala to Yoova ve ilooŋa wa. Tauto ate yabyab kat padi, ve imbaaŋ ghei ninim pa nireu ndug tonene ilale.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tovenen Lot ila to ndirawa ru to tighaze tivai ndinatu liva, ve isaav padi ighaze: “Ai, rikia amundig ve apul ndug tonene! Pasa, Yoova ighaze ireua ilale!” Eemoghon yesuru tighur ila Lot aliŋa maau. Tighaze pa ye igham saveeŋ mogheraaŋ padi moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ndugizau ve aŋela ru tonenen tipasul Lot tighaze: “Umundig rikia, ve ugham azuwam toman ndinatum liva ru, ve apul ndug tonene, ve aghau ala! Pa vene, alalemim toman di. Pasa, paam Yoova ireu ndug tonene pa sosor todi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Eemoghon Lot izuar pa mundigiiŋ. Tovenen ndiran ru tonenen tikis Lot yesuru azuwa ve ndinatu liva ru nimadi, ve tiweu di tivot tila saguan pa ndug. Pasa, Yoova lolo isamin Lot ve ighaze iuuli. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Aŋela ru tonenen, todi eez ipasul di ighaze: “Aŋguaaz taumim ve aghau rikia ala! Matamim imulmuul malep. Apul taan raapa tonene, ve aghau azala pa lolooz. Ala aneep izi ataam luvuŋa malep. Malmalimim ala! Pa vene, Yoova ipasob gham toman tamtoghon to ndug tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Eemoghon Lot isaav pani ighaze: “Wais Tiina tiou, you naraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Onoon, yom lolom ineep tuŋia inim tiou ve lolom isamin ghou, tauto ugham mulin ghou ve naneep pooi. Eemoghon lolooz tonowen ineep mala kat. Irau nazala rikia maau. Tovenen ighaze nazuar pa laghooŋ, ve ureu ndug, pataŋani tonowen pale igham ghou namaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ughita ndug tonowen. Ineep tataŋgan. Irau rikia moghon ve nala navot. Nowe ndug tiina maau, kainaŋen moghon. Ighaze uyok payou ve nala tonowe, pale naneep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Aŋela ipamuul aliŋa ighaze: “Poia. You nayok pa aliŋam. Ndug kainaŋen tonowen, irau nareua maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eemoghon yam alaagh rikia! Pasa, you irau nagham mbeb eta ivot sone, le ala avot ndug tonowen.” Ndug kainaŋen tonowen, iza Zoar. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sawa to Lot ila ivot ndug Zoar, ndag iza inim wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ghoro Yoova igham yab toman yaam salfa tuntunu to vuzi samia kat titaptap tizi, le ireu Sodom ve Gomora. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ye iwaghamun ndug tintina ru tonenen, toman taan raapa to tineep ila, ve tamtoghon tisob to tineep ila taan suruvu tonowen, toman mbeb tisob to titub tiza tonowe, le tisami kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Sawa to tighau, Lot azuwa ilaagh muri ve indaleel imuul ila, le rikia moghon itoora inim te (o sol) patua mala eez to iyoon inimale yaam. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","28","Mboŋmaagh tonenen, Abaram imundig ve izala ndug mbuŋa to noor yesuru Yoova tineep pani ve tisavsaav. Ye mata izila pa Sodom ve Gomora toman taan raapa to ineep sila we, le ighita yab mbuasa iza le ikau taan suruvu tonowen inimale yab tiina ighan ndug. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tovenen sawa to Maaron ireu ndug tisob to tineep sila ila taan raapa tonowen, ye mata iŋgal Abaram, tauto igham mulin Lot pa pataŋani tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot lolo pa ineep mala izi ndug Zoar maau. Pasa, imatughez. Tovenen igham ndinatu liva ru, ve tighau tizala pa lolooz, ve tineep ila yaam saambu eez lolo tonowe inim inadi to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tinepneep le sawa eez, liva olman isaav pa taziliva ighaze: “Ughita. Tamaan ighaze inim olman waat tonene. Ve tamoot eta ineep izi taan suruvu tonene pa ivai ghiit ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tovenen ulooŋ. Ituru irau tapaghun tamaan pa vaen le ŋgar toni iwaghamgham, ghoro tala toni ve itiŋa tagheen. Tagham tovene, ghoro tagham papaghu toit tivot ila toni, ve siŋ toit iseeŋga itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tovenen mboŋ tonenen, yesuru tipaghun tamandi pa ya vaen le ŋgar toni iwaghamgham. Ghoro liva olman ila ve yesuru tama tineep. Ŋgar to ye ighami, tama iwatagi maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ndugizau muul, liva olman isaav pa taziliva ighaze: “Noor mboŋ, yeru tamaan nigheen wa. Tovenen mboŋ aazne, ituru pale tapaghuni pa vaen muul, ve anam ula ve yamru agheen. Leso tagham papaghu toit tivot ila toni, ve siŋ toit iseeŋga itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tovenen mboŋ tonenen, yesuru tipaghun tamandi pa vaen muul, ghoro liva muria ana ila ve yesuru tama tigheen. Ye paam, ŋgar to ighami, tama iwatagi maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ataam tonene, to Lot ndinatu liva ru apodi ila to tamandi. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Liva olman apo ve ipoop tamoot, ve iwaat iza Moap. Ye to inim yes Moapa pughudi. ");
INSERT INTO tuc_o_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Liva muria ipoop tamoot paam, ve iwaat iza Ben-Ami. Ye to inim yes Amona pughudi. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abaram ipul ndug Mamre, ve ilaagh ila pa taan Negev, ve ighur ina to nepooŋ izi bodbodaaŋ pa ndug Kades ve ndug Sur. Ineep mala ris tonowe, ghoro imundig muul ve ila ineep inim loom izi ndug Gerar. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Sawa to Abaram inepneep izi ndug Gerar, isavsaav padi pa azuwa ighaze: “Sara, nene you livug.” Tovenen Abimelek to kinik to ndug Gerar, imbaaŋ mbesooŋa toni pida tila, ve tigham Sara ila ruum toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Eemoghon mboŋ eez, Maaron ivot toni ila vibiiŋ, ve isaav pani ighaze: “Abimelek, ulooŋ. Paam umaat! Pasa, liva to ughami, ye liva vaivaiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Eemoghon Abimelek ila igharau Sara sone. Tovenen ipamuul aliŋa ighaze: “Wai Maaron, pale urab ndiran to ledi sosor maau ne? Abaram tau isaav payou ighaze liva tonene, ye livu. Ve Sara paam isaav ighaze ye livu Abaram. Tovenen nimag igham sosor eta maau. You nagham mbeb tonene toman ŋgar deŋia moghon. Pasa, you nawatag di maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Maaron isaav pani muul ighaze: “You nawatag: Yom ugham mbeb tonene toman ŋgar deŋia moghon. Pughu tonene, to napul ghom ula ugharau Sara maau, ve napoon ghom pa ghamuuŋ sosor ila matag. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Aazne, rikia moghon ve ughur Sara imuul ila to azuwa Abaram. Pasa, ŋgeu tonowen, ye propet eez. Ye pale ighur ghom ila suŋuuŋ toni, leso umaat sob. Eemoghon ighaze yom ughur Sara imuul ila to azuwa maau, nene pale yom toman tamtoghon tiom asob amatmaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mboŋmaagh kat, Abimelek imundig ve ipoi mbesooŋa toni tisob tinim tilup di, ve ipaes padi pa saveeŋ isob to Maaron isavia pani. Yes tilooŋ saveeŋ toni, le matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Ghoro Abimelek ipoi Abaram inim, ve iyaana ighaze: “Pughu vena to ugham ŋgar tonene payei? Rismoghon tone nagham sosor tiina kat. You nagham sa sosor payom, to ugham ghou toman tamtoghon tiou nisosor tiina ila Maaron mata? Ŋgar to ugham payou, nene deŋia maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abaram ipamuul aliŋa ighaze: “Sawa to you nanim ndug tiom sone, matag iŋgal naghaze: ‘Ndiran to ndug tonowen tiwatag Maaron maau, ve timatughez pani maau. Pale tirab ghou namaat, ve tigham azuwag.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Saveeŋ to nasavia payom naghaze Sara, ye livug, nene onoon. Pasa, yeru tamamai ee moghon. Ve nditinamai, ghoro ite ite. Tauto you irau naghami inim azuwag. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Muuŋ, sawa to nanepneep toman tamaŋ sone, Maaron isaav payou ighaze napul ndug to tamaŋ, ve nala nalaghlaagh pa taan suruvu ite. Sawa tonenen, you nasaav pa Sara tovene: Ighaze lolom ineep tiou kat ve ughaze ugham poian ghou, ghoro ndug sine to ituru tala pani, ve ighaze tighason ghom payou, yom usaav padi ughaze: ‘Abaram, nene you livug.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abaram isavsaav le isob, ghoro Abimelek igham le sipsip, mekmek, ve makau, toman mbesooŋa pida, ve ighur Sara imuul ila to Abram. ");
INSERT INTO tuc_o_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ve isaav pa Abaram ighaze: “Ughita. Taan tonene, you tiou. Ndug dige sine to yom ughita poia, ghoro uneep pani. Saveeŋa maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ve Abimelek isaav pa Sara ighaze: “Ughita. You nagham livum le yaam silva irau ndiŋndiŋ eez (1000). Leso napaghazoŋan izam ila yes to yamŋa alaghlaagh ne matadi, ve tiwatag tighaze yom lem sosor eta maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ghoro Abaram isuŋ pa Maaron, ve Maaron igharaat Abimelek yesuru azuwa toman ndiliva to mbesooŋa toni. Leso tinidi popoia ve tipoop muul. Pasa, sawa to Abimelek igham Abaram azuwa Sara ila ruum toni ve inim, ndiliva tisob to tineep ila Abimelek ruum toni, Yoova ipoon di pa popaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Yoova mata iŋgal Sara, ve iuuli itaghon saveeŋ mbuaaŋ toni. Tauto Sara apo, ve indeeŋ sawa to Maaron ighuri pani pa popaaŋ, ye ipoop olman Abaram le natu tamoot eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abaram iwaat natu to Sara ipoopa, iza Isak. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Natu tonowen mboŋi inim liim ve tol, ghoro Abaram iziri itaghon Maaron aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sawa to Sara ipoop Isak, Abaram ndaman toni irau tamoot liim (100). ");
INSERT INTO tuc_o_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara lolo poia kat, ve isaav ighaze: “Maaron igham ghou lolog poia ve naŋiŋ. Ve tamtoghon tisob to tilooŋ varug, nene pale yeiŋa niŋiŋ ve tinimai iza.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ve Sara isaav muul ighaze: “Muuŋ, sei irau isaav pa Abaram ighaze: ‘Azuwam Sara pale ipoop ve ipaghun tau natu?’ Maau. Eemoghon aazne, Abaram inim olman waat wa, ve you napoop le natu tamoot eez.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tinepneep le sawa to natudi Isak ipul tuz, ghoro Abaram igham ghanghaniiŋ tiina pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sawa tonenen, Agar to Isip tidi ne natu Ismael igham ŋalalaŋ ve iŋiŋiŋ pa Sara natu Isak. Sara ighita mbeb tonenen, le irau lolo maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tovenen isaav pa Abaram ighaze: “Uzurun liva mbesooŋa tonowen yesuru natu tighau tila saguan! Liva mbesooŋa tonowen natu irau ineep toman natug Isak, ve tiyoon pa mbeb tiom ne maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eemoghon Ismael, ye Abaram natu paam. Tovenen Abaram ilooŋ saveeŋ tonene, le lolo ipataŋan kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Eemoghon Maaron isaav pani ighaze: “Lolom ipataŋan pa liva mbesooŋa yesuru natu malep. Utaghon Sara ŋgar toni. Pasa, papaghu tiom kat pale tivot ila to natum Isak moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Eemoghon papaghu to liva mbesooŋa natu paam, you pale nagham di timasa tinim ival. Pasa, ye paghu tiom paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tovenen ndugizau, mboŋmaagh kat, ve Abaram imundig ve igham Agar a ya apatu eez ve mberet inim taman, ve iiti izala avara, ve ighur yesuru natu Ismael tila. Yesuru tila ve tiwalaghlaagh izi ndug balim to Ber-Seba. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Sawa to ya todi isob, Agar ipul natu Ismael izi ai kainaŋen eez pughu, ve ilaagh ila saguan ris pani. Ghoro mbole izi, ve itaŋ aliŋa tiina. Pasa, lolo pa ighita natu imaat maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Maaron ilooŋ Agar natu itaŋtaŋ, tovenen aŋela to Maaron ineep sambam, ve ipoi izila pa Agar ighaze: “Agar, vena? Umatughez malep. Natum to inepneep ve itaŋtaŋ we, Maaron ilooŋ taŋiiz toni wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Umundig ula, ve uiti iza ve uŋgin poiani. Pasa, you pale nagham papaghu toni tivot tinim naol ve izadi tintina.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ghoro Maaron igham Agar mata pakia, ve mata ila le ighita ya taiŋ eez. Tovenen igham ya apatu todi, ve ila itibi le ivon, ghoro imuul ila ve ipaghun natu. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Maaron ineep toman Ismael, ve itub le inim olman. Ismael inepneep izi ndug balim, ve nima mamaan pa vaneguuŋ mbeb pa pane. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ismael inepneep izi ndug balim Paran, ve tiina igham Isip tidi eez pani ve ivaii. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sawa tonenen, kinik Abimelek yesuru ŋgeu ite to iŋgin yes ndaaba toni ne iza Pikol, tila to Abaram, ve Abimelek isaav pani ighaze: “You naghilaal naghaze Maaron ineep toman ghom pa mbeb tisob to yom ugham di. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tovenen aazne, you naghaze yom umbua saveeŋ ariaŋa toman ghou ila Maaron mata tovene: Yom irau ugham kaarom eta pa you, ma ndinatug, ma papaghu tiou to muri pale tivot ne maau. Yom pale ugham poian ghou toman tamtoghon to taan to uneep unum loom pani ne paam. Pasa, you nagham poian ghom, ve lupuuŋ toit ee moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abaram ipamuul Abimelek aliŋa ighaze: “Poia. You nambua saveeŋ ariaŋa ila Maaron mata inimale yom usaav.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Eemoghon Abaram le saveeŋ toman Abimelek paam. Pasa, ya taiŋ eez to mbesooŋa toni titaii, mbesooŋa to Abimelek tighami inim ledi, ve tipoon mbesooŋa to Abaram pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abaram ipaesia pataŋani tonowen pa Abimelek, ve ye ipamuul aliŋa ighaze: “Wai, saveeŋ tonene, aazne moghon ve nalooŋa. Pughu vena to upaesia saveeŋ tonene payou rikia maau? Ŋgeu to igham ŋgar tonene, you nawatagi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ghoro Abaram igham sipsip toman makau pida pa Abimelek, ve yesuru timbua saveeŋ ariaŋa pa tilup di tinim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ve Abaram ighur sipsip paŋgaar papaghu liim ve ru paam tila saguan. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Tovenen Abimelek ighasoni ighaze: “Pughu vena to ughur sipsip tonowen tila saguan?” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abaram ipamuul aliŋa ighaze: “You naghaze yom ugham sipsip tonowen tinim lem. Leso ipatooŋ ghom ighaze yom uyok ughaze you natai ya tonowen.” ");
INSERT INTO tuc_o_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","32","Tauto tiwaat ndug tonowen iza Ber-Seba. Pasa, yesuru tineep tonowe, ve timbua saveeŋ ariaŋa pa tilup di tinim ee moghon. Yesuru timbua saveeŋ izi Ber-Seba le isob, ghoro Abimelek yesuru Pikol timuul tila pa ndug todi to ineep ila taan suruvu to Pilistia. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abaram iŋgun ai tamarisk eez izi Ber-Seba, ve ai tonowen inim ina to suŋuuŋ. Ye ineep tonowe, ve isuŋ pa Yoova, ye Maaron to ineep irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abaram ineep mala inim loom izi taan to yes Pilistia. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Muri ghoro, Maaron itoov Abaram. Sawa eez, ye ipoii ighaze: “Abaram!” Abaram iyok pa aliŋa ve isaav ighaze: “Taug nene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Maaron isaav pani ighaze: “Natum ee moghon Isak to lolom pani kat, you naghaze ughami, ve yamru ala pa taan suruvu to Moria. Ala avot tonowe, ghoro azala pa lolooz eez to you pale napatooŋa payom. Ghoro urabi imaat, ve ughuri izala yab ve ighan suvuni inim watooŋrau payou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tovenen mboŋ le ndugizau, mboŋmaagh kat, ve Abaram imundig, ve igharaat esele toni pa laghooŋ, ve ipaal ai pa watooŋrau. Ghoro iturwa di, ve indae di tizala esele pogho. Ghoro igham natu Isak toman mbesooŋa toni ru, ve yesŋa timundig tila pa ndug to Maaron isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tilaagh irau ndag ru, ve ite inim tol pani, ghoro Abaram mata ila, le ighita ndug to tighaze tila pani, igharau ris. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tovenen isaav pa mbesooŋa toni ru tonowen ighaze: “Yamru aneep sualen toman esele. Yeru natug pale nizala ndug tonowen ve nisuŋ le isob, ghoro nimuul nizi ninim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ghoro Abaram igham ai to tavanuuŋ yab pa watooŋrau, ve indaea izala natu Isak avara ve imbaada. Ve ye igham yab toman buza ve yesuru tinau tizala. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tilaghlaagh tila, ve Isak isaav pa tama Abaram ighaze: “Wai tamaŋ!” Abaram ipamuul aliŋa ighaze: “Natug, vena?” Ghoro Isak ighasoni ighaze: “Iit tagham yab ve ai. Eemoghon sipsip sine to pale tagham watooŋrau pani?” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abaram ipamuul aliŋa ighaze: “Natug, Maaron tau pale iuul ghiit ve igham leed sipsip eta pa watooŋrau.” Abaram isaav tovene, ve yesuru tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yesuru tilaagh tila tivot ndug to Maaron isavia pa Abaram, ve Abaram indou yaam inim artaal, ve ighur ai izala pogho. Ghoro ikau natu Isak pa waar, ve ighuri izala ai pogho. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ghoro igham buza, ve indae nima iza ighaze iŋgal natu. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Eemoghon Mbaŋooŋa to Yoova ineep sambam ve imboob izila pani ighaze: “Abaram, Abaram!” Abaram iyok pa aliŋa ighaze: “Taug nene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mbaŋooŋa tonowen isaav pani ighaze: “Nimam imbuul natum malep. Ugham mbeb eta pani malep! Aazne, you nawatag ghom kat: Yom umatughez pa Maaron, ve utaghon katin ŋgar toni. Pasa, natum ee moghon to lolom pani kat, yom uŋguruuta pani maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ghoro Abaram mata ila le ighita sipsip tamoot eez to ndooŋa itoto ila ai kainaŋen eez boga. Tovenen ila ighami, ve irabolin natu pani, ve itavun yab le ighan suvuni inim watooŋrau pa Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abaram iwaat ndug tonowen iza ighaze “Yoova pale iuul ghiit ve igham leed mbeb.” Tauto aazne paam, tamtoghon tisavsaav tighaze: “Yoova pale iuul ghiit ve igham leed mbeb popoia izi lolooz toni.” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mbaŋooŋa to Yoova ineep sambam, ve imboob izila pa Abaram muul ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Nene Yoova tau aliŋa to ilat. Yom ulooŋ aliŋa ve uŋguruut natum ee moghon tonanan pani maau. Tovenen ye imbua saveeŋ ariaŋa toman ghom ila ye tau iza tovene. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ighaze: ‘You pale naghur poia tiou tiina kat iza tiom, ve nagham papaghu tiom timasa tinim naol tinimale pitum to sambam paroŋania, ve magargaar to naari. Ve papaghu tiom pale tiyoon ariaŋa pa malmal le tilib pa koiadi, ve tigham ndug todi inim ledi. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pasa, yom ulooŋ aliŋag. Tovenen papaghu tiom pale tinim ataam pa poia tiou iza to ndug tisob to taan.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mbaŋooŋa to Yoova isavsaav le isob, ghoro Abaram yesuru natu Isak timuul tizila to mbesooŋa toni ru, ve yesŋa timundig ve timuul tila pa ndug Ber-Seba, ve Abaram ighur ina to nepooŋ tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Muri ghoro, Abaram ilooŋ paesiiŋ tighaze tazi Naor azuwa Milka ipoop ndinatu pida wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","Izadi tovene: Uz (ye aidaba), nditazi Bus, ve Kemuel to Aram tama, ve Kesed, Aso, Pildas, Yidlap, ve muria kat, nene Betuel to Rebeka tama. Yes liim ve tol tonene, to Abaram tazi Naor yesuru azuwa Milka ndinatudi. ");
INSERT INTO tuc_o_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naor igham liva ite paam inim azuwa ite, iza Reuma. Eemoghon Reuma, ye Naor azuwa tau maau. Reuma ipoop ndinatu paaŋ: Teba, Gaam, Taas, ve Maaka. ");
INSERT INTO tuc_o_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara inepneep le ndaman toni irau 127, ghoro sawa toni isob ve imaat izi ndug Kiriat Arba to ineep ila taan suruvu to Kanaan. (Kiriat Arba iza ite Ebron). Tovenen Abaram lolo ipataŋan pa azuwa ve itaŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Itaŋtaŋ le isob, ghoro imundig, ipul azuwa paatu izi, ve ila isavsaav toman yes Hita. Isaav padi ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Aghita. You leg taan eta maau. Naneep nanim loom ila yam lolomim. Vena, irau aghita leg taan suruvu eta leso inim ndug to naghur azuwag paatu ila ve igheen pani?” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Yes Hita tipamuul aliŋa tighaze: “Olman, yom ŋgeu tiina eez to uneep toman ghei, ve nighilaal ghom nighaze Maaron ineep toman ghom. Ulooŋ, mateeŋa tiei inadi katindi. Ughita poia eta to irau lolom, ghoro ughur azuwam paatu ila. Tamtoghon tiei eta irau iŋguruuta payom maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abaram ilooŋ saveeŋ todi le lolo poia. Tovenen imundig ve itud padi inimale pakuruuŋ di, ve isaav ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","“Poia. Ighaze yam ayok payou pa naghur mateeŋ tiou izi ndug tonene, ghoro ala to Zoar natu Epron, ve aghasoni pa yaam saambu to ineep izi taan toni Makpela dige. Ndug tonowen to naghaze nagholi inim leg, ve naghuri inim mateeŋa tiei inadi. Atia piiz to ye ighuri, nene pale naghol motini ila yam asob matamim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Abaram isavsaav toman yes Hita izi lupuuŋ ina to ineep ataam avo, ve Epron tau inepneep paam. Tovenen imundig iyoon ila ival tiina matadi, ve ipamuul Abaram aliŋa ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tiina tiou, ulooŋ. You lolog pa ughol taan tiou tonowen malep. Pale nagham payom sorok. Ve yaam saambu to ineep ila taan tonowen paam, pale nagham payom sorok ila ival tisob tonene matadi. Ula utavia mateeŋ tiom tonowe.” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abaram ilooŋ saveeŋ tonene, ve itud padi muul inimale pakuruuŋ di, ve isaav pa Epron ila ival tisob matadi ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","“Nene poia. Eemoghon ughur taliŋam payou. You naghaze naghol motin taan tiom tonowen. Tovenen taan atia pale ilat nimam muuŋ, ghoro nala natavia mateeŋ tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron ipamuul Abaram aliŋa ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tiina tiou, ulooŋ! Taan tonowen atia irau yaam silva 400 ma venen. Eemoghon tambaŋa paam. Ugholi pasa? Ituru tawatag tauud. Ula ve utavia azuwam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abaram ilooŋ Epron aliŋa, ve inin le yaam silva irau 400 itaghon saveeŋ to Epron isavia ila ival tiina matadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Tovenen taan to Epron to ineep izi Makpela igharau ndug Mamre, toman yaam saambu ve ai tisob to tiyoon ila taan tonowen, nene Abaram ighol motin di tinim le. Ve yes Hita tisob to tineep ila lupuuŋ tonenen, tilooŋ saveeŋ mbuaaŋ to yesuru, ve tighita pa matadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ghoro Abaram ila ighur azuwa Sara paatu ilooŋ ila yaam saambu to ineep ila taan Makpela igharau ndug Mamre izi taan Kanaan. (Ndug Mamre iza ite Ebron.) ");
INSERT INTO tuc_o_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tovenen taan tonowen toman yaam saambu to ineep ila, nene yes Hita tipuli inim Abaram le, ve ye ila igharaata inim mateeŋa toni inadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yoova ighur poia toni izaza to Abaram toman mbeb toni tisob, ve ila ila le Abaram inim olman waat. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Sawa eez, Abaram isaav pa mbesooŋa toni eez to olman ve imuuŋ pa ŋginiiŋ mbeb toni tisob ighaze: “Ulooŋ. You naghaze yom ughur nimam ila ŋgoig ve umbua saveeŋ ariaŋa toman ghou ila Maaron to iŋgin sambam ve taan ne iza tovene: Yes Kanaana to itiŋa tanepneep ne, yom irau ugham ndinatudi liva eta pa natug Isak maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Yom irau umuul ula pa ndug tiou ve siŋ tiou, ve ughita liva eta, ve ughami inim. Leso ivai natug.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mbesooŋa toni ighasoni: “Ighaze liva tonowen tini imum pa ipul ndug toni ve inim sualen, nene pale nagham vena? Pale namuul nanim nagham natum, ve naghuri ila ineep izi ndug tiom pughu tonowen?” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abaram ipamuul aliŋa ighaze: “Maau kat! Yom irau ughur natug imuul ila ndug tiou pughu maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Pasa, Maaron Yoova to iŋgin sambam, ye igham ghou napul siŋ to tamaŋ ve ndug tiou pughu, ve imbua saveeŋ ariaŋa toman ghou ighaze ye pale igham taan tonene payou ve papaghu tiou to muri pale tivot. Ye tau pale imbaaŋ aŋela toni imuuŋ payom. Tovenen yom pale irau ugham liva eta pa natug tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ighaze liva tonowen tini imum pa yamru anim sualen, nene saveeŋ mbuaaŋ tiom tonene irau ikis ghom maau. Eemoghon matam iŋgal: Ugham natug imuul ila ndug tiou pughu malep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Abaram isavsaav le isob, ghoro mbesooŋa tonenen ighur nima ila Abaram ŋgoi, ve imbua saveeŋ ariaŋa pani ighaze ye pale itaghon tiina toni aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ghoro mbesooŋa tonenen igham mbaliiŋ naol naol to tiina toni Abaram, ve ighur di tizala kamel saaŋgul poghodi, ve ipamundigin laghooŋ ve ila pa Naor ndug toni to ineep izi Mesopotamia. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ilaghlaagh ila le rabrab eez, ila ivot, ve ighita ya taiŋ eez ineep igharau ndug tonowen. Tovenen igham kamel toni tila tigharau ya dige, ve atedi izi. Rabrab to naol ne, ndiliva to ndug tonowen tila titibtib ya tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mbesooŋa tonenen isuŋ ila lolo ighaze: “O Yoova, Maaron to tiina tiou Abaram, aazne naghaze upatooŋ poia tiom pa tiina tiou, ve ugham uraat tiou anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aazne, you nayondyood igharau ya taiŋ tonene, ve nene sawa to ndiliva papaghu to paanu tinim pa tibuuŋ ya. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tovenen you pale nasaav pa liva eta tovene: ‘Uit uur tiom izi, ve ugham ag ya rita inim naghun.’ Ve ighaze ye ipamuul aliŋag ighaze: ‘Poia. Ughun lak. Ve you pale natib pa kamel tiom paam.’ Ighaze ye ipamuul aliŋag tovene, nene liva tonenen to yom taum usia pa mbesooŋa tiom Isak. Leso nawatag naghaze lolom ineep tuŋia ila to tiina tiou Abaram ve ughaze uuli itaghon saveeŋ mbuaaŋ tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ye isuŋsuŋ sone, ve ighita liva eez imbaad uur ila avara, ve ilaagh ila peria. Liva tonowen iza Rebeka. Tama Betuel, ye Abaram tazi Naor ve Milka natudi liva. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka, ye liva paghu, tamoot eta ila toni sone. Ve ye liva paghuna kat. Ye izila ya taiŋ tonowen ve itib ya ila uur toni le isob, ve imuul iza inim. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ghoro mbesooŋa tonenen ilaan iŋarua ila, ve isaav pani ighaze: “Ai, irau naghun ya rita ila uur tiom?” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebeka ipamuul aliŋa ighaze: “Tiina tiou, poia. Ughun lak!” Ve rikia moghon iit uur toni izi, ipakeepa, ve mbesooŋa tonenen ighun. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ighun le isob, ghoro Rebeka isaav pani muul ighaze: “You pale natib ya pa kamel tiom paam, leso tighun le irau di.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tovenen rikia moghon iliŋ ya izila oon to ŋgai tighunghun ila, ve imuul izila pa tibuuŋ ya. Ighamgham tovene, le kamel tisob tighun ya. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mbesooŋa le saveeŋ maau. Neneeŋa moghon, ve mata ilala pani ighaze ighita: Pale Yoova igham laghooŋ toni anoŋa ivot, ma maau? ");
INSERT INTO tuc_o_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamel tighun ya le isob, ghoro iwaan ŋoor milmilia eez, ve mbi milmilia ru to tigharaat di pa gol, ve igham di pa Rebeka. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ve ighasoni ighaze: “Usaav ghazooŋa payou. Tamam sei? Vena, irau yei nilat ruum tiam, ve nineep toman gham pa mboŋ?” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka ipamuul aliŋa ighaze: “You tamaŋ Betuel. Nditimbug to Naor yesuru Milka. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ruum tiei soso tiina. Irau aneep toman ghei. Ve aniiŋ katindi to kamel paam inepneep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mbesooŋa tonenen ilooŋ saveeŋ tonene, ve iput aghe, ighur nagho izila taan, ve ipait Yoova ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“You napait Yoova, Maaron to tiina tiou Abaram, pa poia toni. Pasa, ye lolo ineep tuŋia toman tiina tiou, ve iuluuli itaghon saveeŋ mbuaaŋ toni. Tauto igham pooz payou le nanim navot ruum to siŋ toni kat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ghoro Rebeka ilaan imuul ila ruum to tina, ve ipaes padi pa mbeb naol tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka livu iza Laban. Ye ighita ŋoor ve mbi milmilia to tineep ila Rebeka uzu ve nima, ve ilooŋ paesiiŋ toni, ghoro imundig ve ilaan ila pa ya taiŋ ighaze ighita ŋgeu tonenen. Ila ivot, ve ighita mbesooŋa to Abaram iyondyood toman kamel toni tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban isaav pani ighaze: “Poia to Yoova ineep toman ghom. Pughu vena to uyondyood sorok izi sualen? Unum tala pa ruum. Inamim to ghenooŋ ve kamel inadi paam, nagharaat di wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tovenen mbesooŋa tonenen igham kamel toni ve yesŋa tila pa ruum to Laban. Tila tivot, ghoro Laban iyou mburuguuŋ tizi pa kamel, ve igharaat inadi, ve igham adi kikiliiŋ ve aniiŋ. Ve igham ya ila pa mbesooŋa to Abaram toman uraata pida to yesŋa tinim. Leso timen aghedi pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ghoro tigharaat aniiŋ ve tighuri izi mbesooŋa to Abaram nagho. Leso ighan. Eemoghon ye isaav padi ighaze: “Poia. Aniiŋ ineep o. You naghaze nasavia saveeŋ tiou payam muuŋ.” Laban ipamuul aliŋa ighaze: “Poia. Usaav lak.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mbesooŋa tonenen ipamundigin saveeŋ toni ighaze: “You mbesooŋa to Abaram. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yoova ighur poia tiina iza to tiina tiou. Tovenen ye iza tiina, ve mbaliiŋ tau kat. Ye le makau, sipsip, mekmek, esele, ve kamel katindi kat. Ve ye le yaam gol ve silva katindi, ve mbesooŋa nditamoot ve ndiliva katindi paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tiina tiou azuwa Sara inim liva waat, ghoro ipoop Abaram le natu tamoot eez. Muri, natu tonowen pale iyoon pa mbeb tisob to tama. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tiina tiou isaav payou ve nambua saveeŋ ariaŋa tomani tovene: Yes Kanaana to yeiŋa ninepneep toman di we, irau nagham ndinatudi liva eta pa natu Isak maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ye ighaze nala pa tau siŋ toni, ve nakaal liva eta pa natu. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Sawa to naghaze napamundigin laghooŋ tiou, naghason tiina tiou: ‘Ighaze nandeeŋ liva eta, ve tini imum pa inim toman ghou, nene pale nagham vena?’ ");
INSERT INTO tuc_o_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ye ipamuul aliŋag ighaze: ‘Nepooŋ tiou toman laghooŋ tiou, you matag iŋgalŋgal Yoova ve nataghon ataam toni irau sawa isob. Ye tau pale imbaaŋ aŋela toni ilat toman ghom, ve iuul ghom. Leso uraat tiom anoŋa ivot. Tovenen yom pale irau ugham liva eta to siŋ to nditamaŋ pa natug Isak. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eemoghon ighaze ula uvot to siŋ tiou, ve tiyok payom maau, nene saveeŋ mbuaaŋ tonene irau ikis ghom maau.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Yo. Aazne rabrab, you nanim navot izi ya taiŋ to ndug tiam tonene, ve nasuŋ naghaze: O Yoova, yom Maaron to tiina tiou Abaram. Aazne, naghason ghom naghaze ugham laghooŋ tiou tonene anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","Ughita. You nayondyood igharau ya taiŋ tonene. Ighaze liva paghu eta inim pa tibuuŋ ya, you pale naghasoni tovene: ‘Irau naghun ya rita ila uur tiom?’ Ve ighaze ipamuul aliŋag ighaze: ‘Poia. Ughun lak. Ve you pale natib pa kamel tiom paam.’ Ighaze ipamuul aliŋag tovene, nene liva tonenen, to yom taum usia pa tiina tiou natu Isak.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Nasuŋsuŋ sone, ve naghita Rebeka imbaad uur ila avara ve inim peria. Ye izila itib ya le isob, ve imuul iza inim, ghoro nasaav pani naghaze: ‘Ai, irau ugham ya rita inim naghun?’ ");
INSERT INTO tuc_o_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Rikia moghon ve ye ighur uur toni izi, ve isaav payou ighaze: ‘Poia. Ughun lak. Ve you pale natib ya pa kamel tiom paam.’ Tovenen you naghun le isob, ve ye itib pa kamel tiou paam, ve tisob tighun le irau di. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ghoro naghasoni naghaze: ‘Tamam sei?’ “Ye ipamuul aliŋag ighaze: ‘You tamaŋ Betuel. Ve nditimbug to Naor yesuru Milka.’ Nalooŋ saveeŋ tonene, ve naghur ŋoor eez ila uzu, ve nanonogi pa mbi ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ghoro naput agheg, ve naghur naghog izila pa taan, ve napakur Yoova, ye Maaron to tiina tiou Abaram, ve napaiti pa poia toni. Pasa, ye igham pooz payou, le nanim navot to tiina tiou natu Betuel natu liva. Leso naghami ila pa natu Isak. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tovenen aazne, ighaze lolomim ineep tuŋia ila to tiina tiou Abaram, ve aghaze agham poiani itaghon ataam to toŋvetaz, ghoro asaav ghazooŋa payou ve nalooŋa. Ighaze maau, pale nakaal ataam ite paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban yesuru Betuel tipamuul aliŋa tighaze: “Mbeb tonene ivot ila to Yoova tau. Tauto yeru irau nisavia saveeŋ eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka inepneep. Ughami ve ala. Leso inim tiina tiom natu azuwa itaghon Yoova aliŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mbesooŋa to Abaram ilooŋ saveeŋ todi, ve iput aghe, ighur nagho izila taan, ve ipait Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ghoro iwaan mbaliiŋ milmilia pida to tigharaat di pa gol ve silva, toman uli popoia pida, ve igham di pa Rebeka. Ve Rebeka livu Laban yesuru tina paam, mbesooŋa tonenen igham ledi mbeb popoia pida to atiadi tintina. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ghoro toman ndita pida to yesŋa tinim ne, tighan ve tighun le isob, ve tigheen. Mboŋmaagh ghoro, mbesooŋa to Abaram imundig ve isaav pa Laban ighaze: “Yo, you naghaze namuul nala to tiina tiou. Vena, yam ayok?” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Eemoghon Rebeka livu Laban yesuru tina tipamuul aliŋa tighaze: “Ee-e, ula rikia malep. Liva paghu ineep toman ghei ris irau mboŋ saaŋgul ma venen, ghoro ala.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Eemoghon mbesooŋa to Abaram ipamuul aliŋadi ighaze: “Aŋguruut ghou malep. Ayok payou, ve namuul nala to tiina tiou. Pasa Yoova igham pooz payou ve laghooŋ tiou anoŋa ivot wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tovenen yesuru tisaav pani tighaze: “Ighaze venen, tapoi Rebeka tau inim, ve taghasoni, lolo vena?” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tovenen tipoi Rebeka inim, ve tighasoni tighaze: “Laak, lolom vena? Yamru ŋgeu tonene amundig to aazne ve ala, ma?” Ye ipamuul aliŋadi ighaze: “Vee, you naghaze nala.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ghoro tighur Rebeka toman liva mbesooŋa to iŋgini ne, ve yesŋa mbesooŋa to Abaram ve ndita to yesŋa tinim, tipamundigin laghooŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ve tighur poia to Maaron iza to Rebeka tighaze: “Livumai, yom pale unum tamtoghon ndiŋndiŋ ndiŋndiŋ tinandi. Ve papaghu tiom pale tilib pa koiadi, ve tigham taan todi inim ledi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ghoro Rebeka yesŋa ndiliva mbesooŋa toni pida tiza kamel, ve timundig tila. Nene ataam to mbesooŋa to Abaram igham Rebeka ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Sawa tonenen, Isak ipul taan suruvu to ya taiŋ Beer Lai Roi ineep pani, ve imuul ila pa taan suruvu to Negev. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Rabrab eez, ye ila ilaghlaagh izi ndug balim, ve ighamgham ŋgar. Mata iza le ighita kamel tilaagh tinim. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka paam, mata ila le ighita Isak. Tovenen rikia moghon izi pa kamel toni, ");
INSERT INTO tuc_o_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ve ighason mbesooŋa to Abaram ighaze: “Sa ŋgeu to ilaghlaagh inim we?” Mbesooŋa ipamuul aliŋa ighaze: “Nowe tiina tiou.” Tovenen Rebeka igham uli pida ve ipoon nagho pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Isak ila ivot todi, ve mbesooŋa tonenen ipaesia mbeb tisob to tivot pani izi Mesopotamia. ");
INSERT INTO tuc_o_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ghoro Isak igham Rebeka inim azuwa, ve tineep ila mbeez to tina Sara. Isak lolo pa Rebeka kat. Tauto irab Isak ate, ve lolo ipataŋan pa mateeŋ to tina Sara muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Muri ghoro, Abaram ivai liva ite iza Ketura. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura ipoop ndinatu liim ve eez. Izadi tovene: Simran, Yoksan, Medan, Midian, Isbak, ve Sua. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ndinatu, nene: Seba ve Dedan. Dedan papaghu toni, nene yes Asura, Letusa, ve Leuma. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ndinatu, nene: Epa, Eper, Anok, Abida, ve Elda. Yes tonene, to tivot ila to Abaram ve Ketura. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abaram ipul mbeb toni tisob tila to natu Isak. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Eemoghon sawa to Abaram inepneep mata iyaryaar sone, irei mbeb toni pida pa ndinatu nditamoot to Agar ve Ketura paam. Ghoro ighur di tila pa taan suruvu to ineep ila pa ndag iza. Leso tineep tigharau natu Isak sob. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abaram nepooŋ toni poia moghon le inim olman waat. Ndaman toni irau 175, ghoro imaat, ve ila igheen toman siŋ toni pida to timaat muuŋ wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Abaram ndinatu ru, Isak ve Ismael, tighur paatu ilooŋ ila yaam saambu to ineep ila taan Makpela igharau ndug Mamre. Muuŋ, taan tonowen to Zoar natu Epron. Zoar, ye Hit taamdi. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abaram ighol taan tonowen ila to yes Hita. Ve titavia Sara yesuru Abaram izi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Sawa to Abaram imaat, poia to Maaron ivool to natu Isak. Sawa tonenen, Isak inepneep igharau ya Beer Lai Roi. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","15","Nene Abaram natu Ismael toman papaghu toni pitiiŋ todi. Agar, ye liva mbesooŋa to Sara. Ye Isip tidi to ipoop Abaram natu Ismael. Ismael ndinatu, nene: Nebaiot, Kedar, Adbel, Mipsam, Misma, Duma, Masa, Aad, Tamar, Yetur, Napis, ve Kedema. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael ndinatu papaghu todi timasa tinim naol, ve tinim rumai saaŋgul ve ru, ve tila tineep izi taan todi todi. Tauto tiwaat Ismael ndinatu izadi pa ndug ve taan todi tonowen. Ismael ndinatu saaŋgul ve ru tonowen tisob tinim daba pa rumai todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael ndaman toni irau 137, ghoro imaat, ve ila igheen toman siŋ toni pida to timaat muuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ve papaghu toni tila tineep ila taan suruvu to ineep bodbodaaŋ pa taan Avila ve taan Sur. Taan tonowen igharau yes Isipa taan todi dige ve ataam tiina to ila pa Asiria. Ismael papaghu toni tilup di maau. Tineep saguan saguan pa taudi. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nene kamos to Abaram natu Isak toman papaghu toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ndaman to Isak irau tamoot ru (40), ghoro ivai Rebeka. Rebeka tama iza Betuel. Ye siŋ to Aram, ve ineep izi taan suruvu to Mesopotamia. Rebeka livu iza Laban. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka, ye liva uupa. Tovenen Isak isuŋ pa Yoova ve ighasoni ighaze iuuli. Yoova ilooŋ suŋuuŋ toni, ve iuul Rebeka ve apo. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebeka iyamaan tau ighaze ndinatu tipaparab ila apo lolo. Tovenen isaav pa tau ighaze: “Wai, pughu vena to pataŋani tonene ivot payou ne?” Ghoro ila isuŋ pa Yoova, ve ighasoni to ipaghazoŋan pataŋani tonowen pughu pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yoova isaav pani ighaze: “Tamtoghon pughudi ru to tineep ila apom lolo. Rouŋ ru pale tivot ilat tiom, ve tivalag di. Rouŋ eez pale tapiri ilib pa ite. Ve ŋgeu olman pale inim mbesooŋa pa ŋgeu muria.” ");
INSERT INTO tuc_o_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka sawa toni to popaaŋ ivot, ve onoon, ipoop nditamoot booga ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ŋgeu olman tini kaviaaŋa, ve bide oro. Tauto tiwaat iza Esau. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ghoro tazi ikis togha aghe gudu ve ana izi. Tovenen tiwaat iza Yakop. Sawa to Rebeka ipoop ndipain ru tonowen, Isak ndaman toni irau tamoot tol (60). ");
INSERT INTO tuc_o_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tinepneep le ndipain ru tonenen tinim ndolman. Esau, ye ŋgeu to ilaghlaagh su ve iŋgalŋgal ŋgai sagsag. Ve Yakop, ye ŋgeu oro maate, ve ighamgham uraat izi paanu moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak lolo pa Esau. Pasa, ye lolo pa ghaniiŋ ŋgai sagsag to su. Ve Rebeka, ye lolo pa Yakop. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sawa eez, Yakop igharaat sur poia, ve Esau ineep su ve ivot. Ye pitoola kat le tapiri isob. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Tovenen isaav pa Yakop ighaze: “Aiss, you pitool ghou le nasami kat. Sur kaviaaŋa tonanan, uzob ag rita inim naghun!” (Tauto tiwaat Esau iza ite tighaze Edom.) ");
INSERT INTO tuc_o_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Eemoghon Yakop isaav pani ighaze: “Poia. Eemoghon ituru taparabol pa inaad muuŋ, ve nagham inam nanim ŋgeu aidaba, ghoro nazob am sur.” ");
INSERT INTO tuc_o_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ipamuul aliŋa ighaze: “Aiss, paam namaat tonene. Inag to ŋgeu aidaba, nene mbeb sorok. Iuul ghou vena? Rikia ugham sur tonanan inim naghun.” ");
INSERT INTO tuc_o_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakop isaav pani muul ighaze: “Yom irau umbua saveeŋ toman ghou muuŋ ve upariaaŋa le iyaryaaŋ kat, ghoro nagham payom.” Tovenen Esau imbua saveeŋ tomani, ve ipariaaŋa le iyaryaaŋ kat ighaze yesuru tiparabol pa inadi, ve Yakop igham ina inim ŋgeu aidaba. ");
INSERT INTO tuc_o_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ye imbua saveeŋ toman tazi le isob, ghoro Yakop igham a mberet toman sur ila ighan ve ighun. Ghoro imundig ve ila. Ŋgar to Esau ighami, nene ipatooŋa ighaze ye mata velegin ina to ŋgeu aidaba ighaze nene mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Sawa pida inim ila, ghoro pitool tiina ivot muul izi taan suruvu to Kanaan, inimale muuŋ ivot ila sawa to Abaram. Tovenen Isak imundig ighaze ighau izila pa Isip. Ye ilaagh ila le ivot izi ndug Gerar. Ndug tonowen ineep ila taan to yes Pilistia, ve kinik Abimelek iŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Isak inepneep tonowe, ve Yoova ivot toni, ve isaav pani ighaze: “Uzila pa Isip malep. Uneep izi taan to you naghaze yom uneep pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tovenen uneep unum loom izi sualen. You pale naneep toman ghom, ve naghur poia tiou iza tiom. Pasa, you naghaze nagham taan isob tonene payom ve papaghu tiom to muri pale tivot. Leso nagham saveeŋ to muuŋ nambua toman Abaram ne anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","You pale nagham papaghu tiom tivot tinim naol kat tinimale pitum to sambam paroŋania, ve nagham taan tonene isob inim ledi. Ve papaghu tiom pale tinim ataam pa poia tiou iza to ndug tisob to taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Pasa, tamam Abaram, ye ilooŋ aliŋag ve itaghon ataam tiou. Tutuuŋ tiou, toman saveeŋ isob to you nasavia pani ve avog iyaryaaŋ pani naghaze itaghoni, ye mata kisini ve itaghoni kat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tauto Isak izila Isip maau. Ye ineep moghon izi ndug Gerar. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tinepneep tonowe, ve sawa to nditamoot to ndug tonowen tighason Isak pa azuwa, ye ipamuul aliŋadi ighaze: “Nene you livug.” Ye isaav tovene pasa, Rebeka, ye liva paghuna kat. Tovenen Isak imatughez ighaze pale tirabi imaat ve tigham azuwa. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak ineep mala ris izi ndug tonowen. Sawa eez, Abimelek to kinik to yes Pilistia, inepneep ruum lolo, ve mata ivot pa marai saambu, le ighita Isak isavag Rebeka. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tovenen Abimelek ipoi Isak inim, ve isaav pani: “Wai, liva tonanan, yom azuwam! Pughu vena to utoom ughaze yom livum?” Isak ipamuul aliŋa ighaze: “You namatughez naghaze pale arab ghou namaat ve agham azuwag. Tauto nasaav naghaze nene you livug.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tovenen Abimelek iyaana ighaze: “Wai, utombaan ghei tovene pasa? Inimale nditamoot tiei eta ila to azuwam, tone yom taum unum pughu pa sosor to yei nighami.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ghoro Abimelek isaav ariaŋa pa tamtoghon toni tisob ighaze: “Alooŋ! Ighaze tamtoghon eta igham samin ŋgeu tonene, ma azuwa, ye pale imaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ndaman tonenen, Isak ivazog aniiŋ ila taan tonowen le aniiŋ pughu eŋaeŋa anoŋadi tivot irau tamoot liim (100). Pasa, Yoova ighur poia tiina iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tovenen Isak a aniiŋ ve le mbeb katindi, ve iza tiina. Mbeb toni ivotvot, le ye inim mbaliiŋ tau kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ye le sipsip, mekmek, ve makau katindi. Ve mbesooŋa toni paam, katindi. Yes Pilistia tighita mbeb toni le ireu lolodi. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tauto tilalal mulin ya taiŋ tisob to muuŋ yes mbesooŋa to Abaram titai di. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ghoro kinik Abimelek isaav pa Isak ighaze: “Upul taan tiei, ve ughau ula. Pasa, tapirim ilib payei wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tovenen Isak ipul di, ve ila ivot izi taan raapa to Gerar, ve ighur ina to nepooŋ izi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ve ya taiŋ to muuŋ yes mbesooŋa to Abaram titai di ve yes Pilistia tilalal di, ye itai mulin di, ve iwaat izadi to muuŋ tama Abaram iwaat di. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ghoro yes mbesooŋa toni tila titai saambu ite izi ndug tonowen, le ya bokia iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Eemoghon yes ŋginiiŋ ŋgaia to ndug Gerar toman yes ŋginiiŋ ŋgaia to Isak tiwazoran di pa ya tonowen. Yes Gerara avodi iyaryaaŋ tighaze nene ya todi. Tauto Isak iwaat ya taiŋ tonenen iza Esek. Pasa, tiŋooŋ pa ya tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tovenen yes mbesooŋa to Isak tila titai ya paghu. Eemoghon ndiran pida tinim ve yesŋa mbesooŋa to Isak tiparzoor pa ya tonowen paam. Tovenen Isak iwaat ya tonowen iza Sitna. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak ipul ndug tonowen, ve ila itai ya ite inim tol pani. Ya taiŋ tonowen, le saveeŋa maau. Tovenen Isak iwaat iza Reobot, ve isaav ighaze: “Aa ghara Yoova ighur soso tiina pait pa taneep pani! Nene pale taneep pooi izi taan tonene, ve tamasa tanim naol.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Muri ghoro, Isak imundig muul, ve izala pa ndug Ber-Seba. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ila ivot tonowe, ve mboŋ, Yoova ivot toni, ve isaav pani ighaze: “You Maaron to tamam Abaram. Umatughez malep. Pasa, you naneep toman ghom. Tamam Abaram to mbesooŋa tiou ne ndamo payom, tauto you pale naghur poia tiou iza tiom, ve nagham papaghu tiom timasa tinim naol.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tovenen Isak indou yaam inim artaal, ve isuŋ pa Yoova izi ndug tonowen. Ve ighur ina to nepooŋ izi tonowe, ve mbesooŋa toni titai ya ite paam izi ndug tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Muri ghoro, Abimelek ipul ndug Gerar, ve inim ighaze ighita Isak. Ye inim toman ŋgeu ŋgara eez, iza Ausat, ve daba to yes ndaaba toni, iza Pikol. Yes tol tinim tivot to Isak, ");
INSERT INTO tuc_o_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ve ye ighason di ighaze: “Yam aghur koi payou, ve azurun ghou pa taan tiam wa. Vena to anim tiou muul?” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yes tipamuul aliŋa tighaze: “Yei nighilaal ghom nighaze Yoova ineep toman ghom. Tovenen nighaze itiŋa tambua saveeŋ ariaŋa pa talup ghiit tanim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ve nighaze yom umbua saveeŋ payei ughaze irau uwaghamun ghei maau. Ughita. Yei nigham samin ghom maau, ve nigham ŋgar popoia moghon payom le nighur ghom ula toman lolom poia. Ve aazne, poia to Yoova inepneep toman ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tovenen Isak igharaat aniiŋ tiina, ve yesŋa tighanghan. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mboŋ le ndugizau, mboŋmaagh kat, ve timundig ve tipariaaŋ saveeŋ mbuaaŋ todi le iyaryaaŋ kat. Ghoro Isak ighur di timuul tila pa ndug todi toman lolodi poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ndag ee moghon tonenen, mbesooŋa to Isak tinim ve tipaes pani tighaze: “Tiina tiei, saambu to yei nitaii ne, nighita ya bokbokia iza pani!” ");
INSERT INTO tuc_o_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tovenen Isak iwaat ya tonowen iza Seba. Tauto tiwaat ndug to ineep igharau ya tonowen iza Ber-Seba. Iza tonene inepneep sone. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ndaman toni irau tamoot ru (40), ghoro ivai Hit tidi ru, izadi Yudit ve Basemat. Yudit, ye Beri natu liva. Ve Basemat, ye Elon natu liva. ");
INSERT INTO tuc_o_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Eemoghon loom tidi ru tonowen ŋgar todi irau rawadi Isak ve rawadi liva Rebeka lolodi maau. Tauto tigham di lolodi ipataŋan kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Olman Isak inim olman waat wa. Ve mata ipis, le irau ighita ndug muul maau. Sawa eez, ye ipoi natu olman Esau ighaze: “Natug!” Esau iyok pa aliŋa ighaze: “Taug nene. Sa?” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ghoro olman Isak isaav pani ighaze: “Ulooŋ. You nanim olman waat wa, ve nakankaan pa mateeŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tovenen ugham pane tiom, ve ula pa su, ve ukaal ag aniiŋ ziga. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Leso ugharaat ag sur to you lolog pani ne, ve ughami inim naghun. Ghoro naghur poia to Maaron iza tiom. Ve muri ighaze namaat, namaat lak.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Isak yesuru natu Esau tisavsaav, ve olman tidi Rebeka taliŋa irab saveeŋ todi. Tovenen Esau ila pa su ve ikaal aniiŋ ziga, ve Rebeka isaav pa natu Yakop ighaze: “Ŋgaramus nalooŋ tamam isaav pa togham ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Esau, ugham aniiŋ ziga eta to su inim ve ugharaat ag sur to you lolog pani ne, ve ughami inim naghun. Ghoro naghur palotiiŋ tiou iza tiom ila Maaron mata. Ve muri ighaze namaat, namaat lak.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tovenen natug, ulooŋ aliŋag, ve utaghon saveeŋ tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ula ndug to ŋgai toit tinepneep pani, ve ughita mekmek papaghu ruta to tubudi, ghoro ugham di tinim. You pale nagharaat tamam a sur poia to ye lolo pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Leso ughami ila pani ve ighun. Ve ighur poia to Maaron iza tiom le isob, ghoro imaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Eemoghon Yakop ipamuul tina aliŋa ighaze: “Tinaŋ, aliŋam poia. Eemoghon toghag Esau, ye tini ororoma. Ve you maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ighaze tamaŋ ikis ghou ris, nene pale ighilaal ghou, ve igham ŋgar ighaze you nagham mogheraaŋ pani. Ghoro ighur poia to Maaron iza tiou maau, ve ighur samia iza tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Eemoghon tina isaav pani ighaze: “Natug, ugham ŋgar naol malep. Ulooŋ aliŋag tonene, ve utaghoni. Ighaze ye ighur samia iza tiom, nene pale you nambaad pataŋani tonenen. Ula ugham mekmek tinim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tovenen Yakop imundig, ve ila igham mekmek ru tinim to tina. Rebeka nima rikrikia pa gharatooŋ sur poia to Isak lolo pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Le isob, ve ila igham nonogiiŋa poia kat to natu olman Esau to ineep mbeez toni lolo, ve ighami ila to Yakop, leso indudi pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ghoro ikau mekmek uli ila Yakop lua ve ila nima paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ve igham sur toman mberet to ye igharaata, ve ighuri ila to Yakop. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakop ila to tama, ve ipoii ighaze: “Tamaŋ, nanim wa!” Tama Isak ighaze: “Natug, taug nene. Ve yom sei?” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakop isaav pani muul ighaze: “You Esau, natum aidaba. Sur toman aniiŋ ziga to yom usaav payou pani, tauto naghami nanim. Umundig ve ughun, ve ughur poia to Maaron iza tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak ilooŋ saveeŋ tonene, ve ighasoni ighaze: “Wai, natug, vena to yom undeeŋ mbeb rikia moghon?” Yakop ipamuul aliŋa ighaze: “Maaron tiom Yoova iuul ghou. Tauto rikia moghon ve nandeeŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ghoro Isak isaav pani muul ighaze: “Natug, unum ugharau ghou, ve nakis tinim ve nayamaana. Leso nawatag kat: Yom natug Esau, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tovenen Yakop ila igharaui, ve tama ikis tini ve iyamaana, ghoro isaav pani ighaze: “Aliŋam inimale Yakop aliŋa. Eemoghon nimam inimale Esau nima.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Isak ighilaal Yakop maau. Pasa, nima ororoma inimale togha Esau. Tovenen Isak ighaze ighur poia to Maaron iza toni. Eemoghon lolo ru sone. Tovenen ighasoni muul ighaze: “Onoon, natug Esau taum tonene?” Yakop ipamuul aliŋa ighaze: “Vee, you taug tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tovenen Isak isaav pani ighaze: “Natug, ugham sur tonanan inim. Lolog pa naghun sur to yom ugharaata toman ziga to su. Naghun le isob, ghoro naghur poia to Maaron iza tiom.” Tovenen Yakop igham sur ila to tama Isak ve ighun. Ve igham a ya vaen paam ila ighun. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tama Isak ighun le isob, ve isaav pani ighaze: “Natug, unum usavag ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tovenen Yakop ila isavag tama. Isak iyaaz Esau vuzi to ineep ila nonogiiŋa toni, ve ighur poia to Maaron iza to Yakop ighaze: “Aa, natug tonene, vuzi inimale su to poia to Maaron ineep pani! ");
INSERT INTO tuc_o_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Maaron pale igham waam tiina to sambam izi payom, ve ipambees taan tiom. Leso ŋgoreeŋa tiina, ve aniiŋ ve vaen katindi tivot payom. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ndug ndug pale timbees payom. Ve taan pida tamtoghona pale tiput aghedi payom ve tipakur ghom. Yom pale unum tiina pa toŋvetaz tiom, ve tinam ndinatu tiput aghedi payom. Tamtoghon tisob to tighur samia iza tiom, nene pale taudi tindeeŋ pataŋani. Ve yes to tighason Maaron pa ighur poia toni iza tiom, nene pale poia toni iza todi paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak ighur poia to Maaron iza to Yakop le isob, ghoro Yakop ipuli, ve ivot ila. Mala maau ve togha Esau ineep su ve ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ye paam igharaat sur poia kat, ve ighami ila to tama, ve isaav pani ighaze: “Tamaŋ, you nagharaat sur tiom toman ziga to su, tauto naghami nanim! Umundig ve ughun, ve ughur poia to Maaron iza tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak ilooŋ saveeŋ toni, ve ighasoni ighaze: “Wai, yom sei paam?” Esau ipamuul aliŋa ighaze: “You Esau, natum aidaba.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak ilooŋ saveeŋ tonene le tini irur kat, ve isaav pani ighaze: “Waii, yom unum sone, ve ŋgeu eez igham sur toman ziga to su inim ve naghun. Nene sei? You naghur poia to Maaron iza toni wa. Ve onoon kat, palotiiŋ tonowen pale ineep toni.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ilooŋ tama saveeŋ toni, le lolo isami pa tau, ve itaŋ tiina, ve itaŋ roran tama ighaze: “O tamaŋ, ughur poia to Maaron iza tiou paam!” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Eemoghon Isak isaav pani ighaze: “Wai, palotiiŋ to naghaze nagham payom, tauto tazim inim itombaan ghou, ve ighami ila wa!” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tovenen Esau isaav ighaze: “Oyais, ŋgeu tonowen, tiwaat iza Yakop le deŋia kat pani! Pasa, ye itombaan ghou pae ru wa! Muuŋ, itombaan ghou ve igham inag inim ŋgeu aidaba. Ve aazne, iyub palotiiŋ tiou paam.” Ghoro Esau ighason tama muul ighaze: “Tamaŋ, vena? Lem palotiiŋ eta payou maau?” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak ipamuul aliŋa ighaze: “Wai, you naghur tazim inim tiina payom, ve naghur toŋvetaz tiam tisob tinim mbesooŋa pani wa. Ve naghason Maaron pa igham aniiŋ ve vaen anoŋadi katindi tivot pani, leso ineep pooi. Tovenen natug, mbeb eta ineep muul pa nagham payom maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eemoghon Esau itaŋ roran tama muul ighaze: “Tamaŋ vena? Palotiiŋ tiom ee moghon kat tonowen? Ite paam maau? O tamaŋ, ughur poia to Maaron iza tiou paam!” Ghoro Esau itaŋ muul toman aliŋa tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tama Isak ipamuul aliŋa ighaze: “Ndug tiom to nepooŋ, pale ineep mala pa taan ŋgoreeŋa, ve waam to sambam irau izi payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yom pale uparab pa buza, ghoro uneep pooi. Ve pale unum mbesooŋa pa tazim. Eemoghon muri pale uzoor pooz toni, ve irau iŋgin ghom muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ikis malmaliiŋ toni pa Yakop ariaŋa. Pasa palotiiŋ toni, tauto tama ighuri iza to Yakop wa. Tovenen igham ŋgar ila lolo ighaze: “Mala maau pale tamamai imaat. Moŋiiŋ toni ighaze isob, ghoro narab tazig Yakop imaat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Eemoghon titig Rebeka taliŋa pa ŋgar to Esau ighaze ighami. Tovenen ipoi Yakop inim, ve isaav pani ighaze: “Natug, ulooŋ. Togham Esau ighaze irab ghom umaat, ghoro lolo poia ve ate izi. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tovenen ulooŋ aliŋag, ve umundig rikia moghon, ve ughau ula to livug Laban to ineep izi Aran we. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ula uneep tomani le togham ate izi o. ");
INSERT INTO tuc_o_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ighaze lolo iluum, ve lolo imaagh pa ŋgar to ugham pani, nene pale nambaaŋ ilat payom, ghoro umuul unum. Pasa, you namatughez: Pale yamru aparab ve amaat pa sawa ee moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ghoro Rebeka isaav pa Isak: “Oyai, ndirawaad liva to Hita tidi ne, tinig imum padi kat. Lolog pa Yakop ivai liva eta to taan tonene inimale yes tonene malep. Ighaze ye igham tovene, poia pa namaat nala. Naneep pasa?” ");
INSERT INTO tuc_o_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tovenen Isak ipoi Yakop inim, ve ighur poia to Maaron iza toni, ghoro avo iyaryaaŋ pani ighaze: “Yom irau uvai Kanaan tidi eta maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Umundig ula pa taan suruvu to Mesopotamia, ve ula ruum to timbum Betuel, ghoro uvai wagham Laban natu liva eta. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne, pale ighur poia toni iza tiom, ve igham papaghu tiom tivot tinim naol, ve rumai katindi tivot ilat tiom. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Poia toni to muuŋ iza to Abaram, pale iza tiom ve papaghu tiom paam. Leso taan to aazne uneep unum loom pani ne, inim lem. Pasa, taan tonene, Maaron ighuri inim timbum Abaram le.” ");
INSERT INTO tuc_o_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak isavsaav pa Yakop le isob, ghoro ighuri ila pa Mesopotamia. Leso ineep toman wagha Laban to Betuel natu. Laban, ye siŋ to Aram. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ilooŋ tighaze Isak ighur poia to Maaron iza to Yakop, ve ighuri ila pa Mesopotamia, leso ivai izi tonowe. Ve avo iyaryaaŋ pani ighaze ivai Kanaan tidi eta malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau ighita Yakop itaghon tama ve tina aliŋadi, ve ila pa Mesopotamia, ");
INSERT INTO tuc_o_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ghoro ighilaal ighaze Kanaan tidi ru to ye ivai di, tama Isak lolo padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tovenen Esau ipul tama ve tina, ve ila to tama Ismael, ghoro ivai liva ite, iza Maalat. Maalat livu iza Nebaiot. Maalat ve Nebaiot, nene Ismael ndinatu. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakop imundig, ipul ndug Ber-Seba, ve ighaze ila pa ndug Aran. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ye ilaagh ila le ivot ndug eez, ve mboŋ izi pani. Tovenen igham yaam eez inim ali pani, iyalia, ve igheen. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ye ivib, ve ighita mbeb eez inimale ndeet to iyoon izi taan, ve izala pa sambam. Ve yes aŋela to Maaron titaghoni tizizi ve tizazala. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ghoro ighita Maaron tau iyoon izi dige, ve isaav pani ighaze: “You Yoova. You Maaron to timbum Abaram, ve Maaron to Isak. Taan to yom ugheen pani ne, you pale nagham payom toman papaghu tiom. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Papaghu tiom pale timasa tinim naol tinimale ghavuur to taan, le tirau ndug. Pida pale tila pa rag pughu, ve pida tila pa yavaar pughu, ve pida tila pa daudau pughu, ve pida tila pa kagu pughu. Ve yamŋa papaghu tiom pale anim ataam pa poia tiou iza to ndug tisob to taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ulooŋ. Ndug sine to yom ula uneep pani, you pale naneep toman ghom ve matag payom. Ve muri, you pale nagham ghom umuul unum pa taan tonene. Tovenen you irau napul ghom maau. Pale naneep toman ghom le nagham saveeŋ mbuaaŋ tiou tonene anoŋa ivot payom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ghoro Yakop imundig mata iyaryaar, ve isaav pa tau ighaze: “Wai, onoon kat, Yoova ineep izi ndug tonene, eemoghon you nawatagi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tovenen matughezaaŋ tiina ighami, ve isaav ighaze: “You namatughez kat. Pasa, ndug tonene patabuaŋ! Onoon kat, nene Maaron tau ina. Ataam to ndug sambam ineep sualen.” ");
INSERT INTO tuc_o_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakop izi igheen muul le ndugizau. Ghoro imundig, igham yaam to iyalia inim ali, ve ipayoonda inim ghilalooŋ pa ndug tonowen, ve iliŋ ŋgoreeŋ izala pogho. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ye iwaat ndug tonowen iza Betel. Muuŋ, ndug tonenen iza Lus. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ghoro Yakop imbua saveeŋ ariaŋa ila lolo tovene: “Ighaze Maaron ineep toman ghou, ve mata payou pa laghooŋ tiou tonene, ve igham ag aniiŋ ve leg nonogiiŋa to nandud ghou pani, ve ighaze naneep poia moghon le irau namuul nala pa ruum to tamaŋ, nene pale Yoova inim Maaron tiou, ve nambees pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Yaam to napayoonda ne, pale ipatooŋ ndug tonene ighaze, nene Maaron ina.” Ghoro imbua saveeŋ toman Maaron ighaze: “Onoon kat, mbeb to yom ugham payou, you pale navalag di tisob tinim ndouŋ saaŋgul, ve naghur ndouŋ eez ilat payom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakop ipamundigin laghooŋ toni muul, ve ilaagh ila ivot ndug eez to yes to taan todi ineep ila pa ndag iza. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mata ila le ighita sipsip rouŋ tol tighengheen tigharau ya taiŋ eez. Pasa, moghon moghon tamtoghon titibtib ya tonowen ve tipapaghun sipsip todi. Ya tonowen, tipoon avo pa yaam babaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ndug tonowen gabuadi tovene: Ighaze rabrab izi, ve sipsip tisob tila tivot ya tonowen dige, ghoro ŋginiiŋ ŋgaia tinim ve tinduur yaam babaŋa ighau ila saguan. Leso titib ya pa sipsip ve tighun. Le isob, ghoro tipoona muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakop iŋarua yes ŋginiiŋ ŋgaia tonowen ila, ve ighason di ighaze: “Ndiran tiou, yam to sa ndug? Yes tipamuul aliŋa tighaze: “Yei to ndug Aran.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tovenen Yakop ighason di muul ighaze: “Yam awatag Naor timbu Laban, ma maau?” Yes tighaze: “Vee, yei niwatagi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakop ighason di muul ighaze: “Vena, ye ineep pooi?” Yes tipamuul aliŋa tighaze: “Vee, ye ineep poia. Ughita. Natu liva Rael toman sipsip todi, to tinim we.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ghoro Yakop isaav padi muul ighaze: “Aghita. Ŋgaramus ndag tiina, ve sipsip irau tilooŋ tila sirsiir lolo sone. Agham adi ya ve tighun le isob, ghoro agham di timuul tila tighan kikiliiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Eemoghon yes tisaav pani tighaze: “Ee-e, vene maau. Yei irau nineep ve nisaŋan sipsip tisob tinim peria, ghoro ninduur yaam tonene ila dige, ve nitib adi ya ve tighun.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakop yesŋa ŋginiiŋ ŋgaia tonenen tisavsaav sone, ve Rael ighereb sipsip to tama tinim tivot. Pasa, ye to iŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakop ighita wagha Laban natu liva Rael toman sipsip toni, ve imundig ila pa ya taiŋ tonenen, induur yaam babaŋa ila saguan pa ya avo, ve itib ya pa sipsip ve tighun. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakop lolo poia kat pa ighita livu. Tauto isavagi ve itaŋ tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ve ivotia tau pani ighaze: “You tonene siŋ to tamam! You tinaŋ Rebeka.” Rael ilooŋ saveeŋ tonene, ve rikia moghon ilaan ila peria to tama, ve ipaes pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ilooŋ wagha Yakop varu, tovenen imundig ve ilaan ila ighaze ighita. Ila ivot toni, ve tini iza ve isavagi toman lolo poia. Ve ighami yesuru tila pa ruum. Ghoro Yakop ipaesia laghooŋ toni, ve Laban ilooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yakop ipaes le isob, ve Laban isaav pani ighaze: “Onoon kat, ituru siŋ ee moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yakop ineep toman Laban irau kaiyo eez, ghoro Laban izi ve isaav pani ighaze: “Onoon, yom siŋ tiou kat. Eemoghon ugham uraat payou sorok, nene poia maau. Tovenen usaav ghazooŋa payou. Lolom pa nagham sa mbeb inim lem atia?” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ndinatu liva ru. Olman iza Lea, ve muria iza Rael. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea nagho paghuna, ve paghuna kat maau. Ve Rael, ye paghuna kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakop lolo pa Rael. Tovenen isaav pa Laban ighaze: “You naghaze navai natum liva Rael. Ighaze uyok payou, ghoro nagham uraat payom irau ndaman liim ve ru.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ipamuul aliŋa ighaze: “You lolog pa nagham Rael pa ŋgeu ite paam maau. Ighaze nagham payom ve uvaii, nene poia kat. Tovenen uneep toman ghou ve ugham uraat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakop igham uraat pa Laban irau ndaman liim ve ru, leso ivai Rael. Eemoghon ye ighita ndaman liim ve ru tonenen inimale sawa mala maau. Pasa, lolo pa Rael kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ndaman liim ve ru tonenen isob, ghoro Yakop isaav pa Laban ighaze: “Sawa to yom ughuri payou, tauto napasobi wa. Ugham liva tonanan inim navaii!” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tovenen Laban igham ghanghaniiŋ tiina, ve ipoi tamtoghon tisob to ndug tonowen tinim tilup di pa ghanghaniiŋ to vaiuuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Eemoghon mboŋ tonenen, ye igham kaarom ve ighur natu liva olman Lea ila to Yakop ve yesuru tigheen. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ve igham liva mbesooŋa toni eez, iza Silpa pa Lea, leso imbees pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mboŋmaagh, Yakop imundig ve mata izi le ighilaal Lea ighengheen izi dige! Tovenen ila isaav pa Laban: “Wai, ugham ŋgar tonene payou pasa? You nagham uraat payom leso navai Rael. Pughu vena to utombaan ghou?” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ipamuul aliŋa ighaze: “Maau. To muuŋ ve inim, tutuuŋ tiei ineep tovene: Liva muria irau ivai muuŋ pa liva olman maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tovenen yom uneep le irau ghanghaniiŋ to Lea isob, ghoro naghur Rael paam ilat. Eemoghon yom irau ugham uraat payou irau ndaman liim ve ru muul.” ");
INSERT INTO tuc_o_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakop ilooŋ saveeŋ tonene, ve itaghoni moghon. Tovenen mboŋ liim ve ru to ghanghaniiŋ to vaiuuŋ tonenen, ye ineep toman Lea. Ghoro Laban ighur natu liva Rael paam ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ve ighur liva mbesooŋa toni ite, iza Bila, ila to Rael, leso imbees pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tovenen Yakop yesuru Rael tigheen paam. Yakop lolo pa Rael kat. Eemoghon Lea, Yakop lolo pani kat maau. Yakop ineep toman Laban, ve igham uraat pani irau ndaman liim ve ru muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yoova ighita Yakop lolo pa Lea kat maau. Tovenen iuul Lea le apo. Eemoghon Rael, ye uupa. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea ipoop natu aidaba, ve isaav ighaze: “Yoova ighita pataŋani tiou, tauto igham leg natug tonene. Aazne, pale azuwag lolo payou kat.” Tovenen iwaat natu tonowen iza Ruben. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tinepneep le Lea apo muul, ve ipoop natu tamoot ite. Tovenen isaav ighaze: “Yoova ilooŋ taŋiiz tiou, ve iwatag ighaze azuwag lolo ineep tiou kat sone. Tauto igham leg natug ite tonene.” Tovenen Lea iwaat natu tonowen iza Simeon. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tinepneep le Lea apo muul, ve ipoop natu tamoot ite inim tol pani. Tovenen isaav ighaze: “Aazne, pale azuwag lolo ineep tuŋia inim tiou. Pasa, napoop le ndinatu nditamoot tol wa.” Tauto iwaat natu tonowen iza Levi. ");
INSERT INTO tuc_o_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tinepneep le Lea apo muul, ve ipoop natu tamoot ite inim paaŋ. Tovenen isaav ighaze: “Aazne, you napait Yoova.” Tauto iwaat natu tonowen iza Yuda. Lea ipoop Yuda, ghoro popaaŋ toni imot, ve ineep le mala. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rael ighita ighaze ye irau ipoop Yakop le natu eta maau. Tovenen iriu togha liva, ve isaav pa Yakop ighaze: “Ugham leg natug eta lak! Ighaze maau, you pale namaat!” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakop ilooŋ saveeŋ tonene, le ate yabyab. Tovenen isaav pa Rael ighaze: “Wai! You Maaron, leso nagharaat apom ve upoop? Maaron tau, to ipoon apom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rael isaav pani muul ighaze: “Poia. Ughita. Liva mbesooŋa tiou Bila inepneep. Ughami ve yamru agheen. Leso ipoop leg natug eta.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tovenen Rael ighur liva mbesooŋa toni ila to Yakop ve yesuru tigheen. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ghoro Bila apo, ve ipoop Yakop le natu tamoot eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tovenen Rael isaav ighaze: “Aa, ghara Maaron iŋgabiiz ghou ighaze leg sosor eta maau. Pasa, ye ilooŋ suŋuuŋ tiou, ve igham leg natug tamoot tonene.” Tauto iwaat natu tonowen iza Dan. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tinepneep le Bila apo muul, ve ipoop natu ite inim ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tovenen Rael isaav ighaze: “Yeru toghag liva niwatovan tapirimai, ve naparab ariaŋa le nalib pani wa.” Tauto iwaat natu tonowen iza Naptali. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ighita tovene: sawa toni to popaaŋ, nene isob. Tovenen ighur liva mbesooŋa toni Silpa ila to Yakop inim azuwa ite. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","11","Ghoro Silpa apo, ve ipoop Yakop le natu eez. Tauto Lea isaav ighaze: “Nene mbeb poia to ivot payou!” Tauto iwaat natu tonowen iza Gat. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tinepneep le Silpa, to liva mbesooŋa to Lea ne, ipoop Yakop le natu tamoot ite inim ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tauto Lea isaav ighaze: “Aazne, you lolog poia kat! Ve yes ndiliva to paanu paam pale lolodi poia toman ghou.” Tovenen Lea iwaat natu tonowen iza Aser. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sawa eez to lupuuŋ wit anoŋa, Ruben ilaghlaagh ila uum lolo, le ighita waar anoŋa pida, ve iyou di tila to tina Lea. Mbeb tonowen, yes tighur ila tighaze ipazaagh nditamoot ve ndiliva leso tigheen ve ndiliva apodi. Rael ighita, ve isaav pa Lea ighaze: “Ai, mbeb to natum ighami, ugham leg pida inim!” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Eemoghon Lea ipamuul aliŋa ighaze: “Wai! Yom ugham azuwag ipul ghou wa. Ve aazne ughaze ugham mbeb to natug tonene paam? Maau kat!” Tovenen Rael isaav pani muul ighaze: “Poia. Ugham leg pida. Ve mboŋ aazne, pale nasaav pa Yakop ilat yamru agheen inim gholiiŋ waar anoŋa to natum ighami ne atia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Rabrab izi, ghoro Yakop imuul inim paanu, ve Lea iŋarua ila, ve isaav pani ighaze: “Ulooŋ. Mboŋ aazne, yom irau unum tiou. Pasa, naghol ghom pa waar anoŋa to natug wa.” Tovenen mboŋ tonenen, Yakop ila to Lea, ve yesuru tigheen. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Maaron ilooŋ suŋuuŋ to Lea, ve iuuli apo muul, ve ipoop natu tamoot ite inim liim. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tovenen Lea isaav ighaze: “You naghur liva mbesooŋa tiou ila to azuwag, tauto Maaron igham leg atia poia tonene.” Tovenen iwaat natu tonowen iza Isakar. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tinepneep le Lea apo muul, ve ipoop natu tamoot ite inim liim ve eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ve isaav ighaze: “Aazne, Maaron igham leg mbeb poia eez. Tovenen azuwag pale lolo imuul payou ve ipakur ghou. Pasa, napoop le ndinatu liim ve eez wa.” Tauto iwaat natu tonowen iza Zebulun. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Muri ghoro, Lea ipoop liva eez, ve iwaat iza Dina. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Ghoro Maaron mata iŋgal Rael paam, ve ilooŋ suŋuuŋ toni. Tovenen iuul Rael ve apo, ve ipoop natu tamoot eez. Tauto Rael isaav ighaze: “Aa, ghara Yoova igham leg natug ve mayag isob! ");
INSERT INTO tuc_o_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Eemoghon naghaze ye igham leg natug tamoot ite paam, ghoro poia.” Tovenen iwaat natu tonowen iza Yosep. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rael ipoop Yosep le isob, ghoro Yakop isaav pa Laban ighaze: “Olman, naghaze uyok payou, leso namuul nala pa ndug tiou ve taan tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yom uwatag: You nakaria uraat payom wa. Tovenen upul ndizwag toman ndinatug leso nimundig nila. Pasa, uraat to nagham payom, tauto naghol di ilat tiom wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Eemoghon Laban ipamuul aliŋa ighaze: “Wai waghag! Ituru taneep ris paam o. Mbeb pida tivot tinim ghilalooŋ payou, ve naghilaal naghaze yom ndamom payou, tauto poia to Maaron iza tiou ve leg mbeb katindi. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tovenen naghaze naŋguruut ghom uneep toman ghou. Yo, usaav ghazooŋa payou. Lolom ughaze nagham sa mbeb inim lem atia leso ituru taneep?” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakop ipamuul aliŋa ighaze: “Taum uwatag: You nakaria uraat payom. Tauto ŋgai tiom timasa tinim naol. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Muuŋ, lem ŋgai naol maau. Eemoghon you nanim naneep toman ghom, tauto ŋgai tiom timasa tinim naol kat. Tovenen you, tauto poia to Maaron iza tiom. Pale ŋeez o nagham uraat pa nauul ndizwag ve ndinatug?” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Tovenen Laban ighasoni muul ighaze: “Yom ughaze nagham lem sa?” Yakop ipamuul aliŋa ighaze: “Yom irau ugham leg mbeb eta to aazne maau. Ve vena? Irau uyok payou to aazne, ve nala nayou sipsip ndinatu asosoŋadi ve mekmek galgaliiŋ tisob tinim leg? Nene atia to lolog pani. Ighaze uyok pa aliŋag tonene, ghoro naneep ve naŋgin ŋgai tiom muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ve muri, yom irau unum ughita ŋgai to tineep toman ghou, leso uwatag ughaze you ŋgeu yubyub maau. Nene atia to yom ugham payou. Ve ighaze ughita mekmek eta to galgaliiŋ maau, ma sipsip eta to asosooŋa maau tilaghlaagh toman ŋgai tiou, nene yom irau uwatag ughaze you nayubi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ilooŋ saveeŋ to Yakop, ve iyok pani ighaze: “Poia. Pale nataghon aliŋam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Eemoghon Laban itaghon saveeŋ todi maau. Pasa, sawa tonenen, ye imundig ila igham mekmek nditamoot tisob to tinidi mbutmbutuuŋ, ve mekmek paŋgaar tisob to galgaliiŋ, ve sipsip ndinatudi tisob to asosoŋadi. Ŋgai tisob tonowen, ye iŋguaaz di tila to tau ndinatu, leso tiŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yesŋa ndinatu tigham ŋgai tonenen, ve tilaagh irau mboŋ tol. Tilaghlaagh tila le tivot ndug eez, ghoro tineep ve tiŋgin ŋgai todi izi tonowe. Ve Yakop ineep ve iŋgin ŋgai pida to Laban ipul di tizi tineep. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Eemoghon Yakop igham ai boga mbiti pida, ve isoi ulidi le tinim mbutmbutuuŋ pisosooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Ghoro ipayoon di tigharau oon to ŋgai tighunghun ya ila. Pasa, ye iwatag: nene sawa to ŋgai nditamoot tiip pa ŋgai paŋgaar. Tovenen sawa to mekmek ve sipsip tinim pa tighun ya, tighita ai soiiŋ mbutmbutuuŋ tonowen, ghoro ŋgai nditamoot tiip pa ŋgai paŋgaar igharau ai tonowen. Ve muri, sawa to popaaŋ, tipoop ndinatudi mbutmbutuuŋ ve galgaliiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakop ighur ndinatudi tonowen tineep saguan pa Laban ŋgai toni, leso tinim le. Ve sipsip tovene paam. Sawa to nditamoot tighaze tiip pa ŋgai paŋgaar, Yakop ighur naghodi ila pa Laban mekmek toni to mbutmbutuuŋ ve asosoŋadi, leso tipoop ndinatudi mbutmbutuuŋ ve asosoŋadi. Ye ighamgham tovene, le ŋgai toni timasa tinim naol kat. Ve ighur di tila tineep saguan pa Laban toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tovenen sawa to ŋgai tubudi tighaze tiip pa ŋgai paŋgaar, Yakop ipapayoon ai boga mbutmbutuuŋ tigharau oon to ŋgai tighunghun ya ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Eemoghon sawa to ŋgai koŋkoŋiŋadi tighaze tiip pa ŋgai paŋgaar, ye ipas ai boga tonowen tighau. Tovenen Yakop le ŋgai tubudi moghon. Ve Laban toni, nene koŋkoŋiŋadi moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ataam tonene to Yakop inim mbaliiŋ tau. Ye iraua kat pa mekmek, sipsip, mbesooŋa toni ndiliva ve nditamoot, kamel, ve esele. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Muri ghoro, tipaes pa Yakop tighaze Laban ndinatu tisavsaav tighaze: “Yakop tonowen, ye iyou mbeb to tamaan tisob tinim le wa. Mbeb toni to naol we, tisob tivot ila to tamaan moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ve Yakop ighita Laban paam, ighur dadabu pani. Lolo poia pani inimale muuŋ maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ghoro Maaron isaav pa Yakop ighaze: “Umundig, ve umuul ula pa taan to nditamam ve nditimbum, ve uneep toman di. You pale naneep toman ghom ve matag payom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tovenen Yakop imbaaŋ ila pa Rael yesuru Lea ighaze tila tivot toni izi paanu dige to ye iŋginŋgin ŋgai pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yesuru tila tivot toni, ve ye isaav padi ighaze: “Alooŋ. Aazne, you naghita tamamim lolo poia payou inimale muuŋ maau. Eemoghon Maaron to tamaŋ inepneep toman ghou ve mata payou. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","7","Yamru awatag: Ndaman ndaman, you narab taug pa uraat to tamamim. Ve sawa naol, ye igham kaarom payou, ve itortoor aliŋa pa atia tiou. Eemoghon Maaron ipoona, tauto ye irau iwaghamun ghou kat maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sawa to tamamim isaav payou ighaze: ‘Mekmek galgaliiŋ pale tinim lem atia,’ mekmek tisob tipoop galgaliiŋ moghon. Ve sawa to ye ighaze: ‘Mekmek mbutmbutuuŋ pale tinim lem atia,’ ghoro mekmek tisob tipoop mbutmbutuuŋ moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ataam tonene, to Maaron ipas ŋgai to tamamim, ve igham di tinim leg. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sawa to ŋgai tighaze tiweer, you nagheen ve naghita vibiiŋ eez tovene: Mekmek nditamoot to tiip pa mekmek paŋgaar, nene mbutmbutuuŋ ve galgaliiŋ moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ghoro aŋela to Maaron ipoi ghou ighaze: ‘Yakop!’ Ve you nayok pa aliŋa naghaze: ‘Taug nene.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Ye isaav payou muul ighaze: ‘Ŋgar naol to Laban ighamgham payom, you naghita wa. Matam ila ve ughita. Mekmek nditamoot to tiip pa mekmek paŋgaar, nowe mbutmbutuuŋ ve galgaliiŋ moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","‘Maaron to ivot payom izi ndug Betel, nene you taug tonene. Sawa to uneep tonowe, yom upayoon yaam ve uliŋ ŋgoreeŋ izala pogho, ve umbua saveeŋ ariaŋa payou. You nasaav payom: Umundig to aazne, upul ndug tonene, ve umuul ula pa ndug to tinam ipoop ghom ve matam izi pani.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yakop ipaes padi le isob, ghoro Rael yesuru Lea tisaav pani tighaze: “Tamamai, muri pale ipul mbeb toni eta inim lemai? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ye mata iŋgal ghei muul maau. Ighita ghei ninimale ndiliva sumbudi. Yom uvai ghei sorok maau. Ughol ghei wa. Ve atia tiina to ugham pani, ye tau ighan suvuni ila wa. Yei nighita rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mbaliiŋ naol to Maaron ipas di pa tamamai, nene iit toman ndinatuud mbeb toit moghon. Poia, utaghon Maaron aliŋa to ye isavia payom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tovenen Yakop imundig, ve iyou ŋgai toni toman mbeb toni naol isob to igham di izi Mesopotamia. Ghoro ighur ndizuwa toman ndinatu tizala kamel toni poghodi, ve yesŋa timundig ve tila to Yakop tama Isak to inepneep izi Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Sawa tonenen, Laban ineep paanu maau. Ye ila pa ikot sipsip toni orodi. Tovenen Rael ila iyub maaron kaarom anunudi to tama Laban ighur di pa tiŋgin ruum toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakop ipaesia mundigiiŋ todi pa Laban maau. Yes timundig inimale yoŋgaaŋ, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tovenen Yakop iyou mbeb toni tisob, ve yesŋa tamtoghon toni tisob tighau. Yes tila timbut ya tiina Euprates, ve tivool tila pa paŋa ite, ve tilaagh tiŋarua lolooz to taan suruvu to Gileat, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mboŋ ru inim ila, ve ite inim tol pani, ghoro tamtoghon pida tipaes pa Laban tighaze wagha Yakop ighau ila wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tovenen Laban imundig, ve iyou siŋ toni pida, ve yesŋa tilaan titaghon di. Titaghon di tila tila le irau mboŋ liim ve ru. Ghoro tila tigharau di izi lolooz to Gileat. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Eemoghon mboŋ tonenen, Maaron ivot to Laban to Aramea taamdi ne ila vibiiŋ, ve isaav pani ighaze: “Matam imosmoos pa aliŋam. Upiyaav saveeŋ ariaŋa eta pa upamatughezan Yakop malep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakop igharaat ina to nepooŋ izi ndug Gileat, ve yesŋa tamtoghon toni tineep tonowe. Tovenen Laban toman tamtoghon toni tila tivot todi, ve tigharaat inadi to nepooŋ izi tonowe paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban imundig ve iyaan Yakop ighaze: “Ai, yom ugham ŋgar tonene payou pasa? Yom ugham kaarom payou, ve uŋguaaz ndinatug liva tighau payou inimale yes ndaaba tighamgham pa yes ndiliva to koiadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","28","Pughu vena to ughau inimale yoŋgaaŋ payou? Inimale usaav payou, tone nigham ghanghaniiŋ toman narogho, ve nighur gham ala toman lolomai poia. Eemoghon yom upaes payou maau. Tauto nakis ndinatug liva toman nditimbug nimadi maau, ve apul ghou. Ŋgar to ugham payou, nene deŋia maau. Ugham ŋgar to borouŋa! ");
INSERT INTO tuc_o_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","You tapirig irau nawaghamun gham. Eemoghon mboŋ, Maaron to tamam isaav payou ighaze: ‘Matam imosmoos pa aliŋam. Upiyaav saveeŋ ariaŋa eta pa upamatughezan Yakop malep.’ Tauto tambaŋa, ula. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","You nawatag: Ŋgar tiom iyaryaaŋ kat ughaze umuul ula to tamam ve ndug tiom. Tauto upul ghou. Eemoghon pughu vena to uyub maaron tiou anunudi to tiŋgin ruum tiou?” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakop ipamuul Laban aliŋa ighaze: “You namatughez naghaze yom pale uŋguruut ndinatum liva payou. Tauto naghau inimale yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Eemoghon you nakankaan pa maaron tiom anunudi. Ighaze yom undeeŋ tamtoghon eta to iyub di, ye pale imaat. Tovenen taum ulaagh, ve utiir mbeb tiei to naol ne ila tamtoghon toit tonene matadi, ve ukaal di. Ighaze undeeŋ mbeb tiom eta, ghoro ughami.” Sawa to Rael iyub tama Laban maaron toni anunudi, Yakop ighita maau. Tauto ikankaan pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tovenen Laban imundig, ve ilooŋ ila Yakop mbeez toni, Lea mbeez toni, ve mbeez to yes ndiliva mbesooŋa ru, ve itiir mbeb tisob. Eemoghon indeeŋ maaron toni anunudi maau. Ghoro ilooŋ ila mbeez to Rael paam ve ikaal mbeb toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Eemoghon Rael iŋgooz maaron kaaromŋa anunudi tonowen ilooŋ ila pelpeel, ve ighuri imonau ila kamel toni dige, ve mbole izala pogho. Tovenen mburuguuŋ to tineep ila mbeez to Rael lolo, Laban itiir di tisob, le maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ghoro Rael isaav pa tama ighaze: “O tiina tiou, atem yabyab payou malep. You irau namundig maau. Pasa, moroghooŋ to ndiliva igham ghou.” Tauto Laban ikaal ikaal le maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ghoro Yakop ate yabyab kat, ve iyaan Laban ighaze: “You namalaaŋ pa sa tutuuŋ, ve nagham sa sosor, to atem yabyab ve utaghon ghou? ");
INSERT INTO tuc_o_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aazne, yom utiir mbeb tiei tisob ve undab di. Ighaze undeeŋ mbeb tiom eta, ghoro ughuri ivot ghazooŋa ila tamtoghon toit tisob tonene matadi ve tighita, leso tiŋgabiiz saveeŋ toit. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“You naneep toman ghom irau ndaman tamoot ee (20) wa. Sawa isob tonenen, sipsip ve mekmek tiom popaaŋ todi poia moghon. Ve you naghan sipsip tiom eta sorok maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ighaze mbeb sagsag ighan sipsip tiom eta le imaat, you nagham sipsip tonowen ilat ve napatooŋa payom maau. Maau kat. You narabolini pa taug sipsip tiou. Pasa, yom usaav ariaŋa payou tovene: Ighaze mbeb tiom eta ilale pa ndag, ma mboŋ, you taug irau narabolini. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ndag, ndag ighaaz katin ghou. Ve mboŋ, saut igham ghou namoŋeeŋ kat, ve nagheen pa matag rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“You naneep toman ghom ve nambesmbees payom irau ndaman tamoot ee wa. You nagham uraat irau ndaman saaŋgul ve paaŋ pa nagham ndinatum liva ru. Ve nagham uraat payom irau ndaman liim ve eez muul, leso ugham leg sipsip ve mekmek. Ve sawa naol, yom utoor aliŋam pa atia tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","“Maaron to timbug Abaram, ye Maaron to tamaŋ Isak imatughez pani ve imbesmbees pani paam. Inimale ye ivool tiou maau, tone yom ughur ghou nanim toman nimag ŋginiŋa. Eemoghon Maaron ighita pataŋani tiou ve uraat tiina to nagham payom. Tauto mboŋ ivot tiom ve iyaan ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yakop isavsaav le isob, ghoro Laban ipamuul aliŋa ighaze: “Ndiliva tonene, nene you ndinatug liva. Ve yes ndipain tonene, nene you nditimbug. Ndinatug liva to tipoop di. Ve sipsip toman mekmek tisob tonene, nene you tiou paam. Tovenen mbeb tisob to aazne yom ughita di ne, nene you tiou moghon. Eemoghon aazne, pale nagham vena padi? Tambaŋa, tinim lem wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tovenen aazne, you naghaze tambua saveeŋ ariaŋa, leso talup lolood inim ee moghon. Ve tagham ŋgar eta, leso tapariaaŋ saveeŋ mbuaaŋ toit ve mataad iŋgali.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tauto Yakop igham yaam mala eez, ve ipayoonda inim ghilalooŋ pa saveeŋ mbuaaŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ghoro isaav pa ndiran toni ighaze tila tindou yaam pida. Yes tila tindou di le isob, ghoro tilup di, ve tigham ghanghaniiŋ igharau yaam ndouŋ tonowen dige. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Yaam ndouŋ tonenen, Laban iwaat iza ila yes Aramea aliŋadi ighaze Yegar Saduta. Ve Yakop iwaat yaam tonenen iza Galet. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban isaav ighaze: “Aazne, yaam ndouŋ tonene ineep ila ituru sosood pa ipariaaŋ saveeŋ mbuaaŋ toit.” Tauto tiwaat yaam ndouŋ tonenen iza Galet. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Ve tiwaat iza ite Mizpa. Pasa, Laban isaav tovene: “Ituru irau tawaghiton ghiit muul maau. Pale taneep saguan saguan pa tauud. Eemoghon Maaron tau pale ighita ghiit irau sawa isob. Tovenen ighaze yom ureu saveeŋ mbuaaŋ toit, ve ugham sosor pa ndinatug liva, ma uvai liva ite paam, upatum ghom. Pasa, Maaron ilooŋ saveeŋ mbuaaŋ toit wa. Ve sa ŋgar to iit taghami inim ŋgozaaŋ ve tamtoghon tiwatagi maau, nene ye ighita.” ");
INSERT INTO tuc_o_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ve Laban isaav pa Yakop muul ighaze: “Ughita yaam ndouŋ ve yaam payondaaŋ to naghur di tineep ila sosood. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mbeb ru tonene, pale tipei ŋgar toit. Leso mataad iŋgal saveeŋ mbuaaŋ toit. Saveeŋ tovene: Ituru irau tamalaaŋ pa yaam ndouŋ tonene, ve you nalat nawaghamun ghom, ma yom unum uwaghamun ghou ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Maaron to Abaram ve Maaron to Naor pale tighita ghiit ve tiŋgabiiz ghiit. Ighaze toit eta igham sosor, nene pale tighur atia pani.” Laban isavsaav le isob, ve Yakop ana iwaat Maaron to tama Isak imatughez ve imbesmbees pani ne iza pa ipariaaŋ saveeŋ mbuaaŋ todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ghoro Yakop irab ŋgai eez, ve imozi izala lolooz daba inim watooŋrau pa Maaron. Ve ipoi siŋ todi tisob tinim, ve yesŋa tilup di ve tighanghan. Tighanghan le isob, ghoro tigheen tonowe pa mboŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mboŋmaagh ndoromaaŋa, ve Laban imundig, ikis ndinatu liva ve nditimbu nimadi, ve ipalot di pa saveeŋ pida, ghoro ipul di, ve imuul ila pa ndug toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban ipul di ve ila, ve Yakop paam ipamundigin laghooŋ toni muul. Ilaagh ila le aŋela pida to Maaron tivot toni izi ataam luvuŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakop ighita di, ve isaav ighaze: “Wai! Nene ndaaba to Maaron inadi to nepooŋ.” Tauto iwaat ndug tonowen iza Mahanaim. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ghoro imbaaŋ tamtoghon pida ighaze tigham avo ve timuuŋ tila to togha Esau to inepneep izi taan suruvu to Seir. Taan tonowen iza ite Edom. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ye ighur saveeŋ padi ighaze: “Yam ala avot to tiina tiou Esau, ghoro asaav pani aghaze: ‘Mbesooŋa tiom Yakop isaav tovene: Yesuru wagha Laban tikaria nepooŋ wa. Tauto aazne, ye ighaze imuul inim. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ye le makau, esele, sipsip, mekmek, ve mbesooŋa nditamoot ve ndiliva katindi. Tovenen imbaaŋ ghei ninim pa nipaes payom, leso ughami toman lolom poia.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yakop isavsaav padi le isob, ve tila tighita Esau. Tighita le isob, ghoro timuul tila to Yakop ve tipaes pani tighaze: “Yei nila nivot to togham, to nimuul ninim. Ve ulooŋ! Yesŋa tamtoghon toni 400 tilaghlaagh tinim tighaze tighita ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakop ilooŋ saveeŋ todi, le matughezaaŋ tiina ighami ve igham ŋgar naol. Tovenen ivalag tamtoghon toni toman ŋgai toni tinim rouŋ ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Pasa, mata iŋgal tovene: “Ighaze Esau inim ve ipamundigin malmal, ve irab rouŋ eez timaat, nene pale rouŋ ite irau tighau tila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ghoro Yakop isuŋ pa Maaron ighaze: “O Yoova, yom Maaron to timbug Abaram ve tamaŋ Isak. Muuŋ, taum usaav payou ughaze namuul nala pa taan tiou ve naneep toman siŋ tiou. Ve usaav payou ughaze yom pale ugham poian ghou ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Maaron, you mbesooŋa tiom. Muuŋ, sawa to nambut ya Yordan ve nala, you leg mbeb eta maau. Nakis titi moghon ve nalaagh. Eemoghon yom lolom ineep tiou, ve ugham poian ghou kat itaghon saveeŋ mbuaaŋ tiom. Tauto aazne, namuul nanim toman rouŋ tintina ru tonene. You poiag irau to ugham ŋgar tovene payou maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Maaron, you naghason ghom. Ugham mulin ghou ila toghag Esau nima. Pasa, you namatughez pani kat. Pale inim ve ipamundigin malmal payou toman ndizwag ve ndinatug, ve irab ghei nisob nimatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Maaron, matam iŋgal saveeŋ to umbua toman ghou. Yom usaav payou ughaze pale ugham poian ghou, ve ugham papaghu tiou timasa tinim naol le irau tinin di maau tinimale magargaar to te.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakop isuŋ le isob, ve ineep tonowe pa mboŋ. Mboŋmaagh ghoro, ivureer ŋgai pida tila saguan ighaze ighur di timuuŋ tila to togha Esau. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ŋgai tovene: Mekmek paŋgaar 200 ve nditamoot tamoot ee (20). Sipsip paŋgaar 200 ve nditamoot tamoot ee (20). ");
INSERT INTO tuc_o_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kamel paŋgaar tamoot ee saaŋgul (30) toman ndinatudi. Makau paŋgaar tamoot ru (40), ve nditamoot saaŋgul (10). Ve esele paŋgaar tamoot ee (20) ve nditamoot saaŋgul (10). ");
INSERT INTO tuc_o_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakop ighur ŋgai tonowen tila ketooŋ ketooŋ, ve ighur di tila mbesooŋa toni pida nimadi, ve isaav padi ighaze: “Yam amuuŋ. Eemoghon alup gham pa laghooŋ malep. Alaagh saguan saguan pa taumim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ve Yakop isaav ariaŋa pa mbesooŋa to ilaagh imuuŋ tovene: “Ighaze toghag Esau inim ivot tiom, ve ighason ghom ighaze: ‘Yom mbesooŋa to sei? Ve ula sine? Ve ŋgai ketooŋ tonanan to sei?’ ");
INSERT INTO tuc_o_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ighaze ye ighason ghom tovene, ghoro upamuul aliŋa ughaze: ‘Ŋgai tonene, to mbesooŋa tiom Yakop. Ye ighaze igham di sorok pa tiina toni Esau. Ye tau ilaghlaagh muri.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakop igham saveeŋ raraate pa mbesooŋa toni to inim ru, ve ite to inim tol, ve mbesooŋa toni tisob to matadi pa ŋgai ketooŋadi tonenen, ve tigham di tila. Ve isaav padi tovene: “Yam ala avot to toghag Esau, ghoro asavia saveeŋ raraate moghon pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ve asaav pani aghaze: ‘Olman, mbesooŋa tiom Yakop ilaghlaagh muri.’” Yakop igham tovene pasa, mata iŋgal ighaze: “You pale nagham mbeb naol tonene timuuŋ tila toni sorok. Leso nagharaat lolo, ve sawa to nala peria toni, ye pale lolo poia payou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tovenen mbeb naol to Yakop ighaze igham pa togha, ye ighur di timuuŋ tila. Eemoghon ye tau ineep izi ndug tonenen pa mboŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mboŋ ee moghon tonenen, Yakop imundig, ve igham ndizuwa ru toman ziria ru paam to mbesooŋa toni, ve ndinatu saaŋgul ve eez. Tila titaghon maghat to ya Yabok ve tivool tila pa paŋa ite. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","Ye ila ighur di tizi, ve imuul ila isaav pa mbesooŋa toni tiyou mburuguuŋ toni pida, ve titaghon di tivool tila. Ve ye eŋgeni ineep tonowe pa mboŋ. Inepneep, ve ŋgeu eez inim ve yesuru Yakop titoov tapiridi izi tonowe le ndugizau. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ŋgeu tonowen ighita ighaze tapiri irau to ilib pa Yakop maau. Tovenen irab Yakop ŋgoi le seŋgaŋa ipas. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ghoro isaav pani ighaze: “Upul ghou nala! Paam ndugizau.” Eemoghon Yakop isaav pani ighaze: “Maau. You pale nakiskis ghom tovene le irau ughur palotiiŋ iza tiou, ghoro napul ghom ula.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tovenen ŋgeu tonenen ighasoni ighaze: “Izam sei?” Yakop ipamuul aliŋa ighaze: “You izag Yakop.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ŋgeu tonenen isaav pani muul ighaze: “Pale tiwaat izam Yakop muul maau. Pale tiwaat ghom Israel. Pasa, yamru Maaron ve tamtoghon atoov tapirimim le ulib padi wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ghoro Yakop ighason ŋgeu tonenen ighaze: “Izam sei?” Ŋgeu tonenen ipamuul aliŋa ighaze: “Pughu vena to ughason ghou pa izag?” Ghoro ighur palotiiŋ iza to Yakop, ve ipuli ve ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakop imundig ve isaav ighaze: “Aazne, you naghita Maaron nagho pa matag, eemoghon namaat maau.” Tovenen iwaat ndug tonowen iza Peniel. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ndag iza peria, ve Yakop ipul ndug Peniel, ve ilaagh. Iweuweu aghe ve ila. Pasa, ŋgoi seŋgaŋa ipas. ");
INSERT INTO tuc_o_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Pughu tonene, to muuŋ ve inim aazne, yes Israela irau tighan ŋgai minda to ipaak ila tua to ŋgoi ne maau. Pasa, ŋgeu tonowen irab Yakop ŋgoi le ipas. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakop ilaagh ila, ve mata ila le ighita togha Esau inim toman tamtoghon toni 400. Tovenen Yakop ivalag ndinatu to Lea, Rael, ve ndiliva mbesooŋa toni ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ye ighur ndiliva mbesooŋa toni ru toman ndinatudi timuuŋ, ve Lea toman ndinatu titaghon di, ve Rael yesuru natu Yosep tilaagh muri. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","4","Ve Yakop tau imuuŋ padi, ve iŋarua togha Esau ila. Ilaghlaagh ve iputput aghe pani irau pa liim ve ru. Ye ighamgham tovene ve togha ilaan ŋarua inim ve isavagi ve yesuru titaŋ ");
INSERT INTO tuc_o_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","6","Ghoro Esau mata ila le ighita yes ndiliva toman ndinatudi. Tovenen ighason Yakop ighaze: “Nowe sei masin to yamŋa anim ne?” Yakop ipamuul aliŋa ighaze: “Tiina tiou, nowe you mbesooŋa tiom ndinatug. Maaron igham di payou itaghon poia toni.” Ye isavsaav, ve ndiliva mbesooŋa toni ru toman ndinatudi tinim tivot, ve tiput aghedi pa Esau. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ve Lea toman ndinatu tinim ve tiput aghedi pani. Ghoro Yosep yesuru tina Rael tilaagh muri tinim, ve yes paam tiput aghedi pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ighason Yakop muul ighaze: “Laak, yes ival to tipakeet ŋgai ve tinim peria tiou ne, pughu vena?” Yakop ipamuul aliŋa ighaze: “Tiina tiou, you nagham di payom, leso ugham ghou toman lolom poia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Eemoghon Esau isaav pani ighaze: “Wai tazig, you narau mbeb to naol ne. Mbeb tiom ineep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Eemoghon Yakop izoorndug ighaze: “Ee-e toghag, ighaze lolom poia payou, ghoro ugham mbeb tisob to nagham di payom. Pasa, yom upatooŋ ŋgar to Maaron payou, ve lolom isamin ghou ve ugham ghou toman lolom poia. Tauto naghita naghom, nene inimale naghita Maaron nagho. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tovenen ugham mbeb to nagham di payom ne. Pasa, Maaron igham poian ghou ve igham leg mbeb katindi.” Yakop izoorndug, tauto Esau lolo poia pa ŋgar toni, ve igham le mbeb tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ghoro Esau isaav ighaze: “Poia, amundig itiŋa tala.” ");
INSERT INTO tuc_o_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Eemoghon Yakop isaav pani ighaze: “Maau. Tiina tiou, yom umuuŋ. Ughita. Ndipain tonene, tapiridi irau tilaagh rikia maau. Ve sipsip ve mekmek tonene tighunghun tuz sone, ve tikaria laghooŋ wa. Tapasul di malep. Ighaze tagham di tilaagh mala pa ndag ee moghon, nene pale tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tovenen tiina tiou, yom umuuŋ, ve you toman ndipain ve ŋgai pale nitaghon ghom. Pale nilaghlaagh pooi taghon ndipain ve ŋgai tapiridi, le nilat peria tiom izi ndug Seir.” ");
INSERT INTO tuc_o_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tovenen Esau iyok pa Yakop saveeŋ toni ighaze: “Poia. Ighaze venen, you pale napul tamtoghon tiou pida tineep toman ghom. Leso tiŋgin gham ve yamŋa anim.” Eemoghon Yakop ipamuul aliŋa ighaze: “Tiina tiou, aliŋam poia. Eemoghon yom upatooŋ ŋgar popoia naol payou wa. Ugham ŋgar naol malep. Tamtoghon tiou tinepneep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tovenen ndag ee moghon tonenen, Esau imuul ila pa Seir. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Eemoghon Yakop ila Seir maau. Ilaagh ila pa ndug ite, iza Sukot. Ila ivot tonowe, ve ipayoon le ruum eez, ve igharaat dur pida pa ŋgai toni paam. Tauto tiwaat ndug tonowen iza Sukot. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sawa to Yakop ipul taan suruvu to Mesopotamia, ve imuul ila pa taan to Kanaan, ye igharaat ina to nepooŋ igharau ndug Sekem. ");
INSERT INTO tuc_o_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ve ighol taan to ye inepneep pani ne ila to siŋ to Amor. (Amor, ye Sekem tama.) ");
INSERT INTO tuc_o_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ve Yakop igharaat artaal eez izi tonowe, ve iwaat iza ighaze: ‘El Eloe Israel.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sawa eez, Yakop yesuru Lea natudi liva Dina ila ighaze ighita ndiliva papaghu pida to ndug Sekem. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Amor to daba to ndug tonowen, natu Sekem ighita Dina, ve ila isavagi ve imogheer pani. Amor, ye Hep taamdi. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem lolo pa Dina kat. Tovenen isavia saveeŋ popoia pida pani, leso irab ate, ve ighami lolo poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ve isaav pa tama Amor ighaze: “Tamaŋ, you lolog pa liva paghu tonowen kat. Ula to siŋ toni, ve yamŋa agharaat saveeŋ leso navaii.” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakop ilooŋ ŋgar mayaŋiiŋa to Sekem igham pa natu liva, eemoghon isavia saveeŋ eta rikia maau. Pasa, ndinatu nditamoot tila ndug ite ve tigham uraat pa ŋginiiŋ ŋgai toni tonowe. Tovenen itatan tau ve inaam di. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ye inamnaam di ve inepneep, ve Sekem tama Amor ila ivot toni ighaze yesuru tigharaat saveeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakop ndinatu tilooŋ ŋgar samia to Sekem igham pa livudi, ve timuul tinim tivot paanu. Lolodi poia maau. Atedi yabyab kat. Pasa, lolodi pa ŋgar tovene ivot padi malep. Tighita tighaze Sekem igham mayaŋiiŋa tiina pa yes Israela. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amor isaav padi ighaze: “Alooŋ. Natug Sekem, ye lolo pa natum liva kat ve itaŋ pani ighaze ivaii. Vena, irau ayok pani ve ivai natug? ");
INSERT INTO tuc_o_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","You naghita naghaze nene poia pa papaghu toit tiwavain di. Yei pale nivai ndinatumim ndiliva, ve yam avai ndinatumai ndiliva. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Aghita. Taan tiina inepneep. Yam taumim aghita lemim taan pida pa aneep pani. Leso itiŋa talup ghiit, ve taparabol pa mbeb toit ila inim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ghoro Sekem imundig ve isaav pa Dina tama Yakop toman ndilivu tovene: “Ighaze lolomim toman ŋgar tiam inim tiou, sa mbeb to lolomim pani, you pale nagham payam. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tovenen asavia liva atia payou. Izi, ma iza, you pale nagham payam. Eemoghon ayok pa naghami inim azuwag.” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Eemoghon Yakop ndinatu atedi yabyab kat pa Sekem pa ŋgar mayaŋiiŋa to igham pa livudi Dina. Tovenen tigham kaarom pa Sekem yesuru tama Amor tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Vana maau. Tamoot to ighaze tiziri maau, nene irau niyok pa ivai livumai maau. Pa vene, igham mayaŋiiŋa payei. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ataam ee moghon to inepneep. Yam irau ataghon gabuamai, ve azir nditamoot tiam, le iit tasob rarateed, ghoro niyok pa saveeŋ tiam, ");
INSERT INTO tuc_o_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ve niyok pa itiŋa tawavain ghiit, ve nineep izi ndug tonene, ve talup ghiit tanim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ve ighaze yam ayok pa zirooŋ gham maau, nene pale nilat nigham livumai, ve nighau nila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Amor yesuru natu Sekem tilooŋ saveeŋ todi, ve tiyok pani tighaze nene ŋgar poia. Tovenen rikia moghon, ve Sekem ipamundigin mbeb tonenen saveeŋa. Pasa, ye lolo pa Yakop natu liva kat. Sekem, siŋ to tama tisob titandag pani ve tiloŋlooŋ aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tovenen Amor yesuru natu Sekem tila pa ndug to lupuuŋ to igharau ataam avo ve tisaav pa yes nditamoot tisob to ndug Sekem tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ndiran tonowen, ndiran luuma, ve tighaze itiŋa talup ghiit tanim ee moghon. Iit taan toit tiina. Irau tapul pida padi. Leso tilaghlaagh pani, ve tiraukol pa mbeb todi, ve itiŋa irau tawavain ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Eemoghon yes tiyoon ariaŋa pa mbeb ee moghon tonene. Tighaze tazir ghiit tasob le rarateed tanimale yes, ghoro tiyok pa tineep toman ghiit, ve itiŋa talup ghiit tanim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ighaze tataghon ŋgar todi, nene pale inim ataam pait ve tagham ŋgai todi to ghaniiŋ ve to uraat, toman mburuguuŋ todi tisob tinim leed. Yo, yam taumim asaav. Vena, tayok pa ŋgar todi, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yes to paanu tilooŋ saveeŋ to Sekem yesuru tama Amor, ve tiyok. Tovenen tizir nditamoot todi tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Uraat to zirooŋ di isob, ve mboŋ inim tol ve nditamoot to ndug Sekem tinepneep toman yabyabuuŋ tiina sone. Ghoro Yakop ndinatu ru, Simeon ve Levi to Dina ndilivu, timundig toman buza todi, ve tilooŋ tila ndug Sekem. Yes to paanu tikankaan pa ŋgar to yesuru tighaze tighami. Yesuru tila, ve timbut nditamoot tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Amor ve natu Sekem paam, timbut yesuru pa buza ve timaat. Ghoro tigham livudi Dina, ve tipul ruum to Sekem, ve tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","29","Ghoro Yakop ndinatu pida anadi timundig ve tilaan muri tilooŋ tila ndug Sekem, ve tiyou mbeb to yes to tirab di timaat ne, inim yatuuŋ ŋgar samia to tigham pa livudi Dina. Tigham makau, esele, ve sipsip todi, toman mbaliiŋ ve mbeb todi pida to tineep ruum lolo. Mbeb todi to ineep paanu, ve mbeb to uum paam, eta ineep muul maau. Tiyou di le tisob. Ve tiyou ndiliva todi toman ndinatudi paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yes tigham ŋgar tonenen, le Yakop ate yabyab ve iyaan Simeon yesuru Levi ighaze: “Yamru awaghamun izag wa. Yes Kanaana ve Peresa to tinepneep izi taan tonene, pale tighita ghou tighaze you ŋgeu samiag kat, ve tighur koi payou. Ighaze tilup di ve tigham malmal pait, nene pale tirab ghiit tasob tamatmaat. Pasa, iit ival maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Eemoghon yesuru tipamuul aliŋa tighaze: “Pale nipul ŋgeu tonowen igham tovene pa livumai inimale ye liva to ataam?” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Muri ghoro Maaron isaav pa Yakop ighaze: “Umundig uzala pa ndug Betel, ve uneep tonowe. Ve ugharaat artaal payou. You Maaron to navot tiom indeeŋ sawa to yom ughau pa togham Esau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tovenen Yakop isaav pa ndiran toni toman tamtoghon pida to yesŋa tinepneep ighaze: “Yam asuruuv maaron tiam anunudi tisob tilaledi, ve agharaat taumim leso aŋgalaaŋ ila Maaron mata, ve ayol gham pa nonogiiŋa popoia. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ghoro tamundig ve tazala pa ndug Betel. You naghaze nagharaat artaal pa Maaron izi tonowe. Pasa, sawa to pataŋani igham ghou, ye ilooŋ suŋuuŋ tiou ve igham mulin ghou. Ve ndug sine to nala naneep pani, ye ineep toman ghou ve mata payou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tovenen tiyou maaron kaaromŋa todi anunudi ve tigham di tinim, ve tipas pandood tizi pa taliŋadi, ve tighur di tila to Yakop. Ghoro ye itavia di ila ai tiina eez pughu. Ai tonowen iyoon igharau ndug Sekem. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ghoro timundig ve tila. Tamtoghon tisob to tineep tigharau ndug Sekem, Maaron igham matughezaaŋ tiina ivot padi. Tovenen todi eta itaghon di pa malmal maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakop toman tamtoghon toni tisob tilaagh tila le tivot ndug Lus. Lus ineep ila taan suruvu to Kanaan. Iza ite Betel. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ghoro Yakop igharaat artaal eez, ve iwaat ndug tonowen iza El Betel. Pasa, sawa to ye ighau pa togha Esau, Maaron ivot toni tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tinepneep tonowe, ve Debora, liva mbesooŋa to Yakop tina Rebeka, imaat. Sawa to Rebeka paini ve inim, Debora iŋgini. Yes titavia izi ai tiina eez pughu to iyoon igharau ndug tonowen. Tovenen tiwaat ai tonowen iza tighaze “Ai to taŋiiz.” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Sawa to Yakop ipul Mesopotamia, ve imuul ila ivot taan to Kanaan, Maaron ivot toni, ve ighur poia iza toni ighaze: “Yom izam Yakop. Eemoghon aazne ve ila, irau tiwaat ghom Yakop muul maau. Pale tiwaat ghom Israel.” Tovenen iwaat Yakop iza paghu Israel. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ve Maaron iseeŋ saveeŋ toni ighaze: “You Maaron Ariaŋag To Nalib Pa Ndimaronŋa Tisob. Papaghu tiom pale timasa tinim naol, ve tinim ndug ndug pughudi. Ve kinik pida pale tivot ila to papaghu tiom. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Taan tonene, muuŋ nambua saveeŋ toman Abaram ve Isak naghaze pale nagham padi. Ve aazne, nagham taan tonene payom ve papaghu tiom to muri pale tivot.” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Maaron isavsaav toman Yakop le isob, ghoro ipuli, ve imuul iza ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakop ipayoon yaam mala eez izi ndug to Maaron isavsaav pani, leso inim ghilalooŋ pa ndug tonowen. Ve iliŋ vaen izala yaam tonowen pogho inim watooŋrau, ve iliŋ ŋgoreeŋ izala pogho paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ve iwaat ndug tonowen iza Betel. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ghoro Yakop toman tamtoghon toni tipul Betel. Tilaagh tila tigharau ndug Eprata sone, ve Rael pain ighami ighaze ipoop. Popaaŋ toni ipataŋan kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Sawa to yabyabuuŋ tiina kat ighami, liva to ipapopani isaav pani ighaze: “Umatughez malep! Nene ugham pain tamoot ite.” ");
INSERT INTO tuc_o_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rael igharau ighaze imaat, ghoro iyavan, ve iwaat natu tonowen iza Benoni. Eemoghon Yakop itoor iza muul ighaze Benyamin. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tovenen Rael imaat, ve titavia izi ataam to ila pa ndug Eprata ne dige. (Eprata, iza ite Betelem.) ");
INSERT INTO tuc_o_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ghoro Yakop ipayoon yaam eez inim ghilalooŋ pa naal to Rael. Yaam tonowen iyondyood sone. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel imundig muul, ve ilaagh ila ivot izi ndug eez. Ndug tonowen, ruum daba mala eez iyondyood, iza Eder. Yakop ipul ruum tonowen ve ila ris, ghoro igharaat ina to nepooŋ tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tinepneep tonowe, ve Ruben ila to Bila to tama ziria ite ne, ve yesuru tigheen. Ŋgar to ighami, tama Israel ilooŋ varu paam. Yakop ndinatu nditamoot saaŋgul ve ru tivot tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ipoop Ruben, ye Yakop natu aidaba, ghoro Simeon, Levi, Yuda, Isakar, ve Zebulun. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rael ipoop Yosep yesuru Benyamin. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bila to liva mbesooŋa to Rael, ye ipoop Dan yesuru Naptali. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ve Silpa to liva mbesooŋa to Lea, ye ipoop Gat yesuru Aser. Sawa to Yakop inepneep izi Mesopotamia, tipoop ndinatu tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakop imundig muul, ve ila ivot to tama Isak izi ndug Mamre to igharau ndug Kiriat Arba. (Kiriat Arba iza ite Ebron. Ndug tonowen, to muuŋ Abaram yesuru Isak tineep tinim loom pani.) ");
INSERT INTO tuc_o_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak inepneep le inim olman waat, ghoro imaat ve ila igheen toman siŋ toni pida to timaat muuŋ wa. Ndaman toni irau (180), ghoro imaat ve ndinatu ru, Esau ve Yakop, titavia. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nene pitiiŋ to Esau toman papaghu toni. (Esau iza ite Edom.) ");
INSERT INTO tuc_o_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ivai Kanaan tidi ru: Ada ve Oholibama. Ada, ye Elon natu liva. Ve Elon, ye Hit taamdi. Oholibama tama Ana, ve timbu Zibeon. Zibeon, ye Ep taamdi. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau ivai Basemat paam. Basemat, ye Ismael natu liva, ve Nebaiot livu. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada yesuru Esau tipoop Elipas, ve Basemat yesuru Esau tipoop Reuel. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama ipoop Yeus, Yalam, ve Kora. Esau ndinatu tonowen, tipoop di izi taan Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Muri ghoro, Esau imundig igham ndizuwa, ndinatu, ve tamtoghon toni tisob to tinepneep tomani, ve ŋgai ve mburuguuŋ toni tisob to ye igham di izi Kanaan ne, ve ila ineep saguan pa tazi Yakop. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Pasa, Yakop yesuru Esau ŋgai todi katindi, ve taan irau di maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tovenen Esau ila ineep izi lolooz to taan suruvu to Seir. (Esau iza ite Edom.) ");
INSERT INTO tuc_o_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nene pitiiŋ to Esau papaghu toni. Esau inim pughu to yes Edoma to tineep izi lolooz to taan suruvu to Seir. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau ndinatu tivot tovene: Yesuru azuwa Ada tipoop Elipas, ve yesuru azuwa Basemat tipoop Reuel. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Esau natu Elipas ndinatu, nene: Teman, Omar, Sepo, Gatam, ve Kenas. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipas ivai liva ite, iza Timna. Eemoghon, ye azuwa kat maau. Ye ipoop Amalek. Nene Esau papaghu toni to tivot ila to azuwa Ada. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel ndinatu, nene: Naat, Sera, Samma, ve Miza. Nene Esau papaghu toni to tivot ila to azuwa Basemat. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau azuwa ite Oholibama. Ye Ana natu liva, ve Zibeon timbu liva. Yesuru Esau tipoop ndinatudi tol: Yeus, Yalam, ve Kora. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau papaghu toni tonowen tila tineep izi ndug todi eŋaeŋa, ve tinim ndimaronŋa pa rumai todi todi. Esau natu aidaba Elipas ndinatu, nene: Teman, Oman, Sepo, Kenas, Kora, Gatam, ve Amalek. Elipas papaghu toni tonowen tineep izi taan suruvu to Edom, ve tinim ndimaronŋa pa rumai todi todi. Nenen Esau papaghu toni to tivot ila to azuwa Ada. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau natu Reuel ndinatu, nene: Naat, Zera, ve Samma. Yes paam tila tineep ledi ledi izi taan suruvu to Edom, ve tinim ndimaronŋa pa rumai todi todi. Nenen Esau papaghu toni to tivot ila to azuwa Basemat. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau azuwa Oholibama ipoop Yeus, Yalam, ve Kora. Yes paam tinim ndimaronŋa pa rumai todi todi. Oholibama, ye Ana natu liva. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tamtoghon tisob tonene, nene Esau papaghu toni. Yes tisob tinim ndimaronŋa pa rumai todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ŋgeu eez ineep izi taan suruvu to Edom paam, iza Seir. Ye Or taamdi. Seir ndinatu, nene: Lotan, Sobal, Zibeon, Ana, Dison, ve Ezer. Yes tila tineep ledi ledi izi taan suruvu to Edom, ve tinim ndimaronŋa pa yes Ora. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ndinatu nditamoot, nene Ori ve Omam. Ve Lotan livu iza Timna. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ndinatu, nene: Alban, Manaat, Ebal, Sepo, ve Onam. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon ndinatu, nene: Aya ve Ana. Ana tonene, to iŋginŋgin esele to tama izi ndug balim, ve indeeŋ ya tuntunu eez tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ipoop ndinatu ru. Tamoot iza Dison, ve liva iza Oholibama. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison ndinatu, nene: Emdan, Esban, Itran, ve Keran. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer ndinatu, nene: Bilan, Zaaban, ve Akan. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ve Disan ndinatu, nene: Uz ve Aran. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Tovenen Or papaghu toni to tivot ve tinim ndimaronŋa pa rumai todi todi, nene Lotan, Sobal, Zibeon, Ana, Dison, Ezer, ve Disan. Yes tonenen, to tiŋgin yes Ora, ve tineep ledi ledi izi taan suruvu to Seir. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Muuŋ, sawa to yes Israela ledi kinik eta sone, yes kinik tonene tiŋgin taan suruvu to Edom. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor natu Bela, ye kinik to iŋgin taan suruvu to Edom muuŋ. Ndug toni iza Dinaaba. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela imaat, ve Zera natu Yobab igham ina. Yobab ndug toni Bosra. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab imaat, ve Usam igham ina. Usam inim pa taan suruvu to yes Temana. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Usam imaat, ve Bedat natu Aad igham ina. Aad ndug toni Abit. Yesŋa yes Midiana tiparab izi taan suruvu to Moap, le ye ilib padi. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Aad imaat, ve Samla igham ina. Samla ndug toni Masereka. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla imaat, ve Saul igham ina. Saul ndug toni Reobot. Ndug tonowen igharau ya tiina Euprates. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul imaat, ve Akbor natu Bal-Anan igham ina. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal-Anan imaat, ghoro Aad igham ina. Aad ndug toni Pau, ve azuwa iza Meetabel. Meetabel tina iza Matret, ve timbu liva iza Me-Zaab. ");
INSERT INTO tuc_o_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Tovenen Esau papaghu toni to tila tineep izi ndug todi todi, ve tinim ndimaronŋa pa rumai todi todi, nene Timna, Alba, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibzar, Magdiel, ve Iram. Yes tonenen, to tinim ndimaronŋa pa yes Edoma, ve tiŋgin taan todi todi. Esau papaghu toni tonenen, to tivot ve tinim pughu to yes Edoma. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakop igharaat ina to nepooŋ izi taan to Kanaan to muuŋ tama Isak ineep inim loom pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nene kamos to Yakop toman ndinatu. Sawa to Yakop natu Yosep ndaman toni irau saaŋgul liim ve ru (17), yesŋa nditogha pida to Yakop ziria ru Bila ve Silpa ndinatudi tila tiŋgin ŋgai todi. Sawa pida, ighaze nditogha tigham mbeb eta isosor, ghoro Yosep ila ipaes pa tamandi. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakop lolo pa Yosep ilib pa ndinatu to naol ne. Pasa, ye inim olman, ghoro azuwa Rael ipoopa. Tovenen Yakop igharaat Yosep le nonogiiŋa mala eez to bodeeŋa popoia kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yosep nditogha tighita tamandi lolo pa Yosep ilib padi, le ireu lolodi, ve tisavia saveeŋ poia eta pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Mboŋ eez, Yosep igheen le ivib. Ghoro ipaesia vibiiŋ toni pa nditogha ighaze: “Ou, alooŋ vibiiŋ tiou. You navib tovene: Iit tanepneep ila uum, ve tagham uraat pa posaaŋ aniiŋ. Mala maau ve aniiŋ poos tiou imundig iza iyoon deŋia, ve aniiŋ poos tiam tisob tinim tiyoon tiluvut tiou, ve tiput aghedi pani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yosep nditogha tilooŋ saveeŋ tonene, ve tisaav pani tighaze: “Wai! Yom upakur ghom pasa! Yom ughaze unum tiina payei ve uŋgin ghei?” Tovenen saveeŋ to ye isavia pa vibiiŋ toni, igham di atedi yabyab kat pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Muri ghoro, ye ivib muul. Ve ipaesia vibiiŋ toni tonenen paam pa nditogha ighaze: “Ou, alooŋ vibiiŋ tiou ite. You navib tovene: Anunug nayondyood, ve ndag, kaiyo, ve pitum saaŋgul ve eez tinim tiput aghedi payou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yosep tama ve nditogha tilooŋ vibiiŋ toni tonene, ve tama iyaana ighaze: “Wai! Sa vibiiŋ tovene? Yom ughaze yeru tinam, toman nditogham, ve tazim kainaŋen pale nisob ninim niput aghemai payom?” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tovenen Yosep nditogha atedi yabyab pani kat ve tighur koi pani. Eemoghon tama Yakop mata kisin Yosep saveeŋ toni, ve ighamgham ŋgar pa pughu. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tinepneep le sawa eez, Yosep nditogha tila ndug Sekem dige, leso matadi pa ŋgai to tamandi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tovenen olman Israel isaav pa Yosep ighaze: “Ulooŋ. Nditogham tiŋginŋgin ŋgai toit to ndug Sekem dige we. You naghaze nambaaŋ ghom ula uŋgig di.” Yosep ipamuul aliŋa ighaze: “Poia. Pale nala.” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tovenen tama Israel isaav pani muul ighaze: “Ula ughita nditogham ve ŋgai toit. Nepooŋ todi vena? Tineep pooi, ma maau? Ghoro, umuul unum upaes payou.” Sawa tonenen, olman Israel toman ndinatu tinepneep izi taan raapa to Ebron. Tovenen Yosep ilaagh ila ivot ndug Sekem, ve ikaal nditogha. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ye ilaghlaagh ila le ŋgeu eez ivot toni ve ighasoni ighaze: “Ukaal sei?” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosep ipamuul aliŋa ighaze: “You nakaal nditoghag toman ŋgai tiei. Ighaze yom ughita di tineep pa dige eta, ghoro usaav payou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ŋgeu tonowen isaav pani ighaze: “Wais, unum rikia, tone ughita di. Maau ve tipul ndug tonene, ve tisakia di tila wa. Eemoghon nalooŋ tighaze tila pa ndug Dotan.” Tovenen Yosep itaghon nditogha ila, le indeeŋ di izi ndug Dotan. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ilaghlaagh mala sone, ve nditogha matadi ila le tighita. Tovenen tiwasavon di pa tirabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tighaze: “Aghita! Ŋgeu to ighita vibiiŋ naol, tauto inim we! ");
INSERT INTO tuc_o_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tala tarabi imaat, ve tapiyaava izila saambu to ya taiŋ eta. Ighaze tighason ghiit pani, ghoro taghaze: ‘Yei nikankaan pani. Ŋgai sagsag eta avaat ighani wa.’ Ghoro taneep ve taghita: Vibiiŋ toni pale anoŋa ivot vena?” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Eemoghon Ruben ilooŋ saveeŋ todi, ve ighaze ipaghau Yosep padi. Tovenen isaav padi ighaze: “Maau. Tarabi imaat malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Taumim agham siŋ pani, nene poia maau. Nes, nene ndug balim. Tapiyaava izila ya taiŋ saambu tonene. Tarabi imaat malep.” Ruben isavia saveeŋ tonene, pasa ighaze ipaghau Yosep pa nditogha. Leso muri, ighuri imuul ila to tamandi. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosep ila peria todi, ghoro timundig, tisavagi, ve tiduduum nonogiiŋa toni to moŋeŋaaŋ to bodeeŋa popoia izi. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ghoro tighami tila, ve tipiyaava izila ya taiŋ saambu to Ruben isavia. Saambu tonowen, lolo ŋginiŋa. Ya ipot ila maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ruben ipul di, ve ila ilaghlaagh mala ris, ve yes pida mboledi izi tighaze tighan adi aniiŋ. Mala maau, ve matadi ila le tighita Ismaela pida tinim. Ndiran tonowen tinim pa taan suruvu to Gileat, ve tighaze tizila Isip pa tiraukol. Kamel todi tighuuz mbeb naol to vuzidi popoia ve atiadi tintina. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda ighita ndiran tonenen, ve isaav pa nditogha ve nditazi ighaze: “Aghita. Ighaze iit tarab taziid tonene imaat ve taŋgooza, pale iuul ghiit vena? ");
INSERT INTO tuc_o_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tagholia ila to yes Ismaela tonowen. Irau tauud tagham siŋ pani maau. Pasa, ye taziid, ve iit siŋ ee moghon.” Yes tilooŋ saveeŋ toni tonene, ve tisob tiyok pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tovenen yes ndiran to Midian to tilaagh pa raukoliiŋ, tila tivot todi, ghoro Yosep nditogha tiyoui iza pa saambu tonowen, ve tigholia ila to yes Midiana pa yaam silva irau tamoot ee. Ghoro yes Midiana tighami, ve yesŋa tizila pa Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","30","Mala maau, ve Ruben imuul inim peria ya taiŋ tonenen. Ye ighita tazi Yosep nagho maau, le lolo ipataŋan kat. Tovenen ireep nonogiiŋa toni, ve ila isaav pa nditazi ighaze: “Wai, pain ilale wa! Pale nagham vena?” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ghoro timundig ve tirab mekmek natu eez ve tipaal apo, ve tizeev nonogiiŋa to Yosep ilooŋ ila ve tipeli pa mekmek siŋi. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Le isob, ghoro timundig ve timuul tila to tamandi, ve tisaav pani tighaze: “Tamamai, yei nindeeŋ nonogiiŋa tonene. Ughilaala. To natum Yosep, ma to ŋgeu ite paam?” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tamandi ighilaal nonogiiŋa tonowen, ve isaav ighaze: “Wai, nene natug ghora nonogiiŋa toni. Onoon kat, ŋgai sagsag eta avaat ireep motini ve ighani wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakop lolo ipataŋan kat pa natu Yosep. Tovenen ireep nonogiiŋa toni, ve imoŋ ve itaŋtaŋ pani irau sawa mala. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ndinatu ve ndinatu liva tisob tila toni, ve titoova pa tirab ate. Eemoghon ye ilooŋ di maau. Itaŋtaŋ, ve isavsaav ighaze: “You pale nataŋtaŋ pa natug tovene le namaat ve nataghoni nazila ndug to mateeŋa paam.” Tovenen Yakop lolo imaagh pa natu maau. Inoknok taŋiiz pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yes Midiana tila tivot Isip, ghoro anadi tigholia Yosep ila inim mbesooŋa sorok to ŋgeu eez, iza Potipar. Potipar, ye uraata eez to kinik to Isip, ve ye daba to yes ndaaba to tiŋgin kinik ruum toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sawa tonenen, Yakop natu Yuda ipul toŋvetaz toni, ve ila ineep toman ŋgeu eez to ndug Adulam, iza Ira. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Inepneep tonowe, ve ighita liva eez ve lolo pani. Tovenen ivaii. Liva tonowen, tama iza Suwa. Ye to Israel maau. Ye to Kanaan. Yuda yesuru azuwa tigheen ve liva apo, ve ipoop natu tamoot ee. Yuda iwaat iza Er. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Muri ghoro, liva apo muul, ve ipoop natu tamoot ite, ve iwaat iza Onan. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yesuru tinepneep izi ndug Kezib, ve azuwa ipoop natu tamoot ite inim tol, ve iwaat iza Sela. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Tinepneep le sawa to Yuda natu aidaba Er ighaze ivai, ghoro tama igham Kanaan tidi eez pani, iza Tamar. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eemoghon Yoova ighita Er ighaze ye ŋgeu samia. Tovenen irabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ghoro Yuda isaav pa natu Onan ighaze: “Yom irau utaghon tutuuŋ toit, ve uvai naar to togham. Leso yamru apoop togham to imaat ne le paghu eta, ve iza iyondyood.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Eemoghon Onan iwatag: Ighaze tipoop, natu tonenen irau igham ye ina maau. Pale igham togha ina. Tovenen sawa isob to yesuru liva tonenen tigheen, ye ipul ya toni imaliŋ izila taan. Leso igham paghu eta pa togha sob. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yoova ighita ighaze Onan ŋgar toni tonenen poia maau. Tovenen irab Onan imaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tauto Yuda isaav pa rawa liva Tamar ighaze: “Ughita. Azuwam imaat, ve yom unum naar. Umuul ula uneep to tamam, ve usaŋan natug Sela le inim olman irau vaiuuŋ, ghoro uvaii.” Ye isaav tovene pasa, imatughez pa natu Sela pale imaat paam inimale nditogha ru. Tovenen ighur rawa liva Tamar imuul ila ineep toman tama. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tinepneep le sawa mala ris, ghoro Yuda azuwa to Suwa natu liva, ana imaat. Yuda inepneep le sawa toni to moŋiiŋ isob, ghoro yesuru ita ite Ira to ndug Adulam tila pa ndug Timna tighaze tighita yes uraata toni to tikotkot sipsip toni orodi. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","14","Sawa tonenen, Yuda natu Sela irau vaiuuŋ wa. Eemoghon Tamar ighita ighaze Yuda irau iyok pani pa ivai natu Sela maau. Ye ilooŋ tighaze rawa Yuda ila ndug Timna pa ighita yes uraata to tikotkot sipsip toni orodi. Tovenen iduduum nonogiiŋa toni to moŋiiŋ izi, indudi pa nonogiiŋa toni ite, ve igham uli pida eez ve ipoon nagho pani. Ghoro ila mbole izi ataam avo to ndug Enaim igharau ataam tiina to ila pa ndug Timna, ve isaŋan rawa. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Mala maau ve rawa Yuda ila peria. Ye ighita rawa liva mbole izi ataam dige, eemoghon ighilaala maau. Ighaze pa ye liva eta to ataam. Pasa, Tamar ipoon nagho. Tovenen Yuda ila toni, ve imbuura ighaze: “Ai, irau ituru tala tagheen?” Tamar ipamuul aliŋa ighaze: “Poia. Eemoghon pale ugham leg sa inim atia tiou?” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda isaav pani ighaze: “Muri pale nasaŋgoor mekmek natu eta ilat tiom.” Tamar iyok pa aliŋa ighaze: “Poia. Eemoghon yom irau ugham leg mbeb tiom eta to aazne inim ghilalooŋ pa saveeŋ mbuaaŋ tiom, ve nakisi le sawa to ighaze usaŋgoor mekmek inim, ghoro napamuul mbeb tiom ilat.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda ighasoni ighaze: “Wai, ighaze venen, pale nagham lem sa?” Tamar ipamuul aliŋa ighaze: “Ugham leg mbeb to mosim ineep ila, toman waara to umbiti ila luam, ve titi tiom to ukiskisi.” Tovenen Yuda igham mbeb tol tonowen pani, ve yesuru tila ve imogheer pani. Tauto Tamar apo ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ghoro Tamar imundig ila, ve iduduum uli to ipoon nagho pani ne izi, indudi pa nonogiiŋa toni to moŋiiŋ muul, ve imuul ila pa paanu. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Muri ghoro, Yuda ighur mekmek natu eez ila to ita ite, ve imbaaŋa ila to liva tonowen. Leso igham mekmek tonenen pani, ve igham mulin mbeb toni to ipuli pani inim ghilalooŋ pa saveeŋ mbuaaŋ toni. Eemoghon ye ila ikaala le maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tovenen ighason ndug tau pida ighaze: “Ou, liva to ataam to muuŋ inepneep izi ataam dige tonene, ila vena?” Yes tipamuul aliŋa tighaze: “Ee-e, liva eta tovene ineep sualen maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tovenen ipamuula ila, ve ipaes pa Yuda ighaze: “Nala nakaal liva tonowen le maau. Ve naghason ndug tau pida, ve yes tighaze liva to ataam eta ineep nowe maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tovenen Yuda isaav pani ighaze: “Tambaŋa paam. Ineeple. Tanoknok ghasoniiŋ, pale tamtoghon tiŋiŋ pait. Mbeb tiou to liva tonowen igham di, tineep tinim le. Pasa, you natoova pa nasaŋgoor le mekmek natu, eemoghon yom undeeŋa maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaiyo tol inim ila, ghoro Tamar varu ivot, ve tipaes pa Yuda tighaze: “Rawam liva ilaghlaagh sorok le apo.” Yuda ilooŋ saveeŋ tonene, ve imundig ve isaav ariaŋa ighaze: “Ala aghami ivot ila pumuri, atavun yab, ve apiyaava izala yab ighani!” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Eemoghon sawa to tigham Tamar tivot tila, ye igham mbeb tol to rawa ipul di tizi toni, ve isaŋgoor di timuul tila toni toman aliŋa tovene: “You apog sorok maau. You apog ila to ŋgeu to mosi toman waara ve titi toni tonene. Taum ughita. To sei?” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ighita ve ighilaal mbeb toni. Tovenen isaav ighaze: “Onoon kat. Nene sosor to liva tonowen maau. Nene you to nanim pughu pani. Pasa, inimale nagham natug Sela pani ve ivaii, tone pataŋani tonene irau ivot maau.” Tovenen tigham mbeb eta pa Tamar maau. Ve muri, Yuda ila toni muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sawa to Tamar ighaze ipoop, tighilaal tighaze booga ru tineep ila apo. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ye ipoop booga tonenen, ve eez nima ivot peria. Tovenen liva to ipapopan Tamar, imbit waar kaviaaŋa ila nima, ve ighaze: “Nene ŋgeu aidaba tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Eemoghon pain tonowen nima goroŋia imuul ila, ve mala maau ita ite imuuŋ izi. Tovenen liva to ipapopan Tamar isaav ighaze: “Wai, yom usipiir itam ite ighau, ve uzoorndug gha uvot unum!” Tauto tiwaat iza Peres. ");
INSERT INTO tuc_o_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ghoro ita ite to timbit waar kaviaaŋa ila nima, ana izi. Ve tiwaat iza Zera. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yes Ismaela tigham Yosep ve tila tivot izi Isip, ghoro tigholia inim mbesooŋa sorok ila to Potipar. Potipar, ye uraata eez to kinik to Isip. Ye daba to yes ndaaba to tiŋgin kinik ruum toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","4","Yoova inepneep toman Yosep, ve ighurghur poia toni izaza toni. Tovenen uraat toni to ye ighamghami izi ruum to Potipar, ilaan poia moghon. Potipar ighita tovene: Maaron ineep toman Yosep, ve iuluuli le uraat toni isob ilaan poia. Tovenen Potipar lolo pani, ve ighuri inim ŋginiiŋ pa ruum toni, toman mbeb toni tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sawa tonenen ve ila, Maaron ighur poia toni iza to Potipar, toman ruum, ŋgai, uum, ve mbeb toni tisob. Pasa, Yosep ndamo pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tovenen Potipar ipul mbeb toni tisob tila Yosep nima pa iŋgin di, ve mata ila padi muul maau. Aniiŋ to ye tau ighani, mbeb tonene moghon to Potipar iŋgini. Yosep, ye ŋgeu nabiu taamdi. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sawa eez, Potipar azuwa ighan mata pani, ighaze itoova. Tovenen imbuura ighaze yesuru tigheen. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Eemoghon Yosep ilooŋa maau, ve ipamuul aliŋa ighaze: “Ee-e, vana maau. Pasa tiina tiou Potipar, ye inumeer ghou kat. Tauto ipul mbeb toni to tineep ila ruum toni lolo ne tisob tinim nimag, ve mata ila padi muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","You nanim daba pa ruum tonene inimale ye tau. Ve yom moghon, to ye iŋgalsekin ghou payom. Mbeb ite paam maau. Pasa, ye azuwa yom. Ighaze nataghon aliŋam ve nagham ŋgar samia tonene, pale poia? Maau. Nene pale nagham sosor tiina ila Maaron mata.” ");
INSERT INTO tuc_o_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Sawa naol, Potipar azuwa inoknok mburaaŋ Yosep ighaze yesuru tigheen. Eemoghon Yosep ilooŋa maau. Ve ila igharaui paam maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tinepneep le sawa eez, Yosep ilooŋ ila ruum lolo ighaze igham uraat toni. Ve sawa tonenen, mbesooŋa ite paam ineep maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tovenen Potipar azuwa ilaagh iŋarua ila, itak nonogiiŋa toni, ve isaav pani ighaze: “Aa, unum ituru tagheen lak!” Eemoghon Yosep ipul nonogiiŋa toni tonowen izi, ve ighau ivot ila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potipar azuwa ighita Yosep ipul nonogiiŋa toni ineep ila nima, ve ighau ivot ila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","Tovenen imboob pa mbesooŋa pida tinim, ve isaav padi ighaze: “Ai, aghita mbeb tonene! Azuwag igham Hibru taamdi tonowen inim ineep toman ghiit, ve aazne ye igham mayaŋiiŋa tiina kat pait. Pasa, ye inim ighaze imogheer payou. Eemoghon you namboob aliŋag tiina, tauto imatughez, ve ipul nonogiiŋa toni tonene izi, ve ighau ivot ila pumuri.” ");
INSERT INTO tuc_o_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ghoro ikis nonogiiŋa to Yosep, ve isaŋan azuwa Potipar inim. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Potipar inim ivot, ghoro azuwa ipaes pani ighaze: “Ai, Hibru taamdi to yom ughami inim ineep toman ghiit, ye igham mayaŋiiŋa tiina kat pait. Pasa, ye inim ighaze imogheer payou. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Eemoghon you namboob aliŋag tiina, tauto imatughez, ve ipul nonogiiŋa toni tonene izi, ve ighau ivot ila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nene ŋgar to mbesooŋa tiom tonowen igham payou.” Potipar ilooŋ saveeŋ toni, le ate yabyab kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tovenen ikis Yosep, ve ighuri ilooŋ ila ruum to yabyabuuŋ. Ruum tonowen, yes to tizorzoor kinik aliŋa, ghoro tizeev di tilooŋ tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yosep inepneep ila ruum to yabyabuuŋ lolo. Eemoghon Yoova ipuli maau. Inepneep tomani, ve iuluuli. Tauto daba to iŋgin ruum to yabyabuuŋ ne lolo poia pa Yosep. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ve ighuri pa iŋgin ndita pida to yesŋa tineep ila ruum to yabyabuuŋ lolo. Sa uraat to ighaze ivot, nene Yosep igham pooz pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Daba to iŋginŋgin ruum to yabyabuuŋ, ipul uraat isob ila Yosep nima, ve mata ila pani muul maau. Pasa, Yoova inepneep toman Yosep. Tovenen uraat isob to Yosep ighami, nene ilaan poia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sawa pida inim ila, ghoro uraata ru to kinik to Isip tigham sosor pani. Uraata ru tonowen, eez iŋgin ya vaen to kinik, ve ite iŋgin uraat to moziiŋ mberet. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Yesuru tigham kinik ate yabyab kat. Tovenen ye ighur di tilooŋ tila ruum to yabyabuuŋ lolo. Ruum tonowen, yes ndaaba to tiŋgin ruum to kinik ne, daba todi mata pani. Ve Yosep ineep ila ruum tonowen lolo paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tovenen daba tonowen ighur Yosep pa iŋgin ndiran ru tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Uraata ru tonenen tinepneep le mboŋ eez, yesuru tivib. Eemoghon vibiiŋ to yesuru, raratedi maau. Pughudi ite ite. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mboŋmaagh, Yosep ila iŋgig di. Ye ighita naghodi, ve ighilaal ighaze yesuru ledi pataŋani. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tovenen ighason di ighaze: “You naghita gham naghomim poia maau. Vena, lemim pataŋani eta?” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yesuru tipamuul aliŋa tighaze: “Mboŋ, yeru nivib. Eemoghon tamtoghon eta ineep sualen pa ivotia vibiiŋ tiei pughudi ne maau.” Yosep isaav padi ighaze: “Saveeŋ tiam, nene onoon. Maaron moghon to irau ivotia vibiiŋ pughu. Poia. Apaesia vibiiŋ tiam payou ve nalooŋ di.” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tovenen uraata to iŋgin ya vaen to kinik, isavia vibiiŋ toni pa Yosep ighaze: “Vibiiŋ tiou tovene: You naghita ai vaen eez iyoon ila naghog. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ai tonowen mata supu iza le ighur boga tol. Ghoro rikia moghon irug, ve anoŋa ivot, ve ibulbuul. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ghoro nagham pida, ve napiis suru izila rubruub to kinik, ve naghami nala, ve nazuzuuna ila to kinik.” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosep ilooŋ vibiiŋ toni, ve isaav pani ighaze: “Vibiiŋ tiom, pughu tovene: Ai vaen to ighur boga tol, nene iza to mboŋ tol. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mboŋ tol inim ila, ghoro tinim iza. Pasa, kinik pale lolo poia payom, ve igham ghom umuul ula pa uraat tiom. Tovenen yom pale uŋgin ya vaen, ve ugham pani ve ighun inimale muuŋ ughamghami. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ve ulooŋ. Sawa to nepooŋ tiom poia muul, matam iŋgal ghou, ve usavia pataŋani tiou tonene pa kinik. Leso uul ghou, ve anag napul ruum to yabyabuuŋ tonene, ve navot paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pasa, taug lolog ve nanim ndug tonene maau. You naneep izi taan to yes Hibrua, ve tikis ghou ve tigholia ghou nala to tamtoghon pida. Tauto nanim sualen. Ve nagham sosor eta izi sualen paam maau. Tighur ghou nalooŋ nanim ruum to yabyabuuŋ tonene sorok.” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Uraata to iŋgin uraat to moziiŋ mberet, ilooŋ Yosep ivotia ita ite vibiiŋ toni pughu le poia, tovenen ana isavia vibiiŋ toni pa Yosep ighaze: “You paam naghita vibiiŋ eez. Vibiiŋ tiou, tovene: Anunug nalup nakaral tol ve naŋgud di. Nakaral tol tonowen, tivon pa mberet. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nakaral to ineep iza sala, mberet naol naol to kinik tineep ila lolo. Eemoghon man tiroov tinim, ve tighanghan mberet tonowen le isob.” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosep ilooŋ vibiiŋ toni, ve isaav pani ighaze: “Ai, vibiiŋ tiom tonene, pughu tovene. Nakaral tol, nene iza to mboŋ tol. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mboŋ tol inim ila, ghoro kinik imbut motin luam, ve tisaron patum izala imonau ila ai. Ghoro man tiroov tilat, ve tighan mindam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Saveeŋ to Yosep tonene, anoŋa ivot. Mboŋ tol inim ila, ghoro tiza pa sawa to kinik tina ipoopa. Tovenen kinik igham ghanghaniiŋ tiina, ve ipoi uraata toni tisob tinim tilup di ve tighanghan. Ghoro imbaaŋ ila pa uraata to iŋgin ya vaen toni, toman ita ite to iŋgin uraat to moziiŋ mberet, ighaze yesuru tinim paam. Tinim peria, ghoro kinik ipayoon di ila ival tiina matadi, ");
INSERT INTO tuc_o_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ve ighur ŋgeu to iŋgin ya vaen, imuul ila pa uraat toni. Tovenen ye ighur rubruub ila kinik nima inimale muuŋ ighamghami. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Eemoghon ita ite to iŋgin uraat to moziiŋ mberet, tirabi imaat ve tisaron paatu izala imonau ila ai. Tovenen mbeb to ivot ne, deŋia itaghon Yosep saveeŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Eemoghon ŋgeu to iŋgin ya vaen to kinik, mata iŋgal Yosep maau. Lolo imaagh pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Ndaman ru inim ila, ghoro kinik to Isip ighita vibiiŋ. Ivib tovene: Anunu iyondyood izi ya Nil dige, ve ighita makau liim ve ru to tubudi ve popoia kat. Tineep ya lolo ve tiza, ve tighanghan vivib ila ya dige. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mala maau ve makau liim ve ru paam, to koŋkoŋiŋadi ve naghodi poia maau, anadi tineep ya lolo ve tiza. Ghoro tiŋarua makau tubudi tonowen tila, ve tiyoon toman di. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Makau koŋkoŋiŋadi tonowen timundig ve tighan suvun makau to tubudi ve popoia ne. Kinik ivib tovene le isob, ve imundig mata iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ghoro izi igheen ve ivib muul. Ighita yagoŋ anoŋa liim ve ru tivot ila aia ee moghon. Yagoŋ anoŋa tonowen, tintina ve popoia kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mala maau ve yagoŋ anoŋa liim ve ru paam tivot. Yagoŋ anoŋa tonowen, geegeu ve tikadakada. Pasa, yaghur tuntunu to ilaagh inim, ve irab di le timalai. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ghoro yagoŋ kapadi tonowen timundig ve titoon suvun yagoŋ anoŋa to tintina ve popoia ne. Kinik ivib tovene, ghoro imundig mata iyaryaar, ve isaav ighaze: “Wai, you avaat navib.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ndugizau, ghoro kinik igham ŋgar naol pa vibiiŋ toni ru tonowen. Tovenen imbaaŋ ila pa ndiran mura toman ndiran ŋgara to Isip tisob tinim. Yes tinim tivot toni, ghoro isavia vibiiŋ toni ru padi ve tilooŋa, ve ighason di ighaze tivotia pughudi pani. Eemoghon todi eta irau ivotia maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tighamgham ŋgar pa vibiiŋ toni ve tinepneep, ve mbesooŋa to iŋgin ya vaen to kinik, mata iŋgal Yosep. Tovenen isaav pa kinik ighaze: “O kinik, ghara matag iŋgal sosor tiou eez. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Muuŋ, yeru mbesooŋa tiom to iŋgin uraat to moziiŋ mberet, nigham ghom atem yabyab ris. Tovenen yom ughur ghei nilooŋ nila ruum to yabyabuuŋ to daba to yes ndaaba iŋgini. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nineep tonowe, ve mboŋ eez, yeru nivib. Eemoghon vibiiŋ tiei ru raratedi maau. Pughudi ite ite. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sawa tonenen, ŋgeu paghu eez to yes Hibrua ineep toman ghei. Ye mbesooŋa to daba to yes ndaaba to tiŋgin ruum tiom. Yeru nisavia vibiiŋ tiei ru pani, ve ye ivotia pughudi payei. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Le saveeŋ toni anoŋa ivot. Yom ughur ghou muul pa uraat tiou. Ve itag ite, nene yom urabi imaat, ve usaron paatu izala imonau ila ai.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kinik ilooŋ saveeŋ tonene, ve imbaaŋ uraata toni tila ighaze tigham Yosep inim. Tovenen rikia moghon tila tighami ivot pa ruum to yabyabuuŋ. Yosep igharaat tau le isob, ghoro ila ivot to kinik. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kinik ighita, ve isaav pani ighaze: “You naghita vibiiŋ ru, ve tamtoghon eta irau ivotia pughudi payou maau. Eemoghon tipaesia ghom payou tovene: Ighaze ulooŋ vibiiŋ to tamtoghon eta, yom irau uvotia pughu.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosep ipamuul aliŋa ighaze: “You taug naraua maau. Eemoghon Maaron, ye irau ivotia vibiiŋ tiom pughu. Leso uwatag ataam to uneep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tovenen kinik ivotia vibiiŋ toni pa Yosep ighaze: “You navib tovene: Anunug nayondyood izi ya Nil dige, ");
INSERT INTO tuc_o_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ve naghita makau liim ve ru to tubudi ve popoia kat, tineep ya lolo ve tiza, ve tighanghan vivib ila ya dige. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mala maau ve makau liim ve ru to koŋkoŋiŋadi ve naghodi poia maau, anadi tineep ya lolo ve tiza. To muuŋ ve inim, you naghita makau samia eta tovene ineep izi taan Isip ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Makau koŋkoŋiŋadi tonowen, timundig le tighan suvun makau to popoia ve tubudi ne. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Eemoghon apodi idogdoog maau. Apodi kaapa inepneep raraate inimale muuŋ. Tovenen tamtoghon eta irau iwatag ighaze yes tighan makau to tubudi ne maau. You naghita vibiiŋ tonene le isob, ghoro namundig matag iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ghoro nazi nagheen, ve navib muul. Naghita yagoŋ anoŋa liim ve ru tivot ila aia ee moghon. Yagoŋ anoŋa tonowen, tintina ve popoia kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mala maau ve naghita yagoŋ anoŋa liim ve ru paam tivot. Yagoŋ anoŋa tonowen, geegeu ve tikadakada. Pasa, yaghur tuntunu ilaagh inim, ve irab di le timalai. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yagoŋ anoŋa kapadi tonowen timundig ve titoon suvun yagoŋ anoŋa to popoiadi le tisob. Naghita vibiiŋ ru tonene, le nagham ŋgar naol. Tauto nambaaŋ ila pa yes mura tinim, ve nasavia vibiiŋ tiou ru tonene padi. Eemoghon todi eta irau ivotia pughudi payou maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosep ilooŋ vibiiŋ ru tonowen, ve isaav pa kinik ighaze: “Vibiiŋ tiom ru, pughudi ee moghon. Maaron ipatooŋ ghom pa mbeb to ye ighaze ighami ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Makau liim ve ru to popoiadi kat, ve yagoŋ anoŋa liim ve ru to popoia ne, pughudi ee moghon. Nene iza to ndaman liim ve ru. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ve makau samsamia liim ve ru to koŋkoŋiŋadi kat ve ughita di tivot muri, toman yagoŋ anoŋa kapadi liim ve ru to yaghur tuntunu ilaagh inim ve irab di le timalai, nene paam iza to ndaman liim ve ru. Ndaman liim ve ru tonenen, pitool tiina pale ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mbeb tonene, nene inimale nasaav payom. Maaron ipatooŋ ghom pa mbeb to ye ighaze ighami ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","“Ulooŋ. Ndaman liim ve ru tonene, aniiŋ pale ivot tiina irau taan isob to Isip, ve yam araua kat pa aniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Ndaman liim ve ru tonene isob, ghoro pitool tiina kat pale ivot, ve ineep irau ndaman liim ve ru muul. Pitool tonowen pale iwaghamun taan tiam, ve tamtoghon tisob to Isip pale lolodi imaagh pa sawa poia to aniiŋ ivot tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Maaron ŋgar toni iyaryaaŋ kat ighaze mala maau, pale igham mbeb tonene ivot. Tauto igham ghom ughita vibiiŋ ru to pughudi ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“O kinik, yom irau ughita ŋgeu eta to le ghilalooŋ, ve ŋgar toni poia, ve irau mata ighur pa mbeb. Leso ughuri inim ŋginiiŋ pa taan to Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ve yom irau ughur le ulaaŋa pida. Leso tiuuli pa uraat to ŋginiiŋ taan tiina to Isip. Ndaman liim ve ru to aniiŋ ivot tiina, yes irau tiŋgoog aniiŋ pida, leso iŋgin gham pa muri. Yes irau titaghon ataam tovene: Aniiŋ naol to tivot pa ndaman liim ve ru tonenen, yes irau tighur di tinim ndouŋ liim. Le isob, ghoro tighur ndouŋ eez ila ruum to lupuuŋ aniiŋ, ve paaŋ ineep pa tamtoghon tighan. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tovenen ndaman liim ve ru to aniiŋ ivot tiina, yes ulaaŋa tonowen pale tigham naghom, ve tiŋgogoog aniiŋ, tiluplupi ila ndug tintina to Isip, ve tiŋgin poiani. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Leso aniiŋ tonowen ineep ve isaŋan pa ndaman liim ve ru to pitool tiina pale ivot izi Isip. Ighaze ataghon ŋgar tovene, yes Isipa irau pitool di ve timatmaat maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kinik toman ndiran ŋgara to tiŋgin uraat toni, tilooŋ Yosep saveeŋ toni, ve tiyok pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ghoro kinik imundig, ve isaav padi ighaze: “You naghita naghaze ŋgeu tonene, Maaron avuvu ineep tomani, ve ighamgham pooz pani. Takaal ŋgeu ite paam, pale irau ye tonene? Maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ghoro isaav pa Yosep ighaze: “Yom, to Maaron ipaghazoŋan ghom pa mbeb tonene. Irau nandeeŋ ŋgeu ite paam to le ghilalooŋ, ve ŋgar toni poia, ve irau mata ighur pa mbeb inimale yom ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tovenen you pale naghur ghom unum ŋginiiŋ pa taan tiou isob. Tamtoghon tiou tisob pale tilooŋ aliŋam, ve titaghoni. Ve you kinik moghon, to yom uneep ila sambag. Ŋgeu ite paam iŋgin ghom maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ghoro isaav pa Yosep muul ighaze: “Aazne, you naghur ghom unum ŋginiiŋ pa taan isob to Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ve iduduum ring toni to tau mosi ineep ila, ve ighuri ila Yosep nima. Ve igham Yosep le nonogiiŋa pisosooŋa eez to poia kat, ve indudi pani, ve ighur mbeb inimale namatavub to tigharaata pa gol ne ila Yosep lua. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ghoro ipul karis toni ite inim Yosep le, ve Yosep ilandaad pani, ve yes uraata to kinik timuŋmuuŋ pani, ve timboboob tighaze: “Alooŋ! Tiina tiam, tauto inim ne! Yam asob aput aghemim pani!” Kinik igham tovene, leso ival tisob to Isip tiwatag tighaze ye ighur Yosep inim ŋginiiŋ pa taan isob to Isip wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ve kinik isaav pa Yosep ighaze: “Ulooŋ. You kinik to Isip. Aazne ve ila, tamtoghon to Isip irau tigham mbeb eta sorok muul maau. Yom uyok padi, ghoro tighami.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Kinik iwaat Yosep iza paghu Zapenat-Panea. Ve igham ŋgeu eez, iza Potipera, natu liva Asenat ila inim Yosep azuwa. Potipera tonowen, ye ŋgeu to watooŋrau to ndug On. Sawa to Yosep ndaman toni irau tamoot ee saaŋgul (30), ye ipamundigin uraat to kinik to Isip ighuri ila nima. Tovenen ipul kinik, ve ilaghlaagh irau ndug ndug to Isip, ve ighitghita di pa uraat todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","48","Ndaman liim ve ru to aniiŋ tiina ivot, aniiŋ to ivot izi taan to Isip, sorok maau. Katindi kat. Sawa tonenen, Yosep iŋgogoog aniiŋ, ve iluplupi ila ruum naol to lupuuŋ aniiŋ to tiyoon izi ndug tintina to Isip. Ye ighamgham tovene: Aniiŋ to ighaze itub igharau ndug tiina eta, nene uraata toni tighuri ilooŋ ila ruum to lupuuŋ aniiŋ to ndug tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tovenen Yosep iŋgogoog aniiŋ ve iluplupi le katindi kat inimale magargaar to te, le irau tinini maau. Pasa, aniiŋ katindi kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yosep azuwa Asenat to Potipera natu liva, ipoop Yosep le ndinatu ru, ghoro pitool tiina ivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosep iwaat natu aidaba iza Manase. Pasa, igham ŋgar ighaze: “Maaron igham ghou lolog imaagh pa pataŋani tiou toman siŋ tiou wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ve natu muria, Yosep iwaat iza Epraim. Pasa, igham ŋgar ighaze: “You nanepneep sualen, ve pataŋani naol tivot payou. Eemoghon Maaron igham mbeb popoia tivot inim tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","55","Aniiŋ ivot tiina izi Isip irau ndaman liim ve ru le isob, ghoro ndaman liim ve ru to pitool ivot itaghon Yosep saveeŋ toni. Pitool tonowen, tiina kat. Ivot irau ndug tisob. Ve yes Isipa moghon, to adi aniiŋ. Eemoghon muri ghoro, pitool tonowen iwaghamun di paam. Tovenen titaŋ roran kinik pa adi aniiŋ. Eemoghon ye isaav padi ighaze: “Anim tiou malep. Malmalimim ala to Yosep. Ve sa saveeŋ to ighaze ye isavia payam, yam alooŋa ve ataghoni.” ");
INSERT INTO tuc_o_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pitool ivot inim tiina kat le irau ndug tisob to Isip, ghoro Yosep ikaak ataam pa ruum to lupuuŋ aniiŋ, ve yes Isipa tila tighol adi aniiŋ. Pasa, pitool iwaghamun tamtoghon kat irau ndug tisob to Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pitool ivot izi taan to Isip moghon maau. Ivot irau taan tisob le iwaghamun di kat. Tovenen ndug ndug tilala Isip ve tigholghol adi aniiŋ ila to Yosep. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakop inepneep izi taan Kanaan, ve ilooŋ tighaze aniiŋ inepneep izi Isip. Tovenen isaav pa ndinatu ighaze: “Ai, yam awambatutun gham ve anepneep pasa? ");
INSERT INTO tuc_o_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","You nalooŋ tighaze aniiŋ ineep izi Isip. Amundig ve azila aghol aad aniiŋ. Leso tamaat sob, ve taneep mataad iyaryaar.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tovenen Yosep nditogha saaŋgul tigharaat di pa laghooŋ, ve timundig ve tizila pa Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Eemoghon Yakop iŋguruut Yosep tazi Benyamin ineep. Pasa, ate katia pani ighaze yesŋa tila, nene pale mbeb eta iwaghamuni izi ataam luvuŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tovenen Yakop ndinatu toman ndug pida tamtoghonadi tilaagh tizila pa Isip pa tighol adi aniiŋ. Pasa, pitool tiina ivot izi taan Kanaan paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sawa tonenen, Yosep inim ŋginiiŋ pa taan to Isip. Tovenen ndug ndug to tilala Isip pa gholiiŋ adi aniiŋ, tilala toni. Tauto sawa to Yosep nditogha tinim tivot Isip, yes paam tiŋarua tila, tiput aghedi pani, ve tighur naghodi izila taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosep ighita nditogha, ve rikia moghon mata ila ighilaal di. Eemoghon ivotia tau padi maau. Igham inimale ye ŋgeu to ndug ite ve ikankaan padi. Tovenen isaav ariaŋa padi inimale ŋarooŋ di ighaze: “Ai, yam to sa ndug? Anim pasa?” Yes tipamuul aliŋa tighaze: “Yei to taan Kanaan. Ninim pa nighol amai aniiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosep ighilaal nditogha. Eemoghon yes tighilaala maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ye mata iŋgal vibiiŋ toni to muuŋ ighita, ve isaav padi ighaze: “Yam atoom. Yam sandiri! Yam anim pa andaŋgat taan tiei. Leso awatag dige sine to tirau malmal maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yes tipamuul aliŋa tighaze: “Wai, tiina tiei, yei ninim pa ŋgar tovene maau. Yei mbesooŋa tiom, ninim pa nighol amai aniiŋ moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yei sandiri maau. Yei nisob tonene, tamamai ee moghon. Yei ndiran to kaarom maau. Avomai onoon moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosep isaav padi ighaze: “Maau. Yam anim pa andaŋgat taan tiei. Leso awatag dige sine to tirau malmal maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yes tipamuul aliŋa tighaze: “O tiina tiei, yei tonene, olman eez to Kanaan ndinatu. Muuŋ, yei saaŋgul ve ru. Eemoghon tazimai eez, to ilale. Ve tazimai ite to muria kat, ye ineep toman tamamai izi Kanaan.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosep isaav padi muul ighaze: “Saveeŋ, tauto nasavia payam wa. Yam sandiri! Tovenen you nasaav ariaŋa payam ila kinik to Isip iza tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","You pale natoov gham, ve nakis gham aneep sualen le irau tazimim muria to yam asavia ne inim ivot tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tovenen ambaaŋ tamtoghon tiam eta imuul ila igham tazimim tonowen inim. Ve yam pida, pale asob alooŋ ala ruum to yabyabuuŋ, ve aneep ve asaŋan di le tinim tivot. Nene ataam to you naghaze natoov gham pani. Leso nawatag: Saveeŋ tiam onoon, ma kaarom? Ighaze tazimim inim ivot sualen maau, nene you nasaav ariaŋa payam ila kinik iza tovene: Yam sandiri!” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ye isavsaav toman di le isob, ghoro ighur di tilooŋ tila ruum to yabyabuuŋ, ve tineep irau mboŋ tol. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mboŋ tol tonenen isob, ghoro Yosep ila iŋgig di, ve isaav padi ighaze: “Alooŋ. You namatughez pa Maaron ve naghaze nataghon ŋgar toni. Tovenen you pale naghur lemim ataam ite. Ataam tonene, ighaze yam ataghoni, nene pale aneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ighaze avomim onoon, ve agham kaarom payou maau, you pale nakis tamtoghon tiam eez ineep ila ruum to yabyabuuŋ lolo. Ve yam pida avot ala, aghol amim aniiŋ, ve aghami amuul ala pa nditamim to tinepneep toman pitool we. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ghoro agham tazimim to muria kat ne, ve yamŋa amuul anim. Leso nawatag naghaze saveeŋ tiam onoon, ve irau amaat maau.” Yes tilooŋ saveeŋ toni, ve tiyok pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ghoro timundig ve tiwasavon di tighaze: “Onoon kat. Sosor to muuŋ tagham pa taziid, tauto aazne atia iza toit. Pasa, sawa to taghur pataŋani pani, ye itaŋ roran ghiit ighaze lolood isamini. Eemoghon iit talooŋa maau. Tauto aazne, pataŋani iŋarua ghiit.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tovenen Ruben isaav padi ighaze: “Laak, you nasaav payam maau? Naghaze agham sosor pa taziid malep. Eemoghon yam alooŋ ghou maau. Tauto aazne, siŋ toni atia iza toit.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sawa to tisavsaav, Yosep neneeŋa, ve iloŋlooŋ di. Eemoghon yes tiwatagi maau. Pasa, ye igham inimale ye iwatag aliŋadi maau, ve isavsaav padi ila ŋgeu ite to itortoor saveeŋ ila yes aliŋadi. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ye ilooŋ di tisavsaav, le lolo isami, ve ighaze itaŋ. Tovenen itoora, ighur muri padi, ve itaŋ. Itaŋ le isob, ghoro itoora mata ila padi, ve isavsaav toman di muul. Ghoro isaav pa yes ndaaba, ve tikau Simeon nima ila matadi, ve tighami tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosep igham saveeŋ pa yes mbesooŋa toni ighaze tinonog aniiŋ ila nditogha nakaral todi le tivon. Ve tipamuul yes eŋaeŋa yaam todi ila taudi nakaral todi. Ve tigham adi aniiŋ inim taman pa ataam paam. Tovenen yes mbesooŋa tila tigham uraat itaghon Yosep aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ghoro Yosep nditogha tipandid aniiŋ toman mburuguuŋ todi izala esele todi poghodi, ve tipamundigin laghooŋ todi tighaze timuul tila pa Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tilaghlaagh tila le mboŋ izi, tovenen tizi tigharaat inadi pa ghenooŋ. Todi eez ikaak nakaral toni avo ighaze igham esele toni a aniiŋ. Mata izila le ighita yaam toni inepneep. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tovenen isaav pa yes pida ighaze: “Wai! Anim aghita mbeb eez ne. Yaam tiou, tighuri imuul ila nakaral tiou lolo.” Yes tilooŋ aliŋa, le tisob ruŋadi iza ve matughezaaŋ tiina igham di, ve tighaze: “Wai, vena to Maaron igham pait tovene?” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yes timuul tila tivot to tamandi Yakop izi Kanaan, ghoro tipaes pani pa mbeb tisob to ivot padi izi Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Tighaze: “Wai tamamai, daba to iŋgin taan to Isip, ye ŋgeu poia maau. Ye isavia saveeŋ ariaŋa inimale ŋarooŋ ghei, ve ighaze yei nila pa nindaŋgat taan todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Eemoghon yei nisaav pani nighaze: ‘Ee-e, yei tonene, sandiri maau. Yei ndiran to saveeŋ onoon. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yei nisob tonene, tamamai ee moghon. Muuŋ, yei saaŋgul ve ru. Eemoghon tazimai eez, to ilale. Ve tazimai ite to muria kat, ye ineep toman tamamai izi Kanaan.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","34","“Yei nisaav pa daba tonowen tovene, ve isaav payei ighaze: ‘Yam pale apul tiam eez izi ineep toman ghou, ve yam pida aghol amim aniiŋ, ve aghami ala to nditamim to tinepneep toman pitool we. Eemoghon sawa to aghaze amuul anim, matamim iŋgal tazimim to muria kat ne, ve yamŋa anim. Leso nawatag naghaze yam sandiri maau, ve avomim onoon. Ghoro napul ŋgeu tiam to ineep ila ruum to yabyabuuŋ lolo ivot, ve imuul ilat tiam. Ve nayok payam pa alaagh izi ndug tonene ve araukol.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tipaes pa tamandi le isob, ghoro tigham nakaral todi tighaze tiliŋ aniiŋ izi. Eemoghon matadi izila nakaral todi lolodi, le yes eŋaeŋa tighita yaam todi ineep ila nakaral todi todi. Yesŋa tamandi tighita mbeb tonowen, le matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ve tamandi Yakop isaav padi ighaze: “Yam agham ghou nanim mandaat pa ndinatug ru to tilaledi wa. Yosep ilale kat, ve aazne Simeon ana. Ve nene aghaze agham Benyamin paam. Aghita. Pataŋani naol to izaza tiou!” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tovenen Ruben isaav pani ighaze: “Tamaŋ, ulooŋ. Yom irau unumeer ghou, ve upul Benyamin inim nimag ve yeru nila. You pale naghami imuul inim tiom. Ighaze maau, yom irau urab ndinatug ru timaat tinim atia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakop ipamuul aliŋa ighaze: “Maau le maau kat! Natug tonene irau ilat toman gham maau. Pasa, togha Yosep, to ilale wa. Ve aazne, ye eŋgeni kat. You nanim olman waat ve moom iza payou wa. Ighaze ye ilat toman gham, ve pataŋani eta ivot pani izi ataam luvuŋa, nene pale lolog isami kat, ve namaat nazila ndug to mateeŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Sawa tonenen, pitool ivot inim tiina kat izi Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tovenen Yakop toman tamtoghon toni tighanghan aniiŋ to ndinatu tighami izi Isip le isob, ghoro Yakop isaav pa ndinatu ighaze tizila muul pa Isip, ve tighol adi aniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Eemoghon Yuda isaav pani ighaze: “Tamaŋ, ŋgeu tonowen imogheer pa saveeŋ maau. Ye isaav ariaŋa kat payei ighaze nigham tazimai tonene ve yeiŋa nila. Ighaze maau, yei irau nila peria toni muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tovenen ighaze yom uyokia Benyamin payei, nene pale nizila muul ve nighol am aniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ve ighaze maau, yei irau nila maau. Pasa, daba tonowen isaav ariaŋa payei. Ighaze nigham tazimai ve yeiŋa nila maau, irau nila peria toni muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakop ilooŋ saveeŋ tonene, ve iyaan di ighaze: “Pughu vena to apaesia tazimim ila to daba tonowen? Yam agham pataŋani tiina kat payou!” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yes tipamuul aliŋa tighaze: “Ŋgeu tonowen ighason roran ghei pa siŋ tiei ighaze: ‘Tamamim inepneep, ma imaat wa? Ve tazimim ite paam inepneep, ma maau?’ Tauto yei nipamuul ghasoniiŋ toni. Ve ŋgar toni to ighaze yei nigham tazimai tonene ve yeiŋa nizila, nene yei nikankaan pani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ghoro Yuda isaav pa tama Israel muul ighaze: “Tamaŋ, uyokia pain tonene payou lak! Leso yeiŋa nizila Isip, ve nighol aad aniiŋ. Pa vene, pitool ghiit ve tasob tamatmaat. Yamŋa nditimbum, ve yei paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","You nambua saveeŋ ariaŋa toman ghom tovene: Taug pale matag pani le irau naghuri imuul inim tiom. Ve ighaze naghami imuul inim iyoon ila matam maau, nene pale inim leg pughu, ve nambaad saveeŋ toni le irau sawa tiou isob ve namaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ughita! Inimale ukis ghei pa savsaveeŋ maau, tone nizila ve nimuul niza ninim pae ru wa.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tovenen tamandi isaav padi ighaze: “Tambaŋa. Ighaze leed ataam ite paam maau, ghoro aghami ve yamŋa ala. Ve agham mbeb popoia pida to taan tonene inimale naunauŋ to vuzidi popoia, toman ai anoŋa popoia, bagil suru, aŋar, ve mbeb pida paam, ve anonog di tila nakaral tiam, ve aghami ala. Leso agham pa daba tonowen ve arab ate. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ve agham yaam tiam muŋgina to tipamuula izila nakaral tiam lolodi, toman yaam pida paam, ve ala. Yaam muŋgina tonowen, aghuri imuul ila padi. Pasa, yes avaat matadi ikankaan, tauto tighur yaam tiam izila nakaral tiam lolodi muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ve agham tazimim tonene paam ve yamŋa amundig ve ala to daba tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne, pale igham ŋgeu tonowen lolo isamin gham, ve iyokia Simeon yesuru tazimim tonene payam. Leso yamŋa amuul anim. Ve ighaze maau, tambaŋa. Nazi nanim mandaat lak.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","16","Tovenen yes timundig, ve tigham mbeb popoia pida pa tirab daba to Isip ate, toman yaam muŋgina ve paghu pida paam, ve yesŋa Benyamin tizila pa Isip. Tila tivot to Yosep ve tiyoon ila mata, ve ye ighita Benyamin inim toman di paam. Tovenen isaav pa mbesooŋa toni to iŋgin ruum toni ighaze: “Ugham ndiran tonene tila ruum tiou, ve urab ŋgai eta, ve ugharaat amai aniiŋ. Leso yeiŋa nighan pa ndag maatu.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tovenen mbesooŋa tonowen itaghon Yosep aliŋa, ve igham Yosep nditogha ve tazi tila pa ruum toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tila tivot izi ruum, le matughezaaŋ tiina igham di, ve lolodi imbumbu tighaze: “Wai! Yaam to tipamuula izila nakaral toit, tauto avaat saveeŋ igham ghiit. Avaat pughu tonene, to tigham ghiit tanim ruum toni. Aazne, pale daba tonowen imundig ikis ghiit, ve igham ghiit tanim mbesooŋa toni sorok, ve iyou esele toit paam tinim le.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tovenen tila peria ataam avo, ve tisaav pa mbesooŋa to iŋgin Yosep ruum toni tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","22","“Tiina tiei, yei lemai saveeŋ ris payom. Muuŋ, yei ninim sualen, ve nighol amai aniiŋ. Eemoghon sawa to nimuul nila ve atemai izi ataam luvuŋa, nikaak nakaral tiei, ve nighita yaam tiei isob ineep ila nakaral tiei avodi. Yei nikankaan pa sei to ipamuula. Tovenen nigham yaam muŋgina tonowen ninim nighaze nighuri imuul ilat. Ve ninim toman yaam tiei pida paam pa nighol amai aniiŋ pani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Eemoghon mbesooŋa tonowen ipamuul aliŋadi ighaze: “Ai, agham ŋgar naol malep. Atemim izi. Yaam tiam to muuŋ aghami anim aghol aniiŋ pani, nene naghami wa. Maaron tiam to yamŋa tamamim ambesmbees pani, ye tau avaat iŋgooz lemim mbaliiŋ tonenen izila nakaral tiam lolodi.” Yesŋa tisavsaav le isob, ghoro mbesooŋa tonenen ila igham Simeon ivot, ve ighuri ila todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","25","Ghoro igham di tilooŋ tila ruum, ve igham ya inim timen aghedi, ve ipan esele todi. Ve ipaes padi ighaze ndag iza inim bobodaaŋ, ghoro yesŋa tiina toni tighanghan. Tovenen yes tigharaat mbeb popoia pida to tighaze tigham pa Yosep, ve tisaŋan. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ndag maatu, ghoro Yosep inim peria ruum. Nditogha ve tazi tigham mbeb popoiadi to tigham di tinim, ve tighur di tila toni, ghoro tiput aghedi pani, ve tighur naghodi izila pa taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosep ighason di pa nepooŋ todi, ve ighason di pa tamandi ighaze: “Vena, tamamim to muuŋ apaesia payou, ye ineep pooi, ma maau? Olman imaat, ma inepneep?” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yes tipamuul aliŋa tighaze: “Tiina tiei, tamamai to mbesooŋa tiom ne, mbeb eta ighami maau. Ye ineep pooi.” Ghoro tighur naghodi izila pa taan muul pa tipakuri. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosep mata ila le ighita tazi Benyamin to yesuru tinandi ee moghon. Tovenen ighason di ighaze: “Tazimim to muuŋ asavia payou, tau tonanan?” Ghoro isaav pani ighaze: “Aa natug, poia to Maaron iza tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ye isaav tovene, le lolo isami kat pa tazi, ve rismoghon tone itaŋ ila matadi. Tovenen rikia moghon ipul di, ve ilooŋ ila ruum lolo ite ve itaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Itaŋ le isob, ghoro imen nagho, ipariaaŋ tau, ve ivot ila todi muul, ve isaav pa yes mbesooŋa tigham aniiŋ inim. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sawa to tigham aniiŋ inim, tighur Yosep a izala toŋ toni, ve nditogha ve tazi adi izala toŋ ite. Ve yes Isipa to yesŋa tighanghan, aniiŋ todi izala toŋ ite paam. Pasa, yes Isipa lolodi pa tighanghan toman yes Hibrua maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Sawa to yes mbesooŋa tighur Yosep nditogha ve tazi pa nepooŋ, tighur di mboledi izi tipartaghon inimale nditinandi tipoop di. Ŋgeu aidaba imuuŋ, ve ila ila le imuul izi ŋgeu muria. Tovenen Yosep nditogha ve tazi avodi ikaak, ve tiwambatutun di. ");
INSERT INTO tuc_o_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosep ivureer aniiŋ popoia pida ila tau toŋ toni, ve mbesooŋa toni tighami tila, ve tireii pa nditogha ve tazi. Eemoghon aniiŋ popoia to tigham pa Benyamin, nene ilib kat pa nditogha todi. Tiŋgal aniiŋ pani pa liim. Tovenen Yosep toman nditogha ve tazi tighanghan ve tighunghun toman lolodi poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosep toman nditogha ve tazi tighanghan le isob, ghoro isaav pa mbesooŋa toni to iŋgin ruum toni ighaze: “Unonog aniiŋ izila nakaral todi lolodi le tivon, ve ughur tamtoghon eŋaeŋa yaam todi imuul izila nakaral todi avodi. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ve ugham rubruub tiou to tigharaata pa silva ne, toman yaam to ŋgeu muria, ve uzeev di tizila nakaral toni avo.” Tovenen mbesooŋa tonowen ila igham mbeb itaghon Yosep aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tigheen le ndugizau, ghoro yes mbesooŋa to Yosep tighur Yosep nditogha ve tazi toman esele todi timuul tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Yes tipul ndug tiina, ve tilaagh tila ris, ghoro Yosep isaav pa mbesooŋa toni to iŋgin ruum toni ighaze: “Umundig ve ulaan taghon di ula. Sawa to uvot todi, usaav padi ughaze: ‘Ai, ŋgar poia to tiina tiou ipatooŋa payam, pughu vena to ayati pa ŋgar samia? ");
INSERT INTO tuc_o_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yam ayub rubruub toni to ye ighunghun pani, ve ighitghita mbeb to muri pale ivot. Ŋgar to aghami, nene samia kat!’” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yosep isavsaav pani le isob, ghoro mbesooŋa tonowen imundig, ve ilaan itaghon Yosep nditogha ve tazi ila, le ivot todi. Ghoro isavia Yosep aliŋa padi. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yes tilooŋ saveeŋ toni, ve tipamuul aliŋa tighaze: “Wai tiina, yom ughita ghei vena, to ugham saveeŋ tovene payei? Yei mbesooŋa tiom irau nigham ŋgar eta tovene maau. Maau le maau kat! ");
INSERT INTO tuc_o_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ughita. Sawa to nimuul nila nivot taan Kanaan ve nikaak nakaral tiei, ruŋamai iza pa yaam tiei isob ineep izila nakaral tiei avodi. Eemoghon yaam tonowen, nighami imuul ilat wa. Tovenen pale niyub silva ve gol ila ruum to tiina tiom lolo pasa? ");
INSERT INTO tuc_o_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tiina, ighaze yom undeeŋ rubruub tonowen ineep to tamtoghon tiei eta, nene pale tamtoghon tonenen imaat, ve yei pida ninim mbesooŋa pa tiina tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mbesooŋa tonenen ipamuul aliŋadi ighaze: “Saveeŋ tiam poia. Eemoghon ighaze nandeeŋ rubruub tonenen ineep to tamtoghon tiam eta, nene ye eŋgeni moghon to pale inim mbesooŋa payou. Ve yam pida, lemim saveeŋ maau. Irau ala.” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tovenen rikia moghon yes eŋaeŋa tisur nakaral todi todi izi taan, ve tikaak avodi. Leso mbesooŋa tonenen itiir di. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ye itiir to ŋgeu olman muuŋ, ve itaghoni ila ila le indeeŋ rubruub tonenen ineep ila ŋgeu muria Benyamin nakaral toni lolo. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nditogha tighita mbeb tonenen le atedi milia. Tauto tireep nonogiiŋa todi, ve tiit mburuguuŋ todi izala esele todi poghodi muul, ve timuul tila pa ndug tiina. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosep inepneep ruum toni, ve isasaŋan di. Yuda toman nditogha ve nditazi tinim peria toni muul, ve titap tizi ila Yosep nagho, ve tighur naghodi izila taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosep isaav padi ighaze: “Pughu vena to agham ŋgar tonene? Yam akankaan payou? Tamtoghon to inimale you, ye irau iwatag mbeb ŋgozaaŋ paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda ipamuul aliŋa ighaze: “Oo tiina tiei, yei lemai saveeŋ maau. Pasa, sosor tiei to ineep ghazooŋa wa. Pale nisaav vena? Pasa aazne, Maaron tau, to ipatooŋ sosor tiei ivot ighazooŋ. Tovenen tiina, yei nisob pale ninim mbesooŋa payom, yeiŋa tazimai to rubruub tiom ineep toni ne.” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Eemoghon Yosep isaav padi ighaze: “Ee-e, irau nagham tovene maau. Ŋgeu to rubruub tiou ineep toni, ye eŋgeni moghon to pale ineep ve inim mbesooŋa payou. Ve yam pida, amuul ala to tamamim. You leg saveeŋ payam maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ghoro Yuda ila igharau Yosep, ve isaav pani ighaze: “O tiina tiou, you mbesooŋa tiom. Yom izam tiina inimale kinik tau. Eemoghon naghaze nasavia saveeŋ tiou ris payom. Atem ghora, yabyab payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Muuŋ, yom ughason ghei ughaze: ‘Tamamim inepneep? Ve lemim tazimim ite paam, ma maau?’ ");
INSERT INTO tuc_o_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","“Ve yei nipamuul ghasoniiŋ tiom nighaze: ‘Vee. Tiina tiei, tamamai yesuru tazimai muria, to tinepneep we. Tazimai tonowen, tamamai inim olman, ghoro tina ipoopa. Ve tinamai tonowen, ye ipoop ndinatu ru moghon. Ŋgeu olman imaat wa. Tovenen ŋgeu muria moghon to inepneep. Tamamai ipulpuli maau. Pasa, ye lolo pani kat.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tiina, yom ulooŋ saveeŋ tiei tonenen, tauto usaav payei ughaze nigham tazimai tonene inim, leso ughita pa taum matam. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Ve yei nipamuul aliŋam nighaze: ‘Tazimai tonowen pale irau ipul tamamai ne maau. Pasa, ighaze ipuli, nene pale tamamai lolo isami, ve imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Eemoghon yom usaav ariaŋa payei ughaze yei nigham tazimai tonene ve yeiŋa nimuul ninim. Ighaze maau, irau ninim peria tiom muul maau.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Sawa to nimuul nila nivot to tamamai, yei nipaesia aliŋam isob tonenen pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nineep le muri ghoro, tamamai imbaaŋ ghei muul ighaze ninim tiom, ve nighol amai aniiŋ rita. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tovenen yei nisaav pani nighaze: ‘Tamamai, yei irau nizila sorok maau. Pasa, ighaze yeiŋa tazimai nizila maau, nene irau nila nivot to daba tonowen maau. Tovenen uyokia tazimai payei, ghoro nizila. Ve ighaze uŋguruuta, nene pale nineep.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tovenen tamamai to mbesooŋa tiom ne, isaav payei ighaze: ‘Yam awatag: Azuwag Rael ipoop leg ndinatug ru moghon. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ve eez ipul ghou alok wa. Avaat mbeb sagsag eta ighani ila wa. Pasa, sawa tonenen ve inim, you naghita nagho muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aghita. You nanim olman waat ve moom iza payou wa. Ighaze yam agham natug tonene ve ala, ve pataŋani eta ivot pani izi ataam luvuŋa, nene pale lolog isami kat, ve namaat nazila ndug to mateeŋa.’ “Tamamai aliŋa, tau tonene. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Tovenen tiina tiou, ughita. Tamamai, ghora, inim olman waat ve moom iza pani. Ighaze namuul nala toni, ve ye ighita tazimai tonene nagho maau, nene pale lolo isami kat ve imaat. Pasa, lolo pa natu tonene kat. Ve yei tonene pale ninim pughu pa mateeŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tiina tiou, you taug nambua saveeŋ ariaŋa toman tamamai naghaze you pale matag pa tazimai tonene le irau naghami imuul ila peria toni. Ve ighaze naghami imuul ila toni maau, nene pale inim leg pughu, ve nambaad saveeŋ toni ila tamamai mata le irau sawa tiou isob ve namaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tiina, vena? Irau upul tazig kainaŋen tonene toman nditogha pida timuul tila to tamamai? Ve you pale nagham ina, ve naneep sualen, ve nanim mbesooŋa payom. ");
INSERT INTO tuc_o_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Pasa, ighaze tazig tonene inim toman ghou maau, pale namuul nala to tamaŋ vena? You lolog pa naghita pataŋani tovene iza toni maau.” ");
INSERT INTO tuc_o_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yuda isavia saveeŋ tonene, le Yosep irau ipariaaŋ tau pa taŋiiz muul maau. Tovenen isaav aliŋa tiina pa yes uraata toni to yesŋa tiyondyood, ighaze: “Yam asob avot ala pumuri!” Yes tivot tila, ve yesŋa nditogha ve tazi eŋgendi tineep, ghoro ivotia tau padi. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ye itaŋ aliŋa tiina. Tovenen tamtoghon pida to Isip to tineep tigharau di, tilooŋa ve tila tipaesia varu pa kinik. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosep isaav pa nditogha ve tazi ighaze: “You Yosep! Taug tonene! Onoon, tamaŋ inepneep?” Eemoghon yes irau tipamuul aliŋa maau. Pasa, ruŋadi iza le todi ilale. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tovenen Yosep isaav padi muul ighaze: “Anim agharau ghou.” Yes tila tigharaui, ve isaav padi muul ighaze: “You Yosep! You tazimim to muuŋ yam agholia ghou nala to yes ndiran to raukoliiŋ. Ndiran tonowen, to tigham ghou nanim naneep izi Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Eemoghon lolomim ipataŋan ve awasukun saveeŋ pa taumim malep. Onoon, yam agholia ghou. Tauto tigham ghou nanim naneep sualen. Eemoghon yam agham ŋgar tonenen sorok maau. Maaron tau, to imbaaŋ ghou namuuŋ payam nanim. Leso nauul tamtoghon katindi ve timaat sob, ve nakis di tineep matadi iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Pitool tonene ineep irau ndaman ru wa. Ve ndaman liim paam inepneep naghood sone. Ndaman liim tonenen, pale vazogiiŋ aniiŋ maau, ve taitaiŋ paam maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Maaron imbaaŋ ghou namuuŋ payam nanim pa nauul gham, leso amaat sob. Tauto aazne, aneep pooi. Ve muri paam, papaghu tiam pale tineep pooi, ve iseeŋga tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tovenen yam ambaaŋ ghou nanim sualen maau. Maaron tau, to imbaaŋ ghou nanim. Ve ye ighur ghou nanim daba pa kinik uraat toni. Tauto aazne, naŋgin mbeb toni tisob toman taan isob to Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“You naghaze yam rikia amuul ala to tamaŋ, ve asavia aliŋag pani aghaze: ‘Natum Yosep aliŋa ilat payom tovene: Maaron ighur ghou nanim tiina, ve naŋgin taan isob to Isip. You naghaze yom upul taan Kanaan, ve rikia moghon uzi unum tiou. Uzuar malep. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tovenen yamŋa ndinatum ve nditimbum, asob amundig, ve ayou ŋgai tiam toman mburuguuŋ tiam tisob, ve anim. Leso aneep agharau ghou izi taan suruvu to Gosen. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Pasa, pitool tiina tonene, ndaman liim inepneep sone. Eemoghon you taug pale naŋgin gham pa aniiŋ. Tovenen yamŋa tamtoghon tiom irau ambool pa mbeb eta maau.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ghoro Yosep isaav padi muul ighaze: “Yam asob aghita katin ghou wa. Ve tazig Benyamin paam, ye ighita ghou. You Yosep. Taug to nasavsaav toman gham ne. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tovenen yam ala ve asaav pa tamaŋ tovene: ‘Natum Yosep iza inim tiina kat izi taan Isip.’ Ve apaes pani pa mbeb tisob to yam aghita di izi sualen. Ghoro aghami ve rikia amuul anim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ye isavsaav padi le isob, ve yesuru tazi Benyamin tiwasavagun di, ve titaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ghoro Yosep isavag nditogha tisob, ve yesŋa titaŋ. Titaŋ le isob, ghoro lolodi poia ve avodi imbees. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sawa to kinik to Isip yesŋa uraata toni tilooŋ tighaze toŋvetaz to Yosep tila tivot toni, igham di lolodi poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tovenen kinik isaav pa Yosep ighaze: “Usaav pa tazim ve nditogham pa tipandid aniiŋ izala esele todi, ve timuul tila pa taan Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ghoro tigham tamamim toman ndizwadi ve ndinatudi, ve yesŋa timuul tinim tivot tiou. You pale napul taan pida to Isip to poia kat inim ledi. Leso tineep pooi, ve adi aniiŋ popoia katindi. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ve usavia aliŋag padi tovene: Yes irau tigham karis pida to Isip ve tila. Leso tighur tamamim, toman ndizwadi ve ndinatudi tiza, ve timuul tinim. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ighaze tipul mbeb todi pida izi Kanaan, matadi ila pani malep. Pasa, taug pale narabolini pa mbeb popoia pida to ndug tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakop ndinatu tila tigham uraat itaghon kinik aliŋa le isob, ghoro Yosep igham ledi karis pida, ve igham adi taman paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ve irei ledi nonogiiŋa papaghu irau di. Eemoghon Benyamin, Yosep igham le nonogiiŋa papaghu liim, ve yaam silva irau 300. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yosep ipandid mbeb popoiadi pida to Isip tizala esele nditamoot saaŋgul poghodi, ve isaŋgoor di tila to tama Yakop. Ve isaŋgoor esele paŋgaar saaŋgul toman aniiŋ naol naol paam. Leso sawa to timuul tinim, inim taman pa tama. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ghoro Yosep ighur nditogha ve tazi tila. Ve isaav padi ighaze: “Ala ve akokook izi ataam luvuŋa malep.” ");
INSERT INTO tuc_o_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tovenen yes tipul taan to Isip, ve tilaagh tila tivot to tamandi Yakop izi Kanaan. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ghoro tipaes pani tighaze: “Tamamai, ulooŋ! Natum Yosep, ye imaat maau. Inepneep Isip we. Ve ye inim tiina, ve iŋgin taan isob to Isip.” Yakop ilooŋ saveeŋ todi, le ruŋa iza ve ŋgar toni isob. Eemoghon ighur ila maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ve sawa to tipaesia Yosep aliŋa pani, ve ighita karis to Yosep isaŋgoor di tila padi leso tiza ve tizila pa Isip, ghoro tini iza ve lolo poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tovenen isaav ighaze: “Onoon kat. Ghara naghur ila. Natug Yosep imaat maau. Ye inepneep. You pale nala ve naghita pataghaaŋ. Ve muri, ighaze namaat, namaat lak!” ");
INSERT INTO tuc_o_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tovenen Yakop iyou mbeb toni tisob, ve yesŋa ndinatu ve nditimbu timundig, ve tizila pa Isip. Tilaagh tila le tivot ndug Ber-Seba, ghoro ye igham watooŋrau pa Maaron to tama Isak izi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mboŋ tonenen, itandag ighaze Maaron inim toni, ve ipoii ighaze: “Yakop, Yakop!” Yakop iyok pa aliŋa ighaze: “Taug nene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","Ghoro Maaron isaav pani ighaze: “You Yoova. You Maaron to tamam Isak. Umatughez pa uzila taan Isip malep. Pasa, you pale nalat toman ghom pa laghooŋ tiom, ve nagham papaghu tiom timasa tinim ival kat tonowe. Ve muri, you pale nagham gham amuul anim taan tonene. Ve sawa to mateeŋ tiom, natum Yosep tau pale ineep digem ve igharaat ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Tovenen Yakop toman ndinatu, nditimbu, ve ndirawa liva tiza karis to kinik to Isip isaŋgoor di padi ne, ve tipamundigin laghooŋ todi muul. Tipul ndug Ber-Seba, ve tilaagh toman ŋgai ve mburuguuŋ todi to tigham di izi Kanaan, ve tizila pa Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakop papaghu toni to yesŋa tizila pa Isip ne izadi tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben, ye Yakop natu aidaba. Ruben ndinatu, nene: Anok, Palu, Ezron, ve Karmi. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ve Simeon ndinatu, nene: Yemuel, Yamim, Oat, Yakin, Zoar, ve Saul. Saul tina, ye Kanaan tidi. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ndinatu, nene: Koat, ve Merari. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ve Yuda ndinatu, nene: Er, Onan, Sela, Peres, ve Zera. Eemoghon Er yesuru Onan timaat izi Kanaan. Yuda natu Peres, ye ipoop ndinatu nditamoot ru, izadi Ezron ve Amul. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar ndinatu, nene: Tola, Pua, Yop, ve Simron. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ve Zebulun ndinatu, nene: Seret, Elon, ve Yalel. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yakop yesuru azuwa Lea tinepneep izi taan suruvu to Mesopotamia, ve tipoop ndinatudi nditamoot tonene toman natudi liva Dina. Tovenen Lea ndinatu ve nditimbu, yes irau tamoot ee saaŋgul ve tol (33). ");
INSERT INTO tuc_o_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gat ndinatu, nene: Zipion, Agi, Suni, Ezbon, Eri, Arodi, ve Areli. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ve Aser ndinatu, nene: Imna, Isva, Isvi, ve Beria. Ve livudi iza Sera. Aser natu Beria ndinatu, nene: Eber ve Malkiel. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tamtoghon saaŋgul liim ve eez (16) tonene, nene Lea liva mbesooŋa toni Silpa yesuru Yakop ndinatudi ve nditimbudi. Silpa tonene, Lea tama Laban igham pani inim mbesooŋa toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakop yesuru azuwa Rael ndinatudi, nene: Yosep yesuru Benyamin. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Sawa to Yosep inepneep izi Isip, yesuru azuwa Asenat tipoop ndinatudi ru, izadi Manase ve Epraim. Yosep azuwa Asenat, ye Potipera natu liva. Potipera, ye ŋgeu to watooŋrau to ndug On. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin ndinatu, nene: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Upim, ve Art. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tamtoghon saaŋgul ve paaŋ (14) tonene, nene Yakop yesuru azuwa Rael ndinatudi ve nditimbudi. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ipoop natu ee moghon, iza Usim. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ve Naptali ndinatu, nene: Yazil, Guni, Yezer, ve Silem. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tamtoghon liim ve ru tonene, nene Rael liva mbesooŋa toni Bila yesuru Yakop ndinatudi ve nditimbudi. Bila tonene, Rael tama Laban igham pani inim mbesooŋa toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tovenen Yakop ndinatu ve nditimbu to yesŋa tizila pa Isip, yes irau tamoot tol liim ve eez (66). Ve ndirawa liva, nene tinin di toman di maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ve ighaze talup Yakop tau, ndinatu, ve nditimbu, toman Yosep ve ndinatu ru to yesuru azuwa Asenat tipoop di izi Isip, nene tinim tamoot tol saaŋgul (70). Yes tonene to tilup di ve tineep izi Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakop toman ndinatu ve nditimbu tila tigharau Isip, ghoro imbaaŋ natu Yuda imuuŋ ila, ve isavia varudi pa Yosep ighaze tama inim ivot taan suruvu to Gosen wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Tovenen Yosep isaav pa uraata toni ve tigharaat karis pani, ghoro iza ve ila pa Gosen ighaze ighita tama. Ila ivot toni, ghoro isavagi ve itaŋ pani le mala. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ghoro Yakop isaav pani ighaze: “Aa natug, you naghaze pa umaat wa. Eemoghon maau. Aazne, naghita ghom uneep matam iyaryaar. Ighaze namaat, namaat lak!” ");
INSERT INTO tuc_o_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ghoro Yosep isaav pa nditogha ve tazi, toman tamtoghon todi pida to yesŋa tinim ne ighaze: “You pale namuul nala to kinik, ve napaes pani naghaze: ‘Tamaŋ, tazig ve nditoghag tipul taan Kanaan, ve tinim tivot wa. ");
INSERT INTO tuc_o_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yes ndiran to ŋginiiŋ ŋgai. Tovenen tiyou ŋgai toman mburuguuŋ todi, ve tinim.’ ");
INSERT INTO tuc_o_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","You pale nala toni ve nasaav pani tovene. Ve alooŋ. Yes Isipa lolodi pa tilup toman ndiran to ŋginiiŋ ŋgai maau kat. Tovenen sawa to kinik ipoi gham ala toni, ve ighason gham pa uraat tiam, yam asaav pani tovene aghaze: ‘O tiina tiei, sawa to pain ghei ve inim aazne, yei tamtoghon to ŋginiiŋ ŋgai ninimale nditimbumai.’ Ighaze yam asaav pani tovene, ye pale iyok pa aneep izi taan suruvu to Gosen tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosep ila to kinik, ve ipaes pani ighaze: “O kinik, tamaŋ, tazig ve nditoghag tipul taan Kanaan ve tinim tivot Isip wa. Yes tinim toman ŋgai ve mburuguuŋ todi, ve aazne tineep izi Gosen. Tauto nagham tamtoghon todi pida tinim, leso ughita di.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ghoro igham nditogha liim tila tiyoon ila kinik mata. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kinik ighita di, ve ighason di ighaze: “Yam aghamgham sa uraat?” Yes tipamuul aliŋa tighaze: “Tiina tiei, yei ndiran to ŋginiiŋ ŋgai ninimale nditimbumai. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pitool tiina ivot izi taan Kanaan, ve ndug tonowen le kikiliiŋ irau to ŋgai tiei tighan ne maau. Tauto ninim nighaze nineep ninim loom izi ndug tiom tonene. Tiina tiei, vena? Irau uyok pa nineep izi taan suruvu to Gosen, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kinik ilooŋ saveeŋ todi, ve isaav pa Yosep ighaze: “Aazne, taum tamam ve toŋvetaz tiom, tauto tinim tivot leso tineep toman ghom. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Taan isob to Isip ineep ila nimam wa. Tovenen taum ughita taan sine to poia kat, ghoro ughur di tineep pani. Ighaze lolodi pa tineep izi taan Gosen, nene poia. Ve ighaze tamtoghon todi pida tiraua kat pa uraat to ŋginiiŋ ŋgai, ghoro ughur di tiŋgin ŋgai tiou paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ghoro Yosep igham tama Yakop ila iyoon ila kinik mata paam, ve Yakop ighur poia to Maaron iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Le isob, ve kinik ighasoni ighaze: “Aa olman tiou, ndaman tiom irau piiz?” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakop ipamuul aliŋa ighaze: “You naneep nanim loom izi taan irau ndaman tamoot liim tamoot ee saaŋgul (130) wa. Ndaman tiou katindi inimale to nditimbug maau. Ve nepooŋ tiou poia maau. Pataŋani naol tigham ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakop isavsaav pa kinik le isob, ve ighur poia to Maaron iza toni muul, ghoro ipuli, ve ivot ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosep ila igharaat nepooŋ to tama, nditogha, ve tazi, toman ndizwadi ve ndinatudi itaghon kinik aliŋa. Ye igham ledi taan poia kat to ineep izi taan suruvu to Ramses. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ve ye tau iŋgin tama toman toŋvetaz toni pa adi aniiŋ, itaghon tamtoghon piiz to tineep ila ruum eŋaeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Sawa tonenen, pitool ivot tiina le tiina kat, ve iwaghamun yes Isipa ve yes Kanaana le tisami kat. Pasa, adi aniiŋ rita ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tovenen tiketkeet tilala to Yosep pa gholiiŋ adi aniiŋ, ve iyouyou yaam todi, ve ighurghuri ilala to kinik. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tighamgham tovene, le Yosep iyou yes Isipa ve yes Kanaana yaam todi le isob kat. Ghoro yes Isipa tila to Yosep, ve titaŋ rorani tighaze: “O tiina tiei, yaam tiei ghora, isob kat. Ugham amai aniiŋ sorok! Ighaze yom uul ghei maau, nene pale nisob nimatmaat ila matam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosep ipamuul aliŋadi tovene: “Ighaze yaam tiam isob kat, ghoro agham ŋgai tiam tinim, ve aparabol pa amim aniiŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tovenen ndaman ee moghon tonenen, yes tighamgham ŋgai todi tilala to Yosep, ve ye ighamgham adi aniiŋ, le iyou suvun hos, esele, makau, sipsip, ve mekmek todi tisob. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ndaman tonenen inim ila, ve ndaman ite, ghoro yes Isipa timuul tila to Yosep, ve tisaav pani tighaze: “O tiina tiei, pataŋani tiei, irau niŋgooza payom maau. Ughita. Pitool tonene inepneep sone. Eemoghon yaam tiei toman ŋgai tiei, tauto uyou suvun di wa. Ve lemai mbeb eta muul pa nigham payom ne maau. Yei taumai moghon to ninepneep, toman taan tiei. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tiina tiei, paam nisob nimatmaat ila matam pa pitool. Tovenen ughol ghei toman taan tiei, ve ugham amai aniiŋ pa nighan, ve ugham lemai uuv, leso nitoov vazogiiŋ di. Yei nisob pale ninim mbesooŋa pa kinik, ve taan tiei paam inim le. Leso nimaat sob, ve nineep matamai iyaryaar. Ighaze uul ghei maau, nene pale nisob nimatmaat, ve taan tiei ineep sorok.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","21","Tovenen Yosep ighol taan isob to yes Isipa inim kinik le. Pasa, pitool iwaghamun di le tisami kat. Tauto tamtoghon tisob to Isip tigholia taan todi isob ila pa kinik, ve tinim mbesooŋa pani. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eemoghon yes ndiran to watooŋrau, yes tigholia taan todi ila pa Yosep maau. Taan todi ineep to taudi. Pasa, yes tinepneep ila kinik tau nima. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","24","Yes Isipa to Yosep ighol taan todi, ye isaav padi ighaze: “Aazne, you naghol gham toman taan tiam, ve anim mbesooŋa to kinik wa. Tovenen you pale nagham lemim aniiŋ uve, leso avazog di. Muri, ighaze aniiŋ anoŋa ivot, yam pale avalagi inim ndouŋ liim, ve aghur ndouŋ eez imuul ila to kinik, ve ndouŋ paaŋ inim amim. Aghan pida, ve pida ineep pa avazog di.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yes tilooŋ Yosep saveeŋ toni, ve tiyok pani tighaze: “Tiina tiei, yom ugham poian ghei kat. Inimale yom uul ghei maau, tone nisob nimatmaat. Tovenen yei pale ninim mbesooŋa pa kinik, ve nimbees pani toman lolomai poia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tauto Yosep ighur tutuuŋ eez pa yes Isipa tovene: Muri, ighaze aniiŋ anoŋa ivot, yes irau tilup aniiŋ, ghoro tivalagi inim ndouŋ liim, ve tighur ndouŋ eez imuul ila to kinik. Eemoghon yes ndiran to watooŋrau, aniiŋ isob to itubtub ila taan todi, nene ineep pa taudi. Pasa, kinik ighol taan todi inim le maau. Tutuuŋ tonene titataghoni sone. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tovenen yes Israela tizila Isip, ve tila tineep izi taan suruvu to Gosen. Tinepneep tonowe, ve tamtoghon toman mbeb todi timasa le tinim naol kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakop ineep izi Isip irau ndaman saaŋgul liim ve ru, le ndaman toni irau tamoot liim, tamoot ru, ve liim ve ru (147). ");
INSERT INTO tuc_o_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Ghoro iyamaan tau ighaze sawa toni to mateeŋ inim igharau wa. Tovenen ipoi natu Yosep inim, ve isaav pani ighaze: “O natug, sawa to ighaze namaat, you naghaze namuul nala nagheen izi taan to tamaŋ ve nditimbug tigheen pani. Tovenen ighaze lolom payou, ghoro ughur nimam inim ŋgoig, ve umbua saveeŋ ariaŋa toman ghou tovene: Yom pale utavia ghou izi taan tonene maau. Pale ugham patug ila Kanaan, ve utavia ghou tonowe. Ighaze utaghon aliŋag tonene, nene pale ipatooŋ ghom ighaze lolom ineep tiou kat, ve ugham ŋgar poia payou itaghon saveeŋ mbuaaŋ tiom.” Yosep ipamuul aliŋa ighaze: “Tamaŋ, ugham ŋgar naol malep. You pale nataghon aliŋam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakop isaav pani muul ighaze: “Saveeŋ to yom umbua toman ghou ne, you naghaze upariaaŋa ila Maaron mata le iyaryaaŋ kat.” Tovenen Yosep ipariaaŋ saveeŋ mbuaaŋ toni tonowen. Ghoro Yakop ineep ila ina to ghenooŋ, ve itud, ve ipait Maaron toman lolo poia. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tinepneep ila, ve tipaes pa Yosep tighaze: “Tamam imorooŋ.” Tovenen Yosep igham ndinatu ru, Manase yesuru Epraim, ve yesŋa tila tighaze tighita tama Yakop. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tila peria, ve tamtoghon pida tipaes pa Yakop tighaze: “Olman, natum Yosep inim wa.” Olman Yakop ilooŋ saveeŋ tonene, ve ipariaaŋ tau, imundig mbole izi ina to ghenooŋ, ");
INSERT INTO tuc_o_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","ve isaav pa Yosep ighaze: “Ulooŋ. Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne, ivot tiou izi ndug Lus to ineep ila taan to Kanaan, ve ighur poia toni iza tiou, ve isaav payou ighaze: ‘You pale nagham papaghu tiom timasa tinim ival, ve rumai katindi tivot ilat tiom. Ve you pale nagham taan tonene inim ledi. Leso tineep pani itaghoni taghoni gha ila.’” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakop iseeŋ saveeŋ toni ighaze: “Ndinatum ru, Manase ve Epraim, you nanim taan to Isip sone, ve yamru azuwam apoop di izi sualen. You naghaze nagham di tinim leg ve tiyoon pa mbeb tiou raraate inimale Ruben ve Simeon to taug ndinatug kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ve ighaze apoop muul, nene pale tinim yom taum lem, ve tineep ila nditoghadi ru Epraim ve Manase sambadi, ve tigham mbeb ila todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Sawa to napul taan to Mesopotamia, ve namuul nanim Kanaan le nagharau ndug Eprata, tinam Rael imaat izi ataam luvuŋa, ve natavia tonowe.” (Ndug Eprata, iza ite Betelem.) ");
INSERT INTO tuc_o_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakop isavia saveeŋ tonene le isob, ghoro mata ila le ikus Yosep ndinatu ru. Tovenen ighasoni ighaze: “Sei masin tonanan?” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","10","Yosep ipamuul aliŋa ighaze: “Nene ndinatug ru to Maaron igham di payou izi sualen.” Yakop ighilaal di maau pasa, ye inim olman waat, ve mata irau ighita ndug muul maau. Ghoro Yakop isaav pa Yosep muul ighaze: “Ugham yesuru tinim tigharau ghou. Leso naghur poia to Maaron iza todi.” Tovenen Yosep igham ndinatu ru tila tigharau timbudi Yakop, ve ye isavag di. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ghoro isaav pa Yosep ighaze: “Muuŋ, naghaze pa naghita ghom muul maau. Eemoghon Maaron igham poian ghou, tauto aazne naghita ghom, ve naghita ndinatum paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ghoro Yosep igham ndinatu ru tila saguan ris pa tama, ve ana iput aghe pa tama, ve ighur nagho izila taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Igham tovene le isob, ghoro imundig iyoon, ve nima ŋas ikis natu aidaba Manase, ve ighuri ineep ila pa tama nima waan, ve nima waan ikis natu Epraim, ve ighuri ineep ila pa tama nima ŋas. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Eemoghon Yakop iparabolin nima, le nima waan izala ŋgeu muria daba, ve nima ŋas izala ŋgeu olman daba. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ghoro ighur poia to Maaron iza to Yosep toman ndinatu ighaze: “O Maaron, yom Maaron to timbug Abaram yesuru tamaŋ Isak. Nepooŋ toman laghooŋ todi, yesuru matadi iŋgalŋgal ghom ve titaghon ataam tiom. Sawa to tinaŋ ipoop ghou, ve inim imuul aazne, yom uŋgin ghou, ve matam payou. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ve uvot tiou inimale aŋela, ve ugham mulin ghou pa pataŋani tiou to naol ne. Aazne, suŋuuŋ tiou iŋarua ghom naghaze ughur poia tiom iza to ndipain ru tonene. Leso papaghu todi timasa tinim naol izi taan, ve yeru tamaŋ Isak ve timbug Abaram izamai iseeŋga itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosep ighita tama ighur nima waan izala natu muria Epraim daba, le irau lolo maau. Tovenen iit tama nima waan pa natu muria, ve ighaze ighuri ila natu olman Manase daba. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ve isaav pa tama ighaze: “Tamaŋ, ugham vene malep. Nimam waan ila ŋgeu olman daba, ghoro poia.” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Eemoghon Yakop ilooŋ Yosep aliŋa maau. Isaav pani ighaze: “Natug, ŋgar to you naghami ne, nakankaan pani maau. You nawatagi. Natum Manase, papaghu toni pale timasa tinim naol, ve iza inim tiina paam. Eemoghon tazi iza pale ilib pani. Pasa, papaghu toni pale timasa tinim ival tiina kat, ve rumai katindi tivot ila toni.” ");
INSERT INTO tuc_o_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tovenen sawa tonenen, Yakop ighur poia to Maaron iza to Yosep ndinatu ru, ve isaav padi ighaze: “Muri, ighaze yes Israela tighur poia to Maaron iza to tamtoghon, nene pale tiwaat izamim tighaze: ‘Maaron pale ighur poia toni iza tiam inimale igham pa Epraim yesuru Manase.’” Tovenen ye iit Epraim iza le ilib pa togha Manase. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yakop ighur poia to Maaron iza to yesuru le isob, ghoro isaav pa Yosep muul ighaze: “Ulooŋ. Sawa tiou to mateeŋ inim igharau wa. Eemoghon Maaron pale ineep toman gham. Ve muri, ye pale igham gham amuul ala pa taan to nditimbumim ve nditamamim. ");
INSERT INTO tuc_o_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ve ulooŋ. Muuŋ, you nagham pane toman buza tiou, ve yeiŋa yes Amora niparab le nalib padi. Tauto nagham ndug mbuŋa Sekem inim leg. You naghaze nait izam ilib pa nditogham izadi. Tovenen aazne, you napul taan tonowen inim lem. Ve taan pida, pale napuli ila pa nditogham.” ");
INSERT INTO tuc_o_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakop isavsaav toman Yosep le isob, ghoro ipoi ndinatu pida tinim, ve isaav padi ighaze: “Anim agharau ghou. Leso navotia mbeb to muri pale ivot payam. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yam Yakop ndinatu, tamamim Israel to you. Anim alup gham ila matag, ve alooŋ saveeŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, yom natug aidaba. Sawa to paghug ve tapirig inepneep, you napoop ghom muuŋ. Tauto tapirig iza tiom, ve izam ve tapirim ilib pa nditazim. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Eemoghon yom irau uŋgin taum maau. Yom unumale yawaaŋa to ivot toman tapiri tiina. Yom uroron pa tamam maau, ve upamayaŋin ghou. Pasa, uzala inag to ghenooŋ, ve umogheer pa azuwag. Tovenen izam irau imuuŋ pa nditazim muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon yesuru tazi Levi, ŋgar todi raraate. Yesuru ndiran to mbutuuŋ sorokin tamtoghon pa buza todi. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tovenen lolog pa ŋgar todi maau, ve lolog pa lupuuŋ toman di maau. Pasa, yesuru atedi tuku, ve tirabrab sorokin tamtoghon timatmaat. Ve ŋgai paam, tiwaghamun di sorok. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maaron tau pale ighur pataŋani iŋarua di. Pasa, malmaliiŋ todi, tiina kat. Irau lolodi isamin tamtoghon rita maau. Tovenen you pale nareu di toman papaghu todi le timbiriis tila tineep ila toŋvetaz todi lolodi. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, nditogham ve nditazim pale tipait izam. Pasa, yom pale ukis koiamŋa luadi. Tovenen nditogham ve nditazim pale tiput aghedi payom, ve tipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, yom unumale laion paghu to tapiri tiina ve tamtoghon timatughez pani. Yom unum laion to ighan ŋgai sagsag pida le isob, ve izi igheen. Sei irau imatughez maau ve imogheer pani? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda toman papaghu toni pale tikis titi to kinik, ve tighamgham pooz ila le irau titi tonowen tamtoghona kat inim ivot. Ghoro ye tau ikisi, ve ndug ndug tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","12","Yuda papaghu toni pale tineep pooi izi taan todi, ve tirau aniiŋ ve vaen, ve titub le naghodi popoia. Irau timbool pa mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun papaghu toni pale tineep tigharau te, ve ledi soso poia pa waaŋ tilooŋ tila. Taan todi pale ila imuul izi ndug Sidon. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isakar papaghu toni pale tinim esele to bide tapiri. Eemoghon ye igheen sorok ila bodbodaaŋ to nakaral to aniiŋ ineep ila. Pale tighita tighaze taan todi, nene poia pa tineep pani ve tigham uraat. Tovenen yes pale tigham uraat tiina. Ve tamtoghon todi pida pale tinim mbesooŋa sorok, ve tigham uraat pataŋani. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","17","Dan papaghu toni pale tinim rumai kainaŋen eez to yes Israela, ve tigham uraat pa gharatooŋ pataŋani to tamtoghon. Yes ival maau. Eemoghon pale tiwaghamun koiadi tinimale moot samia to ineep ataam dige ve isasaŋan. Ighaze tamtoghon eta ilaan toman hos toni inim, nene pale rikia moghon iŋaaŋ hos aghe, ve ŋgeu to ineep izala hos pogho, itap izi taan. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Yoova, you nasaŋan ghom pa ugham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gat papaghu toni koiadi pale tinim pa tireu di. Eemoghon yes pale tiparab ariaŋa, ve tinaan di tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Taan to Aser pale ŋgoreeŋa tiina, ve aniiŋ popoia naol to kinik lolodi pani, titub ila. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali, papaghu tiom pale tinim mekmek sagsag to tilaghlaagh sorok titaghon taudi lolodi, ve tipopoop ndinatudi to paghunadi kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosep papaghu toni pale tinimale ai vaen to iyoon igharau ya, ve boga titub tila saguan le tilib pa sirsiir, ve ighur anoŋa popoia katindi tivot. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yosep koia tipamundigin malmal pani, ve tinaana tighaze tivanegi imaat. Eemoghon tiraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pasa, Maaron ariaŋa to Yakop, ye ŋginiiŋ to yes Israela, ve inim inadi ariaŋa to yoŋgaaŋ. Tauto Yosep nima tuŋia pa pane toni, ve ivaneg rikrikia. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yosep, Maaron to tamam pale iuul ghom. Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne, pale ighur poia toni iza tiom toman papaghu tiom, ve igham uman to sambam izi payam, ve igham ya to taan lolo iza payam paam. Ve ighur poia toni iza to ndiliva tiam, leso tipoop ndinatumim katindi. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yom tamam you. Poia to Maaron ighuri iza tiou, nene tiina kat. Itatab lolooz tintina to tiyondyood irau sawa isob. Ilib pa poia toni to muuŋ iza to nditimbug. Poia tovene pale iza to Yosep toman papaghu toni, ve ipambood di inimale moghar to ineep izala dabadi. Pasa, ye inim daba pa nditogha. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin, ye inimale ŋgavuun sagsag to pitoola ve ilaghlaagh. Mboŋmaagh to naol ne, ighanghan mbeb to ye irabrab di. Ve rabrab to naol, ivavalag mbeb to ye igham di, ve ireirei di pa ndita.” ");
INSERT INTO tuc_o_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nenen yes Israela rumai todi saaŋgul ve ru. Sawa to tamandi Yakop ighaze imaat, ye ighur poia to Maaron iza todi. Ve saveeŋ to ye isavia pa ndinatu, nene: deŋia pa yes eŋaeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Yakop ighur poia to Maaron iza to ndinatu le isob, ghoro avo iyaryaaŋ padi ighaze: “You naghaze napul gham tonene, ve nala naneep toman siŋ tiou pida to timaat wa. Sawa to namaat, yam agham ghou nala, ve aghur ghou nalooŋ nala yaam saambu to ineep izi taan Makpela. Leso nagheen toman tamaŋ ve timbug. Yaam saambu tonowen, muuŋ timbug Abaram igholi ila to Epron, ye Hit taamdi. Ineep igharau ndug Mamre to Kanaan we. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Pasa, yaam saambu tonowen, to tighur Abaram yesuru azuwa Sara, ve Isak yesuru azuwa Rebeka tilooŋ tila. Ve you naghur azuwag Lea ana ilooŋ ila paam. ");
INSERT INTO tuc_o_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tovenen yaam saambu to Abaram igholi ila to yes Hita, you naghaze aghur ghou nalooŋ nala nagheen tonowe paam.” ");
INSERT INTO tuc_o_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Olman Yakop ighur saveeŋ izi to ndinatu le isob, ghoro iyoot aghe izala ina to ghenooŋ, iyavan, ve imaat. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosep ighita tama Yakop imaat, ve itap izala pogho, isavagi, ve itaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Itaŋ le isob, ghoro isaav pa yes mbesooŋa toni to tighamgham uraat pa yes mateeŋa patudi, ve tigharaat tama paatu. Leso isami rikia sob, ve ineep mala. Tovenen yes tila ve tigham uraat pa Yakop paatu itaghon gabuadi, le irau mboŋ tamoot ru (40). Pasa, uraat tonowen ikis di sawa mala tovene. Yes Isipa paam titaŋ pa olman Yakop, ve tineep ila moŋiiŋ le irau mboŋ tamoot tol saaŋgul (70). ");
INSERT INTO tuc_o_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tinepneep le sawa to moŋiiŋ isob, ghoro Yosep isaav pa yes uraata to tiŋgin kinik ruum toni: “Ighaze lolomim payou, ghoro agham naghog, ve ala asavia aliŋag pa kinik tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Sawa to tamaŋ ineep mata iyaryaar, ye isaav payou ve nambua saveeŋ ariaŋa tomani ila Maaron mata tovene: Sawa to ye imaat, you pale nagham paatu ila taan Kanaan, ve naghuri ilooŋ ila yaam saambu to ye tau igharaata tonowe. Tovenen naghaze naghason kinik. Irau iyok payou, ve nala natavia tamaŋ paatu tonowe? Natavia le isob, ghoro namuul nanim.” ");
INSERT INTO tuc_o_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kinik ilooŋ ghasoniiŋ toni, ve iyok pani ighaze: “Poia. Ula utavia tamam izi taan Kanaan itaghon saveeŋ mbuaaŋ tiom to ugham pani.” ");
INSERT INTO tuc_o_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Tovenen Yosep yesŋa nditogha, tazi, ve tamtoghon todi pida timundig, ve tigham tamandi Yakop paatu tighaze tila titavia izi taan Kanaan. Yes uraata to kinik to tiŋgin ruum toni, yesŋa daba to Isip tisob timundig toman di, ve yesŋa tila. Pida tiza hos, pida tiza karis, ve pida tilaagh taan. Tovenen yes to tilaagh toman Yosep, yes ival kat. Eemoghon Yosep yesŋa nditogha ve tazi tipul ndizwadi toman ndinatudi ve ŋgai todi tizi tineep izi taan Gosen. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tilaagh tila le tivot ndug to losiiŋ wit to ineep igharau ndug Atat izi ya Yordan paŋa ite. Ghoro tipamundigin taŋiiz muul pa Yakop ve titaŋtaŋ tovene le irau mboŋ liim ve ru. Titaŋ tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tovenen yes Kanaana to tineep ndug tonowen tilooŋ taŋiiz todi, ve tighaze: “Wai, nowe yes Isipa lolodi isami tiina kat, tauto titaŋtaŋ we.” Pughu tonene to tiwaat ndug tonowen iza ‘Abel Mizraim.’ Ndug tonowen ineep ila ya Yordan paŋa ite. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Tovenen Yakop ndinatu titaghon aliŋa, ve tigham tamandi paatu ila taan Kanaan, ve tighuri ilooŋ ila yaam saambu to ineep izi taan Makpela. Taan to yaam saambu tonowen ineep ila, muuŋ Abaram igholi ila to Epron, ye Hit taamdi. Leso titavia mateeŋa todi tonowe. Yaam saambu tonowen ineep igharau ndug Mamre. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tighur Yakop paatu ilooŋ ila yaam saambu tonenen le isob, ghoro Yosep yesŋa nditogha, tazi, ve yes ival to tilaagh toman di, timuul tizila pa Isip. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yakop imaat, ghoro matughezaaŋ igham Yosep nditogha ve tighaze: “Aiss, tamaan imaat wa. Ighaze Yosep mata iŋgal ŋgar samia to muuŋ tagham pani ve ighaze iyati, sa pale ivot pait? Pale tagham vena?” ");
INSERT INTO tuc_o_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tovenen aliŋadi ila pa Yosep tighaze: “Tamaan imaat sone, ve ighur saveeŋ izi tiei tovene: ");
INSERT INTO tuc_o_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yam ala ve asavia aliŋag pa natug Yosep tovene: Yom irau lolom isamin nditogham, ve upul sosor todi, ve lolom imaagh pa ŋgar samia to tigham payom.’ Tamaan isaav tovene, tauto yei mbesooŋa to Maaron to tamaan imbesmbees pani, nitaŋ roran ghom nighaze: Lolom isamin ghei, ve upul sosor tiei.” Yosep ilooŋ saveeŋ todi, ve itaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ghoro nditogha taudi tila tivot toni, ve titap tizi ila mata, ve tisaav pani tighaze: “Ulooŋ. Yei tonene pale nisob ninim mbesooŋa payom.” ");
INSERT INTO tuc_o_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Eemoghon Yosep isaav padi ighaze: “Yam amatughez malep. You Maaron, leso naghur atia payam? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Muuŋ, yam aghaze awaghamun ghou. Eemoghon ŋgar tiam samia tonanan, Maaron itoora inim mbeb poia. Nene ataam to ye iuul tamtoghon katindi. Tauto timaat maau, ve aazne tineep matadi iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tovenen yam amatughez malep. You taug pale naŋgin gham, toman ndizwamim ve ndinatumim, ve nauul gham pa amim aniiŋ ve sa mbeb to ambool pani.” Yosep isavia saveeŋ luuma tonene pa nditogha, tauto irab atedi, ve lolodi poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosep toman nditogha ve tazi tinepneep izi Isip, le Yosep ndaman toni irau tamoot liim ve saaŋgul (110). ");
INSERT INTO tuc_o_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ye ighita nditimbu ve saas to Epraim, ve ighita Manase natu Makir ndinatu paam, ve igham payamyam padi inimale tau toni. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosep iyamaan tau ighaze sawa toni to mateeŋ igharau, ve isaav pa nditogha ve tazi ighaze: “Sawa tiou to mateeŋ igharau wa. Eemoghon Maaron tau pale mata payam, ve iŋgin gham aneep pooi. Ve muri, ye pale igham gham apul ndug tonene, ve amuul ala aneep izi taan Kanaan itaghon saveeŋ ariaŋa to ye imbua toman Abaram, Isak, ve Yakop.” ");
INSERT INTO tuc_o_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ghoro isaav ariaŋa padi ighaze: “Maaron pale mata payam ve iuul gham, leso apul ndug tonene, ve amuul ala pa taan Kanaan. Sawa tonenen ighaze ivot, ghoro agham tuag ve alaagh tomani.” Yes tilooŋ saveeŋ toni tonene, ve timbua saveeŋ tomani tighaze pale titaghon aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tovenen Yosep ndaman toni irau tamoot liim ve saaŋgul (110), ghoro imaat. Yes Isipa tigharaat paatu leso imbuuz sob, ve tizeeva ila ndawawa lolo to Isip we. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Yes Israela to yesŋa tamandi Yakop, ve ndizwadi ve ndinatudi tizila pa Isip ne izadi tovene: Ruben, Simeon, Levi, Yuda, Isakar, Zebulun, Benyamin, Dan, Naptali, Gat ve Aser. Yakop iza ite Israel. Papaghu toni to yesŋa tizila Isip, yes irau tamoot tol saaŋgul (70). Ve natu Yosep, ye imuuŋ ila ineep pataghaaŋ wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosep imaat, ve tazi toman nditogha ve tamtoghon todi pida to yesŋa tizila Isip pa sawa tonenen, tineep tonowe le tisob timatmaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Eemoghon yes Israela tipopoop, ve papaghu todi timasa le tinim ival kat ve taan to yes Isipa ivon padi. Tovenen tapiridi ighaze ilib padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yes Israela tineep tonowe irau ndaman ndaman, ghoro kinik paghu eez ivot ve igham pooz izi Isip. Kinik paghu tonowen, ye iwatag Yosep uraat toni rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Tovenen isaav pa yes Isipa ighaze: “O, aghita ghiit wa? Aazne, yes Israela timasa tinim naol ve paam tapiridi ilib pait. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tovenen iit irau tagham ŋgar pooi, ve takaal ataam eta pa tatatan tapiridi. Pa vene, tivot tinim ival kat ve tilib pait. Ve ighaze malmal eta imundig, nene pale tila toman koiaad, ve tiparab toman ghiit ve tilib pait, ghoro tipul taan toit ve tighau tila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tovenen yes Isipa tigham yes Israela tinim mbesooŋa sorok padi, ve tighur ŋginiiŋa ariaŋadi pa tiŋgin di. Yes ŋginiiŋa tonowen tighur uraat pataŋani kat padi, leso titatan di. Tigham di tipamundigin ndug papaghu ru, leso tilup aniiŋ toman mbeb pida to kinik tila tonowe. Ndug eez, iza Pitom, ve ite iza Ramses. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yes Isipa tigham samin yes Israela ve tighur uraat pataŋani naol padi. Leso titatan di ve tapiridi isob. Eemoghon tiraua maau. Yes Israela tivotvot tinim naol le naol kat, ve tila tineep irau taan isob to yes Isipa. Tovenen yes Isipa timatughez padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tauto tiŋgal matadi pa uraat pida paam to pataŋani le pataŋani kat. Lolodi isamin di rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tigham le yes Israela nepooŋadi isami kat. Pasa, tighurghur uraat pataŋani kat padi. Tigham di tigharaat brik ve tirei ruum, ve tigham uraat ariaŋa pa uum paam. Ve sawa isob to yes Israela tighamgham uraat, yes Isipa lolodi isamin di rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","16","Ghoro kinik to Isip ipoi Hibru tidi ru tinim. Eez iza Sipra, ve ite iza Pua. Yesuru uraat todi to tipapopan ndiliva to yes Hibrua. Kinik isaav padi ighaze: “Alooŋ. Sawa to apapopan Hibru tidi, aghita ndinatudi. Ighaze nditamoot, arab di timaat. Ve ighaze ndiliva, ghoro apul di tineep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Eemoghon ndiliva ru tonowen timatughez pa Maaron. Tovenen titaghon kinik aliŋa maau, ve tipul ndipain nditamoot tineep. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tovenen kinik ipoi yesuru timuul tinim, ve ighason di ighaze: “Pughu vena to yamru azoor aliŋag, ve apulpul ndipain nditamoot to yes Hibrua tineep?” ");
INSERT INTO tuc_o_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Yesuru tipamuul aliŋa tighaze: “Wai, Hibru tidi, popaaŋ todi, inimale Isip tidi maau. Pasa, yes ndiliva ariaŋadi, ve tipopoop rikia moghon. Sawa to yeru nilaghlaagh sone, yes tipoop wa!” ");
INSERT INTO tuc_o_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ndiliva ru tonenen timatughez pa Maaron ve titaghon ŋgar toni. Tovenen ye igham poian di, le anadi tipoop ledi ndinatudi paam. Ve yes Israela tivotvot le tinim ival le ival kat. Ve tapiridi paam ivot inim tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tovenen kinik isaav ariaŋa pa ival tiina to Isip ighaze: “Ndipain nditamoot to Hibru tidi tipoop di, yam apiyaav di tisob tila ya Nil. Ve ighaze ndiliva, ghoro apul di tineep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Sawa tonenen, tamoot eez ve liva eez to Israel, yesuru tivai. Pughudi ee moghon. Yesuru tivot ila to Levi. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Liva apo, ve ipoop tamoot. Ye ighita natu poia kat. Tovenen iŋgooza ineep irau kaiyo tol le inim olman ris. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ghoro irau iŋgooza muul maau. Tovenen igham ti to tivavaii pa mbeb inimale vivib, ve iŋgal mbeb inimale ndimir ma bagil ila ipoon ti tonowen sambudi, leso ya ilooŋ ila sob. Ghoro ipagheen natu ilooŋ ila, ve ighami ila ighuri ila vivib lolo to titub titaghon ya Nil dige. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Pain tonowen livu iyooŋ saguan, ve mata ilala pani ighaze ighita sa mbeb pale ivot pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Sawa tonenen kat, kinik to Isip natu liva toman ndiliva mbesooŋa toni pida, tizila pa ya Nil, leso kinik natu liva iririu. Tovenen ndiliva mbesooŋa toni tilaghlaagh taghon ya dige, ve ye iriririu. Mata ila le ighita ti tonowen ipotpot ila vivib lolo. Tovenen imbaaŋ liva mbesooŋa toni eez ila ighami inim. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kinik natu liva ikaak ti avo, ve ighita pain kainaŋen ighengheen ve itaŋtaŋ. Tovenen lolo isamini, ve isaav ighaze: “Alei, nene avaat Hibru tidi eta natu!” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Rikia moghon ve pain kainaŋen livu inim peria todi, ve ighason kinik natu liva ighaze: “Vena? Irau nala nakaal liva eta to yes Hibrua, ve naghami inim? Leso iŋgin pain tonanan payom, ve igham payamyam pani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kinik natu liva iyok pa ŋgar toni ighaze: “Poia kat. Ula.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Tovenen ye ila igham pain tiina ve yesuru timuul tila to kinik natu liva. Ghoro kinik natu liva isaav pa pain kainaŋen tiina ighaze: “Ugham pain tonene ula, ve uŋgini payou ve ugham payamyam pani. Pale nagharaat ghom.” Tovenen pain kainaŋen tau tiina ighami ila, ve igham payamyam pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Pain tonowen itub le inim olman ris, ghoro tiina ighuri imuul ila to kinik natu liva, ve ighami inim natu. Kinik natu liva iwaat pain tonenen iza Mose. Pasa, mata iŋgal ighaze: “Pain tonene ineep ya dige, ve naghami iza.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose itub inim olman, ve sawa eez, ye ila ighaze ighita ndita Hibrua. Ila ivot todi ve ighita uraat pataŋani to tighamghami. Ve ighita ŋgeu eez to Isip irab toŋvetaz toni eez to Hibru. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose mata ines, le ighita tamtoghon eta maau. Tovenen ila ivool to ita ite, ve irab Isip taamdi tonowen imaat. Ghoro italaaz magargaar ve izeev paatu ila ve ilalai, leso iŋgooza. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mboŋ ndugizau, ve ila ighaze iŋgig ndita tonowen muul. Ilaghlaagh ila le ighita Hibrua ru tipaparab. Tovenen ighason ŋgeu to igham sosor ve ipamundigin malmal ighaze: “Wai, urab sorokin itam ite pasa?” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ye ipamuul aliŋa ighaze: “Yom sei ighur ghom unum tiina pa uŋgin ghei ve ugharaat pataŋani tiei? Ma vena? Yom ughaze urab ghou namaat nanimale Isip taamdi to noor urabi imaat ne?” Mose ilooŋ saveeŋ tonene, ve mata iŋgal ighaze: “Wai, ŋgar to you naghami, tamtoghon avaat tiwatagi wa.” Tovenen imatughez ve ighau. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Sawa to kinik to Isip ilooŋ Mose varu pa ŋgar to ighami, ikaala ighaze irabi imaat. Eemoghon Mose ighau ila pa yes Midiana taan todi wa. Ila ivot tonowe, ve ate izi igharau ya taiŋ eez dige. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ndug tonowen, ŋgeu eez inepneep, iza Reguel. Reguel iza ite Yetro. Ye ighamgham uraat pa watooŋrau to yes Midiana, ve ndinatu liva irau liim ve ru. Sawa to Mose ineep igharau ya tonowen dige, Reguel ndinatu liva tinim tighaze titib ya ve tipaghun sipsip ve mekmek todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mala maau ve ŋginiiŋ ŋgaia pida tinim tivot, ve tighaze tizurun ndiliva tonowen tighau. Eemoghon Mose imundig ivool todi, ve ipaghun sipsip toman mekmek todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ghoro ndiliva tonowen timuul tila pa tamandi Reguel. Ye ighita di, ve ighason di ighaze: “Wai, pughu vena to ŋgaramus ala ve rikia moghon amuul anim?” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Yes tipamuul aliŋa tighaze: “Yei nila nivot izi ya, ve ŋginiiŋ ŋgaia pida tinim tighaze tizurun ghei. Eemoghon ŋgeu eez to Isip ivool tiei, ve iuul ghei pa tibuuŋ ya, ve ipaghun sipsip ve mekmek toit paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tamandi ilooŋ saveeŋ todi, ve ighason di ighaze: “Wai, tau sine? Pughu vena to apuli ineep? Aghami ve yamŋa anim maau? Rikia moghon amuul ala, ve aghami inim. Leso itiŋa taghan.” Tovenen tila tigham Mose, ve yesŋa timuul tinim. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Reguel ighaze Mose ineep toman di. Tovenen Mose iyok pa ŋgar toni, ve Reguel igham natu liva eez pa Mose ve ivaii. Iza Sipora. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Yesuru tineep le Sipora apo, ve ipoop natu tamoot. Mose iwaat iza Gersom. Pasa, mata iŋgal ighaze: “Muuŋ, naneep nanim loom tonowe.” ");
INSERT INTO tuc_o_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ndaman katindi inim ila, ghoro kinik to yes Isipa imaat. Eemoghon yes Isipa tighamgham samin yes Israela, ve tighurghur uraat pataŋani padi sone. Tigham le matadi siŋi iyaat. Tovenen yes Israela titaŋtaŋ ve tikausim pa ledi ulaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Maaron ilooŋ taŋiiz todi, ve mata iŋgal imuul ila pa saveeŋ to muuŋ ye imbua toman nditimbudi Abaram, Isak ve Yakop. ");
INSERT INTO tuc_o_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ye ighita yes Israela tineep ila pataŋani tiina lolo. Tovenen igham ŋgar tiina padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose iŋginŋgin sipsip ve mekmek to rawa Yetro. Yetro, ye ŋgeu to ighamgham uraat pa watooŋrau to yes Midiana. Sawa eez, Mose igham sipsip ve mekmek to Yetro, ve ila pa ndug balim. Ipul ndug to moghon moghon ilaghlaagh pani, ve isakia laghooŋ ila ivot lolooz Orep pughu. Lolooz tonowen, nene lolooz patabuaŋ to Maaron. Iza ite Sinai. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mose inepneep tonowe, ve Mbaŋooŋa to Yoova ivot toni inimale yab ighan ila ai kainaŋen eez. Mose ighita yab tonowen iyaryaar kat, eemoghon ighan ai maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tovenen igham ŋgar naol ighaze: “Wai, nowe sa? Mbeb tonowen, ghitooŋa ite kat. Pughu vena to yab iyaryaar ila ai tonowen, eemoghon ighani maau? You pale nala nagharaui, ve naghita poiani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tovenen Mose ilaagh iŋarua ai tonowen ila ighaze ighita poiani. Eemoghon Yoova ineep ila ai tonowen, ve ighita Mose inim, ve ipoii ighaze: “Mose, Mose!” Mose iyok pa aliŋa ighaze: “Taug nene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yoova isaav ila pani ighaze: “Unum ugharau malep! Uyoon tonanan, ve upas duduuŋa to aghem izi. Pasa, taan to yom uyondyood izala na, nanan patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","You Maaron to tamam. Ve you Maaron to Abaram, Isak, ve Yakop.” Mose ilooŋ saveeŋ tonene, ve rikia moghon imbotoon nagho. Pasa, imatughez pa ighita Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yoova isaav pani muul ighaze: “Tamtoghon tiou to tineep izi Isip we, you naghita pataŋani todi wa. Yes daba to tiŋgin di pa uraat, tighamgham samin di, le matadi siŋi iyaat ve titaŋ tiina. Eemoghon taŋiiz todi, you nalooŋa wa. Tovenen pataŋani todi, you nakankaan pani maau. Nawatagi le isob. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","“Tauto aazne, nazi nanim naghaze nagham mulin di ila yes Isipa nimadi. You pale nagham di tipul Isip, ve tila tineep izi taan to yes Kanaana, Hita, Amora, Peresa, Hivia, ve Yebusa. Pasa, taan tonowen soso tiina, ve ŋgoreeŋa tiina kat. Ve igham mbeb naol titub pooi. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Tovenen taŋiiz to yes Israela inim ivot tiou ve nalooŋa wa. Ve pataŋani to yes Isipa tighurghuri padi pa titatan di, you naghita wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tovenen aazne, you naghaze nambaaŋ ghom umuul ula pa Isip ve ughita kinik todi, leso ugham tamtoghon tiou Israela tipul taan Isip ve tinim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Eemoghon Mose isaav pa Maaron ighaze: “Wai! You sa ŋgeu, to irau nala nayoon ila kinik mata, ve nagham yes Israela tipul Isip? You irau nagham uraat tovene maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Maaron isaav pani muul ighaze: “You taug pale naneep toman ghom ve napalot ghom. Tovenen yom pale ugham tamtoghon tiou Israel tipul Isip, ve yamŋa anim avot sualen, ve asuŋ ve ambees payou izi lolooz tonene pughu. Sawa to mbeb tonenen ivot, ghoro uwatag ughaze you taug to nambaaŋ ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose ipamuul Maaron aliŋa ighaze: “Nene poia. Ve ighaze namuul nala, ve nasaav pa yes Israela naghaze: ‘Maaron to nditimbuud, to imbaaŋ ghou nanim tiam,’ yes pale tighason ghou tighaze: ‘Sa Maaron tonanan. Iza sei?’ Pale napamuul ghasoniiŋ todi vena?” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Maaron isaav pani ighaze: “You Taug Nanepneep. Nene you izag ve gabuag. Tovenen usaav pa yes Israela ughaze: ‘YE TO INEPNEEP’ tauto imbaaŋ ghou nanim tiam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ve Maaron isaav pa Mose muul ighaze: “Usaav pa yes Israela tovene: ‘Yoova, Maaron to nditimbuud Abaram, Isak, ve Yakop, to imbaaŋ ghou nanim tiam. Ye iza “YOU TAUG NANEPNEEP.” ’ Izag tonene pale ineep le alok. Tovenen tamtoghon to muri pale tivot, irau matadi iŋgal izag tonene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tovenen yom ula ulup ndolman to yes Israela, ve usaav padi tovene: ‘Yoova, Maaron to nditimbuud Abaram, Isak, ve Yakop timbesmbees pani, tauto ivot tiou, ve aliŋa ilat payam ighaze: Mata payam irau sawa isob. Tovenen ŋgar samsamia naol to yes Isipa tighamgham di payam, ye ighita di wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ve ye isaav tovene: Taan Isip to aazne andeeŋ pataŋani tiina pani, ye pale igham gham apuli, ve ala aneep izi taan to yes Kanaana, Hita, Amora, Peresa, Hivia, ve Yebusa. Taan tonowen ŋgoreeŋa tiina, ve igham mbeb naol titub pooi.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Tovenen yom ula usavia aliŋag tonene pa ndolman to yes Israela. Yes pale tilooŋ ghom. Ghoro ugham di ve yamŋa ala avot to kinik to yes Isipa, ve asaav pani aghaze: ‘Yoova, Maaron to yei Hibrua, ivot tiei wa. Tovenen nighaze uyok payei leso nila ndug balim, ve nigham watooŋrau pani izi tonowe. Pale nilaagh irau mboŋ tol, ghoro nila nivot.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Eemoghon you nawatag: Kinik to Isipa, ye irau iyok payam sorok maau. You irau napatooŋ tapirig pani le isob, ghoro iyok payam. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tovenen you pale napatooŋ tapirig pa yes Isipa, ve nagham mbeb gharatooŋadi tintina to ite kat tivot ila lolodi. Leso natatan tapiridi, ve kinik todi ipul gham ala. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Sawa to yam apamundigin laghooŋ, you pale nagham yes Isipa lolodi payam, ve tirei lemim mbeb pida. Leso ala toman nimamim ŋginiŋa sob. ");
INSERT INTO tuc_o_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tovenen ndiliva tiam irau tisob tila ve tighason yes Isip tidi to tineep toman di ne, pa tigham ledi nonogiiŋa popoiadi toman mbaliiŋ todi pida to tigharaat di pa gol ve silva. Yes pale tigham payam. Mbeb todi tonowen pale tisob tinim ndinatumim ledi pa tindud di pani. Tovenen yam pale ayou mbeb todi le isob, ghoro amundig ala.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Yoova isavsaav le isob, ve Mose isaav pani ighaze: “Poia. Eemoghon ighaze yes Israela tighur ila saveeŋ tiou maau, ve tilooŋ ghou maau, ve tisaav payou tighaze: ‘Waa, Yoova ivot tiom onoon, ma ugham kaarom?’ Nene pale nasaav padi vena?” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tovenen Yoova ighasoni ighaze: “Yom ukiskis sa tonanan?” Mose isaav pani ighaze: “Nene titi tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yoova isaav pani muul ighaze: “Upiyaava izi taan.” Tovenen Mose ipiyaav titi toni izi taan, le itoora inim moot. Mose ighita moot tonowen, le ruŋa iza pani ve ighau ila saguan. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yoova isaav pani muul ighaze: “Nimam izi ukis uvu.” Sawa to Mose nima izi ikis moot uvu, nene itoora inim titi muul ila nima. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ghoro Yoova isaav pani ighaze: “Ulooŋ. Sawa to yom ula uvot to yes Israela, ugham tovene. Leso tighur ila tighaze you Yoova, Maaron to nditimbumim Abaram, Isak ve Yakop, to navot tiom, ve tilooŋ aliŋam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ve Yoova isaav pani muul ighaze: “Uzeev nimam ilooŋ ila nonogiiŋa tiom.” Mose igham tovene, ve sawa to ipas nima ivot, ighita kolekole igham nima, le isami ve ipisosooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yoova isaav pani muul ighaze: “Uzeev nimam imuul ilooŋ ila.” Tovenen Mose izeev nima ilooŋ ila nonogiiŋa toni muul. Ve sawa to ipasi ivot, ighita nima poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ghoro Yoova isaav pani tovene: “Ighaze yes Israela tighur ila saveeŋ tiom maau, ugham mbeb gharatooŋa ivot pa titi muuŋ, leso ipatooŋ ghom ighaze you naneep toman ghom. Ve ighaze tighur ila sone, upatooŋ mbeb ite tonanan padi, leso tighita ve tighur ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ve ighaze mbeb gharatooŋadi ru tonanan igham di tighur ila saveeŋ tiom maau, ghoro utib ya Nil rita, ve uliŋi izi taan mamaasa. Ya tonanan pale itoora inim siŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ghoro Mose isaav pa Yoova ighaze: “O Tiina, you tonene, ŋgeu to savsaveeŋ maau. Muuŋ ve inim, avog ipataŋan pa savsaveeŋ. Ve aazne paam, yom uvot tiou ve usavsaav toman ghou, eemoghon avog ipapataŋan sone.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tovenen Yoova isaav pani ighaze: “Sei ighur tamtoghon avodi? Ve sei igham tamtoghon taliŋadi ipam ve avodi ivool? Ve sei igham tamtoghon matadi iyaryaar ve tighita ndug, ve igham matadi ipis? You Yoova moghon. Ite paam maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tovenen aazne, umundig ve ula. You taug pale naneep toman ghom, ve napariaaŋ ghom pa savsaveeŋ, ve napatooŋ ghom pa sa saveeŋ to naghaze usavia.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Eemoghon Mose ipamuul Maaron aliŋa ighaze: “Aa Tiina tiou, you naraua maau. Umbaaŋ tamtoghon ite paam ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tovenen Yoova ate yabyab pa Mose, ve isaav pani ighaze: “Ve vena pa togham Aron? Ye siŋ to Levi paam. You nawatagi: Ye ŋgeu to savsaveeŋ. Ulooŋ. Ye ilaagh itaghon ataam inim ighaze ighita ghom. Sawa to inim peria ve ighita ghom, ye pale lolo poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tovenen sa saveeŋ to nasavia payom, yom irau usavia pani ve ilooŋa. Ghoro ana igham avom, ve ivotia aliŋam pa tamtoghon. You taug pale napariaaŋ gham pa savsaveeŋ, ve napatooŋ gham pa sa ŋgar to pale aghami. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tovenen Aron pale igham avom ve ivotia aliŋam pa ival tiina. Yamru pale ataghon ŋgar inimale you Maaron naghamgham pa yes propeta tiou. Pasa, yom pale usavia aliŋam ila toni, ghoro ana isavia ila pa ival tiina. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","“Ve matam iŋgal titi tiom paam. Ukisi ve ula. Pasa yom pale ugham mbeb gharatooŋadi pida tivot pani. Mbeb tonanan pale tinim ghilalooŋ payom tighaze you naneep toman ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose yesuru Yoova tisavsaav le isob, ghoro imuul ila to rawa Yetro, ve ighasoni ighaze: “Olman, naghaze namuul nala Isip ve naŋgig toŋvetaz tiou. Tisob tinepneep, ma pida timatmaat wa?” Rawa iyok pani ighaze: “Poia. Ula toman lolom poia.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Sawa to Mose ineep izi Midian, Yoova isaav pani ighaze: “Umuul ula pa Isip. Pasa, ndiran to muuŋ tighaze tirab ghom umaat, yes tisob timatmaat wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tovenen Mose igham azuwa toman ndinatu, ighur di tizala esele, ve ikis titi to Maaron, ve tipamundigin laghooŋ todi tighaze tizila pa Isip. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tilaghlaagh tila, ve Yoova isaav pani ighaze: “You naghur tapirig iza tiom, leso ugham mbeb gharatooŋadi naol naol. Sawa to yom ula uvot Isip, ugham mbeb gharatooŋadi tonanan tisob tivot ila kinik todi mata. Eemoghon you pale nagham ŋgar toni iyaryaaŋ kat. Leso ipul yam Israela ala rikia sob. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ghoro uvotia aliŋag pani ughaze: ‘Yoova isaav payom tovene: Tamtoghon to Israel, yes tinimale natug aidaba. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","You nasaav payom wa naghaze upul ndinatug tinim, leso timbees payou ve tisuŋ payou. Eemoghon yom uzoor aliŋag, ve uŋguruut di. Tovenen you pale narab natum aidaba imaat.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mose yesuru azuwa ve ndinatu tilaghlaagh tila le mboŋ izi, ghoro tineep izi ndug eez ve atedi izi. Sawa tonenen, Yoova ivot to Mose, ve ighaze irabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Eemoghon Mose azuwa Sipora rikia moghon igham gharghar ve ighorot natu waar toni uli, ve ighuri ila Mose aghe, ve isaav pani ighaze: “Yom azuwag kat. Pasa, siŋ izala poghom wa.” ");
INSERT INTO tuc_o_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Yoova ighita mbeb tonenen, tauto irab Mose imaat maau, ve ipuli ineep. Ghoro tipamundigin laghooŋ todi muul ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mose togha Aron inepneep izi Isip, ve Yoova ila ivot toni, ve isaav pani ighaze: “Umundig ula pa ndug balim, ghoro ughita tazim Mose tonowe.” Tovenen Aron imundig ila, ve ivot to Mose izi lolooz to Maaron pughu. Ye ighita tazi Mose, le lolo poia kat ve iyaŋin pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ghoro Mose ipaes pani pa saveeŋ isob to Yoova imbaaŋa pa ivotia. Ve ipaesia mbeb gharatooŋadi to Yoova isaav pani pa ighami ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","30","Ghoro yesuru tilaagh muul. Tila tila le tivot Isip, ghoro tipoi ndolman tisob to yes Israela tinim ve yesŋa tilup di, ve Aron ipaes padi pa saveeŋ isob to Yoova isavia pa Mose. Ve ipatooŋ mbeb gharatooŋadi pida tonenen paam ila ival tiina matadi ve tighita, leso tighur ila tighaze Yoova ineep toman di pa uraat todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tovenen ival tiina tighur ila saveeŋ todi. Sawa to ival tiina tilooŋ tighaze Yoova ighita pataŋani todi ve ighaze iuul di, yes tiput aghedi, ve tipait Maaron iza. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mose yesuru Aron tilup yes Israela le isob, ghoro tila tighita kinik to Isip, ve tisaav pani tighaze: “O kinik, ulooŋ. Yoova, ye Maaron to yei Israela, aliŋa ilat payom ighaze: Upul tamtoghon toni tila pa ndug balim. Leso tilup di tonowe, ve tigham suŋuuŋ tiina pani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Eemoghon kinik isaav padi ighaze: “Yoova, ye sei, to pale nalooŋ aliŋa ve napul yam Israela ala? You nawatag Yoova maau. Tovenen irau nalooŋ aliŋa, ve napul yam Israela ala ne maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tovenen yesuru tisaav pani muul tighaze: “Yoova, Maaron to yei Hibrua, ivot tiei wa. Tovenen nighaze upul ghei nila pa ndug balim. Leso nilup ghei pa suŋuuŋ tonowe, ve nigham watooŋrau pani. Pale nilaagh irau mboŋ tol, ghoro nila nivot. Ighaze nila toni maau, ye pale igham moroghooŋ samia eta ivot payei ve iwaghamun ghei, ma igham malmal ivot ve timbut ghei pa buza.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Eemoghon kinik ipamuul aliŋadi ighaze: “Pughu vena to yamru aghaze agham tamtoghon tipul uraat todi? Rikia moghon ve amuul ala pa uraat tiam! ");
INSERT INTO tuc_o_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Aazne, yam loomba sorok amasa anim ival kat. Tauto yamru aghaze agham nditamim tipul uraat todi ne?” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","7","Ndag ee moghon tonenen, kinik to Isip imundig ve isaav ariaŋa pa tau uraata toni pida to tighurghur uraat pa yes Israela, toman Israela pida to tiŋgin nditadi pa uraat, ighaze: “Alooŋ. Wit ve bali ayadi to Israela titoor taan tomani ve tigharaat brik pani, auul di pani muul malep. Aneep, ve taudi tila tikaala ve tighami. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Eemoghon uraat to aghuri padi, anduura izi malep. Ineep toman ina. Pasa, yes maatedi kat pa uraat. Tauto titaŋ roran ghou tighaze napul di tila leso tigham watooŋrau pa Maaron todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tovenen yam aghur uraat pataŋani kat padi. Leso tigham ŋgar pa saveeŋ kaarom muul sob.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kinik isavsaav toman di le isob, ghoro yes uraata toni tonowen yesŋa yes Israela to tiŋgin nditadi pa uraat, tila tivot to ival tiina to Israel, ve tipaes padi tighaze: “Kinik aliŋa ilat payam tovene: Ye irau iuul gham pa wit ve bali ayadi muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Aazne ve ila, ye ipul uraat tonenen ila yam taumim nimamim. Tovenen yam ala pa sa ndug to irau andeeŋ mbeb ayadi, ve ayou lemim. Eemoghon uraat to yei nighuri payam, nene irau ninduura izi maau. Brik piiz to yei nighur di payam pa agharaat di, yam irau apasob di raraate inimale muuŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tovenen yes Israela timbiriis tirau taan isob to Isip, ve tiyouyou wit ve bali ayadi to timbut motmotin di. Leso titoor taan tomani ve tigharaat brik pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Yes daba to tighurghur uraat padi, tipasul di tighaze: “Ai, yam awaghamgham kat pa uraat! Ndag to naol ne, brik piiz to yei nighur di payam pa agharaat di, yam irau apasob di inimale muuŋ, sawa to niuluul gham pa mbeb ayadi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ve yes daba tonowen tila to yes Israela to tiŋgin nditadi pa uraat, ve tilos di, ve tisaav padi tighaze: “Muuŋ, brik piiz to yei nighur di payam pa agharaat di, yam aghagharaat di rikia ve apasob di. Pughu vena to noor ve aazne, ninin brik tiam le imbool?” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Tovenen yes Israela to tiŋgin nditadi pa uraat, tila to kinik ve titaŋ rorani tighaze: “Tiina tiei, yei mbesooŋa tiom. Pughu vena to ugham ŋgar tonene payei? ");
INSERT INTO tuc_o_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Aazne, tilos katin ghei le tinimai isami. Pasa, tighaze yei nigham uraat iraua maau. Ve sei inim pughu pani? Nene yes uraata tiom. Pasa, yes tisaav pa yei mbesooŋa tiom tighaze nigharaat brik inimale muuŋ. Eemoghon tiuul ghei pa mbeb ayadi muul maau. Tauto nigharaat naol maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Kinik iyaan di ighaze: “Yam maatemim pa uraat! Arau uraat maau! Tauto anoknok saveeŋ payou aghaze napul gham ala, leso agham watooŋrau pa Maaron tiam Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Eemoghon pale maau. Rikia moghon amuul ala pa uraat tiam. Irau tiuul gham pa mbeb ayadi muul maau! Ve brik piiz to tisaav payam pa agharaat di, yam irau apasob di.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Yes tilooŋ saveeŋ tonene, ve tighilaal tighaze yes tineep ila pataŋani tiina lolo wa. Pasa, kinik isaav padi ighaze: Brik piiz to tighuri padi to tigharaat di, irau tinduura izi maau. Yes irau tipasob di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ghoro tipul kinik ve tivot tila, le tindeeŋ Mose yesuru Aron. Pasa, yesuru tineep pumuri ve tisasaŋan di. ");
INSERT INTO tuc_o_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Tighita di, ve tiyaan yesuru tighaze: “Ŋgar to agham payei, Yoova ighita wa. Ve ye tau pale ighur atia payam! Pasa, yamru to agham kinik yesŋa uraata toni atedi yabyab kat payei. Yes tighita ghei tighaze yei samsamiamai kat. Aazne, yamru aghur buza ila nimadi, leso timbut ghei nisob nimatmaat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tovenen Mose imuul ila, ve ighason Yoova ighaze: “O Tiina, pughu vena to yom ugham pataŋani tiina tonene ivot pa tamtoghon tiom? Yom umbaaŋ ghou nanim sualen pasa? ");
INSERT INTO tuc_o_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sawa inim mata to nala navotia aliŋam pa kinik to Isip, ve inim aazne, ye ighurghur pataŋani naol pa yes Israela. Eemoghon yom uul di rita pa pataŋani todi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tovenen Yoova isaav pa Mose ighaze: “Aazne, yom pale ughita katin ŋgar to you pale nagham pa kinik to Isip. You pale napatooŋ tapirig tiina pani, leso ipul yes Israela tila. Ye pale ighita katin you tapirig le isob, ghoro izurun gham aghau pa ndug toni.” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ve Maaron isaav pa Mose muul ighaze: “You Yoova nanepneep. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Muuŋ, sawa to navot to Abaram, Isak, ve Yakop, navotia taug padi naghaze: You Maaron Ariaŋag To Nalib Pa Ndimaronŋa Tisob. Eemoghon izag Yoova, nene navotia padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ve nambua saveeŋ toman di naghaze yeiŋa pale nilup ghei ninim ee moghon, ve nagham taan to yes Kanaana to tineep tinim loomba pani ne, inim ledi. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","“Aazne, yes Israela titaŋ tiina pasa, yes Isipa tighamgham samin di, ve tighurghur pataŋani naol padi. Eemoghon taŋiiz todi, you nalooŋa wa. Ve matag iŋgalŋgal saveeŋ mbuaaŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Tovenen yom ula ve uvotia aliŋag pa yes Israela ughaze: ‘You Yoova nanepneep. Aazne, yam anim mbesooŋa sorok pa yes Isipa, ve titatan gham pa tapiridi, ve lemim ataam eta maau. Eemoghon you pale nagham mbeb gharatooŋadi tintina pida, leso nagham mulin gham ila yes Isipa nimadi. Pale napatooŋ tapirig tiina ivot ighazooŋ, ve naghur atia iŋarua yes Isipa pa sosor todi. Leso napas gham avot pa pataŋani tiam. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ve you pale nagham gham anim tamtoghon tiou, ve you Yoova nanim Maaron tiam. Ve yam pale awatag katin ghou, ve aghazooŋ pa gabuag toman ŋgar tiou. Pasa, uraat to naghaze nagham payam, nene pale ipatooŋ gham pa ŋgar tiou. Onoon, aazne yes Isipa titatan gham pa tapiridi. Eemoghon you pale nagham mulin gham ila nimadi, ve nagharaat ataam payam, leso apul ndug todi ve ala. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Muuŋ, you nambua saveeŋ ve napariaaŋa le iyaryaaŋ kat naghaze you pale nagham taan to yes Kanaana inim Abaram, Isak, ve Yakop ledi. Tovenen you pale nagham gham ala avot taan tonowen, ve naghami inim lemim, leso aneep tonowe itaghoni taghoni gha ila. Pasa, you Yoova nanepneep.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Yoova isavia saveeŋ tonene le isob, ghoro Mose ila ipaesia Yoova aliŋa pa yes Israela. Eemoghon uraat pataŋani to yes tighamghami, nene itatan di le tapiridi isob kat. Tovenen lolodi pa tilooŋ saveeŋ toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ghoro Yoova isaav pa Mose muul ighaze: “Ula ughita kinik to Isip, ve usaav pani ughaze iyok pa yes Israela, leso tipul taan toni ve tila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Eemoghon Mose ipamuul Yoova aliŋa ighaze: “You ŋgeu to savsaveeŋ maau. Ighaze yes Israela tilooŋ saveeŋ tiou maau, nene kinik paam, irau ilooŋ ghou maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ghoro Yoova isaav pa Mose yesuru Aron ighaze timuul tila to yes Israela ve kinik to Isip. Ve ighur uraat pa yesuru ighaze tigham yes Israela tipul Isip ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Nene yes Israela pughudi. Yakop natu aidaba iza Ruben. Ve Ruben ndinatu, nene Anok, Palu, Ezron, ve Karmi. Yes tonene tivot tinim ival, ve muri ghoro tinim rumai paaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Yakop natu Simeon ndinatu, nene Yemuel, Yamin, Oat, Yakin, Zoar, ve Saul. (Saul tina, ye Kanaan tidi.) Yes tonene to tivot ila to Simeon. Yes tivot tinim ival, ve muri ghoro tinim rumai liim ve eez. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yakop natu Levi ndinatu izadi, nene Gerson, Koat, ve Merari. Levi ineep irau ndaman 137, ve imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerson ndinatu, nene Libni ve Simei. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koat ndinatu, nene Amram, Izar, Ebron, ve Usiel. Koat ineep irau ndaman 133, ve imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ndinatu, nene Mali ve Musi. Yes tonene to tivot ila to Levi. Nene pitiiŋ to Levi toman papaghu toni. Yes tivot tinim ival, ve muri ghoro tinim rumai tol. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ivai wagha liva Yokopet. Ve Yokopet ipoop Aron yesuru Mose. Amram ineep irau ndaman 137, ve imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izar ndinatu, nene Kora, Nepek, ve Zikri. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ve Usiel ndinatu, nene Misael, Elzapan, ve Sitri. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron ivai Eliseba to Aminadap natu liva, ye Nason livu. Eliseba yesuru Aron tipoop paaŋ: Nadap, Abiu, Eleasar, ve Itamar. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora ndinatu, nene Asir, Elkana, ve Abiasap. Kora ndinatu tol tonene tivot tinim ival, ve muri ghoro tinim rumai tol. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron natu Eleasar ivai Putiel natu liva, ve tipoop Pineas. Yes tonene to Levi papaghu toni, ve tinim daba pa rumai todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","27","Nenen Aron yesuru Mose pughudi. Yoova ighur yesuru pa timuuŋ pa yes Israela, ve tigham di tipul Isip, ve tilaagh ila rouŋ rouŋ itaghon rumai todi todi, ve tila pa taan Kanaan. Ve yesuru to tisaav pa kinik to Isip tighaze iyok padi leso tigham yes Israela tipul Isip ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Sawa to Mose inepneep izi Isip, Yoova isaav pani ighaze: “You Yoova nanepneep. Saveeŋ isob to you nasavia payom, yom irau usavia pa kinik to yes Isipa leso ilooŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Eemoghon Mose isaav pa Yoova ighaze: “You ŋgeu to savsaveeŋ maau. Pale kinik ilooŋ ghou vena?” ");
INSERT INTO tuc_o_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yoova isaav pa Mose muul ighaze: “Ulooŋ. You Maaron to naghur ghom pa ugham naghog, ve uyoon ila kinik to Isip mata. Ve togham Aron pale inim propet tiom, ve ivotia aliŋam pa kinik. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tovenen sa saveeŋ to you nasavia payom, yom irau usavia pa Aron. Leso ana isavia aliŋag ila to kinik. Ye pale isaav pa kinik leso iyok pa yes Israela ve tipul ndug toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Eemoghon you pale nagham kinik ŋgar toni iyaryaaŋ kat. Leso leg soso pa napatooŋ tapirig izi taan to yes Isipa, ve nagham di tighilaal tighaze you nanepneep. Pale nagham mbeb gharatooŋadi naol to ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tovenen kinik to Isip irau ilooŋ gham rikia maau. Pale ikis gham ris. Eemoghon muri, you pale napatooŋ nimag pa yes Isipa, ve naghur pataŋani tintina iza todi inim atia pa sosor todi. Ghoro nagham tamtoghon tiou Israela tipul taan to Isip ve tila. Pale tilaagh ila rouŋ rouŋ tinimale yes ndaaba. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","“Sawa to napatooŋ tapirig ivot ighazooŋ pa yes Isipa, ve nagham yes Israela tipul ndug todi, nene yes Isipa paam pale tighilaal tighaze: You Yoova nanepneep, ve tighazooŋ pa gabuag toman ŋgar tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Yoova isavsaav le isob, ghoro Mose yesuru Aron tila ve titaghon katin saveeŋ to ye isavia padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Sawa tonenen, Mose ndaman toni irau tamoot paaŋ (80). Ve Aron ndaman toni irau tamoot paaŋ ve tol (83). ");
INSERT INTO tuc_o_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yoova isaav pa Mose yesuru Aron ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Alooŋ. Ighaze kinik to Isip isaav pa yamru pa agham mbeb gharatooŋa eta, ghoro usaav pa Aron igham titi toni, ve ipiyaava izi taan ila kinik mata. Titi toni pale itoora inim moot.” ");
INSERT INTO tuc_o_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tovenen yesuru tila tivot to kinik, ve titaghon katin saveeŋ to Yoova isavia padi. Aron ipiyaav titi toni izi taan ila kinik toman uraata toni matadi, ve titi toni itoora inim moot. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kinik ighita mbeb tonenen, ve ipoi tamtoghon ŋgara pida yesŋa mura pida to Isip tinim, ve yes paam tigham mur todi le ivot inimale Aron ighami. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yes eŋaeŋa tipiyaav titi todi todi tizi taan, ve titi todi titoor di tinim moot paam. Eemoghon titi to Aron to inim moot, itoon moot todi tonowen tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kinik ighita mbeb gharatooŋa tonenen pa tau mata. Eemoghon ŋgar toni iyaryaaŋ kat ighaze izoor Maaron aliŋa. Ŋgar to ye ighami, nene deŋia kat pa saveeŋ to muuŋ Yoova isavia pa yesuru. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Muri ghoro, Yoova isaav pa Mose muul ighaze: “Kinik to Isip, ŋgar toni iyaryaaŋ kat ighaze ye irau ipul yes Israela tila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bozo mboŋmaagh, ye pale izila ya Nil. Tovenen yom ugham titi to itoora inim moot, ve umuuŋ uzila usaŋani izi ya dige. Sawa to ye ilat peria, ");
INSERT INTO tuc_o_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ghoro usaav pani ughaze: ‘Yoova, Maaron to yei Hibrua, imbaaŋ ghou nanim, ve nasavia aliŋa payom wa. Ye ighaze yom upul tamtoghon toni Israel tila, leso timbees pani ve tisuŋ pani izi ndug balim. Eemoghon sawa tonenen ve inim aazne, yom ulooŋ aliŋa rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","18","Tovenen Yoova aliŋa ilat payom muul ighaze ye pale igham ŋgar ite paam. Leso uwatag ughaze ye inepneep, ve ughazooŋ pa gabua toman ŋgar toni. Ughita. You pale nalos ya Nil pa titi tiou to nakiskisi ne, ghoro ya Nil pale itoora inim siŋ, ve iigh to tineep ila ya lolo tisob timatmaat. Ve ya pale vuzi mbuuza kat. Tovenen tamtoghon to Isip pale lolodi pa tighuni muul maau.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ve Yoova isaav muul pa Mose ighaze: “Usaav pa togham Aron igham titi toni, ve ipatooŋa iŋarua ya tisob to yes Isipa. Ya tintina, ve ya gegegeu to tirereer taghon uum lolodi, ya naliu, ve ya todi to ghunuuŋ to ineep ila uur ve rubruub lolodi ne paam. Ya tonowen pale tisob tinim siŋ moghon. Tovenen siŋ pale irau taan isob to Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tovenen Mose yesuru Aron tila ve titaghon katin saveeŋ to Yoova isavia padi. Aron ila iyoon ila kinik to Isip yesŋa uraata toni matadi, ve iit titi toni iza, ghoro ilos ya Nil pani, ve ya Nil itoora inim siŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tovenen iigh to tineep ila ya lolo, tisob timatmaat le ya vuzi. Ya to yes Isipa, eta poia muul maau. Tisob tinim siŋ moghon. Tovenen yes Isipa irau tighun ya Nil muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Eemoghon yes mura to Isip timundig, ve anadi tigham mur todi pa ya, le ivot inimale Mose yesuru Aron tighami. Tovenen kinik ŋgar toni iyaryaaŋ muul, ve ilooŋ yesuru saveeŋ todi maau. Ŋgar to ye ighami, nene deŋia kat pa saveeŋ to Yoova isavia pa Mose yesuru Aron muuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ghoro kinik itoora, ve imuul ila pa ruum toni, ve mata ila pa mbeb tonenen muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Yes Isipa irau tighun ya Nil muul maau. Tovenen titai saambu katindi itaghon ya Nil dige, leso titib adi ya pa tighun. ");
INSERT INTO tuc_o_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yoova iwaghamun ya Nil, ve ineep tovene irau mboŋ liim ve ru. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mboŋ liim ve ru tonenen isob, ghoro Yoova isaav pa Mose ighaze: “Ula ughita kinik to Isip muul, ve usaav pani ughaze: ‘Yoova aliŋa ilat payom ighaze upul tamtoghon toni Israel tila, leso timbees pani ve tisuŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ighaze uŋguruut di, upatum ghom. Pasa, ye pale nawaghamun taan dodoli to Isip pa ŋgob. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ŋgob ndiŋndiŋ ndiŋndiŋ pale tivot pa ya Nil, ve tipul ya, ve tiŋarua ruum tiom tilat. Ghoro tilooŋ tila ruum, ve tiyatov di tizala inam to ghenooŋ paam. Ve tilooŋ tila ruum to uraata tiom, ve tiyatov di tizala ival tiina to Isip poghodi paam. Ve ŋgob pale tilooŋ tila inamim to naznazuuŋ, ve tiyatov di tilooŋ tila uur to toraaŋ mberet lolodi paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tovenen yamŋa uraata tiom, ve ival tiina to Isip paam, ŋgob pale tiyatov di tizala poghomim.’” Yoova isavsaav le isob, ghoro Mose ila ipaesia aliŋa tonenen pa kinik. Eemoghon kinik ilooŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Tovenen Yoova isaav pa Mose muul ighaze: “Usaav pa Aron iit titi toni iza, ve ipatooŋa iŋarua ya tisob to Isip: Ya tintina, ve ya gegegeu to tirereer taghon uum lolodi, ve ya naliu paam. Leso ŋgob tivot pa ya to naol, ve tineep irau taan isob to Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tovenen Aron iit titi toni iza, ve ipatooŋa iŋarua ya tisob to yes Isipa. Ghoro ŋgob ndiŋndiŋ ndiŋndiŋ tivot, le tineep irau taan isob to yes Isipa. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Eemoghon yes mura to Isip tigham mur todi, ve yes paam tigham ŋgob katindi tivot izi taan to Isip. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ghoro kinik to Isip ipoi Mose yesuru Aron tinim, ve isaav padi ighaze: “Yamru aghason Yoova pa indiir ŋgob tonene tighau payou ve tamtoghon tiou paam! Leso napul yes Israela tila tigham watooŋrau pa Yoova.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose isaav pani ighaze: “Poia. Yom taum ughur sawa eta pa nasuŋ pa Yoova. Leso lolo isamin ghom toman yes uraata tiom ve ival tiina to Isip, ve indiir ŋgob tighau pa ruum tiam. Eemoghon ŋgob to tineep ya Nil dige, pale tinepneep tovene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Tovenen kinik isaav pani ighaze: “Bozo, ghoro usuŋ.” Mose isaav pani ighaze: “Poia. Pale nataghon aliŋam. Leso uwatag kat ughaze Yoova, Maaron to yei Israela, ye Maaron tau. Ye raraate inimale ndimaronŋa pida maau. Bozo ghoro, ŋgob tisob tipul ghom toman ruum tiom, ve tipul yes uraata tiom, ve ival tiina to Isip paam, ve tisob tighau tila. Eemoghon ŋgob tau tineep ya Nil dige, pale tinepneep tovene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tovenen Mose yesuru Aron tipul kinik, ve timuul tila. Ghoro Mose itaŋ roran Yoova ighaze ŋgob to iŋgal kinik mata pani ne, indiir di tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ve Yoova ilooŋ suŋuuŋ toni. Tovenen ŋgob tisob to tineep ila ruum to yes Isipa lolodi, ve taghon ruum digedi ve uum lolodi, nene tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ghoro yes Isipa tindou di ila ndouŋ ndouŋ, ve timbuuz le vuzidi ikau ndug. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Sawa to kinik to Isip ighita pataŋani to ŋgob isob, ye isaav ighaze: “Suleem! Aazne ghara, atemai izi!” Eemoghon ŋgar toni iyaryaaŋ muul ighaze izoor Yoova aliŋa. Tovenen ilooŋ Mose yesuru Aron aliŋadi maau, ve iŋguruut yes Israela muul. Ŋgar to ye ighami, nene deŋia kat pa saveeŋ to Yoova isavia pa Mose yesuru Aron. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Sawa pida inim ila, ghoro Yoova isaav pa Mose ighaze: “Usaav pa Aron igham titi toni, ve ilos taan. Leso ghavuur irau taan isob to Isip itoora inim suum.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","18","Tovenen yesuru titaghon Maaron aliŋa. Sawa to Aron igham titi toni ve ilos taan pani, ghavuur isob to Isip itoora inim suum, ve tiŋut yes Isipa toman ŋgai todi le tisami kat. Ghoro yes mura anadi tighaze titoov tapiridi leso tigham suum pida paam tivot. Eemoghon tiraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tovenen tila tipaes pa kinik tighaze: “Wai, mbeb tonene ivot ila Maaron tau nima.” Eemoghon kinik ŋgar toni iyaryaaŋ kat ighaze izoor Maaron aliŋa. Tovenen ilooŋ Mose yesuru Aron maau. Nene deŋia kat pa Yoova aliŋa to muuŋ isavia. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Muri ghoro, Yoova isaav pa Mose ighaze: “Bozo ndoromaaŋa, ve umundig uzila ya Nil dige, ve usaŋan kinik to Isip. Ighaze inim ivot, ghoro uŋarua ula, ve usaav pani ughaze: ‘Yoova aliŋa ilat payom ighaze upul tamtoghon toni tila, leso timbees pani ve tisuŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ighaze uŋguruut di, upatum ghom. Pasa, ye pale imbaaŋ raaŋ tintina ndiŋndiŋ ndiŋndiŋ tilat, ve tiŋut ghom toman yes uraata tiom, ve ival tiina to Isip paam. Ndug tiam toman ruum tiam pale tivon pa raaŋ tintina. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Eemoghon ye pale ipoon taan suruvu to Gosen to tamtoghon toni Israel tineep ila, ve raaŋ eta irau ivot padi maau. Leso yom uwatag ughaze ye ineep izi taan tiom paam. Pasa, ye pale itaghon ŋgar eez pa tamtoghon toni, ve ŋgar ite pa tamtoghon tiom. Bozo, ghoro igham mbeb gharatooŋa tonene ivot, leso ipatooŋ tapiri payom.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yoova itaghon aliŋa tonene, ve igham anoŋa ivot. Ye igham raaŋ tintina ndiŋndiŋ ndiŋndiŋ tivot. Raaŋ tonowen tilooŋ tila kinik ruum toni, ve ruum to yes uraata toni, ve tineep irau taan isob to yes Isipa. Tiwaghamun yes Isipa le tisami kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tovenen kinik imbaaŋ pa Mose yesuru Aron tinim, ve isaav padi ighaze: “Iraua lak! Yam Israela ala agham watooŋrau pa Maaron tiam. Eemoghon ala ndug mala malep. Aneep tataŋgan izi taan to yei Isipa, ve agham uraat tonanan.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Eemoghon Mose isaav pani ighaze: “Vana maau. Ighaze nirab ŋgai tiei tinim watooŋrau pa Maaron tiei Yoova ila yes Isipa matadi, nene pale irau ŋgar todi maau, ve timundig ve tirab ghei pa yaam. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tovenen nighaze yom uyok payei, leso nila ndug balim, ve nigham watooŋrau pa Maaron tiei Yoova tonowe itaghon saveeŋ to ye tau isavia payei. Pale nilaagh irau mboŋ tol, ghoro nila nivot.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kinik ilooŋ saveeŋ tonene, ve ighaze: “Poia. You nayok. Yam irau ala ndug balim ve agham watooŋrau pa Maaron tiam Yoova. Eemoghon ala ndug mala malep. Ve matamim iŋgal ghou paam ila suŋuuŋ tiam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose ipamuul aliŋa ighaze: “Ulooŋ. You naghaze namundig nala tonene. Sawa to napul ghom ve nala, you pale nasuŋ pa Yoova, leso bozo indiir raaŋ tonene tighau payam. Yamŋa uraata tiom, ve ival tiina to Isip paam, raaŋ pale tighau pa yam asob. Eemoghon kinik, you nasaav payom: Ugham kaarom payei ve uŋguruut ghei muul malep. Upul ghei nila nigham watooŋrau pa Yoova.” ");
INSERT INTO tuc_o_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ghoro Mose ipul kinik, ve ila isuŋ pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yoova ilooŋ suŋuuŋ toni, ve indiir raaŋ tisob tighau pa kinik toman uraata toni ve ival tiina to Isip, le raaŋ eta ivot muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Eemoghon kinik ŋgar toni iyaryaaŋ muul ighaze ikis yes Israela tineep. Tauto ipul di tila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Sawa pida inim ila, ghoro Yoova isaav pa Mose ighaze: “Ula to kinik to Isip, ve usaav pani ughaze: ‘Yoova, Maaron to yei Hibrua, aliŋa ilat payom ighaze upul tamtoghon toni tila, leso timbees pani ve tisuŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ighaze uzoor saveeŋ, ve upul di tila maau, ve unoknok ŋgurutaaŋ di, upatum ghom. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Pasa, ye pale ipatooŋ tapiri payom, ve ighur moroghooŋ samia kat pa ŋgai tiam to tilaghlaagh pumuri. Hos, esele, kamel, makau, sipsip, ve mekmek tiam pale timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Eemoghon ŋgai to yes Israela, eta irau imaat maau. Pasa, Yoova pale igham ŋgar eez pa yes Israela ŋgai todi ve ŋgar ite pa yam Isipa ŋgai tiam. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ve Yoova ighur sawa ighaze bozo, ghoro igham mbeb tonene ivot izi taan tonene.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ve onoon, mboŋ ndugizau, ghoro Yoova igham mbeb tonenen ivot, le yes Isipa ŋgai todi katindi timatmaat. Eemoghon yes Israela, ŋgai todi eta imaat maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kinik to Isip imbaaŋ tamtoghon pida tila titiir ndug, ve tighita ŋgai to yes Isipa moghon to timatmaat. Ve Israela todi, popoiadi moghon. Eta imaat maau. Eemoghon mbeb tonowen ipamundigin ŋgar to kinik maau. Ŋgar toni iyaryaaŋ kat ighaze iŋguruut yes Israela tineep. Tauto ipul di tila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Muri ghoro, Yoova isaav pa Mose yesuru Aron muul ighaze: “Yamru ala ndug to tipatuntun uur, ve akor avab le nimamim borokia, ghoro ala aghita kinik to Isip. Ala avot toni, ghoro Mose iyoon ila kinik mata, ve itir avab iza. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Avab tonanan pale imbiriis irau taan isob to yes Isipa. Ve sawa to itap izala tamtoghon ve ŋgai poghodi, nene pale sambor toman mbotmboot samsamia igham di.” ");
INSERT INTO tuc_o_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yoova isavsaav le isob, ghoro yesuru tila ndug to tipatuntun uur, ve tikor avab. Yesuru tila tiyoon ila kinik nagho, ve Mose itir avab iza le imbiriis. Sawa to avab ghavuura tonowen itap izala tamtoghon ve ŋgai poghodi, sambor toman mbotmboot samsamia igham di. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Yes mura paam, sambor igham di le tisami kat tinimale ival tiina to Isip. Tovenen tapiridi irau Mose maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Eemoghon Yoova igham kinik ŋgar toni iyaryaaŋ le iyaryaaŋ kat. Tovenen ye ilooŋ Mose yesuru Aron maau. Ŋgar to kinik ighami, nene deŋia pa Yoova aliŋa to muuŋ isavia pa Mose. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","14","Pataŋani to mbotmboot isob ve muri ghoro, Yoova isaav pa Mose ighaze: “Bozo mboŋmaagh, ghoro umundig ula ve usaŋan kinik to Isip. Sawa to inim ivot, ghoro usaav pani ughaze: ‘Yoova, Maaron to yei Hibrua, aliŋa ilat payom ighaze upul tamtoghon toni tila, leso timbees pani ve tisuŋ pani. Ighaze upul di tila maau, upatum ghom. Pasa, ye pale iŋgal yamŋa uraata tiom ve ival tiina to Isip matamim pa pataŋani pida to tintina kat. Leso yom uwatag kat ughaze: Maaron eta to taan raraate inimale ye maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Inimale ye ipatooŋ katin tapiri payom, tone iwaghamun ghom toman tamtoghon tiom pa moroghooŋ tiina, ve ipasob gham pa taan alok wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Eemoghon igham tovene maau. Pasa, ye ighur ghom pa pughu tonene: Ye ighaze ipatooŋ tapiri ivot le ighazooŋ payom, leso muri tamtoghon tivotia varu irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Aazne, yom upakur ghom, ve utatan tamtoghon toni, ve uŋguruut di ughaze tila malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tovenen bozo mboŋmaagh, sawa tovene, ye pale igham ais patu patu titaptap tizi. Sawa to nditimbum tipamundigin Isip inim ndug paghu, ve inim imuul aazne, ais patu patu tovene titap tizi ndug tiam pa eta sone. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tovenen usaav pa uraata tiom tigham ŋgai tiom toman mbeb tiom to tineep pumuri, ve tighur di tisob tilooŋ tila ruum, leso ruum ipoon di. Mbeb eta ineep pumuri malep. Pasa, ais patu patu to pale tizi, nene pale tirab mbeb tisob to tineep pumuri, le timatmaat.’” Yoova isavsaav pa Mose le isob, ghoro Mose ila ipaesia Yoova aliŋa pa kinik. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yes uraata to kinik to tighur ila Yoova aliŋa ve timatughez pani, rikia moghon tighur ŋgai ve mbesooŋa todi tisob tilooŋ tila ruum. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Eemoghon yes to tighur ila maau, tipul mbesooŋa ve ŋgai todi tineep pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ghoro Yoova isaav pa Mose ighaze: “Ukaak nimam iza, leso ais patu patu titaptap tizi irau taan isob to yes Isipa, ve tirab mbeb tisob to tineep pumuri: tamtoghon, ŋgai, ve aniiŋ isob to uum paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tovenen Mose iit titi toni iza, ghoro Yoova igham ndug milia, ve lalaav kiliŋia izizi pa taan toman avolutu tiina, ve ais patu patu titaptap tizi irau taan isob to yes Isipa. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ais patu patu tintina kat titaptap tizi, ve ndug milia le ndug isami kat. Sawa to yes Isipa nditimbudi tipamundigin Isip inim ndug paghu ve inim, mbeb tovene ivot pa ndug todi pa eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tovenen ais patu patu titaptap tizi irau taan isob to yes Isipa, ve tirab mbeb tisob to tineep pumuri: tamtoghon, ŋgai, ve aniiŋ isob to uum. Ve tirab ai paam le bogadi tipolpol. Tovenen mbeb tisob tisami. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ndug ee moghon kat to ais izi pani maau. Nene taan suruvu to Gosen to yes Israela tineep pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tovenen kinik to Isip imbaaŋ pa Mose yesuru Aron tinim, ve isaav padi ighaze: “Iraua lak! Aazne, you naghilaal naghaze nagham sosor wa. Yoova ŋgar toni, nene deŋia. Ve yeiŋa tamtoghon tiou nisosor. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tovenen yamru ala ve asuŋ pa Yoova. Pasa, ais patu patu ve lalaav tonene iwaghamun ghei le nisami kat. You pale napul gham ala. Irau naŋguruut gham muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose isaav pani ighaze: “Poia. You pale napul ndug tiina ve navot nala pumuri, ghoro nakaak nimag iza, ve nasuŋ pa Yoova. Leso ipasob lalaav, ve ais patu patu titap muul sob. Sawa to mbeb ru tonenen putia, yom pale uwatag ughaze: Taan to naol ne, nene taan to Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Eemoghon you nawatag: Yamŋa uraata tiom amatughez pa Maaron tiei Yoova sone.” ");
INSERT INTO tuc_o_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Sawa to ais patu patu tonowen titaptap tizi, tirab aniiŋ bali ve mbeb ite to tighagharaat nonogiiŋa toman mbeb pida pani ne, le tisami. Pasa, bali itub iza ve anoŋa ighaze ivot, ve mbeb ite tonowen irug paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Eemoghon aniiŋ wit toman aniiŋ todi ite to tiwaata tighaze ‘spelt,’ nene tipaar sone. Tauto ais patu patu tonenen tiwaghamun di maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mose ipul kinik, ve ivot ila pa ndug tiina dige, ghoro ikaak nima iza, ve isuŋ pa Yoova. Tovenen Yoova ipasob uman toman lalaav ve ais, ve titap muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Eemoghon sawa to kinik ighita uman toman lalaav ve ais putia, ye igham sosor muul. Yesŋa uraata toni ŋgar todi iyaryaaŋ muul tighaze tiŋguruut yes Israela tineep. Lolodi pa tilooŋ Maaron aliŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kinik ŋgar toni iyaryaaŋ kat. Tauto iŋguruut yes Israela muul. Ŋgar to ye ighami, nene deŋia kat pa Yoova aliŋa to Mose isavia. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Muri ghoro, Yoova isaav pa Mose ighaze: “Ula ughita kinik to Isip muul. Pasa, you taug to nagham yesŋa uraata toni ŋgar todi iyaryaaŋ. Leso nagham mbeb gharatooŋadi tintina tivot ila lolodi, ve napatooŋ tapirig padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ve muri inim kamos pa yam Israela, leso asavia pa ndinatumim ve nditimbumim, ve asaav padi aghaze: ‘Muuŋ, Yoova ipatooŋ tapiri pa yes Isipa. Ye igham mbeb gharatooŋadi tintina tivot ila lolodi, ve ipamogheran di le tiwaghamgham kat.’ Ve yam asob pale awatag aghaze you Yoova nanepneep, ve aghazooŋ pa gabuag toman ŋgar tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Yoova isavsaav le isob, ghoro Mose yesuru Aron tila tivot to kinik, ve tisaav pani tighaze: “Yoova, Maaron to yei Hibrua, aliŋa ilat payom muul ighaze: Yom ukaria zoraaŋ saveeŋ wa. Pale ŋeez o uput aghem pani ve uneep ila samba? Upul tamtoghon toni tila, leso timbees pani ve tisuŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ighaze uŋguruut di muul, upatum ghom. Pasa, bozo mboŋmaagh, ye pale igham isis tivot, ve tiwaghamun ndug tiom. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Isis to pale tivot, nene sorok maau. Pale titatab taan tiam, le aghita taan maau. Tovenen aniiŋ eŋaeŋa to ais iwaghamun di maau, isis pale tipasob di le tisob kat. Ve ai tisob to titub ila uum tiam lolodi ne paam, isis pale tighan suvun rauadi. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Yamŋa uraata tiom ve ival tiina to Isip paam, ruum tiam pale tivon kat pa isis. Muuŋ kat, sawa to nditimbumim tinim tigham ndug tonene, ve inim imuul aazne, aghita isis tovene tivot pa eta sone.” Mose isavia saveeŋ tonene le isob, ghoro itoora, ve ipul kinik, ve ivot ila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yes uraata to kinik tisaav pani tighaze: “Wai kinik, pa piiz to yom ughaze upul ŋgeu tonowen igham pataŋani pait? Yom uwatag maau? Ndug to Isip isami wa. Upul nditamoot to Israel tila tisuŋ pa Maaron todi Yoova.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tovenen tila tigham Mose yesuru Aron timuul tinim, ve kinik isaav padi ighaze: “Aazne, you nayok payam pa ala asuŋ pa Maaron tiam Yoova. Eemoghon naghaze nawatag: Sei masin kat to pale tila?” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose ipamuul aliŋa ighaze: “Yei nisob pale nila. Ndolman, ndipain, ndinatumai nditamoot ve ndiliva, toman sipsip, mekmek, ve makau tiei tisob paam. Pasa, nighaze nila nigham lupuuŋ tiina ve nisuŋ pa Yoova.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tovenen kinik isaav pani muul tovene: “Ighaze nayok payam pa ala, nene avaat Yoova ineep toman gham ve poia toni iza tiam. Eemoghon irau napul ndizwamim ve ndinatumim tila toman gham ne maau. Maau le maau kat! Pasa, ŋgar samia eta avaat ineep ila lolomim. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tovenen yam nditamoot moghon irau ala ve asuŋ pa Yoova. Pasa, mbeb tonenen, to yamru azorzoorndug pani.” Ye isavsaav padi le isob, ghoro izurun Aron yesuru Mose tighau pa mata, ve tivot tila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ghoro Yoova isaav pa Mose ighaze: “Ukaak nimam iza, ve upatooŋa iŋarua taan isob to yes Isipa. Leso isis ndiŋndiŋ ndiŋndiŋ tivot, ve tiwaghamun aniiŋ toman mbeb pida to titub ila taan todi. Sa mbeb to ais iwaghamuni maau, nene pale isis tipasobi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tovenen Mose iit titi toni iza, ve ipatooŋa iŋarua taan isob to yes Isipa. Ghoro Yoova igham yaghur tiina ilaagh pa taan dige to ineep ila pa ndag iza, ve inim. Yaghur ilaagh pa ndag le mboŋ mboŋ ve ndugizau. Tauto iviviir isis tivot. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Isis to tivot ne, sorok maau. Katindi kat. Ve tineep irau taan isob to Isip, ve tiwaghamun ndug todi. Muuŋ ve inim, isis tovene tivot izi Isip pa eta sone. Ve muri paam, irau tivot muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tovenen isis titatab taan isob to yes Isipa, ve tigham taan iyasosooŋ. Ve tighan suvun mbeb tisob to ais iwaghamun di maau ne le tisob kat. Tighan kikiliiŋ, ndoor, aniiŋ, ai rauadi, ve anoŋadi paam. Taan isob to yes Isipa, mbeb mbiti eta ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tovenen rikia moghon kinik to Isip imbaaŋ pa Mose yesuru Aron tinim, ve isaav padi ighaze: “You nagham sosor tiina kat pa Maaron tiam Yoova, ve nagham sosor pa yamru paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Lolomim isamin ghou muul, ve apul sosor tiou tonene. Irau nagham sosor muul maau. Ve asuŋ Maaron tiam Yoova pa indiir pataŋani tonene payei. Pa vene, nisob nimatmaat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tovenen Mose ipul kinik ineep, ve ila isuŋ pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yoova ilooŋ suŋuuŋ toni, ve itoor yaghur ve ilaagh pa ndag izila ve inim toman tapiri, le iviviir isis tonowen tisob tila pa Te Kaviaaŋa. Eta ineep muul izi Isip maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Eemoghon Yoova igham kinik ŋgar toni iyaryaaŋ muul. Tovenen ipul yes Israela tila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Muri ghoro, Yoova isaav pa Mose ighaze: “Ukaak nimam iza, leso ndoroom tiina ivot izi Isip. Ndoroom tiina to pale ivot, nene ite kat. Yes Isipa pale tiyamaana tighaze nene poia maau, ve igham di titaŋtaaŋ ve tiwandabndab tinimale yes to matadi pisi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tovenen Mose ikaak nima iza, ve ndoroom tiina ikau Isip, le ineep irau mboŋ tol ve ndag tol. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ndoroom tiina tonowen ivot le yes Isipa irau tiwaghiton di maau. Tovenen mboŋ tol ve ndag tol tonenen, yes irau tilaagh maau. Tineep ila ruum todi moghon. Eemoghon ndug to yes Israela tineep pani, nene ghazooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tovenen kinik to Isip ipoi Mose imuul inim, ve isaav pani ighaze: “Yam Israela ala asuŋ pa Yoova. Yamŋa ndizwamim ve ndinatumim asob ala. Eemoghon yam irau apul makau, sipsip, ve mekmek tiam tineep izi Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","26","Eemoghon Mose isaav pani ighaze: “Ee-e, vana maau. Pale nimundig toman ŋgai tiei tisob. Irau nipul eta ineep maau. Pasa, yei taumai nikankaan pa sa mbeb to pale nigham di tinim watooŋrau pa Maaron tiei Yoova. Tovenen yei irau niyou di tisob tila toman ghei. Nila nivot sa ndug to Yoova ighaze nineep pani ve nisuŋ, ghoro ye tau pale isaav payei pa sa mbeb to pale nigham di tinim watooŋrau pani. Mbeb pida, pale nimoz suruvu moghon inim watooŋrau. Ve pida, yab pale ighan suvun di.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Eemoghon Yoova igham kinik ŋgar toni iyaryaaŋ muul. Tovenen lolo pa ipul yes Israela tila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ve izurun Mose ighaze: “Ughau pa matag. Ve umuul unum sualen malep! Ighaze naghita ghom muul, yom pale umaat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tovenen Mose ipamuul aliŋa ighaze: “Poia. Saveeŋ tauto usavia. Irau ughita ghou muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Muri ghoro, Yoova isaav pa Mose ighaze: “You pale naŋgal kinik toman ival tiina to Isip matadi pa pataŋani ite paam. Muri pa pataŋani tonene, ye pale iyok payam ve ala. Ye pale izurun gham, ve ipasul gham ighaze rikia ve asob ala. Irau tiam eta ineep maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tovenen aazne, yom ula ve usaav pa Israela tisob, nditamoot ve ndiliva, tovene: Yes irau tila to yes Isipa to tineep tigharau di, ve tighason di pa tigham ledi mbaliiŋ pida to tigharaat di pa gol ve silva.” ");
INSERT INTO tuc_o_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yoova isaav tovene pasa, ye igham yes Isipa lolodi poia pa yes Israela. Ve Mose paam, yes uraata to kinik toman ival tiina to Isip tighita tighaze ye ŋgeu tiina eez, ve titandag pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tovenen Mose isaav pa kinik ighaze: “Ulooŋ! Yoova aliŋa ilat payom tovene. Ighaze: ‘Mboŋ anoŋa, you pale nazi nanim, ve nalaagh irau taan isob to Isip. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ve ndinatumim aidaba tisob pale timatmaat. Irau napul eta ineep maau. Yom to unepneep ila inam to ghamuuŋ pooz, taum natum aidaba pale imaat. Ve itaghoni tovene ila ila le yes ndiliva mbesooŋa to ledi izadi maau ve timumum wit inim palawa ne ndinatudi paam. Tamtoghon tisob to Isip ndinatudi aidaba, toman ŋgai todi ndinatudi to nditinandi tipoop di muuŋ ne, pale tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tovenen taŋiiz tiina pale ivot irau taan isob to Isip. Muuŋ ve inim, taŋiiz tovene ivot izi ndug tiam pa eta sone. Ve muri paam, irau ivot muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Eemoghon yes Israela toman ŋgai todi tisob pale tineep pooi. Ŋgavuun eta irau isuul maau. Leso yom uwatag kat ughaze you Yoova nagham ŋgar raraate pa yam Isipa ve tamtoghon tiou Israel maau. Nagham ŋgar ite ite payam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ve Mose isaav muul ighaze: “O kinik, mbeb tonene ighaze ivot, uraata tiom tonene pale tisob tinim tiput aghedi payou, ve titaŋ roran ghou tighaze: ‘Yamŋa tamtoghon tisob to titaghon ghom, apul ghei ve aghau ala!’ Muri pa mbeb tonenen, you pale napul ghom.” Mose ate yabyab kat. Tovenen ipul kinik ineep, ve ivot ila pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ghoro Yoova isaav pani ighaze: “Kinik to Isip irau ilooŋ aliŋam maau. Ve nene poia. Pasa, ighur soso payou, leso nagham mbeb gharatooŋadi naol izi Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tovenen Mose yesuru Aron tigham mbeb gharatooŋadi naol ila kinik to Isip mata. Mbeb tonowen ite kat. Eemoghon Yoova igham kinik ŋgar toni iyaryaaŋ le iyaryaaŋ kat. Tauto iyok pa yes Israela tipul taan toni ve tila ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mose yesuru Aron tinepneep izi taan to Isip, ve Yoova isaav padi ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kaiyo tonene, nene ilib pa kaiyo tisob. Pasa, kaiyo tonene, you pale nagham mbeb paghu ivot payam. Tovenen yam Israela irau aghur kaiyo tonene imuuŋ pa ndaman tiam tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Yamru ala alup Israela tisob, ve asaav padi tovene: Mboŋ inim saaŋgul to kaiyo tonene, ghoro nditamoot tisob irau timbit sipsip ma mekmek papaghu eŋaeŋa irau ruum todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yam eŋaeŋa irau aŋgabiiz poian sipsip to ambit di: Tamtoghon piiz kat to irau tighani le tipasobi? Ighaze ruum eta tamtoghona naol maau, ve tigham ŋgar tighaze eŋgendi irau tighan suvun sipsip todi maau, yes irau tisaav pa nditadi to tineep tigharau di tinim, ve yesŋa tilup di ve tighanghan. Leso tipasobi. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yam irau aghita sipsip ma mekmek nditamoot to popoiadi moghon, ve ndaman todi eŋaeŋa, ghoro ambit di. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","7","Aŋgin poian di le mboŋ inim saaŋgul ve paaŋ (14) to kaiyo tonene, ve rabrab izi, sawa to taghita sapirin ghiit, ghoro arab di. Ve ruum sine to aneep ila, agham mbeb to arab di ne siŋidi, ve apeli ila ataam avo dige ru, ve izala pa sala paam. Leso inim ghilalooŋ payam ighaze yam tamtoghon to Yoova to alup gham pa ghanghaniiŋ ila ruum tonanan lolo. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“Mboŋ ee moghon tonenen, amoz sipsip tonanan izala yab, ve aghani toman mberet to le yis maau, ve ndoor papaii. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sipsip minda to ighaze mbiti ma nazuuŋ, yam aghani malep. Aghan moziiŋ moghon. Tovenen amoz sipsip anoŋa dodoli, toman daba, ŋgoi, ve kodkoda izala yab, ve aghan suvuni. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Apul pida ineep inim ŋaar malep. Ighaze aghan le apomim isuŋ, ve pida ineep, aghuri ila yab ighan suvuni le isob, ghoro ndugizau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ve agharaat taumim pataghaaŋ pa laghooŋ. Apool nonogiiŋa tiam ila tuku, aghur duduuŋa to aghemim, ve akis titi tiam paam. Ghoro mbolemim izi ve aghanghan. Eemoghon aghan rikia. Aniiŋ tonanan, nene aniiŋ to Pasova. Yam irau aghani, leso matamim iŋgal sawa to you Yoova nasalib payam, ve nala narab yes Isipa ndinatudi timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mboŋ tonenen, you pale nalaagh irau taan isob to Isip, ve narab ndinatudi aidaba, toman ŋgai todi ndinatudi to nditinandi tipoop di muuŋ, le tisob timatmaat. Leso naghur atia pa maaron kaaromŋa todi, ve natatan tapiridi. Pasa, you Yoova nanepneep. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tovenen siŋ to apeli ila ataam to ruum tiam avodi dige, nene pale ipatooŋ ruum tiam payou. Sawa to nalaagh pa narab yes Isipa, ve naghita siŋ tonanan, you pale nasalib payam, ve navool pa ruum ite. Leso nawaghamun gham sob. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Sawa tonene, sawa tiina ve sawa patabuaŋ. Tovenen yam Israela yamŋa papaghu tiam to muri pale tivot, irau apakur sawa tonene, ve matamim iŋgali irau sawa isob. You naghur tutuuŋ payam tovene: Ndaman isob, ighaze sawa tonene ivot, yam irau agham lupuuŋ tiina, ve asuŋ payou toman lolomim poia. Tutuuŋ tonene pale iyaryaaŋ tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Sawa to lupuuŋ tiina tonene, ighaze lolomim pa aghan mberet, ghoro aghan mberet to tighur yis ila maau ne. Yam pale aghan mberet tovene moghon irau mboŋ liim ve ru. Tovenen sawa to lupuuŋ tiina tonene ighaze imundig, yam agham yis isob to ineep ila ruum tiam lolodi, ve apiyaava ilale. Apul rita ineep malep. Mboŋ liim ve ru to lupuuŋ tiina tonene, ighaze tamtoghon tiam eta izoor saveeŋ ve ighan mberet to titoora toman yis, yam azuruni ighau ila saguan pa yam Israela. Ilup toman gham muul malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sawa to lupuuŋ tiina tonene imundig, ve sawa inim liim ve ru to isob pani, yam Israela asob irau alup gham ve agham suŋuuŋ tiina. Sawa ru tonenen, nene umbom patabuaŋ. Agham uraat eta malep. Eemoghon aniiŋ, ghoro yam irau agharaata. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Lupuuŋ tiina to mberet to le yis maau ne, ndaman isob, yam irau matamim iŋgali ve ataghoni. Pasa, sawa tonene kat, to you nagham gham alaagh ila rouŋ rouŋ animale yes ndaaba, ve apul taan to yes Isipa. Tauto naghur tutuuŋ ariaŋa pa yam ve papaghu tiam to muri pale tivot ne tovene: Ndaman to naol ne, yam irau matamim iŋgal sawa tonene, ve alup gham ve agham suŋuuŋ tiina payou. Tutuuŋ tonene pale ineep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","19","“Tovenen ndaman tisob, kaiyo to ivot muuŋ, mboŋi inim saaŋgul ve paaŋ, ve rabrab toni, nene sawa to lupuuŋ tiina tonene imundig. Ve ila isob pa rabrab to mboŋ inim tamoot ee ve eez (21). Mboŋ liim ve ru tonenen, ighaze aghan mberet, ghoro aghan mberet to tighur yis ila maau. Tovenen sawa tonenen, yis eta ineep ruum tiam lolodi malep. Ighaze taumim eta, ma loom eta to ineep ila lolomim izoor saveeŋ ve ighan mberet to titoora toman yis ila sawa tonenen lolo, azuruni ighau ila saguan pa yam Israela. Ilup toman gham muul malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tovenen mboŋ liim ve ru tonenen, ndug sine to yam aneep pani, aghan mbeb eta to yis ineep ila malep. Agharaat mberet to le yis maau ne moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Yoova isavsaav toman Mose le isob, ghoro Mose ila ve ilup ndolman tisob to Israel, ve isaav padi ighaze: “Ala rikia moghon, ve apas lemim sipsip papaghu irau ruum tiam tiam, ve arab di. Leso agharaat aniiŋ to Pasova. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Sipsip tonanan siŋidi, awato ila oon, ve agham ai ‘isop’ boga, ve azeeva ila siŋ tonanan. Ghoro apeli ila ataam tiam avodi dige. Ila dige ru, ve izala pa sala paam. Tiam eta ivot ila pumuri malep. Yam asob aneep ila ruum tiam tiam lolodi le ndugizau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Sawa to Yoova izi inim, ve ilaagh pa irab yes Isipa ndinatudi ve mbeb todi, ighaze ighita siŋ tonanan ineep ataam tiam avodi dige, ye pale isalib payam, ve ila ivool ruum ite. Irau ipul aŋela to rabuuŋ tamtoghon ilooŋ ilat ruum tiam ve irab gham maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Tutuuŋ to aazne nasavia di payam ne, nene ariaŋadi. Pale tinepneep tovene irau sawa isob. Tovenen yamŋa papaghu tiam to muri pale tivot ne matamim kisin di, ve ataghon katin di itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sawa to ala avot taan to Yoova imbua saveeŋ pani ighaze igham payam, matamim iŋgal lupuuŋ tiina to Pasova, ve ataghon katin ŋgara izi tonowe. Apuli malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ve sawa to ndinatumim tighason gham pa lupuuŋ tonene pughu, ghoro apaes padi tovene. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Aghaze: ‘Iit tarab mbeb tonene inim watooŋrau pa Yoova. Leso tapaiti, ve mataad iŋgal sawa to Pasova to Yoova isalib pa ruum toit izi Isip, ve ipul ghiit taneep, ve ila irab yes Isipa ndinatudi.’” Yes Israela tilooŋ saveeŋ tonene, ve tiput aghedi ve tipait Yoova iza. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ghoro tila ve titaghon katin tutuuŋ tisob to Yoova isavia di pa Mose yesuru Aron. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Yes tineep le mboŋ anoŋa, ghoro Yoova izi inim, ve irab yes Isipa ndinatudi aidaba tisob timatmaat. Ipul eta ineep maau. Kinik to igham pooz pa taan Isip ne natu aidaba, ve ila ila le yes to tineep ila ruum to yabyabuuŋ lolo ne ndinatudi aidaba paam, tisob timatmaat. Ve Isipa ŋgai todi paam. Ye irab ndinatudi to nditinandi tipoop di muuŋ ne, le tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tovenen mboŋ tonenen, kinik yesŋa uraata toni ve ival tiina to Isip, timundig le tighita ndinatudi timatmaat. Ghoro taŋiiz tiina imundig irau ruum ruum to yes Isipa. Pasa, mateeŋ irau ruum tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","32","Mboŋ tonenen, kinik imbaaŋ ila pa Mose yesuru Aron tinim, ve isaav padi ighaze: “Rikia moghon ve amundig apul ndug tiou, ve aghau ala! Ve yamru moghon maau. Ival tiina to Israel paam. Yam asob ayou sipsip, mekmek, ve makau tiam, ve ala agham suŋuuŋ pa Yoova itaghon ghasoniiŋ tiam. Apul tamtoghon tiou, ve aghau ala! Ve aghason Maaron tiam pa igham poian ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Yes Isipa tipasul yes Israela tighaze tipul ndug todi rikia moghon. Pasa, tigham ŋgar tovene: “Ighaze yes Israela tineep toman ghiit, nene pale tasob tamatmaat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ghoro yes Israela tigham oon todi to palawa ineep ilooŋ ila, ve tindun di pa uli, leso timbaad di ila avaradi. Palawa tonowen, titoora toman yis sone. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ve titaghon Mose aliŋa ve tighason yes Isipa pa ledi mbaliiŋ naol naol to tigharaat di pa gol ve silva, ve tighason di pa ledi nonogiiŋa paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yoova igham yes Isipa lolodi poia pa yes Israela. Tovenen mbeb tisob to yes Israela tighason di pani, yes Isipa tigham padi moghon. Tauto yes Israela tikarasim di kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Tovenen yes Israela timundig ve tipul ndug Ramses, ve tila tivot ndug eez iza Sukot. Yes ival le ival kat. Nditamoot todi to tirau malmal, yes irau 600,000 ma venen. Ve yes ndiliva toman ndinatudi, tinin di maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Yes Israela ledi sipsip, mekmek, ve makau katindi kat. Tauto tiyou di tisob, ve tilaagh toman di. Ve ndug pida to Israela maau ne timundig tila toman di paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tilaagh tila le tivot ndug eez, ghoro atedi izi. Tineep tonowe, ve tigham palawa todi to tigharaata izi Isip, ve timozi inim adi taman. Palawa tonowen, titoora toman yis maau. Pasa, sawa to timundig, yes Isipa tipasul di. Tauto ledi sawa eta pa tigharaat poian taman todi maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yes Israela tineep izi Isip irau ndaman 430, ghoro tipul Isip ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tovenen sawa kat to ndaman 430 tonenen isob, ghoro yes Israela tisob timundig tipul Isip ve tila. Tilaagh ila rouŋ todi todi tinimale yes ndaaba. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mboŋ tonowen, Yoova mata iŋgal yes Israela, ve igham di tipul Isip itaghon saveeŋ mbuaaŋ toni. Tauto ndaman isob, sawa to Pasova ighaze ivot, yes Israela tisob irau tipamaat ve matadi iŋgal mbeb to ivot pa mboŋ tonowen, ve tipait Yoova. Ŋgar tonene pale ineep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yoova isaav pa Mose yesuru Aron ighaze: “Nene tutuuŋ pida to iŋarua ghanghaniiŋ to Pasova. Ndug ndug to ighaze tinim tineep ila yam Israela lolomim, todi eta irau ighan sorokin aniiŋ to Pasova maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","Ve ighaze agham tamtoghon to ndug ite inim lemim uraata, nene ye paam irau ighan sorokin aniiŋ to Pasova maau. Eemoghon ighaze aghol tamtoghon to ndug eta inim lemim mbesooŋa ve aziri, nene ye irau ighan. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ighaze alup gham pa ghanghaniiŋ to Pasova ila ruum eta lolo, yam aghan suvun sipsip tiam tonanan. Agham minda rita ivot ila pumuri malep. Ve tua tovene paam, aŋgoor eta malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tamtoghon to Israel tisob irau matadi iŋgalŋgal lupuuŋ tiina to Pasova ve titaghon katin ŋgara. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ighaze ŋgeu eta to ndug ite ilat ineep toman gham, ve ighaze ilup toman gham pa ghanghaniiŋ to Pasova, yam irau aziri toman ndita nditamoot tisob to tineep ila ruum toni. Leso aghita di aghaze yes raratedi tinimale yam to Israela kat. Le isob, ghoro yes irau tighan aniiŋ to Pasova. Eemoghon sei to ighaze tiziri maau, nene irau ighan aniiŋ to Pasova maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tutuuŋ tonene pale igham pooz pa yam asob. Yes to siŋ kat to Israel, ve yes loomba to tineep ila lolomim ne paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tovenen yes Israela tisob titaghon katin tutuuŋ tisob to Yoova isavia pa Mose yesuru Aron. ");
INSERT INTO tuc_o_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ve sawa kat tonenen, Yoova igham di tipul Isip. Tilaagh ila rouŋ todi todi, ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yoova isaav pa Mose muul ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Yam Israela irau aghur ndinatumim aidaba toman ŋgai tiam ndinatudi to nditinandi tipoop di muuŋ tisob tinim leg.” ");
INSERT INTO tuc_o_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose isaav pa yes Israela ighaze: “Matamim iŋgal sawa tonene. Muuŋ, yam anim mbesooŋa sorok izi taan Isip. Eemoghon aazne, Yoova ipatooŋ tapiri tiina, ve ipas gham ila yes Isipa nimadi, ve apul ndug todi wa. Tauto aazne, anim mbesooŋa muul maau. Tovenen ndaman isob, sawa tonene ighaze ivot, yam aghan mbeb eta to yis ineep ila ne malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Matamim iŋgal kaiyo Abib tonene. Pasa kaiyo tonene, to yam apul taan to yes Isipa. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","6","Muuŋ, Yoova imbua saveeŋ toman nditimbumim ighaze ye pale igham taan to yes Kanaana, Hita, Amora, Hivia, ve Yebusa inim lemim. Taan tonowen ŋgoreeŋa ve poia pa mbeb naol titub pani. Tovenen muri, sawa to Yoova igham gham ala avot tonowe, matamim iŋgal pa ataghon ŋgar tovene: Ndaman to naol ne, ighaze kaiyo Abib ivot, ghoro alup gham ve asuŋ pa Yoova. Mboŋ liim ve ru, yam irau aghan mberet to le yis maau ne moghon. Ve mboŋ inim liim ve ru to lupuuŋ tiina tonenen isob pani, yam alup gham ve agham suŋuuŋ tiina, ve apait Yoova iza toman lolomim poia. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mboŋ liim ve ru tonenen, ighaze aghan mberet, aghan mberet to le yis maau. Tovenen sawa tonenen, yis eta ineep ila yam Israela ndug tiam lolo malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Ighaze sawa to lupuuŋ tiina tonene ivot, yam eŋaeŋa apaesia pughu pa ndinatumim aghaze: ‘Iit tataghon ŋgar tonene, leso mataad iŋgal sawa to Yoova iuul ghiit, ve igham ghiit tapul Isip ve tanim.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Lupuuŋ tiina tonene pale inim ghilalooŋ to ineep ila nimamim ve ndamomim, ve ipei mulin ŋgar tiam pa sawa to Yoova ipatooŋ tapiri tiina, ve igham gham apul ndug to yes Isipa ve anim. Leso lolomim imaagh pani sob, ve avomim imbesmbees pa saveeŋ to ye igham pait ne irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tovenen Yoova ighur tutuuŋ payam tovene: Ndaman to naol ne, ighaze sawa to lupuuŋ tonene ivot, yam alup gham pa suŋuuŋ ve ataghon ŋgar tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Mose isaav muul ighaze: “Yoova pale igham gham ala avot izi taan Kanaan. Taan tonowen, ye ighaze ipuli inim lemim itaghon saveeŋ mbuaaŋ toni ariaŋa to imbua toman nditimbumim. Saveeŋ tonenen iŋarua gham paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Sawa to ala aneep izi taan tonowen, yam irau ataghon ŋgar tovene: Ndinatumim aidaba, toman ŋgai tiam ndinatudi to nditinandi tipoop di muuŋ, yam aghur di tisob tinim Yoova le. Tovenen ŋgai tiam ndinatudi nditamoot to tipoop di muuŋ, arab di tisob timatmaat tinim watooŋrau pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eemoghon esele ndinatudi nditamoot to tipoop di muuŋ, arab di tinim watooŋrau pa Yoova malep. Arabolin di pa sipsip, ve arab sipsip tonenen tinim watooŋrau. Ve ighaze arabolin di pa sipsip maau, ghoro aŋgoor luadi ve timaat. Ve ndinatumim aidaba nditamoot tovene paam. Arabolin di tisob pa sipsip ma mbeb pida, ve agham mbeb tonenen pa Maaron tinim watooŋrau. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Muri, ighaze ndinatumim tighason gham pa ŋgar tonene pughu, ghoro apaes padi aghaze: ‘Muuŋ, iit tanim mbesooŋa sorok izi Isip. Eemoghon Yoova ipatooŋ tapiri tiina, ve igham ghiit tapul ndug tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Sawa tonenen, kinik to yes Isipa, ŋgar toni iyaryaaŋ kat ighaze tapul ndug toni malep. Eemoghon Yoova irab yes Isipa ndinatudi aidaba toman ŋgai todi ndinatudi to nditinandi tipoop di muuŋ, le tisob timatmaat. Tauto aazne, iit tarab ŋgai toit ndinatu nditamoot to tipoop di muuŋ ne, tisob timatmaat tinim watooŋrau pa Yoova. Ve ndinatuud aidaba tinim Yoova le paam. Eemoghon tarab di tinim watooŋrau maau. Tarabolin di pa sipsip ma mbeb pida, ve tagham mbeb tonenen pa Yoova tinim watooŋrau. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ŋgar tonene, nene inim ghilalooŋ to ineep ila nimaad ve ndamood ve ipei mulin ŋgar toit pa sawa to Yoova ipatooŋ tapiri tiina, ve igham ghiit tapul ndug to yes Isipa ve tanim. Leso lolood imaagh pani sob, ve mataad iŋgali irau sawa isob.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sawa to kinik to Isip ipul yes Israela tila, Yoova imuuŋ ve ipatooŋ di pa ataam. Eemoghon ye igham di titaghon ataam tuku to itaghon taan to yes Pilistia ne maau. Pasa, igham ŋgar tovene: “Ighaze yes Israela titaghon ataam tuku tonowen, ve tivot to koiadi rikia ve malmal imundig, nene pale titoor ŋgar todi, ve tighau timuul tila pa Isip.” ");
INSERT INTO tuc_o_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","19","Tauto ipamuul di tilaagh titaghon ataam mala to itaghon ndug balim ve ila ivot Te Kaviaaŋa. Sawa to yes Israela tipul Isip, tigharaat di pataghaaŋ pa malmal ve tilaagh. Ve Mose igham Yosep tua ve tilaagh tomani. Pasa muuŋ kat, Yosep isaav pa yes Israela nditimbudi tovene: “Muri, Maaron pale igham mulin gham ve apul ndug to yes Isipa. Sawa tonenen ighaze ivot, ghoro agham tuag ve alaagh tomani. Leso atavia izi Kanaan.” Ve yes Israela timbua saveeŋ ariaŋa toman Yosep tighaze yes pale titaghon ŋgar toni tonenen. Tauto Mose mata iŋgal saveeŋ mbuaaŋ todi tonowen, ve itaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yes Israela tipul ndug Sukot, ve tila tivot ndug balim dige, ghoro atedi izi ndug eez, iza Etam. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ndag to naol ne, Yoova ineep ila yaghur tae lolo ve imuuŋ padi, leso ipatooŋ di pa ataam. Yaghur tae tonowen mala. Iza ve izi. Ve mboŋ to naol ne, ye inim yab yama to iyaryaar iza ve isul, leso ipatooŋ di pa ataam. Tovenen yes irau tilaagh pa mboŋ ve ndag. ");
INSERT INTO tuc_o_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yaghur tae ve yab yama tonowen tipulpul di maau. Timuŋmuuŋ padi pa mboŋ ve ndag. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ghoro Yoova isaav pa Mose ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Usaav pa yes Israela titoor di, ve timuul tila tivot naari to ndug Pi Airot. Ndug tonowen ineep ndug Migdol dige to ineep ila pa te, ve igharau ndug Bal Zepon. Tila tivot, ghoro tigharaat inadi izi tonowe ve atedi izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Leso kinik to Isip igham ŋgar ighaze yam asosor pa ataam, ve awalaghlaagh izi ndug balim, ve lemim ataam eta pa aghau maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","You pale nagham ŋgar toni iyaryaaŋ muul, leso itaghon gham. Sawa to inim peria tiam, you pale napatooŋ tapirig pani, ve natatani toman ndaaba toni le tisob tilaledi. Leso nagham izag ivot inim tiina, ve yes Isipa tighilaal tighaze: You Yoova nanepneep.” Tovenen yes Israela titaghon saveeŋ to Yoova isavia padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sawa to tipaes pa kinik to Isip tighaze yes Israela tighau tila wa, yesŋa uraata toni titoor ŋgar todi muul, ve tighaze: “Wai, iit tagham ŋgar to borouŋa! Tapul yes Israela tila pasa? Aazne, sei masin pale tinim mbesooŋa pait?” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tovenen kinik isaav, ve tigharaat hos toman karis toni to malmal. Ve iyou ndaaba toni, leso tila tomani. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ve igham karis ariaŋadi to malmal toman hos irau 600, ve igham karis toman hos pida paam to yes Isipa, ve yes ndiran to malmal to tindandaloov karis. Ghoro toman ndaaba toni tisob timundig ve titaghon yes Israela tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Sawa to yes Israela tipul Isip, lolodi poia kat, ve tigham ŋgar tighaze Maaron todi ilib pa yes Isipa wa. Tovenen tilaagh toman pakuruuŋ. Eemoghon Yoova igham kinik to Isip ŋgar toni iyaryaaŋ muul. Tauto iyou ndaaba toni, ve titaghon yes Israela tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Tovenen yes ndaaba to Isip tigham karis toman hos, ve ndiran pida to malmal, ve titaghon yes Israela tila le tivot todi igharau ndug to yes Israela atedi izi pani. Ineep izi naari to ndug Pi Airot ve ndug Bal Zepon. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yes Israela matadi ila le tighita kinik to Isip yesŋa ndaaba toni tiŋarua di tinim. Tovenen matughezaaŋ tiina igham di, ve titaŋ roran Yoova pa iuul di. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ve tiŋooŋ pa Mose tighaze: “Ugham ghei nipul Isip pasa? Vena, naal to yes Isipa irau ghei maau, tauto ughereb ghei ninim ndug balim tonene, leso nimatmaat izi sualen? ");
INSERT INTO tuc_o_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ŋgar tonene to nimatughez pani. Tauto sawa to tanepneep izi Isip, yei nisaav payom nighaze: ‘Tambaŋa. Upul ghei nineep, ve nigham uraat pa yes Isipa.’ Eemoghon yom ulooŋ ghei maau. Inimale nineep izi Isip ve nimbesmbees padi, tone poia. Eemoghon maau. Aazne, pale nisob nimatmaat izi ndug balim tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Eemoghon Mose irab motin saveeŋ todi ighaze: “Amatughez malep. Ayoon ariaŋa! Aazne, yam pale aghita katin ulaaŋ to Yoova. Pasa, ye tau pale ivool tiam, ve igham mulin gham. Yes Isipa to aazne matamim ila padi we, muri pale aghita di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tovenen atemim izi ve aghur matamim moghon. Pasa, Yoova tau pale iparab payam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ghoro Yoova isaav pa Mose ighaze: “Pughu vena to yom utaŋ roran ghou ne? Usaav pa yes Israela timundig tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ghoro uit titi tiom iza, ve upatooŋa iŋarua te. Leso te ivalagi. Pida ila pa ŋas, ve pida ila pa waan, ve ighur ataam pa yes Israela, ve tilaagh ila taan mamaasa, ve tivool tila pa dige ite. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","You pale nagham yes Isipa ŋgar todi iyaryaaŋ ve titaghon gham. Ghoro napatooŋ tapirig pa kinik to Isip toman ndaaba toni to tilaagh taan, ve yes to tilaan pa hos ve karis, ve natatan di le tisob kat. Leso nagham izag ivot inim tiina, ve yes Isipa tighilaal tighaze you Yoova nanepneep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ghoro aŋela to Maaron to imuŋmuuŋ pa yes Israela, ipul ina to muŋgaaŋ, ve imuul ila pa muridi. Ve yaghur tae mala to imuŋmuuŋ padi ne paam, imuul ila iyoon izi muridi, ");
INSERT INTO tuc_o_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ve ineep bodbodaaŋ pa yes Israela ve yes Isipa. Mboŋ izi, ve yaghur tae tonowen ndorooma tiina ila pa yes Isipa, ve ghazooŋa ila pa yes Israela. Tovenen mboŋ tonenen, yes Isipa irau tila tigharau yes Israela maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","22","Ghoro Mose iit nima iza, ve ipatooŋa ila pa te, ve Yoova igham yaghur tiina ilaagh pa taan dige to ila pa ndag iza ve inim. Yaghur ilaagh pa mboŋ mboŋ le ndugizau, ve iviviir te le ivalagi inim ru. Pida ila pa waan, pida ila pa ŋas, ve taan mamaasa ivot. Te dige ru tonowen tiyoon deŋia tinimale didiiŋ, ve yes Israela tilaagh ila bodbodaaŋ. Tovenen tilaagh titaghon taan mamaasa tonowen, ve tivool tila pa dige ite. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ghoro ndaaba tisob to Isip toman hos ve karis todi titaghon di tinim tivot izi bodbodaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ndag iza ris, ve Yoova ineep ila yaghur tae mala ve yab yama lolo, ve mata izi pa yes Isipa, ve ighamun ŋgar todi le tiwaghamgham. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ve igham hos toman karis todi aghedi tiptipia, leso tizuar pa landooŋ. Ve igham karis aghedi ipaspas ve titaptap tizizi. Tovenen yes Isipa tisaav tighaze: “Ee-e, tala malep! Tamuul! Nene Yoova tau, to ivool to yes Israela ve iparab toman ghiit ne!” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ghoro Yoova isaav pa Mose ighaze: “Uit nimam iza, ve upatooŋa ila pa te. Leso te ila ivool muul, ve itatab yes ndaaba to Isip tonowen toman karis ve hos todi, le tisob timatmaat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","28","Tovenen ndag ipul te ve iza ris, ghoro Mose iit nima iza muul, ve ipatooŋa ila pa te. Ghoro te ipol inim ilupi muul. Yes Isipa to titaghon yes Israela, titoova pa tighau timuul tila. Eemoghon tiraua maau. Te itatab ndaaba to kinik toman karis ve hos todi, le tisob tilaledi. Eta ineep maau. Ataam tonene, to Yoova ipandalin ndaaba tisob to Isip tizila te lolo ve timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Eemoghon yes Israela tilaagh ila taan mamaasa to ineep bodbodaaŋ to te, le tivool tila pa dige ite. Te dige ru tonowen tiyoon kat tinimale didiiŋ. Pida ila pa waan ve pida ila pa ŋas. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Nene ataam to Yoova igham mulin yes Israela ila yes Isipa nimadi. Yes Isipa to timatmaat, yes Israela tighita patudi tiwaghengheen taghon naari. ");
INSERT INTO tuc_o_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Onoon kat, Yoova ipatooŋ tapiri tiina pa yes Isipa, ve yes Israela tighita pa matadi. Tauto timatughez pa Yoova, ve tighur ila toni. Ve tighur ila to mbesooŋa toni Mose paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ghoro Mose yesŋa Israela timbou mbouŋ tonene pa tipait Yoova. “You pale nambou ve napait Yoova. Ye iza tiina le tiina kat. Ye iparab ariaŋa le ilib pa koia. Ye ipiyaav hos todi toman yes to tilaan padi ne tizila te lolo ve tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","You naghamgham tapirig ila to Yoova. Tovenen nambou mbouŋ pa napaiti. You irau nalaleg. Eemoghon ye igham mulin ghou. Ye moghon to Maaron tiou. Tovenen naghaze napait iza pa poia toni. Muuŋ, tamaŋ imbesmbees pani. Ve you paam napait iza izala le izala kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tiina tiou, ye ŋgeu ariaŋa to malmal. Iza Yoova. Ye inepneep irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ye ipiyaav kinik to Isip ndaaba toni toman karis todi tisob tizila te lolo ve tilaledi. Ve yes daba to tiraua kat pa malmal, yes paam tighun te ve tisob timatmaat izi Te Kaviaaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Te itatab di ve tindal tizila tinimale yaam. Tizila kat to mazovan bibiliiŋa lolo we. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Yoova, nimam waan, nene tapiri tiina le tiina kat. Nimam waan irab mbirisan koiamŋa le tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Yom izam tiina kat. Ulib pa mbeb tisob. Koiamŋa to timundig tighaze tizoor ghom, yom ureu mbirisan di. Upatooŋ mbalmbali tiom padi, ve iwaghamun di inimale yab ighan kikiliiŋ gorgori. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Yom atem yabyab padi kat. Tauto ugham yaghur tiina imundig ve ivalag te. Pida ila pa ŋas, ve pida ila pa waan. Dige ru tonowen tiŋgud tiza ve tiyoon kat tinimale didiiŋ. Te to mazovan iyoon le iyaryaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Koiamai tigham tinidi tighaze: ‘Yei pale nigham taghon yes Israela le nikis di. Ghoro niyou mburuguuŋ todi tisob, ve nirei di irau ghei. Sa pataŋani to nighaze nigham padi, nene pale nighami moghon. Tovenen yei pale nipas buza tiei, ve nipatooŋ tapirimai padi, ve nireu mbirisan di.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Eemoghon Yoova, yom uvib avuvum inim yaghur ve iviviir te. Tauto itatab di le tisob tindal tizila mazovan lolo rikia moghon tinimale yaam to pataŋani le pataŋani kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yoova, sa maaron to irau ghom? Eta maau. Yom paghunam ve patabuaŋ kat. Ve ugham uraat tintina toman mbeb gharatooŋadi. Tauto tamtoghon timatughez payom, ve tipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Yom urab koiamŋa pa nimam waan, ve ugham taan avo ikaak, ve itoon di tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Yoova, yom lolom ineep tuŋia ila to tamtoghon tiom, ve uluul di itaghon saveeŋ mbuaaŋ tiom. Tauto uvool todi, ve ugham mulin di pa pataŋani todi. Ve yom umuuŋ ve upatooŋ ataam padi. Tovenen yom pale uŋgin di pa tapirim ve ugham pooz padi, le tila tivot izi inam patabuaŋ to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yes ndug ndug tilooŋ uraat tiom varu, le ruŋadi iza pani ve lolodi imbumbu. Matughezaaŋ tiina igham yes Pilistia ve tisaŋeeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ve daba tisob to Edom paam, matughezaaŋ tiina igham di. Yes pooza to Moap tilooŋ varum, le tinidi irur, ve lolodi imbumbu. Ve yes Kanaana tapiridi isob kat ve tinidi imatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","O Yoova, yes tiwatag: Tapirim, nene tiina kat. Tauto matughezaaŋ tiina igham di, ve lolodi imbumbu. Yom taum ugham mulin yei Israela ve ninim lem kat. Tovenen ndug ndug tineep moghon tinimale yaam, ve timbatut ghei, ve nimbut naghodi ve nila nigham taan tiei. Irau tigham mbeb eta payei maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Yoova, yom ugham ghei ninim nineep pooi izi lolooz tiom. Lolooz tonene, nene inam patabuaŋ to nepooŋ. Pasa, yom upayoon rumai tiom izala. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yoova, ye kinik tiina kat. Ye pale igham pooz itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tovenen Yoova ivalag Te Kaviaaŋa, ve pida ila pa ŋas ve pida ila pa waan, ve yes Israela titaghon taan mamaasa to ineep bodbodaaŋ, ve tivool tila pa dige ite. Eemoghon sawa to ndaaba to kinik tigham hos ve karis todi, ve titaghon di, Yoova igham te ila ivool muul, ve itatab di. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aron livu Miriam, ye propet liva eez. Ye igham kakaap toni ve imuuŋ, ve ndiliva tisob to Israel anadi tigham kakaap todi ve titaghoni, ve yesŋa tigham narogho. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ve Miriam iit mbouŋ tonene padi ighaze: “Ambou ve apait Yoova. Ye iza tiina le tiina kat. Ye iparab ariaŋa le ilib pa koia. Hos todi toman yes to tilaan padi, ye ipandalin di tizila te lolo ve tilaledi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Muri ghoro, Mose isaav pa yes Israela, ve timundig tilaagh muul. Tipul naari to Te Kaviaaŋa, ve tilaagh tilooŋ tila pa ndug balim to tiwaata tighaze ‘Sur.’ Tilaagh izi tonowe irau mboŋ tol, eemoghon tindeeŋ ya eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ghoro tivot ndug kainaŋen eez, iza Mara. Ndug tonowen, ya inepneep. Eemoghon ya tonowen papaii. Tovenen yes Israela irau tighuni maau. Pughu tonene to tiwaat ndug tonowen iza tighaze ‘Mara.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yes Israela timundig ve tiŋooŋ pa Mose tighaze: “Ai, ŋgarsuamai imamaas kat wa. Pale nighun sa?” ");
INSERT INTO tuc_o_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tovenen Mose itaŋ roran Yoova pa ulaaŋ, ve Yoova ipatooŋ ai suruvu eez pani. Mose igham ai tonowen ve ipiyaava izila ya, le ya ipapa muul maau, ve yes irau tighun. Tinepneep tonowe, ve Yoova ighur tutuuŋ pida padi ve ipatooŋ di pa ataam to titaghoni leso tilaagh deŋia ila mata. Ye igham tovene pa itoov di. Leso ighita: Pale titaghon katin aliŋa, ma maau? ");
INSERT INTO tuc_o_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ye isaav padi ighaze: “You Yoova, Maaron tiam. Alooŋ aliŋag ve ataghoni, ve agham ŋgar to deŋia moghon ila matag. Ighaze aghur poian taliŋamim pa tutuuŋ tisob to naghur di, ve ataghon katin di, nene you irau naghur moroghooŋ samia eta payam inimale nagham pa yes Isipa ne maau. Pasa, you Yoova to nagharaat gham pa moroghooŋ tiam ve tinimim popoia.” ");
INSERT INTO tuc_o_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ghoro yes Israela tilaagh tila tivot izi ndug Elim. Ndug tonowen, le taan saambu saaŋgul ve ru to ya ivotvot padi. Ve ai det tamoot tol saaŋgul (70) titub tonowe paam. Ai tonowen anoŋadi poia pa ghaniiŋ. Tovenen tigharaat inadi tonowe, ve atedi izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Muri ghoro, yes Israela timundig ve tipul ndug Elim, ve tilaagh tila tivot ndug balim to iza ‘Siin.’ Ndug tonowen ineep bodbodaaŋ pa Elim ve Sinai. Sawa to tipamundigin laghooŋ todi izi Isip ve tila tivot izi Siin, yes tilaagh irau kaiyo eez ve mboŋ saaŋgul ve liim wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tinepneep tonowe, ve ival tiina to Israel tiŋooŋ pa Mose yesuru Aron muul tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Inimale Yoova irab ghei nimaat izi Isip pataghaaŋ, tone poia! Pasa, sawa to nineep tonowe, nepooŋ tiei poia kat. Nindaad ghei ninepneep, ve nighanghan aniiŋ tiina toman ziga le apomai isuŋ. Vena, yamru aghaze arab ghei nimatmaat pa pitool, tauto aghereb ghei ninim ndug balim tonene?” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tovenen Yoova isaav pa Mose ighaze: “Aazne ve ila, you pale nagham aniiŋ itap sambam ve izilat payam. Mboŋmaagh to naol ne, pale itap sambam ve izilat. Tovenen ighaze yam ala ayou amim, ayou tiina malep. Ayou irau to aghan pa ndag ee moghon. You nagham tovene pa natoov gham. Leso naghita: Pale ataghon aliŋag, ma maau? ");
INSERT INTO tuc_o_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ighaze uraat inim liim ve eez, ghoro ayou tiina ris, irau to aghani pa ndag ru, ve anazi pataghaaŋ ve ineep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","7","Tovenen Mose yesuru Aron tisaav pa tamtoghon tisob to Israel tighaze: “Yei nigham sa, to atemim yabyab ve ayou avomim payei? Yei nisaav to tanim ne? Yam aŋooŋ payei, eemoghon Yoova ilooŋ ŋoŋaaŋ tiam wa. Tovenen rabrab izi, ghoro ye pale igham ŋgar eta payam. Leso awatag kat aghaze ye tau, to igham gham apul Isip ve anim sualen. Ve ndugizau, ghoro ipatooŋ tapiri ve poia toni payam, ve aghita pa taumim matamim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ghoro Mose isaav padi muul ighaze: “Yei sei, to aŋooŋ payei? Sawa to ayou avomim payei, yam aŋooŋ payei maau. Aŋooŋ pa Yoova. Ve ŋoŋaaŋ tiam tonanan, ye ilooŋa wa. Tovenen rabrab izi, ghoro ye tau pale igham amim man pa aghan. Ve mboŋmaagh, ghoro igham amim aniiŋ, leso aghan ve apomim isuŋ.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ghoro Mose isaav pa Aron ighaze: “Ula usaav pa yes Israela tovene: ‘Yoova ilooŋ ŋoŋaaŋ tiam wa. Tovenen yam asob anim alup gham ila Yoova nagho.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aron isavsaav pa ival tiina to Israel, ve matadi ila pa ndug balim, le tighita Yoova ŋguruba isul ila yaghur tae lolo. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ghoro Yoova isaav pa Mose ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ŋoŋaaŋ to yes Israela, you nalooŋa wa. Tovenen usaav padi: Rabrab ndag izila goroŋia, ghoro adi aniiŋ ziga izilat. Ve bozo pale aniiŋ izilat, ve tighan le apodi isuŋ. Leso tiwatag kat tovene: You Yoova, Maaron tiam, nanepneep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Yes Israela tineep le rabrab izi, ghoro man katindi tivot le ndug to tineep pani ne man moghon. Mboŋ le ndugizau, ve waam izi irau ndug to tineep pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Waam imamaas, ve yes Israela tighita mbeb pisosooŋa itatab ndug todi. Ghitooŋa inimale iigh anuvu. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tighita mbeb tonowen, ve tikankaan pani. Tovenen tiwaghasonin di tighaze: “Nene sa?” Mose isaav padi ighaze: “Nene aniiŋ to Yoova igham payam pa aghani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ve ye ighur tutuuŋ payam tovene: Tamtoghon piiz to tilup di ila mbeez ee moghon, nene tipavonin uur gegegeu eŋaeŋa le irau di. Atedi imot pa youŋ aniiŋ malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Tovenen yes Israela tila, ve tiyou adi aniiŋ. Pida tiyou tiina, ve pida tiyou ris. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Eemoghon sawa to titoov aniiŋ ve tighita piiz to tigham di, nene tighita yes tisob adi aniiŋ irau di. Tovenen yes to tiyou tiina, tighan le tipasobi. Avodi alulu rita ineep maau. Ve yes to tiyou rismoghon, tovene paam. Timbool maau. Tighan le apodi isuŋ. Tovenen aniiŋ to tiyou di, nene irau di. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose isaav padi ighaze: “Aniiŋ tonene, aghani le isob. Aghur pida inim ŋaar pa bozo malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Eemoghon tamtoghon pida tizoor Mose aliŋa, ve tighur aniiŋ pida inim ŋaar. Ŋaar todi tonowen ineep le ndugizau, ve iŋaraaŋ. Ve tighita motmoot tineep ila. Mose ighita ŋgar to tighami, le ate yabyab kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tovenen mboŋmaagh to naol ne, yes Israela tilala ve tiyouyou adi aniiŋ irau di. Ve aniiŋ pida to tipuli izi ineep ila taan, sawa to ndag iza inim ve ndug ituntun, nene ireer ve ilale. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ve ndag inim liim ve eez, nene tiyou aniiŋ irau to tighan pa ndag ru. Tovenen ŋginiiŋa to yes Israela tila tighita Mose, ve tipaesia mbeb tonenen pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ye isaav padi ighaze: “Alooŋ. Yoova isaav tovene: Bozo, nene umbom patabuaŋ. Tovenen iit irau ateed izi. Irau tagham uraat eta maau. Tovenen aazne, yam atar taumim pa amim aniiŋ pataghaaŋ. Ighaze anazi, ma amozi, nene ineep to yam taumim. Aghan pida aazne, ve pida ineep pa bozo.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tovenen yes Israela titaghon Mose aliŋa, ve tighur aniiŋ todi pida inim ŋaar. Mboŋ le ndugizau, ghoro tighita ŋaar todi tonowen poia. Iŋaraaŋ maau, ve motmoota maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose isaav padi ighaze: “Aazne, yam irau aghita aniiŋ eta ineep izala taan pogho maau. Pasa, nene umbom patabuaŋ to Yoova ighuri pait leso ateed izi. Tovenen aghan aniiŋ to noor aghuri inim ŋaar ne. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ndag inim eez, ila imuul ndag inim liim ve eez, aniiŋ pale ivotvot tovene, leso ayou amim. Eemoghon ndag inim liim ve ru, nene pale maau. Pasa, nene umbom patabuaŋ to Yoova ighuri pait, leso ateed izi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Eemoghon tamtoghon pida tizoor Mose aliŋa. Ndag inim liim ve ru to umbom patabuaŋ, yes tila tighaze tiyou adi aniiŋ. Eemoghon matadi ines le maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tovenen Yoova isaav pa Mose ighaze: “Yam taliŋamim maau? Pale ŋeez o apul ŋgar tiam to zoraaŋ saveeŋ, ve ataghon katin saveeŋ tiou toman tutuuŋ tiou? ");
INSERT INTO tuc_o_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Aghita. You naghur umbom patabuaŋ payam, leso inim lemim sawa to atemim izi. Tovenen wik to naol ne, ndag inim liim ve eez, ghoro you pale nagham amim aniiŋ to irau pa ndag ru pataghaaŋ. Ve ndag to inim liim ve ru, ghoro yam asob aneep moghon ila inamim. Ala ndug eta malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tauto ndag inim liim ve ru, yes Israela titaghon Maaron aliŋa tonenen, ve atedi izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Aniiŋ to Yoova igham pa yes Israela, tiwaata tighaze ‘manna.’ Aniiŋ manna, nene pisosooŋa ve ghitooŋa inimale mbeb pida uvedi. Ve ghaniiŋa poia kat, inimale palawa to titoora toman bagil suru. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose isaav pa yes Israela muul ighaze: “Yoova isaav ariaŋa pait ighaze tagham uur eez, ve tapavonini pa aniiŋ manna tonene, ve takisi ineep. Leso inim matamuri pa papaghu toit to muri pale tivot. Ighaze tighita, yes pale tiwatag: Sawa to Yoova igham nditimbudi tipul Isip ve tilaghlaagh izi ndug balim, ye ipanpan di pa aniiŋ tovene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Tovenen Mose isaav pa Aron ighaze: “Ugham uur eta, ve ula upavonini pa aniiŋ manna. Le isob, ghoro ughuri ineep izi Yoova nagho. Leso takisi ineep tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tovenen Aron itaghon saveeŋ tonenen, ve ighur manna pida ila uur, ve tighuri ineep izi Bokis to Saveeŋ Mbuaaŋ nagho inim matamuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Yes Israela tighanghan aniiŋ manna irau ndaman tamoot ru. Tineep ila manna moghon le irau tila tivot taan Kanaan dige. Ghoro aniiŋ tonenen izi muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ghoro ival tiina to Israel tipamundigin laghooŋ todi muul. Tipul ndug balim to iza ‘Siin,’ ve tilaghlaagh titaghon Yoova aliŋa. Tighamgham tovene le tila tivot ndug eez, iza Repidim. Ghoro atedi izi tonowe. Eemoghon ndug tonowen, ya maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tovenen tiŋooŋ pa Mose tighaze: “Ughita amai ya ve nighun lak!” Mose ipamuul aliŋadi ighaze: “Pughu vena to atemim yabyab ve aŋooŋ payou? Yam aghaze atoov Yoova tapiri?” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Eemoghon Israela murun di le tisami kat. Tovenen tiyou avodi pa Mose tighaze: “Pughu vena to ugham ghei nipul Isip, ve ughereb ghei ninim sualen? Ughaze yeiŋa ndinatumai ve ŋgai tiei nisob nimatmaat pa ya izi sualen?” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tovenen Mose itaŋ roran Yoova ighaze: “O Yoova, ughita. Paam tamtoghon tonene tirab ghou pa yaam! Pale nagham vena padi?” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","6","Yoova ipamuul Mose aliŋa ighaze: “Ugham ndolman pida to yes Israela, ve yamŋa amuuŋ anim tiou izi lolooz Sinai pughu. Sawa to unum, matam iŋgal titi tiom to ulos ya Nil pani, ve ukisi. You pale naneep izala yaam tiina eez pogho, ve nasaŋan gham. Yam anim avot, ghoro ugham titi tiom ve ulos yaam to nanepneep izala pogho. Ya pale ireer ivot pani, leso ival tiina to Israel tighun.” Tovenen Mose igham ndolman pida ve yesŋa tila, ve tighita Mose ilos yaam tiina tonowen pa titi toni itaghon Yoova aliŋa, ve ya ireer ivot. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ndug tonowen, Mose iwaat iza ighaze ‘Masa’ ve ‘Meriba.’ Pasa, sawa to yes Israela tineep tonowe, tiŋooŋ pani, ve titoov Yoova tighaze: “Ye ineep toman ghiit onoon, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yes Israela tinepneep izi ndug Repidim, ve yes Amaleka tinim tighaze tiparab toman di. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tovenen Mose isaav pa Yosua ighaze: “Uvureer tamtoghon toit pida to tiraua kat pa malmal, ve yamŋa agharaat gham. Leso bozo ala aparab toman yes Amaleka. You pale nakis titi to Maaron, ve nazala nayoon izala ndug mbuŋa tonowen.” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tovenen Yosua itaghon Mose aliŋa, ve igham yes Israela ve tila tiparab toman yes Amaleka. Ve Mose yesuru Aron ve ŋgeu ite, iza Hur, yes tol tizala tiyoon ila ndug mbuŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Sawa to Mose ikaak nima ru iza, yes Israela tilib pa yes Amaleka. Eemoghon sawa to nima ipaspas ve izi, ghoro yes Amaleka anadi tilib pa yes Israela. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose ikaak nima iza ila ila le nima ipaspas kat. Tovenen Aron yesuru Hur tighita yaam eez, ve tighur Mose mbole izala. Ghoro tiit nima ru iza, ve eez ipalot nima waan, ve ite ipalot nima ŋas. Tipaloti tuŋia ve nima inepneep sala tovene le ndag izila. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tauto Yosua yesŋa yes Israela tiparab ariaŋa pa buza todi le tilib pa yes Amaleka. ");
INSERT INTO tuc_o_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ghoro Yoova isaav pa Mose ighaze: “Ulooŋ. Muri, you pale napasob yes Amaleka pa taan, le irau tamtoghon matadi iŋgal di muul maau. Aliŋag tonene, umbooda ila rau. Leso yes Israela matadi iŋgali itaghoni taghoni gha ila. Ve usaav ariaŋa pa Yosua, leso mata kisini paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Yoova isavsaav le isob, ghoro Mose igharaat artaal eez, ve iwaat iza ighaze: “Yoova, ye pilak tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ve Mose isaav muul ighaze: “Yes Amaleka tigham tinidi ve tipatooŋ nimadi pa Yoova. Tovenen ye tau pale iparab toman di itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mose rawa Yetro, ye ŋgeu to ighamgham uraat pa watooŋrau to yes Midiana. Ye ineep izi ndug toni, ve ilooŋ Mose yesŋa tamtoghon toni Israela varudi pa uraat tintina naol to Maaron igham padi, ve ataam to Yoova igham di tipul taan to yes Isipa. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Tovenen ighaze ila ighita Mose. Sawa tonenen, Mose azuwa Sipora toman ndinatu ru tinepneep toman Yetro. Pasa, Mose ighur di tila tineep tomani muuŋ wa. Tovenen sawa to Yetro imundig ila pa ighita rawa, ye igham di ve yesŋa tila. Mose ndinatu ru. Eez iza Gersom, ve ite iza Eliezer. Izadi tonene, ledi pughudi. Sawa to natu aidaba izi, Mose isaav ighaze: “Muuŋ, naneep nanim loom to ipul tau ndug toni.” Tovenen iwaat natu olman iza Gersom. Ve sawa to tipoop natudi ite, Mose isaav ighaze: “Maaron to tamaŋ iuul ghou ve ipaghau ghou pa kinik to Isip buza toni mata.” Tauto iwaat natu muria iza Eliezer. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Tovenen Yetro igham Mose azuwa toman ndinatu ru, ve yesŋa tila tivot to Mose izi ndug balim to igharau Maaron lolooz toni. Sawa tonenen, yes Israela atedi izi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetro imbaaŋ ila pa rawa Mose ighaze: “You nagham azuwam toman ndinatum ru ve yeiŋa ninim nivot wa.” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose ilooŋ saveeŋ tonene, ve imundig ila ighaze ighita rawa. Ila ivot todi, ve itud pa Yetro inimale pakuruuŋi. Ghoro iyaŋin pani, ve tiwaghasonin di pa nepooŋadi, Le isob, ghoro Mose igham di tila pa mbeez toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose ipaes pani pa pataŋani naol to Yoova ighur di pa kinik toman ival tiina to Isip, pa iuul yes Israela. Ve ipaes pani paam pa pataŋani naol to tivot pa yes Israela izi ataam luvuŋa, ve ataam to Yoova igham mulin di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro ilooŋ saveeŋ toni, le lolo poia kat pa ŋgar popoia naol to Yoova ighamgham pa yes Israela, ve ataam to igham mulin di ila yes Isipa nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","11","Tovenen isaav pa Mose ighaze: “You napait Yoova pa poia toni! Muuŋ, sawa to yam aneep ila kinik to Isip toman tamtoghon toni sambadi, yes titatan gham ve tigham samin gham kat. Eemoghon Yoova igham mulin gham ila nimadi wa. Tovenen aazne, you naghilaal kat naghaze: Yoova, ye ilib pa ndimaronŋa tisob!” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ghoro Mose rawa Yetro igham mbeb pida, ve irab di tinim watooŋrau pa Maaron. Ye igham dodoli eez ila yab ighan suvuni, ve imoz pida, leso tamtoghon tighan ve yesŋa Maaron tilup di tinim ee moghon. Tovenen Yetro, Mose ve Aron toman ndolman to yes Israela tisob tilup di ila Maaron nagho pa suŋuuŋ toman ghanghaniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mboŋ ndugizau, ghoro Mose ipamundigin uraat toni to gharatooŋ pataŋani to tamtoghon. Ival tiina tiyondyood luvutini, ve tisasaŋani pa igharaat saveeŋ todi to mboŋmaagh le ila rabrab izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yetro ighita uraat to rawa Mose ighamghami pa iuul yes Israela, nene tiina kat. Tovenen isaav pani ighaze: “Wai, yom ughamgham sa pa yes tamtoghon tonene? Pughu vena to eŋgengom ugharaat saveeŋ todi? Ughita. Ival tiina tonene tiyondyood luvutin ghom ve tisasaŋan mboŋmaagh le ila rabrab izi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose ipamuul aliŋa ighaze: “Tamtoghon tighaze tiwatag ŋgar to Maaron lolo pani. Tauto tinim tiou. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ve ighaze tiwazoran di pa saveeŋ eta, nene tinim tiou, leso nalooŋ pataŋani todi ve nagharaata. Ve you leg uraat to napatoot di pa Maaron aliŋa ve tutuuŋ toni paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tovenen rawa Yetro isaav pani ighaze: “Nene poia. Eemoghon naghita ataam to utaghoni pa uraat tiom, nene pataŋani. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Pasa, uraat tonene, tiina kat. Eŋgengom irau uraua maau. Pale unoknoki tovene le tapirim isob. Ve tamtoghon paam, pale tisaŋan tisaŋan le saŋaniiŋ isooŋ di. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","“Ulooŋ. You naghaze nauul ghom pa ŋgar pida, leso uraat tonene iraurau payom. Ataam to naghaze nasavia payom, ighaze utaghoni, nene pale Maaron ineep toman ghom, ve iuul ghom pa uraat tiom. Yo, ighaze tamtoghon pida tiwazoran di pa mbeb eta, yom irau ugham naghodi, ve usavia pataŋani todi ila to Maaron. Ve sa saveeŋ to ighaze ye isavia payom, ghoro upaesia padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ve yom irau upatoot di pa Maaron aliŋa ve tutuuŋ toni. Ve upasaluŋgan di, leso laghooŋ todi poia ila Maaron mata, ve titaghon ŋgar to ye lolo pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ve yom irau uŋgabiiz poian tamtoghon tisob to Israel, ve uvureer tamtoghon popoiadi pida, leso tiuul ghom pa uraat to ŋginiiŋ ival tiina tonene. Yes to avodi kaarom, ma matadi mbeb, ughur di malep. Ughita yes to avodi onoon, ve timatughez pa Maaron ve titaghon ŋgar toni, ghoro ughur di tiuul ghom pa uraat. Ughur pida tiŋgin tamtoghon ndiŋndiŋ ndiŋndiŋ eez (1000), pida tiŋgin tamoot liim (100), pida tiŋgin tamoot ru saaŋgul (50), ve pida tiŋgin tamtoghon saaŋgul moghon. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Uraat to gharatooŋ saveeŋ ve pataŋani to tamtoghon, nene pale inim daba tisob tonenen ledi uraat, ve tighamghami tovene itaghoni gha ila. Yes pale tigharaat saveeŋ rauraua, leso tiuul ghom pa uraat tonene ve iraurau payom. Eemoghon saveeŋ pataŋani, nene yes irau tipuli ilat nimam, leso taum ugharaata. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ŋgar tonene, Maaron ighaze yom utaghoni. Ighaze ugham tovene, nene pale uraat ipataŋan payom kat maau. Ve tamtoghon tisob to tilat toman pataŋani todi, pale timuul tila pa inadi toman lolodi poia.” ");
INSERT INTO tuc_o_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose ilooŋ rawa aliŋa, ve itaghon ŋgar isob to ye isavia. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ye iŋgabiiz tamtoghon tisob to yes Israela, ve ivureer yes to ledi ŋgar popoia ve tirau uraat to ghamuuŋ pooz, ve ighur di tinim daba, leso tiuuli pa uraat to gharatooŋ saveeŋ. Pida tiŋgin tamtoghon ndiŋndiŋ ndiŋndiŋ eez (1000), pida tiŋgin tamoot liim (100), pida tiŋgin tamoot ru saaŋgul (50), ve pida tiŋgin tamtoghon saaŋgul moghon. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tovenen ndag to naol ne, yes tiloŋlooŋ saveeŋ to tamtoghon, ve tighagharaat pataŋani todi ŋgiira ŋgiira. Eemoghon pataŋani tintina, nene tipul di tila Mose nima, leso tau igharaat di. ");
INSERT INTO tuc_o_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yetro ineep ris toman Mose, ghoro Mose ighuri imuul ila pa ndug toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Yes Israela timundig muul ve tipul ndug Repidim, ve tilaagh tila tivot izi ndug balim Sinai. Laghooŋ todi to tipul Isip ve tinim, nene tigham kaiyo ru wa. Ve ite inim tol pani, ndag inim mata, ghoro tila tivot izi lolooz Sinai pughu, ve atedi izi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose ipul di tineep, ve izala pa lolooz, leso yesuru Maaron tisavsaav. Yoova ineep lolooz daba, ve imboob izila pani ighaze: “Usaav pa yes Israela to papaghu to Yakop ne tovene: ");
INSERT INTO tuc_o_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ŋgar to you nagham pa yes Isipa, yam Israela aghita pa taumim matamim wa. Yam awatag: You nambaad gham inimale manbog imbaad ndinatu izala bage, ve nagham gham anim avot tiou izi sualen. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Aazne, ighaze yam alooŋ aliŋag, ve matamim iŋgal saveeŋ mbuaaŋ tiou, ve ataghon katin tutuuŋa, nene pale anim leg kat, ve itiŋa talup ghiit tanim ee moghon. Onoon, taan isob toman tamtoghona, nene you tiou moghon. Ve yam ghoro, taug nasia gham, ve nagham gham anim leg kat. You naghaze yam asob aneep ila pooz tiou samba, ve ambees payou animale ndiran to watooŋrau. Leso anim tamtoghon tiou patabuaŋa.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yoova isavsaav le isob, ghoro Mose imuul izila to yes Israela. Ila ivot todi, ve ipoi ndolmana todi tinim tilup di, ve ipaesia Yoova aliŋa isob tonenen padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Yes tilooŋ saveeŋ toni, ve tisob tilup avodi tighaze: “Poia, saveeŋ isob to Yoova isavia, yei pale nitaghoni.” Tovenen Mose imuul izala to Yoova, ve ipaesia yokiiŋ todi pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yoova isaav pani ighaze: “Ulooŋ! You pale naneep ila yaghur tae asosooŋa lolo ve nalat tiom, ve nasavsaav toman ghom ve ival tiina tilooŋa. Leso tighur ila saveeŋ tiom ve titaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Mose ipaesia yes Israela aliŋadi pa Yoova le isob, ghoro Yoova isaav pani ighaze: “Umuul uzila, ve usaav padi tovene: Aazne ve bozo, yes irau timen nonogiiŋa todi ve tigharaat di, leso tiŋgalaaŋ ila matag, ve tisasaŋan. Pasa mboŋru, ghoro yes Israela pale tisob tighita ghou nazi nanim ve naneep izala lolooz Sinai daba. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Tovenen uŋgun saŋguyaŋ iluvut lolooz pughu, leso tamtoghon tineep saguan. Ve usaav ariaŋa padi, leso tiza tinim lolooz sob, ve titut lolooz pughu rita malep. Ighaze tamtoghon eta ilaagh inim le ivazag lolooz pughu, yam arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ve ataam to rabuuŋ, nene arabi pa nimamim malep. Aneep saguan, ve arabi pa yaam, ma avanegi. Tovenen ighaze tamtoghon eta, ma ŋgai eta itut lolooz pughu, nene irau ineep maau. Yam arabi imaat. Saveeŋ tonene pale ineep tovene le irau alooŋ tavuur itaŋ le mala, ghoro yam irau azala lolooz.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Yoova isavsaav le isob, ghoro Mose ipul lolooz daba, ve imuul izila to yes Israela, ve isaav padi ighaze timen nonogiiŋa todi ve tigharaat taudi, leso tiŋgalaaŋ ila Yoova mata, ve tisasaŋan. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ve ipaes padi ighaze: “Aazne ve bozo, yam agharaat taumim ve asasaŋan. Agheen toman ndiliva malep. Pasa mboŋru, ghoro Yoova izi inim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tinepneep le mboŋ ru isob, ve mboŋmaagh, ghoro yaghur tae asosooŋa inim ikau lolooz daba. Ve ndug milia, ve lalaav irabrabi. Ve mbeb eez itaŋ inimale tavuur, eemoghon avolutu tiina kat. Tovenen yes Israela tisob timatughez le tapiridi isob. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose igham di tipul ndug todi to nepooŋ, ve tila tiyoon tigharau lolooz pughu, leso yesŋa Maaron tilup di. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","19","Ghoro Yoova izi inim toman yab tiina izala lolooz Sinai daba, ve mbuas tiina ikau lolooz le tighita muul maau. Ve yoŋgyoog tiina itok, le lolooz katkatia ilala inimnim. Ve mbeb to itaŋ inimale tavuur, itaŋtaŋ ve indurnduur inim inim le avolutu ivot inim tiina kat. Ghoro Mose isavsaav toman Maaron. Ve sawa to Maaron ipamuul saveeŋ toni, aliŋa inimale lalaav avolutu. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Tovenen Yoova izi inim ineep izala lolooz Sinai daba, ve ipoi Mose ighaze izala toni tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Tovenen Mose izala toni, ve Yoova isaav pani ighaze: “Umuul uzila, ve uveivei pa ival tiina tovene: Tizoorndug pa tiza tinim tighita ghou malep. Pasa, ighaze tiza tinim, nene pale tamtoghon katindi timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Yes ndiran to watooŋrau paam. Ighaze lolodi tighaze tinim tigharau ghou, nene yes irau tigharaat taudi le tiŋgalaaŋ kat. Le isob, ghoro tinim tivot tiou. Ighaze tigharaat taudi maau, nene pale ateg yabyab padi, ve narab di tilaledi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose isaav pa Yoova ighaze: “Tamtoghon eta irau iza inim lolooz tonene maau. Pasa, yom taum usaav ariaŋa payei ughaze niŋgun saŋguyaŋ iluvut lolooz pughu, leso tamtoghon tighita lolooz tonene inimale ndug patabuaŋ ve tiroron pani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yoova isaav pani muul ighaze: “Poia. Umuul uzila ugham togham Aron, ve yamru moghon aza anim. Eemoghon yes ndiran to watooŋrau toman ival tiina to Israel tizoorndug pa tiza tinim tighita ghou malep. Ighaze tiza tinim, nene pale ateg yabyab padi, ve narab di tilaledi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Yoova isavsaav le isob, ghoro Mose imuul izila, ve ipaesia aliŋa pa yes Israela. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Maaron isavia saveeŋ isob tonene iŋarua yes Israela eŋaeŋa ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“You Yoova, Maaron tiom. Muuŋ, yom unum mbesooŋa sorok izi taan to Isip. Eemoghon you nagham mulin ghom, tauto upul ndug to pataŋani tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Yom irau umbees pa you eŋgengou. Ughur maaron ite paam imuuŋ payou ve umbees pani malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ve ugharaat mbeb eta ve ughuri inim Maaron payom malep. Sa mbeb to tineep sambam, taan, ve te lolo, ugharaat eta nagho, ve ughuri inim maaron payom, ve umbees pani malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","6","Uput aghem pa mbeb eta tovene ve umbees pani malep. Pasa, you Yoova moghon, to Maaron tiom. Matag pariuuŋ. Naghaze tamtoghon tiou timbees pa you eŋgengou moghon. Yes to tighur koi payou, nene pale matag kisin sosor todi, ve naghur atia iza to yes taudi, toman ndinatudi, nditimbudi, ve saas todi. Eemoghon yes to tighur lolodi payou ve titaghon tutuuŋ tiou, nene pale lolog ineep tuŋia ila todi ve papaghu todi, ve poia tiou izaza todi itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“You Yoova, Maaron tiom. Uwaat sorokin izag malep. Pasa, tamtoghon to ighaze iwaat sorokin izag, ma ipariaaŋ saveeŋ kaarom ila you izag, nene irau naghurghuri maau. Pale naghur atia iŋarua pa sosor toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Matam iŋgal umbom to Maaron ve upatab pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","10","Tovenen ndag inim eez, ila imuul ndag inim liim ve eez, nene sawa to ugham uraat tiom. Ve ndag inim liim ve ru, ghoro yom irau upul uraat tiom tisob tineep, ve upatab pani. Pasa, nene umbom patabuaŋ to Yoova, Maaron tiom. Tovenen yamŋa ndinatum, mbesooŋa tiom, ŋgai tiom, ve yes loomba to tineep toman ghom ne paam, yam asob irau apul uraat tiam ineep, ve atemim izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pasa, sawa to you Yoova naghur sambam, taan, ve te, toman mbeb tisob to tineep ila, nagham uraat irau mboŋ liim ve eez moghon, ve napasob uraat tonenen. Ve sawa to inim liim ve ru, ateg izi. Tauto napait sawa tonenen, ve naghuri inim umbom patabuaŋ, ve naghur poia tiou ineep izala. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Matam loŋloŋaiŋa pa tamam ve tinam, ve utandag padi. Leso uneep mala izi taan to you Yoova, Maaron tiom, pale nagham payom. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Urab tamtoghon imaat malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Ughur maat malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Uyub malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Upariaaŋ saveeŋ kaarom pa uwaghamun itam ite malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Lolom igham pa nditam ruum todi malep. “Ve lolom igham pa ndizwadi, mbesooŋa, ŋgai, ma mbeb todi ite paam malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yes Israela tilooŋ lalaav avolutu, ve tighita ndug milia, ve tilooŋ mbeb to itaŋtaŋ inimale tavuur, ve tighita yab mbuasa asosooŋa ikau lolooz, le timatughez ve tinidi irur. Tovenen tiyoon saguan pa lolooz pughu, ");
INSERT INTO tuc_o_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ve tisaav pa Mose tighaze: “Yom irau ugham Maaron avo, ve upaesia aliŋa payei. Pasa, yei nimatughez. Ighaze ye tau isavsaav toman ghei, nene pale nisob nimatmaat!” ");
INSERT INTO tuc_o_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose isaav padi ighaze: “Amatughez malep. Aazne, Maaron izi inim itaghon ataam tonene, pa ipatooŋ tapiri payam, leso awatag katini ve amatughez pani, ve agham sosor muul sob.” ");
INSERT INTO tuc_o_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tovenen ival tiina to Israel tiyoon saguan pa lolooz pughu, ve Mose eŋgeni imuul izala, le ila igharau yaghur tae asosooŋa to Maaron ineep ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ghoro Yoova isaav pa Mose ighaze ipaesia aliŋa pa yes Israela tovene: “Yam taumim aghita wa. You naneep sambam, ve aliŋag izilat payam. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ambees pa you moghon. Alup ghou toman maaron kaarom eta malep. Tovenen agharaat maaron kaarom eta pa silva ma gol ve ambees pani malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Yam irau andou taan, ve agharaata inim artaal payou, leso agham watooŋrau tiam izala. Sipsip ve makau tiam to arab di tinim watooŋrau, aghur pida tizala yab, leso yab ighan suvun di. Ve pida, amoz di ve taumim aghan di, leso itiŋa talup ghiit tanim ee moghon. Ndug sine to ighaze you naghuri payam inim inamim to suŋuuŋ, yam irau alup gham pa suŋuuŋ ve apait izag tonowe. Leso matamim iŋgal ghou, ve nanim naneep toman gham, ve naghur poia tiou iza tiam. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ve ighaze andou yaam inim artaal payou, ayou yaam dodolidi moghon. Yaam to ighaze agharaata ve asap dige, nene aghami pa artaal tiou malep. Yaam tovene, poia pa artaal maau. Pasa, nene ndug patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ighaze agharaat artaal eta, izala kat malep. Pasa, ighaze ataghon ndeet azala, nene pale tighita mbolemim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Maaron iseeŋ saveeŋ toni muul ighaze: “Nene tutuuŋ pida to naghaze usavia pa yes Israela. Leso ipatooŋ di pa sa ŋgar to pale titaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ighaze ughol Hibru taamdi eta inim lem mbesooŋa, ye pale imbees payom irau ndaman liim ve eez. Ve ighaze ndaman inim liim ve ru, ghoro upuli ila. Ve upoi pa lem atia malep. Pasa uraat toni, tauto iyat mulin yaam to yom ugholi pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ighaze muuŋ ye ivai maau, ve yom ugholi inim lem, sawa to ighaze upuli ila, ghoro upul eŋgeni ila. Ve ighaze muuŋ ye ivai, ve yom ughol yesuru azuwa tinim lem, upul yesuru tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ve ighaze mbesooŋa eta daba toni igham liva eta pani inim azuwa, ve liva tonenen ipoop, sawa to ighaze mbesooŋa tamoot uraat toni isob, nene pale eŋgeni ila. Azuwa toman ndinatu pale tineep toman daba toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Eemoghon ighaze mbesooŋa tonenen isaav ghazooŋa ighaze: ‘You lolog pa daba tiou, azuwag, ve ndinatug. Irau napul di tineep, ve eŋgengou nala ne maau.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Nene pale daba toni ighami ve yesuru tila tivot Maaron nagho ila ndug to tisuŋsuŋ pani, ve ipaak mbesooŋa tonenen taliŋa ila ataam, ma ataam avo dige. Ghoro igham kiruuŋ, ve irab purusan mbesooŋa tonenen taliŋa. Leso inim ghilalooŋ pani ighaze muri, ye irau ipul uraat maau. Pale ineep toman daba toni, le irau sawa toni to mateeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ighaze tamoot eta igholia natu liva ila pa ŋgeu ite inim mbesooŋa pani, nene liva tonowen pale ineep toman ŋgeu tonenen. Ighaze muri daba toni ighaze ipuli ila, ye irau itaghon ŋgar to tighamgham pa yes mbesooŋa nditamoot ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ighaze ŋgeu to igham liva tonenen inim le ne, lolo pani muul maau, ye irau igholia ila ndug ite paam maau. Ye irau igholia imuul ila to liva tonenen tau siŋ toni. Pasa, saveeŋ mbuaaŋ toni toman liva tonenen, ye itaghoni maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ighaze ŋgeu tonowen igham liva tonenen pa natu eta, ye irau igham poiani inimale ye tau natu liva. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ve ighaze ŋgeu tonowen ivai liva tonenen, ve muri ivai liva ite paam, ye irau mata iŋgal liva to ighami muuŋ ne pa a aniiŋ, ve le oliŋa, ve yesuru tilup di pa ghenooŋ paam. Ipuli ineep sorok malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ighaze ye itaghon ŋgar tol tonene maau, ye irau ipul liva tonenen ila. Ve irau ipoi pa le atia maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ighaze tamtoghon eta irab ita ite imaat, yam arabi imaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Eemoghon ighaze ye iwaat rabuuŋi maau, yam arabi malep. Pasa, you Maaron to napul pataŋani tonenen ivot. Tamtoghon tovene irau ighau ila pa ndug pida to yoŋgaaŋ to muri pale napatooŋ di payam, leso ineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Eemoghon ighaze tamtoghon eta ate yabyab pa ita ite, ve iwaat rabuuŋi ve imaat, ve muri ighau ila pa artaal pughu, leso artaal ndamo pani ve ineep pooi, yam aghurghuri malep. Ala asasaara ivot ila pumuri, ve arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ighaze tamtoghon eta irab tama ma tina, arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ve ighaze ŋgeu eta ikis tamtoghon ite, ve igholia ila to tamtoghon ite paam, ma tau ikisi inim le mbesooŋa, arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ighaze tamtoghon eta ate yabyab pa tama ma tina, ve ipiyaav saveeŋ samia padi, arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Ighaze nditamoot ru tiparab, ve eez irab katin ita ite pa yaam ma nima, le tini isami kat. Eemoghon imaat maau. Inim narape moghon. Ŋgeu to irabi, pale ighol ita ite tonenen pa sawa to ye inim narape ve irau igham uraat maau. Ve ye irau iŋgini ve imbees pani le tini poia muul. Ighaze ita ite tonenen ikis titi ve tau imundig ilaagh, ghoro isob. Sosor toni, ye igharaata wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ighaze tamtoghon eta ilos mbesooŋa toni tamoot ma liva eta pa ai, ve mbesooŋa toni imaat pataghaaŋ, yam aghur atia pa tamtoghon tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Eemoghon ighaze mbesooŋa toni imaat rikia maau, ve ineep mboŋ eez ma ru, ghoro imaat, yam aghur atia pani malep. Pasa mbesooŋa tonowen, ye ineep ila daba toni tonenen nima. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ighaze liva eta apo, ve sawa toni to popaaŋ sone. Ve ighaze nditamoot pida tiparab, ve todi eta ipiyaav nima le irab sorokin liva tonenen, ve muri ipoop le natu imazug, ve ye tau poia. Nene pale atia piiz to azuwa toman yes pooza tighuri pa ŋgeu tonenen, ye irau igholi. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","“Eemoghon ighaze liva to apo igham samia, yam irau aghur atia pa ŋgeu tonenen itaghon sosor to ye ighami. Tovenen ighaze ye irab liva tonenen imaat, yam arab ŋgeu tonenen imaat paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ve ighaze iwaghamun mata, yam awaghamun ŋgeu tonenen mata. Ve ighaze iwaghamun livo, ma nima, ma aghe, yam paam agham ŋgar raraate moghon pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ve ighaze ye itun liva tonenen pa yab, yam anamim atun ŋgeu tonenen paam. Ve ighaze imbuti, ma irabi le tini imburmburtaaŋ, ataghon ŋgar raraate moghon pa ŋgeu tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","“Ighaze ŋgeu eta irab mbesooŋa toni tamoot ma liva eta le mata isami, ma livo ipol, ye irau ipuli ila. Irau inim mbesooŋa pani muul maau. Nene ataam to ŋgeu tonenen igharaat sosor toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ighaze makau tamoot eta iŋgal tamoot ma liva eta pa ndooŋa le imaat, yam arab makau tonenen paam pa yaam le imaat. Eemoghon aghani malep. Ve aghita makau tama aghaze ye inim pughu pa pataŋani tonenen malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Eemoghon ighaze makau eta moghon moghon iŋgalŋgal tamtoghon pa ndooŋa, ve makau tama iwatagi wa. Eemoghon ye iŋgin poian makau toni maau, ve igham tovene muul pa tamtoghon eta, yam arab makau tonenen pa yaam le imaat. Ve makau tama paam, arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Eemoghon ighaze ye to imaat ne ndita lolodi isamin makau tama, ve tiyok pani pa igharaat sosor toni, nene atia piiz to tighuri pani, ye irau igholi. Leso igham mulin tau, ve imaat sob. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ighaze makau eta iwaghamun pain kainaŋen ma liva kainaŋen eta, yam ataghon ŋgar raraate moghon. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ve ighaze makau tamoot eta iŋgal mbesooŋa tamoot ma liva eta pa ndooŋa, makau tama irau ighol yaam silva tamoot ee saaŋgul (30) ila pa daba to mbesooŋa tonenen. Ve yam irau arab makau tonenen pa yaam le imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","“Ighaze ŋgeu eta itai puura ve ipoona maau, ma ireu mbeb to tipoon saambu avo pani, ve ighaze makau ma esele eta itap izila le imaat, nene ŋgeu tonenen irau igharaat ŋgai tama. Ve ŋgai pale ineep ve inim ye to igham sosor ne le. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ighaze makau to ŋgeu eta iwaghamun makau to ita ite eta ve imaat, ndiran ru tonenen irau tigholia makau to poia ne, ve tivalag yaama. Ve makau to imaat, nene yesuru irau tipaal balagini inim ru, ve pida ila to ŋgeu eez, ve pida ila to ita ite. ");
INSERT INTO tuc_o_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Eemoghon ighaze makau tonenen moghon moghon ighamgham tovene, ve makau tama iŋgin poiani maau, ve igham tovene muul, ye pale irabolin makau to imaat ne, pa toni eta to raraate, ve makau maate tonenen ineep inim a. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ighaze ŋgeu eta iyub makau ma sipsip eta, ve irabi ve ighani, ma igholia ila pa tamtoghon ite, ye pale iyat mbeb to iyubi ne, ve igham pida paam izala pogho. Leso igharaat sosor toni. Ighaze iyub makau, ye pale iyati, ve igham makau paaŋ paam izala pogho. Ve ighaze iyub sipsip, ye pale iyati, ve igham sipsip tol paam izala pogho. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ighaze ŋgeu yubyub eta ireu ruum pa mboŋ ve ilooŋ ila, ve tamtoghon eta ighita ve irabi imaat, nene ye le saveeŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Eemoghon ighaze ŋgeu eta irab yubyub eta le imaat pa ndag, nene ye igham sosor. Tovenen yam irau aghur atia pani inimale moghon moghon aghuri pa yes to tirab tamtoghon imaat. “Ighaze tamtoghon eta iyub mbeb, ye irau igharaat mbeb to iyubi ne ila to mbeb tonowen tama. Ve ighaze ye irau igharaata maau, nene pale tigholia tamtoghon tonenen ila inim mbesooŋa pa tamtoghon pida, ve tigham yaama ila to mbeb tonowen tama. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ighaze ŋgeu eta iyub esele, ma makau, ma sipsip eta, ve ighaze tindeeŋ mbeb tonowen imaat maau ve inepneep ila ŋgeu tonenen nima, ye pale ipamuula, ve igham tau toni eta ila tomani, leso igharaat sosor toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ighaze ŋgeu eta ipul ŋgai toni tivool tila pa uum to tamtoghon ite ve tiwaghamuni, ye irau iyat aniiŋ ve vaen to ŋgai toni tiwaghamun di ne pa aniiŋ ve vaen popoiadi kat to titub ila uum toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ve ighaze ŋgeu eta itun ndug, ve yab ighan uum to tamtoghon ite ve iwaghamun wit toni papaghu, ma wit matua to ndouŋ ne, ye irau iyat suvun wit to yab ighani. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ighaze ŋgeu eta ipul yaam toni ma mburuguuŋ toni pida ila tamtoghon ite nima pa iŋgin di. Ve ighaze yubyub eta iyub mbeb tonowen ila ruum toni, ve muri tindeeŋa, sa mbeb to ye iyubi, ye irau ipamuula imuul ila, ve ighur ite paam izala pogho pa igharaat sosor toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Eemoghon ighaze andeeŋ yubyub tonenen maau, yam agham ŋgeu to iŋgin mbeb tonenen, ve ala apayoonda ila Maaron nagho. Ghoro asuŋ pa Maaron, leso ipatooŋ ŋgeu tonenen: Ye nima isosor pa ita ite mbeb toni, ma maau? ");
INSERT INTO tuc_o_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Ve ighaze tamtoghon ru tiwazoran di pa makau, esele, sipsip, nonogiiŋa, ma mbeb ite paam. Ve eez ighaze ye toni, ve ite ighaze ye toni. Nene agham yesuru ve ala avot Maaron nagho, ve tisavia saveeŋ todi izi tonowe. Ghoro asuŋ pa Maaron, leso ipatooŋ sei to igham sosor. Tamtoghon to igham sosor, pale ipamuul mbeb to tiwazoran di pani ne imuul ila to ita ite, ve ighur ite paam izala pogho pa igharaat sosor toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ighaze ŋgeu eta ipul esele, makau, sipsip, ma ŋgai toni ite paam ila ita ite nima pa iŋgini. Ve ighaze mbeb tonenen imaat, ma isami, ma yubyubŋa tiyubi, ve ighaze tamtoghon eta ighita mbeb tonenen maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Nene pale mbeb tonenen tama yesuru ita ite to iŋgin mbeb toni, tila tiyoon ila Yoova nagho. Ve ighaze ye to iŋgin mbeb toni ne, isaav ighaze: ‘Onoon kat, Maaron ighita ghou ve nasaav. Nimag isosor pa mbeb to itag ite tonene maau.’ Sawa to mbeb tonenen tama ilooŋ saveeŋ ghazooŋa tovene, nene irau le saveeŋ muul maau, ve ye irau ighur mata pa ita ite tonenen pa iyat mbeb toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","“Eemoghon ighaze ita ite iŋgin poian mbeb tonenen maau, ve yubyubŋa tiyubi, ye irau iyat mbeb to ilale imuul ila to mbeb tonenen tama. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ve ighaze mbeb sagsag eta ighan ŋgai tonenen ve isaas motini, nene ŋgeu to iŋgini irau igham suruvu ila, ve ipatooŋa pa ŋgai tonenen tama. Leso iwatag ighaze ita ite tonenen iyub ŋgai toni maau. Mbeb sagsag to iwaghamuni. Tovenen ita ite tonenen irau iyati maau. Pasa, ye le sosor maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ighaze ŋgeu eta ighason ita ite pa bapolo toni, leso iuuli pa uraat. Ve ighaze bapolo tama ineep maau, ve bapolo tonowen imaat, ma mbeb eta iwaghamuni, nene ŋgeu tonenen irau iyati. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Eemoghon ighaze bapolo tama inepneep, ve pataŋani tovene ivot, nene ŋgeu to igham bapolo tonenen pa uraat, irau iyati maau. Ve ighaze ye igharaat bapolo tama pataghaaŋ wa, ve pataŋani tovene ivot, nene paam irau iyati maau. Pasa, ye igharaat atia ila to bapolo tama wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ighaze ŋgeu eta ighereb liva paghu eta to tisia sone, ve imogheer pani, ye irau ighol liva tonenen ve ivaii. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ve ighaze liva tama iyok padi pa tivai maau, nene pale yesuru tivai maau. Eemoghon ŋgeu tonenen irau igharaat liva tama, raraate inimale tigholghol ndiliva papaghu. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ndiliva to tighamgham mur, apul di tineep malep. Arab di timaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ighaze tamoot eta imogheer pa ŋgai liva eta, ma liva eta ipatooŋ tau pa ŋgai tamoot leso ŋgai imogheer pani, arabi imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Yam irau agham watooŋrau pa Yoova moghon. Ighaze tamtoghon eta igham watooŋrau pa maaron kaarom eta, arabi ilale. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Loomba to tineep ila lolomim, yam agham samin di, ma agham pataŋani padi malep. Yam irau agham poian di. Pasa, matamim iŋgal: Muuŋ, yam paam anim loomba izi Isip. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ve yes ndinaara ve parooŋa tovene paam. Agham samin di malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pasa, ighaze agham tovene padi, ve titaŋ roran ghou pa ulaaŋ, you pale nalooŋ taŋiiz todi ve nauul di. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ve you pale ateg yabyab kat payam, ve nambut gham pa buza tiou ve amatmaat, ve ndizwamim tinim ndinaara, ve ndinatumim tinim parooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ighaze tamtoghon tiou eta mbolaaŋ ighami ve igham bun ilat tiom, yom utaghon ŋgar to yes ndiran to tighamgham yaam pa tamtoghon leso tigham ledi avua izala pogho ne malep. Tovenen ye to igham bun ilat tiom, ighaze muri iyati, nene ye irau iyat yaam anoŋa moghon. Upoi pa avua izala pogho malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ve ighaze ugham nonogiiŋa toni to moŋeŋaaŋ ineep tiom, leso mata iŋgal bun toni ve iyati, rabrab to naol ne, yom irau ugham nonogiiŋa toni imuul ila pani le isob, ghoro mboŋ izi. Ve mboŋmaagh, ghoro ye ighami imuul ilat. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Pasa, ye le mbeb ite paam pa itatab tau pani maau. Tovenen ighaze ukis nonogiiŋa toni pa mboŋ, nene pale moŋeŋaaŋ ighami, ve igheen pooi maau. Ve ighaze ye itaŋ roran ghou pa nauuli, nene pale nalooŋ taŋiiz toni. Pasa, yes to tineep ila pataŋani lolo, you lolog isasamin di, ve nauluul di. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Uveleg Maaron malep, ve upiyaav saveeŋ samia pa daba eta to iŋgin gham ne malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Aniiŋ toman vaen ve oliv tiom mata, uŋguruut di payou malep. Ugham di tinim payou. Ve natum tamoot aidaba tovene paam, upuli inim leg. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ve makau ve sipsip tiom to nditinandi tipoop di muuŋ ne paam. Upul di tineep toman nditinandi irau mboŋ liim ve ru. Ve mboŋ inim liim ve tol, ghoro ugham di tinim, ve urab di tinim watooŋrau payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Yam irau ataghon ŋgar patabuaŋ. Pasa you nagham gham anim leg wa. Tovenen ŋgai to ighaze mbeb sagsag eta isaas motini ve irabi imaat, aghani malep. Apiyaava ila ŋgavuun tighani.” ");
INSERT INTO tuc_o_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ighaze ulooŋ mbeb eta varu, ghoro usavia pa tamtoghon rikia malep. Pa vene, saveeŋ kaarom ma venen. Ve ighaze tamtoghon eta igham ŋgar samia ve tipayoonda pa savsaveeŋ, uvool toni ve usavia saveeŋ kaarom pa uuli malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ighaze ival tiina tilup di pa tigham ŋgar samia eta, yom ula toman di malep. Ve sawa to gharatooŋ saveeŋ, ighaze ival tiina tisavia saveeŋ kaarom pa tighamun saveeŋ, yom ula toman di ve upariaaŋ kaarom todi tonowen malep. Yom irau usavia saveeŋ onoon moghon. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“Ighaze tipayoon mbolaaŋa eta pa savsaveeŋ, uvool toni sorok malep. Ulooŋ poian saveeŋ toni pughu le isob, ghoro uŋgabiiza itaghon ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ighaze ughita makau ma esele to koiam eta ilaghlaagh pumuri, ughami imuul ila to tama. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ve ighaze ughita esele to koiam eta to imbaad mbeb pataŋani ve itap izi igheen, upuli malep. Ula ve uul koiam tonanan ve yamru atoov agham esele toni iza iyoon. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ighaze yom daba to ndug, ve mbolaaŋa eta le pataŋani, ve ighuri ilat nimam pa ugharaata, utatan saveeŋ toni malep. Ulooŋ saveeŋ toni ve ugharaat poiani. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ve ighaze tamtoghon tiŋgal saveeŋ pa ŋgeu eta ve tipayoonda sorok pa savsaveeŋ, yom ula toman di pa saveeŋ todi malep. Uneep saguan padi. Tamtoghon deŋia to le sosor eta maau, urabi imaat malep. Pasa, yes to tigham sosor tovene, nene irau naghurghur di maau. Pale naghur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ighaze tamtoghon eta ighaze ighol ghom leso uuli pa kaarom toni, uyok pani malep. Pasa, ŋgar tovene ighamun ŋgar to tamtoghon. Yes to tighazooŋ pa ŋgar poia ne paam, pale ighamun ŋgar todi. Tovenen sawa to tigharaat saveeŋ, yes pale tivool to yes to tighol di, ve tighamun saveeŋ to yes to titaghon ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ugham samin yes loomba malep. Pasa muuŋ, yam paam aneep anim loomba izi Isip. Tovenen pataŋani to yes loomba, taumim ayamaana wa. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Uvavazog aniiŋ ila taan tiom, ve uyouyou di le irau ndaman liim ve eez. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ve ighaze ndaman inim liim ve ru, ghoro upul taan tonanan ineep inim raŋgaat. Ndaman tonenen, yes mbolaaŋa to tineep ila lolomim, pale tila raŋgaat tiom tonanan, ve tikaal adi nakapoŋa pa tighan. Ve ighaze tipul aniiŋ pida ineep, nene pale inim mbeb sagsag adi. Sawa isob, ighaze ndaman inim liim ve ru, yom irau utaghon ŋgar tovene. Ve utaghon ŋgar raraate moghon pa oliv ve vaen tiom paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ndag inim eez, ila imuul ndag inim liim ve eez, nene sawa tiom to ugham uraat. Ve ndag inim liim ve ru, yom irau upul uraat tiom ineep, ve atem izi. Leso makau ve esele tiom, toman yes mbesooŋa to nditinandi tipoop di ila ruum tiom, ve yes loomba to yamŋa anepneep ne paam, atedi izi ve avuvudi ila. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Saveeŋ isob to you nasavia payam, matamim kisini ve ataghoni kat. Ve asuŋ pa maaron kaaromŋa malep, ve izadi ivot ila avomim rita malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ndaman to naol ne, lupuuŋ tintina tol to suŋuuŋ pale tivot. Sawa todi ighaze ivot, ghoro yamŋa ival tiina to Israel alup gham pa suŋuuŋ, ve apait ghou. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Lupuuŋ to ivot muuŋ, nene Pasova. Nene pale ivot pa kaiyo Abib. Pasa, kaiyo tonenen to nagham gham apul taan to yes Isipa ve avot. Sawa tonenen, yam alup gham pa suŋuuŋ, ve aghan mberet to le yis maau irau mboŋ liim ve ru, itaghon tutuuŋ to muuŋ naghuri payam. “Tamtoghon to ighaze isuŋ payou ne, nima ŋginiŋa ve inim ivot naghog malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Lupuuŋ inim ru, nene Sawa to Aniiŋ Mata. Uvazog aniiŋ ila uum tiom, ve usasaŋan le ighaze aniiŋ mata imatu, ghoro lupuuŋ tiina tonene ivot. Tovenen ulaagh toman aniiŋ tiom mata unum, ve yamŋa ival tiina to Israel alup gham pa suŋuuŋ. “Lupuuŋ inim tol, nene Sawa to Taitaiŋ. Ndaman igharau ighaze isob, ve utai aniiŋ ila uum tiom, ghoro lupuuŋ tiina tonene ivot. Tovenen yam asob irau alup gham pa suŋuuŋ, ve apait ghou pa aniiŋ to nagham payam. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“You Yoova, Maaron tiam. Tovenen ndaman to naol ne, ighaze sawa tol tonene tivot, ghoro nditamoot tiam tisob tilup di ila naghog, ve tisuŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Ighaze urab mbeb eta inim watooŋrau payou, ulup mbeb to yis ineep ila ne, tomani malep. Ve sawa to yamŋa ival tiina alup gham pa suŋuuŋ ve ugham watooŋrau payou, yab irau ighan suvun watooŋrau tiom tonanan minda toman ŋgoreeŋa. Ŋgiira rita ineep mboŋ le ndugizau malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“You Yoova, Maaron tiom. Aniiŋ tiom mata to tivot ila taan tiom, yom uvureer popoia moghon ve ugham di tinim rumai tiou. “Ighaze unaz mekmek natu eta, unazi toman tuz to tina malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Alooŋ! You pale nambaaŋ aŋela tiou ilat, leso imuuŋ payam, ve iŋgin gham pa ataam. Ye pale igham gham ala avot izi taan to you naghuri payam pataghaaŋ pa aneep pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Aghur taliŋamim pani pooi, ve alooŋ saveeŋ toni. Azoor aliŋa malep. Pasa, ighaze yam azoor aliŋa, ye irau ighurghur gham maau. Pale ighur pataŋani iza tiam. Pasa, ye igham naghog, ve izag ineep toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Eemoghon ighaze yam alooŋ aliŋa, ve ataghon katin saveeŋ isob to you nasavia, nene pale naghur koi pa yes to tighur koi payam, ve naparab toman yes to tiparab toman gham. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Tovenen aŋela tiou tonene pale imuuŋ payam, ve igham gham ala avot izi taan to yes Amora, Hita, Peresa, Kanaana, Hivia, ve Yebusa. Ve you taug pale narab di tilaledi, leso agham taan todi inim lemim. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“Sawa to ala aneep izi taan Kanaan, ataghon di pa ŋgar todi malep. Tovenen aput aghemim pa maaron kaaromŋa todi ve ambees padi malep. Arab mbirisan di. Ve yaam todi patabuaŋa to tiyondyood ila ndug todi to suŋuuŋ, tovene paam. Arab mbirisan di le timbiriis. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“You Yoova, Maaron tiam. Yam irau ambees payou moghon. Leso poia tiou iza tiam, ve nagham amim aniiŋ ve ya, ve nandiir moroghooŋ ighau payam. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ve ndiliva tiam tisob, popaaŋ todi pale poia moghon. Eta irau uupa maau, ve pain eta to ineep ila tiina apo lolo irau imazug maau. Ve you pale matag payam, leso aneep mala izi taan to naghaze nagham payam. Irau amaat rikia maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Sawa to yam alaagh ala, you taug pale namuuŋ payam, ve naghur matughezaaŋ tiina ivot pa yes ndug ndug to pale ala avot todi. Leso nagham koiamimŋa ŋgar todi iwaghamgham, ve timatughez payam ve tighau. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ve you pale nambaaŋ ŋguruub ndiŋndiŋ ndiŋndiŋ timuuŋ payam. Leso tireu yes Hivia, Kanaana, ve Hita tighau. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Eemoghon irau nandiir di tisob tighau pa ndaman ee moghon maau. Pa vene, taan todi ineep sorok, ve mbeb sagsag timasa tinim naol izi ndug todi, ve tiwaghamun gham. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Tovenen you pale nandiir di poipoi ve tila, le irau yam avot anim naol, ghoro agham taan todi isob inim lemim. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Taan to naghaze nagham payam ne, dige eez, nene itaghon naari to Te Kaviaaŋa, le ila imuul izi naari to Te Mediterenian to yes Pilistia tineep pani. Ve dige ite, nene itaghon ndug balim to magargaar moghon, le ila imuul ya Euprates. You pale naghur taan tonowen tamtoghona tilat nimamim, leso andiir di tighau, ve agham taan todi inim lemim. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tovenen yamŋa ambua saveeŋ pa alup gham anim ee moghon malep. Ve maaron kaaromŋa todi tovene paam. Ambua saveeŋ toman di pa yamŋa alup gham malep. Aneep saguan padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ve ayok padi pa tineep toman gham ila taan tiam malep. Pale tiyes gham pa ŋgar todi samsamia, ve agham sosor ila matag. Ve aghita. Ighaze tiweu gham ve ambees pa maaron kaaromŋa todi ve asuŋ padi, nene pale inim liis payam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yoova isaav pa Mose ighaze: “Yamru togham Aron, toman ndinatu ru Nadap ve Abiu, ve daba tamoot tol saaŋgul (70) to yes Israela aza anim tiou to lolooz daba ne. Eemoghon anim agharau ghou kat malep. Aneep saguan ris, ve aput aghemim, ve asuŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Le isob, ghoro yes pida tineep tonowe, ve yom eŋgengom unum ugharau ghou. Ve yes ival tiina to Israel tovene paam. Tiza tinim tigharau ghou malep. Tineep saguan.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tovenen Mose imuul izila to yes Israela, ve ipaes padi pa saveeŋ ve tutuuŋ tisob to Yoova isavia di. Isavsaav padi le isob, ghoro tilup avodi tighaze: “Saveeŋ isob to Yoova isavia, yei pale nitaghoni.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ghoro Mose imbood saveeŋ isob to Yoova ila rau. Mboŋ ndugizau, ghoro Mose imundig, ve indou yaam pida izi lolooz pughu inim artaal, ve ipayoon yaam saaŋgul ve ru tinim ghilalooŋ pa rumai saaŋgul ve ru to yes Israela. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ghoro imbaaŋ ndipain todi pida tila tigham watooŋrau pa Yoova. Yes tigham mbeb pida ve tighur di tizala yab ve ighan suvun di. Ve timoz makau papaghu pida ve tighan di, leso yesŋa Yoova tilup di tinim ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose iwato mbeb to tirab di tinim watooŋrau ne siŋidi, ve iliŋ pida ila oon pida lolodi, ve igham pida, ve itirtiri izala artaal. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ghoro igham rau to saveeŋ mbuaaŋ todi toman Yoova ineep ila, ve iraava, ve iwaata, ve ival tiina tilooŋ. Tilooŋa le isob, ghoro tisaav tighaze: “Saveeŋ isob to Yoova isavia, yei pale nitaghoni kat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ghoro Mose igham siŋ to ineep ila oon lolodi, ve itirtiri izala ival tiina poghodi, ve isaav padi ighaze: “Aazne, Yoova imbua saveeŋ toman gham, ve yamŋa alup gham anim ee moghon. Siŋ tonene ipariaaŋ saveeŋ mbuaaŋ tiam toman Yoova. Lupuuŋ toit toman Yoova, nene iyoon izala saveeŋ to ye igham pait. Ighaze tataghoni kat, nene pale lupuuŋ toit toman Yoova inepneep tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ghoro Mose igham Aron, Nadap, Abiu, ve daba tamoot tol saaŋgul (70) to yes Israela, ve yesŋa tizala pa lolooz. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Tila tivot tonowe, ghoro tighita Maaron to Israela. Ye iyoon izala mbeb eez pogho. Mbeb tonowen babaŋa, ve bibiliiŋa inimale tata. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yes daba to Israela tineep toman Maaron, ve tighan ve tighun tonowe. Onoon kat, yes tighita Maaron. Eemoghon ye iwaghamun di maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Muri pa mbeb tonenen, Yoova isaav pa Mose ighaze: “Malmalim uza unum tiou to lolooz daba ne, ve uneep izi sualen. Pasa, you naŋgeret saveeŋ ve tutuuŋ tiou ila yaam babaŋadi wa. Leso ipatooŋ yes Israela pa ŋgar to titaghoni. Ve naghaze naghur yaam tonene tilat nimam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Tovenen Mose isaav pa yes daba tonenen ighaze: “Yam aneep to sualen, ve asaŋan yeru Yosua. Aron yesuru Ur to tinepneep ne. Ighaze lemim pataŋani eta, yesuru irau tigharaata.” Isavsaav padi le isob ghoro igham ulaaŋa toni Yosua ve yesuru tinau tizala ris. Ghoro Mose ipul Yosua izi, ve eŋgeni malmali izala pa lolooz to Maaron daba. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Sawa tonenen, yaghur tae izi inim ikau lolooz Sinai daba. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ve Yoova ŋguruba isul izala lolooz daba. Yaghur tae tonowen ikau lolooz irau mboŋ liim ve eez. Ival tiina to Israel to tineep sila, matadi izala pa lolooz, ve tighita Yoova ŋguruba isul inimale yab tiina ighanghan izala lolooz daba. Ndag inim liim ve ru, ghoro Yoova ineep yaghur tae lolo, ve isaav izila pa Mose ighaze izala toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tovenen Mose izala lolooz daba kat, le ilooŋ ila yaghur tae lolo. Ve ineep tonowe irau mboŋ tamoot ru. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mose ineep mala izi lolooz Sinai daba. Tovenen yes Israela tisaŋani le maau, ghoro tila tiluvut Aron, ve tisaav pani tighaze: “Aron, ugharaat leed maaron eta! Leso imuuŋ pait ve iŋgin ghiit. Pasa, ŋgeu to igham ghiit tapul taan to yes Isipa ve tanim, yei nikankaan pani. Mbeb eta avaat ivot pani wa.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron ilooŋ saveeŋ todi, ve isaav padi ighaze: “Poia. Yam ala aŋgoog pandood to ndizwamim ve ndinatumim to tigharaat di pa gol, ve agham di tinim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tovenen ival tiina tipas pandood todi tizi pa taliŋadi, ve tigham di tila to Aron. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ghoro ye igham gol todi tonowen, ve igharaata inim makau anunu. Ival tiina tighita makau anunu tonowen, ve tisaav tighaze: “Ai yam Israela, aghita. Nene maaron toit to igham ghiit tapul Isip ve tanim.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron ighita ŋgar todi tonowen, ve igharaat artaal eez ila mbeb tonowen nagho, ve isaav padi ighaze: “Bozo, pale talup ghiit pa suŋuuŋ, ve tapait Yoova!” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mboŋ le ndugizau, ghoro ival tiina timundig, ve tiyou mbeb todi pida tila, leso tigham watooŋrau pa maaron todi tonowen. Watooŋrau pida, yab ighan suvun di. Ve tigham pida, leso yesŋa maaron todi tonowen tilup di tinim ee moghon. Ghoro mboledi izi ve tighanghan. Tighanghan ve tighunghun, ve mala maau tipamundigin narogho, ve mogheraaŋ toman ŋgar samsamia naol tivot. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","8","Tighamgham tovene, ve Yoova isaav pa Mose ighaze: “Ai, rikia moghon uzila! Pasa, tamtoghon tiom to ugham di tipul Isip ve yamŋa anim, ŋgar todi isami, ve tiwaghamgham. Ataam to avog iyaryaaŋ padi naghaze titaghoni, nene tipuli wa. Ulooŋ. Tigharaat ledi makau anunu, ve tiput aghedi pani, ve tigham watooŋrau pani. Ve tisavsaav tighaze: ‘Yam Israela, aghita. Maaron toit to igham ghiit tapul Isip ve tanim, tau tonene!’ ");
INSERT INTO tuc_o_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ndiran tonowen, you nawatag di wa. Matadi zoraaŋ saveeŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tovenen ateg yabyab padi kat, ve aazne naghaze napasob di tilaledi. Ve yom uŋgalsekin ghou malep. Pasa, naghaze naghur yamŋa papaghu tiom agham inadi. You pale nagham gham amasa anim naol, ve izamim tintina.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Eemoghon Mose itoova pa irab Maaron toni Yoova ate. Ighaze: “Aa Yoova, pughu vena to atem yabyab kat pa tamtoghon tiom? Yom taum to upatooŋ tapirim ve ugham mbeb gharatooŋadi tintina, tauto ugham di tipul Isip ve tinim. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ighaze uwaghamun di, nene pale yes Isipa tisaav tighaze: ‘Laak, Maaron to yes Israela ighaze iwaghamun di ve ipasob di pa taan. Tauto itombaan di, ve igham di tipul ghiit ve tila ndug to bide lolooza, leso irab di tonowe.’ Tovenen uwaghamun di malep. Onoon, atem yabyab kat. Eemoghon utatan atem, ve utoor ŋgar tiom. Ukaria tamtoghon tiom malep. Lolom imuul padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Matam iŋgal mbesooŋa tiom Abaram, Isak, ve Yakop. Muuŋ, yom umbua saveeŋ toman di, ve upariaaŋa le iyaryaaŋ kat ughaze yom pale ugham papaghu todi timasa tinim naol tinimale pitum to sambam paroŋania. Ve ugham taan Kanaan isob inim ledi, leso tineep pani itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Yoova ŋgar toni iyaryaaŋ ighaze iwaghamun yes Israela. Eemoghon Mose isuŋ ariaŋa, tauto Yoova itatan ate, ve itoor ŋgar toni, ve irab tamtoghon toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Ghoro Mose igham yaam babaŋadi ru to Maaron iŋgeret tutuuŋ toni ila, ve imuul izila to yes Israela. Yaam ru tonowen, Maaron tau igharaat di, ve iŋgeret tutuuŋ toni ila. Ve bodeeŋ ineep ila digedi ru. Tutuuŋ tonowen, nene pa ipariaaŋ yes Israela, leso matadi kisin saveeŋ to yesŋa Maaron timbua, ve titaghon ataam toni. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosua to ulaaŋa to Mose, ye isasaŋani izi lolooz luvuŋa. Mose izila ivot toni, ve yesuru malmalidi tizila. Tigharau ndug to ival tiina tinepneep pani, ghoro Yosua ilooŋ oroor tiina. Tovenen isaav pa Mose ighaze: “Wai, nowe avaat malmal eta?” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Eemoghon Mose isaav pani ighaze: “Maau. Oroor tonowen inimale pakuruuŋ to yes ndaaba to tilib pa malmal ne maau. Ve inimale taŋiiz to ndaaba to koiadi tilib padi, nene paam maau. Mbouŋ to nalooŋa we, tamtoghon avaat tinidi iza pa mbeb eta.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mose ivot todi izi lolooz pughu, ve ighita di titortor luvutin makau anunu, le ate yabyab kat. Tovenen ipiyaav yaam babaŋadi ru to ikiskis di ne, tizila taan le berberia. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ghoro ila igham makau anunu tonenen, ve ipiyaava izala yab ighani, ve itututi ila le imbiriis inim avab. Ghoro itiri izila ya, ve isaav ariaŋa pa yes Israela ve tighuni. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ghoro iyaan Aron ighaze: “Laak, ndiran tonene tigham vena payom, to ulooŋ di, ve uweu di ve tigham sosor tiina tonene?” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron ipamuul aliŋa ighaze: “Wai, tiina tiou, atem yabyab payou malep. Yom uwatag: Ndiran tonene, moghon moghon lolodi ipapazaagh di pa ŋgar samsamia naol. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Yes tisaav payou tighaze: ‘Ugharaat leed maaron eta lak! Leso imuuŋ pait ve iŋgin ghiit. Pasa, ŋgeu to igham ghiit tapul taan to yes Isipa ve tanim, yei nikankaan pani. Mbeb eta avaat ivot pani wa.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Yes tisaav payou tovene, tauto nasaav padi naghaze: ‘Poia. Sei to ighaze ipambood tau pa gol, ghoro iduduuma izi ve ighami inim.’ Tovenen yes tila tiyou gol todi tinim tiou, ve nasuruuv di tizala yab, ve rikia moghon makau anunu ivot!” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose ighita ighaze Aron iŋgin poian yes Israela maau, ve ipul di tiwaghamgham, tauto tigham ŋgar samsamia naol. Tovenen imatughez: Ighaze koiadi tinim ve tighita di, nene pale tiveleg di ve tiŋiŋ padi. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tauto ila iyoon ila ataam avo, ve imboob ighaze: “Alooŋ! Sei to ighaze itaghon Yoova, ghoro inim tiou!” Tovenen yes to rumai Levi tisob tila tilup di ila Mose mata, ");
INSERT INTO tuc_o_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ve Mose isaav padi ighaze: “Yoova to Maaron to iit Israela, aliŋa ilat payam ighaze agham buza tiam, ve alaagh taghon ndug lolo, ve ambut yes to tiput aghedi pa maaron kaarom tonenen, le tisob timatmaat. Ighaze toŋvetaz tiam, ma nditamim, ma yes to tineep tigharau gham, aghurghur di malep. Buza ighan di moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tovenen yes Levia titaghon Mose aliŋa, ve sawa tonenen timbut nditamoot irau ndiŋndiŋ tol (3000) pa buza ve timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ghoro Mose isaav padi ighaze: “Yam rumai to Levi, alooŋ. Onoon, nene ipataŋan pa yam arab ndinatumim ve toŋvetaz tiam timatmaat. Eemoghon yam aghurghur di maau, ve ataghon katin Yoova aliŋa. Tauto aazne, ye igham gham anim uraata toni, ve ighur poia toni iza tiam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mboŋ ndugizau, ghoro Mose isaav pa ival tiina ighaze: “Alooŋ! Sosor to yam aghami, nene tiina le tiina kat. Eemoghon you pale namuul nazala to Yoova, ve natoova pa nagharaat saveeŋ tomani, ve naghita: Pale irau ilooŋ ghou, ve ipul sosor tiam tonene, ma maau?” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tovenen Mose imuul iza ila to Yoova, ve isaav pani ighaze: “O Yoova, ival tiina tonowen tigham sosor tiina kat payom. Pasa, tigharaat ledi maaron kaarom pa gol. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Eemoghon aazne, naghason ghom pa lolom isamin di ve upul sosor todi. Ighaze maau, ghoro izag to umbooda ila rau tiom, umusi ighau paam.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yoova ipamuul aliŋa ighaze: “Vana maau. Tamtoghon to ighaze izoor ghou ve igham sosor payou, ye tonenen to pale namus iza ighau pa rau tiou. ");
INSERT INTO tuc_o_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tovenen umundig umuul uzila todi, ve ugham di ve yamŋa ala pa ndug to muuŋ nasavia payam. Aŋela tiou pale imuuŋ payam, ve yamŋa ala. Eemoghon muri, you pale naghur atia padi pa sosor todi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tauto muri, Yoova igham moroghooŋ samia ivot padi, ve iyat ŋgar todi to tizoorndug pa Aron tighaze igharaat ledi makau anunu inim maaron kaarom. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ghoro Yoova isaav muul pa Mose ighaze: “Yamŋa yes Israela to ugham di tipul Isip ve anim, amundig apul ndug tonene, ve alaagh muul ala pa taan Kanaan. Pasa muuŋ, you nambua saveeŋ toman Abaram, Isak, ve Yakop, ve napariaaŋa le iyaryaaŋ kat naghaze you pale nagham taan tonowen pa papaghu todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","You pale nambaaŋ aŋela tiou imuuŋ payam, pa indiir taan tonowen tamtoghona tighau. Nene yes Kanaana, Amora, Hita, Peresa, Hivia, ve Yebusa. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Leso agham taan todi inim lemim, ve aneep pani. Taan tonowen ŋgoreeŋa tiina, ve mbeb naol titub pooi pani. Eemoghon you taug irau itiŋa tala maau. Pasa, yam matamim zoraaŋ saveeŋ. Ighaze itiŋa tala, ve agham ŋgar samia ite paam izi ataam luvuŋa, nene pale apas ateg, ghoro napasob gham.” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ival tiina tilooŋ saveeŋ ariaŋa tonene, le lolodi ipataŋan kat ve titaŋ tiina. Titiik taudi muul maau. Tipul taudi tinimale timoŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pasa, Yoova isaav pa Mose ighaze: “Usaav pa yes Israela tovene: ‘Yam matamim zoraaŋ saveeŋ. Irau itiŋa tala maau. Pasa, ighaze naneep toman gham pa sawa ris, ve apas ateg muul, nene pale napasob gham. Tovenen mbeb tiam popoia naol to atiik taumim pani, aduduum di tisob tizi, ghoro matag iŋgal sa ŋgar to pale nagham payam.’” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tovenen sawa to yes Israela tipul lolooz Sinai ve inim, yes titiik taudi pa mbeb popoia muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Sawa to yes Israela tilaghlaagh izi ndug balim, ve ighaze atedi izi ataam luvuŋa, ghoro Mose ipayoon mbeez eez ineep saguan pa mbeez pida. Mbeez tonowen, tiwaata tighaze: ‘Mbeez to lupuuŋ.’ Tamtoghon tisob to tighaze tighason Yoova pa mbeb eta, tilala tonowe, ve tighurghur aliŋadi ila to Mose, leso ana isavia ila to Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","9","Sawa to naol, ighaze Mose ilaagh ila pa mbeez tonowen, ival tiina tisob timundig, ve tiyoon irau mbeez todi todi naghodi, ve matadi itaghoni le ilooŋ ila mbeez lolo. Ghoro yaghur tae induur izi inim ve ipoon mbeez nagho, ve Mose yesuru Yoova tisavsaav. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sawa to ival tiina tighita yaghur tae tonowen izi inim ipoon mbeez nagho, yes tiput aghedi, ve tisuŋ irau mbeez todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ve Yoova yesuru Mose tiwaghiton di, ve tisavsaav tinimale tamtoghon ru to avodi imbesmbees. Tisavsaav le isob, ghoro Mose ivot, ve imuul ila pa Israela inadi to nepooŋ. Eemoghon Yosua to Nun natu ne, ipulpul mbeez tonenen maau. Iŋgini irau sawa isob. Yosua, ye pain paghu ve inim ulaaŋa to Mose. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Tinepneep le sawa eez, ghoro Mose isaav pa Yoova ighaze: “Laak, yom usaav payou ughaze naghereb ival tiina tonene ve yeiŋa nila pa taan Kanaan. Ve ughaze tinim imot inim tiou ve ugham ghou nanim itam ite kat. Eemoghon sei to ughaze umbaaŋa inim toman ghou pa iuul ghou, nene yom upaghazoŋan ghou pani sone. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ighaze onoon tinim imot inim tiou, ghoro upatooŋ ghou pa ataam toman ŋgar tiom. Leso nawatag katin ghom, ve laghooŋ tiou poia ila matam. Aa Yoova, matam iŋgal ival tiina tonowen paam. Pasa, yes tamtoghon tiom. Yom taum usia di tinim lem.” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yoova ipamuul aliŋa ighaze: “Ugham ŋgar naol malep. You taug pale nalat toman ghom, leso nagham ghom lolom poia ve atem izi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose ilooŋ saveeŋ tonene, ve isaav pani ighaze: “Nene poia pa unum toman ghei. Pasa, ighaze taum unum toman ghei maau, yei irau nipul ndug tonene maau. Pale nineep moghon to sualen. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pasa, ighaze unum toman ghei maau, nene pale sa mbeb igham tamtoghon tighilaal tighaze yom lolom payei, ve poia tiom inepneep toman ghei? Maau. Eemoghon ighaze unum toman ghei, nene pale tamtoghon tiwatag tighaze yom usia ghei ninim lem, ve yom taum upas ghei nivot saguan pa ndug tisob to taan.” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Tovenen Yoova isaav pa Mose ighaze: “Poia. Mbeb to yom ughason ghou pani, you pale naghami. Pasa, tinig imot ilat tiom, ve nagham ghom unum itag ite kat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose ilooŋ saveeŋ tonene, ve ighason Maaron muul ighaze: “Aa Yoova, ighaze venen, upatooŋ taum toman tapirim ve poia tiom payou, ve naghita katin ghom!” ");
INSERT INTO tuc_o_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yoova ipamuul aliŋa ighaze: “You pale napatooŋ suvun poia tiou payom, ve navotia izag Yoova toman gabuag ila matam. Ighaze lolog poia pa tamtoghon eta ve naghaze nagham poiani, nene pale nagham poiani. Ve ighaze lolog isamin tamtoghon eta ve lolog pa nauuli, nene pale nauuli. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Eemoghon yom irau ughita naghog maau. Pasa, ighaze tamtoghon eta ighita katin ghou, ye irau ineep maau. Pale imaat. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ughita ndug to ineep digeg ne. Unum uyoon izala yaam pogho tonene. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Sawa to nanim ve naghaze napatooŋ taug toman tapirig ve poia tiou payom, nene pale naghur ghom ulooŋ ula yaam saambu tonene, ve napoon ghom pa nimag, le irau nasalib payom ve nala. ");
INSERT INTO tuc_o_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ghoro nimag ighau, ve ughita ndimog. Eemoghon naghog, tamtoghon eta irau ighita maau.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ghoro Yoova isaav pa Mose muul ighaze: “Ugharaat yaam babaŋadi ru, le raratedi tinimale papazogi you nagham payom ve upiyaav di tizi berberia. Leso naŋgeret saveeŋ ila raraate inimale muuŋ naŋgereti. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ugharaat di pataghaaŋ, leso bozo mboŋmaagh, ugham di, ve uza unum tiou sualen izi lolooz daba. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tamtoghon ite paam inim toman ghom malep. Ve lolog pa naghita tamtoghon eta ilaagh taghon lolooz dige maau. Ve ŋgai tovene paam. Tilaagh tigharau lolooz pughu malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Yoova isavsaav le isob, ghoro Mose ila igharaat yaam babaŋadi ru, le raratedi tinimale papazogi Yoova igham pani. Mboŋ ndugizau, ndoromaaŋa kat, ve Mose imundig, igham yaam ru tonowen, ve inau izala pa lolooz Sinai daba itaghon Yoova aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ghoro Yoova ineep ila yaghur tae lolo, ve izi inim iyoon igharau Mose, ve ivotia tau iza ve gabua. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","7","Ye ilaagh imbut Mose nagho, ve isaav ighaze: “You Yoova. Izag tau tonene: Yoova. You Maaron to lolog isasamin mbesooŋa tiou, ve naghamgham poian di. Ateg yabyab rikia maau. Poia tiou, nene tiina kat. Lolog ineep tuŋia ila to tamtoghon tiou ve nauluul di, ve nataghon saveeŋ mbuaaŋ tiou irau sawa isob. Ŋgar to lolog ineep tuŋia ila to tamtoghon tiou ve nauluul di, nene napatooŋa pa tamtoghon ndiŋndiŋ ndiŋndiŋ. Ve ŋgar todi to zoraaŋ saveeŋ, toman ŋgar todi pida to iyel pa ataam tiou, sosor todi naol tonowen, moghon moghon you nareureu di. Eemoghon yes to ledi sosor, you naghurghur di maau. Naghurghur atia pa yes taudi, toman ndinatudi, nditimbudi, ve saas todi.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose ilooŋ saveeŋ tonene, le rikia moghon iput aghe, nagho izila pa taan, ve isuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ighaze: “Aa Yoova, ighaze lolom poia payou, ve ughaze ugham poian ghou, unum toman ghei ve itiŋa tala. Onoon, ival tiina tonowen, dabadi ariaŋa, ve tiloŋlooŋ saveeŋ maau. Eemoghon lolom isamin ghei, ve ureu sosor tiei. Ŋgar tiei naol to tiyel pa tutuuŋ tiom, ureu di tilaledi. Ve ugham ghei ninim lem kat.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mose isavsaav le isob, ghoro Yoova isaav pani ighaze: “Aazne, you naghaze nambua saveeŋ toman yam Israela, leso itiŋa talup ghiit tanim ee moghon muul. You pale nagham mbeb gharatooŋadi tintina ila tamtoghon tiom tisob matadi. Uraat to naghaze nagham di, nene pale ite kat. Muuŋ ve inim, ndug tisob to tineep irau taan isob, tighita mbeb eta tovene pa eta sone. Tovenen ndug ndug to tineep tigharau ne, ighaze tighita di, nene pale matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tutuuŋ to aazne naghuri payam, yam asob matamim kisini, ve ataghoni kat. Leso namuuŋ payam, ve nandiir yes Amora, Kanaana, Hita, Peresa, Hivia, ve Yebusa to tineep izi taan Kanaan, tisob taghau tila. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Eemoghon matamim imosmoos pa taumim. Yamŋa taan tonowen tamtoghona ambua saveeŋ pa alup gham malep. Aneep saguan padi. Pasa, ighaze yamŋa alup gham, nene pale tinim liis payam, ve tiweu gham ve agham ŋgar samia. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Tovenen alup gham toman di malep. Ve mbeb todi naol to suŋuuŋ, areu mbirisan di. Artaal todi, toman yaam todi patabuaŋa to tipayoon di tigharau inadi to suŋuuŋ, yam arab babalagin di. Ve ai to tiluplup di ila sambadi ve tipait maaron liva todi Asera, nakavas ighan suvun di tizi. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Yam ambees pa maaron ite paam malep. Pasa, you Yoova to Maaron tiam. Matag pariuuŋ, ve naghaze yam ambees pa you moghon. Tauto tiwatwaat izag tighaze ‘Ye to mata pariuuŋ.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Tovenen ambua saveeŋ toman taan tonowen tamtoghona pa alup gham malep. Pasa, ighaze yes tigham watooŋrau pa maaron kaaromŋa todi, ve tilup di ve tighanghan, ve tipoi gham pa ala toman di, nene pale yamŋa aghan aniiŋ to watooŋrau todi tonowen. Ve ighaze agham tovene, yam anim maaron kaaromŋa todi tonowen ledi, ve apul murimim payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ndinatumim tovene paam. Tivai ndiran tonowen ndinatudi liva malep. Pasa, ighaze ndiliva tonowen timbees pa maaron kaaromŋa todi, nene pale tiweu ndinatumim tila timbees pa maaron kaaromŋa tonowen, ve tighur muridi payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Agham ain, gol, ma silva, ve agharaat mbeb eta inim maaron payam ve apaiti malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ve matamim iŋgal lupuuŋ tiina to ghaniiŋ mberet to le yis maau ne. Yam apul Isip pa kaiyo Abib. Tovenen ndaman isob, ighaze kaiyo tonenen ivot, yam alup gham pa ghaniiŋ mberet to le yis maau ne irau mboŋ liim ve ru itaghon aliŋag. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ndinatumim nditamoot to aidaba, toman ŋgai tiam ndinatudi to tipoop di muuŋ, nene tisob tinim leg moghon. Tovenen ŋgai tiam ndinatudi nditamoot to tipoop di muuŋ, arab di tisob timatmaat tinim watooŋrau payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Eemoghon esele ndinatudi to tipoop di muuŋ, arab di tinim watooŋrau payou malep. Arabolin di pa sipsip, ve arab di tinim watooŋrau payou. Leso agham mulin esele tiam. Ve ighaze arabolin di maau, ghoro arab polin luadi timaat. Ve ndinatumim aidaba tovene paam. Arabolin di pa sipsip, leso agham mulin di. “Tamtoghon to ighaze isuŋ payou ne, nima ŋginiŋa ve inim ivot naghog malep. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ndag inim eez, ila imuul ndag inim liim ve eez, yam irau agham lemim uraat. Eemoghon ndag inim liim ve ru, agham uraat malep. Atemim izi. Sawa to vazogiiŋ ve taitaiŋ paam, yam irau matamim iŋgal sawa tonenen ve atemim izi. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ndaman isob, sawa to Pasova ighaze isob, ve wik liim ve ru inim ila ve aniiŋ wit mata ivot, ghoro yam asob alup gham pa suŋuuŋ. Ve ighaze ndaman igharau ighaze isob, ve sawa to taitaiŋ ivot, yam asob alup gham pa suŋuuŋ muul. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","You Yoova to Tiina to yam Israela. Tovenen ndaman isob, ighaze sawa tintina tol tonene tivot, ghoro nditamoot tiam tisob tinim tilup di ila naghog, ve tisuŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“You pale namuuŋ payam ve nandiir tamtoghon tisob tighau pa taan to naghaze nagham payam, leso inim lemim. Ve you pale naseeŋ taan tiam ila inim tiina. Ighaze sawa tintina tol tonene tivot, ve yam asob apul ndug tiam tiam, ve anim alup gham ila naghog pa suŋuuŋ, agham ŋgar naol pa taan tiam malep. Pasa, tamtoghon eta irau lolo ipazaagha pa ighami sorok ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Siŋ to watooŋrau to yam aghaze agham payou, alupi toman mberet to yis ineep ila ne malep. Ve sawa to alup gham pa ghanghaniiŋ to Pasova, ve arab mbeb pida tinim watooŋrau, apul alulu ineep le ndugizau malep. Ighaze alulu ineep, aghuri ila yab ighan suvuni le isob, ghoro ndugizau. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Aniiŋ mata to tivot ila taan tiam, yam avureer popoia moghon, ve agham di tinim rumai to Maaron tiam Yoova. “Ighaze anaz mekmek natu eta, yam anazi toman tuz to tina malep.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yoova isaav muul pa Mose ighaze: “Saveeŋ tiou isob tonene, taum umbood di. Pasa saveeŋ to itiŋa tambua pa talup ghiit tanim ee moghon, nene iyoon izala saveeŋ tonene.” ");
INSERT INTO tuc_o_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose ineep toman Yoova izi lolooz daba irau mboŋ tamoot ru (40). Sawa tonenen, ye ineep sorok. Ighan aniiŋ eta maau, ve ighun ya maau. Ve iŋgeret tutuuŋ saaŋgul ila yaam babaŋadi ru. Tutuuŋ tonowen isavia ataam to titaghoni, leso lupuuŋ todi toman Maaron ineep ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mose igham yaam babaŋadi ru to tutuuŋ saaŋgul ineep ila, ve imuul izila. Yaam ru tonowen, nene pa ipalot yes Israela, leso matadi kisin saveeŋ mbuaaŋ todi toman Yoova ve titaghoni kat. Sawa to Mose ipul lolooz Sinai daba ve izila, nagho isul kat. Eemoghon ye tau iwatagi maau. Nagho isul pasa, yesuru Yoova tilup di ve tisavsaav. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mose ila ivot to yes Israela, ve Aron toman ival tiina tighita nagho isul. Tovenen timatughez pani, le tila tigharaui maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Eemoghon ye ipoi di ighaze tinim, tauto Aron igham yes daba to Israel, ve yesŋa tila to Mose. Ghoro Mose isavsaav toman di. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Le isob, ghoro ival tiina anadi tinim tigharaui, ve ye ipaesia saveeŋ isob to Yoova isavia pani izi lolooz Sinai daba, ve avo iyaryaaŋ padi leso titaghon katin saveeŋ tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Isavsaav padi le isob, ghoro ipoon nagho pa uli. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Eemoghon sawa isob to ye ighaze ilooŋ ila mbeez to Yoova, ghoro igham uli tonowen ighau pa nagho, ve yesuru Yoova tisavsaav. Tisavsaav le isob, ghoro ivot ila pumuri, ve ipaesia saveeŋ to Yoova isavia pani ne pa yes Israela ve tilooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Sawa to ye ivot ila pumuri, yes Israela tighita nagho isul. Tauto Mose iponpoon nagho, ve inepneep le sawa to ighaze imuul ilooŋ ila mbeez, ghoro igham uli tonowen ighau pa nagho, ve yesuru Yoova tisavsaav. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ghoro Yoova isaav pa Mose ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ndaman to naghood, kaiyo to ivot muuŋ, ve ndag inim mata, ghoro upayoon mbeez patabuaŋ. Leso inim inag to nepooŋ, ve itiŋa taluplup ghiit tonowe pa savsaveeŋ. Ugham tovene: ");
INSERT INTO tuc_o_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Bokis to Saveeŋ Mbuaaŋ to tutuuŋ tiou ineep ila lolo, ughuri imuuŋ ilooŋ ila mbeez suruvu to muŋgaaŋ we. Tutuuŋ tonenen isavia ataam to ataghoni leso lupuuŋ toit ineep tuŋia. Ghoro undaad uli tiina ila mbeez lolo, leso ipoon bokis tonowen. Mbeez suruvu tiina to ineep potla, nene patabuaŋ. Ve suruvu kainaŋen to bokis tonenen ineep pani, nene patabuaŋ le patabuaŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","“Undaad uli le isob, ghoro ughur toŋ to mberet patabuaŋ ilooŋ ila mbeez suruvu tiina to ineep potla, ve ughur mberet patabuaŋ izala. “Le isob, ghoro upayoon lam aia ilooŋ ila, ve ughur lam liim ve ru tila inadi. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Ghoro ugham artaal gol kainaŋen to tunuuŋ mbeb to vuzidi popoia, ve ughuri ilooŋ ila mbeez suruvu tiina. Ve utoora le nagho iŋarua Bokis to Saveeŋ Mbuaaŋ. Uyou mburuguuŋ to mbeez lolo tilooŋ tila le isob, ghoro undaad uli tiina ite ipoon mbeez nagho. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ghoro ughur artaal tiina to watooŋrau ineep saguan ris pa mbeez nagho, ");
INSERT INTO tuc_o_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ve ughur oon tiina to ririwaaŋ ineep bodbodaaŋ pa mbeez nagho ve artaal tiina, ve uliŋ ya ila lolo. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ghoro undaad uli mamala iluvut mbeez, ve undaad uli ariaŋa ila sirsiir avo inim ataam pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Upasob uraat naol tonenen le isob, ghoro ugham ŋgoreeŋ, ve uliŋi izala mbeez toman mburuguuŋ to tineep ila lolo, leso ughur di tinim leg. Mbeb naol tonanan, patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","11","Le isob, ghoro uliŋ ŋgoreeŋ izala artaal tiina to watooŋrau, toman mburuguuŋ to artaal, ve oon to ririwaaŋ, toman toŋ to oon tonanan ineep izala pogho ne paam. Leso ughur di tinim leg. Artaal tonanan, patabuaŋ le patabuaŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Upasob uraat naol tonenen le isob, ghoro ugham Aron toman ndinatu nditamoot tila tigharau ataam avo to mbeez patabuaŋ, ve urughuuz di. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Urughuuz di le isob, ghoro undud Aron pa nonogiiŋa toni patabuaŋ to uraat, ve uliŋ ŋgoreeŋ izala daba pa ughuri inim leg. Leso inim ŋgeu to watooŋrau ve imbees payou. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ghoro ugham ndinatu anadi tinim, ve undud di pa nonogiiŋa todi to uraat paam. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ve uliŋ ŋgoreeŋ izala dabadi inimale ugham pa tamandi. Leso tinim ndiran to watooŋrau ve timbees payou. Yesŋa papaghu todi to muri pale tivot, pale tikis uraat tonene, itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Yoova isavsaav le isob, ghoro Mose ipamundigin uraat. Ye igham mbeb tisob tonowen uraata itaghon saveeŋ to Yoova isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tovenen sawa to yes Israela tivool pa ndaman paghu, kaiyo to ivot pa ndaman tonenen muuŋ, ve ndag inim mata, ghoro tipayoon mbeez patabuaŋ to Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","19","Tighur mbeb pa pos tiyoon izala, ghoro tipayoon pos tizala poghodi. Ve tizeev ŋgaltereniiŋ itaghon saambu to tikir di pataghaaŋ ila pos ne, leso ikis pos tiyoon tuŋia. Ve tipayoon gungun mamala paaŋ ila pa mbeez nagho, ve tiraav uli tintina pida izala mbeez pogho, itaghon Yoova aliŋa to isavia ila to Mose. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ghoro Mose igham yaam ru to tutuuŋ to Yoova ineep ila, ve ighur di tila Bokis to Saveeŋ Mbuaaŋ lolo. Yaam ru tonowen, nene pa ipalot yes Israela, leso matadi kisin saveeŋ mbuaaŋ todi toman Yoova ve titaghoni. Ve Mose izeev sig ru itaghon inadi to ineep Bokis To Saveeŋ Mbuaaŋ dige, leso timbaada. Ve ipakud bokis avo. Bokis avo tonowen, tiwaata tighaze ‘Ndug To Rewaaŋ Sosor.’ ");
INSERT INTO tuc_o_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ghoro Mose ighur Bokis to Saveeŋ Mbuaaŋ ilooŋ ila mbeez lolo, ve indaad uli tiina eez ve ipoona itaghon Yoova aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","23","Le isob, ghoro ighur toŋ to mberet patabuaŋ ilooŋ ila mbeez suruvu tiina to ineep potla. Ineep dige ila pa kagu. Ve ighur mberet patabuaŋ izala, leso ineep ila Yoova nagho, itaghon Yoova aliŋa to isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ghoro igham lam aia ilooŋ ila mbeez suruvu tiina, ve ipayoonda ila dige to ila pa daudau, ve itoora le nagho iŋarua toŋ to mberet patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ve ighur lam liim ve ru izala, leso tisul ila Yoova nagho, itaghon Yoova aliŋa to isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ghoro ighur artaal gol kainaŋen to tunuuŋ mbeb to vuzi popoia ne ila igharau uli tiina to irab motin mbeez lolo. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ve itun mbeb to vuzi popoia izala, itaghon Yoova aliŋa to isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mose igharaat mbeez toman mbeb tisob to tineep ila lolo ne le isob, ghoro indaad uli tiina ila ipoon ataam avo, ve igham uraat to pumuri. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ighur artaal igharau sirsiir to mbeez patabuaŋ ataama, ve igham watooŋrau pida itaghon Yoova aliŋa to isavia pani. Ye ighur ŋgai toman wit pida tizala artaal, ve yab ighan suvun di tinim watooŋrau. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","32","Le isob, ghoro ighur oon tiina ineep bodbodaaŋ pa mbeez nagho ve artaal tiina, ve iliŋ ya ila lolo. Leso sawa to ye tau, ma Aron, ma Aron ndinatu tilooŋ tila mbeez lolo, ma tigharau artaal, ghoro timen nimadi ve aghedi pa ya tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Igham uraat tonenen le isob, ghoro indaad uli mamala tiluvut mbeez toman artaal tiina tinim sirsiir pani, ve indaad uli ariaŋa eez inim sirsiir ataama. Tovenen uraat naol to Yoova isavia di, Mose igham di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Ghoro yaghur tae to Yoova ineep ila, izi inim le itatab mbeez patabuaŋ, ve Yoova ŋguruba isul toman tapiri tiina irau mbeez lolo. Tovenen Mose irau ilooŋ ila maau. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Sawa to yes Israela tilaghlaagh izi ndug balim, matadi ilala pa yaghur tae tonowen. Ighaze ipul mbeez patabuaŋ pogho ve induur ila, nene yes paam timundig, tiyouyou, ve tilaagh titaghoni. Ve ighaze ineep tuŋia izala mbeez pogho, nene irau tilaagh maau. Tineep ve tisasaŋan le tighita yaghur tae induur muul, ghoro timundig tilaagh. ");
INSERT INTO tuc_o_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tovenen sawa to yes Israela tilaghlaagh izi ndug balim, matadi ilala pa yaghur tae tonowen ve titaghoni. Ighaze ndag, ghoro tisob tighita yaghur tae to Yoova ineep ila, inepneep izala mbeez patabuaŋ pogho. Ve ighaze mboŋ, ghoro tighita yaghur tae tonowen isul inimale yab iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Muuŋ kat, yes Israela ledi kinik maau, ve tamtoghon todi pida tinim daba padi ve tiŋgin di. Sawa eez, pitool tiina ivot. Sawa tonenen, ŋgeu eez inepneep, iza Elimelek. Azuwa iza Naimi. Ve ndinatudi nditamoot ru, eez iza Malon, ve ite iza Kilion. Rumai todi Eprata. Paanu todi, nene Betelem to ineep ila taan suruvu to Yuda. Sawa to pitool tiina tonenen ivot, Elimelek yesuru azuwa ve ndinatudi ru tipul Betelem, ve tila tineep izi taan suruvu to Moap. Tinepneep tonowe irau ndaman pida. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ghoro Elimelek imaat, ve Naimi toman ndinatu ru tonenen, yes moghon tineep. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Naimi ndinatu tivai Moap tidi ru. Eez iza Opa, ve ite iza Rut. Yes tineep tonowe irau ndaman saaŋgul, ghoro Malon yesuru Kilion anadi timaat. Tovenen Naimi inim naar ve inim kakam. Le azuwa maau, ve le ndinatu maau. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naimi inepneep izi Moap, ve ilooŋ tighaze Yoova iuul tamtoghon toni Israela, ve igham aniiŋ tiina ivot ila taan todi. Tovenen Naimi yesŋa ndirawa liva ru timundig tipul taan to Moap, ve tighaze timuul tila pa ndug pughu to Naimi. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tipul ndug to tinepneep pani, ve titaghon ataam to ila pa taan suruvu to Yuda. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Tilaghlaagh tila ve Naimi isaav pa ndirawa liva ru ighaze: “Aa, yamru amuul ala to nditinamim ve aneep toman di. Yamru lolomim ineep tuŋia inim tiou ve ndiran toit to timaat ne, ve agham poian ghei kat. Tovenen you nasuŋ pa Yoova naghaze igham poian gham paam. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","10","Ye tau pale iuul gham ve avai muul. Leso ndizwamim matadi payam ve aneep pooi.” Naimi isavsaav le isob, ghoro yesŋa ndirawa liva tiwasavagun di ve titaŋ tiina. Titaŋtaŋ le isob, ghoro ndirawa liva tisaav pani tighaze: “Maau. Itiŋa tamuul tala to toŋvetaz tiom ve taneep toman di.” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Eemoghon Naimi ipamuul aliŋadi ighaze: “Ndinatug liva, yamru amuul ala pa ndug tiam. Azoorndug aghaze itiŋa tala pasa? Aghita. You irau napoop nditamoot ruta muul pa tivai gham ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Amuul ala pa ndug tiam. Pasa, you nanim liva waat wa. Irau navai muul maau. Ighaze you navai pa mboŋ to aazne ve napoop nditamoot ru, ");
INSERT INTO tuc_o_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","irau yamru anepneep ve anamnaam le tinim ndolman, ghoro avai di? Maau. Aa ndinatug liva, you lolog isami kat. Pasa, pataŋani tiina to Yoova igham payou, nene igham gham paam.” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Yesuru tilooŋ saveeŋ toni tonene, ve tipamundigin taŋiiz muul. Titaŋtaŋ le isob, ghoro Opa isavag rawa liva, ve ipul di, ve imuul ila pa ndug toni. Eemoghon Rut lolo ineep tuŋia kat ila to rawa liva Naimi. Tauto lolo pa ipuli maau. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tovenen Naimi isaav pani muul ighaze: “Ughita! Tazim liva imuul ila to tamtoghon toni ve maaron toni wa. Utaghoni ula.” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Eemoghon Rut ipamuul aliŋa ighaze: “Uzoorndug ughaze napul ghom pasa? You irau napul ghom ve namuul nala maau. Ndug sine to yom ughaze ula pani, you pale nala paam. Ve ndug to yom uneep pani, nene you pale naneep pani paam. Tamtoghon tiom, nene tamtoghon tiou paam. Ve Maaron tiom, nene Maaron tiou paam. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Sa ndug to yom uneep pani ve umaat, nene you paam pale namaat ve titavia ghou toman ghom izi tonanan. Saveeŋ isob to nasavia di ne, ighaze nataghon di maau, nene pale Yoova tau ighur atia iza tiou. Tovenen mateeŋ moghon to pale irab motin ghiit.” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naimi ighita ighaze Rut ŋgar toni iyaryaaŋ kat ighaze yesuru tila. Tovenen ye le saveeŋ eta muul maau, ve iyok pa yesuru tila. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yesuru tilaagh tila le tivot izi ndug Betelem. Ival tiina to Betelem tighita di ve tisaŋeeŋ padi. Ve ndiliva pida tighason tighaze: “Wai, aghita. Nowe Naimi?” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Eemoghon Naimi ipamuul aliŋadi ighaze: “Yam awaat izag Naimi muul malep. Awaat izag ‘Mara.’ Pasa, Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne, igham nepooŋ tiou isami kat. ");
INSERT INTO tuc_o_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Sawa to napul ndug tonene ve nala, narau mbeb to naol. Eemoghon aazne, Yoova igham ghou namuul nanim toman nimag ŋginiŋa. Tauto naghaze awaat izag Naimi malep. Pasa, Maaron Ariaŋa To Ilib pa Ndimaronŋa Tisob Ne ighur pataŋani tiina iza tiou ve iwaghamun ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nene kamos to Naimi to ipul taan to yes Moapa, ve yesuru rawa liva Rut to Moap tidi ne, timuul tila pa Betelem. Sawa tonenen, nene sawa to tiyou aniiŋ bali anoŋa. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ŋgeu eez inepneep Betelem, iza Boas. Yesuru Naimi azuwa Elimelek, siŋ ee moghon. Boas, ye mbaliiŋ tau, ve ival tiina titandag pani tighaze ye iza tiina. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Sawa eez, Rut isaav pa Naimi ighaze: “Nene sawa to mbutuuŋ aniiŋ bali. Vena, irau nala nataghon yes uraata pida, ve ighaze lolodi isamin ghou, ghoro nayou aad bali pida to titaptap tizi taan?” Naimi ipamuul aliŋa ighaze: “Natug liva, nene poia. Ula.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tovenen Rut ila uum bali eez, ve itaghon yes uraata ve iyou a bali. Ye iwatag uum tonowen tama maau. Eemoghon ye ilaagh ila le deŋia kat pa uum bali to Boas. Boas yesuru Elimelek, siŋ ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Mala maau ve Boas ipul Betelem ve inim ighaze ighita yes uraata toni. Ye inim ivot todi, ve isaav padi ighaze: “Yoova ineep toman gham.” Yes tipamuul aliŋa tighaze: “Poia to Yoova iza tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ghoro Boas ighason mbesooŋa toni to iŋgin yes uraata ighaze: “Sa liva paghu tonowen? Siŋ toni sei masin?” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mbesooŋa tonenen ipamuul aliŋa ighaze: “Nowe Moap tidi to ipul ndug toni, ve yesuru Naimi tinim. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ye ighason ghou ighaze irau ila itaghon yes uraata ve iyou a bali pida to titaptap tizi taan. Tauto nayok pani. To mboŋmaagh kat ve inim, ye inoknok ghamuuŋ uraat. Tauto ŋgaramus ila yavyaav ve ate izi.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boas ilooŋ saveeŋ tonene, ve ila isaav pa Rut ighaze: “Natug liva, ulooŋ. Yom irau upul uum tonene, ve ula uum bali to ŋgeu ite paam maau. Uneep to sualen moghon, ve yamŋa uraata tiou ndiliva agham uraat. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Matam ila pa uraata tiou moghon. Ighaze timundig muul pa mbutuuŋ bali sine, ghoro ula utaghon di. You naŋgalsekin uraata tiou wa. Irau tigham samin ghom maau. Ve ighaze murun ghom, ghoro ula ughun ya to mbesooŋa titibi izila apatu ve inepneep we.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut ilooŋ saveeŋ tonene, ve iput aghe, nagho izila pa taan, ve isaav pa Boas ighaze: “Wai, you loom tidi. Vena to yom ugham ŋgar tiina payou ve ughaze ugham poian ghou?” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas ipamuul aliŋa ighaze: “Varum, you nalooŋa wa. Sawa to azuwam imaat, ve inim, yom ugham poian rawam liva kat. Ve upul tamam, tinam, taan tiom ve ndug tiom, ve unum uneep toman tamtoghon to muuŋ yom uwatag di maau. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Yom unum uneep sualen, leso Yoova to Maaron to yes Israela ne, mata payom ve uyooŋ ila nima samba. Ye iwatag ŋgar poia to yom ughami. Tovenen ye pale igham lem atia poia kat, ve igham poian ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut ipamuul Boas aliŋa ighaze: “Tiina tiou, yom ugham poian ghou kat. You liva sorok. You nanimale uraata tiom ndiliva tonowen ne maau. Eemoghon lolom isamin ghou, ve usavia saveeŋ popoia payou. Tauto ugham lolog poia kat.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Sawa to tighan aniiŋ, Boas ipoi Rut ighaze: “Ai, unum ugham am mberet pida, ve uzeeva ila sur lolo ve ughan.” Tovenen Rut yesŋa yes uraata mboledi izi, ve Boas igham bali mazooza pida pani. Rut ighami ve ighani le apo isuŋ, ve aniiŋ toni alulu ineep. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Tighan le isob, ve Rut imuul ila pa uraat. Boas isaav ariaŋa pa yes uraata toni tovene: “Ighaze Rut iyou bali ila le igharau pa bali poos eta, yam ayou avomim pani malep. Apuli ve iyou. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ve sawa to apoos bali, apas pida, ve asuruuv di tizi taan. Leso ye ilat iyou di. Ve matamim iŋgal: Ayou avomim pani malep.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Tovenen Rut iyouyou bali le rabrab izi. Ghoro indou di, ve ilos di le anoŋadi titaptap tizi, ve ikor di ila nakaral lolo. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ghoro iŋgudi, ve imuul ila pa paanu, ve ipatooŋa pa rawa liva. Ve aniiŋ mazooza to ye ighani ve alulu ineep, nene ye igham pani paam. ");
INSERT INTO tuc_o_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tovenen Naimi ighasoni ighaze: “Aazne, yom uyou bali tonene izi sine? Yom ugham uraat ila uum to sei? Ŋgeu to mata iŋgal ghom ve iuul ghom, poia to Yoova pale iza toni.” Rut ipamuul aliŋa ighaze: “Aazne, you nagham uraat ila uum to ŋgeu eez, iza Boas.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Tovenen Naimi isaav pani ighaze: “Yoova pale ighur poia toni iza to Boas ve igham poiani! Ŋgar to Yoova to lolo ineep tuŋia ila to tamtoghon toni ve iuluul di, nene isob maau. Ye mata iŋgalŋgal yes mateeŋa ve iit to tanepneep ne paam.” Ve Naimi isaav muul ighaze: “Ŋgeu tonowen yesuru Elimelek, yes toŋvetaz. Yesuru siŋ ee moghon. Ye pale iyoon pait ve iuul ghiit pa pataŋani toit.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ghoro Rut isaav muul ighaze: “Ve mbeb ite. Boas isaav payou ighaze irau yeiŋa uraata toni ndiliva nigham uraat tovene le sawa to bali isob.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naimi isaav pa Rut ighaze: “Natug liva, ughita. Nene poia kat. Yamŋa uraata ndiliva to Boas agham uraat ila uum toni moghon. Ula pa uum to ŋgeu ite paam malep. Pa vene, undeeŋ pataŋani ma venen.” ");
INSERT INTO tuc_o_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tovenen Rut yesŋa uraata ndiliva to Boas tighamgham uraat le sawa to mbutuuŋ bali ve wit isob. Sawa tonenen, Rut ineep toman rawa liva. Ipuli maau. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Tinepneep le muri ghoro, Naimi isaav pa Rut ighaze: “Natug liva, you naghaze nakaal lem ŋgeu eta leso iŋgin ghom ve uneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ulooŋ. Boas to yamŋa uraata toni ndiliva aghamgham uraat ne, yesuru rawam Elimelek siŋ ee moghon. Mboŋ aazne, ye pale igham uraat izi ndug to tiriiŋ bali. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Tovenen ula uririu, ve ugham naunauŋ vuzi poia ila tinim, ve undud ghom pa nonogiiŋa poia eta. Ugharaat ghom le isob, ghoro ula ughita Boas izi ndug to tiriiŋ bali. Eemoghon upatooŋ taum pani rikia malep. Unepneep ve matam ilala pani. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Sawa to ye igham uraat toni le isob, ve ighan ve ighun le isob, ve ighaze igheen, ghoro matam kisin ndug toni to ghenooŋ. Usaŋani le igheen lolo imaagh, ghoro ula uit kaukauŋ pa aghe iza, ve ugheen izi aghe pughu. Ve ighaze ye isavia saveeŋ eta payom, ghoro ulooŋ aliŋa ve utaghoni.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut ipamuul aliŋa ighaze: “Poia. Saveeŋ isob to yom usavia ne, pale nataghoni.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Tovenen Rut imundig, ve ila pa ndug to tiriiŋ bali, ve itaghon saveeŋ isob to rawa liva isavia pani. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas ighan ve ighun le isob, ghoro lolo poia kat, ve ila igheen izi bali ndouŋ dige. Ghoro Rut ipasi poipoi ila le iit kaukauŋ pa Boas aghe iza, ve izi igheen to Boas aghe pughu. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Boas ighengheen le mboŋ anoŋa, ghoro imundig ve ighaze itoora, le ighita liva eez ighengheen izi aghe pughu! Tovenen ighasoni ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Ou, yom sei?” Rut ipamuul aliŋa ighaze: “Tiina, nene you, mbesooŋa tiom Rut. Irau yom utir kaukauŋ tiom mata izala poghog? Pasa, yamru Elimelek siŋ ee moghon. Tovenen yom irau uyoon payou ve uul ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas isaav pani ighaze: “Natug liva, poia to Yoova pale iza tiom. Ŋgar to yom ughami ne, itaghon katin ŋgar to lolood ineep tuŋia ila to siŋ toit. Ve ilib pa ŋgar popoia pida to yom ughamgham di pa rawam liva Naimi. Pasa, nditamoot papaghu katindi tinepneep. Pida mbaliiŋ taudi, ve pida mbolaaŋa. Eemoghon yom ugham ŋgar pa todi eta maau. Yom uŋarua ghou pasa, you siŋ to azuwam. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Natug liva, umatughez ve ugham ŋgar naol malep. Mbeb tisob to yom ughason ghou pani, you pale nagham di. Pasa, tamtoghon to sualen tisob tiwatag tighaze yom liva poia. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Saveeŋ tiom, nene onoon. Yeru azuwam to imaat ne, siŋ ee moghon. Tovenen you irau nayoon payom ve nauul ghom. Eemoghon pughu tiou saguan ris. Ve ŋgeu ite inepneep. Pughu toni igharau kat pa azuwam. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Uneep sualen le ndugizau. Mboŋmaagh, ghoro you nala napalooŋ ŋgeu tonowen: Pale itaghon ŋgar to toŋvetaz ve iuul ghom, ma maau? Ighaze mbeb ighur pooi, nene poia. Ve ighaze maau, you taug pale nayoon payom ve nauul ghom. Saveeŋ tonene, you nambua iyaryaaŋ ila Yoova to Maaron mata yaryaara ne mata. Yo, yom irau ugheen sualen le ndugizau, ghoro ula.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tovenen Rut igheen izi Boas aghe pughu. Ndugizau sone ve Rut imundig ighaze imuul ila pa paanu. Leso tamtoghon eta ighita sob. Pasa, Boas isaav pani ighaze: “Lolog pa tamtoghon tiwatag tighaze yom unum tiou izi ndug to uraat tonene malep.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ve Boas isaav pani ighaze: “Ugham nonogiiŋa tiom to moŋeŋaaŋ ve uraava.” Tovenen Rut iraav nonogiiŋa toni, ve Boas ikor bali anoŋa izila le ivon. Ghoro iiti izala Rut daba, ve iŋgudi imuul ila pa paanu. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut ila ivot to rawa liva, ve Naimi ighasoni ighaze: “Natugliva, taum tonanan? Vena?” Ghoro Rut ipaesia mbeb tisob to Boas igham pani. ");
INSERT INTO tuc_o_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ve isaav muul ighaze: “Ughita. Ye igham aad bali anoŋa tonene paam. Pasa, lolo pa nimag ŋginiŋa ve namuul nanim tiom malep.” ");
INSERT INTO tuc_o_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naimi ilooŋ saveeŋ toni, ve isaav pani ighaze: “Natug liva, atem izi. Uneep ve taghita sa ŋgar to pale ivot. Aazne, Boas irau mbole izi maau, le igharaat saveeŋ tonene le deŋia.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Sawa tonenen, Boas malmali ila ndug to lupuuŋ to ineep igharau ataam avo, ve mbole izi tonowe. Mala maau ve ŋgeu to Boas isavia pa Rut ne, inim. Ŋgeu tonowen, yesuru Elimelek siŋ ee moghon. Boas ighita, ve isaav ila pani ighaze: “Ai toghag, unum mbolem izi. Pasa, you leg saveeŋ payom.” Ye ilooŋ aliŋa ve ila mbole izi. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ghoro Boas ila iyou ndolman saaŋgul to ndug Betelem tinim, ve isaav padi ighaze: “Anim mbolemim izi sualen.” Tovenen ndiran tonowen tila mboledi izi tomani. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ghoro Boas ipamundigin saveeŋ pa togha tonenen ighaze: “Ughita. Naimi to ŋgaramus ipul taan to yes Moapa ve imuul inim, ye ighaze igholia taan to siŋ toit Elimelek. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Tauto nasaav payom pani. Ighaze lolom pa taan tonowen, ghoro ugholi ila yes ndolman ve tamtoghon pida to itiŋa tanepneep ne matadi. Pasa, pughu tiom igharau kat pa Elimelek, ve you nataghon ghom. Tamtoghon ite paam maau. Tovenen yom irau ughol taan toni. Ve ighaze lolom pa taan tonowen maau, usaav ghazooŋa payou ve nalooŋa. Leso nagholi.” Ŋgeu tonenen ipamuul aliŋa ighaze: “Poia. Pale nagholi.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Tovenen Boas isaav pani muul ighaze: “Poia. Ighaze yom ughol taan tonowen ila to Naimi, yom irau ugham naar Rut, to Moap tidi ne paam inim azuwam, ve uŋgini. Leso taan tonowen taudi to timaat ne, izadi iyondyood pa taan todi.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ŋgeu tonenen ilooŋ saveeŋ tonene, ve isaav ighaze: “Ee-e you irau nagholi maau. Onoon, you irau nayoon pa Naimi ve nauuli. Eemoghon irau nasakia taan, ma mbeb tiou pida ila to ŋgeu ite ndinatu ne maau. Tambaŋa. You naneep, ve yom ugholi.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Muuŋ, yes Israela gabuadi tovene: Ighaze tighol taan eta, ma tiparabol pa mbeb pida, nene todi eez ipas duduuŋa to aghe izi, ve ighami ila to ita ite to yesuru tiparabol pa mbeb todi. Leso ipariaaŋ saveeŋ mbuaaŋ todi.) ");
INSERT INTO tuc_o_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Tovenen Boas togha to irau iyoon pa Naimi, isaav pani ighaze: “Yom taum ughol taan tonowen.” Ve ipas duduuŋa to aghe, ve igham pa Boas. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ghoro Boas isaav pa yes ndolman ve tamtoghon pida to tineep toman di ighaze: “Aazne, yam aghita pa matamim wa. Mbeb tisob to Elimelek toman ndinatu ru Malon ve Kilion, nene you pale naghol di ila to Naimi. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ve Moap tidi Rut to Malon naar toni, ye paam, you pale naghami inim azuwag. Leso Elimelek ve ndinatu ru to timaat ne, izadi iyondyood pa taan todi, ve toŋvetaz todi toman ndug todi pughu paam, matadi kisin izadi, ve iseeŋga itaghoni taghoni gha ila. Aazne, yam asob aghita pa matamim.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yes ndolman ve tamtoghon pida to yesŋa tinepneep izi ndug to lupuuŋ tonowen tighaze: “Onoon! Yei nighita pa matamai wa. Azuwam paghu tonowen ighaze ilat ruum tiom, nene pale Yoova iuuli ve ipoop tamtoghon naol, inimale muuŋ igham pa nditimbuud liva ru, Rael ve Lea, to tipoop iit Israela pughuud. Ve yom pale unum tiina izi Eprata, ve lem izam tiina izi Betelem. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Yoova pale igham azuwam paghu tonanan ipoop lem ndinatum katindi. Leso siŋ tiom timasa tinim naol tinimale Yuda yesuru Tamar natudi Peres papaghu toni.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Tovenen Boas igham Rut inim azuwa. Yoova iuul Rut le apo, ve ipoop natu tamoot eez. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Tovenen Betelem tidi tisaav pa Naimi tighaze: “Tapait Yoova iza! Pasa, ye ipul ghom uneep sorok maau. Aazne, igham lem timbum poia eez. Tauto muri pale lem tamtoghon to iyoon payom ve iuul ghom. Ve yes Israela pale tighita tighaze ye iza tiina. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Rawam liva Rut lolo ineep tiom kat. Onoon, yom lem natum tamoot eta muul maau. Ve ighaze yom lem ndinatum nditamoot liim ve ru, yes irau tiuul ghom tinimale rawam liva tonene maau. Ughita. Aazne, ye ipoop lem timbum poia eez. Muri, sawa to unum liva waat, yom pale uneep ila timbum tonene nima, ve nepooŋ tiom pale poia kat.” ");
INSERT INTO tuc_o_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ghoro Naimi imundig ve isavag timbu tonenen, ve igham payamyam pani. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Tovenen Betelem tidi tisaav tighaze: “A ghara, Naimi igham le paghu eez wa.” Ve tiwaat pain tonenen iza Obet. Obet tonene to natu Yesi. Ve Yesi natu, nene kinik David. ");
INSERT INTO tuc_o_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Nene pitiiŋ to Peres papaghu toni: Peres natu, nene Ezron, Ezron natu Ram, Ram natu Aminadap, Aminadap natu Nason, Nason natu Salmon, Salmon natu Boas, Boas natu Obet, Obet natu Yesi, ve Yesi natu, nene David to inim kinik tiina to Israel. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Sei to poia to Maaron izaza toni ve tini iza? Nene ŋgeu to izorzoor ndiran samsamiadi ŋgar todi. Ve yes to tiyel pa ataam to Maaron, ye itaghon ŋgar todi maau. Ve ndiran to tiveveleg Maaron paam, ye ilup toman di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Saveeŋ to Maaron toman tutuuŋ toni, nene ighami lolo poia le poia kat. Ve ighamgham ŋgar pani irau mboŋ ve ndag. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Tamtoghon tovene, ye inimale ai to tivazogi igharau ya to ireer. Sawa to anoŋa ivot, nene pale ighur anoŋa popoiadi. Ve sawa to ndag tiina, raua irau imalai maau. Tamtoghon tovene, uraat toni isob ilaan poia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Eemoghon ndiran samsamiadi, nepooŋadi tovene maau. Yes tinimale buzbuz to ighaze yaghur imundig, ghoro iviviira ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tovenen sawa to Maaron iŋgabiiz tamtoghon ve ighur atia padi, ndiran samsamiadi pale ledi saveeŋ maau, ve titud moghon. Ndiran to ghamuuŋ sosor irau tineep toman tamtoghon deŋiadi ila lupuuŋ todi ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Tovenen tamtoghon deŋiadi, Maaron mata padi, ve iŋginŋgin di pa laghooŋ todi. Eemoghon ndiran to titaghon ataam samia, yes pale tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Pughu vena to ndug ndug atedi yabyab ve tighaze tipamundigin malmal? Tamtoghon tikaal ataam pa tigham didiaaŋ pasa? Ŋgar todi irau ighur maau. Tighami sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Yes kinik to taan tigham aghedi tighaze tigham malmal. Ve yes pooza tilup di, ve tikaal ataam pa tizoor Yoova ŋgar toni ve titatan ŋgeu to ye ighuri inim kinik. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Yes tighaze: “Yo! Takuup ravraav toman sen todi to tikau ghiit pani ne, ve tapiyaav di tila. Leso tiŋgin ghiit muul sob.” ");
INSERT INTO tuc_o_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Eemoghon Yoova ineep ila ina to ghamuuŋ pooz izi ndug sambam, ve iŋiŋ padi. Ye mata velegin ŋgar todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ghoro isaav ariaŋa padi toman ate yabyab. Ate malmal, ve ipamatughezan di. Ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“You naghur tamtoghon tiou eez igham naghog ve inim kinik. Ye ineep izi lolooz tiou patabuaŋ Zion, ve ighamgham pooz.” ");
INSERT INTO tuc_o_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kinik to iit Israela isaav tovene: “You pale navotia saveeŋ to Yoova imbua toman ghou. Ye isaav payou ighaze: ‘You natug yom. Yom tamam to you. Aazne, you naghur ghom pa uraat. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ughason ghou, ghoro you nagham ndug ndug tinim lem. Tamtoghon to tineep irau taan dige to naol ne pale tinim lem, ve uŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Pooz tiom pale ariaŋa kat, inimale titi to kinik to tigharaata pa ain. Yom pale urab matin kinik tisob tapiridi. Pale tisami tinimale uur to tirabi le berberia.’” ");
INSERT INTO tuc_o_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Tovenen, yam kinik asob agham ŋgar pooi. Ve yam pooza to taan, alooŋ saveeŋ ve apatum gham. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Amatughez pa Yoova, ve ambees pani. Atandag pani, ve apaiti toman tinimim iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Aput aghemim pa Natu, ve aneep ila samba. Pa vene, Maaron ate yabyab payam, ve imundig ireu gham asob alalemim. Pasa, ye ate tuku. Eemoghon yes to tiyooŋ ila toni, poia toni pale iza todi, ve tineep toman tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","O Yoova, you koiagŋa katindi. Ival tiina kat timundig tighaze tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Yes tisavsaav payou tighaze: “Maaron ipul muri pani wa. Irau iuuli muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Eemoghon Yoova, yom unum sigeu payou ve upoon ghou. You tinig iza pasa, yom ugham izag inim tiina, ve upalot ghou le nalib pa koiagŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","You nataŋ roran Yoova toman aliŋag tiina naghaze iuul ghou. Ve ye ineep izi lolooz toni patabuaŋ, ve ilooŋ ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Tovenen you nazi nagheen le lolog imaagh. Pasa, Yoova tau to mata pa ghenooŋ tiou le namundig muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ighaze koiagŋa ndiŋndiŋ ndiŋndiŋ saaŋgul (10,000) tiluvut ghou pa tigham malmal payou, you irau namatughez padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","O Yoova, rikia moghon umundig ve uul ghou! Urab koiagŋa azedi le livodi ipolpol. Ve urab matin tapiridi le isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yoova, yom moghon to irau ugham mulin ghou. Ughur poia tiom iza to tamtoghon tiom tisob, leso tinidi iza ve tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","O Maaron, you nataŋ roran ghom. Lolom isamin ghou, ve ulooŋ suŋuuŋ tiou. Pasa, pataŋani igham ghou ve leg ataam maau. Upas ghou navot pa pataŋani tonene. Leso upaghazoŋan ghou ila tamtoghon matadi ughaze ŋgar tiou deŋia ila matam. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Oyai, yam to atatan ghou ve awaghamun izag, ŋeez o apul ŋgar tiam tonanan? Yam aghur lolomim pa ŋgar soroksorok to le anoŋa maau, ve ataghon ŋgar kaarom. Ŋeez o apuli? ");
INSERT INTO tuc_o_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Yam awatag: Yes to lolodi ineep tuŋia ila to Yoova ve titaghon ataam toni, ye isia di tinim le wa. Tovenen sawa to you nataŋ rorani, ye pale ighur taliŋa payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Amatughez pa Maaron, ve agham sosor muul malep. Sawa to yam aneep ila inamim to ghenooŋ, neneeŋamim, ve matamim iŋgal taumim ve agham ŋgar pooi pa saveeŋ tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Anumeer Yoova ve agham watooŋrau pani toman lolomim. Leso watooŋrau tiam deŋia ila mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Tamtoghon naol tikausim tighaze: “Oyai, ŋeez o tagham nepooŋ poia!” Eemoghon you naghaze: “Yoova, lolom poia payei, ve upatooŋ taum payei.” ");
INSERT INTO tuc_o_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Yom ugham ghou tinig iza ve lolog poia kat, ilib pa yes to aniiŋ ve vaen anoŋa katindi tivotvot ila uum todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Tovenen you ateg izi, ve nazi nagheen le lolog imaagh. Irau namatughez maau. Pasa, Yoova, yom taum matam payou ve uŋgin ghou naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","O Yoova, ughur taliŋam pa aliŋag, ve ulooŋ taŋiiz tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Yom kinik tiou ve Maaron tiou. Moghon moghon, suŋuuŋ tiou iŋaŋarua ghom. Tovenen ughur taliŋam pa taŋiiz tiou tonene ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yoova, mboŋmaagh to naol ne, yom uloŋlooŋ aliŋag. Ighaze ndugizau, you naghurghur ghasoniiŋ tiou ilat tiom, ve naghur matag payom pa uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Maaron, yom lolom pa ŋgar samia maau kat. Ndiran samsamiadi irau tineep toman ghom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ve ndiran pakuruuŋa irau tiyoon ila matam maau. Pasa, yom ughur koi pa tamtoghon tisob to tighamgham ŋgar samia. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Yes to avodi kaarom, yom ureu di tilaledi. Ve ndiran tombanooŋa ve yes to tirabrab tamtoghon le naghodi siŋ, yom lolom padi rita maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Eemoghon lolom ineep tuŋia inim tiou ve uluul ghou itaghon saveeŋ mbuaaŋ tiom. Tauto you irau nalooŋ nalat rumai tiom. You naroron payom, ve naput agheg payom ila rumai tiom patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Yoova, ŋgar tiom, nene deŋia moghon. Ugham pooz payou, ve upatooŋ ghou pa ataam tiom, leso nataghoni kat. Pasa, koiagŋa tighaze tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Saveeŋ onoon eta ivot ila avodi maau. Ve lolodi igham pa ŋgar samia moghon tighaze tiwaghamun tamtoghon. Yamadi tortoraaŋ saveeŋ. Avodi inimale naal to avo ikakaak. Tisasavia saveeŋ ŋgoreeŋa naol pa titombaan tamtoghon ve tiwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O Maaron, uvotia sosor todi ivot ighazooŋ, ve ughur atia padi. Ŋgar samsamia to tighamgham di, upamuul di tila pa taudi ve iwaghamun di. Moghon moghon, yes timamalaaŋ pa tutuuŋ tiom. Tovenen undiir di tilaledi. Pasa, yes tizorzoor ghom, ve tighamgham didiaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Eemoghon tamtoghon tisob to tiyooŋ ilat tiom, pale tinidi iza. Yes pale timbou toman lolodi poia irau sawa isob. Yes to lolodi ineep ilat tiom, yom uvool todi ve upoon di. Leso lolodi poia kat, ve tipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","O Yoova, poia tiom izaza to yes to titaghon katin saveeŋ tiom. Yom lolom padi ve poia tiom inim sigeu padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","O Yoova, uyaan ghou toman atem yabyab malep. Ve ighaze ughur pataŋani iŋarua ghou pa upasaluŋgan ghou, ughami toman atem yabyab kat malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yoova, you mbesooŋa tiom. Lolom isamin ghou ve uul ghou lak! Pasa, tapirig isob wa. O Maaron, ugham ghou tinig poia. Pasa, tuag tisob tiyabyab. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Yoova, lolog ipataŋan kat. Pale upul ghou tovene ila ila le ŋeez o isob? ");
INSERT INTO tuc_o_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yoova, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen matam iŋgal ghou muul, ve upas ghou navot pa pataŋani tonene. Ugham mulin ghou lak. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Pasa, mateeŋa irau matadi iŋgal ghom muul maau. Sei to pale ighengheen ila naal ve ipait ghom? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","You nayakyak le tapirig isob. Mboŋ to naol ne, nataŋtaŋ le matag suru ipot ila moogh tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Lolog ipataŋan kat ve nataŋ tiina le matag isarsar. Pasa, koiagŋa katindi. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Yam ndiran to aghamgham ŋgar samsamia, asob aghau payou! Pasa taŋiiz tiou, Yoova ilooŋa wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","You nataŋ roran Yoova pa ulaaŋ, ve ilooŋ suŋuuŋ tiou. Ghasoniiŋ tiou, ye pale iyok pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Pale igham koiagŋa tisob timatughez tiina ve mayadi. Yes pale tiwaghamgham, ve titoor di rikia moghon, ve titud moghon ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Yoova, yom Maaron tiou. You nayooŋ ilat tiom. Ndiran samsamia tigham taghon ghou tighaze tiwaghamun ghou. Uul ghou ve ugham mulin ghou ila nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Pa vene, tirab ghou, ve tiwaghamun ghou inimale laion isaas motin tamtoghon, le ŋgiira ŋgiira. Pasa, leg itag ite eta pa igham mulin ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yoova, Maaron tiou, ndiran to tighaze tigham samin ghou, you nagham sosor eta padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Tamtoghon to yeiŋa nimbua saveeŋ pa nilup ghei ninim ee moghon, you nagham ŋgar samia eta padi maau. Ve yes to tighur koi payou sorok, you nayub mbeb todi eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Ighaze you nagham sosor tovene, nene poia pa koiagŋa tigham taghon ghou ve tikis ghou, ve tivazag ghou ila taan, ve nagheen izala ghavuur. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yoova, umundig toman atem yabyab, ve ureu koiagŋa. Pasa, atedi yabyab kat payou. Maaron tiou, umundig rikia moghon ve uul ghou. Ughur atia iŋarua koiagŋa pa ŋgar to tighami. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Uyou tamtoghon tisob tila tilup di ila naghom. Uneep ila inam to ghamuuŋ pooz izi ndug sambam, ve ugham pooz padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yoova, yom uŋgabiiz tamtoghon to ndug ndug, ve ughur atia padi. Uŋgabiiz ghou ve upaghazoŋan ghou ila tamtoghon matadi, leso tiwatag tighaze you ŋgeu deŋiag, ve gabuag toman ŋgar tiou isob, nene poia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Maaron, ŋgar to yom ughamghami, nene deŋia moghon. Ve yom uwatag katin tamtoghon lolodi ve ŋgar todi. Ndiran to tighamgham ŋgar samsamia, upasob ŋgar todi tonowen. Ve upalot ndiran deŋiadi, leso tiyoon ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Maaron, yom moghon to unum sigeu payou. Yes to ŋgar deŋia ineep tuŋia ila lolodi, yom ugham mulin di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Maaron, gabizooŋ tiom, nene deŋia moghon. Ndag to naol ne, yom upatooŋ mbalmbali tiom pa ndiran samsamia. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Tamtoghon to ighaze itoor ŋgar toni maau, nene pale Maaron ipot buza ve iyool pane toni pa ighur atia pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Tamtoghon tovene, Maaron igharaat ndaab toni pataghaaŋ pa irabi. Ve igharaat pane natu toni ve itun mata pa yab, leso ivanegi. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Ndiran samsamia tinimale liva to apo ve ighaze ipoop. Pasa, lolodi ivon pa ŋgar samsamia naol to tighaze tigham pa tamtoghon. Ve muri, ghoro ŋgar to ineep ila lolodi ne anoŋa ivot. Nene kaarom naol to tiwaghamun tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ŋgeu to ighaze itai saambu pa tamtoghon eta, nene pale tau itap izila saambu tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ŋgar samia to ye ighaze igham pa tamtoghon, nene pale imuul pa tau. Ve malmal to ye ighaze igham padi, nene pale iwaghamun tau. ");
INSERT INTO tuc_o_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","You lolog poia pa Yoova, ve napaiti pa ŋgar toni deŋia. You nambou mbouŋ ve napait iza. Pasa Yoova, ye Maaron tiina kat to ilib pa ndimaronŋa tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","O Yoova, Tiina tiei, yom upatooŋ izam tiina irau taan isob. Yom upambood taum pa ŋgurubam to tiina kat. Ilib pa mbeb tisob to sambam paroŋania. ");
INSERT INTO tuc_o_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Yom ughur yes ndipain ve yes to gegegeu kat pa tipait izam ve tipatooŋ tapirim. Leso ugham koiamŋa neneeŋadi, ve upoon yes ndiran to didiaaŋ avodi. ");
INSERT INTO tuc_o_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Matag izala pa sambam paroŋania, ve naghita nimam muri inepneep. You naghita kaiyo ve pitum to yom taum ughur di tila inadi, ");
INSERT INTO tuc_o_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ve naghaze: “Yei tamtoghon to taan, ninim sa mbeb poia, to yom matam iŋgalŋgal ghei? Pughu vena to matam payei? ");
INSERT INTO tuc_o_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Yom ughur ghei nizi ris moghon pa yes aŋela ve yom taum. Ve upakur ghei ve ugham izamai ivot inim tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yom ughur ghei pa niŋgin nimam muri, ve ughur mbeb tisob tineep ila sambamai: ");
INSERT INTO tuc_o_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ŋgai naol to paanu, ve mbeb tisob to tineep ila su, ");
INSERT INTO tuc_o_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","man tisob to tirovroov ila tata paroŋania, ve iigh tisob to tighaughau ila te lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Yoova, Tiina tiei, yom upatooŋ izam tiina irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","O Yoova, you napait ghom pa poia tiom toman lolog. Ve naghaze navotia uraat gharatooŋadi to yom ughamgham di. Uraat tonanan, ite kat. Tamtoghon tighita di le ŋgar todi isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","You lolog poia kat ve tinig iza payom. Yom Maaron tiina to ulib pa ndimaronŋa tisob. Tovenen you pale nambou, ve napait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Sawa to koiagŋa tighita katin tapirim, yes titoor di, ve tighaze tighau. Eemoghon titaptap tizi le tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Yom uneep ila inam to ghamuuŋ pooz, ve uŋgagabiiz tamtoghon. Ve gabizooŋ tiom, nene deŋia moghon. Yom ughita ghou ughaze ŋgar tiou deŋia. Tauto uul ghou pa saveeŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Yom uyaan ndug ndug to tiwatag ghom maau, ve ureu tamtoghon samsamiadi tilaledi. Yom umus izadi tilaledi wa. Irau tamtoghon matadi iŋgal di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Koiagŋa tisami wa. Pale tineep tovene itaghoni taghoni gha ila. Ve ndug todi paam, yom ureu mbirisan di le tisob tilaledi. Tovenen tamtoghon pale lolodi imaagh padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yoova ineep ila ina to ghamuuŋ pooz, ve iŋgin mbeb irau sawa isob. Ye ighur ina tonowen, ve inamnaam pa iŋgabiiz tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ye iŋgagabiiz tamtoghon tisob to taan, ve ighagharaat pataŋani todi itaghon ŋgar deŋia. Ve igham pooz pa ndug ndug itaghon ŋgar raraate moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yoova inim ruum ariaŋa pa yes to koiadi tighur pataŋani padi. Ighaze pataŋani ivot, ye inim ledi ndug to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Yoova, yes to tiwatag katin ghom, tinumeer ghom. Pasa, ndiran to tizuaria di payom, yom irau upul murim padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Ambou ve apait Yoova. Ye ineep izi ndug Zion, ve ighamgham pooz. Uraat tintina to ye ighamgham di, avotia varudi le irau ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Yes to tirab tamtoghon le naghodi siŋ, Yoova ighurghur di maau. Pale iyat ŋgar todi tonowen. Ve tamtoghon to tinumeera ve timbadbaad pataŋani, ye irau lolo imaagh pa taŋiiz todi maau. Pale iuul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yoova, ughita pataŋani to koiagŋa tigham payou ne! Yes tiwaghamun ghou kat, ve rismoghon tone namaat. Lolom isamin ghou, ve upas ghou navot pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Leso nayoon ila ataam to ndug Zion, ve nasavia uraat tintina tisob to yom ughamgham di payou. Ve napait ghom toman tinig iza. Pasa, yom to ugham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Ndug ndug to tiwatag ghom maau, titai saambu leso tikis tamtoghon. Eemoghon taudi titap tizila. Malum to tiraara pa tisavag tamtoghon, nene taudi tiŋgudi muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yoova iŋgagabiiz tamtoghon, ve ighurghur atia padi itaghon ŋgar deŋia moghon. Leso ipatooŋ tau padi ve tiwatagi. Liis to ndiran samsamia tighuri, nene iliis taudi. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ndiran samsamia ve ndug ndug to tipul muridi pa Maaron, yes pale tisob timaat tizila ndug to mateeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Eemoghon yes mbolaaŋa to tirau mbeb eta maau, Maaron irau lolo imaagh padi maau. Ve yes to timbadbaad pataŋani ve tighurghur matadi pa ulaaŋ to Maaron, ye irau ipul di tineep sami itaghoni taghoni ila ne maau. Pale iuul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yoova, ughita. Tamtoghon sorok to taan tigham aghedi payom. Upul di tigham didiaaŋ malep. Utatan di tizi. Upayoon yes ndug ndug ila matam, uŋgabiiz di, ve ughur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O Yoova, ugham ŋgar eta padi. Leso timatughez payom, ve tiwatag tighaze yes tamtoghon sorok to taan moghon. Tapiridi irau ghom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O Yoova, pughu vena to uyoon saguan payou ve uul ghou maau? Vena to naneep ila pataŋani lolo, ve uyooŋ payou ne? ");
INSERT INTO tuc_o_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ndiran samsamia tipapait taudi, ve tinanaan yes mbolaaŋa to tirau mbeb eta maau. Eemoghon ŋgar todi samia to matadi iŋgali, nene pale imuul pa taudi ve iwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ndiran samsamia tipakur taudi pa ŋgar samia to tighamghami. Moghon moghon, tighamgham ŋgar pa tiyou ledi mbeb, ve tipipiyaav saveeŋ samsamia pa Yoova, ve tivevelegi. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ndiran samsamia tonowen, tipakur taudi pa ŋgar todi. Tauto lolodi pa tiwatag Maaron maau. Ŋgar todi iyaryaaŋ tighaze: “Maaron irau ighur pataŋani payou maau. Pasa, Maaron eta ineep maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Ve moghon moghon, uraat todi ilaan poia moghon. Tauto tinidi iza, ve tigham ŋgar pa sawa to pale Maaron iŋgabiiz di ve ighur atia padi ne maau. Ve matadi velegin koiadi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ve matadi iŋgal tighaze: “Mbeb eta irau igham ghei ruŋamai iza ne maau. Ve pataŋani eta irau ivot payei paam maau. Yei pale nineep poia moghon itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Saveeŋ samsamia naol, toman kaarom, ve matughezaaŋ ivotvot ila avodi irau sawa isob. Sawa to tisavia ŋgar samsamia ve pataŋani to tighaze tigham pa tamtoghon, nene igham lolodi poia kat inimale tighan aniiŋ poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Yes tiyoŋyooŋ ila ndug dige, ve tisasaŋan tamtoghon popoiadi. Tiyooŋ ve matadi inesnes pa yes to tirau malmal maau. Leso tisavag di, ve tirab di timaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Yes tiyoŋyooŋ ve tisasaŋan tinimale laion to ineep ila su lolo ve mata ivotvot. Tisasaŋan, leso tisavag yes to tirau malmal maau. Ighaze tisavag di ila malum todi, ghoro tikis di ve tiweu di tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Tovenen neneeŋadi ve tisasaŋan pa tisavag di. Sawa to ighaze eta peria, ghoro tisavagi. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ve matadi iŋgal tighaze: “Maaron mata inim payei maau. Ŋgar to yei nighami, ye irau ighita maau, ve iwatagi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Oyai, Yoova, umundig upatooŋ tapirim padi lak! Maaron tiei, yes to tinumeer ghom ve timbadbaad pataŋani, lolom imaagh padi malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Maaron, pughu vena to yom upul ndiran samsamia tiveleg ghom? Yes tisavsaav ila lolodi tighaze: “Ŋgar to yei nighami, Maaron irau ipayoon ghei pa savsaveeŋ maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Eemoghon Maaron, yom ughita ŋgar tisob to tigham di ne. Ŋgar samsamia ve pataŋani naol to yes tigham pa tamtoghon, yom uwatag di tisob, ve tineep ila nimam. Pasa, yes mbolaaŋa to tirau mbeb eta maau, tighur taudi tilat nimam ve tinumeer ghom. Yom taum to unum ulaaŋa pa yes parooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Eemoghon ndiran samsamia to tighamgham didiaaŋ, urab matin tapiridi. Uyat ŋgar todi samsamia. Leso ivot muul sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yoova, ye kinik tiina to ighamgham pooz. To aazne, ve itaghoni taghoni gha ila. Ndug ndug to tiwatagi maau ve tineep ila taan toni, ye pale ipasob di le tisob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Yoova, yes to tinumeer ghom ve timbadbaad pataŋani, yom uwatag lolodi wa. Yom pale ughur taliŋam pa taŋiiz todi, ve upalot di. ");
INSERT INTO tuc_o_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Yes parooŋa ve yes to koiadi tighur pataŋani padi, yom taum pale uyoon padi ve uul di, ve ughur atia pa koiadi. Leso tamtoghon sorok to taan tipamatughezan ndug muul sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","You nanumeer Yoova ve nayooŋ ila toni. Pughu vena to yam asavia saveeŋ to borouŋa payou aghaze: “Ughau uzala pa lolooz, inimale man imatughez ve iroov izala. ");
INSERT INTO tuc_o_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Ughita! Ndiran samsamia tiyoŋyooŋ ila ndoroom lolo. Yes tiyool pane todi, tighur pane natu ila ool, ve tisasaŋan tighaze tivaneg tamtoghon to ŋgar deŋia ineep tuŋia ila lolodi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Oyai, ŋgar ve tutuuŋ naol to tinim pughu pa nepooŋ poia, aazne tamtoghon tiwaghamun di le tisami wa. Tovenen ŋgeu deŋia pale igham vena? ");
INSERT INTO tuc_o_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Eemoghon Yoova, ye ineep ila rumai toni patabuaŋ lolo. Ye kinik to sambam to ineep ila ina to ghamuuŋ pooz. Ve mata ighita tamtoghon tisob, ve iŋgagabiiz ŋgar todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yoova iŋgagabiiz tamtoghon deŋiadi ve yes samsamiadi paam. Leso iwatag ŋgar todi. Yes to lolodi pa ŋgar to rabuuŋ tamtoghon, ye lolo padi rita maau. Ighur koi padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Tovenen ye pale igham yab ŋgiliŋi toman yaam salfa tuntunu to vuzi samia, titaptap tizi ve tiwaghamun ndiran samsamiadi. Ve igham yaghur tuntunu kat inim leso iwaghamun di. Nene atia todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Pasa, Yoova itaghon ŋgar deŋia moghon. Tovenen ye lolo pa tamtoghon to tighamgham ŋgar deŋia. Yes to titaghon ŋgar poia, nene pale tineep tomani, ve tighita nagho. ");
INSERT INTO tuc_o_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","O Yoova, uul ghei lak! Pasa, tamtoghon to lolodi ineep tuŋia ilat tiom ve titaghon ataam tiom, tisob wa. Yes to avodi onoon, eta ineep toman ghei muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Tamtoghon tisob tighamgham kaarom, ve tisasavia saveeŋ to le anoŋa maau ne pa nditadi. Yamadi tortoraaŋ saveeŋ. Saveeŋ to ivotvot ila avodi, nene poia. Eemoghon ŋgar to ineep ila lolodi, nene ite. ");
INSERT INTO tuc_o_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","4","Yoova, ndiran to tisasavia saveeŋ ŋgoreeŋ pa tamtoghon pa tigham lolodi, upoon avodi. Yes tipakur taudi tighaze: “Sei to inim daba payei ve iŋgin ghei? Yei avomai mata. Sa ŋgar to ighaze nisavia, nene pale tamtoghon titaghoni moghon.” O Yoova, ugham di neneeŋadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Tovenen Yoova isaav ighaze: “Yes mbolaaŋa to tirau mbeb eta maau, ve yes to koiadi tiwaghamun di, you nalooŋ taŋiiz todi wa. Yes tikausim pa nepooŋ poia. Tovenen aazne, you pale namundig ve nauul di. You pale nagham mulin di ila koiadi nimadi, ve nauul di tineep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yoova saveeŋ toni, nene onoon moghon. Kaarom eta ineep ila lolo maau. Saveeŋ toni, nene inimale silva to tighuri izala yab pa liim ve ru, leso muun isob ighau pani le iŋgalaaŋ kat. Tovenen iit irau taghur ila saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Onoon, aazne ndiran samsamia tipapakur di ve tilaagh irau ndug ndug. Ve ival tiina tipapait ŋgar samia. Eemoghon Yoova, yom matam payei, ve uŋgin ghei nineep pooi. Ve upoon ghei pa ndiran tovene irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Oyai Yoova, pataŋani tiina tonene ikis ghou sawa mala wa. Ŋeez o uul ghou? Pale lolom imaagh payou itaghoni taghoni gha ila? Vena to uŋgooz matam payou? Ŋeez o matam inim payou muul? ");
INSERT INTO tuc_o_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Sawa isob, you naghamgham ŋgar naol pa pataŋani tiou. Mboŋ ve ndag, lolog isami naghaze nataŋ. Pale koiagŋa tilib payou itaghoni taghoni gha ila? Ŋeez o unum uul ghou? ");
INSERT INTO tuc_o_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","4","Yoova, yom Maaron tiou. Matam inim payou, ve ughur taliŋam pa suŋuuŋ tiou tonene. Uul ghou ve ugham tapirig ivot muul. Pa vene, pataŋani tonene itatan ghou ve namaat, ve koiagŋa tipakur taudi tighaze tilib payou. Ighaze you natap ve nagham samia, nene pale koiagŋa tighita ve tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Eemoghon you nanumeer ghom. Pasa, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. You lolog poia kat. Pasa, you nawatag: Yom pale ugham mulin ghou pa pataŋani tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Tovenen you pale nambou mbouŋ ve napait Yoova iza. Pasa, ye igham poian ghou kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Yes kankanooŋa to lolodi imaagh pa Maaron, tigham ŋgar ila lolodi tighaze: “Maaron eta ineep maau.” Ndiran tovene, Maaron lolo padi maau kat. Pasa, ŋgar todi isami wa. Tauto tighamgham ŋgar samsamia naol. Eta igham ŋgar poia maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yoova ineep izi sambam, ve mata izizi pa tamtoghon to taan, ve iŋgagabiiz di. Ye ighaze ighita: Todi eta pale ighilaala, ma maau? Ve eta izuaria tau leso iwatag Maaron? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Tisob tipul ataam toni ve tisami wa. Eta igham ŋgar poia maau. Maau le maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Tovenen Yoova igham ŋgar naol ighaze: “Yes to tinoknok ghamuuŋ ŋgar samsamia ne, ledi ghilalooŋ, ma maau? Ŋeez o ŋgar todi ivot? Sawa isob, yes titombaan tamtoghon tiou, ve tipasob mbeb todi le isob kat, tinimale yes to tighan aniiŋ popoia le tipasobi. Matadi iŋgal ghou ve tisuŋ payou maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Eemoghon muri, matughezaaŋ tiina kat pale igham di. Pasa, Maaron pale ivool to tamtoghon deŋiadi to titaghon ataam toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Yes mbolaaŋa to tirau mbeb eta maau, yam ndiran samsamia aponpoon ataam padi. Tauto ŋgar todi le anoŋa maau. Eemoghon Yoova tau pale inim ledi inadi to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Oyai, Maaron to ineep izi ndug Zion iuul yes Israela, ve ipas di tivot pa pataŋani todi, ghoro poia! Ighaze Yoova iuul tamtoghon toni ve tineep poia muul, nene pale tinidi iza. Onoon kat, Yakop papaghu toni pale lolodi poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Yoova, sei irau ineep toman ghom ila inam patabuaŋ to suŋuuŋ? Ve sei irau ineep izi lolooz tiom patabuaŋ Zion, ve isuŋ payom? ");
INSERT INTO tuc_o_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Tamtoghon to le sosor eta maau, ve laghooŋ toni poia moghon. Ye ighamgham ŋgar deŋia, ve isasavia saveeŋ onoon moghon toman lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Ye iwaghamun tamtoghon izadi maau, ve igham ŋgar samia eta pa ndita maau. Ye iŋgal saveeŋ pa toŋvetaz toni maau, ve inin avo padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Ndiran samsamia to Maaron ipul muri padi, ye paam ipul muri padi. Ve yes to timatughez pa Yoova ve titaghon ŋgar toni, ye ipapait di. Sa saveeŋ to ye imbua, irau lolo imaagh pani maau. Ighaze ipataŋan pani pa itaghoni, nene poia. Eemoghon ye pale itaghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Ve ighaze ndita tigham bun ila toni, sawa to tiyati, nene pale tiyat yaam anoŋa moghon. Ye irau ipoi pa avua izala pogho maau. Ve ighaze tamtoghon tighaze tigholi leso iŋgal saveeŋ pa yes to ledi sosor maau, ye irau iyok padi maau. Tamtoghon to titaghon ŋgar naol tonene, yes pale tiyoon ariaŋa. Mbeb eta irau igham di ruŋadi iza ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","O Maaron, unum sigeu payou ve uŋgin ghou naneep pooi. Pasa, you nanumeer ghom, ve nayooŋ ilat tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","You nasaav pa Yoova: “Yom Tiina tiou. Ighaze naneep saguan payom, irau nandeeŋ mbeb poia eta maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Tamtoghon patabuaŋa to Yoova to tinepneep izi taan, yes popoiadi kat. Ighaze naneep toman di, yes tigham lolog poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Eemoghon ndiran to timbesmbees pa maaron kaaromŋa, pataŋani naol pale tiza todi. You irau nala toman di pa watooŋrau todi maau. Ve avog irau itut maaron todi izadi rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","You naghita Yoova naghaze ye inimale taan poia eez to tipuli payou pa naneep pani. Irau nambool pa mbeb eta maau. Pasa, you naneep ila ye nima. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Mbeb naol to you nagham di ilat tiom, nene popoiadi moghon. Onoon kat, nepooŋ tiou to Yoova igham payou, nene poia kat, inimale naneep ila taan paghuna eez to tipuli payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","You napait Yoova pa poia toni. Pasa, ye ighamgham pooz payou leso nataghon ataam poia. Mboŋ paam, ŋgar to ye ighuri ila lolog ne, ipatooŋ ataam payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Moghon moghon, matag iŋgalŋgal Yoova naghaze ye ineep toman ghou. Ye inepneep ila pa digeg waan ve ipapalot ghou. Tovenen mbeb eta irau igham ghou ruŋag iza ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Tauto tinig iza, ve lolog poia kat. Irau namatughez maau. Pasa, yom pale uŋgin ghou naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Irau upul murim payou, ve upul ghou namaat ve nazila ndug to mateeŋa ne maau. Pasa, you tamtoghon tiom. Lolog ineep tuŋia ilat tiom, ve nataghon ataam tiom. Irau upul patug imbuuz ila naal lolo ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Yom upatooŋ ataam to nepooŋ poia payou. Ighaze naneep toman ghom, nene pale lolog poia kat. Ighaze you naneep ila pa nimam waan, nene pale nayamaan poia tiom itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","O Yoova, ulooŋ taŋiiz tiou tonene, ve uul ghou. Upaghazoŋan ghou ila tamtoghon matadi ughaze you ŋgeu deŋiag. Leso tiwatag tighaze you nagham sosor eta maau. You nasuŋ ghom pa avog uli moghon maau. Nasuŋ ghom toman lolog. Tovenen ughur taliŋam pa suŋuuŋ tiou tonene, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Yom ughita mbeb tisob, ve uwatag ughaze you nataghon ŋgar deŋia ila matam. Tovenen uvool tiou ve upaghazoŋan ghou ila tamtoghon matadi ughaze you nagham sosor eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Yom uŋgabiiz poian ghou, ve utoov ghou. Ve unum utiir ghou pa mboŋ paam. Tauto uwatag katin lolog. Yom uŋgabiiz katin ghou, ve ughita ŋgar samia eta ineep ila lolog maau. Pasa, ŋgar tiou iyaryaaŋ naghaze avog igham sosor eta malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","You nataghon ŋgar to ndiran pida tighamghami ne maau. Pasa, matag kisin saveeŋ tiom. Tovenen ndiran samsamia to tighamgham malmal, you napaghau taug pa ataam todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Sawa isob, nataghon ataam tiom moghon. Agheg iyel pani rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Maaron, you nawatag: Moghon moghon, yom uloŋlooŋ suŋuuŋ tiou. Tovenen nataŋ roran ghom naghaze uul ghou. Ughur taliŋam payou, ve ulooŋ aliŋag tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen ugham uraat gharatooŋadi tintina ve uul ghou. Yes to tiyooŋ ilat tiom, nimam waan pale igham mulin di ila koiadi nimadi, ve tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Uŋgin poian ghou inimale uŋgin taum matam. Upoon ghou inimale tatareek ipakud ndinatu. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Pasa, ndiran samsamia tizuaria di tighaze le tiwaghamun ghou. Koiagŋa tiluvut ghou, ve tighaze tirab ghou namaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Lolodi isamin tamtoghon maau. Ve tipapait taudi izadi toman aliŋadi tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Yes titaghon ghou tinim tiluvut ghou wa. Ve matadi deŋia payou tighaze tikokor ghou, ve tiza payou nazila taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Yes tinimale laion to pitoola, ve ighaze isaas motin mbeb, leso ighani. Yes tinimale laion paghu to iyooŋ ila su lolo ve isasaŋan. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yoova, umundig urab koiagŋa lak! Uyoon unum sigeu payou, upoon di, ve utatan tapiridi. Ukas di pa buza tiom, ve ugham mulin ghou ila ndiran samsamia tonene nimadi. Leso naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Ndiran tonene tigham ŋgar tighaze mbeb to taan, nene mbeb tau. Upatooŋ nimam padi, ve ugham mulin ghou ila nimadi. Atia to yom ughaze ugham padi, ugham alulu padi sob. Upasobi pataghaaŋ. Leso tiyamaana kat! Ve ugham tovene pa ndinatudi ve iseeŋga ila iza to nditimbudi paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Eemoghon you ŋgeu deŋiag. Tovenen you pale naghita naghom. Sawa to namundig, you pale naneep ila naghom, ve nayamaana naghaze: “Aa, mbeb to nazuaria ghou pani, tauto naghami wa!” ");
INSERT INTO tuc_o_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","O Yoova, you lolog payom kat, ve naghamgham tapirig ilat tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yoova iponpoon ghou pa koiagŋa inimale raŋ to izala kat. Ve inim ruum ariaŋa pa nayooŋ ila lolo. Sawa isob, ye ighamgham mulin ghou pa pataŋani tiou. Maaron tiou iponpoon ghou pa ndaab inimale yaam tintina, ve you nayoŋyooŋ ila toni. Ye inim sigeu payou, ve ye Volaaŋa tiou ariaŋa. Ve ye inimale didiiŋ ariaŋa to iluvut ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Iit irau tapait Yoova iza! You napoii pa ulaaŋ, ve ye igham mulin ghou ila koiagŋa nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Liis to mateeŋ, rismoghon tone iliis ghou. Pataŋani naol titatan ghou tinimale dibom tintina to tipol izala poghog. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Ve ravraav ariaŋa to mateeŋ ikaukau ghou, ve rismoghon tone ighereb ghou nazila ndug to mateeŋa. Tovenen naghita liis to mateeŋ ineep ila matag. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Sawa to naneep ila pataŋani tonowen lolo, you napoi Yoova pa ulaaŋ. Nataŋ roran Maaron tiou naghaze inim iuul ghou. Taŋiiz tiou iŋarua, ve ye ighur taliŋa pani. Ye ineep ila rumai toni lolo, ve ilooŋ aliŋag. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Tovenen igham yoŋgyoog itok taan le taan katkatia, ve lolooz tisob pughudi tirur paam. Pasa, ye ate yabyab kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Mbuas ivot pa uzu saambu, ve yab yama toman ŋgiliŋi ivot pa avo, ve ighan suvun mbeb naol. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ghoro sambam paroŋania ikaak, ve ye iyoon izala yaghur tae asosooŋa, ve izi inim. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Ye ineep izala aŋela toni ariaŋa ndimo, ve iroov inim, inimale yaghur to le bage imbaada ve iroov inim. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ye ipoon tau pa ndoroom, leso inim le ina to yoŋgaaŋ. Yaghur tae asosooŋa ikaui, ve iŋgooz tau ila lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ye ineep tonowe toman ŋguruba tiina, ve igham ndug milia. Tauto lalaav kiliŋkiliŋia izi, ve ais patu patu toman yab ŋgiliŋi titaptap tizi pa taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yoova ineep izi sambam, ve isaav toman aliŋa tiina kat, inimale lalaav avolutu. Maaron Tiina To Ilib Pa Ndimaronŋa Tisob Ne aliŋa ivot. Ve yab ŋgiliŋi toman ais patu patu titaptap tizi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ye igham lalaav iŋgal koia inimale pane natu toni. Tauto matughezaaŋ tiina igham di, ve tiwaghaughau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yoova, sawa to upatooŋ mbalmbali tiom padi, yaghur tiina ivot pa uzum, ve iviviir te ila saguan, le magargaar ivot ighazooŋ. Ve taan pughu to ineep izila sila kat ne ivot peria. Mbeb eta ipoona muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ghoro Yoova ineep sala, ve izuzuun nima izi inim ikis ghou, ve indae ghou naza pa mazovan bibiliiŋa lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Koiagŋa tapiridi tintina, ve you narau di maau. Yes tighur koi payou kat. Eemoghon Yoova iuul ghou, ve ipas ghou ila nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Sawa to naneep ila pataŋani lolo, yes tipamundigin malmal payou. Eemoghon Yoova ipoon ghou ve ipalot ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Ye ipas ghou navot pa pataŋani tiou, ve ighur ghou nala naneep izi ndug poia. Pasa, ye lolo payou kat. Tauto igham mulin ghou ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","You nataghon ŋgar to deŋia ila Yoova mata. Tauto ye lolo payou ve igham poian ghou. Nimag isosor pa mbeb eta maau. Tauto ye igham leg atia poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Pasa, moghon moghon, you nataghon ataam to Yoova. Irau nagham ŋgar samia ve napul murig pa Maaron tiou ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Pasa, matag kisin tutuuŋ toni tisob. Tutuuŋ toni to tineep pataghaaŋ, you napul murig padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Tauto leg sosor eta ila mata maau. You naŋgin poian taug, tauto nagham mbeb eta isosor maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","You naghamgham ŋgar deŋia ve ŋgar ŋgalaaŋa moghon ila Yoova mata. Tauto ye lolo payou ve igham leg atia poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yoova, ighaze tamtoghon eta lolo ineep tuŋia ilat tiom ve itaghon ataam tiom, nene pale lolom ineep tuŋia ila toni paam ve uuli irau sawa isob. Tamtoghon to ighaze le sosor eta maau ve ŋgar toni isob popoia moghon, nene pale yom upamuul ŋgar poia pani paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ve ighaze ŋgeu eta ighamgham ŋgar ŋgalaaŋa moghon, nene pale yom paam ugham ŋgar ŋgalaaŋa pani. Eemoghon yes to ledi ŋgar tiina pa ghamuuŋ kaarom ve ŋgar samia, yom lem ataam naol pa uyat ŋgar todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Tamtoghon to titatan taudi, yom ughamgham mulin di pa pataŋani todi. Eemoghon yes to tipapait taudi ve tiveleg ghom, yom utatan di tizi tinim mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yoova, Maaron tiou, yom ugham ghazooŋa tiom isul ghou, ve undiir ndoroom ighau payou, leso naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Yom upapalot ghou. Tauto you irau naparab toman koiagŋa le nalib padi. Maaron tiou inepneep toman ghou. Tovenen you irau nayatov ghou le namalaaŋ pa didiiŋ ariaŋa to iluvut koiagŋa ndug todi, ve nalooŋ nala. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Ataam to Maaron, nene poia le poia kat. Ve saveeŋ toni, nene onoon moghon. Irau taghur ila kat. Tamtoghon tisob to tiyooŋ ila toni, ye inim sigeu padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yoova moghon to Maaron tau. Ite paam maau. Ye moghon to iponpoon ghiit inimale yaam tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Ye ipapalot ghou pa tau tapiri, tauto nayoon ariaŋa. Ve ye iŋgin ghou pa laghooŋ tiou, ve ipatooŋ ataam payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Ye igham agheg tuŋia ila taan, ve nalaan ariaŋa nanimale mekmek sagsag. Tovenen sawa to nalaagh ila ndug sapsapi, irau agheg kirikia ve natap maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ye ipatooŋ ghou pa ŋgar to ghamuuŋ malmal, ve ipalot nimag. Tauto you irau nandaad pane ariaŋa to tigharaata pa mbaras. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yoova, yom unum sigeu payou, ve ugham mulin ghou ila koiagŋa nimadi. Ve nimam waan, tauto ipapalot ghou. Yom uluul ghou, tauto izag inim tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Yom ugharaat poian agheg ina. Tauto agheg kirikia maau, ve nayoon tuŋia pa malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","You nalaan taghon koiagŋa nala le navot todi. Ve narab di tisob timatmaat. Eta ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","You narab di le tisob titaptap tizi agheg pughu. Eta irau imundig muul pa igham malmal payou ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Pasa, yom upapalot ghou pa taum tapirim. Tauto nayoon ariaŋa pa malmal. Yom ughur koiagŋa tinim nimag ve nalib padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Yom ugham di titoor di, ve tighau tila. Yes to tighur koi payou ne, you napasob di le tisob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Yes tipoi pa ulaaŋ. Eemoghon eta iuul di maau. Taŋiiz todi iŋarua Yoova paam. Eemoghon ye ilooŋ di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","You narab mbirisan di, le tinim ghavuur to yaghur iviviira gha ilale. Ve navazag di tinimale tiiŋ to ineep ila ataam. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Sawa to tamtoghon timundig ve tizoor aliŋag, yom uvool tiou, ve ugham mulin ghou ila nimadi. Ve ughur ghou nanim daba pa ndug ndug. Tamtoghon to taan pida to you nawatag di maau, aazne tineep ila sambag, ve timbesmbees payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ighaze tilooŋ aliŋag, nene rikia moghon ve titaghoni. Ndug ndug tinim ve tiput aghedi payou toman matughezaaŋ tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Pasa, tighilaal tighaze tirau mbeb eta maau. Tauto matughezaaŋ tiina igham di, ve tipul ruum todi ariaŋadi to tiyoŋyooŋ ila lolodi, ve tinim tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Onoon kat, Yoova inepneep! Ye iponpoon ghou inimale yaam tiina. Ye Volaaŋa tiou. Tovenen you napakuri ve napait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Ye ivool tiou, ve iyat ŋgar samsamia to koiagŋa tigham payou. Ve ighur ndug tisob tineep ila sambag. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Ye ipas ghou ila koiagŋa nimadi, ve iuul ghou le nalib padi. Ye igham mulin ghou ila yes to tirabrab tamtoghon ne nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Tovenen Yoova, you pale nalool ve napait izam ila tamtoghon to ndug ndug lolodi, ve nambou pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yoova iuluul yes to ye ighur di tinim kinik. Tauto tiliblib pa malmal tintina. Ye tau ighur David pa igham pooz. Tovenen lolo ineep tuŋia ila toni, ve pale ighur poia toni iza to David toman papaghu toni itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Mbeb to tineep ila sambam paroŋania, tisob tipatooŋ ghiit tighaze Maaron iza tiina. Mbeb to sala we, nene ye nima muri. Tauto tipatooŋ Maaron tapiri toman ŋgar ve poia toni pait. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Ndag to naol, tisavsaav pait. Ve mboŋ to naol, tipatooŋ ghiit pa ŋgar toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Yes ledi avodi to tisavsaav maau. Irau talooŋ aliŋadi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Eemoghon aliŋadi ila irau taan isob. Saveeŋ todi ila irau taan dige to naol. Maaron ighur ndag le ina ila sambam paroŋania, leso ineep pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Ndag pusukia iza inimale ŋgeu to ivai paghu, ve ipul ruum toni ve ivot toman tini iza. Ve inimale tamtoghon to landooŋ to igharaat tau leso ilaan toman lolo poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ndag iza pa taan dige eez, ve ila ilib pa dige ite. Ve mbeb eta irau iyooŋ pa mata ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Saveeŋ isob to Yoova igham pait, nene poia kat ve deŋia moghon. Ve ipariaaŋ ghiit ve igham tapiriid ivot muul. Ataam to Yoova ighuri pa tamtoghon toni, ineep tuŋia tovene. Irau itoora muul maau. Ve ipatooŋ yes to ledi ŋgar tiina maau ne, le ŋgar todi ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Tutuuŋ to Yoova ighur di, nene deŋiadi moghon, ve tigham ghiit lolood poia kat. Tutuuŋ to Yoova inim ghazooŋa pait, ve igham ghiit taghilaal. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Ŋgar to tamatughez pa Yoova ve tataghon ŋgar toni, nene poia. Ŋgar tovene iŋgalaaŋ ila ye mata, ve ineep tovene itaghoni taghoni gha ila. Ve gabizooŋ to Yoova, nene deŋia ve onoon moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Tamtoghon tighita yaam gol tighaze nene mbeb tiina, ve lolodi pani. Eemoghon Yoova saveeŋ toni ilib kat pa gol katindi to ŋgalaŋadi ne. Ve bagil suru tovene paam, poia ve poiawaat ila avood. Eemoghon Yoova saveeŋ toni, nene poia kat le ilib pa bagil suru. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yoova, you mbesooŋa tiom. Saveeŋ tiom ipaghau ghou pa pataŋani naol. Yes to titaghon saveeŋ tiom, nene pale tigham ledi atia tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Sei irau ighilaal sosor toni le isob? Maau. O Yoova, sosor naol to naghilaal di maau ve nagham di, lolom isamin ghou ve upul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","You mbesooŋa tiom. Sosor to naghilaal di, upaghau ghou padi. Lolog pa ŋgar tovene igham pooz payou malep. Leso nagham sosor tiina eta sob, ve ŋgar tiou deŋia ila matam. ");
INSERT INTO tuc_o_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Tovenen you naghaze le saveeŋ to ivot ila avog, ve ŋgar to ineep ila lolog, isob deŋia ila matam, ve igham ghom lolom poia. O Yoova, yom Volaaŋa tiou ve uponpoon ghou unumale yaam tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Sawa to ighaze yom uneep ila pataŋani lolo, Yoova pale ilooŋ suŋuuŋ tiom ve iuul ghom. Maaron to Yakop, ye iza tiina pa tapiri ve poia toni. Ye pale inim sigeu payom ve iŋgin ghom uneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Maaron ineep ila rumai toni patabuaŋ izi lolooz Zion. Ye pale iuul ghom ve ipalot ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Pale mata iŋgal watooŋrau tiom tisob. Irau lolo imaagh padi maau. Watooŋrau tiom to yab ighan suvun di, nene tighami lolo poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ve mbeb to yom lolom pani, ye pale igham payom. Ve sa ŋgar to matam iŋgali ughaze ughami, ye pale igham anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Muri, sawa to yom ulib pa koiamŋa, yei pale lolomai poia kat ve nilool. Pale nigham pilak tiei, ve nikakayab di tilala tinimnim, ve nipait Maaron toit iza toman tinimai iza. Mbeb tisob to yom ughason Yoova pani, ye pale ilooŋ ghom ve igham payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Ghara nawatag: Yoova pale iuul kinik to ye tau ighuri pa uraat. Ye pale ineep izi ndug toni patabuaŋ sambam, ve ilooŋ suŋuuŋ toni, ve ipaloti pa tau tapiri. Leso ilib pa koia tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Ndiran pida tinumeer karis todi to malmal, ve pida tipakur di pa hos todi. Eemoghon yei ninumeer Maaron tiei Yoova. Ye iza tiina pa tapiri ve poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Tovenen koiamai pale titaptap tizi. Eemoghon yei pale nimundig ve niyoon ariaŋa pa malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Yoova, ughur taliŋam pa taŋiiz tiei tonene, ve uul kinik tiei. Leso ilib pa koia. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","O Yoova, kinik tiei lolo poia kat. Pasa, yom upaloti pa taum tapirim. Yom uuli pa malmal le ilib pa koia. Tauto tini iza kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Mbeb to ye lolo pani ve ighason ghom pani, yom uŋguruuta maau. Yom ugham pani wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Yom ula uvot toni, ve upakuri pa mbeb popoia naol. Ve ughur moghar ndamooda milmilia izala daba. Moghar tonowen, tigharaata pa gol to poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ye ighason ghom pa uŋgin poiani ila sawa to malmal, leso imaat sob, ve ineep pooi itaghoni taghoni gha ila. Ve yom ulooŋ suŋuuŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Yom uuli le ilib pa malmal, tauto iza ivot inim tiina. Ve upambooda pa tapirim ve poia tiom. Tauto varu ilaan irau ndug ndug, ve tamtoghon tipaiti tighaze ye iza tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Onoon kat, poia tiom pale izaza toni itaghoni taghoni gha ila. Ve yom uneep tomani. Tauto lolo poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Kinik tiei inumeer Yoova. Tovenen mbeb eta irau ighami itap ne maau. Pasa, Maaron Tiina To Ilib Pa Ndimaronŋa Tisob Ne, lolo ineep tuŋia ila toni, ve iuluuli itaghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","O kinik, nimam pale ikis koiamŋa tisob. Yes to tighur koi payom, nimam waan pale isavag di. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Sawa to upatooŋ tapirim ivot ighazooŋ, yom pale uwaghamun di kat inimale yab tiina ighan mbeb. Onoon kat, mbalmbali to Yoova pale iza todi, ve yab toni ighan suvun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ndinatudi paam, yom pale upasob di pa taan. Tovenen muri, paghu todi eta irau ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Onoon, yes tikaal ataam payom, ve timbua saveeŋ tighaze tiwaghamun ghom. Eemoghon ŋgar todi samia tonowen irau ighur anoŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Sawa to tighita ghom undaad pane natu iŋarua di, yes pale timatughez ve tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yoova, umundig ve upatooŋ tapirim ivot ighazooŋ. Leso nimbou ve nipait izam pa tapirim. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Maaron tiou, Maaron tiou, pughu vena to upul murim payou? Pataŋani tiou igham ghou nataŋ tiina. Pughu vena to uul ghou maau, ve uneep saguan payou? ");
INSERT INTO tuc_o_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Maaron tiou, ndag to naol ne, nataŋ roran ghom. Eemoghon yom usavia leg saveeŋ eta maau. Ve mboŋ tovene paam. Ateg izi maau. Nanoknok taŋiiz. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Eemoghon Maaron, you nawatag: Yom patabuaŋ. Yom uneep ila inam to ghamuuŋ pooz, ve yes Israela tipapait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Muuŋ ve inim, nditimbumai tinumeer ghom. Yes tighur ilat tiom, ve yom upas di tivot pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Sawa to titaŋ roran ghom, yom ugham mulin di pa pataŋani todi. Yes tinumeer ghom, ve yom uul di. Tovenen tighur matadi payom sorok maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Eemoghon you, tamtoghon tighita ghou nanimale you tamtoghon maau. Matadi izi payou, ve tiveleg ghou tighaze you mbeb sorok nanimale motmoot to taan lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Tamtoghon tisob to tighita ghou, dabadi katia payou, ve tighaze: ‘Aa, ughita wa?” Ve tiŋiŋ payou, ve tipiyaav saveeŋ velegiiŋ naol payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Tisavsaav payou tighaze: “Yom ughaze unumeer Yoova? Poia. Ighaze venen, ghoro taneep ve taghita. Ighaze ye lolo payom kat, ye pale iuul ghom, ve igham mulin ghom pa pataŋani tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Eemoghon Yoova, yom to ughur ghou navot pooi ila tinaŋ apo. Ve sawa to naghunghun tuz, yom ugham payamyam payou pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Sawa to tinaŋ ipoop ghou, tighur ghou nalat nanim lem, leso uŋgin ghou. Tauto sawa tonowen ve inim, you nanumeer ghom naghaze yom Maaron tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Tovenen uneep saguan payou malep. Pasa aazne, pataŋani tiina ighaze ivot payou. Ve leg tamtoghon eta to iuul ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Ughita. Koiagŋa katindi tinim tiluvut ghou. Tapiridi tintina tinimale makau nditamoot to Basan to bide tapiridi. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Yes tinimale laion to tikakaak avodi ve livodi imasis iŋarua ghou. Ve lolodi ŋuria tighaze tisaas ghou ve tighan ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Tovenen tapirig isob kat, nanimale ya to ineep ila uur lolo ve tiliŋi ilale. Tuag tisob goloŋia. Tovenen nayamaan taug naghaze irau nagham mbeb eta maau. Ve matughezaaŋ tiina igham ghou, ve lolog imbumbu naghaze paam namaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Ŋgarsuag imamaas ve irau natoon ŋazubag maau. Yom upul ghou nagheen izala ghavuur, ve paam namaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Koiagŋa katindi tinim tiluvut ghou tinimale ŋgavuun ketooŋ, ve timorau agheg ve nimag. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ve tuag tisob timareer. Tovenen koiagŋa tiyoon ve timbatut ghou, ve lolodi poia kat. Pasa, nasami wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Yes tighaze pa namaat wa. Tauto tighaze tirei nonogiiŋa tiou toman mbeb tiou pida irau di. Tovenen tiŋgozŋgooz, leso tighita sei to pale igham sa mbeb. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yoova, uneep saguan payou malep. Ulaaŋa tiou, unum rikia ve uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Upoon ghou pa buza to mateeŋ. Upaghau ghou pa ŋgavuun samsamia tonene. Pa vene, tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Ugham mulin ghou ila laion tonene avo, ve upaghau ghou pa makau sagsagŋa tonene ndoŋadi. Aa, ghara naghita naghaze yom ulooŋ ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Tovenen you pale navotia mbeb to ugham payou ne pa nditag. Sawa to tamtoghon tiom tilup di pa suŋuuŋ, you pale nala toman di, ve napait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Yam to amatughez pa Yoova ve ataghon ŋgar toni, apaiti. Yam siŋ to Yakop, apait Yoova iza pa tapiri ve poia toni. Yam Israela asob, aroron ve amatughez pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Pasa, yes to timbadbaad pataŋani ve tighur matadi pa Yoova, ye irau ighita pataŋani todi inimale mbeb sorok ne maau. Pale iuul di. Irau iveleg di, ma ipul muri padi ne maau. Tovenen sawa to titaŋ rorani pa ledi ulaaŋ, ye pale ilooŋ taŋiiz todi ve iuul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Yoova, ighaze tamtoghon tiom tilup di pa suŋuuŋ tiina, you pale nalool ve napait izam ila matadi, ve napakur ghom pa ŋgar to ugham payou. You pale nataghon saveeŋ mbuaaŋ tiou, ve nagham watooŋrau payom ila yes to timatughez payom ve titaghon ŋgar tiom ne matadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Watooŋrau to nagham pa napait Yoova, yes mbolaaŋa pale tighan pida le apodi isuŋ. Ve yes to tizuaria di pa Yoova, pale tipaiti. Ye tau pale igham poian di, ve tineep pooi itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Tamtoghon irau taan dige to naol ne, pale matadi iŋgal Yoova, ve titoor ŋgar todi imuul ila pani. Ndug naol pale tisob tiput aghedi pani ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Pasa, Yoova, ye kinik tiina. Ye iŋgin tamtoghon tisob to taan, ve ighamgham pooz padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Tovenen mbaliiŋ taudi to taan pale tisob tiput aghedi pani ve tipaiti. Ve ila ila le yes to tigharau tighaze timaat ve tinim ghavuur ne paam, pale tiput aghedi pani ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Papaghu toit pale timbees pa Yoova. Yes to tivot muri, pale tilooŋ Yoova varu. ");
INSERT INTO tuc_o_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yes to tipoop di muri, tamtoghon pale tisavia ŋgar deŋia to Yoova padi, ve tipaes padi pa ataam to ye igham mulin tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yoova, ye ŋginiiŋ tiou poia. Irau nambool pa mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ye igheghereb ghou nala pa kikiliiŋ popoia to ineep ya naliu dige. Leso naghan, naghun ya luuma, ve ateg izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ye igham tapirig ivot muul, ve ipasaluŋgan ghou le nataghon ataam to deŋia ila mata. Leso ipaghazoŋan iza tiina ivot ighazooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yoova, ighaze nalaagh ila ndug sapsapi to mateeŋ, ve ndoroom tiina ikau ghou, nene irau namatughez maau. Pasa, yom uneep toman ghou. You naghita ghom ukis ndaab tiom toman titi to upasaluŋgan sipsip pani, tovenen ateg izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","You nanim loom payom, ve upakur ghou kat. Yom ugham ghanghaniiŋ tiina payou ila koiagŋa matadi. Ve uliŋ ŋgoreeŋ izala dabag, ve ugham poian ghou kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Onoon kat, sawa isob to naneep izi taan, yom lolom ineep tuŋia inim tiou, ve poia tiom izaza tiou itaghon saveeŋ mbuaaŋ tiom. Rumai tiom pale inim inag to nepooŋ le irau sawa tiou isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Taan toman mbeb tisob to tineep ila, nene to Yoova. Ndug tisob toman tamtoghon to tineep ila, nene toni moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Pasa, ye to ighur taan ipot izala te pogho. Ve ipariaaŋ taan pughu ineep tuŋia izila te lolo to sila kat we. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Sei irau izala lolooz to Yoova ve isuŋ pani? Ve sei irau ilooŋ ila rumai toni patabuaŋ, ve iyoon ila mata? ");
INSERT INTO tuc_o_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Tamtoghon tovene: Ye igham sosor eta maau. Ve ŋgar isob to ineep ila lolo, nene ŋgalaaŋa moghon. Ye ipait maaron kaaromŋa maau, ve iwaat Maaron iza sorok pa ipalot saveeŋ kaarom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Tamtoghon tovene, poia to Yoova pale iza toni. Maaron to Volaaŋa toni ne, pale igham mulini ve ineep pooi, ve ipatooŋa ighaze ye ŋgeu deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Ndiran tovene tizuaria di pa Maaron. Yes tighaze tila tivot to Maaron to Yakop nagho, ve tisuŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","O yam ataam, akaak ve tinimim iza. Yam ataam to muuŋ kat tigharaat gham, tinimim iza, ve akaak le akaak kat. Leso soso irau kinik to iza tiina pa tapiri ve poia toni, itaghoni ilooŋ ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Laak, kinik to iza tiina pa tapiri ve poia toni, nene sei? Nene Yoova. Ye ariaŋa, ve tapiri tiina. Ve ye iraua kat pa malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","O yam ataam, akaak ve tinimim iza. Yam ataam to muuŋ kat tigharaat gham, tinimim iza, ve akaak le akaak kat. Leso soso irau kinik to iza tiina pa tapiri ve poia toni, itaghoni ilooŋ ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Laak, kinik to iza tiina pa tapiri ve poia toni, nene sei? Nene Yoova. Ye Maaron ariaŋa, ve iŋgin mbeb tisob. Onoon kat, ye kinik to iza tiina pa tapiri ve poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","O Yoova, naghur taug nalat tiom, ve nasuŋ ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Maaron tiou, you nanumeer ghom. Upul koiagŋa titatan ghou malep. Pa vene, tipakur di tighaze tilib payou, ve tigham ghou mayag. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Tamtoghon tisob to tinaam pa ulaaŋ tiom, yes irau tighur matadi payom sorok ve mayadi ne maau. Eemoghon tamtoghon to tipul muridi payom, yes pale mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yoova, upatooŋ ataam tiom payou. Upaghazoŋan ŋgar tiou pani, leso nataghoni kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Ugham pooz payou, leso laghooŋ tiou deŋia itaghon saveeŋ tiom. Ve upaghazoŋan ghou pa ŋgar tiom. Pasa, yom Maaron tiou ve Volaaŋa tiou. Mboŋmaagh le ravrav izi, you naghurghur matag payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yoova, muuŋ ve inim, lolom isamin tamtoghon ve uluul di. Ve lolom ineep tuŋia ila to tamtoghon tiom, ve poia tiom izaza todi. Matam iŋgal ŋgar tiom tonanan. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Sosor ve ŋgar to didiaaŋ to you pain ghou ve naghamgham di, matam iŋgal di malep. Yoova, yom poiam, ve lolom ineep tuŋia ila to tamtoghon tiom ve uluul di itaghon saveeŋ mbuaaŋ tiom. Tovenen matam iŋgal ghou ve uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yoova ŋgar toni, nene poia ve deŋia moghon. Tovenen ndiran to tiyel pa ŋgar toni, ye ipasaluŋgan di pa ataam toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ve yes to titatan taudi ve tinumeer Maaron moghon, ye igheghereb di ve ipatooŋ ataam toni padi, leso titaghon ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Yes to matadi kisin saveeŋ mbuaaŋ todi toman Yoova, ve titaghon ataam to ye ighuri pa tamtoghon toni, ye lolo ineep tuŋia ila todi ve iuluul di itaghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O Yoova, you nagham sosor naol. Eemoghon izam tiina pa ŋgar tiom to lolom isasamin yei tamtoghon. Tovenen ureu sosor tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Tamtoghon tisob to timatughez pa Yoova ve tighaze titaghon ŋgar toni, ye pale ipatooŋ di pa ataam. Leso tiwatag sa ataam to yes irau titaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Ndiran tovene, nepooŋadi pale poia kat. Ve ndinatudi paam, pale tineep pooi izi taan to Yoova igham pa tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yes to timatughez pa Yoova ve titaghon ŋgar toni, tinim ndita kat. Tovenen ye ivovotia ŋgar toni yoŋgaaŋ padi, ve ipatooŋ di pa ataam to yesŋa tilup di tinim ee moghon itaghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Sawa isob, you naghurghur matag pa Yoova naghaze ye pale iuul ghou. Pale ipas agheg pa liis to koiagŋa tighuri payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Yoova, you mbesooŋa tiom. Tovenen matam imuul inim payou. Lolom isamin ghou, ve uul ghou pa pataŋani tiou. Pasa, you eŋgengou moghon. Leg itag ite pa iuul ghou pa pataŋani tiou tonene maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Lolog ipataŋan kat ve nagham ŋgar naol. Pasa, leg ataam eta maau. Upas ghou navot pa pataŋani tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Ughita pataŋani tiina to ivot payou ve itatan ghou ne, ve uul ghou. Ve ureu sosor tiou tisob tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ughita. Koiagŋa, yes ival. Ve atedi yabyab payou kat. Tighaze le tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Eemoghon you nanumeer ghom naghaze yom pale ugham mulin ghou ila koiagŋa nimadi, ve uŋgin ghou naneep pooi. You nayooŋ ilat tiom. Tovenen upul di tilib payou malep. Ighaze maau, pale mayag. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Yoova, ŋgar tiou iyaryaaŋ naghaze nataghon ŋgar popoia to deŋia moghon ila matam. Tovenen yom pale upoon ghou pa mbeb samsamia to naol ne. Pasa, you naghur matag pa ulaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Maaron, upas tamtoghon tiom Israel tivot pa pataŋani todi tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","O Yoova, you naghaze yom upaghazoŋan ghou ila tamtoghon matadi ughaze you ŋgeu deŋiag. Pasa, laghooŋ tiou, you nataghon ŋgar deŋia moghon. Ve naghur ilat tiom ariaŋa. Lolog ru payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yoova, uŋgabiiz ghou, ve utoov ghou. Utiir poian lolog ve ŋgar tiou, ve ughita: You naneep deŋiag ila matam, ma maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Moghon moghon, matag iŋgalŋgal ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Yom utaghon saveeŋ tiom irau sawa isob. Gabuam tonanan ipapalot ghou pa laghooŋ tiou, tauto nataghon ataam tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Yeiŋa ndiran kaaromŋa niluplup ghei maau. Yes to tiparim taudi pa ghurla todi, you nala toman di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","You naghur koi pa yes to tighamgham ŋgar samsamia, ve naneep saguan padi. Ighaze ndiran samsamia tilup di, irau naneep toman di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O Yoova, you nataghon ŋgar deŋia moghon. Tauto namen nimag inim ghilalooŋ payou ighaze leg sosor eta maau. Ve nalaagh luvutin artaal to tighamgham watooŋrau payom izala, ve nasuŋ payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","You pale nambou mbouŋ toman lolog poia ve napait ghom, ve navotia uraat tiom gharatooŋadi to ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yoova, you lolog pa rumai tiom kat. Pasa, nene inam to nepooŋ. Yom upatooŋ tapirim ve ŋgurubam toman poia tiom ivotvot tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Yes to tiyel pa ataam tiom, upasob ghou toman di malep. Ve yes to tirabrab tamtoghon le naghodi siŋ, urab ghou namaat toman di malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Ndiran tovene, nimadi igharghaar pa ghamuuŋ ŋgar samsamia naol. Ve ighaze tighol di pa tigham ŋgar samia eta, nene tiyok moghon ve tighami. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Eemoghon laghooŋ tiou, you nataghon ŋgar deŋia moghon. O Yoova, you mbesooŋa tiom. Lolom isamin ghou ve ugham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","You nayoon tuŋia ila taan raapa. Irau natap maau. Tovenen sawa to tamtoghon tiom tilup di pa suŋuuŋ, you pale nala toman di, ve napait ghom pa poia tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Yoova inim ghazooŋa payou, ve ye Volaaŋa tiou. Pale namatughez pa sei? Maau. Pasa, you nanumeer Yoova. Ye inim ruum ariaŋa pa nayooŋ ila lolo. Tauto namatughez pa mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Ighaze ndiran samsamia tipamundigin malmal payou, ve koiagŋa tighaze tiwaghamun ghou, nene pale Yoova igham aghedi ilot, ve titap. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ighaze ndaaba katindi tinim tiluvut ghou pa tigham malmal, irau lolog imbumbu ve namatughez padi maau. Ighaze malmal imundig, ve koiagŋa tiŋarua ghou tinim, you pale nanumeer Maaron ve nayoon ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Mbeb ee moghon to you lolog pani kat. Tauto naghaze naghason Yoova pani. Sawa isob to naneep izi taan, you naghaze le naneep toman Yoova ila rumai toni lolo, ve naghita poia toni. You naghaze naneep ila rumai toni lolo, leso naghasoni pa ipatooŋ tau ve ŋgar toni payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ighaze pataŋani tiina eta ivot payou, ye pale iŋgin ghou naneep pooi ila nima samba. Pale iŋgooz ghou ila rumai toni lolo. Ve ye pale isur ghou nazala raŋ to sala we, leso koiagŋa tigham mbeb eta payou sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Onoon, aazne, koiagŋa tinim tiluvut ghou. Eemoghon namatughez maau. Pasa, Yoova pale iuul ghou ve nalib padi. Tovenen tinig iza, ve nalool ve napait iza. Nagham watooŋrau pani ila rumai toni lolo, ve nambou ve narab gita pa napait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yoova, ighaze nataŋ roran ghom pa ulaaŋ, ulooŋ taŋiiz tiou. Lolom isamin ghou ve uul ghou. Pasa, you mbesooŋa tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Yom usaav payou ughaze: “Unum usuŋ payou, leso napatooŋ taug payom.” Tauto lolog naghaze nalat tiom, ve upatooŋ taum payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","You mbesooŋa tiom. Uŋgooz matam payou malep. Atem yabyab ve uzurun ghou malep. Maaron, muuŋ ve inim, yom moghon to Volaaŋa tiou. Tovenen upul ghou, ve upul murim payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ighaze tamaŋ ve tinaŋ tipul muridi payou, nene pale Yoova tau igham ghou ve iŋgin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yoova, upaghazoŋan ghou pa ataam tiom. Umuuŋ payou ve upatooŋ ghou pa ataam deŋia. Pasa, koiagŋa katindi tisasaŋan ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Upul ghou nala nimadi malep! Pasa, yes tiŋgal saveeŋ kaarom naol payou, ve tighamgham saveeŋ matughezaaŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Eemoghon you naghur ila naghaze yes irau tiwaghamun ghou maau. You pale naneep matag iyaryaar, ve naghita poia to Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Tovenen yom to ughur ila to Yoova, you nasaav payom naghaze: “Unumeer Yoova, ve ughur matam pani. Umatughez malep. Lolom ee moghon, uyoon ariaŋa, ve usaŋan pa ulaaŋ toni.” ");
INSERT INTO tuc_o_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Yoova, yom uponpoon ghou pa koiagŋa unumale yaam tiina. Tovenen taŋiiz tiou ilat payom. Ughur taliŋam pa suŋuuŋ tiou tonene ve uul ghou lak! Ighaze ulooŋ ghou maau, ve neneeŋam moghon, nene pale nanim yes to timaat ve tizila saambu to yes mateeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Aazne, you nakaak nimag iza iŋarua rumai tiom lolo to patabuaŋ kat, ve nataŋ roran ghom pa ulaaŋ. Ulooŋ taŋiiz tiou tonene, ve lolom isamin ghou. Pasa, you mbesooŋa tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Sawa to yom ughur atia pa ndiran samsamia, uweu ghou nala toman di malep. Yes to tinoknok ghamuuŋ sosor, nalaleg toman di malep. Ndiran tonowen tisasavia saveeŋ poia pa nditadi tighaze lolodi padi. Eemoghon ŋgar to ineep ila lolodi, nene ite. Tighaze tiwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Yes tikaria ghamuuŋ sosor wa. Tovenen ughur atia padi, ve uŋgal matadi. Leso uyat ŋgar todi samia tonowen. Ugham tovene, ghoro deŋia. Pasa, ŋgar to tighamghami, poia maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Uraat tintina to Yoova nima ighamgham di, yes tigham ŋgar pani maau. Tovenen ye pale ireu mbirisan di ve tilaledi kat, tinimale ruum to tireu mbirisani, ve irau tireii muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","You napait Yoova pa poia toni. Pasa, you nataŋ rorani pa iuul ghou, ve ilooŋ taŋiiz tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","You naghamgham tapirig ila to Yoova, ve ye inim sigeu payou. You naghur ila toni ariaŋa ila lolog, ve iuluul ghou. Tovenen lolog poia le poia kat, ve napait iza pa poia toni ila mbouŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yoova tamtoghon toni tighamgham tapiridi ila toni. Ve kinik to Yoova tau ighuri pa uraat toni, ye iuluuli ve iponpoona pa koia inimale didiiŋ ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Yoova, yom usia tamtoghon tiom tinim lem kat. Ugham mulin di pa pataŋani todi, ve ughur poia tiom iza todi. Matam pa sipsip tiom, ve uŋgin poian di. To aazne, ve itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Yam aŋela ariaŋamim to sambam, apakur Yoova. Apait iza pa tapiri ve poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Apait Yoova! Pasa, ye iza tiina kat. Ye ipambood tau pa ŋgar toni patabuaŋ. Tovenen aput aghemim pani ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yoova aliŋa ila irau te dige to naol ne. Maaron to iza tiina ne aliŋa, nene inimale lalaav avolutu. Yoova isaav toman aliŋa tiina izala te pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yoova aliŋa tapiri tiina. Aliŋa ipatooŋa ighaze ye iza tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yoova aliŋa iŋgalŋgal balagin ai mendepur tintina to Lebanon. Aliŋa iŋgalŋgal mbirisan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yoova aliŋa itok lolooz tintina to Lebanon, le tiyatovtov di tinimale makau ndinatu papaghu to tinidi iza. Ve itok lolooz Ermon, le iyatovtova inimale bapolo sagsagŋa ndinatudi to tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yoova aliŋa igham ndug milia, ve yab ighan. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Ve itok taan to ndug balim le irur. Igham ndug balim to Kades katkatia ilala inimnim. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yoova aliŋa igham mekmek sagsagŋa to apodi ne, ruŋadi iza le tipoop pataghaaŋ. Ve igham ai raua tisob kurukia tizi. Tovenen tamtoghon tisob to tilup di pa suŋuuŋ ila rumai toni lolo, tisaav toman aliŋadi tiina tighaze: “Tapait Yoova iza. Pasa, ye tapiri tiina kat!” ");
INSERT INTO tuc_o_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Muuŋ, yawaaŋa ivot toman tapiri ve itatab taan. Sawa tonenen, Yoova ineep ila ina to ghamuuŋ pooz ve iŋgini. Aazne paam, ye kinik to ineep ila ina to ghamuuŋ pooz. Pooz toni pale inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yoova ighamgham tapiri pa tamtoghon toni. Pale ighur poia toni izaza todi, ve iŋgin di tineep pooi toman lolodi luuma. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","O Yoova, you napait izam. Pasa, sawa to naneep ila pataŋani tiina lolo, yom ugham mulin ghou, ve undae ghou naza muul. Inimale yom upul ghou namaat, tone koiagŋa lolodi poia, ve tipakur di tighaze tilib payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Yoova, Maaron tiou, you nataŋ roran ghom pa ulaaŋ. Ve yom upasob moroghooŋ tiou, ve tinig poia wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Rismoghon tone namaat ve nazila ndug to mateeŋa. Eemoghon yom uul ghou, tauto namundig muul, ve aazne naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yam tamtoghon to Yoova to lolomim ineep tuŋia ila toni ve ataghon ataam toni, apaiti ila mbouŋ tiam. Yoova, ye patabuaŋ. Tapiri ve ŋgar toni, nene ite kat. Tovenen lolomim poia pani, ve apait iza pa poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Mbalmbali toni ineep mala maau. Ineep ris, ve isob. Eemoghon poia toni, nene izaza toit irau sawa to taneep izi taan. Ighaze tataŋ pa mboŋ, mboŋmaagh, ye pale igham ghiit lolood poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Sawa to nepooŋ tiou poia moghon, you nasaav naghaze: “Pataŋani eta irau ivot payou ve itok ghou ne maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Pasa, yom ughamgham poian ghou ve upapalot ghou. Tauto napait taug naghaze you pale naneep tuŋia tovene irau sawa isob, nanimale lolooz tintina. Eemoghon sawa to uŋgooz matam payou, matughezaaŋ tiina igham ghou le nasaŋeeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Sawa tonenen, napoi ghom ve nataŋ roran ghom naghaze lolom isamin ghou ve uul ghou. You nasaav payom naghaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“O Yoova, ighaze namaat ve nazila ndug to mateeŋa, nene pale mateeŋ tiou iuul sei? Ughita. Mateeŋa to tizila taan lolo ve tinim ghavuur, todi eta irau ipait ghom? Ma todi eta irau ivotia ŋgar tiom to utataghon saveeŋ mbuaaŋ tiom? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Tovenen Yoova, ulooŋ suŋuuŋ tiou tonene. Lolom isamin ghou ve uul ghou lak! Pasa, you mbesooŋa tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Aa ghara upasob taŋiiz tiou! Tovenen you pale tinig iza ve nator. Yom upasob pataŋani tiou, ve ududuum uli to moŋiiŋ izi pa tinig. Yom ugham ghou lolog poia kat, ve naneep ila poia tiom lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Tovenen irau neneeŋag maau. You pale nambou ve napait izam toman lolog. Yoova, yom Maaron tiou. You pale napait ghom pa poia tiom to aazne, ve itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","O Yoova, you nanumeer ghom ve nayooŋ ilat tiom. Upul koiagŋa titatan ghou malep. Pa vene, tigham ghou mayag. Ŋgar tiom deŋia. Tovenen ugham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ughur taliŋam pa suŋuuŋ tiou, ve rikia uul ghou! Yom Volaaŋa tiou ariaŋa. Yom uponpoon ghou unumale raŋ to izala kat. Ve unum ruum ariaŋa pa nayooŋ ila lolo. Leso mbeb eta iwaghamun ghou sob, ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Onoon kat. Yom Volaaŋa tiou ariaŋa. Yom uponpoon ghou unumale raŋ to izala kat. Ve unum ruum ariaŋa pa nayooŋ ila lolo. Umuuŋ payou ve upatooŋ ataam payou, leso upaghazoŋan izam tiina ivot ighazooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ughita liis to koiagŋa tighuri payou, ve upaghau ghou pani. Pasa, yom to unum inag to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Yoova, yom Maaron to utataghon saveeŋ mbuaaŋ tiom. Aazne, you naghur taug ilat nimam. Ugham mulin ghou pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","You nanumeer Yoova moghon. Tovenen yes to tighurghur mbeb soroksorok tinim maaron padi ve timbesmbees padi, you naghur koi padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","You tinig iza ve lolog poia payom. Pasa, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Sawa to lolog ipataŋan kat, ve ateg imbumbu, yom ughita pataŋani tiou ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Yom upul ghou nala koiagŋa nimadi maau. Yom upas ghou navot pa pataŋani tiou, ve ughur ghou naneep pooi ila ndug ghazooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yoova, you mbesooŋa tiom. Lolom isamin ghou ve uul ghou lak! Pasa aazne, pataŋani tiina igham ghou le lolog ipataŋan. You nataŋ tiina le matag isarsar, ve tapirig isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Lolog ipataŋan kat ve nayakyak irau sawa isob. Pataŋani tonene pale iŋgoor sawa tiou inim tuku. Igham ghou nayamaan taug naghaze tapirig isob. You nakoŋkoŋ kat le tuag tisob timareer. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Koiagŋa tisob tigham ŋalalaŋ payou. Ve yes to tineep tigharau ghou ne paam, tipamogheran di payou. Nditag lolodi pa tinim tigharau ghou maau. Ve yes to tighita ghou izi ataam, timatughez ve tilaagh pa ataam dige ite. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Tamtoghon matadi iŋgal ghou muul maau. Tighita ghou nanimale namaat wa. You nanimale uur to ivavaal, ve tipiyaava ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","You nalooŋ ival tiina tikakamuun payou. Koiagŋa tilup di, ve tikaal ataam pa tirab ghou namaat. Tovenen pataŋani naol tiluvut ghou, le matughezaaŋ tiina igham ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Eemoghon Yoova, you nanumeer ghom. Tauto nasaav payom naghaze: “Yom moghon to Maaron tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Sawa to naneep izi taan, sa mbeb ma ŋgar to ighaze ivot payou, you naneep ila nimam. Upas ghou ila koiagŋa nimadi, ve upoon ghou pa yes to tighamgham lilin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","You mbesooŋa tiom. Lolom poia payou, ve ugham poian ghou. Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen ugham mulin ghou pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yoova, you nataŋ roran ghom pa ulaaŋ. Upul koiagŋa titatan ghou malep. Pa vene, tigham ghou mayag. Utatan ndiran samsamia tonowen tapiridi, leso mayadi. Ve upiyaav di tizila ndug to mateeŋa, leso neneeŋadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Upoon avodi. Pasa, yes ndiran to kaarom. Tipapait taudi, ve tiveveleg tamtoghon deŋiadi, ve tipiyaav saveeŋ samsamia naol padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","O Yoova, poia tiom, nene tiina le tiina kat. Yes to timatughez payom, ve titaghon ataam tiom, yom ughur ledi mbeb popoia naol tisasaŋan di. Yes to tinumeer ghom, ve tiyoŋyooŋ ilat tiom, yom pale ugham poian di ila ival tiina matadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Yom uŋgooz di tila digem. Tovenen koiadi to tikalkaal ataam pa tirab di timaat, irau tigham mbeb eta padi maau. Yom uŋgin di tineep pooi ila nimam samba. Tovenen saveeŋ samsamia to koiadi tipipiyaava padi, irau iwaghamun di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","You napait Yoova pa poia toni. Pasa, lolo ineep tuŋia inim tiou, ve igham ŋgar poia kat payou. Sawa to koiagŋa tiluvut ghou pa tigham malmal payou, ye iuul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Papazogi, you namatughez naghaze Yoova indiir ghou naghau pa mata wa. Eemoghon maau. You nataŋ rorani pa iuul ghou, ve ilooŋ taŋiiz tiou, ve igham mulin ghou pa pataŋani tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Yam tamtoghon to Yoova to lolomim ineep tuŋia ila toni ve ataghon ataam toni, aghur lolomim pani kat. Yes to titaghon aliŋa, ye pale iŋgin di tineep pooi. Eemoghon yes to tipapait taudi ve tivelegi, ye pale ighur atia padi, ve iyat katin ŋgar todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Tovenen yam to anumeer Yoova ve aghurghur matamim pani, amatughez malep. Apariaaŋ taumim, ve ayoon ariaŋa! ");
INSERT INTO tuc_o_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Tamtoghon to ighaze izoor Maaron aliŋa ve iyel pa ataam toni, ighaze Maaron ireu sosor toni ilale, ye pale tini iza pa poia to Maaron to iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Onoon kat, tamtoghon to ighaze ŋgar to kaarom eta ineep ila lolo maau, ve Yoova ighita ighaze ye le sosor eta maau, ye pale tini iza pa poia to Maaron to iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Sawa to naŋgooz sosor tiou, tuag tisob tiyabyab le tapirig isob. Ve nayakyak irau mboŋ ve ndag. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","O Yoova, onoon kat, sawa tonenen, nayamaan katin nimam irau mboŋ ve ndag. Tauto igham tapirig isob kat nanimale ya to ndag ighaaz le imaak. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Naneep le maau, ghoro navotia sosor tiou payom. Ŋgar tiou samia, naŋgooza muul maau. Sawa tonenen, you naghaze: “Ŋgar tiou to zoraaŋ Yoova aliŋa, you pale navotia ila toni.” Tovenen navotia sosor tiou payom, ve ureua ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Tovenen tamtoghon tisob to lolodi ineep tuŋia ilat tiom, ve titaghon ataam tiom, ighaze pataŋani eta igham di, yes irau tisuŋ payom. Ighaze pataŋani tiina kat ivot padi inimale yawaaŋa to ivot toman tapiri, yom pale uul di, leso pataŋani itatan di sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Maaron, yom unum inag to yoŋgaaŋ. Yom upoon ghou pa pataŋani, ve ugham mulin ghou. Tauto ival tiina to tiluvut ghou ne, timbou ve tipait izam toman aliŋadi tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Ve Yoova isaav payou ighaze: “You pale napaghazoŋan ŋgar tiom, ve napatooŋ ghom pa ataam to naghaze utaghoni. You pale matag payom, ve nauul ghom pa ŋgar poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Tovenen ugham ŋgar pooi. Dabam ariaŋa inimale hos ma esele malep. Yes ledi ŋgar maau. Tauto tamtoghon tighurghur ain suruvu toman waar ila avodi, leso tipasaluŋgan di pa laghooŋ, ve titaghon ŋgar todi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ndiran samsamia, pataŋani naol pale igham di. Ve yes to tinumeer Yoova, ye pale lolo ineep tuŋia ila todi, ve tineep ila poia toni lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Yam ndiran to ataghon ŋgar deŋia, lolomim poia, ve tinimim iza pa poia to Yoova. Yam to ŋgar poia ineep ariaŋa ila lolomim, asob lolomim poia pa Yoova ve alool ve apaiti! ");
INSERT INTO tuc_o_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Yam to ataghon ŋgar deŋia, lolomim poia pa Yoova, ve alool ve apaiti. Yam to aghamgham ŋgar poia, apait Yoova iza, ghoro deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Apambar ambam, ve arab gita, ve apakur Yoova. Arab mbeb naol, ve apaiti ila mbouŋ to popoia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Ambou mbouŋ paghu pani, ve arab poian gita. Leso mbouŋ tiam paghuna. Ambou tiina, ve apaiti toman lolomim poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Pasa saveeŋ to Yoova, nene onoon ve deŋia moghon. Uraat naol to ighamgham di, nene ipatooŋa ighaze ye itataghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Ye lolo pa ŋgar deŋia ve ŋgar to gharatooŋ pataŋani to tamtoghon le deŋia. Ve lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. Ŋgar tonene, ye ipatooŋa irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Muuŋ, saveeŋ to Yoova moghon, tauto mbeb to sambam paroŋania tisob tivot. Avo isaav, ve ndag, kaiyo, ve pitum tisob tivot ila sambam paroŋania. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ye igham te ila ilupi ila dige ee moghon. Mazovan to muuŋ kat itatab taan, ye ighur poiani ila ina. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Yam to aneep irau taan, amatughez pa Yoova ve ataghon ŋgar toni. Yam ndug ndug, aroron pani, ve apakuri. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Pasa, ye isaav moghon, ve sambam ve taan tivot titaghon tau aliŋa. Ye isaav ariaŋa, ve mbeb tisob tivot ve tineep tuŋia ila inadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Ndug ndug matadi iŋgal ŋgar naol tighaze tigham di. Eemoghon Yoova iponpoon ataam padi. Tauto ŋgar todi tonowen inim mbeb sorok, ve le anoŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Eemoghon Yoova, ighaze mata iŋgal ŋgar eta, nene pale ŋgar tonenen ineep tovene irau sawa isob. Sa ŋgar to ighaze lolo ighur pani, nene pale inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Yes Israela Maaron todi, nene Yoova. Tauto tinidi iza pa poia toni to izaza todi. Ye tau isia di, ve igham di tinim le kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yoova ineep izi sambam, ve mata izizi pa ival tiina to taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ye ineep ila ina to ghamuuŋ pooz, ve ighita tamtoghon tisob to tineep izi taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ye to ighurghur ŋgar ila tamtoghon eŋaeŋa lolodi. Ve ŋgar naol to tamtoghon tighamgham di, ye iwatag di tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ighaze kinik eta le ndaaba katindi, irau ndaaba tonenen eŋgendi tilib pa malmal maau. Ndaaba ariaŋadi paam. Irau taudi tapiridi, ve tilib pa koiadi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Ve hos to ndaaba tilaan padi pa malmal, tovene paam. Ighaze tighur matadi padi pa tiuul di ve tilib pa koiadi, nene pale tighur matadi padi sorok. Onoon, hos tapiridi. Eemoghon irau tiuul di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Onoon kat, yes to timatughez pa Yoova ve titaghon ŋgar toni, ye mata padi. Yes to tinumeer Yoova tighaze ye lolo ineep tuŋia ila to tamtoghon toni ve iuluul di, ye iŋgin di tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Ye iuluul di, ve igham mulin di pa pataŋani todi. Leso tineep pooi. Ve ighaze pitool tiina ivot, ye pale iuul di, ve igham adi aniiŋ ve tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Tovenen iit tanumeer Yoova, ve taghur mataad pani. Pasa, ye Ulaaŋa toit, ve inim sigeu pait. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Ye moghon, tauto lolood poia kat, ve tiniid iza. Ye patabuaŋ ve iza tiina. Tauto taghur ila toni ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yoova, yei nighur matamai payom pa uul ghei. Ughur poia tiom iza tiei itaghon ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","You pale napait Yoova pa poia toni irau sawa isob. Irau neneeŋag maau. Moghon moghon avog pale ipapaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","You lolog poia pa Yoova, ve napaiti pa ŋgar popoia to ye igham payou. Yes to tinumeer Yoova, ve timbadbaad pataŋani, irau tilooŋ aliŋag tonene. Leso lolodi poia paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Yam anim itiŋa talup ghiit, ve tapakur Yoova. Itiŋa tapait iza. Pasa, ye iza tiina le tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Suŋuuŋ tiou iŋarua Yoova, ve ye ilooŋ ghou. Tauto igham mulin ghou pa mbeb tisob to namatughez padi ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Yes to tighur matadi pani pa iuul di, nene pale lolodi poia, ve tinidi iza. Ye pale iuul di. Irau tighur matadi pani sorok ve mayadi ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Muuŋ, pataŋani tiina igham ghou. Tovenen nataŋ roran Yoova pa ulaaŋ. Ve ye ilooŋ suŋuuŋ tiou, ve igham mulin ghou pa pataŋani tiou tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yes to timatughez pa Yoova ve titaghon ŋgar toni, aŋela toni inepneep toman di, ve iŋginŋgin di. Ye ighamgham mulin di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yoova, ye poia kat. Taumim atoova ve aghita. Yes to tinumeera ve tiyoŋyooŋ ila toni, poia toni izaza todi le lolodi poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Yam tamtoghon patabuaŋa to Yoova, amatughez pani ve ataghon ŋgar toni. Pasa, yes to tighamgham tovene, irau timbool pa mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion papaghu, tapiridi tintina. Eemoghon sawa pida, adi aniiŋ maau ve pitool di. Ve yes to tizuaria di pa Yoova, nene irau timbool pa mbeb poia eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ndinatug, anim alooŋ saveeŋ tiou tonene. You naghaze napatooŋ gham pa ataam to amatughez pa Yoova ve ataghon ŋgar toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Vena, yom ughaze uneep pooi, ve uneep mala izi taan toman lolom poia? ");
INSERT INTO tuc_o_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ighaze tovene, ghoro uŋgin poian avom. Saveeŋ samia, ma kaarom eta ivot ila avom malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ve upul murim pa ŋgar samia, ve ugham ŋgar poia moghon. Uzuaria ghom pa taghoniiŋ ŋgar luuma, ve ukaal ataam pa yamŋa tamtoghon alup gham ve aneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Tamtoghon deŋiadi, Yoova mata padi, ve ighurghur taliŋa pa taŋiiz todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Eemoghon ndiran samsamia, ye ighurghur koi padi. Pale ipasob di pa taan le tisob kat. Muri pale tamtoghon matadi iŋgal di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Sawa to tamtoghon deŋiadi titaŋ roran Yoova pa ulaaŋ, ye iloŋlooŋ di, ve ighamgham mulin di pa pataŋani todi tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yes to pataŋani igham di le lolodi isami kat, Yoova ineep igharau di. Tamtoghon to ighaze pataŋani itatani le tapiri isob, nene pale Yoova iuuli. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Onoon, tamtoghon deŋiadi, pataŋani naol ivotvot padi. Eemoghon Yoova pale igham mulin di pa pataŋani todi to naol. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Pale iŋgin poian di kat. Irau tuadi eta ipol maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Eemoghon yes to tizorzoor Yoova aliŋa, ŋgar todi samsamia pale imuul pa taudi, ve irab di timaat. Yes to tighurghur koi pa tamtoghon deŋiadi, nene pale Yoova ighur atia padi, leso iyat ŋgar todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yoova ighamgham mulin mbesooŋa toni pa pataŋani todi, leso tineep pooi. Yes to tinumeera ve tiyoŋyooŋ ila toni, ye irau ighur atia padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","O Yoova, uul ghou ve utatan koiagŋa to aazne yeiŋa niwazoran ghei ve tiŋoŋooŋ payou ne. Yes to tighaze tigham malmal payou, uvool tiou ve uparab toman di. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Undud ghom pa mburuguuŋ tiom to malmal, ve ukis sigeu tiom, ve umundig unum uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Upas iiz ve ndaab tiom, ve upoon ghou pa yes to tigham lilin ghou. You naghaze nalooŋ ghom usaav payou ughaze: “You Volaaŋa tiom. You pale nauul ghom.” ");
INSERT INTO tuc_o_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Yoova, yes to tighaze tirab ghou namaat, utatan tapiridi, ve ugham di mayadi ve tighau tila. Yes to tikaal ataam pa tiwaghamun ghou, ugham ŋgar todi iwaghamgham, ve timuul tila toman mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yoova, naghaze aŋela tiom inaan di ve tighau tila, inimale yaghur iviviir ghavuur. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Aŋela tiom igham taghon di, ve tilaan ila ndoroom lolo taghon ataam to kirikirikia, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Pasa, you nagham sosor eta padi maau. Eemoghon yes tiraar malum tighaze tisavag ghou. Ve titai saambu to izila kat, leso natap nazila. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Yoova, ukarmotin di pa pataŋani tiina eta. Ugham di tiŋgud malum to tiraara payou ne. Ve ugham di titaptap tizila saambu to titaii payou. Leso tigham samia! ");
INSERT INTO tuc_o_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Yoova, ighaze ugham tovene, nene pale lolog poia kat payom, ve tinig iza pa ulaaŋ to ugham payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","You pale napakur izam toman lolog, ve naghaze: “Yoova, sei to inimale yom? Eta maau! Pasa, yes to tapiridi maau, yom ugham mulin di ila yes to tapiridi tintina ne nimadi. Yes mbolaaŋa ve yes to tineep ila pataŋani lolo, yom pale uvool todi, ve ugham mulin di ila yes yubyubŋa nimadi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Tamtoghon naol timundig ve tiŋgal saveeŋ kaarom payou tighaze tiwaghamun ghou. Eemoghon saveeŋ ŋgaliiŋ to tinoknok ghasoniiŋ ghou pani, you nakankaan pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","You nagham ŋgar poia padi. Eemoghon yes tipamuul ŋgar samia payou. Tauto lolog ipataŋan kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Eemoghon sawa to yes timorooŋ le tisami, lolog ipataŋan padi, ve nagharaat taug maau. Ve naŋgun taug pa ghaniiŋ aniiŋ, ve naghur di tila suŋuuŋ tiou. Eemoghon suŋuuŋ tiou tonene, yom ugham anoŋa ivot maau. Tauto lolog ipataŋan kat, ve nataŋ padi inimale nditag, ma toŋvetaz tiou kat. Ve nalaagh matag iza maau. Natudtud ve nataŋtaŋ nanimale ŋgeu to lolo ipataŋan pa tiina imaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Eemoghon sawa to pataŋani igham ghou ve naneep sami, yes lolodi poia, ve tilup di pa tiwaghamun ghou. Yes to tighaze tigham malmal payou ne, you nawatag di maau. Nakankaan pa ŋgar todi. Yes tinoknok ŋgaliiŋ saveeŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ve tipiyaav saveeŋ velegiiŋ naol payou. Atedi yabyab payou kat, ve tiŋaaŋ mareer tighaze le tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Yoova, pughu vena to umbabatut di, ve tighamgham ŋgar tovene payou? Pale ŋeez o uul ghou? Yes tinimale laion to tisasaŋan pa tisaas ghou. Tovenen ugham mulin ghou ila nimadi, leso naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ighaze uul ghou, sawa to tamtoghon tiom tilup di pa suŋuuŋ, you pale nala toman di, ve napait ghom toman lolog poia. Pale napait varum ila ival tiina tonowen naghodi. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Koiagŋa, muuŋ yeiŋa lupuuŋ tiei ee moghon. Eemoghon aazne, tighur koi payou sorok. Tovenen uul ghou lak! Pa vene, tilib payou ve tipakur di. Yes tighan matadi payou, ve tighaze: “Aa, ŋgeu to iwaghamgham wa!” O Yoova, ŋgar tovene ivot malep! ");
INSERT INTO tuc_o_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Yes tisavia saveeŋ luuma eta pa tilup tamtoghon ve tineep pooi ne maau. Tiŋgalŋgal saveeŋ naol pa tamtoghon to orodi maate to tineep izi taan tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ve aliŋadi izaza sorok, ve tisavsaav ila matag tighaze: “Aa, ghara nighita ghom!” ");
INSERT INTO tuc_o_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yoova, ŋgar todi samsamia to naol ne, yom ughita di wa. Neneeŋam padi malep! Tiina tiou, uneep saguan payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Maaron, yom Tiina tiou. Umundig ve uvool tiou. Uyoon payou, ve utatan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yoova, Maaron tiou, ŋgar tiom deŋia moghon. Tovenen uyoon payou, ve upaghazoŋan ghou ila tamtoghon matadi ughaze you leg sosor eta maau. Uul ghou. Pa vene, koiagŋa tipakur di pa pataŋani to igham ghou ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Ghoro lolodi poia, ve tisaav tighaze: “Aa, isob! Ŋgar to taghaze tagham pani, tauto ivot pani ve isami wa!” ");
INSERT INTO tuc_o_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Yoova, yes to tipakur di pa pataŋani to igham ghou ne, ugham di tiwaghamgham, ve tighau tila toman mayadi. Yes to tipapait taudi ve tiveleg ghou, upamayaŋin di le mayadi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Eemoghon yes to tighaze yom uul ghou ve upaghazoŋan ghou ila tamtoghon matadi ughaze you leg sosor eta maau, yes pale lolodi poia ve tinidi iza, ve tilool ve tipait izam. Ve tisavsaav tighaze: “Yoova iza tiina kat! Ighaze mbesooŋa toni ineep pooi, pale ye paam lolo poia.” ");
INSERT INTO tuc_o_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Tovenen mboŋmaagh ila le rabrab izi, avog pale ivotia ŋgar deŋia to yom ughamghami, ve napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Ŋgar to zoraaŋ Maaron aliŋa to ineep ila ndiran samsamia lolodi, nene isavsaav padi, ve ighamgham pooz padi. Tauto matadi iŋgal Maaron maau, ve timatughez pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Sosor todi tonowen, ighamun ŋgar todi. Tauto tipapakur taudi, ve matadi iŋgal sorok tighaze Maaron ighita sosor todi maau, ve irau ighur atia padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Saveeŋ kaarom ve saveeŋ samsamia moghon to ivotvot ila avodi. Ŋgar to iuul ghiit pa taneep pooi, nene tipuli wa. Tauto tigham ŋgar poia eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ŋgar todi iyaryaaŋ kat. Tighaze le tigham ŋgar samia moghon. Mboŋ to naol ne, tighengheen ila moogh todi, ve matadi iŋgalŋgal pa sa ŋgar samia to pale tighami. Ataam samia tonowen, lolodi pa tipuli maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yoova, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ŋgar tiom tonanan, nene tiina le tiina kat. Izala le ikis sambam. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tiom paam. Izala le ikis tata. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Ŋgar tiom deŋia, nene inimale lolooz tintina. Ve ŋgar tiom to uŋgabiiz tamtoghon itaghon ŋgar deŋia ve ughur atia padi, nene paam, tiina kat inimale mazovan bibiliiŋa to izila le izila kat. Yoova, yom uŋgin tamtoghon ve mbeb naol naol to su ve paanu, ve uluul di, tauto tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Maaron, gabuam to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, nene mbeb tau. Tamtoghon tisob tiyooŋ ila nimam samba, inimale tatareek ndinatu tiyooŋ ila tinandi bage samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Rumai tiom, nene ivon pa mbeb popoia naol. Tovenen tamtoghon tighan le isooŋ di. Poia tiom izaza todi inimale ya tiina to irereer. Yom upaghun di pani, ve tiyamaana poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Yom to unum pughu pa mbeb tisob to tineep matadi iyaryaar. Ve ghazooŋa tiom isul ghei, tauto matamai ighazooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Yoova, lolom ineep tuŋia ila to yes to tiwatag ghom. Yes to ŋgar deŋia ineep tuŋia ila lolodi, upatooŋ poia tiom padi, ve uul di itaghon ŋgar tiom deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Tovenen yes to tipapait taudi izadi ve tiveleg tamtoghon tiom, upul di titatan ghou malep. Ve upul ndiran samsamia tinaan ghou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Aghita. Yes to tinoknok ghamuuŋ ŋgar samia, tauto Maaron irab di titaptap tizizi, le patudi tiwaghengheen izala taan pogho. Irau timundig muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ndiran samsamia to aazne tipapakur taudi, ugham ŋgar naol padi malep. Ve yes to tighamgham sosor, lolom igham pa mbeb todi malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Pale tineep ris, ve tisami tinimale kikiliiŋ to ndag ighaaza ve imalai. Pale tinimale mbeb raua to timalai ve titaptap tizi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Unumeer Yoova, ve ugham ŋgar poia moghon. Leso mbeb eta iwaghamun ghom sob, ve uneep pooi izi taan to ye igham pa tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Tinim iza pa Yoova tau. Leso igham mbeb ivot payom itaghon yom lolom. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Sa ŋgar to yom ughaze ughami, unumeer Yoova, ve ughur taum ila nima. Ye pale iuul ghom, ve ipatooŋ ghom pa ataam to utaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Pale igham ŋgar tiom deŋia ineep ghazooŋa kat ila tamtoghon matadi, inimale ndag ŋguruba. Tovenen tamtoghon pale tighilaal ghom tighaze lem sosor eta maau, ve ŋgar tiom poia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ighaze uraat to ndiran samsamia ilaan poia, ve tiyou ledi mbeb naol ila ataam samia, ugham ŋgar naol padi malep. Atem izi, ve usaŋan Yoova. Ye tau pale ighur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Tovenen atem yabyab ve ugham ŋgar naol malep. Uyai ghom ve utatan atem. Pa vene, atem yabyab, ve ugham sosor. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Pasa, Yoova pale ipasob ndiran samsamia ve tilaledi. Eemoghon tamtoghon to tinumeer Yoova ve tighur matadi pani, yes pale tineep pooi ila taan to ye igham pa tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Mala maau pale ndiran samsamia tisob tilaledi. Ighaze ukaal naghodi, nene pale irau ughita di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Eemoghon yes to titatan taudi ve tinumeer Yoova, yes pale tineep pooi ila taan to ye igham pa tamtoghon toni. Pale igham di tineep poia kat toman tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Ndiran samsamia tilup di, ve tikaal ataam pa tiwaghamun tamtoghon deŋiadi. Atedi yabyab kat, ve tiŋaaŋ mareer ila padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Eemoghon Yoova iŋiŋ padi. Pasa, ye iwatag: Mala maau pale sawa todi ivot ve tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ndiran samsamia tipas buza todi tighaze timbut yes mbolaaŋa to tirau mbeb eta maau. Ve tindaad pane todi pa tivaneg di. Tighaze tirab yes to titaghon ataam deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Eemoghon Yoova pale ipamuul buza todi imuul pa taudi. Ve pane todi pale ipolpol. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Ighaze tamtoghon deŋia eta le mbeb rismoghon, nene iraua. Nepooŋ toni pale poia le ilib pa ndiran samsamia naol to ledi mbeb katindi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Pasa, Yoova pale ipasob ndiran samsamia tapiridi. Eemoghon ye ipapalot tamtoghon deŋiadi, ve iŋgin di tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yes to ledi sosor eta ila Maaron mata maau, Yoova iwatag nepooŋadi, ve mata padi. Ve mbeb popoia to ye igham di tinim ledi, nene pale tineep todi itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Sawa to ighaze pataŋani ivot, yes pale tineep pooi. Ighaze pitool ivot, nene pale tiraua kat pa aniiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Eemoghon ndiran samsamia pale tisob tilaledi. Yoova koia pale timatmaat tinimale kananaŋ ruŋgu to timalai ve kurukia tizi. Pale tisob tinimale yab mbuasa to iza ve imbiriis. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ndiran samsamia tighamgham bun, ve tiyatyat di maau. Eemoghon tamtoghon deŋiadi, yes tireirei mbeb todi pa yes mbolaaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Yes to poia to Yoova izaza todi, pale tineep pooi ila taan to ye igham pa tamtoghon toni. Eemoghon yes to mbalmbali toni inepneep todi, ye pale ipasob di ve tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yes to titaghon ataam to Yoova, tighami lolo poia kat. Ve ye pale ipatooŋ di pa ataam, ve ipalot di pa laghooŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Tamtoghon tovene, ighaze aghe ilot pa mbeb eta, nene irau itap maau. Pasa, Yoova ikiskis nima ve ipapaloti. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Sawa to pain ghou, ve inim aazne nanim olman waat, you naghita Yoova ipul muri pa tamtoghon deŋiadi pa eta sone. Ve naghita todi eta natu pitoola ve isuŋsuŋ tamtoghon pa a aniiŋ sone. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Tamtoghon deŋiadi matadi reiŋ mbeb, ve tiyokyok pa tamtoghon tigham bun ila todi. Ve ndinatudi paam, tinim ataam pa poia to Yoova iza to tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Upul murim pa ŋgar samia, ve ugham ŋgar poia moghon. Leso uneep pooi ila taan to Yoova igham payom itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Pasa, Yoova lolo pa ŋgar deŋia. Tovenen tamtoghon toni to lolodi ineep tuŋia ila toni ve titaghon ataam toni, ye irau ipul muri padi maau. Pale iŋgin poian di itaghoni taghoni gha ila. Eemoghon ndiran samsamia ndinatudi, ye pale ipasob di ve tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ndiran deŋiadi pale tigham taan to Yoova igham pa tamtoghon toni, ve tineep pooi tonowe irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Saveeŋ to ivotvot ila tamtoghon deŋiadi avodi, nene ŋgar poia ineep ila. Yes tisasavia ŋgar deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Tutuuŋ to Maaron todi, ineep ariaŋa ila lolodi ve ŋgar todi. Tauto irau titap maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ndiran samsamia tighamgham lilin tamtoghon deŋiadi. Tizuaria di tighaze le tirab di timaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Eemoghon Yoova ivolvool to tamtoghon toni. Irau ipul di tineep ila koiadi nimadi ne maau. Ve ighaze tamtoghon tipayoon di pa savsaveeŋ, nene pale Yoova tau iyoon ila muridi, ve ipaghazoŋan di ighaze ledi sosor maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Tovenen atem izi, ughur matam pa Yoova, ve utaghon katin ataam toni. Leso ipait ghom, ve izam pa taan to ye igham pa tamtoghon toni. Ve yom pale ughita Yoova iwaghamun ndiran samsamia ve tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","36","Muuŋ, you nawatag ŋgeu samia eez. Sawa naol, ye ipamatughezan tamtoghon, ve itatan di le tineep sami. Ŋgeu tonowen tapiri tiina kat. Ye inimale ai mendepur tiina to Lebanon. Eemoghon muri, nalaagh izi ndug toni, ve naghita ŋgeu tonowen ineep muul maau. Nakaal nagho le maau. Ila vena? ");
INSERT INTO tuc_o_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Matam ila pa yes to ledi sosor maau, ve ugham ŋgar pa yes to ŋgar todi popoia moghon, ve ughita sa ŋgar to ivotvot padi. Ŋgeu oro maate to ilup tamtoghon tinim ee moghon ve iuluul di pa tineep pooi, yesŋa papaghu toni pale tineep pooi itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Eemoghon yes to zoraaŋ Maaron aliŋa, Yoova pale irab di tisob timatmaat. Ve papaghu todi paam, ye pale ipasob di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yoova, ye Volaaŋa to tamtoghon deŋiadi. Ighaze pataŋani ivot padi, ye pale inim inadi to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ye iuluul di, ve ipaspas di tivot pa pataŋani todi. Ye ighamgham mulin di ila ndiran samsamia nimadi, ve tineep pooi. Pasa, yes tiŋarua tila, leso tiyooŋ ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Yoova, uyaan ghou toman atem yabyab malep. Ve ighaze upasaluŋgan ghou, uŋgal matag malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Yom uvaneg ghou pa pane tiom natu, ve nimam itatan katin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Atem yabyab payou kat. Tauto tinig isob isami wa. Anoŋag, babaŋa eta ineep pooi maau. Sosor tiou, tauto tuag tisob tiyabyab ve nasami. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Pataŋani to sosor tiou itatan ghou kat inimale dibom tintina tipolpol izala poghog. Tauto igham pataŋani tiina payou le irau nambaada maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","You nagham ŋgar to yes borouŋa ve nazoor aliŋam. Tauto aazne, mbotmboot toman nanag to vuzi samia ne igham ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Yabyabuuŋ tiina igham ghou, ve natudtud ve nayakyak. Tovenen mboŋmaagh ila le rabrab izi, lolog ipataŋan ve nataŋtaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Tinig ituntun kat, ve anoŋag isob isami wa. Anoŋag, babaŋa eta ineep pooi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Moroghooŋ tonene igham katin ghou le tapirig isob kat. Tovenen lolog ipataŋan ve nayakyak. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Yoova, yom uwatag: You naghaze uul ghou leso tinig poia. You lolog ipataŋan ve nataŋtaŋ. Mbeb tonene iyooŋ payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Aazne, ateg imbumbu ve tapirig isob. Tovenen naghog poia muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Nditag ve yes to ruum todi tigharau ghou ne, tighita moroghooŋ tiou tonene, le tineep saguan payou. Tigharau ghou muul maau. Ve siŋ tiou tovene paam. Tinim tiŋgig ghou rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Koiagŋa to tizuaria di tighaze tirab ghou namaat, tighur liis katindi payou. Mboŋmaagh ila le rabrab izi, yes tisavsaav pa ataam to tiwaghamun ghou. Lolodi ighurghur pa ataam yoŋgaaŋ pa tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Eemoghon matag ila pa saveeŋ todi tonowen maau. Neneeŋag moghon nanimale tamtoghon to avo maau ve taliŋa ipam, ve irau isavsaav maau, ve ilooŋ saveeŋ maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Onoon kat, you nanimale tamtoghon to taliŋa ipam ve ilooŋ saveeŋ maau, ve irau ipamuul saveeŋ eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","O Yoova, Maaron tiou, you naghur matag payom ve nasaŋan ghom. You nanumeer ghom naghaze yom pale ulooŋ suŋuuŋ tiou tonene ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Maaron, upul pataŋani tonene ilib payou malep. Pa vene, natap, ve koiagŋa tinidi iza, ve tipakur di tighaze tilib payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ughita. Yabyabuuŋ tonene ipul ghou rita maau. Moroghooŋ tonene irab matin tapirig le naghaze natap. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Onoon, you nazoor aliŋam. Tauto aazne, lolog ipataŋan, ve navotia sosor tiou payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Koiagŋa, ival kat, ve tapiridi tintina. Ŋgar to tigham payou ne, deŋia maau. Pasa, you nagham sosor eta padi maau. Yes tighur koi payou sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Ŋgar popoia to muuŋ naghamgham padi, aazne tipamuula pa ŋgar samia. Yes tighurghur koi payou pasa, you nazuaria ghou pa ŋgar poia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yoova, upul murim payou malep. Maaron tiou, uneep saguan payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yoova, yom to Volaaŋa tiou. Unum rikia, ve uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","You nasaav pa taug naghaze: “You pale naŋgin poian taug. Leso avog isosor sob. Ighaze naneep toman ndiran samsamia, you pale naŋgin poian avog. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Tovenen napoon avog, ve nasavia saveeŋ eta maau. Natatan taug, ve neneeŋag moghon. Eemoghon nagham ŋgar naol ila ila le lolog ipazaagh ghou naghaze nasaav. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Pasa, nagham ŋgar naol kat, le tiou imoz ghou. Tauto irau neneeŋag muul maau, ve naghason Maaron naghaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Yoova, upaghazoŋan ghou. Ndaman tiou piiz to inepneep sone? Pale ŋeez o namaat ve nasob pa taan? Uul ghou leso naghilaal naghaze: Mala maau pale nepooŋ tiou to taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Yom ughur leg sawa tuku moghon pa naneep izi taan. Sawa to nepooŋ tiou izi taan, nene inimale mbeb sorok ila matam. Onoon kat, tamtoghon tisob to taan nepooŋadi, nene inimale yaghuraad to ivot ila avood. Tineep ris ve tisob. Irau taghita di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Tamtoghon tilaghlaagh pa uraat naol. Eemoghon nepooŋadi, nene tuku inimale ai yavyaava to ighaze ndag izila, nene taghita muul maau. Matadi inim naol, ve tilala tinimnim pa uraat tighaze tindou ledi mbeb katindi. Eemoghon tirab taudi sorok. Pasa, tikankaan pa sei to pale iyou mbeb todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Yoova, sa mbeb to pale naghur matag pani pa iuul ghou? Mbeb eta maau. You naghur matag payom moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","You nazoor aliŋam ve nagham sosor. Upul sosor tiou isob, ve ugham mulin ghou pa pataŋani to sosor tiou. Pa vene, yes kankanooŋa to tiwatag ghom maau ne, tipiyaav saveeŋ velegiiŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Aazne, you neneeŋag moghon. Irau saveeŋ eta ivot ila avog maau. Pasa, yom taum to ugham pataŋani tonene ivot payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Maaron, uŋgal matag iraua! Nimam ighanghan ghou le tapirig isob wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ighaze tamtoghon tigham ŋgar samia, yom uyaan di, ve ulos di pa upasaluŋgan di. Ve mbeb todi popoia to lolodi pani kat, yom uwaghamun di inimale up iwaghamun uli. Nene inimale you nasavia ila wa. Yei tamtoghon to taan ninim mbeb sorok. Nineep rismoghon ve nisob, ninimale yaghuramai to ivotvot ila avomai. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yoova, upoon taliŋam pa taŋiiz tiou malep. Ughur taliŋam payou, ulooŋ suŋuuŋ tiou tonene, ve uul ghou. Pasa, sawa tiou to naneep izi taan, nene mala maau. Sawa tuku to naneep izi taan tonene, you naneep nanim loom payom, nanimale nditimbug tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Lolom isamin ghou ve upul ghou. Uŋgal matag iraua. Leso sawa tuku to naneep izi taan, naneep toman lolog poia, ghoro namaat ve nasob pa taan.” ");
INSERT INTO tuc_o_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Sawa to pataŋani igham ghou, ateg izi ve nasaŋan Yoova. Ve ye ighur taliŋa pa taŋiiz tiou, ve iuul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Muuŋ, nepooŋ tiou inimale you naneep izila saambu to yes mateeŋa. Eemoghon Yoova indae ghou naza. Agheg putukia ila karoos tiina, ve naghaze pale nandal nazila. Eemoghon ye ipas ghou naza, ve ighur ghou nayoon ila taan ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ve ipamundigin ghou ve nambou mbouŋ paghu. Nene mbouŋ to tapait Maaron toit iza. Ŋgar to Yoova igham payou, pale igham ival tiina tighilaal. Tovenen yes pale timatughez, ve tighur ila toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Tamtoghon to ighaze inumeer Yoova, nene pale tini iza, ve poia to Yoova iza toni. Tamtoghon tovene, ye ilup toman yes to tipait taudi izadi ne maau. Ve yes to tipul ataam to Maaron, ve timbesmbees pa maaron kaaromŋa, ye ineep saguan padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yoova, yom Maaron tiou. Eta irau ghom maau. Pasa, yom ughamgham uraat gharatooŋadi naol pa uul ghei. Uraat tonanan, ite kat. Ve lolom ighur pa ŋgar popoia naol to ughaze ugham payei. Ighaze natoova pa nanin di tisob ve nasavia di, nene pale naraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ŋgar to rabuuŋ mbeb inim watooŋrau payom, toman ŋgar to nigham aniiŋ payom pa nipait ghom, nene yom lolom pani maau. Ve ŋgar to ghuruuŋ mbeb izala artaal leso yab ighan suvuni, toman ŋgar to rabuuŋ mbeb pa rewaaŋ sosor to tamtoghon, nene paam, yom ughur matam pani maau. Yom ukaak taliŋag, leso nataghon aliŋam. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Tauto nasaav payom naghaze: “Maaron, taug nene. Nataghon saveeŋ to timbooda iŋarua ghou ila rau tiom, tauto nanim.” ");
INSERT INTO tuc_o_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Maaron tiou, ighaze nataghon katin lolom, nene igham lolog poia kat. Pasa, tutuuŋ to yom ugham payei, nene ineep ariaŋa ila lolog. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Yoova, yom uwatag: Ulaaŋ to ugham payei, you neneeŋag pani maau. Sawa to ival tiina tilup di pa suŋuuŋ, you nasasavia varum padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Onoon kat, ulaaŋ ve ŋgar deŋia to upatooŋa payou, you naŋgooza ineep to taug moghon maau. Ve gabuam to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, nene paam, naŋgooza pa tamtoghon tiom maau. Sawa to tilup di pa suŋuuŋ, you nasasavia gabuam tonenen padi. Ŋgar tiom to uluul tamtoghon itaghon saveeŋ mbuaaŋ tiom, nene navovotia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yoova, matam kisin sosor tiou malep. Lolom isamin ghou ve upul sosor tiou. Ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom, ve utataghon saveeŋ mbuaaŋ tiom, nene pale inim sigeu payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Ughita. Aazne, pataŋani naol tiluvut ghou. Irau nanin di maau. Ŋgar tiou samsamia atia, tauto iŋarua ghou. Tovenen naghita naghaze leg ataam eta muul maau. Sosor tiou, katindi kat. Tilib pa dabag raua. Tovenen namatughez, ve tapirig isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O Yoova, lolom isamin ghou, ve ugham mulin ghou pa pataŋani tonene! Unum rikia moghon ve uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Yes to tikalkaal ataam pa tirab ghou namaat, utatan di, ve ugham ŋgar todi iwaghamgham, leso mayadi. Ve yes to tighita pataŋani tiou tonene ve tinidi iza pani ne paam. Upamuul di tila toman mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ve yes to tisavsaav payou tighaze: “Aa, ughita wa? Ŋgar to nighaze ivot payom, tauto ivot wa!” Ndiran tovene, utatan di, ve ugham di tiwaghamgham. Leso mayadi pa ŋgar to tighami. ");
INSERT INTO tuc_o_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Eemoghon tamtoghon tisob to tizuaria di tighaze le tiwatag katin ghom, yes pale lolodi poia ve tinidi iza payom. Ve yes to lolodi pa ulaaŋ tiom, nene pale lolodi poia kat, ve moghon moghon tisavsaav tighaze: “Tapait Yoova. Pasa, ye iza tiina kat.” ");
INSERT INTO tuc_o_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Yoova, matam inim payou lak! Pasa, pataŋani tonene itatan ghou le tapirig isob. Narau mbeb eta muul maau. Yom moghon to irau uul ghou ve ugham mulin ghou. Maaron tiou, uzuar malep. Unum rikia moghon ve uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Ighaze tamtoghon eta mata iŋgalŋgal yes mbolaaŋa ve iuluul di, nene pale poia to Yoova izaza toni ve tini iza. Ve ighaze pataŋani eta ivot pani, nene pale Yoova iuuli. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yoova tau pale inim sigeu pani ve iŋgini. Leso imaat sob, ve ineep pooi. Pale ineep izi taan to Yoova igham pa tamtoghon toni, ve poia to Yoova izaza toni. Yoova irau ipuli ila koia nimadi ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ve ighaze ye imorooŋ ve ighengheen, nene pale Yoova tau iŋgini, ve ipasob moroghooŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","You nasaav naghaze: “Yoova, you nagham sosor payom wa. Lolom isamin ghou ve upasob moroghooŋ tiou. Pasa, you mbesooŋa tiom.” ");
INSERT INTO tuc_o_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Koiagŋa tisasavia saveeŋ samsamia iŋarua ghou tighaze: “Ŋgeu tonowen, ŋeez o imaat? Leso iza isob, ve lolood imaagh pani?” ");
INSERT INTO tuc_o_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ve sawa to tamtoghon tinim tiŋgig ghou, tisavia saveeŋ toman lolodi maau. Yes tinim pa tiŋgig ghou pa moroghooŋ tiou moghon. Ve sawa to timuul tila, tisasavia varug sorok irau ndug tighaze: “Paam imaat.” ");
INSERT INTO tuc_o_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Yes to tighur koi payou ne, tisob tighaze le nasami kat. Tovenen tikakamuun payou tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Aa, ŋgeu tonowen, moroghooŋ samia kat ighami. Irau mata pakia ve imundig muul ne maau. Paam imaat.” ");
INSERT INTO tuc_o_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ve itag ite to nanumeera kat naghaze yeru lupuuŋ tiei ee moghon, ve niluplup ghei pa ghanghaniiŋ, ye paam ipul muri payou, ve inim koiag. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Yoova, lolom isamin ghou ve uul ghou. Pasa, you mbesooŋa tiom. Upasob moroghooŋ tiou, ve ugham tinig poia muul. Leso nayat ŋgar samia to koiagŋa tigham payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Yoova, aazne you nawatag naghaze yom lolom poia payou. Pasa, koiagŋa titatan ghou maau. Tovenen irau aliŋadi iza sorok tighaze yes tilib payou ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","You nataghon ŋgar deŋia moghon. Tauto upalot ghou ve nayoon ariaŋa. Ve yom pale ugham ghou naneep toman ghom itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Tapait Yoova pa poia toni! Ye Maaron to iit Israela. Tapait iza to aazne, ve itaghoni taghoni gha ila. Onoon le onoon kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Maaron, you naghaze le naneep nagharau ghom, ghoro poia. Eemoghon aazne, naneep saguan payom. Tovenen naŋazuuv ghom nanimale ŋgai sagsag to muruni, ve ikalkaal a ya pa ghunuuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Yoova, yom Maaron to uneep matam iyaryaar. You lolog payom kat nanimale tamtoghon to murun matini, ve ikalkaal a ya pa ghunuuŋ. Pale ŋeez o nalat peria tiom muul, ve nayoon ila naghom ve nasuŋ payom? ");
INSERT INTO tuc_o_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mboŋmaagh ila le rabrab izi, tamtoghon tinoknok velegiiŋ ghou tighaze: “Maaron tiom ineep sine?” Saveeŋ todi tonowen igham ghou nataŋtaŋ ve naghunghun matag suru irau mboŋ ve ndag. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","You matag iŋgal imuul ila pa ŋgar to muuŋ naghamghami, tauto navotia lolog ila to Yoova. Sawa tonenen, you namuŋmuuŋ pa ival tiina, ve yeiŋa nizazala pa Maaron rumai toni, leso nilup ghei pa suŋuuŋ. Yei nimboumbou toman lolomai poia kat, ve nilolool ve nipapait Maaron iza pa poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Tauto naghason taug naghaze vena to aazne lolog isami? Lolog ipataŋan, ve nagham ŋgar naol pasa? You irau naghur ila to Maaron, ve naghur matag pani. Pasa, ye Maaron tiou ve Volaaŋa tiou. Tovenen you pale napaiti muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Onoon, aazne lolog ipataŋan kat, ve naŋazuuv ghom. Pasa, naneep nagharau ghom maau. You naneep izi ya Yordan daba to ineep izi lolooz Ermon dige to ila pa lolooz Mizar we. Eemoghon you pale matag iŋgal imuul ila pa ŋgar tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Pataŋani to yom upuli ivot payou, nene itatan ghou kat. Nene inimale ya to ireer toman avolutu tiina, iyatovtova izala poghog ve imbeluut ghou. Ve inimale dibom tintina to mazovan tipolpol izala poghog. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Eemoghon ndag to naol ne, Yoova lolo ineep tuŋia inim tiou ve iuluul ghou. Tovenen mboŋ to naol, you namboumbou ve napaiti. Suŋuuŋ tiou iŋaŋarua Maaron. Pasa, ye to iŋgin nepooŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Maaron, ye Volaaŋa tiou ariaŋa. Ye iponpoon ghou inimale raŋ to izala kat. Tovenen naghasoni naghaze: “Pughu vena to lolom imaagh payou? Vena to upul koiagŋa titatan ghou, ve tigham ghou lolog isami?” ");
INSERT INTO tuc_o_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Moghon moghon koiagŋa tisasavia saveeŋ velegiiŋ payou. Ve tinoknok ghasoniiŋ ghou tighaze: “Maaron tiom ineep sine?” Saveeŋ todi tonowen iŋgalŋgal ghou inimale iiz. ");
INSERT INTO tuc_o_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Tauto naghason taug naghaze pughu vena to lolog isami? Lolog ipataŋan ve nagham ŋgar naol pasa? You irau naghur ila to Maaron ariaŋa ve naghur matag pani. Pasa, ye Maaron tiou ve Volaaŋa tiou. Tovenen you pale napaiti muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Maaron, yes to matadi iŋgal ghom maau, tighamgham pataŋani payou. Uyoon payou, ve upaghazoŋan ghou ila matadi ughaze you nagham sosor eta maau. Upas ghou ila ndiran kaaromŋa ve ndiran samsamia tonene nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Pasa, yom Maaron tiou, ve you nayooŋ ilat tiom. Pughu vena to upul murim payou? Vena to upul koiagŋa titatan ghou ve tigham ghou lolog isami? ");
INSERT INTO tuc_o_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Naghaze ugham ghazooŋa tiom isul ghou ve upaghazoŋan ghou pa saveeŋ tiom onoon. Pasa, mbeb ru tonowen pale tipatooŋ ataam payou, ve tigham pooz payou, leso nazala pa inam to nepooŋ to ineep izi lolooz tiom patabuaŋ daba. ");
INSERT INTO tuc_o_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ghoro naŋarua artaal tiom, ve nayoon ila naghom ve napait ghom. Pasa, yom Maaron tiou, ve yom to ugham ghou lolog poia kat. Tovenen you pale narab gita, ve nambou pa napait izam. Pasa, yom Maaron tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Tauto naghason taug muul naghaze pughu vena to aazne lolog isami? Lolog ipataŋan ve nagham ŋgar naol pasa? You irau naghur ila to Maaron ariaŋa ve naghur matag pani. Pasa, ye Maaron tiou ve Volaaŋa tiou. Tovenen you pale napaiti muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Maaron, muuŋ sawa to nditimbumai, yom ughamgham uraat tintina padi. Tauto tighamgham kamos pani inim inim, le aazne yei nilooŋa pa taumai taliŋamai paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Yes ndug ndug to muuŋ tineep izi taan tonene, ila taum tapirim, yom undiir di tighau tila, ve ugham nditimbumai tinim tineep izi taan tonene, ve inim ledi kat. Yom utatan yes Kanaana le tapiridi isob kat, ve ugham nditimbumai tineep pooi izi taan tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Onoon, nditimbumai tigham malmal pa taan tonene. Eemoghon taudi tapiridi ve buza todi igham di tilib pa koiadi ne maau. Yom uneep toman di ve matam padi, ve upatooŋ tapirim pa koiadi ve uparab toman di. Tauto nditimbumai tilib padi, ve tigham taan todi inim ledi. Pasa, yom lolom padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Yoova, yom kinik tiou, ve Maaron tiou. Yom usaav ariaŋa ughaze yei Israela to siŋ to Yakop pale nilib pa koiamai. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ila taum tapirim, yei nitatan koiamai. Yei nighur ilat tiom, ve suŋuuŋ tiei iŋarua ghom. Tauto uul ghei ve nirab di, ve nivazag di ila aghemai samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","You nanumeer pane tiou maau. Ve buza tiou paam, nene irau igham mulin ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Yom moghon to uluul ghei, ve ughamgham mulin ghei ila koiamai nimadi. Yom ugham di tiwaghamgham, ve mayadi a tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Maaron, yom uluul ghei, tauto moghon moghon nipapait ghom, ve lolomai poia payom. Yei pale nipait izam itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Eemoghon aazne, yom upul murim payei, ve unum toman ndaaba tiei muul maau. Ve upul koiamai tilib payei le mayamai kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Yom ugham ghei tapirimai maau. Tauto nipul malmal ve niwaghaughau, ve koiamai tiyou mbeb tiei tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Yom ughur ghei nila nimadi ninimale sipsip to timbit di leso tirab di. Ve ureu ghei nimbiriis irau ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Yei tamtoghon tiom. Eemoghon aazne, ugholia ghei nila koiamai nimadi, ve ninim mbesooŋa padi. Ve ugham mbeb tiina eta ila nimadi maau. Yom ughur atiamai izi kat, inimale yei mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Yes to tineep tigharau ghei, tighita ŋgar to ugham payei, le tiŋiŋ ve tigham ŋalalaŋ payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Yes ndug ndug to tiwatag ghom maau ne, tighita ghei ninimale mogheraaŋ. Ve tiŋiŋiŋ payei, ve tililiit dabadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ndag to naol, mboŋmaagh ila le rabrab izi, tamtoghon tipamayaŋin ghou. Tovenen matag iza maau. Mayag ve natudtud moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Pasa, tamtoghon tighita ŋgar to koiagŋa tiyati payou, ve tipipiyaav saveeŋ velegiiŋ ve saveeŋ mayaŋiiŋa naol payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","You nagham ŋgar naol naghaze pughu vena to yom upul pataŋani naol tonene tivot payei? Pasa, yei lolomai imaagh payom maau. Ve saveeŋ to nimbua toman ghom, yei nireua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Yei nipul murimai payom maau. Ve laghooŋ tiei, niyel pa ataam tiom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Eemoghon yom uwaghamun ghei kat le ndug tiei ŋginiŋa inimale mbeb sagsagŋa inadi to nepooŋ. Nepooŋ tiei, nene inimale ndoroom tiina ikau ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","21","Maaron tiei, yom uwatag: Lolomai imaagh payom maau, ve nisuŋ pa maaron kaarom eta maau. Inimale nigham ŋgar tovene, tone yom uwatag. Pasa, ŋgar ŋgozaaŋ to tineep ila lolomai, eta iyooŋ payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Yei nimbesmbees pa yom moghon. Tauto mboŋmaagh ila le rabrab izi, koiamai tirabrab ghei nimatmaat. Tighita ghei ninimale sipsip to timbit di leso tirab di timaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Yoova, ugheen iraua! Umundig! Ugham ŋgar eta pa uul ghei lak! Pale upul murim payei tovene itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Pughu vena to uŋgooz matam payei? Ughita. Koiamai titatan ghei le nisami wa. Pataŋani tiina to nimbadbaada ne, lolom imaagh pani malep! ");
INSERT INTO tuc_o_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Aazne, koiamai titatan ghei kat. Tovenen nitap nizi taan, ve nigheen izala ghavuur pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Maaron, umundig! Unum uul ghei lak! Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen upas ghei nivot pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Lolog ipazaagh ghou pa saveeŋ popoia, tauto natoor mbouŋ tonene iŋarua kinik. Avog raurau pa toraaŋ mbouŋ, nanimale ŋgeu to nima poia pa bodeeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","O kinik, yom paghunam kat ulib pa tamtoghon tisob. Ve saveeŋ popoia to ivotvot ila avom, nene igham poian tamtoghon. Tovenen poia to Maaron pale ineep toman ghom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Yom ariaŋam, ve uraua kat pa ghamuuŋ malmal. Izam tiina, ve upambood taum le paghunam kat. Ugham buza tiom, ve ugharaat ghom pa malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Yom izam tiina kat. Uza hos tiom, ve ula uparab toman koiamŋa le ulib padi. Uparab ariaŋa pa saveeŋ onoon, ŋgar to tatatan tauud, ve ŋgar deŋia. Nimam waan pale igham uraat tintina. Leso koiamŋa tighita ve timatughez. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Kinik tiei, pane tiom ndinatu matadi kat. Tauto tiŋgal koiamŋa le tiyamaan katin di. Tovenen yes ndug ndug pale tinim ve titaptap tizi ila aghem samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Maaron, pooz tiom irau isob ne maau. Pale uneep ila inam to ghamuuŋ pooz itaghoni taghoni gha ila. Ŋgar deŋia to ughamgham pa tamtoghon, nene inim ghilalooŋ pa pooz tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Pasa, yom lolom pa ŋgar deŋia, ve ughurghur koi pa ŋgar samia. Tovenen Maaron tiom ipakur ghom le ulib pa nditam pida, ve iliŋ ŋgoreeŋ izala poghom pa ighur ghom unum kinik. Tauto igham ghom lolom poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Nonogiiŋa tiom, tighur naunauŋ vuzi popoia naol ila. Ruum tiom, tipambooda pa mbeb popoia to tigharaat di pa mbeb ndoŋadi. Yes to rabuuŋ gita ve mbeb pida to aliŋadi popoia ne, tineep toman ghom ila ruum tiom lolo, ve mbouŋ todi igham ghom lolom poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Ndiliva to ledi izadi tinim tineep toman ghom ila ruum tiom paam. Ve todi pida, nene kinik ndinatudi liva. Liva paghu to iyoon ila pa nimam waan ve ughaze uvaii, ye garawaat tidi. Ye itiktiik tau pa mbeb popoia le paghuna kat. Mbeb tonowen, tigharaat di pa gol poia kat to inim pa taan suruvu to Opir. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Natug liva, yom ughaze uvai kinik. Tovenen ughur poian taliŋam, ve ulooŋ aliŋag tonene. Ugham ŋgar pa tamtoghon tiom ve siŋ tiom muul malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Yom paghunam kat. Pale usad kinik ate. Ye to inim tiina tiom. Tovenen yom irau ulooŋ aliŋa, ve uneep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Tamtoghon to ndug Tiro pale tigham lem mbeb popoia katindi. Yes to mbaliiŋ taudi kat, pale tigham lem mbeb popoia naol. Leso matam iŋgal di ve lolom poia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Garawaat tidi to ighaze ivai kinik, ineep ila ruum toni lolo. Ye paghuna le paghuna kat. Nonogiiŋa toni, tisaii pa teret to tigharaata pa gol. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ye indudi pa nonogiiŋa to bodeeŋadi popoia, ve tighami ila to kinik. Ndita ndiliva papaghu titaghoni ve yesŋa tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Tamtoghon tinidi iza, ve tighereb di toman lolodi poia, ve tilooŋ tila ruum to kinik. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","O kinik, yom pale lem ndinatum nditamoot katindi, leso tigham nditimbudi inadi. Ve yom pale ughur di pa tigham pooz pa ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Mbouŋ tiou tonene, tamtoghon pale timboui, ve matadi iŋgal izam itaghoni taghoni gha ila. Tovenen ndug ndug pale tipait izam irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Maaron inim inaad ariaŋa to yoŋgaaŋ, ve ipapalot ghiit. Ighaze pataŋani eta ivot pait, ye pale ineep digeed ve iuul ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Tovenen irau tamatughez maau. Ighaze yoŋgyoog itok taan, ve lolooz tipolpol tizila te lolo, ");
INSERT INTO tuc_o_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ve te isami, ve dibom tipaparab ve tighelghel naari to lolooz pughu le lolooz tirur, nene poia. Irau tasaŋeeŋ maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Maaron Tiina To Ilib Pa Ndimaronŋa Tisob Ne, ndug toni patabuaŋ, ye le ya to moghon moghon irereer. Ya tonowen igham tamtoghon to ndug toni tineep pooi toman tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Maaron inepneep ila ndug tonowen ve iŋginŋgini. Tovenen mbeb eta irau itok ndug tonowen maau. Ighaze pataŋani eta ivot padi, Maaron irau isaŋan le mboŋmaagh maau. Pale iuul di rikia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ndug ndug, matughezaaŋ tiina igham di ve tisaŋeeŋ. Kinik to taan tapiridi isob, le ndug todi tiwaghamgham. Ve Maaron isaav aliŋa tiina inimale lalaav avolutu, le taan ituntun ve ireer inimale ya. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yoova, ye Maaron ariaŋa ve iŋgin mbeb tisob. Ye ineep toman ghiit irau sawa isob. Maaron to Yakop inim inaad ariaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Anim aghita uraat tintina to Yoova igham di. Uraat toni igham tamtoghon timatughez ve avodi ikaak. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Ye ipasob malmal irau taan dige to naol ne. Ve iŋgor polpolin pane ve iiz, ve isad sigeu to malmal, ve isuruuv di tizala yab. ");
INSERT INTO tuc_o_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ye isaav pa tamtoghon ighaze: “Aparab iraua! Atemim izi, ve aghilaal ghou. You moghon to Maaron. Ndug ndug pale tipait ghou, ve izag inim tiina irau taan isob.” ");
INSERT INTO tuc_o_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yoova, ye Maaron ariaŋa, ve iŋgin mbeb tisob. Ye ineep toman ghiit irau sawa isob. Maaron to Yakop inim inaad ariaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Yam tamtoghon to ndug ndug, tinimim iza ve apambar nimamim! Yam asob alool, ve ambou tapirimim pa Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Pasa Yoova, ye Maaron Tiina To Ilib Pa Ndimaronŋa Tisob. Amatughez pani ve ataghon ŋgar toni. Onoon kat, ye kinik tiina. Tamtoghon tisob to taan tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Ye itatan ndug ndug, ve ighur di tineep ila sambamai. Yes to tiwatagi maau ne, ye irab di tizi, ve nivazag di ila aghemai samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Iit siŋ to Yakop, Yoova lolo ineep toit kat. Tauto irab motin taan suruvu eez, ve igham pait. Iit tiniid iza ve tapakur ghiit pa taan to ye igham pait. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Maaron izala ina to ghamuuŋ pooz ve ineep tonowe. Tovenen tavuur itaŋtaŋ, ve tamtoghon tilolool toman lolodi poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Ambou, ambou! Ambou ve apait Maaron! Ambou ve apait kinik toit iza! ");
INSERT INTO tuc_o_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Pasa Maaron, ye kinik tiina. Tamtoghon tisob to taan tineep ila samba. Tovenen ambou mbouŋ, ve apaiti! ");
INSERT INTO tuc_o_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Maaron ineep ila ina patabuaŋ to ghamuuŋ pooz, ve iŋgin ndug tisob. Tamtoghon tisob tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Daba to ndug ndug tilup toman iit to tambesmbees pa Maaron to Abaram, ve itiŋa tapait iza. Pasa, pooza tisob to taan tineep ila nima. Tapait iza izala le izala kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","2","Yoova iza tiina kat. Tovenen iit to taneep ila ndug toni, tapait iza izala le izala kat. Ndug toni, nene ineep izala lolooz toni patabuaŋ Zion. Lolooz tonowen, paghuna ve izala kat. Tamtoghon tisob to taan lolodi poia pa lolooz Zion ve tipaiti. Pasa, nene Maaron tau ina to nepooŋ. Ndug to kinik tiina ineep tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Tamtoghon tiwatag: Maaron iponpoon ndug toni inimale didiiŋ ariaŋa. Ye inepneep tonowe, ve inim sigeu padi. Tauto tamtoghon to ndug tonowen tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","5","Kinik pida tilup di tighaze tigham malmal pa Maaron ndug toni. Eemoghon sawa to tinim tighita, ruŋadi iza pani, ve timatughez ve tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","7","Matughezaaŋ tiina igham di le tisaŋeeŋ tinimale ndiliva to apodi iyabyab pa popaaŋ. Ve yom uwaghamun di le tisami kat, tinimale waaŋ tintina to ndug Tarsis to tighau tila, ve rag imundig le irab mbirisan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Yoova, ye Maaron tiei ariaŋa to iŋgin mbeb tisob. Muuŋ, niloŋlooŋ uraat toni tintina varudi moghon. Eemoghon aazne, nineep ila ndug toni, ve ye igham uraat tovene ivot muul, le nighita katini pa taumai matamai. Maaron ipapalot ndug toni. Tovenen ndug tonowen pale iyoon ariaŋa itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Maaron, yei nineep ila rumai tiom lolo, ve matamai iŋgalŋgal gabuam to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Maaron, varum ilaan irau taan dige to naol ne. Tauto ndug ndug tipapait izam. Yom upatooŋ tapirim, leso upalot ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Gabizooŋ tiom, nene deŋia moghon. Tovenen tamtoghon tisob to ndug Zion, toman ndug ndug to Yudea ne lolodi poia kat, ve tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Yam amundig ve alaghlaagh ila ndug Zion lolo. Ala aghita didiiŋ ariaŋa to iluvut ndug ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Anin ruum dabadi mamala to yes ndaaba tiyondyood izala, ve matadi ilala pa koiadi. Ve matamim ila pa ruum ariaŋadi to ndaaba tiyooŋ ila ve tigham malmal. Leso yam irau asavia ndug tonene pa papaghu tiam to muri pale tivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Pale asaav padi tovene: “Maaron toit, ye ariaŋa inimale ndug Zion. Ye ineep irau sawa isob. Ve ye pale imuuŋ pait, ve ipatooŋ ataam pait itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","2","Yam tamtoghon to ndug ndug, alooŋ saveeŋ tiou tonene. Yam tamtoghon to aneep irau taan, aghur poian taliŋamim payau. Yam to lemim izamim maau, ve yam to izamim tintina ne paam. Ve yam to mbaliiŋ taudi, ve yam mbolaaŋa paam. Yam asob alooŋ aliŋag tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Pasa, avog pale ivotia ŋgar popoia pida to tineep ila lolog ne. Saveeŋ tiou tonene irau ipamundigin ŋgar tiam. Leso aghilaal ŋgar poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","You naghaze nasavia saveeŋ palelaaŋ pida payam. Le isob, ghoro narab gita, ve napaghazoŋan pughu payam. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Ighaze sawa samia eta ivot, ve ndiran samsamia toman ndiran kaaromŋa tiluvut ghou pa tiwaghamun ghou, nene irau namatughez maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Onoon, yes tindoundou ledi mbeb katindi. Tauto tinumeer mbeb todi tonowen, ve tipakur di pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","8","Eemoghon mbeb todi tonowen irau igham mulin di pa mateeŋ maau. Pasa, tamtoghon eta irau ighol Maaron, leso ipaghau mateeŋ pani, ve nepooŋ toni to taan iseeŋga itaghoni ila ne maau. Ŋgar tovene, tapuli ineeple. Pasa nepooŋ tovene, atia ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Tovenen mbaliiŋ toit eta irau ipoon ghiit pa mateeŋ maau. Mbeb eta to taan irau igham ghiit taneep le alok ne maau. Maau kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Iit taghita yes ŋgara timatmaat tinimale yes kankanooŋa to ledi ŋgar maau ne. Ve sawa to timaat, yes pale tipul mbeb todi tisob tizi tineep, ve mbeb tonowen tinim tamtoghon pida ledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Sawa to tineep matadi iyaryaar, yes izadi tintina. Pasa, ledi taan tiina ve mbeb katindi. Eemoghon sawa to timaat, naal to inim ledi inadi irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Tovenen ighaze tamtoghon eta iza tiina, ve le mbeb popoia katindi, nene poia. Eemoghon mbeb toni irau ipaghau mateeŋ pani ne maau. Pale ineep rismoghon, ve isob. Ye pale imaat ve ilale, inimale ŋgavuun ve ŋgai. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Nene ataam to yes to tigham ŋgar to borouŋa, ve tipakur di pa mbeb todi. Aghita ŋgar to ivotvot padi ve yes to lolodi pa saveeŋ toman ŋgar todi, ghoro aghilaal. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Yes tinimale sipsip to timbit di leso tirab di. Mateeŋ pale inim ŋginiiŋ padi, ve iweu di tizila ndug to mateeŋa, ve patudi imbuuz tonowe. Ve mboŋmaagh, ghoro ndiran deŋiadi pale tighita di, ve lolodi poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Eemoghon you, ndug to mateeŋa le tapiri irau ikis ghou maau. Pasa, Maaron pale igham mulin ghou pa mateeŋ. Pale ipas ghou navot pa mateeŋ, ve igham ghou nala yeru nineep. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Tovenen ighaze tamtoghon eta indou le mbaliiŋ, ve mbeb popoia katindi tivon ila ruum toni, ugham ŋgar naol pani malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Pasa sawa to imaat, ye irau ikis mbeb toni eta ve ila ne maau. Mbeb popoia naol to ye iza tiina pani, irau ila tomani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","19","Sawa to tamtoghon tonenen ineep mata iyaryaar, ye ineep pooi toman tini iza. Ve ival tiina tipait iza pasa, tighita tighaze ye iraua. Eemoghon ye pale imaat, ve ineep toman nditimbu ila ndoroom lolo. Yes to ndug tonowen irau tighita ghazooŋa muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Tovenen tamtoghon to ighaze iza tiina ve le mbeb katindi, nene poia. Eemoghon ye ighilaal maau. Muri, ye pale imaat ve ilale, raraate inimale ŋgavuun ve ŋgai. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Yoova, ye Maaron ariaŋa. Aliŋa ilat pa yam tamtoghon to taan. Ye ipoi gham ighaze yam asob anim alup gham ila nagho. Yam to aneep ila pa ndag iza, ve yam to aneep ila pa ndag izila ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Ndug Zion paghuna le paghuna kat. Maaron ineep tonowe, ve ŋguruba isul ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Maaron toit ighaze inim tonene. Irau neneeŋa muul maau. Yab ighan imuuŋ pani, ve yaghur tiina toman uman iluvuti. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ye ipoi sambam ve taan tinim, leso tighita iŋgabiiz tamtoghon toni ve ighur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Ve isaav ighaze: “Tamtoghon tiou to lolodi ineep tiou ve titaghon ŋgar tiou, ayou di tisob tinim tilup di ila naghog. Nene yes to tigham watooŋrau payom, ve timbua saveeŋ toman ghou tighaze yeiŋa nilup ghei ninim ee moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Maaron iŋgagabiiz tamtoghon ve ighurghur atia padi. Ve mbeb to sambam paroŋania tipatooŋa tighaze gabizooŋ toni, nene deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Yam tamtoghon tiou Israel, alooŋ saveeŋ to naghaze nasavia payam. Pasa, you to Maaron tiam. Aazne, you pale nasaav ila matamim, ve navotia sosor tiam. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Watooŋrau to aghamgham di payou ne, you nayaan gham padi maau. Moghon moghon naghita gham aghurghur watooŋrau tizala artaal, leso yab ighan suvun di. Nene poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Eemoghon you irau nagham makau, ma mekmek to tineep ila sirsiir tiam lolo ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Pasa, you nambool pa mbeb eta maau. Mbeb tisob to tilaghlaagh ila su lolo, ve makau to tineep irau lolooz to naol ne, nene tiou moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Ve man to tirovroov ila tata paroŋania, you nawatag di tisob ve naŋgin di. Ve mbeb tisob to tilaghlaagh ila reg lolo ne paam, nene tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ighaze pitool ghou, irau nasaav payam maau. Pasa, taan toman mbeb tisob to tineep ila, nene tiou moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Vena, yam aghaze you naghanghan makau minda, ma naghunghun mekmek siŋi? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Watooŋrau to lolog pani, nene vene: Lolomim poia payou, ve apait ghou pa poia tiou. Ve saveeŋ to ambua toman Maaron tiam to ineep sala le sala kat ne, agham uraata le anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ve ighaze pataŋani igham gham, ghoro ataŋ roran ghou pa ulaaŋ. Leso nagham mulin gham, ve apait izag pa tapirig ve poia tiou.” ");
INSERT INTO tuc_o_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Eemoghon ndiran samsamia, Maaron isaav padi ighaze: “Tutuuŋ tiou to naghur di pataghaaŋ, yam awatwaat di sorok pasa? Ve pughu vena to asasavia saveeŋ to nambua toman tamtoghon tiou?” ");
INSERT INTO tuc_o_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Pasa, sawa to you napasaluŋgan gham, yam ayasiil pa aliŋag. Ve azorzoor saveeŋ tiou, ve avelegi inimale mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ighaze aghita yubyub eta, yam lolomim poia pani, ve aghami inim itamim. Ve yes to tighurghur maat, yam ala toman di ve yamŋa alaghlaagh. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Saveeŋ samsamia ve kaarom naol, to ivotvot ila avomim. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ve yam aŋgalŋgal saveeŋ pa siŋ tiam, ve awaghamun toŋvetaz tiam izadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Vena, yam aghamgham tovene ve aghita neneeŋag, tauto aghaze you nayok pa ŋgar tiam tonanan? Yam aghaze itiŋa rarateed? Maau! Tauto aazne, you nayaan gham, ve nasaav ila matamim, ve navotia sosor tiam ivot ighazooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Tovenen yam to lolomim imaghmaagh payou, apatum gham! Pa vene, namundig, ve nawaghamun gham kat. Ve eta irau ipas gham ila nimag maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Tovenen lolomim poia payou, ve apait ghou pa poia tiou. Pasa, watooŋrau tovene, tauto igham izag inim tiina. Tamtoghon to mata iŋgal tau pa laghooŋ toni, nene pale napatooŋ ulaaŋ tiou pani, ve nagham mulini. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","O Maaron, yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen lolom isamin ghou, ve upul sosor tiou. You nazoor aliŋam. Eemoghon poia tiom, nene tiina, ve lolom isamin tamtoghon tiom kat. Tovenen ureu sosor tiou isob ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","You nayel pa ataam tiom, ve nagham ŋgar samia ila matam. Urughuuz ghou, ve ugham ghou naŋgalaaŋ ila matam muul. Ureu sosor tiou isob ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Pasa, you naghilaal sosor tiou wa. You nazoor aliŋam, ve nayel pa ataam tiom. Moghon moghon, sosor tiou inepneep toman ghou, ve matag iŋgalŋgali. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Sosor to naghami, nene iŋarua ghom moghon. You nagham ŋgar samia ila matam. Tovenen ighaze uvotia sosor tiou ivot ighazooŋ, nene deŋia. Onoon kat, ighaze uŋgabiiz ghou ve ughur atia payou, nene sosor maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Sawa to tinaŋ ipoop ghou ve inim, you nayel pa ataam tiom. Sawa to tinaŋ inaama payou, samia ikis ghou pataghaaŋ wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Maaron, yom ughaze you nataghon saveeŋ onoon toman lolog. Tovenen taum upatooŋ ghou pa ŋgar popoia. Leso nakisi tuŋia ila lolog. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ureu sosor tiou isob ilale. Leso naŋgalaaŋ ila matam. Urughuuz ghou le naŋgalaaŋ kat nanimale yaghur tae pisosooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","You naghaze nalooŋ ghom usaav ughaze yom ureu sosor tiou wa. Leso tinig iza, ve lolog poia muul. Yom ughur pataŋani tiina kat iŋarua ghou pa sosor tiou. Uul ghou, leso tinig iza muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ŋgar tiou naol to tiyel pa ataam tiom, matam ila padi muul malep. Ureu sosor tiou isob ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Maaron, ugham ŋgar ŋgalaaŋa ivot ila lolog, ve upalot ghou. Leso nayoon tuŋia muul, ve nataghon katin ŋgar tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Undiir ghou pa naghom malep. Ve uŋgwaaz Avuvum Patabuaŋ ighau payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Muuŋ, yom ugham mulin ghou le lolog poia kat. Aazne, naghaze ugham tovene payou muul. Upamundigin ghou, leso matag loŋloŋaiŋa payom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ighaze ugham tovene, you pale napatoot yes to tizorzoor aliŋam, ve yes to tighamgham sosor pale titoor ŋgar todi imuul ilat payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Maaron, sosor tiou to narab tamtoghon imaat, nene tiina kat. Irau namaat pani. Eemoghon yom Maaron tiou ve Volaaŋa tiou. Tovenen ugham mulin ghou, ve ureu sosor tiou ilale. Leso lolog poia kat, ve nambou tapirig, ve napait izam pa ŋgar tiom deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","You mayag pa sosor tiou, ve neneeŋag. Tovenen ureu sosor tiou ilale. Leso avog pakia, ve napait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Maaron, yom lolom pa nagham ŋgai inim watooŋrau payom malep. Watooŋrau to yab ighan suvuni ne paam. Inimale igham ghom lolom poia, tone naghami. Eemoghon yom lolom pa ŋgar tovene maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Watooŋrau to yom lolom pani, nene vene: You irau natatan taug, ve lolog ipataŋan pa sosor tiou. Nene watooŋrau kat. Tamtoghon to ighaze itatan tau, ve lolo ipataŋan pa sosor toni, nene yom irau upul murim pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Maaron, ugham poian ndug Zion itaghon taum lolom. Ugharaat mulin didiiŋ ariaŋa to iluvut Yerusalem, le izala iyoon muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Leso nigham watooŋrau to deŋia ila matam. Pale niyou makau tinim, ve nighur di tizala artaal tiom, ve yab ighan suvun di. Leso ughita ve lolom poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Yom ŋgeu ariaŋam, pughu vena to aliŋam izaza, ve upakur ghom pa ŋgar samia to ugham pa Maaron tamtoghon toni? Poia, ughami lak! Eemoghon ndag to naol ne, Maaron lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. Ŋgar toni tonowen irau isob ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Yom ŋgeu to kaarom! Moghon moghon, ukalkaal ataam pa uwaghamun tamtoghon. Ve saveeŋ isob to ivotvot ila avom, nene inimale gharghar to mata kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ŋgar poia ve saveeŋ onoon, yom lolom pani maau. Ve ŋgar samia ve saveeŋ kaarom, ghoro lolom pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Yom avom kaarom. Ve saveeŋ samsamia naol to iwaghamun tamtoghon, lolom pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Tovenen Maaron pale iwaghamun ghom le usami kat. Irau umundig muul maau. Pale ilooŋ ila ruum tiom lolo, ve isasaar ghom uvot ula pumuri, ghoro ipas ghom ila yes to matadi iyaryaar ne lolodi, ve ipiyaav ghom uzila ndug to mateeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ŋgar to pale Maaron igham payom, ighaze ndiran deŋiadi tighita, nene pale timatughez. Ghoro tiŋiŋ payom, ve tisaav tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Aghita. Nene ŋgeu to lolo pa igham ulaaŋ ila to Maaron ve iyooŋ ila toni maau. Ye mbaliiŋ tau kat. Ve inumeer mbeb toni naol tonowen toman ŋgar toni samia ighaze pale ighami ineep pooi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Eemoghon you nanimale ai oliv to iyoon ilooŋ ila sirsiir to Rumai to Maaron. Pale nayoon tuŋia, ve naneep mala izi taan, Pasa, you nanumeer Maaron naghaze ye pale lolo ineep tuŋia ila to tamtoghon toni, ve iuul di itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Maaron, you lolog poia kat pa ŋgar to yom ughami. Tovenen you pale napait ghom pa poia tiom itaghoni taghoni gha ila. Ve napait izam ila yes to lolodi ineep tuŋia ilat tiom ne matadi, ve nasavia ghom padi naghaze: Yom poiam le poiam kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Yes kankanooŋa to lolodi imaagh pa Maaron, tigham ŋgar ila lolodi tighaze: “Maaron eta ineep maau.” Ndiran tovene, Maaron lolo padi maau kat. Pasa, ŋgar todi isami wa. Tauto tighamgham ŋgar samsamia naol. Eta igham ŋgar poia maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Maaron ineep izi sambam, ve mata izizi pa tamtoghon to taan. Ye ighaze ighita: Todi eta pale ighilaala, ma maau? Ve eta izuaria tau leso iwatag Maaron? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Tisob tipul muridi pani, ve tisami wa. Eta igham ŋgar poia maau. Maau le maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Tovenen Maaron igham ŋgar naol ighaze: “Yes to tinoknok ghamuuŋ ŋgar samsamia, ledi ghilalooŋ, ma maau? Ŋeez o ŋgar todi ivot? Sawa isob, yes titombaan tamtoghon tiou, ve tipasob mbeb todi le isob kat, tinimale yes to tighan aniiŋ popoia le tipasobi. Matadi iŋgal ghou ve tisuŋ payou maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ndiran tovene irau tipatum di. Pasa muri, matughezaaŋ tiina kat pale igham di. Muuŋ, timatughez tovene maau. Eemoghon tipamundigin malmal payam, tauto Maaron pale irab di timatmaat, ve tuadi tizi tiwaghengheen izi taan. Yam pale alib padi, ve mayadi. Pasa, Maaron ighur muri padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Oyai, Maaron to ineep izi ndug Zion, iuul yes Israela, ve ipas di tivot pa pataŋani todi, ghoro poia! Ighaze Maaron iuul tamtoghon toni ve tineep poia muul, nene pale tinidi iza. Onoon kat, Yakop papaghu toni pale lolodi poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","O Maaron, yom izam tiina pa tapirim ve poia tiom. Uvool tiou ve upas ghou navot pa pataŋani tiou tonene! Upatooŋ tapirim pa koiagŋa, ve ugham mulin ghou ila nimadi. Leso upaghazoŋan ghou ila tamtoghon matadi ughaze you nagham sosor eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Maaron, ughur taliŋam pa suŋuuŋ tiou. Ulooŋ aliŋag tonene ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Pasa, ndiran samsamia to ndug mala tinim tipamundigin malmal payou. Yes to tizuaria di tighaze tirab ghou namaat, tamtoghon timatughez padi. Pasa, lolodi isamin tamtoghon rita maau. Yes tipapait taudi, ve matadi iŋgal Maaron rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Eemoghon Maaron, ye Ulaaŋa tiou. You naneep ila Tiina tiou nima, tauto aazne naneep matag iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ŋgar samia to koiagŋa tigham payou ne, upamuula imuul ila pa taudi. Upasob di le tisob kat itaghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Yoova, yom poiam kat! Tovenen lolog poia payom, ve naghaze nagham watooŋrau pa napait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Pasa, yom uul ghou, ve upas ghou navot pa pataŋani tiou tisob. Yom utatan koiagŋa ila matag, ve nalib padi wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","O Maaron, ughur taliŋam pa suŋuuŋ tiou. You nataŋ roran ghom: Lolom isamin ghou ve uul ghou. Uŋgooz matam payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ulooŋ suŋuuŋ tiou tonene, ve uul ghou. Pasa, pataŋani naol tigham ghou le isooŋ katin ghou. Tauto lolog imbumbu, ve tapirig isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Koiagŋa aliŋadi izaza, ve tigham saveeŋ matughezaaŋ payou. Ndiran samsamia tonowen tigham pataŋani tiina payou tighaze titatan ghou. Atedi yabyab payou, ve tighur koi payou kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Paam namaat tonene. Tovenen ateg imbumbu ve namatughez kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Matughezaaŋ tiina igham ghou le tinig irur, ve wadedeŋag izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Tovenen nakausim naghaze: “Oyai, leg bageg nanimale man mbaluuz, ghoro poia! Leso naroov naghau nala ndug mala, ve ateg izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Pale nala nala le nala ndug balim to mala kat we, ve nakaal inag poia eta, leso naneep pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Onoon kat, leg bageg nanimale man, tone rikia moghon naghau nala, ve nakaal inag eta to yoŋgaaŋ. Leso naneep tonowe, ve nasaŋan le pataŋani tonene isob. Pasa, nene inimale naneep ila uman ve yaghur tiina lolo.” ");
INSERT INTO tuc_o_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Tiina tiou, ughamun ndiran samsamia tonowen saveeŋ todi, leso ighur anoŋa sob. Ve upasob di ve tilaledi. Pasa, you naghita ŋgar to ghamuuŋ malmal ve zoraaŋ saveeŋ ivon kat ila ndug tiina tonene lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Mboŋ ve ndag, ŋgar tovene ivotvot ila ndug lolo. Ndug tonene ivon kat pa ŋgar samsamia naol ve pataŋani. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Onoon kat, tamtoghon tiwaghamun nepooŋ to ndug le isami kat. Tamtoghon to sualen, ighaze tilup di izi maran pa tigharaat saveeŋ, ma tiraukol, nene moghon moghon titatan nditadi ve titombaan di, leso tiyub mbeb todi. Ŋgar todi tonowen, tipuli rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Inimale koiag eta iveleg ghou, tone poia. Pataŋani tovene, you irau nambaada. Ve inimale tamtoghon ite paam to ighur koi payou ne, mata izi payou, tone poia. Pasa, tamtoghon tovene, you irau nayooŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Eemoghon maau. Yom to muuŋ naghita ghom naghaze ituru ŋgar toit ee moghon. Ve naghaze pa yom ŋgeu tiou, ve itag ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Ve tinig imot ilat tiom, ve naghita ituru lupuuŋ toit poia. Ve muuŋ, itiŋa ival tiina taluplup ghiit pa suŋuuŋ ila Maaron rumai toni lolo. Eemoghon aazne, yom uzi ve unum koiag. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Maaron, koiagŋa lolodi ve ruum todi tivon pa ŋgar samsamia naol. Ukarmotin di pa mateeŋ, ghoro poia. Naghaze tineep matadi iyaryaar, ve tizila ndug to mateeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Tovenen you pale napoi Maaron pa iuul ghou. You nawatag: Yoova pale igham mulin ghou pa pataŋani tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Sawa isob, you nataŋ rorani pa mboŋmaagh, ndag maatu, ve rabrab, ve navotia pataŋani tiou pani. Ve ye pale ilooŋ aliŋag, ve iuul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Onoon, koiagŋa katindi tilup di tighaze tigham malmal payou, ve titatan ghou. Eemoghon Maaron pale ipas ghou ila nimadi, ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Pale ilooŋ suŋuuŋ tiou, ve itatan di. Pasa, muuŋ kat ve inim, ye inepneep ila ina to ghamuuŋ pooz. Ve itortoor ŋgar toni maau. Tovenen yes to timatughez pani maau, ve ŋgar todi iyaryaaŋ tighaze tizoor aliŋa, ye pale itatan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Itag ite to muuŋ yeru niluplup ghei, ighita saveeŋ mbuaaŋ toni inimale mbeb sorok. Tauto ireu saveeŋ toni, ve igham malmal pa ndita to muuŋ yesŋa lupuuŋ todi ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Saveeŋ toni, nene poia ve ŋgoreeŋa kat. Eemoghon ila lolo, ye ighaze igham malmal. Talooŋ saveeŋ toni, ve taghaze pa ye ighaze igham lolood poia. Eemoghon maau. Saveeŋ to ivot ila avo, iŋgal tamtoghon inimale buza. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Sa mbeb ma pataŋani to ighaze ivot payom, ughuri ila Yoova nima. Ye pale ipariaaŋ ghom, ve ikis ghom uneep pooi. Pasa, mata iŋgalŋgal ndiran deŋiadi. Irau ipul di titap pa tovaaŋ eta ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Eemoghon ndiran kaaromŋa ve yes to tirab tamtoghon timatmaat, Maaron, yom pale uŋgor sawa todi inim tuku, ve upiyaav di tizila ndug to mateeŋa. Ve you, ghoro nanumeer ghom naghaze pale uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","O Maaron, you mbesooŋa tiom. Lolom isamin ghou, ve uul ghou lak! Pasa, koiagŋa tinanaan ghou ne. Mboŋ ve ndag, tamtoghon tizuaria di tighaze le titatan ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Sawa isob, yes to tiŋgal saveeŋ payou ne, tighamgham lilin ghou tighaze tirab ghou namaat. Yes to tighamgham malmal payou ne, ival kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Maaron, yom Maaron Tiina To Ulib Pa Ndimaronŋa Tisob. Sawa to matughezaaŋ tiina igham ghou, you pale nanumeer ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","You napait Maaron pa saveeŋ mbuaaŋ toni, ve naghur ila toni ariaŋa. Irau namatughez maau. Pasa, tamtoghon to taan tapiridi ineep sine, leso tiwaghamun ghou? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Saveeŋ tiou, nene poia. Eemoghon moghon moghon, to mboŋmaagh ila le rabrab izi, koiagŋa titortoor aliŋag muul inim saveeŋ samia. Ve tikalkaal ataam tighaze le tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Tilup di, ve tindaŋgat ghou pa laghooŋ tiou, ve tisasaŋan tighaze tirab ghou namaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Maaron, pughu vena to upul ndiran samsamia tonowen tineep? Uyat ŋgar todi tonowen lak! Upatooŋ mbalmbali tiom padi, ve utatan di. Leso tapiridi isob kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Yom uwatag: You nambaad pataŋani naol ve nataŋtaŋ. Eemoghon pataŋani tiou tisob, yom umbood di ila rau tiom wa. Ve naghaze matag suru paam, uwato ila ya paatu tiom, ve ughuri ineep. Leso matam iŋgalŋgal ŋgar ve pataŋani to ivotvot payou ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Maaron, you nawatag: Yom uvolvool tiou. Tovenen sawa to ighaze nataŋ roran ghom pa ulaaŋ, yom pale uul ghou, ve ugham koiagŋa titoor di, ve tighau muul tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","11","Tovenen you napait Maaron pa saveeŋ mbuaaŋ toni, ve naghur ila toni ariaŋa. Irau namatughez maau. Pasa, tamtoghon to taan tapiridi ineep sine, leso tiwaghamun ghou? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Maaron, you naghaze nagham watooŋrau payom itaghon saveeŋ mbuaaŋ tiou. Pasa, yom uul ghou, ve ugham lolog poia kat. Tovenen you pale nagham watooŋrau, ve napait ghom pa poia tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Pasa, yom ugham mulin ghou pa mateeŋ, ve uul ghou le nalib pa koiagŋa. Tauto yes irau tigham ghou natap maau. Yom ugham tovene, leso naghilaal naghaze yom uneep toman ghou pa nepooŋ ve laghooŋ tiou, ve ghazooŋa tiom isul ghou ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","O Maaron, you mbesooŋa tiom. Lolom isamin ghou, ve uul ghou lak! You naŋarua ghom naghaze nayooŋ ilat tiom. Upoon ghou inimale tatareek ipakud ndinatu ila bage samba, le irau pataŋani tonene isob. Pasa aazne, nepooŋ tiou, nene inimale naneep ila uman ve yaghur tiina lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","You nataŋ roran Maaron Tiina To Ilib Pa Ndimaronŋa Tisob, naghaze iuul ghou. Pasa, ŋgar toni ighurghur anoŋa. Sa ŋgar to ye ighaze ivot payou, nene pale ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Pale ineep izi sambam, ve igham ulaaŋ payou, ve igham mulin ghou. Pale iyoon payou, ve itatan koiagŋa to tinanaan ghou ne. Pasa, lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. Ve sawa isob, ye itataghon saveeŋ mbuaaŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Koiagŋa tiluvut ghou wa. Yes tinimale laion to luadi isami pa ghaniiŋ tamtoghon. Livodi mata kat inimale pane ndinatu ve iiz. Ve yamadi paam, mata kat inimale buza to malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Maaron, ugham mbeb eta ivot ila sambam samba inim ghilalooŋ pa tamtoghon. Leso tighita ve tighilaal ghom tighaze izam tiina kat. Ve upatooŋ tapirim ve poia tiom le irau taan isob paam! ");
INSERT INTO tuc_o_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Pataŋani tonene itatan ghou kat. Pasa, koiagŋa tiraar malum payou tighaze tisavag ghou. Ve titai saambu ila ataam tiou, leso natap nazila. Eemoghon maau. Taudi titap tizila. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Maaron, lolog ru payom maau. Lolog ineep tuŋia ilat tiom. Tovenen you pale nambou, ve narab gita pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Lolog ighur naghaze ndugitun, ghoro namundig ve nagharaat taug, ve napambar ambam tiou, ve narab gita ila ila le ndag pusukia iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Tiina tiou, you pale napait ghom pa poia tiom ila tamtoghon to ndug ndug matadi. Pale yeiŋa tamtoghon to ndug tisob nilup ghei pa suŋuuŋ, ve nait mbouŋ pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","O Yoova, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ŋgar tiom tonanan, nene tiina le tiina kat. Izala izala le ikis sambam. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tiom tovene paam. Izala le ikis tata. ");
INSERT INTO tuc_o_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Maaron, ugham mbeb eta ivot ila sambam paroŋania inim ghilalooŋ pa tamtoghon. Leso tighita, ve tipait izam izala le izala kat. Ve upatooŋ tapirim ve poia tiom irau taan isob! ");
INSERT INTO tuc_o_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Yam daba, alooŋ. Ŋgar to yam asasavia ne, nene deŋia? Ve ighaze aŋgabiiz saveeŋ to tamtoghon ve aghur atia padi, yam ataghon ŋgar deŋia? Maau kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Lolomim iyaryaaŋ pa ŋgar samia moghon, ve awaghamun tamtoghon irau ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Ndiran samsamia, moghon moghon tiyel pa ataam poia. Sawa to nditinandi tipoop di ve inim, avodi kaarom, ve tisosor pa ataam to Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","5","Saveeŋ to ivotvot ila avodi, nene iwaghamun tamtoghon inimale moot samia. Ighaze tatoova pa tapasaluŋgan di, nene irau tilooŋ ghiit maau. Pasa, tipoon taliŋadi. Yes tinimale moot to malmal to taliŋadi saambu maau. Tovenen ighaze moot tonowen tama ivib sab, leso ighami lolo poia ve imogheer, ye irau ilooŋ sab aliŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Maaron, ndiran tonowen tinimale laion papaghu to matadi malmal. Arab polpolin livodi, ve apas di! Leso tiwaghamun tamtoghon sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Upasob di ve tilaledi tinimale ya to ireer ila le imaak. Uvazag di ila aghem samba inimale tamtoghon tivazag kikiliiŋ le igorgor. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Ugham di tinim demdem to timaat ve timbuuz. Naghaze tinimale ndipain to timazug ila nditinandi apodi. Irau tineep ve tighita ndag maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Maaron pale rikia moghon iŋgor sawa todi inim tuku, inimale mbeb gorgori to yab ighani rikia. Mbalmbali toni pale iza todi, ve ipasob di tilaledi tinimale buzbuz to yaghur iviviira ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Ighaze tamtoghon deŋiadi tighita Maaron ighur atia pa ndiran samsamia ve iyat ŋgar todi, nene pale lolodi poia. Ndiran samsamia siŋ todi pale ireer izi ve ipot izala taan pogho, ve tamtoghon deŋiadi tilaagh ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Ghoro tamtoghon tisaav tighaze: “Onoon kat, Maaron inepneep, ve iŋgagabiiz tamtoghon to taan, ve ighurghur atia padi. Ve yes to titaghon ŋgar deŋia, ye ighamgham ledi atia popoia.” ");
INSERT INTO tuc_o_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Maaron tiou, uul ghou ve upas ghou ila koiagŋa nimadi. Ughur ghou naza sala, ve matam payou. Leso koiagŋa tiwaghamun ghou sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Ugham mulin ghou, ve upas ghou ila ndiran samsamia tonene nimadi. Pasa, yes ndiran to malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","4","Maaron, ughita! Yes to tapiridi tintina, tilup di ve tigham lilin ghou tighaze tirab ghou namaat. Yes lolodi isamin tamtoghon maau. Ve you leg sosor eta maau. Nazoor saveeŋ eta maau, ve nagham ŋgar samia eta maau. Eemoghon aazne, tigharaat taudi tighaze tigham malmal payou. Maaron, umundig uvool tiou, ve ughita di! ");
INSERT INTO tuc_o_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yoova, yom Maaron ariaŋam kat, ve uŋgin mbeb tisob. Yom moghon to Maaron to Israel. Yes ndug ndug to aazne tighur koi payou ne, muuŋ lupuuŋ tiei ee moghon. Ve aazne, tighur koi payou. Umundig ve ughur atia padi. Ughurghur di malep! Pasa, yes ndiran samsamiadi, ve avodi kaarom. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Rabrab to naol ne, koiagŋa tinimnim, ve tilaghlaagh ila ndug lolo. Tiŋaaŋ mareer, ve lolodi ŋurŋuria tinimale ŋgavuun to ighaze ighan tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Ughita. Saveeŋ samsamia moghon to ivotvot ila avodi. Yamadi, nene inimale buza mata. Ve tisavsaav tighaze: “Sei pale ilooŋ ghei?” ");
INSERT INTO tuc_o_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Eemoghon Yoova, yom ughita di, ve uŋiŋ padi. Yes ndug ndug to tiwatag ghom maau, yom uveleg di, ve ughaze tirau sa? ");
INSERT INTO tuc_o_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Maaron, you naghamgham tapirig ilat tiom. Tovenen naghur matag payom, ve nasasaŋan moghon. Koiagŋa irau tigham mbeb eta payou maau. Pasa, yom upoon ghou padi unumale raŋ to izala kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Maaron tiou, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Yom pale unum toman ghou, ve utatan koiagŋa, ve naghita pa taug matag. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Eemoghon urab di timaat rikia malep. Upul di tineep toman pataŋani ris o. Leso tamtoghon tiou matadi kisin ŋgar tiom to ughurghur atia pa ndiran samsamiadi. Maaron, yom unum sigeu payei. Utatan di pa tapirim le tiwaghamgham, ve ureu mbirisan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Pasa, saveeŋ to ivotvot ila avodi, poia maau. Moghon moghon avodi isosor. Yes tighamgham kaarom pa tamtoghon, ve tipipiyaav saveeŋ samsamia naol padi. Eemoghon ŋgar todi to tipapait taudi ve tiveleg ghom, nene pale inim liis padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Tovenen upatooŋ mbalmbali tiom padi, ve uwaghamun di. Maaron, upasob di le tisob kat. Leso tamtoghon irau taan dige to naol ne, tighilaal ghom tighaze yom ughamgham pooz pa yei to Yakop papaghu toni ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Rabrab to naol ne, koiagŋa tinimnim, ve tilaghlaagh ila ndug lolo. Tiŋaaŋ mareer, ve lolodi ŋurŋuria tinimale ŋgavuun to ighaze ighan tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Yes tinimale ŋgavuun to tilaghlaagh ve tikalkaal aniiŋ. Ve ighaze tighan iraua maau, nene pale tinoknok taŋiiz. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Eemoghon you pale nambou, ve napait izam pa tapirim tiina. Mboŋmaagh to naol ne, you pale nambou ve napait ghom pa ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Pasa, yom uponpoon ghou unumale raŋ to izala kat. Ighaze pataŋani ivot payou, yom pale unum didiiŋ ariaŋa payou, leso nayooŋ ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Maaron, you naghamgham tapirig ilat tiom. Tovenen nambou ve napait izam. Maaron tiou, yom uponpoon ghou unumale raŋ to izala kat. Ve lolom ineep tiou, ve uluul ghou irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Maaron, atem yabyab payei, ve upul murim payei. Tauto koiamai tireu mbirisan didiiŋ ariaŋa to iluvut ndug tiei, ve tilooŋ tinim. Tiina tiei, matam imuul inim payei, ve ugham nepooŋ tiei poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ndug tiei isami wa. Malmal to ivot ne, nene inimale ugham taan tiei irur le ivavaal, ve avo ikaak. Tovenen nitaŋ roran ghom nighaze ugharaat mulin ndug tiei. Pa vene, nisami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Yei tamtoghon tiom. Eemoghon ugham pataŋani tiina kat ivot payei. Nighita sawa tonene samia kat. Mbalmbali tiom iza tiei, le igham ghei niwaghamgham inimale upaghun ghei pa ya ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Sawa to pataŋani tonene ighaze ivot payei, yom upatooŋ pilak tiom pa yei to nimatughez payom ve nitaghon ŋgar tiom. Leso niŋarua ghom nilat, ve upoon ghei pa koiamai. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Maaron, yei niwatag: Lolom ineep tiei kat. Ulooŋ suŋuuŋ tiei tonene, ve upatooŋ tapirim ve uul ghei. Ugham mulin ghei pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Muuŋ, Maaron ineep izi ndug toni patabuaŋ, ve isaav ighaze: “You naparab le nalib pa koiagŋa wa. Tauto tinig iza, ve navalag taan Sekem ve taan raapa to Sukot, ve nareii irau tamtoghon tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Taan suruvu to Gileat, ve taan to yes Manase paam, nene you tiou. Rumai to yes Epraima tinimale hat ariaŋa to napoon dabag pa malmal. Ve rumai to yes Yuda tinimale titi to nakisi inim ghilalooŋ pa pooz tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Taan suruvu to yes Moapa, nene inimale oon tiou to ririwaaŋ. Ve taan suruvu to yes Edoma, nene ndug to napiyaav duduuŋa to agheg izala. Ve yes Pilistia, you naparab toman di le nalib padi. Tauto tinig iza ve nalool.” ");
INSERT INTO tuc_o_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Sei irau igham ghou nalib pa koiagŋa ve nalooŋ nala ndug todi to didiiŋ ariaŋa iluvuti we? Sei pale imuuŋ payou, ve ighereb ghou nala navot taan suruvu to yes Edoma? Ite paam maau. Yom moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Eemoghon Maaron, aazne yom upul murim payei, ve unum toman ndaaba tiei muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Maaron, uul ghei nilib pa koiamai. Pasa ulaaŋ to nighamghami ila to tamtoghon, nene iraua maau. Nene mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Eemoghon ighaze Maaron inim toman ghei, nene pale nilib padi. Ye irau itatan di le tapiridi isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","O Maaron, ulooŋ taŋiiz tiou. Ughur taliŋam pa suŋuuŋ tiou tonene, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Pasa aazne, you naneep mala kat pa ndug tiou, ve matughezaaŋ tiina igham ghou le tapirig isob. Tovenen napoi ghom naghaze uul ghou. Ugham ghou naneep izala raŋ to izala kat. Leso mbeb eta iwaghamun ghou sob, ve naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Pasa, yom to unum inag to yoŋgaaŋ. Yom uponpoon ghou pa koiagŋa unumale ruum ariaŋa to daba mala. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","You naŋazuuv ghom naghaze le naneep ila mbeez tiom lolo, ve nanim loom payom irau sawa isob. You naghaze nalat tiom ve upoon ghou inimale tatareek ipakud ndinatu ila bage samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Maaron, saveeŋ to nambua toman ghom, yom ulooŋa wa. Yes to timatughez payom ve titaghon ŋgar tiom, yom ughamgham mbeb popoiadi naol padi. Mbeb tonowen, yom ugham di payou paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","O Maaron, useeŋ sawa to kinik tiei. Nighaze ye ineep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Nighaze ye ineep ila ina to ghamuuŋ pooz ila naghom, ve igham pooz irau sawa isob. Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ve sawa isob, utataghon saveeŋ mbuaaŋ tiom. Tovenen matam pa kinik tiei, ve uŋgini ineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Ighaze ugham tovene, you pale nambou ve napait izam irau sawa isob. Ve ndag to naol ne, you pale nagham uraat pa saveeŋ to nambua toman ghom, leso anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","You lolog imbumbu maau. Ateg izi, ve nasaŋan Maaron pa iuul ghou. Pasa, you nawatag: Ye moghon to irau igham mulin ghou pa pataŋani tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Onoon kat, ye moghon, to Volaaŋa tiou ariaŋa. Ye iponpoon ghou inimale raŋ to izala kat, ve inim ruum ariaŋa pa nayooŋ ila lolo. Tovenen mbeb eta irau iwaghamun ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Yam to aghaze awaghamun ghou ne, ŋeez o apul ŋgar tiam samia tonanan? Yam asob azuaria gham pa aghaze arab ghou pasa? Aghita. Tapirig isob wa. You nanimale sirsiir muŋgina to pughu imbuuz ve ighaze imatit. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","You leg izag. Tauto ireu lolomim, ve azuaria gham aghaze atatan ghou nazi. Yam ndiran to kaarom kat! Agham kaarom, ghoro lolomim poia. Yam asavsaav ila avomim uli aghaze Maaron ighur poia toni iza tiou. Ve lolomim, aghaze Maaron iwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Eemoghon you lolog imbumbu maau. Ateg izi, ve nasaŋan Maaron pa iuul ghou. You naghur matag pani moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Onoon kat, ye moghon, to Volaaŋa tiou. Ye iponpoon ghou pa koiagŋa inimale raŋ to izala kat, ve inim ruum ariaŋa pa nayooŋ ila lolo. Tovenen mbeb eta irau itok ghou ve natap ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","You nanumeer Maaron naghaze pale igham mulin ghou pa pataŋani tiou, ve igham izag ivot inim tiina. Irau namatughez maau. Pasa, ye to inim inag to yoŋgaaŋ, ve iponpoon ghou inimale raŋ ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Yam tamtoghon to Maaron, anumeera irau sawa isob. Avotia lolomim pani, ve asavia pataŋani tiam tisob tila toni. Pasa, ye to inim inaad to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Tamtoghon tisob tinim mbeb sorok. Yes to ledi izadi maau, ve yes to izadi tintina ne paam. Tineep rismoghon ve tisob, tinimale yaghuraad to ivotvot ila avood ne. Irau tanumeer di maau. Ighaze taŋgabiiz poian di, pale tighita di tirau mbeb eta maau. Pasa, yes toman uraat ve mbeb todi rikia moghon tilaledi, tinimale yaghuraad to ivotvot ila avood. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Tovenen ŋgar to ghamuuŋ malmal leso tayou leed mbeb to tamtoghon, anumeera malep. Ve ŋgar to yubuuŋ paam, aghur matamim pani pa igham gham aneep pooi ne malep. Ve ighaze yaam ve mbaliiŋ tiam tivot tinim naol, aghur lolomim pani malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Sawa naol, you nalooŋ Maaron isaav ighaze ye moghon to le tapiri tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Tiina tiei, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di irau sawa isob. Ve yom ughur atia pa tamtoghon tisob itaghon ŋgar todi todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","O Maaron, yom Maaron tiou. Mboŋmaagh kat, suŋuuŋ tiou iŋarua ghom naghaze unum uneep digeg. You nakausim payom naghaze nalat nagharau ghom, ghoro poia. Pasa aazne, naneep saguan payom. You lolog payom kat, nanimale ŋgeu to ilaghlaagh ila ndug to le ya maau, ve murun matini. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Pasa, matag iŋgal imuul ila pa sawa to naghita ghom ila rumai tiom patabuaŋ lolo, ve naghita katin tapirim toman ŋgurubam. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Nepooŋag to taan, nene poia. Eemoghon naghita naghaze ŋgar to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, nene mbeb to poia le poia kat. Tovenen you pale nalool, ve napait izam ve napakur ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Pale napait izam pa poia tiom ila ila le nepooŋ tiou to taan isob. Pale nakaak nimag iza, ve nasuŋ payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Pasa, yom ugham lolog poia kat inimale naneep ila ghanghaniiŋ, ve naghan aniiŋ to poia ve ŋgoreeŋa kat le isooŋ katin ghou. Tauto lolog poia kat, ve nambou pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Sawa to nazi nagheen, matag iŋgalŋgal ghom. Naghamgham ŋgar payom pa mboŋ ila ila le ndugizau. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Pasa, yom to Ulaaŋa tiou. You naneep pooi ila nimam samba inimale tatareek ndinatu tiyooŋ ila tinandi bage samba. Tauto tinig iza, ve namboumbou. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","You lolog ineep tuŋia ilat tiom, ve nimam waan ipapalot ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Yes to tizuaria di tighaze tirab ghou namaat, taudi pale timaat ve tizila ndug to mateeŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Pale buza ighan di timatmaat, ve ŋgavuun sagsag tighan patudi. ");
INSERT INTO tuc_o_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Eemoghon kinik tiei, Maaron pale iuuli, ve ighami lolo poia kat. Ve tamtoghon tisob to tiwaat Maaron iza pa tipariaaŋ saveeŋ mbuaaŋ todi ve titaghoni, yes paam pale tipait Maaron iza pa tapiri ve poia toni. Eemoghon yes to avodi kaarom, Maaron pale ipoon avodi. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","O Maaron, you nataŋ roran ghom naghaze uul ghou. Ulooŋ taŋiiz tiou tonene, ve upoon ghou pa koiagŋa. Pasa, yes tigham ghou namatughez kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Ndiran samsamia tilup di, ve tikalkaal ataam pa tiwaghamun ghou. Upaghau ghou padi: Pa vene, tiwaghamun ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Saveeŋ to tipiyaava payou ne, poia maau. Yamadi, nene inimale buza to tipoti le mata kat. Saveeŋ to tiŋgalŋgali payou ne, inimale pane natu to tipeli pa mbeb lili. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Yes tiyoŋyooŋ, ve tisasaŋan yes to ledi sosor maau. Ve sawa to tila tivot, ghoro rikia ve tivaneg di. Pasa, yes timatughez pa mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Yes tipapazaagh taudi pa ghamuuŋ ŋgar samia. Ve tiwasavon di pa sa ndug to pale tiŋgooz liis todi pani, leso tisavag tamtoghon. Ve tisaav tighaze: “Ŋgar to taghaze taghami, sei pale iwatagi?” ");
INSERT INTO tuc_o_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Yes tikaal ataam pa ŋgar samia to tighaze tighami, ve tipait taudi tighaze: “Yei niraua kat pa ŋgar. Tovenen ŋgar to nighaze nighami, nene pale ighur.” Oyai, iit tamtoghon, taŋgooz ŋgar samsamia naol ila lolood! ");
INSERT INTO tuc_o_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Eemoghon Maaron pale ivaneg di pa pane natu toni. Pale rikia moghon ve iwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Saveeŋ samsamia to ivotvot ila avodi, nene pale imuul pa taudi ve iwaghamun di. Ŋgar to Maaron ighaze igham padi, tamtoghon pale tighita, ve tililiit dabadi ve tiveleg di. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ŋgar to Maaron igham padi, nene pale igham tamtoghon tisob timatughez, ve tigham ŋgar tiina pani, ve tisavia varu. ");
INSERT INTO tuc_o_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Tovenen ndiran deŋiadi pale lolodi poia pa Yoova, ve tiyooŋ ila toni. Yes to ŋgar deŋia ineep tuŋia ila lolodi, pale tinidi iza, ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Maaron, yei pale nilat ndug Zion ve nipait ghom, ve nigham uraat pa saveeŋ to nimbua toman ghom. Ighaze nitaghon ŋgar tovene, nene deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Pasa, yom uloŋlooŋ suŋuuŋ to tamtoghon ve uluul di. Tamtoghon tisob to taan pale tilat tilup di ila naghom, ve tipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Ighaze ŋgar to zoraaŋ saveeŋ ve ŋgar samia ikau ghei, ve itatan ghei kat, yom ureu sosor tiei. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Yes to yom usia di tinim lem, ve ugham di tilat tineep tigharau ghom ila sirsiir to rumai tiom lolo, nene pale lolodi poia kat, ve poia tiom izaza todi. Yei nighaze le nineep ila sirsiir to rumai tiom patabuaŋ lolo. Pasa, rumai tiom, nene ivon pa mbeb popoiadi naol. Tovenen sawa to nineep tonowe, lolomai poia kat, ve niyamaana nighaze mbeb to nizuaria ghei pani, tauto nighami wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","O Maaron, yom Volaaŋa tiei. Yom uloŋlooŋ suŋuuŋ tiei, ve ughamgham uraat gharatooŋadi tintina. Tamtoghon tighita di le timatughez. Ugham mulin ghei itaghon ŋgar tiom deŋia. Tamtoghon to tineep tirau taan tiina, ve yes to tineep tirau mutu paam, tisob tinumeer ghom ve tighur matadi payom pa ulaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Tapirim iluvut ghom inimale nonogiiŋa tiom. Ila taum tapirim, ugham lolooz tisob tivot, ve tiyoon tuŋia ila inadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ighaze te isami, ve dibom ipolpol toman avolutu tiina, yom irau ughami ate izi. Ve tamtoghon tovene paam. Ighaze tipamundigin malmal toman oroor tiina, yom irau upasob malmal todi, ve ugham di atedi izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Tamtoghon to tineep tirau taan dige to naol ne, tighita mbeb gharatooŋadi tintina to yom ughamgham di, le matughezaaŋ tiina igham di. Yes to tineep ila pa ndag iza, ve yes to tineep ila pa ndag izila ne paam, yom ugham di lolodi poia kat. Tovenen tilool ve tipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Yom to uŋgin taan, ve ugham uman izizi, leso taan imbees. Ve yom to ugham taan ŋgoreeŋa tiina ivotvot. Ya to Maaron, nene ivon ve irereer tovene. Irau imaak maau. Yom ugharaat taan itaghon taum ŋgar tiom. Leso aniiŋ katindi tivot pa tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Yom ugham uman izizi, leso avabuti imbees, ve aniiŋ anoŋa katindi tivot. Yom ututur taan le imbees kat. Ve poia tiom, tauto igham aniiŋ titub pooi tiza. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Yom poiam kat. Pasa, ndaman tonene, ugham aniiŋ tiina ivot ila uum tiei. Aniiŋ to titub ila uum tiei, nene tipambooda tinimale moghar to yes kinik. Ndug sine to ighaze yom ula pani, nene mbeb popoiadi katindi tivotvot. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Yom ugham kikiliiŋ popoia titub ila ndug balim, leso ŋgai ma mbeb naol to su tighan. Ve uum popoia to tineep izala lolooz, nene upambood di le paghunadi kat. Tauto lolooz to naol ne, lolodi poia, ve tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Ndug to kikiliiŋ ineep ila, makau ve sipsip tiraua le isob. Ve aniiŋ katindi titubtub ila taan raapa. Tovenen tamtoghon lolodi poia, ve timboumbou, tilolool, ve tipapait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Yam to aneep irau taan isob, lolomim poia pa Maaron, ve alool ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Ambou ve apait iza pa tapiri ve poia toni. Apaiti kat pasa, ye iza tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Asaav pa Maaron aghaze: “Uraat tintina to yom ughamgham di, tamtoghon tighita di le timatughez. Pasa, tapirim tiina le tiina kat. Tauto koiamŋa timatughez payom kat, ve tiput aghedi ila naghom, ve titaŋroran ghom tighaze lolom isamin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Ve yes moghon maau. Tamtoghon to tineep tirau taan isob, pale tiput aghedi payom, ve timbou ve tipait ghom. Lolodi poia ve timbou tapiridi pa tipait izam.” ");
INSERT INTO tuc_o_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Anim aghita uraat to Maaron ighami. Ye igham uraat tintina pa iuul tamtoghon. Uraat tonowen tipatooŋ katin tapiri. Tauto tamtoghon tighita di, le matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Muuŋ, ye ivalag te, le pida ila pa ŋas, pida ila pa waan, ve taan mamaasa ivot. Tauto nditimbuud tilaagh titaghoni, ve tivool tila pa dige ite. Tovenen iit lolood poia, ve tiniid iza pa ŋgar to ye igham padi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ye tapiri tiina kat. Pale igham pooz itaghoni taghoni gha ila. Moghon moghon, ye mata pa tamtoghon to ndug ndug, ve iŋgagabiiz di. Tovenen yam ndiran to zoraaŋ saveeŋ, azoor pooz toni muul malep. Aneep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Yam ndug ndug, apait Maaron tiei pa poia toni. Apaiti toman aliŋamim tiina, leso tamtoghon tilooŋ paitooŋ tiam. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Pasa, ye to ikiskis ghiit taneep mataad iyaryaar. Ve ye iŋginŋgin ghiit, tauto tatap maau, ve tayoon ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Onoon kat, Maaron, yom utoov ghei pa pataŋani pida, leso ugham ghei niŋgalaaŋ ila matam, ninimale silva to tighuri ila yab, leso ighan muun ighau, ve iŋgalaaŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Yom ugham ghei niŋgud malum tiom, ve ughur pataŋani tiina kat iza tiei. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Yom upul koiamai tilib payei, ve karis todi to malmal tilaan tizala poghomai. Pataŋani tiei, nene inimale nilaagh ila yab to ighanghan ne lolo, ve nilaagh ila yawaaŋa to tapiri tiina. Eemoghon yom upas ghei nivot pa pataŋani tiei, ve ugham ghei nineep pooi, ve niraua kat pa mbeb to naol. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Sawa to naneep ila pataŋani lolo, you nasaav payom naghaze: “Ighaze yom uul ghou, you pale nagham watooŋrau payom.” Tauto aazne, nataghon saveeŋ mbuaaŋ tiou tonenen, ve nanim rumai tiom naghaze naghur watooŋrau tiou izala artaal, leso yab ighan suvuni. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","You pale nagham mbeb tubudi, ve narab di tinim watooŋrau payom, ve yab ighan suvun di. Yab pale ighan sipsip tiou nditamoot, ve vuzidi popoia izalat. Ve tonene moghon maau. Pale nagham watooŋrau pa makau ve mekmek paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Yam to amatughez pa Maaron ve ataghon ŋgar toni, asob anim ve alooŋ saveeŋ tiou tonene. You naghaze navotia uraat tiina to ye igham payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","You nataŋ rorani pa ulaaŋ, ve avog ipaiti paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Sawa tonenen, inimale nakis ŋgar samia eta ineep ila lolog, tone Ŋgeu Tiina irau ilooŋ suŋuuŋ tiou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Eemoghon ye ighur taliŋa payou, ve ilooŋ suŋuuŋ tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Tauto napait Maaron pa poia toni. Pasa, ye iyasiil pa suŋuuŋ tiou maau, ve ipas poia toni payou maau. Ŋgar toni to lolo ineep tuŋia ila to tamtoghon toni ve iuluul di, tauto ipatooŋa payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Maaron igham poian ghiit ve ighur poia toni iza toit. Pale lolo poia pait, ve ghazooŋa toni isul ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Leso tamtoghon to tineep tirau taan tiwatag ŋgar toni, ve ndug ndug tighilaala tighaze ye moghon to irau igham mulin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Maaron, nighaze tamtoghon to ndug ndug tipakur ghom. Ndug tisob tipait izam, ghoro poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Nighaze tamtoghon to ndug ndug lolodi poia, ve tilool ve timbou pa tapait ghom. Pasa, yom uŋgagabiiz tamtoghon, ve ughagharaat pataŋani todi itaghon ŋgar deŋia. Ve yom to ughamgham pooz pa ndug ndug to tineep tirau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Maaron, nighaze tamtoghon to ndug ndug tipakur ghom. Ndug ndug tipait izam, ghoro poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Taitaiŋ poia ivot ila taan toit wa. Poia to Maaron toit pale ineep toman ghiit tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Onoon kat, Maaron ighur poia toni iza toit. Leso tamtoghon to tineep tirau taan dige to naol ne timatughez pani, ve titaghon ŋgar toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Maaron pale imundig ve ireu mbirisan koia. Yes to tighur koi pani, ye pale indiir di tighau pa mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Ye pale ipasob di le tisob kat, tinimale yab mbuasa to iza, ve yaghur iviviira ilale. Ighaze ndiran samsamia tineep ila Maaron nagho, ye pale iwaghamun di ve tilaledi tinimale bagil to ineep igharau yab dige, ve yab ilavaara, ve ireer ila, le isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Eemoghon ndiran deŋiadi, yes pale lolodi poia kat. Pale tineep ila Maaron nagho, ve tinidi iza ve tilool. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Ambou pa Maaron. Ambou ve apait iza, ve agharaat ataam pani. Ye Ŋgeu to ineep ila yaghur tae pogho, ve indaloova. Ye iza Yoova. Alup gham ila nagho, ve tinimim iza pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Maaron ineep ila ina patabuaŋ, ve iŋgin yes parooŋa inimale tamandi. Ye ivolvool to yes ndinaara, ve iyondyood padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Yes to eŋgendi tineep, Maaron pale igham tamtoghon pida tinim nditadi, leso yesŋa tilup di ve tineep. Ve yes to koiadi tighur di sorok tilooŋ tila ruum to yabyabuuŋ, ye ipaspas di tivot, ve imuuŋ padi, ve igheghereb di tila, leso tigham nepooŋ poia. Tovenen tinidi iza ve timbou, ve titaghoni gha tila. Eemoghon tamtoghon to tighamgham didiaaŋ, yes pale tineep sami ila taan to le ya maau ve imamaas kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","8","Maaron, sawa to yom umuuŋ pa tamtoghon tiom Israela, ve yamŋa alaagh izi ndug balim, yoŋgyoog itok taan, ve uman tiina itap tata ve izi. Maaron to Israel, ndug tiom to ghamuuŋ pooz, nene lolooz Sinai. Yom upatooŋ taum uvot ughazooŋ tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Maaron, taan to ugham pa tamtoghon tiom, ighaze ndag tiina ve imamaas, yom ughamgham uman tiina itaptap izi pa ipambees taan, leso mbeb titub muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Tamtoghon tiom tigham taan tonene inim ledi ndug to nepooŋ. Yei mbolaaŋa. Lemai mbeb eta maau. Eemoghon Maaron, yom poia pughu. Tauto ugham taan tonene payei, leso iuul ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Ŋgeu Tiina ivotia malmal varu ighaze ye ilib pa koia wa. Tovenen ndiliva ival tilaan tila, ve titemtem tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Ou alooŋ! Yes kinik toman ndaaba todi tila wa! Tisob tighau tila wa! Tauto ndaaba toit tiyou mbeb to koiaad tinim, ve tigham di pa ndiliva to tineep izi paanu we, leso tiwarein di. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Ndiliva tiei tipambood di pa silva ve gol, le paghunadi kat, tinimale man mbaluuz to tigharaata pa silva, ve tipaak gol milmilia ila bage. Pughu vena to yam pida ala pa malmal maau, ve aneep sorok izi paanu toman sipsip?” ");
INSERT INTO tuc_o_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Sawa to Maaron ariaŋa ireu mbirisan yes kinik, ye igham ais patu patu titaptap tizi ila lolooz Zalmon. Tauto inaan di tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Lolooz to ndug Basan, nene tiina ve daba izala kat, ve le mbuŋa mbuŋa ve kazimuŋa katindi. Daba izala kat, tauto ye le iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Lolooz to ndug Basan, yom lem mbuŋa mbuŋa naol. Pughu vena to ughita Maaron igham lolooz Zion inim ina to nepooŋ, ve ireu lolom? Tauto lolom isami pani ne? Onoon kat, ye pale ineep izi lolooz tonene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Ŋgeu Tiina ipul lolooz Sinai, ve ilaagh toman karis toni ndiŋndiŋ ndiŋndiŋ to malmal, le tila tivot izi ina patabuaŋ to Zion we. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Maaron, yom ughereb koiamŋa katindi to ulib padi ne, ve titaghon ghom, ve yamŋa azala lolooz tiom daba to sala we. Tamtoghon tigham lem mbeb popoiadi naol. Yes to tizorzoor aliŋam ne paam, tiput aghedi payom, ve tigham lem mbeb. Onoon kat, Maaron toit Yoova, moghon moghon ye inepneep izi lolooz toni tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Tapait Ŋgeu Tiina pa poia toni! Ndag to naol ne, ye iuluul ghiit pa badooŋ pataŋani toit. Maaron toit, ye Maaron to ighamgham mulin ghiit pa pataŋani toit. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Maaron toit, ye Maaron to ulaaŋ. Onoon kat, Maaron toit Yoova, ye ighamgham mulin ghiit. Tauto tamaat maau, ve taneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Maaron pale irab balagin koia dabadi. Tamtoghon to titaghon ataam samia, ve tighamgham sosor, ye pale irab mbirisan dabadi rubruuba, le tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Ŋgeu Tiina isaav ighaze: “Koiagŋa irau tighau maau. Ighaze tineep izi lolooz to ndug Basan, ma tineep sila kat izila mazovan, nene pale nagham di tisob timuul tinim. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Siŋidi pale ireer izi, le ipot inimale karoos ila taan pogho, leso awai ila. Ve ŋgavuun tiam pale tighuni le isooŋ di.” ");
INSERT INTO tuc_o_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Maaron, yom kinik tiou. Yom ulib pa koiamŋa wa. Tauto aazne, unum toman lolom poia, ve ulooŋ ula rumai tiom patabuaŋ ila ival tiina matadi. Yom umuuŋ, ve tamtoghon tiom titaghon ghom ve yamŋa alooŋ ala. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Yes to mbouŋ timuuŋ, ve ndiliva papaghu titoktok kakaap, ve titaghon di. Ve yes to tipambar ambam, ve yes to tivivib sab ve tavuur tilaagh muri. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Yam Israela to avot ila to Yakop, alup gham ila Maaron nagho ve apaiti pa poia toni. Yam asob apait Yoova iza! ");
INSERT INTO tuc_o_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Aghita. Rumai to Benyamin to ival maau ne, timuuŋ. Ghoro yes daba to Yuda toman tamtoghon todi titaghon di. Ve yes daba to Sebulun ve Naptali tilaagh muri. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Maaron, yom usaav ariaŋa pataghaaŋ ughaze yei Israela pale lemai tapirimai tiina, ve niyoon ariaŋa. Upatooŋ tapirim payei muul, inimale muuŋ upatooŋa payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Yes kinik to taan pale tinim tivot Yerusalem, ve tigham lem mbeb popoia ilooŋ ila rumai tiom patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Yes Isipa tinepneep ila vivib lolo to ya Nil dige we tinimale poghai. Ve yes kinik to ndug pida tilaghlaagh toman ndaaba todi tinimale makau ketooŋ to tiketkeet toman ndinatudi. Uyaan koiamai tonowen, leso tiput aghedi payom, ve tighur yaam silva todi inim lem pa tipakur ghom. Ndug ndug to lolodi pa ghamuuŋ malmal, ureu mbirisan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Kinik to yes Isipa pale imbaaŋ uraata toni tinim Yerusalem, leso yeiŋa nisavsaav pa lupuuŋ tiei. Ve tamtoghon to Etiopia paam, pale rikia tikaak nimadi iza, ve tisuŋ pa Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Yam kinik to taan toman tamtoghon tiam, ambou pa Maaron. Ambou pani ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Ye Ŋgeu to ineep izala yaghur tae pogho, ve indaloova ila tata to ineep muuŋ kat ve inim. Alooŋ. Ye isavsaav toman tapiri tiina. Aliŋa tiina inimale lalaav. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Tovenen yam avotia Maaron tapiri. Ye kinik tiina to ighamgham pooz pa iit Israela, ve ipatooŋ tapiri ivotvot ila tata. ");
INSERT INTO tuc_o_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Maaron to iit Israela, ye inepneep ila rumai toni patabuaŋ lolo, ve ipatooŋ tapiri. Tovenen tamtoghon tighita, ve timatughez. Ye ireirei tapiri pa tamtoghon toni, ve ipapalot di. Tapait Maaron pa poia toni! ");
INSERT INTO tuc_o_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","O Maaron, uul ghou lak! Pasa, ya ivon iza inim imuul luag, ve naghaze nandal tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Aazne, agheg putukia ila tiiŋ tiina. Leg taan ariaŋa eta pa nayoon izala ne maau. You naneep izila mazovan lolo. Nepooŋ tiou to aazne, nene inimale yawaaŋa ivot toman tapiri, ve izugua ghou nalaleg. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Maaron, you nasami wa. Taŋiiz tiou iŋaŋarua ghom le ŋgarsuag imar. You naghur matag payom naghaze yom pale uul ghou. Eemoghon maau. Tauto tapirig isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Tamtoghon to tighur koi payou ne, yes ival le ival kat. Irau nanin di maau. Tilib pa dabag raua. Koiagŋa to tighaze tiwaghamun ghou ne, tapiridi tintina, ve tiŋgal saveeŋ kaarom naol payou. You nayub mbeb todi eta maau. Eemoghon tisavsaav payou tighaze napamuul mbeb todi. Pale napamuul sa? ");
INSERT INTO tuc_o_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Maaron, yom uwatag: You nagham ŋgar samsamia to borouŋa. Sosor tiou to naol ne, eta iyooŋ payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Yoova, yom Maaron ariaŋam kat ve uŋgin mbeb tisob. Uul ghou lak! Pa vene, nagham mayaŋiiŋa pa yes to tinumeer ghom ve tighurghur matadi payom. Maaron to Israel, you nagham ŋgar tiina pa yes to tizuaria di tighaze le tiwatag katin ghom. Ighaze yom uul ghou pa pataŋani tiou tonene maau, nene pale mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","You nambesmbees payom, tauto tamtoghon tipiyaav saveeŋ velegiiŋ naol payou. Yes tigham ghou mayag, ve natudtud moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Taug siŋ tiou tighita ghou nanimale you ŋgeu sumbu. Ve toŋvetaz tiou kat to tinamai ee moghon, yes tipul muridi payou inimale you to ndug ite. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Ŋgar tiou iyaryaaŋ naghaze le nagharaat rumai tiom. Eemoghon ŋgar tonene, to aazne inim pughu pa nambaad pataŋani tiina inimale yab ighan ghou. Yes to tiveleg ghom, tiveleg ghou paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Sawa to natatan taug, ve naŋgun taug pa ghaniiŋ aniiŋ, tamtoghon matadi velegin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ve sawa to lolog ipataŋan, ve nagharaat taug maau, ve nandud uli to moŋiiŋ, yes tiŋiŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Yes to tiluplup di izi maran ate, tininin avodi payou. Ve yes ghunuuŋa timboumbou ghou inimale ŋalalaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Eemoghon suŋuuŋ tiou iŋaŋarua ghom moghon. Yoova, poia tiom, nene tiina kat. Lolom isamin ghou, ve uul ghou lak! Lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen sawa sine to ughita poia, ulooŋ suŋuuŋ tiou tonene, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Upas ghou navot pa pataŋani tiina tonene. Pa vene, agheg putukia ila tiiŋ le malmalig nazila. Ugham mulin ghou ila koiagŋa nimadi. Undae ghou naza pa mazovan lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Uul ghou. Pa vene, yawaaŋa izugua ghou, ve iweu ghou nalaleg. Ughita. Paam nandal nazila mazovan lolo. Aazne, you naneep izila saambu to yes mateeŋa, ve avo ighaze iŋgup tonene. Upas ghou navot. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yoova, yom poiam. Lolom ineep tuŋia ila to tamtoghon tiom ve uluul di irau sawa isob. Tovenen ulooŋ suŋuuŋ tiou tonene, ve uul ghou. Yom lolom isamin ghei kat. Tovenen matam imuul inim payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","You mbesooŋa tiom. Uŋgooz matam payou malep. Pasa, aazne naneep ila pataŋani tiina lolo. Tovenen ulooŋ suŋuuŋ tiou, ve uul ghou rikia. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Unum uyoon ila digeg, ve uul ghou. Ugham mulin ghou ila koiagŋa nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Ŋgar to koiagŋa tigham payou ne, yom uwatagi wa. Yes tiveveleg ghou, ve tipamayaŋin ghou, ve tiwaghamun izag kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Saveeŋ velegiiŋ to tipiyaava payou, nene igham lolog ipataŋan kat. Naghita naghaze irau poiag muul maau. You naghaze pale tamtoghon lolodi isamin ghou, ve tinim tirab ateg. Eemoghon maau. Eta inim peria tiou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Sawa to pitool ghou, koiagŋa tighur mbeb lili ila aniiŋ tiou. Ve sawa to murun ghou, tigham ag vaen papaii. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Tovenen suŋuuŋ tiou iŋarua ghom naghaze: Sawa to koiagŋa yesŋa nditadi tilup di ve tighanghan, ugham toŋ to aniiŋ todi ineep izala, inim liis padi, ve iwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ugham matadi ipis, leso tighita ndug muul sob. Ve ugham tapiridi isob, ve aghedi ipaspas. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Naghaze uŋgal matadi, ve tiyamaan katin mbalmbali tiom. Mbalmbali tiom iza todi, ve iwaghamun di kat, ghoro poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Inadi to nepooŋ pale balim. Tamtoghon eta irau ineep ila mbeez todi muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Pasa, tamtoghon to yom ulosi ve ughur pataŋani pani, ndiran samsamia tonowen tighur pataŋani iza toni muul, ve tinin avodi pa pataŋani to ivot pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Sosor to ndiran tonowen, lolom imaagh pani malep. Matam kisini, ve ughur atia padi le tiyamaana kat! Ughurghur di malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Umus izadi pa rau to nepooŋ mataad yaryaara. Rau to tamtoghon deŋiadi izadi tineep ila, ndiran tonowen izadi ila toman di malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","O Maaron, aazne nambaad pataŋani ve nayamaan yabyabuuŋ tiina. Tovenen unum uul ghou. Uŋguaaz ghou nazala sala. Leso naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","You pale nambou ve napait Maaron iza. Pasa, ye igham lolog poia kat. Tovenen you naghaze napaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ŋgar tovene, nene igham Yoova lolo poia kat le ilib pa makau katindi to tighamgham di pa watooŋrau. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Yes to tinumeer Maaron ve timbadbaad pataŋani, ighaze tighita Maaron iuul ghou, nene pale tinidi iza. Ve yes to tizuaria di pa Maaron ne paam. Ighaze tighita ulaaŋ to ye igham payou, nene pale ipalot di. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Pasa, yes to timbadbaad pataŋani ve tinumeer Yoova, ye iloŋlooŋ suŋuuŋ todi. Tamtoghon toni to tineep ila koiadi nimadi, ye irau lolo imaagh padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Sambam paroŋania, taan, ve te, toman mbeb tisob to tineep ila, yam asob apait Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Pasa, ye pale igham mulin ndug Zion, ve ipamundigin ndug tisob to Yudea muul. Leso tamtoghon toni timuul tila tonowe, ve tigham mulin taan todi, ve tineep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Ve muri, taan todi pale izi pa papaghu todi, ve tighami inim ledi, ve tineep ila. Tovenen yes to lolodi pa Maaron, pale tineep pooi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","O Maaron, upas ghou navot pa pataŋani tiou tonene. Yoova, unum uul ghou rikia lak! ");
INSERT INTO tuc_o_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Yes to tigham lilin ghou ne, ughamun ŋgar todi. Leso ŋgar todi iwaghamgham, ve mayadi ve tighau tila. Ve yes to tighita pataŋani tiou tonene ve lolodi poia pani, yes paam, upamuul di tila toman mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ndiran tonowen tiwamogheran di payou tighaze: “Aa! Pataŋani to taghaze ivot pani, tauto ivot wa!” Tovenen utatan di, ve ugham di mayadi ve tighau tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Eemoghon tamtoghon tisob to tizuaria di payom, yes pale tinidi iza ve lolodi poia payom. Yes to lolodi pa ulaaŋ tiom kat, nene pale moghon moghon tisavsaav tighaze: “Maaron, ye iza tiina kat!” ");
INSERT INTO tuc_o_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Yoova, pataŋani tonene itatan ghou le tapirig isob kat. Narau mbeb eta muul maau. Ve yom moghon to Ulaaŋa tiou. You naghur matag payom pa upas ghou navot pa pataŋani tonene. Tovenen uzuar malep. Rikia unum uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yoova, you nanumeer ghom, ve nayooŋ ilat tiom. Upul koiagŋa titatan ghou malep. Pasa, ighaze tilib payou, pale mayag. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Yom utataghon ŋgar deŋia. Tovenen uul ghou, ve upas ghou navot pa pataŋani tiou tonene. Ughur taliŋam payou ve uul ghou lak. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Yom Volaaŋa tiou ariaŋa. Uponpoon ghou pa koiagŋa unumale raŋ to izala kat. Ve unum ruum ariaŋa pa nayooŋ ila lolo. Sawa isob, you irau naŋarua ghom, leso mbeb eta iwaghamun ghou sob, ve naneep pooi. Aliŋam inim pataghaaŋ wa ughaze yom pale ugham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Maaron tiou, ugham mulin ghou ila ndiran samsamia nimadi. Pasa yes ndiran to sosor, ve lolodi isamin tamtoghon eta maau. Ighaze tikis ghou, nene pale tiwaghamun ghou kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Yoova, you naghur matag payom pa uul ghou. Tiina tiou, sawa to pain ghou ve inim, you nanumeer ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Sawa to naneep ila tinaŋ apo ve inim, you naneep ila nimam. Tovenen sawa to tinaŋ ipoop ghou, yom uŋgin ghou. Tauto moghon moghon napapait ghom pa poia tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Ival tiina tigham ŋgar naol payou. Pasa, tighita ŋgar to ivotvot payou ne, le tighilaal katin ghom. Yom unum inag ariaŋa to yoŋgaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Tovenen mboŋmaagh ila le rabrab izi, lolog poia kat payom, ve avog ipapait izam pa tapirim ve poia tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Aazne, nanim olman waat wa. Eemoghon ughita ghou nanimale mbeb samia to tamtoghon tipiyaava ilale ne malep. Tapirig isob wa. Upul murim payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Pasa koiagŋa tilup di, ve tikalkaal ataam pa tirab ghou namaat. Sawa to tiyoŋyooŋ ve tisasaŋan pa rabuuŋ ghou, tisavsaav tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","“Aa, Maaron ipul muri pani wa! Tataghoni ve takisi. Pasa, le tamtoghon eta pa iuuli maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Maaron, uneep saguan payou malep! Maaron tiou, rikia unum uul ghou! ");
INSERT INTO tuc_o_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Koiagŋa to tiŋgal saveeŋ payou ne, ugham di mayadi, ve urab di le tisob. Yes to tighaze tiwaghamun ghou ne, utatan di, ve ugham di mayadi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Eemoghon you pale naghur matag payom irau sawa isob, ve nasaŋan ghom pa uul ghou. You naghaze napait ghom le napait ghom kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Avog pale ivotia ŋgar tiom deŋia pa tamtoghon. Mboŋmaagh ila le rabrab izi, you pale nasavia uraat tintina to yom ughamgham di ne pa uul tamtoghon. Uraat tonowen, ighaze natoova pa nanin di, nene pale naraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Yoova, yom upatooŋ tapirim ila uraat tintina. Tovenen you pale nala ve navotia uraat tiom tonenen pa tamtoghon, leso matadi iŋgali. Naghaze nasavia ŋgar deŋia to yom ughamghami. Lolog pa nasavia mbeb ite paam maau. Naghaze nasavia ŋgar tiom deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Sawa to pain ghou ve inim imuul aazne, yom upaghazoŋan ghou pa ŋgar tiom. Tauto navovotia uraat tiom gharatooŋadi pa tamtoghon. Uraat tonowen, ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O Maaron, aazne nanim olman waat, ve moom iza pa dabag wa. Eemoghon upul murim payou malep! Uneep toman ghou le irau navotia tapirim ve uraat tiom tintina pa ndinatumai, nditimbumai, ve iseeŋga taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Maaron, tapirim ve ŋgar tiom deŋia, nene tiina le tiina kat. Izala izala le ikis sambam. Ve uraat naol to yom ughamgham di ne, tovene paam. Nene tintina kat. Sei to pale irau ghom? Eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Onoon, yom upul pataŋani naol tivot, ve tiwaghamun ghou. Eemoghon yom pale ugham ghou naneep pooi muul. Paam namaat nazila naal. Eemoghon yom pale ugham mulin ghou. Irau namaat maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ve yom pale upakur ghou, ve ugham izag ivot inim tiina, ve urab ateg, leso lolog poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Tovenen you pale narab gita, ve napait izam. Pasa, yom utataghon saveeŋ mbuaaŋ tiom. Maaron tiou, yom Maaron patabuaŋ to yes Israela. You pale narab gita tiou, ve nambou mbouŋ pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Pale nalool ve nambou pa napait izam. Pale napakur ghom toman lolog. Pasa, yom to ugham mulin ghou pa pataŋani tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Tovenen ndag to naol ne, mboŋmaagh ila le rabrab izi, you pale nasavia ŋgar tiom deŋia. Pasa, yes to tighaze tiwaghamun ghou, yom utatan di le tapiridi isob, ve upamuul di tila toman mayadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","O Maaron, upasaluŋgan kinik tiei ve uuli pa itaghon ŋgar tiom deŋia. Leso iyoon pa tamtoghon tiom, ve igharaat pataŋani todi le deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ve iŋgabiiz poian tamtoghon tiom, ve igharaat saveeŋ todi itaghon ŋgar deŋia. Ve iyoon pa yes mbolaaŋa ve yes to ledi izadi maau ne, ve iuul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Nighaze nepooŋ poia ivot irau lolooz tisob to ndug tonene. Ve ndug mbuŋa mbuŋa tighita anoŋa to ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Ugham kinik tiei iyoon pa yes to ledi izadi maau ne, ve iparab ariaŋa padi. Ve yes to mbolaaŋ igham di ne, ye irau iuul di. Eemoghon yes to titatan tamtoghon ve tighurghur pataŋani padi, ye irau itatan di le tapiridi isob kat, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Maaron, tamtoghon tiom pale timatughez payom ve titaghon ŋgar tiom itaghoni taghoni gha ila, tinimale ndag ve kaiyo to tineep irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Nighaze kinik tiei iuul tamtoghon tineep pooi, inimale uman to itap izi ila uum, ve ipambees taan, ve igham aniiŋ titub pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Sawa to ye iŋgin ghei, nighaze ŋgar deŋia ve ŋgar luuma ivotvot inim tiina. Leso tamtoghon tineep pooi ila ila le irau sawa isob, ve taghita kaiyo muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Kinik tiei pale iŋgin ndug tiina kat. Te dige eez pale inim ŋgat pani, ve ivool ila pa te dige ite. Ve ya Euprates pale inim ŋgat pani, ve ila ila le irau taan dige to naol ne. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Yes to tineep izi ndug balim, pale tinim ve tiput aghedi pani. Ve koia pale titap tizi ila mata, ve tighan ghavuur to taan. Pasa, tirau mbeb eta muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Ve yes kinik to Tarsis yesŋa kinik to tineep tirau mutu tisob pale tinim, ve tigham mbeb popoia pida pa kinik tiei, ve tipaiti. Yes kinik to tiŋgin taan suruvu to Arabia ve Etiopia ne paam, pale tinim, ve tigham mbeb popoia pani. Leso tipatooŋ taudi tighaze yes pale tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Nighaze kinik tisob tinim tiput aghedi pa kinik tiei, ve tineep ila samba. Ndug ndug timbees pani, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Pasa, sawa to yes mbolaaŋa tipoii pa ulaaŋ, ye ilooŋ taŋiiz todi. Ve yes to tineep sami, ve ledi ulaaŋa eta maau, ye iuluul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Ye lolo isamin yes mbolaaŋa ve yes to tapiridi isob, ve ighamgham mulin di pa pataŋani todi. Leso tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Ighaze tamtoghon titatan di ve tiwaghamun di, ye iyondyood padi, ve ighamgham mulin di ila koiadi tonowen nimadi. Pasa, ye lolo padi kat. Tovenen irau imbatut di, ve siŋ todi imaliŋ sorok ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Maaron, upalot kinik tiei. Leso ineep mala izi taan. Yes Arabia pale tigham le yaam gol to ŋgalaaŋa kat. Ve sawa isob, tamtoghon pale tighur kinik tiei ila suŋuuŋ todi, ve tighason Maaron pa ipaloti, ve ighur poia toni iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Maaron, ugham aniiŋ katindi tivot ila taan tiei le irau uum tiei to lolooz we. Ve wit anoŋa katindi tivot, ve ayadi kalkalia ilala inimnim, tinimale yes Lebanon todi. Ve tamtoghon tovene paam. Nighaze ndug tiei tisob timasa tinim naol, tinimale kikiliiŋ to isaas izala taan pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Kinik tiei, iza pale inepneep tovene itaghoni taghoni gha ila! Iza tiina pale ineep irau sawa isob, inimale ndag to moghon moghon ighazghaaz. Pasa, ye pale inim ataam pa ndug ndug, leso poia to Maaron iza todi. Ndug ndug pale tighita kinik tiei, ve tipaiti tighaze poia to Maaron ineep tomani. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Tapait Yoova! Ye Maaron to iit Israela! Ye moghon to ighamgham uraat gharatooŋadi tintina. Uraat tonenen, ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Tapait iza pa tapiri ve poia toni irau sawa isob! Tamtoghon to tineep tirau taan, pale tighilaala tighaze ye iza tiina pa tapiri ve poia toni. Onoon le onoon kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Suŋuuŋ to Yesi natu David, tauto tinim timuul sualen. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Onoon kat, Maaron ighamgham ŋgar poia pa yes Israela. Yes to ŋgar ŋgalaaŋa ineep ariaŋa ila lolodi, ye igham poian di kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Eemoghon you, sawa eez agheg kirikia, ve rismoghon tone natap. Onoon kat, sawa tonenen, rismoghon tone napul ghurla tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Pasa, naghita ndiran samsamia to tipapait taudi ve tiveleg Maaron, nepooŋadi poia kat. Tovenen nagham ŋgar pa mbeb tonene, le irau lolog maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Yes titub le tinidi popoia kat. Ledi pataŋani maau, ve tineep poia moghon ila le irau mateeŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Pataŋani naol to taan to tighamgham tamtoghon pida, nene tigham di maau. Yes ledi pataŋani eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Ŋgar to paitooŋ taudi, nene tipatooŋa ivot ighazooŋ ila tamtoghon matadi, inimale namatavub to tamtoghon tighuri ila luadi. Ve ŋgar todi to ghamuuŋ malmal, yes tipulpuli maau, inimale nonogiiŋa to moghon moghon tindud di pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Nepooŋ todi, poia moghon. Tovenen titub le paŋadi isarsar. Lolodi ivon pa ŋgar samsamia naol, ve moghon moghon tikalkaal ataam pa tiwaghamun tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Yes tiveveleg tamtoghon, ve tipipiyaav saveeŋ samsamia padi. Ve tipapait taudi izadi, ve tipamatughezan tamtoghon tighaze pale titatan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yes tipakur taudi, ve tisasavia saveeŋ velegiiŋ pa Maaron to sambam. Ve nditadi to tineep izi taan ne, ndiran tonowen matadi velegin di, ve tighaze titatan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Yes tiweu tamtoghon to Maaron paam, ve titaghon di pa ŋgar todi tonowen. Ival tiina tighaze le tiloŋlooŋ saveeŋ todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Ndiran samsamia tonowen tisavsaav tighaze: “Ah, Maaron to ineep sala kat we, ye le ŋgar? Ŋgar to nighamghami ne, Maaron iwatagi maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Aghita. Ndiran samsamia, nepooŋadi tovene. Ledi pataŋani eta maau, ve tindoundou ledi mbeb katindi. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Muuŋ, you nagham ŋgar tovene pa nepooŋadi. Tauto nasaav pa taug naghaze: “You tonene, nazuaria ghou naghaze le leg sosor eta sob, ve ŋgar ŋgalaaŋa moghon ineep ila lolog. Eemoghon ŋgar to nataghoni ne, anoŋa eta maau. Naghamghami sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Pasa ndag to naol ne, mboŋmaagh ila le rabrab izi, Maaron ighurghur pataŋani payou. Mboŋmaagh to naol ne, ye iloslos ghou.” ");
INSERT INTO tuc_o_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Maaron, ŋgar tiou samia tonene, inimale nasavia ivot ighazooŋ ve tamtoghon tilooŋa, tone nagham kaarom pa tamtoghon tiom, ve naghamun ŋgar todi. Tauto ineep to taug moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","You nagham ŋgar naol pa nepooŋ poia to ndiran samsamia, ve nakaal pughu. Eemoghon naraua maau. Tauto igham lolog ipataŋan kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Muri ghoro, nalooŋ nala rumai patabuaŋ to Maaron, ve nasuŋ. Sawa tonenen, ghoro naghilaal, ve ŋgar tiou ivot pa mbeb to muri pale ivot pa ndiran samsamia. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Onoon kat, yom pale ugham di tilaagh ila ataam to kirikirikia. Leso ugham di titap, ve tisami. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Pale upasob di rikia moghon, ve ureu mbirisan di tilaledi. Ve mateeŋ todi, pale toman matughezaaŋ tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Maaron, ighaze yom umundig ve uwaghamun di, nene pale upasob di kat. Eta irau ineep muul maau. Pale tinimale mbeb to taghita ila vibiiŋ, ve mboŋmaagh tamundig lolood imaagh pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","22","Sawa to nagham ŋgar pa ndiran samsamia, nene igham ghou lolog isami ve ateg yabyab. Ŋgar tiou iwaghamgham nanimale borouŋa. You nanimale ŋgai sagsag to le ŋgar payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Eemoghon yom upul ghou maau. Yom unepneep toman ghou irau sawa isob, ve ukis nimag waan ve upalot ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Yom ughamgham pooz payou, leso nataghon ŋgar tiom. Ve muri, yom pale upakur ghou, ve ugham ghou nalat naneep toman ghom ila ŋgurubam lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","You nagham ŋgar pa mbeb eta to ndug sambam maau. Yom moghon to nagham ŋgar payom. Yom unepneep toman ghou, tovenen nakaal sa mbeb muul izi taan? Maau. Pasa, yom moghon to uraua. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Ighaze tapirig isob, ve ŋgar tiou iraua maau, nene pale Maaron ipalot ghou. You naghita Maaron naghaze ye mbeb tau. You naghamgham tapirig ila toni, ve naneep ila toni. Ye inimale taan poia eez to tipuli payou, leso naneep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Yes to lolodi ineep saguan payom, nene pale tilaledi. Ve yes to tipul muridi payom, yom pale upasob di. ");
INSERT INTO tuc_o_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Eemoghon you, sawa to naneep nagharau ghom, nayamaana naghaze nene poia kat. Yoova, yom Maaron tiou. You nanumeer ghom, ve nayooŋ ilat tiom. You naghaze navotia uraat tisob to ughamgham di ne pa tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","O Maaron, pughu vena to upul murim payei kat? Pale upul ghei nineep tovene itaghoni taghoni gha ila? Yei sipsip tiom, ve yom ŋginiiŋ tiei. Pughu vena to atem yabyab payei kat tovene? ");
INSERT INTO tuc_o_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Yei tamtoghon tiom. Muuŋ, yom usia nditimbumai tinim lem, ve uyondyood padi, ve ughamgham mulin di pa pataŋani todi. Tovenen matam iŋgal ghei. Ve matam iŋgal inam to nepooŋ to ineep izi lolooz Zion ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Taum unum ve ulaagh ila ndug lolo ve ughita. Isami wa! Irau poia muul maau. Koiamai tireu mbirisan rumai tiom patabuaŋ, ve tiwaghamun mbeb tisob to tineep ila lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Ndug to muuŋ itiŋa taluplup ghiit ilooŋ ila, koiamŋa tilooŋ tila, ve tighami inim ledi, ve tilool toman aliŋadi tiina. Ve tipayoon pilak todi iza tonowe, leso ipatooŋ di ighaze tilib payei wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","6","Yes tiwaghamun Rumai Tiina tinimale yes to tigham nakavas todi ve tila su pa tiŋgor ai. Ai popoiadi naol to tisap mbeb anunudi ila pa tipabood rumai tiom, tigham nakavas ve tipalpaal di, ve tirabrab balagin di pa hama todi tintina. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Ve titun rumai tiom patabuaŋ, le yab ighan suvuni. Tovenen taum inam to nepooŋ to izam inepneep ila, tiwaghamuni inimale mbeb sorok, le isami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Yes tighaze titatan ghei ve tiwaghamun ghei kat. Tovenen ndug tisob to taan tiei to tamtoghon tiluplup di ila, ve tisuŋsuŋ payom, yes titun di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Aazne, yei nighita mbeb eta to ipatooŋ ghei ighaze yom unepneep toman ghei ne maau. Ve propet eta ineep muul pa ipaghazoŋan ghei pa ŋgar tiom ne maau. Ve tiei eta iwatag maau: Pale ŋeez o, pataŋani tonene isob? ");
INSERT INTO tuc_o_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Maaron, aazne koiamai tiŋiŋiŋ payom, ve tiveveleg izam. Vena, pale upul di tigham tovene itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Pughu vena to nimam ila murim, ve umbabatut ghei moghon? Irau uul ghei maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Maaron, muuŋ ve inim, yom kinik tiei ve Volaaŋa tiei. Ve yom ughamgham uraat tintina izi taan pa uul ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Muuŋ, taum tapirim to uvalag te, le pida ila pa ŋas, ve pida ila pa waan. Ve mbeb samsamia pida to tinepneep ila te lolo, yom urab balagin dabadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Leviatan paam, mbeb samia tiina to inepneep ila te lolo, yom urab balagin daba to naol ne, ve ugham anoŋa, ve upan mbeb sagsagŋa to tineep ndug balim ne pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ndug pida, yom ugham ya ivotvot pa taan ve ireer. Ve ya tintina to ndug pida to tirereer irau sawa isob, yom ugham di timakmaak. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Yom to ughur mboŋ ve ndag, ve uŋgin di. Ve yom ughur ndag ve kaiyo tineep ila inadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Yom ughur taan seŋgaŋa, ve ughur sawa to ndug tuntunu, ve sawa to ndug yauŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Yoova, matam iŋgal saveeŋ velegiiŋ to koiamŋa tipiyaava payom. Aazne, yes kankanooŋa to tiwatag ghom maau ne, tiwaghamun izam, ve tighita ghom unumale mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Koiamai ŋgar todi inimale mbeb sagsag. Lolodi isamin tamtoghon eta maau. Ve yei tamtoghon tiom tapirimai irau mbeb eta maau. Tovenen upul ghei nila nimadi malep. Lolom imaagh payei malep. Pasa, yes titatan ghei le nineep sami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Muuŋ, yom umbua saveeŋ toman ghei ughaze yom pale unum Maaron tiei, ve yei ninim tamtoghon tiom. Matam iŋgal saveeŋ mbuaaŋ tiom tonenen, ve uul ghei. Ughita. Aazne, taan tiei ivon pa ndiran samsamia to tiyoŋyooŋ ila ndoroom lolo, ve tisasaŋan pa tigham malmal pa tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Upul ndiran samsamia titatan tamtoghon, ve tipamayaŋin di malep. Uul yes mbolaaŋa ve yes to tineep sami, leso tipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","23","Maaron, yei tamtoghon tiom. Umundig ve uyoon payei lak! Koiamŋa tipakur di toman aliŋadi tiina. Ndag to naol ne, mboŋmaagh ila le rabrab izi, yes kankanooŋa to tiwatag ghom maau ne, tighamgham oroor tiina, ve tiveveleg ghom. Lolom imaagh malep. Matam iŋgal ŋgar to tighamghami ne, ve ughur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Maaron, yei lolomai poia payom, ve nipait ghom pa poia tiom. Pasa, moghon moghon yom unepneep ugharau ghei. Tovenen yei nipapait izam, ve nivovotia uraat gharatooŋadi to ughamgham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ve Maaron isaav ighaze: “You taug naghur sawa pa naŋgabiiz tamtoghon ve naghur atia padi. Ve gabizooŋ tiou, pale deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ighaze yoŋgyoog itok taan, ve tamtoghon tisob tisaŋeeŋ, you pale nakis taan pughu, leso ineep tuŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Yes to tipapait taudi izadi, you nasaav padi naghaze: ‘Apait taumim iraua!’ Ve nasaav pa ndiran samsamia naghaze: ‘Aparim taumim malep. Tapirimim ineep sine? ");
INSERT INTO tuc_o_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Tovenen apait taumim malep, ve apiyaav saveeŋ velegiiŋ payou malep!’” ");
INSERT INTO tuc_o_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Pasa, tamtoghon to ndag iza, ma tamtoghon to ndag izila, ma tamtoghon to ndug pida paam, tirau tigham tamtoghon eta iza ivot inim tiina ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Maaron moghon, to igham tamtoghon izadi tivot tinim tiina. Pasa, ye to iŋgagabiiz tamtoghon ve ighurghur atia padi. Tamtoghon pida, ye itatan di. Ve pida, ye ipakur di le izadi tintina. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yoova ikis rubruub eez ila nima. Rubruub tonowen ivon pa vaen ariaŋa. Vaen tonowen, nene mbalmbali toni. Ndiran samsamia to tineep izi taan, ye pale iliŋ vaen tonowen, ve ipaghun di pani, le tisob tighun suvuni. Ŋgiira to ineep ila rubruub mbole, pale tighuni paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Eemoghon you navovotia uraat tintina to Yoova irau sawa isob. Pale namboumbou, ve napapait Maaron to Yakop iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Pasa, ye isaav ighaze: “Ndiran samsamia, you pale napasob tapiridi. Ve ndiran deŋiadi, you pale napakur di ve napalot di, leso tapiridi ivot inim tiina.” ");
INSERT INTO tuc_o_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Yes to tineep izi taan suruvu to Yuda, tiwatag Maaron. Ve yes to tineep izi taan suruvu to Israel, tipaiti paam. Pasa, ye iza tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Rumai to Maaron ineep izi Yerusalem. Ve lolooz Zion, nene Maaron ina to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Sawa to koia tigham malmal pani tonowe, ye iŋgor polpolin pane ndinatu to yab ighanghan ila matadi, toman buza todi, ve irab balagin sigeu todi. Tovenen mbeb todi to malmal, ye iwaghamun di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O Maaron, yom ŋgurubam tiina. Yom paghunam ve izam tiina kat. Ulib pa lolooz tintina to tineep irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Koiamai, ndiran ariaŋadi. Timatughez maau. Eemoghon yom uparab toman di le ulib padi. Tauto tamtoghon tiom tila tiyou mbeb todi to malmal tisob tinim ledi. Yom urab koiamŋa tisob timatmaat, ve patudi tiwaghengheen izala taan pogho. Onoon, yes ndiran ariaŋadi. Tiraua kat pa malmal. Eemoghon irau tigham mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Maaron to Yakop, yom upamatughezan di ve uyaan di. Tauto yes to tilaan pa hos toman karis, tisob titaptap tizi le timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","O Maaron, yom moghon to tamtoghon tisob timatughez payom. Pasa, ighaze atem yabyab, sei irau iyoon ila matam? ");
INSERT INTO tuc_o_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Yes to koiadi tighamgham pataŋani padi ve titatan di, yom uyoon padi, ve ugham mulin di tisob. Yom uneep izi sambam, ve aliŋam izi inim, ve usavia atia to pale iŋarua koiadi. Ve sawa to ughur atia tonenen padi, tamtoghon tisob to taan tighita, le matughezaaŋ igham di, ve neneeŋadi moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Onoon kat. Mbalmbali to tamtoghon, nene paam irau inim ataam pa upatooŋ tapirim. Tauto tamtoghon tipait ghom. Ve yes to mbalmbali tiom iwaghamun di maau, yes pale tiluvut ghom, leso tisuŋ payom ve tipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Yam to ambua saveeŋ aghaze agham mbeb pa Maaron tiam Yoova, matamim iŋgal saveeŋ tiam, ve ataghoni. Ve yam ndug ndug to aneep agharau ne, tovene paam. Agham mbeb tiam popoia pida tinim pa Ŋgeu to tamtoghon timatughez pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Yes pooza to tinumeer taudi tapiridi, Maaron itatan di. Tauto yes kinik to taan timatughez pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","You nataŋ roran Maaron. Taŋiiz tiou iŋarua naghaze ighur taliŋa pa suŋuuŋ tiou tonene, ve iuul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Sawa to naneep ila pataŋani tiina lolo, you nazuaria ghou naghaze le nagham ulaaŋ ila to Maaron. Mboŋ ve ndag, nakaak nimag iza, ve nasuŋ pani. Irau ateg izi maau. Eemoghon mbeb eta irau irab ateg maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","You matag iŋgalŋgal Maaron, ve lolog isami ve nataŋ. Nagham ŋgar naol. Tauto lolog ipataŋan ve tapirig isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Mboŋ to naol ne, Maaron ipul ghou nagheen pooi maau. Lolog ipataŋan kat le irau nasavia saveeŋ eta maau. Neneeŋag moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Pasa, matag iŋgal imuul ila pa ndaman katindi to ila wa. Ve naŋazuuv ŋgar to muuŋ Maaron ighamgham pa tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Tovenen mboŋ to naol ne, nagham ŋgar tiina ila lolog, ve matag iŋgalŋgal naghaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Vena, pale Maaron ipul muri payei, ve ipul ghei nineep sami itaghoni taghoni gha ila? Irau lolo poia payei muul maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Ŋgar to lolo ineep tuŋia ila to tamtoghon toni ve iuluul di, nene isob wa? Ve saveeŋ to ye imbua toman ghei, pale izi inim mbeb sorok itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Ma Maaron ate yabyab kat, le ighami lolo imaagh pa poia toni? Tauto lolo isamin ghei muul maau ne?” ");
INSERT INTO tuc_o_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Nagham ŋgar tovene, tauto nasaav pa taug naghaze: “Lolog ipataŋan kat pasa, Maaron to ineep sala le sala kat ne, itoor ŋgar toni wa. Taghita tapiri inim inim le aazne, taghita muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Yoova, you pale matag iŋgal imuul ila pa uraat tiom tintina, ve mbeb gharatooŋadi to muuŋ ughamgham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Pale matag iŋgal uraat tiom ariaŋadi to naol ne, ve nagham ŋgar padi pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O Maaron, yom ughamgham ŋgar patabuaŋ moghon. Ŋgar tiom ve gabuam, nene ite kat. Maaron ite paam iza tiina inimale yom ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Yom Maaron to ughamgham mbeb gharatooŋadi tintina. Upatooŋ tapirim ivot ighazooŋ ila ndug ndug matadi ve tighita katini wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Yakop ve Yosep papaghu todi, yes tamtoghon tiom. Muuŋ, ila taum tapirim, yom upas yes Israela tivot pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O Maaron, sawa to ya tintina tighita ghom, matughezaaŋ tiina igham di. Ve te to ineep izila sila we, imatughez paam, ve imbeluuta izaza. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Sawa tonenen, yaghur tae iyasosooŋ, ve uman tiina izi. Ve ndug ighani milia, ve lalaav kiliŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Yom ugham yaghur uti ililiit, ve lalaav kiliŋkiliŋia. Ndug milia, le ndug ighazooŋ. Ve yoŋgyoog itok taan katkatia. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ataam tiom imbut te ivool ila pa dige ite. Yom uvalag mazovan, le pida ila pa ŋas, ve pida ila pa waan, ve ulaagh ila bodbodaaŋ. Eemoghon tighita aghem muri maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Yom umuuŋ pa tamtoghon tiom unumale ŋginiiŋ to sipsip. Ve ughur Mose yesuru Aron tigham naghom, ve tighereb di tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Yam tamtoghon tiou, aghur taliŋamim pa saveeŋ to naghaze napatoot gham pani. Saveeŋ to naghaze nasavia payam, yam asob alooŋ poiani. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Pale avog ikaak, ve nasavia saveeŋ palelaaŋ pida payam. Pale nasavia mbeb pida to muuŋ tivot. Mbeb tonowen, pughudi iyooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Kamos tonene, nditimbuud tisavia payei ve nilooŋa, tauto niwatagi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Muuŋ, Yoova ipatooŋ tapiri ivot ighazooŋ. Ye igham mbeb gharatooŋadi ve uraat tintina tivotvot. Tauto tamtoghon tipait iza pa tapiri ve poia toni. Uraat toni tonowen, irau taŋgooza pa ndinatuud maau. Tasavia padi, ghoro poia. Leso papaghu toit to pale muri tivot, tiwatagi paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Ataam to itiŋa Maaron talup ghiit tanim ee moghon, muuŋ ye ivotia pa nditimbuud to Yakop papaghu toni. Ye isavia tutuuŋ toni pa yes Israela, ve isaav ariaŋa pa nditimbuud ighaze tipatoot ndinatudi pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Leso yes paam tiwatagi, ve anadi tisavia pa ndinatudi, ve iseeŋga tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Ighaze tigham tovene, papaghu todi irau lolodi imaagh pa uraat tintina to Maaron igham di ne maau. Ve yes pale tinumeera, ve matadi iŋgal tutuuŋ toni, ve titaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Leso tigham ŋgar inimale nditimbudi sob. Pasa nditimbudi, ŋgar todi iyaryaaŋ kat. Lolodi pa titoor ŋgar todi maau. Moghon moghon tighamgham didiaaŋ, ve tizorzoor Maaron aliŋa. Lolodi ineep tuŋia ila toni maau. Ve saveeŋ to yesŋa Maaron timbua, titaghoni maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Papaghu to Epraim, yes tiraua kat pa tivaneg pa pane. Eemoghon sawa to malmal imundig, timatughez ve tighau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Ve saveeŋ to yesŋa Maaron timbua, matadi kisini ve titaghoni maau. Laghooŋ todi, lolodi pa titaghon tutuuŋ toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Ve uraat tintina toman mbeb gharatooŋadi to muuŋ Maaron ighamgham di ila matadi, lolodi imaagh pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Sawa to nditimbudi tineep izi Isip, Maaron igham mbeb gharatooŋadi tintina izi taan raapa to Zoan, ve tighita pa taudi matadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ve sawa to tila tivot izi Te Kaviaaŋa, ye ivalag te le pida ila pa ŋas, ve pida ila pa waan. Ye igham te iyoon inimale didiiŋ. Tauto ataam ivot padi, ve titaghoni tivool tila pa dige ite. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Ndag, ye igham yaghur tae ivot, leso ipatooŋ di pa ataam. Ve mboŋ, ye igham yab ivot, leso imuuŋ padi ve titaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Sawa to tineep izi ndug balim, Maaron irab balagin yaam, ve igham ya ireer ivot pani. Ye igham ya ireer tiina, leso tighun. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Onoon kat, ye igham ya katindi tivot ila yaam, ve tireer tizi le tinim ya tintina. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Eemoghon yes tinoknok ghamuuŋ sosor pa Maaron Tiina To Ilib Pa Ndimaronŋa Tisob. Sawa to tilaghlaagh izi ndug balim, tizorzoor aliŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Yes titovtoov Maaron tapiri. Tauto tisaav pani tighaze igham adi aniiŋ to luadi itaŋtaŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","20","Ve tiveleg Maaron tighaze: “Laak, Maaron tapiri irau igham amai aniiŋ izi ndug balim tonene? Onoon, ye irab balagin yaam, ve ya tiina goŋia ivot toman tapiri, ve ireer izi. Eemoghon irau igham tamtoghon toni adi aniiŋ toman ziga?” ");
INSERT INTO tuc_o_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yoova ilooŋ saveeŋ todi tonowen, le ipas ate. Tovenen igham yab izi ighan Yakop papaghu toni. Ate yabyab kat pa yes Israela, ve iwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Pasa, yes tighur ila toni maau. Tinumeera tighaze tapiri irau iuul di ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Tovenen Maaron isaav ariaŋa, ve ataam to sambam paroŋania ikaak, ");
INSERT INTO tuc_o_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","ve igham aniiŋ manna izi padi. Ye igham aniiŋ to sambam padi leso tighan. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Onoon kat, tamtoghon tighan aniiŋ to yes aŋela. Maaron igham adi aniiŋ katindi, ve tighan le isooŋ di. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Ghoro ipamundigin yaghur ghaughauru inim. Tau tapiri igham yaghur tiina imundig pa rag pughu. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Ve igham man katindi tiroov tinim, ve titaptap tizi ndug to tinepneep pani. Man tonowen, sorok maau. Yes tinimale magargaar to naari. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Maaron igham di titaptap tizi ndug to tamtoghon toni tinepneep pani, le tiluvut mbeez todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Tovenen yes Israela tighan le isooŋ di. Pasa, mbeb to luadi itaŋ pani, tauto ye igham padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","31","Yes Israela tipasob ghanuuŋ man tonowen sone, ve Maaron mbalmbali toni iza todi, ve irab tamtoghon todi ariaŋadi timatmaat. Ndipain todi papaghu to popoiadi kat, ye ipasob di. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Yes Israela tighita mbeb tisob tonowen. Eemoghon tinoknok ghamuuŋ sosor sone. Tikaria ghitooŋ mbeb gharatooŋadi. Eemoghon tighur ila to Maaron maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Tauto ye iŋgor sawa todi inim tuku. Nepooŋ todi isob rikia moghon, inimale yaghuraad to ivotvot ila avood. Mateeŋ ikarmotin di, le matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Onoon, sawa to Maaron irab tamtoghon todi pida, rikia moghon ve ival tiina tighilaal, ve titoor ŋgar todi imuul ila pani, ve tisuŋ pani ariaŋa tighaze lolo isamin di ve ireu sosor todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Ve matadi iŋgal muul tighaze: Maaron, ye iponpoon di inimale raŋ to izala kat. Maaron Tiina To Ilib Pa Ndimaronŋa Tisob, ye to Volaaŋa todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Eemoghon tipaiti pa avodi uli moghon. Saveeŋ to ivotvot ila avodi, tisavia toman lolodi maau. Tigham kaarom. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Lolodi ineep tuŋia ila to Maaron maau. Ve saveeŋ to yesŋa Maaron timbua, matadi kisini ve titaghoni maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Eemoghon Maaron lolo isasamin di, ve ireureu sosor todi. Tauto iwaghamun di kat maau. Onoon, sawa naol, ye ate yabyab padi kat. Eemoghon iyai tau, ve itatan mbalmbali toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Pasa, mata iŋgal ighaze: Yes to taan moghon. Tapiridi tintina maau. Tineep ris, ve tilaledi, tinimale yaghur to talooŋ avolutu inim, ve isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Sawa to tineep izi ndug balim, tizoor Maaron aliŋa pae katindi. Yes tilaghlaagh ila ndug to magargaar moghon, ve tighamgham Maaron lolo ipataŋan. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Maaron Patabuaŋ to yes Israela, yes tinoknok tovaaŋi. Tauto tipas ate, le ate yabyab kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Yes lolodi imaghmaagh pa Maaron tapiri. Matadi iŋgal sawa to ye igham mulin di ila koiadi nimadi ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Muuŋ, ye igham mbeb gharatooŋadi katindi tivotvot izi Isip pa ipatooŋ tapiri padi. Ye igham uraat tintina izi taan raapa to Zoan. Uraat tonowen, tamtoghon tighita di le avodi ikaak. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Ye itoor ya tintina to yes Isipa tinim siŋ. Tovenen yes Isipa adi ya eta pa tighun maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Ve igham raaŋ tintina to tiŋutŋut tamtoghon tivot izi ndug todi, ve tiŋut di le tisami kat. Ve igham ŋgob katindi tivot le tiwaghamun di paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Ve igham isis tivot le titatab ndug todi, ve tighan aniiŋ todi. Uum to tighun wadedeŋadi pani, isis tighan mbeb to uum tonowen le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ve ye igham ais patu patu titaptap tizi, le tiwaghamun ai vaen todi. Ve uman tiina toman ais izi le iwaghamun ai fik todi paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Ye igham ais patu patu titaptap tizi, ve tirabrab makau todi timatmaat. Ve igham lalaav iŋgalŋgal sipsip todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","50","Maaron ate yabyab le yabyab kat. Toni imozi kat. Ate irau izi muul maau. Tauto ighurghur yes Isipa muul maau, ve mbalmbali toni iza todi kat. Ye imbaaŋ aŋela toni ival tila tiwaghamun di pa moroghooŋ samia. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Ye irab yes Isipa ndinatudi aidaba, le tisob timatmaat. Ndinatudi to tipoop di muuŋ, tauto tisob. Eta ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Ghoro igham tamtoghon toni tipul Isip. Ye imuuŋ padi inimale ŋginiiŋ to sipsip, ve yesŋa tilaghlaagh izi ndug balim. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ye imuŋmuuŋ padi ve iŋginŋgin di. Tovenen timatughez pa mbeb eta maau, ve tineep poia moghon. Eemoghon koiadi, te itatab di, le tisob timatmaat ila te lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ye igham di tila tigharau taan toni patabuaŋ dige, ve lolooz to ye iparab pani ve ighami inim le. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Ve indiir ndug ndug to tineep izi taan tonowen tighau tila, leso tamtoghon toni tila tigham taan todi inim ledi. Ve irei taan tonowen toman ruum to tineep ila, le irau rumai rumai to yes Israela, ve tighami inim ledi, leso tineep pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","57","Eemoghon tizi ve titoov Maaron Tiina To Ilib Pa Ndimaronŋa Tisob Ne muul. Tizorzoor aliŋa, ve ataam to ye ighuri padi, yes titaghoni maau. Yes tamtoghon toni. Eemoghon tipul muridi pani, ve tireu saveeŋ mbuaaŋ to timbua toman Maaron, tinimale nditimbudi. Tovenen ye irau inumeer di maau. Yes tinimale pane to ool ipas pani, ve le uraata maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Maaron iriu di pasa, tighagharaat maaron kaaromŋa anunudi. Yes tiluplup di izala ndug mbuŋa to naol ne, ve tisuŋsuŋ pa maaron kaaromŋa. Tauto tipas Maaron ate. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Maaron ighita ŋgar todi tonowen, yabyab ve ipul muri padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Sawa tonenen, ye ipul mbeez toni patabuaŋ to ineep izi ndug Silo, izi ineeple. Ina to nepooŋ to ineep ila tamtoghon toni lolodi, ye ineep ila muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ve Bokis to Saveeŋ Mbuaaŋ to inim ghilalooŋ pa tapiri ve ŋguruba, ye ipuli ila yes Israela koiadi nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","63","Ate yabyab kat pa tamtoghon toni. Tovenen ipul di tila koiadi nimadi, ve timbut di pa buza le geegeu todi papaghu timatmaat. Ndiliva todi papaghu irau timbou mbouŋ to vaiuuŋ muul maau. Pasa, nditamoot tineep ve tivai di muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ndiran to watooŋrau paam, buza ighan di timatmaat. Ve ndizwadi ndiliva to tineep tinim ndinaara, irau titaŋ padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Ghoro Maaron igham ŋgar inimale tamtoghon to igheen ve imundig. Ye inimale tamtoghon ariaŋa to malmal to ighun le iwaghamgham. Ghoro mata pakia, ve imundig ila igham malmal muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Ye itatan koia, ve mayadi ve tighau tila. Mayaŋiiŋa tonowen pale inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Maaron ipul muri pa Yosep papaghu toni. Ve ina to nepooŋ paam, ineep toman di muul maau. Irau igham yes Epraima pa uraat tiina eta muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Ve isia rumai to Yuda, leso tigham pooz pa tamtoghon toni. Ve igham lolooz Zion inim le. Lolooz tonowen, ye lolo pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Ye irei rumai toni patabuaŋ izala, leso inim ina to nepooŋ. Rumai tonowen iyaryaaŋ kat inimale sambam. Pale iyoon tuŋia tovene itaghoni taghoni gha ila, inimale taan to ye ighuri. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Ve isia mbesooŋa toni David inim kinik. David iŋginŋgin sipsip ila sirsiir lolo, ve Maaron ighami pa uraat toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Ye mata pa sipsip nditinandi toman ndinatudi to tighunghun tuz, ve Maaron ighami inim ŋginiiŋ pa yes Israela to Yakop papaghu toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Tovenen David iŋgin di itaghon ŋgar deŋia, ve igham pooz padi pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","O Maaron, aazne ndug ndug to tiwatag ghom maau ne, tinim taan tiom tonene, ve tighaze tighami inim ledi. Yes tiwaghamun rumai tiom patabuaŋ le isami, ve tireu mbirisan ndug tiina Yerusalem. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Yes tirab mbesooŋa tiom timatmaat, ve tipul patudi tiwaghengheen ila taan, leso man tighan di. Tamtoghon tiom to lolodi ineep tuŋia ilat tiom ve titaghon ataam tiom, tauto mindadi inim mbeb sagsagŋa adi pa tighani. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Koiamai tirab tamtoghon tiei katindi, ve siŋ todi ireer inimale ya irau Yerusalem lolo. Ve tiei eta ineep pa itavia di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Tovenen ndug ndug to tineep tigharau ghei ne, tighita ghei, ve tighamgham ŋalalaŋ payei. Yes tiŋiŋiŋ payei, ve tiveleg ghei kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O Yoova, pale ŋeez o lolom imuul inim payei? Pale uriuriu ghei, ve mbalmbali tiom ighanghan ghei inimale yab irau sawa isob? Pale mbalmbali tiom izaza tiei tovene itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Ughur mbalmbali tiom iza to ndug ndug to tiwatag ghom maau, ve tiyamaan katini. Ughur atia iŋarua yes to tisuŋsuŋ payom maau ne, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Pasa, yei to Yakop papaghu toni, tirab ghei nisob. Ve tiwaghamun taan tonene, le ndug tiei ŋginiŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Sosor to muuŋ nditimbumai tigham di, ughur atia iza tiei malep. Lolom isamin ghei, ve rikia unum uul ghei. Pasa aazne, pataŋani tiina ivot payei, ve nisami wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Maaron, yom to Volaaŋa tiei. Uul ghei lak! Leso nipait izam pa tapirim ve poia tiom. Upas ghei nivot pa pataŋani tonene, ve ureu sosor tiei. Pasa, gabuam tovene. Tauto tamtoghon tipapait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Maaron, ighaze uul ghei maau, nene pale ndug ndug tisavia saveeŋ velegiiŋ payei tighaze: “Laak, Maaron tiam ineep sine?” Maaron, yes to tirab mbesooŋa tiom timatmaat, uyat ŋgar todi tonowen, ve nighita. Leso ndug ndug tiwatag tighaze yom ughur atia pa ŋgar samia. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Ulooŋ taŋiiz to yes to tineep ila koiadi nimadi. Tapirim tiina kat. Tovenen yes to koiadi tighaze tirab di timaat, ugham mulin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Maaron, ndug ndug tipiyaav saveeŋ velegiiŋ naol payom. Ŋgar todi tonowen, uyati le uyat katini. ");
INSERT INTO tuc_o_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ighaze ugham tovene, nene pale yei tamtoghon tiom lolomai poia payom, ve nipait izam pa poia tiom irau sawa isob. Pale nisavia uraat tiom itaghoni taghoni gha ila. Pasa, yei sipsip tiom, ve yom to ŋginiiŋ tiei. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","O Maaron, yom ŋginiiŋ to yei Israela, ve yei sipsip tiom. Yom to umuŋmuuŋ pa yei papaghu to Yosep. Ughur taliŋam pa suŋuuŋ tiei tonene. Yom unepneep ila inam to ghamuuŋ pooz to ineep izala aŋela ariaŋadi avaradi Upatooŋ ŋgurubam ivot ighazooŋ payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Yom ariaŋam ve tapirim tiina. Umundig ve upatooŋ tapirim ila Epraim, Benyamin, ve Manase papaghu todi matadi. Unum uul ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O Maaron, uul ghei ve upalot ghei. Lolom poia payei, ve ugham poian ghei. Leso nineep poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Yoova, yom Maaron ariaŋam kat, ve uŋgin mbeb tisob. Yei tamtoghon tiom. Eemoghon atem yabyab payei, ve ulooŋ suŋuuŋ tiei maau. Pale ŋeez o mbalmbali tiom isob? ");
INSERT INTO tuc_o_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Yom ugham ghei nimbaad pataŋani tiina le isooŋ katin ghei. Tovenen nitaŋ tiina, ve nighun matamai suru inim ya payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Yom upul murim payei. Tovenen ndug ndug to tineep tigharau ghei, tiwazoran di pa taan tiei tighaze tighami inim ledi. Ve koiamai tiveveleg ghei, ve tiŋiŋiŋ payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Yom Maaron ariaŋam kat, ve uŋgin mbeb tisob. Uul ghei ve upalot ghei. Lolom poia payei, ve ugham poian ghei. Leso nineep poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Muuŋ, ai vaen eez iyoon ila taan to yes Isipa. Yom ugheli iza, ve ughami inim sualen, ve undiir ndug tonene tamtoghona tighau, ve uvazogi ila taan todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ve undeeb pughu, leso itub pooi. Tovenen waria izila taan lolo kat, ve boga titub tila mamala, le titatab taan tonene isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ai vaen tonene itub iza iza, le itatab lolooz to ndug tonene paam, ve inim yavyaav padi. Ve ai mendepur tintina tiyoon ila samba paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Boga pida titub tivot tila mala, le tivot naari to te Mediterenian. Ve pida titub tila le peria ila ya tiina Euprates. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Pughu vena to aazne ureu didiiŋ to muuŋ iluvut uum vaen tiom? Ughita. Tamtoghon to tilaghlaagh sorok, tisob tinim tilooŋ tila, ve tiyubyub anoŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Ve ŋgai sagsag tisusus pughu ve tivazagi, ve mbeb naol to su tighanghan anoŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","15","O Maaron, yom ariaŋam kat, ve uŋgin mbeb tisob. Matam imuul inim payei. Uneep sambam, ve matam izi inim ughita ai vaen to nimam waan ivazogi. Isami wa! Tovenen unum ugharaata! Leso itub pooi muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Aazne, koiamŋa tiŋgor ai vaen tiom izi, ve tisuruuva izala yab. Ughita di ve uyaan di, ve upasob di tilaledi! ");
INSERT INTO tuc_o_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Eemoghon ŋgeu tiom to ineep ila nimam waan, uŋgin poiani ila nimam samba. Kinik tiei to yom taum usia, ve ughuri pa uraat, matam pani ve upaloti. Leso igham uraat payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ighaze ugham tovene, yei irau nipul murimai payom muul maau. Tovenen uul ghei nineep poia muul. Leso nimbees payom, ve nipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Yoova, yom Maaron ariaŋam kat ve uŋgin mbeb tisob. Uul ghei ve upalot ghei. Lolom poia payei, ve ugham poian ghei. Leso nineep poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Lolomim poia pa Maaron, ve ambou pani. Pasa, iit taghamgham tapiriid ila toni. Tinimim iza pa Maaron to Yakop, ve alool ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Ait mbouŋ ve ambou. Ve atok kakaap, ve arab gita ve mbeb pida, leso agham mbouŋ paghuna. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Sawa to kaiyo iza paghu, ve sawa to kaiyo imatu, nene sawa to talup ghiit ve tasuŋ. Tovenen avib tavuur ve apamundigin suŋuuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Pasa ŋgar tovene, nene itaghon tutuuŋ to Maaron ighuri pa iit Israela alok wa. Maaron to Yakop ighaze tataghon tutuuŋ tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Sawa to ye igham malmal pa yes Isipa, ye isaav pa iit Israela ighaze tataghon tutuuŋ tonene, leso itiŋa talup ghiit tanim ee moghon. You nalooŋ ŋgeu eez aliŋa inim. To muuŋ ve inim, nalooŋ aliŋa tovene maau. Isaav ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“You to nazugua mburuguuŋ pataŋani izi pa avaramim, ve nagham gham atemim izi pa badooŋ mbeb. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Muuŋ, yam aneep ila pataŋani tiina lolo, ve ataŋ roran ghou pa nauul gham. Ve you nalooŋ taŋiiz tiam, ve napas gham avot pa pataŋani tiam. You nayooŋ ila yaghur tae asosooŋa to lalaav avolutu ivotvot pani, ve napamuul aliŋamim. Ve natoov gham izi ya dige to ndug Meriba. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Yam tamtoghon tiou, alooŋ saveeŋ ariaŋa to naghaze nasavia payam. Yam Israela, aghur taliŋamim pa aliŋag tonene ve ataghoni, ghoro poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Maaron ite paam ineep ila lolomim ve ambees pani malep. You moghon, ghoro ambees payou. Tovenen aput aghemim pa maaron kaaromŋa to ndug pida malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Pasa, you Yoova to Maaron tiam. You to nagham gham apul Isip. You nasaav payam naghaze: Akaak avomim tiina. Leso napavonini pa mbeb popoiadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Eemoghon tamtoghon tiou tilooŋ aliŋag maau. Yes Israela tiyasiil payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ŋgar todi iyaryaaŋ kat. Lolodi pa tilooŋ saveeŋ maau. Tauto napul di titaghon taudi ŋgar todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","You nakausim naghaze le tamtoghon tiou tilooŋ aliŋag, ve titaghon ataam tiou! ");
INSERT INTO tuc_o_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Leso rikia moghon ve koiadi tiyamaan nimag, ve natatan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Yes to tighur koi payou ne, pale tinim titap tizi ila matag toman matughezaaŋ tiina. Ve atia to pale iza todi, nene pale inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Eemoghon yam Israela, pale napan gham pa aniiŋ popoia, ve napaghun gham pa bagil to su suru, le isooŋ gham.” ");
INSERT INTO tuc_o_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Maaron ineep ila ina to ghamuuŋ pooz, ve yes daba to ndug sambam tilup di ila mata. Ye ipayoon ndimaronŋa pa savsaveeŋ, ve iŋgabiiz di pa uraat todi. Ighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“Yam tonene, ataam tiam to ghamuuŋ pooz, deŋia maau. Pale ŋeez o apul ŋgar tiam tonanan? Sawa to daba to taan tigharaat saveeŋ to tamtoghon, yam apul di tivolvool to ndiran samsamia. ");
INSERT INTO tuc_o_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Yam irau apamundigin di, leso tigharaat saveeŋ to yes to tapiridi maau ve yes parooŋa, le deŋia moghon. Ve tiyoon pa yes to tineep ila pataŋani lolo, ve yes to ledi ulaaŋ eta maau, ve tiuul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Tovenen yes to tapiridi iraua maau, ve yes mbolaaŋa, yam irau matamim padi, ve agham mulin di ila ndiran samsamia nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Eemoghon yam aghamgham tovene maau. Lemim ghilalooŋ maau. Ŋgar tiam ivot sone. Laghooŋ tiam, yam ataghon ŋgar to ndoroom. Tauto ŋgar ve tutuuŋ naol to tinim pughu pa nepooŋ poia izi taan, yam awaghamun di le tisami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Onoon, muuŋ you nawaat gham naghaze ndimaronŋa. Ve nasaav payam naghaze yam asob anim Maaron Tiina To Ilib Pa Ndimaronŋa Tisob Ne ndinatu. ");
INSERT INTO tuc_o_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Eemoghon yam pale asob amatmaat animale ival tiina to taan. Pale atap animale yes daba to taan, ve lemim izamim muul maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Maaron, umundig ve ughur atia pa ndiran samsamia to tineep izi taan. Pasa, ndug tisob to taan toman mbeb todi, nene yom tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","O Maaron, pughu vena to ugham mbeb eta maau, ve neneeŋam moghon? Vena to nimam ila murim, ve unepneep sorok? ");
INSERT INTO tuc_o_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Ughita. Koiamŋa tighaze tipamundigin malmal. Yes to tighur koi payom, tipakur taudi, ve tighamgham aghedi payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Tamtoghon tiom to lolom padi kat, koiamŋa tonowen tilup di, ve tikaal ataam pa tiwaghamun di. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Tighaze: “Anim tala ve tapasob yes Israela le tisob kat. Leso ledi izadi muul sob, ve tamtoghon lolodi imaagh padi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Onoon kat, koiamŋa tonowen tilup lolodi ve ŋgar todi inim ee moghon, ve timbua saveeŋ tighaze tizoor pooz tiom, ve tiwaghamun tamtoghon tiom. Yes tamtoghon to ndug tonene: ");
INSERT INTO tuc_o_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Yes Edoma ve Ismael papaghu toni, ve yes Moapa ve yes Agri, ");
INSERT INTO tuc_o_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ve yes to taan suruvu to Gebal toman yes Amona ve Amaleka, ve yes Pilistia ve tamtoghon to ndug Tiro. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Ve yes Asiria paam to ndiran ariaŋadi to malmal, tivool to yes Amona ve Moapa to Lot papaghu toni, leso tiuul di pa malmal. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Tovenen yei nitaŋ roran ghom nighaze ugham ŋgar raraate pa yes ndiran tonowen inimale muuŋ ugham pa yes Midiana, ve muri ugham pa Sisera yesuru Yabin izi ya Kison. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Sawa tonenen, yom urab di timatmaat izi ndug Endor, ve patudi tiwaghengheen ila taan ve timbuuz. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Yes daba to koiamai, ugham ŋgar raraate padi inimale muuŋ ugham pa Oreb yesuru Zeeb. Ve yes pooza todi tovene paam. Utatan di inimale muuŋ utatan Zeba yesuru Zalmuna. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Ndiran ru tonowen, muuŋ tisaav tighaze: “Maaron taan toni, le kikiliiŋ popoia. Tala taghami inim leed.” ");
INSERT INTO tuc_o_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Maaron tiou, ureu di le timbiriis tinimale ghavuur ve buzbuz to yaghur iviviira gha ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Uwaghamun di inimale yab ighan suvun reg, ve inimale yab ighan izala lolooz, le ipasob su. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Ugham uman tiina izi, ve yaghur tiina imundig, leso timatughez ve tighau. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O Yoova, utatan di. Leso mayadi kat, ve tighilaal tighaze yom izam tiina, ve tisuŋ payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ugham di tiwaghamgham, ve tineep toman mayadi itaghoni taghoni gha ila. Upamayaŋin di, ve upasob di. ");
INSERT INTO tuc_o_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Leso tighilaal tighaze: Yoova, yom moghon to izam tiina. Yom Maaron Tiina To Ulib Pa Ndimaronŋa Tisob, ve uŋgin taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","O Yoova, yom ariaŋam kat ve uŋgin mbeb tisob. You lolog pa rumai tiom kat. Nene poiawaat kat, ve inim inam to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","You nakausim naghaze le naneep ila sirsiir to rumai tiom lolo, ghoro poia. Maaron, yom uneep matam iyaryaar irau sawa isob. Tovenen lolog ve ŋgar tiou isob iŋaŋarua ghom, ve lolog poia kat, ve namboumbou payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yoova, yom ariaŋam kat, ve uŋgin mbeb tisob. Yom kinik tiou ve Maaron tiou. Man to tineep ila sirsiir to rumai tiom lolo, lolodi poia kat. Ve man gegegeu tireirei rumadi ila rumai tiom lolo, leso tineep tigharau artaal tiom, ve tipoop ndinatudi tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Yes to tinepneep ila rumai tiom lolo, poia tiom izaza todi, ve lolodi poia kat. Tauto timboumbou, ve tipapait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Yes to tighamgham tapiridi ilat tiom, poia tiom izaza todi, ve lolodi poia kat. Lolodi iyaryaaŋ tighaze le titaghon ataam to ila pa lolooz Zion, leso tisuŋ payom tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Sawa to tilaagh ila taan raapa to le ya maau, ya katindi bokbokia ila taan lolo ve tizaza. Maaron igham uman izi pa taan tonowen, tauto ya ipot irau ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Tovenen tamtoghon toni tapiridi ivotvot, ve tilaghlaagh titaghon ataam, le tila tivot Maaron nagho izi lolooz Zion. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Yoova, yom Maaron ariaŋam kat, ve uŋgin mbeb tisob. Ulooŋ suŋuuŋ tiou tonene. Maaron to Yakop, ughur taliŋam payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Maaron, suŋuuŋ tiei iŋarua ghom pa kinik tiei to yom taum usia. Matam pani, ve ughur poia tiom iza toni. Pasa, ye to inim sigeu payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Ighaze you naneep ila sirsiir to rumai tiom lolo pa ndag ee moghon kat, nene igham ghou lolog poia ilib pa sawa ndiŋndiŋ ndiŋndiŋ to naneep izi ndug pida. You lolog pa naneep toman ndiran samsamia ila ruum todi maau. You naghaze le naneep ataam avo to Maaron tiou rumai toni, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Maaron toit Yoova, ghazooŋa toni isul ghiit inimale ndag, ve ye inim sigeu pait. Ye ighamgham poian ghiit, ve igham izaad ivot inim tiina. Yes to laghooŋ todi deŋia ila mata, ye irau iŋguruut mbeb poia eta padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Yoova, yom ariaŋam kat ve uŋgin mbeb tisob. Yes to tinumeer ghom, poia tiom izaza todi, ve lolodi poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","O Yoova, muuŋ yom ughamgham poian ndug tiom. Yei to Yakop papaghu toni ne, sawa to nineep ila pataŋani lolo, yom uul ghei ve ugham ghei nineep poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ve sawa to tamtoghon tiom tigham sosor, yom upul sosor todi. Ŋgar todi to isosor ila matam, yom ureua isob ilale. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Yom utatan mbalmbali tiom, ve lolom poia padi muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ve aazne, nitaŋ roran ghom muul. Maaron, yom Volaaŋa tiei. Matam imuul payei, ve uul ghei. Leso nineep poia muul. Atem yabyab payei muul malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Vena, pale mbalmbali tiom izaza tiei irau sawa isob? Pale inepneep tovene itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Yei tamtoghon tiom. Tovenen matam imuul inim payei, ve upamundigin ghei muul. Leso lolomai poia payom, ve nipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Yoova, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Upatooŋ ŋgar tonenen payei muul, ve ugham mulin ghei. Leso nineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","You pale naghur taliŋag pa saveeŋ to Maaron ighaze ivotia pa tamtoghon toni. Pasa, you nawatag: Yoova pale isavia saveeŋ luuma pait. Tamtoghon toni to lolodi ineep tuŋia ila toni ve titaghon ataam toni, ye pale iuul di, leso tineep poia muul. Eemoghon tipatum di. Ŋgar to borouŋa to muuŋ tighamghami, tighami muul malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Onoon kat. Yes to timatughez pa Maaron ve titaghon ŋgar toni, ye inepneep igharau di, ve isasaŋan pa iuul di. Ye pale ineep toman ghiit, ve ipatooŋ tapiri ve poia toni ivot ighazooŋ izi taan tiei tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Maaron lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. Ve yes titaghon tutuuŋ toni. Tauto yesŋa tilup di tinim ee moghon. Yes titaghon ŋgar deŋia, ve ye igham di tineep pooi toman lolodi luuma. Tauto lupuuŋ todi ee moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Ŋgar to taghoniiŋ saveeŋ onoon, nene ivotvot izi taan. Ve Maaron ineep izi sambam, ve mata pait itaghon ŋgar toni deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Onoon kat, Yoova pale igham lemai mbeb popoia. Pale igham aniiŋ katindi tivot ila taan tiei. ");
INSERT INTO tuc_o_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Ŋgar deŋia, to imuŋmuuŋ pani, ve ighagharaat ataam pani pa inim. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","O Yoova, ughur taliŋam payou. Ulooŋ suŋuuŋ tiou tonene, ve uul ghou. Pasa, you naneep ila pataŋani lolo, ve nakalkaal ataam. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","You mbesooŋa tiom, ve nanumeer ghom. Lolog ineep tuŋia ilat tiom, ve nataghon ataam tiom. Yom Maaron tiou. Tovenen uvool tiou, ve ugham mulin ghou. Pa vene, namaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Tiina tiou, lolom isamin ghou ve uul ghou! Pasa ndag to naol ne, mboŋmaagh ila le rabrab izi, taŋiiz tiou iŋaŋarua ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Tiina, you mbesooŋa tiom. You nasuŋ payom toman lolog. Ugham lolog poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Tiina tiou, yom poiam kat, ve upulpul sosor to tamtoghon. Tamtoghon tisob to tisuŋsuŋ payom, lolom ineep tuŋia ila todi, ve uluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Tiina, ughur taliŋam pa suŋuuŋ tiou. Ulooŋ taŋiiz tiou tonene, ve uul ghou. Pasa, you mbesooŋa tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Sawa to naneep ila pataŋani lolo, you nataŋ roran ghom. Pasa, you nawatag: Yom pale ulooŋ suŋuuŋ tiou, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Tiina tiou, yom moghon to Maaron tau. Maaron ite paam raraate inimale yom maau. Eta irau igham uraat tintina inimale yom ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Yoova, yom ughur tamtoghon tisob tineep tirau ndug todi todi. Ndug naol pale tinim tiput aghedi payom, ve tipait izam pa tapirim ve poia tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Pasa, yom izam tiina, ve ughamgham mbeb gharatooŋadi tintina. Tovenen yom moghon to Maaron tau. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O Yoova, upatooŋ ataam tiom payou. Leso laghooŋ tiou deŋia itaghon saveeŋ tiom onoon. Ve ugham ghou naghur lolog payom kat. Leso namatughez payom, ve nataghon aliŋam. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Tiina, yom Maaron tiou. You lolog poia payom, ve napait ghom toman lolog. You pale napait izam pa tapirim ve poia tiom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Pasa, lolom ineep tuŋia inim tiou ve uluul ghou. Muuŋ, rismoghon tone nazila ndug to mateeŋa. Eemoghon ugham mulin ghou, tauto namaat maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Maaron, ughita. Aazne, ndiran samsamia timundig tighaze tiwaghamun ghou. Ndiran to didiaaŋ tilup di, ve tighaze tirab ghou namaat. Lolodi isamin tamtoghon eta maau, ve matadi iŋgal ghom rita maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Tiina, yom Maaron to lolom isasamin ghei, ve ughamgham poian ghei. Atem yabyab rikrikia maau. Poia tiom, nene tiina kat. Lolom ineep tuŋia inim tiei, ve uluul ghei, ve utaghon saveeŋ tiom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Tovenen matam imuul inim payou, ve lolom isamin ghou. Upalot ghou. Pasa, you mbesooŋa tiom. You nambesmbees payom inimale tinaŋ imbesmbees payom. Tovenen ugham mulin ghou pa pataŋani tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","O Yoova, ugham ŋgar eta, leso ipatooŋ ghou ighaze lolom poia payou. Ighaze uul ghou, ve ugham ghou ateg izi, nene pale koiagŋa tighita, ve tighilaal tighaze yom lolom payou. Ghoro mayadi ve neneeŋadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Yoova tau ipamundigin ndug toni izi lolooz toni patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Ye lolo pa ndug Zion kat ilib pa ndug naol to Yakop papaghu toni tinepneep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O Yerusalem, yom Maaron ndug toni. Tauto tamtoghon tipait varum kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Maaron isaav ighaze: “Yes Isipa ve Babilona pale tiwatag ghou, ve nawaat di tamtoghon tiou. Ve you pale nasaav pa yes Pilistia, yes to ndug Tiro, ve yes to Etiopia paam tovene: ‘Yam anim Yerusalem tamtoghona, raraate inimale yes to tipoop di izi sualen.’” ");
INSERT INTO tuc_o_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Onoon kat, pale tisavia ndug Zion tighaze: “Maaron Tiina To Ilib Pa Ndimaronŋa Tisob, ye igham tamtoghon to ndug naol tinim Yerusalem tamtoghona. Ndug tonowen, ye tau ipamundigini.” ");
INSERT INTO tuc_o_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Tovenen sawa to Yoova imbood tamtoghon toni izadi ila rau, ye pale imbood saveeŋ to ipaghazoŋan tamtoghon to ndug naol tonowen ighaze: “Yes paanu tau to Yerusalem.” ");
INSERT INTO tuc_o_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Tovenen tamtoghon pale lolodi poia, ve timboumbou ve titortor, ve tisaav tighaze: “A Yerusalem, yom unumale saambu to ya bokbokia izaza pani. Pasa, yom, tauto mbeb popoia katindi tivotvot payei!” ");
INSERT INTO tuc_o_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Yoova, yom Maaron tiou ve Volaaŋa tiou. Ndag to naol ne, nataŋtaŋ, ve taŋiiz tiou iŋaŋarua ghom naghaze uul ghou. Ve mboŋ paam, nanim naneep ila naghom, ve nasuŋsuŋ payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Ulooŋ suŋuuŋ tiou tonene. Ughur taliŋam pa taŋiiz tiou, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Pasa, pataŋani naol titatan ghou, ve naghita naghaze naneep ila naal avo wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Tamtoghon tighita ghou tighaze paam namaat ve nazila ndug to mateeŋa. Pasa, tapirig isob kat wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Tamtoghon tighita ghou nanimale namaat wa. Tauto lolodi imaagh payou, ve eŋgengou naneep. You nanimale ndiran to tirab di timatmaat, ve tisuruuv patudi tizila naal. Ve nanimale yes mateeŋa to yom irau uul di muul maau, ve lolom imaagh padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Yom ughur ghou nazila saambu to mateeŋa to izila le izila kat. Naneep sila kat ila ndoroom lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Mbalmbali tiom itatan ghou kat, inimale dibom tintina tipolpol izala poghog ve titatab ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Yom ugham nditag tipul ghou. Lolodi pa tighita ghou maau. Pasa, ŋgar to ugham payou ne, igham di tighita ghou nanimale mbeb samia. Nepooŋ tiou, nene inimale naneep ila ruum to yabyabuuŋ lolo, ve leg ataam pa navot maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Yoova, ndag to naol ne, you nakaak nimag iza, ve nataŋtaŋ roran ghom pa uul ghou. Lolog ipataŋan kat, ve nataŋ tiina le matag isarsar. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Laak, yom ugham mbeb gharatooŋa eta pa yes mateeŋa leso uul di? Ma mateeŋa irau timundig, ve tipait izam? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Ve yes to tineep ila naal lolo, tisasavia ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di? Ma yes to tineep izi ndug to mbeb tisamsami pani, tisavsaav pa ŋgar tiom to utataghon saveeŋ mbuaaŋ tiom? Maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Ve yes to tineep ila ndoroom lolo, tiwatag mbeb gharatooŋadi to ughamgham di ne? Ma mateeŋa to tamtoghon lolodi imaagh padi, matadi iŋgalŋgal ŋgar tiom deŋia? Maau kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Eemoghon you, ghoro nataŋtaŋ payom naghaze uul ghou. Yoova, mboŋmaagh to naol ne, suŋuuŋ tiou iŋaŋarua ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Yoova, vena to upul murim payou, ve uŋgooz matam payou? ");
INSERT INTO tuc_o_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Sawa to pain ghou ve inim, nambadbaad pataŋani tiina, ve nanepneep ila naal avo. Yom ughur pataŋani payou, ve upamatughezan ghou inimale koiam you. Tauto lolog ipataŋan kat, ve naghita naghaze narau mbeb eta muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Pasa, mbalmbali tiom itatan ghou kat. Yom uwaghamun ghou le namatughez kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Ndag to naol ne, mboŋmaagh ila le rabrab izi, nepooŋ tiou, nene inimale dibom inim toman tapiri, ve rismoghon tone izugua ghou nalaleg. Pataŋani naol tiluvut ghou, ve leg ataam pa napaghau taug maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Yom ugham nditag ve toŋvetaz tiou tipul ghou. Yes to muuŋ yeiŋa lupuuŋ tiei ee moghon, tigharau ghou muul maau. Aazne, ndoroom tiina ikau ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","O Yoova, you pale nambou ve napait ghom irau sawa isob. Pasa, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ve ŋgar tiom to utataghon saveeŋ mbuaaŋ tiom tovene paam, avog pale ivovotia pa tamtoghon to aazne, ve iseeŋga itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Pale navotia ghom pa tamtoghon naghaze: Ŋgar to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, nene pale inepneep tovene itaghoni gha ila. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tiom paam, nene ineep tuŋia irau sawa isob, inimale sambam paroŋania. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","4","Muuŋ, yom usaav ughaze: “You nasia mbesooŋa tiou David ve nambua saveeŋ tomani. Saveeŋ tonene, napariaaŋa le iyaryaaŋ kat naghaze: ‘You pale napalot papaghu tiom, ve naghur di tinim kinik irau sawa isob. Yes pale tineep ila inam to ghamuuŋ pooz, ve tiŋgin yes Israela itaghoni taghoni gha ila.’” ");
INSERT INTO tuc_o_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yoova, yes aŋela patabuaŋa tiluplup di izi sambam, ve tipapait izam pa mbeb gharatooŋadi to ughamgham di. Yes tipapakur ghom pasa, yom utataghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Yoova, sei to irau ghom? Yes to tineep izi sambam, yom ulib padi tisob. Aŋela eta irau ghom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Sawa to yes daba to aŋela patabuaŋa tilup di pa savsaveeŋ izi ndug sambam, yes tiyoon luvutin ghom, ve timatughez ve tapait ghom. Pasa, tapirim tiina, ve ulib padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yoova, yom Maaron ariaŋam kat, ve uŋgin mbeb tisob. Sei tapiri tiina kat inimale yom? Eta maau. Ve yom utortoor ŋgar tiom maau. Moghon moghon, utataghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Yom to uŋgin te. Ighaze yaghur tiina imundig, ve ipei dibom tintina, yom irau ugham dibom imaat, ve taun izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Muuŋ kat, yom urab balagin Rahab daba ve imaat. Nimam pataŋani. Tauto urab matin koiamŋa, ve ureu mbirisan di tighau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Sambam ve taan, nene tiom. Pasa, yom to ughur di toman mbeb tisob to tineep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Yom ughur taan to ineep ila pa rag, ve ila imuul yavaar pughu. Lolooz Tabor ve lolooz Hermon lolodi poia, ve timboumbou ve tipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Yom ariaŋam ve tapirim tiina. Nimam waan, nene ariaŋa ve ŋguruba kat. Tauto urab koiamŋa ve ulib padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ŋgar deŋia toman ŋgar to gabizooŋ tamtoghon itaghon ŋgar deŋia, tauto inim pughu pa pooz tiom. Ve ŋgar tisob to ughamgham di, nene tipatooŋ ghom tighaze: Lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, ve utataghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Yes to tilup di pa suŋuuŋ, ve tilolool ve tipait izam, tilaghlaagh ila ghazooŋa tiom, ve poia tiom izaza todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Yes tiwatag ghom toman ŋgar tiom. Tovenen ndag to naol ne, mboŋmaagh ila le rabrab izi, lolodi poia kat, ve tipapait izam pa ŋgar tiom deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Yei nigham tapirimai ilat tiom, tauto tinimai iza, ve izamai ivot inim tiina. Poia tiom, tauto igham tapirimai ivot le nilib pa koiamai. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Yoova, yom usia ŋgeu to inim sigeu payei. Ye to iponpoon koiamai. Maaron patabuaŋ to yei Israela, yom ughur lemai kinik pa igham pooz payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yes to lolodi ineep tuŋia ilat tiom ve titaghon ataam tiom, muuŋ kat, yom upaghazoŋan di pa ŋgar to ughaze ughami. Yom usaav padi ila tandagiiŋ ughaze: “Ndaaba ariaŋa eez inepneep ila lolomim. You taug nasia ve naghuri inim kinik. Tauto nauuli ve nagham iza ivot inim tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","You naghita mbesooŋa tiou David, ye iraua. Tauto naliŋ ŋgoreeŋ tiou patabuaŋ izala daba, ve naghuri pa uraat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ye pale inepneep ila nimag, ve napaloti irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Tovenen koiŋa irau tilib pani maau, ve ndiran samsamia irau titatani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Pasa, you taug pale namuuŋ pani, ve natatan koia le tapiridi isob. Yes to tighur koi pani, you pale narab di tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","You pale nataghon saveeŋ mbuaaŋ to nagham pani, ve lolog ineep tuŋia ila toni, ve naghur poia tiou izaza toni. Pale naneep tomani ve napaloti, leso tapiri ivot inim tiina, ve ilib pa koia. Tovenen iza pale inim tiina kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","You pale nagham ival tiina tineep ila samba. Yes to tineep izi naari to Te Mediterenian, ve ila imuul ya Euprates dige. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ye pale isaav payou ighaze: ‘You Tamaŋ yom. Yom to Maaron tiou, ve Volaaŋa tiou ariaŋa. Yom uponpoon ghou pa koiagŋa unumale yaam tiina.’ ");
INSERT INTO tuc_o_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ve you pale naghami inim natug aidaba. Tovenen ye pale iza tiina kat, ve ilib pa kinik tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Pale lolog ineep tuŋia ila toni ve nauuli irau sawa isob. Ve saveeŋ to nambua pani, tovene paam. Pale ineep tuŋia tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Siŋ toni irau isob maau. Pale naŋgin papaghu toni, ve tineep pooi itaghoni taghoni gha ila tinimale sambam paroŋania. Pale tineep ila David ina to ghamuuŋ pooz, ve tiŋgin yes Israela irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Eemoghon ighaze papaghu toni tipul muridi pa saveeŋ tiou, ve laghooŋ todi, tisosor pa tutuuŋ to naghuri, ");
INSERT INTO tuc_o_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ma tiveleg tutuuŋ tiou to ineep pataghaaŋ inimale mbeb sorok, ve timalaaŋ pa tutuuŋ tiou ŋgara, ");
INSERT INTO tuc_o_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","nene pale naŋgal matadi pa ŋgar todi to zoraaŋ saveeŋ, ve nalos matin di pa sosor todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","34","Eemoghon ŋgar to lolog ineep tuŋia ila to David ve papaghu toni, ve nauluul di, nene irau napuli maau. Pale inepneep tovene itaghoni taghoni gha ila. Ŋgar tiou to natataghon saveeŋ tiou, nene irau napuli maau. Tovenen saveeŋ to nambua toman David, irau nareua maau. Saveeŋ to ivot ila taug avog, irau natoora maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Pasa, you Maaron patabuaŋ. Tovenen saveeŋ mbuaaŋ tiou to napariaaŋa le iyaryaaŋ kat, nene pale inepneep tovene itaghoni taghoni gha ila. Irau natombaan David maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Tovenen siŋ toni irau isob maau. Pale iseŋseeŋga itaghoni taghoni gha ila. Pale matag padi, ve pooz todi iyaryaaŋ inimale ndag, ve inepneep tovene. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Pooz todi pale tuŋia irau sawa isob inimale kaiyo. Kaiyo to ineep ila sambam paroŋania, nene ipatooŋ saveeŋ mbuaaŋ tiou tonene ighaze, nene onoon.” ");
INSERT INTO tuc_o_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Yoova, muuŋ yom umbua saveeŋ ariaŋa tovene pa David ve papaghu toni. Eemoghon aazne, atem yabyab kat pa kinik tiei to taum usia ve ughuri pa uraat. Yom lolom pani muul maau, ve upul murim pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Saveeŋ mbuaaŋ to muuŋ ugham pa mbesooŋa tiom, aazne ureua wa. Ve uzugua moghar toni izi pa daba, ve upiyaava izila ghavuur. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Didiiŋ ariaŋa to iluvut ndug toni, yom ureu mbirisani izi. Ve uwaghamun ruum toni ariaŋadi paam, le tisob timbiriis. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Tovenen tamtoghon tisob to tilala tinimnim, tiyubyub mbeb toni. Ve yes ndug ndug to tineep tigharaui, tivelegi ve tighamgham ŋalalaŋ pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Yoova, yom taum upalot kinik tiei koia, ve tiparab ariaŋa le tilib pani. Tauto tisob lolodi poia, ve tipakur taudi. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Sawa to kinik tiei igham malmal, yom upaloti maau, ve upamuul buza toni mata imuul pa tau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Tovenen mbeb toni popoia to ye iza tiina pani, yom uŋguaaz di pani, ve ureu ina to ghamuuŋ pooz izi taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ye ŋgeu paghu. Eemoghon ugham koia tilib pani, tauto igharaat tau maau, ve ipul tau. Taghita inim olman waat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O Yoova, pale ŋeez o matam inim payei muul? Vena, pale uŋgooz matam payei, ve mbalmbali tiom izaza tiei itaghoni taghoni gha ila? ");
INSERT INTO tuc_o_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yoova, matam iŋgal: Yei tamtoghon to taan nineep mala maau. Onoon, yom taum ughur ghei. Eemoghon, pale nisob nimatmaat ninim mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Sei irau imaat maau, ve ineep mata iyaryaar itaghoni taghoni gha ila? Ma sei irau ipaghau tau pa mateeŋ? Eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Yoova, muuŋ yom umbua saveeŋ toman David, ve upariaaŋa le iyaryaaŋ kat ughaze pale lolom ineep tuŋia ila toni, ve uuli irau sawa isob. Eemoghon aazne, poia tiom tonanan ineep sine? Vena to utaghon saveeŋ mbuaaŋ tiom muul maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","O Yoova, you mbesooŋa tiom. Matam iŋgal ghou ve uul ghou lak! Pasa aazne, ndug ndug tipamayaŋin ghou, ve tiveleg ghou le lolog isami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yoova, yom taum usia ghou, ve ughur ghou nanim kinik. Ughita. Ndug sine to nala pani, nene koiamŋa tiwamogheran di payou, ve tipiyaav saveeŋ velegiiŋ payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Tapait Yoova pa poia toni irau sawa isob. Onoon le onoon kat! ");
INSERT INTO tuc_o_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","O Tiina, muuŋ ve inim, yom unum inamai to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Yom Maaron to uneep irau sawa isob. Muuŋ kat, sawa to ugham taan ve lolooz tivot sone, yom unepneep. Ve yom pale unepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Yom ugham yei tamtoghon to taan nimaat ninim ghavuur. Yom usaav payei ughaze pale nimaat ve nizila ninim taan muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Yom ughita ughaze ndaman ndiŋndiŋ eez (1000), nene sawa tuku moghon. Ila ŋgar tiom, nene inimale noor ve inim aazne. Ve inimale sawa tuku to mboŋ to yes ndaaba tiyoon, ve tipamaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","6","Yom upasob nepooŋ tiei, inimale tamtoghon igheen ve ivib, ve isob. Yei ninimale kananaŋ to ighaze ndag iza, ruŋgu ivavaal, ve ghitooŋa poia. Ve ighaze rabrab izi, ghoro imalai ve itap. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Mbalmbali tiom ipapasob ghei. Tiom imozmoz ghom pa sosor tiei, ve ughurghur atia payei. Tauto matughezaaŋ tiina igham ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Pasa, ŋgar tiei tisob to tiyel pa ŋgar tiom, yom matam kisin di. Sosor tiei to ŋgozaaŋ, tisob tineep ghazooŋa ila matam. Eta iyooŋ maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Tovenen sawa isob to nineep izi taan, mbalmbali tiom izaza tiei. Tauto nineep sawa tuku moghon, ghoro yaghuramai isob, ve nimaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nineep irau ndaman tamoot tol saaŋgul (70) moghon, ve nimaat. Ve ighaze tapirimai iraua, ghoro nineep irau ndaman tamoot paaŋ (80) ma venen. Ve ndaman tiei to naol ne, nirabrab taumai pa uraat, ve nimbadbaad pataŋani. Sawa samia, ve sawa poia paam. Nighamgham tovene ila le rikia moghon nivot pa sawa tiei, ghoro nisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Maaron, sei ighilaal katin mbalmbali tiom tapiri? Mbalmbali tiom to iŋaŋarua ghei ne, sei ighazooŋ pani, leso imatughez payom, ve itaghon aliŋam? Eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Tovenen ugham ghei nighilaal nighaze nepooŋ tiei to taan, nene tuku kat. Leso ŋgar tiei ivot, ve nighilaal ataam to nineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Yoova, ŋeez o utoor ŋgar tiom, ve matam inim payei muul? Lolom isamin ghei ve uul ghei. Pasa, yei mbesooŋa tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Mboŋmaagh to naol ne, nighaze upavonin ghei pa poia tiom, ve upatooŋ ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Leso lolomai poia ve tinimai iza, ve nimboumbou ila le sawa tiei isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ugham sawa poia ivot. Leso lolomai poia, ve iyat ndaman katindi to ughur pataŋani payei ve nineep sami. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Yei mbesooŋa tiom nighaze nighita ghom ugham uraat tintina tivot muul. Ve papaghu tiei to muri pale tivot ne paam, nighaze upatooŋ tapirim padi toman poia tiom to izam tiina pani, ve tighita. ");
INSERT INTO tuc_o_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Yoova, yom Maaron tiei. Lolom poia payei, ve ughur poia tiom iza tiei. Leso uraat to nighamghami pa nimamai ilaan poia. Upalot uraat tiei. Leso anoŋa ivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Ighaze ŋgeu eta iyooŋ ila to Maaron Ariaŋa To Ilib Pa Ndimaronŋa Tisob, ye pale ineep pooi ila Maaron samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Ye irau isaav pa Yoova ighaze: “Maaron tiou, you nanumeer ghom. Yoova, yom unum inag to yoŋgaaŋ, ve uponpoon ghou pa koiagŋa unumale didiiŋ ariaŋa.” ");
INSERT INTO tuc_o_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Onoon kat, ye pale ipaghau aghem pa liis to koiamŋa tighuri payom. Ve ipaghau moroghooŋ samia payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Pale iŋgin ghom ila nima samba inimale tatareek ipakud ndinatu ila bage samba. Yes to tiyooŋ ila toni, pale tineep pooi. Pasa, ye itataghon saveeŋ mbuaaŋ toni. Ŋgar tonenen pale inim sigeu payom, ve ipoon ghom pa mbeb samsamia. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Tovenen yom irau umatughez pa mbeb samsamia to mboŋ maau. Ve ndag paam, irau umatughez pa koiamŋa pane todi ndinatu maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Tovenen moroghooŋ samsamia to ighamgham tamtoghon pa mboŋ, ve pataŋani to irabrab di pa ndag, yom irau umatughez padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ighaze tamtoghon ndiŋndiŋ eez (1000) timatmaat ve titaptap ila digem, ma tamtoghon ndiŋndiŋ saaŋgul (10,000) to tiluvut ghom timatmaat, yom umatughez malep. Pasa, mbeb samia eta irau inim igharau ghom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Atia to iza to ndiran samsamia, yom pale unepneep, ve ughita katini pa taum matam. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Pasa, yom uyoŋyooŋ ila to Yoova, ve ye inim inam to nepooŋ. Maaron Tiina To Ilib Pa Ndimaronŋa Tisob iŋgin ghom. Tauto uneep pooi ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Tovenen mbeb samia eta irau iwaghamun ghom maau, ve moroghooŋ samia eta irau igharau inam to nepooŋ maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Pasa, Maaron pale imbaaŋ aŋela toni pa tiŋgin ghom. Ndug sine to ughaze ula pani, yes pale matadi payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Pale tikis ghom pa nimadi, ve tipalot ghom. Leso utut aghem ila yaam sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ighaze utut laion paghu, ma uvazag moot samia eta, nene irau tigham mbeb eta payom maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Pasa, Yoova isaav ighaze: “Yes to lolodi ineep tuŋia inim tiou ve titaghon ataam tiou, you pale napas di tivot pa pataŋani todi. Ve you pale naghur di tizala sala, ve matag padi. Leso mbeb eta iwaghamun di sob. Pasa, yes tiwatag ghou, ve lolodi ineep tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ighaze titaŋ roran ghou, you pale nalooŋ di. Sawa to tineep ila pataŋani lolo, you pale naneep toman di. Pale nauul di, ve napakur di. ");
INSERT INTO tuc_o_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","You pale naseeŋ sawa todi ila mala, leso tineep toman lolodi poia. Ve napatooŋ ulaaŋ tiou ivot ighazooŋ padi.” ");
INSERT INTO tuc_o_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Yoova, yom Maaron To Ulib pa Ndimaronŋa Tisob. Ighaze you napait ghom pa poia tiom, ve nambou pa napait izam, nene igham lolog poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Mboŋmaagh to naol ne, navovotia ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ve mboŋ, you navovotia gabuam to utataghon saveeŋ mbuaaŋ tiom. Ŋgar tovene igham lolog poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","You narabrab gita ve kulele, ve namboumbou pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Pasa, Yoova, uraat tiom igham lolog poia kat. Matag ilala pa mbeb naol to nimam igharaat di, ve nambou toman tinig iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yoova, uraat to yom ughamgham di, nene tintina kat. Ve ŋgar tiom paam, pughu ariaŋa. Ila le ila kat. Tovenen nagham ŋgar pani, eemoghon naraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Eemoghon yes kankanooŋa tighilaal maau. Ŋgar todi inimale borouŋa. Tauto pataŋani to pale ivot pa ndiran samsamia, yes tigham ŋgar pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Onoon, aazne ndiran samsamia tivot tinim naol tinimale kikiliiŋ samsamia to tisaas le tirau ndug. Ve yes to tinoknok ghamuuŋ sosor, taghita taghaze nepooŋadi, poia kat. Eemoghon muri, yom pale upasob di, le tisob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","O Yoova, yom uneep sala, ve ughamgham pooz irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Onoon kat, koiamŋa to tighamgham ŋgar samia, yom pale ureu mbirisan di, ve tisob tilaledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Eemoghon you, yom upakur ghou, ve ugham tapirig ivot tiina inimale makau sagsag. Ve poia tiom izaza tiou, inimale tiliŋ ŋgoreeŋ poia izala poghog. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Yom utatan koiagŋa, ve tisami ila matag. Yom uwaghamun ndiran samsamia tonowen, ve nalooŋ katin taŋiiz todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Eemoghon ndiran deŋiadi pale tineep pooi, ve ŋgar popoia katindi tivotvot ila lolodi inimale niu rabu. Ve irau tisami maau. Pale tiyoon tuŋia ve tineep mala, tinimale ai mendepur tintina to Lebanon. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Yes tinimale ai to tivazog di ila rumai patabuaŋ to Yoova dige. Pale tineep pooi ilooŋ ila Maaron toit rumai toni sirsiira. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Ve sawa to tinim ndolman watwaat, tapiridi inepneep sone, ve tighamgham ŋgar popoia tivotvot, tinimale ai papaghu to anoŋadi katindi. ");
INSERT INTO tuc_o_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Ve tivovotia saveeŋ tovene tighaze: “Yoova iponpoon ghou inimale raŋ to izala kat. Sosor eta ineep toni maau. Ŋgar toni isob, nene deŋia moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yoova, ye kinik tiina to ighamgham pooz pa mbeb tisob. Ŋguruba toman tapiri, tauto tiluvuti tinimale nonogiiŋa toni. Muuŋ kat, ye ighur taan le pughu tuŋia kat. Tauto mbeb eta irau induura maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Yoova, muuŋ kat, sawa to ughur mbeb eta ivot sone, yom uneep pataghaaŋ wa. Sawa tonowen ve inim, pooz tiom ineep ariaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yoova, te imundig toman tapiri ighaze ireu ndug, ve avolutu tiina inimale lalaav. Dibom tipolpol, ve tighelghel taan toman avolutu tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Eemoghon Yoova, yom ariaŋam kat. Yom uneep sala, ve ughamgham pooz pa mbeb tisob. Te to avolutu tiina inimale lalaav ne, tapirim ilib pani. Ve dibom tovene paam, tapirim ilib padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","O Yoova, ataam to yom ughuri pa tamtoghon tiom, leso yamŋa alup gham anim ee moghon, nene ineep tuŋia tovene irau sawa isob. Irau utoora maau. Ŋgar patabuaŋ pale ipambood rumai tiom itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O Yoova, yom Maaron to uyatyat ŋgar samia to tamtoghon. Upatooŋ ŋgar tiom deŋia ivot ighazooŋ, ve ughur atia pa ndiran samsamia. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Pasa, yom to uŋgagabiiz tamtoghon tisob to taan, ve ughurghur atia padi. Tovenen umundig ve ughur atia iŋarua yes to tipapait taudi. Upamuul ŋgar todi samsamia imuul ila pa taudi, ghoro deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O Yoova, ndiran samsamia tighamgham tinidi, ve lolodi poia pa ŋgar to tighamghami we. Pale ŋeez o upasob ŋgar todi tonowen? ");
INSERT INTO tuc_o_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Yes to tighamgham ŋgar samia, saveeŋ pakuruuŋ naol ivotvot ila avodi. Aliŋadi izaza, ve tipapait taudi pa ŋgar todi tighaze yes tiraua. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yoova, ughita. Yes tighamgham samin tamtoghon tiom. Yes to ugham di tinim lem, ndiran tonowen tighamgham pataŋani tiina padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Ve tirabrab ndinaara toman parooŋa timatmaat. Ve loomba to tineep toman ghei izi ndug tiei ne, tirab di paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Ve matadi velegin ghom tighaze: “A, Yoova ighita ghiit? Ŋgar to taghamghami ne, Maaron to Yakop irau mata ila pani maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Yam ndiran samsamiamim, lemim ŋgar maau animale borouŋa! Pale ŋeez o ŋgar tiam ivot, ve aghilaal? ");
INSERT INTO tuc_o_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Maaron to igharaat taliŋamim. Irau ilooŋ saveeŋ tiam maau? Ve ye to igharaat matamim. Irau ighita gham maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ye ighurghur pataŋani pa tamtoghon to ndug ndug, leso ipasaluŋgan di. Pale ighurghur gham? Ve ye to ighamgham ŋgar pa tamtoghon. Vena, aghaze ye le ŋgar maau? ");
INSERT INTO tuc_o_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Ŋgar naol to tineep ila iit tamtoghon lolood, Yoova iwatag di le tisob. Ve ye iwatag: Sawa naol, ŋgar toit anoŋa maau. Nene isob rikia moghon inimale yaghuraad to ivotvot ila avood. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yoova, tamtoghon to ighaze yom ughur pataŋani pani pa upasaluŋgani, ve upaghazoŋani pa tutuuŋ tiom, nene pale poia tiom iza toni, ve lolo poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Tamtoghon tovene, ighaze ineep ila pataŋani, yom pale uuli. Leso ate izi, ve inamnaam le irau titai saambu pa yes ndiran samsamia, ve titap tizila. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Yoova irau ipul muri pa tamtoghon toni ne maau. Yes to ye igham di tinim le, lolo imaagh padi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ve ye pale ipasaluŋgan yes pooza, leso tigharaat pataŋani to tamtoghon itaghon ŋgar deŋia. Ve tamtoghon tisob to ŋgar deŋia ineep tuŋia ila lolodi, yes pale tipalot ŋgar tovene paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Ighaze tamtoghon tigham samin ghou, sei pale iyoon payou ve iuul ghou? Ve sei to iponpoon ghou pa ndiran samsamia? Ite paam maau. Yoova moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Inimale Yoova iuul ghou maau, tone namaat rikia moghon, ve nala ndug to le oroora maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Yoova, sawa to naghaze pale natap pa ghurla tiou, ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, tauto ipalot ghou ve nayoon tuŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Ve sawa to lolog ipataŋan, ve nagham ŋgar naol, yom urab ateg, ve ugham lolog poia muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Yes pooza samsamia to tighurghur tutuuŋ naol pa tiwaghamun tamtoghon, yom irau ula toman di pa ŋgar todi tonowen maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Yes tilup di, ve timbua saveeŋ tighaze tiwaghamun ndiran deŋiadi. Ve yes to ledi sosor maau, yes pooza tonowen tighur saveeŋ tighaze yes pale timaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Eemoghon Yoova, ye inim didiiŋ ariaŋa payou, leso nayooŋ ila. Maaron tiou iponpoon ghou inimale raŋ to izala kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Pale ipamuul ŋgar samsamia to ndiran tonowen imuul pa taudi, ve iwaghamun di. Pale ipasob di toman ŋgar todi samsamia tonowen. Maaron toit Yoova pale ipasob di le tisob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Anim, tambou ve tapait Yoova. Tiniid iza, ve talool. Pasa, ye Volaaŋa toit ariaŋa to iponpoon ghiit pa koiaad inimale yaam tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Anim tala tayoon ila nagho, ve tapaiti pa poia toni. Aliŋaad iza, ve tambou toman tiniid iza, ve tapaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Pasa, Yoova, ye Maaron tiina. Ye kinik tiina kat to ilib pa ndimaronŋa tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Mbeb to taan tisob tineep ila nima. Taan pughu to sila we, le izala lolooz daba paam, ye iŋgin di tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Te toman taan, mbeb toni moghon. Pasa, ye nima to ighur di. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yam anim talup ghiit, ve tasuŋ pa Yoova. Tatud pani ve taput agheed, ve tapaiti. Pasa, ye to ighur ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Ye Maaron toit, ve iit sipsip toni. Ye iŋgin ghiit ve mata pait. Taneep ila ye nima, ve tau ipanpan ghiit. Aazne, ighaze yam alooŋ Yoova aliŋa ve ataghoni, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Ye isaav payam ighaze: “Apoon lolomim payou, ve azoor ghou inimale muuŋ nditimbumim tighami izi ndug balim to Meriba ve Masa ne malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Sawa tonenen, you nagham uraat tintina ila lolodi, ve tighita pa taudi matadi. Eemoghon tighur inim tiou maau. Ve tinoknok tovaaŋ ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Tauto lolog padi maau kat irau ndaman tamoot ru. Ve nasaav naghaze: ‘Ndiran tonowen, lolodi pa titaghon ŋgar tiou maau. Moghon moghon tiyel pa ataam tiou.’ ");
INSERT INTO tuc_o_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Tauto nasaav ariaŋa padi toman ateg yabyab, ve napariaaŋ saveeŋ tiou naghaze: ‘Onoon kat. Ndug to naghaze atedi izi pani, yes irau tilooŋ tila maau. Maau le maau kat!’” ");
INSERT INTO tuc_o_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Ambou mbouŋ paghu pa Yoova! Yam tamtoghon to aneep irau taan, ambou pa Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Ambou pani, ve apait iza pa poia toni. Uraat tintina to ye ighamgham di pa iuul ghiit, asasavia di irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Avotia iza tiina toman tapiri ve poia toni irau ndug tisob. Ve uraat toni gharatooŋadi to ite kat, asavia di irau ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Pasa, Yoova, ye iza tiina kat. Tovenen iit irau tapait varu le tapaiti kat, ve tamatughez pani ilib pa ndimaronŋa tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Pasa, ndimaronŋa tisob to ndug ndug timbesmbees padi, nene maaron kaaromŋa moghon. Ve Yoova, ye Maaron tau to ighur sambam toman mbeb tisob to tineep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Ye iza tiina kat, ve ŋguruba iluvuti. Tapiri ve poia toni ipavonin rumai toni lolo, ve ipambooda le paghuna kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Tovenen yam tamtoghon to ndug ndug, ŋgar tiam ivot, ve aghilaal Yoova! Ŋgar tiam pakia ve apaiti. Pasa, ye le iza, ve tapiri tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Iza tiina le tiina kat. Tovenen yam apaiti, ghoro deŋia. Anim toman paitooŋ tiam, ve alooŋ ala sirsiir to rumai toni lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Yoova ipambood tau pa ŋgar toni patabuaŋ. Tovenen aput aghemim pani ve apaiti. Yam tamtoghon to taan, asob amatughez pani, ve atatan taumim ila mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Asaav pa ndug tisob aghaze: “Yoova, ye kinik tiina to iŋgin mbeb tisob! Muuŋ, ye ighur taan le pughu tuŋia. Tauto mbeb eta irau induura maau. Pale iŋgabiiz ndug ndug, ve ighur atia padi. Ve gabizooŋ toni, nene deŋia moghon.” ");
INSERT INTO tuc_o_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Yam mbeb to sambam ve taan, lolomim poia ve tinimim iza. Ve te toman mbeb tisob to tineep ila lolo ne paam, aliŋamim iza tiina ve apait Yoova. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Ve uum to naol ne, toman mbeb tisob to titub ila lolodi, lolomim poia ve tinimim iza. Ve ai toman mbeb tisob to su lolo paam, aliŋamim iza, ve alool ve apaiti Yoova iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Pasa, ye ighaze inim. Leso iŋgabiiz tamtoghon tisob to taan, ve ighur atia padi. Ye pale iŋgin tamtoghon tisob to taan, ve iŋgabiiz di. Ve gabizooŋ toni, nene deŋia ve onoon moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yoova, ye kinik tiina to iŋgin mbeb tisob. Tovenen yam tamtoghon to aneep irau taan, lolomim poia. Ve yam mutua tovene paam, tinimim iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Yoova iŋgozgooz tau ila yaghur tae asosooŋa, ve ndoroom ikaui. Ŋgar deŋia toman ŋgar to ulaaŋ, tauto inim pughu pa pooz toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ye igham yab ighan imuuŋ pani, ve ighan koia tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Ye igham ndug milia irau taan. Tovenen taan ighita, ve irur. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yoova, ye tiina to iŋgin taan isob. Sawa to ye inim ve ipatooŋ tapiri, lolooz tisob tireer, ve timbiriis ila nagho. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Mbeb naol to tineep ila sambam paroŋania, tipatooŋ Yoova tighaze ŋgar toni deŋia moghon. Ndug tisob tighita mbeb tonowen, ve tighilaal Yoova tighaze ye iza tiina. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Tamtoghon tisob to timbesmbees pa maaron kaaromŋa anunudi, Yoova igham di mayadi. Pasa, maaron kaaromŋa todi tirau mbeb eta maau. Maaron todi tonowen pale tisob tiput aghedi pa Yoova, ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Maaron, yes to ndug Zion tilooŋ varum pa uraat to yom ughamghami, le lolodi poia. Ve ndug ndug to Yuda paam, tisob tinidi iza. Pasa, yom uyondyood pa tamtoghon tiom, ve uluul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Yoova, yom Maaron Tiina. Tamtoghon tisob to taan tineep ila sambam. Yom izam tiina le tiina kat. Ulib pa ndimaronŋa tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yoova lolo pa yes to tighurghur koi pa ŋgar samia. Tamtoghon toni to lolodi ineep tuŋia ila toni, ve titaghon ataam toni, ye inim sigeu padi, leso mbeb eta iwaghamun di sob. Ve ighamgham mulin di ila ndiran samsamia nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Ye ighurghur ghazooŋa pa ndiran deŋiadi. Yes to ŋgar deŋia ineep tuŋia ila lolodi, ye igham di lolodi poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Yam ndiran deŋiamim, tinimim iza pa Yoova! Apaiti pa poia toni, ve apakur iza patabuaŋ! ");
INSERT INTO tuc_o_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Ambou mbouŋ paghu pa Yoova! Pasa, mbeb gharatooŋadi to ye ighamgham di, nene ite kat. Nima waan iparab ariaŋa le ilib pa koia wa. Ye ipatooŋ tapiri patabuaŋ, ve igham mulin tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yoova ivotia ulaaŋ tiina to ye igham pa tamtoghon toni. Ye ipatooŋ ŋgar toni deŋia ila ndug ndug matadi, ve tighita katini wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Saveeŋ to ye imbua toman yes Israela, mata iŋgalŋgali, ve itataghoni. Tauto lolo ineep tuŋia ila todi ve iuluul di. Maaron toit iparab ariaŋa, ve igham mulin ghiit ila ndug tisob to taan matadi, ve tighita wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Yam taan to naol ne, asob lolomim poia pa Yoova, ve alool ve apait iza. Tinimim iza pani, ve ait mbouŋ pa apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Apambar ambam ve arab gita, ve ambou pa apait Yoova! Apambar ambam ve arab gita le titaŋ poia, ve apakuri. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Yoova, ye kinik tiina. Tinimim iza pani, ve avib tavuur toman trampet ila nagho, ve alool ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Te toman mbeb naol to anepneep ila te lolo, yam alool ve apait Yoova! Ve taan toman tamtoghon ve mbeb naol to anepneep ila taan, yam paam, alool ve apaiti! ");
INSERT INTO tuc_o_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Ve ya to naol ne paam, asob apambar nimamim pani, ve apaiti. Ve yam lolooz, asob alup avomim, ve ambou toman lolomim poia izi Yoova nagho, ve alool ve apait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Pasa, ye ighaze inim. Leso iŋgabiiz tamtoghon tisob to taan, ve ighur atia padi. Pale iŋgabiiz ndug tisob to taan. Ve gabizooŋ toni, nene deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yoova, ye kinik tiina to iŋgin mbeb tisob. Tovenen yam ndug ndug asob amatughez pani, ve tinimim irur. Ye ineep ila ina to ghamuuŋ pooz to ineep izala aŋela ariaŋadi avaradi. Tapiri igham taan irur ve ilala inimnim inimale yoŋgyoog itoktok. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yoova inepneep izi ndug toni Zion. Iza toman tapiri, tiina kat. Ndug tisob tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Yoova, yom izam tiina, ve tapirim paam, tiina kat. Ve yom patabuaŋ. Tauto tamtoghon tisob pale timatughez payom, ve tipait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Yom kinik ariaŋam, ve lolom pa ŋgar deŋia kat. Yom to unum pughu pa ŋgar deŋia. Yom upapalot ŋgar deŋia le ineep ariaŋa ila yes Israela lolodi, ve uluul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Tapait Yoova, ye Maaron toit. Tala taput agheed izi ina to ghamuuŋ pooz nagho, ve tapaiti. Pasa, ye patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Muuŋ, Mose yesuru Aron tinim ndiran to watooŋrau. Tamtoghon to titaŋ roran Maaron pa ulaaŋ, propet Samuel, ye todi eez paam. Ve Yoova ilooŋ suŋuuŋ todi, ve iuul yes Israela. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Sawa to yes Israela tilaghlaagh izi ndug balim, Yoova ineep ila yaghur tae lolo, ve isavsaav padi. Ye ighur tutuuŋ padi, leso yesŋa tilup di tinim ee moghon. Ve matadi kisin tutuuŋ tonowen toman tutuuŋ pida to ye igham padi, ve titaghon di. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yoova, yom Maaron tiei. Yom uloŋlooŋ suŋuuŋ to tamtoghon tiom, ve upulpul sosor todi. Eemoghon ughurghur atia pa sosor todi paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Tapait Yoova, ye Maaron toit. Taput agheed pani izi lolooz toni patabuaŋ, ve tapaiti. Pasa, Maaron toit Yoova, ye patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Yam tamtoghon to aneep irau taan isob, tinimim iza pa Yoova, ve alool ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Lolomim poia ve ambesmbees pani. Anim alup gham ila nagho, ve ambou pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Lolomim imaagh pa Yoova malep. Aghilaala aghaze: Ye moghon to Maaron tau. Ye to ighur ghiit, ve iit tamtoghon toni. Iit sipsip toni. Tauto mata pait, ve iŋginŋgin ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Lolomim poia pani, ve ataghon ataam to Rumai Tiina, ve alooŋ ala. Apaiti ve alooŋ ala sirsiir toni lolo. Lolomim poia pani, ve apait iza pa poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Pasa, Yoova ŋgar toni, nene poia moghon. Lolo ineep tuŋia ila to tamtoghon toni, ve iuluul di irau sawa isob. Pale itaghon saveeŋ mbuaaŋ toni, itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","O Yoova, you nambou mbouŋ tonene pa napait ghom. Pasa, yom utaghon ŋgar deŋia moghon. Ve lolom ineep tuŋia ila to tamtoghon tiom, ve uluul di itaghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","You naghaze le naneep deŋia moghon ila matam. Tovenen you pale nataghon ŋgar deŋia moghon ila ruum tiou, ve nagham pooz pa tamtoghon tiou itaghon ŋgar deŋia. Ve ŋeez o unum uul ghou? ");
INSERT INTO tuc_o_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","You irau nayok pa mbeb samia eta ineep ila matag maau. Ve yes to tiyel pa ataam tiom, you naghur koi padi, ve nandiir di tighaughau. Irau tilup toman ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","You pale naneep saguan pa ŋgar kaarom. Ŋgar tovene, eta irau ineep tiou maau. Ve ŋgar samia tovene paam, irau matag ila pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Yes to tiŋgal saveeŋ pa nditadi inim ŋgozaaŋ, you pale nawaghamun di, leso napoon avodi. Ve yes to tipakur taudi tighaze izadi tintina, ve tiveleg nditadi ve titatan di, nene irau napul di tineep maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Eemoghon taan tonene tamtoghona to avodi onoon ve titaghon ataam tiom, you nakalkaal di naghaze tinim tineep toman ghou. Ve yes to laghooŋ todi deŋia moghon, you naghaze nagham di tinim mbesooŋa tiou, leso tiuul ghou pa uraat. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Eemoghon ndiran kaaromŋa irau tineep toman ghou ila ruum tiou ne maau. Ighaze ŋgeu eta avo kaarom, nene irau iyoon ila matag maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Mboŋmaagh to naol ne, you pale nawaghamun tamtoghon samsamiadi tisob to tineep izi taan tonene. Yes to tighamgham ŋgar samia, you pale nandiir di tighau pa Yoova ndug toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","O Yoova, taŋiiz tiou ilat tiom. Ulooŋ suŋuuŋ tiou tonene, ve uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Uŋgooz matam payou malep. Pasa, you naneep ila pataŋani tiina lolo. Ighaze poiŋ tiou ilat, ghoro ughur taliŋam payou. Ulooŋ suŋuuŋ tiou, ve rikia moghon uul ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Paam namaat tonene. Nepooŋ tiou, nene inimale yab mbuasa to imbuŋ iza, ve imbiriis ilale. Tinig ituntun kat, ve tuag tisob tiyabyab. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","You nanimale kikiliiŋ to tamtoghon tivazagi le igorgor. Tovenen lolog pa naghan aniiŋ muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","You nayamaan yabyabuuŋ, ve nayak tiina. Ve nakoŋkoŋ le nakoŋkoŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","You naghita naghaze eŋgengou kat. You nanimale man to mboŋ to eŋgeni ineep izi ndug balim, ma ineep izi paanu muŋgina to tamtoghon tipuli ve isami. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","You irau nagheen maau. Napamaat le ndugizau. You ghora eŋgengou moghon. Nanimale man to eŋgeni ineep izala ruum pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Sawa isob, mboŋmaagh ila le rabrab izi, koiag tipipiyaav saveeŋ velegiiŋ payou ve tiŋiŋiŋ payou. Ve ighaze tighur samia pa tamtoghon eta, nene tiwatwaat sorokin you izag tighaze: Pataŋani to igham ghou, nene pale igham tamtoghon tonenen paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Yom atem yabyab payou kat. Tauto upiyaav ghou nala dige nanimale buzbuz. Ve avab inim ag aniiŋ, ve matag suru inim ag ya pa naghun. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Nepooŋ tiou to taan, nene inimale ndag izila ve yavyaava inim. Tapirig isob wa. Nanimale kikiliiŋ to raua imalai ve igorgor. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Eemoghon Yoova, yom kinik to unepneep ila inam to ghamuuŋ pooz. Muuŋ, aazne, ve itaghoni taghoni gha ila. Tovenen tamtoghon papaghu to muri pale tivot, yes pale tiwatag tighaze izam tiina inepneep tovene, itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Yom lolom isamin ndug tiom Zion. Tovenen yom pale umundig ve uuli. Pasa, sawa to ughur poia tiom iza toni, tauto ivot wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Onoon, tireu mbirisan ndug Zion, ve mbeb tisob timbiriis tilaledi wa. Yaam popoiadi to tirei ruum pani, tipiyaav di tila saguan saguan tinimale mbeb sorok. Eemoghon mbesooŋa tiom lolodi pa ndug tonowen kat. Tauto tighita mbeb tonenen le lolodi isami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","16","Eemoghon muri, Yoova pale igharaat mulin ndug Zion, ve ipatooŋ tau toman tapiri ve poia toni ivot ighazooŋ. Ghoro yes to ndug ndug toman kinik todi todi pale tighilaala tighaze ye iza tiina pa tapiri ve poia toni, ve timatughez pani, ve tineep ila samba. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Tamtoghon toni to tineep sorok kat, ye irau iyasiil pa taŋiiz todi maau. Pale ilooŋ suŋuuŋ todi, ve iuul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Mbeb to Yoova ighami, umbooda ila rau. Leso tamtoghon toni to muri pale tivot, tiwatagi, ve tipait iza. Umbood saveeŋ tovene: ");
INSERT INTO tuc_o_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Yoova inepneep izi ndug toni patabuaŋ, ve mata ilala inimnim. Ye ineep izi sambam, ve mata izizi pa taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Tovenen yes to tineep ila koiadi nimadi ve tiyakyak, ye iloŋlooŋ taŋiiz todi, ve iuluul di. Ve yes to tisaŋan sawa to koiadi tirab di timaat, ye ipaghau di pa mateeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Leso muri, yes ndug ndug toman kinik todi todi tinim tilup di pa suŋuuŋ izi Yerusalem, ve tivotia Yoova varu. Yes pale tipait iza izi lolooz toni Zion. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","You nanim olman kat sone. Eemoghon aazne, Yoova igham ghou tapirig isob, ve iŋgoor sawa tiou inim tuku. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Tovenen nasaav pani naghaze: “Maaron tiou, ugham ghou rikia malep. Pasa, nanim olman waat sone! Ve yom, ghoro nepooŋ tiom inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Yoova, muuŋ kat, yom ugharaat taan pughu le tuŋia. Ve sambam paroŋania paam, nene nimam muri. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","27","Eemoghon muri, sambam paroŋania ve taan pale tisami ve tilaledi, tinimale uli muŋgina to imarepreep. Tovenen yom pale upiyaav di tilaledi, ve urabolin di pa sambam paroŋania paghu ve taan paghu. Eemoghon yom unepneep tovene. Utortoor gabuam ve ŋgar tiom maau, ve sawa tiom irau isob maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Yei to nimbesmbees payom ne, yom pale uŋgin ndinatumai, ve tineep pooi. Ve papaghu todi to muri pale tivot ne paam, yom pale ugham di tiyoon ariaŋa, ve tineep pooi ila naghom irau sawa isob.” ");
INSERT INTO tuc_o_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","You nasaav pa taug naghaze you irau napait Yoova pa poia toni. Onoon kat, ila lolog ve ŋgar tiou isob, you pale napait Yoova iza patabuaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Nasaav muul. You irau napait Yoova pa poia toni. Ŋgar ve mbeb popoiadi naol to ye ighamgham di payou, irau lolog imaagh pa eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ye ireu sosor tiou, ve ipasob moroghooŋ tiou tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ye igham mulin ghou pa mateeŋ. Tauto namaat maau. Ye igham ghou lolog poia kat nanimale tamtoghon to tighuri inim kinik. Pasa, ŋgar to lolo ineep tuŋia ila to tamtoghon toni ve iuluul di, ye ipatooŋa payou paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Nepooŋ tiou to taan, ye ighamgham leg mbeb popoiadi naol naol le naraua kat. Ve igham ghou nanim paghu muul, le tapirig ivot inim tiina inimale manbog. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Ŋgar to Yoova ighamghami, nene deŋia moghon. Tovenen tamtoghon tisob to koiadi titatan di, ve tigham samin di, ye iyondyood padi, ve iuluul di pa pataŋani todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Muuŋ, Yoova ivotia gabua ve ŋgar toni pa Mose. Ve ipatooŋ uraat tintina toman tapiri ila yes Israela matadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yoova lolo isamin ghiit, ve ighamgham poian ghiit. Irau ate yabyab rikia maau. Poia toni, nene tiina kat. Ye lolo ineep tuŋia inim toit, ve iuluul ghiit irau sawa isob. Ve moghon moghon itaghon saveeŋ toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Onoon, sawa pida, ye iŋgal mataad pa sosor toit. Eemoghon igham tovene moghon moghon maau. Ve irau ikis mbalmbali toni le mala ne maau. Ineep ris, ve isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Onoon, ighaze tagham ŋgar to iyel pa tutuuŋ toni, Maaron irau iyat sosor toit ve ighur atia pait. Eemoghon ye ighamgham tovene maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Yes to timatughez pani, ve titaghon ŋgar toni, Yoova lolo ineep tuŋia ila todi, ve poia toni tiina izaza todi itaghon saveeŋ mbuaaŋ toni. Lolo poia tonowen, tiina kat, inimale soso to taan ve izala pa sambam. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Ve sosor toit to tazorzoor Maaron aliŋa, nene Yoova ipaghau di tila mala kat pait, irau soso to taan dige to ila pa ndag iza, ve ila pa ndag izila. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Yes to timatughez pa Yoova ve titaghon ŋgar toni, ye lolo isamin di inimale nditamaan lolodi isamin ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Pasa, ye tau to igharaat ghiit. Tauto moghon moghon mata iŋgalŋgal ighaze: Iit tanimale ghavuur to taan moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Nepooŋ to iit tamtoghon to taan, nene mala maau. Taneep ris, ve talaleed tanimale kikiliiŋ. Iit tanimale kananaŋ ruŋgu. Mboŋmaagh, ighaze ndag iza, ghoro ivavaal. Ve rabrab izi, ghoro imalai. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Ve ighaze yaghur iviviira, nene pale itap izi, ve ina ŋginiŋa. Taghita muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","18","Eemoghon yes to timatughez pa Yoova, ve titaghon ŋgar toni, ye lolo ineep tuŋia ila todi, ve iuluul di. To aazne, ve itaghoni taghoni gha ila. Ve ndinatudi ve nditimbudi paam. Ye ipatooŋ ŋgar deŋia padi ve iseeŋga itaghoni taghoni gha ila. Tovenen yes to matadi kisin saveeŋ to yesŋa Maaron timbua, ve titaghon tutuuŋ toni, ye pale lolo ineep tuŋia ila todi, ve iuul di itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yoova ighur ina to ghamuuŋ pooz ineep tuŋia izi sambam. Ye kinik to ighamgham pooz pa mbeb tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Tovenen yam aŋela to Yoova, yam asob apaiti pa poia toni. Yam aŋela ariaŋamim to aloŋlooŋ Yoova aliŋa ve ataghoni, apakuri. ");
INSERT INTO tuc_o_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yam ndaaba to sambam to ambesmbees pa Maaron ve ataghon ŋgar toni, apait Yoova pa poia toni! ");
INSERT INTO tuc_o_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Yam mbeb to sambam ve taan to Yoova igharaat gham, ve aneep ila samba, yam asob apaiti pa poia toni. Ve you paam, pale napait Yoova pa poia toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","2","You nasaav pa taug naghaze you irau napait Yoova pa poia toni. O Yoova, Maaron tiou, yom izam tiina kat. Tapirim tiina toman ŋgurubam to izam tiina pani, nene ipambood ghom inimale nonogiiŋa to yes kinik. Muuŋ kat, yom ugharaat sambam paroŋania inim inam to nepooŋ inimale moogh guduuŋ to tamtoghon tiraava leso tineep ila paroŋania. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ve upayoon ruum tiom izala ya to ineep izala tata pogho. Yom ugham yaghur tae inim lem karis, leso uyoon izala pogho ve ulaan pani. Tovenen yaghur imbaad ghom, ve ughaughau ila sambam paroŋania. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Yom ugham yaghur inim lem mbaŋooŋa. Ve yab yama, nene inim lem mbesooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Muuŋ, yom ughur taan iyoon tuŋia izala pughu. Tauto irau induur maau. Inepneep tovene. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Sawa tonenen, ugham te itatab taan toman lolooz tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ghoro aliŋam iza, ve uyaan te ve ighau. Aliŋam tapiri tiina inimale lalaav avolutu. Tauto te ilooŋ ghom, ve rikia moghon ighau ila ilupi ila dige eez, ve taan peria. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Tovenen te imaak, ve lolooz peria, ve imaak izi izi le ndug rapadi peria paam. Tauto aazne, ya ve te tineep ila inadi inadi to taum ughur di padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ve yom ughur ŋgat pa te ve taan. Leso te itatab taan ve ireu ndug muul sob. Ŋgat tonowen, te irau imalaaŋ pani maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Yom ugham ya tivot ila taan saambu to tineep taghon lolooz digedi, ve tireer taghon ndariri tizila pa ŋgoloop. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Ya tonowen tineep, leso mbeb naol naol to su tighun. Esele sagsagŋa paam. Ighaze murun di, nene pale tighun le isooŋ di. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Man tirei rumadi izala ai to tiyoon ila ya digedi ne bogadi, ve tineep ila ve titaŋtaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Yom uneep ila inam to sala we, ve ugham uman izizi ila lolooz. Uraat tiom tonenen, tauto igham taan ŋgoreeŋa ivot ve mbeb popoia naol titub pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Yom ugham kikiliiŋ itub, leso makau, sipsip ve mbeb pida paam tighan. Ve ughur mbeb naol pa tiuul tamtoghon paam. Leso tivazog di ve tigham uraat padi. Yom ugham aniiŋ anoŋa ivotvot ila taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Ve ughur ai vaen, leso tamtoghon tigharaata ve tighun suru, ve igham di lolodi poia. Ve ugham ai oliv padi paam. Leso tigham ŋgoreeŋa, ve timusil tinidi ve naghodi pani, le milmilia. Ve ugham aniiŋ naol naol padi, leso tighan di ve ipalot di. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yoova, ai tiom mendepur to uvazog di izi Lebanon, yom uŋgin di pooi, ve ugham uman izizi padi. Tauto aazne tiza tinim tintina. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Ai tonowen, man tirei rumadi izala bogadi. Ve man ŋgau, ghoro tighagharaat rumadi ila ai to tinimale yar ne bogadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Lolooz mamala dabadi, nene mekmek sagsagŋa inadi to nepooŋ. Ve mbeb pida tinimale namaiva ve uzuuv ma venen, nene tiyoŋyooŋ ilooŋ ila yaam tintina lolodi izala lolooz. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Yom ughur kaiyo inim iŋgat pa sawa to ndaman. Ve ndag, nene iwatag sawa sine to iza, ve sawa sine to izila. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Yom ugham mboŋ izi le ndug ndoroom, leso mbeb sagsagŋa to su tilaagh. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Tovenen laion papaghu tilaghlaagh ve titaŋtaŋ, ve tikalkaal adi mbeb pa tighan. Ve Maaron tau igham padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Sawa to ndag iza, ghoro timuul tila pa inadi to ghenooŋ, ve tizi tineep. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Ghoro tamtoghon anadi tivot tila pa tigham uraat. Tighamgham uraat ila ila le rabrab izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Yoova, yom ughur mbeb naol naol. Ve mbeb tisob to yom ugharaat di, tipatooŋ ghom tighaze ŋgar tiom tiina le tiina kat. Taan ivon kat pa mbeb ndiŋndiŋ ndiŋndiŋ to yom ugharaat di. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ve nagham ŋgar pa te paam. Nene tiina kat. Ve mbeb ndiŋndiŋ ndiŋndiŋ to matadi iyaryaar tineep ila lolo. Pida tintina, ve pida geegeu. Mbeb tonowen, tanin di, pale taraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Waaŋ tiravraav ila te pogho, ve Leviatan ilaghlaagh ila te lolo. Mbeb tonowen, tiina le tiina kat. Muuŋ kat, yom ugharaata, leso imomogheer ila te. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Mbeb naol tonowen tighurghur matadi payom pa ugham adi aniiŋ. Sawa to pitool di, yom taum upanpan di. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Yes tineep ila nimam. Ighaze ugham aniiŋ padi, yes pale tighami. Ighaze ukaak nimam pa upan di, pale tighan mbeb popoia le apodi isuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ve ighaze uŋgooz matam padi, nene pale timatughez, ve tiwaghamgham. Ve ighaze upas avuvudi ighau, nene pale timatmaat le tinim ghavuur muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Mbeb naol to tineep izi taan ne, yom uvib Avuvum ila padi, tauto tineep matadi iyaryaar. Ve sawa to timaat, yom ugham papaghu todi tivot izi taan, leso tigham inadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yoova iza tiina pale ineep itaghoni taghoni gha ila. Ve ye lolo poia pa mbeb naol to ye igharaat di. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ye tapiri tiina kat. Ighaze mata izi pa taan, nene pale taan irur. Ve ighaze itut lolooz eta, nene pale yab ighan lolooz tonenen. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Tovenen sawa to naneep matag iyaryaar, you pale nambou ve napait Yoova. Pale lolog poia pani, ve napaiti ila mbouŋ ila ila le nepooŋ tiou to taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Yoova igham ghou lolog poia kat. Tovenen sawa to nanepneep ve naghamgham ŋgar pani, naghaze ye ighita ghou, ve lolo poia pa ŋgar tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Eemoghon ndiran samsamiadi to tighamgham sosor ila Yoova mata, poia pa ye ipasob di pa taan ve tilaledi. Ve you, ghoro nasaav pa taug naghaze you irau napait Yoova pa poia toni. Aleluia! Tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Apait Yoova pa poia toni, ve avotia iza tiina. Asavia ŋgar to ye ighamghami irau ndug ndug, leso tiwatagi. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ambou pani. Ambou ve apaiti. avotia uraat toni gharatooŋadi to naol ne. Uraat tonowen, ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Yoova, ye iza patabuaŋ. Apaiti toman lolomim poia. Yes to tizuaria di pani, nene pale lolodi poia kat ve tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Suŋuuŋ tiam iŋarua Yoova. Leso ipalot gham pa tapiri. Azuaria gham pa ala aneep tomani irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Yam to avot ila to Maaron mbesooŋa toni Abaram, yam siŋ to Yakop to Maaron isia gham anim le, matamim iŋgal mbeb gharatooŋadi ve uraat tintina to Yoova ighamgham di. Uraat toni tonowen ite kat. Ve matamim iŋgal sawa naol to ye iŋgabiiz tamtoghon, ve ighur atia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yoova eŋgeni to Maaron toit. Uraat to gabizooŋ tamtoghon ve ghuruuŋ atia padi, nene ye ipatooŋa irau taan isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Moghon moghon, mata iŋgalŋgal saveeŋ mbuaaŋ toni, ve itataghoni. Tutuuŋ to Maaron isavia, pale iyaryaaŋ tovene, ve anoŋa ivotvot itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Muuŋ, ye imbua saveeŋ toman Abaram ighaze yesuru tilup di tinim ee moghon. Ghoro ipariaaŋ saveeŋ mbuaaŋ tonowen ila to Isak le iyaryaaŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","11","Muri ghoro, ipariaaŋ saveeŋ tonenen muul ila to Yakop ighaze saveeŋ tonenen pale iyaryaaŋ tovene itaghoni taghoni gha ila. Ve isaav pa Yakop ighaze: “You pale nagham taan Kanaan inim lem. Taan tonanan pale inim yamŋa papaghu tiom lemim kat.” ");
INSERT INTO tuc_o_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Sawa tonenen, yes ival maau. Yes rismoghon. Ve tineep tinim loomba pa taan tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Laghooŋ todi, titaghon ŋgar tovene: Tineep ris izi ndug eez, ghoro timundig muul, ve tila tineep izi ndug ite. Tila tivot ndug to kinik eez ve tineep toman di. Le isob, ghoro tipul di, ve tila tivot to kinik ite, ve tineep toman di. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","15","Laghooŋ todi, nene Maaron tau iŋgini. Ye ipul tamtoghon to ndug eta titatan di, ve tigham samin di ne maau. Ye mata iŋgalŋgal di, tauto iyaan kinik pida ighaze: “Yes to nasia di ve naghur di tinim uraata tiou, ambuul di malep! You naghur di tinim propet tiou. Tovenen awaghamun di malep.” ");
INSERT INTO tuc_o_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Muri ghoro Yoova igham pitool tiina ivot izi taan Kanaan. Sawa tonenen, Yakop yesŋa ndinatu adi aniiŋ maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Eemoghon Yoova imbaaŋ todi eez imuuŋ padi ila Isip. Nene Yosep to tigholia ila, ve inim mbesooŋa sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Yes Isipa tighuri ilooŋ ila ruum to yabyabuuŋ, ve tikau aghe pa sen, ve tighur ain liliita ila lua. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yoova itovtoov Yosep tovene, le Yosep ivotia mbeb pida pa yes Isipa, ve saveeŋ toni anoŋa ivot. Tovenen saveeŋ to Yoova isavia pani, nene ipaghazoŋan Yosep ighaze ye igham sosor maau, ve ŋgar toni deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Ghoro kinik to yes Isipa to iŋgin ndug naol, imbaaŋ ila ighaze tipul Yosep ivot pa ruum to yabyabuuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Ve ighur Yosep inim daba to yes Isipa, ve ipul ruum toni toman mbeb toni tisob ila ye nima, leso iŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Tauto Yosep inim daba pa yes to tighamgham uraat pa kinik. Ye ipatoot yes uraata to tiuluul kinik pa ŋgar, ve ipatooŋ di pa ŋgar poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Ataam tonene to yes Israela to siŋ to Yakop tila tivot izi Isip, ve tineep tinim loomba izi taan to Ham. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yoova ipapalot di, tauto tivot tinim ival, le tapiridi ilib pa koiadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Ghoro ye itoor ŋgar to yes Isipa, ve tighur koi pa tamtoghon toni. Tovenen tikaal ataam pa titombaan mbesooŋa toni ve tigham samin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Tauto Yoova imbaaŋ mbesooŋa toni ru, Mose ve Aron, leso tiuul yes Israela. Aron tonene, Yoova tau ighuri pa igham uraat toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Maaron ighaze ipatooŋ tapiri pa yes Isipa. Tauto ipalot Mose yesuru Aron, ve tigham mbeb gharatooŋadi naol ve uraat tintina ila yes Isipa lolodi. Uraat to ivot izi taan to Ham, nene ite kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yoova igham ndoroom tiina ighamun taan to yes Isipa. Pasa, yes tizoor aliŋa, ve tiŋguruut tamtoghon toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ve itoor ya todi tisob tinim siŋ, le iigh tisob timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Ghoro igham ŋgob ndiŋndiŋ ndiŋndiŋ tivot le tineep irau taan isob to yes Isipa. Ruum lolo to kinik tau, nene ivon pa ŋgob paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Ve Yoova isaav, ve raaŋ tintina toman suum katindi tivot, le tirau taan to yes Isipa. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ve sawa to uman ighaze izi, uman izi maau. Yoova igham ais patu patu titaptap tizi le tiwaghamun ndug todi. Ve igham ndug milia, ve lalaav kiliŋkiliŋia irau taan todi isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Tauto iwaghamun ai vaen toman ai fik todi, ve iŋgal ai pida tipolpol paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Ghoro isaav, ve isis tivot le katindi kat. Tanin di, pale taraua maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Ve tighan aniiŋ to yes Isipa tivazog di ne raua toman mbeb pida to titub ila taan todi, le isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Muri ghoro, Yoova irab ndinatudi aidaba timatmaat irau taan todi isob. Ndinatudi to tipoop di muuŋ, tauto tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Ghoro Yoova igham yes Israela tipul Isip, ve tivot tila. Sawa to timundig, tiyou gol to yes Isipa toman silva todi, ve tila tomani. Ve laghooŋ todi, tiwasiiŋ moghon. Todi eta tapiri isob ve itap ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Sawa to yes Israela tipul Isip ve tila, yes Isipa lolodi poia kat. Pasa, yes Israela to tinim pughu pa pataŋani to ivotvot padi. Tauto matughezaaŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Ndag, Yoova igham yaghur tae ivot, ve ipoon ndag mata pa yes Israela. Ve mboŋ, ye igham yab ighan, le isul ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Sawa to tighasoni pa adi aniiŋ, ye igham man kayau katindi tivot, ve igham aniiŋ tiina ineep sambam ve izi inim padi. Tovenen tighami ve tighan le apodi isuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Yoova igham yaam ivavaal le avo ikaak, ve ya goŋia ivot. Ya tonowen ireer tiina izi ndug balim to le ya maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Yoova igham mbeb naol tonenen pasa, mata iŋgalŋgal saveeŋ toni patabuaŋ to imbua toman mbesooŋa toni Abaram. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Tovenen Yoova ighereb tamtoghon toni Israel to ye tau isia di ne, ve tipul Isip. Timboumbou ve tilolool toman lolodi poia ve tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Muri ghoro, ye igham taan to ndug pida padi. Tovenen ndug tonowen uraat todi anoŋa, inimale ruum, uum, ai, ve mbeb todi pida paam, tauto tisob tinim yes Israela ledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Yoova igham tovene padi, leso tikis saveeŋ toni tuŋia, ve matadi kisin tutuuŋ toni ve titaghoni. Aleluia! Tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Aleluia! Lolood poia pa Yoova, ve tapaiti pa poia toni. Pasa, ye poia kat. Lolo ineep tuŋia ila to tamtoghon toni, ve iuluul di irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Sei irau isavia uraat tintina to Yoova ighamgham di? Ve sei irau ipaiti pa ŋgar popoia naol to ye ighamgham di, ve ipasob di? Eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Yes to tighagharaat pataŋani to tamtoghon ve titaghon ŋgar deŋia irau sawa isob, nene pale lolodi poia kat, ve poia to Maaron izaza todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","5","O Yoova, sawa to ugham poian tamtoghon tiom, ve ugham mulin di pa pataŋani todi, matam iŋgal ghou, ve uul ghou paam. Maaron, yom taum usia yes Israel tinim lem. Yes tamtoghon tiom. Tovenen naghaze taug naghita di tineep pooi. Leso yeiŋa nilup ghei toman tinimai iza ve nipait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Yei nisosor wa. Niyel pa ataam tiom ninimale nditimbumai. Yei nighamgham ŋgar samia. Ŋgar tiei deŋia ila matam maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Sawa to nditimbumai tineep izi Isip, yom ugham mbeb gharatooŋadi tintina ivotvot. Eemoghon tighilaal di maau. Sawa naol, yom upatooŋ poia tiom padi itaghon ŋgar tiom to lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Eemoghon yes tigham ŋgar pa ulaaŋ tiom tonenen maau. Sawa to tila tivot Te Kaviaaŋa, tizoor aliŋam, ve tipul muridi payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Eemoghon Yoova, ye iza tiina pa tapiri ve poia toni, ve ighaze igham di tighilaal katin tapiri. Tauto igham mulin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Sawa tonenen, ye isaav ariaŋa pa Te Kaviaaŋa, le ivalagi inim ru. Pida ila pa ŋas, pida ila pa waan, ve taan mamaasa ivot. Ghoro ighereb yes Israela, ve tilaagh ila taan mamaasa to ineep sila kat, ve tivool tila pa dige ite. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Tovenen ye igham mulin di ila koiadi nimadi. Ye iyoon padi, ve iuul di. Tauto yes to tighur koi padi irau tiwaghamun di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Sawa tonenen, te itatab koiadi le tisob timatmaat. Eta ineep muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Maaron igham tovene, tauto yes Israela tighur ila saveeŋ mbuaaŋ toni, ve timbou ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Eemoghon rikia moghon ve lolodi imaagh pa mbeb gharatooŋadi to ye igham di. Yes tisaŋan Maaron pa ivotia ŋgar toni padi ne maau. Tigham mbeb itaghon taudi ŋgar todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Sawa to tinepneep izi ndug balim, luadi itaŋ tighaze le tighan aniiŋ popoia inimale muuŋ tighanghani izi Isip. Tovenen titoov Yoova tapiri izi ndug balim. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Ve Maaron ilooŋ taŋiiz todi, ve igham adi mbeb to tighasoni pani. Eemoghon ye igham moroghooŋ samia ivot le iwaghamun di paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Sawa to tinepneep ila inadi to nepooŋ izi ndug balim, tamtoghon todi pida timundig ve tiŋooŋ pa Mose yesuru togha Aron to Yoova mbesooŋa toni patabuaŋ. Tighaze le tigham uraat to Maaron ighuri ila yesuru nimadi, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Tovenen taan ikaak, ve Datan yesuru Abiram toman siŋ todi tisob titaptap tizila, ve taan avo ila iŋgup muul. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Ghoro yab ivot, ve ighan tamtoghon pida to titaghon di pa ŋgar todi tonowen. Ndiran samsamiadi tonowen, yab yama ighan di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Sawa to yes Israela tinepneep izi lolooz Sinai pughu, tigham gol ve tigharaat makau natu tamoot anunu, ve tiput aghedi pani ve tipaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Tovenen Maaron todi to iza tiina pa tapiri ve poia toni, yes tipul muridi pani. Ve tighur mbeb to ighanghan kikiliiŋ ne anunu igham Maaron ina. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Onoon kat, Maaron todi to igham uraat tintina tivot izi Isip, ve igham mulin di, lolodi imaagh pani kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Ye igham mbeb gharatooŋadi tintina izi taan to yes Isipa, ve igham uraat tintina izi Te Kaviaaŋa dige paam. Uraat tonowen, tamtoghon tighita di le matughezaaŋ tiina igham di. Eemoghon yes Israel tigham ŋgar pa mbeb tonenen maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Tovenen Maaron ighaze iwaghamun di le tisob. Eemoghon mbesooŋa toni Mose to ye tau isia, iyoon ila Maaron mata inim sigeu pa yes Israela. Tauto itatan Maaron mbalmbali toni, ve Maaron iwaghamun tamtoghon toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Sawa to yes Israela tigharau taan Kanaan, yes tirere pa taan poia to Yoova ighaze igham padi. Pasa, tighur ila saveeŋ mbuaaŋ toni maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Yes lolodi pa tilooŋ Yoova aliŋa maau. Tinepneep ilooŋ ila mbeez todi, ve lolodi ŋurŋuria pa Maaron. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","27","Tauto Yoova iit nima iza, ve imbua saveeŋ ariaŋa ighaze ye pale irab di tisob timatmaat izi ndug balim, ve ireu papaghu todi timbiriis tirau ndug ndug. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Muri ghoro, yes Israela tila tivot lolooz Peor. Sawa tonenen, tila toman yes to timbesmbees pa maaron kaarom Baal. Pasa, aniiŋ to ndiran tonowen tigham pa maaron maate todi tonowen, yes Israela tighani paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Ŋgar to tighami, nene ipas Yoova ate, le ate yabyab kat. Tauto igham moroghooŋ samia ivot padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Tovenen Pineas imundig ve irab tamtoghon ru to tizoor Maaron aliŋa ne timaat. Ghoro moroghooŋ samia tonowen isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Ŋgar toni tonowen, tauto Maaron ighita ighaze ye ŋgeu deŋia. Ve Maaron pale mata iŋgalŋgali tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Yes Israela tila tivot izi ya Meriba, ve tigham Yoova ate yabyab muul. Sawa tonenen, tigham pataŋani pa Mose paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Pasa, yes tizoor katini le tipas ate. Tauto igham ŋgar pooi maau, ve ipiyaav aliŋa isosor. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Sawa to tilooŋ tila taan Kanaan, Yoova isaav ariaŋa padi ighaze tirab yes to tineep tonowe tisob timatmaat. Eemoghon titaghon Yoova aliŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Yesŋa Kanaana tiluplup di, ve titaghon ŋgar todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Yes timbesmbees pa maaron kaaromŋa todi, ve ŋgar tonowen inim liis padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Ve tigham taudi ndinatudi nditamoot ve ndiliva, ve tirab di timaat tinim watooŋrau pa avuvu samsamiadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Onoon kat, ndinatudi nditamoot ve ndiliva to ledi sosor eta maau, yes tirab di timatmaat tinim watooŋrau pa maaron kaaromŋa to yes Kanaana. Siŋ todi to imaliŋ, iwaghamun taan todi le isami ila Maaron mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ŋgar to tighami, igham di tisami kat ila Yoova mata. Yes tipul muridi pani tinimale liva to ipul azuwa ve ila ighurghur maat. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Ŋgar to tamtoghon toni Israela tighami, nene igham Yoova ate yabyab kat, ve lolo padi maau le maau kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Tauto ipul di tila ndug ndug nimadi. Yes tineep ila koiadi sambadi, ve anadi tiŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Koiadi tonowen tighur pataŋani naol padi, ve titatan di pa tapiridi, ve tigham di tinim mbesooŋa todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Sawa naol, Yoova ipas yes Israela tivot pa pataŋani todi. Eemoghon tighilaal ulaaŋ toni maau, ve tizorzoor aliŋa, ve titaghon taudi ŋgar todi. Ŋgar todi samia tonowen igham di tiwaghamgham. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Eemoghon Yoova ighita pataŋani todi, ve ilooŋ taŋiiz todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","46","Pasa, mata iŋgal saveeŋ to imbua toman nditimbudi, ve lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. Tauto itatan mbalmbali toni, ve igham yes to tikiskis yes Israela ne lolodi isamin di, ve tigham poian di. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O Yoova, Maaron tiei, ugham mulin ghei ila koiamai nimadi! Ughita. Aazne, nineep irau ndug ndug. Uyou ghei, ve ulup ghei nila taan tiei muul. Leso lolomai poia payom, ve nipait izam patabuaŋ. Ve matamai iŋgal izam ve tapirim tiina irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Iit tapait Yoova pa poia toni. Ye Maaron to iit Israela. Tapaiti to aazne, ve itaghoni taghoni gha ila! Ve ival tiina pale tisaav tighaze: “Onoon kat.” Aleluia! Tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Lolomim poia pa Yoova ve apaiti. Pasa, ye poia kat. Lolo ineep tuŋia ila to tamtoghon toni, ve iuluul di irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Yes to Yoova igham mulin di ila koiadi nimadi, irau tisavia saveeŋ tonene. Pasa, ye iyoon padi ve ipas di tivot pa pataŋani todi, ve igham di tineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Muuŋ, koiadi tigham di tila tineep irau ndug ndug. Pida tineep ila pa ndug to ndag iza pani, ve pida tineep ila pa ndug to ndag izila. Pida tineep ila pa rag pughu, ve pida tineep ila pa yavaar pughu. Eemoghon Yoova iyou di timuul pa taudi ndug todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Tamtoghon pida, tiwalaghlaagh izi ndug balim to le ya maau. Ve tikalkaal ataam tighaze tila ndug eta, leso tineep tonowe. Eemoghon tindeeŋ ataam eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Pitool di, ve murun di, le tapiridi isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Tovenen tineep sami. Eemoghon sawa to titaŋ roran Yoova pa ulaaŋ, ye iuul di pa pataŋani todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ve ipatooŋ di pa ataam to deŋia ve tuku. Tauto titaghoni, ve rikia tila tivot ndug poia, ve tineep tonowe. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Tovenen yes irau lolodi poia pa Yoova, ve tipaiti pa poia toni. Pasa, ye lolo ineep tuŋia inim to iit tamtoghon, ve ighamgham uraat gharatooŋadi pa iuul ghiit. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Yes to murun di, ye ighamgham adi ya, leso tighun le isooŋ di. Ve yes to pitool di, ye irau di pa mbeb popoia le tiraua kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Tamtoghon pida, yes tineep ila ndoroom tiina lolo, ve rismoghon tone timaat. Yes tineep ila ruum to yabyabuuŋ lolo, ve ravraav toman sen ighan nimadi ve aghedi, le tisami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Pasa, tizorzoor Maaron aliŋa. Maaron Tiina To Ilib Pa Ndimaronŋa Tisob, yes tiveleg saveeŋ toni inimale mbeb sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Tauto ye ighur uraat pataŋani kat iza todi, leso itatan di. Yes irau tilaagh deŋia maau, ve titaptap tizi. Pasa, timbadbaad mbeb pataŋani. Ve ledi tamtoghon eta to irau iuul di ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Tovenen tineep sami. Eemoghon sawa to titaŋ roran Yoova pa ulaaŋ, ye iuul di pa pataŋani todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Ye ipas di tivot pa ndoroom tiina tonowen lolo, ve igham di tivot tila ghazooŋa. Ve ikuup motin ravraav toman sen pa nimadi ve aghedi. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Tovenen yes irau lolodi poia pa Yoova, ve tipaiti pa poia toni. Pasa, ye lolo ineep tuŋia inim to iit tamtoghon ve iuluul ghiit. Ve ighamgham uraat gharatooŋadi pa iit tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Ataam ariaŋadi to ruum to yabyabuuŋ to tigharaat di pa mbaras, ye irab balagin di. Ve ain ariaŋadi to tipalot ataam, ye iŋgor polpolin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Tamtoghon pida, yes tighamgham ŋgar to borouŋa, ve tinoknok zoraaŋ saveeŋ. Yes tighamgham sosor, tovenen timorooŋ, ve yabyabuuŋ tiina igham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Lolodi pa tighan aniiŋ eta maau. Sawa to tighita aniiŋ eta, atedi inaunau ve tilulu. Tovenen tineep ila naal avo wa. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Yes tineep sami. Eemoghon sawa to titaŋ roran Yoova pa ulaaŋ, ye iuul di pa pataŋani todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ye isaav, ve tinidi popoia muul. Muuŋ, tineep ila naal avo. Ve ye igham mulin di pa mateeŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Tovenen yes irau lolodi poia pa Yoova, ve tipaiti pa poia toni. Pasa, ye lolo ineep tuŋia inim to iit tamtoghon ve iuluul ghiit. Ve ighamgham uraat gharatooŋadi pa iuul iit tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Tovenen yes irau tigham watooŋrau pani, ve tipaiti pa poia toni. Ve lolodi poia kat, ve timbou tiina, ve tisavia uraat tintina to ye ighamgham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Tamtoghon pida, yes tiza waaŋ, ve tiraav tila ndug mala, leso tiraukol. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Yes tighita katin Yoova tapiri, ve uraat tintina to ye ighamgham di ila te pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Pasa, ye isaav ariaŋa, ve yaghur tiina iza le ipei dibom tintina. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Dibom tonowen indae waaŋ todi iza kat, ve ipuli izi le rismoghon tone indal izila mazovan tiina lolo. Tovenen matughezaaŋ tiina igham di, le tapiridi isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Ve tiwataptap tinimale yes to tighun ve tiwaghamgham. Yes to te ve tiwatag ghamuuŋ pooz. Eemoghon tirau mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Tovenen tineep sami. Eemoghon sawa to titaŋ roran Yoova pa ulaaŋ, ye iuul di pa pataŋani todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ye igham yaghur ate izi, ve dibom imaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Yes tighita taun izi, le lolodi poia. Ve Yoova igham di tila tilooŋ ndug to tighaze tila pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Tovenen yes irau lolodi poia pa Yoova ve tipaiti pa poia toni. Pasa, ye lolo ineep tuŋia inim to iit tamtoghon ve iuluul ghiit. Ve ighamgham uraat gharatooŋadi pa iuul iit tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Tovenen ighaze ival tiina tilup di pa suŋuuŋ, ndiran tonowen pale tila toman di, ve tinidi iza pa Yoova ve tipakuri. Ve sawa to yes daba tilup di, ndiran tonowen pale tineep toman di, ve yesŋa tipait Yoova iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yoova irau igham ya tintina timaak le timamaas kat, tinimale ndug to le ya maau. Ve ya to tivotvot ila taan lolo ne paam, ye irau ipoon di le taan lolo imamaas. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Ighaze ndug eta tinoknok ghamuuŋ ŋgar samia, ye irau iwaghamun taan todi to ŋgoreeŋa tiina, leso isami, ve mbeb eta itub ila muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ve ighaze ndug eta le ya maau, ye irau igham ya ivot pani, ve ireer tiina. Taan to lolo mamaasa, ye irau igham ya ivot pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Yes to pitool di, ye igham di tila tineep ila taan poia tonowen, ve tighami inim ledi ndug to nepooŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Tovenen yes tivazog aniiŋ ve vaen ila, ve tighita anoŋa katindi tivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yoova ighur poia toni izaza todi, tauto timasa tinim ival. Ve mata pa makau, mekmek, ve sipsip todi paam, le timasa tinim naol. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Ighaze tamtoghon to Maaron koiadi titatan di le tapiridi isob, ve tigham samin di, le tineep sami toman lolodi ipataŋan, ");
INSERT INTO tuc_o_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","nene pale Yoova iuul di, ve itatan daba to koiadi tonowen. Pale igham di tiwaghamgham, ve tiwalaghlaagh izi ndug balim to le ataam eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Eemoghon yes to tineep ila pataŋani lolo ve mbolaaŋ igham di, ye ipas di tivot pa pataŋani todi, ve mata padi le timasa tinim ival. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Ŋgar toni tonowen, ndiran deŋiadi tighita, le lolodi poia kat. Ve ndiran samsamiadi tisob ledi saveeŋ eta muul maau. Saveeŋ todi isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Tamtoghon to le ŋgar, ye irau igham ŋgar pooi pa mbeb tonene, ve mata iŋgalŋgal ŋgar to Yoova to lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Maaron, lolog ru payom maau. Lolog ineep tuŋia ilat tiom, ve naghur ilat tiom ariaŋa. Tovenen nasaav pa taug naghaze: “Umundig ve umbou pa upait Maaron.” ");
INSERT INTO tuc_o_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Lolog naghaze ndugitun, ghoro namundig ve nagharaat taug, ve napambar ambam ve narab gita ila ila le ndag pusukia iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Tiina tiou, you pale napait ghom pa poia tiom ila tamtoghon to ndug ndug matadi. Pale yeiŋa tamtoghon to ndug naol nilup ghei pa suŋuuŋ, ve nait mbouŋ pa napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","O Yoova, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Ŋgar tiom tonanan, tiina le tiina kat. Izala izala le ikis sambam. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ tiom tovene paam. Izala le ikis yaghur tae. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Maaron, ival tiina pale tipait izam izala le izala kat, ilib pa sambam paroŋania. Ve tipakur ghom pa tapirim ve poia tiom irau taan isob! ");
INSERT INTO tuc_o_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Maaron, yei tamtoghon tiom. Yom lolom tiei kat. Ulooŋ suŋuuŋ tiou tonene, ve upatooŋ tapirim ve uul ghei. Ugham mulin ghei pa pataŋani tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Muuŋ, Maaron ineep izi ndug toni patabuaŋ, ve isaav ighaze: “You naparab le nalib pa koiagŋa wa. Tauto lolog poia ve navalag taan Sekem ve taan raapa to Sukot, ve nareii irau tamtoghon tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Taan suruvu to Gileat, ve taan to yes Manase paam, nene you tiou. Yes Epraima tinimale hat ariaŋa to ipoon dabag pa malmal. Ve yes Yuda tinimale titi to nakisi inim ghilalooŋ pa pooz tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Taan suruvu to Moap, nene inimale oon tiou to ririwaaŋ. Ve taan suruvu to Edom, nene ndug to napiyaav duduuŋa to agheg pani. Ve yes Pilistia, you naparab toman di le nalib padi. Tauto lolog poia ve aliŋag iza.” ");
INSERT INTO tuc_o_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Sei irau igham ghou nalib pa koiagŋa ve nalooŋ nala ndug todi to didiiŋ ariaŋa iluvuti ne? Sei pale imuuŋ payou, ve ighereb ghou nala navot taan suruvu to yes Edoma? ");
INSERT INTO tuc_o_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Ite paam maau. Yom moghon. Eemoghon Maaron, aazne yom ughur murim payei, ve unum toman ndaaba tiei muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Maaron, uul ghei. Leso nilib pa koiamai. Pasa, ulaaŋ to nighamghami ila to tamtoghon, nene anoŋa maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Eemoghon ighaze Maaron inim toman ghei, nene pale nilib padi. Ye irau itatan di, le tapiridi isob kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","O Maaron, sawa isob you napapait ghom. Ulooŋ suŋuuŋ tiou. Neneeŋam malep! ");
INSERT INTO tuc_o_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Pasa, ndiran samsamiadi to avodi kaarom, tighur koi payou, ve tiŋgal saveeŋ kaarom naol payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Koiagŋa tonowen tipipiyaav saveeŋ samsamia payou, ve tiwaghamun izag sorok. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Muuŋ, you lolog padi, ve nagham ŋgar poia padi. Eemoghon tiyat ŋgar poia to nagham padi ne pa ŋgar samia, ve tiŋgal saveeŋ naol payou. Eemoghon you ŋgeu to suŋuuŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ŋgar poia to you nagham padi, yes tiyati pa ŋgar samia. You lolog padi. Eemoghon yes tighur koi payou, ve tighaze: ");
INSERT INTO tuc_o_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","7","“Taghur tamtoghon samia eta iyoon ila dige pa iŋgal saveeŋ pani. Leso sawa to tipayoonda pa savsaveeŋ, tighita tighaze ye isosor, ve tighur atia pani. Ve nighaze suŋuuŋ toni paam, nene isosor ila Maaron mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ŋgeu tonowen ineep mala izi taan malep. Tamtoghon ite paam igham ina, ve igham uraat toni, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Azuwa pale inim naar, ve ndinatu tinim parooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Pale tireu ndinatu ruum todi tizi, ve tinaan di tighau tila. Leso tiwaghamgham, tiwalaghlaagh, ve tisuŋsuŋ ledi mbeb. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ighaze ŋgeu tonowen igham bun ila to tamtoghon eta, nene pale tamtoghon tonenen inim ve iyou mbeb toni tisob tinim le. Mbeb to ye ighun wadedeŋa pani, ndiran to ndug ite pale tila ve tiyou di tinim ledi. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Tamtoghon eta igham poian ŋgeu tonowen malep. Ve ndinatu to tinim parooŋa, tamtoghon eta lolo isamin di ve iuul di malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Ndinatu timatmaat le tisob, ghoro poia. Leso ŋgeu tonowen le iza muul sob, ve tamtoghon lolodi imaagh pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Ŋgar samia to nditimbu, tamtoghon pale tisavia pa Yoova, leso mata iŋgalŋgali. Ve sosor to tina paam, Yoova ireua malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Tovenen sosor to ŋgeu tonowen toman siŋ toni, Yoova pale mata iŋgalŋgali irau sawa isob, ve ipasob di pa taan. Leso tamtoghon lolodi imaagh padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Pasa, ŋgeu tonowen, mata iŋgal ve igham ŋgar poia eta pa tamtoghon maau. Yes mbolaaŋa ve yes to tineep ila pataŋani lolo, ye ighamgham samin di, ve irab di timatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ŋgar to avood samia pa tamtoghon, ye lolo pani. Eemoghon saveeŋ toni samia tonowen pale imuul pa tau, ve iwaghamuni. Ŋgar to tasuŋ Maaron leso ighur poia toni iza to tamtoghon, ŋgeu tonowen lolo pani maau. Tovenen poia to Maaron pale ineep saguan pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ŋgar to avood samia pa tamtoghon, ye ipulpuli maau. Nene inimale nonogiiŋa to ye lolo pani kat, ve moghon moghon indududi. Eemoghon saveeŋ toni samia tonowen pale imuul pa tau, ve izila lolo inimale ya, ve itaghon tua to naol ne inimale ŋgoreeŋ, ve iwaghamuni. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Saveeŋ toni samia tonowen, pale imuul pa tau ve ikaui, inimale kawaal to ye ikawaala ila ŋgali, ve inimale puus to ipusi pani irau sawa isob.” ");
INSERT INTO tuc_o_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","O Yoova, saveeŋ samsamia naol to koiagŋa tiŋgalŋgali payou, upamuula imuul ila pa taudi. Leso uyat ŋgar todi tonowen. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Yoova, yom Maaron tiou. Izam tiina pa poia tiom ve ulaaŋ tiom. Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Tovenen uyoon payou, ve upas ghou navot pa pataŋani tiou tonene. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Pasa, aazne naneep sami, ve leg ataam eta maau. Tovenen ateg imbumbu, ve lolog isami kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","You nanimale mbeb yavyaava to ighaze ndag izila, ghoro taghita muul maau. You nanim isis to yaghur iviviira ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","You naŋgun taug pa ghaniiŋ aniiŋ ris wa. Tovenen nakoŋkoŋ, ve tuag tisob timareer, ve agheg imatmaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ighaze koiagŋa tighita ghou, yes tiveveleg ghou, ve tiŋiŋiŋ payou. Ve luadi katia payou ve tighaze: “Aa, ughita wa?” ");
INSERT INTO tuc_o_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yoova, yom Maaron tiou. Uul ghou lak! Ugham mulin ghou pa pataŋani tiou tonene. Pasa, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ugham koiagŋa tiwatag nimam. Upatooŋ tapirim padi ve tighita katini pa matadi. Leso tighilaal tighaze yom to Volaaŋa tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Onoon, yes avodi samia payou. Eemoghon yom pale ughur poia tiom iza tiou. Ighaze koiagŋa tipamundigin malmal payou, yom pale utatan di, ve upamuul di tila toman mayadi. Leso ugham mbesooŋa tiom lolo poia ve tini iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Tovenen yes to tiŋgal saveeŋ payou ne, ugham di tiwaghamgham, ve tighau tila toman mayadi. Mayaŋiiŋa todi tonowen pale inim ledi nonogiiŋa pa tindudi irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Eemoghon you pale lolog poia kat pa Yoova, ve aliŋag iza ve napaiti pa poia toni. Sawa to yeiŋa ival tiina nilup ghei pa suŋuuŋ, you pale nait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Pasa, yes to tineep ila pataŋani lolo ve titaŋ rorani pa ulaaŋ, ye iyondyood digedi pa iuul di. Ve yes to koiadi tiŋgal saveeŋ padi ve tighaze tirab di timaat, ye igham mulin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Yoova isaav pa Tiina tiou ighaze: “Unum mbolem izi ila pa nimag waan, le irau natatan koiamŋa ve tapiridi isob kat, ve uvazag di ila aghem samba.” ");
INSERT INTO tuc_o_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","O kinik, aazne yom unepneep izi ndug Zion, ve Yoova igham titi to kinik payom leso ipalot ghom. Tauto tapirim tiina ve pooz tiom ila irau ndug ndug. Yoova isaav payom ighaze: “Utatan koiamŋa to tiluvut ghom, ve ugham di tineep ila sambam.” ");
INSERT INTO tuc_o_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ighaze umundig ula pa malmal, tamtoghon tiom ndiŋndiŋ ndiŋndiŋ pale lolodi ipazaagh di tighaze tilat ve yamŋa ala. Ighaze ndag pusukia iza, ndipain tiom to tiraua kat pa malmal, pale tikeet tilat tineep tirau lolooz patabuaŋa to tiluvut Yerusalem, tinimale waam to mboŋmaagh itatab kikiliiŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yoova imbua saveeŋ toman ghom, ve ipariaaŋa le iyaryaaŋ kat. Irau itoor ŋgar toni maau. Isaav payom ighaze: “Yom ŋgeu to watooŋrau unumale Melkizedek. Ve yom pale uneep tovene itaghoni taghoni gha ila.” ");
INSERT INTO tuc_o_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Maaron ineep ila pa nimam waan ve ipapalot ghom. Sawa to mbalmbali toni ighaze ivot, ye pale ipamundigin malmal ve irab yes kinik tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Pale ighur atia pa ndug ndug, ve irab di tisob timatmaat, le patudi tizi tiwaghengheen izi taan. Tovenen yes pooza to tineep tirau taan, ye pale irab di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ve kinik tiei, ye pale ighun ya to ireer igharau ataam dige, le tapiri ivot muul. Tovenen ye pale ilib pa malmal, ve tini iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Aleluia, tapait Yoova! Ighaze ndiran deŋiadi tilup di pa suŋuuŋ, you pale nala toman di, ve napait Yoova toman lolog kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Pasa, Yoova ighamgham uraat tintina. Tovenen yes to lolodi pa uraat toni kat, tighamgham ŋgar pa uraat toni irau sawa isob tighaze le tiwatag katini. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Uraat toni ipatooŋa ighaze ye tapiri tiina ve poia kat. Tauto tamtoghon titandag pani. Ŋgar toni deŋia pale inepneep tovene itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Ye ipamundigin ŋgar toit, leso mataad kisin uraat toni to gharatooŋadi ne. Ye lolo isasamin tamtoghon toni, ve ighamgham poian di. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Yes to timatughez pani, ve titaghon ŋgar toni, ye ighamgham adi aniiŋ. Ve saveeŋ to yesŋa tamtoghon toni timbua pa tilup di tinim ee moghon, ye mata iŋgalŋgali ve itaghoni irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Muuŋ, ye igham uraat tintina ila tamtoghon toni matadi, leso ipatooŋ tapiri padi. Sawa tonenen, ye igham taan to ndug ndug inim ledi pa tineep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Uraat naol to ye igham di, nene tipatooŋa tighaze ye itataghon saveeŋ mbuaaŋ toni, ve ŋgar toni deŋia moghon. Tovenen tutuuŋ tisob to ye ighur di, iit irau taghur ila, ve tataghon katin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Tutuuŋ tonowen pale tiyaryaaŋ tovene itaghoni taghoni gha ila. Yoova ighur tutuuŋ tonowen itaghon saveeŋ mbuaaŋ toni ve ŋgar deŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Muuŋ, ye ipas tamtoghon toni tivot pa pataŋani todi. Ve sawa to yesŋa timbua saveeŋ pa tilup di tinim ee moghon, avo iyaryaaŋ padi ighaze titaghon saveeŋ mbuaaŋ todi tonowen ŋgara irau sawa isob. Ye tapiri tiina, ve iza patabuaŋ kat. Tauto tamatughez pani, ve tataghon ŋgar toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Ŋgar to tamatughez pa Yoova ve tataghon ŋgar toni, nene inim pughu pa ŋgar poia. Yes to titaghon saveeŋ toni, tiwatag ataam to tigham nepooŋ poia. Tovenen iit tapaiti irau sawa isob! ");
INSERT INTO tuc_o_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Aleluia, tapait Yoova! Ŋgeu to ighaze imatughez pa Yoova ve itaghon ŋgar toni, ve tutuuŋ to Yoova ighami lolo poia kat, nene pale tini iza, ve poia to Maaron iza toni. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Ve papaghu toni pale tinim ndiran to izadi tintina. Tovenen yes to tineep deŋiadi ila Maaron mata, tamtoghon to taan tonene pale titandag pa papaghu todi, ve poia to Maaron iza todi. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Ndiran deŋiadi, ruum todi ivon kat pa mbaliiŋ ve mbeb popoia katindi. Ve ŋgar todi deŋia pale ineep ariaŋa itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ighaze ŋgeu deŋia eta ineep ndoroom tiina lolo, nene pale ghazooŋa to Maaron isuli. Tamtoghon tovene lolo isasamin tamtoghon, ve ighamgham poian di, ve ipatooŋ ŋgar deŋia padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Ŋgeu to ighaze mata reiŋ mbeb, ve iyokia mbeb toni pa iuul tamtoghon, ve itaghon ŋgar deŋia moghon pa uraat toni, nene pale ineep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Tamtoghon to itaghon ŋgar deŋia, tovaaŋ eta irau ighami itap ne maau. Ve tamtoghon pale matadi kisini pa ŋgar poia toni tonowen itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Ighaze ilooŋ mbeb samia eta varu, ye irau imatughez maau. Pasa, inumeer Yoova, ve ghurla toni iyaryaaŋ kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Tovenen matughezaaŋ irau ighami maau. Iyoon ariaŋa, le ighita Maaron itatan koia. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Ye mata iŋgalŋgal yes mbolaaŋa, ve ireirei mbeb padi. Ŋgar toni deŋia pale ineep ariaŋa tovene itaghoni taghoni gha ila. Tovenen iza pale inim tiina, ve tamtoghon titandag pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Ndiran samsamiadi tighita ŋgar to ivotvot pani, le atedi yabyab, ve tiŋaaŋ mareer pani. Eemoghon irau tigham ŋgar eta pani ne maau. Pale pataŋani ivot padi ve tilaledi. Tovenen mbeb popoia to lolodi padi, nene irau tigham di maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Aleluia, tapait Yoova! Yam mbesooŋa to Yoova, apakuri, ve apait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Apait Yoova pa poia toni to aazne, ve itaghoni taghoni gha ila! ");
INSERT INTO tuc_o_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Yam to aneep ila pa ndag iza, ve ila pa yam to aneep ila pa ndag izila, apait Yoova iza! ");
INSERT INTO tuc_o_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yoova ineep sala kat, ve ndug tisob tineep ila samba. Iza ve tapiri ilib pa mbeb tisob to sambam. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Sei to irau Maaron tiei Yoova? Eta maau. Ye inepneep ila ina to ghamuuŋ pooz to ineep sala kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Tovenen mata izila le izila kat to sila we, ghoro ighita mbeb to sambam paroŋania ve taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","8","Eemoghon yes to ledi izadi maau, ve yes mbolaaŋa to moghon moghon tilala ndug to piyavooŋ buzbuz, ve tikalkaal adi aniiŋ, ye lolo imaagh padi maau. Ye ipapakur di ve iuluul di, leso tineep pooi toman tinidi iza. Tovenen yes irau tineep toman yes daba to tighamgham pooz pa tamtoghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ve yes ndiliva to upadi, ye ighamgham ledi inadi popoia to nepooŋ, ve ighamgham ledi ndinatudi. Tovenen tineep toman ndinatudi tonowen, ve lolodi poia kat. Aleluia, tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Muuŋ, Israela tipul Isip ve tila. Yakop papaghu toni tipul tamtoghon to aliŋadi ite, ve tivot. ");
INSERT INTO tuc_o_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Sawa tonenen, yes Yuda tinim Yoova ina patabuaŋ to nepooŋ. Ve yes Israela, tineep ila ye nima, ve iŋgin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Sawa to Te Kaviaaŋa ighita Yoova tamtoghon toni tinim, ye imatughez ve ighau. Ve ya Yordan ighita di, le ipamuula ilooŋ ila ve ipot inimale ya naliu. ");
INSERT INTO tuc_o_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Ve lolooz tovene paam. Yoŋgyoog itok, le tiyatov di tinimale mekmek. Ve ndug mbuŋa mbuŋa tiyatov di tinimale sipsip ndinatu. ");
INSERT INTO tuc_o_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","O te, sa mbeb ivot payom to ughau? Ve ya Yordan, pughu vena to upamuula ulooŋ ula ve upot unumale ya naliu? ");
INSERT INTO tuc_o_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ve yam lolooz ve ndug mbuŋa mbuŋa, ayatov gham pasa? ");
INSERT INTO tuc_o_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","O taan, upatum ghom! Pasa, mala maau pale Yoova inim. Paam Maaron to Yakop inim, ve ipatooŋ tapiri payom. ");
INSERT INTO tuc_o_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Ye to igham ya ivot ila yaam, ve izi ipot inimale ya naliu. Onoon kat, ye igham ya ivot ila yaam ariaŋa, ve ireer izi. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","O Yoova, yei lolomai pa tamtoghon tipait izamai malep. Tipait yom izam pa tapirim ve poia tiom, ghoro poia. Pasa, lolom ineep tuŋia ila to tamtoghon tiom ve uluul di, ve utaghon saveeŋ mbuaaŋ tiom irau sawa isob. Tovenen upatooŋ tapirim, ve uul ghei. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Pa vene, ndug ndug tiveleg ghom, ve tisaav payei tighaze: “Aa, Maaron tiam ineep sine?” ");
INSERT INTO tuc_o_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Eemoghon yei niwatag: Maaron tiei, ye ineep izi sambam. Ve sa ŋgar to ye ighaze ighami, nene ighami moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Ndug ndug tighagharaat maaron todi pa silva ve gol. Maaron kaaromŋa tonowen, tamtoghon tigharaat di pa nimadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Yes ledi avodi. Eemoghon tisavsaav maau. Ve ledi matadi. Eemoghon tighita ndug maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Yes ledi taliŋadi. Eemoghon tilooŋ saveeŋ maau. Ve ledi uzudi. Eemoghon tiyaaz mbeb eta vuzi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Yes ledi aghedi. Eemoghon irau tilaagh maau. Ve ledi nimadi. Eemoghon irau tikis mbeb eta ve tiyamaana ne maau. Onoon kat, saveeŋ ma taŋiiz eta ivot pa avodi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Tamtoghon to tighagharaat maaron kaaromŋa tovene ve tinumeer di, yes tisob tinimale maaron todi tonowen. Tirau mbeb eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Yam ival tiina to Israel, anumeer Yoova. Pasa, ye to Volaaŋa tiam, ve inim sigeu payam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Ve yam to watooŋrau to avot ila to Aron ne paam, anumeer Yoova! Pasa, ye to Volaaŋa tiam, ve inim sigeu payam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Tovenen yam to amatughez pa Yoova ve ataghon ŋgar toni, yam asob anumeera. Pasa, ye to Volaaŋa tiam, ve inim sigeu payam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yoova mata iŋgalŋgal ghei. Ve ye pale ighur poia toni iza tiei. Pale ighur poia toni iza to yes to watooŋrau to tivot ila to Aron. Ve ighur poia toni iza to ival tiina to Israel paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Tovenen yes to timatughez pani ve titaghon ŋgar toni, ye pale ighur poia toni iza to yes tisob. Yes to ledi izadi maau, ve yes to izadi tintina ne paam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Yoova pale igham gham toman papaghu tiam amasa anim naol. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yoova to ighur sambam ve taan. Ye pale ighur poia toni iza tiam. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Sambam, nene Yoova ndug toni. Ve taan, nene ye igham pa iit tamtoghon pa taneep ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Yes to timaat ve tizila ndug to mateeŋa, eta iyou oroor maau. Neneeŋadi moghon. Irau tipait Yoova muul maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Eemoghon iit to taneep mataad iyaryaar, ghoro lolood poia pa Yoova, ve tapaiti pa poia toni. To aazne, ve itaghoni taghoni gha ila. Aleluia, tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","2","You lolog pa Yoova kat pasa, ye ilooŋ taŋiiz tiou. You nataŋ rorani pa ulaaŋ, ve ye ighur taliŋa payou, ve iuul ghou. Tovenen sawa to naneep izi taan, suŋuuŋ tiou pale iŋarua irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Liis to mateeŋ, rismoghon tone igham ghou. Ravraav to mateeŋ ikau ghou, ve ighaze ighereb ghou nazila ndug to mateeŋa. Tovenen igham lolog ipataŋan, ve matughezaaŋ tiina igham ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Tauto nataŋ roran Yoova naghaze: “O Yoova, paam namaat. Uul ghou lak!” ");
INSERT INTO tuc_o_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yoova lolo isasamin ghiit, ve ighamgham poian ghiit. Ŋgar toni, nene deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yes to irau tiuul taudi maau, Yoova tau iŋgin di, ve iuluul di. Inimale you. Sawa to pataŋani itatan ghou le tapirig isob, ye inim ve igham mulin ghou. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Tauto aazne, ateg izi ve lolog poia muul. Pasa, Yoova igham poian ghou kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","9","Onoon kat, ye igham mulin ghou pa mateeŋ, ve ipasob taŋiiz tiou. Ve ye to ikiskis ghou. Tauto natap maau, ve aazne naneep matag iyaryaar. Ve laghooŋ tiou, nazuaria ghou naghaze le nataghon ŋgar to deŋia moghon ila Yoova mata. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Muuŋ, you nasaav pa taug naghaze: “Pataŋani tiina igham ghou le naneep sami.” Eemoghon nakis ghurla tiou tuŋia. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Pataŋani tonowen igham ghou le nakaal ataam. Tovenen napiyaav saveeŋ sorok naghaze: “Tamtoghon tisob, avodi kaarom moghon. Irau nanumeer eta maau.” ");
INSERT INTO tuc_o_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Pale nagham sa pa Yoova, leso nayat ŋgar popoia naol to ye igham payou ne? ");
INSERT INTO tuc_o_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","You pale nagham rubruub vaen, ve naliŋi izala watooŋrau tiou pogho pa napaiti, ve nasuŋ pani toman lolog poia. Pasa, ye igham mulin ghou pa pataŋani tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Tovenen sawa to Yoova tamtoghon toni tilup di pa suŋuuŋ, you pale nataghon saveeŋ to nambua tomani, ve nagham uraata ila matadi. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yes to lolodi ineep tuŋia ila to Yoova ve titaghon ataam toni, ye lolo padi kat. Tovenen ye irau ighita mateeŋ to todi eta inimale mbeb sorok ne maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Yoova, you mbesooŋa tiom. Nambesmbees payom inimale muuŋ tinaŋ imbesmbees payom. Muuŋ, nepooŋ tiou inimale tikau ghou pa ravraav ve sen. Eemoghon yom upoola payou, tauto aazne naneep pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Tovenen you pale nagham watooŋrau payom, ve nasuŋ payom toman lolog poia, ve napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","19","Sawa to Yoova tamtoghon toni tizala Yerusalem, ve tilup di pa suŋuuŋ ilooŋ ila sirsiir to rumai toni lolo, you pale nataghon saveeŋ mbuaaŋ tiou tonene, ve nagham uraata ila matadi. Aleluia, tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Yam tamtoghon to ndug ndug, apait Yoova! Yam to aneep irau taan, asob andae iza ve apakuri. ");
INSERT INTO tuc_o_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Pasa, poia toni, nene tiina le tiina kat. Ye lolo ineep tuŋia ila to tamtoghon toni, ve iuluul di irau sawa isob. Ve ŋgar to taghoniiŋ saveeŋ mbuaaŋ toni paam, inepneep tovene, itaghoni taghoni gha ila. Aleluia, tapait Yoova! ");
INSERT INTO tuc_o_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Lolomim poia pa Yoova ve apaiti! Pasa, ye poia kat. Lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Yam ival tiina to Israel, alup avomim ve asaav aghaze: “Ye lolo pa tamtoghon toni ve iuluul di.” ");
INSERT INTO tuc_o_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Ve yam to watooŋrau to avot ila to Aron ne paam, asaav aghaze: “Ye lolo pa tamtoghon toni ve iuluul di.” ");
INSERT INTO tuc_o_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Tovenen yam to amatughez pa Yoova ve ataghon ŋgar toni, asob asaav aghaze: “Ye lolo pa tamtoghon toni ve iuluul di.” ");
INSERT INTO tuc_o_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Muuŋ, you naneep ila pataŋani tiina lolo ve leg ataam maau. Tovenen nataŋ roran Yoova pa ulaaŋ. Ve ye ilooŋ aliŋag, ve ipas ghou navot pa pataŋani tiou. Tauto aazne, naneep ila ndug ghazooŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Ighaze Yoova ineep digeg, you irau namatughez maau. Pasa, tamtoghon pale tigham sa payou? ");
INSERT INTO tuc_o_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yoova ivool tiou, ve iuluul ghou. Ye pale itatan koiagŋa ila matag, ve nalib padi. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Iit tanumeer tamtoghon to taan malep. Tanumeer Yoova ve tayooŋ ila toni, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Yes daba to tighamgham pooz ne paam, tanumeer di malep. Tanumeer Yoova ve tayooŋ ila toni, ghoro poia. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Muuŋ, ndug ndug tinim tiluvut ghou tighaze tigham malmal payou. Eemoghon Yoova ipalot ghou, tauto napasob di. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Tiŋarua ghou tinim, ve tiluvut ghou, le leg ataam eta pa naghau maau. Eemoghon Yoova, tauto napasob di. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Yes timorau ghou tinimale ŋguruub. Eemoghon Yoova ipalot ghou, tauto napasob di le tapiridi isob. Yes tinimale yab to ighan reg ve iyaryaar, ve rikia moghon imaat. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Yes tipamundigin malmal payou, ve rismoghon tone titatan ghou. Eemoghon Yoova iuul ghou, tauto tiwaghamun ghou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Pasa, ye Volaaŋa tiou ariaŋa. You naghamgham tapirig ila toni, ve ye inim sigeu payou. Tauto nambou mbouŋ pa napait iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Alooŋ. Ndiran deŋiadi tinepneep ila mbeez todi todi, ve timboboob ve tipapait Yoova iza toman lolodi poia. Pasa, ye ilib pa koiadi wa. Tisavsaav tighaze: “Yoova nima waan, nene pataŋani. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Nima iparab ariaŋa kat. Ye igharaat tau pa malmal, ve iparab le ilib pa koia!” ");
INSERT INTO tuc_o_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","You pale namaat sone. Pale naneep matag iyaryaar. Leso navotia uraat tintina to Yoova ighamgham di. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Onoon, ye ilos katin ghou. Eemoghon ipul ghou namaat maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Tovenen akaak ataam to ndiran deŋiadi payou. Leso nataghoni nalooŋ nala, ve napait Yoova pa ŋgar to ye igham payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Nene ataam to Yoova. Yes to tineep deŋiadi ila ye mata, ghoro titaghoni tilooŋ tila. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Yoova, yom ulooŋ suŋuuŋ tiou, ve ugham mulin ghou pa pataŋani tiou. Tovenen lolog poia payom, ve napait ghom. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Yaam to yes to reiŋ ruum matadi velegini ve tipiyaava ilale, tauto inim pughu pa ruum ve ipaloti. Leso ruum iyoon ariaŋa izala pogho. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Maaron tau igham mbeb tonene ivot. Ve yei nighita inimale mbeb gharatooŋa eez ila matamai. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Ndag to aazne, Yoova ighuri. Tovenen tiniid iza ve lolood poia pani. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","O Yoova, lolom isamin ghei, ve ugham mulin ghei! Uul ghei, leso mbeb tisob tivot pooi payei. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Ŋgeu tonene inim pa Yoova iza. Tovenen poia to Yoova pale iza toni. Yei to nineep ila Yoova rumai toni lolo, nighasoni nighaze ighur poia toni iza tiam. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yoova, ye Maaron tau! Ye igham poian ghiit, ve ghazooŋa toni isul ghiit. Akis napatolo mbila ve ala aluvut artaal ve apaiti. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Yom Maaron tiou. You lolog poia payom, ve napait ghom pa poia tiom. Onoon kat, yom to Maaron tiou. Tovenen you pale nait izam. ");
INSERT INTO tuc_o_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Lolomim poia pa Yoova, ve apaiti pa poia toni. Pasa, ye poia kat. Ye lolo ineep tuŋia ila to tamtoghon toni ve iuluul di. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Yes to tighamgham sosor maau, ve laghooŋ todi deŋia moghon itaghon saveeŋ to Yoova, nene pale poia toni izaza todi ve tinidi iza. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","3","Yes to matadi kisin ataam to Maaron ighuri pa tamtoghon toni ve titaghoni, ve tighur lolodi kat pa Maaron, ve tizuaria di leso tiwatagi kat, ve tighamgham sosor maau, ve laghooŋ todi, titaghon ataam to Maaron, nene pale poia to Maaron iza todi ve lolodi poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Yoova, yom ughaze nitaghon tutuuŋ tiom eŋaeŋa ŋgara le nitaghoni kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Tutuuŋ tiom to tineep pataghaaŋ, ŋgar tiou iyaryaaŋ naghaze le nataghon katin di. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Pasa, ighaze matag iŋgal tutuuŋ tiom tisob, nene irau mayag ila ival tiina matadi maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ataam tiom to gabizooŋ mbeb, nene deŋia moghon. Ighaze upatooŋ ghou pani, nene pale lolog poia payom, ve napait ghom toman lolog ŋgalaaŋa. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Tutuuŋ tiom naol to tineep pataghaaŋ, you pale matag kisin di, ve nataghon di irau sawa isob. Tovenen upul murim payou malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Ighaze pain paghu eta lolo pa laghooŋ toni iŋgalaaŋ ila matam, pale igham sa? Ye irau mata iŋgal aliŋam ve itaghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","You naghur lolog payom kat, ve nazuaria ghou naghaze le nawatag katin ghom. Tovenen upul ghou nayel pa tutuuŋ tiom malep. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","You naghita aliŋam naghaze nene mbeb tau. Tovenen naghur poiani ineep ila lolog. Leso ipalot ghou, ve nagham sosor payom sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Yoova, you napait ghom pa poia tiom. Upaghazoŋan ghou pa tutuuŋ tiom naol to tineep pataghaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Tutuuŋ tiom naol to yom uvotia di, you pale nasavia di le tisob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ataam to yom ughuri payei, sawa to nataghoni, nene igham lolog poia kat, nanimale yes to tipakur di pa mbaliiŋ to taan. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Matag itaghon tutuuŋ tiom eŋaeŋa ŋgara naghaze le naghazooŋ padi. Ve matag iŋgalŋgal ataam tiom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Tutuuŋ tiom naol to tineep pataghaaŋ, tigham lolog poia le poia kat. Irau lolog imaagh pa aliŋam maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","O Yoova, you mbesooŋa tiom. Upatooŋ poia tiom payou. Leso naneep pooi, ve nataghon aliŋam irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Upaghazoŋan ŋgar tiou, leso naghilaal ŋgar popoia naol to tineep ila saveeŋ tiom lolo. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Taan tonene, nene ndug tiou kat maau. You naneep nanim loom pani moghon. Tovenen ugham ghou naghazooŋ pa tutuuŋ tiom naol ŋgara. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Moghon moghon, you lolog naghaze le upatooŋ ghou pa ataam tiom to gabizooŋ mbeb, ghoro poia! ");
INSERT INTO tuc_o_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Yes to tipapait taudi ve tiveleg ghom, yom uyaan di, ve mbalmbali tiom izaza todi. Pasa, tiyel pa tutuuŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ve you, ghoro matag kisin ataam to yom ughuri payei, ve nataghoni irau sawa isob. Tovenen saveeŋ velegiiŋ ve mayaŋiiŋa to tipiyaav di payou ne, yom upaghau di payou. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Yes daba to tighamgham pooz ne paam, tilup di, ve tikalkaal ataam tighaze tiwaghamun ghou. Eemoghon you mbesooŋa tiom. Pale matag itaghon tutuuŋ tiom naol to tineep pataghaaŋ, ve nagham ŋgar padi pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Ataam to yom ughuri payei, nene igham lolog poia le poia kat. Ve ipasaluŋgan ghou, leso nawatag sa ŋgar to pale nataghoni. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","You tapirig isob, ve rismoghon tone namaat ve nagheen ila ghavuur. Upamundigin ghou, ve ugham tapirig ivot muul itaghon saveeŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ŋgar naol to naghamgham di ne, you navotia di payom. Tauto ulooŋ suŋuuŋ tiou, ve uul ghou. Upaghazoŋan ghou pa tutuuŋ tiom naol to tineep pataghaaŋ. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Tutuuŋ naol to yom ughur di, upatooŋ ghou pa ataam to nataghon di. Ve you pale matag itaghon uraat tiom gharatooŋadi, ve nagham ŋgar padi pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","You lolog ipataŋan le tapirig isob. Upalot ghou itaghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Uul ghou pa naneep saguan pa ŋgar kaarom. Saveeŋ tiom, nene inim ataam pa poia tiom iza tiou. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","You lolog ighur naghaze you pale nataghon ataam to saveeŋ onoon. Ve matag iŋgalŋgal ataam tiom to gabizooŋ mbeb. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Yoova, ataam to yom ughuri payei, you nakisi ineep tuŋia ila lolog. Tovenen upul ghou malep! Pa vene, mayag. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Yom upatooŋ ghou pa mbeb katindi. Tauto tinig iza pa nataghon ataam to tutuuŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Yoova, tutuuŋ tiom naol to tineep pataghaaŋ, upatooŋ ghou pa ataam to nataghon di. Leso matag kisin di, ve nataghon di ila ila le sawa tiou isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Upaghazoŋan ghou pa saveeŋ tiom ŋgara. Leso matag kisini, ve nataghoni toman lolog irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Umuuŋ ve upatooŋ ataam payou, leso nataghon tutuuŋ tiom. Pasa, ataam tonenen to igham lolog poia le poia kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Upamundigin lolog, leso nataghon ataam to yom ughuri payei, ve nagham ŋgar pa ndouŋ leg mbaliiŋ to taan sob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Upaghau matag pa mbeb soroksorok to taan to anoŋadi maau ne, ve upalot ghou pa nataghon ataam tiom. Leso naneep matag iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","You mbesooŋa tiom. Tovenen matam iŋgal saveeŋ mbuaaŋ tiom, ve ugham anoŋa ivot payou. Saveeŋ tiom tonenen iŋarua tamtoghon tisob to timatughez payom ve titaghon ŋgar tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Saveeŋ samia to koiagŋa tipiyaava payou, nene igham ghou namatughez. Pasa, ighaze tamtoghon tighur ila saveeŋ todi tonowen, nene pale mayag. Tovenen utatan saveeŋ todi, leso tamtoghon tighur ila sob. Pasa, ataam tiom to gabizooŋ tamtoghon, nene deŋia moghon. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","O Yoova, you naghaze nataghon tutuuŋ tisob to yom ughur di. Tovenen utaghon ŋgar tiom deŋia, ve ugham ghou naneep matag iyaryaar. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","O Yoova, you nawatag: Yom lolom ineep tuŋia ila to tamtoghon tiom ve uluul di. Upatooŋ ŋgar tonanan payou paam, ghoro poia. Tovenen ugham mulin ghou pa pataŋani tiou itaghon saveeŋ mbuaaŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Leso you irau napamuul saveeŋ velegiiŋ to tipiyaava payou. Pasa, you naghur ila saveeŋ tiom. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","You naghur matag pa gabizooŋ tiom. Tovenen uul ghou lak! Leso avog ivotia gabuam to avom onoon ve utaghon saveeŋ tiom irau sawa isob. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","You pale nataghon saveeŋ tiom irau sawa isob. To aazne, ve itaghoni taghoni gha ila. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Tutuuŋ to yom ughur di, you nazuaria ghou pa nataghon di. Tovenen mbeb eta irau ipoon ataam payou maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ataam to yom ughuri payei, you pale navotia ila yes kinik matadi paam. Pasa, you namatughez, ma mayag pa tamtoghon eta maau. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Tutuuŋ tiom to naol ne, tigham lolog poia le poia kat. Tauto lolog padi kat. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","You lolog pa tutuuŋ tiom to naol ne ve napatab padi. Tovenen nakaak nimag, ve napait ghom pa tutuuŋ tiom. Tutuuŋ tiom naol to tineep pataghaaŋ, matag itaghon di naghaze nagham ŋgar padi pooi. ");
INSERT INTO tuc_o_vpl VALUES ("PS119_49","020_119_49","PSA","119