﻿USE sofia;
DROP TABLE IF EXISTS sofia.ttqt_vpl;
CREATE TABLE ttqt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ttqt_vpl WRITE;
INSERT INTO ttqt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵙⵎⵓⵏ ⵏⵍⵌⴹⵏ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵂⵢⴰ ⵏⵏⵀⵢ ⴹⵓⴹ ⴹⵏⵀⵢ ⵀⵔⵂⵎ ");
INSERT INTO ttqt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ⵀⵔⵂⵎ ⵔⵓ ⵙⵂⵆ⵰ ⵙⵂⵆ ⵔⵓ ⵢⵆⵀ⵰ ⵢⵆⵀ ⵔⵓ ⵢⵂⴹⴰ ⴹⵎⴹⵔⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ⵢⵂⴹⴰ ⵔⵓ ⴼⵔⵙ ⴹⵤⵔⵈ ⵏⵏⵙⵏ ⵙⵎⵏⵜ ⵜⵎⵔ⵰ ⴼⵔⵙ ⵔⵓ ⵈⵙⵔⵏ⵰ ⵈⵙⵔⵏ ⵔⵓ ⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ⵔⵎ ⵔⵓ ⵗⵎⵏⴹⵀ⵰ ⵗⵎⵏⴹⵀ ⵔⵓ ⵏⵛⵏ⵰ ⵏⵛⵏ ⵔⵓ ⵙⵍⵎⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ⵙⵍⵎⵏⴰ ⵔⵓ ⵀⵈⵤ ⵓⵙ ⵏⵏⵜ ⵔⵂⵀ⵰ ⵀⵈⵤ ⵔⵓ ⵗⵀⵢⴹ ⵓⵙ ⵏⵏⵜ ⵔⵜ⵰ ⵗⵀⵢⴹ ⵔⵓ ⵢⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ⵢⵙⵢ ⵔⵓ ⴹⵓⴹ ⵓⵏ ⵎⵏⴾⵍ⵰ ⴹⵓⴹ ⵔⵓ ⵙⵍⵎⵏ ⵓⵙ ⵏⵏⵜ ⵜⵏ⵿ⵜⵜ ⵏⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ⵙⵍⵎⵏ ⵔⵓ ⵔⵈⵀⵂⵎ⵰ ⵔⵈⵀⵂⵎ ⵔⵓ ⵀⵢⴰ⵰ ⵀⵢⴰ ⵔⵓ ⵤⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ⵤⴰ ⵔⵓ ⵢⵂⵛⴼⵜ⵰ ⵢⵂⵛⴼⵜ ⵔⵓ ⵢⵔⵎ⵰ ⵢⵔⵎ ⵔⵓ ⵗⵤⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ⵗⵤⵢⵙ ⵔⵓ ⵢⵜⵎ⵰ ⵢⵜⵎ ⵔⵓ ⵈⵤ⵰ ⵈⵤ ⵔⵓ ⵈⵤⵆⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ⵈⵤⵆⵢⵙ ⵔⵓ ⵎⵏⵛⴰ⵰ ⵎⵏⵛⴰ ⵔⵓ ⵎⵏ⵰ ⵎⵏ ⵔⵓ ⵢⵛⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ⵢⵛⵢⴰ ⵔⵓ ⵢⴾⵏⵢⴰ ⴹⵎⴹⵔⵢⵏⵜ⵰ ⵤⵎⵏ ⵓⵏ ⴹⵏ ⵏ⵿ⵜⵏⵢ ⴰ ⴹⵗ ⵜⵓⵗⵏ ⴾⵍⵙⵔⵢⵍ ⵎⵓⵢⵏ ⵙⴾⵍ ⵏⵀⵀⵢⵍⵏ ⵆⵍⵏ ⴹⵗⵙ ⴾⴼⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ⴹⴼⵔ ⴹⵢ ⵔⵓ ⵢⴾⵏⵢⴰ ⵛⵍⵜⵢⵍ⵰ ⵛⵍⵜⵢⵍ ⵔⵓ ⵤⵔⵀⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ⵤⵔⵀⵀⵍ ⵔⵓ ⵀⵂⴹ⵰ ⵀⵂⴹ ⵔⵓ ⵍⵢⵆⵎ⵰ ⵍⵢⵆⵎ ⵔⵓ ⵢⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ⵢⵤⵔ ⵔⵓ ⵙⴹⵆ⵰ ⵙⴹⵆ ⵔⵓ ⵈⴾⵎ⵰ ⵈⴾⵎ ⵔⵓ ⵍⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ⵍⵢⴹ ⵔⵓ ⵍⵢⵤⵔ⵰ ⵍⵢⵤⵔ ⵔⵓ ⵎⵜⵏ⵰ ⵎⵜⵏ ⵔⵓ ⵢⵆⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ⵢⵆⵀ ⵏ⵿ⵜⴰ ⵔⵓⵏ ⵢⵙⴼ ⵓⴰ ⵤⵍⴼⵏ ⵎⵔⵢⵎⴰ ⵜⴰ ⵜⵔⵓⵜ ⵗⵢⵙⴰ ⵓⵙ ⵜⵓⵏⵓ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ⴹⵗ ⴹⵢ ⵎⵔⵓ ⵎⴹⵏ ⴹⴾⵤ ⵍⵏⵏ ⴶⵔ ⴹⵓⴹ ⴹⵎⵔⵓⵏⵜ ⵀⵔⵂⵎ⵰ ⵍⵏ⵿ⵜⵓ ⵎⵔⵓ ⴹⴾⵤ ⴶⵔ ⴹⵓⴹ ⴹⵤⵎⵏ ⵓⵏ ⵜⵓⴾⴼⵍ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵙ ⵀⵀⵢⵍⵏ ⵍⵏ⵿ⵜⵓ ⴹⵗ ⵎⵔⵓ ⴹⴾⵤ ⴶⵔ ⵜⵓⴾⴼⵍ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵙ ⵀⵀⵢⵍⵏ ⴹⵜⵂⵓⵜ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ⵏ⵿ⵜⴰ ⴹⴰ ⵎⴾ ⵓⵙ ⴹⴶⵤ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵏⵜ ⵎⵔⵢⵎⴰ ⵜⵏ ⵏⴰ ⵏ⵿ⵗⵢⵙⴰ ⵎⵔⴾⵏ ⴹⵔⵙ ⵢⵙⴼ ⵤⵍⴼ⵰ ⵎⵛⵏ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⵤⵍⵢ ⵙ ⵢⵙⴼ ⵙ ⵜⴶⴰ ⵜⴹⵙ⵿ⵜ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ⵢⵙⴼ ⵎⵙⵏ ⵍⵙ ⵗⴹⵏ ⵓⵔ ⵔⴰ ⵙⴾⵔⴾⴹ ⵏⵎⵔⵢⵎⴰ ⴹⵗ ⵢⵜⴹⵏ⵰ ⵓⵏ ⴹⵗ ⴼⵍ ⵙⵎⵔⴾⵙ ⴹⵗ ⵎⵏⵜ ⵙ ⴹⵔⵙ ⵗⵔⴹ ⴹⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⵂⵏ ⵙⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ⵙⵎⴹⵔⵏ ⴹⵗ ⵓⵏ ⴹⴰ ⵙ ⵜⵏⵀⵤ ⵜⵙ ⵏⴼⵍⵍⵙⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⴹⵗ ⵜⵔⴶⵜ ⵏⵙ «ⵢⵙⴼ ⵂⵢⴰ ⵏ⵿ⴹⵓⴹ ⴾⵢⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ ⵏⵤⵍⴼ ⵏⵎⵔⵢⵎⴰ ⴼⵍⵙ ⵀⵔⵔ ⵓⴰ ⵂⵏ ⵜⴹⵙ⵿ⵜⵏⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ⴹ ⵜⴶⵔⵓ ⵀⵔⵔ ⵎⵔⵏ ⴾⵢ ⴶⵙ ⵙⵎ ⵗⵢⵙⴰ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵤⵙⴼⵙⵏ ⵜⵎⵜⵢⵏⵜ ⴹⵗ ⵀⴾⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ⵔⵜ ⵓⴰ ⴾⵍ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴹⵎⵍ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ⴹ ⵜⴶⵓ ⵜⵎⵓⵜ ⵜⴹⵙ⵿ⵜ ⴹⴰ ⵓⵔ ⵜⵤⴹⵢ ⵎⴹⵏ ⵜⴶⵔⵓ ⵀⵔⵔ⵰ ⵀⵔⵔ ⵓⴹⵢ ⴹⵙⵜⵓⴶⵓ ⵙⵎ ⵎⵏⵓⵍ ⵍⵎⵗⵏⴰ ⵎⵛⵏⴰ ⵍⴰ ⵗⵔⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ⵙ ⴹⵏ⵿ⴾⵔ ⵢⵙⴼ ⴹⵗ ⵜⵙ ⵎⵤⵍ ⵙⵔⵜ ⵓⵙ ⵜⵎⵔ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵤⵍⴼ ⵎⵔⵢⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ⵎⵛⵏ ⵓⵔ ⴾⵍⴰ ⴹⵔⵙ ⵏⵎⵏ⵿ⵙⴰ ⵂⵔ ⵂⵓ ⵀⵔⵔ⵰ ⵙ ⵂⵓ ⴶⵙ ⵢⵙⴼ ⵙⵎ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ⵤⵎⵏ ⵏⵎⵏⴾⵍ ⵂⵔⴹ ⴹⵗ ⵂⵓ ⵗⵢⵙⴰ ⴹⵗ ⵗⵔⵎ ⵏⵀⵜⵍⵈⵎ ⴹⵗ ⵎⴹⵍ ⵏⵢⵂⴹⵢⴰ⵰ ⴶⵍⵏ⵿ⴹⵓ ⵎⵙⵏⵏ ⵏⵎⵏⵢⵏ ⴹⴼⵍⵏⵏ ⴹⵏⴶ ⵂⵔ ⴹⵙⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ⵏⵏ «ⵎⴰ ⴶⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⴰ ⵂⵓⵏ ⴹⴰ ⵙⴾⵜ⵰ ⵜⵔⵏⵜ ⵏⵏⵢ ⴹⵗ ⴹⵏⴶ ⵎⵔⵏ ⵏⴾⵢⴹⵓ ⵢⴹⵙⵏⵙⵌⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ⵔⵜ ⵓⴰ ⵙ ⵜⵙⵍⴰ ⵎⵏⴾⵍ ⵂⵔⴹ ⴶⴰ ⵛⵓⵛⴰ ⵤⵓⵔⵏ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⴾⵍⵢⵔⵙⵍⵎ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ⵛⴹⵓⴹⵓ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⴹⴹⴶ ⵓⴰ ⴹⵗ ⵤⵂⵓ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ⵏⵏⵙ «ⵗⵔⵎ ⵏⵀⵜⵍⵈⵎ ⴹⵗ ⵤⵂⵓ ⴹⵗ ⵎⴹⵍ ⵏⵢⵂⴹⵢⴰ ⴼⵍⵙ ⵏⵀⵢ ⵎⴾⴰ ⴾⵜⵀ ⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","\"ⴾⵎ ⵎⵔⵏ ⵀⵜⵍⵈⵎ ⵜⵏ ⵎⴹⵍ ⵏⵢⵂⴹⵢⴰ ⵜⵂⵗ ⵗⵔⵎⵏ ⵓⵏ ⵗⴼ ⴹⵗ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴼⵍⵙ ⴾⵎ ⴹⵤⴶⵎⴹ ⵎⵤⵔ ⵓⴰ ⵤⴶⵏ ⵢ ⵜⵎⵜⵢⵏⵏ ⵙⵔⵢⵍ ⵜⵤⵔ⵿ⵜ ⵜⴰ ⵜⴶⵓ ⵎⴹⵏ ⵢⵂⵔⵢⵏⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ⵜⵤⵔ ⵙⵙⵗⵔⴹⵓ ⵎⵏⴾⵍ ⵂⵔⴹ ⵎⵙⵏⵏ ⵓⵏ ⵎⵏⵢⵏ ⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⴶⵏ ⴹⵗ ⵙⵔ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⴹⵜⵎⵔ⵿ⵜ ⵜⵙ ⴶⵎⴹ ⵛⴾ ⵙ ⵏ⵿ⵜⴰ ⴹⵗ ⴹⵏⴼⵍⵍ ⵜⵔⵢ ⵓⴰ ⵎⵍⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ⴹⴼⵔ ⵓⵏ ⵙⴾⵏ ⵀⵜⵍⵈⵎ ⵏⵙⵏ «ⴶⵍⵓⵜ ⵜⴾⵏⵎ ⵙⵓⴹ ⵢ ⴹⴹ ⵍⴰ ⵀⵔⵔ ⵓⴰ ⵂⵓⵏ ⴹⴰ ⵙ ⵜⵜⴶⵔⵓⵎ ⵜⵎⵔⵎⴹⵓ ⵜⵎⵍⵎⵢ ⴹⴹ ⵍⴰ ⴼⵍ ⴹ ⵜⴾⴰ ⵙⵌⴹⵗⵙ ⵏⴾ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ⵙ ⴹⵙⵏⵗⵔⴹ ⵎⵏⴾⵍ ⵓⵍ ⴶⵍⵏ⵰ ⵜⵤⵔ ⴶⵏ ⵜⵔⵢ ⵓⴰ ⴹⵙⵏⵏⴼⵍⵍⵏ ⴹⵗ ⵌⵏⵓⵏ ⴹⵜ ⵓⵏ ⴹⵗ ⴹⵏⴶ⵰ ⵓⵔ ⵎⵤⵢ ⵜⵔⵏ ⴹ ⵍⴰ ⴹⵜⵙⵏ ⵤⵔⵙⵏ ⵙ ⵎⵍ ⴹⵏⴶ ⴹⴶ ⵓⴰ ⵂⴰ ⵀⵔⵔ ⵤⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ⵙ ⵏⵢⵏ ⵜⵔⵢ ⵙ ⵤⴾⵜ ⴾⵏⵏ ⵜⴼⵍⵓⵙ⵿ⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ⴶⵤⵏⵏ ⵂⵏ ⵏⵢⵏ ⵀⵔⵔ ⴹⵏⵏⵜ ⵎⵔⵢⵎⴰ ⴶⵔⴼⵏ ⵙⵌⴹⵏ ⵢ ⵀⵔⵔ⵰ ⴹⴼⵔ ⴹⵢ ⵔⵏ ⵍⵍⵏⵙⵏ ⴾⵙⵏⵙⴹⵓ ⴹⵗⵙⵏ ⵛⵀⴹⵔ ⴶⵏⵏ ⴹⵗ ⵔⵗ ⴹⵛⵏ ⵙⵆⴹⵏ ⵤⴹⵏⵏ ⵎⵙⵏⵏ ⵤⵏⴼ ⵏ⵿ⵜⵗⵍⵀⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ⴹⴼⵔ ⵓⵏ ⵙⵏⴼⵍⵍⵙⵏ⵿ⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⵜⵔⴶⵜ ⵙ ⴹ ⵓⵔ ⵆⵍⵏ ⵂⵔⴹ⵰ ⵓⵏ ⴹⴰ ⴼⵍ ⵀⵤⵏ ⵜⵔⵢⵜ ⵢⵜ ⵆⵍⵏ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ⴹⴼⵔ ⵙ ⴶⵍⵏ ⵏⴼⵍⵍⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵢ ⵢⵙⴼ ⴹⵗ ⵜⵔⴶⵜ ⵏⵙ «ⵏ⵿ⴾⵔ ⵜⴹⵓⵗ ⴹⵀⵔⵔ ⴹⵏⵏⵜ ⵜⴾⴰ ⵜⵔⵎⴹ ⴾⵍ ⵏⵎⵙⵔ ⵜⵆⵎⴰ ⴹⵗⵙ ⵂⵔ ⴹⴾⵎⵍⵗ ⵙⵗⴰ ⵓⴰ ⴹⵤⵜⵆⵍⴰ ⴼⵍⵙ ⵀⵔⵔ ⴹⵢ ⴹ ⴶⵎⵢ ⵂⵔⴹ ⴹⵜⵏⵗⵢⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ⵏ⵿ⴾⵔ ⵢⵙⴼ ⴹⵓ ⴹⵀⵔⵔ ⴹⵏⵏⵜ ⵓⵢ ⵂⴹ ⵀⵤ ⵜⵔⵢⵜ ⴾⴰ ⵎⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ⵆⵎⵏ ⴹⵗ ⵎⵙⵔ ⴹⵏ ⴹⴰ ⵂⵔ ⵀⴰ ⵂⵔⴹ⵰ ⵔⵜ ⵓⴰ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴹⴶⴰ ⵎⵍⵢ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙⵢ ⴹⵗ ⵏⴰ «ⵗⵔⴹⵓ ⵀⵔⵔⵏ ⵙⵔⴹⵗⵆⴹⵓ ⵎⵙⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ⵙ ⵙⵏ ⵂⵔⴹ ⵙ ⵎⵙⵏⵏ ⵓⵏ ⵎⵏⵢⵏ ⵎⵤⵔⵢⵏ ⵀⵜⵏⵜ ⵗⵍⵢⵏ⵿ⵜⵓ ⵗⵛⵛⵜ ⵎⵔ ⵙⴹ ⵜⵓⵏ⵿ⵗⵏ ⵀⵔⵔⵏ ⵏⵢⵢⵏ ⴾⵍ ⵓⵏ ⵂⵓⵏⵏ ⴹⵗ ⵗⵔⵎ ⵏⵀⵜⵍⵈⵎ ⴹⵗⵍⵢⵗⵍⵢⵏⵜ ⴹⵀⵤⵏ ⵗⵔ ⵛⵏ ⵍⵏ ⵂⵔ ⵤⵎⵏ ⵓⵏ ⴹⵏ ⵎⵙ ⵙ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⴹⴰ ⵙ ⴹⵙⵏⵏ ⵎⵙⵏⵏ ⵓⵏ ⵏ⵿ⵜⴰ ⴹⵗ ⴹⵏⴼⵍⵍ ⵜⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ⴹⵏ ⴹⵗ ⴹ ⵏ⵿ⴹⴰ ⵓⵍ ⵓⴰ ⴹⴶⴰ ⵎⵍⵢ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵔⵎⵢⴰ ⴹⵗ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«ⵜⴶⴹⵓ ⵜⴾⵔⵢⵜ ⴹⵗ ⵗⵔⵎ ⵏⵔⵎⴰ ⵎⵙ ⵓⵏ ⵜⵍⴰ ⵏⵢⵜⴹⵏ ⴼⵍ ⵜⴶⴰ ⵜⴼⵢⵓⵜ⵰ ⵓⵏ ⵔⵈⵍ ⵜⵏ ⵜⵎⵔⵓⵜ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵜⵂⵍⵜ ⴼⵍ ⵀⵔⵔⵏⵜ⵰ ⵓⵔ ⵜⵔⴰ ⵢ ⴹⵙⴶⵏ ⵍⵎⵗⵤⴰ ⴼⵍⵙ ⵀⵔⵔⵏ ⵌⵓⵔⵏ ⵀⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ⴹⴼⵔ ⵜⵎⵜⵏ⵿ⵜ ⵏⵂⵔⴹ ⵏⴼⵍⵍ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵢ ⵢⵙⴼ ⴹⵗ ⵜⵔⴶⵜ ⴹⵗ ⴾⵍ ⵏⵎⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⵏ⵿ⴾⵔ ⵜⴹⵓⵗ ⴹⵀⵔⵔ ⴹⵢ ⴹⵏⵏⵜ ⵜⵆⵍⵗ ⴾⵍ ⵏⵙⵔⵢⵍ ⴼⵍⵙ ⵢⵜⴹⵏ ⵓⵏ ⵔⵏⵏ ⵜⵏⵗⵢⵏⵜ ⵀⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ⵏ⵿ⴾⵔ ⵢⵙⴼ ⴹⵓ ⴹⵀⵔⵔ ⴹⵏⵏⵜ ⵆⵍ ⴾⵍ ⵏⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ⵎⵛⵏ ⴶⵔⵓ ⵙⵍⵏ ⵙ ⵔⴾⵍⵓⵙ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴹⵗ ⴹⴶ ⵏⵀⵏⵜ ⵂⵔⴹ⵰ ⵜⵤⵔ ⵜⴶⵤ ⵜⵙⴰ ⵢⵙⴼ ⵀⵙ ⵂⵍ ⴾⵢ ⵏⵢⵂⴹⵢⴰ ⴾⴰ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹ ⵎⵛⵏⴰ ⴹⵙⴹⵙⵏⴼⵍⵍⵏ ⵓⵏ ⴹⵗ ⵜⵔⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ⴶⵍⴰ ⵗⵙⵔ ⴹⵗ ⵗⵔⵎ ⵙ ⵜⵓⵏⵓ ⵏⵤⵔⵜ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⴶⵏ ⵔⵜⵏ ⵓⵏ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴹⴶⴰ ⵎⵍⵢ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵜⵏ ⵙ ⵏⵏ «ⵜⵓⴶⵙ ⵙⵎ ⵓ ⵏⵤⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ⵍⵏ ⴹⴼⵔ ⵓⵏ ⵙⵏ⵿ⵜⴰ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴶⵢ ⵏ⵿ⵜⵍⵈⵜⵀⵜ ⴹⵗ ⵜⵏⵔⵢ ⵏⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ⴶⵏⵓ «ⵜⵀⵜ⵰ ⵍⴾⵏ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ⵢⵈⵢⵏ ⴹⵗ ⴼⵍ ⵎⴶⵔⴹ ⵏⵀⵢ ⵙⵢⵙ ⵙⵗⴰ ⵓⴹ ⵏⴰ «ⵍⵙ ⵢⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⴹⵗ ⵙⴼ ⴶⵏⵓ \"ⵙⵎⵜⴶⵜ ⵀⵔⵆⴰ ⵢⵎⵍⵢ⵰ ⵜⵙⵙⵗⴹⵎ ⵜⵔⵢⵏ ⴹⵜⵙ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ⵢⵈⵢⴰ ⵍⵙⴰ ⵜⵀⴹⵆ ⵜⴶⵜ ⴹⵗ ⵏ⵿ⵤⴹⵏ ⵏⵎⵏⵙ ⵜⵀ ⵙⵙⵜⵀ ⵏⴶⵛⴾ⵰ ⴹⵔ ⵙⵌⵓⵍⵏ ⴹⵜⵔⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ⵜⵏ⵿ⵜⵙⵏ ⵢⵜⴹⵏ ⴶⵎⴹⵏ⵿ⴹⵓ ⵢⵔⵙⵍⵎ ⴹⴾⵍ ⴾⵜⵏⵜ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹⵎⴹⵍ ⴾⵍ ⵓⵏ ⵗⵍⵢⵗⵍⵢⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ⵜⵜⵀⵏ ⴹⵗ ⵀⴾⴹⵏⵙⵏ ⴹⵜ ⵜⵎⵜⵢ ⵙⵍⵎⵆⵏ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ ⴹⵗ ⴶⵔⵓ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ⵙⵏ⵿ⴹⵓ ⴼⵔⵙⵢⵜⵏ ⴶⵜⵏⵏ ⴹⵙⴹⵙⵢⵜⵏ ⵢⵜⵏⵙⵍⵎⵗ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ⵰ ⵙ ⵏⵢ ⵢⵈⵢⴰ ⵔⵜ ⵓⵏ ⵏⵙⵏ «ⵈⴰ ⵜⵛⵍⵏ ⵛⵏ⵰ ⵎⴰ ⴾⵓⵏⵙⵙⵏⵏ ⴹⵔⴶ ⵢⵜⴹⵀ ⵓⴰ ⴹⵤⵢⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ⴹⵗ ⴹⵢ ⵜⴶⵓⵜ ⵎⵤⵍⵏ ⵍⵗⵏⵏ ⵜⵙⵜⴹⵎ ⵙⵔⵙⵏ ⵜⵜⵀⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ⵓⵔ ⴶⴹⴰ ⴹ ⵜⴶⵏⵎ ⴹⵗ ⵎⵏⵓⵏ \"ⵏⴾⵏⵢ ⵤⵔⵢⴰ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⵏⵎⵙ\" ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵎⵛⵏⴰ ⴼⵔⴶ ⴹ ⵙⵎⵜⵢ ⵛⵂⵏ ⵛⵏ ⵜⵂⵏⵢⵎ ⴹⴰ ⵈⵍⴾⴹⵓ ⴹⵗⵙⵏⵜ ⵤⵔⵢⴰ ⵢⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ⴶⵜ ⵏⵢⵜ⵰ ⵜⵤⴼ⵿ⵜ ⵂⵔⵓⴰ ⵎⵔⴹⴰ ⴹⴰ ⵜⵎⵜⴶ ⵢⴹⵜⵙⴹⵏ⵿ⴶⵔ ⵢⵛⴾⵏ⵰ ⴹⵗ ⴹⵢ ⵛⴾ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵜⵔⵓ ⵔⵜⵏ ⵍⵗⵏⵏ ⴹ ⵜⵓⵗⵜⵙ ⵜⵓⴶⵔⵏ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ⵏⴾ ⵎⵏ ⴹⵆ ⵆⵓⵏ⵿ⵙⵍⵎⵗⴰ ⴼⵍ ⴹ ⵙⵏⴼⵍⵍⵗ ⵙⵓⵏ ⵜⵜⵀⵜⵏⵓⵏ⵰ ⵎⵛⵏ ⵓⴰ ⴹⵤⵙⵏ ⴹⴼⵔⵢ ⵓⴰ ⴹⴶⴰ ⴹⵗ ⵛⴶⵔⵜ ⵓⵔ ⵓⴹⴰ ⵓⵍⴰ ⵔⴰ ⵏ⵿ⵙⵗⵏ ⵏ⵿ⵗⵜⵎⵏⵜ⵰ ⵏ⵿ⵜⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵎ⵿ⵙⵢ ⴹⵆ ⵆⵓⵏ⵿ⵤⵙⵍⵎⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ⵂⴰ ⵍⵎⵜⵍ ⵏⵓⴹⵏ ⵜⴼⵏ ⵜⵙⵢⵜ ⵢⴹ ⵤⵤⵔ ⵍⴾⵎⵏⵜ⵰ ⵛⴹⵓ ⵍⴾⵎⴰ ⴹⵗ ⵜⴹⵏ⵿ⴶⵓⵜⵏⵜ ⵛⵗⵍ ⵎⵔⵏ ⴶⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵜⵀⵍⴶⵍⴶⵜ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⴹⵙⴰ ⵗⵢⵙⴰ ⴶⵎⴹⵓ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴾⴹⵓ ⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⵢⴹ ⵜⵙⵍⵎⵗ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ⵎⵛⵏ ⴶⵎⵢ ⵢⵈⵢⴰ ⴹⵗⵙ ⴾⵙ ⵓⵏ⵰ ⵏⵙ ⵢⵈⵢⴰ «ⵏⴾ ⴹⵔⵔⵏ ⵙⴹⵜⵙⵍⵎⵗⴰ ⴹⵗ ⵎⵏ ⵎⵔⵏ ⴾⵢ ⵎⵏⴾ ⴹⴹⴾⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⵎⵔⴹⴰ ⵔⴹⵓ ⵙⵔⵜ ⵓⴹⵢ ⴹⴰ ⴼⵍⵙ ⵍⵤⵎⵏⵗ ⴹ ⵏⵙⵏ⵿ⴹⵓ ⵔⵜ ⴾⵍ ⵓⴰ ⵔⴰ ⵎⵛⵏⴰ⵰» ⵜⵤⵔ ⵔⴹⴰ ⵢⵈⵢⴰ ⵙⵙⵍⵎⵗ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ⵜⵓⵙⵍⵎⵗ ⵗⵢⵙⴰ ⵗⵙ ⴶⵎⴹⵓ ⵎⵏ ⵏⵍⵎⵏ ⵌⵏⵓⵏ ⴹⵗ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴶⴰ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵙ ⴹⴶⵎⴹ ⵌⵏⵓⵏ ⵂⴰ ⵛⵛⵍⵏ ⵏ⵿ⵜⴹⵀⵔ⵿ⵜ ⵓⵔ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ⴶⵎⴹⵓ ⵎⵙⵍⵢ ⵌⵏⵓⵏ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⵢ ⵀⵔⵔⵏ ⴾⵏ ⵜⵔⴰ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴹⵏ ⴶⵏⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ⵜⵤⵔ ⵙⴾⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵗⵢⵙⴰ ⵜⵏⵔⵢ ⵢⴹⵗⵙ ⵜⵌⵔⵀ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ⵙ ⴶⴰ ⵗⵢⵙⴰ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵤⵍ ⴹⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵂⴹ ⵤⵎ ⴶⵤⵜⵓ ⴶⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ⵂⵤⵜⴹⵓ ⵀⵍⵙ ⵏⵏⵌⵔⵀ ⵏⵙ «ⴾⴹ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵎⵔⴰ ⵛⵂⵏ ⵙⴹ ⵆⵍⵏⵜ ⵎⵏ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⴶⴹⵎ ⵓⵔⴶⵗ ⵎⵏ⵿ⵙⵓⵏ ⵗⵙ ⵙ ⵜⴹⵔ ⴾⵍⵔ ⵙⴹⵔ⵿ⵜⵓ ⴹ ⵍⴾⵎ ⵢⵓⵍ ⴾⵜⵏⵜ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ⴾⴰ ⴹⵔⵙ ⵀⵍⵙ ⵗⵔⵎ ⵓⴰ ⵤⴹⴶⵏ ⵏⵢⵔⵙⵍⵎ ⵙⵀⴹⴹⵜⵓ ⴼⵍ ⴼⵍⴰ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ⵏⵙ «ⴾⴹ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵜⵔⴶ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⴹ ⵎⵔ ⵎⵛⵏⴰ ⵏ⵿ⴶⵍⵙⵏ ⴹⵗ ⵜⵍⵗⵏⴾ ⴾⵀⵍⵏ⵿ⴾⵢ ⴹⵗ ⴼⵙⵏⵙⵏ ⴼⵍ ⴹⴾⵓⵔ⵿ⵜⵏ⵿ⴾⴼ ⵜⵂⵏ⵿ⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵤⴰ ⵍⴾⵜⵀⵏ ⴹⵢ ⵏⵏ \"ⴹ ⵓⵔ ⵜⵜⵌⵔⵀⴰ ⵎⵍⵏⴾ ⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ⴹⴼⵔ ⵓⵏ ⴾⴰ ⴹⵔⵙ ⵀⵍⵙ ⴼⵍⴰ ⵏⴹⵗⵗ ⴾⵏⵏ ⵜⵤⴶⵔⵜ ⵙⵙⵓⴹⵜⵓ ⴹⵗ ⵜⵗⵎⵔⵏ ⴾⵍ ⵏⴹⵏⵜ ⴹⵜⵂⵙⵢⵏⵙⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ⵏⵙ «ⵓⴰ ⵜⴶ ⴹⵏ ⴾⵍ ⴾⴼⵗⴾⵓ ⵙ ⴹⵜⵙⵌⴹⴰ ⵜⵗⵀⴹⵗⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ⵏⵙ ⵗⵢⵙⴰ «ⴶⴶⵢ ⵛⵢⵜⵏ⵰ ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⵎⵍⵏⴾ ⵎⵛⵏⴰ ⵙ ⵤⴰ ⵜⵙⵌⴹⴰ ⵏ⵿ⵜⴰ ⵗⵙ ⵤⴰ ⵜⵗⵀⴹⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ⵎⵔⵏ ⵢⵢ ⵀⵍⵙ⵰ ⵂⵏⵏⵏ ⵏ⵿ⴶⵍⵙⵏ ⴾⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵙⵏⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵜⵔⵎⵙ ⵏⵢⵈⵢⴰ ⵆⵍ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ⵎⵛⵏ ⵓⵔ ⵆⵎ ⴹⵗ ⵗⵔⵎ ⵏⵤⵔⵜ⵰ ⴾⵍⵔ ⴶⵍⴰ ⵗⵙⵔ ⴹⵗ ⵜⵗⵔⵎ⵿ⵜ ⵜⴶⵜ ⴾⴼⵔⵏⵂⵎ ⵜⵓⵔⵜ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⴹⵗ ⵎⴹⵍ ⵏ⵿ⵤⵀⵍⵏ ⴹ ⵓⵏ ⵏⴼ⵿ⵜⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ⵎⴾⵏ ⴹⵗ ⵙ ⵏ⵿ⴹⴰ ⵓⵍ ⵓⴰ ⴹⴶⴰ ⵎⵍⵢ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙⵢⵙ ⴹⵗ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ⴾⵍ ⵏ⵿ⵤⵀⵍⵏ ⴹ ⵓⵏ ⵏⴼ⵿ⵜⵍⵢ ⵂⵏⵏ ⵙⵍⵎ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⴼⵍ ⵜⴶⴹⵎⵢⵜ ⵜⵏ ⵜⵔⵎ ⵏⵢⵔⴹⵏ ⵍⵎⵗⵏⴰ ⴶⵍⵍⵢⴰ ⵏ⵿ⵜⴰ ⴹⵗ ⵗⵙⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ⵜⵎⵜⵢ ⵜⴰ ⵜⵂⵜ ⵛⵢⵢ ⵜⵏⵢ ⵏⵔ ⵤⵓⵔⵏ ⵙ ⵎⵍⵓⵍⵓ ⵢⵜⴹⵏ ⴹⵗ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵓⴰ ⵜⵍⵙⴰ ⵜⵍⵢ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵀⵍⵤⵍⵤ ⴼⵍⵙⵏ ⵏⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ⵤⵎⵏⵏ ⴹⴰ ⴹⵗ ⴶⵤ ⵗⵢⵙⴰ ⵛⵏ ⴶⵢ ⵏ⵿ⵜⵍⵈⵜⵀⵜ ⴶⵏⵓ «ⵜⵀⵜ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ⵤⵍ ⵢⵏ ⵌⵓⵏ⵿ⴾⵜ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⵙ ⵏⵢ ⵛⵏ ⵎⴹⵔⵢⵏ ⵙⵢⵏ ⵙⵎⵏⵜ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵀⵜⵔⵙ ⴹⵎⴹⵔⵢⵏⵜ ⵏ⵿ⴹⵔⵓⵙ⵰ ⵎⴹⵏ ⵓⵏ ⵏⵀⵤⵏ ⵏ⵿ⴾⴼⵜⵏ ⵎⵙⵏ⵰ ⵙ ⵜⵏⵏⵢ ⴼⵜⵓⵏ ⴹⵗ ⴶⵔⵓ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵓⵏ ⵀⵤ ⵏ⵿ⴾⴼⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵍⴾⵎⵜⵢ ⴾⵓⵏⴶⴰ ⵎⴹⵏ ⵙⵔⵢ ⴹⵤⵜⵓⵢⵏⵏ ⵢⵜⴹⵏ ⵢⵜⵏⵙⴼⵙⴰ ⴹⵗ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ⵢⵏ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵍⴾⵎⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ⵙ ⴶⴰ ⵗⵢⵙⴰ ⵔⵜ ⵏ⵿ⵜⴾⵍⵢ ⴹⴼⵔ ⵓⵏ ⵏⵢ ⵛⵏ ⵎⴹⵔⵢⵏ ⵓⵢⴹ ⵎⵙⵏⵏ ⵢⵆⵀ ⴹⵎⴹⵔⵢⵏⵜ ⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵏⵙ ⵏ⵿ⵤⵀⴹⵢ⵰ ⵙ ⵜⵏⵏⵢ ⵏⵎⵂⵏ ⵗⵍⵍ ⵏⵎⵏ ⴹⵀⵏⵙⵏ ⵤⵀⴹⵢ ⴾⵏⵏ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵓⵏ ⵙ ⵜⵀⵤⵏ ⴾⴼⵜⵏ⵰ ⵗⵔⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹ ⵢⵏ ⵗⵍⵍⵏⵙⵏ ⴼⵍⵏ ⵀⵏⵙⵏ ⵍⴾⵎⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ⵙⵓⵍ ⵗⵢⵙⴰ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴾⵜⵏⵜ ⵙⵙⵗⵔⵓ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ⵎⵍ ⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵤⵤⵢ ⵢⵜⴹⵏ ⴹⵗ ⴾⵍⴾ ⵏ⵿ⵜⵓⵔⵏⴰ ⴹⴾⵍⴾ ⵏⵍⵗⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵓⵙⵍⴰ ⵗⵢⵙⴰ ⴹⵗ ⵎⴹⵍ ⵏ⵿ⵙⵔⵢⴰ ⴾⵍ⵰ ⴹⵙⴹⵜⵎⵓⵢⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵔⵏⵏ ⴹⵓⵏ ⵜⵍⵏⵏ ⴹⵍⵗⵀⵏ ⵆⵍⵏ ⴹⵓⵏ ⵙⵔⵏⵏ ⴾⵍⵙⴼ ⴹⵓⵏ ⵍⵏⵏ ⴾⵔⴾⵜⵏ ⴹⵏⵀⴹⵏ ⵤⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ⵍⴾⵎⵏⵜⵙ ⵜⵎⵜⵓⵏ ⴶⵜⵏⵏ ⴹⴼⵍⵏⵏ ⴶⵍⵍⵢⴰ ⴹⴾⵍ ⵓⵙ ⵜⵓⵏⵓ «ⵓⵏⵎⵔⵓⵗⵔⵎⵏ» ⴹⵢⵔⵙⵍⵎ ⴹⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴹⵎⴹⵍ ⵓⴰ ⵂⵏ ⴹⵏⴶ ⵏⵢⵔⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵛⵎⵜⵓⵏ ⵛⵏ ⵜⴹⵙⵏⵏ ⴹⵏ ⵓⵔ ⴹⵗⵗ⵰ ⵆⵎ ⴹⵏ ⴹⴰ ⵂⵤⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ⵙⵏ⵿ⵜⴰ ⵙⵙⵗⵔⵢ ⵏⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ⵰ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«ⵀⵍⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⵆⵓⵏⵏ ⴹⵗ ⵎⵏⵙⵏ ⵆⵀⵍⵏ ⵙ ⴹⵔⵔⵏ ⵙ ⵎⵛⵏⴰ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵛⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ⵀⵍⵍⵏ ⵓⵏ ⵂⵍⵏⵏ ⴼⵍⵙ ⵜⵏⵙⴹⵓⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ⵀⵍⵍⵏ ⵓⵏ ⵙⵔⵙⵏⵏ ⵎⵏⵙⵏ ⴼⵍⵙ ⴹ ⴶⵔⵓⵏ ⴾⵍ ⵓⴰ ⴹⵙⵏⵙⵏ⵿ⵙⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ⵀⵍⵍⵏ ⵓⵏ ⴾⵏⵏⵏ ⴹⵔⵏ ⵏⵓⴰ ⵗⴹⵏ ⴼⵍⵙ ⴹ ⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ⵀⵍⵍⵏ ⵓⵏ ⵂⵏⵜⵜⵏⵏ ⵢ ⵏⵔⴶⵏⵙⵏ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⵙⵏⵂⵏⵜⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ⵀⵍⵍⵏ ⵓⵏ ⵙ ⵤⴹⴶⵏ ⵓⵍⵏⵙⵏ ⴼⵍⵙ ⴹ ⵏⵢⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ⵀⵍⵍⵏ ⵓⵏ ⵜⴶⵏⵏ ⵍⵈⵔ ⴼⵍⵙ ⴹⵙⵏⴶⵓ ⵎⵛⵏⴰ ⵙⵎ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ⵀⵍⵍⵏ ⵓⵏ ⵜⵓⴹⴶⵤⵏⵏ ⴼⵍ ⴶⵢ ⵏⵓⴰ ⵗⴹⵏ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵛⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ⵜⵀⵍⵍⵎ ⴾⵓⵏⵢ ⵔⵀⴹⵏ ⵢⵜⴹⵏ ⴹⴶⵤⵏ⵿ⴾⵓⵏ ⵓⵔ ⵜⵍⴰ ⵤⵏⴼ ⵏⵤⴶⵏ ⴾⵓⵏⵓⵔⵙⵓⵔⵏ ⴼⵍ ⴹⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ⵓⵍⴰ ⴹⵓⵜⵜ ⵜⴼⵍⵓⵙⵎ ⴼⵍⵙ ⵜⵍⵎ ⵔⵤⵏ ⴶⵜⵏⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ⵏⵀⵜⵏ ⵓⵏ ⴹⵜⵓⵏ ⴹⴰ ⵎⴾ ⵓⴹⵢ ⴹⵗ ⵙ ⵜⵓⴹⴶⵤⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵜⵙⵎ⵿ⵜ ⵜⵎⵙⵎ ⵢⴹⵏⵜ⵰ ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵜⵙⵎ⵿ⵜ ⵜⴰ ⵀⵙ ⵜⵍⴰ ⵜⵎ⵿ⵀⵢ ⵎⵏⵢ ⵎⴾ ⵓⵙ ⵜⵜⴹⵤⵜⵜⵓⵙⵗⵍ ⵜⵎ⵿ⵀⵢⵏⵜ⵰ ⵜⵙⵎ⵿ⵜ ⵜⴰ ⵀⵙ ⵜⵏ⵿ⴼⴰ ⵓⵍⴰ ⵓⵔ ⵜⵂⵔ ⵔ ⴹⵏ⵿ⵜⵜⵓⴶⵔ ⵙⴹⵢ ⵜⵜⴹⵢⵤⵏ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ⵏⵔ ⵏⴹⵏⵜ ⵜⵎⵙⵎ⵰ ⵗⵔⵎ ⴾⵔⵙⵏ ⴼⵍ ⴼⵍⴰ ⵏⴹⵗⵗ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵜⵓⵔⵤⵏⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ⵎⴾⵏ ⴹⵗ ⵜⴶⴰ ⴼⵜⵍⴰ ⵙ ⵜⵔⵗⴰ ⵓⵔ ⵤⴰ ⵜⵜⵓⴶⵓ ⴹⵓ ⵗⵤⵓ⵰ ⴾⵍⵔ ⵜⵓⴶⴰ ⵤⴰ ⵜⴶⵓ ⴹⵗ ⴹⴶ ⴾⵏⵏ ⵂⴾⵓ ⴼⵍ ⴹ ⵜⵙⵎⵍⵓⵍⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵎⵍⵓⵍⵓⵜ ⵏⵔⵏⵓⵏ ⴹⵜ ⵢⵜⴹⵏ ⴾⵍ ⴼⵍ ⴹ ⵏⵢⵏ ⵔⵜⵏ ⵍⵗⵏⵏ ⵓⵏ ⵜⵜⴶⵎ ⵓⵢⴹⵓ ⵙⵔⵙⵏ ⵓⵏ ⴹ ⵎⵍⵏ ⵜⵏⵢⴰ ⵏⵀⵏⵓⵏ ⴹⵢ ⵂⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹ ⵓⵔ ⵜⵗⵍⵎ ⵙⴰ ⴹⴶ ⵢⴹⵏⴾⵙⵗ ⵓⴰ ⴾⵜⵀⵏ ⴹⵗ ⵜⵓⵔⵜ ⵎⴹⵗ ⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ⵰ ⵓⵔⴶⵗ ⴹⵢ ⴹⴾ ⴾⵍⵔ ⵙⴰ ⴹⴶⵗ ⵢⵜⵏⵙⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴾⵜ ⵍⵏ⵿ⵜⵓ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵜⵓⵔⵜ ⵓⵔ ⵜⵏ⵿ⵤⵜⴶⵎⴹ ⵓⵍⴰ ⵜⵜⵀⵆⵜ ⵎⵔⵏ ⵓⵍⴰ ⵗⵙ ⵙⴾⵍ ⵓⵔ ⵜⵏ⵿ⵤⴶⵎⴹ ⴾⵜ ⵓⵔ ⵏ⵿ⴹⴰ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗⵙ ⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵎⵤⵔⵢⵏ ⵓⵍⴰ ⵗⵙ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ ⵜⵎⴹⵔⵢⵜ ⵎⵔ ⵢⵜⴹⵏ ⵙⴹ ⴶⵏ ⵓⵏ ⴹⴰ ⵓⴹⵏ ⵓⴹⵢ ⵏ⵿ⵜⴰ ⵤⴶⵔⵏ ⵔⵙ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵀⵔⴹⴶ ⵓⴹⵏ ⵢⵍⵓⵌⵀⵏ ⵓⵏ ⵙⵙⵗⵔⵏ ⵢⵢⵜⴹⵏ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⴹⴾⵍ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ⵓⵍⴰ ⵎⵍⵗⵓⵏ ⵙ ⵙ ⵓⵔ ⵜⴶⵎ ⵢ ⵎⵛⵏⴰ ⵀⵔⴹⴶ ⴶⵔⵏ ⵓⴰ ⴹⵙⴶⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⴹⵢ ⵓⵔ ⵤⴰ ⵜⴶⵤⵎ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ⵜⵙⵍⵎ ⵙ ⵜⵓⵏⴰ ⵢⵍⵌⴹⵏⵏⴰ ⴹⵗ ⵜⵓⵔⵜ \"ⴹ ⵓⵔ ⵜⴶⵗ ⵎⵏ⵰\" ⵙ ⴶⴰ ⵓⴹⵏ ⵎⵏ ⴹ ⵜⵀⵤ ⵛⵔⵗⴰ ⵓⴹⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵤ ⵍⵂⵎ ⵏⵢⵏ ⵓⴹⵢ ⴹ ⵜⵀⵤ ⵛⵔⵗⴰ ⵓⴹⵀ⵰ ⵓⴹⵏ ⴹⵗ ⴾⵍ ⵓⴰ ⵏⵏ ⵢⵢⵏ \"ⵏⴼⵏⵤ⵰\" ⵓⴹⵢ ⴹ ⵜⵓⵙⵀⴹⴹ ⴹⵜ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵙ ⵜⵓⵏⵓ ⵙⵏⵂⴹⵔⵏ ⴼⵍ ⴹ ⵜⵓⵛⵔⵗ ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⵏⵏ ⵢⵢⵏ \"ⴾⵢ ⵎⵔⵙ⵰\" ⵓⴹⵢ ⵛⵔⵗⵏⵜ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ⴹⵗ ⴹⵢ ⵙ ⴹⵜⴾⵜⵗ ⵙ ⵛⴾⵢ ⵓⴹⵏ ⴹⵗ ⵎⵤⵢ ⵓⴰ ⴹⵗ ⴹⵜⵓⵢⴰ ⵜⴾⵜⵢⵏⴾ ⵙⴹⴶ ⵓⵏ ⵙⵆⴹ ⵏ⵿ⵜⴾⵜⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ⵜⵢⴰ ⵜⴾⵜⵢⵏⴾ ⴹⵢ ⴹⴰ ⵜⴶⵍⴰ ⵂⵔ ⵜⵏⵎⵙⵔⴼⴰ ⴹⵓⴹⵏ ⵓⴹⵢ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵜⵆⵍⴰ ⵜⴶⴰ ⵜⴾⵜⵢⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ⵙ ⴾⵢⵙⵓⵔ ⵓⴹⵏ ⵍⵂⵏ ⵜⴾⵏⴰ ⴹⵔⵙ ⵜⵔⵎⴹ ⴾⵜ ⴹⵢ ⴹ ⵜⵂⵎ ⵜⵔⵢⵜ⵰ ⵙ ⵓⵔ ⴶⴰ ⴹⵢ ⵓⴹⵏ ⵓⴹⵢ ⴹ ⵛⵛⵓⴹ ⵀⵜⵓ ⵜⴹⵢ ⵍⵆⵍⵢ⵰ ⵜⵤⵔ ⵏ⵿ⴾⵔ ⵍⵆⵍⵢ ⴶⴾ ⴹⵗ ⴼⵙⵏ ⵏ⵿ⵙⵌⵢ ⴾⵢⵤⴶⵏ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ⵙ ⴶⴰ ⴹⵢ ⵎⵔⵏ ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⵔ ⴹⵤⵜⴶⵎⴹⵗ ⴾⵜ ⵓⵔ ⵜⵗⵔⴹⴰ ⵔⵤⵎ ⵏⵔⵜ ⴾⵍ ⵓⵙ ⴾⵢⵓⵔⵏ ⵔⵤⵎⵜⵏⵜ⵰ ⵓⵍⴰ ⵜⵎⴰ ⵢⴹⴰ ⵓⵔ ⴹⵏ⵿ⵤⵜⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ⵜⵙⵍⵎ ⵙ ⵜⵓⵏⴰ \"ⴹ ⵓⵔ ⵜⴶⵗ ⵤⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵏ ⴹⵗ ⵜⵏ⵿ⵜⵜ ⵙⵓⴹ ⴹⵗ ⵙⴹⵔⵏ ⵏⵎⵏ⵿ⵙⵏⵜ ⵓⴹⵢ ⴶⴰ ⴹⵔⵙ ⵤⵏⴰ ⴹⵗ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ⴾⴹ ⵛⵜⵏⴾ ⵜⵏ ⵗⵍ ⵜⵀⴾⵜ ⴹⴾⵜⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵏⵀⴾⴹ ⵜⴾⴾⵔⵆⵜⴹⵓ ⵜⴶⵔⵆⵜⵏ ⴹ ⴼⴾ ⵜⴶⵎⴹⴾⵢ ⵜⵙⵍⵜⵏⴾ ⵢⴹⴰ ⵢⴹ ⵜⵜⵓⴶⵔ ⵜⵗⵙⵏⴾ ⴾⵍ ⴹⵗ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ⵎⵔⵏ ⴾⴹ ⴼⵙⵏⴾ ⵓⵏ ⵗⵍ ⵀⴾⵏ ⴹⴾⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵀⴾⴹ ⵜⴼⵔⵙⵆⵏ ⵜⴶⵔⵆⵏ ⴹ ⴼⴾ ⵜⴶⵎⴹⴾⵢ ⵜⵙⵍⵜⵏⴾ ⵢⴹⴰ ⵢⴹ ⵜⴶⵤ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵌⵂⵏⵎⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵜⵓⵏⴰ ⴹⵗ \"ⵢ ⵤⵎⵤⵢⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⴾⴼⵜⵜ ⵛⵔⵓⵜ ⵏⵎⵤⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ⵏⴾ ⵤⴰ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵤⵎⵤⵢⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⴼⵍ ⵓⵔ ⵏⵎⵙ ⴶⵢ ⵏⵎⴹⵏ ⵓⴹⵢ ⵙⵙⴶⵢ ⵜⵜⴶⴰ ⵤⵏⴰ ⵎⵔⵏ ⵙ ⵤⵍⴼ ⵍⵙ ⵢⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵎⵤⵢⵜ ⴹⴰ ⵓⴹⵢ ⵤⵏⴰ ⴶⴰ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ⵜⵙⵍⵎ ⴹⵗ ⵙ ⵜⵓⵏⴰ ⵢⵍⵌⴹⵏⵏⴰ \"ⴹ ⵓⵔ ⵜⵂⴹⵎ ⴼⵍ ⵔⵜ ⵜⵆⵎⵎ ⵓⵔ ⵜⵜⵎⵤⵍⵎ⵰ ⴾⵍⵔ ⵙⵀⴹⴹⵜ ⵔⴾⵓⵍⵏ ⵓⵏ ⴼⵍ ⵜⵂⴹⵎ ⵙⵙⵎ ⵏⵎⵍⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⴹ ⵓⵔ ⵜⵂⴹⵎ ⴼⵍ ⵔⵜ ⵓⵍⵢⵏ ⴼⴹⴰ ⴶⵔ ⵤⴰ ⵙ ⵌⵏⵓⵏ ⴼⵍⵙ ⴹⴶ ⵏⵍⵈⴾⵎ ⵏⵎⵛⵏⴰ ⵎⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ⵓⵍⴰ ⴹⵗ ⵜⵂⴹⵎ ⵙⵎⴹⵍ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵍⵏ ⴹⵓ ⴹⵔⵏⵜ ⵓⵍⴰ ⴹⵗ ⵜⵂⴹⵎ ⵙ ⵢⵔⵙⵍⵎ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵜⵎⵙⵜ ⵗⵔⵎ ⵏⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵜⵎⵙⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ⴹ ⵓⵔ ⵜⵂⴹⵗ ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵗⴼⵏⴾ ⴼⵍⵙ ⵓⵔ ⵜⴼⵔⴶⵗ ⵙⵎⵍⵍ ⵏⵏ⵿ⵤⴹⵏⵜ ⵓⵍⵢⵏ ⴹⴰ ⵓⵍⴰ ⴹⵗ ⵙⴾⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ⴶⵏⵓⵜ ⵗⵙ \"ⵢⵓ\" ⵢⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⵎⴹⵗ \"ⴾⵍ\" ⵢⵓⴰ ⵎⵙⵏ ⵀⵂⵓ⵰ ⵀⵜⵓ ⴹⵜⵛⵜⵎ ⴼⵍ ⴹⵢ ⴾⵍ ⵛⵢⵜⵏ ⵙ ⴹⵜⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ⵜⵙⵍⵎ ⵙ ⵜⵓⵏⴰ \"ⵢ ⴹⴾⵙⵏ ⵛⵜ ⵏⵢⵏ ⴹⵜⵜⵓⴾⵙ ⵛⵜⵏⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⵢ ⴹⵔⵤⵏ ⵛⵏ ⵏⵢⵏ ⴹⵜⵓⵔⵤⵓ ⵛⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⴹ ⵓⵔ ⵜⵜⴶⵤⵎ ⵎⵏⵓⵏ ⴹⵗ ⵎⴾⵙⵏ⵰ ⴾⵍⵔ ⵙ ⴹⴾⵆⵙ ⴼⵍ ⵎⴹⴹⵏⴾ ⵓⵏ ⵗⵍ ⵜⴾⴼⵆⵓ ⵎⴹⴹⵏⴾ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ⵙ ⵔⴰ ⵓⴹⵏ ⴾⵢⵀⵤ ⵙⵛⵔⵗⴰ ⴼⵍ ⴹ ⴶⵔⵓ ⵍⵗⵛⵀⵏⴾ ⵜⴾⴼⵆⵓ ⵀⵔⵏⵤⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ⵙ ⴾⵢⵛⵂⵛⵍ ⵓⴹⵏ ⴶⵢ ⵏⵍⵍⵏⵜ ⵂⵔ ⴶⵎ ⵏ⵿ⵜⴾⵍ⵿ⵜ ⵜⵓⵢⵗⵙ⵿ⵜⵏ ⵂⵔ ⵛⵏ ⴶⵎ ⵏ⵿ⵜⴾⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ⵢ ⴾⵢⵏ⵿ⵙⵢⵏ ⵜⴾⴼⵆⵓ ⵢ ⴹⵗⴾ ⴶⵎⵢⵏ ⵎⵔⵓⵙ ⴹⵙ⵿ⵜⵓⵔ⵿ⵜⴶⴹⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ⵜⵙⵍⵎ ⵙ ⵜⵓⵏⴰ \"ⵔⵓ ⵏⵎⵔⵢⵏⴾ ⵜⴶⵤⵔⵗ ⵤⵏ⵿ⴶⵓⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⵔⵓⵜ ⵤⵏ⵿ⴶⵏⵓⵏ ⴹ ⵜⵜⴶⵎ ⵛⵓⵜⵔⵓⵏ ⵍⵗⵏⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⵙⵙⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ⴼⵍ ⴹ ⵜⵆⵍⵎ ⵙ ⵜⴹⵜ ⴹⴰ ⵀⵔⵔⵏ ⵏⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰ ⵏ⵿ⵜⴰ ⴹⵙⴶⵎⴹⵏ ⵜⴼⴾⵏⵜ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⵎⴾⵙⵏⵏ ⴹⵓⵏ ⵍⵗⵏⵏ ⵙⵓⵜ ⴾⵏⴾⵏⵜ ⴼⵍ ⵓⵏ ⵗⴹⵏⵏ ⴹⵓⵏ ⵏⵎⵤⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ⴾⴹ ⵓⵔ ⵜⵔⵎ ⵔ ⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⵔⵏⵏ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵤ ⵓⴰ ⵤⴰ ⵜⴶⵔⵓⵎ ⴹⵗ ⵓⵏ⵰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⵓⵏ ⵤⵔⵤⵎⵏⵏ ⵜⴾⵙⵏ ⵎⵙⵏⵏ ⵎⴾⵙⵏⵏ ⴹⴰ ⵓⵏ ⴹⵗ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ⵙ ⵎⵙ ⵙ ⵎⴹⵔⵢⵏⴾ ⵗⵙ ⵜⵔⵗ ⵜⵙⵙⵍⵎⵆⵏ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵜ ⵎⵜⵢⵏ ⵓⴰ ⵜⴶⵗ⵰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⴹⴰ ⴹⵢ ⴹⵗ ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⵆⵍⵜ ⵢⵜⴹⵏ ⴾⵎⵍⵏⵏ ⵛⵍⵜ ⵏⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵏ⵿ⴾⴹⵜ ⴹⴶⵢ ⵏⵍⵗⵀⴹⴰ ⵎⵙⵏ ⵙⴾⵏⵢ⵰ ⵙ ⵓⵔ ⴶⴰ ⴹⵢ ⵓⵔ ⵤⴰ ⵜⴶⵔⵓⵎ ⵔⵤⵏ ⵗⵔ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«ⵙ ⵜⵜⴶⴰ ⵜⴾⵜⵢ ⵢⵎⴹⵔⵔ ⴹ ⵓⵔ ⵆⵍ ⴹⵢ ⵔⵜ ⵜⵙⵏⴼⵍⵍⴰ ⵤⵏ ⵓⴰ ⵜⴶⵏ ⵍⵎⵏⴼⵆⵏ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵜⵔⵢⵏ ⴼⵍ ⵜⵔⴰ ⵏⴹ ⴶⵔⵓⵏ ⴹⴾⵍ ⵗⵔ ⵢⵜⴹⵏ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵍⵎⵏⴼⵆⵏ ⵓⵏ ⴹⵢ ⵔⵤⵏⵙⵏ ⴶⵔⵓⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ⴾⵢ ⵎⵔⵏ ⵙ ⵜⵜⴶⴰ ⵜⴾⵜⵢ ⴹ ⵓⵔ ⵙⵏ ⴼⵙⵏⴾ ⵓⵏ ⵤⵍⴶⵜ ⵓⴰ ⵜⴶⵓ ⵓⵏ ⵗⵍ ");
INSERT INTO ttqt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ⴼⵍ ⴹ ⵜⵆⵍ ⵜⴾⵜⵢⵏⴾ ⵙⵔ⵰ ⵀⵏⴾ ⵙⵏ⵿ⵜⴰ ⵂⵏⵢⵏ ⵙⵔⵏ ⴹⴾⵤⵔⵤⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ⵙ ⵜⵜⵜⵔⵎ ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵓⴰ ⵜⴶⵏ ⵍⵎⵏⴼⵆⵏ ⵔⵏⵏ ⴹ ⵜⵜⵔⵏ ⵀⴹⴹⵏ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵙⵎⵏⵢⵏ ⴶⵎⵢⵏ ⵙⵓⵏ ⵜⵏⵏⵢⵏ ⵢⵜⴹⵏ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵔⵤⵏⵙⵏ ⴶⵔⵓⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ⴾⵢ ⵎⵔⵏ ⵙ ⵜⵜⴶⴰ ⵛⵓⵜⵔⵓⵏ ⵜⴶⵤⵗ ⴹⵗ ⵂⵏⴾ ⴹⴶ ⵓⴰ ⴶⵔⵏ ⵏⵎⴶⴶ ⴹⵢⵜⴹⵏ ⵜⵈⴼⵍⵆⵏ ⴼⵍ ⵎⵏⴾ ⵜⵜⵔⴰ ⴹⵗ ⵙⵔ ⵙⵀⵏⴾ ⴹ ⵍⴰ ⴹⵢ⵰ ⵀⵏⴾ ⵙⵏ⵿ⵜⴰ ⵂⵏⵢⵏ ⵙⵔⵏ ⴾⵢⵤⴾⴼⵏ ⵔⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ⵙ ⵜⵜⵜⵔⵎ ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵓⵍ ⴶⵏ ⵜⴶⵏⵎ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵤⵏ ⵓⴰ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⵗⵍⵏⵏ ⵓⵔ ⴹⵙⵏ⵿ⵤⵙⵍⵓ ⵎⵛⵏⴰ ⵔ ⵙⴹ ⵜⴶⵏ ⵓⵍ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ⵜⵏⵓⵔ⵿ⵜⵜⵍⵍⵎ ⴼⵍⵙ ⵀⵏⵓⵏ ⵙⵏ ⵓⵙ ⵜⴹⵔⵔⵎ ⴹⴰ ⵂⵔⵓⴰ ⵓⵔ ⴹⵗⵙ ⵜⵜⴶⵎⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ⵜⵓⵜⵔⵢ ⴹⴰ ⵜⵙ ⵂⵔ ⵜⵜⵜⴶⵎ ⴾⵓⵏⵢ \"ⵀⵏⵏⴰ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵜⵓⵙⵗⵎⵔⵜ ⵙⵎⵏⴾ ⴹⵢ ⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ⵜⵙⵜⴹⵓ ⵜⵗⵎⵔⵏⴾ⵰ ⵜⵜⵓⵎⵤⵍⵜ ⵜⵔⵏⴾ ⴼⵍ ⵎⴹⵍ ⵙ ⵎⴾ ⵓⵙ ⵜⵜⵓⵎⵤⵍ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ⴾⴼⵏⵗ ⵙⴹⵔⵏⵏⴰ ⵓⵏ ⵤⵍⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ⵜⵙⵔⴼⵗⵏⴰ ⵜⴹⵍⵎ⵿ⵜ ⵜⴰ ⵏⴶⴰ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵙⵔⴼ ⵢ ⵓⵏ ⴹⵏⵗⴹⵍⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ⴹⵏⵓⵔ⵿ⵜⴶⴰ ⴹⵗ ⵍⵗⵔⵔ ⵏ⵿ⵌⵔⵀⵜⵏ ⴾⵍⵔ ⴶⵤⵏⴰ ⴹⵗ ⵀⵍⵙ ⴼⵍⵙ ⵜⵗⵎⵔ ⴹⵜⵔⵏⴰ ⴹⵜⵏⵢⴰ ⵛⵏⴾ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«ⵙ ⵜⵙⵔⴼⵎ ⵢⵢⵜⴹⵏ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⴹⵓⵏⴶⵏ ⴾⵓⵏⵢ ⴹⴰ ⴹⵓⵏⵙⵔⴼ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ⵎⵛⵏ ⵙ ⵓⵔ ⵜⵙⵔⴼⵎ ⵢⵢⵜⴹⵏ ⵓⴹⵢ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵓⵔ ⴹⵓⵏ⵿ⵤⵙⵔⴼ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ⵙ ⵜⵤⵎⵎ ⴹ ⵓⵔ ⵜⵙⵏⴼⵍⵍⵎ ⵜⴾⵏ⵿ⵤⵔ⵿ⵜ ⵤⵏ ⵓⴰ ⵜⴶⵏ ⵍⵎⵏⴼⵆⵏ ⵏ⵿ⵜⵏⵢ ⵙⵎⵜⵢⵏⵏ ⴹⵎⵓⵏⵙⵏ ⴼⵍ ⴹ ⵙⵙⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵙ ⵤⵎⵏ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵔⵤⵏⵙⵏ ⴶⵔⵓⵏ⵿ⵜⵏ ⵂⵔⵓⴰ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ⴾⵢ ⵎⵔⵏ ⵙ ⵜⵤⵎⵗ ⵜⵛⵔⴹⵗ ⴹⵎⵏⴾ ⵜⴶⴰ ⵍⵓⵔⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ⴼⵍ ⴹ ⵓⵔ ⵙⵏⵏ ⵢⵜⴹⵏ ⵙ ⵜⵤⵎⵗ⵰ ⵀⵏⴾ ⵗⵙ ⵤⵙⵏⵏ ⴹⵗ ⴹⵢ ⴼⵍⵙ ⵍⴰ ⴹⵢ ⴹⵗ ⵙⵔ ⵂⵏⵢ ⵓⴰ ⵜⴶⵏ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⴾⵤⵔⵤⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ⴹ ⵓⵔ ⵜⵛⴹⵓⵎ ⵜⴶⵔⴶⵙ⵿ⵜ ⴹⵗ ⴹⵏⵜ ⴹⵆⵜ ⵤⴰ ⵜⵂⵍⴾ ⵜⵎⴹⵢ ⴹⵜⵏⴾ ⵔⵤⵏ ⴹⵗ ⵀⵢⴹⴶⵏ ⵏⵏ ⵜⴾⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ⴾⵍⵔ ⵛⴹⵓⵜ ⵢ ⵎⵏⵓⵏ ⵜⴶⵔⴶⵙ⵿ⵜ ⴹⵗ ⵌⵏⵓⵏ ⴹⵆⵜ ⵓⵔ ⵤⴰ ⵜⵂⵍⴾ ⵜⵎⴹⵢ ⵤⴰ ⵓⵍⴰ ⵜⵏⴾ ⵓⵍⴰ ⴹⵗ ⵙⵏ⵿ⵜⵜⵏ ⵀⵢⴹⴶⵏ ⵓⵏ ⵔⵤⵏⵏ ⵏⵏ ⵜⴾⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ⴼⵍⵙ ⴹⴶ ⵓⴰ ⵜⵂⴰ ⵜⴶⵔⴶⵙ⵿ⵜⵏⴾ ⵏ⵿ⵜⴰ ⵤⴶⵤ ⵓⵍⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ⵛⵜⵓⵏ ⵛⵍⵜ ⵏ⵿ⴼⵜⵍⴰ ⵎⵙⵏⵜ ⵢ ⵜⵗⵙⵏⴾ⵰ ⵙ ⵎⵙ ⵙ ⵛⵜⵓⵏⴾ ⵂⵏⵢⵏⵜ ⵙⵍⵗ ⵓⴹⵢ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵜⵂⴰ ⵏⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵛⵜⵓⵏⴾ ⵓⵔ ⵂⵏⵢⵏⵜ ⵙⵍⵗ ⵓⴹⵢ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵜⵂⴰ ⵛⵢⵢ⵰ ⴹⵗ ⴹⵢ ⵙ ⵎⵙ ⵙ ⵓⵍⴰ ⵏⵔ ⵓⴰ ⵂⵏ ⵜⵗⵙⵏⴾ ⴹⴰ ⵎⵙ ⵛⵢⵢ ⵓⴹⵢ ⴹ ⵜⴶⵤⴰ ⵛⵢⵢ ⵓⵔ ⵏⵎⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⵛⵗⵍ ⵢⵛⵏ ⵎⵤⵔⵏ⵰ ⵓⴰ ⵗⵙ ⴾⵢⴹ ⵢⵏ ⴹⵗⵙⵏ ⵔⵓ ⵓⴰ ⵂⴹⵏ ⵎⴹⵗ ⵀⵔⴹⴶ ⵢⵢⵏ ⵍⴾⵓ ⵓⴰ ⵂⴹⵏ⵰ ⵓⵔ ⵜⴼⵔⴶⵗ ⴹ ⵜⵗⵀⴹⴰ ⵎⵛⵏⴰ ⵜⴶⵍⴰ ⴹⵗ ⵜⵤⵍⴰ ⴹⴼⵔ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«ⴹⵗ ⴹⵢ ⵏⵗⵓⵏ ⴾⵓⵏ ⵓⵔ ⵜⵛⵓⵛ ⵜⵎⴹⵔ⵿ⵜ ⴶⵔ ⵓⴰ ⵤⴰ ⵜⵜⵛⵎ ⵓⵍⴰ ⵓⴰ ⵤⴰ ⵜⵛⵓⵎ ⵓⵍⴰ ⵓⴰ ⵤⴰ ⵜⵍⵙⵎ⵰ ⵎⵏⵓⵏ ⵓⵔⴶⵗ ⴶⵔⵏ ⵎⵏ⵿ⵙⵓⵏ ⵜⵗⵙⵏⵓⵏ ⴹⵗ ⵜⴶⵔ ⵙⵍⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ⵙⵓⴹⵜ ⴹⵗ ⴶⴹⴹ ⵜⴶⴹⵏⵏ ⴹⵗ ⵍⵂⵓⴰ ⵓⵔⵎⴹ ⵏⵀⵍⵏ ⵤⴰ ⵓⵔ ⵜⵍⵢⵏ ⵓⵔ ⵛⴹⵓⵏ ⵓⵍⴰ ⴹⵗ ⵜⴹⵏ⵿ⴶⵓⵏ ⵎⵛⵏ ⵙⴹⵔ⵿ⵜⵏ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰ ⴾⵓⵏⵢ ⵓⵔⴶⵗ ⵜⴶⵔⵎ⵿ⵜⵏ ⵍⵎⵆⵎ ⵙⵏ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴼⵔⴶⵏ ⵙⵛⵓⵛⵏⵜ ⵛⵜⵢ ⵏ⵿ⵜⵗⵔⵙ⵿ⵜⵏⵜ ⵙ ⵓⵍⴰ ⵍⴼ ⵏⵛⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ⵎⴼⵍ ⵙ ⴾⵓⵏ⵿ⵜⵛⵓⵛ ⵜⵍⵗⴰ ⵏ⵿ⵙⵍⵙⴰ⵰ ⵏ⵿ⵤⵔⵜⵏ ⴹⵗ ⵎⴾ ⵓⵙ ⴹⴹⴶⵍⵏⵜ ⵜⵌⴶⵓⵏ ⴹⵗ ⵙⴼ⵰ ⵓⵔⵎⴹ ⵛⵆⵍⵏⵜ ⵓⵍⴰ ⵤⵜⵏⵜ ⵙⵍⵙⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ⵎⵛⵏ ⵏⵗⵓⵏ ⵓⵍⴰ ⵎⵏⴾⵍ ⵙⵍⵎⵏ ⵂⵔⴾⴹ ⵜⴶⵔⴶⵙ⵿ⵜⵏⵜ ⴾⵍ ⵓⵔ ⴾⵍⴰ ⴹ ⵓⴹ ⵓⵍⴰ ⵢⴹⴰ ⴹⵗⵙⵏⵜ ⴹⵗ ⵜⵂⵙⵢ ⵏ⵿ⵜⵍⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ⴹⴹ ⵙⵍⵙⵓ ⵎⵛⵏⴰ ⵢⵍ ⵙ ⵜⵎⵓⵜ ⵜⴹⵢ ⵙⵤⵍⴹⴰ ⵀⴹⴹ ⵜⴼⵜ ⴹ ⵜⵓⵙⵔⵗⵓ ⴹⵗ ⵜⵌⵏ⵿ⴶⵔⵔ⵿ⵜ⵰ ⵎⵏⵎⴾ ⵙ ⴾⵓⵏⵓⵔⵤⵙⵍⵙⵓ ⴾⵍ ⵤⴶⵤⵏ ⵏ⵿ⴹⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵛⵓⵛⵎ ⵜⴶⵏⵎ \"ⵎⴰ ⵤⴰ ⵏⵜⵛⵓ⵰\" ⵎⴹⵗ \"ⵎⴰ ⵤⴰ ⵏⵛⵓ⵰\" ⵎⴹⵗ \"ⵎⴰ ⵤⴰ ⵏⵍⵙⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⵤⵍⵏⵏ ⴹⵗ ⴶⵎⵢⵏⵙⵏ ⵎⵔⵏ ⴾⵓⵏⵢ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵙⵏ ⵙ ⵜⴹⵔⵔⵎ ⵙⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ⴶⵎⵢⵜ ⵜⵤⵔ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⵆⴹ ⴹⵜⵙ ⵙ ⴶⴰ ⴹⵢ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⴾⵓⵏ⵿ⵜⵓⴾⴼⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ⴹⵗ ⴹⵢ ⴾⵢⵓⵔⵛⵓⵛ ⵔⵜ ⵓⴰ ⴹⵤⵢⵏ ⵜⴼⵜ ⴼⵍⵙ ⵜⴼⵜ ⴹ ⵜⵛⵓⵛ ⴹⵜⵎⵗⵜⵔⵏⵜ⵰ ⵤⵍ ⴾⵍ ⵍⴰ ⵛⵎⵗⵜⵔⵏⵜ ⴹⵙⴶⴹⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍⵙⵏ ⵏⴰ «ⴹ ⵓⵔ ⵜⵏⵎ ⵔⴾ ⵔⵜ ⵙⵓⴹⵏ ⴼⵍ ⵙⵔⵓⵏ ⵓⵔ ⵜⵓⵏⵓ ⴾⵓⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ⴼⵍⵙ ⵎⴾ ⵓⵙ ⵜⵈⴾⵎⵎ ⵏ⵿ⵜⴰ ⵙ ⵤⴰ ⵜⵜⵓⵈⴾⵎⵎ ⴾⵓⵏⵢ ⴹⴰ ⵎⵔⵏ ⵜⵙⴾⵜ ⵜⵙ ⵜⴾⵜⵎ ⵢⵢⵜⴹⵏ ⵏ⵿ⵜⴰ ⵙ ⴹⵓⵏ⵿ⵤⴾⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ⵎⴼⵍ ⵜⵂⵏⵢⴰ ⵜⵤⵓⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵏⵎⴹⵔⵢⵏⴾ ⴾⵢ ⵎⵔⵏ ⵓⵔ ⴹⵏ⵿ⵜⴶⵔⵗ ⵛⵍⵍ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵜⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵏⴰ ⵢⵎⴹⵔⵢⵏⴾ \"ⵢⵢ ⴹⴾⴾⵙⴰ ⵜⵤⵓⵜ ⵜⴰ ⴹⵗ ⵛⵜⵏⴾ\" ⴾⵢ ⵎⵔⵏ ⵛⵍⵍ⵿ⵜ ⵜⵂⵜ ⵛⵜ ⵜⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ⵍⵎⵏⴼⵆ ⴾⵙ ⵜⵤⵔ ⵛⵍⵍ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜⵏⴾ ⴹⵢ ⴹ ⵤⴰ ⵜⵏⴼⵍⵢⴰ ⴹⵗ ⵜⵤⵓⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵏⵎⴹⵔⵢⵏⴾ ⵜⴾⵙⵗⵙ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ⴹⵏⵓⵔ⵿ⵜⴶⵔⵗ ⵔⵜ ⵤⴹⴶⵏ ⵎⴹⵗ ⵔⵜ ⵍⵏ ⵍⵎⵆⵎ ⵢ ⵎⴾⵙⵏⵏ ⴼⵍⵙ ⵓⵔ ⵤⵍⵢⵏ ⴹⵏ ⴾⵓⵏ⵿ⴹⵎⵍⵍⵢⵏⵏ ⵢⴾⵓⵏⴹⴹⵏ ⵎⴹⵗ ⵍⴹⵢⵏ ⵂⵍⴾⵏⵏ ⵔⵜⵏ ⵓⵏ ⵍⵏⵏ ⵍⵎⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ⵏ⵿ⵙⵢⵜ ⵎⵛⵏⴰ ⴾⵓⵏⴾⴼⵓ⵰ ⴶⵎⵢⵜ ⴹ ⵜⴶⵔⵓⵎ⵰ ⵗⵔⵓⵜⵓ ⴹⵓⵏⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ⴼⵍⵙ ⵢ ⵏ⵿ⵙⵢⵏ ⴹ ⵜⵓⴾⴼⵓ ⵢ ⴶⵎⵢⵏ ⴹ ⴶⵔⵓ ⵢ ⵗⵔⵏ ⴹⵗ ⵎⵛⵏⴰ ⴹⵙⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴹⵗ ⵤⴶⵎⵢ ⵀⵔⵔⵏⵜ ⵜⴶⵍⴰ ⴾⴼⵢ ⵜⵂⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ⵓⵍⴰ ⴶⵎⵢ ⴹⵗⵙ ⵙⵏ ⴾⴼⵢ ⵜⵛⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ⴹⴹ ⵤⵎⵙ ⵓⵍⴰ ⴾⵓⵏⵢ ⵏ ⵏⵍⵀⵙ ⴹⴰ ⵜⵙⵏⵎ ⵜⵂⴾⵢ ⵏⵓⴰ ⵍⵗⵏ ⵢ ⵀⵔⵔⵏⵓⵏ ⵎⵏⵎⴾ ⵙ ⴾⵓⵏⵓⵔⵤⴾⴼⵓ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵓⴰ ⵜⵜⵏ⵿ⵙⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ⵜⴶⵓⵜ ⵢⵢⵜⴹⵏ ⵔⵜ ⴾⵍ ⵓⵙ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⴶⵏ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵔⵜ ⵓⴰ ⵂⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ⴶⵤⵜ ⵙⵎⵢ ⵓⴰ ⴾⵔⵤⵏ ⵙⵏ⵿ⵜⴰ ⵜⵓⵢⵏ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⴾⵜ ⵍⵓⵢ ⴶⵢ ⵎⵢ ⵓⴰ ⵜⵓⵢⵏ ⵙⵂⵍⴾ ⴾⵜ ⵙⵏⴼⵍⵢ ⵜⴶⵢ ⵜⵔⵢⵜ ⵜⴰ ⵜⵜⵓⵢⵜ ⵙⵂⵍⴾ ⵎⵔⵏ ⴶⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵏ⵿ⵜⴰ ⵙ ⵜⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ⵎⵛⵏ ⴾⵜ ⵜⴾⵔⵤⵜ ⴶⵜ ⵎⵢ ⵓⴰ ⵜⵓⵢⵏ ⵙ ⵜⵎⴹⵔ⵿ⵜ ⴾⵜ ⴹⵗ ⵙⵎⵗⵜⵔ ⵜⴶⵢ ⵜⵔⵢⵜ ⵜⴰ ⵜⵜⵓⵢⵜ ⵙ ⵜⵎⴹⵔ⵿ⵜ ⵎⵔⵏ ⵓⵔ ⴶⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏ⵿ⴶⵔⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ⵏ⵿ⴾⴹⵜ ⵢⵏⵀⵜⵏ ⵓⵏ ⵀⵂⵓ⵰ ⵙ ⴾⵓⵏ⵿ⴹⵜⵙⵏ ⵎⵙⵏ ⵤⵏ ⵢⴼⴹ ⵎⵛⵏ ⵙ ⵜⴹⵜ ⵔⴹⵍⵏ ⵎⵙⵏ ⴾⵏⵏⵏ ⵛⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ⵔⵜ ⵓⴰ ⴹⵙⵈⵙⵍⵏ ⵙ ⵜⵏ⵿ⵤⵜⵤⴹⵢⵎ⵰ ⵓⴾ ⵍⵗⵏⵀ ⵜⵓⵏ⵿ⴾⴹⵓ ⴹⵗ ⵜⵤⵢⵜ⵰ ⵓⵍⴰ ⵜⵓⵏ⵿ⴾⴹⵓ ⴼⴶ ⴹⵗ ⵜⴶⵔⴼ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ⵎⴾⵏ ⴹⵗ ⵙ ⵛⴾ ⵙⵈⵏ ⴹⵜⵔⵓⵏ ⵔⵜⵏ ⵍⵗⵏⵏ ⵎⵔⵏ ⵛⴾ ⵓⵔ ⵏⵙⵈⴰ ⵜⵔⵓⴹⵓ ⵓⵏ ⵓⵔ ⵏⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ⵛⴾ ⵙⵈⵏ ⵓⵔ ⴼⵔⴶ ⵔⴰ ⵏⵔⵜⵏ ⵓⵔ ⵏⵍⵗ ⵓⵍⴰ ⴹⵗ ⴼⵔⴶ ⵛⴾ ⵓⵔ ⵏⵙⵈⴰ ⵔⴰ ⵏⵔⵜⵏ ⵍⵗⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ⵛⴾ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵜⵔⵓ ⵔⵜⵏ ⵍⵗⵏⵏ ⵓⴹⵢ ⵜⵓⵈⵜⵙ ⵜⵓⴶⵓ ⵜⵓⴶⵔ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ⴹⵗ ⴹⵢ ⵍⴾⵏ ⵙ ⵏⵀⵜⵏ ⵓⵏ ⵀⵂⵓ ⵓⴰ ⴹⵙⵈⵙⵍⵏ ⵙ ⵜⵏ⵿ⵤⵜⵤⴹⵢⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ⵓⵔ ⴶⴹⴰ ⵢ ⴹⴶⵏⵏ \"ⵎⵍⵢ ⵎⵍⵢ⵰\" ⵓⵔ ⵤⴶⵤ ⵓⵏ ⵓⴹⵏ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⴾⵍⵔ ⴾⵏ⵿ⴹⵀⴰ ⵢ ⵜⵎⵤⵍ ⵙ ⵜⵔⴰ ⵏⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵏⵏ \"ⵎⵍⵢ ⵎⵍⵢ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵙⵎⵏⴾ ⵙ ⵏⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⵓⵏ ⴼⵍⵏⴰ ⴹⵜⵤⵤⵀ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵙ ⵏⵙ⵿ⵜⵗ ⴾⵍⵙⴼ⵰ ⵏⴶⴰ ⵙⵔⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴶⵜⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ⴹⵢ ⴹⵙⵏⵏⴰ \"ⵓⵔ ⴾⵍⴰ ⴾⵓⵏⵤⴹⵢⵗ⵰ ⴶⴶⵜⵢ ⵏⵎⵤⵔⵢ ⵏⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ⴹⵗ ⴹⵢ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵙⵎⵏ ⵢⵓⵍⵏ ⵓⴰ ⵎⵤⵍ⵿ⵜⵓ ⵓⴹⵢ ⵂⴰ ⵍⵎⵜⵍ ⵏⵍⵙ ⵏⵎⵍⵢ ⵏ⵿ⵜⵢⵜⵢ ⴾⵔⵙⵏ ⵂⵏⵜ ⴼⵍ ⵜⵙⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ⵓⵜ ⴾⵏⴾ ⴶⵏ ⵏ⵿ⴶⵢⵜⵏ ⵙⵂⵜⵏⵏ ⴶⵔⵏⵜⴹⵓ ⵜⵤⴾⵓⵏ ⵙ⵿ⵜⵀⵏ ⵢⵂⵏ ⵏ ⵎⵛⵏ ⵓⵔ ⴹⴰ ⴼⵍⵙ ⵜⵙⵍⵜ ⴼⵍ ⵀⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵙⵎⵏ ⵢⵓⵍ ⵓⴰ ⴶ ⴹⴰ ⵆⵎ ⵓⵔ ⵜⵎⵤⵍ ⵓⴹⵢ ⵂⴰ ⵍⵎⵜⵍ ⵏⵍⵙ ⵓⵔ ⵏⵍⴰ ⵜⵢⵜⵢ ⴾⵔⵙⵏ ⵂⵏⵜ ⴼⵍ ⵤⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ⵓⵜ ⴾⵏⴾ ⴶⵏ ⵏ⵿ⴶⵢⵜⵏ ⵙⵂⵜⵏⵏ ⴶⵔⵏⵜⴹⵓ ⵜⵤⴾⵓⵏ ⵙ⵿ⵜⵀ ⵓⵏ ⵢⵂⵏ ⵓⴰ ⵏⴹ ⵀⵔⵌⵜ ⵍⵢⵎⵏ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵍⴼⵢⴹⵜⵏ ⵛⵏ ⵜⵆⵎ ⵜⵎⵜⵢ ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵎⴾ ⵓⵙ ⵜⴶⵓ ⵙⵙⵗⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ⴼⵍⵙ ⴶⵙⵏ ⵙⵙⵗⵔⵢ ⵏⵓⴹⵏ ⵍⵏ ⵜⵏⵢⴰ ⵓⵔ ⵍⵏ ⵎⵙⵏⵏⵙⵏ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ⵙ ⴹⵤⵀⵜ ⵗⵢⵙⴰ ⴹⵗⵗ ⵓⵏ ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ⵂⵏⵏ ⵂⵤⵜⴹⵓ ⵓⴹⵏ ⵜⴶⵔⵓ ⵜⵓⵔⵏⴰ ⵏ⵿ⴾⵜⵔⵓ ⵙⵌⴹ ⴹⵜⵙ ⵏⴰ «ⵎⵍⵢ ⵙ ⵜⵔⵗ ⴹⵢ ⵜⴼⵔⴶⵗ ⴹⵜⵤⵤⵢⵗ ⵤⴹⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ⵤⵍⵏ ⵗⵢⵙⴰ ⴼⵙⵏⵜ ⴹⵙ⵿ⵜⵓ ⵏⴰ «ⵔⵗ ⴹⵢ ⵤⵢ ⵜⵤⴹⴶⴰ⵰» ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⵤⵢ ⵍⵙ ⵓⵏ ⴹⵗ ⴾⵜⵔⵓ ⵤⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ⵏⵙ ⵗⵢⵙⴰ «ⵏⵢ ⵤⴰ ⴹ ⵓⵔ ⵜⵎⵍⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵔⵜ ⵓⴰ ⴶⵏ ⴹⴰ ⵎⵔⵏ ⴶⵍⵓ ⵜⵙⴾⵏⵗ ⵎⵏⴾ ⵢⵍⵎⵎ ⵜⴶⴰ ⵜⴾⵜⵢ ⵜⴰ ⴾⵢⵙⵓⵔ ⵛⵔⵗⴰ ⵏⵏⵀⵢ ⵎⵙⴰ ⴹ ⵆⵍ ⴹⵢ ⵢⵢⵜⴹⵏ ⵜⴶⵢⴰ ⵏ ⵜⵎⵤⵢⵜⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ⵎⵤⵢ ⵓⴰ ⴹⴰ ⴹⵗ ⵏⵜⴶⵤ ⵗⵢⵙⴰ ⵜⵗⵔⵎ⵿ⵜ ⵏ⵿ⴾⴼⵔⵏⵂⵎ ⵏ⵿ⵜⴰ ⴹⵗ ⵜⵏⴾⴰ ⴾⵀⵜⵏ ⵢⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏⵔⵎ ⵏ⵿ⵙⵢⵜⵓ ");
INSERT INTO ttqt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ⵏⵙ «ⵎⵍⵢ ⵎⵛⵗⵍⵏ ⴹⵏⵢ ⵙⵔⴹ ⴹⵗ ⵗⵢⵓⵏ ⵀⴹⵏ ⴹⴶⵤ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ⵏⵙ ⵗⵢⵙⴰ «ⵏⴾ ⵎⵏⵏ ⵜⵤⴾⵏ ⵤⵤⵢⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ⵏⵙ ⴾⵀⵜⵏ ⵏ «ⵎⵍⵢ ⵏⴾ ⵓⵔ ⵓⴹⵗ ⴹ ⵜⴶⵤⵗ ⵂⵏⵏ⵰ ⵏⵓ ⵔⵜ ⵗⵙ ⴹ ⵤⵢ ⵎⵛⵗⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ⵙⵏⴰ ⴹⵗ ⴹⵢ ⴼⵍⵙ ⵓⴹⵏ ⵎⵙⵗ ⴹⵗ ⵜⴼⵏ ⵓⵢⴹ ⵜⵏⵜ ⵜⴼⵆⵜ ⵏⴾ ⵎⵏⵏ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⴹⵓⵢ ⵍⵏⵏ⵰ ⵙ ⵏⵗ ⵢⵢⵏ \"ⴶⵍ\" ⴹ ⴶⵍⵓ ⵙ ⵏⵗ ⵢⵢⵏ \"ⵢⵓ\" ⴹⴹⵙⵓ⵰ ⵙ ⵏⵗ ⵢⴾⵍⵏⵏ \"ⴶⵓ ⵓ\" ⴹ ⵜⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢⵓⴰ ⵏⴰ ⴾⵀⵜⵏ ⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵏⵢⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⴾⵍⵙⵔⵢⵍ ⴶⵏ ⵤⴶⵤⵏ ⵓⴹⵏ ⵓⴰ ⴶⴰ ⵍⵙ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","«ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⴼⵍⵏ ⴹⵏⴶ ⴹⵜⵔⵎ ⵏⵗⵎⵏ ⴹⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹⵢⵆⵀ ⴹⵔⵓⵏ ⴹⵔⵙⵏ ⵎⴶⵔⴰ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ⵎⵛⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⵙⵏ⵿ⵜⵏⵢ ⵙ ⵜⵜⵓⵙⵎⵜⴶ ⵜⵗⵎⵔ ⵜⴰ ⵓⵏ ⴹⵢ ⴹⵏ⵿ⵜⵓⵀⴹⵗⵏ ⵙⴹⵢ ⴹⵗ ⵛⵢⵢ ⴹ ⵂⵍⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⴾⵀⵜⵏ ⵓⴰ ⵏⴹ «ⵆⵍ ⵗⵢⵓⵏⴾ ⴶⵜⴾ ⵎⵛⵏⴰ ⵔⵜ ⵓⴰ ⴹⵗⵙ ⵜⴶⵎⵢⴰ ⴼⵍ ⵤⴶⵤⵏⴾ⵰» ⵜⵤⵔ ⵤⵢ ⵎⵛⵗⵍ ⵏ⵿ⴾⵀⵜⵏ ⵓⵏ ⴹⵗ ⵎⵤⵢ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ⴹⴼⵔ ⴹⵢ ⴾⴰ ⵗⵢⵙⴰ ⵂⵏ ⵏⵀⵜⵔⵙ⵰ ⵏⵢ ⵜⴹⴶⵍ⵿ⵜ ⵏⵀⵜⵔⵙ ⵜⵙⵔⴹ ⵜⵏⴹ ");
INSERT INTO ttqt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ⴹⵙ ⴼⵙⵏⵜ ⵜⵓⵜ ⴼⵍⵙ ⵜⵏⴹⵢ ⵜⵏ⵿ⴾⵔⴹⵓ ⵜⵜⵙⵎⴶⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵎⵓⵢⵏⵙⴹⵓ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙⵔⵏⵏ ⴾⵍⵙⴼ⵰ ⵗⵔⴹ ⵗⵢⵙⴰ ⵙⵜⵗ ⵏ⵿ⴾⵍⵙⴼ ⵓⵏⴹ ⵙ ⵜⴼⵔ⵿ⵜ ⵢⴹⴰ⵰ ⵤⵤⵢ ⴹⵗ ⵎⵔⵏⵏ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ⵎⴾ ⵓⵏ ⴹⵗ ⵙ ⵏ⵿ⴹⴰ ⵓⵍ ⵓⴰ ⴹⴶⴰ ⵎⵍⵢ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙⵢⵙ ⴹⵗ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⴾⵍⵏ ⵍⵗⵀⵏⵏⴰ ⴹⴾⵍ ⴼⵍ ⵔⵏⵜ ⵛⵓⵔⵏⵓⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⵜⵗⵍⵢⵗⵍⵢⵜⵓ ⵎⵔ ⵏⵜⵍⵀⵏⵜ ⵙⴹⵔⵙ ⴹⵓⵏ ⵗⵔⵙⵏ ⵙ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ⴾⵢⴹⵓ ⵎⵙⵏ ⵏⵜⵓⵔⵜ ⵢⵏ ⵏⵙ «ⵛⵈ ⴹⴾⵍⴾⵎⵗ ⵙⴹⴶ ⴾⵍ ⵓⴰ ⵜⴾⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ⵏⵙ ⵗⵢⵙⴰ «ⵤⴶⵤⵏ ⵍⵏ ⵏⵓⵏ ⴶⴹⴹ ⴹⵗ ⵍⵏ ⵛⵙⵍⵍⴰ ⵎⵛⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵓⵔ ⵍⵗ ⵓⵍⴰ ⴹⴶ ⴹⵗ ⵙⵏ⵿ⵙⵗ ⵗⴼⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ⵏⵙ ⵏⵍⴾⵎⵏⵜ ⵢⵏ «ⵎⵍⵢ ⴾⴼⵢ ⵜⵔⴶⵜ ⵏⴹ ⴶⵍⴰ ⵂⵔ ⴹⵏⵏⵀⵍⵗ ⵀⵏⵏ ⵜⵤⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⵍⴾⵎⵢ ⵜⵢⵗ ⵏⵎⵜⵏ ⴹ ⵏⵀⵍⵏ ⵏⵎⵜⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ⴹⴼⵔ ⴹⵢ ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ⵓⵍⴰ ⵂⴶⵏ ⵜⴶⵔⴹⵓ ⵜⵤⴼⴰ ⵍⵀⵙⵜ ⴼⵍ ⴶⵔⵓ ⴹ ⴶⵜⵏⵜ ⵜⵏⵤⵎⵔⵏ ⵗⵍⵍ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵏ⵿ⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵜⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵙ ⴶⵏⵏⵙ «ⵎⵍⵢ ⴶⵤⵏⴰ⵰ ⵏⴾⵏⵢ ⵏⵌⵓⵔ ⵏⵂⵍⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ⵏⵙⵏ «ⵎⴼⵍ ⵜⵂⵓⵏ ⵜⵙⴰ ⵜⴶⴹⵜ ⴹⵓⴰ ⴾⵍ ⵤⴶⵤⵏ ⵔⴾⵎⵏ⵰» ⵏ⵿ⴾⵔⴹⵓ ⵗⵢⵙⴰ ⵙⵏⵔⵗⵎ ⵢⴹⵓ ⴹⴶⵔⵓ ⵗⵔⴹⵏ ⴹⵔⵔ ⴹⵙⵙⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ⵔⵜ ⵓⴰ ⵆⵏ ⵗⴼⵓⵏⵙⵏ ⴹ ⴶⵏⵏ «ⵎⴰ ⵎⵙ ⵓⴰ ⴹⵗ ⵓⴹⵏ ⵙ ⵓⵍⴰ ⴹⵓ ⴹⴶⵔⵓ ⴹⴰ ⵜⴼ ⴹⵗⵙⵏ ⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ⵙ ⵓⵔ ⵗⵢⵙⴰ ⴶⵏⴰ ⵓⴰ ⵂⴹⵏ ⵏⴶⵔⵓ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⴹⵔⵜⵏ ⵙⵍⴾⴹⵏⵙⴹⵓ ⵛⵏ ⵢⵜⴹⵏ ⵙⵔⵏⵏ ⴾⵍⵙⴼ ⴶⵎⴹⵏ⵿ⴹⵓ ⵙⵔⵙ ⵤⴾⵓⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵓⴰ ⴶⵏ ⴹⵗ ⵜⵍⵀⵙ⵿ⵜ ⵓⵔ ⵜⵍⴰ ⵢ ⵂⵍⵏ ⴹⴾⵢ ⴹⵗ ⴹⴶ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ⵙⵗⵔⵏⵙⴹⵓ ⴶⵏⵏ «ⵎⴰ ⴹⵗⵏⴰ ⵜⵔ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰ ⵓⴾ ⵙⴰ ⴹⵜⴶ ⵢⴹⵏⵜⵙⴾⵔⵔ ⴹⴰ ⵓⵔ ⴹⵜⵓⴹ ⵜⵎⵙ⵿ⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ⵏ⵿ⵜⴰ ⵍⵜⵓ ⵙⴶⵏ ⴶⵏ ⵏⵍⴹⵢⵏ ⴹⵏⵏ ⴹⵗ ⴶⴶⵏⵙⵏ ⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ⵏ⵿ⵙⵢⵏ ⴾⵍⵙⴼ ⵓⵏ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵙ ⴹⵏⵜⵙ⵿ⵜⵗⴰ ⵜⵙⴾⵗⵏⵗ ⵙⴶⵏⵏ ⵏⵍⴹⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ⵏⵙⵏ «ⴶⵍⵜ⵰» ⵜⵤⵔ ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⵎⴹⵏ ⵓⵏ ⵛⵏ ⵏ ⴾⵏ ⵍⴹⵢⵏ ⴶⵤⵏ⵿ⵜⵏ⵰ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⴹⵓⴼⵏ ⵍⴹⵢⵏ ⵓⵏ ⴹⵏ ⴾⵍ ⴼⵍ ⵤⴹⴶⴰ ⵏ⵿ⵜⴾⵛⵓⵔ⵿ⵜ ⵗⵔ⵿ⵜⵜⵓⵏ ⴹ ⵜⴼⵜⵆⵏ ⴹⵗ ⴶⵔⵓ ⵍⵎⵤⵏ⵿ⵜⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ⵜⵤⵔ ⵤⵍⵏ ⵎⴹⵏⵏ ⵏⵍⴹⵢⵏ ⵓⵏⴹ ⵙⵗⵔⵎ ⵙⵗⵍⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴶⵏ ⴹⵏ ⵢⵢⵜⴹⵏ ⴹⵓⴰ ⴶⵏ ⴼⵍ ⵎⴹⵏ ⵓⵏ ⵙⵔⵏⵏ ⴾⵍⵙⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ⴹⵏ ⴹⵗ ⴹⵗⵔⴹⵏ ⴾⵍ ⵗⵔⵎ ⵓⵏ ⴶⵎⴹ ⵙⵍⴾⴹⵏ⵿ⴹⵓ ⵢ ⵗⵢⵙⴰ ⵏ⵿ⵙⵢⵏ⵿ⵜⵓ ⴹ ⴶⵎⴹ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ⵜⵤⵔ ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵗⵔⵙ ⴶⵔⵓ ⴾⴰ ⵜⵗⵔⵎ⵿ⵜⵏⵜ ⴾⴼⵔⵏⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ⵓⵢⵏⵙⴹⵓ ⵢⵜⴹⵏ ⵏⵀⴹⵏ ⵂⵏ ⵜⵙⵜⵏⵜ⵰ ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵤⴶⵤⵏⵙⵏ ⵏⴰ ⵢⵏⵀⴹⵏ «ⴰ ⴾⵢ ⵓⵔ ⵛⵓⵛ ⵓⵍⴰ ⵀⵔⵔⵏ⵰ ⵀⴾⴹⵏⴾ ⵜⵓⵙⵔⴼⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ⵜⵤⵔ ⵏⵏ ⵔⵜ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵓⵢⴹ ⴹⵗ ⵎⵏⵙⵏ «ⵍⵙ ⵓⴰ ⵎⴹⵔⵓ ⵜⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ⵏⵙⵏ ⵗⵢⵙⴰ ⵙⵏⵏ ⴹⵗ ⵓⴰ ⵙⵎⴹⵔⵏⵏ «ⵎⴼⵍ ⵜⵜⴶⵎ ⵔⴾ ⵎⴹⵔⵏⵏ ⵓⵏ ⴹⵗ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ⵓⴾ ⵎⴰ ⴶⵔⵏ ⵜⵔⵗⵙⵢ ⴶⵔ ⵢ ⵏⵏ \"ⵀⴾⴹⵏⴾ ⵜⵓⵙⵔⴼⵏⴾ\" ⵎⵗ ⴾ ⵢ ⵏⵏ \"ⵀⴹⴹ ⵌⵓⵏ⵿ⴾⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ⵎⵔⵏ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵍⵗ ⴹⵗ ⴹⵏⵜ ⵜⵏⵢⴰ ⴹⵜⵛⵛⵓⴹⵜ ⴹ ⵙⵔⴼⴰ ⵢⵓⴹⵏ ⵀⴾⴹⵏⵜ⵰» ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢⵏⵀⴹⵏ «ⵀⴹⴹ ⵜⴹⴾⵍⴰ ⵜⵙⵜⵏⴾ ⵜⴾⵗ ⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ⵀⴹⴹ ⵍⵙ ⵓⵏ ⴾⴰ ⵗⵢⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ⵙ ⵏⵢⵜ ⵜⵎⵜⵓⵏ ⵔⵜ ⵓⵏ ⵜⵗⵔⴹⵜⵏⵜ ⵜⵙⴰ ⴶⵤ ⴹ ⵜⴶⵏⵜ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⴾⴼⵏ ⵜⵔⵏⴰ ⵜⴶⴹⵜ ⴹⵓⵏ ⵢⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⵍⵎⴹⵓ ⴹⴶⵎⴰ ⵏⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵎⵜⴰ ⵆⵎⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⵤⵔⵤⵎ ⵏⵤⵔⴼ ⵓⵏ ⵜⴾⵙ ⵏⵙ «ⵍⴾⵎⵢ⵰» ⵜⵤⵔ ⵀⴹⴹ ⵎⵜⴰ ⵍⴾⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ⵤⵍ ⵢⵏ ⵂⴰ ⵗⵢⵙⴰ ⵗⵢⵓⵏ ⵏⵎⵜⴰ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵏⵙⵀⴾⴹⵏ ⴹⵔⵓ ⴹⵔⵙⵏ ⵎⵏ⵿ⵙⵓⵏ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ⵏⵢⵏ ⴼⵔⵙⵢⵜⵏ ⵔⵜ ⵓⴰ ⵏⵏ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵎⴼⵍ ⴹⵔⵓ ⵛⵈⵏⵓⵏ ⴹⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵏⵙⵀⴾⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ⵙⵍⵙⵏ ⵗⵢⵙⴰ ⵏⴰ «ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵗⵍⵢ ⵓⵔ ⴹⵔⵔⵏ ⵙⵏⵙⵎⴶⵍ ⵎⵔⵏⵏ ⵙⵔⵙ ⴹⵔⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ⴶⵍⵓⵜ ⵜⵙⵏⵎ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵓ ⵜⴰ ⴶⴰ ⵎⵛⵏⴰ ⵙ ⵏⴰ \"ⵜⵂⵏⵏ⵿ⵜ ⵔ ⵓⵔⴶⵗ ⵛⴾⵜⵓⵏ⵰\" ⵓⵔ ⴹⵙⵗ ⴼⵍ ⴹⵗⵔⵗ ⵢⵜⴹⵏ ⵓⵏ ⵗⵔ ⴶⴰ ⵙ ⵗⴹⵏ ⴾⵍⵔ ⵏⵙⵀⴾⴹⵏ ⵙ ⴹⵎⵤⵍⴰ ⵢⵜⵏ⵿ⴹⵗⵔⴰ ⵆⵍⵏ ⵏⵍⴾⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ⵜⵤⵔ ⴾⵏⵏ ⵏⵜⵍⵀ ⵏⵢⵈⵢⴰ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴼⵍ ⵏⴾⵏⵢ ⴹⴼⵔⵙⵢⵜⵏ ⵏⵜⵤⵎ ⴼⵓ ⵎⵔⵏ ⴾⵢ ⵏⵜⵍⵀⵏⴾ ⵓⵔ ⵜⵤⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴾ ⵍⴶⵜⵏ ⵗⵔ ⵍⴰ ⵎⵤⵍⵢ ⵤⴾⵏ⵿ⵤⵔⵏ⵰ ⵎⵛⵏ ⵍⴾⵎⵏ ⴹⵏ ⵗⵔⵙⵏ ⵤⵎⴹⴾⵍ ⵎⵤⵍⵢ ⴹⵢ ⵎⵔⵏ ⴹ ⵤⵤⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ⵓⵔ ⵜⵍⴰ ⵢ ⵤⵓⵜⵏ ⵛⴾⵙ⵿ⵜ ⵜⵢⵏⵢⵜ ⴹⵗ ⵜⵀⴹⵆ ⵓⵛⵔⵜ ⴼⵍⵙ ⴹⵢ ⵛⴾⵙ⵿ⵜ ⵜⴰ ⴹⵏ⵿ⵜⵜⵓⵜⵜ ⴹⵜⵤⴾⵓⵏ⵿ⵤⵤ ⵜⵀⴹⵆ ⵜⴰ ⵓⵛⵔⵜ ⵜⵤⵔ ⵜⵛⵜⵙ ⵤⵔⵓ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵢ ⵤⴶⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵢⵏⵢⵏ ⴹⵗ ⴶⴹⴹ ⴼⵍⵙ ⵙ ⴶⴰ ⴹⵢ ⴹ ⵀⵆⵏ ⴶⴹⴹ ⵓⵏ ⵜⵤⵔ ⴼⵜⵓ ⴹⵗ ⵙⵎⴹ ⴹⴶⴹⴹ⵰ ⴾⵍⵔ ⵔⵜ ⵓⴰ ⵂⵔⵏ ⴹ ⵜⵓⴶⵓ ⵙⵎⴹ ⵓⴰ ⵢⵏⵢⵏ ⴹⵗ ⵀⵢⵗ ⵢⵏⵢⵏⵏ ⵎⴾ ⵓⴹⵢ ⴹⵗ ⵙ ⵤⵗⵍⵙ ⵙⵎⴹ ⵂⵔⴾⴹ ⵀⵢⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ⵛⵓⵍⵙⵏ ⵗⵢⵙⴰ ⴹⵏ ⴹⵗ ⵙ ⴹⵙⴰ ⵢⵏ ⴹⵗ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙⵌⴹ ⴹⵜⵙ ⵏⵙ «ⵜⵀⵔⵔ⵿ⵜⵏ ⵀⴰ ⵎⵔⴹⴰ ⵎⵛⵏ ⵢⴰ ⵙⵏⵗ ⵙ ⵙ ⴹⵜⵙ ⵜⵙⵓⵔⵆⵜ ⴼⵙⵏⴾ ⴹⵜⵏ⵿ⴾⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ⵜⵤⵔ ⵏ⵿ⴾⵔⴹⵓ ⵗⵢⵙⴰ ⵍⴾⵎⵙ ⴹⵓⵏ ⴹⵔⵙ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ⵜⵍⵜⵓ ⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⵎⵔⵓ ⵍⵏ ⴹⵛⵏ ⴶⵎⴹⵜⵜ ⵤⵏⵢ ⵜⵂⵤⴹⵓ ⵗⵢⵙⴰ ⵙⴰ ⵙⵔ ⵜⵗⵔⴹⵏ ⵜⴹⵙ ⵜⵀⵏⴾ ⵏ⵿ⵜⴾⴹⴾⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ⴼⵍⵙ ⵜⵏⴰ ⵜⴶⴰ ⴹⵗ ⵎⵏⵜ «ⴶⴹⴰ ⵗⵙ ⴹ ⴹⵙⴰ ⵜⴾⴹⴾⵜⵏⵜ ⴹ ⵤⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ⵎⵍⵍⵢⵏ ⵗⵢⵙⴰ ⵏⵢⵜⵜ ⵏⵙ «ⴹ ⵓⵔ ⵜⵗⵛⴹⴰ ⵜⵀⵔⵔ⵿ⵜⵏ⵰ ⵤⴶⵤⵏⵎ ⵙⵔⵢ ⴾⵎⵤⵤⵢⵏ⵰» ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⵜⵤⵢ ⵜⵏ⵿ⵜⵜ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ⴹⴼⵔ ⵓⵏ ⴾⴰ ⵗⵢⵙⴰ ⵂⵏ ⵏⵎⵤⵔ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏⴹ⵰ ⵙ ⴹⵏⵓⴹ ⵗⵢⵙⴰ ⵏⵢ ⵎⵓⵜⵏ ⵏ⵿ⵜⵙⵏ⵿ⵙⵗ ⵛⵏ ⵜⴼⵢⵓⵜ ⴹⵢⵜⴹⵏ ⵏⵌⵔⵓⵢⵏⵏ ⴶⵏ ⵜⵔⵎⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ⵏⴰ «ⵓⴹⵏ ⴾⵍ ⵔⴹⵗⵜ⵰ ⵜⵀⵔⵔ⵿ⵜ ⴹⵢ ⵓⵔ ⵜⵜⵀⴰ ⵜⵙ ⵗⵙ ⵜⴶⴰ⵰» ⵜⵤⵔ ⴶⵏ⵿ⵜⵓ ⵌⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ⵙ ⵜⵜⵓⵙⵔⴹⵗ ⵜⵎⵜⵢ ⵜⵏ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵓⴰ ⵜⵂⴰ ⵜⵀⵔⵔ⵿ⵜ ⵜⴰ ⵀⴰ ⵀⵤ ⴼⵙⵏⵜ ⵙⵏ⵿ⴾⵔ⵿ⵜⵜⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ⵓⵤⵓⵤⵏ ⵙⵍⵏ ⵏⵓⴰ ⴶⵏ ⴹⵏ ⴹⵗ ⴾⵍ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ⵙ ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⵍⴾⵎⵏⵙ ⵛⵏ ⵎⴹⵔⵗⵍ ⵙⵗⵔⵏ ⴶⵏⵏ «ⵢⴰ ⴶ ⵏⵀⵢ ⴹⵓⴹ⵰ ⵂⵏⵜⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ⵙ ⴹⵏⵓⴹ ⵗⵢⵓⵏ ⴶⵤ ⵂⵏ ⵂⵤⵏ⵿ⵜⵏ ⵎⴹⵔⵗⵍ ⵓⵏ ⴹⵏ ⵏⵙⵏ «ⵜⵤⴶⵤⵏⵎ ⵙ ⴼⵔⴶⵗ ⴶⵢ ⵏⵔⵜ ⵓⴰ ⵜⵔⵎ ⴹⵢ⵰» ⵏⵏⵙ «ⵓⵍⴰ ⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ⵜⵤⵔ ⴹⵙ ⵛⵜⵓⵏⵙⵏ ⴶⵏⵓ «ⵜⵓⴶⵓⵜⵓⵏ ⵔⵜ ⵓⴰ ⵏⵎⵏⴾⵏ ⴹⵤⴶⵤⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ⴹⵏ ⴹⵗ ⴹ ⴶⵔⵓⵏ ⵙⵓⴹⵏⵙⵏ⵰ ⴶⵙⵏ ⵗⵢⵙⴰ ⵜⵔⵗⵎ⵿ⵜ ⵜⵙⵂⵜ ⵏⵙⵏ «ⵏ⵿ⴾⴹⵜ ⵢⴹ ⵙⵏ ⵎⵙⵏ ⵓⴹⵏ ⴹⵗ ⵓⴰ ⴹⵓⵏⴶ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ⵎⵛⵏ ⵙ ⴶⵍⵏ ⵤⵓⵤⵓⵤⵏ ⵙⵍⵏⵜ ⴹⵗ ⴾⵍ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ⴼⵍⵏ ⵗⵢⵙⴰ ⵗⵙ ⵎⵓⵢⴹⵓ ⵙⵔⵙ ⵓⴹⵏ ⵙ ⵎⴹⴹ ⵎⵏⵜ ⴹ ⴶⵙⴼ ⵜⵤⴹⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ⴾⵙ ⵗⵢⵙⴰ ⴶⵙⴼ ⵓⵏ ⵗⵙ ⴶⵤ ⵓⴹⵏ ⵓⵙ ⵎⴹⴹ ⵎⵏⵜ ⴹⵏ ⵛⵏ ⵓⵍ⵰ ⵙⵎⴾⵍⵍ ⵓⵏ ⵙ ⵜⵎⵜⵢ ⴹ ⵜⴶⵏⵓ «ⵔⵜ ⵓⴰ ⵓⵔ ⴾⵍⴰ ⵜⵜⵓⵏⵢ ⵜⵍⵜⵏⵜ ⴹⵗ ⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ⴼⵔⵙⵢⵜⵏ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢ ⴶⵏⵏ «ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵙⴼ ⵜⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ⵍⵍ ⵗⵢⵙⴰ ⵗⵔⵎⵏ ⴹⵜⵗⵔⵎⵜⵏ ⴾⵍ ⵙⵙⵗⵔⵓ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⴶⵓ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵤⵤⵢ ⴹⵗ ⵢⵜⴹⵏ ⴹⵗ ⵤⵏⴼⵏ ⴾⵍ ⵏ⵿ⵜⵓⵔⵏⵓⵏ ⴹⵍⵗⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ⵙ ⵏⵢ ⵜⵎⵜⵢ ⵜⴶⵤⵜⵓ ⵜⵂⵏⵏ⵿ⵜⵏⵜ ⴼⵍⵙ ⵔⴾⵏⵢ ⵏⵢⵏ ⵜⵓⵢⵏ ⴹⵎⵏⵙⵏ ⵎⵙⵏ ⵤⵏ ⵢⴼⴹ ⵓⵔ ⵏⵍⴰ ⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ⵜⵤⵔ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵗⵔⵜ ⵜⴶⵜ ⵎⵛⵏ ⵓⵔ ⴶⵜⵏ ⵎⵛⵗⵍⵏ ⵓⵏ ⵜⵜⵤⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ⴹⵗ ⴹⵢ ⵜⵔⵜ ⵙⵙⵎ ⵏⵎⵛⵙ ⵏ⵿ⵗⵔⵜ ⵜⴰ ⴹⵙⴶⵍⵓ ⵎⵛⵗⵍⵏ ⵜⵜⵍⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵙ ⵎⵏⵜ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴾⴼⵏ ⵜⵔⵏⴰ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⴹⵤⵤⵢ ⵏ⵿ⵜⵆⵍ ⵜⵓⵔⵏⴰ ⴹⵆⵍ ⵍⵗⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵙⵎⵓⵏ ⵏⵎⵤⵍ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵓⴰ ⵤⵔⵏ ⵙⵎⵏⵜ ⵙⵎⵗⵏ ⵜⵓⵏⵙ ⵀⵜⵔⵙ ⴹⵏ⵿ⴹⵔⵓⵙ ⵓⵏ ⵎⴹⵔⵢⵏⵜ ⴹⵢⵆⵀ ⵓⵏ ⴶ ⵤⵀⴹⵢ ⴹⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵔⵢⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ⴹⴼⵍⵀⵙ ⴹⵀⵔ⵿ⵜⵍⵎⵓⵙ ⴹⵜⵎⴰ ⴹⵎⵜⴰ ⵓⴰ ⵤⵔⵤⵎⵏ ⵜⴾⵙⵏ ⴹⵢⵆⵀ ⵓⵏ ⴶ ⵍⴼⵢ ⴹⵜⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ⴹⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵓⴰ ⵙⴶⵜⴾⵏ ⴹⵢⵂⵤⴰ ⵓⵙ ⵜⵓⵏⵓ ⵙⵈⵔⵢⵜⵢ ⵙⵏ⵿ⵜⴰ ⵤⴶⵏ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴰ ⵎⵔⵓ ⵏⵜⵍⵀ ⴹⵛⵏ ⵓⵏ ⵤⵎⵤⵍ ⵗⵢⵙⴰ ⴹⴼⵔ ⵙ ⵜⵏⵎⵔ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵜⴾⵎ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⴹⵗ ⵜⴶⵤⵎ ⵗⵔⵎ ⵓⵍⵢⵏ ⵏ⵿ⴾⵍⵙⵎⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ⴾⵍⵔ ⴾⵓⵜ ⴾⵍⵙⵔⵢⵍ ⵓⵏ ⵎⵙⵏⵏ ⵤⵏ ⵢⴼⴹ ⵙⴶⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ⴶⵍⵓⵜ ⴹⵙⵏ⵿ⵜⵜⴶⵎ ⵙⵍⵏ ⵏⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⵤⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ⵤⵤⵢⵜ ⵎⵔⵏⵏ ⴹⵜⵙⵏ⵿ⴾⵔⵎ ⵏⵎⵜⵏ ⵜⵤⵤⵢⵎ ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓ ⴾⵜⵔⵓ ⵜⵤⵤⴹⴶⵎ⵿ⵜⵏ ⴹ ⵜⵜⴾⵙⵎ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰ ⵀⵏⵏ ⵙ ⵜⵜⵓⴾⴼⵎ ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⴹⴰ ⵂⴾⵓⵜ ⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ⴹ ⵓⵔ ⵜⵜⵓⵢⵎ ⵔⵗ ⵓⵍⴰ ⵤⵔⴼ ⵓⵍⴰ ⴹⵗ ⵜⵆⵍ ⵜⴼⵍ⵿ⵜ ⴹⵗ ⵏⴼⴹⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ⵓⵍⴰ ⴹⵗ ⵗⵔⴶ ⴹⵗ ⵛⴾⵍⵏⵓⵏ ⵓⵍⴰ ⵜⴾⴹⴾⵜ ⵜⵏ ⵙⵏⵜⵜ ⵓⵍⴰ ⵜⵙⵙⵍ⵿ⵜ ⵜⵏ ⵙⵏⵜⵜ ⵓⵍⴰ ⵜⵍⵆ⵰ ⵙⵏⵜ ⵙ ⴹⴶ ⵜⵙⵎ ⴹ ⵜⵜⵓⵙⵎⴶⵔⵎ ⴼⵍⵙ ⵎⵛⵗⵍⵏⵏ ⵜⵎⵙⵎ ⵎⵔⵏ ⵎⵛⵗⵍ ⴾⵍ ⵍⴰ ⵍⵈⵆ ⵏⴹ ⴶⵔⵓ ⵜⵛⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ⵙ ⴹⵜⴶⵤⵎ ⵗⵔⵎ ⵎⴹⵗ ⵜⵗⵔⵎ⵿ⵜ ⵜⴶⵎⵢⵎ ⵓⴹⵏ ⵓⴰ ⵏⵂⴶⵏ ⴹⵗⵔⵙ ⵜⵙⴶⵏⵎ ⵜⵆⵎⵎ ⵗⵔ ⵓⴹⵏ ⵓⴹⵢ ⴹⴰ ⵂⵔ ⵙⵗⴰ ⴹⵗ ⵜⴶⵎⴹⵎ ⵗⵔⵎ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ⵙ ⴹⵜⴶⵤⵎ ⵂⵏ ⵜⵏⵎ \"ⵍⵈⵔ ⴼⵍⵓⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ⴾⴹ ⵢⵜⴹⵏ ⵏⵂⵏ ⵓⴹⵢ ⵏⵂⴶⵏ ⴹⵗⵔⵙⵏ ⵜⵙⴶⵏⵎ ⵓⴹⵢ ⵜⵓⵜⵔⵢ ⵏⵍⵈⵔ ⵜⴰ ⴹⵙⵏ⵿ⵜⴶⵎ ⴼⵍⵙⵏ ⵜⵆⵀⵍ ⵎⵛⵏ ⵙ ⵓⵔ ⵏⵂⴶⵏ ⴹⵗⵔⵙⵏ ⵜⵙⴶⵏⵎ ⵓⴹⵢ ⵜⵓⵜⵔⵢ ⵜⵏ ⵓⵔ ⵤⴰ ⵜⵆⵀⵍ ⴼⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ⵙ ⵓⵔ ⵜⵜⵓⵆⵀⵍⵎ ⵓⵔ ⵜⵓⵙⵙⵎ ⴹⵗ ⵢ ⵀⵜⵏⵓⵏ ⴹⵗ ⵗⵔⵎ ⵓⴹⵢ ⵎⴹ ⴹⵗ ⵗⵢⵓⵏ ⵓⴹⵢ ⵜⴶⵎⴹⵎ⵿ⵜⵓ ⵜⵀⴾⵀⴾⵎⵏ ⴶⴹⵔⵔⵏⵜ ⵓⴰ ⵓⵔⵏ ⴹⵔⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⴹⵢ ⴹ ⴶⵏ ⵍⵗⵤⵀ ⴶⵔⵏ ⵓⴰ ⵤⴶⵏ ⵓⵏ ⵎⴹⵍ ⵏ⵿ⵙⴹⵎ ⴹⴶⵎⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ⵙⵏⵜ ⵙ ⵤⵎⵤⵍⵆⵓⵏ ⵜⵎⵙⵎ ⵤⵏ ⵢⴼⴹ ⵂⵏⵏ ⵎⵙ ⵏⵔⴹⵍⵏ ⴹⵗ ⴹⵢ ⵍⵓⵜ ⵜⵢⵜⵢ ⵜⴶⵎ ⵏⵢⵜ ⵤⵏ ⵓⴰ ⵜⴶⵏⵜ ⵜⵛⵍⵏ ⵜⵍⵎ ⴹⵜⴹⵀⵔⵏ ⵓⵔ ⵓⵔ ⵎⵙⵏ ⵍⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ⵏ⵿ⴾⴹⵜ ⵢⵢⵜⴹⵏ ⴼⵍⵙ ⴾⵓⵏⵙⵀⴹⴹⵏ ⴹⵜ ⵙⴶⵓⵔⵏ ⵏⵛⵔⵗⴰ ⴾⵓⵏⴶⵜⵏ ⵙ ⵍⴾⴹ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ⴹ ⵜⵜⵓⵙⵀⴹⴹⵎ ⴹⵜ ⵏⵈⴾⵎⵏ ⴹⵎⵏⴾⵍⵏ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ ⵜⵆⵍⵎ ⵛⴶⵢⵓⵏⵏ ⵢⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ⵎⵛⵏ ⵙⵗⴰ ⵓⴹ ⵤⴰ ⵜⵜⵓⴶⵎ ⴹⵗ ⴼⵙⵏ ⴾⵓⵏⵓⵔⵛⵓⵛ ⵎⴾ ⵓⵙ ⵤⴰ ⵜⵛⵓⵍⵎ ⵓⵍⴰ ⴹⵗ ⵓⴰ ⵤⴰ ⵜⵏⵎ ⴼⵍⵙ ⵔⵜ ⵓⴰ ⵤⴰ ⵜⵏⵎ ⴼⵍⵓⵏ ⴹⵤⵀⵜ ⴹⵗ ⵎⵤⵢ ⵓⴰ ⴹⴰ ⴹⵗ ⵜⵔⵎ ⵜⵏⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ⴹ ⵓⵔⴶ ⴾⵓⵏⵢ ⵤⵛⵓⵍⵏⵏ ⴾⵍⵔ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵀⵏⵓⵏ ⴹⵗⵓⵏ ⵛⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ⴹ ⵙⵜⵔⵎⵙⵏ ⵢⵜⴹⵏ ⵎⴹⵔⵢⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ ⵙⵜⵔⵎⵙⵏ ⵀⵜⵏ ⵀⵔⵔⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ ⴼⵍⴶⵏ ⵀⵔⵔⵏ ⴼⵍ ⵎⵔⵓⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ⵓⴹⵏ ⴾⵍ ⴾⵓⵏⴶⵤⵔ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ ⵎⵛⵏ ⵓⴰ ⴹⵗⵓⵏ ⵤⵎⵔⵏ ⵂⵔ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵢ ⴹ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ⵙ ⵜⵜⵓⵙⵙⵎ ⴹⵗ ⵗⵔⵎ ⵜⴹⵔⴶⵎ ⵙⵢⵏ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⴹⵤⵜⵗⵔⴹⵎ ⵗⵔⵎⵏ ⵏⵙⵔⵢⵍ ⵂⵔⵓⴰ ⴹⴰ ⵙ ⴹⵤⵆⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ⵜⵍⵎⵢ ⵓⵔ ⴶⵔ ⵛⵈⵏⵜ ⵓⵍⴰ ⴹⵗ ⴶⵔ ⴾⵍⵢ ⵎⵛⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ⴶⴹⴰ ⵢⵜⵍⵎⵢ ⴹ ⴶⴹⵓ ⴹⵛⵈⵏⵜ ⴾⵍⵢ ⴹⵗ ⴶⴹⵙ ⴹ ⴶⴹⵓ ⴹⵎⵛⵙ⵰ ⴹⴹ ⵤⵎⵙ ⵎⵤⵔ ⵏⵗⵢⵓⵏ ⴶⵏⵙ ⵙⵎ ⵛⵢⵜⵏ ⵏⵀⵗⵍⵤⵀⵍ ⵎⵏⵎⴾ ⵙ ⵓⵔ ⵤⴶⵏ ⵔⴾ ⵀⵜⵜⵏ ⵢ ⴾⵍ ⵗⵢⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ⴹⵗ ⴹⵢ ⵜⵏⵓⵔ⵿ⵜⴾⵙⴹⵎ⵰ ⵔⵜ ⴾⵍ ⵓⴰ ⵗⵀⵔⵏ ⴹ ⵜⵓⵙⵏⴼⵍⵍ ⵎⵔⵏ ⵙⵔ ⴾⵍ ⴹ ⴼⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ⵔⵜ ⵓⴰ ⴹⵓⵏⵏ ⴹⵗ ⵛⵢⵢ ⵏⵓⵜⵓ ⵤⵍ ⵎⵍⵏ⵰ ⵎⵔⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵓⵏⵜⵓⵙⵜⴾⵜⴾⵏ ⵏⵓⵜⵓ ⵙⴼⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ⴹ ⵓⵔ ⵜⴾⵙⴹⵎ ⵓⵏ ⵏⵆⵏⵏ ⵜⵗⵙⴰ ⵏⵓⴹⵏ ⵗⵙ ⵎⵔⵏ ⵓⵔ ⴼⵔⴶⵏ ⵗⵛⴹ ⵏⵓⵍⴰ ⵢ ⵎⵏⵜ⵰ ⴾⵍⵔ ⴾⵙⴹⵜ ⵎⵛⵏⴰ ⴼⵔⴶⵏ ⵂⵍⴾ ⵏ⵿ⵜⵗⵙⴰ ⵂⵔⴾⴹ ⵎⵏ ⴶⴹⵍⵏ ⴹⵗ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ⵓⴾ ⵓⵔⴶⵗ ⵛⵏ ⴶⴹⴹ ⵜⴼⵍ⵿ⵜ ⵢⴹⴰ ⵏⵤⵏ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵤⴶⵎⴹⵏ ⵎⵏ ⵔ ⵙ ⵜⵔⴶⵜ ⵏⵀⵏⵓⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵍⴰ ⵏ⵿ⵤⴹⵏ ⵏ⵿ⵗⴼⵓⵏⵓⵏ ⴹⴰ ⴾⵍ ⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⴾⵙⴹⵎ ⵓⵍⴰ ⴼⵍⵙ ⵗⵔ ⵎⵛⵏⴰ ⵜⴶⵔⵎ ⴶⴹⴹ ⵍⵆⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵢⵏ ⴹⵜ ⵢⵜⴹⵏ ⵙ ⵏⴾ ⵜⵍⵏ ⵓⴹⵢ ⵏⴾ ⴹⴰ ⴼⵍⵙ ⴶⵢⵗ ⴹⵜ ⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ⵎⵛⵏ ⵓⴰ ⴹⵏ⵿ⴾⵔⵏ ⴹⵜ ⵢⵜⴹⵏ ⵓⴹⵢ ⵏⴾ ⴹⴰ ⴹ ⵜⵏ⵿ⴾⵔⵗ ⴹⵜ ⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ⴹ ⵓⵔ ⵜⵗⵍⵎ ⵙⴰ ⴹⴶⵗ ⵓⵢⴹⵓ ⵍⵈⵔ ⵙⴹⵏⵜ ⴾⵍⴰ ⴾⵍⴰ ⵓⵔ ⴹⵓⵢⵗ ⵍⵈⵔ ⵎⴶⵔ ⴹⵓⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ⵙⴹⵓ ⵢⴹ ⵤⵏⵎⵤⵔⵢⵗ ⵍⵙ ⴹⵀⵏⵜ ⵤⵏⵎⵤⵔⵢⴰ ⵜⵀⵔⵔ⵿ⵜ ⴹⵏⵏⵜ ⵤⵏⵎⵤⵔⵢⴰ ⴹⵗ ⵜⴹⴶⵍ⵿ⵜ ⴹⵜⵏ⵿ⵜⵜ ⵏⵀⵔⵔⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ⵆⵍⵏ ⴾⵍ ⵗⵢⵓⵏ ⵏⵓⴹⵏ ⵤⵏ⵿ⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ⵢ ⴶⵏ ⵢⵀⵏⵜ ⵎⴹⵗ ⵏⵏⵜ ⵜⵔⴰ ⵜⴶⵔⵜ ⵜⴰ ⴹⴶⴰ ⵓⴹⵢ ⵓⵔ ⵂⵔ ⴹⵜⵛⵜ ⵏⵏⵍⴾⵎⵏ⵰ ⵢ ⴶⵏ ⵢ ⵀⵔⵔⵏⵜ ⵎⴹⵗ ⵜⵀⵔⵔ⵿ⵜⵏⵜ ⵜⵔⴰ ⵜⴶⵔⵜ ⵜⴰ ⴹⴶⴰ ⵓⴹⵢ ⵓⵔ ⵂⵔ ⴹⵜⵛⵜ ⵏⵏⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ⵢ ⵓⵔ ⵏⴹⴾⵍ ⵜⴶⵜⵓⵜⵏⵜ ⴶⵓ ⵎⵜⵔⵏⵜ ⵍⴾⵎⵢ ⵓⴹⵢ ⵓⵔ ⵂⵔ ⴹⵜⵛⵜ ⵏⵏⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴾⵜⵓ ⵔ ⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵓⴹⵢ ⴹ ⴼⵜⵓ ⴹⵗ ⵍⵈⵔⵜ⵰ ⵎⵔⵏ ⵓⴰ ⵆⵀⵍⵏ ⴹ ⵙⴼⵜⵓ ⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⵜⵏⴶⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ⵢ ⴹⵓⵏⴶⵏ ⵙⵈⵍⴾ ⵓⴹⵢ ⵏⴾ ⵙ ⵜⵏⴶⴰ ⵎⵔⵏ ⵢ ⴹⵜⵏⴶⵏ ⵓⴹⵢ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵙ ⵜⵏⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ⵢ ⴶⵏ ⵙⵈⵍⴾ ⵢⵏⵀⵢ ⵏⵎⵛⵏⴰ ⴼⵍ ⵜⵛⵜⵏⵜ ⵏⵀⵢ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵔⵤⵏ ⵓⵏ ⴶⵔⵓ ⵏⵀⵢ⵰ ⵎⵔⵏ ⵢ ⴶⵏ ⵙⵈⵍⴾ ⵢⵍⵗⴹⵍ ⵏⵎⵛⵏⴰ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵍⵗⴹⵍⵏⵜ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵔⵤⵏ ⵓⵏ ⴶⵔⵓ ⵍⵗⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵛⵛⵓⵏ ⵓⵍⴰ ⵀⵍⵓ ⵏⵎⵏ ⵙⵎⴹⵏⵏ ⵢⵢⵏ ⴹⵗ ⵏⵍⴾⵎⵏⵏ ⵓⵏ ⴶⵔⵏⵏ ⵜⵎⴹⵔⵢⵜ ⴼⵍⵙ ⵎⵙ ⵏⵍⴾⵎⵏ ⵓⴹⵢ ⵍⴾⵏ ⵙ ⴹ ⴶⵔⵓ ⵔⵤⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵎⵔ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴼⵍ ⴹⴶ ⵓⵏ ⴹ ⵙⵙⵗⵔⵓ ⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ ⴹⵗ ⵗⵔⵎⵏ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵂⴰ ⴾⵙⵓ ⵙ ⵙⵍⴰ ⵓⴰ ⵜⴶⵓ ⵍⵎⵙⵈ ⵤⵎⵤⵍⴹⵓ ⵙⵔⵙ ⵔⵜ ⴹⵗ ⵜⵍⵎⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ⵢⴹ ⵜⵙⵙ⵿ⵜⵏⵏ ⵏⵏⵙ «ⴾ ⴾⵢ ⵎⵙⵏ ⵓⵙ ⵏⵆⵍ ⵢⴹⵙⵓ ⵎⵗ ⴾ ⴹ ⵏⵆⵍ ⵢⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵆⵍⵜ ⵢⵈⵢⴰ ⵜⵙⵗⵍⵎⵙ ⵓⵙ ⵜⵙⵍⵎ ⴹⵓⴰ ⵜⵂⵏⵢⵎ ⵜⵏⵎⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ⵎⴹⵔⵗⵍ ⵂⵏⵢⵏ ⵏⵀⴹⵏ ⵌⵓⵏ⵿ⴾⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓ ⴾⵜⵔⵓ ⵤⵢⵏ ⵤⴹⴶⵏ ⵎⵤⴶⵏ ⴶⵔⵓⵏ ⵜⵙⵍⵢ ⵏⵎⵜⵏ ⵏⴾⵔⵏ⵿ⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵛⵍⵆⵓⵏ ⴹⵗ ⵙⵍⵏⵜ ⵢⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ⵀⵍⵍ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⴶⵎⴹ ⵤⴶⵤⵏⵜ ⴼⵍⵙ ⵓⵔ ⴶⴰ ⵛⴾ ⴹⵗ ⵓⴰ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ⵙ ⴶⵍⵏ ⵜⵍⵎⵜⵏ ⵏⵢⵈⵢⴰ ⵙⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵎⴶⵔⴹ ⵢ ⵜⵎⵜⵢ ⴹⵗ ⵀⵜⵓ ⵏⵢⵈⵢⴰ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵔⵜ ⵓⵙ ⵜⴾⵎ ⵙⴼ ⵢⵜⵜⵏⵢⵎ⵰ ⵓⴾ ⵜⵍⵏ⵿ⵜ ⵙⵓⵍⵓⵍ ⴹⵓ⵰ ⴾⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ⴹⵗ ⴹⵢ ⵎⴰ ⵎⵙ ⵓⴰ ⵜⴾⵎ ⵢⵜⴹⵜⵏⵢⵎ⵰ ⵓⴾ ⵍⵙ ⵍⵙⵏ ⵜⵀⴹⵆ ⵜⴾⵏⵜ ⵛⵂⵙⵢ⵰ ⴾⵍⴰ⵰ ⵏⵢⵜ ⵤⴰ ⵢⵜⴹⵏ ⵓⵏ ⵆⵏⵏ ⵛⵀⴹⵗ ⵛⵏ ⵂⵙⵢⵏⵏ ⵓⵏ ⴹⵢ ⵏⵏ ⵏⵎⵏⴾⵍⵏ ⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ⴹⵢ ⵤⴰ ⵎⴰ ⵜⴾⵎ ⵢⵜⴹⵜⵏⵢⵎ⵰ ⵓⴾ ⵏⵀⵢ⵰ ⵓⵍⵏ ⵤⵙ ⵏⵀⵢ⵰ ⵎⵔⵏ ⵢⵈⵢⴰ ⴶⵔ ⵜⵛⵜ ⵏⵏⵀⵢ ⴼⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ⴼⵍⵙ ⵢⵈⵢⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⵏⵢ ⵤⴰ ⵏⴾ ⴹⵜⴾ ⵙⴶⵍⵗ ⵏⵎⵤⵍⵏ ⵤⴾⵏⵏ ⵜⵔⵢⵜⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⴹⵂⵓ ⵓⴹⵏ ⴶⵔⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵓⵍⴰ ⵗⵙ ⵓⴰ ⴶⵔⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⴹⴰ ⴶⵔ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ⴹⵀⵤⵏ ⵗⵔ ⴹⵏ ⵓⵏ ⴹⵗ ⵜⴶⵓ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵜⵍⵈⵜⵀⵜ ⵂⵔ ⵂⵔⵓⴰ ⴹⴰ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵎⵆⵙ ⴹⵜⵍⵀⵙ⵿ⵜ ⵜⵙⵂⵜ ⴶⵎⵢⵏ ⴾⵍ ⵛⵔ ⴹⵀⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ⵎⵔⵏ ⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ ⴾⵍ ⴹⵜⵓⵔⵜ ⵎⵍⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵂⵔ ⵤⵎⵏ ⵏⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ⴾⴹ ⵜⵆⵀⵍⵎ ⵓⴰ ⴹⵓⵏⵏⵗ ⴹⵢ ⵓⴹⵢ ⵙⵏⵜ ⵙ ⵢⵈⵢⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵢⵙ ⵓⵙ ⵜⵎⵍ ⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ⵓⴰ ⵙⵍⵏ ⵙⵙⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ⵎⵙ ⵤⵎⵜⵍⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ⵰ ⵍⵏ ⴹⵀⵔⵔⵏ ⵆⵎⵏⵏ ⴹⵗ ⵙⴾ ⵙⵗⵔⵏ ⵢ ⵎⴹⵓⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ⴶⵏⵏⵙⵏ ⵏⵓⵜⵓⵏ ⵜⵏ⵿ⴹ ⵎⵛⵏ ⵓⵔ ⵜⵓⵗⵎ⵰ ⵏⴶⵓⵏ ⵙⴾⵏ ⵏ⵿ⵜⴼⵢⵓⵜ ⵎⵛⵏ ⵓⵔ ⵜⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ⵏⵗⵓⵏ ⴹⵢ ⴼⵍⵙ ⵢⵈⵢⴰ ⵙⴹⵓ ⵓⵔⵎⴹ ⵜⵜⵓ ⵤⴰ ⵓⵔ ⵙⵙⵓ ⵜⵤⵔ ⵏⵏ ⵢⵜⴹⵏ ⵍⵌⵢⵏ ⵜⵤⴹⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ⵎⵔⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵙⴹⵓ ⵜⵜⴰ ⵙⵙⴰ ⵎⵛⵏ ⵏⵏ ⵢⵜⴹⵏ \"ⵏⵓⵜ ⵍⵙ ⵓⵏ ⵏⵎⵓⵍⵢ ⵏ ⵙⵙⵏ ⵙⵎⴹ ⵙⴶⵜ ⵎⵙ ⵎⴹⵢ ⵏⵀⵤⵏ ⵏ⵿ⵜⴾⵙⵏ ⴹⵔⴾ ⵢⵜⴹⵏ⵰\" ⵎⵙⵏⵜ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵎⵔⵏ ⵎⵤⵍⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ ⵙⵜⴹⵏⵏ ⵆⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ⵜⵤⵔ ⵙⵗⵍ ⵗⵢⵙⴰ ⵜⴶⵏⴰ ⵍⵀⵙⵜ ⵢ ⵗⵔⵎⵏ ⵓⵏ ⴹⵗ ⴶⵏⵜ ⵜⵛⵎ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⴹ ⵜⵜⵀⵜ ⵓⵔ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ⵏⴰ «ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵍⵗⵔⵎ ⵏ⵿ⴾⵔⴹⵤⵏ⵰ ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵍⵗⵔⵎ ⵏⵀⵜⵙⵢⴹⴰ⵰ ⴼⵍⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵗⵔⵓⵏ ⴶⵏⵏ ⵏⵔ ⴶⵏⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ ⵓⴹⵢ ⵔⵓ ⵙ ⵆⵏⵏ ⵙⵍⵙⴰ ⵏⵀⵂⵓ ⵆⵎⵏ ⴹⵗ ⵤⴹ ⵎⵙ ⵓⵏ ⵙⵏⴼⵍⵍ ⵏⵙ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵏⵗⵓⵏ ⵍⵗⵤⵀ ⵓⴰ ⵤⴰ ⵜⴶⵎ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹ ⴶⵔ ⵓⴰ ⵤⴶⵏ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵏ⵿ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ⴾⵓⵏⵢ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⵏ ⴾⴼⵔⵏⵂⵎ ⴹⵙ ⴹ ⵜⵎⴹⴾⵍⵎ ⵙⵍⵌⵏⵜ⵰ ⴾⵍⵔ ⵌⵂⵏⵎⴰ ⴹⵗ ⵤⴰ ⵜⵜⵓⴶⵔⵎ ⴼⵍⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵗⵔⵓⵏ ⴶⵏⵏ ⵙ ⵏⵔ ⴶⵏⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵙⴹⵎ ⵓⴹⵢ ⵂⵔ ⵤⵍⴹⴰ ⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵏⵗⵓⵏ ⵍⵗⵤⵀ ⵓⴰ ⵤⴰ ⵜⴶⵎ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹ ⴶⵔ ⵓⴰ ⵤⴶⵏ ⵢⵜⴹⵏ ⵏⴾⵍ ⵏ⵿ⵙⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⴰ «ⴶⵗⴾ ⵜⵎⵍⵏ ⵢⴰ ⵀⴰ ⵎⵍⵢ ⵏ⵿ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⴼⵍ ⵗⵀⵔ ⵓⴰ ⵜⴶⵗ ⵔⵜⵏ ⵓⵏ ⵢ ⵎⵙⵏⵏ ⴹⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ ⵜⵙⵏⴼⵍⵍⵆⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⵍⵢ ⴹⵀⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ⴹ ⴹⵢ ⴹⴰ ⵎⵙⵏ ⴶⵏⵏⴾ ⵢⴰ ⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«ⵔⵜ ⴾⵍ ⴶⵢ ⵀⵏⵏ ⴹⵗ ⴼⵙⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵙⵏⵏ ⵓⴰ ⵎⵙⴰ ⵔ ⵀⴰ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵢ ⵙⵏⵏ ⵓⴰ ⵎⵙ ⵀⴰ ⵔ ⵏⴾ ⵏ ⵀⵔⵔⵏⵜ ⴹⵓⴹⵏ ⵓⵙ ⵔⵗ ⴹⵙ⵿ⵜⵙⵏⴼⵍⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ⴾⵓⵜⴹⵓ ⴾⵜⵏⵓⵏ ⵓⵏ ⴹⵤⵏⵏ ⵓⵢⵏ ⵤⴾ ⴾⵓⵏⴾⴼⴰ ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ⵀⵔⴹⴶⵜⵢ ⵜⵍⴾⵎⵎ ⵢ ⵜⵔⵏⵏ ⵜⵀⵤⵎ ⴼⵍⵢ ⵎⵙⵏⵜ ⴹ ⵏⴾ ⵎⵛⵙ ⵏ⵿ⵜⵍⵎⵜ ⵎⵙⴰ ⵓⵍⵏ ⴹⵗ ⵓⵔ ⵜⵂⴰ ⵤⵤⵓⵔ ⵏⵎⵏ⵰ ⴹⵢ ⴹ ⵤⴰ ⵜⴶⵔⵓⵎ ⵜⵙⵏ⵿ⴼⵓⵜ ⵢ ⵎⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ⴼⵍⵙ ⵍⴾⵎ ⵢ ⵜⵔⵏⵏ ⵙⵏⴼⵍⵢ ⴶⴶⵏⵏ ⴹⵗ ⵢ ⴼⵙⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ⵤⵎⵏⵏ ⴹⴰ ⵤⵍ ⵢⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙⵓⵍ ⵗⵢⵙⴰ ⵛⵓⴶⵙ ⵏⵍⴾⵎⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ⴶⵤ ⴶⵍⴾ ⵏⵜⵍⵀⵏⵜ ⴹⵔⵙⵀⵏ ⵛⵗⵗⵏⵏ ⵜⵜⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ⵙ ⵏⵢⵏ ⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵏⵢ⵰ ⵏⵜⵍⵀⵏⴾ ⵜⴶⵏ ⵔⵜ ⵈⵔⵎⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⴹⵓⴹ ⵙⵗⴰ ⵓⴹ ⵜⴶⵤ ⴶⵍⴾ ⵏ⵿ⵜⴰ ⴹⵎⴹⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ⵓⴾ ⵓⵔⴶⵗ ⴶⵤ ⴶⵏ ⵂⵏ ⵏⵎⵛⵏⴰ ⵜⵛⵏ ⵛⴶⵍⵓⵏ ⵛⵏ ⵎⵙⵏⵏ ⵜⴾⵜⵢ ⵜⵙⴾⵜⵜ ⵢ ⵎⵛⵏⴰ ⵎⵙ ⵓⵏ ⵔⵜ ⴼⵍⵙⵏ ⵈⵔⵎⵏ⵰ ⵛⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⵍⵎⵎⵏ ⵗⵙ ⵙ ⵜⵈⵍⵍ ⵜⵜⵢⵏⵙⵏⵜ⵰ ⵓⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ⵎⵗ ⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵗ ⵜⵓⵔⵜ ⵙ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵍⵎⵎⵏ ⵓⵔ ⵙⴼⵔⵔⵏ ⵛⵔⴹⵏ ⵏⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴹ ⵤⵍ ⵓⴹⵢ ⵛⵆⵍⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵛⵏ ⵓⵔ ⴼⵍⵙⵏ ⵎⵙ ⵓⵏ ⵍⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ⴶⵢⵗⵓⵏ ⵙ ⵓⴰ ⵍⵏ ⴹⴰ ⴶⵔ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ⵏⵔ ⵜⴶⵔⵎ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵓ ⵜⴰ ⵜⵏⵜ \"ⵏⴾ ⵜⵂⵏⵏ⵿ⵜ ⵔⵗ ⵓⵔⴶ ⵜⴾⵜⵢ⵰\" ⵓⴹⵢ ⵓⵔ ⵤⴰ ⵜⵀⵤⵎ ⵙⵛⵔⵗⴰ ⵢⵜⴹⵏ ⵓⵔ ⵓⵔ ⵍⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ⵏⵗⵓⵏ ⴹⵢ ⴼⵍⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵈⴾⵎⵏ ⴼⵍ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴾⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⵗⵔⵎ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ⵂⵏ ⵓⵏ ⵂⵢ ⵍⵙ ⵙ ⵎⵜ ⴼⵙⵏⵜ⵰ ⵏⵏ ⴼⵔⵙⵢⵜⵏ ⵢ ⵗⵢⵙⴰ «ⴾ ⵈⵍⵍ ⵤⵤⵢ ⵏⵓⴹⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ⵔⵜ ⵓⵏ ⵎⵙ ⵜⵏⴶⵎⵢⵜ ⴹⵙⴶⵏ ⴼⵍ ⴹ ⵜⵀⵤⵏ ⵙⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⵤⵍⵏ ⵜⵍⵢ ⵢⴹⴰ ⵎⵔⵏ ⵜⵆⵍ ⵏⵓ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵆⵎ ⵓⵔ ⴹⵗⵙ ⵜⵜⴹⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ⵓⴹⵏ ⵤⴰ ⴶⵔ ⵜⵍⵢ ⵍⵎⵆⵎ ⵓⵍⵏ⵰ ⴹⵗ ⴹⵢ ⵈⵍⵍ ⴶⵢ ⵏ⵿ⵜⵏ⵿ⴼⴰ ⵢⵓⴹⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢⵍⵙ ⵓⴰ «ⵤⵍ ⴼⵙⵏⴾ⵰» ⵤⵍ⵿ⵜⵓ ⵤⵢ ⵍⴰ ⴹⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ⴶⵍⵏ ⴼⵔⵙⵢⵜⵏ ⴹ ⵜⵎⵛⵓⵔⵏ ⴼⵍ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵏ ⵎⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵓⵏ ⴶⵎⴹ ⴹⴶ ⵓⵏ⵰ ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⵜⴶⵜ⵰ ⵤⵤⵢ ⵎⵔⵏⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ⵎⵛⵏ ⵔⵗⵎⵙⵏ ⴼⵍ ⵎⵍ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵓⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ⵔⵜ ⵓⵏ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ⵏ⵿ⵜⴰ ⴹⴰ ⵏⵗⵀⴹⵏ ⵓⴰ ⵙⵏⴼⵔⵏⴰ ⵙⵏ⵿ⵜⴰ ⴾⵏⵗ ⵜⵔⴰ ⵙⴼⵍⵓⵙ ⵎⵏⵏ⵰ ⴼⵍⵙ ⴹⵤⵤⵀ ⵏ⵿ⴼⵙⵏ ⴹⵢ ⵤⴹⴶⵏ ⴹ ⵎⵍ ⵢ ⵜⵎⵜⵓⵏ ⵏⴹⵏⵜ ⴾⵍ ⵛⵔⵗⴰ ⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ⵓⵔ ⵤⵎⵙ⵿ⵜⵏ ⴹⵓⴹⵏ ⵓⵍⵢⵏ ⵤⴰ ⵓⵔ ⴼⵍⵙ ⵤⵙⵗⵔⵜ ⵓⵍⴰ ⵙⵍⵏⵙ ⵢⵜⴹⵏ ⵛⵓⵍ ⴹⵗ ⵜⵔⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ⵓⵔ ⵤⵔⵤⵓ ⵍⵓⴶ ⵏ⵿ⵜⵍⵏ⵿ⵜ ⵍⴶⵓⵏ ⵤⴰ ⵓⵔ ⵤⵏ⵿ⵗⵓ ⴼⵜⵍⴰ ⵜⵀⴾⵜ ⵢ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵍⵎⵗⵏⴰ ⵙ ⵓⵔ ⵤⴶⵓ ⵜⴾⵎⴰ ⵓⵍⵢⵜ ⵢ ⵏⵔⴾⵎ⵰ ⵓⵏ ⴹⵗ ⵤⵜⴶⵓ ⴾⵜ ⵓⵔ ⵙⵀⴹⴹ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ⴶⵏⵜ ⴹⵗⵙ ⵜⵎⵜⵓⵏ ⵏⴹⵏⵜ ⴾⵍ ⵜⵎⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ⵜⵤⵔ ⵎⵓⵢⴹⵓ ⵍⵙ ⵢⵏ ⵙ ⵗⵢⵙⴰ ⵙ ⵎⴹⴹ ⵎⵏⵜ ⵎⵙ ⴹⵗ ⵎⴹⵔⵗⵍ ⴼⵍⵙ ⴶⵙⴼ ⵜⵤⴹⵗⵏ⵰ ⵤⵤⵢ ⵗⵢⵙⴰ ⵍⵙ ⵓⵏ ⵛⵓⵍ ⵙⵓⴹ ⴹⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ⵙⵎⴾⵍⵍ ⵓⵏ ⵓⵍⵏ ⵙ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⴹ ⵜⴶⵏⵓ «ⵎⴰ ⵆⵍ ⴾ ⴶ ⵏⵀⵢ ⴹⵓⴹ ⵓⴰ ⵜⵎⵍⵏ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ⵎⵛⵏ ⵙ ⵙⵍⵏ ⴼⵔⵙⵢⵜⵏ ⵢⵓⵏ ⵏⵏ «ⵍⵙⵏ ⵛⵢⵜⵏ ⵀⵗⵍⵤⵀⵍ ⵓⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵙⴼ ⵜⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ⵎⵛⵏ ⵢⴰ ⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵓⴰ ⵙⵎⴹⵔⵏⵏ ⵏⵙⵏ «ⵜⵗⵎⵔ ⴾⵍ ⵜⵙ ⵎⴶⵔⵏ ⵎⵙⵓⵙ ⴶⵔⵙⵏ ⵜⴹⵢ ⵀⵔⵌⵢ ⵤⴰ ⵜⴶⵓ⵰ ⵓⵔ ⵜⵍⴰ ⵗⵔⵎ ⵓⵍⴰ ⴹⵗ ⵗⵢⵓⵏ ⵙ ⵤⵎⵤⵔⵢⵏ ⵎⵙⵓⵙ ⵆⵎ ⵓⵔ ⵀⵔⵌⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ⵙ ⵎⵙ ⵙ ⵛⵢⵜⵏ ⵙⵜⵗ ⵎⵏⵜ ⵓⴹⵢ ⵎⵏⵜ ⴹⵔ ⵎⴶⵔ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵂⴶ ⵜⵗⵎⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ⵎⵔⵏ ⴾⴹ ⵏⴾ ⵜⵔⵏⴰ ⵏⵀⵗⵍⵤⵀⵍ ⵙ ⵜⴾⵙⵗ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵏⵍⴾⵎⵏⵓⵏ ⵤⴰ ⵎⴰ ⵍⵏ ⵜⵔⵏⴰ ⵜⵙ ⵜⵏ⵿ⵜⴾⵙⵏ⵰ ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵎⵏⵙⵏ ⵙ ⴾⵓⵏ⵿ⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵙ ⵜⴾⵙⵗ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵓⴹⵢ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵙⵓⵏ⵿ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⴶⵤ ⵏⵂⵏ ⵏⵍⵙ ⵏⵎⵆⵔⴹ ⵗⵔⴹ ⵆⴰ ⵏ⵿ⵜⵍⵏⵜ ⵔ ⵙⴹ ⵜⴾⵔⴹ ⵜⵤⵔ⵰ ⴹⴼⵔ ⵙ ⵜⴾⵔⴹ ⵎⵔⵏ ⴹ ⵤⴼⵔⴶ ⵆⴰ ⵏ⵿ⵜⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ⵓⴰ ⴹⵔⵢ ⵓⵔ ⵏⴹⵓ ⵓⴹⵢ ⵤⵏ⵿ⴶⵓⵏⵏ ⵎⵙ ⵓⴰ ⴹⵓⵔⵏⵍⵍ ⴹⵗ ⵙⵛⴹⵓ ⵓⴹⵢ ⵤⵓⵤⵓⵤ ⵜⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«ⵓⵏ ⴹⴰ ⴼⵍ ⴹⵓⵏⵏⵗ ⵆⵍ ⵀⴾⴹ ⵓⵍⴰ ⵍⴼⵓⵈⵛ ⴾⵍ ⴹ ⵜⵓⵙⵔⴼⵏ ⵢⵓⴹⵏ ⵎⵛⵏ ⴾⵙ ⵏ⵿ⵜⵔⵏⴰ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⵤⵜⵓⵙⵔⴼ ⵢⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ⵙ ⴹⵀⵢⴾ ⵓⴹⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴼⵔⴶ ⴹ ⴶⵔⵓ ⵜⵙⵔⴼ⵿ⵜ ⵎⵛⵏ ⵙ ⵀⵢⴾ ⵓⴹⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔⵎⴹ ⵤⴶⵔⵓ ⵜⵙⵔⴼ⵿ⵜ ⴹⵗ ⴹⵏⵜ ⵤⴰ ⵓⵔ ⵜⵜⵤⴶⵔⵓ ⴹⵗ ⵍⵈⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«ⵙ ⵜⵍⵎ ⵛⴾ ⵙⵈⵏ ⴹⵗⵙ ⵜⴶⵔⵓⵎ ⵔⵜⵏ ⵍⵗⵏⵏ ⵙ ⵜⵍⵎ ⵛⴾ ⵓⵔ ⵏⵙⵈⴰ ⴹⵗⵙ ⵜⴶⵔⵓⵎ ⵔⵜⵏ ⵀⵔⵔⵏⵏ⵰ ⴼⵍⵙ ⵔⵜⵏ ⵓⵏ ⵜⵔⵓ ⵛⴾ ⵏ⵿ⵜⵏⵢ ⵙ ⵜⵓⵤⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ⵈⴰ ⵜⵛⵍⵏ ⵛⵏ ⴹⴰ⵰ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵏⵎ ⵍⵗⵏ ⵏ⵿ⵜⴰ ⴾⵓⵏⵢ ⵜⴾⵏⵎ ⵜⵍⵀⵙ⵿ⵜ⵰ ⵓⵔⴶⵗ ⵓⴰ ⴹⴾⵔⵏ ⵓⵍ ⵏⵓⴹⵏ ⵏ⵿ⵜⴰ ⴹⴶⵎⴹⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ⵓⴹⵏ ⵓⴰ ⵍⵗⵏ ⵍⵗ ⵓⴰ ⵂⵏ ⵓⵍⵏⵜ ⴹⵗ ⴹⵜⴾⵙ ⵓⴰ ⵍⵗⵏ ⵎⵛⵏ ⵏⵍⵀⵙ ⵏ⵿ⵜⴰ ⵜⵍⵀⵙ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵓⵍⵏⵜ ⴹⵗ ⴹⵜⴾⵙ ⵓⴰ ⵍⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ⵎⵔⵏ ⵏⴾ ⵏⵗⵓⵏ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵓⴹⵏ ⴾⵍ ⴾⵏ⵿ⴹⵀⴰ ⵀⴹⴹ ⴼⵍ ⵀⵜⵜⵏ ⵏⵀⵏⵏ ⵛⵏ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ⴼⵍⵙ ⵓⵍⵏⴾ ⴾⵢⵜⴶⵤⵏⵏ ⴹⵗ ⵛⵔⵗⴰ ⵎⵔⵏ ⵏ⵿ⵜⵏⵜⵢ ⵂⵔⵓⴰ ⴹⴰ ⴾⵢⵜⵀⵤⵏⵏ ⵙⵛⵔⵗⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ⵏⵏ ⵔⵜ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ «ⵛⵈ ⵏⵔⴰ ⴹⵗⴾ ⴹⵏⵜⵙⴾⵏⴰ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵏⵍⵀⵙ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⵎⵔⵏ ⴶⵎⵢⵏ ⵜⵍⵎⵗⵌⵌⵜ⵰ ⴾⵍⴰ⵰ ⵜⵍⵎⵗⵌⵌⵜ ⵜⴰ ⴹⵙⵏ⵿ⵜⵜⵓⴶⵜ ⵢⴹⴰ ⵗⵙ ⵜⵜⵎⵙⵏ ⵜⵏ ⵏⵀⵢ ⵢⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ⵏ⵿ⵜⴰ ⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴶⴰ ⵢⵏⵙ ⴾⵔⴹ ⵌⵍⵏ ⴹⴾⵔⴹ ⵂⴹⵏ ⴹⵗ ⵜⴹⵙ⵿ⵜ ⵏ⵿ⴾⴼⵢ ⵓⴰ ⵤⵓⵔⵏ ⵎⴾ ⵓⵏ ⴹⵗ ⵙ ⵏⴾ ⴹⴰ ⴶ ⴶⴹⵎ ⴹ ⴶⴰ ⴾⵔⴹ ⴹⵏ ⴶⵔ ⵎⵓⵜⵏ ⵏⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹ ⴹⵏ⵿ⴾⵔⵏ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵏⵏⴼ ⵤⵀⵤⵏ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵢⵛⵔⵗⴰ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵂⴹⵢ ⴶⵏ ⵤⵍ ⵓⴰ ⴹⵙⵏⴶⴰ ⵢⵏⵙ ⵜⵍⵈⵜⵀⵜ ⵎⵍⵙⵏ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵓⴰ ⵍⵏ ⴹⴰ ⵎⵔⴹⴰ ⴶⵔ ⵢⵏⵙ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙ ⵜⵜⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹⵜⵏ⵿ⴾⵔ ⵜⵎⵏⴾⵍ⵿ⵜ ⵜⵙ ⴾⵍⴰ ⵜⵈⴾⵎ ⴼⵍ ⴾⵍ ⵏⴶⵍⴰ ⴶⵏ ⵙⵎ ⵛⵀⴰ ⵜⴶⵢⵜ ⴼⵍ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵜⵤⵀⵤⵜⵏ ⵢⵛⵔⵗⴰ ⴼⵍⵙ ⴹⴹ ⵔⵤ ⵎⴹⵍ ⴹⵜⴶⵎⴹ ⴼⵍ ⴹ ⵜⵙⵙⵎ ⵢⵓⵍ ⵏ⵿ⵜⵍⴰ ⵏⴶⵔⵢ ⵓⴰ ⵜⴶⵓ ⵎⵏⴾⵍ ⵙⵍⵎⵏ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵓⴰ ⵍⵏ ⴹⴰ ⵎⵔⴹⴰ ⴶⵔ ⵏⵀⵢ ⵙⵍⵎⵏ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙⴹⵙ⵿ⵜⵙⵙⵎⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«ⵙ ⴶⵎⴹ ⴶⵙⴼ ⵓⴹⵏ ⵔⵙ ⴶⵙⴼ ⵓⵏ ⴹⴶⵏ ⵆⵔⵏⵏ ⴶⵎⵢ ⴹ ⵎⵍ ⵆⵎ ⵓⵔ ⵜⴶⵔⵓ ");
INSERT INTO ttqt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ⴹ ⵏⵓ ⴹⵗ ⵎⵏⵜ \"ⵏⴾ ⵤⴰ ⴹ ⵆⵍⵗ ⵂⵏⵏ ⵓⴰ ⴹⴶⵎⴹⴰ⵰\" ⵙ ⵜⴹⵆⵍ ⵜⴹⵙⵓ ⵓⵔ ⵜⵓⴶⵤ ⴼⵔⴹ ⵗⵔⴹ ⵎⴾⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ⵜⵤⵔ ⴶⵍⵓ ⴹⵓⴹⵓ ⴹⵙⴰ ⴾⵍⵙⴼ ⵓⵢⴹ ⵜⴶⵔⵏⵏ ⵜⵍⵀⵙ⵿ⵜ ⴶⵤⵏ ⵓⴹⵏ ⵓⵏⴹ ⵤⴹⵗⵏ⵿ⵜⵓ⵰ ⵜⴶⵓ ⵜⵗⵔⴰ ⵏⵓⴹⵏ ⵓⵏ ⵗⵛⴹ ⴶⵔⵏ ⵓⵙ ⴾⵍⴰ ⵜⵜⴶⴰ⵰ ⵓⵏ ⴹⴰ ⵤⴶⵔⵓⵏ ⵏⵍⵀⵙ ⵏⵤⵎⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ⵛⵓⵍ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⴹⵏ ⴹⴰ ⵜⵍⴰ ⵏⵏⵜ ⴹⵏ ⴹⵎⴹⵔⵢⵏⵜ⵰ ⵀⴹⴹⵏ ⵙⴹⵢ ⴹⵜ ⵂⵏ ⵔⵏ ⴹⵙⵏⵏ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ⵏⴰ ⵓⴹⵏ ⵢⵏ ⵢ ⵗⵢⵙⴰ «ⵏⵢ ⵏⵏⴾ ⴹⵎⴹⵔⵢⵏⴾ ⵀⴹⴹⵏⴾ ⴹⵜ ⵂⵏ ⵔⵏ ⴹⴾⵏⵏ ⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴰ ⵎⵙⵏ ⵏⵏⵏ⵰ ⵎⴰ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ⵜⵤⵔ ⵤⵍ ⵗⵢⵙⴰ ⴼⵙⵏ ⴹⵏⴶ ⵏⵜⵍⵀⵏⵜ ⵏⴰ «ⵏⵢⵜ ⵏⵏⵏ ⴹⵎⴹⵔⵢⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ⴹ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵎⵤⵍⵏ ⵜⵔⴰ ⵏⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ ⵎⴹⵗ ⵜⵎⴹⵔⵢⵜⵏ ⵎⴹⵗ ⵏⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ⵤⵍ ⵓⵏ ⴶⵎⴹ ⵗⵢⵙⴰ ⵂⵏ ⴶⵍⴰ ⵆⵎ ⴹⵗ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ⵜⴹⵓⴹⵓ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵂⵔ ⵙ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵆⵎ ⴹⵗⵙ ⵜⵀⴹⴹ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⴹⵗ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ⵎⴶⵔⴹⵙⵏ ⴹⵗ ⵔⵜⵏ ⴶⵜⵏⵏ ⵙⵍⵎⵜⵍⵏ⵰ ⵏⵙⵏ «ⴾⵍⴰ ⴹ ⴾⴰ ⵎⴶⵢⴾ ⵢⵏ ⵜⵓⴶⵙ⵿ⵜⵏⵜ ⵢⵜⵜⵏⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ⴹⵗ ⵏⵀⵍ ⵓⴰ ⵜⴶⵓ ⴹⵏ ⵎⵙⵏ ⵏⵀⵙ ⵏⵎⵙⴰ ⵔ⵿ⵜⴾⵏⵜ ⵜⵀⵍⵍⵏ ⵛⵢⴹ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵙⵏ⵿ⴹⵓ ⴶⴹⴹ ⵜⵛⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⴹⴶ ⵂⵏⵜ ⵜⵂⵏ ⵎⵔⵏ ⵓⵔ ⵜⵂⴰ ⵎⴹⵍ ⴶⴹⵏ⵰ ⴹⵓⵍⴹⵓ ⵎⵙⴰ ⵓⵏ ⵜⵔⵎⴹ ⴼⵍⵙ ⵓⵔ ⴹⵓⵙ ⵍⴰ ⵎⴹⵍ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ⵙ ⵜⴶⵤⵢ ⵜⴼⴾ ⵜⵙⵆⴹ ⵓⴰ ⴹⴹⵓⵍⵏ ⴹⵗ ⵎⵙⴰ ⵓⵏ⵰ ⵆⵔ ⴼⵍⵙ ⴾⵓⵏⵜ ⵓⵔ ⵏⴶⴶ ⴹⵗ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ⵛⵀⵍⵍⵏ ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⵜⴼⵙⵗ⵰ ⴹⵓⵍⵏⵜ ⵜⴼⵙⵗ ⵛⵏ ⵍⵎⵤⵏⵜ ⵎⵙⴰ ⵓⴰ ⴹⴹⵓⵍⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ⵎⵛⵏ ⵢⴰ ⵔⵜ ⴹⵗ ⵜⵀⵍⵍⵏⵏ ⵔ⵿ⵜⴾ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ⵰ ⴶⵎⴹⵓ ⴹⵓⵍ ⴶⴰ ⵛⵗⵗⵏⵏ⵰ ⵛⵀⵍⵍⵏ ⵛⵏ ⴹⵏ ⴾⵢⵜ ⵜⵔⵓ ⵜⵎⴹⵢ ⵏ⵿ⵜⵀⵍⵍ⵿ⵜ ⵛⵢⴹ ⵙⴹⵙⵜ ⵜⵎⵔⵓⵏ ⵛⵢⴹ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ⵓⴰ ⵙⵍⵏ ⵙⵙⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ⴹⴼⵔ ⵓⵏ ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⵎⴼⵍ ⵜⵜⵎⴶⵔⴹⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵎⵜⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵜⴶⵗⵙⵏ ⵍⵎⵜⵍⵏ ⵓⵏ ⴹ ⴾⵓⵏⵢ ⵜⴶⵔⵓⵎ ⵎⵙⵏⵜ ⴹⵗ ⵙⵔⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵓⵔ ⵜⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ⴼⵍⵙ ⵓⴰ ⵍⵏ ⴹⵙⵜⵓⵛⵜⵓ ⵓⴰ ⵍⴰ ⵏⴼⵍⵢ⵰ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵎⵔⵏ ⵔⵜ ⵏⵓⴰ ⵍⴰ ⴹⴰ ⴹⵗⵙ ⵜⵔⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ⵓⵏ ⴹⴰ ⴼⵍ ⴹⵙⵏ⵿ⵜⵎⴶⵔⴹⴰ ⵙⵍⵎⵜⵍⵏ ⴹ ⵙⵓⴹⵏ ⵎⵛⵏ ⵓⵔ ⵂⵏⵢⵏ ⵙⵙⵎⵏ ⵎⵛⵏ ⵓⵔ ⵙⵍⵏ ⵤⴰ ⵓⵔ ⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ⵏ⵿ⵜⵏⵢ ⴼⵍ ⵜⵏ⵿ⴹⴰ ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵏⵀⵢ ⵙⵢⵙ ⵙⵗⴰ ⵓⴹ ⵏⴰ \"ⴹ ⵜⴾⵏⵎ ⵙⵙⵎ ⵎⵛⵏ ⵓⵔ ⵤⴰ ⵜⴶⵔⵎ ⵓⵍⴰ⵰ ⵜⴾⵏⵎ ⵙⵓⴹ ⵎⵛⵏ ⵓⵔ ⵤⴰ ⵜⵏⵢⵎ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ⴼⵍⵙ ⵓⵍⵏ ⵏ⵿ⵜⵎⵜⵢ ⵜⴰ ⵀⵙ ⵍⵏ ⵜⴼⵔⵢⵜ ⵏ⵿ⴶⵎ ⴶⵔⵏ⵰ ⴶⵏ ⵎⵏⵙⵏ ⵎⵤⴶⵏ ⵛⵜⵓⵏⵙⵏ ⴹⵗ ⵗⵎⵙⵏ⵿ⵜⵏⵜ ⴼⵍ ⴹ ⵀⵙ ⵂⵏⵢⵏ ⵙ ⵛⵜⵓⵏⵙⵏ ⵀⵙ ⵙⵍⵏ ⵙ ⵜⵎⵤⴶⵏⵙⵏ ⵀⵙ ⴶⵔⵏ ⵙ ⵓⵍⵏⵙⵏ⵰ ⴶⵢⵏ ⵙ ⵜⵜⵀⵜ ⵏ⵿ⴶⵎ ⵤⵤⵢⵆⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⵀⵍⵍⵎ ⴹ ⵛⵜⵓⵏⵓⵏ ⵂⵏⵢⵏⵜ ⵜⵀⵍⵍⵎ ⴹ ⵛⵎⵤⴶⵏⵓⵏ ⵙⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙⴹⵔⵏⵏ ⵏⵀⵜⵏ ⴶⵜⵏⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ ⴶⵜⵏⵏ ⵏⵢ ⵏⵓⴰ ⵜⵂⵏⵢⵎ ⵎⵛⵏ ⵓⵔ ⵜⵏⵢⵏ ⵙⴹⵔⵏⵏ ⴹⵗ ⵜⵙⵍⵢ ⵢⵓⵙ ⵜⵙⵍⵎ ⵎⵛⵏ ⵓⵔ ⴹⵙⵙⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⵙⵙⵎⵜ ⵢⵍⵎⵗⵏⴰ ⵏⵍⵎⵜⵍ ⵓⵏ ⵏⵀⵍ ⵏⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⴹⵏ ⵓⴰ ⵙⵍⵏ ⵢ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵔ ⵜⵏⴶⵔⴰ ⵙⴹⵓ ⵀⵍⵙ ⴾⵙ ⵓⴰ ⵜⵓⵏⵀⵍⵏ ⴹⵗ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵎⴹⵍ ⵂⵏⵜ ⵜⵂⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⴹⵏ ⵓⴰ ⵙⵍⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵆⵀⵍ⵿ⵜⵓ ⴹⵢ ⴹⴰ ⵙ ⵎⵏ ⴼⵍⵓⵙⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ⵎⵛⵏ ⵓⵔ ⵍⴰ ⵓⵏ ⴾⵢ⵰ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵎⵙ ⵔ ⵎⵛⵙ ⵏ⵿ⵜⵎⵤⵢⵏ⵰ ⴶⴹⴰ ⵗⵙ ⵜⵜⵎⵍ ⵜⵙⵙ⵿ⵜ ⵎⴹⵗ ⵜⴹⴶⵤⵜ ⵜⴶⵜ ⴼⵍ ⴹⵍⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⴹ ⵢⵓ ⵤⴶⵤⵏ ⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵜⴼⵙⵗ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⴹⵏ ⵓⴰ ⵙⵍⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵎⵛⵏ ⵛⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴹⴹⴾⵍ ⵓⴰ ⵜⴶⴰ ⵜⴶⵔⴶⵙ⵿ⵜ ⵏⴹⵏⵜ ⵜⵢⵜⵢⵏⵜ ⵙⴼⵍⵏ⵿ⴹⵓ ⴹⵏⴶ ⵓⵍ ⵓⵏ ⴶⴹⵍⵙ ⵓⵏ ⴹⵓⵢ ⵜⵏ⵿ⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ⵎⵙⴰ ⵎⵔⵏ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⴹⵏ ⵓⴰ ⵙⵍⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⴶⵔⵢ⵰ ⵓⴹⵏ ⵓⴹⵢ ⴹⵓⵢ ⵜⵏ⵿ⴼⴰ ⵜⵎⵙⵜ ⵜⵎⴹⵢ ⵏⵏⵜⴼⵙ ⵢⵜ ⵜⵆⵍ ⵙⴹⵙⵜ ⵜⵎⵔⵓⵏ ⵢⵜ ⵎⵔⵏ ⵜⵆⵍ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ⴶⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⵍⵎⵜⵍ ⵢⵏ⵰ ⵏⴰ «ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵍⵙ ⵏⵀⵍⵏ ⵎⵙⴰ ⵍⵗⵏ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ⵙ ⵏ⵿ⵙⵏ ⵢⵜⴹⵏ ⵙⴹⵓ ⵤⵏ⵿ⴶⵓⵏⵜ ⵏⵀⵙ ⵔⴾ ⵎⵙⴰ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⵌⵓⵏ⵿ⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ⵙ ⵜⴹⵓⵍ ⵜⵓⴶⵙ⵿ⵜ ⵜⴶⴰ ⵛⵗⵗⵏⵏ ⵏⴼⵍⵍⴹⵓ ⵏ⵿ⵜⴰ ⴹⴰ ⵔⴾ ⵎⵙⴰ ⵓⵏⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ⵙⵏ⵿ⴹⵓ ⴾⵍⵏ ⵏⵍⵙ ⵓⴰ ⵍⵏ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⵏⵏⵙ \"ⵎⵛⴾⵏⴰ ⵓⵔⴶⵗ ⵎⵙⴰ ⵓⴰ ⵍⵗⵏ ⵜⵏⵀⵍⴰ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜⵏⴾ⵰ ⵏⵙ ⵤⴰ ⵜⵗⵔⴰ ⵏⵔⴾ ⵢⵍ ⵓⴰ ⴹⵗⵙ ⴹⴹⵓⵍⵏ ⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ⵏⵙⵏ ⵍⵙ ⵓⵏ \"ⴹⵢ ⵤⵏ⵿ⴶⵓⵏⵏ ⵢⵏ ⵜⴶⵏ⵰\" ⵏⵏⵙ ⴾⵍⵏ \"ⵎⵆⵍ ⵜⵔⵗ ⴹ ⵏⴶⵍⵓ ⵏⵗⵔⴹⵓ ⵍⵀⵢ ⵏⵢⵍ ⵓⴰ ⵓⵔ ⵏⵍⵗⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ⵏⵙⵏ \"ⴾⵍⴰ⵰ ⴼⵍⵙ ⵜⴾⵙⴹⴰ ⴶⵗ ⵜⵜⵏⴾⴹⵎ ⵂⵔ ⵎⵔⵙⵍ ⵍⴾⵎⴰ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ⵢⵓⵜⵏ ⴹ ⴹⵓⵍⵏ ⴾⵍ ⵂⵔ ⴹⵜⵓⴹ ⵗⵔⵜ⵰ ⵙ ⵏ⵿ⵜⴰ ⵎⵍⵢ ⵏ⵿ⵜⵓⴶⵙ ⴹ ⵏⵗ ⵢ ⵎⵛⵗⵍⵏ ⵓⵏ ⵜⵍⵢⵏⵏ ⴹ ⵤⵔⵏ ⵙⵔⴾ ⵢⵍ ⵓⴰ ⵂⵔ ⵜⵗⵔⴹⵏ ⵜⵓⵗⵏⵢ ⵆⵍ ⵛⵀⵍⵙⵏ ⵜⵓⵙⵆⴹ ⵍⴾⵎⴰ ⵎⵔⵏ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵜⴹⵏ⵿ⴶⵓⵜⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ⴶⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵜⵍ ⵢⵏ ⵏⵙⵏ «ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵍⴰ ⴹⵎⵙⴰ ⵏⵏⵀⵜ ⴶⵏ ⵙⵎ ⵎⵜⵔⴹ ⵏⵀⵍ ⵓⴹⵏ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ⵎⵙⴰ ⵓⵏ ⵎⵜⵔⴹ ⵏ⵿ⵜⴰ ⴶⵔⵏ ⵎⵙⵏ ⴾⵍ ⵜⵎⴹⵔⵢⵜ⵰ ⵎⵛⵏ ⵙ ⴹⵓⵍ ⴹ ⴶⵔ ⵏⵀⵜⵏ ⴾⵍ ⵓⵏ ⴼⵔⴶⵏ ⵆⵍ ⵛⴾ ⵂⵔ ⵙ ⴹⵙⵏ ⴶⴹⴹ ⴹ ⵜⴶⵏ ⵛⵙⵍⵍⴰ ⴹⵗ ⵤⵍⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ⴶⵙⵏ ⵍⵎⵜⵍ ⵢⵏ ⵏⵙⵏ «ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵍⴰ ⴹⵈⵎⵔⴰ ⵜⵔⵓⵢ ⵜⵏ⵿ⵜⵜ ⴹⵗ ⴾⵔⴹⵜ ⵏⴼⵗⵜⵏ ⵏⴶⵍ ⵏⵍⴾⵎⴰ ⵂⵔ ⴾⴼ ⴶⵍ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ⵔⵜⵏ ⵓⵏ ⴹⵏ ⴾⵍ ⴶⵏⵏ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⵙⵍⵎⵜⵍⵏ⵰ ⵓⵔ ⴹⵙⵏⵏⴰ ⵔⵜ ⵓⵍⵢⵏ ⵓⵔ ⵏⵎⵙ ⵍⵎⵜⵍ ");
INSERT INTO ttqt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵏⵎⵛⵏⴰ ⵓⴰ ⵎⵍ ⵏⵀⵢ ⵙⵗⴰ ⵓⴹ ⵏⴰ «ⴹ ⵔⵗ ⵎⵏⵏ ⵛⵓⵍⴰ ⵙⵍⵎⵜⵍⵏ ⵎⵍⵗ ⵔⵜⵏ ⵓⵏ ⵗⵀⵔⵏⵏ ⵂⵔⵓⴰ ⵗⵔ ⵏⵜⵢ ⵏⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ⴹⴼⵔ ⵓⵏ ⴼⵍ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⴶⵍⴰ ⴾⴰ ⵂⵏ⵰ ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⵙⵙⴶⵔⵏⵗ ⵍⵎⵜⵍ ⵓⵏ ⵔⴾ ⵢⵍ ⵓⴰ ⴹⴹⵓⵍⵏ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ⵏⵙⵏ «ⵓⴰ ⵏⵀⵍⵏ ⵎⵙⴰ ⵓⴰ ⵍⵗⵏ ⴹⵢ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ⵜⵓⴶⵙ⵿ⵜ ⴹⵢ ⴹⵏⵜ ⵎⵙⴰ ⵓⴰ ⵍⵗⵏ ⵎⵔⵏ ⵎⵜⵍ ⵢⵜⴹⵏ ⵓⵏ ⵀⵔⴹⴶⵏⵏ ⵢ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵔⴾ ⵢⵍ ⵎⵜⵍ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵜⵔⵢⵜ ⵜⵏ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ⵤⵏ⵿ⴶⵓ ⵓⴰ ⵏⵀⵍⵏ ⵔⴾ ⵎⵙⴰ ⴹⵢ ⵀⵍⵙ ⵗⵔⵜ ⵎⵔⵏ ⴹⵢ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵍⵢⵏⵏ ⴹⵢ ⵏ⵿ⴶⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ⵏ⵿ⵜⴰ ⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴹⵜⵓⵏ⵿ⴾⴹ ⵔⴾ ⵢⵍ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵜⵓⵙⵆⴹ ⵎⴾ ⵓⴹⵢ ⴹⵗ ⵤⵜⵓⴶⵏ ⵤⵍ ⵓⴰ ⵜⵀⴹⵢ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ⴹⵙⴶⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵏ⵿ⴶⵍⵙⵏⵏ ⵤⴾⵙⵏⵏ ⴹⵗ ⵜⵗⵎⵔⵏ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵜⴾⵙⵏⵏ ⵤⴶⵤⵏ ⴹⵗ ⵢⵜⴹⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵏⵎⵤⵔⵢ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ⵜⵤⵔ ⴶⵔⵏ⵿ⵜⵏ ⴹⵗ ⵎⵂⵏ⵿ⴹⵔ ⵏ⵿ⵜⵎ⵿ⵙⵢ ⴹ ⵂⵍⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ⴹⵢ ⴹⵗ ⴹ ⵤⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ ⵎⵍⵓⵍⵓ ⵓⵏ ⵜⴼⴾ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵙⵏ⵰ ⵢ ⵙⵍⵏ ⵙⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵍⴰ ⵂⵔⵓⴰ ⴹⴰ ⴹⵔⵤⵗ ⵗⵀⵔⵏ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵙⴼⴶⵢ ⴹⵓⴹⵏ ⵢⵏ ⵍⵙ⵿ⵜⵓ ⵗⵀⵔ⵰ ⵓⴰ ⴶⴰ ⴹⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⴶⵍⴰ ⵤⵏ⵿ⵤⵏ ⵓⴰ ⵍⴰ ⴾⵍ ⵤⵏ⵿ⵤⴰ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵍⴰ ⵂⵔⵓⴰ ⴹⴰ ⴹⵎⵙⵜⴶ ⴶⵎⵢⵏ ⵍⵌⵂⵔ ⵓⴰ ⵂⵙⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ⵙ ⴶⵔⵓ ⵍⵌⵂⵔ ⵢⵏ ⵂⵙⵢⵏ ⵓⵏ ⵍⵙⵍ ⴶⵍⴰ ⵤⵏ⵿ⵤⵏ ⵓⴰ ⵍⴰ ⴾⵍ ⵤⵏ⵿ⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵍⴰ ⵂⵔⵓⴰ ⴹⴰ ⴹⵙⵏ⵿ⴶⵢ ⵤⵓⵔⵏ ⵏⵀⵤ ⵏ⵿ⴾⴼⵜⵏ ⵜⵓⴶⵔⵏ ⴹⵗ ⴶⵔⵓ ⵀⵤⴹⵓ ⴾⴼⵜⵏ ⵎⵙⵏⵏ ⵤⵏⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ⵙ ⴹⵏⵢ ⵔⴾⵀⵏ⵿ⵜⴹⵓ ⵏⵀⵤⵏ ⵏ⵿ⴾⴼⵜⵏ ⵙ ⵜⴶⴹⵎⵢⵜ ⵆⵎⵏ ⴹⴾⵍⵏ⵿ⴹⵓ ⵤⵎⵎⵏ ⴹⵗⵙⵏ ⵜⴶⵏ ⴾⴼⵜⵏ ⵓⵏ ⵍⵗⵏⵏ ⴶⵔⵏⵏ ⵓⵏ ⵓⵔ ⵏⵏ⵿ⴼⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ⵓⵏ ⴹⵗ ⵤⴶⵏ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ⵰ ⴹⵙⵏ ⵏ⵿ⴶⵍⵙⵏ ⵙⴾⵜⵏⵏ ⵏⵎⵤⵔⵢ ⵏⵎⵛⵏⴰ ⵤⵎⵤⵢⵏ⵿ⵜⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ⴶⵔⵏ⵿ⵜⵏ ⴹⵗ ⵎⵂⵏ⵿ⴹⵔ ⵏ⵿ⵜⵎ⵿ⵙⵢ ⴹ ⵂⵍⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⴾ ⵜⴶⵔⵎ ⵓⴰ ⵏ ⴹⴰ ⴾⵍ⵰» ⵏⵏⵙ «ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ⵜⵤⵔ ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⵎⵙⵏ ⵏⵜⵓⵔⵜ ⴾⵍ ⵓⴰ ⵜⵓⵙⵙⵗⵔⵏ ⵢⴹ ⵆⵍ ⵏⵍⴾⵎ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵍⴰ ⴹⵎⵛⵙ ⵏⵗⵢⵓⵏ ⴹⵜⴾⵙⵏ ⴹⵗ ⵜⵍⵏⵜ ⵔⵜⵏ ⵓⵏ ⵢⵏⵢⵏⵏ ⴹⵓⵏ ⵓⵛⵔⵏⵏ ⵙⵜⵗⵎⵍ⵿ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵙⵙⵗⵔⵢ ⵓⴰ ⴶⵏ ⵙⵍⵎⵜⵍⵏ ⵏ ⴶⵎⴹ ⴾⵍ ⵓⴰ ⵂⵤⵏ ⴶⵔⵓ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ⵙ ⴹⵙⴰ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ ⴹ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⴹⵗ ⵂⵏⵙⵏ ⵓⵏ ⵍⵗⵀⴹⴰ⵰ ⵓⴰ ⵙⵔⵙⵏ ⴶⴰ ⵓⵏ ⴹⵗ ⵙⵎⴾⵍⵍ ⵂⵔ ⵆⵎⵏ ⴶⵏⵏ «ⵎⵏⵙ ⵜⴹⵜⴶⵤ ⵎⵙⵏⵜ ⵜⴶⴹⵜ ⴹⵓⴰ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵜⴶⵓ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","«ⴾ ⵓⴰ ⵓⵔⴶⵗ ⴶ ⵍⵙ ⵓⴰ ⴾⵔⵙⵏ ⵏⵏ⵰ ⵓⵔⴶⵗ ⵏⵏⵜ ⵙⵎⵏⵜ ⵎⵔⵢⵎⴰ ⵎⴹⵔⵢⵏⵜ ⵢⵏ ⵢⵆⵀ ⵢⵏ ⵢⵙⴼ ⵢⵏ ⵙⵎⵗⵏ ⵢⵏ ⵢⵂⵤⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ⵓⵔⴶⵗ ⵛⵎⴹⵔⵢⵏⵜ ⴾⵍ ⵍⵏⵜ ⵗⵔⵏⴰ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵢ ⴶⵤ ⵓⴰ ⴹⵙⴹⴶⵏ ⵔⵜⵏ ⵓⵏ ⴹⴰ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ⵓⵏ ⴹⵗ ⴹⵙⵏⴶⴹⵍⵏ ⵤⴶⵤⵏ ⵙⵔⵙ⵰ ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵀⵢ ⵓⵔ ⵜⵓⵍⴾⵓ ⵔ ⴹⵗ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ ⴹⵗⵢⵓⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ⵎⵔⵏ ⵆⵎ ⴹⴰ ⵓⵔ ⴶⴰ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴶⵜⵏⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⴼⵍⵙ ⵤⴶⵤⵏ ⵙⵔⵙ ⵓⵔ ⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ⵤⵎⵏⵏ ⴹⴰ ⴹⵗ ⵙⵍⴰ ⵂⵔⴹ ⵏ⵿ⵜⴼⵙ ⵓⵏ ⵎⵤⵔ ⵏⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ⵜⵤⵔ ⵏⴰ ⵂⵔⴹ ⵢⵢⵜⴹⵏⵜ «ⴰ ⴶⵏ ⴹⴰ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵓⵏ ⴹⴰ ⴼⵍ ⵍⴰ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ⵔⵜ ⵓⵏ ⵏⵢ ⵂⵔⴹ ⴼⵍⵙ ⵤⵎⵏ ⴹⵜ ⵓⵏ ⵎⵔ ⵙⵜⵔⵎⵙ ⵏⵢⵈⵢⴰ ⵜⵓⴾⵔⴹ ⵜⵓⴶⴰ ⴹⵗ ⴾⵙⵓ ⴼⵍ ⴹⵍⵍ ⵏⵂⵔⴹⵢⵙ ⵜⵎⵙⵜ ⵜⵗⵔ ⴼⵍⵀⵙ ⵎⵙⵏ ⵎⴹⵔⵢ ⵏⵂⵔⴹ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ⴼⵍⵙ ⵢⵈⵢⴰ ⴶⵏⵏ ⵢ ⵂⵔⴹ «ⵈⵔⵎ ⴼⵍⴾ ⵤⵍⴼ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ⵓⵢⴹⵓ ⵓⵏ ⵙ ⵂⵔⴹ ⵙ ⵔⴰ ⴾⵙ ⵏⵎⵏ ⵏⵢⵈⵢⴰ ⵎⵛⵏ ⴾⵙⴹ ⵜⵎⵜⵢ ⵜⴶⵜ ⵢ ⵢⵈⵢⴰ ⴹⴼ ⵏⵙ ⵏⵀⵢ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ⵙ ⴹⵗⵍⵢ ⵤⵍ ⵓⵏ ⵜⵂⵓⵜ ⵏⵂⵔⴹ ⵙⵙⴶⴰ ⵙⴾⵙⵙ ⵜⴶⴰ ⵍⵙ ⵏⵂⵔⴹⵢⵙ ⵓⵗ ⴾⵏⵏ ⵛⵂⵙⵢ ⴹⵜ ⵏⴼ⵿ⵜⵗⵏ⵰ ⵜⵤⵔ ⴶⵎ⵿ⵜⵜ ⵂⵔⴹ ");
INSERT INTO ttqt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ⵂⵔ ⵙ ⵂⴹⵙ ⵙ ⴹⵙⴶⵓ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗⵙ ⵜⴶⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ⵙ ⵜⵛⵓⵔ ⵏⵏⵜ ⵜⵏⵙ ⴹ ⵜⵏⵓ ⵢ ⵂⵔⴹ ⵗⴼ ⵏⵢⵈⵢⴰ ⵜⵔⴰ⵰ ⵜⵏ⵿ⴾⵔ ⵜⵀⵔⵔ⵿ⵜ ⵜⵏⵢ ⵂⵔⴹ «ⴾⴼⵢ ⵜⵀⵍⴰ ⴹⴰ ⴹⴰ ⵂⴰ ⵗⴼ ⵏⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ⵔⵜ ⵓⴰ ⵜⴶⵎⵢ ⵜⵀⵔⵔ⵿ⵜ ⵜⵏ ⵓⵢⴹⵓ ⵙⵎⵏⴾⵍ ⵂⵔⴹ ⵙ ⵗⵛⴹⵏ ⵎⵏⵜ⵰ ⵎⵛⵏ ⵎⵔ ⵙⴹⵙⵜⵓⴶⵓ ⵔⵜ ⵓⴰ ⵜⴶⵎⵢ ⴹⵏ ⴼⵍ ⴹⵍⵍ ⵏ ⵜⵂⴹⵢ ⵜⴰ ⴹⵙⴶⴰ ⴹⴹⵍⵍ ⵏ ⵏⴼ⵿ⵜⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ⵙⴶⵍⴰ ⵓⴹⵏ ⵢⴹⴼⵔⵙ ⵗⴼ ⵏⵢⵈⵢⴰ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ⵎⵓⵢⴹⵓ ⵗⴼ ⵏⵏⵀⵏ ⴹⵗ ⵜⵀⵍⴰ ⵜⵓⴾⴼⴰ ⵢ ⵜⵀⵔⵔ⵿ⵜ ⵜⵤⵔ ⵜⴾⴼⵢ ⵢⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ⵙⵏ⵿ⴹⵓ ⵏⵍⴾⵎⵏ ⵏⵢⵈⵢⴰ ⴹⴾⵍⵏ ⵜⵗⵙⵏⵜ ⵏⵀⵍⵏ⵿ⵜⵜⵏ⵰ ⴶⵍⵏ ⵎⵍⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵙⵍⵏ ⵓⵏ ⴶⵎⴹ ⴹⴶ ⵓⵏ ⵂⴰ ⵗⵍⵍ ⵏⵎⵏ⵰ ⴶⵍⴰ ⵗⵙⵏⵜ ⴾⴰ ⴹⴶ ⵙⴼⵏ ⴹⵏⴾⵜⵢⵏ⵰ ⵜⵙⵍⴰ ⵜⵎⵜⵢ ⵜⴰ ⵜⵂⵜ ⵛⵗⵔⵎⵜⵏ ⵛⵏ ⵗⵍⵢⵗⵍⵢⵏ ⵓⵏ ⵜⵍⴾⵎⵙ ⴹⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ⵙ ⴹⵤⵀⵜ ⵗⵍⵍ ⵏⵢ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⴶⵤⵜⵓ ⵜⵂⵏⵏ⵿ⵜⵏⵜ ⴹ ⵤⵤⵢ ⵎⵔⵏⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ⵙ ⵜⴶⴰ ⵜⴾⵙ⵿ⵜ ⵂⵤⵏ⵿ⵜⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⴹⴶ ⵙⴼⵏ ⵓⴰ ⵎⵔⵏ ⵤⵍ ⴶⵍⴰ ⴹⵗ ⴹⵢ ⵙⵗⵍ ⵜⵎⵜⵢ ⴰ ⴹ ⵜⴶⵎⵢ ⴹ ⵜⵤⵏ⵿ⵤⴰ ⵜⵜⵛⴰ ⴹⵗ ⵜⵗⵔⵎⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔ ⵜⴶⴰ ⴹⵔⵔⵜ ⵙⴹ ⴶⵍⵏ ⵛⵜⵛⵜⵏ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ⵏⵏⵙ «ⵏⴾⵏⵢ ⵢⴰ ⵓⵔ ⵏⵍⴰ ⴹⴰ ⵔ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⴹⵛⵏ ⴾⴼⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵢⵜⵜⵏ⵿ⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ⵎⵔ ⵜⵎⵜⵢ ⵙⴹ ⵜⵆⵎ ⴹⵗ ⵢⵍ ⵍⵏ ⴹⵏ ⵜⵤⵔ ⴹⴾⵍ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⴹⵛⵏ ⴾⴼⵜⵏ ⵓⵏ ⴶⵤⵢ ⵌⵏⵓⵏ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ⵰ ⴾⵔⵎⴾⵔⵎ ⵛⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⴾⴼⵏⵜ ⵢ ⵏⵜⵍⵀ ⵜⵏⵜⵤⵏⵏ ⵢ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ⵜⵛⵏ ⵢⵜⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵂⵔ ⵢⵓⵏⵏ⵰ ⵛⴹⵓⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⵜⵓⴶⵍⵤⵏⵏ ⴹⵏⵢⵏ ⵎⵔⵓ ⵤⵎⵎⵏ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ⵢⵜⴹⵏ ⵓⵏ ⵜⵛⵏⵏ ⴹⵏ ⵎⵙⵏ ⴹⴶ ⵏ⵿ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ ⵍⵏⵜ ⴹⵗ ⵜⴹⴹⵏ ⴹⵏ ⴹⵀⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ⵓⵍⴰ ⵂⴶⵏ ⵎⵔ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵙⴹ ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ ⵤⵔⵏⵙⵏ ⵙ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ ⴾⵜ ⴹⵢ ⴹ ⵜⵙⵍⵎ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ⵙ ⵗⵔⴹⵏ ⵢⵜⴹⵏ ⵜⴾⵍⵢ ⴶⵤⵢ ⵗⵢⵙⴰ ⴹⵗⵗ ⵢⴹ ⴶⵓ ⵛⵓⵜⵔⵓⵏ ⴹⵗ ⴹⴶ ⴾⵜⵢⵏ⵰ ⵍⴰ ⴹⵏ ⴹⴰ ⵗⵙⵏⵜ ⵂⵔ ⴶⴰ ⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ⵙ ⵜⴶⵓ ⵓⵏ ⴹⴰ ⵗⵍⵍ ⴶⴶⵏ ⴹⵗ ⴶⵔⵓ ⵀⵜⵏⵜⵓ ⵜⵏⵤⵎⵔⵏ ⵙⴰ ⴹⵙⴰ ⴼⵍⵙ ⴹⵓ ⵙⵂⵏ ⴹⵔ ⵎⵆⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ⵙ ⵜⴶⴰ ⵜⵍⴾⵎⵜ ⵏⵂⴹ ⴾⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵌⵓⵏ⵿ⴾⵜ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ⵙ ⵜⴶⵏ ⵌⵓⵏ⵿ⴾⵜⴹⵓ ⴼⵍ ⵎⵏ ⵔⵎⵗⵏ⵰ ⵏⵏ «ⵓⵏ ⴶⵙⴼ⵰» ⵙⴾⵔⵢⵏ ⴼⵍ ⵓⴰ ⴶⵏ ⴹⵗ ⵜⵔⵎⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ⵎⵛⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵙⵏⵛⵓⵍ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵗⵛⴹⵎ ⵏⴾ ⵓⴰ⵰ ⵜⴶⵎⴹⵜⴾⵓⵏ ⵜⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ⴹⵏ ⴹⵗ ⴹⵙⵏⴰ ⵀⵜⵔⵙ «ⴾⴹ ⴾⵢ ⴹⵢ ⵎⵍⵢ ⵜⵎⵔⵗⵢ ⵙⴹⵏ⵿ⵌⵓⵏ⵿ⴾⵗ ⴼⵍ ⵎⵏ ⵙⵍⴾⴹⵗⴾⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","«ⵢⵓ⵰» ⵏⵙ ⵗⵢⵙⴰ⵰ ⵤⵀⵜ ⵀⵜⵔⵙ ⵗⵍⵍ ⵌⵓⵏ⵿ⴾⵜ ⴼⵍ ⵎⵏ ⵏⵎⴹ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ⵎⵛⵏ ⵙ ⴹⵏⴶⵔⴰ ⵙⵂⵜ ⵏⴹⵓ ⵓⴰ ⴶⵔⵏ ⴹⵏ ⵜⴶⵤⵜⵓ ⵜⵙⴰ ⴶⵤⵏ⵿ⵜⵓ ⵎⵏ ⵛⵏ ⵍⵎⵤ⵰ ⵙⵗⵔⵜ ⵏⴰ «ⵎⵍⵢ ⴶⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ⵜⵔⵎⴹ ⵙ ⴹⵙⵏⵤⵍ ⵗⵢⵙⴰ ⴼⵙⵏⵜ ⵀⵤⵜⴹⵓ⵰ ⵏⵙ ⵗⵢⵙⴰ «ⵤⴶⵤⵏⴾ ⵔⴾⵎ ⵓⵍⵏ ⵎⴰ ⴹⵗⴾ ⴶⵏ ⵛⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ⴶⵤⵏ ⵗⵍⵍ ⵗⵙ ⴹⵔⵔ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ⵙⵌⴹⵏⵙ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵗⵍⵍ ⵏ ⴶⵏⵏ «ⵍⴾⵏ ⵙ ⴾⵢ ⵎⵙⵏ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ⵙ ⵗⵔⵙⵏ ⴶⵔⵓ ⵓⴹⵏ ⴾⵍ ⵏ⵿ⴶⵏⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ⵙ ⵙⵏⵏ ⴾⵍ ⴾⵍⵏ ⵙ ⵗⵢⵙⴰ ⵓⵏ ⵎⵍⵏ ⵢⵢⵜⴹⵏ ⵏ⵿ⴾⵍⵏ ⵓⵏ ⵗⵍⵢⵗⵍⵢⵏ ⵏⴹⴶ ⵓⵏ ⵙⵔⵙ ⴹⵜⵎⵓⵢⵏ ⵎⵔⵏⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ⴹ ⵜⵓⵏ⵿ⵙⵢ ⴹ ⵢⵓ ⵢⵜⴹⵏ ⴹⵙⵏ ⴾⴹⵗ ⵜⵀⵏⴾ ⵏ⵿ⵜⴾⴹⴾⵜⵏⵜ ⵎⵔⵏ ⵢ ⵜⵜⴹⵙⵏ ⴹ ⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ⴹⴼⵔ ⵓⵏ ⴼⵍⵏ⵿ⴹⵓ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵢⵔⵙⵍⵎ ⴾⵏ ⵗⵢⵙⴰ ⵏⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ⵎⴼⵍ ⵓⵔ ⵍⴾⵎⵏ ⵏⵜⵍⵀⵏⴾ ⵢⵍⵗⴹⵜⵏ ⵛⵏ ⴹⵏⴹⵢⵏ ⵎⵔⵓⵏⵏⴰ ⵓⵔ ⵛⵔⴹⵏ ⴼⵙⵏⵙⵏ ⴹⵜ ⵜⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵤⴰ ⵎⴼⵍ ⵜⵜⵎⵤⵔⵢⵎ ⵍⵓⵌⵀⵏ ⵏⵎⵛⵏⴰ ⴼⵍ ⵍⴾⵎ ⵢⵍⵗⴹⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ⵓⵔⴶ ⵎⵛⵏⴰ ⵏⴰ \"ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ\"⵰ ⵏⴰ ⴹⵗ \"ⵓⴹⵏ ⵓⴰ ⵛⴼⵔⵛⵏ ⵀⵏⵜ ⵎⴹⵗ ⵏⵏⵜ ⵓⴹⵢ ⴹⵗⵙ ⵜⵓⴾⵙⵏ ⵎⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ⵎⵛⵏ ⴾⵓⵏⵢ ⵜⴶⵏⵎ ⵢⵢⵜⴹⵏ ⵙ ⵏⴰ ⵓⴹⵏ ⵢⵀⵏⵜ ⵎⴹⵗ ⵏⵏⵜ \"ⵔⵜ ⵓⴰ ⴾⵢⵤⴾⴼⵗ ⵎⵙ ⵜⴹⵂⵍ⵿ⵜⵏⴾ ⵙⵏ⵿ⵙⵆⵓ ⵢⴹ ⵜⴶⴰ ⵜⴾⵜⵢ\" ");
INSERT INTO ttqt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ⴹⵢ ⵀⵙ ⵂⵛⵍ ⵢⵓⴹⵏ ⵓⴹⵢ ⵙⵗⵎⵔ ⵏⵀⵏⵜ ⵓⵍⴰ ⵏⵏⵜ⵰ ⵎⴾ ⴹⵢ ⴹⴰ ⵙ ⵜⴶⵎ ⵍⵗⴹⵜⵏⵓⵏ ⴹⵗ ⴹⴶ ⵏⵓⵍ ⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ⵍⵎⵏⴼⵆⵏ⵰ ⵜⴹⵜ ⵎⵙ ⵓⵍ ⵓⴰ ⴶⴰ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵏⵓⵏ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"ⵜⵎⵜⵢ ⵜⴰ ⵍⵙ ⵗⵙ ⵙ ⴹⵜⵙⵗⵎⵔ ⵎⵛⵏ ⵓⵍⵏⵙⵏ ⴶⴶⵏⵢ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ⵍⵗⵀⴹⴰ ⵓⴰ ⴹⵜⴶⵏ ⵀⵏⵏ ⴼⵍⵙ ⵓⵔ ⵙⵙⵗⵔⵏ ⵔ ⵍⵓⵌⵀⵏ ⴹⵏ⵿ⵤⵎⵏ ⵢⵜⴹⵏ ⴹⵗ ⵗⴼⵓⵏⵙⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ⵗⵔⴰ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⵏⵙ «ⵙⵙⵎⵜⵢ ⵜⴶⵔⵎ ⵓⴰ ⴹⵓⵏ⵿ⵤⵏⴰ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ⵓⵔⴶⵗ ⵓⴰ ⵜⴶⵤⵏ ⵙⵎⵢ ⵏⴶⴹⵎ ⵜⵙⵎⴹⵙⵏ ⴾⵍⵔ ⵓⴰ ⴹⴶⵎⴹⵏ ⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ⴹⴼⵔ ⵓⵏ ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⴾ ⵜⴶⵔⵗⵏ ⵙ ⵀⵜⵜⵏⴾ ⵛⴾⵏ⵿ⵜⵏⵜ ⴼⵔⵙⵢⵜⵏ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵀⵜ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵀⵍ ⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ ⵓⴹⵢ ⴹⵜⵓⵍⵀⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ⵢⵜⵏ ⵗⵙ⵰ ⵓⵏ ⵎⴹⵔⵗⵍ ⵍⵓⵢⵏⵏ ⵓⵢⴹ⵰ ⵎⴹⵔⵗⵍ ⵍⵓⵢⵏ ⵢⵏ ⵎⵔⵏ ⴶⴹⵍ ⵜⴶⵏ ⴾⵜⵏⵙⵏ ⴹⵗ ⵏⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ⵛⵓⵍ ⵀⵜⵔⵙ ⵏⵙ «ⵙⵙⴶⵔⵏⵗ ⵍⵎⵜⵍ ⵓⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ⵏⴰ ⵗⵢⵙⴰ «ⵓⴾ ⴾⵓⵏⵢ ⴹⴰ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⵍⵎ ⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ⵓⴾ ⵓⵔ ⵜⴶⵔⵎ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⴶⵤⵏ ⵙⵎⵢ ⵏⴶⴹⵎ ⴾⵢ ⵤⴶⵓ ⵙ ⵜⴹⵙ⵿ⵜ ⴹⴼⵔ ⴹⵢ ⵏ⵿ⵗⵍⵏ ⴹⵗ ⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ⵎⵛⵏ ⵓⴰ ⴹⴶⵎⴹⵏ ⵎⵢ ⵓⴹⵢ ⵓⵍ ⴹⴼⵍ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵙⵎⴹⵙⵏ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ⵙⵏⵜ ⵙ ⵓⵍ ⵏ⵿ⵜⴰ ⴹⴶⵎⴹⵏⵜ ⵔⴾ ⵏⵢⵜⵏ ⴹⴶⵢ ⵏⵎⵏ ⴹⴶⵢ ⵏⵤⵏⴰ ⴹⴶⵢ ⵏ⵿ⵜⴹⴹⵏ ⵎⴹⵗ ⴶⵢ ⵏⵎⴹⵏ ⴹⵛⴾⵔⴰ ⴹⵜⴶⵢⴰ ⵏⵀⵂⵓ ⴹⵛⵤⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵏ⵿ⵜⵏⵢ ⵙⵎⴹⵙⵏⵏ ⴶⴹⵎ⵰ ⵎⵛⵏ ⵜⵜⵢ ⵙ ⴼⵙⵏ ⵓⵔ ⵏⵔⴹ ⵓⵔ ⵜⵙⵎⴹⵙ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ⵙ ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴾⴰ ⵎⴹⵍ ⵏ⵿ⵜⵔ ⴹⵙⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ⵜⵂⵏⵏ ⵜⵏ⵿ⵜⵜ ⵏⵢⵜ ⴹⵗ ⴾⵏⵏⵜⵜⵏ ⵜⵤⴹⵗⵜ ⴾⵍⵏ ⴹⴰ ⵜⴾⴹⵓ ⵗⵢⵙⴰ ⵜⵙⴾⵔⵢ ⵜⴶⵏⵙ «ⵢⴰ ⵎⵍⵢ ⴶ ⵎⵏⴾⵍ ⴹⵓⴹ ⵂⵏⵜⵜⵢ⵰ ⵜⵀⵔⵔ⵿ⵜⵏ ⵤⴹⵗ ⴶⵙⴼ ⵜⵜⵤⵗⵤⵀⵏ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ⵎⵛⵏ ⵓⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵏ⵿ⵜⵜⵏ ⵓⵍⴰ⵰ ⴹⴶⵤ ⵓⵏ ⵏⵜⵍⵀ ⵂⵤⵏ⵿ⵜⵏ ⵏ⵿ⵙⵢⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵙⵗⵍ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⴹⵏⵜⵍⴾⵎⵜ ⴹⴰ ⵜⵙⴾⵔⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ⵏⴰ ⵗⵢⵙⴰ «ⵏⴾ ⵓⵔ ⴹⵜⵓⵤⵎⵤⵍⵗ ⵔ ⵙ ⴾⵍⵙⵔⵢⵍ ⵎⵙⵏⵏ ⵤⵏ ⵢⴼⴹ ⵙⴶⵍⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴾⵢⴹⵓ ⵜⵏ⵿ⵜⵜ ⵏ ⵜⵙⵌⴹⵙ ⵜⵏⵙ «ⵎⵍⵢ ⵙⵏ ⴹⵗⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ⵏⴰ ⵗⵢⵙⴰ «ⵓⵔ ⵍⵗ ⵢ ⴹⴾⵍⵏ ⵎⵏ⵿ⵙⵢ ⵏⵀⵔⵔⵏ ⴶⵔ⵿ⵜⵏ ⵢ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ⵜⵏⵙ ⵜⵏ⵿ⵜⵜ ⵏ «ⵜⴹⵜⵏⴾ ⵎⵍⵢ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴹⵏ ⴾⵎⵢ ⵜⴶⵏ ⵓⴰ ⴹⵔⵜⴾⵏ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵜⵏ ⵎⵙⵓⵙⵏ ⵜⵜⵏ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ⵏⵙ ⵗⵢⵙⴰ «ⵢⴰ ⵜⵏ⵿ⵜⵜ⵰ ⵤⴶⵤⵏⵎ ⵢ ⵤⵓⵔⵏ⵰ ⵜⵓⴶⵜⵎ ⵓⴰ ⵜⵔⵗ⵰» ⵎⵤⵢⵏ ⴹⴰ ⴹⵗ ⵜⵤⵢ ⵍⵙ ⵏ⵿ⵜⵏ⵿ⵜⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ⴹⴼⵔ ⵓⵏ ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴾⴰ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⵜⵤⵔ ⵓⵔ ⴹⵗⵗ ⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ⵜⴾⵢⴹⵓ ⵜⵎⵜⵢ ⵜⴶⵜ ⵙⵔⵙ ⴹⵜⵓⵢⵜ ⵎⴶⴹⵍ ⴹⵎⴹⵔⵗⵍ ⴹⵏⵀⴹⵏ ⴹⵢⵜⴹⵏ ⵙ ⵎⴹⴹⵏ ⵎⵓⵏⵙⵏ ⴹⵎⵔⵏⵏ ⵓⵢⴹ ⴶⵜⵏⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵏ⵿ⵙⵏ ⴹⵜ ⵗⵢⵙⴰ ⵤⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ⵙⵎⴾⵍⵍ ⵙ ⵜⵎⵜⵢ ⵏⵢ ⵓⴰ ⵜⴶⴰ ⵢⵜⴹⵏ ⵙ ⵎⴹⴹⵏ ⵎⵓⵏⵙⵏ ⵛⵓⵍⵏ ⵜⵏⵢ ⵏⵀⴹⵏ ⴶⵔⵓⵏ ⵛⵗⵔⴹⵏⵙⵏ ⵜⵏⵢ ⵎⴶⴹⵍ ⵌⵓⵏ⵿ⴾⵏ ⵙⵍⵗ ⵜⵏⵢ ⵎⴹⵔⵗⵍ ⵂⵏⵢⵏ⵰ ⴹ ⵜⴶⵏ ⵢⵜⴹⵏ ⵜⵎⵍⵏ ⵢⵎⵍⵢ ⵏⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵜⵂⵢ ⵜⵂⵏⵏ⵿ⵜ ⵏ⵿ⵜⵎⵜⵢ ⴰ⵰ ⴾⵔⴹ ⴹⵏ ⵗⵔⵢ ⴶⵏ ⵎⵔⵏ ⵀⵙ ⵜⵍⴰ ⵜⵛⵏ⵰ ⵓⵔ ⵔⵗ ⵜⵏⵢⴰ ⴶⵍⵏ ⵓⵔ ⵔⵎⵏ ⵔⵜ ⴼⵍⵙ ⴹⵢ ⵎⵌⵙ ⵜⵏⴶⴹⵍⵓ ⴶⵍⴾ ⴹⵗ ⵜⵔⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵎⵏⵢ ⴹⵤⵏⴶⵔⵓ ⵤⴰ ⴹⵗ ⵙⴼ ⵛⴶⵍⵓⵏ ⵙⵢⵓⵏⵏ ⵜⵎⵜⵢ ⵜⴶⴹⵜ ⴹⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵏⴾⵜ ⵜⴶⵍⵓⵏ ⵜⵍⵎ⵰» ⵏⵏⵙ «ⵙⵢⵜ ⵜⴶⵍⵓⵏ ⵏⵍⴰ ⴹⵔⵜ ⵏ⵿ⴾⴼⵜⵏ ⵓⵏ ⵎⴹⵔⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ⵎⵔ ⵜⵎⵜⵢ ⵙⴹ ⵜⵗⵔⴹ ⵜⵗⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ⴹⴾⵍⴹⵓ ⵙⵢⵜ ⵜⴶⵍⵓⵏⵏ ⴹⴾⴼⵜⵏ ⵓⵏ ⴹⵏ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵎⵔⵏ ⴾⵔⵎⴾⵔⵎ⵿ⵜⵏ ⴾⴼⵏ ⵢ ⵏⵜⵍⵀ ⵤⵏⵏ⵿ⵜⵏ ⵢ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ⵢⵜⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵢⵓⵏⵏ ⴶⵍⵤⵏ⵿ⴹⵓ ⵂⵔ ⵙ ⵙⴰ ⵤⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵜⵓⵜⴾⵔⵏⵏ ⴹⵗ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⴶⵍⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ⵢⵜⴹⵏ ⵓⵏ ⵜⵛⵏⵏ ⴹⵏ ⵎⵙⵏ ⴾⵤ ⴶⵎ ⵏⵍⵙ ⵙ ⵓⵔ ⵂⵏⵜ ⵜⴹⴹⵏ ⴹⵀⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ⴹⴼⵔ ⵓⵏ ⵙⵍⵎ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴾⴰ ⴾⵍ ⵏⵎⴶⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ⴾⵏ⵿ⴹⵓ ⴼⵔⵙⵢⵜⵏ ⴹⵙⴹⵙⵢⵜⵏ ⵗⵢⵙⴰ ⵔⵏ ⴹ ⵜⵌⵔⵀⵏ ⴶⵎⵢⵏ ⴹⵗⵙ ⴹⵙⵏⴶⵓ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ⵏⵙⵏ «ⵙ ⴶⴰ ⵍⵎⵤ ⵜⵏⵢⵎ ⵌⵏⵓⵏ ⵤⴶⵗⵏ ⴹ ⵜⵏⵎ \"ⵜⴼⵜ ⵤⴰ ⴹ ⴶⵓ ⵤⵍ ⵂⵙⵢⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ⵙ ⴼⵓ ⵎⵔⵏ ⵜⵏⵢⵎ ⵌⵏⵓⵏ ⵤⴶⵗⵏ ⵂⵏⵜⵏ ⵛⵢⵢ ⴹ ⵜⵏⵎ \"ⵤⵍⴹⴰ ⴹ ⴶⵓ ⵤⵍ ⵀⵔⵔⵏ⵰\" ⵙ ⵜⵙⵓⴹⵎ ⴹⵗ ⵌⵏⵓⵏ ⴹ ⵜⵙⵏⵎ ⵓⴰ ⴹⵔ ⵤⵍⵓ ⵍⵂⵓⴰ ⴹⴼⵔ ⵓⵏ ⵎⵛⵏ ⵓⴰ ⵜⴶⵏ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵓⵔ ⵜⵙⵏⵎ ⵍⵎⵗⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵏⵍⵀⵙ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⵎⵔⵏ ⴶⵎⵢⵏ ⵜⵍⵎⵗⵌⵌⵜ⵰ ⴾⵍⴰ⵰ ⵜⵍⵎⵗⵌⵌⵜ ⵜⴰ ⴹⵙⵏ⵿ⵜⵜⵓⴶⵜ ⵢⴹⴰ ⵗⵙ ⵜⵜⵎⵙⵏ ⵜⵏ ⵏⵀⵢ ⵢⵏⵙ⵰» ⴹⵏ ⴹⴰ ⵜⵏⴼⵍ ⵗⵢⵙⴰ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ⴾⵏ ⵏⵜⵍⵀ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ⵰ ⵙ ⵓⴹⵏ ⴶⵔⵏⵏ ⵙ ⵜⵓⵏⵏ ⴶⵢ ⵏⵍⵓ ⵏ⵿ⵜⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏ⵿ⴾⴹⵜ ⵓⵍⵏ ⵢ ⵈⵎⵔⴰ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴹ ⵓⵏ ⵙⴹⵙⵢⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ⵜⵤⵔ ⴹ ⴶⵏⵏ ⵏⵜⵍⵀ ⴶⵔⵙⵏ «ⵓⴰ ⵓⵔ ⵜⵏⴰ ⵔ ⴼⵍⵙ ⵓⵔ ⵏⵓⵢ ⵜⴶⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵓⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵛⵓⵍⵎ ⴶⵔⵓⵏ ⴼⵍⵙ ⵓⵔ ⵜⵍⵎ ⵜⴶⵍⴰ ⴾⵍ ⵤⴶⵤⵏ ⵏ⵿ⴹⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ⵓⴾ ⴶⵔⵢ ⵓⵔ ⵜⴶⵎ ⵂⵔⵓⴰ ⴹⴰ⵰ ⵓⵔ ⵜⴾⵜⵓⵎ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⵜⵛⵏ ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ ⴹⴾⵜ ⵏⵤⵎⵎⵏ ⵓⵏ ⴹⵜⴹⵏⵢⵎ ⴹⵗ ⴶⵍⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ⵎⵗ ⴾ ⵜⵜⵓⵎⵏ ⵙⵢⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⵛⵜⵛⵏⵏ ⴾⵤ ⴶⵎ ⵏⵍⵙ⵰ ⵎⵏⴾⵜ ⵤⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵜⴹⵏⵢⵎ ⵤⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ⵏⴾ ⴹⵓⵏⵏⵗ \"ⵏ⵿ⴾⴹⵜ ⵢ ⵈⵎⵔⴰ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴹ ⵓⵏ ⵙⴹⵙⵢⵜⵏ\"⵰ ⵎⵏⵎⴾ ⵙ ⵓⵔ ⵜⴶⵔⵎ ⵙ ⵓⵔⴶⵗ ⵜⴶⵍⴰ ⵙ ⴹⵓⵏⵂⵗ ⵀⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ⴹⵏ ⴹⵗ ⴹ ⴶⵔⵏ ⵙ ⵓⵔⴶⵗ ⵈⵎⵔⴰ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴹ ⵓⵏ ⵙⴹⵙⵢⵜⵏ ⴼⵍ ⴹⵙⵏⵎⴶⵔⴹ ⴹⵏ ⴾⵍⵔ ⵙⵙⵗⵔⵏⵙⵏ ⵙ ⴹⵙⵏⵏⴰ ⴹⵙⵏ⵿ⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ⴾⴰ ⵗⵢⵙⴰ ⵎⴹⵍ ⵏⵆⵢⵙⵔⵢⴰ ⵓⵏ ⵎⵤⵔ ⴼⵍⵀⵙ ⵙ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⴾ ⴹⵗ ⴹⴼ ⵏⵢⵜⴹⵏ ⵎⴰ ⵎⵙⴰ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ⵏⵏⵙ «ⵓⵢⴹ ⵤⴰ ⴶⵏⵏ ⴾⵢ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰ ⵓⵢⴹ ⴶⵏⵏ ⴾⵢ ⵏⵀⵢ ⵍⵢⵙ⵰ ⵓⵢⴹ ⵎⵔⵏ ⴶⵏⵏ ⴾⵢ ⵏⵀⵢ ⵔⵎⵢⴰ ⵜⵎⵙⴰ ⵎⴹⵗ ⵢⵏ ⴹⵗ ⵏⵀⵜⵏ ⵓⵏ ⵂⴹⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵤⴰ ⵎⴰ ⵜⵏⵎ ⵎⴰ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵍⵎⵙⵈ ⵜⵎⵙⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵗⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵜⵀⵍⵍⴰ ⵢⴰ ⵙⵎⵗⵏ ⴶ ⵢⵏⵙ ⴼⵍⵙ ⵔⵜ ⵓⴹⵢ ⵓⵔⴶⵗ ⴾⵢ ⴹⵗⵙ ⵙⵙⵏⵏ ⵎⵏⴾ ⴾⵍⵔ ⵀⵏⵏ ⴹⵢ ⵂⵏ ⵌⵏⵓⵏ ⴹⴾⵙⵏⴼⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ⵏⴾ ⵎⵔⵏ ⵏⵗⴾ ⴾⵢ ⵀⵜⵔⵙ ⵜⵂⵏ⵿ⵜ ⵜⵎⵙⴰ ⵎⵔⵏ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⵤⴾⵔⵙⵗ ⵍⴾⵏⵙⵜⵏ⵰ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵔⵏⴰ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴹⴰ ⵓⵔ ⵜⴼⵔⴶ ⴹⵙ⵿ⵜⵗⵛⴹ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ⴾⵢⴾⴼⴰ ⵜⵙⵙⵔⵜ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵙⵈⵔⵎⴰ ⴹⵗ ⴹⵏⵜ ⴹⴹⴰ ⵌⵏⵓⵏ ⴹⴰ ⴹⵗⵙⵏ ⵈⵔⵎ ⵔⵜ ⴹⵗ ⵓⴰ ⵜⵙⵈⵍⵍⴰ ⴹⵗ ⴹⵏⵜ ⴹⴹⴰ ⵌⵏⵓⵏ ⴹⴰ ⴹⵗⵙⵏ ⵈⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ⵜⵤⵔ ⴶⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵎⵔ ⴹⵗ ⴹⴶⵤ ⵙⴹ ⵓⵔ ⵎⵍⵏ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ⵀⵤⵏ ⵗⵔ ⵤⵍ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⴶⵤ ⵗⵢⵙⴰ ⵛⵏ ⵙⵙⴶⵔⵢ ⵏⵜⵍⵀⵏⵜ ⵙ ⵓⵔ⵿ⵜⵓ ⴾⵢ ⵏⵢⵔⵙⵍⵎ ⵢⴹ ⴶⵓ ⵍⵗⵤⵀ ⴶⵏ ⴹⵙⵤⴶⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵜⵓⴶⵏ ⵎⵏⵜ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ⵜⵤⵔ ⵓⵜⵓ ⵀⵜⵔⵙ ⵙⵂⵍ ⵛⵓⵍ ⴼⵍⵙ ⵏⵙ «ⵎⵍⵢ ⵂⵏⵜⵜⵜⴾ ⵎⵛⵏⴰ ⴹⵗ ⵔⵜ ⵓⴰ ⵜⵎⵍⵗ ⴹⵢ⵰ ⴾⵍⴰ ⵓⵔ ⴾⵢⵤⴶⵔⵓ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ⵎⵛⵏ ⵎⵍⵍⵢⵏ ⵗⵢⵙⴰ ⵀⵜⵔⵙ ⵏⵙ «ⴼⵍ ⴹⴼⵔⵢ ⵛⵢⵜⵏ⵰ ⵜⵆⵍⵗⵢ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴹⴹⵓⵢⵏ ⵙⴹⵏⵜ ⴼⵍⵙ ⵎⴹⵔⵏⵏⴾ ⵓⵔⴶⵗ ⵎⵛⵏⴰ ⴹⴼⵍⵏ ⴾⵍⵔ ⵎⴹⵔⵏⵏ ⵏⴶⴹⵎ ⵗⵙ ⵎⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵓⴰ ⵔⵏ ⴹⵍⴾⵎ ⵓⴹⵢ ⴶⵎⴹⵜ ⵜⵔⴰ ⵏ ⵎⵏⵜ ⴶⵓ ⵎⵜⵔⵏⵜ ⴹⴾⵍ ⵜⴶⵜⵓⵜⵏⵜ ⵍⴾⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ⵙⵏⵜ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴶⵎⵢ ⵔ ⴶⵤ ⵏⵎⵏⵜ ⵓⴹⵢ ⴹ ⵜⴶⵎⴹⵏ ⵎⵛⵏ ⵓⴰ ⵆⵀⵍⵏ ⴹ ⵜⴶⵎⴹⵏ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⵜⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ⵎⴰ ⵤⴾⵏⵓ ⵢⵓⴹⵏ ⴹ ⴶⵔⵓ ⴹⵏⵜ ⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⵎⵔⵏ ⵜⵎ⵿ⵙⵢ ⴾⴰ⵰ ⵓⴾ ⵎⵙ ⴼⵔⴶ ⵓⴹⵏ ⵜⵂⴾⵢⵏⵜ ⵢⵙⵔⵙ ⴶⵤ ⵎⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ⵙⵏⵜ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵙⴰ ⵍⵗ ⵜⵏⵢⴰ ⵏⵀⵏⵏ ⴹⵓⴰ ⴹⵏ⵿ⴶⵍⵙⵏⵜ ⴹⵢ ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⴹ ⵜⴾⴼⵓ ⵎⵔⵤⵜ ⵏⵓⴰ ⵓⴹⵏ ⵎⵤⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵢⴹ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵀⴹⴹⵏⵏ ⴹⴰ ⵓⵔ ⵜⵏ⵿ⵤⵀⴰ ⴾⵜ ⵓⵔ ⵏⵢⵏ ⵙⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵎⵙⵗ ⵎⵏⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ⵙ ⴶⵏ ⵙⴹⵙ ⴹⵏ ⴹⴼⵔ ⵓⵏ ⴹⵓ ⵗⵢⵙⴰ ⴹⵀⵜⵔⵙ ⴹⵢⵆⵀ ⴹⵢⵈⵢⴰ ⵎⵙⵏ ⵎⴹⵔⵢ ⵏⵢⵆⵀⵏ ⴹⴰ ⴾⴰ ⴹⵔⵙⵏ ⴹⵗⵗ ⵤⴶⵔⵏ ⵗⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ⴹⵏ ⴹⴰ ⴹ ⵎⵜⵢ ⵤⵂⵔⵏⵜ ⴹⵜⵙⵏ ⵎⵍⵓⵍⵓ ⴹⵎⵏⵜ ⵙⵏⵔ ⵍⵏ ⴹ ⵓⵏ ⵜⴼⴾ ⴶⵏ ⵙⵍⵙⵏⵜ ⵜⵎⵍⵢ ⵜⵙⵔⵆⵜ ⵓⵍⵏ ⵜⴾⵏⴰ ⵙⵎⵗⵎⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ⵂⵏⵏⵏ ⴶⵏ ⵏⵀⵢ ⵎⵙⴰ ⴹⵏⵀⵢ ⵍⵢⵙ ⵙ ⴹⵏⴼⵍⵍⵏ ⵎⵛⵓⵍⵏ ⴹⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ⴶⴹⵓ ⵀⵜⵔⵙ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵎⵍⵢ ⵍⵗ ⵙ ⵏⵍⴰ ⴹⴰ⵰ ⴾⴹ ⵜⵔⵗ ⴹⵢ ⴹ ⴾⵔⵙⴰ ⴾⵔⴹ ⵂⴾⵜⵏ ⴹⵗ ⴹⴶ ⵓⴰ⵰ ⵢⵏ ⵏⴾ ⵢⵏ ⵏ ⵎⵙⴰ ⵢⵏ ⵏ ⵍⵢⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵀⵜⵔⵙ ⵙ ⵜⵏ⵿ⵜⵍⵙⴰ ⵜⴶⵔⴾ ⵜⵎⵍⵓⵍⵓⵜ ⵜⵆⵍⵙⵏ ⵤⵏ ⵜⵍⵢ⵰ ⴶⵎⴹ ⵎⵙⵍⵢ ⵜⴶⵔⴾ ⵜⵏ ⵏⴰ «ⵓⴰ ⵀⵔⵔⵏ ⵓⴰ ⴾⵏⵗ ⵜⵔⴰ⵰ ⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴹⵏ ⴶⵏⵏⵏ⵰ ⵙⵙⵎⵜⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ⵙ ⵙⵍⵏ ⵏⵜⵍⵀ ⵢ ⵀⵜⵓ ⵜⵏ ⵔⵎⵗⵏ ⵓⵍⵏ ⴼⵜⵆⵏ ⵙⵌⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ⵂⵤⵜⵏⵏ ⵗⵢⵙⴰ ⴹⵙ⵿ⵜⵏ ⵏⵙⵏ «ⵏ⵿ⴾⵔⵜ ⵜⴶⵎⴹⵜⴾⵓⵏ ⵜⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ⴹⴾⵍⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⵙⵓⴹⵏⵙⵏ ⵓⵔ ⵂⵏⵢⵏ ⵔ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ⵜⵤⵀⵏ⵿ⴹⵓ ⴹⵗⵗⵏ ⴹⴰ ⵙ ⵜⵏⵎⵔ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵎⵍⵎ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵓⴰ ⵜⵏⵢⵎ ⴹⴰ ⴾⵜ ⵓⵔ ⴹⵏ⵿ⴾⵔⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ⵙⵙ⵿ⵜⵏⵏ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴼⵍ ⵤⴰ ⴶⵏⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ \"ⴾⵏ⵿ⴹⵀⴰ ⵙⴹⵓ ⵍⵢⵙ ⵜⵤⵔ ⵙ ⴹⵤⵙⵓ ⵍⵎⵙⵈ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵓⵍⴰ ⵤⴰ ⵔ ⴹⵙⵓ ⵍⵢⵙ ⵏⵤⵎ ⵔⵜⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ⵎⵔⵏ ⵙⵙⵏⵆⵓⵏ ⵙ ⵍⵢⵙ ⵙⴹⵓ ⵎⵛⵏ ⵓⵔ ⵜⵆⵀⵍⵏ ⵢⵜⴹⵏ ⴾⵍⵔ ⴶⵏⵙ ⵓⵙ ⵔⵏ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵍⴾⵏ ⵙ ⴹⵤⵗⵤⵀⵏ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ⴶⵔⵏ ⵏⵜⵍⵀ ⵙ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵙ ⵂⴰ ⵗⵢⵙⴰ ⵀⵜⵏⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ⵙ ⴹⵤⵀⵜ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹⵏ ⴹⵗⵗ ⵂⵤⵏ⵿ⴹⵓ ⵜⵎⵜⵢ ⴾⵢⴹⵓ ⵍⵙ ⵢⵏ ⴶⵔⴼⵜ ⴹⵜⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ⵏⵙ «ⵎⵍⵢ ⵂⵏⵜⵜ ⵢ ⵀⵔⵔⵏ ⵜⵤⴾⵔⴾⵔⵜ ⵜⵜⴶⵔⵓⵜ ⵎⵔⵏ ⵗⵤⵀ ⵓⵍⵏ ⴼⵍⵙ ⴼⵓ ⴹⴰ ⵜⴹⵓ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵎⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ⵓⵢⵆⵓ ⵙ ⵏⵜⵍⵀⵏⴾ ⵢⴹ ⵜⵤⵤⵢⵏ ⵎⵛⵏ ⵏ⵿ⴹⵔⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ⵏⴰ ⵗⵢⵙⴰ «ⵈⴰ⵰ ⴾⵜ ⵀⴰ ⵏⵤⴶⵤⵏ ⴾⵜ ⵛⵔ ⴹⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⴰ⵰ ⵓⴾ ⵂⵔ ⵎⵢ ⴹⵓⴰ ⴹⵔⵓⵏ ⵤⵤⵢⴹⵔⴰ ⴹⵔⵓⵏ⵰ ⵓⵢⵜⴹⵓ ⵀⵔⵔ ⵙⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ⵂⵔⵛⵜ ⵗⵢⵙⴰ ⴶⵙⴼ ⵓⴰ ⵂⵏ ⵀⵔⵔ ⵏ ⵜⵤⵔ ⴶⵎⴹⵜⵓ⵰ ⵤⵢ ⵀⵔⵔ ⴹⵗ ⵎⵤⵢ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ⵂⵤⵏⵏ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴼⵍ ⵏⴾⵏⵢ ⵏ⵿ⴹⵔⵏⵗ ⴾⵙ ⵏⴶⵙⴼ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ⵏⵙⵏ «ⴹⵢ ⵤⴰ ⵛⴹⵜ ⵏⵔⴾⵎ ⵏⵤⴶⵤⵏⵓⵏ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵏⵔ ⵜⵍⵎ ⴹⵗ ⵤⴶⵤⵏ ⴶⴹⵏ ⴹⵓⵍⴰ ⵎⵢ ⵏ⵿ⵜⵤⵗⵢ ⵏⵛⵏⵏ ⵂⵔ ⵜⵏⵎ ⵢⴹⵗⵗ ⵏ \"ⴶⵎⴹ ⴹⴶ ⴹⵢ ⵜⴾⴰ ⵓⵏ\" ⴹ ⵎⵤⵍ ⵙⴹⵢ⵰ ⴹⵢ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵙ ⴹⵓⵏ⵿ⵤⵏ⵿ⴹⵔ ⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ⵎⵔⵏ ⵤⵏⴼ ⵏⴶⵙⴼ ⵓⵏ ⵓⵔ ⴶⵎⴹ ⵓⴹⵏ ⵔ ⵙ ⵜⵓⵜⵔⵓⵏ ⴹⵤⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ⵤⵍ ⵢⵏ ⴹⵓⵏ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵙ ⴹⵙⵏⵏⴰ «ⵏⴾ ⴶ ⴶⴹⵎ ⵌⵓⵔⴰ ⴹ ⴶⵤⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ⴶⵏ ⵎⵏⵏ ⵜⵤⵔ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ⵜⵗⵛⴹ ⵀⵜⵓ ⵜⵏ ⵎⵏⵙⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ⴶⵍⴰ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵂⵔ ⵓⴹⵏ ⴾⴼⵔⵏⵂⵎ⵰ ⵏ⵿ⴾⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵤⵔⵤⵎⵏⵏ ⵎⵏⴰ ⵢⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵂⵤⵏⵏ ⵀⵜⵔⵙ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵓⴾ ⵛⵈⵏⵓⵏ ⵔⵤⵎ ⵓⵔ ⵜⴶⵓ ⵎⵏⴰ ⵢⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ⵏⵙⵏ ⵀⵜⵔⵙ «ⵓⵍⴰ ⵤⴰ ⵔ ⵔⵤⵎ⵿ⵜ»⵰ ⴶⵤ ⵀⵜⵔⵙ ⵂⵏ ⵤⵔⵙ ⵗⵢⵙⴰ ⵓⵍ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ «ⵎⴰ ⵜⵏ ⴾⵢ ⵙⵎⵗⵏ ⵎⴰ ⵔⵤⵎⵏ ⵜⴾⵙⵏ ⴹⵎⵏⴰ ⵢ ⵎⵏⴾⵍⵏ ⵏⴹⵏⵜ⵰ ⵓⴾ ⵎⴹⵏⵙⵏ ⴹⵙⵏ⵿ⵜⵏⵔⵤⵎⵏⵏ ⵎⵗ ⵢⵜⴹⵏ ⵙⴰ ⵂⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ⵏⵙ ⵙⵎⵗⵏ «ⵢⵜⴹⵏ ⵙⴰ ⵂⴹⵏ ⴹⵙⵏ⵿ⵜⵏⵔⵤⵎⵏⵏ⵰» ⵏⵙ ⵗⵢⵙⴰ ⵎⵔⵏ «ⴹⵗ ⴹⵢ ⵎⴹⵏⵙ ⵏⵎⵏⴾⵍⵏ ⵓⵔ ⵜⵏⵓⵔ ⵔⵤⵎ ⵏⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ⵎⵛⵏ ⵢⴰ ⴼⵍ ⴹ ⵓⵔ ⵏⵆⵍ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵤⴶⵤⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵤⵔⵤⵎⵏⵏ ⴶⵍⵓ ⴾⵓ ⴶⵔⵓ ⵜⴶⵔⴰ ⴹⵗⵙ ⵤⵀⵤⵀ ⵓⵏ ⵀⵤ ⵏ⵿ⴾⴼⵜⵏ⵰ ⴾⴼⵢ ⵓⴰ ⵜⵀⵤⵗ ⵙ⵿ⵜⵤⵔⵜ ⵔⵓ ⵎⵏⵜ ⴹⵗⵙ ⵏ⵿ⵜⴶⵤⴰ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ ⵓⴰ ⵎⵍⵏ⵰ ⵜⴼⵍ⵿ⵜ ⵜⵏ ⴾⵙ⵿ⵜⵜⴹⵓ ⵜⴶⵍⴰ ⵜⴾⴼⵗⵙⵏ⵿ⵜⵜ ⴹ ⵜⵆⵍ ⵔⵤⵎⵜⵏ ⵏⵎⵏⴰ ⵓⵏⵏ ⴹⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹⵗ ⴹⵏⵂⵤⵏ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴰ ⵎⵙ ⵤⴰ ⵓⴰ ⴶⵔⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ⵜⵤⵔ ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵔⵜ ⵏⵀⵔⵔ ⵙⵀⴹⴹⵜⵓ ⴶⵔⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ⵏⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙ ⵓⵔ ⵜⵙⵎⵜⵢⵎ ⵍⵈⵍ ⵜⵆⵍⵎ ⵤⵏ ⵀⵔⵔⵏ ⵓⴹⵢ ⵓⵔ ⵍⴾⵎ ⵜⴶⵤⵎ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵔⵙⵏ ⵎⵏⵜ ⵤⵏ ⵔⵜ ⵏⵀⵔⵔ ⵓⴰ ⵓⴹⵢ ⵍⴾⵏ ⵙ ⵏ⵿ⵜⴰ ⴶⵔⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«ⵎⵔⵏ ⵢ ⵆⵀⵍⵏ ⵀⵔⵔ ⵛⵍⵏ ⵓⴰ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⵏⴾ ⵎⵏⵏ ⵙ ⴹⵆⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ⵎⵛⵏ ⵢ ⵆⵍⵏ ⵙⵀⵀ ⵏⵀⴾⴹ ⵢⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵎⵙⵏⵏ ⵤⵏ ⵀⵔⵔⵏ ⵎⴹⵔⵔⵏⵏ ⵓⴹⵢ ⴼⵙ ⴹ ⵜⵓⵆⵏ ⵤⵤⴹ ⵤⵓⵔⵏ ⵏ⵿ⵜⵂⵏ⵿ⵜ ⴹⵗ ⵔⵏⵜ ⵜⵓⴶⵔ ⴹⵗ ⵎⵙ ⵏⴶⵔⵓ ⵎⵤⵍ ⵓⴰ ⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ⴾⵜ ⵍⵗⵤⵀ ⵍⵢ ⵢⵢⵜⴹⵏ ⵏⴹⵏⵜ⵰ ⴹⵍⵍⵏ ⴶⵜⵏⵏ ⵜⵍⵏⵏ ⵜⵏ⵿ⵙⵙⴶⵏⵏ ⵀⴾⴹⵏ⵰ ⵍⴾⵏ ⵙ ⴹ ⵜⵎⵍⵏ ⴹⵍⵍⵏ ⵓⵏ ⴹⵏ ⵂⵔ ⴼⵓ ⵎⵛⵏ ⴾⵜ ⵍⵗⵤⵀ ⵍⵢ ⵢⵓⴹⵏ ⵓⴰ ⴹⵙⵏ⵿ⴹⵆⵍⵏ ⵙⵀⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ⴾⴹ ⴼⵙⵏⴾ ⵎⴹⵗ ⴹⵔⵏⴾ ⴾⵢⵙⵙⴶⵏⵏ ⵀⴾⴹⵏ ⵓⴹⵢ ⴼⵔⵙ⵿ⵜⵏⵏ ⵜⴶⵔⵆⵏⵏ ⵙⴹⵢ⵰ ⴹ ⴼⴾ ⵜⴶⵤⴰ ⵍⵌⵏⵜ ⵜⴶⵗ ⴼⵙ ⵎⴹⵗ ⵜⴶⵗ ⴹⵔ ⵢⴹ ⵜⵍⵗ ⵛⵏ ⴼⵙⵏ ⴹⵛⵏ ⴹⵔⵏ ⵜⵜⵓⴶⵔⴰ ⴹⵔⵙⵏ ⴹⵗ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ⵎⵔⵏ ⴾⴹ ⵛⵜⵏⴾ ⵜⵀⴾⵜ ⴹⴾⵜⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵏⵀⴾⴹ ⵓⴹⵢ ⴾⴾⵔⵜⵜⴹⵓ ⵜⴶⵔⵆⵜⵏ ⵙⴹⵢ ⴹ ⴼⴾ ⴹ ⵜⴶⵗ ⵛⵜ ⴹⵗ ⵍⵌⵏⵜ ⵢⴹ ⵜⵍⵗ ⵙⵏⵜⵜ ⵛⵜⵓⵏ ⵜⵜⵓⴶⵔⴰ ⴹⵔⵙⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵏ ⵌⵂⵏⵎⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«ⵏ⵿ⴾⴹⵜ⵰ ⴹ ⵓⵔ ⵜⵍⴾⵎ ⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵎⴹⵔⵔⵏⵏ ⴹⵢ ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵏ⵿ⴶⵍⵙⵏⵙⵏ ⵂⵏ ⵌⵏⵓⵏ ⴼⵓ ⵍⵏ ⵗⵔ ⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ⵏⴾ ⴶ ⴶⴹⵎ ⵙⵗⴹⵓ ⴶⵎⵢⵗ ⵢⵜⴹⵏ ⵓⵏ ⵈⵔⴾⵏⵏ ⵢⵜⵏⵗⵍⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«ⵎⴰ ⵜⵏⵎ ⴾⵓⵏⵢ ⵢⵓⵏ⵰ ⵓⴾ ⵎⴹⵏ ⵍⵏ ⵜⵎⴹⵢ ⵏ⵿ⵜⵍⵢ ⵂⵔ ⴹⵗⵙⵏⵜ ⵜⵙⴶⵍ ⵢⴹⴰ ⵓⵔⴶⵗ ⴹ ⵢⵓ ⵜⵤⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵜⵤⵢⵜ ⵛⵏ ⵂⴹⵜⵏⵏ ⴹⵏⵜ ⵜⵤⵔ ⵤⵍ ⵙⵓⴹ ⵢ ⵜⴰ ⵜⵙⴶⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙ ⴹⴶⵔⵓ ⵜⵍⵢ ⵜⵏ ⵢⴹⴰ ⵏ ⴶⵔ ⵜⴹⵓⵜ ⵜⴰ ⵤⴶⵓ ⴼⵍ ⴹⵍⵍⵏⵜ ⵢ ⵜⴰ ⵤⴶⵓ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵤⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵜⵤⵢⵜ ⵛⵏ ⵓⵔ ⵏⵙⴶⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ⵎⴾⵏ ⴹⵗ ⵙ ⵀⵏⵓⵏ ⵂⵏ ⵌⵏⵓⵏ ⵓⵔ ⵔⴰ ⴹ ⵂⵍⴾ ⵓⵍⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵎⴹⵔⵔⵏⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⴰ «ⵙ ⴾⵢⴹⵍⵎ ⵎⴹⵔⵢⵏⴾ ⵜⴾⵆⵓ ⴹⵗ ⴹⴶ ⴹⵗ ⵜⵎⵙⵎ ⵗⵙⵏⵓⵏ ⵜⵙⵙⴶⵔⵆⵏ ⵍⵂⵏⵜ⵰ ⴾⴹ ⵤⴰ ⵙⵙⵎⴾ ⵜⵀ ⵓⴹⵢ ⵤⵏ ⵙ ⵎⴹⵔⵢⵏⴾ ⴹⵜⴶⵔⵓⵗ ⴾⵢⴶⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ⵎⵛⵏ ⵙ ⴶⵢ ⵙⴹⴾⵙⵙⵎ ⵜⴹⵓⴰ ⴹⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵎⴹⵗ ⵛⵏ ⵜⵆⵍⵆⵓ⵰ ⵎⴾⵏ ⴹⵗ ⵙ \"ⵀⵜⵓ ⴾⵍ ⴹ ⵜⴾⵏⵓ ⵆⵎⵏⵜⵙ ⵙⵏⵜⵜ ⵜⴶⵢⵓⵏ ⵎⴹⵗ ⴾⵔⴹⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ⵎⵔⵏ ⵙ ⴶⵢ ⵙⴹ ⵍⴾⵎ ⵢⵓⵍ ⵓⴰ ⴹⵙⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵜⵎⵍⵗ ⵍⵎⵙⵍⵜ ⵜⴹⵢ ⵢⵍⴾⵏⵙⵜ⵰ ⵙ ⴶⵢ ⵙⴹ ⵍⴾⵎ ⵢⵓⴰ ⴹⵙ⵿ⵜⵏⴰ ⵍⴾⵏⵙⵜ ⵓⴹⵢ ⴶⵙ ⴹⴼ ⵓⴰ ⵜⴶⵗ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⵎⴹⵗ ⵜⴶⵗⵙ ⴹⴼ ⵓⴰ ⵜⴶⵗ ⵢⵢⵜⴹⵏ ⵓⵏ ⵤⵔⵤⵎⵏⵏ ⵜⴾⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵙⵈⵔⵎⵎ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵓⴹⵢ ⵌⵏⵓⵏ ⴹⴰ ⴹⵗⵙⵏ ⵈⵔⵎ⵰ ⵎⵔⵏ ⵓⴰ ⵜⵙⵈⵍⵍⵎ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵓⴹⵢ ⵌⵏⵓⵏ ⴹⴰ ⴹⵗⵙⵏ ⵈⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ⵙⵍⴾⵏⵗⵓⵏ ⴹⵗ ⵙ ⵙ ⵏⵎⵔⴹⵏ ⵛⵏ ⴹⵗⵓⵏ ⴹⵗ ⴹⵏⵜ ⴹⴰ ⴹⴰ ⵜⵔⵏ ⵙⵙⵎ ⵏⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ ⵓⴹⵢ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗⵙ ⴶⵎⵢⵏ ⴹⵙⵏ⵿ⵜⴾⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ⴼⵍⵙ ⴹⴶ ⵓⴰ ⴹⵗ ⵎⵏⵢⵏ ⵛⵏ ⵎⴹⵗ ⴾⵔⴹ ⴹⵗⵓⵏ ⵙⵙⵎⵏ ⵓⴹⵢ ⵙⵏⵜ ⵙ ⵍ ⴶⵔⵙⵏ ⴹⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ⵜⵤⵔ ⵂⵤⵏ ⵀⵜⵔⵙ ⵗⵢⵙⴰ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ «ⵎⵍⵢ ⵂⵔ ⵎⵏⴾⵜ ⵜⴾⵍⵜⵏ ⵙ ⴹⵓⵔ ⴹ ⵙⵔⴼⴰ ⵢⵎⴹⵔⵢⵏⵏ ⴹⴹⵍⵎⵏ⵰ ⵓⴾ ⵂⵔ ⵙⵢⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔ ⴹⴾⵏ ⵂⵔ ⵙⵢⵜ ⵜⴾⵍⵜⵏ ⴾⵍⵔ ⴹⴾⵏ ⵙⵔⴼⵙ ⵙⵢⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⴾⵍⵜ ⵂⵔ ⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵎⵏⴾⵍ ⴹ ⵗⵔⵏ ⴾⵍⵏⵜ ⵔⴰ ⴹ ⵙⵗⵔⴹ ⵔⵤⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ⵙ ⵙⵏ⵿ⵜⴰ ⵜⵓⵗⵔⴹⵓ ⵢⵏ ⴹⵗ ⴾⵍⵏ ⵏ ⵗⵔ ⵍⴰ ⴶⵎⵏ ⵏ⵿ⴶⵎⵏ ⵏ⵿ⵜⴼⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ⵎⵛⵏ ⴾⵍⵢ ⵓⵏ ⵓⵔ ⴼⵔⴶ ⵔⵤⵎⵜⵏ ⵏⵤⵔⴼⵏ⵰ ⵓⵏ ⴹⵗ ⴼⵍ ⵎⵔ ⵎⵛⵙ ⵙⴹⵏⵜⵓⵤⵏ⵿ⵤⵓ ⵏ⵿ⵜⴰ ⴹⵜⵗⵔⵙ ⴹⵎⴹⵏⵙ ⴹⵓⴰ ⵍⴰ ⴾⵍ ⵆⵍⵏ ⵔⵤⵎⵜⵏ ⵏⵔⵤⵗⵏ ⵓⵏ ⵗⵔⵙ ⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ⵜⵤⵔ ⴼⵜⵆⴹ ⴾⵍⵏ ⵙⵌⴹ ⴹⵜ ⵎⵛⵙ ⵏⵙ \"ⴶⵢ ⵜⵤⵢⴹⵔ⵿ⵜ ⵎⵛⵢ ⴹⴾⵔⵤⵎⵗ ⵓⴰ ⵗⵔⵢ ⵜⵍⵗ ⴾⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ⵔⵜ ⵓⵏ ⵓⵢⴹⵓ ⵙ ⵎⵛⵙ ⵙ ⵜⵜⴶⵤ ⵜⵂⵏⵏ⵿ⵜⵏⵜ⵰ ⵜⵤⵔ ⵙⵔⴼⵙ ⵓⴰ ⵗⵔⵙ ⵍⴰ ⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ⵤⵎⴰ ⴹⵏⴶⵎⴹ ⴾⵍⵢ ⵓⵏ ⴼⵍⵏ ⵎⵛⵙ ⵎⵏⵢ ⴹⵢⵏ ⴹⵗ ⵎⴹⵓⵏⵜ ⴹⵗ ⵛⵗⵍ ⵓⵔ ⵔⵓⵙ ⵔ ⵜⵎⴹⵢ ⵏ⵿ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ⵰ ⵜⵤⵔ ⵀⵤⵙ ⵜⵔⵤⵎ ⵏⵙ \"ⵔⵤⵎⵢ ⵤⵔⴼ ⵓⴰ ⴹⵗⴾ ⵍⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ⵜⵤⵔ ⴼⵜⵆⴹ ⵎⴹⵏⵜ ⵓⵏ ⵏ⵿ⵙⵢⵜⵓ ⵏⵙ \"ⴶⵢ ⵜⵤⵢⴹⵔ⵿ⵜ ⴹⴾⵔⵤⵎⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ⵎⵛⵏ ⴶⵢ ⴾⵍⵢ ⵓⵏ ⵙⵙⴶⴰ ⴼⴹⴰ ⵎⴹⵏⵜⵏ ⴹⵗ ⴾⵙⵓ ⵢⴹ ⵜⵤⵔⵤⵎ ⵎⵔⵓⵙ ⵓⴰ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ⵙ ⵏⵢⵏ ⵎⴹⵓⵏⵜ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴶⵏ ⴹⵏ ⵗⵛⴹⵏ ⵎⵏⵙⵏ ⵓⵍⵏ ⴶⵍⵏ ⴶⵏ ⵙⵍⵏ ⵓⵏ ⴾⵍ ⵢ ⵎⵛⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ⵜⵤⵔ ⵙⵙⵗⵔⵢⴹⵓ ⵎⵛⵙ ⵏⵙ \"ⵍⴾⵏ ⵙ ⴾⵢ ⵎⴾⵙⵏ⵰ ⵏⴾ ⵙⵔⴼⵗⴾ ⵓⴰ ⵗⵔⴾ ⵍ ⴾⵍ ⴼⵍⵙ ⴹⵜⵏ⵿ⵙⵢⵗ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ⴾⵢ ⴹⴰ ⵓⵔⴾⵢ ⴾⵢⵜⴶⵤ ⵜⵂⵏⵏ⵿ⵜ ⵏⵎⴹⵏⴾ ⵜⴶⵗⵙ ⵂⵏⵜⴰ ⵤⵏ ⵓⴰ ⴹⴾⴶⵗ ⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ⵜⵤⵔ ⴶⵤ ⵍⵂⵎ ⵎⵛⵙ ⵙⵙⴶⴰ ⴾⵍⵏ ⴹⵗ ⴾⵙⵓ⵰ ⵜⵓⵜⴼ ⵂⵔ ⵗⵔⴹ ⵔⵤⵎ ⵏⵓⴰ ⵗⵔⵙ ⵍⴰ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⴾⵏ ⴹⵗ ⵙ ⵀⵏⵏ ⵂⵏ ⵌⵏⵓⵏ ⵓⵔ ⴹⵓⵏ⵿ⵤⵙⵔⴼ ⵙ ⵎⵙ ⵙ ⴾⵢⵏ ⴹⵗⵓⵏ ⵓⵔ ⵙⵔⴼ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵢ ⵎⴹⵔⵢⵏⵜ ⴹⵗ ⵤⴶⵤⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ⴹⴼⵔ ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵍⴼⵢⴹⵜⵏ ⵛⵏ ⴼⵍ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴾⴰ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵂⵏ ⴶⵏⴰ ⵓⴰ ⵂⴹⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ⵍⴾⵎⵏⵜⵙ ⵜⵎⵜⵓⵏ ⴶⵜⵏⵏ ⵜⵏⵜⵤⵤⵢ ⴹⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ⵂⵤⵏ⵿ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⴶⵏⵙ ⵙⵙ⵿ⵜⵏ ⵎⵙⵏ ⵜⵏⴶⵎⵢⵜ ⵏⵏⵙ «ⵓⴾ ⵈⵍⵍ ⵢⵍⵙ ⵤⵎⵤⵢ ⵏ⵿ⵜⵏ⵿ⵜⵜⵏⵜ ⴼⵍ ⵆⵍ ⴹⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵜⵗⵔⵎ ⵙ ⵙ⵿ⵜⵤⵔⵜ ⵙ ⴹⵈⵍⴾ ⵎⵈⵍⴾ ⴹⵏⵜ \"ⵈⵍⴾⴹⵓ ⵢⵜⴹⵏ ⵈⵍⴾⵏ⵿ⴹⵓ ⵎⵙⵏ ⵢⵢ ⴹⵜⵏ⵿ⵜⵢ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","«ⵏⴰ \"ⴹⵢ ⴹⵗ ⴼⵍ ⴼⵍ ⵍⵙ ⵀⵏⵜ ⴹⵏⵏⵜ ⵔ⵿ⵜⵢ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⵆⵍⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","«ⵎⴾⵏ ⴹⵗ ⵙ ⴹ ⵀⵙ ⵎⵙⵏ ⵛⵏ ⴾⵍⵔ ⴹ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ⴹⵗ ⴹⵢ ⵓⴰ ⵙⵔ⵿ⵜⵢ ⵎⵛⵏⴰ ⵜⵓⵔⵤⵎⵤⵢ ⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ⵏⵏⵙ «ⴹⵗ ⴹⵢ ⵎⴼⵍ ⵙ ⵎⵔ ⵏⵀⵢ ⵎⵙⴰ ⴹ ⵜⵜⵓⴾⴼⵓ ⵛⵔⵓⵜ ⵏⵎⵤⵢ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⵜⵓⵤⵎⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ⵏⵙⵏ «ⵛⴹⵜ ⵏ ⵜⴶⵔⵎⵎ⵿ⵜ ⴼⵍ ⴾⵓⵏⴾⴼⴰ ⵎⵙⴰ ⵜⵔⴶⵜ ⵏⴹ ⵜⵤⵎⵤⵢⵎ ⵛⴹⴹⵏⵓⵏ⵰ ⵎⵛⵏ ⵔⵜ ⵓⴹⵢ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⴶⵏ ⵙ⵿ⵜⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ⵎⵔⵏ ⵏⴾ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵤⵎⵤⵢⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⴹⵙⵓⵔⵏⵜⴶⵓ ⵎⴹⵏ ⵤⵍⴼ ⵢⵜ ⵓⴹⵢ ⵤⵏⴰ ⴶⴰ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⴹⵢ ⵤⴰ ⴾⴹ ⵓⵏ ⴹⵗ ⵍⵏ ⴶⵔ ⵍⵙ ⴹⵜⵏ⵿ⵜⵜ ⵓⴹⵢ ⴼⴰ ⵢ ⵓⵔ ⵏⵤⵍⴼ ⴼⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ⵏⵙⵏ «ⵓⵍ ⵓⴰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⴾⵍ ⵆⵀⵍⵏ⵿ⵜⵓ ⴾⵍⵔ ⵓⵔ ⵜⵆⵀⵍ ⵔ ⵓⵏ ⴾⴼⴰ ⵎⵛⵏⴰ ⴼⵔⴶⵜ ⵏⵍⵆⵀⵍⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ⴼⵍⵙ ⵍⵏ⵿ⵜⵓ ⴹⵍⵍⵏ ⴶⴹⵍⵏⵏ ⵤⵍⴼ ⵎⵙⵏⵏ ⵙ ⵎⴹⵏ ⵓⵢⴹ ⵙ ⴹⵂⵓⵏ ⴹⴰ ⵓⵔ ⴼⵔⴶⵏ ⵤⵍⴼ ⵓⵢⴹ ⴹⴼⵔ ⴶⵏ ⴹ ⵜⵓⵤⵎⵏ ⵍⵏ⵿ⵜⵓ ⴹⵗ ⵓⵏ ⵙ ⵎⵏⵙⵏ ⵙ ⵙⵏⴼⵔⵏⵏ ⵀⴰ ⵏⵤⵍⴼ ⴼⵍ ⴹ ⵓⵔ ⵍⵏ ⴹⵗ ⵛⵗⵍ ⵔ ⵓⵏ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ⵓⴰ ⴼⵔⴶⵏ ⵍⵆⵀⵍⵜ ⵏⴹⵢ ⵆⵀⵍⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ⵜⵤⵔ ⴹⵜⵓⵢⵏ ⵢⵜⴹⵏ ⵀⵔⵔⵏ ⴼⵍ ⵜⵏⵙⵓⵔ ⵗⵢⵙⴰ ⴼⵙⵏⵜ ⵜⵔⵙⵏ⵰ ⵛⵓⵍⵏ ⵏⵜⵍⵀ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵢⵓⵜ ⵀⵔⵔⵏ ⴹⴹⴾⵏ ⵜⵏⵏⵓⵔ⵿ⵜⵓⵗⵎ ⴼⵍⵢ⵰ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵛⵍⵜⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ⵙⵓⵔ⵿ⵜⵏ ⴼⵙⵏⵜ ⵜⵔⵙⵏ ⴹⴼⵔ ⵓⵏ ⵀⵤ ⵜⵔⵢⵜⵏⵜ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ⵜⵤⵔ ⵂⵤⵏ ⵍⵙ ⵢⵏ ⵢⵏⵢⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵛⵈ ⵎⴰ ⵎⵙ ⵔⵜ ⵍⵗⵏ ⵓⵙ ⵙ ⵜⴶⵗ ⴹ ⴶⵔⵓⵗ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴼⵍ ⵙ ⴹⵜⵙⵙ⵿ⵜⵏⴰ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵍⵗⵏ⵰ ⵎⵛⵏⴰ ⵗⵙ ⵍⵗⵏ⵰ ⵎⵔⵏ ⵙ ⵜⵔⵗ ⴹ ⵜⴶⵔⵓⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵜⵍⴾⵎⴰ ⵢⵍⵓⵌⵀⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ⵏⵙ ⵍⵙ ⵓⵏ «ⵎⴰ ⵎⵙⵏ ⵤⴰ ⵍⵓⵌⵀⵏ ⵓⵏ ⴹⵏ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴹⵢ ⵤⴰ ⴹ ⵓⵔ ⵜⴶⵗ ⵎⵏ⵰ ⴹ ⵓⵔ ⵜⴶⵗ ⵤⵏⴰ⵰ ⴹ ⵓⵔ ⵜⴾⵔⴰ⵰ ⴹ ⵓⵔ ⵜⴶⴰ ⵜⴶⵢⴰ ⵏⵀⵂⵓ ⴼⵍ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ⵰ ⴶⵓ ⵢⵛⵆⵗⵏⴾ ⵜⵔⴰ ⵜⴰ ⵜⴶⵗ ⵢ ⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ⵏⵙ ⵍⵙ ⵓⵏ «ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⵙⵀⴹⴹⵆⵏ⵰ ⵎⴰ ⴹⵏⵆⵎⵏ ⵂⵔⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ⵏⵙ ⵗⵢⵙⴰ «ⵙ ⵜⵔⵗ ⴹ ⵜⵆⵍⵗ ⵓⴹⵏ ⴾⵎⵍⵏ ⵜⴶⵍⴰ ⵜⵤⵏ⵿ⵤⵗⵏ ⵜⵍⵏⴾ ⵜⴾⴼⵗ ⵏⵤⵏⵜ ⵢ ⵜⵍⵆⵓⵏ ⴹⵢ ⴹ ⵜⴶⵔⵓⵗ ⵔⵤⵗ ⴹⴾⵤⵏ⵿ⵙⵏ ⴹⵗ ⵍⵈⵔⵜ⵰ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵜⴶⵍⴹⵓ ⵜⵍⴾⵎⵗⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ⵙ ⵙⵍⴰ ⵍⵙ ⵓⵏ ⵢ ⵀⵜⵓ ⵜⵏ ⵏ⵿ⴾⵔ ⴶⵍⴰ ⵗⵛⴹⵏ ⵎⵏⵜ ⴼⵍⵙ ⵔⵤⵗ ⴶⵏ ⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ⴹⵏ ⴹⵗ ⴹ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵤⵓⵜ ⴼⵍ ⵎⴶⵔⴶⵙ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ⵓⵍⴰ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴶⵔ ⵜⵔⵗⵙⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵍⵎ ⵔⴹⵗ ⴹⵗ ⵜⵀⴹⵢ ⵏⵏⵤⵎⵢ ⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵎⴶⵔⴶⵙ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ⵙ ⵙⵍⵏ ⵏⵜⵍⵀ ⵢⵓⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵍⵏ ⵏⵏ «ⴹⵗ ⴹⵢ ⵎⴰ ⴼⵔⴶⵏ ⴹ ⵗⵍⵙ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ⵙⵓⴹ ⴹⵗⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵔⵜ ⵓⴹⵢ ⵎⵈⵍ ⵎⵙ ⵗⵔ ⵢⵜⴹⵏ ⵎⵛⵏ ⵗⵔ ⵎⵛⵏⴰ ⵔⵜ ⴾⵍ ⴼⵔⴶ ⴶⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ⴹⵏ ⴹⵗ ⴹ ⵛⵓⵍ ⵀⵜⵔⵙ ⵏⴰ «ⵏⴾⵏⵢ ⵤⴰ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵏⵢⴰ ⵔⵜ ⴾⵍ ⵏⵍⴾⵎⴾ⵰ ⴹⵗ ⴹⵢ ⵎⴰ ⴹⵗⵏⴰ ⵤⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙ ⵜⵓⵛⵛⵏⵢⵏ ⵔⵜⵏ ⴾⵍ ⵆⵎⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⴹⴶⵏ ⵜⵎⵙⵏ ⵜⵈⵓⵜ ⵏ⵿ⵜⵗⵎⵔⵏ ⴹⵢ ⵜⵍⵜ ⵜⵏⵢⴰ ⴹⵢ ⴾⵓⵏⵢ ⴹⵍⴾⵎⵏⵏ ⴹ ⵜⵆⵎⵎ ⴼⵍ ⵎⵔⵓⵜ ⵜⵈⵓⴰ ⵏ⵿ⵜⵗⵎⵔ ⴹⵙⵏⵜⵜ ⵜⵛⵔⵗⵎ ⵢ ⵜⵓⵛⵜⵏ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵏ ⵎⵔⵓⵜ ⴹⵙⵏⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴼⵍⵏ ⵗⵢⵓⵏⵙⵏ ⴹⵎⴹⵔⵢⵏⵜ ⴹⵜⵎⴹⵔⵢⵏⵜ ⴹⵀⵏⵜ ⴹⵏⵏⵜ ⴹⵀⵔⵔⵏⵜ ⵎⴹⵗ ⵎⴹⵍⵏⵜ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵜⵎⴹⵢ ⵏⵏⵜⴼⵙ ⵏⵔⵜⵏ ⵓⵏ ⴹⵏ ⴶⵔⵓ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ⴶⵏ ⴹⵗ ⵓⵏ ⵂⵏⵏ ⵗⴼ ⵎⵔⴹⴰ ⵍⴾⵎ ⴹ ⴶⵤⵏ ⵍⵆⵎ⵰ ⵎⵔⵏ ⴶⵏ ⴹⵗ ⵓⵏ ⵂⵏⵏ ⵍⵆⵎ ⵎⵔⴹⴰ ⵍⴾⵎ ⴹ ⴶⵤⵏ ⵗⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⴹⵔ ⵜⵍⴰ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⴹⵏ⵿ⴾⵔ ⵓⴹⵏ ⵍⵏ ⴼⵔⴶ ⵏⵍⵗⵏⵀ ⵤⵍ ⵢⵏ ⵗⵔⴰ ⵔⴰ ⴹ ⴹⴾⵍ ⵎⵛⵗⵍⵏ ⵢⴼⵔⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ⵏⵎⵔⴹⴰ ⴹⵎⵛⵗⵍⵏ ⵓⵏ ⵙ ⵤⵍ ⴾⵍ ⵜⵏⴾⴼⵓ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ ⵜⵤⵔ ⵙⴾⵏ ⴼⵔⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ⵙ ⵜⴶⴰ ⴹⴶⵍⵛⵜ ⵍⵙⴹⵓ ⴶⵎⴹ ⵏⵢ ⵎⵛⵗⵍⵏ ⵓⵢⴹ ⵓⵔ ⵏⴶⵔⵓ ⵛⵗⵍ ⵂⵔⵓⴰ ⵆⵎⵏ ⴹⵗ ⵙⵎⵏⵢ ⵏⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ⵏⵙⵏ \"ⴾⵓⵏⵢ ⴹⴰ ⴶⵍⵓⵜ ⵜⵛⵗⵍⵎ ⴹⵗ ⴼⵔⴶⵏ ⴹⵓⵏⴶⵗ ⵔⵤⵎⵜⵏ ⵍⵗⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ⴶⵍⵏ ⵎⵛⵗⵍⵏ ⴾⵏ ⴼⵔⴶⵏⵜ⵰ ⴹⴼⵔ ⵓⵏ ⵍⵙ ⴶⵎⴹⵓ ⵗⵔ ⵎⵙⵏⵤⵍ ⴶⵎⴹⵓ ⴹⵗ ⵙ ⵜⵤⵔ⵰ ⵎⵔⵏ ⵢ ⴹⴶⵎⴹ ⴹ ⴶⵓ ⵤⵏ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ⵙ ⵜⴶⴰ ⵜⴾⵙ⵿ⵜ ⵤⴶⵔⵜ ⵍⵙⴹⵓ ⴶⵎⴹ ⵏⵢ ⵎⵛⵗⵍⵏ ⵓⵢⴹ ⵆⵎⵏⵏ ⵏⵙⵏ \"ⵎⴼⵍ ⵜⴾⵍⵎ ⴹ ⵜⵆⵎⵎ ⴹⵢ ⵓⵔ ⵜⵂⵎ ⵓⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ⵏⵏⵙ \"ⴶⵔⵓ ⵓⵔ ⵏⴶⴰ ⵢ ⴹⵏⵗⵛⵛⵗⵍⵏ⵰\" ⵏⵙⵏ \"ⴶⵍⵓⵜ ⴾⵓⵏⵢ ⴹⴰ ⵜⵛⵗⵍⵎ ⴹⵗ ⴼⵔⴶⵏ ⵏⵍⵗⵏⵀ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵏⴰ ⵎⵛⵙ ⵏⴼⵔⴶ ⵓⵏ ⵢⵎⵤⵔ ⵏⵎⵛⵗⵍⵏⵜ \"ⵗⵔⴹⵓ ⵎⵛⵗⵍⵏ ⴾⵍ ⵜⵔⵤⵎⴰ ⵢⴾⵢⵏ ⵍⵈⵆⵏⵜ⵰ ⵤⵔ ⵙ ⵓⵏ ⴹⴾⵍⴰ ⴹⵗ ⵜⵍⴾⵎⵜ ⵜⵙⵍⴾⵎⵗ ⵙ ⵓⵏ ⴹⴾⵍⵗ ⵙ⵿ⵜⵤⵔⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ⵙⵏ⵿ⴹⵓ ⵓⵏ ⵙⵏ⵿ⵜⵏⵏ ⵛⵗⵍ ⵜⴾⵙ⵿ⵜ ⵤⴶⵔⵜ ⴾⵢⵏ ⴹⵗⵙⵏ ⴶⵔⵓ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ⴹⴼⵔ ⵓⵏ ⵜⵙⵗⵍⵢⴹⵓ ⵙ ⵓⵏ ⵛⵗⵍⵏⵏ ⵙ⵿ⵜⵤⵔⵜ ⴶⵏ ⴹⴼ ⵏⵙ ⴹ ⴶⵔⵓⵏ ⴶⵔⵏ ⵓⴰ ⴶⵔⵓⵏ ⵎⴹⵏ ⵓⵏ⵰ ⵎⵛⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴾⵢⵏ ⴹⵗⵙⵏ ⴶⵔⵓ ⵜⴼⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ⵙ ⴶⵔⵓⵏ ⵔⵤⵎⵜⵏⵙⵏ ⵙⵗⵍⵏ ⵜⴶⵏⴰ ⵎⵛⵙ ⵏⴼⵔⴶ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ⵏⵏ \"ⵢⵜⴹⵏ ⵓⵏ ⵜⵜⴾⵍⵗ ⵙ ⵜⵍⴾⵎⵜ ⵍⵓⵆ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵛⵗⵍⵏ ⵎⵔⵏ ⵜⵛⵛⴶⴹⵆⵏ ⴹⵔⵏⴰ ⵏⴾⵏⵢ ⴾⵍⵏⵏ ⵏⵛⵗⵍ ⵜⴾⴶⵢⵏⴰ ⵜⴼⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ⵜⵤⵔ ⵛⵓⵍ ⵎⵛⵙ ⵏⴼⵔⴶ ⵢⵢⵏ ⴹⵗⵙⵏ ⵏⵙ \"ⵎⴹⵏⵏ ⵏⴾ ⵓⵔ ⴹⴾⴶⵗ ⵔⵜ ⵓⵍⵢⵏ ⵓⵔ ⵏⵗⴹ⵰ ⵓⵔⴶ ⴾⵢ ⵎⵏⴾ ⴹⵔ ⵏⵎⵔⴹⴰ ⴼⵍ ⵜⴼⵍ⵿ⵜ ⵢⴹⴰ ⵏⵤⵔⴼ ⴹⵗ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ⴹⵗ ⴹⵢ ⵀⵤ ⵤⵔⴼ ⵓⴰ ⵎⵙⵏ ⵍⵈⵆⵏⴾ ⵜⴶⵍⴰ⵰ ⴾⴹ ⵏⴾ ⵔⵏ ⴹ ⵛⵛⴶⴹⵗ ⵍⵈⵆⵏⴾ ⴹ ⵓⵏ ⵎⴹⵏ ⵓⵏ ⵜⴾⵍⵗ ⴹⵗ ⵜⵍⴾⵎⵜ ⵜⴹⵢ ⵏⴾ ⵜⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ⵓⴾ ⵏⴾ ⵓⵔ ⵤⴶⵗ ⵓⴰ ⵔⵗ ⵙⵔⵤⵗⵏⵏ⵰ ⵎⵗ ⴾ ⵎⵏ⵿ⵌⵗ ⵜⴶⵗ ⵙ ⵎⵙⵗ ⵍⵙ ⵍⵗⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ⵏⴰ ⵗⵢⵙⴰ «ⵎⴾⵏ ⴹⵗ ⵙ ⵓⵏ ⵂⵏⵏ ⵗⴼ ⵎⵔⴹⴰ ⵍⴾⵎ ⴹ ⴶⵤⵏ ⵍⵆⵎ⵰ ⵎⵔⵏ ⵓⵏ ⵂⵏⵏ ⵍⵆⵎ ⵎⵔⴹⴰ ⵍⴾⵎ ⴹ ⴶⵤⵏ ⵗⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ⴶⵤⵢ ⵗⵢⵙⴰ ⴾⴰ ⵢⵔⵙⵍⵎ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ⵓⵔ ⴹⵔⵙⵏ ⵜⵎⴰ ⴹⴰ ⵌⵓⵏ⵿ⴾⵏ ⴼⵍ ⵜⵔⵢⵜ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ⵙⵙⵎⵜ ⵏⴾⵏⵢ ⴹⴰ ⴶⵤⵢⵏⵏ ⵙ ⵢⵔⵙⵍⵎ ⴹⴰ⵰ ⴹⵏ ⴹⵗ ⴹ ⵤⵜⵓⴶⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⴼⵙⵏ ⵏⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵈⴾⵎⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ⴹⴶⵏ ⴹⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⵗⵢ ⵜⵌⵀⵏ ⵢⵓⵏⵏⵢ ⵛⵓⵜ⵰ ⴹⴼⵔ ⵓⵏ ⵜⵢⵜⵢⵏⵢ ⴼⵍ ⵜⴶⵜⵓⵜ ⵀⵢ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ⵜⵂⵤⵏ ⵜⵗⵔ ⵤⵀⴹⵢ ⵗⵢⵙⴰ ⵜⴹⵓ ⴹⵎⴹⵏⵙ⵰ ⵜⴶⵔⴼⵜ ⵢⵜⵜⵏ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ⵏⵙ «ⵔⵜ ⵢⵏ ⵜⵔⵗ⵰» ⵜⵏⵙ «ⵀⵔⵔⵏⵏ ⵏⵛⵏ ⵙ ⴹⵗⴾ ⵔ ⴹⵜⴶⵗ ⵔⴾⵓⵍ ⵏⵙ ⴹ ⴶⵤⵏ ⴹⴶⵏ ⵜⴾⵍⵏⵏ ⵢⵏ ⴹⵗ ⵗⵍⵏⴾ ⵓⴰ ⵂⴹⵏ ⴹⵗ ⵤⵍⴶⵜⵏⴾ ⴹⵗ ⵜⵗⵎⵔⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ⵏⴰ ⵗⵢⵙⴰ «ⵓⵔ ⵜⵙⵏⵎ ⵍⵎⵗⵏⴰ ⵏⵔⵜ ⵓⴰ ⵜⴶⵎⵢⵎ ⴹⵢ⵰ ⵓⴾ ⵜⴼⵔⴶⵎ ⴹⵔⵢ ⵜⴹⵔⵓⵎ ⵍⵗⵤⵀ ⵓⴰ ⵤⴶⴰ ⴹⵗ ⵍⵓⵆ ⵓⵔ ⵏⴶⴶ⵰» ⵏⵏⵙ «ⵓⵍⴰ ⵏⴼⵔⴶ ⴹⵔⴾ ⵜⵏⴹⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵍⴰ ⵍⴾⵏ ⵙ ⵜⴼⵔⴶⵎ ⴹⵔⵢ ⵜⴹⵔⵓⵎ ⵍⵗⵤⵀ ⵓⴰ⵰ ⵎⵛⵏ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵤⵆⵎⵏ ⴹⵗ ⵗⵍⵏ ⵓⵍⴰ ⵤⵍⴶⵜⵏ ⵓⵔⴶⵗ ⵏⴾ ⵜⵂⴾⵏ ⴾⵍⵔ ⴹⴶⵏ ⵓⵏ ⴹⵢ ⵏ ⵓⵏ ⵙ ⵜⵏⵙⵎⵜⴶ ⵀⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ⵙⵍⵏ ⵎⵔⵓ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ ⵢⵓⵏ ⵛⴾⵏ ⵛⵏ ⵎⴹⵔⵢⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ⵜⵤⵔ ⵗⵔⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵂⵤⵏ⵿ⵜⵏ ⵏⵙⵏ «ⵜⵙⵏⵎ ⵙ ⵎⵤⵔⵏ ⵏ⵿ⵜⵎⵜⵓⵏ ⵙⴾⵏⵏ ⵜⵔⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⵏ ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵗⵙⵏ ⵜⴼⵏⵏ ⵍⵈⴾⵎ ⵙⴾⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⵏ ⵜⵗⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ⵎⵛⵏ ⴾⵓⵏⵢ ⴹ ⵓⵔ ⵜⴶⵎ ⴹⵢ ⴶⵔⵓⵏ⵰ ⴾⵍⵔ ⵙ ⵔⴰ ⵢⵏ ⴹⵗⵓⵏ ⴹ ⵍⵓ ⵍⵎⵆⵎ ⵆⵍⵜ ⵤⵏ ⵎⵛⵗⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ⵎⵔⵏ ⵓⴰ ⴹⵗⵓⵏ ⵔⵏ ⵜⵤⵔ⵿ⵜ ⵆⵍⵜ ⴾⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ⵎⴾⵏ ⴹⵗ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵓⵔ ⴹⵙⵗ ⴹⵏⵜ ⵢⴹⵛⵗⵍⵏ ⵢⵜⴹⵏ⵰ ⴾⵍⵔ ⵙⴰ ⴹⴶ ⵢⴹ ⵛⵗⵍⴰ ⵢⵢⵜⴹⵏ ⴾⴼⴰ ⵎⵏⵏ ⴼⵍ ⴹ ⵙⴹⵔⴼⵗ ⵙ ⵜⵎⵜⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵗⵔⵎ ⵓⵏ ⵢⵔⴾⵓ ⵜⵍⴾⵎⵙⵏ ⵜⵎⵜⵢ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ⵍⵏ ⵎⴹⵔⵗⵍ ⴹⵏ ⵛⵏ ⵆⵎⵏ ⴼⵍ ⴼⵢ ⵏ⵿ⵜⵔⵢⵜ⵰ ⵙⵍⵏ ⵙ ⵗⵢⵙⴰ ⵜⴾⵢⵏ ⴹⵏ ⴹⴾⵍⵏ ⵎⵙⵍⵏⵙⵏ ⴹ ⴶⵏⵏ «ⵂⵏⵜⵜⵏⵗ ⵎⵍⵢ ⴶ ⵏⵀⵢ ⴹⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ⵜⵙⵏⵔⵗⵎⵏⵙⵏ ⵜⵎⵜⵢ ⴼⵍ ⴹ ⴼⵙ⵿ⵜⵏ ⵎⵛⵏ ⵛⵜⵏ ⴹⴾⵍ ⵏⵎⵙⵍⵏⵙⵏ ⴶⵏⵏ «ⵂⵏⵜⵜⵏⵗ ⵎⵍⵢ ⴶ ⴹⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ⵤⴾⵜ ⵗⵢⵙⴰ ⵗⵔⵏ ⵏⵙⵏ «ⵎⵙ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ⵏⵏⵙ «ⵎⵍⵢ ⵙⵓⴹⵏⵏⵗ ⵙ ⵏⵔⴰ ⴶⵔⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ⵜⴶⵤ ⵜⵂⵏⵏ⵿ⵜⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵙ ⵛⵜⵓⵏⵙⵏ⵰ ⵎⵤⵢ ⵓⵏ ⴹⵗ ⵜⵏ⵿ⴹⵆⵍ ⵙⵓⴹⵏⵙⵏ ⵜⵤⵔ ⵍⴾⵎⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ⵙ ⴹⵏⵂⵤ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵢⵔⵙⵍⵎ ⴹⵗ ⵏⵎⵂⵤ ⵏ⵿ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⴼⵌⵢ ⴹⴶⵎⴰ ⵏⴹⵗⵗ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ \"ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ\" ⵤⵎⵤⵍ ⵗⵢⵙⴰ ⵛⵏ ⵏⵜⵍⵀ ");
INSERT INTO ttqt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ⵏⵙⵏ «ⴾⵓⵜ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⴹⵜⵓⵏ ⴹⵏ⵰ ⵜⵙⵎ⵿ⵜⵜⵏ ⵗⵙ ⵜⵏⵢⵎ ⵜⵌⵜ ⵜⵆⵏⵜ ⵜⵍⵜ ⵂⵍⵍ⵰ ⵔⵓⵜⵏ⵿ⴹⵓ ⵜⵍⵓⵢⵎⵜⵏ⵿ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ⵙ ⴹⵓⵏⵏⴰ ⵓⴹⵏ ⵔⵜ ⵜⵏⵎⵙ \"ⵎⵍⵢ ⵙⵔⵙⵏ ⴹⵔⵔⵏ⵰\" ⴹⵢ ⴾⵓⵏⵢⵓ ⵜⴶⵍⵎ ⴹⵔⵙⵏ ⵎⵤⵢ ⵓⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ⵔⵜ ⵓⴰ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴹⵎⵍ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏⵀⵢ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ⵏⵓⵜ ⵢⵗⵔⵎ ⵓⵏ ⵙⵢⵏ ⵏⵢ⵰ ⵎⵏⴾⵍⵏⴾ ⵤⵢⴾⵢⴹⵓ⵰ ⴾⵏⴰ ⵙⵔⵙ ⵏⵎⵏⵜ⵰ ⵓⵏ ⵜⵌⵜ ⵂⵍⵍ ⴼⴹⴰ ⵎⵙⵏ ⵔⴰ ⵏⵎⴹⵔ ⴼⵍ ⵜⵎⵓⵢ ⵤⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ⴶⵍⵏ ⵏⵜⵍⵀ ⵎⵤⵍⵏ ⵓⴰ ⵙ ⵜⵏⵎⵔ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ⵍⵓⵢⵏ ⵜⵌⵜ ⴹⵂⵍⵍⵏⵜ ⵢ ⵗⵢⵙⴰ⵰ ⴹⴼⵔⵏ ⴼⵍⵙⵏ ⵙⵍⵙⵏⵙⵏ ⵓⵏ ⵗⵢⵙⴰ ⵂⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ⵜⴶⵍⴹⵓ ⵜⵎⵜⵢ ⵜⴶⵜ ⵓⵍⵏ ⴹ ⵜⵜⵙⵓ ⵢ ⵗⵢⵙⴰ ⵙⵍⵙⵏⵜ ⴼⵍ ⵜⵔⵢⵜ ⵓⵢⴹ ⴼⵔⵙⵏ⵿ⴹⵓ ⵍⴹⵍⴹ ⵜⵙⵓⵏⵙ⵿ⵜⵏ ⴼⵍ ⵜⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ⵜⵎⵜⵢ ⵜⴰ ⵜⵍⴾⵎⵜ ⵢ ⵗⵢⵙⴰ ⴹⵜⴰ ⴹⵙ⵿ⵜⵤⵔⵜ ⵜⵜⴾⵍ ⵎⵙⵍⵏⵜ ⵜⴶⵏⵓ «ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢⵂⵢⴰ ⵏⵎⵏⴾⵍ ⴹⵓⴹ⵰ ⴶⴰ ⵎⵛⵏⴰ ⵍⵀⵔⴾⴰ ⴹⵗ ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ⵰ ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ⵓⵏ ⴹⴾⵍⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ⵙ ⴹⴶⵤ ⵗⵢⵙⴰ ⵢⵔⵙⵍⵎ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⴾⵜⵏⵙⵏ ⵏⵌⵔⵓⵢⵏ ⴶⵏⵏ «ⵎⴰ ⵎⵙ ⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ⴹ ⵜⴶⵏⵓ ⵜⵎⵜⵢ «ⴹⵢ ⵤⴰ ⵏⵀⵢ ⵗⵢⵙⴰ ⵎⵙⵏ ⴶ ⵗⵔⵎ ⵏⵤⵔⵜ ⵜⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⵗⵔⴹ ⴹⵗⵙ ⵙⵜⵗ ⵏⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵎⵙⵜⴶⵏ ⵂⵔⴾⴹ ⵓⵏ ⵎⵤⵏ⵿ⵤⵏ⵰ ⵙⵀⵏⵀⵢ ⵜⵀⵔⵏ ⵛⵏ ⴼⵍ ⵙⵏ⵿ⵙⵏ ⴾⵍ ⵙⵏ⵿ⵌⵢ ⵤⵔⴼⵏⵙⵏ ⵙⵀⵏⵀⵢ ⴹⵗ ⵛⵙⵆⵎⴰ ⵏⵎⵙⵜⴶⵏ ⵏ⵿ⵜⴹⵀⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ⵜⵤⵔ ⵏⵙⵏ «ⴾⵜⵀ ⵙ \"ⵂⵏⵏ ⴹⵙⵜⵓⴶⵓ ⵙⵎ ⵂⵏ ⵏⵍⵗⵀⴹⴰ⵰\" ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⴶⵎ⵿ⵜⵓ \"ⵙⵍⵗⵙ ⵏⵀⵢⴹⴶⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ⵂⵤⵏⵏ ⵎⴹⵔⵗⵍ ⴹⵎⴶⴹⵍ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⵏ ⴹⴰ ⵤⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵛⴾⵏ ⵓⵍⵏ ⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵓⵏ ⴶⴰ ⵗⵢⵙⴰ ⴹⵏ⵰ ⵛⴾⵏ ⴹⵗ ⵛⵗⵔⵜⵏ ⵛⵏ ⵜⴶⵏ ⵀⵔⵔⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴶⵏⵏ «ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢⵂⵢⴰ ⵏⵎⵏⴾⵍ ⴹⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ⵓⵏ ⴼⵍ ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵜⵙⵍⴰ ⵢⵓⴰ ⴶⵏⵏ ⴹⴰ⵰» ⵎⵔⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵍⴰ⵰ ⵓⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵗ ⵍⴾⵜⵀⵏ ⵀⵜⵓ ⵜⴰ ⵜⵏⵜ \"ⴾⵢ ⴹⵓⵢⵏ ⵙ ⵀⵔⵔⵏ ⴹⵌⵏ⵿ⵗⵢⵏ ⴹⴾⴶⵏ ⵜⵎⵍⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ⴹⴼⵔ ⵓⵏ ⴼⵍ⵿ⵜⵏ ⵗⵢⵙⴰ ⴶⵎⴹ ⵢⵔⵙⵍⵎ ⴹⵓⴰ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⵏⵢ ⵏ⵿ⵙⴰ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ⵙ ⴼⵓ ⵆⵍⴹⵓ ⵢⵔⵙⵍⵎ ⵂⵔⵓⴰ ⵗⵔⴰ ⴼⵔⵢ ⵢ ⴶⵍⴾ ⴹⵗ ⵜⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ⵏⵢ ⵛⴾ ⵏ⵿ⴼⴶ ⵎⵔ⵿ⵜⵏ ⵎⵛⵏ ⵓⵔ ⴹⵗⵙ ⵏⴶⵤ ⵔ ⴼⵔⴾⴾ ⵗⵙ⵰ ⵜⵤⵔ ⵏⴰ ⵢⵛⴾ ⵓⵏ \"ⵜⵎⵤⵗⵜ ⴹⴶⵢ ⵏⵔⵜⵏ ⵂⵔ ⴼⵓ ⴹⵗ ⴹⵏⵜ⵰\" ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹ ⵆⵔ ⵛⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ⵙ ⵏⵢⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⴹ ⴶⵏⵏ «ⵎⵏⵎⴾ ⵙ ⵆⵔ ⵛⴾ ⵏ⵿ⴼⴶ ⵓⵏ ⵎⵢ ⵢⵏ⵿ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙ ⵜⵤⴶⵤⵏⵎ ⵓⵔ ⵜⴶⵎ ⵎⵙⵏ ⵛⴾ ⵓⵔⴶⵗ ⵓⴰ ⴶⵗ ⵢⵛⴾ ⵗⵙ ⵙ ⵤⴰ ⵜⴼⵔⴶⵎ ⴶⵏⵜ⵰ ⴾⵍⵔ ⴹ ⵜⴼⵔⴶⵎ ⴹ ⵜⵏⵎ ⵢⴹⵗⵗ ⵓⴰ \"ⴶⵎⴹ ⴹⴶ ⴹⵢ ⵜⴼⵜⵆ ⴹⵗ ⴶⵔⵓ\" ⴶⵓ ⴹⵗ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⵙⵤⴶⵤⵏ ⵜⵜⴶⵔⵓⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ⴾⴰ ⵗⵢⵙⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗⵙ ⵙⵙⵗⵔⵓ⵰ ⵂⵤⵏ⵿ⵜⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⵏⵙ «ⵓⴾ ⵎⴰ ⵜⵎⵙ ⵜⵔⵏⴰ ⵜⵙ ⵜⵜⴶⵗ ⵔⵜⵏ ⵓⵏ⵰ ⵎⴰ ⴾⵢⴾⴼⵏ ⵜⵔⵏⴰ ⵜⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⴹⴰ ⴹⵓⵏⴶⵗ ⵙⵙ⵿ⵜⵏ ⵢⵏ⵿ⴹⴰ⵰ ⵙ ⵜⵌⵓⵀⵎ ⵢⵙⵙ⵿ⵜⵏⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⴹⴶⵔⵓⵗ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⵜⴶⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵙ⵿ⵜⵏⵏ \"ⵓⴾ ⵙⵍⵎⵗ ⵓⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵎⵛⵏⴰ ⵗⵔ ⴹⴼⵍ ⵓⵏ ⵎⵗ ⴶⴹⵎ⵰\"» ⵜⵤⵔ ⴹ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵙ ⵏⵏⴰ \"ⵎⵛⵏⴰ ⵗⵔ ⴹⴶⵔⵓ ⵜⵔⴶⵜ ⵏⵓⵏ\" ⴹⵏⵗⵏⵓ \"ⵎⴼⵍ ⵤⴰ ⵓⵔ ⵙⵔⵙ ⵜⵤⴶⵤⵏⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ⵙ ⴹⵙⵏⵏⴰ ⵎⵔⵏ \"ⴶⴹⵎ ⵗⵔ ⴹⴶⵔⵓ ⵢⵈⵢⴰ ⵜⵔⵏⴰ ⵜⵏ\" ⵓⴹⵢ ⴹⵏⵜⵛⴾ ⵜⵎⵜⵢ ⴼⵍⵙ ⴾⵜⵏⵜ ⵜⴾⵙ ⵛⴾ ⵙ ⵢⵈⵢⴰ ⵏⵀⵢ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ⵜⵤⵔ ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵓⵔ ⵏⵙⵏ⵰» ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⴹⴰ ⵤⴰ ⵓⵔ ⴹⵓⵏ⵿ⵤⵎⵍⴰ ⵓⴰ ⴹⴾⴼⵏ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵎⴰ ⵜⵏⵎ ⵙⵍⵆⵙⵜ ⵜⴰ⵰ ⵍⵙ ⵢⵏ ⵍⵏ ⵛⵏ ⵀⵔⵔⵏ⵰ ⵂⵤⵏ ⵀⵔⵔⵏⵜ ⵓⴰ ⵤⵔⵏ ⵏⵙ \"ⴶⵍⵓ ⵀⵔⵔⵏ ⵜⵛⵗⵍⴰ ⴹⵗ ⴼⵔⴶⵏⵏⴰ ⵓⵏ ⵍⵗⵏⵀ ⵤⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ⵏⵙ ⵀⵔⵔⵏⵜ ⵓⵏ \"ⵓⵔ ⴹⵂⴰ ⴹⵢ⵰\" ⵎⵛⵏ ⵢⴰ ⴹⴼⵔ ⵓⵏ ⵎⴶⵔⵤ ⵀⵔⵔⵏ ⵜⴶⵢⵜ ⵜⴰ ⴶⴰ ⵢⵀⵏⵜ ⵜⵤⵔ ⴶⵍⴰ ⴾⴰ ⴼⵔⴶⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ⵂⵤⵏ ⵍⵙ ⵓⵏ ⵀⵔⵔⵏⵜ ⵓⵏ ⵛⵏ ⴶⵎⵢ ⴹⵗⵙ ⵔⵜ ⵓⴰ ⴶⵎⵢ ⴹⵗ ⵓⴰ ⵤⵔⵏ⵰ ⴶⵙ ⵀⵔⵔⵏⵜ ⵓⵏ ⵍⵌⵓⵀ ⴶⵏ ⵙ ⵙⵗⵎⵔ ⵏⵙ \"ⵓⵍⴰ ⵀⵏⵏ ⴹ ⴾⵗ ⴼⵔⴶⵏⵏⴰ⵰\" ⵎⵛⵏ ⵆⵎ ⴹⴰ ⵓⵔ ⵜⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ⵓⴾ ⵎⴰ ⵎⵙ ⴹⵗ ⵀⵔⵔⵏⵏ ⵓⴰ ⵎⵤⵍⵏ ⵜⵔⴰ ⵏⵀⵏⵙⵏ⵰» ⵏⵏⵙ «ⴹⵢ ⵤⴰ ⵀⵔⵔ ⵓⴰ ⵤⵔⵏ⵰» ⴹⵢ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵤⴰ ⵙ ⵏⵀⵤⵏ ⵏ⵿ⵜⴾⵙⵏ ⴹⵜⴾⵔⵓⵜⵏ ⴹⴰ ⴹⵓⵏⵤⵔⵏ ⵜⵓⵆⵀⵍ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ⵏⵗⵓⵏ ⴹⵢ ⴼⵍⵙ ⵢⵈⵢⴰ ⵙⵓⵏ⵿ⴹⵓ ⵙⴾⵏⵓⵏ ⵓⴰ ⴾⵓⵏⵓⵔⵏ ⵎⵔⴹⴰ ⴶⵔⵓⵏ ⴹⵎⵛⵏⴰ ⵎⵛⵏ ⵓⵔ ⵙⵔⵙ ⵜⵤⴶⵤⵏⵎ⵰ ⵎⵔⵏ ⵏⵀⵤⵏ ⵏ⵿ⵜⴾⵙⵏ ⴹⵜⴾⵔⵓⵜⵏ ⵤⴶⵤⵏⵏ ⵙⵔⵙ⵰ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵏⵢⵎ ⵓⵏ ⵎⵛⵏ ⵓⵔ ⵙⵔⵓⵏ ⴹⵓⵢ ⵜⵎⴶⵔⵙ⵿ⵜ ⵓⵍⵢⵜ ⵏⵔⴾ ⵎⵤⵍⵏⵓⵏ ⵏ⵿ⴶⵎ ⵤⴰ ⵜⵤⴶⵤⵏⵎ ⵙⵔⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ⵙⵙⵎⵜ ⵢⵍⵆⵙⵜ ⵢⵜ ⵜⵎⵙⵜ ⵍⵎⵜⵍ «ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⵢⵏ ⵏⵀⵍⵏ ⵍⵗⵏⵀ ⴹⵗ ⵎⴹⵍⵏⵜ ⵙⵗⵍⵢⵜⵓ ⴼⵔⴶ ⵤⵗⵤ ⴹⵗⵙ ⵜⴶⴹⵢⵜ ⵜⴰ ⴹⵗ ⵜⵓⵤⵎⵓ ⵍⵗⵏⵀ⵰ ⵙⴾⵔⵙ ⴶⴰ ⵂⴾⵏ ⵙ ⵤⴶⵔ ⵓⴹⵏ ⵓⴰ ⴶⵤⵏ ⴼⵔⴶⵏ⵰ ⵜⵤⵔ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜⵏ ⵢ ⵎⴶⵢⴾⵏ ⵓⵢⴹ ⵛⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ⵙ ⴹⵜⵂⵤ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⵎⵍⵢ ⵏⵍⵗⵏⵀ ⵤⵎⵤⵍ ⴾⵍⵏⵜ ⵙ ⵎⴶⵢⴾⵏ ⵓⵏ ⵗⴼⵔⵏⵏ ⴼⵔⴶⵏⵜ ⵢⴹⵙⴹⵓⵢⵏ ⴹⴶⵔⵏⵜ ⴹⵗ ⵍⵗⵏⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ⵎⵛⵏ ⵀⵤⵏ ⵎⴶⵢⴾⵏ ⵓⵏ ⴾⵍⵏ ⵓⵏ ⴶⵏ ⵢⵢⵏ ⴹⵗⵙⵏ ⵛⵓⵜ ⴶⵏ ⵎⵏ ⵏⵓⴰ ⵂⴹⵏ ⴹ ⴶⵔⵏ ⵓⵏ ⴾⵔⴹ ⵙ ⵜⵂⵏ ⵂⵔ ⵜⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ⵍⵙ ⵎⵛⵙ ⵏⴼⵔⴶ ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⴾⵍⵏ ⵓⵢⴹ ⴶⵔⵏⵏ ⵓⵏ ⴹⵏ ⴶⵜ ⵎⵛⵏ ⴶⵏⵙⵏ ⵎⴹⵏ ⵓⵏ ⵗⴼⵔⵏⵏ ⴼⵔⴶⵏ ⵓⴰ ⴹⵗ ⴶⵏ ⵢ ⵓⵏ ⴹⵏⵤⵎⵤⵍ ⴹⵜ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ⵜⵤⵔⵙ⵿ⵜ ⵏⵓⵏ ⵙ ⵙⵔⵙⵏ ⵤⵎⵤⵍ ⵀⵔⵔⵏⵜ ⴼⵍⵙ ⵏⴰ ⴹⵗ ⵎⵏⵜ \"ⴹⴹ ⵤⵎⵙ ⵀⵔⵔⵏ ⵓⴰ ⵎⴾⵏ ⵙ ⴹ ⵜⵙⵗⵎⵔⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ⵎⵛⵏ ⵙ ⵏⵢⵏ ⵎⴶⵢⴾⵏ ⵓⵏ ⵀⵔⵔⵏⵜ ⵏⵎⵏⵏ ⴶⵔⵙⵏ \"ⵏ⵿ⵜⴰ ⴹⵢ ⵎⴾⵙⵓ ⵏⴼⵔⴶ⵰ ⵏ⵿ⴹⵓⵜ ⵜⵏⵏ⵿ⵗⵓ ⴾⵔⵤ ⴹ ⵏⴾⵙⵜ ⴼⵔⴶ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ⵜⵤⵔ ⵀⵤⵏ⵿ⵜⵓ ⴾⵙⵏ⵿ⵜⵓ ⴹⵗ ⴼⵔⴶ ⵏ⵿ⵗⵏ⵿ⵜⵓ ⴾⵔⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴾ ⵙ ⴹⵙⴰ ⵎⵛⵙ ⵏⴼⵔⴶ ⵏⵍⵗⵏⵀ ⵓⵏ ⵎⴰ ⵤⴶⵓ ⵢ ⵎⴶⵢⴾⵏ ⵏⵍⵗⵏⵀ ⵓⵏ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ⵌⵌⵢⵏ ⵢⵜⴹⵏ ⵏⵏⵙ «ⵙ ⴹⵙⴰ ⵤⴰ ⴹ ⵗⵔⴹ ⵜⵏⵗⵢ ⵏⵎⴾⵙⵏⵏ ⵓⵏ ⴹⵢ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜ ⵢ ⵎⴶⵢⴾⵏ ⵓⵢⴹ ⴹⵙⴹⵤⵜⵓⵢⵏⵏ ⵜⵏ⵿ⴼⴰ ⴹⵗ ⵜⵎⵔ⵿ⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ \"ⵜⵂⵏ⵿ⵜ ⵜⴰ ⴹⵏⴶⵔⵏ ⵎⴾⵔⵙⵏ ⵏ⵿ⵜⴰ ⵜⵆⵍⵜ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⴾⵀⵍⵜ ⵂⵏ ⵔⵜ ⵓⵏ ⵎⵍⵢ ⴹⴼⵍ ⵎⵔⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵎⵍⵗⵓⵏ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⵗⵓⵏ ⵜⵜⵔⵎⵙ ⵜⵜⵓⴾⴼⵓ ⵢ ⵜⵎⵜⵢ ⵜⴰ ⴹⵗⵙ ⴹⵤⵜⵓⵢⵜ ⵜⵏ⵿ⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ⵓⴹⵏ ⵓⴰ ⴹⵏ ⴼⵍ ⵜⵂⵏ⵿ⵜ ⵜⵏ ⴹ ⴹⴶⴹⴶ ⵓⴰ ⴼⵍ ⵜⴹⴰ ⴹⵗ ⵜⵜⵍⴾⵛ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ⵙ ⵙⵍⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⴼⵔⵙⵢⵜⵏ ⵢⵍⵎⵜⵍⵏ ⵓⵏ ⴶⴰ ⵗⵢⵙⴰ ⴹⵏ ⴶⵔⵏ ⵙ ⵏ⵿ⵜⵏⵢ ⴼⵍ ⵎⴶⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ⴹ ⴶⵎⵢⵏ ⵎⴾ ⵓⵙ ⵜⵤⵙⵜⵔⵎⵙⵏ ⵎⵛⵏ ⴾⵙⴹⵏ ⵜⵎⵜⵢ ⴼⵍⵙ ⵜⴶⴰ ⵢ ⵗⵢⵙⴰ ⴹⴼ ⵏⵙ ⵏⵀⵢ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ⵍⵙ ⵗⵢⵙⴰ ⴶⵙⵏ ⵍⵆⵙⵜ ⵢⵜ ⵜⵎⵙⵜ ⵍⵎⵜⵍ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵎⵏⴾⵍ ⵢⵏ ⵙⵙⴶⵏ ⵙⴾⵙⵙ ⴹⵗ ⵜⴾⵔⵙ⵿ⵜ ⵏⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ⵤⵎⵤⵍ ⴾⵍⵏⵜ ⵢⴹ ⵎⵍⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵔⴰ ⴹⴶⵤⵏ ⵙⴾⵙⵙ ⵓⵏ ⵎⵛⵏ ⴶⵢⵏ ⵙⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ⵍⵙ ⵤⵎⵤⵍ ⵏⴾⵍⵏⵜ ⵓⵢⴹ ⵢⴹ ⵏⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵏ \"ⵏⴾ ⵙⵎⵜⴶⵗ ⵎⴶⵔⵏⵏ ⴶⵤⵎⵗ ⵤⴶⵔⵏⵏ ⴹⵂⵔⵏⵏ ⵓⵏ ⴹⵔⵜⵏⵏ ⵔⵜ ⴾⵍ ⵎⵜⴶ ⵎⵔⴹⴰ ⴶⵍⵓⵜⴹⵓ ⵎⵔⵏ ⴹ ⵏⵙⵏ⵿ⵜⵓ ⵙⴾⵙⵙ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ⵎⵛⵏ ⴶⵎⴹⵏ ⵀⵜⵏⵜ ⵓⵢⴹ ⴾⵏ ⵛⵓⴶⵙⵏⵙⵏ ⵓⵢⴹ ⴾⵏ ⴹⴶⵏ ⵓⵏ ⴹⵗ ⵙⵜⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ⵜⵤⵔ ⵀⵤⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵎⵤⵍⵏ ⵓⵏ ⴹⵏ ⴶⵏⵙⵏ ⵜⵔⵛⵈⵛⴹ ⵏ⵿ⵗⵏ⵿ⵜⵏ ⴾⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ⴶⵤ ⵍⵂⵎ ⵍⵀⵙⵏ ⵎⵏⴾⵍ ⵙⴶⵍⴰ ⵙⵌⵜⵏⵜ ⵗⵔⴹⵏ ⵜⵏⵗⵢ ⵏⵎⴶⵏ ⵏⵎⵏ ⵓⵏ ⴹⵏ ⵗⵔⴹⵏ ⵙⵆⴹ ⵏⵗⵔⵎⵏⵙⵏ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«ⵜⵤⵔ ⵏⴰ ⵢⴾⵍⵏⵜ \"ⵎⵜⴶ ⵤⴰ ⵓⵏ ⵙⴾⵙⵙ ⴶⵏ ⵎⵛⵏ ⵎⴹⵏ ⵓⵏ ⴹⵏ ⵓⵔ ⵂⵔⵏ ⴹⵎⴶⵔⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ⴹⵗ ⴹⵢ ⴶⵍⵓⵜ ⵜⴾⵎ ⴹⴶⵏ ⵓⵏ ⴹⵗ ⵎⵏⵢⵏⵜ ⵜⵔⵢⵏ ⵜⵗⵔⵎⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵏⵢⵎ ⴹⴾⵏ ⵙⴾⵙⵙ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ⵜⵤⵔ ⴶⵍⵏ ⴾⵍⵏ ⵓⵏ ⴹⵏ ⵗⵔⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵏⵢⵏ ⴶⵔ ⵤⴰ ⵓⵏ ⵍⵗⵏⵏ ⵓⵍⴰ ⵓⵏ ⵎⵙⵏⵏ ⵎⴾⵙⵏⵏ ⵂⵔ ⵗⵔⴹ ⴹⴶ ⵓⵏ ⵙⴾⵙⵙⵏ ⴹⵏⵢ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ⴶⵍⴹⵓ ⵎⵏⴾⵍ ⵢⴹ ⵏⵢ ⵍⵌⵎⵗⵜ ⵜⴰ ⴹⵜⴹⵓⵜ ⴹⵏ ⵢ ⵜⴾⵔⵙ⵿ⵜ⵰ ⵏⵢ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵢⵏ ⵓⵔ ⵏⵍⵙⴰ ⵜⵀⴹⵆ ⵜⵙ ⵂⵔ ⴹⵜⵜⵓⵆⵏ ⵙ ⵜⴾⵔⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ⵏⵙ ⵎⵏⴾⵍ \"ⵀⵤ ⴾⵢ ⴾ ⵎⵙ ⴹⵜⴶⵤⵗ ⴹⴶ ⵓⵔ ⵜⵆⵏⴰ ⵜⵀⴹⵆ ⵜⵙ ⵂⵔ ⴹⵜⵜⵓⵆⵏ ⵙ ⵜⴾⵔⵙ⵿ⵜ⵰\" ⵓⵔ ⴹⵜⴶⵎⴹ ⵜⴼⵔ⵿ⵜ ⵓⵍⵢⵜ ⵎⵢ ⵏⵍⵙ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ⴹⵏ ⴹⵗ ⴹ ⵏⴰ ⵎⵏⴾⵍ ⵢ ⵎⵛⵗⵍⵏⵜ \"ⵀⵤⵜⵓ ⵜⵗⵔⴹⵎ ⴾⵔⴹ ⵏ⵿ⴹⵔⵏⵜ ⴹⴼⵙⵏⵜ ⵜⴶⵔⵎ⵿ⵜⵏ ⵙⴹⵢ ⴹⵗ ⵛⵢⵢ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵂⵍⵏ ⵢⵜⴹⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ⵏⴰ ⵗⵢⵙⴰ «ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵜⵓⵗⵔⵏⵏ ⵎⵛⵏ ⵓⵔ ⴹⵗⵙⵏ ⴶⵜⵏ ⵓⵏ ⵜⵓⵙⵏⴼⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ⴹⴼⵔ ⵓⵏ ⵎⵛⵓⵔⵏ ⴼⵔⵙⵢⵜⵏ ⴹ ⴶⵎⵢⵏ ⵎⴾ ⵙ ⴶⵏ ⵢ ⵗⵢⵙⴰ ⵜⴼ⵿ⵜⵓ ⵔⵏ ⵜⵙⵙⴶⵏ ⵀⵜⵓ ⵜⵤⵜⴶⵜ ⴹⵗ ⵗⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ⵤⵎⵤⵍⵏ⵿ⴹⵓ ⵔⵜ ⴹⵗ ⵏⵍⴾⵎⵏⵙⵏ ⴹⵢⵜⴹⵏ ⵓⵢⴹ ⵓⵔⵏⵏ ⴶⵏⴰ ⵏⵎⵏⴾⵍ ⵂⵔⴹ ⵢⴹ ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵏⵙⵏ ⵙ ⵎⴶⵢ ⵏ ⵜⴹⵜ ⵜⵎⵙⴰ ⵎⵔⵏ ⵜⵙⵙⵗⵔⴰ ⵙ ⵜⴹⵜ ⵓⵙ ⴹⵏⵓⵔ ⴶⵏⵜ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵓⵔ ⵜⵍⴰ ⵢ ⵜⴾⵙⴹⴰ ⴹⵗ ⵓⴰ ⵜⴶⵏⴰ ⴼⵍⵙ ⵓⵔ ⵜⵤⵍⵢⴰ ⴹⵗ ⵍⵎⵆⵎ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ⴹⵗ ⴹⵢ ⵏⵔⴰ ⴹⵗⴾ ⴹⵏⵜⵎⵍⴰ ⵓⴾ ⵈⵍⵍ ⵔⵤⵎ ⵏⵎⵏⴰ ⵢⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵆⵢⵙⵔⴰ ⵎ ⵓⵔ ⵈⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ⵎⵛⵏ ⴶⵔⴰ ⵗⵢⵙⴰ ⵛⵔⵏⵙⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵜⵌⵔⵀⵎⵢ ⵍⵎⵏⴼⵆⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ⵙⴾⵏⵓⵜⵢ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ ⵜⵙ ⵜⵓⵔⵤⵎ ⵎⵏⴰ⵰» ⵜⵤⵔ ⵜⵎⵓⵢⵙⴹⵓ ⵜⴼⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⴰ ⵍⵏ ⵗⴼ ⴹⵙⵎ ⵓⵏ ⵓⵔⵏⵏ ⵜⴼⵍ⵿ⵜ ⵜⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ⵏⵏⵙ «ⵏ ⵆⵢⵙⵔⴰ⵰» ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵢⵜ ⵤⴰ ⴶⵓⵜ ⵢ ⵆⵢⵙⵔⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ ⵜⴶⵎ ⵢ ⵎⵛⵏⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵍⵌⵓⵀ ⵓⵏ ⵢⵏ ⵗⵢⵙⴰ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ⵤⵍ ⵓⵏ ⴹⵗ ⴹⵙⵏ ⵙⴹⵙⵢⵜⵏ ⵎⵙⵏⵏ ⵢⵜⴹⵏ ⴶⵏⵏ ⴹⴼ ⵏⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵏⴾⵔⴰ ⴹⴼⵔ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵂⵤⵏⵏ ⵗⵢⵙⴰ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ");
INSERT INTO ttqt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ⵏⵏⵙ «ⵛⵈ ⵏⵀⵢ ⵎⵙⴰ ⵏⴰ \"ⵙ ⵀⴰ ⵓⴹⵏ ⵓⵔ ⴶⵔⵓ ⵀⵔⵔ ⵓⴹⵢ ⵎⴹⵔⵢⵏⵜ ⵓⵔ ⴹ ⵤⵍⴼ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⴹⵢⴰ ⴹⵏ ⴼⵍ ⴹ ⴶⵓ ⵤⵔⵢⴰ ⵢⵎⴹⵏⵜ ⵓⴰ ⵀⴰ ⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","«ⵏ⵿ⵜⴰ ⵏⴾⵏⵢ ⵂⵏⵏⵗ ⵙⴰ ⵎⴹⵔⵢⵏ⵰ ⵤⵍⴼ ⵓⴰ ⴹⵙⵏⵓⵛⵔⵏ ⴾⵜⵏⵙⵏ ⵀⵜⵓ ⴹⴰ ⵓⵔ ⵍⴰ ⵀⵔⵔ ⵢⴹⵓ ⵜⵏ⵿ⵜⵜⵏⵜ ⵢⵎⴹⵔⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ⴶⴰ ⵓⵏ ⴹⴰ ⴼⵍ ⵎⴹⵔⵢⵏⵜ ⵓⵏ ⴶⵔⵓ ⵓⵏ ⴾⵔⴹ ⵈⵙⵍ ⵜⵜⵤⵍⴼⵏ ⵜⵀⵜⵏ ⴹⴰ ⵓⵔ ⴹⵔⵙ ⵍⵏ ⵀⵔⵔⵏ ⵂⵔ ⵗⵔⴹⵏ ⴼⵍ ⵙⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ⴹⴼⵔ ⵙ ⵜⵏⵀⴰ ⴾⵜⵏⵙⵏ ⵀⴰ ⵜⵏ⵿ⵜⵜ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ⴹⵗ ⴹⵢ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵎⴰ ⵎⵙ ⴹⵗ ⵙⴰ ⵎⴹⵔⵢⵏ ⵓⵏ ⴹⵏ ⵓⵙ ⵤⴰ ⵜⵆⵍ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵜⵗⵔⵙ ⴹⴹ ⵤⵎⵙ ⴾⵜⵏⵙⵏ ⵤⵍⴼⵏ⵿ⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵜ ⵏⵍⵈⵜⴰ ⵜⵜⴼⵎ⵿ⵜⵓ ⴼⵍⵙ ⵓⵔⵎⴹ ⵜⵙⵏⵎ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵓⵍⴰ ⴹⵗ ⵜⵙⵏⵎ ⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵔⵏⴰ ⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ⵙⵏⵜ ⵙ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵓⵔ ⵜⵍⴰ ⵤⵍⴼ ⵢ ⵎⴹⵏ ⵓⵍⴰ ⵛⴹⴹⵏ⵰ ⴾⵍⵔ ⵜⵎⴹⵔ⵿ⵜ ⵤⴶⵏ ⵛⵍⵜ ⵏ ⵜⴰ ⴶⵏ ⵏ⵿ⴶⵍⵙⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ⴹⵗ ⵀⵜⵓ ⵎⵔⵏ ⵜⴰ ⵜⵆⵍⵜ ⵜⵏⴾⵔⴰ ⵏⵎⵜⵏ ⵓⴾ ⴹⵙ ⴾⵓⵏⵓⵔⴶⴰ ⵙ ⵜⵗⵔⵎ ⵓⴰ ⴹⵓⵏⵏⴰ ⵎⵛⵏⴰ ⴹⵗ ⵍⴾⵜⵀⵏ⵰ ⵓⵔⴶⵗ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ⵏⴾ ⵎⵙⵏ ⵎⵍⵢ ⵏⵀⵔⵂⵎ ⵎⵍⵢ ⵏⵙⵂⵆ ⵎⵍⵢ ⵏⵢⵆⵀ⵰\" ⵎⵛⵏⴰ ⵓⵔ ⵎⵙ ⵎⵍⵢ ⵏ ⵜⵎⵈⵙⴰ ⴾⵍⵔ ⵎⵍⵢ ⵏⵓⵏ ⴹⵔⵏⵏ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ⵜⵎⵜⵢ ⵜⴰ ⵜⵙⵍⵜ ⵢⵍⵌⵓⵀⵏ ⵓⵏ ⴹⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵓⵍⵏ ⵙⵙⵗⵔⵢ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ⵙ ⵙⵍⵏ ⴼⵔⵙⵢⵜⵏ ⵙ ⵗⵢⵙⴰ ⴶⴰ ⵍⵌⵓⵀ ⵙⴼⵙ⵿ⵜⵏ ⵙⴹⵙⵢⵜⵏ ⵎⵏⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ⵏ⵿ⴾⵔ ⵢⵏ ⴹⵗⵙⵏ ⵎⵙⵏ ⵎⵙⵏ ⵏⵛⵔⵗⴰ ⵔⴰ ⴹ ⴶⵓ ⵜⵏⴶⵎⵢⵜ ⵢ ⵗⵢⵙⴰ⵰ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«ⵛⵈ ⵎⴰ ⵎⵙ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ ⴹⵗ ⵜⵓⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ⵏⵙ ⵗⵢⵙⴰ «ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ \"ⵔⵓ ⵎⵍⵏⴾ ⵎⵛⵏⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹⵎⵏ ⵔⴹⵏⵏ ⵜⵔⵆⵓ ⴹⵗ ⵙ ⵜⵢⵜⵢⵏⴾ ⴾⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ ⵍⵓⵌⵀⵏ ⴾⵍ ⵎⵙ ⴹⵗ ⵓⴰ ⵤⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ⵎⵔⵏ ⵍⵓⵌⵀ ⴹⴰ ⵓⴰ ⵍⴾⵎⵏ ⵢ ⵓⵏ ⴹⵔⵙ ⵍⵏ \"ⴶⵓ ⵢⵛⵆⵗⵏⴾ ⵜⵔⴰ ⵜⴰ ⵜⴶⵗ ⵢ ⵎⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ⵍⵓⵌⵀⵏ ⵓⵏ ⵛⵏ ⴰ ⵏ⵿ⵜⵏⵢ ⴹⵗ ⵆⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵂⵏ ⵍⴾⵜⵀⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ⴶⵍⵏ ⴼⵔⵙⵢⵜⵏ ⵓⵏ ⴹⵏ ⵍⵏ ⴹⵏ ⴹⴰ ⵎⵏⵢⵏ⵰ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵗⵢⵙⴰ ⵎⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⴹⴼⵏⵓⵏ ⴹⵗ ⵍⵎⵙⵈ⵰ ⵎⴰ ⵜⵏⵎ ⵎⴰ ⵎⵙ ⵀⵏⵜ⵰» ⵏⵏⵙ «ⴹⵢ ⵤⴰ ⴶ ⵎⵏⴾⵍ ⵏⵀⵢ ⴹⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵜⵗⵔⴰ ⵏⵀⵢ ⴹⵓⴹ ⵙ ⵜⵍⵍ⵿ⵜ ⵏⵏ⵿ⴼⵙ ⵓⵏ ⵎⵛⵏⴰ ⵙⵙⵎ ⵓⴰ ⵏ \"ⵎⵍ\"⵰ ⴼⵍⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"ⵏⴰ ⵎⵍⵢ ⵢⵎⵍⵏⵏ 'ⵢⵓ ⵆⵎⵓ ⴹⵗ ⵗⵍⵏ ⵂⵔ ⵗⵔⴹⵗ ⵙⵔⵙ ⵏ⵿ⵤⵏ⵿ⴶⵏⴾ ⴶⵆⵏ ⴹⵓ ⴹⵔⵏⴾ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ⴹⴹ ⵤⵎⵙ ⵗⵔⵢ ⴹⵓⴹ ⵙⵙⵎ ⵓⵏ ⵎⵍⵢ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⵆⵍ ⵀⵔⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵓⵍⵢⵏ ⵍⴼⴹⵏ ⵢ ⵗⵢⵙⴰ ⵓⵍⴰ ⵜⴼⵔ⵿ⵜ ⵢⴹⴰ ⵏⵍⵌⵓⵀ ⵢⵙⵙ⵿ⵜⵏ ⵓⴰ ⴶⴰ ⴹⵏ⵰ ⵎⵔⵏ ⵀⵤⵏ ⵗⵔ ⵤⵍ ⵓⵏ ⵀⵙ ⵜⵍⴰ ⵓⴹⵏ ⵂⵍⵏ ⴹⵙⴶⵓ ⵙⵙ⵿ⵜⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ⴹⵏ ⴹⵗ ⴹ ⵛⵓⵍ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⴹⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵏ⵿ⵜⵏⵢ ⵙⵙⵗⵔⵏⵏ ⵢⵜⴹⵏ ⵛⵔⵗⴰ ⵓⴰ ⴹⵢⴰ ⵏⵀⵢ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ⴹⵗ ⴹⵢ ⵎⵤⵍⵜ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⴾⵓⵏ⵿ⵙⵙⵗⵔⵏ ⵜⵀⵔⴹⴶⵎ ⵢⵓⴰ ⴹⵓⵏ⵿ⴶⵏⵏ⵰ ⵎⵛⵏ ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵏ ⴼⵍⵙ ⵓⴰ ⴶⵏⵏ ⵓⵔ ⴹⵔⵓ ⵔⵜ ⴹⵓⴰ ⵜⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ⵤⴾ ⵤⵓⵔⵏ ⵙ ⵤⵓⵜ ⴶⵢⵏⵜ ⵙⵓⵔⵏ ⵢⵜⴹⵏ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵓⵔ ⵜⵤⴹⵙⵏ ⵙ ⵓⵍⴰ ⴹⴹⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ⵎⵤⵍⵏⵙⵏ ⴾⵍ ⵓⵔ ⵎⵙⵏ ⵔ ⵙⴾⵏⵜ⵰ ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵛⵔⴰ ⵛⵏ ⵜⴾⵏⵔⵏⵙⵏ ⴶⵏ⵿ⵜⵏⵜ ⵛⵢ ⵤⵓⵔⵏⵏ ⵓⵍⵏ ⵤⵤⵓⵔⵏ ⴹⵗ ⵛⵏ ⵜⵆⵏⵏ ⴹⵗ ⵜⴶⵍ⵿ⵜⵎⵏⵙⵏ ⴼⵍ ⴹ ⵍⵏⵜ ⵏⵢ ⵓⵍⵏ⵰ ⵛⵀⵏⴾ ⵏ⵿ⵜⴾⴹⴾⴹⵏⵙⵏ ⴹⵗ ⵀⵍⵏⵙⵏⵜ ⵀⵛⴾⵛⴾⵏ ⵤⴶⵔⵜⵏⵏ ⵍⵏⵏ ⵏⵢ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ⵔⵏ ⵜⵗⵎⵜ ⴹⵗ ⴹⴶⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⴹⵗ ⵎⴶⵔⴰ ⴹⴶⵏ ⵓⵏ ⵍⵏⵏ ⵍⵎⵆⵎ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ⵔⵏ ⴹⵙⵏ⵿ⵜⴶⵏ ⵢⵜⴹⵏ ⵙⵍⵎ ⵏ⵿ⵙⵗⵎⵔ ⴹⵗ ⵙⵎⵏⵢⵏ ⵔⵏ ⴹⵗ ⵜⵏ⵿ⵗⵔⵏ ⵢⵜⴹⵏ ⵙⵙⵎ ⵓⵏ \"ⵛⵈⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«ⵎⵛⵏ ⴾⵓⵏⵢ ⴹ ⵓⵔ ⵜⴶⵎ ⵢ ⵎⵏⵓⵏ ⵙⵎ ⵓⵏ ⵛⵈ ⴼⵍⵙ ⴾⵓⵏⵢ ⵛⵈ ⵢⵏ⵿ⴹⴰ ⵜⵍⵎ ⵎⵔⵏ ⴾⵜⵏⵓⵏ ⵎⴹⵔⵢⵏ ⵜⵎⵙⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ⴹ ⵓⵔ ⵜⵗⵔⵎ ⴹⵗ ⵢⵏ ⴹⵗⵓⵏ ⵙⵙⵎ ⵓⵏ ⵀⴰ ⴹⵗ ⴹⵏⵜ ⴼⵍⵙ ⵀⴰ ⵢⵏ⵿ⴹⴰ ⵜⵍⵎ ⵜⵎⵙⵏ ⵀⴰ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ⴹ ⵓⵔ ⵜⵔⴹⵎ ⴹⵗ ⵜⵓⵏⵓⵏ \"ⵛⵈ\" ⴼⵍⵙ ⵛⵈ ⵢⵏ⵿ⴹⴰ ⵜⵍⵎ ⵜⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ⵓⴰ ⴹⵗⵓⵏ ⵎⵙⵏ ⵎⵤⵔ ⵓⴹⵢ ⴹ ⵆⵍ ⵤⵏ ⵎⵛⵗⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ⵢ ⴹⴾⵍⵏ ⵎⵏⵜ ⴹ ⵜⵙⵔⵙ ⵎⵛⵏⴰ ⵢ ⵙⵔⵙⵏ ⵎⵏⵜ ⴹⵗ ⴹ ⵜⴹⴾⵍ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⴾⵓⵏⵢ ⵎⵙⵏⵏ ⵢⵢⵜⴹⵏ ⵤⵏ ⵜⵙⵂⵔ⵿ⵜ ⵜⵗⴼⵍⵜ ⴶⵔⵙⵏ ⴹⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ⵰ ⴼⵍⵙ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⴰ ⵓⵔ ⵜⴶⵤⵎ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⴶⴹⵍⵎ ⴹⵗ ⴶⵤⵏⵜ ⵢ ⵓⵏ ⵜⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⵜⵜⵎ ⵂⵔⵢ ⵏ⵿ⵜⴹⴹⵏ ⵛⵏ ⵙ ⵀⴰ ⵎⴹⵏⵙⵏⵜ ⵎⵔⵏ ⵜⵜⴶⵎ ⵎⴹⵏ ⵤⴶⵔⵜⵏⵏ ⵓⵔ ⵏⵎⵙ ⵔ ⵙⴾⵏⵢ⵰ ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵜⴹⵀ ⵓⵏⵓⵏ ⴹ ⴶⵔ ⵜⴹⵀⵏ ⴾⵍ ⵜⵍⵀⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⵛⴾⵍⵎ ⵜⵙⵓⵍⵎ ⴹⴶⵏ ⴾⵍ ⴼⵍ ⵎⴹⵍ ⴹⴶⵔⵓⵏ ⵜⴶⵎⵢⵎ ⴾⴹⵗ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵙⵔⴹⵎ ⵙⴹ ⵍⴾⵎ ⵢⵙⵙⵗⵔⵢ ⵓⵏ ⵜⵓⵔⵜ⵰ ⵎⵔⵏ ⵙ ⵙⵔⵙ ⵜⵙⵔⴹⵎ ⵓⴹⵏ ⵜⵜⴶⵎ ⵓ ⵌⵂⵏⵎⴰ ⵂⵔ ⵙ ⵍⵗⵤⵀ ⵓⴰ ⵤⴶⵓ ⴹⴶⵓ ⵛⵏ ⵏⴹⴼⵙⵏ ⴼⵍ ⵓⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵤⵔⵏ ⴹⵔⵗⵍⵏⵏ⵰ ⴾⵓⵏⵢ ⴶⵏⵏⵏ ⵙ ⵂⴹ ⵓⴹⵏ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⴹⵢ ⵓⵔ ⵎⵙ ⵓⵍⴰ ⵎⵛⵏ ⵙ ⵂⴹ ⵙⵔⵗ ⵓⴰ ⵂⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⴹⵢ ⵜⵂⴹⵢⵏⵜ ⵜⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ⵎⵙⴾⵍⵏ ⵏⵎⴹⵔⵗⵍ⵰ ⵓⴾ ⵔⵗ ⴶⵔⵏ ⵍⵎⵆⵎ ⵎⵗ ⴾ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⵙⵏ⵿ⵜⴰ ⵤⵤⴹⴶⵏ ⵔⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ⵎⴹⵗ ⵜⵏⵎ \"ⵙ ⵂⴹ ⵓⴹⵏ ⵙ ⵎⵌⵎⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙⵆⴹ ⵏ⵿ⵜⴾⵜⵓⵏ ⵓⴹⵢ ⵜⵂⴹⵢⵏⵜ ⵓⵔ ⵜⵎⵙ ⵓⵍⴰ ⵎⵛⵏ ⵙ ⵂⴹ ⵙ ⵜⴾⵜⵢ ⵜⴰ ⵜⵓⵔⵜ ⵎⵌⵎⵔ ⵓⴹⵢ ⵜⵂⴹⵢⵏⵜ ⵜⴶⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ⵎⴹⵔⵗⵍ ⵓⵏ⵰ ⵓⴾ ⵜⴾⵜⵢ ⵜⴶⵔⵜ ⵍⵎⵆⵎ ⵎⵗ ⵎⵌⵎⵔ ⵓⴰ ⵜⵜⵤⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ⵙⵏⵜ ⵙ ⵓⴹⵏ ⵓⴰ ⵂⴹⵏ ⵙ ⵎⵌⵎⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙⵆⴹ ⵏ⵿ⵜⴾⵜⵓⵏ ⵓⴹⵢ ⵓⴰ ⵓⵔⵏ ⵎⵌⵎⵔ ⴹⴰ ⵂⴹ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ⵓⴹⵏ ⵓⴰ ⵂⴹⵏ ⵙⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⴹⵢ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵂⴹ ⴹⵓⴰ ⵜⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⵂⴹⵏ ⵙ ⵌⵏⵓⵏ ⵓⴹⵢ ⵜⵈⵓⵜ ⵜⵏ ⵜⵗⵎⵔ ⵏⵎⵛⵏⴰ ⵙ ⵂⴹ ⴹⵓⴰ ⴼⵍⵙ ⵆⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⵜⴾⵙⵎ ⵜⵎⵙⴹⴾ ⴹⵗ ⵏⵗⵏⵗ ⴹⵗⵏⵜ ⴹⵍⴾⵎⵏ ⵎⵔⵏ ⵜⵢⵎ ⵔⵜⵏ ⵓⵏ ⴶⵔⵏⵏ ⵙⵂⵜ ⴹⵗ ⵍⵆⵏⵏ ⵜⵏ ⵎⵙⵏ ⵛⵔⵗⴰ ⵜⵂⵏⵏ⵿ⵜ ⴹⵤⴶⵤⵏ⵰ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵏ⵿ⵜⵏⵢ ⵤⵔⵏⵏ ⵓⵔⴾⵓⵏ ⵜⵏ⵿ⵜⵎⵤⵍⵎ ⴹⴰ ⵓⵔ ⴹⵏ⵿ⵜⴶⵍⵎⵎ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ⵎⵤⵔⵏ ⴹⵔⵗⵍⵏⵏ⵰ ⵜⵤⵤⴹⵔⵎ ⵎⵏ ⵢⴹⵗⵙⵏ ⵜⴾⵙⵎ ⵛⵤⵀⵓⵏ ⵎⵔⵏ ⵜⵍⵎⵤⵎ ⵍⵎ ⵗⵔⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ⵰ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⵤⵤⴹⴶⵎ ⴼⵍⴰ ⵏⵙⵍⴾⵓ ⴹⵗⵤⵓ ⵎⵛⵏ ⵎⵙⵏⵙⵏ ⵌⵔⴶⵏ ⴼⵍⵙ ⴹⵏⵢ ⵜⵔⴾⵀⵜ ⴹⵔⴾ ⴹⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ⴼⵔⵙⵢ ⴹⵔⵗⵍⵏ⵰ ⵤⵤⴹⴶ ⵜⵤⵔ ⵎⵙ ⵏⵙⵍⴾⵓ ⴹⵗⵤⵓ ⴹⵢ ⴹ ⵤⵤⴹⴶ ⴼⵍⵏⵜ ⵏ⵿ⵜⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⵍⵎ ⴹⵤⴾⵓⵏ ⴼⵍ ⵜⵓⵙⵍⵙⵏⵏ ⵔⵜ ⵎⵍⵏ ⵂⵙⵢⵏ ⴹⵗ ⵤⵂⵔ ⵎⵔⵏ ⵎⵙⵏⵙⵏ ⴹⵏⵢⵏ⵿ⵜⵓ ⵗⵙⵏ ⵏⵎⵜⵏ ⴹⵤⵏⴼⵏ ⴾⵍ ⵏ⵿ⵜⵌⵔⴶⵏⵏ ⵎⴹⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ⵎⴾⵏ ⴹⵗ ⵜⴶⵎ ⴾⵓⵏⵢ ⴹⴰ⵰ ⴹⵗ ⵤⵂⵔ ⵤⴰ ⵜⵗⴹⵎ ⵎⵛⵏ ⵓⵍⵏⵓⵏ ⵓⵔ ⴹⴾⵔⵏ ⵔ ⵜⵍⵎⵏⴼⵆⴰ ⴹⵜⵍⵀⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⵜⴾⵔⵙⵎ ⵤⴾⵓⵏ ⵢⵏⵀⵜⵏ ⵜⴹⵍⴶⵎ ⵤⴾⵓⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ⵎⵔⵏ ⵜⴶⵏⵎ \"ⵏⵔ ⴹⵏⴶⵤ ⵤⵎⵏ ⵓⵏ ⴹⴶⵤⵏ ⵎⵔⵓⵏⵏⴰ ⵓⵔ ⴹⵔⵙⵏ ⵤⴰ ⵏⵏⵎⵏⴾ ⴹⵗ ⵜⵏⵗⵍⴰ ⵜⴰ ⴶⵏ ⵤⵏⵢ ⵏⵏⵀⵜⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵙⵜⴹⵎ ⵜⵛⵜⵏⵓⵏ ⵂⵢⵓⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵏ⵿ⵗⵏⵏ ⵏⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ⴹⵗ ⴹⵢ ⵙⴾⵙⵓⵜ ⵓⴰ ⴹⵏⴶⵍⵎⵏ ⵎⵔⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ⴾⵜ ⵏ⵿ⵜⵛⵍⵏ⵰ ⵤⵏⴼ ⵏ⵿ⵜⵛⵍⵏ ⵛⵏ ⵂⴰ ⵙⵎ ⵓⴰ ⵍⵀⵙⵏ⵰ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⴹⵔⴶⵎ ⵢⵜⴹⵀ ⵏ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ⵓⵏ ⴹⵗ ⴼⵍ ⴾⵓⵏ⵿ⴹⵙⴾⵗ ⵏⵀⵜⵏ ⴹⵎⵍⵏⵏ⵿ⵜⵢⵜⵢ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⴹ ⵜⴶⵎ ⵎⵏ ⵏⵓⵢⴹ ⵜⵜⵢⵜⵢⵎ⵿ⵜⵏ ⴼⵍ ⵜⴶⵜⵓⵏ ⵜⴶⵎ ⵛⵓⵜ ⵏⵍⴾⴹ ⵢ ⵓⵢⴹ ⴹⵗ ⵏⵏⵓⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵜⵍⵎⵎ ⴶⵔ ⵗⵔⵎⵏ ⵜⴹⴶⵤⵎ⵿ⵜⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ⴼⵍ ⴾⵓⵏⵓⵔ ⵍⵈⵆ ⴾⵍ ⵏⵤⵏⵢ ⵓⴰ ⵜⵓⵏ⵿ⵗⵍⵏ ⴹⵗ ⵜⴹⵍⵎ⵿ⵜ ⴹⵀⵤⵏ ⵗⵔ ⵂⵀⵍⴰ ⵓⵏ ⵍⵗⴹⵍ ⵂⵔ ⵍⵎⵎ ⵤⴾⵔⵢⴰ ⵓⵏ ⴶ ⵀⵔⴾⵢⴰ ⵓⴰ ⵜⵏ⵿ⵗⵎ ⴶⵔ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⴹⵎⵌⵎⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙⵆⴹ ⵏ⵿ⵜⴾⵜⵓⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵔⵜⵏ ⵓⵏ ⵎⵍⵗ ⴹⵢ ⴾⵍ ⴹ ⴶⵏ ⴼⵍ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«ⵈⴰ ⵢⵜⴹⵏ ⵏⵢⵔⵙⵍⵎ ⴾⵜ ⵜⴶⵎ ⵎⵏ ⵏⵏⵀⵜⵏ ⵜⵏ⵿ⵗⵎ ⴹⵗ ⵙ ⵜⴶⵔ ⵏ⵿ⵜⵂⵏ ⵓⵏ ⵙⵔⵓⵏ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵂⵔ ⵎⵏⴾⵜ ⵜⴾⵍⵜⵏ ⴶⵎⵢⴰ ⴹⴾⵓⵏ⵿ⴹⵛⴹⵓⴰ ⵙⵎⴾ ⵙ ⴹⵜⵛⴹⵓ ⵜⴾⵌⵜ ⴾⵔⵜⵏⵜ ⴹⵓ ⴼⵔⵜⵏⵜ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ⵏⵢⵜ ⵤⴰ ⵂⵏⵓⵏ ⴹ ⵜⵓⵢⵓ ⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⴹⵤⵜⵍⵙⵎ ⵏⵢ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵂⵔ ⵤⵍ ⵓⴹ ⵤⴰ ⵜⵏⵎ \"ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ ⴶⵔⵓ ⵔⵈⵎⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵀⵜⵜⵏ ⵛⵏ ⴹⵏ ⴶⵎⴹ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴶⵍⴰ⵰ ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵢⵜⵏ⵿ⵙⵙⴶⵔⵏ ⵜⵎⴾⵔⵙ⵿ⵜ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵜⵂⵏⵢⵎ ⴾⵔⵙ ⵓⴰ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴰ ⵜⵂⵏⵢⵎ ⴹⴰ ⴾⵜⵏⵜ ⵓⵔ ⴹⵗⵙ ⴹⵤⵆⵎ ⵜⵂⵏ⵿ⵜ ⵜⵓⵔⵜ ⵜⵎⴹⵜⵏⵜ ⴾⵜⵏⵜ ⴹ ⵜⵓⵌⵀⵔⵌⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ⴹⴼⵔ ⵓⵏ ⴶⵍⴰ ⵆⵎ ⴼⵍ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ⵰ ⵂⵤⵏ⵿ⵜⵏ ⵏⵜⵍⵀⵏⵜ ⵗⵙⵏⵙⵏ ⵏⵏⵙ «ⵎⵍⵏⵗ ⵎⵢ ⴹ ⵤⴶⵓ ⵔⵜ ⵓⴹⵢ ⵜⵎⵍⵗⵏⵗ ⵍⵗⵍⵎⵜ ⵜⴰ ⵤⴰ ⵜⵙⴾⵏⵜ ⵙⵏⴾ ⴹⵗⵔⴹ ⵏⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏ⵿ⴾⴹⵜ⵰ ⴾⵓⵏⵓⵔⵙⵈⵔⴾ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ⴼⵍⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵤⵙⵏⵏ ⵜⴼⵏ ⵙⵎⵏ ⴾⵢⵏ ⴹⵗⵙⵏ ⴶⵏⵓ ⵎⵙ ⵍⵎⵙⵈ⵰ ⵎⵔⵏ ⴹ ⵙⵈⵔⴾⵏ ⵙⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ⴹ ⵜⵙⵍⵎ ⵢ ⵜⵔⵎⵆ ⵏⵎⴶⵔⵏ ⴹⵙⵍⵏ ⵏⵎⴶⵔⵏ⵰ ⵎⵛⵏ ⵏ⵿ⴾⴹⵜ ⵢⴾⵓⵏⵙⵔⵎⵗ ⵓⵏ ⴼⵍⵙ ⵔⵜⵏ ⴹⵢ ⵙ ⴾⵏ⵿ⴹⵀⴰ ⴶⵏ⵰ ⵎⵛⵏ ⵓⵔⴶⵗ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵜⵤⵔⵙ⵿ⵜ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ⴹ ⴾⵏⵙⵏⵜ ⴹⵓⵍⵜⵏ ⴶⵔⵙⵏⵜ ⴾⵏⵙⵏⵜ ⵜⵗⵎⵔⵏ ⴶⵔⵙⵏⵜ⵰ ⵎⵍ⵿ⵜⵓ ⵍⵤ ⵍⵀⵙⵏ ⴹⵏⴶⵢⵏⴶⵢⵏ ⵏⵎⴹⵍ ⴹⵗ ⴹⴶⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ⵎⵛⵏ ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵓⵔ ⵎⵙⵏ ⵔ ⵏⵜⵢ ⵏ⵿ⵜⵍⵓⵢⵜ ⵜⵂⵜ ⵍⵎⵜⵍ ⵏ⵿ⵜⴰ ⴹⵜⵜⵤⵔⵜ ⵙ ⵜⵏ⵿ⵜⵜ ⵜⵜⴶⵤⵜ ⵎⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ⴹⵢ ⴹ ⵤⴰ ⵜⵜⵓⴶⵎ ⴹⵗ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⴹ ⵜⵜⵓⵏ⵿ⵗⵎ ⵜⵜⵓⴶⵤⵔⵎ ⴹⵗ ⵜⵎⵜⵓⵏ ⵏⴹⵏⵜ ⴾⵍ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ⵔⵜ ⵓⵏ ⴹⵓⵢ ⵙⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵜⵏⴶⵎⴹ ⵤⴶⵤⵏⵙⵏ ⴹ ⵜⵏⵎⴾⴹⵍⵏ ⵏⵎⴶⵤⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ⴹ ⵜⵎⵍⵏ ⵏⵀⵜⵏ ⵏⵀⵂⵓ ⴶⵜⵏⵏ ⵤⵙⵈⵔⴾⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ⴹ ⵜⵜⵜⵢ ⵜⵍⵀⵙ⵿ⵜ ⵂⵔ ⵙ ⵜⵛⵎ ⵏⵢⵜⴹⵏ ⴹⵗⵙⵏ ⵜⴼⵏⵤ ⵜⵔⴰ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ⵎⵛⵏ ⵓⴰ ⴹⵗⵓⵏ ⵤⵎⵔⵏ ⵂⵔ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵢ ⴹ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵏ ⴹⴰ ⴹ ⵜⵓⵎⵍⵏ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ ⴼⵍ ⴹ ⵙⵍⵏⵜ ⵜⵎⵜⵓⵏ ⴾⵍ ⵏⴹⵏⵜ ⵜⴶⵢⴰ ⵜⴰ⵰ ⴹⵢ ⵎⵔⵏ ⴹⵤⵜⵓⴹ ⵜⵤⵔⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵙ ⵜⵏⵢⵎ \"ⵜⵈⵔⵎ⵿ⵜ ⵜⴰ ⵙⴾⵙⴹⵜ\" ⵜⴰ ⵎⵍ ⵏⵀⵢ ⴹⵏⵢⵍ ⵜⵂⴰ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵓⴹⵢ ⵓⴰ ⵗⵔⵏ ⴶⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴹⴶⴶⵏⵜ ⵙⴹⵗⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ⵓⴹⵏ ⵓⴰ ⵆⵎⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⴼⵍⴰ ⵏⵂⵏⵜ ⴹⵓⵔⵤⵀⵜ ⵢⴹⵏⴹⴾⵍ ⵔⵙ ⵂⵏ ⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ⵓⴹⵏ ⵓⴰ ⵂⵏ ⵜⵓⴶⵙ⵿ⵜⵏⵜ ⴹⵓⵔⵆⵍ ⵗⵢⵓⵏⵜ ⴶⵎⵢ ⵙⵍⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ⴾⵜ ⵍⵗⵤⵀ ⴹ ⵜⴶⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⴶⵏⵏ ⵛⴹⵙⵏ ⴹⵛⵏ ⵙⵏ⵿ⴾⵙⵏⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ⴶⵎⵢⵜ ⴹⵗ ⵎⵛⵏⴰ ⴼⵍ ⴹⵓⵔⵎⵤⵢⵜ ⴹⴶⴶⵏⵓⵏ ⴹⵜⵎⵔ⵿ⵜ ⵏⵙⵎⴹ ⵔ⵿ⵜⵢⵏ ⴹⴾⵏⴾ ⵎⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ⴼⵍⵙ ⴹⵏ ⵓⵏ ⴹⵏ ⵜⵜⵎⵍ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⵙ ⴹⵜⵏ⵿ⵜⴰ ⴹⵏⵜ ⵓⵔ ⵜⵜⵓⵏⵢ ⵛⵢ ⵓⵔ ⵜⴶⵔ⵰ ⵎⵔⵏ ⵓⵔ ⵍⴾⵎ ⴹⵗ ⴹ ⵜⵜⵓⵏⵢ ⵜⵍⵜⵏⵜ ⴹⴼⵔ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ⴾⵏ⵿ⴹⵀⴰ ⵙ ⴹⵏ ⵓⵏ ⴹⵏ ⴾⴼⵏ ⵎⵍⵢ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵢ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⴹⵤⵔⴶⵏ⵰ ⴾⵍⵔ ⴹ ⵜⵓⵤⴶⵤⵍⵏ ⴼⵍ ⴹⵍⵍ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵏⴼⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ⴹⵢ ⵎⵔⵏ ⵙ ⴹⵓⵏⵏⴰ ⵓⴹⵏ \"ⵏⵢⵜ⵰ ⵍⵎⵙⵈ ⵍⴰ ⴹ\" ⵎⴹⵗ \"ⵍⴰ ⴹⵏ\" ⴹⵙⵓⵔ⵿ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ⴼⵍⵙ ⴹ ⵜⵎⵍⵏ ⵍⵎⵙⵈⵏ ⵏⵀⵂⵓ ⵎⵍⵏ⵿ⵜⵓ ⴹⵗ ⵏⵀⵜⵏ ⵏⵀⵂⵓ⵰ ⴹ ⵜⴶⵏ ⵍⵗⵍⵎⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵜⵢⵏⵏ ⵂⵔ ⵙ ⵏⵔ ⴼⵔⴶⵏ ⵓⵏ ⵙⵈⵔⴾⵏ ⵢⵜⴹⵏ ⵂⵔⴾⴹ ⵓⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴹⵎⵏⵓⵏ⵰ ⵔⵜⵏ ⵓⵏ ⴶⵗⵓⵏ⵿ⵜⵏ ⴹⵓ ⵗⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ⵎⵔⵏ ⵙ ⴹⵓⵏⵜⵓⵏⴰ \"ⵏⵢⵜ ⵍⵎⵙⵈ ⴹⵏ ⵂⴰ ⵜⵏⵔⵢ\" ⵜⵓⵔ⵿ⵜⴾⵎ⵰ ⵎⴹⵗ ⵜⵓⵏⵓⵏ \"ⵏⵢⵜ ⵂⴰ ⴹⵗ ⵂⵏ ⴹⴶ ⵓⴰ ⴶⵔⵏ ⵍⵗ\" ⴾⵛⴹⵢ ⴹ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵓⵍⴰ ⴹⵗ ⵀⵜⵜⵏ ⵛⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ⵙⵏⵜ ⵙ ⵙⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵍⴰ ⴹⵙⵎ ⴹⵤⵙⵏ⵿ⵜⵏ ⵀⵍⵤⵍⵤ ⴹⴰ ⴹⵏ⵿ⵜⴰ ⴹⵏⴶ ⵂⵔ ⴹⴰ ⴹⵔⵤ ⵜⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ⴹⴶ ⵜⴶⵤ ⵜⵎⵈⵙⵢⵜ ⴹⵗⵙ ⴹⵓⵏ ⵌⴹⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵜⵔⵎⴹ ⴹⴼⵔ ⴹⵏ ⵏ⵿ⵜⵙⵙ⵿ⵜ ⵜⴰ ⵍⵀⵙⵜ ⵏ ⴹ ⵍⵙⵏⵜ ⵛⵢⵢ ⵜⴼⴾ ⵜⵍⵜ ⴹⵗ ⴶⵎⴹⵜⵜ ⵏⵔⵏⵜ ⵔ⵿ⵜⴾⵏ⵿ⴹⵓ ⵜⵔⵏ ⵏⴶⵢⵏⴶⵢⵏⵜ ⵜⵈⵍⴾ ⵛⵏ ⵍⵏⵏ ⵜⵔⵏⴰ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ⴹⵢ ⴹⵤⵜⵏⴼⵍⵍ ⵍⵗⵍⵎⵜⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⵌⵏⵓⵏ⵰ ⵛⵎⵜⵓⵏ ⴾⵍ ⵏⴹⵏⵜ ⴹ ⵙⴾⵔⵢⵏⵜ ⵜⵤⵔ ⵏⵢⵏⵜⵢ ⵏⴾ ⴶ ⴶⴹⵎ ⵙ ⴹⵤⵙⴰ ⵂⵗ ⵛⴶⵏⵓⵏ ⴾⵏⵗ ⵜⵍⴰ ⵏ⵿ⵜⵔⵏⴰ ⴹⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ⵜⵤⵔ ⵏ⵿ⵙⵗ ⵏ ⵙⴾ ⵤⵎⵤⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵏ⵿ⴶⵍⵙⵏⵏ ⵛⴹⵓⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵓⵏ ⵙⵏⴼⵔⵏⴰ ⴹⵗ ⵜⵗⵎⵔ ⵏ ⴾⵤⵜ ⵏⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ⵏⵙⵏ «ⵀⵤⵜ ⵍⴼⵢⴹⵜ ⵙⵍⵎⵜⵍ ⵓⵏ ⵛⴾ ⵏ⵿ⴼⴶ⵰ ⴶⴹⴰ ⴹ ⵂⵙⵢⵏ ⵍⴹⵍⴹⵏⵜ ⴶⵤⴹⵓ ⵛⵏ ⵜⵏⵤⵔⴰ ⴹ ⵜⵙⵏⵎ ⵙ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⴾⵙⴰ ⵜⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⵗ ⵙ ⵙ ⵜⵏⵢⵎ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵓⵏⵎⵍⵗ ⴹⵢ ⵜⵙⵏⵎ ⵙ ⵗⵔⴹ ⵏⴹⵏⵜ ⵂⵤ ⵓⵔ ⵍⴰ ⴶⵔⵓⵏ ⴹⵔⵙ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵎⵜⵢ ⵜⴰ ⴹⴰ ⵏⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ ⴹ ⵜⵏⵢ ⵏⵜⵢ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵍⴾⵎ ⴹ ⵀⵙ ⵜⵍⵏ ⵎⵛⵏ ⵀⵜⵜⵏⵏ ⵍⵏⵜⵓ ⵂⵔ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵤⵍ ⵎⵔⵏ ⵓⵍⴰ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵤⴶⵓ ⵓⴰ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⵙⵏⵏ ⴶⵔ ⵤⴰ ⵏ⵿ⴶⵍⵙⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⵓⵍⴰ ⵀⵔⵔ ⵎⵏⵜ⵰ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⵙⵏⵏ ⵔ ⵀⴰ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ⵓⴰ ⴶⵏ ⴹⵗ ⵤⵎⵏ ⵏⵏⵀⵢ ⵏⵈ ⵤⴶⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵗ ⴹⵤⵙⴰ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ⵜⵙⵏⵎ ⵙ ⴹⵏ ⴹⵜ ⵍⵓⵀⵍ ⵢⵜⴹⵏ ⵜⵜⵏ ⵙⵙⵏ ⵤⵍⴼⵏ ⵤⵤⵍⴼⵏ ⵂⵔ ⵤⵍ ⵓⴰ ⴹⵗ ⴶⵤ ⵏⵈ ⵗⵍⵍ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ⵓⵔ ⴶⵏ ⵛⴾ ⴹⵗ ⵔⵜ ⵓⵍⵢⵏ ⵂⵔ ⴹⵓⴹ ⵍⵓⵀⵍ ⵗⵔⴹⵜⵏ ⵀⵜ ⴾⵜⵏⵙⵏ⵰ ⵤⵏ ⵓⵏ ⴹⵗ ⵤⴶⵏ ⵗⵔ ⵙⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ⴹⵢ ⵛⵏ ⵎⴶⵢⴾⵏ ⵏⵎⵛⵗⵍⵏⵏ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵢⴹⴰ ⴹ ⵎⴹⴾⵍ ⵢⵏ ⵜⵓⵢⴹⵓ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ⵙⵏⵜⵜ ⵜⴹⴹⵏ ⵜⴹⵏⵏ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⴹ ⵜⵎⴹⴾⵍ ⵢⵜ ⵜⵜⵓⵢⴹⵓ ⵜⴰ ⵂⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴼⵍⵙ ⵓⵔ ⵜⵙⵏⵎ ⵤⵍ ⵓⴰ ⴹⵗ ⴹⵤⵙⵓ ⵎⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ⵜⵙⵏⵎ ⵓⵍⵏ ⵙ ⵏⵔ ⵙⵏ ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⵎⵤⵢ ⵓⴰ ⴹⵗ ⴹⵤⴹⵍ ⵀⵢⴹⴶ ⵂⴹ ⵓⴹⵢ ⴹ ⴾⵢ ⵙⵎⵜⴶ ⵢⴹⵙⴶⴹⵍ ⵜⵔⵤⵢ ⵏⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⴾⵓⵏⵢ ⴹⴰ ⵙⵎⵜⴶⵜ ⴼⵍⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵙⴰ ⴹⵗ ⵙⵗⵜ ⵜⴰ ⵓⵔ ⵜⵔⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⴾⵍⵢ ⵗⴹⵍⵏ ⵍⵏ ⴶⵔⵢ ⵏ⵿ⵜⴰ ⵙⵏⴼⵔⵏ ⵎⵛⵙ ⵤⵤⵔ⵿ⵜⵓ ⵢⴾⵍⵏⵜ ⵓⵏ ⵂⴹⵜⵏⵏ ⵢⵜⵏⵂⴾⵓ ⵎⵏ⵿ⵙⵓⵏ ⴹⵗ ⵍⵓⵆ ⵓⵙ ⵂⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ⵀⵍⵍ ⴾⵍⵢ ⵓⵏ ⵙ ⴹⵆⵍ ⵎⵛⵙ ⴶⵤⵜⴹ ⵂⴰ ⵛⵗⵍ ⵓⴰ ⴹⵆ ⵆⴹⵢⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴾⵍⵢ ⵓⵏ ⴹ ⵜⵤⵤⵔ ⵎⵛⵙ ⵢ ⵜⵍⵏⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ⵎⵛⵏ ⵏⵔ ⵎⵙ ⵔⴾ ⴾⵍⵢ ⵏⴰ ⴹⵗ ⵎⵏⵜ \"ⵎⵛⵢ ⵍⵍⵜⵏ\" ");
INSERT INTO ttqt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ⵜⵤⵔ ⴹ ⴶⵜ ⵎⴹⵓⵏⵜ ⴹⵔⵓ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⵎⵙⵓⴹⵏⵏ ⵜⵏⵎⵛⵓ ⴹⵔⵙⵏ ⵙⵎⴹ ");
INSERT INTO ttqt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ⵓⴹⵢ ⵍⴾⵎ ⵜⴹⵗⴹⵔ ⵎⵛⵙ ⴹⵗ ⵤⵍ ⴹⵎⵤⵢ ⵓⵔ ⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ⵜⵤⵔ ⴹ ⵜⴶⵜ ⵎⵛⵙ ⵂⵔ ⵜⴾⵙⵏ ⴶⵢ ⴹⴹ ⵜⵓⴶⵏ ⵍⵎⵏⴼⵆⵏ⵰ ⴹⵏ ⴹⴰ ⴹ ⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⵍⵏⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵢ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵤⵍ ⵓⴹⵢ ⵙⴰ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⴹ ⴶⵤ ⵍⵎⵜⵍ ⵏⵎⵔⵓⵜ ⵜⵎⵓⴹⵏ ⵓⵔ ⵏⵤⴹⵢ ⵎⴹⵏ ⴹⴾⵍⵏⵏ ⵀⵍⵏⵙⵏⵜ ⵤⵍ ⵏ⵿ⵜⴾⵔⵙ⵿ⵜ ⵙⵍⴾⴹⵏⵜ ⵢⵎⵤⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ⵙⵎⵙⵜ ⴹⵗⵙⵏⵜ ⵤⴰ ⵓⵔ ⵍⵏⵜ ⵜⵢⵜⵢ ⵙⵎⵙⵜ ⵎⵔⵏ ⵍⵏⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ⵛⵏ ⵓⵔ ⵏⵍⴰ ⵜⵢⵜⵢ ⵤⴰ ⵙ ⴹⴾⵍⵏⵜ ⵀⵍⵏⵙⵏⵜ ⵓⵔ ⵓⵢⵏⵜ ⵓⴹⵢ ⵓⵏ ⵙⵔⵗⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ⵛⵏ ⵍⵏⵏ ⵜⵢⵜⵢ ⵎⵔⵏ ⵙ ⴹⴾⵍⵏⵜ ⵀⵍⵏⵙⵏⵜ ⵓⵢⵏⵜ ⵛⵜⴾⵏ ⵂⴰ ⵓⴹⵢ ⵓⵏ ⵙⵔⵗⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ⵍⵍⵜⵏ ⵎⵤⵍⵢ ⵂⵔ ⵙ ⵀⵤⵜⵏⵜ ⵜⵙ ⴾⵜⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ⵙ ⴶⴰ ⴹⵓⵏⵢ ⵜⴶⴹⵓ ⵜⵗⵔⵜ ⵜⵓⵏⴰ \"ⵎⵤⵍⵢ ⴹⵢ ⵔⴹⵗⵜⴹⵓ ⵙⵍⴾⴹⵜⵙ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ⵜⵤⵔ ⵏ⵿ⴾⵔⵏⵜⴹⵓ ⵜⵎⵓⴹⵏ ⵛⵏ ⵎⵔⵓⵜⵏ ⴾⵜⵏⵙⵏⵜ ⵙⵎⵜⴶⵏⵜ ⵀⵍⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ⵏⵏⵜ ⵛⵏ ⵓⵔ ⵏⵍⴰ ⵜⵢⵜⵢ ⵢ ⵛⵏ ⵂⴹⵜⵏⵏ \"ⵀⵍⵏⵏⴰ ⴶⵤⵏ ⵛⵏ ⵜⵎⵜⵏ⵿ⵜ ⴾⴼⵎⵜⵏⴹⵓ ⴹⵗ ⵓⴹⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ⵏⵏⵜⵙⵏⵜ ⵛⵏ ⵍⵏⵏ ⵜⵢⵜⵢ \"ⴾⵍⴰ ⵓⴹⵏⵏⴰ ⵓⵔ ⴹⵏⵗⵓⴹ ⴹⵔⴾⵎⵜ⵰ ⴶⵍⵎⵜ ⴾⵎⵜ ⵎⵙⵜⴶⵏ ⵏⵓⴹⵢ ⵜⵤⵏ⵿ⵤⵎⵜⴹⵓ ⵓⴹⵢ ⵢ ⵀⵍⵏⴾⵎⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ⵙ ⴶⵍⵏⵜ ⵢⴹⵤⵏ⵿ⵤⵏⵜ ⵓⴹⵢ ⵙⴹⵓ ⵎⵤⵍⵢ ⴶⵤⵏⵜ ⴼⵍⵙ ⵙⵎⵙⵜ ⵜⵎⵓⴹⵏ ⵛⵏ ⵙⵎⵜⴶⵏⵏ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⴶⵓ ⵙⴾⵙⵙ ⵜⵜⵓⵂⵔⴹⵓ ⵜⵙⵂⵔ⵿ⵜ ⵏⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ⴹⴼⵔ ⵓⵏ ⵓⴹⵏⵜⴹⵓ ⵜⵎⵓⴹⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⴹ ⵙⵗⵔⵜⵏⵜ ⵢⵎⵤⵍⵢ ⴶⵏⵏⵜⵙ \"ⵎⵏ⵿ⴹⵎ⵰ ⵎⵏ⵿ⴹⵎ⵰ ⵍⵎⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ⵜⵤⵔ ⵏⵙⵏⵜ ⵎⵤⵍⵢ \"ⴶⵢⵗ ⵙⵍⴾⵏⵗ ⵙ ⵓⵔ ⴾⵎⵜⵤⴹⵢⵗ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴼⵍⵙ ⵓⵔⵎⴹ ⵜⵙⵏⵎ ⵤⵍ ⵤⴰ ⵓⵍⴰ ⵙⵗⵜ ⵜⴰ ⴹⵤⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵗⵎⵔ ⵜⵏ ⵌⵏⵓⵏ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵍⵙ ⵛⴾⵍⵏ⵰ ⵗⵔⴹⵓ ⴾⵍⵏⵜ ⵜⵏⵙⵗⵍⴼ ⵔⵤⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ⴾⴼⴰ ⵢⵏ ⴹⵗⵙⵏ ⵙⵎⵙⵜ ⵜⵙⴶⵔⵙ ⵏ⵿ⴹⵏⵔⵏ ⵏⵔⵗ ⴾⴼⴰ ⵓⴰ ⵂⴹⵏ ⵙⵏⵜⵜ ⴾⴼⴰ ⵢⴹⴰ ⵢⴾⵍⵢ ⵓⵏ ⴾⵔⴹ ⴹⵗ ⵓⵍ ⵓⵏ ⵙ ⴹⴰ ⴹⵜⵆⵍ ⴼⵔⴶⵜⵏⵙⵏ ⵎⵔⵏ ⵛⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ⵜⵔⵎⴹ ⵙ ⴶⵍⴰ ⵓⴰ ⵙⵗⵍⴼ ⵙⵎⵙⵜ ⵜⵙⴶⵔⵙ ⵛⵛⵗⵍ ⵔⵗ ⵓⵏ ⴶⵔⵓⴹⵓ ⴼⵍⵙ ⵙⵎⵙⵜ ⵜⵙⴶⵔⵙ ⵛⵢⴹ ⵏ⵿ⴹⵏⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ⵓⴰ ⵙⵗⵍⴼ ⵙⵏⵜⵜ ⴹⵗ ⴶⵍⴰ ⵛⵗⵍ ⴶⵔⵓⴹⵓ ⴼⵍⵙⵏⵜ ⵙⵏⵜⵜ ⵛⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ⵓⴰ ⵓⵔ ⵏⴶⵔⵓ ⵔ ⵜⵙⴶⵔⵙ⵿ⵜ ⵢⴹⴰ ⴶⵍⴰ ⴶⴰ ⵏⵓ ⴹⵗ ⵎⴹⵍ ⵏⵀⵍ ⴹⵗⵙ ⵜⵙⴶⵔⵙ⵿ⵜ ⵜⴰ ⵗⵍⴼ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ⵙ ⵜⴶⴰ ⵜⵔⵜ ⴹⴼⵔ ⵓⵏ ⵙⴹⵓ ⵎⵛⵙⵏ ⴹ ⵙⵗⵔⴹ ⵔⵤⵗⵏ ⵓⵏ ⵜⵏⵙⵗⵍⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ⵀⴹⴹⵓ ⵓⴰ ⵙⵗⵍⴼ ⵙⵎⵙⵜ ⵜⵙⴶⵔⵙ ⵓⵢⴹⵓ ⵙⵎⵙⵜ ⵛⵏ ⴼⵍⵙⵏⵜ ⴹⵛⵜⴰ⵰ ⵏⵙ \"ⵎⵛⵢ ⵙⵎⵙⵜ ⵜⵙⴶⵔⵙ ⴹⵜⵙⵗⵍⴼⴰ ⵎⵔⵏ ⴶⵔⵓⴹⵓ ⴼⵍⵙⵏⵜ ⵙⵎⵙⵜ ⵛⵢⴹ⵰ ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ⵏⵙ ⵎⵛⵙ \"ⵍⴼⵢⵜ⵰ ⵍⴾⵏ ⵙ ⴾⵍⵢ ⵍⵗⵏ ⵜⵎⵙⴰ ⵜⵎⵙⵗ ⴹⵗ ⵓⴹⵏ ⵏ⵿ⵜⴼⵍⵙ⵿ⵜ⵰ ⵜⵙⴾⵏⵗ ⴹⵢ ⴹⵗ ⵔⵜ ⵓⵔ ⵏⴶⵜ⵰ ⴹⴼⵔ ⵓⴰ ⴾⵢⵙⵗⵍⴼⵗ ⴶⵏ⵰ ⵢⵓ ⵜⴶⴰ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴰ ⴶⵗ ⵏⴾ ⵏ ⵎⵛⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«ⵓⴰ ⵙⵗⵍⴼ ⵙⵏⵜⵜ ⵜⵙⴶⵔⵙ ⴹⵗ ⵀⴹⴹⵓ ⵏⴰ \"ⵎⵛⵢ ⵙⵏⵜⵜ ⵜⵙⴶⵔⵙ ⴹⵜⵙⵗⵍⴼⴰ ⵎⵔⵏ ⴶⵔⵓⴹⵓ ⴼⵍⵙⵏⵜ ⵙⵏⵜⵜ ⵛⵢⴹ⵰ ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ⵏⵙ ⵎⵛⵙ \"ⵍⴼⵢⵜ⵰ ⵍⴾⵏ ⵙ ⴾⵍⵢ ⵍⵗⵏ ⵜⵎⵙⴰ ⵜⵎⵙⵗ ⴹⵗ ⵓⴹⵏ ⵏ⵿ⵜⴼⵍⵙ⵿ⵜ⵰ ⵜⵙⴾⵏⵗ ⴹⵢ ⴹⵗ ⵔⵜ ⵓⵔ ⵏⴶⵜ⵰ ⴹⴼⵔ ⵓⴰ ⴾⵢⵙⵗⵍⴼⵗ ⴶⵏ⵰ ⵢⵓ ⵜⴶⴰ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴰ ⴶⵗ ⵏⴾ ⵏ ⵎⵛⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«ⴹⴼⵔ ⵓⵏ ⵎⵔⵏ ⵀⴹⴹⵓ ⵓⴰ ⵙⵗⵍⴼ ⵜⵙⴶⵔⵙ⵿ⵜ ⵢⴹⴰ ⵏⴰ \"ⵎⵛⵢ ⵙⵏⵗ ⵙ ⵍⵙ ⵍⵀⵙⵏ ⵜⵎⵙⴰ ⵜⵜⵍⵢⴹⵓ ⵗⵔⵜ ⴹⵗ ⴹⴶ ⴹⵗ ⵓⵔ ⵜⵏⵀⵍⴰ ⵜⵜⵍⵢⴹⵓ ⴹⵗ ⵜⵏ⵿ⴼⴰ ⴹⵗ ⴹⴶ ⴹⵗ ⵓⵔ ⵜⵏⵀⵙⵗ ⵎⵙⴰ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵜⴶⵤ ⵜⵙⵏⴾ ⴶⵍⵗ ⵏⵀⵍⴰ ⵜⵙⴶⵔⵙ⵿ⵜ ⵜⴰ ⴹⵜⵙⵗⵍⴼⴰ⵰ ⵎⵔⴹⴰ ⵏ⵿ⵜⴰ ⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ⵏⵙ ⵎⵛⵙ \"ⴾⵢ ⵔⴾ ⴾⵍⵢ ⵜⵎⵙⴰ ⵜⵎⵙⴰ ⴹⵗ ⵏⴼⵔⵛⵢ⵰ ⴹⴹ ⵤⵎⵙ ⵜⵙⵏⵗ ⵙ ⵜⵍⵢⴹⵓ ⵗⵔⵜ ⴹⵗ ⴹⴶ ⴹⵗ ⵓⵔ ⵏⵀⵍⴰ ⵜⵍⵢⴹⵓ ⴹⵗ ⵜⵏ⵿ⴼⴰ ⴹⵗ ⴹⴶ ⴹⵗ ⵓⵔ ⵏⵀⵙⵗ ⵎⵙⴰ ⵓⵍⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ⵓⴹⵢ ⵏⵔ ⴹⵢ ⵜⵙⵏ⵿ⵙⵗ ⵤⵔⴼⵏ ⴹⵗ ⵀⵏ⵿ⴾ ⵙ ⴹⵤⵆⵍⵗ ⴶⵔⵓⴹⵓ ⴼⵍⵙ ⵜⵜⵢⵜ ⵜⴾⵍⵆⴹⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ⵏⴰ ⵎⵛⵙ \"ⴹⵗ ⴹⵢ ⵀⵤⵜⴹⵓ ⴹⵗⵙ ⵜⵙⴶⵔⵙ⵿ⵜ ⵜⴹⵢ ⵜⴾⴼⵎ⵿ⵜⵜ ⵢ ⵓⴰ ⵍⵏ ⵎⵔⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵍⵏ ⵓⴹⵢ ⴹⵙⵜⵓⵛⵜⵓ ⵓⴰ ⵍⴰ ⵏⴼⵍⵢ ⵎⵔⵏ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵔⵜ ⵏⵔⵜ ⵓⴰ ⵍⴰ ⴹⴰ ⴹⵗⵙ ⵜⵔⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ⴾⵍⵢ ⵎⵔⵏ ⵓⴰ ⵓⵔ ⵏⵏ⵿ⴼⴰ ⵓⵍⴰ ⴶⵔⵜⵏ ⴹⴼⵔ ⵂⵏ ⴹⵗ ⵛⵢⵢ⵰ ⴹⵏ ⴹⴰ ⴹ ⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⵍⵏⵏ ⴹⴹⵏ ⴹⴹⵓⵏⵙⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵙ ⴹⵆⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵂⵗ ⵜⵏⵢⵏⵏ ⴹⵓⴹⵓ ⴹⵏ⵿ⴶⵍⵙⵏ ⴾⵍ ⴹ ⵆⵎⴰ ⴼⵍ ⵜⵈⵓⵜⵏ ⵜⵏ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ⵛⵎⵜⵓⵏ ⵏⴹⵏⵜ ⴾⵍ ⴹⴹⵓⵏⵜ ⵀⴹⴹⵏⵜ ⴹⵜⵢ⵰ ⵜⵏⵜⵤⵎⵤⵢⴰ ⵙⵎⴾ ⵙ ⵙⴾⵜ ⵎⴹⵏ ⵢⴼⴹⵏⵜ ⴹⵗ ⵓⵍⵢ ");
INSERT INTO ttqt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ⴶⵗ ⵢⴼⴹ ⴹⵗ ⵗⵍⵏ ⴶⴰ ⵓⵍⵢ ⴹⵗ ⵤⵍⴶⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ⴹⵏ ⴹⵗ ⴹ ⵤⵏⴰ ⵏⴾ ⵏ ⵎⵏⴾⵍ ⵢ ⵓⵏ ⵂⵏⵏ ⵗⵍⵏ \"ⵢⵓⵜ ⴾⵓⵏⵢ ⵓⵏ ⵙ ⴶⴰ ⵀⵏⵏ ⵔⵈⵎⵜ ⴹ ⵜⴶⵔⵓⵎ ⵜⵗⵎⵔ ⵜⴰ ⴹⵓⵏ⵿ⵜⵜⵓⵙⵎⵜⴶⵜ ⵂⵔⵓⴰ ⵗⵔ ⵏⵜⵢ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ⴼⵍⵙ ⴶⵤⵢ ⴶⵍⴾ ⵜⵛⵜⵛⵎⵢ⵰ ⴶⵤⵢ ⴼⴹ ⵜⵛⵛⵓⵎⵢ⵰ ⵆⵍⵗ ⵏⴼ⵿ⵜⵗ ⵜⵙⵎⴶⵔⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ⵤⵍⵎⴰ ⵜⵙⵍⵙⵎⵢ⵰ ⵔⵏⴰ ⵜⵙⵏⵎ ⴹⵗⵢ⵰ ⴶⵤⵗ ⴾⵙⵓ ⵜⵙⵙⵍⵎⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ⴹⵏ ⴹⵗ ⴹⵤⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ \"ⵎⵍⵢ ⵎⵢ ⴾⵢⵏⵏⵢ ⵂⴾ ⴶⵍⴾ ⵏⵛⵜⵛⴾ ⵓⵍⴰ ⵂⴾ ⴼⴹ ⵏⵛⵛⵓⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ⵎⵢ ⴾⵢⵏⵏⵢ ⵜⵎⵙⵗ ⵏⴼ⵿ⵜⵗ ⵏⵙⵎⴶⵔⵜⴾⵢ ⵓⵍⴰ ⵜⵤⵍⵎⴰ ⵏⵙⵍⵙⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ⵎⵢ ⴾⵢⵏⵏⵢ ⵜⵔⵏⴰ ⵓⵍⴰ ⵜⵂⵗ ⴾⵙⵓ ⵏ⵿ⴶⵎ ⵏⵙⵏ ⴹⵗⴾ ⵓⵍⴰ ⵏⵙⵙⵍⵎⴾⵢⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ⴹⵏ ⴹⵗ ⴹⵙⵏ⵿ⵤⵏⴰ ⵏⴾ ⵏ ⵎⵏⴾⵍ \"ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⴹ ⵤⵎⵙ ⵜⴶⵎ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵢⵢⵏ⵿ⴹⴰ ⴹⵗ ⵎⴹⵔⵢⵏⵏ ⵓⵏ ⴾⵏⵏⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵢ ⵓⴹⵢ ⵏⴾ ⵙ ⵜⵏ⵿ⵜⴶⵎ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«ⴹⴼⵔ ⵓⵏ ⵎⵔⵏ ⵏⵗ ⵢ ⵓⵏ ⵂⵏⵏ ⵤⵍⴶⵜⵏ \"ⴶⴶⵜⵢ ⵎⵓⵔⵏ ⵏ⵿ⵜⵍⵗⵏ⵿ⵜ⵰ ⴶⵍⵓⵜ ⴶⵤⵜ ⵌⵂⵏⵎⴰ ⵜⵜⵓⵙⵎⵜⴶⵜ ⵢⵀⵍⵙ ⴹⵏ⵿ⴶⵍⵙⵏ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ⴼⵍⵙ ⴶⵤⵢ ⴶⵍⴾ ⵎⵛⵏ ⵓⵔ ⴹⵜⵛⵜⵛⵎ⵰ ⴶⵤⵢ ⴼⴹ ⵎⵛⵏ ⵓⵔ ⴹⵜⵛⵛⵓⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ⵆⵍⵗ ⵏⴼ⵿ⵜⵗ ⵎⵛⵏ ⵓⵔ ⴹⵜⵙⵎⴶⵔⵎ⵰ ⵤⵍⵎⴰ ⵎⵛⵏ ⵓⵔ ⴹⵜⵙⵍⵙⵎ⵰ ⵔⵏⴰ ⴶⵤⴰ ⴾⵙⵓ ⵎⵛⵏ ⵓⵔ ⴹⵗⵢ ⵜⵙⵏⵎ ⵤⴰ ⵓⵔ ⴹⵏ⵿ⵜⵙⵙⵍⵎⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ⵜⵤⵔ ⵏⵏⵢ \"ⵎⵍⵢ ⵎⵢ ⴾⵢⵏⵏⵢ ⵂⴾ ⴶⵍⴾ ⵓⵍⴰ ⵂⴾ ⴼⴹ ⵓⵍⴰ ⵜⵎⵙⵗ ⵏⴼ⵿ⵜⵗ ⵓⵍⴰ ⵜⵤⵍⵎⴰ ⵓⵍⴰ ⵜⵔⵏⴰ ⵓⵍⴰ ⵜⵂ ⴾⵙⵓ ⵏⵆⵎ ⵓⵔ ⴹⵗⴾ ⵏⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ⴹⵢ ⴹⵙⵏ⵿ⵤⵏⴰ \"ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⴹ ⵤⵎⵙ ⵓⵔ ⵜⴶⵎ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵢⵢⵏ⵿ⴹⴰ ⴹⵗ ⵓⵏ ⴾⵏⵏⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵢ ⵓⴹⵢ ⵏⴾ ⵎⵏⵏ ⵙ ⵜⵓⵔ⵿ⵜⴶⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ⴹⵏ ⴹⴰ ⴹ ⵤⴾⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⴶ ⵏⵜⴹⵀ ⵗⵍⵍⵏ ⵓⵏ ⵗⴹⵏⵏ ⵎⵔⵏ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵍⴼⵢⴹⵜⵏ ⵛⵏ ⴾⵍ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ⵜⵙⵏⵎ ⵙ ⵎⴹ ⵓⵏ ⴾⵢ ⵀⵙⵏ ⵛⵏ ⴹⵏ ⵎⵔⵏ ⴹⵢ ⴹⵗ ⴹ ⵤⴰ ⵜⵓⵙⵜⵔⵎⵙⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵢⴹ ⵜⵓⵜⵢⵜⵢⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⴹⵗ ⵗⵔⵗⵔ ⵏⵗⵢⵓⵏ ⵏ⵿ⴾⵢⴼ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ⵏⵎⵔⴹⵏ ⴼⵍ ⵜⵎⵔⴾⵙ⵿ⵜ ⵜⵙ ⵤⵀⵤⵏ ⵗⵢⵙⴰ ⴶⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴶⵏⵏ ⴹ ⵓⵔ ⵏⴶⵓ ⴹⵢ ⴹⵗ ⴹⵏ ⵏⵎⴹ ⴼⵍ ⴹ ⵓⵔ ⵌⵏⵌⵔⵓⵢ ⵓⵏ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ⵂⴰ ⵗⵢⵙⴰ ⵜⵗⵔⵎ⵿ⵜ ⵏⵀⵜⵏⵢ ⵆⵎ ⴹⵗ ⵂⵏ ⵏ⵿ⵙⵎⵗⵏ ⵓⵙ ⴾⵍⴰ ⵜⴶⵔⵓ ⴾⵜⵔⵓ ");
INSERT INTO ttqt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ⵙ ⴹⵜⵙⴰ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵜⵂⵤⵜⵏ ⴹⵗ ⵎⵤⵢ ⴹⵗ ⵙⵗⵎⵔ ⵜⵜⵓ⵰ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵜⵓⵢ ⵀⵜⵍⵢ ⴶⵏ ⴹⵗ ⵜⵂⵏ⵿ⵜ ⵜⴾⵏⵜ ⵛⵂⵙⵢ ⵂⴰ ⵍⵓⵔⴹⵢ ⵢⵏ ⵍⵏ ⵍⵎⵆⵎ ⵓⵍⵏ⵰ ⵜⵤⵔ ⴹ ⵜⵏⵆⵍ ⵍⵓⵔⴹⵢ ⵓⵏ ⴼⵍ ⵗⴼ ⵏ⵿ⵗⵢⵙⴰ ⵎⵙ ⵓⵏ ⵍⵗⵍⵎⵜ ⵏ⵿ⵙⵗⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ⵙ ⵏⵢⵏ ⵏⵜⵍⵀ ⵔⵜ ⵓⵏ ⵛⴾⵏ⵿ⵜⵓ ⵓⵍⵏ ⵏⵏ «ⵎⴰ ⵏ⵿ⴼⴰ ⵂⵍⴾ ⵏⵍⵓⵔⴹⵢ ⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ⵍⵓⵔⴹⵢ ⵓⴰ ⵍⵏ ⵍⵎⵆⵎ ⴰ ⵏⵔ ⵏⵤⵏ ⴹⵏⵜⵓⴶⴰ ⵤⵔⴼ ⴶⵏ ⵜⵓⴾⴼⵏ ⵏⵤⵏⵜ ⵢ ⵜⵍⵆⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ⴶⵔⵏ ⵗⵢⵙⴰ ⵓⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵗⵛⴹⵎ ⵎⵏ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⴰ⵰ ⵎⵤⵍ ⵍⵗⵏ ⴹⵜⴶⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ⴼⵍⵙ ⵛⵍⵆⵓⵏ ⴼⵓ ⴹⴰ ⵍⵏⵜ ⵗⵔⵓⵏ ⵏⴾ ⵎⵔⵏ ⵓⵔⴶ ⴼⵓ ⵍⵗ ⵗⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ⵍⵓⵔⴹⵢ ⵓⴰ ⵜⵏⵗⵍⴰ ⵜⵜⴶⴰ ⴼⵍ ⵜⵗⵙⵏⵏ ⴼⵍ ⴹⵜⵙⵎⵜⴶ ⵢⵤⴾⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⴶ ⴹⵗ ⵜⵎⵍ ⵍⵏ⵿ⵌⵍ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ ⴹⵗⵙ ⵜⵎⵍ ⵓⴰ ⵜⴶⴰ ⵜⵏ⵿ⵜⵜ ⴰ ⵜⵜⵓⴾⵜⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ⵤⵍ ⵓⵏ ⴹⴰ ⴹ ⵏ⵿ⴾⵔ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴶⵏ ⵙⵎ ⵢⵂⵤⴰ ⵓⵙ ⵜⵓⵏⵓ ⵙⵈⵔⵢⵜⵢ ⴾⴰ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ⵏⵙⵏ «ⵎⴰ ⴹⵤⵜⴾⴼⵎ ⴹⵓⵏ⵿ⵜⴶⴰ ⴹⵗ ⴼⵙⵏ ⵏⴾ ⵎⵏⵏ⵰» ⵜⵤⵔ ⵏⵎⵔⴹⴰ ⴹⵔⵙⵏ ⴾⴼⵏ⵿ⵜⵓ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ⵀⵤⵏ ⵗⵔ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹ ⴶⵤ ⵛⵏ ⴶⵎⵢ ⵏ⵿ⵜⵎⵤⵢⵜ ⵜⴰ ⴹⵗ ⵤⴶⵓ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ⵙ ⴹⵓⴹ ⵤⵍ ⵓⴰ ⵤⵔⵏ ⵏⵎⴹ ⵓⴰ ⴹⵗ ⵜⵎⵜⵛⵏⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵂⵤⵏⵏ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⵏⴹ ⵜⵔⵗ ⴹⴾⵏⵙⵎⵜⴶ ⵎⵏ⵿ⵙⵓⵏ ⵏⵎⴹ ⵓⵏ ⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ⵏⵙⵏ «ⴶⵤⵜ ⵗⵔⵎ ⵜⴾⵎ ⵓⴹⵏ ⵢⵏ ⵍⵏ ⴹⵏ ⵜⵏⵎⵙ \"ⵏⴾ ⵛⵈ ⵍⵓⵆ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜⵏ ⵂⵤ⵰ ⴾⵢ ⵗⵔ ⵤⴰ ⵏⵎⵏ⵿ⵙⵓ ⴹⵗ ⵎⴹ ⵓⵏ ⴾⵢ ⵏⴾ ⴹⵏⵜⵍⵀⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ⵎⵤⵍⵏ ⵏⵜⵍⵀ ⵓⵙ ⵜⵏⵎⵔ ⵗⵢⵙⴰ ⵙⵎⵜⴶⵏ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵏⵗⵎⴰ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ⵜⵜⵏ ⴹⵏ ⴹⵗ ⵙ ⵏⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢⵏ ⴹⵗⵓⵏ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ⵀⵜⵓ ⵜⵏ ⵜⵓⵢⴹⵓ ⵙⵔⵙⵏ ⵙ ⵗⵛⴹⵏ ⵎⵏⵙⵏ ⵓⵍⵏ ⴹⵙⴶⵏⵓ ⴾⵢⵏ ⴹⵗⵙⵏ «ⵎⵍⵢ ⵏ⵿ⴶⵎ ⵓⵔⴶⵗ ⵏⴾ ⴾⵢⵤⴶⵏ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ⵜⵌⵓⵀⵙⵏ ⴶⵏⵙⵏ «ⵓⴰ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⴹⵔⵓⴰ ⴹⵔⵙ ⴹⴰ ⴹⴰ ⴹⵗ ⵗⵤⵓ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ⵜⴹⵜ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵀⴰ ⵙⵎⴾ ⵓⴰ ⵎⵍⵏ ⵍⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵏⵏ⵰ ⵎⵛⵏ ⵢⴰ ⴾⵜ ⵍⵗⵤⵀ ⴹ ⵜⴶⵓ ⵓⴰ ⴹⴶⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⴼⵙⵏ⵰ ⵓⴹⵏ ⵓⴹⵢ ⴹⵙⴼⵓ ⴼⴹⴰ ⴹⵓⵔⴶⵤ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ⵜⵤⵔ ⵛⵓⵍ ⵢⵂⵤⴰ ⵙⵏ⵿ⵜⴰ ⵜⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵏⵙ «ⵏ⵿ⴶⵎ ⵓⵔⴶⵗ ⵏⴾ ⵙ ⵜⴶⵏⵗ ⴹⵢ ⵛⵈ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹⵗ ⵜⵜⵏ ⴹⵏ ⴹⵗ ⴹⴹⴾⵍ ⵗⵢⵙⴰ ⵜⴶⵍⴰ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵔⵤⴰ ⵜⴶⵍⴰ ⵜⵏ ⵤⵏ⵿ⵜⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵜⵛⵓⵜ ⴹⴰ⵰ ⵜⵗⵙⵏⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ⴹⴼⵔ ⵓⵏ ⴹⴾⵍⴹⵓ ⵜⴾⵀⵔ⵿ⵜ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴾⴼⵙⵏ⵿ⵜⵜ ⵏⵙⵏ «ⵛⵓⵜ ⴹⵗⵙ ⴾⵜⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ⴼⵍⵙ ⵤⵏⵏⵏ ⴹⵢ ⵙⵜⴹⵏ ⵤⵏⵢ ⵓⵏ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⴶⵔ ⵎⵛⵏⴰ ⴹⵜⵎⵜⵢⵏⵜ⵰ ⵤⵏⵢ ⵓⴰ ⴹ ⵏ⵿ⵗⵍ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵓⵔ ⵤⵍⵙⴰ ⵜⵙⵢ ⵏⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵓⴰ ⴾⵜ ⵓⵔ ⴹⵓⴹ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⵛⵓⴰ ⵓⴰ ⵢⵏⵢⵏ ⵏⴾ ⴹⵔⵓⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵀⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ⵜⵤⵔ ⵙⴶⴹⵏ ⴹⵗ ⵜⵎⵍⵏ ⴹⴶⵎⴹⵏⵏ ⵤⵀⵔ ⵙ ⵜⵏⵜⵗⵔⴹⵏ ⴾⵏ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ⵂⵏ ⵜⵔⵢⵜ ⴹⵏ ⴹⴰ ⵙ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ «ⵂⴹ ⴹⴰ ⴾⵜⵏⵓⵏ ⵙ ⴹⵓⵏ⵿ⵤⵆⵍⵗ ⵙⵀⵀ ⵏⴹ ⵓⵍⵓⵍ ⵤⴶⵤⵏⵓⵏ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⴹ ⵓⵜⵗ ⵎⴹⵏ ⵀⵜⵓ ⵜⵤⵔ ⵓⵤⵓⵤⵏⵜ ⵢⴼⴹⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ⵎⵛⵏ ⴹⴼⵔ ⵜⵓⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵓⵏⵏⵤⵔⵗ ⵙⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⵆⵍⵗⵓⵏ ⴹⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ⵛⵓⵍ ⵀⵜⵔⵙ ⵏⵙ «ⴾⴹ ⵓⵍⵓⵍ ⵤⴶⵤⵏⵙⵏ ⴾⵜⵏⵙⵏ ⴹⵗ ⵀⵜⵏⴾ ⴹⴰ ⵓⵏⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵓⵍⵓⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵂⴹ ⴹⴰ ⵙ ⵤⵗⵔⵓ ⴾⵌⵢ ⵗⵔⴰ ⵜⴶⴹⵗⵢ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ⵏⵙ ⵀⵜⵔⵙ «ⴾⴹ ⵆⵍ ⵙ ⵜⵓⵏ⵿ⵗⴰ ⴾⵔⵤ ⵤⴰ ⵏⴶⵓ ⵏⴾ ⴹⵔⴾ ⴹⴰ ⵓⵔ ⴾⵢⵤⴶⴹⴰ⵰» ⵏⵏ ⵏⵜⵍⵀ ⴾⵜⵏⵙⵏ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ⵓⴹ ⴹⵔⵙⵏ ⵗⵢⵙⴰ ⴼⵔⴶ ⵏⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ ⵙ ⵜⵓⵏⵓ ⴶⵜⵙⵎⵏⵢ ⵏⵙⵏ «ⵆⵎⵓⵜ ⴹⵢ ⴹⴰ ⴹ ⴾⵗ ⴹⴶ ⵏ ⴹ ⴶⴰ ⵛⵓⵜⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ⵤⵏ⵿ⴾⵤ ⴼⵍⵙⵏ ⵗⵢⵙⴰ ⴹⵓ ⴹⵀⵜⵔⵙ ⴹⵛⵏ ⵎⴹⵏ ⵏⵎⴹⵏⵙ ⵏ⵿ⵤⵀⴹⵢ ⵜⵤⵔ ⵙⵏ⵿ⵜⵏ ⵎⵏⵜ ⵗⵛⴹ ⵛⵓⵛ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ⴹⵏ ⴹⵗ ⴹⵙⵏⵏⴰ «ⵓⴰ ⴶⵏ ⵎⵏⵏ ⴹⵗ ⵗⵛⴹ ⵀⴾⵗ ⴹⵀⴰ⵰ ⴹ ⵓⵔ ⵜⴼⵍⵎ ⴹⴰ ⴹ ⵏⴾⵢ ⵏⴾ ⴹⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ⵜⵤⵔ ⴶⴰ ⴼⵍⵙⵏ ⵔⵜ ⵏⵤⵏ⵿ⴾⵤ ⵙⵌⴹ ⵜⵔ ⵏⴰ «ⵀⵏⵏ ⴾⴹ ⵎⴾⵏ ⴹⵢ ⵜⵙⴶⴶⵗⵢ ⵜⴾⵀⵔ⵿ⵜ ⵜⵏ ⵍⵗⵤⵀ ⴹⵢ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔⴶⵗ ⵓⴰ ⵔⵗ ⵏⴾ ⵜⴶⵏ ⴾⵍⵔ ⵓⴰ ⵜⵔⵗ ⴾⵢ ⵤⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ⴹⴼⵔ ⵓⵏ ⵆⵍⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹ ⵏ ⵙⵏ⵿ⴹⵓ ⵏ⵿ⵙⵏ⵰ ⵏⴰ ⵢ ⵀⵜⵔⵙ «ⴹⵗ ⴹⵢ ⵏ⵿ⴹⵔⵓⵏ ⴹ ⵜⴶⵎ ⵍⵓⵆ ⵢⵏ⵿ⴹⴰ ⵜⴾⵢⵎ ⵏⴾ ⴹⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ⴾⵢⵜ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴾⵓⵏⴶⵤⵏ ⴹⵗ ⵌⵔⵀⵜⵏ ⵏⵀⵍⵙ⵰ ⵜⴹⵜ ⵙ ⵏⵢⵜ ⵏⴶⴹⵎ ⵜⵙⴹⵔⵏ ⴶⵢ ⵏⵓⴰ ⵍⵗⵏ ⵎⵛⵏ ⴶⴹⵍⵙ ⵔⴾⵎ ⵏ⵿ⵜⵗⵙⵏⵜ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ⵍⵙ ⵤⵏ⵿ⴾⵤ ⴼⵍⵙⵏ ⴹ ⵜⴶⵓ ⵛⵓⵜⵔⵓⵏ ⵏⴰ «ⵢⴰ ⵀⵏⵏ ⴾⴹ ⵓⵔ ⵜⵍⴰ ⵎⴾ ⵙ ⴹⵜⵗⵍⵢ ⵜⴾⵀⵔ⵿ⵜ ⵜⵏ ⵍⵗⵤⵀ ⴹⵢ ⴾⴹ ⵍⵤⵎⵢ ⵜⵜⵛⵓⴰ ⵓⴹⵢ ⵜⴶⵓⵜ ⵜⵔⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ⵍⵙ ⵆⵍⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹ ⴶⵤⵜⵏⵏ ⵆⵍⵏ ⵜⵙ ⴼⵍⵙ ⵓⴰ ⴹⵙⵏⴶⴰ ⵜⵙ ⴹⵗ ⴶⵤ ⵀⵙ ⴼⵔⴶⵏ ⵔⴰ ⵏⵛⵜⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ⵍⵙ ⴼⵍ⵿ⵜⵏ ⴾⴰ ⴹⵏ ⴶⴰ ⵜⵓⵜⵔⵢⵏⵜ ⵜⵏ ⴾⵔⴹⵜ ⴹⵗ ⵏⴰ ⵔⵜ ⵓⴰ ⵏⴰ ⴹⵜ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ⴹⴼⵔ ⵓⵏ ⵆⵍⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⴾⵓⵏⵢ ⵂⵔⵓⴰ ⴹⴰ ⵜⵏ⵿ⵙⵎ ⵜⵙⵏ⵿ⴼⵎ⵰ ⵏⵢⵜ⵰ ⵍⵓⵆ ⵂⵤⴹⵓ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵓⴶⴰ ⴹⵗ ⴼⵙⵏ ⵏⵙⵀⴾⴹⵏ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ⵏ⵿ⴾⵔⵜⵏ ⵏ⵿ⴹⵓⵜ⵰ ⵏⵢⵜ⵰ ⵓⴰ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵓⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ⵛⵓⵍ ⵂⵔⵓⴰ ⴹⴰ ⵙ ⴹⵓⴹ ⵢⵂⵤⴰ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵓ ⴹⵜⵎⵜⵢ ⵜⴶⵜ ⴹⵙⴶⵍⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ⵜⵎⵜⵢ ⵜⵏ ⵜⵓⵢ ⵛⴾⵀⵓⵏ ⴹⵜⵀⵔⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ⵓⴰ ⵜⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵎⵍⵙⵏ ⵍⵗⵍⵎⵜ ⵜⵙ ⵤⵜⵓⵙⵏ ⵏⵙⵏ «ⵓⴰ ⵤⵍⵎ ⴹⵗ ⵎⴹⵏ ⵏ ⵙⵏⵜ ⵙ ⵏ⵿ⵜⴰ ⵜⵀⵤⵎ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ⵙⴹⵓ ⵢⵂⵤⴰ ⵗⵙ ⵂⵤⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵎⴰ ⵜⵈⵍⴾⵗ ⵛⵈ⵰» ⵜⵤⵔ ⵤⵍⵎⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴹⵏⵏ ⵔⵜ ⵓⴰ ⴾⵢ ⴹⵓⵢⵏ ⴶⵢ⵰» ⵜⵤⵔ ⵓⴹⵏ⵿ⴹⵓ ⵀⵤⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⴹⵍⵀⵢ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⵜⴾⵀⵏⵜ ⵓⵜ ⵙⵔⵙ ⴾⵍⵢ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴼⵔⵙⴹⵓ ⵜⵎⵤⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ⵜⵤⵔ ⵏⵙ ⵗⵢⵙⴰ «ⵙⵗⵍ ⵜⴾⵀⵏⴾ ⵜⵜⵔⵜ ⴼⵍⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵛⵆⵍⵏⵏ ⵙ ⵜⴾⵀⴰ ⵜⴾⵀⴰ ⵙ ⵤⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ⵓⵔ ⵜⵔⴹⵗ ⵙ ⴼⵔⴶⵗ ⴹ ⴶⵎⵢⴰ ⵜⵍⵍ⵿ⵜ ⴹⵗ ⵀⵏⵏ ⵙⴶⵍⴹⵓ ⵎⵔⴹⴰ ⴶⵔⵏ ⵎⵔⵓ ⴶⵏⵏ ⵏⵏ⵿ⴶⵍⵙⵏ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ⵎⵛⵏ ⵙ ⴶⴰ ⴹⵢ ⵎⵙ ⵤⵏ⵿ⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵎⵍⵏⵏ ⵙ ⵓⴰ ⴾⵍ ⵍⵤⵎ ⴹ ⵏ⵿ⴹⵓ ⵙⵎⴾ ⵓⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ «ⵎⴼⵍ ⵜⵙⵎⴹⵓ ⵜⵓⵢⵎ ⵛⴾⵀⵓⵏ ⴹⵜⵀⵔⴶⵏ ⵢⴹⵜⵀⵤⵎ ⵤⵏ ⵙ ⵜⴶⵎⵢⵎ ⵌⵌⵀ ⵢⵏ ⵏⵀⵢⴹⴶ⵰ ⵏⴾ ⵓⵔⴶⵗ ⵤⵍ ⴾⵍ ⵏⵗⵎⴰ ⴹⵔⵓⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵙⵗⵔⴰ ⴹⵗⵙ ⵎⵔⵏ ⵓⵔ ⴹⵜⵀⵤⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ⵎⵛⵏ ⵙⵏⵜ ⵙ ⵓⴰ ⴶⵏ ⴹⴰ ⴾⵜⵏⵜ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ⵰» ⴹⵏ ⴹⵗ ⵜⴼⵍⵏ ⵏⵜⵍⵀⵏⵜ ⴾⵜⵏⵙⵏ ⴹⴶⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ⵢⵜⴹⵏ ⵓⵏ ⵀⵤⵏⵏ ⵗⵢⵙⴰ ⵓⵢⵏ⵿ⵜⵓ ⵙ ⴾⵢⴼ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰ ⵏ⵿ⵜⴰ ⵗⵔ ⵎⵏⵢⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ⴶⴰ ⵀⵜⵔⵙ ⵢ ⵗⵢⵙⴰ ⵍⴾⵎ ⵤⴶⵔⵏ ⵂⵔ ⵓⴹ ⵗⵍⴰ ⵏⵗⵢⵓⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴶⵤⵜⵓ ⵏⵗⵎⴰ ⴹⵎⵛⵗⵍⵏ ⵙⵓⴹ ⵢⴹ ⵏⵢ ⵓⴰ ⵤⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ⵏ⵿ⴾⵔⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴾⵜⵏⵜ ⴹ ⴶⵎⵢⵏ ⵓⴹⵏ ⵆⵍⵏ ⵜⴶⵢⴰ ⵏⵀⵂⵓ ⴼⵍ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵔⵢⵜ ⵏⴶⵢ ⵏⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ⵎⵛⵏ ⵛⴶⵢⵓⵏ ⴶⵜⵏⵏ ⵏⵀⵂⵓ ⵛⵏ ⴼⵍⵙ ⵜⴶⵏ ⴹⴰ ⵀⵙⵏ⵿ⴹⵓ ⴹⵗⵙⵏⵜ ⴹⵍⵍ ⵙⵂⵏ ⴼⵍ ⵜⵓⵏ⵿ⵗⴰ⵰ ⵈⵙⵍ ⵙⵏⵜⴹⵓ ⵜⴶⵢⵓⵏ ⵛⵢⴹ ⵙⵏⵜⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ⵏⵏⵜ «ⵓⴹⵏ ⵓⴰ ⵏⴰ \"ⴼⵔⴶⵗ ⵌⵀⵔⵌⵢ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵎⵛⵏⴰ ⵍⵙⵆⵓ ⴾⵔⵙ ⴹⵗ ⴾⵔⴹ ⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ⵜⵤⵔ ⵀⴹⴹ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⴾⵢ ⵓⵔ ⵜⴶⵏⴰ ⵓⵍⴰ ⴹⵗ ⵜⵗⵜⵙ ⵛⵏ ⴹⴾⵜⵓⴶⵏⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ⵎⵛⵏ ⴶⵍⴰ ⵗⵢⵙⴰ ⴼⵙ⵿ⵜⴰ⵰ ⵍⵙ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙ «ⴶⵎⵢⴰ ⴹⵗⴾ ⴹⵜ ⵎⵛⵏⴰ ⴹⵢ ⴹⵔⵏ ⴹⵏⵗⵜⵎⵍⴰ ⴾⴹ ⴾⵢ ⵎⵙⵏ ⵍⵎⵙⵈ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵍⴰ ⴾⵢ ⵎⵏⴾ ⵏⵏ ⴹⵢ⵰ ⵎⵔⵏ ⵎⵍⵗⵓⵏ ⵙ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⴹⵜⵏⵢⵎ ⵏⴾ ⴶ ⴶⴹⵎ ⵆⵎⴰ ⴹⵗ ⵗⵍ ⵏⵎⵍⵢ ⵏ⵿ⵜⵔⵏⴰ ⵜⵏⵢⵎⵢ ⴹⵗ ⵤⵢⴹⵓ ⵓⵔⴰ ⵛⴶⵔⴾⵏ ⵏ⵿ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ⵜⵤⵔ ⵤⵤⵔⵜ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵜⴾⵜⴾⵜⵏⵜ ⴼⵍ ⵓⴰ ⴶⵏ ⵎⵏⵜ ⴹⵗ ⵗⵛⴹ ⵏⴰ «ⵍⵙ ⵓⴰ ⵎⴹⵔⵓ ⴶⴰ ⵢ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵎⴰ ⵏⴾⴰ ⵢ ⵜⴶⵢⵓⵏ ⵛⵢⴹ⵰ ⵓⵔ ⵜⵙⵍⵎ ⵢⵎⴹⵔⵓ ⵓⴰ ⴶⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ⵎⴰ ⵜⵏⵎ⵰» ⵏⵏⵙ ⴾⵜⵏⵙⵏ «ⵍⵙ ⵓⴰ ⵛⵔⵗⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ⵜⵤⵔ ⴹ ⵙⵜⴼⵏ ⴼⵍ ⴹⵎⵏⵜ ⴶⵜⵏ⵿ⵜⵓ ⵜⵆⵙⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ⴶⵏⵏⵙ «ⵍⵎⵙⵈ ⴹⴹ ⵤⵎⵙ ⴾⵢ ⵏⵀⵢ ⵎⵍⵏⴰ ⵓⴰ ⴾⵢⴶⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ⵙ ⵜⴶⵓ ⵓⵏ ⵀⵜⵔⵙ ⵆⵎ ⴹⵜ ⵂⵏ ⴹⵗ ⵗⵍⴰ ⵏⵗⵢⵓⵏ ⵓⵏ⵰ ⵜⵂⵤⵜⵏ ⵜⵎⵛⵗⵍ⵿ⵜ ⵢⵜ ⵏⵗⵢⵓⵏⵏ ⴹⴰ ⵜⵏⵙ «ⴾⵢ ⴹⴰ ⵜⵜⴹⵓⵗ ⴹⵗⵢⵙⴰ ⵓⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ⵎⵛⵏ ⴶⴹ ⵀⵜⵔⵙ ⵓⵏ ⴹⵜ ⵢⵜⴹⵏ ⴾⵍ ⵏⴰ «ⵓⵔ ⵙⵏⵗ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ⵜⵤⵔ ⴹⴶ ⵀⵜⵔⵙ ⵙⴰ ⵙⵔ ⵎⵢ ⵏⵗⵢⵓⵏ ⵜⵏⵢⵜⵓ ⵜⵎⵛⵗⵍ⵿ⵜ ⵢⵜ ⵜⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ «ⵍⵙ ⵓⵏ ⵜⴹⵓ ⴹⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ⵍⵙ ⴶⴹⵜⵓ ⵂⴹ ⵏⴰ «ⵓⵔ ⵤⴹⵢⵗ ⵍⵙ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ⵙ ⴶⴰ ⵔⵜ ⵏⵎⵤⵢ ⴹⴼⵔ ⵓⵏ ⵂⵤⵏ⵿ⴹⵓ ⵎⴹⵏ ⵓⵢⴹ ⵀⴹⴹⵏⵏ ⴹⵏ ⵏⵏ ⵢ ⵀⵜⵔⵙ «ⵍⴾⵏ ⵙ ⴾⵢ ⴹⴰ ⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴹⵗ ⴹⵏ ⵜⵎⵙⴰ ⴼⵍⵙ ⵓⵍⵏⴾ ⴹⴰ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ⵜⵤⵔ ⴹ ⵂⴹ ⵀⵜⵔⵙ ⴶⵏⵓ «ⵎⵛⵏⴰ ⵢⴰ ⵜⵍⵗⵏⵗⵢ ⴾⴹ ⵀⵂⵓ ⴶⵗ ⵙ ⵓⵔ ⵤⴹⵢⵗ ⵍⵙ ⵓⵏ⵰» ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹ ⵗⵔⴰ ⴾⵌⵢ ⵗⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ⴾⵜⴹⵓ ⵀⵜⵔⵙ ⵜⵏⴰ ⵜⴰ ⴹⵙⴶⴰ ⵗⵢⵙⴰ «ⴹⵜ ⵜⵗⵔⵢ ⵏⴾⵌⵢ ⵗⵔⴰ ⴹⵜⵏ⵿ⴾⵔⴰ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ⵜⵤⵔ ⴶⵎⴹ ⵙⴹⵢ ⴹ ⵂⵍⵓ ⴼⵍ ⵓⴰ ⴶⴰ ⴹⵗ ⵜⵎⴶⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ⵙ ⴼⵓ ⵗⵔⴰ ⵎⵏⵢ ⵙⴶⵓⵔ ⵏⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵙⵏ ⴹ ⵜⴶⵏ ⵛⵏⴹⵏ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵗⵢⵙⴰ ⵢⴹⵙ⵿ⵜⵜⵓⵈⴾⵎ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ⴾⵔⴹⵏ⵿ⵜⵓ ⵓⵢⵏ⵿ⵜⵓ ⵙⵏⵈⴾⵎ ⵀⵍⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ⵢⵂⵤⴰ ⵓⴰ ⴶⵏ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ ⵙ ⵏⵢ ⵙ ⵗⵢⵙⴰ ⵜⵓⵈⴾⵎⵙ ⵜⴹⵀ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴹⵏⵜ ⴹⵗⵙ ⵜⵎⴶⵔⵤ ⵓⵢⴹⵓ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ ⵛⵏ ⴶⵔⵓ ⵢⵜⵏⵜⵙⵗⵍ ⵢ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ⵏⵙⵏ «ⵏⴾ ⴶⵗ ⵀⴾⴹ⵰ ⵓⴹⵏ ⵓⵔ ⵏⵗⵛⴹ ⵓⵍⴰ ⴶ ⴹⵗ ⴼⵙⵏ ⵢⴹ ⵜⵓⵏ⵿ⵗⵓ⵰» ⵎⵛⵏ ⵏⵏⵙ «ⵏⴾⵏⵢ ⵓⵔ ⵏⵤⵍⵢ ⴹⵗ ⵜⴹⵢ⵰ ⵀⵜⵓ ⵜⴹⵢ ⴾⵢ ⵜⵆⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ⴶⵔ ⵢⵂⵤⴰ ⵤⵔⴼ ⵓⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴶⵍⴰ ⵛⵍⵢ ⵎⵏⵜ ⵛⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ⴾⵎⵏ⵿ⴹⵓ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵤⵔⴼ ⵓⵏ ⵏⵏ «ⵛⵔⵗⵏⵏⴰ ⵙⵈⵔⵎ ⴼⵍⵏⴰ ⴶⵢ ⵏⵤⵔⴼ ⵓⴰ ⴹⵗ ⵙⵏ⵿ⴹⵆ ⵓⴰ ⵂⴰ ⵔⵤⵗ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴼⵍⵙ ⵤⵔⴼ ⵓⴰ ⵤⵏⵢ ⴹⴶⵎⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ⴶⵏ ⵛⵏⴹⵏ ⵤⵏ⵿ⵤⵏ ⴹⵗ ⵤⵔⴼ ⵓⵏ ⵜⵓⴶⵙ⵿ⵜ ⵙ ⵜⵓⵏⵓ «ⵜⵓⴶⵙ⵿ⵜ ⵏⴾⵏⵓ» ⵢⵜⵜⴶⵏ ⴹⴶ ⵏ⵿ⵤⴾⵓⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵍⴰ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⵂⵔ ⵤⵍⴹⴰ ⵜⵓⵏⵙ «ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⵤⵏⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ⵎⴾⵏ ⴹⵗ ⵙ ⵏ⵿ⴹⴰ ⵓⵍ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⵔⵎⵢⴰ ⵙ ⵏⴰ «ⴹⴾⵍⵏ⵿ⴹⵓ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⴼⵍ⵿ⵜ ⵎⵙⵏⵏ ⵍⵆⵎⵜ ⵜⵙ ⵜⴹⴾⴹⵏ ⵎⴹⵏⵙ ⵏⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ⵤⵏ⵿ⵤⵏ ⵙⵔⵙⵏⵜ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⴾⵏⵓ ⵙⵎⴾ ⵓⵙ ⴹⵎⵔ ⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ⵜⵓⵙⵀⴹⴹ ⵗⵢⵙⴰ ⴹⵜ ⵏⵈⴾⵎ ⵀⵍⵜⵙ⵰ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵈⴾⵎ ⵏⵙ «ⵓⴾ ⴾⵢ ⴹⵗ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ⵎⵛⵏ ⵓⵔ ⵏⴰ ⵗⵢⵙⴰ ⵓⵍⴰ ⴹⵗ ⵀⵜⵓ ⵏⵍⵂⵏⵏ ⵓⵏ ⵜⵙⵓⵔⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ⵜⵤⵔ ⵏⵙ ⵀⵍⵜⵙ «ⵓⵔ ⵜⵙⵍⴰ ⵢ ⵍⵂⵏⵏ ⴶⵜⵏⵏ ⵓⵏ ⴾⵢⵙⵓⵔⵏ ⵢⵜⴹⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ⵎⵛⵏ ⵓⵔ ⴹⵙⵏⴰ ⵗⵢⵙⴰ ⵓⵍⴰ ⵜⴼⵔ⵿ⵜ ⵢⴹⴰ ⴹⵗ ⵀⵜⵜⵏ ⵛⵏ⵰ ⵔⵜ ⵓⵏ ⵙⵎⴾⵍⵍ ⵓⵍⵏ ⵙⵏⵈⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ⵎⵙ ⵍⵗⴹⵜ ⵏⵏⵈⴾⵎ ⵙ ⴹ ⴹⵗⵍⵢ ⵎⴹ ⵓⵏ ⴾⵢ ⴹ ⴾⵙ ⵎⵙⴾⵙⵓ ⵓⵙ ⵜⵔⴰ ⵜⵎⵜⵢ ⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ⵤⵎⵏ ⵏ ⵍⵢ ⵎⵙⴾⵙⵓ ⴼⵍ ⵜⴶⴰ ⵎⵙⵏⵜ ⴶⵏ ⵙⵎ ⵗⵢⵙⴰ ⵀⵔⵗⵀⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ⵜⵤⵔ ⵏⴰ ⵀⵍⵜⵙ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵓⵏⵏ ⴹⵏ «ⵎⴰ ⵎⵙ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⵓⵙ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⴾⵙⴰ⵰ ⵓⴾ ⵀⵔⵗⵀⵙ ⵎ ⵗⵢⵙⴰ ⵓⵙ ⵜⵓⵏⵓ ⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ⵀⵍⵜⵙ ⵙⵏ ⵙ ⵛⴹⵜ ⵏⵎⵏ⵿ⵤⵗ ⴼⵍ ⴶⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ⵎⵤⵢ ⵓⴰ ⴹⵗ ⵆⵎ ⵀⵍⵜⵙ ⴹⵗ ⴹⴶ ⵓⵏ ⵛⵔⵗⴰ ⴹⵏ ⵏ⵿ⵜⴰ ⵙ ⵙⵔⵙ ⴹⵜⵤⵎⵤⵍ ⵜⵗⵔⵙ ⵜⵏⵙ «ⵍⵙ ⴹⵢ ⵗⴹ ⴹ ⵓⵔ ⵜⴶⵤⴰ ⵀⵜⵏⵜ ⴼⵍⵙ ⵏ⵿ⴹⴹ ⵏⵢⴰ ⴹⵗ ⵜⵔⴶⵜ ⵍⵗⵤⵀ ⴶⵏ ⴼⵍ ⴹⵍⵍⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ⵏ⵿ⴾⵔⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙⵔⴹⵏ ⵜⵎⵜⵢ ⵙⴹ ⵜⴶⵎⵢ ⴹ ⵜⵓⴾⵙ ⵀⵔⵗⵀⵙ ⵜⵓⴾⵙⵏ ⵎⵏ ⴹⵗ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ⵛⵓⵍ ⵏⵈⴾⵎ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⴹⵗ ⵛⵏ ⵎⴹⵏ ⵓⵏ ⴹⵢ ⵓⵙ ⵜⵔⵎ ⴹ ⵜⴾⵙⴰ⵰» ⵏⵏⵙ «ⵀⵔⵗⵀⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵎⴰ ⵤⴶⴰ ⵤⴰ ⵢ ⵗⵢⵙⴰ ⵓⵙ ⵜⵓⵏⵓ ⵍⵎⵙⵈ⵰» ⵏⵏⵙ ⴾⵜⵏⵙⵏ «ⵜⵓⵜⵢⵜⵢⵜ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ⵎⵛⵏ ⵢⴰ ⵏⵙⵏ ⵏⵈⴾⵎ «ⵎⴼⵍ ⵤⴰ⵰ ⵎⴰ ⵗⵛⴹ⵰» ⵆⵍⵙⵏ ⵓⵏ ⵙ ⵙⵂⴾⵏ ⵎⵙⵍⵏⵙⵏ ⵓⵍⵏ ⵏⵏ «ⵜⵓⵜⵢⵜⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ⵏⵢ ⵀⵍⵜⵙ ⵙ ⵓⵔ ⴹⵈⵙⵍ ⵓⵍⴰ ⴹⵗ ⵓⵏ ⵎⵔⵏ ⵜⵏⵌⵔⵓⵢⵜ ⵜⵜⵜⵢ ⴹⴾⵍⴹⵓ ⵎⵏ ⵛⵔⴹ ⵙⵔⵙⵏ ⴼⵙⵏⵜ ⴹⵜ ⵜⵎⵜⵢ ⵏⴰ «ⵏⴾ ⵔⴹⴰ ⴹⵗ ⵤⵏⵢ ⵏⵍⵙ ⴹⵢ⵰ ⵀⵜⵓ ⵜⴹⵢ ⴾⵓⵏⵢ ⵜⵆⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ⵜⵌⵌⵢⵜ ⵜⵎⵜⵢ ⴾⵍ ⵜⵏⴰ «ⵓⵔⵜⵏⴰ ⵍⵈⵆ ⵏⵤⵏⵏⵜ ⵏⴾⵏⵢ ⴹⵀⵔⵔⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ⵜⵤⵔ ⴾⵙⵙⵏ⵿ⴹⵓ ⵀⵍⵜⵙ ⵀⵔⵗⵀⵙ ⵗⵢⵙⴰ ⵎⵔⵏ ⵙⵙⴶⵙ ⵜⵏⵗⵢ ⵍⵀⵙⵜ ⵙⵍⴾⴹ ⴾⴼⵢ ⵢ ⵙⵌⵜⵏ ⵢⴹ ⵜⵜⵢⵜⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ⵜⵤⵔ ⵓⵢⵏ ⵙⵌⵜⵏ ⵏⵏⵈⴾⵎ ⵀⵍⵜⵙ ⵗⵢⵙⴰ ⴾⵏ ⴹⵔⵙ ⵎⵙ ⵏⵗⵔⵗⵔ ⵏⵗⵍⴰ ⵏⵂⵏ ⵓⵏ ⵛⵔⵗⴰ⵰ ⵛⴹⵓⵏ⵿ⴹⵓ ⵙⵌⵜⵏ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵗⵍⵢⵗⵍⵢⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ⴾⵙⵏ ⴹⵗⵙ ⵜⵀⴹⵆⵏⵜ ⵙⵍⵙⵏ⵿ⵜⵓ ⵀⵔⵏⵤ ⴶⵏ ⵜⵤⵗⵢ ⵜⵙⵎⵗⵎⵗⵜ ⵤⵏ ⵓⴰ ⵍⵙⵏ ⵎⵏⴾⵍⵏ ⵎⵙ ⵓⵏ ⵜⵂⵍⵍⵜ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ⵤⴹⵏ ⵜⴾⵀⵜ ⵤⵏ ⵜⵏ ⵎⵏⴾⵍⵏ ⵜⴶⵜ ⴹⵗ ⵛⵏⵏⵏ ⵙⵓⵔⵏ⵿ⵜⵜ ⵢⵗⴼⵏⵜ ⴶⵏ ⴶⵀⵍ ⵏ⵿ⵜⵍⵏ⵿ⵜ ⴹⵗ ⴼⵙⵏⵜ ⵓⵏ ⵗⵍ⵰ ⵜⵤⵔ ⴹⵜⵙ ⵜⴶⵔⴼⵏ ⵜⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ ⴶⵏⵏⵙ «ⵢⴾ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ⴼⵍⵙ ⵙⵜⴼⵏ ⵜⵀⵤⵏ⵿ⴹⵓ ⴶⵀⵍ ⵏ⵿ⵜⵍⵏ⵿ⵜ ⵓⵏ ⴶⵜⵏ ⵙⵔⵙ ⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ⴹⴼⵔ ⵙ ⴹⵗⵙ ⵢⵓⵏⵏ ⴶⵢ ⵏ⵿ⵜⵎⴾⴾⵢⵜ ⴾⵙⵏ ⴹⵗⵙ ⵀⵔⵏⵤ ⵓⴰ ⵜⵙⵍⵙⵏ ⴹⵏ ⵙⵗⵍⵏ⵿ⵜⵓ ⵙⵍⵙⵏⵜ ⵓⵢⵏ⵿ⵜⵓ ⵢⴹ ⵜⵓⵜⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ⵂⵏ ⵜⵔⵢⵜ ⵙ ⵎⵏⵢⵏ ⴹⵙⵎⵗⵏ ⵎⵙⵏ ⵍⵙ ⵏⵗⵔⵎ ⵏⵆⵔⵓⵏ ⵛⵂⵛⵍⵏ⵿ⵜⵓ ⴶⵢ ⵏ⵿ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵤⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ⵓⴹⵏ ⴹⴶ ⵙ ⵜⵓⵏⵓ ⴶⵍⴶⵜⴰ ⵍⵎⵗⵏⴰ ⵏⵓⵏ «ⴹⴶ ⵓⵏ ⵜⴾⵢ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ⴾⴼⵏ⵿ⵜⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵔ⵿ⵜⵢⵏ ⴹⵤⵢ⵰ ⵔⵎ⵿ⵜⵏ ⵗⵢⵙⴰ ⴶⵢ ⵙ ⵜⵙⵢⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ⴹⴼⵔ ⵙ ⵜⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⴹ ⵜⵤⵏⵏ ⵛⵀⴹⵗⵏⵜ ⵙ ⵜⵛⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ⵜⵤⵔ ⵆⵎⵏ ⵓⵍⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ⵛⵍⵢⵏ ⴹⵏⴶ ⵗⴼⵏⵜ ⵙⵍⵎ ⴼⵍ ⴾⵜⵀ ⵙ «ⵓⴰ ⵗⵢⵙⴰ ⵓⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ» ⵎⵙ ⵓⵏ ⵔⵜ ⵙⴹⴶⵏⵏ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ⵜⵓⵜⵢⵜⵢⵏ ⴹⴶⵎⵏⵜ ⵛⵏ ⵎⴹⵏ ⵏ⵿ⵌⵌⵀ ⵏⵀⵢⴹⴶⵏ⵰ ⵂⴰ ⵢⵏ ⵗⵍⵏⵜ ⵓⴰ ⵂⴹⵏ ⵤⵍⴶⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ⴹⵗⵙ ⵜⵌⵀⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵍⵎⵏ ⴹⵏ ⵜⴶⵏⵙ ⵔⴾ ⵀⵜⵜⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ⴶⵏⵏ «ⴹⵓ⵰ ⴾⵢ ⵓⵔⴶⵗ ⵜⵏⵗ ⵜⴼⵔⴶⵗ ⵌⵀⵔⵌⵢ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵍⵙⵆⵓ ⴾⵔⵙ ⴹⵗ ⴾⵔⴹ ⴹⵏ⵰ ⴾⴹ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵙⴼⵙⵗ ⵎⵏⴾ ⵜⵤⵀⴹⵓ ⵜⴶⵜⵓⵜ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ⵎⴾⵏ ⴹⴰ ⵙ ⴹⵗⵙ ⵜⴶⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵎⴾⴾⵢⵜ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴶⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ⵍⵙ ⵓⴰ ⵙⴼⵙⵏ ⵢⵜⴹⵏ ⵓⵔ ⴼⵔⴶ ⵙⴼⵙⵢ ⵏⵎⵏⵜ⵰ ⴾⴹ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏⵙⵔⵢⵍ ⵤⵀⵜⵜⴹⵓ ⵜⴶⵜⵓⵜ ⵜⵏ⵰ ⴹⵢ ⵙⵔⵙ ⵏⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ⴶⴰ ⵜⵎⵏⵜ ⴹⵗ ⵎⵛⵏⴰ⵰ ⴶⵤⵜⵓ ⵎⵛⵏⴰ ⵎⵔⴹⴰ ⴾⴹ ⵔⵢ⵰ ⴼⵍⵙ ⵏⴰ \"ⵏⴾ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵙⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ⵌⵌⵀ ⵏⵀⵢⴹⴶⵏ ⵓⵏ ⴹⴶⵎⵏⵙ ⵜⵢⵜⵢⵏⵏ ⴹⴰ ⵂⵏ ⵛⵏⵜ ⵙⵎⴾⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ⵍⵙⵏⵜ ⵛⵢⵢ ⴾⵍ ⴾⵜⵏⵜ ⵀⵤⵏ ⵗⵔ ⵎⵙⵏⵤⵍ ⵂⵔ ⴹⴼⵔ ⵜⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ⵗⵔ ⵜⵢⵏ ⵏ⵿ⵜⵤⵔ ⴹⴾⵍ ⵗⵢⵙⴰ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⵏⴰ «ⵍⵢ ⵍⵢ ⵍⵎⴰ ⵙⵀⵈⵜⵏⵢ⵰» ⵍⵎⵗⵏⴰ ⵏⵓⵏ \"ⵎⵍⵏⵏ ⵎⵍⵏⵏ ⵎⴼⵍ ⵜⵢⵗⵢ ⴹⵎⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ⵙⵍⵏⵙ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵀⴹⴹⵏⵏ ⴹⵏ ⵏⵏ «ⵓⵏ ⵏⵀⵢ ⵍⵢⵙ ⵗⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ⵜⵔⵎⴹ ⵙ ⵤⵍ ⵢⵏ ⴹⵗⵙⵏ ⴹⴾⵍⴹⵓ ⵜⴹⴼ⵿ⵜ ⵙⵍⵎⵆⵜ ⴹⵗ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⴾⵤⵀⵔⵏ ⵓⵍⵏ ⵜⵍ⵿ⵜⵜ ⴹⵎⵢ ⵏⵍⵓⴶ ⵏ⵿ⵜⵍⵏ⵿ⵜ ⵤⵍ⵿ⵜⵏ ⵢ ⵗⵢⵙⴰ ⵢⴹ ⵛⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹ ⴶⵏⵏ ⵢⵢ ⴹ ⵏⵙⵏ ⴹⵙⵓ ⵍⵢⵙ ⵙⴼⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⵍⵙ ⵗⵢⵙⴰ ⴾⵙ ⵏⵎⵙⵍⵢ ⵙⵂⵏ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ⵙⵗⵜ ⵜⵏ ⴹⴰ ⴹⵗ ⵤⵔⵜ ⴼⵔ ⵓⴰ ⵤⵓⵔⵏ ⵎⵙⵏ ⵏⵗⵔ ⴶⵔ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⵓⴰ ⴶⵔⵏ ⵜⵤⴹⴾ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵔⵜⴹⵓ ⵏⵗⵔ ⵓⵏ ⵗⵔ ⴼⵍⴰ ⵂⵔ ⵔⵙ⵰ ⵏⴶⵢⵏⴶⵢ ⵎⴹⵍ ⴹ ⵜⵙⵔⵜⵏⵜ ⵜⵙⵍⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ⵏⵍⵎⵏ ⵤⴾⵓⵏ ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵏⵎⵜⵏ ⴶⵜⵏⵏ ⵎⵙⵏⵏ ⵏⵗⵀⴹⵏ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ⴶⵎⴹⵏ⵿ⴹⵓ ⵤⴾⵓⵏ⵰ ⴹⴼⵔ ⵜⵏⴾⵔⴰ ⵏ⵿ⵗⵢⵙⴰ ⴶⵤⵏ ⵗⵔⵎ ⵓⴰ ⵤⴹⴶⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵎⵙⵏ ⵢⵔⵙⵍⵎ⵰ ⵏⵎⵜⵏ ⵓⵏ ⴹⵏ ⵏⴼⵍⵍⵏ ⵢⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ⵙ ⵏⵢ ⴾⵀⵜⵏ ⴹⵙⵌⵜⵏ ⵓⵏ ⴶⵤⵏ ⵗⵢⵙⴰ ⵏⴶⵢⵏⴶⵢ ⵓⴰ ⴶⴰ ⵎⴹⵍ ⴹⵔⵜⵏ ⵓⵏ ⴶⵏⵏ ⴹⵏ ⵜⴶⵤⵜⵏ ⵜⵙⴰ ⵤⵓⵔⵜ ⵏⵏ «ⵍⴾⵏ ⵙ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ⵍⵏⵜ ⵜⴹⴹⵏ ⴶⵜⵏⵏ ⴹⵏ ⵀⴹⴹⵏⵏ ⵙⴹⵢ ⵙⵓⴹⵏⵜ⵰ ⵛⴹⴹⵏ ⵛⵏ ⴹⵏ ⵂⵔⵓⴰ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹ ⴹⵓⵏⵜ ⴹⵗⵢⵙⴰ ⵙⵏⵜ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ⵜⵂⵏⵜ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹⵎⵔⵢⵎⴰ ⵜⵏ ⵏⴰ ⵏⵢⵆⵀ ⴹⵢⵙⴼ ⴹⵏⴰ ⵏⵎⴹⵏⵙ ⵏ⵿ⵤⵀⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ⵍⵢ ⵍⵙ ⵏⵎⴶⵔⴶⵙ ⴶⵏ ⵙⵎ ⵢⵙⴼ ⵏⵗⵔⵎ ⵏⵔⵎⵜⵢ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ⵙⴹⵓ ⵗⵔ ⴶⴹⵍ ⵏ⵿ⵜⴼⴾ ");
INSERT INTO ttqt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ⴾⴰ ⵀⵍⵜⵙ ⴶⵎⵢ ⴹⵗⵙ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵜⵤⵔ ⵎⵔ ⵀⵍⵜⵙ ⵙⴹ ⵜⵓⵢⵓ ⵢⵙⴼ ⵓⵢ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ⴹⴾⵍ ⵢⵙⴼ ⵜⵗⵙⴰ ⵜⵏ ⴶⵜ ⴹⵗ ⵛⴼⵜ ⵜⵂⵙⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ⵓⵢⵜⵜ ⵙⵏ⵿ⵙⵜ ⴹⵗ ⵤⴾⴰ ⵢⵏⵢⵏ ⵎⵙⵏ ⴾⵤⵎ ⵙⵙⴶⴰ ⵢ ⵎⵏⵜ⵰ ⵜⵤⵔ ⵙⵗⵔⵔⴹⵓ ⵜⵂⵏ⵿ⵜ ⵤⵓⵔⵜ ⵂⵔ ⵙⵔⵙ ⵎⵢ ⵏⵤⴾⴰ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ⵜⵍⴰ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹⵏ ⴹⵎⵔⵢⵎⴰ ⵜⴰ ⵂⴹⵜ ⵆⵎⵏⵜ ⴹⵗ ⵜⵏⵎⵓⵍⴰ ⵏⵤⴾⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ⵙ ⴶⴰ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵎⵙⵏ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵙⵎⵜⴶ ⵏⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵍⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⴼⵔⵙⵢⵜⵏ ⴾⵏ ⵀⵍⵜⵙ ");
INSERT INTO ttqt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ⵏⵏⵙ «ⵢⴰ ⵎⵤⵔ ⵏⴾⵜⵓ ⵙ ⵏⵙⵀⵂⵏ ⵂⵔⵓⴰ ⴹⴰ ⴹⵔ ⴹ ⵏⴰ ⵢⵢⵜⴹⵏ \"ⴹⴼⵔ ⴾⵔⴹ ⴹⵏ ⴹⵜⵓⵙⵏ⵿ⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ⴹⵗ ⴹⵢ ⵎⵔ ⵙⴹ ⵜⵓⴶⵤ ⵤⴾⴰ ⵓⵏ ⵂⵔ ⵤⵍ ⵓⵏ ⴾⵔⴹ ⴼⵍ ⴹⵓⵔⵙⵏ ⵏⵍⴾⵎⵏⵜ ⴾⵔⵏ ⵜⵗⵙⵏⵜ ⴹ ⴶⵏⵏ ⵢⵢⵜⴹⵏ \"ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰\" ⵀⵂⵓ ⵓⴰ ⵙ ⴶⴰ ⴹ ⴶⵔ ⵓⴰ ⵤⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ⵰ ⴹⵓⵜ ⴹⵜⵙⴶⵔ⵿ⵜ ⵏ⵿ⵙⵌⵜⵏ ⵜⵤⵤⴶⵤⵎ⵿ⵜⵏ ⵤⴾⴰ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⵜⵔⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ⵜⵤⵔ ⴾⵏ ⵤⴾⴰ ⵗⴼⵍⵏ⵿ⵜⵓ ⵗⵔⴹⵏ ⵤⵤⵓⵢ ⵓⵍⵏ ⵢ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⵜⵂⵔⵜ ⵤⵤⴶⵤⵏ⵿ⵜⵓ ⵢ ⵙⵌⵜⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ⴹⴼⵔ ⵙ ⴾⵢ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴼⵓ ⵗⵔⴰ ⵏⵍⵈⴹ ⵜⴶⵍⴰ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹⵎⵔⵢⵎⴰ ⵜⴰ ⵂⴹⵜ ⵢⴹⵏⵢⵏⵜ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ⵂⵏⵏ ⵎⴹⵍ ⴶⴰ ⵏⴶⵢⵏⴶⵢ ⵙⵂⵏ ⴼⵍⵙ ⵢⵏ ⴹⵗ ⵏ⵿ⴶⵍⵙⵏ ⵏⵎⵍⵢ ⴹⵤⵀ ⴹⵗ ⵌⵏⵓⵏ ⵂⵤⵏ ⵤⴾⴰ ⵙⵗⵔⵔⴹ ⵜⵂⵏ⵿ⵜ ⵤⵓⵔⵜ ⵜⴰ ⵜⵜⵂⵔⵜ ⵆⵎ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ⵍⴰ ⵤⵂⵔ ⵏⵙⵎ ⵜⴶⴰ ⵜⵀⴹⵆⵏⵜ ⵜⵎⵍⵢ ⵜⵙⵔⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ⵜⴶⴰ ⵜⵢⵙⵙ⵿ⵜ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⴶⵤⵏⵏ ⵤⴾⴰ ⴼⵍ ⵓⴰ ⴹⵙⵏ⵿ⵜⴶⴰ ⵜⵙⴰ ⴹⵗ ⴶⵤ ⵤⵏ ⵜⵏⴶⵎⴹⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ⵛⵓⵍ ⵏ⵿ⴶⵍⵙ ⵏⴰ ⵢ ⵜⴹⴹⵏ ⵛⵏ ⴹⵏⵙⵏⵏ ⵤⴾⴰ ⵓⵏ «ⴾⵎⵜⵢ ⴾⵎⵜⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ ⴼⵍⵙ ⵙⵏⵗ ⵙ ⵗⵢⵙⴰ ⵙ ⵜⵙⴶⴹⵎⵜ ⵓⴰ ⵜⵓⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ⵓⵔ ⵍⴰ ⴹⴰ ⴼⵍⵙ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵙⵎⴾ ⵓⵙ ⵎⵍ ⵓⵏ⵰ ⴶⵍⵎⵜⴹⵓ ⴹ ⵜⵏⵢⵎⵜ ⴹⴶ ⵓⵙ ⴾⵍⴰ ⴹⵗⵙ ⵜⵏ⵿ⵙⴰ ⵜⵗⵙⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ⵜⴶⵍⵎⵜ ⵜⵔⵎⴹ ⵜⵎⵍⵎⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵙ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵤⵔⵙⵏⵏ ⵙ ⴶⵍⵍⵢⴰ⵰ ⴹⵏ ⴹⴰ ⵜⵤⵜⵏⵢⵎ⵰ ⴹⵢ ⴹⴰ ⵙ ⵔ ⴹⴾⵎⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ⴼⵍⵏⵜ ⵤⴾⴰ ⵜⵔⵎⴹ ⵜⵂⵏⵜ ⵜⵙⴰ ⵎⵛⵏ ⵢⴰ ⴼⵍⵓⵙⵏⵜ ⵓⵍⵏ ⵤⵍⵏⵜ ⴶⵏⵜ ⵙⵍⵏ ⵢ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ⴶⵍⵏⵜ ⴹⵏ ⴹⴰ ⵙ ⵎⵏⵢⵏⵜ ⴹⵗⵢⵙⴰ ⵏⵙⵏⵜ «ⵎⴰ ⵜⵈⵍⴾⵎⵜ⵰» ⵂⵤⵏⵜⵏ ⴶⵀⵔⵜⵏⵜ ⴹⵔⵏⵜ ⵙⵌⴹⵏⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ⵜⵤⵔ ⵏⵙⵏⵜ ⵗⵢⵙⴰ «ⴰ ⴾⵎⵜⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ⵰ ⴶⵍⵎⵜ ⵜⵏⵎⵜ ⵢ ⵎⴹⵔⵢⵏⵏ ⴹ ⴾⵏ ⴶⵍⵍⵢⴰ⵰ ⴹⵏ ⴹⵗ ⴹⵤⵏⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ⵂⵔⵓⴹⴰ ⵂⵏⵜ ⵜⵔⵢⵜ ⵙ ⴹⵓⴹⵏ ⵔⵜ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⴶⵤⵏⵏ ⵤⴾⴰ ⵗⵔⵎ ⵙⵗⵍⵏ ⵢ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵓⴰ ⴶⵏ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ⵜⵤⵔ ⵎⵏⵢⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵛⵏⴹⵏ ⴾⴼⵏ ⵙⵌⵜⵏ ⵓⵏ ⵤⵔⴼ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ⵏⵏⵙⵏ «ⵏⵓⵜ \"ⵏⵜⵍⵀⵏⵜ ⴹⵙⵏⵏ ⵂⴹ ⵏⵏ⵿ⵙⴰ ⴾⵔⵏ ⵜⵗⵙⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ⵙ ⵙⵍⴰ ⵏⵈⴾⵎ ⵀⵍⵜⵙ ⵔⵜ ⵓⴰ ⵜⵏⵙⵙⴶⵔⵓ ⵓⴰ ⵎⵙ ⵜⵆⵎⵎ ⴹⴰ ⵓⵔ ⴾⵓⵏⴶⵔⵓ ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ⴹⴾⵍⵏ ⵙⵌⵜⵏ ⵤⵔⴼ ⵎⵤⵍⵏ ⵙⵔⵜ ⵓⴰ ⴹⵙⵏⵜⵓⵏⵏ ⴹⵏ⵰ ⵍⵆⵙⵜ ⵜⴰ ⵜⵓⵤⵓⵤ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⵂⵔ ⵤⵍⴹⴰ ⵙⵗⵍⵏ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ⴶⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ ⴾⵏ ⴶⵍⵍⵢⴰ ⴶⵤⵢⵏ ⴹⵗⵗ ⵓⴰ ⴹⵔ ⵜⵏⵙⵏⵎⵓⵍ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ⵙ ⵏⵢⵏ ⵗⵢⵙⴰ ⵙⵌⴹⵏⵙ⵰ ⵎⵛⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⵏ ⴹⵗⵙ ⵛⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ⵜⵤⵔ ⵂⵤⵜⵏⵏ ⵗⵢⵙⴰ ⵛⵓⵍⵙⵏ ⵏⴰ «ⵜⵓⴾⴼⴰ ⵜⵗⵎⵔ ⴾⵍ ⴹⵗ ⵌⵏⵓⵏ ⵜⵓⴾⴼⵆⵜ ⴹⵗ ⴼⵍ ⵎⴹⵍ ");
INSERT INTO ttqt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ⴹⵗ ⴹⵢ ⴶⵍⵓⵜ ⵜⴾⵎ ⵛⵎⵜⵓⵏ ⴾⵍ ⵏⴹⵏⵜ ⵜⴶⵎ⵿ⵜⵏⵜ ⵏⵍⴾⵎⵏⵏ⵰ ⵙⵍⵎⵗⵜⵏ ⴹⵗ ⵎⵏ ⵙⵙⵎ ⵏⵀⴰ ⴹⵀⵔⵔ ⴹⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ⵙⵙⵗⵔⵓⵜⵏ ⵍⴾⵎ ⵢⵔⵜⵏ ⴾⵍ ⵓⵏ ⵙ ⴾⵓⵏⵎⵔⴰ⵰ ⵏⴾ ⵎⵔⵏ ⵙⵏⵜ ⵙ ⵍ ⵗⵔⵓⵏ ⴼⵓ ⵂⵔ ⵗⵔⴹ ⵏⴹⵏⵜ⵰»");
INSERT INTO ttqt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ⵏ⵿ⵜⴰ ⴹⴰ ⵜⵙⵏ⵿ⵜⵜ ⵏⵍⵏ⵿ⵌⵍ ⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵀⵔⵔ ⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ⵏ⵿ⵜⵏ ⴹⴰ ⴼⵍ ⵏⴰ ⵏⵀⵢ ⵙⵢⵙ ⴹⵗ ⵍⴾⵜⵀⵏⵜ «ⵏⵢ ⵤⴰ ⴹⵜⴾ ⵙⴶⵍⵗ ⵏⵎⵤⵍⵏ ⵤⴾⵏⵏ ⵜⵔⵢⵜⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⴹⵗ ⵙⴼ ⴶⵏⵓ \"ⵙⵎⵜⴶⵜ ⵀⵔⵆⴰ ⵢⵎⵍⵢ⵰ ⵜⵙⵙⵗⴹⵎ ⵜⵔⵢⵏ ⴹⵜⵙ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵙⴰ ⵢⵈⵢⴰ ⴶⵤ ⵙⴼ ⴹ ⵜⴶⵓ ⵢⵢⵜⴹⵏ ⵜⵍⵈⵜⵀⵜ ⴶⵏⵙⵏ ⴹ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⵙⴾⵏⵏ ⵜⵜⵀⵜⵏⵙⵏ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ⵜⵏ⵿ⵜⵙⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵏ⵿ⴶⵎⴹⵏⵏ ⴾⵍ ⴾⵜⵏⵜ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹⵢⵜⴹⵏ ⴾⵍ ⵏⵗⵔⵎ ⵓⵏ ⵢⵔⵙⵍⵎ⵰ ⵜⵜⵀⵏ ⴹⵗ ⵀⴾⴹⵏⵙⵏ ⴹⵜ ⵜⵎⵜⵢ ⵙⵍⵎⵆⵏ ⴹⵗ ⵎⵏ ⴹⵗ ⴶⵔⵓ ⵓⵙ ⵜⵓⵏⵓ ⵢⵔⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ⵙ ⵜⴶⵓ ⵓⵏ ⵤⵍⴶ ⵢⵈⵢⴰ ⵙⵍⵙⵓ ⴶⵏ ⵙⵏ⵿ⵤⴹⵏ ⵏⵎⵏⵙ ⵜⵀ ⵙⵙⵜⵀ ⵏⴶⵛⴾ⵰ ⴹⵔ ⵙⵌⵓⵍⵏ ⴹ ⵜⵔⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ ⴶⵏⵓ ⵢ ⵜⵎⵜⵢ \"ⴰ ⴹⴼⵔⵢ ⴹⵙⵓ ⵍⵙ ⵙ ⵓⴰ ⴹⴶⴰ ⴹⵗ ⵛⴶⵔⵜ ⵓⵔ ⵓⴹⴰ ⵓⵍⴰ ⵏⵤ ⵢ ⴹ ⵔⴰ ⵢ ⵙⵗⵏ ⵏ⵿ⵗⵜⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ⵏⴾ ⵎⵏ ⴹⵆⵓⵏ ⵙⵍⵎⵗⴰ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴰ ⴹⵆⵓⵏ ⵤⵙⵍⵎⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⴹⵙⴰ ⵗⵢⵙⴰ ⴶⵎⴹⵓ ⵏⵤⵔⵜ ⵜⵎⵙⵜ ⵜⵗⵔⵎ⵿ⵜ ⵜⵂⵜ ⴾⵍ ⵏ ⴶⵍⵍⵢⴰ⵰ ⴾⴰ ⴹⴶ ⵓⴰ ⴹⵗ ⵙⵍⵎⵗ ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⴹⵗ ⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⵙⵍⵎⵆⵓ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ⴶⵎⴹⵓ ⵗⵢⵙⴰ ⵎⵏ ⵗⵙ ⴶⴰ ⵌⵏⵓⵏ ⵙ ⵏⵍⵎⵏ ⵤⵀⵜⴹⵓ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵂⴰ ⵛⵛⵍⵏ ⵏ⵿ⵜⴹⵀⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ⴶⵎⴹⵓ ⵎⵙⵍⵢ ⵌⵏⵓⵏ ⵏⴰ «ⴾⵢ ⵎⵙⵏ ⵀⵔⵔⵏ ⴾⵏⵗ ⵜⵔⴰ ⵜⵙⵏ⵿ⴹⴹⵓ ⴶⵏⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⴹⵗ ⵙⴾⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵗⵢⵙⴰ ⵜⵏⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ⴶⴰ ⴹⵗⵙ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵤⵍ ⵜⵌⵔⵀⵜⵓ ⵀⵍⵙ⵰ ⵜⵏⵎⵔⵤⴶ ⴹ ⵓⵈⵙⵏ ⵙⵏⵏ ⴹⵗⵙ ⵏ⵿ⴶⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ⴹⴼⵔ ⵜⵔⵎⵙ ⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴹ ⴾⴰ ⵗⵢⵙⴰ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹⵗⵙ ⵎⵍ ⵎⵤⵍ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ⴶⵏⵓ ⵢ ⵜⵎⵜⵢ \"ⵜⵎⵙ⵿ⵜⵏ⵿ⵜ ⵜⵏ⵿ⴹⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⵤ⵰ ⵜⵀⵜ ⵜⵤⴶⵤⵏⵎ ⵙⵍⵏ⵿ⵌⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ⵤⵍ ⵢⵏ ⵍⵍ ⵗⵢⵙⴰ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⵙ ⴶⴰ ⵙⵎⵗⵏ ⴹⵎⴹⵔⵢⵏⵜ ⵏ⵿ⴹⵔⵓⵙ ⴼⵜⵓⵏ ⴹⵗ ⴶⵔⵓ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵓⵏ ⵙ ⵜⵀⵤⵏ ⴾⴼⵜⵏ ⴼⵍⵙ ⵏⵀⵤⵏ ⵏ ⴾⴼⵜⵏ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ⵏⵙⵏ ⵗⵢⵙⴰ \"ⵍⴾⵎⵜⵢ ⴾⵓⵏⴶⴰ ⵎⴹⵏ ⵙⵔⵢ ⴹⵤⵜⵓⵢⵏⵏ ⵢⵜⴹⵏ ⵢⵜⵏⵙⴼⵙⴰ ⴹⵗ ⵀⴾⴹⵏⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ⵢⵏ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵍⴾⵎⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ⴶⴰ ⵗⵢⵙⴰ ⵢⴹⴶⵏ ⵔⵜ ⵏⴾⵢ ⵏⵢ ⵢⵆⵀ ⴹⵎⴹⵔⵢⵏⵜ ⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵏⵙ ⵏ ⵤⵀⴹⵢ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵂⵏ ⵗⵍⵍ ⵏⵎⵏ⵰ ⴾⵏⵏ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵓⵏ ⵙ ⵜⵀⵤⵏ ⴾⴼⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ⵗⵔⵏ⵿ⴹⵓ ⴹⵗ ⵎⵤⵢ ⵓⵏ ⴹⴰ⵰ ⵢⵏ ⵀⵏⵙⵏ ⵤⵀⴹⵢ ⴹ ⵎⵛⵗⵍⵏⵜ ⴹⵗ ⵗⵍⵍ ⵍⴾⵎⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ⴾⴰ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵜⵗⵔⵎ⵿ⵜ ⵜⴶⵜ ⴾⴼⵔⵏⵂⵎ⵰ ⵓⴹⵓ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵗⵙ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗⵙ ⵙⵙⵗⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ⵙⵎⴾⵍⵍ ⵙ ⵜⵎⵜⵢ ⵎⴾ ⵓⵙ ⵜⴶⵓ ⵙⵙⵗⵔⵏⵜ ⴼⵍⵙ ⴶⵙⵏ ⵙⵙⵗⵔⵢ ⵏⵓⴹⵏ ⵍⵏ ⵜⵏⵢⴰ ⵓⵔ ⵍⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ⵓⵍⴰ ⵂⴶⵏ ⴹⴾⵍ ⵍⵙ ⵢⵏ ⵂⴰ ⴶⵙⴼ ⵎⵙⵍⵏⵜ ⴹⵗ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⴹ ⴶⵏⵓ ");
INSERT INTO ttqt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"ⵎⴰ ⴹⵗⵏⴰ ⵜⵔⵗ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ⵰ ⵏ⵿ⴶⵎ ⵙⴰ ⴹⵜⴶⵗ ⵢⴹⵏⵗⵜⵂⵍⴾⴰ⵰ ⵙⵏⵗ ⵓⴰ ⵜⵎⵙⴰ ⴾⵢ ⵎⵙⵏ ⵎⵤⴹⴶ ⵓⴰ ⴹⵤⵎⵤⵍ ⵎⵛⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ⵂⵔⵛⵜⵓ ⵗⵢⵙⴰ ⵏⵙ \"ⴼⵙ⵿ⵜⵓ ⵜⴶⵎⴹⵗ ⵍⵙ ⴹⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ⵜⵤⵔ ⵤⵤⴾⵔⴾⵔ ⴶⵙⴼ ⵍⵙ ⵏ ⵤⵢⴾ ⴶⵎⴹⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ⵂⴶⵏ ⵢⵜⴹⵏ ⴾⵜⵏⵙⵏ ⴹ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ \"ⵎⴰ ⵎⵙ ⵓⴰ⵰ ⵎⴰ ⵜⵎⵙ ⵎⵙⵏⵜ ⵜⴰ ⵓⵔ ⵏⵤⴹⵢ ⴰ ⵜⴹⵓⵜ ⴹ ⵜⵏⵢⴰ⵰ ⵓⴹⵏ ⵓⴰ ⵓⵍⴰ ⴾⵍⵙⴼ ⵜⴼⵏ ⵜⵏⵏⵜ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ⵜⵔⵎⴹ ⵙ ⵜⵓⵤⵓⵤ ⵙⵍⵜ ⵏ ⵗⵢⵙⴰ ⴹⵗ ⴶⵍⵍⵢⴰ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ⴶⵎⴹⵓ ⵗⵢⵙⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵗⵙ ⴾⴰ ⵂⵏ ⵏ⵿ⵙⵎⵗⵏ ⴹⵏ⵿ⴹⵔⵓⵙ ⴹⵓ ⴹ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⴹⴶⵍ⵿ⵜ ⵏ⵿ⵙⵎⵗⵏ ⵜⵤⵤⵍⵍⵜⵜ ⵜⵏⴹⵢ⵰ ⵙⵏ ⵗⵢⵙⴰ ⵗⵙ ⵜⵜⵎⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ⵜⵤⵔ ⵙⵜⵏ ⵀⵤ ⴼⵙⵏⵜ ⵙⵀⴹⴹⵜⵜ ⵜⵓⵜ ⴼⵍⵙ ⵜⵏⴹⵢ ⵜⵏ⵿ⵜⵙⵎⴶⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵙⵔⵙ ⴹⵜⵎⵓⵢⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵔⵏⵏ ⴹ ⵓⵏ ⵂⵏ ⴾⵍⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ⴹⵓⴹⵓ ⵗⵔⵎ ⴾⵜⵏⵜ ⴹⵜ ⵎⵢ ⵏⵂⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ⵤⵤⵢ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵔⵓⵏⵜ ⵜⵓⵔⵏⵓⵏ ⵓⵔ ⵏⵍⴰ ⴾⵙ ⴹⵗ ⴹⵗ ⵓⵢⴹ ⴾⵍⵙⴼ ⴶⵜⵏⵏ⵰ ⵎⵔⵏ ⴶⴹⵍ ⵢ ⴾⵍⵙⴼⵏ ⵎⵍ ⵏⵓⴰ ⵎⵙ ⴹ ⵎⵙⵏⵜ ⴶⵏ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵏ⵿ⴾⵔⴹⵓ ⵗⵢⵙⴰ ⴹⵜⵤⵍ ⴶⵎⴹ ⴾⴰ ⴹⴶ ⵙⴼⵏ ⴹ ⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ⴹⴼⵔ ⵓⵏ ⴶⵍⴰ ⵙⵎⵗⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵗⵔⵙ ⵍⵏⵏ ⴹⵙⴶⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ⵙ ⵜⵏⵙⵏ ⵏⵏⵙ «ⵢⵜⴹⵏ ⴾⵍ ⵙⴶⴹⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ \"ⴾⵓⵜⵏⴰ ⵛⵗⵔⵎⵜⵏ ⵛⵏ ⴹⵏⵗⵍⵢⵗⵍⵢⵏⵏ ⴹⵗⵙⵏⵜ ⴶⴰ ⵜⵍⵈⵜⵀⵜ ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ ⴼⵍⵙ ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵎⵤⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ⵍⵍ ⵗⵢⵙⴰ ⴾⵍ ⵏ ⴶⵍⵍⵢⴰ ⴾⵜⵏⵜ ⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⴾⵙ ⴹⵗ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ⵙⴹⵓ ⵓⴹⵏ ⵢⵏ ⵜⴶⵔⵓ ⵜⵓⵔⵏⴰ ⵏ⵿ⴾⵜⵔⵓ ⴶⵔⴼⵜ ⴹⵜ ⵗⵢⵙⴰ ⵏ⵿ⵙⵢⵜⵓ ⵏⵙ «ⵙ ⵜⵔⵗ ⴹⵢ ⵜⴼⵔⴶⵗ ⴹⵜⵤⵤⵢⵗ ⵤⴹⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ⵂⵏⵜⵜⵙ ⵗⵢⵙⴰ⵰ ⵤⵍⵏ ⴼⵙⵏⵜ ⴹⵙ⵿ⵜⵓ ⵏⵙ \"ⵔⵗ ⴹⵢ ⵤⵢ ⵜⵤⴹⴶⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ⵤⵢ ⵓⴹⵏ ⵓⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵤⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ⵙⵍⵎ⵿ⵜⵓ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹⴼⵔ ⵙ ⴹⵙⵔⵗⵎ ⵓⵍⵏ ⵏⵙ «ⵏⵢ ⵤⴰ ⴹ ⵓⵔ ⵜⵎⵍⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵔⵜ ⵓⴰ ⴶⵏ ⴹⴰ ⵎⵔⵏ ⴶⵍⵓ ⵜⵙⴾⵏⵗ ⵎⵏⴾ ⵢⵍⵎⵎ ⵜⴶⴰ ⵜⴾⵜⵢ ⵏ⵿ⵜⵤⴹⴾ ⵜⴰ ⴾⵢⵙⵓⵔ ⵛⵔⵗⴰ ⵏⵏⵀⵢ ⵎⵙⴰ ⴹ ⵆⵍ ⴹⵢ ⵢⵢⵜⴹⵏ ⵜⴶⵢⴰ ⵏ⵿ⵜⵎⵤⵢⵜⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ⵎⵛⵏ ⴶⵍⴰ ⵍⵙⵏ ⵗⵙ ⴶⵤ ⵛⵏ ⵤⵓⵤⵓⵤ ⵏ ⵙⵍⵏ ⵏⵓⴰ ⴶⵏ ⵂⵔ ⵀⵙ ⴼⵔⴶ ⵗⵢⵙⴰ ⴶⵤ ⵏⵗⵔⵎ ⵂⵏⵢⵏ⵿ⵜⵓ ⵢⵜⴹⵏ⵰ ⵓⵏ ⴹⵗ ⴼⵍ ⴶⵤ ⵙⴼ ⴹⵗⵙ ⵜⵏ⵿ⵜⵙⵏ ⵢⵜⴹⵏ ⵙⵔⵙ ⴹⴶⵎⴹⵏⵏ ⵛⵙⴹⴶ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ⴹⵏ ⴹⴼⵔ ⵓⵏ ⵆⵍ ⵗⵢⵙⴰ ⵗⵔⵎ ⵏ ⴾⴼⵔⵏⵂⵎ⵰ ⵙⵍⵏ ⵢⵜⴹⵏ ⵙ ⵂⴰ ⵂⵏ ⵓⴰ ⴹⵗ ⵙⴶⵏ ⵗⵙ ");
INSERT INTO ttqt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ⴾⵏ⵿ⵜⴹⵓ ⵙⴶⵜ ⵂⵔ ⵙ ⵀⵙ ⵜⵂⴰ ⴹⴶ ⵓⵍⴰ ⵗⵙ ⴹⵜ ⵎⵢ ⵏⵂⵏ⵰ ⴹⵙⵏⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ ⴹⴰ ⴹⴰ ⵙ ⴹⵙⴹⵎⵓⵢ ⵏⵀⴹⵏ ⵎⵙⵓⵢⵏ ⵎⴹⵏ ⴾⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ⵎⵛⵏ ⵔⵏⵙⵏ ⵜⵏⵓⴹⵏ ⴼⵍ ⴶⵜ ⵏⵢⵜⴹⵏ⵰ ⵓⵔⵏ ⴼⵍⴰ ⵏ ⵜⵗⵤⵎ⵿ⵜ ⴼ⵿ⵜⵢⵏ ⵙⴼⵍ ⴹⵗ ⵜⵏⵎⵓⵍⴰ ⵏⴹⴶ ⵓⴰ ⵂⴰ ⵗⵢⵙⴰ⵰ ⵜⵤⵔ ⵙⵔⵙⵏ⵿ⴹⵓ ⵏⵀⴹⵏ ⵓⴰ ⴹⵗ ⵜⵈⵔⵀⵜ ⵜⴰ ⴶⵏ ⴹⵏ ⵤⵍⵍⵜ ⴹⵗ ⵜⵙⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵤⴶⵤⵏⵙⵏ ⵏⴰ ⵢⵏⵀⴹⵏ ⵓⵏ \"ⵀⵔⵔⵏ ⵀⴾⴹⵏⴾ ⵜⵓⵙⵔⴼⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ⵓⵏ ⵙ ⵜⴶ ⵆⵎⵏ ⵔⵜ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵙⵍⵏ ⵢⵓⴰ ⵏⴰ ⵗⵢⵙⴰ ⴹⴰ ⵗⵙ ⴹ ⵜⵂⵏ⵿ⵤⵎⵏ ⴹⵗ ⵎⵏⵙⵏ ⴶⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ⵓⴰ ⵍⵙ ⵎⴰ ⵜⵙⵂⵍⵏ ⴶⵢ ⵏⵓⵍ ⵓⴰ⵰ ⵔⵜ ⵓⴰ ⵎⴹⵔⵓ⵰ ⵎⴰ ⴼⵔⴶⵏ ⵙⵔⴼ ⵏ ⵀⴾⴹⵏ ⵔ ⵎⵛⵏⴰ ⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⵓⴰ ⵙⵎⴹⵔⵏⵏ ⵜⵤⵔ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵜⵂⵏ⵿ⵤⵎⵎ ⴹⵢ ⴹⵗ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ⵎⴰ ⴶⵔⵏ ⵜⵔⵗⵙⵢ ⴶⵔ ⴹ ⵜⵏⴰ ⵢⵏⵀⴹⵏ \"ⵜⵓⵙⵔⴼⵏⴾ ⵀⴾⴹⵏⴾ\" ⵎⵗ ⴾ ⴹⵙ⵿ⵜⵏⴰ \"ⵀⴹⴹ ⵜⴹⴾⵍⴰ ⵜⵙⵜⵏⴾ ⵜⵌⵓⵏ⵿ⴾ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ⵎⵔⵏ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵍⵗ ⴹⵗ ⴹⵏⵜ ⵜⵏⵢⴰ ⴹⵜⵛⵛⵓⴹⵜ ⴹ ⵙⵔⴼⴰ ⵢⵓⴹⵏ ⵀⴾⴹⵏⵜ⵰» ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢⵏⵀⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ⵀⴹⴹ ⵜⴹⴾⵍⴰ ⵜⵙⵜⵏⴾ ⵜⴾⵗ ⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ⵀⴹⴹ ⵍⵙ ⵓⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⴾⵍ ⵜⵙⵜⵏⵜ⵰ ⴶⵎⴹ ⵙⵓⴹⵏ ⴹⵗⵙ ⵢⵜⴹⵏ ⴾⵍ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⵎⵍⵏ ⵎⵛⵏⴰ ⴶⵏⵏ «ⵓⵔ ⴾⵍⴰ ⴹ ⵏⵏⵢ ⵔⵜ ⵛⵍⵜ ⵏ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ⴶⵎⴹ ⵗⵢⵙⴰ ⵗⵔⵎ ⵍⵙ ⵜⵓⵗⵍⵢ ⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ⵜⵏ⵿ⵜⵙⵏ ⵢⵜⴹⵏ ⵙⴶⵜ ⵙⵙⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ⵌⵓⵏ⵿ⴾⵜ ⵙ ⵏⵢ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵍⵀⵢ ⴶ ⵍⴼⵢ ⵆⵎ ⴹⵗ ⴹⴶ ⵏⵛⵗⵍⵏⵜ ⵎⵙⵏ ⵤⵔⵤⵎ ⵏⵤⵔⴼ ⵏ⵿ⵜⴾⵙⵏ ⵏⵙ ⵗⵢⵙⴰ \"ⵍⴾⵎⵢ⵰\" ⵀⴹⴹ ⵍⵀⵢ ⵍⴾⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ⵏⴼ⵿ⵜⵗ ⵗⵢⵙⴰ ⵢ ⵍⵀⵢ⵰ ⴹⵔⵓ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵏⵙⵀⴾⴹⵏ⵰ ⵢⵜⴹⵏ ⵛⵍⵜ ⵏ ⵓⵏ ⴶⵜⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ⵙ ⵏⵢⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵏ ⵜⴶⵢⵜ ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⵗⵢⵙⴰ ⴹⵔⵓ ⴹⵏⵙⵀⴾⴹⵏ ⴹⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⵏⵏ ⵢ ⵏⵜⵍⵀⵏⵜ \"ⵎⴼⵍ ⴹⵔⵓ ⵍⴼⵆⵏⵓⵏ ⴹ ⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵏⵙⵀⴾⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ⵙⵍⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵗⵍⵢ ⵓⵔ ⴹⵔⵔⵏ ⵙⵏⵙⵎⴶⵍ ⵎⵔⵏⵏ ⵙⵔⵙ ⴹⵔⵔⵏⵏ⵰ ⵏⴾ ⵓⵔ ⴹⵎⵤⵍⴰ ⵙⵢⵜⴹⵏ ⵓⵏ ⵗⵔ ⴶⴰ ⵙ ⵗⴹⵏ ⴾⵍⵔ ⵏⵙⵀⴾⴹⵏ ⵙ ⴹⵎⵤⵍⴰ ⵢⵜⵏ⵿ⴹⵗⵔⴰ ⵆⵍⵏ ⵏⵍⴾⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ⵤⵍ ⵢⵏ ⴹ ⵤⵎⵏ ⵏⵜⵍⵀ ⵏ ⵢⵈⵢⴰ ⴹ ⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵙⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵓⵢⴹ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴼⵍ ⵜⵤⵎⵏ ⵏⵜⵍⵀ ⵏⵢⵈⵢⴰ ⴹ ⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵎⵔⵏ ⵓⵏⴾ ⵓⵔ ⵜⵤⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵏⵎⴾ ⵙ ⵤⴾⵍⵏ ⵍⴶⵜⵏ ⵗⵔ ⵍⴰ ⵎⵤⵍⵢ ⵙ ⵎⵓⵏⵙⵏ⵰ ⴾⵍⵔ ⴾⵜ ⵍⴰ ⵗⵔⵙⵏ ⵓⵔ ⵤⴾⵍⵏ ⵙ ⵎⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ⵎⵛⵏ ⵍⴾⵎ ⵤⵍ ⵗⵔⵙⵏ ⵤⵎⴹⴾⵍ ⵎⵤⵍⵢ ⵤⵍ ⵓⴹⵢ ⵎⵔⵏ ⴹ ⵤⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ⵓⵔ ⵜⵍⴰ ⵢ ⵤⵓⵜⵏ ⴹⵗ ⵜⵀⴹⵆ ⵓⵛⵔⵜ ⵛⴾⵙ⵿ⵜ ⵜⵢⵏⵢⵜ⵰ ⵙ ⴶⴰ ⴹⵢ ⴹ ⵜⴾⵓⵏ⵿ⵤⵤ ⵛⴾⵙ⵿ⵜ ⵜⴹⵢ ⵜⵛⵜⵓ ⵜⵀⴹⵆ ⵜⵏ ⵤⵔⵓ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵢ ⵤⴶⵏ ⵙⵎⴹ ⵏⵤⵀⵀ ⵢⵏⵢⵏ ⴹⵗ ⴶⴹⴹ⵰ ⴼⵍⵙ ⵙ ⴶⴰ ⴹⵢ ⴹ ⴾⴼⵏ ⵀⵆⵏ ⴼⵜⵓ ⴹⵗ ⵙⵎⴹ ⵓⴹⵢ ⴶⴹⴹ ⴹⵗ ⵈⵛⴹⵏ⵰ ⴾⵍⵔ ⵙⵎⴹ ⵏⵤⵀⵀ ⵓⴰ ⵢⵏⵢⵏ ⵀⵢⵗ ⵢⵏⵢⵏⵏ ⴹⵗ ⵜⵓⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ⵤⵍ ⵢⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵌⵓⵏ⵿ⴾⵜ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵜⵓⴶⵙ ⵏⵍⴾⵎⴰ⵰ ⵌⵓⵏ⵿ⴾⵏ ⵏⵜⵍⵀⵏⵜ ⵔⵙⵀⵏ⵿ⴹⵓ ⵛⵗⵗⵏⵏ ⵜⵜⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ⵜⵤⵔ ⵙⵙⴶⵔⵏⵏ ⴼⵔⵙⵢⵜⵏ ⵗⵢⵙⴰ ⵓⵏ ⵏⵏⵙ \"ⵏⴾ ⵓⴰ ⵜⴶⵏ ⵏⵜⵍⵀⵏⴾ⵰ ⵎⴼⵍ ⵜⴶⵏ ⵔⵜ ⵈⵔⵎⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ⵏⵙⵏ «ⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⴹⵓⴹ ⵙⵗⴰ ⵓⴹ ⵎⵗⵜⵔ ⵜⵤⵔ ⴶⵤⵜⵓ ⴶⵍⴾ ⵏ⵿ⵜⴰ ⴹ ⵎⴹⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ⵓⴾ ⵓⵔⴶⵗ ⴶⵤ ⴶⴰ ⵂⵏ ⵏ ⵎⵛⵏⴰ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹⵗ ⵎⵙ ⵀⵢⵜⵔ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵜⵤⵔ ⵜⵛⴰ ⴹⵗ ⵜⴶⵍⵓⵏ ⵛⵏ ⵎⵙⵏⵏ ⵜⴾⵜⵢ ⵜⵙⴾⵜⵜ ⵢ ⵎⵛⵏⴰ ⵙ ⵍⵎⵎⵏ ⵗⵙ ⵙ ⵜⵈⵍⵍ ⵜⵜⵢⵏⵙⵏⵜ⵰ ⴼⴹⴰ ⴾⴼⴰ ⴹⵗⵙⵏⵜ ⵎⴹⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ⵏⵙⵏ ⴹⵗ «ⴶⴹⵎ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⴹⵜⵓⵈⵍⴾⵏ ⴼⵍ ⴹⵍⵍ ⵏⵙⵀⵜ ⴾⵍⵔ ⵙⵀⵜ ⴹⵜⵜⵓⵈⵍⴾⵜ ⴼⵍ ⵜⵏ⵿ⴼⴰ ⵏⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ⴹⵗ ⴹⵢ ⵏⴾ ⴶ ⴶⴹⵎ ⵈⴾⵎⵏ ⴼⵍ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ⵍⵙ ⵗⵢⵙⴰ ⴶⵤ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴾⴼⵔⵏⵂⵎ⵰ ⵍⴰ ⵍⵙ ⴹⵏ ⵙ ⵎⵜ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ⵜⵤⵔ ⴶⵔⵏ ⴹⵗⵙ ⴼⵔⵙⵢⵜⵏ ⵛⵜⵓⵏ ⵢⴹ ⵙⵏⵏ ⴾⴹ ⴹ ⵤⵤⵢ ⵓⴹⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴼⵍ ⴹ ⵜⵈⵜⵙⵏ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ⵏⴰ ⵗⵢⵙⴰ ⵢⵍⵙ ⵓⵙ ⵎⵜ ⴼⵙⵏⵜ ⴹⴰ «ⵏ⵿ⴾⵔ ⵀⴹⴹ ⴹⵗ ⵎⵙ ⵏⵍⵌⵎⵗⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ⵎⵔⵏ ⵏⴰ ⵢⵍⵌⵎⵗⵜ «ⵓⴾ ⴹⵗ ⵓⴰ ⵏⴰ ⵜⵓⵔⵜ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵢ ⵏⵔⵜ ⵍⵗⵏ ⴹⵗⵙ ⵈⵍⵍⵏ ⵎⵗ ⴾ ⴶⵢ ⵏ ⵓⴰ ⵓⵔ ⵏⵍⵗ⵰ ⵓⴾ ⵔⴶ ⵏⵓⴹⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵗ ⴾ ⵛⵢⵜⵏⵜ ⵂⵍⴾ⵰» ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴹⵙⵏⵏ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ⵙⵍⵍ⵿ⵜⵏ ⵗⵢⵙⴰ ⵙⵓⴹⵏⵜ ⵂⵢ ⵍⵂⵎ ⵜⵗⵛⴹ ⵜⵗⵔ⵿ⵜ ⵜⴰ ⴶⵏ ⵓⵍⵏⵙⵏ ⵎⵏⵜ ⵓⵍⵏ⵰ ⵜⵤⵔ ⵏⴰ ⵢⵍⵙ ⵓⵏ «ⵤⵍ ⴼⵙⵏⴾ⵰» ⵤⵍ⵿ⵜⵓ ⵤⵢ ⵆⵍ ⵎⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ⴶⵎⴹⵏ ⴼⵔⵙⵢⵜⵏ ⵗⵙ ⴾⵏ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵏⵂⵔⴹ ⵓⵏ ⵏⵎⵏⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹⵔⵙⵏ ⵜⵏⵎⵛⵓⵔⵏ ⴼⵍ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵏ ⵎⵏ ⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ⴹⵓ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴾⴰ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ⵜⴹⵓ ⴹⵔⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵙⵢⵜ ⴾⵍ ⵏ ⴶⵍⵍⵢⴰ ⴹⵜⴶⵎⴹ ⵢⵜ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ⵢⵜ ⵗⵔⵎ ⵏ ⵢⵔⵙⵍⵎ ⵢⵜ ⴾⵍ ⵏⴹⵎⵢ ⴹ ⵎⴹⵍⵏ ⵓⵏ ⵓⵔⵏⵏ ⴶⵏⴰ ⵓⵏ ⵙⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⵢⵜ ⵎⴹⵍⵏ ⵓⵏ ⵂⵤⵏⵏ ⵗⵔⵎ ⵏ ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ ⴹⵜⴶⵎⴹ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴾⵍ ⵜⵙⵍⵢ ⵏⵔⵜⵏ ⵓⵏ ⵜⴶⵓ ⵗⵢⵙⴰ ⵜⵏ⵿ⴹⵜⵓⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ⵓⴰ ⵜⴶⴰ ⵜⵎⵜⵢ ⴹⵗ ⴶⵜ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⴹⵙⵎⵜⴶⵏ ⵗⵍⵍ ⵏⵎⵏ ⵢⵜⴶⵤ ⵙ ⵜⵜⵙⵙ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ⴼⵍⵙ ⵤⵤⵢ ⴹⵗⵙⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵓⵢⴹⵓ ⵓⵏ ⵙ ⴼⵍⵙ ⵜⵏⵀⴹⵗⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵔⵏⵏ ⴶⵎⵢⵏ ⴹⴹⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏ ⴾⵍⵙⴼ ⵏ⵿ⵜⵏⵢ ⴹ ⵏⵢⵏ ⵗⵢⵙⴰ ⴹⵙⵙⵌⴹⵏ ⵤⵢⴾⵏ ⴶⵏⵏ «ⴾⵢ ⵎⵙⵏ ⵀⵔⵔ ⵏ ⵎⵛⵏ» ");
INSERT INTO ttqt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ⵎⵛⵏ ⵔⵆⵎⵙⵏ ⵗⵢⵙⴰ ⵓⵍⵏ ⴼⵍ ⵎⵍ ⵏⵓⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ⴾⴰ ⵗⵢⵙⴰ ⴼⵍⴰ ⵏⴹⵗⵗ ⵢⵏ ⵗⵔⵏ ⵎⴹⵏ ⵓⵏ ⵂⵏⵏ ⴶⵏⵏⵜ ⵙⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ⵙⵏⴼⵔⵏ ⴹⵗⵙⵏ ⵎⵔⵓ ⴹⵛⵏ ⵓⵏ ⴹⵔ ⵤⵜⴹⵓ ⴶⵙⵏ ⵙⵎ ⵏⵎⵤⵍ⵰ ⵙⵏⴼⵔⵏ⵿ⵜⵏ ⴹⵗ ⵢⴹ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ⴾⴼⵏ ⴹⵗ ⵜⵔⵏⴰ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ⵏ⵿ⵜⵏⵢ ⴹⵢ ⵙⵎⵓⵏ ⵏ ⵎⵔⵓ ⵎⴹⵏ ⴹⵛⵏ ⵓⵏ ⵙⵏⴼⵔⵏ ⵙⵎⵗⵏ ⵓⵙ ⴶⴰ ⵙⵎ ⵀⵜⵔⵙ ");
INSERT INTO ttqt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ⴹ ⵢⵆⵀ ⴹⵎⴹⵔⵢⵏⵜ ⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵏⵙ ⵏ ⵤⵀⴹⵢ ⵓⵏ ⵙ ⴶⴰ ⵙⵎ ⵀⵂⵏⵔⴶⵙ ⵍⵎⵗⵏⴰ ⵏⴹⵢ ⵎⴹⵏⵙ ⵏ ⵜⵆⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ⴹⵏ⵿ⴹⵔⵓⵙ ⴹ ⴼⵍⵀⵙ ⴹ ⵀⵔ⵿ⵜⵍⵎⵓⵙ ⴹ ⵎⵜⴰ ⴹ ⵜⵎⴰ ⴹ ⵢⵆⵀ ⵓⵏ ⴶ ⵍⴼⵢ ⴹ ⵜⴹⵢ ⴹ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵓⴰ ⵙⴶⵜⴾⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ⴹ ⵢⵂⵤⴰ ⵙⵈⵔⵢⵜⵢ ⵓⵙ ⵏ⵿ⵜⴰ ⵤⵙⵜⵔⵎⵙⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ⴹⴼⵔ ⵓⵏ ⵆⵍⴹⵓ ⵗⵢⵙⴰ ⵂⵏ ⵓⴰ ⴹⵗ ⵙⴶⵏ ⴹⵗ ⴾⴼⵔⵏⵂⵎ⵰ ⵜⵍⵙ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴹⵓⵜ ⵙⵓⴰ ⵜⴶⴰ ⴹⵗ ⴶⵜ ⵀⵙ ⵓⵍⴰ ⵍⵓⵆ ⴹⵗ ⴶⵔⵓ ⵙ ⵜⵜⵢ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ⵙⵍⵏ ⵎⵔⵓⵏⵜ ⵓⵏ ⴾⵏ⵿ⵜⴹⵓ ⵢⴹ ⵜⵀⵤⵏ ⴶⵍⵏ ⴹⵔⵙ ⴼⵍⵙ ⴶⵏⵏ «ⵓⴰ ⵔⵜ ⵜⵎⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ⴶⴹⵏ⵿ⴹⵓ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵓⵢⴹ ⴹⴶⵎⴹⵏⵏ ⵢⵔⵙⵍⵎ ⴹ ⴶⵏⵏ «ⵓⴰ ⵛⵢⵜⵏ ⵀⵗⵍⵤⵀⵍ ⵓⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵙⴼ ⵜⵂⵏ ⵏ⵿ⵜⴰ ⵜⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ⵜⵤⵔ ⵗⵔⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⴶⵙⵏ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⴹⵗ ⴹⵙⵏⵏⴰ «ⵎⵏⵎⴾ ⵙ ⵤⴾⵙ ⵛⵢⵜⵏ ⴹⵗ ⵢⵜⴹⵏ ⴾⵍⵙⴼⵏⵜ ⵙⵏ⵿ⵜⴰ ⵙ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ⵜⵗⵎⵔ ⵜⵙ ⵎⴶⵔⵏ ⵎⵙⵓⵙ ⴶⵔⵙⵏ ⵜⴹⵢ ⵀⵔⵌⵢ ⵤⴰ ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ⵗⵢⵓⵏ ⵢⵏ⵿ⴹⴰ ⴹⵗ ⵙ ⵎⵤⵔⵢⵏ ⵎⵙⵓⵙ ⵓⴹⵢ ⵀⵔⵌⵢ ⵤⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ⵤⵏ ⴹⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⴾⴹ ⵛⵢⵜⵏ ⵎⵏⵜ ⴹⵔ ⵎⴶⵔ ⵓⴹⵢ ⵜⵗⵎⵔⵏⵜ ⵓⵔ ⵤⴰ ⵜⵂⴶ⵰ ⵀⵔⵌⵢ ⵤⴰ ⵜⴶⵓ ⵜⵗⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ⵓⵍⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⴶⵤ ⵏⵂⵏ ⵏⵍⵙ ⵏⵎⵆⵔⴹ ⵗⵔⴹ ⵆⴰ ⵏ⵿ⵜⵍⵏⵜ ⵔ ⵙⴹ ⵜⴾⵔⴹ ⵜⵤⵔ⵰ ⴹⴼⵔ ⵙ ⵜⴾⵔⴹ ⵎⵔⵏ ⴹ ⵤⴼⵔⴶ ⴹ ⵗⵔⴹ ⵆⴰ ⵏ⵿ⵜⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⵀⴾⴹ ⴹⵍⴼⵓⵈⵛ ⵙ ⵓⵔ ⴼⵔⴶ ⵎⵛⵏⴰ ⵜⵙⵔⴼ ⵢⵓⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ⵔ ⵍⴼⵓⵈⵛ ⵎⵙⵏ ⴾⵙ ⵏ⵿ⵜⵔⵏⴰ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴼⵍⵙ ⵀⴾⴹ ⴹⵢ ⵗⵍⵍⵏ ⴼⵍ ⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ⵀⵜⵓ ⵜⴰ ⴶⵙⵏ⵿ⵜⵜ ⵗⵢⵙⴰ ⴼⵍⵙ ⵜⵏⴰ ⵜⴶⵏ «ⵂⵢ ⴶⵙⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ⵜⵙⴹⵓ ⵏⴰ ⵏ ⵗⵢⵙⴰ ⴹⵎⴹⵔⵢⵏⵜ ⵀⴹⴹⵏ ⴹⵜ ⵎⵢ ⵏⵂⵏ ⵤⵎⵤⵍⵏ ⵙⵔⵙ ⵓⴹⵏ ⵢⴹⵙⵏ⵿ⵜⴹⵗⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ⵜⵆⵎ ⵜⵎⵜⵢ ⵜⴶⵜ ⵗⵔ ⵗⵢⵙⴰ ⵜⵗⵍⵢⵗⵍⵢⵜⵓ ⵙ ⴹⵙⵜⵓⵏⴰ «ⵜⵀⴹⴹⴾ ⵏⵏⴾ ⴹ ⵎⴹⵔⵢⵏⴾ ⴹⵜ ⵂⵏ ⵙⵙ⵿ⵜⵏⵏ ⴹⵔⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ⵏⴰ ⵗⵢⵙⴰ «ⵎⴰ ⵎⵙⵏ ⵤⴰ ⵏⵏⵏ ⵎⴰ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ⵜⵤⵔ ⵙⵍⵍ ⵙⵓⴹⵏⵜ ⵜⵎⵜⵢ ⵜⴰ ⵗⵔⵙ ⵜⵆⵎⵜ ⴹⴰ ⵜⵗⵍⵢⵗⵍⵢⵜⵓ ⵏⴰ «ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴰ ⵏⵏⵏ ⴹ ⵎⴹⵔⵢⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵎⵤⵍⵏ ⵜⵔⴰ ⵏⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ ⵎⴹⵗ ⵜⵎⴹⵔⵢⵜⵏ ⵎⴹⵗ ⵏⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ⵍⵙ ⵗⵢⵙⴰ ⵜⵓⵗⵍⵢ ⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⴹ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ⵰ ⵜⴹⵓⴹⵓ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵂⵔ ⵙ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴹⵂⵏ ⵎⵢ ⵏⴶⵔⵓ ⴹⴰ ⴹⴰ ⵆⵎ ⴹⵗⵙ⵰ ⵜⵎⵜⵢ ⵎⵔⵏ ⴾⵜⵏⵜ ⵜⵆⵎⴹⵓ ⵜⵀⴹⴹ ⴹⵗ ⵙⵍⵎ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ⵜⵜⵙⵙⵗⵔⵓ ⵔⵜⵏ ⴶⵜⵏⵏ ⵙⵍⵎⵜⵍⵏ⵰ ⵏⵙⵏ ⴹⵗ ⵙⵙⵗⵔⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ⵙⵙⵎⵜ⵰ ⵎⴶⵢⴾ ⵢⵏ ⴶⵍⵏ ⵢⴹ ⵏⵀⵍ ⵜⵓⴶⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ⴹⵗ ⵏⵀⵍ ⵓⴰ ⵜⴶⵓ ⴹⵏ ⵎⵙⵏ ⵏⵀⵙ ⵏⵎⵙⴰ ⵔ⵿ⵜⴾⵏⵜ ⵜⵀⵍⵍⵏ ⵛⵢⴹ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵙⵏ⵿ⴹⵓ ⴶⴹⴹ ⵜⵛⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ⵔ⵿ⵜⴾⵏⵜ ⵛⵢⴹ ⴹⵗ ⵎⴹⵍ ⵂⵏⵜ ⵜⵂⵏ⵰ ⴹⵓⵍⴹⵓ ⵎⵙⴰ ⵓⵏ ⵜⵔⵎⴹ ⴼⵍⵙ ⵓⵔ ⵍⴰ ⴹⵓⵙ ⵎⴹⵍ ⴶⵏ ⴹⵗ ⴶⵍⵏ ⴾⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ⵎⵛⵏ ⵙ ⵜⴶⵤⵢ ⵜⴼⴾ ⵍⵙⵓⵢ ⵆⵔ ⴼⵍⵙ ⵓⵔ ⵂⴰ ⵎⴹⵍ ⴹⵗ ⵏ ⵤⴶⴶⵏ ⴾⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⵜⴼⵙⵗ⵰ ⴹⵓⵍⵏⵜ ⵜⴼⵙⵗ ⵛⵏ ⵍⵎⵤⵏⵜ ⵎⵙⴰ ⵓⴰ ⴹⴹⵓⵍⵏ ⴹⵏ ⴶⴹⵍⵙⵏⵜ ⵓⵏ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ⵎⵛⵏ ⵢⴰ ⵔⵜ ⴹⵗ ⵜⵀⵍⵍⵏⵏ ⵔ⵿ⵜⴾ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ⵰ ⴶⵎⴹⵓ ⴹⵓⵍ ⴶⴰ ⵛⵗⵗⵏⵏ⵰ ⵛⵗⵗⵏⵏⵜ ⵛⵢⴹ ⴾⵢⵜ ⵂⵏⵜⵜ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏ ⵜⵀⵍⵍ⵿ⵜ⵰ ⵛⵢⴹ ⵙⴹⵙⵜ ⵜⵎⵔⵓⵏ ⵛⵢⴹ ⵜⵎⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ⴹⴼⵔ ⵓⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴰ ⵙⵍⵏ ⵙⵙⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ⵙ ⵜⴼⵍ ⵜⵎⵜⵢ ⵗⵢⵙⴰ ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵢⵜⴹⵏ ⵓⵢⴹ ⴹⵔⵙ ⵜⴹⵓⵏⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⴹⵍⵎⵗⵏⴰ ⵏⵍⵎⵜⵍⵏ ⵓⵏ ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ⵏⵙⵏ «ⴾⵓⵏⵢ ⵜⴶⵔⵓⵎ ⵎⵙⵏⵜ ⴹⵗ ⵙⵔⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵔⵜ ⴾⵍ ⵜⵏ⵿ⴶⵍⵏ ⵙ ⴹⵙⵏⵜⵜⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ⴹⵢ ⴹⵓⵢⵏ ⵙ ⵙⵓⴹⵏ ⵎⵛⵏ ⵓⵔ ⵂⵏⵢⵏ ⵙⵙⵎⵏ ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ⵰ ⴹ ⵏⵔ ⵓⵔ ⴶⴰ ⴹⵢ ⵜⵀⵏ ⵜⵓⵙⵔⴼⵏⵙⵏ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ⵏⵙⵏ ⴹⵗ «ⵓⴾ ⴶⵔⵢ ⵓⵔ ⵜⴶⵎ ⵓⴰ ⴹⵗ ⵍⵎⵜⵍ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⴶⵔⵎ ⵍⵎⵜⵍⵏ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ⵎⴶⵢⴾ ⵓⵏ ⵂⴶⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⴹⵏ ⵎⵍⵏ ⵓⵍ ⵏ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⴹⵙⵓ ⵛⵢⵜⵏ ⴹⵏ ⴹⴰ ⴾⵙ⵿ⵜⵓ ⴹⵗ ⵓⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵎⴹⵍ ⵂⵏⵜ ⵜⵂⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙ ⵙ ⵙⵍⵏ ⵢⵓⵍ ⵏ ⵎⵛⵏⴰ ⴹ ⵜⵆⵀⵍⵏ ⴹⵢ ⴹⴰ ⵙ ⵎⵏ ⴼⵍⵓⵙⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ⵎⵛⵏ ⵓⵔ ⵍⴰ ⵓⵏ ⴾⵢ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵎⵙⵏ ⵔ ⵎⵙⵓⵙⵏ ⵏ⵿ⵜⵎⵤⵢⵏ⵰ ⴶⴹⴰ ⵗⵙ ⵜⵜⵎⵍ ⵜⵙⵙ⵿ⵜ ⵎⴹⵗ ⵜⴹⴶⵤⵜ ⵜⴶⵜ ⴼⵍ ⴹⵍⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⴹ ⵢⵏ ⵤⴶⵤⵏ ⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵜⴼⵙⵗ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ⵎⵛⵏ ⵛⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴹⴹⴾⵍ ⵓⴰ ⵜⴶⴰ ⵜⴶⵔⴶⵙ⵿ⵜ ⵏⴹⵏⵜ ⵜⵢⵜⵓⵏⵙⵏ ⴹⵔⴾ ⴹⵔⵏⵏ ⵓⵢⴹ ⴶⵜⵏⵏ ⵙⴼⵍⵏ⵿ⴹⵓ ⴹⵏⴶ ⵓⵍ ⵓⵏ ⴶⴹⵍⵙ ⵓⵏ ⴹⵓⵢ ⵜⵏ⵿ⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⵎⵔⵏ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙ ⵙ ⵙⵍⵏ ⵢⵓⵍ ⵏ ⵎⵛⵏⴰ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵆⵍⵙⵏ ⵜⵏ⵿ⴼⴰ ⵜⵎⵙⵜ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏⵏⵜⴼⵙ ⵢⵜ ⵜⵆⵍ ⵙⴹⵙⵜ ⵜⵎⵔⵓⵏ ⵢⵜ ⵎⵔⵏ ⵜⵆⵍ ⵜⵎⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵓⴾ ⴼⵜⵍⴰ ⵜⵔⵗⵜ ⴹⴾⵍ⵿ⵜⵜ ⵓⴹⵏ ⴶⵜ ⴹⵓ ⵗⵤⵓ ⵎⴹⵗ ⴹⵓ ⵜⵙⵜ⵰ ⵓⵔⴶⵗ ⵜⵓⵙⵓⵔ ⵜⵜⵓⴶⵓ ⴹⴶ ⵂⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ⵓⵔ ⵜⵍⴰ ⵗⵀⵔⵏ ⵓⵔ ⵤⴰ ⵏⵏⴼⵍⵍ⵰ ⵓⵍⴰ ⵢⵏ ⵎⵙⵏ ⵙⵔ ⵓⵔ ⵤⴰ ⵏⴼⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ⵓⴰ ⵙⵍⵏ ⵙⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ⵏⵙⵏ ⴹⵗ «ⵜⴶⵜ ⵙⵙⵎ ⵍⵗⵏ ⵢⵎⵤⵍ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ⵰ ⵜⵙⴾⵜ ⵜⵙ ⵜⴾⵜⵎ ⵢⵢⵜⴹⵏ ⵏ⵿ⵜⴰ ⵙ ⴹⵓⵏ⵿ⵤⴾⵜ ⵎⵛⵏⴰ ⵛⵜⵓⵏ ⴹⵗ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ⴼⵍⵙ ⵓⴰ ⵍⵏ ⴹⵙⵜⵓⵛⵜⵓ ⵓⴰ ⵍⴰ⵰ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵎⵔⵏ ⵔⵜ ⵏⵓⴰ ⵍⴰ ⴹⴰ ⴹⵗⵙ ⵜⵔⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ⵏⵙⵏ ⴹⵗ «ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵓⴹⵏ ⵏⵀⵍⵏ ⵎⵙⴰ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ⴶⵔ ⵤⵏ⵿ⵙⴰ ⵓⵍⴰ ⴾⵢ ⴶⵔ ⵤⵂⴹ ⵓⵍⴰ ⵤⵍ⵰ ⵎⵙⴰ ⵓⴹⵢ ⴹⴶⵎⴹ ⴹ ⴹⴶⵍ⵰ ⵓⵔ ⵙⵏ ⵎⵛⵙ ⵎⴾ ⵓⵙ ⴹⴶⵎⴹ ⵓⵍⴰ ⵓⵙ ⴹⴶⵍ ");
INSERT INTO ttqt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ⴼⵍⵙ ⵎⴹⵍ ⴶⵔⵙ ⴹ ⵎⵏⵜ ⵙ ⴹⵜⴾⵙ ⵜⵏ⵿ⴼⴰ⵰ ⵢⵍ ⴹⵜⵤⵔⵏ ⴶⵎⴹ ⴹⴼⵔ ⵓⵏ ⴶⵓ ⵛⵗⵗⵏⵏ ⵎⵔⵏ ⴹⵓⵍⵏⵜⴹⵓ ⴹⵗⵙⵏⵜ ⵜⵀⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ⵜⵑⴰ ⵜⵀⵤⵙ⵿ⵜ ⵗⵙ ⴹⴾⵍⴹⵓ ⵎⵛⵙ ⵍⵎⵛⵢ ⵙⵏ⵿ⵜⵓ ⴹⵗ ⵍⵢⵏⵜ⵰ ⴼⵍⵙ ⵜⵎⵔ⵿ⵜ ⵏⵍⵢ ⵜⴶⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ⴹⴼⵔ ⵓⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵙ ⵤⴰ ⵏⵎⵜⵍ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵎⴰ ⵎⵙ ⵍⵎⵜⵍ ⵓⴰ ⵜⵜⵙⵙⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ⵜⵗⵎⵔ ⵤⴰ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⴰ ⵍⵎⵜⵍ ⵏⵎⵙⴰ ⵏⵏⵀⵜ ⴶⵏ ⵙⵎ ⵎⵜⵔⴹ ⴶⵔⵏ ⵎⵙⵏ ⴾⵍ ⵜⵎⴹⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ⵎⵛⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵙ ⵜⵓⵏⵀⵍ ⴹ ⴹⵓⵍ ⴶⵔ ⵏⵀⵜⵏ ⴾⵍ ⵓⵏ ⵏⵀⵍⵏ ⵜⵤⴶⵔⵜ⵰ ⴶⵓ ⵤⵍⵏ ⴶⵏⵏ ⵜⵤⴶⵔⵜ ⵜⵏ ⵙ ⴹⵗⵙⵏ ⴶⵏ ⴶⴹⴹ ⵛⵙⵍⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ⵍⵎⵜⵍⵏ ⴶⵜⵏⵏ ⵛⵍⵜ ⵏ ⵓⵏ ⴹⵢ ⵙ ⴹⵙⵏⵎⵍ ⵗⵢⵙⴰ ⵓⵍ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⴹⵗ ⵓⵍ ⵓⵏ ⵙⵓⵙ ⴼⵔⴶⵏ ⴶⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ⵓⵔ ⵜⵍⴰ ⵏⴰ ⵢ ⵜⵎⵜⵢ ⵙ ⵓⵔⴶⵗ ⵍⵎⵜⵍⵏ ⴹⵆⵓ ⵏⴰ ⵎⵛⵏ ⵙ ⵆⵍ ⵗⵙⵏⵜ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹⵙⵏⵎⵍ ⵍⵎⵗⵏⴰ ⵏⵍⵎⵜⵍⵏ ⵓⵏ ⴹⵢ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ⵤⵍ ⵓⵏ⵿ⴹⴰ ⵙ ⴹⵂⵤ ⵂⴹ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵏⵗⵔⵙⵜ ⵙ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ⴼⵍⵏ ⵜⵎⵜⵢ ⵎⵜⴾⵓⵢⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵢⵏ⵿ⵜⵓ ⴹⵗ ⵗⵍⵍ ⵏⵎⵏ ⵓⴰ ⴹⴰ ⴹⵗ ⵆⵎ ⴹⴰ⵰ ⴹⵓⵏ ⴹⵔⵙ ⵗⵍⵍⵏ ⵏⵎⵏ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ⴶⵍⵏ ⵙ ⴹⴶⵔ ⴹⵓ ⵙⵂⵏ ⴼⵍ ⴶⵔⵓ⵰ ⴹ ⵙⵜⵀⵏⵜ ⵜⵏⵤⵎⵔⵏ ⵢⵗⵍⵍ ⵜⴶⵤⵏ⵿ⵜⴹ ⵎⵏ ⵂⵔ ⵀⴾ ⵢⴹ ⴹⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵙⵎⵜ ⴹⴼⵔ ⵏ⵿ⵙⴰ ⴹⵗ ⵍⵆⵎ ⵏⵗⵍⵍ⵰ ⵜⵤⵔ ⵙⵏ⵿ⴾⵔⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵜⵙ ⵏⵏⵙ «ⵍⴼⵆⵢ⵰ ⵓⴾ ⵤⵍⵢ ⵓⵔ ⵜⴶ ⴹⵗ ⴹⵏⵗⵜⵛⵏ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ⵏ⵿ⴾⵔⴹⵓ ⵗⵢⵙⴰ ⵙⵏⵔⵗⵎ ⵢⴹⵓ ⵏⴰ ⵢⴶⵔⵓ «ⴹⵔⵔ ⵜⴼⵙ⵿ⵜⴰ⵰» ⵜⵤⵔ ⵤⴾⵜ ⴹⵓ ⵗⵔⴹ ⵔⵜ ⴾⵍ ⴹⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ⵜⵤⵔ ⵏⵙⵏ «ⵎⴰ ⴾⵓⵏⵙⵔⵎⵗⵏ⵰ ⵓⴾ ⵤⴶⵤⵏ ⵓⵔ ⵜⴶⵎ ⵂⵔⵓⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ⵜⴶⵤ ⵜⵙⴰ ⵤⵓⵔⵜ ⵏⵜⵍⵀ ⴹ ⵜⵏⵎⵏⵏ «ⴾⵓⵏⵢ ⴾ ⵎⴰ ⵎⵙ ⵓⴰ ⴹⵗ ⵓⴹⵏ ⵙⴹⵓ ⴹⴶⵔⵓ ⴹⴰ ⵜⴼ ⴹⵗⵙⵏ ⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ⵓⴹⵏ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵙⵍⵎ ⵏⴶⵔⵓ ⵓⵏ ⵙⵏ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⵔⵙⵏⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ⵤⵀⵜⴹⵓ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵗⵙ ⴶⵎⴹⵓ ⵙⵔⵙ ⵎⵙⴾⵍ ⵢⵏ ⵤⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ⵤⴾⵓⵏⵏ ⴹⴰ ⴹⵗ ⵈⵙⵔ ⵎⵔⵏ ⵏ⵿ⴹⵔ ⵢⵢⵜⴹⵏ ⴾⵔⴹⵏⵜ ⵙ ⵓⵍⴰ ⵙⵙⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ⵢⵓⵏⵏ ⴾⵔⴹ ⵏ ⴼⵙⵏⵜ ⵙ ⵙⵙⵔⵏ ⵙⵗⵏ ⴹⵔⵏⵜ ⵙ ⵜⵤⵀⴶⵓⵏ ⵎⵛⵏ ⴹ ⵗⵜⵙ ⵓⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ⵂⴰ ⵤⴾⵓⵏⵏ ⴹⴰ ⴹⴹⵗⵗⵏ ⵂⴹⵤⵍ ⵤⵢⴾ ⵜⵍⵢ ⵎⵏⵜ ⵙ ⵜⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ⵎⵛⵏ ⵙ ⴶⴰ ⵗⵢⵙⴰ ⴹⵗ ⴶⴶ ⵤⵍⴹⵓ ⵙⵔⵙ ⵙⵌⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ⴹⴾⵍ ⴶⵙⴼ ⵓⴰ ⵂⵏ ⵍⵙ ⵓⴰ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⵏⴰ «ⵎⴰ ⴹⵗⵢ ⵜⵔⵗ ⵗⵢⵙⴰ ⵀⵔⵔ ⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ⵰ ⴶⵎⵢⴰ ⴹⵗⴾ ⴼⵍ ⵎⵛⵏⴰ ⴹⵓⵔ⵿ⵜⵤⵗⵤⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ⵏⴰ ⵓⵏ ⴼⵍⵙ ⴹⵙⵏⴰ ⵗⵢⵙⴰ «ⵍⵌⵢⵏ ⵓⴰ ⵍⵀⵙⵏ ⴶⵎⴹ ⴹⵍⵙ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ⵜⵤⵔ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⵎⴰ ⵙⵎⵏⴾ⵰» ⵏⵙ ⴶⵙⴼ «ⵙⵎⵏ ⴶⵏ ⴼⵍⵙ ⴶⵜ ⵏⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ⴹ ⵜⵏ⵿ⵙⵢ ⴶⵙⴼ ⵓⵏ ⵗⵢⵙⴰ ⴼⵍ ⵜⵓⵔⴾⵙ ⴹⵗ ⴾⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ⵙ ⵜⴶⵓ ⵓⵏ ⴹⵏ ⵙⴶⵏ ⴶⵏ ⵏ ⵍⴹⵢⵏ ⴼⵍ ⵜⵙⴶⴰ ⵏ ⵜⴾⵛⵓⵔ⵿ⵜ ⵜⵂⵤⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ⴹ ⵜⵏ⵿ⵙⵢⵏ ⴾⵍⵙⴼⵏ ⵗⵢⵙⴰ ⴶⵏⵏⵙ «ⵙⴾⵏⵗ ⵍⴹⵢⵏ ⵏ ⵜⵏⴶⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ⵔⴹⵙⵏ ⵗⵢⵙⴰ ⵙⵓⵏ⵰ ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⵍⵙ ⵓⵏ ⴶⵤⵏ ⵍⴹⵢⵏ⵰ ⴹⴶⴶⵏ⵿ⴹⵓ ⵍⴹⵢⵏⵏ ⴼⵍ ⵤⴹⴶⴰ ⵏ ⵜⴾⵛⵓⵔ⵿ⵜ ⴹ ⵜⵜⵔⴶⵏ ⴹⵗ ⴶⵔⵓ⵰ ⵜⵛⵏ⵿ⵜⵏ ⵎⵏ ⵎⵙⵏ ⴹⴶ ⵏⵛⵏ ⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ⵜⵤⵔ ⵤⵍⵏ ⵎⴹⵏⵏ ⵏ ⵍⴹⵢⵏ ⵓⵏ ⴶⵏ ⵙⵍⵏ ⵢⵗⵔⵎ ⵓⵏ ⴹ ⵗⵍⵢⵗⵍⵢⵏⵜ⵰ ⴶⵍⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵢⴹ ⵏⵢⵏ ⵓⴰ ⴶⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ⵙⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵏⵢⵏ ⵍⵙ ⵓⵙ ⴾⵍⴰ ⴹ ⵜⵂⵏ ⴾⵍⵙⴼ⵰ ⵆⵎ ⵍⵙⴰ ⵜⵆⵍ⵿ⵜⴹⵓ ⵜⵢⵜⵢⵏⵜ ⵜⵤⵔ ⵜⴶⵤⵜⵏ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ⴶⵏ ⴹⵗⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵢⵜⵏⵏ ⵢⵓⵏ ⵙⵍⵏ ⴾⵍ ⵏⵓⴰ ⵜⵓⴶⵏ ⵢⵍⵙ ⵏ ⴹⵓⴰ ⴶⵔⵓⵏ ⵍⴹⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ⵜⵤⵔ ⴹ ⵜⵏ⵿ⵙⵢⵏ ⵗⵢⵙⴰ ⴹⵙⵏⴶⵎⴹ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ⵜⴶⵤ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵙ ⴹⵏ⵿ⴾⵔ ⵍⵙ ⵓⴰ ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⵜⵜⵏ⵿ⵙⵢ ⴹ ⵜⵢⵓ ⴹⵔⵙ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ⵓⵔ ⴹⵙⵔⴹⴰ ⵗⵢⵙⴰ ⵙⵓⵏ ⴶⵙ ⵢⴰ ⵏⵙ «ⴶⵍⵓ ⵆⵍ ⵂⵏⵓⵏ ⴹⵢⵜⴹⵏⴾ ⵜⵎⵍⵗⵙⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⴾⴶⴰ ⵎⵍⵢ ⵙⵂⵏⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ⵜⵤⵔ ⴶⵍⴰ ⵍⵙ ⵏ ⴾⴰ ⴾⵍ ⴶⵏ ⵙⵎ «ⵓⵏⵎⵔⵓⵗⵔⵎⵏ» ⴹ ⵎⵍ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵙⴶⴰ ⵗⵢⵙⴰ⵰ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵙⵙⵍⵏⵏ ⵙⵏⵂⵍ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ⵆⵍ ⵗⵢⵙⴰ ⵗⵔⵙ ⴶⵔⵓ ⵙⵙⵍⵎⵏⵜ ⵓⴰ ⵂⴹⵏ⵰ ⵜⵍⵙ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ⵜⵤⵔ ⵙⴹⵓ ⵍⵙ ⴶⵏ ⵙⵎ ⵌⵢⵗⵙ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵎⵤⵔⵏ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⵏⵢ ⵗⵢⵙⴰ ⵗⵙ ⵙⵌⴹ ⴹⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ⵏ⵿ⵙⵢ ⵗⵢⵙⴰ ⵏⵙ «ⵜⵀⵔⵔ⵿ⵜⵏ ⵗⵔ ⵜⵍⴰ ⵜⵎⵜⵏ⵿ⵜ ⵔⵗ ⴹⵗⴾ ⵙⵔⵙ ⵏⴹⵓ ⵜⵙⵓⵔⵆⵜ ⴼⵙⵏⴾ ⴹ ⵜⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ⴶⵍⴰ ⵗⵢⵙⴰ ⴹⵓ ⴹⵔⵙ⵰ ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⵜⵏⵀⴹⵗ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ⵜⵎⵜⵢ ⵏ ⵜⵂⵜ ⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⵎⵔⵓ ⵍⵏ ⴹⵛⵏ ⴶⵎⴹⵜⵜ ⵤⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ⵜⵏⵢ ⵍⵗⵤⵀ ⴶⵏ ⴹⵗ ⴼⵙⵏ ⵏ ⵏⵙⵎⴶⵍⵏ ⴶⵜⵏⵏ⵰ ⵓⴰ ⵜⵍⴰ ⴾⵍ ⵙ ⴹⵗⵙⵏ ⵜⵜⵏ⵿ⵗⴰ⵰ ⵎⵛⵏ ⴹⴶ ⵏⴹ ⵜⴶⴹⵢ ⵜⵜⵢⵜ ⴼⴹⴰ ⴼⵍⵙ ⵜⴶⴰ ⵜⵓⵔⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ⵜⵏ⵿ⵜⵜ ⵜⵏ ⴾⵍⴰ ⴹⴰ ⵜⵙⵍⴰ ⵢⵓⴰ ⴶⵏⵏ ⵢⵜⴹⵏ ⵙ ⵗⵢⵙⴰ⵰ ⵜⴶⵤⵏ ⵜⵎⵜⵢ ⵜⴰ ⵜⵂⵜ ⵛⵗⵔⴹⵏ ⵏ ⵗⵢⵙⴰ ⵜⴹⵙ ⵜⴾⴹⴾⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ⴼⵍⵙ ⵜⵏⴰ ⴹⵗ ⵎⵏⵜ «ⵙ ⴹⵙⴰ ⴾⴹⵗ ⵙⵍⵙⵏⵜ ⴹ ⵤⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ⴹⴰ ⴹⴰ ⴹ ⵜⴹⵙ ⵜⴾⴹⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⴹⵗⵙ ⵤⴾⵜ ⵤⵏⵢ ⵓⴰ ⴹⵗⵙ ⵏⵆⵍⵏ ⵜⴼⵔⵢ ⵢ ⵜⵗⵙⵏⵜ ⵙ ⵜⵤⵢ ⴹⵗ ⵜⵓⵔⵏⴰ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵗ ⴼⵔⵢ ⵗⵢⵙⴰ ⵢ ⵜⵔⵏⴰ ⵢⵜ ⵙ ⵜⵏ⵿ⵜⴶⵎⴹ⵰ ⵎⵍⵍⵢⴹⵓ ⵜⵎⵜⵢ ⵏⴰ «ⵎⴰ ⴹⵙⵏ ⵙⵍⵙⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵜⵂⵏⵢⴰ ⵜⵎⵜⵢ ⵜⴰ ⴼⵍⴾ ⵜⵜⵏⵀⴹⵗⵜ ⴶⵙ ⵜⴶⵏⴰ \"ⵎⴰ ⴹⴹⵙⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙⵍⵍ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⵙⵓⴹⵏⵜ ⵢⴹ ⵏⵢ ⵓⴰ ⵜⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ⵜⵤⵔ ⵜⵔⵎⵗ ⵜⵏ⵿ⵜⵜ ⵜⵏ⵿ⴹⵓⵜⵜ ⵜⵢⵙⵙ⵿ⵜ ⴼⵍⵙ ⵜⵙⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⴰ ⵜⴶⴰ ⴹⵏ⵰ ⵜⴾⴹⵓ ⵗⵢⵙⴰ ⵜⵙⵌⴹ ⴹⵜⵙ ⵜⵎⵍⵙ ⵜⴹⵜ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ⵏⵙ «ⵜⵀⵔⵔ⵿ⵜⵏ ⵤⴶⵤⵏⵎ ⵙⵔⵢ ⴾⵎⵤⵤⵢⵏ⵰ ⴶⵍⵓ ⴹⵗ ⵍⵈⵔ ⵜⵤⵢⴰ ⴹⵗ ⵜⵓⵔⵏⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵗⵢⵙⴰ ⵙ ⴹⵙⵏ ⵢⵜⴹⵏ ⴹⴼⵍⵏⵏ ⵗⵢⵓⵏ ⵏ ⵌⵢⵗⵙ ⵓⵏ ⵎⵤⵔ ⵏⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⵏⵙ «ⵜⵀⵔⵔ⵿ⵜⵏⴾ ⵓⵔ ⵜⴹⵔ ⴶⴹⴾ ⵜⴹⴶⵤⵗ ⵛⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ⵎⵛⵏ ⵓⵔⵏⴶⵔ ⵗⵢⵙⴰ ⵜⵏⵀⵢ ⴹⵗ ⵓⴰ ⵜⵓⵏⵏ ⴹⵏ ⵏⴰ ⵢⵎⵤⵔ ⵏⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ «ⴹ ⵓⵔ ⵜⵔⵎⵗⴰ ⵜⴼ ⵗⵙ ⵤⴶⵤⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ⴶⴹⵍ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⴹⵔⵙ ⵜⴹⵓ⵰ ⴶⵍⴰ ⵓⵔ ⴹⵓ ⵔ ⴹ ⵀⵜⵔⵙ ⴹ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵔⵢ ⵏⵢⵆⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ⴹⵓⵏ ⴹ ⵌⵢⵗⵙ ⵓⵏ ⵀⴰ ⵏ ⵜⵀⵔⵔ⵿ⵜ ⵙⵗⵢⵓⵏⵜ⵰ ⵙ ⴹⵏⵙⵏ ⵏⵢ ⵗⵢⵙⴰ ⵜⵏⵌⵔⵓⵢⵜ ⵏⵢⵜⴹⵏ ⵂⵍⵏⵏ ⵙⴾⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ⴶⵤⵏ ⴼⵍⵙⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵏⵌⵔⵓⵢⵎ ⵜⵂⵍⵎ⵰ ⵜⵀⵔⵔ⵿ⵜⵏⵓⵏ ⵓⵔ ⵜⵜⵀⴰ ⵜⵙ ⵗⵙ ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ⵜⵤⵔ ⴶⵏ⵿ⵜⵓ ⵌⵀ⵰ ⵙⵔⴹⵆⵏ ⴾⵜⵏⵙⵏ ⵓⵔ ⴹⵆⵎ ⵔ ⵎⵔⵓⵏ ⵏ ⵜⵀⵔⵔ⵿ⵜ ⴹ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴹⵔ ⴹⴹⵓ ⵜⵤⵔ ⴶⵤ ⴹⵔⵙⵏ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵏ⵿ⵙⴰ ⵜⵗⵙⴰ ⵏ ⵜⵀⵔⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ⵀⵤ ⴼⵙⵏⵜ ⵏⵙ «ⵜⵍⵜⴰ ⵆⵎ⵰» ⵍⵎⵗⵏⴰ ⵏⵓⵏ «ⵜⵀⵔⵔ⵿ⵜ ⵏⵗⵎ ⵏ⵿ⴾⵔⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ⵜⵏ⵿ⴾⵔⴹⵓ ⵜⵀⵔⵔ⵿ⵜ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⵜⵌⵓⵏ⵿ⴾⵜ⵰ ⵜⵀⵔⵔ⵿ⵜ ⵜⵏ ⵎⵔⵓ ⵍⵏⵜ ⴹⵛⵏ⵰ ⵓⴰ ⵙⵔⵙⵏ ⴶⴰ ⵓⵏ ⴹⵗ ⵙⵎⴾⵍⵍ ⵂⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ⵔⵗⵎⵙⵏ ⵗⵢⵙⴰ ⵓⵍⵏ ⴼⵍ ⵎⵍ ⵏⵓⵏ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴹⴼⵔ ⴹⵢ ⵏⵙⵏ ⵜⵜⴾⴼⵏ ⵜⵜⵛⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴹⵓ ⴹ ⵏⵜⵍⵀⵏⵜ ⴾⴰ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ⵙ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗⵙ ⵙⵙⵗⵔⵓ⵰ ⵙⵎⴾⵍⵍ ⵓⵏ ⵙⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵓⵏ ⴹⵙⵙⵙⵎⵏⵏ ⵂⵔ ⵆⵎⵏ ⴶⵏⵏ «ⵎⵏⴹ ⴹⵙⵏ ⵓⴰ ⴹⵗ ⵓⴹⵏ ⵔⵜⵏ ⵓⵏ⵰ ⵎⴰ ⵜⵎⵙ ⵎⵙⵏⵜ ⵜⴰ ⵜⵜⵜⵓⴾⴼⵜ ⴹⴰ ⵙ ⵜⴶⵓ ⵜⵍⵎⵗⵌⵌⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ⵓⴾ ⵓⴰ ⵓⵔⴶⵗ ⵎⴾⵔⵙ ⵏⵏ ⵓⵏ ⴶ ⵎⵔⵢⵎⴰ ⵎⵆⵔ ⵏ ⵢⵆⵀ ⴹ ⵢⵙⵙ ⴹ ⵢⵂⴹⴰ ⴹ ⵙⵎⵗⵏ⵰ ⵓⵔⴶⵗ ⵛⵎⴹⵔⵢⵏⵜ ⴹⴰ ⴹⴰ ⵈⵙⵔⵏⵏ ⴶⵔⵏⴰ ⴹⴰ⵰» ⵓⵏ ⴹⵗ ⴹⵙⵏⴶⴹⵍⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵀⵢ ⵓⵔ ⵜⵓⵍⴾⵓ ⵔ ⴹⵗ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ ⴹ ⵛⵆⵗⵏⵜ ⴹⵗⵢⵓⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ⴶⴹⵍⵙ ⵓⵏ ⵗⵔⵙⵏ ⴶⵓ ⵜⵍⵎⵗⵌⵌⵜⵏ⵰ ⵎⵔⵏⵏ ⵓⵔ ⵏⴶⵜ ⵗⵙ ⵙⵓⵔ ⴼⵙⵏⵜ ⵤⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_6ⴰ","071_6_6ⴰ","MRK","6","6ⴰ","6ⴰ","ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵀⴰ ⵏⵤⴶⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_6ⵀ","071_6_6ⵀ","MRK","6","6ⵀ","6ⵀ","ⵍⵍ ⵗⵢⵙⴰ ⵛⵗⵔⵎⵜⵏ ⵛⵏ ⵂⵤⵏⵏ ⵏⵤⵔⵜ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ⵤⵍ ⵢⵏ ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴾⴼⵏ ⵜⵔⵏⴰ ⴼⵍ ⴾⵍⵙⴼ ⵜⵏⵤⵎⵤⵍ ⵙⵛⵏ ⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ⵎⵔ⵿ⵜⵏ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵓⵢⵎ ⵔⵜ ⵓⵍⵢⵏ ⴹⵗ ⵛⴾⵍⵏⵓⵏ ⵔ ⵜⵍⵆ⵰ ⴹ ⵓⵔ ⵜⵓⵢⵎ ⵍⵓ ⵓⵍⴰ ⵗⵔⴶ ⵓⵍⴰ ⵜⴼⵍ⵿ⵜ ⴹⵗ ⵏⴼⴹⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ⵙⵍⵜ ⵗⵜⵎⵏⵓⵏ ⵎⵔⵏ ⴹ ⵓⵔ ⵜⵓⵢⵎ ⵙⵏⵜⵜ ⵜⴾⴹⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ⵂⵏ ⵓⵙ ⵜⵏⴼ⵿ⵜⵗⵎ ⵜⵓⵔ⵿ⵜⴶⵎⴹⵎ ⵙⵢⵏ ⴾⵜ ⵜⵂⵎ ⵗⵔⵎ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ⵙ ⵓⵔ ⵜⵜⵓⵆⵀⵍⵎ ⵓⵔ ⵜⵓⵙⵙⵎ ⴹⵗ ⵢ ⵀⵜⵏⵓⵏ ⴹⵗ ⴹⴶ ⵓⴹⵢ ⵙ ⵜⵜⴶⵎⴹⵎ ⵜⵀⴾⵀⴾⵎⵏ ⴶⴹⵔⵔⵏⵜ ⵓⴰ ⵓⵔⵏ ⴹⵔⵏⵓⵏ ⵍⴾⵎ ⴹ ⴶⵢⵜ ⵓⵏ ⴼⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ⴶⵍⵏ ⵏⵜⵍⵀ ⴹ ⵜⴶⵏ ⵜⵍⵈⵜⵀⵜ ⵢⵢⵜⴹⵏ ⴼⵍ ⴹ ⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ⵜⴾⵙⵏ ⴹⵗ ⴾⵍⵙⴼ ⴶⵜⵏⵏ ⴹⵗ ⵢⵜⴹⵏ ⵍⵢ ⵓⴹⵢ ⵤⴶⵢⵏ ⵢ ⵎⵔⵏⵏ ⴶⵜⵏⵏ ⵤⵤⵢⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ⵙⵍⴰ ⵎⵏⴾⵍ ⵂⵔⴹ ⵙⵍⵏ ⵏ ⵗⵢⵙⴰ ⴼⵍⵙ ⵙⵍⵜⵏⵜ ⵜⵓⴹⵜ ⴹⴶ ⴾⵍ ⵎⵔⵏ ⴶⵏⵏ ⵙⵔⵙ ⵢⵜⴹⵏ «ⵓⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴹⵢ ⴼⵍ ⵍⴰ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏ ⵜⵍⵎⵗⵌⵌⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ⴶⵏⵏ ⵓⵢⴹ «ⵓⵏ ⵏⵀⵢ ⵍⵢⵙ⵰» ⵓⵢⴹ ⴹⵗ ⴶⵏⵏ «ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵀⵜⵏ ⵓⵏ ⵔⵓⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ⵙ ⵙⵍⴰ ⵂⵔⴹ ⵢⵔⵜⵏ ⵓⵏ ⵜⵓⵏⵏⵏ ⴹⵏ ⵙ ⵗⵢⵙⴰ ⵏⴰ «ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵓⵙ ⴹⵙⴼⵔⵙⵗ ⵗⴼⵏⵜ ⵏ⵿ⵜⴰ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ⵂⵔⴹ ⵎⵏⵜ ⵎⵔⵏ ⵙⴹ ⵜⵔⵎⵙ ⵢⵈⵢⴰ ⵙⴾⵔⴹⵜⵓ ⵙⵙⴶⵢ ⴹⵗ ⴾⵙⵓ⵰ ⴶⴰ ⵂⵔⴹ ⵓⵏ ⴼⵍ ⴹⵍⵍ ⵏⵤⵍⴼⵏⵜ ⵂⵔⴹⵢⵙ ⵜⵎⵙⵜ ⵜⵗⵔ ⴼⵍⵀⵙ ⵎⵔⵏ ⴼⵍⵀⵙ ⵎⴹⵔⵢ ⵏ ⵂⵔⴹⵏ ⴹⵗ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ⵏ⵿ⵜⴰ ⵢⵈⵢⴰ ⵢⵓⵏ ⵜⵏⴰ ⵢ ⵂⵔⴹ «ⵈⵔⵎ ⴼⵍⴾ ⴹ ⵜⵔⴾⵀⴰ ⴹⵗ ⵎⴹⵔⵢⵏⴾ ⵜⵗⵔⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ⵜⵤⵔ ⵜⴶⵤⵔ ⵂⵔⴹⵢⵙ ⵢⵈⵢⴰ ⴼⵍ ⵓⵏ ⴹⴰ ⴹ ⵜⴶⵎⵢ ⴹⵗⵙ ⵜⴾⵙ ⵎⵏ ⵎⵛⵏ ⵓⵔ ⵜⴶⵔⵓ ⵜⵎⵓⵜ ⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ⴼⵍⵙ ⵂⵔⴹ ⴾⵙⴹⵏ ⵢⵈⵢⴰ⵰ ⵙⵏ ⵙ ⵍⵙ ⵏⵍⵗⴹⵍ ⵎⵙ ⵏⵎⵤⴹⴶ ⴹⵢ ⴼⵍ ⵜⴶⵤ⵰ ⵔⴰ ⴹ ⵙⵙⵎ ⵢ ⵀⵜⵜⵏⵜ ⵎⵛⵏ ⵢⴰ ⵢ ⴹⵙⵏⵜⵙⵍⴰ ⴹ ⵜⵛⵓⵛ ⵓⵍⵏ ⵓⴰ ⴶⵏⵓ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ⵓⵏ ⴹⵗ ⴶⵏ ⵂⵔ ⵙⵔⵙ ⵜⴶⵔⵓ ⵂⵔⴹⵢⵙ ⵜⵔⵢⵜ ⵗⵔ ⵗⵍⵢ ⵏⵤⵍ ⵓⴰ ⴹⵗ ⵂⵓ ⵂⵔⴹ⵰ ⵤⵍ ⵓⵏ ⵙⵙⴶⴰ ⴹⵗⵙ ⵂⵔⴹ ⵙⴾⵙⵙ ⵤⵓⵔⵏ ⵎⴶⵔⵏⵙⴹⵓ ⵎⵤⵔⵏ ⵏⵍⵈⴾⵎⵏⵜ ⴹ ⵎⵤⵔⵏ ⵏ ⵙⵌⵜⵏⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⵜⵏⵀⵢ ⴹⵗ ⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ⵜⴶⵤⴹⵓ ⵍⵙ ⵏ ⵂⵔⴹⵢⵙ ⴹ ⵜⴶⵗ⵰ ⴶⵎ ⵂⵔⴹ ⴹ ⵏⴼ⵿ⵜⵗⵏⵜ ⵓⵗⵏⵜ ⵜⵤⵔ ⵏⵙ «ⴶⵎⵢ ⴹⵗⵢ ⵓⴰ ⵜⵔⵗ ⴾⵍ ⴹⵎ⵿ⵜⴾⴼⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ⴶⵍⴰ ⵂⵔ ⴹⵙⵂⴹ ⵏⵙ «ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗⵢ ⵜⴶⵎⵢⴰ ⴹⵎ⵿ⵜⴾⴼⴰ ⴾⴹⵗ ⵆⵍ ⴹⵔⵎ ⵤⵏⴰ ⴾⵍⵏ ⴹⵗ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ⵜⴶⵎⴹ ⵜⵏⴰ ⵢⵏⵏⵜ «ⵎⴰ ⴹⵗⵙ ⵤⴶⵎⵢⴰ⵰» ⵜⵏⵙ ⵏⵏⵜ «ⴶⵎⵢ ⴹⵗⵙ ⵗⴼ ⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ⵜⵔⵎⴹ ⵙ ⴹⵜⵆⵍ ⵜⵎⵓⵜ ⵜⵏ ⵎⵏⴾⵍ ⵂⵔⴹ ⵜⵏⵙ «ⵗⴼ ⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵙ ⵔⵗ ⴹⵜⵜⴾⴼⴰ ⵎⵔⴹⴰ ⵏ⵿ⵙⴰ ⴹⵗ ⵜⵀⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ⵔⵜ ⵓⵏ ⵗⵛⴹ ⵎⵏ ⵏⵎⵏⴾⵍ ⵓⵍⵏ ⵎⵛⵏ ⵓⵔ ⵔⴰ ⴹⵙⴶⵢ ⴼⵍ ⴹⵍⵍ ⵏ ⵜⵂⴹⵢ ⵜⴰ ⴹⵙⴶⴰ ⴹⴹⵍⵍ ⵏ ⵏⴼ⵿ⵜⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ⵙⴶⵍⴰ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵢⵏ ⴹⵗ ⵙⵌⵜⵏⵜ ⵓⵏ ⵜⵜⴶⵤⵏⵏ ⵏⵙ ⴹⵙⴹⵓⵢ ⵗⴼ ⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ⵰ ⴶⵍⴰ ⵙⵌⵢ ⴼⵔⵙⴹⵓ ⵗⴼ ⵏⵢⵈⵢⴰ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ⵓⵢⵜⴹ ⴹⵗ ⵜⵀⵍⴰ ⴾⴼⵢ ⵢ ⵜⵎⵓⵜ ⵜⵏ⵰ ⵜⵀⵔⵔ⵿ⵜ ⴹⵗ ⵜⴾⴼⵢ ⵢⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ⵙ ⵙⵍⵏ ⵏⵍⴾⵎⵏ ⵏ ⵢⵈⵢⴰ ⵓⵏ ⴶⵍⵏ ⴹⴾⵍⵏ ⵜⵗⵙⵏⵜ ⵏⵀⵍⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ⵆⵍⵏ⵿ⴹⵓ ⵏⵎⵤⵍ ⵓⵏⴹ ⵤⵎⵤⵍ ⵗⵢⵙⴰ ⴹⴰ ⵙⵗⵍⵏⵙ ⵙⵍⵏ ⵏⵔⵜ ⴾⵍ ⵓⴰ ⴶⵏ ⴹⵓⴰ ⵙⵙⵗⵔⵏ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵢⵓⵜ ⴾⵓⵜⵏⵗ ⴹⴶ ⵙⴼⵏ ⴼⵍ ⴹ ⵜⵙⵏ⵿ⴼⵎ ⵏ⵿ⴹⵔⵏ⵰» ⵔⵜ ⵓⵏ ⵏⵙⵏ⵿ⵜⵓ ⴼⵍⵙ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏ⵿ⴹⵜⵙⵏⵏ ⴹ ⵓⵏ ⴶⵍⵏⵏ ⴶⵏⵏ ⴶⵜ ⵓⵙ ⵔⵜ ⵏⵎⵤⵢ ⴹⵗ ⵜⵛⵏ ⵏⵜⵍⵀⵏⵜ ⴹⴰ ⵓⵔ ⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ⵜⵤⵔ ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ ⴶⵍⵏ ⴾⵏ ⴹⴶ ⵙⴼⵏ ⴹⵏⴾⵜⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ⴶⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙ ⴶⵍⵏ ⵤⴹⵢⵏ⵿ⵜⵏ⵰ ⴶⴹⵓ ⵤⵍ ⵏⵢⵜⴹⵏ ⴹⵗ ⵗⵔⵎⵏ ⴾⵍ ⵓⵏ ⵂⵤⵏⵏ ⴹⵏ ⵤⵔⵏⵏ ⵢ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵙⴹⴶ ⵓⴰ ⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ⵙ ⴹⵤⵀⵜ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵏⵢ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⴶⵤⵜⵓ ⵜⵂⵏⵏ⵿ⵜⵏⵙⵏ ⴼⵍⵙ ⵎⵙⵏ ⵤⵏ ⵢⴼⴹ ⵓⵔ ⵏⵍⴰ ⵎⴹⵏ⵰ ⵜⵤⵔ ⵜⵏⵙⵙⵗⵔⵓ ⵔⵜⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ⵙ ⴶⵤⵍ ⵤⵍ ⵂⵤⵏ⵿ⵜⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⴹⴶ ⵙⴼⵏ ⵓⴰ ⵎⵔⵏ ⵤⵍ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ⵙⵗⵍ ⵜⵎⵜⵢ ⴰ ⴹ ⵜⴶⵎⵢ ⴹ ⵜⵤⵏ⵿ⵤⴰ ⵜⵜⵛⴰ ⴹⵗ ⵗⵓⵏⵜⵏ ⴹ ⵜⵗⵔⵎⵜⵏ ⵓⵏ ⵂⵤⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵛⵜⵛⵜⵏ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⴰ⵰» ⵏⵏⵙ «ⵓⴾ ⵜⵔⵗ ⴹ ⵏⴹⴾⵍ ⵙⵏⵜⵜ ⵜⵎⴹ ⵏⵔⵢⵍ ⵏⵤⵔⴼ ⵓⴰ ⵎⵍⵏ ⵏⵤⵏ⵿ⵤⴹⵓ ⵛⴶⵍⵓⵏ ⵜⵛⵏ ⵢⵜⴹⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ⵏⵙⵏ «ⵙⵏⵜⴹⵓ ⵎⵏⴾⵜ ⵜⴶⵍⵓⵏ ⵜⵍⵎ⵰» ⵙ ⴹⵙⵏⵏ ⵓⴰ ⵜⵍⵏ ⵆⵍⵏ⵿ⵜⴹ ⵏⵏⵙ «ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⴹⵛⵏ ⴾⴼⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ⵜⵤⵔ ⵎⵔ⵿ⵜⵏ ⵙⴹ ⴶⵏ ⵢⵜⴹⵏ ⵜⵤⵏⵏ ⵙⵗⵎⵏ⵿ⵜⵏ ⴹⵏ ⴹⴰ ⴹⵗ ⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ⵆⵎⵏ ⵢⵜⴹⵏ ⵎⵙⵏ ⵜⵤⵏⵏ⵰ ⵜⵤⵏⵏⵏ ⵛⵢⴹ ⵎⵙⵏⵜ ⵜⵎⴹⵢ ⵜⵎⴹⵢ ⵏⵓⴹⵏ ⵛⵢⴹ ⵎⵙⵏⵜ ⵙⵎⵙⵜ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ⵎⵔⵏ ⴹⴾⵍ ⵗⵢⵙⴰ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⴹⵛⵏ ⴾⴼⵜⵏ ⵓⵏ ⴶⵤⵢ ⵌⵏⵓⵏ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴾⵔⵎⴾⵔⵎ ⵛⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⴾⴼⵏⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵢⵜⵏⵜⵤⵏⵏ ⵢ ⵜⵎⵜⵢ⵰ ⵤⵏⵏⵙⵏ ⴹⵗ ⴾⴼⵜⵏ ⵓⵏⴹ ⵏⵛⵏ ⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ⵜⵛⵏ ⵢⵜⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵂⵔ ⵢⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ⵛⴹⵓⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⵏ ⵗⵢⵙⴰ ⵓⴰ ⴹⵆⵎⵏ ⴹⵗ ⵜⴶⵍⵓⵏ ⴹ ⴾⴼⵜⵏ ⴹⴾⵔⵏ ⴹⵗⵙ ⵎⵔⵓ ⵤⵎⵎⵏ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ⴹⴾⴹ ⵏ ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ ⵂⵏⵏ ⵜⵎⵜⵢ ⵜⴰ ⵜⵜⵛⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ⵓⵍⴰ ⵂⴶⵏ ⵎⵔ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵙⴹ ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ ⵤⵔⵏⵙⵏ ⵙ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⵙⵢⴹⴰ ⴾⵜ ⴹⵢ ⴹ ⵜⵙⵍⵎ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ⵙⴶⵍⴰ ⵜⵎⵜⵢ ⵗⵙ ⴾⴰ ⴹⵗⵗ ⵢⵏ ⵢⴼⵍⵙ ⴶⵓ ⵛⵓⵜⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ⵙ ⴶⴰ ⵂⴹ ⵗⵍⵍ ⵏⵎⵏ ⵓⴰ ⵂⵏ ⵏⵜⵍⵀ ⵏ ⵗⵢⵙⴰ ⵙⴶⵔⵢⴶⵔⵢ ⴹⵗ ⴶⵔⵓ ⵗⵢⵙⴰ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⴹⵗⵗ ⵗⵙⵏⵜ ⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ⴶⵏ ⵀⵍⵏⵏ ⴹⵙⴶⵍⵢ ⵏⵗⵍⵍ ⴼⵍ ⵎⵏ ⴼⵍⵙ ⴹⵓ ⴹⵔ ⴹⵎⵆⵙⵏ⵰ ⵙ ⵜⴶⴰ ⵜⵍⴾⵎⵜ ⵏⵂⴹ ⴾⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵌⵓⵏ⵿ⴾⵜ ⴼⵍ ⵎⵏ⵰ ⵙ ⵤⵎⴰ ⵜⵏⴾⵢ ");
INSERT INTO ttqt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ⴶⵏ⵿ⵜⵓ ⵌⵓⵏ⵿ⴾⵜ ⴼⵍ ⵎⵏ ⵗⵍⵏ ⴶⵙⴼ ⵙⴾⵔⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ⴾⵜⵏⵙⵏ ⵙⵔⵎⵆⵏ ⵏⵢ ⵓⴰ ⵜⴶⵏ⵰ ⵎⵛⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵙⵏⵛⵓⵍ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵗⵛⴹⵎ ⵏⴾ ⵓⴰ⵰ ⵜⴶⵎⴹⵜⴾⵓⵏ ⵜⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ⴶⵤⴹⵓ ⴼⵍⵙⵏ ⵗⵍⵍ ⵗⵙ ⴹⵔⵔ ⴹⵓ⵰ ⴶⴰ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ ⵍⵀⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ⴼⵍⵙ ⵓⵔ ⴶⵔⵏ ⵍⵎⵗⵏⴰ ⵏ ⵜⵎⵗⵌⵌⵜ ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⵙ ⵜⴶⵍⵓⵏ ⴹ ⵓⵍⵏⵙⵏ ⴶⵔⵎⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ⵙ ⵗⵔⵙⵏ ⴶⵔⵓ ⵓⴹⵏ ⴾⵍ ⵏ⵿ⴶⵏⵤⵔⵜ ⵏ⵿ⴹⵢⵏ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⵜⵛⵛⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ⴶⵎⴹⵏ ⵗⵍⵍ ⵏⵎⵏ ⵗⵙ ⵙⵏⵏ ⵢⵜⴹⵏ ⵙ ⵗⵢⵙⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ⵜⵤⵔ ⵤⵍⵏ ⴹⵗ ⴾⵍ ⴾⵜⵏⵜ ⴹⴶ ⵙ ⵙⵍⵏ ⵙ ⵂⵢ ⵙⵔⵙ ⴹⵜⵓⵢⵏ ⵎⵔⵏⵏ ⴹⵗ ⵜⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ⴹⴶ ⵙⴰ ⵗⵢⵙⴰ ⴶⵔ ⵤⴰ ⵗⵔⵎ ⵓⵍⴰ ⵜⵗⵔⵎ⵿ⵜ ⵓⵍⴰ ⵗⵓⵏⵜⵏ ⵏⵙⴼ ⴹⵓⵢⵏ ⵢⵜⴹⵏ ⵎⵔⵏⵏ ⵙⴹⴶ ⵓⴰ ⵎⵙⵏ ⵙⵎⵏⵢ ⵏ⵿ⵙⵢⵏ ⵗⵢⵙⴰ ⴹ ⵢⵓ ⵢⵜⴹⵏ ⴹⵙⵏ ⴾⴹⵗ ⵜⵀⵏⴾ ⵏ ⵜⴾⴹⴾⵜⵏⵜ⵰ ⵢ ⵜⵜⴹⵙⵏ ⴹⵗ ⴹ ⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ⴹⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵗⵔ ⵗⵢⵙⴰ ⵏ⵿ⵜⵏⵢ ⴹⵔⵜ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴶⵎⴹⵏⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ⵏⵢⵏ ⵔⵜ ⴹⵗ ⵏⵜⵍⵀ ⵏ ⵗⵢⵙⴰ ⵜⵜⵏ ⵙ ⴼⵙⵏ ⵎⴹⵙⵏⵏ ⵍⵎⵗⵏⴰ ⵓⵔ ⵏⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ⵏ⵿ⵜⴰ ⴼⵔⵙⵢⵜⵏ ⴹ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⵓⵔ ⵜⵜⵏ ⴾⵜ ⵓⵔ ⵛⵔⴹⵏ ⴼⵙⵏⵙⵏ ⵂⵔ ⵜⵗⵎⵔ ⵎⵙ ⵓⵏ ⵍⵗⴹⵜ ⵏ ⵎⵔⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ⵓⵔ ⵜⵜⵏ ⴹⵗ ⵙ ⴹⴶⵎⴹⵏ ⵙⵎⵏⵢ ⵏⵢⵜⴹⵏ ⴾⵜ ⵓⵔ ⵤⵤⴹⴶⵏ⵰ ⵜⴼⵏ ⴹⵗ ⵛⵢⴹ ⵍⵗⴹⵜⵏ ⴶⵜⵏⵏ ⵎⵙⵏⵏ ⵤⵤⴹⴶ ⵏ ⴾⵙⵏ ⴹ ⵜⴾⵏ ⴹ ⵜⵗⵔⵏ ⴹ ⵜⵙⵓⵏ ⵛⵏ ⴹⵗ ⵜⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ⴹⵢ ⴼⵍ ⵙⵙ⵿ⵜⵏⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⴼⵍ ⵓⵔ ⵍⴾⵎⵏ ⵏⵜⵍⵀⵏⴾ ⵢⵍⵗⴹⵜⵏ ⵏ ⵎⵔⵓⵏⵏⴰ ⵜⵜⵏ ⵙ ⴼⵙⵏ ⵎⴹⵙⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵍⵎⵏⴼⵆⵏ⵰ ⵜⴹⵜ ⵎⵙ ⵓⴰ ⵙⵔⵓⵏ ⵏⴰ ⵏⵀⵢ ⵙⵢⵙ ⵙⵎⴾ ⵓⵙ ⵜⵓⴾⵜⵀ ⵙ \"ⵜⵎⵜⵢ ⵜⴰ ⵍⵙ ⵗⵙ ⵙ ⴹⵜⵙⵗⵎⵔ ⵎⵛⵏ ⵓⵍⵏⵙⵏ ⴶⴶⵏⵢ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ⵍⵗⵀⴹⴰ ⵓⴰ ⴹⵜⴶⵏ ⵀⵏⵏ ⴼⵍⵙ ⵓⵔ ⵙⵙⵗⵔⵏ ⵔ ⵍⵓⵌⵀⵏ ⴹⵏ⵿ⵤⵎⵏ ⵢⵜⴹⵏ ⴹⵗ ⵗⴼⵓⵏⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ⵎⴾⵏ ⴹⴰ ⵜⴶⵎ ⴾⵓⵏⵢ ⴹⴰ ⵜⵢⵎ ⵍⵓⵌⵀⵏ ⵏ ⵎⵛⵏⴰ ⵜⵍⴾⵎⵎ ⵢⵍⵗⴹⵜⵏ ⵏⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵛⵢⵜ ⵜⵍⵗⵜ ⵜⴶⵎ ⵢⵍⵓⵌⵀⵏ ⵏ ⵎⵛⵏⴰ ⴼⵍ ⵍⴾⵎ ⵢⵍⵗⴹⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ⵓⵔⴶⵗ ⵏⵀⵢ ⵎⵙⴰ ⵏⴰ \"ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ\" ⵏⴰ ⴹⵗ \"ⵓⴹⵏ ⵓⴰ ⵛⴼⵔⵛⵏ ⵀⵏⵜ ⵎⴹⵗ ⵏⵏⵜ ⵓⴹⵢ ⴹⵗⵙ ⵜⵓⴾⵙⵏ ⵎⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","ⵎⵛⵏ ⴾⵓⵏⵢ ⵜⴶⵏⵎ «ⴼⵔⴶ ⵓⴹⵏ ⴹ ⵏⵓ ⵢⵀⵏⵜ ⵎⴹⵗ ⵏⵏⵜ \"ⵜⴹⵂⵍ⵿ⵜ ⵜⵙ ⴹⵗⵢ ⵜⴶⵎ ⵏⵢⵜⵏⵜ ⵙⵓⵔⵆⵜ ⴶⵏⴰ ⵜⵎⵙ ⴹⵓⵍ⵰\" ⴹⵗ ⴹⵢ ⵓⴹⵏ ⵓⴹⵢ ⵓⵔ ⵜⵜⵢⵎ ⵙⵎⴾⵏⵓ ⵏⵔⵜ ⵢⵀⵏⵜ ⵓⵍⴰ ⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ⵜⵎⵓⵜ ⵜⴹⵢ ⴹⴰ ⵙ ⵜⴶⵎ ⵍⵗⴹⵜⵏⵓⵏ ⴹⵗ ⴹⴶ ⵏⵓⵍ ⵏ ⵎⵛⵏⴰ ⵜⵙⵙⵗⵔⵎ⵿ⵜⵜ ⵢ ⵀⵔⵔⵏⵓⵏ⵰ ⵜⵜⴶⵎ ⴹⵗ ⵓⵢⴹ ⵔⵜⵏ ⴶⵜⵏⵏ ⵛⵍⵜ ⵏⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ⵙ ⴶⴰ ⵗⵢⵙⴰ ⵀⵜⵓ ⵜⵏ ⵢ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵗⵔⴰ ⵜⵎⵜⵢ ⵏⵙ «ⵙⵙⵎⵜⵢ ⴾⵜⵏⵓⵏ ⵜⴶⵔⵎ ⵓⴰ ⴹⵓⵏ⵿ⵤⵏⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵜⴶⵤⵏ ⵜⵗⵙⴰ ⵏⴶⴹⵎ ⴼⵔⴶⵏ ⵙⵎⴹⵙⵏⵜ⵰ ⴾⵍⵔ ⵓⴰ ⵜⴹⴶⵎⴹⵏ ⵜⵜⵙⵎⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ⵓⴰ ⵙⵍⵏ ⵙⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ⵙ ⵎⵤⵢ ⵗⵢⵙⴰ ⴹ ⵜⵎⵜⵢ ⴶⵤ ⵂⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⴹⵍⵎⵗⵏⴰ ⵏⴶⵢ ⵓⴰ ⴶⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ⵏⵙⵏ «ⵓⴰ ⵤⵗⵏⵏ ⴾⵓⵏⵢ ⴹⴰ ⵓⵔ ⵜⵍⵎ ⴶⵔⵢ⵰ ⵓⵔ ⵜⴶⵔⵎ ⵙ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵜⴶⵤⵏ ⵜⵗⵙⴰ ⵏⴶⴹⵎ ⴼⵔⴶⵏ ⵙⵎⴹⵙⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ⴼⵍⵙ ⵓⵔⴶⵗ ⵓⵍⵏⵜ ⵜⴶⵤ⵰ ⴾⵍⵔ ⵜⴹⵙ⵿ⵜⵏⵜ ⵜⴶⵤ ⴹⴼⵔ ⴹⵢ ⵏ⵿ⵗⵍⵏ ⴹⵗ ⵙⴼ⵰» ⵎⴾ ⵓⴰ ⴹⴰ ⵙ ⵙⵈⵍⵍ ⵗⵢⵙⴰ ⵎⵏ⵿ⵙⵓⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ⵏⵙⵏ ⴹⵗ «ⵓⴰ ⴹⴶⵎⴹⵏ ⵓⵍ ⵏⴶⴹⵎ ⵏ⵿ⵜⴰ ⵜⵙⵎⴹⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ⴼⵍⵙ ⵓⵍ ⵏⴶⴹⵎ ⴹⴶⵎⴹⵏⵜ ⵔⴾ ⵏⵢⵜⵏ ⵜⵜⵓⵢⵏⵏ ⵙⴶⵢ ⵏ ⵜⴹⴹⵏ ⵎⴹⵗ ⴶⵢ ⵏ ⵎⴹⵏ ⴹ ⵛⴾⵔⴰ ⴹⴶⵢ ⵏ ⵎⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ⴹⴶⵢ ⵏⵤⵏⴰ ⴹⵜⵔⴰ ⵏⴹⵏⵜ ⴹ ⵜⵛⵜ ⵏⵎⴾⵙⵏ ⴹ ⵜⴾⴹⵍ⵿ⵜ ⴹⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⴶⵔⵏⵏ ⵜⵈⵔⵎ⵿ⵜ ⴹ ⵎⵏ⵿ⵌⵗ ⴹ ⵛⵤⵎⵜ ⴹⴹⴾⵍ ⵏ ⵎⵏ ⴹ ⵜⵎⵜⴾⵓⵢⵏ ⴾⵍ ⵛⵏ ⵀⴰ ⵏ ⵜⵍⴰ ⵏⵍⵎⵗⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵍⵀⵙⵏⵏ ⴾⵍ ⵓⵍ ⵏⴶⴹⵎ ⴹⴶⵎⴹⵏ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢ ⵜⵙⵎⴹⵙⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴾⴰ ⵎⴹⵍ ⵏ ⵜⵔ⵰ ⵙⵏ ⵗⵙ ⴶⵤ ⵂⵏ ⵢⵏ ⴼⵍⵙ ⵓⵔ ⵔⴰ ⴼⵍⵙ ⵜⴶⵓ ⵎⵙⵏⵜ⵰ ⵎⵛⵏ ⵏ⵿ⴹⵔⵙ ⴹ ⵆⵎ ⵓⵔ ⴼⵍⵙ ⵜⴶⴰ ⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ⴾⵍⵔ ⵔⵤⵏ ⵗⵙ ⵜⵙⵍⵢ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵜⵍⵜ ⵜⵀⵔⵔ⵿ⵜ ⵂⴰ ⴶⵙⴼ ⵜⴾⵢⴹⵓ ⵜⵙⵌⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵓⵔ ⵜⵎⵙ ⵢⵜ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵍⵙⵍⵏⵜ ⴾⵍ ⴼⵏⵙⵢⴰ ⴹⴾⵍ ⵙⵔⵢⴰ⵰ ⵜⵏ⵿ⵙⵢ ⵗⵢⵙⴰ ⴹⵙⴾⵙ ⴶⵙⴼ ⴹⵗ ⵜⵀⵔⵔ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ⵜⵤⵔ ⵏⵙ ⵗⵢⵙⴰ «ⵢⵓ ⵀⵔⵔⵏ ⴹ ⵢⵓⵏⵏ ⵜⵤⵔ ⴼⵍⵙ ⵓⵔ ⵍⵗ ⵢ ⴹⵓⵙⵏ ⴹⴾⵍⵏ ⵎⵏ⵿ⵙⵢⵏⵙⵏ ⴶⵔ⵿ⵜⵏ ⵢ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ⵜⵏⵙ ⵜⵏ⵿ⵜⵜ «ⵜⴹⵜⵏⴾ ⵎⵍⵢ ⵎⵛⵏ ⵢⴰ ⴹⵏ ⴹⴰ ⴾⵎⵢ ⵜⴶⵏ ⵓⴰ ⴹⵔⵜⴾⵏ ⴹⵗ ⵀⵔⵔⵏ ⵜⵜⵏ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵍⵓ ⵜⵆⵍⵗ ⵗⵢⵓⵏⵎ⵰ ⵜⵀⵔⵔ⵿ⵜⵏⵎ ⴶⵎⴹⵜⵜ ⴶⵙⴼ ⴼⵍ ⴹⵍⵍ ⵏ ⵀⵜⵓ ⵜⴰ ⴹⵜⴶ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ⵜⵆⵍ ⵗⵢⵓⵏⵜ ⵜⵙⵏ ⵜⵀⵔⵔ⵿ⵜⵏⵜ ⵜⵤⵍⵍⵜ ⴹⵗ ⵜⵙⵜ ⴶⵎⴹⵜⵜ ⴶⵙⴼ ⵜⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ⴹⴼⵔ ⴹⵢ ⴶⵎⴹ ⵗⵢⵙⴰ ⴾⵍ ⵏ ⵜⵔ ⵔⵤⴶ ⵙⴹⵏ ⵙⵏ ⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⴶⴰ ⵙⵔⵙ ⵜⵔⵢⵜ ⵜⴰ ⵜⵎⵔⵜ ⴾⵍ ⵓⵏⵎⵔⵓⵗⵔⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ⴹⵏ ⴹⵗ ⵙⵔⵙ ⴹⵓⵢⵏ ⵢⵜⴹⵏ ⵍⵙ ⵎⵤⴶⵏ ⵙ ⵏ⵿ⴹⵢ ⵍⵙⵏⵜ⵰ ⵜⵜⵏ⵿ⵙⵢⵏ ⵢⴹ ⵜⵙⵓⵔ ⴼⵙⵏⵜ ⵤⵤⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ⴹⵓ ⴹⵔⵙ ⵗⵢⵙⴰ ⴶⵎⴹ ⴹⵔⵙ ⵢⵜⴹⵏ ⵜⵤⵔ ⴶⴰ ⴹⴹⵓⵏⵜ ⴹⵗ ⵜⵎⵤⴶⵏ ⵏⵎⵤⴶ ⵏ ⴹⴼⵔ ⴹⵢ ⵙⵓⵔ⵿ⵜⵏ ⵎⵜⵎⵏⵜ ⴹⵙ ⵙⵔⵙⵏ ⵍⵙ ⵏⵎⵤⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ⵎⵔⵏ ⴶⵤⵢ ⵗⵢⵙⴰ ⵌⵏⵓⵏ ⵂⵏⴼⵜ ⵏⵙ «ⴼⵜⴰ⵰» ⵍⵎⵗⵏⴰ ⵏⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⴹⵗ ⵏⵍⵎⵏⵜ ⵜⵎⵤⴶⵏ ⵏⵎⵤⴶ ⵏ ⵜⵓⵢⴹⵓ ⵍⵙⵏⵜ ⵛⵓⵍ ⵙⵍⵙ ⵙⵔⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ⴹⴼⵔ ⵓⵏ ⵎⵔ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⵙⴹ ⵓⵔ ⵎⵍⵏ ⵓⴰ ⴶⵏ ⴹⵏ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵎⵛⵏ ⴾⵜ ⵜⵎⵔ⵿ⵜⵏ ⵙⵓⵏ ⵙⵏⵂⵍⵏ⵿ⵜⵓ ⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ⴶⴰ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ ⵍⵀⵙⵏ ⴶⵏⵏ «ⵓⴰ ⵜⴶⵓ ⴾⵍ ⴾⵏⴰ ⵍⵗ⵰ ⵓⵍⴰ ⵎⵤⴶⵏ ⵙⵙⵍⵏ ⵛⵛⵓⵍ ⴹⵗ ⵓⵏ ⵙ ⵏ⵿ⴹⵢⵏ ⵍⵙⵓⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⵜⵍⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⴹⵓⵜ ⴼⵍ ⵗⵢⵙⴰ⵰ ⵜⵎⵜⵢⵏ ⵓⵔ ⵜⵍⴰ ⵜⵜⵛⴰ⵰ ⵗⵔⴰ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«ⵢⵜⴹⵏ ⵜⵂⵢ ⵜⵂⵏⵏ⵿ⵜⵏⵙⵏ⵰ ⴾⵔⴹ ⴹⵏ ⵗⵔⵢ ⴶⵏ ⵎⵔⵏ ⵀⵙ ⵜⵍⴰ ⵜⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ⵙ ⵜⵏⵙⴾⴰ ⵗⵓⵏⵜⵏⵙⵏ ⵓⵔ ⵔⵎⵏ ⵔⵜ ⵜⵏⴶⴹⵍⵓ ⴶⵍⴾ ⴹⵗ ⵜⵔⵢⵜ ⴹ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⴶ ⴹⴶⵎⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵎⵏⵢ ⴹⵤⴶⵔⵓ ⵓⴹⵏ ⴹⵗ ⵙⴼ ⵛⴶⵍⵓⵏ ⵙⵢⵓⵏⵏ ⵜⵎⵜⵢ ⵜⴶⴹⵜ ⴹⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵎⵏⴾⵜ ⵜⴶⵍⵓⵏ ⵜⵍⵎ⵰» ⵏⵏⵙ «ⵙⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ⵎⵔ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⵙⴹ ⵜⵗⵔⴹ ⵜⵗⵎⵜ⵰ ⴹⴾⵍⴹⵓ ⵙⵢⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵢ ⴾⵔⵎⴾⵔⵎ⵿ⵜⵏⵜ ⴾⴼⵏⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵢⵜⵏⵜⵤⵏⵏ ⵢ ⵜⵎⵜⵢⵏ⵰ ⵤⵏⵏⵙⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ⵍⵏ ⴹⵗ ⵔⵜ ⵏ ⴾⴼⵜⵏ ⵓⵏ ⵎⴹⵔⵔⵏⵏ⵰ ⴶⴰ ⵗⵢⵙⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵜⵏⵤⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ⵢⵜⴹⵏⵏ ⵢⵓⵏⵏ ⴶⵍⵤⵏ⵿ⴹⵓ ⵂⵔ ⵙ ⵙⴰ ⵤⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵜⵓⴹⴾⵔⵏⵏ ⴹⵗ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⴶⵍⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ⴹⴾⴹ ⵏⴾⵤ ⴶⵎ ⵏⵍⵙ ⵜⵛⵏⵏ ⴹⵏ⵰ ⵙ ⵜⵜⵛⴰ ⵜⵎⵜⵢ ⵙⵍⵎ⵿ⵜⵜ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵗ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴾⴰ ⴾⵍ ⵏ⵿ⴹⵍⵎⵏⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ⵙⵏ⵿ⴹⵓ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ ⵎⵛⵓⵍⵏ ⴹⵔⵙ ⴶⵎⵢⵏ ⴹⵗⵙ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵎⵙⵏ ⵓⵏ ⵌⵔⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ⴶⴰ ⵗⵢⵙⴰ ⵜⵂⵏⴼⵜ ⵤⴶⵔⵜ ⵏⴰ «ⵎⴼⵍ ⴶⵎⵢⵏ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵜⵍⵎⵗⵌⵌⵜ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵍⴾⵎ ⴹⵓⵏ⵿ⵜⵜⵓⴶⴰ ⵜⵍⵎⵗⵌⵌⵜ ⵓⵍⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ⵜⵤⵔ ⴼⵍ⵿ⵜⵏ ⵍⵙ ⴶⵤ ⵏⵗⵍⵍ ⵏⵎⵏ ⴾⴰ ⵙⵍⵎ ⵓⴰ ⵂⴹⵏ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ⵜⵓⵏⵏ ⵏⵜⵍⵀ ⴹⵓⵢⵏ ⵍⵓ ⵏ⵿ⵜⴶⵍⴰ⵰ ⵜⴶⵍⴰ ⵢⴹⴰ ⵗⵙ ⵜⵂⵜ ⵗⵍⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ⵙⵎⵜⵔ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵏ⵿ⴾⴹⵜ ⵓⵍⵏ ⵢ ⵈⵎⵔⴰ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴹ ⵓⵏ ⵎⵏⴾⵍ ⵂⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ⴹ ⵜⵏⵎⵏⵏ ⵏⵜⵍⵀⵏⵜ ⴶⵔⵙⵏ «ⵓⴰ ⵓⵔ ⵜⵏⴰ ⵔ ⴼⵍⵙ ⵓⵔ ⵏⵍⴰ ⵜⴶⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵓⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵛⵓⵍⵎ ⴹⵗ ⵀⵏ ⵜⵍⵏⵓⵏ ⵜⴶⵍⴰ⵰ ⵓⴾ ⴶⵔⵢ ⵓⵔ ⵜⴶⵎ ⵂⵔⵓⴰ ⴹⴰ⵰ ⵓⴾ ⵓⵍⵏⵓⵏ ⴶⵏⵏ ⵜⵗⵔ⵿ⵜ ⵜⵙ ⵀⵙ ⵜⴶⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ⵓⴾ ⵛⵜⵓⵏ ⵓⵔ ⵜⵍⵎ ⵙ ⵜⵏⵢⵎ ⵓⵍⴰ ⴹⵗ ⵛⵎⵤⴶⵏ ⵙ ⵜⵙⵍⵎ⵰ ⵓⴾ ⵜⵜⵓⵜ ⴹⵏ⵿ⵜⴶⵎ ");
INSERT INTO ttqt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ⴾⵜ ⵏⵤⵎⵎⵏ ⴹⵜⴹⵏⵢⵎ ⴹⵗ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⵜⴶⵍⵤ ⵜⵎⵜⵢ ⵙⵗⴰ ⵓⴹ ⵤⵏⵗ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵢ ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ⵰» ⵏⵏⵙ «ⵏⴾⵜⵓ ⵙ ⵎⵔⵓ ⵤⵎⵎⵏ ⴹⵛⵏ ⴹⵏⴹⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ⵛⴶⵍⵓⵏ ⵛⵏ ⵙⵢⵜ ⵤⴰ ⵛⵏ ⵤⵏⴰ ⵢⴾⵤ ⴶⵎ ⵏⵍⵙ ⵎⵏⴾⵜ ⵤⵎⵎⵏ ⴹⵜⴹⵏⵢⵎ ⴹⵗ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⵜⵓⴶⵍⵤⵏⵏ⵰» ⵏⵏⵙ «ⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ⵎⵔⵏ ⵏⵙⵏ «ⴶⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⴶⵔⵎ ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ⵙⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵜⵗⵔⵎ⵿ⵜ ⵏ ⵀⵜⵙⵢⴹⴰ⵰ ⵍⵓⵢⵏ⵿ⴹⵓ ⵙⵔⵙ ⵢⵜⴹⵏ ⵍⵙ ⵏⵎⴹⵔⵗⵍ ⵏ⵿ⵙⵢⵏ⵿ⵜⵓ ⴹ ⵜⴹⵙ ⵤⵤⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ⵀⵤ ⵗⵢⵙⴰ ⴼⵙ ⵏⵎⴹⵔⵗⵍ ⵏ ⵍⵓⵢⵜⵓ ⵂⵔ ⴹⵔⵙ ⴶⵎⴹ ⵜⵗⵔⵎ⵿ⵜ⵰ ⵙⵓⵔ ⵎⵜⵎⵏⵜ ⵛⵜⵓⵏⵜ ⵙⵓⵔ⵿ⵜⵓ ⴼⵙⵏⵜ ⵏⵙ «ⵓⴾ ⵜⵂⵏⵢⵗ ⵔⵜ ⵎⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ⴹⴾⵍ ⵎⴹⵔⵗⵍ ⵗⴼⵏⵜ ⵏⴰ «ⵂⵏⵢⵗ ⵢⵜⴹⵏ ⵎⵛⵏ ⵍⵏⵢ ⴹⵛⴾⵏ ⵌⵓⵏ⵿ⴾⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ⵍⵙ ⵗⵢⵙⴰ ⵙⵓⵔ ⵏ ⴼⵙⵏⵜ ⵛⵜⵓⵏ ⵏⵎⴹⵔⵗⵍⵏ⵰ ⵆⵍ⵿ⵜⴹ ⵙⵓⴹⵏⵜ ⴾⵜⵏⵜ ⵤⵢ ⵏⴼⵍⵢ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ⵙⵍⵎ⵿ⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⴹ ⵓⵔ ⵜⵆⵍⴰ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⴶⵍⵓ ⴾⵓ ⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ⴹⴼⵔ ⵓⵏ ⴹⵓ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴾⵏ ⵛⵗⵔⵎⵜⵏ ⵂⵏⵏ ⵎⴹⵍ ⵙ ⵜⵓⵏⵓ ⵆⵢⵙⵔⵢⴰ ⵓⵏ ⵎⵤⵔ ⴼⵍⵀⵙ⵰ ⴶⵍⵏ ⵙ ⵜⵏⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴾ ⴹⵗ ⴹⴼ ⵏⵢⵜⴹⵏ ⵎⴰ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ⵏⵏⵙ «ⵓⵢⴹ ⴶⵏⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵜⵎⵙⴰ ⵓⵢⴹ ⴶⵏⵏ ⵏⵀⵢ ⵍⵢⵙ ⵓⵢⴹ ⴹⵗ ⴶⵏⵏ ⵢⵏ ⴹⵗ ⵏⵀⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«ⴾⵓⵏⵢ ⵤⴰ ⵎⴰ ⵜⵏⵎ ⵎⴰ ⵎⵙⴰ⵰» ⵏⵙ ⵀⵜⵔⵙ «ⴾⵢ ⵎⵙⵏ ⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ⵙⵏ⵿ⴾⴹⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵜⴹⵜ ⵎⵙ ⴹⵢ ⵎⵛⵏ ⵜⵓⵔ⵿ⵜⵎⵍⵎ ⵢⵓⴹⵏ ⵓⵍⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ⴹⵏ ⴹⴰ ⴹ ⵙⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵙⵙⵗⵔⵢ ⵏ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵏⴾ ⴶ ⴶⴹⵎ ⴾⵏ⵿ⴹⵀⴰ ⵏⵢⴰ ⵍⵗⵤⵀ ⴶⵏ ⵏ⵿ⴾⵔⵏⵢ ⵎⵤⵔⵏ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵜⵓⴶⵏ ⵎⵏⵏ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ⴶⵙⵏ ⵢ ⵀⵜⵏ ⴶⵢ ⵙⵙⴶⵔⵏ ⵓⵍⵏ⵰ ⵜⵤⵔ ⵓⵜⵓ ⵀⵜⵔⵙ ⵙⵂⵍ ⵛⵓⵍ ⴼⵍⵙ ⴼⵍ ⵓⴰ ⵏⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ⵎⵛⵏ ⵎⵍⵍⵢ ⴼⵍⵙ ⵗⵢⵙⴰ ⵙⵓⴹ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵂⴹⵜⵏⵏ ⵂⵔⵛⵜ ⵀⵜⵔⵙ ⵏⵙ «ⴼⵍ ⴹⴼⵔⵢ ⵛⵢⵜⵏ ⴼⵍⵙ ⵎⴹⵔⵏⵏⴾ ⵓⵔⴶⵗ ⵎⵛⵏⴰ ⴹⴼⵍⵏ ⴾⵍⵔ ⵎⴹⵔⵏⵏ ⵏⴶⴹⵎ ⵗⵙ ⵎⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ⴹⴼⵔ ⵓⵏ ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⴹ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵓⴰ ⵔⵏ ⴹⵍⴾⵎ ⵓⴹⵢ ⴶⵎⴹⵜ ⵜⵔⴰ ⵏ ⵎⵏⵜ ⴶⵓ ⵎⵜⵔⵏⵜ ⴹⴾⵍ ⵜⴶⵜⵓⵜⵏⵜ ⵍⴾⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ⵙⵏⵜ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴶⵎⵢ ⵔ ⴶⵤ ⵏⵎⵏⵜ ⵓⴹⵢ ⴹ ⵜⴶⵎⴹⵏ ⵎⵛⵏ ⵓⴰ ⵆⵀⵍⵏ ⴹ ⵜⴶⵎⴹⵏ ⴼⵍ ⴹⵍⵍⵏ ⴹⴹⵍⵍ ⵏⵍⵏ⵿ⵌⵍ ⵓⴹⵢ ⴹ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ⵎⴰ ⵤⴾⵏⵓ ⵢⵓⴹⵏ ⴹ ⴶⵔⵓ ⴹⵏⵜ ⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⵎⵔⵏ ⵜⵎ⵿ⵙⵢ ⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ⵓⴾ ⵎⵙ ⴼⵔⴶ ⵓⴹⵏ ⵜⵂⴾⵢⵏⵜ ⵢⵙⵔⵙ ⴶⵤ ⵎⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⴾⵔⴾⴹ ⵍⴾⵎ ⵢⵢ ⵎⴹⵗ ⵙⴾⵔⴾⴹⵜⵓ ⵙⵗⵍ ⵏⵓⵍⵏ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹⵗ ⴶⵜ ⵀⴰ ⵏ ⵜⴾⵙⴹⴰ ⵏ ⵎⵛⵏⴰ ⵓⴹⵢ ⵏⴾ ⴹⴰ ⴶ ⴶⴹⵎ ⴹⵜⵙⴾⵔⴾⴹ ⵍⵆⵀⵍⵜⵏⵜ ⵤⵍ ⵓⴰ ⴹⵤⵆⵍⴰ ⵍⵗ ⵜⵏⵢⴰ ⵏⵀⵏⵏ ⴹⵓⴰ ⴹⵏ⵿ⴶⵍⵙⵏ ⵤⴹⴶⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⵀⴹⴹⵏⵏ ⴹⴰ ⵓⵔ ⵜⵏ⵿ⵤⵀⴰ ⵓⵔ ⵏⵢⵏ ⵙⴰ ⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴶⵏ ⵙ ⵜⵔⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ⵙⴹⵙ ⴹⵏ ⴹⴼⵔ ⵓⵏ ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵀⵜⵔⵙ ⴹ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ ⴹⵓ ⴹⵔⵙⵏ ⵏ⵿ⵜⵏⵢ ⵗⵙ ⵙⴹⵗⵗ ⵢⵏ ⵤⴶⵔⵏ⵰ ⵍⵏ ⴹⵏ ⴹⴰ ⵙ ⵎⵜⵢ ⵤⵂⵔ ⵏ ⵗⵢⵙⴰ ⴹⵜⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ⵎⵍⵓⵍⵓⵏ ⵙⵍⵙⵏⵜ⵰ ⴶⵏ ⵜⵎⵍⵢ ⵜⵙⵔⵆⵜ ⵓⵍⵏ ⵙ ⴾⵍⴰ ⵓⵔ ⵜⵜⵓⵏⵢ ⵛⵍⵜⵏⵜ ⴹⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ⵜⵤⵔ ⴶⵏ ⵏⵀⵢ ⵍⵢⵙ ⴹⵏⵀⵢ ⵎⵙⴰ ⵎⵛⵓⵍⵏ ⴹ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ⴶⴹⵓ ⵀⵜⵔⵙ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵍⵗ ⵙ ⵏⵍⴰ ⴹⴰ⵰ ⴹ ⵏⴾⵔⵙ ⴾⵔⴹ ⵂⴾⵜⵏ⵰ ⵢⵏ ⵏⴾ ⵢⵏ ⵏ ⵎⵙⴰ ⵢⵏ ⵏ ⵍⵢⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ⵓⵔ ⴹⵏⴶⵔⴰ ⵀⵜⵔⵙ ⵈⵔⵙ ⵓⴰ ⴶⴰ ⴹⵏ ⴼⵍ ⵓⴰ ⴶⴰ ⴹⵗ ⵜⵔⵎⵆ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵏⴶⵙⵏ ⴹⵜⵏⴼⵍⵍ ⵜⴶⵔⴾ ⵜⵍⵙⵏ ⵜⵍⵢⵏⵜ⵰ ⵜⵤⵔ ⴶⴹⵓ ⵓⵍ ⴹⵗ ⵜⴶⵔⴾⵏ ⴹⴰ ⵏⴰ «ⵓⴰ ⵀⵔⵔⵏ ⵓⴰ ⴾⵏⵗ ⵜⵔⴰ ⵙⵙⵎⵜⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ⵓⵍⴰ ⵂⴶⵏ ⵓⵔⵗⵓⵔⵗⵏ ⵏⵜⵍⵀ ⵓⵔ ⵂⵏⵢⵏ ⵓⴹⵏ ⵓⵍⵢⵏ ⵗⵔⵙⵏ ⵍⵏ ⵔ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ⵜⵤⵀⵏ⵿ⴹⵓ ⴹⵗⵗⵏ ⴹⴰ ⵙ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ «ⴹ ⵓⵔ ⵜⵎⵍⵎ ⵓⴰ ⵜⵏⵢⵎ ⴹⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴾⵜ ⵓⵔ ⴹⵏ⵿ⴾⵔⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ⵜⴼⵏ ⵜⵔⵗⵎ⵿ⵜ ⵜⴰ ⴹⵙⵏⴶⴰ ⴹⵏ ⵎⵛⵏ ⵜⵏⵎⵙⵙ⵿ⵜⵏⵏ ⴶⵔⵙⵏ ⴹⵓⴰ ⵙⴾⴰ ⵗⵢⵙⴰ ⵙ «ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ» ⵜⴰ ⵎⵍ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵎⴼⵍ ⴶⵏⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ \"ⴾⵏ⵿ⴹⵀⴰ ⵙⴹⵓ ⵍⵢⵙ ⵜⵤⵔ ⵙ ⴹⵤⵙⵓ ⵍⵎⵙⵈ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ⵏⵙⵏ «ⵜⴹⵜⵏⵙⵏ ⵙ ⴾⵏ⵿ⴹⵀⴰ ⵙⴹⵓ ⵏⵀⵢ ⵍⵢⵙ ⵜⵤⵔ ⵏⵤⵎ ⵔⵜⵏ ⴾⵍ⵰ ⵎⵛⵏ ⵢⴰ ⵎⴼⵍ ⴾⵜⵀ ⵙ ⴶ ⴶⴹⵎ ⴾⵏ⵿ⴹⵀⴰ ⵏⵢ ⵍⵗⵤⵀ ⴶⵏ ⵜⵓⵙⴾⵏⵓ ⵎⵍⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ⴾⵓⵏⵙⵙⵏⵗ ⵙ ⵏⵀⵢ ⵍⵢⵙ ⵙⴹⵓ ⵎⵔⵏ ⴶⵏⵙ ⵢⵜⴹⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵔⵏ ⵎⵙ ⵙ ⵓⵏ ⴹⴰ ⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ⵙ ⴹⵆⵍ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹ ⴶⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵗⵍⵢⵗⵍⵢⵜⵏ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔⵙⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ⵜⴶⴰ ⵜⵎⵜⵢ ⵗⵢⵙⴰ ⵗⵙ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⵤⵍⵏ ⵙⵔⵙ ⵜⵙⵙⵍⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵎⴰ ⴹⵔⵙⵏ ⵜⵎⵤⵗⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ⵏⵙ ⵍⵙ ⵢⵏ ⴹⵗ ⵜⵎⵜⵢ ⵏ «ⵍⴼⵆⵢ ⵓⵢⴹⵓ ⵙⵔⴾ ⵀⵔⵔⵏ ⵂⴰ ⴶⵙⴼ ⵍⵀⵙⵏ ⵏ⵿ⴹⵢⵏ ⵍⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ⵙ ⴹⵗⵙ ⴹⵏ⵿ⴾⵔ ⵜⴶⴹⵍⵓ ⴹ ⵙⴾⴼⴾⴼ ⵙⵎⴾⵢⴾ ⵜⵤⵔ ⵙⴼ⵰ ⴶⵎⵢⴰ ⴹⵗ ⵏⵜⵍⵀⵏⴾ ⴹⵗⵙ ⵜⴾⵙⵏ ⵎⵛⵏ ⵏ⵿ⴹⵔⵙⵏ» ");
INSERT INTO ttqt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵈⴰ⵰ ⴾⵜ ⵀⴰ ⵏⵤⴶⵤⵏ ⴹⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⴰ⵰ ⵓⴾ ⵂⵔ ⵎⵢ ⴹⵓⴰ ⴹⵔⵓⵏ ⵤⵤⵢⴹⵔ ⴹⵔⵓⵏ⵰ ⵓⵢⵜⴹⵓ ⵀⵔⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ⵜⵤⵔ ⵓⵢⵏⵙ⵿ⵜⴹ⵰ ⴹⴰ ⴹⴰ ⵗⵙ ⴹ ⵏⵢ ⴶⵙⴼ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵤⵤⴾⵔⴾⵔ ⵀⵔⵔ ⴼⵜⵆⵜ ⴹ ⵜⵤⵀⵔⴹⵍ ⵙⴾⴼⴾⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵀⴰ ⵏⵀⵔⵔ ⵏⵙ «ⵎⵢ ⴹⵜⴶⵤ ⵓⴰ ⵛⵏ ⴶⵔⵓ⵰» ⵏⵙ «ⵂⵔⵓⴰ ⵎⴹⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ⵢⵓⵏ⵿ⵜⵓ ⴶⵙⴼ ⵜⵎⴶⵔ⵿ⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵎⴹⵗ ⵎⵏ ⵢⴹ ⵜⵏ⵿ⵗⵓ⵰ ⴾⴹ ⵜⴼⵔⴶⵗ ⵜⴾⵏⵗ ⴹⵗ ⵓⴰ ⵜⵂⵏⵜⵗⵏⴰ ⵜⵍⵍⵗⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ⵏⵙ ⵗⵢⵙⴰ «ⴾⴹ ⵜⴼⵔⴶⴰ ⵢⴰ⵰ ⵔⵜ ⴾⵍ ⴼⵔⴶⵗ ⴶⵏⵜ ⵢ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ⴹⴾⵍ ⵀⴰ ⵏ ⵀⵔⵔ ⵎⵙⵍⵏⵜ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵏⴰ «ⵤⴶⵤⵏⵗ ⴶⵤⵢ ⴹⵗ ⵀⴰ ⵏⵤⴶⵤⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵤⵍ ⵏ ⵜⵎⵜⵢ ⴶⴹⵓ ⵙⵔⵙ ⵂⵔⵛⵜ ⴶⵙⴼ ⵏⵙ «ⵍⵌⵢⵏ ⵓⴰ ⴶⴹⵍⵏ ⵓⵍ ⵤⵎⵤⴶ ⵎⵔⵆⵢ ⵙⴹ ⵜⴶⵎⴹⴰ ⵀⵔⵔ ⴹⵢ⵰ ⵎⵔⵏ ⵜⵓⵔ⵿ⵜⵍⵙⵗ ⴶⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ⵤⵢⴾ ⴶⵙⴼ ⴶⴰ ⵢ ⵀⵔⵔⵏ ⵤⵤⴾⵔⴾⵔ ⵍⵀⵙⵏ ⵎⵔⵏ ⴶⵎⴹⵜⵓ⵰ ⵓⵔ ⵂⴰ ⴹⴶ ⵀⵔⵔⵏ ⵜⵎⵜⴾⵓⵢⵏ ⵤⵏ ⵜⵀⴰ ⵂⵔ ⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ «ⵀⵜ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ⵎⵛⵏ ⵀⵤⵜⴹ ⵗⵢⵙⴰ ⵙⴼⵙ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹ ⵀⴹⴹ ⵀⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ⵙ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵢⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⵓⵔ ⵆⵎ ⵓⴹⵏ ⵓⵍⵢⵏ ⵏⵏⵙ «ⵍⵌⵢⵏ ⵓⵏ ⵂⴶⵏ ⵎⴼⵍ ⵏ⵿ⴹⵔⵏⵗ ⴾⵙⵏⵜ ⴹⵗ ⵀⵔⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ⵏⵙⵏ «ⵤⵏⴼ ⵏⴶⵙⴼ ⵓⵏ ⵓⵔ ⵜⵜⴾⵙ ⵔ ⵛⵓⵜⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵔⵤⴶⵏ ⴾⵍ ⵏ ⴶⵍⵍⵢⴰ ⵎⵛⵏ ⵓⵔ ⵔⴰ ⴹ ⵙⵏ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⴹ ⵍⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ⴼⵍⵙ ⵙⵙⵗⵔⵢ ⵜⴶ ⵏⵜⵍⵀⵏⵜ⵰ ⴶⵏⵙⵏ «ⵏⴾ ⴶ ⴶⴹⵎ ⵌⵓⵔⴰ ⴹ ⴶⵤⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⴶⵏ ⵎⵏⵏ ⵎⵛⵏ ⴾⵔⴹ ⴹⵏ ⴹⴼⵔ ⵀⵏⵏ ⴹⵏ⵿ⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ ⵏⵜⵍⵀⵏⵜ ⵀⵜⵓ ⵜⴰ ⴹⵙⵏⴶⴰ ⴹⵏ ⵎⵔⵏ ⵜⵂⵏ ⵜⵙⴰ ⵏⵙⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ⵓⴹⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵗⵔⵎ ⵏ ⴾⴼⵔⵏⵂⵎ⵰ ⴶⵤⵏⵏ ⵂⵏ ⵗⵙ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵏⵙⵏ «ⵎⴰ ⵜⵎⵤⵗⵎ ⴹⵗ ⵜⵔⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ⵓⵔ ⴹⵙⵏⵏ ⵔⵜ ⴼⵍⵙ ⵜⵎⵤⵆ ⴶⵏ ⴶⵔⵙⵏ ⴹⵗ ⵜⵔⵢⵜ ⵔⵏ ⴹ ⵙⵏⵏ ⵓⴰ ⴹⵗⵙⵏ ⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ⵆⵎ ⵗⵢⵙⴰ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵜⴹⵂⵤⵏ ⵏⵙⵏ «ⵓⴰ ⴹⵗⵓⵏ ⵔⵏ ⵜⵤⵔ⵿ⵜ ⵓⵔ⵿ⵜⵓ ⴹ ⴶⵓ ⵎⵏⵜ ⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⴶⵜ ⵎⵏⵜ ⴾⵍⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ⵀⵤⴹⵓ ⵗⵢⵙⴰ ⴼⵙ ⵏⵔⵜ ⵏ ⵀⵔⵔ ⵢⵏ ⵍⵏ ⴹⵏ ⵙⵀⴹⴹⵜⵓ ⴶⵔⵙⵏ ⵀⵤⵜⴹ ⵤⵍⵎⵜⵓ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ⵢ ⵆⵀⵍⵏ ⵀⵔⵔ ⵛⵍⵏ ⵓⴰ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⵏⴾ ⵎⵏⵏ ⵙ ⴹⵆⵀⵍ⵰ ⵓⴰ ⴹⵆⵀⵍⵏ ⴹⵗ ⵓⵔⴶ ⵏⴾ ⵆⵀⵍ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵆⵀⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ⵏⵙ ⵢⵈⵢⴰ «ⵛⵈ ⵏⵏⵢ ⵍⵙ ⵢⵏ ⵜⴾⵙⵏ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵙⵙⵎⵏⴾ ⵏⵏⵙ ⵓⵔ ⵍⵙ ⴶⵢ ⵏⵓⵏ ⴼⵍⵙ ⵓⵔ ⴹⵏⵗⵂⴰ ⵙ ⵍⴾⵎ ⵢⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ⵏⵙ ⵗⵢⵙⴰ «ⴰ ⴹⵙⵓⵔ⵿ⵜⴶⴹⵍⵎ ⴶⵢ ⵏⴹⵢ ⴼⵍⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙ ⵤⴶⵏ ⵜⵍⵎⵗⵌⵌⵜ ⵙⵙⵎⵏ ⵏⵓ ⵙⵔⵢ ⵍⵀⵙⵏ ⴹⴼⵔ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ⵢ ⵓⵔ ⵏⴶⵎⵢ ⵜⴾⵎⵏⵏⴰ ⵓⴹⵢ ⵎⴹⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ⵎⵔⵏ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⴾⵓⵏⵛⵛⵓⵏ ⵓⵍⴰ ⵀⵍⵓ ⵏⵎⵏ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎ ⵏⵍⵎⵙⵈ ⵓⴹⵢ ⵍⴾⵏ ⵙ ⴹ ⴶⵔⵓ ⵔⵤⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«ⵢ ⵆⵍⵏ ⵙⵀⵀ ⵏⵀⴾⴹ ⵢⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵎⵙⵏⵏ ⵤⵏ ⵀⵔⵔⵏ ⵎⴹⵔⵔⵏⵏ ⵓⴹⵢ ⴼⵙ ⴹ ⵜⵓⵆⵏ ⵤⵤⴹ ⵤⵓⵔⵏ ⵏ⵿ⵜⵂⵏ⵿ⵜ ⴹⵗ ⵔⵏⵜ ⵜⵓⴶⵔⵏ ⴹⵗ ⴶⵔⵓ ⵎⵤⵍ ⵓⴰ ⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","ⴾⴹ ⴾⵢ ⴼⵙⵏⴾ ⵀⴾⵏ ⴹⴾⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵏⵀⴾⴹ ⵜⴼⵔⵙⵆⵏ⵰ ⴹ ⴼⴾ ⴹ ⵜⴶⵤⴰ ⵍⵌⵏⵜ ⵜⴶⵗ ⴼⵙ ⵢⴹ ⵜⵍⵗ ⵛⵏ ⴼⵙⵏ ⵜⴶⵤⵗ ⵜⵎ⵿ⵙⵢ ⵏ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","ⴾⴹ ⴹⵗ ⴹⵔⵏⴾ ⵀⴾⵏ ⴹⴾⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵏⵀⴾⴹ ⵜⴼⵔⵙⵆⵏ⵰ ⴹ ⴼⴾ ⴹ ⵜⴶⵤⵗ ⵍⵌⵏⵜ ⵜⴶⵗ ⴹⵔ ⵢⴹ ⵜⵍⵗ ⵛⵏ ⴹⵔⵏ ⵜⴶⵤⵗ ⵜⵎ⵿ⵙⵢ ⵏ ⵌⵂⵏⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ⵎⵔⵏ ⴾⴹ ⵛⵜⵏⴾ ⵜⵀⴾⵜ ⴹⴾⵜⵆⵍ ⵙⵀⵀ ⵏⴶⵢ ⵏⵀⴾⴹ ⵜⴾⴾⵔⵆⵜⴹⵓ⵰ ⴹ ⴼⴾ ⴹ ⵜⴶⵤⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⴶⵗ ⵛⵜ ⵢⴹ ⵜⵍⵗ ⵙⵏⵜⵜ ⵛⵜⵓⵏ ⵜⵜⵓⴶⵔⴰ ⴹⵔⵙⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵏ ⵌⵂⵏⵎⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ⵜⵎⵙⵜ ⴹⴶ ⵙ ⵓⵔⵎⴹ ⵜⵎⵜⵜⵏⵜ ⵜⵓⴾⵓⵏⵜ ⵓⵍⴰ ⴹⵗ ⵜⵎ⵿ⵙⵢⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ⵓⴹⵏ ⴾⵍ ⴹ ⵜⵓⵤⵤⴹⴶ ⵙ ⵜⵎ⵿ⵙⵢ ⵤⵏ ⴹⵎⴾ ⵙ ⵜⵜⴶⵤ ⵜⵙⵎ⵿ⵜ ⵎⵏ⵿ⵙⵓⵏ ⴼⵍ ⵜⵏ⵿ⵜⴶⵤ ⵜⵏⵀⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ⵜⵙⵎ⵿ⵜ ⵔⵜ ⵍⵗⵏ ⵜⵎⵙ ⵎⵛⵏ ⵙ ⵜⵜⴶⵎⴹ ⵜⵏⵀⵢⵏⵜ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵜ ⵓⴰ ⴹⵗⵙ ⵤⵜⵓⴶⵏ ⵜⵆⵍ⵿ⵜⵜⴹⵓ⵰ ⵜⵆⵍⵜ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ ⵍⵏ ⵜⵏⵀⵢ ⵤⵏ ⵜⵙⵎ⵿ⵜ ⵎⵔⵏ ⵎⵍⵜ ⵍⵈⵔ ⴶⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ⴼⵍ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴾⴰ ⴾⵍ ⵏ ⵢⵂⴹⵢⴰ ⵂⵏ ⴶⵏⴰ ⵓⴰ ⵂⴹⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ⵰ ⵜⵍⵙ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴹⵓⵜ ⵜⵜⵙⵙⵗⵔⵓ ⵎⵙ ⵓⵏ ⵔⵜ ⵜⴶⵓ ⴼⵓ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ⵂⵤⵏ⵿ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⴶⵏⵙ ⵙⵙ⵿ⵜⵏ ⵎⵙⵏ ⵜⵏⴶⵎⵢⵜ ⵏⵏⵙ «ⵓⴾ ⵈⵍⵍ ⵢⵍⵙ ⴹ ⵤⵎⵤⵢ ⵜⵏ⵿ⵜⵜⵏⵜ ⵎⵗ ⵓⵔ ⵈⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵙ ⵎⵙ ⵍⵓⵌⵀ ⵓⴰ ⴹⵓⵏ⵿ⴹⵢⴰ ⵏⵀⵢ ⵎⵙⴰ ⴹⵗ ⵀⵜⵓ ⵜⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ⵏⵏⵙ «ⵏⵀⵢ ⵎⵙⴰ ⴾⴼⴰ ⵜⵔⴶⵜ ⵏⴹ ⵜⵜⵓⴾⵜⵀ ⵛⵔⵓⵜ ⵏⵎⵤⵢ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⵜⵓⵤⵎⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵛⴹⵜ ⵏ ⵜⴶⵔⵎⵎ⵿ⵜ ⵏ ⵓⵍⵏⵓⵏ ⴼⵍ ⴹⵓⵏ⵿ⴹⵢⴰ ⵎⵙⴰ ⵍⵓⵌⵀ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙ ⵜⵤⵔⵜ ⵙ ⴹⵈⵍⴾ ⵎⵛⵏⴰ ⴹⵏⵜ \"ⵈⵍⴾⴹⵓ ⵢⵜⴹⵏ ⵈⵍⴾⵏ⵿ⴹⵓ ⵎⵙⵏ ⵢⵢ ⴹⵜⵏ⵿ⵜⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ⴹⵢ ⴹⴰ ⴼⵍ ⴼⵍ ⵍⵙ ⵀⵏⵜ ⴹⵏⵏⵜ ⵔ⵿ⵜⵢ ⴹ ⵜⵏ⵿ⵜⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ⵆⵍⵏ ⴼⵍ ⵛⵏⵙⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⴹ ⵀⵙ ⵎⵙⵏ ⵛⵏ ⵢⵜⴹⵏ ⴾⵍⵔ ⴹ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ⴹⵗ ⴹⵢ ⵓⴰ ⵙⵔ⵿ⵜⵢ ⵎⵛⵏⴰ ⵜⵓⵔⵤⵎⵤⵢ ⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ⵙ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹ ⵀⵜⵓ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ⵏⵙⵏ «ⵢ ⵤⵎⵤⵢⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⵤⵍⴼ ⵢⵜ ⵓⴹⵢ ⵤⵏⴰ ⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⴰ ⵜⵎⵤⵢⵜ ⴹⵍⵙⵏⵜ ⵤⵍⴼ⵿ⵜⵜ ⵢⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵤⵏⴰ ⵜⴶⴰ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ⴹⵜⵓⵢⵏ ⵢⵜⴹⵏ ⵀⵔⵔⵏ ⵙ ⵗⵢⵙⴰ ⴼⵍ ⵜⵏⵙⵓⵔ ⴼⵙⵏⵜ ⵜⵔⵙⵏ ⵎⵛⵏ ⵛⵓⵍⵏ ⵏⵜⵍⵀ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ⵏⵢ ⵗⵢⵙⴰ ⵓⵏ ⵗⵙ ⵛⴾⵓ ⵏⵙⵏ «ⵢⵓⵜ ⵀⵔⵔⵏ ⴹⴹⴾⵏ⵰ ⵜⵏⵏⵓⵔ⵿ⵜⵓⵗⵎ ⴼⵍⵢ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵛⵍⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵓⵔ ⵏⴶⴰ ⵢ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵍⵆⵀⵍⵜ ⵛⵍⵜ ⵏ ⵜⴰ ⴹⵙⴶⴰ ⵀⵔⵔ ⵓⴹⵢ ⵓⵔ ⴹⵙⵍⴾⵎ ⵜⵜⴶⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ⵜⵤⵔ ⴹ ⵜⵤⵍⵎⵜ ⵗⵢⵙⴰ ⵀⵔⵔⵏ ⵓⵏ ⴹⵏ ⵙⵓⵔ⵿ⵜⵏ ⴼⵙⵏⵜ ⵜⵜⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ⵙ ⵤⵎⴰ ⵎⵜⴾⵓⵢ ⵗⵢⵙⴰ ⴹⵗ ⴹⴶ ⵓⵏ ⵔⵤⴹⵓ ⵙⵔⵙ ⵍⵙ ⵢⵏ ⵙⵔⵙ ⴹⵤⵍⵏ ⴶⵔⴼⵜ ⴹⵜⵙ ⵏⵙ «ⵛⵈ ⵍⵗⵏ ⵎⵙ ⴹⵓⵔ ⴶⵏⵜ ⵢⴹ ⴶⵔⵓⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴼⵍ ⵙ ⴹⵜⴶⵏⵗ ⵛⵈ ⵍⵗⵏ⵰ ⵓⵔ ⵜⵍⴰ ⵢ ⵍⵗⵏ ⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ⵍⵓⵌⵀⵏⵜ ⵜⵙⵏⵆⵏ ⵂⵏ ⵙ \"ⴹ ⵓⵔ ⵜⴶⵗ ⵎⵏ ⴹ ⵓⵔ ⵜⴶⵗ ⵤⵏⴰ ⴹ ⵓⵔ ⵜⴾⵔⴰ ⴹ ⵓⵔ ⵜⴶⵢⵗ ⵙ ⵀⵂⵓ ⴹ ⵓⵔ ⵜⴶⴰ ⵜⴾⵎⴰ ⵢⵓⴹⵏ ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ⵏⵙ ⵍⵙ ⵓⵏ «ⵍⴼⵆⵢ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⵂⵔⵓⴰ ⴹⴰ ⵎⴹⵔⵢⴰ ⵙ ⵜⵏⵙⵀⴹⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ⵜⵤⵔ ⴹⴾⵓ ⵗⵢⵙⴰ ⵙⵙⵓⴹ ⵜⵂⴰ ⵜⵔⴰ ⵏⵙ «ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴹⴾⵏⵆⵎⵏ ⵎⵔⴹⴰ ⴶⵍⵓ ⵤⵏ⵿ⵤⵏ ⵜⵍⵏⴾ ⴾⵍ ⵜⴾⴼⵗ ⵏⵤⵏⵜ ⵢ ⵜⵍⵆⵓⵏ ⴹ ⵜⴶⵔⵓⵗ ⵔⵤⵗ ⴹⴾⵤⵏ⵿ⵙⵏ ⴹⵗ ⵍⵈⵔⵜ⵰ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵜⴶⵍⴹⵓ ⵜⵍⴾⵎⵗⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ⵙⵍⴰ ⵍⵙⵏ ⵢ ⵀⵜⵓ ⵜⵏ ⵗⵙ ⵤⴾⵏ⵿ⵤⵔ⵰ ⵏ⵿ⴾⵔ ⴶⵍⴰ ⵗⵛⴹⵏ ⵎⵏⵜ ⴼⵍⵙ ⵔⵤⵗ ⴶⵏ ⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ⵙⵍⵍ ⵗⵢⵙⴰ ⵙⵓⴹⵏⵜ ⵜⵎⵜⵢ ⵜⴰ ⵜⵜⵗⵍⵢⵗⵍⵢⵜ ⴹⵏ ⵎⵔⵏ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⴾⵜ ⵤⵓⵢ ⴶⵢ ⴶⵤ ⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴼⵍ ⵓⵏ ⴶⵔⴶⵙⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ⵀⵜⵓ ⵜⵏ ⵜⵆⵏ ⵗⴼⵓⵏ ⵏ ⵏⵜⵍⵀⵏⵜ ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵀⵔⵔⵏⵏ ⴾⵜ ⵤⵓⵢ ⴶⵢ ⴶⵤ ⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ⴶⵔ ⵜⵔⵗⵙⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵍⵎ ⵔⴹⵗ ⴹⵗ ⵜⵀⴹⵢ ⵏⵏⵤⵎⵢ ⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵎⴶⵔⴶⵙ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ⵀⵜⵓ ⵜⴰ ⵜⵙⵎⴾⵍⵍ ⵓⵍⵏ ⵙ ⵏⵜⵍⵀ ⵜⵤⵔ ⴹ ⵜⵏⵎⵏⵏ «ⴹⵢ ⵤⴰ ⵎⴰ ⴼⵔⴶⵏ ⴹ ⵗⵍⵙ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ⵙⵓⴹ ⴹⵗⵙⵏ ⵗⵢⵙⴰ ⵏⴰ «ⵎⵈⵍ ⵎⵙ ⴹⵢ ⵗⵔ ⵢⵜⴹⵏ ⵎⵛⵏ ⵎⵛⵏⴰ ⵓⵔ ⵙⵔⵙ ⵜⵎⵙ ⴼⵍⵙ ⵔⵜ ⴾⵍ ⴼⵔⴾⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ⵜⵤⵔ ⵏⵙ ⵀⵜⵔⵙ «ⵏⴾⵏⵢ ⵤⴰ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵏⵢⴰ ⵔⵜ ⴾⵍ ⵏⵍⴾⵎⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴼⵍⵏ ⴼⵍ ⴹⵍⵍⵏ ⴹⴹⵍⵍ ⵏⵍⵏ⵿ⵌⵍ ⵂⵏⵜ ⵎⴹⵗ ⵎⴹⵔⵢⵏⵜ ⵎⴹⵗ ⵛⵎⴹⵔⵢⵏⵜ ⵎⴹⵗ ⵏⵏⵜ ⵎⴹⵗ ⵀⵏⵜ ⵎⴹⵗ ⵀⵔⵔⵏⵜ ⵎⴹⵗ ⵛⵓⴶⵙⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ⵓⴹⵢ ⵓⴹⵏ ⴹ ⴶⵔⵓ ⵂⵔⵓⴰ ⴹⴰ ⵎⵔⴹⴰ ⵜⵎⴹⵢ ⵏⵏⵜⴼⵙ ⵏ ⵏⵏ ⵎⴹⵗ ⵎⴹⵔⵢⵏ ⵎⴹⵗ ⵛⵎⴹⵔⵢⵏ ⵎⴹⵗ ⵏⵜⵏ ⵎⴹⵗ ⵀⵔⵔⵏ ⵎⴹⵗ ⵛⵓⴶⵙ⵰ ⵎⵔⵏ ⴹⵢ ⴾⵜⵏⵜ ⴹ ⵜⴶⵔⵓ ⴹⵓⵙ ⴹⵍⵗⵤⵀ ⴶⵔⵓ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⵜⵗⵍⵍⵜ ⴹⵗ ⵍⵈⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ⵎⵔⵏ ⴶⵏ ⴹⵗ ⵓⵏ ⵂⵏⵏ ⵗⴼ ⵎⵔⴹⴰ ⵍⴾⵎ ⴹ ⴶⵤⵏ ⵍⵆⵎ ⵓⵏ ⵂⵏⵏ ⵍⵆⵎ ⴹⵗ ⵎⵔⴹⴰ ⵍⴾⵎ ⴶⵤⵏ ⵗⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ⵂⴰ ⵗⵢⵙⴰ ⵜⵔⵢⵜ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵤⵔⵙⵏ ⵜⴶⵤⵢⵏ ⵙ ⵢⵔⵙⵍⵎ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⵛⵓⵛⵏ ⵏⵜⵍⵀⵏⵜ ⵜⵂⴰ ⴹⵗ ⵜⵙⴰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ⵰ ⵍⵙ ⵗⵢⵙⴰ ⴾⵙ ⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵗ ⵢⵜⴹⵏ ⵢⴹⵙⵏⵎⵍ ⵔⵜ ⴼⵍⵙ ⵤⴶⵏ ⴹⵗ ⵍⵓⵆ ⵓⵔ ⵏⴶⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ⵏⵙⵏ «ⵙⵙⵎⵜ ⵏⴾⵏⵢ ⴹⴰ ⴶⵤⵢⵏⵏ ⵙ ⵢⵔⵙⵍⵎ ⴹⴰ⵰ ⴹⵏ ⴹⴰ ⴹ ⵤⴰ ⵜⵓⴶⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⴼⵙⵏ ⵏⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵈⴾⵎⵏ ⵜⵎⵜⵏ⵿ⵜ ⴶⵏⵢ ⴹⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ");
INSERT INTO ttqt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ⴹⵗⵢ ⵜⵌⵀⵏ ⵙⵜⴼⵏ ⴼⵍⵢ ⵢⵓⵏⵏⵢ ⵛⵓⵜ ⴶⵏ ⵎⵏⵏ ⵎⵛⵏ ⴹⵏ⵿ⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ⵏ⵿ⴾⵔⵏ ⵏⵜⵍⵀ ⵛⵏ ⵓⵏ ⵎⴹⵏⵙ ⵏ ⵤⵀⴹⵢ ⵎⵙⵏⵏ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ ⵂⵤⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵛⵈ ⴹⵗⴾ ⵏⴶⵎⵢ ⵔⵜ ⵙ ⵏⵔⴰ ⴹⵏⵆⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ⵏⵙⵏ «ⵎⵙ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ⵏⵏⵙ «ⵏⵔⴰ ⴹⵗⴾ ⴹ ⵆⵎ ⵢⵏ ⴹⵗⵏⴰ ⴹⵗ ⵗⵍⵏⴾ ⵆⵎ ⵓⴰ ⵂⴹⵏ ⴹⵗ ⵤⵍⴶⵜⵏⴾ ⵍⵓⵆ ⵓⴹ ⵤⴰ ⵜⴶⵤⴰ ⵜⵏⵢⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔ ⵜⵙⵏⵎ ⵍⵎⵗⵏⴰ ⵏⵔⵜ ⵓⴰ ⵜⴶⵎⵢⵎ ⴹⵢ⵰ ⵓⴾ ⵜⴼⵔⴶⵎ ⴹⵔⵢ ⵜⴹⵔⵓⵎ ⵍⵗⵤⵀ ⵓⴰ ⵤⴶⴰ ⴹⵗ ⵍⵓⵆ ⵓⵔ ⵏⴶⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ⵏⵏⵙ «ⵓⵍⴰ ⵏⴼⵔⴶ ⴹⵔⴾ ⵜⵏⴹⵔⵓ⵰» ⵏⵙⵏ «ⵜⴹⵜ ⵎⵙ ⵙ ⵜⴼⵔⴶⵎ ⴹⵔⵢ ⵜⴹⵔⵓⵎ ⵍⵗⵤⵀ ⵓⴰ ⵜⴶⵎ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⵤⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵓⴰ ⵤⵆⵎⵏ ⴹⵗ ⵗⵍⵏ ⵓⵍⴰ ⵤⵍⴶⵜⵏ ⵓⵔⴶⵗ ⵏⴾ ⵜⵂⴾⵏ⵰ ⴾⵍⵔ ⴹⴶⵏ ⵓⵏ ⵏ ⵓⵏ ⵙ ⵜⵓⵙⵎⵜⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ⵙⵍⵏ ⵎⵔⵓ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ ⵢⵓⵏ ⵛⴾⵏ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ⵜⵤⵔ ⵗⵔⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵏⵙⵏ ⴾⵜⵏⵙⵏ «ⵜⵙⵏⵎ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵜⴼⵏⵏ ⴹⵗ ⵜⵛⵜ ⵏⵎⵤⵔⵏ ⵏ ⵜⵎⵜⵓⵏ ⵙⴾⵏⵏ ⵜⵔⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⵏ ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵗⵙⵏ ⵜⴼⵏⵏ ⵍⵈⴾⵎ ⵙⴾⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⵏ ⵜⵗⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ⵎⵛⵏ ⴾⵓⵏⵢ ⴹ ⵓⵔ ⵜⴶⵎ ⴹⵢ ⴶⵔⵓⵏ⵰ ⴾⵍⵔ ⵙ ⵔⴰ ⵢⵏ ⴹⵗⵓⵏ ⴹ ⵍⵓ ⵍⵎⵆⵎ ⵓⴹⵢ ⵆⵍⵜ ⵤⵏ ⵎⵛⵗⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ⵎⵔⵏ ⵓⴰ ⴹⵗⵓⵏ ⵔⵏ ⵜⵤⵔ⵿ⵜ ⵓⴹⵢ ⵆⵍⵜ ⵤⵏ ⴾⵍⵢ ⵏⵓⴹⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ⴼⵍⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵓⵔ ⴹⵙⵗ ⴹⵏⵜ ⵢⴹⵛⵗⵍⵏ ⵢⵜⴹⵏ⵰ ⴾⵍⵔ ⵙⴰ ⴹⴶ ⵢⴹ ⵛⵗⵍⴰ ⵢⵢⵜⴹⵏ ⴾⴼⴰ ⵎⵏⵏ ⴼⵍ ⴹ ⵙⴹⵔⴼⵗ ⵙ ⵜⵎⵜⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ⴶⵍⴰ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵂⵔ ⴹⵏⵓⴹⵏ ⵗⵔⵎ ⵓⵏ ⵢⵔⴾⵓ⵰ ⵙ ⴶⵤ ⵗⵢⵙⴰ ⵛⵏ ⴶⵎⴹ ⵏⵗⵔⵎ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹ ⵜⵎⵜⵢ ⵜⴶⵜ ⵍⵢ ⵎⴹⵔⵗⵍ ⵢⵏ ⴶⵏ ⵙⵎ ⵀⵔ⵿ⵜⵎⵢ ⴶ ⵜⵎⵢ ⵆⵎⵏ ⴼⵍ ⴼⵢ ⵏ ⵜⵔⵢⵜ ⵜⵏ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ⴹⴰ ⴹⴰ ⵗⵙ ⴹ ⵙⵍⴰ ⵙ ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⴹ ⴶⵏⵓ «ⵢⴰ ⵗⵢⵙⴰ ⴶ ⵏⵀⵢ ⴹⵓⴹ ⵂⵏⵜⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ⵔⵗⵎⵏⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵢⴹ ⴼⵙ⵿ⵜⵓ ⵎⵛⵏ ⵙⵂⴾⵜ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⴶⵏⵓ «ⵢⴰ ⵗⵢⵙⴰ ⴶ ⴹⵓⴹ ⵂⵏⵜⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ⵤⴾⵜ ⵗⵢⵙⴰ ⵏⴰ «ⵗⵔⵓⵜⵜⴹ»⵰ ⵜⵓⵗⵔⴰ ⵎⴹⵔⵗⵍ ⵜⵓⵏⵙ «ⴹⵓⵜ ⵜⵀⴹⴹⴰ ⵗⵔⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ⴶⵔⵏ ⵎⴹⵔⵗⵍ ⵙⵍⵙⵓⵏⵜ ⵓⵏ ⴼⵍⴰ ⴶⴹ ⵏⵎⴹ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⵎⵙ ⵜⵔⵗ ⴹⴾⴶⴰ⵰» ⵏⵙ ⵎⴹⵔⵗⵍ «ⵛⵈ ⵔⵗ ⴹⴹⵆⵍ ⵙⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ⵜⵤⵔ ⵏⵙ ⵗⵢⵙⴰ «ⴶⵍⵓ ⵤⵤⵢⴾⵢ ⵤⴶⵤⵏⴾ ⵙⵔⵢ⵰» ⵆⵍ⵿ⵜⴹ ⵙⵓⴹⵏⵜ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵀⵤ ⵜⵔⵢⵜ ⴶⵤ ⵜⵎⵜⵢ ⵜⴰ ⵜⵍⴾⵎⵜ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ⵙ ⴹⵏⵂⵤ ⵗⵢⵙⴰ ⵢⵔⵙⵍⵎ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵏⵎⵂⵤ ⵏ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⴼⵌⵢ ⴹ ⵜⵏ ⵀⵜⵏⵢ ⴹⴶⵎⴰ ⵏⴹⵗⵗ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ \"ⵛⴾⵏ ⵏ ⵤⵢⵜⵏ\"⵰ ⵤⵎⵤⵍ ⵛⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ⵏⵙⵏ «ⴾⵓⵜ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⴹⵜⵓⵏ ⴹⵏ⵰ ⵜⴶⵤⵎ⵿ⵜⵜⵏ ⵗⵙ ⵜⵏⵢⵎ ⵂⵍⵍ ⵏⵤⴹⵏ ⵆⵏⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⴹ ⵜⵓⵏ⵰ ⵔⵓⵜⵓ ⵜⵍⵓⵢⵎ⵿ⵜⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ⵎⵔⵏ ⵙ ⴹⵓⵏⵏⴰ ⵓⴹⵏ \"ⵎⴰ ⵜⵜⴶⵎ ⴹⵢ⵰\" ⵜⵏⵎⵙ \"ⵎⵍⵢ ⵙⵔⵙ ⴹⵔⵔⵏ⵰\" ⵎⵔⵏ ⵜⴹⵙⵗⵍ ⵜⵔⵎⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ⴶⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⴹⵏ ⵙⵏⵏ ⵂⵍⵍ ⵆⵏ ⴼⵍ ⵜⵔⵢⵜ ⴹⵜ ⵎⵢ ⵏⵂⵏ ⵢⵏ⵰ ⵜⵜⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ⵜⵤⵔ ⵏⵏⵙⵏ ⵢⵜⴹⵏ ⵍⵏⵏ ⴹⵏ «ⵎⴰ ⵜⵜⴶⵎ ⴹⵢ⵰ ⵎⵙ ⵜⵜⵔⵎ ⵂⵍⵍ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ⵌⵓⵀⵏⵙⵏ ⵏⵜⵍⵀ ⵙⵓⴰ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ⵰ ⵎⵔⵏ ⵜⵓⵢⵏ ⵔⵏ ⵂⵍⵍ ⴶⵍⵏ ⴹⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ⵍⵓⵢⵏ⵿ⵜⴹ ⵢ ⵗⵢⵙⴰ⵰ ⴹⴼⵔⵏⵙ ⴼⵍⵙ ⵙⵍⵙⵏⵙⵏ ⵓⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ⴹ ⵜⵙⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵢ ⵗⵢⵙⴰ ⵙⵍⵙⵏⵙⵏ ⴹⵗ ⵜⵔⵢⵜ ⵓⵢⴹ ⵗⵜⵙⵏ⵿ⴹⵓ ⵍⴹⵍⴹ ⵓⵔ ⵂⵏ ⵛⵏⵏⵏ ⵜⵙⵓⵏⵙ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵤⵔⵏⵏ ⴹ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ ⴾⵜⵏⵙⵏ ⵙⵗⵔⵏ ⴶⵏⵏ «ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ⵰ ⴶⴰ ⵎⵛⵏⴰ ⵍⵀⵔⴾⴰ ⴹⵗ ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ⴶⴰ ⵎⵛⵏⴰ ⵍⵀⵔⴾⴰ ⴹⵗ ⵜⵗⵎⵔ ⵜⴰ ⴹⵜⵤⵢⵜ ⵜⵗⵎⵔ ⵏⵎⵔⵓⵏⵏⴰ ⴹⵓⴹ⵰ ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ⴹⵢ ⴹⴾⵍⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ⴶⵤ ⵗⵢⵙⴰ ⵗⵔⵎ ⵏ ⵢⵔⵙⵍⵎ ⴾⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵤⴶⵤⴹⴰ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗⵙ ⵜⴶⵏ⵰ ⵙ ⴶⴰ ⵓⵏ ⴹⴰ ⴹⴶⵤⵜⴹ ⵂⴹ ⴶⵎⴹ ⵗⵔⵎ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴾⵏ ⵀⵜⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⴶⵎⴹⵓ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵀⵜⵏⵢ ⵙ ⴼⵔⵢ ⵢ ⴶⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ⴶⴰ ⴹⵗ ⴶⴶ ⵛⴾ ⵏ ⴼⴶ ⵏ⵿ⵤⵔⵏ⵰ ⴾⵢ ⵢⴹ ⵙⵏ ⵔⵓ⵰ ⵙ ⵜⵏⵙⴰ ⵓⵔ ⵜⵂⴰ ⵔ ⴼⵔⴾⴾ ⴼⵍⵙ ⵜⵎⵔ⵿ⵜ ⵏⵔⵏⵜ ⵓⵔ ⵏⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ⵜⵤⵔ ⵛⵓⵍ ⵗⵢⵙⴰ ⵙⵛⴾ ⵓⵏ ⵏⴰ «ⵜⵗⵔⴹⵜ ⴹⵏⵜ ⵓⵔ ⵍⵙ ⵓⴹⵏ ⵜⵜⵢ ⵏⵔⵏⴾ⵰» ⵔⵜ ⵓⴰ ⵏⴰ ⵗⵢⵙⴰ ⴹⵏ ⵙⵍⵏⵙ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ⵙ ⴹⵓⴹ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵢⵔⵙⵍⵎ ⴶⵤ ⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗⵙ ⵙⵜⵗ ⵎⵙⵜⴶⵏ ⴹ ⵎⵤⵏ⵿ⵤⵏ⵰ ⵙⵀⵏⵀⵢ ⵜⵀⵔⵏ ⵛⵏ ⴼⵍ ⵙⵏ⵿ⵙⵏ ⴾⵍ ⵙⵏ⵿ⵌⵢ ⵤⵔⴼⵏⵙⵏ ⵙⵀⵏⵀⵢ ⴹⵗ ⵛⵙⵆⵎⴰ ⵏ ⵎⵙⵜⴶⵏ ⵏ ⵜⴹⵀⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ⵜⵤⵔ ⴶⴹⵍ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴹ ⵔⵤⴶ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵢ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ⵏⴰ ⵢⵢⵜⴹⵏ ⴹⵗ ⵙⵙⵗⵔⵢ ⵓⴰ ⵜⵏⵜⴶⵓ «ⵓⵔⴶⵗ ⴾⵜⵀ ⵙ ⵏⴰ ⵎⵛⵏⴰ \"ⵂⵏⵏ ⴹⵙⵜⵓⴶⵓ ⵙⵎ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵢ ⵜⵓⵛⵜⵏ ⴾⵍ\"⵰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⴶⵎ⵿ⵜⵓ \"ⵙⵍⵗⵙ ⵏⵀⵢⴹⴶⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ⵙⵍⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵢⵓⵏ ⵗⵙ ⴹ ⴶⵎⵢⵏ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵏ ⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵎⵛⵏ ⵜⵂⵏ ⵜⵙⵏⵜ ⴼⵍⵙ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵙⵏⵂⵍⵜ ⵜⴶⵎⴰ ⵏⵙⵙⵗⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ⵙ ⴹⵂⵤ ⵂⴹ ⴶⵎⴹ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ⵙ ⴼⵓ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵂⴰ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵜⵔⵢⵜ ⵏ ⵢⵔⵙⵍⵎ ⵙ ⴹⵍⵎⵏ ⴹⴶⵎⴰ ⵏⵛⴾ ⵏ ⴼⴶ ⵓⵏⴹ ⵏⵢⵏ⵿ⵜⵓ ⵆⵔ ⴾⵜⵏⵜ ⵂⵔⴾⴹ ⴾⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ⴾⵜⴹⵓ ⵀⵜⵔⵙ ⵛⴾ ⵓⵏ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵏⴾ ⴼⴶ ⵓⴰ ⵜⵍⵗⵏⴰ ⴾⵜⵏⵜ ⵆⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵤⴶⵤⵏⵜ ⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵏⵏ ⵢⴹⵗⵗ ⵏ \"ⴶⵎⴹ ⴹⴶ ⴹⵢ ⵜⴼⵜⵆ ⴹⵗ ⴶⵔⵓ\" ⵎⵔⵏ ⵙ ⵏⴰ ⵓⵏ ⵓⵔ ⴶⴰ ⵛⴾ ⴹⵗ ⵓⵍⵏⵜ ⵤⴶⵤⵏ ⵙ ⵓⴰ ⵏⴰ ⴹⴰ ⴹ ⴶⵓ⵰ ⵓⴹⵏ ⵓⴹⵢ ⴹⵙⴶⵓ ⵎⵛⵏⴰ ⵓⴰ ⴹⵗⵙ ⴶⵎⵢ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ⴹⵗ ⴹⵢ ⵎⵍⵗⵓⵏ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵓⵏ ⵓⴹⵢ ⵤⴶⵤⵏⵜ ⵙ ⵜⴶⵔⵓⵎ⵿ⵜⵓ ⴹⵢ ⴹⵓⵏ⵿ⵜⴾⴼⵓ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«ⵎⵔⵏ ⵙ ⵜⵜⵜⵔⵎ ⴾⴹ ⵍⵢ ⵔⵜ ⵆⵍ ⵓⵔ ⵏⵍⵗ ⵜⵜⴼⵎ ⴹⵗ ⵎⵏ ⵢⵓⴹⵏ ⵜⵙⵔⴼⵎⵙ ⵜⵤⵔ ⴹⵢ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵓⵏⵙⵔⴼ ⵔⴾ ⵎⵤⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ⵎⵛⵏ ⵙ ⵓⵔ ⵜⵙⵔⴼⵎ ⵢⵢⵜⴹⵏ ⵓⴹⵢ ⵓⵔ ⴹⵓⵏ⵿ⵤⵙⵔⴼ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵔⴾ ⵎⵤⵍⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ⵍⵙⴹⵓ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⵜⵓⵗⵍⵢ ⵏⵗⵔⵎ ⵏ ⵢⵔⵙⵍⵎ⵰ ⵙⵗⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⵜⴹⵙⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⵙⵏ⵿ⵜⴹ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ ⴾⵍⵍⵢⵂⴹ ");
INSERT INTO ttqt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ⵏⵏⵙ «ⵓⴾ ⵎⴰ ⵜⵎⵙ ⵜⵔⵏⴰ ⵜⵙ ⵜⵜⴶⵗ ⵔⵜⵏ ⵓⵏ⵰ ⵎⴰ ⴾⵢⴾⴼⵏ ⵜⵔⵏⴰ ⵏⴶⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴰ ⴹⵓⵏⴶⵗ ⵙⵙ⵿ⵜⵏ ⵢⵏ⵿ⴹⴰ⵰ ⵙ ⴹⵜⵌⵓⵀⵎ ⴹⵓⵏⵎⵍⴰ ⵓⴰ ⴹⴾⴼⵏ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⵜⴶⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ⵎⵍⵜⵢ ⵓⴾ ⵙⵍⵎⵗ ⵓⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵎⵛⵏⴰ ⵗⵔ ⴹⴼⵍ ⵓⵏ ⵎⵗ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ⵜⵤⵔ ⴹ ⵜⵏⵎⵛⵓⵔⵏ ⴶⵔⵙⵏ ⴶⵏⵏ «ⵙ ⴹⵙⵏⵏⴰ \"ⵎⵛⵏⴰ ⴹⴼⵍ\" ⴹⵏⵗⵏⵓ \"ⵎⴼⵍ ⵤⴰ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵙⵓⴰ ⴹⵓⵏⵏⴰ ⵢⵈⵢⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ⵓⵔ ⴹⵙⵤⵏⵏⵓ ⵤⴰ \"ⴶⴹⵎ\"⵰» ⵓⵔ ⵂⵍⵏ ⵜⵏⴰ ⵏⵓⵏ ⴼⵍⵙ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵜⴼ ⵙ ⵢⵈⵢⴰ ⵏⵀⵢ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ⵜⵤⵔ ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵓⵔ ⵏⵙⵏ»⵰ ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹⵗ ⴹⵢ ⵏⴾ ⴹⴰ ⵓⵔ ⴹⵓⵏ⵿ⵤⵎⵍⴰ ⵓⴰ ⴹⴾⴼⵏ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ⵛⵓⵍⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵍⵎⵜⵍⵏ ⵏⵙⵏ «ⵍⵙ ⵢⵏ ⵏⵀⵍⵏ ⵛⴾⵏ ⵏⵤⵀⵀ ⵙⵗⵍⵢⵜⵏ ⴼⵔⴶ⵰ ⵗⵤ ⴹⵗⵙ ⵜⴶⴹⵢⵜ ⵜⴰ ⴹⵗ ⵤⴰ ⵜⵓⵤⵎⵓ ⵤⵀⵀ ⴾⵔⵙ ⴹⵗ ⴶⴰ ⵂⴾⵏ ⵙ ⵤⴶⵔ ⵓⴹⵏ ⵓⴰ ⵜⴶⵤⵏ ⴼⵔⴶ⵰ ⵜⵤⵔ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜⵏ ⵢ ⵎⴶⵢⴾⵏ ⵓⵢⴹ ⵛⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ⵙ ⴹⵜⵓⴹ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⵎⵍⵢ ⵏⵤⵀⵀ ⵤⵎⵤⵍ ⵢⵏ ⴹⵗ ⴾⵍⵏⵜ ⵙ ⵎⴹⵏ ⵓⵏ ⵗⵔⵙ ⵗⴼⵔⵏⵏ ⴼⵔⴶⵏⵜ ⵢⵗⵔⵙⵏ ⴹⵓⵢ ⴹⴶⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ⵙ ⵜⵏⵏⵙⴰ ⴾⵍⵢ ⵏ ⵀⵤⵏ⵿ⵜⵓ ⴶⵏⵙ ⵛⵓⵜ ⵙⵗⵍⵏ⵿ⵜⵓ ⵎⵛⵙ ⵙⴾⵔⵢⵔⵢ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⵢⵏ ⴾⵍⵢ⵰ ⵙ ⵜⵏⵏⵙⴰ ⵙⵀⵙⵏ ⵗⴼⵏⵜ ⴶⵏⵙ ⵜⵔ ⵛⵈⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ⵍⵙ ⵎⵛⵙ ⵏⴼⵔⴶ ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⴾⵍⵏⵜ ⵢⵏ⵰ ⵙ ⵜⵏⵏⵙⴰ ⵀⵤⵏ⵿ⵜⵓ ⵏ⵿ⵗⵏ⵿ⵜⵓ ⴾⵔⵤ⵰ ⴹⴼⵔ ⴹⵢ ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⴹⵗ ⵜⵏⵎⵤⵔⵢ ⵓⵢⴹ ⴾⵍⵏⵜ ⴶⵜⵏⵏ⵰ ⵓⵢⴹ ⵤⴰ ⴶⵜⵏ⵿ⵜⵏ ⵂⵔ ⵜⵏⴾⵙⵏⵏ ⵓⵢⴹ ⵏ⵿ⵗⵏ⵿ⵜⵏ ⴾⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ⵀⵙ ⴹⵆⵎ ⵢ ⵎⵛⵙ ⵏⴼⵔⴶ ⵔ ⵀⵔⵔⵏⵜ ⵓⴰ ⴾⵏⴰ ⵜⵔⴰ⵰ ⵤⵎⵤⵍ⵿ⵜⵓ ⵙⵔⵙⵏ ⴹⵗ ⵜⵍⴾⵎⵜ ⴼⵍⵙ ⵏⴰ ⴹⵗ ⵎⵏⵜ \"ⵎⴾⵏ ⵙ ⴹ ⵙⵗⵎⵔⵏ ⵀⵔⵔⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ⵎⵛⵏ ⵙ ⵏⵢⵏ ⵎⴶⵢⴾⵏ ⵓⵏ ⵗⴼⵔⵏⵏ ⴼⵔⴶ ⵀⵔⵔ ⵓⵏ ⵏⵎⵏⵏ ⴶⵔⵙⵏ \"ⵏ⵿ⵜⴰ ⴹⵢ ⵎⴾⵙⵓ ⵏⴼⵔⴶ⵰ ⵏ⵿ⴹⵓⵜ ⵜⵏⵏ⵿ⵗⵓ ⴾⵔⵤ ⴹ ⵏⴾⵙⵜ ⴼⵔⴶ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ⵜⵤⵔ ⵀⵤⵏ⵿ⵜⵓ ⵏ⵿ⵗⵏ⵿ⵜⵓ ⴾⵔⵤ⵰ ⴶⵔⵏⵏ ⵜⴼⴾⵏⵜ ⵙⴹⵢ ⵢⴼⵔⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«ⴹⵗ ⴹⵢ ⵎⴰ ⵤⴶⵓ ⵎⵛⵙ ⵏⴼⵔⴶ ⵓⵏ⵰ ⵓⵔⴶⵗ ⵙⴰ ⴹⵤⴶⵓ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵓ ⵎⵏ ⵏ ⵎⴶⵢⴾⵏ ⵓⵏ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜ ⵢ ⵓⵢⴹ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ⵓⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ \"ⵜⵂⵏ⵿ⵜ ⵜⴰ ⴹⵏⴶⵔⵏ ⵎⴾⵔⵙⵏ ⵏ⵿ⵜⴰ ⵜⵆⵍⵜ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⴾⵀⵍⵜ ⵂⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ⵔⵜ ⵓⵏ ⵎⵍⵢ ⴹⴼⵍ ⵎⵔⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ⴹ ⴶⵎⵢⵏ ⵎⵤⵔⵏ ⵓⵏ ⴹⵏ ⵎⴾ ⵓⵙ ⵤⴰ ⵙⵜⵔⵎⵙⵏ ⵗⵢⵙⴰ ⴼⵍⵙ ⴶⵔⵏ ⵙ ⵏ⵿ⵜⵏⵢ ⵙⴾⴰ ⵙⵍⵎⵜⵍ ⵓⵏ⵰ ⵎⵛⵏ ⵢⴰ ⵓⵔ ⵂⵍⵏ ⵓⵏ ⴼⵍⵙ ⵜⵎⵜⵢ ⴾⵙⴹⵏ⵰ ⴹⵢ ⴼⵍ ⵜⵢⵏ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ⴹⴼⵔ ⵓⵏ ⵙⴾⵏ⵿ⵜⴹ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ ⴹⵢⵜⴹⵏ ⵓⵢⴹ ⵓⵔⵏⵏ ⴶⵏⴰ ⵏⵎⵏⴾⵍ ⵂⵔⴹ ⴼⵍ ⴹⵙⴶⵏ ⵜⵏⴶⵎⵢⵜ ⵙ⵿ⵜⵙⵙⵏⵏ ⵔⵜ ⴼⵍ ⵜⵀⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ⵙⵏ⵿ⵜⴹ ⵏⵏⵙ «ⵛⵈ ⵏⵙⵏ ⵙ ⵎⴶⵢ ⵏ ⵜⴹⵜ ⵜⵎⵙⴰ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵜⴾⵙⴹⴰ ⴹⵗ ⵓⴰ ⵜⴶⵏⴰ ⴼⵍⵙ ⵓⵔ ⵜⵤⵍⵢⴰ ⴹⵗ ⵍⵎⵆⵎ ⵏⵢⵜⴹⵏ⵰ ⵜⵙⵙⵗⵔⴰ ⵙ ⵜⴹⵜ ⵓⵙ ⴹⵏⵓⵔ ⴶⵏⵜ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ⴾⵢⵏⵙⵙ⵿ⵜⵏ ⵓⴾ ⵈⵍⵍ ⵔⵤⵎ ⵏⵎⵏⴰ ⵢⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵆⵢⵙⵔⴰ ⵎⵗ ⵓⵔ ⵈⵍⵍ⵰ ⵜⵏⵔⵤⵎ ⵎⵗ ⵓⵔ ⵜⵤⵏⵔⵤⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ⵏⵙⵏ ⵗⵢⵙⴰ ⴶⵔⵏ ⵜⵍⵎⵏⴼⵆⵏⵙⵏ «ⵎⴼⵍ ⵜⵜⵌⵔⵀⵎⵢ⵰ ⴾⴼⵓⵜⴹⵓ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ ⵜⵜⵏⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ⴾⴼⵏⵙ⵿ⵜⵜⵏ ⵜⵤⵔ ⵏⵙⵏ «ⵎⴰ ⵍⵏ ⴹⵎ ⴹⵙⵎ ⵓⵏ ⵜⵜⵓⵔⵏⵏ⵰» ⵏⵏⵙ «ⵏ ⵆⵢⵙⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ⵏⵙⵏ «ⴹⵢ ⵤⴰ ⴶⵓⵜ ⵢ ⵆⵢⵙⵔⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ ⵜⴶⵎ ⴹⵗ ⵢ ⵎⵛⵏⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ⵰» ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵍⵌⵓⵀ ⵓⴰ ⵜⵏⴾⴼⴰ ⵗⵢⵙⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ⴹⴼⵔ ⵓⵏ ⵙⵏ⵿ⴹⵓ ⵙⴹⵙⵢⵜⵏ ⵗⵢⵙⴰ ⵎⵙⵏⵏ ⵢⵜⴹⵏ ⵜⴼⵏⵏ ⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵏⴾⵔⴰ ⴹⴼⵔ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«ⵛⵈ ⵏⵀⵢ ⵎⵙⴰ ⴾⵜⵀ ⵙ \"ⵙ ⵀⴰ ⵍⵙ ⵢⴹⵓ ⵜⵏ⵿ⵜⵜ ⴹⵔ ⵓⵔ ⵍⴰ ⵀⵔⵔ ⵍⵤⵎ ⵎⴹⵔⵢⵏⵜ ⵜⵜⵤⵍⴼ ⴼⵍ ⴹ ⴶⵓ ⵤⵔⵢⴰ ⵢⵎⴹⵏⵜ ⵓⴰ ⵀⴰ ⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ⵏ⵿ⵜⴰ ⴾⵍⴰ ⵜⵍⵏ ⵙⴰ ⵎⴹⵔⵢⵏ⵰ ⵤⵍⴼ ⵓⴰ ⴹⵙⵏⵓⵛⵔⵏ ⴾⵜⵏⵙⵏ ⵀⵜⵓ ⵓⵔ ⴹⵢⴰ ⵎⵙⵏ ⵀⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ⵤⵍⴼ ⵓⵏ ⵛⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵗⵔ ⵀⴰ ⵎⴹⵏⵜ ⴹⵏ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⵀⵜⵓ ⵓⵔ ⴹⵢⴰ ⵔⴰ⵰ ⴶⴰ ⵓⵏ ⴾⵔⴹ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ⵙⴰ ⵎⴹⵔⵢⵏ ⵓⵏ ⴾⵜⵏⵙⵏ ⴶⵏ ⵓⵏ ⴹⴰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴹⵢⵏ ⵔⴰ⵰ ⴹⴼⵔ ⵙ ⵜⵏⵀⴰ ⴾⵜⵏⵙⵏ ⵀⴰ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ⵓⴾ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵎⴰ ⵎⵙ ⴹⵗ ⵙⴰ ⵎⴹⵔⵢⵏ ⵓⵏ ⴹⵏ ⵓⵙ ⵤⴰ ⵜⵆⵍ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵜⵗⵔⵙ ⴹⴹ ⵤⵎⵙ ⴾⵜⵏⵙⵏ ⵤⵍⴼⵏ⵿ⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵍⵈⵜⴰ ⵜⵜⴼⵎ ⴼⵍⵙ ⵓⵔⵎⴹ ⵜⵙⵏⵎ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵓⵍⴰ ⴹⵗ ⵜⵙⵏⵎ ⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵔⵏⴰ ⵏ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ⴼⵍⵙ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵓⵔ ⵜⵍⴰ ⵤⵍⴼ ⵢ ⵎⴹⵏ ⵓⵍⴰ ⵛⴹⴹⵏ⵰ ⴾⵍⵔ ⵜⵎⴹⵔ⵿ⵜ ⵤⴶⵏ ⵛⵍⵜ ⵏ ⵜⴰ ⴶⵏ ⵏ⵿ⴶⵍⵙⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵏⵎⵜⵏ ⴹ ⵜⵏⴾⵔⵏⵙⵏ ⵓⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⴹⵗ ⵜⵓⵔⵜ ⵓⴰ ⵏⴰ ⵎⵛⵏⴰ ⵢⵏⵀⵢ ⵎⵙⴰ ⵗⵔ ⵏⴼⵍⵍ ⵓⴰ ⴹⵙⴶⴰ ⵗⵔ ⵜⴼⵙⵆ⵰ ⵓⵔⴶⵗ ⴹⵙⵏⴰ ⵎⵛⵏⴰ \"ⵏⴾ ⵎⵙⵏ ⵎⵍⵢ ⵏⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹ ⵢⵆⵀ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ⵎⵛⵏⴰ ⵓⵔ ⵎⵙ ⵎⵍⵢ ⵏ ⵜⵎⵈⵙⴰ ⴾⵍⵔ ⵎⵍⵢ ⵏⵓⵏ ⴹⵔⵏⵏ ⵎⵙ⵰ ⴹⵗ ⴹⵢ ⵍⵈⵜⴰ ⵤⵓⵔⵏ ⵜⵂⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ⵂⵤⴹⵓ ⵢⵏ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵙⵙⵎⵏ ⵢⵎⵛⵓⵍ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⴰ ⴹ ⵙⴹⵙⵢⵜⵏ ⴹⵍⵌⵓⵀ ⴶⵎ ⵓⴰ ⴹⵙⵏⴶⴰ ⵗⵢⵙⴰ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵎⴰ ⵎⵙ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ ⴹⵗ ⵍⵓⵌⵀⵏ ⴾⵍ ⵓⵏ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ⵏⵙ ⵗⵢⵙⴰ «ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵓⵌⵀ ⵓⴰ ⴶⵔⵏ \"ⵙⵙⵎⵜ ⴾⵍⵙⵔⵢⵍ⵰ ⵎⵍⵏⵏⴰ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵗⵙ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ⵔⵓ ⵎⵍⵏⴾ ⵎⵛⵏⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹ ⵎⵏ ⵔⴹⵏⵏ⵰ ⵜⵔⵆⵓ ⵙⵓⴰ ⵜⵍⵗ ⴾⵍ ⴹⵗ ⵜⵢⵜⵢ ⴹ ⵜⵗⵔⴹ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«ⵎⵔⵏ ⵍⵓⵌⵀ ⵓⴰ ⵍⴾⵎⵏ ⵢ ⵓⴹⵢ ⵙ \"ⴶⵓ ⵢⵛⵆⵗⵏⴾ ⵜⵔⴰ ⵜⴰ ⵜⴶⵗ ⵎⵏⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ⵜⵤⵔ ⵏⴰ ⵎⵙⵏ ⵏⵜⵓⵔⵜ ⵓⵏ ⵢ ⵗⵢⵙⴰ «ⵜⴹⵜⵏⴾ ⵛⵈ⵰ ⵎⵛⵏⴰ ⵢⵏ⵿ⴹⴰ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢⵏ ⵔ ⵏ⵿ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ⵎⵔⵏ ⵙ ⵜⵔⴰ ⵓⴹⵏ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵔⵢ ⴹⵗ ⵙⵓⴰ ⵍⴰ ⴾⵍ ⴹⵗ ⵜⵢⵜⵢ ⴹ ⵜⵗⵔⴹ ⵔⴰ ⴹⵗ ⵛⵆⵗⵏⵜ ⵙⵎⴾ ⵓⵙ ⵔⴰ ⵎⵏⵜ ⵓⵔ ⵜⵜⵍⴰ ⵜⴾⵜⵢ ⵜⵜⵔⴾⵎⵜ ⵓⵍⴰ ⵜⴾⵜⵢ ⵢⵜ ⵓⵔ ⴶⵔ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ⴹⴰ ⴹⵗ ⴹ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢ ⵀⵜⵓ ⵜⴶⵜ ⵙⴶⵔⵢ ⵜⴰ ⴶⴰ ⵍⵙ ⵏ⵿ⵜⴰ ⴹⵙⵏⴰ «ⴾⵢ ⵓⵔ ⴾⵢⴶⴶ ⴶⵤ ⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ⵀⵙ ⵜⵍⴰ ⵢ ⵂⵍⵏ ⵙⵙ⵿ⵜⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⴶⴰ ⵙⵙ⵿ⵜⵏ ⵓⴰ ⵏⴰ «ⵓⴾ ⵓⵔⴶⵗ ⴶⵏⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵍⵎⵙⵈ ⴶ ⵎⵏⴾⵍ ⵏⵀⵢ ⴹⵓⴹ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ⴹⵓⴹ ⵤⴰ ⵎⵏⵜ ⵙ ⵜⵙⵙⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵀⵜⵓ ⵏⵍⵎⵙⵈ \"ⵎⵍⵢ ⵎⵛⵏⴰ ⵏⴰ ⵢⵎⵍⵏⵏ ⵆⵎⵓ ⴹⵗ ⵗⵍⵏ ⵂⵔ ⵗⵔⴹⵗ ⵙⵔⵙ ⵏ⵿ⵤⵏ⵿ⴶⵏⴾ ⴶⵆⵏ ⴹⵓ ⴹⵔⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ⴹⵓⴹ ⵎⵏⵜ ⵙ ⵗⵔⴰ ⵍⵎⵙⵈ ⵙⵙⵎ ⵓⵏ ⵎⵍⵢ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⵆⵍ ⵀⵔⵔⵏⵜ⵰» ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⴰ ⵜⴶⵎ⵿ⵜⵜ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⴰ ⴹⵙ⵿ⵜⵙⵙⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⴹⵗ ⵙⵙⵗⵔⵢ ⵓⴰ ⵜⵜⵜⴶⵓ ⴹⵏ «ⴶⵤⵜ ⵎⵏⵓⵏ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵔⵏ ⴹ ⵙⵗⵍⵢⵏ ⵤⵍⴶⵏ ⵛⴾⴹⴾⴹⵏ ⵤⴶⵔⵜⵏⵏ ⴹⵜⵓⵙⵙⵍⵎ ⴶⵏ ⵙ ⵙⵗⵎⵔ ⴹⵗ ⵙⵎⵏⵢⵏ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ⵔⵏ ⴹⵗ ⵜⵗⵎⵜ ⴹⵗ ⴹⴶⵏ ⵓⵏ ⵍⵏⵏ ⵍⵎⵆⵎ ⴹⵗ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⴶⵤ ⵏ⵿ⴹⴶⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⴹⵗ ⵎⴶⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ⵜⵗⵏ ⵓⴰ ⵍⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⵙ ⵓⵔ ⴹⵔⵏ ⵎⴹⵏⵙⵏⵜ ⵜⴶⵏ ⴹⵗ ⵎⴹⵏ ⵤⴶⵔⵜⵏⵏ ⵓⵔ ⵏⵎⵙ ⵔ ⵙⴾⵏⵢ⵰ ⵍⴾⵎ ⴹⵙⵏⵜⵓⵈⴾⵎ ⵜⴹⵀ ⵍⵀⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ⵆⵎ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵍⴰ ⴹⵜⵙ ⵙⵏ⵿ⴹⵆ ⵓⴰ ⴹⵗ ⵜⴹⵓ ⵔⵤⵗ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵓⴹ ⴹⵗ ⵜⵎⵜⵢ ⵜⵜⴶⵓ ⴹⵗⵙ ⵤⵔⴼ⵰ ⵙⵔ⵿ⵜⴾⵏ ⴹⵗⵙ ⵎⴶⵔⴶⵙ ⴶⵜⵏⵏ ⵤⵔⴼ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ⵜⵙⴹⵓ ⵜⵏ⵿ⵜⵜ ⵏ ⵜⵍⵆⵢ ⵙ ⵓⵔ ⴹⵔ ⵍⵙⵏⵜ ⵜⵙⵔ⵿ⵜⴾ ⴹⵗⵙ ⵙⵏⵜⵜ ⵜⴼⵍⵏ ⵙ ⵓⵔ ⵜⵓⴹ ⵍⵆⵎⵜⵏⵙⵏⵜ ⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ⵜⵤⵔ ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵙ ⵎⵏⵜ ⵏⵙⵏ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵏ⵿ⵜⵜ ⵏ ⵜⵍⵆⵢ ⵜⴰ ⵙ ⵓⵔ ⴹⵔ ⵍⵙⵏⵜ ⵜⴶⵔ ⵢⵜⴹⵏ ⴾⵜⵏⵙⵏ ⵜⵂⴾⵢ ");
INSERT INTO ttqt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ⴼⵍⵙ ⴾⵜⵏⵙⵏ ⵤⵔⴼ ⵓⵙ ⵓⵔ ⴹⵔⵔⵏ ⴹⵗ ⴾⴼⵏ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⵍⵆⵏⵜ ⵜⴹⴾⵍⴹⵓ ⵔⵢⵍⵏ ⵙⵏ⵿ⵜⵏⵢ ⵗⵙ ⴼⵍ ⵜⵙⵏ ⵜⴾⴼⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ⴶⵎⴹ ⵗⵢⵙⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⴹⵙⵏⴰ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ «ⵛⵈ ⵏⴾ ⵛⵂⵙⵢ ⵏ ⵜⵂⵏ ⵛⵏ ⵙ ⴾⵔⵙ ⵂⵏ ⴰ⵰ ⵛⵂⵙⵢ ⵏⵂⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ⵏⵙ ⵗⵢⵙⴰ «ⵜⵂⵏⵢⵗ ⵂⵏ ⵤⵓⵔⵏ ⴰ⵰ ⵓⵔ ⴹⵗⵙ ⴹⵤⵜⵆⵎ ⵜⵂⵏ⵿ⵜ ⵜⵓⵔⵜ ⵜⵎⴹⵜⵏⵜ⵰ ⴾⵜⵏⵜ ⴹ ⵜⵓⵌⵀⵔⵌⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ⴹⴼⵔ ⵓⵏ ⵆⵎ ⵗⵢⵙⴰ ⴼⵍ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ ⵤⵢⵜⵏ ⴹⵗ ⵜⵏⵎⵓⵍⴰ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⵜⵙⵙ⵿ⵜⵏ ⵀⵜⵔⵙ ⴹ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ ⴹⵏ⵿ⴹⵔⵓⵙ ⵓⵔ ⵆⵎⵏ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ⵎⵍⵏⵗ ⵎⵢ ⴹ ⵤⴶⵓ ⵔⵜ ⵓⴰ ⵜⵏⵗ ⵂⴶⵏ⵰ ⵎⴰ ⵤⴰ ⵜⵆⵍ ⵍⵗⵍⵎⵜ ⵜⴰ ⵤⴰ ⵜⵙⴾⵏⵜ ⵙ ⵀⴾ ⵢⴶⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏ⵿ⴾⴹⵜ ⴾⵓⵏⵓⵔⵙⵈⵔⴾ ⵓⴹⵏ ⵓⵍⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ⴼⵍⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵤⵙⵏⵏ ⵜⴼⵏ ⵙⵎⵏ ⴾⵢⵏ ⴹⵗⵙⵏ ⴶⵏⵓ ⵎⵙ ⵍⵎⵙⵈ ⵙⵈⵔⴾⵏ ⵙⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ⵎⵔⵏ ⵙ ⵜⵙⵍⵎ ⵢ ⵜⵔⵎⵆ ⵏⵎⴶⵔⵏ ⴹⵙⵍⵏ ⵏⵎⴶⵔⵏ ⴾⵓⵏⵓⵔⵙⵔⵎⵗ ⵓⵏ⵰ ⵔⵜⵏ ⴹⵢ ⴾⵏ⵿ⴹⵀⴰ ⵙⵏ⵿ⴹⵓ ⵎⵛⵏ ⵓⵔⴶⵗ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵜⵤⵔⵙ⵿ⵜ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ⴹ ⴾⵏⵙⵏⵜ ⴹⵓⵍⵜⵏ ⴶⵔⵙⵏⵜ ⴾⵏⵙⵏⵜ ⵜⵗⵎⵔⵏ ⴶⵔⵙⵏⵜ ⵎⵍⵏ⵿ⵜⵓ ⵏⴶⵢⵏⴶⵢⵏ ⵏⵎⴹⵍ ⴹⵗ ⴹⴶⵏ ⴶⵜⵏⵏ ⴹ ⵍⵤ ⵍⵀⵙⵏ⵰ ⵎⵛⵏ ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵓⵔ ⵎⵙⵏ ⵔ ⵏⵜⵢ ⵏ⵿ⵜⵍⵓⵢⵜ ⵜⵂⵜ ⵍⵎⵜⵍ ⵏ⵿ⵜⴰ ⴹⵜⵜⵤⵔⵜ ⵙ ⵜⵏ⵿ⵜⵜ ⵜⵜⴶⵤⵜ ⵎⵤⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«ⴾⵓⵏⵢ ⵎⵔⵏ ⵏ⵿ⴾⴹⵜ ⴹ ⵎⵏⵓⵏ⵰ ⴹ ⵜⵜⵔⵎⵙⵎ ⵜⵜⵓⵙⵀⴹⴹⵎ ⴹⵜ ⵙⴶⵓⵔⵏ ⵏⵛⵔⵗⴰ ⵜⵓⴶⵏⵜⵓⵏ ⵜⵓⵜ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⴹ ⵜⵜⵓⵙⵀⴹⴹⵎ ⴹⵜ ⵏⵈⴾⵎⵏ ⴹ ⵎⵏⴾⵍⵏ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ ⴾⴼⵓⵏ ⴹⵢ ⵜⵔⵢⵜ ⵏ⵿ⴼⵍⵢ ⵜⴶⵢⵎ ");
INSERT INTO ttqt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ⴼⵍⵙ ⵜⵓⵛⵜⵏ ⴾⵍ ⵏⴹⵏⵜ ⴾⵏ⵿ⴹⵀⴰ ⵙⵍⵏⵜ ⵢ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ⵙ ⵜⵜⵔⵎⵙⵎ ⵜⵜⵓⵙⵀⴹⴹⵎ ⴹⵗ ⴹⴶ ⵏⵛⵔⵗⴰ ⴾⵓⵏⵓⵔⵛⵓⵛ ⵓⴰ ⵤⴰ ⵜⵏⵎ⵰ ⴶⵜ ⵗⵙ ⵀⵜⵓ ⵜⴰ ⴾⵓⵏ ⵤⴰ ⵜⵜⵓⴾⴼⵜ ⴹⵗ ⵙⵗⵜ ⵜⴹⵢ ⴹⴰ ⴼⵍⵙ ⵓⵔⴶⵗ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵜⴶⵏ⵰ ⴾⵍⵔ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵜⵤⴶⵏ ⴹⵗ ⵎⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ⴹ ⵙⵜⵔⵎⵙⵏ ⵢⵜⴹⵏ ⵎⴹⵔⵢⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ ⵙⵜⵔⵎⵙⵏ ⵀⵜⵏ ⵀⵔⵔⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ ⴼⵍⴶⵏ ⵀⵔⵔⵏ ⴼⵍ ⵎⵔⵓⵏⵙⵏ ⵙⵙⴶⵏ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ⵓⴹⵏ ⴾⵍ ⴾⵓⵏⴶⵤⵔ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ ⵎⵛⵏ ⵓⴰ ⴹⵗⵓⵏ ⵤⵎⵔⵏ ⵂⵔ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵢ ⴹ ⵗⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«ⵙ ⵜⵏⵢⵎ \"ⵜⵈⵔⵎ⵿ⵜ ⵜⴰ ⵙⴾⵙⴹⵜ\" ⵜⵂⴰ ⴹⴶ ⵓⵙ ⵓⵔ ⵎⴾⵏ ⵜⵜⵂⴰ⵰ ⴶⵔⵜ ⵓⴹⵏ ⵓⴰ ⵗⵔⵏ ⵙⵍⵏ ⵓⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⴶⵤ ⴹⵢ ⴹⵗ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵓⵏ ⴹⵢ ⴹⴶⴶⵏⵜ ⵙⴹⵗⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ⵓⴰ ⵆⵎⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⴼⵍⴰ ⵏⵂⵏⵜ ⴹⵓⵔⵤⵀⵜ ⵢⴹⵏⴹⴾⵍ ⵔⵜ ⵂⵏ ⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ⵓⴰ ⵂⵏ ⵜⵓⴶⵙ⵿ⵜⵏⵜ ⴹⵓⵔⵆⵍ ⵗⵢⵓⵏ ⵢⴹⵏⴹⴾⵍ ⵙⵍⵙⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ⴾⵜ ⵍⵗⵤⵀ ⴹ ⵜⴶⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⴶⵏⵏ ⵛⴹⵙⵏ ⴹⵛⵏ ⵙⵏ⵿ⴾⵙⵏⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«ⴶⵎⵢⵜ ⴹⵗ ⵎⵛⵏⴰ ⴹⵓⵔⵎⵤⵢⵜ ⴹⵢ ⴹⵜⵎⵔ⵿ⵜ ⵏⵙⵎⴹ ⵔ⵿ⵜⵢⵏ ⴹⴾⵏⴾ ");
INSERT INTO ttqt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ⴼⵍⵙ ⵍⵗⵤⵀ ⵙⴾⵙⴹⵏ ⴹⵤⵙⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵢ ⵙ ⴹⵈⵍⴾ ⵎⵛⵏⴰ ⴹⵏⵜ ⵓⵔ ⴾⵍⴰ ⵜⵜⵓⵏⵢ ⵜⵍⵜⵏⵜ ⵤⴰ ⵓⵔ ⵍⴾⵎ ⴹⵜⵙⴰ ⵜⵍⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ⴾⵏ⵿ⴹⵀⴰ ⵙ ⴹⵏ ⵓⵏ ⴹⵢ ⴾⴼⵏ ⵎⵍⵢ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵢ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⴹⵤⵔⴶⵏ⵰ ⴾⵍⵔ ⴹ ⵜⵓⵤⴶⵤⵍⵏ ⴼⵍ ⴹⵍⵍ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵏⴼⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«ⴹⵢ ⵎⵔⵏ ⵙ ⴹⵓⵏⵏⴰ ⵓⴹⵏ \"ⵏⵢⵜ⵰ ⵍⵎⵙⵈ ⵍⴰ ⴹ\" ⵎⴹⵗ \"ⵍⴰ ⴹⵏ\" ⴹⵙⵓⵔ⵿ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ⴼⵍⵙ ⴹ ⵜⵎⵍⵏ ⵍⵎⵙⵈⵏ ⵏⵀⵂⵓ ⵎⵍⵏ⵿ⵜⵓ ⴹⵗ ⵏⵀⵜⵏ ⵏⵀⵂⵓ⵰ ⴹ ⵜⴶⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵂⵔ ⵙ ⵏⵔ ⴼⵔⴶⵏ ⵓⵏ ⵙⵈⵔⴾⵏ ⵢⵜⴹⵏ ⵂⵔⴾⴹ ⵓⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴹ ⵎⵏⵓⵏ⵰ ⵔⵜⵏ ⴹⵢ ⴾⵜⵏⵙⵏ ⴶⵗⵓⵏ⵿ⵜⵏ ⴹⵓ ⵗⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«ⴹⴼⵔ ⵜⵙⵙ⵿ⵜ ⵜⴰ ⵤⴰ ⵜⴶⵜ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵢ ⴹ ⵍⵙⵏⵜ ⵛⵢⵢ ⵜⴼⴾ ⴶⵎⴹ ⵏⵔ ⵜⵍⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ⵔ⵿ⵜⴾⵏ⵿ⴹⵓ ⵜⵔⵏ ⵏⴶⵢⵏⴶⵢⵏⵜ ⵜⵈⵍⴾ ⵛⵏ ⵍⵏⵏ ⵜⵔⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ⵍⵓⵆ ⵓⴹⵢ ⴹⴰ ⴹ ⵤⴰ ⵜⵓⵏⵢⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵙ ⴹⵤⵙⴰ ⵂⵗ ⵛⴶⵏⵓⵏ ⴹⵗ ⵜⵔⵏⵏⵏ ⵜⴶⵜ ⴹ ⵜⵏⵢⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ⵜⵤⵔ ⵤⵎⵤⵍⵗ ⵏ⵿ⴶⵍⵙⵏ ⵙ ⵜⵗⵎⵔ ⵏ ⴾⵤⵜ ⵏⴹⵏⵜ ⵢⴹⵛⴹⵓⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵏⴼⵔⵏⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ⵏⵙⵏ «ⵀⵤⵜ ⵍⴼⵢⴹⵜ ⵙⵍⵎⵜⵍ ⵓⵏ ⵛⴾ ⵏ⵿ⴼⴶ⵰ ⴶⴹⴰ ⴹ ⵂⵙⵢⵏ ⵍⴹⵍⴹⵏⵜ ⴶⵤⴹⵓ ⵛⵏ ⵜⵏⵤⵔⴰ ⴹ ⵜⵙⵏⵎ ⵙ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⴾⵙⴰ ⵜⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⵗ ⵙ ⵙ ⵜⵏⵢⵎ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏⵎⵍⵗ ⴹⵢ ⵜⵙⵏⵎ ⵙ ⵗⵔⴹ ⵏⴹⵏⵜ ⵂⵤ ⵓⵔ ⵍⴰ ⴶⵔⵓⵏ ⴹⵔⵙ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵎⵜⵢ ⵜⴰ ⴹⴰ ⵏⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ ⴹ ⵜⵏⵢ ⵏⵜⵢ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵍⴾⵎ ⴹ ⵀⵙ ⵜⵍⵏ ⵎⵛⵏ ⵀⵜⵜⵏⵏ ⵍⵏⵜⵓ ⵂⵔ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«ⵤⵍ ⵎⵔⵏ ⵓⵍⴰ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵤⴶⵓ ⵓⴰ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⵙⵏⵏ ⴶⵔ ⵤⴰ ⵏ⵿ⴶⵍⵙⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⵓⵍⴰ ⵀⵔⵔ ⵎⵏⵜ⵰ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙⵏ ⵙⵏⵏ ⵔ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ⵏ⵿ⴾⴹⵜ ⵜⵙⵎⵜⴶⵎ ⴼⵍⵙ ⵓⵔ ⵜⵙⵏⵎ ⵙⵗⵜ ⵜⴰ ⴹⵗ ⵤⴶⵓ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ⵂⴰ ⴹⵢ ⵍⵎⵜⵍ ⵏⵍⵙ ⵛⴾⵍⵏ⵰ ⵙ ⴶⵤ ⵛⵏ ⵜⴾⵍⵢ ⴶⴰ ⵛⵏⴹⵏ ⵏⵗⵢⵓⵏⵜ ⴹⵗ ⴼⵙⵏ ⵏⴾⵍⵏⵜ⵰ ⴾⵢⵏ ⵎⵍⵙ ⵛⵗⵍ ⵓⵙ ⵜⵓⵔ ⴶⵏⵜ⵰ ⵏⴰ ⵢ ⵓⴰ ⴶⵤⵏ ⵎⵢ ⵏⵂⵏ ⴹ ⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴼⵍⵙ ⵓⵔ ⵜⵙⵏⵎ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⴹⵤⵙⵓ ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⴾⴹ ⵍⵎⵤ ⵓⵍⴰ ⴹⵓⵏⵢ ⵏⵂⴹ ⵓⵍⴰ ⴹⵜⵤⵍ ⵓⵍⴰ ⵗⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ⴾⵓⵏ⵿ⴹⵓⵔⵙⵓ ⴹⵗ ⵍⵓⵆ ⴹⵗ ⵙ ⵓⵔ ⵜⵙⵓⴹⵎ ⴶⵤⴾⵓⵏ⵿ⴹⵓ ⵜⵏ⵿ⵙⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ⵓⴰ ⴹⵓⵏ⵿ⴶⵏⴰ ⴹⴰ ⴾⵜⵏⵓⵏ ⵙ ⴹⵓⵏ⵿ⵜⴶⵏⴰ ⵜⵎⵙⵏ ⵙ ⵏ⵿ⴾⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ⵛⵏ ⴹⵏ ⴹⵏⵀⴰ ⴹⵗ ⵎⴹ ⵓⵏ ⴾⵢ ⴹⵎⴹ ⵓⴰ ⴹⵗ ⵜⵎⵜⵛⵏⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ⵰ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵂⵔⵓⴰ ⴹⴰ ⴶⵎⵢⵏ ⵜⵎⵔⴾⵙ⵿ⵜ ⵜⵙ ⵤⵀⵤⵏ ⵗⵢⵙⴰ ⴶⵏ ⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ⴼⵍⵙ ⴶⵏⵏ «ⴹ ⵓⵔ ⵏⴶⵓ ⴹⵢ ⴹⵗ ⴹⵏ ⵏⵎⴹ ⴼⵍ ⴹⵓⵔⵓⵢ ⵏⵌⵔⵓⵢ ⵙ ⵜⵎⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ⵓⵏ ⵙ ⵜⴶⵓ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵂⴰ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⵏⵢ ⵎⴶⵔⵜ ⵢ ⵙⵎⵗⵏ ⵓⵙ ⴾⵍⴰ ⵜⴶⵔⵓ ⴾⵜⵔⵓ⵰ ⵜⵎⵏ⵿ⵙⵓ ⴹⵏ ⴹⴰ ⵙ ⴹⵜⵙⴰ ⵜⵏ⵿ⵜⵜ ⵜⵓⵢⵜ ⵀⵜⵍⵢ ⴶⵏ ⴹⵗ ⵜⵂⵏ⵿ⵜ ⵎⵍⵜ ⵂⴰ ⵍⵓⵔⴹⵢ ⴾⵏⵏ ⵛⵤⴹⴰ ⴹⵤⵓⵢ ⵙ ⵜⵓⵏⵓ ⵏⵔ⵰ ⵜⵙⴹⵓ ⵗⵙ ⵜⵔⵤⴰ ⵎⵢ ⵏ ⵀⵜⵍⵢ ⵓⴰ ⵜⵓⵢ ⴹⴰ ⴹ ⵜⵏⵆⵍ ⵍⵓⵔⴹⵢ ⵓⵏ ⴼⵍ ⵗⴼ ⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ⵔⵜ ⵓⵏ ⴶⴰ ⵍⵂⵎ ⴹⵗ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⴹ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵎⴰ ⵏ⵿ⴼⴰ ⵂⵍⴾ ⵏⵍⵓⵔⴹⵢ ⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ⵓⵔⴶⵗ ⴼⵔⴶ ⴹⵏⵏ⵿ⵤⵓ ⵍⵆⵎⵜ ⵏ⵿ⴾⵔⴹⵜ ⵜⵎⴹ ⵏⵤⵍ ⵏⵛⵗⵍ ⵜⵓⴾⴼⵓ ⵓⵏ ⵢ ⵜⵍⵆⵓⵏ⵰» ⴹ ⵙⵗⵍⵏ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵜⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⴼⵜⵜ ⵎⵙⵍⴶ⵰ ⵎⴼⵍ ⴹⵙ⵿ⵜⵗⵛⴹⵎ ⵎⵏ⵰ ⵎⵤⵍ ⵍⵗⵏ ⴹⵜⴶⴰ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ⴼⵍⵙ ⵛⵍⵆⵓⵏ ⴼⵓ ⴹⴰ ⵍⵏⵜ ⵗⵔⵓⵏ ⴹ ⵜⵔⵎ ⴹⵢ ⵜⴼⵔⴶⵎ ⴹⵙⵏⵜⵍⵍⵎ⵰ ⵏⴾ ⵎⵔⵏ ⵓⵔⴶ ⴼⵓ ⵍⵗ ⵗⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵓⴰ ⵜⴼⵔⴶ ⵜⴶⵢ⵰ ⵜⵏ⵿ⵗⵍ ⴼⵍⵢ ⵍⵓⵔⴹⵢ ⵢⴹ ⵜⵙⵎⵜⴶ ⵜⵗⵙⵏⵏ ⵢⵤⴾⴰ ⵂⵔⵓⴰ ⴹⵜ ⵍⵓⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⴶ ⴹⵗ ⵜⵎⵍ ⵍⵏ⵿ⵌⵍ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ ⴹⵗⵙ ⵜⵎⵍ ⵓⴰ ⵜⴶⴰ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵜⵓⴾⵜⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ⴹⵏ ⴹⴰ ⴹ ⵏ⵿ⴾⵔ ⵢⵂⵤⴰ ⵙⵈⵔⵢⵜⵢ ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ ⵗⵢⵙⴰ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴾⴰ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴼⵍ ⴹⵙⵏⵎⵍ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵓ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ⵙⴹⵓⵜⵏ ⵓⵏ ⵜⵤⵔ ⴶⵏⵙ ⵔⴾⵓⵍ ⵏⴹ ⵜⴾⴼⵏ ⵤⵔⴼ⵰ ⴹ ⴶⵎⵢ ⵢⵂⵤⴰ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵓ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ⵤⵍ ⵓⴰ ⵤⵔⵏ ⵏⵎⴹ ⵓⴰ ⴹⵗ ⵜⵎⵜⵛⵏⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵤⵍ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵜⵓⴶⵤⵎⵏ ⵌⵗⵍ ⵓⵏ ⵎⴹ ⵓⵏ ⴾⵢ ⵏⵏ ⵏⵜⵍⵀ ⵢ ⵗⵢⵙⴰ «ⵎⵏⴹ ⵜⵔⵗ ⴹⴾⵏⵙⵎⵜⴶ ⵎⵏ⵿ⵙⵓⵏ ⵏⵎⴹ ⵓⵏ ⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ⵜⵤⵔ ⵙⴾⴰ ⵗⵢⵙⴰ ⵛⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵢⵔⵙⵍⵎ ⵏⵙⵏ «ⴶⵤⵜ ⵗⵔⵎ ⴹ ⵜⵎⵏⵢⵎ ⴹⵍⵙ ⵓⵢⵏ ⵜⴾⵏ ⴹⴾⵔⵏ ⵎⵏ⵰ ⵍⴾⵎⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ⵂⵏ ⵓⴰ ⴶⵤ ⵏⵜ ⵢ ⵎⵛⵙ \"ⵏⴾ ⵛⵈ 'ⵎⵏⵢ ⴹⴶ ⴹⵗ ⵂⵏⴾ ⵓⴰ ⴹⵗ ⵤⴰ ⵏⵎⵏ⵿ⵙⵓ ⵏⴾ ⴹ ⵏⵜⵍⵀⵏ ⴹⵗ ⵎⴹ ⵓⵏ ⴾⵢ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ⴾⵓⵏⵙⴾⵏⵓ ⴹⵗ ⵙⵔⵏⵜ ⵂⵏ ⵓⵏ ⴼⵍⴰ ⵍⵓⵏ ⵂⵏ⵿ⵜⵓ ⵎⵜⴶ ⴾⵍ ⴾⵏⴰ⵰ ⴹⵢ ⴹⴰ ⴹⵏⵤⵜⵙⵎⵜⴶⵎ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ⴶⵍⵏ ⵏⵜⵍⵀ ⴾⵏ ⵗⵔⵎ⵰ ⵙ ⴹⵏⵓⴹⵏ ⵏⵢⵏ ⵓⴰ ⴹⴰ ⴹⵙⵏⵎⵍ ⵗⵢⵙⴰ⵰ ⵜⵤⵔ ⵙⵎⵜⴶⵏ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵙⴹⵓ ⵗⵢⵙⴰ ⴹⵓ ⴹ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ⵙⵗⵎⵔ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ ⴹⵏ ⴹⴰ ⵜⵎⵏ⵿ⵙⵓⵏ ⵙ ⴹⵙⵏⵏⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢⵏ ⴹⵗⵓⵏ ⴹⵔⵢ ⴹⵔⵓⵏ ⴹⴰ ⴹⴰ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ⵗⵛⴹ ⵓⵏ ⵎⵏⵙⵏ ⴾⵢⵏ ⴹⵗⵙⵏ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵏ⵿ⴶⵎ ⵓⵔⴶ ⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ⵏⵙⵏ «ⵢⵏ ⴹⵗⵓⵏ ⴾⵓⵏⵢ ⵏⵜⵍⵀⵏ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵔⵢ ⴹⵔⵓⵏ ⵎⵔⴹⴰ ⴹⵗ ⵗⵤⵓ ⵢⵏ⵿ⴹⴰ ⵤⴶⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ⵍⴾⵏ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵀⴰ ⵙⵎⴾ ⵎⵏⵜ ⵓⴰ ⵎⵍⵏ ⵍⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵏⵏ ⵎⵛⵏ ⵢⴰ ⴾⵜ ⵍⵗⵤⵀ ⵜⵏⵢ ⵓⴹⵏ ⵓⴰ ⴹⴶⵏ ⴹⵗ ⴼⵙⵏ⵰ ⵓⴹⵏ ⵓⴹⵢ ⴹⵙⴼⵓ ⴼⴹⴰ ⴹⵓⵔⴶⵤ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ⵜⵜⵏ ⴹⴰ ⴹⴰ ⵙ ⴹⴾⵍ ⵗⵢⵙⴰ ⵜⴶⵍⴰ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵔⵤⴰ ⵜⴶⵍⴰ ⵜⵏ ⵤⵏ⵿ⵜⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵜⵛⵓⵜ ⴹⴰ ⵜⵗⵙⵏⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ⴹⴼⵔ ⵓⵏ ⴹⴾⵍ ⵜⴾⵀⵔ⵿ⵜ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵎⵔⵏ ⴾⴼⵙⵏ⵿ⵜⵜ ⵏⵎⴶⵍⵤⵏ ⵓⴰ ⵜⵜⵂⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ⵎⵔⵏ ⵏⵙⵏ «ⴹⵢ ⵤⵏⵏⵏ ⵙⵜⴹⵏ ⵔⴾⵓⵍ ⵏ ⵜⵙⵆ ⴶⵔ ⵎⵛⵏⴰ ⴹ ⵜⵎⵜⵢⵏⵜ⵰ ⵤⵏⵢ ⵓⴰ ⴹ ⵏ⵿ⵗⵍ ⴼⵍ ⵜⵏ⵿ⴼⴰ ⵏⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵤⵍⵙⵗ ⵜⵙⵢ ⵏⵙⵎⴹ ⵏⵍⵗⵏⵀ ⴾⵜ ⵓⵔ ⴹⵓⴹ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⵛⵓⴰ ⵓⴰ ⵢⵏⵢⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ⴹⴼⵔ ⵓⵏ ⵙⴶⴹ ⵗⵢⵙⴰ ⴹ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵜⵎⵍⵏ ⴹⴶⵎⴹⵏⵏ ⵤⵀⵔ⵰ ⵙ ⵜⵏⵜⵗⵔⴹⵏ ⴾⵏ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ ⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⴾⵜⵏⵓⵏ ⴹ ⵓⵍⵓⵍ ⵤⴶⵤⵏⵓⵏ ⴹ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⴹ ⵓⵜⵗ ⵎⴹⵏ ⵀⵜⵓ ⵜⵤⵔ ⵓⵤⵓⵤⵏⵜ ⵢⴼⴹⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ⵎⵛⵏ ⴹⴼⵔ ⵜⵓⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵓⵏⵏⵤⵔⵗ ⵙⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⵆⵍⵗⵓⵏ ⴹⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ⵜⵤⵔ ⵏⵙ ⵀⵜⵔⵙ «ⴾⴹ ⵓⵍⵓⵍ ⵤⴶⵤⵏⵙⵏ ⴾⵜⵏⵙⵏ ⴹⴰ ⵓⵏⵏ ⵓⵔ ⵤⵓⵍⵓⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵂⴹⴰ ⴹⴰ ⵙ ⵤⴶⵓ ⴾⵌⵢ ⵢⵗⵔⴰ ⵙⵏⵜⵜ ⵜⵗⵔ ⵜⴶⴹⵗⵢ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ⵎⵛⵏ ⵤⵤⵓⵜ ⵀⵜⵔⵙ ⴹⵗ ⵀⵜⵏⵜ ⵏⴰ «ⴾⴹ ⵆⵍ ⵙ ⵜⵓⵏ⵿ⵗⴰ ⴾⵔⵤ ⵤⴰ ⵏⴶⵓ ⵏⴾ ⴹⵔⴾ ⴹⴰ ⵓⵔ ⴾⵢⵤⴶⴹⴰ⵰ ⵏⵏ ⵏⵜⵍⵀ ⴾⵜⵏⵙⵏ ⵓⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ⴹⴼⵔ ⵓⵏ ⴹⵓ ⴹⵔⵙⵏ ⵗⵢⵙⴰ ⵙⴼⵔⴶ ⵏⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ ⴶⵏ ⵙⵎ ⴶⵜⵙⵎⵏⵢ⵰ ⵙ ⴹⵏⵓⴹⵏ ⵏⵙⵏ «ⵆⵎⵓⵜ ⴹⴰ ⴹⴰ ⴾⵜ ⴹⵢ ⴹ ⵜⴶⴰ ⵛⵓⵜⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ⵤⵏ⵿ⴾⵤ ⴼⵍⵙⵏ ⴹⵓ ⴹ ⵀⵜⵔⵙ ⴹ ⵢⵆⵀ ⴹ ⵢⵈⵢⴰ⵰ ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⴹⵗ ⵙⵏ⵿ⵜⵏ ⵎⵏⵜ ⵗⵛⴹ ⵛⵓⵛ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ⵏⵙⵏ «ⵓⴰ ⴶⵏ ⵎⵏⵏ ⴹⵗ ⵗⵛⴹ ⵀⴾⴰ ⴹⵀⴰ⵰ ⴹ ⵓⵔ ⵜⴼⵍⵎ ⴹⴰ ⵎⵔⵏ ⴾⵓⵏⵓⵔⵀⵤ ⵜⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ⵤⵏ⵿ⴾⵤ ⴼⵍⵙⵏ ⵏ⵿ⴹⵔⵏ ⵙⵌⴹ ⴹ ⵜⵜⵔ ⴶⵎⵢ ⴹⵗ ⵎⵛⵏⴰ ⴾⴹ ⵎⴾⵏ ⵜⵙⴶⴶ ⵓⴰ ⵜⴹⵤⵢⵏ ⴹⵗ ⵍⵓⵆ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ⵏⴰ ⴹⵗ ⵜⵓⵜⵔⵢⵏⵜ «ⵢⴰ ⵀⵏⵏ ⵔⵜ ⴾⵍ ⵜⴼⵔⴶⵗ ⴶⵏⵜ⵰ ⵙⴶⴶⵢ ⵜⴰ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵏⵍⵗⵤⵀ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴶⵜ ⵜⵔⴰ ⵜⵏⴾ ⵓⵔⴶⵗ ⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ⴹⴼⵔ ⵓⵏ ⵆⵍⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹ ⵏ ⴶⵤⵜⵏ⵿ⴹⵓ ⵏ⵿ⵙⵏ⵰ ⵙⵏ⵿ⴾⵔ⵿ⵜⵏ ⵏⴰ ⵢ ⵀⵜⵔⵙ «ⵙⵎⵗⵏ ⴾⵢ ⴹⵙ ⵜⵙ ⵜⴶⵗ⵰ ⵏ⵿ⴹⵔⴾ ⴹ ⵜⴶⴰ ⵓⵍⴰ ⵗⵙ ⵍⵓⵆ ⵢⵏ⵿ⴹⴰ ⵜⴾⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ⴾⵢⵜ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴾⵓⵏⴶⵤⵏ ⴹⵗ ⵌⵔⵀⵜⵏ ⵏⵀⵍⵙ⵰ ⵜⴹⵜ ⵙ ⵏⵢⵜ ⵏⴶⴹⵎ ⵜⵙⴹⵔⵏ ⴶⵢ ⵏⵓⴰ ⵍⵗⵏ ⵎⵛⵏ ⴶⴹⵍⵙ ⵔⴾⵎ ⵏ⵿ⵜⵗⵙⵏⵜ ⴶⵢ ⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ⵍⵙ ⵤⵏ⵿ⴾⵤ ⴼⵍⵙⵏ ⴶⴰ ⵜⵓⵜⵔⵢ ⵜⴰ ⴹⵗ ⴶⴰ ⵂⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ⴹⴼⵔ ⴹⵢ ⵍⵙⵏ ⵜⵓⵗⵍⵢ ⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹ ⵙⵏⵏ ⵏ⵿ⵙⵏ ⴼⵍⵙ ⵓⴰ ⴹⵙⵏⴶⴰ ⵜⵙ ⴹⵗ ⴶⵤ ⵀⵙ ⴼⵔⴶⵏ ⵔⴰ ⵏⵛⵜⵓⵏⵙⵏ⵰ ⵓⵔ ⵙⵏⵏ ⴹⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ⵙ ⴹⵙⵏ⵿ⴹⴶⴰ ⵜⵓⵗⵍⵢ ⵜⵏ ⴾⵔⴹⵜ ⵏⵙⵏ «ⵂⵔⵓⴰ ⴹⴰ ⵜⵏ⵿ⵙⵎ ⵜⵙⵏ⵿ⴼⵎ⵰ ⵀⵜⵓ ⵤⴰ ⵜⵗⵔⴹ⵰ ⵙⵏⵜ ⵙ ⵍⵓⵆ ⵓⴹⵓ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵓⴶⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⴼⵙⵏ ⵏ ⵏⵙⵀⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ⵏ⵿ⴾⵔⵜⵏ ⵏ⵿ⴹⵓⵜ⵰ ⵏⵢⵜ⵰ ⵓⴰ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵓⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵗⵢⵙⴰ ⵙ ⴹⵙⴰ ⵢⵂⵤⴰ ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵓ ⴹⵜⵎⵜⵢ ⴹⵙⴶⵍⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⵜⵎⵜⵢ ⵜⵏ ⵜⵓⵢ ⵛⴾⵀⵓⵏ ⴹ ⵜⵀⵔⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ⵎⴾⴹⵍ ⵓⴰ ⴶⵏ ⵢⵂⵤⴰ ⵎⵍ ⵢ ⵜⵎⵜⵢ ⵜⵏ ⵎⴾ ⵓⵙ ⵤⵤⴹⵢⵏ ⵗⵢⵙⴰ ⵙ ⵜⵏⴰ ⵜⴰ ⴹⵙⵏⴶⴰ «ⵍⵙ ⵓⵙ ⴹⵜⵏⵢⵎ ⵙ ⵜⵤⵍⵎⵗ ⵏ⵿ⵜⴰ ⵗⵢⵙⴰ⵰ ⵀⵤⵜⵓ ⵜⴶⵍⵎ ⴹⵔⵙ ⵜⴶⵎ ⴹⵔⵙ ⵏⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ⵙⴹⵓ ⵢⵂⵤⴰ ⵗⵙ ⵂⵤⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵛⵈ⵰» ⵜⵤⵔ ⵤⵍⵎⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ⵜⴶⴹⵏ ⵜⵎⵜⵢ ⵙ ⵗⵢⵙⴰ ⵜⵀⵤⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ⵂⴹⵓ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⵍⵀⵢ ⵜⴾⵀⵏⵜ ⵓⵜ ⵙⵔⵙ ⴾⵍⵢ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴼⵔⵙⴹⵓ ⵜⵎⵤⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ⵜⵏ «ⵓⴾ ⵏⴾ ⵌⵌⵀ ⵢⵏ ⵏⵀⵢⴹⴶ ⵎⵙⴰ ⵙ ⴹⴹⵜⵜⴾⵎ ⵜⵓⵢⵎ ⵛⴾⵀⵓⵏ ⴹ ⵜⵀⵔⴶⵏ ⵢⴹⵜⵀⵤⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ⵓⵔⴶⵗ ⵤⵍ ⴾⵍ ⵍⵗ ⴶⵔⵓⵏ ⵙⵙⵗⵔⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⴼⵍ ⵓⵔ ⴹⵜⵀⵤⵎ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵓⴰ ⴶⵏ ⴹⴰ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⴰ ⵙⵔⵢ ⵏⵏ ⵍⴾⵜⵀⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ⴹⵏ ⴹⴰ ⵜⴼⵍⵏ ⵏⵜⵍⵀⵏⵜ ⴾⵜⵏⵙⵏ ⴹⴶⴶⵏ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ⵍⴾⵎ ⵎⵓⴹ ⵢⵏ ⵢ ⵜⵎⵜⵢ ⵏ ⵍⵙⴰ ⴼⵔ ⵂⵙⵢⵏ ⴹⵓ ⵓⵔ ⵆⵏ ⵔⵜ⵰ ⴶⴹⵏⵏ ⵙⵔⵙ ⵎⴹⵏ ⵢⴹ ⵜⵀⵤⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ⵢⵙⵏ⵿ⴹⵓ ⴼⵔ ⵓⴰ ⵍⵙⴰ ⵤⵍ ⵓⵔ ⵍⵙⴰ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ⵎⵓⵢ ⵗⵢⵙⴰ ⵙⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵗⵔ ⴹⵓⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ⴶⴰ ⵀⵜⵔⵙ ⵢ ⵗⵢⵙⴰ ⵍⴾⵎ ⵤⴶⵔⵏ ⵂⵔ ⴶⵤ ⵎⵙ ⵏⵗⵍⴰ ⵏⵗⵢⵓⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰ ⵆⵎ ⴹ ⵙⴾⵙ ⵗⵔ ⵎⵛⵗⵍⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵆⵎⵏⵏ ⵙ ⵜⵎ⵿ⵙⵢ ⵜⵔⵗⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴾⵜⵏⵜ ⴶⵎⵢⵏ ⵢ ⵤⴶⵢⵏ ⴼⵍ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵔⵢⵜ ⵏⴶⵢ ⵏⵎⵏⵜ ⵎⵛⵏ ⵓⵔ ⵜⴶⵔⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ⴼⵍⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵏ⵿ⴾⵔⵏⵏ ⴶⵏ ⴼⵍ ⵗⵢⵙⴰ ⵛⴶⵢⵓⵏ ⵎⵙⵏⵏ ⵀⵂⵓ ⵎⵛⵏ ⵓⵔ ⵜⵏⵜⵂⴰ ⵛⵢ ⵜⵏⵎⵏⴾⵜ ⴹ ⵜⵂⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵓⵢⴹ ⴹⵗⵙⵏ ⵙⵓⵔⵏ⵿ⵜⵓ ⵀⵂⵓ ⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«ⵏⵙⵍⵙ ⵙ ⵏⴰ \"ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵢⵜⴹⵏ ⵜⴾⵔⵙⵏⵏ ⵜⵌⵀⵔⵌⵗ ⵙⵀⴹⴹⴰ ⴹⵗ ⴾⵔⴹ ⴹⵏ ⵢⵏ ⵓⵔ ⴾⵔⵙⵏ ⵢⵜⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ⵎⵛⵏ ⵀⵜⵓ ⵜⴰ ⴹⴰ ⵎⵤⵔⵢⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ⵜⵤⵔ ⵏ⵿ⴾⵔ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵀⴹⴹ ⴹⵗ ⵎⵙ ⵏⵍⵌⵎⵗⵜ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵓⴾ ⵔⵜ ⵓⵔ ⵜⴶⵏⴰ ⴹⵗ ⵜⵗⵜⵙ ⵛⵏ ⴹⴾⵜⵓⴶⵏⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ⵎⵛⵏ ⴶⵍⴰ ⵗⵢⵙⴰ ⴼⵙ⵿ⵜⴰ ⵓⵔ ⴹⵙⵏⴰ ⵓⵍⴰ⵰ ⵍⵙ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙ «ⵓⴾ ⴾⵢ ⵎⵙⵏ ⵍⵎⵙⵈ ⵀⵔⵔ ⵏ ⵓⵙ ⵏⵜⴶⵓ ⵜⵎⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵍⴰ ⵎⵙⵆⵓ⵰ ⵎⵔⵏ ⴹⵜⵏⵢⵎ ⵏⴾ ⴶ ⴶⴹⵎ ⵆⵎⴰ ⴹⵓ ⵗⵍ ⵏⵎⵍⵢ ⵏ ⵜⵔⵏⴰ ⵜⵏⵢⵎⵢ ⴹⵗ ⵤⵢⴹⵓ ⵂⵗ ⴶⵔⴾⵏ ⴶⵎⴹⴹⵓ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ⵙ ⵙⵍⴰ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵢⵓⵏ ⵤⵤⵔⵜ ⵜⴾⴹⴾⵜⵏⵜ ⴼⵍ ⵓⴰ ⴶⵏ ⵎⵏⵜ ⴹⵗ ⵗⵛⴹ ⵏⴰ «ⵓⴾ ⵎⴰ ⵏⴾⴰ ⵢ ⵜⴶⵢⵓⵏ ⵛⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ⵜⵙⵍⵎ ⵢⵎⴹⵔⵓ ⵓⴰ ⴶⴰ ⴹⴰ ⵢ ⵎⵛⵏⴰ⵰ ⵎⴰ ⵜⵏⵎ⵰» ⵏⵏ ⴾⵜⵏⵙⵏ ⵛⵔⵗⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ⴼⵍⵙ ⵙⵜⴼⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵗⵎⵙⵏⵙ ⴹ ⵜⴶⵜⵏ ⴶⵏⵏⵙ «ⴾⵢ ⵢⴰ ⵏⵀⵢ ⵎⵍ ⵓⴰ ⴾⵢⵓⵜⵏ⵰» ⴹⴼⵔ ⵓⵏ ⵜⵓⴾⴼⴰ ⵢ ⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵙ⵿ⵜⴶⵏ ⵛⵆⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ⵂⵔⵓⴰ ⴹⴰ ⵆⵎ ⵀⵜⵔⵙ ⴹⵗ ⵎⵙ ⵏⵗⵍⵏ ⴹⴰ ⵙ ⴹⵜⵙⴰ ⵢⵜ ⴹⵗ ⵜⵎⵛⵗⵍⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ⵜⵏⵢⵜⵓ ⵙⴾⵙ ⵙ ⵜⵎ⵿ⵙⵢ ⵜⵤⴶⵤⴹⵢ ⵜⵏⵙ «ⴾⵢ ⴹⴰ ⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴹⵓⵏⵏ ⴹ ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ⵎⵛⵏ ⴶⴹ ⵀⵜⵔⵙ ⵙ ⵜⵤⴹⵢ ⵏⴰ «ⵓⵔⵎⴹ ⵙⵏⵗ ⵓⴰ ⴹⵗⵢ ⵜⵛⵓⵍⴰ ⵤⴰ ⵓⵔ ⵜⴶⵔⵗ⵰» ⵜⵤⵔ ⴶⵎⴹ ⵗⵍⴰ ⴾⴰ ⵎⵏⵜ⵰ ⵗⵔⴰ ⴾⵌⵢ ⵗⵔⴰ ⴹⴰ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ⵜⵏⵢⵜⵓ ⵜⵎⵛⵗⵍ⵿ⵜ ⵜⵍⵙ ⵜⵏⴰ ⵢⵢⵜⴹⵏ ⵀⴹⴹⵏⵏ ⴹⵏ «ⵍⵙ ⵓⴰ ⵢⵏ ⴹⵗⵙⵏ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ⵍⵙ ⵀⵜⵔⵙ ⴶⴹ ⵗⵢⵙⴰ⵰ ⵔⵜ ⵏⵎⵤⵢ ⴹⴼⵔ ⵓⵏ ⵏⵏ ⵢⵜⴹⵏ ⵀⴹⴹⵏⵏ ⴹⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵢ ⵀⵜⵔⵙ «ⵍⴾⵏ ⵙ ⴾⵢ ⴹⴰ ⵢⵏ ⴹⵗⵙⵏ ⵜⵎⵙⴰ ⴼⵍⵙ ⴾⵢ ⴹⴰ ⵏ ⴾⵍ ⵏ ⴶⵍⵍⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ⴹ ⵂⴹ ⵀⵜⵔⵙ ⴶⵏⵓ «ⵎⵛⵏⴰ ⵢⴰ ⵜⵍⵗⵏⵗⵢ ⴾⴹ ⵀⵂⵓ ⴶ⵰ ⵂⴹⵗⵓⵏ ⵙ ⵓⵔ ⵤⴹⵢⵗ ⵍⵙ ⵓⵙ ⵜⴶⵏⵎ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ⴹⴰ ⴹⴰ ⵗⵙ ⴹ ⵏⴰ ⵀⵜⵔⵙ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⴶⴰ ⴾⵌⵢ ⵢⵗⵔⴰ ⵜⵗⵔⵢ ⵜⵏ ⵙⵏⵜⵜ ⴾⵜⴹⵓ ⵀⵜⵔⵙ ⵀⵜⵓ ⵜⴰ ⴹⵙⴶⴰ ⵗⵢⵙⴰ ⵙ ⴹⵙⵏⴰ «ⵙ ⵤⴶⵓ ⴾⵌⵢ ⵢⵗⵔⴰ ⵙⵏⵜⵜ ⵜⵗⵔ ⵜⴶⵗⵢ ⴾⵔⴹ ⴾⵙⵏ ⵢ ⵜⵤⴹⵢⵜ⵰» ⵜⵤⵔ ⵗⵛⴹⵏ ⵎⵏ ⵏⵀⵜⵔⵙ ⵓⵍⵏ ⴶⵤ ⵛⵏ ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ⵙ ⴼⵓ ⵗⵔⴰ ⵎⵏⵢⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵍⵎⵗⵏⴰ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴾⵜⵏⵜ ⵙⵙⴾⵔⴹⵏ ⵗⵢⵙⴰ ⵓⵢⵏ⵿ⵜⵓ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⴼⵙⵏ ⵏⵏⵈⴾⵎ ⵀⵍⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵀⵍⵜⵙ ⵏⵙ «ⵓⴾ ⴾⵢ ⴹⵗ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ ⴾⵍⵍⵢⵂⴹ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ⴹ ⵙⵓⵔⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⵗⵢⵙⴰ ⵔⴾ ⴶⵜⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ⵍⵙ⵿ⵜⵓ ⵀⵍⵜⵙ ⵙⵙ⵿ⵜⵏ ⵏⵙ «ⵜⵙⵍⴰ ⵢⵔⵜⵏ ⴾⵍ ⵓⵏ ⴾⵢⵙⵓⵔⵏ ⴹⴰ⵰ ⴾⵢ ⵎⴰ ⵜⵏⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ⵆⵎ ⵗⵢⵙⴰ ⵓⵔ ⴹⵙⵍⵙ ⵜⵏⴰ ⵏⵔⵜ⵰ ⵙⵎⴾⵍⵍ ⵓⵏ ⵙ ⵀⵍⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ⴹ ⴹⵗⵍⵢ ⵎⴹ ⵓⵏ ⴾⵢ ⴹⴾⵙ ⵏⵈⴾⵎ ⵀⵍⵜⵙ ⵎⵙⴾⵙⵓ ⵓⵙ ⵜⵔⴰ ⵜⵎⵜⵢ ⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ⵙ ⵜⴶⵓ ⵓⵏ ⵍⵢ ⵍⵙ ⴶⵏ ⵙⵎ ⵀⵔⵗⵀⵙ ⵂⵏ ⴾⵙⵓ ⵏ⵿ⵜⴰ ⴹ ⵏⴼⵍⴶ ⵓⵢⴹ ⵙ ⴾⵍⴰ ⵌⵏⵌⵔⵓⵢⵏ ⵜⵎⵜⵢ ⵂⵔ ⴶⵏ ⵎⵏ ⵏⵓⴹⵏ ⴹⵗ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ⵜⵏ⵿ⴾⵔ ⵜⵎⵜⵢ ⴹ ⵜⴶⵎⵢ ⴹⵗ ⵀⵍⵜⵙ ⴹⵙⴶⵓ ⵜⵏⴼⵙ⵿ⵜ ⵜⴰ ⵗⵔⵙ ⵜⵍⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵓⴾ ⵜⵔⴰ ⵜⴶⵎ ⴹⵓⵏⴾⵙⵗ ⵎⵏⴾⵍ ⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ⵏ⵿ⵜⴰ ⵀⵍⵜⵙ ⵙⵏ ⵙ ⵛⴹⵜ ⵏⵎⵏ⵿ⵤⵗ ⵏ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵏ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ⵎⵛⵏ ⴶⵏ⵿ⴹⵓ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹⵗ ⵜⵎⵜⵢ ⴹ ⵜⴹⴶⵤ ⵀⵍⵜⵙ ⵢⴹⵙⴹⴾⵙ ⵀⵔⵗⵀⵙ ⵓⵔⴶⵗ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ⵍⵙ ⵀⵍⵜⵙ ⵓⵍ ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⵎⵙ ⵜⵔⵎ ⴹ ⵜⴶⴰ ⵢⵍⵙ ⵓⵙ ⵜⴶⵏⵎ ⴹⴰ ⵎⵏⴾⵍ ⵏ ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ⵍⵙⵏ ⴹⴾⵍ ⵏⵎⵙⵍⵏⵙⵏ ⴹ ⴶⵏⵏ «ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵎⴼⵍ ⵤⴰ⵰ ⵎⴰ ⵗⵛⴹ⵰» ⵎⵛⵏ ⵙⵂⴾⵏ ⵓⵍⵏ ⵎⵙⵍⵏⵙⵏ ⴹ ⴶⵏⵏ «ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ⵙⴼ ⵀⵍⵜⵙ ⵍⴾⵎ ⵢⵓⴰ ⵜⵔⴰ ⵜⵎⵜⵢ⵰ ⴾⵙⵙⵏ⵿ⴹⵓ ⵀⵔⵗⵀⵙ ⴹⵗ ⴾⵙⵓ ⵗⵢⵙⴰ ⵎⵔⵏ ⵙⵙⴶⵙ ⵜⵏⵗⵢ ⵍⵀⵙⵜ ⵙⵍⴾⴹ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵈⴾⵎⵙ ⵜⵓⵜⵢⵜⵢ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ⵓⵢⵏ ⵙⵌⵜⵏ ⵗⵢⵙⴰ ⵙⵎⵙ ⵏⵗⵔⵗⵔ ⵏⵗⵍⴰ ⵏⵂⵏ ⵓⵏ ⵛⵔⵗⴰ⵰ ⵗⵔⵏ⵿ⴹⵓ ⵙⵌⵜⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ⵙⵍⵙⵏ⵿ⵜⵓ ⵀⵔⵏⵤ ⵤⴶⵗⵏ ⵓⴰ ⵍⵙⵏ ⵎⵏⴾⵍⵏ ⵙⵓⵔⵏⵙ ⴹⵗ ⵍⵎⵜ ⵏ ⵜⴾⵀⵜ ⵤⵏ ⵜⵏ ⵎⵏⴾⵍⵏ ⵜⴶⵜ ⴹⵗ ⵛⵏⵏⵏ⵰ ⵎⵙ ⵓⵏ ⴶⵢ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ⵜⵙⵙⵍⵎⵏ ⴶⵏⵏⵙ «ⵢⴾ ⵎⵏⴾⵍ ⵏ ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ⴹ ⴶⵜⵏ ⵗⴼⵏⵜ ⵙⴶⵀⵍ ⵏ⵿ⵜⵍⵏ⵿ⵜ ⵙⵜⴼⵏ ⴼⵍⵙ ⵜⴶⵔⴼⵏ ⵙⵌⴹⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ⵙ ⴹⵗⵙ ⵗⵔⴹⵏ ⴶⵢ ⵏ ⵜⵎⴾⴾⵢⵜ ⵜⵔ⵿ⵜⵢⵜ ⴹⵜⵙⵙⵍⴾⴰ ⴾⵙⵏ ⴼⵍⵙ ⵀⵔⵏⵤ ⵤⴶⵗⵏ ⵓⴰ ⵜⵙⵍⵙⵏ ⵙⵗⵍⵏ⵿ⵜⵓ ⵙⵍⵙⴰ ⵓⵏ⵿ⴹⵏⵜ ⴶⵍⵏ ⴹⵔⵙ ⴶⵎⴹⵏ ⴹⵔⵙ ⵗⵔⵎ ⵢⴹ ⵜⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ⵎⵏⵢⵏ ⵙⵌⵜⵏ ⴹ ⵙⵎⵗⵏ ⵓⵏ ⵗⵔⵎ ⵏ ⵆⵔⵓⵏ ⵓⴰ ⵔⵓⵏ ⵍⵙⴾⵏ⵿ⴹⵔ ⴹ ⵔⴼⵙ ⴼⵍⴹⵓ ⵛⵓⴶⵙ⵰ ⵛⵂⵛⵍⵏ⵿ⵜⵓ ⴶⵢ ⵏ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵤⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ⵓⵢⵏ ⵗⵢⵙⴰ ⵙⴹⴶ ⵙ ⵜⵓⵏⵓ ⴶⵍⴶⵜⴰ ⵍⵎⵗⵏⴰ ⵏⵓⵏ «ⴹⴶ ⵓⵏ ⵜⴾⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ⴾⴼⵏ⵿ⵜⵓ ⵙⵎⴹ ⵏⵤⵀⵀ ⵔ⵿ⵜⵢⵏ ⴹⵎⴶⵍ ⵎⵙⵏ ⵤⵏⴼ ⵏ⵿ⵜⵗⵍⵀⵙ⵿ⵜ ⴼⵏⵤⵏ ⵜⵍⵓⵢⵜ ⵎⵛⵏ ⴶⵢ ⵗⵢⵙⴰ ⵙ ⵜⵙⵢⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ⵜⵤⵔ ⵜⵢⵜⵢⵏ⵿ⵜⵓ ⵙⵌⵜⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⵤⵏⵏ ⵙⵍⵙⵏⵜ ⵙ ⵜⵛⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ⴹⴶⵍⵛⵜ ⵙ ⵜⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ⵜⵢⵜⵢⵏ ⴹⵏⴶⵙ ⵙⵍⵎ ⴼⵍ ⴾⵜⵀ ⴹⵍⵍ ⵓⴰ ⵙⵔⵙ ⴹⵓⵢⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵙⵍⵎ ⵏ ⴾⵜⵀ ⴼⵍⵙ ⵙ «ⵓⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ⵌⵢⵜ ⵗⵢⵙⴰ ⴹⵛⵏ ⵌⵌⵀ ⵏⵀⵢⴹⴶⵏ ⵜⵓⵜⵢⵜⵢ⵰ ⵢⵏ ⵜⵓⵜⵢⵜⵢ ⴹⵗ ⵗⵍ ⵏ ⵗⵢⵙⴰ ⵓⴰ ⵂⴹⵏ ⵜⵓⵜⵢⵜⵢ ⴹⵗ ⵤⵍⴶⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ⵎⴾⵏ ⴹⴰ ⵙ ⵜⵏ⵿ⴹⴰ ⵀⵜⵓ ⵜⴰ ⵜⵏⵜ ⴹⵗ ⵍⴾⵜⵀⵏ «ⴹ ⴹⵏ ⴹⵗ ⵎⴶⵏ ⵏ ⵜⴾⵎⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ⴹⵙ⵿ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵜⴾⵢⵏⵏ ⴹⵏ ⵔⴾ ⵀⵜⵜⵏ ⵙⵓⵍⵓⵍⵏ ⵗⴼⵓⵏⵙⵏ ⴶⵏⵏⵙ «ⴹⵓ⵰ ⴾⵢ ⵓⴰ ⵏⵏ ⴹ ⵜⵌⵀⵔⵌⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵍⵙⵆⵓ ⴾⵔⵙ ⴹⵗ ⴾⵔⴹ ⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ⵎⵔⴹⴰ ⵙⴼⵙⵓ ⵎⵏⴾ ⵜⵤⵀⵗⴹⵓ ⵜⴶⵜⵓⵜ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ⵎⴾⵏ ⴹⵗ ⵙ ⵎⵤⵔⵏ ⵏ ⵍⵎⵎⵏ ⴹ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴰ ⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵏ⵿ⵜⴰ ⵓⴰ ⵙⴼⵙⵏ ⵢⵜⴹⵏ ⵓⵔ ⴼⵔⴶ ⵙⴼⵙⵢ ⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ⴾⴹ ⵏ⵿ⵜⴰ ⵍⵎⵙⵈ ⵎⵙ ⵓⵏ ⵎⵏⴾⵍ ⵏⵙⵔⵢⵍ ⵤⵀⵜⵜⴹⵓ ⵜⴶⵜⵓⵜ ⵎⵔⴹⴰ ⴹ ⵏⵏⵢ ⴹⵢ ⵏⵤⴶⵤⵏ ⵙⵔⵙ⵰» ⵎⴹⵏ ⵓⵏ ⴹⵔ ⵌⵢⵜ ⵗⵢⵙⴰ ⵜⵓⵜⵢⵜⵢ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵂⵏ ⵛⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ⵙ ⴶⴰ ⵎⵙⵏⵤⵍ ⵍⵙⵏⵜ ⵛⵢⵢ ⴾⵍ ⴾⵜⵏⵜ ⵂⵔ ⵜⴶⴰ ⵜⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ⵙ ⵜⴶⴰ ⵜⵤⵔ ⴹⴾⵍ ⵗⵢⵙⴰ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵍⵢ ⵍⵢ ⵍⵎⴰ ⵙⵀⵈⵜⵏⵢ⵰» ⵍⵎⵗⵏⴰ ⵏⴹⵢ «ⵢⴰ ⵎⵍⵏ ⵢⴰ ⵎⵍⵏⵏ ⵎⴼⵍ ⵜⵢⵗⵢ ⴹ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ⵙⵍⵏⵙ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵀⴹⴹⵏⵏ ⴹⵏ ⴹ ⴶⵏⵏ «ⵙⵙⵎⵜ⵰ ⵗⵔⵓ ⵏⵀⵢ ⵍⵢⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ⵤⵍⵏ ⵙⵔⵙ ⵓⴹⵏ ⵢⵏ ⵙⵍⵎⵗⴹⵓ ⵜⴹⴼ⵿ⵜ ⴹⵗ ⵀⵏⴶⵔ ⵜⵍ⵿ⵜⵜ ⴹⵎⵢ ⵏⴶⵀⵍ ⵤⵍⵙ⵿ⵜⵜⵏ ⵢⵜⵜⵛⵓ ⴶⵏⵓ «ⵙⵍⵏⵜ ⴹ ⵏⵙⵏ ⵜⴹⵙⵓ ⵏⵀⵢ ⵍⵢⵙ ⴾⵙ⵿ⵜⴹⵓ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜ» ");
INSERT INTO ttqt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹ ⴾⵙ ⵗⵢⵙⴰ ⵎⵙⵍⵢ ⵙⵂⵏ ⵎⵔⵏ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ⵙⵗⵜ ⵜⵏ ⴹⴰ ⴹ ⵤⵔⵜ ⴼⵔ ⵓⴰ ⵤⵓⵔⵏ ⵎⵙⵏ ⵏⵗⵔ ⴶⵔ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⵓⴰ ⴶⵔⵏ ⵜⵤⴹⴾ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⵙⵔⵜⴹⵓ ⵏⵗⵔ ⵓⵏ ⵗⵔ ⴼⵍⴰ ⵂⵔ ⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ⵙ ⵏⵢ ⴾⵀⵜⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⵀⴹⴹⵏ ⴹⵏ ⵎⴾ ⵓⵙ ⴶⵎⴹⵏ ⵎⵏ ⵗⵢⵙⴰ ⵏⴰ «ⵍⴾⵏ ⵙ ⵍⵙ ⵓⴰ ⵀⵔⵔ ⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ⵀⴹⴹⵏⵜ ⴹⵗ ⵜⴹⴹⵏ ⵛⵢⴹ ⵙⴹⵢ ⵙⵓⴹⵏⵜ ⴹⵗ ⵓⴰ ⴶⵏ ⴹⵏ⵰ ⵛⴹⴹⵏⵏ ⵜⵂⵏⵜ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹ ⵎⵔⵢⵎⴰ ⵜⴰ ⵜⵔⵓⵜ ⵢⵆⵀ ⵓⴰ ⵏ⵿ⴹⵔⵏ ⴹ ⵢⵙⵙ ⴹⵢⵜ ⵜⴶⵜ ⵙⵎ ⵙⵍⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ⵂⵔⵓⴰ ⵂⴰ ⵗⵢⵙⴰ ⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⵙ ⴹⵙⵍⴾⵎⵏⵜ ⴹⵂⵍⵏⵜⵓ ⵙⵓⴰ ⴼⵔⴶⵏⵜ⵰ ⵀⴹⴹⵏⵜ ⴹⵗ ⵜⴹⴹⵏ ⵛⵢⴹ ⴹⵏ ⴶⵜⵏⵏ ⴹⴹⵓⵏⵏ ⴹ ⵗⵢⵙⴰ ⵙ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ⵙ ⵜⴾⵢ ⵜⴾⵙ⵿ⵜ ⵏⵤⵍ ⵓⵏ ⵍⴶⵎⵜ ⵙⵎⵜⴶⵏ ⵢⵜⴹⵏ ⵢⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ⴾⴰ ⵢⵙⴼ ⵓⵏ ⵗⵔⵎ ⵏⵔⵎⵜⵢ ⵂⵏ ⵏ ⵀⵍⵜⵙ⵰ ⵢⵙⴼ ⵍⵙ ⵎⵙ ⵜⵓⵙⵗⵎⵔⵏ ⵂⵏ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵎⵙ ⴹⵗ ⵓⴹⵏ ⴶⵏ ⵜⵎⴰ ⴹⵗ ⵙⴰ ⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵏ⵿ⵜⴰ ⴶⵏ ⵎⵤⵍ ⵏ ⵜⵂⵍⵜ ⵎⵙⵏ ⵙ ⴾⴰ ⵀⵍⵜⵙ ⴶⵎⵢ ⴹⵗⵙ ⵜⵗⵙⴰ ⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ⵙⵎⴾⵍⵍ ⵙ ⵀⵍⵜⵙ ⵜⵔⵀ ⵏⴶⵎⴹ ⵓⴰ ⴶⵏ ⵎⵏ ⵗⵢⵙⴰ⵰ ⵙⵙⵗⵔⴹⵓ ⴾⵀⵜⵏ ⵓⵏⴹ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⴾⴹ ⵜⴹⴰ ⵀⴰ ⵏ ⵗⵢⵙⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ⵙ ⴹⵙⴶⴰ ⴾⵀⵜⵏ ⵓⴰ ⵙⵍⵏ ⵏⵀⴰ ⵏ ⵗⵢⵙⴰ ⴾⴼⴰ ⵀⵍⵜⵙ ⵢⵙⴼ ⵜⵔⴶⵜ ⵏⴹ ⴹⴾⵍ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ⵤⵏ⵿ⵤⴹⵓ ⵢⵙⴼ ⵛⴼⵜ ⵜⴰ ⵜⵂⵙⵢⵜ ⴾⵙⴹⵓ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⴶⵢ ⴹⵗⵙ ⵜⵤⵔ ⴶⵢ ⴹⵗ ⵤⴾⴰ ⵎⵙⵏ ⴾⵤⵎ ⵙⵗⵔⵔⴹⵓ ⵜⵂⵏ⵿ⵜ ⵤⵓⵔⵜ ⵂⵔ ⵙⵔⵙ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ⵜⵍⴰ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹⵏ ⴹ ⵎⵔⵢⵎⴰ ⵜⴰ ⵜⵔⵓⵜ ⵢⵙⵙ ⵙⵓⴹⵏⵜ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵜⵓⴶⴰ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ⵙ ⴾⵢ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵜⵏ⵿ⴾⵔ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹ ⵎⵔⵢⵎⴰ ⵜⴰ ⵜⵔⵓⵜ ⵢⵆⵀ ⴹ ⵙⵍⵎⴰ ⵤⵏ⵿ⵤⵏⵜⴹⵓ ⴹⵜⵏ ⵤⴹⵏⵏ ⵢⵜⵏⵙⵍⵍⵏⵜ ⵜⵗⵙⴰ ⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ⴶⵍⵏⵜ ⵗⵔⴰ ⵗⵔ ⴶⵎⴹ ⵏ ⵜⴼⴾ ⵤⵍ ⵓⵏ ⵍⵈⴹ ⴾⵏⵜ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ⴶⵍⵏⵜ ⵜⵏⵎⵏⵏⵜ ⴶⵔⵙⵏⵜ «ⵏⴾⵏⵜⵢ ⴹⴰ ⵎⴰ ⴹⵏⵤⵙⵗⵔⵔⴹⵏ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⵂⵔⵜ ⵤⴾⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ⴹⴾⵍⵏⵜ ⵙⵓⴹⵏⵙⵏⵜ ⵏⵢⵏⵜ ⵙ ⵜⵂⵏ⵿ⵜ ⵜⵏⴹ ⵜⵜⵓⵙⵗⵔⵔⴹ ⵙⴹⵢ⵰ ⵜⵂⵏ⵿ⵜ ⵜⵏ ⴹⴰ ⵤⴰ ⵜⴾⵏⴰ ⵜⵤⵓⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ⴶⵤⵏⵜ ⵤⴾⴰ ⵏⵢⵏⵜ ⴹⵗⵙ ⵍⵙ ⵏⵎⵓⴹ ⵏⵙⵎⵍⵍ ⵆⵎ ⴹⵗ ⵗⵍⵏⵙⵏⵜ ⵔⵎⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ⵏⵙⵏⵜ «ⴹ ⵓⵔ ⵜⵔⵎⵗⵎⵜ⵰ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵓⴰ ⵜⵓⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⵙ ⵜⵙⴶⴹⵎⵜ⵰ ⵓⵔ ⵍⴰ ⴹⴰ⵰ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵏⴾⵎⵜ ⴹⴶ ⵓⵙ ⴾⵍⴰ ⴹⵗⵙ ⵜⵏ⵿ⵙⴰ ⵜⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ⵎⵔⴹⴰ ⴶⵍⵎⵜ ⵜⵎⵍⵎⵜ ⵢ ⵏⵜⵍⵀⵏⵜ ⵂⵔⴾⴹ ⵀⵜⵔⵙ ⵙ ⴹⵙⵏⵏⵤⵔ ⵙⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ⴹⵏ ⴹⴰ ⵜⵤⵜⵏⵢⵎ ⵙⵎⴾ ⵓⵙ ⴹⵓⵏ⵿ⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ⵜⵤⵔ ⴶⵎⴹⵏⵜⴹⵓ ⵤⴾⴰ ⵤⵍⵏⵜ ⵜⴶⴰ ⴹⵗⵙⵏⵜ ⵜⵢⵙⵙ⵿ⵜ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏⵜ ⵓⴰ ⴶⵏ ⴹⵏ⵰ ⵓⴰ ⴶⵏⵜ ⴹⵗ ⵜⵔⵎⵆ ⵓⵔ ⵜⵍⴰ ⵢ ⵙⵏⵏⵜ ⵔⵜ ⴹⵗ ⵜⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ⵗⵔⴰ ⵏⵤⵍ ⵓⵏ ⵍⵈⴹ ⴹⵏ⵿ⴾⵔ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴶⴰ ⵏⴼⵍⵍⵏⵜ ⵓⴰ ⵤⵔⵏ ⵢ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⵜⵙ ⴾⵍⴰ ⴹⵗⵙ ⴾⵙ ⵙⴰ ⴾⵍⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ⵜⴶⵍⴰ ⵜⴶⴰ ⵙⵍⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⴾⵍⴰ ⵜⴹⵓⵏ ⴹ ⵗⵢⵙⴰ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵛⴹⵏ ⵎⵏⵙⵏ ⵂⵍⵏ ⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ⵎⵛⵏ ⵙ ⵙⵍⵏ ⵙ ⴹⵔ ⵜⵏⵢⵜⵓ ⴶⵢⵏ ⵙⴹ ⵤⴶⵤⵏⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ⴹⴼⵔ ⵓⵏ ⵏⴼⵍⵍ ⵗⵢⵙⴰ ⵙ ⵜⵎⵓⵜ ⵢⵜ ⵢⵛⵏ ⴹⵗ ⵏⵍⴾⵎⵏⵜ ⵌⵓⵏ⵿ⴾⵜⵏⵏ ⴹⵗ ⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ⵜⵤⵔ ⵆⵍⵏ ⵢⵔⵙⵍⵎ ⵎⵍⵏ ⵓⵏ ⵢ ⵏⵍⴾⵎⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵎⵛⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵓⵔ ⴹⵙⵏⵜⵓⵤⴶⵤⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ⴹⴼⵔ ⵓⵏ ⵏⴼⵍⵍⴹⵓ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ ⴹⵗ ⵎⵤⵢ ⴹⵗ ⵜⵜⵏ⵰ ⵙⵗⵍ⵿ⵜⵏ ⵜⴶⵏⴰ ⵏⵀⴰ ⵏⵤⴶⵤⵏⵙⵏ ⴹ ⵜⴶⵔⵎⵎ⵿ⵜ ⵏ ⵓⵍⵏⵙⵏ ⴼⵍⵙ ⵓⵔ ⵤⴶⵤⵏⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵢⵏⵏ ⴹⴼⵔ ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ⵏⵙⵏ «ⴶⵍⵓⵜ ⵜⵍⵍⵎ ⴹⵏⵜ ⴾⵜⵏⵜ ⵜⵎⵍⵎ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵢⴹ ⵜⵍⴰ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ⵢ ⵤⴶⵤⵏⵏ ⵜⵓⵙⵍⵎⵗ ⴹⵗ ⴹⵗ ⵎⵏ ⵙⵙⵎⵏ ⴹ ⴶⵔⵓ ⴼⵙⵏ⵰ ⵎⵔⵏ ⵓⴰ ⴶⵢⵏ ⵙⵤⴶⵤⵏ ⴹ ⵜⵓⵔ ⵜⴹⵀ ⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ ⵍⵗⵍⵎⵜⵏ ⵛⵏ ⵤⴰ ⵜⵓⵏⵢⵏⵏ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⴹ ⴾⵙⵏ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵙ ⵜⵔⵏⴰ ⵏⵙⵎⵏ ⵛⵓⵍⵏ ⵓⵍⵏ ⵏ ⵜⵓⵛⵜⵏ ⵓⵔ ⵤⴹⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ⵎⵔⵏ ⴾⴹ ⴹⴾⵍⵏ ⵜⵛⵍⵏ ⵙ ⴼⵙⵏⵙⵏ ⵓⵍⴰ ⵛⵓⵏ ⵙⵏ⵿ⵙⴶ ⴹⴰ ⵓⵔ ⴹⵙⵏ⵿ⵤⵗⵛⴹ ⴹⵢ ⵓⵍⴰ⵰ ⵙ ⵙⵓⵔⵏ ⴼⵙⵏⵙⵏ ⵎⵔⵏⵏ ⴹ ⵤⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ⴶⵙⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⵀⵜⵓ ⵜⵏ ⵗⵙ ⵎⴹⴾⵍ ⵙ ⵌⵏⵓⵏ ⵆⵎ ⴹⵗ ⵗⵍ ⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⴶⵍⵏ ⴹ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⴹⴶ ⴾⵍ⵰ ⵍⵍⵙⵏ ⵎⵍⵢ ⵙⵛⵗⵍ ⵓⵏ ⵙⵜⴹⵓ ⵓⴰ ⴶⵏⵏ ⵙⵍⵗⵍⵎⵜⵏ ⵎⵙⵏⵏ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵜⴶⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","ⵢⴰ ⵜⵢⴼⵍ ⵓⴰ ⴾⵏⵗ ⵙⵗⵎⵔ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴾⵜⵀⵏⵏ ⵙⵍⵏ ⵏⵓⴰ ⵗⵔⵏⵗ ⴶⵏ ⵙⵎⴾ ⵎⵏⵜ ⵓⵙ ⴹⵏⵜⵏⵙⵗⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⴶⵢⵜⵏⵏ ⵙ ⵛⵜⵓⵏⵙⵏ ⵂⵔⵓⴰ ⵗⵔ ⵏⵜⵏⵙⵏ ⵆⵍⵏ ⵢⵜⴹⵏ ⵛⵗⵍⵏⵏ ⴹⵗ ⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⵓⵏ ⴹⴰ ⴼⵍ ⴹⴹⴶⵤ ⵏⴾ ⴹⴰ ⴹⴼⵔ ⵙ ⵛⴶⵔⵗ ⵙⵍⵏ ⴹⵢ ⴾⵍ ⵙⵍⵗ ⴹⵀⵤⵏ ⵗⵔ ⵍⵙⵍⵏⵙⵏ ⴹⴾⵏⴶⴰ ⵢⵙⵏ ⴾⵜⵀ ⵏⵤⵎⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ⴼⵍ ⴹ ⵜⴾⵙⵗ ⵛⴾ ⵙ ⵜⵙⵏⵏ ⵛⵏ ⵜⵜⵓⵙⵙⵗⵔⴰ ⵜⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ⵍⵏ ⵓⵏ ⴹⵗ ⵎⵙ ⵂⵔⴹ ⵎⵏⴾⵍ ⵏⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵍⵢ ⵍⵎⵎ ⵢⵏ ⴶⵏ ⵙⵎ ⵤⴾⵔⵢⴰ ⵂⵏ ⵜⴶⵢⵜ ⵏⵍⵎⵎⵏ ⵓⵏ ⵂⵢⵓⵏ ⵏⵀⵢⴰ⵰ ⵜⵏ⵿ⵜⵜⵏⵜ ⵜⵂⵢⵓⵜ ⵏⵂⵔⵏ ⵙⵎⵏⵜ ⵍⵤⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ⵏ⵿ⵜⴰ ⴹⵔⵙ ⵎⵙⵏ ⵍⵗⴹⵍⵏ ⴹⵜ ⵎⵛⵏⴰ ⴶⵏ ⵢⵍⵓⵌⵀⵏ ⵏⵎⵍⵢ ⴹⵍⵎⵔⵏⵜ ⵍⴾⵎ ⴹⵗ ⵓⵔ ⵍⵏ ⵍⵂⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ⵓⵔ ⵍⵏ ⵀⵔⵔ ⵓⵍⵢⵏ ⴼⵍⵙ ⵍⵤⵀⵜ ⵓⵔ ⵏⵜⵍⵓ ⵀⵔⵔⵏ ⴶⵎⴹⵏ⵿ⵜⵏ ⴹⵗ ⵍⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ⵤⵍ ⵢⵏ ⵜⴶⵓ ⵤⴾⵔⵢⴰ ⴹⵜ ⵎⵛⵏⴰ ⵛⵗⵍ ⵓⴰ ⵜⴶⵏ ⵍⵎⵎⵏ ⴼⵍⵙ ⵜⴶⵢⵜ ⵏⵍⵎⵎⵏ ⵜⴰ ⵂⴰ ⵙ ⴹⵙⵗⵍⵢ ⴶⵢ ⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ⵀⵤⵏⵜⵓ ⵜⵛⵗⵔⵏ ⵎⵙⵏⵏ ⵙ ⵏ⵿ⵜⴰ ⵤⴶⵤⵏ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵎⵍⵢ ⵙⵆⴹ ⴹⵗⵙ ⴹⵜⵏ ⴼⵍ ⵎⵌⵎⵔ ⵓⴰ ⵙⴾⵜⵏ ⵢⵓⵏ⵰ ⵛⵛⵗⵔⵏ ⵛⵏ ⵎⵙ ⴶⵏⵙⵏⵜ ⵍⵗⴹⵜ ⵏⵍⵎⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ⵙ ⴶⴰ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵜⵆⴹⵏ ⴹⵜⵏ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵀⴹⴹ ⴹⵗ ⵜⴼⵔⵢ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ⵓⵍⴰ ⵂⴶⵏ ⵏⴼⵍⵍⵙⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵀⴹⴹ ⴹⵗ ⵗⵍ ⵏⵎⵌⵎⵔ ⵓⵏ ⵙⵆⴹ ⵏⴹⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ⵏⵢ ⵤⴾⵔⵢⴰ ⵏ⵿ⴶⵍⵙ ⵗⵙ ⵔⵎⵗ ⵜⴶⵤⵜⵓ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ⵎⵛⵏ ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⵤⴾⵔⵢⴰ⵰ ⴾⵢ ⵓⵔ ⵜⴶⵤ ⵜⵙⴰ ⴼⵍⵙ ⵎⵛⵏⴰ ⵆⵀⵍ ⵎⵏ⵿ⵙⵢⵏⴾ ⵜⵏ⵿ⵜⵜⵏⴾ ⵍⵤⵀⵜ ⴹ ⵜⴶⵔⵓ ⵀⵔⵔ ⵎⵔⵏ ⴶⵙ ⵙⵎ ⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ⴹ ⵜⴹⵓⵗ ⵜⴼⵍⵓⵙⵗ⵰ ⵜⵙⴹⵓⵜ ⴹⵗ ⵜⵂⵓⵜⵏⵜ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ⵎⵔⵏ ⴹ ⵆⵍ ⵓⴹⵏ ⵤⵓⵔⵏ ⴹⵜ ⵎⵍⵢ⵰ ⵓⵔ ⵎⴹ ⵙ ⵤⵛⵓ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵓⵍⴰ ⴹⵗ ⵙⵎⴹ ⵓⵍⵢⵏ⵰ ⴹ ⵜⴹⵏⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵂⵔⵓⴰ ⴹⴰ ⵂⴰ ⵜⴹⵙ⵿ⵜ ⵏⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ⴹ ⴹⵙⵗⵍ ⴾⵍⵙⵔⵢⵍ ⴶⵜⵏⵏ ⵎⵍⵏⵙⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ⵏ⵿ⵜⴰ ⴹⵤⵤⵔⵏ ⵢⵎⵍⵢ ⵎⵙ ⵏⵎⵤⵍⵏⵜ ⴶⵔⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵔⵏⴰ ⵛⵍⵜ ⵏⵓⵏ ⴶⵔⵓ ⵏⵀⵢ ⵍⵢⵙ ⴼⵍ ⴹⵓⵢ ⵍⵈⵔ ⴶⵔ ⵢⵜⴹⵏ ⴹⵀⵔⵔⵏⵙⵏ ⵓⵢⴹⵓ ⵏⵎⵤⵔⵢ ⵙⴹ ⵍⵏ ⵜⵢⵜⵢ ⵜⴰ ⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵍⵏⵏ⵰ ⵜⵎⵓⵜ ⵜⴹⵢ ⵙ ⵤⵙⵎⵜⴶ ⵢⵎⵍⵢ ⵜⵎⵜⵢ ⵜⵙⵎⵜⴶⵜ ⵢ ⵍⴾⵎ ⵢⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ⵜⵤⵔ ⵏⴰ ⵤⴾⵔⵢⴰ ⵢⵏ⵿ⴶⵍⵙ «ⵎⵏⵢ ⵍⵗⵍⵎⵜ ⵜⴰ ⴹⵤⵜⵙⵙⵏⵜ ⵙ ⴹⵢ ⴹ ⴶⵓ⵰ ⵏ⵿ⵜⴰ ⵏⴾ ⵗⵎⵔ ⵓⵛⵔⵏ ⵎⵙⴰ ⵜⵏ⵿ⵜⵜⵏ ⴹⵗ ⴶⵍⵏ ⴹⵗⵙ ⵍⵏ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⵓⴰ ⵏⴾ ⵌⵀⵔⵍ ⴾⵍⵢ ⵏⵎⵛⵏⴰ ⵓⴰ ⴹⵜⵙ ⵀⴹⴹⵏ⵰ ⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵙⵔⴾ ⵢⴹⴾⴶⵗ ⵙⵍⵏ ⵂⵙⵢⵏⵏ ⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⵓⵔ ⵜⵤⴶⵤⵏⵗ ⵙⵍⵏ ⵓⵏ ⴹⴾⴶⵗ ⴹⴰ ⵙ ⵤⵏ⵿ⴹⵏⵏ ⴹⵗ ⵍⵓⵆⵏⵙⵏ ⴹ ⵎⴹⴹ ⵎⵏⴾ⵰ ⵓⵔ ⵤⴰ ⵜⵍⵙⵗ ⵓⵍ ⴾⵜ ⵓⵔ ⴹⵙⴰ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⴶⵓ ⵔⵜ ⵓⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ⵓⵏ ⵙ ⵜⴶⵓ ⵜⵎⵜⵢ ⵜⵆⵍ ⵢ ⵤⴾⵔⵢⴰ ⵆⵏⵏ ⵗⴼⵓⵏⵙⵏ ⵢⵓⴰ ⵜⵏⵙⵂⴶⵏ ⴹⵗ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ⵙ ⵜⴹⴶⵎⴹ ⵏ⵿ⴹⵔⵙ ⴹⵙⵏⵛⵓⵍ ⴼⵍⵙ ⵎⵏⵜ ⵎⴹⴹⵏ ⴹⵙⵏⵙⴹⴶⵏ⵰ ⵙⵏⵏ ⵙ ⵔⵜ ⵢⵏ ⴹⵙⴹⵏⴼⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ⵙ ⵙⵏ⵿ⴹⴰ ⴹⵏⵜ ⵓⵏ ⵛⵗⵍ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵆⵍ ⵗⵢⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ⴹⴼⵔ ⵓⵏ ⵜⴶⴰ ⵜⵏ⵿ⵜⵜⵏⵜ ⵍⵤⵀⵜ ⵜⴹⵙ⵿ⵜ ⵜⵤⵔ ⵜⴶⴹⵍ ⵢ ⵎⵏⵜ ⵜⵓⵏⵢ ⵂⵔ ⵜⴶⴰ ⵙⵎⵙⵜ ⵜⵍⵍ ⵜⴶⵏⵓ ");
INSERT INTO ttqt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«ⵓⴰ ⴶⵢ ⵏⵎⵍⵢ⵰ ⵏ⵿ⵜⴰ ⴹⵗⵢ ⵙⵏⵏ ⴾⵙⵢ ⵙⴾⵔ ⵓⴰ ⴹⴶⵜⵏ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ⵜⵂⴰ ⵍⵤⵀⵜ ⵜⵍⵜⵏⵜ ⵜⵏ ⵙⴹⵙⵜ ⵙ ⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵏ⵿ⴶⵍⵙ ⵌⵀⵔⵍ ⵙⵗⵔⵎ ⵙ ⵜⵓⵏⵓ ⵏⵤⵔⵜ ⵂⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ⵙⴾⵢ ⵜⵎⵓⵜ ⵢⵜ ⵓⵔ ⵏⵤⴹⵢ ⵎⴹⵏ ⵂⵔⵓⴹⴰ ⵜⴶⵜ ⵙⵎ ⵎⵔⵢⵎⴰ⵰ ⵎⵔⵏ ⵎⵔⵢⵎⴰ ⵜⵙⵎⵔⴾⵙ ⴹⵍⵙ ⴶⵏ ⵙⵎ ⵢⵙⴼ ⵎⵙⵏ ⵔⵜ ⴹⵗ ⵤⵔⵢⴰ ⵏⵎⵏⴾⵍ ⴹⵓⴹ ⵓⵏ ⵏⵀⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ⵙⵜⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵙ «ⵎⵔⵢⵎⴰ ⵎⴰ ⵜⵈⵍⴾⴰ⵰ ⵎⵍⵢ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵎ ⵔⵈⵎⵜⵏⵜ⵰ ⵙⵏ ⴹⵗⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ⵆⵏ ⵓⵍ ⵓⵏ ⵗⴼ ⵏⵎⵔⵢⵎⴰ ⴹⴶⵤⵜⵜ ⵜⵤⵔ ⴹ ⵜⵙⵎⴹⵔⵏ ⵓⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵙⵍⵎ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⴰ ⴾⵎⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ ⵎⵔⵢⵎⴰ ⵎⵛⵏⴰ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵎ ⵔⵈⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ⴹ ⵜⴶⴰ ⵜⴹⵙ⵿ⵜ ⵜⴶⵔⵓⴰ ⵀⵔⵔ ⵜⴶⵗⵙ ⵙⵎ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ⴹ ⵜⵓⵙⵗⵎⵔ ⴶⵓ ⵙⵎ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ⵰ ⴹ ⵜⴾⴼⵓ ⵎⵍⵢ ⵎⵛⵏⴰ ⵜⵗⵎⵔ ⵏⵎⵔⵓⵏⵜ ⴹⵓⴹ ");
INSERT INTO ttqt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ⵤⵔ ⵢ ⵂⵢⵓⵏ ⵏⵢⵆⵀ ⵂⵔ ⴼⵓ ⵎⵔⵏ ⵜⵎⵏⴾⵍⵏⵜ ⴹ ⵜⵗⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ⵜⵏⴰ ⵎⵔⵢⵎⴰ ⵢⵏ⵿ⴶⵍⵙ «ⵎⵏⵎⴾ ⵙ ⵤⴶⵓ ⴹⵢ ⵏ⵿ⵜⴰ ⵏⴾ ⵂⵔⵓⴹⴰ ⵓⵔ ⵤⴹⵢⴰ ⵎⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⴰ ⴼⵍⵎ ⴹⵤⵀⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵍⵙⵎ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⵜⵆⵍⵎ ⵤⵏ ⵜⵍⵢ ⵓⵏ ⴹⴰ ⴼⵍⵙ ⵀⵔⵔ ⵓⴰ ⵤⴰ ⵜⵍⵗ ⴹ ⴶⵓ ⵙⵎ ⵎⵤⴹⴶ ⴶⵓ ⴹⵗ ⵙⵎ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ⵏⵎ ⵜⵛⵆⵆⵏⵎ ⵍⵤⵀⵜ⵰ ⴶⵍⵏ ⴹⵗⵙ ⵍⵏ ⵓⵍⵏ ⵎⵛⵏ ⵜⴶⴰ ⵜⴹⵙ⵿ⵜ ⵏⵀⵔⵔ⵰ ⵏ⵿ⵜⴰ ⵜⵙ ⵜⵓⵏⵓ ⵓⵔ ⵜⵜⵍⵓ ⵀⵔⵔⵏ ⵜⵍⵜⵏⵜ ⵜⵏ ⵙⴹⵙⵜ ⵜⵂⴰ ⵎⵔⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ⴼⵍⵙ ⵓⵔ ⵜⵍⴰ ⵎⵙⵏ ⵎⵈⵍ ⴼⵍ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ⵜⵏⵙ ⵎⵔⵢⵎⴰ «ⵏⴾ ⵜⴾⵍⵜ ⵏⵎⵍⵢ ⵜⵓⴶⵜⵢ ⵓⴰ ⵜⵏⵗ⵰» ⵜⵤⵔ ⴼⵍ⵿ⵜⵜ ⵏ⵿ⴶⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ⵜⵏ⵿ⴾⵔ ⵎⵔⵢⵎⴰ ⴹⵗ ⴹⵏⵏ ⴹⴰ ⵜⵂⵤ ⵜⴾⴰ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ ⵏⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵎⵙⵏ ⴾⵍ ⵏⴹⵗⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ⵜⵙⵏ ⵂⵏ ⵏ⵿ⵤⴾⵔⵢⴰ ⵜⵙⵙⵍⵎ ⴼⵍ ⵍⵤⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ⴹⴰ ⴹⴰ ⵗⵙ ⴹ ⵜⵙⵍⴰ ⵍⵤⵀⵜ ⵢⵙⵍⵎ ⵏⵎⵔⵢⵎⴰ ⵏ⵿ⵜⴰ ⴹ ⵤⵀⴶⵜ ⵀⵔⵔ ⵓⴰ ⵂⵏ ⵜⴹⵙ⵿ⵜ ⵏⵍⵤⵀⵜ ⵜⵤⵔ ⴹⵏⵢⵜⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ⵜⴹⴾⵍ ⵍⵤⵀⵜ ⵎⵙⵍⵏⵜ ⵜⵏⴰ «ⵜⴶⵔⴰ ⵛⴹⴹⵏ ⴾⵍ ⴶⵔⵓ ⵏⵔⵈⵎⵜ ⵀⵔⵔ ⴹⵗ ⵓⴰ ⴹⵤⴶⵎⴹⵏ ⵜⴹⵙ⵿ⵜⵏⵎ ⴶⵔⵓ ⵔⵈⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ⵓⴾ ⵏⴾ ⵎⴰ ⵎⵙⴰ ⵙ ⴹⴹⵜⵜⵙⵓ ⵏⴰ ⵏⵎⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ⴹⴰ ⴹⴰ ⵗⵙ ⴹ ⵙⵍⵗ ⵢⵙⵍⵎⵏⵎ ⵏ⵿ⵜⴰ ⴹ ⵤⵀⴶⵜ ⵀⵔⵔ ⵓⴰ ⵂⵏ ⵜⴹⵙ⵿ⵜⵏ ⴼⵍ ⵜⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ⵜⵀⵍⵍⵗ ⴾⵎ ⵜⵤⴶⵤⵏⵜ ⵙ ⵓⴰ ⴹⵎⵏⴰ ⵎⵍⵢ ⴹ ⵏ⵿ⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ⵜⵏⴰ ⵎⵔⵢⵎⴰ «ⵓⵍⵏ ⵎⵍ ⴹⴾⵍ ⵏⵎⵍⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ⵎⵏⵏ ⵙⴹⵓⵜⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵗⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ⴼⵍⵙ ⵙⵓⴹ ⴹⵏⴶⴰ ⴹⵗ ⵜⵎⴹⵔⵢⵜ ⵏ⵿ⵜⴾⵍⵜⵏⵜ⵰ ⴰ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⴾⵍ ⴹ ⵏⵏ ⵀⵍⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ⴼⵍⵙ ⵓⴰ ⵍⵏ ⵜⵔⵏⴰ ⴶⵢ ⵔⵜⵏ ⵤⵓⵔⵏⵏ⵰ ⵙⵎⵏⵜ ⵢ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ⵜⵂⵏⵜⵜ ⵢⵢⵜⴹⵏ ⵏⵤⵎⵏ ⴾⵍ ⵓⵏ ⵜⴾⵙⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ⴶⴰ ⴼⵙⵏⵜ ⵎⵤⵍⵏ ⵏ⵿ⵜⵍⴰ ⵏ⵿ⵜⵔⵏⴰ⵰ ⵤⵓⵤⵓⵤ ⵢⵜⴹⵏ ⵓⵏ ⴹⴾⵍⵏⵏ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ⴾⵙ ⴹⵓ ⵎⵤⵔⵏ ⵜⵗⵎⵔⵏⵙⵏ ⴹⴾⵍ ⵛⵍⵆⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ⵙⵢⵓⵏ ⵓⵏ ⵍⵤⵏⵏ ⴹⵗ ⵓⴰ ⵤⴹⵏ ⵢⴰ ⵎⴶⵔⴶⵙ ⵆⵔⵏ ⴼⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ⴹⵂⵍ ⴾⵍⵙⵔⵢⵍ ⵏⴾⵍⵏⵜ ⴼⵍⵙ ⵜⵂⵏⵜⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ⵢⵀⵔⵂⵎ ⴹⵤⵔⵢⵏⵜ ⵂⵔ ⴼⵓ ⵎⵙ ⵓⵏ ⵔⴾⵓⵍ ⴶⴰ ⵢ ⵎⵔⵓⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ⵜⵎⵍ ⵎⵔⵢⵎⴰ ⵗⵔ ⵍⵤⵀⵜ ⵂⵔ ⵜⴶⴰ ⴹⴶ ⵏ⵿ⴾⵔⴹⵜ ⵜⵍⵍ ⵎⵔⵏ ⵜⵆⵍ ⵗⵢⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ⵙⴹⵓ ⵍⵓⵆ ⵏⴶⵤ ⵏⵎⵤⵔ ⴼⵍ ⵍⵤⵀⵜ ⵜⴶⵔⵓ ⵀⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ⵙⵍⵏ ⵎⵂⵔⴶⵏⵜ ⴹⵛⵆⵗⵏⵜ ⵂⵏⵜⴰ ⵤⵓⵔⵏ ⵓⴰ ⴹⵙⴶⴰ ⵎⵛⵏⴰ ⴹⴰ ⴹⵓⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ⵙ ⵤⵍ ⵓⵏ ⵜⵎ ⵙⵏ⵿ⴹⵓ ⵢⴹ ⵙⵎⵎⴾⴹⵏ ⵀⵔⵔ⵰ ⵔⵏ ⴹⵙⴶⵏ ⵙⵎ ⵤⴾⵔⵢⴰ ⵙⵎ ⵓⴰ ⴹⵗ ⴶⴰ ⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ⵎⵛⵏ ⵜⵏⵙⵏ ⵏⵏⵜ «ⴾⵍⴰ ⴾⵍⴰ⵰ ⴹ ⴶⵓ ⵙⵎ ⵢⵈⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ⵏⵏⵙ «ⵙⵎ ⵢⴰ ⵓⴹⵢ ⵓⵔ ⵜⵍⵗ ⵛⵆⵗ ⵜⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ⵜⵤⵔ ⴹ ⵙⴹⴶⵏⵏ ⵢⵀⴰ ⵏⵀⵔⵔ ⵢⴹⵙⵏⵎⵍ ⵙⵎ ⵓⵙ ⵔⴰ ⴹ ⵜⴶⵓ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ⵙⴹⴶⵏⵙⵏ ⵤⴾⵔⵢⴰ ⵜⴹⴾⴼⵏ ⵙⵍⵎ⵰ ⴾⵜⵀ ⴼⵍⵙ «ⵙⵎⵏⵜ ⵢⵈⵢⴰ⵰» ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ⵜⵤⵔ ⴾⵢ ⵎⴹⴹ ⵤⴾⵔⵢⴰ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⵎⵔⴰ ⵍⵙⵏⵜ ⴹ ⵜⴶⵓ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ⵜⴶⵤ ⵜⵙⴰ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⵂⵤⵏⵙⵏ ⵓⵤⵓⵤⵏ ⵙⵍⵏ ⵏⵓⴰ ⴶⵏ ⴹⵏ ⴹⵗ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴾⵜⵏⵜ ⵓⵏ ⴹⵗⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵓⵏ ⵜⴼⵏ⵿ⵜⵓ ⴹⵗ ⵓⵍⵏⵙⵏ ⴶⵏⵏ «ⵎⴰ ⵤⵆⵍ ⵓⴰ ⴹⴰ ⵀⵔⵔ⵰» ⵍⴾⵏ ⵙ ⵙⵓⵔ⵿ⵜⵓ ⵎⵍⵢ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ⴹⵏⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵤⴾⵔⵢⴰ ⵓⵏ ⵀⴰ ⵏⵀⵔⵔ ⵙⵏⴼⵍⵍⵙ ⵎⵛⵏⴰ ⵓⵍⵏⵜ ⴹ ⴶⵏⵓ ");
INSERT INTO ttqt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⵎⵍⵢ ⵏⵙⵔⵢⵍ ⴼⵍⵙ ⵎⵙⵏⵜ ⴶⴰ ⴹⵗ ⵜⵎⵜⵢⵏⵜ ⵙⴹⵔⴼ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ⴾⵙⵏⴹⵓ ⴹⵗ ⵂⵏ ⵏⴾⵍⵏⵜ ⴹⵓⴹ ⵎⵗⵍⵙ ⵍⵏ ⵜⵔⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","ⴹⵏⵤⴶⵤⵏ ⴹⵗ ⵤⵏ⵿ⴶⵏⵏⴰ ⴾⵙⵏⴰ ⴹⵗ ⴼⵙⵏ ⵏⵎⴾⵙⵏⵏⵏⴰ ⴾⵍ⵰ ⵎⵙ ⵓⵏ ⵔⴾⵓⵍ ⴶⴰ ⴹⵗ ⵎⵓⵏ ⵏⵏⵀⵜⵏⵜ ⵓⵏ ⵔⵓ ⵙⵏⴼⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ⵎⴾ ⵓⴹⵢ ⵙ ⵙⴾⵏⴰ ⵜⵂⵏⵏ⵿ⵜⵏⵜ ⵢ ⵎⵔⵓⵏⵏⴰ ⵙⵏ⵿ⴹⴰ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆⵏⵜ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ⵔⴾⵓⵍ ⵓⵏ ⵂⴹ ⴼⵍⵙ ⵢ ⵎⵔⵓⵏⵏⴰ ⵀⵔⵂⵎ ⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ⴹⵏⵗⵙⴼⵙⵓ ⴹⵗ ⵤⵏ⵿ⴶⵏⵏⴰ ⴼⵍ ⵜⵏⵗⵀⴹ ⵛⵢ ⵓⵍⴰ ⵜⵙⴰ ⵏⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ⵏⵤⴹⴶ ⵏⵗⴹ ⴾⵜ ⵏⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ⵎⵔⵏ ⴾⵢ ⵀⵔⵔⵏ ⴰ ⴾⵢ ⵓⵔ ⵙⵎ ⵏⵀⵢ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⴾⵢ ⴹⵤⵤⵔⵏ ⵢⵎⵍⵢ ⴼⵍ ⴹⵜⵙ ⵜⴾⵏⴰ ⵜⵔⵢⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ⵜⵙⵙⵏⴰ ⵜⵎⵜⵢⵏⵜ ⵙ ⴼⵙⵏ ⵍⵏ ⵗⵔ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ⵓⵏ ⵜⴶⵢ ⵎⵍⵏⵏⴰ ⵎⵛⵏⴰ ⴼⵍ ⵙⵀⵀ ⵏ⵿ⵜⵂⵏⵏ⵿ⵜ ⵜⴶⵜ ⵜⴰ ⵜⵜⵂⵜ⵰ ⴹⵢ ⴼⵍ ⴹⵏⴹⵤⵙⵓ ⵍⵎⵙⵈ ⵍⴰ ⴹⴶⵎⴹ ⵏ⵿ⵜⴼⴾ ");
INSERT INTO ttqt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ⴼⵍ ⴹ ⵎⵍⵓⵍⵓ ⵏⵔⵏⵜ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⵆⵎⵏⵏ ⴹⵗ ⵛⵢⵢ ⵂⵏ ⵜⵍⵢ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵤⵤⵍⵍⵗ ⵜⴾⵍⵏⵏⴰ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ⴹ ⴹⴶⵍ ⵢⵈⵢⴰ ⵜⵜⵓⴹⵜⴹ ⵜⵢⵜⵢⵏⵜ⵰ ⵤⴹⵗ ⴾⵍⵏ ⵏ⵿ⵙⴼⵏ ⵂⵔ ⵤⵍ ⵓⴹ ⵙⵙⵏ ⴾⵍⵙⵔⵢⵍ ⴼⵍ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ⵤⵎⵏ ⵓⵏ ⴹⵗ ⵤⵂⵓ ⵗⵢⵙⴰ ⴹⵗ ⵎⵔ ⵆⵢⵙⵔⴰ ⴶⵙ⵿ⵜⵙ ⵓⵏ ⵜⵀⵍ ⵏⵔⵎ ⵙⴹ ⴹⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵗⵎⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ⵜⴹⵏ⵿ⵜ ⵜⵏ ⵏ⵿ⵜⴰ ⵜⵤⵔⵜ⵰ ⵙ ⵜⴶⴰ ⴾⵔⵏⵢⵙ ⵎⵙⵏ ⵎⵤⵔ ⵏⴾⵍ ⵓⵏ ⵙⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ⵢⵜⴹⵏ ⴾⵍ ⴶⵍⵏ ⴹ ⴹⵏⵏ⵰ ⴾⵍⴾ ⵏⵓⴹⵏ ⴾⴰ ⵗⵔⵎ ⵏⵎⵔⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ⴹⵢ ⴼⵍ ⴶⵎⴹ ⵢⵙⴼ ⵏ⵿ⵜⴰ ⴹⴰ ⵗⵔⵎ ⵓⵏ ⵏⵤⵔⵜ ⵂⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴶⵤⵢ ⵙⵗⵔⵎ ⵏⵍⵌⴹⵏⵜ ⵎⵏⴾⵍ ⴹⵓⴹ ⵜⵎⵙⵏ ⵗⵔⵎ ⵏⵀⵜⵍⵈⵎ ⵂⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ⴼⵍ ⴹⵗⵙ ⴹⵏ⵰ ⴹⵓ ⴹⵎⵔⵢⵎⴰ ⴹⵔ ⵙⵎⵔⴾⵙ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⴹⴰ ⵜⴶⴰ ⵜⴹⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ⵂⵏ ⵀⵜⵍⵈⵎ ⵙ ⴼⵍⵙ ⴶⴰ ⵍⵓⵆ ⵏⴶⵤ ⵏⵎⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ⵜⴶⵤ ⵎⵔⵢⵎⴰ ⵎⵤⵔ ⵏⵗⴼⴹⵢⵏⵜ⵰ ⵜⴶⵓ ⵓⵏ ⴹⴶⵎⴰ ⵏⵙⴶⵏ ⵏⵂⵔⵢ ⵙⵗⵏ ⴹⵂⵏ ⵓⴰ ⵗⵔ ⵤⵀⵏ ⴼⵍⵙ ⴹⴶ ⵓⵔ ⴶⵔⵓⵏ ⴹⵗ ⵂⵏⵏ⵰ ⵜⵜⵍ ⵀⵔⵔ ⴹⵗ ⴼⵔ ⵜⵙⵏ⵿ⵙⵢ ⴹⵗ ⵗⵍⵍ ⵍⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ⴾⵍⵏ ⵂⵏ⵿ⵜⵓ ⵎⴹⵏⵏ ⵙⵎ⵿ⵀⵔⵏⵏ ⵂⵔⵢⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ⴹⵏ ⴹⴰ ⴹⵏⴼⵍⵍ ⴹⵜⵙⵏ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵜⵙⵎⵍⵓⵍⵓ ⵜⵏⵢⴰ ⵏⵎⵍⵢ ⴹⴶ ⵓⴰ ⵂⵏ ⴶⵏ ⵜⵔⵎⵆ ⵤⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ⵏⵙⵏ ⵏ⵿ⴶⵍⵙ «ⴹ ⵓⵔ ⵜⵔⵎⵗⵎ ⵙⵍⵏ ⵍⵗⵏⵏ ⴹⵓⵏ⵿ⴹⵓⵢⴰ ⴹⵤⵓⵢⵏⵏ ⵜⴹⵓⵜ ⵜⴶⵜ ⵙ ⵜⵎⵜⵢ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ⵤⵍⴹⴰ ⵎⵗⵍⵙⵏⵓⵏ ⵂⵓ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴹⵓⴹ⵰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⵙ ⵜⵤⵜⵤⴹⵢⵎ \"ⴹ ⵜⵏⵢⵎ ⵌⵏ⵿ⵗⵢ ⵜⵍⵏ ⴹⵗ ⴼⵔ ⵙⵔⴹ ⴹⵗ ⵗⵍⵍ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ⵓⵍⴰ ⵂⴶⵏ ⵏⴼⵍⵍⴹⵓ ⴶⵏ ⵤⵓⵔⵏ ⵏⵏ⵿ⴶⵍⵙⵏ ⵗⵔ ⵓⵏ ⵎⵍⵏ ⵎⵛⵏⴰ ⴶⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ⵍⵈⵔ ⴹⵗ ⴹⵏⵜ ⵢⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⴶⵏⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ⵆⵍⵏ ⵏ⵿ⴶⵍⵙⵏ ⵌⵏⵓⵏ ⵗⵙ ⵏⵎⵏⵏ ⵎⴹⵏⵏ «ⵏ⵿ⴹⵓⵜ ⵀⵜⵍⵈⵎ ⴹ ⵏⵏⵢ ⵓⴰ ⴹⵏⵗⵎⵍ ⵎⵍⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ⵜⵤⵔ ⴶⵍⵏ ⵂⵤⵏ⵰ ⵙⵏⵏ ⵎⵔⵢⵎⴰ ⴹⵢⵙⴼ ⴹⵌⵏ⵿ⵗⵢ ⵙⵔⴹ ⴹⵗ ⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ⵙ ⵏⵢⵏ ⵎⴹⵏⵏ ⵀⵔⵔ ⵙⵗⵍⵏ ⵓⴰ ⴹⵙⵏⵜⵓⵏⵏ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⴰ ⵏⵏ ⵎⴹⵏⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ⵎⵔⵢⵎⴰ ⵏ⵿ⵜⴰ ⵜⵜⴼ ⵙⵍⵏⵏ ⴾⵍ ⴹⵗ ⵎⵏⵜ ⵜⵏⵤⵔ ⴹⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ⵜⵤⵔ ⵆⵍⵏ ⵎⴹⵏⵏ ⵎⵍⵏ ⴹⴾⵍ ⵏⵎⵛⵏⴰ ⵜⴶⵏⵙ ⵜⵎⵍⵏ ⴼⵍ ⵛⴹⵜ ⵏⵔⵜ ⴾⵍ ⵓⵙ ⵙⵍⵏ ⴹⵓⴰ ⵏⵢⵏ ⵙ ⴾⵜⵏⵜ ⴶⴰ ⵙⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴹⵙⵏⵜⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ⵙ ⵤⵍ ⵓⵏ ⵜⵎ ⵜⵓⵙⵎⵏ⵿ⴾⴹ ⵀⵔⵔ ⵜⵓⴶⵙ ⵙⵎ ⵗⵢⵙⴰ ⵎⵙ ⵙ ⵙⵎ ⵓⴰ ⴹⴰ ⵎⵍ ⵏ⵿ⴶⵍⵙ ⵢⵏⵏⵜ ⴹⵜ ⴶⵏⵜ ⵜⴹⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ⵙ ⴹⵓⴹ ⵍⵓⵆ ⵏ⵿ⵤⵤⴹⴶ ⵓⴰ ⵎⵍ ⵜⵓⵔⵜ ⵏⵏⵀⵢ ⵎⵙⴰ ⴹⵓ ⵢⵙⴼ ⴹⵎⵔⵢⵎⴰ ⵙⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴼⵍ ⴹ ⵤⵤⴹⴶⵏ ⵎⵏⵙⵏ⵰ ⵓⵢⵏ ⴹⵗ ⵀⵔⵔ ⵢⴹ ⵜⴶⵏ ⴹⴰ ⵜⵗⵍⴼ⵿ⵜ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ⵙⵎⴾ ⵙ ⴾⵜⵀ ⴹⵗ ⵛⵔⵗⴰ ⵏⵎⵍⵢ ⵙ «ⵀⵔⵔ ⴾⵍ ⵓⵏ ⵗⴼⴹⵢ ⴹ ⵙⴾⵜ ⵢⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ⵢⵙⴼ ⴹⵎⵔⵢⵎⴰ ⵙⵓⵔ⵿ⵜⵏ ⵛⵔⵗⴰ ⵏⵎⵍⵢ ⴹⵗ ⵜⵔⵢⵜ ⵏⵤⵤⴹⴶⵏⵙⵏ ⴹ ⴾⴼⵏ ⵜⵤⴶⵤⵎ⵿ⵜ ⵏ⵿ⵙⵏⵜⵜ ⵜⴹⵀⵔⵏ ⵛⵏ ⵙⴼ ⵎⴹⵗ ⵙⵏⵜⵜ ⵛⵏ ⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵈⵙⵔ ⴹⵗⵙ ⵍⵙ ⴶⵏ ⵙⵎ ⵙⵎⵗⵏ ⵏⵍⵗⴹⵍ ⵏⵎⴾⵙⴹ ⵏⵎⵛⵏⴰ⵰ ⴶⴰ ⵜⵎⴰ ⵏⵏⵙⵙⵎⴹ ⴹⵤⵙⵏ ⵙⴼⵙⵓ ⵙⵔⵢⵍ⵰ ⵙⵎⵗⵏⵏ ⵤⵀⴹⵓ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ⵙⵏ⵿ⵜⴰ ⴹⵙⵙⵏⴼⵍⵏ ⵙ ⵓⵔ ⵜⵤⵀⴰ ⵓⵔ ⵏⵢ ⵍⵎⵙⵈ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ⵓⵢⵜⴹ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⵎⵤⵢⵜⴹⵓ ⴹⵎⵔⵓⵏ ⵏ⵿ⵗⵢⵙⴰ ⵜⵎⵤⵍⵏ ⵙⵍⵗⴹⵜ ⵜⴰ ⵜⵏⵙⵓⵔ ⵛⵔⵗⴰ ⴹⵗ ⵀⵜⵓ ⵏⵀⵔⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ⴹⴾⵍ ⵙⵎⵗⵏ ⵀⵔⵔ ⴶⴰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ⵎⵔⴹⴰ ⵎⵍⵢ ⴹ ⵜⵢⵗ ⴾⵍⵏⴾ ⴹ ⵜⵀⴰ ⴹⵗ ⵍⵈⵔ ⴹ ⵓⴰ ⴹⵜⵏⵗ ⵏ⵿ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ⴼⵍⵙ ⵏⵢⴰ ⵙ ⵛⵜⵓⵏ ⵛⵏ⵿ⴹⵏⵏ ⵎⵗⵍⵙ ⵓⴰ ⴹⵏⴹⵜⵙⴾⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ⵓⴰ ⴹⵜⵙⵎⵜⴶⵗ ⵢ ⵜⵎⵜⵓⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ⵎⵙ ⵏⵔ ⵙ ⵤⴾⵙⵏ ⴹⵗ ⵛⵢⵢ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵢⴹⵓ ⴹⵗ ⴹⴾⵍ ⵙ ⵜⵎⵜⵢⵏⴾ ⴾⵍⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ⵀⵏⵜ ⴹⵏⵏⵜ ⵆⵏⵏ ⵗⴼⵓⵏⵙⵏ ⵢⵔⵜⵏ ⵓⵏ ⵙⵔⵙ ⵜⵓⵏⵏⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ⵜⵤⵔ ⵜⵔⵙⵏ ⵙⵎⵗⵏ ⴹⵙⵏⴶⵏ ⵍⵀⵔⴾⴰ ⵎⵔⵏ ⵏⴰ ⵢ ⵎⵔⵢⵎⴰ ⵏⴰ ⵏ⵿ⵗⵢⵙⴰ «ⵙⵏ ⵙ ⵀⵔⵔ ⵙⵏⴼⵔⵏ⵿ⵜⵓ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⴹⵓⵢ ⴶⴹⵍ ⴹⵜⵏⴾⵔⴰ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⴶⵜⵏⵏ ⵆⵍ ⵙⵀⵀ ⵏⵏⵎⵤⵔⵢ ⴶⵔ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ⵎⴾ ⵓⴹⵢ ⵙ ⵤⵙⴼⴶⵓ ⵓⴰ ⵂⵏ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ⴾⵎ ⵎⵏⵎ ⴾⵎⵤⵤⵔ ⵓⵍ ⵤⵏ ⵜⵜⵔⵤⴶ ⵜⴾⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ⵜⵍⵢ ⴹⵗ ⵜⵏⵀⵜ ⵢⵜ ⵜⴾⵏⵜ ⵜⵛⵔⵢ ⵜⴶⵜ ⵙⵎ ⵈⵏⵜⵓ ⵓⵍⵜ ⴼⵏⵓⵍ ⵏ⵿ⵜⵓⵛⵜ ⵜⵏ ⵛⵔ ⴹⵙⵏ ⵙⴰ ⵍⵏ ⵏⵤⵍⴼ ⴹⵗ ⵜⵎⴹⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ⵀⴰ ⵍⵙⵏⵜ ⵓⵔ ⵜⵍⵙ ⵤⵍⴼ ⵂⵔ ⵜⴶⴰ ⵜⵎⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴹⴾⵤ⵰ ⴼⵓ ⵜⵂⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⵜⵗⵀⴹ ⵎⵛⵏⴰ ⵂⴹ ⵤⵍ ⵜⵜⵤⵎ ⵜⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ⵜⵎⵤⵢⵜ ⵜⵏ⵿ⴹⴰ ⴹⵆⵏ ⴹⵜⵙⴰ ⵜⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ⵰ ⴹ ⵜⵜⴶⵓ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴶⵏⵏ ⵜⵎⴰ ⵏⴹ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵜⴹⵔⴼⵜⵏⵜ ⴼⵍ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ⵙ ⵙⵏ⵿ⴹⵏ ⵎⵔⵓⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵢ ⵏⵔⵜ ⴾⵍ ⵓⴰ ⵜⵏⵙⵓⵔ ⵛⵔⵗⴰ ⵏⵎⵍⵢ ⵆⵍⵏ ⵗⵔⵎⵏⵙⵏ ⵏⵤⵔⵜ ⵂⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ⴹⴶⵍ ⵀⵔⵔ ⵜⵍⵓ ⵜⵢⵜⵢ ⴹⴶⵔⵢ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵙ ⵎⵛⵏⴰ ⵔⵈⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","ⵓⵜⵢ ⴾⵍ ⴶⵤⵢⵏ ⵎⵔⵓⵏ ⵏ⵿ⵗⵢⵙⴰ ⵙⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵢⵎⴹ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ ⴾⵢ ⵎⵙ ⵓⵏ ⵍⵗⴹⵜ ⵏⵎⴹ ⵓⵏ⵰ ⵙ ⵆⵍ ⵗⵢⵙⴰ ⵓ ⵎⵔⵓ ⵍⵏ ⴹⵛⵏ ⴹⵓⵏ ⴹⵔⵙ ⵙⵎⴹ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ⵙ ⵗⵔⴹⵏ ⴹⵏ ⵓⵏ ⵎⴹ ⵆⵍⵏ ⵗⵢⵓⵏ ⵗⵢⵙⴰ ⵎⵔⵏ ⵆⵎⵏ ⴹⵗ ⵢⵔⵙⵍⵎ ⵓⵔ ⵙⵏⵏ ⴹⵗ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ⵗⵍⵏ ⵂⴰ ⵍⵌⵎⵗⵜ ⵏⵎⵛⴾⵍ ⵓⵏ ⴹⵔ ⴹⵓⵏ⵰ ⵙ ⴶⵏ ⵛⴾⵍ ⵏⵤⵍ ⴹⵙⴶⴹⵏ ⴹⵗ ⵛⵆⵗⵏⵙⵏ ⴹⵜⵎⵤⴹⵢⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ⵎⵛⵏ ⵓⵔ ⵜⴶⵔⵓⵏ ⵜⵤⵔ ⵆⵍⵏ ⵢⵔⵙⵍⵎ ⵙⴶⴹⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ⵙ ⵤⵍⵏⵙⵏ ⵓⵏ ⴾⵔⴹ ⴶⵔⵙⵏ ⴹⵔⵙ ⵙⵏ⵿ⵜⴹ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵗⵎⴰ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵙⵙⵎⵙⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⴹⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⴰ ⴶⵏⵓ ⵜⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵜⵢⵜⵢⵏⵜ ⴹⵍⵌⵓⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ⵙ ⵜⵏⵢⵏ ⵎⵔⵓⵏⵜ ⵂⴶⵏ ⵜⵏⵙ ⵏⵏⵜ «ⵀⵔⵔⵏ ⵎⴰ ⵎⵙ ⵓⴰ ⴹⵏⵜⴶ ⴹⴰ⵰ ⵏⴾ ⴹⵀⵏⴾ ⵜⵛⵓⵛⵏⴰ ⵜⵗⵔⵏⴾ ⵏⵙⴰ ⴹⴶ ⴾⵍ ⵏⵙⴶⴹⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ⵏⵙⵏ «ⵎⴰ ⴼⵍ ⵤⴰ ⵙ ⴹⵜⵙⴶⴹⵎ⵰ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵜⵍⵤⵎⵢ ⵜⵗⵎⵜ ⴹⵗ ⵂⵏ ⵏⵀⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ ⵓⴰ ⴹⵙⵏⵏⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ⴹⵓ ⵗⵢⵙⴰ ⴹⵎⵔⵓⵏⵜ ⵤⴶⴹⵢⵏ ⵆⵍⵏ ⵗⵔⵎ ⵏⵤⵔⵜ ⵀⵔⴹⴶⵙⵏ⵰ ⵏⵏⵜ ⵜⵜⴼ ⵔⵜⵏⵏ ⴾⵍ ⴹⵗ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ⴹⴶⵍ ⵗⵢⵙⴰ ⵜⵜⵜⵢ ⵜⵍⵏⵜ ⴶⵔⵢ ⴾⵏⵓ ⴶⵔⵤⵜ ⵢ ⵎⵛⵏⴰ ⴹⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ⵓⵜⵢ ⵓⵏ ⵎⵔⵓ ⴹⵙⵎⵙ ⵏⵆⵢⵙⵔⴰ ⵜⵀⵔⵢⵙ ⴹⴰ ⵜⵗⵎⵔ ⴼⵏ⵿ⵙ ⵀⵍⵜⵙ ⵎⵙⵏ ⵎⵤⵔ ⵏⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⵎⵔⵏ ⵂⵔⴹ ⵈⴾⵎ ⴼⵍ ⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⵎⵆⵔⵏⵜ ⴼⵍⵀⵙ ⵈⴾⵎ ⴼⵍ ⵓⵏ ⵜⵔⵢⴰ ⴹ ⵓⵏ ⵜⵔⴾⵏⵜ ⵍⵙⵏⵢⴰ ⵏ⵿ⵜⴰ ⵈⴾⵎ ⴼⵍ ⴾⵍ ⵓⵏ ⵀⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_2ⴰ","072_3_2ⴰ","LUK","3","2ⴰ","2ⴰ","ⵈⵏⵏ ⴹⴾⵢⴼ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_2ⵀ","072_3_2ⵀ","LUK","3","2ⵀ","2ⵀ","ⵓⵜⵢ ⵓⵏ ⴹⴰ ⴹⵤⵀⵜ ⵓⵍ ⵏⵎⵛⵏⴰ ⴼⵍ ⵢⵈⵢⴰ ⴶ ⵤⴾⵔⵢⴰ ⴹⵗ ⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ⴹⴼⵔ ⵓⵏ ⵍⵍ ⵢⵈⵢⴰ ⴾⵍⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵜⵢⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⵜⴶⵓ ⵢⵢⵜⴹⵏ ⵜⵍⵈⵜⵀⵜ ⴶⵏⵙⵏ ⴹ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⵙⴾⵏⵏ ⵜⵜⵀⵜⵏⵙⵏ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ⵎⴾ ⴹⵢ ⵓⵙ ⵜⵏ⵿ⴹⴰ ⵀⵜⵓ ⵜⴰ ⴾⵜⵀ ⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ «ⵍⵙ ⵢⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⴹⵗ ⵙⴼ ⴶⵏⵓ \"ⵙⵎⵜⴶⵜ ⵀⵔⵆⴰ ⵢⵎⵍⵢ⵰ ⵜⵙⵙⵗⴹⵎ ⵜⵔⵢⵏ ⴹⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ⴹ ⵜⵍⴰ ⵏⵂⵗ ⴾⵜⵏⵜ ⴹ ⵏⵀⵍ⵰ ⴹⵗⵗⵏ ⴹⴶⴼⵏ ⴹ ⵔⵙⵏ ⵜⵔⵢⵏ ⵛⵏ ⴼⵔⵗⵏⵏ ⴹ ⵗⴹⵏⵜ ⵀⵔⵆⵏ ⵓⵏ ⵓⵔ ⵏⴶⴹⴰ ⴹ ⴶⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ⵏⵢ ⵓⴹⵏ ⴾⵜⵏⵜ ⵍⵗⵍⵙ ⵓⴰ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ⴹⵢ ⴼⵍ ⴶⵏⵓ ⵢⵈⵢⴰ ⵢ ⵜⵎⵜⵓⵏ ⵛⵏ ⵜⴹⵜⵙⵏⵏ ⵢⵜⵏⵜⵙⵍⵎⵗ ⴹⵗ ⵎⵏ «ⵈⴰ ⵜⵛⵍⵏ ⵛⵏ⵰ ⵎⴰ ⴾⵓⵏⵙⵙⵏⵏ ⴹⵔⴶ ⵢⵜⴹⵀ ⵏⵎⵛⵏⴰ ⵓⴰ ⴹⵤⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ⴹⵗ ⴹⵢ ⵜⴶⵓⵜ ⵎⵤⵍⵏ ⵍⵗⵏⵏ ⵜⵙⵜⴹⵎ ⵙⵔⵙⵏ ⵜⵜⵀⵜⵏⵓⵏ⵰ ⵓⵔ ⴶⴹⴰ ⴹ ⵜⴶⵏⵎ ⴹⵗ ⵎⵏⵓⵏ \"ⵏⴾⵏⵢ ⵤⵔⵢⴰ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⵏⵎⵙ\" ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵎⵛⵏⴰ ⴼⵔⴶ ⴹ ⵙⵎⵜⵢ ⵛⵂⵏ ⵛⵏ ⵜⵂⵏⵢⵎ ⴹⴰ ⵈⵍⴾⴹⵓ ⴹⵗⵙⵏⵜ ⵤⵔⵢⴰ ⵢⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ⴶⵜ ⵏⵢⵜ⵰ ⵜⵤⴼ⵿ⵜ ⵂⵔⵓⴰ ⵎⵔⴹⴰ ⴹⴰ ⵜⵎⵜⴶ ⵢⴹⵜⵙⴹⵏ⵿ⴶⵔ ⵢⵛⴾⵏ⵰ ⴹⵗ ⴹⵢ ⵛⴾ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵜⵔⵓ ⵔⵜⵏ ⵍⵗⵏⵏ ⴹ ⵜⵓⵗⵜⵙ ⵜⵓⴶⵔⵏ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ⵜⵙⵙ⵿ⵜⵏⵏ ⵢⵜⴹⵏ ⴶⵏⵏⵙ «ⴹⵗ ⴹⵢ ⵎⵙ ⴹⵏⵗⵓⵔ ⵜⵏⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ⵏⵙⵏ «ⵓⴹⵏ ⵓⴰ ⵍⵏ ⵛⵏ ⵙⵍⵙⴰ ⴾⴼⵜ ⵢⵏ ⵢ ⵓⴰ ⵜⵓⵔⵏⵍⴰ⵰ ⵓⴰ ⵍⵏ ⵜⵛⴰ ⴾⴼⵜ ⴹⵗⵙ ⵓⴰ ⵜⵓⵔⵏⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ⵏⵀⵤⵏ ⵏⵎⵏⴰ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵜⵙⵏ⵿ⴹⵓ ⵢⵈⵢⴰ ⴼⵍ ⵜⵏⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵏⵏⵙ «ⵛⵈ ⵎⵙ ⴹⵏⵗⵓⵔ ⵜⵏⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵤⵔⵤⵎⵎ ⴶⵔⵏ ⵓⴰ ⴹⵓⵏⵜⵓⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⴹⵗ ⵙⵌⵜⵏ ⵏⵏⵙ «ⵏⴾⵏⵢ ⵤⴰ ⵎⵙ ⴹⵏⵗⵓⵔ ⵜⵏⴶⵓ⵰» ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵔⴾⵀⵎ ⴹⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⵤⵔⴼⵏⵜ ⵓⵍⴰ ⴹⵗ ⵜⵙⵓⵔⵎ⵿ⵜⵓ ⵀⵂⵓ⵰ ⴶⴹⵜ ⵙⵍⵈⵆⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⴰ ⴶⵏⵓ ⵢⵈⵢⴰ ⴶⵏ ⵜⵎⴰ⵰ ⴾ ⵓⴹⵏ ⵙⵎⴹⵔⵏⵏ ⴹⵗ ⵓⵍⵏⵜ ⴾⴹ ⵢⵈⵢⵏ ⴹⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ⵓⵏ ⴹⴰ ⴼⵍ ⴹⵙⵏⵏⴰ ⵢⵈⵢⴰ ⴾⵜⵏⵙⵏ «ⵏⴾ ⵎⵏ ⴹⵆ ⵆⵓⵏ⵿ⵙⵍⵎⵗⴰ ⵎⵛⵏ ⵤⵢⴹⵓ ⵍⵙ ⵙⵓⴰ ⴹⴶⴰ ⴹⵗ ⵛⴶⵔⵜ ⵓⵔ ⵓⴹⴰ ⵓⵍⴰ ⵔⴰ ⵏ⵿ⵙⵗⵏ ⵏ⵿ⵗⵜⵎⵏⵜ⵰ ⵏ⵿ⵜⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵎ⵿ⵙⵢ ⴹⵆ ⵆⵓⵏ⵿ⵤⵙⵍⵎⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ⵂⴰ ⵍⵎⵜⵍ ⵏⵓⴹⵏ ⵜⴼⵏ ⵜⵙⵢⵜ ⵢⴹ ⵤⵤⵔ ⵍⴾⵎⵏⵜ⵰ ⵛⴹⵓ ⵍⴾⵎⴰ ⴹⵗ ⵜⴹⵏ⵿ⴶⵓⵜⵏⵜ ⵛⵗⵍ ⵎⵔⵏ ⴶⵏⵜ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵜⵀⵍⴶⵍⴶⵜ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ⴶⵍⴰ ⵢⵈⵢⴰ ⴹⵗ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ ⵜⴶⵓ ⵢⵢⵜⴹⵏ ⵏⵙⵈⵜⵏ ⵓⵢⴹ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ⵂⵔⴹ ⵎⵔⵏ ⵓⵏ ⵎⵏⴾⵍ ⵏⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵔⵗⵎⵜⵏ ⴹⵙⴶⴰ ⴹⵗ ⵀⵜⵓ ⵏⵂⵔⴹⵢⵙ ⵜⵎⵙⵜ ⵜⵗⵔ ⵎⴹⵔⵢ ⵏⵂⵔⴹⵏ ⴹⴰ ⴶⵏ ⵙⵎ ⴼⵍⵀⵙ ⴶⵙ ⴹⵗ ⵓⵢⴹ ⵔⵗⵎⵜⵏ ⴼⵍ ⵔⴾ ⵎⵤⵍⵏ ⵍⵀⵙⵏⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ⵛⵜⴰ ⵂⵔⴹ ⴼⵍ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⴹⵏ ⴾⵍ ⴶⵢ ⵏⵢⵈⵢⴰ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ⵙ ⵜⵓⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴾⵍ ⴹⵗ ⵎⵏ ⵜⵓⵙⵍⵎⵗ ⴹⵗⵙⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ⵜⵜⵔ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵙ ⵏⵍⵎⵏ ⵌⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ⵤⵀⵜⴹⵓ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵂⴰ ⵛⵛⵍⵏ ⵏ⵿ⵜⴹⵀⵔ⵿ⵜ ⴶⵎⴹⵓ ⵎⵙⵍⵢ ⵌⵏⵓⵏ ⵏⴰ «ⴾⵢ ⵎⵙⵏ ⵀⵔⵔⵏ ⴾⵏⵗ ⵜⵔⴰ ⵜⵙⵏ⵿ⴹⴹⵓ ⴶⵏⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ⵍⴰ ⵗⵢⵙⴰ ⴹⴶ ⵏ⵿ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⵙ ⵙⵏ⵿ⵜⴰ ⵛⵗⵍⵏⵜ⵰ ⵜⴼⵏ ⵢⵜⴹⵏ ⵙ ⴶ ⵢⵙⴼ ⵓⵏ ⴶ ⵂⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ⵂⵍⵢ ⵏ⵿ⵜⴰ ⴶ ⵎⵜⵜ ⵎⵜⵜ ⴶ ⵍⵀⵢ ⵍⵀⵢ ⴶ ⵎⵍⴾⵢ ⵎⵍⴾⵢ ⴶ ⵢⵏⵢ ⵢⵏⵢ ⴶ ⵢⵙⴼ ");
INSERT INTO ttqt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ⵢⵙⴼ ⴶ ⵎⵜⵙⵢⵙ ⵎⵜⵙⵢⵙ ⴶ ⵎⵙ ⵎⵙ ⴶ ⵏⵂⵎ ⵏⵂⵎ ⴶ ⵈⵙⵍⵢ ⵈⵙⵍⵢ ⴶ ⵏⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ⵏⴶⵢ ⴶ ⵎⵜⵢ ⵎⵜⵢ ⴶ ⵎⵜⵙⵢⵙ ⵎⵜⵙⵢⵙ ⴶ ⵙⵎⵗⵢ ⵙⵎⵗⵢ ⴶ ⵢⵙⵈ ⵢⵙⵈ ⴶ ⵢⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ⵢⴹⴰ ⴶ ⵢⵂⵏⵏ ⵢⵂⵏⵏ ⴶ ⵗⵢⵙⴰ ⵗⵢⵙⴰ ⴶ ⵤⵔⵀⵀⵍ ⵤⵔⵀⵀⵍ ⴶ ⵙⵍⵜ ⵙⵍⵜ ⴶ ⵏⵢⵔⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ⵏⵢⵔⵢ ⴶ ⵎⵍⵈⵢ ⵎⵍⵈⵢ ⴶ ⴹⵢ ⴹⵢ ⴶ ⴾⵙⵎ ⴾⵙⵎ ⴶ ⵍⵎⴹⵎⴰ ⵍⵎⴹⵎⴰ ⴶ ⵔ ");
INSERT INTO ttqt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ⵔ ⴶ ⵗⵢⵙⴰ ⵗⵢⵙⴰ ⴶ ⵍⵢⵤⵔ ⵍⵢⵤⵔ ⴶ ⵢⵔⵎ ⵢⵔⵎ ⴶ ⵎⵜⵜ ⵎⵜⵜ ⴶ ⵍⵀⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ⵍⵀⵢ ⴶ ⵙⵎⵗⵏ ⵙⵎⵗⵏ ⴶ ⵢⵂⴹⴰ ⵢⵂⴹⴰ ⴶ ⵢⵙⴼ ⵢⵙⴼ ⴶ ⵢⵏⵎ ⵢⵏⵎ ⴶ ⵍⵢⴾⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ⵍⵢⴾⵎ ⴶ ⵎⵍⵢⴰ ⵎⵍⵢⴰ ⴶ ⵎⵢⵏⴰ ⵎⵢⵏⴰ ⴶ ⵎⵜⵜ ⵎⵜⵜ ⴶ ⵏⵜⵏ ⵏⵜⵏ ⴶ ⴹⵓⴹ ");
INSERT INTO ttqt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ⴹⵓⴹ ⴶ ⵢⵙⵢ ⵢⵙⵢ ⴶ ⵗⵀⵢⴹ ⵗⵀⵢⴹ ⴶ ⵀⵈⵤ ⵀⵈⵤ ⴶ ⵙⵍⴰ ⵙⵍⴰ ⴶ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ⵏⵙⵏ ⴶ ⵗⵎⵏⴹⵀ ⵗⵎⵏⴹⵀ ⴶ ⴹⵎⵏ ⴹⵎⵏ ⴶ ⵔⵏⵢ ⵔⵏⵢ ⴶ ⵈⵙⵔⵏ ⵈⵙⵔⵏ ⴶ ⴼⵔⵙ ⴼⵔⵙ ⴶ ⵢⵂⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ⵢⵂⴹⴰ ⴶ ⵢⵆⵀ ⵢⵆⵀ ⴶ ⵙⵂⵆ ⵙⵂⵆ ⴶ ⵀⵔⵂⵎ ⵀⵔⵂⵎ ⴶ ⵜⵔⵈ ⵜⵔⵈ ⴶ ⵏⵈⵔ ");
INSERT INTO ttqt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ⵏⵈⵔ ⴶ ⵙⵔⵈ ⵙⵔⵈ ⴶ ⵔⴶⵓ ⵔⴶⵓ ⴶ ⴼⵍⵈ ⴼⵍⵈ ⴶ ⵗⵀⵔ ⵗⵀⵔ ⴶ ⵙⵍⵈ ");
INSERT INTO ttqt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ⵙⵍⵈ ⴶ ⴾⵢⵏⵎ ⴾⵢⵏⵎ ⴶ ⵔⴼⴾⵛⴹ ⵔⴼⴾⵛⴹ ⴶ ⵙⵎ ⵙⵎ ⴶ ⵏⵈ ⵏⵈ ⴶ ⵍⵎⵈ ");
INSERT INTO ttqt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ⵍⵎⵈ ⴶ ⵎⵜⵙⵍⴰ ⵎⵜⵙⵍⴰ ⴶ ⵂⵏⵈ ⵂⵏⵈ ⴶ ⵢⵔⵜ ⵢⵔⵜ ⴶ ⵎⵍⵍⵢⵍ ⵎⵍⵍⵢⵍ ⴶ ⴾⵢⵏⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ⴾⵢⵏⵎ ⴶ ⵏⵙ ⵏⵙ ⴶ ⵙⵜ ⵙⵜ ⴶ ⴹⵎ ⴹⵎ ⵏ⵿ⵜⴰ ⵎⵛⵏⴰ ⵜⴹⵈⵍⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ⴶⵎⴹ ⵗⵢⵙⴰ ⵜⵎⵓⵏ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⴹⴾⵔ⵿ⵜⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵏ⵿ⴼⵙ ⵓⴰ ⴹⴰ ⵜⵙⴾⵏ ⵜⵏⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ⴶⴰ ⴹⵗⵙ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵤⵍ ⵜⵌⵔⵀⵜⵓ ⵀⵍⵙ⵰ ⴹⵏ ⵓⵏ ⴾⵍ ⴶⵏ ⵓⵔ ⵜⵛⴰ ⵓⵍⴰ ⵙ ⵗⵔⴹⵏ ⵂⵢ ⵍⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ⵏⵙ ⵀⵍⵙ «ⴾⴹ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵎⵔⴰ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵙⴹ ⵜⵆⵍ ⵎⵏ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⵓⴹⵏ ⵓⵔ ⵜⴹⵔ ⵙ ⵎⵏ⵿ⵙⵓⵏ ⵗⵙ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ⴾⴰ ⴹⵔⵙ ⵀⵍⵙ ⴹⴶ ⴾⵏⵏ ⵂⴾⵢ ⵙⵙⵓⴹⵜⵓ ⴹⵗ ⵜⵗⵎⵔⵏ ⴾⵍ ⵏⴹⵏⵜ ⴹⵗ ⵍⴼ ⵏⵛⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ⵎⵔⵏ ⵏⵙ «ⴰ ⴾⵢⴾⴼⴰ ⵜⵗⵎⵔⵏⵏ ⴾⵍ ⴹⵜⵂⵙⵢⵏⵙⵏⵜ ⴼⵍⵙ ⵜⵓⴾⴼⵏⵜⵢ ⵂⴾⵆⵏⵜ ⴹⵗ ⵢ ⵓⵙ ⵜⵏⵜⵔⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ⴹⵗ ⴹⵢ ⵙ ⴹⵜⵙⵌⴹⴰ ⴹ ⵜⴶⵔⵓⵗ ⵓⵏ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⵎⵍⵏⴾ ⵎⵛⵏⴰ ⵙ ⵤⴰ ⵜⵙⵌⴹⴰ ⵏ⵿ⵜⴰ ⵗⵙ ⵤⴰ ⵜⵗⵀⴹⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ⵜⵤⵔ ⴾⴰ ⴹⵔⵙ ⵀⵍⵙ ⵢⵔⵙⵍⵎ ⵙⵀⴹⴹⵜⵓ ⴼⵍ ⴼⵍⴰ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵙ «ⴾⴹ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵜⵔⴶ ");
INSERT INTO ttqt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⴹ ⵎⵔ ⵏ⵿ⴶⵍⵙⵏⵜ ⴾⵢ ⴶⵤⵏ ⴹⵗ ⵛⵔ\" ");
INSERT INTO ttqt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ⴾⵜⵀ ⴹⵗ ⵙ \"ⴰ ⴾⵢⴾⵀⵍⵏ ⴹⵗ ⴼⵙⵏⵙⵏ ⴼⵍ ⴹⴾⵓⵔ⵿ⵜⵏ⵿ⴾⴼ ⵜⵂⵏ⵿ⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵤⴰ ⵍⴾⵜⵀⵏ ⴹⵢ ⵏⵏ \"ⴹ ⵓⵔ ⵜⵜⵌⵔⵀⴰ ⵎⵍⵏⴾ ⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ⵙ ⵜⵗⵔⴹ ⵀⵍⵙ ⵌⵔⵀ ⴶⵍⴰ ⵢⵢ ⵂⵔ ⵙⵔⵙ ⵍⵙ ⴶⵔⵓ ⵏ⵿ⵜⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ⴹⴼⵔ ⵓⵏ ⵆⵍ ⵗⵢⵙⴰ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵜⵂⵢ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵜⴼⵤⵜ ⵙⵍⵜⵏⵜ ⴹⵗ ⴾⵍⵏ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⴹⵗ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵙⵏ ⵙⵗⵎⵔⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ⵙⴰ ⴹⵗ ⵗⵢⵙⴰ ⵏⵤⵔⵜ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ⵰ ⵙ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵤ ⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵎⵙ ⵓⵏ ⵔⵜ ⵜⴶⵓ ⴼⵓ⵰ ⵀⴹⴹ ⵢⴹ ⵗⵔⵓ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ⵜⵓⴾⴼⵢⵏ ⵍⴾⵜⵀ ⵓⵏ ⵏⵀⵢ ⵙⵢⵙ⵰ ⴾⵙ ⵢⵍⴾⵜⵀ ⴹⴰ ⵓⴰ ⴶⴰ ⵍⵎ ⴼⵍ ⴹⴶ ⴹⵗ ⴾⵜⵀ ⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ⵓⵔⵢ ⵏ⵿ⴼⵙ ⵏⵎⵍⵢ ⴼⵍⵙ ⵙⵏⴼⵔⵏⵢ ⵢⴹ ⵎⵍⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵢ ⵜⵍⵆⵓⵏ⵰ ⵤⵎⵤⵍⴹⵓ ⵢⴹ ⴶⵗ ⵙⵍⵏ ⵢ ⵓⵏ ⵜⵓⵜⴼⵏⵏ ⴶⵔⵓⵏ ⵎⵏⵙⵏ ⵤⵤⵢⵗ ⵎⴹⵔⵗⵍ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⴹⴶⵤⵏⵏ ⴹⵗ ⴶⵆⵏ ⴹⵗ ⵜⵔⴰ ⵏⵎⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ⵎⵍⵗ ⵓⵜⵢ ⵜⵂⴰ ⵔⵈⵎⵜ ⵏⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵜⵗⵔⵢ ⵂⵔ ⵍⴾⵜⵀ ⵙⵗⵍ⵿ⵜⵓ ⵢⵎⵛⵗⵍ ⵏⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵆⵎ⵰ ⴶⵔⵏ ⴹⵗⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵛⵜⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ⵎⵔⵏ ⵏⵙⵏ «ⵤⵍⴹⴰ ⵓⵍ ⵏⵎⵛⵏⴰ ⵓⵙ ⵜⵙⵍⵎ ⴹⴰ ⵏ⵿ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ⴾⵜⵏⵙⵏ ⵎⵍⵏ⵿ⵜⵓ⵰ ⵙⵎⴾⵍⵍⵏⵜ ⵙⵔⵙⵏ ⵀⵜⵜⵏ ⵍⵗⵏⵏ ⵛⵏ ⴹⴶⵎⴹⵏⵏ ⵎⵏⵜ ⴹ ⴶⵏⵏ «ⴾ ⵓⴰ ⵓⵔⴶⵗ ⴶ ⵢⵙⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵍⴾⵏ ⵙ ⴹⴹⵜⵙⴾⵜⵎ ⴶⵢ ⵓⴰ ⵏⵏ \"ⵏⵙⵎⴶⵍ ⵤⵤⵢ ⵎⵏⴾ\" ⵜⵤⵔ ⵜⵏⵎⵢ \"ⴶⵓ ⴹⵗ ⴾⵍⵏⴾ ⴹⴰ ⴹⴰ ⵓⵙ ⵏⵙⵍⴰ ⵙ ⵜⴶⵆⵓ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴾⴼⵔⵏⵂⵎ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ⵏⵙⵏ ⴹⵗ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⵏⵀⵢ ⵜⵓⵆⵀⵍⵏ ⴹⵗ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ⵎⵔⵏ ⴹⵓⵏⵎⵍⴰ ⵜⴹⵜ ⴹⵗ ⵍⵏ ⵏⵏⵀⵢ ⵍⵢⵙ ⴾⵍ ⵏⵙⵔⵢⵍ ⵂⵏⵜⵓ ⵜⴹⴹⵏ ⴶⵜⵏⵏ ⵙ ⵓⵔ ⴹⵔⵏ ⵎⴹⵏⵙⵏⵜ⵰ ⵍⵏⵏ ⴹⴰ ⴹⵗ ⴶⴰ ⴾⵏⴾ ⴾⵔⴹ ⵍⵏ ⴹⴶⵏⴰ ⵓⵔ ⵓⵜ ⴶⴰ ⵍⵤ ⵍⵀⵙⵏ ⴹⵗ ⴾⵍ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔ ⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵏⵀⵢ ⵍⵢⵙ ⵙ ⵓⵍⵢⵜ ⴹⵗ ⵜⴹⴹⵏⵏ⵰ ⴾⵍⵔ ⵤⵎⵤⵍ⵿ⵜⵓ ⵙⵢⵜ ⵜⵈⵙⵔⵜ ⴹⵗ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵙⵔⴼ⵿ⵜⴰ ⵜⵂⵜ ⴾⵍ ⵏ⵿ⵙⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ⵂⵏ ⴹⵗ ⴾⵜⵔⵜⵏ ⴶⵜⵏⵏ ⴾⵍ ⵏⵙⵔⵢⵍ ⴹⵗ ⵍⵏ ⵏⵏⵀⵢ ⵍⵙⵢⵙ ⵎⵛⵏ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵜⵓⵤⵤⵢⵏ ⵔ ⵏⵗⵎⵏ ⵓⵏ ⴾⵍ ⵏ⵿ⵙⵔⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ⵙ ⵙⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵢⵓⵏ ⴶⵤⵜⵏ ⵍⵂⵎ ⵍⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ⵀⴹⴹⵏ ⴶⵏ ⴼⵙⵏ ⴹⴰ ⵗⵢⵙⴰ ⴾⵙⵏ⵿ⵜⵓ ⴹⵗ ⵗⵔⵎ ⵓⵢⵏ⵿ⵜⵓ ⵙⴼⵍⴰ ⵏⴹⵗⵗ ⵓⴰ ⴼⵍ ⴾⵔⵙ ⵗⵔⵎ ⵢⴹ ⵜⴶⵔⵏ ⴹⵗ ⵗⵗⵢ ⵀⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ⵎⵛⵏ ⵍⵎ ⵗⵢⵙⴰ ⴶⵔⵙⵏ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ⴹⴼⵔ ⵓⵏ ⵔⵙ ⵗⵢⵙⴰ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵜⴶⵜ ⴾⴼⵔⵏⵂⵎ ⵜⵂⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ ⴹ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⴹⵗ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵌⵍⵏ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵎⴾ ⵓⵙ ⵙⵙⵗⵔⵓ ⴼⵍⵙ ⵙⵙⵗⵔⵏⵜ ⵏ ⵓⴹⵏ ⵍⵏ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⵂⵢ ⵍⵙ ⵂⴰ ⴶⵙⴼ⵰ ⴹⴾⵍ ⵍⵙ ⵓⵏ ⵎⵙⵍⵏⵜ ⴹ ⴶⵏⵓ ");
INSERT INTO ttqt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«ⵈⴰ⵰ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵎⴰ ⴹⵗⵏⴰ ⵜⵔⵗ⵰ ⵏ⵿ⴶⵎ ⵙⴰ ⴹⵜⴶⵗ ⵢⴹⵏⵜⵂⵍⴾⴰ⵰ ⵙⵏⵗ ⵓⴰ ⵜⵎⵙⴰ ⵎⵤⴹⴶ ⵓⴰ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ⵂⵔⵛⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⴼⵙ⵿ⵜⵓ ⵜⴶⵎⴹⵗ ⵍⵙ ⴹⵢ⵰» ⵜⵤⵔ ⴶⴹⵍⴰ ⴶⵙⴼ ⵍⵙⵏ ⴶⵔ ⵢⵜⴹⵏ ⵎⵔⵏ ⴶⵎⴹⵜⵓ ⵓⵔ ⴹⵙⵈⵛⴹ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ⵂⴶⵏ ⵢⵜⴹⵏ ⴾⵜⵏⵙⵏ ⴹ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵓⵍ ⵏⵍⵙ ⵓⴰ⵰ ⴾⵍⵙⴼ ⴹⴰ ⵜⴼ ⴹⵗⵙⵏ ⵜⵏⵜ ⵜⵎⵔ⵿ⵜⵏ ⵙ ⵜⵏⵢⴰ ⴶⵎⴹⵏ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ⵜⵓⵤⵓⵤ ⵙⵍⵜ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⴹ ⵜⵍⴰ ⴹⴶ ⴹⵗ ⴾⵍⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ⵙ ⴶⵎⴹ ⵗⵢⵙⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴾⴰ ⵂⵏ ⵏ⵿ⵙⵎⵗⵏ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⵜⴹⴶⵍ⵿ⵜ ⵏ⵿ⵙⵎⵗⵏ ⵜⴼⵔⵢⵜ ⵜⵏⴹ ⵓⵍⵏ ⵜⵤⵔ ⴶⵎⵢⵏ ⴹⵗⵙ ⵢⵜⴹⵏ ⵜⵜⵤⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ⵏⵤⵏ ⴼⵍⵙ ⵗⵢⵙⴰ ⵙⵏⵔⵗⵎ ⵢ ⵜⵏⴹⵢ ⵜⵤⵔ ⵜⵓⵜ ⴼⵍⵙ⵰ ⵜⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵜⵏ⵿ⵜⵙⵎⴶⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ⵙ ⵜⴹⴰ ⵜⴼⴾ ⵓⵢⵏ⵿ⴹⵓ ⵙⵔⵙ ⵢⵜⴹⵏ ⵎⵔⵏⵏⵙⵏ ⴶⵏⵏ ⵛⵓⵔⵏⵓⵏ ⵎⵙⵏⵏ ⵤⵏⴼⵏ⵰ ⴾ ⵢⵏ ⵙⵓⵔ⵿ⵜⵓ ⴼⵙⵏⵜ ⵤⵤⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ⴶⵎⴹⵏ ⴹⵗ ⴾⵍⵙⴼ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙⵗⵔⵏ ⴾⵍⵙⴼ ⵏ ⴶⵏⵏ «ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏ» ⵎⵛⵏ ⵙⵏⵔⵗⵎⵙⵏ ⴶⴹⵍⵙⵏ ⵓⵍ ⴹ ⵎⵙⵏⵜ ⴶⵏ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ⵙ ⴼⵓ ⴶⵎⴹ ⵗⵢⵙⴰ ⵗⵔⵎ ⴾⴰ ⴹⴶ ⵙⴼⵏ⵰ ⴹⵙ⵿ⵜⵙⴶⴹ ⵜⵎⵜⵢ ⵂⵔ ⵜⵏ⵿ⵜⵙⴰ⵰ ⴹ ⴶⵎⵢⵏ ⵜⵎⵓⵜ ⵜⵙ ⴹⵙⵤⴶⴹⵍⵏ ⵜⵏⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ⵎⵛⵏ ⵏⵙⵏ «ⵓⵔⵢ ⴹ ⵎⵍⴰ ⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵢ ⵗⵔⵎⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴼⵍⵙ ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵎⵤⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ⵜⵤⵔ ⴶⵍⴰ ⵗⵢⵙⴰ ⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵏⴾⵍ ⵏⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ⵤⵍ ⵢⵏ ⵀⴹⴹ ⵗⵢⵙⴰ ⴹⵗ ⵜⵛⵛⵓⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵏⵤⵔⵜ ⵜⵜⵏⵀⴹⵗ ⴼⵍⵙ ⵜⵎⵜⵢ ⴼⵍ ⴹ ⵙⵍⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵓⴰ ⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ⵏⵢ ⵗⵢⵙⴰ ⵛⵏ ⵗⵍⵍⵏ ⵏⵎⵏ ⴹⵗ ⵜⵛⵛⵓⵜ ⵏⴶⵔⵓ⵰ ⵗⵍⵍⵏ ⵓⵏ ⴶⵎⴹⵏ⵿ⵜⵏ ⵎⵙⵓⵙⵏ ⵜⴾⵙⵏ ⵜⵌⵔⴶⵏ⵿ⵜ ⴹⵗ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵓⵏ ⵙ ⵜⵀⵤⵏ ⴾⴼⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ⵜⵤⵔ ⴶⵤ ⴹⵗⵙⵏ ⵓⵏ ⵙⵎⵗⵏ ⴶⵎⵢ ⴹⵗⵙ ⴹⵏⵤⵏ⵿ⴾⵤ ⴼⵍ ⵜⵛⵛⵓⵜ ⵎⵔⵏ ⵆⵎ ⴹ ⵙⵙⵗⵔⵓ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ⵙ ⵔⵤ ⴹⵗ ⵙⵙⵗⵔⵢ ⵏⴰ ⵢ ⵙⵎⵗⵏ «ⴾⵓ ⴾⵢ ⴹⵎⴹⵓⵏⴾ ⴹⴹ ⵤⴶⵔⵜⵏ ⵎⵏ ⵜⴶⵔⵎ ⵙⵏ⵿ⴶⵢⵜⵏⵓⵏ ⵜⵀⵤⵎ ⴾⴼⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ⵏⵙ ⵙⵎⵗⵏ «ⵛⵈ ⵂⴹ ⵗⵔⴹⵏ ⵏⴶⴰ ⵏⵛⵗⵍ ⴶⵙ ⵓⵔ ⵏⵀⵤ ⵓⵍⴰ ⵎⵛⵏ ⵢⴰ ⵤⵎⴰ ⴹⵢ ⵜⵏⵗ ⴹⵢ ⵤⴰ ⴹ ⴶⵔⴰ ⵙⵏ⵿ⴶⵢⵜⵏ ⴹⵗ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ⴶⵏ ⵓⴰ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ ⵜⵤⵔ ⵀⵤⵏ ⴾⴼⵜⵏ ⵙⵓⴰ ⴶⵏ ⴹⵗ ⴶⵜ ⵂⵔ ⵀⴾⵏ ⵙⵏ⵿ⴶⵢⵜⵏⵙⵏ ⵢⵤⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ⴹ ⵜⵍⴼⵏ ⵢ ⵎⴹⵓⵏⵙⵏ ⵓⵏ ⵂⵏⵏ ⵗⵍⵍ ⵏⵎⵏ ⵓⴰ ⵂⴹⵏ ⵢⴹⴶⵍⵏ ⴹⵙⵏⵍⵍⵏ⵰ ⵙⵏ⵿ⴹⵓ ⴹⵏⵢⵏ ⵛⵏ ⵗⵍⵍⵏ ⵓⵏ ⴹⵏ ⵂⵔ ⵀⴾⵏ ⵢⴹⴾⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ⵙ ⵏⵢ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵓⵏ ⵙⵌⴹ ⵢ ⵗⵢⵙⴰ ⵏⵙ «ⵢⴰ ⵎⵍⵢ ⵏⵎⴶⴶ ⴹⵔⵢ ⴼⵍⵙ ⵏⵙⵀⴾⴹ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ⵏⴰ ⵓⵏ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹⵎⴹⵓⵏⵜ ⴾⵜⵏⵙⵏ ⵙ ⵂⴶⵏ ⵗⵔ ⵏⵢⵏⵙⵏ ⴶⵜ ⵏ⵿ⴾⴼⵜⵏ ⵓⵏ ⵀⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ⵂⴶ ⵓⴰ ⴶⴰ ⵙⵎⵗⵏ ⴹⵏ ⵏ⵿ⵜⴰ ⴶⴰ ⵢⵆⵀ ⴹⵢⵈⵢⴰ ⵓⵏ ⵎⴹⵏⵙ ⵏ⵿ⵤⵀⴹⵢ ⴹⵔ ⴹⵔⵓ ⵛⵗⵍ⵰ ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵙⵎⵗⵏ «ⴹ ⵓⵔ ⵜⵔⵎⵗⴰ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵜⵆⵍⵎ ⵎⴹⵏ ⵙⵔⵢ ⴹⵤⵜⵓⵢⵏⵏ ⵢⵜⴹⵏ ⵢⵜⵏⵙⴼⵙⴰ ⴹⵗ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ⵎⵔⵏ ⵙⵗⵍⵏ ⵗⵍⵍⵏⵙⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵢⵏ ⵔⵜ ⴾⵍ ⵍⴾⵎⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ⵂⴰ ⵗⵢⵙⴰ ⵗⵔⵎ ⵢⵏ ⵙ ⵜⵏⵢ ⵍⵙ ⵙ ⵜⵍⵙⴰ ⵜⵓⵔⵏⴰ ⵏ⵿ⴾⵜⵔⵓ ⵍⵎⵏⵜ ⴾⵜⵏⵜ⵰ ⴾⵢⴹⵓ ⵙⵌⴹ ⴹⵜⵙ ⵏ⵿ⵙⵢⵜⵓ ⵏⵙ «ⵎⵍⵢ ⵙ ⵜⵔⵗ ⴹⵢ ⵜⴼⵔⴶⵗ ⴹⵜⵤⵤⵢⵗ ⵤⴹⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ⵤⵍⵏ ⵗⵢⵙⴰ ⴼⵙⵏⵜ ⴹⵙ⵿ⵜⵓ ⵏⵙ «ⵔⵗ ⴹⵢ ⵤⵢ ⵜⵤⴹⴶⴰ⵰» ⵎⵤⵢ ⵓⵏ ⴹⵗ ⴹ ⵤⵢ ⴹⵗ ⴾⵜⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ⵜⵤⵔ ⵙⵏ⵿ⴾⴹⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⵏⵢ ⵤⴰ ⴹ ⵓⵔ ⵜⵎⵍⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵓⴰ ⴶⵏ ⴹⴰ ⵎⵔⵏ ⴶⵍⵓ ⵜⵙⴾⵏⵗ ⵎⵏⴾ ⵢⵍⵎⵎ ⵜⴶⴰ ⵜⴾⵜⵢ ⵏ⵿ⵜⵤⴹⴾ ⵜⴰ ⴾⵢⵙⵓⵔ ⵛⵔⵗⴰ ⵏⵏⵀⵢ ⵎⵙⴰ ⴹ ⵆⵍ ⴹⵢ ⵢⵢⵜⴹⵏ ⵜⴶⵢⴰ ⵏ⵿ⵜⵎⵤⵢⵜⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴶⵍⴰ ⵙⵍⵜ ⵏ⵿ⵗⵢⵙⴰ ⵜⵜⵜⵢ ⵜⵜⴹⵓ ⴼⵍⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⴼⵍ ⴹⵙ⵿ⵜⵙⵙⵎ ⵤⵤⵢ ⴹⵗ ⵛⵓⵔⵏⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵜⴾⵓ ⴹⴶⵏ ⵙⴼⵏⵏ ⵢⴹⵗⵙⵏ ⵗⵀⴹ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ⵤⵍ ⵢⵏ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⵆⵎⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴶⵎⴹⵏⵏ ⵛⵗⵔⵎⵜⵏ ⴾⵍ ⵛⵏ ⵏⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹⵢⵔⵙⵍⵎ⵰ ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵢⵙⴰ ⴶⵔⵓ ⵗⵔ ⵎⵍⵢ ⵜⵔⵏⴰ ⵏⵤⵤⵢ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ⵂⵔ ⴹⵙⵏ ⵎⴹⵏ ⵓⵢⴹ ⵎⵙⵓⵢⵏⵏ ⵍⵙ ⵏⵏⵀⴹⵏ ⴹⵗ ⵜⵙⵜ⵰ ⴹ ⴶⵎⵢⵏ ⴹⵔⵙ ⴶⵤⵏ ⵙⵏ⵿ⵙⵏ⵿ⵜⵓ ⴹⵜ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ⵙ ⴹⵙⵏⵀⴰ ⵜⵎⵓⵜ ⵙ ⴹⵔⵙ ⴶⵤⵏ ⴼⵍ ⴶⵜ ⵏⵢⵜⴹⵏ ⵓⵔⵏ ⴼⵍⴰ ⵏ⵿ⵜⵗⵤⵎ⵿ⵜ ⵍⵎⵏ ⵙⴼⵍⵏⵜ ⵙⵔⵙⵏ⵿ⵜⵓ ⴹⵗⵙ ⵂⴰ ⵜⵙⵜⵏⵜ ⵂⵔ ⵜⵙⵏ⵿ⵙⵏ ⴹⵗ ⵎⵙ ⵏ⵿ⵜⵎⵜⵢ ⴹⵜ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵤⴶⵤⵏⵙⵏ ⵏⴰ ⵢⵏⵀⴹⵏ ⵓⵏ «ⵀⴾⴹⵏⴾ ⵜⵓⵙⵔⴼⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ⵙⵍⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵢⵓⵏ ⵗⵙ ⴹ ⴶⵏⵏ ⴹⵗ ⵎⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵍⵙ ⵓⴰ ⵜⴶⵏ ⵎⴹⵔⵓ ⴹⴰ⵰ ⵎⴰ ⴼⵔⴶⵏ ⵙⵔⴼ ⵏⵀⴾⴹⵏ ⵔ ⵎⵛⵏⴰ ⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ⵙⵏ ⵗⵢⵙⴰ ⵓⴰ ⵙⵎⴹⵔⵏⵏ ⵏⵙⵏ «ⵎⴼⵍ ⵜⵜⵂⵏ⵿ⵤⵎⵎ ⴹⵢ ⴹⵗ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ⵎⴰ ⴶⵔⵏ ⵜⵔⵗⵙⵢ ⴶⵔ ⵢ ⵏⵏ \"ⵜⵓⵙⵔⴼⵏⴾ ⵀⴾⴹⵏⴾ\" ⵎⵗ ⴾ ⵢ ⵏⵏ \"ⵀⴹⴹ ⵌⵓⵏ⵿ⴾⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ⵎⵔⵏ ⵔⵗ ⵜⵙⵏⵎ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵍⵗ ⴹⵗ ⴹⵏⵜ ⵜⵏⵢⴰ ⴹⵜⵛⵛⵓⴹⵜ ⴹ ⵙⵔⴼⴰ ⵢⵓⴹⵏ ⵀⴾⴹⵏⵜ⵰» ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢⵏⵀⴹⵏ «ⵀⴹⴹ ⵜⴹⴾⵍⴰ ⵜⵙⵜⵏⴾ ⵜⴾⵗ ⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ⵀⴹⴹ ⵍⵙ ⵓⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵜ ⵢⵜⴹⵏ ⴾⵍ ⴹⴾⵍ ⵜⵙⵜⵏⵜ ⵆⵍ ⵂⵏⵜ ⵎⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ⵢⵜⴹⵏ ⴾⵍ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⵓⵍⵏ⵰ ⵎⵍⵏ ⵎⵛⵏⴰ ⵜⵂⵏ ⵜⵙⴰ ⴶⵏⵏ «ⵤⵍⴹⴰ ⵏⵏⵢ ⵔⵜⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⵜⵓⵏⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⴶ ⵏ ⴶⴰ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵍⵀⵢ ⵆⵎ ⴹⵗ ⴹⴶ ⵓⵏ ⵤⵔⵤⵎ ⵏⵤⵔⴼ ⵏ⵿ⵜⴾⵙ ⵏⵙ «ⵍⴾⵎⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ⵀⴹⴹ ⵍⵀⵢ ⵢⴰ ⵓⴰ ⵂⴰ ⴾⵍ ⵍⴾⵎ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ⴹⴼⵔ ⵓⵏ ⴶⴰ ⵍⵀⵢ ⵢ ⵗⵢⵙⴰ ⵎⴶⵔⴰ ⵤⵓⵔⵏⵏ ⴹⵗ ⵂⵏⵜ⵰ ⴹⵔⵓⵏ ⴹⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵢⵜⴹⵏ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ⵏⵢⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏⵙⵏ ⵓⵏ ⵜⵓⵔⵜ ⵓⵏ ⵗⵙ ⴶⵜⵏ⵿ⵜⵏⵏ ⴹ ⴶⵏⵏ ⵢ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ «ⵎⴼⵍ ⵜⴹⵔⵓⵎ ⴹⵏⵤⵔⵤⵎ ⵏ⵿ⵜⴾⵙⵏ ⴹⵏⵙⵀⴾⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵢⵜⴹⵏ ⵓⵔ ⵏⴼⵔⵢ ⵓⵔ ⴹⵔⵔⵏ ⵙⵏⵙⵎⴶⵍ ⵎⵔⵏⵏ ⵙⵔⵙ ⴹⵔⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ⵏⴾ ⵓⵔ ⴹⵙⵗ ⴼⵍ ⴹⵍⵍ ⵏⵢⵜⴹⵏ ⵓⵏ ⵗⵔ ⴶⴰ ⵙ ⵗⴹⵏ ⴾⵍⵔ ⵎⵤⵍ ⴹⴶⵗ ⴼⵍ ⴹⵗⵔⵗ ⵏⵙⵀⴾⴹⵏ ⵙ ⵜⵜⵀⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ⴹⴼⵔ ⵓⵏ ⵏⵏⵙ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ «ⵏⵜⵍⵀ ⵏⵢⵈⵢⴰ ⴹⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵜⵤⵎⵏ ⴼⵓ ⵜⵜⵔⵏ ⵓⵏⴾ ⵎⵔⵏ ⵜⵜⵏ ⵙⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴾ ⵜⴼⵔⴶⵎ ⴹ ⵜⵤⵤⵎⵎ ⵍⴶⵜⵏ ⵗⵔ ⵍⴰ ⵎⵤⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ⵎⵛⵏ ⵍⴾⵎⵏ ⴹⵏ ⵗⵔⵙⵏ ⵤⵎⴹⴾⵍ ⵎⵤⵍⵢ⵰ ⴹⵏ ⵓⵏ ⴹⵢ ⴹ ⵤⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ⴶⵙⵏ ⵗⵢⵙⴰ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⵢⵜ ⵏⵙⵏ «ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵤⴾⵙⵏ ⵛⴾⵙ⵿ⵜ ⴹⵗ ⵜⵀⴹⵆ ⵜⵢⵏⵢⵜ ⵢⵜⵜⵓⵜ ⴹⵗ ⵢⵜ ⵓⵛⵔⵜ ⴼⵍⵙ ⵙ ⴶⴰ ⴹⵢ ⴹ ⵗⵛⴹ ⵜⵀⴹⵆ ⵜⴰ ⵜⵢⵏⵢⵜ ⵛⴾⵙ⵿ⵜ ⴹⵗ ⵜⴰ ⴹⵗⵙ ⴹⴾⵙ ⵓⵔ ⵜⵏⵂⴰ ⴹⵜⵀⴹⵆ ⵜⴰ ⵓⵛⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵢ ⵤⴶⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵢⵏⵢⵏ ⴹⵗ ⴶⴹⴹ⵰ ⵢ ⴶⵏ ⴹⵢ ⴹ ⵀⵆⵏ ⴶⴹⴹ ⵓⵏ ⵜⵤⵔ ⴼⵜⵓ ⴹⵗ ⵙⵎⴹ ⴹⴶⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ⴾⵍⵔ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵢⵏⵢⵏ ⵀⵢⵗ ⵢⵏⵢⵏⵏ ⴹⵗ ⵜⵓⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ⵓⴹⵏ ⵛⵓⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵓⵛⵔⵏ ⵓⵔ ⵤⵔⵓ ⴹⴼⵔ ⴹⵢ ⵜⵙⵢ ⵏⵓⴰ ⵢⵏⵢⵏ ⴼⵍⵙ ⴹ ⵏⵓ \"ⵓⴰ ⵓⵛⵔⵏ ⵤⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ⵤⵍ ⵢⵏ ⵎⵙⵏ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵌⵓⵏ⵿ⴾⵜ ⵗⵢⵙⴰ ⴹⵗ ⵜⵓⴶⵙ ⵏⵍⴾⵎⴰ ⵔⵙⵀⵏ⵿ⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵛⵗⵗⵏⵏ ⵜⴼⴼⵔⵏ⵿ⵜⵏⵜ ⴶⵔ ⴼⵙⵏⵙⵏ ⵜⵜⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ⵜⵤⵔ ⵏⵏⵙⵏ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ «ⵎⴼⵍ ⵜⵜⴶⵎ ⵔⵜ ⵈⵔⵎⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴾ ⵜⵗⵔⵢ ⵓⵔ ⵜⴶⵎ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⴹⵓⴹ ⵤⵍ ⵓⴰ ⵜⴶⵤ ⴶⵍⴾ ⵏ⵿ⵜⴰ ⴹⵎⴹⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ⵓⴾ ⵓⵔⴶⵗ ⴶⵤ ⴶⴰ ⵂⵏ ⵏⵎⵛⵏⴰ ⴹⴾⵍ ⵛⴶⵍⵓⵏ ⵛⵏ ⵎⵙⵏⵏ ⵜⴾⵜⵢ ⵜⵙⴾⵜⵜ ⵢ ⵎⵛⵏⴰ ⵙ ⵍⵎⵎⵏ ⵗⵙ ⵙ ⵜⵈⵍⵍ ⵜⵜⵢⵏⵙⵏⵜ ⵜⵛⴰ ⴹⵗⵙⵏⵜ ⴾⴼⴰ ⴹⵗⵙⵏⵜ ⴹⵗ ⵢⵜⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵏⴾ ⴶ ⴶⴹⵎ ⵈⴾⵎⵏ ⴼⵍ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ⵤⵍ ⵢⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹ ⵙⵙⵗⵔⵓ⵰ ⵂⵏⵏ ⵂⵢ ⵍⵙ ⵙ ⵎⵜ ⴼⵙⵏⵜ ⵓⵏ ⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ⴶⵔⵏ ⴹⵗⵙ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵛⵜⵓⵏ ⴼⵍ ⴹ ⵙⵏⵏ ⴾⴹ ⴹ ⵤⵤⵢ ⵓⴹⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵓⵍⴰ ⴼⵍ ⵜⵔⴰ ⵏⴹ ⴶⵔⵓⵏ ⴹⵍⵍ ⵙ ⵜⵈⵜⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵙⵏ ⵓⴰ ⵂⵏ ⵎⵏⵙⵏ⵰ ⵏⴰ ⵢⵍⵙ ⵓⵙ ⵎⵜ ⴼⵙⵏⵜ «ⵏ⵿ⴾⵔ ⵀⴹⴹ ⴹⵗ ⵎⵙ ⵏⵍⵌⵎⵗⵜ⵰» ⵏ⵿ⴾⵔ ⵍⵙ ⵀⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙⵙ⵿ⵜⵏⵆⵓⵏ ⵓⴾ ⵈⵍⵍ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵢ ⵏⵔⵜ ⵍⵗⵏ ⵎⵗ ⴶⵢ ⵏⵍⵀⵙⵏ ⵔⴶ ⵏⵓⴹⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵗ ⵓⴾ ⵛⵢⵜⵏⵜ ⵀⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ⵙⵍⵍ⵿ⵜⵏ ⵗⵢⵙⴰ ⵙⵓⴹⵏⵜ ⴾⵜⵏⵙⵏ ⵎⵔⵏ ⵏⴰ ⵢⵍⵙ ⵓⵙ ⵎⵜ ⴼⵙⵏⵜ «ⵤⵍ ⴼⵙⵏⴾ» ⴶⴰ ⵓⴰ ⴹⵙⵏⴰ ⵤⵢ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ⵔⵜ ⵓⵏ ⴶⴰ ⴹⵗⵙⵏ ⵍⵂⵎ ⵍⵀⵙⵏ ⴹ ⵜⵏⵎⵛⵓⵔⵏ ⴶⵔⵙⵏ ⴼⵍ ⵓⴰ ⵤⴶⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⴾⴰ ⵗⵢⵙⴰ ⴹⵗⵗ ⵢⵏ ⵢⴼⵍⵙ ⴶⵓ ⵛⵓⵜⵔⵓⵏ⵰ ⴶⴰ ⴼⵍⵙ ⵂⴹ ⵗⵔⴹⵏ ⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ⵙ ⴼⵓ ⵗⵔⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵙⵏⴼⵔⵏ ⴹⵗⵙⵏ ⵎⵔⵓ ⴹⵛⵏ ⴶⵙⵏ ⵙⵎ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ⵙⵎⵓⵏⵙⵏ ⴹⴰ ⵙⵎⵗⵏ ⵓⵙ ⴶⴰ ⵙⵎ ⵀⵜⵔⵙ ⴹⵎⴹⵔⵢⵏⵜ ⵏ⵿ⴹⵔⵓⵙ⵰ ⵢⵆⵀ ⵢⵈⵢⴰ ⴼⵍⵀⵙ ⵀⵔ⵿ⵜⵍⵎⵓⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ⵎⵜⴰ ⵜⵎⴰ ⵢⵆⵀ ⵓⵏ ⴶ ⵍⴼⵢ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵓⴰ ⵙⴶⵜⴾⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ⵢⵂⵤ ⵓⵏ ⴶ ⵢⵆⵀ ⴹⵢⵂⵤⴰ ⵙⵈⵔⵢⵜⵢ ⵓⴰ ⵤⴾⴹⵍⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ⴹⴼⵔ ⵓⵏ ⵤⵀⵜ ⴹⵔⵙⵏ ⵗⵢⵙⴰ ⴹⵗⵗ ⵀⴹⴹ ⴹⵗ ⵜⵗⵙ ⵢⵏ ⴹⵗ ⵜⵀⴹⴹ ⵜⵎⵜⵢ ⵜⴶⵜ ⵏⵍⴾⵎⵏⵜ ⴹⵜⵎⵜⵢ ⵜⴶⵜ ⴹⵜⴼⵍⵜ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴹⵢⵔⵙⵍⵎ ⴹⵗⵔⵎⵏ ⵓⵏ ⵜⵔ ⴹⵙⴹⵏ ⵂⵏⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⴰ ⵤⵓⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ⵢⵜⴹⵏⵏ ⵙⵏ⵿ⴹⵓ ⴼⵍ ⴹ ⵙⵙⵎⵏ ⵢⵓⴰ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⵜⵓⵤⵤⵢⵏ ⴹⵗ ⴹⵗ ⵜⵓⵔⵏⵓⵏⵙⵏ⵰ ⵤⵤⵢ ⴹⵗⵙⵏ ⴹⵗ ⵓⵏ ⵂⵏ ⴾⵍⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ⵜⵎⵜⵢⵏ ⴾⵜⵏⵜ ⵜⴶⵎⵢ ⴹⴹⵙ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍⵙ ⵜⵔⵏⴰ ⵜⴹⵜⴶⵎⴹⵜ ⵜⵤⵤⵢⵜⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ⵙⵓⴹ ⵗⵢⵙⴰ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵏⴰ «ⵜⵀⵍⵍⵎ ⴾⵓⵏⵢ ⵓⵏ ⵙⵍⵆⵓⵏⵏ ⵎⵏⵓⵏ ⴹⵜ ⵎⵛⵏⴰ ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵛⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ⵜⵀⵍⵍⵎ ⴾⵓⵏⵢ ⵓⵏ ⵂⴰ ⵍⵤ ⵎⵔⴹⴰ ⴼⵍⵙ ⴹ ⵜⵢⵓⵏⵎ⵰ ⵜⵀⵍⵍⵎ ⴾⵓⵏⵢ ⵓⵏ ⵂⵍⵏⵏ ⵎⵔⴹⴰ ⴼⵍⵙ ⴹ ⵜⴹⵤⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ⵜⵀⵍⵍⵎ ⴾⵓⵏⵢ ⵓⵏ ⴾⵢⴹⵏ ⵢⵜⴹⵏ ⴾⵙⵏ⵿ⴾⵓⵏ ⴹⵗ ⵎⵙⵏⵙⵏ ⵔⵀⴹⵏ⵿ⴾⵓⵏ ⵗⵛⴹⵏ ⵙⵎⵓⵏⵓⵏ ⴼⵍⵙ ⴹⵜⵍⴾⵎⵎ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ⴹⵓⵜⵜ ⵜⴼⵍⵓⵙⵎ ⵤⵍ ⵓⴹⵢ ⴼⵍⵙ ⵜⵍⵎ ⵔⵤⵏ ⴶⵜⵏⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ⵔⵜ ⵓⴰ ⴹⵓⵏⴶⵏ ⴹⵢ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵏ ⵎⵔⵓⵏⵙⵏ ⵢⵏⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ⵎⵛⵏ ⴾⵓⵏⵢ ⵎⴶⵔⴶⵙ ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴼⵍⵙ ⵓⴰ ⵔⵏ ⵎⵏⵓⵏ ⵂⴰ ⴼⵙⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵓⵏⵢ ⵓⵏ ⵢⵓⵏⵏ ⵎⵔⴹⴰ ⴼⵍⵙ ⴹ ⵜⵍⵤⵎ⵰ ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵓⵏⵢ ⵓⵏ ⴹⵤⵏⵏ ⵎⵔⴹⴰ ⴼⵍⵙ ⴹⵗⵓⵏ ⵜⴶⵓ ⵜⴼⵢⵓⵜ ⵜⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵓⵏⵢ ⵓⵏ ⵎⵍⵏ ⵢⵜⴹⵏ⵰ ⴰ ⴹⴹⴰ ⴶⵏ ⵎⵔⵓⵏⵙⵏ ⵢⵏⵀⵜⵏ ⵓⵏ ⵀⵂⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«ⴾⵓⵏⵢ ⵓⵏ ⴹⵙⵙⵎⵏⵏ ⵎⵔⵏ ⵏⵗⵓⵏ \"ⵔⵓⵜ ⵤⵏ⵿ⴶⵏⵓⵏ ⴹ ⵜⵜⵎⵤⵍⵎ ⵍⵗ ⵢ ⵓⵏ ⴾⵓⵏⴾⵢⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ⵜⵜⵔⵜ ⴶⵏ ⵔⵈⵎⵜ ⵢ ⵓⵏ ⴾⵓⵏ⵿ⵙⵓⵔⵏⵏ ⵍⵗⵏⵜ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴶⵏ ⵍⵈⵔ ⵢ ⵓⵏ ⴹⵓⵏ⵿ⵜⴶⵏⵏ ⵜⵔⵛⵈⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ⵙ ⴹⴾⵆⵙ ⵓⴹⵏ ⵜⴾⴼⵆⵓ ⵎⴹⴹⵏⴾ ⵓⴰ ⵂⴹⵏ⵰ ⵙ ⴹⵗⴾ ⵔⴾⵀ ⵓⴹⵏ ⵀⵔⵏⵤⵏⴾ ⵍⵗⵛⵀⵏⴾ ⴹⴰ ⵢⵙ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ⵢ ⴾⵢⵏ⵿ⵙⵢⵏ ⵜⴾⴼⵆⵓ⵰ ⴹ ⵓⵔ ⵜⴶⵎⵢⴰ ⴹⵗ ⵓⴹⵏ ⴾⵢⴹⵙⵗⵍ ⵓⴰ ⴹⵗⴾ ⵔⴾⵀ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«ⵔⵜ ⵓⵙ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⴶⵏ ⵢⵜⴹⵏ ⴶⵜⵙⵏ⵿ⵜⵓ ⴾⵓⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ⴾⴹ ⵓⵔ ⵜⵔⵎ ⵔ ⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⵔⵏⵏ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵤ ⵓⴰ ⵤⴰ ⵜⴶⵔⵓⵎ⵰ ⵓⵍⴰ ⵔⴾ ⵢⵜⴹⵏ ⴹⴰ ⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ⴾⴹ ⵓⵔ ⵜⵜⴶⵎ ⵍⵗⵏ ⵔ ⵢ ⵓⵏ ⴹⵓⵏ⵿ⵜⵜⴶⵏⵏ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵤ ⵓⴰ ⵤⴰ ⵜⴶⵔⵓⵎ⵰ ⵓⵍⴰ ⵔⴾ ⵢⵜⴹⵏ ⵜⴶⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ⴾⴹ ⴹⵗ ⵓⵔ ⵜⵙⵎⵔⵓⵙⵎ ⵔ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵜⵔⴹⵎ ⵙ ⴹⵓⵏⵔⵤⵎⵏ ⵓⴾ ⵎⴰ ⵎⵙ ⵔⵤ ⵓⴰ ⵤⴰ ⵜⴶⵔⵓⵎ⵰ ⵔⴾ ⵢⵜⴹⵏ ⴹⴰ ⵜⵏⵎⴾⴼⵏ ⵎⵔⵓⵙⵏ ⴶⵔⵙⵏ ⴼⵍⵙ ⵙⵏⵏ ⵙ ⵜⵏ⵿ⴹⵆⵍ ⵓⴰ ⵙⵎⵔⵓⵙⵏ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«ⴾⵍⵔ ⵔⵓⵜ ⵤⵏ⵿ⴶⵏⵓⵏ ⴹ ⵜⵜⴶⵎ ⵢⵢⵜⴹⵏ ⵓⴰ ⵍⵗⵏ ⵜⵜⵤⵀⵏⵎ ⵢ ⵓⵏ ⴹⵗⵓⵏ ⴶⵎⵢⵏⵏ ⵤⵀⵏⴰ⵰ ⵜⴶⵎ ⴹⵢ ⴾⵜⵏⵜ ⴹⴰ ⵓⵔ ⵜⴶⵎ ⵜⵎⴰ ⵏ⵿ⴹⵓⵏⵜⵓⴶⵓ⵰ ⴹⵢ ⴹ ⴶⵜ ⵔⵤⵏⵓⵏ ⵜⵆⵍⵎ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵜⴶⵓ ⵍⵗ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵂⴰ ⴶⴹⴰ ⴹⵓⵏ ⵎⴾⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ⵜⴶⵤⵜⴾⵓⵏ ⵜⵂⵏⵏ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵀⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«ⴹ ⵓⵔ ⵜⵏⵎ ⵔⴾ ⵔⵜ ⵙⵓⴹⵏ ⴼⵍ ⵙⵔⵓⵏ ⵓⵔ ⵜⵓⵏⵓ⵰ ⴹ ⵓⵔ ⵜⵙⵓⵔⵎ ⵓⴹⵏ ⵍⵂⵏ ⴼⵍ ⴾⵓⵏⵓⵔⵜⵓⵙⵓⵔ ⴾⵓⵏⵢ ⴹⴰ⵰ ⵙⵔⴼⵜ ⴹ ⵜⴶⵔⵓⵎ ⵜⵙⵔⴼ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ⵂⴾⵜ ⴹ ⵜⵜⵓⴾⴼⵎ⵰ ⵜⵙⴾⵜ ⵜⵍⵗⵜ ⵜⴹⴾⵔⵜ ⵜⵙⴾⵙⴾⵜ ⵂⵔ ⵜⴼⵜⵏ⵿ⵗⵍ ⴹⵓⵏ⵿ⵤⵜⵓⴶⵏ ⴹⵗ ⵙⵀⵜⵔⵏⵓⵏ⵰ ⵜⵙⴾⵜ ⵜⵙ ⵜⴾⵜⵎ ⵢⵢⵜⴹⵏ ⵏ⵿ⵜⴰ ⵙ ⴹⵓⵏ⵿ⵤⴾⵜ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ⴶⵙⵏ ⴹⵗ ⵗⵢⵙⴰ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⵏⵙⵏ «ⵓⴾ ⵎⴹⵔⵗⵍ ⴼⵔⴶ ⵍⵓⵢ ⵏⵢⵏ ⵎⴹⵔⵗⵍ⵰ ⵙ ⴶⴰ ⴹⵢ ⵓⵔⴶⵗ ⴾⵜⵏⵙⵏ ⵙ ⵤⴹⵏ ⴹⵗ ⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ⵜⵍⵎⵢ ⵓⵔ ⴶⵔ ⵛⵈⵏⵜ ⵎⵛⵏ ⵜⵍⵎⵢ ⴾⵍ ⵓⴰ ⵙⵈⵜⵎⵏ ⴹ ⴶⴹⵓ ⴹⵛⵈⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ⵎⴼⵍ ⵜⵂⵏⵢⴰ ⵜⵤⵓⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵏⵎⴹⵔⵢⵏⴾ ⴾⵢ ⵎⵔⵏ ⵓⵔ ⴹⵏ⵿ⵜⴶⵔⵗ ⵛⵍⵍ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵜⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ⵎⵏⵎⴾ ⵙ ⵜⴶⵏⴰ ⵢⵎⴹⵔⵢⵏⴾ \"ⵢⵢ ⴹⴾⴾⵙⵗ ⵜⵤⵓⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜⵏⴾ⵰\" ⵙ ⴶⴰ ⵓⵏ ⴾⵢ ⵎⵏⴾ ⵓⵔ ⵜⵂⵏⵢⴰ ⵛⵍⵍ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵜⵏⴾ⵰ ⵎⵏⴼⵆ ⴾⵙ ⵜⵤⵔ ⵛⵍⵍ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜⵏⴾ ⴹⵢ ⴹ ⵤⴰ ⵜⵏⴼⵍⵢⵗ ⴹⵗ ⵜⵤⵓⵜ ⵜⴰ ⵜⵂⵜ ⵛⵜ ⵏⵎⴹⵔⵢⵏⴾ ⵜⴾⵙⵗⵙ⵿ⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ⵓⵔ ⵜⵍⴰ ⵛⴾ ⵙⵈⵏ ⵜⵔⵓⵏ ⵔⵜⵏ ⵀⵔⵔⵏⵏ ⵓⵍⴰ ⵢⵏ ⵓⵔ ⵏⵙⵈⴰ ⵜⵔⵓⵏ ⵔⵜⵏ ⵍⵗⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ⴾⵍⴾ ⵏⵛⴾ ⵔⵜⵏⵜ ⵙ ⵜⵓⵤⴹⵢ⵰ ⵓⵔ ⵜⵏⵎⴹⵏ ⵔⵜⵏ ⵏ⵿ⴼⴶ ⴹⵗ ⵜⵤⵢⵜ ⵓⵍⴰ ⴹⵗ ⵜⵏⵎⴹ ⵍⵗⵏⵀ ⴹⵗ ⵜⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ⵓⴹⵏ ⵓⴰ ⵍⵗⵏ ⵍⵗ ⵓⴰ ⵂⵏ ⵓⵍⵏⵜ ⴹⵗ ⴹⵜⴾⵙ ⵓⴰ ⵍⵗⵏ ⵎⵛⵏ ⵏⵍⵀⵙ ⵏ⵿ⵜⴰ ⵜⵍⵀⵙ⵿ⵜ ⵜⴰ ⵜⵂⵜ ⵓⵍⵏⵜ ⴹⵗ ⴹⵜⴾⵙ ⵓⴰ ⵍⵀⵙⵏ⵰ ⵓⴰ ⴹⴾⵔⵏ ⵓⵍ ⵏⵓⴹⵏ ⴹⴶⵎⴹⵏ ⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ⵎⴰ ⴼⵍ ⵙ ⴹⵜⴶⵏⵎ \"ⵎⵍⵢ ⵎⵍⵢ⵰\" ⵎⵛⵏ ⵓⵔ ⵜⵜⴶⵎ ⵓⴰ ⴹⵓⵏ⵿ⴶⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","«ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⴹⵜⵙⵏ ⵙⵙⵎ ⵢⵓⵍⵏ ⵜⵎⵤⵍ ⵙⵓⴰ ⵏⵗ ⴹⵓⵏⵎⵍⴰ ⵓⴹⵏ ⵓⴰ ⵙ⵿ⵜⵤⵎⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ⵎⵜⵍⵆⵓ ⵙⵓⴹⵏ ⴾⵔⵙⵏ ⵂⵏ⵰ ⵗⵤ ⵓⵍⵏ ⵂⵔ ⵓⴹ ⵜⵙⵍⵜ ⴾⵔⵙⴹⵓ ⴼⵍⵙ ⵂⵏⵜ⵰ ⴹⴼⵔ ⵓⵏ ⵙⴹⵓ ⵏ⵿ⴶⵢ ⵙⵂⵏ ⵔⵤⴾⵓ ⵎⵛⵏ ⵓⵔ ⵜⵙⵎⵜⴾⵓⵢ ⴼⵍⵙ ⵜⵙⵍⵜ ⴼⵍ ⴹⴾⵔⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","«ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⵙⵙⵎⵏ ⵢⵓⵍⵏ ⵎⵛⵏ ⵓⵔ ⵙⵔⵙ ⵜⵎⵤⵍ ⵂⴰ ⵍⵎⵜⵍ ⵏⵓⴹⵏ ⴾⵔⵙⵏ ⵂⵏⵜ ⴹⴰ ⵓⵔ ⵜⵗⵤ⵰ ⵙⴹⵓ ⵏ⵿ⴶⵢ ⵙ⵿ⵜⵀⵙ⵰ ⵀⵔⵌⵜ ⵗⵔⴹ ⵂⵍⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⴹⵏ ⴾⵍ ⵢ ⵜⵎⵜⵢ ⵏ ⴶⵤ ⵜⵗⵔⵎ⵿ⵜ ⵏ⵿ⴾⴼⵔⵏⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵂⵜ ⴾⵀⵜⵏ ⵢⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏⵔⵎ ⵍⵏ ⴾⵍⵏⵜ ⴾⵏⴰ ⵜⵔⴰ ⵔⵏⵏ ⵀⴾ ⵢⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ⵙ ⵙⵍⴰ ⴾⵀⵜⵏⵏ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⵤⵎⵤⵍ ⵙⵔⵙ ⵔⵜ ⴹⵗ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴼⵍ ⵜⵏ⵿ⵙⵢⵏ ⴹⵙⵓ ⵤⵤⵢ ⴾⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ⵙⵏⵏ ⵗⵢⵙⴰ ⵏ⵿ⵙⵢⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵍⵙ ⴰ ⵂⵔ ⴹⵙ⵿ⵜⴶⵗ ⵜⵏⴼⵙ⵿ⵜ ⵜⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ⴼⵍⵙ ⵔⴰ ⵜⵎⵜⵢⵏⵏⴰ ⵏ⵿ⵜⴰ ⴼⴹⴰ ⴹⵏⵗⵙⴾⵔⵙⵏ ⵂⵏⵏⴰ ⵓⵏ ⵍⵗⵀⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ⵜⵤⵔ ⴹⵓ ⴹⵔⵙⵏ ⵗⵢⵙⴰ⵰ ⵙ ⴹⵏⵂⵤ ⵗⵢⵙⴰ ⵂⵏ ⵤⵎⵤⵍⴹⵓ ⵙⵔⵙ ⴾⵀⵜⵏⵏ ⵎⴹⵓⵏⵜ ⵢⴹⵙⵏⵏ «ⵎⵍⵢ ⴹ ⵓⵔ ⵜⵙⵍⵢⵗⵗ ⵎⵏⴾ ⵏⴾ ⵓⵔ ⵓⴹⵗ ⴹ ⵜⴶⵤⵗ ⵂⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ⴹⵢ ⴹⴰ ⴼⵍ ⴾⵢⵏⵓⵔⵙⵗ ⵏⴾ ⵎⵏⵏ⵰ ⵏⵓ ⵔⵜ ⵗⵙ ⴹ ⵤⵢ ⵎⵛⵗⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ⵙⵏⴰ ⴹⵗ ⴹⵢ ⴼⵍⵙ ⵓⴹⵏ ⵎⵙⵗ ⴹⵗ ⵜⴼⵏ ⵓⵢⴹ ⵜⵏⵜ ⵜⴼⵆⵜ ⵏⴾ ⵎⵏⵏ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⴹⵓⵢ ⵍⵏⵏ⵰ ⵙ ⵏⵗ ⵢⵢⵏ \"ⴶⵍ\" ⴹ ⴶⵍⵓ ⵙ ⵏⵗ ⵢⵢⵏ \"ⵢⵓ\" ⴹⴹⵙⵓ⵰ ⵙ ⵏⵗ ⵢⴾⵍⵏⵏ \"ⴶⵓ ⵓ\" ⴹ ⵜⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢⵓⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵎⵍⵍⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ ⵏⴰ «ⵏⵗⵓⵏ ⵓⵍⴰ ⴾⵍⵙⵔⵢⵍ ⵓⵔ ⴹⵗⵙⵏ ⵏⵢⵗ ⵓⴹⵏ ⴶⵏ ⵤⴶⵤⵏ ⵓⴹⵏ ⵓⴰ ⴶⴰ ⵍⵙ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ⵙ ⴹⵏⵆⵍⵏ ⵎⴹⵏ ⵓⵏ ⵎⵤⵍⵏⵏ ⵂⵏ ⵙⵏⵏ ⴾⵍⵢ ⵓⴰ ⵔⵏⵏ ⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ⴹⴼⵔ ⵓⵏ ⴾⴰ ⵗⵢⵙⴰ ⵗⵔⵎ ⵢⵏ ⴶⵏ ⵙⵎ ⵏⵢⵏ ⴹⵓⵏ ⴹⵔⵙ ⵏⵜⵍⵀⵏⵜ ⴹⵜⵎⵜⵢ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ⵙ ⴹⵏⵂⵤ ⵎⵢ ⵏⵗⵔⵎ ⵎⵏⵢ ⴹⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵓⵢⵏⵏ ⵏⵎⵜⵏ ⵢⵜⵏⵏⵀⵍⵏ⵰ ⵍⵙ ⵓⵏ ⵏⵎⵜⵏ ⵏ ⵓⵔ ⵜⵍⴰ ⵏⵏⵜ ⵔ ⵏ⵿ⵜⴰ ⵀⵏⵜ ⴹⵗ ⵓⵔ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ⵙ ⵜⵜⵏⵢ ⵎⵍⵢ ⵜⵙⵂⵏⵜⵜⵓ ⵏⵙ «ⵢⵓ ⵜⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ⴾⴹⵓ ⵏⵎⵜⵏ ⴹⵙ ⵜⵙⵜ ⵜⴰ ⴹⵗ ⵎⵓⵢ ⵀⴹⴹⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵢⵏⵏ ⵜⵤⵔ ⵏⴰ «ⵎⵓⴹ ⵏⵗⴾ ⵏ⵿ⴾⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ⵆⵎⴹⵓ ⵍⵙ ⵓⴰ ⵀⴰ ⵛⵓⵍ ⵙⵗⵍ⵿ⵜⵓ ⵗⵢⵙⴰ ⵢⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ⵔⵎⵗⵏ ⵢⵜⴹⵏ ⴾⵍ ⴹ ⵎⵍⵏ ⵎⵛⵏⴰ ⴶⵏⵏ «ⵏⵀⵢ ⵤⵓⵔⵏ ⴹⵏⴼⵍⵍⵏ ⴹⵗⵏⴰ ⵎⵛⵏⴰ ⵙⴹⵓ ⵜⵎⵜⵢⵏⵜ ⴼⵍ ⴹⵗⵙ ⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ⵜⵤⵔ ⵜⴼⵤⵜ ⵙⵍⵜ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴾⵜⵏⵜ ⴹⴾⵍⵏ ⵓⵏ ⵜⵗⵍⵢⵗⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ⴶⵔⵓ ⵢⵈⵢⴰ ⵙⵍⵏ ⵓⵏ ⴹⵏ ⴾⵍ ⵗⵔ ⵜⵍⵎⵜⵏⵜ⵰ ⵗⵔⴹⵓ ⵛⵏ ⴹⵗⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ⵤⵎⵤⵍ⵿ⵜⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⵢⴹⵙⵏⵏ «ⵓⴾ ⴾⵢ ⴹⴰ ⵓⵙ ⵏⵆⵍ ⵢⴹⵙⵓ ⵎⵗ ⴾ ⴹ ⵏⵙⴶⴹ ⵢⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ⵙ ⴹⵏⵙⵏ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴹⵏⴹⵤⵎⵤⵍⵏ ⵙⵔⴾ ⵏⴾ \"ⵓⴾ ⴾⵢ ⴹⴰ ⵓⵙ ⵏⵆⵍ ⵢⴹⵙⵓ ⵎⵗ ⴾ ⴹ ⵏⵙⴶⴹ ⵢⵢⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ⵙⵗⵜ ⵜⵏ ⴹⴰ ⵎⵏⵜ ⵤⵤⵢ ⴹⵗⵙ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⵜⵓⵔⵏⵓⵏ ⴹⵜⵍⵓⵢⵏ ⴹⴾⵍⵙⴼ ⵙⵙⵓⴹ ⴹⵗ ⵎⴹⵔⵗⵍ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ⵌⵓⵀ ⵗⵢⵙⴰ ⵢ ⵎⴹⵏ ⵓⵏ ⵙⵔⵙ ⴹⵎⵤⵍⵏⵏ ⵏⵙⵏ «ⵆⵍⵜ ⵢⵈⵢⴰ ⵜⵙⵗⵍⵎⵙ ⵓⴰ ⵜⵏⵢⵎ ⴹⵓⵙ ⵜⵙⵍⵎ ⵜⵏⵎⵙ ⵎⴹⵔⵗⵍ ⵂⵏⵢⵏ ⵏⵀⴹⵏ ⵌⵓⵏ⵿ⴾⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓ ⴾⵜⵔⵓ ⵤⵢⵏ ⵤⴹⴶⵏ ⵎⵤⴶⵏ ⴶⵔⵓⵏ ⵜⵙⵍⵢ ⵏⵎⵜⵏ ⵏⴾⵔⵏ⵿ⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵛⵍⵆⵓⵏ ⴹⵗ ⵙⵍⵏⵜ ⵢⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ⵀⵍⵍ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⴶⵎⴹ ⵤⴶⵤⵏⵜ ⴼⵍⵙ ⵓⵔ ⴶⴰ ⵛⴾ ⴹⵗ ⵓⴰ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ⵙ ⴶⵍⵏ ⵎⴹⵏ ⵓⵏ ⴹⵤⵎⵤⵍ ⵢⵈⵢⴰ ⵙⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵎⴶⵔⴹ ⵢ ⵜⵎⵜⵢ ⴹⵗ ⵀⵜⵓ ⵏⵢⵈⵢⴰ ⵏⴰ «ⵎⴰ ⵎⵙ ⵔⵜ ⵓⵙ ⵜⴾⵎ ⵙⴼ ⵢⵜⵜⵏⵢⵎ⵰ ⵓⴾ ⵜⵍⵏ⵿ⵜ ⵙⵓⵍⵓⵍ ⴹⵓ⵰ ⴾⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ⴹⵗ ⴹⵢ ⵎⴰ ⵜⴾⵎ ⵢⵜⴹⵜⵏⵢⵎ⵰ ⵓⴾ ⵍⵙ ⵍⵙⵏ ⵜⵀⴹⵆ ⵜⴾⵏⵜ ⵛⵂⵙⵢ⵰ ⴾⵍⴰ⵰ ⵏⵢⵜ ⵤⴰ ⵢⵜⴹⵏ ⵓⵏ ⵍⵙⵏⵏ ⵜⵀⴹⵆ ⵜⴰ ⵜⵂⵙⵢⵜ ⴶⵏ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵏⴼⵍⵢⵏ ⵏⵏ ⵏⵎⵏⴾⵍⵏ ⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ⴹⵢ ⵤⴰ ⵎⴰ ⵜⴾⵎ ⵢⵜⴹⵜⵏⵢⵎ⵰ ⵓⴾ ⵏⵀⵢ⵰ ⵓⵍⵏ ⵤⵙ ⵏⵀⵢ⵰ ⵎⵔⵏ ⵢⵈⵢⴰ ⴶⵔ ⵜⵛⵜ ⵏⵏⵀⵢ ⴼⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ⴼⵍⵙ ⵢⵈⵢⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ \"ⵏⵢ ⵤⴰ ⴹⵜⴾ ⵙⴶⵍⵗ ⵏⵎⵤⵍⵏ ⵤⴾⵏⵏ ⵜⵔⵢⵜⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ⵏⵗⵓⵏ ⵓⵔ ⴾⵍⴰ ⴹⵂⵓ ⵓⴹⵏ ⴶⵔⵏ ⵢⵈⵢⴰ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵓⵍⴰ ⵗⵙ ⵓⴰ ⴶⵔⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⴰ ⴶⵔ ⵢⵈⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵢⵈⵢⴰ ⵂⵔⴾⴹ ⵏⵀⵤⵏ ⵏⵎⵏⴰ ⴾⵍ ⵆⵀⵍⵏ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵜⵗⴹⵜ ⴹⵢ ⴼⵍ ⵔⴹⵏ ⵙⵍⵎⵆⵏ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ⵎⵛⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵏ⵿ⵜⵏⵢ ⵙⴾⵏⵏ ⵙ ⵜⴶⵢⵜ ⵜⴰ ⴶⵏ ⵙ⵿ⵜⵏⵙⵍⵎⵗ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ ⵀⴰ ⵏ⵿ⵜⵔⴹⵓⵜⵏⵙⵏ ⵙⵓⴰ ⵈⵜⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ⵏⴰ ⵗⵢⵙⴰ «ⵎⵙ ⵤⵎⵜⵍⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ⵰ ⵓⴾ ⵎⴰ ⴹⵔ ⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ⵍⵏ ⴹⵀⵔⵔⵏ ⵆⵎⵏⵏ ⴹⵗ ⵙⴾ ⵜⵏⵎⵗⵔⵏ ⴶⵏⵏ \"ⵏⵓⵜⵓⵏ ⵜⵏ⵿ⴹ ⵎⵛⵏ ⵓⵔ ⵜⵓⵗⵎ⵰ ⵏⴶⵓⵏ ⵙⴾⵏ ⵏ⵿ⵜⴼⵢⵓⵜ ⵎⵛⵏ ⵓⵔ ⵜⵍⵎ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«ⵏⵗⵓⵏ ⴹⵢ ⴼⵍⵙ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵙ ⴹⵙⴰ ⵙⴶⵜ ⵤⵎ ⵓⵔ ⵙⵙⵓ ⴹⵗ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵜⵏⵎ ⴶⵙⴼ ⵜⵤⴹⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ⵎⵔⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵙⴹⵓ ⵜⵜⴰ ⵙⵙⴰ ⵎⵛⵏ ⵜⵏⵎ \"ⵏⵓⵜ ⵍⵙ ⵓⵏ ⵏⵎⵓⵍⵢ ⵏ ⵙⵙⵏ ⵙⵎⴹ ⵙⴶⵜ ⵎⵙ ⵎⴹⵢ ⵏⵀⵤⵏ ⵏ⵿ⵜⴾⵙⵏ ⴹⵔⴾ ⵢⵜⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ⵎⵙⵏⵜ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵎⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⵏⵢ ⵙⵜⴹⵏⵏ ⵆⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ⴶⵎⵢ ⴼⵔⵙⵢ ⵢⵏ ⴹⵗ ⵗⵢⵙⴰ ⵗⵔⵙ ⵜⵛⵓ⵰ ⵜⵤⵔ ⴾⴰ ⵗⵢⵙⴰ ⵂⵏ ⵏ⵿ⴼⵔⵙⵢ ⵓⵏ ⵙⵗⵎⵔⵏ ⴹ ⵜⵎⵏ⵿ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ⵓⵍⴰ ⵂⴶⵏ ⵜⵔⵤⴹⵓ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵏ⵿ⵜⵏⵙⵀⴾⴹⵜ ⵜⵂⵜ ⵗⵔⵎⵏ ⴹⴰ ⵜⵙⵍⵜ ⵙ ⵗⵢⵙⴰ ⵎⴶⵔⵜ ⵢ ⴼⵔⵙⵢ ⵓⵏ⵰ ⵙ ⴹⵜⵙⴰ ⵜⵓⵢ ⵀⵜⵍⵢ ⵏⵍⵓⵔⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ⵜⵎⵍⴹⵓ ⴹⴼⵔ ⵗⵢⵙⴰ ⵗⵔ ⴹⵔⵏⵜ ⴹ ⵜⵂⵍⵓ ⵂⵔ ⵜⵙⵀⴹⴶ ⴹⵔⵏ ⵏ⵿ⵗⵢⵙⴰ ⵙ ⵎⵜⵓⵏⵜ ⵜⵎⵙ⵿ⵜⵏ ⵙ ⵌⴾⴹⵏⵜ⵰ ⴹⵙⵏ⵿ⵜⵜⵎⵍⵜ ⵜⵏⵆⵍ ⴼⵍⵙⵏ ⵍⵓⵔⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ⵙ ⵏⵢ ⴼⵔⵙⵢ ⵓⴰ ⵙⵎⴶⵔⵏ ⵗⵢⵙⴰ ⵓⵏ ⵏⴰ ⴹⵗ ⵎⵏⵜ «ⵏⵔ ⵎⵙ ⵍⵙ ⵏⵀⵢ ⵙⵏ ⵙ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵜⴹⵙⵜ ⴹⴰ ⵜⵏⵙⵀⴾⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ⵏⵙ ⵗⵢⵙⴰ «ⵙⵎⵗⵏ ⴹⴾⵏⵗ ⵔⵜ⵰» ⵏⵙ ⵙⵎⵗⵏ «ⵛⵓⵍ ⵛⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ⵏⵙ ⵗⵢⵙⴰ «ⴾⵍⴰ ⵜⵍⴰ ⵍⵙ ⵢⵏ ⵔⵓⵙⵏ ⵛⵏ ⵎⴹⵏ⵰ ⵢⵏ ⵔⵓⵙ⵿ⵜⵓ ⵙⵎⵙⵜ ⵜⵎⴹ ⵏ⵿ⵜⵎⴰ ⵏⵤⵔⴼ ⵓⴰ ⵂⴹⵏ ⵔⵓⵙ⵿ⵜⵓ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ⴹⴹ ⵓⵔ ⵍⵏ ⵙ ⵔⵤⵎⵏ ⵢⵙⵏ ⵓⴰ ⵜⵏⵔⵓⵙ⵰ ⵓⴾ ⵎⴰ ⵜⵏⵗ ⵎⵏⵢ ⴹⵗⵙⵏ ⵓⴰ ⵜⵤⵔⵏ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ⵏⵙ ⵙⵎⵗⵏ «ⵔⴹⵗ ⵙ ⵓⵙ ⵢⴰ ⵎⵔⵓⵙ ⵓⴰ ⴶⵏ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⵜⴹⵜⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ⵎⵔⵏ ⵎⵍⵍⵢⵏ ⵜⵏ⵿ⵜⵜ ⵜⵤⵔ ⵏⴰ ⵢ ⵙⵎⵗⵏ «ⵜⵂⵏⵢⵗ ⵜⵏ⵿ⵜⵜ ⵜⴰ⵰ ⵙ ⴹⴶⵤⵗ ⵂⵏⴾ ⵓⵔ ⴹⵜⴾⴼⵗ ⵎⵏ ⵙ ⵛⵔⴹⴰ ⴹⵔⵏⵏ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵜⵙⵀⴹⴾⵏ ⵙ ⵎⵜⵓⵏⵜ ⵜⵎⵙ⵿ⵜⵏ ⵙ ⵌⴾⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ⵙ ⴹⵙⵗ ⵂⵏⴾ ⵓⵔ ⴹⴹⵜⵙⵍⴾⴹⴰ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⴹⵙⵗ ⵜⵜⵎⵍⵜ ⵢ ⴹⵔⵏⵏ ⴼⵍ ⵙⵗⵎⵔ ⴹⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ⴾⵢ ⵓⵔ ⵜⵤⵓⵢⵗ ⵗⴼⵏ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⴹⵔⵏⵏ ⴼⵍ ⵜⵏ⵿ⵗⵍ ⵍⵓⵔⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ⴹⵢ ⴼⵍ ⴹⴾⵏⵗ ⵜⵔⴰ ⵤⵓⵔⵜ ⵜⴰ ⴹⵜⵙⴾⵏⴰ ⵜⵙⵜⴹⴰ ⵙ ⵀⴾⴹⵏⵜ ⵜⵓⵙⵔⴼⵏⵙ ⴾⵍ ⴾⴹⵗ ⴶⵜⵏ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵏ⵿ⴹⵔⵏ ⵏ⵿ⵜⴰ ⵜⵔⵏⵜ ⵛⵢ ⵏ⵿ⴹⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⵏ «ⵀⴾⴹⵏⵎ ⵜⵓⵙⵔⴼⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ⴹ ⴶⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵙ ⴹⵔⵓⵏⵏ ⵎⵏ⵿ⵙⵓⵏ ⴹⵗ ⵎⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵓⴰ ⴹⵗ ⵓⴹⵏ ⵙ ⵓⵍⴰ ⵀⴾⴹⵏ ⵙⵔⴼ⵿ⵜⵏ ⵢⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⵏ «ⵤⴶⵤⵏⵎ ⴾⵎⵗⵍⵙⵏ ⴶⵍⵓ ⴹⵗ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ⴹⴼⵔ ⵓⵏ ⵍⵍ ⵗⵢⵙⴰ ⵗⵔⵎⵏ ⴹⵜⵗⵔⵎⵜⵏ ⵎⵍ ⵢⵢⵜⴹⵏ ⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⴹⵓⵏ ⴹⵔⵙ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ⴹⵓ ⴹⵗ ⴹⵜⴹⴹⵏ ⵙ ⵛⵢⴹ ⴾⵍⵙⴼ ⴹⵗⵙⵏⵜ ⴾⵙ ⵛⵢⴹ ⵛⵓⵔⵏⵓⵏ ⴹⵆⵏⵜ ⵤⵤⵢ⵰ ⵎⵙⵏⵜ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⵙⵏ⵿ⵜⴰ ⴹⴶⵎⴹⵏ ⵙⴰ ⴾⵍⵙⴼ ");
INSERT INTO ttqt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ⴹⵌⵏⵜⴰ ⵜⵏ ⵜⵏ⵿ⵜⵜ ⵏⵈⵤⴰ ⵓⴰ ⵏⵜⴼⵏ ⴹⵜⵗⵓⵛⵓⵏ ⵏⵎⵏⴾⵍ ⵂⵔⴹ ⴹⵙⵤⵏⴰ ⴹⵛⵢⴹ ⵛⴹⴹⵏ ⴶⵜⵏⵏ⵰ ⴾⵜⵏⵙⵏⵜ ⴹⵂⵍⵏⵜ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵙⵓⴰ ⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ⵓⵔ ⵜⵍⴰ ⵗⵔⵎ ⴹⵓⵔⴶⵎⴹⵏ ⵢⵜⴹⵏ ⵜⴾⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵜⵤⵔ ⵜⴶⴰ ⴼⵍⵙ ⵜⴹⵓⵜ ⵜⴶⵜ ⴶⵙⵏ ⵍⵎⵜⵍ ⵓⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ⴾⵍⴰ ⴹ ⴶⵍⴰ ⵎⴶⵢⴾ ⵢⵏ ⵢⴹ ⵏⵀⵍ ⵎⵙⵏⵜ⵰ ⴹⵗ ⵏⵀⵍ ⵓⴰ ⵜⴶⵓ ⴹⵏ ⵎⵙⵏ ⵏⵀⵙ ⵏⵎⵙⴰ ⵔ⵿ⵜⴾⵏⵜ ⵜⵀⵍⵍⵏ ⵛⵢⴹ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵜⵤⵔ ⴾⴾⵍⵏ ⴹⵗⵙⵏⵜ ⵢⵜⴹⵏ ⵜⵛⵏ⵿ⵜⵏⵜ ⴶⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⴹⴶ ⵂⵏⵜ ⵜⵂⵏ⵰ ⵙ ⴹⴶⵎⴹⵏⵜ ⵆⵔⵏⵜ ⴼⵍ ⵀⴰ ⵏⵀⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⵜⴼⵙⵗ ⴹⵓⵍⵏⵜ ⴹⵔⵙⵏⵜ ⵍⵎⵤⵏⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ⵛⵢⴹ ⵔ⵿ⵜⴾⵏⵜ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ ⵜⵤⵔ ⴹⵓⵍⵏⵜ⵰ ⴾⵍⴾ ⵏ⵿ⵜⵀⵍⵍ⵿ⵜ ⵜⵔⵓ ⵜⵎⴹⵢ ⵏⵢⵜ⵰» ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵓⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵓⴰ ⵙⵍⵏ ⵙⵙⵎⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ⴹⴼⵔ ⵓⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⴹⵍⵎⵗⵏⴰ ⵏⵍⵎⵜⵍ ⵓⴰ ⴶⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ⵏⵙⵏ «ⴾⵓⵏⵢ ⵜⴶⵔⵓⵎ ⵎⵙⵏⵜ ⴹⵗ ⵙⵔⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵏ⵿ⴶⵍⵏ ⵙ ⴹⵙⵏⵜⵎⵍ ⵙⵔ ⵓⴰ ⴼⵍ ⴹ ⵆⵍ ⵙ \"ⵙⵓⴹⵏ ⵎⵛⵏ ⵓⵔ ⵂⵏⵢⵏ⵰ ⵙⵙⵎⵏ ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ⴶⵍⴰ ⵗⵢⵙⴰ ⵛⵓⵍ ⵏⵙⵏ «ⵍⵎⵜⵍ ⵓⴹⵢ ⵍⵎⵗⵏⵏⵜ ⴹⴰ ⵎⵙⴰ ⵍⵎⵜⵍ ⵎⵙ ⵏⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴼⵍ ⵜⵎⴰ ⵏ⵿ⵜⵔⵢⵜ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵎⵛⵏ ⴹ ⴹⵙⵓ ⵀⵍⵙ ⴾⵙ⵿ⵜⵓ ⴹⵗ ⵓⵍⵏⵙⵏ ⴼⵍ ⴹ ⵓⵔ ⵤⴶⵤⵏⵏ ⴶⵔⵓⵏ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵜⵂⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵆⵀⵍⵏ⵿ⵜⵓ ⵙ ⵎⵏ ⴼⵍⵓⵙⵏⵏ ⵎⵛⵏ ⵓⵔ ⵍⴰ ⵓⵏ ⴾⵢ ⵤⴶⵤⵏⵙⵏ ⵓⵔ ⵜⵂⴶ⵰ ⵙ ⵜⵓⵌⵔⵀⵏ ⵜⵏⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⴹⵗ ⵜⴼⵙⵗ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵆⵀⵍⵏ⵿ⵜⵓ ⵎⵛⵏ ⵙ ⵜⵏⴹⴶⵤⵏ ⵛⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴹⵜⵔⴰ ⵏⴹⵏⵜ ⴹⵔⴾ ⴹⵔⵏⵏ ⵙⴼⵍⵏ⵿ⴹⵓ ⴹⵏⴶ ⵓⵍ ⵓⵏ ⴹ ⴶⴹⵍ ⵓⵏ ⵢⵤⴶⵤⵏⵙⵏ ⵍⴾⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ⵎⵙⴰ ⵓⴰ ⵔ⵿ⵜⴾⵏ ⵎⵔⵏ ⴹⵗ ⵎⴹⵍ ⵍⵗⵏ ⵍⵎⵜⵍ ⵎⵙ ⵏⵢⵜⴹⵏ ⵓⵏ ⵙⵍⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵍⵏ ⵓⵍⵏ ⵍⵗⵏⵏ ⵍⵎⴹⵏⵏ ⵜⵤⵔ ⵆⵀⵍⵏ⵿ⵜⵓ ⵜⴼⵏ⵿ⵜⵓ ⵙⵍⵗ ⵜⴶⵎⴹⵜⵏ⵿ⴹⵓ ⵜⵏ⵿ⴼⴰ ⴼⵍⵙ ⵤⵎⵔⵏ ⵢⵔⵜ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙⵔⵗⵏ ⴼⵜⵍⴰ ⵜⵤⵔ ⵙⵀⵏⵀⵢ ⴼⵍⵙ ⵗⵤⵓ ⵎⴹⵗ ⴶⵜ ⴹⵓ ⵜⵙⵜ⵰ ⴾⵍⵔ ⵛⵍⵢ ⵜⵜⵜⴶⵓ ⵜⵛⵛⵍⵢⵜⵏⵜ ⴼⵍ ⴹ ⵏⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵜⴶⵤⵏⵏ ⵂⵏ ⵙⵏⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ⵓⵔ ⵜⵍⴰ ⵗⵀⵔⵏ ⵙ ⵓⵔⴶⵗ ⴹ ⴼⴶⵓ ⵓⵍⴰ ⵢⵏ ⵙ⵿ⵜⵔⵏ ⵙ ⵓⵔⴶⵗ ⴹⵏⵏⴼⵍⵍ ⵜⵓⵙⵏ ⵤⵍ ⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⵢⵎⴾ ⵓⵙ ⵜⵙⵙⵎⵎ⵰ ⵓⴹⵏ ⵓⴰ ⵍⵏ ⴹⵙⵜⵓⵛⵜⵓ ⵓⴰ ⵍⴰ⵰ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵎⵔⵏ ⵔⵜ ⵏⵓⵙ ⵗⵍ ⵍⵢ ⴹⴰ ⴹⵗⵙ ⵜⵔⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ⵜⵙⴹⵓ ⵏⴰ ⵏ⵿ⵗⵢⵙⴰ ⴹⵎⴹⵔⵢⵏⵜ ⵎⵛⵏ ⵔⵏⵏ ⵜⵏⵓⴹⵏ ⴼⵍ ⴶⵜ ⵏ⵿ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ⵜⵓⵏⵙ «ⵏⵏⴾ ⴹⵎⴹⵔⵢⵏⴾ ⵀⴹⴹⵏⴾ ⵔⵏ ⵏⵢⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵏⵏ ⴹⵎⴹⵔⵢⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵙⵎⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵜⵎⵤⵍⵏ ⵙⵓⴰ ⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ⵤⵍ ⵢⵏ ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ⵏⵙⵏ «ⵏⵗⵔⵙⵜ ⴶⵔⵓ ⵙ ⵜⴶⴹⵎⵢⵜⵏⵜ ⵜⴰ ⵂⴹⵜ⵰» ⵜⵤⵔ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ⴶⵍⵏ ⴼⵍ ⵎⵏ ⵙ ⴹⵏⵀⵤ ⵜⵙ ⵗⵢⵙⴰ⵰ ⵓⵍⴰ ⵂⴶⵏ ⴶⵔⴹⵓ ⴹⵓ ⵙⵂⵏ ⴼⵍ ⴶⵔⵓ ⴹ ⴹⴾⵔ ⵗⵍⵍ ⵎⵏ ⴶⵤⵏ ⵤⴶⴰ ⵏ⵿ⵜⵏⵜⵛⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ⵂⵤⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵜⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵙ ⴶⵏⵏ ⵙ «ⵛⵈ ⵛⵈ ⵏⵂⵍⴾ⵰» ⵏ⵿ⴾⵔⴹⵓ ⵗⵢⵙⴰ ⵙⵏⵔⵗⵎ ⵢⴹⵓ ⴹⵜⵏⵤⵎⵔⵏ ⵜⴾⵏⵏ ⵌⵏⵓⵏ ⵜⵤⵔ ⵀⴹⴹ ⴹⵓ ⴹⵔⵔ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ⵎⵔⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⴰ ⴶⴰ ⵤⴶⵤⵏⵓⵏ⵰» ⵙⵔⵎⵆⵏ ⵓⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ⵰ ⴹ ⵜⵏⵎⵏⵏ «ⵎⴰ ⵎⵙ ⵓⴰ ⴹⵗ ⵓⴹⵏ ⵙ ⵓⵍⴰ ⴹⵓ ⴹⵎⵏ ⵜⴼ ⴹⵗⵙⵏ ⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ⴹⴼⵔ ⵓⵏ ⵓⴹⵏⵏ ⴾⵍ ⵏ⵿ⴶⵔⵙⵏⵜⵏ ⵏⵎⵗⵍⵢⵏ ⴶⵔⵓ ⴹⴾⵍ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ⴹⴰ ⴹⴰ ⵗⵙ ⴹⵤⵀⵜ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⵙⴹⵙⵍⴾⴹ ⵍⵙ ⵢⵏ ⵂⵏ ⴾⵍⵙⴼ⵰ ⵍⵙ ⵓⵏ ⵏ ⵗⵔⵎ ⵂⵏ ⴾⵍⵏ ⴹⴰ⵰ ⵔⵓ ⵙ ⵙⵏ⵿ⵙⴰ ⵙⵍⵙⴰ ⴶⵎⴹ ⵗⵢⵓⵏ ⵈⵙⵔ ⴹⵗ ⵤⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ⵏⵢ ⵗⵢⵙⴰ ⵗⵙ ⴹ ⵜⴾⵙ ⵎⵙⵍⵏ ⵍⵀⵙⵏⵏ ⵜⵤⵔ ⵙⵌⴹ ⵢ ⵗⵢⵙⴰ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⵏⴰ «ⵢⴰ ⵗⵢⵙⴰ ⵓⵏ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⵎⴰ ⴹⵗⵢ ⵜⵔⵗ⵰ ⵏ⵿ⵙⵢⵆⵢ ⴹⵓⵔ⵿ⵜⵤⵗⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ⵏⴰ ⵓⵏ ⴼⵍⵙ ⵗⵢⵙⴰ ⵎⵔⵏ ⴶⵙⴼ ⵓⴰ ⵜⵂⵏ ⵙ⵿ⵜⴹⴶⵎⴹ⵰ ⵢⵓⵏ⵿ⴹⵓ ⵙⵔⵙ ⴶⵙⴼⵏ ⵙⵏ⵿ⴾⵔ ⴾⵔⴹⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⵙ ⵙⵙⵔⵏ ⴹⵜⵤⵀⴶⵓⵏ ⵎⵛⵏ ⴹ ⵗⵜⵙ ⵓⵏ ⴾⵍ ⵓⵢⵜⵓ ⴶⵙⴼ ⵙⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵗⵢⵙⴰ ⵏⵙ «ⵎⴰ ⵙⵎⵏⴾ⵰» ⵌⵓⵀⵙ ⵏⵙ «ⵙⵎⵏ ⴶⵏ⵰» ⵏⵙ ⵍⵙⵏ ⵓⵏ ⴼⵍⵙ ⴾⵍⵙⴼ ⴶⵜⵏⵏ ⵜⵂⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ⴹ ⵜⵏ⵿ⵙⵢⵏ ⴾⵍⵙⴼ ⵓⵏ ⵜⵂⵏⵏ ⵗⵢⵙⴰ ⵜⵏⵓⵔⵙⴾⵓ ⵏⵓ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ⵍⵜⵓ ⵙⴶⵏ ⴶⵏ ⵏⵍⴹⵢⵏ ⴹⵏⵏ ⴼⵍ ⵜⵙⴶⴰ ⵏ⵿ⵜⴾⵛⵓⵔ⵿ⵜ⵰ ⵏ⵿ⵙⵢⵏ ⴾⵍⵙⴼ ⵗⵢⵙⴰ ⵢⵜⵏⴾⴼⵓ ⵜⵔⴶⵜ ⵏⴹ ⴶⵤⵏ ⵍⴹⵢⵏ ⵏ ⴾⴼⵙⵏ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⵍⵙ ⵏ ⴶⵤⵏ ⵍⴹⵢⵏ⵰ ⵜⵤⵔ ⵤⵍⵏ⵿ⴹⵓ ⵍⴹⵢⵏ ⴼⵍ ⵤⴶⴹⴰ ⵏ⵿ⵜⴾⵛⵓⵔ⵿ⵜ ⴹ ⵜⵜⵔⴶⵜⵔⴶⵏ ⴹⵗ ⴶⵔⵓ ⵜⵜⵏ⵿ⵜⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ⵙ ⵏⵢⵏ ⵎⴹⵏⵏ ⵏⵍⵢⴹⵢⵏ ⵓⴰ ⴶⵏ ⴹⵏ ⵤⵍⵏ ⴶⵏ ⵙⵍⵏ ⵏⵓⵏ ⴹⵗ ⵗⵔⵎⵏ ⴹⵗⵍⵢⵗⵍⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ⴶⵍⵏ ⵢⵜⴹⵏ ⵢⴹ ⵏⵢⵏ ⵓⴰ ⴶⵏ⵰ ⵙ ⴹⵏⵙⵏ ⵗⵢⵙⴰ ⴶⵤⵏⵏ ⵗⵔⵙ ⵍⵙ ⵓⴰ ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⵆⵎ ⵗⵔ ⴹⵔⵏⵜ ⵍⵙⴰ ⵜⵆⵍ⵿ⵜⴹⵓ ⴹⵗ ⵜⵢⵜⵢⵏⵜ ⵜⵤⵔ ⵜⴶⵤⵜⵏ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ⴶⵏ ⴹⵗⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵢⵜⵏⵏ ⵢⵓⵏ ⵙⵍⵏ ⵏⵎⴾ ⵓⵙ ⵜⵓⵙⴼⵙⴰ ⵍⵙ ⵓⴰ ⴹⵗ ⵜⵓⴾⵙⵏ ⴾⵍⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴾⵍ ⵏ⵿ⴶⵔⵙⵏⵜⵏ ⴹ ⴶⵎⵢⵏ ⴹⵗ ⵗⵢⵙⴰ ⵜⵏⴶⴶ ⴼⵍⵙ ⵜⵙⴰ ⵜⵏ⵿ⵜⴶⵤⵜ ⵤⵓⵔⵜ⵰ ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⵍ ⵏⵎⵏ ⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ⵏ⵿ⵙⵢⵜⵓ ⵍⵙ ⵓⴰ ⴶⵎⴹⵏ ⴾⵍⵙⴼ ⴹ ⵜⵢⵓ ⴹⵔⵙ ⴹⵓ ⵎⵛⵏ ⵙⵗⵍ⵿ⵜⵓ ⵗⵢⵙⴰ ⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«ⵆⵍ ⵂⵏⴾ ⵜⵎⵍⴰ ⵢⵢⵜⴹⵏ ⴾⵜ ⵏⵔⵈⵎⵜ ⵜⴰ ⴹⴾⴶⴰ ⵎⵛⵏⴰ ⴹⴰ⵰» ⵜⵤⵔ ⴶⵍⴰ ⴹ ⵎⵍ ⴹⵗ ⵗⵔⵎⵏ ⴾⵜⵏⵜ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵙⴶⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ⵙ ⵆⵍ ⵗⵢⵙⴰ ⵙⵍⵎ ⵓⴰ ⵂⴹⵏ ⵏⴶⵔⵓ ⵜⵙⵍⴾⴹⵙⴹⵓ ⵜⵎⵜⵢ ⵙ ⴾⵜⵏⵜ ⵜⵆⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹⵙⴰ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵌⵢⵗⵙ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵎⵤⵔⵏ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ⵰ ⵙⵌⴹ ⴹⵜ ⵗⵢⵙⴰ ⴹ ⵜⵜⵏ⵿ⵙⵢ ⴹ ⴹⵓⵏ ⵙⵂⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ⴼⵍⵙ ⵍⵙ ⵜⵎⵙⵜ ⵓⵍⵜ ⵎⵔⵓ ⵍⵏ ⴹⵛⵏ ⵙⵏ⵿ⵜⴰ ⵗⵙ ⵍⴰ ⵜⵀⴾⵜ ⵢⵀⴰ⵰ ⴹⵓ ⴹⵔⵙ ⵗⵢⵙⴰ ⵜⵜⵏⵀⴹⵗ ⴼⵍⵙ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ⵜⵎⵜⵢⵏ ⵜⵂⵜ ⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⵎⵔⵓ ⵍⵏ ⴹⵛⵏ ⴶⵎⴹⵜⵜ ⵤⵏⵢ⵰ ⵜⵏ⵿ⵗⴰ ⵜⵍⵏⵜ ⴾⵍ ⴹⵗ ⵏⵙⵎⴶⵍⵏ ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴼⵔⴶⵏ ⵤⵤⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ⵜⵂⵤⴹⵓ ⵗⵢⵙⴰ ⵙⴰ ⵙⵔ ⵜⵗⵔⴹⵏ ⵜⴹⵙ ⵜⵀⵏⴾ ⵏ⵿ⵜⴾⴹⴾⵜⵏⵜ ⵤⴾⵜ ⵤⵏⵢ ⵓⴰ ⵜⵜⴶⵎⴹⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ⵜⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ «ⵎⴰ ⴹⴹⵙⵏ⵰» ⴶⴹ ⵓⴹⵏ ⴾⵍ ⵙ ⵜⴹⵙ ⵎⵔⵏ ⵏⵙ ⵀⵜⵔⵙ «ⵛⵈ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵙ ⴾⵢⵜⵗⵍⵢⵗⵍⵢ ⵜⵙⵙⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ⵎⵛⵏ ⵢⴰ ⵏⴰ ⵗⵢⵙⴰ «ⵓⴹⵏ ⵢⵏ ⴹⵙⵢ ⴼⵍⵙ ⴼⵔⵢⴰ ⵢ ⵜⵔⵏⴰ ⵢⵜ ⵙ ⴹⵜⴶⵎⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ⵙ ⵜⵙⵏ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵙ ⵜⴼⴶⴰ ⵜⴾⴹⵓ ⵗⵢⵙⴰ ⵜⵏ⵿ⴹⵓⵜⵜ ⵜⵢⵙⵙ⵿ⵜ ⵜⵙⵌⴹ ⴹⵜⵙ ⵜⵎⵍⵙ ⴹⵜ ⵢⵜⴹⵏ ⴾⵍ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵜⵜⴹⵙ ⴹⵜⵎⵤⵢⵜ ⵜⴰ ⵜⴶⴰ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ⵏⵙ ⵗⵢⵙⴰ «ⵜⵀⵔⵔ⵿ⵜⵏ ⵤⴶⵤⵏⵎ ⵙⵔⵢ ⴾⵎⵤⵤⵢⵏ ⴶⵍⵓ ⴹⵗ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵗⵢⵙⴰ ⵙ ⴹⵙⴰ ⵓⴹⵏ ⵢⵏ ⴹⴼⵍⵏ ⵗⵢⵓⵏ ⵏ⵿ⵌⵢⵗⵙ ⵓⵏ ⵎⵤⵔ ⵏⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⵙ «ⵍⴾ ⵀⵜⵜ ⵎⵤⵢ ⴹⴹⴶⵤ ⵏⵛⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ⵙⵍⴰ ⵗⵢⵙⴰ ⵢⵓⵏ ⵏⴰ ⵢ ⵌⵢⵗⵙ «ⴹ ⵓⵔ ⵜⵔⵎⵗⴰ ⵤⴶⵤⵏ ⵗⵙ ⵍⴾ ⴹ ⵜⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ⵙ ⴹⵏⵓⴹ ⵗⵢⵙⴰ ⵂⵏ ⵏ⵿ⵌⵢⵗⵙ ⴶⴹⵍ ⵢⵢⵜⴹⵏ ⴹ ⵜⴶⵤⵏ ⵓⵔ ⵢⴰ ⵔ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⴹⵢⵆⵀ ⴹⵀⴰ ⵏ⵿ⵜⵀⵔⵔ⵿ⵜ ⴹⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵂⵍⵏ ⵙⴾⵍⵍⵏ ⴼⵍ ⵜⵀⵔⵔ⵿ⵜ ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵢⵓⵜ ⵜⵍⴰ ⵜⵀⵔⵔ⵿ⵜ ⵓⵔ ⵜⵜⵀⴰ ⵜⵙ ⵗⵙ ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ⴹⵗⵙ ⵜⵌⵀⵏ ⴼⵍⵙ ⵙⵏⵏ ⵙ ⵓⵔ ⵜⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ⵜⵤⵔ ⴶⵤ ⵗⵢⵙⴰ ⴼⵍ ⵜⵀⵔⵔ⵿ⵜ ⵀⵤ ⴼⵙⵏⵜ ⵗⵔⵜ ⵏⵙ «ⵜⵀⵔⵔ⵿ⵜ ⵏ⵿ⴾⵔⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ⵆⵍⵏ⵿ⵜⵜⴹⵓ ⵎⵏⵜ ⵜⵀⴹⴹⵓ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵜⵤⵔ ⵎⵔ⵿ⵜⵏ ⵗⵢⵙⴰ ⵙ⵿ⵜⵜⴾⴼⵏ ⵜⵜⵛⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ⵂⴶⵏ ⵎⵔⵓⵏ ⵏ⵿ⵜⵀⵔⵔ⵿ⵜ ⵎⵛⵏ ⵔⵗⵎⵙⵏ ⵗⵢⵙⴰ ⴼⵍ ⵎⵍ ⵏⵓⵏ ⵢⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴾⴼⵏ ⵜⵔⵏⴰ ⴹⵍⵈⴾⵎ ⴼⵍ ⴾⵍⵙⴼ ⴾⵍ ⴾⴼⵏ ⴹⵗ ⴼⵔⴶⵜ ⵏⵤⵤⵢ ⵏ⵿ⵜⵓⵔⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ⵤⵎⵤⵍ⵿ⵜⵏ ⵢⴹ ⴶⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵤⵤⵢⵏ ⴹⵗ ⵎⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⵓⵢⵎ ⵓⵍⴰ ⴹⵗ ⵛⴾⵍ ⴶⵔ ⵤⵆⵍ ⵜⵍⵆ ⵓⵍⴰ ⵗⵔⴶ ⵓⵍⴰ ⵍⵓ ⵓⵍⴰ ⵤⵔⴼ ⵓⵍⴰ ⴹⵗ ⴾⵢⵏ ⵜⴾⴹⴾⵜ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ⵙ ⴹⵏ⵿ⵜⵙⵎ ⵗⵔⵎ ⵂⵏ ⵓⴰ ⵜⴶⵤⵎ ⵙⵎⴶⵔⵜⴾⵓⵏ ⵤⵀⵜⵜ ⴹⵗⵙ ⵂⵔ ⵜⴶⵎⴹⵎ ⵗⵔⵎ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ⵗⵔⵎ ⵜⴶⵤⵎ ⵓⵔ ⴾⵓⵏⵆⵀⵍⵏ ⵢⵜⴹⵏⵜ ⵙ ⵜⵜⴶⵎⴹⵎ ⵜⵀⴾⵀⴾⵎⵏ ⴶⴹⵔⵔⵏⵜ ⵓⴰ ⵓⵔⵏ ⴹⵔⵏⵓⵏ ⵍⴾⵎ ⴹ ⴶⵢⵜ ⵓⵏ ⴼⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ⴶⵍⵏ ⵏⵜⵍⵀ ⵍⵍⵏ ⵛⵗⵔⵎⵜⵏ ⴹ ⵎⵍⵏ ⵍⵏ⵿ⵌⵍ ⴹⵗ ⴹⴶ ⴾⵍ ⵤⵤⵢⵏ ⴹⵗⵙ ⴹⵗ ⵎⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ⵙⵍⴰ ⵂⵔⴹ ⵓⵏ ⵎⵤⵔ ⵏⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵜⴶⵓ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵆⵏ ⵓⵏ ⵗⴼⵏⵜ ⴼⵍⵙ ⵍⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⴶⵏⵏⵏ ⵙ ⵗⵢⵙⴰ «ⵓⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ⵓⵢⴹ ⴶⵏⵏ «ⵓⵏ ⵏⵀⵢ ⵍⵢⵙ ⴹⵤⵀⵏ⵰» ⵓⵢⴹ ⴹⵗ ⴶⵏⵏ «ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵀⵜⵏ ⵓⵏ ⵔⵓⵏⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ⵏⴰ ⵂⵔⴹ «ⵢⵈⵢⴰ ⵏⴾ ⵎⵏⵏ ⴹⵙⴼⵔⵙⵏ ⵗⴼⵏⵜ ⴹⵗ ⴹⵢ ⵎⴰ ⵎⵙ ⵍⵙ ⵓⴰ ⴼⵍ ⵙⵍⵗ ⵔⵜⵏ ⵓⵏ⵰» ⴹ ⴶⵎⵢ ⵂⵔⴹ ⴹⵏⵢ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ⵆⵍⵏ⵿ⴹⵓ ⵏⵎⵤⵍ ⵙⵗⵍⵏ ⵢ ⵗⵢⵙⴰ ⵓⴰ ⴶⵏ ⴾⵍ⵰ ⵜⵤⵔ ⴶⵎⴹ ⴹⵔⵙⵏ ⵢⵜⴹⵏ ⵙⴹⴶ ⵙⴼⵏ ⴹⵏⴾⵜⵢⵏ ⵂⵏ ⵏⵎⴹ ⵏ⵿ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⵙⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ⵎⵛⵏ ⵜⵙⵍⴰ ⵜⵎⵜⵢ ⵓⵏ ⵜⵍⴾⵎⵙ⵰ ⴶⵙⵏ ⵗⵢⵙⴰ ⵎⵔⵈⵀⴰ ⵜⵤⵔ ⵛⵓⵍⵙⵏ ⴹⵗ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵤⵤⵢ ⴹⵗⵙⵏ ⵓⵏ ⴹⵔⵔⵏⵏ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ⵙ ⵜⵀⴾ ⵜⴼⴾ ⵢⴶⴹⵍ ⵂⵤⵏ⵿ⵜⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵏⵏⵙ «ⵙⵗⵍ ⵜⵎⵜⵢ ⴰ ⴹ ⵜⴾⵓ ⵛⵗⵔⵎⵜⵏ ⴹⵗⵓⵏⵜⵏ ⵓⵏ ⵂⵤⵏⵏ ⴹ ⵜⴶⵎⵢ ⴹ ⵜⵏ⵿ⵙⴰ ⴹⵜⵜⵛⴰ ⴼⵍⵙ ⴹⴶ ⵙⴼⵏ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ⵏⵙⵏ «ⵙⵜⵛⵜⵏ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⴰ⵰» ⵏⵏⵙ «ⵏⴾⵏⵢ ⵓⵔ ⵏⵜⴼ ⵔ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⴹⵛⵏ ⴾⴼⵜⵏ ⴾⵏ⵿ⴹⵀⴰ ⵤⴰ ⴹ ⵏⴶⵍⴰ ⵏⵤⵏ⵿ⵤⴹⵓ ⵎⵏ⵿ⵙⵓⵏ ⵢ ⵜⵈⵍⴾ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ⴹⴶ ⵏ⵿ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ ⵍⵏⵏ ⴹⵏ⵰ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵙⵗⵎⵓⵜ ⵢⵜⴹⵏ ⴾⵍ ⵜⴶⵎ⵿ⵜⵏ ⵛⵗⵎ⵿ⵜⵏ ⵏ⵿ⵙⵎⵙⵜ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ⴶⵏ ⵏⵜⵍⵀ ⵓⵏ ⴹⴰ ⵙⵗⵎⵏ ⵢⵜⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ⵜⵤⵔ ⴹⴾⵍ ⵗⵢⵙⴰ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵛⵏ ⴹⵏ ⴹⵛⵏ ⴾⴼⵜⵏ ⵓⵏ ⴶⵤⵢ ⵌⵏⵓⵏ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵎⵔⵏ ⴾⵔⵎⴾⵔⵎ ⵛⴶⵍⵓⵏ ⵛⵏ ⴶⴰ ⵓⵏ ⴹⴰ ⵢ ⴾⴼⵜⵏ ⴾⴼⵏ ⵢ ⵏⵜⵍⵀⵏⵜ ⵢⵜⵏⵤⵏⵏ ⵢ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ⵜⵛⵏ ⵢⵜⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵂⵔ ⵢⵓⵏⵏ⵰ ⵜⵓⵛⴹⵓⵏ⵿ⴹⵓ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⵜⵓⴶⵍⵤⵏⵏ ⵜⵓⴹⵏⵢⵏ ⴹⵗⵙⵏ ⵎⵔⵓ ⵤⵎⵎⵏ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ⵤⵍ ⵢⵏ ⵜⵜⵔ ⵗⵢⵙⴰ ⵗⵙⵏⵜ ⵓⵔ ⵗⵔⵙ ⵍⴰ ⵔ ⵏⵜⵍⵀⵏⵜ ⴹⴼⵔ ⵓⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵏⵙⵏ «ⵓⴾ ⴹⵗ ⴹⴼ ⵏⵢⵜⴹⵏ ⵎⴰ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ⵏⵏⵙ «ⵓⵢⴹ ⴶⵏⵏ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵜⵎⵙⴰ ⵓⵢⴹ ⴶⵏⵏ ⵏⵀⵢ ⵍⵢⵙ ⵓⵢⴹ ⴹⵗ ⴶⵏⵏ ⵢⵏ ⴹⵗ ⵏⵀⵜⵏ ⵓⵏ ⵔⵓⵏⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ⵜⵤⵔ ⵏⵙⵏ «ⴾⵓⵏⵢ ⵤⴰ ⵎⴰ ⵜⵏⵎ ⵎⴰ ⵎⵙⴰ⵰» ⵏⵙ ⵀⵜⵔⵙ «ⵍⵎⵙⵈ ⵏⵎⵛⵏⴰ ⵜⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ⵙⵏ⵿ⴾⴹ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵎⵔ⵿ⵜⵏ ⵙⴹ ⵓⵔ ⵎⵍⵏ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵙⵍⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ⵏⵙⵏ «ⵏⴾ ⴶ ⴶⴹⵎ ⵍⵤⵎⵢ ⴹ ⵏⵢⵗ ⵔⴾⵏⵢ ⴶⵏ ⵏ⵿ⴾⵔⵏⵢ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵜⵓⴶⵏ ⵎⵏⵏ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ⴹⴼⵔ ⵓⵏ ⵏⵙⵏ ⴾⵜⵏⵙⵏ «ⵓⴰ ⵔⵏ ⴹⵍⴾⵎ ⵓⴹⵢ ⴶⵎⴹⵜ ⵜⵔⴰ ⵏ ⵎⵏⵜ ⴶⵓ ⵎⵜⵔⵏⵜ ⴹⴾⵍ ⵜⴶⵜⵓⵜⵏⵜ ⴾ ⵤⵍ ⵍⴾⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ⵙⵏⵜ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴶⵎⵢ ⵔ ⴶⵤ ⵏⵎⵏⵜ ⵓⴹⵢ ⴹ ⵜⴶⵎⴹⵏ ⵎⵛⵏ ⵓⴰ ⵆⵀⵍⵏ ⴹ ⵜⴶⵎⴹⵏ ⴼⵍ ⴹⵍⵍⵏ ⵓⴹⵢ ⴹ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ⵎⴰ ⵤⴾⵏⵓ ⵢⵓⴹⵏ ⴹ ⴶⵔⵓ ⴹⵏⵜ ⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⵙⵈⵔⴾ ⵎⵏⵜ ⴼⵜⴰ ⴹⵗ ⵍⵈⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⴾⵔⴾⴹ ⵍⴾⵎ ⵢⵢ ⵎⴹⵗ ⵙⴾⵔⴾⴹⵜⵓ ⵙⵗⵍ ⵏⵓⵍⵏ ⵓⴹⵢ ⵏⴾ ⴹⴰ ⴶ ⴶⴹⵎ ⴹⵙⴾⵔⴾⴹ ⵍⵆⵀⵍⵜⵏⵜ ⵤⵍ ⵓⴰ ⴹⵤⵆⵍⴰ ⵂⵗ ⵜⵏⵢⵏⵏ ⵜⵎⵙⵜ ⵜⵏⵢⴰ ⵜⵏ ⵀⴰ ⵜⵎⵙ ⴹⵗ ⵜⵏ ⵏ⵿ⴶⵍⵙⵏ ⵤⴹⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⵀⴹⴹⵏⵏ ⴹⴰ ⴹⴰ ⵓⵔ ⵜⵏ⵿ⵤⵀⴰ ⵓⵔ ⵏⵢⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ⴹⴶ ⵏⵜⵎ ⴹⵏ ⴹⴼⵔ ⴶⵢ ⵓⴰ ⴹⵙⵏⴶⴰ ⵗⵢⵙⴰ ⵀⵜⵜⵏ ⵛⵏ ⴹⵏ ⵏ⵿ⴾⵔ ⴹⵓ ⴹⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⴹⵢⵆⵀ ⵙⴹⵗⵗ ⵢⵏ ⴼⵍ ⴼⵍⵙ ⵏ⵿ⵙⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ⵜⵜⵔ ⴹⵏ ⴹⴰ ⵙ ⵎⵜⵢ ⴹⵎⵏⵜ ⵜⵤⵔ ⴶⵏ ⵙⵍⵙⵏⵜ ⵜⵎⵍⵢ ⵜⵜⵙⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","ⵂⵏⵏⵏ ⴶⵏ ⵏⵀⵢ ⵎⵙⴰ ⴹⵏⵀⵢ ⵍⵢⵙ ⴹⵗ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵎⵛⵓⵍⵏ ⴹⵗⵢⵙⴰ ⴹⵗ ⵀⵜⵓ ⵏⴶⵎⴹ ⵓⴰ ⵤⴶⵓ ⴹⵏⵜ ⵤⵜⴹⵏ ⴹⵗ ⵢⵔⵙⵍⵎ ⵙ ⵜⵎⵜⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ⵙ ⵜⴶⵓ ⵓⵏ ⵀⵜⵔⵙ ⴹⵎⴹⵓⵏⵜ ⵀⵤⵜⵏⵏ ⵜⵙ⵰ ⵙ ⴹⵏ⵿ⴾⵔⵏ ⵏⵢⵏ ⵜⵏⵢⴰ ⵏ⵿ⵗⵢⵙⴰ ⵏⵢⵏ ⴹⵗ ⵛⵏ ⵎⴹⵏ ⵓⵏ ⴹⵔ ⵏⵀⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ⵙ ⴶⵤ ⵏⵀⵢ ⵎⵙⴰ ⴹⵍⵢⵙ ⵛⵏ ⴶⵍⵢ ⵏⴰ ⵀⵜⵔⵙ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵍⵗ ⵙ ⵏⵍⴰ ⴹⴰ⵰ ⵏ⵿ⴹⵓⵜ ⴹ ⵏⴾⵔⵙ ⴾⵔⴹ ⵂⴾⵜⵏ ⵢⵏ ⵏⴾ ⵢⵏ ⵏ ⵎⵙⴰ ⵢⵏ ⵏ ⵍⵢⵙ⵰» ⵓⵔ ⵙⵏ ⵀⵜⵔⵙ ⴶⵏⵓ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ⴶⵏⵓ ⵀⵜⵔⵙ ⵓⵏ ⴹⴰ ⵙ ⴹⵜⵏⴼⵍⵍ ⵜⴶⵔⴾ ⵢⵜ ⵜⵍⵙⴰ ⵗⵢⵙⴰ ⴹⵏⵀⵜⵏ ⵛⵏ ⵓⵏ ⴹⵔ ⵏⵀⴹⴹ⵰ ⵙ ⵜⵍⵙⴰ ⵀⵜⵔⵙ ⴹⵎⴹⵓⵏⵜ ⵜⴶⵤⵜⵏ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ⴶⵎⴹⵓ ⵎⵙⵍⵢ ⵜⴶⵔⴾ ⵜⵏ ⵏⴰ «ⵓⴰ ⵀⵔⵔⵏ ⵓⴰ ⵙⵏⴼⵔⵏⵗ ⵙⵙⵎⵜⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ⵙ ⵜⵏ⵿ⴹⴰ ⵀⵜⵓ ⵜⵏ ⵓⵔ ⵂⵏⵢⵏ ⵏⵜⵍⵀ ⵔ ⵗⵢⵙⴰ⵰ ⴼⵙ⵿ⵜⵏ ⴼⵍ ⵓⵏ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙ ⵜⵎⵍⵏ ⴹⵗ ⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ⵙ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ ⵢ ⵓⵏ ⵤⵀⵜⴹⵓ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵓⵏ ⴾⵔⴹⵏ ⴹⵗⵗ ⵜⵤⵔ ⵜⵙⵍⴾⴹⵙⵏ ⵜⵎⵜⵢ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ⵓⵍⴰ ⵂⴶⵏ ⴹⴾⵍ ⵍⵙ ⵢⵏ ⴹⵗ ⵎⵙ ⵏ⵿ⵜⵎⵜⵢⵏ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵢⴰ ⵛⵈ ⵏ⵿ⵙⵢⵆⵢ ⴹⵜⵂⵏⵜⵗ ⵢ ⵀⵔⵔⵏ ⵏ⵿ⵜⴰ ⵗⵙ ⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ⵍⵌⵢⵏ ⵜⵜⵀⵤⵏ ⵜⵤⵔ ⴹ ⵤⵢⴾ ⵜⵤⵀⵔⴹⵍ ⵙⴾⴼⴾⴼ⵰ ⴶⵔⴹ ⵙ ⵜⵜⵢⵓ ⵙⴾⵏⵢ ⵍⵗⵤⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ⵏ⵿ⵙⵢⵗ ⵏⵜⵍⵀⵏⴾ ⴹⵗⵙ ⵜⴾⵙⵏ ⵏ⵿ⴹⵔⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ «ⵈⴰ⵰ ⴾⵜ ⵀⴰ ⵏⵤⴶⵤⵏ ⴹⵛⵔ ⴹⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⴰ⵰ ⵓⴾ ⵂⵔ ⵎⵢ ⴹⵓⴰ ⴹⵔⵓⵏ ⵤⵎⵔⵗⵓⵏ⵰ ⵓⵢⴹⵓ ⵀⵔⵔⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ⵙ ⴹⵂⵤ ⵀⵔⵔ ⵗⵢⵙⴰ ⴶⴹⵍⵢ ⴶⵙⴼ ⴹ ⵜⵤⵀⵔⴹⵍ⵰ ⵂⵔⵛⵜ ⵗⵢⵙⴰ ⴶⵙⴼ ⴾⵙ⵿ⵜⵓ ⴹⵗ ⵀⵔⵔ ⵤⵢ ⵙⵗⵍ⵿ⵜⵓ ⵢⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ⵢⵜⴹⵏ ⴾⵍ ⵜⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵜⵤⵓⵔ⵿ⵜ ⵏ⵿ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ⵰ ⵂⵔⵓⴹⴰ ⵙⵎⴾⵍⵍ ⵙⵢⵜⴹⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⵏ ⵙ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«ⵜⴶⵤⵜ ⵀⵜⵓ ⵜⴰ ⵛⵎⵤⴶⵏⵓⵏ ⵜⵜⴼⵎ⵿ⵜⵜ \"ⵏⴾ ⴶ ⴶⴹⵎ ⵌⵓⵔⴰ ⴹ ⴶⵤⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ ⵀⵜⵓ ⵜⴰ ⴹⵙⵏⴶⴰ ⴹⵏ ⵜⵏ⵿ⴾⵍⵙⵏ ⵍⵎⵗⵏⵏⵜ ⴼⵍ ⵜⵜⵓⵔⴶⵔⵏ ⵎⵔⵏ ⵜⵂⵏ ⵜⵙⴰ ⵏⵙⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⴹⵗⵙⵏ ⴶⵔⵏ ⵍⵎⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ⵙⵏ ⵗⵢⵙⴰ ⵓⴰ ⵙⵎⴹⵔⵏⵏ ⴹⵢ ⴼⵍ ⴹⴹⴾⵍ ⵔⵜ ⵏⵀⵔⵔ ⵢⵏ ⵙⵀⴹⴹⵜⵓ ⴹⴶⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ⵎⵔⵏ ⵏⵙⵏ «ⵢ ⵆⵀⵍⵏ ⵀⵔⵔ ⴰ ⴼⵍ ⴹⵍⵍⵏ ⵏⴾ ⵆⵀⵍ⵰ ⵢ ⴹⵆⵀⵍⵏ ⴹⵗ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵆⵀⵍ⵰ ⵓⴰ ⴹⵗⵓⵏ ⵓⵔ ⵏⵎⵙ ⵔⵜ ⵏ⵿ⵜⴰ ⵤⵓⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ⵏⴰ ⵢⵈⵢⴰ ⵢ ⵢⵢⵙⴰ «ⵛⵈ ⵏⵏⵢ ⵍⵙ ⵢⵏ ⵜⴾⵙⵏ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵙⵙⵎⵏⴾ ⵏⵏⵙ ⴹ ⵓⵔ ⵍⵙ ⴶⵢ ⵏⵓⵏ ⴼⵍⵙ ⵓⵔ ⴹⵏⵗⵂⴰ ⵙ ⵍⴾⵎ ⵢⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ⵏⵙ ⵗⵢⵙⴰ «ⴰ ⴹⵙ⵿ⵜⵓⵔ⵿ⵜⴶⴹⵍⵎ ⴼⵍⵙ ⵢ ⵓⵔ ⵏⴶⵎⵢ ⵜⴾⵎⵏⵓⵏ ⵓⴹⵢ ⵎⴹⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ⵙ ⴹⵂⵤⵏ ⴹⵏ ⵓⵏ ⴹⵗ ⵤⵙⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵔⵜ ⵓⴰ ⵈⵜⵙ ⵎⵛⵏⴰ ⵜⵎⵙⵏ ⵎⴹⴾⵍⵏⵜ ⵙ ⵌⵏⵓⵏ ⵙⴶⵜⴾⵜ ⵢⴾⵢ ⵏⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ⵙⴶⵍⴰ ⵏⵎⵤⵍⵏ ⴹⵜⵙ ⴾⵏ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ ⵏⴾⵍ ⵏ⵿ⵙⵎⵔⵢⴰ ⵢⴹⵙⴾⵏⵏ ⴹⴶ ⵏⵤⵀⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ⵎⵛⵏ ⴶⵢⵏ ⵢⵜⴹⵏ ⵏ⵿ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵙⴹⵙⵏⵎⴶⵔⵜ ⴼⵍⵙ ⴾⴰ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ⵙ ⵏⵢ ⵢⵆⵀ ⴹⵢⵈⵢⴰ ⵓⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵏⵏ «ⵎⵍⵢ ⵜⵔⵗ ⴹ ⵏⵏⵓ ⵢ ⵜⵎ⵿ⵙⵢ ⴼⵍⵙⵏ ⴹⵜⵤⵀⵜ ⵜⵙⵔⴾⵎⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ⵎⵍⵍⵢⵜⵏⵏ ⵗⵢⵙⴰ ⵙⵏⵔⵗⵎⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ⵜⵤⵔ ⴾⵢⵏ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ⵌⵓⵏ⵿ⴾⵏ ⵙ ⵏⴰ ⵍⵙ ⵢⵏ ⵢ ⵗⵢⵙⴰ «ⴰ ⴹⴾⵍⴾⵎⴰ ⵙⴹⴶ ⴾⵍ ⵓⴰ ⵜⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ⵏⵙ ⵗⵢⵙⴰ «ⵤⴶⵤⵏ ⵍⵏ ⵏⵓⵏ ⴶⴹⴹ ⴹⵗ ⵍⵏ ⵛⵙⵍⵍⴰ ⵎⵛⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵓⵔ ⵍⵗ ⵓⵍⴰ ⴹⴶ ⴹⵗ ⵙⵏ⵿ⵙⴰ ⵗⴼⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ⵏⴰ ⵗⵢⵙⴰ ⵢⵢⵏ ⵍⵙ «ⵍⴾⵎⵢ⵰» ⵜⵤⵔ ⵏⵙ «ⵎⵍⵢ ⴾⴼⵢ ⵜⵔⴶⵜ ⵏⴹ ⴶⵍⴰ ⵂⵔ ⴹⵏⵏⵀⵍⵗ ⵀⵏⵏ ⵜⵤⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⵢⵓ ⵏⵎⵜⵏ ⴹ ⵏⵀⵍⵏ ⵏⵎⵜⵏⵙⵏ ⴾⵢ ⵎⵔⵏ ⴶⵍⵓ ⵜⴶⴰ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ⵏⵙ ⵢⵏ ⵍⵙ «ⵎⵍⵢ ⵔⵗ ⴹⴾⵍⴾⵎⴰ ⵎⵛⵏ ⴾⴼⵢ ⵜⵔⴶⵜ ⵏⴹ ⵏⵎⴶⴰ ⴹⵢⵜⴹⵏⵏ ⵛⵓⵜⵔⵓⵏ ⵜⵤⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ⵏⵙ ⵗⵢⵙⴰ «ⵓⴹⵏ ⵓⴰ ⵙⵏ⵿ⵜⵏ ⴹⵗ ⵍⴾⵎ ⵢⵢ ⵎⵛⵏ ⵓⵔ ⴶⴰ ⵓⵏ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵓⴹⵢ ⵓⵔ ⵂⵔ ⴹⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ⴹⴼⵔ ⵓⵏ ⵙⵏⴼⵔⵏ ⵎⵍⵢ ⵓⵢⴹ ⵏⵜⵍⵀ ⵎⵙⵏⵏ ⵙⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵛⵏ ⵤⵎⵤⵍ⵿ⵜⵏ ⵙⵛⵏ ⵛⵏ ⵢⴹⵙⵏⵤⵔⵏ ⵙ ⵗⵔⵎⵏ ⴹⴶⵏ ⵓⵏ ⵙ ⵀⴾ ⵢⵜⵏⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ⵏⵙⵏ «ⵗⵔⵜ ⵜⴶⵜ ⵎⵛⵏ ⵓⵔ ⴶⵜⵏ ⵎⵛⵗⵍⵏ ⵓⵏ ⵜⵜⵤⵍⵢⵏⵏ⵰ ⴹⵗ ⴹⵢ ⵜⵔⵜ ⵙⵙⵎ ⵏⵎⵛⵙ ⵏ⵿ⵗⵔⵜ ⵜⴰ ⴹⵙⴶⵍⵓ ⵎⵛⵗⵍⵏ ⵜⵜⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ⴶⵍⵜ⵰ ⵤⵎⵤⵍⵆⵓⵏ ⵜⵎⵙⵎ ⵤⵏ ⵌⵎⵔⵏ ⵂⵏⵏ ⵎⵙ ⵏⵔⴹⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ⴹ ⵓⵔ ⵜⵓⵢⵎ ⵤⵔⴼ ⵓⵍⴰ ⵗⵔⴶ ⵓⵍⴰ ⵜⵙⵙⵍ ⵜⵏ ⵙⵏⵜⵜ⵰ ⴾⵓⵏⵓⵔⵙⵍⵍⵏ ⵙⵍⵎⵏ ⴹⵗ ⵜⵔⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«ⵂⵏ ⵜⴶⵤⵎ ⵜⴶⵔⵎ ⴼⵍⵙ ⵙⵍⵎ ⵜⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ⴾⴹ ⵂⵢ ⵓⴹⵏ ⵏⵍⵈⵔ ⵓⴹⵢ ⴾⵓⵏⵆⵀⵍ ⴶⵔⵓ ⵍⵈⵔⵏⵓⵏ⵰ ⴾⴹ ⴹⵗ ⵓⵔ ⵜⵂⴰ ⵓⴹⵢ ⵜⴾⵢⵎ ⴹⵍⵈⵔⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ⵙ ⵜⴶⵔⵓⵎ ⵂⵏ ⵏⵓⴹⵏ ⵏⵍⵈⵔ ⵜⵈⵙⵔⵎ ⴹⵗⵙ⵰ ⵜⵜⵛⵎ ⵜⵛⵓⵎ ⵓⴰ ⴾⵓⵏⵜⵓⴾⴼⵏ ⴼⵍⵙ ⵎⵛⵗⵍ ⴾⵍ ⵂⵔ ⴹⵍⵈⵆⵏⵜ⵰ ⴹ ⵓⵔ ⵜⵍⵍⵎ ⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«ⵗⵔⵎ ⴹⵏ⵿ⵜⵙⵎ ⴹⵗ ⵆⵀⵍⵏ⵿ⴾⵓⵏ ⵎⵙⵓⵙ ⵜⵜⵛⵎ ⵔⵜ ⵓⵙ ⴾⵓⵏ⵿ⵙⵎⴶⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ⵜⵤⵤⵢⵎ ⵎⵔⵏⵏ ⵓⵏ ⵜⵂⵏⵏ ⵜⵤⵔ ⵜⵏⵎ ⵢⵢⵜⴹⵏⵜ \"ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⵤⴾⵓⵏ⵿ⴹⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ⵎⵛⵏ ⵗⵔⵎ ⴹⵏ⵿ⵜⵙⵎ ⵓⵔ ⴾⵓⵏⵆⵀⵍⵏ ⵎⵙⵓⵙ ⵍⵍⵜ ⵜⵔⵢⵏⵜ ⵜⴶⵏⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"ⵜⴶⵢⵎ ⵙ ⵓⵍⴰ ⵀⵆⴰ ⵏⵗⵔⵎⵏⵓⵏ ⵓⴰ ⵓⵔⵏ ⴹⵔⵏⵏⴰ ⴹⴰ ⵏⵀⴾⵀⴾⵏ ⵎⵛⵏ ⵙⵏⵜ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⵤ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ⵏⵗⵓⵏ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⴹⵢ ⴹ ⴶⵏ ⵍⵗⵤⵀ ⴶⵔⵏ ⵓⴰ ⵤⴶⵏ ⵓⵏ ⵗⵔⵎ ⵓⵏ ⵙⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵍⵗⵔⵎ ⵏ⵿ⴾⵔⴹⵤⵏ⵰ ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵍⵗⵔⵎ ⵏⵀⵜⵙⵢⴹⴰ⵰ ⴼⵍⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵗⵔⵓⵏ ⴶⵏⵏ ⵏⵔ ⴶⵏⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ ⵓⴹⵢ ⵔⵓ ⵙ ⵆⵏⵏ ⵙⵍⵙⴰ ⵏⵀⵂⵓ ⵆⵎⵏ ⴹⵗ ⵤⴹ ⵎⵙ ⵓⵏ ⵙⵏⴼⵍⵍ ⵏⵙ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵍⵗⵤⵀ ⵓⴰ ⵤⴰ ⵜⴶⵎ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹ ⴶⵔ ⵓⴰ ⵤⴶⵏ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵏ⵿ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ⴾⵓⵏⵢ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⵏ ⴾⴼⵔⵏⵂⵎ ⴹⵙ ⴹ ⵜⵎⴹⴾⵍⵎ ⵙⵍⵌⵏⵜ⵰ ⴾⵍⵔ ⵌⵂⵏⵎⴰ ⴹⵗ ⵤⴰ ⵜⵜⵓⴶⵔⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ⵏⴰ ⵗⵢⵙⴰ ⴹⵗ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵓⴹⵏ ⵓⴰ ⴹⵓⵏⵙⵙⵎⵏ ⵏⴾ ⵙ ⵙⵙⵎ⵰ ⵓⴰ ⴾⵓⵏⵏ⵿ⴾⵔⵏ ⴹⵗ ⵏⴾ ⵏ⵿ⴾⵔ⵰ ⵎⵔⵏ ⵓⴰ ⴹⵏ⵿ⴾⵔⵏ ⵓⴹⵢ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵏ⵿ⴾⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ⵙ ⴹⵆⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⵙⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵛⵏ ⴾⵏⵏ ⵜⴼⵍⵓⵙ⵿ⵜ ⴶⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵎⵍⵢ ⵓⵍⴰ ⴾⵍⵙⴼ ⵜⴼⵏ ⵜⵏⵏⵏⴰ ⵙ ⴹⵙⵏⵗⵔⴰ ⵙⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵂⵏⵢⵗ ⵛⵢⵜⵏ ⵙ ⴹⴼⵜⵆⵜ ⴹⵗ ⵌⵏⵓⵏ ⵤⵏ ⵙⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ⵙⵏⵜ ⵙ ⴾⴼⵆⵓⵏ ⵜⵔⵏⴰ ⴼⵍ ⵜⵛⵍⵏ ⴹⵜⵤⵔⴹⵎ ⴹⵓⴰ ⵍⴰ ⵤⵏ⵿ⴶⵓⵏⵏⴰ ⵀⵍⵙ ⴾⵍ ⴹⵗ ⵜⵔⵏⴰ⵰ ⵓⵔ ⵜⵍⴰ ⴼⵔⴶⵏ ⴹⵓⵏⴶⵓ ⵜⴾⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ⵎⵛⵏ ⴾⵓⵏⵓⵔⵙⴼⵍⵓⵙ ⵙ ⵜⴼⵏ ⴾⵍⵙⴼ ⵜⵏⵏⵓⵏ ⴾⵍⵔ ⵙⴼⵍⵓⵙⵜⴾⵓⵏ ⴾⵜⵀ ⵓⴰ ⴶⵏ ⵙⵎⵓⵏⵓⵏ ⴹⵗ ⵍⵌⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ⵙⵗⵜ ⵜⵏ ⴹⴰ ⴹ ⴾⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⴹⵓⵢ ⵏ⵿ⵗⵢⵙⴰ ⵜⵤⵔ ⵏⴰ «ⴶⵗⴾ ⵜⵎⵍⵏ ⵢⴰ ⵀⴰ ⵎⵍⵢ ⵏ⵿ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⴼⵍ ⵗⵀⵔ ⵓⴰ ⵜⴶⵗ ⵔⵜⵏ ⵓⵏ ⵢ ⵎⵙⵏⵏ ⴹⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ ⵜⵙⵏⴼⵍⵍⵆⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⵍⵢ ⴹⵀⵔⵔⵏ⵰ ⴹ ⴹⵢ ⴹⴰ ⵎⵙⵏ ⴶⵏⵏⴾ ⵢⴰ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ⵔⵜ ⴾⵍ ⴶⵢ ⵀⵏⵏ ⴹⵗ ⴼⵙⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵙⵏⵏ ⵓⴰ ⵎⵙⴰ ⵔ ⵀⴰ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵢ ⵙⵏⵏ ⵓⴰ ⵎⵙ ⵀⴰ ⵔ ⵏⴾ ⵏ ⵀⵔⵔⵏⵜ ⴹⵓⴹⵏ ⵓⵙ ⵔⵗ ⴹⵙ⵿ⵜⵙⵏⴼⵍⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ⵎⵍⵍⵢⵏ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵛⵓⵍⵙⵏ ⵏ⵿ⵜⵏⵢ ⵗⵙ ⵏⵙⵏ «ⵀⵍⵍⵏⵜ ⵛⵜⵓⵏ ⵛⵏ ⵂⵏⵢⵏⵏ ⵓⴰ ⵜⵂⵏⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙⴹⵔⵏⵏ ⵏⵀⵜⵏ ⴶⵜⵏⵏ ⴹⵎⵏⴾⵍⵏ ⵏⵢ ⵏⵓⴰ ⵜⵂⵏⵢⵎ ⵎⵛⵏ ⵓⵔ ⵜⵏⵢⵏ ⵙⴹⵔⵏⵏ ⴹⵗ ⵜⵙⵍⵢ ⵢⵓⵙ ⵜⵙⵍⵎ ⵎⵛⵏ ⵓⵔ ⴹⵙⵙⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ⴹⴼⵔ ⵓⵏ ⵏ⵿ⴾⵔⴹⵓ ⵎⵙⵏ ⵏⵛⵔⵗⴰ ⵢⵏ ⴶⴰ ⵢ ⵗⵢⵙⴰ ⵙⵙ⵿ⵜⵏ ⵎⵙⵏ ⵜⵏⴶⵎⵢⵜ ⵏⵙ «ⵛⵈ ⵎⵙ ⴹⵍⵤⵎ ⴶⵏⵜ ⵢⴹ ⴶⵔⵓⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴰ ⴾⵜⵀⵏ ⴹⵗ ⵜⵓⵔⵜ⵰ ⵎⴰ ⴹⵗⵙ ⵜⵗⵔⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ⵌⵓⵀⵙ ⵏⵙ «ⴾⵜⵀ ⴹⵗⵙ ⵙ \"ⴹ ⵜⵔⵗ ⵎⵍⵏⴾ ⵎⵛⵏⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹⵎⵏ ⵔⴹⵏⵏ ⵜⵔⵆⵓ ⵙ ⵜⵗⵔⴹⵏⴾ ⴾⵍ ⴹⵜⵢⵜⵢⵏⴾ ⴾⵍ ⵜⵔⵗ ⴹⵗ ⵛⵆⵗⵏⴾ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⵜⵔⵗ ⵎⵏⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ⵏⵙ ⵗⵢⵙⴰ «ⵍⵌⵓⵀⵏⴾ ⵗⴹ ⵜⴶⵓ ⴹⵢ ⴹⴰ ⴹ ⵜⴹⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ⵎⵛⵏ ⴹⴹ ⵔⴰ ⵎⵙⵏ ⵓⵏ ⴹ ⴾⵏⵓ ⵀⵜⵏⵜ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵎⴰ ⵎⵙⵏ ⵤⴰ ⵛⵆⵗⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵙⵍⵎⵜⵍ ⵓⴰ ⵏⵙ «ⵍⵙ ⵢⵏ ⴹⴶⵎⴹⵏ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵔⵙ ⴾⴰ ⵓⵏ ⵢⵔⴾⵓ ⵂⵔ ⵜⴶⵔⵓⵏ ⵀⵢⴹⴶⵏ⵰ ⵀⵤⵏ ⴹⵗⵙ ⵓⴰ ⵍⴰ ⴶⵜⵏ⵿ⵜⵓ ⵙ ⵜⵢⵏ ⵍⴰ ⴶⵔ ⵜⵎⴹⵔ⵿ⵜ ⴹⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ⵎⵤⵢⵜ ⴹⵓⵏ ⴹⵙ ⴹⴶⴰ ⵍⵎⵎ ⵢⵏ ⵜⵔⵢⵜ ⵜⵏ⵰ ⵏⵢ ⵍⵙ ⵓⵏ ⵗⵍⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ⵍⵎⴹⵓ ⵢⵏ ⴹⵗ ⴾⵍⵀⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵏ ⵏⵢⵜⵓ ⵗⵍⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ⵎⵛⵏ ⵙ ⴹⵍⵎ ⵓ ⵙⵎⵔⵢⴰ ⵢⵏ ⴹⵏ ⵛⴾⵍⵏ ⵏⵢⵜⵓ ⵜⴶⵤⵜⵓ ⵜⵂⵏⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ⴾⵢⴹⵓ ⵛⵔⴹ ⵀⵙⵏⵜ ⵙⵤⵢⵜ ⴹⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵜⵍ⵿ⵜⵏ ⵜⵤⵔ ⵙⵓⵏ⵿ⵜⵓ ⵜⵙⵏⵢⵜⵏⵜ ⵓⵢⵜⵓ ⵙⵤⵤⵀⵓ ⵙⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ⵙ ⴼⵓ ⴹⴾⵍⴹⵓ ⵛⵏ ⴹⵏⵔⵏ ⵏⵤⵔⴼ ⴾⴼⵏ ⵢⵍⵙ ⵓⴰ ⵏⵜⴼⵏ ⴹⵤⵤⵀⵓ ⵏⵙ \"ⵙⵏ ⴹⵗ ⵍⵙ ⴹⵢ ⵙ ⴹⵆⵍⴰ ⵏⴾ ⴹⴾⵤⵔⵤⵎⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴼⵍⵙ ⵜⵏ⵿ⵗⵗ ⴾⴹ ⵏ⵿ⵜⴰ ⴶⵔ ⴹⵢ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢⵎⵙⵏ ⵏⵜⵓⵔⵜ ⵓⵏ «ⵎⵏⵢ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⴾⵔⴹ ⴰ ⵓⵙ ⵜⵔⴹⵗ ⵙ ⵏ⵿ⵜⴰ ⴶⵏ ⵢⵍⵙ ⵓⴰ ⵏ⵿ⵗⵏ ⵀⵢⴹⴶⵏ ⵎⵤⵍ ⵓⴰ ⵜⴶⵓ ⵓⴹⵏ ⵢⵛⵆⵗⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ⵏⵙ «ⵓⴰ ⴹⵙⵂⵏⵜⵏ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴹⵢ ⵤⴰ ⴶⵍⵓ ⵜⴶⴰ ⴾⵢ ⴹⴰ ⵤⵏ ⴹⵓⵏ ⴹⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ⴶⵍⴰ ⵗⵢⵙⴰ ⴹⵗ ⵛⴾⵍⵏⵜ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵂⵔ ⴶⵤ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ ⵏⴼ⵿ⵜⵗ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⵙⵎ ⵎⵔ⵿ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵍⴰ ⵜⵎⴹⵔⵢⵜⵏⵜ ⵜⴶⵜ ⵙⵎ ⵎⵔⵢⵎⴰ⵰ ⵜⵆⵎ ⵎⵔⵢⵎⴰ ⵗⵔ ⴹⵔⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵜⵙⵙⵎ ⵢⵓⴰ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ⵎⵔ⵿ⵜⴰ ⵎⵔⵏ ⵛⵎⵛⵏ⵿ⵜⵜ ⵛⵗⵍ ⵏⵙⵎⴶⵔⵢ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵓⵍⴰ ⵂⴶⵏ ⵜⵂⵤⴹⵓ ⵗⵢⵙⴰ ⵜⵏⵙ «ⵎⵍⵢ ⵓⴾ ⵤⵍⵢⵜ ⵓⵔ ⵜⴶⵗ ⴹⵗ ⵙ ⴹⵜⵢⴰ ⵜⵎⴹⵔⵢⵜⵏ ⴹⵛⵗⵍ ⴾⵜⵏⵜ ⵗⵙⵏ⵰ ⵏⵙ ⴹⵜⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ⵏⵙ ⵗⵢⵙⴰ «ⵎⵔ⵿ⵜⴰ ⵎⵔ⵿ⵜⴰ⵰ ⵛⵓⵛⵏ⵿ⴾⵎ ⵔⵜⵏ ⴶⵜⵏⵏ ⵙⴶⴹⵏ ⵜⵢⵜⵢⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ⵏ⵿ⵜⴰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵍⵗ ⵜⵎⵙⵏ ⵙⵙⵎ ⵢⵓⵍⵏ ⵏ⵿ⵜⴰ ⵜⵙⵏⴼⵔⵏ ⵎⵔⵢⵎⴰ ⵎⵔⵏ ⵓⵔ ⴹⵗⵙ ⵤⵜⵔⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ⵤⵍ ⵢⵏ ⵜⵜⵔ ⵗⵢⵙⴰ ⴹⵗ ⴹⴶ ⵢⵏ⵰ ⵙ ⵙⵏ⵿ⴹⴰ ⵏⵙ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ «ⵎⵍⵢ ⵙⵙⵏⵏⴰ ⵜⵓⵜⵔⵢ ⵤⵏ ⵓⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢ ⵏⵜⵍⵀⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙ ⵜⵜⵜⵔⵎ ⵜⵏⵎ \"ⵀⴰ ⵜⵓⵙⵗⵎⵔⵜ ⵙⵎⵏⴾ ⴹⵢ ⵤⴹⴶⵏ ⵜⵙⵜⴹⵓ ⵜⵗⵎⵔⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ⴾⴼⵏⵗ ⴾ ⵤⵍ ⵙⴹⵔⵏⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ⵜⵙⵔⴼⵗⵏⵗ ⵀⴾⴹⵏⵏⴰ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵙⵔⴼ ⵢ ⵓⵏ ⴹⵏⵗⴶⵏⵏ ⵔⴾ ⵎⵤⵍⵏ⵰ ⴰ ⴹⵏⵓⵔ⵿ⵜⴶⴰ ⴹⵗ ⵍⵗⵔⵔ ⵏ⵿ⵌⵔⵀⵜⵏ ⵏⵀⵍⵙ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⵤⵍⵏ ⵎⴹⵢ ⵙⵢⴹⵓ ⴹⵓⵏⵢ ⵏⵂⴹ ⵏⵙ \"ⵤⵀⵏⵜⴹⵓ ⴾⵔⴹⵜ ⵜⴶⵍⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ⴼⵍⵙ ⵢⵏ ⴹⵗ ⵎⴹⵓⵏⵏ ⴹⴹⵏⴼ⵿ⵜⵗⵏ ⵓⵔ ⵍⵗ ⵜⵛⵜⵛⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ⵜⵤⵔ ⵏⵙⴹⵓ ⴹⵗ ⵎⵙ ⵏⵂⵏ \"ⴰ ⴹⵓⵔ⵿ⵜⴹⴶⵤⴰ ⵂⵏⵏ ⵎⵔⴹⴰ ⵈⴼⵍ ⵏⴾ ⴹⵀⵔⵔⵏⵏ ⵏⵆⵍ ⵙⵜⵙ ⵓⵔ ⴼⵔⴶⴰ ⴹⵏⵀⴹⴹⵗ ⴾⴼⵆⵢ ⵔⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ⵏⵗⵓⵏ ⴾⴹ ⵓⵔ ⴹⵏ⵿ⴾⵔ ⴾⴼⵙ⵿ⵜⵏⵜ ⴼⵍⵙ ⵎⵙ ⵎⴹⵏⵜ ⴹⴰ ⴹ ⴹⵏ⵿ⴾⵔ ⴾⴼⵢ ⵔⵜ ⴾⵍ ⵓⵙ ⴹⵔⵔ ⴼⵍⵙ ⵓⵔ ⵜⵙⴾⵔⴾⴹ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵜⴶⴰ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ⵎⵔⵏ ⵏⴾ ⵏⵗⵓⵏ «ⵏ⵿ⵙⵢⵜ ⵎⵛⵏⴰ ⴾⵓⵏⴾⴼⵓ⵰ ⴶⵎⵢⵜ ⴹ ⵜⴶⵔⵓⵎ⵰ ⴾⵓⴾⵓⵜ ⵜⵙⵂⵔ⵿ⵜ ⴹⵓⵏ⵿ⵜⵏⵍⵎ⵰ ⵗⵔⵜⵓ ⴹⵓⵏⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ⵓⵍⴰ ⵢ ⵏ⵿ⵙⵢⵏ ⴹ ⵜⵓⴾⴼⵓ⵰ ⵢ ⴶⵎⵢⵏ ⴹ ⴶⵔⵓ ⵢ ⵗⵔⵏ ⴹⵗ ⵎⵛⵏⴰ ⴹⵙⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴹⵗ ⵤⴶⵎⵢ ⵀⵔⵔⵏⵜ ⵙⵏ ⴾⴼⵢ ⵜⵛⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ⵓⵍⴰ ⴶⵎⵢ ⴹⵗⵙ ⵜⴾⴾⵜ ⴾⴼⵢ ⵜⵤⵔⴹⵎ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ⴾⴹ ⴾⵓⵏⵢ ⵏ ⵏⵍⵀⵙ ⵜⵙⵏⵎ ⵜⵂⴾⵢ ⵏⵓⴰ ⵍⵗⵏ ⵢ ⵀⵔⵔⵏⵓⵏ ⵎⵏⵎⴾ ⵙ ⴾⵓⵏⵓⵔⵤⴾⴼⵓ ⵀⵏⵓⵏ ⵓⴰ ⵂⵏ ⵌⵏⵓⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⴹⵙ⵿ⵜⵜⵏ⵿ⵙⵢⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ⴹⴼⵔ ⵓⵏ ⴾⵙ ⵗⵢⵙⴰ ⴹⵗ ⵍⵙ ⵢⵏ ⴶⵙⴼ ⴹⵙⴶⴹⵍⵏ ⵓⵍ⵰ ⴶⵎⴹⵜⵓ ⴶⵙⴼ ⵗⵙ ⵛⵓⵍ ⵙⵎⴾⵍⵍ ⵓⵏ ⵙ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ⵎⵛⵏ ⴹ ⴶⵏⵏ ⵓⵢⴹ ⴹⵗⵙⵏ «ⵓⵏ ⵛⵢⵜⵏ ⵀⵗⵍⵤⵀⵍ ⵓⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵙⴼ ⵜⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ⵓⵢⴹ ⴹⵗ ⵔⵏ ⴹ ⵜⵌⵔⵀⵏ ⴶⵎⵢⵏ ⴹⵗⵙ ⴹⵙⵏⴶⵓ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵙⵏ ⵓⴰ ⵙⵎⴹⵔⵏⵏ ⴹⵢ ⴼⵍ ⴹⵙⵏⵏⴰ «ⵜⵗⵎⵔ ⴾⵍ ⵜⵙ ⵎⴶⵔⵏ ⵎⵙⵓⵙ ⴶⵔⵙⵏ ⵀⵔⵌⵢ ⵤⴰ ⵜⴶⵓ ⵜⵤⵔ ⵀⵔⵌⵏ ⵗⵓⵏⵜⵏⵜ ⵙⵢⵏ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ⵜⴶⵏⵎ ⵏⴾ ⵛⵢⵜⵏ ⵀⵗⵍⵤⵀⵍ ⴹⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ⵰ ⴾⴹ ⴹⵢ ⴶⵏ ⵓⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵂⴶ ⵜⵗⵎⵔⵏⵜ ⵏ⵿ⵜⴰ ⵎⴶⵔ ⴹⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ⵎⵔⵏ ⴾⴹ ⵏⴾ ⵜⵔⵏⴰ ⵏⵀⵗⵍⵤⵀⵍ ⵙ ⵜⴾⵙⵗ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵏⵍⴾⵎⵏⵓⵏ ⵤⴰ ⵎⴰ ⵍⵏ ⵜⵔⵏⴰ ⵜⵙ ⵜⵏ⵿ⵜⴾⵙⵏ⵰ ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵎⵏⵙⵏ ⵙ ⴾⵓⵏ⵿ⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ⴾⴹ ⵎⵔⵏ ⵏⴾ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⵙ ⵜⴾⵙⵗ ⴾⵍⵙⴼ ⴹⵗ ⴹⵢ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵙⵓⵏ⵿ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ⵍⵙ ⵏⵎⵆⵔⴹ ⵜⵀⵏ ⴼⵍ ⵜⵤⵍⵢ ⴶⵤ ⵂⵏⵜ ⵓⴹⵢ ⵜⵍⵏⵜ ⵓⵔ ⵜⵜⵏⴾⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ⵎⵛⵏ ⵙ ⵜⴹⵀⴶ ⵢⵏ ⵜⴶⵔⵏ ⵙⵂⵜ ⵔⵏⵢ⵰ ⴹⵗⵙ ⵀⵤ ⵜⵤⵍⵏⵜ ⵜⴰ ⴼⵍ ⴼⵍⴰ ⵔⴾⵀ ⴹⵗⵙ ⵜⵍⵏⵜ ⵤⵏ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ⵓⴰ ⴹⵔⵢ ⵓⵔ ⵏⴹⵓ ⵤⵏ⵿ⴶⵓⵏⵏ ⵎⵙ⵰ ⵓⴰ ⴹⵓⵔⵏⵍⵍ ⴹⵗ ⵙⵛⴹⵓ ⵓⴹⵢ ⵤⵓⵤⵓⵤ ⵜⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ⵙ ⴶⵎⴹ ⴶⵙⴼ ⵓⴹⵏ ⴹ ⵔⵙ ⴶⵙⴼ ⵓⵏ ⴹⴶⵏ ⵆⵔⵏⵏ ⴶⵎⵢ ⴹ ⵎⵍ ⵆⵎ ⵓⵔ ⵜⴶⵔⵓ ⴹ ⵏⵓ ⴹⵗ ⵎⵏⵜ \"ⵏⴾ ⵤⴰ ⴹ ⵆⵍⵗ ⵂⵏⵏ ⵓⴰ ⴹⴶⵎⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ⵙ ⵜⴹⵆⵍ ⵜⴹⵙⵓ ⴼⵔⴹ ⵎⵜⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ⵜⵤⵔ ⴶⵍⵓ ⴹⵓⴹⵓ ⴹⵙⴰ ⴾⵍⵙⴼ ⵓⵢⴹ ⵜⴶⵔⵏⵏ ⵜⵍⵀⵙ⵿ⵜ ⴶⵤⵏ ⵓⴹⵏ ⵓⵏⴹ ⵤⴹⵗⵏ⵿ⵜⵓ⵰ ⵜⴶⵓ ⵜⵗⵔⴰ ⵏⵓⴹⵏ ⵓⵏ ⵗⵛⴹ ⴶⵔⵏ ⵓⵙ ⴾⵍⴰ ⵜⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ⵛⵓⵍ ⵗⵢⵙⴰ ⴹⵏ ⴹⴰ ⵙ ⵜⴹⴾⵍ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵎⵙⵍⵏⵜ ⵜⵏⵙ «ⵜⵀⵍⵍ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⴾⵢⵜⵔⵓⵜ ⴹⴼⴼⵏ ⵓⵏ ⵜⵏ⵿ⴾⵙⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵏⵏ ⵀⵍⵍ ⴹⴰ ⵙⵙⵎⵏⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵜⵎⵤⵍⵏ ⵓⴰ ⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⵜⴹⵓⵏ ⴼⵍⵙ ⵏⵙⵏ «ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵏⵍⵀⵙ⵰ ⴶⵎⵢⵏ ⵜⵍⵎⵗⵌⵌⵜ⵰ ⴾⵍⴰ⵰ ⵜⵍⵎⵗⵌⵌⵜ ⵜⴰ ⴹⵙⵏ⵿ⵜⵜⵓⴶⵜ ⵢⴹⴰ ⵗⵙ ⵜⵜⵎⵙⵏ ⵜⵏ ⵏⵀⵢ ⵢⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ⵎⴾ ⵓⵙ ⴾⵍⴰ ⴹ ⵆⵍ ⵢⵏⵙ ⵍⵗⵍⵎⵜ ⵢⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵏⵏⴼ ⵎⴾⵏ ⴹⴰ ⵙ ⵤⵆⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵍⵗⵍⵎⵜ ⵢⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹⵜⵏ⵿ⴾⵔ ⵜⵎⵏⴾⵍ⵿ⵜ ⵜⵙ ⴾⵍⴰ ⵜⵈⴾⵎ ⴼⵍ ⴾⵍ ⵏⴶⵍⴰ ⴶⵏ ⵙⵎ ⵛⵀⴰ ⵜⴶⵢⵜ ⴼⵍ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵜⵤⵀⵤⵜⵏ ⵢⵛⵔⵗⴰ ⴼⵍⵙ ⴹⴹ ⵔⵤ ⵎⴹⵍ ⴹⵜⴶⵎⴹ ⴼⵍ ⴹ ⵜⵙⵙⵎ ⵢⵓⵍ ⵏ⵿ⵜⵍⴰ ⵏⴶⵔⵢ ⵓⴰ ⵜⴶⵓ ⵎⵏⴾⵍ ⵙⵍⵎⵏ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵓⴰ ⵍⵏ ⴹⴰ ⵎⵔⴹⴰ ⴶⵔ ⵏⵀⵢ ⵙⵍⵎⵏ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙⴹⵙ⵿ⵜⵙⵙⵎⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⴹ ⴹⵏ⵿ⴾⵔⵏ ⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⵏ ⵏⵏⴼ ⵤⵀⵤⵏ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵢⵛⵔⵗⴰ ⴼⵍⵙ ⵜⵜⵀⵜ ⴶⵏ ⵤⵍ ⵓⴰ ⴹⵙⵏⴶⴰ ⵢⵏⵙ ⵜⵍⵈⵜⵀⵜ ⵎⵍⵙⵏ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵓⴰ ⵍⵏ ⴹⴰ ⵎⵔⴹⴰ ⴶⵔ ⵢⵏⵙ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙ ⵜⵜⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙⵔⵗⵏ ⴼⵜⵍⴰ ⵜⵤⵔ ⵗⵀⵔ⵿ⵜⵜ ⵎⴹⵗ ⴶⵜ ⴹⵓ ⵗⵤⵓ ⴾⵍⵔ ⵙⵓⵔ ⵜⵜⵜⴶⵓ ⴹⴶ ⵂⴾⵏ ⴼⵍ ⴹ ⵏⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵜⴶⵤⵏⵏ ⵂⵏ ⵙⵏⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ⵛⵜ ⵛⵍⵜ ⵏ⵿ⴼⵜⵍⴰ ⵜⵎⵙ ⵢ ⵜⵗⵙⵏⴾ⵰ ⵙ ⵎⵙ ⵙ ⵛⵜⵏⴾ ⵜⵂⵏⵢ ⵙⵍⵗ ⵓⴹⵢ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵜⵂⴰ ⵏⵔ⵰ ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵛⵜⵏⴾ ⵓⵔ ⵜⵂⵏⵢ ⵙⵍⵗ ⵓⴹⵢ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵜⵂⴰ ⵛⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ⴹⵗ ⴹⵢ ⴶⵓ ⵏⵢⵜ ⴹⵎⵏⴾ ⵏⵔ ⵓⴰ ⴾⵢ ⵂⵏ ⵜⵓⵔⵍⵙⵏⵜ ⵛⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ⵎⵔⵏ ⴾⴹ ⵜⵗⵙⵏⴾ ⴾⵜⵏⵜ ⵜⵂⴰ ⵏⵔ ⵓⵔ ⵜⵜⵂⴰ ⴹⴶ ⵂⵏ ⵛⵢⵢ⵰ ⵓⴹⵢ ⴹ ⵜⵎⵍⵓⵍⵓ ⴾⵜⵏⵜ ⵤⵏ ⵜⵂⵗ ⴹⴶ ⵜⵙⵎⵍⵓⵍⵓ ⴼⵜⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ⵗⵔⴹ ⵗⵢⵙⴰ ⵓⵍ ⵗⵙ ⴶⵎⵢ ⴹⵗⵙ ⴼⵔⵙⵢ ⵢⵏ ⵗⵔⵙ ⵎⵏ⵿ⵙⵓ⵰ ⵙⵏ ⵗⵢⵙⴰ ⵂⵏ ⵏ⵿ⴼⵔⵙⵢ ⵓⵏ ⴶⵤ ⴹⴶ ⵓⴰ ⴹⵗ ⵙⴾⵔⵏ ⵎⵏ⵿ⵙⵓⵏ ⵙⵗⵎⵔ ⴹ ⵜⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ⵙⵎⴾⵍⵍ ⵙ ⴼⵔⵙⵢⵏ ⵓⵙ ⵙⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵜⵜⵢ ⵓⵔ ⵛⵔⴹ ⴼⵙⵏⵜ ⵓⴰ ⵜⵏⴰ ⵍⵗⴹⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ⵜⵤⵔ ⵏⵙ ⵎⵍⵢ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⴼⵔⵙⵢⵜⵏ ⵜⵤⵤⴹⴶⵎ ⴼⵍⴰ ⵏⵙⵍⴾⵓ ⴹⵗⵤⵓ ⵙ ⴶⴰ ⵓⵏ ⵎⵙ ⵏⵓⵍⵏⵓⵏ ⵓⵔ ⴹⵏⵢⵏ ⵔ ⵜⵔⴾⵀⵜ ⴹⵜⵍⵀⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ⵍⵌⵂⵍⵏ⵰ ⵓⵔⴶⵗ ⵓⴰ ⴹⴶⵏ ⴼⵍⴰ ⵏ⵿ⵜⵗⵙⴰ ⵏ⵿ⵜⴰ ⴹⴶⵏ ⵎⵙⵏⵜ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ⴹⵗ ⴹⵢ ⴾⵜⵜ ⵢ ⵜⵍⵆⵓⵏ ⵓⴰ ⵂⵏ ⴾⵙⵏⵓⵏ ⴹⵢ ⵔⵜ ⴾⵍ ⴹⵓⵏⵤⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⴼⵔⵙⵢⵜⵏ ⴼⵍⵙ ⵜⵂⴾⵎ ⵓⴰ ⵎⵙⵏ ⵜⵎⵙⴹⴾⵏⵓⵏ ⴹⵗ ⵏⵗⵏⵗ ⴹⵤⵏⴼⵏ ⵏⵢⵍⵜⵏ ⴾⵍ ⵓⵏ ⴼⵔⴶⵏ ⵙ ⴶⴰ ⵓⵏ ⵜⵜⵎⵤⵔⵢⵎ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⴹⵜⵔⵏⵜ ⵙⵏ⵿ⵜⵏⵢ ⵙ ⴾⵓⵏⵓⵔ ⵍⴾⵎ ⵢⵙⵏ ⴹⴰ ⵓⵔ ⴹⵏ⵿ⵜⴶⵍⵎⵎ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵓⵏⵢ ⴼⵔⵙⵢⵜⵏ ⴼⵍⵙ ⵜⵔⵎ ⵜⵗⵎⵜ ⴹⵗ ⴹⴶ ⵓⴰ ⵍⵏ ⵍⵎⵆⵎ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⴾⵓⵏ⵿ⵙⵙⵍⵎⵏ ⵢⵜⴹⵏ ⴹⵗ ⵙⵎⵏⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴼⵍⵙ ⵜⵍⵎ ⴹⵤⴾⵓⵏ ⵓⵔ ⵏⵎⵏ ⴼⵍ ⵜⵌⵓⵏ⵿ⴾⵜ ⵓⴹⵏ ⵓⵔ ⵙⵏ ⵙⵎⴹⵙⵏ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ⵏⴰ ⵢⵏ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⴹⵗ ⵓⴰ ⵜⵏⵗ ⴹⵢ ⵏⴾⵏⵢ ⴹⴰ ⵜⴶⵗⵏⴰ ⵔⴾ ⵀⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ⵏⵙ ⵗⵢⵙⴰ «ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴾⵓⵏⵢ ⴹⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴼⵍⵙ ⵜⵙⵓⵔⵎ ⵢⵜⴹⵏ ⵤⴾ ⵙ ⵤⵓⵜ ⴶⵢⵏⵜ⵰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵔ ⵜⵤⵜⴹⵙⵎ ⵙ ⵓⵍⴰ ⴹⴹⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⴼⵍⵙ ⵜⴾⵔⵙⵎ ⵤⴾⵓⵏ ⵂⵙⵢⵏⵏ ⵢⵏⵀⵜⵏ ⵙ ⵎⵔⵓⵏⵓⵏ ⵜⵏⵏ⵿ⵗⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ⵎⴾ ⵓⴹⵢ ⵙ ⵜⴶⵢⵎ ⴼⵍ ⵓⴰ ⴶⵏ ⵜⵔⴹⵎ ⵙⵔⵙ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵤⴰ ⵏ⵿ⵗⵏ⵿ⵜⵏ ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⴾⵔⵙⵎ ⵤⴾⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ⵓⵏ ⴹⵗ ⴼⵍ ⵏⴰ ⵎⵛⵏⴰ ⴹⵗ ⵎⵙⵏⵜⵏⵜ ⵓⵔ ⵏⵍⴰ ⵜⵤⵔⵙ⵿ⵜ \"ⴰ ⵙⵔⵙⵏ ⵤⵎⵤⵍⵗ ⵏⵀⵜⵏ ⴹⵏⵎⵤⵍ ⴹ ⴶⵏ ⵎⵏ ⵏⵓⵢⴹ ⴹⵗⵙⵏ ⵤⵗⵤⵀⵏ ⵓⵏ ⵂⴹⵜⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ⴹⵢ ⵙ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵂⵏ⵿ⵜⵏ ⵎⵏ ⵏⵏⵀⵜⵏ ⴾⵍ ⵓⵏ ⵜⵏⵓⵏ⵿ⵗⵏⵏ ⵓⵏ ⵏⵜⵢ ⵏⴹⵏⵜ ⵂⵔ ⵤⵍⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ⵓⵍⴰ ⵍⴾⵏ ⵙ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⵂⵏ⵿ⵜⵏ ⵎⵏ ⵏⵢⵜⴹⵏ ⴹⵢ ⴾⵍ ⴹⵀⵤⵏ ⵗⵔ ⵎⵏ ⵓⵏ ⵂⵀⵍⴰ ⵂⵔ ⵓⵏ ⵤⴾⵔⵢⴰ ⵓⴰ ⵏ⵿ⵗⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴶⵔ ⵎⵌⵎⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵙⵆⴹ ⵏ⵿ⵜⴾⵜⵓⵏ ⴹⴹⴶ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ⴾⵜ ⵍⵗⵤⵀ ⵆⵍⵓⵏ ⵢⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴼⵍⵙ ⵜⵂⵔⵎ ⵜⵔⵢⵜ ⵜⴰ ⵜⵜⵓⵢⵜ ⵓⴹⵏ ⵙ ⵎⵙⵏⵜ ⵏⵎⵛⵏⴰ⵰ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵓⵔ⵿ⵜⵜⴶⵤⵎ ⵜⴶⴹⵍⵎ ⴹⵗ ⴶⵤⵏⵜ ⵢ ⵓⵏ ⵜⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ⵙ ⴼⵍ ⵗⵢⵙⴰ ⵂⵏ ⵓⵏ ⵙⵏ⵿ⵜⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⴹⵗ ⴹⴶⵤⵏⵜ ⵓⵍⵏ ⵜⴶⵏⵙ ⵙⵙ⵿ⵜⵏⵏ ⴶⵜⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ⴹⵗ ⴶⵎⵢⵏ ⵜⵙⵙⵏⵏ ⵔⵜ ⵜⵏ⵿ⵤⴾⴼⵏ ⵜⵔⵢⵜ ⵙ ⵜⵈⵜⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⴹⵓ ⵜⵎⵜⵢ ⵜⴾⵏⵜ ⴶⵜ ⴼⵍ ⵗⵢⵙⴰ ⵂⵔ ⵆⵎⵏ ⵢⵜⴹⵏ ⵜⵏⵎⴾⴾⵍⵏ⵰ ⵛⵓⵍ ⵗⵢⵙⴰ ⵤⵔ ⵙ ⵏⵜⵍⵀⵏⵜ ⵏⵙⵏ «ⵏ⵿ⴾⴹⵜ ⵢ ⵈⵎⵔⴰ ⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵜⵎⵙⵏ ⵜⵍⵎⵏⴼⵆⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ⵔⵜ ⴾⵍ ⵓⴰ ⵗⵀⵔⵏ ⴹ ⵜⵓⵙⵏⴼⵍⵍ ⵎⵔⵏ ⵙⵔ ⴾⵍ ⴹ ⴼⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ⴹⵗ ⴹⵢ ⵜⵏⵎ ⴹⵗ ⵛⵢⵢ ⴹ ⵜⵓⵙⵍⵓ ⵤⵍ ⵎⵍⵏ⵰ ⵜⵙⵎⵜⴾⵜⴾⵎ ⴹⵗ ⴹⵗ ⵎⵙ ⵏⵏⵓⵏ ⴹ ⵜⵎⵍ ⴼⵍ ⴼⵍⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ⴾⵓⵏⵢ ⵎⴹⵓⵏⵏ ⵏⵗⵓⵏ ⴹ ⵓⵔ ⵜⴾⵙⴹⵎ ⴶⴹⵎ ⵙ ⴼⵔⴶⵜⵏⵜ ⵓⵔ ⵜⴾⵢ ⴾⵙ ⵏⵎⵏ ⴹⵗ ⵜⵗⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ⴹⵓⵏⵎⵍⵗ ⵓⴰ ⵤⴰ ⵜⴾⵙⴹⵎ ⴾⵙⴹⵜ ⵎⵛⵏⴰ ⵏⵆⵏ ⵍⴰ ⴹⵗ ⵜⵔⵏⴰ ⵏ⵿ⴾⵓⵏⴶⵔ ⴹⵗ ⵌⵂⵏⵎⴰ⵰ ⵓⵍⴰ ⵏⵗⵓⵏ ⵏ⵿ⵜⵏ ⴹⴰ ⵙ ⴾⵓⵏⵓⵔ ⵜⵜⴾⵙⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ⵓⵔⴶⵗ ⵙⵎⵙ ⴶⴹⴹ ⴹⵏⵤⵏⵏ ⵙⵏⵜⵜ ⵜⴼⵍⵏ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴹⵏⵜⵜⵓ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵍⴰ ⵏ⵿ⵤⴹⵏ ⵏ⵿ⵗⴼⵓⵏⵓⵏ ⴹⴰ ⴾⵍ ⴹⵏⵏ⵰ ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⴾⵙⴹⵎ ⵓⵍⴰ ⵜⴶⵔⵎ ⴶⴹⴹ ⴶⵜⵏⵏ ⵍⵆⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ⵏⵗⵓⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵢⵏ ⴹⵜ ⵢⵜⴹⵏ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵜⵍⵏ ⵏⴾ ⴹⴰ ⴹ ⴶⵢⵗ ⴹⵜ ⵏ⵿ⴶⵍⵙⵏ ⵏⵎⵛⵏⴰ ⵙ ⵏⴾ ⵜⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ⵎⵛⵏ ⵓⴰ ⴹⵏ⵿ⴾⵔⵏ ⴹⵜ ⵢⵜⴹⵏ ⵓⴹⵢ ⵏⴾ ⴹⴰ ⴹ ⵜⵏ⵿ⴾⵔⵗ ⴹⵜ ⵏ⵿ⴶⵍⵙⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ⵓⴹⵏ ⴹⵗ ⵓⴰ ⴹⵀⵢⴾⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴼⵔⴶ ⴹ ⴶⵔⵓ ⵜⵙⵔⴼ⵿ⵜ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴾⵙⵏ ⵜⵔⵏⴰ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴹⵢ ⵓⵔ ⵤⴶⵔⵓ ⵜⵙⵔⴼ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ⵙ ⵜⵎⵓⵢⵎ ⵙ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵎⴹⵗ ⵙ ⵎⵏⴾⵍⵏ ⵎⴹⵗ ⵙ ⵎⵤⵔⵏ ⵢⴹ ⵜⵜⵓⵛⵔⵗⵎ⵰ ⴾⵓⵏⵓⵔⵛⵓⵛ ⵎⴾ ⵓⵙ ⵤⴰ ⵜⴾⵙⵎ ⵎⵏⵓⵏ ⵓⵍⴰ ⵓⴰ ⵤⴰ ⵜⵏⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵓⵏ⵿ⵤⵙⵙⵏⵏ ⴹⵗ ⵙⵗⵜ ⵜⴹⵢ ⴹⴰ ⵓⵙ ⵏⵂⴶⴰ ⵜⵜⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ⵏⴹⵓ ⵓⴹⵏ ⵢⵏ ⵢ ⵗⵢⵙⴰ ⴹⵗ ⵎⵙ ⵏ⵿ⵜⵎⵜⵢ «ⵛⵈ ⵏⵓ ⵢⵎⵆⵔⵏ ⴹⵔⵢ ⵤⵏ ⵜⴾⵙⵜⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ⵏⵙ ⵗⵢⵙⴰ «ⵍⵙ ⵎⴰ ⴹⴶⵏ ⵍⵆⵍⵏⵓⵏ ⵓⵍⴰ ⵜⵤⵏⵗⵓⵏ ⵜⴾⵙⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ «ⵂ ⴾⵓⵏⵢ⵰ ⴶⵤⵜ ⵎⵏⵓⵏ ⴹⵗ ⵎⵙⵏ ⵓⵍⵢ ⴼⵍⵙ ⴾⴹ ⴶⵔⴶⵙ ⵓⴹⵏ ⴹⴰ ⵜⵎⴹⵔ⵿ⵜⵏⵜ ⵓⵔ ⵜⵆⵏ ⴹⵗ ⵔⵤⵗⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ⵜⵤⵔ ⴶⵙⵏ ⵍⵎⵜⵍ ⵓⴰ ⵏⴰ «ⵛⵓⴶⵙ ⵏⵎⴶⵔⴶⵙ ⵢⵏ ⴶⵏⵏ ⴶⵢ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ⴹ ⵙⵎⴹⵔⵏ ⴶⵔⵙ ⴹⵎⵏⵜ ⴶⵏⵓ \"ⵓⴾ ⵎⴰ ⵤⴶⵗ⵰ ⵏⴾ ⵀⵙ ⵍⵗ ⴹⴶ ⴹⵗ ⴶⵗ ⵜⵗⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ⵜⵤⵔ ⵏⴰ \"ⵙⵏⵗ ⵓⴰ ⵤⴶⴰ⵰ ⴹ ⵔⵤⵗ ⵛⴹⵏ⵿ⴶⵓⵏⵏ ⴾⵔⵙⵗ ⵛⵏ ⵜⵏⵜⴶⵔⵏⵏ ⵛⴹⵓⵗ ⴹⵗⵙⵏⵜ ⵜⵗⵎⵏ ⴾⵍ ⴹⵓⴰ ⵍⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ⵎⵔⵏ ⵏⵗ ⵢ ⵎⵏⵏ \"ⵢⴰ ⵎⵏ⵿ⴹⵎ ⵜⵍⵗ ⵔⵤⵗ ⴶⵏ ⴹⴾⴶⵏ ⵍⵏ ⴶⵜⵏⵏ ⵙⵏ⵿ⴼⵓ ⵜⵜⵛⴰ ⵜⵛⵓⴰ ⵜⵏⴼⵍⵢⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ⵎⵛⵏ ⵏⵙ ⵎⵛⵏⴰ \"ⵎⵙⴾⵍ⵰ ⵂⴹ ⴹⴰ ⴾⵢⵤⴶⵎⴹⵏ ⵎⵏⴾ⵰ ⵎⴰ ⵤⴶⵔⵓⵏ ⵓⴰ ⵜⵛⴹⵓⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ⵓⵏ ⴹⵗ ⴶⵔⵓⵏ ⵓⴹⵏ ⵓⴰ ⵛⴹⵓⵏ ⴹⵏⵜ ⴼⵍ ⵎⵏⵜ ⵎⵔⵏ ⵓⵔ ⵛⴹⵓ ⵓⵍⴰ ⴹⵗ ⵜⵍⵗⴰ ⵜⴰ ⴶⵔⵙ ⴹⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵓⵏ ⴹⴰ ⴼⵍ ⴹⵓⵏⵏⵗ ⴾⵓⵏⵓⵔ⵿ⵜⵛⵓⵛ ⵜⵎⴹⵔ⵿ⵜ ⴶⵔ ⵓⴰ ⵤⴰ ⵜⵜⵛⵎ ⵓⵍⴰ ⵓⴰ ⵤⴰ ⵜⵍⵙⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ⴼⵍⵙ ⵎⵏⵓⵏ ⴶⵔⵏ ⵎⵏ⵿ⵙⵓⵏ ⵍⵎⵆⵎ ⵜⵗⵙⵏⵓⵏ ⴹⵗ ⵜⴶⵔ ⵙⵍⵙⴰ ⵍⵎⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ⵏ⵿ⵤⵔⵜ ⴹⵗ ⵗⵔⵜⵏ ⵓⵔⵎⴹ ⵏⵀⵍⵏ ⵤⴰ ⵓⵔ ⵜⵍⵢⵏ ⵓⵔⵎⴹ ⵍⵏ ⵙⵗⵀⵔ ⵤⴰ ⵓⵍⴰ ⵛⴹⵏ⵿ⴶⵓⵏ ⵎⵛⵏ ⵙⴹⵔ⵿ⵜⵏ ⵎⵛⵏⴰ⵰ ⵜⴼⵎ⵿ⵜⵏ ⵤⴰ ⵙⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴼⵔⴶⵏ ⵙⵛⵓⵛⵏⵜ ⵛⵜⵢ ⵏ⵿ⵜⵗⵔⵙ⵿ⵜⵏⵜ ⵙ ⵓⵍⴰ ⵍⴼ ⵏⵛⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ⴹⴹ ⵤⵎⴰ ⵙ ⵓⵔ ⵜⴼⵔⴶⵎ ⴶⵢ ⵏⴶⴹⵏ ⴹⵓⴰ ⵜⵎⴹⵔⵢⵜ ⵎⴰ ⴼⵍ ⵙ ⴾⵓⵏ ⵛⵓⵛ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ⵏ⵿ⵤⵔⵜ ⴹⵗ ⵎⴾ ⵓⵙ ⴹⴹⴶⵍⵏⵜ ⵜⵌⴶⵓⵏ ⵓⵔⵎⴹ ⵛⵆⵍⵏⵜ ⵓⵍⴰ ⵤⵜⵏⵜ ⵙⵍⵙⴰ ⵎⵛⵏ ⵏⵗⵓⵏ ⵓⵍⴰ ⵎⵏⴾⵍ ⵙⵍⵎⵏ ⵂⵔⴾⴹ ⵜⴶⵔⴶⵙ⵿ⵜⵏⵜ ⴾⵍ ⵓⵔ ⴾⵍⴰ ⴹ ⵓⴹ ⵓⵍⴰ ⵢⴹⴰ ⴹⵗⵙⵏⵜ ⵛⵂⵙⵢ ⵏ⵿ⵜⵍⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ⴹⴹ ⵙⵍⵙⵓ ⵎⵛⵏⴰ ⵢⵍ ⵙ ⵜⵎⵓⵜ ⵜⴹⵢ ⵙⵤⵍⴹⴰ ⵀⴹⴹ ⵜⴼⵜ ⴹ ⵜⵓⵙⵔⵗⵓ ⴹⵗ ⵜⵌⵏ⵿ⴶⵔⵔ⵿ⵜ⵰ ⵎⵏⵎⴾ ⵙ ⴾⵓⵏⵓⵔⵤⵙⵍⵙⵓ ⴾⵍ ⵤⴶⵤⵏ ⵏ⵿ⴹⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ⴹⵗ ⴹⵢ ⴾⵓⵏⵓⵔⴹⴶⵤⵏ ⵎⴹⵔⵏⵏ ⵏⵓⴰ ⵤⴰ ⵜⵜⵛⵎ ⵓⵍⴰ ⵓⴰ ⵤⴰ ⵜⵛⵓⵎ ⵓⵍⴰ ⴹⵗ ⵛⵓⵛⵏ⵿ⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","31","ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⵤⵍⵏⵏ ⴹⵗ ⴶⵎⵢⵏⵙⵏ⵰ ⵎⵛⵏ ⴾⵓⵏⵢ ⴹⴶⵤⵜ ⴹⵗ ⴶⵎⵢ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⴾⵓⵏ⵿ⵜⵓⴾⴼⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴼⵍⵙ ⵀⵏⵓⵏ ⵙⵏ ⵙ ⵜⴹⵔⵔⵎ ⵙⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ⵜⵙⴶⵔ⵿ⵜ ⵏⵢⴼⴹⵏ ⴾⵎⵜⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ ⴼⵍⵙ ⵀⵏⴾⵎⵜ ⴶⵔⵤⵙ ⵓⵍⵏ ⴾⵎⵜⴾⴼⵓ ⵜⵗⵎⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ⵤⵏ⵿ⵤⵜⵏ ⵓⴰ ⵜⵍⵎ ⵜⴾⵜⵎ⵿ⵜⵓ ⵢ ⵜⵍⵆⵓⵏ ⵜⴶⵎ ⵢ ⵎⵏⵓⵏ ⴼⵔ⵿ⵜⵎⵏⵜⵏ ⵓⵔ ⵏⵜⵎⵏ⵿ⴹⵓ ⵜⵛⴹⵓⵎ ⴹⵗ ⵌⵏⵓⵏ ⵔⵤⵗ ⵓⴰ ⵓⵔ ⵏⵗⵔⴹ ⵓⵔ ⵎⴹ ⵜⵏ⵿ⵤⵂⵤⵏ ⵀⵢⴹⴶⵏ ⵓⵍⴰ ⴹⵗ ⵜⵗⵛⴹⵜⵓ ⵜⵎⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ⴹⴶ ⵓⴰ ⵜⴶⵤ ⵜⴶⵔⴶⵙ⵿ⵜⵏⵓⵏ ⵏ⵿ⵜⴰ ⵤⴶⵤⵏ ⵓⵍⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«ⵆⵍⵜ ⵢⵜⴹⵏ ⵜⵀⵏⵏ ⵙ ⵔⵗⵏⵜ ⴼⵜⵍⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ⵜⵍⵎ ⴹⴾⵍⵏ ⵆⵍⵏⵏ ⵢⴹ ⴹⴼⵍ ⵎⵛⵙⵏ ⵜⴾⵔⵙ⵿ⵜ ⴼⵍ ⵙⵔⵙ ⵏⵀⴹⴹⵏ ⴹⴰ ⴹⴰ ⴹ ⴹⵤⴾⵜ ⴹⵗ ⵎⵢ ⵏⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ⵀⵍⵍⵏ ⴾⵍⵏ ⵓⵏ ⴹⴶⵤ ⵎⵛⵙⵏ ⴾⵢⵏ⵰ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹ ⵜⵀ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙⵗⵎⵏ ⵙⵎⵏ⵿ⵙⵓⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ⴶⵔ ⵤⵆⵍⴹⵓ ⴹⵓⵏⵢ ⵏⵂⴹ ⵓⵍⴰ ⴹⵗ ⵎⵙ ⵏⵂⴹ ⴾⵍⵏ ⵓⵏ ⴹⴶⵤ ⵎⵛⵙⵏ ⴾⵢⵏ ⵀⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ⵓⵔⴶⵗ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵙⵏⵎ ⵙ ⵏⵔ ⵙⵏ ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⵎⵤⵢ ⵓⴰ ⴹⵗ ⴹⵤⴹⵍ ⵀⵢⴹⴶ ⴾⵢ ⵙⵎⵜⴶ ⵢⴹⵙⴶⴹⵍ ⵜⵔⵤⵢ ⵏⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ⵙⵎⵜⴶⵜ ⵤⴰ ⴾⵓⵏⵢ ⴹⴰ ⴼⵍⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹ ⴹⵙⴰ ⴹⵗ ⵙⵗⵜ ⵜⵙ ⵓⵔ ⵜⵔⴹⵎ ⴹⵗⵙ ⴹⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ⵜⵤⵔ ⵏⵙ ⵀⵜⵔⵙ «ⵎⵍⵢ ⵏⴾⵏⵢ ⵗⵙ ⴼⵍ ⵜⴶⵗ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⵜⴹⵢ ⵎⵗ ⵢⵜⴹⵏ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ⵌⵓⵀⵙ ⵎⵍⵢ ⵗⵢⵙⴰ ⵏⵙ «ⵎⵛⵗⵍ ⵓⴰ ⵗⴹⵍⵏ ⵍⴰ ⴹⵗ ⴶⵔⵢ ⵏ⵿ⵜⴰ ⵙⵏⴼⵔⵏ ⵎⵛⵙ ⵤⵤⵔ⵿ⵜⵓ ⵢ ⵎⵛⵗⵍⵏⵜ ⵓⵏ ⵂⴹⵜⵏⵏ ⴼⵍ ⵜⵏⵂⴾⵓ ⴹⴶⵔⵏⵙⵏ ⴹⵗ ⵙⴹⵔ ⴹⵗ ⵍⵓⵆ ⵓⴰ ⴶⵎⴹⵏ ⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ⵀⵍⵍ ⴾⵍⵢ ⵓⵏ ⵙ ⴹⵆⵍ ⵎⵛⵙ ⴶⵤⵜⴹ ⵂⴰ ⵛⵗⵍ ⵓⴰ ⴹⵆ ⵆⴹⵢⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹ ⵜⵤⵤⵔ ⵎⵛⵙ ⵢ ⵜⵍⵏⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ⵎⵛⵏ ⵏⵔ ⵏⴰ ⴾⵍⵢ ⵓⴹⵢ ⴹⵗ ⵎⵏⵜ \"ⵎⵛⵢ ⵍⵍⵜⵏ\" ⵜⵤⵔ ⴹ ⴶⵜ ⵎⵛⵗⵍⵏ ⴹⵜⵎⵛⵗⵍⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵜⵓ ⵙⵙⵓ ⵙⵎⴹ ⵂⵔ ⵎⵙⵓⴹ ");
INSERT INTO ttqt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ⴾⵍⵢ ⵓⴹⵢ ⵍⴾⵎ ⵜⴹⵗⴹⵔ ⵎⵛⵙ ⴹⵗ ⵤⵍ ⴹⵎⵤⵢ ⵓⵔ ⵔⴹⴰ ⵜⵤⵔ ⴹ ⵜⴶⵜ ⵂⵔ ⵜⴾⵙⵏ ⴶⵢ ⴹⴹ ⵜⵓⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵗⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ⵎⵔⵏ ⴾⵍⵢ ⵓⴰ ⵙⵏⵏ ⵓⴰ ⵔⴰ ⵎⵛⵙ ⵆⵎ ⵓⵔ ⵜⴶⴰ ⵎⴹⵗ ⵓⵔ ⴶⴰ ⵏⵢⵜ ⵏⴶⵏⵜ ⴹⵙ⵿ⵜⵓⴶⵏⵜ ⵜⵓⵜ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ⵎⵛⵏ ⴾⵍⵢ ⵓⴰ ⵓⵔ ⵏⵙⵏ ⵓⴰ ⵔⴰ ⵎⵛⵙ ⵎⵔⵏ ⴶⴰ ⵔⵜ ⵂⵔⵏ ⴹⵓⴹⵀ ⴹⵙ⵿ⵜⵓⴶⵏⵜ ⵜⵓⵜ ⵓⵔ ⵏⴶⵜ⵰ ⵓⴹⵏ ⴶⵔⵓⵏ ⴶⵏ ⴹⵗⵙ ⵜⵓⴶⵎⵢ ⴶⵏ⵰ ⵢ ⵜⵓⵙⵗⵍⴼⵏ ⴶⵏ ⴹⵗⵙ ⵜⵓⴶⵎⵢ ⴶⵔⵏ ⵓⴰ ⵜⵓⵙⵗⵍⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ «ⵙⵗⴹⵓ ⴼⵍ ⴹ ⵙⵔⵗⴰ ⵜⵎ⵿ⵙⵢ ⴹⵗ ⴹⵏⵜ⵰ ⵙⴹⵔⵏⵗ ⴹ ⵎⵙ ⵙ ⵜⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ⵎⵔⵏ ⵍⴾⵎ ⴹⵗⵢ ⵜⵓⵙⵍⵎⵗ ⵙⴾⵜ ⵓⵔ ⵜⴶⵗ ⴾⵏⵏⵢ ⵎⵏⵏ ⴹⴶⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ⵜⵔⴹⵎ ⵙ ⵙⴰ ⴹⴶⵗ ⴼⵍ ⴹⵓⵢⵗ ⵍⵈⵔ ⵙⴹⵏⵜ⵰ ⴾⵍⴰ ⴾⵍⴰ ⵏⵎⵤⵔⵢ ⵙⵔⵙ ⴹⵓⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ⴹ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵙⵎⵙ ⵢⵜⴹⵏ ⵏⵂⵏ ⵢⵏ⵿ⴹⴰ ⴹ ⵏⵎⵤⵔⵢⵏ ⵓⵔⵏ ⴾⵔⴹ ⴶⵏⴰ ⴼⵍ ⵛⵏ ⵛⵏ ⴹⵗ ⵓⵔⵏ ⴶⵏⴰ ⴼⵍ ⴾⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ⴹ ⵏⵎⵤⵔⵢ ⵍⵙ ⴹⵀⵔⵔⵏⵜ ⵀⵔⵔ ⴹⵗ ⵏⵎⵤⵔⵢ ⴹⵀⵏⵜ ⵜⵏⵎⵤⵔⵢ ⵜⵏ⵿ⵜⵜ ⴹⵜⵀⵔⵔ⵿ⵜⵏⵜ ⵜⵀⵔⵔ⵿ⵜ ⴹⵗ ⵜⵏⵎⵤⵔⵢ ⴹⵏⵏⵜ ⵜⵏⵎⵤⵔⵢ ⵜⴹⴶⵍ⵿ⵜ ⴹⵜⵏ⵿ⵜⵜ ⵏⵀⵔⵔⵏⵜ ⵜⵏⵎⵤⵔⵢ ⴹⵗ ⵜⵏ⵿ⵜⵜ ⴹⵜⴹⴶⵍ⵿ⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ⵏⴰ ⵗⵢⵙⴰ ⴹⵗ ⵢ ⵜⵎⵜⵢ «ⵓⵔⴶⵗ ⵙ ⵜⵏⵢⵎ ⵜⴶⵔⴾ ⵙ ⴹⵜⴶⵎⴹ ⴹⵗ ⵜⵔⵎ ⴹ ⵜⵏⵎ ⴹⵢ ⴹⴰ \"ⴾⵏⴾ ⵤⵢⴹⵓ⵰\" ⵜⵤⵔ ⴶⵓ ⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ⵙ ⵜⵏⵢⵎ ⴹⵗ ⵂⴹ ⵙ ⴹⴶⵔ ⴹ ⵜⵏⵎ \"ⴹ ⵜⴶⵓ ⵜⴾⵙⵢ⵰\" ⵜⵤⵔ ⴶⵓ ⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ⵍⵎⵏⴼⵆⵏ ⵜⵙⵏⵎ ⵎⵍ ⵏⵍⵗⵍⵎⵜⵏ ⵛⵏ ⴶⵏⵏ ⴼⵍ ⵎⴹⵍ ⴹⵛⵏ ⴶⵏⵏ ⴹⵗ ⵌⵏⵓⵏ ⵎⵛⵏ ⴹⵙ ⵓⵔ ⵜⴶⵔⵎ ⵤⵎⵏ ⵓⵏ ⴼⵍⵓⵏ ⴶⵏⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ⵎⴼⵍ ⵤⴰ ⵓⵔ ⵜⴶⵔⵎ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵓⴰ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ⵎⵙⵍⵏ ⵙ ⴾⵢⵗⵔⴰ ⵓⴹⵏ ⵙⴹⴶ ⵏⵛⵔⵗⴰ ⵜⴶⵎⵢⴰ ⵜⵎⵓⵜ ⵙ ⵜⵏⵎⴾⵏⵎ ⴹⵗ ⵜⵔⵢⵜ⵰ ⵙ ⵓⵔ ⵜⴶⵗ ⴹⵢ ⴾⵢⵍⵓⵢ ⵂⵔ ⴾⵢⵙⵀⴹⴹ ⴹⵜ ⵍⵆⵍⵢ⵰ ⵍⵆⵍⵢ ⵎⵔⵏ ⴾⵢⴶⵓ ⴹⵗ ⴼⵙⵏ ⵏ⵿ⵙⵌⵢ ⵓⴰ ⴾⵢⵤⴶⵔⵏ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⵔ ⴹⵤⵜⴶⵎⴹⴰ ⴾⵜ ⵓⵔ ⵜⵔⵤⵎⴰ⵰ ⵓⵍⴰ ⵜⵎⴰ ⵢⴹⴰ ⵓⵔ ⴹⵏ⵿ⵤⵜⵆⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵗⵢⵙⴰ ⵙ ⴹⵏ⵿ⴾⵔⵏ ⵢⵜⴹⵏ ⵍⵏⵏ ⴹⵏ ⵙⵗⵍⵏⵙ ⵙⵍⵏ ⵏⵎⴹⵏ ⵓⵢⴹ ⵏ⵿ⴶⵍⵍⵢⴰ ⵙ ⵙⵙⴶⴰ ⵏⵈⴾⵎ ⵀⵍⵜⵙ ⵎⵏⵙⵏ ⵍⵓⵆ ⴹⵗ ⵜⴶⵏ ⵛⴾⵜⵓⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴾ ⵜⵔⴹⵎ ⵙ ⴾⵍⴶⵍⵍⵢⴰ ⵓⵏ ⴹⵢ ⴶⵔⵏ ⴾⵍⴶⵍⵍⵢⴰ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ ⴼⵍ ⵙ ⴶⵏ ⵔⴾ ⵜⵎⵜⵏ⵿ⵜ ⵜⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ⵏⵗⵓⵏ ⴾⵍⴰ⵰ ⵎⵔⵏ ⴾⵓⵏⵢ ⴹⴰ ⵙ ⵓⵔ ⵜⵜⵀⵎ ⴹ ⵜⵂⵍⴾⵎ ⴾⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ⵎⴰ ⵜⵏⵎ ⵤⴰ ⵙⵢⵜⴹⵏ ⵓⵏ ⵎⵔⵓ ⴹⵜⵎ ⵓⵏ ⴼⵍ ⵀⵔⵌⵜ ⵙⵔⵓ ⵓⵙ ⵜⵓⵏⵓ ⵙⵍⵓⵎ ⴹⵗ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵏ⵿ⵗⵏ⵰ ⵜⵔⴹⵎ ⵙ ⴶⵔⵏ ⴾⵍⵢⵔⵙⵍⵎ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ⵏⵗⵓⵏ ⴾⵍⴰ⵰ ⵎⵔⵏ ⴾⵓⵏⵢ ⴹⴰ ⵙ ⵓⵔ ⵜⵜⵀⵎ ⴹ ⵜⵂⵍⴾⵎ ⴾⵜⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ⴶⵙⵏ ⵗⵢⵙⴰ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⵢⵜ ⵏⵙⵏ «ⴾⵍⴰ ⵏⵀⵍ ⵍⵙ ⵢⵏ ⵛⴾ ⵙ ⵜⵓⵏⵓ ⴼⴶ ⴹⵗ ⴼⵔⴶⵏⵜ ⵏⵍⵗⵏⵀ⵰ ⵙ ⵜⴶⴰ ⵜⵎⵔ⵿ⵜ ⵏⵔⵏⵜ ⵙⵢⴹⵓ ⵢⴹ ⴹⵏ⵿ⴾⴹ ⵔⵜⵏⵜ ⵎⵛⵏ ⵓⵔ ⴹⵗⵙ ⴶⵔⵓ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ⵜⵤⵔ ⵏⴰ ⵢⵎⵛⵗⵍ ⵓⴰ ⵏⵜⴼⵏ ⴹⴼⵔⴶ \"ⵏⵢ⵰ ⵎⵔⴹⴰ ⴾⵔⴹ ⵍⵏ ⴶⵗ ⵜⵙⴹⵓ ⴶⵎⵢⴹⵓ ⵔⵜⵏ ⵏⵛⴾ ⵓⴰ ⵎⵛⵏ ⵓⵔ ⴾⵍⴰ ⴹⵗⵙ ⴶⵔⵓⴰ ⵓⵍⴰ⵰ ⴹⵗ ⴹⵢ ⵗⵜⵙ⵿ⵜⵏ⵰ ⵎⴰ ⴾⵏⵓ ⴹⵗ ⵎⴹⵍ ⵓⵔ ⵜⴹⵜⴶⵎⴹ ⵜⵏ⵿ⴼⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ⵏⵙ ⵎⵛⵗⵍ ⵓⵏ \"ⵎⵛⵢ ⵔ ⴹⵗⴾ ⵜⵜⵢⴰ ⵜⵏⵓⴰ ⴹⴰ ⵗⵙ ⴹ ⵗⵤⵗ ⵎⴹⵍ ⵓⴰ ⵜⵗⵍⵢⵏ ⵏ⵿ⵗⵍⴰ ⴹⵗⵙ ⵜⵎⵆⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ⵂⴰ ⵎⵌⵙ ⵓⵜⵢ ⵓⴰ ⴹⵤⵢⵏ ⴹ ⵔⵓ ⵙ ⵓⵔ ⵔⵓ ⵜⵙⵗⵜⵙⵆⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ⵤⵍ ⵢⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ⵜⵍⴰ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⴹⵏ ⵜⵍⵜ ⵎⵔⵓ ⵍⵏ ⴹⵜⵎ ⵙⵔⵏ⵿ⵜⵜ ⴶⵙⴼ ⵎⵙ ⵔⵔⵏⵜ ⵜⴶⵏ⵿ⵤⵢ ⵓⵔ ⵜⴼⵔⴶ ⵆⴹ ⵏ⵿ⵜⵀⴹⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ⵙ ⵜⵜⵏⵢ ⵗⵢⵙⴰ ⵗⵔⵜⴹⵓ ⵜⵤⵔ ⵏⵙ «ⵜⵏ⵿ⵜⵜ ⵜⵓⵔⵏⵏⵎ ⵜⵤⵢⵗ ⴹⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ⵙⵓⵔ⵿ⵜⵜ ⴼⵙⵏⵜ ⵜⵗⴹ ⵜⵀⴹⵢⵏⵜ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹ ⵜⵎⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ⵎⵛⵏ ⴶⵤ ⵍⵂⵎ ⵎⵤⵔ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⴼⵍⵙ ⵤⵤⵢ ⵗⵢⵙⴰ ⵓⴹⵏ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏⴰ ⵎⵤⵔⵏ ⵢ ⵜⵎⵜⵢ «ⵓⵔⴶⵗ ⵙⴹⵙ ⴹⵏ ⵙ ⵎⴾⵏ ⴹⵗⵙⵏ ⵜⵓⴶⵓ ⵛⵗⵍ⵰ ⵙⵓⵜⴹⵓ ⴹⵗⵙⵏ ⵜⴶⵎⵢⵎ ⵜⵎⵤⵢⵜ ⵓⵔⴶⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ⵏⵙ ⵗⵢⵙⴰ «ⵍⵎⵏⴼⵆⵏ ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⵓⵔ ⵏⵜⴾⵙ ⵜⵓⵗⵏⵢ ⵢⵤⴶⵔⵏⵜ ⵎⴹⵗ ⵜⵔⴶ ⵌⴹⵏⵜ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵢⵜⴹⵛⵛⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ⵜⵂⵢⵓⵜ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⵜⴰ ⵎⵔⵏ ⴾⵔⴹ ⵀⵍⵙ ⵍⵏ ⵎⵔⵓ ⵍⵏ ⴹⵜⵎ ⴹⵙ ⵓⵔ ⵎⴾⵏ ⴹ ⵜⵜⵓⵤⵤⵢ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵓⵏ ⵜⵀⵤ ⵜⴾⵔⴾⵜ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵏⵎⵤⵔⵢⵏⵜ ⵢⵜⴹⵏ ⵙⴰ ⵂⴹⵏ ⵎⵔⵏ ⴾⵜⵏⵙⵏ ⵙⴹⵓⵏ⵿ⵜⵏ ⵎⵤⵍⵏ ⴾⵏⵏⵏ ⵛⵂⵙⵢ ⵓⵏ ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ⵏⴰ ⵗⵢⵙⴰ «ⵎⴰ ⴹⵔ ⵜⵍⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵎⵙ ⵜⵜⵤⵎⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ⵜⵍⴰ ⴹⵎⵙⴰ ⵏⵏⵀⵜ ⴶⵏ ⵙⵎ ⵎⵜⵔⴹ ⴹⴾⵍ ⵓⴹⵏ ⵏⵀⵍ⵿ⵜⵓ ⴹⵗ ⴼⵔⴶⵏⵜ ⴹⵓⵍ ⵆⵍ ⵛⴾ ⴹ ⵜⴶⵏ ⴶⴹⴹ ⵛⵙⵍⵍⴰ ⴹⵗ ⵤⵍⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵎⵙ ⵤⵎⵜⵍⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ⵜⵍⴰ ⴹⵈⵎⵔⴰ ⵜⵔⵓⵢ ⵜⵏ⵿ⵜⵜ ⴹⴾⵔⴹ ⵏⴼⵗⵜⵏ ⵏⴶⵍ ⵏⵍⴾⵎⴰ ⵂⵔ ⴾⴼ ⴶⵍ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ⴶⵍⴰ ⵗⵢⵙⴰ ⵍⵍ ⵗⵔⵎⵏ ⴹⵜⵗⵔⵎⵜⵏ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⴹⴶ ⵙⴰ ⵙⵔ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ⵏⵙ ⵓⴹⵏ ⵢⵏ «ⵎⵍⵢ ⵓⴾ ⵢⵜⴹⵏ ⵓⵔ ⵏⴶⵜ ⵗⵙ ⵤⵙⴼⵙⵓ ⵎⵛⵏⴰ⵰» ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ⵎⵢ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵢ ⴾⵔⵤⵏ ⴹⵗ ⴹⵢ ⵀⵍⵏⵜ ⵜⴶⵎⵢⵎ ⴹⴶⵤⵏⵜ⵰ ⵏⵗⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵤⴶⵎⵢⵏⵏ ⴹⴶⵤⵏⵜ ⵎⵛⵏ ⴹⵙⵏⵏ⵿ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ⵙ ⵌⵓⵔ ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⵗⴼⵍⵏ ⴼⵍ ⵎⵏⵜ ⵜⵙⵂⵔ⵿ⵜ ⵏⵂⵏ ⴾⵓⵏⵢ ⵜⵀⴹⴹⵎ ⴹⵜⵙ ⴹ ⵜⴶⵤⵎ ⵛⵏ ⴾⴾⵓ ⵜⴶⵏⵎ \"ⵎⵏ⵿ⴹⵎ ⵍⵎⵏⵗ⵰\" ⵏⵓⵏ \"ⵓⵔ ⴾⵓⵏⵤⴹⵢⵗ ⵤⴰ ⵓⵔ ⵙⵏⴰ ⴹⴰ ⴹⵜⴼⵍⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ⵍⵓⵆ ⵓⴹⵢ ⴹⵙ⵿ⵜⵏⵎ \"ⵓⵔⴶⵗ ⵏⴹⵔⵓ ⴹⵔⴾ ⵜⵜⵢ ⴹⵜⵙⵢ ⵜⵙⵙⵗⵔⴰ ⴹⵗ ⴹⵗ ⵗⵔⵎⵏⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ⵎⵛⵏ ⴹⵓⵏⵏⵓ \"ⵏⴾ ⵓⵔ ⴾⵓⵏⵤⴹⵢⵗ⵰ ⴾⵜⵏⵓⵏ ⵎⴶⵏ ⵏ⵿ⵜⵍⵀⵙ⵿ⵜ ⵜⵎⵙⵎ ⴶⴶⵜⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ⵙ ⵜⵏⵢⵎ ⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹⵢⵆⵀ ⴹⵏⵀⵜⵏ ⴾⵍ ⵆⵎⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵜⵓⵙ⵿ⵜⵗⵎ ⴹⵗⵙ ⴹ ⵜⵍⵎ ⴹ ⵜⴹⴹⵎ ⴹⴹⵓⵏⵓⵏ ⴼⵍ ⵜⵎⴶⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ⴹ ⴹⴶⵎⴹⵏ ⵢⵜⴹⵏ ⴹⵏⴶ ⴹⵜⵔⵎ ⴹⵜⵎⵙⵏⴰ ⴹⴶⵍⴰ ⵜⵤⵔ ⵏⵗⵎⵏ ⴹⵔⵓⵏ ⵎⴶⵔⴰ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ⵏⵢⵜ ⵤⴰ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵍⵆⵎ ⵎⵔⴹⴰ ⴹ ⵤⵔⵏ ⵓⵏ ⵤⵔⵏⵏ ⴹⵗ ⵎⵔⴹⴰ ⴹ ⴶⵤⵏ ⵍⵆⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵜⴹⵂⵤⵏ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ ⵏⵏⵙ «ⴶⵎⴹ ⴹⴶ ⴰ ⴼⵍⵙ ⵎⵏⴾⵍ ⵂⵔⴹ ⵔⴰ ⴶⵢ ⵏⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵍⵜ ⵜⵏⵏ ⵢⵓⵆⵙ ⵓⴰ ⴶⵏ ⵂⵔⴹ \"ⵜⴾⵙⵗ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵤⵤⵢⵗ ⵎⵔⵏⵏ ⵤⵍⴹⴰ ⴹⵜⴼⵜ ⵎⵔⵏ ⵤⵍ ⵓⵏ ⴾⵔⴹ ⴹ ⵙⵏ⵿ⴹⴰ ⵛⵗⵍⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵛⵍ ⵎⵙ ⴹ ⴶⵍⴰ ⴹⵗ ⵛⴾⵍⵏ ⵤⵍⴹⴰ ⴹⵜⴼⵜ ⴹⵜⴼⵜ ⵜⵏ ⴼⵍⵙ ⵓⵔ ⵎⴾⵏ ⴹ ⵀⴰ ⵏⵀⵢ ⴹⵗ ⴹⴶ ⵓⵔ ⵏⵎⵙ ⵢⵔⵙⵍⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ⵏⴰ ⵗⵢⵙⴰ «ⵈⴰ ⵢⵜⴹⵏ ⵏⵢⵔⵙⵍⵎ ⴾⵜ ⵜⴶⵎ ⵎⵏ ⵏⵏⵀⵜⵏ ⵜⵏ⵿ⵗⵎ ⴹⵗ ⵙ ⵜⴶⵔ ⵏ⵿ⵜⵂⵏ ⵓⵏ ⵙⵔⵓⵏ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵂⵔ ⵎⵏⴾⵜ ⵜⴾⵍⵜⵏ ⴶⵎⵢⴰ ⴹⴾⵓⵏ⵿ⴹⵛⴹⵓⴰ ⵙⵎⴾ ⵙ ⴹⵜⵛⴹⵓ ⵜⴾⵌⵜ ⴾⵔⵜⵏⵜ ⴹⵓ ⴼⵔⵜⵏⵜ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ⵏⵢⵜ ⵤⴰ ⵎⵛⵏⴰ ⴹⵗⵓⵏ ⴹⴾⵍ ⴼⵙⵏⵜ ⵆⵍ ⵂⵏⵓⵏ ⵎⵌⵔ⵰ ⵎⵔⵏ ⵏⵗⵓⵏ ⵓⵔ ⴹⵤⵜⵍⵙⵎ ⵏⵢ ⴾⵜ ⵓⵔ ⴹⵙⴰ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵏⵎ \"ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ ⴶⵔⵓ ⵔⵈⵎⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ⵤⵍ ⵢⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵤ ⵗⵢⵙⴰ ⵂⵏ ⵏⵢⵏ ⴹⵗ ⵎⵤⵔⵏ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴼⵍ ⵗⵔⵙ ⵜⵛⵓ⵰ ⴶⵔⵏ ⴹⵗⵙ ⴼⵔⵙⵢⵜⵏ ⵍⵏⵏ ⴹⵏ ⵛⵜⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ⵍⴰ ⵍⵙ ⵢⵏ ⴹⵏ ⵙ ⵀⵢⵗⵜ ⵍⵎⵏⵜ ⴾⵜⵏⵜ ⵆⵎ ⴹⵜ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵏⵙⵏ «ⵓⴾ ⵤⵤⵢ ⵏⵓⴹⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵈⵍⵍ ⵎⵗ ⵓⵔ ⵈⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ⵎⵛⵏ ⵓⵔ ⴹⵙⵏⵏ ⵓⵍⴰ⵰ ⵎⵔⵏ ⴹⵙ ⵗⵢⵙⴰ ⵎⵔⵏ ⵏ ⵤⵤⵢⵜⵓ ⵙⴶⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ⵜⵤⵔ ⵏⵙⵏ «ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⵙ ⵤⵂⵏⵢⵏ ⵀⵔⵔⵏⵜ ⵎⴹⵗ ⵤⴶⵔⵏⵜ ⵂⵔ ⵆⵍ ⴹⵗ ⵏⵓ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵆⵎ ⵓⵔ ⵜⴹⴾⵙ ⴹⵗⵙ ⵜⵎⵤⵢⵜ ⵜⴹⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ⵓⵔ ⵙⵏⵏ ⴹⵙⵏⵏ ⴹⵗ ⵀⵜⵜⵏ ⵛⵏ ⴶⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ⴶⵔⵏ ⵗⵢⵙⴰ ⵙⵏⴼⵔⵏ ⵓⴰ ⴶⵏ ⵏⴼ⵿ⵜⵗⵏ ⴹⴶⵏ ⵓⵏ ⵜⴶⵤⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⵜⵤⵔ ⴶⵙⵏ ⵂⵍ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ⵙ ⴹⵗⴾ ⴶⵎⵢ ⵓⴹⵏ ⵤⵤⵍⵢⵏ ⴹⵙⵏ⵿ⵜⵎⴶⵔⵗ ⴹ ⵓⵔ ⵜⵙⵏⴼⵔⵏⵗ ⴹⴶ ⵓⴰ ⵜⴶⵤⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⴼⵍⵙ ⵎⵌⵙ ⴶⵎⵢ ⴹⵗ ⵓⴹⵏ ⵢⵏ ⴾⵢⴶⵔⵏ ⵍⵎⵆⵎ ⴹⵙⵏⵎⴶⵔⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ⵜⵤⵔ ⵙⴾⴹⵓ ⵎⵛⵙ ⵏⵂⵏ ⵓⴰ ⴾⵓⵏ⵿ⴹⵗⵔⵏ ⵙ ⵎⴶⵔⵏⵜ ⵏⴾ \"ⴶⵎⴹ ⴹⴶ ⵢⵍⵙ ⵓⴰ⵰\" ⵜⵀⵤⴾⵢ ⵜⴾⵔⴾⵜ ⵜⴾⵗ ⴹⴼⵔ ⵢⵜⴹⵏ ⵜⵆⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ⴾⵍⵔ ⵙ ⴹⵗⴾ ⵜⵓⴶⵎⵢ ⴹⵏ⵿ⵜⵙⵗ ⵎⴶⵔⴰ ⵜⴾⴰ ⴹⴼⵔ ⵢⵜⴹⵏ ⵜⵆⵎⴰ⵰ ⴹⵢ ⵙ ⴹⵙⴰ ⵎⵛⵙ ⵏⵂⵏ ⴹⴾⵏⵓ \"ⵎⴹⵏⵏ ⵤⵏ⵿ⴾⵤⴹⵓ ⵙⴹⴶ ⴼⵏ ⵓⴹⵢ⵰\" ⴾⴼⴾ ⴹⵢ ⵜⵓⵙⵗⵎⵔ ⵗⵔ ⵏⴼ⵿ⵜⵗⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⴾⵍⵏ ⵎⵏⵜ ⴹ ⵜⵓⵙⵔⵙ ⵓⴰ ⵙⵔⵙⵏ ⵎⵏⵜ ⴹⵗ ⴹ ⵜⵓⴹⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⴼⵔⵙⵢ ⵓⵙ ⵏⴼ⵿ⵜⵗ «ⵙ ⴹⵜⵗⵔⵗ ⵢⵜⴹⵏ ⵢⵜⵏ⵿ⵜⵛⵜⵛⵗ ⵤⵍ ⵎⴹⵗ ⵂⴹ ⴹⵓⵔ⵿ⵜⵗⵔⴰ ⵎⴹⵓⵏⴾ ⵓⵍⴰ ⵎⴹⵔⵢⵏⴾ ⵓⵍⴰ ⵛⵆⵗⵏⴾ ⵓⵍⴰ ⵎⵂⵔⴶⵏⴾ ⵏⵎⴶⵔⴶⵙ ⴼⵍ ⴾⵢⴹⵓⵔⵗⵔⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵤⵍ ⵢⵏ ⵔⵤⵎⵏⴾ ⵓⴰ ⴹⵙⵏ⵿ⵜⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ⴾⵍⵔ ⵙ ⵆⵍ ⵙ ⵜⵛⵜⵛⵗ ⵢⵜⴹⵏ ⵛⵜⵛⵓ ⵛⵍⵆⵓⵏ ⴹⵏⵀⴹⵏ ⴹⵎⴶⴹⵍ ⴹⵎⴹⵔⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ⵜⵀⵍⵍⵗ ⵙ ⵜⴶⵗ ⴹⵢ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵓⵔ ⴼⵔⴶⵏ ⴹⴾⵔⵤⵎⵏ⵰ ⵔⵤⵎⵜⵏⴾ ⵜⵏ⵿ⵜⴶⵔⵓⴰ ⵤⵍ ⵓⵏ ⵜⵏⴾⵔⴰ ⵏⵍⵗⴹⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ⵙ ⵙⵍⴰ ⵢⵏ ⴹⵗ ⵏⴼ⵿ⵜⵗⵏ ⵢ ⵀⵜⵓ ⵜⵏ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵀⵍⵍ ⵓⴹⵏ ⵓⴰ ⵤⵜⵛⵏ ⴹⵗ ⵎⴶⵔⴰ ⵓⵏ ⵤⴶⵏⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ⵏⵙ ⵗⵢⵙⴰ «ⵍⵙ ⵢⵏ ⵜⴶⵏ ⵎⴶⵔⴰ ⵤⵓⵔⵏⵏ ⴶⵎⵢ ⴹⵗ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵜⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ⵙ ⴹⵎⴶⵏⵏ ⵎⵏ⵿ⵙⵓⵏ ⵤⵎⵤⵍ ⴾⵍⵏⵜ ⵢⴹ ⵏⵓ ⵢ ⵏⴼ⵿ⵜⵗⵏ \"ⵙⵓⵜⴹⵓ ⵎⵏ⵿ⵙⵓⵏ ⵎⵔⴹⴰ ⵎⵜⴶⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«ⵎⵛⵏ ⴶⵤⵏ⵿ⵜⵓ ⴾⵜⵏⵙⵏ ⵙⵢⵏ ⵢⵏ ⴹⵙⵔ⵰ ⵏⵙ ⵓⴰ ⵤⵔⵏ \"ⵙⴾⵜ ⵤⵏ⵿ⵤⴰ ⵜⵓⴶⵙ⵿ⵜ ⴾⵏ⵿ⴹⵀⴰ ⵙⵆⵜ ⵏⵢⵆⵜ⵰ ⴹⵓⵔ⵿ⵜⵛⴾⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ⵏⵙⴹⵓ ⵢⵏ \"ⵙⴾⵜ ⴹⵤⵏ⵿ⵤⴰ ⵎⵔⵓ ⵤⴶⵔⵏ ⵢⴶⵢⴾ ⵎⵔⵏ ⵔⵗ ⵜⵏⵔⵎⴰ⵰ ⴹⵓⵔ⵿ⵜⵛⴾⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ⵏⵙⴹⵓ ⵢⵏ \"ⵙⴾⵜ ⵤⵍⴼⴰ ⴹⵗ ⴹⵢ ⵓⵔ ⴼⵔⴶⴰ ⴾⵢⵏⵙⵗ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ⵙ ⴹⵆⵍ ⴾⵍⵢ ⴶⴰ ⵢ ⵎⵛⵙ ⵙⵍⵏ ⴾⵍ ⵓⵏ ⴹⵏ⵰ ⴶⵤ ⵍⵂⵎ ⵍⵀⵙⵏ ⵎⵛⵙ ⵏⵗⵢⵓⵏ ⵎⵔⵏ ⵏⵙ \"ⴶⵍⵓ ⵜⵔⵎⴹ ⵜⵍⵍⵗ ⵗⵔⵎ ⵜⴹⵓⴹⵓ ⴹⵜⵍⵆⵓⵏ ⴹⵏⵀⴹⵏ ⴹⵎⴹⵔⵗⵍ ⴹⵎⴶⴹⵍ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«ⵙ ⴹⵆⵍ ⴾⵍⵢ ⵏⴰ ⵢ ⵎⵛⵙ \"ⵎⵛⵢ ⴶⵗ ⵓⴰ ⴹⵜⵏⵗ ⵎⵛⵏ ⵂⵏ ⵂⵔⵓⴰ ⴹⴰ ⵂⵢ ⴹⴶ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ⵏⵙ ⵎⵛⵙ \"ⴶⵎⴹ ⵗⵔⵎ ⵜⵍⵍⵗ ⴹⵜⵔⵢⵏ ⴹⵜⵎⵓⵏ ⵏ⵿ⴼⵔⴶⵏ ⵜⵛⵂⵛⵍⵗ ⵢⵜⴹⵏ ⴹⵙⵏ ⴼⵍ ⴹ ⴹⵏⵢ ⵂⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ⵍⴾⵏ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⴰ ⴶⵎⵢⴰ ⴹⵗⵙⵏ ⴹⴹⵙⵏ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵤⵔⵎⵏ ⵎⵏ⵿ⵙⵓⵏⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ⵎⵍⵍⵢⵏ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⵜⴾⵏⵜ ⴶⵜ ⵜⴰ ⴹⵔⵙ ⵜⴹⵓⵜ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ⵓⴹⵏ ⵓⴰ ⵔⵏ ⴹⵍⴾⵎ ⵏ⵿ⵜⴰ ⵓⵔ ⴹⴶⴰ ⵜⵔⴰ ⵜⴶⵔⵜ ⵜⴰ ⴶⴰ ⵢⵀⵏⵜ ⴹⵏⵏⵜ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⴹⵀⵔⵔⵏⵜ ⴹⵎⴹⵔⵢⵏⵜ ⴹⵜⵎⴹⵔⵢⵏⵜ ⴹⵏ⵿ⵜⴰ ⵎⵏⵜ ⵓⴹⵢ ⵓⵔ ⴼⵔⴶ ⴹ ⵆⵍ ⵏⵜⵍⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ⵢ ⵓⵔ ⵏⴶⵔ ⵔⵢ ⵢⴹ ⴹⴾⵍ ⵜⴶⵜⵓⵜⵏⵜ ⴶⵓ ⵎⵜⵔⵏⵜ ⵍⴾⵎⵢ ⵓⴹⵢ ⵓⵔ ⴼⵔⴶ ⴹ ⵆⵍ ⵏⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ⴹ ⵏⵏⴰ ⵎⵙⵍⵏ ⴹ ⵔⴰ ⵢⵏ ⴹⵗⵓⵏ ⴹ ⴾⵔⵙ ⵂⵏ ⵎⵙⵏ ⵙⵔⵓ⵰ ⵓⵔⴶⵗ ⵜⵗⵎⵜ ⵜⴶⵓ ⵈⵙⵀ ⵓⴰ ⵜⴾⵔⵙⵏ ⵜⵤⵔ ⵙⵏ ⴾⴹ ⵍⴰ ⵤⵔⴼ ⵜⵙⵏ⵿ⴹⵏ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ⵙ ⵓⵔ ⴶⴰ ⵓⵏ ⵙ ⵜⵙⵏ⵿ⵜⴰ ⴾⵔⵙ ⵂⵔ ⵜⵔⵏⴰ ⵙⵏ⵿ⴹⵏⵜ ⴹⵗⵙ ⴶⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵏⵢⵏⵏ ⵜⵎⴾⴾⵢⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ⵏⵏ \"ⵓⴹⵏ ⵓⴰ ⵙⵏ⵿ⵜⴰ ⴾⵔⵙ ⵏⵂⵏ ⵔⵏⵢ ⴹ ⵜⵙⴾⵙⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ⵎⴹⵗ ⵏⵏⴰ ⵎⵙⵍⵏ ⵎⵏⴾⵍ ⵢⵏ ⵙ ⵏ⵿ⴾⵔ ⵎⴶⵔ ⴶⵔⵙ ⴹⵢⵏ⵰ ⵓⵔⴶⵗ ⵜⵗⵎⵜ ⵤⴶⵓ ⵜⵤⵔ ⵙⵎⴹⵔⵏ ⵙⵏ ⴾⴹ ⵏ⵿ⵜⴰ ⵓⴰ ⵍⵏ ⵎⵔⵓ ⴶⵎ ⵏⵍⵙ ⴼⵔⴶ ⵜⵔⵤⵢ ⵏⵎⵏⴾⵍ ⵓⴰ ⵂⴹⵏ ⵍⵏ ⵏ⵿ⵜⴰ ⵙⵏⵜⵜ ⵜⵎⵔⵓⵏ ⵏⴶⵎ ⵏⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ⵙ ⵏⵢ ⵙ ⵓⵔ ⵜⴼⵔⴶ ⵂⵔⵓⴰ ⴹⴰ ⴶⴶ ⵎⵏⴾⵍ ⵓⴰ ⵂⴹⵏ ⵙ ⵜⵤⵙⴾⵓ ⵏⵎⵤⵍ ⴶⵎⵢ ⴹⵗⵙ ⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ⴾⵓⵏⵢ ⴹⴰ ⵤⴰ ⵎⴾ ⴹⵢ ⴹⴰ ⵢ ⴹⵗⵓⵏ ⵓⵔ ⵏⵎⵤⵢ ⴹⵓⴰ ⵍⴰ ⴾⵍ ⵓⵔ ⴼⵔⴶ ⴹ ⵆⵍ ⵏⵜⵍⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ⵜⵙⵎ⵿ⵜ ⵔⵜ ⵍⵗⵏ ⵜⵎⵙ ⵎⵛⵏ ⵙ ⵜⵜⴶⵎⴹ ⵜⵎ⵿ⵀⵢⵏⵜ ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⵜⵜⵤⵜⵜⵓⵙⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ⵀⵙ ⵜⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⵓⵍⵢⵜ ⵢⵎⴹⵍ ⵓⵍⴰ ⴹⵗ ⵜⵂⵜ ⵜⵏ⵿ⴼⴰ ⵢ ⵜⵎⵆⵙ⵿ⵜ⵰ ⵜⵏⵗⵍⴰ ⵗⵙ ⴹⵏ⵿ⵤⵜⵜⵓⴶⵓ⵰ ⵓⴰ ⵙⵍⵏ ⵙⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ⵙⵏ⵿ⴹⵓ ⵏⵀⵤⵏ ⵏⵎⵏⴰ ⴹⵏⵙⵀⴾⴹⵏ ⴾⵍ ⵗⵢⵙⴰ ⵢⴹⵙⵙⵙⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ⴶⵤⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵛⵏ ⴶⵜⵏ⵿ⵜⵏ ⴶⵏⵏ ⵙ ⵗⵢⵙⴰ «ⵓⴹⵏ ⵓⴰ ⵆⵀⵍ ⵏⵙⵀⴾⴹⵏ ⴹⵔⵓ ⴹⵗ ⴹⵔⵙⵏ ⵎⵏ⵿ⵙⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ⵜⵤⵔ ⴶⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵜⵍ ⵓⴰ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ⵙ ⵍⴰ ⵢⵏ ⴹⵗⵓⵏ ⵜⵎⴹⵢ ⵏ⵿ⵜⵍⵢ ⵂⵔ ⴹⵗⵙⵏⵜ ⵜⵙⴶⵍ ⵢⴹⴰ ⵓⴾ ⵓⵔⴶⵗ ⴹ ⵢⵓ ⵜⵤⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵜⵤⵢⵜ ⵛⵏ ⵂⴹⵜⵏⵏ ⴹⵏⵜ ⵜⵤⵔ ⵤⵍ ⵙⵓⴹ ⵢ ⵜⴰ ⵜⵙⴶⵍⵜ ⵂⵔ ⵜⵜⴹⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ⵙ ⵜⵜⴹⴶⵔⵓ ⵜⵜⵙⵓⵔ ⵤⵔⵏⵜ ⴼⵍ ⵓⴰ ⴶⴰ ⴹⵗ ⵜⴹⵓⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ⵙ ⴹⵆⵍ ⵗⵢⵓⵏ ⴹⵗⵔⵓ ⵎⴹⵓⵏⵜ ⴹⵎⵂⵔⴶⵏⵜ ⵏⵙⵏ \"ⵢⵓⵜ ⵜⴶⵎ ⵜⴹⵓⵜ ⵜⴰ ⴶⵗ ⴼⵍⵙ ⴶⵔⵓ ⴹⴶⵗ ⵜⵍⵢⵏⵏ ⵜⴰ ⵜⵙⴶⵍⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ⵏⵗⵓⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴰ ⵤⴶⵏ ⵓⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⴼⵍ ⵜⵜⵀⵜ ⵏⵏⵙⵀⴾⴹ ⵢⵏ⵿ⴹⴰ ⵜⴶⵔ ⵜⴰ ⵜⵏ⵿ⵤⵜⵙⵙⴶⵓ ⵜⵤⵢⵜ ⵜⵎⵔⵓⵏ ⵏⵍⵗⴹⵍ ⴹⵜⵤⴰ ⵙ ⵗⵔ ⴶⴰ ⵙ ⵓⵔ ⴹⵔⵔⵏ ⵙ ⵜⵜⵀⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«ⵎⴹⵗ ⵏⵏⴰ ⵎⵙⵍⵏ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵜⵍⵜ ⵎⵔⵓⵜ ⵜⵎⵜⵏ ⵏⵤⵔⴼ ⵂⵔ ⴹⵗⵙ ⵀⴰ ⵢⵜ⵰ ⵓⵔⴶⵗ ⴹ ⵜⵙⵔⵗⵓ ⴼⵜⵍⴰ ⵜⴼⵔⴹ ⵂⵏⵜ ⴾⵜⵏⵜ ⵜⵙⵓⴹⵙ ⵙⵍⵗ ⴾⵜ ⵓⵔ ⵜⵜⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ⵙ ⵜⵜⴶⵔⵓ ⴹⵜⵗⵔⵓ ⵛⵎⴹⵓⵏⵜ ⴹⵜⵎⵂⵔⴶⵏⵜ ⵜⵏⵙⵏⵜ \"ⴶⵎⵜ ⵜⴹⵓⵜ ⵜⴰ ⴶⵗ ⴼⵍⵙ ⴶⵔⵓ ⴹⴶⵗ ⵜⵎⵏⵏ ⵜⴰ ⴹⵗⵢ ⵀⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ⵏⵗⵓⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵜⵜⵀⵜ ⵏⵏⵙⵀⴾⴹ ⵢⵏ⵿ⴹⴰ ⵜⵙⴼⵍⵓⵙ ⵏ⵿ⴶⵍⵙⵏ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⵍⵙ ⵢⵏ ⵍⵏ ⵛⵏ ⵀⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ⵙ ⵤⵍ ⵢⵏ ⵏⴰ ⵓⴰ ⵎⴹⵔⵢⵏ ⵢⵀⵏⵜ \"ⵀⴰ ⴾⴼⵢ ⴹⴶⵔⵏ ⴹⵗ ⵜⴾⵙⵜ⵰\" ⵤⵏⵙⵏ ⵀⵏⵙⵏ ⵜⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ⵔⵜ ⵏⴹⵏ ⴹⴼⵔ ⵓⵏ ⵏ⵿ⴾⵔ ⵀⵔⵔ ⵓⴰ ⵏ⵿ⴹⵔⵏ ⵛⴹⵓ ⵓⴰ ⵍⴰ ⴾⵍ ⴾⴰ ⴾⵍ ⵢⵏ ⴶⴶⵏ⵰ ⵍⴾⵎ ⵢ ⵜⵔⴰ ⵏⵎⵏⵜ ⴹ ⵗⵛⴹ ⵓⴰ ⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ⵙ ⵏ⵿ⵗⴰ ⵓⴰ ⵍⴰ ⴾⵍ ⵙⴹⵓ ⵍⵤ ⵍⵀⵙⵏ ⴾⵍ ⵓⴰ ⵂⴰ ⵜⵤⵔ ⴶⵤ ⵛⵏ ⵜⵎⵗⵜⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ⴶⵍⴰ ⵛⵗⵍ ⵢⵓⴹⵏ ⵢⵏ ⵏⴾⵍⵏ ⴹⴰ⵰ ⵙⴾⵢ ⵛⵓⴶⵙⵏⵜ ⵢⴹⵙⴹⵏ ⴹⵗⵙⵏⵜ ⵍⴹⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ⵓⴰ ⴹⵙⴶⴰ ⵍⵤ ⴹⵗ ⴶⵤ ⵙⴹⵔⵏ ⵜⵜⵢ ⵏⵛⵜⵛⴰ ⵓⵏ ⵜⵜⵏ ⵍⴹⵢⵏ ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵙ⵿ⵜⵏⴾⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ⵎⵔⵏ ⵙⵎⴹⵔⵏ ⴹⵗ ⵎⵏⵜ ⵏⴰ \"ⵓⴾ ⵓⵔⴶⵗ ⵎⵛⵗⵍⵏ ⵏⵀⵏⵏ ⴶⵜⵏ ⵎⵛⵏ ⴾⵜⵏⵙⵏ ⵍⵏ ⵜⵛⵏ ⵂⵔ ⵜⴹⴶⵍⵤⵏ ⵏ⵿ⵜⴰ ⵏⴾ ⵏⵆⵢ ⵍⵤ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ⴹ ⵏ⵿ⴾⵔⵗ ⵆⵍⴰ ⵀⵏⵏ ⵏⵗⵙ 'ⵀⴰ ⵎⵤⵔⵢⵗ ⵎⵛⵏⴰ ⴾⵢ ⴹⵗ ⵀⴹⵔⵆⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ⵀⵙ ⵂⵔⴰ ⴹⵜⵓⵏⵓ ⵀⵔⵔⵏⴾ ⴶⵢ ⵢⵏ ⴹⵗ ⵎⵛⵗⵍⵏⴾ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ⵜⵤⵔ ⵏ⵿ⴾⵔ ⵆⵍ ⵀⵏⵜ⵰ ⵤⵢⵏ ⵂⵏ ⴹⵗ ⴶⴶ ⵙ ⵜⴶⴰ ⵀⵏⵜ ⵜⴶⵤⵜⵓ ⵜⵂⵏⵏ⵿ⵜⵏⵜ ⵤⵍ ⵙⵔⵙ ⵤⵍⵎⵜⵓ ⴹⵙⵜⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ⵜⵤⵔ ⵏⴰ ⵀⵔⵔ ⵢⵀⵏⵜ \"ⵀⴰ ⵎⵤⵔⵢⵗ ⵎⵛⵏⴰ ⴾⵢ ⴹⵗ ⵀⵔⵆⵢ ⵀⵙ ⵂⵔⴰ ⴹⵜⵓⵏⵓ ⵀⵔⵔⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ⵎⵛⵏ ⵏⴰ ⵀⵏⵜ ⵢⴾⵍⵏⵜ \"ⵜⵔⵎⴹ ⵓⵢⵜⴹⵓ ⵜⴾⵜⴾⵜ ⵜⴰ ⵜⵂⵙⵢⵜ ⵜⵤⵤⵍⴶⵎⵙ⵿ⵜⵜ ⵜⴶⵎ ⵜⵙⵏ⵿ⴹⵔ⵿ⵜ ⴹⵗ ⴹⴹⵏⵜ ⵜⵙⵙⵍⵎ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ⵜⵀⵤⵎⴹⵓ ⵂⵔⵢ ⵓⴰ ⴹⵔⵏ ⵜⴶⵤⵎⵎ⵿ⵜⵓ ⴹ ⵏⵜⵛⵓ ⵏⴶⵓ ⵙⴾⵙⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ⴼⵍⵙ ⵀⵔⵔⵏ ⵓⴰ ⵛⵍⵜ ⵏⵙ ⵜⵀⴰ ⵎⵔⵏ ⵎⵔⴹⴰ ⴹⵔⴹⵓ⵰ ⴾⵍⴰ ⵈⵔⴾ ⵎⵔⵏ ⵎⵔⴹⴰ ⴶⵔⵓⴹⵓ⵰\" ⵎⵔⵏ ⵙⵏ⵿ⵜⵏ ⴹⵗ ⵙⴾⵙⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ⵙ ⵜⴶⵓ ⵓⵏ ⵀⵔⵔⵏⵜ ⵓⵏ ⵗⴼⴹⵢ ⵂⴰ ⵛⵓⴶⵙ⵰ ⵙ ⴹⵆⵍ ⵂⵤⴹⵓ ⵗⵢⵓⵏ ⵙⵍⴰ ⵢ ⵙⵓⵜ ⴹⵓⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ⵗⵔⴹⵓ ⵢⵏ ⴹⵗ ⴾⵍⵏⵙⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⴹⵓⴰ ⵜⴶⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ⵏⵙ ⴾⵍⵢ \"ⵎⴹⵔⵢⵏⴾ ⴹⵆⵍⵏ ⴶⵤⵎ ⵀⵏⴾ ⵂⵔⵢ ⵓⴰ ⴹⵔⵏ ⴼⵍⵙ ⵜⵓⵗⵍⵢ ⵜⴹⴶⴰ ⵀⵔⵔⵏⵜ ⵓⵔ ⵍⴰ ⵎⵍⴹ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ⴶⵤⵜⵓ ⵍⵂⵎ ⴶⵢ ⵙⴶⵤ ⵏⵂⵏ⵰ ⵆⵀⴹⵓ ⵀⵏⵜ ⴹ ⵜⵜⵏ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ⴶⵙ ⵏⴰ ⵢⵀⵏⵜ \"ⵓⵔⴶⵗ ⵍⵏ ⵍⵏ ⵛⵗⵍⵗⴾ ⵓⵔ ⴾⵍⴰ ⵎⵤⵔⵢⵗ ⵜⵏⵏⴾ ⵂⵔⴾⴹ ⵓⵏ ⵓⵔ ⴾⵍⴰ ⴹⵜⴾⴼⵗ ⵓⵍⴰ ⵗⵙ ⵗⵢⴹ ⴶⵤⵎⴰ ⴶⴰ ⴼⵍⵙ ⵙⴾⵙⵙ ⵏⴾ ⴹⵎⴹⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ⵔⵔⴾ ⵎⵔⵏ ⵓⴰ ⵗⵛⴹⵏ ⵂⵔⵢⵏⴾ ⴹⵗ ⵜⴾⵔⵓⵜⵏ ⵏ⵿ⵜⴰ ⵙⴹⵓ ⵗⵙ ⵜⴶⵤⵎⵗⵙ ⵂⵔⵢ ⵓⴰ ⴹⵔⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ⵏⵙ ⵀⵏⵜ \"ⵀⵔⵔⵏ ⴾⵢ ⴼⵓⴹⴰ ⵜⵍⵗ ⵗⵔⵢ ⵓⴰ ⵍⵗ ⴾⵜⵏⵜ ⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ⵎⵛⵏ ⵎⴾⵏ ⴹ ⵏⴹⵓⵜ ⵏⴶⵓ ⵙⴾⵙⵙ ⴼⵍⵙ ⵎⴹⵔⵢⵏⴾ ⵛⵍⵜ ⵏⵙ ⵜⵀⴰ ⵎⵔⵏ ⵎⵔⴹⴰ ⴹⵔⴹⵓ⵰ ⴾⵍⴰ ⵈⵔⴾ ⵎⵔⵏ ⵎⵔⴹⴰ ⴶⵔⵓⴹⵓ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⴾⵍⴰ ⵜⵍⴰ ⵍⵙ ⵢⵏ ⵏⵎⴶⵔⴶⵙ ⵍⵏ ⵎⵛⵗⵍ ⵙⵏⵜⴼ ⴹⵔⵤⵗⵏⵜ ⵎⵔⵏ ⵜⵓⵏⵙ ⵗⵛⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ⵜⵤⵔ ⵙⵙⵗⵔⵢⴹⵓ ⵏⵙ \"ⵎⴰ ⵎⵙ ⵓⴰ ⴼⵍⴾ ⵙⵍⵗ⵰ ⵎⵍⵢ ⵓⴰ ⵜⴶⵗ ⵢⵔⵤⵗⵏ ⵏⴾ ⵀⵙ ⵔⵗ ⵛⵗⵍⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ⵏⴰ ⵎⵛⵗⵍ ⵓⴰ ⴶⵔⵙ ⴹⵎⵏⵜ \"ⵓⴾ ⵎⵔⴹⴰ ⵎⴰ ⵤⴶⴰ ⵙ ⴹⴾⵙ ⵎⵤⵔⵏ ⴹⵗ ⵛⵗⵍ⵰ ⵏⴾ ⵓⵔ ⴼⵔⴶⵗ ⴶⵢⴾ ⵎⵏ⵿ⵙⵢ ⴹⵗ ⵙⴾⵔⴾⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ⵙⵏⵗ ⵓⴰ ⵤⴶⴰ ⵙ ⴾⴹ ⵜⵓⴾⵙⴰ ⴹⵗ ⵛⵗⵍⵏ ⴹⴰ ⴹⵆⵀⵍⵏ ⵢⵜⴹⵏ ⴹⵗ ⵏⵏⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ⵜⵤⵔ ⵙⵙⵗⵔⴹⵓ ⵢⵜⴹⵏ ⵓⵏ ⵔⵓⵙ ⵍⵙ ⵓⵙ ⵛⵗⵍ ⵙⵢⵏ ⵢⵏ⵰ ⵏⴰ ⵢ ⵓⴰ ⵤⵔⵏ \"ⵎⴰ ⴾⵢ ⵔⵓⵙ ⵎⵤⵔⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ⵏⵙ \"ⵜⵎⴹⵢ ⵏ⵿ⵜⵏⵓ ⵏⵓⴹⵢ ⵓⵏ ⵤⵢⵜ⵰\" ⵏⵙ ⵎⵛⵗⵍ \"ⵗⵎ ⵜⴹⴾⵍⴰ ⵛⵔⵓⵜⵏⴾ ⵜⵏ ⵎⵔⵓⵙ ⵜⴾⵜⵀⵗ ⴼⵍⵙ ⵜⵔⵎⴹ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⵏⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵢⵢⵏ \"ⴾⵢ ⵤⴰ ⵎⴰ ⵜⵜⵓⵔⵓⵙⵗ⵰\" ⵏⵙ \"ⵜⵎⴹⵢ ⵏⵀⵂⵓ ⵏⵍⴾⵎⴰ⵰\" ⵏⵙ \"ⴹⴾⵍ ⵛⵔⵓⵜⵏⴾ ⵜⵏ ⵎⵔⵓⵙ ⵜⴾⵜⵀⵗ ⴼⵍⵙ ⵜⵎⵜ ⵜⵎⵔⵓⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ⵜⵎⵔⴾⵙ⵿ⵜ ⵜⵏ ⵙⵍⵜ ⵍⵙ ⵓⴰ ⵛⵛⵗⵍⵏ ⵔⴾ ⵎⵛⵗⵍ ⵓⵏ ⵜⵤⵔ ⴹ ⵜⵎⵍ ⴼⵍ ⵜⵍⵏⵜ ⵜⵢⵜⵢ⵰ ⵜⴹⵜ ⵎⵙ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⴶⵔⵏ ⵓⵏ ⵜⴾⵙⴹⵏⵏ ⵜⵍⴰ ⵏ⵿ⵜⵢⵜⵢ ⴹⵗ ⵜⵗⵓⵛⵓⵏ ⵛⵏ ⵍⵏⵏ ⴶⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⴶⵓⵜ ⵎⴹⵓⵏ ⵙⵔⵤⵗⵏ ⵏⵀⵏⵏ ⵓⵏ ⵏⴹⵏⵜ ⵜⴰ⵰ ⴹⵢ ⵙ ⴾⵓⵏⴶⵎⴹⵏ ⴹ ⵜⵜⵓⵆⵀⵍⵎ ⴹⵗ ⴹⴶ ⵏ⵿ⵜⵎⵈⵙⵔ⵿ⵜ ⵗⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ⵓⴹⵏ ⵓⴰ ⵜⵂⴰ ⵜⴼⵍⵙ⵿ⵜ ⴹⵗ ⵔⵜ ⵏ⵿ⴹⵔⵏ ⵓⴰ ⵤⵓⵔⵏ ⴹⴰ ⵜⵂⵢ ⴹⵗⵙ⵰ ⵓⴰ ⵓⵔ ⵜⵂⴰ ⵜⴼⵍⵙ⵿ⵜ ⴹⵗ ⵏ⵿ⴹⵔⵏ ⵓⴰ ⵤⵓⵔⵏ ⴹⴰ ⵓⵔ ⴹⵗⵙ ⵜⵜⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ⴹⵗ ⴹⵢ ⴹⴰ ⴾⵓⵏⵓⵔ⵿ⵜⵂⴰ ⵜⴼⵍⵙ⵿ⵜ ⴹⵗ ⵔⵤⵗ ⵏⵀⵏⵏ ⵓⵏ ⴹⵏⵜ ⵜⴰ ⵎⴰ ⴾⵓⵏ⵿ⵤⵤⵤⴶⵤⵏ ⵔⵤⵗ ⵓⵏ ⵜⴹⵜ ⵓⴰ ⵂⵏ ⵍⵈⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ⵎⵔⵏ ⴾⴹ ⵓⵔ ⴾⵓⵏ⵿ⵜⵂⴰ ⵜⴼⵍⵙ⵿ⵜ ⴹⵗ ⵔⵜ ⵓⴰ ⵓⵔ ⵜⵍⵎ ⵎⴰ ⴾⵓⵏ⵿ⵤⴾⴼⵏ ⵔⵜ ⵓⴰ ⵜⵍⵎ ⴹⵗ ⵍⵈⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ⵓⵔ ⵜⵍⴰ ⵎⵛⵗⵍ ⴼⵔⴶⵏ ⴹ ⵛⵗⵍ ⵢⵛⵏ ⵎⵤⵔⵏ⵰ ⵓⴰ ⵗⵙ ⴾⵢⴹ ⵢⵏ ⵔⵓ ⵓⴰ ⵂⴹⵏ⵰ ⵎⴹⵗ ⵀⵔⴹⴶ ⵢⵢⵏ ⵍⴾⵓ ⵓⴰ ⵂⴹⵏ⵰ ⵓⵔ ⵜⴼⵔⴶⵎ ⴹ ⵜⵗⵀⴹⵎ ⵎⵛⵏⴰ ⵜⴶⵍⵎ ⴹⵗ ⵜⵤⵍⵎ ⴹⴼⵔ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ⵙⵙⵎⵏ ⴼⵔⵙⵢⵜⵏ ⵢⵓⴰ ⵏⴰ ⵗⵢⵙⴰ ⴹⵏ ⴾⵍ ⵜⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ ⴼⵍⵙ ⵎⵔⵏ ⵏⵤⵔⴼ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵜⵙⴾⵏⵎ ⴹⵜ ⵢⵜⴹⵏ ⵙ ⵍⵗⴹⵍⵏ ⵜⵎⵙⵎ ⵎⵛⵏⴰ ⵎⵔⵏ ⵙⵏ ⵓⴰ ⵂⵏ ⵓⵍⵏⵓⵏ⵰ ⴼⵍⵙ ⵔⵜ ⵓⴰ ⵤⵤⵓⵔⵏ ⵢⵜⴹⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵜⴶⵍⴼⵜ ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«ⵜⵓⵔⵜ ⴹⵍⴾⵜⵀⵏ ⵓⵏ ⵏⵀⵜⵏ ⵏ⵿ⵜⵏⵢ ⵗⵙ ⵜⵓⵙⵙⵗⵔⵏⵏ ⵂⵔ ⵤⵍ ⵓⴰ ⴹⵙⴰ ⵢⵈⵢⴰ ⵓⴰ ⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰ ⴹⵢ ⵎⵔⵏ ⴹ ⴶⵤⵏ ⵙⵍⵏ ⵓⵏ ⵍⵏ⵿ⵌⵍ ⵛⵏ ⵜⵓⴶⴰ ⵎⵙⵏⵏ ⵙⵍⵏ ⵏⵙⴰ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵎⵔⵏ ⴹ ⴶⵎⵢ ⵓⴹⵏ ⴾⵍ ⴶⵤⵏⵜ ⵙⵙⵂⵜ ⴹⵜⵍⵀⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⴶⵔ ⵜⵔⵗⵙⵢ ⵜⴰ ⴶⴰ ⴹ ⵀⴰ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵜⴰ ⴶⴰ ⴹ ⵀⴰ ⵓⵍⴰ ⵗⵙ ⵙⴾⵍ ⵢⵏ⵿ⴹⴰ ⵏⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ⴹⵢ ⴼⵍⵙ ⵍⵙ ⴾⵍ ⵓⴰ ⵤⵎⵤⵢⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⵤⵍⴼ ⵢⵜ ⵓⴹⵢ ⴶⴰ ⵤⵏⴰ⵰ ⵍⵙ ⴹⵗ ⵓⴰ ⵤⵍⴼⵏ ⵜⵏ⵿ⵜⵜ ⵜⵎⵤⵢⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⴰ ⵤⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵗ «ⴾⵍⴰ ⴹ ⵜⵍⴰ ⵍⵙ ⵢⵏ ⵏⵎⴶⵔⴶⵙ ⵏⵎⵢⵓⵏ ⵙ ⴼⵓ ⵤⵍⴶ ⵙⵍⵙⴰ ⵓⵏ ⵂⵙⵢⵏⵏ ⵤⵓⵜⵏⵏ ⴼⵓ ⴹⵗ ⵏⴼⵍⵢ ⵙⴾⵙⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ⵙ ⵜⴶⵓ ⵓⵏ ⴹⵜ ⵎⵢ ⵏⵂⵏⵜ ⵙⵔⴹ ⵍⵙ ⵢⵏ ⵏ⵿ⵜⵍⵆⵢ ⴶⵏ ⵍⵤⵔⵙ ⵙ ⵍⵙⵏⵜ ⵛⵆⵙ ⵍⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ⵙⴹⵔⵏ ⵜⵜⵢ ⵏ⵿ⴾⵔⵎⵔⵎⵏ ⵓⵏ ⴹⵔⵜⴾⵏⵏ ⴹⵗ ⵎⵏ⵿ⵙⵓⵏ ⵏⵎⴶⵔⴶⵙⵏ⵰ ⵓⵍⴰ ⴹⵏ ⵜⵙⵏ⵿ⵜⴹⵓ ⵜⵍⵗⵏ ⵛⵆⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ⵂⵔ ⵤⵍ ⵓⴹ ⵀⴰ ⵜⵍⵆⵢ ⵜⵏ ⵜⵤⵔ ⵓⵢⵏ⵿ⵜⵓ ⵏ⵿ⴶⵍⵙⵏ ⵙⵏⵀⵢ ⵀⵔⵂⵎ ⴹⵗ ⵍⵌⵏⵜ⵰ ⵎⴶⵔⴶⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵀⵜⵓ ⵜⵓⵏⵀⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ⵂⴰ ⵌⵂⵏⵎⴰ ⵜⵗⵤⵀ ⴹⵗⵙ ⵙ ⴹⴾⵍ ⵙⵓⴹⵏⵜ ⴶⴰ ⵀⵔⵂⵎ ⴹⵗ ⴶⴶ ⵍⴰ ⵗⵔⵙ ⵍⵤⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ⴹ ⵗⵔⵓ ⵀⵔⵂⵎ ⴶⵏⵙ \"ⵢⴰ ⵀⴰ ⵀⵔⵂⵎ ⵂⵏⵜⵜⵢ ⵜⵤⵎⵤⵍⴹⵓ ⵙⵔⵢ ⵍⵤⵔⵙ ⵢⴹ ⵙⵍⵎⵗ ⴾⴹⵗ ⵎⵢ ⵏⴹⴹⵏⵜ ⴹⵗ ⵎⵏ ⵙⵙⵎⴹⵢ ⵙⵔⵙ ⵍⵙⵏ ⴼⵍⵙ ⵍⵗⵤⵀ ⵜⴶⴰ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵜⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ⵎⵛⵏ ⵏⵙ ⵀⵔⵂⵎ \"ⵀⵔⵔⵏ ⴾⵜⴹⵓ ⵙ ⴾⵢ ⵜⴶⵔⵓⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵔⵗ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜⵏⴾ ⵙ ⴶⴰ ⵓⵏ ⵍⵤⵔⵙ ⵏ⵿ⵜⴰ ⵓⵔ ⵏⵢ ⵔ ⵍⵗⵤⵀ⵰ ⵎⵔⵏ ⵎⵔⴹⴰ ⵏ⵿ⵜⴰ ⵙ ⵜⵓⴾⵏⵏ ⵎⵏ ⴾⵢ ⵜⵜⵗⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ⵓⴰ ⴹⴼⵔ ⴹⵢ ⵙ ⵍⴰ ⵗⵗⵢ ⵓⵔ ⵏⵍⴰ ⴹⵔ ⴶⵔⵏⴰ ⴹⵔⵓⵏ ⴼⵍ ⴹ ⵓⵔ ⵔⵓ ⵓⵍⵢⵏ ⴹⵗⵏⴰ ⴾⵓⵏⵏⴾⵓ ⴼⵔⴶ ⴹⵢ ⵓⵍⴰ ⴹⵗ ⴼⵔⴶ ⵓⵍⵢⵏ ⴹⵗⵓⵏ ⴹⵏⴹⴾⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ⵏⴰ ⵎⴶⵔⴶⵙ \"ⴹⵗ ⴹⵢ ⵀⴰ ⴶⵎⵢⴰ ⴹⵗⴾ ⴹ ⵜⵤⵎⵤⵍⴰ ⵍⵤⵔⵙ ⵙⵗⵢⵓⵏ ⵏⵀⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ⴼⵍⵙ ⵍⵗ ⵙⵎⵙ ⵎⴹⵔⵢⵏ ⵢⴹⵙⵏⵔⵗⵎ ⴼⵍ ⴹⵓⵔⴶⵤⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴶ ⵏⵍⵗⵤⵀ ⵓⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ⵎⵛⵏ ⵏⵙ ⵀⵔⵂⵎ \"ⵎⴹⵔⵢⵏⴾ ⵜⴼⵏ ⵍⴾⵜⵀ ⵓⵏ ⵜⵓⵔⵜ ⴹⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵍⴾⵎⵏⵜⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ⵏⴰ ⵢⵀⵔⵂⵎ \"ⴾⵍⴰ ⴾⵍⴰ ⵀⵏⵏ ⵀⵔⵂⵎ ⴹⵢ ⵓⵔ ⴶⴹⴰ ⵎⵛⵏ ⵙ ⵜⵏⵏⵆⵍ ⵓⴹⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵏⵎⵜⵏ ⴹ ⵜⵀⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ⵎⵛⵏ ⵏⵙ ⵏⵀⵢ ⵀⵔⵂⵎ \"ⵙ ⵓⵔ ⵙⵙⵎⵏ ⵢⵏⵀⵢ ⵎⵙⴰ ⴹⵏⵀⵜⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵓⵔ ⵤⵜⵀⵏ ⴾⴹⵗ ⴶⵙⵏ ⵓⴹⵏ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵏⵎⵜⵏ ⵙⵍⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ⵤⵍ ⵢⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵓⵔ ⵜⵍⴰ ⵜⵓⵔⵎⵍⵏ ⵔⵜⵏ ⵙ ⵤⴰ ⵙⵙⴶⵏⵏ ⵢⵜⴹⵏ ⵀⴾⴹⵏ ⵎⵛⵏ ⴾⵜ ⵍⵗⵤⵀ ⵍⵢ ⵢⵓⴹⵏ ⵓⴰ ⴹⵙⵏ⵿ⴹⴶⵏ ⵙⵀⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ⴹⵙⴼⵓ ⴹ ⵜⵓⵆⵏ ⵤⵤⴹ ⵤⵓⵔⵏ ⵏ⵿ⵜⵂⵏ⵿ⵜ ⴹⵗ ⵔⵏⵜ ⵜⵓⴶⵔⵏ ⴹⵗ ⴶⵔⵓ ⵜⵛⵜ ⵏⵙⵀⵀ ⵏⵀⴾⴹ ⵢ ⵓⵍⴰ ⵢⵏ⵿ⴹⴰ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵎⴹⵔⵔⵏⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ⴶⵜ ⵏⵢⵜ ⴹⵎⵏⵓⵏ⵰ ⵙ ⴾⵢⴹⵍⵎ ⵎⴹⵔⵢⵏⴾ ⵜⵔⵗⵎⵗⵙ⵰ ⴾⴹ ⵎⴶⵔⵤ ⵜⵙⵔⴼⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ⴾⴹ ⵎⵙ ⵙ ⴶⴾ ⵙⵢⵜ ⵜⴹⵍⵎⵏ ⴹⵗ ⵤⵍ ⴶⴾⴹⵓ ⵙⴰ ⵙⵜⵏ ⴶⵎⵢ ⵜⵙⵔⴼ⵿ⵜ ⴹⵗ ⵤⵍ ⵓⵏ ⴹⴰ ⴹⴰ ⵙⵔⴼⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ⵏⵏ ⵏⵎⵤⵍ ⵢⵎⵍⵢ ⵗⵢⵙⴰ «ⵛⵜⵓ ⵤⴶⵤⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ⵏⵙⵏ ⵎⵍⵢ ⵗⵢⵙⴰ «ⵙ ⵜⵍⵎ ⵤⴶⵤⵏ ⴶⴹⵏ ⴹⵓⵍⴰ ⵎⵢ ⵏ⵿ⵜⵤⵗⵢ ⵏⵛⵏⵏ ⴹ ⵜⴼⵔⴶⵎ ⴹ ⵜⵏⵎ ⵢⵛⴾ ⵓⴰ \"ⵍⵀⵢⴹⵓ ⵎⵏⴾ ⵜⵗⵜⴰ ⴹⵗ ⴶⵔⵓ ⵏ\" ⴶⵓ ⵓⴰ ⵜⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴹⵤⴹⵓ ⴾⵍⵏⵜ ⴹⵏⵏ ⵎⴹⵗ ⴶⵢⴾⵏ ⵏⵙ \"ⵢ ⵜⵔⵎⴹ ⵜⵎⵏ⵿ⵙⵓⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ⵓⵔⴶⵗ ⵜⵏⴰ ⴹⵙⵤⵜⴶⵎ \"ⵙⵑⵢ ⵜⵛⵗ ⵜⵤⵔ ⵜⵓⵢⵗⵜⴹ ⵜⵛⵗⵍⴰ ⵂⵔ ⵜⵛⴰ ⵛⵓⵗ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵜⵜⵛⴰ ⵜⵛⵓⴰ ⴾⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ⵓⴾ ⵍⵙⵏ ⴹ ⴶⴹⵢ ⵢⴾⵍⵏⵜ ⴼⵍⵙ ⴶⴰ ⵓⵙ ⵜⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ⴾⵓⵏⵢ ⴹⴰ ⵤⴰ ⵙ ⵜⴶⵎ ⵔⵜ ⴾⵍ ⵓⵙ ⵜⵜⵓⵎⵔⵎ ⵜⵏⵎ \"ⵏⴾⵏⵢ ⵓⵔ ⵏⵎⵙ ⵔ ⴾⵍⵏ ⵓⵔ ⵏⴶⴰ ⵔ ⵓⵙ ⴹⵏⵗⵓⵔ ⴶⵏⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ⵗⵔ ⴾⵢ ⵏ⵿ⵗⵢⵙⴰ ⵢⵔⵙⵍⵎ ⵍⵎ ⴶⵔ ⴾⵍ ⵓⵏ ⵙⵎⵔⵢⴰ ⴹ ⵓⵏ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ⵙ ⴹⴶⵤ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ ⵙⵍⴾⴹⵏⵙⴹⵓ ⵎⵔⵓ ⵎⴹⵏ ⴶⵔⵓ ⴾⵜⵔⵓ ⵀⴹⴹⵏⵙⵏ ⴹⵗ ⴶⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ⴹⴾⵍⵏ ⵎⵙⵍⵏⵙⵏ ⵏⵏⵙ «ⵢⴰ ⵗⵢⵙⴰ ⵛⵈⵏⵏⴰ ⵂⵏⵜⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ⵙⵓⴹ ⴹⵗⵙⵏ ⵏⵙⵏ «ⴶⵍⵜ ⵙⴾⵏⵜ ⵎⵏⵓⵏ ⵢ ⵍⵎⵎⵏ⵰» ⴶⵍⵏ ⴾⵏ ⵍⵎⵎⵏ ⵢⴹⵙⵏⵎⵍⵏ ⵙ ⵤⵢⵏ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ⵙ ⴹⵏⴶⵔⴰ ⵢⵏ ⴹⵗⵙⵏ ⵜⵎⵤⵢⵜ ⵜⴰ ⴶⴰ ⴹⵏ ⵆⵍ ⵗⵢⵙⴰ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵎⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ⵙ ⵜⵏⵙⴰ ⵙⵌⴹ ⴹⵜⵙ ⴹⵙⵜⴶⴹⵢ⵰ ⵍⵙⵏ ⵏ ⴾⵍ ⵏ⵿ⵙⵎⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ⵏⴰ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵎⵔⵓⵙⵏ ⵙ ⵤⵢⵏ ⵤⴹⴶⵏ ⵎⴰ ⴶⵏ ⵜⵤⴰ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ⴹⵙ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴹⵆⵍⵏ ⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⵔ ⵏⴼ⵿ⵜⵗ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢⵍⵙ ⵓⵏ «ⵀⴹⴹ ⴶⵍⵓ ⵤⴶⵤⵏⴾ ⴾⵢⵗⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ⵗⵢⵙⴰ ⵙ ⵜⵙⵙ⵿ⵜⵏⵏ ⴼⵔⵙⵢⵜⵏ ⴹⵍⵓⵆ ⵓⴰ ⴹⵤⵜⵙⵓ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵏⵙⵏ «ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵔ ⴹⵜⵜⴶⵓ ⵙⴰ ⵍⵏ ⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ⵓⵔ ⵎⴹ ⵤⵜⵓⵏⵓ \"ⵏ⵿ⵜⴰ ⴹ\" ⵓⵍⴰ \"ⵏ⵿ⵜⴰ ⴹⵏ\"⵰ ⵙⵏⵜ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵍⴰ ⴶⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵍⴾⵎⵏ ⴹⵏ ⴹⵗ ⵤⴰ ⵜⵙⴹⵔⵏⵎ ⵏⵢ ⵏ⵿ⵜⵓⵗⵍⵢⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴾⴹⵗ ⵏⵢ ⵏⵤⵍ ⵢⵏ⵿ⴹⴰ ⵎⵛⵏ ⵓⵔ ⴹⵤⵜⵏⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ⵎⵔⵏ ⴹⵓⵏⵜⵓⵏⵓ \"ⵏ⵿ⵜⴰ ⴹⵏ\" ⵎⴹⵗ \"ⵏ⵿ⵜⴰ ⴹ\"⵰ ⴹ ⵓⵔ ⵜⴶⵍⵎ ⵓⵍⴰ ⵜⵍⴾⵎⵎ ⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ⵀⵍⵤⵍⵤ ⵜⴶⵓ ⵙⵎ ⴹⵗ ⵌⵏⵓⵏ ⵙⵎⵍⵓⵍⵓ ⵜⵎⴰ ⵏⵎⴹⵍ ⵜⴰ ⵂⵔ ⵜⴰ ⴹⵔ ⵤⵍⵓ ⵙⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ⵎⵛⵏ ⴹⵜ ⴹⵢ ⵍⵤⵎⵢ ⵏⴾ ⴶ ⴶⴹⵎ ⵏⵢ ⵏⵍⵗⵤⵀ ⴶⵏ ⵏ⵿ⴾⵔⵏⵢ ⴹⵗ ⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ⵓⴰ ⴶⵏ ⴹⵗ ⵤⵎⵏ ⵏⵏⵀⵢ ⵏⵈ ⵤⴶⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵗ ⴹⵤⵙⴰ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ⵤⵎⵏ ⵓⵏ ⴹⵏ ⵢⵜⴹⵏ ⵜⵜⵏ ⵙⵙⵏ ⵤⵍⴼⵏ ⵤⵤⵍⴼⵏ ⵂⵔ ⵤⵍ ⵓⴰ ⴹⴶⵤ ⵏⵈ ⵗⵍⵍ ⵏⵎⵏ ⵜⵤⵔ ⵙⴹⵓ ⵍⵓⵀⵍ ⵂⵍⴾⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ⵤⵏ ⴹⵓⵏ ⴹⴰ ⴹⵗ ⴶⵏ ⴹⵗ ⵤⵎⵏ ⵏⵍⵜ⵰ ⵢⵜⴹⵏ ⵜⵜⵏ ⵙⵙⵏ ⵤⵏ⵿ⵤⵏ ⵙⵜⴶⵏ ⵏⵀⵍⵏ ⴶⵢⴾⵏ ⴾⵔⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ⵂⵔ ⵤⵍ ⵓⴹ ⴶⵎⴹ ⵍⵜ ⵗⵔⵎ ⵏ⵿ⵙⴹⵎ ⵜⵤⵔ ⵙⴼⵢⴹⵓ ⵎⵛⵏⴰ ⴼⵍ ⵗⵔⵎⵏ ⴹⵗⵙⵏ⵿ⵜⵂⵔ⵿ⵜ ⵀⵍⴶⵍⴶⵏ ⵂⵍⴾ ⵢⵜⴹⵏⵜ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ⵤⵏ ⴹⴹⵢ ⴹⴰ ⵤⴶⵏ ⵤⵍ ⵓⴰ ⴹⵤⵜⵓⵙⵏⴼⵍⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ⵤⵍ ⵓⴹⵢ ⵓⴹⵏ ⵓⴰ ⵆⵎⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⴼⵍⴰ ⵏⵂⵏⵜ ⵎⵔⵏ ⵂⵏ ⵍⵍⵏⵜ ⵂⵏⵜ ⴹⵓⵔⵤⵀⵜ ⵢⵜⵏⵏⴹⴾⵍ⵰ ⵓⴰ ⵂⵏ ⵜⵓⴶⵙ⵿ⵜⵏⵜ ⴹⵗ ⴹ ⵓⵔ ⵆⵍ ⵗⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ⴾⵜⵓⵜⴹⵓ ⵓⴰ ⴶⵔⵓⵏ ⵜⵗⵔ ⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ⴹ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴶⵎⵢ ⵔ ⴶⵤ ⵏⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴹ ⴼⵜⵓ ⴹⵗ ⵍⵈⵔⵜ⵰ ⵎⵛⵏ ⵓⴰ ⵙⴼⵜⵏ ⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴹ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ⵏⵗⵓⵏ ⵂⴹ ⵓⴹⵢ ⴹ ⵏ⵿ⵙⵏ ⵛⵏ ⵢⵜⴹⵏ ⴹⵗ ⵜⵙⵜ ⵢⴹⴰ ⵎⴹⴾⵍ ⵢⵏ ⵜⵓⵢⴹⵓ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ⴹ ⵜⴹⵏⵜ ⵙⵏⵜⵜ ⵜⴹⴹⵏ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⵜⵎⴹⴾⵍ ⵢⵜ ⵜⵜⵓⵢⴹⵓ ⵜⴰ ⵂⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ⴹ ⵂⵏ ⵛⵏ ⵎⴹⵏ ⵜⵓⴶⵙ⵿ⵜ ⵢⴹⴰ ⵎⴹⴾⵍ ⵢⵏ ⵜⵓⵢⴹⵓ ⵓⴰ ⵂⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ⵙⵙ⵿ⵜⵏⵏ ⵏⵜⵍⵀ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵎⵍⵢ ⵓⴹⵢ ⵔⵜ ⵎⵏⴹ ⵤⴶⵓ⵰» ⵏⵙⵏ «ⴹⴶ ⵜⴶⵤ ⵜⵎⵈⵙⵢⵜ ⴹⵗⵙ ⴹⵓⵏ ⵌⴹⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ⴶⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⵍⵎⵜⵍ ⵢⵏ ⴹⵗ ⵔⴰ ⵜⵏⵙⵙⵏ ⵙ ⵂⵔ ⴹ ⵜⵏ⵿ⵙⵢⵏ ⵎⵛⵏⴰ ⴼⵓ ⴹⵗⵙ ⵓⵔ ⴾⵙⵏ ⵜⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ⵏⵙⵏ «ⵗⵔⵎ ⵢⵏ ⵂⴰ ⵎⵛⵔⵗ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⵓⵔ ⵙⵗⵎⵔ ⴹⵗ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ⵎⵔⵏ ⵗⵔⵎ ⵏ ⵜⵂⵢ ⵜⵏ⵿ⵜⵜ ⵙ ⵓⵔ ⴹⵔ ⵍⵙⵏⵜ ⴹⵜⵜⵙⵜ ⵎⵛⵔⵗ ⵏ ⵜⴶⵏⵙ \"ⴾⴼⵢ ⵍⵈⵆⵏ ⴹⵗ ⵎⴾⵔⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ⵙ ⴶⴰ ⵜⵎⵔ⵿ⵜ ⵜⴶⵢⵙ ⵏⴰ ⴶⵔⵙ ⴹⵎⵏⵜ \"ⴾⴹ ⵓⵔ ⴾⵙⴹⵗ ⵎⵛⵏⴰ ⵓⵍⴰ ⵙⵗⵎⵔⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ⴹⴰ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⴹⴶⵤⵢ⵰ ⵜⵜⴾⴼⴰ ⵍⵈⵆⵏⵜ ⴼⵍ ⴹⵗⵙ ⴶⵔⵓⵗ ⵎⵏⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ⵜⵤⵔ ⵏⴰ ⵎⵍⵢ ⵗⵢⵙⴰ «ⵜⵙⵍⵎ ⵢⵓⴰ ⵏⴰ ⵔⴾ ⵎⵛⵔⵗ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ⵜⵔⴹⵎ ⵙ ⵎⵛⵏⴰ ⵓⵔ ⵤⴾⴼⵓ ⵢⵜⴹⵏ ⵓⵏ ⵙⵏⴼⵔⵏ ⵍⵈⵆⵏⵙⵏ ⵜⵜⵏ⵿ⵙⵢⵏⵏ ⵂⵍⵏ ⵂⴹ ⵤⵍ⵰ ⵜⵔⴹⵎ ⵙ ⴼⵍⵙⵏⵏ ⵙⵂⴶⵓ ⵜⴹⵂⵍ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ⵏⵗⵓⵏ ⵜⵏⴾⴼⵓ ⵍⵈⵆⵏⵙⵏ ⵜⵔⵎⴹ⵰ ⵎⵛⵏ ⵂⵔⴾⴹ ⴹⵢ ⵤⵍ ⵓⴰ ⴹⵤⵆⵍⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⵓⴾ ⴹⴶⵤⵗ ⴹⵗ ⴹⵏⵜ ⵢⵜⴹⵏ ⵤⴶⵤⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ⴹⴼⵔ ⵓⵏ ⴶⴰ ⵗⵢⵙⴰ ⵍⵎⵜⵍ ⵢⵢⵜⴹⵏ ⵜⴼⵏⵏ ⵎⵏⵙⵏ ⴹⵗ ⵜⵛⵜ ⵏⵍⵗⴹⵍⵏ ⵙ ⴶⴰ ⵓⵏ ⵍⴾⵏ ⵢⵜⴹⵏ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ⴾⵍⴰ ⴹ ⴶⵤⵢⵏ ⵎⴹⵏ ⵛⵏ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴼⵍ ⴹ ⴶⵏ ⵛⵓⵜⵔⵓⵏ⵰ ⵢⵏ ⴼⵔⵙⵢ ⵓⴰ ⵂⴹⵏ ⵏⵀⵤ ⵏⵎⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ⴼⵔⵙⵢ ⵤⴰ ⵀⴹⴹ ⴹ ⵜⵜⵔ ⴶⵏⵓ ⴹⵗ ⵎⵏⵜ \"ⵢⴰ ⵎⵛⵏⴰ ⴶⴹⵢⵗⴾ ⵙ ⵓⵔ ⵍⵗ ⴹⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵎⵙⵏⵏ ⵏⵔⴾⵀⵏ ⴹⵏⵎⵤⵔⵢ ⴹⵎⴶⵏ ⵏⵤⵏⴰ ⵓⵍⴰ ⴹⵗ ⵍⵗ ⴹⵏⵀⵤ ⵏⵎⵏⴰ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ⵙⴰ ⴹⵏ ⴾⵍ ⵜⵤⵎⴰ ⴹⵗⵙⵏ ⵛⵏ⵰ ⵜⴾⵙⵗ ⵜⵎⵙⴹⴾ ⴹⵗ ⵓⴰ ⴶⵔⵓⴰ ⴾⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ⵎⵛⵏ ⵏⵀⵤ ⵏⵎⵏⴰ ⵏ⵿ⵜⴰ ⵀⴹⴹⵏ ⴹⵗ ⴶⴶ ⵓⵔ ⵂⵍ ⵓⵍⴰ ⴹⴾⵍ ⵏⵙⵓⴹⵏⵜ ⵙⴰ ⵙⵔ ⵌⵏⵓⵏ ⴶⵜ ⴹⵎⵔⵏⵜ ⴼⵍ ⵓⴰ ⴶⵏ ⵎⵏⵜ ⴹⵗ ⵗⵛⴹ ⴶⵏⵓ \"ⵢⴰ ⵎⵛⵏⴰ ⵜⴶⵤⵜⴾⵢ ⵜⵂⵏⵏ⵿ⵜⵏ ⵏⴾ ⵏⵏⵙⵀⴾⴹ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ⵏⵗⵓⵏ ⵏⵀⵤ ⵏⵎⵓⵏ ⵓⴰ ⵆⵍ ⵂⵏⵜ ⴶⵔⵓ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ ⵎⵛⵏ ⴼⵔⵙⵢ ⵓⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⴶⵔⵓ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ⴼⵍⵙ ⵢ ⴹⴾⵍⵏ ⵎⵏⵜ ⴹ ⵜⵙⵔⵙ ⵎⵛⵏⴰ ⵢ ⵙⵔⵙⵏ ⵎⵏⵜ ⴹ ⵜⴹⴾⵍ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ⵂⵔⴾⴹ ⵀⵔⵔⵏ ⵓⵏ ⵌⵏ⵿ⵗⵢⵏ ⵜⵓⵢⵏ⵿ⵜⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵙ ⵗⵢⵙⴰ ⴼⵍ ⵜⵏⵙⵓⵔ ⴼⵙⵏⵜ ⵜⵔⵙⵏ⵰ ⵏⵢⵏ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵛⵓⵍⵏ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ⵎⵛⵏ ⵗⵔⵏ⵿ⴹⵓ ⵗⵢⵙⴰ ⵙ ⵎⵏⵜ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵢⵜ ⵀⵔⵔⵏ ⴹⴹⴾⵏ ⵜⵏⵏⵓⵔ⵿ⵜⵓⵗⵎ⵰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵛⵍⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⵓⵔ ⵏⴶⴰ ⵢ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵍⵆⵀⵍⵜ ⵛⵍⵜ ⵏ⵿ⵜⴰ ⴹⵙⴶⴰ ⵀⵔⵔ ⵓⴹⵢ ⵓⵔ ⴹⵙⵍⴾⵎ ⵜⵜⴶⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ⵙⵙ⵿ⵜⵏ ⵎⵤⵔ ⵢⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵗⵢⵙⴰ ⵏⵙ «ⵛⵈ ⵍⵗⵏ ⵎⵙ ⴹⵓⵔ ⴶⵏⵜ ⵢⴹ ⴶⵔⵓⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴼⵍ ⵙ ⴹⵜⴶⵏⴰ ⵛⵈ ⵍⵗⵏ⵰ ⵓⵔ ⵜⵍⴰ ⵢ ⵍⵗⵏ ⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ⵜⵙⵏⵗ ⵍⵓⵌⵀⵏⵜ ⴹ ⵓⵔ ⵜⴶⵗ ⵤⵏⴰ ⴹ ⵓⵔ ⵜⴶⵗ ⵎⵏ ⴹ ⵓⵔ ⵜⴾⵔⴰ ⴹ ⵓⵔ ⵜⴶⵗ ⵜⴶⵢⴰ ⵏⵀⵂⵓ ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ⵏⵙ ⵍⵙ ⵓⵏ «ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⵂⵔⵓⴰ ⴹⴰ ⵎⴹⵔⵢⴰ ⵙ ⵜⵏⵙⵀⴹⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢⵓⵏ ⵏⵙ «ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴹⴾⵏⵆⵎⵏ ⵎⵔⴹⴰ ⴶⵍⵓ ⵤⵏ⵿ⵤⵏ ⵓⴰ ⵜⵍⵗ ⴾⵍ ⵜⵤⵏⵗ ⵏⵤⵏⵜ ⵢ ⵜⵍⵆⵓⵏ ⴹ ⵜⴶⵔⵓⵗ ⵔⵤⵗ ⴹⴾⵤⵏ⵿ⵙⵏ ⴹⵗ ⵍⵈⵔⵜ⵰ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵜⴶⵍⴹⵓ ⵜⵍⴾⵎⵗⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ⵙ ⵙⵍⴰ ⵢⵓⵏ ⵗⵛⴹⵏ ⵎⵏⵜ ⵓⵍⵏ ⴼⵍⵙ ⵜⴶⵔⴶⵙ⵿ⵜ ⵜⴶⵜ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ⵙ ⵏⵢ ⵗⵢⵙⴰ ⵙ ⵗⵛⴹⵏ ⵎⵏ ⵏⵍⵙⵏ ⵓⵍⵏ ⵏⴰ «ⴾⵜ ⵤⵓⵢ ⴶⵢ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴼⵍ ⵓⵏ ⴶⵔⴶⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ⴶⵔ ⵜⵔⵗⵙⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵍⵎ ⵔⴹⵗ ⴹⵗ ⵜⵀⴹⵢ ⵏⵏⵤⵎⵢ ⵢ ⵜⴰ ⴶⴰ ⴼⵍ ⵎⴶⵔⴶⵙ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ⵜⵤⵔ ⵏⵏⵙ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵙⵙⵎⵏⵏ «ⴹⵢ ⵤⴰ ⵎⴰ ⴼⵔⴶⵏ ⴹ ⵗⵍⵙ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴰ ⵎⵙⵏ ⵎⵈⵍ ⵗⵔ ⵢⵜⴹⵏ ⵎⵛⵏⴰ ⴼⵔⴾⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ⵏⵙ ⵀⵜⵔⵙ «ⵏⴾⵏⵢ ⵤⴰ ⵢⵏⵏ ⵓⴰ ⵏⵍⴰ ⴾⵍ ⵏⵍⴾⵎⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵏ⵿ⵤⵢⵏ ⵂⵏⵜ ⵎⴹⵗ ⵜⵏ⵿ⵜⵜⵏⵜ ⵎⴹⵗ ⵎⴹⵔⵢⵏⵜ ⵎⴹⵗ ⵎⵔⵓⵏⵜ ⵎⴹⵗ ⵀⵔⵔⵏⵜ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ⵙ ⵓⵔⴶⵗ ⴹ ⴶⵔⵓ ⵏⴹⴼⵙⵏⵙⵏ ⴹⵗ ⵂⵔⵓⴰ ⵎⵔⴹⴰ ⴶⵔⵓ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵍⴾⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ⴾⵙ ⵗⵢⵙⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⴹⵗ ⵢⵜⴹⵏ ⵏⵙⵏ «ⵙⵙⵎⵜ ⵏⴾⵏⵢ ⴹⴰ ⴶⵤⵢⵏⵏ ⵙ ⵢⵔⵙⵍⵎ ⴹⴰ ⵎⵔⵏ ⴹⵏ ⴹⴰ ⴹ ⵤⵏ⵿ⴹⵓ ⵔⵜ ⴾⵍ ⵓⴰ ⴾⵜⵀⵏ ⵏⵀⵜⵏ ⴹⵗ ⵙⵍⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ⴹ ⵜⵓⴶⴰ ⴹⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⴹⵗⵢ ⵜⵎⴾⴾⵢⵜ ⴶⵏⵢ ⵛⵙⵙⵍⴾⴰ ⵙⵜⴼⵏ ⴼⵍⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ⵢⵓⵏⵏⵢ ⵛⵓⵜ ⴶⵏ ⵎⵏⵏ ⵜⵤⵔ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⴶⵔⵏ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵓⴰ ⵏⴰ ⴹⵏ ⵜⵏ⵿ⴾⵍⵙⵏ ⵍⵎⵗⵏⵏⵜ ⵓⵔ ⴶⵔⵏ ⵓⴰ ⴹⵗ ⴹⵙⵏⵛⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ⵙ ⴹⵂⵤ ⵗⵢⵙⴰ ⵗⵔⵎ ⵓⵏ ⵢⵔⴾⵓ ⴾⵢ ⴼⵍ ⵎⴹⵔⵗⵍ ⵢⵏ ⵆⵎⵏ ⴼⵍ ⴼⵢ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ⵙ ⵙⵍⴰ ⵎⴹⵔⵗⵍ ⵢ ⵜⵎⵜⵢ ⵜⴰ ⴼⵍⵙ ⵜⵜⴾⵢⵜ ⴹⴰ ⵙⵙ⵿ⵜⵏ ⴹⵓⴰ ⵎⵙ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ⵜⵓⵏⵙ «ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ ⵜⴾⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ⵎⵔⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⴶⵏⵓ «ⵢⴰ ⵗⵢⵙⴰ ⵓⵏ ⴶ ⵏⵀⵢ ⴹⵓⴹ ⵂⵏⵜⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ⵙⵏⵔⵗⵎⵏⵙ ⵢⵜⴹⵏ ⵓⵏ ⵤⵔⵏⵏ ⵢⴹ ⴼⵙ⵿ⵜⵓ ⵎⵛⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⴶⵏⵓ «ⵢⴰ ⴶ ⴹⵓⴹ ⵂⵏⵜⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ⵜⵤⵔ ⵤⴾⵜ ⵗⵢⵙⴰ ⵎⵔ ⵙⴹⵙⴹⵜⵍⵓⵢ⵰ ⵙ ⵜⴹⵙⴰ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ⵎⵙ ⵜⵔⵗ ⴹⴾⴶⴰ⵰» ⵏⵙ ⵎⴹⵔⵗⵍ «ⵎⵍⵢ ⵔⵗ ⴹⴹⵆⵍ ⵙⵓⴹⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ⵏⵙ ⵗⵢⵙⴰ «ⵆⵍⵜⴾⵢⴹⵓ ⵙⵓⴹⵏⴾ ⵤⴶⵤⵏⴾ ⴾⵢⵗⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ⵆⵍⴹⵓ ⵙⵓⴹ ⵎⴹⵔⵗⵍ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴶⵍⴰ ⵍⴾⵎ ⵢ ⵗⵢⵙⴰ ⵎⵍ ⵎⵛⵏⴰ⵰ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵏⵢⵏⵏ ⵓⴰ ⴶⵏ ⴹⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵎⵍⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ⴶⵤ ⵗⵢⵙⴰ ⵗⵔⵎ ⵏⵢⵔⴾⵓ ⴾⵢ ⴹⵗ ⵎⵙⵏⵜ ⵢⴹ ⵜⵔⴹⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ⵗⵔⵎⵏ ⵂⵢ ⵍⵙ ⴶⵏ ⵙⵎ ⵤⴾⵢⵙ ⵎⵙⵏ ⵎⵤⵔ ⵏⵀⵤⵏ ⵏⵎⵏⴰ ⵏⵎⴶⵔⴶⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ⴹ ⴶⵎⵢ ⴹⵏⵢ ⵏ⵿ⵗⵢⵙⴰ ⵎⵛⵏ ⵜⴶⴹⵍⵙ⵿ⵜⵓ ⵜⵎⵜⵢ ⴼⵍⵙ ⵜⴶⵤⵍⵢ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ⵜⵤⵔ ⵤⵍ ⵤⵔ ⵢ ⵜⵎⵜⵢ ⴼ⵿ⵜⵏ ⵛⴾ ⴶⵏ ⵙⵎ ⵙⴾⵎⵔ ⴼⵍ ⴹ ⵏⵢ ⵗⵢⵙⴰ ⴼⵍⵙ ⴹⵏ ⴹⴰ ⴹⵤⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ⵙ ⴹⵓⴹ ⵗⵢⵙⴰ ⴹⴶ ⵓⵏ ⴹⴾⵍ ⵙⵓⴹⵏⵜ ⵏⵙ «ⵤⴾⵢⵙ ⵤⵀⵜⴹⵓ ⵜⵔⵎⴹ ⵤⵍⴹⴰ ⴾⵏ⵿ⴹⵀⴰ ⵤⵀⵗ ⴹⵗ ⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ⵤⵀⵜⴹⵓ ⵤⴾⵢⵙ ⵜⵔⵎⴹ ⵆⵀⵍ ⵓⵏ ⴼⵍⵓⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ⵙ ⵏⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵜⵏ⵿ⵜⵏⵏ ⴾⵜⵏⵙⵏ ⴶⵏⵏ «ⵤⵀⵜ ⵗⵔ ⵍⵙ ⵏⵏⵙⵀⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ⵎⵔⵏ ⵀⴹⴹ ⵤⴾⵢⵙ ⴹⵜ ⵎⵍⵢ ⵗⵢⵙⴰ ⵏⵙ «ⵢⴰ ⵎⵍⵢ ⴹ ⴾⴼⵗ ⵜⵤⵏ⵿ⵜ ⵏ⵿ⵜⵍⵏⵏ ⵢ ⵜⵍⵆⵓⵏ ⴾⴹ ⴹⵗ ⵍⵢ ⵢ ⴹⵗ ⵜⵛⵗ ⵔⵜ ⴹⵙ⵿ⵜⵙⵗⵍⴰ ⵎⵙ ⴾⵤ ⵏⴹⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ «ⵤⵍⴹⴰ ⵂⵏ ⵓⴰ ⴶⵤⵜⴹ ⵍⵗⵍⵙ ⴼⵍⵙ ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵂⵢⴰ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ⵏⴾ ⴶ ⴶⴹⵎ ⵙⵗⴹⵓ ⴶⵎⵢⵗ ⵢⵜⴹⵏ ⵓⵏ ⵈⵔⴾⵏⵏ ⵢⵜⵏⵗⵍⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ⵙⵙⵎⵏ ⵢⵜⴹⵏ ⵢⵓⴰ ⴶⵏⵓ ⵗⵢⵙⴰ ⴾⵜⵏⵜ⵰ ⴶⵙⵏ ⵗⵢⵙⴰ ⵜⵏ⵿ⴶⵍ⵿ⵜ ⵢⵜ ⴼⵍⵙ ⵂⵤ ⵢⵔⵙⵍⵎ ⵎⵔⵏ ⵗⵍⵏ ⵍⵓⵆ ⵓⴹ ⵤⴰ ⵜⵏⴼⵍⵍ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ⵏⵙⵏ «ⴾⵍⴰ ⴾⴰ ⵍⵙ ⵢⵏ ⵏⴶ ⴾⵜ ⴾⵍ ⵢⵏ ⴶⴶⵏ ⵢⴹⵗⵙ ⴹⴶⵔⵓ ⵜⵎⵏⴾⵍⴰ ⵆⵍⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ⴹⵜ ⵜⴾⵍⵢⵏⵜ ⵗⵔⴹⵓ ⵎⵔⵓ ⴹⵗ ⴾⵍⵏⵜ⵰ ⴾ ⵢⵏ ⴹⵗⵙⵏ ⴾⴼⵢ ⵜⵎⴰ ⵏⵙⵏ \"ⴶⵓⵜ ⴹⵗⵙⵏⵜ ⵌⵍⴰ ⵂⵔ ⴹⵆⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ⵎⵔⵏ ⵍⵙ ⵏ ⵓⵔ ⵜⵔⵏ ⵢⵜⴹⵏ ⵏⴾⵍⵏⵜ⵰ ⵙ ⴶⵍⴰ ⵙⴶⵍⵏ ⵏⵎⵤⵍ ⵙⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵢⴹⵙⵏⵏ \"ⵍⵙ ⴹⵢ ⵓⵔ ⵏⵔⴰ ⴹ ⵆⵍ ⵎⵏⴾⵍⵏⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ⵎⵛⵏ ⴶⵔⵓ ⵜⵗⵎⵔ ⵆⵍⴹⵓ ⴾⵍⵏⵜ⵰ ⵙⵙⵗⵔⴹⵓ ⴾⵍⵏⵜ ⵓⵏⴹ ⴾⴼⴰ ⵜⵎⵜⵏ ⴹⴰ ⴼⵍ ⴹ ⵙⵏ ⵓⴰ ⵙⵔⵙⵏ ⴹⴶⵤⵏ ⴹⵗ ⵌⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ⵙⵢⴹⵓ ⵓⴰ ⵤⵔⵏ ⵏⵙ \"ⵎⵛⵢ ⵜⵎⴰ ⵜⴰ ⴹⵜⴾⴼⵗ ⴶⵔⵓⴹⵓ ⴼⵍⵙ ⵎⵔⵓⵜ ⵛⵢⴹ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ⵏⵙ ⵎⵛⵙ \"ⵍⴼⵢⵜ⵰ ⵍⴾⵏ ⵙ ⴾⵍⵢ ⵍⵗⵏ ⵜⵎⵙⴰ⵰ ⵤⵎⵙ ⵜⵂⴾ ⵜⴼⵍⵙ⵿ⵜ ⴹⵗ ⵓⴰ ⵓⵔ ⵏⴶⵜ ⴹⵢ ⵤⴰ ⴾⵢⵤⵤⵔⵗ ⵢ ⵎⵔⵓ ⵗⵔⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ⵙⵢⴹⵓ ⵓⵏ ⵛⵏ ⵏⵙ \"ⵎⵛⵢ ⵜⵎⴰ ⵜⴰ ⴹⵜⴾⴼⵗ ⴶⵔⵓⴹⵓ ⴼⵍⵙ ⵙⵎⵙⵜ ⵛⵢⴹ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ⵏⴰ ⵢ ⵓⴰ \"ⴾⵢ ⴹ ⵜⵤⵔⵗ ⵢ ⵙⵎⵙ ⵗⵔⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ⵙⵢⴹⵓ ⵓⵏ ⴾⵔⴹ ⵏⴰ \"ⵎⵛⵢ ⵜⵎⴰ ⵜⴰ ⴹⵜⴾⴼⵗ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ⴾⵎⵙ ⵜⵜⴶⵗ ⴹⵗ ⵍⴾⵛⴼⵏⵏ ⴶⵤⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ⵜⴾⵙⴹⴰ ⴾⵢⴶⵗ ⴼⵍⵙ ⵙⵏⵗ ⵙ ⵍⵙ ⵍⵀⵙⵏ ⵜⵎⵙⴰ⵰ ⵜⴹⴾⵍⵗ ⵓⵔ ⵜⵙⵏ⵿ⵙⴰ ⵜⵜⵍⵢⴰ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵓⵔ ⵜⵏⵀⵍⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ⵏⵙ ⵎⵛⵙ \"ⴾⵢ ⵔⴾ ⴾⵍⵢ ⵜⵎⵙⴰ ⵓⴰ ⴹⴶⵎⴹⵏ ⵎⵏⴾ ⵙ ⴾⵢⵤⵀⵤⵗ⵰ ⴹⴹ ⵜⵙⵏⵗ ⵙ ⵎⵙⵗ ⵓⴹⵏ ⵍⵀⵙⵏ ⴹⴾⵍⵏ ⵓⵔ ⵙⵏ⵿ⵙⴰ ⵜⵍⵢ ⴹⵗ ⵜⵓⴶⵙ⵿ⵜ ⵓⵔ ⵏⵀⵍ ");
INSERT INTO ttqt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ⵎⴰ ⴼⵍ ⵙ ⵓⵔ ⵜⴶⵗ ⵤⵔⴼⵏ ⴹⵗ ⵀⵏ⵿ⴾ ⴹⵢ ⵙ ⴹⵤⵆⵍⴰ ⴶⵔⵓⴰ ⴼⵍⵙ ⵜⵜⵢⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ⵜⵤⵔ ⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ \"ⵀⵤⵜ ⴹⵗⵙ ⵜⵎⴰ ⵜⴰ ⵜⴼ ⵜⴾⴼⵎ⵿ⵜⵜ ⵢ ⵓⴰ ⵍⵏ ⵎⵔⵓⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ⵏⵏⵙ \"ⵎⵛⴾⵏⴰ ⵓⵔⴶⵗ ⵍⴰ ⵎⵔⵓⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ⵌⵓⵀⵙⵏ ⵏⴰ \"ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴰ ⵍⵏ ⵓⴹⵢ ⴹⵙⵜⵓⵛⵜⵓ ⵓⴰ ⵍⴰ⵰ ⵎⵔⵏ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵔⵜ ⵏⵔⵜ ⵓⴰ ⵍⴰ ⴹⴰ ⴹⵗⵙ ⵜⵔⵎⵙ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵤⵏ⵿ⴶⵏⵏ ⵓⵔ ⵏⵔⴰ ⴹ ⵆⵍⴰ ⵎⵏⴾⵍⵏⵙⵏ ⵓⵢⵜⵏ⵿ⴹⵓ ⵜⴶⵤⵎⵎ⵿ⵜⵏ ⴹⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ⵙ ⵏⴰ ⵓⵏ ⴶⵤ ⵗⴼ ⵏⵜⵍⵀⵏⵜ ⴶⵤⵢ ⵙ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ⵙ ⴹⵏⵂⵤ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⴼⵌⵢ ⴹ ⵜⵏ ⵀⵜⵏⵢ ⴹⴶⵎⴰ ⵏⴹⵗⵗ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ \"ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ\" ⵤⵎⵤⵍ ⵛⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ⵏⵙⵏ «ⴾⵓⵜ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⴹⵜⵓⵏ ⴹⵏ⵰ ⵙ ⵜⵜⵏ⵿ⵜⴶⵤⵎ ⴹ ⵜⵏⵢⵎ ⵂⵍⵍ ⵏⵤⴹⵏ ⵆⵏⵏ ⵙ ⴾⵍⴰ ⵓⵔ ⵜⵓⵏ⵰ ⵔⵓⵜⴹ ⵜⵍⵓⵢⵎ⵿ⵜⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ⵙ ⴾⵓⵏⵙⵙ⵿ⵜⵏ ⵓⴹⵏ ⵏⵓⵏ \"ⵈⴰ ⵎⴰ ⵜⵜⴶⵎ ⴹⵢ⵰\" ⵜⵏⵎⵙ \"ⵎⵍⵢ ⵙⵔⵙ ⴹⵔⵔⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ⴶⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⴹⵏ ⵏⵢⵏ ⵔⵜ ⴾⵍ ⵙⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴹⵙⵏ⵿ⵜⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ⵜⵔⵏ ⵂⵍⵍ ⵙ ⴹⵙⵏⵏⵏ ⵎⵙⵓⵙ «ⵈⴰ ⵎⴰ ⵜⵜⴶⵎ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ⵏⵏⵙⵏ ⵏⵜⵍⵀ ⵓⵏ ⵛⵏ ⵏ «ⵎⵍⵢ ⵙⵔⵙ ⴹⵔⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ⵍⵓⵢⵏ⵿ⵜⴹ ⵢ ⵗⵢⵙⴰ⵰ ⴹⴼⵔⵏⵙ ⴼⵍⵙ ⵙⵍⵙⵏⵙⵏ ⵙⵓⵏⵏⵙ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ⵎⵜⴾⵓⵢ ⴹⵙ⵿ⵜⵙⵓⵏ ⵢⵜⴹⵏ ⵙⵍⵙⵏⵙⵏ ⴹⵗ ⵜⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ⵙ ⴹⵓⴹ ⵗⵢⵙⴰ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵤⴶⴹⵢ ⵜⵔⵢⵜ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ ⴹⵗ ⵏⵎⵂⵤ ⵏⵢⵔⵙⵍⵎ ⴹⴾⵍⵏ ⵏⵍⴾⵎⵏⵜ ⴾⵜⵏⵙⵏ ⵎⵙⵍⵏⵙⵏ ⵙⴶⴹⵏ ⴹⵗ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⴾⵍ ⵛⵏ ⵏⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ⴶⵏⵏ «ⴶⴰ ⵎⵛⵏⴰ ⵍⵀⵔⴾⴰ ⵢⵎⵏⴾⵍ ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ⵰ ⵜⴹⵜ ⵍⵈⵔ ⴹⵜⵏⵢⴰ ⴹⵗ ⵌⵏⵓⵏ ⵓⵏ ⴹⴾⵍⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ⵜⵤⵔ ⵏⵏ ⴼⵔⵙⵢⵜⵏ ⵂⵏⵏ ⵜⵎⵜⵢⵏ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵔⵗⵎ ⵢ ⵏⵍⴾⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵗⵓⵏ ⵙ ⴼⵙ⵿ⵜⵏ ⵛⵂⵏ ⴰ ⵤⴰ ⵙⵗⵔⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ⵙ ⴹⵏⵂⵤ ⵗⵢⵙⴰ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴶⵢ ⴶⵤ ⴼⵍⵙ ⵛⵏ ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ⴶⵏⵓ «ⵢⴰ ⵢⵔⵙⵍⵎ ⵏⵔ ⴾⵎ ⴹⴰ ⵜⵙⵏⵗ ⵎⴾ ⵓⵙ ⵤⴰ ⵜⴶⵔⵓⵗ ⵍⵈⵔ ⵤⵍⴹⴰ⵰ ⵎⵛⵏ ⵓⵔ ⵜⵜⵙⵏⴰ ⴼⵍⵙ ⵗⵀⵔ ⴹⵎⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ⵍⴾⵎⵏ ⴹⵏ ⴹⵗ ⴾⵎⵤⵗⵍⵗⵍⵢⵏ ⵤⵏ⵿ⴶⵏⵎ ⴶⵏⵎ ⴼⵔⴶ ⵙⵂⵏ ⵏⵎⴶⵔ ⴹⴶⵤⵏ⵿ⴾⵎ ⴼⵍ ⴶⵏⵜⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ⴹⴶⴹⴶⵏ⵿ⴾⵎ ⴾⵎ ⴹⵢⵜⴹⵏⵎ⵰ ⵓⵔ ⴹⵗⵎ ⴹⵤⵢⵏ ⵜⵂⵏ⵿ⵜ ⵜⵓⵔⵜ ⵢⵜ ⴼⵍⵙ ⵜⴶⵢⵗ ⵙⴹ ⵜⴶⵔⵗ ⵙⴰ ⵓⴰ ⴹⵎⴹⴶⴰ ⵎⵛⵏⴰ ⵢⴹⵎⴶⵓ ⵔⵈⵎⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ⴹⴼⵔ ⵓⵏ ⴶⵤ ⵗⵢⵙⴰ ⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗⵙ ⵙⵜⵗ ⵎⵙⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ⴶⵏⵙⵏ «ⵓⵔⴶⵗ ⴾⵜⵀ ⵙ ⵏⴰ ⵎⵛⵏⴰ \"ⵂⵏⵏ ⴹ ⵆⵍ ⵂⵏ ⵏ⵿ⵜⵓⵜⵔⵓⵏ⵰\" ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⴶⵎ⵿ⵜⵓ \"ⵙⵍⵗⵙ ⵏⵀⵢⴹⴶⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ⴾ ⵤⵍ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⴹ ⴶⵎⵢⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⴶⵢ ⵏⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ⵎⵛⵏ ⵀⵙⵏ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵏ ⵓⵏ ⴼⵍⵙ ⵢⵜⴹⵏ ⴾⵍ ⴾⵏⵏⵙ ⵙⵙⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ⵤⵍ ⵢⵏ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵍⵙⵏ ⵍⵏ⵿ⵌⵍ ⵙ ⵜⴹⵙⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵓⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ");
INSERT INTO ttqt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ⵏⵏⵙ «ⵎⵍⵏⴰ ⴹⴰ ⴹⵜⴶⵔⵓⴰ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⵜⵜⴶⴰ ⴹⴰ⵰ ⵎⴰ ⴹⴾⵜⴾⴼⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ⵏⵙⵏ «ⵏⴾ ⴹⴰ ⴹⵓⵏⴶⵗ ⵙⵙ⵿ⵜⵏ ⵢⵏ ⵎⵔⵏ ⵎⵍⵜⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ⵓⴾ ⵙⵍⵎⵗ ⵓⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵎⵛⵏⴰ ⵗⵔ ⴹⴼⵍ ⵓⵏ ⵎⵗ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ⵜⵤⵔ ⵏⵎⵛⵓⵔⵏ ⴶⵔⵙⵏ ⵏⵏ «ⵙ ⴹⵙⵏⵏⴰ \"ⵎⵛⵏⴰ ⵗⵔ ⴹⴼⵍ\" ⴹⵏⵗⵏⵓ \"ⵎⴼⵍ ⵤⴰ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵙⵓⴰ ⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ⵙ ⴹⵙⵏⵏⴰ \"ⴶⴹⵎ ⵗⵔ ⴹⴼⵍ\" ⵜⵎⵜⵢ ⵜⴰ ⴾⵜⵏⵜ ⵙ ⴹⵏⵤⵜⵏ⵿ⵗⵓ ⵙ ⵤⵀⵓ ⵏ⵿ⵜⴶⵔ ⴼⵍⵙ ⵜⴾⵙ ⵛⴾ ⵙ ⵢⵈⵢⴰ ⵏⵀⵢ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ⵏⵏⵙ ⵎⵔⵏ «ⵓⵔ ⵏⵙⵏ ⵓⴰ ⵗⵔ ⴹⴼⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⴹⴰ ⵤⴰ ⵓⵔ ⴹⵓⵏ⵿ⵤⵎⵍⵗ ⴹⴹ ⴹⴶⵔⵓⵗ ⵜⵔⵏⴰ ⵏⴶⵢ ⵏⵔⵜⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ⵎⵔⵏ ⵎⵍⵍⵢⵏ ⵗⵢⵙⴰ ⵜⵎⵜⵢ ⴶⵙ ⵍⵎⵜⵍ ⵓⴰ ⵏⴰ «ⴾⵍⴰ ⴹ ⵍⴰ ⵍⵙ ⵢⵏ ⴼⵔⴶ ⵏⵍⵗⵏⵀ⵰ ⵜⵤⵔ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜⵏ ⵢ ⵎⴶⵢⴾⵏ ⵓⵢⴹ ⵛⴾⵍ ⴶⵏ ⵜⵎⵔ⵿ⵜ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ⵙ ⴹⵜⵓⴹ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⵎⵍⵢ ⵏⵍⵗⵏⵀ ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⵢⵏ ⴹⵗ ⴾⵍⵏⵜ ⵢⵜⴹⴾⴼⵏ ⴹⴶⵔⵏⵜ ⴹⵗ ⵓⴰ ⴹⵔⵓ ⴼⵔⴶ ⵎⵛⵏ ⴶⵏⵙ ⵛⵓⵜ ⵙⵗⵍⵏ⵿ⵜⵓ ⵎⵛⵙ ⵙⴾⵔⵢⵔⵢ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⵢⵏ ⴾⵍⵢ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⵏⵙ ⵛⵓⵜ ⵙⴼⵍⵙⵏ⵿ⵜⵓ ⵙⵗⵍⵏ⵿ⵜⵓ ⵓⵔ ⵓⵢ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ⵙ ⵜⴾⵍⵜ ⵜⵏ ⴾⵔⴹⵜ ⵤⵎⵤⵍ ⵙⵔⵙⵏ ⵢⵏ ⴾⵍⵢ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵀⵙⵏ⵿ⵜⵓ ⵙ⵿ⵜⵗⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵎⵛⵙ ⵏⴼⵔⴶ \"ⵓⴾ ⵎⴰ ⵤⴶⴰ⵰ ⵙⵔⵙⵏ ⵤⵎⵤⵍⴰ ⵔⵔⵢ ⵓⴰ ⴾⵏⵗ ⵜⵔⴰ ⵎⵌⵙ ⵏ⵿ⵜⴰ ⵜⵙⵗⵎⵔⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ⵎⵛⵏ ⵙ ⵏⵢⵏ ⵎⴶⵢⴾⵏ ⵓⵏ ⵗⴼⵔⵏⵏ ⴼⵔⴶ ⵀⵔⵔⵏⵜ ⵤⵢⵜⵏ⵿ⴹⵓ ⵏⵎⵏⵏ ⴶⵔⵙⵏ \"ⵏ⵿ⵜⴰ ⴹⵢ ⵎⴾⵙⵓ ⵏⴼⵔⴶ⵰ ⵏ⵿ⵗⵓⵜⵏⵆⵓ ⴾⵔⵤ ⴼⵍ ⴹ ⵜⵆⵍ ⵜⴾⵙⵜ ⵛⵏⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ⴾⵙⵏ⵿ⵜⵓ ⴹⵗ ⴼⵔⴶ ⵏ⵿ⵗⵏ⵿ⵜⵓ ⴾⵔⵤ⵰» ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵜⵎⵜⵢ «ⵎⵔⴹⴰ ⵎⴰ ⵜⵔⴹⵎ ⵎⴰ ⵤⴶⵓ ⵎⵛⵙ ⵏⴼⵔⴶ ⵢ ⵓⵏ ⴹⵏ ⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ⴹⵢ ⵤⴰ ⴹ ⴶⵍⵓ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵓ ⵎⵏ ⵏⵎⴶⵢⴾⵏ ⵓⵏ ⵙⵗⴼⵔ ⴼⵔⴶⵏⵜ ⵢ ⵎⴶⵢⴾⵏ ⵓⵢⴹ⵰» ⵙⵍⵏ ⵢⵜⴹⵏ ⵢⵓⵏ ⵗⵙ ⵏⵏ «ⵎⵛⵏⴰ ⵢⴰ ⵓⵔ ⵜⴶⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ⵜⵤⵔ ⴹⴾⵏ ⵗⵢⵙⴰ ⵙⵙⵓⴹ ⵏⵙⵏ «ⴹⵗ ⴹⵢ ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵓ ⵜⴰ ⵜⵏⵜ ⴹⵗ ⵍⴾⵜⵀⵏ \"ⵜⵂⵏ⵿ⵜ ⵜⴰ ⴹⵏⴶⵔⵏ ⵎⴾⵔⵙⵏ ⵏ⵿ⵜⴰ ⵜⵆⵍⵜ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⴾⵀⵍⵜ ⵂⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵏ ⴼⵍ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⴹ ⴹⴶⴹⴶ ⵓⴰ ⴼⵍ ⵜⴹⴰ ⴹⵗ ⵜⵜⵍⴾⵛ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ⴶⵔⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵙ ⵏ⵿ⵜⵏⵢ ⴼⵍ ⴶⴰ ⵗⵢⵙⴰ ⵍⵎⵜⵍ ⵓⵏ ⵜⵤⵔ ⴶⵎⵢⵏ ⴹⵀⵤⵏⵜ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⵎⵛⵏ ⵓⵔ ⴶⵏ ⵓⵏ ⴼⵍⵙ ⵜⵎⵜⵢ ⴾⵙⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ⴹⵢ ⴼⵍ ⵓⵍⵏ ⵗⵢⵙⴰ ⵏ⵿ⴾⴹⵏⵙ⵰ ⵙⴾⵏ⵿ⵜⴹⵓ ⵎⴹⵏ ⴶⵏⵏ ⵎⵏⵙⵏ ⵍⵎⵜ ⵍⵗⴹⵍⵏ ⴼⵍ ⵜⵛⵛⵓⵍⵏ ⵙⵙⵏⵏ⵿ⵜⵓ ⵔⵜ ⵓⵔ ⵏⵜⵓⵏⵓ ⵀⵤⵏ⵿ⵜⵓ ⵙⵔⵙ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⴼⵙⵏ ⵏⵎⵤⵔ ⵏⴾⵍ ⴹⵍⵈⴾⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ⵙⵙ⵿ⵜⵏⵏ ⵗⵢⵙⴰ ⵏⵏⵙ «ⵛⵈ ⵏⵙⵏ ⵙ ⵓⴰ ⵜⴶⵏⴰ ⴹⵓⴰ ⵜⵙⵙⵗⵔⴰ ⵗⴹ⵰ ⵓⵔ ⵜⵜⴶⴰ ⵜⵎⵔⵜ ⴶⵔ ⵢⵜⴹⵏ⵰ ⵜⵙⵙⵗⵔⴰ ⵙ ⵜⴹⵜ ⵓⵙ ⴹⵏⵗⵓⵔ ⴶⵏⵜ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ⵎⵔⵏ ⵎⵍⵏⴰ ⵓⴾ ⵈⵍⵍⵏⴰ ⵔⵤⵎ ⵏⵎⵏⴰ ⵢⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵆⵢⵙⵔⴰ ⵎⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ⴶⵔⴰ ⵗⵢⵙⴰ ⵜⵏⴶⵎⵢⵜⵏⵙⵏ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«ⵙⴾⵏⵜⵢ ⵜⴼⵍ⵿ⵜ ⵏⵤⵔⴼ⵰ ⵎⴰ ⵍⵏ ⴹⵎ ⴹⵙⵎ ⵓⵏ ⵜⵓⵔⵏⵏ⵰» ⵏⵏⵙ «ⵏ ⵆⵢⵙⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ⵏⵙⵏ «ⴹⵢ ⵤⴰ ⴶⵓⵜ ⵢ ⵆⵢⵙⵔⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ ⵜⴶⵎ ⴹⵗ ⵢ ⵎⵛⵏⴰ ⵓⴰ ⴾⵓⵏⵙⵓⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ⵏ⵿ⴹⵔⵙⵏ ⵜⵙⵙⴶⵏ ⵔⴾ ⵓⵍ ⴹⵜ ⵢⵜⴹⵏ⵰ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵍⵌⵓⵀ ⵓⴰ ⴹⵙⵏⴶⴰ ⴹⵏ ⴼⵙ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ⴹⴼⵔ ⵓⵏ ⵙⵏ⵿ⵜⴹ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵏ⵿ⵜⴶⵢⵜ ⵜⵏ ⵙⴹⵙⵢⵜⵏ⵰ ⵙⴹⵙⵢⵜⵏ ⵜⴼⵏ ⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵏⴾⵔⴰ ⴹⴼⵔ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ");
INSERT INTO ttqt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ⵏⵏⵙ «ⵛⵈ ⵏⴰ ⵏⵀⵢ ⵎⵙⴰ ⴹⵗ ⵜⵓⵔⵜ \"ⵙ ⵀⴰ ⵍⵙ ⵢⴹⵓ ⵜⵏ⵿ⵜⵜ ⴹⵔ ⵓⵔ ⵍⴰ ⵀⵔⵔ ⵜⵜⵤⵍⴼ ⵎⴹⵔⵢⵏⵜ ⴼⵍ ⴹ ⴶⵓ ⵤⵔⵢⴰ ⵢⵎⴹⵏⵜ ⵓⴰ ⵀⴰ ⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ⵎⵔⵏ ⴾⵍⴰ ⵜⵍⵏ ⵙⴰ ⵎⴹⵔⵢⵏ⵰ ⵤⵍⴼ ⵓⴰ ⴹⵙⵏⵓⵛⵔⵏ ⴾⵜⵏⵙⵏ ⵀⵜⵓ ⵓⵔ ⵍⴰ ⵀⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ⵤⵍⴼ ⵓⵏ ⵛⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⴹⵢⴰ ⵎⵆⵔⵏⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⵀⵜⵓ ⵓⵔ ⴹⵢⴰ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ⵓⴰ ⵏ⵿ⴾⵔⴹ ⴹⵗ ⵓⵏ ⴹⴰ⵰ ⵙⴰ ⵎⴹⵔⵢⵏⵏ ⴾⵜⵏⵙⵏ ⴶⵔⵓⵜⵏ ⵓⵏ ⴹⴰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴹⵢⵏ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ⴹⴼⵔ ⵓⵏ ⵀⴰ ⵜⵏ⵿ⵜⵜ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ⵓⴾ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ ⵎⴰ ⵎⵙ ⴹⵗ ⵙⴰ ⵎⴹⵔⵢⵏ ⵓⵏ ⴹⵏ ⵓⵙ ⵤⴰ ⵜⵆⵍ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵜⵗⵔⵙ ⴹⴹ ⵤⵎⵙ ⴾⵜⵏⵙⵏ ⵤⵍⴼⵏ⵿ⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵏⵂⴰ ⴹⴰ ⵤⵍⴼⵏ ⵎⴹⵏ ⵜⵓⵤⵍⴼⵏⵜ ⵜⴹⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵏⵂⴰ ⵎⵛⵏⴰ ⴹⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⴹ ⴶⵤⵏ ⵍⵌⵏⵜ ⵓⵏ ⴹⵢ ⵓⵔ ⴹⵙⵏ⵿ⵜⵍⴰ ⵤⵍⴼ ⴶⵔ ⵤⴰ ⵎⴹⵏ ⵓⵍⴰ ⵛⴹⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ⴹ ⵀⵙ ⴹⵗⵙⵏ ⵜⵍⴾⵎ ⵜⵎⵜⵏ⵿ⵜ ⵍⵏ ⴹⵏ⵿ⴶⵍⵙⵏ ⵆⵍⵏ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⴹ ⵜⵏⴾⵔⴰ ⴹⴶⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ⵎⵔⵏ ⴹⵗ ⵓⴰ ⵆⵍⵏ ⵜⵏⴾⵔⴰ ⵏⵎⵜⵏ ⵏⵀⵢ ⵎⵙⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙ ⵙⵜⴹⴰ ⵓⵏ ⴹⵗ ⵜⵓⵔⵜ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⴼⵙⵆ ⵙⵗⴰ ⵓⴹ ⵏⴰ ⵎⵛⵏⴰ ⵎⵙ \"ⵎⵍⵢ ⵏⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹⵢⵆⵀ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ⴹⵗ ⴹⵢ ⵎⵛⵏⴰ ⵓⵔ ⵎⵙ ⵎⵍⵢ ⵏ ⵜⵎⵈⵙⴰ ⴾⵍⵔ ⵎⵍⵢ ⵏⵓⵏ ⴹⵔⵏⵏ ⵎⵙ ⴼⵍⵙ ⵗⵔⵙ ⵢⵜⴹⵏ ⴾⵍ ⴹⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ⵏⵏ ⵓⵢⴹ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵢ ⵗⵢⵙⴰ «ⵛⵈ ⵜⴶⵗ ⵓⵍ ⵍⵗⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ⴹⴼⵔ ⴹⵢ ⵀⵙ ⵂⵍⵏ ⵙⵙ⵿ⵜⵏⵜ ⴹⵔⵜ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ⴹⴼⵔ ⵓⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵎⵏⵎⴾ ⵙ ⵜⵓⵏⵓ ⵍⵎⵙⵈ ⴶ ⵎⵏⴾⵍ ⵏⵀⵢ ⴹⵓⴹ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ⵏ⵿ⵜⴰ ⴹⵓⴹ ⵎⵏⵜ ⵙ ⵙⵔⵙ ⵏⴰ ⴹⵗ ⵍⴾⵜⵀ ⵓⵏ ⵤⵀⵔ \"ⵏⴰ ⵎⵍⵢ ⵢⵎⵍⵏⵏ 'ⵆⵎⵓ ⴹⵗ ⵗⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ⵂⵔ ⴶⴰ ⵤⵏ⵿ⴶⵏⴾ ⴹⵓ ⴹⵔⵏⴾ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⴹⵓⴹ ⵎⵏⵜ ⵗⵔⴰ ⵍⵎⵙⵈ ⵙⵙⵎ ⵓⵏ ⵎⵍⵢ ⵎⵏⵎⴾ ⵙ ⵤⵆⵍ ⵀⵔⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ⵂⵔⵓⴹⴰ ⵙⵙⵎⵏ ⵢⵜⴹⵏ ⴾⵍ ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ⵏ⵿ⴾⴹⵜ ⵢ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵔⵏ ⵙⵗⵍⵢ ⵤⵍⴶⵏ ⵛⴾⴹⴾⴹⵏ ⵤⴶⵔⵜⵏⵏ ⴹⵜⵓⵙⵙⵍⵎ ⴶⵏ ⵙ ⵙⵗⵎⵔ ⴹⵗ ⵙⵎⵏⵢⵏ ⵔⵏ ⵜⵗⵎⵜ ⴹⵗ ⴹⴶⵏ ⵓⵏ ⵍⵏⵏ ⵍⵎⵆⵎ ⴹⵗ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⴶⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⴹⵗ ⵎⴶⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ⵜⵜⵏ ⵂⵔⵢ ⵏ⵿ⵜⴹⴹⵏ ⵛⵏ ⵙ ⵀⴰ ⵎⴹⵏⵙⵏⵜ ⵙ ⴶⴰ ⵓⵏ ⵜⴶⵏ ⵎⴹⵏ ⵜⵂⴶⵏⵏ ⵓⵔ ⵏⵎⵙ ⵔ ⵙⴾⵏⵢ⵰ ⵍⴾⵎ ⴹⵙⵏⵜⵓⵈⴾⵎ ⵜⴹⵀ ⵍⵀⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ⴹⴾⵍ ⵗⵢⵙⴰ ⵙⵓⴹⵏⵜ ⵏⵢ ⵎⴶⵔⴶⵙ ⵜⴶⵏ ⵤⵔⴼ ⵓⴰ ⴾⵜⵏ ⴹⵗ ⵙⵏ⵿ⴹⵆ ⵓⴰ ⴹⵗ ⵜⴹⵓ ⵔⵤⵗ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ⵏⵢ ⴹⵗ ⵜⵏ⵿ⵜⵜ ⵢⵜ ⵏ⵿ⵜⵍⵆⵢ ⵙ ⵓⵔ ⴹⵔ ⵍⵙⵏⵜ ⵙ ⵜⴶⴰ ⴹⵗ ⵙⵏ⵿ⴹⵆⵏ ⵙⵏⵜⵜ ⵜⴼⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ⵜⵤⵔ ⵏⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵏ⵿ⵜⵜ ⵜⵏ ⵏ⵿ⵜⵍⵆⵢⵏ ⵙ ⵓⵔ ⴹⵔ ⵍⵙⵏⵜ ⵏ ⵜⴶⵔ ⵢⵜⴹⵏ ⴾⵜⵏⵙⵏ ⵜⵂⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ⴼⵍⵙ ⴾⵜⵏⵙⵏ ⵓⵙ ⵓⵔ ⴹⵔⵔⵏ ⴾⴼⵏ ⵏ⵿ⵜⴰ ⵎⵔⵏ ⴹⵔⵔⵜⵏⵜ ⴹⵗ ⵜⴹⴾⵍ ⵓⴰ ⵜⵍⴰ ⴾⵍ ⵜⴾⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ⵛⵓⵍⵏ ⵢⵜⴹⵏ ⵓⵢⴹ ⴹⵗ ⵀⵜⵓ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵍⵏ ⴹⵍⴶ ⵓⴰ ⴶⴰ ⵙ ⵜⵂⵏ ⵂⵙⵢⵏⵏ ⴹⵔⵜⵏ ⵓⵏ ⴾⴼⵏ ⵢⵜⴹⵏ ⴹⵗ ⵜⴾⵜⵓⵏⵙⵏ⵰ ⵏⴰ ⵗⵢⵙⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«ⴰ ⵓⴰ ⵜⵂⵏⵢⵎ ⴹⴰ ⵍⴾⵎⵏ ⴹⵏ ⴹⵗⵙ ⴹⵓⵔⵤⵜⵆⵎ ⵜⵂⵏ⵿ⵜ ⵜⵓⵔⵜ ⵜⵎⴹⵜⵏⵜ ⴾⵜⵏⵜ ⴹ ⵜⵓⵌⵀⵔⵌⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ⵜⵤⵔ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵛⵈ ⵎⵢ ⴹ ⵤⴶⵓ ⵓⴹⵢ ⵔⵜ⵰ ⵎⴰ ⵤⴰ ⵜⵆⵍ ⵍⵗⵍⵎⵜ ⵜⴰ ⵤⴰ ⵜⵙⴾⵏⵜ ⵙ ⵀⴾ ⵢⴶⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏ⵿ⴾⴹⵜ ⴹ ⵓⵔ ⵜⵜⵓⵙⵈⵔⴾⵎ ⴹ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵤⵙⵏⵏ ⵜⴼⵏ ⵙⵎⵏ⵰ ⴾⵢⵏ ⴹⵗⵙⵏ ⴶⵏⵓ \"ⵏⴾ ⵎⵙⵏ ⵍⵎⵙⵈ\" \"ⵜⵆⵏ ⵜⵓⴹ⵰\" ⴹⵙⵏⵓⵔ⵿ⵜⵍⴾⵎⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ⵙ ⵜⵙⵍⵎ ⵢ ⵜⵔⵎⵆ ⵏⵎⴶⵔⵏ ⴹⵍⴼⵍⴶⵜⵏ ⴹ ⵓⵔ ⵜⵛⵓⵛⵎ ⴼⵍⵙ ⵔⵜⵏ ⴹⵢ ⴾⵏ⵿ⴹⵀⴰ ⵤⵔⵏ⵿ⴹⵓ ⵎⵛⵏ ⵓⵔ ⴹⵙⵏ⵿ⵤⵜⵍⴾⵎ ⵜⵤⵔⵙ⵿ⵜ ⵏⴹⵏⵜ ⴹⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ⵏⵙⵏ ⴹⵗ «ⴹ ⴾⵏⵙⵏⵜ ⴹⵓⵍⵜⵏ ⴶⵔⵙⵏⵜ ⴾⵏⵙⵏⵜ ⵜⵗⵎⵔⵏ ⴶⵔⵙⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ⵎⵍⵏ⵿ⵜⵓ ⵏⴶⵢⵏⴶⵢⵏ ⵏⵎⴹⵍ ⵍⵀⵙⵏⵏ⵰ ⵎⵍ⵿ⵜⵓ ⵍⵤ ⴹⵜⵓⵔⵏⵓⵏ ⵙⴾⵙⴹⵏⵏ ⴹⵗ ⴹⴶⵏ ⴶⵜⵏⵏ ⵎⵍⵏ⵿ⵜⵓ ⴹⵗ ⵔⵜⵏ ⵙⴾⵙⴹⵏⵏ ⴹⵍⵗⵍⵎⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ⵎⵛⵏ ⴹⵜ ⴹⵢ ⴾⵍ ⴹ ⵜⵜⵔⵎⵙⵎ ⵜⵜⵓⵤⵗⵤⵀⵎ ⵜⵎⵓⵢⵎ ⵙ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵜⵓⴶⵎ ⴹⴰ ⴾⵙⵓ ⵜⵜⵓⵙⵀⴹⴹⵎ ⴹⵜ ⵎⵏⴾⵍⵏ ⴹⵏⵈⴾⵎⵏ ⵜⵜⵓⵙⵙ⵿ⵜⵏⵎ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ⴾⵓⵏⴾⴼⵓ ⴹⵢ ⵜⵔⵢⵜ ⵏ⵿ⴼⵍⵢ ⵜⴶⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ⴹⵗ ⴹⵢ ⵙⵏ⵿ⵙⵓⵜ ⵜⵢⵜⵓⵏⵓⵏ ⴹ ⵓⵔ ⵜⵙⵎⵜⴶⵎ ⵓⴰ ⵤⴰ ⵜⵏⵎ ⵢⴹ ⵜⴾⵙⵎ ⵎⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ⴼⵍⵙ ⴾⵓⵏⴾⴼⴰ ⵎⵙⵏⵜ ⵏⵓⵍ ⴹⵜⵍⴰ ⵏⴶⵔⵢ ⵙ ⵜⵓⵔⵍⴰ ⵤⵏ⵿ⴶⵓⵏⵓⵏ ⴹⵙⵏ⵿ⵤⴼⵔⴶⵏ ⵓⵍⴰ ⴹⵗ ⴼⵔⴶ ⵙⵀⵂⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ⵓⵍⴰ ⵎⵔⵓⵏⵓⵏ ⴾⵓⵏ⵿ⵙⵜⵔⵎⵙⵏ ⵙⵜⵔⵎⵙⵏ⵿ⴾⵓⵏ ⵎⴹⵔⵢⵏⵓⵏ ⴹⵛⵆⵗⵏⵓⵏ ⴹⵎⴹⵓⵏⵓⵏ ⵜⵓⵏ⵿ⵗⵏ ⵓⵢⴹ ⴹⵗⵓⵏ ⴾⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ⴾⵓⵏⴶⵤⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⴼⵍⵙ ⴾⵓⵏⵓⵔ ⵙⵎⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ⵎⵛⵏ ⵓⵔ ⴹⵓⵏ⵿ⵤⵗⵛⴹ ⴹⵢ ⵓⵍⴰ ⴹⴶⵏ ⴹⵜⵤⵗⵢ ⵏⵎⵢ ⵏⵛⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ⵤⵎⵔⵜⵏⵓⵏ ⵙ ⵤⴰ ⵜⴶⵤⵎ ⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ⵙ ⵜⵏⵢⵎ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵗⵍⵢⵗⵍⵢⵏ⵿ⵜⵓ ⴶⵏⵏ ⵏ⵿ⵙⵌⵜⵏ ⵜⵙⵏⵎ ⵙ ⵌⵓⵔ ⵜⵓⴹⴶⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵓⵏ ⴹⵢ ⴹⴶⴶⵏⵜ ⵙⴹⵗⵗⵏ⵰ ⵓⵏ ⵂⵏⵏ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴶⵎⴹⵏⵜⵓ ⵓⵏ ⵜⴶⵎⴹⵏⵏ ⵙ ⵙⴼⵏⵜ ⵜⴹⵓⵔⵆⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ⴼⵍⵙ ⴹⵏ ⵓⵏ ⴹⵢ ⴹ ⵆⵍⵏ ⴹⵏ ⴹⵗ ⵤⵓⴹⵀ ⵎⵛⵏⴰ ⵢⵜⴹⵏ ⴼⵍ ⴹ ⵏ⵿ⴹⵏ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵏⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ⴾⵜ ⵍⵗⵤⵀ ⴹ ⵜⴶⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⴶⵏⵏ ⵛⴹⵙⵏ ⴹⵛⵏ ⵙⵏ⵿ⴾⵙⵏⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵏ ⴼⵍⵙ ⴹ ⵜⴶⵓ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⴹⵗ ⴾⵍ ⵤⵀⵜⴹⵓ ⵜⴹⵀ ⵏⵎⵛⵏⴰ ⴼⵍ ⵜⵎⵜⵢ ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ⵔⵜ ⴹⵗ ⵜⵎⵜⵢ ⵜⴰ ⴹ ⵜⵓⵏ⵿ⵗⵓ ⵙ ⵜⴾⵀⴰ ⵓⴰ ⵂⴹⵏ ⴾⴼⵍ ⵙ ⴾⵍⵏ ⴾⵍ ⴶⵤⵏⵜ ⵜⵎⵜⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵜⵜⵜⴼ⵿ⵜⴼⵏⵜ ⵂⵔ ⵜⵏ⵿ⴹⵓ ⵜⵎⵙ⵿ⵜⵏ⵿ⵜ ⵜⴰ ⵜⵏⵜⴾⴼⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ⴹ ⵜⵓⵏⵢⵏ ⵔⵜⵏ ⵙⴾⵙⴹⵏⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵙ ⵤⴶⵏⵏ ⴹⴰ ⵜⴼⴾ ⴹⵜⵍⵜ ⴹⵜⵔⵏ⵰ ⴹ ⵛⵓⵛⵏⵜ ⵜⵎⵜⵓⵏ ⵏⴹⵏⵜ ⵓⵍⵏ ⵆⵏ ⵎⵙⵍⵢ ⵍⵀⵙⵏ ⵓⴰ ⵜⴶⵏⵜ ⵜⵏⵤⵎⵔⵏ ⵏⵎⵏ ⵏ⵿ⴶⵔⵓⵏ ⵗⴼⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ⵢⵜⴹⵏ ⵜⵏ⵿ⵜⵏ⵿ⵗⵓ ⵜⵙⴰ ⵏⵔⵜⵏ ⵓⵏ ⵂⵏⵢⵏ ⵤⵢⵏ⵿ⴹⵓ ⴹⵏⵜ ⴼⵍⵙ ⴹ ⵜⵓⵙⵏⴶⵢⵏⴶⵢⵏⵜ ⵜⵈⵍⴾ ⵛⵏ ⵍⵏⵏ ⵜⵔⵏⴰ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ⵍⵓⵆ ⵓⴹⵢ ⴹⵏⵢⵏ ⵢⵜⴹⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵙ ⴹⵤⵙⴰ ⵂⵗ ⵜⴶⵔⴾ ⵍⵗ ⵜⵔⵏⴰ ⴹⵜⵏⵢⴰ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ⵙ ⵏ⵿ⵜⵏ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵜⵙⵎⵜⴶⵎ ⵏⵍⵎⵏⵜ ⵎⵏⵓⵏ ⴼⵍⵙ ⵍⵓⵆ ⵏ⵿ⵜⴹⵔⴼⵜⵏⵓⵏ ⵂⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ⴶⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵜⵍ ⵏⵙⵏ «ⵏ⵿ⵤⵔⵜⵏ ⴹⵗ ⵛⴾ ⵏ⵿ⴼⴶ ⴹⵛⴾⵏ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ⵙ ⴶⵤⵏ ⵛⵏ ⵜⵏⵤⵔⴰ ⴹ ⵜⵙⵏⵎ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵙ ⵜⵎⵔ⵿ⵜ ⵜⵏ ⴾⵙⴰ ⵜⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⵗ ⵙ ⵙ ⵜⵏⵢⵎ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏⵎⵍⵗ ⴹⵢ ⵜⵙⵏⵎ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵜⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵎⵜⵢ ⵜⴰ ⴹⴰ ⵏⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ ⴹ ⵜⵏⵢ ⵏⵜⵢ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵍⴾⵎ ⴹ ⵀⵙ ⵜⵍⵏ ⵎⵛⵏ ⵀⵜⵜⵏⵏ ⵍⵏⵜⵓ ⵂⵔ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«ⵏ⵿ⴾⴹⵜ ⴼⵍ ⵎⵏⵓⵏ⵰ ⴹ ⵓⵔ ⵗⵛⴹ ⴶⵜ ⵏ⵿ⵜⵜⵢ ⴹⵜⵙⵢ ⵏⵙⵎⴹ ⴹⵎⴹⵔⵏⵏ ⵏⴹⵏⵜ ⵏⵢⵜⵏⵓⵏ ⴶⵓⵏ ⵤⵍ ⵓⴹⵢ ⵗⴹⵔ ");
INSERT INTO ttqt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ⵤⵏ ⵓⴰ ⵜⵜⴶⵓ ⵜⴼ⵿ⵜⵓ ⵢⵓⴹⵏ⵰ ⵔⵜ ⵓⴹⵢ ⴹ ⴶⵓ ⴼⵍ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵓⵔⵏⵏ ⵜⵙⵢⵜ ⵏⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ⴹⵗ ⴹⵢ ⴶⵜ ⵏⵢⵜ ⴹ ⵜⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⵍⵓⵆ ⴾⵍ ⴾⵓⵏⵙⴼⵔⴶⵏ ⴾⵙ ⵏⵎⵏⵓⵏ ⴹⵗ ⵓⴰ ⴹⵤⵢⵏ ⴾⵜⵏⵜ ⵜⴼⵔⴶⵎ ⴹⵜⵢ ⵜⵀⴹⴹⵎ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ⴼⵓ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵔⵏ ⵙ ⴶⴰ ⵂⴹ ⴹ ⴹⵓ ⴹⵗⵗ ⴶⵏ ⵙⵎ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ⴹ ⴼⵓ ⴹⵏ⵿ⵤⵢⵏ ⵢⵜⴹⵏ ⴾⵍ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵢⴹⵙⵙⵙⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ⵎⴹ ⵓⴰ ⴹⵗ ⵜⵜⵏ ⵢⵜⴹⵏ ⵛⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ ⴾⵢ ⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴶⵎⵢⵏ ⵜⵎⵔⴾⵙ⵿ⵜ ⵜⵙ ⵤⴶⵏ ⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵎⵛⵏ ⴾⵙⴹⵏ ⴹ ⵜⵏ⵿ⵗⵏ ⵌⵏⵌⵔⵓⵢ ⵓⵏ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ⴶⵤ ⵛⵢⵜⵏ ⵢⵂⵤⴰ ⵓⵙ ⵜⵓⵏⵓ ⵙⵈⵔⵢⵜⵢ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ⴶⵍⴰ ⴾⴰ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⴶⵤⵏⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵛⵓⵍ ⴹⵔⵙⵏ ⴹⵗ ⵀⵜⵓ ⵏⵎⴾ ⵓⵙ ⵤⴶⵓ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ⵙⴹⵓⵜⵏ ⵓⵏ⵰ ⵔⴹⵏ ⵙⴹ ⵜⴾⴼⵏ ⵤⵔⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ⵔⴹⵙⵏ ⵜⵤⵔ ⴹ ⴶⵎⵢ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵓ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ ⴹⵗ ⵎⵤⵢ ⵗⵔⵙ ⵓⵔ ⵜⵍⴰ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ⵙ ⴹⵓⴹ ⵤⵍ ⵏⵎⴹ ⵓⵏ ⵜⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵓⴰ ⴹⵗ ⵜⵓⴶⵤⵎⵏ ⵌⵗⵍ ⵓⵏ ⵎⴹ ⵓⵏ ⴾⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ⵤⵎⵤⵍ ⵗⵢⵙⴰ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵏⵙⵏ «ⴶⵍⵜ ⵜⵙⵎⵜⴶⵎⵏⵗ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵎⴹ ⵓⵏ ⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ⵏⵏⵙ «ⵎⵏⴹ ⵜⵔⵗ ⵜⵏⵙⵎⵜⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ⵏⵙⵏ «ⵙ ⴹⵏ⵿ⵜⴶⵤⵎ ⵗⵔⵎ ⴹ ⵜⵎⵏⵢⵎ ⴹⵍⵙ ⴹⴾⵜⵔⵏ ⵜⴾⵏⵜ⵰ ⵍⴾⵎⵜⵙ ⵙⵂⵏ ⵓⴰ ⵤⴶⵤ ");
INSERT INTO ttqt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ⵜⵏⵎ ⵢ ⵎⵛⵙ ⵏⵂⵏ ⵓⴹⵢ \"ⵏⴾ ⵛⵈ 'ⵎⵏⵢ ⵜⵓ ⴹⵗ ⵂⵏⴾ ⴹⴶ ⵓⵏ ⵏⴼ⵿ⵜⵗⵏ ⵓⴰ ⴹⵗ ⵤⴰ ⵏⵎⵏ⵿ⵙⵓ ⵏⴾ ⴹⵏⵜⵍⵀⵏ ⴹⵗ ⵎⴹ ⵓⵏ ⴾⵢ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ⴾⵓⵏⵙⴾⵏⵓ ⴹⵗ ⵙⵔⵏⵜ ⵂⵏ ⵓⵏ ⴼⵍⴰ ⵍⵓⵏ ⵂⵏ⵿ⵜⵓ ⵎⵜⴶ ⴾⵍ⵰ ⴹⵢ ⴹⴰ ⴹ ⵤⴰ ⵜⵙⵎⵜⴶⵎ ⵎⵏ⵿ⵙⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ⴶⵍⵏ ⵏⵢⵏ ⵔⵜ ⴾⵍ ⵙⵎⴾ ⵓⵙ ⴹⵙⵏ⵿ⵜⵏⴰ ⵗⵢⵙⴰ⵰ ⵜⵤⵔ ⴹ ⵙⵎⵜⴶⵏ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ⵙ ⴶⴰ ⵍⵓⵆ ⵏ⵿ⵜⵜⵢ ⵏⵗⵎⴰ ⵗⵢⵙⴰ ⴹⵏⵎⵤⵍⵏⵜ ⴶⵤⵏ ⵛⵏ ⵜⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ⵜⵤⵔ ⵏⵙⵏ «ⴾⵏⵗ ⴹⵔⵏ ⵏ⵿ⵜⴹⵔⵓⵜ ⵜⴰ ⴹⵔⵓⵏ ⴶⵗ ⵎⵏ⵿ⵙⵓⵏ ⵏⵎⴹ ⵓⴰ ⵂⵔⵓⴰ ⵓⵔ ⵗⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⴹⵍⴾⵎ ⵜⵏⵍⵙⴰ ⵜⵜⵢ ⴾⵜ ⵓⵔ ⴹⵙⴰ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⵏ⵿ⴹⵓ ⵍⵎⵗⵏⵏⵙⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ⵜⵤⵔ ⴹⴾⵍⴹⵓ ⵗⵢⵙⴰ ⵜⴾⵀⵔ⵿ⵜ ⵂⴰ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⵏⴰ «ⵀⵤⵜ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵜⵏⵎⴶⵍⵤⵎ ⵓⴰ ⵜⵜⵂⵏ ");
INSERT INTO ttqt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⵍⴾⵎ ⴹ ⵛⵓⵗ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⴾⵜ ⵓⵔ ⴹⵜⵙⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ⴹⴼⵔ ⵓⵏ ⴹⴾⵍ ⵗⵢⵙⴰ ⵜⴶⵍⴰ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵔⵤⵜ ⵤⵏⵙⵏ⵿ⵜⵜ ⵏⵙⵏ «ⵜⵗⵙⵏⵏ ⴹⵢ ⵜⵜⵓⴾⴼⵜ ⴼⵍ ⴹⵍⵍⵏⵓⵏ⵰ ⵜⵤⵏⵜⵜ ⵙ ⵜⵎⵓⵜ ⵜⴰ ⴹⴰ ⵎⵙ ⴹⵢ ⵙⴾⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⴰ ⵙ ⵙ ⵜⵛⵏ ⴹⴾⵍ ⵜⴾⵀⵔ⵿ⵜ ⵏⵙⵏ «ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵔⴾⵓⵍ ⵓⴰ ⵢⵏⵢⵏ ⵏ⵿ⵜⵙⵆ ⵜⵎⵙ ⴶⵔ ⵎⵛⵏⴰ ⴹⵜⵎⵜⵢⵏⵜ⵰ ⵔⴾⵓⵍ ⵓⴰ ⵤⵏⵏⵏ ⵤⵏ⵿ⵗⵍⵏ ⴼⵍ ⵜⵏ⵿ⴼⵏⵓⵏ ⵜⵙⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«ⴼⴹⴰ ⵏⵢⵜ ⵍⵙ ⵓⴰ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵍⴰ ⴹⴰ ⴹⴰ ⴹⵔⵓ ⴹⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ⵍⴾⵏ ⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵀⴰ ⵙ ⵜⵎⵓⵜ ⵜⴰ ⴹⵈⴾⵎ ⵎⵛⵏⴰ ⵂⵔⵓⴰ ⴹⵜ ⵍⵓⵆ ⵎⵛⵏ ⴾⵜ ⵍⵗⵤⵀ ⴹ ⵜⵏⵢ ⵓⴹⵏ ⵓⴰ ⴹⴶⵏ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ⵜⵤⵔ ⴹ ⵜⵏⵎⵙⵙ⵿ⵜⵏⵏ ⵏⵎⵤⵍⵏⵜ ⴶⵔⵙⵏ ⴹⵓⴰ ⴹⵗⵙⵏ ⵤⴶⵏ ⵓⵏ ⴹⵗ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ⴹⴼⵔ ⵓⵏ ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔⵙⵏ ⵜⴶⵜ ⴹⵗ ⵀⵜⵓ ⵏⵓⵙ ⵜⴼⵏ ⵙ ⵏ⵿ⵜⴰ ⴹⵗⵙⵏ ⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵏⴾⵍⵏ ⵏ⵿ⵜⵎⵜⵓⵏ ⵏⴹⵏⵜ ⵙⴾⵏⵏ ⵜⵔⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⵔⵏ ⵤⵎⵤⵍⵏ ⴼⵍⵙⵏ ⴹⵗ ⵍⵈⴾⵎⵏⵙⵏ⵰ ⵎⵛⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵜⴼⵏ ⵙ ⵎⴹⵂⵍⵏ ⵏⵢⵜⴹⵏ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ⵎⵛⵏ ⴾⵓⵏⵢ ⴹ ⵓⵔ ⵜⴶⵎ ⵓⵏ⵰ ⴾⵍⵔ ⵓⴰ ⴹⵗⵓⵏ ⴶⵔⵏ ⵍⵎⵆⵎ ⵆⵍⵜ ⵤⵏ ⵓⴰ ⴹⵗⵓⵏ ⵎⴹⵔⵢⵏ⵰ ⵓⴰ ⴹⵗⵓⵏ ⵤⵔⵏ ⵆⵍⵜ ⵤⵏ ⵎⵛⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ⵓⴾ ⵎⴰ ⴶⵔⵏ ⵓⴹⵏ ⵓⴰ ⵆⵎⵏ ⵜⵜⵓ ⴹⵓⴰ ⴹⵙⵛⵗⵍⵏ⵰ ⵓⵔⴶⵗ ⵓⴰ ⵆⵎⵏ ⵜⵜⵓ⵰ ⵎⵛⵏ ⵏⴾ ⵎⵙⵏ ⵎⵤⵔⵏⵓⵏ ⵂⵆⵓⵏ ⵎⵙⴰ ⵤⵏ ⵎⵛⵗⵍⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«ⴾⵓⵏⵢ ⵓⵏ ⴹⴰ ⴹⵆⵎⵏⵏ ⵜⵍⴾⵎⵎⵢ ⴹⵗ ⵌⵔⵀⵜⵏ ⵓⵏ ⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ⴹⵢ ⵙ ⵜⵂⴾⵢ ⵜⴰ ⴹⴶⴰ ⵀⵏⵏ ⵜⵗⵎⵔ ⵏ⵿ⵜⴰ ⴹⵓⵏ⵿ⵤⴶⴰ ⵢⵙ ⵏⴾ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ⴼⵍ ⴹⵔⵢ ⵜⴹⵔⵓⵎ ⵜⵜⵢ ⴹⵜⵙⵢ ⴹⵗ ⵜⵗⵎⵔⵏ ⵜⵆⵎⵎ ⴼⵍ ⵜⵙⵆⵎⴰ ⵏ⵿ⵜⵎⵏⴾⵍⴰ ⵢⴹ ⵜⵛⵔⵗⵎ ⵢ ⵜⵓⵛⵜⵏ ⵎⵔⵓⵜ ⴹⵙⵏⵜⵜ ⵛⵏ ⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«ⵙⵎⵗⵏ ⵙⵎⵗⵏ⵰ ⵏ⵿ⴾⴹ⵰ ⵛⵢⵜⵏ ⴶⵎⵢ ⵜⵔⴶⵜ ⵏ⵿ⴹⵓⵏⴶⵓ ⵙⴾⵏ⵿ⵙⴾⵢ ⵓⴰ ⵜⵓⴶⵏ ⵢⵍⴾⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ⵎⵛⵏ ⵏⴾ ⵏ⵿ⵙⵢⵗⴾ ⵎⵛⵏⴰ ⴼⵍ ⴾⵢⵓⵔⴶⵎⴹ ⵤⴶⵤⵏ ⵓⴰ ⵙⵔⵢ ⵜⴶⵗ⵰ ⵎⵔⵏ ⵙ ⴹⴹⵜⵆⵍⴰ ⵜⵙⵙⵂⵗ ⵤⴶⵤⵏ ⵏⵎⴹⵔⵢⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵎⵍⵢ ⵏⴾ ⵙⵎⵜⴶⴰ ⵙⴹⵔⴾ ⴹⵓⴰ ⴾⴹⵗ ⵙ ⴾⵙⵓ ⴹⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⵀⵜⵔⵙ ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⵔ ⵤⵗⵔⵓ ⴾⵌⵢ ⵗⵔⴰ ⵂⴹⴰ ⴹⴰ ⵓⵔ ⴹⵜⴶⴹⴰ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵎⵤⵍⵏⵜ ⴾⵜⵏⵙⵏ «ⵍⵓⵆ ⵓⴰ ⴾⵓⵏ⵿ⵤⵎⵤⵍⴰ ⵓⵔ ⵜⵓⵢⵎ ⵤⵔⴼ ⵓⵍⴰ ⵗⵔⴶ ⵓⵍⴰ ⵜⵙⵙⵍ⵿ⵜ ⵜⵏ ⵙⵏⵜⵜ ⵓⴾ ⵍⵢ ⵔⵜ ⴹⵏ⵿ⵜⴹⵏⵎ⵰» ⵏⵏⵙ «ⴾⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ⵏⵙⵏ «ⵎⵔⴹⴰ ⵤⴰ ⵓⴰ ⵍⵏ ⵤⵔⴼ ⵓⵢⵜⵓ ⵓⴰ ⵍⵏ ⵗⵔⴶ ⵓⵢⵜⵓ⵰ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵜⴾⵀⴰ ⵤⵏ⵿ⵤⵜⵏ ⵀⵔⵏⵤⵏⵜ ⵤⵏ⵿ⵤⵜⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴰ ⴼⵍⵢ ⵜⵓⵏⵏ ⴹⵗ ⵍⴾⵜⵀ ⵏⵎⵛⵏⴰ ⵏⵙ \"ⴹⵏ ⴹⵗ ⵎⴶⵏ ⵏ⵿ⵜⴾⵎⴰ⵰\" ⴾⵏ⵿ⴹⵀⴰ ⵏ⵿ⴹⴰ⵰ ⵓⵍⴰ ⵔⵜ ⴾⵍ ⵓⴰ ⴼⵍⵢ ⵜⵓⵏⵏ ⴹ ⵏ⵿ⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ⵏⵏⵙ «ⵎⵍⵢ ⵙⵏⵜⵜ ⵜⴾⵀⵓⵏ ⴹⴰ⵰» ⵏⵙⵏ «ⵢⵜ ⵀⵜⵓ ⴹⵢ ⵓⵔ ⴹⵜⴶⵔⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ⴶⵎⴹ ⵗⵢⵙⴰ ⴹⵓ ⴹⵏⵜⵍⵀⵏⵜ ⴾⴰ ⴹⵗⵗ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⵜⴶⵓ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ⵙ ⴹⵏⵓⴹⵏ ⵏⵙⵏ «ⵏ⵿ⵙⵢⵜ ⵎⵛⵏⴰ ⴾⵓⵏⴶⵤⵏ ⴹⵗ ⵌⵔⵀⵜⵏ ⵏⵀⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ⵏ⵿ⵜⴰ ⵎⵔⵏ ⵤⵏ⵿ⴾⵤⵏ ⴼⵍⵙⵏ ⴹⴾⴹ ⵏ⵿ⵜⴶⵔ ⵏ⵿ⵜⵂⵏ⵿ⵜ ⴶⵔⴼⵜ ⴹ ⵜⵜⵔ ");
INSERT INTO ttqt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ⴶⵏⵓ «ⵀⴰ ⴾⴹ ⵎⴾⵏ ⴹⵢ ⵜⵙⴶⴶⵗⵢ ⵜⴾⵀⵔ⵿ⵜ ⵜⵏ ⵍⵗⵤⵀ ⴹⵢ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴶⵜ ⵜⵔⴰ ⵜⵏⴾ ⵓⵔⴶⵗ ⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ⵎⵔⵏ ⵏⴼⵍⵍⵙ ⵏ⵿ⴶⵍⵙ ⵢⴹ ⵜⵙⵙⵂⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ⵜⵤⵔ ⴹⴶⵤⵏ ⵎⵏ ⵗⵢⵙⴰ ⴹⴶⵤ ⵓⵍⵏ ⴹⵗ ⵜⵓⵜⵔⵓⵏ ⵂⵔ ⵜⵆⵍ ⵜⵔⴼ⵿ⵜⵏⵜ ⵛⵍⵜ ⵏⵤⵏⵢ ⴹ ⵜⵜⵜⵀ ⴹⵗ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ⵙ ⵗⵔⴹ ⵛⵓⵜⵔⵓⵏ ⵀⴹⴹ ⵆⵍⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵙⵏ⵿ⴹⵓ ⵙⵏ⵿ⵙⵏ ⵗⵛⴹ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ⵏⵙⵏ «ⵎⴼⵍ ⵜⵏ⵿ⵙⵎ⵰ ⵏ⵿ⴾⵔⵜ ⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴾⵓⵏⴶⵤⵏ ⴹⵗ ⵌⵔⵀⵜⵏ ⵏⵀⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ⵂⵔⵓⴹⴰ ⵛⵓⵍⵙⵏ ⵙ ⵜⵏ⵿ⵜⴶⵤ ⵜⵎⵜⵢ ⵜⴶⵜ ⵙ ⵤⵔ ⵢⵂⵤⴰ ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ⵂⵤⴹⵓ ⵢⵂⵤⴰ ⵗⵢⵙⴰ ⵢⴹ ⵜⵤⵍⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ⵎⵛⵏ ⵏⵙ ⵗⵢⵙⴰ «ⴹⵙ ⴾⵢ ⵢⵂⵤⴰ ⵜⵤⵍⵎⵜ ⵙ ⴹⵤⵜⵙⵙⴶⴰ ⴹⵗ ⴼⵙⵏ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ⵙ ⵏⵢⵏ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ ⵓⴰ ⵀⴾⵏ ⵢⴶⵢ ⴹⴰ ⵏⵏ «ⵎⵍⵢ ⵎⴰ ⵆⵍ ⵏⵛⵛⵗⵍ ⵛⴾⵀⵓⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ⵜⵤⵔ ⵓⵜ ⵢⵏ ⴹⵗⵙⵏ ⴾⵍⵢ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴼⵔⵙⴹⵓ ⵜⵎⵤⴾⵏⵜ ⵜⵏ ⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ⵎⵛⵏ ⵂⵔⵛⵜⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵢⵜ ⴹⵢ⵰» ⵜⵤⵔ ⴹⵙ ⵜⵎⵤⴾ ⵏⴾⵍⵢ ⵓⵏ ⵤⵤⵢⵜⵜ ⵜⵆⵍ ⵎⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ⵎⵔⵏ ⵏⴰ ⵢ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵤⵏⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙ ⴾⵜⵏⵙⵏ ⵙⵏ⵿ⴹⵓ ⵢⴹ ⵜⵀⵤⵏ «ⵓⴾ ⵌⵌⵀ ⵢⵏ ⵏⵀⵢⴹⴶ ⵎⵙⴰ ⵙ ⵙⵔⵢ ⴹⵜⵓⵢⵎ ⵛⴾⵀⵓⵏ ⴹⵜⵀⵔⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ⵓⵔⴶⵗ ⵤⵍ ⴾⵍ ⵔ⵿ⵜⵢⴰ ⴹⵔⵓⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵛⵏ ⵓⵔ ⴹⵜⵀⵤⵎ⵰ ⵎⵔⴹⴰ ⵤⴰ ⵍⵓⵆⵏⵓⵏ ⴹⵓⴹⵏ ⴾⵓⵏⵢ ⴹⵜⵗⵎⵔ ⵜⵏ ⵀⵍⵙ ⴹⵛⵢⵢⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ⵜⵤⵔ ⵀⵤⵏ ⵗⵢⵙⴰ ⵓⵢⵏ⵿ⵜⵓ ⵙⵗⵢⵓⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰ ⴶⵙⵏ ⵀⵜⵔⵙ ⵍⴾⵎ ⵤⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ⵙ ⴹⵏⵙⵏ ⵜⵜⵓⵙⵔⵗⴰ ⵜⵎ⵿ⵙⵢ ⴹⵗ ⵎⵙ ⵏⵗⵍⴰ ⵆⵎⵏ ⵙⵔⵙ ⵢⵜⴹⵏ⵰ ⴶⵤⵜⵏⵏ ⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ⵜⵏⵢⵜⵓ ⵜⵎⵛⵗⵍ⵿ⵜ ⵢⵜ ⵆⵎ ⵙ ⵜⵎ⵿ⵙⵢ ⵜⵤⴶⵤⴹⵢ ⵓⵍⵏ ⵎⵔⵏ ⵜⵏⴰ «ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵓ ⴹⵗⵢⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ⵎⵛⵏ ⴶⴹ ⵀⵜⵔⵙ ⵓⵏ ⵏⴰ «ⵜⵏ⵿ⵜⵜ ⵓⵔ ⵜⵤⴹⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ⵔⵜ ⵏⵎⵤⵢ ⴹⴼⵔ ⵓⵏ ⵏⵢⵜⵓ ⵢⵏ ⵓⴹⵏ ⵏⵙ «ⴾⵢ ⴹⴰ ⵢⵏ ⴹⵗⵙⵏ⵰» ⵎⵛⵏ ⵏⵙ ⵀⵜⵔⵙ «ⵈⴰ ⵍⵙ ⵓⴰ ⴾⵍⴰ ⵓⵔ ⵜⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ⵙ ⴶⴰ ⴹⴶ ⵏⵍⵓⵆ ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵍⵙ ⵢⵏ ⵙⵙⵂⵜ «ⵍⴾⵏ ⵙ ⵍⵙ ⵓⴰ ⴹⵓ ⴹⵔⵙ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ⵏⵙ ⵀⵜⵔⵙ «ⵈⴰ ⵍⵙ ⵓⵔ ⵙⵏⵗ ⵓⴰ ⴹⵗⵢ ⵜⵛⵓⵍⵗ⵰» ⵂⵔⵓⴰ ⴹⴰ ⵛⵓⵍ ⵀⵜⵔⵙ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵙ ⵗⵔⴰ ⴾⵌⵢ ⵗⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ⵜⵤⵔ ⵎⵍⵍⵢⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⵙⵓⴹ ⴹⵗ ⵀⵜⵔⵙ⵰ ⴹⵏ ⴹⴰ ⴹⴾⵜⴰ ⵀⵜⵔⵙ ⵓⵍ ⵓⴰ ⴹⵙⴶⴰ ⵎⵍⵢ ⵙ ⴹⵙⵏⴰ «ⵓⵔ ⵤⵗⵔⵓ ⴾⵌⵢ ⵗⵔⴰ ⵤⵍⴹⴰ ⵓⵔ ⴹⵜⴾⵙⵗ ⵜⵤⴹⵢⵜ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ⵜⵤⵔ ⴶⵎⴹ ⵀⵜⵔⵙ ⴹ ⵂⵍⵓ ⴼⵍ ⵓⴰ ⴶⵏ ⵎⵏⵜ ⴹⵗ ⵗⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ⵍⵓⵆ ⵓⵏ ⵎⴹⵏ ⵓⵏ ⵜⴼⵏⵏ ⵗⵢⵙⴰ ⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ ⴶⵜⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ⴶⵏⵙ ⵀⵏⵀⵏ ⴹⵙⴶⵏⵏ «ⴾⵢ ⵢⴰ ⵍⵓⵍⵢ⵰ ⵎⵍ ⵓⴰ ⴾⵢⵓⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ⴹⵙ⵿ⵜⴶⵏ ⵀⵜⵜⵏ ⵛⵢⴹ ⴶⵜⵏⵏ ⵍⵀⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ⵙ ⴼⵓ ⵗⵔⴰ ⵎⵏⵢ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵂⵏ⵿ⵜⵓ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵜⵓⵙⵀⴹⴹ ⴹⵜⵙⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ⵏⵏⵙ «ⴾⴹ ⴾⵢ ⵍⵎⵙⵈ ⵜⵎⵍⵗⵏⴰ⵰» ⵜⵤⵔ ⵏⵙⵏ «ⴾⴹ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵓⵔ ⴹⵤⵜⵤⴶⵤⵏⵎ ");
INSERT INTO ttqt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ⴾⴹ ⴾⵓⵏⵙⵙ⵿ⵜⵏⴰ ⴹⵗ ⵓⵔ ⴹⵤⵜⵌⵓⵀⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ⵎⵛⵏ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹ ⵆⵎⴰ ⴹⵗ ⵗⵍ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵢ ⵏ⵿ⵜⵔⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ⵏⵏⵙ ⴾⵜⵏⵙⵏ «ⴹⵗ ⴹⵢ ⴾⵢ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰» ⵏⵙⵏ «ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵙ ⵜⵏⵎ ⵎⵙⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ⵜⵤⵔ ⵏⵏ «ⵎⴰ ⵏⴾⴰ ⵢⵢⵜ ⵜⴶⵢⴰ⵰ ⵓⵔⴶⵗ ⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵏⵙⵍⴰ ⵢⵓⴰ ⴹⴶⵎⴹⵏ ⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ⵜⵏ⵿ⴾⵔ ⵍⵌⵎⵗⵜ ⴾⵜⵏⵜ ⵜⵓⵢ ⵗⵢⵙⴰ ⵙ ⵀⵍⵜⵙ ⵓⵏ ⵏⵈⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ⵗⵔⵙ ⵜⵗⵜⵙⵏ ⴶⵏⵏ «ⵍⵙ ⵓⴰ ⵙ ⵜⵏⵙⴰ ⵙⵈⵔⴾ ⵜⵎⵜⵢⵏⵏⴰ⵰ ⴶⴹⵍ ⴹⵗ ⵢⵢⵜⴹⵏ ⴹ ⵔⵤⵎⵏ ⵎⵏⴰ ⵢ ⵆⵢⵙⵔⴰ ⵓⵏ ⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵂⵔⵓⴰ ⴶⵏⵓ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵎⵏⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ⵓⵏ ⴹⴰ ⴼⵍ ⵜⵙⵙ⵿ⵜⵏ ⵀⵍⵜⵙ ⵏⵙ «ⵓⴾ ⴾⵢ ⴹⵗ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ⵏⴰ ⵀⵍⵜⵙ ⵢ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵜⵎⵜⵢ «ⵓⵔ ⵂⵏⵢⵗ ⴹⵍⵍ ⵓⵍⵢⵏ ⴼⵍ ⵀⵤⵗ ⵍⵙ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ⵎⵛⵏ ⴹⴶⵤⵏ ⵓⵍⵏ ⴹⵗ ⵜⵗⵜⵙⵏⵜ ⴶⵏⵏ «ⵌⵏⵌⵔⵓⵢ ⵢⵜⴹⵏ ⵙ ⵙⵙⵗⵔⵜⵏⵜ ⴹⵗ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴾⵜⵏⵜ⵰ ⵙⵏ⵿ⵜⴹⵓ ⵓⵏ ⴹⵗ ⴶⵍⵍⵢⴰ ⵂⵔ ⵓⵙ ⴹⵓⴹ ⵢⵔⵙⵍⵎ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ⵙⵍⴰ ⵀⵍⵜⵙ ⵢⵙⵎ ⵓⵏ ⴶⵍⵍⵢⴰ ⵗⵙ ⵙⵙ⵿ⵜⵏ ⴾⴹ ⵗⵢⵙⴰ ⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ⵙ ⵙⵏ ⵙ ⵜⵗⵎⵔ ⵜⵏ ⵂⵔⴹ ⴹⵙ⵿ⵜⵤⵔⵜ ⵙⴾⵙ⵿ⵜⵓ ⴼⵍⵙ ⵂⴰ ⵢⵔⵙⵍⵎ ⴹⵗ ⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ⵂⵔⴹ ⵙⴹⵓⵜⵓ ⵓⵍⵏ ⵏⵢ ⵏ⵿ⵗⵢⵙⴰ ⵔⵓ ⵔⴰ ⵏⵢⵏⵜ ⴼⵍ ⴹⵍⵍ ⵏⵔⵜⵏ ⵓⵏ ⵙⵔⵙ ⵙⵍⵓ⵰ ⴶⴰ ⴹⵗ ⵜⵎⴰ ⵏ⵿ⴹⵜⵙ ⴶⵓ ⵗⵢⵙⴰ ⵜⵍⵎⵗⵌⵌⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ⴶⵙ ⵙⵙ⵿ⵜⵏⵏ ⴶⵜⵏⵏ ⵎⵛⵏ ⵓⵔ ⴹⵙⵏⴰ ⵗⵢⵙⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⵍⵏ ⴹⵏ ⵙⵗⵔⵏ ⴹⴰ ⵜⵗⵜⵙ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ⴹⵙⵜⴶⵓ ⵂⵔⴹ ⴹⵙⵌⵜⵏⵜ ⵛⵙⵙⵍⴾⴰ ⵜⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ⵰ ⵤⵤⵍⴶⵏ⵿ⵜⵓ ⵜⴾⵜⴾⵜ ⵜⴾⵏⵜ ⵀⵍⵤⵍⵤ ⵎⵔⵏ ⵙⵗⵍ⵿ⵜⵓ ⵂⵔⴹ ⵢ ⵀⵍⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ⵓⵢⴹⵓ ⵓⵏ ⵤⵍ ⵓⵏ ⴹⴰ ⵙ ⵎⴹⵓ ⵀⵍⵜⵙ ⴹⵂⵔⴹ ⴹ ⴹⵜ ⵓⵏ ⵏⵎⴶⵤⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ⵛⴹⵓⴹⵓ ⵀⵍⵜⵙ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵜⵎⵜⵢ ");
INSERT INTO ttqt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ⵏⵙⵏ «ⵜⵓⵢⵎⴹⵓ ⵙⵔⵢ ⵍⵙ ⴰ ⵜⵏⵎ ⵙⴼⵍⴶ ⵢⵜⴹⵏ⵰ ⵛⵔⵗⵗⵙ ⴹⵜⵓⵏ ⵎⵛⵏ ⵓⵔ ⵏⵢⴰ ⴹⵍⵍ ⵓⵍⵢⵏ ⴼⵍ ⵜⵀⵤⴰ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⵜⵜⵙⵓⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ⵓⵍⴰ ⴹⵗ ⵏⵢⵜⵓ ⴹⵗⵙ ⵂⵔⴹ ⴼⵍⵙ ⵙⵗⵍⵏⵆⴹ⵰ ⵎⵔⵏ ⵏⵢⵜ⵰ ⵍⵙ ⵓⴰ ⵓⵔ ⴶⴰ ⵔⵜ ⵓⵍⵢⵏ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ⴹⵗ ⴹⵢ ⴹⵙⵙⴶⴰ ⵛⵓⵜ ⵎⵔⵏ ⵢⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ⵜⵍⵢ ⵍⵗⴹⵜ ⵜⵎⵙⵜ ⵙ ⵢ ⴹⵗⵍⵢ ⵎⴹ ⵓⵏ ⴾⵢ ⵓⵔ ⵀⵍⵜⵙ ⴹⵙⵏⴾⵙ ⵓⴹⵏ ⵢⵏ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ⵌⵌⵢⵏ ⴹⴾⵍ ⵏⵎⵙⵍⵏⵙⵏ ⴾⵜⵏⵙⵏ ⴹⵗ ⵌⵏⵓⵏ ⴶⵏⵏ «ⴶⵓ ⵎⵏ ⵏⵍⵙ ⴹⵢ ⵜⴾⵙⵗⵏⴹⵓ ⵀⵔⵗⵀⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ⵀⵔⵗⵀⵙ ⵓⵏ ⵏⵌⵔⵓⵢ ⵙ ⴾⵍⴰ ⴹ ⵜⴶⵏ ⵢⵜⴹⵏ ⴹⵗ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴹⴶⵢ ⵏⵎⵏ ⵏⵓⴹⵏ ⴼⵍ ⴶⵤ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ⵍⵙⵙⵏ ⵀⵍⵜⵙ ⵓⵍ ⴼⵍⵙ ⵜⵔⴰ ⴶⴰ ⴹ ⵢⵓ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ⵎⵛⵏ ⴶⵍⵏ ⵙⵗⵔⵏ ⴹⵗ ⵌⵏⵓⵏ ⴶⵏⵏ «ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ⴶⵙⵏ ⵀⵍⵜⵙ ⵜⵏⴰ ⵜⵏ ⴾⵔⴹⵜ «ⵎⴼⵍ ⵤⴰ⵰ ⵎⴰ ⵗⵛⴹ⵰ ⵓⵔ ⵂⵏⵢⵗ ⴹⵍⵍ ⵓⵍⵢⵏ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴹⵗ ⴹⵢ ⴹⵙⵙⴶⴰ ⵛⵓⵜ ⵗⵙ ⵢⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ⵎⵛⵏ ⵛⵜⵏ ⵛⵗⵔⵜⵏ ⵓⵍⵏ ⴶⵎⵢⵏ ⴹⵗⵙ ⴹ ⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵗⵍⵀⵏ ⵀⵍⵜⵙ ⵙ ⵜⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ⵜⵤⵔ ⵈⵜⵙ ⵀⵍⵜⵙ ⵢ ⵗⵢⵙⴰ ⵛⵔⵗⴰ ⵓⴰ ⴹⵗⵙ ⵜⴶⵎⵢ ⵜⵎⵜⵢ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ⴾⵙ ⵍⵙ ⵓⴰ ⴹⵗⵙ ⴶⵎⵢⵏ ⴶⵤⵏ ⴾⵙⵓ ⴼⵍ ⵏⵌⵔⵓⵢ ⵏⵢⵜⴹⵏ ⴹⴶⵢ ⵏⵎⵏ ⵏⵓⴹⵏ⵰ ⵗⵢⵙⴰ ⵎⵔⵏ ⴶⵢ ⴹⵗ ⴼⵙⵏⵙⵏ ⵢⴹⵗⵙ ⵜⵓⵈⴾⵎ ⵓⵙ ⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ⵤⵔⴶⵤⵏ ⵙⵌⵜⵏ ⵗⵢⵙⴰ⵰ ⴶⵍⵏ ⴹⵔⵙ ⵙ ⵎⵏⵢⵏ ⴹⵍⵙ ⵢⵏ ⵏⵗⵔⵎ ⵏⵆⵔⵓⵏ ⴶⵏ ⵙⵎ ⵙⵎⵗⵏ ⴹⴼⵍⵏ ⵛⵓⴶⵙ ⵜⵤⵔ ⵀⵤⵏ⵿ⵜⵓ ⵙⵙⵓⵢⵏ⵿ⵜⵓ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵤⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ ⵍⴾⵎⵙ ⴹⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⵂⵏⵜ ⵜⴹⴹⵏ ⴶⵜⵏⵏ ⴼⵍⵙ ⵂⵍⵏⵏ ⵙⴾⵍⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ⵙⵓⴹⵏ ⴹⵗⵙⵏⵜ ⵗⵢⵙⴰ ⵏⵙⵏⵜ «ⵛⵜ ⵢⵔⵙⵍⵎ ⵢⵎⵜ ⴼⵍⵢ ⵜⵍⴰ⵰ ⴾⵍⵔ ⵍⵎⵜ ⴼⵍ ⵎⵏⴾⵎⵜ ⴹⵎⴹⵏⴾⵎⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ⴼⵍⵙ ⵍⴾⵎⵏ ⴹⵏ ⴹⵗ ⵤⵜⵓⵏⵓ \"ⵀⵍⵍⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⵓⵔ ⵏⵜⵍⵓ ⵀⵔⵔⵏ ⴹⵛⵏ ⵙ ⴾⵍⴰ ⵓⵔ ⵜⵏⵍⵏⵜ ⴹⵛⵏ ⵙ ⴾⵍⴰ ⵓⵔ ⵙⵏ⵿ⴾⵙⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ⴹⵏ ⵓⵏ⵿ⴹⵢ ⴹ ⵏⵏ ⵢⵜⴹⵏ ⵢⴹⵗⵗⵏ \"ⵀⵔⵌⵜⵜ ⴼⵍⵏ\" ⵏⵏ ⵢ ⴾⵛⵓⵔⵏ \"ⵍⵙⵓⵜⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ⴼⵍⵙ ⴹⴹ ⵜⵓⴶⴰ ⵎⵤⵍ ⵓⴰ ⵢⵛⴾ ⵓⴰ ⵀⴹⴶⵏ ⵓⴹⵢ ⵎⴰ ⴹⵏⵢⵏ ⵓⴰ ⵆⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ⵍⵏ ⵎⴹⵏ ⴹⵏ ⵛⵏ ⵏⵙⴶⴼⴰ ⵍⵀⵙⵏⵏ ⵙⵏ⵿ⵜⵏⵢ ⴹⴰ ⵜⵓⵤⵔⴶⵤⵏ ⵙⴹⴶ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ⵙ ⵓⴹⵏ ⵙⵌⵜⵏ ⴹⴶ ⴶⵏ ⵙⵎ ⵜⴾⵢⴰ ⵜⵢⵜⵢⵏ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⵙⵗⵜⵏ⵿ⵜⵜ ⴹⵔⵙ⵰ ⴶⵏ ⵓⵏ ⴹⴰ ⵢ ⵎⴹⵏ ⵓⵏ ⵛⵏⵏ⵰ ⵢⵏ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵗⵍ ⵏ⵿ⵗⵢⵙⴰ ⵓⴰ ⵂⴹⵏ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵤⵍⴶⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ⵏⴰ ⵗⵢⵙⴰ «ⵢⴰ ⵀⴰ ⵙⵔⴼⵙⵏ⵰ ⵓⵔ ⵙⵏⵏ ⵓⴰ ⵜⴶⵏ⵰» ⵤⵏⵏ ⵜⵀⴹⵆ ⵏ⵿ⵗⵢⵙⴰ ⵙ ⵜⵛⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ⵜⵎⵜⵢ ⵜⵀⴹⴹ ⴹⵏ ⵜⵙⵓⴹ⵰ ⵎⵤⵔⵏ ⵎⵔⵏ ⴶⵏ ⵜⵎⴾⴾⵢⵜ ⴹⵗ ⵗⵢⵙⴰ ⴶⵏⵏ «ⵏ⵿ⵜⴰ ⵓⴰ ⵙⴼⵙⵏ ⵢⵜⴹⵏ ⵙⴼⵙⵜ ⵎⵏⵜ ⴾⴹ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵜⴼⵔⵏ⵿ⵜ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ⵙⵌⵜⵏ ⴹⴰ ⴶⵏ ⴹⵗⵙ ⵜⵎⴾⴾⵢⵜ⵰ ⵜⵂⵤⵏ⵿ⵜⵏ ⵜⵤⵍⵏⵙⵏ ⵀⵏⴶⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ⴶⵏⵏⵙ «ⴾⴹ ⴾⵢ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵎⵙⵗ ⵜⵙⴼⵙⵗ ⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ⵜⵢⵜⵢⵏ ⴹⵗ ⴹⵏⴶⵙ ⵙⵍⵎ ⴼⵍ ⴾⵜⵀ ⵙ «ⵓⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ⴹⵙⵜⴶⵓ ⵢⵏ ⴹⵗ ⵎⴹⵏ ⵏ⵿ⵌⵌⵀ ⵏⵀⵢⴹⴶⵏ ⵓⵏ ⴹⴶⵎⵏⵙ ⵜⵓⵜⵢⵜⵢⵏⵏ ⵔⴾ ⵀⵜⵜⵏ ⴶⵏⵙ «ⵓⵔⴶⵗ ⴾⵢ ⵍⵎⵙⵈ⵰ ⵙⴼⵙⵓ ⵤⴰ ⵎⵏⴾ ⵜⵙⴼⵙⵗⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ⵙⵏⵔⵗⵎⵙ ⵓⴰ ⵂⴹⵏ ⵏⵙ «ⴾⵢ ⵜⴾⵙⴹⴰ ⵓⵔ ⵜⴶ ⵎⵛⵏⴰ ⴾⵢ ⵓⴰ ⵀⵤ ⵛⵔⵗⴰ ⵎⵙⵏ ⵜⵎⵜⵏ⵿ⵜ ⵓⴰ ⵜⵀⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ⵏⴾⵏⵢ ⵛⵔⵗⴰ ⵓⴰ ⴹⵏⵗⵜⵓⴶⵏ ⵗⴹ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⵍⵏⵏⴰ ⴹⵏⵗⵜⵓⵈⴾⵎⵏ ⵎⵛⵏ ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⵓⵔ ⴶⴰ ⵔⴾ ⵎⵤⵍ ⵓⵍⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ⵜⵤⵔ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵗⵢⵙⴰ ⴾⵜⵓⴹⵓ ⵙ ⴹⵜⵆⵍⴰ ⵜⵂⵗ ⵜⵗⵎⵔⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵤⵍⴹⴰ ⴹ ⵏⵏⵎⴶⵤ ⵍⵌⵏⵜ ⵏⴾ ⴹⵔⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ⵓⵏ ⵜⴶⵓ ⵜⵢⵏ ⵏⵎⵙⵏⵤⵍ⵰ ⵜⵤⵔ ⵍⵙⵏⵜ ⵛⵢⵢ ⵎⴹⵍ ⴾⵜⵏⵜ ⵂⵔ ⵜⴶⴰ ⵜⵤⵔ ");
INSERT INTO ttqt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ⴼⵍⵙ ⵜⴼⴾ ⴶⵎⴹ ⵏⵔ⵰ ⴼⵔ ⴹⵗ ⵓⴰ ⵤⵎⵤⵢⵏ ⴹⴶ ⵓⴰ ⵤⴹⴶⵏ ⴹⵓⴰ ⴶⵔⵏ ⵜⵤⴹⴾ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵤⵔⵜ ⴹⵗ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ⵜⵤⵔ ⴾⵙ ⵗⵢⵙⴰ ⵎⵙⵍⵢ ⵙⵂⵏ ⵏⴰ «ⵀⴰ ⴶⵗ ⵎⵏⵏ ⴶⵔ ⴼⵙⵏⴾ⵰» ⵏⴰ ⵓⵏ ⵗⵙ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ⵙ ⵏⵢ ⴾⵀⵜⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⵓⵏ ⵜⵢⵜⵢⵏⵏ ⵗⵢⵙⴰ ⵓⴰ ⴶⵏ ⴹⵏ ⴶⴰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⵎⵔⵏ ⵏⴰ «ⵍⴾⵏ ⵙ ⵍⵙ ⵓⴰ ⵍⵗⴹⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ⴹⵓⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵏ ⵢⴹ ⵏⵢⵏ ⵓⴰ ⵤⴶⵏ⵰ ⵙ ⵜⵏⵢⵏ ⵆⵍⵏ ⴶⵜⵏ ⴹⵎⵔⵏⵙⵏ ⴼⵍ ⵓⴰ ⴶⵏ ⵎⵏⵙⵏ ⴹⵗ ⵗⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⴹⵓⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⵍ ⵂⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⴹⵙⴹⵍⴾⵎⵏⵏ ⵂⵔⵓⴰ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵀⴹⴹⵏ ⵙⴹⵢ ⵙⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ⵍⵢ ⵍⵙ ⴶⵏ ⵢⵙⴼ ⵂⵏ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵎⵙⵏ ⵓⴹⵏ ⵍⵗⵏ ⵏⵍⵗⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ⵏ⵿ⵜⴰ ⵓⵔ ⵔⴹⴰ ⵙ ⵜⵏⵜ ⵜⴰ ⴶⵏ ⵎⵤⵔⵏ ⵓⵏ ⵓⵍⴰ ⴹⵗ ⵙⵔⵜ ⵓⴰ ⴶⵏ⵰ ⵢⵙⴼ ⵓⴰ ⵏ ⵗⵔⵎ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵙⵎ ⵔⵎⵜⵢ ⵎⵔⵏ ⴶⴰ ⵜⵎⵏⵜ ⴹⵗ ⵙⴰ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ⴾⴰ ⵢⵙⴼ ⵀⵍⵜⵙ ⵓⵏ ⵏⵈⴾⵎ ⵏⴾⵍ ⴶⵔⵓⴹⵓ ⵗⵔⵙ ⵜⵔⴶⵜ ⵏⴹ ⵜⴾⵍ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ⵜⵤⵔ ⴾⵙ⵿ⵜⵜⴹⵓ ⴼⵍ ⵜⴶⵜⵓⵜ ⴶⵜ ⴹⵗ ⵛⴼⵜ ⴶⵜ ⴹⵗ ⵤⴾⴰ ⵎⵙⵏ ⴾⵤⵎ ⵙ ⵓⵔ ⴾⵍⴰ ⴹⵗⵙ ⵜⵓⴶⴰ ⵏⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ⵓⵏ ⵜⴶⵓ ⴹⵗ ⵤⵍ ⵓⴰ ⴹⵗ ⵙⵎⵜⴶⵏ ⵢⵜⴹⵏ ⵢⵎⴹ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵀⴾⵏ ⵢⵏⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ⵛⴹⴹⵏ ⵛⵏ ⴹⴹⵓⵏⵏ ⴹⵗⵢⵙⴰ ⵂⵔⵓⴰ ⴹⵗ ⴶⵍⵍⵢⴰ ⵍⴾⵎⵏⵜ ⵢ ⵢⵙⴼ⵰ ⵏⵢⵏⵜ ⵤⴾⴰ ⴹⵎⴾ ⵓⵙ ⴹⵗⵙ ⵜⵜⵓⴶⴰ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ⵆⵍⵏⵜ ⵗⵢⵓⵏ ⵜⵤⵔ ⴹ ⵙⵎⵜⴶⵏⵜ ⴹⵜⵏ ⵤⴹⵏⵏ ⴹⵍⵓⵔⴹⵜⵏ ⵓⵏ ⵤⴰ ⵜⵓⵏ⵿ⵗⵍⵏⵏ ⴼⵍ ⵜⵗⵙⵏⵜ⵰ ⵙ ⴹⵓⴹ ⵤⵍ ⵓⵏ ⵙⵀⵜ ⵙⵏ⵿ⴼⵏⵜ ⵎⵙ ⵓⵏ ⵍⵓⵌⵀ ⵏⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ⵙ ⵤⵍ ⵓⵏ ⵍⵈⴹ ⵏ⵿ⵤⵢⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⴹⵏ ⵙⵤⴾⴰ ⵏ⵿ⵗⵢⵙⴰ ⵓⵢⵏⵜ ⴹⵜⵏ ⵓⵏ ⵙⵎⵜⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ⵙⵏⵜⵏ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⵂⵔⵜ ⵤⴾⴰ ⵜⵜⵓⵙⵗⵔⵔⴹ ⵜⵍⴰ ⴹⵏ ⵢⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ⴶⵤⵏⵜ ⵤⴾⴰ ⵎⵛⵏ ⵓⵔ ⴹⵗⵙ ⵏⵢⵏⵜ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ⵆⵏⵏ ⵗⴼⵓⵏⵙⵏⵜ ⵢⵓⵏ⵰ ⵓⵍⴰ ⵂⴶⵏ ⵀⴹⴹⵏ⵿ⴹⵓ ⵛⵏ ⵎⴹⵏ ⴹⴶⵎⵏⵙⵏⵜ ⵍⵙⵏⵏ ⵙⵍⵙⴰ ⵀⵍⵤⵍⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ⵔⵎⵗⵏⵜ ⵢⵏⵜ ⴹⵎⵔⵏ ⵙⵎⴹⵍ ⵜⵤⵔ ⵏⵏⵙⵏⵜ ⵎⴹⵏ ⵓⵏ ⵛⵏ ⵏ «ⵎⵙ ⵜⵙⴶⴹⵎⵜ ⵢⵢ ⴹⵔⵏ ⴹⵗ ⵏⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ⵀⵙ ⵍⴰ ⴹⴰ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴾⵜⵎⵜⴹⵓ ⵓⴰ ⵏⴰ ⵂⵔⵓⴰ ⵂⴰ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ⵙ ⵏⴰ \"ⴶ ⴶⴹⵎ ⵍⵤⵎ⵿ⵜⵓ ⴹ ⵜⵓⴶⵓ ⴹⵗ ⴼⵙⵏ ⵏⵙⵀⴾⴹⵏ ⵜⵓⵜⵢⵜⵢ ⴼⵍ ⵜⴶⵜⵓⵜ ⵀⵜⵓ ⵜⵤⵔ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ⵎⵔⵏ ⴾⵜⵏⵜⴹⵓ ⵓⴰ ⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ⴼⵍⵏⵜ ⵤⴾⴰ ⵆⵍⵏⵜ ⵙⵗⵍⵏⵜ ⵓⵏ ⴾⵍ ⵢ ⵏⵎⵤⵍ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ ⴹⵏⵍⴾⵎⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ⵛⴹⴹⵏ ⵛⵏ ⵎⵙⵏⵜ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⴹⵜⵈⵢⴰ ⴹⵎⵔⵢⵎⴰ ⵜⵏ ⵏⴰ ⵏⵢⵆⵀ ⴹⵜⴹⴹⵏ ⵛⵢⴹ ⴹⵔⵙⵏⵜ ⴹⵓⵏⵏ⵰ ⵏ⵿ⵜⵏⵜⵢ ⵙⵗⵍⵏⵏ ⵔⵜⵏ ⵓⵏ ⵢ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ⵎⵛⵏ ⵓⵔ ⵙⵔⵙⵏ ⵍⵏ ⵔⵜⵏⵏ ⵍⵎⵗⵏⴰ⵰ ⴹⵢ ⴼⵍ ⴹⵙⵏⵜⵓⵔⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴶⴹⵓ ⵀⵜⵔⵙ ⵤⵍ ⵙⵤⴾⴰ⵰ ⵙ ⵜⵏⵙⴰ ⵛⴶⴰ ⴹⵗⵙ ⵓⵔ ⴹⵗⵙ ⵏⵢ ⵔ ⵛⴼⵜ ⵜⵤⵔ ⵆⵍ ⵆⵏ ⵓⵏ ⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ⵤⵍ ⵓⵏ ⴹⴰ ⵎⵏⵜ ⴹ ⴾⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵛⵏ ⵜⵗⵔⵎ⵿ⵜ ⵢⵜ ⵜⴶⵜ ⵎⵢⵙ ⵙ ⵜⵍⴰ ⵜⴾⵍⵢ ⵏⵛⵏ ⵍⵓⵆⵏ ⴶⵔⵙ ⴹⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ⵎⵛⵓⵍⵏ ⴹⵗ ⵀⵜⵓ ⵏⵔⵜⵏ ⵓⵏ ⴶⵏⵏ ⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ⵎⵛⵓⵍⵏ ⴹⵏ ⴹⴰ ⵙ ⵜⵏ⵿ⴹⵓⴹ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴹⵓ ⴹⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ⵂⵏⵢⵏ⵿ⵜⵓ ⵎⵛⵏ ⵓⵔ ⵜⵤⴹⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ⵏⵙⵏ «ⵎⴰ ⴹⵗ ⵜⵎⵛⵓⵍⵎ ⴹⴰ⵰» ⵀⴹⴹⵏ ⵜⵓⵔ ⵜⴾⵏ⵿ⵤⵔ⵿ⵜ ⴹⵎⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ⵏⵙ ⵓⴰ ⴹⵗⵙⵏ ⴶⵏ ⵙⵎ ⴾⵍⵢⵀⵙ «ⴹⵙ ⴾⵢ ⵗⵙ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵢⵔⵙⵍⵎ ⵓⵔ ⵂⵏ ⵙⵍⵏ ⵏⵓⴰ ⴹⵗⵙ ⴶⵏ ⴹⵗ ⴹⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ⵏⵙⵏ «ⵎⴰ ⴹⵗⵙ ⴶⵏ⵰» ⵏⵏⵙ «ⵔⵜ ⵓⴰ ⴶⵔⵓⵏ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵎⵙⵏ ⵏⵀⵢ ⵜⴶⵏ ⵎⵤⵍⵏ ⴹⵓⵍⵏ ⵏ⵿ⵜⵍⴰ ⵜⵔⵏⴰ ⴹⵜ ⵎⵛⵏⴰ ⴹⵢⵜⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ⵙⵜⵔⵎⵙⵏ⵿ⵜⵓ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⵎⵤⵔⵏⵏⴰ ⵜⵜⵓⵈⴾⵎⵙ ⵜⵎⵜⵏ⵿ⵜ ⵙⵜⵢⵜⵢⵏ⵿ⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ⵏⴾⵏⵢ ⴹⵜ ⵓⵏ ⵏⴶⴰ ⵜⵎⴰ ⵏⵙ ⵏ⵿ⵜⴰ ⵤⵙⴹⵔⴼⵏ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ⵰ ⵎⵛⵏ ⵤⵍⴹⴰ ⵤⵍ ⵏⵔⵜⵏⵏ ⵓⵏ ⴾⵔⴹ ⴹⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵆⵏⵜ ⵜⴹⴹⵏⵏⴰ ⵛⵢⴹ ⵗⴼⵓⵏⵏⴰ ⵏ⵿ⵤⵢⵏⵏ ⵙⵤⴾⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ⵎⵛⵏ ⵓⵔ ⴹⵗⵙ ⵏⵢⵏⵜ ⵜⵗⵙⵏⵜ⵰ ⵆⵍⵏⵜⴹⵓ ⵏⵏⵜ ⵏⴼⵍⵍⵏⵙⵏⵜ ⵏ⵿ⴶⵍⵙⵏ ⵏⵏⵙⵏⵜ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ⵜⵤⵔ ⴾⵏ ⵓⵢⴹ ⴹⵗⵏⴰ ⵤⴾⴰ ⵙⵏⵏ ⵏⵢⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵏⵏⵜ ⵜⴹⴹⵏ ⵏ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⵜⵏⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ⵎⵔⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵈⴰ ⴾⵓⵏⵢ ⵤⴰ ⵍⵌⵂⵍⵏ⵰ ⵤⵓⵜ ⴼⵍⵓⵏ ⵤⴶⵤⵏ ⵙⵔⵜ ⴾⵍ ⵓⴰ ⵏⵏ ⵏⵀⵜⵏ ⴹⵗ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ⵓⵔⴶⵗ ⵍⵎⵙⵈ ⵍⵤⵎ ⵙ ⴹ ⵏⵢ ⵍⵗⵤⵀ ⵜⵤⵔ ⵎⵔⵏ ⴶⵔⵓ ⵜⵏⵢⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ⵜⵤⵔ ⵜⵏⵙⵙⴶⵔⵓ ⵗⵢⵙⴰ ⵓⴰ ⵙⵔⵙ ⵏⵏ ⵍⴾⵜⵀⵏ ⴾⵍ⵰ ⵀⵤⴹⵓ ⵗⵔ ⵍⴾⵜⵀⵏ ⵓⵏ ⵏⵀⵢ ⵎⵙⴰ ⵂⵔ ⵓⵏ ⵏⵀⵜⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ⵙ ⴹⵏⵂⵤⵏ ⵜⵗⵔⵎ⵿ⵜ ⵜⴰ ⴾⵏ ⵙⴾⵏⴰ ⵗⵢⵙⴰ ⵙ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ⵎⵛⵏ ⵓⵗⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵗⵎ ⵗⵔⵏⴰ ⴼⵍⵙ ⵤⵍ ⴶⵍⴰ ⵂⴹ ⵀⴾ ⵢⴶ» ⵜⵤⵔ ⵤⵀⵜ ⵗⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ⵙ ⴶⵤⵏ ⵛⵏ ⵜⵜⵢ ⴹⴾⵍ ⵗⵢⵙⴰ ⵜⴶⵍⴰ ⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⵔⵤⵜ ⴾⴼⵙⵏ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ⵎⵔⵏⵜ ⵛⵜⵓⵏⵙⵏ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵤⴹⵢⵏ⵿ⵜⵓ ⵎⵛⵏ ⴶⵤⵙⵏ ⵜⵏ⵿ⴾⵍ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ⵜⵤⵔ ⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵤⵗⵏⵏ ⵓⵏ ⴹⴰ ⴼⵍ ⴾⵏⵏ ⵎⵏⵏⴰ ⵜⴼⵍⵓⵙ⵿ⵜ ⵍⵓⵆ ⵓⴰ ⴹⵏⵗⵛⵓⵍ ⴹⵗ ⵜⵔⵢⵜ ⵙⵙⴶⵔⵏⴰ ⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ⵀⴹⴹⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵆⵍⵏ ⵢⵔⵙⵍⵎ⵰ ⵙⵏⵏ ⵏⵎⵤⵍ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ ⴹⵏⵍⴾⵎⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵓⵏ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ⴶⵏⵏ «ⵜⴹⵜ ⴹⵗ ⵎⵙ ⵙ ⵎⵍⵢ ⵗⵢⵙⴰ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵔⵏ ⵏⴼⵍⵍ ⵢ ⵙⵎⵗⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ⵙⵗⵍⵏⵙⵏ ⵎⴹⵏ ⵓⵏ ⵛⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵓⴰ ⵏⵢⵏ ⴹⵗ ⵜⵔⵢⵜ ⴹⵎⴾ ⵓⵙ ⵜⵤⴹⵢⵏ ⵍⵓⵆ ⵓⴹ ⵔⵤⴰ ⵜⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ⵂⵔⵓⴹⴰ ⵛⵓⵍⵏ ⴹⵗ ⵓⵏ ⵙ ⴹⵀⴹⴹ ⵗⵢⵙⴰ ⵎⵏⵜ ⴶⵔⵙⵏ ⵏⵙⵏ «ⵍⵈⵔ ⴼⵍⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ⴶⵏ ⵜⵔⵎⵆ ⵤⵓⵔⵜ ⵜⴶⵤⵜⵏ ⵜⵙⴰ ⴼⵍⵙ ⵗⵍⵏ ⴶⵙⴼ ⵂⵏⵢⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⴰ ⴼⵍ ⵜⵛⵓⵛⵎ⵰ ⵎⴰ ⴼⵍ ⴹⵗ ⵜⴶⵎ ⵛⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ⵏⵢⵜ ⴼⵙⵏⵏ ⴹⵔⵏⵏ ⵏⴾ ⵎⵏⵏ ⵓⴰ⵰ ⴹⵙⵜⵢ ⴹ ⵜⵏⵢⵎ ⴼⵍⵙ ⴶⵙⴼ ⵓⵔ ⵍⴰ ⵜⵗⵙⴰ ⵓⵍⴰ ⵗⵙⵏ ⵓⵏ ⵙ ⴹⵜⵂⵏⵢⵎ ⴹⴰ ⵍⵆⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ⵙ ⴹⵙⵏⵏⴰ ⵓⵏ ⵙⴾⵏⵏ ⴼⵙⵏⵜ ⴹⵔⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ⵎⵛⵏ ⴶⵍⵏ ⵓⵔ ⴹⵗⵙ ⴾⵙⵏ ⵛⴾ ⴼⵍ ⵓⴰ ⴶⵏ ⴹⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⴾⵏⴰ ⴹⵗ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ⵰ ⴹⵢ ⴼⵍ ⴹⵙⵏⵏⴰ «ⵓⴾ ⵜⵍⵎ ⵜⵎⵜⵛⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ⴾⴼⵏ⵿ⵜⵓ ⵜⵀⵍⵍ⵿ⵜ ⵏ⵿ⴾⴼⵢ ⵜⵑⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ⵀⵤⵜⵜ ⵜⵛⵜ ⴹⵜⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ⴹⴼⵔ ⵓⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏⵏ ⵂⵔⵓⴰ ⴾⵓⵏⵂⵗ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⴼⵍⵢ ⴾⵜⵀⵏⵏ ⴹⵗ ⵜⵓⵔⵜ ⵏⵏⵀⵢ ⵎⵙⴰ ⴹⵍⴾⵜⵀⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵤⵀⵔ ⵛⵍ ⴹ ⵏ⵿ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ⵎⵔⵏ ⵔⴰ ⵗⴼⵓⵏⵙⵏ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵢⴹ ⴶⵔⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ⵏⵙⵏ «ⵓⵔⴶⵗ ⴾⵜⵀ ⵙ ⵍⵎⵙⵈ ⴹ ⵏⵢ ⵍⵗⵤⵀ ⵀⵜⵓ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⵏ ⴾⵔⴹ ");
INSERT INTO ttqt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ⵜⵤⵔ ⵜⵓⴶⵏ ⵙⵍⵏ ⵏ⵿ⵜⵜⵀⵜ ⵙⵙⵎⵏⵜ ⵢ ⵜⵎⵜⵓⵏ ⴾⵍ ⴼⵍ ⴹ ⴶⵔⵓⵏⵜ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏ ⵏ⵿ⵜⵓ ⵓⵏ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ⴾⵓⵏⵢ ⵜⵎⵙⵎ ⵛⴶⵢⵓⵏ ⵏⵔⵜⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ⵎⵔⵏ ⵏⴾ ⴼⵍⵓⵏ ⴹⵤⵤⵀⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵀⵏⵏ ⴶⵏ ⵔⴾⵓⵍⵏⵜ⵰ ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⴶⵎⴹⵎ ⵗⵔⵎ ⵓⴰ ⴹⴰ ⵂⵔ ⴹⵤⵀⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⴼⵓⵏ ⵜⵔⵏⴰ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ⴹⴼⵔ ⵓⵏ ⴹⵓ ⴹⵔⵙⵏ ⴶⵎⴹⵏ ⵗⵔⵎ ⵂⵔ ⴹⵏⵂⵤⵏ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵀⵜⵏⵢ ⵜⵤⵔ ⴹⴾⵍ ⴼⵙⵏⵜ ⵜⵔⵙⵏ ⵜⵏⴾⴼⵏ ⵍⵀⵔⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ⵜⵜⵔⵙⵏ ⵂⵔⵓⴰ ⴹⴰ ⵙ ⴹⵔⵙⵏ ⵎⵤⵢ ⵎⴹⴾⵍ ⵙ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵙ ⴹⵙⵙⵌⴹⵏ ⵆⵍⵏ ⵢⵔⵙⵍⵎ ⴾⵏⵏ ⵜⴼⵍⵓⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ⴼⵓ ⵂⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵍⵏ ⵎⵛⵏⴰ⵰");
INSERT INTO ttqt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ⵙ⵿ⵜⵤⵔⵜ ⵙ ⴹⵈⵍⴾ ⵎⵛⵏⴰ ⴹⵏⵜ ⴹⴰ ⵓⵍ ⵍⵢ⵰ ⵓⵍ ⵍⴰ ⵗⵔ ⵎⵛⵏⴰ ⵎⵔⵏ ⵓⵍ ⵓⴰ ⵎⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ⵓⵍ ⵙ⵿ⵜⵤⵔⵜ ⵍⴰ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","4","ⵈⵍⴾⴹⵓ ⵙⵔⵙ ⵎⵛⵏⴰ ⵔⵜ ⴾⵍ⵰ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⴹⵗ ⴹⵏⵜ ⵓⴰ ⵙⵔⵙ ⴹⵓⵔⵏⵈⵍⴾ ⴼⵍⵙ ⵓⵍ ⵓⴰ ⵏ⵿ⵜⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵎⵙⵜ ⵏⵔ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ⵎⵍⵓⵍⵓ ⴹⵗ ⵛⵢⵢ ⵎⵛⵏ ⵓⵔ ⵜⵆⵀⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ⵙⴹⵓ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵢⵈⵢⴰ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ⵎⵙ ⵜⴶⵢⴰ ⴼⵍ ⴹ ⵎⴶⵔⴹ ⵙⵏⵔ ⵓⴰ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵙⵔⵜⵏ ⵓⵏ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵓⵔ ⵎⵙ ⵏⵔ ⵜⵓⵙⴶⵍⴰ ⵗⵙ ⴹⴶⴰ ⵎⵙ ⵜⴶⵢⴰ ⴼⵍ ⴹ ⵎⴶⵔⴹ ⵙⵏⵔ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ⵓⵍ ⵓⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵏⵔ ⵓⵏ ⵜⴹⵜ ⵓⴰ ⴹⴾⵏ ⴹⵏⵜ ⵙⵎⵍⵓⵍⵓ ⵢⵜⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ⵏ⵿ⵜⴰ ⵂⵏ ⴹⵏⵜ ⵈⵍⴾⵜⴹⵓ ⵙⵔⵙ ⵎⵛⵏⴰ ⵎⵛⵏ ⵓⵔ ⵜⵜⵆⵀⵍ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ⵙⴹⵓ ⴾⵍⵏⵜ ⴶⵙ ⵓⵔ ⵜⵆⵀⵍⵏ ⵢⵜⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ⵎⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵆⵀⵍⵏⵏ ⵤⴶⵤⵏⵏ ⵙⵔⵙ ⵓⵏ ⴹⵢ ⴾⴼⵏ ⵍⵎⵆⵎ ⵏ⵿ⵜⵛⵜ ⵏⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ⵀⵔⵔⵏⵏ ⵍⵙⵏ ⵜⵂⵓⵜ⵰ ⵎⵛⵏ ⵜⵂⵓⵜⵏ ⵓⵔ ⵜⵍⴰ ⴹⵜⴰ ⵜⵜⵓⵤⴹⵢⵜ⵰ ⵓⵔ ⵜⴶⴰ ⵙ ⵍⴾⵎ ⵢ ⴹⵔⵏ ⵏⴶⴹⵎ ⵓⵍⴰ ⵜⵏⵜⵏⵜ⵰ ⴾⵍⴰ ⴾⵍⵔ ⵎⵛⵏⴰ ⵎⵏⵜ ⵙ ⵜⵏⴶⴰ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ⵓⴰ ⵎⵙⵏ ⵓⵍ ⵆⵍ ⵓⴹⵏ ⵈⵙⵔ ⵗⵔⵏⴰ ⴾⵏⴰ ⵜⵍⴰ ⵏⵍⵈⵔⵎⴰ ⵎⵙ ⵎⵛⵙ ⵏ⵿ⵜⴹⵜ⵰ ⵏⵙⵏⴶⵔⴰ ⵜⵏⵢⵏⵜ ⵜⵏⵢⴰ ⵜⴰ ⴶⵔⵓ ⵀⵔⵔ ⵏⵢⵏ⵿ⴹⴰ ⵗⵔ ⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ⴶⵢⵜⵙ ⵢⵈⵢⴰ ⵛⵓⵍ ⵙⴼⵍⴰ ⴹ ⴶⵏⵓ «ⵓⴰ ⴹⵗ ⵙ ⵂ ⵀⵜⵏⵜ ⵙⵗⴰ ⵓⴰ ⴹⵓⵏ⵿ⴶⵏⴰ \"ⴰ ⴹⵙⵓ ⴹⴼⵔⵢ ⵎⵛⵏ ⴶⵔⵢ ⴼⵍⵙ ⴹⵜⵢ ⴹⴰ ⵍⵢ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ⵓⵍⴰ ⴾⵜⵏⵏⴰ ⵏⴶⵔⵓ ⵍⵀⵔⴾⴰ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵙⵍⵈⵔⵎⵏⵜ ⴾⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ⴼⵍⵙ ⵎⵛⵏⴰ ⴾⴼⵏⵗ ⵛⵔⵗⴰ ⴹⵗ ⴼⵙ ⵏⵎⵙⴰ ⵍⵈⵔⵎⴰ ⴹⵜⴹⵜ ⵎⵔⵏ ⵙⴹⵓ ⴹⵔⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵏⵢⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⵀⵔⵔ ⵏⵢⵏ⵿ⴹⴰ ⵎⵙⵏ ⵎⵛⵏⴰ ⵍⴰ ⵗⵔ ⵀⴰ ⵏ⵿ⵜⴰ ⴹⵏⵆⵙⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ⵏ⵿ⵜⴰ ⴹⴰ ⵜⴶⵢⴰ ⵜⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢⵔⵜ ⴹⵗ ⵍⵎⵎⵏ ⴹⴾⵍⵀⵢ ⵓⵏ ⴹⴼⵍⵏⵏ ⵢⵔⵙⵍⵎ ⵙⵗⴰ ⵓⴰ ⵜⵏ⵿ⴹⵤⵎⵤⵍⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵢⴹ ⵜⵙⵙ⵿ⵜⵏⵏ ⴹⵓⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ⵓⵔ ⴶⵢ ⵙⴹⵙⵏⵌⵓⵀ⵰ ⴾⵍⴰ ⴾⵍⵔ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵙⴼⵍⴰ ⵏⵙⵏ «ⵏⴾ ⵓⵔ ⵎⵙⵗ ⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ⵏⵏⵙ «ⵎⴰ ⵜⵎⵙⴰ ⵤⴰ⵰ ⵍⵢⵙ ⵜⵎⵙⴰ⵰» «ⴾⵍⴰ ⴾⵍ» ⵏⵙⵏ «ⵓⵔ ⵜⵎⵙⴰ⵰» «ⵏⵀⵢ ⵓⴰ ⵜⵎⵍⵏ ⵜⵎⵙⴰ⵰» «ⴾⵍⴰ ⴾⵍ» ⵏⵙⵏ «ⵓⵔ ⵜⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ⵜⵤⵔ ⵏⵏⵙ «ⴹⵗ ⴹⵢ ⵎⴰ ⵜⵎⵙⴰ⵰ ⵂⵔ ⴹⵏⵙⵓ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏⴹⵙⴶⵍⵏⵏ ⵏⵓⵢⵙⵏ ⵍⵌⵓⵀ ⵏⵓⴰ ⵜⵎⵙⴰ⵰ ⴹⵗ ⴹⵢ ⵎⵍⵏⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ⵏⵙⵏ ⵔⵜ ⵓⴰ ⵏⴰ ⵏⵀⵢ ⵙⵢⵙ ⵔⵓ ⵙ ⵏⴰ «ⵏⴾ ⵎⵙⵏ ⵓⴰ ⵙⵗⵔⵏ ⴹⵗ ⵙⴼ ⴶⵏⵓ \"ⵙⵙⵗⴹⵜ ⵀⵔⵆⴰ ⵢⵎⵍⵢ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ⵢⵜⴹⵏ ⵓⵏ ⴹⵎⵤⵍⵏⵏ ⵙ ⵢⵈⵢⴰ ⴹⴰ ⵂⵏ⵿ⵜⵏ ⴾⵍ ⵜⴶⵢⵜ ⵜⵏ ⴼⵔⵙⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ⵍⵙⵏ⵿ⵜⵓ ⵙⵙ⵿ⵜⵏ ⵏⵏⵙ «ⵎⴰ ⴼⵍ ⵜⵙⵍⵎⵗⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴾⵢ ⵜⵏ ⵓⵔ ⵜⵎⵙⵗ ⵍⵎⵙⵈ ⵓⵔ ⵜⵎⵙⵗ ⴹⵗ ⵏⵀⵢ ⵓⴰ ⵜⵎⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ⵏⵙⵏ «ⵏⴾ ⵎⵏ ⴹⵗ ⵙⵍⵎⵗⴰ ⵎⵛⵏ ⵍⴰ ⴶⵔⵓⵏ ⵓⴹⵏ ⵓⵔ ⵜⵤⴹⵢⵎ ");
INSERT INTO ttqt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ⵙⵏ⵿ⵜⴰ ⴹⵤⵙⵏ ⴹⴼⵔⵢ ⵎⵔⵏ ⵓⴰ ⴹⴶⴰ ⴹⵗ ⵛⴶⵔⵜ ⵓⵔ ⵓⴹⴰ ⵓⵍⴰ ⵔⴰ ⵏ⵿ⵙⵗⵏ ⵏ⵿ⵗⵜⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵎⴹⵍ ⵏⵀⵜⵏⵢ ⴹⵗ ⵜⴶⵏ ⴼⵍ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ ⵓⵏ ⵢⵔⴹⵏ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵙⵍⵎⵗ ⵢⵈⵢⴰ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ⵙ ⴶⴰ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⴶⴰ ⵢⵈⵢⴰ ⵗⵢⵙⴰ ⵤⵢⵜⴹⵓ ⵜⵤⵔ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⵏ ⵌⵗⵍ ⵏⵎⵛⵏⴰ ⵓⴰ ⵜⴾⵙⵏ ⵀⴾⴹⵏ ⴹⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ⵏ⵿ⵜⴰ ⵙ ⵂ ⵀⵜⵏⵜ ⵙ ⴹⵓⵏ⵿ⴶⵏⴰ \"ⵍⵙ ⵢⵏ ⴹⵙⵓ ⴹⴼⵔⵢ ⵎⵛⵏ ⴶⵔⵢ ⴼⵍⵙ ⴹⵜⵢ ⴹⴰ ⵍⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ⵏⴾ ⵎⵏⵏ ⵓⵔ ⵜⵤⴹⵢⴰ ⵎⵛⵏ ⵙⴹⵓ ⴹ ⵙⵍⵎⵗⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴼⵍ ⴹⵏⴼⵍⵍ ⵢ ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ⵍⵙ ⵢⵈⵢⴰ ⵜⴶⵢⴰ ⵏⴰ «ⵙⵓⴹⴰ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⴹⴶⵎⴹ ⵌⵏⵓⵏ ⵂⴰ ⵛⵛⵍⵏ ⵏ⵿ⵜⴹⵀⵔ⵿ⵜ ⵓⵔ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ⴹⵜ ⵓⵏ ⵓⵔ ⵜⵤⴹⵢⴰ ⵎⵛⵏ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵢⴹ ⵙⵍⵎⵗⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵏⵢ \"ⵍⵙ ⵓⵙ ⵜⵏⵢⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⴼⵍⵙ ⴹⵤⵀⵜ ⵍⵙ ⵓⴹⵢ ⵏ⵿ⵜⴰ ⵤⵙⵍⵎⵗⵏ ⵢⵜⴹⵏ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ⵎⵔⴹⴰ ⵔⵜ ⵓⴰ ⵏⵢⵆⵓ ⵙ ⵛⵜⵓⵏⵏ⵰ ⵎⵔⵏ ⴶⵢ ⵙⵍⴾⵏⵗ ⵙ ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ⵙ ⴶⴰ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵂⴰ ⵢⵈⵢⴰ ⴹⴶ ⵓⴰ ⵂⵔⵓⴰ ⴹⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵛⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ⴶⴰ ⵗⵢⵙⴰ ⵙ ⴹⴶⵎⵏⵙⵏ ⴹⵍⵎ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⵏ ⵌⵗⵍ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ⵙⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⵛⵏ ⵢ ⵀⵜⵓ ⵜⴰ ⴶⴰ ⴹⴰ ⵜⵤⵔ ⵍⴾⵎⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ⵙⵓⴹⵏ ⵗⵢⵙⴰ ⴹⴼⵔⵙ ⴶⵏ ⵍⴾⵎⵏⵙ ⵏⵙⵏ «ⵎⵙ ⵜⵙⴶⴹⵎ⵰» ⵏⵏⵙ «ⵎⵏⴹ ⵜⵗⵙⵔⴰ ⵛⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ⵏⵙⵏ «ⴶⵍⵓⵜⴹⵓ ⵜⵜⵏⵢⵎ»⵰ ⵜⴶⵓ ⵓⵏ ⵜⴾⵙ⵿ⵜ ⵤⴶⵔⵜ⵰ ⴶⵍⵏ ⴹⵓⵏ ⴹⵔⵙ ⵏⵢⵏ ⴹⴹ ⵍⴰ ⵜⵤⵔ ⵙⵏ⵿ⴹⵏ ⵗⵔⵙ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ⵎⴹⵏ ⵓⵏ ⵛⵏ ⵍⴾⵎⵏⵏ ⵢ ⵗⵢⵙⴰ ⴹⴼⵔ ⵜⵙⵍⵢ ⵜⴰ ⴶⵏ ⵢⵓⵍ ⵏⵢⵈⵢⴰ ⵙⵎ ⵏⵢⵏ ⴹⵗⵙⵏ ⵏ⵿ⴹⵔⵓⵙ ⵎⴹⵔⵢ ⵏ⵿ⵙⵎⵗⵏ ⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ⵎⵏⵢ ⵏ⵿ⴹⵔⵓⵙ ⴹⵎⵆⵔⵏⵜ ⵙⵎⵗⵏ ⵙ⵿ⵜⵤⵔⵜ ⵏⵙ «ⵏⴾⵏⵢ ⵏⵎⵏⵢ ⴹⵍⵎⵙⵈ⵰» ⵍⵎⵗⵏⴰ ⴾⵔⵙ⵿ⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ⵎⵔⵏ ⵍⵓⵢⵜⵓ ⵙ ⵗⵢⵙⴰ⵰ ⵙⵓⴹ ⵗⵢⵙⴰ ⴹⵗ ⵙⵎⵗⵏ ⵗⵙ ⵏⵙ «ⴾⵢ ⵙⵎⵗⵏ ⴶ ⵢⵈⵢⴰ ⴹ ⵜⴶⵗ ⵙⵎ ⵆⵢⴼⵙ⵰» ⵙⵎ ⵓⴰ ⵍⴰ ⴹ ⵓⵏ ⵀⵜⵔⵙ ⵍⵎⵗⵏⵏⵜ ⵜⵂⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ⵙ ⴼⵓ ⵔⴰ ⵗⵢⵙⴰ ⴾⵢ ⵏⵎⴹⵍ ⵏ⵿ⴶⵍⵍⵢⴰ⵰ ⵎⵏⵢ ⴹⴼⵍⵀⵙ ⵏⵙ «ⵍⴾⵎⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ⴼⵍⵀⵙ ⴹⵏ⵿ⴹⵔⵓⵙ ⴹⵀⵜⵔⵙ ⵗⵔⵎⵏⵙⵏ ⵢⵏ⵿ⴹⴰ ⵙⵎⵏⵜ ⵀⵜⵙⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ⵎⵏⵢ ⴼⵍⵀⵙ ⴹⵏⵜⵏⵢⵍ ⵏⵙ «ⵏⴾⵏⵢ ⵏⵎⵏⵢ ⴹⵓⵙ ⵎⴶⵔⴹ ⵏⵀⵢ ⵎⵙⴰ ⴹⵗ ⵜⵓⵔⵜ ⵎⴶⵔⴹⵏ ⵙⵔⵙ ⴹⵗ ⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ ⵜⵎⵙⵏ ⵗⵢⵙⴰ ⵓⵏ ⴶ ⵢⵙⴼ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ⵜⵤⵔ ⵏⵙ ⵏⵜⵏⵢⵍ «ⵎⴾⵏ ⵗⵔⵎ ⵏⵤⵔⵜ ⵜⴹⴶⵎⴹ ⵔⵜ ⵂⵙⵢⵏ⵰» ⵏⵙ ⴼⵍⵀⵙ «ⵢⵓ ⵜⵏⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ⴶⴰ ⵗⵢⵙⴰ ⵏⵜⵏⵢⵍ ⵤⵢⵜⴹⵓ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⵏ ⵓⴹⵏ ⵏⵙⵔⵢⵍ ⵓⵏ ⵜⴹⵜ ⵓⴰ ⵓⵔ ⵂⴰ ⵎⵙⵏ ⵜⵍⵎⵏⴼⵆⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ⵏⵙ ⵏⵜⵏⵢⵍ «ⵎⵏⵢ ⵓⵙ ⴹⵜⵤⴹⵢⴰ⵰» ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⵂⵔⵓⴰ ⴾⵢ ⴹⵓⵔⵗⵔⴰ ⴼⵍⵀⵙ ⵙⵗⴰ ⵓⴹ ⵜⵍ ⴹⵓ ⵛⴾ ⵓⵏ ⴼⴶ ⴹⴰ ⵂⵏⵢⵆⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ⵏⵙ ⵏⵜⵏⵢⵍ «ⵛⵈ ⴾⵢ ⵎⵙⵏ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵗ ⵎⵏⴾⵍ ⵏⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ⵏⵙ ⵗⵢⵙⴰ «ⵜⵤⴶⵤⵏⴰ ⴼⵍ ⵙ ⴹⴾⵏⵗ ⵂⵏⵢⵆⵢ ⴹⵓ ⵛⴾ ⵏ⵿ⴼⴶ⵰ ⴹ ⵜⵏⵢⵗ ⵔⵜⵏ ⵓⵢⴹ ⵤⵓⵔⵏⵏ ⴶⵔⵏⵏ ⵓⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ⵏⵙ ⵗⵢⵙⴰ ⴹⵗ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⴼⵔ ⵓⴰ ⴹ ⵜⵏⵢⵎ ⵌⵏⵓⵏ ⵏⵍⵎⵏ ⵜⴶⵤⵢⵏ ⵙⵔⵙⵏ ⵏ⵿ⴶⵍⵙⵏ ⵜⵤⵀⵏ⵿ⴹⵓ ⴼⵍⵢ ⵏⴾ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ⵤⵍ ⵓⵏ ⴾⵔⴹ ⵜⵎⵍ⵿ⵜⵓ ⵜⴾⵔⵙ⵿ⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴾⵏⴰ ⴹⵗ ⵎⴹⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵜⵂⵜ ⵏⴰ ⵏ⵿ⵗⵢⵙⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ⵜⵤⵔ ⵜⵓⵗⵔⴹⵓ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵓⴹⵓ ⴹⵏⵜⵍⵀⵏⵜ ⵙ ⵜⴾⵔⵙ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ⵙ ⵀⵙ ⴹⵆⵎ ⵓⵍⴰ ⴹⵗ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵜⵏⴰ ⵏⴰ ⵏ⵿ⵗⵢⵙⴰ ⵢⵙ «ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵗⵔⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ⵏⵙ ⵗⵢⵙⴰ «ⵏⴰ ⵜⴹⵢ ⴾⵎⵓⵔ⵿ⵜⴹⴶⵤ⵰ ⵍⵓⵆⵏ ⵓⵔ ⴹⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ⵜⵏⴰ ⵏⵏⵜ ⵢ ⵎⵛⵗⵍⵏ «ⴶⵜ ⵓⵙ ⴹⵓⵏⵏⴰ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ⵙⴾⵔⵏ ⴹⵏ ⵙⴹⵙ ⵜⴾⵏ ⵜⴶⵤⵏ ⵎⵏ ⵙ ⵜⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵤⵤⴹⴶ ⵎⵙⵏ ⵍⵗⴹⵜⵏⵙⵏ⵰ ⴾⵍⴾ ⵏⵢⵏ ⵜⴶⵤⵜⵓ ⴹⴾⴹ ⵏ⵿ⵜⵎⴹⵢ ⵏⵍⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵎⵛⵗⵍⵏ ⵏ «ⴹⵏⵢⵜ ⵜⴾⵏ ⴹⵢ ⵎⵏ⵰» ⵏ⵿ⵜⵏⵢ ⴹⵗ ⴹⵏⵢⵏ⵿ⵜⵏ ⵂⵔ ⴼⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ⵏⵙⵏ ⵎⵔⵏ «ⵍⴾⵓⵜ ⴹⵗⵙⵏ ⵎⵔⴹⴰ ⵢⵎⵓⵢ ⵏ⵿ⵙⴾⵙⵙ⵰» ⴶⵏ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ⵙ ⵔⵎ ⵎⵓⵢ ⵏ⵿ⵙⴾⵙⵙ ⵎⵏ ⵓⵏ ⵎⵜⵢⵏⵏ ⴹⴰ ⵆⵍⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵙ ⵓⵔ ⵙⵏ ⴶⵤ ⵓⴰ ⴹⴶⴰ ⵎⵛⵏ ⵎⵛⵗⵍⵏ ⵓⵏ ⵜⵏ⵿ⴹⵍⴾⵓⵏⵏ ⴹⴰ ⵙⵏⵏ ⵗⵔⴰ ⵎⵤⵍⵢ ");
INSERT INTO ttqt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ⵏⵙ «ⵎⵙⴾⵙⵙ ⴾⵍ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵓⴰ ⵤⴹⵏ ⴶⵔⵓⵏ ⵎⵔⵏ ⴹⴼⵔ ⵙ ⴼⵍⵓⵙⵏ ⴹ ⴶⵔⵓⵏ ⵓⴰ ⵙⵎⴾⵏⵏ⵰ ⴶⵙ ⴾⵢ ⵜⵗⵀⵔⴰ ⵓⴰ ⵤⴹⵏ ⵂⵔ ⵎⵔⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ⵏ⵿ⵜⴰ ⴹⵢ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⵜⴰ ⵜⵤⵔⵜ ⵎⵤⵍ ⵗⵢⵙⴰ⵰ ⴶⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴾⵏⴰ ⵜⵏ ⴶⵍⵍⵢⴰ⵰ ⵙⵏⴼⵍⵍ ⵙⵔⵙ ⵜⵏⵢⵏⵜ ⵜⵤⵔ ⵤⴶⵤⵏⵏ ⵙⵔⵙ ⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ⴹⴼⵔ ⵓⵏ ⵤⴶⴹⵢ ⵗⵢⵙⴰ ⴾⴰ ⵜⵗⵔⵎ⵿ⵜ ⵏ⵿ⴾⴼⵔⵏⵂⵎ ⵏ⵿ⵜⴰ ⴹⵏⵏⵜ ⴹⵎⴹⵔⵢⵏⵜ ⴹⵏⵜⵍⵀⵏⵜ⵰ ⵓⵔ ⴹⵗⵙ ⴶⵏ ⵔ ⵔⵜ ⵏⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ⵙ ⴹⵂⵤ ⵎⴹ ⵓⵏ ⴾⵢ ⵎⵙⵏ ⵎⴹ ⵎⵆⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵤⵢ ⵗⵢⵙⴰ ⴾⴰ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ⴶⵤⵏ ⵗⵢⵙⴰ ⴹⵗ ⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵙⵜⴶⵏ ⵏ⵿ⵤⴶⵔⵏ ⴹⵢⴼⴹ ⴹⵜⴹⵀⵔⵏ ⴹⵜⵗⵎⵜⵏ ⵏ⵿ⴾⵍ ⵙⵏ⵿ⵌⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ⴶⴰ ⵍⴾⴹ ⵙ ⵗⵏⵏ ⵙ⵿ⵜⵆⵏ ⴹⵗ ⴼⵔⴶⵏ ⴾⵜⵏⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⵢⴼⴹ ⴹⵤⴶⵔⵏ ⵏ⵿ⴼⵤ ⴹⵗ ⵎⴹⵍ ⵤⵔⴼⵏ ⵏ⵿ⴾⵍ ⵙⵏ⵿ⵌⵢ ⵙⵀⵏⵀⵢ ⵜⵀⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ⵎⵙⵜⴶⵏ ⵏ⵿ⵜⴹⵀⵔⵏ ⵏ⵿ⵜⵏⵢ ⵏⵙⵏ «ⴾⵙⵜ ⵓⴰ ⴹⵗ ⴹⴶ ⴰ ⴹ ⵓⵔ ⵜⴶⵎ ⵂⵏ ⵏⵀⵏⵏ ⵙⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ⴾⵜⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⴾⵜⵀ ⵏⵏⵀⵢ ⴹⵓⴹ ⵓⴰ ⵏⵏ «ⵜⵔⵏⵏ ⵂⵏⴾ ⵜⵔⵗⴰ ⴹⵗⵢ ⵛⵍⵜ ⵏ⵿ⵜⵎ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⵏⵙ «ⵎⴰ ⵜⵎⵙ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵙ ⵜⴼⵔⴶⵗ ⴶⵏⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⵜⵙⵜⴹⵜ ⵙ ⵜⵍⵗ ⵜⵔⵢⵜ ⵏⴶⵢ ⵏⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵌⵀⵔⵌⵜⵜ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵢ ⴹ ⵜⵙⵀⴹⴹⴰ ⴹⵗ ⴾⵔⴹ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ⵏⵏⵙ «ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵢ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴹⵙⴹⵙ ⴼⵍ ⵜⵓⴾⵔⵙ⵰ ⴾⵢ ⵎⵙ ⵜⵤⵜⵙⵀⴹⴹⴰ ⴹⵗ ⴾⵔⴹ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⴰ ⵎⵍ ⵗⵢⵙⴰ ⴹⴰ ⵜⵗⵙⵏⵜ ⵙⵔⵙ ⵙⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ⵙ ⴹⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴾⵜⵏ⵿ⴹⵓ ⵏⵜⵍⵀⵏⵜ ⵜⵏⴰ ⵜⴰ ⴶⴰ ⴹⵢ⵰ ⵤⴶⵤⵏⵏ ⵙⵓⵍ ⵏⵎⵛⵏⴰ ⴹⵓⵍ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ ⵗⵔ ⵏⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵎⵤⵍ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⴶⴰ ⴹⵗ ⵢⵔⵙⵍⵎ ⵗⵔ ⵎⴹ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ⵎⵛⵏ ⵢⴰ ⵗⵢⵙⴰ ⵓⵔ ⵜⵏⴼⵍⵙ ⴼⵍⵙ ⵤⴹⵢⵜⵏ ⴾⵜⵏⵙⵏ ⵏ⵿ⵜⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ⵓⵔ ⴹⵔⵔ ⵙⵢ ⴹⵙⴶⵏ ⵙⵍⵏ ⵏⵓⴹⵏ ⴹ ⵓⵔ ⴹⵙⵗⵀⵔ ⵓⴰ ⵂⵏ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ⵍⵢ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵏⴾⴹⵎⵙ ⵂⵏ ⵜⴶⵢⵜ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⵎⵙ ⵢⵏ ⴹⵗ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ⵙⴹⵓ ⵗⵢⵙⴰ ⵂⴹ ⵢⵏ ⵏⵙ «ⵛⵈⵏ ⵏⴾⵏⵢ ⵏⵙⵏ ⵙ ⵎⵛⵏⴰ ⴾⵢ ⴹⵤⵎⵤⵍⵏ ⵙⵔⵏⴰ ⴹⵏⵜⵙⵙⵗⵔⴰ ⴹ ⵓⵔ ⵜⵍⴰ ⵢ ⵤⴶⵏ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵜⴶ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵔ ⵙ ⵜⴹⵂⵍ⵿ⵜ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ⵗⵢⵙⴰ ⴹⵗ ⵏⵙ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴼⵔⴶⵏ ⵏⵢ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵔ ⵙⴹ ⵍⵙ ⵜⵂⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⴾⴹⵎⵙ ⵏⵙ «ⵎⵙ ⵤⵍⵙ ⵓⴹⵏ ⵓⵛⵔⵏ ⵜⵂⵓⵜ⵰ ⵛⵢ ⵜⴶⵜ ⴹⴰ ⵓⵔ ⴼⵔⴶ ⴹ ⵍⵙ ⵜⵓⵗⵍⵢ ⵏ⵿ⵜⴹⵙ⵿ⵜ ⵏⵏⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⴹⵏ ⵓⵔ ⴼⵔⴶ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵔ ⵙⴹ ⵂⵓ ⵙⵎⵏ ⴹⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ⵍⵙⵍ ⵏⴶⴹⵎ ⵢⵏ ⴶⴹⵎ ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⴹⴶⵎⴹⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗⵙ ⵏⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ⴹⵗ ⴹⵢ ⴹⴾⵓⵔⵆⵏ ⵗⴼ ⵙ ⴹⴾⵏⵗ ⵓⵔⴾⵓⵏ ⴹ ⵜⵍⵙⵎ ⵜⵂⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ⴹⵓ ⴶⵔ ⵙⵙ ⵔⴰ ⵜⵙⵍⴰ ⵢⵎⵙⵍⵏⵜ ⵎⵛⵏ ⵓⵔ ⵜⵙⵏⴰ ⴹⴰ ⴹⴼⵍ ⵓⵍⴰ ⴹⴹ ⴾⴰ⵰ ⵙⵎⵍ ⴹⵢ ⴹⴰ ⵂⴰ ⵓⴹⵏ ⵓⴰ ⵂⵓⵏ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⴾⴹⵎⵙ ⵏⵙ «ⵎⵏⵢ ⵜⵜ ⵜⵎⵓⵜ ⵜⵙ ⵤⴶⵏ ⵔⵜⵏ ⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⵜⵎⵙⵗ ⵎⵙⵏ ⵤⵓⵔⵏ ⴹⵗ ⵙⵔⵢⵍ ⴶⵙ ⵓⵔ ⵜⵙⵏⵗ ⵔⵜⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵏⵜⵎⴶⵔⴹ ⵙⵓⴰ ⵏⵙⵏ ⵏⵜⴶⵢⵜ ⴹⵗ ⴼⵍ ⵓⴰ ⵏⵏⵢ ⴶⵙ ⵜⴶⵢⵎ ⵙⴹ ⵜⵆⵀⵍⵎ ⵜⴶⵢⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ⴹⴹ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵙⵓⴰ ⴹⵓⵏ⵿ⴶⵏⴰ ⵙⴹⵏⵜ ⵎⵙ ⵤⴰ ⵜⵤⴶⵤⵏⵎ ⵓⴰ ⴹⵓⵏ⵿ⴶⵏⴰ ⵙⵍⵈⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ⵓⵔ ⵜⵍⴰ ⵙ ⴾⵍⴰ ⴹ ⵏⵢ ⵌⵏⵓⵏ ⵔ ⵏⴾ ⴶ ⴶⴹⵎ ⵜⵏ⵿ⴹⴶⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ⵎⴾ ⵓⵙ ⵙⵔⴶⴶ ⵏⵀⵢ ⵎⵙⴰ ⵜⵛⵍ⵿ⵜ ⴼⵍ ⴶⵜ ⴹⵗ ⵜⵏⵔⵢ ⵎⴾ ⵓⵏ ⴹⵗ ⵙ ⴾⵏ⵿ⴹⵀⴰ ⵜⵓⵙⵂⴾ ⵏⴾ ⴶ ⴶⴹⵎ ");
INSERT INTO ttqt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ⴼⵍ ⴹ ⵆⵍ ⵙ ⵢ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ⴼⵍⵙ ⵎⵛⵏⴰ ⵓⴰ ⴶⴰ ⵢⴹⵏⵜ ⴹⵗ ⵜⵔⴰ ⴾⴼⴰ ⵀⵔⵔⵏⵜ ⵏⵢⵏ⵿ⴹⴰ ⴼⵍ ⴹ ⵆⵍ ⵙ ⵢ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵓⵔ ⵤⵂⵍⴾ ⴾⵍⵔ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ⵎⵛⵏⴰ ⵓⵔ ⴹⵙⴾⴰ ⵀⵔⵔⵏⵜ ⴹⵏⵜ ⴼⵍ ⵜⵜⵂⵍⴾ ⴾⵍⵔ ⵙⴾⵙ⵿ⵜⵜⴹⵓ ⴼⵍ ⵙⵔⵙ ⵜⴼⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ⵢ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵓⵔ ⵂⵍⴾ ⵎⵛⵏ ⵓⴰ ⵙⵔⵙ ⵓⵔ ⵏⵤⴶⵤⵏ ⵂⵍⴾ ⴼⵍⵙ ⵓⵔ ⵤⴶⵤⵏ ⵙⵙⵎ ⵏⵀⵔⵔ ⵏⵢⵏ⵿ⴹⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ⴹⵍⵍ ⴹⴰ ⵓⴰ ⴹⵓⵢⵏ ⵂⵍⴾ ⵏⵔ ⴹⵙⵏ ⴹⵏⵜ ⵎⵛⵏ ⵙⴼⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⵛⵢⵢ ⴹ ⵔⴾ ⵎⵤⵍⵏ ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ⵎⵔⵏ ⵢ ⵜⴶⵏ ⵜⴾⵎⴰ ⵓⴹⵢ ⴶⵍⴼ ⵏⵔ ⵓⵔ ⵜⴹⵤⴾⵓ ⴼⵍⵙ ⴾⵙⴹ ⴹ ⵏⴼⵍⵍⵏ ⵔⴾ ⵎⵤⵍⵏⵜ ⵤⵍ ⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ⵎⵛⵏ ⵓⴰ ⵜⴶⵏ ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⵓⴹⵢ ⵜⴾⴹⵓ ⵏⵔ ⴼⵍ ⴹ ⵜⵓⵏⵢ ⵙ ⵎⵤⵍⵏⵜ ⵙⵏ⵿ⴹⵢ ⴹⵗ ⵍⴾⵎ ⵢ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ⴹⴼⵔ ⵓⵏ ⴾⴰ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵎⴹⵍ ⵏⵢⵂⴹⵢⴰ⵰ ⵆⵎ ⴹⵗⵙ ⵂⵔ ⴶⴰ ⵔⵜ ⵏⵤⵎⵏ ⵏ⵿ⵜⴰ ⴹⵔⵙⵏ ⵙⵍⵎⵗ ⵗⵢⵙⴰ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ⵢⵈⵢⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵍⵎⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴹⵗ ⵜⵙⵙⵏ⵿ⴶⵢⵜ ⵜⵏ ⵢⵏⵏ ⴹⴶⵎⴰ ⵏ⵿ⵙⵍⵎ ⴼⵍⵙ ⵍⵏ⵿ⵜⵓ ⵎⵏ ⴹⵏ ⴶⵜⵏⵏ⵰ ⵜⵙⵏ⵿ⵜⴹⵓ ⵢⵜⴹⵏ ⵙⵍⵎⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ⵔⵜ ⵓⴰ ⵙ ⵜⴶⵓ ⵢⵈⵢⴰ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴶⵤ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔ ⵏⵜⵍⵀ ⵏⵢⵈⵢⴰ ⴹⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵎⵓⵜⵏ ⵛⵏ ⵙ ⵜⴶⵓ ⵤⵤⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ⴾⵏ ⵢⵈⵢⴰ ⵏⵏⵙ «ⵛⵈⵏⵏⴰ ⵜⴾⵜⵓⴰ ⵍⵙ ⵓⴰ ⴹⵔ ⵜⴹⵓⴰ ⴼⵍ ⴼⵢ ⵏⵢⵔⴹⵏ ⵓⵏ ⵙⵏ ⵙⵏ⵿ⵜⴰ ⵙ ⴹⵏⵜⵎⴶⵔⴹⴰ⵰ ⵜⵂⵏⵢⴰ⵰ ⵎⵔⴹⴰ ⵙⵍⵎⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵎⵔⵏ ⴾⵜⵏⵙⵏ ⵜⴾⵏ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ⵏⵙⵏ ⵢⵈⵢⴰ «ⵓⴹⵏ ⵓⵔ ⵤⴶⵔⵓ ⵔ ⵓⴰ ⵜⴾⴼⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⴶⵢⵎⵢ ⵙ ⵏⵗ \"ⵓⵔ ⵎⵙⵗ ⵍⵎⵙⵈ ⵜⵓⵤⵎⵤⵍ ⵗⵙ ⴹⴶ ⴹⵜⵙ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ⵎⵤⵍⵢ ⴹⴰ ⵍⵏ ⵜⵎⵤⵍⵢⵜ ⵎⵔⵏ ⵎⴹⵏⵜ ⵓⵏ ⵏⴼⵍⵙⵏⵜ ⵏ⵿ⵜⴰ ⵏⵜⴼⵏ ⴹⵤⵤⵍⵢ ⵙⴶⴹ ⴹⵏ ⴹⴰ ⵆⵍⵙ⵰ ⵙ ⵙⵍⴰ ⵢⵎⵙⵍⵢ ⵏⵎⵤⵍⵢ ⴶⵎⵢⴹⵓ ⵜⵎⵤⵍⵢⵜ ⴹ ⴾⵏⵓ ⵜⴹⵓⵜ⵰ ⵜⴹⵓⵜ ⵜⴹⵢ ⵤⴰ ⵏ⵿ⵜⴰ ⴶⵗ ⵎⵔⵏ ⵎⵔⴹⴰ ⵜⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ⵜⵢⵜ ⵜⵓⵙⵗⵎⵔⵏⵜ ⴼⵏⵤ ⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ⵓⴰ ⴹⴶⵎⴹⵏ ⴼⵍⴰ ⵏ⵿ⵜⴰ ⴹⴾⵍⵏ ⴹⵏⴶ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵂⵏ ⴹⵏⵜ ⵏ ⴹⵏⵜ ⵎⵔⵏ ⵔⵜⵏ ⵏⴹⵏⵜ ⵙ ⵜⵎⴶⵔⴹ⵰ ⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⴹⴾⵍ ⴹⵏⴶ ⵓⴹⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ⴶⵢⵜ ⵙⵓⴰ ⵏⵢ ⴹⵓⵙ ⵙⵍⴰ ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵆⵀⵍⵏ ⵜⴶⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ⵓⴰ ⵆⵀⵍⵏ ⵜⴶⵢⵏⵜ ⵙⵍⴾⵏ ⵓⴰ ⵏⴰ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ⴼⵍⵙ ⵓⴰ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵓⵍ ⵏⵎⵛⵏⴰ ⵎⵍ ⴹ ⵎⵛⵏⴰ ⴹⵙⴶⵏ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵂⴾⵢ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ⵀⴰ ⵔⴰ ⵀⵔⵔⵏⵜ ⵎⵔⵏ ⵔⵜⵏ ⴾⵍ ⴶⵏ ⴹⵗ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ⵓⴰ ⵤⴶⵤⵏⵏ ⵙ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵎⵔⵏ ⵓⴰ ⴶⵢⵏ ⵙⵔⵙ ⵤⴶⵤⵏ ⵓⴹⵢ ⵓⵢⴹⵓ ⵙ ⵎⵏⵜ ⵍⵂⵎ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","ⵙⵍⵏ ⴼⵔⵙⵢⵜⵏ ⵙ ⵜⵓⵏⵓ ⵗⵢⵙⴰ ⴶⵔⵓ ⵏⵜⵍⵀ ⴶⵔⵏⵏ ⵓⵏ ⵢⵈⵢⴰ ⵙⵍⵎⵆⵏ ⴹⵗ ⵎⵏ⵰ ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⵙ ⵗⵢⵙⴰ ⵎⵏⵜ ⵓⵔ ⵙⵍⵎⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⵎⵏ ⵏⵜⵍⵀⵏⵜ ⵙⵍⵎⵗⵏⵏ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ⵰ ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢⵓⴰ ⵜⵆⵍⵏ ⴶⵎⴹ ⵎⴹⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⵆⵍ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ⴹⴹ ⵜⵍⵤⵎ ⵎⵔ ⵏⵎⴹⵍ ⵓⵏ ⵙⵎⵔⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ⵛⴾⵍ ⵂⵔ ⵓⴹ ⵗⵔⵎ ⵢⵏ ⵏ⵿ⵙⵎⵔⵢⴰ ⴶⵏ ⵙⵎ ⵛⵈⵔ ⴹⴶⵎⴰ ⵏ⵿ⵜⵓⴶⵙ⵿ⵜ ⵜⴰ ⴾⴼⴰ ⵢⵆⵀ ⵀⵔⵔⵏⵜ ⵢⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ⴹⴶ ⵓⵏ ⵏ⵿ⵜⴰ ⵂⴰ ⵗⵔⵙ ⵏⵢⵆⵀ⵰ ⵙ ⵜⴹⵓⴹ ⵗⵢⵙⴰ ⴹⵤ ⵛⴾⵍ ⵜⵤⵔ ⵆⵎ ⴼⵍ ⵎⵢ ⵏⵗⵔⵙ ⵜⴶⵓ ⵓⵏ ⵎⵙⵏⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","ⵙ ⴾⵏ ⵏⵜⵍⵀⵏⵜ ⵗⵔⵎ ⵢⴹ ⴹⵤⵏ⵿ⵤⵏ ⵎⵏ⵿ⵙⵓⵏ ⵜⵓⵔⴹⵓ ⵜⵏ⵿ⵜⵜ ⵏ⵿ⴾⵍⵙⵎⵔⵢⴰ ⴹⵜⵤⵔⴶⵜ ⵏⵏ⵰ ⵏⵙ ⵗⵢⵙⴰ «ⵛⵛⵓⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ⵜⵏⵙ «ⴾⵢ ⵜⵎⵙⵗ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵜⴶⵎⵢⴰ ⴹⵗⵢ ⵎⵏ ⵏⴾ ⵜⵎⵙⵜ ⵢⵜ ⴹⵗ ⴾⵍⵙⵎⵔⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ⵏⵙ ⵗⵢⵙⴰ «ⵏⵔ ⵜⵙⵏⵗ ⵔⵜ ⵓⴰ ⵂⴾⵓ ⵎⵛⵏⴰ ⵜⵙⵏⵗ ⴹⵗ ⵓⴰ ⵎⵙⴰ ⵏⴾ ⵓⴰ ⴾⵎⵜⵏ⵿ⵙⵢⵏ ⵎⵏ ⵏ⵿ⵜⵙⵢ ⵜⵏ⵿ⵙⵢⵗⵜⵏ ⴾⵎ ⴾⴼⵗⵎ⵿ⵜⵏ ⴹⵗ ⵎⵙⵏ ⵓⵏ ⵙⴹⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ⵜⵏⵙ ⵜⵏ⵿ⵜⵜ «ⵛⵈⵏ ⵏⵓ ⵢ ⵤⴶⵔⵏ ⵎⵔⵏ ⴾⵢ ⵓⵔ ⵜⵍⵗ ⴶⴰ ⴹⵗ ⴹⵢ ⵎⵏⵢ ⴹⵤⵜⴶⵔⵓⵗ ⵎⵏ ⵓⵏ ⵙⴹⵔⵏⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ⵛⴶⵔⵜ ⵜⴶⵗ ⵎⵔⵓⵏⵏⴰ ⵢⵆⵀ ⴹⵏⵗⴾⴼⵏ ⵏⵓ ⴰ ⵛⵓⴰ ⵎⵏⵜ ⵛⵓⵏ⵿ⵜⵏ ⵎⴹⵏⵙ ⴹⵂⵔⵢⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ⵏⵙ ⵗⵢⵙⴰ «ⵢ ⵛⵓⵏ ⵎⵏ ⴹⵢ ⴹ ⵜⵍⵙ ⴼⴹ ⴶⵤ ");
INSERT INTO ttqt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ⵎⵛⵏ ⵢ ⵛⵓⵏ ⵎⵏ ⵓⵏ ⵜⵤⴾⴼⴰ ⵓⴹⵢ ⵎⵤⵢ ⴹⴼⴹ ⴼⵍⵙ ⴹⵗⵙ ⵆⵍⵏ ⴹⵔⵢ ⵏ⵿ⴶⵢⵏ ⵙⵎⵏ ⵓⵏ ⵂⴾⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ⵜⵏⵙ ⵜⵏ⵿ⵜⵜ «ⵛⵛⵓⴹⵓ ⴹⵗ ⵎⵏ ⵓⵏ ⴹⵢ ⴼⵍ ⴹⴶⵎⴹ ⴼⴹ ⵎⵤⵢⴰ ⴹⵤⵔⴶ ⵏⵏⵓ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","«ⴶⵍ» ⵏⵙ ⵗⵢⵙⴰ⵰ «ⵗⵔⴹⵓ ⵍⵙⵏⵎ ⵜⵆⵍⵗⴹⵓ ⴹⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ⵜⵏⵙ «ⵓⵔ ⵍⵗ ⵍⵙ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⵜⴹⵜⵏⵎ ⵙ ⵜⵏ ⵓⵔ ⵜⵍⵗ ⵍⵙ ");
INSERT INTO ttqt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ⴼⵍⵙ ⵙⵎⵙ ⵙ ⴾⵍⴰ ⵜⵏ⵿ⵜⵍ ⵎⵔⵏ ⵓⴰ ⵗⵔ ⵜⵍⵗ ⵎⵔⴹⴰ ⵓⵔⴶⵗ ⵍⵙⵏⵎ⵰ ⵜⴹⵜ ⴹⵜⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ⵜⵤⵔ ⵜⵏⵙ «ⵂⵏⵢⵗ ⵙ ⴾⵢ ⵏⵀⵢ ⵜⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ⵎⵔⵓⵏⵏⴰ ⴹⵗⵗ ⴹⴰ ⴼⵍ ⵗⵀⴹⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⴾⵓⵏⵢ ⴾⵍⵍⵢⵂⴹ ⵜⵏⵎ ⵢⵔⵙⵍⵎ ⵂⴰ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵓⵗⵀⴹ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","«ⵜⵏ⵿ⵜⵜ» ⵏⵙ ⵗⵢⵙⴰ «ⵤⴶⵤⵏⵢ ⵍⵓⵆ ⵤⵢⴹⵓ ⴹⵗ ⵓⵔ ⵤⴰ ⵜⵗⵀⴹⵎ ⵀⴰ ⴶⵔ ⵤⴰ ⴼⵍ ⴹⵗⵗ ⵓⴰ ⵓⵍⴰ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ⴾⵓⵏⵢ ⴾⵍⵙⵎⵔⵢⴰ ⵓⵔ ⵜⵤⴹⵢⵎ ⵓⴰ ⵜⵗⵀⴹⵎ ⵏⴾⵏⵢ ⴾⵍⵍⵢⵂⴹ ⵏⵤⴹⵢ ⵓⴰ ⵏⵗⵀⴹ ⴼⵍⵙ ⴼⵙⵏ ⴶⵤ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ⵎⵛⵏ ⵍⵓⵆ ⵤⵢⴹⵓ⵰ ⵎⵔⵏ ⵙⴹⵓ⵰ ⵓⵙ ⵏⵗⵀⴹⵏ ⵓⵏ ⵜⴹⵜ ⴹ ⵗⵀⴹⵏ ⵀⴰ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⴹⵜ ⴼⵍⵙ ⵀⴰ ⵏⵗⵀⴹⵏ ⵓⵏ ⵜⵗⵀⴹⵏⵏ ⵙ ⵜⵎⵓⵜ ⵜⴹⵢ ⵏ⵿ⵜⵏⵢ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ⵎⵛⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵙ ⵎⵔⵏ ⵏⵗⵀⴹⵏⵜ ⵍⵤⵎ⵿ⵜⵏ ⴹ ⵜⵗⵀⴹⵏ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ⵜⵏⵙ ⵜⵏ⵿ⵜⵜ «ⵙⵏⵗ ⵙ ⵍⵎⵙⵈ ⵜⵓⵏⵙ ⴾⵔⵙ⵿ⵜⵙ ⴹⵙⵓ⵰ ⵙ ⴹⵙⴰ ⴹⵏⵗⵙⵙⴶⵔⵓ ⵔⵜⵏ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ⵏⵙ ⵗⵢⵙⴰ «ⵏⴾ ⵜⵎⵙⵏ ⵏⴾ ⵓⴰ ⴹⵎⵛⵓⵍⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ⵙⵗⵜ ⵜⵏ ⴹⴰ ⴹⵆⵍⵏ ⵏⵜⵍⵀ ⵆⵏⵙⵏ ⵗⴼ ⵎⵛⵓⵍ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⵜⵏ⵿ⵜⵜ⵰ ⵎⵛⵏ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵂⵍⵏ ⴹ ⵜⵙⵙ⵿ⵜⵏ ⵏⵙ «ⵎⴰ ⴹⵗⵙ ⵜⵔ⵰» ⵎⴹⵗ «ⵎⵙ ⴹⵔⵙ ⵜⵎⵛⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ⵜⵤⵔ ⵜⵢⴹⵓ ⵜⵏ⵿ⵜⵜ ⵜⴾⵏⵜ ⵜⵆⵍ ⵗⵔⵎ ⵜⵏⴰ ⵢⵢⵜⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ⵢⵓⵜ ⴹ ⵜⵏⵢⵎ ⵓⴹⵏ ⴹⵎⵍⵏ ⵔⵜ ⴾⵍ ⵓⵙ ⴾⵍⴰ ⴹ ⵜⴶ ⴼⵔⴶ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ⵜⵤⵔ ⴶⵎⴹⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵗⵔⵎ ⴾⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ⵙ ⵜⴶⵓ ⵓⵏ ⵏⵜⵍⵀ ⴶⵎⵢⵏ ⴹⵗ ⵗⵢⵙⴰ ⴹ ⵜⵛⵓ ⴶⵏⵏⵙ «ⵛⵈ ⵜⵛⵓ ⵔⵜ ⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ⵏⵙⵏ «ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵤⵜⵛⴰ ⵓⵔ ⵜⵏ⵿ⵜⵤⴹⵢⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ⴹ ⵜⵏⵎⵏⵏ ⵏⵜⵍⵀ ⴶⵔⵙⵏ «ⵏ⵿ⴶⵎ ⵗⵙ ⵓⵔⴶⵗ ⵓⴹⵏ ⵢⵏ ⴹⵙⴹⵓⵢⵏ ⵎⵏ⵿ⵙⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵏ⵿ⵙⵓⵏⵏ ⵓⵔ ⵜⵏⵎⵙ ⵔ ⴹ ⵎⵤⵍⴰ ⵜⵔⴰ ⵏⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵗⵔⴹⵗ ⵛⵗⵍ ⵓⴰ ⴹⵗⵢ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ⵓⴾ ⴾⵓⵏⵢ ⵓⵔ ⵜⴶⵏⵎ \"ⵆⵎⵏⵜⵏ ⴾⵤⵜ ⵜⵍⵍ ⵢⴹ ⵜⴶⵓ ⵗⵔⵜ⵰\" ⵏⴾ ⵤⴰ ⵏⵗⵓⵏ ⴾⵏⵓⵜ ⵤⴶⵤⴹⵢ ⵏ⵿ⵜⵓⴶⵙ ⴹ ⵜⵏⵢⵎ ⵙ ⵛⵗⵗⵏⵏ ⵑⵏⵜ ⵓⵔ ⵔⵏⵜ ⵔ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ⵓⴹⵏ ⵓⴰ ⵜⵍⵢⵏ ⵓⴹⵢ ⴶⵔⵓ ⵔⵤⵎⵜⵏⵜ⵰ ⵛⵗⵗⵏⵏ ⵛⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵛⴹⵓ ⴼⵍ ⴹ ⵌⵢⵜ ⵓⴰ ⵏⵀⵍⵏ ⴹⵓⴰ ⵜⵍⵢⵏ ⵜⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ⴼⵍⵙ ⵜⴹⵜ ⵏ⵿ⵜⵎⵌⵆ ⵜⴰ ⵜⵏⵜ \"ⵍⵙ ⵢⵏ ⵏⵀⵍ ⵢⵏ ⵜⵍⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ⵙⴶⵍⵆⵓⵏ ⴼⵍ ⴹ ⵜⵍⵢⵎ ⵜⵓⴶⵙ⵿ⵜ ⴹⵗ ⵓⵔ ⵜⵛⵗⵍⵎ ⵢⵜⴹⵏ ⵓⵢⴹ ⴹⵗⵙ ⵛⵗⵍⵏⵏ ⵎⵛⵏ ⵜⴶⵔⵓⵎ ⵜⵏ⵿ⴼⴰ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴶⵏ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏ⵿ⴾⵍⵙⵎⵔⵢⴰ ⵙ ⵗⵢⵙⴰ ⴼⵍⵙ ⵜⵏ⵿ⵜⵜ ⴹⵙⵏ⵿ⵜⵏⵜ «ⵎⵍⵢ ⵔⵜⵏ ⵓⵏ ⵙ ⴾⵍⴰ ⵜⵏⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ⵓⵏ ⴹⴰ ⴼⵍⵙ ⵙⵏ⵿ⵜⴹⵓ ⵗⵙ ⴶⵎⵢⵏ ⴹⵗⵙ ⵗⵔⵙⵏ ⵆⵎ⵰ ⵆⵎ ⵗⵔⵙⵏ ⵗⵢⵙⴰ ⵂⵔ ⴶⴰ ⵛⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ⵙⵍⵏ ⵢⵜⴹⵏ ⵢⵓⵍⵏⵜ ⵤⴶⵤⵏⵏ ⵙⵔⵙ ⵓⵢⴹ ⴶⵔⵏⵏ ⵓⵏⴹ ⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ⵜⵤⵔ ⵏⵏ ⵢ ⵜⵏ⵿ⵜⵜ «ⵏⴾⵏⵢ ⵙⴾⵜ ⵏⴾⵏⴰ ⵤⴶⵤⵏ ⴼⵍⵙ ⵙ⵿ⵜⵤⵔⵜ ⴾⵎ ⵗⵙ ⴹⵏⵗⴶⵏ ⵙⵍⵏ ⵎⵔⴹⴰ ⵎⵏⵏⴰ ⵙ ⴹⵙⵏⵙⵍⴰ ⵎⵔⵏ ⵏⵙⵏ ⵙ ⵜⴹⵜ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵏⵙⴼⵙⵢ ⵏⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ⵙ ⵏ⵿ⴹⵏ ⵛⵏ ⴹⵏ ⵓⵏ ⴹⵏ ⴾⴰ ⵗⵢⵙⴰ ⵎⴹⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙ ⵏⴰ ⵏⵀⵢ ⵓⵔ ⵜⵓⵙⵗⵎⵔ ⴹⵗ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ⵙ ⴹⵏⵙⴰ ⴶⵍⵍⵢⴰ ⵆⵀⵍⵏ⵿ⵜⵓ ⴾⵍⴶⵍⵍⵢⴰ ⴹ ⵏⵢⵏ ⵎⵤⵍⵏ ⴾⵍ ⵓⵏ ⴶⴰ ⴹⵗ ⵢⵔⵙⵍⵎ ⵗⵔ ⵎⴹ ⵓⵏ ⴾⵢ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵙⵏⵏ ⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ⵍⵙⴹⵓ ⵗⵢⵙⴰ ⵙⴰ ⵏ⵿ⵜⵗⵔⵎ⵿ⵜ ⵏ⵿ⴾⵏⴰ ⵜⵏ ⴶⵍⵍⵢⴰ ⵜⴰ ⴹⵗ ⵙⵎⵜⵢ ⵎⵏ ⴶⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ⵰ ⵍⵢ ⵍⵙ ⵎⵙⵏ ⵎⵛⵗⵍ ⵏⵎⵏⴾⵍ ⴹⵗ ⵜⵗⵔⵎ⵿ⵜ ⵏ⵿ⴾⴼⵔⵏⵂⵎ⵰ ⵍⵙ ⵍⴰ ⵀⵔⵔⵏⵜ ⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ⵙ ⵙⵍⴰ ⵙ ⵗⵢⵙⴰ ⴶⵎⴹⵓ ⵎⴹⵍ ⵏⵢⵂⴹⵢⴰ ⵂⴰ ⴶⵍⵍⵢⴰ ⵙⵢⴹⵓ ⵏ⵿ⵙⵢⵜⵓ ⴹ ⴹⵓⵏ ⴹⵙⵤⵤⵢ ⵀⵔⵔⵏⵜ ⵗⵔ ⵜⵍⴰ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ⵏⵙ ⵗⵢⵙⴰ «ⵙ ⵓⵔⴶⵗ ⴹ ⵜⵏⵢⵎ ⵍⵗⵍⵎⵜⵏ ⵎⵜⵢⵏⵏ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵓⵔ ⵤⴰ ⵜⵤⴶⵤⵏⵎ ⴼⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ⵏⵙ ⵎⵛⵗⵍ ⵏⵎⵏⴾⵍ «ⵎⵍⵢ ⵔⵙⵏⵗ ⵙ ⴾⴼⵔⵏⵂⵎ ⵜⵔⵎⴹ ⵂⵔⵓⴰ ⴹ ⵓⵔ ⵀⴰ ⵀⵔⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ⵏⵙ ⵗⵢⵙⴰ «ⴶⵍⵓ ⵀⵔⵔⵏⴾ ⵤⵢ⵰» ⵍⵙ ⴹⵗ ⵤⴶⵤⵏ ⵙⵓⵍ ⵏ⵿ⵗⵢⵙⴰ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ⵂⴰ ⵜⵔⵢⵜ ⵆⵍ ⵙ ⵎⵏⵢ ⴹⵎⵛⵗⵍⵏⵜ ⴹⵙⴹⵍⴾⵎⵏⵏ⵰ ⵏⵏⵙ «ⵀⵔⵔⵏⴾ ⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⴶⵔⵓ ⵎⵏⵜ⵰» ⵏⵏⵙ «ⵏ⵿ⴹⵤⵍ ⴶⵢ ⵏ⵿ⵜⵤⵔ ⴼⵍⵙ ⵜⵓⵜ ⵜⵏⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ⴾⵜⴹⵓ ⵍⵙ ⵙ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵎⵏⵜ ⴹⵗⵙ ⵏⴰ ⵗⵢⵙⴰ «ⵀⵔⵔⵏⴾ ⵤⵢ⵰» ⵤⴶⵤⵏ ⵙⵔⵙ ⵏ⵿ⵜⴰ ⴹⵗⵢⵓⵏⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵎⵙⵜ ⵍⵗⵍⵎⵜ ⵜⵏ ⵙⵏⵜⵜ ⵎⵤⵍ ⵗⵢⵙⴰ ⴹⵗ ⴶⵍⵍⵢⴰ ⴹⴼⵔ ⴶⵎⴹⵏⵜ ⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ⴹⴼⵔ ⴹⵢ ⵓⴹⵓ ⵎⴹ ⵢⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵤⵔ ⴾⴰ ⵗⵢⵙⴰ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ⵗⵔⵎ ⵓⵏ ⵢⵔⵙⵍⵎ ⵜⵂⵢ ⵜⵗⵤⵔ⵿ⵜ ⵜⵂⵤⵜ ⴹⴶ ⵓⵙ ⵜⵓⵏⵓ ⵜⵙⵂⵔ⵿ⵜ ⵜⵏ ⵢⴼⴹ⵰ ⵜⵗⵤⵔ⵿ⵜ ⵜⴰ ⵙⵎⵏⵜ ⵀⵜⵙⴹⴰ ⴹⵗ ⵜⵍⵗⵀⵔⵜ ⵎⵔⵏ ⵜⵍⴰ ⴶⵔ ⵙⵎⵙⵜ ⵜⵍⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ⵜⵍⵓⵏ ⵛⵏ ⵙⵔⴹⵏ ⴹⵓⵙⵏⵜ ⵎⵔⵏⵏ ⴶⵏⵏ ⴹⵗ ⵎⴹⵔⵗⵍ ⴹⵎⴶⴹⵍ ⴹⵏⵀⴹⵏ⵰ ⵙⴶⴹⵏ ⵢⴹ ⴶⵤⵏ ⵎⵏ ⵛⵏ ⵎⵜⴾⵓⵢ ");
INSERT INTO ttqt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ⴼⵍⵙ ⵎⵍ⵿ⵜⵓ ⵍⵓⵆ ⴹⵗ ⴹⵜⵤⵀⵜ ⵏ⵿ⴶⵍⵙ ⵢⵏ ⵏⵎⵍⵢ ⵌⵏⵌⵔⵓⵢ ⵎⵏ ⵏ⵿ⵜⵗⵤⵔ⵿ⵜ ⵜⵏ⵰ ⵎⵔⵏ ⴾⵍ ⵓⴰ ⵤⵔⵏ ⴶⵤⵏⵜ ⴹⴼⵔ ⵏⵌⵔⵓⵢ ⵓⴰ ⵜⴶⴰ ⴹⴰ ⵓⴹⵢ ⴹ ⵤⵢ ⴹⵗ ⵜⵓⵔⵏⴰ ⵜⴰ ⵜⵜⴶⵔⵓⵜ ⵜⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ⴹⴶⵏ ⵂⵢ ⵍⵙ ⴶⵏ ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴹⵜⵎ ⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ⴶⵢ ⵗⵢⵙⴰ ⵙⵔⴹ ⵎⵔⵏ ⵙⵏ ⵙ ⴶⴰ ⵜⵓⵔⵏⴰ ⵜⵔⵓⵜ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ «ⵓⴾ ⵜⵔ ⵜⵎⵤⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ⵏⵙ ⵎⵔⵏ ⵓⴰ «ⵛⵈ ⵏⴾ ⵓⵔ ⵍⵗ ⵓⴹⵏ ⴹⴶⵏ ⴹⵗ ⵜⵗⵤⵔ⵿ⵜ ⵜⴰ ⴹⵗ ⵎⵤⵢ ⵓⴰ ⴹⵗ ⵜⵏⵌⵔⵓⵢⵏ ⵎⵏⵜ ⵎⵔⵏ ⴹ ⴶⵎⵢⴰ ⴹⴶⵤⵏⵜ ⴹⵤⵔ ⵙⵔⵙ ⵓⴹⵏ ⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ⵏⵙ ⵗⵢⵙⴰ «ⵀⴹⴹ ⵜⴹⴾⵍⴰ ⵜⵙⵜⵏⴾ ⵜⵌⵓⵏ⵿ⴾ» ");
INSERT INTO ttqt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ⵤⵢ ⵍⵙ ⵓⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⴾⵍ ⵜⵙⵜⵏⵜ ⵌⵓⵏ⵿ⴾⵜ⵰ ⵏ⵿ⵜⴰ ⵔⵜ ⵓⴰ ⵜⴶⵓ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ⵏⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵢⵍⵙ ⵓⴰ ⵤⵢⵏ ⴹⴰ «ⴾⵢ ⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵗ ⵙ ⵤⵍⴹⴰ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴹⵗⴾ ⵓⵔ ⵈⵍⵍ ⴶⵢ ⵏ⵿ⵜⵙⵍⵜⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ⴶⵙ ⵢⴰ ⵏⵙⵏ ⵍⵙ ⵓⵏ «ⵍⵙ ⵓⴰ ⴹⵤⵤⵢⵏ ⵏ⵿ⵜⴰ ⴹⵏⵏ \"ⴹⴾⵍ ⵜⵙⵍⵜⵏⴾ ⵜⵌⵓⵏ⵿ⴾ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ⵏⵏⵙ «ⵎⴰ ⵎⵙ ⵤⴰ ⵍⵙ ⵓⴰ ⴹⴾⵏⵏ \"ⴹⴾⵍ ⵜⵙⵍⵜⵏⴾ ⵜⵌⵓⵏ⵿ⴾ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ⵏ⵿ⵜⴰ ⵍⵙ ⵓⴰ ⵤⵢⵏ ⴹⴰ ⵓⵔ ⵜⵂⵏ ⵙⵍⵏ ⵏⵓⴰ ⵎⵙ ⵓⴹⵏ ⵓⴰ ⵜⵤⵤⵢⵏ ⴹⵏ ⴼⵍⵙ ⵢⵜⴹⵏ ⴾⵏⵏⵏ ⴶⵜ ⵂⵏⵏ ⴹⴶ ⵓⴰ ⴹⵆ ⵤⵤⵢ ⵗⵢⵙⴰ ⴹⵏ ⵔⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵌⵓⵏ⵿ⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ⴹⴼⵔ ⵓⵏ ⴶⵤⵜⵏ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵙ «ⵙⵙⵎ⵰ ⴾⵢ ⴹⴰ ⵤⵢⵏ ⴹⴰ ⵎⵔⴹⴰ⵰ ⵗⵔⴹ ⴹⴶⵢ ⵏⵀⴾⴹⵏ ⴾⵢ ⵓⵔ ⴶⵔⵓ ⵔⵜ ⴶⵔⵏ ⵓⵏⴹ ⵜⵍⵀⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ⵌⵓⵏ⵿ⴾⵜ ⵍⵙ ⵓⵏ ⵜⵤⵔ ⵎⵍ ⵢ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙ ⵗⵢⵙⴰ ⵜⵤⵤⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ⵔⵜ ⵓⴰ ⵓⵢⴹⵓ ⵙⵔⵙⵏ ⵙ ⴾⵏⵏ ⴶⵤⵔ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍⵙ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴹⵗ ⴶⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵀⵏⵏ ⴼⵓ ⴹⴰ ⵛⵗⵍ ⴹⵗ ⴹⵢ ⵏⴾ ⴹⴰ ⵛⵗⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ⵀⵜⵓ ⵜⴰ ⵜⵓⵢⴹⵓ ⵙ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙ ⵛⵜⵏ ⴹⵗ ⴶⵎⵢ ⵏ⵿ⵜⵏⵗⵢ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍⵙ ⵓⵔⴶⵗ ⵍⵆⵏⵏ ⵏⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵗⵙ ⵎⵤⵔⵢ ⴾⵍⵔ ⵛⵜⴹⵓ ⴼⵍⵙ ⵙ ⵏⴰ ⵎⵙ ⵎⵛⵏⴰ ⵀⵏⵜ⵰ ⴹⵗ ⴹⵢ ⵛⵛⴶⴹⴰ ⵎⵏⵜ ⴹⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵀⵔⵔ ⵓⵔ ⴼⵔⴶ ⴶⵢ ⵏⵔⵜ ⵓⵍⵢⵏ ⴶⵔⵙ ⴹⵎⵏⵜ⵰ ⵓⵔ ⵜⴶⵓ ⵔ ⵔⵜ ⵓⵙ ⵂⵏⵢ ⵀⵏⵜ ⵜⴶⵢ⵰ ⵎⵔⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⴶⵓ ⵀⴰ ⵀⵔⵔ ⴹⴰ ⵜⴶⵢ ⵙⵙⵓⵢ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ⴼⵍⵙ ⵀⴰ ⵔⴰ ⵀⵔⵔ ⵎⵔⵏ ⵙⴾⵏⵢ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⴶⵓ⵰ ⴹ ⵜⵙⴾⵏⵓ ⵔⵜⵏ ⴶⵔⵏⵏ ⵓⵏ ⴹⴰ ⵜⵍⴰ ⵏⵍⵎⵗⵏⴰ ⵢⵜⵏⴶⵓ ⴼⵍ ⴹ ⵜⵗⵌⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ⵎⴾ ⵓⴰ ⴹⵗⵙ ⴹⵙⵏ⵿ⴾⵔ ⵀⴰ ⵏⵎⵜⵏ ⵜⴶⵓ ⴹⵗⵙⵏ ⵎⵏ ⵎⴾ ⵓⴹⵢ ⴹⴰ ⵙ ⵂⴾⵓ ⵀⵔⵔ ⵏ⵿ⵜⴰ ⴹⴰ ⵜⵎⴹⵔ⵿ⵜ ⵢ ⵓⵙ ⵜⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ⵓⴰ ⴹⴼⵔ ⴹⵢ ⵙ ⵀⴰ ⵓⵔ ⵈⴾⵎ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴾⵍⵔ ⵛⵔⵗⴰ ⴾⵍ ⴶⵢ ⴹⵗ ⴼⵙ ⵏⵀⵔⵔ ");
INSERT INTO ttqt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ⴼⵍ ⴹ ⵤⵤⵓⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵀⵔⵔ ⵙⵎⴾ ⵓⵙ ⵤⵤⵓⵔⵏ ⵀⴰ⵰ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵤⵤⵓⵔ ⵀⵔⵔ ⵓⴹⵢ ⵓⵔ ⵤⵤⵓⵔ ⵀⴰ ⵓⴰ ⵜⴹⵤⵎⵤⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵙⵎⵏ ⵢ ⵀⵜⵜⵏⵏ ⵤⴶⵤⵏ ⵙ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵓⴹⵢ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⵓⵔ ⵤⵓⴹⵀ ⴾⵍⵔ ⵜⵎⵜⵏ⵿ⵜ ⴹⴶⵎⴹ ⵙ ⵜⵎⴹⵔ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵤⵢⴹⵓ ⵍⵓⵆ⵰ ⵙⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵏⵂⴰ ⴹⴰ ⵎⵔⴹⴰ⵰ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵢ ⵓⵔ ⵏⵤⴶⵤⵏ ⴹ ⵙⵍⵏ ⵢⵎⵙⵍⵢ ⵏⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵔⵏ ⵓⵏ ⴹⵙⵙⵍⵏⵏ ⴾⵓⵏⵏⵙ ⴹ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ⴼⵍⵙ ⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⵂⴾⵓ ⵀⴰ ⵜⵎⴹⵔ⵿ⵜ ⵎⴾ ⵓⴹⵢ ⴹⵗ ⵙ ⴾⴼⴰ ⵀⵔⵔ ⴼⵔⴶⵜ ⵏ⵿ⵜⵜⵂⴾⵓ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ⴾⴼⵢ ⴹⵗ ⵜⵔⴶⵜ ⵏⵛⵔⵗⴰ ⵢⵢⵜⴹⵏ ⴼⵍⵙ ⵏⴾ ⴶ ⴶⴹⵎ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ⴹ ⵓⵔ ⵆⵏⵏ ⵗⴼⵓⵏⵓⵏ ⵢⵔⵜ ⵓⴰ ⵍⴾⵎ ⴹⵓⴹ ⵍⵓⵆ ⴹⵗ ⵤⵙⵍⵏ ⵏⵎⵜⵏ ⴾⵍ ⴹⵗ ⵤⴾⵓⵏⵙⵏ ⵢⵎⵙⵍⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ");
INSERT INTO ttqt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ⴶⵎⴹⵏ⵿ⴹⵓ ⵤⴾⵓⵏⵙⵏ ⴹⵢ ⴹⴰ⵰ ⵓⵏ ⴶⵏⵏ ⵔⵜⵏ ⵍⵗⵏⵏ ⴹⴶⵎⴹⵏ ⵤⴾⵓⵏ ⵢⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵓⵏ ⴶⵏⵏ ⵜⴾⵎⴰ ⵎⵔⵏ ⴹⴶⵎⴹⵏ ⵤⴾⵓⵏ ⵢⴹ ⵓⴹⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵙ ⴼⵔⴶⵗ ⴶⵏⵜ ⴶⵔⵢ ⴹⵎⵏⵏ⵰ ⵛⵔⵗⴰ ⵓⴰ ⵜⴶⴰ ⵍⴾⵎⴰ ⴹⵗⵙ ⵢⵓⴰ ⴹⴶⵏⵓ ⵎⵛⵏⴰ ⵎⵔⵏ ⵛⵔⵗⵏⵏ ⵗⴹ ⴼⵍⵙ ⵓⵔ ⵍⴾⵎⴰ ⵢⵔⵜ ⵓⴰ ⵔ ⵏⴾ ⵎⵏⵏ ⴾⵍⵔ ⵔⵜ ⵓⴰ ⵔⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵙ ⵍⴾⵎⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«ⵙ ⵎⵙ ⵙ ⵏⴾ ⵗⵙⵏ ⵙ ⴶⵢⵗ ⵢ ⵎⵏⵏ ⵓⴹⵢ ⵜⴶⵢⵏⵏ ⵓⵔ ⵜⵎⵙ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ⵍⵜⵓ ⵓⴰ ⴹⵎⵙⵏ ⵢⵜ ⵜⴶⵢⴰ ⵎⵔⵏ ⵙⵏⵗ ⵙ ⵔⵜ ⵓⴰ ⴶⵏⵓ ⴹⵗ ⵜⵍⵗⵏⵏ ⵜⴹⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ⵜⵙⴶⵍⵎ ⵏⵎⵤⵍⵏ ⵙ ⵢⵈⵢⴰ ⴶⵢⵜⵙⵏ ⴼⵍ ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ⵏⴾ ⵓⵔ ⴹⵔⵔⵗ ⵙ ⵜⴶⵢⴰ ⵏⵓⴹⵏ⵰ ⵔⵜ ⵓⴰ ⵓⵔ ⵜⴶⵏⵗ ⵔ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⵜⵙⵔⴼ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ⵢⵈⵢⴰ ⵤⵏ ⴼⵜⵍⴰ ⵜⵔⵗⵜ ⵜⵀⵍⵤⵍⵤ ⵎⵙ ⵎⵔⵏ ⵜⵆⵀⵍⵎ ⴹ ⵜⴶⵎ ⵔⵜ ⵏⵙⵗⵜ ⵏ⵿ⵜⴹⵓⵜ ⴹⵗ ⵏⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ⵏⴾ ⵎⵔⵏ ⵍ ⵜⴶⵢⴰ ⵜⴶⵔⵜ ⵜⵏ ⵢⵈⵢⴰ ⵙⵂⵜ ⵛⵗⵍⵏ ⵓⵏ ⵜⴶⴰ ⵜⵏⵎⵙⵏ ⵓⵏ ⵙ ⴹⵙⵓⵔ ⵀⴰ ⴶⵏⵙⵏ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵜⴶⵢⵏⵏ ⵙⵜⴹⵏ ⵙ ⵀⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ⵀⴰ ⵎⵏⵜ ⵙⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⵢⵜⵢ⵰ ⵓⵔ ⴾⵍⴰ ⴹ ⵜⵙⵍⵎ ⵢⵎⵙⵍⵏⵜ ⵓⵍⴰ ⴹⵗ ⵜⵏⵢⵎ ⵤⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ⵎⵔⵏ ⵓⵔ ⵂⴰ ⵓⵍⵏⵜ ⵓⵍⵏⵓⵏ ⵔⵜ ⵓⴹⵢ ⵙⵜⴹⵢ ⵀⴰ ⵏⵤⴶⵤⵏⵓⵏ ⵙ ⵓⴰ ⴹⵤⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ⵜⵜⴶⵎ ⵢⵓⵍ ⵏⵎⵛⵏⴰ ⵜⵗⵔⵢ ⵜⴶⵜ ⵙⵏⵤⵔ ⴼⵍⵙ ⵜⵗⵍⵎ ⵙⵔⵙ ⵜⴶⵔⵓⵎ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⵓⵍ ⵓⴰ ⵜⵗⵔⵎ ⴹⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙ ⴼⵍⵢ ⴶⵢⵜ ");
INSERT INTO ttqt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ⴶⵙ ⵓⵔ ⵜⵔⵎ ⴹⴹⵜⴾⵎ ⵢⴹ ⵜⴶⵔⵓⵎ ⵜⵎⴹⵔ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«ⵏⴾ ⵓⵔ ⴶⵎⵢⵗ ⵜⵓⵙⵗⵎⵔ ⵗⵔ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ⵤⴹⵢⵆⵓⵏ ⵙⵏⵗ ⵙ ⵎⵏⵓⵏ ⵓⵔ ⵜⵏ⵿ⵜⵂⴰ ⵜⵔⴰ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ⵏⴾ ⵀⵏⵏ ⴹⴹⵙⴶⵍⵏ ⵎⵛⵏ ⵓⵔ ⵜⵔⵎ ⵍⵆⵀⵍⵜⵏ⵰ ⵎⵔⵏ ⵙ ⴾⵓⵏ ⴹⵙⴰ ⵓⴹⵏ ⵢⵏ ⴹⴶⵍⵏ ⴶⵔⵙ ⴹⵎⵏⵜ ⵜⵜⵆⵀⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ⵜⵔⵎ ⴹ ⵜⵜⵏⵎⵙⵗⵎⵔⵎ ⴶⵔⵓⵏ ⴶⵙ ⵓⵔ ⵜⵔⵎ ⵙⵗⵎⵔ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵢⵏ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ⴹ ⵓⵔ ⵜⵗⵍⵎ ⴾⵓⵏⵙⵓⵔⴰ ⵍⵂⵏ ⵗⵔ ⵀⵏⵏ⵰ ⵏⵀⵢ ⵎⵙⴰ ⵏ⵿ⵜⴰ ⴾⵓⵏ ⵤⵙⵓⵔⵏ ⵍⵂⵏ ⵏ⵿ⵜⴰ ⵓⴰ ⴹⵗ ⵜⴶⵎ ⵜⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ⵏⵔ ⵜⵤⴶⵤⵏⵎ ⵙ ⵎⵙⴰ ⵜⵤⴶⵤⵏⵎ ⵙⵔⵢ ⵏⴾ ⴹⴰ ⴼⵍⵙ ⵎⴶⵔⴹ ⵙⵔⵢ ⴹⵗ ⵍⴾⵜⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ⵎⵛⵏ ⴹⴹ ⵎⵙ ⵙ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵙⵍⴾⵜⵀⵏⵜ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵤⴶⵤⵏⵎ ⵓⴰ ⴶⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ⴹⴼⵔ ⴹⵢ ⴾⴰ ⵗⵢⵙⴰ ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵓ ⵓⵏ ⴶⵍⵍⵢⴰ ⵜⵓⵏⵙ ⴹⵗ ⴶⵔⵓ ⵓⵏ ⵜⵀⵔⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⴼⵍⵙ ⵂⵏⵢⵏ ⵢⵜⴹⵏ ⵍⵗⵍⵎⵜⵏ ⵛⵏ ⵙ ⵜⵎⵤⵍ ⵎⵙⵏⵏ ⵎⴾ ⵓⵙ ⵤⵤⵢ ⵎⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ⴶⵤⵢ ⵗⵢⵙⴰ ⴹⵗⵗ ⵜⵤⵔ ⵆⵎ ⴹⵏ ⴹⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⴹ ⵓⵏ ⴾⵢ ⵂⵤⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ⵙⵓⴹ ⵗⵢⵙⴰ ⵏⵢ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⵤⵢⵜⴹⵓ ⵏⴰ ⵢ ⴼⵍⵀⵙ «ⵎⵏⵢ ⴹⵤⵏⵤⵏ⵿ⵤⵓ ⵜⴶⵍⴰ ⵜⵛⵏ ⵢⵜⴹⵏⵏ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ⵙⵙ⵿ⵜⵏ ⵓⴰ ⵙ ⵜⴶⴰ ⵗⵢⵙⴰ ⴹⴰ ⵙⵏ ⵔⵜ ⵓⵙ ⵜⵙ ⴶⵏⵜ⵰ ⵔⴰ ⵗⵙ ⴹ ⵙⵏ ⵓⴰ ⴹⵙⵤⵏⵓ ⴼⵍⵀⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ⵏⴰ ⴼⵍⵀⵙ ⵢ ⵗⵢⵙⴰ «ⴾⴹ ⴹⵏⵤⵏ⵿ⵤⴰ ⵜⴶⵍⴰ ⵏ⵿ⵙⵏⵜⵜ ⵜⵎⴹ ⵏ⵿ⵜⴼⵍ⵿ⵜ ⵍⵎⵗⵏⴰ ⵍⵈⵆ ⵏ⵿ⵙⵏⵜⵜ ⵜⵎⴹ ⵏⵤⵍ ⵏⵛⵗⵍ ⴹⴰ ⵓⵔ ⴹⵙⵏ⵿ⵜⴾⵏⴰ ⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ⵏⵙ ⵏⵜⵍⵀⵏⵜ ⴶⵏ ⵏ⵿ⴹⵔⵓⵙ ⵓⵏ ⵎⴹⵔⵢ ⵏ⵿ⵙⵎⵗⵏ ⵀⵜⵔⵙ ");
INSERT INTO ttqt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ⵍⴰ ⵀⵔⵔ ⴹⴰ ⵍⵏ ⵙⵎⵙⵜ ⵜⴶⵍⵓⵏ ⵏⵛⵗⵔ ⴹⵛⵏ ⴾⴼⵜⵏ ⵎⵛⵏ ⵢⴰ ⵎⴰ ⵤⴰ ⴾⵏⵏ ⵢⵢⵜⴹⵏ ⴶⴹⵏⵏ ⴹⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ⵏⴰ ⵗⵢⵙⴰ «ⵙⵗⵎⵓⵜ ⵜⵎⵜⵢ ⴾⵍ⵰» ⵜⵤⵔ ⵆⵎⵏ ⵢⵜⴹⵏ ⴾⵍ ⴹⵗ ⵢⵍ ⴶⵏ ⵍⵏ ⴹⵏ⵰ ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ ⵂⵏⵏ ⵜⵎⵜⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ⴹⴾⵍⴹⵓ ⵗⵢⵙⴰ ⵛⴶⵍⵓⵏ ⵛⵏ ⴹⵏ⵰ ⵙ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵤⵏ⵿ⵜⵏⵜ ⵢ ⵜⵎⵜⵢ⵰ ⴶⴰ ⵓⵏ ⴹⴰ ⵢ ⴾⴼⵜⵏ⵰ ⴶⵔⵓ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵙⴶⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ⵙ ⵢⵓⵏⵏ ⵢⵜⴹⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵛⴹⵓⵜⴹⵓ ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⵜⵓⴶⵍⵤⵏⵏ ⴼⵍ ⴹⵗⵙ ⵓⵔ ⵗⵛⴹ ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ⵗⵔⴹⵏ⵿ⴹⵓ ⴾⵎⵢ ⵏ⵿ⴾⵔⵎⵜⵏ ⵓⵏ ⴹⴶⵍⵤⵏ ⵢⵜⴹⵏ ⴹⵗ ⵜⴶⵍⵓⵏ ⵏⵛⵗⵔ ⵛⵏⴹ ⵏ⵿ⵙⵎⵙⵜ ⴰ⵰ ⵎⵔⵓ ⵤⵎⵎⵏ ⴹⵛⵏ ⴹⴹⵏⵢⵏ ⴹⵗ ⴶⵍⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ⵙ ⵏⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⵗⵍⵎⵜ ⵜⵙ ⵎⵤⵍ ⵗⵢⵙⴰ ⴹⴰ ⴹ ⴶⵏⵏ «ⴶⵎⴹ ⵛⴾ ⵙ ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵏⵀⵢ ⵓⴰ ⴹⵤⵙⵏ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ⵙⵏ ⵗⵢⵙⴰ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵀⵤ ⵜⵤⴶⵏ ⵛⵂⵛⵍⵏ⵿ⵜⵓ ⵜⵛⵜ ⵏⵎⵏⴾⵍ ⵍⵙ⵿ⵜⵏ ⴼⵍ ⴾⴰ ⴹⴶ ⵢⵏ ⴹⵗ ⴹⵗⵗⵏ ⴹⴰ ⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ⵙ ⵜⴶⴰ ⵜⴾⵙ⵿ⵜ ⵤⴶⴹⵢⵏ ⵏⵜⵍⵀⵏⵜ ⵙⴶⵔⵓ ");
INSERT INTO ttqt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ⴶⵤⵏ ⵗⵍⵍ ⵙⵓⵍⵏ ⴶⵔⵓ ⵢⴹ ⵗⵔⵙⵏ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⴾⴼⵔⵏⵂⵎ⵰ ⵜⴶⵓ ⵓⵏ ⵂⴹ ⵗⵢⵙⴰ ⵎⵔⵏ ⵓⵔ ⵜⵏⵏⵓⴹ ⵂⵔⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ⴶⵔⴹⵓ ⴹⵓ ⵙⵂⵏ ⴹ ⵜⵏⵙ⵿ⵜⵀⵏ ⵎⵏ ⵏⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ⵙ ⴶⵏ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⴹⴶ ⵏ⵿ⵙⵎⵙ ⴾⵍⵓⵜⵏ ⵎⴹⵗ ⵙⴹⵙ ⵏⵛⴾⵍ ⴶⵏ ⵗⵢⵙⴰ ⴹⵗ ⵂⵤ ⵌⵓⵏ⵿ⴾⵜⴹⵓ ⴼⵍ ⵎⵏ ⵤⵢⴹⵓ ⵗⵍⵍ ⵓⴰ ⵂⵏ ⵜⵤⵔ ⵜⴶⵤⵜⵏ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ⵎⵛⵏ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵜⴶⵎⴹⵜⴾⵓⵏ ⵜⵙⴰ ⵏⴾ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ⴶⵎⵢⵏ ⴹⵜⴹⵤⴶⵤⵏ ⵗⵍⵍ ⴹⵏ ⴹⴰ ⵙ ⴹⵔⵙⵏ ⵓⴹ ⵗⵍⵍ ⴹⴶ ⵓⴰ ⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵜⴶⵔⵏ ⵜⵎⵜⵢ ⵜⴰ ⵜⵓⵔⵜ ⴼⵢ ⵏⴶⵔⵓ ⵓⵏ ⵙⵏ ⵙ ⵗⵍⵍ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵍⵏ ⴹⵏ ⵏ⵿ⴹⵤⵍ ⵎⵔⵏ ⵙⵏⵏ ⵙ ⵗⵢⵙⴰ ⵓⵔ ⵏⵎⴶⵤ ⵗⵍⵍ ⵓⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ⵙⵏⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵙ ⵏⵜⵍⵀⵏⵜ ⵗⵙⵏⵙⵏ ⵙ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ⵏ⵿ⵤⵢⵏ⵿ⴹⵓ ⵓⵢⴹ ⴹⴼⵍⵏⵏ ⵗⵔⵎ ⵏ⵿ⵜⵀⵔⵢⴹ⵰ ⵙⵏ⵿ⴹⵓ ⴹⴶⵎⴰ ⵏⴹⴶ ⵓⴰ ⴹⵗ ⵜⵜⵛⴰ ⵜⵎⵜⵢ ⵜⴶⵍⴰ ⴹⴼⵔ ⴶⴹⵏ ⵓⵏ ⴶⴰ ⵗⵢⵙⴰ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ⵙ ⵜⵏⵢ ⵜⵎⵜⵢ ⵙ ⵗⵢⵙⴰ ⵓⵔ ⵍⴰ ⴹⵏ ⵏ⵿ⵜⴰ ⵓⵍⴰ ⵏⵜⵍⵀⵏⵜ ⵜⴶⵤ ⵗⵍⵍⵏ ⵓⵏ ⴹⵏ ⴶⵎⵢⵏ ⵗⵢⵙⴰ ⵙ ⴾⴼⵔⵏⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ⵙⵏ⵿ⵜⵏ ⴼⵍ ⴼⵢ ⵏⴶⵔⵓ ⵓⴰ ⵂⴹⵏ ⵜⵤⵔ ⵏⵏⵙ «ⵢⴰ ⵛⵈ ⵎⵢ ⴹⵜⵙ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ⴶⵙⵏ ⵗⵢⵙⴰ ⵍⵌⵓⵀ ⵓⴰ ⵏⴰ «ⴶⵢ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔ ⴹⵜⵙⴶⴹⵎ ⵔ ⴼⵍ ⵙ ⵜⵜⵛⵎ ⵜⴶⵍⴰ ⵂⵔ ⴹⵗⵙ ⵜⵢⵓⵏⵎ ⵓⵔⴶⵗ ⵛⴹⵜ ⵏⴶⵔⵢ ⵏⵍⵎⵗⵏⴰ ⵏⵍⵗⵍⵎⵜⵏ ⵛⵏ ⵎⵤⵍⴰ ⴼⵍ ⴹⵜⵍⴾⵎⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ⵢⵜ ⵛⵗⵍ ⴹⵗ ⴶⵎⵢ ⵏⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵗⵛⴹⵏⵏ ⴶⵎⵢⵜ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵓⵔ ⵏⵗⵛⴹ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵓⵏ⵿ⵜⵏ⵿ⵤⴾⴼⵏ ⴼⵍⵙ ⵏⴾ ⵙⵓⵔ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵌⵓⵍ ⵓⵏ ⵜⵗⵎⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵏⵙ «ⵎⵏⵢ ⵤⴰ ⵔⵜ ⵓⵙ ⴹⵏⵗⵓⵔ ⵜⵏⴶⵓ ⵢⴹ ⵏⴾⵏⵓ ⵛⵗⵍⵏ ⵓⵏ ⵔⴰ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵛⵗⵍ ⵓⴰ ⴹⵗⵓⵏ ⵔⴰ ⵎⵛⵏⴰ ⵓⵔ ⵜⵎⵙ ⵔ ⴹ ⵜⵤⴶⵤⵏⵎ ⵙ ⵓⴰ ⴹⵙⴶⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ⵍⵙⵏ⵿ⵜⵓ ⵙⵙ⵿ⵜⵏ ⵏⵏⵙ «ⵎⴰ ⵜⵎⵙ ⵤⴰ ⵍⵗⵍⵎⵜ ⵜⴰ ⴹⵏⵤⵜⵎⵤⵍⴰ ⴼⵍ ⵙⵔⴾ ⵏⵤⴶⵤⵏ⵰ ⵎⴰ ⵤⴰ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ⵎⵔⵓⵏⵏⵗ ⵜⵛⵏ ⴹⵗ ⵜⵏⵔⵢ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⵎⵏⴰ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵓ ⵜⴹⵢ \"ⵛⵜⵛⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴼⵍⵏ ⵌⵏⵓⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⵔⴶ ⵏⵀⵢ ⵎⵙⴰ ⴾⵓⵏⴾⴼⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴼⵍⵏ ⵌⵏⵓⵏ⵰ ⵀⵏⵏ ⵏ⵿ⵜⴰ ⴾⵓⵏⴾⴼⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴼⵍⵏ ⵌⵏⵓⵏ ⵎⵙ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ⴼⵍⵙ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵢⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ⵏⵏⵙ «ⵎⵍⵢ ⵎⵏ⵿ⵙⵢ ⵓⴹⵢ ⵂⴾⵏⵆⵓ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⵎⵙⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⵓⴰ ⴹⴹⴾⵏ ⵓⵔ ⴹⵙⵍⴾⵎ ⴹ ⵜⴶⵤ ⴶⵍⴾ ⵎⵔⵏ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵓⵔ ⴹⵗⵙ ⵍⴾⵎ ⴹ ⵜⴶⵤ ⴼⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ⵎⵛⵏ ⵏⵗⵓⵏ ⵜⵏⵢⵎⵢ ⴶⵙ ⵓⵔ ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⴾⴼⴰ ⵀⴰ ⴹⴹⵙⵓ ⵎⵔⵏ ⵓⵔ ⵤⴰ ⵎⵍⵍⵢⴰ ⴼⵍ ⵢ ⴹⴹⴾⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ⴼⵍⵙ ⵤⵀⵢ ⴹⴶ ⴹⵗ ⵌⵏⵓⵏ ⴼⵍ ⴹ ⵎⵤⵍⴰ ⵙⵔⵜ ⵓⴰ ⵔⴰ ⵓⴰ ⴹⴹⵙⴶⵍⵏ ⵓⵔⴶⵗ ⵔⵜ ⵓⴰ ⵔ ⵏⴾ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ⵏ⵿ⵜⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵓⵔ ⵔⴰ ⴹ ⵈⵔⴾ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⵓⵏ ⴹⴾⴼⴰ ⴾⵍⵔ ⵔⴰ ⵜⵏ⵿ⴹⵙⵏ⵿ⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ⵓⵍⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵔⴰ ⵀⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵏⵢⵏⵏ ⵏⴾ ⵀⵔⵔⵏⵜ ⵤⴶⵤⵏⵏ ⵙⵔⵢ ⵏ⵿ⵜⵏⵢ ⵤⴶⵔⵓⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵙⵏ⵿ⴾⵔⵆⵏ⵿ⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ⵜⵤⵔ ⴹ ⵜⴶⵜⵏ⵿ⵜⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵂⵏ ⵀⵜⵏⵜ ⴼⵍ ⵙ ⵏⴰ «ⵏⴾ ⵎⵙⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ⴶⵏⵏ «ⵓⴾ ⵓⵏ ⵓⵔⴶ ⵗⵢⵙⴰ ⵓⵏ ⴶ ⵢⵙⴼ ⵏⴾⵏⴰ ⵜⵎⵤⴹⵢⵜ ⵏⵀⵏⵜ ⴹⵏⵏⵜ ⵎⵏⵎⴾ ⵙ ⴹⵤⵏ⵿ⴾⵔ ⵎⵔⴹⴰ ⴹ ⴶⵏⵓ ⵌⵏⵓⵏ ⴹⴶⵎⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ⵌⵓⵀⵙⵏ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵢⵓⵜ ⴶⵜⵏ⵿ⵜⵏ ⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ⵓⵔ ⵜⵍⴰ ⵢ ⴹⴹⵤⴾⵏ ⵔ ⵙ⵿ⵜⴹⵓⵢ ⵙⵔⵢ ⵀⴰ ⴹⴹⵙⴶⵍⵏ ⵏⴾ ⵎⵔⵏ ⵙⵏ⵿ⴾⵔⵆⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ ⵂⵏ ⵙ \"ⴾⵜⵏⵙⵏ ⵜⵏⵙⵙⵗⵔⵓ ⵎⵛⵏⴰ⵰\" ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵍⵏ ⵢⵀⴰ ⵆⵀⵍ ⵙⵙⵗⵔⵏⵜ ⵓⴹⵢ ⴹⴹⴾⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ⵓⵔ ⵜⵍⴰ ⵙ ⴾⵍⴰ ⴹ ⵏⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵔ ⵓⴰ ⵜⴹⴼⵍⵏ⵰ ⵏ⵿ⵜⴰ ⵗⵙ ⵜⵏⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢ ⵤⴶⵤⵏⵏ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ⵏⴾ ⵎⵙⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ⵎⵔⵓⵏⵓⵏ ⵜⵛⵏ ⵎⵏⴰ ⴹⵗ ⵜⵏⵔⵢ ⵎⵛⵏ ⵓⵔ ⴹⵙⵏⴶⴹⵍ ⵓⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ⵙ ⴶⴰ ⵓⵏ ⵎⵏ⵿ⵙⵢ ⵓⵙ ⴶⵏⴰ ⵏⴾ ⵌⵏⵓⵏ ⴹⵗ ⴹⴶⵎⴹ⵰ ⵢ ⵜⵜⵛⵏ ⵓⵔ ⵜⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ⵏⴾ ⵎⵙⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⵂⴾⵓ ⵜⵎⴹⵔ⵿ⵜ⵰ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵛⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹ ⴹⵔ ⵂⵔ ⴼⵓ⵰ ⵎⵔⵏ ⵜⵗⵙⵏⵏ ⵜⵎⵙⵜ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵤⴾⴼⴰ ⴼⵍ ⴹ ⵜⴶⵔⵓ ⴹⵏⵜ ⵜⵎⴹⵔ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⵜⵙⵂⵜ ⴶⵔ ⴾⵍⵍⵢⵂⴹ ⴹ ⴶⵏⵏ «ⵎⵏⵎⴾ ⵙ ⴹⵏⵤⴾⴼⵓ ⵓⴹⵏ ⵓⴰ ⵜⵗⵙⵏⵜ ⵏⵜⵛⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵍⴰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵙ ⵓⵔ ⵜⵜⵛⵎ ⵜⵗⵙⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵜⵛⵓⵎ ⴹⵗ ⵤⵏⵏⵏ ⵓⵔ ⴹⵓⵏ⵿ⵜⵜⵍⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ⵓⴹⵏ ⵓⴰ ⵜⵛⵏ ⵜⵗⵙⵏⵏ ⵛⵓⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵤⵏⵏⵏ ⵓⴹⵢ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵙⵏ⵿ⴾⵔⵆⴹⵓ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵤⵍ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ⴼⵍⵙ ⵜⵗⵙⵏⵏ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⵜⴹⵜ ⵜⵎⵙ ⵤⵏⵏⵏ ⴹⵗ ⵎⵏ ⵏ⵿ⵜⵙⵢ ⵓⵏ ⵜⴹⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ⵓⴹⵏ ⵓⴰ ⵜⵛⵏ ⵜⵗⵙⵏⵏ ⵛⵓⴰ ⴹⵗ ⵤⵏⵏⵏ ⵓⴹⵢ ⵔ⵿ⵜⵢ ⴹⵔⵢ ⵏⴾ ⴹⵗ ⵂⵗ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ⵀⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵏ⵿ⵜⴰ ⵗⵔ ⵜⵍⴰ ⵜⵎⴹⵔ⵿ⵜ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵜⵜⴾⴼⵏ ⴹⵗ ⴹⵢ ⵓⴰ ⵜⵛⵏ ⵜⵗⵙⵏⵏ ⴹ ⵜⵙⴹⵔⴰ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ⵰ ⵓⵔ ⵍⴰ ⴹⵓⴰ ⵜⵛⵏ ⵎⵔⵓⵏⵓⵏ ⴼⵍⵙ ⵓⵔ ⴹⵙⵏⴶⴹⵍ ⴹⵢ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵓⴹⵏ ⵓⴰ ⵜⵜⵛⵏ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ⵔⵜ ⴹⴰ ⴹⴰ ⵓⴰ ⵏⴰ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⴾⴼⵔⵏⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ⵙ ⵙⵍⵏ ⵏⵜⵍⵀⵏⵜ ⴶⵜⵏⵏ ⵢⵔⵜ ⵓⴰ ⵏⴰ ⴹⴰ ⵏⵏ «ⵀⵜⵓ ⵜⴰ ⵛⵢ ⵍⵀⵙⵜ ⵤⵓⵜ ⵤⴶⵤⵏⵜ⵰ ⵎⴰ ⴼⵔⴶⵏ ⵍⵆⵀⵍⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ⵙⵏ ⵗⵢⵙⴰ ⴹⵗ ⵎⵏⵜ ⵙ ⴶⵜⵏ⵿ⵜⵏⵏ ⵏⵜⵍⵀⵏⵜ ⴶⵔⵙⵏ ⴹⵗ ⵜⵍⵗⴰ ⵜⵏ ⵏⵙⵏ «ⵏ⵿ⴶⵎ ⵤⴶⵤⵏⵓⵏ ⵜⴹⵙ ⵀⵜⵓ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ⵎⴰ ⵤⴰ ⵜⴶⵎ ⵤⴰ ⵙ ⴹⵜⴶⵎ ⵏⴾ ⴶ ⴶⴹⵎ ⵜⴶⵤⵢⴰ ⵙⴹⴶ ⵓⴰ ⵂⵗ ⵙ⵿ⵜⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ⵓⴹⵏ ⵙ ⵜⵗⵙⵏⵜ ⵓⵔ ⵎⵙ ⵓⵍⴰ⵰ ⵓⵍⵏ ⵓⵏ ⴹⵓⵏⴶⵗ ⵏ⵿ⴼⵙ ⵎⵙⵏ ⵂⴾⵏ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ⵎⵛⵏ ⵂⵏ⵿ⴾⵓⵏ ⵢⵜⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ⵰» ⵗⵢⵙⴰ ⵂⵔⵓⴰ ⵗⵔ ⵜⵤⵔⵜ ⴹⴰ ⵙⵏ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙⵏ ⴹⵗ ⵓⴰ ⵜⵤⴶⵏ ⴹⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ⵍⵙ ⵏⵙⵏ «ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵓⵏⵏ \"ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⴹⴹⴾⵓ ⵔ ⵙⴹ ⵜⴾⴼⴰ ⵀⴰ ⴼⵔⴶⵜ ⵏⴹⵢ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ⴹⵏ ⴹⴰ ⴹⴼⵔⵙ ⴼⵍ ⴶⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵗⵔⴹⵏ ⴹⵜⴹⵓⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ «ⵎⵆⵍ ⴾⵓⵏⵢ ⴹⴰ ⵜⵔⵎ ⵜⴾⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵎⵍⵢ ⵎⴰ ⵎⵙ ⵓⴰ ⵤⴰ ⵏⴾⵓ⵰ ⴾⵢ ⵜⴶⵏ ⵓⵍⵏ ⵓⵏ ⵂⴾⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ⵏⴾⵏⵢ ⵏⵤⴶⵤⵏ ⵙⵔⴾ ⵏⵙⵏ ⵙ ⴾⵢ ⵎⵤⴹⴶ ⴹⴼⵍⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾ ⵓⵔⴶⵗ ⵙⵏⴼⵔⵏ ⴾⵓⵏⴶ ⴾⵜⵏⵓⵏ ⴼⵍ ⵎⵔⵓⵓⵏ ⴹⵛⵏ ⴾⴹⵗ ⵙ ⵢⵏ ⴹⵗⵓⵏ ⵀⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ⵀⵜⵓ ⵜⴰ ⵢⵂⵤⴰ ⵓⵏ ⴶ ⵙⵎⵗⵏ ⵙⵈⵔⵢⵜⵢ ⴼⵍ ⵜⵜⴶⴰ ⵗⵢⵙⴰ⵰ ⴼⵍⵙ ⵢⵂⵤⴰ ⵜⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⴾⴹⵗ ⵙ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ⴹⴼⵔ ⴹⵢ ⵙⵓⵍ ⵗⵢⵙⴰ ⴹⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴼⵍⵙ ⵓⵔ ⵔⴰ ⵙⵓⵍ ⵏ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵎⵢⵏⵏ ⴹⵜⵏⵗⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ⵙ ⵜⴶⵓ ⵓⵏ ⵎⴹ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ ⵜⴾⵔⵀⵏⵏ ⵂⵤⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ⵏⵏⵙ ⵎⴹⵔⵢⵏⵜ «ⴼⵍ ⴹⴰ ⵜⴾⴰ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⴼⵍ ⴹ ⵏⵢⵏ ⵏⵜⵍⵀⵏⴾ ⵛⵗⵍⵏ ⵓⵏ ⵜⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ⵓⴹⵏ ⵙ ⵔⴰ ⴼⵍⵙ ⵜⴶⵓ ⵎⵙⵏⵜ ⵓⵔ ⵛⵆⵍ ⴹⵗ ⵙⵔ⵰ ⴹⴹ ⵤⵎⴰ ⵙ ⵜⵜⴶⵗ ⵔⵜⵏ ⴶⴹⵏⵏ ⴹⵓⴰ ⵓⴹⵢ ⴶⵓ ⵜⵎⵓⵜ ⵜⴰ ⴼⵍ ⵜⵏ⵿ⵤⵏⵢ ⵓⴹⵏ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ⵙ ⴹⵙⴶⵏⵏ ⵎⴹⵔⵢⵏⵜ ⵓⵏ ⴹⴰ ⵓⵔ ⵙⵔⵙ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙⵗⵜ ⵜⵏⵏ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴹⵜⵓⴹ⵰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵔ ⵜⵤⵍⵢⵎ ⵙⵗⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ⵓⵔ ⵜⵍⴰ ⴹⵍⵍ ⴼⵍ ⴾⵓⵏ⵿ⵤⵜⴶⵤⵔ ⴹⵏⵜ⵰ ⵏⴾ ⵎⵔⵏ ⴹⵏⵜ ⵜⴶⵤⵔⵢ ⴼⵍⵙ ⵜⴶⵢⴰ ⵎⵙⴰ ⵢⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⴹⵗⵙ ⵜⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ⴾⵓⵜ ⵎⴹ ⵓⵏ ⴾⵓⵏⵢ⵰ ⵏⴾ ⵓⵔ ⵜⴾ ⴼⵍⵙ ⵙⵗⵜⵏ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴹⵜⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ⵙ ⴹⵙⵏⵗⵔⴹ ⵜⵏⴰ ⵏⵔⵜⵏ ⵓⵏ ⵆⵎⴹⵓ ⴹⵗ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙ ⴾⵏ ⵎⴹⵔⵢⵏⵜ ⵎⴹ ⴾⵢ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⵙ ⴾⵢ ⵓⴰ ⵤⵏ ⵙ ⴶⴰ ⴹⵗ ⵙⵔ ⴼⵍⵙ ⵓⵔ ⵙⴾⵏⴰ ⵎⵏⵜ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ⵜⴶⵓ ⵎⴹ ⴹⵏ ⴹⴰ ⴶⵎⵢⵏ⵿ⵜⵓ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏⵏ «ⵎⴰ ⴶⴰ ⵍⵙ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔ ⵢⵜⴹⵏ ⴹⵗ ⵜⵍⵗⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵓⵢⴹ ⵤⴰ ⴶⵏⵏ «ⵍⵙ ⴹⵢ ⵍⵗ⵰» ⵓⵢⴹ ⵎⵔⵏ ⴶⵏⵏ «ⴾⵍⵔ ⵙⵈⵔⴾ ⴼⴹⴰ ⵜⴶⵓ ⵜⵎⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵂⵍⵏ ⵎⴶⵔⴹ ⴹⵜ ⵢⵜⴹⵏ ⴹⵗ ⵜⵍⵗⵏⵜ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ⵙ ⵙⴶⵔⵢⴶⵔⵢ ⵎⴹ ⴾⴰ ⵗⵢⵙⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗⵙ ⵙⵙⵗⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ⵙⵙⵗⵔⵢ ⵓⴰ ⵆⵏ ⵗⴼⵓⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵍⵏ ⵂⵔ ⵆⵎⵏ ⴶⵏⵏ «ⵓⴰ ⴾ ⵓⴹⵏ ⵎⴰ ⵜⵙⵙⵏⵏ ⵔⵜⵏ ⵓⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⵗⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙⵙⵗⵔⵏⵏ ⵓⵔⴶ ⵏⴾ ⴹⴼⵍ ⴾⵍⵔ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴹⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵔⵏ ⴹ ⵎⵤⵍ ⵜⵔⴰ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⴹ ⵙⵏ ⴾⴹ ⵙⵙⵗⵔⵏⵏ ⵏ⵿ⵜⴰ ⵎⵛⵏⴰ ⴹⴼⵍ ⵓⵍⴰ ⴹⵗ ⵔⵜ ⵎⵙ ⴹⵏ⵿ⵤⵎⴰ ⴶⵔⵢ ⴹⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ⵓⴹⵏ ⵓⴰ ⵛⵓⵍⵏ ⵙⵔⵜⵏ ⴹⵏ⵿ⵤⵎ ⴶⵔⵙ ⴹⵎⵏⵜ ⵓⴹⵢ ⵎⵏⵜ ⵙ ⴶⵎⵢ ⵜⵏⵢⴰ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⵛⵗⵍⵏ ⴹⵗ ⵙⵏⴼⵍⵍ ⵏ⵿ⵜⵏⵢⴰ ⵏⵓⴰ ⵜⴹⵤⵎⵤⵍⵏ ⵓⴹⵢ ⵜⴹⵜ ⵎⵍ ⵓⵔ ⴹⵗⵙ ⵜⵍⴰ ⵎⵙⵏ ⵍⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ⵓⵔⴶⵗ ⴾⴼⵓⵏ ⵏⵀⵢ ⵎⵙⴰ ⵍⵆⵏⵏ⵰ ⵓⵔ ⴾⵓⵏⵂⴰ ⵤⴰ ⵢ ⴹⵙⵍⴾⵎⵏ⵰ ⵎⴼⵍ ⵙ ⵜⵔⵎ ⴹⵜⵏ⵿ⵗⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ⵏⵏⵙ ⵢⵜⴹⵏ «ⴾⵢ ⴶⵙⴼ ⴾⵢⵂⵏ⵰ ⵎⴰ ⵔⵏ ⵜⵏⵗⵢⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⵜⵍⵎⵗⵌⵌⵜ ⵢⴹⴰ ⵗⵙ ⴶ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵎⵛⵏ ⵆⵏⵏⵙ ⵗⴼⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ⴾⵓⵏⵢ ⵓⵔⴶⵗ ⵜⵛⵆⵍⵎ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴼⵍⵙ ⵀⵔⵔⵏⵓⵏ ⴹⵗⵙ ⵜⵙⵎⵏ⵿ⴾⴹⵎ⵰ ⵎⵔⵏ ⵓⵔ ⴼⵍⵓⵏ ⵎⵙ ⵓⵏ ⵍⵂⵏ ⴼⵍⵙ ⵏⵀⵢ ⵎⵙⴰ ⴹⵓⵏ⵿ⵜⵏⵏ⵰ ⵙ ⴶⴰ ⵓⵏ ⵎⵔⵓⵏⵏⴰ ⵜⴹⵙⵏ⵿ⵜⵏⵏ ⵓⵔⴶ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ⵏⵢⵜ ⵤⴰ ⴹⴹ ⵎⵙ ⵙ ⵜⵓⵙⵎⵏ⵿ⴾⴹ ⵀⵔⵔ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴼⵍ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵏⵀⵢ ⵎⵙⴰ ⵎⴼⵍ ⵙ ⴾⵓⵏⵂⴰ ⵍⵂⵎⵏ ⴼⵍⵙ ⴶⵗ ⵢⵓⴹⵏ ⵤⵤⵢ ⴾⵎⵍⵏ ⴹⵗ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ⴹ ⵓⵔ ⵜⵈⴾⵎⵎ ⵓⴹⵏ ⵙⵤⵂⵔⵏⵜ⵰ ⴾⵍⵔ ⵈⴾⵎⵜ ⵙ ⵜⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ⵙ ⵜⴶⵏ ⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵢⵔⵙⵍⵎ ⴹ ⴶⵏⵏ «ⵓⴾ ⵍⵙ ⵓⵏ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵙ ⵔⵏ ⵎⵤⵔⵏⵏⴰ ⵜⵏⵗⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵏ ⵎⵔⴹⴰ ⵛⵓⵍⵏ ⴹⵏ ⴹⵜ ⵓⴹⵏ ⴾⵍ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵙⴶⵏⵏ ⵓⵍⴰ⵰ ⵓⴾ ⵎⴾⵏ ⵎⵤⵔⵏⵏⵗ ⵙⵍⴾⵏⵏ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ⵙ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⵍⵙ ⵓⴰ ⵏⵙⵏ ⴾⵍ ⵓⴰ ⴹⴶⵎⴹ ⵍⵎⵙⵈ ⵎⵔⵏ ⵙⵗⴰ ⵓⴰ ⴹⵤⵙⵓ ⵏⴼⵍⵍ ⵗⵙ ⴹⵤⴶⵓ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙⵏⵏ ⴹⴰ ⴹⴶⵎⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ⵂⵔⵓⴰ ⴹⴰ ⵙⵙⵗⵔⵓ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⵏⴰ «ⵜⵤⴹⵢⵎⵢ ⵜⵙⵏⵎ ⵙⵙ ⴹⵂ⵰ ⵙ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔ ⴹⵙ ⴶⵔⵢ ⴹⵎⵏⵏ ⴾⵍⵔ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⴹⴹⵤⵎⵤⵍⵏ⵰ ⵎⵔⵏ ⵓⵔ ⵜⵜⵤⴹⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ⵏⴾ ⵤⴹⵢⵆⵓ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵙⵔⵓⵏ ⴹⴼⵍⴰ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ⴹⵏ ⴹⴰ ⴹ ⴶⵎⵢⵏ ⵎⵤⵔⵏ ⵏ⵿ⵜⵎⵜⵢ ⴹⵀⵤⵏⵜ ⵎⵛⵏ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵜⴹⵙⵏ ⴼⵍⵙ ⵍⵓⵆⵏⵜ ⴹⵓⵔⵏⵓⴹ ⵂⵔⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵢ ⵏ ⴶⵏⵏ «ⵜⵔⴹⵎ ⵙ ⴾⴹ ⴹⵙⴰ ⵍⵎⵙⵈ ⴼⵔⴶ ⵙⴾⵏⵢ ⵏⵍⵗⵍⵎⵜⵏ ⴶⵔⵏⵏ ⵛⵏ ⵙⴾⵏⴰ ⵍⵙ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ⵔⵜ ⵓⴰ ⵙⵎⵜⴾⵜⴾⵏ ⵢⵜⴹⵏ ⴹⵗ ⵜⵎⵜⵢ ⵜⴰ ⵙⵍⵏ⵿ⵜⵓ ⴼⵔⵙⵢⵜⵏ⵰ ⵏ⵿ⴾⵔⵏ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⴼⵔⵙⵢⵜⵏ ⵙⴶⵍⵏ⵿ⴹⵓ ⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵢⴹ ⵀⵤⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⴾ ⴹ ⴶⵗ ⵔⵜ ⵏ⵿ⵜⵎⵔ⵿ⵜ ⴹⵓⴰ ⴹⵔⵓⵏ ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⴹ ⵤⴾⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ⴹⵜⴶⵎⵢⵎ ⵎⵛⵏ ⵓⵔ ⴹⵤⵜⴶⵔⵓⵎ ⴼⵍⵙ ⴹⴶ ⵓⴰ ⵤⴾⴰ ⵓⵔ ⵜⴼⵔⴶⵎ ⴾⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ⴹ ⵜⵏⵎⵙⵙ⵿ⵜⵏⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵏⵏ «ⵎⴰ ⵎⵙ ⵤⴰ ⴹⴶ ⵓⴰ ⵤⴾⵓ ⴹⵆⵓ ⵓⵔ ⵤⴰ ⵏⴶⵔⵓ⵰ ⵎⵆⵍ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵓⵤⵓⵤⵏⵏ ⴹⵗ ⴾⵍⵏ ⵓⵏ ⵜⵎⴰ ⵤⴾⵓ ⴶⵤⵜⵏ⵰ ⵎⵗ ⴾ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵤⵙⵙⵗⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵓ ⵜⴰ ⴶⴰ ⴹⴰ ⵙ ⵏⴰ \"ⴰ ⴹⵜⴶⵎⵢⵎ ⵎⵛⵏ ⵓⵔ ⴹⵤⵜⴶⵔⵓⵎ ⴼⵍⵙ ⵓⵔ ⵜⴼⵔⴶⵎ ⴾⵢ ⵏⴹⴶ ⵓⴰ ⵤⴾ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ⵙ ⴹⵓⴹ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ ⵏⵎⴹ ⵓⵏ ⵜⴾⵔⵀⵏⵏ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵤⵍ ⵓⴰ ⵤⵓⵔⵏ ⴹⵗ ⵎⴹ ⵏ ⵀⴹⴹ ⵗⵢⵙⴰ ⴹⵜ ⵜⵎⵜⵢ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴼⴹⵏ ⴾⵓⵜⴹⵓ ⴹ ⵛⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ \"ⴹ ⵏ⵿ⴶⵢⵏ ⴶⵔⵓⵏ ⵏⵎⵏ ⵓⵏ ⵙⴹⵔⵏⵏ ⴹⵗ ⵓⵍⵏⵜ\" ⵙⵎⴾ ⵓⵙ ⴾⵜⵀ ⵓⵏ ⴹⵗ ⵍⴾⵜⵀⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵔⵙ ⵙⴾⴰ ⵤⴶⵔⵓⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ⵰ ⵏ⵿ⵜⴰ ⵤⵎⵏⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔ ⵜⵓⴾⴼⴰ ⵂⵔⵓⴰ ⴹⴰ ⴼⵍⵙ ⵗⵢⵙⴰ ⵓⵔ ⵏⴶⵤ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ⵙ ⵙⵍⴰ ⴹⵙ ⵏ⵿ⵜⵎⵜⵢⵏ ⵢ ⵀⵜⵜⵏ ⵛⵏ ⴶⴰ ⵗⵢⵙⴰ ⴹⴰ ⵏⵏ «ⵍⴾⵏ ⵙ ⵍⵙ ⵓⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵏⵀⵢ ⵓⴰ ⵜⵎⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ⵏⵏ ⵓⵢⴹ «ⵍⵎⵙⵈ ⵓⴰ⵰» ⵏⵏⵙⵏ ⵓⵢⴹ «ⵎⵏⵎⴾ ⵙ ⴹⵤⴶⵎⴹ ⵍⵎⵙⵈ ⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ⵓⴾ ⵍⴾⵜⵀⵏ ⵓⵔⴶⵗ ⵏⵏ \"ⵤⵔⵢⴰ ⵏ⵿ⴹⵓⴹ ⴹⵜⵗⵔⵎ⵿ⵜ ⵏⵀⵜⵍⵈⵎ ⵙⵏ⵿ⵜⴰ ⵙ ⴾⵍⴰ ⴹⵗⵙ ⵗⵙⵔ ⴹⵓⴹ ⴹⵤⴶⵎⴹ ⵍⵎⵙⵈ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵎⵤⵔⵢ ⵜⵎⵜⵢ ⴹⵗ ⵜⵍⵗⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ⵓⵢⴹ ⴹⵗⵙⵏ ⵔⵏ ⵀⵤⵏⵜ ⵎⵛⵏ ⵓⵔ ⵜⵏⵂⴰ ⵙ ⵜⴹⵙ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ⴶⵍⵏ ⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵆⵍⵏ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⴼⵔⵙⵢⵜⵏ⵰ ⵙⵏⵏ ⵗⵙ ⵏⵏⵙⵏ «ⵎⴼⵍ ⵓⵔ ⵜⴹⵜⵓⵢⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ⵏⵏⵙⵏ ⵎⴶⵤⵏ «ⵓⵔ ⴾⵍⴰ ⵜⵓⵏⵢ ⵓⴹⵏ ⴶⵏ ⵓⵍ ⵓⴰ ⴶⴰ ⵍⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ⵏⵏⵙⵏ ⴼⵔⵙⵢⵜⵏ «ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⴹⴰ ⵜⵢⵎ ⵎⵏⵓⵏ ⵜⵜⵓⵙⵈⵔⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ⵙⵏⵜ ⵍⵢ ⵢ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⴹⵗⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ⵓⵔ ⵙⵔⵙ ⵤⴶⵤⵏ ⵔ ⵜⵎⵜⵢ ⵏⵍⵌⵂⵍⵏ ⵓⵔ ⵏⵙⵏ ⵓⵍⴰ ⴹⵗ ⵓⴰ ⵂⵏ ⵛⵔⵗⴰ ⵏⵜⵓⵔⵜ ⵙ ⴾⵜⵏⵙⵏ ⵜⵓⵔ⵿ⵜⵏ ⵜⵍⵗⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ⵏⵙⵏ ⵏⴾⴹⵎⵙ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⴼⵔⵙⵢⵜⵏ ⵙⵏ⵿ⵜⴰ ⴹⵏⵙⵏ ⵗⵢⵙⴰ ⴹⵜ ⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ⵛⵔⵗⵏⵏⴰ ⵓⵔ ⵜⵂⴰ ⴹ ⵜⵓⵈⴾⵎ ⵓⴹⵏ ⴾⵜ ⵓⵔ ⵛⵓⵍ ⵜⵓⵙⵏ ⵓⴰ ⴹⵗ ⵛⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ⵏⵏⵙ «ⴶⵍⵍⵢⴰ ⴾⵢ ⵜⵍⵜ ⴾⵢ ⴹⴰ⵰ ⴾⵏⵓ ⵜⵗⵔⵢ ⵏⵍⴾⵜⵀⵏ ⴹ ⵜⵏⵢⴰ ⴾⵢ ⵎⵏⴾ ⵙ ⵓⵔ ⵜⵍⴰ ⵏⵀⵢ ⴹⵤⴶⵎⴹⵏ ⴶⵍⵍⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ⵜⵤⵔ ⴾⴰ ⵓⴹⵏ ⴾⵍ ⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ⴾⴰ ⵗⵢⵙⴰ ⴹⵗⵗ ⵙ ⵜⵓⵏⵓ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ⵙ ⴼⵓ ⵗⵔⴰ ⵆⵍ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵤⵔ ⵜⴾⵢⴹⵓ ⵜⵎⵜⵢ ⴾⵜⵏⵜ⵰ ⵆⵎ ⵜⵏⵙⵙⵗⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ⵛⵓⵍ ⴹⵏ ⴹⴰ ⵙ ⴹⵙⵏ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵢⵏ ⵜⵏ⵿ⵜⵜ ⴹⵗⴹⵔⵏ ⵜⵜⴶⵓ ⵤⵏⴰ⵰ ⵙⵀⴹⴹⵏ⵿ⵜⵜ ⴹⵜ ⵓⴹⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ⵏⵏ ⵢ ⵗⵢⵙⴰ «ⵢⴰ ⵛⵈⵏⵏⴰ ⵜⵏ⵿ⵜⵜ ⵤⵏⴰ ⵜⴶⴰ ⵎⵔⵏ ⵜⵜⵓⵏⵢ ⵜⵜⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ⴹⵗ ⵜⵓⵔⵜ ⵤⴰ ⵏⴰ ⵎⵙⴰ \"ⵜⵏ⵿ⵜⵜ ⵤⵏ ⵜⴰ ⵍⵤⵎ ⵜⵜⴶⵔⵏ ⵢⵜⴹⵏ ⵙ ⵜⵂⵏ ⵂⵔ ⵜⵜⵀⴰ⵰\" ⵎⵔⵏ ⴾⵢ ⵎⴰ ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ⵔⵜ ⵓⴰ ⵜⵎⵔⴾⵙ⵿ⵜ ⵎⵙ ⴹⵙⴶⵏ ⴼⵍ ⴹ ⵜⵙⵓⵔⵏ ⵍⵂⵏ⵰ ⴹⴶ ⵏ ⴹⵙⵏⵌⵓⵀ ⵗⵢⵙⴰ ⵏⵤ ⴹ ⴾⵜⵀ ⵙⴹⴹⵏⵜ ⴼⵍ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ⵆⵎⵏ ⴹⴶⵤⵏ⵿ⵜⵓ ⵙⵙⵙ⵿ⵜⵏ ⵙ ⵂⴶ ⵀⴹⴹⵓ ⵏⵙⵏ «ⵏ⵿ⴾⵔⵜⴹⵓ ⴹⵗⵓⵏ ⵓⵙ ⴾⵍⴰ ⵓⵔ ⴶⴰ ⵀⴾⴹ ⵤⵔⵜ ⵙ ⵜⴶⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ⵍⵙ ⵏⵤ ⴹ ⴾⵜⵀ ⵙⴹⴹⵏⵜ ⴼⵍ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ⵙⵍⵏ ⵢ ⵀⵜⵓ ⵜⴰ ⵗⵙ ⵎⵤⵤⵔⵏ ⴶⵍⵏ ⵤⵔⵏⵙⵏ ⵓⵏ ⵓⵛⵔⵏⵏ⵰ ⵆⵎⴹⵓ ⵗⵢⵙⴰ ⵗⵙⵏⵜ ⵏ⵿ⵜⴰ ⴹⵜⵏ⵿ⵜⵜ ⵜⴰ ⵏⴹ ⵜⵀⴹⴹ ⴹⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ⵀⴹⴹⵓ ⵏⵙ «ⵜⵏ⵿ⵜⵜ ⵎⴰ ⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵎⵀⵤⵏⵏ⵰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴾⵎⵀⵤⵏ ⵙⵛⵔⵗⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ⵜⵏⵙ «ⵓⵍⵢⵏ ⴹⵗⵙⵏ ⵎⵍⵏⵏ»⵰ ⵏⵙ ⵗⵢⵙⴰ «ⵏⴾ ⴹⴰ ⵤⴰ ⵓⵔ ⴾⵎⵤⵀⵤⴰ ⵙⵛⵔⵗⴰ⵰ ⴶⵍⵓ ⵜⵌⵓⵏ⵿ⴾ ⵎⵛⵏ ⴹ ⵓⵔ ⵜⵍⵙⵗ ⴶⵢ ⵏⵀⴾⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ⵍⵙ ⵗⵢⵙⴰ ⵓⵍ ⵢ ⵜⵎⵜⵢ ⵏⴰ «ⵏⴾ ⵎⵙⵏ ⵏⵔ ⵏⴹⵏⵜ⵰ ⴹⵗ ⴹⵢ ⵓⴰ ⴹⵍⴾⵎⵏ ⴹ ⴶⵔⵓ ⵏⵔ ⵓⴰ ⵙⴹⵔⵏ ⵎⵔⵏ ⵗⵔⴹ ⴹⴹ ⵌⵓⵏ⵿ⴾⵜ ⴹⵗ ⵛⵢⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ⵏⵏⵙ ⴼⵔⵙⵢⵜⵏ «ⵜⴶⵢⴰ ⵏⵎⵏⴾ ⵜⵎⵙⴰ ⵔⵜ ⵓⴰ ⵜⴶⵏⵗ ⴹⵢ ⵔⴾⵎ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⴹ ⵎⵙ ⵙ ⵜⴶⵢⴰ ⵏⵎⵏⵏ ⵎⵙⴰ ⴹⴰ ⵜⴶⵢⵏⵏ ⵜⴹⵜ ⵜⵎⵙ ⴼⵍⵙ ⵙⵏⴰ ⵙⵙ ⴹⵂ ⴹⵙⵙ ⴹⴶⴰ⵰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵔ ⵜⵙⵏⵎ ⵙⵙ ⴹⵂ ⵓⵍⴰ ⵙⵙ ⴹⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ⴾⵓⵏⵢ ⵤⵂⵔ ⵗⵙ ⵙ ⵜⵛⵔⵗⵎ ⵢⵜⴹⵏ ⵏⴾ ⵎⵔⵏ ⵓⵔ ⵛⵔⵗⴰ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ⵙ ⴶⴰ ⵓⵏ ⴹⴰ ⵙ ⴼⵍⵢ ⴹⵙⴰ ⴹⵢ ⴹ ⵛⵔⵗⴰ ⵎⵔⵏ ⵛⵔⵗⵏⵏ ⵙⵂⵜ ⴼⵍⵙ ⴹⵓ ⴹⵔⵢ ⵀⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ⵛⵔⵗⵏⵓⵏ ⴾⵜⵀ ⴹⵗⵙ ⵙ ⵜⴶⵢⴰ ⵏⵛⵏ ⵎⴹⵏ ⵜⵎⵙⵜ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ⵏⴾ ⵤⴰ ⵜⴶⵢⴰ ⵢⴹⴰ ⵎⵙⵗ ⵢ ⵎⵏⵏ ⵜⴶⵢⵏⵏ ⵜⵏ ⵙⵏⵜⵜ ⵎⵔⵏ ⵀⴰ ⵙⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵜⵜⵎⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ⵜⵤⵔ ⵏⵏⵙ «ⵎⵏⴹ ⵍⴰ ⵤⴰ ⵀⵏⴾ⵰» ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔⵎⴹ ⴹⵜⵤⴹⵢⵎ ⵤⴰ ⵓⵔ ⵜⵤⴹⵢⵎ ⵀⵏⵏ⵰ ⵏⵔ ⴹⵜⵤⴹⵢⵎ ⵜⵤⴹⵢⵎ ⵀⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ⵀⵜⵜⵏ ⵛⵏ ⵜⴶⵏⵜ ⵗⵢⵙⴰ ⵙⵗⴰ ⵓⴰ ⴹⵗ ⵙⵙⵗⵔⵓ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⴶⵎⴰ ⵏⴹⴶ ⵓⴰ ⵂⴰ ⵙⵏ⵿ⴹⵆ ⵓⴰ ⴹⵗ ⵜⴹⵓⵏⵜ ⵜⴾⵜⵓⵏ⵰ ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⴶⵎⵢⵏ ⴹⵀⵤⵏⵜ ⴼⵍⵙ ⵍⵓⵆⵏⵜ ⴹⵓⵔⵏⵓⴹ ⵂⵔⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵏⴾ ⵜⴾⵍⵢ ⵤⴶⴰ⵰ ⴹⵜⴶⵎⵢⵎ ⵎⵔⵏ ⴾⵓⵏⵀⴰ ⴹⵗ ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ⵰ ⵓⵔ ⵜⴼⵔⴶⵎ ⴹⵏ⵿ⵜⵓⴹⵎ ⴹⴶ ⵓⴰ ⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ⴹ ⵜⵏⵎⵏⵏ ⵔⵜ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴶⵔⵙⵏ «ⵎⵆⵍ ⵎⵏⵜ ⵤⵏ⵿ⵗⵓ ⴼⵍⵙ ⵏⴰ ⵓⵔ ⵏⴼⵔⴶ ⴹⵏⵓⴹ ⴹⴶ ⵓⴰ ⴾⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵓⵏⵢ ⵢⵜⴹⵏ ⵏⵔⵙ ⵜⵎⵙⵎ ⵏⴾ ⵏ ⴼⵍⴰ⵰ ⴾⵓⵏⵢ ⴾⵍ ⴹⵏⵜ ⴹⴰ ⵜⵎⵙⵎ ⵏⴾ ⵓⵔ ⴹⵜⵍⴰ ⴹⵏⵜ ⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵓⵏⵏ ⴾⵓⵏⵀⴰ ⴹⵗ ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ⵰ ⵙ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⵙ ⵏⴾ ⵎⵙⵏ \"ⵓⴰ ⵍⵏ ⴹ\" ⵓⴹⵢ ⴾⵓⵏⵀⴰ ⴹⵜⵛⵜ ⵏⵀⴾⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ⵏⵏⵙ «ⴾ ⵎⴰ ⵜⵎⵙⵗ⵰» ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴰ ⴹⵓⵏⵎⵍⴰ ⵗⵔ ⵜⵤⵔⵜ ⵂⵔ ⵎⵔⴹⴰ ⵏ⵿ⵜⴰ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ⵍⵏ⵿ⵜⵓ ⵔⵜⵏ ⴶⵜⵏⵏ ⵙ ⴼⵔⴶⵗ ⵜⵏⵏⴰ ⴹⵗ ⵜⵍⵗⵏⵓⵏ ⵍⵏ⵿ⵜⵓ ⴹⵗ ⵔⵜⵏ ⴶⵜⵏⵏ ⵙ ⴼⵔⴶⵗ ⴾⵓⵏⵓⴹⵀⴰ ⴼⵍⵙⵏ⵰ ⵎⵛⵏ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵎⵛⵙ ⵏ⵿ⵜⴹⵜ ⵎⵙ ⵎⵔⵏ ⵔⵜ ⵓⴰ ⴹⴹⵏⴰ ⵗⵙ ⵎⵍⴰ ⵢⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ⵓⵔ ⴶⵔⵏ ⵙ ⵀⵜⵓ ⵏⵀⴰ ⴹⵗ ⴹⵙⵏⵎⴶⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙ ⵜⴶⵎ ⵎⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵙⵙⵂⴾⵢ ⵓⴰ ⴹⵤⵜⴶⵎ ⴼⵍ ⵜⴶⵜⵓⵜ ⴹ ⵜⵙⵏⵎ ⵙ ⵏⴾ ⴹⴰ ⵎⵙⵏ \"ⵓⴰ ⵍⵏ ⴹ\" ⵜⵙⵏⵎ ⴹⵗ ⵙ ⵓⵔ ⵜⵍⴰ ⵜⴶⴰ ⴶⵔⵢ ⴹⵎⵏⵏ ⵔⵜ ⵓⴰ ⴹⵙⵙⵗⵔⴰ ⵀⴰ ⵗⵙ ⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴹⵓ ⴹⵔⵢ⵰ ⵓⵔ ⴹⵢⴰ ⵗⵙⵏ ⴼⵍⵙ ⴼⵓ ⴹⴰ ⵔⵜ ⵓⴰ ⴹⵙⴶⵔⵤⵏ ⵗⵙ ⵜⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ⵙⵍⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵢⵓⴰ ⵏⴰ ⵗⵢⵙⴰ ⴹⵏ ⵤⴶⵤⵏⵏ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ «ⵙ ⵜⵀⵔⴹⴶⵎ ⵢⵓⴰ ⴾⵓⵏ⵿ⵙⵙⵗⵔⴰ ⴹ ⵜⵆⵍⵎ ⵏⵜⵍⵀⵏ ⵓⵏ ⵜⴹⵜ ");
INSERT INTO ttqt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ⵜⵙⵏⵎ ⵜⴹⵜ ⵜⴹⵜ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴾⵓⵏ⵿ⵤⵜⵙⴹⵔⴼⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ⵏⵏⵙ «ⵏⴾⵏⵢ ⵢⴰ ⵤⵔⵢⴰ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⵏⵎⵙ ⵓⵔ ⴾⵍⴰ ⴹⵗ ⴹⵏⵜ ⴹ ⵏⵆⵍ ⴾⵍⵏ ⵏⵓⵍⵢⵏ ⵎⴼⵍ ⵜⴶⵏⴰ \"ⴹ ⵜⴹⵔⴼⵎ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⴶⵏ ⵀⴾⴹⵏ ⵓⴹⵢ ⴾⵍⵢ ⵏⵀⴾⴹⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ⴾⵍⵢ ⵎⵔⵏ ⵓⵔ ⴹⵙ⵿ⵜⵍⴰ ⴹⴶ ⵏ⵿ⴼⵓ ⴹⵗ ⵗⵢⵓⵏ ⵎⵛⵏ ⵀⵔⵔ ⵓⴰ ⵔⵓ ⵗⵢⵓⵏ ⵓⴹⵢ ⴹⴶⵏⵜ ⵍⵢ ⵂⵔ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ⴹⵗ ⴹⵢ ⵙ ⴾⵓⵏⵙⴹⵔⴼⵜ ⵀⵔⵔ ⵓⴹⵢ ⴹ ⵜⴹⵔⴼⵎ ⵙ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ⵙⵏⵗ ⵙ ⵤⵔⵢⴰ ⵏⵀⵔⵂⵎ ⵜⵎⵙⵎ ⵎⵛⵏ ⵜⴶⵎⵢⵎ ⴹⴹ ⵜⴶⵎ ⵎⵏⵏ ⴼⵍⵙ ⵓⵍⵏ ⵓⵔ ⵏⴹⵙ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ⵏⴾ ⵔⵜ ⵓⴰ ⵏⵢⴰ ⵗⵔ ⵀⵏⵏ ⵎⵍⴰ ⵎⵔⵏ ⴾⵓⵏⵢ ⵜⵜⴶⵎ ⵓⵙ ⵜⵙⵍⵎ ⵗⵔ ⵀⵏⵓⵏ ⵀⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ⵏⵏⵙ «ⵀⵏⵏⴰ ⵢⴰ ⵏⵀⵢ ⵀⵔⵂⵎ ⵜⵎⵙⵏ⵰» ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵔ ⵜⴹⵜ ⵙ ⵜⵎⵙⵎ ⵀⵔⵔⵏ ⵏⵀⵔⵂⵎ ⴹ ⵜⵜⴶⵎ ⵎⵤⵍⵏ ⵓⵏ ⴶⴰ ⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ⴾⵓⵏⵢ ⵎⵔⵏ ⵎⵔⴹⴰ ⵜⴶⵎⵢⵎ ⴹⵜⵏⵗⵢⵏⵏ ⵏⴾ ⵎⵙⵏ ⵓⴹⵏ ⴹⵓⵏⵎⵍⵏ ⵜⴹⵜ ⵙⵎⴾ ⵓⵙ ⴹⵜⵜⴹⵏⴰ ⵎⵛⵏⴰ⵰ ⵔⵜ ⵓⴹⵢ ⵓⵔ ⵜⴶⴰ ⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ⵎⵤⵍⵏ ⵓⵏ ⴶⴰ ⵀⵏⵓⵏ ⵜⵜⴶⵎ⵰» ⵏⵏⵙ «ⵏⴾⵏⵢ ⵓⵔ ⵏⵎⵙ ⵏⵀⴰ⵰ ⵓⵔ ⵏⵍⴰ ⵔ ⵀⴰ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵔ ⵎⵛⵏⴰ ⵎⵙⵏ ⵀⵏⵓⵏ ⵜⵔⵎⵢ ⴼⵍⵙ ⵎⵛⵏⴰ ⴹⴶⵎⴹⴰ ⵏ⵿ⵜⴰ ⴹⴼⵍⴰ ⵓⵔⴶ ⴶⵔⵢ ⴹⵎⵏⵏ ⵙ ⴹⵙ ⴾⵍⵔ ⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ⵎⴼⵍ ⵓⵔ ⵜⴶⵔⵎ ⵓⵍⵏ⵰ ⵓⵔ ⴹⵓⵏⴶⴹⵍ ⴶⵔⵏⵜ ⵔ ⵙ ⵓⵔ ⵜⴼⵔⴶⵎ ⵙⵙⵎ ⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ⵓⵔ ⵜⵍⵎ ⴹⵗ ⵀⵜⵏ ⵔ ⵀⵍⵙ ⵎⵔⵏ ⵜⵔⵎ ⴹ ⵜⵙⵏ⵿ⴹⵎ ⴹⵔⵏⵏ ⵏⵀⵏⵓⵏ⵰ ⵂⵔⵓⴰ ⵗⵔ ⵏⵜⵢ ⴹ ⵆⵍ ⵎⴶⵢ ⵏⵎⵏ ⵎⵔⵏ ⵓⵔ ⵀⴹⴹ ⴹⵗ ⵜⴹⵜ ⴼⵍⵙ ⵓⵔ ⵜⵂⴰ ⵜⴹⵜ ⵓⵍⵏⵜ⵰ ⴶⵢ ⵏⵀⵂⵓ ⵎⵙⵏ ⵜⵀⵗⵜⵏⵜ ⴼⵍⵙ ⵏⵙⵀⵂⵓ ⵎⵙ ⵎⵙ ⴹⵗ ⵀⴰ ⵏⵀⵂⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ⵏⴾ ⵎⵔⵏ ⵜⴹⵜ ⵙ ⵜⵎⴶⵔⴹⴰ ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵓⵔ⵿ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ⵎⵏⵢ ⴹⵗⵓⵏ ⵓⴰ ⴼⵔⴶⵏ ⴹ ⴶⵢⵜ ⵙ ⴾⵍⴰ ⴹ ⴶⵗ ⵀⴾⴹ⵰ ⴾⴹ ⵜⴹⵜ ⵎⵍⴰ ⵎⴼⵍ ⵓⵔ ⴹⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ⵓⴹⵏ ⵎⵙⵏ ⵔⵜ ⴹⵗ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ ⵙⵙⵎ ⵜⴶⵓ ⵢⵓⴰ ⵏⴰ ⵎⵛⵏⴰ⵰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵔ ⴹⵙ⵿ⵜⵙⵙⵎⵎ ⴼⵍⵙ ⵓⵔ ⵜⵎⵙⵎ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ⵜⵤⵔ ⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵢ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⴾⵍⴰ ⴹ ⵏⵏⴰ ⴾⵢ ⵢⵏ ⴹⵗ ⴾⵍⵙⵎⵔⵢⴰ ⵜⵎⵙⵗ ⵎⵔⵏ ⵂⴾ ⴶⵙⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔ ⴹⵂⴰ ⴶⵙⴼ ⵀⵏⵏ ⵗⵙ ⵙⵗⵎⵔⴰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵓⵔ ⴹⵜⵙⵗⵎⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ⵓⵔ ⴶⵎⵢⵗ ⵜⵏⵢⴰ ⵢ ⵎⵏⵏ⵰ ⵍⵢ ⵓⴰ ⴹⴶⵎⵢⵏ ⵜⵏⵢⴰ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵈⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⵓⴰ ⵜⴼⵏ ⵓⵍⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵏⵢ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ⵏⵏⵙ ⵔⵜ ⴹⵗ ⴾⵍⵍⵢⵂⴹ «ⵎⵔⴹⴰ ⴹ ⵏⴾⵙ ⵛⴾ ⵙ ⵂⴾ ⴶⵙⴼ⵰ ⵀⵔⵂⵎ ⴹⴰ ⵀⵜⵓ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⵏⵀⵜⵏ ⴾⵍ ⴾⵢ ⵎⵔⵏ ⵜⴶⵏⴰ \"ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⴼⵏ ⵓⵍⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵏⵢ ⵜⵎⵜⵏ⵿ⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ⵀⵏⵏⵗ ⵀⵔⵂⵎ ⴹⴰ ⵀⵜⵓ ⵜⵔⴹⵗ ⵙ ⵜⴶⵔⵆⵓ ⵍⵎⵆⵎ⵰ ⵏⵀⵜⵏ ⴹⴰ ⵀⵜⵏ⵰ ⴾⵢ ⵎⴰ ⵜⵈⵙⵀⵗ ⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵙ ⵎⵙ ⵙ ⵎⵏⵏ ⴼⵍ ⵙⵏⵎⵍⴰ ⵓⴹⵢ ⵜⵏⵢⵏⵏ ⵓⵔ ⵜⵏ⵿ⴼⴰ ⵓⵍⴰ⵰ ⵀⵏⵏ ⵙⵏ⵿ⵜⴰ ⵙ ⵜⴶⵏⵎ ⵎⵙ ⵎⵍⵏⵓⵏ ⵏ⵿ⵜⴰ ⴹⵂⴾⵏ ⵜⵏⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ⵎⵔⵏ ⵓⵔ ⵜⵜⵤⴹⵢⵎ ⵎⵛⵏ ⵏⴾ ⵤⴹⵢⵆⵓ⵰ ⵙ ⵏ ⵓⵔ ⵜⵤⴹⵢⴰ ⵓⴹⵢ ⴹ ⵆⵍⵗ ⵏⵙⵀⵂⵓ ⵏⵛⵍⵜⵏⵓⵏ⵰ ⴾⵍⵔ ⵤⴹⵢⵆⵓ ⵎⵔⵏ ⵜⴼⵗ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ⵀⵏⵓⵏ ⵀⵔⵂⵎ ⵎⵍ⵿ⵜⵓ ⴹⵜⴹⵓⵜ ⴼⵍ ⵙ ⴹⵙⴶⵎⴹ ⵛⴾ ⵙ ⴹ ⵏⵢ ⵙⵏⵏ ⵎⵔⵏ ⵏⵢⵜⵓ ⴾⵏⵢ ⵓⵏ ⵙⴼⵍⵓⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ⵏⵏⵙ ⴾⵍⵍⵢⵂⴹ «ⴾⵢ ⵓⵔ ⵜⵓⴹⴰ ⵓⵍⴰ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴶⵙ ⵜⵏ ⵜⵏⵢⵗ ⵀⵔⵂⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ⵏⵙⵏ «ⴶⵢ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹⵜ ⵜⵂⵓⵜ ⵏⵏⵀⵢ ⵀⵔⵂⵎ ⴹⴰ ⵏⴾ ⵎⵙⴰ \"ⵓⴰ ⵍⵏ ⴹ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ⵜⵤⵔ ⴹ ⵜⴾⵎⵏ ⵛⵂⵏ ⵢⴹⵙⴶⵏ ⵤⵀⵓ ⵎⵛⵏ ⵢⴰ ⴶⵎⴹⵜⵏ ⴹⵗ ⵜⵎⵜⵢ ⵔⴹⵗ ⴼⵔⴶ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ⵌⵓⵏ⵿ⴾⵜ ⵗⵢⵙⴰ ⵙ ⵏⵢ ⵍⵙ ⵙⵙ ⴹⵂⵓ ⴹⴰ ⴹⵔⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵓ ⵏⵜⵍⵀⵏⵜ ⵏⵏⵙ «ⵛⵈ ⵎⴼⵍ ⴹⵂⵓ ⵍⵙ ⴹⵜⴹⵔⵗⵍ⵿ⵜ⵰ ⵓⴾ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵜ ⵎⵗ ⴾ ⵀⴾⴹ ⵏⵎⵔⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵔⵎⴹ ⴹⵔⵗⵍ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵜ ⵓⵍⴰ ⴹⵗ ⵀⴾⴹ ⵏⵎⵔⵓⵏⵜ⵰ ⵓⵔ ⴹⵂⵓ ⴹⵜⴹⵔⵗⵍ⵿ⵜ ⵔ ⵢⵙⵔⵙ ⵜⵓⵏⵢⵏ ⴶⵜⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ⵓⵔⵏⵗ ⴹ ⵏⴾⵏⵓ ⵛⵗⵍⵏ ⵏⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴾⵜ ⴹⵢ ⴹ ⴶⴰ ⵤⵍ ⴼⵍⵙ ⵂⴹ ⵤⵢⴹⵓ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵙ ⴼⵔⴶⵏ ⵛⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ⴾⵜ ⵂⵗ ⴹⵏⵜ ⵎⵙⵗ ⵏⵔ ⵏⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ⵙ ⴶⴰ ⵀⵜⵓ ⵜⴰ ⵙⵜⴼ ⴹⵗ ⵎⴹⵍ ⴶⴰ ⵔⵜ ⵏ⵿ⵜⵍⵆ ⵙ ⵎⵜⵎⵏⵜ ⵙⵍⵍ⵿ⵜⵜ ⵢ ⵛⵜⵓⵏ ⵏⵎⴹⵔⵗⵍ ⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ⵏⵙ «ⴶⵍⵓ ⵜⴾⴰ ⵜⵗⵤⵔ⵿ⵜ ⵜⵏ ⵙⵍⵈⵎ ⵜⵛⵔⴹⴰ ⴹⵗⵙ ⴹⵎⵏⴾ⵰» ⵙⵍⵈⵎ ⵍⵎⵗⵏⵏⵜ ⵏⵎⵤⵍ⵰ ⴶⵍⴰ ⵎⴹⵔⵗⵍ ⵛⵔⴹ ⴹⵎⵏⵜ ⵙ ⴹⵆⵍ ⴹⴰ ⵂⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ⴹ ⴶⵏⵏ ⵎⵂⵔⴶⵏⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵢⵏⵏ ⴹⵜ ⵓⵏ ⵎⵙ ⵎⴹⵔⵗⵍ ⵜⵏ⵿ⵙⵢⵏ «ⴾ ⵓⵏ ⵓⵔⴶⵗ ⵍⵙ ⵓⵙ ⴼⵓ ⵆⵎ ⵜⵏ⵿ⵙⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ⵓⵢⴹ ⴶⵏⵏ «ⵏ⵿ⵜⴰ ⴹⵗ ⵓⵏ⵰» ⵓⵢⴹ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⵏⵏ «ⴾⵍⴰ ⵜⵍⵜ ⵗⵙ ⴹⵔⵙ ⴶⴰ⵰» ⵏ⵿ⵜⴰ ⵎⵔⵏ ⴶⵏⵓ «ⵏⴾ ⴹⵗ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ⵜⵙⵙ⵿ⵜⵏⵏ ⴶⵏⵏⵙ «ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⵜⴶⵔⵓⵗ ⵙⵓⴹⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ⴶⵏⵙⵏ «ⵍⵙ ⵙ ⴶⵏⵏ ⵗⵢⵙⴰ ⴶⵏ ⵔⵜ ⵏ⵿ⵜⵍⵆ ⵜⵤⵔ ⵙⵍⵍ⵿ⵜⵜ ⵢ ⵛⵜⵓⵏⵏ ⵏⵢ ⴹ ⴶⵍⵗ ⵛⵔⴹⵗ ⴹⵎⵏ ⴹⵗ ⵜⵗⵤⵔ⵿ⵜ ⵜⵏ ⵙⵍⵈⵎ⵰ ⴶⵍⵗ ⵛⵔⴹⵆⵓ ⵗⵙ ⴶⵔⵓⵗ ⵙⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ⵏⵏⵙ «ⵎⴰ ⴶⴰ ⵤⴰ ⵍⵙ ⵓⴹⵢ⵰» ⵏⵙⵏ «ⵓⵔ ⵙⵏ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ⵍⵓⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⵙ ⵓⵙ ⴾⵍⴰ ⴹ ⵎⵙ ⵎⴹⵔⵗⵍ ⴹⴰ ⵙ ⴼⵔⵙⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ⵏ⵿ⵜⴰ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⴶⴰ ⵗⵢⵙⴰ ⵜⵍⵆ ⵙⵙⵓⴹ ⵎⴹⵔⵗⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ⵜⵙⵙ⵿ⵜⵏⵏ ⴼⵔⵙⵢⵜⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⵜⵎⵓⵜ ⵜⵙ ⴶⵔⵓ ⵙⵓⴹⵏⵜ⵰ ⵏⵙⵏ «ⵔⵜ ⵏ⵿ⵜⵍⵆ ⵙⵍⵍ ⵛⵜⵓⵏⵏ ⵛⵔⴹⵗ ⴹⵎⵏ ⵙⵓⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ⴹ ⴶⵏⵏ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ «ⵍⵙ ⵓⴰ ⴶⵏ ⵔⵜ ⵓⴰ ⵓⵔ ⴹⴼⵍ ⵎⵛⵏⴰ ⴼⵍⵙ ⵓⵔ ⵙⵙⵂⵜ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜⵏⵏⴰ⵰» ⵏⵏ ⵓⵢⴹ «ⵍⵗⵍⵎⵜⵏ ⵛⵏ ⵎⵏⵎⴾ ⵙ ⵜⵏⵜⵤⴶⵓ ⵓⴹⵏ ⵎⵙⵏ ⵏⵙⵀⴾⴹ⵰» ⵜⵤⵔ ⴶⴰ ⵎⵤⵔⵢ ⴶⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ⵍⵙⵏ ⵙⵙ⵿ⵜⵏ ⵏⵍⵙ ⵓⵙ ⴾⵍⴰ ⴹ ⴹⵔⵗⵍ ⵏⵏⵙ «ⴾⵢ ⵏⵏ ⵤⵤⵢⴾⵢ ⵍⵙ ⴹⵗ ⵜⴹⵔⵗⵍ⵿ⵜ ⵎⵍⵏⵗ ⵓⵙ ⵜⵔⴹⵗ ⵙ ⵎⵙ⵿ⵜⵓ⵰» ⵏⵙⵏ «ⵏⵀⵢ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ⴶⵍⵏ ⴼⵔⵙⵢⵜⵏ ⵓⵔ ⵤⴶⵤⵏⵏ ⵙ ⵍⵙ ⵓⴰ ⴾⵍⴰ ⴹ ⴹⵔⵗⵍ ⵂⵔ ⴹⵙⵙⵗⵔⵏ ⵎⵔⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ⵏⵏⵙⵏ «ⴾ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵀⵔⵔⵏⵓⵏ ⵓⵙ ⵜⵏⵎ ⵙ ⴹⵂⵓ ⴹⴰ ⴹⵔⵗⵍ⵰ ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⴶⵔⵓ ⵙⵓⴹⵏⵜ ⵎⵔⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ⵏⵏⵙⵏ ⵎⵔⵓⵏ ⵏⵍⵙ «ⵏⵙⵏ ⵙ ⵀⵔⵔⵏⵏⵗ ⵎⵙ ⵏⵙⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵙ ⵙ ⴹⵂⵓ ⴹⴰ ⴹⵔⵗⵍ ");
INSERT INTO ttqt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ⵎⵛⵏ ⵓⵔⵎⴹ ⵏⵙⵏ ⵜⵎⵓⵜ ⵜⵙ ⴶⵔⵓ ⵙⵓⴹⵏⵜ ⵤⴰ ⵓⵍⴰ ⴹⵗ ⵓⴹⵏ ⵓⴰ ⵜⵙⵙⵓⴹⵏ⵰ ⵙⵙ⵿ⵜⵏⵜⵓ ⵎⵏⵜ ⴼⵍⵙ ⵍⵙ ⵓⵛⵔⵏ ⵎⵙ ⴼⵔⴶⵏ ⴹ ⵎⴶⵔⴹ ⴹⵗ ⵜⵍⵗⴰ ⵜⴰ ⵜⵜⵆⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ⵀⵜⵓ ⵜⴰ ⵓⵔ ⵜⵜⴶⵏ ⵎⵔⵓⵏⵜ ⵔ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴼⵍⵙ ⵜⵏⴰ ⴶⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵢⵏ ⵙ ⵗⵢⵙⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵓⴹⵢ ⴹ ⵜⴾⵙⵏ ⴹⵗ ⵍⵌⵎⵗⵜ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ⵓⵏ ⴹⴰ ⴼⵍ ⵏⵏ ⵎⵔⵓⵏⵜ «ⵜⵛⵔⵢⵏⵜ ⵜⵛⵛⵓⴹⵜⵓ ⴹⵓⵏⵎⴶⵔⴹ ⴹⵗ ⵜⵍⵗⴰ ⵜⴰ ⵜⵜⵆⵍⵜ ⵙⵙ⵿ⵜⵏⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ⵍⵙⵏ⵿ⴹⵓ ⴼⵔⵙⵢⵜⵏ ⵜⵗⵔⵢ ⵏⵍⵙ ⵓⵙ ⴾⵍⴰ ⴹ ⴹⵔⵗⵍ ⵏⵏⵙ «ⴾⵙⴹ ⵎⵛⵏⴰ ⵜⵎⵍⴰ ⵜⴹⵜ⵰ ⵏⴾⵏⵢ ⵏⵙⵏ ⵙ ⵍⵙ ⴹⵢ ⵏⵙⵀⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ⵏⵙⵏ ⵍⵙ ⵓⴰ «ⵏⴾ ⵓⵔ ⵙⵏⴰ ⴾⴹ ⵏⵙⵀⴾⴹ ⵎⵙ ⵓⵍⴰ⵰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⴹⵗ ⵙⵏⴰ ⵙ ⴾⵍⴰ ⴹ ⴹⵔⵗⵍⴰ ⵎⵔⴹⴰ ⵂⵏⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ⴹⴼⵔ ⵓⵏ ⵏⵏⵙ «ⵎⴰ ⵎⵙ ⵔⵜ ⵓⴰ ⴹⴾⴶⴰ⵰ ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⴾⵢⵙⵙⵓⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ⵏⵙⵏ «ⵔⵜ ⵓⴹⵢ ⵢⴰ ⵎⵍⵗⵓⵏ⵿ⵜⵓ ⵎⵛⵏ ⵓⵔ ⴹⵜⵤⴶⵤⵏⵎ⵰ ⵎⴼⵍ ⵜⵔⵎ ⴹⵓⵏ⵿ⵜⵍⵙⵗ ⵎⵍ⵰ ⵎⵆⵍ ⴾ ⴾⵓⵏⵢ ⴹⴰ ⵜⵔⵎ ⴹ ⵜⵆⵍⵎ ⵏⵍⴾⵎⵏⵜ ⴾⵜⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ⴶⵏⵙ ⵔⵀⴹⵏ ⵏⵏⵙ «ⴾⵢ ⵎⵙⵏ ⵏⵍⴾⵎⵏⵜ ⵏⴾⵏⵢ ⵏⵍⴾⵎⵏ ⵏⵏⵀⵢ ⵎⵙⴰ ⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ⵎⵙⴰ ⵏⵙⵏ ⵙ ⵛⵓⵍⵙ ⵎⵛⵏⴰ ⵎⵔⵏ ⵍⵙ ⵓⴹⵢ ⵓⵔ ⵏⵙⵏ ⵙⵙ ⴹⵂⴰ ⴼⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ⵏⵙⵏ «ⵍⵙ ⵓⴰ ⵓⵔ ⵜⵙⵏⵎ ⵓⵍⴰ ⵙⵙ ⴹⵂⴰ ⵎⵛⵏ ⵤⵤⵢⵢ ⴹⵗ ⵜⴹⵔⵗⵍ⵿ⵜ⵰ ⵔⵜ ⵢⴰ ⵓⴰ ⵏ⵿ⵜⴰ ⵙⵎⴾⵍⵍⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ⵜⵙⵏⵎ ⵙ ⵎⵛⵏⴰ ⵓⵔ ⵆⵀⵍ ⵛⵓⵜⵔⵓⵏ ⵏⵙⵀⴾⴹⵏ⵰ ⵓⴹⵏ ⵓⴰ ⴹⵙⵀⵔⴹⴶⵏ ⵜⵎⵤⵍ ⵜⵔⵏⵜ ⵏ⵿ⵜⴰ ⵙ ⵆⵀⵍ ⵛⵓⵜⵔⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ⵓⵔ ⴾⵍⴰ ⴹ ⵜⵓⵙⵍⴰ ⵓⴹⵏ ⵙⵙⵓⴹⵏ ⵢⵏ ⴹⵂⵓⵏ ⴹⵜⴹⵔⵗⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ⵏⵔ ⴹⵓⵔⴼⵍ ⵍⵙ ⴹⵢ ⵎⵛⵏⴰ ⵓⵔ ⵤⴼⵔⴶ ⴶⵢ ⵏⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ⵂⵔⵛⵏ⵿ⵜⵓ ⵏⵏⵙ «ⴾ⵰ ⴹⵙ ⴾⵢ ⵓⵙ ⵙ ⴹⵜⵂⵓⴰ ⴹⴰ ⵜⵎⵙⴰ ⵜⵀⵍⵍⵆ ⵏⵀⴾⴹ ⴾⵢ ⵔⵏ ⴹⵏⵜⴾⴼⵗ ⵍⴼⵢⴹⵜⵏ⵰» ⵜⵤⵔ ⵙ⵿ⵜⵗⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵎⵤⵍ ⵓⴰ ⴶⵏ ⴹⴰ ⵙⵓⴹ ⵢⵍⵙ ⵓⵏ ⵂⵔ ⵜⴶⵔⵓ ⵏⵙ «ⵓⴾ ⵜⵤⴶⵤⵏⵗ ⵙⵔⵢ ⴶ ⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ⵏⴰ ⵍⵙ ⵢ ⵗⵢⵙⴰ «ⵎⵍⵢ ⵓⴰ ⵎⵙ ⵎⵍⵏⵏ ⴼⵍⵙ ⵔⵗ ⵙⵔⵙ ⵤⴶⵤⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ⵏⵙ ⵗⵢⵙⴰ «ⵜⵏⵢⵆⵓ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⴹⴾⵎⴶⵔⴹⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ⵏⵙ ⵍⵙ «ⴹⵗ ⴹⵢ ⵤⴶⵤⵏⵗ ⵎⵍⵏⵏ⵰» ⵜⵤⵔ ⵙⵌⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ⵎⵔⵏ ⵏⴰ ⵗⵢⵙⴰ «ⵏⴾ ⵙⴰ ⴹⴶⵗ ⴹⵏⵜ ⵢⴹ ⵎⵤⵍⵗ ⵛⵔⵗⴰ ⵙⵓⴹⵏ ⵓⵏ ⵓⵔ ⵏⵂⵏⵢ ⴹⵔⵗⵍⵏ ⵓⵏ ⵂⵏⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ⵙⵍⵏ ⵔⵜ ⴹⵗ ⴼⵔⵙⵢⵜⵏ ⵓⵏ ⴹⵔ ⴹⵓ ⵢⵓⴰ ⵏⴰ ⴹⴰ ⵏⵏⵙ «ⴹⵗ ⴹⵢ ⵏⴾⵏⵢ ⴹⴰ ⵎⴹⵔⵗⵍ ⵏⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵔ ⵜⵎⵙⵎ ⵎⴹⵔⵗⵍ ⵓⴹⵢ ⵓⵔ ⴾⵓⵏⵓⵔ ⵀⴾⴹ ⵎⵛⵏ ⴹⴹ ⵎⵙ ⵙ ⵜⴶⵏⵎ \"ⵏⴾⵏⵢ ⵏⵂⵏⵢ\" ⵓⴹⵢ ⵓⵔⴾⵓⵏ ⵀⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⴶⵤ ⴼⵔⴶ ⵏⵢⴼⴹ ⵙⵎⵢ ⵓⵙ ⵜⵓⴶⵤ ⵜⵔⴶⵜⴹⵓ ⵓⴹⵢ ⵀⵢⴹⴶ ⵎⵙ ⵏⵏⵔⴾⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ⵎⵔⵏ ⵓⴰ ⴹⴶⵤⵏ ⵙⵎⵢ ⵏⴼⵔⴶ ⵓⴹⵢ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⴹⵏ ⵏⵢⴼⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ⵏⵗⵍⴼ ⵏⴼⵔⴶ ⴹⵙⵤⵍⵎⵏ ⵎⵢ ⵙⵍⵏⵜ ⵢⴼⴹ ⵢⵎⵙⵍⵏⵜ ⴹ ⵗⵔⵓ ⵛⵏⵜ ⵙⵙⵎⵓⵏⵙⵏⵜ ⵙⵔⴹⵆⵏⵜ ⴼⵔⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ⵙ ⴹⵗⵔⴹ ⴾⵙ ⵏⵛⵏⵜ ⴹⵙⵏⵜⵤⵔ ⵍⴾⵎⵏⵜⵙ ⴼⵍⵙ ⵤⴹⵢⵏⵜ ⵎⵙⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ⵙ ⴶⴰ ⵓⵏ ⵓⴹⵏ ⵓⴰ ⴹⵙⵏⵜⵎⵙⵏ ⵏⴼ⵿ⵜⵗ ⵓⵔ ⴹⵙⵤⵍⴾⵎⵏⵜ ⵓⴼ ⴼⴹⴰ ⵜⵤⴶⵏⵜ ⴼⵍⵙ ⵓⵔ ⵤⴹⵢⵏⵜ ⵎⵙⵍⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ⵍⵎⵜⵍ ⵓⴰ ⴹⴰ ⴹⵙⵏⴶⴰ ⵗⵢⵙⴰ ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ ⵍⵎⵗⵏⴰ ⵏⵓⴰ ⴹⵗⵙⵏ ⵎⴶⵔⴹ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵏⴾ ⵎⵙⵏ ⵎⵢ ⵓⵙ ⵔⴹⵗⵏⵜ ⵢⴼⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ⵓⵏ ⴹⵜⵢ ⴹⵙⵏⵏ ⴾⵍ ⵀⵢⴹⴶⵏ ⵏⵔⴾⵀⵏ ⵎⵙⵏ ⵎⵔⵏ ⵓⵔ ⴹⵙⵏⵙⵙⵎⵏⵜ ⵢⴼⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ⵏⴾ ⵎⵙⵏ ⵎⵢ ⵏⴼⵔⴶ⵰ ⵓⴰ ⵙⵔⵢ ⴹⴶⵤⵏ ⴹ ⴼⵙⵓ⵰ ⴼⵔⴶ ⴹ ⵜⴶⵤ ⵔⴹⵗ ⴶⵔⵓ ⵏ⵿ⵜⴹⴰ ⵎⵏ⵿ⵙⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ⵀⵢⴹⴶ ⵓⵔ ⴹⵜⵙⵓ ⵔ ⴼⵍ ⵛⴾⵔⴰ ⴹⴶⵢ ⵏⵎⵏ ⴹⵂⵍⴾ⵰ ⵏⴾ ⵎⵔⵏ ⵙⴹⵓ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵢⵜⴹⵏ ⵜⵎⴹⵔ⵿ⵜ ⴶⵔⵓⵏ⵿ⵜⵜ ⴹⴰ ⵤⴰ ⵙ ⵜⵎⵓⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ⵏⴾ ⵎⵙⵏ ⵎⴹⵏ ⵓⴰ ⵍⵗⵏ⵰ ⵎⴹⵏ ⵓⴰ ⵍⵗⵏ ⵎⵏⵜ ⵂⴾⵓ ⴼⵍ ⵢⴼⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ⵎⵛⵏ ⵓⴹⵏ ⵓⵙ ⵢⴼⴹ ⵓⵔⴶⵗ ⵛⵏⵜ ⵜⵓⵗⴼⵔ ⵗⵙ ⵜⵓⴶⴰ ⵢⵜⵏⵜⴹⵏ ⵓⴹⵢ ⵙ ⴶⴰ ⵔⴹⵍ ⵤⵢⵜⵏⵜⴹⵓ ⴹ ⴹⴶⴶ ⵢⵏⵜⵏ ⵀⵤ ⴹⵗⵙⵏⵜ ⵔⴹⵍ ⵓⴰ ⵔⴰ ⵤⵓⵤⵓⵤⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ⵔⵜ ⵓⴰ ⵜⴶⵢ ⵍⵙ ⵓⴰ ⴼⵍⵙ ⵜⵓⵗⴼⵔ ⵗⵙ ⴶⴰ ⵢⵛⵗⵍ ⵓⴰ ⵓⵔ ⵤⵍⵢ ⴶⵏⵜ ⵢⴼⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ⵏⴾ ⵎⵙⵏ ⵎⴹⵏ ⵓⴰ ⵍⵗⵏ⵰ ⵤⴹⵢⵗ ⵢⴼⴹⵏ ⵢⴼⴹⵏ ⴹⵗ ⵤⴹⵢⵏⵜⵢ ");
INSERT INTO ttqt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ⵙ ⵜⵎⵓⵜ ⵜⴰ ⴹⵗ ⵙ ⴹⵤⴹⵢ ⵀⵏⵏ ⵏⴾ ⴹⵗ ⵤⴹⵢⵆⵓ⵰ ⴾⴼⵗ ⵎⵏⵏ ⴼⵍ ⵢⴼⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ⵍⵗ ⵢⴼⴹ ⵛⵢⴹ ⵓⵔ ⵏⵂⴰ ⴼⵔⴶ ⵓⴰ⵰ ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ ⴾⵏ⵿ⴹⵀⴰ ⵤⵔⵗⵙⵏⵜ ⵙⵍⵏⵜ ⵢⵎⵙⵍⵏⵏ⵰ ⵢⴼⴹⵏ ⴾⵍ ⴹ ⵔ⵿ⵜⵢⵏⵜ ⵆⵍⵏⵜ ⵙⴶⵏ ⵢⵏ⵿ⴹⴰ ⵍⵏ ⵎⴹⵏ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ⵀⴰ ⵔⵢ ⴼⵍⵙ ⵎⵏⵏ ⴾⴼ ⴼⵍ ⵜⵏⵍⵙⵗ ⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵢ ⵤⵀⵤⵏ ⵎⵏ ⴾⵍⵔ ⵎⵏⵏ ⴾⴼⵗ ⵙ ⵜⵔⴹⵓⵜⵏ⵰ ⵍⵗ ⴼⵔⴶⵜ ⵏ⵿ⵜⵂⴾⵢⵏⵙⵏ ⵍⵗ ⴹⴰ ⴼⵔⴶⵜ ⵏⵙⵗⵍⵏⵙⵏ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵗ ⵔⵜ ⵓⵙ ⴹⵎⵔ ⵀⵏⵏ ⵙⴶⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ⵍⵙⵏ ⴾⵍⵍⵢⵂⴹ ⵎⵤⵔⵢ ⴹⵗ ⵜⵍⵗⴰ ⵏⵔⵜⵏ ⵓⵏ ⴶⵏⵓ ⵗⵢⵙⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ⴹⵗⵙⵏ ⴶⵏ ⴶⵏⵏ «ⵍⵙ ⵓⴰ ⴶⵙⴼ ⵜⵂⵏ⵰ ⵓⴰ ⵎⵙⴾⵍ⵰ ⵎⴼⵍ ⵜⵙⵙⵎⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ⵓⵢⴹ ⴶⵏⵏ «ⵓⴹⵏ ⵂⴰ ⴶⵙⴼ ⵓⵔ ⵜⴶⵓ ⵓⵍ ⵓⴰ⵰ ⵜⵔⴹⵎ ⵙ ⵍⵢ ⴶⵙⴼ ⴼⵔⴶⵏ ⵙⵙⵓⴹ ⵏⵎⴹⵔⵗⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ⵤⵎⵏⵏ ⵜⴶⵔⵙ⵿ⵜ⵰ ⵓⴹⵓ ⵎⴹ ⵎⵙⵏ ⵙⴾⵜⵏ ⵏⵜⵓⵤⵤⴹⴶ ⵓⴰ ⴶⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ⵜⵌⵓⵏ⵿ⴾⵜ ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵓⵍ ⴹⵜⵔⵢⵜ ⵜⴼⵍⵜ ⵙ ⵜⵓⵏⵓ «ⵜⴰ ⵏ⵿ⵙⵍⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ⵗⵍⵢⵗⵍⵢⵏ⵿ⵜⵓ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⴶⵏⵏⵙ «ⴾⵢ ⴾ ⵂⵔ ⵎⵢ ⵓⵔ ⴹⵏⵜⵔ ⴹⵗ ⵗⴼ⵰ ⴾⴹ ⴾⵢ ⵍⵎⵙⵈ ⵜⵎⵙⴰ ⵜⵤⵍⵍⵗⴹⵓ ⴹⴰ ⴹⴰ ⵜⵏⵗⵏⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵍⵗⵓⵏ ⵎⵛⵏ ⵓⵔ ⴹⵜⵤⴶⵤⵏⵎ⵰ ⵎⵤⵍⵏ ⵓⵏ ⴶ ⵙⵙⵎ ⵏⵀⵏⵏ ⴶⵢⵏⵢ ");
INSERT INTO ttqt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ⵎⵛⵏ ⵓⵔ ⴹⵜⵤⴶⵤⵏⵎ ⴼⵍⵙ ⵓⵔ ⵜⵜⵀⵆⵎ ⴹⵗ ⵢⴼⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ⵢⴼⴹⵏ ⵙⵍⵏⵜ ⵢⵎⵙⵍⵏⵏ ⵤⴹⵢⵆⵏⵜ ⵎⵔⵏ ⵍⴾⵎⵏⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ⴾⴼⵆⵏⵜ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵓⵔ ⴹⵗⵙⵏⵜ ⵜⵍⴾⵎ ⵜⵎⵜⵏ⵿ⵜ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵗⵢ ⵜⵏⵜⵤⵔⴾⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ⵀⵏⵏ ⴹⵜⵏⵜⴾⴼⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵓⵔ ⴶⵔ⵰ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵜⵏⵜⵤⵔⴾⵀⵏ ⴹⵗ ⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ⵏⴾ ⴹⵀⴰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵏⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ⵍⵙⵏ⵿ⴹⵓ ⵙⵔⵙ ⴹⴾⵍ ⵏ⵿ⵜⵂⵏ ⵢⴹ ⵜⵏ⵿ⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵙⴾⵏⵆⵓⵏ ⵎⵤⵍⵏ ⴶⵜⵏⵏ ⵍⵗⵏⵏ ⴹⴼⵍⵏⵏ ⵀⴰ⵰ ⵎⵏⵢ ⴹⵗⵙⵏ ⵓⴰ ⴼⵍ ⵜⵔⵎ ⴹⵜⵏ⵿ⵗⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ⵏⵏⵙ «ⵏⴾⵏⵢ ⵓⵔ ⵏⵔⴰ ⵜⵏⵗⵢⵏⴾ ⴼⵍ ⵙ ⵜⴶⵗ ⵎⵤⵍ ⵍⵗⵏ ⴾⵍⵔ ⵎⴹⵔⵓ ⵓⴰ ⵜⴶⵗ ⴹⵢ ⴼⵍ ⴾⵢⵤⵏⵏ⵿ⵗⵓ⵰ ⴾⵢ ⵓⵔ ⵜⵎⵙⵗ ⵔ ⴶⴹⵎ ⵎⵔⵏ ⵜⵔⵗ ⴹ ⵜⴶⵗ ⵎⵏⴾ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⴾ ⵓⵔⴶⵗ ⴾⵜⵀ ⴹⵗ ⵜⵓⵔⵜ ⵙ ⵏⴰ ⵎⵛⵏⴰ \"ⴾⵓⵏⵢ ⵜⵎⵙⵎ ⵎⵍⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ⵓⵔ ⵏⴼⵔⴶ ⴹⵏⴶⵔ ⵔⵜ ⵓⴰ ⵂⵏ ⵍⴾⵜⵀⵏ⵰ ⵙⵎ ⵓⵏ ⵎⵍⵏ ⵗⵔⴰ ⵙⵔⵙ ⵎⵛⵏⴰ ⵢⵜⴹⵏ ⵓⵏ ⴾⴰ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ⵏⴾ ⵎⵛⵏⴰ ⴹⵙⵏⴼⵔⵏⵏ ⵤⵎⵤⵍⴹⵓ ⵙⴹⵏⵜ⵰ ⵎⵏⵎⴾ ⴹⵗ ⴹⵢ ⵙ ⵤⴰ ⵜⵏⵎ ⵜⴶⵗ ⵎⴹⵔⵓ ⴼⵍⵙ ⵏ \"ⵎⵙⴰ ⵀⵔⵔ ⵏⵎⵛⵏ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ⵙ ⵎⵙ ⵙ ⵓⵔ ⵜⴶⵗ ⵎⵤⵍⵏ ⵓⵏ ⵙ ⴹⴹⵙⴶⵍⴰ ⵀⵏⵏ ⵢⵜⵏⴶⴰ ⴹⵓⵔ⵿ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ⵎⵛⵏ ⴹⴹ ⵎⵙ ⵙ ⵜⴶⵆⵏ ⵓⴹⵢ ⴾⴹ ⵙⵔⵢ ⵓⵔ ⵜⵤⴶⵤⵏⵎ ⴹⴰ ⵤⴶⵤⵏⵜ ⴾⴹⵗ ⵙ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⴰ ⴼⵍ ⴹ ⵜⵙⵏⵎ ⵜⵙⵏ⵿ⵜⵎ ⴹⵗ ⴹⵗ ⴶⵔⵢ ⵏⵙ ⵀⴰ ⵔ⵿ⵜⵢ ⴹⵔⵢ ⵏⴾ ⴹⵗ ⵔ⵿ⵜⵢⴰ ⴹⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ⵍⵙⵏ ⴶⵎⵢ ⴹⵀⵤⵏⵜ ⵎⵛⵏ ⴶⵎⴹⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ⵍⵙ ⵗⵢⵙⴰ ⴾⵢ ⵏ⵿ⵜⴶⴹⵎⵢⵜ ⵜⴰ ⵂⴹⵜ ⵏⵢⵔⴹⵏ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵙⵏ⵿ⵜⴰ ⵢⵈⵢⴰ ⵙⵍⵎⵗ ⵏⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵆⵎ ⴹⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ⵙⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵏⵏ «ⵢⵈⵢⴰ ⵓⵔ ⴶⴰ ⵍⵗⵍⵎⵜ ⵓⵍⵢⵜ ⵎⵛⵏ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵏⵗⵏⴰ ⵙⵍⵙ ⵓⴰ ⵜⴹⵜ ⵎⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ⴹⵏ ⴹⵗ ⴹ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ⵍⵢ ⵍⵙ ⵔⵏⵏ ⴶⵏ ⵙⵎ ⵍⵤⵔⵙ ⵂⵏ ⵜⵗⵔⵎ⵿ⵜ ⵏⵀⵜⵏⵢ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵜⵗⵙⵔ ⵎⵔⵢⵎⴰ ⴹⵎⵔ⵿ⵜⴰ ⵎⵙⵏⵏ ⵛⵎⴹⵔⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ⵎⵔⵢⵎⴰ ⵜⴰ ⴹⴰ ⵜⵏ⵿ⵗⵍⵜ ⵍⵓⵔⴹⵢ ⴼⵍ ⵎⵍⵢ ⵗⵢⵙⴰ ⵜⵎⵙ ⴹⵔⵏⵜ ⵙ ⵌⴾⴹⵏⵜ⵰ ⵎⵔⵏ ⵎⴹⵔⵢⵏⵜ ⵍⵤⵔⵙ ⵔⵏⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ⵙⴾⵏⵜ ⵜⵎⴹⵔⵢⵏⵜ ⵗⵢⵙⴰ ⵎⵤⵍ ⵙ «ⵎⵍⵢ ⵎⵔⵏⴾ ⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ⵙ ⵙⵍⴰ ⵗⵢⵙⴰ ⵢ ⵙⵍⵏ ⵓⵏ ⴹⵏ ⵏⴰ «ⵜⵙⵍⴾⵎ⵿ⵜ ⵏ⵿ⵜⵓⵔⵏⴰ ⵜⵏ ⵓⵔ ⵤⴰ ⵜⵆⵍ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵤⵔⵙ ⵔⵜ ⵜⵎⵙ ⵤⵙⴾⵏⵏ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵙⵏⴼⵍⵍⴹⵓ ⵏ⵿ⵜⴹⴰ ⵜⵏⵢⴰ ⵜⴰ ⵍⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ⵗⵢⵙⴰ ⵔⴰ ⵎⵔ⵿ⵜⴰ ⵓⵍⵏ ⵏ⵿ⵜⴰ ⴹⵜⵎⴹⵔⵢⵜⵏⵜ ⴹⵍⵤⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ⵙⵍⴰ ⵜⵓⵔⵏⵏⵜ ⵎⵛⵏ ⴶⴰ ⴹⴼⵔ ⵓⵏ ⵛⵏ ⴹⵏ ⵓⵔ ⴶⵎⴹ ⴹⴶ ⵓⴰ ⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ⴹⴼⵔ ⴹⵢ ⵏⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵏ⵿ⴹⵓⵜ ⴹ ⵏⵆⵍ ⵢⵂⴹⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵛⵈⵏⵏⴰ ⵎⵤⵔⵏⵏⴰ ⵓⵔⴶ ⴹⵙⵏⵙⵏ ⵙⴾⵜ ⴹⴰ ⴹⴰ ⴹⴰ ⴶⵎⵢⵏ ⴹⵜⵏⵗⵢⵏⴾ ⴾⵢ ⵎⵔⵏ ⵜⵔⵗ ⵜⵓⵗⵍⵢ ⵏⴾⵍ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵤⵍ ⵓⵔⴶⵗ ⵎⵔⵓ ⵍⵓⵆⵏ ⴹⵛⵏ ⵎⵙ⵰ ⵙ ⵌⵓⵏ⵿ⴾⵜ ⵓⴹⵏ ⵤⵍ ⵓⵔ ⵤⵏⴶⵔ⵿ⵜⵜⴼ ⴼⵍⵙ ⵂⵏⵢ ⴹⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ⵎⵛⵏ ⵙ ⵌⵓⵏ⵿ⴾⵜ ⵓⴹⵏ ⵂⴹ ⴹ ⵏⴶⵔ⵿ⵜⵜⴼ ⴼⵍⵙ ⵓⵔ ⵜⵂⴰ ⵏⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ⵙ ⴶⴰ ⵀⵜⵓ ⵜⴰ ⵏⴰ ⵜⵍⵙ «ⵎⴹⵏⵏⴰ ⵍⵤⵔⵙ ⵏ⵿ⵙⴰ ⴹ ⴶⵍⵗ ⵜⴹⵙⵏ⵿ⴾⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵎⵍⵢ ⴹⴹ ⵤⵎⵙ ⵏ⵿ⵙⴰ ⵓⴹⵢ ⵏ⵿ⴶⵎ ⴹ ⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵤⵔⵙ ⵙ ⴹⵙⵏⵎⴶⵔⴹ ⴹⵏ ⵎⵛⵏ ⵏ⵿ⵜⵏⵢ ⵗⵍⵏ ⵜⵙ ⵓⵏ ⵍⵗⴹⵜ ⵙ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ⴹⵢ ⴼⵍ ⴹⵤⵍⵍⵗ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵍⵤⵔⵙ ⵀⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ⵎⵔⵏ ⵙⴹⵓⵜⵢ ⵙ ⵓⵔ ⵍ ⴹⵏ ⵍⵓⵆ ⵓⴹⵢ ⴼⵍⵙ ⵔⵜ ⵓⴰ ⵏ⵿ⵜⴰ ⵙⵔⵓⵏ ⴹⵤⵓⵢⵏ ⵙⵔⵢ ⵜⵤⴶⵤⵏⵎ⵰ ⵎⵔⴹⴰ ⵏ⵿ⴹⵓⵜⵏⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ⵏ⵿ⴾⵔ ⵜⵎⴰ ⵓⵙ ⴶⵏⵏ ⴾⵏⵢ ⵏⴰ ⵢ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ «ⵏ⵿ⴹⵓⵜ ⵏⴾⵏⵢ ⴹⴰ ⴹⵏⵗⵀⴰ ⵏⴹⵓ ⴹⵔⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ⵙ ⴹⵏⵙⴰ ⵗⵢⵙⴰ ⵜⵎⵍⵙ ⵙ ⵍⵤⵔⵙ ⴶⴰ ⴾⵤ ⴹⵏ ⴹⵗ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ⵀⵜⵏⵢ ⵜⵂⵤ ⵢⵔⵙⵍⵎ⵰ ⴹⴶ ⵏ⵿ⴾⵔⴹ ⴾⵍⵓⵜⵏ ⵗⵙ ⵍⵏ ⴶⵔⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ⵙⵏⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⵎⵔ⵿ⵜⴰ ⴹⵎⵔⵢⵎⴰ ⴼⵍ ⴹⵙⵏⵜⵏⵛⵓⵛⴾⵏⵏ ⴹⵗ ⴹⴶ ⵏⵎⴹⵔⵢⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ⵙ ⵜⵙⵍⴰ ⵎⵔ⵿ⵜⴰ ⵙ ⵗⵢⵙⴰ ⵂⵤⴹⵓ ⵜⵗⵔⵎ⵿ⵜ ⵜⵙⵍⴾⴹⵙ⵰ ⵎⵔⵢⵎⴰ ⵏ⵿ⵜⴰ ⵜⵆⵎⵏ ⴹⵗ ⵗⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ⵜⵏⴰ ⵎⵔ⵿ⵜⴰ ⵢ ⵗⵢⵙⴰ «ⵎⵍⵢ ⵏⵔ ⵜⵍ ⴹⴰ ⵓⵔ ⵤⵀⴰ ⵎⴹⵔⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ⵎⵛⵏ ⵎⵔⴹⴰ ⴹⴰ ⵙⵏⵗ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴹⴾⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴹⵔⵢⵏⵎ ⴹⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ⵜⵏⵙ ⵎⵔ⵿ⵜⴰ «ⵙⵏⵗ ⵙ ⵎⴹⵔⵢⵏⵏ ⴹⵏ⵿ⴾⵔ ⵗⵔ ⵜⵏⴾⵔⴰ ⵏⵢⵜⴹⵏ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ⵏⵙ ⵗⵢⵙⴰ «ⵏⴾ ⵎⵙⵏ ⵓⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵙⴰ ⵜⵎⴹⵔ⵿ⵜ⵰ ⵓⴹⵏ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵓⴹⵢ ⴾⴹ ⵜⵀⴰ ⴹⴰ ⴹⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵔⵏ ⵤⴶⵤⵏ ⵙⵔⵢ ⵓⴹⵢ ⵓⵔ ⵍⴾⵎ ⴹ ⵜⵀⴰ⵰ ⵜⵤⴶⵤⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ⵜⵏⵙ «ⵓⵍⴰ ⵎⵍⵢ ⵤⴶⵤⵏⵗ ⵙ ⴾⵢ ⵎⵙⵏ ⵍⵎⵙⵈ ⵜⵎⵙⴰ ⴹⵗ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵙ ⵜⵎⵍ ⵙ ⴹⵙⵓ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ⵙ ⵜⴶⴰ ⵎⵔ⵿ⵜⴰ ⵀⵜⵓ ⵜⴰ ⵜⴾⴰ ⵜⵎⴹⵔⵢⵜⵏⵜ ⵎⵔⵢⵎⴰ ⵜⵓⵜⵜ ⵙⵂⵍ ⵜⵏⵙ «ⵛⵈ ⵍⴹⴰ ⵙⵙ⵿ⵜⵏ ⴹⵔⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ⵙ ⵜⴶⵔⵓ ⵎⵔⵢⵎⴰ ⵙⵍⵏ ⵓⵏ ⵜⴶⴹⵓ ⵜⵙⵍⴾⴹ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ⵙ ⵜⴶⵓ ⵓⵏ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴹⴶⵤ ⵜⵗⵔⵎ⵿ⵜ ⵓⵔ ⴶⵎⴹ ⴹⴶ ⵓⴰ ⴹⵆ ⵏ⵿ⵜⵙⴰ ⵎⵔ⵿ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ⵍⵏ ⴾⵍⵍⵢⵂⴹ ⵗⵔ ⵎⵔⵢⵎⴰ ⴹⵙⴹⵛⵓⵛⴾⵏⵏ⵰ ⵙ ⵜⵜⵏⵢⵏ ⵙ ⴹⵜⴶⴹ ⵜⵔⵎⴹ ⵜⵆⵀ ⵍⴾⵎⵏⵙ ⵗⵍⵏ ⵤⴾⴰ ⵜⴾⴰ ⵢⴼⵍⵙ ⵜⵂⵍⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ⵙ ⴹⵏ⵿ⵜⵙⴰ ⵎⵔⵢⵎⴰ ⴹⴶ ⵓⴰ ⵂⴰ ⵗⵢⵙⴰ ⵜⴶⵢ ⵗⵙ ⵜⴼⵜⵆⵜ ⵗⵔ ⴹⵔⵏⵜ ⵜⵏⵙ «ⵎⵍⵢ ⵏⵔ ⵜⵍ ⴹⴰ ⵓⵔ ⵤⵀⴰ ⵎⴹⵔⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ⵙ ⵜⵜⵏⵢ ⵗⵢⵙⴰ ⵜⵂⵍⵓ ⵏⵢ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵔⵙ ⴹⴹⵓⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵂⵍⵏ ⴾⵏⴰ ⵜⵔⵎⵆ ⵗⵛⴹⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ⵏⵙⵏ «ⵎⵏⵢ ⵜⵜⴶⵎ⵰» ⵏⵏⵙ «ⵎⵍⵢ ⵢⵓ ⵜⵏⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ⴹ ⵂⵍⵓ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ⵏⵏ ⵢⵜⴹⵏ «ⵏⵓⵜ ⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵔⴰ ⵜⴰ ⴶⴰ ⵢⵍⵙ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ⵜⵤⵔ ⵏⵏ ⵓⵢⴹ ⴹⵗⵙⵏ «ⵍⵙ ⵓⴰ ⵙⵙⵓⴹⵏ ⵎⴹⵔⵗⵍ ⵓⵔⴶⵗ ⴼⵔⴶ ⴹ ⴶⴹⵍ ⵢ ⵍⵤⵔⵙ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ⵍⵙ ⵗⵢⵙⴰ ⵜⵔⵎⵆ ⵜⵤⵔ ⴾⴰ ⵤⴾⴰ ⵎⵙⵏ ⴾⵤⵎ ⵜⴹⵀⵗ ⵜⵂⵏ⵿ⵜ ⵤⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ⵏⴰ ⵗⵢⵙⴰ «ⴾⵙⵜ ⵜⵂⵏ⵿ⵜ⵰» ⵜⵏⵙ ⵎⵔ⵿ⵜⴰ ⵜⵏ ⵜⵎⴹⵔⵢⵜ ⵏⵍⵙ ⵓⴰ ⵀⴰ ⴹⴰ «ⵎⵍⵢ ⵍⵙ ⴹⵢ ⵎⵔⴹⴰ ⵍⴰ ⴹⵓ ⴼⵍⵙ ⵤⵍⵏⵜ ⵓⵏ ⴾⵤ ⴹⵏⵀⵍ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔⴶⵗ ⵏⵗⵎ ⵙ ⵜⵤⴶⵤⵏⴰ ⴹ ⵜⵏⵢⵗ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ⵜⵜⵓⴾⵙⴹⵓ ⵜⵂⵏ⵿ⵜ⵰ ⵙⵓⴹ ⵗⵢⵙⴰ ⴹⵗ ⵌⵏⵓⵏ ⵏⴰ «ⵀⴰ ⴶⴹⵢⵗⴾ ⵙ ⴹⵜⵆⵀⵍⴰ ⵜⵓⵜⵔⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ⵏⴾ ⵎⵏⵏ ⵙⵏⵗ ⵙ ⴼⵓ ⴹⴰ ⵜⵆⵀⵍⴰ ⵛⵓⵜⵔⵓⵏⵏ⵰ ⴹⵍⵍ ⵏ⵿ⵜⵎⵜⵢ ⵜⴰ ⴹⵜⵗⵍⵢⵗⵍⵢⵜ ⴹⴰ ⴼⵍ ⴹⴾⵛⵓⵍⴰ ⴼⵍ ⴹ ⵜⵤⴶⵤⵏ ⵙ ⴾⵢ ⴹⴹⵤⵎⵤⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ⵙ ⴶⴰ ⵜⵓⵜⵔⵢ ⵜⴰ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵍⵤⵔⵙ ⴶⵎⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ⴶⵎⴹⵓ ⵏⵎⵜⵏ ⵓⴰ ⵏⴹ ⵜⵍⵏ ⴼⵙⵏⵜ ⴹⵔⵏⵜ ⵙ ⵜⵙⵓⴹ ⵜⵍⵙⴰ ⴹⵗ ⵜⵀⴹⵆ ⴹⵎⵏⵜ⵰ ⵏⵙⵏ ⵗⵢⵙⴰ «ⴾⵙⵜⵙ ⵜⵍ ⵜⵢⵎ⵿ⵜⵓ ⴹ ⵌⵓⵏ⵿ⴾⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⴹⵙⵏⵏ ⵎⵔⵢⵎⴰ ⵏⵢⵏ ⵔⵜ ⵓⴰ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ⵓⵢⴹ ⴹⵗⵙⵏ ⵎⵔⵏ ⴾⵏ ⴼⵔⵙⵢⵜⵏ ⵎⵍⵏⵙⵏ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ⵜⵤⵔ ⵙⵙⴶⵏ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⴼⵔⵙⵢⵜⵏ ⵎⵏⵢ ⵏⵎⵤⵔⵏ ⵏⵏ «ⵎⴰ ⵤⴰ ⵏⴶⵓ⵰ ⵍⵙ ⵓⴰ ⵜⴶⵓ ⵍⵗⵍⵎⵜⵏ ⴶⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ⵙ ⵜⵏⵢⴰ ⵜⴶⵓ ⵔⵜⵏ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵜⵤⵔ ⵙⵏ⵿ⴹⵓ ⵙⵌⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⴹⵏⵙⵜⵗⵎⵔⵏⵏ ⴹⴶⴹⴶⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵗⵔⴹⵏ ⴹⵗ ⵜⵏⵗⵢ ⵏ⵿ⵜⵎⵜⵢⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ⵏ⵿ⴾⵔⴹⵓ ⵢⵏ ⴹⵗⵙⵏ ⴶⵏ ⵙⵎ ⴾⵢⴼ ⵎⵙⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵗ ⵓⵜⵢ ⵓⵏ ⵏⵙⵏ «ⴾⵓⵏⵢ ⵓⵔ ⵜⴶⵔⵎ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ⵓⵔ ⴹⵏ⵿ⵜⴶⵔⵎ ⵙ ⴼⴰ ⴹ ⵎⵜ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⴹⵗ ⴹⴶ ⵏ⵿ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ⵀⵜⵓ ⵜⴰ ⴶⴰ ⴹⴰ ⵓⵔ ⵜⵜⴶⴰ ⴶⵔⵙ ⴹⵎⵏⵜ ⴾⵍⵔ ⵜⵛⵜⵏⵜ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵗ ⵓⵜⵢ ⵓⵏ ⴼⵍ ⴶⵔⵓ ⵍⵓⵍⵢⵜ ⵏⵙ ⵗⵢⵙⴰ ⴾⵏ⵿ⴹⵀⴰ ⵎⵜ ⴹⵗ ⴹⴶ ⵏ⵿ⵜⵎⵜⵢ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ⵎⵔⵏ ⵓⵔⴶ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ ⵗⵙ ⵙ ⵜⵤⵀⴰ ⴹⵗ ⴹⴶⵏⵜ ⴾⵍⵔ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⴾⵍ ⵓⵏ ⵓⵤⵓⵤⵏⵏ ⴶⵔ ⴾⵍⵏ ⴹⵤⵛⴹⵓ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ⵤⵍ ⵓⵏ ⴹⴰ ⴹⵗ ⴶⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵏⵜ ⵜⵏ ⵜⵏⵗⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ⵓⵏ ⴹⴰ ⴼⵍⵙ ⵀⵙ ⵜⵍⵎ ⵗⵢⵙⴰ ⴹⴹ ⵔⴰ ⴹⵗ ⴾⵍⵍⵢⵂⴹ⵰ ⴶⵎⴹ ⴾⵍ ⵓⵏ ⴾⴰ ⵗⵔⵎ ⴶⵏ ⵙⵎ ⴼⵔⵢⵎ ⵏⵎⵂⵤⵏ ⴹⵜⵏⵔⵢ ⵆⵎ ⴹⵗⵙ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ⵤⵎⵏⵏ ⵎⴹ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴾⵢ ⵂⵤⴹⵓ⵰ ⴹⴶⵎⴹⵏ ⵢⵜⴹⵏ ⴹⴶⵏ ⴶⵜⵏⵏ ⵜⴾⵏ⵿ⴹⵓ ⵢⵔⵙⵍⵎ ⴼⵍ ⴹ ⵤⵤⴹⴶⵏ ⴹⵜ ⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ⵙⴶⴹⵏ ⵢ ⵗⵢⵙⴰ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ «ⴾⵓⵏⵢ ⴾ ⵎⴰ ⵜⵏⵎ ⵜⵔⴹⵎ ⵙ ⴹⵙⵓ ⵎⴹ ⵎⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ⵏ⵿ⵜⴰ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴹⴼⵔⵙⵢⵜⵏ ⵎⵔⵏ ⵢⵜⴹⵏ ⵙⵙ ⵢ ⵙⵏⵏ ⴹⴶ ⵓⴰ ⵂⴰ ⵗⵢⵙⴰ ⵙⴼⴶⵜⵓ ⴼⵍ ⴹ ⵜⵔⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ⵙⴹⵙ ⴹⵏ ⴹⵜ ⵎⴹ ⵓⵏ ⴾⵢ ⴾⴰ ⵗⵢⵙⴰ ⵀⵜⵏⵢ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵈⵙⵔ ⵍⵤⵔⵙ ⵓⴰ ⴹⵙⴹⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ⵙ ⴹⵏⵙⴰ ⵗⵢⵙⴰ ⵜⵓⴶⵏⵙ ⵎⴶⵔⴰ ⵍⵗⵏⵏ⵰ ⴹⵜⵜⵓⵢ ⵎⵔ⵿ⵜⴰ ⵎⵏ⵿ⵙⵓⵏ ⵍⵤⵔⵙ ⵎⵔⵏ ⵂⴰ ⵢⵜⴹⵏ ⵓⵏ ⵏⵗⵎⵏⵏ ⴹⵗⵢⵙⴰ ⴹⵔⵓⵏ ⴹⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ⵜⵤⵔ ⵜⴹⴾⵍⴹⵓ ⵎⵔⵢⵎⴰ ⴶⵏⴰ ⵏⵍⵜⵔ ⵏⵍⵓⵔⴹⵢ ⴾⵏⵏ ⵛⵤⴹⴰ ⴹⵤⵓⵢ ⵙ ⵜⵓⵏⵓ ⵏⵔ ⵜⵜⵏⵆⵍ ⴼⵍ ⴹⵔⵏ ⵏ⵿ⵗⵢⵙⴰ ⵜⵎⵙ⵿ⵜⵏ ⵙ ⵌⴾⴹⵏⵜ ⴹⵏⵢ ⵂⵏ ⴹⵓ ⵏⵍⵓⵔⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ⵏ⵿ⴾⵔ ⵢⵂⵤⴰ ⵙⵈⵔⵢⵜⵢ ⵓⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⵓⵙ ⵏ⵿ⵜⴰ ⵜⵤⴶⵏ ⴹⵗ ⴼⵙⵏ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«ⵎⴼⵍ ⵓⵔ ⴹⵏⵤⵏ⵿ⵤⴰ ⵍⵓⵔⴹⵢ ⵓⴰ ⵤⵔⴼ ⵤⵓⴹⵏ ⴾⵔⴹⵜ ⵜⵎⴹ ⵏⵤⵍ ⵏⵛⵗⵍ ⵏⴾⴼⵢ ⵢ ⵜⵍⵆⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ⵔⵜ ⵓⴰ ⵓⵔ ⵜⵏⴰ ⴼⵍ ⵜⵂⵏⵏ⵿ⵜ ⵢ ⵜⵍⵆⵓⵏ ⴾⵍⵔ ⵀⵢⴹⴶ ⵎⵙ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵜⴼⵏ ⵙⵏ⵿ⴹⵆ ⵓⴰ ⵜⴶⵤ ⵤⵔⴼ ⵏⵜⵍⵀ ⴹⴾⵍ ⴹⵗ ⵓⴰ ⵜⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ⴶⵙ ⵢⴰ ⵏⴰ ⵗⵢⵙⴰ «ⵢⵜ⵰ ⵍⵓⵔⴹⵢ ⵓⴰ ⴾⵍⴰ ⴹⴰ ⵜⴶⵤⵜⵓ ⵢⵤⵍ ⵓⴹ ⵤⴰ ⵜⵓⴶⴰ ⴹⵗ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ⵛⵍⵆⵓⵏ ⴼⵓ ⴹⴰ ⵍⵏⵜ ⵗⵔⵓⵏ ⵏⴾ ⵎⵔⵏ ⵓⵔⴶⵗ ⴼⵓ ⵍ ⵗⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ⵜⵙⵍⴰ ⵜⵎⵜⵢ ⵜⴶⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙ ⵍⴰ ⵗⵢⵙⴰ ⴹⵏ ⵜⵤⵔ ⴾⵏ ⵂⵏ ⵓⵏ ⵎⵛⵏ ⵓⵔⴶ ⵗⵢⵙⴰ ⵗⵙ ⴹⵏⴾⵏ ⴾⵍⵔ ⵓⵏⴼ ⵜⵏⵂⵏ ⵏⵍⵤⵔⵙ ⵓⴰ ⴹⵙⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ⵜⵤⵔ ⴾⵙⵏ⵿ⴹⵓ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⵜⵏⵜ ⵏⴹ ⵏ⵿ⵗⵏ ⵍⵤⵔⵙ ⵏ⵿ⵜⴰ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ⴼⵍⵙ ⴹⵍⵍⵏⵜ ⴼⵍ ⴹⴼⵔⵙⵏ ⴼⵍⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ⵙ ⴼⵓ ⵙⵍⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⴾⵏⵏ ⵎⴹ ⵙ ⵗⵢⵙⴰ ⴶⵤⴹⵓ ⵗⵔⵎ ⵓⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ⴹⴾⵍⵏ⵿ⴹⵓ ⵍⴹⵍⴹ ⵏ⵿ⵜⴶⵢⵜ ⴶⵍⵏ ⵙⵍⴾⴹⵏⵙ ⴶⵏⵏ ⵙⴼⵍⴰ «ⵤⵏⴰ⵰ ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ⵰ ⴶⴰ ⵎⵛⵏⴰ ⵍⵀⵔⴾⴰ ⴹⵗ ⵓⴰ ⴹⵙⵏ ⵙⵙⵎ ⵏⵎⵍⵢ⵰ ⴾⵢ ⵎⵏⴾⵍ ⵏⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ⴶⵔⵓ ⵗⵢⵙⴰ ⵂⵍⵍ ⵓⵏ⵿ⵜⵓ ⵙⵎⴾ ⵓⴰ ⵎⵍⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«ⴹ ⵓⵔ ⵜⵛⵓⵛⴰ ⵢⴰ ⵓⵍⵜ ⵙⵢⵏ ⵎⵏⴾⵍⵏⵎ ⴹⵢ ⴹⵏⵤⵢⵏ ⴹⵢ ⵓⵏ ⵂⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ⵔⵜ ⵓⴰ ⵓⵔ ⵜⴶⵔⵏ ⵏⵜⵍⵀⵏⵜ ⴹⵗ ⵜⵤⵔⵜ ⵎⵛⵏ ⵙ ⴶⵔⵓ ⵗⵢⵙⴰ ⴹⴾⵍⵏⵜ ⴾⵜⵏ⵿ⴹⵓ ⵙ ⵔⵜⵏ ⵓⵏ ⵎⵍⵏ⵿ⵜⵏ ⵍⴾⵜⵀⵏ ⵎⵔⵏ ⴾⵍ ⵏ⵿ⴹⵏ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ⵜⵎⵜⵢ ⵜⴰ ⵜⵎⴶⵏⵜ ⵙⵗⴰ ⵓⴰ ⴹⵗ ⴹⵗⵔⴰ ⵗⵢⵙⴰ ⵍⵤⵔⵙ ⴹⵗ ⵤⴾⴰ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⴶⵢⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ⵓⵏ ⴹⴰ ⴼⵍ ⴹⵙⴹⵜⵙⵍⴾⴹ ⵜⵎⵜⵢ ⴼⵍⵙ ⵙⵍⵏ ⵍⵗⵍⵎⵜ ⵜⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ⵜⵤⵔ ⴹ ⵜⵏⵎⵏⵏ ⴼⵔⵙⵢⵜⵏ ⴶⵔⵙⵏ «ⵜⴶⵎ⵿ⵜⵓ⵰ ⵏ⵿ⴹⵔⵓⵏ ⴹⵔ ⵜⵏ⵿ⵜⴾⵎ ⵂⵔ ⵙ ⵢⵜⴹⵏ ⴾⵍ ⵍⴾⵎⵏⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ⵍⵏ⵿ⵜⵓ ⵔⵜ ⵏ⵿ⴾⵍⵍⵢⵏⵏ ⵂⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⴾⵏⵏ ⵢⵔⵙⵍⵎ ⵢⴹⵗⵙ ⵗⵀⴹⵏ ⵎⵛⵏⴰ ⴹⵗ ⴹⵏⵏ ⴹⴰ ⵏⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ⴾⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏ ⴼⵍⵀⵙ ⵓⵏ ⵜⵗⵔⵎ⵿ⵜ ⵏⵀⵜⵙⵢⴹⴰ ⵜⵏ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⵏⵏⵙ «ⵏⴶⵎⵢ ⴹⵗⴾ ⴹⵏⵜⵙⴾⵏⴰ ⵗⵢⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ⴶⵍⴰ ⴼⵍⵀⵙ ⵎⵍ ⵢⵏ⵿ⴹⵔⵓⵙ ⴹⵓ ⴹⵔⵙ ⵏ⵿ⴹⵔⵓⵙ ⵎⵍⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵍⵓⵆ ⵓⴹⵓ ⵎⵔⴹⴰ ⵓⴰ ⴹⵗ ⵤⴶⵔⵓⴰ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⴾⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⵀⵍⵍ⵿ⵜ ⵏⵍⴾⵎⴰ ⵙ ⵓⵔ ⵜⵔ⵿ⵜⴾ ⴹⵗ ⵎⴹⵍ ⵜⵎⵜ ⴹ ⵜⴶⵍⵓ ⵜⵎⵙ ⵢⴹⴰ ⵎⵛⵏ ⵙ ⵜⵎⵜ ⴹⵜⴹⵓⵍ ⵜⴶⵓ ⵔⴰ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ⵓⴹⵏ ⵓⴰ ⵔⵏ ⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴹ ⴼⵜⵓ ⴹⵗ ⵍⵈⵔⵜ⵰ ⵎⵔⵏ ⵓⴰ ⵔⴹⵏ ⴹ ⵙⴼⵜⵓ ⵎⵏⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵓⴹⵢ ⵓⵔ ⵜⵤⴶⵎⴹⵏ ⴾⵍⵔ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵔⵏ ⴹⵛⵗⵍ ⵍⴾⵎⵜⵢ ⵙ ⴶⴰ ⴹⵢ ⴹⴶ ⵓⴰ ⵂⵗ ⵏ⵿ⵜⴰ ⵤⴶⵤ ⴾⴼⵢ ⴹⵗ ⵀⵏⵏ ⵍⵎⵆⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ⵎⵔⴹⴰ ⵗⵛⴹⵏ ⵎⵏⵏ⵰ ⵎⴰ ⵤⵏⴰ⵰ ⵓⴾ ⴹ ⵏⴰ \"ⵀⴰ ⵙⴼⵙⵢ ⴹⵗ ⵙⵗⵜ ⵜⴰ⵰ ⵎⵛⵏ ⵓⵔ ⴹⵓⴹⵗ ⵍⵓⵆ ⵓⴰ ⵔ ⵢⴼⵍⵢ ⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ⵀⴰ ⵙⵏⴼⵍⵍ ⵜⵍⵏⴾ ⵜⵏⵢⴰ⵰\"» ⵜⵤⵔ ⴶⵎⴹⵓ ⵎⵙⵍⵢ ⵌⵏⵓⵏ ⵏⴰ «ⵜⵍⵏⵏ ⵜⵏⵢⴰ ⵙⵏⴼⵍⵍⵆⵜ ⵎⵔⵏ ⵜⵜⵍⵙⵗ ⵙⵏⴼⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ⵜⵎⵜⵢ ⵜⴰ ⵜⵍⵜ ⴹⵏ ⵜⵙⵍⴰ ⵢⵎⵙⵍⵢ ⵓⴰ ⵜⵗⵍ ⴶⴶ⵰ ⴹ ⴶⵏⵏ ⵓⵢⴹ «ⵏ⵿ⴶⵍⵙ ⴹⵙⵛⵓⵍⵏ ⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵎⵙⵍⵢ ⵓⴰ ⵓⵔⴶⵗ ⴹⵍⵍⵏ ⴼⵍ ⴹⴶⴰ ⴾⵍⵔ ⴹⵍⵍⵏⵓⵏ ⴾⵓⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ⵎⵔⴹⴰ ⴹ ⵤⴰ ⵜⵜⵓⵈⴾⵎ ⴹⵏⵜ ⵜⴰ ⵜⵓⵙ⵿ⵜⵗ ⵎⵏⴾⵍⵏⵜ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ⵎⵔⵏ ⵏⴾ ⵙ ⵜⵓⵙⵂⴾ ⴼⵍ ⵎⴹⵍ ⵓⵔⴰ ⵜⴶⵜⵓⵜ ⴹⵗⵔⵗ ⵢⵜⴹⵏ ⴾⵍ ⵙ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ⵀⵜⵓ ⵜⴰ ⵙⴹⴶⵏ ⵙⵔⵙ ⵜⵎⵓⵜ ⵜⵙ ⵜⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ⵜⵏⵙ ⵜⵎⵜⵢ «ⵏⵏⵢ ⴹⵗ ⵓⵍ ⵏⵎⵛⵏⴰ ⵙ ⵍⵎⵙⵈ ⴹ ⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⵗⵍⵍⵜ⵰ ⵎⵏⵎⴾ ⵎⵔⵏ ⵙ ⴹⵏⵤⵜⵏⵗ ⴶ ⴶⴹⵎ ⴹ ⵜⵓⵙⵂⴾⵜ ⴼⵍ ⵎⴹⵍ⵰ ⵎⴰ ⵎⵙ ⴶ ⴶⴹⵎ ⵓⵙ ⵜⴶⵏⵗ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ⵜⵤⵔ ⵏⵙⵏ ⵗⵢⵙⴰ «ⵏⵔ ⵂⵔⵓⴰ ⴹⴰ ⵍⴰ ⵗⵔⵓⵏ ⵂⵔ ⴶⵏ ⵔⵜ ⵏⵤⵎⵏ⵰ ⵌⵓⵏ⵿ⴾⵜⵜ ⴾⵜ ⴹⵢ ⴹ ⵜⵍⴰ ⴼⵍ ⴾⵓⵏⵓⵔⵗⴹⵔⵏⵜ ⵛⵢⵢ ⴼⵍⵙ ⵓⴰ ⵌⵓⵏ⵿ⴾⵏ ⴹⵗ ⵛⵢⵢ ⴹⵢ ⵓⵔ ⵙⵏ ⵙⵙ ⴹⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ⵤⴶⵤⵏⵜ ⵙⵏⵔ ⵂⵔⵓⴰ ⵜⴶⵤⵎ ⴼⵍ ⴹ ⵜⵆⵍⵎ ⴾⵍ ⵏⵔ⵰» ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⴶⵢ ⵏⵀⵜⵓ ⵜⴰ ⴶⴾⵏ ⴾⴰ ⴹⴶ ⵓⵔ ⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ⵍⵗⵍⵎⵜⵏ ⴶⵜⵏⵏ ⵛⵏ ⴶⴰ ⵗⵢⵙⴰ ⴹⵜⵙⵏ ⵓⵔ ⵙⵔⵙⵏ ⴹⵓⵢⵏⵜ ⵙ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ⴼⵍ ⴹ ⵜⵏ⵿ⴹⵓ ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ «ⵎⵍⵢ ⵎⴰ ⵎⵙ ⵓⴰ ⵤⴶⵤⵏⵏ ⵙⵔⵜ ⵓⴰ ⵏⵎⵍ⵰ ⵎⴰ ⵎⵙ ⵓⵙ ⵜⵏⴼⵍⵍ ⵜⵔⵏⴰ ⵏⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵓⵔ ⴼⵔⴶⵏ ⴹ ⵤⴶⵤⵏⵏ ⴹⴰ ⵎⵍ⵿ⵜⵓ ⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«ⵎⵛⵏⴰ ⵜⵏⵙⴹⵔⵗⵍⵏ ⵙⵗⵔ ⵓⵍⵏⵙⵏ ⴼⵍ ⴹ ⵀⵙ ⵂⵏⵢⵏⵜ ⵛⵜⵓⵏⵙⵏ ⵀⵙ ⴶⵔⵏ ⵓⵍⵏⵙⵏ ⴼⵍ ⴹ ⵓⵔ ⵜⵀⵏ ⵤⵤⵢⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ⵔⵜⵏ ⵓⵏ ⵏⵏ ⵙⵢⵙ ⴼⵍⵙ ⵏⵢ ⵜⵏⵢⴰ ⵏ⵿ⵗⵢⵙⴰ ⵎⴶⵔⴹ ⴹⵗ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ⵙ ⴶⴰ ⵓⵏ ⵎⵤⵔⵏ ⵎⵏⵙⵏ ⴹⴰ ⴹⵗⵙⵏ ⴶⵏ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ ⵎⵛⵏ ⵓⵔ ⵂⵍⵏ ⵎⵍ ⵏⵓⵏ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏ⵿ⴼⵔⵙⵢⵜⵏ ⴼⵍⵙ ⵓⵔ ⵔⵏ ⴹ ⵜⵓⴾⵙⵏ ⴹⵗ ⵍⵌⵎⵗⵜ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ⵎⵔⵏ ⵙⴼⵏ ⵙⵗⵎⵔ ⵓⵏ ⵢⵜⴹⵏ ⵜⵏⵢⴰ ⵜⴰ ⵂⴾⵓ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ⴹⴾⵍ ⵗⵢⵙⴰ ⵎⵙⵍⵏⵜ ⵏⴰ «ⵓⴹⵏ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵓⵔⴶ ⵏⴾ ⵗⵙ ⵙ ⵤⴶⵤⵏ ⴾⵍⵔ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴹⴰ ⵤⴶⵤⵏ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ⵎⵔⵏ ⵓⴰ ⴹⵗⵢ ⵙⵓⴹⵏ ⴹⵢ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴹⵗ ⵙⵓⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ⵏⴾ ⵤⵏ ⵏⵔ ⵎⵙⴰ ⴾⴹⵓ ⴹⵏⵜ ⵢⵙ ⵢ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⵓⵔ ⵤⵆⵎ ⴹⵗ ⵛⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ⵙ ⵙⵍⴰ ⵓⴹⵏ ⵢ ⵀⵜⵜⵏⵏ ⵆⵎ ⵓⵔ ⵜⵏⵜⵜⴼ ⵓⵔⴶ ⵏⴾ ⵜⵤⵓⴹⵀⵏ ⴼⵍⵙ ⵏⴾ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⴹⴾ ⵙⴹⵏⵜ ⵓⵔⴶⵗ ⵜⴹⵀⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ⴹⵗ ⴹⵢ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵍⴾⵏ ⵆⵎ ⵓⵔ ⴶⴰ ⵜⵏⵀⵢ ⴹⵗ ⵀⵜⵜⵏⵏ ⵓⴹⵢ ⵍⵢ ⵓⴰ ⵜⵤⵓⴹⵀⵏ⵰ ⵓⵍ ⵎⵏⵜ ⵓⴰ ⴹⴰ ⴶ ⴹⴰ ⴹⵙⵤⵛⵔⵗⵏ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ⴼⵍⵙ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵓⵔⴶⵗ ⵏⴾ ⵜⵏ⵿ⴹⵏ⵿ⵤⵎⵏ ⴶⵔⵢ ⴹⵎⵏⵏ ⴾⵍⵔ ⵀⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵎⵏⵜ ⵙ ⴹⵎⵔ ⵙⵔⵜ ⵓⵙ ⴹⵓⵔ ⴹ ⵜⵏⴰ ⴹⵓⵙ ⴹⵓⵔ ⴼⵍⵙ ⵎⴶⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ⵙⵏⵗ ⵙ ⵔⵜ ⵓⵙ ⵎⵔ ⵏ⵿ⵜⴰ ⵜⵓⵢⵏ ⵙ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⴹⵗ ⴹⵢ ⵔⵜ ⵓⵙ ⵎⴶⵔⴹⴰ ⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴹⵜⵎⵍ ⵀⴰ ⵏ⵿ⵜⴰ ⵙ ⵙⵔⵙ ⵎⴶⵔⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ⵂⴹ ⵓⴰ ⴶⵏ ⵎⴹ ⵓⵏ ⴾⵢ ⵙⵏ ⵗⵢⵙⴰ ⵙ ⵍⵓⵆⵏⵜ ⵙⴹⵓ ⵓⴰ ⴹⵗ ⵤⴶⵎⴹ ⴹⵏⵜ ⵆⵍ ⵀⴰ⵰ ⵗⵢⵙⴰ ⴼⵓ ⴹⴰ ⵙⴾⵏⵓ ⵏⵜⵍⵀⵏⵜ ⵜⵔⴰ ⵎⵔⵏ ⵎⵔⴹⴰ ⵙⵏⵂⵍ⵿ⵜⵏ ⵙⴾⵏⵢ ⵏ⵿ⵜⵔⴰ ⵜⴰ ⴹⵙⵏⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ⵜⵎⵏ⵿ⵙⵓ ⵗⵢⵙⴰ ⴹⵏⵜⵍⵀⵏⵜ ⵂⴹ ⵙ ⵜⴶⵓ ⵓⵏ ⴹⴰ ⵀⵍⵙ ⴶⴰ ⴹⵗ ⵓⵍ ⵏⵢⵂⵤⴰ ⵓⵏ ⴶ ⵙⵎⵗⵏ ⵙⵈⵔⵢⵜⵢ ⵜⴾⴹⵍ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ⵙⵏ ⵗⵢⵙⴰ ⵙ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⴶⴰ ⵔⵜ ⴾⵍ ⴹⵗ ⴼⵙⵏⵜ ⵙⵏ ⴹⵗ ⵙ ⴶⵎⴹⵓ ⵎⵛⵏⴰ ⵎⵔⵏ ⴹ ⵜⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ⵀⴹⴹ ⴼⵍ ⵎⵏ⵿ⵙⵓⵏ ⴾⵙ ⵜⴾⴹⴾⵜⵏⵜ ⵜⵏ ⴼⵍⴰ ⴹⴾⵍ ⴼⵔ ⴶⵀⵙ⵿ⵜⵓ ");
INSERT INTO ttqt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ⵜⵤⵔ ⴶⴰ ⵎⵏ ⴹⵗ ⵗⵍⵍ ⴹ ⵛⵔⴹ ⴹⵔⵏ ⵏⵜⵍⵀⵏⵜ ⵎⵙ⵿ⵜⵏ ⵙⴼⵔ ⵓⴰ ⴶⵀⵙ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ⵙ ⴹⵓⴹ ⵗⵢⵙⴰ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵏⵙ «ⵎⵍⵢ ⴾⵢ ⵤⵛⵔⴹⵏ ⴹⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ⵏⵙ ⵗⵢⵙⴰ «ⵓⴰ ⵜⴶⴰ ⴹⴰ ⵓⵔ ⵜⴼⵔⴶⴰ ⴶⵔⵏⵜ ⵎⵔⴹⴰ ⵎⵛⵏ ⵜⵜⴶⵔⴰ ⴹⴼⵔ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ⵏⵙ ⵀⵜⵔⵙ «ⴾⵢ ⴹ ⵜⵛⵔⴹⴰ ⴹⵔⵏⵏ⵰ ⵓⵍⴰ ⵏⵎⵂⵤ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⵙ ⴹⴾⵏⵓⵔⵛⵔⴹⴰ ⵏⴾ ⴹⵔⴾ ⵏⵎⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⴹⵗ ⴹⵢ ⵎⵍⵢ ⵓⵔⴶ ⴹⵔⵏⵏ ⵗⵙ ⵛⵔⴹ ⵂⵔⴾⴹ ⴼⵙⵏⵏ ⴹⵗⴼⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ⵏⵙ ⵗⵢⵙⴰ «ⵓⴹⵏ ⵛⵔⴹⵏ ⵓⵔ ⴹⵔⵔ ⵔ ⵛⵔⴹ ⵏ⵿ⴹⵔⵏ ⴼⵍ ⴹ ⵤⴹⴶ ⴾⵜⵏⵜ ⵎⵔⵏ ⴾⵓⵏⵢ ⵜⵤⴹⴶⵎ ⵎⵛⵏ ⵓⵔⴶ ⴾⵜⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ⵗⵢⵙⴰ ⵙⵏ ⵓⴰ ⵜⵤⴾⴹⵍⵏ⵰ ⴹⵢ ⴼⵍ ⵏⴰ «ⵓⵔ ⵜⵤⴹⴶⵎ ⴾⵜⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ⵙ ⵗⵔⴹ ⵗⵢⵙⴰ ⵛⵔⴹ ⵏ⵿ⴹⵔⵏⵙⵏ ⵤⵍⴶ ⵜⴾⴹⴾⵜⵏⵜ ⵆⵍ ⴹⴶⵏⵜ ⵏⵙⵏ «ⵓⴾ ⵜⴶⵔⵎ ⵓⴰ ⴹⵓⵏⴶ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ⵜⴶⵏⵎⵢ \"ⵎⵙⵙⵗⵔ\" ⴹ \"ⵎⵍ\" ⵜⴶⵏⵎ ⵍⵗⵏ ⴼⵍⵙ ⵎⵙⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⵏⴾ ⵎⵙⵏ ⵎⵍⵢ ⴹⵎⵙⵙⵗⵔⵢ ⵛⵔⴹⴰ ⴹⵔⵏⵓⵏ ⵓⵔⴾⵓⵏ ⴾⵓⵏⵢ ⴹⴰ ⴹⵗ ⵍⴾⵎ ⴰ ⴹ ⵜⵜⵎⵛⵔⴹⵎ ⴹⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ⵙⴾⵏⵆⵓⵏ ⵔⵜ ⵓⴰ ⴼⵍ ⵜⵜⵜⴶⵎ ⴾⵓⵏⵢ ⴹⴰ ⵙⵎⴾ ⵓⵙ ⴹⵓⵏ⵿ⵜⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴾⵍⵢ ⵓⵔ ⴶⵔ ⵎⵛⵙ ⵏⵎⵤⵍ ⴹⵗ ⵓⵔ ⴶⵔ ⵓⴰ ⵜⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ⴹⴹ ⵤⵎⵙ ⵜⵙⵏⵎ ⵔⵜⵏ ⵓⵏ ⵓⴹⵢ ⵜⵀⵍⵍⵎ ⴾⴹⵙ ⵜⵜⵎⵤⵍⵎ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ⵓⵔ ⴹⵓⵏ⵿ⴶⵏⴰ ⴾⵜⵏⵓⵏ⵰ ⵓⵏ ⵙⵏⴼⵔⵏⴰ ⴾⵍ ⵤⴹⵢⵆⵏ ⵎⵔⵏ ⴾⵏ⵿ⴹⵀⴰ ⵏ⵿ⴹⴰ ⵓⴰ ⵎⵍ ⵓⵍ ⵏⵎⵛⵏⴰ ⵙ ⵏⴰ \"ⵓⴰ ⴹⵔ ⴹⵔⵓⴰ ⵆⵍ ⵎⴾⵙⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ⵔⵜ ⵓⴰ ⵙ ⴶⴰ ⴹ ⵜⵤⴶⵤⵏⵎ ⵙ ⵏⴾ ⵎⵙⵏ \"ⵓⴰ ⵍⵏ ⴹⴰ⵰\" ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵓⵏ⵿ⵜⵏⵗ ⵎⵔⴹⴰ ⵂⵔⵓⴰ ⵓⵔ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴰ ⵆⵀⵍⵏ ⵢⵏ ⴹⵗ ⵏⵎⵤⵍⵏ ⵏⴾ ⵎⵏⵏ ⵆⵀⵍ⵰ ⵂⵔⵓⴰ ⵓⴰ ⴹⵆⵀⵍⵏ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵆⵀⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵓⵏ ⵗⵛⴹⵏ ⵎⵏⵜ ⵜⵤⵔ ⵏⴰ «ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵢⵏ ⴹⵗⵓⵏ ⴹⵤⴶⵏ ⴹⵗ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ⴹ ⵜⵏⵎⵙⵓⴹⵏ ⵏⵜⵍⵀⵏⵜ ⵆⵏⵏ ⵗⴼⵓⵏⵙⵏ ⵢ ⵓⵙ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ⵢⵏ ⴹⵗ ⵏⵜⵍⵀⵏⵜ ⵓⴰ ⵙⵏⵂⵍ ⵗⵢⵙⴰ ⵜⵔⴰ ⵙⵗⵎⵔ ⴹⵗ ⵂⵤ ⵏⴹⵎⵔⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ⵙⴹⴶⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⴹ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⴹⵓⵙ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ⵜⵤⵔ ⵏⵤⵏ ⵏⵜⵍⵀ ⵓⵏ ⴼⵍ ⴹⵎⵔⵏ ⵏ⵿ⵗⵢⵙⴰ ⵏⵙ «ⵎⵍⵢ ⵎⴰ ⵤⵆⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⵓⴰ ⴾⴼ ⴾⵔⵎⵓ ⵏ⵿ⵜⴶⵍⴰ ⵓⴰ ⵤⵙⵍⵎⵗⴰ ⴹⵗ ⴹⵔⵤ ⴰ⵰» ⵜⵤⵔ ⵙⵍⵎⵗ ⴾⵔⵎⵓ ⵏ⵿ⵜⴶⵍⴰ ⴾⴼⵢ ⵢ ⵢⵂⵤⴰ ⴶ ⵙⵎⵗⵏ ⵙⵈⵔⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ⵙ ⴶⵔⵓ ⵢⵂⵤⴰ ⴾⵔⵎⵓ ⵓⵏ ⴶⵤⵜⵓ ⵛⵢⵜⵏ⵰ ⵜⵤⵔ ⵏⵙ ⵗⵢⵙⴰ «ⵜⴶⵗⵜ ⵜⵔⵎⴹ ⵓⴰ ⴾⵢⵓⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ⵓⴰ ⴼⵍ ⵏⴰ ⵗⵢⵙⴰ ⵓⵏ ⵢ ⵢⵂⵤⴰ ⵓⵔ ⵂⴰ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵂⴹⵜⵏⵏ ⵙⵗⵎⵔⵏⵏ ⴹⵏ ⵜⵜⵏ ⵢ ⵜⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ⵓⵢⴹ ⵔⴹⵏ ⵙ ⴹⴼ ⵓⴰ ⴶⴰ ⵢⵂⵤⴰ ⵤⵔⴼ ⵏⵜⵍⵀ ⴼⵍ ⴹⵙⵏⴰ ⵗⵢⵙⴰ «ⵤⵏ⵿ⵤⴹⵓ ⵔⵜ ⵓⵙ ⵤⴰ ⵏⴹⵔⵔ ⵢⵎⴹ⵰ ⵎⴹⵗ ⴾⴼⵓ ⵛⵍⵆⵓⵏ ⵔⵜ ⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ⵀⵤ ⵢⵂⵤⴰ ⴾⵔⵎⵓ ⵏ⵿ⵜⴶⵍⴰ ⴶⵎⴹ ⵜⵔⵎⴹ ⵙ ⵜⴶⵓ ⵓⵏ ⴹⴰ ⵂⴹ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ⵙ ⴶⵎⴹ ⵢⵂⵤⴰ ⵏⴰ ⵗⵢⵙⴰ «ⵎⵔⴹⴰ ⵜⵏⵢⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⵜⵏⴼⵍⵍ ⵜⵏⴼⵍⵍ ⴹⵗⵢ ⴹⵗ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ⴹⴹ ⵤⵎⵙ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵜⵏⴼⵍⵍ ⴹⵗⵢ ⵎⵛⵏⴰ ⴹⴰ ⴹ ⵙⵏⴼⵍⵍ ⴹⵗ ⵎⵏⵜ ⵜⵏⵢⵏⵏ ⵏⴾ ⴶ ⴶⴹⵎ ⴹⵗ ⵍⵓⵆ ⵂⵤⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ⵎⵔⵏⵏ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ ⵗⵔⵓⵏ ⵤⴶⴰ⵰ ⴹⵜⴶⵎⵢⵎ ⵎⵛⵏ ⴹⴶ ⵓⴰ ⴾⵗ ⵓⵔ ⵜⴼⵔⴶⵎ ⵜⵏ⵿ⵜⵓⴹⵎ⵰ ⴾⵍⴰ ⴹ ⵏⵗ ⴹⵢ ⵢ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⴾⵓⵏⵢ ⴹⴰ ⵎⵔⴹⴰ ⵏⵗⵓⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ⴾⵓⵏⴾⴼⵗ ⵍⵓⵌⵀ ⵢⵏⵢⵏ ⵜⵎⵙⵏ ⵙ ⵏⵎⵔⵓⵜ⵰ ⵏⵎⵔⵓⵜ ⴾⵓⵏⵢ ⴹⴰ ⵙⵎⴾ ⵓⵙ ⴾⵓⵏⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ⵙ ⵜⵏⵎⵔⵎ ⴹ ⵙⵙⵏ ⴹⵢ ⵢⵜⴹⵏ ⴾⵍ ⵙ ⴾⵓⵏⵢ ⵏⵜⵍⵀⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵎⵍⵢ ⵎⵏⴹ ⵜⴾ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴹⴶ ⵓⴰ ⴾ ⵓⵔ ⵜⴼⵔⴶⴰ ⴹⵙⵔⵙ⵿ⵜⵍⴾⵎⴰ ⵎⵔⴹⴰ ⴶⵙ ⴹⵏ⵿ⵜⵍⴾⵎⴰ ⴹⴼⵔ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ⵏⵙ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵎⵍⵢ ⵎⴼⵍ ⵙ ⵓⵔ ⴼⵔⴶⴰ ⴹⴾ ⵙⵔⵙ ⵍⴾⵎⴰ ⵎⵔⴹⴰ⵰ ⴶⵔⵗ ⵔⵢ ⵢⴼⵍⴾ ⴾⴼⴰ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ⵏⵙ ⵗⵢⵙⴰ «ⴹⵙ ⴼⵍⵢ ⵜⴾⴼⵗ ⵎⵏⴾ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵓⵔ ⵤⵗⵔⵓ ⴾⵌⵢ ⵗⵔⴰ ⵓⵔ ⴹⵜⴶⴹⴰ ⵂⵔ ⴾⵔⴹⵜ ⵜⴾⵍⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹ ⵓⵔ ⵜⵛⵓⵛⵎ ⵤⴶⵤⵏⵜ ⵙ ⵎⵛⵏⴰ ⵜⵤⴶⵤⵏⵎ ⵙⵔⵢ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ⵂⵏ ⵏⵀⵏⵏ ⵂⵏ⵿ⵜⵓ ⴹⴶⵏ ⴶⵜⵏⵏ ⵏ⵿ⵜⵎⵈⵙⵔ⵿ⵜ⵰ ⵓⴾ ⵏⵔ ⵓⵔ ⴶⴰ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⴹⵓⵏ⵿ⵤⵏⴰ ⴹ ⴶⵍⴰ ⵙⵎⵜⴶⵗⵓⵏ ⴹⴶ ⵜⵤⴹⵗⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ⵙ ⵜⵙⵎⵜⴶⴰ ⴹ ⴹⵆⵍⴰ ⴹⵓⵗⵏ ⴹⵔⵓⵏ ⴼⵍ ⴹ ⵜⴶⵤⵎ ⴹⴶ ⵓⴰ ⵂ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ⴹⴶ ⵓⴰ ⴾ ⵜⵙⵏⵎ ⵜⵔⵢⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ⵏⵙ ⵜⵎⴰ «ⵎⵍⵢ ⵓⵔ ⵏⵙⵏ ⴹⴹ ⵜⴾ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵏⵙⵏ ⵜⵔⵢⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ⵏⵙ ⵗⵢⵙⴰ «ⵏⴾ ⵎⵙⵏ ⵜⵔⵢⵜ ⴹ ⵎⵙⴰ ⵜⴹⵜ ⵎⵙⴰ ⵏ⵿ⵜⴹⴰ ⵓⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ⵓⴹⵏ ⵓⵍⵢⵏ ⵓⵔ ⵏ⵿ⵤⵓⴹ ⵀⴰ ⵔ ⵙ ⵜⵔⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ⵏⵔ ⵜⵙⵏⵎ ⵓⴰ ⵎⵙⴰ ⵜⵙⵏⵎ ⵓⴰ ⵎⵙ ⵀⵏⵏ ⴹⴰ⵰ ⵎⵔⴹⴰ ⵜⵙⵏⵎ ⵓⴰ ⵎⵙ ⵎⵔⵏ ⵜⵏⵢⵎ⵿ⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ⵏⵙ ⴼⵍⵀⵙ «ⵎⵍⵢ ⵙⵙⵏⵏⵗ ⵓⴰ ⵎⵙ ⵀⴰ ⴶⴹⵏⴰ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ⵏⵙ ⵗⵢⵙⴰ «ⴼⵍⵀⵙ ⵔⵓⵗ ⵙ ⴹⵔⵓⵏ ⴹⵓⴰ ⴶⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⵙⵏⵗ ⵓⴰ ⵎⵙⴰ⵰ ⵓⵔ ⵜⵙⵏⵗ ⵙ ⵓⴰ ⴹⵏⵢⵏ ⵏⵢ ⵀⴰ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵜⴶⵏⴰ \"ⵙⵙⵏⵏⵗ ⵓⴰ ⵎⵙ ⵀⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ⵓⵔ ⵜⵤⴶⵤⵏⵗ ⵙ ⵏⴾ ⴹⵀⴰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵏⵎⵙ⵰ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵓⵔⴶⵗ ⵏⴾ ⵜⵏ⵿ⴹⵏ⵿ⵤⵎⵏ ⴶⵔⵢ ⴹⵎⵏⵏ ⴾⵍⵔ ⵀⴰ ⴹⵔ ⵎⵙⵗ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙⵏ⵿ⴹⵏ ⴶⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ⵤⴶⵤⵏⵜⵢ ⵏⴾ ⴹⵀⴰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵏⵎⵙ⵰ ⴾⴹ ⵤⴶⵤⵏ ⵓⵔ ⵜⴶⵎ ⵙⵓⴰ ⵏ ⵤⴶⵤⵏⵜ ⴼⵍ ⴹⵍⵍ ⵏⵎⵤⵍⵏ ⵓⵏ ⵙ ⴹⵜⵏⵢⵎ ⵜⴶⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵓⴰ ⵙⵔⵢ ⵤⴶⵤⵏⵏ ⴹ ⴶⵓ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⴰ⵰ ⴼⴹⴰ ⴹ ⴶⵓ ⵓⵏ ⵜⵏⴶⵔⵏⵏ ⴼⵍⵙ ⵏⴾ ⵀⴰ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ⵎⵔⵏ ⵆⵍ ⵔⵜ ⵓⴰ ⵜⴶⵎⵢⵎ ⵙⵙⵎⵏ ⴹ ⵜⴶⴰ ⴼⵍ ⴹ ⵜⵜⵓⵏⵢ ⵜⵏⵢⴰ ⵏⵀⴰ ⴹⵗ ⵀⵔⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ⵙ ⴹⵗⵢ ⵜⴶⵎⵢⵎ ⵔⵜ ⵆⵍ ⵙⵙⵎⵏ ⴹ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ⴾⴹ ⵜⵔⴰ ⴹⵜⴶⵎ ⵜⵜⴼⵎ ⵍⵓⵌⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ⵎⵔⵏ ⴹ ⴶⵎⵢⴰ ⴹⵗ ⵀⴰ ⴾⵓⵏⴾⴼⵓ ⵎⴹⵂⵍ ⵢⵏ ⵗⵔⵓⵏ ⵤⵎⵍⵏ ⵂⵔ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵙⵏⴼⵍⵍⵏ ⵜⴹⵜ ⵙ ⵓⵔ ⵜⴼⵔⴶ ⴹⵏⵜ ⵍⵆⵀⵍⵜⵏⵜ ⴼⵍⵙ ⵓⵔ ⵜⵜⵂⵏⵢ ⵓⵍⴰ ⴹⴰ ⵜⵤⴹⵢⵜⵓ⵰ ⴶⵙ ⴾⵓⵏⵢ ⵜⵤⴹⵢⵎ⵿ⵜⵓ ⴼⵍⵙ ⵂⵤⴾⵓⵏ ⵎⵔⵏ ⴹ ⴶⵤ ⵓⵍⵏⵓⵏ ⵂⵔ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ⵓⵔ ⴾⵓⵏ⵿ⵤⵢⴰ ⴹⵗ ⴹⵏⵜ ⵜⵎⵙⵎ ⵛⵍⵜ ⵏ⵿ⴶⴶⵍⵏ ⴾⵓⵏ⵿ⴹⵆⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ⴹⴼⵔ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ ⴹⵏⵜ ⵓⵔ ⴹⵤⵜⵍⵙ ⵏⵢ⵰ ⴶⵙ ⴾⵓⵏⵢ ⴹⵜⵍⵙⵎ ⵏⵢ ⴼⵍⵙ ⴹⵔⴰ ⴾⵓⵏⵢ ⴹⴰ ⴹ ⵜⴹⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ⵍⵓⵆ ⵓⴹⵢ ⴹ ⵜⵙⵏⵎ ⵙ ⵏⴾ ⴹⵀⵏⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵏⵎⵙ ⵜⵙⵏⵎ ⴹⵗ ⵙ ⵜⵂⵎ ⵓⵍⵏ ⵏⴾ ⴹⴰ ⵂⵗ ⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ⵓⴰ ⵜⴼⵏ ⵍⵓⵌⵀⵏⵏ ⵏ⵿ⵜⴰ ⴹⵔⵏ⵰ ⵓⴰ ⴹⵔⵏ ⴹ ⵜⵔⵓ ⵀⵏⵏ ⵔⵆⵓ ⵏⴾ ⴹⴰ ⵙⵏⴼⵍⵍⵗⵙ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ⵏⵙ ⵢⵂⵤⴰ ⵓⴰ ⵓⵔ ⵏⵎⵙ ⴶ ⵙⵈⵔⵢⵜⵢ «ⵎⵍⵢ ⵎⵏⵎⴾ ⵙ ⴹⵏⵤⵜⵙⵏⴼⵍⵍⵗ ⵎⵏⴾ ⵏⴾⵏⵢ ⵗⵙ ⵓⵔ ⵜⵏ⵿ⵜⵙⵙⵏⴰ ⵢⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ⵏⵙ ⵗⵢⵙⴰ «ⵓⴹⵏ ⵓⴰ ⴹⵔⵏ ⴹ ⵜⴼ ⵓⴰ ⵏ ⵔⵢ ⵀⵏⵏ ⵏⵙⵢⴹⵓ ⵏⵎⵍ ⵗⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ⵓⴰ ⴹⵓⵔⵏⵔⴰ ⵓⴹⵢ ⵓⵔ ⵜⴼ ⵀⵜⵜⵏⵏ⵰ ⵎⵔⵏ ⵀⵜⵓ ⵜⵙ ⵜⵙⵍⵎ ⴹⴰ ⵓⵔⴶ ⵏⴾ ⵜⵜⴶⵏ ⴾⵍⴰ ⵔ ⵛⵏ ⵀⴰ ⵙⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ⴶⵗⵓⵏ⵿ⵜⵜ ⵂⵔⵓⴰ ⴾⵓⵏⵂ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ⵎⵔⵏ ⵎⴹⵂⵍ ⵎⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴰ ⴹⵓⵏ⵿ⴹⵤⵙⴶⵍⵓ ⵀⴰ ⵙⵙⵎⵏ ⴾⵓⵏⵙⵙⵗⵔⵓ ⵔⵜⵏ ⴾⵍ ⵙⴾⵜⵓⵏ⵿ⴹⵓ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵓⵏⵏ ⵏⴾ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ⵢⵗⵓⵏ⵿ⴹⵓ ⵍⵈⵔ ⴾⴼⵆⵓⵏ ⵍⵈⵔ ⵓⵏⵏ⵰ ⵏⴾ ⵓⵔ ⴹⵓⵏ⵿ⵜⴾⴼⵗ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⵜⵜⵂⴾⵓ ⴹⵏⵜ⵰ ⴹ ⵓⵔ ⵜⵛⵓⵛⵎ ⵓⵍⴰ ⵜⴶⵤⴾⵓⵏ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ⵜⵙⵍⵎⵢ ⵙ ⴹⵓⵏⵏ \"ⵜⴾⵍⵢ ⴶⵗ\" ⵏⵗ ⵂⵔⵓⴰ \"ⴰ ⴾⵓⵏ⵿ⴹⵆⵍⴰ⵰\" ⵏⵔ ⵈⵙⵍ ⵙ ⴹⵜⵔⵎ ⵜⵙⴼⵍⵓⵙⵜⴾⵓⵏ ⵜⵏⴰ ⵜⴰ ⴶⵗ \"ⵆⵍⵗ ⵀ\" ⴼⵍⵙ ⵀⴰ ⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ⵎⵔⵏ ⵔⵜⵏ ⵓⵏ ⵎⵍⵗⵓⵏ⵿ⵜⵏ ⵎⵔⴹⴰ ⵂⵔⵓⴰ ⵓⵔ ⴶⵏ ⴼⵍ ⵙⵔⵢ ⵜⵤⴶⵤⵏⵎ ⵍⵓⵆ ⵓⴹ ⵤⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ⵓⵔ ⴹⵔⵓⵏ ⵤⵍⵙⴰ ⴶⵢ ⵏⵀⵜⵓ ⵜⴶⵜ ⴼⵍⵙ ⵎⵏⴾⵍ ⵏⴹⵏⵜ ⵤⵢⴹⵓ⵰ ⵓⵔ ⴹⵏⴾⴰ ⴹⵔⵜ ");
INSERT INTO ttqt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ⵎⵛⵏ ⴾⵏ⵿ⴹⵀⴰ ⴶⵗ ⵓⵙ ⴹⵎⵔ ⵀⴰ ⵜⵙⵏ ⴹⵏⵜ ⴹⵗ ⵙ ⵔⵗ ⵀⴰ⵰» ⵙ ⵗⵔⴹ ⵀⵜⵓ ⵜⴰ ⵏⵙⵏ «ⵏ⵿ⴾⵔⵜ ⴶⵎⴹⵜⵏⴰ ⴹⴶ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ «ⵏⴾ ⵎⵙⵏ ⵙⵀ ⵏⵍⵗⵏⵀ ⵓⴰ ⵍⵗⵏ ⵀⵏⵏ ⵎⵙ ⵎⵛⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ⵍⴹⵍⴹⵏ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵜⵔⵓ ⴹ ⵜⵈⵜⵙ ⵓⴰ ⵜⵔⵓⵏ ⴹ ⵜⴼⵏⵤ ⴼⵍ ⴹ ⴹⵏ⵿ⵤⵔ ⴶⵓ ⵔⴰ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ⵤⵏ ⴹⴹⵢ ⴹⴰ ⴾⵓⵏⵢ ⴹⴰ ⵓⵢⴹⵓ ⵙⵔⵓⵏ ⵓⵍⵏ ⵜⵤⴹⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ⴶⵓⵜ ⴹⵔⵢ ⵜⵔ⵿ⵜⵢⵜ ⵛⵍⵜ ⵏ⵿ⵜⴰ ⴹⵔⵓⵏ ⴶ ⵤⵍ ⵓⵔ ⵤⵔⵓ ⵗⵙⵏⵜ ⵙ ⴹⵆⵜⵙ ⴹⵗ ⵛⴾ⵰ ⴾⵓⵏⵢ ⴹⴰ ⵍⵎⵜⵍ ⴹⵢ ⴹⴰ ⵜⵂⵎ ⵙ ⴹⵔⵢ ⵓⵔ ⵜⵔ⵿ⵜⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ⵏⴾ ⵎⵙⵏ ⵙⵀ ⵏⵍⵗⵏⵀ ⴾⵓⵏⵢ ⵍⴹⵍⴹⵏⵜ⵰ ⵓⴰ ⴹⵔⵢ ⴶⵏ ⵜⵔ⵿ⵜⵢⵜ ⵜⴰ ⴹⵔⵙ ⴶ ⵜⴹⵜⴶⵎⴹ ⵜⵏ⵿ⴼⴰ ⵜⴶⵜ ⴼⵍⵙ ⵙ ⴹⵗⵢ ⵏ⵿ⵜⵆⵜⵙⵎ ⵓⵔ ⵜⴼⵔⴶⵎ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ⵓⴰ ⴹⵔⵢ ⵓⵔ ⵏⵔ⵿ⵜⵢ ⴹⵏⵜⵓⴶⵔ ⵛⵍⵜ ⵏⵍⴹⵍⴹ ⵆⵜⵙⵏ ⵆⵔ ⵜⵓⴾⵎⴹⵓ ⵜⵓⴶⵔ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵀⵍⴶⵍⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ⵙ ⴹⵔⵢ ⵜⵔ⵿ⵜⵢⵎ ⵜⵜⴼⵎ ⵀⵜⵜⵏⵏ ⴶⵎⵢⵜ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵔⵎ ⵜⵜⴶⵔⵓⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⵙ ⵜⵜⵓⵏⵢ ⵜⵏⵢⴰ ⵏⵀⵏⵏ ⴹⵜⵔⵓⵎ ⵜⵏ⵿ⴼⴰ ⵜⴶⵜ ⵙⴾⵏⵓ ⴹⵢ ⵙ ⵜⵎⵙⵎ ⵏⵜⵍⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ⵜⵔⴰ ⵜⴰ ⴹⴶⴰ ⵀⴰ ⵏ⵿ⵜⴰ ⴹⵓⵏⴶ⵰ ⵜⴼⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ⵙ ⵎⵙ ⵙ ⵜⵜⴼⵎ ⵍⵓⵌⵀⵏⵏ ⵓⴹⵢ ⵜⵂⵎ ⵜⵔⵏⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵏⴾ ⴹⴰ ⵜⴼⴰ ⵓⵏ ⵀⴰ ⵂ ⵜⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ⵏⵗⵓⵏ ⴹⵢ ⴼⵍ ⴹ ⵜⴶⵎ ⵜⴼⵍⵓⵙ⵿ⵜ ⵤⵏ ⵜⴰ ⴶⵗ ⵜⴶⵎ ⴹⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴾⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵓⵌⵀ ⵓⵏⵏ \"ⵏⵎⵔⵓⵜ ⵙⵎⴾ ⵓⵙ ⴾⵓⵏⵔ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ⵓⵔ ⵜⵜⵍⴰ ⵜⵔⴰ ⵜⴶⵔⵜ ⴹ ⴾⴼⵓ ⵓⴹⵏ ⵎⵏⵜ ⴼⵍ ⵎⴹⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ⵙ ⵎⵙ ⵙ ⵜⵜⴶⵎ ⵓⵙ ⴾⵓⵏⵎⵔⴰ ⵓⴹⵢ ⴾⵓⵏⵢ ⵎⴹⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ⵓⵔ ⴹⵓⵏ⵿ⴶⵏⵗ ⴾⵍⵏ ⴼⵍⵙ ⴾⵍⵢ ⵓⵔ ⵜⵙⵏ ⵔⵜ ⵓⴰ ⵜⴶ ⵎⵛⵙ⵰ ⴾⵍⴰ ⴾⵍⵔ ⴹⵓⵏ⵿ⴶⵏⵗ ⵎⴹⵓⵏⵏ ⴼⵍⵙ ⵓⵙ ⵙⵍⵗ ⵗⵔ ⵀⵏⵏ ⴾⵍ ⵙⵙⵏⵗⵓⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ⵓⵔ ⴹⵜⵙⵏⴼⵔⵏⵎ ⴾⵓⵏⵢ ⵎⵔⵏ ⵏⴾ ⴾⵓⵏⵙⵏⴼⵔⵏⵏ⵰ ⵙⵓⵔⵆⵓⵏ ⴹ ⵜⴶⵍⵎ ⵜⵎⵤⵍⵎ ⵓⴰ ⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⵜⴶⵜ ⵗⵔ ⵎⵛⵏⴰ⵰ ⵜⵏ⵿ⴼⴰ ⴹⵢ ⴹⴰ ⵜⴰ ⵤⴰ ⵜⵂⴶⵜ⵰ ⵜⴶⵎⵢⵎ ⴹⵗ ⴹⵗ ⵀⴰ ⵙⵙⵎⵏ ⴹⵓⵏ⵿ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ⵎⵔⵆⵓⵏ ⵙⴹ ⵜⵏⵎⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ⴾⴹ ⴶⵤⵔ ⴾⵓⵏ⵿ⵜⴶⴰ ⴹⵏⵜ ⵙⵏⵜ ⵙ ⵜⴶⵤⵔⵢ ⴹⵜⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ⴾⴹ ⴾⵓⵏⵢ ⴹⵏⵜ ⴾⵓⵏ⵿ⵜⵍⵜ ⵓⴹⵢ ⴹⵏⵜ ⵜⵔⴰ ⵓⴰ ⵜⵍⴰ⵰ ⵎⵛⵏ ⵓⵔ ⴾⵓⵏ⵿ⵜⵍⴰ ⴼⵍⵙ ⵏⴾ ⴾⵓⵏ ⴹⵗⵙ ⴹⵙⵏⴼⵔⵏⵏ ⴹⵢ ⴼⵍ ⴾⵓⵏ⵿ⵜⴶⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ⴾⵜⵓⵜⴹⵓ ⵓⴰ ⴹⵓⵏⵏⵗ ⵙ \"ⴾⵍⵢ ⵓⵔ ⴶⵔ ⵎⵛⵙ⵰\" ⴾⴹ ⵙⴾⵏⵢ ⴹⴶⵏ ⵍⵗⵤⵀ ⴹⵓⵏ⵿ⵜⵙⴾⵏⵏ ⴾⵓⵏⵢ ⴹⴰ⵰ ⴾⴹ ⵜⵔⴹⵓⵜ ⴶⵏ ⵙⵓⵍⵏ ⵓⴹⵢ ⴾⵓⵏⵢ ⴹⴰ ⴹ ⵔⴹⵏ ⵙ ⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ⴹⵢ ⴾⵍ ⴹⵍⵍⵏ ⴼⵍ ⴹⵓⵏ⵿ⵜⵤⴶⵏ⵰ ⴼⵍⵙ ⵓⵔ ⵙⵏⵏ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ⵏⵔ ⴹⵓⵔⵙ ⵛⵓⵍⵗⵙⵏ ⵓⵔ ⵤⵜⵔⵎⵙⵏ ⵙ ⵀⴾⴹⵏⵙⵏ ⴶⵙ ⵎⵔⴹⴰ ⵓⵔ ⵜⵍⴰ ⵙⵔⵓ ⵓⵍⵢⵏ ⴹⵙⵏ⵿ⵤⴶⴹⵍⵏ ⵙⵔⵙⵏ ⵜⵔⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ⵓⴰ ⴹⴶⵤⵔⵏ ⴶⵤⵔ ⵀⵏⵏ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ⵏⵔ ⵓⵔ ⴶ ⴶⵔⵙⵏ ⵎⵤⵍⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙ ⴾⵍⴰ ⵜⵏⴶⴰ ⵓⵔ ⵤⵜⵔⵎⵙⵏ ⵙ ⵀⴾⴹⵏⵙⵏ⵰ ⵏⵢⵏ⵿ⵜⵏ ⴶⵙ ⴶⵍⵏ ⴶⵤⵔⵏⵏⴰ ⵏⴾ ⴹⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ⵎⵛⵏ ⴹⵢ ⴶⴰ ⴼⵍ ⴹ ⵜⵏ⵿ⴹⵓ ⵀⵜⵓ ⵜⴰ ⵜⵜⵓⴾⵜⵀⵜ ⴹⵗ ⵜⵓⵔⵜ ⵜⵏⵜ \"ⴶⵤⵔⵏⵢ ⵀⵏⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ⵙ ⴹⵙⴰ ⵎⴹⵂⵍ ⵓⴰ ⴹⵓⵏ⵿ⴹⵤⵙⴶⵍⴰ ⵗⵔ ⵀⴰ ⵎⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵙⵏⴼⵍⵍⵏ ⵜⴹⵜ ⵙⵔⵓⵏ ⴹⵤⴶⵎⴹⵏ ⵀⴰ ⴼⵍⵢ ⴶⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ⴾⵓⵏⵢ ⴹⴰ ⴼⵍⵢ ⵜⴶⵢⵎ ⴼⵍⵙ ⵜⴹⵓⵎ ⴹⵔⵢ ⵂⵔⵓⴰ ⵗⵔ ⵜⵤⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«ⵎⵍⵗⵓⵏ ⴹⵢ ⴼⵍ ⴾⵓⵏⵓⵔⴶⵎⴹ ⵤⴶⵤⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ⴹ ⵜⵜⵓⴾⵙⵎ ⴹⵗ ⵍⵌⵎⵗⵜ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴼⴹⴰ ⵍⴾⵎ ⵍⵓⵆ ⴹⵗⵙ ⵓⴰ ⴹⵗⵓⵏ ⴾⵙⵏ ⵎⵏ ⵍⴰ ⵗⵔⵙ ⵙ ⵜⵔⴰ ⵏⵎⵛⵏⴰ ⵎⵤⵍ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ⴹⵢ ⴹⵓⵏ⵿ⵤⴶⵏ ⵢⵜⴹⵏ ⴼⵍⵙ ⵓⵔⵎⴹ ⴹⵤⴹⵢⵏ ⵓⵍⴰ ⵙⵏⵏ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ⵎⵍⵗⵓⵏ ⵔⵜⵏ ⴹⵢ ⵎⵔⴹⴰ ⴼⵍ ⵜⵏ⵿ⴹⵜⴾⵜⵎ ⵙ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵤⴶⵏ ⵢⵜⴹⵏ ⵜⵔⵏⵙⵏ⵰ ⵔⵜⵏ ⵓⵏ ⵓⵔ ⴹⵓⵏ⵿ⵜⵏⵎⵍⴰ ⴹⵗ ⵜⵤⵔⵜ ⵏⵛⵗⵍⵏ ⵗⵔⵓⵏ ⴼⵍⵙ ⵍⵓⵆ ⵓⴹⵢ ⵂⵔⵓⴰ ⴹⴰ ⴹⵓⴰ ⴹⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«ⵎⵔⴹⴰ ⴹ ⵆⵍⴰ ⵓⴰ ⴹⴹⵤⵎⵤⵍⵏ ⵎⵛⵏ ⵓⵔ ⴾⵓⵏⵂⴰ ⵢ ⴹⵙⵙ⵿ⵜⵏⵏ ⴹⴹ ⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ⴶⵙ ⴾⵏⵏ ⵎⵏⵓⵏ ⵗⵛⴹ ⴼⵍ ⵙ ⴹⵓⵏⵏⵗ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ⴹⵔ ⴶⴰ ⴹⵢ ⴹⴰ ⵢⴰ ⴹⵓⵏⵎⵍⴰ ⵜⴹⵜ ⴼⵓⵏ ⴹ ⴶⵍⴰ ⴼⵍⵙ ⵙ ⵓⵔ ⴶⵍ ⵓⵔ ⴾⵓⵏ⵿ⴹⵤⵙⵓ ⵎⴹⵂⵍ ⵙ ⴶⵍ ⵎⵔⵏ ⴹⵓⵏ⵿ⵜⴹⵙⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ⵙ ⴹⵙⴰ ⴹ ⵙⵙⵏ ⵢⵜⴹⵏ ⵏⴹⵏⵜ ⵙ ⵈⵔⴾⵏ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵎⵙⵏ ⵀⴾⴹ ⴹⵓⴰ ⵎⵙⵏ ⵜⵆⵜ ⵏⵎⵛⵏⴰ ⴹⵓⴰ ⵎⵙⵏ ⵛⵔⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ⵙⵙⵏ⵿ⵜⵏ ⵙ ⵈⵔⴾⵏ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵎⵙ ⵀⴾⴹ ⴼⵍⵙ ⵜⴶⵢⵜ ⴶⵏ ⵙⵔⵢ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ⵙⵙⵏ⵿ⵜⵏ ⵙ ⵈⵔⴾⵏ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵎⵙⵏ ⵜⵆⵜ ⴼⵍⵙ ⵜⵓⵗⵍⵢ ⴶⵗ ⵀⴰ ⵎⵔⵏ ⵓⵔ ⵤⵍⵙⵗ ⵜⵓⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ⵙⵙⵏ⵿ⵜⵏ ⵙ ⵈⵔⴾⵏ ⴹⵗ ⵀⵜⵓ ⵏⵓⴰ ⵎⵙⵏ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⴼⵍⵙ ⵎⵏⴾⵍ ⵏⴹⵏⵜ ⵜⵎⵙⵏ ⵀⵍⵙ ⵀⵤⵜⵓ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ⵂⵔⵓⴹⴰ ⵍ ⵀⵜⵜⵏ ⴶⵜⵏⵏ ⵙ ⵔ ⴹⵓⵏ⵿ⵜⵏⵜⴶⴰ ⴶⵙ ⵓⵔ ⴹⵙⵏⵜⵤⵎⵔⵎ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ⵙ ⴹⵙⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵏⴼⵍⵍⵏ ⵜⴹⵜ ⴾⵓⵏⵙⵍⴾⵎ ⵢ ⵜⴹⵜ ⴾⵍ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⴼⵍⵙ ⵀⵜⵜⵏⵜ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⴹⵤⴶⵎⴹⵏⵜ ⵓⴰ ⵙ ⵤⵙⵍⵓ ⵗⵙ ⴹⵗ ⴹⵓⵏ⵿ⵤⵛⵓⵍ ⴾⵜⵏⵜ ⵎⵍⵓⵏ ⵔⵜⵏ ⵓⵏ ⴹⵤⵢⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ⵙⵗⵎⵔⵢ ⴼⵍⵙ ⵓⴰ ⵤⴶⵔⵓ ⴹⵗ ⵓⴰ ⵍ ⴹⵓⵏ⵿ⵤⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ⵓⴰ ⵍⴰ ⵀⴰ ⴾⵜⵏⵜ ⵏⵏ ⵏⴾ ⴹⴰ⵰ ⴹⵢ ⴼⵍ ⴹⵓⵏⵏ ⵓⴰ ⴶⵔⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵓⴰ ⵍ ⴹⵓⵏ⵿ⵤⵎⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ⴰ ⴹⵓⵏⴶⵎⴹⵗ ⵏⵢ ⴹⴼⵔ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ ⵎⵛⵏ ⴹⵜⵍⵙⵎ ⵏⵢ ⴹⵗ ⴹⵏ ⵓⵔ ⵏⴶⵜ ⴹⴼⵔ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ⵜⵤⵔ ⵏⵎⵏⵏ ⵓⵢⴹ ⴹⵗ ⵏⵜⵍⵀⵏⵜ «ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵓⴰ ⴹⵏⵗⵏⴰ ⴹⴰ \"ⴰ ⴹⵓⵏⴶⵎⴹⵗ ⵏⵢ ⴹⴼⵔ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ ⵎⵛⵏ ⴹⵜⵍⵙⵎ ⵏⵢ ⴹⵗ ⴹⵏ ⵓⵔ ⵏⴶⵜ ⴹⴼⵔ ⴹⵢ⵰\" ⵎⴰ ⵎⵙ ⴹⵗ ⵍⵎⵗⵏⴰ ⵏ \"ⵀⴰ ⴾ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏ \"ⴹⵗ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ\" ⵓⴰ ⵎⵍ ⴹⴰ⵰ ⵔⵜ ⵓⴰ ⴹⵗ ⵛⵓⵍ ⴹⴰ ⵓⵔ ⵜⵏⴶⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ⵙⵏ ⵗⵢⵙⴰ ⵙ ⵔⵏ ⴹ ⵜⵙⵙ⵿ⵜⵏⵏ⵰ ⵏⵙⵏ «ⵜⵜⵏⵎⵙⵙ⵿ⵜⵏⵎ ⴼⵍⵙ ⵏ \"ⴰ ⴹⵓⵏⴶⵎⴹⵗ ⵏⵢ ⴹⴼⵔ ⵍⵓⵆ ⵓⵔ ⵏⴶⵜ ⵎⵛⵏ ⴹⵜⵍⵙⵎ ⵏⵢ ⴹⵗ ⴹⵏ ⵓⵔ ⵏⴶⵜ ⴹⴼⵔ ⴹⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⴹ ⵜⵍⵎ ⵜⵙⴾⵍⵍⵎ ⵎⵛⵏ ⵢⵜⴹⵏ ⵏⴹⵏⵜ ⵏ⵿ⵜⵏⵢ ⴹⵓⵏ⵰ ⴹ ⵗⵛⴹⵏ ⵎⵏⵓⵏ ⴶⵙ ⵗⵛⴹ ⴹⵢ ⵜⵜⵤⵔⵢ ⵜⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ⵜⵏ⵿ⵜⵜ ⵙ ⵜⵜⴶⵤ ⵎⴹⵍ ⴹ ⵗⵛⴹⵏ ⵎⵏⵜ ⴼⵍ ⴶⴹ ⵓⴰ ⴹⵜⴶⴰ ⵍⵓⵆⵏⵜ⵰ ⵎⵛⵏ ⵙ ⴹⵂⵓ ⵀⵔⵔⵏⵜ ⴹ ⵜⵎⵤⵢ ⴹⵙⵎⴹⵔⵏ ⴹⵗ ⵔⴾⵏⵢ ⵓⴰ ⵜⵏⵢ ⵙⴹⵓⵜⵜ ⵙ ⴹⵜⴶⴰ ⵓⴹⵏ ⴹⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ⴾⵓⵏⵢ ⴹⴰ ⵤⵏ ⴹⴹⵢ ⴹⴰ ⵎⵔⴹⴰ ⵗⵛⴹⵏ ⵎⵏⵓⵏ ⵎⵛⵏ ⴾⵓⵏⵍⵙⵗ ⵏⵢ ⵤⵍ ⵓⴹⵢ ⴹ ⵜⴶⵎ ⵜⴹⵓⵜ ⵙ ⵜⵓⵔⵍⴰ ⵢ ⴹⵗⵓⵏ ⵜⵜⵤⴾⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ⵓⵔ ⴹⵤⵜⵙⵙ⵿ⵜⵏⵎ ⴹⵔⵜ ⵓⵍⵢⵏ ⵤⵍ ⵓⴹⵢ⵰ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵜⴶⵎⵢⵎ ⴹⵗ ⵀⴰ ⵙⵙⵎⵏ ⴹⵓⵏ⵿ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ⵂⵔⵓⴹⴰ ⵓⵔ ⵜⵍⴰ ⵜⴶⵎⵢⵎ ⵙⵙⵎⵏ⵰ ⴶⵎⵢⵜ ⴹ ⵜⴶⵔⵓⵎ ⴼⵍ ⴹ ⵜⴶⵎ ⵜⴹⵓⵜ ⵜⴾⵎⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ⵎⵍⵗⵓⵏ ⴹⵢ ⵙⵍⵎⵜⵍ ⵎⵛⵏ ⵍⴾⵎ ⵍⵓⵆ ⴹⵗ ⵓⵏⵓⵔⵤⵍⵙⵗ ⵎⵍ ⵏⵔⵜ ⵓⵍⵢⵏ ⵆⵍⵏ ⵀⴰ ⵙⵍⵎⵜⵍ ⴾⵍⵔ ⴹⵓⵏ⵿ⵜⵎⵍⴰ ⵙⵓⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ⵍⵓⵆ ⵓⴹⵢ ⴹ ⵜⴶⵎⵢⵎ ⴹⵗ ⵀⴰ ⵙⵙⵎⵏ⵰ ⵓⵔ ⴹⵓⵏⵏ ⴹⵓⵏ⵿ⵜⵏ⵿ⵙⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ⴼⵍⵙ ⵀⴰ ⵎⵏⵜ ⵔⵓⵏ ⴼⵍ ⵙ ⴹⵜⵔⵎ ⵜⵤⴶⵤⵏⵎ ⴹⵗ ⵙ ⵗⵔⵙ ⴹⴶⵎⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ⵀⴰ ⵗⵔ ⴹⴶⵎⴹⴰ ⵙⴹⵓ ⴹⵏⵜ ⵎⵔⵏ ⵎⵔⴹⴰ ⵜⵜⴶⵎⴹⴰ ⵆⵍⵆⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ⵜⵤⵔ ⵏⵏⵙ ⵏⵜⵍⵀⵏⵜ «ⵏⵢ ⵎⵔⴹⴰ ⵜⵎⵍⵗⵏⵗ ⵔⵜⵏ ⵙⵓⴰ ⵎⵙⵏ ⵓⵔⴶ ⵙⵍⵎⵜⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ⵏⵙⵏ ⵙ ⵜⵙⵏⴰ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵆⵍ ⴹⴾⵗⵀⵔⵏ⵰ ⴹⵢ ⴹⴰ ⴼⵍ ⵏⵤⴶⵤⵏ ⵙ ⵀⴰ ⵗⵔ ⴹⵜⴶⵎⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ⵏⵙⵏ ⵗⵢⵙⴰ «ⴹⵙ ⵎⵔⴹⴰ ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ⵏⵢⵜ ⵍⵓⵆ ⵂⵤ ⴼⴹⴰ ⴶⴰ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵜⵓⵤⵓⵤⵓⵤⵎ ⴾⵢⵏ ⴾⴰ ⵗⵢⵓⵏⵜ ⵜⵢⵎⴹ ⵗⵙⵏ⵰ ⵎⵛⵏ ⵢⴰ ⵓⵔ ⵎⵙⴰ ⵗⵙⵏ ⴼⵍⵙ ⵍⴰ ⵗⵔⵢ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ⵎⵍⵗⵓⵏ ⵔⵜ ⵓⴰ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⵍⵈⵔ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⵜⴰ ⴹⵔⵢ ⵜⴶⵎ⵰ ⴹ ⵜⵏⵢⵎ ⵔⴾⵏⵢ ⴹⵗ ⴹⵏⵜ ⴹ ⵓⵔ ⵜⴾⵙⴹⵎ ⵓⵍⴰ ⴼⵍⵙ ⴹⵏⵜ ⵔⵤⵆⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵓⵏ ⴹⴾⵍ ⵙⵓⴹⵏⵜ ⴶⵤⵢ ⵌⵏⵓⵏ ⵜⵔ ⵏⴰ «ⵀⴰ ⵍⵓⵆ ⵓⴹⵓ ⵙⴾⵏⵓ ⵜⵏⵢⴰ ⵏⵀⵔⵔⵏⴾ ⴼⵍ ⴹ ⵙⴾⵏⵓ ⵏ⵿ⵜⴰ ⴹⴰ ⵜⴰ ⵏⴾ ");
INSERT INTO ttqt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ⴹ ⵜⵤⵤⵔⵆⵓ ⵢⵢⵜⴹⵏ ⴾⵍ ⴼⵍ ⴹ ⴾⴼⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵢ ⵓⵏ ⵜⵜⴾⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ⵎⵔⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵓⴰ ⵜⵜⵎⵙⵏ ⴹ ⵏⴼⵍⵍ ⵢⵢⵜⴹⵏ ⵓⴰ ⵜⵎⵙⴰ ⴾⵢ ⵎⵙⵏ ⵎⵛⵏⴰ ⵓⵏ ⵜⴹⵜ⵰ ⵏⴼⵍⵍⵙⵏ ⵏ⵿ⵜⴹⴰ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵜⵤⵎⵤⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ⵙⴾⵏⴰ ⵜⵏⵢⵏⴾ ⴼⵍ ⵎⴹⵍ ⵙⵙⵏ⵿ⴹⵢ ⵓⴰ ⴶ ⵛⵗⵍ ⵓⵙ ⴹⵜⵙⵓⵔⵗ ⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ⵎⵔⵏ ⵎⵔⴹⴰ ⴾⵢ ⵀⴰ ⴾⴼⵢ ⵗⵔ ⵎⵏⴾ ⵜⵏⵢⴰ ⵜⴰ ⵗⵔⴾ ⵍⵗ ⵂⵔⵓⴰ ⴹⵜ ⵈⵍⴾ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ⵙⵏⴼⵍⵍⵗ ⵓⴰ ⵜⵎⵙⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵜⵙⵏⴼⵔⵏⴰ ⵜⵙⴾⵜⵆⵏ⵿ⴹⵓ ⴹⵗ ⴹⵏⵜ ⵜⴶⵆⵏ ⴹⵗ ⴼⵙⵏ ⵜⴼⵏ ⵓⵍⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ⵎⵔⴹⴰ ⵙⵏⵏ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵜⴾⴼ ⴾⵢ ⵗⵔ ⴹⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ⴼⵍⵙ ⵎⵍⵗⵙⵏ ⵓⴰ ⴹⵜⵏ ⵆⵀⵍⵏ⵿ⵜⵓ ⵎⵔⵏ ⵙⵍⴾⵏⵏ ⵙ ⴾⵢ ⵗⵔ ⴹⴶⵎⴹⴰ ⵤⴶⵤⵏⵏ ⴹⵗ ⵙ ⴹⴹⵜⵤⵎⵤⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ⵓⵔ ⴾⵢⵜⵏ⵿ⵙⵢⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵏⵜ ⴾⵍⵔ ⵢⵜⴹⵏ ⵓⵏ ⴹⵜⴾⴼ ⵙ ⴾⵢⵜⵏ⵿ⵙⵢⵗ ⴼⵍⵙ ⵏ⵿ⵜⵏⵢ ⵜⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ⵓⴰ ⵍ ⴾⵍ ⵏⴾ ⴾⵢ ⴹⴰ ⵓⴰ ⵜⵍ ⴾⵍ ⵏⵓ⵰ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢⵏ ⴹⴰ ⴹⵗ ⵜⵏⴼⵍⵍ ⵜⵏⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ⵏⴾ ⵀⵙ ⵂⵗ ⴹⵏⵜ ⴾⵢ ⴹⵏⴾ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵂⵏ⵿ⵜⵜ⵰ ⵢⴰ ⵀⴰ ⴹⵢ ⵤⴹⴶⵏ ⴶⵤⵜⵏ ⵙⵙⵎⵏⴾ ⵓⴰ ⴹⵜⴾⴼⵗ ⴼⵍ ⴹ ⵆⵍⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵛⵍⵜ ⵏⵓⴰ ⴹⵔⴾ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ⵂⵔⵓⴰ ⵜⵏⵂ ⴶⵤⵆⵏ ⵙⵙⵎⵏⴾ ⴹⵜⴾⴼ ⵓⵔ ⴹⵗⵙⵏ ⵈⵔⴾ ⵓⵍⵢⵏ ⵔ ⵓⴰ ⵈⵔⴾⵏ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ⵎⵔⴹⴰ ⴾⵢ ⴹⵏⴾ ⴶⵏⵗ ⵓⴰ ⵂⵔⵓⴰ ⵂⵗ ⴹⵏⵜ ⴼⵍ ⴹ ⴶⵏ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⵏ⵿ⴹⵜ ⵜⴰ ⴹⴰ ⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ⵎⵍⵗⵙⵏ ⵓⵍⵏⴾ ⵜⴶⵤⵔ⵿ⵜⵏ ⴹⵏⵜ ⴼⵍⵙ ⵓⵔ ⵜⵏ⵿ⵜⵍⴰ ⵤⵏ ⴹⵙ ⵏⴾ ⵎⵏⵏ ⴹⴰ ⵓⵔ ⴹⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ⵓⵔ ⴹⵗⴾ ⴶⵎⵢⴰ ⵜⵏ⵿ⵜⴾⵙⴰ ⴹⵗ ⴹⵏⵜ ⵎⵛⵏ ⴶⵎⵢⴰ ⴹⵗⴾ ⵜⵏ⵿ⵜⴶⵤⴰ ⴹⵗ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ⵓⵔ ⵜⵏ⵿ⵜⵍⴰ ⴹⵏⵜ ⵤⵏ ⴹⵙ ⵏⴾ ⵎⵏⵏ ⴹⴰ ⵓⵔ ⴹⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ⵤⵤⴹⴶ ⵓⵍⵏⵙⵏ ⵙⵓⵍⵏⴾ ⵎⵙⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ⵤⵎⵤⵍ ⵓⴰ ⴹⴹⵜⴶ ⵙⴹⵏⵜ ⵏ⵿ⵜⴰ ⵜⵏ⵿ⵙⵔⵙⴶ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ⵎⵔⵏ ⴾⴼⵆⵢ ⵎⵏⵏ ⴼⵍ ⴹⵍⵍⵏⵙⵏ ⴼⵍ ⴹ ⴾⴼⵏ ⵓⵏⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵙ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ⵓⵔⴶⵗ ⵏⵜⵍⵀⵏ ⵗⵙ ⵙ ⴾⵢⵜⵏ⵿ⵙⵢⴰ ⴾⵍⵔ ⵜⵏ⵿ⵙⵢⵆⵢ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵢ ⵤⵤⴶⵤⵏⵏ ⵙⵙⵀⵀ ⵏⵙ ⵙⵍⵏ ⵢⵓⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ⴶⵎⵢⴰ ⴹⵗⴾ ⵜⵏⴶⵏ ⴾⵜⵏⵙⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙⵎⴾ ⵓⵙ ⴹⵔⴾ ⵜⵎⵙⴰ⵰ ⵏⵆⵍ⵿ⵜⵓ ⴹⵔⵙⵏ ⵏⴾⵏⵢ ⴹⴰ ⴼⵍ ⴹ ⵜⵤⴶⵤⵏ ⴹⵏⵜ ⵙ ⴾⵢ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ⴾⴼⵆⵏ ⵜⵏⵢⴰ ⵜⴰ ⴹⵜⴾⴼ ⴼⵍ ⴹ ⵆⵍⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙⵎⴾ ⵓⵙ ⵜⵏⵎⵙ ⵏⴾ ⴹⵔⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ⵏⴾ ⵔ⵿ⵜⵢⴰ ⴹⵔⵙⵏ ⴾⵢ ⵜⵔ⵿ⵜⵢⴰ ⴹⵔⵢ⵰ ⵆⵍⵏⵜ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙ ⵜⵎⵓⵜ ⵜⵏ⵿ⴹⵜ ⴼⵍ ⴹ ⵜⵙⵏ ⴹⵏⵜ ⵙ ⴾⵢ ⴹⴹⵤⵎⵤⵍⵏ ⵜⴶⵗⵙⵏ ⴹⵗ ⵜⵔⴰ ⵜⴰ ⴹⵜⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ⵀⴰ ⵔⵗ ⵙ ⵓⵏ ⴹⵜⴾⴼ ⴹ ⴶⵤⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴶ ⵓⴰ ⵂ ⴼⵍ ⴹ ⵂⵏⵢⵏ ⵜⵏⵢⴰ ⵜⴰ ⴹⵜⴾⴼ ⴼⵍⵙ ⴹⵜⵔ ⵂⵔⵓⴰ ⴹⵜ ⵈⵍⴾ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ⵀⴰ ⴾⵢ ⵗⴹⵏ ⴹⵏⵜ ⵓⵔ ⴾⵢⵜⵙⵏ ⴶⵙ ⵏⴾ ⵙⵏⵆⵢ ⵎⵔⵏ ⵏⵜⵍⵀⵏ ⵙⵏⵏ ⵙ ⴾⵢ ⴹⴹⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ⵙⵙⵏⵆⵏ ⵓⴰ ⵜⵎⵙⴰ ⵎⵔⵏ ⵓⵔ ⵤⵎⵤⵢⴰ ⴹⴶⵢ ⵏⴹⵢ ⴼⵍ ⵜⵏ⵿ⵜⴶⵤ ⵜⵔⴰ ⵜⴰ ⴹⵜⴶⵗ ⵔ⵿ⵜⵢⴰ ⴹⵔⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ⵙ ⴶⴰ ⵗⵢⵙⴰ ⵀⵜⵓ ⵜⴰ ⴾⴰ ⵜⵎⴰ ⵜⴰ ⵂⴹⵜ ⵏⴶⵔⵔ ⵓⵏ ⴾⴹⵔⵏ⵰ ⴶⵤ ⴼⵔⴶ ⵏⵛⴾⵏ ⵍⵏ⵿ⴹⵏ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ⴹⴶ ⵓⵏ ⵙⵏ⵿ⵜⵓ ⵢⵂⵤⴰ ⵙⵈⵔⵢⵜⵢ ⵓⴰ ⵤⴾⴹⵍⵏ ⵗⵢⵙⴰ ⴼⵍⵙ ⴼⵓ ⴹⴰ ⵜⴾⵢ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ⵤⵔⴹⵓ ⵢⵂⵤⴰ ⵢⴶⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⴹⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵙⴶⵍⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⴼⵔⵙⵢⵜⵏ ⵓⵢⵏ ⴼⵜⵍⵜⵏ ⴹⵀⵍⵏ ⴹⵜⵤⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ⵙ ⴹⵏⵓⴹⵏ ⵂⵤⵜⵏⵏ ⵗⵢⵙⴰ ⵙⵏⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵤⴶⵔⵓⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵓⵙ ⵜⵙⴶⴹⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ⵏⵏⵙ «ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵙ ⵏⵙⴶⴹ⵰» ⵏⵙⵏ «ⵏⴾ ⴹⴰ ⴹⴰ⵰» ⵀⴹⴹ ⴶⵔⵙⵏ ⵢⵂⵤⴰ ⵓⴰ ⵜⴾⴹⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ⵎⵤⵢ ⵓⴰ ⴹⴰ ⴹⵗ ⴹⵙⵏⵏⴰ ⵗⵢⵙⴰ «ⵏⴾ ⴹⴰ ⴹ» ⵏ⵿ⵜⴰ ⴹⵗ ⵔⵎⵗⵏ ⵆⵍⵏ ⴹⴼⵔⵙⵏ ⵂⵔ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ⵍⵙ ⵗⵢⵙⴰ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵓⵙ ⵜⵙⴶⴹⵎ⵰» ⵏⵏⵙ «ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵙ ⵏⵙⴶⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ⵏⵙⵏ «ⵓⵔⴶⵗ ⵏⵗⵓⵏ ⵏⴾ ⴹⴰ ⴹⴰ⵰ ⴹⵗ ⴹⵢ ⴾⴹ ⵏⴾ ⵙ ⵜⵙⴶⴹⵎ ⵜⵢⵎ ⵢⵜⴹⵏ ⵓⵏ ⴹⴰ ⴹ ⵌⵓⵏ⵿ⴾⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ⵎⴾ ⵓⵏ ⴹⴰ ⵙ ⵏ⵿ⴹⴰ ⵓⵍ ⵓⴰ ⴶⴰ ⴹⵜ ⵓⵏ ⵙ ⵏⴰ «ⵓⵔ ⴹⵗⵢ ⵤⵈⵔⴾ ⵓⵍⵢⵏ ⴹⵗ ⵓⵏ ⴹⵜⴾⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ⵂⴹⵓ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵍⵀⵢⴹⵓ ⵜⴾⵀⵏⵜ ⵓⵜ ⵙⵔⵙ ⴾⵍⵢ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴼⵔⵙⴹⵓ ⵜⵎⵤⴾⵏⵜ ⵜⵏ ⵗⵍ⵰ ⴾⵍⵢ ⵓⴰ ⵙⵎⵏⵜ ⵎⵍⵈⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ⵜⵤⵔ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵀⵜⵔⵙ «ⵙⵗⵍ ⵜⴾⵀⵏⴾ ⵜⵜⵔⵜ⵰ ⵓⴾ ⴹ ⵆⵎⴰ ⵓⵔ ⴶⵗ ⵍⵗⵤⵀ ⵓⴰ ⴹⵈⴾⵎ ⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ⵜⵤⵔ ⵀⵤⵏ ⵗⵢⵙⴰ ⴾⵔⴹⵏ⵿ⵜⵓ ⵎⵙⵏ ⴶⵏ ⵏ⵿ⵙⵌⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⴹⵎⵤⵔⵏⵙⵏ ⴹⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵙⴶⵍⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ⵓⵢⵏ⵿ⵜⵓ ⵤⵔⵏ ⴹⵔⵙ ⵙⵗⵢⵓⵏ ⵏⵈⵏⵏ ⵓⵏ ⴹⴶⵍ ⵏ⵿ⴾⵢⴼ ⵓⴰ ⵎⵙⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵗ ⵓⵜⵢ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ⵎⵔⵏ ⴾⵢⴼ ⵏ⵿ⵜⴰ ⴶⵏ ⵢ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⵏⵜ ⵜⵏ ⵙ ⴼⴰ ⴹ ⵎⵜ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⴹⵗ ⴹⴶ ⵏ⵿ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ⵍⴾⵎ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵢ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⵏⵜⵍⵀ ⵢⵏ⵰ ⵏⵜⵍⵀ ⵓⴰ ⵤⴹⵢ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵎⵏⵜ ⵜⵤⵔ ⴶⵤ ⴼⵔⴶ ⵓⴰ ⵗⵍⵢⵏ ⵗⵢⵓⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵗ ⵎⵤⵢ ⵓⴰ ⴹⴰ ⴹⵆ ⴶⵤ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ⵀⵜⵔⵙ ⵏ⵿ⵜⴰ ⵆⵎⴹⵓ ⴹⵜ ⵂⵏ ⵗⵔ ⵎⵢ ⵏⵗⵍⴰ⵰ ⵔⴹⵗⴹⵓ ⵏⵜⵍⵀ ⵓⵏ ⴶⵔⵓ ⵗⵔ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⴶⵤⵜ ⵜⵙⵂⵔ⵿ⵜ ⴹ ⵜⵢⵓ ⵀⵜⵔⵙ ⴶⵤ ⵗⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ⵜⵤⵔ ⵜⵏⴰ ⵜⵎⵛⵗⵍ⵿ⵜ ⵜⴰ ⵜⴶⵤⵜ ⵎⵢ ⵏⵂⵏ ⵢ ⵀⵜⵔⵙ «ⵓⵔⴶ ⴾⵢ ⴹⴰ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵏⵍⵙ ⵓⴰ ⵜⵎⵙⴰ⵰» ⵏⵙ «ⵓⵔ ⵜⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ⵙⵎⴹ ⴶⴰ⵰ ⵗⵍⵢⵗⵍⵢⵏ ⴾⵍⵏ ⴹⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵎ⵿ⵙⵢ ⵏ⵿ⵜⵎⴾⵜⵏ ⵙⴾⵙⵏ ⵙⵔⵙ⵰ ⴾⵏⵏ ⵀⵜⵔⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⴹ ⵙⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ⵙ ⵜⴶⵓ ⵓⵏ ⵙⵙ⵿ⵜⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵗⵢⵙⴰ ⴹⵗ ⵜⵍⵗⴰ ⵏⵜⵍⵀⵏⵜ ⴹⵙⵙⵗⵔⵢ ⵓⴰ ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵍ ⵓⴰ ⴶ ⵢⴹⵏⵜ ⵓⵔ ⵎⵙ ⵔⵜ ⵗⵀⵔⵏ⵰ ⴼⵓ ⴹⴰ ⵏⵏ ⵏ⵿ⵜⵗⵔⵢ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗ ⵙⵙⵗⵔⴰ ⴹⴹ ⴹⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⴹⵗ ⴹⵢ ⵓⵔ ⵜⵍⴰ ⵓⵍ ⴶ ⴹⵗ ⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ⵎⴼⵍ ⵙ ⴹⵜⵙⵙ⵿ⵜⵏⴰ⵰ ⵙⵙ⵿ⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵍⵏⵏ ⴹⵔⵜⵏ ⵓⵏ ⴹⵗ ⴹⵙⵏⵎⴶⵔⴹⴰ⵰ ⵏ⵿ⵜⵏⵢ ⵙⵏⵏ ⴹⵗ ⵔⵜ ⵓⴰ ⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ⵙ ⵏⴰ ⵗⵢⵙⴰ ⵔⵜ ⵓⴰ ⵆⵙⵙ ⵢⵏ ⴹⵗ ⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵀⴹⴹⵏ ⴹⵏ ⵏⵙ «ⵎⴰ ⴾⵢⵙⵂⵍⵏ ⴶⵢ ⵏⵍⵌⵓⵀ ⵓⴰ ⵢⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⴾⴹ ⵔⴾ ⵀⵜⵓ ⴶ ⵎⵍⵢ ⴹⴶ ⵓⴰ ⴹⵆ ⵆⵜⴶ⵰ ⴾⴹ ⵎⵔⵏ ⴶⵗ ⵀⵜⵓ ⵜⵍⵗⵜ ⵎⴰ ⵎⵙ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⴹⵜⴶⵜⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ⵙⵔⴹⵆⵓ ⵈⵏⵏ ⴹⴰ ⴾⵔⴹ ⵙⴾⵢ ⴾⵢⴼ ⵓⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ⵙ ⵜⴶⵓ ⵓⵏ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵍⴰ ⴹⵏ ⵙⴾⵙ ⵙ ⵜⵎ⵿ⵙⵢⵏ ⴹⴰ⵰ ⵜⵓⵏⵙ «ⵓⵔⴶ ⴾⵢ ⴹⴰ ⵔⵜ ⴹⵗ ⵏⵜⵍⵀ ⵏⵍⵙ ⵓⴰ ⵜⵎⵙⴰ⵰» ⵍⵙ ⵀⵜⵔⵙ ⵛⴶⵜ ⵏ⵿ⵗⵢⵙⴰ ⵏⴰ «ⴾⵍⴰ ⴾⵍⴰ ⵓⵔ ⵜⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ⵏ⵿ⴾⵔⴹⵓ ⵢⵏ ⴹⵗ ⴾⵍⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵎⵙⵏ ⵛⵆⵗ ⵏⵍⵙ ⵓⵙ ⴹⴼⵔⵙ ⵀⵜⵔⵙ ⵜⵎⵤⴾⵏⵜ ⵏⴰ ⵢ ⵀⵜⵔⵙ «ⵓⵔⴶⵗ ⵏⵢⵆⵢ ⵜⴹⵓⴰ ⴹⵔⵙ ⴹⵗ ⴼⵔⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ⵍⵙ ⵀⵜⵔⵙ ⵛⴶⵜ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⵗⵔⴰ ⴾⵌⵢ ⵗⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ⵎⵓⵢ ⵗⵢⵙⴰ ⵗⵔ ⴾⵢⴼ ⵙⵗⵢⵓⵏ ⵏⵏⵈⴾⵎ⵰ ⵜⴶⵓ ⵓⵏ ⵗⵔ ⴼⵔⵔⵢ ⵏⵏⵢ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵙ ⴹⴹⵓⵏⵏ ⵓⵔ ⴹⵔⵙ ⴶⵤⵏ ⵗⵢⵓⵏ ⵓⵏ ⵏⵈⴾⵎ ⴼⵍ ⴹ ⵜⴼⵏ ⵜⵤⴹⴾⵏⵙⵏ ⵂⵔ ⵜⵛⵏ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ⵓⵏ ⴹⴰ ⴼⵍ ⵙⵔⵙⵏ ⴹⴶⵎⴹ ⵀⵍⵜⵙ ⵓⵏ ⵎⵤⵔ ⵏⴾⵍ ⵂⵏⵜ ⴾⵏ⵿ⴹⵓ ⵏⵙⵏ «ⵎⴰ ⵎⵙ ⵍⵂⵏ ⵓⴰ ⴼⵍ ⵜⵀⵤⵎ ⵍⵙ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ⵏⵏⵙ «ⵏⵔ ⵓⵔ ⵎⵙ ⵎⴶⵢ ⵏ⵿ⵜⴾⵎⴰ ⵓⵔ ⴹⴾⴹⵤⵏⵓⵢ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵓⵢⵜⵓ ⵜⵈⴾⵎⵎⵙ ⵙⵛⵔⵗⴰ ⵓⵏⵓⵏ⵰» ⵏⵏⵙ ⴾⵍⵍⵢⵂⴹ «ⵏⴾⵏⵢ ⵓⵔ ⵏⵍⴰ ⵜⵔⴶⵜ ⵏ⵿ⵜⵏⵗⵢ ⵏⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ⵔⵜ ⵓⴰ ⴶⴰ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⵍ ⵓⴰ ⴶⴰ ⵗⵢⵙⴰ ⵙⵗⴰ ⵓⴹ ⵎⵍ ⵏⵗ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⵤⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ⵜⵤⵔ ⵆⵍ ⵀⵍⵜⵙ ⵂⵏⵜ ⵗⵔⵏ ⵗⵢⵙⴰ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ «ⵓⴾ ⴾⵢ ⴹⵗ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ⵏⵙ ⵗⵢⵙⴰ «ⵔⵜ ⵓⴰ ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵜⵏ ⵎⵗ ⴾ ⵢⵜⴹⵏ ⵓⵢⴹ ⴹⴾⵏⵏⵏ ⵙⵔⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ⵏⵙ ⵀⵍⵜⵙ «ⵏ ⵏⴾ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵎⵙⴰ⵰ ⵜⵎⵜⵢⵏⴾ ⴹⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴾⵢⴹⵓⵢⵏⵏ ⵙⵔⵢ ⵎⴰ ⵎⵙ ⵔⵜ ⵓⴰ ⵜⵗⵛⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⵜⵗⵎⵔⵏ ⵓⵔ ⵜⵜⵍⴰ ⴹⵏⵜ ⵜⴰ ⴹⴰ⵰ ⵏⵔ ⵜⵗⵎⵔⵏ ⵜⵍⵜ ⴹⵏⵜ ⴰ ⵏ⵿ⴾⵔⵏⵜⴹⵓ ⵜⵗⵔⴹⵏ ⴾⵏⵙⵏⵜ ⴼⵍ ⴹ ⵓⵔ ⴶⵤⵗ ⴼⵙⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ⴾⵍⴰ ⴾⵍⴰ ⴶⵎⴹ ⵛⴾ ⵙ ⵜⵗⵎⵔⵏ ⵓⵔ ⵜⵜⵍⴰ ⴹⵏⵜ ⵜⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ⵏⵙ ⵀⵍⵜⵙ «ⴾ ⵜⴹⵜ ⵙ ⴾⵢ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ⵌⵓⵀⵙ ⵗⵢⵙⴰ ⵏⵙ «ⴾⵢ ⴹⴰ ⵜⵏⵗ ⴹⵢ⵰ ⵓⵍⴰ ⵎⵏⴾⵍ ⵎⵙⴰ⵰ ⵔⵜ ⴹⴰ ⵓⴰ ⴼⵍ ⴹⵂⵓⴰ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴼⵍ ⴹⴶⵤⵗ ⴹⵏⵜ ⵜⵎⵙⵏ ⵙ ⵙⴰ ⴹⴶ ⵢⴹ ⴶⵢⵗ ⵢ ⵜⴹⵜ⵰ ⵓⴹⵏ ⵓⴰ ⵍⴾⵎⵏ ⵢ ⵜⴹⵜ ⴾⵍ ⵙⵙⵎ ⵢⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ⵏⵙ ⵀⵍⵜⵙ «ⵜⴹⵜ ⵤⴰ ⵎⴰ ⵜⵎⵙ⵰» ⵜⵤⵔ ⵆⵍⴹⵓ ⵀⵍⵜⵙ ⴾⵍⵍⵢⵂⴹ ⵏⵙⵏ «ⴼⵍ ⴶⵏⴰ ⵤⴰ ⵓⴰ ⴹⵆⵍⵏ ⵏⴾ ⵓⵔ ⵂⵏⵢⴰ ⵍⵂⵏ ⵓⵍⵢⵏ ⴶⴰ ⵍⵙ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ⵎⵛⵏ ⵢⴰ ⴹⵗ ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵍⵗⴹⵜ ⵙ ⴹ ⴹⵗⵍⵢ ⵎⴹ ⵓⵏ ⴾⵢ ⴹⵓⵏ⵿ⴹⴾⵙⵗ ⵢⵏ ⴹⵗ ⵎⵙⴾⵙⵏⵓⵏ⵰ ⵎⵆⵍ ⵜⵔⵎ ⴹⵓⵏ⵿ⵙⵙⵢⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ⵍⵙⵏ ⴹⴾⵍ ⵏⵎⵙⵍⵏⵙⵏ ⵓⵍⵏ ⴾⵜⵏⵙⵏ ⵏⵏⵙ «ⴾⵍⴰ ⴾⵍⴰ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ⵰ ⵀⵔⵗⵀⵙ ⵙ ⵏⵔⴰ ⴹⵏⵆⴹⵜⴾⵙⴰ⵰» ⵀⵔⵗⵀⵙ ⵓⴰ ⵌⵌⵀ ⵏⵏⴼⵍⴶ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ⵜⵤⵔ ⵎⵔ ⵀⵍⵜⵙ ⵙⴹ ⵜⵓⴶⵏⵜ ⵜⵓⵜ ⵏⵍⴾⴹ ⵢ ⵗⵢⵙⴰ⵰ ⵜⵓⴶⵙ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ⵤⴹⵏ ⵙⵌⵜⵏ ⵜⴾⵀⵜ ⵜⴶⵜ ⵙ ⵛⵏⵏⵏ ⵙⵓⵔⵏ⵿ⵜⵜ ⵗⴼⵏⵜ ⵤⵤⵍⴶⵏ⵿ⵜⵓ ⴹⵗ ⵀⵔⵏⵤ ⵤⴶⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ⵜⵂⵤⵏ⵿ⵜⵏ ⴶⵏⵏⵙ «ⵢⴾ⵰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰» ⵜⵆⵙⵏⵙ ⵙⴰ ⴹⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ⵍⵙⴹⵓ ⵀⵍⵜⵙ ⵔⴹⵗ ⵏⴰ ⵢ ⴾⵍⵍⵢⵂⴹ «ⵏⵢⵜ⵰ ⴹⵓⵏ⵿ⵜⴹⵙⵔⴹⵗⴰ ⴹ ⵜⵙⵏⵎ ⵙ ⵓⵔ ⴼⵍⵙ ⵏⵢⴰ ⵍⵂⵏ ⵓⵍⵢⵏ ⴼⵍ ⵓⴹⵀ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ⵜⵤⵔ ⵔⴹⵗⴹⵓ ⵗⵢⵙⴰ ⵜⵓⵔ⵿ⵜⵓ ⵜⴾⵀⵜ ⵏⵛⵏⵏⵏ ⵤⵍⴶ ⵀⵔⵏⵤ ⵤⴶⵗⵏ ⵏⵙⵏ ⵀⵍⵜⵙ «ⵍⵙⵏⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ⵙ ⵜⴶⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⴶⵤⵏ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⴾⵍⵏ ⵎⵙⵍⵏⵙⵏ ⴶⵏⵏ «ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ⵏⵙⵏ ⵀⵍⵜⵙ «ⵀⵤⵜⵓ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵜⵢⵜⵢⵎ⵿ⵜⵓ ⵏⴾ ⵓⵔ ⵂⵏⵢⵗ ⴹⵍⵍ ⵓⵍⵢⵏ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ⵏⵏⵙ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ «ⵏⴾⵏⵢ ⵏⵍⴰ ⵛⵔⵗⴰ ⵎⵔⵏ ⵛⵔⵗⴰ ⵓⴰ ⵂⵢ ⵙ ⵍⵙ ⵓⴰ ⵂⵔ ⴹⵜⵎⵜⵏ⵿ⵜ ⴼⵍⵙ ⵏⴰ ⵏ⵿ⵜⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ⵀⵜⵓ ⵜⴰ ⵜⴶⴰ ⵜⵙⴰ ⵓⵍⵏ ⴹⵗ ⵀⵍⵜⵙ ");
INSERT INTO ttqt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ⵆⵍ ⵂⵏⵜ ⴶⵤ ⴹⴶ ⵓⵏ ⵛⵔⵗⴰ ⵏⴰ ⵢ ⵗⵢⵙⴰ «ⵎⵏⵙ ⴹⵜⵂ⵰» ⵎⵛⵏ ⵓⵔ ⴹⵙⴶⴰ ⵗⵢⵙⴰ ⵍⵌⵓⵀ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵙⵏⴰ ⵀⵍⵜⵙ «ⵏⴾ ⵙ ⵜⴶⵢⴰ ⵙⴹⵜⵛⵓⵍⴰ⵰ ⵓⵔ ⵜⵙⵏⵗ ⵙ ⵍ ⴼⵔⴶⵜ ⵏ⵿ⴾⵢⵙⵙⵢⴰ ⵍⵗ ⵏ⵿ⵜⴹⴰ ⴼⵔⴶⵜ ⵏ⵿ⴾⵢⵜⵢⵜⵢⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ⵏⵙ ⵗⵢⵙⴰ «ⵓⵔ ⴼⵍⵢ ⵜⵍ ⵜⵔⵏⴰ ⵓⵍⵢⵜ ⵔ ⵜⴰ ⵙⵔⴾ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰ ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⴹⴶⵏ ⴶⵔ ⴼⵙⵏⴾ ⴶⵔⴾⵢ ⴶⵢ ⵏⵀⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⴶⵤ ⵀⵍⵜⵙ ⵛⵏ ⴶⵎⵢ ⵏⵙⵓⵢ ⵓⵙ ⵤⵢⵓ ⵗⵢⵙⴰ⵰ ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⴾⵍⵍⵢⵂⴹ ⴹ ⴶⵏⵏ ⵙⴼⵍⴰ «ⵍⵙ ⴹⵢ ⵙ ⵜⵜⵙⵙⵢⴰ ⵓⴹⵢ ⵓⵔ ⵜⵎⵙⵗ ⵎⴹⵢ ⵏⵆⵢⵙⵔⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵔⵎ ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵏⵏ ⵎⵙ ⵎⵏⴾⵍ ⵓⴹⵢ ⵤⵏ⵿ⴶⵓ ⵏⵆⵢⵙⵔⴰ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ⵙ ⵙⵍⴰ ⵀⵍⵜⵙ ⵢ ⵀⵜⵓ ⵜⴰ ⵙⵔⴹⵗⴹⵓ ⵗⵢⵙⴰ ⵜⵤⵔ ⵆⵎ ⴹⵗ ⵜⵈⵓⵜ ⵜⵏ ⴹⴶ ⵏⵛⵔⵗⴰ⵰ ⴹⴶ ⵓⴰ ⵙⵎⵏⵜ «ⵗⵔⵗⵔ ⵍⵙⵏ ⵜⵙⵍⵜ» ⵜⵓⵏⵙ ⴹⵗ ⵜⵍⵗⵀⵔⵜ «ⴶⵀⵜ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ⵜⴶⵓ ⵓⵏ ⵎⵙⵏⵤⵍ ⵏⵤⵍ ⵓⴰ ⴶⵏ ⵎⴹ ⵓⵏ ⴾⵢ ⵙⵎⵜⴶⵏ ⵢⵜⴹⵏ ⵢⵎⴹ⵰ ⵏⴰ ⵀⵍⵜⵙ ⵢ ⴾⵍⵍⵢⵂⴹ «ⵎⵏⴾⵍⵏⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ⵆⵍⵙⵏ ⵓⵏ ⵙ ⵙⵂⴾⵏ ⵎⵙⵍⵏⵙⵏ ⵓⵍⵏ ⴶⵏⵏ «ⵎⵜⵜ⵰ ⵎⵜⵜ⵰ ⵜⵢⵜⵢⵜⵓ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ⵏⵙⵏ ⵀⵍⵜⵙ «ⴹⵗ ⴹⵢ ⴹ ⵜⵢⵜⵢⵗ ⵎⵏⴾⵍⵏⵓⵏ ⴼⵍ ⵜⴶⵜⵓⵜ⵰» ⵏⵏⵙ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ «ⵎⵏⴾⵍⵏⵏⴰ ⵓⵔ ⵜⵎⵙ ⵔ ⵆⵢⵙⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ⵜⵤⵔ ⴾⴼⵏ ⵀⵍⵜⵙ ⵗⵢⵙⴰ ⵢⴹ ⵜⵓⵜⵢⵜⵢ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵤⵔⴶⵤⵏ ⵙⵌⵜⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ⴶⵎⴹ ⵗⵔⵎ ⵓⵢ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵤⵜⵓⵜⵢⵜⵢ⵰ ⴾⵏ ⴹⵔⵙ ⴹⴶ ⵙ ⵜⵓⵏⵓ «ⵜⴾⵢ» ⵜⵓⵏⵙ ⴹⵗ ⴹⵗ ⵜⵍⵗⵀⵔⵜ «ⴶⵍⴶⵜ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ⴹⵏ ⴹⴰ ⴹ ⵜⵢⵜⵢⵏ ⵙⵌⵜⵏ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵜⵓⵜⵢⵜⵢⵏ ⵛⵏ ⵎⴹⵏ ⵓⵢⴹ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴼⵍ ⵜⴶⵜⵓⵏ ⴹⴶⵎⵏⵜ ⴹⵗ ⵍⴰ ⵗⵢⵙⴰ ⴶⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ⵎⵔ ⵀⵍⵜⵙ ⵙⴹ ⵎⴹⴾⵍ ⵙⵍⵎ ⵜⵓⴾⵜⵀ ⴼⵍⵙ «ⵓⴰ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ» ⵜⵓⵜⵢⵜⵢ ⴹⵗ ⴼⵍⴰ ⵏ⵿ⵜⴶⵜⵓⵜ⵰ ⵜⵓⴶⴰ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ⵗⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⵙⵍⵎ ⵓⴰ⵰ ⵏ⵿ⵜⴰ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⵂⵤ ⵗⵔⵎ ⵎⵔⵏ ⵙⵍⵎ ⵓⴰ ⴾⵜⵀ ⴹⵗ ⵓⵍ ⵓⵏ ⵜⵍⵗⵀⵔⵜ ⴹ ⵓⵏ ⵜⵍⵜⵏ⵿ⵜ ⴹ ⵓⵏ ⵜⵍⵢⵏⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ⵏⵏ ⵍⵎⵎⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵢ ⵀⵍⵜⵙ «ⴹ ⵓⵔ ⵜⵢⵗ ⵙⵍⵎ ⵓⴰ ⵜⵙⵍ⵿ⵜⵗⴰ ⵜⴶⵜⵓⵜ ⴾⵜⵀ ⴼⵍⵙ ⵙ \"ⵍⵙ ⵓⴰ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ\" ⴾⵍⵔ ⴾⵜⵀ ⴼⵍⵙ ⵙ \"ⵍⵙ ⴹⴰ ⵓⴰ ⵏⵏ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵏⴾⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ⵏⵙⵏ ⵀⵍⵜⵙ «ⵔⵜ ⵓⴰ ⴾⵜⵀⴰ ⵓⵔ⵿ⵜⵤⵙⵎⵜⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ⵙ ⵜⵢⵜⵢⵏ ⵙⵌⵜⵏ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⴹⴾⵍⵏ ⵙⵍⵙⵏⵜ ⴶⵏⵙⵏ ⴾⵤⵜ ⵜⵤⵏⵏ ⴾⵍⴾ ⵏⵢⵏ ⴹⵗⵙⵏ ⴶⵔⵓ ⵢⵜ⵰ ⴹⴾⵍⵏ ⵏ⵿ⵜⴹⴰ ⵜⴾⴹⴾⵜⵏⵜ ⵜⴰ ⵤⵓⵔⵜ ⵜⴶⵜ ⴹⵗ ⵜⵀⴹⵆ ⵓⵔ ⵂⴰ ⵎⵙⵏ ⵤⵎⵢ ⵜⵙⵗⴹⵓ ⵗⵔ ⴼⵍⴰ ⵂⵔ ⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ⵏⵏ ⴶⵔⵙⵏ «ⴹ ⵓⵔ ⵏⵤⵤⵔⵜ ⵜⴾⴹⴾⵜ ⵜⴰ ⴼⴰ ⴹ ⵏⴶⵓ ⵛⵛⵗⵔⵏ ⴼⵍ ⴹ ⵏⵙⵏ ⵓⴰ ⵜⵜⵤⵍⵏ⵰» ⵔⵜ ⵓⴰ ⵏⵏ⵿ⵜⵓ ⴼⵍ ⴹ ⵜⵏ⵿ⴹⵓ ⵀⵜⵓ ⵜⵂⵜ ⵍⴾⵜⵀⵏ ⵜⴰ ⵜⵏⵜ «ⵤⵏⵏ ⵜⵀⴹⵆⵏ ⵜⵤⵔ ⴶⵏ ⵛⵛⵗⵔⵏ ⴼⵍ ⵜⴾⴹⴾⵜⵏ⵰» ⵔⵜ ⵓⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵏ ⵙⵌⵜⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵜⵢⵜⵢ ⵗⵢⵙⴰ ⵀⴹⴹⵏⵜ ⴹⴶⵎⵏⵜ ⵜⴹⴹⵏ ⵎⵙⵏⵏ ⵏⵏⵜ ⴹⵎⵔⵢⵎⴰ ⵜⵏ ⵜⵎⴹⵔⵢⵜ ⵏⵏⵏⵜ ⵜⵎⵙⵜ ⵜⵗⵔ ⴾⵍⵀⵙ ⴹⵎⵔⵢⵎⴰ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ⴶⴰ ⵗⵢⵙⴰ ⵏⵏⵜ ⵏⵢ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵏⵜ ⵀⴹⴹ ⴹⴶⵎⵏⵜ ⵏⵙ «ⵏⴰ ⵀⵔⵔⵏⵎ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ⵜⵤⵔ ⵏⴰ ⵢⵏⵜⵍⵀⵏⵜ ⵓⵏ «ⵏⵏⴾ ⴹⵢ⵰» ⵎⵤⵢ ⵓⵏ ⴹⴰ ⴹⵗ ⴹⵔⵙ ⴹⵓ ⵏⵜⵍⵀ ⵓⵏ ⵙⵗⵢⵓⵏⵜ ⵙⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵗⵢⵙⴰ «ⵂⵢ ⴼⴹ» ⴼⵍⵙ ⵙⵏ ⵙ ⵔⵜ ⴾⵍ ⴾⵎⵍ ⵎⵔⵏ ⵔⵜ ⵓⴰ ⵓⵔ ⵜⵏⴰ ⵔ ⴼⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ⴹⴶⵏ ⵏ⵿ⵙⴰ ⴹⵗⵙ ⵗⵤⵓ ⵂⴰ ⵀⵏⴶⵔ ⵜⵎⴹⴾⵍⴹⵓ ⵜⴹⴼ⵿ⵜ ⵜⵜⵓⵜⵍ ⴹⵎⵢ ⵏⴶⵀⵍ ⵏⵤⵏⴼ ⵏⵏⵗⵏⵗ ⵢⵏ ⴹⵓⵍⵏ ⵙ ⵜⵓⵏⵓ ⵈⵙⴼ ⵜⵜⵓⵙⵍⵎⵗⴹⵓ ⴹⵗ ⵀⵏⴶⵔ ⵓⴰ ⵜⵜⵓⵤⵍⵏ ⵙⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ⵙ ⵤⵏⵍⵎⵤ ⵗⵢⵙⴰ ⵀⵏⴶⵔ ⵏⴰ «ⵔⵜ ⴾⵍ ⴾⵎⵍ⵰» ⵜⵤⵔ ⵙⵔⵙ ⵗⴼⵏⵜ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ⵤⵍ ⵓⵏ ⵙⵎⵜⴶⵏ ⵢⵜⴹⵏ ⵢⵎⴹ ⵓⵏ ⴾⵢ⵰ ⵓⵔ ⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴹ ⵆⵎⵏⵜ ⵍⵤⵏⵤⵜⵏ ⵏⵢⵜⴹⵏ ⵓⵔⵏⵜ ⵛⴶⵜⵓⵏ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜⵏⵙⵏ⵰ ⵏ⵿ⵜⴰ ⵤⵍ ⵓⵏ ⵓⵔ ⴶⴹⴰ ⴹⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵤⵓⵔ⵿ⵜ⵰ ⴾⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵀⵍⵜⵙ ⵏⵏⵙ «ⵎⵔ ⵙⴹ ⵜⵓⵔⵤⵏ ⴹⵔⵏⵙⵏ ⴼⵍ ⵜⵏⵀⴰ ⵜⵔⵎⴹ ⵜⵙⴾⵙⴹⵓ ⵍⵤⵏⵤⵜⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ⴾⵏ⵿ⴹⵓ ⵙⵌⵜⵏ ⵎⴹⵏ ⵓⵏ ⵜⵓⵜⵢⵜⵢⵏⵏ ⴹⴶⵎⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵔⵤⵏ ⴹⵔⵏ ⵏⵓⴰ ⵤⵔⵏ ⴾⵢⵏ ⵙ ⵓⵏ ⵛⵏ ⴶⵏⵙ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ⵙ ⴹⵓⴹⵏ ⵗⵢⵙⴰ ⵏⵢⵏ ⵙ ⵙ ⴹⵙⵏ ⴹⴰ ⵀⵜⵓ⵰ ⵆⵎⵏ ⴹⴰ ⵓⵔ ⵔⵤⵏ ⴹⵔⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ⵎⵛⵏ ⴹⴶ ⵢⵏ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⵜⵙⴶⴰ ⵏ⵿ⵗⵢⵙⴰ ⵙⵍⵗⵏⵜ ⴼⵢⴹⵓ ⴹⵗⵙ ⵤⵏⵢ ⴹⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ⵓⴹⵏ ⵓⴰ ⴶⵏ ⵙⵍⵏ ⵓⵏ ⵏⵢⵜⵏ ⵙ ⵛⵜⵓⵏⵜ ⵎⵔⵏ ⵜⴶⵢⵏⵜ ⵜⴹⵜ ⵜⵎⵙ⵰ ⵙⵏ ⵙ ⵜⴹⵜ ⵜⴰ ⵜⵤⴹⵔⵜ ⵙ ⵛⵓⵍ ⴹⴰ ⴼⵍ ⴹ ⵜⵤⴶⵤⵏⵎ ⴾⵓⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ⵏ⵿ⵜⴰ ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵓⵔ ⴶⵏ ⵔ ⴼⵍ ⴹ ⵜⵏ⵿ⴹⵓ ⵀⵜⵓ ⵜⵂⵜ ⵍⴾⵜⵀⵏ ⵜⴰ ⵜⵏⵜ «ⵗⵙⵏⵜ ⵓⵍⵢⵏ ⵓⵔ ⵤⵔⵤ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ⵍⴾⵜⵀⵏ ⵂⵏ ⵏ⵿ⵜⴹⴰ ⵙ «ⴹ ⵙⴹⴶⵏ ⵙⵓⴹⵏⵙⵏ ⵙⴰ ⵙⵔ ⵓⴰ ⵙⵈⵔⵀⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ⴹⴼⵔ ⴹⵢ ⵙⴹⵓ ⵢⵙⴼ ⵓⵏ ⵗⵔⵎ ⵏⵔⵎⵜⵢ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵙ ⴹⵗ ⵙⵔ ⴼⵍⵙ ⴾⵙⴹ ⴾⵍⵍⵢⵂⴹ⵰ ⴾⴰ ⵀⵍⵜⵙ ⴶⵎⵢ ⴹⵗⵙ ⴹ ⵓⵢ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ⴾⴼⵢ ⵀⵍⵜⵙ ⵜⵔⴶⵜ ⵏⵓⵏ ⵜⵤⵔ ⴶⵍⴰ ⵓⵢⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ⵙⴹⵓ ⵏⴾⴹⵎⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵏ⵿ⵜⴰ ⵙ ⴾⵍⴰ ⴹⵏⵙⴰ ⵗⵢⵙⴰ ⵂⴹ ⵢⵏ⵰ ⵓⵢⴹⵓ ⵜⴼⵔⵛⵜ ⴹⵗ ⵏ⵿ⵗⵍⵏ ⵍⵓⵔⴹⵜⵏ ⵜⵎⵙⵜ ⵎⴹⵍ ⵏ⵿ⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⴾⵍⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ⴹⴾⵍⴹⵓ ⵢⵙⴼ ⴹⵏⴾⴹⵎⵙ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏ⵿ⵜⵜ ⴹⵗ ⵛⴼⵜ ⵜⴶⵜ ⴹⵗ ⵜⵙⵓⴹ ⵙⵍⵍⵏ⵿ⵜⵜ ⴹⵜⵏ ⵤⴹⵏⵏ ⵓⵏ⵰ ⵔⵜ ⵓⴰ ⵎⵙ ⵍⵗⴹⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵏⵀⵍ ⵏⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵓⵜⵢⵜⵢ ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⵂⵢ ⴼⵔⴶ⵰ ⵎⵔⵏ ⴼⵔⴶ ⵓⵏ ⵂⵢ ⵤⴾⴰ ⵎⵙⵏ ⴾⵤⵎ ⵙ ⵓⵔ ⴾⵍⴰ ⴹⵗⵙ ⵜⵓⴶⴰ ⵏⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ⵤⵍ ⵓⵏ ⵏ⵿ⵜⴰ ⴹⵗ ⵙⵎⵜⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵢⵤⵍⵏⵙⵏ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵓⵏ ⴹⴰ ⴼⵍ ⴶⴰ ⵢⵙⴼ ⴹⵏⴾⴹⵎⵙ ⵗⵢⵙⴰ ⴹⵗ ⵤⴾⴰ ⵓⴰ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵂⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ⵙ ⴼⵓ ⵤⵍ ⵓⵏ ⵍⵈⴹ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴼⵔⵢⵔⵢ ⵏⵢ ⵙ ⵜⴾⴰ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⵤⴾⴰ⵰ ⵙ ⴹⵏ⵿ⵜⵙⴰ ⵜⵏⵢ ⵙ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⵂⵔⵜ ⵤⴾⴰ ⵜⵜⵓⴾⵙⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ⵜⵤⵍ ⵜⴾⴰ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⴹⵏⵜⵍⵀ ⵓⴰ ⵙⵏⵂⵍ ⵗⵢⵙⴰ ⵜⵔⴰ ⵜⵏⵙⵏ «ⵎⵍⵢ ⵜⵓⴾⵙ ⴹⵗ ⵤⴾⴰ ⵎⵔⵏ ⵓⵔ ⵏⵙⵏ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵓⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ⵔⴹⵗⴹⵓ ⵀⵜⵔⵙ ⴹⵏⵜⵍⵀ ⵓⴰ ⵂⴹⵏ ⴾⵏ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ⵤⵍⵏ ⵤⵔⵏ ⵏⵜⵍⵀ ⵓⴰ ⵂⴹⵏ ⴼⵍⵙ ⵔⵏⴰ ⵀⵜⵔⵙ ⴹⵗ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ⵛⴶⴰ ⵏⵢ ⵛⵙⵓⴹ ⵛⵏ ⵛⴼⵜ ⵏ⵿ⵙⵏⵜ ⴹⵏ ⵎⵛⵏ ⵓⵔ ⴶⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ⵙ ⴹⵓⴹ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵓⴰ ⴹⵙⴹⵍⴾⵎⵏ ⴶⵤ ⵤⴾⴰ ⵏⵢ ⵏ⵿ⵜⴹⴰ ⵛⵙⵓⴹ ⵛⵏ ⵏ⵿ⵙⵏⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ⵏⵢ ⵙⵍⵙⵓ ⵓⴰ ⵓⵔⵏ ⵗⴼ ⵏ⵿ⵗⵢⵙⴰ ⵓⵔ ⵔ⵿ⵜⵢ ⴹⵛⴼⵜ ⵜⵍ ⵏ⵿ⵙⴰ ⵙⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ⵜⵤⵔ ⴶⵤⴹⵓ ⵏⵜⵍⵀ ⵓⴰ ⵂⴹⵏ ⵙⵏ⵿ⵜⴰ ⴹⵤⵔⵏ ⵏⵢ ⵔⵜ ⵓⴰ ⵤⴶⵤⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ⵏ⵿ⵜⴰ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴶⵔⵏ ⵀⵜⵓ ⵜⴰ ⵜⵏⵜ ⴹⵗ ⵍⴾⵜⵀⵏ ⵍⵎⵙⵈ ⴾⵏ⵿ⴹⵀⴰ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ⵜⵤⵔ ⵆⵍⵏ ⵏⵜⵍⵀ ⵓⵏ ⴹⵏ ⵗⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ⵜⵆⵎⴹⵓ ⵎⵔⵢⵎⴰ ⵜⵂⵍⵓ ⴹⴶⵎⴰ ⵏⵤⴾⴰ⵰ ⵜⵛⴶⵏ ⴹⵗⵙ ");
INSERT INTO ttqt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ⵜⵏⵢ ⵛⵏ ⵏ⵿ⴶⵍⵙⵏ ⵙⵎⵍⵍⵏⵏ ⵆⵎⵏ ⴹⵗ ⴹⴶ ⵓⵙ ⴾⵍⴰ ⵜⵜⵂⴰ ⵜⵗⵙⴰ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵢⵏ ⵍⴰ ⵗⵔ ⵏⵎⴹ ⵏⵗⴼⵏⵜ ⵓⴰ ⵂⴹⵏ ⵍⴰ ⵗⵔ ⴹⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ⵏⵏⵙ «ⵎⴰ ⴾⵎⵙⵍⵏ ⵜⵏ⵿ⵜⵜ⵰» ⵜⵏⵙⵏ «ⵓⵔ ⴹⵙⵍⵓ ⵔ ⵙ ⵎⵓⵢ ⵎⵍⵏⵏ ⵎⵔⵏ ⵓⵔ ⵙⵏⴰ ⴹⴹ ⵜⵓⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ⵙ ⵜⵏⴰ ⵔⵜ ⵓⴰ ⵜⵙⵓⴹ ⴹⴼⵔⵙ ⵜⴶⴰ ⵗⵢⵙⴰ ⵀⴹⴹ⵰ ⵎⵛⵏ ⵓⵔ ⵜⵙⵏ ⵙ ⵏ⵿ⵜⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ⵏⵙ ⵗⵢⵙⴰ «ⵎⴰ ⴾⵎⵙⵍⵏ ⵜⵏ⵿ⵜⵜ⵰ ⵎⴰ ⵎⵙ ⵓⵙ ⵜⵙⴶⴹⴰ⵰» ⵜⵏⵙ ⵎⵔⵢⵎⴰ «ⵢⴰ ⵍⵙ ⴾⴹ ⴾⵢ ⵜⵓⵢⵏ ⵜⵎⵍⵗⵢ ⴹⴹ ⵍⴰ ⵜⴹⵓⵢⴰ⵰» ⵔⵜ ⵓⴰ ⵙ ⴹⵙ⵿ⵜⵜⵏⴰ ⵜⵗⵍ ⵎⴶⵢⴾ ⵏⴼⵔⴶ ⵓⴰ ⵂⴰ ⵤⴾⴰ ⴹⵙⵛⵓⵍⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ⵏⵙ ⵗⵢⵙⴰ «ⵎⵔⵢⵎⴰ⵰» ⵜⵤⵔ ⵜⵎⵍⵍⵢⵜⵏ ⵜⵏⵙ ⴹⵗ ⵓⵍ ⵓⵏ ⵜⵍⵗⵀⵔⵜ «ⵔⵀⵏⵢ⵰» ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵛⵈⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ⵏⵙ ⵗⵢⵙⴰ «ⴰ ⴹⵓⵔ⵿ⵜⴶⴹⵍⴰ ⵜⴾⵍⵢ ⴼⵍⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴶⵤⵢⴰ ⵙⵀⴰ ⴾⵍⵔ ⴶⵍⵓ ⵎⵍ ⵢ ⵎⴹⵔⵢⵏⵏ ⵙ ⵏⴾ ⴹ ⴶⵤⵢⴰ ⵙⵀⵏⵏ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵀⵏⵓⵏ ⴾⵓⵏⵢ ⴹⴰ ⴶⵤⵢⴰ ⵙⵎⵍⵏⵏ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵍⵏⵓⵏ ⴾⵓⵏⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ⵜⴶⵍⴰ ⵎⵔⵢⵎⴰ ⵎⴹⵍ ⵜⵎⵍ ⵢ ⵏⵜⵍⵀ ⵙ ⵜⵏⵢ ⵎⵍⵢ ⵜⵎⵍⵙⵏ ⴹⵗ ⵓⴰ ⴹⵙⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ⵜⴹⵓⵜ ⵏⵍⵈⴹ ⵓⵏ ⴹⴰ ⵎⵏⵜ ⴹⵓⵏ ⵏⵜⵍⵀ ⵗⴼⵍⵏ⵿ⴹⵓ ⵂⵏ ⴼⵍ ⵎⵏⵙⵏ ⴼⵍⵙ ⴾⵙⴹⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ⵙⴹⵓ ⵗⵢⵙⴰ ⵀⴹⴹ ⴶⵔⵙⵏ ⵏⵙⵏ «ⵍⵈⵔ ⴼⵍⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ⵙ ⴹⵙⵏⵏⴰ ⵓⵏ ⵙⴾⵏⵏ ⴼⵙⵏⵜ ⴹⵜⵙⴶⵏⵜ⵰ ⴼⵍⵓⵙⵏ ⵏⵜⵍⵀ ⴼⵍ ⵏⵢ ⵓⴰ ⴶⵏ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ⵍⵙ ⵏⵙⵏ «ⴶⵓⵏ ⵎⵛⵏⴰ ⵍⵈⵔ⵰ ⵤⵎⵤⵍⵆⵓⵏ ⵙⵎⴾ ⵓⵙ ⴹⴹⵤⵎⵤⵍ ⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ⵙ ⴹⵙⵏⴶⴰ ⵀⵜⵓ ⵜⴰ ⵙⵓⴹⵓ ⴼⵍⵙⵏ ⵙⵎⵏⵜ ⵏⵙⵏ «ⵜⴶⵔⵓⵎⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ⵓⵏ ⵙ ⵜⵙⵔⴼⵎ ⵀⴾⴹⵏⵙⵏ ⵤⴰ ⴹⵙⵏ⵿ⵜⵓⵙⵔⴼⵏ ⵎⵔⵏ ⵓⵏ ⵙ ⵜⵏⵓⵔ⵿ⵜⵙⵔⴼⵎ ⵓⵔ ⵤⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ⵜⵎⴰ ⵓⵙ ⵜⵙⵎⴹⵆⵏⵜ ⴾⵏⵢ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵏⵜⵍⵀ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵓⵔ ⵍⴰ ⴹⵏ ⵙ ⵏⵢⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ⵙ ⴹⵙⵏⵏ ⵏⵜⵍⵀ ⵓⵏ «ⵏⵏⵢ ⵎⵍⵢ⵰» ⵏⵙⵏ «ⵓⵔ ⵤⵤⴶⵤⵏⵗ ⴾⵜ ⵓⵔ ⵏⵢⴰ ⵛⵎⵌⵔ ⵏⵙⵎⵔ ⴹⵗ ⴼⵙⵏⵜ ⴹⵙⵗ ⴹⴶⵏⵙⵏ ⵙⴹⴹⵏ ⴹⵙⴰ ⴹⵗ ⵜⵙⴶⵏⵜ ⵙⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ⵙ ⴶⵏ ⵜⵎ ⴹⵏ ⴹⴼⵔ ⵓⵏ ⴹⵓⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⵂⵏ ⵢⵏ ⵎⵔⵏ ⵜⴾⵍⵜ ⵜⵏ ⵂⵏ ⵜⵎⴰ⵰ ⴶⵤⴹⵓ ⴼⵍⵙⵏ ⵗⵢⵙⴰ ⴹⴰ ⵂⵔⵏⵜ ⵜⵙⵂⵔ ⵏⵂⵏ ⵀⴹⴹ ⴶⵔⵙⵏ ⵏⵙⵏ «ⴶⵓⵏ ⵎⵛⵏⴰ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ⴹⴼⵔ ⴹⵢ ⵏⴰ ⵢ ⵜⵎⴰ «ⴶⵓ ⴹⴹⵏⴾ ⴹⴰ ⵜⵙⵓⴹⴰ ⴹⵗ ⴼⵙⵏⵏ ⵜⴹⵙⴰ ⴹⵗ ⵜⵙⴶⵏⵏ ⵙⴼⵙⵏⴾ ⵜⵤⴶⵤⵏⴰ ⵜⵆⵎⴰ ⴹⴰ ⵓⵔ ⵜⵆⵍⵗ ⵓⴹⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ⵏⵙ ⵜⵎⴰ «ⵢⴰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ⵏⵙ ⵗⵢⵙⴰ «ⴾⵢ ⵓⵔ ⵜⵤⴶⵤⵏⴰ ⵂⵔ ⴹⵜⵏⵢⴰ⵰ ⵀⵍⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵓⵔⵏⵏⵢ ⵎⵛⵏ ⵤⴶⵤⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ⵎⵤⵍ ⵗⵢⵙⴰ ⵍⵗⵍⵎⵜⵏ ⵛⵢⴹ ⴶⵜⵏⵏ ⴹⵜ ⵏⵜⵍⵀⵏⵜ ⵎⵛⵏ ⵢⴰ ⵓⵔ ⵙⵔⵙⵏⵜ ⵎⴶⵔⴹ ⵍⴾⵜⵀ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ⴶⵙ ⵔⵜ ⵓⴰ ⵜⵂⵏ ⵜⵓⴾⵜⵀ ⴼⵍ ⴹ ⵜⵤⴶⵤⵏⵎ ⵙ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ ⵎⵙ ⴹⵗ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵔⵏ ⵙ ⵙⵔⵙ ⵜⵤⴶⵤⵏⵎ ⴹ ⵜⴶⵔⵓⵎ ⵜⵎⴹⵔ⵿ⵜ ⵙⵙⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ⴹⴼⵔ ⵓⵏ ⵍⵙ ⵗⵢⵙⴰ ⵏⴼⵍⵍ ⵢ ⵏⵜⵍⵀ ⴼⵍ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵓⵏ ⵜⵀⵔⵢⴹ⵰ ⵎⴾ ⴹⴰ ⵓⵙ ⴹⵙⵏⵏⴼⵍⵍ ");
INSERT INTO ttqt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⴹⵜⵎⴰ ⵓⵙ ⵜⵙⵎⴹⵆⵏⵜ ⴾⵏⵢ ⴹⵏⵜⵏⵢⵍ ⵓⵏ ⴾⵏⴰ ⴹⵗ ⵎⴹⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴹⵀⵔⵔⵏ ⵏ⵿ⵤⵀⴹⵢ ⴹⵛⵏ ⵏⵜⵍⵀ ⵓⵢⴹ ⴾⵜⵏⵙⵏ ⴹⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ⵏⵙⵏ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵏⴾ ⴹ ⴾⵗ ⴹⴶ ⵏⵀⵤ ⵏ⵿ⴾⴼⵜⵏ⵰» ⵏⵏⵙ «ⵏⴾⵏⵢ ⴹⴰ ⵏⴹⵓ ⴹⵔⴾ⵰» ⴶⵍⵏ ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ⵰ ⵂⴹ ⵓⵏ ⵓⵔ ⵀⵤⵏ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ⵙ ⴼⵓ ⵓⵔⵏ ⵗⵢⵙⴰ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵎⵛⵏ ⵓⵔ ⵙⵏⵏ ⵏⵜⵍⵀⵏⵜ ⵙ ⵏ⵿ⵜⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ⵏⵙⵏ «ⵎⵔⵏⵏ ⵓⴾ ⵀⵤ ⵓⵔ ⵜⴶⵎ ⵓⵍⴰ ⴹⵗ ⴾⴼⵜⵏ⵰» ⵏⵏⵙ «ⴾⵍ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ⵏⵙⵏ «ⴶⵔⵜ ⵎⵤⵤⴹⵔⵏⵓⵏ ⵓⵏ ⵀⵤ ⵏ⵿ⴾⴼⵜⵏ ⴼⵍ ⴶⵏⴰ ⵏⵗⵍⵍ ⵓⵏ ⵗⵍ ⵜⵏ⵿ⵜⴶⵔⵓⵎ⵰» ⴶⵔⵏ ⵎⵤⵤⴹⵔⵏⵙⵏ ⴹⵗ ⴶⵔⵓ ⵜⵤⵔ ⵏ⵿ⴹⵔⵙⵏ ⵜⴹⴹⴾⵍⵏ ⴼⵍ ⵓⴰ ⴶⵏ ⴾⴼⵜⵏ ⵓⵏ ⵜⵂⵏⵏ ⴹⵗ ⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ⵏ⵿ⴾⵔ ⵏⵜⵍⵀ ⵓⴰ ⵙⵏⵂⵍ ⵗⵢⵙⴰ ⵜⵔⴰ ⵏⴰ ⵢ ⵀⵜⵔⵙ «ⵓⵏ ⵎⵍⵢ⵰» ⴹⴰ ⴹⵗ ⴹ ⵙⵍⴰ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵙ ⵎⵍⵢ ⵓⵏ ⵏ⵿ⵜⴰ ⴹ ⵆⵏ ⵙⵍⵙⵓⵏⵜ ⵓⵏ ⴼⵍⴰ ⴼⵍⵙ ⵤⴼ ⵜⵤⵔ ⵜⵔⴶⵜ ⴹⵗ ⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ⵎⴹⵍ ⵏ⵿ⵙⵏⵜⵜ ⵜⵎⴹ ⵏⵗⵍ ⵍⵏⵏ ⴶⵔⵙⵏ ⴹⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ⵰ ⵆⵎⵏ⵿ⴹⵓ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵗ ⵗⵍⵍ ⵔⴾⵀⵏ⵿ⴹⵓ ⴹⴼⵔⵙⵏ ⵎⵤⵤⴹⵔⵏⵙⵏ ⴹⵏⵢ ⴾⴼⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ⵤⵀⵏ⵿ⴹⵓ ⵗⵙ ⴶⵏ ⵜⵎ⵿ⵙⵢ ⵏ⵿ⵜⵎⴾⵜⵏ ⴼⵍ ⵏⵑⵏ ⴾⴼⵜⵏ ⵜⵏ⵿ⵙⴰ ⴹⵗ ⵜⴶⵍⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵓⵢⵜⴹⵓ ⵔⵜ ⴹⵗ ⴾⴼⵜⵏ ⵓⵏ ⴹⵜⵀⵤⵎ ⵎⵔⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ⴶⵎⴹⵓ ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵎⵏ ⵍⵍⵙⵏ ⵙⵔⴾⵀ ⵏⵎⵤⵤⴹⵔ ⵓⴰ ⵂⵏ ⴾⴼⵜⵏ⵰ ⵜⵎⴹⵢ ⴹⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⴾⴼⵢ ⴹⴾⵔⴹ ⵙ ⴾⵍ ⵓⵏ ⵤⵓⵔⵏⵏ ⵜⵂⵏⵏ ⵎⵛⵏ ⵓⵔ ⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ⵏⵙⵏ ⵗⵢⵙⴰ «ⵢⵓⵜ ⵜⵜⵛⵎ⵰» ⵓⵔ ⵂⴰ ⵏⵜⵍⵀ ⵢ ⵂⵍⵏ ⴹ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵎⴰ ⵜⵎⵙⴰ⵰» ⴼⵍⵙ ⵙⵏⵏ ⵙ ⵎⵍⵢ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ⵂⵤⵜⵏⵏ ⵗⵢⵙⴰ ⵀⵤⴹⵓ ⵜⴶⵍⴰ ⴾⴼⵙⵏ⵿ⵜⵜ ⴾⴼⵏ ⵏ⵿ⵜⴹⴰ ⴾⴼⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ⵜⴾⵍⵜ ⵜⴰ ⵏ⵿ⵜⴰ ⵜⵎⵙⵜ ⵏⴼⵍⵍ ⵓⵏ ⴾⵔⴹ ⴹⴶⴰ ⵗⵢⵙⴰ ⵢ ⵏⵜⵍⵀⵏⵜ ⴹⴼⵔ ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ⵙ ⵜⵛⵏ ⵏⴰ ⵗⵢⵙⴰ ⵢ ⵙⵎⵗⵏ ⵀⵜⵔⵙ «ⵙⵎⵗⵏ ⴶ ⵢⵈⵢⴰ ⵓⴾ ⵜⴹⵜ ⵙ ⵜⵔⴰ ⵜⴰ ⴹⵜⴶ ⵜⴶⵔ ⵜⴰ ⴹⴶⵏ ⵏⵜⵍⵀ ⵓⵏ ⵂⴹⵜⵏⵏ⵰» ⵏⵙ ⵙⵎⵗⵏ «ⵢⵓ ⵎⵍⵢ ⵜⵙⵏⴰ ⴹⵗ ⵜⵔⴰ ⵜⴰ ⴹⴾⴶ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⴶⵤ ⵤⴰ ⵌⵎⵔⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ⴶⵙ ⵢⵙⵙ⵿ⵜⵏ ⵓⴰ ⴶⵢ ⵓⵏ ⵛⵏ ⵏⵙ «ⵙⵎⵗⵏ ⴶ ⵢⵈⵢⴰ ⵓⴾ ⵜⵔⵗⵢ⵰» ⵏⵙ ⵀⵜⵔⵙ «ⵢⵓ ⵎⵍⵢ ⵜⵙⵏⴰ ⴹⵗ ⵜⵔⴰ ⵜⴰ ⴹⴾⴶ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⵆⵍ ⵤⴰ ⵎⴹⵏ ⵏⵢⴼⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ⴶⵙ ⵢⵙⵙ⵿ⵜⵏ ⵓⴰ ⴶⵢ ⵓⵏ ⴾⵔⴹ ⵏⵙ «ⵙⵎⵗⵏ ⴶ ⵢⵈⵢⴰ ⵓⴾ ⵜⵔⵗⵢ⵰» ⵗⵛⴹⵏ ⵎⵏ ⵏ⵿ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⴼⵍⵙ ⴾⵔⴹ ⴶⵜⵏ ⴹⵙⴶⴰ ⵗⵢⵙⴰ ⵢⵙⵙ⵿ⵜⵏ ⵓⴰ⵰ ⵏⵙ «ⵎⵍⵢ ⴾⵢ ⵙⵏⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⵜⵙⵏⵗ ⵙ ⵔⵆⵢ⵰» ⵏⵙ ⵗⵢⵙⴰ «ⵙⵏ ⵤⴰ ⴹⵗ ⵢⴼⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ⴶⵢⵗ ⵙⵍⴾⵏⵗⴾ ⵙ ⵂⵔⵓⴰ ⵜⵢⵏⵢⴰ ⵎⵏⴾ ⵙ ⵜⵍⵙⴰ ⵜⵀⴹⵆⵏⴾ ⵜⵜⴾⵗ ⴹⴶ ⵓⵙ ⵜⵔ ⵎⵛⵏ ⵙ ⵜⵆⵍⵗ ⵗⵎⵔ ⴹ ⵜⵤⵍⵗ ⴼⵙⵏⴾ ⵙⵍⵙⴾ ⵓⴹⵏ ⵢⵏ ⵜⵀⴹⵆⵏⴾ ⵓⵢⴾⵢ ⵙⴹⴶ ⵙ ⵓⵔ ⵜⵔⵗ ⴾⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ⵀⵜⵓ ⵜⴰ ⵙⴾⴰ ⵙⵔⵙ ⵗⵢⵙⴰ ⵏⵗ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⵤⴶⵓ ⵀⵜⵔⵙ ⵙⵏ⵿ⵜⴰ ⵙ ⵤⵙⴾⵏⵓ ⴹⴾⵍ ⵓⴰ ⴶⴰ ⵢ ⵎⵛⵏⴰ⵰ ⵙ ⴶⴰ ⵗⵢⵙⴰ ⵀⵜⵓ ⵜⴰ ⵏⵙ «ⵍⴾⵎ» ");
INSERT INTO ttqt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ⵙⵓⴹⵏ ⵀⵜⵔⵙ ⴹⴼⵔⵙ ⴶⴰ ⵏⵜⵍⵀ ⵓⴰ ⵙⵏⵂⵍ ⵗⵢⵙⴰ ⵜⵔⴰ ⵍⴾⵎⵙⵏ⵿ⴹⵓ⵰ ⵏⵜⵍⵀ ⵓⴰ ⵏ⵿ⵜⴰ ⵙⵗⵎⵔⵏ ⴹⵗ ⵂⵤ ⵏⴹⵎⵔⵏ ⵏ⵿ⵗⵢⵙⴰ ⵂⴹ ⵓⴹ ⵜⵜⵏ ⵎⵏ⵿ⵙⵓⵏ ⵏⵎⴹ ⵓⵏ ⴾⵢ ⵏ⵿ⵜⴰ ⴹⵗ ⵙ ⴾⵍⴰ ⴹ ⵙⵙ⵿ⵜⵏⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵎⵍⵢ ⵎⴰ ⵎⵙ ⵓⴰ ⴾⵢ ⵤⴾⴹⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ⵙ ⵜⴶⴰ ⵀⵜⵔⵙ ⵙⵙ⵿ⵜⵏ ⵗⵢⵙⴰ ⵏⵙ «ⵏ⵿ⵜⴰ ⵤⴰ ⵎⵍⵢ ⵎⴰ ⴹⵗⵙ ⵍⴾⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ⵏⵙ ⵗⵢⵙⴰ «ⴾⴹ ⵜⵔⴰ ⴶⵗ ⴹ ⴹⵔ ⵂⵔ ⴹⵆⵍⴰ ⵜⴹⵢ ⵓⵔ ⴾⵢⵜⵆⵍ⵰ ⴾⵢ ⵍⴾⵎⵢ ⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ⵓⵤⵓⵤⵏ ⵙⵍⵏ ⴹⵗ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵙ ⵏⵜⵍⵀ ⵓⴰ ⵓⵔ ⵜⵤⵀⴰ⵰ ⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⵓⵔⴶⵗ ⵏⴰ ⵓⵔ ⵜⵤⵀⴰ ⵜⵏⴰ ⵗⵙ ⴶⴰ «ⴾⴹ ⵜⵔⴰ ⴶⵗ ⴹ ⴹⵔ ⵂⵔ ⴹⵆⵍⴰ ⵜⴹⵢ ⵓⵔ ⴾⵢⵜⵆⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ⵏⵜⵍⵀ ⵓⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙ ⴶⵢⵜ ⴼⵍ ⴶⵜⵏ ⵓⵏ ⴾⵜⵀⵜⵏ⵰ ⵏⵙⵏ ⵙ ⵜⴶⵢⵏⵜ ⵜⴹⵜ ⵜⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ⵗⵢⵙⴰ ⴶⴰ ⵔⵜⵏ ⵓⵢⴹ ⴶⵜⵏⵏ⵰ ⵙ ⴶⵎⵢ ⵓⴹⵏ ⴹⵙⵔⵙⵏ ⵎⴶⵔⴹ ⵙⵢⵏⵢⵏ ⵔⴹⵗ ⵙ ⴹⵏⵜ ⴾⵜⵏⵜ ⴹⴰ ⵓⵔ ⵤⴰ ⵜⵓⵢ ⵍⴾⵜⵀⵏ ⵓⵏ ⵤⴾⵜⵀ⵰");
INSERT INTO ttqt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ⵢⴰ ⵜⵢⴼⵍ ⵍⴾⵜⵀⵏ ⵓⴰ ⵤⵔⵏ ⴾⵜⵀⵗ ⴹⵗⵙ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵙ ⵙⵏ⵿ⵜⴰ ⵗⵢⵙⴰ ⴶⵏⵙⵏ ⴹⵙⵙⵗⵔⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ⵂⵔ ⵤⵍ ⵓⴰ ⴹⵎⴹⴾⵍ ⵙ ⵌⵏⵓⵏ ⴹⴼⵔ ⵙ ⴶⴰ ⵎⵔⵏⵜ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵢ ⵏⵎⵤⵍⵏⵜ ⵓⵏ ⵙⵏⴼⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ⵏ⵿ⵜⵏⵢⵏ ⴹⴰ ⵙⴾⵏⴰ ⵎⵏⵜ ⴹⴼⵔ ⵍⵗⵤⵀⵏⵜ⵰ ⵙⵜⴹⵙⵏ ⵙ ⵜⵎⵓⵜⵏ ⴶⵜⵏⵏ ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵤⵍ ⴶⴰ ⵜⵏⴼⵍⵍⵙⵏ ⵜⴶⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ⵤⵍ ⵢⵏ ⴹⵔⵓ ⴹⵔⵙⵏ ⵎⵏ⵿ⵙⵓⵏ ⵙ ⵜⵏⵎⵔ ⵏⵙⵏ «ⴹ ⵓⵔ ⵜⴶⵎⴹⵎ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ⵰ ⵆⵍⵜ ⵢⵔⴾⵓⵍ ⵏⵀⴰ ⵓⴰ ⴹⵓⵏⵎⵍⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ⴼⵍⵙ ⵢⵈⵢⴰ ⵎⵏ ⴹⵗ ⵙⵍⵎⵗ ⵢⵜⴹⵏ ⵎⵛⵏ ⴾⵓⵏⵢ ⵗⵔ ⴹⵏ ⵓⵔ ⵏⴶⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵤⴰ ⵜⵜⵓⵙⵍⵎⵗⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ⴹⵓⵏ ⵗⵔⵙ ⵏⵎⵤⵍⵏⵜ ⵙ ⵜⵙⵙ⵿ⵜⵏⵏ ⵏⵏⵙ «ⵎⵍⵢ ⵓⴾ ⵎⵔⴹⴰ ⴹ ⵤⴰ ⵜⵙⵗⵍⴰ ⵜⵎⵏⴾⵍⴰ ⵢⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ⵏⵙⵏ «ⵓⵔ ⴾⵓⵏ⵿ⵜⵓⵔ ⵎⵙⵏⵜ ⵏⵍⵓⵆ ⵓⵍⴰ ⵜⵎⵔ⵿ⵜ ⵓⵏ ⵜⵙ ⵀⴰ ⵙ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ⵎⵛⵏ ⵢⴰ ⴼⵍⵓⵏ ⴹⵤⵀⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⴶⵔⵓⵎ ⵜⵔⵏⴰ ⵜⵆⵍⵎ ⵛⴶⵢⵓⵏⵏ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⵢⵔⵙⵍⵎ ⴹⴾⵍ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹ ⵓⵏ ⵙⵎⵔⵢⴰ ⵜⴶⵍⵎ ⵂⵔ ⴹⴰ ⴹⵔⵤ ⵎⴹⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ⵙ ⵏⴰ ⵓⵏ ⵎⴹⴾⵍ ⵙ ⵌⵏⵓⵏ⵰ ⵙⵓⴹⵏ ⴹⵗⵙ ⵂⵔ ⴹⵙⵏ⵿ⵜⵜⵍⵙⴰ ⵜⴶⵔⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ⵂⵔⵓⴹⴰ ⴶⵤⵢⵏ ⵌⵏⵓⵏ ⵙⵗⴰ ⵓⴹ ⵜⴶⵤⵢ ⵗⵢⵙⴰ ⵙ ⵏⴼⵍⵍⵏ ⵛⵏ ⵎⴹⵏ ⵏ⵿ⵙⵎⵍⵍⵏ ⴹⴶⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ⵏⵏⵙⵏ «ⵢⴰ ⵎⴹⵏ ⵏ⵿ⴶⵍⵍⵢⴰ ⵎⵙ ⵜⵀⴹⴹⵎ ⵜⵙⵓⴹⵎ ⴹⵗ ⵌⵏⵓⵏ⵰ ⵗⵢⵙⴰ ⵓⴰ ⵎⴹⴾⵍⵏ ⴶⵔⵓⵏ ⴹⴰ ⵙ ⵌⵏⵓⵏ ⵍⴾⵎ ⴹⵆⵍ ⵙⵎⴾ ⵓⴰ ⴹⴰ ⵙ ⵜⵜⵏⵢⵎ ⴾⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ⵜⵤⵔ ⴼⵍⵏ ⵏⵎⵤⵍ ⴹⵗⵗ ⵓⵙ ⵜⵓⵏⵓ ⵓⵏ ⵛⴾⵏ ⵏ⵿ⵤⵢⵜⵏ ⵆⵍⵏ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴹⵙⵂⵏ ⴹⴶ ⵏ⵿ⵜⴾⵍⵢ ⵜⵙ ⵜⵜⵓⵍⴰ ⵜⵔⴶⵜⵏⵜ ⴹⵗ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵍⵎⵗⵏⴰ ⴹⴶ ⵏ⵿ⴾⵍⵓ ⵢⵏ⵿ⴹⴰ ⵏ⵿ⵜⴾⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ⵙ ⴹⵏⵙⵏ ⴶⵤⵏ ⵂⵏ ⵓⵏ ⴼⵍⴰ ⴹⵗ ⵙⵔⵓ ⵓⴰ ⴹⵗ ⵙⴶⵏⵏ⵰ ⵎⵙⵏ ⵀⵜⵔⵙ ⵢⵈⵢⴰ ⵢⵆⵀ ⵏ⵿ⴹⵔⵓⵙ ⴼⵍⵀⵙ ⵜⵎⴰ ⵀⵔ⵿ⵜⵍⵎⵓⵙ ⵎⵜⴰ ⵢⵆⵀ ⵓⵏ ⴶ ⵍⴼⵢ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵓⴰ ⵙⴶⵜⴾⵏ ⴹⵢⵂⵤⴰ ⵓⵏ ⴶ ⵢⵆⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ⴾⵜⵏⵙⵏ ⵜⴹⵓⵏ⵿ⴹⵓ ⵢⴶⵢ ⵏ⵿ⵜⵓⵜⵔⵓⵏ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵏ⵿ⵜⵏⵢ ⴹⵎⴹⵔⵢⵏ ⵏ⵿ⵗⵢⵙⴰ ⴹⵜⴹⴹⵏ ⵜⵂⴰ ⵎⵔⵢⵎⴰ ⵜⵏ ⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⵀⴹⴹ ⵀⵜⵔⵙ ⴶⵔ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵎⵙⵏⵏ ⵜⵎⴹⵢ ⵏⵓⴹⵏ ⴹⵙⵏⵜⵜ ⵜⵎⵔⵓⵏ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«ⵎⴹⵔⵢⵏⵏ ⵛⵍ ⴹ ⵏ⵿ⴹⵓ ⵓⴰ ⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵔⵓ ⵙⵎⵢ ⵏⵏⵀⵢ ⴹⵓⴹ ⴹⵗ ⵙⵍⵏ ⵏⵢⵂⵤⴰ ⵓⴰ ⴹⵙⵍⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵀⵤⵏⵏ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ⴼⵍⵙ ⴾⵍⴰ ⴹⵗⵏⵗ ⴹⵏ ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⵎⵔⵏ ⴶⵔⵓ ⴹⴶⵔⵏⵜ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴹⵔⵏⵗ ⵙⵏⵜⴼ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ⵍⵙ ⵤⴰ ⵓⴰ ⵤⵏ⵿ⵤⴰ ⵜⵓⴶⵙ⵿ⵜ ⴹⵗ ⵤⵔⴼ ⵓⴰ ⴶⵔⵓ ⴹⵗ ⵀⴾⴹⵏⵜ ⴹⴼⵔ ⵓⵏ ⴹⴰ ⴹⵗⵙ ⵙ ⵜⴹⵙ⵿ⵜⵏⵜ ⵀⵆⵜ ⴼⵤⵜ ⵓⴰ ⵂⵏ ⵜⴹⵙ⵿ⵜⵏⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⵢⵔⵙⵍⵎ ⵙⵍⵏ ⵓⵏ ⵂⵔ ⵙ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⴶⵏⵙ ⵙⵎ ⴹⵗ ⵓⵍⵏⵙⵏ \"ⴾⵍⴹⵎ\" ⵍⵎⵗⵏⴰ ⵜⵓⴶⵙ⵿ⵜ ⵜⵏ ⵤⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ⵎⵔⵏ ⴾⵜⵀ ⴹⵗ ⵍⴾⵜⵀ ⵓⵏ ⵤⵀⵔ ⵙ \"ⵆⵍⵜ ⵂⵏⵜ ⵎⵌⵔ ⵜⵓⵔⵍⵙ ⵓⴹⵏ ⴶⵤ⵰\" ⴾⵜⵀ ⴹⵗⵙ ⴹⵗ ⵙ \"ⴶⵤⵜ ⵓⴹⵏ ⵢⵏ ⴹⴶⵏⵜ ⴹⵗ ⵛⵗⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ⴹⵗ ⴹⵢ ⵍⵤⵎⵏⴰ ⴹ ⵏⵙⵏⴼⵔⵏ ⵢⵏ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⴹⵔ ⵏⵜⴹⵓ ⴼⵓ ⴹⵗ ⵛⴾⵍⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ⴹⵀⵤⵏ ⵗⵔ ⵤⵍ ⵓⴰ ⵜⵙⵍⵎⵗ ⵢⵈⵢⴰ ⴹⵗ ⵎⵏ ⵂⵔ ⵤⵍ ⵓⴰ ⵗⵔⵏⵗ ⵎⴹⴾⵍ ⵙ ⵌⵏⵓⵏ⵰ ⵍⵙ ⵓⴰ ⵤⴰ ⵏⵙⵏⴼⵔⵏ ⴹⴰ ⴹ ⵆⵍ ⵜⴶⵢⴰ ⵏ⵿ⵜⵏⴾⵔⴰ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ⵙⵀⴹⴹⵏ ⵛⵏ ⵎⴹⵏ ⵎⵙⵏⵏ ⵢⵙⴼ ⵓⵙ ⵜⵓⵏⵓ ⵀⵔⵙⵀⵙ ⴶⵏⵏⵙ ⴹⵗ ⵢⵙ⵿ⵜⵙ ⴹⵎⵜⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ⵜⵤⵔ ⵜⵔⵏ ⵏⵏ «ⵢⴰ ⵎⵍⵢ ⴾⵢ ⵙⵏⵏ ⵓⴰ ⵂⵏ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⴾⵍ ⵙⴾⵏⵏⴰ ⵓⴰ ⵜⵙⵏⴼⵔⵏⴰ ⴶⵔ ⵎⴹⵏ ⵓⵏ ⵛⵏ ⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ⴼⵍ ⴹ ⴶⵤ ⵛⵗⵍ ⵏⵏⵎⵤⵍ ⵓⴰ ⴶⵎⴹ ⵢⵂⵤⴰ ⴾⴰ ⴹⴶ ⵓⴰ ⵎⵙⵏ ⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ⴶⵏ ⵛⵛⵗⵔⵏ ⵀⵤⵏⵜ ⵎⵜⵢⵙ ⴹⵏ ⴹⵗ ⵏⵎⵤⵍ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ⵙ ⴹⵗⵍⵢ ⵤⵍ ⵏⵎⴹ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵙ ⵜⵓⵏⵓ ⴼⵏ⵿ⵜⴾⵓⵜ ⴹⵓⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⵜⵏⵙⵏ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ⵓⵍⴰ ⵂⴶⵏ ⴶⵎⴹⵓ ⵌⵜ ⵢⵏ ⵌⵏⵓⵏ ⵍⵏ ⴹⵏ ⴹⵓ ⵙⵂⵏ ⵜⴾⵔ ⵂⵏ ⴾⵜⵏⵜ ⵓⴰ ⴹⵗ ⵆⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ⵏⴼⵍⵍⵏⵙⵏ ⴹⵍⵙⵓⵏ ⵍⵏⵏ ⴹⵏ ⵀⵍⴶⵍⴶ ⵏ⵿ⵜⵎ⵿ⵙⵢ ⵎⵤⵢⵏ ⵍⵙⵓⵏⵏ⵰ ⴾⵍⴾ ⵏⵢⵏ ⵓⵔ ⵢⵏ ⴹⵗⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ⴹⵏⵢⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵜⵏⵙⵏ ⵜⵤⵔ ⵙⵏ⵿ⵜⵏ ⵓⵍ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵎⵙ ⵓⵏⵙⵏ ⵙⵎⴾ ⵓⵙ ⵜⵏⴾⴼⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴼⵔⴶⵜ ⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵗⵙⵔⵏ ⴹⵗⵙ ⴾⵍⵍⵢⵂⴹ ⵤⵤⵓⵜⵏⵏ ⴹⵗ ⴹⵏ ⴹⴶⵎⴹⵏⵏ ⴾⵍⵏ ⵏⴹⵏⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ⵙ ⵙⵍⵏ ⵢⵓⵍ ⵓⵏ ⵜⴹⵓⴹⵓ ⵜⵎⵜⵢ ⵜⴶⵜ ⵜⵤⵔ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⴼⵍⵙ ⴾⵢⵏ ⴹⵗⵙⵏ ⵙⵍⵓ ⵢ ⵏⵍⴾⵎⵏ ⵛⵓⵍⵏ ⴹⵗ ⵓⵍ ⵏⴾⵍ ⵓⴰ ⴹⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ⴶⴰ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ ⵍⵀⵙⵏ ⴶⵏⵏ «ⵈⴰ⵰ ⵢⵜⴹⵏ ⵛⵓⵍⵏⵏ ⴹⴰ ⵓⴾ ⵓⵔⴶⵗ ⴾⵜⵏⵙⵏ ⴾⵍⴶⵍⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ⵎⵙ ⵤⴰ ⴾⵢⵏ ⴹⵗⵏⴰ ⵙⵍⵙⵏ ⵛⵓⵍⵏ ⵓⵍ ⵏⵎⵔⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ⵏ⵿ⵜⴰ ⵏⴾⵏⵢ ⵂⵏⵏⵗ ⵢⵜⴹⵏ ⴹⴶⵎⴹⵏⵏ ⵎⴹⵍ ⵏⵀⵔ⵿ⵜⵢⴰ ⴹⴾⵍ ⵓⵏ ⵎⴹⵢⴰ ⴹ ⵓⵏ ⵍⵎ ⴹⵢⵜⴹⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⴾⵍ ⵓⵏ ⵎⵤⵀⵜⵎⵢⴰ ⴹ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹ ⵓⵏ ⴾⵀⴹⴾⵢⴰ ⴹ ⵓⵏ ⴼⵏ⵿ⵜⵙ ⴹ ⵓⵏ ⵙⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ⴹ ⵓⵏ ⴼⵔⵌⵢⴰ ⴹ ⵓⵏ ⵀⵏ⵿ⴼⵍⵢⴰ ⴹ ⵓⵏ ⵎⵙⵔ⵰ ⵓⵢⴹ ⴶⵎⴹⵏ⵿ⴹⵓ ⴾⵍ ⵏⵍⵀⵢⴰ ⴹⵗ ⵗⵍⵢⵗⵍⵢⵏ ⵏⵗⵔⵎ ⵓⵏ ⵆⵔⵓⵏ ⵓⵢⴹ ⵢⵜⴹⵏ ⵏⵔⵎ ");
INSERT INTO ttqt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ⵓⵢⴹ ⵢⵜⴹⵏ ⵏ⵿ⴾⵔⵜ ⴹⵓⵏ ⵔⵀⵢⴰ⵰ ⴶⵔ ⵤⴰ ⵓⵏ ⴹⵗⵏⴰ ⵎⵙⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⴹⵗ ⵢⵜⴹⵏ ⴹⵂⴹⵏⵏ ⵙⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵏⴰ ⵏⵙⵍⵙⵏ ⵎⵍⵏ ⴹⵗ ⵓⵍⵏⵏⴰ ⴶⵜⵏ ⵏ⵿ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ⴾⵜⵏⵙⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⵓⵔ ⵙⵏⵏ ⵏⵏ ⵜⵏⵎⵏⵏ «ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ⵎⵛⵏ ⵢⴰ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⵏ ⴹⵗ ⵏⵍⴾⵎⵏ ⵜⵎⴾⴾⵢⵜ ⴶⵏⵏ «ⵓⵏ ⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵜⵏⵙⵎⵙⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ⵜⵤⵔ ⵀⴹⴹ ⵀⵜⵔⵙ ⵏ⵿ⵜⴰ ⴹⵏⵎⵤⵍ ⵓⵏ ⵎⵔⵓ ⴹⵢⵏ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵛⵓⵍ ⵢ ⵜⵎⵜⵢ ⵏⴰ «ⵎⴹⵏ ⵏⵢⵂⴹⵢⴰ ⴹⴾⵓⵏⵢ ⴾⵜⵏⵓⵏ ⵓⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⵢⵔⵙⵍⵎ ⴶⵔⵓⵜ ⵓⴰ ⴶⵏ ⴹⴰ ⵜⵙⵙⵎⵎ ⵓⵍⵏ ⵢⵓⴰ ⴹⵓⵏ⵿ⵤⵏⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ⵎⴹⵏ ⵓⵏ ⵓⵔ ⵎⵙⵓⴹⵏ ⵔⵜ ⵓⴰ ⵜⵗⵍⵎ ⴹⵢ ⴼⵍⵙ ⵜⵤⴰ ⵍⵓⵆⵏ ⵓⵏ ⵗⵔⴰ ⵓⴰ ⵂⵔⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ⴾⵍⴰ ⴾⵍⵔ ⵔⵜ ⵓⴰ ⵎⵍ ⵏⵀⵢ ⵢⵓⵍ ⴹⵙⵏ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"ⵏⴰ ⵎⵛⵏⴰ 'ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⴹⵤⵙⵏ ⴹⵗ ⴹⵏ ⵏⴹⵏⵜ ⵓⵏ ⵍⴾⵎⵏⵏ ⴹⵤⵤⵀⵗ ⵏ⵿ⴼⵙⵏ ⴼⵍ ⵢ ⵜⵍⴰ ⵓⴹⵏ ⵙⵗⵍⵏ ⵎⴹⵏⵓⵏ ⴹⵛⴾⵓⵏ ⵓⴰ ⴹⵙⵏ⵿ⵤⵎⵍⴰ⵰ ⵙⵏⴼⵍⵍⵗ ⵔⵜⵏ ⵜⵏ⵿ⴾⵍⵏⵏ ⵢ ⵎⵓⴹⵏⵓⵏ ⵙⵙⴶⴰ ⵗⵎⵔⵏⵓⵏ ⵜⵔⴶⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ⵓⵍⴰ ⴹⵤⵤⵀⵗ ⴹⵗ ⴹⵏ ⵓⵏ ⴹⵏ ⵏ⵿ⴼⵙⵏ ⴼⵍ ⵏⵗⵀⴹⵏⵏ ⴹⵜⵏⵗⵀⴹⵏⵏ ⵜⵤⵔ ⵙⵗⵍⵏ ⵓⴰ ⴹⵙⵏ⵿ⵤⵎⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ⴹ ⴶⵗ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴹⵗ ⵌⵏⵓⵏ ⴶⵗ ⵔⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴼⵍ ⵎⴹⵍ ⵏ⵿ⵗⵍ ⵤⵏⵢ ⵜⵔⵗⵓ ⵜⵎ⵿ⵙⵢ ⴾⵓ ⵂⵓ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ⵜⴼⴾ ⴹ ⵜⵎⵜⵢ ⵜⵆⵍ ⵛⵢⵢ⵰ ⵜⵤⵓⵗ ⵜⵍⵜ ⵛⵍⵜ ⵏⵤⵏⵢ⵰ ⵤⵔⴹⵓ ⴹⵢ ⴾⵍ ⵢⵙⴰ ⵏⵤⵍ ⵤⵓⵔⵏ ⵍⵏ ⵍⵈⵔⵎⴰ ⵓⴰ ⵙⵀⴹⴹ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ⵎⵔⵏ ⵢ ⴶⵎⵢⵏ ⴹⵗ ⵎⵍⵢ ⵍⵗⵍⵙ ⴹ ⵜⴶⵔⵓ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ⵢⴰ ⵎⴹⵏ ⵏⵙⵔⵢⵍ ⵙⵙⵎⵜ ⵢ ⵙⵍⵏ ⵓⵏ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵍⵙ ⵎⵙ ⵙ ⴾⵓⵏⵙⴾⵏⴰ ⵎⵛⵏⴰ ⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴹⵔⵜⵏ ⵎⵜⵢⵏⵏ ⴹⵓⵢⴹ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵓⵏ ⵙ ⵜⴾⴼⴰ ⴶⵏⵙⵏ ⴶⵔⵓⵏ ⵙ ⵏ⵿ⵜⴰ ⵙⵏⴼⵔⵏ⵰ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵙⵏⵎ ⴹⵗ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ⵍⵙ ⴹⵢ ⵎⵛⵏⴰ ⴹⵢ ⵙ ⵜⵓⵔⵍⴰ ⴹⵙⴹⵔⴶⵏ ⵜⴶⵏ ⴹⵗ ⴼⵙⵏⵓⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⵈⵜⵙ ⵔⵓ ⵜⴶⵎ ⵎⵏⵜ ⵙⵜⵓⵙⵜⵢⵜⵢ ⵓⴰ ⵜⵜⵙⵙⴶⵎ ⵢ ⵏⵤⵍⵎ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ⵎⵛⵏ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴾⵙ⵿ⵜⴹⵓ ⴹⵗ ⵜⵔⵏⴰ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴼⵍⵙ ⵓⵔ ⵜⵍⴰ ⵎⴾ ⵙ ⵜⵏ⵿ⵜⵜⴼ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ⵀⵜⵏⵜ ⴹⵗ ⵏⴰ ⵏⵀⵢ ⴹⵓⴹ ⵔⵓ \"ⵂⵏⵢⴰ ⵎⵍⵢ ⴹⵜⵢ ⴼⵓ ⵂⴰ ⵗⵍⵏ ⴼⵍ ⴹ ⵓⵔ ⵗⵛⴹⵏ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ⴹⵢ ⴼⵍ ⴼⵍⵓⵙⵏ ⵎⵏⵏ ⵜⴾⵏⴰ ⵜⴹⵓⵜ ⴶⵤ ⵏⵓⵍⵏ ⵓⵍⴰ ⵜⵗⵙⵏⵏ ⵓⵔ ⵏⵎⵙ ⵜⵎⵗⵍⵍ⵿ⵜ ⴹⴰ ⴹ ⵜⴶⵓ ⵜⵎⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ⴹ ⵓⵔ ⵤⴰ ⵜⵢⵗ ⵎⵏⵏ ⴹⵗ ⵍⵈⵔⵜ ⵓⵍⴰ ⴹⵗ ⵜⵢⵗ ⵎⵤⴹⴶⵏⴾ ⵜⵔⴾⵓ ⵜⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ⴾⵢ ⴹⵙⴾⵏⵏ ⵜⵔⵢⵜ ⵜⴰ ⵜⵂⴰ ⵜⵎⴹⵔ⵿ⵜ⵰ ⴹⵜⵙⴼⵍⵓⵙⴰ ⵓⵍⵏ ⵙ ⵜⵙⵆ ⵜⴰ ⴹⵔⴾ ⴶⵗ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ⵎⴹⵔⵢⵏⵏ ⵍⵗ ⵜⵔⵢⵜ ⵏ⵿ⴹⵓⵏⴶⵗ ⵙⵍⵏ ⴹⵗ ⴾⵙⵗ ⵛⴾ ⵏⵎⵔⵓⵏⵏⴰ ⴹⵓⴹ ⵏⵙ ⵀⵜⵓ ⵜⵓⵏⵀⵍⵏ⵰ ⵤⴾⵏⵜ ⵂⵔ ⵤⵍⴹⴰ ⵍⴰ ⴶⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ⵏⵀⵢ ⵎⵙ ⵙⵏ ⴹⵗ ⴼⵍ ⵔⴾⵓⵍ ⵓⴰ ⴼⵍ ⴹⵙⵂⴹ ⵎⵛⵏⴰ ⵏⵙ ⵍⴾⵎ ⴹ ⴶⵓ ⴹⵗ ⵜⵗⵎⵔⵏⵜ ⵢⵏ ⴹⵗ ⵂⵢⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ⴹⵗ ⴹⵢ ⴹⵓⴹ ⵏⵢ ⴹⵜ ⵍⵓⵆ ⵜⵏⴾⵔⴰ ⵏⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵔⵏ ⵙⵍⵏ ⵏ⵿ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵏⴰ \"ⵓⵔ ⴹⵏⵜⵓⵢⴰ ⴹⵗ ⵍⵈⵔⵜ ⵓⵍⴰ ⴹⵗ ⵜⵔⴾⴰ ⵜⵗⵙⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ⵗⵢⵙⴰ ⵤⴰ ⵓⴰ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴶⵔ ⵏⵎⵜⵏ ⵏⴾⵏⵢ ⵏⴶⵢⵜ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ⴹⴾⵍ⵿ⵜⵓ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵜ ⴶⵢ ⴹⵗ ⵗⵍⵏⵜ ⴾⴼⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ ⵏ⵿ⵜⴰ ⵎⵔⵏ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵏⴰ⵰ ⴹⵢ ⵎⵙ ⵔⵜ ⵓⴰ ⵜⵂⵏⵢⵎ ⴹⴰ ⵜⵙⵍⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ⵓⵔⴶⵗ ⵏⵀⵢ ⴹⵓⴹ ⴾⵏ ⵌⵏⵓⵏ ⴾⵍⵔ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵏⵏ \"ⵏⴰ ⵎⵍⵢ ⵎⵛⵏⴰ ⵢⵎⵍⵏⵏ 'ⵗⵎ ⴹⵗ ⵗⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ⴾⵜ ⴹⵢ ⴹ ⵜⴶⵗ ⵤⵏ⵿ⴶⵏⴾ ⴹⵓ ⴹⵔⵏⴾ⵰'\" ");
INSERT INTO ttqt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ⴹⵗ ⴹⵢ ⴾⵏⵏⵜ ⴾⵍⵙⵔⵢⵍ ⴾⵍ ⵎⵙⵏⵜ ⴹⵗ ⵙ ⵗⵢⵙⴰ ⵓⴰ ⵜⵜⵢⵜⵢⵎ ⴼⵍ ⵜⴶⵜⵓⵜ ⵏ⵿ⵜⴰ ⴶⴰ ⵎⵛⵏⴰ ⵎⵍⵢ ⴹⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ⴹⵙ ⵓⵍ ⵓⴰ ⴶⴰ ⵀⵜⵔⵙ ⴹⵏ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⵓⵍⵏ ⵏⵏⵙ ⵏ⵿ⵜⴰ ⴹⵏⵎⵤⵍ ⵓⵏ ⵂⴹⵜⵏⵏ «ⵎⴹⵔⵢⵏⵏⴰ ⵎⵙ ⴹⵏⵗⵍⵤⵎ ⴶⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ⵏⵙⵏ ⵀⵜⵔⵙ «ⵜⵀⵜ⵰ ⴾⵢⵏ ⴹⵗⵓⵏ ⵜⵓⵙⵍⵎⵗⵜ ⴹⵗ ⵎⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵓⵏ ⵜⴶⵔⵓⵎ ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ⵏ⵿ⵜⴰ ⵔⴾⵓⵍ ⵓⴰ ⴶⴰ ⵎⵛⵏⴰ ⴾⵓⵏⵢ ⵙ ⵜⴶⴰ ⴾⵓⵏⵢ ⴹⵂⵢⵓⵏⵓⵏ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⴶⴶ ⵍⵎⵗⵏⴰ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵤⵗⵔⵓ ⵎⵍⵏⵏⴰ ⵎⵛⵏⴰ ⵙ ⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ⵂⵔ ⵔⵓ ⵀⵜⵔⵙ ⵜⴶⵙⵏ ⵜⵍⵈⵜⵀⵜ ⴹⴶⵤ ⵓⵍⵏ ⴶⵏⵙⵏ «ⴶⵤⵜ ⵎⵏⵓⵏ ⴹⵗ ⵢⵜⴹⵏ ⵈⵔⴾⵏⵏ ⵏⵍⵀⵙ ⵓⵏ ⵤⵎⵏ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙⵓⴰ ⵏⴰ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵜⵤⵔ ⵜⵜⵢ ⵜⴹⵓⵜ ⵏⵎⵤⴶⵤⵏ ⵤⵍ ⵓⵏ ⵙⴹⴶ ⵏ⵿ⴾⵔⴹ ⴶⵎ ⵏⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ⵓⵔ ⴶⵎⴹⵏ ⵔ ⵙ ⵜⵗⵔⵢ ⴹⵓ ⵏⵎⵤⵍ ⵎⵙⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴾⵜⵏⵙⵏ ⴹⵔⵓⵏ ⵎⵏ⵿ⵙⵓⵏⵙⵏ ⵜⵤⵏⵏ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⵙⴾⵜⵏ ⵜⴶⵏ ⵛⵓⵜⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ⵜⴾⵏⴰ ⵜⵙⴰ ⵏⵎⵛⵏⴰ ⴶⵤ ⵏⵓⴹⵏ ⴾⵍ ⵏⵎⵤⵍ ⴹⵗ ⵜⴶⵏ ⵙⵍⵆⴹⵔⵜ ⵏⵎⵛⵏⴰ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴶⵜⵏⵏ ⴹⵔⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ⵔ⵿ⵜⵢⵏ ⵎⵤⴶⵤⵏ ⴾⵜⵏⵙⵏ ⴹⵔⵓⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ⵤⵏ⵿ⵤⵏⵏ ⴹⵗ ⵔⵤⵗⵏⵙⵏ ⵜⵤⵏⵏ ⵜⵎⵏⵜ ⵓⵍ ⵓⵏ ⵙⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⴹⵔⵔⵜ ⵏⴾⵢⵏ ⴹⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ⵤⵍ ⴾⵍ ⵜⵎⵏⵢⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵎⵏⴾⵏ ⵙⵓⵏ⵰ ⵜⵤⵏⵏ ⵎⵏ⵿ⵙⵢ ⵓⵏ ⵙⴾⵜⵏ ⴹⵗ ⵏⵏⵙⵏ ⴹⵔⵓⵏ ⴹⵗ ⵎⵏ⵿ⵙⵓⵏⵙⵏ ⴹⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⴹⵜⵤⴹⴾ ⵏⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ⵎⵍⵏ ⵎⵛⵏⴰ ⵙⵗⵎⵔⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⴾⵍ⵰ ⴾ ⵤⵍ ⵛⵜⴰ ⵎⵍⵢ ⵍⵌⵎⵗⵜⵏⵙⵏ ⵙⵢⵜⴹⵏ ⵓⵏ ⵗⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ⵤⵍ ⵢⵏ ⴶⵤⵢ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵢⴹ ⴶⵏ ⵛⵓⵜⵔⵓⵏ ⵛⵏ ⵜⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹⵗ ⴹⵎⵓⵢ ⵍⵙ ⵢⵏ ⴹⵂⵓⵏ ⴹⵀⴹⵏ ⵙⵎⵢ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵙ ⵜⵓⵏⵓ «ⵎⵢ ⵓⴰ ⵂⵙⵢⵏ» ⵜⵓⵙⵏ⵿ⵙⴰ ⴼⵍ ⴹ ⴶⵎⵢ ⵜⴾⵜⵢ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵜⵜⴶⵤⵏⵏ⵰ ⴾ ⵤⵍ ⵜⵓⵙⵏ⵿ⵙⵓ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ⵙ ⵏⵢ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵀⴾⵏ ⵢⴶⵤ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵏⵜⵏ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ⴹⴾⵓ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵙⵙⵓⴹ ⵏⵙ ⵀⵜⵔⵙ «ⵙⵓⴹ ⴹⵗⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ⴾⵏⴰ ⴹⵗⵙⵏ ⵙⵓⴹ ⴶⴰ ⵜⵎⴰ ⵏⴹ ⵜⴾⴼⵏ ⵔⵜ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ⵜⵤⵔ ⵏⵙ ⵀⵜⵔⵙ «ⵔⵗ ⵓⵍⴰ ⵤⵔⴼ ⵓⵔ ⵜⵏⵍⵗ ⵎⵛⵏ ⴾⵢⴾⴼⴰ ⵓⴰ ⵍⵗ ⵙ ⵜⵔⵏⴰ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵓⵏ ⵗⵔⵎ ⵏⵤⵔⵜ ⵀⴹⴹ ⵌⵓⵏ⵿ⴾⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ⵜⵤⵔ ⵀⵤ ⵀⵜⵔⵙ ⴼⵙⵏⵜ ⵓⵏ ⵗⵍ ⵙⵀⴹⴹⵜⵓ⵰ ⴹⵔⵏ⵿ⴹⵓ ⴹⵔⵏⵜ ⴹⵜⵍⵤⵏⵜ ⵍⵓⵆ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ⵏⴹⵓ ⵤⵍⵜ ⵀⴹⴹ ⵌⵓⵏ⵿ⴾⵜ⵰ ⴹⵓ ⴹⵔⵙⵏ ⴶⵤⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵌⵓⵏ⵿ⴾⵜ ⵜⴶⴹ ⴼⵍ ⵜⴹⵓⵜ ⵎⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ⵂⵏⵢⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⴾⵍ ⵌⵓⵏ⵿ⴾⵜ ⵎⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ⵙ ⴹⵏⴶⵔⵏ ⵙ ⵏ⵿ⵜⴰ ⵜⵗⵎⵏ ⵗⵔ ⵎⵢ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵙ ⵜⵓⵏⵓ «ⵎⵢ ⵓⴰ ⵂⵙⵢⵏ» ⵜⵏ⵿ⵙⵢ ⵂⴶⵏ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⴰ ⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ⴶⵍⴰ ⵍⵙ ⵓⴰ ⵜⵓⵤⵤⵢⵏ ⴹⴰ ⵍ⵿ⵜⵗ ⴹⵗ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ⵰ ⵌⵓⵏ⵿ⴾⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⴼⵍⵜ ⵙ ⵜⵓⵏⵓ «ⵜⴰ ⵏ⵿ⵙⵍⵎⵏ» ⵙ ⵙⵔⵙⵏ ⴹⵜⵤⵍ ⵜⵎⵜⵢ ⴾⵜⵏⵜ⵰ ⴶⴰ ⵓⵏ ⵙⵢⵜⴹⵏ ⵙⵎⴾⵍⵍ ⵍⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ⵙ ⵏⵢ ⵀⵜⵔⵙ ⵓⵏ ⵏⴰ ⵢⵢⵜⴹⵏ «ⵎⴹⵏ ⵏⵙⵔⵢⵍ ⵎⴼⵍ ⴾⵏⴰ ⵙⵔⵓⵏ ⵓⴰ ⵙⵎⴾⵍⵍ⵰ ⵜⴶⵔⵎ ⴹⵗⵏⴰ ⵛⵜⵓⵏ ⵜⴶⵎ ⴹⵗⵏⴰ ⵙⵓⴹ ⵏⵙ ⵏⴾⵏⵢ ⵤⵤⵢⵏ ⵍⵙ ⵓⴰ ⵙ ⴼⵔⴶⵜⵏⵏⴰ ⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵎⴹⵗ ⵏⵤⵤⵢⵜⵓ ⴼⵍ ⵛⴹⵜ ⵏ⵿ⵜⴾⵙⴹⵏⵏⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ⵎⵍⵢ ⵏⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹⵢⵆⵀ ⵎⵍⵢ ⵏⵎⵔⵓⵏⵏⴰ ⵏ⵿ⵜⴰ ⴾⴼⵏ ⴾⵍⵏⵜ ⵗⵢⵙⴰ ⵍⵈⵔⵎⴰ⵰ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⴶⵏ ⴹⵗ ⴼⵙⵏ ⵜⵏ⵿ⴾⵔⵎ⵿ⵜⵓ ⴹⵜ ⵀⵍⵜⵙ ⵙⵏ⵿ⵜⴰ ⴾⵙⵏⵜ ⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ⵓⵍⴰ ⵜⵏ⵿ⴾⵔⵎ ⵍⵗⴹⵍ ⴹⵢ ⵏⵎⵤⴹⴶ ⵜⴶⵎⵢⵎ ⴹⵓⵏ⵿ⴹⵜⵓⴾⵙ ⵍⵙ ⵏⵎⴶⵢ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ⵜⴶⵎ ⵎⵏ ⵏⵓⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴾⵔ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵏⴾⵏⵢ ⵏⴶⵢⵜ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ⵤⴶⵤⵏⵏⴰ ⵙ ⵜⵔⵏⴰ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⴾⴼⵏ ⵍⵙ ⵜⵂⵏⵢⵎ ⴹⴰ ⵜⵤⴹⵢⵎ⵿ⵜⵓ ⵛⵗⵔⴹⵏⵜ⵰ ⵍⴾⵏ ⵙ ⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⴾⴼⵏ ⵍⵙ ⴹⵢ ⵛⵗⵔⴹⵏⵜ ⴾⵍ ⴹⵜⵓⵏ ⴾⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵙⵏⵗ ⵙ ⵍⵌⵂⵍ ⴹⵗ ⵜⴶⵎ ⴹⵢ ⴾⵓⵏⵢ ⴹⵎⵤⵔⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ⵎⵛⵏ ⵙⵏⵜ ⵙ ⵔⵓ ⵙ ⵎⵍ ⵎⵛⵏⴰ ⴹⵗ ⵎⵓⵏ ⵏⵏⵀⵜⵏ ⴾⵍ ⵙ ⵍⵎⵙⵈ ⵍⵤⵎ⵿ⵜⵓ ⴹ ⵏⵢ ⵍⵗⵤⵀ ⵎⵔⵏ ⵙⵏ⵿ⴹⴰ ⴹⵢ ⵙ ⵜⵎⵓⵜ ⵜⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ⴹⵗ ⴹⵢ ⵜⵀⵜ ⵜⴾⵙⴹⵎ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵎⵙ ⵀⴾⴹⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ⵤⵤⵀⵜⴹⵓ ⴼⵍⵓⵏ ⵛⵎⵔⵏ ⵏ⵿ⵜⵙⵙⵎⵜ ⵙⵗⵍⴹⵓ ⵍⵎⵙⵈ ⴹⵓⵏⵙⵏⴼⵔⵏ ⴹⵜ ⵍⵓⵆ ⵍⵎⵗⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ⵍⵤⵎ⵿ⵜⵓ ⴹ ⵆⵎ ⴹⵗ ⵌⵏⵓⵏ ⵂⵔ ⴹⵙⵓ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵤⵙⵗⵍ ⵎⵛⵏⴰ ⵔⵜ ⴾⵍ ⵎⴾⵏⵜ ⵓⴰ ⵤⵔⵏ ⵎⵍ ⵓⵏ ⵔⵓ ⵙ ⵎⵓⵏ ⵏⵏⵀⵜⵏⵜ ⴹⵢ ⵤⴹⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ⵓⵍⴰ ⵏⴰ ⵏⵀⵢ ⵎⵙⴰ \"ⵎⵛⵏⴰ ⵎⵍⵏⵓⵏ ⴹⵓⵏ⵿ⴹⵙⵏⴼⵍⵍ ⵢⵏ ⵏⵀⵢ ⵏⵛⵍⵜⵏ ⴹⵗ ⵎⴹⵔⵢⵏⵓⵏ ⵎⵔⵏ ⴹ ⵜⵙⵙⵎⵎ ⵢⵓⴰ ⴹⵓⵏ⵿ⵤⵏⵓ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵀⵔⴹⴶ ⵢⵏⵀⵢ ⵓⴹⵢ ⴹ ⵜⵓⴾⵙ ⴹⵗ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ ⵂⵍⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ⵏⵀⵜⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵀⵤⵏ ⵗⵔ ⵏⵀⵢ ⵙⵎⵓⵍ ⴹⵓⵏ ⵜⵤⵔⵢⵏⵏ ⴾⵜⵏⵙⵏ ⵎⵍⵏ ⵔⵜ ⵓⴰ ⴶⵏ ⴹⵗ ⴹⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ⴾⵓⵏⵢ ⵎⵙⵏ ⵎⴾⵙⴰ ⵏⵏⵀⵜⵏ ⵓⵏ ⴹⵏ ⵜⴾⵙⵎ ⴹⵗ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⵓⴰ ⴹⴾⵍ ⵎⵛⵏⴰ ⵢ ⵎⵔⵓⵏⵓⵏ ⵙ ⵏⴰ ⵢⵀⵔⵂⵎ \"ⵜⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴾⵍ ⴹ ⴶⵔⵓⵏⵜ ⵍⵀⵔⴾⴰ ⵙⵙⵀⵀ ⵏⵤⵔⵢⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ⴾⵓⵏⵢ ⵙ ⴹⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⴾⵍⵏⵜ ⵗⵢⵙⴰ ⴹⵗ ⵜⵤⵔⵜ ⵙⴾⵓⵏ⵿ⵜⴹ ⴼⵍ ⴾⵓⵏⴾⴼⵓ ⵍⵀⵔⴾⵏⵜ ⴾⵙ ⴾⵢⵏ ⴹⵗⵓⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵛⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵢ ⵜⵎⵜⵢ ⵙ ⴼⵍⵙⵏ ⵂⵏ ⵍⵎⵎⵏ ⴹⵓⵏ ⴹⵎⵤⵔ ⵏⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵤⵏⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵙⴹⵙⵢⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ⵂⵏ ⵍⵂⵎ ⵏⵙⵙⵗⵔⵢ ⵓⴰ ⵜⴶⵏ ⵜⵎⵜⵢ ⵎⵍⵏ ⵙ ⴹⴹ ⵤⵎⵙ ⵗⵢⵙⴰ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⵏⵎⵜⵏ ⴹⴰ ⴹⵗⵙ ⴹⵏ⵿ⴾⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ⵙⵜⵔⵎⵙⵏ⵿ⵜⵏ ⴶⵏ⵿ⵜⵏ ⴹⵗ ⴾⵙⵓ ⵂⵔ ⴼⵓ ⴼⵍⵙ ⵂⴹ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ⵎⵛⵏ ⵢⴰ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⵓⵏ ⵙⵍⵏⵏ ⵢ ⵜⵍⵈⵜⵀⵜ ⵜⵏ ⵜⵤⵔ ⵆⵍⵏ ⵎⵤⴶⵤⵏ ⴹⴶ ⵏ⵿ⵙⵎⵙ ⴶⵎ ⵏⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ⵙ ⴼⵓ ⵎⵏⵢⵏ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵎⵗⵔⵏⵙⵏ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ⵂⵏ ⵈⵏⵏ ⵓⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⴾⵢⴼ ⴹⵢⵈⵢⴰ ⴹⵍⵙⴾⵏ⵿ⴹⵔ ⴹⵢⵜⴹⵏ ⵏⵗⵢⵓⵏ ⵏⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ⵙⵀⴹⴹⵏ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⴶⵔⵙⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵏ ⵏⵏⵙⵏ «ⵎⴰ ⵍⵏ ⵜⵔⵏⴰ ⵎⴹⵗ ⵙⵎ ⵓⵙ ⵜⴶⵎ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ⵜⵤⵔ ⵏⵙⵏ ⵀⵜⵔⵙ ⴹⴾⵔⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ «ⵢⴰ ⵎⵤⵔⵏ ⵏ⵿ⵜⵎⵜⵢⵏⵏⴰ ⴹⵎⵗⵔⵏ ⵏⵙⵔⵢⵍ ");
INSERT INTO ttqt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ⵤⵍⴹⴰ ⵏⵀⴹⴹ ⴹⵜ ⵙⴶⵓⵔ ⵓⴰ ⴼⵍⵙ ⵏⴶⴰ ⵎⵤⵍ ⵍⵗⵏ ⵎⵙⵏ ⵜⵍⵍ⵿ⵜ ⵢⵓⴹⵏ ⵀⴹⵏⵏ ⵎⵔⵏ ⵍⵤⵎⵏⴰ ⴹ ⵏⵎⵍ ⵎⴾ ⵓⵙ ⵜⵓⵤⵤⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ⵙⵏⵜ ⵤⴰ ⴾⵜⵏⵓⵏ ⴾⵓⵏⵢ ⴹⵢⵜⴹⵏ ⵏⵙⵔⵢⵍ ⴾⵍ ⵙ ⵍⵙ ⵓⴰ ⵀⴹⴹⵏ ⴹⵜⵓⵏ ⴹⴰ ⵓⵔ ⵍⴰ ⵎⵍⴹ ⵓⵍⵢⵏ ⵜⵔⵏⴰ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵓⵏ ⵏⵤⵔⵜ ⵜⵤⵤⵢⵏ ⵓⴰ ⵜⵜⵢⵜⵢⵎ ⴼⵍ ⵜⴶⵜⵓⵜ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ \"ⵜⵂⵏ⵿ⵜ ⵜⴰ ⴹⵏ⵿ⵜⴶⵔⵎ ⴾⵓⵏⵢ ⵓⵏ ⵎⴾⵔⵙⵏ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵜⵆⵍⵜ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⴾⵀⵍⵜ ⵂⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ⵏ⵿ⵜⴰ ⵗⵙ ⵗⵍⵙⵏ ⵎⵔⵏ ⵓⵔ ⴾⴼⴰ ⵎⵛⵏⴰ ⴶⵔ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵙⵎ ⵏⵓⴹⵏ ⵢⵏ ⵓⵙ ⵤⴰ ⵏⵗⵍⵙ ⵔ ⵓⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ⵙ ⵏⵢⵏ ⵜⵂⵍⵜ ⵏⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵓⵍ ⵙⵎⴾⵍⵍ ⵙⵔⵙⵏ ⵓⵏ ⴼⵍⵙ ⴶⵔⵏ ⵙ ⵍⵌⵂⵍⵏ ⵎⵙⵏ ⵙⵏⵏ ⴹⵗ ⵙ ⵢⵜⴹⵏ ⵎⵙⵏ ⵙ ⴾⵍⴰ ⵜⴹⵓⵏ ⴹⵗⵢⵙⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⵙ ⴼⵔⴶⵏ ⴹⵙⵏ⵿ⵜⵏⵏ ⴼⵍⵙ ⵂⵏⵢⵏ ⵍⵙ ⵓⴰ ⵜⵓⵤⵤⵢⵏ ⵀⴹⴹ ⴹⵏ ⵗⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ⵜⵤⵔ ⴾⵙⵏ⵿ⵜⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⴹⵗ ⵎⵏⵢ ⵙⴶⵓⵔ ⵎⵔⵏ ⴹ ⵜⵏⵎⴶⵏ ⵛⵏⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ⴶⵏⵏ «ⵎⴰ ⵤⴰ ⵏⴶⵓ ⵢⵢⵜⴹⵏ ⴰ⵰ ⵍⴾⵏ ⵙ ⵏⵢⵏ ⴾⵍⵢⵔⵙⵍⵎ ⴾⵍ ⵜⵍⵎⵗⵌⵌⵜ ⵤⵓⵔⵜ ⵜⴰ ⴶⵏ ⵎⵔⵏ ⵓⵔ ⵏⴼⵔⴶ ⵙⵀⵂⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ⵎⵛⵏ ⵢⴰ ⴼⵍ ⴹ ⵓⵔ ⵓⵤⵓⵤⵏ ⵙⵍⵏ ⵏⵓⵏ ⴹⵗ ⵜⵎⵜⵢ ⴾⵍ ⴹⵗ ⴹⵢ ⴶⵓⵜⵏⴰ ⵢⵙⵏ ⵛⵙⴾⵙⴹⵓⵏ ⴼⵍ ⴹⵓⵔⵍⵙⵏ ⴹⴾⵍ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⴹⵜ ⵓⴹⵏ ⵓⵍⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ⵜⵤⵔ ⵙⵙⵗⵔⵏ⵿ⵜⵏ⵿ⴹⵓ ⵔⵗⵎⵏⵙⵏ ⴼⵍ ⴹⵓⵔⵍⵙⵏ ⴹⴾⵍ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵓⵍⴰ ⴹⵗ ⵙⵙⵗⵔⵢ ⵏⵔⵜ ⵜⵆⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ⵎⵛⵏ ⵏⵙⵏ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ «ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵎⴰ ⵜⵏⵎ ⵎⵏⵢ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⵓⴰ ⵗⴹⵏ ⴹⵜ ⵎⵛⵏⴰ ⵓⴾ ⵀⵔⴹⴶ ⵢⵓⵏ ⵎⵗ ⵀⵔⴹⴶ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ⵏⴾⵏⵢ ⵤⴰ ⵓⵔ ⵏⴼⵔⴶ ⴹ ⵏⵢⵓ ⵎⵍ ⵏⵔⵜⵏ ⵓⵏ ⵏⵏⵢ ⴹⵓⵏ ⵙ ⵏⵙⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ⵍⵙⵙⵏ ⵙⴶⵓⵔ ⴶⵢ ⵏ⵿ⵜⵙⴾⵙⴹⵓⵏ ⵎⵔⵏ ⵢⵏ⵿ⵜⵏ ⴹ ⵓⵔ ⴶⵔⵓⵏ ⵙⵔⵓ ⴼⵍ ⵜⵏⵓⴹⵀⵏ⵰ ⴶⵏ ⵓⵏ ⴼⵍ ⴹⵍⵍ ⵏⵢⵜⴹⵏ ⴼⵍⵙ ⵢⵜⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵜⴶⵏ ⵢ ⵎⵛⵏⴰ ⵜⵎⵍⵏ ⴼⵍ ⵓⴰ ⴶⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ⵏ⵿ⵜⴰ ⵍⵙ ⵓⴰ ⴶⵏ ⵜⵎⵤⵢⵜ ⵜⵎⵙⵜ ⵜⵍⵎⵗⵌⵌⵜ ⵜⵏ ⵍⵏⵜ ⴶⵔⵏ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ⵜⵓⵢⴰ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵗⵙ ⴾⵏ ⵎⴹⵓⵏⵙⵏ ⵙⵗⵍⵏⵙⵏ ⵓⴰ ⴹⵙⵏⵏⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵗⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ⵙ ⵙⵍⵏ ⵢ ⵙⵍⵏ ⵓⵏ ⵌⵌⵢⵏ ⴹⵗ ⵜⵓⵜⵔⵢ ⵜⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵏⵏ ⵙⴼⵍⴰ «ⵢⴰ ⵎⵍⵢ ⴾⵢ ⴹⵈⵍⴾⵏ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⴹⴶⵔⵓⵏ ⴹⵓⴰ ⵜⵏⵂⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ⴾⵢ ⵏⵏ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵎⵢ ⵏⵎⵔⵓⵏⵏⴰ ⴾⵍⵏⴾ ⴹⵓⴹ \"ⵎⴼⵍ ⵗⵛⵛⵜⵏⵜ ⴹⵓⵍⵜⵏ ⵏⴹⵏⵜ ⵜⴶⵏⵜ ⵜⵎⵜⵓⵏ ⵛⵏⴹⵏ ⵓⵔ ⵏⵏ⵿ⴼⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ⵀⴹⴹⵏ ⵎⵏⴾⵍⵏ ⵏⴹⵏⵜ ⴹⵓⵏ ⴹⵗ ⵎⵤⵔⵏ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⴼⵍ ⴹ ⵎⴹⵏ ⵎⵍⵢ ⴹⵍⵎⵙⵈⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ⴹ ⵍⴾⵏ ⵙ ⵗⵔⵎ ⵓⴰ ⴹⴰ ⴹⵗ ⵎⵏⵢ ⵂⵔⴹ ⴹⴼⵏ⵿ⵙ ⵀⵍⵜⵙ ⵏ⵿ⵜⵏⵢ ⴹⵜⵎⵜⵓⵏ ⵛⵏ ⵏⵤⵍⵎ ⴹⵛⵏ ⵙⵔⵢⵍ ⵎⴹⵏ ⵗⵢⵙⴰ ⵎⵙⵏ ⴾⵍⵏⴾ ⵤⴹⴶⵏ ⵓⴰ ⵜⴶⵗ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ⵎⵙ ⵓⵏ ⴶⵢ ⵏⵔⵜ ⴾⵜⵏⵜ ⵓⵙ ⵜⵈⵜⵙⴰ ⴼⵍ ⴶⵏⵜ ⴹⵜ ⵍⵓⵆ ⵙ ⵜⵔⵏⵏⴾ ⴹⵜⵔⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ⵎⵔⵏ ⵎⵔⴹⴰ ⵎⵍⵢ ⵙⵓⴹ ⴹⵗ ⵜⵙⴾⵙⴹⵓⵏ ⵛⵏ ⴹⵏⵜⴶⵏ ⵜⵤⵔ ⵜⵙⵂⵍⵗⵏⴰ ⵓⵍⵏ ⵏⴾⵏⵢ ⵏ ⴾⵍⵏⴾ ⵎⵍ ⵏⵓⵍⵏⴾ ");
INSERT INTO ttqt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ⵜⵍⵍⵗⵏⴰ ⵙ ⵜⵔⵏⴰ ⵏⴼⵙⵏⴾ ⴼⵍ ⴹ ⵏⵤⵤⵢ ⵢⵜⴹⵏ ⵏⴶⵓ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴹⵔⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⴾⵍⵏⴾ ⵤⴹⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ⵙ ⵗⵔⴹⵏ ⵜⵓⵜⵔⵢⵏⵙⵏ ⵏⴶⵢⵏⴶⵢ ⴹⴶ ⵓⴰ ⴹⵗ ⴹⵓⵏ ⴹⵏⵢⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵜⵏⵙⵏ ⵜⵤⵔ ⴹ ⵎⵍⵏ ⵓⵍ ⵏⵎⵛⵏⴰ ⵛⵢ ⵓⵍⴰ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ⵍⵌⵎⵗⵜ ⵜⵏ ⵎⵤⴶⵤⵏ ⴾⵜⵏⵜ ⵜⵏⵎⵏⴾ ⵜⵎⵙ ⵔⵜ ⵢⵏ⵿ⴹⴰ⵰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴶⵏⵏ ⵓⴰ ⵍⴰ ⵏⵜ ⵗⵙⵏⵜ ⴾⵍⵔ ⴹⵔⵓⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ⵜⴶⵢⵏ ⵏⵎⵤⵍ ⵙ ⵜⵔⵏⴰ ⵤⵓⵔⵜ ⴼⵍ ⵜⵏⴾⵔⴰ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴾⴼⵏ ⴹⵗ ⵎⵛⵏⴰ ⴾⵜⵏⵙⵏ ⵔⵈⵎⵜⵏⵜ ⵙⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ⵍⵌⵎⵗⵜⵏ ⵓⵔ ⵜⵜⵂⴰ ⵢ ⴹⵔⵔⵏ ⵙ ⵓⵍⴰ ⴼⵍⵙ ⵓⵏ ⴹⵗⵙⵏ ⵍⵏⵏ ⵏⵏ ⵎⴹⵗ ⵛⵓⴶⵙ ⵤⵏ⵿ⵤⵏ⵿ⵜⵏⵏ ⵜⵓⵢⵏ⵿ⴹⵓ ⵜⵎⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ⵂⴾⵏ⵿ⵜⵓ ⵢ ⵏⵎⵤⵍ ⵎⵔⵏ ⵜⵓⵤⵏ ⴶⵔ ⵎⵤⴶⵤⵏ ⵓⵍⵏ ⴹⴶⵔⵏⵙⵏ ⵙⵓⴰ ⴹⵔ ⴶⴹⵏⵜ ⵜⵎⵗⵜⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ⵓⵏ ⴹⴰ ⴶⴰ ⵍⵙ ⵢⵏ ⴶⵏ ⵢⵙⴼ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⴾⵍⵀⵢ ⵏⴾⵍ ⵏⵆⵀⵔⵙ⵰ ⵏ⵿ⵜⴰ ⵙ ⴶⵏ ⵏⵎⵤⵍ ⵜⵙⵎⴹⵆ ⵀⵔⵏⵀⵙ ⵍⵎⵗⵏⴰ «ⵏⵍⵎ ⴼⵍ ⵎⵏ» ");
INSERT INTO ttqt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ⵤⵏ⵿ⵤⵏ ⵜⵓⴶⵙ⵿ⵜ ⵜⵂⵜ ⵜⵍⵏⵜ ⵓⵢⴹⵓ ⵜⵎⵏⵜ ⴾⴼⵢ ⵢ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ⵍⵢ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵏⵏⵢⵙ ⴹⵏⵤⵏ⵿ⵤⵏ ⵏ⵿ⵜⴰ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⵙⴼⵔⴰ ⵜⵓⴶⵙ⵿ⵜⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ⵜⵤⵔ ⵏⵎⵔⴹⴰ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⴼⵍ ⴹⵏⵜⴼ ⵔⵜ ⴹⵗ ⵤⵔⴼ ⵓⴰ ⴹⵏ⵿ⵜⵏ⵿ⵤⴰ ⵓⵢⴹⵓ ⵓⴰ ⵂⴹⵏ ⴾⴼⵢ ⵢ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ⵏⵙ ⵀⵜⵔⵙ «ⵏⵏⵢⵙ ⵎⴼⵍ ⵙ ⵜⵢⵗ ⵛⵢⵜⵏ ⴶⴰ ⵢⵓⵍⵏⴾ ⴶⵤ ⴶⴹⵏ ⴹⵓⴰ ⵓⴹ ⴹⵗⴾ ⴹ ⵜⴶⴰ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵀⵂⵓ ⵙⴹⴼ ⵓⴰ ⴹⵏ⵿ⵜⴶⵗ ⵔⵜ ⴹⵗ ⵤⵔⴼ ⵓⴰ ⴹⵏ⵿ⵜⵏ⵿ⵤⴰ ⵜⵓⴶⵙ⵿ⵜⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ⵂⵔⵓⴰ ⵜⵜⵏⵓⵔ⵿ⵜⵤⵏ⵿ⵤⴰ ⵓⵔⴶⵗ ⵜⵍⵏⴾ ⵜⵂⴰ⵰ ⵙ ⵜⵜⵏ⵿ⵜⵤⵏ⵿ⵤⴰ ⴹⵗ ⵓⵔⴶⵗ ⵤⵔⴼ ⵓⴰ ⵜⵜⵏ⵿ⵜⵤⵏ⵿ⵤⴰ ⴾⵢ ⵜⴼⵏ ⵜⵏⵜⵏⵜ⵰ ⴹⵗ ⴹⵢ ⵎⴼⵍ ⵜⵙⵎⵔⴾⵙⴰ ⴹⵗ ⵓⵍⵏⴾ ⴶⵢ ⵏⵎⵤⵍ ⴶⴹⵏ ⴹⵓⴰ⵰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⵙ ⵜⴶⵗ ⵀⵂⵓ ⴾⵍⵔ ⵎⵛⵏⴰ ⵙ ⵜⵜⴶⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ⵙ ⵙⵍⴰ ⵏⵏⵢⵙ ⵢ ⵀⵜⵓ ⵜⵏ ⴼⵜⵆⵜ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ⵜⴶⵤ ⵜⵙⴰ ⵤⵓⵔⵜ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ⵜⵤⵔ ⵙⵏ⵿ⵜⴹⵓ ⵎⴹⵏ ⵏⵎⵓⴹⵏ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵛⴼⵜ ⴶⵍⵏ ⴹⵔⵙ ⵏⵀⵍⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ⴹⴶ ⵏ⵿ⴾⵔⴹⵜ ⵙⵗⵜⵏ ⴹⴼⵔ ⵓⵏ ⵜⵙⴹⵓ ⵜⵏ⵿ⵜⵜ ⵏⵏⵏⵢⵙ ⵓⵔ ⵜⵙⵏ ⴼⵍ ⵓⴰ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ⵙⵙ⵿ⵜⵏ⵿ⵜⵜ ⵀⵜⵔⵙ ⵏⵙ «ⵙⴼⵔⴰ ⵎⵍⵢ ⵓⴾ ⵜⵓⴶⵙ⵿ⵜⵏⵓⵏ ⵤⵔⴼ ⵓⴰ ⵜⵜⵏ⵿ⵜⵤⵏ⵿ⵤⵎ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⴾⵜⵏⵜ⵰» ⵜⵏⵙ «ⵓⵍⴰ ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ⵜⵤⵔ ⵏⵙ ⵀⵜⵔⵙ «ⵎⵏⵎⴾ ⵙ ⵜⵏⵎⵏⴾⵎ ⴼⵍ ⴶⵢ ⵏ⵿ⵜⵔⵎ⵿ⵜ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵙⵙⵎ ⵎⴹⵏ ⵓⵏ ⴹⵏⵏⵀⵍⵏⵏ ⵍⵙⵏⵎ ⵍⵏ ⴹⵜ ⵎⵢ ⵏⵂⵏ⵰ ⴾⵎⵓⵢⵏ ⴾⵎ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ⵜⴼⵜⵆⵜ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵗⵔ ⴹⵔⵏ ⵏⵀⵜⵔⵙ ⴶⵎⴹⵏ⵿ⵜⵜ ⵎⵏ⵰ ⴶⵤⵏ⵿ⴹⵓ ⵎⴹⵏ ⵓⵏⴹ ⵏⵎⵓⴹⵏ ⴰ ⵙⵏ⵿ⵜⵜⴹⵓ ⵓⵔ ⵜⴹⵔ ⵓⵢⵏ⵿ⵜⵜ ⵏⵀⵍⵏ⵿ⵜⵜⵏ ⴹⴶⵎⴰ ⵏⵍⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ⵓⵢⴹⵓ ⵓⵏ ⵙ ⵜⴶⵤ ⵜⵙⴰ ⵍⵀⵙⵜ ⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵍⵏⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ⵜⴶⵏ ⵏⵎⵤⵍ ⵜⵍⵎⵗⵌⵌⵜⵏ ⴶⵜⵏⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵔⵜⵏ ⴶⵜⵏⵏ ⵙⵎⴾⵍⵍⵏⵏ ⴹⵗ ⵢⵜⴹⵏ⵰ ⵜⵎⵏⵢⵏ ⴼⵓ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⴾⵜⵏⵙⵏ ⴹⵓ ⵜⴼⵍⴰ ⵏⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵙ ⵜⵓⵏⵓ «ⵜⴰ ⵏ⵿ⵙⵍⵎⵏ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ⵙⵗⵎⵔⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⵎⵛⵏ ⵓⵔ⵿ⵜⵍⴰ ⵢ ⵂⵍⵏ ⵜⵏⵏⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⵜⵢⵏ ⵙⵢⵜⴹⵏ ⴾⵏⵏⵏ ⴶⵜ ⴶⵏⵏ ⴹⵗ ⵎⴹⵏ ⴹⵜⴹⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ⵂⵔ ⵙ ⵜⵎⵓⵢⵏ⵿ⴹⵓ ⵎⵔⵏⵏ ⵜⵓⵙⵏ⵿ⵙⵏ ⴹⵗ ⵜⵙⵜⵏ ⵎⴹⵗ ⵛⵙⵍⵜⵏ ⴼⵍ ⴼⵢ ⵏ⵿ⵜⵔⵢⵏ ⵏⵢⵔⵙⵍⵎ ⴼⵍ ⴹⵏ⵿ⵜⵓⴹ ⴾⴹⵗ ⵜⵍⵢ ⵏⵀⵜⵔⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⵙ ⴹⵍⵎ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ⵜⵤⵍⵏ⵿ⴹⵓ ⴹⵗ ⵢⵜⴹⵏ ⴾⵏⵏⵏ ⴶⵜ ⵏ⵿ⵗⵔⵎⵏ ⵓⵏ ⵂⵤⵏⵏ ⵢⵔⵙⵍⵎ ⵙ ⵢⵔⵙⵍⵎ ⵓⵢⵏ ⵎⵔⵏⵏⵙⵏ ⴹⵢⵜⴹⵏⵙⵏ ⵓⵏ ⵙⵔⵏⵏ ⴾⵍⵙⴼ⵰ ⴾⵜⵏⵙⵏ ⴹⵗ ⵜⵓⵤⵤⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ⴶⵤⵏⵜ ⵜⵙⵎⵜⵏ ⵍⵀⵙⵏⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵗⵎⵜⵏⵜ ⵏ⵿ⵜⴶⵢⵜ ⵜⵏ ⵙⴹⵙⵢⵜⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ⵜⵤⵔ ⵏ⵿ⴾⵔⵏ ⵙⵜⵔⵎⵙⵏ ⵏⵎⵤⵍ ⴶⵏ⵿ⵜⵏ ⴹⵗ ⴾⵙⵓ ⴹⵜ ⵓⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ⵎⵛⵏ ⵙⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵂⴹ ⵍⵎ ⵛⵙⵂⵔ ⵏ⵿ⴾⵙⵓ ⴾⵙ⵿ⵜⵏ⵿ⴹⵓ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«ⴾⵓⵜ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵎⵍⵎ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⴾⵍ ⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵢⵏⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ⴶⵏ ⵏⵎⵤⵍ ⵓⴰ ⴹⵙⵏⵜⵓⵏⵏ ⵏ⵿ⵤⵢⵏ ⵙⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵗⵙ ⵙⵙⵗⵔⵏ ⵢⵜⴹⵏ⵰ ⵙ ⴹⵙⴰ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⵗⵎⵜⵏⵜ ⵙⵙⵗⵔⵏ⵿ⴹⵓ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵍⵎⵗⵏⴰ ⵗⵎⵔⵏ ⴾⵍ ⵓⵏ ⵎⵙⵏⵏ ⵛⴶⵜⵓⵏ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵎⵔⵏ ⵙⴶⵎⵢⵏ ⵏⵎⵤⵍ ⵙ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ⵙⵏⵏ ⵎⵛⵗⵍⵏ ⵓⵏ ⵜⵏⴶⵎⵢⵏⵏ ⵂⵏ ⵏ⵿ⴾⵙⵓ ⵎⵛⵏ ⵓⵔ ⵜⵏⵏⴶⵤⵏ ⴹⵗ ⴾⵙⵓ ⵜⵤⵔ ⵆⵍⵏ ⴶⵏ ⵙⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ⵏⵏ «ⵏⵙⵏ ⴾⵙⵓ ⴾⵜⵏⵜ ⵜⵎⵏ⵿ⵜⵎⵜ ⵀⴹⴹⵏ ⵙⵌⵜⵏ ⵓⵏ ⵜⴶⵤⵏⵏ ⴹⵜ ⵎⵓⵏⵜ ⵎⵛⵏ ⵙ ⵏⵍⵎ ⵜⵙⵂⵔ⵿ⵜ ⵏ⵿ⴾⵙⵓ ⵓⵔ ⴹⵗⵙ ⵏⵙⴰ ⵓⴹⵏ ⵓⵍⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ⵙ ⵙⵍⴰ ⴾⵀⵜⵏ ⵏ⵿ⵙⵌⵜⵏ ⵓⵏ ⵜⴶⵤⵏⵏ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵢ ⵙⵍⵏ ⵓⵏ ⴹⵏ ⵆⵏⵏ ⵗⴼⵓⵏⵙⵏ ⴹ ⵙⵎⴹⵔⵏⵏ ⴹⵗ ⵓⴰ ⵤⵆⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ⵂⵏ ⵜⵏ ⴹⴰ ⵙ ⵜⵏ⵿ⴹⵙⴰ ⵓⴹⵏ ⵏⵙⵏ «ⵙⵙⵎⵜ⵰ ⵎⴹⵏ ⵓⵏ ⵜⴶⵎ ⴹⵗ ⴾⵙⵓ ⵀⴹⴹⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵙⵗⵔⵏ ⴹⵗⵙ ⵜⵎⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ⵜⵤⵔ ⴶⵍⴰ ⴾⵀⵜⵏ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹⵓ ⴹⵙⵌⵜⵏⵜ ⵀⵤⵏ⵿ⴹⵓ ⵏⵎⵤⵍ ⵎⵛⵏ ⵓⵔ ⵜⵏⴹⵙⵏ ⴼⵍⵙ ⴾⵙⴹⵏ ⵙⵔⵙⵏ ⴹⵜⴶⴹ ⵜⵎⵜⵢ ⵏ⵿ⵜⵏⵢⵏ ⴹⴰ ⵜⵏ⵿ⵗⵏ ⵙ ⵤⵀⵓ ⵏ⵿ⵜⴶⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ⵙ ⵜⵏ⵿ⴹⵓⵢⵏ ⵤⵤⴾⵏ⵿ⵜⵏ ⴹⵜ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵜⵤⵔ ⵙⵙ⵿ⵜⵏ⵿ⵜⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ⵏⵙⵏ «ⵓⵔⴶⵗ ⵏⵔⵗⵎⵓⵏ ⵓⵍⵏ ⴼⵍ ⵎⵙⵏ ⵙⵙⵗⵔⵢ ⵏⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⵀⵜⵓ ⵏⵙⵎ ⴹⵢ⵰ ⵎⵛⵏ ⵏⵢⵜ ⵓⴰ ⵜⴶⵎ⵰ ⵜⵤⵓⵤⵓⵤⵎ ⴹⵗ ⵢⵔⵙⵍⵎ ⴾⵜⵏⵜ ⵙⵙⵗⵔⵏⵓⵏ ⵜⵔⵎ ⴹⵏⵜⵙⵓⵔⵎ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵙ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ⵏⵙⵏ ⵀⵜⵔⵙ ⴹⵏⵎⵤⵍ ⵓⵏ ⵂⴹⵜⵏⵏ «ⵎⵛⵏⴰ ⵙ ⴹⵏⵗⵍⵤⵎ ⴹⵙⵏⵀⵔⴹⴶ ⵓⵔⴶⵗ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ⵎⵛⵏⴰ ⵎⵍⵢ ⵏⵎⵔⵓⵏⵏⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵗⵢⵙⴰ ⵓⵙ ⵜⴶⵎ ⵎⵏⵜ ⵙⵜⵢⵜⵢ ⵓⴰ ⵜⵜⴶⵎ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴾⵍ ⵎⵛⵏⴰ ⴶⵢ ⴹⵗ ⵗⵍⵏⵜ ⴶⵢ ⵎⵤⵔ ⴹⵎⵗⵍⵙ ⵢⴹ ⴶⵔⵓ ⵢ ⴾⵍⵙⵔⵢⵍ ⵜⵔⵢⵜ ⵏ⵿ⵜⵜⵀⵜ ⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ⵏⵎⵙ ⵛⴶⵢⵓⵏ ⵏⵓⵏ ⵏⴾⵏⵢ ⴹⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵂⴾⵓ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵜⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ⵙ ⵙⵍⵏ ⵎⵤⵔⵏ ⵏⵙⴶⵓⵔ ⵓⵏ ⵢ ⵀⵜⵓ ⵜⵏ ⴶⵤⵜⵏ ⵍⵂⵎ ⵍⵀⵙⵏ ⵔⵏ ⴹⵗⵙⵏ ⴾⵙⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ⵎⵛⵏ ⵀⴹⴹ ⵢⵏ ⴹⵗⵙⵏ ⵏ⵿ⵜⴶⵢⵜ ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⴶⵏ ⵙⵎ ⴶⵎⵍⵢⵍ ⵎⵙⵏ ⵎⵙⵏ ⵤⵓⵔⵏ ⵏⵜⵓⵔⵜ ⵙⵗⵎⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵎⵔ ⵙⴹ ⵜⵓⴾⵙⵏ ⵏⵎⵤⵍ ⴹⵗ ⵂⵏ ⵓⴰ ⴹⵗ ⴶⴰ ⵎⵏⵢ ⵂⵔ ⴹⵏⴶⵏ ⵔⵜ ⵏⵎⵤⵢ ");
INSERT INTO ttqt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ⵎⵔⵏ ⵏⵙⵏ «ⴾⵍⵙⵔⵢⵍ ⵏ⵿ⴾⴹⵜ ⵢⵓⵙ ⵜⵔⵎ ⵜⵜⴶⵎ ⵢ ⵎⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ⵓⵔ ⵔⵓ ⴹⵢ ⵙ ⴹⵏ⵿ⴾⵔ ⵍⵙ ⴶⵏ ⵜⴹⵙ ⵏⴰ ⵏ⵿ⵜⴰ ⵎⵙ ⵔⵜ ⵜⵤⵔ ⵍⴾⵎⵏⵙ ⵎⴹⵏ ⵓⴹⵏⵏ ⴾⵤⵜ ⵜⵎⴹ ⵏⵍⵙ⵰ ⵏ⵿ⵜⴰ ⵤⴰ ⵎⵏⵜ ⵜⵓⵏ⵿ⵗⴰ ⴾⵔⵤ ⵎⴹⵏ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ ⵓⵤⵓⵤⵏ ⵀⵏⵏ ⵓⵏ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ⴹⴼⵔⵙ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵜⴹⵏ⵿ⵜ ⵏ⵿ⴾⵔⴹⵓ ⵢⵏ ⵍⵙ ⴶⵏ ⵙⵎ ⵢⵂⵤⴰ ⵓⵏ ⴶⵍⵍⵢⴰ ⵙⴼⵍⴶ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵍⴾⵎⵏⵙ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⵤⴰ ⵜⵓⵏ⵿ⵗⴰ ⴾⵔⵤ ⵜⵤⵔ ⵓⵤⵓⵤⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ⴹⵗ ⴹⵢ ⴹⵗ ⵜⵍⵗⴰ ⵜⴰ ⵏⵙⵈⴰ ⵓⴰ ⴹⵓⵏ⵿ⵤⴶⴰ ⴶⵎⴹⵜ ⵀⵜⵓ ⵏⵎⴹⵏ ⵏ ⵜⵢⵎ⵿ⵜⵏ ⴹ ⴶⵍⵏ⵰ ⴼⵍⵙ ⴾⴹ ⵔⵜ ⵓⴰ ⵏⵢⵏ ⵎⴹⵗ ⵓⴰ ⵜⴶⵏ ⵓⵔ ⵎⵙ ⵔ ⵔⵜ ⵔⵏ ⵢⵜⴹⵏ ⴰ ⵓⴹⵢ ⴹ ⵀⵔⵌⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ⵎⵛⵏ ⴾⴹ ⵔⵜ ⵎⵙ ⵙ ⵎⵛⵏⴰ ⵜⵔⵏ ⵓⴹⵢ ⵓⵔ ⵜⴼⵔⴶⵎ ⵤⵔⵤⵏⵙⵏ⵰ ⵏ⵿ⴾⴹⵜ ⴹⵏⵓⵔ⵿ⵜⴶⵔⵎ ⵎⵏⵓⵏ ⵜⵎⵙⵎ ⵍⴹ ⵏⵎⵛⵏⴰ⵰» ⵜⵤⵔ ⵜⴼⵏ ⵏⵙⵈⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ⵙⵙⵗⵔⵏ⵿ⴹⵓ ⵏⵎⵤⵍ ⵙⵙⴶⵏⵙⵏ ⵛⵓⵜ ⵍⵀⵙⵏⵏ ⵙⵍⴾⴹ⵰ ⴹⴼⵔ ⵓⵏ ⵔⵗⵎⵏⵙⵏ ⴼⵍ ⴹⵓⵔⵍⵙⵏ ⴹⴾⵍ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵎⵔⵏ ⵢⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ⴼⵍⵏ ⵏⵎⵤⵍ ⵂⵏ ⵓⴰ ⴹⵗ ⵜⵎⵏⵢ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴾⵏⵏ ⵜⴹⵓⵜ ⴹ ⵎⵛⵏⴰ ⵜⵏⵙⵂⵔⵏ ⴹⴹ ⵜⵓⵙⴾⵏⵏ ⵎⵍⴾⴰ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ⴾ ⵤⵍ ⴶⵔ ⵤⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵍⴰ ⴹⵗ ⴹⵗ ⵏⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⴾⵍⴰ ⵎⵤⵢⵏ ⴹⵙⵙⵗⵔⵢ ⴹⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵜⵏⵎⵙⵏ ⵙ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ⵤⵎⵏ ⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵜⵜⵢⵏ ⵓⵍⵏ⵰ ⵓⵢⴹⵓ ⵓⵏ ⵙ ⴶⵜⵏ⵿ⵜⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵛⵓⵍⵏⵏ ⵜⵍⵢⵏⵏ⵿ⵜ ⴼⵍ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵛⵓⵍⵏⵏ ⵜⵍⵗⵀⵔⵜ ⴼⵍⵙ ⵓⵔ ⵜⵜⵓⴶⴰ ⵎⵙⵏⵜ ⵜⵍⵗⵜ ⴹⵗ ⵜⴹⴹⵏⵙⵏ ⵛⵏ ⵙ ⵀⴰ ⵎⴹⵏⵙⵏⵜ ⵗⵔ ⵜⵤⵏ⵿ⵜ ⵜⴰ ⵜⵓⴶⵏ ⵎⵏ⵿ⵙⵓⵏ ⴾ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ⴹⵢ ⴼⵍ ⵙⵙⴶⵏ ⵏⵎⵤⵍ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ ⵎⵏⵢ ⵜⵂⴰ ⵍⵌⵎⵗⵜ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⵍ ⵏⵏⵙⵏ «ⵓⵔ ⵂⵔ ⴹ ⵏⵢⵓ ⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⴼⵍ ⴹ ⵏⵏⵜⴼ ⴹⵜⵤⵏ⵿ⵜ ⵏⵎⵏ⵿ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏⴰ ⵙⵏⴼⵔⵏⵜ ⴹⵗⵓⵏ ⵙⴰ ⵎⴹⵏ ⵙ ⵜⴶⴰ ⵎⵙⵏⵜ ⴼⵍ ⵍⵗⵏⵙⵏ ⴹⴾⵔ⵿ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵙⵏ ⵎⵙⵏⵏ ⵜⵏⵙⵏⵜⴼ ⴹⵛⵗⵍ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ⵏⴾⵏⵢ ⵎⵔⵏ ⵏⴶⵎⴹ ⵙⴶⵢ ⵏ⵿ⵜⵓⵜⵔⵓⵏ ⴹⵛⵗⵍ ⵓⵏ ⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⵗⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ⵜⵏⵜ ⵜⵏ ⵜⴶⵎ⵿ⵜⵜ ⵍⵌⵎⵗⵜ ⴾⵜⵏⵜ⵰ ⵜⵤⵔ ⵙⵏⴼⵔⵏⵏ ⵙ⵿ⵜⴼⵏⵙ ⵎⵙⵏ ⵍⵙ ⵤⴶⵤⵏⵏ ⵓⵍⵏ ⴹⴾⵔ⵿ⵜⵓ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⴼⵍⵀⵙ ⴹⴼⵔⴾⵔⵙ ⴹⵏⴾⵏⵔ ⴹⵜⵎⵏ ⴹⵀⵔⵎⵏⵙ ⴹⵏⴾⵍⵢⵙ ⵓⵏ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⵙ ⴾⵍⵏⵜ ⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ⵜⵤⵔ ⵙⵀⴹⴹⵏ⵿ⵜⵏ ⴹⵜ ⵏⵎⵤⵍ ⵙⵓⵔⵏ⵿ⵜⵏ ⵏⵎⵤⵍ ⴼⵙⵏ ⵜⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ⴹ ⵜⵢⵜⵢ ⵜⵓⵙⵗⵎⵔ ⵓⴰ ⵜⵓⴶⵏ ⵢⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⵜⵤⵔ ⵜⵢⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵍⵏ ⴹⵗ ⵢⵔⵙⵍⵎ ⴼⴹⴰ ⵂⴹⵏ⵿ⴹⵓ ⵍⵎⵎⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⵙ ⵗⵢⵙⴰ ⵤⴶⵤⵏⵏ ⵙ ⵍⵎⵙⵈ ⵎⵙ ⵍⴾⵎⵏ ⵢⵓⵙ ⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ⵙ⵿ⵜⴼⵏⵙ ⵍⵙ ⵎⵙ ⴾⵏⵏ ⴶⵔⵓ ⵏⵔⵈⵎⵜ ⴹⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ⵰ ⵜⵎⵤⵍ ⴹⵜ ⵢⵜⴹⵏ ⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵤⵓⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ⵜⵤⵔ ⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵓⵢⴹ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵙ ⵜⵓⵏⵓ «ⵓⴰ ⵏ⵿ⴹⵔⴼⵏ» ⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⴾⵍⵍⵢⵂⴹ ⵏⵆⵔⵓⵏ ⵓⵢⴹ ⵏ ⵗⵔⵎ ⵏⵍⵙⴾⵏ⵿ⴹⵔⵢⴰ ⵓⵢⴹ ⵏ ⴾⵍ ⵓⵏ ⴾⵍⴾⵢⴰ ⴹ ⵓⵏ ⵙⵢⴰ ⴹ ⵜⵎⵤⵗⵏ ⴹⵙ⵿ⵜⴼⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ⵎⵛⵏ ⵓⵔ ⵜⵍⴰ ⴹⵔ ⴹⵏⴾⵏ ⵎⵙⵏⵜ ⵜⴰ ⵜⴾⴼⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ⵜⵤⵔ ⵔⵤⵎⵏ ⵢ ⵎⴹⵏ ⵓⵢⴹ ⴹⵗ ⵙⵔ ⴼⵍ ⴹ ⵙⵓⵔⵏ ⵙ⵿ⵜⴼⵏⵙ ⵀⵂⵓ ⵏⵏ «ⵏⵙⵍⵙ ⵜⴶⵓ ⵀⵜⵜⵏ ⵎⵙⵏⵏ ⴾⵙ ⵏ⵿ⵜⵔⵏⴰ ⵢ ⵎⵛⵏⴰ ⵎⵙⵏⵜ ⴹⵗ ⵀⴰ ⵏ⵿ⵙⴼⵔⵔ ⵏⵏⵀⵢ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ⴶⵏ ⵙⵓⵏ ⵍⵂⵎ ⴹⵗ ⵜⵎⵜⵢ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵓⵔ ⵙⵍⴰ ⵙ⵿ⵜⴼⵏⵙ ⵓⵍⴰ ⵙ ⵜⴹⵙⵏ ⵢⵜⴹⵏ ⵀⵤⵏ⵿ⵜⵓ⵰ ⵓⵢⵏ⵿ⵜⵓ ⵙⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ⵜⵤⵔ ⵙⵀⴹⴹⵏ ⵛⴶⵢⵓⵏ ⵏⵀⵂⵓ ⵏⵏⵜ «ⵍⵙ ⵓⴰ ⵓⵔ ⵜⵎⵤⵢ ⴹⵀⵢⴾ ⵏⵂⵏ ⵓⴰ ⵤⴹⴶⵏ ⵓⴰ ⴹⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ⴶⵎⴹ ⵛⴾ ⵙ ⵏⵙⵍⵙ ⵙ ⵏⴰ ⵍⴾⵎ ⴹ ⵌⵀⵔⵌⵜ ⵗⵢⵙⴰ ⴹⵢ ⵏⵤⵔⵜ ⴹⵢ ⵂⵏ ⵓⴰ ⵙⵎⵜⵢ ⵍⵗⴹⵜⵏ ⵛⵏ ⴹⵏⴹⵢⴰ ⵏⵀⵢ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ⴶⵔⵏ ⵢⵜⴹⵏ ⴾⵜⵏⵙⵏ ⵓⵏ ⵙⴶⵓⵔ ⵛⵜⵓⵏ ⴹⵗ ⵙ⵿ⵜⴼⵏⵙ ⵆⵍ ⵙⵔⵙⵏ ⴹⵎⵏⵜ ⵤⵏ ⵏ ⵏ⵿ⴶⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ⵜⵤⵔ ⵙⵙ⵿ⵜⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵙ⵿ⵜⴼⵏⵙ ⵏⵙ «ⵓⴾ ⵔⵜⵏ ⵓⵏ ⵜⴹⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ⵏⴰ ⵙ⵿ⵜⴼⵏⵙ «ⴾⵓⵏⵢ ⵎⴹⵔⵢⵏⵏ ⴹⵀⵜⵏⵏ ⵙⵙⵎⵜⵢ⵰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵢ ⵏ⵿ⵜⵏⵢⴰ ⵏ⵿ⵜⴰ ⵙ ⴾⵍⴰ ⴹⵏⴼⵍⵍ ⵢⵎⵔⵓⵏⵏⴰ ⵀⵔⵂⵎ ⵂⵔⵓⴰ ⵂⴰ ⴾⵍ ⵓⵏ ⵎⵤⵀⵜⵎⵢⴰ ⴹⵜ ⵜⵎⵈⵙⵔ⵿ⵜⵏⵜ ⴹⵗ ⴾⵍ ⵓⵏ ⵈⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ⵏⵙ \"ⴶⵎⴹ ⴾⵍⵏⴾ ⴹⵎⵔⵓⵏⴾ ⵜⴾⵗ ⴾⵍ ⵓⴰ ⴾⵢⵤⵙⴾⵏⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ⵜⵤⵔ ⴶⵎⴹ ⵀⵔⵂⵎ ⴾⵍ ⵓⵏ ⴾⵙⴹⵢⵜⵏ ⵈⵙⵔ ⴹⵗ ⵓⵏ ⵈⵔⵏ⵰ ⴹⴼⵔ ⵀⴰ ⵏⵀⵏⵜ ⵜⴹⵙⴶⵍⵜ ⵎⵛⵏⴰ ⵙⴾⵍ ⵓⴰ ⴹⴰ ⴹⵗ ⵜⵈⵙⵔⵎ ⴹⴰ ⵤⵍⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ⴾⵍ ⵓⴰ ⵓⵔ ⴹⵗⵙ ⴾⴼⴰ ⵎⵛⵏⴰ ⵀⵔⵂⵎ ⴹⴶ ⵙ ⵤⴶⵤⵏ ⵜⴾⵙⵜⵏⵜ ⵓⵍⴰ ⵗⵙ ⴹⴶ ⴹⵗ ⵙⵏ⵿ⵙⴰ ⴹⵔⵏⵜ ⵎⵛⵏ ⴹⴾⵍⵙ ⵎⵛⵏⴰ ⵔⴾⵓⵍ ⵏ ⴹⵙ⵿ⵜⴾⴼⵓ ⵏ⵿ⵜⴰ ⴹⵤⵔⵢⵏⵜ ⴾⴹⵗ ⵙ ⵍⵓⵆ ⵓⵏ ⵓⵔ ⵍⴰ ⵀⵔⵂⵎ ⵔⴰ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵏⴰ ⵎⵛⵏⴰ \"ⵂⵢⵓⵏⴾ ⴹ ⵈⵙⵔⵏ ⴹⵗ ⴾⵍ ⴹⵗ ⵎⵙⵏ ⵗⵔⵀ ⵆⵍⵏ ⴹⵗⵙ ⴾⵍⵏ ⴹ ⵜⵓⵤⵗⵤⵀⵏ ⵂⵔ ⴶⵏ ⴾⵤⵜ ⵜⵎⴹ ⵏⵓⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ⵎⵛⵏ ⴹⵓⵍⵜ ⵜⴰ ⵜⵏ⵿ⵜⴶⵜ ⴾⵍⵏ ⵏⴾ ⵎⵏⵏ ⵜⵜⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ ⴹⴼⵔ ⴹⵢ ⴾⵙⵆⵏ⵿ⴹⵓ ⴹⵗⵙ ⵗⵀⴹⵏⵢ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ⵜⵤⵔ ⵏⵎⴶⴰ ⵎⵛⵏⴰ ⴹⵀⵔⵂⵎ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⵙⵏ⵿ⵜⴰ ⵙ ⵎⵙ ⵎⵏ⵿ⴾⴹ ⵌⵓⵍⵏⵜ⵰ ⴹⵢ ⴼⵍⵙ ⵙ ⵂⵓ ⵀⵔⵔⵏⵜ ⵙⵂⵆ ⵙⵎⵏ⵿ⴾⴹⵜⵓ ⵤⵍ ⵓⵏ ⵜⵎ ⴹⴼⵔ ⵜⵂⵓⵜⵏⵜ⵰ ⴶⴰ ⵙⵂⵆ ⵓⵏ ⴹⴰ ⵢ ⵀⵔⵔⵏⵜ ⵢⵆⵀ ⵢⵆⵀ ⴹⵗ ⴶⴰ ⵓⵏ ⴹⴰ ⵢ ⵀⵔⵔⵏⵜ ⵎⵙⵏⵏ ⵎⵔⵓ ⴹⵛⵏ ⵓⵏ ⵎⵙⵏⵏ ⵍⵌⴹⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ⵏ⵿ⴾⵔⵏ ⵎⴹⵏ ⵓⵏ ⵎⵙⵏⵏ ⵍⵌⴹⵏⵏⴰ ⵎⵏ⵿ⵤⵗⵏ ⵎⴹⵔⵢⵏⵙⵏ ⵢⵙⴼ ⵜⵤⵔ ⵤⵏ⵿ⵤⵏ⵿ⵜⵏ ⵎⵓⵢ ⵙⴾⵍ ⵏⵎⵙⵔ⵰ ⵎⵛⵏ ⵙⵏ ⴹⵗⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ⴾⵙ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵗⵜⵔ ⴾⵍ ⵛⵏ ⴶⵤ⵰ ⴾⴼⵢ ⵎⵙⵏⵜ ⴹⴹⵎ ⵗⵔ ⴼⵔⵗⵓⵏⴰ ⵓⵏ ⵎⵏⴾⵍ ⵏⵎⵙⵔ ⵂⵔ ⵙ ⴶⵢ ⴼⵔⵗⵓⵏⴰ ⴹⵓⵙ ⵤⵤⵔ⵿ⵜⵓ ⵢⴾⵍ ⵏⵎⵙⵔ ⴹⵗⵢⵓⵏⵜ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ⴹⴼⵔ ⵓⵏ ⴶⴰ ⵍⵤ ⴹⵗ ⴾⵍ ⵏⵎⵙⵔ ⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⴹ ⵓⵏ ⴾⵏⵏ⵰ ⴹ ⵜⵗⵤⵀⵏ ⵢⵜⴹⵏ ⵓⵍⵏ ⵀⴰ ⵢ ⵎⴹⵏ ⵓⵏ ⵎⵙⵏⵏ ⵍⵌⴹⵏⵏⴰ ⵜⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ⵙ ⵙⵍⴰ ⵢⵆⵀ ⵙ ⵎⵙⵔ ⵜⵂⵜ ⵜⵀⵤⵙ⵿ⵜ ⵤⵎⵤⵍ ⵙⵔⵙ ⵎⴹⵏ ⵓⵏ ⴹⵏⵙⵂⵢⵓⵏⵏ ⵎⵙ ⵓⵏ ⴾⵏⵙⵏ ⵢⵙ ⵓⴰ ⵤⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ⵗⵔ ⴾⵏⵙⵏ ⵎⵙⵔ ⵓⵏ ⵛⵏ ⴹ ⵤⵤⴹⵢ ⵢⵙⴼ ⵎⵏⵜ ⵢ ⵎⴹⵔⵢⵏⵜ ⴶⵤⵏ ⴹⵗ ⵙⵍⵏ ⴼⵔⵗⵓⵏⴰ ⵏⵗⵢⵓⵏ ⵓⴰ ⴹⴶⵎⴹ ⵢⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ⵙⴶⵎⵢ ⵢⵙⴼ ⵀⵏⵜ ⵢⵆⵀ ⴹⵎⵔⵓⵏⵜ ⴾⵍ ⵎⵙⵏ ⵙⵢⵜ ⵜⵎⵔⵓⵏ ⵏⵓⴹⵏ ⴹⵙⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ⵜⵤⵔ ⵔⵙ ⵢⵆⵀ ⴾⵍ ⵏⵎⵙⵔ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵜⵀⴰ ⵀⴰ ⴹⵗⵙ ⴹⵗ ⵎⵔⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ⵎⵓⵢⵏⵜ ⵜⵗⵙⵓⵏⵙⵏ ⵙⵗⵔⵎ ⵏⵛⴾⵎ ⵜⵓⵏⵀⵍⵏⵜ ⴹⵗ ⵤⴾⴰ ⵓⴰ ⵤⵏ⵿ⵤⴰ ⵀⵔⵂⵎ ⵤⵔⴼ ⵓⴰ ⵀⵍⵍⵗⵏ ⵗⵔ ⵎⴹⵏⵙ ⵏⵈⵎⵔ ⴹⵗ ⵛⴾⵎ ⵢⴹ ⵆⵍ ⵜⵏⵀⵍ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ⵙ ⴹⵂⵤ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵤⵙⵏ⵿ⴹⵓ ⵎⵛⵏⴰ ⵔⴾⵓⵍ ⵓⴰ ⴼⵍ ⵂⴹ ⵢⵀⵔⵂⵎ ⵜⵎⵜⵢⵏⵏⴰ ⵜⵜⵢ ⵜⵎⵙ ⵜⵈⵍⴾ ⵜⴶⵜ ⴹⵗ ⵎⵙⵔ ");
INSERT INTO ttqt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ⵂⵔ \"ⴶⵤ ⵢⵏ ⵎⵏⴾⵍ ⵓⵔ ⵏⵙⵏ ⴼⵍ ⵢⵙⴼ ⵜⵗⵎⵔ ⵏ ⵎⵙⵔ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ⴾⵔⵙ ⴾⵍ⵿ⵜⵎⵜⵏⵏⴰ ⴶⴰ ⵢ ⵎⵔⵓⵏⵏⵏⴰ ⵤⵗⵤⵀ ⵍⵀⵙⵏ ⵂⵔ ⵙ ⵛⵂⵛⵍ⵿ⵜⵏ ⴹⵏ⵿ⵜⵢⵏ ⵀⵔⵔⵏⵙⵏ ⵓⵏ ⵙ ⵙⴾⵜ ⵂⵓⵏ ⴹⵗ ⵙⴼ ⴼⵍ ⴹ ⵓⵔ ⴹⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ⵤⵎⵏⵏ ⴹⴰ ⴹⵗ ⵂⵓ ⵎⵙⴰ ⵎⵙ ⵀⵔⵔ ⵂⵙⵢⵏ ⴶⵔⵓⵏ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ⵜⴼⵏ⵿ⵜⵓ ⵎⵔⵓⵏⵜ ⴹⵗ ⵂⵏⵙⵏ ⵂⵔ ⴶⴰ ⴾⵔⴹⵜ ⵜⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ⵢⵏ⵿ⵜⵏ ⵎⵔⵓⵏⵜ ⵗⵙ ⴼⵍ ⴼⵢ ⵏⵏⵍ ⵜⵏⵢⵜⵓ ⵜⵀⵔⵔ⵿ⵜ ⵏ⵿ⴼⵔⵗⵓⵏⴰ ⵜⴹⴾⵍ⵿ⵜⵓ ⵜⴶⵢ ⵀⵔⵔⵏⵜ ⵜⴶⵙ ⵙⴹⵓⵍ ⵓⴰ ⵤⴰ ⵜⴶⵓ ⵢ ⵀⵔⵔ ⵏ⵿ⵜⴹⵙ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ⵜⵓⵙⵙⵗⵔⵓ ⵎⵙⴰ ⵎⵙⵏⵜ ⴾⵍ ⵜⵏ ⴾⵍⵎⵙⵔ ⵆⵍ ⵍⵙ ⵍⵏ ⵜⵏⴰ ⴹⵗ ⵓⴰ ⴶⵏⵓ ⴹⵓⴰ ⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ⵙ ⴶⴰ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴹⵜⵂⵓⵜ ⴶⵤⵜⴹ ⴹⵏⵙⵓ ⵎⴹⵔⵢⵏⵜ ⴾⵍⵙⵔⵢⵍ ⵏⵢ ⵓⴰ ⴹⵔ ⵜⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ⵏⵢ ⵢⵏ ⴹⵗⵙⵏ ⵜⵓⴶⵏⵜⵙ ⵜⵔⵛⵈⵛⴹ ⵗⵙ ⵛⵏⵗⵏ ⴶⴰ ⵎⵏ ⵏⵓ ⵎⵙⵔ ⵓⴰ ⴹⵙⵜⴶⵏ ⵔⴾ ⵔⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ⵗⵍ ⴹ ⴶⵔⵏ ⵎⴹⵔⵢⵏⵜ ⴾⵍⵙⵔⵢⵍ ⵙ ⵎⵛⵏⴰ ⵜⴹⵤⵎⵤⵍⵏ ⵙⵔⵙⵏ ⴼⵍ ⵜⵏⵙⴼⵙⵓ ⵎⵛⵏ ⵓⵔ ⴶⵔⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ ⵢ ⵓⵏ ⵙⴹⵓ ⵛⵏ ⴹⵗⵙⵏ ⴾⵏⵙⵏ⵰ ⴶⵎⵢ ⴹⵜⵏⴾⵏⵓ ⵏⵎⴶⵏ ⵍⵈⵔ ⵏⵙⵏ \"ⵎⴹⵏ ⴾⵓⵏⵢ ⵎⵙⵏⵏ ⵎⴹⵔⵢⵏ ⵎⴼⵍ ⵙ ⵜⵜⵏⵎⵏ⵿ⵗⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ⵎⵛⵏ ⵀⴹⵆⵏ ⵍⵙ ⵓⴰ ⵜⴶⵏ ⵜⵔⵛⵈⵛⴹ ⵢⵎⴹⵏⵜ ⵏⵙ \"ⵎⴰ ⴾⵢⴶⵏ ⵎⵤⵔⵏⵏⴰ ⵓⵍⴰ ⵎⵛⵔⵗⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ⵏ⵿ⴶⵎ ⵜⵔⵗ ⴹⵜⴶⴰ ⵜⵏⵗⵢ ⵜⴰ ⵜⴶⵗ ⵢⵓ ⵎⵙⵔ ⵓⵏ ⵏ⵿ⴹⵤⵍ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ⵙⵍⴰ ⵎⵙⴰ ⵢ ⵀⵜⵓ ⵜⵏ ⵗⵙ ⵜⴶⵤⵜⵓ ⵜⵙⴰ ⴶⵎⴹ ⵎⵙⵔ ⵍⵗⵙ ⴹⵗ ⴾⵍ ⵓⵏ ⵎⴹⵢⵏ ⵆⵍ ⴹⵗⵙ ⵗⵔⵀ ⵤⵍⴼ ⴹⵗⵙ ⴶⵔⵓ ⵛⵏ ⵀⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ⵙ ⴶⵏⵜ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⴹⴼⵔ ⵓⵏ \"ⵏⴼⵍⵍⵙⴹⵓ ⵏ⵿ⴶⵍⵙ ⴹⵗ ⵜⴼⵙⵆ ⵜⵀⵍⴶⵍⴶⵜ ⴹⵗ ⵜⵏⵔⵢ ⵗⵔ ⴹⵗⵗ\" ⵓⵏ ⵙⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ⵙⵎⴾⵍⵍ ⵙ ⵎⵙⴰ ⵔⵜ ⵓⴰ ⴹⵙⴹⵏⴼⵍⵍ ⴹⵏ⵰ ⵜⵂⵤⵏ ⵤⴰ ⵜⴼⵙⵆ ⴼⵍ ⴹ ⵏⴼⵍⵢ ⴹⵗ ⵓⵏ ⵙ ⵙⵍⴰ ⵢⵎⵙⵍⵢ ⵏⵎⵍⵢ ⵎⵛⵏⴰ ⵙ ⴹⵙⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"ⵏⴾ ⵎⵙⵏ ⵎⵛⵏⴰ ⵏⵎⵔⵓⵏⴾ ⵎⵍⵢ ⵏⵀⵔⵂⵎ ⴹⵙⵂⵆ ⴹⵢⵆⵀ⵰\" ⵜⵏ⵿ⴹⵓ ⵜⵢⵙⵙ⵿ⵜ ⵎⵙⴰ ⵀⵙ ⵂⵍ ⴹ ⵍⵙ ⵙⵓⴹ ⴹⵗ ⵜⴼⵙⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ⵏⵙ ⴹⵗ ⵎⵍⵢ \"ⴾⵙ ⵗⵜⵎⵏⴾ ⴼⵍⵙ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵀⴹⴹⵗ ⴹⵢ ⵎⴹⵍ ⵤⴹⴶⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ⵗⵢⵏⵗ ⵍⵗⵤⵀ ⵓⴰ ⵜⵜⴶⵓ ⵜⵎⵜⵢⵏⵏ ⴹⵗ ⵎⵙⵔ ⵙⵍⵗ ⴹⵗ ⵢ ⵂⵔⵔⴾⵜⵏⵙⵏ⵰ ⵤⵀⴹⵓ ⴼⵍ ⵜⵏⵙⴼⵙⴰ⵰ ⵎⵔⴹⴰ ⵂⵤⴹⵓ ⴾⵢⵤⵎⵤⵍⴰ ⵙ ⵎⵙⵔ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ⵎⵙⴰ ⵓⵏ ⴹⴰ ⵏ⵿ⴾⵔⵏ ⵙ ⵜⵏⴰ ⵜⴰ ⴹⵙⴶⵏ \"ⵎⴰ ⴾⵢⴶⵏ ⵎⵤⵔⵏⵏⴰ ⵓⵍⴰ ⵎⵛⵔⵗⵏⵏⴰ⵰\" ⵏ⵿ⵜⵏ ⴹⴰ ⵤⴰ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵢⴹ ⵤⵔ ⵢ ⴾⵍⵙⵔⵢⵍ ⵙⴹⵔⴼⵜⵏ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴶⵍⵙ ⵓⴰ ⴹⵙⴹⵏⴼⵍⵍⵏ ⴹⵗ ⵜⴼⵙⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ⵏ⵿ⵜⵏ ⴹⴰ ⵜⵏ⵿ⴹⴾⵙⵏ ⴹⵗ ⵎⵙⵔ ⵙⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵓⵏ ⵜⴶⵓ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵏ⵿ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ⵰ ⴶⴰ ⵔⵜⵏ ⵓⵢⴹ ⵙⵎⴾⵍⵍⵏⵏ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵗⵔ ⵔⴹⵗ ⵓⴰ ⴶⵏ ⴹⵗ ⴶⵔⵓ ⵓⵙ ⵜⵓⵏⵓ ⵓⴰ ⵤⴶⵗⵏ ⴶⵍⴰ ⵜⴶⵓ ⵓⵏ ⴹⴰ ⴹⵗ ⵜⵏⵔⵢ ⵂⵔ ⴶⴰ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ⵎⵙⵏ ⴹⴰ ⵏⵏ ⵢ ⴾⵍⵙⵔⵢⵍ \"ⵍⴾⵎ ⵙⵔⵓⵏ ⴹⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵏⵀⵢ ⵢⵏ ⵏⵛⵍⵜⵏ ⴾⵓⵏ⵿ⴹⵤⴶⵎⴹⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ⵙ ⵜⴹⵓ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ ⴹⵗ ⵜⵏⵔⵢ ⵏ⵿ⵙⵏⵢ ⵏ⵿ⵜⵏ ⴹⴰ ⵀⴹⴹⵏ ⴶⵔ ⵎⵔⵓⵏⵏⴰ ⵓⵏ ⴹⵏ ⴹⵏ⵿ⴶⵍⵙ ⵓⴰ ⴹⵙⵛⵓⵍⵏ ⴼⵍ ⴹⵗⵗ ⵓⵏ ⵙⵏⵢ ⵜⵤⵔ ⴾⴼⵢ ⵎⵛⵏⴰ ⵓⵍⵏ ⵂⴾⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵢⴹⵏⵜⵏⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ⵎⵛⵏ ⴶⵢⵏ ⵎⵔⵓⵏⵏⴰ ⵙⴹ ⵍⴾⵎⵏ ⵢⵓⴰ ⵏⴰ ⵎⵙⴰ ⴶⵢⵏ ⵙⵔⵙ ⵙⴹⵔⵏⵏ ⴹ ⵆⵍⵏ ⵎⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ⵏⵏ ⵢ ⵂⵔⵏ \"ⴶⵏⴰ ⵎⵍⵏ ⵤⵎⵍⵏⵏ ⴹⵜⵏⴰ ⴼⵍⵙ ⵎⵙⴰ ⵓⴰ ⴹⵏⴹⴾⵙⵏ ⴹⵗ ⴾⵍ ⵏⵎⵙⵔ ⴹⴰ ⵓⵔ ⵏⵙⵏ ⵓⴰ ⴹⵗⵙ ⵏⴶⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⴶⵏ ⵙⵏⵎ ⴶⵏ ⵜⵎⵓⵜ ⵏⵀⵔⴾⵓ ⴾⵜⵏ ⴼⵍⵙ⵰ ⵙⴹⵓⵜⵏ ⵓⵍⵏ ⵔⵜ ⵓⴰ ⴶⵏ ⵙ ⴼⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ⵜⵤⵔ ⵏⵎⴶⴶ ⴹⵔⵙⵏ ⵎⵛⵏⴰ ⵢⵏ ⴹⵎⵏⵙⵏ ⵗⵀⴹⵏ ⵜⴼⴾ ⴹⵜⵍⵜ ⴹⵜⵔⵏ ⵎⵙ ⵓⵏ ⵔⵜ ⵏⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ \"ⵢⴰ ⴾⵍⵙⵔⵢⵍ ⵓⴾ ⵏⴾ ⵙ ⵜⵜⴶⵎ ⵛⵤⴶⵤⵎ ⴹⵜⴾⵜⵓⵏ ⴹⵗ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⵛⵏ ⵜⴶⵎ ⴹⵗ ⵜⵏⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ⵓⵔⴶⵗ ⵂⴾⵜ ⵏⵙⵏⵎ ⵓⴰ ⴶⵏ ⵎⵍⵈ ⵜⵓⵢⵎ ⴹⵛⵛⵍⵏ ⵏⵜⵔⵢ ⵓⴰ ⴶⵏ ⵔⵎⴼⵏ ⵓⵏ ⵙⵏⵎⵏⵓⵏ ⵎⵙⵏⵏ ⵙⵏⵎⵏ ⵓⵏ ⵜⴶⵎ\" ⴼⵍ ⵜⵏ⵿ⵜⵗⵀⴹⵎ⵰ \"ⴹⵢ ⴼⵍ ⴾⵓⵏ⵿ⵤⵙ⵿ⵜⵗⴰ ⵂⵔ ⵜⴾⵢⵎ\" ⵀⵀⵢⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ⵎⵔⵏ ⵎⵔⵓⵏⵏⴰ ⵓⵏ ⴹⴾⵙ ⵎⵛⵏⴰ ⴹⵗ ⵎⵙⵔ ⴶⵤⵏ ⵜⵏⵔⵢ ⵍⵏ ⵂⴾⵜ ⵓⵏ ⵎⵏⵢ ⴹⵎⵛⵏⴰ ⵓⵙ ⵎⵔ ⵎⵛⵏⴰ ⵎⵙⴰ ⵙⴹ ⵜⴶⵓ ⵙⵎⴾ ⵓⴰ ⵜⵙⴾⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ⵂⴾⵜ ⵏ ⴶⵤⴹⵓ ⵙ ⵎⵔⵓⵏⵏⴰ ⵓⵏ ⴹⴼⵔ ⵓⵏ ⴹⵏ ⵤⵎⵏ ⵓⵏ ⴹⵗ ⴹⵙⵏⵤⵔ ⵌⵙⵓ ⵓⵢⵏ⵿ⵜⵓ ⵙⴾⵍ ⵓⴰ ⵀⵤⵏ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵙ⵿ⵜⵗ ⵎⵛⵏⴰ ⵜⵓⵛⵜⵏ ⴹⵜⵙⵏ⵰ ⴶⵤ ⵂⴾⵜ ⵓⵏ ⴾⵍⵏ ⴹⴰ ⵂⵔ ⵤⵎⵏ ⵏⵏⵀⵢ ⴹⵓⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ⵏⵀⵢ ⴹⵓⴹ ⴶⵔⵓ ⵔⵈⵎⵜ ⵗⵔ ⵎⵛⵏⴰ⵰ ⵏ⵿ⵜⴰ ⴶⵎⵢⵏ ⴹⵗ ⵎⵛⵏⴰ ⵜⵔⴶⵜ ⵏⴹ ⴾⵔⵙ ⵂⵏ ⵢⵎⵍⵢ ⵏⵢⵆⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ⵎⵛⵏ ⵏⵀⵢ ⵙⵍⵎⵏ ⴶⵔⵓⵏ ⵜⵔⴶⵜ ⵜⵏ ⴾⵔⵙ ⵂⵏ ⵢⵎⵍⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⵓⵔ ⵈⵙⵔ ⴹⵗ ⴾⵔⵙⵏ ⴼⵙⵏ ⵏⵢⵜⴹⵏ⵰ ⴹⵢ ⵏⴰ ⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ⵏⴰ ⵎⵍⵢ ⵎⵛⵏⴰ \"ⵌⵏⵓⵏ ⵎⵙⵏⵏ ⵜⵈⵓⵜⵏ ⵜⵏ ⵜⵗⵎⵔ ⵎⴹⵍ ⵓⵔ ⵎⵙ ⵔ ⵔⵜ ⵍⵏ ⴹⵓ ⴹⵔⵏⵏ⵰ ⴹⵗ ⴹⵢ ⵎⴰ ⵎⵙ ⵤⵏⴼ ⵏⵂⵏ ⵓⴰ ⴹⵤⵜⴾⵔⵙⵎ⵰ ⵎⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵤⵙⵏ⵿ⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ⵓⵔⴶⵗ ⴼⵙⵏ ⴹⵈⵍⴾⵏ ⴹⵢ ⴾⵍ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ⵂⵔⵓⴰ ⵏⵙⵏ ⵙ⵿ⵜⴼⵏⵙ «ⵢⴰ ⵎⴹⵏ ⵓⵏ ⵆⵙⵜⵏⵏ ⵜⵈⴼⵍⵎ ⵓⵍⵏⵓⵏ ⵜⴹⵀⵗⵎ ⵛⵎⵤⴶⵏⵓⵏ ⵓⵔ ⵜⵤⵍⵢⵎ ⴹⵢⵜⴹⵏ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⴼⵓ ⵜⴶⵢⵎ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⴹⵢ ⴹⴰ ⴶⵏ ⵎⵔⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ⵎⵏⵢ ⴹⵗ ⵏⵀⵜⵏ ⵓⴰ ⵓⵔ ⵤⵗⵤⵀⵏ ⵎⵔⵓⵏⵓⵏ⵰ ⴶⵏ ⵎⵏ ⵏⵎⵤⵍ ⵏⵎⵛⵏⴰ ⵓⵏ ⵎⵍⵏⵏ ⴹⵜ ⵍⵓⵆ ⵙⴰ ⵏⵓⴰ ⵗⴹⵏ ⵙ ⴾⵓⵏⵢ ⵎⵔⴹⴰ ⵜⴾⴹⵍⵏ ⵜⴶⵎ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ⴾⵓⵏⵢ ⵓⵏ ⴹⵙⴾⴰ ⵎⵛⵏⴰ ⵏ⵿ⴶⵍⵙⵏ ⵓⵢⵏⵏ ⵍⵆⵏⵏⵜ ⵎⵛⵏ ⵜⴶⵢⵎ ⵙⴹⵙ⵿ⵜⵍⴾⵎⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ⵙ ⵙⵍⵏ ⵢ ⵀⵜⵓ ⵜⵏ ⴶⵤⵜⵏ ⵍⵂⵎ ⵍⵀⵙⵏ ⴹ ⵙⵎⴹⴹⵏ ⴼⵍ ⵍⵂⵎ ⵏⵙ⵿ⵜⴼⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ⵎⵛⵏ ⵏ⵿ⵜⴰ ⴹⴾⵔⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⴾⵍ ⵙⵓⴹⵏⵜ ⵙⴰ ⵙⵔ ⵌⵏⵓⵏ ⵏⵢ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵏⵢ ⴹⵗ ⵗⵢⵙⴰ ⵀⴹⴹ ⴹⵗ ⵗⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ⵜⵤⵔ ⵏⵙⵏ «ⵏⵢⵜ ⵌⵏⵓⵏ ⵏⵍⵎⵏ⵰ ⵂⵏⵢⵗ ⴶ ⴶⴹⵎ ⵀⴹⴹ ⴹⵗ ⵗⵍ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ⵙⵍⵏ ⵢⵓⵏ ⵗⵙ ⴹ ⵤⵢⴾⵏ ⴹⵀⵗⵏ ⵛⵎⵤⴶⵏⵙⵏ ⴶⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵙⵙ⵿ⵜⴼⵏⵙ ⵀⵤⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ⴾⵙⵏ⵿ⵜⵓ ⴹⵗ ⵗⵔⵎ ⴹ ⵜⴶⵔⵏ ⵙ ⵜⵂⵏ⵰ ⵎⵔⵏ ⵎⴹⵏ ⵓⵏ ⴼⵍⵙ ⴶⵢⵜⵏⵏ ⵍⵙ ⵏⵎⵙ ⴶⵏ ⵙⵎ ⵜⵍⵜ ⵗⵔ ⵙⵏ⵿ⵙⵏ ⵀⵔⵏⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ⴶⵔⵏ ⵙ⵿ⵜⴼⵏⵙ ⵙ ⵜⵂⵏ ⵙ ⵜⵔ ⵏⴰ «ⵢⴰ ⵎⵍⵢ ⵗⵢⵙⴰ ⵆⵀⵍ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ⴹⴼⵔ ⵓⵏ ⴶⵔⴼⵜ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵙⴼⵍⴰ ⵏⴰ «ⵢⴰ ⵎⵍⵢ ⵜⵏⵓⵔ⵿ⵜⵙⵓⵔⵗ ⵀⴾⴹ ⵓⴰ⵰» ⵙ ⵏⴰ ⵓⵏ ⴶⵎⴹⵏ⵿ⵜⵓ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ⵎⵔⵏ ⵜⵍⵜ ⵏ⵿ⵜⴰ ⵂⴰ ⵓⵏ ⵔⴹⵏⵏ ⵙⵜⵓⵏ⵿ⵗⴰ ⵏⵙ⵿ⵜⴼⵏⵙ⵰ ⵜⵜⵢⵜ ⵏⵍⴾⵏⵙⵜ⵰ ⵛⴶⵢⵓⵏ ⴹⵗ ⵢⵂⴹⵢⴰ ⴹⵙⵎⵔⵢⴰ ⵤⵍ ⵓⵏ ⴹⴰ ⴹ ⵜⵏ⵿ⵜⴰ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⴼⵍ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵂⵜ ⵢⵔⵙⵍⵎ⵰ ⵜⵤⵔ ⵓⵤⵓⵤⵏ ⵍⵎⵙⵈⵜⵏ ⴾⵜⵏⵙⵏ ⴹⵗ ⴾⵍⵏ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹⵙⵎⵔⵢⴰ⵰ ⵓⵔ ⴹⵆⵎ ⴹⵗ ⵢⵔⵙⵍⵎ ⵔ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ⵙⵏ⵿ⴹⵓ ⵎⴹⵏ ⵏⵎⴾⵙⴹⵏ ⵏⵎⵛⵏⴰ ⵏⵀⵍⵏⵏ ⵙ⵿ⵜⴼⵏⵙ⵰ ⵢⵓⵏⵏ ⴼⵍⵙ ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ⵜⵍⵜ ⵏ⵿ⵜⴰ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵂⵍⴾ ⵏⵍⴾⵏⵙⵜ⵰ ⵔⵤⴶ ⵏⵏ ⵍⵀⵢⴹⵓ ⴹⵗⵙⵏ ⵎⴹⵏ ⴹⵜⴹⴹⵏ ⴶⵔ⵿ⵜⵏ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ⵎⵔⵏ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵓⵏ ⵜⵓⵤⵓⵤⵏⵏ ⴹⵏ ⵔⵤⴶⵏ ⴾⵍ ⴾⵜⵏⵜ ⵎⵍⵏ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⵓⵏ ⵂⵏⵏ ⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ⵓⵏ ⴹⴰ ⴹⵓⵢⵏ ⴼⵍⵀⵙ ⵙⵗⵔⵎ ⵢⵏ ⵏⴾⵍ ⵏ⵿ⵙⵎⵔⵢⴰ ⴹⵗⵙ ⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ⵙ ⵜⵙⵍⴰ ⵍⵌⵎⵗⵜ ⵜⴶⵜ ⵜⵏⵎⵏⴾⵜ ⵢⵓⵍ ⵏ⵿ⴼⵍⵀⵙ ⵜⵏⵢ ⴹⵗ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵛⵏ ⵜⴶⵓ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⵏ⵿ⵜⵔⵏⴰ ⵜⴰ ⴶⵔⵓ ⵜⵙⵗⵍⵏ ⵏⵢⵜⵏⵜ ⵔⵜⵏ ⵓⵏ ⴶⵏⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ⴼⵍⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵎⴹⵏ ⴾⵍⵙⴼ⵰ ⵙ ⵜⵏ⵿ⴹⴶⵎⴹⵏ ⵜⴾⵙⵏ ⵎⵙⵍⵏ ⵍⵀⵙⵏⵏ⵰ ⵜⵓⵤⵤⵢⵏ ⴹⵗ ⵏⵀⴹⵏ ⴹⵎⴶⴹⵍ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ⵓⵢⴹⵓ ⵓⵏ ⵜⴹⵓⵜ ⴶⵜ ⴹⵗ ⵗⵔⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ⵎⵔⵏ ⵗⵔⵎ ⵏ ⵂⵢ ⵍⵙ ⵢⵏ ⵏⵎⵙⵈⵔ ⴶⵏ ⵙⵎ ⵙⵎⵗⵏ ⵜⴶⵏ ⵛⵗⵓⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵙⵢⵜⴹⵏ ⵏ⵿ⵙⵎⵔⵢⴰ⵰ ⴶⵏⵓ ⵏ⵿ⵜⴰ ⵓⴹⵏ ⵤⵓⵔⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ⵢⵜⴹⵏ ⴾⵍ ⵙⵙⵎⵏⵙ ⵙⵍⵗ ⴶⵔ ⵤⴰ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵍⵎⵆⵎ ⵓⵍⴰ ⵓⵏ ⵜⵍⵏⵏ ⴶⵏⵏ «ⵍⵙ ⵓⴰ ⵜⵔⵏⴰ ⵏⵎⵍⵢ ⵜⵙ ⵜⵓⵏⵓ ⵜⴰ ⵜⴶⵔⵜ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ⵢⵜⴹⵏ ⵓⵏ ⵙⵙⵎⵏⵙ ⵙⵍⵗ ⴼⵍⵙ ⵔⵓ ⵜⴶⵙⵏ ⵛⵗⵓⵏ ⵙⵔⵙⵏ ⵙⵎⴾⵍⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ⵎⵛⵏ ⵙ ⵤⴶⵤⵏⵏ ⵢ ⴼⵍⵀⵙ ⴹⵙⵏⵎⵍⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⵜⵔⵏⴰ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵎⴹⵏ ⵂⵔⴾⴹ ⵜⴹⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ⵤⴶⵤⵏ ⵙⵎⵗⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ⵰ ⵍ⵿ⵜⵗ ⴹⵗ ⴼⵍⵀⵙ⵰ ⵆⵏⵜ ⵍⵗⵍⵎⵜⵏ ⵏ⵿ⵜⵔⵏⴰ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ ⵤⵓⵔⵏⵏ ⵛⵏ ⵜⴶⵓ ⴼⵍⵀⵙ ⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ⵙ ⵙⵍⵏ ⵏⵎⵤⵍ ⴹⵗ ⵢⵔⵙⵍⵎ ⵙ ⴾⵍⵙⵎⵔⵢⴰ ⵆⵀⵍⵏ ⵓⵍ ⵏⵎⵛⵏⴰ ⵤⵎⵤⵍⵏ ⵙⵔⵙⵏ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ⵙ ⵜⵏⵏⵙⵏ ⵜⵔⵏⵙⵏ ⴼⵍⵙⵏ ⴹⵤⵤⵀⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ⴼⵍⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⴼⵍ ⴹⵤⵀⵜ ⵜⵓⵙⵍⵎⵗ ⵗⵙ ⵜⵓⴶⵏ ⴹⵗ ⵎⵏ ⵙⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ⵜⵤⵔ ⵜⵏⵙⵓⵔ ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⴼⵙⵏⵙⵏ ⴶⵔⵓⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ⵙ ⵏⵢ ⵙⵎⵗⵏ ⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵓⵔ ⵏ⵿ⴼⵙⵏ ⵏⵎⵤⵍ ⵙ ⵜⵓⴶⵔⵓ ⴶⵎⵢ ⴹⵗⵙⵏ ⵜⵏⴾⴼⵓ ⵤⵔⴼ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ⴾⴼⵓⵜⵢ ⵏⴾ ⴹⴰ ⵜⵔⵏⴰ ⵜⴹⵢ ⵜⵙ ⵢ ⵙⵓⵔⴰ ⴼⵙⵏⵏ ⴹ ⴶⵔⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ⵏⵙ ⵀⵜⵔⵙ «ⵜⵂⵍⴾⵗⵜ ⴾⵢ ⴹⵤⵔⴼⵏⴾ ⵤⵎⴰ ⵜⵗⵍⴰ ⵜⴼⵔⴶⵗ ⵜⵤⵏ⵿ⵤⴰ ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ⵀⵜⵓ ⵜⴰ ⵓⵔⵎⴹ ⵜⵜⵂⵗ ⵤⴰ ⵓⵍⴰ ⵜⵍⵗ ⴹⵗⵙ ⵜⵏⵜ ⴼⵍⵙ ⵓⵍⵏⴾ ⵓⵔ ⵗⴹ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ⴹⵗ ⴹⵢ ⵜⵀ ⴹⵗ ⵛⵔⵏⴾ ⵜⵏ⵿ⵙⵢⴰ ⵎⵛⵏⴰ ⴹⴾⵙⵔⴼ ⵔⴾ ⵏⵢⵜ ⵜⴰ ⵜⵂⵜ ⵓⵍⵏⴾ ⴾⴹ ⵎⴾⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ⴼⵍⵙ ⵂⵏⵢⵗ ⵙ ⵓⵍⵏⴾ ⵓⵔ ⴹⴾⵔ ⵔ ⵜⵔⴰ ⵏⴹⵏⵜ ⵍⵀⵙⵜ ⴹⵀⴰ ⵏⵆⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ⵜⵤⵔ ⵏⵙⵏ ⵙⵎⵗⵏ «ⵏ⵿ⵙⵢⵜⵢ ⵎⵍⵢ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴼⵍ ⴹⵓⵔⵀⵤ ⵙⵓⴰ ⵜⵏⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ⵀⵜⵔⵙ ⴹⵢⵈⵢⴰ ⵓⵏ ⵏⵎⵤⵍ ⵙ ⵎⵍⵏ ⵢⵢⵜⴹⵏ ⵓⴰ ⴶⵢⵏ ⴼⵍ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵍⵏⵙⵏ ⴹⵗ ⵓⵍ ⵏⵎⵍⵢ ⵆⵍⵏ ⵢⵔⵙⵍⵎ⵰ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⵜⵗⵔⵎⵜⵏ ⴶⵜⵏⵏ ⵏ⵿ⵙⵎⵔⵢⴰ ⵛⵏ ⵂⵏⵏ ⵜⵔⵢⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ⴹⴼⵔ ⵓⵏ ⵛⵓⵍ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⵢ ⴼⵍⵀⵙ ⵏⵙ «ⵏ⵿ⴾⵔ ⵜⵓⵢⴰ ⴹⵜⵔⵢⵜ ⵜⴾⵜ ⴶⵍⴰ ⵜⴰ ⵜⴶⵎⴹⵜ ⵢⵔⵙⵍⵎ ⵜⵔⵙ ⵜⴾⴰ ⴶⵤⴰ⵰» ⵜⵔⵢⵜ ⵜⵏ ⵜⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ⵏ⵿ⴾⵔ ⴼⵍⵀⵙ ⴶⵍⴰ⵰ ⵌⵓⵏ⵿ⴾⵜ ⴹⵗ ⵜⵔⵢⵜ ⵙ ⵎⵏⵢ ⴹⵍⵙ ⵏⵏⵤⵎ ⵏⴾⵍ ⵏⵜⵢⴼⵢⴰ ⵎⵙⵏ ⵓⴹⵏ ⵤⵓⵔⵏ ⴹⵗ ⵜⵗⵎⵔ ⵏ⵿ⴾⵏ⵿ⴹⵙ ⵜⵏ ⵜⵎⵏⴾⵍ⵿ⵜ ⵏⵜⵢⴼⵢⴰ ⵙⵏ⵿ⵜⴰ ⵏⵜⴼⵏ ⴹⵔⵤⵗ ⴾⵍ ⵓⵏ ⵜⵎⵏⴾⵍ⵿ⵜⵏ⵰ ⵙⴹⵓ ⵢⵔⵙⵍⵎ ⴼⵍ ⴹⵗⵙ ⵗⵀⴹ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ⵆⵍ ⴾⵍⵏⵜ ⵆⵎ ⴹⵗ ⵎⵍⵏ⵿ⴾⵢⵏⵜ ⵗⵔⵓ ⵍⴾⵜⵀ ⵏⵏⵀⵢ ⵙⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵢ ⴼⵍⵀⵙ «ⵂⵤⵏ ⵎⵍⵏ⵿ⴾⵢ ⵏ ⵜⵎⴹⵗⵗ ⵢ ⵎⵛⵙ» ");
INSERT INTO ttqt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ⵤⵍⵏ ⵙⵔⵙ ⴼⵍⵀⵙ⵰ ⵙⵍⵙ ⵗⵔⵓ ⵍⴾⵜⵀ ⵏⵏⵀⵢ ⵙⵢⵙ ⵏⵙ «ⵓⴾ ⵜⴶⵔⵗ ⵍⵎⵗⵏⴰ ⵏⵓⴰ ⵜⵗⵔⴰ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ⵏⵙ ⵍⵙ ⵓⵏ «ⵎⵏⵎⴾ ⵙ ⵜⵤⴶⵔⴰ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴹⵜⴼⵙⵔⵏ⵰» ⵜⵤⵔ ⴶⵎⵢ ⴹⵗ ⴼⵍⵀⵙ ⴹⵓⵏ ⵆⵎ ⴹⴶⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ⴹⴶ ⵓⴰ ⵗⵔⵓ ⴹⵗ ⵍⴾⵜⵀ ⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵏⴰ «ⵜⵍⵓⵢ ⵤⵏ ⵜⵍⵢ ⵙⴹⴶ ⵏⴶⵤⵎ ⵜⴼⵙ⵿ⵜⵜ ⵜⴶⵓ ⵌⵗⵍ ⵢⵢⵜⴹⵏ ⵍⵤⵏⵏ ⵜⴹⴼ⵿ⵜⵏⵜ ⴶⴰ ⵓⵔ ⴹⴶⵎⴹ ⵍⵈⵔⴼ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ⵜⵓⵙⵔⵙ ⵓⵔ ⴹⵙⴶⵏ ⵛⵔⵗⴰ ⵓⴰ ⴹⵔ ⵂⵔ⵰ ⵎⴰ ⴼⵔⴶⵏ ⴶⵢ ⵏ⵿ⵙⵍⵏ ⴾⵍ ⵏⵂⵢⵓⵏⵜ ⴹ ⵜⵜⵓⵤⵔⵤ ⵜⵗⵔⵙ⵿ⵜⵏⵜ ⴹⵗ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ⵜⵤⵔ ⵙⵙ⵿ⵜⵏ ⵍⵙ ⵓⵏ ⵜⵢⴼⵢⴰ ⴼⵍⵀⵙ ⵏⵙ «ⴾⵢ ⴾ ⵎⵍⵢ ⵓⵙ ⵂⴰ ⵏⵀⵢ ⵛⵏⵜ ⴹⴰ⵰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵎⵗ ⵓⴹⵏ ⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ⵀⵤ ⴼⵍⵀⵙ ⵗⵔ ⵀⵜⵓ ⵜⵏ ⴹⴰ ⵎⵍⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ⴶⵍⵏ ⵤⴰ ⵙ ⴹⵙⵏ ⴹⴶ ⵂⵏ ⵎⵏ ⵜⵤⵔ ⵏⴰ ⵍⵙ ⵓⵏ ⵜⵢⴼⵢⴰ «ⵎⵏ ⴹⴰ ⵎⴰ ⴹⵤⴶⴹⵍⵏ ⴹ ⵜⵓⵙⵍⵎⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ⵏⵙ ⴼⵍⵀⵙ «ⵓⵔ ⵜⵍⴰ ⴾⴹ ⵜⵤⴶⵤⵏⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ⵰» ⵏⵙ ⵍⵙ ⵓⵏ «ⵤⴶⵤⵏⵗ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ⵎⵔ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⵙⴹ ⵜⵓⵙⵀⴹⴹ ⵎⵍⵏ⵿ⴾⵢ ⵤⵀⵏ ⵏ⵿ⵜⴰ ⴹⴼⵍⵀⵙ ⴶⵤⵏ ⵎⵏ ⵙⵍⵎⵆⵓ ⴼⵍⵀⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ⴹⴰ ⴹⴰ ⵗⵙ ⴹⴶⵎⴹⵏ ⵎⵏ ⵏ⵿ⵜⴰ ⴹ ⴹⴾⵍ ⵏ⵿ⴼⵙ ⵏⵎⵍⵢ ⴼⵍⵀⵙ ⵀⵙ ⵜⵂⵏⵢ ⵍⵙ ⵓⵏ ⵎⵛⵏ ⴶⵍⴰ ⴹⵗ ⵜⵔⵢⵜⵏⵜ ⴾⵏⴰ ⵜⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ⴼⵍⵀⵙ ⵏ⵿ⵜⴰ ⵙ ⴹⵏⴶⵔⴰ ⵎⵏⵜ ⵂⴰ ⵗⵔⵎ ⵏⵤⵜ⵰ ⵙ ⵜⴶⵎⴹ ⵍⵍ ⴾⵍⵏ ⵜⴶⵓ ⴹⵗ ⵗⵔⵎⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵂⵔ ⵙⴰ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⵍⵜ ⵂⵔⵓⴹⴰ ⵙⵎⵂⴹ ⴼⵍ ⴶⵢ ⵏⵎⵏ ⵏⵜⵍⵀ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ⴾⴰ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ⴶⵎⵢ ⴹⵗⵙ ⴹⵙⴶⵓ ⵛⵔⴰ ⵙ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵗⵔⵎ ⵏ⵿ⴹⵎⵙ ⵎⵙⵏⵏ ⵛⵔⴰ ⵜⴾⴼⵏⵏ ⵜⵔⴶⵜ ⵙⵙ ⵙ ⴶⵔⵓ ⵢⵜⴹⵏ ⴶⵔ ⵤⴰ ⵎⴹⵏ ⵓⵍⴰ ⵛⴹⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵗⵢⵙⴰ ⵜⵏⴾⵔⴹ ⵍⵓⵢⵜⵏ⵿ⴹⵓ ⵙ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ⴾⴰ ⵤⴰ ⵗⵔⵎ ⵏ⵿ⴹⵎⵙ ⵙ ⵜⵏⵂⵤ ⵓⵔ ⵙⵍⴰ ⴶⵏ ⵙ ⴼⵍⵙ ⵀⵍⵤⵜ ⵏⵔ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ⴼⵜⵆⵜ ⵙⵍⴰ ⵢⵎⵙⵍⵢ ⵓⴰ ⴹⵙⵏⵏ «ⵜⵍⵜ ⵜⵍⵜ ⵎⴼⵍ ⵙ ⴹⵜⵤⵗⵤⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ⵏⵙ ⵜⵍⵜ «ⵎⴰ ⵜⵎⵙⵗ ⵎⵍⵢ⵰» ⵙⵍⴰ ⵢ ⵓⴰ ⴹⵙⵏⵏ «ⵏⴾ ⵗⵢⵙⴰ ⵓⴰ ⵜⵤⵗⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ⵀⴹⴹ ⴶⵤ ⵗⵔⵎ ⴹⴾⵜⵎⵍ ⵓⵙ ⴾⵢⵓⵔ ⴶⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ⵎⴹⵏ ⵓⵏ ⴹⵓⵏⵏ ⴹⵜⵍⵜ ⵀⴹⴹⵏ ⵜⴶⴹⵍⵙⵏ ⵜⵔⵎⵆ ⵓⵍ ⵙⵍⵏ ⵢⵎⵙⵍⵢ ⵎⵛⵏ ⵓⵔ ⵂⵏⵢⵏ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ⵀⴹⴹⵓ ⵜⵍⵜ ⵔⴰ ⵛⵜⵓⵏⵜ ⵎⵛⵏ ⵏ⵿ⴹⵔⵙ ⵏⵢ ⵏⵓⵍⴰ⵰ ⴾⵏ⵿ⴹⵀⴰ ⵙ ⵀⵤⵏ ⵎⴹⵓⵏⵜ ⴼⵙⵏⵜ ⵍⵓⵢⵏ⵿ⵜⵓ ⵂⵔ ⴹⵔⵙ ⴶⵤⵏ ⴹⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ⵂⵔ ⴶⴰ ⴾⵔⴹ ⴹⵏ ⵓⵔ ⵂⵏⵢ ⵔⵜ ⵓⵔ ⵜⵛⴰ ⵤⴰ ⵓⵔ ⵛⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ⵎⵔⵏ ⴹⵎⵙ ⵂⵜ ⵏⵍⴾⵎ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏ ⵙⵎ ⵏⵏⵢⵙ⵰ ⵗⵔⵢ ⵎⵍⵢ ⴹⵗ ⵜⵔⴶⵜ ⵏⵙ «ⵏⵏⵢⵙ⵰» ⴾⵓⵏⵙ ⵏⵙ «ⵏⴾ ⴹⴰ ⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ⵏⵙ ⵎⵍⵢ «ⵏ⵿ⴾⵔ ⵜⵙⵓⵍⴰ ⴹⵜⵔⵢⵜ ⵜⵙ ⵜⵓⵏⵓ \"ⵜⴰ ⵜⵗⴹⵜ\" ⵜⴾⵗ ⵂⵏ ⵏⵢⵂⵤⴰ ⵜⵙⵙ⵿ⵜⵏⵗ ⴹⵍⵙ ⵏⵗⵔⵎ ⵏ⵿ⵜⵔⵙⴰ ⴶⵏ ⵙⵎ ⵜⵍⵜ ⴹ ⵜⵏ⵿ⵙⵢⵢ ⴹⵗ ⵍⵓⵆ ⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ⵎⵔⵏ ⵏⵢ ⴹⵗ ⵜⵔⴶⵜ ⵍⵙ ⴶⵏ ⵙⵎ ⵏⵏⵢⵙ ⵙ ⵜⴹⵙⴰ ⵙⵓⵔ⵿ⵜⵓ ⴼⵙⵏⵜ ⴼⵍ ⵜⴹⵆⵍ ⵙⵓⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ⵜⵤⵔ ⵏⵙ ⵏⵏⵢⵙ «ⵢⴰ ⵎⵍⵢ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵏⵢ ⵙⵍⵏ ⵏⵍⵙ ⴹⵢ ⴹⵜⵍⵀⵙ⵿ⵜ ⵜⴶⵜ ⵜⴰ ⵙⴾⵏⴰ ⵎⵤⴹⴶⵏⴾ ⵓⵏ ⵂⵏⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ⴹⴰ ⴹⴰ ⵍⴰ ⵜⵔⴶⵜ ⵏⵀⵤ ⵏⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵜⵔⵏⵏ ⵙⵙⵎⵏⴾ ⵎⵔⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵜⴾⴼⵏⵏ ⵜⵔⴶⵜ ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ⵎⵛⵏ ⵏⵙ ⵎⵍⵢ «ⴶⵍⵓ ⵍⵙ ⴹⵢ ⵏⴾ ⵜⵙⵏⴼⵔⵏ ⴼⵍ ⴹⵎⵍ ⵢⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⵎⵏⴾⵍⵏⵙⵏ ⵎⵍⵢ ⴹⵗ ⵢ ⴾⵍⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ⵏⴾ ⵎⵏⵏ ⵙ ⴹⵙⵤⴶⵗ ⵤⵗⵤⵀ ⴾⵍ ⵓⴰ ⵜⵓⵔⵏ ⴼⵍ ⴹⵍⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ⵜⵤⵔ ⴶⵍⴰ ⵏⵏⵢⵙ ⵂⵔ ⴹⵏⵙⴰ ⵂⵏ ⴶⵤⵜⵓ ⵏⵢ ⵜⵍⵜ ⵙⵓⵔ⵿ⵜⵓ ⴼⵙⵏⵜ ⵏⵙ «ⵎⴹⵔⵢⵏⵏ ⵜⵍⵜ ⵎⵍⵢ ⵗⵢⵙⴰ ⵓⴰ ⴹⴾⵏⴼⵍⵍⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⴰ ⴹⵜⴶⵗ ⵏ⵿ⵜⴰ ⴹⴹⵤⵎⵤⵍⵏ ⴼⵍ ⴾⵢⴹⵆⵍ ⵙⵓⴹⵏⴾ ⴹⵏⵢⴾⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵗ ⴹⵔ⵿ⵜⴾⵏ ⵔⵜⵏ ⵍⵏⵏ ⴹⵜⴼⵔⵏ⵿ⴾⵓⵏ ⴹⵗ ⵛⵜⵓⵏ ⵏ⵿ⵜⵍⵜ ⵜⵤⵔ ⵆⵍ⵿ⵜⴹ ⵙⵓⴹⵏⵜ⵰ ⵀⴹⴹ ⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ⴹⴼⵔ ⵓⵏ ⵜⵛⴰ ⵆⵍⵏⵜⴹⵓ ⵜⵗⵔⴹⵏⵜ⵰ ⴶⴰ ⵔⵜ ⵏⴹⵏ ⵗⵔ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵂⵏⵏ ⴹⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ⵜⵔⵎⴹ ⵙ ⴾⴰ ⵜⵍⵜ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗⵙⵏ ⵎⵍ ⵙ ⵗⵢⵙⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ⵙⵎⴾⵍⵍ ⵓⵏ ⵙⵢⵜⴹⵏ ⴹ ⴶⵏⵏ «ⴾ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵙ ⴾⵍⴰ ⵀⵏⵀⵢ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵜⵜⵔⵏⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⴹⵗ ⵢⵔⵙⵍⵎ ⵂⵍⴾⵏ⵰ ⵓⵔⴶⵗ ⵓⵔ ⵜⴹⵓⵢ ⵙⵗⵔⵎ ⵓⴰ ⵔ ⵜⵏⵀⵤ ⵍⵓⵢⵜⵏ ⵙ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ⵎⵛⵏ ⵜⵍⵜ ⵏ⵿ⵜⴰ ⵜⵙⵂⵜ ⵤⵤⴶⵤⵏⵜ⵰ ⵓⵔ ⵙⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵎⵙ ⴹⵙⵏⵏ ⴹⵗ ⵙⴾⵏⵢ ⵓⴰ ⵜⵏⵜⴶⵓ ⵙ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ⵙ ⵔⵓ ⵜⵍⵜ ⴹⵗ ⴹⵎⵙ ⵏⵎⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵗⴼ ⴼⵍ ⴹ ⴶⵏ ⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ⵎⵛⵏ ⵜⵎⵍⵙ ⵓⵏ⵰ ⵓⴹⵏ ⴹⵗ ⵜⵔⴰ ⵏ⵿ⵜⵏⵗⵢⵏⵜ ⵙ ⴹⵙⵏ⵿ⴾⴹⵏ ⵂⴹ ⵤⵍ ⵗⵔ ⵎⵓⵏ ⵏⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ⵙ ⵂⴹ ⵢⵏ ⵏ⵿ⴾⵔⵏ ⵏⵜⵍⵀⵏⵜ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵤⵎⵎ ⵤⵓⵔⵏ ⵔⴹⴼⵏ ⴹⵗⵙ ⵗⵏ ⵤⵤⵀⵏ⵿ⵜⵓ ⴼⵍ ⴶⵏⴰ ⵓⴰ ⵂⴹⵏ ⵏⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ⵙ ⵙⴰ ⵜⵍⵜ ⵢⵔⵙⵍⵎ ⴶⵎⵢ ⴹⴹ ⵔ⵿ⵜⵢ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵎⵛⵏ ⵓⴼⵏ⵿ⵜⵓ ⴾⵜⵏⵙⵏ ⴼⵍⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵤⴶⵤⵏⵏ ⵙ ⵢⵏ ⴹⵗⵙⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ⵀⵤⵜⴹⵓ ⵀⵔⵏⵀⵙ ⵙ ⵎⵏⵜ ⴹⵓ ⴹⵔⵙ ⵙ ⵏⵎⵤⵍ ⵜⵤⵔ ⴶⵙⵏ ⵙⵍⵏ ⴾⵍ ⵏⵎⴾ ⵓⵙ ⵏⵢ ⵜⵍⵜ ⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵜⵔⵢⵜ ⵏ⵿ⴹⵎⵙ ⴹⵓⵍ ⵓⴰ ⴹⵙⴶⴰ ⵎⵍⵙⵏ ⴹⵗ ⴶⵢ ⵓⴰ ⴶⴰ ⵙⵍⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⴹⵎⵙ ⵓⵔ ⵜⵍⴰ ⵢ ⵙ ⵜⵜⵂⴰ ⵜⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ⵍⵓⵆ ⵓⴹⵢ ⴹⵔⵙⵏ ⵔ⵿ⵜⵢ ⵜⴹⵓ ⴹⵔⵙⵏ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ⵜⴶⵓ ⵙⵍⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵛⵢ ⵓⵍⴰ ⵜⵙⴰ ⵏⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ⵜⵎⵛⵓⵍ ⵜⵍⵜ ⴹⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵛⵓⵍⵏⵏ ⵜⵍⵢⵏⵏ⵿ⵜ ⵜⵎⵤⵗ ⴹⵗ ⴹⵔⵙⵏ⵰ ⴹ ⴶⵎⵢⵏ ⴹⴶⵢ ⵏⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ⵙ ⵙⵍⵏ ⵎⴹⵔⵢⵏⵜ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⴹⵓⵏ ⴹⵔⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⵙⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⵎⵔⵏ ⵙⴾⵏ⵿ⵜⵓ ⵓⵏ ⵜⵔⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ⵤⵎⵏ ⵏ ⴶⵔⵓⵏ ⴹⵗⵙⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴹⵍⴾⵏⵙⵜⵏ ⵍⵈⵔ ⴹⵗ ⴾⵍ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⴹ ⵓⵏ ⴶⵍⵍⵢⴰ ⴹ ⵓⵏ ⵙⵎⵔⵢⴰ⵰ ⵜⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵍⴾⵏⵙⵜⵏ ⵜⴶⵏⵜ ⵎⵤⵍⵏ ⵙⵗⵎⵔⵏⵏ ⵎⵍⵢ ⵜⵜⵢⵏⵜ ⴹⵗ ⵙ ⵜⵍⵍ⵿ⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ⵍⵍ ⵤⴰ ⵀⵜⵔⵙ ⴾⵍ ⴾⵜⵏⵜ ⵂⵔ ⵔⵙ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵍⴹⴰ ⴼⵍ ⴹ ⵏⵢ ⵎⵤⴹⴶⵏ ⵓⵏ ⴹⵗⵙ ⵈⵙⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ⵏⵢ ⴹⵗⵙ ⵍⵙ ⴶⵏ ⵙⵎ ⵏⵢⵙ ⴶⵏ ⵜⵎ ⵍⵏ ⴹⵀⴹⵏ ⵓⵔ ⴾⵍⴰ ⴶⵎⴹ ⵜⵙⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ⵏⵙ ⵀⵜⵔⵙ «ⵏⵢⵙ ⵀⴹⴹ ⵜⴹⴰ ⵜⵙⵜⵏⴾ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵤⵤⵢⴾⵢ⵰» ⵀⴹⴹ ⵏⵢⵙ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ⵏⵢⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⵗⵔⵎ⵿ⵜ ⵏⵍⴹⴰ ⴹⵓⵏ ⵤⵓⵗ ⵓⵏ ⵛⵔⵏ ⵜⵤⵔ ⵂⴹⵏ⵿ⴹⵓ ⵙⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵔⵎ ⵏⵢⴼⴰ ⵜⵈⵙⵔ ⴹⵗⵙ ⵜⵏⵍⴾⵎ⵿ⵜ ⵏ⵿ⵗⵢⵙⴰ ⵜⴶⵜ ⵙⵎ ⵜⵀⵜⴰ ⵍⵎⵗⵏⴰ ⵏⵙⵎ ⵓⴰ ⴹⵗ ⵜⵍⵢⵏⵏ⵿ⵜ ⴹⵔⴾⵙ ⵍⵎⵗⵏⴰ «ⵜⵏⵔ⵿ⵜ»⵰ ⵓⵔ ⵜⴶⵎⴹ ⵔ ⵙⴶⵢ ⵏⵎⵤⵍⵏ ⵍⵗⵏⵏ ⴹⵜⴾⵜⵓⵏ ⵢ ⵎⴹⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⵜⵔⵏ ⵀⵜⵜ⵰ ⵜⵜⵓⵛⵔⴹ ⵜⵜⵓⵙⵏ⵿ⵙⴰ ⴹⵗ ⵂⵏ ⵓⵏ ⴼⵍⴰ ⵏ⵿ⵙⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ⴹⴹ ⵎⵙ ⵙ ⵍⴹⴰ ⵓⵔ ⵜⴶⴶ ⵢⴼⴰ ⵙ ⵙⵍⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵂⵏⵏ ⵢⴼⴰ ⵙ ⵀⵜⵔⵙ ⵂⴰ ⵍⴹⴰ ⵤⵎⵤⵍⵏ ⵙⵔⵙ ⵛⵏ ⵎⴹⵏ ⴼⵍ ⴹ ⵜⵏ⵿ⵙⵢⵏ ⵜⵏ⵿ⴹⴾⵓ ⵜⵔⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ⵏ⵿ⴾⵔ ⵀⵜⵔⵙ ⴹⵓ ⴹⵔⵙⵏ⵰ ⵙ ⴹⵏⵙⴰ ⵓⵢⵏ⵿ⵜⵓ ⵙ ⵙⵔⵓ ⵓⴰ ⵜⵂⴰ ⵜⵗⵙⴰ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⴾⵏⵜⴹⵓ ⵜⴹⴹⵏ ⵛⵏ ⵙ ⵓⵔ ⴹⵔⵏ ⵎⴹⵏⵙⵏⵜ ⵂⵍⵏⵜ ⵙⴾⵏⵏⵜⵓ ⵛⴾⴹⴾⴹⵏ ⴹⵙⵍⵙⴰ ⵓⵢⴹ ⴹⵙⵏⵜⴶⴰ ⴹⵔⴾⵙ ⵂⵔⵓⴰ ⵜⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ⵙⵔⴹⵗ ⵀⵜⵔⵙ ⵓⴹⵏ ⴾⵍ ⴶⵔⴼⵜ ⴹ ⵜⵜⵔ⵰ ⵙ ⵙⵏ⵿ⴹⴰ ⵜⵓⵜⵔⵢⵏⵜ ⵎⵍⵍⵢⴹⵓ ⵜⵗⵙⴰ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵀⴰ ⵏⴰ «ⵜⵀⵜⴰ ⵏ⵿ⴾⵔⴹ» ⵜⵤⵔ ⵜⵔⴰ ⵛⵜⵓⵏⵜ ⵜⵏⵢ ⵀⵜⵔⵙ ⵜⵆⵎⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ⵤⵍⵙⵏ ⴼⵙⵏⵜ ⵍⵍⵙ ⵙ ⵜⵀⴹⵢ ⵎⵔⵏ ⵗⵔⴹⵓ ⵎⵤⴹⴶⵏ ⴹⵜⴹⴹⵏ ⵛⵏ ⵙ ⵓⵔ ⴹⵔⵏ ⵎⴹⵏⵙⵏⵜ ⵙⴾⵏⵙⵏ⵿ⵜⵜ ⵜⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ⵜⵓⵙⵍⴰ ⵓⵏ ⴹⵗ ⵗⵔⵎ ⵏⵢⴼⴰ ⴾⵜⵏⵜ ⵜⵤⵔ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ⵂⴰ ⵀⵜⵔⵙ ⵢⴼⴰ ⵂⵔ ⵔⵓ ⵍⴰ ⵗⵔ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵙⵎⵗⵏ ⵙ ⵎⵙ ⵛⵗⵍⵏⵜ ⵛⴼⵍ ⵏ⵿ⴶⵛⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⵂⵢ ⵍⵙ ⵢⵏ ⵏ⵿ⴾⵍⵔⵎ ⴶⵏ ⵙⵎ ⴾⵔⵏⵍⵢⵙ ⵎⵙ ⵢⵏ ⴹⵗ ⴾⵀⵜⵏⵜⵏ ⵓⵏ ⵤⵔⵏⵏ ⵢⴶⵏ ⵏ⵿ⵙⵌⵜⵏ ⵓⵙ ⵜⵓⵏⵓ «ⵜⵍⵢ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ⵎⵙ ⵍⵙ ⴾⵙⴹⵏ ⵎⵛⵏⴰ ⵗⵀⴹⵜⵓ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⵏⵂⵏⵜ ⴾⵜⵏⵙⵏ ⵜⴶⵓ ⵛⴾⵜⵓⵏ ⴶⵜⵏⵏ ⵢ ⴾⵍⵍⵢⵂⴹ ⴼⵓ ⴹⵗ ⵜⵜⵔ ⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ⵙ ⵤⵍ ⵢⵏ ⵗⵔ ⵎⴹⵍ ⵏ⵿ⴾⵔⴹ ⵍⵓⵆⵏ ⵓⵏ ⵜⵤⵔ ⵏⴼⵍⵍⵙⴹⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵛⵏⴰ ⵏⵢⵜⵓ ⵙ ⴹⴶⵤ ⵂⵏⵜ ⵏⵙ «ⴾⵔⵏⵍⵢⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ⵔⵎⵗ ⴾⵔⵏⵍⵢⵙ ⴶⵔ ⵛⵜⵓⵏ ⴹⵗ ⵏ⵿ⴶⵍⵙ ⵏⵙ «ⵢⴰ ⵎⵛⵢ ⵎⴰ ⵜⵔⵗ⵰» ⵏⵙ ⵏ⵿ⴶⵍⵙ «ⵛⵓⵜⵔⵓⵏⴾ ⴹⵜⴾⵜⵓⵏⴾ ⴶⵤⵢⵏⵜ ⵙ ⵎⵛⵏⴰ ⵆⵀⵍ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ⴹⵗ ⴹⵢ ⵎⵔⴹⴰ ⵤⵎⵤⵍ ⵎⴹⵏ ⵙⵗⵔⵎ ⵏⵢⴼⴰ ⴹⴾⴹⴹⵓⵏ ⴹⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵙⵎⵗⵏ ⵙ ⵜⵓⵏⵓ ⵀⵜⵔⵙ ");
INSERT INTO ttqt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ⵏⴼ⵿ⵜⵗⵏ ⵢ ⵙⵎⵗⵏ ⵓⴰ ⵛⴼⵍⵏ ⴶⵛⴾⵏ ⵙⵂⵏⵜ ⵂⴰ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ⴼⵍ⵿ⵜⵓ ⵏ⵿ⴶⵍⵙ ⵓⴰ ⴹⵙⵛⵓⵍⵏ ⵗⵙ ⵗⵔⴹⵓ ⵎⵛⵗⵍⵏⵜ ⵛⵏ ⴹⵢⵏ ⴹⵗ ⵙⵌⵜⵏ ⵓⵏ ⵛⵛⵗⵍ ⵎⵙⵏ ⵓⴹⵏ ⴾⵙⴹⵏ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ⵙⵗⵍⵙⵏ ⵓⴰ ⴶⵏ ⴾⵍ ⵎⵔⵏ ⵤⵎⵤⵍ⵿ⵜⵏ ⵙ ⵢⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ⵂⵤⵏⵏ ⵗⵔⵎ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵙ ⵓⵔ ⵀⵜⵔⵙ ⴼⵍⴰ ⵏ⵿ⵜⵗⵤⵎ⵿ⵜ ⵜⵢⵏ ⵏⵎⵙ ⵏⵤⵍ ⴼⵍ ⴹ ⴶⵓ ⵛⵓⵜⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ⵜⵜⵔ ⴹⵏ ⴹⴰ ⵙ ⵜⴶⵤ ⴶⵍⴾ ⵙⴹⵔⵏ ⵜⵛⴰ⵰ ⵜⵓⴶⵏⵙⴹⵓ ⵎⵏ⵿ⵙⵓⵏ ⵙ ⵜⵜⵀⵤ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ⴶⴰ ⵌⵏⵓⵏ ⵙ ⵎⵔⵏ ⵜⵓⵙⵔⵙⴹⵓ ⴹⵗⵙⵏ ⵔⵜ ⵍⵏ ⴹⴼⵔ ⵤⵓⵔⵏ ⵜⵓⵜⴼⵏ ⵙⴾⵤⵜ ⵜⵙⵍⴾⴹⵏⵜ ⵂⵔ ⴹⵜⵙ ⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ⵂⵏ⵿ⵜⵓ ⵤⵏⴼⵏ ⵏⵎⴹⵔⵏ ⴾⵍ ⵓⵏ ⵌⵓⵏ⵿ⴾⵜⵏⵏ ⴼⵍ ⵎⴹⵍ ⴹⵎⵔⴹⵎⵔⵏ ⴹⴶⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ⵜⵤⵔ ⵙⵍⴰ ⵢⵎⵙⵍⵢ ⵢⵏ ⵙ ⴹⵙⵏⴰ «ⵀⵜⵔⵙ ⵏ⵿ⴾⵔ ⵜⴶⵤⵎⴰ ⵜⵜⵛⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ⵎⵛⵏ ⵏⵙ ⵀⵜⵔⵙ «ⴾⵍⴰ ⴾⵍⴰ ⵎⵍⵢ ⴹ ⵓⵔ ⴾⵍⴰ ⴹ ⵜⵛⵗ ⵈⵔⵎⵏ ⵓⵍⴰ ⵎⴹⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ⵍⵙ ⵜⵙⵍⵢ ⵢⵎⵙⵍⵏ ⵙ ⵏⴰ «ⵓⴰ ⵙⵈⵍⵍ ⵎⵛⵏⴰ ⵓⵔⴶⵗ ⴾⵢ ⵜⵤⴶⵏ ⵢ ⵈⵔⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ⵂⵔ ⴶⴰ ⵎⵙⵍⵏ ⵢⵓⵏ ⴾⵔⴹⵜ ⵜⵏⵓⵏ ⵎⵔⵏ ⵎⴹⴾⵍ ⴼⵔⵏ ⵙ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ⵂⵔⵓⴹⴰ ⵆⵏ ⵓⵏ ⵗⴼ ⵏⵀⵜⵔⵙ ⵙⵎⴹⵔⵏ ⴹⵗ ⵓⴰ ⵤⵆⵍ ⵍⵎⵗⵏⵏⵜ ⵏⵓⴰ ⴹⵙⴹⵏⴼⵍⵍⵏ ⴹⵏ ⵙ ⴹⵀⴹⴹⵏ ⵎⴹⵏ ⵓⵏ ⴹⵤⵎⵤⵍ ⴾⵔⵏⵍⵢⵙ ⴹⵗ ⵎⵢ ⵏⵂⵏ ⵏ⵿ⵙⵎⵗⵏ ⴹⴼⵔ ⵙ ⵙⵙ⵿ⵜⵏⵏ ⴹⴹ ⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ⵗⵔⵏ⵿ⴹⵓ ⵎⵙⵓⵙ ⵏⵂⵏ ⵙⵙ⵿ⵜⵏⵏ⵿ⵜⵏ ⴾⴹ ⴹⵏ ⴹⴰ ⴹ ⵤⵀⵜ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ⵂⵔⵓⴹⴰ ⵙⵎⴹⵔⵏ ⵀⵜⵔⵙ ⴹⵗ ⵓⴰ ⵤⵆⵍ ⵍⵎⵗⵏⴰ ⵏⵔⵜ ⵓⴰ ⴹⵙⴹⵏⴼⵍⵍⵏ ⵙ ⴹⵙⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ «ⵏⵢ⵰ ⵎⴹⵏ ⴹⵏ ⴾⵔⴹ ⴹⵔⴾ ⵙⵙ⵿ⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ⴹ ⵓⵔ ⵜⵤⵍⵢⵗ ⵢⵜⴹⵏ ⵀⴹⴹ ⵜⵤⵀⵗ ⵜⴹⵓⴰ ⴹⵔⵙⵏ⵰ ⴹ ⵏⴾ ⵜⵏ⵿ⴹⵤⵎⵤⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ⵜⵤⵔ ⵤⵀⵜⴹⵓ ⵙⵔⵙⵏ ⵀⵜⵔⵙ ⵏⵙⵏ «ⵏⴾ ⴹⴰ ⵙ ⵜⵙⴶⴹⵎ⵰ ⵎⴰ ⵎⵙ ⴹⵍⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⵓⵢⵏ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ⵏⵏⵙ «ⴾⵔⵏⵍⵢⵙ ⵓⵏ ⴾⵀⵜⵏ ⵏ⵿ⴾⵍⵔⵎ ⴹⵏⴹⵤⵎⵤⵍⵏ ⵎⵙⵏ ⵍⵙ ⵗⴹⵏ ⵏⵎⴾⵙⴹ ⵏⵎⵛⵏⴰ ⵙⵗⵎⵔⵏ⵿ⵜⵓ ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵙⵏ⵰ ⵏ⵿ⵜⴰ ⵙ ⵏⴼⵍⵍ ⵏ⵿ⴶⵍⵙ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⵎⵔ⵿ⵜⵓ ⵙⴾⵢⵙⴶⵎⵢ ⵜⵙⵗⵏ ⵂⵏⵜ ⴼⵍ ⴹ ⵙⵍⵓ ⵢⵓⴰ ⵤⴰ ⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ⵎⵔⵏ ⵤⴶⵤⵜⵏ⵿ⴹⵓ ⵀⵜⵔⵙ ⵙⵎⴶⵔⵜⵏ⵰ ⵙ ⴼⵓ ⴹⵓ ⴹⵔⵙⵏ⵰ ⴹⵓⵏ ⴹⵔⵙ ⵔⵜ ⴹⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵏⵗⵔⵎ ⵏⵢⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵓⴹⵏ ⵗⵔⵎ ⵓⵏ ⵆⵢⵙⵔⵢⴰ⵰ ⵙ ⴹⵏⵙⵏ ⴹⴰ ⵆⵍⵙⵏ ⴾⵔⵏⵍⵢⵙ ⵏ⵿ⵜⴰ ⴹⵎⵔⵓⵏⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⴹⵔ ⴾⵏⴰ ⵜⵎⴹⵓⴰ ⵙⵏ⵿ⵜⴰ ⵜⵏ⵿ⴹⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ⵙ ⵤⵎⴰ ⴹⵏⴶⵤ ⵀⵜⵔⵙ ⵂⵏ ⵙⵍⴾⴹⵙⴹⵓ ⴾⵔⵏⵍⵢⵙ ⴶⵔⴼⵜ ⵗⵔ ⴹⵔⵏⵜ ⵙⵌⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ⵎⵛⵏ ⵙⵀⴹⴹⵜⵓ ⵀⵜⵔⵙ ⵏⵙ «ⵀⴹⴹ⵰ ⵏⴾ ⴶⴹⵎ ⵗⵙ ⵎⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ⴶⵤⵏ ⵂⵏ ⵎⵛⵓⵍⵏ ⵙⵏ ⴹⵗⵙ ⵀⵜⵔⵙ ⵍⵌⵎⵗⵜ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ⵜⵤⵔ ⵏⵙⵏ «ⵜⵙⵏⵎ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵙ ⵙⵈⵔⵎ ⵍⵆⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵢⵢⵏ ⴹⵗⵙⵏ ⵜⵙⵆ ⵎⴹⵗ ⴶⵤ ⵏⵂⵏ ⵏⵓⴹⵏ ⵓⵔ ⵏⵎⵙ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ⵰ ⵎⵛⵏ ⵏⴾ ⵙⵙⵏⵢ ⵎⵛⵏⴰ ⴹⵗ ⵙ ⴹ ⵓⵔ ⴶⵗ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴹⴼ ⵏⵙ ⵢ ⵈⵔⵎⵏ ⵓⵍⴰ ⵎⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵙ ⴹⵜⵙⴶⵎⵢⵎ ⴾⵆⵓⵏ⵿ⴹⵓ ⴹⵢ ⴹⴰ ⵓⵔ ⴶⵗ ⵙⵔⵓ ⵓⵍⵢⵏ⵰ ⵎⵔⵏ ⵎⵔⴹⴰ ⵎⵍⵜⵢ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⴹⵜⵙⴶⵎⵢⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ⵏⵙ ⴾⵔⵏⵍⵢⵙ «ⵤⵍ ⵢⵏ ⵜⵜⵔⴰ ⴹⵗ ⵂⵏⵏ ⵍⴰ ⴹⵢ ⵎⵔⴹⴰ ⴾⵔⴹ ⴹⵏ ⵓⵔ ⵙⵍⵗ ⴶⵏ ⵙ ⴹⵜⵢ ⵀⴹⴹ ⵍⵙ ⵍⵙⵏ ⵙⵍⵙⴰ ⵀⵍⵤⵍⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ⵜⵤⵔ ⵏⵢ \"ⴾⵔⵏⵍⵢⵙ⵰ ⵜⵓⵜⵔⵢⵏⴾ ⵜⵆⵀⵍ ⵛⴾⵜⵓⵏⴾ ⴹⵗ ⵆⵀⵍ⵿ⵜⵏⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ⴹⵗ ⴹⵢ ⵤⵎⵤⵍ ⵙ ⵢⴼⴰ ⵜⵙⴶⵎⵢⴰ ⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵀⵜⵔⵙ⵰ ⵏⴼ⵿ⵜⵗ ⵢⵍⵙ ⴶⵏ ⵙⵎⵗⵏ ⵓⴰ ⵛⴼⵍⵏ ⴶⵛⴾⵏ ⵂⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ⵜⵤⵔ ⵙⴶⵎⵢⵆⵢ ⵜⵎⵤⵢⵜ ⵜⴹⵢ ⴹⴰ ⵍⵗ ⴹⵗ ⵙ ⴹⵜⵙⵗ⵰ ⵎⵔⵏ ⵎⵔⴹⴰ ⴾⵜⵏⵏⴰ ⵏⵍⴰ ⴹⴰ ⴹⵜ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵏⵙⵙⵎ ⵢⵔⵜ ⴾⵍ ⵓⵙ ⴾⵢⵎⵔ ⵎⵍⵢ ⵙⴹⵏⵆⵜⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ⵛⵓⵍ ⵀⵜⵔⵙ ⵏⴰ «ⵎⵔⴹⴰ ⴶⵔⵗ ⵙ ⵜⴹⵜ ⴹⵗ ⵎⵙ ⵙ ⵎⵛⵏⴰ ⵓⵔ ⵤⵍⵢ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ⴾⵍⵔ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⴾⵙⴹⵏ ⵜⴶⵓ ⵓⴰ ⵗⴹⵏ ⵓⴹⵏ ⵓⴹⵢ ⴹ ⵜⵆⵀⵍ ⵎⵛⵏⴰ ⵜⵆⵍ ⵜⵓⵛⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ⵙⴾⴹⵓ ⴾⵍⵙⵔⵢⵍ ⵓⵍⵏⵜ ⵎⵙⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵍⵏⵏ ⵙⵍⵏ ⵏⵍⵈⵔ ⵓⴰ ⵂⴾⵓ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵓⵏ ⵎⵍⵢ ⵏⵓⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ⵜⵙⵏⵎ ⴹⵗ ⵓⴰ ⴶⵏ ⴹⵗ ⴾⵍ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵏ⵿ⵜⴹⵓ ⴹⵢ ⴹⵗ ⵓⵏ ⴶⵍⵍⵢⴰ ⴹⴼⵔ ⵜⵍⵈⵜⵀⵜ ⵜⴰ ⴶⴰ ⵢⵈⵢⴰ ⵢⵢⵜⴹⵏ ⴹⵗ ⵀⵜⵓ ⵏⵍⵎⵗ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ⴹⵎⴾ ⵓⵙ ⵙⴾⵏⴰ ⵎⵛⵏⴰ ⵢⵜⴹⵏ ⵙ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵙⵏⴼⵔⵏ ⵙ ⵜⵂⴾⵢ ⵜⴰ ⵜⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵔⵏⴰ⵰ ⵜⵙⵏⵎ ⴹⵗ ⴹⵗ ⵜⵍⵍ⵿ⵜ ⵜⴰ ⴶⴰ ⴾⵍ ⵜⵎⵤⵍ ⵍⵗ ⵤⵤⵢ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵗ ⵏⴹⴰ ⵀⵍⵙ ⴹ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⵏⴶⵢⵜ ⵓⴰ ⴶⴰ ⴾⵜⵏⵜ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⵢⵔⵙⵍⵎ ⴹⴾⵍ ⵙⴰ ⵂⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⵏ⵿ⵜⴰ ⵓⴰ ⵜⵓⵜⵢⵜⵢⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⵀⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⵤⵍ ⵓⵏ ⴾⵔⴹ ⴹⴼⵔ ⵀⵏⵜ ⴾⴼⵢ ⵜⵔⴶⵜ ⵏⴹ ⵜⵓⵏⵢ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⴾⵍ ⵜⵏⵢⵏⵏ ⴾⵍⵔ ⵓⵔ ⵜⵏⵢ ⵔ ⵛⴶⵢⵓⵏ ⵛⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⵂⵔⵓⴰ ⴹⵜ ⵍⵓⵆ ⵜⵏⵜⵎⵙⵏ ⵏⴾⵏⵢ ⵓⵏ ⴹⵔⵙ ⴹⵔⵓⵏⵏ ⵜⵜⵢ ⴹⵜⵙⵢ ⴹⴼⵔ ⵜⵏⴾⵔⴰ ⵜⴰ ⴹⴶⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ⵜⵤⵔ ⵎⵔⵏⴰ ⵗⵢⵙⴰ ⵙⴹ ⵏⵎⵍ ⵍⵏ⵿ⵌⵍ ⵢⵢⵜⴹⵏ ⵏⴶⵢⵜⵙⵏ ⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⴶⵢ ⵎⵛⵔⵗ ⵏⴹ ⵜⵍⴰ ⵓⴹⵏ ⴶⵔ ⵤⴰ ⵓⵏ ⴹⵔⵏⵏ ⵓⵍⴰ ⵓⵏ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ⵏ⵿ⵜⵏ ⴹⴰ ⵙ ⴶⵢⵏ ⵏⵀⵜⵏ ⴾⵍ ⵙ ⵢ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⴹ ⴶⵔⵓ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵜ ⵙⵙⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵀⵜⵔⵙ ⵙ ⴹⵤⵀⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴼⵍ ⵍⵌⵎⵗⵜ ⴾⵜⵏⵜ ⵜⴰ ⵜⵙⵙⵎⵜ ⵢ ⵜⵍⵈⵜⵀⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ⴾⵏⴰ ⵓⵏ ⵙⵎⴾⵍⵍ ⵙ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⴹⵓⵏⵏ ⴹⵀⵜⵔⵙ ⵙ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⴰ ⴶⵔⵓⵏ ⵙⴶⵜ ⵜⵂⴾⵜ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ⴼⵍⵙ ⵙⵍⵏⵙⵏ ⵛⵓⵍⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵎⵍⵏ ⴹⴾⵍ ⵏⵎⵛⵏⴰ⵰ ⵜⵤⵔ ⵏⴰ ⵀⵜⵔⵙ ");
INSERT INTO ttqt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«ⵓⴾ ⵎⴰ ⵤⴶⴹⵍⵏ ⵢⵢⵜⴹⵏ ⴶⵏⵏ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴶⵔⵓ ⵓⴰ ⴹⵙⵏⴶⴰ ⴹ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ⵎⵔⵏ ⵎⵔ ⵙⴹ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⴹⴼⵔ ⵓⵏ ⴶⵎⵢⵏ ⴹⵗ ⵀⵜⵔⵙ ⵗⵔⵙⵏ ⴶⵓ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ⵙⵍⵏ ⵏⵎⵤⵍ ⴹⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⵙ ⵍⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵤⴶⵤⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵙⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ⵍⵓⵆ ⵓⴹ ⴶⵤⵢ ⵀⵜⵔⵙ ⵙ ⵢⵔⵙⵍⵎ ⵛⵓⵍⵏ ⴼⵍⵙ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵜⴼⵏⵏ ⵍⵗⴹⵜⵏⵙⵏ ⵜⵏ ⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ⵏⵏⵙ «ⵎⵏⵎⴾ ⵙ ⵜⵜⴶⵤⴰ ⵂⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵏ⵿ⴾⴹ ⵓⵍⴰ ⵜⴹⵔⵓ ⴹⵔⵙⵏ ⵎⵏ⵿ⵙⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ⵜⵤⵔ ⵙⵗⵍⵙⵏ ⵀⵜⵔⵙ ⵓⴰ ⴶⵏ ⴾⵍ ⵓⵏ ⵏⵜⵢ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ⵜⵜⵔⴰ ⴹⵗ ⵗⵔⵎ ⵏⵢⴼⴰ ⵙ ⴹⵜⵀⵤ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⴼⵍⵍⵢ ⵔⵜ ⵢⵏ⵰ ⵔⵜ ⵓⴰ ⵜⵓⵙⵔⵙⴹⵓ ⴹⵗ ⵌⵏⵓⵏ ⵍⴰ ⴹⴼⵔ ⵤⵓⵔⵏ ⵜⵓⵜⴼⵏ ⵙⴾⵤⵜ ⵜⵙⵍⴾⴹⵏⵜ ⵂⵔ ⴹⵜⵢ ⴹⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ⵙⵓⴹⴰ ⴹⵗⵙ ⵤⴶⵤⴹⵆⵓ ⵏⵢⵗ ⴹⵗⵙ ⵂⵔⵢ ⴹⵜⵓⵆⵙ⵿ⵜ ⴹⵎⵔⴹⵎⵔⵏ ⴹⴶⴹⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ⵜⵤⵔ ⵙⵍⵗ ⵢⵎⵙⵍⵢ ⵓⴰ ⴹⵏⵏ \"ⵀⵜⵔⵙ ⵏ⵿ⴾⵔ ⵜⴶⵤⵎⴰ ⵜⵜⵛⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ⵎⵛⵏ ⵏⵗⵙ \"ⴾⵍⴰ ⴾⵍⴰ ⵎⵍⵢ ⴹ ⵎⵏⵏ ⵓⵔ ⴾⵍⴰ ⵜⴶⵤ ⵔⵜ ⵈⵔⵎⵏ ⵓⵍⴰ ⵢⵏ ⵎⴹⵙⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ⵍⵙⴰ ⵜⵙⵍⵢ ⵢⵎⵙⵍⵏ ⵙ ⵏⴰ ⴹⵗ ⵌⵏⵓⵏ \"ⵓⴰ ⵙⵈⵍⵍ ⵎⵛⵏⴰ ⵓⵔⴶⵗ ⴾⵢ ⵜⵤⴶⵏ ⵢ ⵈⵔⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ⵂⵔ ⴶⴰ ⵎⵙⵍⵏ ⵢⵓⵏ ⴾⵔⴹⵜ ⵜⵏⵓⵏ ⵎⵔⵏ ⵜⵓⵔⴾⵀⵏ ⵓⵏ ⴾⵜⵏⵜ ⵙ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴹⵀⴹⴹⵏ ⴾⵔⴹ ⵎⴹⵏ ⵙⵂⵏ ⵓⴰ ⴹⵗ ⵙⴶⵏⴰ ⵙⵔⵢ ⴹⵎⵤⵍⵏⵏ ⴹⵗ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ⵜⵤⵔ ⵏⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵔⵙⵏ ⴹⵓⴰ ⴹⵢ ⴹⴰ⵰ ⴹ ⵓⵔ ⵤⵍⵢⵗ ⵢⵜⴹⵏ⵰ ⴹⵓⴰ ⴹⵗ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵙⴹⵙ ⵓⵏ ⵂⵔ ⵏⴶⵤ ⵂⵏ ⵏⵍⵙ ⵓⴰ ⴹⴹⵙⴶⵎⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ⵙⵗⵍⵏⴰ ⵎⴾ ⵓⵙ ⴹⵙⵏⴼⵍⵍ ⵏ⵿ⴶⵍⵙ ⴹⵗ ⵂⵏⵜ ⵀⴹⴹ ⴹⵜⵙ ⵏⵙ \"ⵤⵎⵤⵍ ⵓⴹⵏ ⵙⵗⵔⵎ ⵏⵢⴼⴰ ⵢⴹⴾⴹⴹⵓ ⴹⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ ⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ⴹⴾⴶⵓ ⵎⴶⵔⴹ ⵙⵔⴾ ⴹⵤⵓⵢⵏ ⴼⵙⵏ ⴾⵢ ⴹⵗⵢⵓⵏⴾ ⴾⵜⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ⵂⵔⵓⴹⴰ ⵓⵔ ⵂⴶⴰ ⵛⵓⵍⴰ ⵙ ⴼⵍⵙⵏ ⴹⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵤⵀⵢ ⵓⴰ ⴼⵍⵏⴰ ⴹⴶⴰ ⵏⴾⵏⵢ ⴹⵗ ⵜⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ⵜⵤⵔ ⴾⵜⵗⴹⵓ ⵜⵏⴰ ⵜⴰ ⴶⴰ ⵎⵍⵢ \"ⵢⵈⵢⴰ ⵎⵏ ⴹⵗ ⵙⵍⵎⵗ ⵢⵜⴹⵏ ⵎⵛⵏ ⴾⵓⵏⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵤⴰ ⵜⵜⵓⵙⵍⵎⵗⵎ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⴶⵙⵏ ⵎⵛⵏⴰ ⵜⵂⴾⵜ ⵤⵏ ⵜⴰ ⴹⵏⵗⴶⴰ ⵙ ⵏⵤⴶⵤⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⴰ ⵎⵙⴰ ⵏⴾ ⵙ ⴶⴹⵍⴰ ⵢ ⵎⵛⵏⴰ ⴶⵢ ⵏⵓⴰ ⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ⵙ ⵜⵙⵍⴰ ⵍⵌⵎⵗⵜ ⵢ ⵙⵍⵏ ⵓⵏ ⵜⴼⵙ⵿ⵜⴰ ⵜⵤⵔ ⴹ ⵜⵎⵍ ⵎⵛⵏⴰ ⵜⴶⵏⵓ «ⴹⵗ ⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⴰ ⵙⴼⵔⴾⵏ ⵎⵛⵏⴰ ⴹ ⵜⵀⵏ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵤⵓⵤⵓⵤ ⵍⵗⵤⵀ ⵓⴰ ⴹⵤⵔⵢⵏ ⵜⵓⵏ⵿ⵗⴰ ⵏⵙ⵿ⵜⴼⵏⵙ ⴶⵍⵏ ⵓⵢⴹ ⵂⵔ ⵙⵏ ⴾⵍ ⵓⵏ ⴼⵏⵙⵢⴰ ⵓⵢⴹ ⵙⵏ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵆⵀⵔⵙ ⵓⵢⴹ ⵙⵏ ⵗⵔⵎ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ⵰ ⵎⵍⵏ ⵓⵍ ⵏⵎⵛⵏⴰ ⴶⵙ ⵢ ⴾⵍⵍⵢⵂⴹ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵢⴹ ⴹⵗⵙⵏ ⵏⴾⵍ ⵓⵏ ⵆⵀⵔⵙ ⴹ ⵓⵏ ⵆⵔⵓⵏ ⵙ ⴹⵏⵙⵏ ⵗⵔⵎ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⵛⵓⵍⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵛⵓⵍⵏⵏ ⵜⵍⵢⵏⵏ⵿ⵜ ⵎⵍⵏⵙⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ⵜⴹⵂⵍ⵿ⵜⵏ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⴹⵗ ⵓⴰ ⵜⴶⵏ ⵜⵤⵔ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵀⵏ ⵍⴾⵎⵏ ⵢⵎⵍⵢ ⵎⵙⵏ ⵎⵏⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ⵙⵍⵏ ⵏⵓⵏ ⵓⴹⵏⵏ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵂⵜ ⵢⵔⵙⵍⵎ ⵜⵤⵔ ⵜⵤⵎⵤⵍ ⵀⵔⵏⵀⵙ ⵙⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ⵙ ⴹⵏⵙⴰ ⵏⵢ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵜⴰ ⴹⵜⵤⵀⵜ ⴹⵏ ⴹⵓⵜ⵰ ⵜⵤⵔ ⴶⵙⵏ ⴾⵜⵏⵙⵏ ⵏⵙⵈⴰ ⵎⵙⵏ ⴹ ⵍⴾⵎⵏ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵀⵔⵏⵀⵙ ⵍⵙ ⵍⵗⵏ ⵎⵙ ⵜⴾⵔⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵂⵜ ⴹⵗ ⵤⴶⵤⵏⵜ⵰ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⵓⵢⴹ ⴶⵜⵏⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ⵎⵔⵏ ⴾⴰ ⵀⵔⵏⵀⵙ ⵗⵔⵎ ⵏ⵿ⵜⵔⵙⴰ ⵙⴶⴹ ⵢ ⵜⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ⵙ ⵜⴶⵔⵓ ⴹⵓⴹⵓ ⴹⵔⵙ ⵙⵏ⵿ⵜⵢⵈⵢⴰ⵰ ⴶⵏ ⴹⵗⵙ ⵓⵜⵢ ⵗⵔⴹⵏ ⵙⵗⵏ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵂⵏⵏ ⵍⴾⵏⵙⵜ ⵜⵏ ⵙⵙⵗⵔⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ⵗⵔⵎ ⵓⵏ ⴹⴰ ⵏⵏ⵿ⵜⵢⵈⵢⵏ⵿ⴹⵗ ⵙⵏ⵿ⵜⵏ ⵢⵜⴹⵏ ⵜⵗⵔⵢ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵙⵙⵎ ⵓⵏ «ⵍⵎⵙⵈⵜⵏ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ⴹⵏⵏ ⴹⴰ ⴹⵗ ⴶⵎⴹⵏ ⵏⵀⵜⵏ ⵓⵢⴹ ⵢⵔⵙⵍⵎ ⵔⵙⵏ ⵙⵗⵔⵎ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ⵀⴹⴹ ⵢⵏ ⴹⵗⵙⵏ ⴶⵏ ⵙⵎ ⴶⵀⵙ ⵎⵍ ⴹⵜ ⵍⵓⵆ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵍⴾⵎ ⴹ ⴶⵓ ⵍⵤ ⵍⵀⵙⵏ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ⵰ ⵍⵤⵏ ⴹⴰ ⴹⵗ ⵙⴹⵓ ⵙⵎⴾ ⵓⵙ ⵜⵎⵍ ⴹⵗ ⵤⵎⵏ ⵏⵎⵏⴾⵍ ⴾⵍⵓⴹⵢⵙ ⵆⵢⵙⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ⵜⵤⵔ ⵏⵎⵔⴹⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⴼⵍ ⵜⵏⵜ ⵜⵎⵙⵜ ⴹ ⵔⴶ ⴾⵢⵏ ⴹⵗⵙⵏ ⵓⴰ ⴼⵔⴶ ⵙⵙⵓⵢⵏ ⵜⴹⵂⵍ⵿ⵜ ⵜⴰ ⵢ ⵎⴹⵔⵢⵏⵙⵏ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ⴶⵏ ⵓⵏ ⴹⴰ ⴶⵏ ⵛⵔⴶⵜⵏⵙⵏ ⴹⵗ ⴼⵙ ⵏⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⵢⵜⵏⵜⵓⵢⵏ ⵢ ⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵂⵜ ⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ⵤⵎⵏⵏ ⴹⴰ ⴹⵗ ⵙⵏ⵿ⵜⴰ ⵎⵏⴾⵍ ⵂⵔⴹ ⵤⵗⵤⵀ ⵏⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵏⵍⴾⵏⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ⵙⵙⵏ⵿ⵗⴰ ⵙ ⵜⴾⵀⴰ ⵢⵆⵀ ⵓⵏ ⵎⴹⵔⵢ ⵏⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ⵙ ⵏⵢ ⵙ ⴶⵎⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵙⵜⵔⵎⵙ ⵀⵜⵔⵙ⵰ ⵜⴶⵓ ⵓⵏ ⴹⵏ ⵏⵎⴹ ⵓⴰ ⴹⵗ ⵜⵜⵏ ⵢⵜⴹⵏ ⵛⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ⵙⵙⴶⵢ ⴹⵗ ⴾⵙⵓ ⵙⵓⵆⵓ ⵢ ⵎⵔⵓ ⵙⵌⵜⵏ ⴹⵙⴹⵙ ⵜⵜⵏⵎⵤⵔⵢⵏⵏ ⵙⴾⵤ ⴾⵤ⵰ ⵜⵙ ⴹⵙⵛⵔⵗ ⴹⵜ ⵓⴹⵏ ⴾⵍ ⴹⴼⵔ ⵎⴹ ⵓⵏ ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ⵂⴰ ⵀⵜⵔⵙ ⴾⵙⵓ ⴹⵏ ⵍⴾⵏⵙⵜ ⵏ⵿ⵜⴰ ⵜⴹⴶⵤ ⵓⵍⵏ ⵜⵜⵏ⵿ⵙⵢⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ⵙ ⵂⴹ ⵓⴹ ⵤⴼⵓ ⵛⵔⵗⵙ ⵂⵔⴹ ⵏ⵿ⵙⴰ ⵀⵜⵔⵙ ⴶⵔ ⵛⵏ ⵙⵌⵜⵏ ⵜⵜⴼⵏⵏ ⵙⵛⵏ ⵙⵙⵔⵏ ⵀⴹⴹⵏ ⴹⵗ ⵎⴶⵤⵏ ⵓⵢⴹ ⴹⵜ ⵎⵢ ⵏ⵿ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ⵓⵍⴰ ⵂⴶⵏ ⵏⴼⵍⵍⴹⵓ ⵏ⵿ⴶⵍⵙ ⵢⵏ ⵏⵎⵍⵢ ⵎⵍⵓⵍⵓ ⴹⴶ ⵓⴰ ⴹⵗ ⵏ⵿ⵙⴰ ⵀⵜⵔⵙ ⴹⵗ ⵎⵙ ⵏ⵿ⴾⵙⵓ⵰ ⵜⵤⵔ ⴹⵙ ⵏ⵿ⴶⵍⵙ ⵜⵙⴶⴰ ⵏⵀⵜⵔⵙ ⵙⵏ⵿ⴾⵔ⵿ⵜⵓ ⵏⵙ «ⵀⴹⴹ ⵜⵔⵎⴹ⵰» ⵔ⵿ⵜⴾⵏ ⵙⵙⵔⵏ ⵓⵏ ⵙ ⴾⵔⴹⵏ ⴼⵙⵏⵜ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ⵂⵔⵓⴰ ⵏⵙ «ⵤⵍⴶ ⵙⵍⵙⵏⴾ ⵜⵙⵍⵗ ⵗⵜⵎⵏⴾ⵰» ⴶⴰ ⵀⵜⵔⵙ ⵓⵏ ⴹⴰ⵰ «ⵎⵔⴹⴰ ⵤⵍⴶ ⵀⵔⵏⵤⵏⴾ ⵜⵍⴾⵎⵗⴹⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ⴶⵎⴹⵓ ⵀⵜⵔⵙ ⵍⴾⵎ ⵢⵏ⵿ⴶⵍⵙ ⵓⵔ ⵙⵏ ⵙ ⵓⴰ ⵜⴶⵓ ⵏ⵿ⴶⵍⵙ ⴹⵏ ⵜⴹⵜ ⵎⵙ ⵗⵍ ⵜⵔⴶⵜ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ⴾⵢⵏ ⴼⵍ ⵎⴶⵤⵏ ⵓⵏ ⵤⵔⵏⵏ ⴹⵓⵏ ⵍⵏⵏ ⴹⵏⴶⵙⵏ ⵎⵔⵏ ⵙⵏ⵿ⴹⵓ ⵜⵙⵂⵔ⵿ⵜ ⵏ⵿ⵜⵤⵍⵢ ⵜⵙⵓⴹⵜ ⵙⴰ ⵙⵔ ⵗⵔⵎ⵰ ⵜⵏⵍⵎ ⴹⵜⵙⵏ ⵛⵏ ⵎⵏⵜ ⵔⴹⵗⵏ⵰ ⵙⵓⵍⵏ ⴹⵜⵔⵢⵜ ⵢⵜ ⵓⵍⴰ ⵂⴶⵏ ⴼⵍ⵿ⵜⵓ ⵏ⵿ⴶⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ⵜⵤⵔ ⴶⵤ ⵀⵜⵔⵙ ⵏⵓⵍⵜ ⵏⵗⴼⵏⵜ ⵏⴰ «ⵎⵔⴹⴰ ⴾⵙⵗ ⵛⴾ ⴹⵗⵙ ⵎⵍⵢ ⵎⵛⵏⴰ ⴹⵤⵎⵤⵍⵏ ⵏ⵿ⴶⵍⵙⵏⵜ ⴾⵙⴹⵓ ⴹⵗ ⴼⵙⵏ ⵏⵎⵏⴾⵍ ⵂⵔⴹ ⴹⵜⵍⵀⵙ⵿ⵜ ⴾⵍ ⵜⵙ ⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵜⴶⵔⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ⵎⵔⵏ ⴶⵔⴰ ⵜⵗⵔⵏⵜ ⴾⴰ ⵂⵏ ⵏⵎⵔⵢⵎⴰ ⵜⵏ ⵏⴰ ⵏⵢⵈⵢⴰ ⵓⵙ ⵜⵓⵏⵓ ⵎⵔⴾⵙ⵰ ⵎⵏⵢⵏ ⵗⵔⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵜⵏ⵿ⵙⵢⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ⴾⵓⴾⵓ ⵎⵢ ⵏⵗⵍⴰ ⵜⴶⵍⴹⵓ ⵜⵎⵛⵗⵍ⵿ⵜ ⵜⴶⵜ ⵙⵎ ⵗⴹⴰ ⵢⴹ ⵜⵙⵏ ⵓⴰ ⵎⵙ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ⵙ ⵜⵤⴹⵢ ⵎⵙⵍⵢ ⵏⵀⵜⵔⵙ ⵓⴰ ⵜⴶⴰ ⴹⵗ ⵜⴹⵓⵜ ⴹⴶ ⵏ⵿ⴹⵙ⵿ⵜⵍⵎ ⵜⵤⵍ ⵜⵆⵍ ⵎⵙ ⵏⵂⵏ ⵜⵎⵍ ⵙ ⵀⵜⵔⵙ ⵍⴰ ⴹⵜ ⵎⵢ ⵏⵗⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ⵏⵏⵙ «ⴾⵎ ⵎⵙⴾⵍ ⵜⴶⵗ⵰» ⵎⵛⵏ ⵜⵤⵤⵢⵔⵙⵏ ⴹⵗⵙ ⵏ⵿ⵜⴰ ⴹⵗ ⵓⵏ⵰ ⵎⵔⵏ ⵏⵏⵙ «ⴹⵗ ⴹⵢ ⵏ⵿ⴶⵍⵙⵏⵜ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ⴶⵏⵏ ⵓⵏ ⵀⵜⵔⵙ ⵏ⵿ⵜⴰ ⵜⴾⵓⴾⵓⵙⵏ ⵎⵢ ⵏⵗⵍⴰ⵰ ⵙ ⵍⵎⵏ ⵏⵢⵏ⵿ⵜⵓ ⴶⴰ ⵙⵔⵙⵏ ⵓⵏ ⵙⵎⴾⵍⵍ ⵍⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ⵙⴹⴶⵏⵙⵏ ⵙⴼⵙⵏⵜ ⴹ ⴼⵙ⵿ⵜⵏ ⵜⵤⵔ ⵎⵍⵙⵏ ⵜⵎⵓⵜ ⴾⵍ ⵜⵙ ⵜⴹⴾⵙ ⵎⵍⵢ ⵎⵛⵏⴰ ⴹⵗ ⴾⵙⵓ⵰ ⵏⵙⵏ ⴹⵗ «ⵎⵍⵜ ⴹⵢ ⵢ ⵢⵆⵀ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⵂⴹⵜⵏⵏ⵰» ⵎⵔⵏ ⴼⵍ⵿ⵜⵏ ⴾⴰ ⴹⴶ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ⵙ ⴼⵓ ⵜⴶⴰ ⵜⵏⵌⵔⵓⵢⵜ ⵍⵀⵙⵜ ⴹⵗ ⵙⵌⵜⵏ⵰ ⴾ ⵢⵏ ⵙⵙ⵿ⵜⵏ ⵎⴹⵏⵜ ⴹⵓⴰ ⴶⴰ ⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ⵙ ⵜⴹⵀⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵜⵙⵙⵓⴹ ⵂⵔⴹ ⵙⵙ⵿ⵜⵏ ⵙⵌⵜⵏ ⵓⵏ ⵜⴶⵤⵏⵏ ⵎⵔⵏ ⵎⵔ ⵙⴹ ⵜⵓⵏ⵿ⵗⵏ ⴾⵔⵤ⵰ ⴹⴼⵔ ⵓⵏ ⴶⵎⴹ ⵂⵔⴹ ⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ ⵤⴶⴹⵢ ⴾⴰ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⵢⴹⵗⵙ ⴶⵓ ⵜⵎⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ⵓⵏ ⵙ ⵜⴶⵓ ⵂⵔⴹ ⵂⵢ ⵍⵂⵎ ⵍⵀⵙⵏ ⵏⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⵏ ⵜⵔ ⴹ ⵓⵏ ⵙⴹⵏ⵰ ⴹⵂⵍ⵿ⵜⵏ ⵀⵍⵙ⵿ⵜⵙ ⵓⵏ ⵎⵛⵓⵔ ⵏⵂⵔⴹ ⵏⵎⵏⴾⵏ ⵤⵎⵤⵍⵏ ⵙ ⵂⵔⴹ ⵍⵎⵓⴾⵍⵏⵙⵏ ⴼⵍ ⴹⵔⵙ ⴾⵏⵏ ⴼⵍⵙ ⴾⵍⵏⵜ ⴹⴶⵎⴹⵏ ⵙⴹⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ⵙ ⴹⵙⴰ ⵤⵍ ⵓⴰ ⵜⵓⵙⵏⴼⵔⵏⵏ ⵤⵍⴶ ⵂⵔⴹ ⵙⵍⵙⵏⵜ ⵓⵏ ⵜⵗⵎⵔ ⵜⵤⵔ ⵆⵎ ⴼⵍ ⵜⵈⵓⵜⵏⵜ ⵜⵏ ⵜⵗⵎⵔ ⵎⵔⵏ ⵛⵓⵍ ⵢ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ⴹ ⵙⵗⵔⵏ ⵢⵜⴹⵏ ⴶⵏⵏ «ⵎⵙⵍⵢ ⵓⴰ ⵏ ⵎⵍⵢ ⵢⵏ ⵓⵔⴶⵗ ⵏ ⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ⵓⵍⴰ ⵂⴶⵏ ⵓⵜⵓ ⵏ⵿ⴶⵍⵙ ⵏⵎⵍⵢ ⴼⵍⵙ ⴶⵢ ⴶⴰ ⵎⵏⵜ ⴹⵗ ⴹⴶ ⵏⵎⵛⵏⴰ ⵓⵔ ⴶⴰ ⵢⵎⵍⵢ ⴹⴾⵍ ⵓⴰ ⴹⵔ ⵂⵔ⵰ ⵜⵤⵔ ⵜⵛⵏⵜⵓ ⵜⵓⴾⵓⵏ ⵀⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ⵓⵍ ⵏⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⴶⵍⴰ ⵜⵓⵤⵓⵤ ⵜⴶⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ⵎⵔⵏ ⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⵙ ⵗⵔⴹⵏ ⵛⵗⵍ ⵓⴰ ⵜⵏ⵿ⴹⵓⵢⵏ ⵙⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵆⵍⵏ ⵙⵙ ⴹⵂⵏ ⴹⵓⵏ ⴹⵢⵈⵢⴰ ⵓⵙ ⵜⵓⵏⵓ ⵎⵔⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵂⵜ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⵂⵏ⵿ⵜⵜ ⵏⵀⵜⵏ ⴹⵎⵙⵙⵗⵔⴰ ⵎⵙⵏⵏ ⵀⵔⵏⵀⵙ ⴹⵙⵎⵗⵏ ⵓⵙ ⵜⵓⵏⵓ \"ⴾⵓⵍ\" ⴹⵍⵆⵢⵙ ⵓⵏ ⴾⵍ ⵏⵆⵔⵓⵏ ⴹⵎⵏⵂⵏ ⵓⴰ ⵏⵎⴹⵓⵍⵏ ⴹⵎⵏⴾⵍ ⵂⵔⴹ ⴹⵗ ⵂⵏ ⵢⵏ⵿ⴹⴰ ⵎⵔⵏ ⴹⵜⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ⵤⵍ ⵢⵏ ⴹ ⵎⵏⵢⵏ ⵗⵀⴹⵏ ⵎⵍⵢ ⵤⵎⵏ ⴹⵗ ⵏⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ «ⵙⵓⵔⵜⵢ ⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⴶⵏⴰ ⴼⵍ ⴹ ⴶⵏ ⵛⵗⵍ ⵓⵙ ⵜⵏ⵿ⴹⵗⵔⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ⵤⵎⵏ ⴶⵏ ⵛⵓⵜⵔⵓⵏ ⵜⵤⵔ ⵎⵔⵏ ⵙⵓⵔⵏ ⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⴼⵙⵏⵙⵏ ⴶⵏⵙⵏ ⵛⵓⵜⵔⵓⵏ ⴹⴼⵔ ⴹⵢ ⵙⴶⵍⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ⵙⴾⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⵗⵔⵎ ⵏ⵿ⵙⵍⴾⵢⴰ⵰ ⴶⵤⵏ ⴹⵗⵙ ⵗⵍⵍ ⵏⵎⵏ ⴾⵏ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵆⵀⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ⵙ ⵙⵏ ⵗⵔⵎ ⵏ⵿ⵙⵍⵎⵏ ⴹ ⵎⵍⵏ ⵓⵍ ⵏⵎⵛⵏⴰ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⴹⵓ ⴹⵔⵙⵏ ⵢⵈⵢⴰ ⵓⵙ ⵜⵓⵏⵓ ⵎⵔⴾⵙ⵰ ⵍⵍⵙⵏ ⴹⵂⵍ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ⵔⵤⴶⵏ ⵆⵀⵔⵙ ⵙⵏⵆⵀⵏ⵿ⵜⵓ ⵂⵔ ⵙⵏ ⵗⵔⵎ ⵏⵀⴼⵙ⵰ ⴹⵏ ⴹⴰ ⴹ ⵎⵏⵢⵏ ⴹⵍⵙ ⵢⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵙⵎ ⵀⵔⵗⵢⵙⴰ ⵏⵎⵛⵗⵓ ⴶⵏⵏ ⵏ⵿ⵜⴰ ⵏⵀⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ⵎⵔⵏ ⵙⵗ ⴹⵙⵔⵌⵢⵙ ⵀⵍⵙ ⵓⵏ ⵏⵈⴾⵎ ⵏⴾⵍ ⵎⵙⵏ ⵓⴹⵏ ⵍⵏ ⴶⵔⵢ⵰ ⵙⴶⵎⵢ ⵎⵤⵔ ⵓⴰ ⵀⵔⵏⵀⵙ ⴹⵜⵍⵜ ⴼⵍⵙ ⴾⵏⴰ ⵙⵏⵂⵍ ⵏ⵿ⵜⵔⴰ ⵏⴹ ⵙⵍⵓ ⵢⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ⵎⵛⵏ ⵏ⵿ⴾⵔ ⵍⵢⵎⵙ ⵓⵏ ⵎⵛⵗⵓ⵰ ⵓⵏ ⴹⴰ ⵎⵙⵏ ⵍⵎⵗⵏⴰ ⵏⵙⵎⵏⵜ ⴹⵗ ⵜⵍⵢⵏⵏ⵿ⵜ⵰ ⵆⵍ ⵍⴹⵏⵙⵏ ⴹ ⴶⵎⵢ ⴹⴹ ⴶⴹⵍ ⵢⵏⵈⴾⵎ ⵓⵏ ⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ⵜⵤⵔ ⵌⵌⵏ⵿ⵗⵍ ⴹⵗⵙ ⵜⵍⵜ ⵙ ⵜⵓⵏⵓ ⴹⵗ ⵀⵍⵙ ⴶⵔⵓⵏ ⵙⴶⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ⵏⵙ «ⴶ ⵛⵢⵜⵏ ⵤⵏ⵿ⴶⵓ ⵏⵔⵜ ⴾⵍ ⵓⴰ ⵗⴹⵏ⵰ ⵓⵔ ⵜⵍⴰ ⵤⵏⴼ ⵏ⵿ⵜⴾⵔⵙ ⴾⵢⵓⵔⵏⵂⴰ ⵎⴾⵔⵙ ⵏⵏⵍⵀⵙ ⵜⵎⵙⵗ⵰ ⵎⵢ ⴹ ⵤⴰ ⵜⵎⵤⵢⵗ ⴹⴶⵎⵢ ⵏⵙⴼⵔⵗ ⵏ⵿ⵜⵔⵢⵜ ⵜⵗⴹⵜ ⵏⵎⵍⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ⵎⵔⴹⴰ ⵏⵢ ⴼⵍⴾ ⵙⵏ⵿ⵙⵓ ⵎⵍⵢ ⴼⵙⵏⵜ ⵜⴹⵔⵗⵍⴰ⵰ ⴹ ⵜⴶⵗ ⵤⵎⵏ ⵓⵔ ⵜⵍⵙⵗ ⵏⵢ ⵏⵏⵔ ⵏ⵿ⵜⴼⴾ⵰» ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⴼⵍⵙ ⴶⵏⵜ ⵛⵢⵢ ⴹⵍⵎⵜ ⴼⵍⵙ ⵎⴹⵍ ⵜⵤⵔ ⴹ ⴹⵤ ⴶⵎⵢ ⵢ ⵜⵍⵓⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ⵙ ⵏⵢ ⵏⵈⴾⵎ ⵓⵏ ⵓⴰ ⴶⵏ ⴹⵏ ⵤⴶⵤⵏ⵰ ⵙⵎⴾⵍⵍ ⵙⵔⵙ ⵙⵙⵗⵔⵢ ⵓⵙ ⵙⵍⴰ ⴹⵗ ⵀⵜⵓ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ⴶⵤ ⵀⵍⵙ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⵎⴹⵓⵏⵜ ⴹⵗ ⵀⴼⵙ ⴾⵏ ⵗⵔⵎ ⵏⵀⵔⴶ ⵂⵏ ⴾⵍ ⵏⵀⵏ⵿ⴼⵍⵢⴰ⵰ ⴹⵏ ⴹⴰ ⴹⵔⵙⵏ ⵎⵤⵢ ⵢⵈⵢⴰ ⵓⵙ ⵜⵓⵏⵓ ⵎⵔⴾⵙ ⵆⵍ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⴶⵎⴹⵏ ⵀⵔⴶ ⴾⵏ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⵓⵏ ⴾⵍ ⵏⵀⵙⴹⵢⴰ⵰ ⵙ ⴶⴰ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴶⵤⵏ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵆⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ⵙ ⵜⵓⵗⵔⵏ ⴹⴶⵏ ⴹⵗ ⵜⵓⵔⵜ ⴹⵍⴾⵜⵀⵏ ⵓⵏ ⵏⵀⵜⵏ ⵙⴰ ⵂⴹⵏ ⵏⵏⵙⵏⵏ ⵎⵤⵔⵏ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ «ⵎⴹⵔⵢⵏⵏⴰ ⴾⴹ ⵜⵍⵢ ⵀⵜⵓ ⵙ ⵤⴰ ⵜⵙⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵢⵜⴹⵏ ⵜⴶⵎ⵿ⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ⵀⴹⴹ ⵀⵍⵙ ⵙⴹⴶⵏⵙⵏ ⵙⴼⵙⵏⵜ ⴹ ⴼⵙ⵿ⵜⵏ ⵎⵔⵏ ⵏⴰ «ⵎⴹⵏ ⵓⵏ ⴾⵍⵙⵔⵢⵍ ⴹⴾⵓⵏⵢ ⵓⵏ ⵎⴾⵙⴹⵏ ⵏⵎⵛⵏⴰ ⵙⵙⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵢ ⵏ⵿ⵜⵎⵜⵢ ⵜⴰ ⴹⴰ ⵏⵙⵔⵢⵍ ⵙⵏⴼⵔⵏⵏ ⵎⵔⵓⵏⵏⴰ ⵜⵤⵔ ⵙⴶⵜⵏ ⴹⵗ ⵍⵏ ⵓⵏ ⴹⵗ ⵎⵙⵏ ⵏⴼ⵿ⵜⵗⵏ ⴹⵗ ⴾⵍ ⵏⵎⵙⵔ ⴹⴼⵔ ⴹⵢ ⴾⵙ⵿ⵜⵏ⵿ⴹⵓ ⴹⵗⵙ ⵙ ⵜⵔⵏⴰ ⵏⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ⴶⴰ ⴹⴶ ⵏⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⵛⵏ ⴶⵏ ⴹⵗ ⵜⵏⵔⵢ ⵤⵤⵢⴹⵔ ⴹⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ⴾⴼⵏ ⵙ ⵔⵤⵏ ⵙⵢⵜ ⵜⵓⵛⵜⵏ ⴹⵗ ⴾⵍ ⵏ⵿ⴾⵏⵏ ⴾⴼⵏ ⴾⵍⵏⵙⵏ ⴶⵤ ⵜⴾⵙⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ⵓⵏ ⴾⵜⵏⵜ ⴹⴶ ⵏⴾⵤⵜ ⵜⵎⴹ ⵏⵓⵜⵢ ⴹⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⴹⵗ ⴶⴰ⵰ ⴹⴼⵔ ⵓⵏ ⴹⵙⵏⵤⵤⵔ ⵍⵆⵍⵜⵏ ⵜⵆⵍⵏⵙⵏ ⵎⵏⴾⵍⵏ ⵂⵔ ⵤⵎⵏ ⵏⵏⵀⵢ ⵙⵎⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ⵤⵎⵏⵏ ⴹⴰ ⴹⵗ ⴶⵎⵢⵏ ⵎⵏⴾⵍ ⵜⵤⵔ ⴾⴼⵏ ⵎⵛⵏⴰ ⵜⵍⵜ ⴶ ⴾⵛ ⵓⵏ ⵜⵓⵛⵜ ⵜⵏ ⵀⵏⵢⵎⵏ⵰ ⴶⴰ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵓⵜⵢ ⵈⴾⵎ ⴼⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ⴹⴼⵔ ⴹⵢ ⴾⵙ⵿ⵜⵓ ⵎⵛⵏⴰ ⴹⴰ ⵜⵗⵎⵔ ⴶⴰ ⴹⵓⴹ ⴹⵗ ⴹⴶⵏⵜ ⵙⵏ⵿ⵜⴰ ⴼⵍ ⵏⴰ ⵎⵛⵏⴰ \"ⴶⵔⵓⴰ ⴹⵓⴹ ⴶ ⵢⵙⵢ ⵎⵙⵏ ⵍⵙ ⵍⴾⵎⵏ ⵢ ⵜⵔⵏⵏ ⵓⴰ ⵤⵎⵤⵍⵏ ⵙ ⵜⵔⵏⵏ ⴾⵜⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ⵂⵢⵓⵏⵜ ⴹⵗ ⴹⴾⵙ ⵎⵛⵏⴰ ⵗⵢⵙⴰ ⵙⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵗⵍⵙ ⵓⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ ⵢ ⴾⵍⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ⴹⵜ ⵙⵏⵜ ⴹ ⴶⴰ ⵢⵈⵢⴰ ⵢ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ ⴾⵜⵏⵜ ⵙⵍⵏ ⵎⵙⵏⵏ ⴹ ⵜⵀⵏ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⵙⴾⵏⵓ ⴹⵢ ⵜⵜⵀⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ⵙ ⵀⴾ ⵢⵈⵢⴰ ⵢⵙⵏ⵿ⴹⵢ ⵏⵛⵗⵍⵏⵜ ⴹ ⴶⵏⵓ \"ⵎⴰ ⵜⵗⵍⵎ ⵎⴰ ⵎⵙⵗ⵰ ⵓⵔ ⵎⵙⵗ ⵤⴰ ⵓⴹⵏ ⵓⵙ ⵜⵗⵍⵎ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵍⴾⵎⴹⵓ ⵏⴾ ⵓⵔ ⵓⴹⴰ ⵓⵍⴰ ⵔⴰ ⵏ⵿ⵙⵗⵏ ⵏ⵿ⵗⵜⵎⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ⵎⴹⵔⵢⵏⵏ ⴾⵓⵏⵢ ⵓⵏ ⵂⵢⵓⵏ ⵏⵀⵔⵂⵎ ⴹⴾⵓⵏⵢ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵜⴾⵙⴹⵎ ⵎⵛⵏⴰ ⵙⵍⵏ ⵏⵍⵗⵍⵙ ⵓⴰ ⵏⴾⵏⵢ ⵙ ⵜⵏ⵿ⴹⵙⴾⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ⵎⵔⵏ ⵢⵜⴹⵏ ⵏⵢⵔⵙⵍⵎ ⴹⵎⵤⵔⵏⵙⵏ ⵓⵔ ⴶⵔⵏ ⵓⴰ ⵎⵙ ⵗⵢⵙⴰ ⵓⵔ ⴶⵔⵏ ⴹⵗ ⵓⵍⴰ ⴹⵗ ⵓⴰ ⵏⵏ ⵏⵀⵜⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵓⵏ ⵜⵓⵗⵔⵏⵏ ⴾ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵏ⵿ⴹⵏ ⵓⴰ ⵏⵏ ⵏⵀⵜⵏ ⵓⵏ ⴹⵢ ⵙⵀⵤ ⵓⴰ ⵜⴶⵏ ⵙⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ⵓⵔ ⴶⵔⵓⵏ ⵔⵜ ⵓⵍⵢⵏ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ ⵎⵛⵏ ⵂⵔⴾⴹ ⵓⵏ ⴶⵎⵢⵏ ⴹⵗ ⵀⵍⵜⵙ ⴹⵗⵙ ⵜⵓⴾⵙⵏ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ⵙ ⵙⵏ⵿ⴹⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ ⴾⵙⵏ⵿ⵜⴹⵓ ⴼⵍ ⵜⴶⵜⵓⵜ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⵤⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ⵎⵛⵏ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ⴶⴰ ⴹⵏ ⴶⵜⵏⵏ ⵜⵏⴼⵍⵍ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵙ ⴹⴹⵓⵏⵏ ⴹⵗ ⴾⵍ ⵏ⵿ⴶⵍⵍⵢⴰ ⴶⵤⵢⵏ ⵙⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ⵰ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵎⵔⴹⴰ ⵛⴶⵢⵓⵏⵜ ⵗⵔ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ⵎⵔⵏ ⵏⴾⵏⵢ ⴹⴰ ⵏⵜⴶⵓⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏⵏ ⵙⵍⵏ ⵓⵏ ⵙ ⵜⵓⴶⴰ ⵔⴾⵓⵍⵏⵙⵏ ⵢ ⵎⵔⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ⵔⴾⵓⵍ ⵓⵏ ⵙⵏ⵿ⴹⵏⵆⵓ ⵎⵛⵏⴰ ⵏⴾⵏⵢ ⵓⵏ ⵂⵢⵓⵏⵙⵏ ⵙⵙⵏ⵿ⴾⵔ ⵓⴰ ⴹⴶⴰ ⵗⵢⵙⴰ ⵙⵎⴾ ⵓⵙ ⴾⵜⵀ ⴹⵗ ⵜⵙⵔⵏⵜ ⵜⵏ ⵙⵏⵜⵜ ⵏⵤⵀⵔ ⵙ ⵏⴰ ⴹⵗ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ \"ⴾⵢ ⵀⵔⵔⵏ ⵆⵍⵗ ⵤⵍⴹⴰ ⵀⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ⵙⵏ⵿ⴾⵔ ⵓⴰ ⵜⴹⴶⴰ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⴰ ⵓⵔ ⵜⵔⴾⴰ ⵜⵗⵙⵏⵜ ⴹⵗ ⵤⴾⴰ ⵎⵍ⵿ⵜⵓ ⵎⵛⵏⴰ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ ⵜⵎⵓⵜ ⵜⴰ ⵙ ⵏⴰ \"ⴰ ⴾⵓⵏⴾⴼⴰ ⵔⵈⵎⵜⵏ ⵤⴹⴶⵏⵏ ⵜⴹⵏⵏ ⵛⵏ ⵙ ⴶⵗ ⵔⴾⵓⵍⵏⵙⵏⵜ ⵢ ⴹⵓⴹ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ⴾⵜⵀ ⴹⵗ ⵙ \"ⵓⵔ ⵤⴰ ⵜⵢⴰ ⵎⵤⴹⴶⵏⴾ ⵔⴾⵓ ⴹⵗ ⵤⴾⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ⴹⵓⴹ ⵎⵔⵏ ⴹⴼⵔ ⵙ ⵎⵤⵍ ⴹⵗ ⵤⵎⵏⵜ ⵙⵔⵜⵏ ⵓⵏ ⵈⵜⵙ ⵎⵛⵏⴰ ⵀⵜⵓ ⵜⵓⵏⵀⵍ ⴹⴶⵎⴰ ⵏⵎⵔⵓⵏⵜ ⵜⵔⴾⴰ ⵜⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ⵎⵛⵏ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴾⵔ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⵔ ⵜⵔⴾⴰ ⵜⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵙⵏⵜ ⵙ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏ ⵜⵜⵎⵍⵓⵏ ⵙ ⵜⵔⵢⵜⵏⵜ⵰ ⵎⵔⵏ ⵢ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⴹ ⴶⵔⵓ ⵜⴹⵔⴼⵜ ⴹⵗ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵙ ⵓⵔ ⴼⵔⴶ ⵜⴹⵔⴼⵜ ⴹⵗⵙⵏ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⴰ ⴹⵤⵀⵏ ⴼⵍ ⵏⵀⵢ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ⴹⵢ ⴼⵍ ⵤⴰ ⵜⵏ⵿ⴾⴹⵎ ⵢⴾⵓⵏⴶⵔⵓ ⵓⴰ ⵎⵍⵏ ⵏⵀⵜⵏ ⵙ ⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"ⵏⵢⵜ ⴾⵓⵏⵢ ⵓⵏ ⵏⵌⵀⵏ⵰ ⵙⵎⴾⵍⵍⵜ ⵜⵂⵍⴾⵎ⵰ ⴼⵍⵙ ⴹ ⵎⵤⵍⴰ ⵔⵜ ⴹⵗ ⵤⵎⵏⵓⵏ ⵙ ⴾⴹ ⴹⵓⵏⴶⴰ ⵓⴹⵏ ⵙⵍⵏⵜ ⴾⵍ ⴹⴰ ⵓⵔ ⴹⵙⵤⵜⵤⴶⵤⵏⵎ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ⴶⵎⴹ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵙ ⴹⵗⵙⵏ ⴶⵎⵢⵏ ⵢⵜⴹⵏ ⴹ ⴹⵍⵙⵏ ⵜⵓⵗⵍⵢ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵓⴰ ⴹⵤⵢⵏ ⴼⵍ ⴹⵙⵏⵛⵜⵏ ⴹⵗ ⴶⵢ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ⵙ ⵜⵓⵤⵓⵤ ⵍⵌⵎⵗⵜ ⴹⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜⵏⵏ ⴹⵢⵜⴹⵏ ⵓⵢⴹ ⴹ ⴹⵂⴹⵏⵏ ⵙⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ⵰ ⵎⵛⵓⵍⵏ ⴹⵔⵙⵏ ⴶⵎⵢⵏ ⴹⵗⵙⵏ ⴹ ⵤⵤⵓⵏ ⴹⵗ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵜⴰ ⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ⵙ ⴹⵗⵍⵢ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵜⴹⵓⴹⵓ ⵜⵛⵎ ⵏⵗⵔⵎ ⴾⵜⵏⵜ ⵢⴹ ⵙⵙⵎ ⵢⵓⵍ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ⵙ ⵏⵢⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵜ ⵏ⵿ⵜⵎⵜⵢ ⴶⵤⵏⵜⵏ ⵜⵙⵎⵜⵏ ⵍⵀⵙⵏⵏ ⴹ ⵙⵀⵂⵓⵏ ⵀⵍⵙ ⵔⵀⴹⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ⵜⵤⵔ ⵏⵙⵏ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵓⵔ ⵜⵂⴰ ⵜⵙⴰ ⵏⵓⵍⴰ «ⴾⵓⵏⵢ ⴹⵔⵔⵏ ⵙⴹⵓⵏⵜⵎⵍ ⵓⵍ ⵏⵎⵛⵏⴰ ⵙ ⵜⵤⵔⵜ ⵎⵛⵏ ⴹⴹ ⵤⵎⵙ ⵜⴶⵢⵎ ⵙⵔⵙ ⵓⵔ ⵜⵙⵂⵔⵎ ⵎⵏⵓⵏ ⴹⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵓⴹⵢ ⴹ ⵏⵎⵍⵍⵢ ⵙⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ⴼⵍⵙ ⵓⵏ ⴹⴰ ⵙ ⴹⵏⵗⵎⵔ ⵎⵍⵢ ⵎⵛⵏⴰ ⵙⵎⴾ ⵓⵙ ⵏⴰ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ \"ⴶⵆⵢ ⵏⵔ ⵢ ⵜⵓⵛⵜⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴼⵍ ⴹ ⵜⵓⵢⵗ ⵙⵍⵏ ⵏⵍⵗⵍⵙ ⵂⵔ ⴹⵜⵔⵤ ⴹⵏⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ⵙ ⵙⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵢⵓⵏ ⴹⵓⵏ ⵤⵤⵓⵔⵏ ⵓⵍ ⵏⵎⵍⵢ ⵎⵛⵏⴰ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙ ⵜⵓⵜⵙ ⴹ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ⴹ ⵜⵓⵤⵓⵤ ⵓⵍ ⵏⵎⵍⵢ ⴹⵗ ⴾⵍ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵔⴾⵎⵏ ⴹⵗ ⵜⴹⴹⵏ ⵛⵢⴹ ⵜⵓⵙⵗⵎⵔⵏⵏ ⵂⵏⵏ ⴹⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵎⵤⵔⵏ ⵏⵗⵔⵎ ⵓⵢⵏ⵿ⴹⵓ ⵙ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵜⵓⴹⴶⵤ ⵍⵀⵙⵏ ⵜⵤⵔ ⵙ⵿ⵜⵗⵏ⵿ⵜⵏ ⴾⵙⵏ⵿ⵜⵏ ⴹⵗ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ⵀⴾⵀⴾⵏ ⵀⵆⴰ ⵏ⵿ⴹⵔⵏⵙⵏ ⴹⵗ ⵀⵜⵓ ⵏⵗⵔⵎ ⵓⵏ ⵜⵤⵔ ⴾⵏ ⵗⵔⵎ ⵓⵏ ⴾⵏⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⴹⵢⵏ ⴹⴼⵔⵙⵏ ⴹⵗ ⵏ⵿ⵜⵢⵈⵢⴰ ⵎⵔⵏ ⴾⵏⵏ ⵜⴼⵍⵓⵙ⵿ⵜ ⴹⵏⵢⵜⵏ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ⴶⴰ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⴹⵗ ⵗⵔⵎ ⵏⴾⵏⵢⵎ ⵔⵜ ⵓⴰ ⴹⴰ ⵜⴶⵏ ⴼⵓⴹⴰ ⵜⵎⵙⵏ ⴶⵤ ⵏⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ⵜⵤⵔ ⴶⵏ ⴹⵗⵙ ⵓⵍ ⴹⵓⵢⵏ ⵙ ⵤⴶⵤⵏⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴹⴾⵍⵍⵢⵏⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴶⵢⵏⵏ ⵙⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⴶⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵔⴾⵎⵏ ⵙ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ⵂⵔⴾⴹ ⵓⵏ ⴶⴰ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵜⵎⵔ⵿ⵜ ⵜⴶⵜ ⴹⵗ ⴾⵏⵢⵎ⵰ ⵜⴶⵏ ⵓⵍ ⴹⵆⵏ ⵓⵔ ⵜⵂⴰ ⵜⵙⴰ ⵜⴶⵢⵏ ⴼⵍ ⵎⵍⵢ⵰ ⴾⴼⵏ ⵎⵍⵢ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵙⵜⴹⵏⵏ ⵜⴹⵜ ⵎⵙⵏ ⵙⵍⵏ ⵓⵏ ⵆⵍⵏⵏ ⵔⵈⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ⵎⵛⵏ ⵜⵤⵏ ⵜⵎⵜⵢ ⵏⵗⵔⵎ⵰ ⵓⵢⴹ ⵓⵔⵏ ⴶⵏⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵢⴹ ⴶⵏⴰ ⵓⵏ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ⵏ⵿ⴾⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⴾⵍⵍⵢⵂⴹ ⴹⵎⵤⵔⵏⵙⵏ ⵙⵎⵔⴾⵙⵏ ⴹ ⴶⵏ ⵜⵔⵛⵈⵛⴹ ⵍⵀⵙⵏⵏ ⵢ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵏ⵿ⵗⵏ⵿ⵜⵏ ⴾⵔⵤ ⵙ ⵜⴶⵔ ⵏ⵿ⵜⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ⵙ ⵙⵍⴰ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵓⵏ ⴶⵎⴹⵏ ⵗⵔⵎ ⵓⵏ ⴾⵏ ⵍⵙ⵿ⵜⵔⴰ ⴹⵔⵀ ⵎⵙⵏⵏ ⵗⵔⵎⵏ ⵏⴾⵍ ⵓⵏ ⵍⴾⵓⵏⵢⴰ ⴹⴾⵍⵏ ⵓⵏ ⵜⵏⵗⵍⵢⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ⴹⵗⵙⵏ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ⵗⵔⵎ ⵏⵍⵙ⵿ⵜⵔⴰ ⵂⵢ ⵍⵙ ⵏⵏⵀⴹⵏ ⵙⵙ ⴹⵂⵓ ⴹⴰ ⵎⵜⵏ ⴹⵔⵏⵜ ⵓⵔ ⴾⵍⴰ ⵜⵓⵔ ⵜⴾⵍ⵿ⵜⵏⵜ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ⵙ ⵤⵍ ⵢⵏ ⴹ ⵙⵙⵎ ⵢ ⵀⵍⵙ ⵛⵓⵍ ⴹⴾⵓ ⵀⵍⵙ ⵙⵙⵓⴹ ⵏⵢ ⴹⵗⵙ ⵙ ⵍⴰ ⵤⴶⵤⵏ ⵜⵤⵤⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ⵜⵤⵔ ⵏⵙ ⵙⴼⵍⴰ «ⵏ⵿ⴾⵔ ⵜⵗⴹⴰ ⵜⵀⴹⵢⵏⴾ⵰» ⴶⴹ ⵍⵙ ⴶⵤ ⵛⵏ ⵜⴾⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ⵙ ⵜⵏⵢ ⵜⵎⵜⵢ ⵜⴶⵜ ⵓⴰ ⴶⴰ ⵀⵍⵙ ⴹⵏ ⴹ ⴶⵏⵏ ⵢⵜⴹⵏ ⵙⴼⵍⴰ ⴹⵗ ⵓⵍ ⵓⵏ ⵜⵍⴾⵓⵏⵢⵙⵜ «ⵎⵍⵏ ⵂⵏⵏ ⵛⵛⵍⵏ ⵏ ⵢⵜⴹⵏ ⴼⵍⵏⴰ ⴹⵤⵀⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ⴶⵏ ⵢ ⵀⵔⵏⵀⵙ ⵙⵎ ⵏⵢⵏ ⴹⵗ ⵙⵏⵎⵏⵙⵏ ⵙ ⴶⵏⵏ «ⵤⵙ» ⵀⵍⵙ ⴶⵏⵙ ⵙⵎ ⵏⵢⵏ ⵙ ⴶⵏⵏ «ⵂⵔⵎⵙ» ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵛⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ⵏ⵿ⴾⵔ ⵍⵎⵎ ⵏⵙⵏⵎ ⵓⴰ ⴶⵏ «ⵤⵙ» ⵙ ⵂⵏ ⵏⵍⵗⵀⴹⵏⵜ ⵂⴰ ⵎⵢ ⵏⵗⵔⵎ ⵙⵙⵍⵓⵢⴹⵓ ⵙ ⵎⵓⵏ ⵏⵗⵔⵎ ⵤⴶⵔⵏ ⴹⵜⵜⵍ⵿ⵜⵍⴰ ⵏ⵿ⵜⵌⴶⵢ ⵔⴰ ⵏ⵿ⵜⴰ ⴹⵜⵎⵜⵢ ⵜⴶⵜ ⵜⵏⴶⵏ ⵛⵤⴶⵤⵎ ⵢ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ⵎⵛⵏ ⵙ ⵙⵍⵏ ⵏⵎⵤⵍ ⵓⵏ ⴶⵏⵏ ⵀⵔⵏⵀⵙ ⴹⵀⵍⵙ ⵓⵏ ⵤⵤⵔⵏ ⵛⴾⴹⴾⴹⵏⵙⵏ ⴼⵍ ⵎⵏⵙⵏ ⵤⵍⵏ ⵙ ⵜⵎⵜⵢ ⵜⴶⵜ ⴹⴾⵍⵏ ⵎⵙⵍⵏⵙⵏ ⵙⴼⵍⴰ ⴶⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«ⵈⴰ ⵎⴹⵏ⵰ ⵎⴰ ⵜⵜⴶⵎ ⴹⴰ⵰ ⵏⴾⵏⵢ ⵓⵔ ⵏⵎⵙ ⵔ ⵢⵜⴹⵏ ⵏⵛⵍⵜⵏⵓⵏ⵰ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵓⵏ⵿ⴹⵏⵓⵢ ⴼⵍ ⴹ ⵜⵎⵤⵢⵎ ⴹⵍⵗⵀⴹⴰ ⵏⵙⵏⵎⵏ ⵜⵜⵀⵎ ⵙ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵗⵍⵍ ⴹⵈⵍⴾⵏ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⴹⴶⵔⵓⵏ ⴹⵓⴰ ⵜⵏⵂⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ⴹⵗ ⵍⵏ ⵓⵏ ⵔⵓⵏⵏ ⵢⴰ ⵛⵎⵜⵓⵏ ⴾⵍ ⵍⴾⵎⵏⵜ ⵢ ⵜⵔⴰ ⵏⵎⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ⵎⵛⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴶⴰ ⵢ ⵎⵏⵜ ⵜⴶⵢⴰ ⴹ ⵙⴾⵏⴰ ⵍⵗⵏⵜ ⵎⵙⵏ ⵙⴼⵢ ⵓⴰ ⴹⵓⵏ⵿ⴹⵜⴶⵓ ⴾⵏⴾ ⴹⵗ ⵌⵏⵓⵏ ⵂⴾⵓⵏ ⵛⵎⵔⵏ ⵍⵗⵏⵏ ⴹⵙⴹⵔ ⵙⴼⵍⵓⵙⴾⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ⴶⵔⴹ ⵙ ⵙⵂⴹⵔⵏ ⵢⵜⴹⵏ ⵙ ⵀⵜⵓ ⵜⴰ ⴶⵏ ⴹⵏ ⴶⴹⵍⵏⵙⵏ ⴹⵙⵏⴶⵏ ⵛⵏⴶⵤⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ⵙⵏ⵿ⴹⵓ ⴾⵍⵍⵢⵂⴹ ⵓⵢⴹ ⴹⴼⵍⵏⵏ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⴹ ⵓⵏ ⴾⵏⵢⵎ ⵛⵓⵍⵏ ⵢⵢⵜⴹⵏ ⵂⵔ ⵜⵏⵙⵓⵔⵏ ⴶⵏⴰ ⵓⵏⵙⵏ⵰ ⴹ ⴶⵔⵏ ⵀⵍⵙ ⵙ ⵜⵂⵏ ⴹⴼⵔ ⴹⵢ ⵤⵔⵔⵓⵏ⵿ⵜⵓ ⵂⵔ ⴹⵔⵙ ⴶⵎⴹⵏ ⵗⵔⵎ ⵗⵍⵏ ⵀⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ⵎⵛⵏ ⵙ ⵙⵔⵙ ⴹⴹⵓⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵗⵍⵢⵗⵍⵢⵏ⵿ⵜⵓ ⵀⴹⴹⵓ ⵆⵍ ⵗⵔⵎ⵰ ⵙ ⴼⵓ ⴹⵓ ⴹⵀⵔⵏⵀⵙ ⴾⵏ ⵗⵔⵎ ⵏ⵿ⴹⵔⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ⵙ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⵍⴾⵎⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵢ ⵗⵢⵙⴰ⵰ ⵆⵍ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵗⵔⵎ ⵏⵍⵙ⵿ⵜⵔⴰ ⴹ ⵓⵏ ⴾⵏⵢⵎ ⴹ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ⴹ ⴶⵎⵢⵏ ⴹⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎⵏ ⵓⵏ ⴹ ⵤⵤⵓⵏ ⴹⵗ ⵜⵔⵢⵜⵏⵙⵏ⵰ ⵛⵓⵍⵏⵙⵏ ⵜⵍⵎⵏⵙⵏ ⴼⵍ ⵎⵏ ⵙⴹ ⵤⵤⵓⵏ ⴹⵗ ⵤⴶⵤⵏⵙⵏ ⴶⵏⵏⵙⵏ «ⵍⴾⵏ ⵙ ⴶⵤ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⴹⵓ ⴹⵜⵙⵙ⵿ⵜ ⵜⴶⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ⴾⵍⴾ ⵏⵍⴾⵏⵙⵜ ⵙⵏⴼⵔⵏⵏⵙ ⵎⵤⵔⵏ ⵛⴹⵓⵏ ⵓⵏ ⴹⵜⵓⵜⵔⵓⵏ ⴹⵤⵎ ⵎⵔⵏ ⴶⵏ⵿ⵜⵏ ⴹⵗ ⵜⵗⵍⴼ⵿ⵜ ⵏⵎⵛⵏⴰ ⴹⵢ ⵙ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ⴹⴼⵔ ⵓⵏ ⵔⵤⴶⵏ ⴾⵍ ⵓⵏ ⵀⵙⴹⵢⴰ ⴾⵢⵏ ⵙ ⵓⵏ ⵀⵏ⵿ⴼⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⵀⵔⴶ ⵎⵔⵏ ⵔⵙⵏ ⵙ ⵓⵏ ⵜⵍⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⵜⵍⵢⴰ ⵏⵎⴹⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⵗⵔⵎ ⵓⵙ ⵏ⵿ⵜⴰ ⵙ ⴾⵍⴰ ⴹⵗⵙ ⵜⵓⴶⵏ ⴹⵗ ⵜⵗⵍⴼ⵿ⵜ ⵏⵎⵛⵏⴰ ⵢⵛⵗⵍ ⵓⴰ ⵙⵏ⵿ⴹⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ⵙ ⴹⵏⵙⵏ ⵙⵙⵗⵔⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⵏⵍⴾⵏⵙⵜ ⵜⵤⵔ ⵙⵗⵍⵏⵙⵏ ⵙⵍⵏ ⵏⵔⵜ ⴾⵍ ⵓⵙ ⵜⵏⴾⴼⴰ ⵎⵛⵏⴰ ⵜⵔⴶⵜ ⵏⴶⵏⵜ ⴹⵎⴾ ⵓⵙ ⵍⵎ ⵎⵛⵏⴰ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵢ ⵜⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ⴹⴼⵔ ⵓⵏ ⵎⵍⵏ ⵗⵔ ⵏⵍⴾⵎⵏ ⵓⵏ ⴹⵏ ⵂⵔ ⴶⵏ ⵜⵎⵔ⵿ⵜ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ⵙⵏ⵿ⴹⵓ ⵎⴹⵏ ⵓⵢⴹ ⴹⴶⵎⴹⵏⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⴹ ⵙⵙⵗⵔⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏⵏⵙⵏ «ⵙ ⵓⵔ ⵜⵍⴾⵎⵎ ⵢⵍⵗⴹⵜ ⵏⵎⵏ⵿ⴾⴹ ⵜⴰ ⴹⵢⴰ ⵏⵀⵢ ⵎⵙⴰ ⵓⵔ ⵤⴰ ⵜⴶⵔⵓⵎ ⵍⵗⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ⵓⵔ ⵔⴹⴰ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⵙ ⵀⵜⵓ ⵜⵏ ⵓⵢⴹⵓ ⵓⵏ ⵜⵎⵤⵆ ⵍⵀⵙⵜ ⴶⵔⵙⵏ ⴹⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ⵰ ⵜⵤⵔ ⵜⵜⵓⴶⴰ ⵜⵏⵜ ⵏⴹ ⴶⵤⵢ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵢⴹ ⵙ ⵢⵔⵙⵍⵎ ⴼⵍ ⴹ ⵏⵢⵏ ⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⴹⵗ ⵀⵜⵓ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ⵜⴾⴼⵏ ⵍⴾⵏⵙⵜ ⵜⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⵔⵜ ⴾⵍ ⵓⵙ ⴹⵔⵔⵏ ⵎⵔⵏ ⴶⵍⵏ⵰ ⵔⵤⴶⵏ ⴾⵍ ⵓⵏ ⴼⵏⵙⵢⴰ ⴹ ⵓⵏ ⵙⵎⵔⵢⴰ ⵙⵗⵍⵏ ⵙⵍⵏ ⴾⵍ ⵏ⵿ⵜⵜⵀⵜ ⵜⴰ ⴹⴶⵏⵜ ⵜⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙ ⵎⵛⵏⴰ⵰ ⵙⴼⵍⵓⵙ ⵓⵏ ⵓⵍⵏ ⵏⵍⴾⵎⵏ ⴾⵍ ⵓⵏ ⴾⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ⵙ ⵙⵏ ⵢⵔⵙⵍⵎ ⵜⴶⵙⵏ ⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ ⵎⵔⵈⵀⴰ ⴹⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ⵰ ⵜⵤⵔ ⴶⵏ ⴹⵗⵙⵏ ⵙⵍⵏ ⵏⵔⵜ ⴾⵍ ⵓⵙ ⵜⵏⴾⴼⴰ ⵎⵛⵏⴰ ⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ⵎⵛⵏ ⴶⴹⵏ⵿ⴹⵓ ⵎⴹⵏ ⵓⵢⴹ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵂⵏⵏ ⵜⴶⵢⵜ ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⵏⵏ «ⵎⵏ⵿ⴾⴹ ⴹⵍⴾⵎ ⵢⵍⵆⵏⵏ ⵓⵏ ⵏⵀⵢ ⵎⵙⴰ ⴼⵔⴹ ⵎⵙ ⴼⵍ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ⵜⵤⵔ ⵎⵏⵢⵏ ⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⴼⵍ ⴹ ⵙⵏⵏ ⵓⴰ ⵤⴶⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ⵙ ⵔⵓⵏ ⵎⵤⵗⵏ ⵀⴹⴹ ⵀⵜⵔⵙ ⵏⵙⵏ «ⵎⴹⵔⵢⵏⵏ ⵜⵙⵏⵎ ⵙ ⵔⵓ ⵙ ⴹⵙⵏⴼⵔⵏ ⴹⵗⵓⵏ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵙⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⵎⵏⵏ ⵤⴶⵤⵏⵏ ⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ⵎⵛⵏⴰ ⵙⵏⵏ ⵓⴰ ⵂⵏ ⵓⵍ ⵏⵓⴹⵏ ⴾⵍ ⵙⴾⵏⴰ ⵜⵔⴹⵓⵜ ⵜⴰ ⵙⵔⵙⵏ ⴶⴰ ⵙ ⵜⵂⴾⵢ ⵜⴰ ⵜⵏⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⴹⵏⵜⴾⴼⴰ ⵏⴾⵏⵢ ⵓⵏ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ⵓⵔ ⴹⵏⵗⵤⵏⵎⵤⵍⵢ ⴹⵔⵙⵏ ⴼⵍⵙ ⵎⵛⵏⴰ ⵤⵤⴹⴶⵏ ⵓⵍⵏ ⵙⵤⴶⵤⵏ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ⴹⵗ ⴹⵢ ⵎⵔⴹⴰ ⵎⴰ ⴼⵍ ⵜⵜⴶⵎ ⵜⵏⴶⵎⵢⵜ ⵢ ⵎⵛⵏⴰ ⵙⴶⵢ ⵓⴰ ⵜⵜⴶⵎ ⴼⵍ ⵔⵓⵏ ⵏⵍⴾⵎⵏ ⵤⴾ ⵙ ⵓⵔⵎⴹ ⴼⵔⴶⵏ ⵎⵔⵓⵏⵏⴰ ⴹⴾⵍⵏⵜ ⵓⵍⴰ ⴹⵗ ⵏⴼⵔⴾⵓ ⵏⴾⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ⵓⵔⴶⵗ ⵔⵈⵎⵜ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵙ ⵏⵤⴶⵤⵏ ⵜⵙⴼⵙⵏⴰ⵰ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵤⴰ ⵏ⵿ⵜⵏⵢ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵜⵎⵓⵜ ⵜⴰ ⴹⴰ ⵙ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ⵜⵤⵔ ⵜⴼⵙ⵿ⵜⴰ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵙⵙⵎⵏ ⵢⵜⴹⵏ ⵢ ⵀⵔⵏⵀⵙ ⴹⵀⵍⵙ ⵙⵗⵍⵏ ⵙⵍⵏ ⴾⵍ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵓⵏ ⵙ ⵜⵏⴾⴼⴰ ⵎⵛⵏⴰ ⴶⵏⵙⵏ ⴹⵗ ⵜⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ⵙ ⴼⵙ⵿ⵜⴰ ⵀⵔⵏⵀⵙ ⴹⵀⵍⵙ ⵛⵓⵍ ⵢⵆⵀ ⵏⴰ «ⵎⴹⵔⵢⵏⵏ ⵙⵙⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ⵙⵎⵗⵏ ⵀⵜⵔⵙ ⵙⵗⵍⵏⴰ ⵜⵎⵓⵜ ⵜⵙ ⵙⵏ⵿ⵜⴰ ⵎⵛⵏⴰ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵙⴾⵏⵢ ⵏ⵿ⵜⵔⴰ ⵜⴰ ⴶⴰ ⵢ ⵜⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵙⵏⴼⵔⵏ ⵓⴰ ⴹⵗⵙⵏⵜ ⴶⴰ ⵢⵜⴹⵏ ⵙ ⵤⵆⵍⵏⵏ ⵜⵎⵜⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ⵎⵔⵏ ⵏⵎⵏⴾ ⵓⵏ ⴹⵓⴰ ⵏⵏ ⵏⵀⵜⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"ⴹ ⴹⵆⵍⴰ ⴹⴼⵔ ⵓⴰ ⵍⵙⵗ ⵢ ⴹⵓⴹ ⴾⵔⵙ ⵏⵂⵏⵜ ⵀⵔⵌⵏ ⴾⵔⵙⵗ ⵎⴶⵍⵤⵏⵜ ⵙⵀⴹⴹⵆⵓ ");
INSERT INTO ttqt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ⴼⵍ ⴹ ⴶⵎⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵆⵎⵏⵏ ⵎⵍⵢ⵰ ⵓⵍⴰ ⵛⵎⵜⵓⵏ ⴾⵍ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹ ⵆⵍⵏⵜ ⵜⵎⵜⵢⵏⵏ ⵗⵀⴹⵏⵜⵢ⵰ ⴹⵢ ⵏⴰ ⵎⵍⵢ ⵓⴰ ⴶⵏ ⵔⵜⵏ ⴹⵢ ⴾⵍ\" ");
INSERT INTO ttqt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ⴼⵍ ⵜⴶⴰ ⵎⵙⵏⵜ ⵂⵔⵓⴰ ⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ⵓⵏ ⴹⴰ ⴼⵍⵙ ⵏⴾ ⵢⵆⵀ ⵔⴹⵗ ⵙⴹ ⵏⵢⵓ ⵙⵎⵗⵜⵔ ⵏⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵜⵜⵀⵏⵏ ⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ⵎⵛⵏ ⴾⵜⵀⵜⵏⴰ ⵢⵙⵏ ⵛⵔⵓⵜ ⵏⵏⵙⵏ ⴹ ⵎⵤⵢⵏ ⴹⵙⵎⴹⵙ ⵏⵎⵏⵙⵏ ⵙⵔⵜ ⴹ ⴹⵎⵔⵏ ⵙⵏⵎ ⵎⵤⵢⵏ ⴹⴶⵢ ⵏⵤⵏⴰ ⴹⵜⵜⵢ ⵏ⵿ⵙⵏ ⵏⵎⴹⵔ ⵜⵏ⵿ⵗⴰ ⵜⵔⵤⵎ ⴹⵜⵙⵢ ⵏⵤⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ⴼⵍⵙ ⵔⵓ ⴹ ⵜⵎⵍⵏ ⵍⴼⵆⵜⵏ ⵙⵙⵗⵔⵏⵏ ⵜⵓⵔⵜ ⴹⵗ ⴾⵍⴾ ⵏⵗⵔⵎ ⵜⵓⵗⵔⵓ ⴹⵗ ⴾ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⴹⵗ ⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ⵜⵤⵔ ⵔⴹⵏ ⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ ⴹⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ ⵙⴹ ⵙⵏⴼⵔⵏⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵤⵎⵤⵍⵏ⵿ⵜⵏ ⵙⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⴹⵓⵏ ⴹⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ⵰ ⵙⵏⴼⵔⵏⵏ ⵢⵂⵤⴰ ⵓⵙ ⵜⵓⵏⵓ ⵀⵔⵙⵀⵙ ⴹⵙⵍⵙ ⵎⵙⵏⵏ ⵎⵤⵔⵏ ⴹⵗ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ⵙⵓⵔⵏ⵿ⵜⵏ ⴹ ⵓⵢⵏ ⵛⵔⵓⵜ ⵙⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⴹⵗⵙ ⴾⵜⵀⵏ «ⵓⴰ ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵎⴹⵔⵢⵏⵓⵏ⵰ ⵏⵂⵍⵏ ⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵂⵏⵏ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⴹⵓⵏ ⵂⵏⵏ ⴾⵍ ⵏ⵿ⵙⵔⵢⴰ ⴹ ⵓⵏ ⴾⵍⴾⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ⵏⵙⵍⴰ ⵙⴰ ⵓⴰ ⴾⵓⵏⵏⴶⵏ ⵎⴹⵏ ⴹⵏⵗⵏⴼⵍⵏⵏ ⵛⵢ ⵓⵍⴰ ⵜⵔⴶⵜⵏⵏⴰ ⵗⵛⴹⵏ ⵎⵏⵓⵏ ⵛⵓⵛⵏ⵿ⴾⵓⵏ ⵙⵓⴰ ⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ⴹⵢ ⴼⵍ ⵏⵏⵎⵏⴾ ⴾⵜⵏⵏⴰ ⵏⴶⴰ ⵜⵏⵜ ⴹ ⵏⵙⵏⴼⵔⵏ ⵎⴹⵏ ⵏⵤⵎⵤⵍ⵿ⵜⵏⵏ ⵙⵔⵓⵏ ⴹⵓⵏⵏ ⴹⵎⵔⵏⵏⴰ ⵀⵔⵏⵀⵙ ⴹⵀⵍⵙ ");
INSERT INTO ttqt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ⵎⵙⵏⵏ ⵎⴹⵏ ⴶⵏⵏ ⵎⵏⵙⵏ ⴹⵗ ⵍⵗⵔⵔ ⴼⵍ ⴹⵍⵍ ⵏⵙⵎ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ⴹⵢ ⴹⴰ ⴼⵍ ⴹⵏⵤⵎⵤⵍ ⵢⵂⵤⴰ ⴹⵙⵍⵙ ⴼⵍ ⴹⵓⵏⵍⵙⵏ ⵙⵗⵍ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⵎⵢ ⵙⵎⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ⴼⵍⵙ ⵙⵀⴹⴹ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵜⵏⵜ ⵏⵙ ⵓⵔ ⴾⵓⵏ⵿ⵤⵏⵙⵓⵔ ⵤⴾ ⵓⵍⵢⵏ ⵔ ⵓⵏ ⵔⵜⵏ ⵓⵏ ⵓⵌⵀⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ⵎⵙⵏⵏ ⴹ ⵜⵎⵤⵢⵎ ⴹⵜⵜⵢ ⵏⵎⵏ⵿ⵙⵢ ⵜⵓⴾⴼⵏ ⵢⵙⵏⵎⵏ ⴹⵜⵙⵢ ⵏⵤⵏⵢ ⴹⵜⵜⵢ ⵏ⵿ⵙⵏ ⵏⵎⴹⵔ ⵜⵏ⵿ⵗⴰ ⵜⵔⵤⵎ ⴹⴶⵢ ⵏⵤⵏⴰ⵰ ⵙ ⵜⵜⴼⵎ ⵎⵏⵓⵏ ⴼⵍ ⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⴹⵢ ⴹ ⵜⴶⵎ ⵍⵗⵏ⵰ ⵏⵂⵍⴾⵓⵏⵏ ⵓⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ⴹⴼⵔ ⵓⵏ ⵜⵓⵙⵍⵎⵏ ⵤⴶⴹⵢⵏ ⵆⵍⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⵓⵢⵏ ⵛⵔⵓⵜ⵰ ⵙ ⴹⵏⵓⴹⵏ ⵛⴹⵓⵏ⵿ⴹⵓ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⴼⵏ⵿ⵜⵏ ⵛⵔⵓⵜ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ⵜⵜⵓⵗⵔⴰ ⵜⵤⵔ ⵙⴹⵓⵏ⵿ⵜⵏ ⵙⵍⵏ ⵜⵍⵎⵏⵏ ⴼⵍ ⵎⵏ ⵓⵏ ⴶⵔⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ⵎⵔⵏ ⵛⵓⵍ ⵢⵂⵤⴰ ⴹⵙⵍⵙ ⵎⵙⵏⵏ ⵏ⵿ⵜⵏⵢ ⵎⵏⵙⵏ ⵏⵀⵜⵏ ⴹ ⵜⴶⵏ ⵏⵙⵈⴰ ⴶⵏ ⵢ ⵎⴹⵔⵢⵏ ⵜⵍⵎⵏⵙⵏ ⴼⵍ ⵎⵏ ⵙⵙⵂⵏ ⵤⴶⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ⵙ ⴶⴰ ⵢⵂⵤⴰ ⴹⵙⵍⵙ ⵜⵎⵔ⵿ⵜ ⴹⵏ ⵙⵍⵎⵏ⵿ⵜⵏ ⵎⴹⵔⵢⵏ ⵓⵏ ⵏ⵿ⵜⵢⵈⵢⴰ ⴼⵍ ⴹ ⵆⵍⵏ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵏ⵿ⴹⵜⵤⵎⵤⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ⵎⵛⵏ ⵙⴼ ⵙⵍⵙ ⴹ ⵆⵎ ⴹⵏ ⴹⴰ ⵆⵍ ⵙ ⵢⵂⵤⴰ ⵗⵙ ⵆⵍⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ⵈⵙⵔ ⵀⵍⵙ ⴹⵀⵔⵏⵀⵙ ⴹⵗ ⵏ⵿ⵜⵢⵈⵢⴰ ⵈⵜⵀⵏ ⵏ⵿ⵜⵏⵢ ⴹⵓⵢⴹ ⵎⴹⵔⵢⵏ ⴶⵜⵏⵏ ⵢⵢⵜⴹⵏ ⵍⵏ⵿ⵌⵍ ⵏⵎⵍⵢ ⵙⵙⵗⵔⵏⵙⵏ⵿ⵜⵓ ⴹⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ⵙ ⴶⵏ ⵜⵎⵔ⵿ⵜ ⴹⴼⵔ ⵓⵏ ⵏⴰ ⵀⵍⵙ ⵢ ⵀⵔⵏⵀⵙ «ⵆⵍⵏⴰ ⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵂⵏⵏ ⵗⵔⵎⵏ ⴾⵍ ⵓⵏ ⴹⵗ ⵏⵎⵍ ⵓⵍ ⵏⵎⵍⵢ ⴹ ⵏⵙⵏ ⵓⴰ ⴹⵗⵙⵏ ⵏⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ⵔⴰ ⵀⵔⵏⵀⵙ ⴹ ⴹⵓⵏ ⴹⵢⵈⵢⴰ ⵓⵙ ⵜⵓⵏⵓ ⵎⵔⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ⵎⵛⵏ ⵏⴰ ⵀⵍⵙ ⵓⵔ ⵂⵔ ⴹ ⴹⵓⵏ ⴹⵍⵙ ⵙ ⴹⵜ ⵓⵏ ⴹⵗⵙⵏ ⵈⵜⵙ ⵎⵏⵜ ⴹⵗ ⵀⵏ⵿ⴼⵍⵢⴰ ⵓⵔ ⵗⵔⵙⵏ ⵆⵎ ⵂⵔ ⵙⴾⵙⵓⵏ ⵛⵗⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ⵜⴾⵙ ⵜⵍⵗⴰ ⴶⵔⵙⵏ ⵂⵔ ⴹⵓⵢ ⵓⵏ ⵙ ⵎⵤⵢⵏ⵰ ⴹⵓ ⵀⵔⵏⵀⵙ ⴹⵎⵔⴾⵙ ⴶⵤⵏ ⵗⵍⵍ ⵏⵎⵏ ⴾⵏ ⵆⵀⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ⵀⵍⵙ ⵏ⵿ⵜⴰ ⵙⵏⴼⵔⵏ ⵙⵍⵙ ⴹⵓ ⴹⵔⵙ⵰ ⵙ ⵜⴶⵏ ⵎⴹⵔⵢⵏ ⴹⵗ ⵜⵗⵍⴼ⵿ⵜ ⵏⵎⵛⵏⴰ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ⵍⵍ ⵀⵍⵙ ⴾⵍ ⵓⵏ ⵙⵔⵢⴰ ⴹ ⵓⵏ ⴾⵍⴾⵢⴰ ⵙⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵍⴾⵏⵙⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ⵙⴰ ⵀⵍⵙ ⵗⵔⵎ ⵏ⵿ⴹⵔⵀ ⵙ ⵜⴼⵍ ⴾⴰ ⵓⵏ ⵍⵙ⵿ⵜⵔⴰ⵰ ⵎⵔⵏ ⵍⵙ⵿ⵜⵔⴰ ⵂⵜ ⵏⵍⴾⵎ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏ ⵜⵎⵜⵢ ⵙⵏⵏⵜ ⵢⵜ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵜⵤⴶⵤⵏⵜ ⵙ ⵗⵢⵙⴰ ⵎⵛⵏ ⵀⵏⵜ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ⵎⵍⵏ⵿ⵜⵓ ⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵍⵙ⵿ⵜⵔⴰ ⴹⴾⵏⵢⵎ ⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ⵔⴰ ⵀⵍⵙ ⵜⴹⵓⵜⵏⵜ ⵏ⵿ⴾⵔ ⵙⵎⵏ⵿ⴾⴹⵜⵓ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵓⵏ ⴼⵍⵙ ⵙⵏⵏ ⴾⵜⵏⵙⵏ ⵙ ⵀⵏⵜ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵏⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ⵗⵔⵎ ⴹⵙⴰ ⵀⵍⵙ ⴹⵙⵍⵙ ⴹⵗⵙ ⵎⵍⵏ ⵢ ⵏⵍⴾⵎⵏ ⵓⵏ ⵜⵂⵏⵏ ⵛⵏⴹⵏ ⵛⵏ ⴶⵏ ⵏⵎⵤⵍ ⴹⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⵜⵏ ⵢⵔⵙⵍⵎ ⴶⵎⵢⵏ ⴹⵗⵙⵏ ⴹⵙⵏⵜⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ⴹ ⵜⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵍⴾⵏⵙⵜⵏ ⵜⵢⵜⵢⵏⵜ ⴾ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ⵔⵤⴶ ⵀⵍⵙ ⴹⵙⵍⵙ ⴾⵍ ⵓⵏ ⴼⵔⵌⵢⴰ ⴹ ⵓⵏ ⴶⵍⵜⵢⴰ ⴶⵍⵏ ⴾⵢⵏ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵙⵏⴶⴹⵍⵏ ⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⴹⵗ ⴾⵍ ⵓⴰ ⵙⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ⵙ ⵙⵏ ⴶⴶⵙ ⵏⴾⵍ ⵓⵏ ⵎⵙⵢⴰ ⴶⵎⵢⵏ ⴹⴶⵤ ⵏⴾⵍ ⵓⵏ ⵀⵜⵏⵢⴰ ⵎⵛⵏ ⴶⴹⵍⵙⵏ⵿ⵜⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ⵜⵤⵔ ⵔⵤⴶⵏ ⵎⵙⵢⴰ ⵤⴶⴹⵢⵏ ⵙⵗⵔⵎ ⵓⵏ ⵜⵔⵓⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ⵙ ⴶⴰ ⵂⴹ ⵔⴶⴰ ⵀⵍⵙ ⵏⵢ ⵍⵙ ⵢⵏ ⵏⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⵀⴹⴹ ⴹⵏⴶⵙ ⵜⵏ⵿ⵙⵢⵜⵓ ⴶⵏⵙ «ⴾⴹⵓ ⵎⵙⴹⵏⵢⴰ ⵜⴹⵂⵍⵗⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ⴶⴰ ⵀⵍⵙ ⵜⵔⴶⵜ ⵜⵏ ⵗⵙ ⵏⵙⵎⵜⴶ ⵢⴾⵢ ⵏⵎⵙⴹⵏⵢⴰ ⴼⵍⵙ ⵏⴾⵙ ⵛⴾ ⵙ ⵎⵛⵏⴰ ⴹⵏⵗⵗⵔⵏ ⴼⵍ ⴹⵗⵙ ⵏⵎⵍ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⵜⵔⵓⵙ ⵏⵏⵎⴹ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵙⵎⵜⵔⵙ⵰ ⵙ ⴼⵓ ⵏⴾⴰ ⵗⵔⵎ ⵏⵢⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ⵏ⵿ⵜⴰ ⵏⴶⵎⴹⵜⵓ ⵙ ⵓⵏ ⴼⵍⵀ ⵎⵙⵏ ⵗⵔⵎ ⴼⵍ ⵜⵈⴾⵎ ⵔⵎ⵰ ⵎⵙ ⴹⵗ ⵗⵔⵎ ⵓⴰ ⵤⵔⵏ ⴹⵗ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ⵰ ⵏⴶⴰ ⴹⵗⵙ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ⵙ ⴹⵓⴹ ⵤⵍ ⵓⵏ ⵙⵀⵜ ⵤⵍ ⵓⵏ ⵜⵙⵏ⵿ⴼⵓⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵏⴶⵎⴹⵏ ⵗⵔⵎ ⵙ ⵜⴶⴹⵎⵢⵜ ⵏ⵿ⵜⵙⵙⵏ⵿ⴶⵢⵜ ⵢⵜ ⵙ ⵏⵔⴹⴰ ⵙ ⵂⵜ ⴹⴶ ⴹⵗ ⵜⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵛⵓⵜⵔⵓⵏ⵰ ⵏⴶⵤⵏ ⵛⴹⴹⵏ ⵎⵏⵢⵏⵏ ⴹⵏ ⵜⵤⵔ ⵏⵆⵎ ⵏⵛⵓⵍⵙⵏⵜ ⵏⴶⵙⵏⵜ ⴹⵗ ⵜⵍⵈⵜⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ⵜⵙⵙⵎⵏⴰ ⵢⵜ ⴹⵗⵙⵏⵜ ⵏ⵿ⵜⵎⴾⵙⵜ ⵏⵎⵛⵏⴰ ⵜⴶⵜ ⵙⵎ ⵍⴹⵢⴰ ⵏⵗⵔⵎ ⵏ⵿ⵜⵢⵜⵔ ⵜⵜⴶⵜ ⵌⵍⴰ ⵏ⵿ⵜⵀⴹⵗ ⵤⴶⵗⵏⵏ ⵂⵙⵢⵏⵏ⵰ ⵔⴰ ⵎⵍⵢ ⵓⵍⵏⵜ ⵜⴶⴰ ⵙⵙⵎ ⵍⵗⵏ ⵢⵓⴰ ⴶⵏⵓ ⵀⵍⵙ ⵜⵤⵔ ⵜⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ⵙ ⵜⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⵏⵗⵢⵓⵏⵜ ⵜⵏ⵿ⵙⵢⵏⴰ ⵜⵏⵏⴰ «ⵤⵎⴰ ⵜⵂⵏⵢⵎ ⵙ ⵤⴶⵤⵏⴰ ⵙⵎⵍⵢ ⵓⴹⵢ ⴾⵓⵜⴹⵓ ⵂⵏⵏ ⵜⵤⵀⵎ ⴹⵗⵙ⵰» ⵜⴶⵔⵓⴹⵓ ⴹⵗⵏⴰ ⵙ ⵏⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ⵤⵍ ⵢⵏ ⵏⴾⴰ ⴹⴶ ⵏ⵿ⵜⵓⵜⵔⵓⵏ ⵓⵏ ⵙ ⵏⵎⵏⵢ ⴹⵜⵎⵓⵜ ⵢⵜ ⵏ⵿ⵜⴾⵍⵜ ⵂⴰ ⴶⵙⴼ ⴹⵙⵎⵍⵏ ⵓⴰ ⴹⵤⵢⵏ ⴶⵔⵓⵏ ⵙⵔⵙ ⵎⵙⵓⵙ ⵜⵏ⵿ⴼⴰ ⵜⴶⵜ ⴹⵗ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ⵜⵍⴾⵎⵏⴰ ⵏⴾⵏⵢ ⴹⵀⵍⵙ ⵜⵙⵗⵔⵜ ⵜⴶⵏⵓ «ⵎⴹⵏ ⵓⵏ ⴾⵍⵏ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴹⴾⵍ ⵎⵙⵏ⵰ ⵙⵍⵏ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ ⵍⵗⵍⵙ ⵙ ⴹⵙⵏ ⵢⴹⵓⵏ⵿ⵜⵏⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ⵜⴶⴰ ⴹⵏ ⴶⵜⵏⵏ ⵜⵜⴶⵓ ⵓⵏ⵰ ⴶⵍⴰ ⵀⵍⵙ ⵂⵔ ⵜⵛⵗⵛⵛⵜ ⵓⵏ ⵎⵍⵍⵢⵜⵜⵏ ⵏⴰ ⵢⴶⵙⴼ ⵓⴰ ⵜⵜⵂⵏ «ⵎⵔⵆⵢ ⵙ ⵜⵔⵏⴰ ⵜⴰ ⵜⵂⵜ ⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴶⵎⴹⵜⵜ⵰» ⵜⵤⵔ ⴶⵎⴹⵜⵜ ⴶⵙⴼ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ⵙ ⵏⵢⵏ ⵎⵙⵓⵙ ⵙ ⵀⵙ ⵙⵔⵙⵏ ⵜⵜⴹⵜⴶⵎⴹ ⵜⵏ⵿ⴼⴰ ⵀⵤⵏ ⵀⵍⵙ ⴹⵙⵍⵙ ⵍⵓⵢⵏ⵿ⵜⵏ ⵙⵙⵎⵏⵢ ⵏⵗⵔⵎ ⵙⵀⴹⴹⵏ⵿ⵜⵏ ⴹⵜ ⵏⵈⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ⵏⵏ ⵢ ⵏⵈⴾⵎⵏ «ⵎⴹⵏ ⵓⵏ ⵌⵏⵌⵔⵓⵢⵏ ⵗⵔⵎⵏⵏⴰ⵰ ⴾⵍⵍⵢⵂⴹ ⵎⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ⵙⵙⵗⵔⵏⵏ ⵢⵜⴹⵏ ⵍⵗⴹⵜⵏ ⵙ ⵏⴾⵏⵢ ⴾⵍⵔⵎ ⵓⵔ ⵏⵍⴰ ⵜⵔⴶⵜ ⵏ⵿ⵜⵔⴹⵓⵜ ⵙⵔⵙⵏⵜ ⵓⵍⴰ ⵍⴾⵎ ⵢⵙⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ⵜⵏ⵿ⴾⵔ ⵜⵎⵜⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⵜⵤⵏ ⵙ ⵀⵍⵙ ⴹⵙⵍⵙ⵰ ⵏⵏ ⵏⵈⴾⵎⵏ ⴼⵍⵙⵏ ⵜⵓⵤⵤⵔⵏ ⵙⵍⵙⴰ ⵎⵔⵏ ⵙⴹⵙⵏ⵿ⵜⵓⴶⵏⵜ ⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ⵙ ⵜⵏⵢⵓⵏⵏ ⵛⵓⵜ ⴶⵔⵏ⵿ⵜⵏ ⴹⵗ ⴾⵙⵓ ⵎⵔⵏ ⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⵙⴹⵙⵏⴶⵓ ⴶⵤ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⴹⵗ ⵙ ⴹⵙⵜⵓⵏⴰ ⵓⵏ ⵏ⵿ⴾⵔ ⴶⵏ ⴹⵗ ⴹⵏ⵿ⴶⵢⴰ ⵏ⵿ⴾⵙⵓ ⵏ⵿ⴹⵢ ⴹⵔⵏⵙⵏ ⴹⵗ ⵛⵍⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ⵙ ⵙⴶⵔⵢⴶⵔⵢ ⵂⴹ ⴹ ⵜⵜⵔ ⵀⵍⵙ ⴹⵙⵍⵙ ⵙⵂⴾⵏ ⵎⵙⵍⵏⵙⵏ ⵜⴶⵏ ⴹⵗ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⵙⵙⵎⵏⵙⵏ ⵎⵙⴾⵙⴰ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ⵓⵍⴰ ⵂⴶⵏ ⴶⴰ ⵎⴹⵍ ⵏⴶⵢⵏⴶⵢ ⵙⵓⴰ ⴶⴰ ⴹⵗ ⵙⵂⵜ ⵂⵔ ⵏⴶⵢⵏⴶⵢ ⵂⵏ ⵏ⵿ⴾⵙⵓ ⴾⵜⵏⵜ ⵏⵍⵎⵏⵜ ⵜⵙⵂⵔ ⵏ⵿ⴾⵙⵓ ⴾⵍ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵤⵍⵀⵏ ⵙⵙⵔⵏ ⴹⵗ ⵎⵙⴾⵙⴰ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ⵏ⵿ⴾⵔⴹⵓ ⵎⵤⵔ ⵏⵂⵏ ⵏ⵿ⴾⵙⵓ ⴹⵗ ⵜⵙ⵰ ⵙ ⵏⵢ ⵛⵙⵂⵔ ⵏ⵿ⴾⵙⵓ ⵏⵍⵎⵏⵜ ⵍⵀⵢⴹⵓ ⵜⴾⵀⵏⵜ ⵢⵙⵔⵙ ⵏ⵿ⵗⵓ ⵎⵏⵜ ⴼⵍⵙ ⵗⵍ ⵎⵙⴾⵙⴰ ⴹⴶⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ⵎⵛⵏ ⵙⵗⵔⵜⵙ ⵀⵍⵙ ⵏⵙ «ⴹ ⵓⵔ ⵜⵏ⵿ⵗⵗ ⵎⵏⴾ ⴾⵜⵏⵏⴰ ⵏⵍⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ⵏⴰ ⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⴹ ⴹⵎⵓⵢⵏⵜ ⴼⵜⵍⵜⵏ ⴶⵤ ⵎⵙ ⵏ⵿ⴾⵙⵓ ⵜⵔⵎⴹ ⴶⵍⴰ ⵂⵔ ⵓⴹ ⴹⵏ⵿ⴶⵢⵏⵜ ⵜⵏ⵿ⴹⵓⵜⵓ ⵜⵢⵙⵙ⵿ⵜ ⵂⵔ ⵙⵌⴹ ⵢ ⵀⵍⵙ ⴹⵙⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ⵜⵤⵔ ⴾⵙ⵿ⵜⵏ⵿ⴹⵓ ⵏⵙⵏ «ⵎⴹⵏ ⵎⵙ ⴹⵓⵔ ⴶⵏⵜ ⴶⵔⵓⵗ ⵍⵗⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ⵏⵏⵙ «ⵤⴶⵤⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⴹ ⵜⵗⵍⵙⴰ ⴾⵢ ⴹⵗⵢⵓⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ⵎⵔⵏ ⵎⵍⵏⵙ ⵓⵍ ⵏⵎⵍⵢ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⴾⵍ ⵏⵗⵢⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ⵓⵢⵜⵏ ⵍⵓⵆ ⵓⵏ ⴹⴰ ⴹⵓⵏⵢ ⵏⵂⴹ ⵛⵔⴹ ⵀⵙⵏⵙⵏ⵰ ⴹⵏ ⴹⴰ ⴹ ⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⵏⵗⵢⵓⵏⵜ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ⵜⵤⵔ ⴹⵓ ⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⴹⵀⵍⵙ ⴹⵙⵍⵙ ⵙⵂⵏⵜ ⵙⵎⴶⵔⵜⵏ⵰ ⵙⴹⵓⵜⵓ ⵓⵍⵏ ⵏ⵿ⵜⴰ ⴹⵗⵢⵓⵏⵜ ⴾⵜⵏⵜ ⵤⴶⵤⵏ ⵓⴰ ⴶⵏ ⵙ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ⵙ ⴼⵓ ⵤⵎⵤⵍⵏ ⵏⵈⴾⵎⵏ ⵙⵌⵜⵏ ⵙⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⵢⴹⵙⵏⵏ ⴹ ⴾⵙ ⵀⵍⵙ ⴹⵙⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ⵎⵍ ⵎⵤⵔ ⵏ⵿ⴾⵙⵓ ⵎⵤⵍ ⵓⵏ ⵢ ⵀⵍⵙ ⵏⵙ «ⵏⵈⴾⵎⵏ ⵏⵗⵔⵎ ⵏⵏ⵿ⴹⵓ ⴹ ⵜⵜⵓⴾⵙⵎ⵰ ⴹⵗ ⴹⵢ ⴶⵎⴹⵜ ⵜⴶⵍⵎ ⴹⵗ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ⵎⵛⵏ ⵏⴰ ⵀⵍⵙ ⵢ ⵙⵌⵜⵏ «ⴰ ⴹⵏⵗⴶⵏ ⵛⵓⵜ ⴹⵜ ⵓⴹⵏ ⴾⵍ ⴹⴰ ⵓⵍⴰ ⵛⵔⵗⴰ ⵏ⵿ⵜⴰ ⵏⴾⵏⵢ ⵏⵎⵙ ⴾⵍⵔⵎ⵰ ⴶⵔⵏⵏⴰ ⴹⵗ ⴾⵙⵓ ⵎⵔⵏ ⵎⵔⴹⴰ ⵔⵏ ⴹⵏⵗⴾⵙⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵙⵏⵏ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵙⵏⵜⴹⵓ ⵎⵏⵙⵏ ⴾⵙⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ⵆⵍⵏ ⵙⵌⵜⵏ ⵙⵗⵍⵏ ⵀⵜⵓ ⵜⵏ ⵢ ⵏⵈⴾⵎⵏ⵰ ⵙ ⵙⵍⵏ ⵙ ⵀⵍⵙ ⴹⵙⵍⵙ ⴾⵍⵔⵎ ⵎⵙⵏ ⵔⵎⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ⵙⵏ⵿ⵜⵏ⵿ⴹⵓ ⵜⵏ⵿ⵜⵍⵗⴹⵏ ⵜⵤⵔ ⴾⵙⵏ⵿ⵜⵏ ⴹⵗ ⴾⵙⵓ ⴹⵗⵙⵏ ⴶⵎⵢⵏ ⴹ ⴶⵎⴹⵏ ⵗⵔⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ⴼⵍ ⵀⵍⵙ ⴹⵙⵍⵙ ⴾⵙⵓ ⴾⵏ ⵂⵏ ⵏⵍⴹⵢⴰ⵰ ⵙ ⵎⵏⵢⵏ ⴹⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵛⵓⵍⵏⵙⵏ ⵍⵎⵏⵙⵏ ⴼⵍ ⵎⵏ ⵎⵔⵏ ⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ⴶⴰ ⵀⵍⵙ ⴹⵙⵍⵙ ⵜⵔⵢⵜ ⵜⴰ ⵜⵔⵤⴶⵜ ⵏ⵿ⴼⵀⵍⵙ ⴹⵀⵍⵏⵢⴰ ⵂⵔ ⴹⵏⵙⵏ ⵗⵔⵎ ⵏ⵿ⵜⵙⵍⵏⴾ ⴹⵗ ⵍⵏ ⴾⵍⵍⵢⵂⴹ ⵂⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ⵙⵏⵏ ⵀⵍⵙ ⵓⴰ ⴹⴰ ⵜⴶⵓ ⴼⵓⴹⴰ⵰ ⴶⴰ ⴹⵏ ⴾⵔⴹⵜ ⵙⵀⵜⵏ ⵜⵎⵛⵓⵍ ⴹⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵙⵍⵏ ⵏⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ⵙⵙⴶⵔⵙⵏ⵿ⵜⵏ ⵙⵙⵏ⵿ⵜⵏ ⵙ ⵍⵎⵙⵈ ⵍⵤⵎ⵿ⵜⵓ ⴹ ⵗⵤⵀ ⵀⵜⵓ ⵜⵤⵔ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴶⵏⵙⵏ ⴹⵗ «ⵗⵢⵙⴰ ⵓⴰ ⴹⵓⵏⵎⵍⴰ ⴹⴰ ⵏ⵿ⵜⴰ ⵍⵎⵙⵈ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ⵤⴶⵤⵏⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵙⵓⴰ ⴶⵏⵓ ⵜⵤⵔ ⵓⵔⵏ ⴶⵏⴰ ⵏⵀⵍⵙ ⴹⵙⵍⵙ ⵏ⵿ⵜⵏⵢ ⴹⴾⵍⵍⵢⵏⵏ ⴾⵏⵏⵏ ⴶⵜ ⵏⵎⴾⵙⴹⵏ ⵏⵎⵛⵏⴰ ⴹⵜⴹⴹⵏ ⴶⵜⵏⵏ ⵍⵏⵏ ⵙⵎ ⴹⵗ ⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ⵎⵛⵏ ⴶⵤⵏⵜ ⵜⵙⵎⵜⵏ ⵍⵀⵙⵏⵏ ⵜⵛⵎ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵛⴹⵓⵏ⵿ⴹⵓ ⵔⴾ ⵢⵜⴹⵏ ⵓⵏ ⵙⴾ ⵆⵍⵏ ⵜⴹⵓⵜ ⵜⵤⵔ ⵌⵏⵌⵔⵓⵢⵏ ⵗⵔⵎ⵰ ⵙ⵿ⵜⵀⵏ ⵢⵂⵏ ⵏⵢⵙⵏ ⴶⵎⵢⵏ ⵀⵍⵙ ⴹⵙⵍⵙ ⴼⵍ ⵜⵏⵙⵀⴹⴹⵏ ⴹⵜ ⵍⵌⵎⵗⵜ ⵜⵛⵔⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ⵓⵔ ⵗⵔⵙ ⵜⵏⴶⵔⵓⵏ ⵜⵤⵔ ⵍⵓⵢⵏ ⵢⵙⵏ ⵏ⵿ⵜⴰ ⴹⵔⵜ ⴹⵗ ⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵂⵔ ⵜⵏⵙⵀⴹⴹⵏ ⴹⵜ ⵏⵈⴾⵎⵏ ⵏⵗⵔⵎ ⴹ ⴶⵏⵏ ⵙⴼⵍⴰ «ⵢⵜⴹⵏ ⵓⵏ ⴹⵏⵜ ⴾⵜⵏⵜ ⵙ ⵙⵔⵙ ⴹⵓⵢⵏ ⵀⴰ ⵏⵍⵈⵔ ⵎⵔⴹⴰ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ⵎⵔⵏ ⵢⵙⵏ ⵜⵏⴶⵏ ⴹⵗ ⵗⵢⵓⵏⵜ⵰ ⴾⵜⵏⵙⵏ ⵜⵎⵤⵔⵢⵏ ⵍⵆⵏⵏ ⵏⵎⵏⴾⵍⵏⵏⴰ ⵆⵢⵙⵔⴰ ⴼⵍⵙ ⵜⵏⴰ ⵜⴶⵏ ⵍⵢ ⵢⵏ ⵎⵏⴾⵍ ⴶⵏ ⵙⵎ ⵗⵢⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ⵙⵍⵏ ⵓⵏ ⴹⵏ ⵙ ⴹⵙⵏ⵿ⵜⵙⵍⴰ ⵜⵎⵜⵢ ⴹⵏⵈⴾⵎⵏ ⵏⵗⵔⵎ ⴶⵏ ⵛⵓⵛⴰ ⵍⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ⴶⵏ ⵤⵔⴼ ⴹⵗ ⵢⵙⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵗⵔⵙ ⵍⵏⵏ ⵂⵔ ⵜⵔⵤⵎⵏ ⵙ ⵜⵓⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ⵜⵔⵎⴹ ⵙ ⵙⴾⵏ ⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵀⵍⵙ ⴹⵙⵍⵙ ⵗⵔⵎ ⵏⵀⵔⵓⵢⴰ ⵂⴹ ⵓⵏ⵿ⴹⴰ⵰ ⵙ ⵜⵏⵙⵏ ⴶⵤⵏ ⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ⵙⴾⵏⵏ⵿ⵜⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵀⵔⵓⵢⴰ ⵍⵍⵓ ⴶⵔⵏ ⵓⴰ ⵜⵓⵙⴾⵏⵏ ⴹⵗ ⵜⵙⵍⵏⴾ⵰ ⵏ⵿ⵜⵏⵢ ⴾⵏⵏ ⵍⵆⵀⵍⵜ ⵏⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⵤⵍ ⴾⵍ ⵗⵔⵏ ⵍⴾⵜⵀⵏ ⵜⵛⴶⵔⵏ ⴾⴹ ⵓⴰ ⴶⵏⵓ ⵀⵍⵙ ⵜⴹⵜ ⵎⵙ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ⵓⵢⴹⵓ ⵓⵏ ⵙ ⵤⴶⵤⵏⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⵜⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⵜⴹⴹⵏ ⵏ⵿ⴾⵍⵍⵢⵏⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⴹⵎⴹⵏ ⴶⵜⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ⵎⵛⵏ ⵙ ⵙⵍⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵜⵙⵍⵏⴾ ⵙ ⵗⵔⵎ ⵓⵏ ⵀⵔⵓⵢⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵎⵍ ⴹⵗⵙ ⵀⵍⵙ ⵓⵍ ⵏⵎⵛⵏⴰ ⴾⵏ⵿ⵜⵓ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⵏ ⵔⴾ ⵎⵏ ⴹⵗ ⵢⵜⴹⵏ ⵌⵏⵌⵔⵓⵢⵏ ⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ⴹⵏ ⴹⴰ ⴹ ⵏ⵿ⴾⵔⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵙⴶⵍⵏ ⵀⵍⵙ ⵙⴾⵏ⵿ⵜⵓ ⵜⵎⴰ ⵏⴶⵔⵓ⵰ ⵙⵍⵙ ⴹⵜⵎⵜⵢ ⵏ⵿ⵜⵏⵢ ⵆⵎⵏ⵿ⴹⵓ ⴹⵗ ⵀⵔⵓⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ⵢⵜⴹⵏ ⵓⵏ ⵎⵛⴹⵓ ⵏⵀⵍⵙ ⴹⵓⵏ ⴹⵔⵙ ⵂⵔ ⵜⵛⵛⵓⴹⵏ ⵗⵔⵎ ⵏⵜⵏⴰ ⵎⵔⵏ ⵆⵍⵏ ⵓⵢⵏ ⵎⵤⵍ ⵏⵀⵍⵙ ⵢ ⵙⵍⵙ ⴹⵜⵎⵜⵢ ⵏⵙ ⴹⵙⴹⵍⴾⵎⵏ ⵜⵔⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ⵆⵍ ⵀⵍⵙ ⵢ ⵎⴹⵓⵏⵜ ⴹⵗ ⵗⵔⵎ ⵏⵜⵏⴰ ⵜⵎⵜⵛⵏ ⵎⵏⵜ ⴼⵍ ⵍⵂⵎ ⵏⴶⵜ ⵓⴰ ⴶⵏ ⵙⵏⵎⵏ ⴹⵗ ⵗⵔⵎ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ⵜⵤⵔ ⴹ ⵜⴾⵓ ⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⵜⵎⵛⵓⵍ ⴹⵔⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⵢⵜⴹⵏ ⵓⵢⴹ ⵏⵎⴾⵙⴹⵏ ⵏⵎⵛⵏⴰ ⵜⴾⵓ ⴹⵗ ⴾ ⵤⵍ ⵙⵎⵏⵢ ⵏⵗⵔⵎ ⵜⵎⵛⵓⵍ ⴹⵓⵏ ⴹⵔ ⵜⵎⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ⵜⵎⵛⵓⵍ ⴹⵗ ⵀⵍⵙ ⴹⵎⴹⵏ ⵓⵢⴹ ⵏⵎⵙⵏⵏ ⵏ⵿ⵜⴶⵢⵜ ⵜⵏ ⴼⴾⵔⵢⵏ ⴹⵙ⵿ⵜⵢⵙⵢⵏ⵰ ⵜⵎⵤⵗⵏ ⴹⵔⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⵏⵏ «ⵓⴰ ⴾ ⵜⵓⵍⵆⵜ ⵎⴰ ⴶⵏⵓ⵰» ⵓⵢⴹ ⴶⵏⵏ «ⵙ ⵜⵏⴰ ⵎⵍⵏ ⵓⵢⴹ ⵓⵔ ⵏⵤⴹⵢ ⵙ ⵎⵍ ⵙⵍⵏⵙⵏ⵰» ⵓⵔ ⵜⵏⵙⵙⵏⴰ ⵓⵏ ⵔ ⴼⵍ ⴹⵙⵏⵎⵍ ⵀⵍⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵜⴶⵙⵏ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⴹⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ⵜⵤⵔ ⴾⵏ ⴹⵔⵙ ⵙⵙⴶⵓⵔ ⵏⵗⵔⵎ ⵏⵜⵏⴰ ⵙ ⵜⵓⵏⵓ ⵔⵢⴼⴶⵙ ⵏⵏⵙ «ⴶⵏⴰ ⵙⵍⵏ ⵏⵎⵙⵏⵜ ⵜⵤⵔⵢⵜ ⵜⴰ ⴹⵔ ⴹⵜⵙⵗ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ⴼⵍⵙ ⵜⵙⵙⵍⵗⵏⴰ ⵔⵜⵏ ⵓⵔ ⵏⵤⴹⵢ ⵙ ⵏⵔⴰ ⴹ ⵏⵙⵏ ⵍⵎⵗⵏⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ⵏ⵿ⵜⵏⵢ ⴾⵍⵜⵏⴰ ⴾⵍ ⴹⵏⴼ⵿ⵜⵗⵏ ⵓⵏ ⵜⵏⵂⵏⵏ ⵓⵔ ⴶⵎⴹⵏ ⵔ ⵙⵓⵍ ⴹⵙⵙⵎ ⵢ ⵙⵍⵏ ⵓⵏ ⴹⵤⵔⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ⵀⴹⴹ ⵀⵍⵙ ⴹⵗ ⵎⵙ ⵏⵔⵢⴼⴶⵙ ⵏⴰ «ⵂⵏⵢⴰ ⵓⵍⵏ ⵙ ⴾⵓⵏⵢ ⴾⵍⵜⵏⴰ ⵜⴹⵏⵎ ⵓⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ⴼⵍⵙ ⵙⵗⵍⵢⴰ ⴹⵗ ⵗⵔⵎⵏⵓⵏ ⵤⴶⵤⴹⵗ ⴹⴶⵏ ⵓⵏ ⴹⵗ ⵜⵗⵀⴹⵎ ⵎⵍⵏⵓⵏ ⵙⵂⴰ ⴼⴹⴰ ⴼⵍ ⴹⴶ ⴹⵗ ⵜⵓⴾⴼⵏⵜ ⵜⴾⵜⵓⵏ ⴼⵍ ⴾⵜⵀ \"ⴹⴶ ⵏⵍⵗⵀⴹⴰ ⵏⵎⵍⵢ ⵓⵔ ⵏⵜⵓⵙⵏ\"⵰ ⵎⵍⵢ ⵓⴰ ⵜⵗⵀⴹⵎ ⴹⴰ ⵓⵔ ⵜⵜⵙⵏⵎ ⵏ⵿ⵜⴰ ⵙ ⴹⵓⵏⵎⵍⴰ ⵙⵍⵏⵜ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ⵎⵛⵏⴰ ⵓⴰ ⴹⵈⵍⴾⵏ ⴹⵏⵜ ⴹⵔⵜ ⴾⵍ ⵓⴰ ⵜⵜⵂⵏ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵍⵢ ⵏ⵿ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵓⵔ ⵈⵙⵔ ⴹⵗ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⴾⵔⵙⵏ ⴼⵙⵏ ⵏⴶⴹⵎ ");
INSERT INTO ttqt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ⵓⵍⴰ ⴹⵔⵔ ⵙⴾⵏⴰ ⴶⴹⵎ ⴼⵍⵙ ⵓⵔ ⴹⵔⵔ ⵙ ⵓⵍⴰ⵰ ⵏ⵿ⵜⴰ ⵙⴹⵔⵏ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵂⴾⵓ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ⵈⵍⴾⴹⵓ ⵜⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴾⵍ ⴹⵗ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵢⴹ ⵈⵙⵔⵏⵜ ⴼⵍ ⵔⵔⵓ ⵏⵎⴹⵍ ⴾⵜⵏⵜ⵰ ⵈⵜⵙⵙⵏⵜ ⵤⵎⵏ ⴶⴰ ⴹⵗ ⵛⵤⵔⵤ ⵢ ⴾⵍⵏ ⵓⵏ ⴹⵗ ⵈⵙⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ⴶⴰ ⵎⵛⵏⴰ ⵓⵏ ⴼⵍ ⴹ ⵜⴶⵎⵢⵏ ⵢⵜⴹⵏ ⴾⴹⵗ ⵙⴹⵤ ⵎⵌⵙ ⵜⴶⵔⵓⵏ⵰ ⴾⴹⵗ ⵙ ⵓⵔ ⴹⵏⵗⵂⴰ ⵢ ⴶⴶ ");
INSERT INTO ttqt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ⴼⵍⵙ ⵏ⵿ⵜⴰ ⵜⴼⵏ ⵜⵎⴹⵔ⵿ⵜⵏⵏⴰ ⴹⵎⵜⴾⵓⵢ ⵏⴾ ⵢⵏ ⴹⵗⵏⴰ ⴹⵓⴰ ⵏⵎⵙ⵰ ⴹⵢ ⴹⴰ ⵏⵏ ⵔⵜ ⴹⵗ ⵎⵙⵓⵢⵏⵓⵏ ⵓⵢⴹ ⵙ ⵜⵏⴰ ⵜⴰ ⴶⵏ \"ⵓⵍⴰ ⵏⴾⵏⵢ ⴹⴰ ⵏⵎⵙ ⵀⵔⵔⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⵏⵎⵙ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵓⵔ ⵎⴾⵏ ⴹ ⵏⵔⴹⵓ ⵙ ⵂⴰ ⵛⵛⵍⵏ ⵏⵙⵏⵎ ⴶⵏ ⴹⵗ ⵔⵗ ⵓⵍⴰ ⵤⵔⴼ ⵓⵍⴰ ⵜⵂⵏ⵿ⵜ ⴹⵏ⵿ⵤⵎ ⵓⴹⵏ ⴶⵔⵙ ⴹⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ⵍⵌⵂⵍ ⵓⴰ ⴶⵏ ⵢⵜⴹⵏ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵓⵔ ⴼⵍⵙⵏ ⵜⵈⵙⵀ ⵎⵛⵏⴰ ⴹⵗ ⵍⵏ ⵓⵏ ⵜⵍⵌⵂⵍⴰ ⵎⵛⵏ ⵎⵔⴹⴰ ⵎⵔ ⵢⵜⴹⵏ ⴾⵍ ⴹⴶ ⵂⵏ ⵙ ⵜⵜⵀⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ⴼⵍⵙ ⵍⴾⵎ ⵤⵍ ⴶⴰ ⵜⵎⵙ⵿ⵜⵏ⵿ⵜ ⵓⴰ ⴹⵗ ⵤⴶⵓ ⵢⴹⵏⵜ ⴾⵜⵏⵜ ⵛⵔⵗⴰ ⵗⴹⵏ⵰ ⵙⵏⴼⵔⵏ ⵍⵙ ⵓⴰ ⵤⴶⵓ ⴹⵗ ⵛⵗⵍ ⵓⴹⵢ⵰ ⵙⴾⵏⴰ ⴹⵢ ⵢⵓⴹⵏ ⴾⵍ ⵙⵙⵏ⵿ⴾⵔ ⵓⴰ ⵜⴹⴶⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ⵙ ⵙⵍⵏ ⵢ ⵀⵍⵙ ⵛⵓⵍ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴶⵏ ⴹⵗⵙ ⵓⵢⴹ ⵜⵎⴾⴾⵢⵜ ⵓⵢⴹ ⵎⵔⵏ ⵏⵏⵙ «ⵏⵔⴰ ⴹⴾⵏⵍⵙ ⵙⵙⵎ ⴹⵗ ⵀⵜⵓ ⵜⴹⵢ ⵤⵍ ⵢⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ⴹⵏ ⴹⴰ ⵜⵏⴼⵍ ⵀⵍⵙ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵙⵗⵏ ⴹⵔⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⵜⵤⵔ ⵤⴶⵤⵏⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏ ⴹⵢⵏⵙⵢⵙ ⵂⵏ ⵙⴶⵓⵔ ⵓⵏ ⵔⵢⴼⴶⵙ ⴹⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⴹⵎⵔⵙ ⴹⵓⵢⴹ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ⴹⴼⵔ ⵓⵏ ⴶⵎⴹ ⵀⵍⵙ ⵗⵔⵎ ⵏⵜⵏⴰ ⴾⴰ ⵓⵏ ⴾⵔⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ⴹⵏ ⴹⴰ ⴹ ⵎⵏⵢ ⴹⵍⵙ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵙⵎ ⴾⵍⵙ ⵏⴾⵍ ⵏ⵿ⴼⵏ⵿ⵜⵙ ⴹⵙⵏ ⵙⴾⵜ ⴼⵍⴹⵓ ⴾⵍ ⵓⵏ ⵜⵍⵢⴰ ⵏ⵿ⵜⴰ ⴹⵂⵏⵙ ⴼⵔⵙⴾⴰ⵰ ⴼⵍⵙ ⵎⵏⴾⵍ ⴾⵍⵓⴹⵢⵙ ⵆⵢⵙⵔⴰ ⵎⵔⵏ ⵙⴹ ⵜⵓⵙ⵿ⵜⵗⵏ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⴹⵗ ⵗⵔⵎ ⵏⵔⵎ⵰ ⵙⵗ ⴹⵔⵙⵏ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ⵎⵔⵏ ⴹⴹ ⵎⵙ ⵙ ⵍⴰ ⴹⵔⵙⵏ ⵛⵗⵍ⵰ ⴾⵜⵏⵙⵏ ⵛⵗⵍⵏⵙⵏ ⴶⵢ ⵏⵂⴾⵜⵏ⵰ ⵎⵍ ⵗⵔⵙⵏ ⵀⵍⵙ ⵛⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ⴾ ⵤⵍ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ ⵜⴶⵓ ⵀⵍⵙ ⵙⵍⵏ ⴹⵗ ⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⴶⵎⵢ ⴹⴹ ⵤⴶⵤⵏⵏ ⴾⵍⵍⵢⵂⴹ ⴹⴾⵍⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ⵙ ⴹⵙⴰ ⵙⵍⵙ ⴹⵜⵎⵜⵢ ⵀⵍⵙ ⴼⵍⵏ⵿ⴹⵓ ⵎⵙⴹⵏⵢⴰ ⴶⵎⴹ ⵀⵍⵙ ⵏ⵿ⵜⴰ ⵙⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⵗⵙ ⵜⴶⵢⵜ ⵢ ⴾⵍⵍⵢⵂⴹ ⵙ ⵗⵢⵙⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ⵎⵛⵏ ⴶⵢⵏ ⵙⵔⵙ ⴾⵍⵍⵢⵂⴹ ⵜⵔⵀⴹⵏ⵰ ⵀⴾⵀⴾ ⵀⵍⵙ ⵙⵍⵙⵏⵜ ⵍⵎⵗⵏⴰ ⵀⵙ ⴹⵔⵙⵏ ⴹⵔⵓ ⵓⵍⴰ⵰ ⵏⵙⵏ «ⵜⵍⵎⵏⵎ ⵎⵏⵓⵏ⵰ ⵓⵔⵜ ⵍⵈⵆⵏⵓⵏ ⵗⴼⵓⵏⵓⵏ ⵏⴾ ⵀⵙ ⴹⵓⵔ ⵍⵈⵆ ⵏⵀⴰ ⵏⵍⵗⵍⵙⵏⵓⵏ⵰ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵤⴾⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ⵜⵤⵔ ⴼⵍ⵿ⵜⵏ ⴶⵤ ⵂⵏ ⵏⵍⵙ ⴶⵏ ⵙⵎ ⵜⵜⵢⵙ ⵢⵙ⵿ⵜⵙ ⵎⵙⵏ ⵎⴾⵙⴹ ⵏⵎⵛⵏⴰ ⵙ ⵍⴰ ⵂⵏⵜ ⴹⴶⵎⴰ ⵏⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ⴾⵔⵙⵀⵙ ⵓⵏ ⵎⵤⵔ ⵏⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⵜⴰ ⵤⴶⵤⵏ ⵙⵎⵍⵢ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⵢⵜⴹⵏ ⵏⵗⵢⵓⵏⵜ ⴾⵍ⵰ ⵙⵍⵏ ⴾⵍⴾⵔⵏ⵿ⵜ ⴶⵜⵏⵏ ⵢ ⵙⵍⵏ ⵓⵏ ⵜⴶⵓ ⵀⵍⵙ ⵤⴶⵤⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵜⵤⵔ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ⵙ ⵂⴹ ⵢⵏ ⴶⴰ ⵀⵍⵙ ⵜⵔⴶⵜ ⴹⵗ ⴹⵙⵏⴰ ⵎⵍⵢ «ⴰ ⴾⵢ ⵓⵔ ⵜⴶⵤ ⵜⵙⴰ ⴾⵍⵔ ⵛⵓⵍ ⴹ ⵓⵔ ⵜⴼⵙ⵿ⵜⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ⵍⵆⵓ ⴹⵔⴾ ⵓⵔ ⵜⵍⴰ ⵢ ⵤⴼⵔⴶⵏ ⴹⴾⵈⵛⴹ ⵔⵜ ⴼⵍⵙ ⵍⵗ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵗ ⵗⵔⵎ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ⵈⵙⵔ ⵀⵍⵙ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴾⵔⵏ⵿ⵜ ⵂⵔ ⴶⴰ ⵓⵜⵢ ⴹⴶⵏⴰ ⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ⵤⵎⵏ ⵓⵏ ⴹⵗ ⵎⵙ ⴶⵍⵢⵏ ⵏⵈⴾⵎ ⵏⴾⵍ ⵓⵏ ⴾⵢⴰ ⵏ⵿ⴾⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵗⴼ ⴼⵍ ⵀⵍⵙ ⵀⵤⵏ⵿ⵜⵓ ⵓⵢⵏ⵿ⵜⵓ ⵙⴹⴶ ⵏⵛⵔⵗⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ⵏⵏ «ⵍⵙ ⵓⴰ ⴶⵎⵢ ⴹⴹ ⵗⵀⴹⵏ ⵢⵜⴹⵏ ⵎⵛⵏⴰ ⵙ ⵜⵎⵓⵜ ⵜⵎⵤⵔⵢⵜ ⵛⵔⵗⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ⵙ ⵤⵎⴰ ⵙⵏ⵿ⵜⴰ ⵀⵍⵙ ⴹⵗ ⵓⵍ ⵏⴰ ⴶⵍⵢⵏ ⵢ ⴾⵍⵍⵢⵂⴹ «ⴾⵓⵏⵢ ⴾⵍⵍⵢⵂⴹ ⵏⵔ ⵙⴰ ⴹⴹⵜⴶⵎ ⴹⵗ ⵀⵜⵓ ⵏⵔⵜ ⵎⵤⵔⵢⵏ ⵛⵔⵗⴰ ⵎⴹⵗ ⵔⴾ ⵎⵤⵍ ⵍⵀⵙⵏ ⵎⵍ⵿ⵜⵓ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⴹⵓⵏ⵿ⵤⵙⵙⵎⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ⵎⵛⵏ ⵤⵎⴰ ⵓⴰ ⵜⵎⵤⵆ ⵜⴶⵜ ⴼⵍ ⵜⴼⵔ ⴹⵙⵎⵓⵏ ⴹⵛⵔⵗⵏⵓⵏ ⵛⵔⵗⵜⵏ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵏⴾ ⵓⵔ ⵔⵗ ⴹ ⵆⵍⴰ ⵎⵛⵔⵗ ⵏⵔⵜⵏ ⵤⵏ ⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ⵎⵔⵏ ⵙⵙⵔⴹⵆⵏ ⵂⵏ ⵓⵏ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ⵜⵤⵔ ⵏ⵿ⴾⵔⵏ ⴾⵜⵏⵙⵏ ⵀⵤⵏ ⵙⵙ⵿ⵜⵏⵙ ⵓⵏ ⵎⵤⵔ ⵏⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⴹ ⵜⴶⵜⵏ ⴹⴰ ⴹⴰ ⴹⵜ ⵂⵏ ⵓⵏ ⵛⵔⵗⴰ⵰ ⵎⵛⵏ ⵓⵔ ⵤⵍⵢ ⴶⵍⵢⵏ ⴹⵗ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ⴶⵍⴰ ⵀⵍⵙ ⵈⵙⵔ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⴾⵔⵏ⵿ⵜ ⵂⵔ ⵔⵓ⵰ ⴹⴼⵔ ⴹⵢ ⵏⵎⴶⴰ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵛⵓⵜⵔⵓⵏ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴾⴰ ⵙⵔⵢⴰ ⴹⵓ ⴹⴼⵔⵙⴾⴰ ⴹⴾⵍⵙ⵰ ⵂⵔⵓⴹⴰ ⵓⵔ ⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⵆⵏ⵿ⴾⵔⵢⴰ ⵏⵎⵂⵤⵏ ⴹⴾⵔⵏ⵿ⵜ ⴾⵓ ⵙⵔⵢⴰ ⴹ ⵍⵤⴰ ⵗⴼⵏⵜ ⵢⴹ ⵙⴾⵏⵓ ⵙⵓⵏ ⴹⵓⵍ ⵓⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ⵙ ⵙⵏ ⵗⵔⵎ ⵏⴼⵤ ⵎⵤⵢ ⴹⵔⵙⵏ ⵀⵍⵙ⵰ ⴶⵍⴰ ⵏ⵿ⵜⴰ ⴶⵤ ⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⵎⵛⵓⵍ ⴹⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ⴶⵎⵢⵏ ⴹⵗⵙ ⵗⵔⵙⵏ ⵂⴶ ⴶⵢⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ⵎⵛⵏ ⵙ ⵜⵏⴼⵍ ⵏⵙⵏ «ⵓⵔ ⵎⴾⵏ ⴹⵓⵔⴶⴰ ⵎⴹ ⵓⴰ ⴹⵤⵢⵏ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ⴾⵓⵏ⵿ⴹⵆⵍⴰ ⴾⴹ ⵎⵛⵏⴰ ⵔⴹⴰ⵰» ⴶⵎⴹ ⴼⵤ ⵂⴰ ⵗⵍⵍ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ⵙ ⵤⵀⵜ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⵆⵢⵙⵔⵢⴰ ⴶⵤⵢ ⴾⴰ ⵢⵔⵙⵍⵎ ⵙⵙⵍⵎ ⵍⴾⵏⵙⵜ ⴹⴼⵔ ⴹⵢ ⵤⴶⴹⵢ ⴾⴰ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ⵙ ⴹⵗⵙ ⴶⴰ ⵜⵎⵔ⵿ⵜ ⴶⵎⴹⵜⵓ ⵍⵍ ⴾⵍ ⵓⵏ ⴶⵍⵜⵢⴰ ⴹ ⵓⵏ ⴼⵔⵌⵢⴰ ⵙⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ⵙ ⵜⴶⵓ ⵓⵏ ⵗⵔⵎ ⵏⴼⵤ ⵙⵢⴹⵓ ⵍⵙ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵙⵎ ⵀⵍⵙ ⵏⵗⵔⵎ ⵏⵍⵙⴾⵏ⵿ⴹⵔⵢⴰ ⵎⵙⵏ ⵍⵙ ⵙⵏⵏ ⵓⵍ ⵓⵍⵏ ⴶⵏ ⵎⵙⵏⵜ ⵜⴶⵜ ⵢⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ⵜⵓⵙⵙⵗⵔⴰ ⵜⵔⵢⵜ ⵜⵏ ⵎⵍⵢ ⵎⵔⵏ ⴾⴼⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴶⵍⵢⵜ ⴹⵗ ⴶⵢ ⵏ⵿ⵜⵍⵈⵜⵀⵜ ⵙⵙⵗⵔⵓ ⴹⵗ ⵙⵍⵗ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵗⵢⵙⴰ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙⵍⵏ ⵏⵙⵍⵎⵗ ⵓⴰ ⵜⴶⵓ ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⵗⵙ ⵜⵂⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ⴹ ⵜⴶⵓ ⵓⵍ ⴹⵆⵓ ⵓⵔ ⵜⵂⴰ ⵜⵙⴰ ⴹⵗ ⵂⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ⵰ ⵙ ⴹⵙ⵿ⵜⵙⵍⴰ ⴼⵔⵙⴾⴰ ⴹⴾⵍⵙ ⴹⵓⵏ ⴹⵔⵙ ⵙⵙⵗⵔⵏ⵿ⵜⵓ ⵙⵍⵗ ⵛⵜⵏⵙ ⵎⵙⵏⵜ ⵜⴰ ⴶⴰ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ⴹⴼⵔ ⵓⵏ ⵙⵎⵔⴾⵙ ⵀⵍⵙ ⴾⵢ ⵏⴾⵍ ⵓⵏ ⴾⵢⴰ ⵜⵤⵔ ⴹⵂⵍⵏ⵿ⵜⵓ ⵎⴹⵔⵢⵏⵜ ⴹⵗ ⵤⴶⵤⵏ ⵙⵓⵏ⵰ ⴾⵜⵀⵏ ⵛⵔⵓⵜ ⵢ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵜⵂⵏⵏ ⴼⵍ ⴹⵙⴶⵏ ⵜⵎⵓⵜ ⵜⵍⵗⵜ ⵙ ⵜⵏⵏⵙⴰ⵰ ⵙ ⴹⵏⵙⴰ ⵜⴶⵤⵜⵓ ⵜⵏ⵿ⴼⴰ ⵤⵓⵔⵜ ⴹⵜⴼⵍⵜ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ⴼⵍⵙ ⵙⵀⵂⵓ ⵙⵙⵂⵜ ⴹⵜ ⵜⵎⵜⵢ ⴹⴼ ⵓⴰ ⴶⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⵙⴾⵏⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ ⵗⵢⵙⴰ ⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ⵤⵎⵏ ⵓⵏ ⴹⵗ ⵂⴰ ⵀⵍⵙ ⴾⵔⵏ⵿ⵜ ⴹ ⵔⵤⴶ ⵀⵍⵙ ⴾⵍ ⵏⴹⵗⵗⵏ ⵂⵔ ⵔⵙ ⴼⵍ ⵗⵔⵎ ⵏⴼⵤ⵰ ⵏⵢ ⴹⵗⵙ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵢⴹ ");
INSERT INTO ttqt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ⵏⵙⵏ «ⵓⴾ ⴾⵓⵏⵢ ⵙ ⵜⵤⴶⵤⵏⵎ ⵜⴶⵔⵓⵎ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰» ⵏⵏⵙ «ⵓⵔ ⵏⵙⵍⴰ ⴼⴹⴰ ⵙ ⵜⵍⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ⵏⵙⵏ ⵀⵍⵙ «ⴹⵗ ⴹⵢ ⵎⴰ ⵎⵙ ⵤⵏⴼ ⵏⵙⵍⵎⵗ ⵓⴰ ⵜⵜⵓⴶⵎ ⴹⵗ ⵎⵏ⵰» ⵏⵏⵙ «ⵙⵍⵎⵗ ⵓⵏ ⵢⵈⵢⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ⵎⵔⵏ ⵏⵙⵏ ⵀⵍⵙ «ⵢⵈⵢⴰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵀⵏⵏ ⴹⵗ ⵀⴾⴹⵏ ⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵙⴾⵏⵓ ⴹⵢ ⵜⵜⵀⵜⵏⵙⵏ ⵎⵍⵙⵏ ⴹ ⵤⴶⵤⵏⵏ ⵙ ⵓⴰ ⴹⵤⵙⵏ ⴹⴼⵔⵙ ⵍⵎⵗⵏⴰ ⵗⵢⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ⵙ ⵙⵍⵏ ⵢⵓⵏ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴹⵗ ⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ⵜⵤⵔ ⵙⵓⵔ ⵀⵍⵙ ⴾ ⵢⵏ ⴹⵗⵙⵏ ⴼⵙⵏⵜ ⴶⵔⵓⵏ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵛⵓⵍⵏ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⴶⵔⵓⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ⵎⴹⵏ ⵏ ⵎⵔⵓⵙⵏ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ⵎⵔⵏ ⴹ ⵜⴾⵓ ⵀⵍⵙ ⵂⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵜⴶⵓ ⴹⵗⵙ ⵜⵍⵈⵜⵀⵜ ⵓⵔ ⵜⵍⴰ ⵙ ⵜⵜⵂⴰ ⵜⵙⵏⵜ ⵂⵔ ⴶⴰ ⴾⵔⴹⵜ ⵜⵍⵍ⵰ ⴶⵎⵢ ⴹⴹ ⵙⵜⴹⵓ ⵢ ⴾⵍⵍⵢⵂⴹ ⵙⵍⵏ ⵓⵏ ⵜⴶⵓ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ⵎⵛⵏ ⵙⴶⵔⵎⵎⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵓⵍⵏⵙⵏ ⴶⵢⵏ ⵙⴹ ⵤⴶⵤⵏⵏ ⵙⵓⴰ ⴶⵏⵓ ⴼⴹⴰ ⴹ ⴶⵏⵏ ⴹⵜ ⵜⴹⵓⵜ ⵔⵜⵏ ⵓⵔ ⵏⵍⵗ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵎⵍⵢ⵰ ⵎⵤⵢ ⴹⵔⵙⵏ ⵀⵍⵙ ⴹⵓ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵜⵏⵙⵙⵗⵔⵓ ⴾ ⵤⵍ ⴹⵗ ⵂⵏ ⵏ⵿ⵜⵗⵔⵢ ⵏⵍⵙ ⵢⵏ ⴶⴰ ⵙⵎ ⵜⵔⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ⵂⵔ ⴶⴰ ⵛⵏ ⵍⵏ⵰ ⵂⵔ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⴾⵍ ⵏⵙⵢⴰ ⴶⵔ ⵤⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵓⵏ ⴾⵍⵍⵢⵏⵏ ⴾⵜⵏⵙⵏ ⵙⵍⵏ ⵢⵓⵍ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ⵙⵙⴶⵓ ⵎⵛⵏⴰ ⵀⵍⵙ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ⵂⵔ ⵙ ⵜⵎⵓⵢⵏ ⵍⴾⵛⴼⵜⵏ ⴹⵜⵙⵓⴹ ⵏ⵿ⵜⵀⴹⵆ ⴹⵙⵏⵏ ⵀⵍⵙ ⴼⵍ ⵙⵔⵙⵏ ⵜⵓⴹⵙⵏ ⵎⵔⵏⵏ⵰ ⵜⵤⵢⵏ ⵢⵜⴹⵏⵏ ⴹⵗ ⵜⵓⵔⵏⵓⵏⵙⵏ⵰ ⵓⵏ ⴹⵗⵙⵏ ⵂⵏ ⴾⵍⵙⴼ ⴹⵗ ⴶⵎⴹⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ⵏ⵿ⴾⵔⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵢⴹ ⵍⵎⵏⵏ ⴶⵔ ⴾⵍⵏ ⵜⴾⵙⵏ ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⴹ ⴶⵎⵢⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴾⵙ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⵢⵜⴹⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⴶⵏⵏ ⴹⵗ ⵜⵎⴶⵔⵓⵏⵙⵏ «ⵂⴹⵗⵓⵏ ⵙ ⵗⵢⵙⴰ ⵓⵙ ⵜⴶⵓ ⵀⵍⵙ ⵙⵍⵏⵜ ⵔ ⴹ ⵜⴶⵎⴹⵎ ⵓⴹⵏ ⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ⵙⴰ ⵎⴹⵏ ⵏⵎⴹⵔⵢⵏ ⵎⵙⵏⵏ ⵎⴹⵏⵙ ⵏⵎⵤⵔ ⵢⵏ ⵏⵍⵎⵎ ⴶⵏ ⵙⵎ ⵙⵓⴰ ⵜⴶⵏⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ⵙ ⵏⵏ ⵓⵏ ⵢⴶⵙⴼ ⴹⵙⵏⵏⵓ «ⵤⴹⵢⵗ ⵗⵢⵙⴰ ⵀⵍⵙ ⴹⵗ ⵛⵏⵗ ⵓⴰ ⵎⵙ ⴾⵓⵏⵢ ⵎⵔⵏ ⵎⴰ ⵜⵎⵙⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ⵜⵤⵔ ⴼⵜⵆⵜ ⴹⵗⵙⵏ ⵓⴹⵏ ⵓⴰ ⵂⵏ ⴾⵍⵙⴼ ⴹⴰ ⴶⵤⵏⵜⵓ ⵜⵗⵔⴹ ⵜⵙⵙⵔⵏⵏⵏ ⵎⴹⵏⵏ ⴾⵜⵏⵙⵏ ⵗⵍⵀⵜⵏ ⵙ ⵜⵓⵜ ⵂⵔ ⵙ ⵙ ⴶⵎⴹⵏ ⵂⵏ ⵓⵏ ⵤⵍⵏ ⵤⴼⵏ ⵀⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ⵙⵍⵏ ⵢⵜⴹⵏ ⵏⴼⵤ ⴾⵍ ⵓⵏ ⴶⵔ ⵤⴰ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵓⵏ ⴾⵍⵍⵢⵏⵏ⵰ ⵜⴶⵤⵜⵏ ⵜⵙⴰ ⴾⵜⵏⵙⵏ ⵜⵤⵔ ⵤⵤⵓⵔⵏ ⵓⵍⵏ ⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ⴹⵜⵙⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵤⴶⵤⵏⵏ ⵙ ⵎⵛⵏⴰ ⵙⵗⵍⵏ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⵙ ⴾⵍⴰ ⵜⵏ⵿ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ⵓⵢⵏ⵿ⴹⵓ ⵎⵙⵈⵔⵏ ⴶⵜⵏⵏ ⵍⴾⵜⵀⵏⵙⵏ ⵙⵆⴹⵏ⵿ⵜⵏ ⴹⵜ ⵓⴹⵏ ⴾⵍ⵰ ⵜⵓⵈⵙⵀ ⵓⴰ ⴹⵏ⵿ⵤⵏ ⵆⵍ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏⴶⵎ ⵏ⵿ⵜⵎⴰ ⵏⵤⵔⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ⵎⴾⵏ ⴹⴰ ⵙ ⵜⵤⵓⵤⵓⵤ ⵜⵔⵏⴰ ⵏⵎⵍⵢ ⵓⵍ ⵏⵎⵛⵏⴰ ⵜⵙⴾⵏⴰ ⵙⵂⵜ ⵜⴰ ⵜⵂⵜ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ⴹⴼⵔ ⵓⵏ ⵙⵎⵔⴾⵙ ⵀⵍⵙ ⴹⵗ ⵎⵏⵜ ⴾⵢ ⵏⵢⵔⵙⵍⵎ ⵎⵔ ⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ ⴹ ⵓⵏ ⴾⵢⴰ⵰ ⴶⵏⵓ ⴹⵗ ⵎⵏⵜ «ⴹⴼⵔ ⵙ ⵙⵗ ⵢⵔⵙⵍⵎ ⴾⵏ⵿ⴹⵀⴰ ⴾⵗ ⵗⵔⵎ ⵓⵏ ⵔⵎ ⵏ⵿ⵜⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ⵜⵤⵔ ⵤⵎⵤⵍ ⵜⵎⵜⵢ ⴹⵔⵙ⵿ⵜⵙ ⵓⵏ ⵎⴹⵂⵍⵏⵜ ⵙⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵍⴰ ⵂⴰ ⴾⵍ ⵓⵏ ⵙⵢⴰ ⵂⵔ ⴹⵗⵙ ⵂⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ⵤⵎⵏⵏ ⵏⵌⵔⵓⵢ ⴹⵗⵙⵏ ⵗⵔⵎ ⵏⴼⵤ ⵓⵍⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ⵍⵢ ⵏⴹ ⵢⵏ ⴶⵏ ⵙⵎ ⴹⵎⵜⵔⵢⵙ ⵜⴶⵏ ⴹⵗ ⵤⵔⴼ ⴼⵜⵜⵏ ⵏⵂⵏ ⵏⵙⵏⵎ ⵢⵏ ⵎⵙⵏ ⵜⵏ⵿ⵜⵜ ⵜⴶⵜ ⵙⵎ ⵔ⵿ⵜⵎⵙ⵰ ⴶⵔⵓ ⴹⵗ ⵓⵏ ⵜⵏ⵿ⴼⴰ ⵜⴾⵏⵜ ⴶⵜ ⵢ ⵏⴹⵏ ⵓⵏ ⵎⴹⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ⵛⴹⵓⵜⵏ⵿ⴹⵓ ⴾⵜⵏⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⵏⴹⵏ ⵓⵢⴹ ⵓⵏ ⴹⵔⵏⵏ ⴹⵗ ⵓⵏ ⵏⵙⵏ «ⵢⴰ ⵎⴹⵏ ⵜⵙⵏⵎ ⵙ ⵜⴶⵔⴶⵙ⵿ⵜⵏⵏⴰ ⵜⵆⵏ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ⵎⵛⵏ ⵜⵂⵏⵢⵎ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵙⵍⵎ ⴹⵗ ⵓⴰ ⵜⴶⵓ ⵍⵙ ⵓⴹⵢ ⵙ ⵜⵓⵏⵓ ⴹⵢ ⵀⵍⵙ⵰ ⴶⵏⵓ \"ⵎⵍⵏ ⵓⵏ ⴶⵏ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵎⵙⵏ ⴼⴹⴰ ⵎⵍⵏ⵰\" ⵤⵤⴶⵤⵏ ⵓⵏ ⵢⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵓⵔⴶ ⴹⴰ ⴹⴰ ⴹⵗ ⴼⵤ ⵗⵙ ⴹ ⵙⵈⵔⴾ ⵢⵜⴹⵏ ⴾⵍⵔ ⵂⵔⴾⴹ ⵜⵛⵎ ⵏⵢⵜⴹⵏ ⵓⵏ ⴾⵍ ⵏⵙⵢⴰ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ⵔⵜ ⵓⴰ ⵓⵔⴶⵗ ⵛⵗⵍⵏⵏⴰ ⵗⵙ ⵙ ⴹⵤⵓⵢ ⴶⵤ ⵏ⵿ⵜⵤⴾ ⵏⴹ ⵜⵓⵍⴾⵓ ⴾⵍⵔ ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵏ ⵔ⵿ⵜⵎⵙ ⴹⵢ ⵎⵆⵔⵜ ⵜⴰ ⵜⵎⵙⵜ ⵜⵎⵍⵜⵏⵏⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⴹ ⵔ⵿ⵜⴾ ⵍⵎⵆⵎⵏⵜ ⵜⵎⵤⵢ ⴼⴹⴰ ⴹⵜⵓⵙⵗⵎⵔ ⵏ⵿ⵜⴰ ⵗⵀⴹⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴾⵍ ⵏⵙⵢⴰ ⴹⴹⵏⵜ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ⵙ ⵙⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵙⵙⵎⵏⵏ ⵢⵓⵏ ⴶⵤⵜⵏ ⵍⵂⵎ ⵍⵀⵙⵏ ⵙⴾⵏ ⵎⵙⵍⵏⵙⵏ ⵌⵏⵓⵏ ⴶⵏⵏ «ⵔ⵿ⵜⵎⵙ ⵜⵏ ⴾⵍⴼⵤ ⴹⵢ ⵎⵆⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ⵜⴶⴰ ⵜⵏⵌⵔⵓⵢⵜ ⴹⵗ ⵗⵔⵎ ⴾⵜⵏⵜ⵰ ⵜⵏ⵿ⴾⵔ ⵜⵎⵜⵢ ⵜⴶⴶ ⵙⵂⵏ ⵤⵓⵔⵏ ⵓⵏ ⵎⵏⵢ ⵜⵍⵓⵢ ⴶⵢⵙ ⴹⵔⵙ⵿ⵜⵔⵈⵙ ⵓⵏ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⵎⵙⵏⵏ ⵎⴹⵓⵏ ⵏⵀⵍⵙ ⴹⵔ ⴹⵓ ⴹⵗ ⵛⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ⵜⵤⵔ ⵔⴰ ⵀⵍⵙ ⴹ ⴾⵓ ⵜⵎⵜⵢ ⵜⵏ ⵎⵛⵏ ⴶⴹⵍⵏⵙ⵿ⵜⵓ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ⵓⵍⴰ ⵔⵜ ⴹⵗ ⵎⵤⵔⵏ ⵏⴾⵍ ⵏⵙⵢⴰ ⵏⵎⴹⵓⵏⵜ ⴹⴰ ⵤⵎⵤⵍⵏ ⵙⵔⵙ ⵢⵜⴹⵏ ⵢⴹⵗⵙ ⴶⵎⵢⵏ ⴹ ⵓⵔ ⴾⴰ ⵂⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⵎⵜⵢ ⵜⴰ ⵜⴹⵓⵜ ⴹⵗ ⵂⵏ ⵏ ⴾⵜⵏⵜ ⵜⵏⵌⵔⵓⵢ⵰ ⵙⵗⵔⵏ ⵢⵜⴹⵏ ⴹⵗ ⵌⵏⵓⵏ ⴶⵏⵏ ⵔⵜⵏ ⵓⵔ ⵏⵍⴰ ⴼⵍⵙ ⵜⵛⵎⵏⵙⵏ ⵓⵔ ⵙⵏⵏ ⴼⴹⴰ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⴹⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ⵀⴹⵗⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵍⵙ ⴶⵏ ⵙⵎ ⵍⵙⴾⵏ⵿ⴹⵔ ⵙ ⵜⴹⵓⵜ ⵜⵎⵍⵙ ⵓⴰ ⴶⵏ ⴹⵏ⵰ ⵜⵤⵔ ⴹ ⵙⴹⴶⵏ ⵙⴼⵙⵏⵜ ⵢ ⵜⵎⵜⵢ ⵜⴼⵙ⵿ⵜⵜ ⵢⴹⵙⵏⵛⵓⵍ ⵙⵙⵎ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ⵎⵛⵏ ⵙ ⴶⵔⵏ ⵙ ⵓⴹⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵎⵙ ⵙⴾⵏ ⵎⵙⵍⵏⵙⵏ ⵌⵏⵓⵏ ⵌⵌⵢⵏ ⴶⵏⵏ «ⵔ⵿ⵜⵎⵙ ⵜⵏ ⴾⵍⴼⵤ ⴹⵢ ⵎⵆⵔⵜ⵰» ⵂⵔ ⴹⵏⴾⵏ ⴹⴶ ⵏ⵿ⵙⵏⵜⵜ ⵙⵗⵜⵏ ⴶⵏⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ⵍⵙ ⵓⴰ ⵎⵙⵏ ⵏⴾⵜⵀ ⵏⵗⵔⵎ ⵏ ⵏ⵿ⵜⴰ ⵙⵂⴹⵔⵏ ⵜⵎⵜⵢ ⵏ ⵏⵙ «ⵢⴰ ⵎⴹⵏ ⵏⴼⵤ ⵓⴾ ⵍⵢ ⵓⴹⵏ ⵓⵔ ⵏⵙⵏ ⵙ ⵗⵔⵎ ⵓⵏ ⴼⵤ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⴶⵤ ⵏⵂⵏ ⵓⴰ ⴹⵗ ⵜⵜⵓⵗⵀⴹ ⵔ⵿ⵜⵎⵙ ⴹⵢ ⵎⵆⵔⵜ ⴹⵛⵛⵍⵏⵜ ⴶⵏ ⴹⵗ ⵜⵂⵏ⵿ⵜ ⵙ ⵌⵏⵓⵏ ⴹⵗ ⴹⵜⵔ⵿ⵜⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ⵤⵎⴰ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙ ⵌⵂⵍ ⵓⵏ ⵓⴹⵢ ⵂⵔ ⴹ ⵜⵂⴹⵔⵎ ⴹ ⵓⵔ ⵜⴶⵎ ⵔⵜ ⵓⵍⵢⵏ ⴹⵗ ⵜⵔⵔⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ⴼⵍⵙ ⵎⴹⵏ ⵓⵏ ⴹⵜⵍⵓⵢⵎ ⴹⴰ ⵓⵔⵎⴹ ⵎⵙⵏ ⵀⵢⴹⴶⵏ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵓⵍⴰ ⴹⵗ ⵏⵏ ⵍⵀⵙⵏ ⵙ ⵜⵎⵍⵜⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ⵎⵔⵏ ⴾⴹ ⴹⵎⵜⵔⵢⵙ ⴹⵏⴹⵏ ⵓⵏ ⵎⴹⵓⵏⵜ ⵍⵢ ⴹⵙⵏⵗⵛⴹ ⵓⴹⵏ ⵓⴹⵢ ⵍⵏ⵿ⵜⵓ ⵌⵍⵏ ⵓⵏ ⴹⵗ ⵜⴶⵓ ⵛⵔⵗⴰ ⵍⵏ⵿ⵜⵓ ⴹⵗ ⵏⵈⴾⵎⵏ ⵓⵏ ⵜⵜⴶⵏⵏ⵰ ⴾⵏⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ⴾⴹ ⴹⵗ ⵓⵢⴹ ⵔⵜⵏ ⴹⵔ ⵜⵙⵙ⵿ⵜⵏⵎ ⴹ ⵜⵜⵓⴾⵏⵓ ⵜⵗⵓⵛⵢ ⵜⴹⵢ ⴹⵗ ⵙⴶⵓⵔ ⵓⴰ ⵙⴾⵜⵏ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ⵏⴾⵏⵢ ⴹⴰ ⵎⵔⴹⴰ ⵂⵏⵏ ⵜⵤⴾ ⵏⴹ ⵜⵓⵏⵓ ⴼⵍⴶ ⵏⴶⴰ ⴼⵍ ⴹⵍⵍ ⵏⵓⴰ ⴶⵏ ⵤⵍⴹⴰ⵰ ⴼⵍⵙ ⵓⵔ ⵜⵍⴰ ⵙⵔⵓ ⵏⴶⴰ ⵙ ⵏⵏⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⵜⴶⴰ ⵜⵏⵌⵔⵓⵢⵜ ⵜⴰ⵰» ⵗⵔⴹ ⵏⴾⵜⵀ ⵏⵗⵔⵎ ⵓⵍ ⵓⵏ ⵗⵙ ⵏⴰ ⵢ ⵜⵎⵜⵢ ⴹ ⵜⵓⵤⵓⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ⵙ ⴹⵔⵔⵏ ⵢⵜⴹⵏ ⵙⵙⵗⵔⴹⵓ ⵀⵍⵙ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵙⵏ ⵏⵙⵈⴰ ⵙⵙⵎⴹ ⵓⵍⵏⵙⵏ ⵎⵔⵏ ⵏⵎⴶⴰ ⴹⵔⵙⵏ ⵛⵓⵜⵔⵓⵏ ⴶⵍⴰ ⴾⴰ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ⵔⵤⴶ ⴾⵍⵏ ⵜⴶⵓ ⵏⵙⵈⵜⵏ ⴶⵜⵏⵏ ⵢ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵜⵍⵎⵙⵏ ⴼⵍ ⵎⵏ ⴹⴼⵔ ⵓⵏ ⴾⴰ ⴾⵍ ⵓⵏ ⴾⵍⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ⴶⴰ ⴹⵗⵙ ⴾⵔⴹⵜ ⵜⵍⵍ⵰ ⵙⵎⵜⴶ ⵢⴶⵤ ⵏⵗⵍⵍ ⵏⵎⵏ ⵙⴾⵍ ⵏ⵿ⵙⵔⵢⴰ ⵙ ⵜⴶⵤⵏ ⵙⵍⵏ ⵏⵙ ⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵗⴼ ⴼⵍ ⵜⵏ⵿ⵗⵏ ⵜⵤⵔ ⴶⴰ ⵜⵏⵜ ⵏⴹ ⵆⵍ ⴹⴼⵔⵙ ⴶⵓ ⵜⵔⵢⵜ ⵜⵏ ⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ⴹⵓ ⴹⵙⴼⵜⵔⵙ ⴶ ⴼⵔⵙ ⵓⵏ ⵗⵔⵎ ⵏⵀⵔⵓⵢⴰ ⴹⵔⵙ⵿ⵜⵔⵈⵙ ⴹⵙⴾⵏ⵿ⴹⵙ ⵓⵏ ⵏⵗⵔⵎ ⵏ⵿ⵜⵙⵍⵏⴾ ⴹⴶⵢⵙ ⵓⵏ ⵗⵔⵎ ⵏ⵿ⴹⵔⵀ ⴹⵜⵛⴾ ⴹⵜⵔⴼⵎⵙ ⵓⵏ ⵏⴾⵍ ⵏⵙⵢⴰ ⵎⵔⵏ ⴹⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ⴶⵍⵏ ⵎⴹⵏ ⵓⵏ ⵤⵔⵏⵏⵗ ⵆⵍⵏⵏⵗ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔⵓⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ⵎⵔⵏ ⵏⴾⵏⵢ ⵙ ⴼⵍⵏⵗ ⴾⵢ ⵎⴹ ⵓⴰ ⴹⵗ ⵜⵜⵏ ⵢⵜⴹⵏ ⵛⴶⵍⵓⵏ ⵛⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⴼⵍⵀ ⵏⴾⴰ ⵜⵔⵓⵙ⵰ ⵙ ⵏⴶⴰ ⵙⵎⵙ ⴹⵏ ⴼⵍ ⴶⵔⵓ ⵏⵙⵏⵏ ⵏⴶⴰ ⴹⵏ ⵙⴰ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ⵙ ⵤⵍ ⵓⵏ ⵍⵈⴹ ⵎⵙⵏ ⵤⵍ ⵓⴰ ⵤⵔⵏ ⴹⵗ ⵌⵍⵏ ⵏⵎⵏⵢ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⵢⴹ ⵏⴹⵔⵓ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵙⴾⵜⵏ⵰ ⵛⵓⵍ ⵀⵍⵙ ⵢ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵂⵔ ⵙⴶⵔⵢⴶⵔⵢ ⵂⴹ ⴼⵍⵙ ⵛⴾⵍ ⴼⵍ ⵏ⵿ⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ⵂⵏⵜ ⴼⵜⵍⵜⵏ ⴶⵜⵏⵏ ⵂⵏ ⵎⵙⵏ ⵙⵔⵓ ⵓⴰ ⴹⵗ ⵏⵎⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ⵛⵓⵍ ⵀⵍⵙ ⴹⵏ ⵆⵎ ⵍⵙ ⵢⵏ ⵏⵎⵓⴹ ⴶⵏ ⵙⵎ ⵢⵜⵈⵙ ⴼⵍ ⴼⵏⵜⵔ⵰ ⵍⴰ ⴹⵏ ⵂⵔ ⵜⴶⵤ ⵜⵙ ⴹ ⵜⵏⴹⵎ⵰ ⴶⵍⴰ ⵂⵔ ⴹⵗⵙ ⴶⵍⴰ ⵜⵙ ⵓⵍⵏ ⴼⵜⵆⵜ ⴾⴰ ⵎⴹⵍ⵰ ⴼⵏⵜⵔ ⵏ⵿ⵙⵔⵓ ⵓⵏ ⴾⵔⴹ ⴼⵍ ⴹⴼⵜⵆⵜ ⴹⵏ⵰ ⵙ ⴹⵎⴹⴾⵍ ⵓⵔ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ⵤⵀⵜⴹⵓ ⵙⵔⵙ ⵀⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⴼⵜⵆⵜ ⴼⵍⵙ ⵤⵍⵎⵜⵓ ⵏⴰ «ⴹ ⵓⵔ ⵜⵛⵓⵛⵎ ⴹⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ⵜⵤⵔ ⵆⵍ ⵀⵍⵙ ⵂⵏ ⵓⴰ ⴹⵤⵀⵜ ⵤⵏ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵙⴾⵜⵏ ⵙ ⵜⵛⵏ ⵍⵙ ⵀⵍⵙ ⵛⵓⵍⵙⵏ ⵂⵔ ⴹⵜⴶⵎⴹ ⵜⴼⴾ ⴹⵢ ⵎⵔⵏ ⴹ ⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ⵎⵓⴹ ⵏ⵿ⵜⴰ ⴹⵓⵏ ⴹⵔⵙ ⵢⵜⴹⵏ ⵙⵗⵢⵓⵏ ⴹⵔ ⵓⵔ ⵍⴰ ⵗⵍⵢ⵰ ⴾⵜⵏⵙⵏ ⵍⵎⵙⵏ ⵓⵏ ⵓⵍⵏ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ⵏⴾⵏⵢ ⵏⴶⵍⴰ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵏⴾⴰ ⵗⵔⵎ ⵏⵙⵙ ⵏⵤⵔ ⵢ ⵀⵍⵙ⵰ ⴹⵏ ⴹⴰ ⴼⵍⵏⴰ ⴹⵤⴶⵤ ⵗⵍⵍ ⵎⵙ ⵙ ⵓⵏ ⴹⴰ ⵙ ⵜⵙ ⴶⵏⵜ⵰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵔⴰ ⴹⵏⵌⵓⵏ⵿ⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ⵙ ⴹⵏⴹⵙⴰ ⴹⵗ ⵙⵙ ⵏⵏⵎⴶⵤ ⴹⵔⵙ ⵗⵍⵍ ⵏⵎⵏ ⵏⴾⴰ ⵗⵔⵎ ⵏⵎⵜⵍⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ⵏⴶⵎⴹ ⵎⵜⵍⵏⵙ ⵏⵂⴰ ⵗⵍⵍ ⵏⵎⵏ ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵏⵎⴹⵗ ⵢⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵈⵢⵓ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⴹⵢ ⵏⵓⴹ ⵓⵏ ⵙⵎⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⴹⵢ ⵏⵙⴰ ⵗⵔⵎ ⵏⵎⵍⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ⴶⴰ ⵀⵍⵙ ⵜⵏⵜ ⵏⵙ ⵓⵔ ⵤⵎⵔ ⴼⵤ ⴼⵍ ⴹ ⵓⵔ ⵍⵍⵜ ⴹⵗ ⴾⵍ ⵏⵙⵢⴰ ⴼⵍⵙ ⵔⵔⴹ ⵢⵔⵙⵍⵎ ⴼⵍ ⴹⵗⵙ ⵜⴶⵓ ⵎⴹ ⵓⵏ ⴼⵏ⵿ⵜⴾⵓⵜ ⴾⴹ ⴹⵢ ⴼⵔⴶ ⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ⵤⵀⵢ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵎⵍⵜⵙ ⵗⵔ ⵤⵎⵤⵍ ⵀⵍⵙ ⵓⴹⵏ ⵙⴶⵎⵢ ⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⵏⴼⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ⵙ ⵜⴹⵙⵏ ⵏⵙⵏ «ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵂⵏ⵿ⴾⵓⵏ ⵙⵍⵏ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⴹⵔⵓⵏ ⴶⵗ ⵓⴰ ⴹⴶⵤⵗ ⴾⵍ ⵏⵙⵢⴰ ⵤⵍ ⵓⵤⵔⵏ ⵂⵔ ⵓⵙ ⴾⵓⵏⴼⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ⴹⵎⴾ ⵓⵙ ⵜⴶⴰ ⵛⵗⵍ ⵏⵎⵍⵢ ⵙⵔⵙⵗ ⵎⵏⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⴹⵓⵢ ⵓⵏ ⴹⵎⵜⵓⵏ ⴹⵜⵎⵗⵜⵔ ⵛⵏ ⵙⵔⵢ ⴹⵜⵓⵢⵏⵜ ⵔⴾ ⵜⵏⴶⵎⵢⵏ ⵛⵏ ⴹⵜⴶⵏ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ⵜⵙⵏⵎ ⴹⵗ ⵙ ⵓⵔ ⴾⵍⴰ ⴹⵓⵏⵗⵀⵔⴰ ⵔⵜ ⵓⵍⵢⵏ ⴹⵓⵏ⵿ⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⵆⵎⴰ ⵓⵔ ⴹⵓⵏ⵿ⵜⵎⵍⴰ ⵙⵙⵗⵔⵓⵏ⵿ⵜⵓ ⴶⵔ ⵤⴰ ⴹⵜ ⵢⵜⴹⵏ ⵓⵍⴰ ⴹⵗ ⴹⵗ ⵏⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ⵓⵔ ⴾⵍⴰ ⵎⵤⵢⴰ ⴹⴶⵎⵢ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⴹ ⵜⵀⵏ ⵙ ⵎⵛⵏⴰ ⵤⴶⵤⵏⵏ ⵙⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ⵎⵔⵏ ⵎⵔⴹⴰ ⵏⴾ ⴹⴰ ⵤⵍⵤⵎ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵢ ⵏⵢⵔⵙⵍⵎ ⵓⵔ ⵙⵏⵗ ⵓⴰ ⴹⵆⵍⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⴹⵗ ⵙⵏⵗ ⵙ ⴶⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⴰ ⴹⵓ ⵗⴼ ⵙ ⵗⵔⵎ ⵙⵗ ⴹⴰ ⵍⴾⵎ ⴹⵗⵢ ⴾⵙⵓ ⴹⵍⵗⵤⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ⵓⵔ ⵗⵔⵢ ⵜⵎⵙ ⵜⵎⴹⵔ⵿ⵜⵏ ⴼⴹⴰ ⵓⵍⴰ ⵔⵜ ⵓⴰ ⵗⵔⵢ ⵜⵎⵙⵏ ⴹⵙⵈⵙⵍⴰ ⵔⵜ ⵓⴰ ⴹⴼⵔ ⵤⵍⴰ ⵗⵔⴹⴰ ⵛⵗⵍ ⵓⴰ ⴹⵗⵢ ⴶⴰ ⵎⵍⵢ ⵗⵢⵙⴰ ⵎⵙⵏ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ ⵂⵏ ⵙⵍⵏ ⵏⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ⵎⵔⵏ ⵎⵔⴹⴰ ⵙⵏⴰ ⴹⵗⵙ ⴾⵓⵏⵢ ⵓⵏ ⴶⵔ ⵍⵎⴰ ⴹⴰ ⵎⵍⴰ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵔ ⴹⵤⵜⵍⵙⵎ ⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ⴹⵢ ⴼⵍ ⴾⵓⵏⴶⵗ ⵤⵍⴹⴰ ⵛⴶⵢⵓⵏ ⵏⵙ ⵀⵙ ⴹⵓⵔ ⵍⵈⵆ ⵏⵤⵏⵢ ⵏⵓⵍⵢⵏ ⴹⵗⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ⴼⵍⵙ ⵓⵔ ⴾⵍⴰ ⴹⵓⵏⵗⵀⵔⵗ ⵔⵜ ⵓⵍⵢⵏ ⵎⵍⵗⵓⵏ ⵜⵔⵢⵜ ⴾⵍ ⵜⴰ ⴹⴾⵜⵀ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⴹⵎⵏⵓⵏ ⵜⵙⵏⵎ ⴹⵗ ⴹⵗ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵙ ⴾⵓⵏⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⴶⵤⵏⵜ ⵜⴶⵎ ⵢⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⵜⵎⴹⵏ⵿ⵜ ⵜⵍⵗⵜ ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ ⴹⵤⵏ⵿ⵤⴰ ⵍⵎⵙⵈ ⵙⵤⵏⵢ ⵓⵏⵜ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ⵙⵏⵗ ⵙ ⵏⴾ ⵙ ⴶⵍⵗ ⴾⵓⵏ⵿ⴹⴶⵤⵏ ⵢⵜⴹⵏ ⵓⵔ ⵏⵤⵍⵢ ⴹⵜⵤⵔⵢⵓⵏ ⵍⵀⵙⵏⵏ ⵓⵔ ⵤⴰ ⵏⵢⵓ ⵍⴾⵏⵙⵜⵏⵓⵏ ⵓⵔ ⵜⵜⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⴰ ⵂⵏ⵿ⴾⵓⵏ ⵢⵜⴹⵏ ⵙ ⵤⴰ ⵙⴼⵔⵗⵏⵏ ⵜⴹⵜ ⴼⵍ ⴹ ⵙⵈⵔⴾⵏ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ⴹⵗ ⴹⵢ ⴶⵜ ⵏⵢⵜ ⴹⵜⴾⵜⵎ ⵙ ⴾⵔⴹ ⵍⵏ ⴶⵗ ⵙⵙⵗⵔⵆⵓⵏ ⵙⵢⵏ ⵢⵏ ⵂⴹ ⵤⵍ ⵙⵔ⵿ⵜⵢⵗ ⵓⵏ ⴹⵎⵜⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ⵎⵔⵏ ⵎⵔⴹⴰ ⵙⵗⵍⴼⵆⵓⵏ ⵢ ⵎⵛⵏⴰ ⴹⵙⵍⵏ ⵓⵏ ⵎⵍⵏⵏ ⵔⵈⵎⵜⵏⵜ⵰ ⵎⵛⵏⴰ ⴼⵔⴶ ⵙⵙⵂⵢ ⵏⵤⴶⵤⵏⵓⵏ ⴹⵙⵜⴹⵢ ⵏⴶⵔⵓ ⵓⴰ ⵤⴰ ⵜⴶⵎ ⴹⵗ ⵜⴾⵙⵜ ⵜⴰ ⵙⵏ⵿ⵙⴰ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵤⴹⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ⵓⵔ ⴹⴹⵙ ⵙ ⴶⵗ ⵜⵎⵏⵏ ⴹⵗ ⵤⵔⴼ ⵓⵍⴰ ⵔⵗ ⵓⵍⴰ ⵙⵍⵙⴰ ⵏⵓⴹⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵙⵏⵎ ⵙ ⴼⵙⵏ ⵓⵏ⵿ⴹⵏⵏ ⵙ ⵛⵗⵍⴰ ⴾⵏⵗ ⵙⵛⵗⵍⵏⵙⵏ ⵜⵎⵗⵍⵜⵏⵏ ⴹⵛⵏ ⵎⴹⵓⵏⵏ ⵓⵏ ⴹⵔ ⴹⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ⴼⵓ ⵙⴾⵏⵆⵓⵏ ⵙ ⵎⴾⵏ ⴹⴰ ⵙ ⴾⵓⵏⵓⵔ ⴾⵓⵏⵢ ⴹⴰ ⴹ ⵜⵛⵗⵍⵎ ⴼⵍ ⴹ ⵜⵍⵍⵎ ⵢ ⵎⴹⵔⵔⵏ ⴹⵜⴾⵜⵎ ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵎⵍⵢ ⵗⵢⵙⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵙ ⵏⴰ \"ⵀⵍⵍ ⵓⴰ ⵜⴶⵓ ⵓⴹⵏ ⵓⴰ ⴾⴼⵏ ⴶⵔ ⵓⴰ ⵜⴶⵓ ⵓⴹⵏ ⵓⴰ ⴶⵔⵓⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ⵙ ⵏⴰ ⵀⵍⵙ ⵓⵏ ⴶⵔⴼⵜ ⵏ⵿ⵜⴰ ⴹⵔⵙⵏ ⴹ ⵜⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ⴾⵜⵏⵙⵏ ⵂⵍⵏ ⵜⵤⵍⵎⵏ ⵀⵍⵙ ⵜⵎⵍⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ⵔⵜ ⵓⴰ ⵗⵛⴹⵏ ⵎⵏⵙⵏ ⵓⵍⵏ ⵜⵏⴰ ⵜⴰ ⴹⵙⵏⴶⴰ ⵓⵔ ⵜⵤⵍⵙⵏ ⵏⵢ⵰ ⵎⵔⵏ ⵏ⵿ⵜⴶⵏ⵿ⵜⵓ ⵂⵔ ⵙⴰ ⵗⵍⵍ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ⵙ ⴹⵔⵙⵏ ⵏⵎⵤⵢ ⴶⵔⴹ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵤⵍ ⴹⵔⵏⴰ ⵙⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⴾⵙ⵰ ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵏⴶⵎⴹⵜⵓ ⵙⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵔⴹⵙ⵰ ⵏⴶⵎⴹ ⵔⴹⵙ ⵏⴾⴰ ⵗⵔⵎ ⵏ⵿ⴼⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ⵏⴶⵤⵏ ⴹⵗⵙ ⵗⵍⵍ ⵏⵎⵏ ⵜⴾⵏ ⴾⵍ ⵓⵏ ⴼⵏⵙⵢⴰ ⵜⵤⵔ ⵏⴶⵤⵜⵓ ⵏⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ⵙ ⵏⴶⴰ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵆⵀⵔⵙ ⵏⵗⵍⵢⵜⵓ ⴼⵍ ⴶⵏⴰ ⵓⵏ ⴶⵍⴰ ⵏⴹⴶ ⵙⴰ ⵙⵔ ⴾⵍ ⵓⵏ ⵙⵔⵢⴰ ⵂⵔ ⵏⵤⵀⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔ ⵙⵏ⵿ⵜⴰ ⴹⵗ ⵤⴰ ⵜⵓⵤⵤⵀⵏ ⵍⵍⵏ ⵓⵏ ⵓⵢ ⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ⵏⴶⵎⵢ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵂⵔ ⵜⵏⴶⵔⵓ ⵏⵤⵀⵜ ⵗⵔⵙⵏ ⵂⵔ ⵏⴶⴰ ⵙⴰ ⴹⵏ⵰ ⵏⵍⴰ ⵗⵔⵙⵏ ⵙ ⵜⵏⵙⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⴹ ⵏⵏ ⵢ ⵀⵍⵙ ⴹ ⵓⵔ ⴾⵓ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙ ⵏ⵿ⴹⵏ ⴹⵏ ⵓⵏ ⴹⵏ ⵏⵎⵜⴾⵓⵢ ⵏⴶⵍⴰ⵰ ⵏ⵿ⵜⴶⵏⵏⴰ ⴾⵜⵏⵙⵏ ⵂⵔⴾⴹ ⵜⴹⴹⵏⵙⵏ ⴹⵀⵔⵔⵏⵙⵏ ⵂⵔ ⵏⴶⵎⴹ ⵗⵔⵎ ⵎⵔⵏ ⵏⴶⵔⴼⵜ ⴹⵗ ⵜⵎⴰ ⵏⴶⵔⵓ ⵏⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ⵙ ⴹⵔⵙⵏ ⵏⵏⵎⴶⴰ ⵛⵓⵜⵔⵓⵏ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ⵰ ⵏ⵿ⵜⵏⵢ ⵆⵍⵏ ⵗⵓⵏⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ⵏⴶⵍⴰ ⴹⵗ ⵛⴾⵍⵏⵏⴰ ⵏⴶⵎⴹ ⵜⵔ ⵏⴾⴰ ⵀⵜⵍⵎⵢⵙ⵰ ⵙ ⴹⵗⵙ ⵏⵤⵀⵜ ⵏⴾⴰ ⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⵜⵂⵏⵏ ⵢⵜⵏⵙⵙⵍⵎ ⵏⴶⴰ ⵗⵔⵙⵏ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵏⴾⴰ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ⵰ ⵙ ⵜⵏⵙⴰ ⵏⵤⵀⵜ ⴹⵗ ⵂⵏ ⵏ⵿ⴼⵍⵀⵙ ⵓⵏ ⵎⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⵙⴰ ⵓⵏ ⵙ ⴾⵍⴰ ⵜⵓⵙⵏⴼⵔⵏⵏ ⴼⵍ ⴹ ⵜⵍⵍⵏ ⵢⵍⴾⵏⵙⵜ ⵜⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ⵍⴰ ⴾⵤⵜ ⵜⵀⵔⵔⵏ ⵓⵔ ⵏⵤⴹⵢ ⵎⴹⵏ⵰ ⵛⵀⵔⵔⵏ ⵛⵏ ⵎⵙⵏⵜ ⵜⵏⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ⵙ ⵏⴶⴰ ⴹⵏ ⴶⵜⵏⵏ ⴹⵏ ⵙⴹⵓ ⵏⵀⵢ ⵢⵏ ⴶⵏ ⵙⵎ ⴶⵀⵙ ⴹⴼⵍⵏ ⴾⵍ ⵏⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ⵙⵏⴹⵓ ⴹⴾⵍ ⵙⵜⵀ ⵏⵀⵍⵙ ⴾⵔⴹ ⵙⵔⵙ ⴹⵔⵏ ⵓⵏⵜ ⵎⵏⵜ ⴹⴼⵙⵏⵜ ⵎⵔⵏ ⵏⴰ «ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ \"ⵍⵙ ⵓⴰ ⵍⵏ ⵙⵜⵀ ⵓⴰ ⵎⴾ ⵓⴰ ⴹⴰ ⵙ ⵜⵤⴾⵔⴹⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵢⵔⵙⵍⵎ ⴶⵏ⵿ⵜⵓ ⴹⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ⵙ ⵏⵙⵍⴰ ⵢⵓⵏ ⴹ ⵏⵜⵏ⵿ⵙⵢ ⵀⵍⵙ ⵏⴾⵏⵢ ⴹⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎⵏ ⴼⵍ ⴹ ⵓⵔ ⴶⵤⵢ ⴾⵓ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ⵎⵛⵏ ⵏⵏⴰ ⵀⵍⵙ «ⵎⴰ ⴼⵍ ⵜⵂⵍⵎ ⵜⵙⵎⵍⵛⵎ ⵓⵍⵏ⵰ ⵏⴾ ⵓⵔⴶⵗ ⴾⵔⴹ ⵗⵙ ⵙ ⵙⵎⵜⴶⴰ ⴾⵍⵔ ⵜⵎⵜⵏ⵿ⵜ ⴹⴰ ⵙⵎⵜⴶⵗⵙ ⴹⵗ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴼⵍ ⴹⵍⵍ ⵏⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ⵙ ⵏⵏⵢ ⵙ ⵓⵔ ⵜⴹⵤⵏⵙⵗⵍ ⴹⵗ ⵓⵙ ⵔⴰ ⴶⵏⵜ ⵏⵢⵢ ⵏⵏⴰ «ⴶⵜ ⵎⵍⵢ ⵜⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ⴹⴼⵔ ⴹⵏ ⵓⵏ ⴹⵏ ⴹ ⵏⵙⵎⵜⴶ ⵢ ⵜⴾⵍⵢ ⵏⴶⵍⴰ ⵏⴶⵤⵢ ⵙ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ⴹⵓⵏ ⴹⵔⵏⴰ ⵔⵜ ⴹⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ⵰ ⵓⵢⵏⵏⴰ ⵙⵂⵏ ⵏⵍⵙ ⴶⵏ ⵙⵎ ⵎⵏⵙⵏ ⵏⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵆⵀⵔⵙ ⵔⵓⵏ ⵎⵙ ⵏⵍⴾⵎ ⵏ⵿ⵗⵢⵙⴰ ⵏⵤⵀⵜ ⵗⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ⵙ ⴹⵏⴶⵤ ⵢⵔⵙⵍⵎ ⴶⵏⵏⴰ ⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵍⵏⵏ ⴹⵏ ⵎⵔⵈⵀⴰ ⴹⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ⵙ ⴼⵓ ⴹⵓ ⴹⵔⵏⴰ ⵀⵍⵙ ⵙⵂⵏ ⵏⵢⵆⵀ ⵗⵔ ⴹⵓⵏ ⵎⵗⵔⵏ ⵏⵍⴾⵏⵙⵜ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ⵙⵙⵍⵎ⵿ⵜⵏ ⵀⵍⵙ ⵜⵤⵔ ⵗⵔⴹⵙⵏ ⵙⵗⵍ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⴶⴰ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵛⵗⵍ ⵓⴰ ⵜⴶⵓ ⵀⵍⵙ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ⵙ ⵙⵍⵏ ⵢⵔⵜⵏ ⵓⵏ ⵏⴰ ⴹ ⵎⵍⵏ ⵎⵛⵏⴰ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵏⵏ ⵢ ⵀⵍⵙ «ⵎⴹⵔⵢⵏⵏⴰ ⵏⵢ ⴶⵎⵏ ⵙ ⴶⵎⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵙⵏ ⵤⵤⵓⵏ ⵓⵍⵏ ⴹⵗ ⴹⴼ ⵏⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ⵓⴹⵏ⵿ⵜⵏ⵿ⴹⵓ ⵤⴰ ⵙⵍⵏ ⵓⵤⵓⵤⵏⵏ ⴹⵗ ⵀⵜⵏⴾ ⵎⵙⵏⵏ ⵙ ⵙⵙⵗⵔⵢ ⵓⴰ ⵜⵜⴶⴰ ⵜⵓⵢⴹⵓ ⵙ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵛⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵎⵤⵢ ⴹⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵜⴶⵏⵗⵙⵏ ⴹ ⵎⵤⵢⵏ ⴹⵙⵎⵏ⵿ⴾⴹ ⵏⵀⵔⵔⵏⵙⵏ ⴹⵍⴾⵎ ⵢⵍⵗⴹⵜⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ⴹⵗ ⴹⵢ ⵎⴰ ⵤⴰ ⵏⴶⵓ⵰ ⴼⵍⵙ ⴶⵎⴹ ⵛⴾ ⵙ ⴹ ⵙⵍⵏ ⵙ ⵜⵙⵗⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ⴹⵍⵍ ⵓⴹⵢ ⴼⵍ ⵤⴰ ⵜⴶⴰ ⵓⴰ ⴹⴾⵤⵏⵏⵓ ⴹⴰ ⵂⵏⵏⵗ ⴾⵤ ⵎⴹⵏ ⴹⴾⵍⵏⵏ ⴹⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ⴹⵓ ⴹⵔⵙⵏ ⵙⴹⴶ ⵓⴰ ⴹⵗ ⵤⵤⴹⴶⵏ ⵢⵜⴹⵏ ⵜⵤⵤⴹⴶⴰ ⵎⵏⴾ ⴾⵢ ⴹⵔⵙⵏ ⵜⵔⵤⵎⵗ ⴼⵍⵙⵏ ⵔⵜ ⵓⴰ ⵜⵏⵂⵏ ⴼⵍ ⴹⵙⵏ⵿ⵜⵓⵍⵤⵏ ⵗⴼⵓⵏⵙⵏ⵰ ⴹⵢ ⴹ ⵤⵙⵏⵏ ⵢⵜⴹⵏ ⴾⵍ ⵙ ⵓⴰ ⵙⵔⴾ ⵜⵓⵏⵏ ⵓⵔ ⵜⵂⴰ ⴶⵏ ⴾⵍⵔ ⴾⵢ ⴹⴰ ⵜⵍⴾⵎⵗ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵗⵢⵙⴰ ⵏⴾⵜⵀⵙⵏ ⵛⵔⵓⵜ ⵂⵏⵜ ⵜⵏⴹⵏ ⵛⵏ ⵏⴶⴰ ⵎⵙⵏⵏ ⵙ ⴹ ⵓⵔ ⵜⵛⵏ ⵙⵏ ⵎⵙⵏⵏ ⵜⴾⵜⵢ ⵢⵙⵏⵎ ⵓⵍⴰ ⵛⵓⵏ ⵤⵏⵢ ⵓⵍⴰ ⵜⵛⵏ ⵙⵏ ⵏⵎⴹⵔ ⵜⵏ⵿ⵗⴰ ⵜⵔⵤⵎ ⵓⵍⴰ ⴶⵏ ⵤⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ⵜⵤⵔ ⴹⵓ ⵀⵍⵙ ⴹⵎⴹⵏ ⵓⵏ ⴾⵤⵏ⵰ ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵤⵤⴹⴶ ⵎⵏⵜ ⵏ⵿ⵜⴰ ⴹⵔⵙⵏ ⵎⵔⵏ ⴶⵤ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵎⵍ ⵢ ⵍⵎⵎⵏ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵏ⵿ⴹⵓ ⵜⵤⴹⴾⵏⵙⵏ ⵤⵍ ⵓⴰ ⴹⵗ ⵤⴰ ⵜⵜⵓⴾⴼⵓ ⵜⴾⵜⵢ ⴼⵍ ⴾ ⵢⵏ ⴹⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ⵙ ⵤⵎⴰ ⴹⵗⵙⵏ ⴾⵎⵍⵏ ⵙⴰ ⴹⵏ ⵜⵏ⵿ⴹⵓ ⵜⵤⴹⴾⵏⵙⵏ ⵏⵢⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵢⴹ ⵏⴾⵍ ⵏⵙⵢⴰ ⵀⵍⵙ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ⵜⵤⵔ ⵌⵏⵌⵔⵓⵢⵏ ⵜⵎⵜⵢ ⴶⵏ ⴹⵗⵙ ⵔⴾ ⵎⵏ ⵙ ⵀⵍⵙ ⵀⵤⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ⴶⵏⵏ ⵙⴼⵍⴰ «ⵢⴰ ⴾⵍⵙⵔⵢⵍ ⴶⵤⵜ⵰ ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵙ ⵓⴰ ⵜⴶⵏ ⴹⵗ ⵜⵍⵈⵜⵀⵜⵏ ⵛⵏ ⵜⴶⵓ ⵢⵢⵜⴹⵏ ⴾⵍ ⴹⵗ ⴹⴶ ⴾⵍ ⵔⴾ ⵓⵍⵏ ⴼⵍ ⵜⵎⵜⵢⵏⵏⴰ ⴹⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⴰ⵰ ⴶⵍⴰ ⵂⵔ ⵙ ⴶⴹⵓ ⴾⵍⵍⵢⵏⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵎⴹⵙ ⴹⴶ ⵤⴹⴶⵏ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ⴶⵏⵏ ⵓⵏ ⴼⵍⵙ ⴹⵜ ⵓⵏ ⵏⵢⵏ ⵜⵔⴼⵎⵙ ⵓⵏ ⴼⵤ ⴹⵗ ⵗⵔⵎ ⴹⵓ ⴹⵀⵍⵙ⵰ ⵜⵤⵔ ⵔⴹⵏ ⵙ ⵤⴶⵤⵜⵓ ⵀⵍⵙ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ⵏⵌⵔⵓⵢ ⵗⵔⵎ ⴾⵜⵏⵜ ⵤⵍⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⴹⵗ ⵜⵙⴹⴶ ⴾⵍ⵰ ⵀⵤⵏ ⵀⵍⵙ ⵍⵓⵢⵏ⵿ⵜⵓ ⴶⵎⴹⵏ ⴹⵔⵙ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵜⵤⵔ ⵜⵓⵂⵔⵏ ⵎⵓⵏⵜ ⴹⴼⵔⵙⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ⴶⵎⵢⵏ ⴹ ⴶⵏ ⵎⵏ ⵏⵀⵍⵙ ⵙ ⴹⵏⵓⴹⵏ ⵙⵍⵏ ⴾⵎⵏ⵿ⴹⴰ ⵏ⵿ⵙⵌⵜⵏ ⵏⵔⵎ ⵏⵙ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⴾⵜⵏⵜ ⵏⵌⵔⵓⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ⵗⵔⴹⵓ ⵙⵌⵜⵏ ⴹⴾⵀⵜⵏⵜⵏⵙⵏ ⴹⵗ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵤⵍⵏ ⵙⵔⵙⵏ⵰ ⵙ ⵜⴶⴰ ⵜⵎⵜⵢ ⴾⵎⵏ⵿ⴹⴰ ⴹⵙⵌⵜⵏ ⵜⵔⵤ ⴹⵗ ⵜⵓⵜ ⵏⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ⵜⵤⵔ ⴾⴹⵓ ⴾⵎⵏ⵿ⴹⴰ ⵀⵍⵙ ⵀⵤⵜⵓ ⵎⵔ ⵙⴹ ⵜⵓⴾⵔⴹ ⵙⵛⵏ ⵙⵙⵔⵏ ⵎⵔⵏ ⵙⵙ⵿ⵜⵏ ⴹⵓⴰ ⵎⵙ ⴹⵓⴰ ⵗⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ⵜⵙⵗⵔⵜ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⴶⵏⵏ ⵔⵜⵏ ⵎⵤⵔⵢⵏⵏ⵰ ⵏ⵿ⴹⵔ ⵢ ⴾⵎⵏ⵿ⴹⴰ ⴹ ⵙⵏ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⴹⵗ ⵜⴾⵜ ⵜⵏ ⵜⵤⵔ ⵎⵔ ⵙⴹ ⵎⵓⵢ ⵀⵍⵙ ⵙ ⵀⵔⴾⵢ ⵓⵏ ⵙⵌⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ⵙ ⵓⴹ ⵀⵍⵙ ⵛⵙⴼⵜⵏ ⵏⵂⵏ ⵓⵏ ⵀⵔⴾⵢ ⵓⴰ ⵙⵔⵙ ⵜⴶⴰ ⵜⵎⵜⵢ ⴹⵗ ⵓⵌⵏ ⴾⵏ⵿ⴹⵀⴰ ⵙ ⵜⴹⴾⵍⵏ ⵙⵌⵜⵏ ⵙⴼⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ⵜⵍⴾⵎⵙ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵙⵗⵔⵜ ⵜⴶⵏⵓ «ⵎⵜⵜ ⵎⵜⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ⵙ ⵤⵎⴰ ⴹⵔⵙ ⴶⵤⵏ ⵙⵌⵜⵏ ⵀⵔⴾⵢ ⵏⴰ ⵀⵍⵙ ⵢ ⴾⵎⵏ⵿ⴹⴰ «ⵓⴾ ⵍⵗ ⵜⵔⵢⵜ ⵏ⵿ⴹⴾⵏⵗ ⵔⵜ⵰» ⵏⵙ ⴾⵎⵏ⵿ⴹⴰ «ⴾ⵰ ⴾⵢ ⵜⵙⵏⴰ ⵜⵍⵢⵏⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ⴹⵗ ⴹⵢ ⵓⵔ ⵜⵎⵙⵗ ⵓ ⵎⵙⵔ ⵓⵙ ⴾⵍⴰ ⵙⴼⵍⴶ ⵢⵜⴹⵏ ⵜⵤⵔ ⴶⵤ ⵜⵏⵔⵢ ⵏ⵿ⵜⴰ ⴹⴾⵤ ⴶⵎ ⵏⵓⴹⵏ ⵏⵎⴶⵏ ⵏⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ⵏⵙ ⵀⵍⵙ «ⵏⴾ ⴶⵍⵢⵂⴹ ⵎⵙⵗ ⵂⵓⵏ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔⵙⴰ ⴹⵗ ⴾⵍ ⵏ⵿ⴾⵍⴾⵢⴰ ⵎⵙⵏ ⵗⵔⵎ ⴼⵍ ⵜⴶⴰ ⵎⵙⵏⵜ⵰ ⵏ⵿ⵙⵢⵆⵢ ⴹⵜⴾⴼⴰ ⵜⵔⴶⵜ ⵏⴹ ⵛⵓⵍⴰ ⵢ ⵜⵎⵜⵢ ⵜⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ⴾⴼⵙ⵿ⵜⵜ ⴾⵎⵏ⵿ⴹⴰ ⵀⴹⴹ ⵀⵍⵙ ⴼⵍ ⵜⵙⴼⵜⵏ ⵙⴹⴶⵏ ⵙⴼⵙⵏⵜ ⵢ ⵜⵎⵜⵢ ⴹ ⵜⵙⵙⵎ⵰ ⵜⴼⵙ⵿ⵜⴰ ⵜⵎⵜⵢ ⴾⵜⵏⵜ ⵜⵤⵔ ⵛⵓⵍⵙⵏ ⵀⵍⵙ ⴹⵗ ⵜⵍⵗⵀⵔⵜ ⵓⵍ ⵓⴹⵏⵙⵏ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ⵎⴹⵔⵢⵏⵏ ⴹⵀⵜⵏⵏ ⵙⵙⵎⵜ ⵎⵔⴹⴰ ⴾⵓⵏ⵿ⵙⵙⴶⵔⴰ ⵜⴹⵍⵎ⵿ⵜ ⵜⴰ ⵜⵓⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ⵙ ⴹⵙⵙⵍⵏ ⵛⵓⵍⵙⵏ ⴹⵗ ⵜⵍⵗⵀⵔⵜ ⵛⵜⵏ ⴹⵗ ⵙⵙⵎ ⵢⵙ⵰ ⵜⵤⵔ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ⵏⴾ ⴶⵍⵢⵂⴹ ⵎⵙⴰ ⵂⵓⵏ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔⵙⴰ ⵂⵏ ⴾⵍ ⵏ⵿ⴾⵍⴾⵢⴰ ⵎⵛⵏ ⵗⵔⵎ ⵓⴰ ⴹⵗ ⴹⵗ ⴹⵓⵍⴰ ⵗⵔⵗ ⴹⵓ ⴶⵎⵍⵢⵍ⵰ ⵙⵙⵗⵔⵢ ⵙⵍⵗ ⵍⴾⵎ ⵢⵍⵆⵏⵏ ⵏⵍⵌⴹⵏⵏⴰ⵰ ⴶⵗ ⴶⵍⵢⵜ ⴹⵗ ⵍⴾⵎ ⵢ ⵎⵛⵏⴰ ⵛⵍⵜ ⵏ⵿ⵜⴰ ⵜⴶⵎ ⵤⵍⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ⵤⵗⵤⵀⵗ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⴰ ⴹⴰ ⵏ⵿ⵗⵢⵙⴰ ⵂⵔ ⴶⵎⴹⵏ ⵎⵏ ⵓⵢⴹ ⴾⵔⴹⴰ ⵎⴹⵏ ⴹⵜⴹⴹⵏ ⴶⵔⵆⵏ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵙⴶⵓⵔ ⵓⵏ ⵗⵎⵔⵏ ⴶⵢⵏ ⴼⵍ ⴹⵢ⵰ ⵏ⵿ⵜⵏⵢ ⴼⴹⴰ ⴹⴾⴼⵏⵏ ⵛⵔⴰ ⴾⵏⵏ ⵎⴹⵔⵢⵏⵏⴰ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵎⵙ ⴼⵍ ⴹ ⴶⵔⵓⴰ ⵙ ⴹⵏⵙⵗ ⵜⵔⵢⵜ ⵏⵀⵤ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴾⵍ ⵓⵏ ⵜⵂⵏⵏ ⵓⵢⵆⵏ⵿ⴹⵓ ⵙ ⵢⵔⵙⵍⵎ ⴾⵔⴹⵏ ⴼⵍ ⴹ ⵓⴹⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ⵛⴾⵍⴰ ⵤⴰ ⴹⵗ ⵓⵏ ⴹⴰ ⵙ ⴹⵏⵂⵤⵗ ⵗⵔⵎ ⵏ⵿ⴹⵎⵙ ⵜⵢⵏ ⵏⵎⵙ ⵏⵤⵍ ⵓⵍⴰ ⵂⴶⵏ ⵀⵍⵤⵜ ⵏⵔ ⵍⵀⵙⵏ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⴹⵗ ⵗⵍⵢⵗⵍⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ⴹⵗ ⵙⵍⵗ ⵢⵎⵙⵍⵢ ⵢⵏ ⵙ ⴹⵏⴰ \"ⵜⵍⵜ ⵜⵍⵜ ⵎⴰ ⴼⵍ ⵙ ⴹⵜⵤⵗⵤⵀⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ⵏⵗ \"ⵎⵍⵢ ⵎⴰ ⵜⵎⵙⵗ⵰\" ⵏⵢ \"ⵏⴾ ⵓⴰ ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ ⵓⴰ ⵜⵤⵗⵤⵀⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ⵏⵢⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵔ ⴹⵓⵗ ⵏⵔ ⵓⵏ ⵎⵛⵏ ⵓⵔ ⵙⵍⵏ ⵢⵎⵙⵍⵢ ⵓⴰ ⴹⵛⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ⵜⵤⵔ ⵏⵗ \"ⵎⵍⵢ ⵎⵙ ⴹⵓⵔ ⴶⵏⵜ⵰\" ⵏⵢ ⵎⵍⵢ \"ⵀⴹⴹ ⵜⴾⵗ ⵗⵔⵎ ⵏ⵿ⴹⵎⵙ ⴹⴾⴹⵗⵙⵜⵎⵍ ⵔⵜ ⴾⵍ ⵓⵙ ⴾⵢ ⵓⵔ ⴶⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ⴹⵔⵗⵍⴰ ⴼⵍ ⵜⵍⵀⵙ⵿ⵜ ⵏⵏⵔ ⵏ ⵜⵤⵔ ⵀⵤⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵔ ⴹⵓⴰ ⴼⵙⵏ ⵍⵓⵢⵏⵢ ⵙ ⴹⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ⵎⵔⵏ ⴹⵎⵙ ⵂⵜ ⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵏⵏⵢⵙ ⴾⵙⴹⵏ ⵎⵛⵏⴰ ⵓⵍⵏ ⵍⴾⵎ ⵢⵍⵆⵏⵏⵏⴰ ⵙ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⵓⵏ ⴹⵎⵙ ⵙⵗⵎⵔⵏ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ⵙⴹⵓ ⵀⴹⴹ ⴹⴶⵎⵏⵏ ⵏⵢ \"ⵎⴹⵔⵢⵏⵏ ⵜⵍⵜ ⵆⵍⵜⴾⵢⴹⵓ ⵙⵓⴹⵏⴾ⵰\" ⵆⵍⴹⵓ ⵙⵓⴹⵏ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ ⵏⵢⵆⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ⵏⵢ ⴹⵗ \"ⵎⵛⵏⴰ ⵓⴰ ⵗⵀⴹⵏ ⵎⵔⵓⵏⵏⴰ ⴾⵢⵙⵏⴼⵔⵏⵏ ⵂⵔⵓⴰ ⴹⵜ ⵍⵓⵆ ⵢⴾⵢⵙⵙⵏ ⵜⵔⵏⵜ ⵜⵏⵢⵗ ⵍⵗⴹⵍⵏⵜ ⵜⵙⵍⴰ ⴹⵗ ⵢⵎⵙⵍⵢ ⵓⵏⵜ ⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ⴹ ⴹ ⵜⵆⵍⴰ ⵜⴶⵢⵏⵜ ⴹⵜ ⵢⵜⴹⵏ ⴾⵍ ⵜⵎⵍⵗⵙⵏ ⵓⴰ ⵜⵏⵢⵗ ⴹⵓⵙ ⵜⵙⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ⵎⵔⴹⴰ ⵎⵙ ⵜⵆⵍⴰ⵰ ⵀⴹⴹ ⵜⵜⵓⵙⵍⵎⵗⴰ ⴹⵗ ⵎⵏ ⵜⵏ⵿ⵙⵢⵗ ⵎⵍⵢ ⴾⵢⵤⵤⴹⴶ ⴹⵗ ⵀⴾⴹⵏⴾ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ⴹⴼⵔ ⵓⵏ ⵆⵍⴰ ⵢⵔⵙⵍⵎ⵰ ⵜⵜⵔⴰ ⵤⵍ ⵢⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⴹⵜⵀⵤ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ⵏⵢⵗ ⵎⵍⵢ ⵏⵢ \"ⵜⵔⵀ ⵜⴶⵎⴹⴰ ⵢⵔⵙⵍⵎ ⵜⵔⵎⴹ ⴼⵍⵙ ⵓⵔ ⵤⵆⵀⵍⵏ ⵢⵜⴹⵏⵜ ⵜⴶⵢⴰ ⵜⴰ ⴼⵍⵢ ⵜⵜⴶⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ⵜⵤⵔ ⵏⵗⵙ \"ⵢⴰ ⵎⵍⵢ ⵓⵔⴶⵗ ⵏ⵿ⵜⵏⵢ ⵎⵏⵙⵏ ⵙⵏⵏ ⴹⵗ ⵎⴾ ⵓⵙ ⴾⵍⴰ ⴹ ⵜⵍⵍⴰ ⵏⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵢⵏ ⵢⵏ ⵙⵗⴼⵍⵗ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⴾ ⵤⴶⵤⵏⵏ ⴶⵜⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ⵙ ⵜⵓⵏ⵿ⵗⵍ ⴹⵗ ⵤⵏⵢ ⵏⵙ⵿ⵜⴼⵏⵙ ⵎⵙⵏ ⵜⴶⵢⵏⴾ ⵏⴾ ⵎⵏⵏ ⵍⵗ ⴹⵏ ⵔⴹⵗ ⵙⵜⵓⵏ⵿ⵗⵏⵜ ⵏⴾ ⴶⵤⵏ ⵀⵔⵏⵤ ⵏⵢⵜⴹⵏ ⵓⵏ ⴶⵏⵏ ⵎⵏⵜ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ⵎⵔⵏ ⵏⵢ \"ⴶⵍⵓ ⵏⴾ ⴾⵢⵤⵤⵎⵤⵍⵏ ⵙⴶⴶ ⵙⴾⵆⵢ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ⵙⵙⵎⵏⵙ ⵢⵜⴹⵏ ⵂⵔ ⴹⴹⴾⵍ ⵀⵜⵓ ⵏⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵜⵤⵔ ⵙⵗⵔⵏ ⴹⵗ ⵌⵏⵓⵏ ⴶⵏⵏ «ⵜⵓⴾⵙⵜ ⵓⴹⵏ ⵓⴰ ⴼⵍ ⵎⴹⵍ⵰ ⵓⴹⵏ ⵛⵍⵜ ⵏⵓⴰ ⵓⵔ ⵎⴾ ⴹ ⵍⵙ ⵜⵎⴹⵔ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ⵜⴾⵙⵏ ⵎⵙⵍⵏ ⵙⴾⵙⴹⵏⵏ ⴶⵔⵏⵏ ⵀⵔⵏⵤⵏⵙⵏ ⴶⵔⵏ ⵀⵆⴰ ⴹⵗ ⵍⵂⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ⵎⵔ ⴾⵎⵏ⵿ⴹⴰ ⵙⴹ ⵜⵓⵤⴶⵤ ⵀⵍⵙ ⵎⵙ ⵏⵀⵔⴾⵢ ⵜⵓⴶⵏⵜⵙ ⵜⵓⵜ ⵙⵍⴾⴹ ⴼⵍ ⴹⵙⵏⵎⵍ ⴹⵍⵍ ⵓⴰ ⴼⵍⵙ ⵜⵙⵗⵔⵜ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ⵎⵛⵏ ⵙ ⵜⴾⵔⴹⵏ ⵢⴹⵙⴶⵏ ⵛⵓⵜ ⵏⴰ ⵢ ⴾⵀⵜⵏ ⵓⴰ ⵍⵏ ⴹⵏ «ⵓⴾ ⵜⵍⵎ ⵜⵔⵢⵜ ⵏ⵿ⵜⵓⵜ ⵏⵢⵏ ⴹⵗ ⴾⵍⵔⵎ ⵓⵔ ⵀⵤ ⵛⵔⵗⴰ ⵂⵔⵓⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ⵙ ⵙⵍⴰ ⴾⵀⵜⵏⵏ ⵢⵓⵏ ⴶⵍⴰ ⵎⵍ ⵢ ⴾⵎⵏ⵿ⴹⴰ ⵏⵙ «ⵎⴰ ⵜⵜⴶⴰ ⴹⴰ⵰ ⵍⵙ ⴰ ⵏ ⵔⵎ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ⴾⴹⵓ ⴾⵎⵏ⵿ⴹⴰ ⵀⵍⵙ ⵏⵙ «ⵜⴹⵜ ⵙ ⴾⵢ ⵏ ⵔⵎ⵰» ⵏⵙ ⵀⵍⵙ «ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ⵜⵤⵔ ⵏⴰ ⴾⵎⵏ⵿ⴹⴰ «ⵏⴾ ⵤⵔⴼ ⴶⵏ ⵤⵏ⵿ⵤⴰ ⵜⵛⵜ ⵏⵢⵏ ⴹⵗ ⴾⵍⵔⵎ⵰» ⵏⵙ ⵀⵍⵙ «ⵏⴾ ⵍⵙⵍⵏ ⵜⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ⵜⵔⵎⴹ ⵙ ⴼⵍⵙ ⵤⵏ⵿ⴾⵤⵏ ⵙⵌⵜⵏ ⵓⵏ ⵙ ⵤⵎⴰ ⵜⴶⵤⵏ ⵛⵏ ⵜⵏⵗⵢ ⵢⵜⵛⵛⵓⵍⵏ⵰ ⴾⵎⵏ⵿ⴹⴰ ⵎⵏⵜ ⵙ ⵙⵏ ⵙ ⵢⵏ ⴹⵗ ⴾⵍⵔⵎ ⵙⵙⴾⵔⴹ ⴹⵏ ⵙ ⵙⵙⵔⵏ ⵜⴶⵤⵜⵓ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵎⵔ ⴾⵎⵏ⵿ⴹⴰ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴾⵜⵏⵜ ⵙⴹ ⵎⵏⵢ ⴼⵍⵙ ⵔⴰ ⴹ ⴾⵙ ⵛⴾ ⴹⵗ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵙⵜⵔⵎⵙⵏ ⴾⵍⵍⵢⵂⴹ ⵀⵍⵙ⵰ ⵜⵤⵔ ⵙⴾⵙⴹⵓ ⵀⵍⵙ ⵙⵀⴹⴹⵜⵓ ⴹⵜⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ⴹⴶ ⵀⵍⵙ ⵙⴶⵓⵔ ⵙⵙⵓⴹⵏⵜ ⵏⴰ «ⵎⴹⵔⵢⵏⵏ ⵓⵔ ⴹⵜⵂⴰ ⵜⵔⴾ ⵓⵍⵢⵜ ⵏⵙ ⵍⵢ ⵔⵜ ⵆⵍ ⵓⵔ ⵔⴰ ⵎⵛⵏⴰ ⵙ ⴾⵍⴰ ⴹ ⵜⵎⵤⵍⴰ ⵂⵔ ⵓⵙ ⵀⴹⴹⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ⵎⵛⵏ ⵎⵔ ⵏⵏⵢⵙ ⵓⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵢⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⴶⵎⴰ ⵏⵀⵍⵙ ⵙⴹⵙⵏ⵿ⴼⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ⵜⵤⵔ ⵏⵙ ⵀⵍⵙ «ⵎⵛⵏⴰ ⴹⴾⵤⵏ⵿ⴼⵤⵏ ⵍⵎⵏⴼⵆ⵰ ⵓⵔ ⵜⵆⵎⵗ ⴹⵢ ⵔ ⵢⴹⵜⵛⵔⵗⴰ ⵙⵓⴰ ⵏⴰ ⵛⵔⵗⴰ ⴾⵢ ⵜⵎⵤⵔⵢⵆⵓ ⴹ ⵜⵙⵓⵜⵗ ⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ⵏⵏⵙ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⴶⵎⵏⵜ «ⴾⵢ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⵏⵎⵛⵏⴰ ⵜⵔⵀⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ⵏⵙⵏ ⵀⵍⵙ «ⵓⵔ ⵙⵏⵗ ⵎⴹⵔⵢⵏⵏ ⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ⵰ ⵜⴹⵜ ⴹⵗ ⵙ ⴾⵜⵀ ⵙ \"ⴹ ⵓⵔ ⵜⵏⵗ ⵍⵀⵙⵏ ⵙⵎⵏⴾⵍ ⵏ⵿ⵜⵎⵜⵢⵏⴾ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ⵙⵏ ⵀⵍⵙ ⵙ ⵜⵤⵏ⵿ⵜ ⵏⵙⴶⵓⵔⵏ ⵢⵜ ⵙⴹⵙⵢⵜⵏ ⴹⵗ ⵜⴶⴰ ⵜⴰ ⵂⴹⵜ ⴼⵔⵙⵢⵜⵏ⵰ ⴹⵢ ⴼⵍ ⴹⴾⵍ ⵎⵙⵍⵏⵜ ⵓⵍⵏ ⴹⵜ ⵙⴶⵓⵔ ⵏⴰ «ⵎⴹⵔⵢⵏⵏ ⵏⴾ ⴼⵔⵙⵢ ⵎⵙⴰ ⵔⵓⵏ ⵓⵢⴹ ⴼⵔⵙⵢⵜⵏ ⵓⵔ ⴹⵎⵓⵢⴰ ⵙⴹⴶ ⵏⵛⵔⵗⴰ ⵓⴰ ⵔ ⴼⵍⵙ ⴶⵗ ⵜⵎⴰ ⴹⵗ ⵙ ⵏⵎⵜⵏ ⵍⴾⵎ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ⵏⴰ ⵓⵏ ⵗⵙ ⵜⵏ⵿ⴾⵔ ⵜⵎⵤⵆ ⴶⵔ ⴼⵔⵙⵢⵜⵏ ⴹⵙⴹⵙⵢⵜⵏ ⵜⵤⵏ ⵜⴹⵓⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ⴼⵍⵙ ⵙⴹⵙⵢⵜⵏ ⵜⴼⵏ ⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⵍⴰ ⵍⵏ⵿ⵜⵓ ⵏ⵿ⴶⵍⵙⵏ ⵓⵍⴰ ⴾⵍⵙⴼ⵰ ⴼⵔⵙⵢⵜⵏ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢ ⵤⴶⵤⵏⵏ ⵙ ⵓⵏ ⴾⵍ ⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ⵜⴾⵙ ⵜⵎⵤⵆ ⵓⵍⵏ⵰ ⵏ⵿ⴾⵔ ⵔⵜ ⴹⵗ ⵎⵙⵏⵏ ⵓⵏ ⴼⵔⵙⵢⵜⵏ ⵀⵍⵏⵏ ⴼⵍ ⵓⵏ ⵓⵔⵏ ⴶⵏⴰ ⵏⵀⵍⵙ ⴹ ⴶⵏⵏ «ⵍⵙ ⵓⴰ ⵓⵔ ⴼⵍⵙ ⵏⵂⵏⵢ ⵍⵂⵏ ⵓⵍⵢⵏ⵰ ⵎⵌⵙ ⵜⴹⵜ ⴹⵗ ⵙ ⵛⵓⵍⵙ ⴶⵙⴼ ⵎⴹⵗ ⵏ⵿ⴶⵍⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ⵓⴰ ⵜⴶⴰ ⵜⵎⵤⵆⵏⵙⵏ ⴹⵗ ⵜⴾⵙⵢ ⵜⴶⵤ ⵜⵙⴰ ⴾⵎⵏ⵿ⴹⴰ ⵏⴹ ⴶⵏ ⵀⵍⵙ ⵜⵏ⵿ⴾⵜⵏ⵿ⴾⵜ⵰ ⴹⵢ ⴼⵍ ⵎⵔ ⵙⵌⵜⵏ ⵙⴹ ⵤⵀⵏ ⴼⵍ ⴹⵗⵙⵏ ⴹⵈⵜⵙⵏ ⵀⵍⵙ ⵓⵢⵏ⵿ⵜⵓ ⵙ ⵀⵔⴾⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ⵙ ⴶⴰ ⵂⴹ ⵏⴼⵍⵍ ⵎⵍⵢ ⵢ ⵀⵍⵙ ⵏⵙ «ⵀⵍⵙ ⴾⵢⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ⵰ ⵎⴾ ⵓⴰ ⴹⵗ ⵙ ⴼⵍⵢ ⵜⴶⵢⵗ ⴹⵗ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵎⴾ ⴹⵢ ⴹⴰ ⵙ ⴾⵢⵓⵔ ⴼⵍⵢ ⵜⴶⵢⵗ ⴹⵗ ⵓⵏ ⵔⵎ ⵏ⵿ⵜⴰ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ⵙ ⴼⵓ ⵏⵎⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵗⴼ ⵂⴹⵏ ⵙ ⵓⵔ ⵤⵜⵛⵏ ⵓⵍⴰ ⵛⵓⵏ ⴾⵜ ⵓⵔ ⴶⵏ ⵎⵏ ⵏⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵏⵏ ⴹⵏ ⴶⵔⵏ ⴾⵤⵜ ⵜⵎⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ⴾⵏ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵗⵔⵏ ⵏ⵿ⵜⵎⵜⵢ ⵏⵏⵙⵏ «ⵏⵂⴹ ⵙ ⵓⵔ ⵤⴶⵤ ⵔⵜ ⵎⵓⵏⵏⴰ ⴾⵜ ⵓⵔ ⵏⴶⴰ ⵎⵏ ⵏⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ⴹⵗ ⴹⵢ ⵎⵔⴹⴰ ⴾⵓⵏⵢ ⴹⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴶⵎⵢⵜ ⴹⵗ ⴾⵎⵏ⵿ⴹⴰ ⴹⵜⵓⵏ ⵙⵀⴹⴹ ⵀⵍⵙ ⵜⵙⴾⵏⵎ ⵙ ⵜⵔⵎ ⴹ ⵜⵛⴶⵔⵎ ⵜⵗⵔⵏⵜ ⵙⵍⵗ⵰ ⵎⵔⵏ ⵏⴾⵏⵢ ⵏⵙⵎⵜⴶ ⵢⴶⵢ ⵏⵎⵏⵜ ⵂⵔⵓⴰ ⴹⵓⵔⵓⴹ ⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ⵎⵛⵏ ⵙⵍⴰ ⵜⴶⵤⵢ ⵏⵀⵍⵙ ⵢ ⵜⴼ⵿ⵜⵓ ⵜⵏ ⴾⴰ ⵀⵔⴾⵢ ⵏ⵿ⵙⵌⵜⵏ ⴶⵤⵜⵓ ⵎⵍ ⵢ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ⵜⵤⵔ ⵗⵔⴹⵓ ⵀⵍⵙ ⵢⵏ ⴹⵗ ⴾⵀⵜⵏⵜⵏ ⵏⵙ «ⵍⵓⵢ ⵀⵢ ⴹⵢ ⵙ ⴾⵎⵏ⵿ⴹⴰ ⵍⴰ ⵙⵍⵏ ⴹⵙⵤⴶⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ⴹⵓ ⴹⵔⵙ ⴾⵀⵜⵏ ⵓⵢⵜⵓ ⵙ ⴾⵎⵏ⵿ⴹⴰ ⵏⵙ «ⵎⵙⴾⵙⵓ ⵓⴰ ⴶⵏ ⵀⵍⵙ ⴹⴹⵗⵔⵏ ⴶⵎⵢ ⴹⵗⵢ ⵙⵔⴾ ⴹⵍⵓⵢⴰ ⵀⵢ ⴰ ⵍⵏ ⵙⵍⵏ ⴹⴾⵤⵎⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ⵀⵤ ⴾⵎⵏ⵿ⴹⴰ ⴼⵙ ⵏⵀⵢ ⴶⵎⴹ ⴹⵔⵙ ⵢⵜⴹⵏ ⵙⵙ⵿ⵜⵏ⵿ⵜⵓ ⵏⵙ «ⵎⵙ ⵜⵔⵗ ⴹⵜⵜⵎⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ⵏⵙ ⵀⵢ «ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵗⴼ ⴼⵍ ⴹⵗⴾ ⴶⵎⵢⵏ ⵜⴼⵜ ⴹ ⵜⵙⵀⴹⴹⴰ ⵀⵍⵙ ⴹⵜ ⵙⴶⵓⵔⵏⵙⵏ ⵓⴰ ⵤⵓⵔⵏ ⵍⵎⵜ ⵔⵏ ⴹ ⵛⴶⵔⵏ ⵜⵗⵔⵏⵜ ⵙⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ⴹⵙⵏⵓⵔ⵿ⵜⵔⴹⴰ ⴼⵍⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⴶⵔⵏⵏ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏⵍⵙ ⴹⵙⵤⵀⴾⵎⵜⵏⵏ ⵢⴹ ⴶⵏ ⵎⵏⵜ⵰ ⵂⴹⵏ ⵙ ⵓⵔ ⵤⵜⵛⵏ ⵤⴰ ⵓⵔ ⵤⵛⵓⵏ ⴾⵜ ⵓⵔ ⴶⵏ ⴹⵢ⵰ ⵙⵎⵜⴶⵏ ⵎⵔⴹⴰ ⵓⵔ ⵆⵍⵏ ⵔ ⵢⵜⴹⵜⵢⴰ ⵙⵔⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ⵔⵗⵎ ⴾⵎⵏ⵿ⴹⴰ ⵢⵀⵢ ⵓⵏ ⴼⵍ ⵎⵍ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵙⵍⵏ ⵓⵏ ⴹⵙⴶⴰ ⴹⵏ ⵎⵔⵏ ⵙⴶⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ⴹⴼⵔ ⵓⵏ ⵗⵔⴹⵓ ⴾⵎⵏ⵿ⴹⴰ ⵛⵏ ⴾⵀⵜⵏⵜⵏ ⵏⵙⵏ «ⵙⵎⵜⴶⵜ ⵙⵏⵜⵜ ⵜⵎⴹ ⵏ⵿ⵙⵌⵢ ⴹⵙⵢⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵙⵌⵢ ⴹⵗ ⵓⵏ ⴶⵏⵏ ⴶⵙⵏ ⴹⵙⵏⵜⵜ ⵜⵎⴹ ⴹⵗ ⵓⵏ ⵜⴼⵏⵏ ⵍⵗⵏ⵰ ⵢⴹ ⴾⵏ ⵆⵢⵙⵔⵢⴰ ⴹⴼⵔ ⵜⵙⴹⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ⵜⵙⵎⵜⴶⵎ ⴹⵗ ⵛⵙⵏⵢ ⵛⵏ ⵤⵓⵏ ⵀⵍⵙ ⵜⵛⵛⵓⴹⵎ⵿ⵜⵏ ⴼⵍⴾⵙ ⵓⵏ ⵏⵈⴾⵎ ⴹⵗ ⵍⵈⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ⵎⵔⵏ ⴾⵜⵀⵙⵏ ⴾⵎⵏ⵿ⴹⴰ ⵛⵔⵓⵜ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ⵓⴰ ⵏⴾ ⴾⵍⵓⴹⵢⵙ ⵍⵙⵢⵙ ⴹⵏⵂⵍⵏ ⵏⵈⴾⵎ ⴼⵍⴾⵙ ⴾⵏⵗ ⵙⵗⵎⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ⵍⵙ ⴹⵢ ⵀⵤⵏ ⴾⵍⵍⵢⵂⴹ ⵙ ⵤⵎⴰ ⴶⵏ ⵎⵏⵜ ⵙ ⵜⵏⵏⵙⵗ ⴹⵓⵗ ⴹⵙⵌⵜⵏ⵰ ⵙ ⴹⴶⵤⵏ ⵙⵍⵏ ⵏⵙ ⵓⴹⵏ ⵏⵔⵎ ⵎⵙ ⴶⵆⵓ ⴹⵗ ⴹⴶ ⴹⵆⵏ ⵓⵔ ⴾⴰ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ⴹⴼⵔ ⵓⵏ ⵓⵢⵆⵓ ⵙⵙⴶⵓⵔⵏⵙⵏ ⵓⴰ ⵤⵓⵔⵏ ⴼⵍ ⴹ ⵙⵏⵗ ⵍⵂⵏ ⵓⴰ ⵜⵙⵓⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ⵏⵢⵗ ⵙ ⵔⵜ ⵆⵍⵏ ⵛⵔⵗⴰ ⵓⵏⵙⵏ ⵗⵙ ⴼⵍ ⵜⵗⵜⵙⵏ ⵓⵔⴶⵗ ⵔⵜ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ ⵓⵍⴰ ⴶⵤ ⵏ⵿ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ⵎⵛⵏ ⵙ ⵙⵍⵗ ⵙ ⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵗⴼ ⴼⵍ ⴹ ⴶⵏ ⵎⵏⵜ ⵙⴾⵗⴾⵏ ⴹⵢ ⴹⴰ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵏⵗⵙⵏ ⵙⵔⴾ ⵏⵓⵢⵏ ⴾⵢ ⵛⵗⵜⵙ ⵛⵏ ⵜⴶⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ⴶⵏ ⵙⵌⵜⵏ ⵓⵙ ⵜⵓⵎⵔⵏ⵰ ⴶⵍⵏ ⵂⴹ ⵓⵏ ⴹⴰ ⴹⵓⵏ ⴹⵀⵍⵙ ⵂⵔ ⵙⵏ ⵗⵔⵎ ⵏⵏ⵿ⵜⴼⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵆⵍⵏ⵿ⴹⵓ ⵙⵌⵜⵏ ⵓⵏ ⵌⵓⵏ⵿ⴾⵜⵏⵏ ⵀⵔⴾⵏⵙⵏ ⴶⵍⵏ ⵓⵏ ⵓⵏⵏ ⴶⵙⵏ ⴹⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ⵙ ⴹⵏⵙⵏ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⴶⵏ ⵛⵔⵓⵜ ⵜⵏⴹ ⴹⵗ ⴼⵙ ⵏⵏⵈⴾⵎ ⵙⵀⴹⴹⵏ ⴹⵜⵙ ⴹⵗ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ⵗⵔⵜ ⵎⵔⵏ ⵙⵙ⵿ⵜⵏ ⵀⵍⵙ ⴹⴾⵍ ⵓⴰ ⵜⵍⵏ⵰ ⵙ ⵙⵏ ⵙ ⴾⵍ ⵏ⵿ⴾⵍⴾⵢⴰ ⵜⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ⵏⵙ «ⵙ ⴹⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵢⵗⵜⵙⵏⵏ ⴾⵢⴹⵙⵙⵗⵔⴰ⵰» ⵜⵤⵔ ⵎⵔ ⵙⴹ ⵜⵓⵜⴼ ⵀⵍⵙ ⴹⵗ ⵂⵏ ⵏ⵿ⵜⵎⵏⴾⵍⴰ ⵓⵙ ⴾⵍⴰ ⵜⵙⴾⵔⵙ ⵎⵏⴾⵍ ⵂⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ⵙⵎⵙ ⴹⵏ ⴹⴼⵔ ⵓⵏ ⵙⴹⵓ ⵏⵏⵢⵙ ⵓⵏ ⵍⵎⵎ ⵓⴰ ⵤⵓⵔⵏ ⴹⵓⴹⵓ ⴹⵔⵜ ⴹⵗ ⵎⵗⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵍⵙ ⴹⵓⴾⵍⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵏ ⵙⵎ ⵜⵔ⵿ⵜⵍⵙ⵰ ⵗⵜⵙⵏ ⵀⵍⵙ ⵗⵔ ⵏⵈⴾⵎ ⵏⴾⵍ ⴼⵍⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ⵜⵤⵔ ⵜⵓⵗⵔⴹⵓ ⵀⵍⵙ ⵎⵔⵏ ⵙⵏ⵿ⵜⴰ ⵜⵔ⵿ⵜⵍⵙ ⴹⵗ ⵎⵍ ⵏⵔⵜⵏ ⵓⵏ ⵙ ⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵗⵛⴹⵜⵏ ⵏⴰ «ⵢⴰ ⵎⵤⵓⵔ ⴼⵍⴾⵙ ⴹⵍⵍⵏⴾ ⴹⴹⵍⵍ ⵏⵔⵜⵏ ⵓⵏ ⵜⴶⵗ ⴼⵍ ⴶⵔⵓ ⴾⵍ ⵓⴰ ⵍⵈⵔ ⴶⵏ ⵎⵔⵏ ⵜⴶⵗ ⵏⵤⵎ ⵍⵗⵏ ⵢ ⵜⵎⵜⵢⵏⵏⴰ ⴼⵍ ⵛⴹⵜ ⵏ⵿ⵜⵍⵏⴾ ⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ⵏⵜⴶⴹⵢⴾ ⵓⵍⵏ ⴹⵗ ⴹⴶ ⴾⵍ ⵔⵜⵏ ⵍⵗⵏⵏ ⴾⵍ ⵓⵏ ⵜⴶⵗ ⵢⴰ ⵎⵤⵓⵔ ⴼⵍⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ⵓⵔ ⵔⵗ ⴾⵢⵙⵍⵍⵗ ⵀⵜⵏⵏⴰ ⵛⵢ ⴶⵤⵍⵜ ⵎⵛⵏ ⴶⵎⵢⴰ ⴹⵗⴾ ⴼⵍ ⴹⵍⵍ ⵏⵍⵗⵏⴾ ⴹⵔ ⴾⵢⵏⵤⴹⵢ ⴹⵏⵜⵙⵙⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ⵏⵏⵢ ⵙ ⵍⵙ ⴰ ⵍⵎⵙⵀⵜ ⵎⵙ ⴶⵎⵢⵏ ⴹⵙⴼⵍⴶ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⴶ ⵂⵏ ⴹⵗ ⴹⵏⵜ ⵎⵙ ⴹⵗ ⵎⵤⵔ ⵏ⵿ⵜⴶⵢⵜ ⵏⵔⵜ ⵏⵢⵜⴹⵏ ⵙ ⵜⵓⵏⵓ ⵏⵤⵔⵜⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ⵓⵍⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴹⴰ ⴶⵎⵢ ⴹⵙⵎⴹⵙⵏⵜ⵰ ⵏⵀⵤⵜⵓ⵰ ⵏⵔⴰ ⴹⵙⵏⴶⵓ ⵛⵔⵗⴰ ⵓⵏⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ⵎⵛⵏ ⵙⵏⴹⵓ ⴾⵎⵏ⵿ⴹⴰ ⵍⵙⵢⵙ ⵀⵤⵜⵓ ⴹⵗⵏⴰ ⵙⵙⵂⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ⵎⵔ ⴹⵗ ⴹⵜⴾ ⵀⴹⴹⵏ ⵢⵜⴹⵏ ⵓⵏ ⵗⵜⵙⵏⵏ ⵀⵍⵙ⵰ ⴾⵢ ⵎⵏⴾ ⵙ ⵜⵜⵙⵙ⵿ⵜⵏⴰ ⴹ ⵜⵏⵢⴰ ⵜⴹⵜ ⵏ⵿ⵜⵗⵜⵙ ⴾⵍ ⵛⵏ ⴹⵙⵏⴶⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ⵜⵤⵔ ⵔⴹⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵀⵜⵓ ⵏ⵿ⵜⵔ⵿ⵜⵍⵙ ⵏⵏ ⵜⴹⵜ ⵜⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ⵙⴹⴶⵏ ⵏⵈⴾⵎ ⵢ ⵀⵍⵙ ⴹ ⵛⵓⵍ⵰ ⵏⴰ ⵀⵍⵙ «ⵙⴹⵓⵜⵢ ⴹⵜⴾ ⴶⴰ ⵀⵜⵓ ⵜⵙ ⴶⵎⵢⵗ ⴶⵤ ⵏⵎⵏⵏ ⴼⵍⵙ ⵙⵏⵗ ⵎⵏⴾⵍⵏ ⵙ ⵔⵓ ⵜⵎⵙⵗ ⵎⵛⵔⵗ ⵏ⵿ⵜⵎⵜⵢ ⵏⴾⵍ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ⴾⵢ ⵎⵏⴾ ⵜⴼⵔⴶⵗ ⴹ ⵜⵙⵏⵗ ⴾⴹ ⵜⴹⵜ ⵓⵍⴰ ⵀⵂⵓ ⵙ ⵍⵏ ⵎⵔⵓ ⴹⵏ ⴹⵛⵏ ⴹ ⴶⵤⵢⵗ ⵙ ⵢⵔⵙⵍⵎ ⵢⴹⵗⵙ ⵗⵀⴹⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ⵓⵔⵎⴹ ⴹⵏⵢⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵍⴰ ⴹⵗ ⵏⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵓⵍⴰ ⴹⵗ ⴹⵗ ⵗⵔⵎ ⵎⵛⵓⵍⴰ ⴹⵓⴹⵏ ⵓⵍⵢⵏ ⵤⴰ ⵓⵍⴰ ⵌⵏⵌⵔⵓⵢⵗ ⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⴼⵔⴶⵏ ⵙⵀⴹⴹ ⵏ⵿ⵜⵗⵜⵙ ⵛⵏ ⴹⴶⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ⵎⵛⵏ ⵢⴰ ⵔⴹⵗ ⵙⵔⵜ ⵢⵏ⵿ⴹⴰ ⵎⵔⵏ ⴹ ⵜⵏⴰ ⴹⵜⴾ ⵜⵎⵙⵏ ⵙ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵢ ⵏⵎⵔⵓⵏⵏⴰ ⵙ ⵍⴾⵎⴰ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⵜⵜⵏⴰ ⵜⵔⵢⵜ ⵜⵏ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵜⵙ ⴶⵏⵏ ⵏ⵿ⵜⵏⵢ ⵜⴶⵢⵜ⵰ ⵤⴶⵤⵏⵗ ⵙⵔⵜ ⴾⵍ ⵓⴰ ⴾⵜⵀⵏ ⴹⵗ ⵜⵓⵔⵜ ⴹⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ⴶⵗ ⵜⵎⴰ ⵓⴰ ⴹⵗ ⵎⵛⵏⴰ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴶⵏ⵿ⵜⵓ ⵜⵎⵙ ⵙ ⵜⵍⵢ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴶⵔ ⵤⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵏⵏ ⵓⵍⴰ ⵓⵏ ⵓⵔ ⵏⵗⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ⴹⵢ ⴼⵍⵙ ⴼⵓ ⴹⴰ ⴶⵎⵢⴰ ⵏⴾ ⴹⴰ ⵓⵍⵏ ⴹⵓⵔ⵿ⵜⴶⵤ ⵜⵔⴾ ⵏⵍⵀⵙⵏ ⴹⵜ ⵎⵛⵏⴰ ⵓⵍⴰ ⴹⵗ ⴹⵜ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ⵍⵏ ⵍⵏ ⴹ ⴶⵎⴹⵗ ⵢⵔⵙⵍⵎ ⵙ ⵎⵔⴹⴰ ⵆⵍⴹⵓ ⵢⴹⵓⵢⵗ ⵢ ⵜⵎⵜⵢⵏⵏ ⵛⵔⴶⵜⵏ ⴶⴰ ⴹⵗ ⵛⴾⵜⵓⵏ ⵛⵏ ⵤⵍⵤⵎ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","ⵓⴰ ⴹⴰ ⵂⵗ ⵙ ⴹⴹⵙⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵙⵢⴰ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵙⵏ⵿ⴹⵗ ⵔⵜ ⵓⴰ ⴹⵙⵓⵔ ⵛⵔⵗⴰ ⴹⵗ ⵙⵍⵏ ⵏⵤⵤⴹⴶⵏ⵰ ⵓⵔⵎⴹ ⵗⵔⵢ ⵜⵍⴰ ⵜⵎⵜⵢ ⵤⴰ ⵓⵍⴰ ⵙⵏ⵿ⴾⵔⴰ ⵌⵆⵗ ⵏⵢⵜⴹⵏ⵰ ⵏ⵿ⵜⵏⵢ ⵙ ⵂⵔ ⴹⵜⴾ ⵀⴹⴹⵏ ⵗⵜⵙⵏⵢ ⵗⵔⴾ ⴾⴹ ⵏ⵿ⵜⴰ ⵍⵏ ⴹⵍⵍ ⵓⵍⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ⵎⴹⵗ ⵎⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⴰ ⵍⵂⵏ ⵓⵙ ⵏⴰ ⵙⴶⵓⵔ ⵓⴰ ⵤⵓⵔⵏ ⴶⵆⵓ ⵍⵓⵆ ⵓⴰ ⴹⵜⵙ ⵀⴹⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ⵓⵔ ⵏⵎⵙ ⵙ ⵏⵗ ⴶⵔⵙⵏ ⵙⴼⵍⴰ \"ⵓⵔ ⴹⵙⵀⴹⴹ ⴹⵜⵓⵏ ⵤⵍⴹⴰ ⵢⴹⵜⵛⵔⵗⵎ ⵔ ⴼⵍ ⵙ ⵤⴶⵤⵏⵗ ⵙ ⵍⴾⵎ ⴹⵏ⵿ⴾⵔⵏ ⵏⵎⵜⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ⴼⵍⴾⵙ ⵂⵏ ⵙⵍⵏ ⵓⵍⵏ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙ ⵙⵍⴰ ⵢ ⵀⵜⵓ ⵜⵏ ⵤⵔⵤ ⵛⵔⵗⴰ ⵂⵔ ⵢⵏ ⵤⵍ ⵏⴰ «ⵙ ⴹⵙⴰ ⵍⵙⵢⵙ ⵓⵏ ⴾⵎⵏ⵿ⴹⴰ ⴹ ⵈⵜⵙⴰ ⵛⵔⵗⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ⵜⵤⵔ ⵎⵔ ⴼⵍⴾⵙ ⴾⵀⵜⵏ ⵙⴹ ⴶⵤ ⵀⵍⵙ ⵎⵛⵏ ⴹ ⵓⵔ ⵜⵓⴹⴶⵤ ⵓⵍⴰ ⵜⵓⴶⴹⵍ ⵢⵢⵜⴹⵏⵜ ⴹⵗⵙ ⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ⵔⵜ ⵏⴹⵏ ⴹⴼⵔ ⵓⵏ ⵙⴹⵓ ⴼⵍⴾⵙ ⴹⵓ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⴹⵔⵙⵍⴰ ⵜⵎⵙⵜ ⵓⵍⵜ ⵍⵢⵂⴹ⵰ ⵜⵤⵔ ⵙⵙⵗⵔⴹⵓ ⵀⵍⵙ ⵙⵙⵎ ⵢ ⵙⵍⵏ ⵓⵏ ⵜⴶⵓ ⴹⵗ ⵀⵜⵓ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ⵎⵛⵏ ⵙ ⴹⵓⴹ ⵀⵍⵙ ⵙⵍⵏ ⵓⵏ ⵆⵍⵏⵏ ⵜⵆⵜ ⴹⵏⴹⵢ ⴹⵗ ⵎⵏ ⴹⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵓⴰ ⴹⵤⵢⵏ ⵜⴶⵤ ⵜⵙⴰ ⴼⵍⴾⵙ ⵏⵙ «ⵎⵔⴹⴰ ⴶⵍⵓ ⵙ ⴶⵔⵓⴰ ⵜⵎⵤⵢⵜ ⵏ⵿ⴹⵔⴾ ⵎⵛⵓⵍⴰ ⴾⵢⴹⵍⵙⵗ ⵙⵙⵗⵔⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ⵜⴶⵓ ⴼⵍⴾⵙ ⵓⵏ ⴶⴰ ⵜⵎⴰ ⴹⵗ ⴹ ⵜⴾⴼⵓ ⵀⵍⵙ ⵤⵔⴼ ⴹⵢ ⴼⵍ ⵜⴹⵙⵙⵗⵔⵓ ⵜⴶⵓ ⴹⵔⵙ ⵜⴾⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ⵓⵏ ⴹⴰ ⴶⵏ ⵂⵔ ⴶⵏ ⵛⵏ ⵍⵏ⵰ ⴶⵎⴹ ⴼⵍⴾⵙ ⵜⵤⵔ⵿ⵜ ⴶⵤ ⵀⵔⴾⵢⵙ ⴼⵙ⵿ⵜⵙ ⴹⴶⵏⵜ⵰ ⵢⴹⵓ ⵀⵍⵙ ⴹⵗ ⴾⵙⵓ ⴼⵍ ⴹ ⴶⵓ ⵜⵏⴼⵙ⵿ⵜ ⵢ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ⵙ ⴶⴰ ⴼⵙ⵿ⵜⵙ ⴾⵔⴹ ⴹⵏ ⴹⴶⵤ ⵏ⵿ⵜⵤⵔ⵿ⵜ ⵏⵢⵂⴹⵢⴰ ⴶⵎⴹ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⴶⵤⵢ ⵙ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ⵙ ⴹⵏⵙⴰ ⵎⵏⵢⵏ ⴹⵔⵙ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵗⵜⵙⵏ ⵗⵔⵙ ⵀⵍⵙ⵰ ⵜⵜⵏ⵿ⵙⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ⴹⵙⵏⴶⵓ ⵜⵏⴼⵙ⵿ⵜ ⵏⴹ ⴹⵙⴾⵓ ⵀⵍⵙ ⵢⵔⵙⵍⵎ ⵢⴹⵗⵙ ⵛⵔⵗ⵰ ⴶⵏⵏ ⵓⵏ ⵏ⵿ⵜⵏⵢ ⴶⵏ ⵗⴼ ⴼⵍ ⴹⵙⵀⴾⵎⵏ ⴹⵗ ⵜⵔⵢⵜ ⴶⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ⵎⵛⵏ ⵏⵙⵏ ⴼⵙ⵿ⵜⵙ «ⵀⵍⵙ ⴾⵙⵓ ⵓⵏ ⵆⵢⵙⵔⵢⴰ ⴹⵗ ⵜⵓⵜⴼ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴹ ⵆⵍ ⵜⵔⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ⴹⵗ ⴹⵢ ⴹⵓⵏⵜ ⴹⵔⵢ ⵎⵤⵔⵏⵓⵏ ⵙ ⵆⵢⵙⵔⵢⴰ ⵗⵜⵙⵏⵜⵓ ⴹⵏ ⴹⴰ ⴾⴹ ⵍⵢ ⵗⵛⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ⴶⴰ ⴼⵙ⵿ⵜⵙ ⴹⵗ ⵢⵔⵙⵍⵎ ⴹⵏ ⵍⵏⵏ ⴶⵔ ⵜⵎ ⴹⵎⵔⵓ ⵎⵔⵏ ⵆⵍ ⵆⵢⵙⵔⵢⴰ⵰ ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵆⵎ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵛⵔⵗ ⵜⵤⵔ ⵎⵔ ⵙⴹⵜⵙ ⵜⵓⵙⵀⴹⴹ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ⵙ ⴹⵙⴰ ⵀⵍⵙ ⵗⵍⵢⵗⵍⵢⵏ⵿ⵜⵓ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⴶⵎⴹⵏⵏ ⵢⵔⵙⵍⵎ ⵜⵗⵜⵙⵏ ⵙⵓⵔⵏ⵿ⵜⵓ ⴶⵢ ⵏⵔⵜⵏ ⴶⵜⵏⵏ ⵍⵀⵙⵏⵏ ⵙ ⵓⵔ ⴼⵔⴶⵏ ⵙⵜⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ⵛⵓⵍ ⵀⵍⵙ ⵢⴹ ⴶⵤ ⵎⵏⵜ ⵏⴰ «ⵏⴾ ⵓⵔ ⴶⵗ ⵔⴾ ⵎⵤⵍ ⵓⵍⵢⵏ ⵎⵔⵏ ⵛⵔⵗⴰ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵤⴰ ⵓⵍⴰ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵓⵍⴰ ⴹⵗ ⴶⵆⵓ ⵢ ⵆⵢⵙⵔⴰ ⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ⴼⵙ⵿ⵜⵙ ⵔⵏ ⴶⵢ ⵏ⵿ⵜⵏⴼⵙ⵿ⵜ ⵢ ⴾⵍⵍⵢⵂⴹ ⵏⴰ ⵢ ⵀⵍⵙ «ⵓⴾ ⵜⵔⴹⵗ ⵙⴹ ⵜⴶⵤⵢⵗ ⵙ ⵢⵔⵙⵍⵎ ⴹⴾⴹⵗⵙⵛⵔⵗⴰ ⵔⵜⵏ ⵓⵏ ⴹⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ⵏⵙ ⵀⵍⵙ «ⴾⵍⴰ ⴾⵍⴰ⵰ ⴹⴶ ⵏⵛⵔⵗⴰ ⵓⴰ ⵏ ⵔⵎ⵰ ⴹⵗ ⴹⵢ ⴹⴰ ⴹⴰ ⴹ ⵤⴰ ⵜⵓⵛⵔⵗⴰ⵰ ⵓⵔ ⵗⵛⴹⵗ ⵔⵜ ⵓⵍⵢⵏ ⵢ ⴾⵍⵍⵢⵂⴹ ⴾⵢ ⵎⵏⴾ ⵜⵙⵏⵗ ⵓⵍⵏ ⴹⵗ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ⴾⴹ ⵛⵔⵗⴰ ⵎⵤⵔⵢⴰ ⵎⴹⵗ ⴶⵗ ⵔⵜ ⴹⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ ⵔⴹⵗ ⵙ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵎⵛⵏ ⴾⴹ ⵔⵜⵏ ⵓⵏ ⵙ ⵜⵓⵏⴰ ⵗⵛⴹⵆⵏ ⵀⵂⵓ ⵎⵙⵏ ⵓⴹⵢ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵍⵏ ⵜⵔⵢⵜ ⵏ⵿ⴹⴶⵓ ⴹⵗ ⴼⵙⵏⵙⵏ⵰ ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⴹⵢ ⴶⵏ ⵓⴹⵢ ⵎⵏⴾⵍ ⵆⵢⵙⵔⴰ ⵙ ⵔⵗ ⴹⵛⵔⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ⵎⵛⵓⵔ ⴼⵙ⵿ⵜⵙ ⴹⵎⵛⵓⵔⵏⵜ ⵎⵔⵏ ⵏⴰ ⵢ ⵀⵍⵙ «ⵎⵏⴾⵍ ⵆⵢⵙⵔⴰ ⵙ ⵜⵔⵗ ⴹⴾⵛⵔⵗ ⵜⵜⴾⴰ ⵤⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ⵔⵜ ⵏⴹⵏ ⴹⴼⵔ ⵓⵏ ⵙⴹⵓ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⵗⵔⵎ ⵏⵆⵢⵙⵔⵢⴰ ⴹⵓ ⴹⵜⵎⴹⵔⵢⵜⵏⵜ ⵜⴶⵜ ⵀⵔⵏⴾⵙ ⴼⵍ ⴹ ⵙⵙⵍⵎⵏ ⴼⵙ⵿ⵜⵙ ⴶⵏⵙ ⵍⴼⵢⵜ ⴹⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ⴹⵏ ⴶⵜⵏⵏ ⵓⵏ ⴶⵏ ⴹⵏ ⴹⴾⵍⴹⵓ ⴹⵗⵙⵏ ⴼⵙ⵿ⵜⵙ ⵢⵎⵏⴾⵍ ⴶⵔⴼⴰ ⵙⵍⵏ ⵏⵀⵍⵙ ⵏⵙ «ⵍⴰ ⵍⵙ ⴹⴰ ⴹⵢⴰ ⵏⵈⴾⵎ ⴼⵍⴾⵙ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ⵍⵓⵆ ⵓⴰ ⴹⴾⵗ ⵢⵔⵙⵍⵎ ⵗⵜⵙⵏ⵿ⵜⵓ ⵗⵔⵢ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⴹⵎⵗⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴶⵎⵢⵏ ⴹⵗⵢ ⵜⵤⵀⵤⴰ ⵙⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ⵎⵛⵏ ⵏⵗⵙⵏ ⵛⵔⵗⴰ ⵓⵏ ⴾⵍⵔⵎ ⵓⵔ ⵜⵀⵤ ⵓⴹⵏ ⵔ ⵙⴹ ⵛⵔⵗ⵰ ⴾⵏ⵿ⴹⵀⴰ ⵏⵀⴹⴹ ⵓⴹⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⵗⵜⵙⵏⵏ ⴶⵤ ⵎⵏⵜ ⴹⵗ ⵔⵜ ⵓⴰ ⵜⵓⵙⵓⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ⴹⵢ ⴼⵍ ⴹⵔⵢ ⴹⴹⵓⵏ ⵙ ⵆⵢⵙⵔⵢⴰ⵰ ⵙⴹⵓ ⵗⵙ ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵆⵎⴰ ⴹⵗ ⴹⴶ ⵓⵏ ⵛⵔⵗⴰ ⵎⵔⴰ ⵙⴹⵎⵓⵢ ⵍⵙ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ⵀⴹⴹⵏ ⵎⴹⵏ ⵓⵏ ⵜⵗⵜⵙⵏⵏ ⵎⵛⵏ ⵓⵔ ⵜⵙⵓⵔⵏ ⵔⴾ ⵎⵤⵍ ⵍⵀⵙⵏ ⵓⵍⵢⵏ ⴹⵗ ⵓⵏ ⵗⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ⵓⴰ ⵤⵗⵏⵏ ⵜⵎⵤⵆ ⵗⵙ ⵜⴶⵜ ⴹⵗ ⵀⵜⵓ ⵏⴹⵏⵙⵏ ⴹⵙⵍⵏ ⵏⵍⵙ ⵢⵏ ⴶⵏ ⵙⵎ ⵗⵢⵙⴰ ⵀⴰ ⵎⵛⵏ ⴶⵍⴰ ⵀⵍⵙ ⵎⵍ ⵙ ⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ⵏⴾ ⵎⵏⵏ ⵓⵔ ⵙⵏⵗ ⵎⴾ ⵓⵙ ⵤⵛⵔⵗⴰ ⵤⵏⴼ ⵏⵔⵜⵏ ⵓⵏ ⴹⵏ ⴹⵢ ⴼⵍ ⵙⵙ⵿ⵜⵏⵗ ⵀⵍⵙ ⴾⴹ ⵔⴹⴰ ⵙⴹ ⴾⵓ ⵢⵔⵙⵍⵎ ⵛⵔⵗ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ⵎⵛⵏ ⵙⴼ ⴹⵙⵛⵔⵗ ⵆⵢⵙⵔⴰ ⵙⵏ⵿ⵜⴰ ⵎⵏⴾⵍ ⵓⴰ ⴹⵏⴶ ⵎⵏⴾⵍⵏ⵰ ⴹⵢ ⴼⵍ ⵎⵔⴰ ⵙⴹ ⵜⵓⴶⵤ ⵂⵔ ⵜⵜⵓⵙⴾⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ⵎⵔⵏ ⵏⴰ ⴶⵔⴼⴰ ⵢ ⴼⵙ⵿ⵜⵙ «ⵏⴾ ⴹⴰ ⵔⵗ ⴹ ⵙⵍⴰ ⵢⵍⵙ ⵓⴹⵢ⵰» ⵏⵙ ⴼⵙ⵿ⵜⵙ «ⵜⴼⵜ ⴹⵙ⵿ⵜⵙⵍⵗ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⴶⴹⵓ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⵙⴰ ⵓⵏ ⵎⵏⴾⵍⵏ ⵏ⵿ⵜⴰ ⴹⵜⵎⴹⵔⵢⵜⵏⵜ ⵀⵔⵏⴾⵙ⵰ ⴶⵤⵏ ⵂⵏ ⵓⵏ ⵛⵔⵗⴰ ⴹⵓⵏ ⴹⴾⵎⵏ⵿ⴹⵜⵏ ⵏ⵿ⵙⵌⵜⵏ ⴹⵎⵤⵓⵔⵏ ⵏⵗⵔⵎ⵰ ⵎⵔ ⴼⵙ⵿ⵜⵙ ⵙⴹⵎⵓⵢ ⵀⵍⵙ ⵜⵤⵔ ⵎⵓⵢⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ⵎⵔⵏ ⵏⴰ ⴼⵙ⵿ⵜⵙ «ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⴹⴾⵓⵏⵢ ⴾⵜⵏⵓⵏ ⵓⵏ ⵎⵏⵢⵏⵏ ⴹⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵙ ⵓⵙ ⴹⵍⵍⵏⵜ ⴼⵍ ⴹⴹⵙⵏ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⴹⵗ ⵢⵔⵙⵍⵎ ⵂⵔⴾⴹ ⴹⵗ ⴹⴰ ⴹⴰ ⴶⵏⵏ ⵙⴼⵍⴰ ⵓⵔ ⵎⴾⵏ ⴹ ⵍⵙ ⵜⵎⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ⵎⵔⵏ ⵏⴾ ⵤⴰ ⵓⵔ ⵏⵢⵗ ⵙ ⴶⴰ ⵎⵤⵍ ⵓⵍⵢⵏ ⵜⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ ⵎⵛⵏ ⴹⴹ ⵤⵎⵙ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴶⵎⵢⵏ ⴹⵙⵛⵔⵗ ⵎⵏⴾⵍ ⵓⴰ ⴹⵏⴶ ⵎⵏⴾⵍⵏ ⵓⴹⵢ ⴶ ⵜⵏⵜ ⵜⵎⵙⵜ ⴹⵙ⵿ⵜⵙⴾⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔ ⵙⵏⵗ ⴼⵍ ⵔⵜ ⵓⵍⵢⵏ ⴶⵎⴹ ⵛⴾ ⴹⵗ ⵜⵍⵗⵏⵜ ⴹⵏ⵿ⵤⴾⵜⵀⴰ ⵢⵎⵏⴾⵍ ⵓⴰ ⴹⵏⴶ ⵎⵏⴾⵍⵏ⵰ ⴹⵢ ⴼⵍ ⵜⵙⵀⴹⴹⴰ ⴹⵜⵓⵏ ⵓⵍⵏ ⴾⵢ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⴼⵍ ⵜⵏⵙⵙ⵿ⵜⵏ ⵙⵏⵗ ⵓⴰ ⵤⴾⵜⵀⴰ ⴹⵗ ⵜⵍⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ⴼⵍⵙ ⵓⵔ ⵙⵔⵢ ⵍⴰ ⵍⵎⵗⵏⴰ ⴹ ⵙⴾⴰ ⵆⵢⵙⵔⴰ ⵎⵙⴾⵙⵓ ⵙ ⴹⵏⵓⵔⵎⵍⵗ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵜⵓⵜⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ⵏⴰ ⴶⵔⴼⴰ ⵢ ⵀⵍⵙ «ⵜⴶⵔⵓⴰ ⵜⵔⴶⵜ ⵏⵓⵍ ⵜⴶⵤⵗ ⵎⵏⴾ⵰» ⵜⵤⵔ ⵤⵍ ⵀⵍⵙ ⴼⵙⵏⵜ ⵢⴹⵙ⵿ⵜⵙⵙⵎ ⵜⵎⵜⵢ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ⵢⴰ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⵀⵍⵍ ⵤⵓⵔⵏ ⴹⵜⵎⵙ ⵜⵂⴾⵢ ⵜⴰ ⴹⵜⴶⵗ ⵤⵍⴹⴰ ⵜⵔⴶⵜ ⵏⴶⵤ ⵏⵎⵏⵏ ⴹⵗ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵙ ⵏⵏ ⴾⵍⵍⵢⵂⴹ ⵗⵛⴹⵆⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ⵓⵍⵏ ⵙ ⵂⵏ⵿ⴾⵢ ⵙⵍⵏ ⵓⵍⵏ ⵏⵍⵗⴹⵜⵏⵙⵏ ⴾⵍ ⴹⵔⵜⵏ ⴾⵍ ⵓⵏ ⴼⵍ ⵜⵎⵤⵗⵏ⵰ ⴹⵗ ⴹⵢ ⵏ⵿ⵙⵢⵆⵢ ⴹ ⵜⴶⴰ ⵜⵤⵢⴹⵔ⵿ⵜ ⵜⵙⵙⵎⵗⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⵤⴹⵢⵏⵢ ⵂⵔⵓⴰ ⵗⵔ ⵜⵎⴹⵔⵢⵜⵏ⵰ ⵙⵏⵏ ⴹⵗ ⵓⴰ ⴶⵗ ⴾⵍ ⴹⵗ ⵜⵎⵜⵢⵏⵏ ⵂⵔⴾⴹ ⴹⵗ ⴹⵗ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ⵔⵓ ⵙ ⴹⵤⴹⵢⵏ ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵔⴹⵏ ⴼⵔⴶⵏ ⴹⴾⴶⵢⵏ ⵙ ⵜⴶⵢⵜ ⵜⵏ ⴼⵔⵙⵢⵜⵏ ⵂⵗ ⵙⵏ⵿ⵜⴰ ⵜⴶⵔⵜ ⵤⵤⵓⵢ ⴹⵗ ⴹⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ⵎⵔⴹⴰ ⵏⴾ ⴹⴰ ⵀⴹⴹⵏ ⴹⴰ ⵛⵔⵗⴰ ⴼⵍⵙ ⴶⵗ ⵜⵎⴰ ⴹⵗ ⵔⴾⵓⵍ ⵓⴰ ⴶⴰ ⵎⵛⵏⴰ ⵢ ⵎⵔⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ⵜⵎⵏ ⴹⴰ ⴶⵏⵜ ⵜⵓⵛⵜⵏⵏⴰ ⵏ ⵎⵔⵓⵜ ⴹⵙⵏⵜⵜ ⵓⵢⴹⵓ ⵙⵔⵙⵏⵜ ⵓⵏ ⵍⵗⵀⴹⴰ ⵏⵎⵛⵏⴰ ⵙ ⴶⵍⵢⵜ ⵂⴹ ⵤⵍ ⵆⵍⵏⵜ ⵢⴹ ⵏ⵿ⴹⵓ⵰ ⵢⴰ ⵎⵏⴾⵍⵏ ⴶⵔⴼⴰ ⵜⵎⵏ ⴹⴰ ⵤⴰ ⴼⵍ ⴹⵗⵜⵙⵏ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ⵎⴰ ⴼⵍ ⵙ ⴹⵓⵏⵔⵏⴰ ⴾⵓⵏⵢ ⴾⵍⵍⵢⵂⴹ ⵤⴶⵤⵏ ⵙ ⵎⵛⵏⴰ ⵍⴾⵎ ⴹ ⴹⵙⵏ⵿ⴾⵔ ⵏⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ⵏⴾ ⵎⵏⵏ ⴾⵍⴰ ⵗⵔⵢ ⵍⴰ ⵙ ⵓⵔⵢ ⴶⵢ ⵏⵔⵜ ⴾⵍ ⵓⴰ ⴼⵔⴶⴰ ⴼⵍ ⴹⵏⵏ⵿ⵗⴰ ⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵏⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ⵔⵜ ⵓⵏ ⵎⵏⵜ ⴶⵗ ⴹⵗ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ⵰ ⴾⴼⵏⵢ ⴹⵗⵙ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵜⵔⴶⵜ ⵜⵤⵔ ⵀⵤⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵜⵏⵏ ⴶⵆⵏ ⴹⵗ ⴾⵙⵓ⵰ ⵓⵔⵗ ⴶⵏⴰ ⵏⵓⵏ ⵜⵏⵀⵤⵏⵏ ⵙⵛⵔⵗⴰ ⵓⵏ ⵜⵎⵜⵏ⵿ⵜ ⵜⵏ ⴾⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ⵢⵓⵏⵗ ⵍⵎ ⴶⵔ ⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵍⵗⵀⴹⴰ ⵜⵓⴹⵀⵆⵏ ⵛⵂⵛⵍⵆⵏ ⵀⴹⵔ ⵏ⵿ⵗⵢⵙⴰ⵰ ⵓⴰ ⴹⵙⵏⴶ ⴹⵗ ⴶⵤⵔ ⵍⴾⵎⵗⵙⵏ ⵙ ⵗⵔⵎⵏ ⵏ⵿ⴾⵍⵏ ⵓⵏ ⵜⵎⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ⵤⵍ ⵢⵏ ⵛⴾⵍⴰ ⴹⵗ ⵓⵏ ⴹⴰ ⴾⵗ ⴹⵎⵙ ⴶⵔⵓⴰ ⵜⵔⴶⵜ ⵗⵔ ⵎⵤⵔⵏ ⵏⵍⵎⵎⵏ ⵏⴶⵢ ⵏⵓⵏ ⵎⵙ ⵙ ⵏ⵿ⵜⵏⵢ ⴹⴶⵏⵏ ⴹⵗ ⵛⵗⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ⵢⴰ ⵎⵏⴾⵍⵏ ⵓⵢⵗ ⴹⵜⵔⵢⵜ ⵎⵙ ⵏⵤⵍ ⵓⵍⴰ ⵂⴶⵏ ⵏⵢⵗ ⵏⵔ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⴶⵔⵏ ⵓⵏ ⵜⴼⴾ ⵎⵍⵓⵍⵓ ⵙ ⵀⵍⵤⵜ ⴹⵗ ⵗⵍⵢⵗⵍⵢⵏⵏⴰ ⵏⴾ ⴹⵢⵜⴹⵏ ⵓⵏ ⴹⵔ ⴹⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ⵏⴹⴰ ⴾⵜⵏⵏⴰ ⵜⵤⵔ ⵙⵍⵗ ⵢ ⵓⴰ ⴹⵏⵏ ⴹⵗ ⵜⵍⵗⵀⵔⵜ \"ⵜⵍⵜ⵰ ⵜⵍⵜ⵰ ⵎⵙ ⴹⵜⵤⵗⵤⵀⴰ⵰ ⵜⴶⵢⵜⵏⴾ ⵙ ⵍⴾⵎ ⵢ ⵜⵔⵏⵏ ⵓⵔ ⵜⵏ⵿ⴼⴰ ⵓⵍⴰ⵰ ⵓⵔ ⵜⵤⵍⵢ ⴹ ⵜⵏ ⵢⵙ ⴹⴶ ⵎⵛⵙ ⵙ ⵗⵢⵎⵏ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ⵏⵗⵙ \"ⵎⵍⵢ ⵎⴰ ⵜⵎⵙⵗ⵰\" ⵜⵤⵔ ⵏⵢ ⵎⵍⵢ \"ⵏⴾ ⵓⴰ ⵗⵢⵙⴰ ⵓⴰ ⵜⵤⵗⵤⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ⵎⵛⵏ ⵏ⵿ⴾⵔ ⵜⵀⴹⴹⵗ ⴼⵍⵙ ⵏⴼⵍⵍⵗⴾ ⴼⵍ ⴾⵢⴶⵗ ⵎⵛⵗⵍⵏ ⴹⵜⴶⵢⵏⵏ ⵤⴰ ⵜⴶⵢⵜ ⵢⵢⵜⴹⵏ ⵏⵢ ⵓⴰ ⴹⵜⴶⵗ ⵜⴶⵢⵗⵙⵏ ⴹⵗ ⵓⴰ ⴾⵢⵤⵙⴾⵏⴰ ⴹⴼⵔ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ⴾⵢⴶⵤⴰ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⴹⵜⵎⵜⵓⵏ ⵛⵏ ⵜⵏⵓⵔⵏⵎⵙ ⵤⵎⵤⵍⵆⵢ ⵙⵔⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ⴼⵍ ⴹ ⵜⵔⴰ ⵛⵜⵓⵏⵙⵏ ⵜⴾⵙⵆⵏ⵿ⴹⵓ ⴹⵗ ⵛⵢⵢ ⵙⵏⵔ ⴶⵎⴹⵏ⵿ⴹⵓ ⵜⵔⵏⴰ ⵜⵏ ⵀⵍⵙ ⵍⴾⵎⵏ ⵢ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵙⵏ ⴶⵔⵓⵏ ⴹⵗ ⵜⴹⴶⵔ⵿ⵜ ⴹⵗ ⵎⵤⴹⴶⵏ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵙⵔⵢ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ⵢⴰ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⴹⵍⵍ ⵓⴹⵢ ⴼⵍ ⵓⵔ ⵎⵤⵔⵢⵗ ⵓⴰ ⴹⴹⵏⴼⵍⵍⵏ ⴶⵎⴹⵓ ⵌⵏⵓⵏ⵰ ⴶⵢ ⵏⵎⵛⵏⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ⴾⵍⵔ ⵤⵔⵗ ⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵎⵙ ⴹⵓⵏ ⵢⵔⵙⵍⵎ ⴹⵢⵜⴹⵏ ⵓⵏ ⵢⵂⴹⵢⴰ ⴾⵜⵏⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵜⴶⵗⵙⵏ ⵜⵍⵈⵜⵀⵜ ⴶⵏⵗⵙⵏ ⵓⵔ⵿ⵜⵏ ⴹ ⵜⵀⵏ ⵂⴹⵏ⵿ⴹⵓ ⵙ ⵎⵛⵏⴰ ⴶⵏ ⵎⵤⵍⵏ ⵙⴾⵏⵏⵏ ⵜⵜⵀⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ⴹⵍⵍ ⵏⵓⵏ ⴹⴰ ⴼⵍ ⴹⵀⵤⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⴶⵎⵢⵏ ⴹⵜⵏⵗⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ⵜⴹⵂⵍ⵿ⵜ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ ⴹⴹⵜⵛⵛⵓⴹⵜ ⵤⵍ ⵓⵏ ⵤⵍⴹⴰ ⵜⵀⴹⵢ ⵜⴰ ⴶ ⴹⴰ ⵜⴶⵗ ⵙⵍⵏⵜ ⵢⵢⵜⴹⵏ ⴶⵔ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵍⵎⵆⵎ ⵓⵍⴰ ⵓⵏ ⵜⵍⵏⵏ ⵓⵔ ⴹⵛⵜⵗ ⵓⵍⴰ ⴹⵗ ⵙⵍⵏ ⵏⵓⵙ ⵎⵍⵏ ⵏⵀⵜⵏ ⵙⴰ ⵂⴹⵏ ⴹⵏⵀⵢ ⵎⵙⴰ ⵙ ⴹⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ⵜⵎⵙⵏ ⵙ ⵍⵎⵙⵈ ⵍⴾⵎ ⴹ ⵏⵢ ⵍⵗⵤⵀ ⵀⵜⵓ ⵤⵔⴹⵓ ⴹⵗ ⵢ ⵏⵎⵜⵏ ⵜⵏⴾⵔⴰ ⵎⵍ ⵏⵔ ⵓⴰ ⵂⴾⵓ ⵎⵛⵏⴰ ⵎⵙⵏ ⵙⵍⵏ ⵏⵍⵗⵍⵙ ⵢ ⴾⵍⵍⵢⵂⴹ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ⵂⵔⵓⴹⴰ ⵛⵓⵍ ⵀⵍⵙ ⵛⵔⵗ ⴼⵍ ⵎⵏⵜ ⵙ ⴹⴾⵍ ⴼⵙ⵿ⵜⵙ ⵎⵙⵍⵏⵜ ⵏⴰ «ⴾⵢ ⵀⵍⵙ ⵎⵙⴾⵍ ⵜⴶⵗ ⴶⵜ ⵏ⵿ⵜⵗⵔⵢ ⵜⴰ ⵜⴶⵗ ⵙⵎⵙⴾⵍⴾⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ⵏⵙ ⵀⵍⵙ «ⵎⵤⵓⵔ ⴼⵙ⵿ⵜⵙ ⵏⴾ ⵓⵔ ⵎⵙⴾⵍⴰ⵰ ⴾⵍⵔ ⵓⴰ ⴶⵏⴰ ⴹⴰ ⵜⴹⵜ ⵎⵙ ⵜⴾⴼⵜ ⵙ ⵜⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ⵎⵔⵏ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⵂⵏ⵿ⵜⵓ ⵙⵍⵏ ⵓⵏ ⴹⵢ⵰ ⴹⵢ ⴼⵍ ⵓⵔ ⴾⵙⴹⵗ ⴶⵏⵙⵏ ⴹⵜⵙ ⴼⵍⵙ ⴾⵙⵗ ⵛⴾ ⵙ ⵓⵔ ⵜⵏⵂⴰ ⵓⵍⵢⵏ ⴹⵙⵌⵂⵍⵏ ⴹ ⵓⵔ ⵜⵓⴶⵏ ⴹⵗ ⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ⵎⵏⴾⵍⵏ ⴶⵔⴼⴰ ⵓⴾ ⵜⵤⴶⵤⵏⵗ ⵙⵓⴰ ⵏⵏ ⵏⵀⵜⵏ⵰ ⵙⵏⵗ ⵙ ⵜⵤⴶⵤⵏⵗ ⵙⵔⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ⵜⵤⵔ ⵏⴰ ⴶⵔⴼⴰ ⵢ ⵀⵍⵙ «ⵜⵔⴹⵏⴾ ⴹⵜⴶⴰ ⵍⵎⵙⵈⵢ ⴼⵍ ⵔⵜ ⵏⵎⵤⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ⵏⵙ ⵀⵍⵙ «ⴶⵔ ⵤⴰ ⴼⵍ ⵔⵜ ⵏⵎⵤⵢ ⵓⵍⴰ ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴾⵢ ⴹⵔⵢ ⵛⵛⵍⵏ ⴾⵢ ⵂⵔⴾⴹ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵙⵙⵎⵏⵏ ⴹⴰ ⵤⵍⴹⴰ ⵙ ⵓⵔ ⵂⵏ ⵙⵙⵔⵏ ⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ⵜⵤⵔ ⵏ⵿ⴾⵔ ⵎⵏⴾⵍ ⴶⵔⴼⴰ ⴹⴼⵙ⵿ⵜⵙ ⵓⵏ ⵏⵈⴾⵎ ⴹⵀⵔⵏⴾⵙ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵔ ⵏⵗⵎⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ⴶⵎⴹⵏ ⵜⵏⵎⵏⵏ ⴶⵔⵙⵏ «ⵍⵙ ⵓⵏ ⵓⵔ ⴶⴰ ⵔⵜ ⵓⵍⵢⵏ ⵙ ⵂⵔ ⴼⵍⵙ ⵎⵜ ⵓⵍⴰ ⴹⵗ ⴶⵤ ⴼⵍⵙ ⴾⵙⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ⵎⵔⵏ ⵏⴰ ⴶⵔⴼⴰ ⵢ ⴼⵙ⵿ⵜⵙ «ⵍⵙ ⵓⵏ ⵏⵔ ⵓⵔ ⴶⵎⵢ ⴹⵙⵛⵔⵗ ⵆⵢⵙⵔⴰ ⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⵜⵓⵢⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ⵙ ⵜⵓⵏⴰ ⴹ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵏⴾⵓ ⴾⵍ ⵏⵜⵍⵢⴰ ⵜⵓⴶⴰ ⵀⵍⵙ ⵏ⵿ⵜⴰ ⴹⵓⵢⴹ ⵎⵙⴾⵙⴰ ⴹⵗ ⴼⵙ ⵏ⵿ⴾⵀⵜⵏ ⵢⵏ ⴶⵏ ⵙⵎ ⵢⵍⵢⵙ ⵂⵏ ⴶⵏ ⵏ⵿ⵙⵌⵜⵏ ⵙ ⵜⵓⵏⵓ «ⵓⴰ ⵏⵆⵢⵙⵔ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ⵜⵤⵔ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⵏⵗⵔⵎ ⵏⴹⵔⵎⵜⵏⵙ ⴾⵏ ⴾⵍⵏ ⵏⵙⵢⴰ ⵓⵏ ⵓⵔⵏⵏ ⴼⵢ ⵏⴶⵔⵓ⵰ ⵂⵏⴰ ⵔⵙ⵿ⵜⵔⵈⵙ ⵎⵙⵏ ⵓⴹⵏ ⵏⵗⵔⵎ ⵏ⵿ⵜⵙⵍⵏⴾ ⵏⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⵏⵤⵀⵜ ⴹⵗ ⵗⵔⵎ ⵏ⵿ⵙⴹⵏ⵰ ⵢⵍⵢⵙ ⵎⵙⵏ ⵓⴹⵏ ⵙⴾⵏⵏ ⵀⵍⵙ ⵍⵗ ⴾⴼⵢ ⵜⵔⴶⵜ ⵏⴹ ⴾⵓ ⵎⴹⵓⵏⵜ ⵓⵏ ⵂⵏⵏ ⵗⵔⵎ ⵓⵏ ⴼⵍ ⴹⵗⵙ ⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ⵙ ⴹⵔⵏⵗ ⴶⵎⴹ ⵗⵍⵍ ⵏⵎⵏ ⵙⴹⵏ ⵏⵍⵍ ⵙⵍⵎ ⵏⴶⵔⵓ ⴹⵗ ⵏⵂⴰ ⴼⵢ ⵏⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⵆⵀⵔⵙ ⴼⵍⵙ ⴹⵓ ⴹⵔ ⵏⵎⵆⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ⴹⴼⵔ ⵓⵏ ⵏⵛⴾⵍ ⴼⵍ ⴶⵔⵓ ⵓⵙ ⵓⵔ ⴾⵍ ⵏ⵿ⴾⵍⴾⵢⴰ ⴹ ⵓⵏ ⵀⵏ⵿ⴼⵍⵢⴰ ⵜⵎⵏⵜ ⵏⵓⴹⵏ ⵗⵔⵎ ⵏⵎⵔⴰ ⵂⵏ ⴾⵍ ⵓⵏ ⵍⴾⵢⴰ ⵏⵤⵀⵜ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ⴶⵔⵓ ⴹⵗⵙ ⴾⵀⵜⵏ ⵓⴰ ⴹⵔ ⵏⴹⵓ ⵢⵏ ⵗⵍⵍ ⵏⵗⵔⵎ ⵏⵍⵙⴾⵏ⵿ⴹⵔⵢⴰ ⵜⴾⵏ ⴾⵍ ⵏⵜⵍⵢⴰ ⴶⵏⴰ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ⵏⴶⴰ ⴹⵏ ⴶⵜⵏⵏ ⵏⵙⵍⵍⵎ ⴼⵍ ⵎⵏ ⵙⵍⵏ ⴶⵔⴹ ⵙ ⴹⵏⵂⵤ ⵗⵔⵎ ⵏ⵿ⴾⵏⴹⵙ⵰ ⵜⴶⴹⵍⵏⴰ ⵙⵂⵜ ⵏⴹⵓ ⴹ ⵏⴶⵍⵓ ⴹⵗ ⵏⵎⴹ ⵓⵏ ⵜⵤⵔ ⵏⵏⵎⴹ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⴾⵔⵜ⵰ ⵙ ⵏⴾⵢ ⴼⵍ ⵙⵍⵎⵏ ⵏⵎⴹⵗ ⵢ ⴾⵔⵜ ⵏⴶⵤ ⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ⴶⵔⴹ ⵙ ⵏⵍⵍ ⵙⵍⵎ ⵏⴶⵔⵓ ⵂⵔ ⵏⵓⴹ ⴹⴶ ⴶⵏ ⵙⵎ «ⵤⵤⵀⴰ ⵓⵏ ⵂⵙⵢⵏⵏ ⵏⵗⵍⵍⵏ» ⵏⵎⵂⵤⵏ ⴹⵗⵔⵎ ⵏⵍⵙⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ⵙⵍⵍⵜⵏⴰ ⵛⴾⵍ ⵓⵏ ⵓⵍⵏ ⵛⴾⵍ ⴹⵗ ⵗⵍⵍ ⵏⵎⵏ ⴹⵗ ⵎⵔⴹⴰ ⴶⵤⵜⵓ ⵍⵗⵔⵔ ⴼⵍⵙ ⵓⵍⴰ ⵤⵎ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵗⵔⵜ ⴾⵢ⵰ ⴹⵢ ⴼⵍ ⴶⴰ ⵀⵍⵙ ⵢⵢⵜⴹⵏ ⵓⵏ ⵏⴹⵏⵏ ⴹⵗ ⵗⵍⵍ ⵏⵎⵏ ⵏⵙⵈⴰ ⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«ⵎⴹⵏ ⵂⵏⵢⵗ ⵙ ⵛⴾⵍⵏⵏⴰ ⴹ ⵜⴶⵤ ⵀⴰ ⵏ⵿ⵜⵗⵔⴰ ⴹⵗⵛⴹ ⵤⵓⵔⵏ⵰ ⵓⵔⴶⵗ ⵗⵍⵍ ⵏⵎⵏ ⵗⵙ ⴹⵍⵍⵏⵜ ⵤⵂⵍⴾⵏⵏ ⴾⵍⵔ ⵏⴾⵏⵢ ⴹⴰ ⴹ ⵏⴶⵤ ⵜⵤⴾ ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ⵎⵛⵏ ⵙⴼ ⴾⵀⵜⵏ ⴹⴼ ⵏⵀⵜⵓ ⵜⴰ ⴹⵙⵏⴶⴰ ⵍⵙ ⵓⴰ ⵓⵢⵏ ⵗⵍⵍ ⵏⵎⵏ ⴹⵓⴰ ⵜⵍⵏ ⴹⴼ ⵏⵏⵙⵈⴰ ⵓⴰ ⴹⵙⵏⴶⴰ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ⴹⴹ ⵎⵙ ⵙ ⵤⵤⵀⵓ ⵏⵗⵍⵍⵏ ⵏⵎⵏ ⵓⵏ ⵓⵔ ⴹⵗⵙ ⵍⵗ ⴾⵙ ⵏ⵿ⵜⴶⵔⵙ⵿ⵜ ⵜⵏ⵿ⴾⵔ ⵜⵛⵎ ⵏⵢⵜⴹⵏ ⵓⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⴶⵏ ⵜⵏⵜ ⴹ ⴶⵍⵏ ⴶⵎⵢⵏ ⴹⴶⴹ ⵏⵢⵏ ⵗⵔⵎ ⵎⵙⵏ ⵤⵤⵀⵓ ⵏⵗⵍⵍⵏ ⵏⵎⵏ ⴶⵏ ⵙⵎ ⴼⵏⴾⵙ ⵂⵏ ⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙ ⵜⵓⵏⵓ ⴾⵔⵜ ⴾⵙⵏ ⵜⴶⵔⵙ⵿ⵜ ⴹⵗ ⵗⵢⵏ⵿ⵗⵢⵏⵜ ⵙⵢⵏ ⵙⵓⴹ ⵙⴰ ⵙⵔ ⴶⵍⴰ ⴹⵗ ⵜⵔⵎ ⵓⴰ ⵂⴹⵏ ⵙⴰ ⵙⵔ ⵜⵎⵙⵏⴰ ⴹⵗ ⵜⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ⵍⵏ ⴹⵏ ⴹⴰ ⵙ ⴹⴶⵔ ⵔⵜ ⵏⴹⵓ ⵓⵏ ⴶⵍⴰ ⵜⵤⵔ ⴾⵙⵏ ⵢⵗⵍⵍ ⵏⴹⵢ ⴶⵍⵏ ⵙⵎⴹⵗⵏ ⵢⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵏ⵿ⴾⵔⵜ ⴹⵗ ⵂⵤⵏ ⵜⵛⵛⵓⵜⵏⵜ ⵗⵍⵏ ⴹ ⴼⵔⴶⵏ ⵎⵔⴹⴰ ⴶⵢ ⵏⵓⴰ ⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ⵎⵛⵏ ⵓⵔ ⵂⴶⵏ ⴹⵜⴾⵍⵢ ⵙ ⴼⵍⵙⵏ ⴹⵜⴶⵔ ⵜⵤⴼⴰ ⵜⵙⵂⵜ ⵙ ⵜⵓⵏⵓ ⵜⵏ ⵜⵎⵙⵏⴰ ⴹⵗ ⴹⵏⴶ ⵜⴶⵜ ⵙⵎ ⵢⵔⴾⵍⵏ ⴹⵙⵏ⵿ⴹⵜⴶⵜ ⴶⵤ ⵓⵏ ⴾⵍ ⵏ⵿ⴾⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ⵜⵤⵔ ⵀⵜ ⴹⵓ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⴹⵔⵏⴰ ⴹⴼⵏⵜ ⴶⵍⴰ ⴹⵔⵏⵗ ⵀⵜⵓ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ⵙ ⵏⴶⵤ ⴼⵢ ⵏⵔⵜ ⵏⴾⵍ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⴶⵏ ⵙⵎ ⴾⵓⴹⴰ ⵏⴶⴰ ⵢⵔⵜ ⵏ⵿ⵜⵗⵍⵍ⵿ⵜ ⵏⵎⵏ ⵍⵓⵢ ⵗⵍⵍ ⵓⴰ ⵏⵂⴰ ⵜⵎⵓⵜ ⵜⴰ ⵏⵔⴰ ⴶⵔⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ⴹⴾⵍⵏ⵿ⵜⵜⴹⵓ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⴶⵏ⵿ⵜⵜ ⴹⵗ ⵎⵙ ⵏⵗⵍⵍ ⵜⵤⵔ ⵙⵗⵍⵢⵏ⵿ⴹⵓ ⵗⵍⵍ ⵏⵎⵏ ⴾⵜⵏⵜ ⵗⵏⵏ ⵤⵓⵔⵏⵏ ⵜⵀⵏⵙ ⵙⵔⵙⵏ ⴼⵍ ⵜⵓⵔⵤⵎⵤⵢⵏ ⵎⵏ⵰ ⵙⵔⵙⵏ ⴼⵔ ⵓⴰ ⵙⴾⴼ ⴹⵓ ⵙⵍⵍⵎ ⴼⵍ ⵎⵏ ⴼⵍ ⴹ ⴶⵓ ⵙⵍⵏ ⴼⵍⵙ ⴾⵙⴹⵏ ⴹ ⵙ⵿ⵜⵀ ⵗⵍⵍ ⵢⵎⴹⵍ ⴹⵗ ⴹⴶ ⴶⵏ ⵙⵎ ⵙⵔ⵿ⵜⵙ ⴹⵗ ⴶⵤⵍ ⴶⵔⵓ ⴶⵍⴰ ⵗⵍⵍ ⵀⵜⵓ ⴹⵔⵏⵗ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ⵓⴰ ⵜⴶⴰ ⵜⵤⴼⵏ ⴹⵗ ⵙⵂⵜ ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⴹⵏⴶⵔⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⵍⵍⵏ ⴹⵗ ⴶⵔⵓ ⴼⵍ ⴹ ⴼⵙⵙ ⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ⵙ ⵤⵍ ⵓⵏ ⴾⵔⴹ ⴶⵔⵏⵏ ⴹⵗ ⵎⵏ ⵙ ⴼⵙⵏ ⵓⵏ⵿ⴹⵏⵙⵏ ⵙⵙⴾⵏⴰ ⵏⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ⵜⴼⴾ ⵓⵍⴰ ⵜⵔⵏ ⵏⴶⴰ ⴹⵏ ⴶⵜⵏⵏ ⵓⵔ ⵜⵏⵏⵢ⵰ ⵓⴰ ⵜⴶⴰ ⵜⵤⴼⵏ ⴹⵗ ⵙⵂⵜ ⵏⴾⵙ ⴼⴹⴰ ⵜⵎⴰ ⵏⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ⴹⵏⵏ ⵏⴶⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⵜⵛⵏ ⵔⵜ ⵜⵤⵔ ⵀⴹⴹ ⵀⵍⵙ ⴹⵗ ⵎⵙ ⵏⵢⵜⴹⵏ ⵏⴰ «ⵎⴹⵏ ⵏⵔ ⵜⵜⴼⵎ ⵏⵙⵈⴰ ⵓⴰ ⴹⵓⵏⴶⵗ ⵜⵆⵎⵎ ⴹⴰ ⵓⵔ ⴹⵜⴶⵎⴹⵎ ⴾⵍ ⵓⵏ ⴾⵔⵜ⵰ ⴹⵢ ⵓⵔ ⴾⵓⵏ⵿ⵤⴶⵔⵓ ⵀⴰ ⵏ⵿ⵜⵗⵔⴰ ⵓⴰ ⴹⵂⵍⴾ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ⵎⵔⵏ ⵎⵔⴹⴰ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹ ⵓⵔ ⵜⴾⵙⵎ ⵜⵎⴰ ⴼⵍⵙ ⵓⵔ ⴾⵓⵏⵂⴰ ⵢ ⵤⴶⵎⴹⵏ ⵎⵏⵜ ⵎⵛⵏ ⵢⴰ ⵗⵍⵍ ⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⵏⵗⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ⵏ⵿ⴹⴹ ⴹⵏⴼⵍⵍ ⵏ⵿ⴶⵍⵙ ⵏⵎⵛⵏⴰ ⵓⴰ ⴹⵍⵏ ⵂⵗ ⵛⵗⵍⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ⵏⵢ \"ⵀⵍⵙ ⴾⵢⵓⵔ⵿ⵜⴶⵤ ⵜⵙⴰ ⵆⵢⵙⵔⴰ ⵓⵏ ⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⴾⵏ⵿ⴹⵀⴰ ⵜⵀⴹⴹⴰ ⴹⵜⵙ ⵛⵔⵗⴾ⵰ ⵎⵔⵏ ⵏⵢ ⵎⵛⵏⴰ ⴶⴾ ⵔⵈⵎⵜ ⵜⵎⵙⵜ ⴶⵤ ⵏⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵔ ⵜⵏⵎⵂⴰ ⵗⵍⵍ ⵏⵎⵏ ⴹⴰ⵰\" ");
INSERT INTO ttqt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ⴹⵗ ⴹⵢ ⵎⴹⵏ ⴹ ⵓⵔ ⵜⴾⵙⵎ ⵜⵎⴰ ⴼⵍⵙ ⵤⴶⵤⵏⵗ ⵙ ⵎⵛⵏⴰ⵰ ⵓⴰ ⴹⵏⴰ ⴹⵏ ⴹ ⴶⵓ ⵙⵎⴾⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ⵎⵔⵏ ⴾⵏ⵿ⴹⵀⴰ ⵙ⵿ⵜⵀ ⴹⵔⵏⵗ ⵗⵍⵍ ⵏⵎⵏ ⵢ ⵜⵛⵛⵓⵜ ⵏⴾⵍ ⵢⵏ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ⵙ ⴶⴰ ⴹⵓⵏⵢ ⵏⵂⴹ ⵏⵤⵍⵏⵏⴰ ⵓⵏ ⵎⵔⵓ ⴹⴾⵤ ⵜⴶⵔ ⴼⵍⵏⴰ ⵜⵤⴼⴰ ⵀⵜ ⴹⵔⵏⵗ ⴹⵓ ⵗⵍⵍ ⴼⵍ ⴶⵔⵓ ⴶⵏ ⵙⵎ ⴹⵔⵢⵜⴾ ⵏⴼⵔⵢⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⵏⵎⵏ ⴹⵙ ⵎⴹⵍ ⵓⵔ ⴶⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ⵜⵤⵔ ⴶⵔⵏ ⴹⵗ ⵎⵏ ⵗⵏ ⵢⵙⵔⵙ ⴾⵜⵏ ⵜⵤⴶⵔⵜ ⵏⴶⵔⵓ⵰ ⵜⵆⵍ ⵜⵤⴶⵔⵜ ⵏⵎⵏ ⴹⵗ ⴹⴶ ⵓⵏ ⵙⵢⵜ ⵜⵎⵔⵓⵏ ⵏⵗⵍ ⴹⴾⵤ⵰ ⵙ ⴶⵏ ⵎⵤⵢ ⵍⵙⵏ ⵜⴾⵜ ⵙⵏⵏ ⴹⴶ ⵓⵏ ⵜⵎⵙ ⵜⵤⴶⵔⵜⵏⵜ ⵙⵎⵙⵜ ⵜⵎⵔⵓⵏ ⵏⵗⵍ ⴹⵙⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ⵜⴶⵤⵜⵏ ⵜⵙⴰ ⵏⴹ ⵏ⵿ⴼⵍ ⵗⵍⵍ ⵏⵎⵏ ⵢ ⵜⵂⵏ ⵜⵤⵔ ⴶⵔⵏ ⴹⵗ ⵎⵏ ⴹⵗ ⵍⵆⵎ ⵏⵗⵍⵍ ⴾⵤⵜ ⵜⵤⵍⵢⵓⵏ ⵛⵏ ⵙ ⵜⵏⴹⵢⵏ ⵎⵔⵏ ⴹ ⵜⵜⵔⵏ ⵜⵏⵙⴾⵏⵏ ⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ⴹ ⴶⵎⵢⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⵏⵎⵏ ⴹ ⴹⴶⴶⵏ⵰ ⵜⵤⵔ ⵙⵔⵙⵏ ⵜⵗⵍⵍ⵿ⵜ ⵏⵎⵏ ⵜⴰ ⵏ⵿ⴹⵔⵜ ⴹⵗ ⴶⵔⵓ ⴶⵏ ⵙⵔⵓ ⵙ ⵔⵏ ⴹ ⵏ⵿ⴹⵢⵏ ⵗⴼ ⵏⵗⵍⵍ ⵙ ⵛⵢⴹ ⵛⵤⵍⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ⵎⵛⵏ ⵏⴰ ⵀⵍⵙ ⵢ ⴾⵀⵜⵏ ⴹⵙⵌⵜⵏ «ⵎⴹⵏ ⵏ ⵙ ⴶⵎⴹⵏ ⵗⵍⵍ ⵓⴰ ⵓⴹⵢ ⵓⵔ ⴹⵓⵏ⵿ⵜⵍⴰ ⴶⵎⴹ ⴹⵎⵏⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ⵜⵤⵔ ⵍⵢⵏ ⵙⵌⵜⵏ ⵗⵏⵏ ⵓⵏ ⵆⵏⵏ ⵜⵗⵍⵍ⵿ⵜ ⴶⵍⵏ ⴹⵔⵙ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ⵙ ⵀⴾ ⵤⵍ ⵢⴶⵢ ⴶⵎⵢ ⵀⵍⵙ ⴹⵗ ⵓⴹⵏ ⴾⵍ ⴹ ⵜⵛⵓ ⵏⵙⵏ «ⵤⵍⴹⴰ ⵤⵍⵏⵓⵏ ⵓⵏ ⵎⵔⵓ ⴹⴾⵤ ⴹⵛⵓⵛⴰ ⵍⵀⵙⵏ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵙ ⵜⵔⵎ ⵜⵜⵢⵏⵜ ⵓⵍⴰ ⵢⵏ ⴶⵤⵏ ⵎⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ⴹⵗ ⴹⵢ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹ ⵜⵜⵛⵎ ⴼⵍ ⴹ ⵜⵔⴶⵎ ⴼⵍⵙ ⵓⵔ ⴾⵓⵏⵂⴰ ⵢ ⴹⵗ ⵏ⵿ⵤⵀⴰ ⵓⵍⴰ ⵏ⵿ⵤⴹ ⵢⵏ⵿ⴹⴰ ⵏⵗⴼⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ⵙ ⵏⴰ ⵀⵍⵙ ⵓⵏ ⴹⴾⵍⴹⵓ ⵜⴶⵍⴰ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴹⵜⵙⵏ ⴾⵜⵏⵙⵏ ⵎⵔⵏ ⴾⵔⵎⵜ ⴹⵗⵙ ⴹ ⵜⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ⵜⴶⵎⴹⵜⵏ ⵜⵙⴰ ⴾⵜⵏⵙⵏ ⵜⵛⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ⵓⴰ ⵏⵎⵙ ⴹⵗ ⵗⵍⵍⵏ ⴾⵜⵏⵏⴰ ⵙⵏⵜⵜ ⵜⵎⴹ ⵏⵓⴹⵏ ⴹⵙⵢⵜ ⵜⵎⵔⵓⵏ ⴹⵙⴹⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ⵙ ⵢⵓⵏⵏ ⴹⵏⵆⵍⵏ ⵍⴾⵎⴰ ⴹⵗ ⴶⵔⵓ ⴼⵍ ⴹ ⵙⴼⵙⵙⵏ ⵗⵍⵍ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ⵙ ⴶⴰ ⵤⵍ ⵏⵢⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵍⵍ ⵙ ⴾⵍ ⵓⴰ ⴹⵏⵂⵤⵏ ⴹⵏ ⵓⵔ ⵜⵤⴹⵢⵏ⵰ ⴶⵏ ⵤⵤⵍ ⴹⵗ ⵜⵛⵛⵓⵜ ⵏⵏ ⴹ ⴶⵎⵢⵏ ⴹⵙⵔⵙ ⵓⵢⵏ ⵗⵍⵍ ⵂⵔ ⴹⵙ⵿ⵜⵙⵙ⵿ⵜⵀⵏ ⴾⴹ ⴹ ⴼⵔⴶⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ⴾⵙⵏ ⵛⵤⵍⵢⵓⵏ ⵛⵏ ⵏ⵿ⴹⵢⵏⵏ ⵗⵍⵍ ⵢⵏ⵿ⵜⵏⵜⵏ ⵙⵎⵏ ⵔⵏ ⴹⵗ ⵗⵏⵏ ⵏ⵿ⴾⵜⴾⵓⵜⵏ ⵓⵏ ⵙⵏⵎⴹⵏⵏ ⵗⵍⵍ⵰ ⴹⴼⵔ ⴹⵢ ⴾⵙⵏ ⴹⴰ ⵢⴼⵔ ⵓⴰ ⵂⵏ ⴹⵜ ⵗⵍⵍ ⴼⵍ ⴹ ⵜⵙⴾⴼ ⴹⵓ ⵎⵔⵏ ⵙⵏⵎⵓⵍⵏ⵿ⵜⵓ ⴹⵜⴶⴹⵎⵢⵜ ⵂⴰ ⵤⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ⵎⵛⵏ ⵏ⵿ⴼⵍⵏ ⵢ ⵜⴶⴼ⵿ⵜ ⵏⵤⵤⵍ ⵜⵂⵜ ⴶⵔⵓ ⵜⵜⵢ ⴹⵗⵙ ⵗⴼ ⵏⵗⵍⵍ ⵎⵤⵢ ⴹⵎⵜⴾⵓⵢ⵰ ⵜⵤⵔ ⴹ ⵜⵔⵤⵓ ⵙⵂⵜ ⵏ ⵜⵏⵤⵎⵔⵏ ⵍⵆⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ⵏⵢⵏ ⵙⵌⵜⵏ ⵓⵏ ⵗⵙ ⵏⵎⵏⴾⵏ ⴼⵍ ⴹ ⴾⵙⵏ ⵎⵏ ⴹⵗ ⵎⵙⴾⵙⴰ ⴼⵍ ⴹ ⵓⵔ ⵛⴼ ⵓⵍⵢⵏ ⴹⵗⵙⵏ ⴹⴶⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ⵎⵛⵏ ⴶⴹⵍⵙⵏ ⴾⵀⵜⵏⵙⵏ ⴶⵢ ⵏⵓⵏ ⴼⵍⵙ ⵔⴰ ⴹ ⴶⵤ ⵀⵍⵙ⵰ ⵜⵤⵔ ⵎⵔ ⴾⵀⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵏⵏ ⵓⵜ ⵏⵎⵏ ⴹ ⵜⵔⴶⵏ ⴹⵗ ⴶⵔⵓ ⵤⵔⵏⵏ ⵙ ⵜⴶⴹⵎⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏ⵿ⵜⵏⵢ ⵎⵔ⵿ⵜⵏ ⵙⴹ ⵓⵔⵏ ⴾⵜⴾⵓⵜⵏ ⴹⴶⵏⵜⵏ ⵏⵗⵍⵍ ⵓⵏ ⴹⵏⵙⵔⵏⵏ⵰ ⵎⴾⵏ ⴹⴰ ⵙ ⵓⴹⵏ ⴾⵜⵏⵙⵏ ⵜⴶⴹⵎⵢⵜ ⵏⴶⵔⵓ ⵔⴶⵏ⵿ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ⵙ ⴹⵏⵔⴶ ⴹⵗ ⵓⵏ ⵏⴶⵎⴹⵓ ⵎⵏ ⵜⵓⵏⵏⴰ ⴾⵍ ⵓⵏ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⵙⵎⵏⵜ ⵎⵍ⵿ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ⵙⴾⵏⵏⵏⵗ ⵢⵜⴹⵏ ⵏⴾⵍ ⵓⵏ ⵍⵗ ⵓⵔ ⵏⵍⴰ ⵜⵍⵜ⵰ ⴶⵏⵏⴰ ⴾⵜⵏⵏⴰ ⵎⵔⵂⵀⴰ ⵙⵔⵗⵏⵏⴰ ⵜⵎ⵿ⵙⵢ ⴼⵍⵙ ⴾⵏⴾ ⴼⵢⵏ ⴶⴰ ⴹⵗ ⵙⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ⵛⴹⵓⴹⵓ ⵀⵍⵙ ⵗⴼ ⵏⵛⴾⵏ ⴶⵏ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵜⴾⵙⴹⵓ ⴹⵗⵙⵏ ⵜⴾⵙⵢ ⵜⵛⵍ⵿ⵜ ⵜⴹⴹ ⴼⵙⵏⵜ ⵜⴾⵔⵢⵔⵢ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ⵙ ⵏⵢⵏ ⴾⵍ ⴾⵍ ⵓⵏ ⵜⵛⵍ⵿ⵜ ⵜⴾⵔⵢⵔⵢ ⴹⵗ ⴼⵙ ⵏⵀⵍⵙ ⴹ ⵜⵏⵎⵏⵏ «ⴶⵎⴹ ⵛⴾ ⵙ ⵍⵙ ⵓⵏ ⵎⴶⵢ ⵏⵎⵏ ⵎⵙ⵰ ⵔⴶⴹⵓ ⴹⵗ ⴶⵔⵓ ⵎⵛⵏ ⵂⵔⵓⴰ ⴹⴰ ⵍⴾⵎⵙ ⵛⵔⵗⴰ ⵓⵔ ⵔⴰ ⴹ ⴹⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ⵔⵙⴾⵏ ⵀⵍⵙ ⵜⵛⵍ⵿ⵜ ⵜⵔ⵿ⵜⴾ ⴹⵗ ⵜⵎ⵿ⵙⵢ ⵓⵔ ⵜⵍⴰ ⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ⵆⵍⵏ ⵢⵜⴹⵏ ⵢⴹ ⵂⴹⴹⵢ ⵀⵍⵙ ⵎⴹⵗ ⴼⵜⵆⵜ ⵀⵜⵓ ⵜⵎⵤⵢⵜ ⵜⵏ ⴹⴰ⵰ ⵎⵛⵏ ⵙ ⵔⵓⵏ ⵓⵔ ⵂⵏⵢⵏ ⵜⴶⵔⵓⵏ ⵆⵍⵏ⵿ⴹⵓ ⴹⵗ ⵓⴰ ⵏⵏ ⴹ ⴶⵏⵏ ⵎⵔⵏ «ⵎⵍⵢ ⵢⵏ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ⴹⴶⵏ ⵂⵤⵏⵜⵓ ⵜⵓⴶⵙ ⵏⵀⵀⵍⵢⵙ ⵍⵙ ⵓⵏ ⵎⵤⵔ ⵏⴾⵍ ⵓⵏ⵰ ⵤⵤⵀⵜⵏⴰ ⴹⵗ ⵂⵏⵜ ⵏⴶⴰ ⴾⵔⴹ ⴹⵏ ⵏⵏⴼ⵿ⵜⵗⵙ⵰ ⴶⵏⴰ ⵎⵔⵂⵀⴰ ⴹⵎⴶⵔⴰ ⴾⵏⵏⵏ ⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ⵙ ⵜⴶⵓ ⵓⵏ ⵜⵤⵤⵍⵍⵜ ⵜⵏⴹⵢ ⵀⴰ ⵏⵀⵀⵍⵢⵙ ⵜⵔ⵿ⵜⵢⵙ ⴹⵜⴹⵙ⵿ⵜ⵰ ⵙⵢⵏ ⵀⵍⵙ ⵙⵓⵔ⵿ⵜⵓ ⴼⵙⵏⵜ ⵏ⵿ⵙⵢⵙ ⵎⵛⵏⴰ⵰ ⵤⵤⵢⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ⴹⴼⵔ ⵓⵏ ⴹⵜⵙⵏ ⵎⵔⵏⵏ ⵏⴾⵍ ⵓⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵓⵤⵤⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ⵙⴾⵏⵏⵏⵗ ⵢⵜⴹⵏ ⵏⴾⵍ ⵓⵏ ⵙⵗⵎⵔ ⴶⵏ ⵙ ⵏⴶⵤ ⵛⵏ ⵜⴾⵍⵢ ⴹⵗ ⵗⵍⵍ ⵏⵎⵏ ⵢⵏ⵰ ⴾⴼⵏⵏⵗ ⵔⵜ ⵓⵙ ⵏⴹⵔⵔ ⵢⵛⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ⵙ ⵏⴶⴰ ⴾⵔⴹⵜ ⵜⵍⵍ ⴹⵗ ⵎⵍ⵿ⵜⴰ ⵏⴶⵤ ⵗⵍⵍ ⵏⵎⵏ ⴹⴶⵎⴹⵏ ⵗⵔⵎ ⵏⵍⵙⴾⵏ⵿ⴹⵔⵢⴰ ⵙ ⵓⵔⵏ ⵙⵏⵎⵏ ⵙ ⵜⵓⵏⵓ \"ⵓⵏ ⴾⵏⵓⵏ\" ⵗⴼⵏⵜ ⵙⵏ⵿ⵜⴰ ⴹⴰ ⴾⵍ ⵓⵏ ⴹⴰ ⵎⵙⵏ ⴶⵔⵓⵜⵍⵏ ⴹⵗ ⴾⵙ ⵜⴶⵔⵙ⵿ⵜ ⵏⴶⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ⵙ ⵏⵙⴰ ⵗⵔⵎ ⵏ⵿ⵙⵔⴾⵙⴰ ⵏⴶⴰ ⴹⵗⵙ ⴾⵔⴹ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ⵏⴶⵎⴹ ⵙⵔⴾⵙⴰ ⵏⴶⵍⴰ ⵂⵔ ⵏⵙⴰ ⵗⵔⵎ ⵏⵔⴶⵢⵏ⵰ ⵙ ⵤⵍ ⵓⴰ ⴹⴼⵔ ⵓⵏ ⴶⵔⴹⵓ ⴹⵓ ⵓⵏ ⴶⵍⴰ ⵏⴶⵍⴰ⵰ ⵙ ⵤⵍ ⵓⴰ ⵂⴹⵏ ⵏⵓⴹ ⵗⵔⵎ ⵏⵀⵜⵢⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ⴹⵏ ⴹⴰ ⴹ ⵏⵙⵂⴰ ⴼⵍ ⵔⵜ ⴹⵗ ⵏⵍⴾⵎⵏ ⵏ⵿ⵗⵢⵙⴰ ⴶⵎⵢⵏ ⴹⵗⵏⴰ ⵗⵔⵙⵏ ⵏⴶⵓ ⵙⴰ ⴹⵏ⵰ ⴹⴼⵔ ⵓⵏ ⵏⵏⵎⴹ ⵗⵔⵎ ⵏⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ⵙ ⴹⵏⵗⵙⵍⵏ ⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵗⵔⵎ ⵏⵔⵎ ⵙⵍⴾⴹⵏⵏⴹⵓ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵜⵏ ⵙⴾ ⵏⴼⵢⵙ ⵓⵢⴹ ⵙⵍⴾⴹⵏⵏⴹⵓ ⵙ ⵜⵗⵔⵎ⵿ⵜ ⵙ ⵜⵓⵏⵓ ⵜⴰ ⵏ⵿ⴾⵔⴹ ⵤⵤⵀⴰ⵰ ⵙ ⵜⵏⵏⵢ ⵀⵍⵙ ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴾⵏⴰ ⵓⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ⵙ ⴹⵏⴶⵤ ⵗⵔⵎ ⵏⵔⵎ ⵔⴹⴰ ⵍⵈⴾⵎ ⵢ ⵀⵍⵙ ⵙⴹ ⵗⵙⵔ ⴹⵗ ⵂⵏ ⵓⵔ ⵏⵎⵂⴰ ⵔ ⴹⵙⵌⵢ ⵓⴰ ⵜⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ⴾⵔⴹ ⴹⵏ ⴹⴼⵔ ⵓⵏ ⵙⵙⵗⵔⴹⵓ ⵀⵍⵙ ⵎⵤⵔⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵗⵔⵎ ⵏⵔⵎ⵰ ⵙ ⴹⴹⵓⵏ ⵏⵙⵏ «ⵎⴹⵔⵢⵏⵏ ⵏⴾ ⵓⵔ ⵏⵗⵛⴹ ⵔⵜ ⵓⵍⵢⵏ ⵢ ⵜⵎⵜⵢⵏⵏⴰ ⵓⵍⴰ ⴹⵗ ⵎⵤⵔⵢⴰ ⵍⵗⴹⵜⵏ ⵛⵏ ⴹⵏⴶⵤ ⵗⵔ ⵎⵔⵓⵏⵏⴰ ⵎⵛⵏ ⵜⵔⵎⵙⵗ ⴹⵗ ⵢⵔⵙⵍⵎ ⵜⵓⴶⴰ ⴹⵗ ⴼⵙⵏ ⵏ⵿ⴾⵍⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ⵙ ⴹⵛⵔⵗⵏ ⵔⵏ ⴹⵢⵏ ⴼⵍⵙ ⵓⵔ ⴶⵗ ⵔⵜ ⵓⵍⵢⵏ ⴹⵙⵓⵔⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ⵎⵛⵏ ⵏ⵿ⴾⵔⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵢⵏ ⵙⴹ ⵜⵓⵢⴰ ⵆⵍⵢ ⵛⵍ ⴶⵎⵢ ⵏ⵿ⴹⵛⵔⵗ ⵆⵢⵙⵔⴰ ⵎⵏⴾⵍ ⵓⴰ ⵤⵓⵔⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔ ⴶⵗ ⵏⵢⵜ ⵏⴹ ⴶⴰ ⵢ ⵜⵎⵜⵢⵏⵏⴰ ⵜⵗⵜⵙ⵿ⵜ ⵓⵍⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ⴹⵢ ⴼⵍ ⴾⵓⵏⵙⴶⵎⵢⴰ ⴾⵓⵏⵏⵢⴰ ⵎⵛⵓⵍⴰ ⴹⵔⵓⵏ⵰ ⵙⵙⵔⵏ ⵓⵏ ⵓⵔ ⵙⵔⵢ ⵜⵏ⵿ⴹⵓⵢ ⵔ ⵙ ⴶⵗ ⵜⵎⵏⵏ ⴹⵗ ⵓⵙ ⵆⵍⵏ ⴾⵍⵙⵔⵢⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ⵏⵏⵙ «ⵏⴾⵏⵢ ⵤⴰ ⵓⵔ ⵏⴶⵔⵓ ⵛⵔⵓⵜ ⵓⵍⵢⵜ ⴹⵜⴼⵍⵜ ⴾⵍ ⵏⵢⵂⴹⵢⴰ ⴹⵗ ⵜⵍⵗⵏⴾ ⵓⵍⴰ ⴹⵗ ⵙⵏⴹⵓ ⵢⵏ ⴹⵗ ⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⴹⵏ ⴶⵏⴰ ⵙⵍⵏⴾ ⵎⴹⵗ ⵏⵓ ⵙⵔⴾ ⵔⴾ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ⵎⵔⵏ ⵏⵔⴰ ⴹⵏⵜⵎⵍⴰ ⴾⵢ ⵎⵏⴾ ⵓⴰ ⵜⵙⵎⴹⵔⵏⵗ ⴼⵍⵙ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙ ⴹⵏⵗⵂⵏ ⵙⵍⵏⵜ ⵙ ⵜⴶⵢⵜ ⵜⵏ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵓⵔ ⵜⵍⴰ ⴹⴶ ⵜⵜⵓⵔⵏⵛⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ⵜⵤⵔ ⵏⵎⴶⵏ ⴹⵔⵙ ⵜⵎⵙ⵿ⵜⵏ⵿ⵜ ⵤⵍ ⵢⵏ⵰ ⵙ ⴹⵗⵍⵢ ⵤⵍ ⵓⵏ ⵙⵏ⵿ⵜⴹⵓ ⵙⴶⵜ ⴹⵗ ⵂⵏ ⵓⴰ ⵂⴰ⵰ ⵛⵓⵍⵙⵏ ⵙ ⴶⵍⵢⵜ ⴹⵗ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵏ ⵗⵔⴰ ⵂⵔ ⴶⴰ ⵂⴹ ⵙⵙⴶⵔⵙⵏ⵿ⵜⵜ⵰ ⵙⴾⵏⵏ ⵙ ⵜⵎⵓⵜ ⵜⵙⵙⴶⵔⵜ ⴹⵗ ⵜⵓⵔⵜ ⵏⵎⵙⴰ ⴹⵍⴾⵜⵀⵏ ⵏⵏⵀⵜⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵙ ⵓⴰ ⴶⵏⵓ ⵙ ⵗⵢⵙⴰ ⵜⴹⵜ ⴹⵗ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ⵓⵢⴹ ⵙⴾⵙⵏ ⴹⵗⵙⵏ ⵔⵜⵏ ⵓⵏ ⵏⴰ ⵀⵍⵙ ⵛⴾ ⵤⴶⵤⵏⵏ⵰ ⵓⵏ ⵂⴹⵜⵏⵏ ⴶⵢⵏ ⵙⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ⵜⵤⵔ ⵎⵤⵗⵏ ⴶⵔⵙⵏ⵰ ⵙ ⴶⵤⵏ ⵛⵏ ⵜⴾⵍⵢ ⵏⴰ ⵀⵍⵙ «ⵜⴹⵜ ⴹⴰ ⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵢ ⵎⵔⵓⵏⵏⴰ ⴹⵗ ⵎⵢ ⵏⵏⵀⵢ ⵙⵢⵙ ⵙ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ⴶⵍⵓ ⴾⵓ ⵜⵎⵜⵢ ⵏ ⵜⵏⵗⵙ 'ⴹ ⵜⵢⵓⵏ ⵙⵙⵎ ⵎⵛⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵜⴶⵔⴰ ⵓⵍⴰ ⵜⵢⵓⵏ ⵙⵓⴹ ⵎⵛⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵜⵏⵢ ⵓⵍ'⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ⴼⵍⵙ ⵜⵎⵜⵢ ⴹⵢ ⵙⵗⵔ ⵜⴶⴰ ⵓⵍⵏⵜ ⴶⵔⴹ ⵙ ⵙⵍⵏⵜ ⵜⵎⵤⴶⵏⵜ ⵜⵆⵏ ⵛⵜⵓⵏⵜ⵰ ⴼⵍ ⴹ ⵓⵔ ⵜⵏⵢ ⵤⴰ ⵓⵍⴰ ⵜⵙⵍⵓ ⵜⵆⵎ ⴹⴰ ⵓⵔ ⵜⴶⵔⴰ ⵙⵓⵍⵏⵜ ⵏ⵿ⴶⵎ ⵜⵜⵀ ⵤⵤⵢⵆⵜ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ⴹⴼⵔ ⵓⵏ ⵏⵙⵏ ⵀⵍⵙ «ⵙⵏⵜ ⵤⴰ ⵙ ⵛⵎⵜⵓⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵏⵜⵢ ⴹⴰ ⵙⴾⵏⵜⴹⵓ ⵎⵛⵏⴰ ⵙⵍⵏ ⵏⴼⵙⵏⵜ⵰ ⵏ⵿ⵜⵏⵜⵢ ⴹⵙⵏ⵿ⵤⵙⵙⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ⵙ ⵏⴰ ⵀⵍⵙ ⵓⵏ ⴼⵍⵏ⵿ⵜⵓ ⴾⵍⵍⵢⵂⴹ ⵎⵤⵗⵏ ⵓⵍⵏ ⴶⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ⴶⴰ ⵀⵍⵙ ⵛⵏ ⵍⵏ ⵗⵔⴹⵏⵏ ⴹⵗ ⵂⵏ ⵈⴼⵔ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵜⴶⵓ ⵎⵔⵂⵀⴰ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵔⵏⵏ ⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ⵜⴶⵙⵏ ⵙⵍⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵙⵙⵗⵔⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵆⵍⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵛⵢ ⵓⵍⴰ ⵜⵙⴰ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵓⴹⵏ ⴹⵙⴶⴹⵍⵏ ⵓⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⴾⵍⵢ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵜⵓⵗⵔⵏ ⵙ ⵜⵛⵜ ⵏⵏⵎⵤⵍ ⵜⵓⵙⴾⵜ ⴹⵗ ⵢⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ⵍⵏ⵿ⵌⵍ ⵓⵏ ⵔⵓ ⵎⵛⵏⴰ ⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ ⵢⵏⵀⵜⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵓⵏ ⵤⴹⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⴹⵏ ⵎⴶⵔⴹⵏ ⴹⵗ ⵀⵜⵓ ⵏⵀⵔⵔ ⵏⵎⵛⵏⴰ ⴹⵂⵓⵏ ⴹⵗ ⵤⵔⵢⴰ ⵏⵏⵀⵢ ⴹⵓⴹ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵛⵜⵏⵜ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ⴹⵗ ⵀⵜⵓ ⵎⵔⵏ ⵜⴰ ⵜⵆⵍⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⵜⵓⵈⵙⵀ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵙ ⵜⵔⵏⴰ ⵙⵙⵀⵀ ⵏ⵿ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ⵜⵔⵢⵜⵏⵜ ⵙ ⵏⴶⵔⵓ ⵔⵈⵎⵜ ⵏ⵿ⵜⵛⵜ ⵏⵎⵤⵍ ⴼⵍ ⴹⵏⵓⵢ ⵛⵎⵜⵓⵏ ⴾⵍ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵀⵔⴹⴶ ⵓⴰ ⴹⵜⵓⵢ ⵤⴶⵤⵏ ⴼⵍ ⵙⵗⵎⵔ ⵏⵙⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ⵛⵎⵜⵓⵏ ⵛⵏ ⴾⵓⵏⵢ ⴹⴰ ⵜⵂⵎ⵿ⵜⵏⵜ ⴾⵓⵏⵢ ⵗⵔⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ⴾⵜⵀⵗⵓⵏⵏ ⴾⵜⵏⵓⵏ ⴾⵓⵏⵢ ⵂⵏⵏ ⵗⵔⵎ ⵏⵔⵎ ⵜⵎⵙⵎ ⵓⵏ ⴾⵏⴰ ⵎⵛⵏⴰ ⵜⵔⴰ ⵜⵜⵓⵗⵔⵎ ⵙⴹ ⵜⵤⴹⴶⵎ⵰ ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵓⵏⴶⵏ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ⴹⵗ ⵜⵤⵔⵜ ⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵗ ⵀⵜⵏⵓⵏ ⴾⵜⵏⵓⵏ ⴹ ⵤⴶⵤⵏⵓⵏ ⵜⵓⵙⵍⴰ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ⴶⵢⵜⵢ ⵎⵛⵏⴰ ⵗⵀⴹⴰ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵙⵎⵍ ⵓⴰ ⵜⴶⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵀⵔⵔⵏⵜ ⵙ ⴼⵓ ⵜⵂⵎ ⵛⵓⵜⵔⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ⴼⵓ ⴹⴰ ⴶⵎⵢⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏ ⴹ ⴶⵔⵓⵗ ⵜⵎⵓⵜ ⵏ⵿ⴾⵓⵏⵏⵙⴰ ⵙ ⵔⴹⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ⵜⴹⵜ ⵙ ⴾⵏⵗ ⵜⵔⴰ ⵏ⵿ⴾⵓⵏⵏⵢⴰ ⴼⵍ ⴹⵔⵓⵏ ⴹⵔⵓⵗ ⵔⵜ ⵏ⵿ⵜⵂⴾⵜⵏ ⵛⵢⴹ ⴹⴼⵍⵏⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⵤⵤⵓⵢ ⴹⵗ ⵤⴶⵤⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ⵍⵎⵗⵏⴰ ⵙ ⴹⵔⵓⵏ ⵏⵎⴶⵤⵗ ⴹⴶ ⵤⴶⵤⵏ ⵓⴰ ⵏⵍⴰ ⵏⴾ ⴹⵔⵓⵏ ⴹⵏⵗⵙⵙⵂⵜ ⴾⵜⵏⵏⴰ ⴹⵗ ⵜⵔⵢⵜ ⵜⴰ ⵏⵂⴰ ⵏⵎⵙⵙⵂⵜ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏⵓⵏ ⴹⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵢⵓⵏⵗ ⵜⵔⴰ ⵏ⵿ⴾⵓⵏⵏⵙⴰ ⴼⵍ ⴹ ⴶⵔⵓⴰ ⵗⵔⵓⵏ ⵜⵏ⵿ⴼⴰ ⵏⵛⵗⵍⵏ ⵓⵏ ⵏⵎⵤⵍ ⵤⵏ ⵜⴰ ⴶⵔⵓⴰ ⵗⵔ ⵜⵎⵜⵓⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⵎⵛⵏ ⵏ⵿ⴹⵔⵢ ⵓⵏ ⵂⵔ ⵂⵔⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ⵜⵛⵜⵏ ⵏⵎⵤⵍ ⵜⵙⵓⵔⵢ ⵛⵗⵍ ⴹⵗ ⵢⵜⴹⵏ ⴾⵍ ⴶⵔ ⴾⵍⵍⵢⵏⵏ ⵙ ⵎⵔⵏⵜ ⵛⵜⵓⵏⵙⵏ ⵓⵍⴰ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⴶⵔ ⵓⵏ ⵎⵙⵏⵏ ⵓⵍⴰ ⵓⵏ ⵍⵌⵂⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵙⴹⵔⵏⵗ ⵓⵍⵏ ⴹⵓⵏⴶⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴾⵓⵏⵢ ⴹⴰ ⵂⵏⵏ ⵗⵔⵎ ⵏⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ⴼⵍⵙ ⵓⵔ ⴹⵎⵙ ⵍⵏ⵿ⵌⵍ ⵜⴾⵔⴾⵜ ⴹ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⵎⵙ ⵜⵓⵢⴹⵓ ⴼⵙⵏ ⵙⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵤⴶⵤⵏⵏ ⵀⵤⵏ ⵗⵔ ⴾⵍⵍⵢⵂⴹ ⴾⴰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ⵍⴾⵏ ⵙ ⵜⵆⵜ ⵜⵏ ⵎⵛⵏⴰ ⵜⵏⴼⵍⵍ ⴹⵗ ⵍⵏ⵿ⵌⵍ ⵙⵤⴶⵤⵏ ⵎⵔⵏ ⵙⵤⴶⵤⵏ ⵗⵙ ⴹ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴹⵏ ⵓⴰ ⵗⴹⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ⵍⵂⵎ ⵏⵎⵛⵏⴰ ⴼⵍⴹⵓ ⵌⵏⵓⵏ ⵜⴾⴹⵓ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵓⵔ ⵏⴾⵙⴹ ⵎⵛⵏⴰ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵓⵔ ⵏⵗⴹ ⵓⵗⵏ ⵜⴹⵜ ⴶⴹⵍⵏⵙ ⵏⴼⵍⵍ ⵙⵀⴰ ⵏ⵿ⵜⵆⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ⴼⵍⵙ ⵔⵜ ⵓⴰ ⴼⵔⴶⵏ ⵜⵓⵙⵏ ⴹⵗ ⵀⵜⵓ ⵏⵎⵛⵏⴰ ⵀⵢⵏⵙⵏ ⴹ ⵎⵛⵏⴰ ⵎⵏⵜ ⴹⵙⵏ⵿ⵜⵙⵏⴼⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ⵓⵍⴰ ⵂⵔⵓⴰ ⵗⵔ ⵈⵍⴾ ⵏⵎⵛⵏⴰ ⴹⵏⵜ ⴹⴰ ⵙⵢⴼⵜⵏⵜ ⵛⵏ ⵓⵔ ⵏⵜⵓⵏⵢ ⵎⵙⵏⵏ ⵜⵔⵏⵏⵜ ⵜⵗⵍⵍⵜ ⴹⵜⵛⵜⵏⵜ ⵎⵍⵢ ⵜⵓⵂⵏⵢⵏⵜ ⵎⵏⵜ ⴹⵗ ⴶⵜⵏⵜ⵰ ⴹⵗ ⴹⵢ ⵓⵔ ⵍⵏ ⵙⵔⵓ ⵓⵍⵢⵏ ⵜⵏⴾⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ⴹ ⵙⵏⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⵓⵔ ⴹⵙⴶⵏ ⵙⵗⵎⵔ ⵓⴰ ⴹⵔ ⵂⵔ ⵤⴰ ⵓⵔ ⴹⵙⴶⵏ ⴶⴹⵏ⵰ ⴾⵍⵔ ⵢⵏ ⵎⵏⵙⵏ ⵙⵈⵔⴾⵏ⵿ⵜⵏ ⵎⴹⵔⵏⵏ ⵓⵔ ⵏⵏ⵿ⴼⴰ ⵓⵍⴰ ⵌⵓⵏ⵿ⴾⵏ ⴹⵗ ⴹⵗ ⵛⵢⵢ ⴹ ⵓⵍⵏⵙⵏ ⵗⴼⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ⴶⵏ ⴹⴼ ⵏⵙ ⵎⵙⵏ ⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵎⵙⴾⵍⵏ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ⵏ⵿ⴾⵔⵏ ⵙ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵗⵍⵍ ⴶⵏ ⴹⵗ ⴹⴶⵏⵜ ⵛⵛⵍⵏⵏ ⵏⴶⴹⵎ ⵓⵔ ⵏⵗⵍⵍ ⴹⴶⴹⴹ ⴹⵂⵔⵓⵏ ⴹⵓⵈⵙⵏ ⴹⵎⵔⴹⵎⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ⵓⵏ ⴹⵗ ⴼⵍ ⵜⵏⵢⴰ ⵎⵛⵏⴰ ⵍⴾⵎⵏ ⵢⵔⴾ ⴹⵔⵏⵏⵙⵏ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵙⵎⴹⵙⵏ ⵎⵏⵙⵏ ⵙ ⵜⵎⵓⵜ ⵜⵙⴼⵍⵙⵜ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ⵏ⵿ⵜⵏⵢ ⵙⵎⵜⵢⵏⵏ ⵜⴹⵜ ⵏⵎⵛⵏⴰ ⴶⵏ ⵀⵂⵓ ⴹⵗ ⴹⴶⵏⵜ ⵗⵀⴹⵏ ⵎⵜⵓⵈⵍⴾ ⵢⵏ ⵓⴰ ⴹⵈⵍⴾⵏ⵰ ⵜⵎⵍⵜ ⵙⵎⵏⵜ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ⵓⵏ ⴹⵗ ⴼⵍ ⵜⵏⵢⴰ ⵎⵛⵏⴰ ⴶⵤⵏ ⵜⵔⴰ ⵏⵎⵏⵙⵏ ⵓⵢⴹⵓ ⵙⵔⵙⵏ ⵓⵏ ⵛⴼⵍⵙ ⵂⵔ ⵙ ⵛⴹⴹⵏⵙⵏ ⵀⵙ ⵜⵏⵎⵏ⵿ⵙⵏⵜ ⴹⵎⴹⵏ ⴾⵍⵔ ⵛⴹⴹⵏ ⴹⵔ ⵜⵏⵎⵏ⵿ⵙⵏⵜ ⵎⵙ ⵓⵏ ⵔⵜ ⵎⵤⵔⵢⵏ ⵜⵀⵗⵜ ⵏⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ⵎⴹⵏ ⴹⵗ ⴶⵏ ⵓⵏ ⴹⴰ⵰ ⵀⵙ ⵜⵏⵎⵏ⵿ⵙⵏ ⴹⵜⴹⴹⵏⵙⵏ ⴹ ⵜⵏⵎⴶⵏ ⵤⵏⴰ ⴶⵔⵙⵏ ⴾⵏⵏ ⵜⵔⴰ ⵏⵓⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵈⵔⴾⵏⵏ ⵏ ⵜⵏⵀⵤ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵙⵜⴹⵀ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⵍⵏ ⵓⵔ ⵏⵜⵓⴶⵓ ⵓⵏ ⵜⴶⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ⴹⴹ ⵤⵎⵙ ⴶⵢⵏ ⵙⴹ ⵙⵏⵏ ⵎⵛⵏⴰ ⵢⵏ ⵎⵛⵏⴰ ⵍⴾⵎⵏ ⵢⵔⴾ ⵜⵢⵜⵢⵏⵙⵏ ⴹ ⵜⴶⵏ ⵎⵤⵍⵏ ⵓⵔ ⵏⵎⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ⵜⴶⵏ ⵤⵏⴼⵏ ⴾⵍ ⵏⵎⵤⵍⵏ ⵓⵔ ⵏⵗⴹ ⴹⵛⵔ ⴹⵜⵎⴰ ⴹⵗ ⵓⵔ ⵍⵏ ⴹⵤⵏ⵿ⴶⵓ ⴹⵎⵏ⵿ⵤⵗ ⴹⴶⵢ ⵏⵎⵏ ⴹⴾⵏⵙⵏ ⴹⵜⴾⵔⵙ ⴹⵜⵛⵜ ⵏⵎⴾⵙⵏⵏ⵰ ⵙⵓⵔⵏ ⵢⵜⴹⵏ ⵀⵂⵓ ");
INSERT INTO ttqt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ⴾⵢⵏ ⴶⵏⵓ ⵔⴾ ⵔⵜⵏ ⵙ ⵓⴰ ⵂⴹⵏ⵰ ⵎⵙⵏ ⵤⵏ⵿ⴶⴰ ⵏⵎⵛⵏⴰ ⵓⵔ ⵍⵏ ⵍⴹⵀ ⵜⵏⵔⵀⴹⵏ ⵂⵏ ⵤⵤⵓⵔ ⵏⵎⵏ ⴶⵎⵢⵏ ⵜⵔⵢⵏ ⴾⵍ ⵛⵏ ⴶⵢ ⵏ⵿ⵜⴾⵎⴰ⵰ ⵓⵔ ⵀⵔⴹⴶⵏ ⵢ ⵎⵔⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ⵓⵔ ⵍⵏ ⵜⵢⵜⵢ ⵓⵔ ⵗⴹⵍⵏ ⵓⵔ ⵍⵏ ⵜⴼⵔⵢⵜ ⵤⴰ ⵓⵔ ⵜⵏ⵿ⵜⵂⴰ ⵜⵂⵏⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ⴾⵏⵏ ⵎⵙⵏⵜ ⵏⵛⵔⵗⴰ ⵎⵙⵏ ⵜⵎⵜⵏ⵿ⵜ ⵜⵗⵍⵍⵜ ⵓⴰ ⵙⵏ⵿ⵙⴰ ⵎⵛⵏⴰ ⵢ ⵓⵏ ⵜⴶⵏⵏ ⵎⵤⵍⵏ ⵓⵏ ⴹⵏ⵰ ⵎⵛⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵙⵔ⵿ⵜⵢⵏ ⵙ ⵜⵎⵤⵍⵏ ⵔⴾ ⵔⵜⵏ ⵓⵏ ⴹⵏ ⴹⵙ ⵆⵀⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏ⵿ⵜⵎⵤⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ⴹⵗ ⴹⵢ ⴾⵢ ⵓⴰ ⵈⴾⵎⵏ ⵢⵢⵜⴹⵏ ⵙⵏ ⵙ ⵓⵔ ⴹⴾⵜⵜⵍⴰ ⵜⵙⵔⴼ⵿ⵜ ⵜⵆⵍⴰ ⴹⴰ ⴼⵍⵙ ⵙ ⵜⵈⴾⵎⴰ ⵢⵢⵜⴹⵏ ⵓⴹⵢ ⵎⵏⴾ ⵜⵜⵀⵤⴰ ⵙⵛⵔⵗⴰ ⴹ ⴾⵢ ⵎⵏⴾ ⴹⴰ ⵜⵜⴶⵗ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ⵎⵔⵏ ⵏⵙⵏ ⵙ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵓⵙ ⵀⵤ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵎⵤⵍⵏ ⵓⵏ ⴹⵏ ⵗⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ⵏ⵿ⵤⵔⵏ ⴹⵗ ⵙ ⴾⵢ ⵓⴰ ⵈⴾⵎⵏ ⵢⵜⴹⵏ ⴹⵔⴾ ⵍⵏⵏ ⵍⵈⵍ ⵓⵔ ⵜⵍⴰ ⵎⴾ ⵙ ⴹⵤⵜⵔⴶⴰ ⴹⵗ ⵛⵔⵗⴰ ⵓⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ⵎⵗ ⴾ ⵙⵜⵍⴾⴾ ⵜⴶⵗ ⵍⵗ ⵏⵎⵛⵏⴰ ⴹⵍⵍⵏⵜ ⴹⵜⵤⵢⴹⵔ⵿ⵜⵏⵜ ⵜⵆⵎⴰ ⵓⵔ ⴹⵏ⵿ⵜⴶⵔⵗ ⵙ ⵔⴰ ⴾⵢⵙⵎⵜⵢ ⵙⵍⵗⵏⵜ ⵜⵜⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ⵆⵙⵏⴾ ⴹⵜⴶⵢⵜⵏⴾ ⵙ ⵜⵜⵀⵜ ⴹⵓⵢⵏⵏ ⵙ ⵜⵓⵙⵎⵜⴶⴾ ⵍⵗⵤⵀ ⵤⵓⵔⵏ ⵤⵍ ⵓⴹ ⵤⵤⵎⵤⵍ ⵎⵛⵏⴰ ⵍⵂⵎⵏⵜ ⵏⴼⵍⵍ ⵛⵔⵗⵏⵜ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ⵤⵍ ⵓⵏ ⵓⴹⵏ ⴾⵍ ⴹ ⵜⴾⴼⵓ ⵎⵛⵏⴰ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ⵓⵏ ⴶⵏⵏ ⵜⵤⵢⴹⵔ⵿ⵜ ⵤⴰ ⴹⵗ ⵎⵤⵍ ⵏⵓⴰ ⵍⵗⵏ ⴶⵎⵢⵏ ⵙⵓⵏ ⵜⵓⵙⵗⵎⵔ ⵗⵔ ⵎⵛⵏⴰ ⴹⴹⴾⵍ ⴶⵎⵢⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵓⵔ ⵏⵗⵔⴹ ⵓⵏ ⴹⵢ ⴹ ⵜⵏⴾⴼⵓ ⵎⵛⵏⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ⵎⵔⵏ ⵓⵏ ⵓⵔ ⵏⴶⵎⵢ ⵔ ⵜⵏ⵿ⴼⴰ ⵏⵎⵏⵙⵏ ⵎⵙⵏ ⵍⴹ ⵏ⵿ⵜⴹⵜ ⵜⵎⵤⵍⵏ ⴹⵗ ⵔⵜⵏ ⵓⵔ ⵏⵗⴹ ⵓⵏ ⴹⵢ ⵜⵏⵙⴾⵏⵓ ⵎⵛⵏⴰ ⵛⵔ ⵏⵍⵂⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ⵓⵍⴰ ⵜⵙⵙ⵿ⵜ ⴹⵜⵎⵗⵜⵔ ⵍⵏⵜⵓ ⵢⵢⵜⴹⵏ ⵓⵏ ⵜⵎⵤⵍⵏⵏ ⵜⵍⵀⵙ⵿ⵜ ⵀⵤⵏ ⵗⵔ ⴾⵍⵍⵢⵂⴹ ⴾⴰ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵎⵤⵍⵏ ⵓⴰ ⵍⵗⵏ ⵓⴹⵢ ⵍⵙ⵿ⵜⵓ ⵜⴾⵍ ⴹⵜⵓⵙⵗⵎⵔ ⴹⵍⵈⵔ ⵀⵤⵏ ⵗⵔ ⴾⵍⵍⵢⵂⴹ ⴾⴰ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ");
INSERT INTO ttqt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ⴼⵍⵙ ⵎⵛⵏⴰ ⵓⵔ ⵜⴶⵓ ⵜⵎⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ⴹⵢ ⴼⵍⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵜⴶⵏⵏ ⵀⴾⴹⵏ ⵎⵙ ⵙ ⵌⵂⵍⵙⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵓⵏ ⴹⵢ ⵓⵔ ⵤⵜⵔⵎⵙⵏ ⵙⵛⵔⵗⴰ ⵓⵏ⵰ ⵎⵔⵏ ⵓⵏ ⵙⵏⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵜⴶⵏ ⵀⴾⴹⵏ ⵓⵏ ⴹⵢ ⴾⵜⵏⵙⵏ ⴹⵙⵏⵜⵓⵈⴾⵎ ⵙⵛⵔⵗⴰ ⵓⴹⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ⵓⵔⴶⵗ ⵓⵏ ⵙⵙⵎⵏⵏ ⵢⵛⵔⵗⴰ ⵗⴹⵏⵏ ⴹⵜ ⵎⵛⵏⴰ ⴾⵍⵔ ⵓⵏ ⵙⵔⵙ ⵜⵎⵤⵍⵏⵏ ⵏ⵿ⵜⵏⵢ ⵤⴶⵔⵓⵏⵏ ⵜⵓⵆⵀⵍ ⴹⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⵓⵔ ⵙⵏⵏ ⴼⵍ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵎⵛⵏ ⵎⵤⵍⵏ ⵓⵏ ⵜⵀⵗⵜⵏⵙⵏ ⵏⵎⵏⴾⵏ ⴹⵛⵔⵗⴰ ⵓⴰ ⵓⵏ ⴹⵢ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵛⵔⵗⴰ ⵢ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ⵙⴾⵏⵏ ⵙⵓⵏ ⵙ ⵎⵤⵍⵏ ⵓⵏ ⵙ ⵎⵔ ⵛⵔⵗⴰ ⴾⵜⵀⵏ ⴹⵗ ⵓⵍⵏⵙⵏ⵰ ⵏⵢⵜⵏⵙⵏ ⴹⵗ ⵜⴶⵢⵜⵏⵜ ⵓⵏ⵰ ⵎⵔⵏ ⴹⴼ ⵓⴰ ⵏⵎⴶⵏ ⴶⵔⵙⵏ ⵙⵗⵜ ⵢⵜ ⵜⵏⵎⵙⵓⵔⵏ ⵙⵔⵙ ⵍⵂⵏ ⵙⵗⵜ ⵢⵜ ⴹⵗ ⴶⵎⵢⵏ ⵙⵔⵙ ⵏⵎⵙⵔⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵓⴰ ⵤⴶⵏ ⵤⵍ ⵓⴹ ⵤⵛⵔⵗ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵤⵍⵏ ⵏⴶⴹⵎ ⵓⵏ ⵗⵀⵔⵏⵏ ⵙⵎⴾ ⵓⵙ ⵜⵏⴰ ⵍⵏ⵿ⵌⵍ ⵓⴰ ⵎⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ⴾⵢ ⵓⴰ ⴶⵏⵏ ⵜⵎⵙⵗ ⴶ ⵍⵢⵂⴹ ⵜⴼⵍⴰ ⴼⵍ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵜⵜⴶⵗ ⵀⵔⴶⵏ ⵙ ⴾⵢ ⵜⵎⵙⵗ ⵎⵔⵢ ⵙ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ⵜⵙⵏⵗ ⵓⴰ ⵔⴰ ⵎⵛⵏⴰ ⵜⵙⵏⵗ ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵍⵎⵈⵙⴹ ⴹ ⵜⵜⵓⵙⵙⵗⵔⴰ ⵛⵔⵗⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ⴾⵢ ⵓⴰ ⴾⵙⵏ ⵛⴾ ⵙ ⵜⵎⵙⵗ ⵎⵍⵓⵢ ⵏⵓⵏ ⴹⵔⵗⵍⵏⵏ ⵜⵎⵙⵗ ⵏⵔ ⵢ ⵓⵏ ⵂⵏⵏ ⵛⵢⵢ ");
INSERT INTO ttqt_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ⵜⵎⵙⵗ ⵎⵙⵙⵗⵔⵢ ⵏⵢⵜⴹⵏ ⵓⵏ ⵏⵀⵏⵏ ⴹⵎⵙⵙⵗⵔⵢ ⵏⵀⵔⵔⵏ ⵜⴶⵗ ⵓⵏ ⴼⵍⵙ ⵜⵏⵢⴰ ⴹⵗ ⵜⵓⵔⵜ ⵎⵙⵏⵜ ⴹⵜⴹⵜ ⴾⵎⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ⵈⵙⵍ ⴾⵢ ⵓⴰ ⵙⵙⵗⵔⵏ ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵔ ⵜⵙⵙⵗⵔⵗ ⵎⵏⴾ⵰ ⴾⵢ ⵓⴰ ⵜⵎⵔⵏ ⵢⵜⴹⵏ ⵙⴹ ⵓⵔ ⴾⵔⵏ ⵎⴼⵍ ⵜⵜⴾⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ⴾⵢ ⵓⴰ ⵜⵎⵔⵏ ⵢⵜⴹⵏ ⵙⴹ ⵓⵔ ⴶⵏ ⵤⵏⴰ ⵎⴼⵍ ⵜⵜⴶⵆⵓ⵰ ⴾⵢ ⵓⴰ ⴾⵢⴹⵏ ⵙⵏⵎⵏ ⵎⴼⵍ ⵜⴶⵍⴰ ⵜⵜⴾⵔⵗ ⵓⴰ ⵂⵏ ⴹⴶⵏ ⵏⵍⵗⵀⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ⴾⵢ ⵓⴰ ⵙⵀⵔⴶⵏ ⴼⵍ ⵛⵔⵗⴰ ⵏⵜⵓⵔⵜ ⵎⵔⵏ ⵜⵜⵎⵤⵔⵢⵆⵓ ⵎⵙ ⵓⵏ ⵀⴰ ⵏ⵿ⵙⴼⵔⵔ ⵏⵙⵎ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","«ⴼⵍⵙ ⵙⵎ ⵏⵎⵛⵏⴰ ⵙⵎⴹⵔⵢⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⵎⵤⵍⵏⵓⵏ ⴹⵓⵢⵏⵏ ⵓⵏ» ⵙⵎⴾ ⵓⵙ ⵜⵎⵍⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ⵍⴾⵏ ⵙ ⵎⵏ⵿ⴾⴹ ⵜⵂⵢ ⵜⵏ⵿ⴼⴰ ⵙ ⵎⵙ ⵙ ⵜⵀⵔⴹⴶⴰ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵎⵛⵏ ⵙ ⵜⵜⵎⵤⵔⵢⵗ ⵛⵔⵗⴰ ⵓⵏ ⵓⴹⵢ ⵎⵏ⵿ⴾⴹⵏⴾ ⵓⵔ ⵤⵍⵢ ⴹⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ⵙ ⵎⵙ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵎⵏ⵿ⴾⴹ ⵍⴾⵎ ⵢⵍⵓⵌⵀⵏ ⵏⵛⵔⵗⴰ ⵀⵔⴹⴶⵙⵏ ⵓⴾ ⵓⵔⴶⵗ ⴹⵙⵜⵓⵈⵙⵀ ⵙ ⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵎⵏ⵿ⴾⴹ ⵎⵔⵏ ⵀⵔⴹⴶ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵏ⵿ⵜⴰ ⴹⴾⵤⵛⵔⵗⵏ ⴾⵢ ⵓⴰ ⵜⴼⵏ ⵜⵓⵔⵜ ⵜⵎⵏ⵿ⴾⴹⴰ ⵜⵜⵎⵤⵔⵢⵆⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ⵔⵜ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⵙ ⵜⵛⵜ ⵏⴶ ⵍⵢⵂⴹ ⵓⵔ ⵜⵎⵙ ⵔⵜ ⵓⵔⵏ ⵤⵂⵔ ⵗⵙ ⵓⵍⴰ ⵎⵏ⵿ⴾⴹ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ⴾⵍⵔ ⵓⴰ ⵂⵏ ⵓⵍ ⵏ⵿ⵜⴰ ⵜⴶⵏ ⵓⴹⵏ ⴶ ⵍⵢⵂⴹ ⵎⵔⵏ ⵎⵏ⵿ⴾⴹ ⵓⴰ ⵜⴶⵏ ⵓⴹⵏ ⴶ ⵍⵢⵂⴹ ⵓⵍ ⴹⵗ ⵜⴶⵓ ⵎⵙ ⵔⵜ ⴹⴼⵍⵏ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵓⵔⴶⵗ ⵔⵜ ⴾⵜⵀⵏ ⵗⵙ ⴹⵗ ⵜⵓⵔⵜ⵰ ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ ⴶ ⵍⵢⵂⴹ ⵓⴰ ⴶⵔⵓⵏ ⵜⵎⵍⵏ ⵛⵏ ⴹⴼⵍⵏⵏ ⵎⵛⵏⴰ ⵓⵔⴶⵗ ⵛⵏ ⴹⴼⵍⵏⵏ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ⴹⵗ ⴹⵢ ⵎⵏⵢ ⵜⵜ ⵍⴼⵢⴹⵜ ⵏ⵿ⵜⵛⵜ ⵏⴶ ⵍⵢⵂⴹ ⵎⴹⵗ ⵎⵏⵢ ⵜⵏ⵿ⴼⴰ ⵏⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ⵜⵏ⵿ⴼⵏⵜ ⵛⵢ ⴶⵜ ⴹⵗ ⵏⵎⴹ ⴾⵍ ⵎⵔⵏ ⵜⴰ ⵤⵓⵔⵜ ⵙ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵏⵢ ⵙ ⴹⴶⴰ ⵎⵛⵏⴰ ⵓⵍⵏⵜ ⴹⵗ ⴼⵙⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ⵜⴹⵜ ⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⵎⵤⵔⵢⵏ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵎⴾⵏ ⵀⴰ ⵏ⵿ⵜⵍⵗⴹⵍⵏⵙⵏ ⴹ ⵜⵙⵎⵜⵢ ⵔⵜ ⴹⵗ ⵜⵍⵗⴹⵍⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ⴾⵍⴰ ⴾⵍⴰ⵰ ⵜⵓⵆⵀⵍⵜ ⵙ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵜⴹⵜ ⴶⴹⵎ ⵏⵙⵀⵂⵓ⵰ ⵜⵛⵜ ⵏⵎⵛⵏⴰ ⵜⴹⵜ ⵏ⵿ⵜⴰ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵜⴶⵔⵓⴰ ⵜⵆⵜ ⴹⵗ ⵓⵍⵏⴾ ⵜⴶⵔⵓⴰ ⵜⴹⵜ ⴹⵗ ⵛⵔⵗⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ⵎⵛⵏ ⵎⴰ ⵤⴰ ⵏⵏⵓ ⵙ ⵎⵙ ⵙ ⵀⴰ ⵏⵆⴹⵏⵏⴰ ⵙⵏⴼⵍⵍⴹⵓ ⵆⴹ ⵏⵎⵛⵏⴰ⵰ ⵓⴾ ⵎⵛⵏⴰ ⵎⵙ ⴼⵍⵙ ⵀⴰ ⵏⵆⴹ ⴹ ⵤⵎⵤⵍ ⵍⵂⵎⵏⵜ⵰ ⵍⴾⵏ ⵙ ⵓⵍ ⵓⴰ ⵜⴶⴰ ⴹⴰ ⵜⴶⵆⵓ ⵙ ⵜⵢⵜⵢ ⵜⵏ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ⴾⵍⴰ ⴾⵍⴰ⵰ ⵎⵛⵏⴰ ⵏⵎⴶⴶ ⴹⴹ ⵎⵙ ⵙ ⵓⵔ ⵗⴹ⵰ ⴾⵏ⵿ⴹⵀⴰ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⵛⵔⵗ ⵢⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵀⵂⵏⵏ ⵙⵏⵂⵍ ⵙⵏⴼⵍⵍ ⵏ⵿ⵜⴹⵜ ⵏⵎⵛⵏⴰ ⵓⵢⴹⵓ ⵓⵏ ⵙ ⵜⵀⵢⵏ ⵜⵏⵢⵏⵜ ⵓⴹⵢ ⵎⴼⵍ ⵜⵜⵓⵈⴾⵎⵢ ⵜⵛⵜ ⵏⵏⵙⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ⵎⴰ ⴾⵎⴰ ⴼⴹⴰ ⵏⵏⴰ «ⵎⵤⵍⵜⵏⴰ ⵜⵍⵀⵙ⵿ⵜ ⴼⵍ ⵜⵜⴹⵜⴶⵎⴹ ⵜⵏ⵿ⴼⴰ⵰» ⵔⵜ ⵙⵏ⵿ⵜⴰ ⵙⵔⵏⴰ ⴶⵏⵏ ⵔⵜ ⵏⵢⵜⴹⵏ ⴶⵎⵢⵏⵏ ⴹⵏⵗⵗⵛⴹⵏ ⵙⵎ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵂⵔⵏ ⴹⴹ ⵜⵔⵎⵙⵏ ⵙⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ⵎⴰ ⵤⴰ⵰ ⵓⴾ ⵏⴾⵏⵢ ⵏ ⴾⵍⵍⵢⵂⴹ ⵜⵍⵢ ⵍⴼⵢⴹⵜ ⵏⴶⵔⵓ ⴹⵏⴶ ⵢⵜⴹⵏ ⵂⵔⵓⴰ ⴹⴰ⵰ ⴾⵍⴰ ⴾⵍⴰ ⴼⵍⵙ ⵏⵌⵓⵔ ⵏⵙⵜⴹⴰ ⵙ ⴾⵜⵏⵏⴰ ⴶⵔ ⵤⴰ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⵙ ⵏⵂⴰ ⵜⵍⴰ ⵏⵀⴾⴹ ");
INSERT INTO ttqt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ⵙⵎⴾ ⵓⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⵔ ⵜⵍⴰ ⵢ ⵗⴹⵏ ⵓⵍⴰ ⵗⵙ ⵢⵏ⵿ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ⵓⵔ ⵜⵍⴰ ⵢ ⴶⵔⵏ ⵓⵔ ⵜⵍⴰ ⵢ ⴶⵎⵢⵏ ⵎⵙⵏⵜ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ⴾⵍ ⵈⵔⴾⵏ ⵎⴾ ⵎⵙⵏ ⴾⵜⵏⵙⵏ ⴾⵏⵏ ⵛⵔ ⵓⵔ ⵜⵏⵂⴰ ⵢ ⵜⴶⵏ ⵓⴰ ⵍⵗⵏ ⵓⵍⴰ ⵗⵙ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ⵛⴶⵔⵙⵜⵏⵙⵏ ⵎⵙⵏⵜ ⵤⵏ ⵜⵙⵙⴾⴰ ⵏⵍⵎⵏⵏ ⵍⵙⵓⵏⵙⵏ ⵜⴾⵔⵙⵏ ⵙⵔⵙⵏ ⵢⵜⴹⵏ ⴹⵍⵢⵏⵙⵏ ⵓⵔ ⵗⵀⵔⵏ ⵔ ⵙⵎ ⵏ⵿ⵜⵛⵍ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ⵎⵓⵏⵙⵏ ⴹⵏⵢⵏ ⵀⵜⵜⵏ ⵙⵎⵎⵏⵏ ⴹⵜⵍⵗⵏ⵿ⵜ ");
INSERT INTO ttqt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ⴹⵔⵏⵙⵏ ⵜⵂⵏ ⵜⴹⵙⵢⵜ ⵏ⵿ⵜⵏⵗⵍⴰ ⵏⵤⵏⵢ ");
INSERT INTO ttqt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ⵂⵍⴾ ⴹⵍⵎⵙⵀⵜ ⵓⵔⵏ ⵜⵔⵢⵜⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ⵓⵔ ⵤⴹⵢⵏ ⵜⵔⵢⵜ ⵜⵏ ⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ⵜⴾⵙⴹⴰ ⵏⵎⵛⵏⴰ ⵓⵔ ⵜⵂⴰ ⵓⵍⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ⵏ⵿ⵜⴰ ⵏⵙⵏ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵏⴰ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵏⵢ ⵢⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⵓ ⵍⵈⴾⵎ ⵓⵏ ⵜⵓⵔⵜ ⴼⵍ ⴹ ⴼⵙ⵿ⵜⵏ ⵎⵓⵏ ⴾⵍ ⵜⵓⵆⵀⵍ ⵙ ⴹⵏⵜ ⴾⵍ ⵀⵤⵜⵜ ⵛⵔⵗⴰ ⵓⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ⴼⵍⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙ ⵤⴰ ⵜⵜⵓⵆⵀⵍ ⵜⵆⵜⵏⵜ ⴹⵜ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵎⵤⵍ ⵏⵓⴰ ⵂⵏ ⵛⵔⵗⴰ ⴼⵍⵙ ⵛⵔⵗⴰ ⵏ⵿ⵜⴰ ⴹⵏⵗⵙⵙⵏⵏ ⵓⴰ ⵎⵙ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ⵎⵛⵏ ⵎⵔⴹⴰ ⵎⵛⵏⴰ ⵙⵏⴼⵍⵍ ⵎⴾ ⵓⵙ ⵤⵆⵀⵍ ⵜⵆⵜⵏⵏⵗ ⴹⴰ ⵓⵍⴰ ⵜⵔⵢⵜ ⵜⵏ ⵛⵔⵗⴰ ⵜⴹⵏ ⴹⵗ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ⵎⵛⵏⴰ ⵆⵀⵍ ⵜⵆⵜ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⴾⵍ ⵆⵀⵍ ⵜⵆⵜⵏⵙⵏ ⴼⵍⵙ ⵢⵜⴹⵏ ⵓⵔ ⵤⵍⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ⴾⵜⵏⵙⵏ ⴶⵏ ⵀⴾⴹⵏ ⵀⴰ ⴼⵍⵙⵏ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ⵎⵔⵏ ⴶⵔⵓⵏ ⵜⵆⵜ ⵜⵎⵙⵜ ⵜⵂⴾⵜ ⵏⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⴹⵔⴼⵜ ⵜⴰ ⴹⵜⵓⵢ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ⵏ⵿ⵜⴰ ⴹⵙⴶⵍⴰ ⵎⵛⵏⴰ ⵈⴾⵎⵙ ⴹ ⵆⵍ ⵜⴾⵜⵢ ⵜⴰ ⵜⵎⵙⵜ ⵀⴾⴹⵏ ⵏⵢⵜⴹⵏ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵙⵤⵏⵏⵜ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵙⴾⵏⴰ ⵎⵛⵏⴰ ⵜⵆⵜⵏⵜ⵰ ⴼⵍⵙ ⵎⵛⵏⴰ ⵢⴰ ⵀⴾⴹⵏ ⴹⴰ ⵓⵔ ⵜⵏⵓⴹⵀ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵔⵓⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ⵏ⵿ⵜⵤⵢⴹⵔ⵿ⵜⵏⵜ ⵎⵔⵏ ⵤⵎⵏ ⵓⵏ ⵎⵔⴹⴰ ⵔⴰ ⴹ ⵙⴾⵏⵓ ⵜⵆⵜⵏⵜ ⵙ ⵜⵎⵓⵜ ⴹⵗ ⵤⵜⵓⵆⵀⵍ ⵙ ⵗⴹ ⴼⵍ ⴹ ⵆⵀⵍ ⵜⵆⵜ ⵏⵓⴹⵏ ⴾⵍ ⵓⴰ ⵤⴶⵤⵏⵏ ⵙ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ⴹⵗ ⴹⵢ ⵓⴾ ⵍⵢ ⴹⵍⵍ ⴼⵍ ⵏⴶⴰ ⵀⵔⴶⵏ⵰ ⴾⵍⴰ ⵓⵔ ⵜⵍⴰ ⴼⵍⵙ ⵓⵔⴶⵗ ⵀⵔⴹⴶ ⵢⵛⵔⵗⴰ ⵛⵗⵍⵏ ⵎⵔⴹⴰ ⴾⵍⵔ ⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ⴼⵍⵙ ⵏⴾⵏⵢ ⵏⴶⴰ ⴹⴼ ⵏⵙ ⵓⴹⵏ ⴶⵔⵓ ⵜⵆⵜ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵓⵔⴶⵗ ⵍⴾⵎ ⵢⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ⵎⵗ ⴾ ⵏⴶⴰ ⴹⴼ ⵏⵙ ⵎⵛⵏⴰ ⴾⵍⵍⵢⵂⴹ ⵗⵙ ⵙ ⵎⵙ ⵎⵍⵏⵙⵏ⵰ ⵓⴾ ⵎⵛⵏⴰ ⵓⵔ ⵎⵙ ⵎⵍⵢ ⵏⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⵓⵍⴰ ⵎⵍⵢ ⵏⵢⵜⴹⵏ ⴾⵍ ⵎⵙ ⵂⵔⴾⴹ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ⴹⴹ ⵤⵎⵙ ⵎⵛⵏⴰ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵓⴹⵢ ⴹ ⵆⵀⵍ ⵜⵆⵜ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⵙⵙⵀⵀ ⵏⵤⴶⵤⵏ ⵆⵀⵍ ⴹⵗ ⵜⵆⵜ ⵏⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ⴹⵗ ⴹⵢ ⵓⵔⴶⵗ ⵎⵙ ⴹⵏⵜⴶⵓ ⵛⵔⵗⴰ ⵏⵜⴶⵓ ⵤⴶⵤⵏ ⴹⵗ ⴹⴶⵏⵜ⵰ ⴾⵍⵔ ⵙⵜⴹⵢ ⵏⵜⴶⵓ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ⵎⴰ ⵤⴰ ⵏⵏⵓ ⴹⵗ ⴹⵢ ⵙⵀⵔⵂⵎ ⵎⵙⵏ ⵎⵔⵓⵏⵏⵗ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵛⵜ ⵏⴶⴹⵎ⵰ ⵎⴰ ⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ⵏⵔ ⵎⵙ ⵙ ⵀⵔⵂⵎ ⵜⵔⵢⵜ ⵏⵎⵤⵍⵏⵜ ⵙ ⴶⵔⵓ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ ⵓⴹⵢ ⵍⴰ ⴹⵍⵍ ⵏⴶⵢ ⵏⵀⵔⴶⵏ⵰ ⵎⵛⵏ ⵓⵔⴶⵗ ⵓⵏ ⴶⵏ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ ⵤⴶⵤⵏ ⵀⵔⵎ ⵙ ⵎⵛⵏⴰ ⵓⵏ ⴹⵗ ⴼⵍ ⵜⴾⴼⴰ ⵎⵛⵏⴰ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ⵓⴹⵏ ⵓⴰ ⵜⴶⵏ ⵎⵤⵍⵏ ⵍⵗⵏⵏ ⵓⴹⵢ ⵍⴾⵏⵜ ⵓⵔ ⴹⵙⵎⵙ ⵜⵏⴼⵙ⵿ⵜ ⴾⵍⵔ ⵍⵈⵆⵏⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ⵓⴹⵏ ⵎⵔⵏ ⵓⴰ ⵓⵔ ⵏⴶⴰ ⵎⵤⵍⵏ ⵍⵗⵏⵏ ⵎⵛⵏ ⵤⴶⵤⵏ ⵙ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵂⴾⵏ ⵜⵆⵜ ⵢ ⵏⵙⵀⴾⴹⵏ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵜⵆⵜ ⵙⵙⵀⵀ ⵏⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ⵎⴾⵏ ⴹⵗ ⵙ ⵏⴰ ⵏⵀⵢ ⴹⵓⴹ ⴹⵗ ⵀⵜⵓ ⵏⵀⵍⵍ ⵏⵓⴹⵏ ⵓⴰ ⴾⴼⴰ ⵎⵛⵏⴰ ⵜⵆⵜ ⴹⴰ ⵓⵍⴰ ⵎⵤⵍⵏⵜ ⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ⵀⵍⵍⵏ ⵓⵏ ⵙ ⵜⵓⵙⵔⴼⵏ ⵔⴾ ⵎⵤⵍⵏⵙⵏ ⵜⵓⵎⵙⵏ ⵀⴾⴹⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ⵀⵍⵍ ⵍⵙ ⵓⴰ ⴼⵍ ⵓⵔ ⵈⵙⵀ ⵎⵛⵏⴰ ⵀⴾⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ⵓⴾ ⵀⵍⵍ ⵓⴰ ⵏ ⴾⵍⵍⵢⵂⴹ ⵗⵙ ⵎⵗ ⴾ ⵏ ⵢⵜⴹⵏ ⴾⵍ ⵂⵔⴾⴹ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⴼⵍⵙ ⵏⴶⵏⵓ ⵤⴶⵤⵏ ⵏⵀⵔⵂⵎ ⴶⵔⵓ ⵙⵔⵙ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ⵓⴾ ⵎⴰ ⴹⵔ ⵍⴰ ⵀⵔⵂⵎ ⵙ ⴶⵔⵓ ⵜⵓⵆⵀⵍ ⵓⵏ ⵗⵔ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵎⵏ⵿ⴾⴹ ⵎⵗ ⵓⵔ ⵎⵏ⵿ⴾⴹ ⵂⵔⵓⴰ⵰ ⴾⵍⵔ ⵂⵔⵓⴰ ⴹⴰ ⴹⵜ ⵎⵏ⵿ⴾⴹⵏⵜ ⴹ ⴶⵔⵓ ⵜⵓⵆⵀⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ⴹⴼⵔ ⵓⵏ ⴹ ⴶⵔⵓ ⵀⵔⵂⵎ ⵗⵔ ⵎⵛⵏⴰ ⵙⵏⵍ ⵓⵏ ⵎⵏ⵿ⴾⴹ ⵎⵙⵏ ⵙⵜⴹⵢ ⵏ⵿ⵜⵆⵜ ⵜⴰ ⴶⵔⵓ ⵙⵤⴶⵤⵏ ⵂⵔⵓⴰ ⴹⵜ ⵎⵏ⵿ⴾⴹⵏⵜ⵰ ⵔⵜ ⵓⵏ ⴶⴰ ⴼⵍ ⴹ ⵆⵍ ⵀⵔⵂⵎ ⵎⵔⵓ ⵏⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙ ⵎⵛⵏⴰ ⴹⴰ ⵓⵔ ⵎⵏ⵿ⴾⴹⵏ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ⵀⵔⵂⵎ ⵎⵙ ⵂⵔⵓⴰ ⴹⴰ ⵀⴰ ⵏⵢⵜⴹⵏ ⵓⵏ ⵎⵏ⵿ⴾⴹⵏⵏ ⵎⵛⵏ ⵓⵔⴶⵗ ⵎⵏ⵿ⴾⴹⵏⵙⵏ ⵗⵙ ⴼⵍ ⴼⵍⵏ ⴾⵍⵔ ⵜⵍⵍ⵿ⵜ ⴶⵏ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵜⴰ ⴶⴰ ⵎⵔⵓⵏⵏⵗ ⵀⵔⵂⵎ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ⵎⵛⵏⴰ ⴶⴰ ⵔⴾⵓⵍ ⵢⵀⵔⵂⵎ ⴹⵂⵢⵓⵏⵜ ⵙ ⴹ ⴶⵔⵓⵏ ⴹⵏⵜ⵰ ⵔⴾⵓⵍ ⵓⵏ ⵓⵔ ⵜⵓⴶⴰ ⵢⵀⵔⵂⵎ ⴼⵍ ⵍⴾⵎⵏⵜ ⵢⵛⵔⵗⴰ ⴾⵍⵔ ⴶⵙ⵿ⵜⵓ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵆⵜ ⵜⵜⴾⴼⵜ ⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ⵙ ⵎⵙ ⵙ ⵜⵔⵢⵜ ⵏⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵙ ⵤⴶⵔⵓⵏ ⵢⵜⴹⵏ ⵔⴾⵓⵍ ⵓⵏ ⵓⴹⵢ ⵤⴶⵤⵏ ⵓⵔ ⵍⴰ ⵜⵔⵏⴰ ⵓⵍⵢⵜ ⵔⴾⵓⵍ ⵓⵏ ⴹⵗ ⴹ ⵀⵙ ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ⴼⵍⵙ ⵛⵔⵗⴰ ⵜⵓⵢⴹⵓ ⵜⵎⵤⵔⵢⵜ ⴹ ⵓⵔ ⵏⴼⵔⴶ ⵜⴹⵏⵙⵏ⵿ⴹⵓ ⵜⵎⵤⵔⵢⵜ ⵎⵔⵏ ⵜⵜⵓⵢⴹⵓ ⵍⵂⵎ⵰ ⵎⵔⵏ ⴹⴶ ⵓⴰ ⵓⵔ ⵂⴰ ⵛⵔⵗⴰ ⵓⴹⵢ ⵓⵔ ⵜⵤⵜⴶⵤ ⵜⵎⵤⵔⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ⵏ⵿ⵜⴰ ⴹⵏ ⴹⵗ ⴹⵍⵍ ⵓⴰ ⴼⵍⵙ ⵔⴾⵓⵍ ⵓⵏ ⴹ ⵜⵓⴶⵔⵓ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⴼⵍ ⴹ ⵆⵍ ⵜⵂⴾⵜ ⵜⵎⵙⵜ ⵔⵈⵎⵜ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵔⴾⵓⵍ ⵓⵏ ⵜⴹⴰ ⵢⵤⵔⵢⴰ ⵏⵀⵔⵂⵎ ⴾⵜⵏⵜ ⵍⵎⵗⵏⴰ ⵓⵔⴶⵗ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⵛⵔⵗⴰ ⵗⵙ ⴾⵍⵔ ⵂⵔⴾⴹ ⵓⵏ ⵀⵤⵏⵏ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵜⵏ ⵀⵔⵂⵎ ⵎⵙⵏ ⵀⵏⵏⴰ ⴾⵜⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ⵓⵏ ⴹⴰ ⵂⵏ ⵍⴾⵜⵀⵏ ⴹ ⵏⵏ «ⴶⵆⵢ ⵎⵔⵓ ⵏ⵿ⵜⵎⵜⵓⵏ ⴾⵏⵏⵏ ⴶⵜ⵰» ⵎⵙ ⵀⵏⵏⴰ ⴾⵜⵏⵏⴰ ⴹⵜ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵙ ⵤⴶⵤⵏ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵢ ⵓⵏ ⵀⴰ ⵈⵍⴾⴹⵓ ⵓⴰ ⵜⵓⵔⵏⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ⵀⵔⵂⵎ ⴶⵤ ⵍⵈⵍⵜ ⴹⵗⵙ ⵜⵓⵔⵍⴰ ⵜⵎⴰ ⵓⵍⵢⵏ ⵎⵛⵏ ⵤⴶⵤⵏ ⴶⴰ ⵜⵎⵏⵜ ⴹⵗ ⵎⵛⵏⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵆⵍ ⵀⴰ ⵏ⵿ⵜⵎⵜⵓⵏ ⴾⵏⵏⵏ ⴶⵜ ⵙⵎⴾ ⵓⵙ ⴹⵙⵜⵓⵏⴰ «ⵓⵏ ⴹⵗ ⴹⵔ ⵤⴶⴹⵏ ⵂⵢⵓⵏⴾ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ⵓⵔ ⴹⵙ ⵓⵍⴰ ⵤⴶⵤⵏ ⵏⵀⵔⵂⵎ ⴾⴹⵗ ⵙ ⵙⵏ ⵙ ⵜⵗⵙⵏⵜ ⵤⵏ ⵙ ⵜⵎⵜ ⴼⵍⵙ ⵤⵢⵏ ⵜⵎⴹⵢ ⵏⵓⵜⵢ ⵙⵔⵜⴰ ⴹⵗ ⵜⵓⵛⵔ ⵜⴶⴶⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ⵀⵔⵂⵎ ⵓⵔ ⴶⴰ ⵛⴾ ⴹⵗ ⵔⴾⵓⵍ ⵏⵎⵛⵏⴰ ⵤⵏ ⵓⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⴾⵍⵔ ⵙⵙⵂⵜⵓ ⵤⴶⵤⵏⵜ ⵙⵗⵎⵔ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ⵙⵏⵂⵍ ⴾⵙ ⵏⵛⴾ ⵙ ⵎⵛⵏⴰ ⵍⴰ ⵜⵔⵏⴰ ⵏⴹ ⵙⵏ⵿ⴹⵓ ⵔⵜ ⵓⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ⵓⵏ ⴹⵗ ⴼⵍ «ⴹⵙⵜⵓⵈⵙⵀ ⵓⵏ ⵙ ⵜⵛⵜ ⵏⵓⴹⵏ ⵗⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ⵎⵛⵏ ⵓⵔⴶⵗ ⴹⵍⵍⵏⵜ ⵏ⵿ⵜⴰ ⵗⵙ ⴼⵍ ⵜⵓⴾⵜⵀ ⵙ «ⵜⵓⵈⵙⵀⵙ ⵓⵏ» ");
INSERT INTO ttqt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ⴾⵍⵔ ⵏⴾⵏⵢ ⴹⴰ ⵜⵓⴾⵜⵀ ⴼⵍ ⴹⵍⵍⵏⵏⴰ ⵎⵔⵏ ⵎⵛⵏⴰ ⵏⴾⵏⵢ ⴹⴰ ⴹ ⵈⵙⵀ ⵜⵆⵜⵏⵏⴰ⵰ ⵏⴾⵏⵢ ⵤⴶⵤⵏ ⵙⵔⵙ ⵏⴶⴰ ⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ");
INSERT INTO ttqt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ⵙⵏ⵿ⵜⴰ ⵜⵓⴾⴼⵏ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵏⴰ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ⴹⵗ ⴹⵢ ⵙ ⵏⴶⵔⵓ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ ⵙⵤⴶⵤⵏⵏⴰ ⵓⴹⵢ ⵏⴶⵔⵓ ⵍⵈⵔ ⴶⵔⵏⵗ ⴹⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵙ ⵏⴶⵔⵓ ⵔⵈⵎⵜ ⵙ ⵙⵀⵀ ⵏⵤⴶⵤⵏⵏⴰ⵰ ⵔⵈⵎⵜⵏ ⵏ⵿ⵜⴰ ⴼⵍⵏⵏⴰ⵰ ⵏⴹⵓⵜ ⵎⵔⵏ ⵜⵎⴰ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵀⵔⴶⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ⴹⵏⴶ ⵓⵏ ⴼⴹⴰ ⵏⵙⵀⵔⴶ ⴾⴹ ⵏⵂⴰ ⵜⵙⵙ⵿ⵜ ⴼⵍⵙ ⵏⵙⵏ ⵙ ⵜⵙⵙ⵿ⵜ ⵏ⵿ⵜⴰ ⴹⵜⵜⵓⵢⵜ ⵤⵎⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ⵤⵎⵔⵜ ⵜⵏ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵏⵜⵂⴾⵜ ⵜⵛⵜ ⵏⵢⵜⴹⵏ ⵍⵏⵏ ⵍⵎⵗⵏⴰ ⵎⵔⵏ ⵙ ⵏⵆⵍ ⵢⵜⴹⵏ ⵍⵏⵏ ⵍⵎⵗⵏⴰ ⵓⵔ ⵤⴰ ⵏⵎⵤⵢ ⴹⴶⵢ ⵏⵜⵎⴰ ⴹⵗ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ⵎⵛⵏⴰ ⵎⵔⵏ ⵓⵔ ⵙⵔⵎⴶ ⵢ ⴹⵗⵙ ⴶⵏ ⵜⵎⴰ ⴹ ⵜⵔⵏⵜ ⵜⴹⵏⵢⵜ ⵓⵍⵏⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴰ ⴹⵏⵗⵜⵓⴾⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ⴼⵍⵙ ⵂⵔⵓⴰ ⴹⵏⵗⵓⵔ⵿ⵜⵆⵍ ⵍⴼⵢⴹⵜ ⵓⵍⵢⵜ ⴹ ⵎⵜ ⵍⵎⵙⵈ ⴼⵍ ⴹⵍⵍ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙ ⵎⵛⵏⴰ ⴹⵗ ⵍⵓⵆ ⵓⴰ ⵙⴾⵜ ⵎⵛⵏⴰ ⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ⵤⵓⵜ ⵢ ⵤⵆⵀⵍⵏ ⴹ ⵜⵀⴰ ⴾⴹⵗ ⴼⵍ ⴹⵍⵍ ⵏⵓⴹⵏ ⵗⴹⵏ⵰ ⵎⵌⵙ ⴼⵔⴶ ⵓⴹⵏ ⴹ ⵆⵀⵍ ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⵓⴹⵏ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ⵎⵛⵏ ⵎⴾ ⴹⴰ ⵓⵙ ⴹⵏⵗⵙⴾⵏⴰ ⵎⵛⵏⴰ ⵜⵔⴰ ⵜⴰ ⴹⵏⵗⴶⴰ ⵂⵔⵓⴹⴰ ⵏⵎⵙ ⵏⵙⵀⴾⴹⵏ ⴹ ⵀⴰ ⵍⵎⵙⵈ ⴼⵍ ⴹⵍⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ⴹⴹ ⵤⵎⵙ ⵎⵔⴹⴰ ⵏⴶⵔⵓ ⵜⵆⵜ ⵙ ⵜⵔⵢⵜ ⵏⵤⵏⵢ ⵏⵍⵎⵙⵈ ⵎⵏⵎⴾ ⵙ ⴹⵏⵗ ⵓⵔ ⵤⵙⴼⵙⵓ ⴹⵗ ⵍⵂⵎ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ⴼⵍⵙ ⴹⴹ ⵤⵎⵙ ⵂⵔⵓⴰ ⵏⵎⵙ ⵤⵏ⵿ⴶⴰ ⵏⵎⵛⵏⴰ ⴹⴰ ⵏⴶⴰ ⴹⵔⵙ ⵍⵈⵔ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵏⵀⵔⵔⵏⵜ ⵎⵏⵎⴾ ⵙ ⵓⵔ ⵤⴰ ⵏⴶⵔⵓ ⴼⵙⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵎⴹⵔ⵿ⵜ ⵏⵀⵔⵔⵏⵜ ⵎⵔⴹⴰ ⴹⵔⵙ ⵏⴶⴰ ⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ⵎⵔⵏ ⵢⵏ ⵔⵜ ⵙ ⵎⵛⵏⴰ ⴼⵍ ⵏⵙⴼⵍⴰ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵙⵏ⵿ⵜⴰ ⴹⵏⵗⴶⵏ ⵎⵔⴹⴰ ⵍⵈⵔ ⴹⵎⵛⵏⴰ⵰ ⵏ⵿ⵜⴰ ⴹⵏ ⴹⵗ ⵀⵔⴶⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ⵎⴰ ⵜⵙⴾⴰ ⵤⴰ ⵀⵜⵓ ⵜⵏ⵰ ⴹⵢ ⵤⴰ ⵙ ⵜⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵙ ⴹⴶⵤ ⵀⴾⴹ ⴹⵏⵜ ⵀⴾⴹ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵓⵢⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵎⵜⵏ⵿ⵜ ⵜⵍⵢ ⵢⵢⵜⴹⵏ ⴾⵍ ⴼⵍⵙ ⴾⵜⵏⵙⵏ ⴶⵏ ⵀⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ⵏ⵿ⵜⴰ ⵀⴾⴹ ⵍⵢ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵛⵔⵗⵏⵜ ⴼⵍ ⵏⵀⵢ ⵎⵙⴰ ⵎⵔⵏ ⵀⴾⴹ ⵓⵔ ⵈⵙⵀ ⵙ ⵜⵓⵔⵍⴰ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⵎⵜⵏ⵿ⵜ ⵜⵍⵢ ⵜⵈⴾⵎ ⴹⵗ ⴹⵏⵜ ⴹⵀⵤⵏ ⵗⵔ ⴹⵎ ⵂⵔ ⵎⵙⴰ⵰ ⵜⵍⵢ ⵂⵔⴾⴹ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⴶⴰ ⵀⴾⴹ ⵍⵏ ⴹ ⵓⵏ ⴹⵎ ⵙⵏ⵿ⵜⴰ ⵂⵏ ⵍⵎⵜⵍ ⵏⵓⴰ ⴹⵤⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ⵎⵛⵏ ⵜⵎⵤⵔⵢⵜ ⵏⴹⵎ ⵓⵔ ⵜⵍⴰ ⴹⵜⵂⴾⵜ ⵜⴰ ⴹⵏⵗⴶⴰ ⵎⵛⵏⴰ ⵙⵔⵈⵎⵜⵏⵜ⵰ ⵜⴹⵜ ⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵀⵜⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵎⵤⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⴹⵎ⵰ ⵎⴰ ⴹⵔ ⴶⴹⴰ ⴶⵜ ⵏⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵜ ⵜⵂⴾⵜⵏⵜ ⵜⴰ ⴹⵜⵙⵜ ⵙ ⵜⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵔⵈⵎⵜ ⵜⵏ ⴹⵜⵂⴾⵜ ⵜⵏ ⵓⵔ ⵍⵏⵜ ⴹⴾⴹ ⵎⵔⵏ ⵓⴹⵏⵜⵏ ⵢⵜⴹⵏ ⴾⵏⵏⵏ ⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ⵓⴰ ⴹⵜⵜⵓⵢ ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ ⵓⵔ ⵍⴰ ⴹⵓⴰ ⴹⵓⵢ ⵀⴾⴹ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ⵰ ⴹⴼⵔ ⵀⴾⴹ ⵓⴰ ⴶⴰ ⴹⵎ ⵎⵛⵏⴰ ⵓⴹⵀ ⵙⵛⵔⵗⵏⵜ ⵢⵜⴹⵏ ⴾⵍ⵰ ⵜⵂⴾⵜ ⵎⵔⵏ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ ⵜⵆⵜ ⵙ ⵜⵜⵓⵢ ⵢⵜⴹⵏ ⵎⵔⵏ ⵜⵙⴹⵓ ⴹⴼⵔ ⵙ ⴶⵏ ⵢⵜⴹⵏ ⵜⵎⵤⵔⵢⵜ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ⵍⴾⵏ ⵙ ⵜⵎⵤⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⴹⵜⵓⵢⵜ ⵙ ⵜⵈⴾⵎ ⵜⵎⵜⵏ⵿ⵜ ⴹⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵓⵏ⵰ ⵎⵛⵏ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵗⵙⵏⵜ ⴶⵔⵓⵏ ⵢⵜⴹⵏ ⴶⵔⵏ ⵓⵏ ⵓⵍⵏ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓⵏⵏ ⵔⵈⵎⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⴹⵜⵂⴾⵜⵏⵜ ⵜⵂⴾⵜ ⵜⵆⵜ ⵓⵏ ⴹⵢ ⴹ ⴹⵔⵏ ⵈⴾⵎⵏ ⴹⵗ ⵙ ⵜⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ⴹⵗ ⴹⵢ ⴾⴹ ⵜⵎⵤⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵓⵢⴹⵓ ⵜⴹⵀ ⵙⵢⵜⴹⵏ ⴾⵍ ⵓⴹⵢ ⵢⵜⴹⵏ ⴾⵍ ⴹ ⴶⵔⵓⵏ ⵜⵆⵜ ⵜⵂⴾⵜ ⵜⵎⴹⵔ⵿ⵜ ⵙ ⵜⵔⵢⵜ ⵏⵎⵤⵍ ⵗⴹⵏ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ⵰ ⵎⵤⵍ ⵓⵏ ⵜⵎⵜⵏ⵿ⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵜⵎⵤⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵓⵢⴹⵓ ⵙ ⵆⵍⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏⵙⵀⴾⴹⵏ ⵎⴾⵏ ⴹⵗ ⵙ ⵀⵔⴹⴶ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⴹⵤⵓⵢⵏ ⵙⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹ ⴶⵔⵓⵏ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ⵛⵔⵗⴰ ⵎⵔⵏ ⵙⴹⵓ ⴼⵍ ⴹ ⵜⵜⵢ ⵜⵎⵤⵔⵢⵜ ⵓⵍⵏ⵰ ⵎⵛⵏ ⵀⴾⴹⵏ ⵙ ⴶⵜⵏ ⴹⵗ ⴹⴶ ⴹⵏⴶⵙⵏ ⴹⵜⵙⴼⵍ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⵀⴾⴹ ⵈⴾⵎ ⴼⵍ ⴹⵏⵜ ⴹⵓ ⴹⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⴹⴰ ⴹ ⵜⵈⴾⵎ ⵜⴹⵓ ⴹⵜⵆⵜ ⴼⵍ ⴹⵏⵗⵜⴾⴼⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ⵎⴰ ⵤⴰ ⵏⵏⵓ ⴹⵗ ⴹⵢ⵰ ⵓⴾ ⴹ ⵏⴶⵍⵓ ⴹⵗ ⴶⵢ ⵏⵀⴾⴹⵏ ⴼⵍ ⴹ ⵜⵜⵢ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ⴾⵍⴰ ⴾⵍⴰ⵰ ⵏⴾⵏⵢ ⵓⵏ ⴶⵏⵏ ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⴹⵏⵜⵤⵎⵤⵢⵜ ⴹⵀⴾⴹⵏ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵏⴶⵍⵓ ⴹⵗ ⴶⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ⵏⴾⵏⵢ ⴾⵜⵏⵏⵗ ⵎⴾ ⵏⵎⵙ ⵙ ⵏⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵙⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵓⴾ ⵜⵜⵓⵜ ⴹⵏ⵿ⵜⴶⵎ ⵙ ⵏⵔ⵿ⵜⵢ ⴹⵔⵙ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ⴹⵗ ⴹⵢ ⵜⵎⵜⵏ⵿ⵜ ⵏⴶⴰ ⵏⵜⵓⵏⵀⵍⵏ ⵏⵔ⵿ⵜⵢ ⴹⵍⵎⵙⵈ ⵙⵍⵎⵗ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵎⵏ ⵙⵙⵎⵏⵜ⵰ ⵓⵏ ⴹⵗ ⵙ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⴹⵏ⵿ⴾⵔ ⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵏⵢⴰ ⵏⵀⵏⵏⴰ ⵎⴾⵏ ⴹⵗ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⴹ ⵏⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ⴹⴹ ⵤⵎⵙ ⵏⵔ⵿ⵜⵢ ⴹⵔⵙ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⵍⵜ ⴹⵜⵏⵜ ⵓⴹⵢ ⴹⵔⵙ ⵏⵔ⵿ⵜⵢ ⵙ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⵍⵜ ⴹⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ⵏⵙⵏ ⴹⵗ ⴹⵢ ⵙ ⴶⴹⵎ ⵓⵙ ⴾⵍⴰ ⵜⵏⵎⵙ ⵓⴹⵢ ⵜⵓⵜⵢⵜⵢ ⴼⵍ ⵜⴶⵜⵓⵜ ⴹⵓ ⴹⵍⵎⵙⵈ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵎⵙ⵿ⵜⵏⵏⴰ ⵜⴰ ⵜⵔⵓⵜ ⵏ⵿ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ ⵜⵂⵍⴾ ⵀⵙ ⵜⵜⵍⴰ ⵏⴾⵏⵢ ⴹⵗ ⵏⵎⵤⵢ ⴹⴾⵍⵓ ⵜⵎⵙⵏ ⵜⵛⵜ ⵏⵙⵀⴾⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵀⴰ ⵓⴹⵢ ⴹⵔⴼⴰ ⴹⵗ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ⵏⴾⵏⵢ ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⵀⵏⴰ ⵏⴹⵓ ⴹⵍⵎⵙⵈ ⵓⴹⵢ ⵏⵤⴶⵤⵏ ⵙ ⴹⵔⵙ ⵏⴹⵓ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ⴹ ⵏⵙⵏ ⵙ ⵍⵎⵙⵈ ⵓⵔ ⵜⵤⵀⴰ ⴹⴼⵔ ⵜⵏⴾⵔⴰ ⵜⴰ ⴹⴶⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵀⵙ ⴼⵍⵙ ⵜⵍⴰ ⵜⵎⵜⵏ⵿ⵜ ⵜⵔⵏⴰ ⵓⵍⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ⴼⵍⵙ ⵀⵜⵓ ⵎⵔⵏ ⴹⵍⵍ ⵏⵀⴾⴹ ⴼⵍ ⵜⵀⴰ ⴹⵗ ⵜⴾⵍⵜ ⵢⴹⴰ⵰ ⵎⵔⴹⴰ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⴶⴰ ⵎⵛⵏⴰ ⵙ ⵜⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⴹⴰ ⴶⵓⵜ ⵢ ⵎⵏⵓⵏ ⴹⴼ ⵏⵙ ⵀⴾⵓⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ ⵀⴾⴹ ⵜⴶⵎ ⴹⵗ ⴹⴼ ⵏⵙ ⵜⴹⵔⵎ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵍⵙ ⵀⴾⴹ ⵈⴾⵎ ⴼⵍ ⵜⵗⵙⵓⵏⵓⵏ ⵎⵙⵏⵏ ⵔⵜ ⵜⵎⵜⵏ ⵓⵍⴰ ⵜⵍⴾⵎⵎ ⵢⵔⴾ ⴹⵔⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ⴹ ⵓⵔ ⵜⵜⵢⵎ ⵛⵙⵍⴹⵏⵓⵏ ⵢⵀⴾⴹ ⵆⵍⵏⵜ ⵤⵏ ⵜⵤⵍⵢ ⵙ ⵜⵜⵓⵎⵤⵍ ⵜⴾⵎⴰ⵰ ⴾⵍⵔ ⴾⴼⵓⵜ ⵎⵏⵓⵏ ⵢ ⵎⵛⵏⴰ ⵜⵆⵍⵎ ⵤⵏ ⵢⵜⴹⵏ ⵀⴰ ⴹⵏ⵿ⴾⵔⵏⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⴾⴼⵎ ⵛⵙⵍⴹⵏⵓⵏ ⵢ ⵎⵛⵏⴰ ⴹ ⵆⵍⵏⵜ ⵜⵤⵍⵢ ⵜⵜⵎⵤⵍⵜ ⵓⴰ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ⴼⵍⵙ ⵀⵙ ⵜⵂⵎ ⵜⵍⴰ ⵏⵀⴾⴹ ⴹ ⵀⵙ ⵜⵂⵎ ⵜⵗⵎⵔ ⵜⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴾⵍⵔ ⵜⴶⵤⵎ ⵜⵗⵎⵔ ⵜⵏ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ⵎⴰ ⵤⴰ ⵏⴶⵓ ⵤⴰ⵰ ⵓⴾ ⴹ ⵏⴶⵓ ⵀⴾⴹⵏ ⴼⵍⵙ ⵏⴾⵢⴹⵓ ⵤⵎⵏ ⵓⵏ ⵛⵔⵗⴰ ⵏⴶⵤ ⵓⵏ ⵔⵈⵎⵜ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ⵓⴾ ⵓⵔ ⵜⵙⵏⵗ ⵙ ⵙ ⵜⴶⵗ ⵎⵏⴾ ⴾⵍⵢ ⵏⵓⴹⵏ ⵜⵀⵔⴹⴶⵗⵙ ⵓⴹⵢ ⴾⵢ ⵜⵆⵍⵗ ⴾⵍⵢ ⵏⵓⴹⵏ ⵓⵏ⵰ ⴹⵗ ⴹⵢ ⵓⴰ ⵗⵙ ⵜⵆⵍⵗ ⴾⵍⵢ ⵏⵀⴾⴹ ⵜⵓⵢⵏ ⵙ ⵜⵎⵜⵏ⵿ⵜ ⵓⴰ ⵜⵆⵍⵗ ⴾⵍⵢ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ ⵀⵔⴹⴶ ⵢ ⵎⵛⵏⴰ ⵜⵜⵓⵢⵜ ⵙ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ⵎⵛⵏ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ⵰ ⴹⴼⵔ ⵙ ⴾⵍⴰ ⵜⵎⵙⵎ ⴾⵍⵏ ⵏⵀⴾⴹ ⵎⵔⴹⴰ ⵜⵀⵔⴹⴶⵎ ⴹⵗ ⵓⵍⵏⵓⵏ ⵢⵛⵔⴹⵏ ⵏⵙⵙⵗⵔⵢ ⵓⴰ ⵜⵜⵓⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ⵜⴹⵔⴼⵎ ⴹⵗ ⵀⴾⴹⵏ ⵜⵆⵍⵎ ⵎⵔⴹⴰ ⴾⵍⵏ ⵏⵓⴰ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ⵍⵎⵜⵍ ⵓⴰ ⵜⴶⵆⵓ ⵙⵏⵎⴹ ⵓⵏ ⴶⴹⵎ ⴼⵍ ⴹⵍⵍ ⵏⵔⴾⵎⵏⵓⵏ ⴹⵔ ⴹⵜⵈⵍⴾⵎ⵰ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⴾⵍⴰ ⴹ ⵜⵙⵎⵍⴾⵓⵎ ⵛⵙⵍⴹⵏⵓⵏ ⵜⵎⵙⵎ ⴾⵍⵏ ⵏⵓⴰ ⵎⴹⵙⵏ ⴹⵓⴰ ⵈⵔⵎⵏ ⴼⵍ ⴹ ⵜⵓⴹⵎ ⵜⵈⵔⵎ⵿ⵜ ⴾⵜⵏⵜ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵎⵔⴹⴰ ⴾⴼⵓⵜ ⵛⵙⵍⴹⵏⵓⵏ ⵢⴹ ⵜⵆⵍⵎ ⴾⵍⵏ ⵏⵓⴰ ⵗⴹⵏ ⴼⵍ ⴹ ⵜⵓⴹⵎ ⵜⵤⴹⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ⴼⵍⵙ ⵙⵗⴰ ⵓⴹ ⵜⵎⵙⵎ ⴾⵍⵏ ⵏⵀⴾⴹ ⴹⵢ ⵜⴹⵔⴼⵎ ⴹⵗ ⵏⵎⴹ ⵓⵏ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ⵎⴰ ⴹⵔ ⵍⴰ ⵓⴰ ⴹⵜⵙⵈⵙⵍⵎ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹⵢ⵰ ⵏ⵿ⴶⵎ ⵔⵜⵏ ⵙ ⵎⵔⴹⴰ ⵙⴾⵔⴾⴹⵏ⵿ⴾⵓⵏ ⴼⵍⵙ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵙⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ⵎⵛⵏ ⵎⵔⴹⴰ ⴹⴹ ⵤⵎⵙ ⵜⴹⵔⴼⵎ ⴹⵗ ⵀⴾⴹⵏ ⵜⵆⵍⵎ ⴾⵍⵏ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⵜⵤⴹⴾ ⴹⵤⵜⵙⵈⵙⵍⵎ ⵎⵔⵏ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ⴼⵍⵙ ⵔⵤⵎⵜⵏ ⵏⵀⴾⴹ ⵜⵎⵜⵏ⵿ⵜ ⵎⵛⵏ ⵜⵂⴾⵜ ⵜⴰ ⴹⵏⵗⵙⵏ⵿ⵙⴰ ⵎⵛⵏⴰ ⵜⵎⵙ ⵔⵈⵎⵜⵏⵜ ⵜⵎⴹⵔ⵿ⵜ ⵜⵜⵎⵙⵏ ⵜⴰ ⵜⵗⵍⵍⵜ ⴹⵗ ⵜⵙⵆ ⴹⵎⵍⵏⵏⴰ ⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⵙ ⵛⵔⵗⴰ ⵓⵔ ⵍⵤⵎ ⵔ ⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵏⵏ⵰ ⵙⵏⵗ ⵙ ⵂⵏ⵿ⴾⵓⵏ ⵙⵍⵏ ⵏⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵏ⵿ⵜⵜ ⵜⵤⵍⴼⵜ ⴾⵜ ⴹⵔ ⵍⵙⵏⵜ ⵙⵆⵜ ⴹⵔⵙ ⵛⵔⵗⴰ⵰ ⵎⵛⵏ ⵙ ⵀⴰ ⵍⵙⵏⵜ ⴹ ⵜⴹⴼⵔ⵿ⵜ ⴹⵗ ⵛⵔⵗⴰ ⵓⵙ ⴾⵍⴰ ⵜⵏⵙⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ⴹⵗ ⴹⵢ ⵙ ⵎⵙ ⵙ ⵂⵔⵓⴰ ⴹ ⴹⵔ ⵍⵙⵏⵜ ⵜⵜⵤⵍⴼ ⵍⵙ ⵢⵏ ⵓⴹⵢ ⵤⵏⴰ ⵜⴶⴰ ⵎⵛⵏ ⵙ ⵀⴰ ⵍⵙⵏⵜ ⵓⴹⵢ ⵜⴹⵔⴼⴰ ⴹⵗ ⵛⵔⵗⴰ⵰ ⴹⵢ ⴾⴹ ⵜⵜⵤⵍⴼ ⵍⵙ ⵢⵏ ⴹⴰ ⵓⵔ ⵤⵜⵓⵏⵓ ⵜⴶⴰ ⵤⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ⵎⴾⵏ ⴹⴰ ⵜⵎⵙⵎ ⴾⵓⵏⵢ ⴹⴰ ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⴾⵓⵏⵢ ⴹⴰ ⵀⴾⵓⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ⵰ ⵎⵔⴹⴰ ⵜⵂⵎ ⵜⵍⴰ ⵢⵜ ⵜⵢⵏⵢⵜ ⵜⵜⵎⵙⵏ ⵜⵏ ⵓⴰ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵏⵎⵜⵏ ⴼⵍ ⴹⵏⵙⵈⵙⵍ ⵜⵏ⵿ⴼⴰ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ⵂⵔⵓⴰ ⴹ ⵏⵍⴾⵎ ⵢ ⴹⵔⵏⵏ ⵏⵓⵍⵏⵏⴰ ⵂⵏⵏⵗ ⵔⴾ ⴹⵔⵏⵏ ⵓⵏ ⴹⵜⵓⵢ ⵛⵔⵗⴰ ⵜⴼⵏ ⵜⵏⵜ ⵏ⵿ⵜⵙⵍⴹⵏⵏⴰ ⴼⵍ ⴹⵏⵙⵈⵙⵍ ⵔⵜⵏ ⵓⵏ ⵜⵓⵢⵏⵏ ⵙ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ⵎⵛⵏ ⵎⵔⴹⴰ ⵏⴹⵔⴼⴰ ⴹⵗ ⵍⵈⴾⵎ ⵓⵏ ⵛⵔⵗⴰ ⵀⵏⴰ ⴹⵗ ⵀⵜⵓ ⵏⵔⵜⵏ ⵓⵏ ⴹⵏⵗⴶⵏⵏ ⴹⵗ ⵜⵍⴰ⵰ ⴹⵗ ⴹⵢ ⵏⴼⵔⴶ ⴹ ⵏⵗⵀⴹ ⵎⵛⵏⴰ ⵙ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔⴶⵗ ⵙⵏⵎⴹ ⵓⴰ ⵔⵓⵏ ⵏⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵎⵙⵏ ⵔⵜ ⴶⵎⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ⵎⴰ ⵤⴰ ⵏⵏⵓ ⴹⵗ ⴹⵢ⵰ ⵓⴾ ⵛⵔⵗⴰ ⵎⵜⵍⴰ ⴹⵀⴾⴹ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵎⵛⵏ ⵢⴰ ⵛⵔⵗⴰ ⵏ⵿ⵜⴰ ⴹⵤⵤⴹⵢⵏ ⵀⴾⴹ ⴹ ⵏⵔ ⵓⵔ ⵏⴰ ⵛⵔⵗⴰ «ⴹ ⵓⵔ ⵜⴶⵗ ⵜⵎⵏⴾ ⴹⵗ ⵔⵙ ⵏⵓⴹⵏ⵰» ⵓⵔ ⵤⵙⵏⵗ ⵓⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⴶⵢ ⵏⵜⵎⴰ ⴹⵗ ⵔⵙ ⵏⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ⵎⴾⵏ ⴹⵗ ⵙ ⵙⵍⵎ ⵀⴾⴹ ⴹⵓ ⵍⵓⵌⵀⵏ ⵜⵤⵔ ⴶⴹⵓ ⴹⵗ ⵓⵍⵏ ⵔⴾ ⴹⵔⵏⵏ ⵙ ⵜⵓⵔⵍⴰ ⴹⵗ ⵓⵔ ⴶⵏ⵰ ⴼⵍⵙ ⵙ ⵜⵓⵔⵍⴰ ⵛⵔⵗⴰ ⵓⴹⵢ ⵀⴾⴹ ⴹⴰ ⵤⵏ ⵙ ⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ⴹⵜ ⵓⴰ ⵂⵔⵓⴰ ⵜⵓⵔⵍⴰ ⵛⵔⵗⴰ ⵏⴾ ⴹⵔⴰ⵰ ⵎⵛⵏ ⵙⵗⴰ ⵓⴰ ⴹⵙⵏ ⵍⵓⵌⵀⵏ ⵏ⵿ⵜⴰ ⴹ ⵆⵍ ⵀⴾⴹ ⵔⵜ ⴹⵔⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ⵏⴾ ⵎⵔⵏ ⵀⵢ⵰ ⵍⵓⵌⵀⵏ ⵓⵏ ⵙ ⵂⵔⵏ ⵙ ⵜⵎⴹⵔ⵿ⵜ ⵙ ⵜⵓⵢⵏ ⵏⴾ ⵜⵎⵜⵏ⵿ⵜ ⵙ ⴹⵓⵢⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ⴼⵍⵙ ⵀⴾⴹ ⵙⵍⵎⵏ ⴹⵓ ⵍⵓⵌⵀ ⵏⵛⵔⵗⴰ ⵙⵈⵔⴾⵢ ⵏ⵿ⵗⵢ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ⴹⵗ ⴹⵢ ⵛⵔⵗⴰ ⵢ ⵤⴹⴶⵏ ⵍⵓⵌⵀ ⴹⵗ ⵤⴹⴶ ⵗⴹ ⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ⵓⴾ ⵏⴾ ⵔⵜ ⵍⵗⵏ ⴹⵆⵍⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵀⴾⴹ ⵎⵙⵏ ⵙⵀⵀ ⵏⵓⵏ ⴾⵍ⵰ ⴹⵗ ⴹⵢ ⵀⴾⴹ ⵙⵏⴼⵍⵍⴹⵓ ⵓⴰ ⵎⵙ ⵙ ⵜⴹⵜ⵰ ⵛⵛⵗⵍ ⵓⴰ ⵍⵗⵏ ⴼⵍ ⵙⵔⵢ ⴹⵓⵢ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵜⵔⵢⵜ ⵏⵍⵓⵌⵀ ⵙ ⵜⵏⴼⵍⵍ ⵜⵍⵀⵙ⵿ⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵜⴰ ⵜⵂⵜ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ⵏⵙⵏ ⵙ ⵛⵔⵗⴰ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⴹⴼⵍ⵰ ⵎⵛⵏ ⵏⴾ ⵓⴹⵏ ⵎⵙⴰ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⴹⵔⵏⵏⵜ⵰ ⵏ⵿ⵤⵗⵏ ⵎⵙⴰ ⵤⵏ ⴾⵍⵢ ⵏⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ⴼⵍⵙ ⵓⴰ ⵜⴶⴰ ⵓⵔ ⵜⴶⵔ⵰ ⵔⵜ ⵓⴰ ⵔⵗ ⵓⵔ ⵜⵜⴶⴰ ⵎⵔⵏ ⵔⵜ ⵓⴰ ⴾⵢⴹⴰ ⵏ⵿ⵜⴰ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵜⴶⵗ ⵓⴰ ⵓⵔ ⵔ ⵓⴹⵢ ⵆⵀⵍⵗ ⵙ ⵛⵔⵗⴰ ⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ⵎⵔⴹⴰ ⵓⵔⴶⵗ ⵏⴾ ⵜⴶⵏ ⵓⵏ ⴾⵍⵔ ⵀⴾⴹ ⵓⴰ ⴹⵗⵢ ⵗⵙⵔⵏ ⵜⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ⴼⵍⵙ ⵙⵏⵗ ⵙ ⵔⵜ ⵓⴰ ⵍⵗⵏ ⵓⵔ ⴹⵗⵢ ⵗⵙⵔ ⵍⵎⵗⵏⴰ ⵓⵔ ⵂⴰ ⵜⵗⵙⵏⵏ⵰ ⴼⵔⴶⴰ ⵜⵔⴰ ⵏⵓⴰ ⵍⵗⵏ ⵎⵛⵏ ⵓⵔ ⴼⵔⴶⵗ ⵎⵤⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ⵓⵔ ⵜⵎⵤⵍⵗ ⵓⴰ ⵍⵗⵏ ⵙⵏ⵿ⵜⴰ ⵔⵗ ⴾⵍⵔ ⵓⴰ ⵓⵔ ⵏⵍⵗ ⵜⵎⵤⵍⴰ ⵙⵏ⵿ⵜⴰ ⵓⵔ ⵔⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ⵙ ⵎⵙ ⵙ ⵜⵎⵤⵍⵗ ⵓⴰ ⵓⵔ ⵔⵗ ⵓⴹⵢ ⵓⵔⴶⵗ ⵏⴾ ⵜⵜⵎⵤⵍⵏ ⴾⵍⵔ ⵀⴾⴹ ⵓⴰ ⴹⵤⴹⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ⵎⴾⵏ ⴹⵗ ⵙ ⴹⴶⵔⵗ ⵙ ⴹ ⵔⵗ ⴶⵢ ⵏⵓⴰ ⵍⵗⵏ ⴹⵜⵢ ⴹⵎⵍ ⵓⴰ ⵓⵔ ⵏⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ⴼⵔⵢⴰ ⴹⵗ ⵓⵍⵏ ⵢⵙ ⵔⵗ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ⵎⵛⵏ ⴼⵔⵢⴰ ⴹⵗ ⵜⵙⵍⴹⵏ ⵢⵛⵔⵗⴰ ⵢⵏ ⵀⵍⵏⵏ ⴹⵛⵔⵗⴰ ⵓⴰ ⵆⵀⵍⵏ ⵎⵏⵏ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵆⵍⵗ ⴾⵍⵢ ⵏⵛⵔⵗⴰ ⵓⵏ ⵀⴾⴹ ⵂⵏ ⵛⵙⵍⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ⴾⵜ ⵗⵛⴹ ⵏⵎⵏ ⴶⵔⵓⵢ⵰ ⵎⴰ ⴹⵤⵙⴼⵙⵏ ⴹⵗ ⵜⵗⵙⴰ ⵜⵙ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⴹⵗ ⴹⵢ ⵙ ⵜⵢⵜⵢⵏⵏ ⵤⴰ ⵎⵙⵗ ⴾⵍⵢ ⵏⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵙ ⵜⵗⵙⵏⵏ ⵎⵔⵏ ⵎⵙⵗ ⴾⵍⵢ ⵏⵛⵔⵗⴰ ⵓⵏ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ⴹⵢ ⴼⵍⵙ ⵎⵔⴹⴰ ⵀⵙ ⵜⵍⴰ ⵜⴹⵀ ⵢ ⵓⵏ ⵔ⵿ⵜⵢⵏⵏ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ⴼⵍⵙ ⵜⵔⵏⴰ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵂⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵙⴹⵔⴼⵜⴾⵢ ⴹⵗ ⵜⵔⵏⴰ ⵜⵏ ⵀⴾⴹ ⴹⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵓⵔ ⴼⵔⴶ ⴶⵢ ⵏⵓⵏ ⴼⵍⵙ ⴶⴹⵍⵙ⵿ⵜⵓ ⵔⴾⵎ ⵏ⵿ⵜⵗⵙⴰ ⵏⴶⴹⵎ⵰ ⴹⵢ ⴼⵍ ⴹⵙⴶⵍⴰ ⵎⵛⵏⴰ ⵀⵔⵔⵏⵜ ⵎⵏⵜ ⵂⴰ ⵜⵗⵙⴰ ⵤⵏ ⵜⵏ ⵏⵙⵀⴾⴹⵏ ⵏⵎⵙ ⵆⵍ ⵜⴾⵜⵢ ⵜⴰ ⵜⵎⵙⵜ ⵀⴾⴹⵏ ⴹ ⵎⵛⵏⴰ ⵜⵜⵓⴹⵀⵏ ⴹⵗ ⴹⴶⵏⵏⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵤⵤⵔⵤ ⵜⵔⵏⴰ ⵜⴰ ⴼⵍⵏⵗ ⵍⴰ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ⵔⵜ ⵓⵏ ⴶⵢ ⴼⵍ ⴹ ⵏⴼⵔⴶ ⵎⵤⵍ ⵏⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵙ ⵜⵎⵓⵜ ⵜⵗⴹⵜ ⵏⴾⵏⵢ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵜⵔⴰ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔⴶⵗ ⵜⵏ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵜⵔⴰ ⵜⵏ ⴶⴹⵎ ⵓⵏ ⴹⵢ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ ⵜⴶⵏ ⵎⵔⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⵜⵔⴰ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵏ ⴹⵢ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵓⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ⵍⴾⵎ ⵢ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ ⵜⵎⵜⵏ⵿ⵜ ⵙ ⵜⵓⵢ ⵎⵔⵏ ⵍⴾⵎ ⵢ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵓⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⵙ ⵜⵓⵢ ⴹⴶⵔⵓ ⵏⵍⵈⵔ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ⴼⵍⵙ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ ⵤⵏ⵿ⴶⵏ ⵎⵛⵏⴰ ⴹ ⴶⴹⵎ ⵓⵔ ⵀⵔⴹⴶ ⵢⵛⵔⵗⴰ ⵓⵏ ⵎⵛⵏⴰ ⵎⵔⵏ ⵓⵔ ⵜⴼⵔⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢ ⴹⵔⵏⵏ ⵏ⵿ⵜⵗⵙⵏⵙⵏ ⵓⵔ ⴼⵔⴶⵏ ⴶⵔⵤⵜ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ⴾⵓⵏⵢ ⵙ ⵎⵙ ⵙ ⵤⴹⵗⴾⵓⵏ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⵀⵙ ⵜⵍⴾⵎⵎ ⵢ ⵎⴹⵔⵏⵏ ⴹⵔⵏⵏ ⵏⴶⴹⵎ ⴾⵍⵔ ⵓⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵜⵍⴾⵎⵎ⵰ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵂⴰ ⵏ⵿ⴼⵙ ⵓⵏ ⵍⵎⵙⵈ ⵓⴹⵢ ⵓⵔⴶⵗ ⵢ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵜⵔ⵿ⵜⵢⵎ ⴹⵍⵎⵙⵈ ⵓⴹⵢ ⴾⴹ ⵎⵙ ⵙ ⵜⵗⵙⵏⵓⵏ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵜ ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹ ⴹⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⴼⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⴼⵍⵙ ⵢⵜⴹⵏ ⵗⴹⵏⵏ ⵜⵎⵙⵎ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ⵛⵗⵙⵓⵏⵓⵏ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵙⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙ ⵎⵙ ⵙ ⵂⵓⵏ ⵏ⵿ⴼⵙ ⵏⵓⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⵓⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹ ⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⴹⵗ ⵜⵗⵙⵓⵏⵓⵏ ⵙⵏ⵿ⴼⵙⵏⵜ ⵤⴹⴶⵏ ⴾⵓⵏⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵍⵏ⵿ⵜⵓ ⵔⵜⵏ ⴹⵏⵗⵂⵛⵍⵏⵏ ⵎⵛⵏ ⵓⵔⴶⵗ ⴹⵗ ⵏⵎⴹ ⵓⵏ ⴹⵔⵏⵏ ⵏⴶⴹⵎ ⵔⵏⵏ ⴹ ⵏⵍⴾⵎ ⵢⵓⴰ ⵔⵏ ⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ⴼⵍⵙ ⵙ ⵜⴶⵎ ⵜⵎⴹⵔ⵿ⵜ ⵜⵍⴾⵎⵎ ⵢⵓⴰ ⵔⵏ ⵎⵏⵓⵏ ⵓⴹⵢ ⴾⵓⵏⵀⴰ ⵜⴶⵤⵎ ⵌⵂⵏⵎⴰ⵰ ⵎⵛⵏ ⵙ ⵜⵢⵎ ⵎⵤⵍⵏ ⵓⵏ ⵔⵏ ⵎⵏ ⵏⴶⴹⵎ ⵜⵍⴾⵎⵎ ⵢ ⵓⵏ ⵔⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵓⵏⵂⵏ ⵓⴹⵢ ⴹ ⵜⴹⵔⵎ ⵂⵔ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ⴼⵍⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵗ ⵏⴹⴰ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵓⵏ ⴹⵢ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ⵏ⵿ⴼⵙ ⵓⴰ ⵜⴶⵔⵓⵎ ⴹⵢ ⵓⵔ ⴾⵓⵏⴶⴰ ⴾⵍⵏ ⵓⵔ ⵜⵜⴶⵔⵓⵎ ⴼⵍ ⵜⴶⵍⵎ ⵜⵂⵓⵏ ⵜⵙⴰ ⴾⵍⵔ ⵜⴶⵔⵓⵎ⵿ⵜⵓ ⴼⵍ ⵜⵆⵍⵎ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ⵰ ⵏ⵿ⴼⵙⵏ ⴹⵗ ⵙⵔⵏⴰ ⴹⵓⵢⵏ ⵙ ⵏⴹⴾⵍ ⵎⵙⵍⵏⵏⴰ ⵏⴶⵏⵓ ⵢ ⵎⵛⵏⴰ «ⵀⴰ⵰ ⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵜⴶⵢⵜⵏⵏ ⵙ ⵏⵎⵙ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵏⵎⵙ ⵓⴹⵢ ⵎⴾⵙⴰ ⵏⵔⵈⵎⵜⵏⵜ ⵏⵎⵙ ⵎⵔⵏ ⵏⴹⵔⵓ ⵜⴾⵙⵜ ⵜⵏ ⴹⵍⵎⵙⵈ ⴹⴹ ⵤⵎⵙ ⵏⴹⵓ ⴹⵔⵙ ⴹⵗ ⵍⵗⵤⵀ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵜⴹⴶⵔ⵿ⵜⵏⵏⴰ ⴹⵗ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ⴶⴰ ⵗⵔⵢ ⵙ ⵍⵗⵤⵀ ⵓⴰ ⵏⵜⴶⵓ ⵎⵔⴹⴰ ⵓⵔ ⵓⴹ ⵓⵍⴰ ⴹⵗ ⵜⵏⵢⴰ ⵜⴰ ⴹⵏⴹⵤⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ⵓⴰ ⴹⵈⵍⴾⵏ ⴾⵍ ⴾⵏⴰ ⴹⴶⵤ ⴹⵗ ⵏⵢ ⵏⵍⵓⵆ ⵓⴹ ⵤⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ⴼⵍⵙ ⵓⴰ ⴹⵈⵍⴾⵏ ⴾⵍ ⴶⵤ ⵜⵍⴰ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ ⵜⵀⵏⵏ⵰ ⵓⵔⴶⵗ ⵏ⵿ⵜⵏⵢ ⵔⵏⵏ ⵓⵏ ⴾⵍⵔ ⵎⵛⵏⴰ ⵜⵏⴶⵏ ⴹⵗ ⴼⵙⵏ ⵏ⵿ⵜⵗⵎⵔ ⵜⵏ⵰ ⵍⵢ ⵜⵎⴰ ⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ⵙ ⵜⵈⵍⴾ ⵜⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴹⴰ ⴾⵜⵏⵜ ⴹ ⵜⴹⵔⴼⵜ ⴹⵗ ⵂⵍⴾ ⵓⴰ ⵜⴶⴰ ⵎⵙⵏ ⴾⵍⵓ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵍⵍⵓ ⴶⵏ ⴹⵗ ⵜⵏⵢⴰ ⵜⴰ ⵤⴶⵔⵓⵏ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ⵎⵔⵏ ⵏⵙⵏ ⵓⵍⵏ ⵙ ⵂⵔ ⵂⵔⵓⴰ ⴹⴰ ⵜⵈⵍⴾ ⴾⵜⵏⵜ ⵜⴹⵓ ⴹⵗ ⵜⵂⵏⴼⴰ ⴹⵜⵍⵓⵢⵜ ⵤⵏ ⵜⵏ⵿ⵜⵜ ⵜⵜⴶⵤⵜ ⵎⵤⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ⵎⵛⵏ ⵓⵔⴶⵗ ⵏ⵿ⵜⵏⵢ ⵗⵙ ⵜⵂⵏⴼⵜⵏⵏ ⵏⴾⵏⵢ ⴶⵔⵓⵏⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵙⵏ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⵜⵤⵔⵜ ⴹⵗ ⵜⵂⴾ ⵏⵎⵛⵏⴰ ⴹⴰ ⵏⵜⵂⵏⴼⵜ ⴹⵗ ⵎⵏⵏⴰ ⵏⴾⵏⴰ ⴹⴶⵤ ⴹⵗ ⴹⵏⵗⴶⵓ ⵎⵛⵏⴰ ⵀⵔⵔⵏⵜ ⴾⴼⵏⵗ ⵜⴹⵔⴼⵜ ⵜⴾⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ⴼⵍⵙ ⵏⴶⵔⵓ ⴼⵙⵏ ⵙⵜⵎⴰ ⵓⴰ ⵏⴶⴰ⵰ ⵙ ⵏⵂⵏⵢ ⵓⵙ ⵏⴶⴰ ⵜⵎⵏⵜ ⵓⴹⵢ ⵀⵙ ⵎⵙ ⵜⵎⴰ⵰ ⵎⴰ ⵎⵙ ⵓⴰ ⵤⴶⵏ ⵜⵎⴰ ⵏⵔⵜ ⵂⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ⵎⵛⵏ ⵙ ⵏⴶⴰ ⵜⵎⵏⵏⴰ ⴹⵗ ⵓⴰ ⵓⵔ ⵏⵂⵏⵢ ⵓⴹⵢ ⴹⵙⵏⵆⵍ ⵙ ⵤⵎⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ⵙ ⵏⴶⴰ ⵓⵏ ⴹⵙⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵂⵍⵏⴰ ⴹⵗ ⵔⴾⵎⵏⵏⴰ ⴼⵍⵙ ⵏⴾⵏⵢ ⵓⵔ ⵏⵙⵏ ⵔⵜ ⵓⵙ ⵂⵔ ⵜⵏⵏ⵿ⵙⵢ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏⴰ⵰ ⵎⵛⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵏⵜ ⵜⴶⵓ ⵛⵂⵏⴼⴰ ⵙ ⵓⵔ ⴼⵔⴶ ⵓⴹⵏ ⵎⵍⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ⵎⵔⵏ ⵓⴰ ⵜⵎⵢⵤⵏ ⵓⵍⵏ ⵙⵏ ⵓⴰ ⵜⵎⵙ ⵏⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⵏ⵿ⵜⴰ ⴶⵏⴰ ⵓⵏ ⵎⵛⵏⴰ ⵙ ⵜⵜⵔ ⵙⵙⵎ ⵏⵎⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ⵎⵔⵏ ⵏⵙⵏ ⵙ ⵔⵜⵏ ⴾⵍ ⵎⵙⵏ ⵜⵏ⵿ⴼⴰ ⵏⵢⵜⴹⵏ ⵓⵏ ⵔⵏⵏ ⵎⵛⵏⴰ ⵜⵓⵗⵔⵏ⵿ⴹⵓ ⴹⵗ ⵙ ⵜⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ⴼⵍⵙ ⵓⵏ ⵙⵏⴼⵔⵏ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵓⵏ ⴹⵢ ⵜⵙⵙⵏ ⴹ ⵆⵍⵏ ⵍⵎⵜⵍ ⵏⵀⵔⵔⵏⵜ ⴼⵍ ⴹ ⵆⵍ ⵀⵔⵔⵏⵜⵏ ⵗⴼⴹⵢ ⴹⵗ ⵀⵔⵔⵏ ⴶⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ⵎⵔⵏ ⵓⵏ ⵙ ⵜⵙ ⵎⵛⵏⴰ ⵜⵗⵔⵢⵏⵙⵏ ⴾⵍⴰ ⴹⴰ ⵓⵏ ⴹⵢ ⵗⵔⵏ ⵎⵔⵏ ⴶⵏ ⵢⵜⴹⵏ ⵗⴹⵏⵏ ⴾⴼⵏ ⴹⵗ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ⴹⵗ ⴹⵢ ⵎⴰ ⵤⴰ ⵏⵏⵓ ⴹⵗ ⵀⵜⵓ ⵜⴰ⵰ ⵙ ⵎⵙ ⵙ ⵎⵛⵏⴰ ⵓⵔ ⴶⵏⵏⵏⴰ ⵎⴰ ⴼⵔⴶⵏ ⴹ ⵆⵍ ⵍⴹⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ⵎⵛⵏⴰ ⵙ ⵀⵔⵔⵏⵜ ⵏ ⵢⵏ⵿ⴹⴰ ⴹⴰ ⵓⵔ ⵜⵢⴰ ⴾⵍⵔ ⴾⴼⵢ ⴼⵍ ⴹⵍⵍⵏⵏⴰ ⴾⵜⵏⵏⴰ ⵎⵏⵎⴾ ⵙ ⴹⵏⵓⵔⵤⴾⴼⵓ ⵔⵜ ⴾⵍ ⵙⵔⵈⵎⵜⵏⵜ ⵏⴹⵔⵓ ⵓⵏ ⴹⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ⵎⴰ ⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ ⵢⵜⴹⵏ ⵓⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔⴶⵗ ⵎⵛⵏⴰ ⵜⵏⴾⴼⵏ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ⵎⴰ ⵎⵙ ⵤⴰ ⵓⴰ ⵜⵏ⵿ⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ⵰ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵎⵏⵜ ⵙ ⵜⵀⴰ ⵎⵔⵏ ⵓⵔⴶⵗ ⵓⵏ ⵗⵙ ⴾⵍⵔ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵂⴰ ⵎⵔⴹⴰ ⵗⵍ ⵏⵎⵛⵏⴰ ⵎⵙ ⵍⵎⵓⴾⵍⵏⵏⵗ ⴹⵏⵗⵜⴶⵏ ⵛⵓⵜⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ⵎⴰ ⴼⵔⴶⵏ ⴹⵏⵗⵤⵎⵤⵢ ⴹⵜⵔⴰ ⵏⵍⵎⵙⵈ⵰ ⵓⴾ ⵜⵙⵙ⵿ⵜ⵰ ⵎⵗ ⵜⵎⵗⵜⵔ⵿ⵜ ⵎⵗ ⵜⵓⴹⴶⵤ ⵎⵗ ⴶⵍⴾ ⵎⵗ ⵤⵍⵎ ⵎⵗ ⴶⵤ ⵏⵍⵗⵔⵔ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵎⵗ ⵜⴾⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ⵏⵏ ⵍⴾⵜⵀⵏ «ⵜⵓⴾⵙⵏ ⴹⵗⵏⴰ ⵎⵏ ⵤⵍ ⴾⵍ ⴼⵍ ⴹⵍⵍⵏⴾ⵰ ⵏⵜⵓⵈⵙⵀ ⵤⵏ ⵢⴼⴹ ⵜⵓⴶⵤⵎⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ⵎⵛⵏ ⴹⵗ ⵓⵏ ⴾⵜⵏⵜ ⵏⴶⵔⵓ ⵜⵔⵏⴰ ⵜⴰ ⵜⴶⵔⵜ ⵙ ⵜⵔⵢⵜ ⵏⵓⴰ ⴹⵏⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ⴼⵍⵙ ⴾⵙⵗ ⵛⴾ ⵙ ⴶⵔ ⵤⴰ ⵜⵎⵜⵏ⵿ⵜ ⵓⵍⴰ ⵜⵎⴹⵔ⵿ⵜ ⵓⵍⴰ ⵏ⵿ⴶⵍⵙⵏ ⵓⵏ ⵎⵤⵔⵢⵏⵏ ⵎⵛⵏⴰ ⵓⵍⴰ ⵜⵗⵎⵔⵏ ⵏⵛⵔ ⵛⵏ ⵂⵏⵏ ⵜⵏ⵿ⴾⵍ ⵓⵍⴰ ⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⵎⵔⴹⴰ ⵓⵍⴰ ⵤⵎⵏ ⵓⵏ ⴹⵤⵢⵏⵏ ⵓⵍⴰ ⵛⵗⵔⴹ ");
INSERT INTO ttqt_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ⵓⵍⴰ ⵓⴰ ⵂⵏ ⴼⵍⴰ ⵓⵍⴰ ⵓⴰ ⵂⵏ ⵔⵙ ⵓⵍⴰ ⵔⵜ ⵓⵍⵢⵏ ⴹⵈⵍⴾⵏ ⵈⵙⵍ ⵓⵔ ⵜⵍⴰ ⴼⵔⴶⵏ ⴹⵏⵗⵤⵎⵤⵢ ⴹⵜⵔⴰ ⵜⴰ ⴹⵏⵗⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ⵜⴹⵜ ⵎⵍⴰ ⵙⵙⵎ ⵏⵍⵎⵙⵈ ⵓⵔ ⵜⴶⴰ ⵀⵂⵓ ⵎⵏⵏ ⴶⵢⵏⵢ ⴼⵍ ⵓⵏ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ⵗⵛⴹⵏ ⵎⵏⵏ ⵓⵍⵏ ⵛⵓⵛⴰ ⴹⵗ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ⵓⵍⴰ ⵓⵔ ⴹⴾⵎⴰ ⵍⵗⵏⵢ ⵎⵛⵏⴰ ⵎⵤⵢⴰ ⴹⵍⵎⵙⵈ ⴼⵍ ⵍⵗⵍⵙ ⵏ⵿ⴾⵍ ⵜⵎⵜⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵓⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ⵜⵏⵎⵙⵏ ⴾⵍⵙⵔⵢⵍ⵰ ⵏ⵿ⵜⵏⵢ ⵍⵏⵏ ⵍⵎⵆⵎ ⵏ⵿ⵜⵛⵜ ⵏⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵓⵏ ⴹⵙⴾⵜ ⵢ ⵎⵏⵜ⵰ ⵏ⵿ⵜⵏⵢ ⴹⵗ ⵎⵙⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵗ ⴹⵜⵏⴼⵍⵍ ⵜⵎⵙ⵿ⵜ ⵏⵎⵛⵏⴰ ⵙ ⵜⵏⵢⴰ ⵏⴼⵍⵍⵏ⵿ⴹⵓ ⴹⵗ ⴹⵗⵙⵏ ⵔⴾⵓⵍⵏ ⵏ⵿ⵜⵙⵆ ⴹⵜⵂⴾⵜ ⵜⵏ ⵛⵔⵗⴰ ⴹⵍⵗⵀⴹⴰ ⴹⵔⴾⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ⵏ⵿ⵜⵏⵢ ⴹⵗ ⵎⵙⵏⵏ ⵤⵔⵢⴰ ⵏⵎⵔⵓⵏⵏⴰ ⵓⵏ ⵔⵓⵏⵏ ⵍⵎⵙⵈ ⴹⵗ ⵎⵙ ⵢⵏ ⴹⵗⵙⵏ ⵙ ⵜⵛⵜⵏⵜ ⴶⴹⵎ⵰ ⵍⵎⵙⵈ ⵙⵏ⵿ⵜⴰ ⵍⵏ ⴹⵏⴶ ⴾⵍⴾ ⵏⵔⵜ ⵎⵙ ⵎⵛⵏⴰ⵰ ⵜⵎⵍⵜ ⵙⵎⵏⵜ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ⵔⵜ ⵓⵏ ⵓⵔ ⵎⵙ ⵍⵎⵗⵏⵏⵜ ⵙ ⵓⵍ ⵏⵎⵛⵏⴰ ⵀⵙ ⵍⴰ ⵍⵎⵆⵎ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵏ⵿ⵜⴰ ⵢⴰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⴶⵎⴹⵏⵏ ⵙⵔⵢⵍ ⵎⵙⵏⵏ ⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ⵓⵏ ⴹⴶⵎⴹⵏⵏ ⵀⵔⵂⵎ ⴹⵗ ⵓⵔⴶⵗ ⴾⵍ ⵎⵙⵏ ⵀⵔⵔⵏⵜ ⴾⵍⵔ ⵏⴰ ⵎⵛⵏⴰ ⵢⵀⵔⵂⵎ ⴹⵗ ⵍⴾⵜⵀⵏ «ⵢⵜⴹⵏ ⵓⵏ ⴹⴶⵎⴹⵏⵏ ⵙⵂⵆ ⵤⵆⵍⵏⵏ ⵤⵔⵢⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ⵓⵔⴶⵗ ⵀⵔⵔⵏ ⵓⵏ ⵂⵓⵏⵏ ⵙ ⵜⵎⵓⵜ ⵜⵏ ⴶⴹⵎ ⵎⵙⵏⵏ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ⵰ ⴾⵍⵔ ⵀⵔⵔⵏ ⵓⵏ ⵂⵓⵏⵏ ⵙ ⵜⵎⵓⵜ ⵜⴰ ⵜⵏⵎⵏⴾⵜ ⴹⵔⴾⵓⵍ ⵏⵎⵛⵏⴰ ⵏ⵿ⵜⵏⵢ ⵈⵙⵀ ⵎⵛⵏⴰ ⴹⵗ ⵤⵔⵢⴰ ⵏⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵏⴰ ⵔⴾⵓⵍ «ⴰ ⴾⵢⴹⵆⵍⴰ ⴹⵏ ⴹⴰ ⵤⵏⵏ ⴹⵢ ⴹⴰ ⵜⵎⵂⵔⴾⵏⴾ ⵙⵔⵜⴰ ⵜⵍⴰ ⵀⵔⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ⵎⵔⵏ ⵓⵔⴶⵗ ⵓⵏ ⵗⵙ⵰ ⵓⵏ ⴹⵗ ⵜⴶⴰ ⵔⵆⵢⵜⵓ ⵏ⵿ⵜⴰ ⴹⴰ ⵛⵏ ⵀⵔⵔⵏ ⵏⵢⵢⵏ ⵏⴾⵏⵓⵏ ⵜⵍⴰ ⵎⵔⵏ ⴾⵜⵏⵙⵏ ⵍⵌⴹⵏⵏⵗ ⵙⵂⵆ ⴹⵔ ⵜⵏ⵿ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","ⵎⵛⵏⴰ ⵍⴰ ⵜⵔⵢⵜⵏⵜ ⵜⵙ ⵙⵏⴼⵔⵏ ⵢⵜⴹⵏ⵰ ⵙⵏⴼⵔⵏⵜ ⵢⵜⴹⵏ ⵍⴾⵎ ⵢ ⵜⵗⵔⵢ ⵜⴰ ⵜⵏⴶⴰ ⵙ ⵜⵔⵢⵜⵏⵜ ⵓⵔⴶⵗ ⵎⵤⵍⵏⵙⵏ⵰ ⴼⵍ ⴹ ⵙⵜⴹⵓ ⵜⵔⵢⵜ ⵜⴰ ⴹⴶⴰ ⴹⵏ ⵜⵎⵙⵜ ⵔⵜ ⵙⵏⴼⵔⵏ ⵏⴰ ⵢ ⵔⵆⵢⵜⵓ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵂⵓⵏ ⵀⵔⵔⵏⵜ ⵓⵔ ⴾⵏⵏ ⵓⵍⴰ ⵤⴰ ⵓⵔ ⵜⵗⵛⴹⵏ «ⵓⴰ ⵓⵛⵔⵏ ⴹ ⵆⵍ ⴾⵍⵢ ⵏⵓⴰ ⵏ⵿ⴹⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ⵏⵎⵏⴾ ⵓⵏ ⴹⵓⴰ ⵂⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⵔⵗ ⵢⵆⵀ ⴾⵢⴹⵗ ⵙⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ⴹⵗ ⴹⵢ ⵎⴰ ⵤⴰ ⵏⵏⵓ ⵢⵓⵏ⵰ ⵓⴾ ⵎⵛⵏⴰ ⵓⵔ ⵗⴹ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ⴼⵍⵙ ⵏⴰ ⵢ ⵎⵙⴰ «ⴹ ⵂⵏⵜⵗ ⵢ ⵓⵙ ⵔⵗ ⴹⵙⵂⵏⵜⵗ ⵍⵍⵗ ⵢ ⵓⵙ ⵔⵗ ⴹⵙⵍⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ⵎⴾⵏ ⴹⵗ ⵙ ⵔⵜ ⵓⵏ ⵓⵔⵎⴹ ⵆⵏ ⴹⵗ ⵓⴰ ⵔⴰ ⵓⴹⵏ ⵓⵍⴰ ⵔⵜⵏ ⵓⵏ ⵙ ⵤⵍ ⴹⵗ ⴶⵎⵢⵏⵙⵏ⵰ ⴾⵍⵔ ⵓⵔ ⵆⵏ ⵔ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵂⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ⵙⵏ⵿ⵜⴰ ⵏⵏ ⵢ ⴼⵔⵗⵓⵏⴰ ⴹⵗ ⵍⴾⵜⵀⵏ «ⵏⵢ⵰ ⴾⴼⵆⵢ ⵍⵎⵆⵎ ⴼⵍ ⴹ ⵙⴾⵏⴰ ⵜⵔⵏⵏⵏ ⵙ ⵜⵔⵢⵜⵏⴾ ⵜⴶⵓ ⵎⵙⵏⵜ ⴼⵍ ⵙⵎⵏ ⴹⵗ ⴹⵏⵜ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ⴹⵗ ⴹⵢ ⵎⵛⵏⴰ ⵜⵂⵏⵜⵜ ⵢ ⵓⵙ ⵔⴰ ⵙⴶⵔⵎⵎ ⵓⵍ ⵏⵓⵙ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ⵎⵔⵏ ⵙⵏⵗ ⵙ ⴹⵜⵏⴰ «ⵎⴼⵍ ⴹⵗ ⴹⵢ ⵎⵛⵏⴰ ⵂⵔⵓⴹⴰ ⵜⵀⵤ ⵢⵜⴹⵏ ⵙ ⵎⵤⵍⵏⵙⵏ ⴹⴹ ⵤⵎⵙ ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⵎⵤⵔⵢ ⵏ⵿ⵜⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ⴼⴹⴰ ⴾⵢ ⴶⴹⵎ ⵎⴰ ⵜⵎⵙⵗ ⵙ ⵜⵛⵔⵗⴰ ⴹⵎⵛⵏⴰ⵰ ⵓⴾ ⵜⵍⵆ ⵜⴼⵔⴶ ⴹ ⵜⵏⵓ ⵢ ⵓⴰ ⵙⵔⵙ ⵛⵆⵍⵏ «ⵎⴼⵍ ⵜⵜⴶⵗⵢ ⵎⴾ ⵓⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ⵓⴾ ⴾⵏⵓ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵍⵏ ⵜⵍⵆ ⵜⴶⵓ ⵙⵔⵙ ⴾⵙⵏ ⵙ ⵓⵢⴹ ⵤⴰ ⵜⵓⵙⵏ⵿ⵙⵏ ⵢⵤⵍ ⵙⵔⵙⵏ ⵙⴾⵜⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵎⵔⵏ ⵜⵓⵙⵜⵗⵎⵍⵏ ⵤⵍ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","23","ⵎⴾⵏ ⴹⵗ ⴶⵏ ⵔⵜⵏ ⵓⵏ ⵙⵎⵜⴶ ⵎⵛⵏⴰ⵰ ⴶⴰ ⴹⵔⵏⴰ ⵜⵤⵢⴹⵔ⵿ⵜ ⵜⴶⵜ ⵏⴾⵏⵢ ⵂⵔⵏⵏ ⴹⵂⵍⴾ ⴼⵍⵙ ⵔⴰ ⴹ ⵙⵏⴼⵍⵍ ⵍⵂⵎⵏⵜ ⴹⵜⵔⵏⵏⵜ⵰ ⵔⴰ ⴹⵗ ⴹ ⵙⵏⴼⵍⵍ ⵢⵢⵜⴹⵏ ⵓⵢⴹ ⵜⵏⵢⵏⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ ⵏ⵿ⵜⵏⵢ ⵙ ⵂⵏⵜⵜ ⵏ⵿ⵜⵏⵢ ⴹⵗ ⵙⵎⵜⴶ ⴾⵍⴰ ⴹⴰ ⵢⴹⵔⵙ ⵔ⵿ⵜⵢⵏ ⴹⵗ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ ⵏⴾⵏⵢ ⵜⵏⵎⵙⵏ⵰ ⵗⵔⵏⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵗⵔⵏⴹⵓ ⴹⵗ ⴹⵗ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ⵓⵏ ⴹⵗ ⵂⵏ ⵍⴾⵜⵀ ⵓⵏ ⵏⵀⵢ ⵙⵢ ⵙ ⵏⴰ «ⵓⵏ ⵓⵔ ⵏⵎⵙ ⵜⵎⵜⵢⵏⵏ ⵜⵏ⵿ⴹⵗⵔⵗ ⴶⵆⵏ \"ⵜⵎⵜⵢⵏⵏ\"⵰ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⵓⵏ ⴾⵏⵗ ⵜⵔⴰ ⵜⵏⴶⴰ \"ⵓⵏ ⴾⵏⵗ ⵜⵔ\"⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ⵎⵔⵏ ⴹⴶⵏ ⵓⵏ ⴹⵗ ⴹⵙⵏⵜⵓⵏⵓ \"ⵓⵔ ⵜⵎⵙⵎ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ⵰\" ⴹⴶⵏ ⵓⵏ ⴹⵢ ⴹⴰ ⴹⵗ ⴹⵙⵏ⵿ⵤⵜⵓⵏⵓ \"ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⴹⵢ ⴹⵔⵏ\"⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ⵏⵀⵢ ⵙⵢⵙ ⴹⵗ ⴾⵜⵀ ⴹⵗ ⵀⵜⵓ ⵏⵙⵔⵢⵍ ⵙ «ⵙ ⴶⵏ ⵎⴹⵏⵙ ⵏⵙⵔⵢⵍ ⴶⵜ ⵓⵏ ⵜⵀⵍⵍⵏ ⵏⵎⴹⵍ ⵔⵜ ⴹⵗⵙⵏ ⵗⵙ ⵤⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ⴼⵍⵙ ⵎⵗⵍⵍ ⴹ ⵙⵏ⵿ⴹⵓ ⵓⵍⵏⵜ ⴼⵍ ⴹⵏⵜ ⵙ ⵜⵎⵓⵜ ⵜⴾⵎⵍⵜ ⵜⵜⵔⵀⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ⵤⵏ ⵀⵜⵓ ⵜⴰ ⴶⴰ ⵏⵀⵢ ⵙⵢⵙ ⴹⵜ ⵓⵏ ⵙ ⵏⴰ «ⴾⵏ⵿ⴹⵀⴰ ⵙ ⵎⵍⵢ ⴹⵢ ⵍⵏ ⵜⵔⵏⴰ ⴹⵗⵏⴰ ⴹⴶⵍⵤⵏ ⵎⵙⴰ ⵓⴹⵢ ⴹ ⵏⵆⵍ ⵤⵏ ⵙⴹⵎ ⵏⵍⵓ ⴹⴶⵎⵔⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ⵎⴰ ⵤⴰ ⵏⵏⵓ ⴹⵗ ⴹⵢ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵔ ⴶⵍⵢⵏ ⴹⵗ ⴶⵎⵢ ⵏ⵿ⵜⵆⵜ ⵎⵛⵏ ⴶⵔⵓⵏ⵿ⵜⵜ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ⴾⵍⵙⵔⵢⵍ ⵎⵔⵏ ⴶⵎⵢⵏⵏ ⴹⵙⴾⵎⵍⵏ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵜⵆⵜ ⵏ⵿ⴹⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ⵎⴰ ⴹⵓⵢⵏ ⵤⴰ ⵓⵏ⵰ ⴹⵢ ⵤⴰ ⵀⴰ ⵏⴶⵎⵢⵏⵙⵏ ⵜⵆⵜ ⵜⵏ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⴶⵎⵢⵏ⵿ⵜⵜ ⵙ ⵎⵤⵍⵏⵙⵏ⵰ ⵜⵏ⵿ⴾⴼⵙⵏ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵜⵙⴶⴹⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ⵜⵂⵏ⵿ⵜ ⵜⵏ ⵜⵎⵜⵍ ⵍⵎⵙⵈ ⵎⵔⵏ ⵏⵏ ⵍⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵏⵜ «ⵏⵢⵜ ⵙⵏ⵿ⵙⴰ ⴹⵗ ⵙⵢⵏ ⵜⵂⵏ⵿ⵜ ⵜⵎⵙⵜ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵜⵎⵙ ⴹⵗ ⵜⵙⵍⵜ ⵜⵜⴶⴹⵍⵜ ⵢⵜⴹⵏ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵓⵔ ⵤⴾⵔⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ⵎⴹⵔⵢⵏⵏ ⴾⵏⵗ ⴹⵔⵏ ⵏⴹ ⴶⵔⵓⵏ ⴾⵍⵙⵔⵢⵍ ⴼⵙⵏ ⵎⵔⵏ ⵓⵏ ⴹⵗ ⵜⵏ⵿ⵙⵢⴰ ⵎⵛⵏⴰ ⴼⵓ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ⴼⵍⵙ ⴶⵢⵗ ⵙ ⴶⵍⵢⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ ⵎⵛⵏⴰ ⵎⵛⵏ ⵓⵔ ⵙⵔ⵿ⵜⵢⵏ ⵓⵏ ⴹⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ⵓⵔ ⴶⵔⵏ ⵜⵎⵓⵜ ⵜⵙ ⵂⴾⵓ ⵎⵛⵏⴰ ⵢⵜⴹⵏ ⵜⵆⵜ ⵜⵜⴶⵎⵢⵏ ⵙ ⵎⵤⵍⵏⵙⵏ⵰ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵓⵔ ⵀⵔⴹⴶⵏ ⵢ ⵎⵛⵏⴰ ⴶⵢⵏ ⵙ ⵍⴾⵎ ⵢ ⵜⵔⵢⵜ ⵜⵙ ⵂⴾⵓ ⵎⵛⵏⴰ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵜⵙⵈⵜⵎ⵿ⵜ ⵏⵛⵔⵗⴰ ⵢⴹ ⵆⵍ ⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⴹ ⴶⵔⵓⵏ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ⵔⵜ ⴹⴰ ⵓⴰ ⴾⵜⵀ ⵏⵀⵢ ⵎⵙⴰ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵆⵜ ⵜⴰ ⵜⵜⵓⴶⵔⵓⵜ ⵙ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ «ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵙⵏ⵿ⴹⵏ ⵛⵔⵗⴰ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵜⵎⴹⵔ⵿ⵜ ⵙⵙⵀⵀ ⵏⵛⵔⵗⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ⵎⵛⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵎⴾ ⵓⵙ ⵜⵜⵓⴶⵔⵓ ⵜⵆⵜ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ «ⴹ ⵓⵔ ⵜⴶⵏⴰ ⴹⵗ ⵎⵏⴾ \"ⵎⴰ ⵤⴶⵤⵢⵏ ⵙ ⵌⵏⵓⵏ⵰\"» ⵓⴾ ⵍⵎⵙⵈ ⵓⵔⴶⵗ ⵤⵀⵜⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ⵎⴹⵗ ⵜⵏⴰ «ⵎⴰ ⵤⵤⵀⵏ ⴶⵤ ⵎⵓⵜⵏ ⵏⵎⴹⵍ⵰» ⵓⴾ ⵍⵎⵙⵈ ⵓⵔⴶⵗ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ⵓⴾ ⵎⴰ ⵏⴰ ⵓⵍ ⵏⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵓ ⵜⴰ⵰ ⵏⴰ «ⵓⵍ ⵂⵤⴾⵢ ⵂⴰ ⵎⵏⴾ ⵂⴰ ⵓⵍⵏⴾ» ⵎⵔⵏ ⵓⵍ ⵓⴰ ⵀⵜⵓ ⵏⵤⴶⵤⵏ ⴹⵗ ⵛⵓⵍ ⵏ⵿ⵜⴰ ⴹⵗ ⵙ ⵏⵜⴶⵓ ⵜⵍⵈⵜⵀⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ⵙ ⵜⵛⵓⵍⴰ ⵜⵆⵀⵍⵗ ⵙ ⵗⵢⵙⴰ ⵎⵙ ⵎⵍⵢ ⵜⵤⴶⵤⵏⴰ ⴹⵗ ⵓⵍⵏⴾ ⵙ ⵙⵏ⵿ⴾⵔ⵿ⵜⴹⵓ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⴾⵢ ⵜⴶⵔⵓⵗ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵤⴶⵤⵏⵏ ⴹⵗ ⵓⵍⵏⵜ ⵓⴹⵢ ⴹ ⵜⴾⴼⵓ ⵎⵛⵏⴰ ⵜⵆⵜ⵰ ⵎⵔⵏ ⵓⴰ ⵛⵓⵍⵏ ⵎⵍ ⵤⴶⵤⵏⵜ ⵓⴹⵢ ⴹ ⵜⴾⴼⵓ ⵎⵛⵏⴰ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ⵏⵏ ⵍⴾⵜⵀⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ «ⴼⵍⵙ ⴼⵍⵏ ⴶⴰ ⴹⵗⵙ ⵜⵎⵏⵜ ⵓⵔ ⵍⴾⵎ ⴹ ⴾⵔⴾⴹ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ⵓⵔ ⵤⵍⵢ ⵓⴰ ⵎⵙⵏ ⴶ ⵍⵢⵂⴹ ⵓⵍⴰ ⵓⴰ ⵜⵓⵔⵏⵎⵙ⵰ ⴾⵜⵏⵙⵏ ⵎⵍⵏⵙⵏ ⵢⵏ⵿ⴹⴰ ⵂⴾⵏ ⵙⵍⵍⵏⵜ ⵜⴶⵙ⵿ⵜ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴹⵗⵙ ⵜⵜⴶⵎⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴶⵎⵢⵏ ⵜⴶⵙ⵿ⵜ ⴹⵗ ⵎⵍⵢ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⴼⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ⵎⵏⵢ ⵤⴰ ⵎⴾ ⵓⵙ ⵤⴶⵎⵢⵏ ⵜⴶⵙ⵿ⵜ ⴹⵗ ⵓⵙ ⵓⵔ ⵤⴶⵤⵏⵏ⵰ ⵎⵏⵢ ⵎⴾ ⵓⵙ ⵙⵔⵙ ⵤⵤⴶⵤⵏⵏ ⵓⵔ ⵙⵍⵏ ⵢⵓⵍⵏⵜ⵰ ⵎⵏⵢ ⵎⴾ ⵓⵙ ⴹⵙⵤⵙⵍⵏ ⴹⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⴹⵙⵏ⵿ⵜⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ⵎⵏⵢ ⵎⴾ ⵓⵙ ⵜⵤⵎⵍⵏ ⵢⵜⴹⵏ ⴹⵙⵏ⵿ⵜⵎⵍⵏⵏ ⵙ ⵎⵙ ⵙ ⵓⵔ ⵜⵍⴰ ⵢ ⵜⵏⵙⴶⵍⵏ⵰ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴾⵜ ⵛⵂⵙⵢ ⴶⵏⵜⵏⵜ ⵜⴾⵍⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵎⵍⵏⵏ ⵙⵍⵏ ⵏⵍⵈⵔ ⵎⵙ ⵍⵏ⵿ⵌⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ⵎⵛⵏ ⵓⵔⴶⵗ ⴾⵍⵍⵢⵂⴹ ⴾⵍ ⵀⵔⴹⴶⵏ ⵢⵍⵏ⵿ⵌⵍ⵰ ⵏⴰ ⵏⵀⵢ ⵙⵢⵙ «ⵎⵍⵢ ⵎⵏⵢ ⵓⴰ ⵤⴶⵤⵏⵏ ⵙⵓⴰ ⵏⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ⴹⵗ ⴹⵢ ⵙⵍⵏ ⵓⵏ ⵙ ⵏⵙⵍⴰ ⵏ⵿ⵜⵏⵢ ⴹⵜⵓⵢⵏⵏ ⵤⴶⵤⵏ ⵎⵔⵏ ⵓⵍ ⵏⵍⵎⵙⵈ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ⵎⵛⵏ ⵙⵙ⵿ⵜⵏ ⴹⴰ ⵓⴰ ⵜⴶⴰ ⵓⴾ ⴾⵍⵍⵢⵂⴹ ⵓⵔ ⵙⵍⵏ ⵢⵓⵍ ⵓⵏ⵰ ⵓⵍⵏ ⵤⴰ ⵙ ⵙⵍⵏⵙ⵰ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵎⵙⵍⵏⵙⵏ ⵜⵙⵍⵙ ⴹⵏⵜ ⴾⵜⵏⵜ ⵓⵍⵏⵙⵏ ⵔⵔⵓ ⵏⵎⴹⵍ ⴾⵜⵏⵜ ⵓⴹⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ⵍⵙⵗ ⵙⵙ⵿ⵜⵏ ⵂⵔⵓⴰ ⴹⴰ ⵏ ⵓⴾ ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⴰ ⴹⵗ ⵓⵏ⵰ ⵏⵀⵢ ⵎⵙⴰ ⴹⵙⵏ⵿ⵜⵎⵍⵏ ⵙ ⵜⵤⵔⵜ⵰ ⵏⵙⵏ «ⵏⴰ ⵎⵛⵏⴰ ⴾⵓⵏⴶⵗ ⵏⵎⵏ⵿ⵤⵗ ⵏⵓⵏ ⵙ ⵜⵎⵜⵢ ⴹⴰ ⵓⵔ ⵜⵜⵎⵙⵏ ⴾⵏⵗ ⴹⵗⵓⵏ ⴶⵢ ⵏⵍⵂⵎ ⵏ⵿ⵜⵎⵜⵢ ⵓⵔ ⵏⵍⴰ ⵜⵢⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ⵏⵀⵢ ⵙⵢⵙ ⴼⴹⴰ ⴹⵙⵏⵏⵏ ⵙ ⵜⵂⵍⵜ «ⴶⵔⵓⵏⵢ ⵓⵏ ⴹⵓⵔⵏⴶⵎⵢ ⵙⵏⴼⵍⵍⵗ ⵎⵏⵏ ⵢ ⵓⵏ ⴹⵓⵔⵏⵏ⵿ⵙⵢ ⵓⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ⵎⵛⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ ⴾⵍⵙⵔⵢⵍ ⵏⴰ «ⵤⵍ ⴾⵍ ⵤⵍⵗ ⴼⵙⵏ ⵗⵔⴰ ⵜⵎⵜⵢ ⵜⵎⵙⵜ ⵏⵎⵤⵔⵢ ⵏⴼⵍⴶ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ⵏ ⴹⵗ ⴹⵢ ⵓⴾ ⵎⵛⵏⴰ ⴶⵎⴹ ⴶⴰ ⵀⵜⵓ ⵏ⵿ⵜⵎⵜⵢⵏⵜ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⴼⵍⵙ ⵏⴾ ⵎⵏⵏ ⵢⵏ ⴹⵗ ⴾⵍⵙⵔⵢⵍ ⵎⵙⴰ ⵎⵙⵗ ⵂⵢⴰ ⵏⵀⵔⵂⵎ ⴶⵎⴹⴹⵓ ⵜⵓⵛⵜ ⵜⵏ ⵀⵏⵢⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ⵎⵛⵏⴰ ⵓⵔ ⴶⵎⴹ ⵀⵜⵓ ⵏ⵿ⵜⵎⵜⵢⵏⵜ ⵙ ⵔⵓ ⵙ ⵜⵜⵙⵏⴼⵔⵏ⵰ ⵏ⵿ⴶⵎ ⵜⴾⵜⵓⵎ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⴹⵗ ⵀⵜⵓ ⵏⵏⵀⵢ ⵍⵢⵙ ⵙⵗⴰ ⵓⴹ ⵓⵢ ⵜⵍⵏⵜ ⵙ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⴾⵍⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ⵏⴰ ⵢ ⵎⵛⵏⴰ «ⵎⵍⵢ ⵏ⵿ⵗⵏ ⵏⵀⵜⵏⴾ ⵌⵀⵔⵌⵏ ⴹⴶⵏⴾ ⵓⵏ ⵜⴾⵜⵓⵏ ⵓⵔ ⴹⵆⵎ ⵔ ⵏⴾ ⵎⵔⵏ ⴶⵎⵢⵏ ⴹⵗⵢ ⴾⵙⵏ ⵎⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ⵜⵙⵏⵎ ⵤⴰ ⵓⴰ ⴹⵙⵌⵓⵀ ⵎⵛⵏⴰ⵰ ⵏⵙ «ⵙⵏⴼⵔⵏⵗ ⵢ ⵎⵏⵏ ⵙⴰ ⴶⵎ ⵏⵍⵙ ⵓⵔ ⵏⵙⵌⴹ ⴹⵜ ⵙⵏⵎ ⵓⴰ ⴶⵏ ⵀⵈⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⵗ ⵙ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⵎⵔⴹⴰ ⴶⵍⵤⵏ⵿ⴹⵓ ⵢⵜⴹⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⵙⵔⵈⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⵔⵈⵎⵜⵏⵜ ⵙ ⵜⵏⵙⵏⴼⵔⵏ ⵓⴹⵢ ⵓⵔⴶⵗ ⴼⵍ ⴹⵍⵍ ⵏⵎⵤⵍⵏⵙⵏ ⵎⴹⵗ ⵎⵔⵏ ⵆⵍ ⵙ ⵔⵈⵎⵜ ⵀⵙ ⵜⵎⵙ ⵔⵈⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ⵎⴰ ⴶⵏ ⴹⵗ ⴹⵢ⵰ ⴾⵍⵙⵔⵢⵍ ⵓⵔ ⴶⵔⵓⵏ ⵓⴰ ⴶⵎⵢⵏ⵰ ⵓⵔ ⴹⵗⵙⵏ ⵜⴶⵔⵓ ⵔ ⵓⵏ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ⵰ ⵓⵏ ⵂⴹⵜⵏⵏ ⵎⵔⵏ ⵜⵓⴶⵏ ⵢⵜⴹⵏ ⵙ ⴶⵔⵎⵎⵏ ⵓⵍⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ⵏⵎⵏⴾ ⵓⵏ ⴹⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⴾⵙ⵿ⵜⵏ ⵎⵛⵏⴰ ⴹⵗ ⵍⵈⵢⵔ ⵏⵎⵏⵙⵏ ⴾⴼⵏ ⵛⵜⵓⵏ ⵓⵔ ⵏⵂⵏⵢ ⵓⵍⴰ ⴹⵜⵎⵤⴶⵏ ⵓⵔ ⵏⵙⵍⵓ ⵂⵔ ⵤⵍⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ⵏⵀⵢ ⴹⵓⴹ ⴹⵗ ⵏⴰ «ⵆⵍⵏⵜⵙⵏ ⵎⵏ⵿ⵙⵓⵏⵙⵏ ⵜⴼ⵿ⵜⵓ ⵆⵍⵏ ⵙⵏ⵿ⴶⵢ ⵜⵏ⵿ⵤⵀⵤⵏ⵰ ⵆⵍⵏⵜⵙⵏ ⴶⴹⵍ ⴶⵔⵓⵏⵜ ⵜⴹⵀ ⵓⴰ ⴹⵔ ⵂⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ⵍⵙⵏⵜ ⵛⵢⵢ ⵛⵜⵓⵏⵙⵏ ⴶⵎⴹⵜⵏ ⵙⵓⴹⵏⵙⵏ⵰ ⴾⵔⵏⵀⵓⵏⵜ ⵔⵔⵏⵙⵏ ⵂⵔ ⴼⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ⵏ ⴹⵗ ⴹⵢ ⵓⴾ ⴾⵍⵙⵔⵢⵍ ⵏⴶⵔ⵿ⵜⵜⴼⵏ ⵢⴹ ⴹⵏ ⵂⵔ ⴼⵓ⵰ ⴶⵎⴹ ⵛⴾ ⵙ ⵓⵔⴶⵗ ⵓⵏ⵰ ⵎⵛⵏ ⵜⵎⵤⵔⵢⵜⵏⵙⵏ ⴹⵜⵓⵢⵜ ⵙ ⴶⵔⵓⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴼⵙⵏ ⴼⵍ ⴹ ⴶⵤⵏⵜ ⵜⵙⵎⵜⵏ ⴾⵍⵙⵔⵢⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ⵓⵍⴰ ⵜⵎⵤⵔⵢⵜⵏⵙⵏ ⵜⵆⵍ ⵜⵏⴼⵍⵢⵜ ⵢⴹⵏⵜ ⵜⵓⵔⵏⵏⵙⵏ ⴹⵗ ⵆⵍ ⵜⵏⴼⵍⵢⵜ ⵢ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⴶⵎ ⵏ ⵤⴰ ⵙ ⴹⵗⵔⴹⵏ ⵙⵏⴹ ⵀⴹⴹⵏ⵿ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ⵎⵔⴹⴰ ⴾⵓⵏⵢ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙ ⵛⵓⵍⴰ ⵏⴾ ⵏⵎⵤⵍ ⵎⵙⴰ ⵙⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⵙⵗⵎⵔⵗ ⵛⵗⵍ ⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ⵂⵔ ⵙ ⵙ ⵎⴾⵏ ⵓⵏ ⴹⵓⵢⴰ ⵛⵙⵎⵜⵏ ⵙⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵛⵜⵏ ⴼⵙⵏ ⴹⵗⵙⵏ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ⴼⵍⵙ ⵙ ⵆⵍ ⵙ ⵜⵓⴾⵙⵏⵙⵏ ⵙ ⵜⵎⴰ ⵓⵢⴹⵓ ⵎⴾⵏⵓ ⴹⵗ ⴹⵏⵜ ⵏ⵿ⴶⵎ ⵏ ⵤⴰ ⵜⵓⵙⵗⵍⵏⵙⵏ⵰ ⵓⵔ ⵜⵍⴰ ⴹⵔ ⵤⵍⵓ ⵔ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⵜⵤⵔⵜ ⴹⵗ ⵜⴶⵍⴰ ⵜⵙⴾⵜ ⵢ ⵎⵛⵏⴰ ⵓⴹⵢ ⵓⴰ ⴹⵗⵙ ⵏⵆⵎⵏ ⴾⵜⵏⵜ ⴹⴰ ⵏ ⵎⵛⵏⴰ⵰ ⵙ ⵎⵙ ⵙ ⴹⵗ ⴾⵓⵏ ⵜⵓⵙⴾⵜⵏ ⵢ ⵎⵛⵏⴰ ⵓⴹⵢ ⵍⴹⵍⴹ ⴹⴰ ⵜⵓⵙⴾⵜⵏⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ⵍⵎⵜⵍⵏ ⴹⵗ ⵂⵏ ⴾⵍⵙⵔⵢⵍ ⵍⴹⵍⴹ ⵓⵢⴹ ⴹⵏ⵿ⵜⵓⴾⵔⵎⵜⵏⵏ ⴹⵗ ⵛⴾ⵰ ⴾⵢ ⵎⵔⵏ ⵓⴰ ⵓⵔ ⵏⵎⵙ ⵢⵏ ⴹⵗ ⴾⵍⵙⵔⵢⵍ ⵜⵎⵙⴰ ⵤⵏ ⵍⴹⵍⴹ ⵏ⵿ⵤⵢⵜⵏ ⵏⵙⴼ ⵜⵤⵔ ⵜⵜⵓⴶⴰ ⴹⵗ ⴹⴶⵏⵙⵏ⵰ ⴹⵗ ⴹⵢ ⴾⵢ ⴹⴰ ⵜⴹⵔⵓⴰ ⴹⵔⵙⵏ ⵙⴹⵔ ⵍⵗⵏⵏ ⵓⵏ ⴹⵏⴾⵙⵏ ⴾⵓⵏ ⵏⵤⵢⵜⵏ ⵓⴰ ⵜⵓⵏⵀⵍⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴹ ⵓⵔ ⵜⵍⴾⵗ ⵍⴹⵍⴹ ⵓⵏ ⴹⵏ⵿ⵜⵓⴾⵔⵎⵜⵏⵏ⵰ ⵎⵔⵏ ⵙ ⴾⵢ ⴹⵜⴶⵤ ⵏⵢⵜ ⵏ⵿ⵤⵤⵓⵔ ⵏⵎⵏⴾ ⵜⴾⵜⴹⵓ ⵙ ⵓⵔⴶⵗ ⴾⵢ ⵍⵏ ⴾⵓⵏ ⴾⵍⵔ ⴾⵓⵏ ⴾⵢⵓⵢⵏⵏ ⴾⵀⵍⵏ⵿ⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ⴹ ⵜⵏⴰ ⴹⵗ ⴹⵢ ⵍⴹⵍⴹ ⵜⵓⴾⵔⵎⵏⵏ ⴼⵍ ⴹ ⴶⵤⵗ ⴹⴶⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ⵜⴹⵜ ⵙ ⵜⵓⴾⵔⵎⴰ ⴹⵏⴶⵏ ⵍⴹⵍⴹ ⵓⵏ ⴹⵏ ⴼⵍ ⵀⴰ ⵏⵤⴶⵤⵏ⵰ ⴾⵢ ⵎⵔⵏ ⵜⴹⵔⴰ ⵙⵤⴶⵤⵏⴾ⵰ ⴹ ⵓⵔ ⵜⴶⵗ ⵎⴹⵔⵏⵏ ⵎⵙⵏⵏ ⵤⵤⵓⵔ ⵏⵎⵏ ⴾⵍⵔ ⵆⵍ ⵎⴾⵙⴹ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ⴼⵍⵙ ⴹⴹ ⵤⵎⵙ ⵎⵛⵏⴰ ⵓⵔ ⵢⴰ ⵍⴹⵍⴹ ⵓⵏ ⴹⵔ ⴹⵈⵍⴾ ⵛⴾ ⵓⴹⵢ ⴾⵢ ⴹⴰ ⵓⵔ ⴾⵢⵤⵢⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ⴹⵗ ⴹⵢ ⵙⵏ ⴼⵍ ⵍⵗ ⵏⵎⵛⵏⴰ ⴹⵜⵍⵀⵙ⵿ⵜ ⵏⵍⵂⵎⵏⵜ⵰ ⵜⵍⵀⵙ⵿ⵜ ⵏⵍⵂⵎⵏⵜ ⵙⴾⵏⵜ ⵢ ⵓⵏ ⵏⵎⵤⵔⵢ ⵍⵗⵏⵜ ⵎⵔⵏ ⵙⴾⵏⴾⵓ ⴾⵜ ⵜⵤⵤⵓ ⴹⵗ ⵜⵔⵢⵜ ⵏⵍⵗ ⵓⵏ⵰ ⵙ ⵓⵔ ⵜⴶⵗ ⴹⵢ ⵓⴹⵢ ⴾⵢ ⴹⴰ ⴹⵏ⵿ⵜⵜⵓⴾⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ⴾⵍⵍⵢⵂⴹ ⴹⴰ ⵙ ⵢⵏ ⵜⵔⵢⵜ ⵜⵏ ⵀⴰ ⵏⵤⴶⵤⵏ ⴹⵜⵓⵙⵗⵍⵏ ⵛⴾ ⴼⵍⵙ ⵎⵛⵏⴰ ⵍⴰ ⵜⵔⵏⴰ ⵏ⵿ⵜⵏ⵿ⴹⵍⵙ ⵙⵗⵍ ⵏⵛⴾ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ⴹⴹ ⵤⵎⵙ ⴾⵢ ⵜⵜⵓⴾⵔⵎⴹⵓ ⴹⵗ ⵛⴾ ⵏ⵿ⵤⵢⵜⵏ ⵏⵙⴼ ⵜⵜⵓⴶⵗ ⵍⴹⵍⴹ ⵏ⵿ⵤⵢⵜⵏ ⵓⵏ ⵏⵀⵍ ⵍⵗⵏ ⵎⵏⵎⴾ ⵙ ⴹⵓⵔⵤⵜⵓⵙⵗⵍⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵜⵓⴶⵏ ⴹⵗ ⵤⵢⵜⵏ ⵓⴰ ⴹⵗ ⴹⵈⵍⴾⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ⵎⴹⵔⵢⵏⵏ ⵓⵔ ⵔⵗ ⴹⵓⵏⵌⵂⵍ ⵙⵔ ⵓⴰ ⴼⵍ ⴹ ⵓⵔ ⵜⵗⵍⵎ ⵜⵍⵎ ⵎⵙⵏⵜ ⵢⵜ ⵤⵓⵔⵜ⵰ ⴹⵙ ⵏ⵿ⴾⵍⵙⵔⵢⵍ ⵓⵔ ⵤⵎⵤⵢⵏ ⴹ ⴼⵍⴶⵏ ⴾⵜ ⵓⵔ ⴹⵈⵙⵍⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙ ⵜⵗⵎⵔ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ⵎⴾⵏ ⴹⵗ ⵙ ⵤⴶⵔⵓ ⵙⵔⵢⵍ ⴾⵜⵏⵜ ⴼⵙⵏ ⴹ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴰ ⵗⵍⵙⵏ ⴹⴶⵎⴹ ⵙⵢⵏ ⴾⵙ ⵏⵎⵤⵔⵢ ⴹⵗ ⵤⵔⵢⴰ ⵏⵢⵆⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⵔⴾⵓⵍ ⵓⴰ ⴹⵔⵙⵏ ⵤⴶⴰ ⵙⵗⴰ ⵓⴰ ⴼⵍⵙⵏ ⵤⴾⵙⵗ ⵀⴾⴹⵏⵙⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⴶⵢⵜⵏⵙⵏ ⵙⵍⵏ⵿ⵌⵍ ⵓⴹⵢ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵤⵏ⵿ⴶⴰ ⵏⵎⵛⵏⴰ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⵜⵏ⵿ⴼⴰ ⵏⵓⵏ⵰ ⵎⵛⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵏⴼⵔⵏ ⵓⵏ ⵎⵛⵏⴰ ⵓⴹⵢ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵏⴰ ⵎⵛⵏⴰ ⵜⵔⴰ ⴼⵍ ⴹⵍⵍ ⵏⵎⵔⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ⴼⵍⵙ ⵎⵛⵏⴰ ⵓⵔ ⴹⵜⵆⵍ ⴹⵗ ⵜⵂⴾⵜⵏⵜ ⵤⴰ ⵓⵔ ⵙⵎⵜⵢ ⵏⴼⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹⵜ ⵓⴰ ⵜⵎⵤⵔⵢⵎ ⵎⵛⵏⴰ ⵎⵛⵏ ⵎⵔⴹⴰ ⵂⵏⵜⵜⵓⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵎⵤⵔⵢⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⵗ ⵙ ⴹⴹ ⵤⵎⵙ ⵜⵎⵤⵔⵢⵜⵏⵙⵏ ⵜⵏ ⵎⵔⴹⴰ ⵜⵓⵢⴹⵓ ⵙ ⵜⴶⵔⵓⵎ ⵂⵏⵜⴰ ⵔⵜ ⵓⴹⵢ ⴶⴰ ⴼⵍ ⴹⵙⵏⵂⵏⵜⵜ ⵎⵛⵏⴰ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ⴼⵍⵙ ⵎⵛⵏⴰ ⵜⴼ ⵢⵜⴹⵏ ⴾⵍ ⴹⵗ ⵜⵎⵤⵔⵢⵜ ⴼⵍ ⵜⵏⵙⴾⵏⵓ ⴾⵜⵏⵙⵏ ⵜⵂⵏⵏ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ⵢⴰ ⵎⵛⵏⴰ⵰ ⵜⴶⵔⴶⵙ⵿ⵜⵏⴾ ⴹⵜⵢⵜⵢⵏⴾ ⴹⵎⵙⵏⵜⵏⴾ ⵓⵔ ⵍⵏⵜ ⴹⴾⴹ⵰ ⵍⵈⴾⵎⵏⴾ ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⵛⴶⵔⵏⵙⵏ ⵜⵔⵢⵏⴾ ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⴶⵔⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«ⵎⵏⵢ ⵓⴰ ⵙⵏⵏ ⵓⴰ ⴹⵗ ⵙⵎⴹⵔⵏ ⵎⵍⵢ⵰ ⵎⵏⵢ ⵓⵙ ⴾⵍⴰ ⴹ ⵆⵍ ⵎⵛⵓⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ⵎⵏⵢ ⵓⵙ ⴾⵍⴰ ⴹ ⴶⴰ ⵢ ⵎⵛⵏⴰ ⵜⵏⴼⵙ⵿ⵜ ⵏ⵿ⴶⵎ ⵆⵍ ⵙ ⵔⵓⵙ⵿ⵜⵓ ⵜⵏⴼⵙ⵿ⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ⵔⵜ ⴾⵍ ⵏ⵿ⵜⴰ ⴹⴼⵍ ⵏ⵿ⵜⴰ ⴹⵓⵢⵏ ⵙ ⵜⵎⵍ ⵔⵜ ⴾⵍ ⵏ⵿ⵜⴰ ⴹⵗ ⵍⵏ ⵔⵜ ⴾⵍ⵰ ⴶⵔⵓⵜ ⵎⵛⵏⴰ ⴹⴾⵍ ⴹⵗ ⵤⵎⵏ ⴾⵍ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ⴹⵗ ⴹⵢ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⴼⵍ ⵜⵛⵜ ⵜⴰ ⴶⴰ ⵎⵛⵏⴰ ⵎⵂⵏⵏ ⴹ ⵜⴾⴼⵎ ⵛⵗⵙⵓⵏⵓⵏ ⵆⵍⵏⵜ ⵜⴾⵜⵢ ⵜⴹⵔⵜ ⵤⴹⴶⵜ ⵜⴶⵔⵤⵜ ⵢ ⵎⵛⵏⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵤⴰ ⵜⴶⵎ ⵢ ⵎⵛⵏⴰ ⵍⵗⵀⴹⴰ ⵓⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ⴹ ⵓⵔ ⵜⵢⵎ ⵎⵏⵓⵏ ⵙⵎⵜⵢⵏ⵿ⴾⵓⵏ ⵤⵎⵏ ⵓⵏ ⵏⵂⴰ ⴹⴰ ⵎⵔⴹⴰ ⴾⵍⵔ ⵢⵓⵜ ⵎⵏⵓⵏ ⴾⵓⵏ⵿ⵜⵛⵛⵏⵢ ⵜⵢⵜⵢⵏⵓⵏ ⵜⴰ ⵜⵢⵏⵢⵜ ⴼⵍ ⴹ ⵜⴶⵔⵎ ⵜⵔⴹⵎ ⴹⵗ ⵙⵔⵜ ⵓⴰ ⵎⵙⵏ ⵜⵔⴰ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵏ ⵓⴰ ⵍⵗⵏ ⴹⵓⴰ ⴶⵔⵤⵏ ⵢ ⵎⵛⵏⴰ ⴹⵓⴰ ⴾⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ⵔⵜ ⴹⴰ ⵓⴰ ⴶⵏⴰ ⵢⴾⵢⵏ ⴹⵗⵓⵏ ⵙⵙⵀⵀ ⵏⵔⵈⵎⵜ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵤⵤⵓⵔⵏⵏ ⵎⵏⵙⵏ ⴾⵍⵔ ⴶⵓⵜ ⵢ ⵎⵏⵓⵏ ⴹⴼ ⴶⵏ ⵙⵏⵢⵜ ⵜⵍⵗⵜ ⵓⵍ ⵓⵏ ⵙⵤⴶⵤⵏ ⵓⴰ ⴾⴼⴰ ⵎⵛⵏⴰ ⵢⴾⵢⵏ ⴹⵗⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ⴾⵢⵏ ⴹⵗⵏⴰ ⵜⵗⵙⴰ ⵢⴹⴰ ⵍⴰ ⵎⵛⵏ ⵜⴶⴰ ⴹⵗ ⵜⵙⵍⴹ ⴶⵜⵏⵏ ⵎⵔⵏ ⵛⵙⵍⴹ ⵛⵏ ⴹⵏ ⴾⵢⵜ ⴹⵛⵗⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ⵎⴾⵏ ⴹⵗ ⵙ ⵏⴾⵏⵢ ⵏⴶⵜ ⵎⵛⵏ ⵜⵗⵙⴰ ⵢⴹⴰ ⵏⵎⵙ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⴹⵍⵎⵙⵈ ⵎⵔⵏ ⴾⵢⵏ ⴹⵗⵏⴰ ⵎⵙ ⵜⵙⵍⵜ ⴹⵗ ⵍⵌⵎⵗⵜⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ⵎⵛⵏ ⵏⴶⵔⵓ ⵛⵂⴾⵜⵏ ⵓⵔ ⵏⵍⴰ ⵓⵍⵏⵏ ⵙⵔⵈⵎⵜ ⵜⴰ ⵜⵜⵓⴾⴼⵜ ⴾⵢⵏ ⴹⵗⵏⴰ⵰ ⵙ ⵎⵙ ⵙ ⴶⵔⵓ ⵢⵏ ⴹⵗⵏⴰ ⵜⵂⴾⵜ ⵏⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⴼⵍⵙ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵛⵛⵗⵍⵜⵜ ⵓⵍ ⵓⵏ ⵙⵓⴰ ⴹⵔ ⴶⴹⴰ ⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ⵓⵙ ⵜⵂⴾⵜⵏⵜ ⵜⴹⵂⵍ⵿ⵜ ⵏⵢⵜⴹⵏ ⴹⵂⵍⵜⵏ⵰ ⵓⴰ ⴶⵔⵓⵏ ⵜⵂⴾⵜ ⵏⵙⵙⵗⵔⵢ ⵙⵙⵗⵔⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ⵓⴰ ⴶⵔⵓⵏ ⵜⵛⵜ ⵏⵓⴹⵏ ⵜⵍⵎⵏ ⵢⵢⵜⴹⵏ ⴼⵍ ⵎⵏ ⵎⵤⵍⵜ ⵙⵓⵏ⵰ ⵓⴰ ⴶⵔⵓⵏ ⵜⵛⵜ ⵏⵓⴹⵏ ⵜⵂⴰ ⵜⵂⴾⵢ ⴾⴼⵜ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ⵰ ⵓⴰ ⴶⵔⵓⵏ ⵜⵤⵔ⵿ⵜ ⴶⵓⵜ ⵜⵤⵔ⵿ⵜ ⵏⵍⵎⵈⵙⴹ⵰ ⵓⴰ ⵜⵙⵏⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵎⵗⵜⵔⵏⵏ ⵙⵏⵜ ⴹⵗⵙⵏ ⵙ ⵎⵏ ⴼⵍⵓⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ⵜⵔⴰ ⵜⵜⵓⵔ⵿ⵜⴶⵤ ⵜⵍⵎⵏⴼⵆⴰ⵰ ⴾⵢⴹⵜ ⵔⵜ ⴾⵍ ⵓⴰ ⵎⵙⵏ ⵜⴾⵎⴰ⵰ ⵤⵤⵓⵜⵜ ⵓⵍⵏ ⴹⵗ ⵎⵤⵍ ⵏⵓⴰ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵔⴰ ⵜⴰ ⴶⵔ ⵎⴹⵔⵢⵏ ⴾⵢⵏ ⴹⵗⵓⵏ ⴾⵏⵓⵜ ⵜⵔⴰ ⵏⵓⵏ ⵂⴹⵜⵏⵏ⵰ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵙⵗⵎⵔ ⵤⵤⵔⵜ ⵜⵏ⵿ⴼⴰ ⵜⵏ ⵎⴹⵔⵢⵏⵓⵏ ⵢ ⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵛⵗⵍ ⵆⵍⵜ ⵎⵛⵗⵍⵏ ⵓⵔⴶⵗ ⵎⵙⵏ⵿ⴹⴹ ⵜⵎⵂⵏ⵿ⴹⵔⵜ ⴹⵗⵓⵏ ⵜⵎ⵿ⵙ ⵜⴰ ⵜⵜⴾⵙⵜ ⵙⵏ⵿ⴹⴹ ⴰ ⵜⵜⵎⵙⵏ ⵜⵏ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵜⵗⵀⴹⵎ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⴶⵢ ⵏⵜⵎⴰ ⴼⵍⵓⵙⵜ⵰ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵙⵙ⵿ⵜ ⵆⵍⵜ ⵎⵤⵤⵢⴹⵔ⵰ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵛⵓⵜⵔⵓⵏ ⴹ ⵓⵔ ⵜⵎⵤⵢⵎ ⴹⴶⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ⴹⵂⵍⵜ ⵎⵤⴹⴶⵏ ⴹⵗ ⴹⵔⵔⵜⵏⵙⵏ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵂⴰ ⵎⴶⵔⵓ ⴼⵓⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ⵜⵜⵔⵜ ⴶⵏ ⵍⵀⵔⴾⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⴹⴶⵤⵏⵏ⵰ ⴹ ⵓⵔ ⵜⵍⵗⵏⵎ ⵓⴹⵏ ⵓⵍⵢⵏ ⴾⵍⵔ ⵜⵜⵔⵜ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ⵙ ⵜⴶⵤⵎ ⵢⵜⴹⵏ ⴼⵍⵓⵙⵏⵏ ⵜⴼⵍⵓⵙⵎ ⴾⵓⵏⵢ ⴹⴰ ⵙ ⵜⴶⵤⵎ ⵓⵏ ⵂⵍⵏⵏ ⵜⵍⵎ ⴾⵓⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ⵏⵎⴶⵓⵜ ⴹⴼ ⵢⵏ⵿ⴹⴰ ⴶⵔⵓⵏ⵰ ⴹ ⵓⵔ ⵜⴶⵎⵢⵎ ⵍⵎⵆⵎ ⵢ ⵎⵏⵓⵏ ⴾⵍⵔ ⴶⵎⵢⵜ ⵓⴰ ⵓⵔ ⵏⵍⴰ ⵏⵢ⵰ ⴹ ⵓⵔ ⵜⴶⵎ ⴹⴼ ⵏⵙ ⵜⵎⵙⵎ ⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ⴹ ⵓⵔ ⵜⵤⵍⵎ ⵜⴾⵎⴰ ⵙ ⵜⴾⵎⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ⵰ ⴶⵎⵢⵜ ⵓⴰ ⵍⵗⵏ ⵗⵔ ⵢⵜⴹⵏ ⴾⵍ ⵙⵔⵙ ⵜⵜⵎⵤⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ⵙ ⵎⴾⵏ ⵓⵏ ⴾⵜ ⵆⵏ ⴹⵗⵓⵏ ⴹⵢ ⵎⵍⵜⵓ ⵍⵈⵔ ⴶⵔⵓⵏ ⴹⵓⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ⴹ ⵓⵔ ⵜⵤⵤⵍⵎ ⵢ ⵎⵏⵓⵏ ⵎⵔⵏⵏ ⴾⵍⵔ ⵢⵓⵜ ⵍⵂⵎ ⵓⵏ ⵎⵛⵏⴰ ⴹ ⵛⵗⵍ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵏⴾ ⵜⵀⵤⵏ ⵙⵛⵔⵗⴰ ⵏⴾ ⵤⵈⴾⵎⵏ ⵢⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵔ ⵂⵔ ⵏⴰ ⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ⴾⵓⵏⵢ ⵎⵔⵏ ⵔⵜ ⴹⴰ ⵓⴰ ⴾⵓⵏⵓⵔⵏ «ⵙ ⵜⵏⵢⵗ ⵤⵏ⵿ⴶⵓⵏⴾ ⵂⵢ ⴶⵍⴾ ⵜⵛⵜⵛⵆⵓ⵰ ⵙ ⵜⵂⴰ ⴼⴹ ⴹⵗ ⵜⵛⵛⵓⵆⵓ⵰ ⴼⵍⵙ ⵙ ⴹⵙ⵿ⵜⴶⵗ ⴹⵢ ⵤⵏ ⵙ ⵜⵙⵏ⵿ⵙⴰ ⴼⵍ ⵗⴼⵏⵜ ⵛⵎⴾⵜⵏ ⵔⵗⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ⴹⴾⵓⵔⵍⴾⵎ ⴹ ⵜⵢⵗ ⵛⵔ ⵙⴼⵍⴹⵓ ⴹⵏⴶⴾ ⴾⵍⵔ ⵗⵍⵀ ⵛⵔ ⵙⵎⵤⵍ ⵏⵓⴰ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ⵓⴹⵏ ⴾⵍ ⵍⵤⵎ⵿ⵜⵓ ⵀⵔⴹⴶ ⵢ ⵎⵤⵔⵏ ⵏⴾⵍ ⴼⵍⵙ ⵜⵗⵎⵔ ⴾⵍ ⵎⵛⵏⴰ ⴹⵜⴼⵍ⵰ ⵜⵗⵎⵔⵏ ⴾⵍ ⵛⵏ ⵜⵍⵏⵏ ⵎⵛⵏⴰ ⵜⵏⵜⵙⵀⴹⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⴼⵍⴶⵏ ⴼⵍ ⵍⵈⴾⵎ ⵏⴾⵍⵏⵜ ⵓⴹⵏ ⵓⴹⵢ ⵏⵤⵎ ⵏⵎⵛⵏⴰ ⴼⵍ ⴼⵍⴶ⵰ ⵓⵏ ⴼⵍⴶⵏⵏ ⴹⵗ ⴹⵓⵢⵏ ⵜⴹⵀ ⵙ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ⵎⵤⵔⵏ ⵓⵔ ⵜⵏⴾⵙⴹ ⵓⴹⵏ ⵓⴰ ⵜⴶⵏ ⵓⴰ ⵍⵗⵏ ⴾⵍⵔ ⵓⵔ ⵜⵏⴾⵙⴹ ⵔ ⵓⴰ ⵜⴶⵏ ⵜⴾⵎⴰ⵰ ⵙ ⵜⵔⵗ ⴾⵢⵜⴶⵎⴹ ⵜⵙⴰ ⵏⵎⵤⵔⵏ ⴹ ⵜⵜⵎⵤⵍⵗ ⵓⴰ ⵍⵗⵏ ⴹⵢ ⵗⵔⵙⵏ ⵜⴶⵔⵓⵗ ⵍⵆⵀⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ⴼⵍⵙ ⵎⵤⵔⵏ ⵏⴾⵍ ⵛⵗⵍ ⵏⵎⵛⵏⴰ ⵂⵏ ⵎⵙⵏ ⵜⵏ⵿ⴼⵏⴾ⵰ ⵎⵛⵏ ⵙ ⵜⵜⴶⵗ ⵓⴰ ⵓⵔ ⵏⵍⵗ ⵓⴹⵢ ⴾⵙⴹ ⵎⵤⵔⵏ ⴼⵍⵙ ⵓⵔⴶⵗ ⵀⵏⵏ ⵍⵏ ⴼⵔⴶⵜ ⵏⵜⴹⵀ ⵙ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵎⵛⵏⴰ ⵛⵛⵗⵍⵏ ⵎⵤⵔⵏ ⴼⵍ ⴹ ⵜⵓⴹⵀⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⵎⵤⵍⵏⵏ ⵜⴾⵎⴰ ⵓⵢⵏ⵿ⴹⵓ ⵙ ⵎⵏⵙⵏ ⵍⵂⵎ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵙⴹ ⵀⵔⴹⴶⵏ ⵢⵜⴹⵏ ⵢ ⵎⵤⵔⵏ⵰ ⵓⵔⴶⵗ ⵜⴾⵙⴹⴰ ⵏⵜⴹⵀ ⵗⵙ ⴼⵍ ⴹⵏⵗⵍⵤⵎ ⵓⵏ ⴾⵍⵔ ⵏⵢⵜⵏⵏⵗ ⴹⵏⵜⵜⵤⵍⵤⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ⴹⵍⵍ ⵏⵓⵏ ⴹⵗ ⴼⵍ ⵜⵔⵤⵎⵎ ⵎⵏⴰ ⴼⵍⵙ ⵓⵏ ⵜⴶⵔⵓⵏⵏ ⴹⵏ ⵎⵛⵏⴰ ⵜⵏⵛⵛⵗⵍⵏ ⴼⵍ ⴹ ⵙⵏⵂⵍⵏ ⵎⴾⵏⵓ ⵏⵛⵗⵍ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ⵔⵤⵎⵜ ⵢⵓⴹⵏ ⴾⵍ ⵓⴰ ⴹⵗⵓⵏ ⵍⴰ⵰ ⵔⵤⵎⵜ ⵎⵏⴰ ⵢ ⵓⴰ ⴹⵗⵓⵏ ⵜⵍⵏ ⵜⵔⵤⵎⵎ ⵜⴾⵙ ⵢ ⵓⴰ ⴹⵗⵓⵏ ⵜⵜⵔⵏ ⵜⴾⵙⴹⵎ ⵓⵙ ⴾⵓⵏ⵿ⵜⵓⵔ ⵜⴾⵙⴹⵏⵜ ⵜⵙⵗⵎⵔⵎ ⵓⵙ ⴾⵓⵏⵓⵔ ⵙⵗⵎⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ⵜⵓⵔⵎⵍ ⵓⵍⵢⵏ ⴹⵗⵓⵏ ⵜⵓⵔⵓⵙⵏ ⵔⵜ ⵆⵍ⵰ ⵜⵓⵔⵎⵍ ⴶⵔⵓⵏ ⵔ ⵏⵎⵔⴰ ⴹ ⵓⴹⵏ ⵓⴰ ⵔⵏ ⵢⵜⴹⵏ ⵓⴹⵢ ⵙⵏ⵿ⴹⴹⵓ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ⴼⵍⵙ ⵍⵓⵌⵀⵏ ⵤⵏ ⵓⵏ ⵏⵏⵏ «ⴹ ⵓⵔ ⵜⴶⵗ ⵤⵏⴰ ⵓⵍⴰ ⵜⴶⵗ ⵎⵏ ⵓⵍⴰ ⵜⴾⵔⴰ ⵓⵍⴰ ⵜⴶⵗ ⵜⵎⵏⴾ ⴹⵗ ⵔⵙ ⵏⵓⴹⵏ» ⴹⵍⵓⵌⵀⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵈⵙⵍⵏ⵿ⴹⵓ ⴹⵗ ⵍⵓⵌⵀ ⵢⵏ⵿ⴹⴰ ⵓⴰ ⵏⵏ «ⴶⵓ ⵢⵛⵆⵗⵏⴾ ⵜⵔⴰ ⵜⴰ ⵜⴶⵗ ⵢ ⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ⵓⴹⵏ ⵔⵏ ⵛⵆⵗⵏⵜ ⵓⵔ ⵍⴾⵎ ⴹⵙⴶⴰ ⵜⴾⵎⴰ ⵓⵍⵢⵜ⵰ ⴹⵗ ⴹⵢ ⵜⵔⴰ ⵜⵙⵏ⵿ⴹⴹⵓ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ⴹⵗ ⴹⵢ ⵍⵓⵆ ⵓⴹⵓ ⵎⵔⴹⴰ ⵓⴰ ⴹⵆⵓⵏ ⵓⵔ ⴹ ⵜⵏ⵿ⴾⵔⵎ ⴹⵗ ⵜⵙ ⴼⵍⵙ ⴼⵙⵏ ⴶⵔ ⵂⵤ ⵓⴰ ⴹⵏⴹⴶⵏ ⵎⵔⴹⴰ ⵢ ⵓⴰ ⴹⵏⴹⴶⵏ ⵙⵗⴰ ⵓⴰ ⴹⵏⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ⵂⴹ ⴶⵍⴰ ⵤⵍ ⵂⵤⴹⵓ⵰ ⵎⵤⵢⵜⵏⴰ ⴹⵗ ⴹⵢ ⴹⵎⵤⵍⵏ ⵓⵏ ⵛⵢⵢ⵰ ⵜⴼⵜⵏⴰ ⵜⵤⵍⵢ ⵜⵏ ⵏⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ⵛⴾⵍⵜⵏⴰ ⴹⵗ ⵤⵀⵏ ⵤⵏ ⵙ ⵏⵌⵓⵏ⵿ⴾⵜ ⵤⵍ ⵎⵍⵏ⵰ ⴹ ⵓⵔ ⵏⵙⵙⴾⵢ ⴹⵗ ⵜⵜⵢ ⵓⵍⴰ ⵜⵙⵢ ⵏⵙⵎⴹ⵰ ⴹ ⵓⵔ ⵏⵜⴶⵓ ⵤⵏⴰ ⴹⵎⵤⵍⵏ ⵤⵤⵍⵜⵏⵏ ⴶⴹⵎ ⵏⵏⵎⴶⴶ ⴹⵜⵎⵤⵗⵏ ⴹⵎⵏ⵿ⵤⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ⴾⵍⵔ ⵜⵆⵍⵜ ⵜⵀⴹⵆⵏⵓⵏ ⵍⵈⵍ ⵓⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⴹ ⵓⵔ ⵜⵢⵎ ⵜⵔⵢⵜ ⵓⵍⵢⵜ ⵢⵔⴾ ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ ⵏⴹⵏ ⴹⵗⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ⵆⵀⵍⵜ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵔⴾⵎ ⵤⴶⵤⵏⵙⵏ⵰ ⴹⵔⵙⵏ ⵓⵔ ⵜⵜⵎⵤⵗⵎ ⴹⵗ ⵀⵜⵓ ⵏⴹⴼⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ⵓⴹⵏ ⵢⵏ ⴶⴰ ⴹⴼ ⵏⵙ ⵜⵈⵍⵍⵙ ⵜⵜⵢ ⵏⵔⵜ ⴾⵍ⵰ ⵢⵏ ⵙ ⵔⴾⵎ ⵤⴶⵤⵏⵜ ⵓⵔ ⴹⵙⵈⵍⵍ ⵔ ⵜⵜⵢ ⵏⵏⵀⵜⵏ ⵓⵏ ⴼⵔⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ⵓⴰ ⵜⵜⵏ ⵎⵏ⵿ⵙⵢ ⴹ ⵓⵔ ⵍⴾⵓ ⵓⴰ ⵜⵓⵔⵏⵜⵜⵓ⵰ ⵓⴰ ⵓⵔ ⵏⵜⵜⵓ ⵎⵏ⵿ⵙⵢ ⴹⵗ ⴹ ⵓⵔ ⵙⵓⵔ ⵍⵂⵏ ⵢ ⵓⴰ ⵜⵜⵜⵏ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵆⵀⵍ⵿ⵜⵓ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ⵎⴰ ⵜⵎⵙⵗ ⵙ ⵜⵈⴾⵎⴰ ⵢⴾⵍⵢ ⵏⵓⵢⴹ⵰ ⴶⵔ ⵀⴹⴹ ⵓⵍⴰ ⴹⴰ ⴹⴰ ⵎⵛⵙ ⵜⵆⵍ ⵀⵜⵓ ⵜⵏ⵰ ⵎⵛⵏ ⵓⵔ ⵤⴹⵓ ⴾⵍⵔ ⴹ ⵀⴹⴹ ⴼⵍⵙ ⵎⵍⵢ ⵍⴰ ⴼⵔⴶⵜ ⵏⴾⵀⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ⵓⴹⵏ ⵢⵏ ⴶⴰ ⴹⴼ ⵏⵙ ⵤⵍ ⵢⵏ ⴶⵔ ⵌⵍⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵢⵏ ⴶⴰ ⴹⴼ ⵏⵙ ⵌⵍⵏ ⴾⵍ ⵍⵏ ⴶⴹⵏ⵰ ⵓⴹⵏ ⴾⵍ ⵓⵔ⵿ⵜⵓ ⴾⵙ ⵏⵛⴾ ⴹⵗ ⴹⴼ ⵓⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ⵓⴹⵏ ⵓⴰ ⵤⵍⵢⵏ ⵌⵍⵏ ⵎⵍⵢ ⴼⵍ ⴶⴰ ⵓⵏ⵰ ⵓⴰ ⵜⵜⵏ ⵎⵏ⵿ⵙⵢ ⵓⵙ ⵔⴰ ⴹⵗ ⵎⵍⵢ ⴼⵍ ⴶⴰ ⵓⵏ ⴼⵍⵙ ⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵜⵜⵓ⵰ ⵓⴰ ⵙⵀⵏ ⴼⵍ ⵎⵏⵜ ⵎⵏ⵿ⵙⵓⵏ ⵓⵢⴹ ⴹⵗ ⵎⵍⵢ ⴼⵍ ⴶⴰ ⵓⵏ ⴹ ⵏ⵿ⵜⴰ ⴹⴰ ⴶⴹⵢ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ⵙⵏⵜ ⵙ ⵓⵔ ⴹⵏⵗⵂⴰ ⵢ ⴹⵔⵏ ⴼⵍ ⴹⵍⵍ ⵏⵎⵏⵜ ⵓⵍⴰ ⴹⵗ ⵢ ⵜⵀⴰ ⴼⵍ ⴹⵍⵍ ⵏⵎⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ⴼⵍⵙ ⵙ ⵏⴹⵔ ⵓⴹⵢ ⵎⵍⵢ ⴼⵍ ⵏⴹⵔ ⵙ ⴹⵏⵗⵀⴰ ⴹⵗ ⵎⵍⵢ ⴼⵍ ⴹⵏⵗⵀⴰ⵰ ⴶⵔ ⵤⴰ ⵏⴹⵔ ⵓⵍⴰ ⴹⵗ ⵀⵏⴰ ⵎⵍⵢ ⴹⵏⵗⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ⴼⵍⵙ ⵍⵎⵙⵈ ⵀⵜⵓ ⵆⵍⴹⵓ ⵜⵎⴹⵔ⵿ⵜ ⴼⵍ ⴹ ⵆⵍ ⵎⵍⵢ ⵏⵓⵏ ⵀⴰ ⴹⵓⵏ ⴹⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ⵎⵔⵏ ⴾⵢ ⵎⴼⵍ ⵜⵈⴾⵎⴰ ⵢⵎⴹⵔⵢⵏⴾ ⵎⴹⵗ ⵜⵍⴾⵆⵓ⵰ ⵓⴾ ⵓⵔⴶⵗ ⴾⵜⵏⵏⴰ ⴾⵏ⵿ⴹⵀⴰ ⵏⵀⴹⴹ ⴹⵜ ⴹⴶ ⵏⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵏⴰ ⵎⵛⵏⴰ \"ⵏⴾ ⴹⵔⴰ ⵢ ⴹⵈⵍⴾⵏ ⴾⵍ ⴾⵏ⵿ⴹⵀⴰ ⵙⵌⴹ ⴹⵜⵢ ⵍⵙ ⴹⵗ ⴾⵍ ⴾⵏ⵿ⴹⵀⴰ ⴶⴰ ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ⵎⴾⵏ ⴹⵗ ⵙ ⴾⵢⵏ ⴹⵗⵏⴰ ⴾⵏ⵿ⴹⵀⴰ ⵀⴹⴹ ⴼⵍ ⵎⵤⵍⵏⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ⴹⵗ ⴹⵢ ⵎⵤⵢⵜⵏⴰ ⴹⴹ ⵏⵈⴾⵎ ⵎⴹⵓⵏⵏⴰ⵰ ⴾⵍⵔ ⴾⵢⵏ ⴹⵗⵓⵏ ⴹⴶⵤⵜ ⴹⵗ ⴹ ⵏ⵿ⴾⴹ ⵢⵔⵜ ⵤⵙⵏⴶⵔ⵿ⵜⴼⵜⵏ ⵎⴹⵏⵜ ⵎⴹⵗ ⴶⴹⵍⵢ ⴹⵗ ⵍⵈⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ⵙⵏⵗ ⵎⵔⵏ ⴾⵙⵗ ⵛⴾ ⴹⵗ ⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵙ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⵈⵔⵎⵏ⵰ ⵎⵛⵏ ⵙ ⴶⴰ ⵓⴹⵏ ⴹⴼ ⵏⵙ ⵈⵔⵎ ⴼⵍⵙ ⵔⵜ ⵢⵏ ⵓⴹⵢ ⴼⵍⵙ ⵈⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ⵙ ⵎⵙ ⵙ ⵜⵗⵛⴹⴰ ⵎⵏ ⵏⵎⴹⵔⵢⵏⴾ ⴹⵗ ⵀⵜⵓ ⵏⵎⵏ⵿ⵙⵢ ⵓⴹⵢ ⴾⵢ ⵓⵔ ⵜⵛⴾⵍⴰ ⴹⵗ ⵜⵔⴰ⵰ ⴹ ⵓⵔ⵿ⵜⵂⵍⴾⴰ ⵎⴹⵔⵢⵏⴾ ⴹⵗ ⵤⴶⵤⵏ ⴹⵗ ⵀⵜⵓ ⵏⵎⵏ⵿ⵙⵓⵏ ⴼⵍⵙ ⵍⵎⵙⵈ ⵎⵏⵜ ⵙ ⵜⵀⴰ ⴼⵍ ⴹⵍⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵓⵏⵓ ⵔⴾ ⵔⵜ ⵙⵔⵜⵏ ⵓⵏ ⵙ ⵜⴶⵎ ⴹⴼ ⵏⵙ ⵍⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵔ ⵜⵎⵙ ⵜⵜⵢ ⵓⵍⴰ ⵜⵙⵢ⵰ ⴾⵍⵔ ⵜⵆⵜ ⵜⵎⵙ ⴹⵍⵈⵔ ⴹⵜⴼⵍⵓⵙ⵿ⵜ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ⵓⴰ ⵗⵀⴹⵏ ⵍⵎⵙⵈ ⵙⵎⴾ ⵓⴹⵢ ⴹ ⴶⵔⵤ ⵢ ⵎⵛⵏⴰ ⴶⵔⵓ ⴹⵗ ⵜⵓⵙⵗⵎⵔ ⵗⵔ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ⴹⵗ ⴹⵢ ⴶⵎⵢⵜⵏⴰ ⵓⵍⵏ ⵔⵜⵏ ⵓⵏ ⴹⵜⵓⵢⵏⵏ ⵍⵈⵔ ⴹⵓⵏ ⴹⵏⵤⵍⵍⵏⵏ ⵙⴹ ⵙⵂⵜ ⵤⴶⵤⵏⵏⴰ ⴾⵜⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ⴹ ⵓⵔ ⵜⵌⵀⵔⵌⵗ ⵛⵗⵍ ⵏⵎⵛⵏⴰ ⴼⵍ ⵀⵜⵓ ⵏⵎⵏ⵿ⵙⵓⵏ⵰ ⵜⴹⵜ ⵙ ⵎⵏ⵿ⵙⵢ ⴾⵍ ⵜⵈⵍⵍ ⵜⵜⵢⵏⵜ ⵎⵛⵏ ⵜⵈⵔⵎ ⵜⵜⵢ ⵏⵎⵏ⵿ⵙⵢ ⴹⵤⵜⵓⵢⵜ ⴹ ⵏⴶⵔ⵿ⵜⵜⴼ ⵓⴹⵏ ⵢⵏ ⴹⵗ ⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ⵍⵗ ⴹ ⵢⵓ ⵓⴹⵏ ⵜⵜⵢ ⵏ⵿ⵙⵏ ⵢⵓ ⵜⵙⵢ ⵏⵙⵎⴹ ⵏⵍⵗⵏⵀ ⵎⵤⵢ ⴹⵔⵜ ⴾⵍ ⵓⴰ ⵤⵔⵤⵏ ⵤⴶⵤⵏ ⵏⵎⴹⵔⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ⴹⴼ ⵓⴰ ⴹⵗ ⵜⴾⵙⵗ ⵛⴾ ⴹⵗ ⵓⵍⵏⴾ ⵓⴹⵢ ⴶⵢ ⴶⵔⴾ ⴹⵎⵛⵏⴰ⵰ ⵀⵍⵍ ⵓⴰ ⴾⵙⵏ ⵛⴾ ⵙ ⵓⵔ ⵜⵀⵤ ⵛⵔⵗⴰ ⵙⵔⵜ ⵓⵙ ⴶⴰ ⴹⴼ ⵏⵙ ⵏ⵿ⵜⴰ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴶⵏ ⵛⴾ ⴹⵗ ⵓⴰ ⵜⵜⵓ ⵓⴹⵢ ⵀⵤⵜⵓ ⵛⵔⵗⴰ ⴹ ⵓⴰ ⵜⴶⵓ ⵓⵔ ⵏⵎⵏⴾ ⴹⵤⴶⵤⵏⵜ⵰ ⵎⵔⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵏⵎⵏⴾ ⴹⵤⴶⵤⵏⴾ ⵓⴹⵢ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ⵏⴾⵏⵢ ⵙ ⵙⵂⵜ ⵤⴶⵤⵏⵏⵗ ⵜⵓⵔⵏⴰ ⵤⵎⵔⵜ ⵢ ⵓⵏ ⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵙⵏ ⵏⵢⵓ ⴶⵎⵢ ⵏⵔⵜ ⵓⴰ ⵔⵏ ⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ⴾⵢⵏ ⴹⵗⵏⴰ ⵓⵔ⵿ⵜⵓ ⴹ ⴶⵎⵢ ⴹⴹ ⴶⵔⵤ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵔ ⴹⵔⵓ ⵤⴶⵤⵏ ⴹⵗ ⵏⵎⴹ ⵏⵓⴰ ⵍⵗⵏ ⵎⵙ ⵓⵏ ⴶⵎⵢ ⵏⵓⴰ ⵜⵏ⵿ⵤⵛⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ⴼⵍⵙ ⵍⵎⵙⵈ ⴹⴰ ⵓⵔ ⴶⵎⵢ ⵓⴰ ⴹⵙⴶⵔⵤⵏ ⴾⵍⵔ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵔⵀⴹⵏ ⵓⵏ ⴹⴾⵜⵓⴶⵏⵏ ⵆⵍⵏ ⴼⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ⵎⵔⵏ ⵔⵜⵏ ⵓⵏ ⵏⵏ ⵍⴾⵜⵀⵏ ⴹⵜ ⵤⵍ ⴾⵍ ⵜⵓⴾⵜⵀⵏ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵜⵎⴰ ⵓⴰ ⵜⵓⵢⵏ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵤⵎⵔⵜ ⴹⵜⵙⵙⵎⵜ ⵏⵓⵍⵏⵏⴰ ⵛⵏ ⴹⵏⵗⵂⴾⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⴹⵜⴼⵍ ⵤⵎⵔⵜ ⴹⵍⵎ ⴼⵍ ⵎⵏ ⴾⵓⵏⴾⴼⵓ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵜⵏⵎⵔⴹⵎ ⴶⵔⵓⵏ ⴹⵗ ⵜⵍⴾⵎⵎ ⵢⵍⵎⵙⵍ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ⵎⴾⵏ ⴹⵗ ⵙ ⵤⴰ ⵜⴶⵎ ⵜⵎⵍⵏ ⵏ⵿ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⴶⵎ ⵓⵏ ⵙⵏⵎⵏⴾ ⵏⵓⵍⵏ ⴹⵎⵙⵍⵢ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ⵜⵏⵎⵆⵀⵍⵜ ⴶⵔⵓⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⴾⵓⵏⵆⵀⵍ ⵍⵎⵙⵈ ⵜⴶⵎ ⵓⵏ ⴼⵍ ⵙⵗⵎⵔ ⵏ⵿ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ⵍⴾⵏ ⵙ ⵍⵎⵙⵈ ⵆⵍ ⵎⵛⵗⵍ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴼⵍ ⴹ ⵙⵜⴹⵓ ⵔⴾⵓⵍⵏ ⵓⵏ ⴶⴰ ⵎⵛⵏⴰ ⵢⵍⵌⴹⵏⵙⵏ ⵙⴾⵏⵓ ⵙⵓⵏ ⵙ ⵎⵛⵏⴰ ⵜⴹⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ⵙⴹⵓ ⵏ⵿ⵜⴹⴰ ⴼⵍ ⴹ ⴶⵔⵓ ⵎⵛⵏⴰ ⵜⵎⵍⵏ ⵏ⵿ⵜⵏⵢⵏⵜ ⵗⵔ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵂⵏⵏ⵿ⵜⵏⵜ ⵤⵏ ⵓⴰ ⵂⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⵓⵏ ⴹⵗ ⴼⵍ ⴾⵢⵤⵎⵍⴰ ⴹⵗ ⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴶⵗ ⵛⴶⵢⵜⵍⵏ ⵏ⵿ⵙⵗⵎⵔⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ⵏⵏ ⴹⵗ ⵍⴾⵜⵀⵏ «ⵜⵓⵛⵜⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴶⵎⵜ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴰ ⵜⴶⴰ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ⵏⵏ ⴹⵗ «ⴶⵎⵜ ⵜⵎⵍⵏ ⵢⵎⵍⵢ ⴾⵜⵏⴾⵎⵜ ⵜⵓⵛⵜⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵛⵎⵜⵓⵏ ⴾⵍ ⵎⵍⵏⵜⵜⵓ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ⵏⵀⵢ ⵙⵢⵙ ⴹⴰ ⵏⴰ «ⵂⵢⴰ ⵏⵢⵙⵢ ⴹⵙⵓ ⵀⴹⴹ ⵈⴾⵎ ⴼⵍ ⵜⵓⵛⵜⵏ ⵛⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵎⵔⵏ ⴾⵜⵏⵙⵏⵜ ⴹⵗⵙ ⴶⵏⵜ ⵜⵎⵏⵙⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵗⵔ ⴹⴼⵍ ⵜⵎⴰ ⴾⵜⵏⵜ ⴾⵓⵏⴾⴼⵓ ⵜⴼⵍⵓⵙ⵿ⵜ ⴹⵍⵈⵔ ⴾⵎⵍⵏⵏ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏⵓⵏ ⴼⵍ ⴹ ⵜⵙⵏⵂⵍⵎ ⴶⵔⵓ ⵏⵜⵎⴰ ⵙ ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⴾⵓⵏ⵿ⵜⵆⵍⵜ ⴾⵓⵏⵢ ⵏⴾ ⵎⵏⵏ ⴾⵙⵗ ⵛⴾ ⵎⴹⵔⵢⵏⵏ ⵙ ⵜⴾⵏⵎ ⵍⵗ ⵜⴾⵏⵎ ⴶⵔⵓ ⵏⵎⵙⵏⵜ ⵜⴼⵔⴶⵎ ⴹ ⵜⵜⵏⵎⵙⵙⵗⵔⵎ ⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴾⴹ ⵔⴰ ⵏⵗ ⴾⵜⵀⵗⵓⵏⵏ ⵙ ⵜⵂⵍⵜ ⴼⵍ ⴾⵓⵏ⵿ⴹⵙⴾⵜⴰ ⵙ ⵜⵔⵢⵜ ⵏⵔⵈⵎⵜ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ ⵔⵜ ⵙ ⴾⵍⴰ ⴹⴰ ⵜⵙⵏⵎ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ⵔⵈⵎⵜ ⵜⵏ ⵜⵎⵙ ⵙ ⴹⴶⴰ ⵎⵛⵗⵍ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⵜⴶⵗ ⵛⵗⵍ ⵤⴹⴶⵏ ⵙⵎⵍ ⵓⴰ ⵜⴶⵗ ⵍⵏ⵿ⵌⵍ ⵏⵎⵛⵏⴰ⵰ ⵓⵏ ⴶⵆⵓ ⴼⵍ ⴹ ⵆⵍⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍ ⵍⵢⵂⴹ ⵜⴾⵜⵢ ⵜⴶⵔⵤⵜ ⵢ ⵎⵛⵏⴰ ⵜⵎⵙⵜ ⵔⵜ ⴹⵔ ⵏⵂⴶⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ⴹⵗ ⴹⵢ ⵍⵗ ⵙⴹ ⵙⵀⵔⴶⴰ ⴹⵗ ⵜⵙⵆ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴹⵗ ⵀⵜⵓ ⵏⵛⵗⵍ ⵓⴰ ⴶⵗ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ⵓⵔ ⵂⵍⵗ ⵓⵍ ⴹⵗ ⵔⵜⵏ ⵔ ⵓⵏ ⵙⵏ⵿ⴹⴰ ⵍⵎⵙⵈ ⵙ ⵜⵔⵢⵜⵏ ⵎⵙⵏⵏ ⵙ ⴹⵓⵢⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵀⵔⴹⴶ ⵢ ⵎⵛⵏⴰ⵰ ⵔⵜ ⵓⵏ ⴶⴰ ⵙⵓⵍ ⴹⵎⵤⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ⴶⴰ ⴹⵗ ⵙ ⵜⵔⵏⴰ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴹⵔⵜⵏ ⵙⵎⴾⵍⵍⵏⵏ ⴶⵏⵏ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵔⵏⴰ ⵏⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⴹⵀⵤⵏ ⵗⵔ ⵢⵔⵙⵍⵎ ⵂⵔⴾⴹ ⵍⵔⵢⴰ ⴾⵍ ⵓⴹⵢ ⴾⵍ ⵙⵏⵂⵍⵗ ⴹⵗⵙ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ⵎⵔⵏ ⵛⵗⵍⵏ ⵓⴰ ⴹⵗ ⴹⴶⵤⴰ ⵓⵍⵏ ⵎⵙ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ ⵢⵢⵜⴹⵏ ⵓⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⴹ ⵙⵍⵏ ⵢⵙⵎ ⵏⵍⵎⵙⵈ⵰ ⵔⵜ ⵓⵏ ⴶⵆⵓ ⴼⵍ ⴹ ⵓⵔ ⵆⵍ ⵛⵗⵍⵏ ⵔⵜ ⵏ⵿ⵜⵏ ⴼⵍ ⵛⵗⵍ ⵏⵢⵏ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ⵛⵗⵍ ⵓⵏ ⴶⵆⵓ ⵙⵎⴾ ⵓⴰ ⵎⵍⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⵓⵏ ⵙ ⵓⵔ ⵜⵎⵍ ⴹ ⵜⵏⵢⵏ ⵎⵔⵏ ⵓⵏ ⵓⵔ ⵏⵙⵍⴰ ⵙⵍⵏⵜ ⵜⵏⵙⵍⵏ ⴶⵔⵏ⵿ⵜⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ⵔⵜ ⵓⴰ ⴹⵗ ⴹⴶⴹⵍⵏ ⴼⵓⴹⴰ ⴾⵓⵏⵏⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ⵎⵛⵏ ⵎⵔⴹⴰ ⵗⵔⴹⵗ ⵛⵗⵍⵏ ⴹⵗ ⴾⵍⵏ ⵓⵏ ⴹⵏ⵰ ⵍⵏ ⵍⵏ ⴹ ⴾⵏⵗ ⵜⵔⴰ ⵏ⵿ⴾⵓⵏⵏⵤⵢⵔⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ⵎⵔⵏ ⵔⵗ ⴶⵢ ⵏⴹⵢ ⵙⵗⴰ ⵓⴰ ⴹⵏ⵿ⵤⵙⵗ ⵙⵀⵏⵢⴰ⵰ ⴼⵍⵙ ⴶⵗ ⵜⵎⴰ ⵏ⵿ⴾⵓⵏⵏⵢⵗ ⵙ ⴹⵏⵎⵔⵗ ⴹⵢ ⵎⵔⵏ ⴼⵍⴰ ⴼⵍⵓⵏ ⵢⴹⵜⵍⵍⵎ ⵙⴾⵢ ⵏⴾⵍ ⵓⵏ ⴹⴼⵔ ⵙ ⵗⵔⵓⵏ ⴶⵗ ⵤⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ⵎⵔⴹⴰ ⴹ ⴾⴰ ⵢⵔⵙⵍⵎ ⵢⴹ ⵛⵗⵍⵗ ⵢ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ ⵜⴰ ⵜⵍⵜ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ⴼⵍⵙ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵎⵙⴹⵏⵢⴰ ⴹⴾⵢⴰ ⴾⵏⵏⵜ ⵜⵔⴰ ⵏⴶⵢ ⵏⵛⵔⴶⵜⵏ ⴼⵍ ⴹ ⴹⵂⵍⵏⵜ ⵛⵍⵆⵓⵏ ⵂⵏⵏ ⵎⵤⴹⴶⵏ ⵓⵏ ⵢⵔⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⴾⵏⵏⵜ ⵜⵔⴰ ⵏⵓⵏ ⵎⵔⵏ ⵓⵔ⵿ⵜⵏⵜ ⴶⵏⵜ ⴼⵍⵙ ⴹⴹ ⵤⵎⵙ ⵍⵎⵙⵈⵜⵏ ⵓⵏ ⵎⵙⵏⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵂⵍⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍ ⵍⵢⵂⴹ ⴼⵍ ⴶⵏⴰ ⵓⵏ ⵤⴶⵤⵏⵙⵏ ⵓⴹⵢ ⵍⵎⵙⵈⵜⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍ ⵍⵢⵂⴹ ⵓⵔ⵿ⵜⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹ ⴹⵂⵍⵏ ⵙⵔⵤⵗⵏⵙⵏ ⵓⵏ ⵎⵙⵏⵏ ⴾⵍ ⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ⴹⵗ ⴹⵢ ⵙ ⵗⵔⴹⵗ ⵛⵗⵍ ⵓⴰ ⵛⵛⵓⴹⴰ ⵛⵔⴶⵜⵏ ⵛⵏ ⵢ ⵎⵙⵓⵙⵏⵜ ⴹ ⴾⵗ ⵙⵀⵏⵢⴰ ⵎⵔⵆⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ⵎⵔⵏ ⵙⵏⵗ ⵙ ⵍⵀⵔⴾⴰ ⴾⵎⵍⵏ ⵏⵍⵎⵙⵈ ⵎⵙ ⵙⴰ ⵓⴰ ⴾⵓⵏⵏ⵿ⵤⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⵓⵍⵏ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵜⵔⴰ ⵜⴰ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵍⵍⵎ ⴹⵗ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴶⵗ ⵙⴹⵜⵜⵏ⵿ⵙⵢⵎ ⵎⵛⵏⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ⵜⵜⵔⵜⵏ ⴹⵗⵍⵙⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴶⵢⵏⵏ ⵙⵀⵔⴹⴶ ⵢ ⵎⵛⵏⴰ ⵂⵏⵏ ⵢⵂⴹⵢⴰ ⵜⵜⵔⵎⵢ ⴹⵗ ⴼⵍ ⵆⵀⵍⵏ ⵎⵤⴹⴶⵏ ⵓⵏ ⵢⵔⵙⵍⵎ ⵛⵔⴶⵜⵏ ⵛⵏ ⴹⵙⵏ⵿ⵤⵓⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ⵙ ⴶⴰ ⴹⵢ ⴾⵓⵏⵏⵙⴰ ⴾⵏⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⴾⴹ ⵔⴰ ⵎⵛⵏⴰ ⴹⵢ ⴶⴰ ⵗⵔⵓⵏ ⵤⵎⵏ ⵏ⵿ⵜⵙⵏ⵿ⴼⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⵂⴾⵏ ⵍⵈⵔ ⴾⵓⵏⴶⵤ ⴾⵜⵏⵓⵏ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ⵙⴼⵍⵙⵆⵓⵏ ⵜⵎⴹⵔⵢⵜⵏⵏⴰ ⴼⵀⵢ ⵜⵎⵙⵜ ⵜⵎⴹⵂⵍ⵿ⵜ ⵏⵍⴾⵏⵙⵜ ⵜⵏ ⵆⵏ⵿ⴾⵔⵢⴰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ⴼⵍ ⵜⵜⵆⵀⵍⵎ ⵙⵙⵎ ⵏⵎⵍⵢ ⴶⴰ ⵓⵏ ⵙⵎⴾ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⴹⴶⵏ⵰ ⵍⵍⵜⵙ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗ ⵜⴹⵔⵔ ⵜⵍⵍ⵿ⵜⵏⵓⵏ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵜⵍⵍ ⵢⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙ ⵏⴾ ⵎⵏⵏ ⵂⵆⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ⵜⵂⵍⵎⵏ ⴼⵔⵙⴾⴰ ⴹⴾⵍⵙ ⵎⵙⵏⵏ ⵎⴹⵓⵏⵏ ⴹⵗ ⵛⵗⵍ ⵢⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ⵏ⵿ⵜⵏⵢ ⴶⵏⵏ ⵎⵏⵙⵏ ⴹⵗ ⵍⵗⵔⵔ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⴹⴶⵤⵏ ⴹⵗ ⵓⵏ ⵔⵏⵏ ⵜⵏⵗⵢⵏⵏ⵰ ⵓⵔⴶⵗ ⵏⴾ ⵗⵙ ⴹⵙⵏⴶⴹⵢⵏ ⵓⵏ⵰ ⴾⵍⵔ ⵍⴾⵏⵙⵜⵏ ⴾⵍ ⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⴰ ⴶⴹⵢⵏⵜⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ⵜⵂⵍⵎⵏ ⴹⵗ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵂⵜ ⵗⵢⵓⵏⵙⵏ⵰ ⵜⵂⵍⵎⵏ ⵎⵔⵏⵏ ⴼⵢⵏⵜ ⵙⵏ⵿ⵜⴰ ⵤⵔⵏ ⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⴹⵗ ⴾⵍ ⵏⵙⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ⵜⵂⵍⵎⵏ ⵎⵔⵢⵎⴰ ⵜⵢⵓⵏⵜ ⵛⵗⵍ ⴶⵏ ⵎⵙⵏ ⵜⵍⵍ⵿ⵜ ⵢⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ⵜⵂⵍⵎⵏ ⵏ⵿ⴹⵔⵏⴾⵙ ⴹⵢⵏⵢⴰ ⵎⵙⵏⵏ ⴾⵍ ⵜⵎⵜⵏ ⴹⵔ ⵏⵎⴶⵤⴰ ⴾⵙⵓ ⵎⵙⵏ ⴹⵗ ⵢⵜⴹⵏ ⴼⵍ ⵜⴶⴰ ⵎⵙⵏⵜ ⴹⵗ ⵏⵎⵤⵍ ⵎⵔⵏ ⵤⵔⵏⵢ ⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ⵜⵂⵍⵎⵏ ⴹⵗ ⵏ⵿ⴼⵍⵢⵜⵙ ⴾⵏⵗ ⵜⵔⴰ ⴼⵍ ⵜⵔ⵿ⵜⵢⵜ ⵏⴶⴰ ⴹⵗ ⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ⵜⵂⵍⵎⵏ ⵔⵀⵏⵙ ⵎⵙⵏ ⵎⴹⵏⵏⴰ ⴹⵗ ⵛⵗⵍ ⵢⵍⵎⵙⵈ ⵜⵂⵍⵎⵏ ⴹⵗ ⵎⵔⵏⵏ ⵙ⵿ⵜⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ⵜⵂⵍⵎⵏ ⵀⵍⵙ ⵎⵙⵏ ⵓⴹⵏ ⵙⵜⴹⵏ ⵤⴶⵤⵏⵜ ⵙⵍⵎⵙⵈ⵰ ⵜⵂⵍⵎⵏ ⴹⵗ ⴾⵍ ⵗⵢⵓⵏ ⵏⵔⵙ⵿ⵜⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ⵜⵂⵍⵎⵏ ⵂⵔⴹⵢⵏ ⵙⵏ⵿ⵜⴰ ⴹⴰ ⵢⵏ ⴹⵗ ⴾⵍ ⵜⵎⵜⵏ⵰ ⵜⵂⵍⵎⵏ ⴾⵍ ⵗⵢⵓⵏ ⵏⵔⵙⵙⵙ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ⵜⵂⵍⵎⵏ ⵜⵔⴼⵏⴰ ⴹⵜⵔⴼⵤⴰ ⴶⵏⵏ ⵛⵗⵍ ⴶⵏ ⴹⵗ ⵜⵔⵢⵜ ⵏⵎⵍⵢ⵰ ⵜⵂⵍⵎⵏ ⵜⵎⵔⵜⵏⵏⴰ ⴼⵔⵙⴹⴰ ⵜⴶⵜ ⵏ⵿ⵜⴹⴰ ⵛⵗⵍ ⴶⵏ ⴹⵗ ⵜⵔⵢⵜ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ⵜⵂⵍⵎⵏ ⵔⴼⵙ ⵎⵙⵏ ⵏⴼⵔⵏ ⵏⵎⵛⵏⴰ ⴹⵏⵏⵜ ⵙ ⵏⴾ ⴹⴰ ⵜⵎⵙⵢ ⵤⵏ ⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ⵜⵂⵍⵎⵏ ⵙⵏ⵿ⴾⵔⵜ ⴹⴼⵍⴶⵏ ⴹⵗⵔⵎⵙ ⴹⴼⵜⵔⵀⵙ ⴹⵗⵔⵎⵙ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⵗⵔⵙⵏ ⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ⵜⵂⵍⵎⵏ ⴼⵍⵍⴶⵙ ⴹⵢⵍⵢⴰ ⴹⵏⵔⵢ ⴹⵜⵎⴹⵔⵢⵜⵏⵜ ⵏ⵿ⵜⵏⵢ ⵂⵔⴾⴹ ⵍⵏⵀⵙ ⴹⵎⵤⴶⵤⵏ ⴾⵍ ⵓⵏ ⵗⵔⵙⵏ ⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ⵜⵏⵎⴶⵜ ⵙⵍⵎ ⵤⴹⴶⵏ⵰ ⵂⵍⵏⵜⴾⵓⵏⵏ ⵍⴾⵏⵙⵜⵏ ⵏⵍⵎⵙⵈ ⴾⵜⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹ ⵜⵏ⵿ⴾⴹⵎ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵜⵓⵢⵏⵏ ⵎⵤⵢⵏ ⴶⵔⵓⵏ ⴹⵜⵙⵏ⵿ⴾⴼ ⵙⴾⵔⴾⴹⵏⵏ ⵎⵙⵏⵏ ⵍⴹ ⵏⵙⵙⵗⵔⵢ ⵓⴰ ⵜⵜⵓⴶⵎ⵰ ⵏⵎⴶⴶⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ⴼⵍⵙ ⵓⵔ ⵗⵀⴹⵏ ⵎⵍⵏⵏⵗ ⵍⵎⵙⵈ ⴾⵍⵔ ⵓⵔ ⴶⵎⵢⵏ ⵔ ⴶⵏ ⴹⵗ ⵜⴹⵙⵏⵙⵏ⵰ ⵓⵍⵏⵙⵏ ⵂⵙⵢⵏⵏ ⴹⵛⵤⴹⴰ ⵏⵍⵙⵏⵙⵏ ⵙ ⵜⴾⵔⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵔⴾ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ⵀⵔⴹⴶⵏⵓⵏ ⵢ ⵎⵛⵏⴰ ⵓⴹⵏ ⴾⵍ ⵙⵏ ⴹⵗⵙ ⴹⵢ ⴼⵍ ⵙ ⵙⴼⵍⵓⵙⵢ ⵓⵏ ⴹⵗ ⵀⵜⵏⵓⵏ⵰ ⵎⵛⵏ ⵔⵗ ⴹ ⵜⵍⵎ ⵜⵢⵜⵢ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵎⵤⵍ ⵏⵓⴰ ⵍⵗⵏ ⵜⵤⴹⴶⵎ ⴹⵗ ⴹⵗ ⵢ ⵜⵜⵍⴰ ⵜⵍⵀⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⴹⴼⵍ ⵍⵈⵔ ⴾⵍ ⵜⵔⵎⴹ ⵙ ⵤⴹⴶⴹⴶ ⵛⵢⵜⵏ ⴹⵓ ⴹⵔⵏⵓⵏ⵰ ⵜⴹⵓⵜ ⴹⵔⵓⵏ ⵔⵈⵎⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ⵂⵍⴾⵓⵏⵏ ⵎⴹⵏⵏ ⴹⵗ ⵛⵗⵍ ⵜⵎⵙⵏ ⵜⵎⵜⵢ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⵍⵆⵢⵙ ⴹⵢⵙⵏ ⴹⵙⵙⴼⵜⵔ ⵎⵙⵏⵏ ⴾⵍ ⵜⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ⵏⴾ ⵎⵏⵏ ⵜⵔ⵿ⵜⵢⵙ ⵜⵓⵙⴾⵜⵀⵏ ⵛⵔⵓⵜ ⵜⴰ ⴹⴰ ⵂⵍⵆⵓⵏ ⵙⵙⵎ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ⵂⵍⴾⵓⵏⵏ ⴶⵢⵙ ⵙⵏ⵿ⵜⴰ ⵗⵔ ⵙⴶⵏⴰ ⵏⴾ ⴹⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ⵰ ⵂⵍⴾⵓⵏⵏ ⵔⵙ⵿ⵜⵙ ⵎⵙⵏ ⵍⵙ ⵓⴰ ⵏⵜⴼⵏ ⴹⵔⵤⵗⵏ ⵏⵗⵔⵎ ⵓⴰ ⵂⵍⴾⵓⵏⵏ ⴹⵗ ⵎⴹⵔⵢⵏⵏⴰ ⴾⵔ⵿ⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ⵜⴹⵓⵜ ⴹⵔⵓⵏ ⵔⵈⵎⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵜⵏⵓⵏ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵍⵏ ⵜⵔⵏⴰ ⵏⴹ ⵙⵙⵂⵜ ⵤⴶⵤⵏⵓⵏ ⴹⵗ ⵏⵎⴹ ⵏⵎⵏⴾⵏ ⴹⵍⵏ⵿ⵌⵍⵏⵜ ⵓⴰ ⵎⵍⴰ ⵎⵙ ⵜⵍⵈⵜⵀⵜ ⵜⴰ ⴶ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵏⵎⵏⴾ ⴹⵗ ⵓⵏ ⴹⵙⵔ ⵏⵎⵛⵏⴰ ⵓⴰ ⴹⵏⵗⵏⴼⵍⵍⵏ⵰ ⵙⵔ ⵓⵏ ⵗⵀⵔ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴾⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ⵎⵛⵏ ⵎⵔⴹⴰ ⵙⵏⴼⵍⵍⵏ⵿ⵜⵓ ⵍⴾⵜⵀⵏ ⵓⵏ ⴹⵤⵀⵜⵏⵏ ⴼⵍ ⵏⵀⵜⵏ⵰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵗⵍⵍ ⵎⵔⵏ ⵙⴹ ⵏⴼⵍⵍ ⵓⵏ ⵢ ⵜⵓⵛⵜⵏ ⵏⴹⵏⵜ ⴾⵜⵏⵙⵏⵜ ⴼⵍ ⵙⵔⵙ ⵤⴶⵤⵏⵜ ⵀⵔⴹⴶⵏⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵎⵛⵙ ⵏⵎⵙⵏⵜ ⴾⵍ⵰ ⵜⵏⵢⴰ ⴾⵍ ⵛⵏⵜ⵰ ⵜⵎⵍⵜ ⵂⵔ ⴼⵓ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵎⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⵗⵔⴰ ⵎⵛⵏⴰ ⴹⵗ ⵜⵔⵏⵜ ⵙ ⵜⵛⵜ ⵏⵏⵎⵤⵍ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ⵏⴾ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵙⵙ⵿ⵜⵏⵙ ");
INSERT INTO ttqt_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ⵏⵂⵍⵏ ⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⵜⴰ ⵜⵂⵜ ⵗⵔⵎ ⵏ⵿ⴾⵔⵏ⵿ⵜ⵰ ⵗⵔⵜ ⵢⴹ ⵜⵆⵍ ⵜⵎⵜⵢⵏⵜ ⵤⴹⴶⵜ ⵜⵂⵜ ⵜⵍⵏⵜ ⵙⵙⵀⵀ ⵏ⵿ⵜⵙⵆⵏⵙⵏ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ⵏ⵿ⵜⴰ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⴶ ⵂⵏ ⵗⵀⴹⵏ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵎⵍⵏⵙⵏ ⵎⵙ ⴹⵗ ⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⴾⴼⵆⵓⵏ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ⴼⵓ ⵜⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵏⵏ ⴹⵗ ⵜⵍⵗⵏⵓⵏ ⵜⵂⴾⵢ ⵜⴰ ⴾⵓⵏⴶⴰ ⵔⵈⵎⵜⵏⵜ ⵙⵙⵀⵀ ⵏ⵿ⵜⵙⵆⵏⵓⵏ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ⴼⵍⵙ ⵜⵙⵆⵏⵓⵏ ⴹⵔⵙ ⵙⵔⵓⵏ ⴹⵓⵢⵏ ⵙ ⴾⵓⵏⵙⵀⵍⵍ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⵍⵏ ⴹⵗ ⵓⴰ ⵜⴶⵏⵎ ⴾⵍ ⴹⵓⴰ ⵜⵙⵏⵎ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⵓⵏ ⵏⴶⴰ ⵜⴹⵏ ⵗⵔⵓⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ⴹⵢ ⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ ⵓⵔ ⵜⴶⵔⵓⵎ ⴾⵓⵏⵢ ⵓⵏ ⵓⵔⵗⵓⵔⵗⵏⵏ ⵢ ⵜⵓⵗⵍⵢ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ⵙⵏ⵿ⵜⴰ ⵤⵙⵙⵂⵏ ⵤⴶⵤⵏⵓⵏ ⵂⵔ ⵜⵤⵔⵙ⵿ⵜ ⵓⴹⵓ ⴼⵍⵓⵏ ⵤⵍ ⵓⴰ ⴹⵤⵙⵓ ⵓⵔ ⴾⵓⵏⵓⵔ ⵍⵂⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ⵎⵛⵏⴰ ⴹⵢ ⴾⵓⵏ⵿ⴹⵗⵔⵏ ⵢⴹ ⵜⵔ⵿ⵜⵢⵎ ⴹⵀⵔⵔⵏⵜ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵓⵔ ⴹⵜⵆⵍ ⴹⵗ ⵜⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ⵎⴹⵔⵢⵏⵏ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴼⵍ ⴹⵎ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹ ⵜⵏⵎⵏⴾⵎ ⴾⵜⵏⵓⵏ ⴹⵗ ⵓⴰ ⵜⴶⵏⵎ ⵜⵆⵎⵎ ⵓⵔ ⵜⵆⵍⵎ ⵜⵤⵏⵏ⵰ ⴾⵍⵔ ⵏⵎⵏⴾⵜ ⴹⵗ ⵓⴰ ⵜⵙⵎⴹⵔⵏⵎ ⴹⵓⴰ ⵜⵏⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ⴼⵍⵙ ⵎⴹⵔⵢⵏⵏ ⴶⵏ ⴹⵗⵢ ⵢⵜⴹⵏ ⵏⵗⵢⵓⵏ ⵏ⵿ⴾⵍⵓⵢ ⵙⵍⵏ ⵏⵙ ⵜⵍⴰ ⴶⵔⵓⵏ ⵜⵎⵤⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ⵏⵗ ⴹⵢ ⴼⵍⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⴶⵏⵏ «ⵏⴾⵏⵢ ⵀⵍⵙ ⵙ ⵏⵍⴾⵎ» ⵓⵢⴹ ⴶⵏⵏ «ⵏⴾⵏⵢ ⵀⵍⵙ ⵙ ⵏⵍⴾⵎ» ⵓⵢⴹ ⴶⵏⵏ «ⵏⴾⵏⵢ ⵀⵜⵔⵙ ⵙ ⵏⵍⴾⵎ» ⵓⵢⴹ ⴶⵏⵏ «ⵏⴾⵏⵢ ⵍⵎⵙⵈ ⵙ ⵏⵍⴾⵎ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ⵓⴾ ⵍⵎⵙⵈ ⵜⵤⵏ⵿ⵜ ⴶⴰ⵰ ⵜⵗⵍⵎ ⵏⴾ ⵀⵍⵙ ⵜⵓⵏ⵿ⵗⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵓⵏ⵰ ⵎⵗ ⴾ ⵙⵎ ⵓⵏⵏ ⵀⵍⵙ ⵙ ⵜⵜⵓⵙⵍⵎⵗⵎ ⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⵙ ⵓⵔ ⴹⵗⵓⵏ ⵙⵍⵎⵗⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⵎⵏ ⵔ ⴾⵔⵙⵀⵙ ⴹⴶⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ⴹⵗ ⴹⵢ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴼⵔⴶⵏ ⴹ ⵏⵓ ⵜⵓⵙⵍⵎⵗ ⴹⵗ ⵎⵏ ⵙⵙⵎⵏ ⴼⵍ ⴹ ⵆⵍ ⵏⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ⵓⵍⴰ ⴾⵜⴹⵓ ⵙ ⵙⵍⵎⵗⴰ ⴹⵗ ⵎⵏ ⵢⵜⴹⵏ ⵏⵂⵏ ⵏⵙ⵿ⵜⴼⵏⵙ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ⵓⵔ ⵏⵎⵙ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⴾⵜⵓⵗ ⴹ ⵙⵍⵎⵗⴰ ⴹⵗ ⵎⵏ ⵓⴹⵏ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ⴼⵍⵙ ⵓⵔ ⴹⴹⵤⵎⵤⵍ ⵍⵎⵙⵈ ⴼⵍ ⴹ ⵙⵍⵎⵗⵗ ⵢⵜⴹⵏ ⴹⵗ ⵎⵏ ⴾⵍⵔ ⵤⵎⵤⵍⴹⵓ ⴼⵍ ⴹⵙⵏⵎⵍⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴶⵗⵙⵏ ⴹⵗ ⵎⵍ ⵓⵔ ⵏⴶⴰ ⵙ ⵎⵙⵏⵜ ⵏⵓⵍ ⴼⵍ ⴹ ⵓⵔ ⵜⵀⵏⵏ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜⵆⵍ ⵔⵜ ⵓⵔ ⵏⵍⴰ ⵍⵎⵗⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ⵜⴹⵜ ⵙ ⵙⵍⵏ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⵗⵔ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵏⵂⵍⴾ ⵙⵍⵏ ⵓⵔ ⵏⵍⴰ ⵍⵎⵗⵏⴰ ⵎⵙⵏ⵰ ⵎⵛⵏ ⵏⴾⵏⵢ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵏⵍⵗⵍⵙ ⵏⵙⵏ ⵙ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ⵙⵍⵏ ⵏⵓⵏ ⴹⴰ ⴹⵗ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴹ ⵙⵀⵏⵏⴰ ⵎⵙⵏⵜ ⵏⵎⵙⵏⵏ ⵙⵀⵏⵏⴰ ⴹⵗ ⵜⵢⵜⵢ ⵏⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ⴹⵗ ⴹⵢ ⵎⴰ ⴹⵏⴶⵏ ⴹⵗ ⵎⵙⵏⵏ⵰ ⵎⴰ ⴹⵏⴶⵏ ⵤⴰ ⴹⵗ ⵎⵙⵏⵏ ⵏⵜⵓⵔⵜ⵰ ⵎⵙⵏⵏ ⵏⵓⵍ ⵏⵤⵎⵏ ⵓⵏ ⴹⵏ ⵏ⵿ⵜⵏⵢ ⵎⴰ ⴹⵗⵙⵏ ⵏⴶⵏ⵰ ⵓⵔⴶⵗ ⵎⵛⵏⴰ ⵙⴾⵏⴰ ⵙ ⵎⵙⵏⵜ ⵜⴰ ⵍⵏ ⵢⵜⴹⵏ ⵏⴹⵏⵜ ⵜⴰ ⵎⵙⴾⵍ ⵜⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ⴼⵍⵙ ⵎⵛⵏⴰ ⴶⵏ ⵙ ⵎⵙⵏⵜⵏⵜ ⵙ ⵢⵜⴹⵏ ⵓⵔ ⴼⵔⴶⵏ ⵜⵙⵏⵏ ⵙ ⵎⵙⵏⵜ ⵜⵏⵙⵏ ⵎⵏⵙⵏ ⴹⵢ ⴼⵍ ⴶⵔⵤ ⵢ ⵎⵛⵏⴰ ⴹ ⵗⵍⵙ ⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏⵏ ⵎⵙⴾⵍ ⵙⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵙ ⵓⵔ ⵏⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ⴾⵍⵍⵢⵂⴹ ⵤⴰ ⵏ⵿ⵜⵏⵢ ⴶⵎⵢⵏ ⴹⵙⵏⵜⵓⴶⵏⵜ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵎⵙⵏⵏ ⵍⵗⵍⵎⵜⵏ ⴾⵍⵍⵢⵏⵏ ⵎⵔⵏ ⴶⵎⵢⵏ ⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ⴹⵢ ⴼⵍⵙ ⵏⴾⵏⵢ ⵎⵍ ⵓⴰ ⵏⵜⴶⵓ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵎⵙ ⵢ ⴾⵍⵍⵢⵂⴹ ⴹⵙⵏ⵿ⵜⴶⴹⵍⵜ ⵤⴶⵤⵏ ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵏⵢ ⵎⵙ ⵗⵔⵙⵏ ⵎⵙⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ⵎⵛⵏ ⵗⵔ ⵢⵜⴹⵏ ⵓⵏ ⵗⵔⴰ ⵎⵛⵏⴰ ⴶⵔ ⵤⴰ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⴹⵗ ⴾⵍⵍⵢⵏⵏ ⵍⵎⵙⵈ ⵜⵔⵏⴰ ⴹⵎⵙⵏⵜ ⵏⵎⵛⵏⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ⴼⵍⵙ ⴶⵢ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⵎⵙⵏ ⵙⵢⵜⴹⵏ ⴹⵢ ⵎⵙⴾⵍ ⵓⵔ ⵜⵜⵓⴹ ⵎⵙⵏⵜ ⵏⴶⴹⵎ⵰ ⴶⵏⵜ ⴹⵗ ⵓⴹⵢ ⵎⵙⵏ ⵙⵢⵜⴹⵏ ⵀⴰ ⵏ⵿ⵜⵍⴰ ⵏ⵿ⵜⵏⵢⴰ ⵓⵔ ⵜⵜⵍⴰ ⵜⵔⵏⴰ ⵏⴶⴹⵎ ⵓⵔ ⴶⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⴾⵜⵓⵜⴹⵓ ⵓⴰ ⵜⵎⵙⵎ ⵙ ⴾⵓⵏ⵿ⴹⵗⵔⴰ ⵎⵛⵏⴰ⵰ ⵓⵔ ⴹⵗⵓⵏ ⴶⵜⵏ ⵢⵜⴹⵏ ⵙ ⵜⵓⴶⴰ ⴹⴼ ⵏⵙ ⵎⵙⵏ ⵎⵙⵏⵏ ⵓⵍⴰ ⵓⵢⴹ ⵍⵏⵏ ⴼⵔⴶⵜ ⵓⵍⴰ ⵓⵢⴹ ⵎⵙⵏⵏ ⴾⵍ ⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ⴾⵍⵔ ⵎⵛⵏⴰ ⵙⵏⴼⵔⵏ ⵔⵜⵏ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⵍⵎⵗⵏⴰ ⵗⵔ ⵢⵜⴹⵏ ⵏⴹⵏⵜ ⵜⴰ ⴼⵍ ⴹ ⵤⵀⵤ ⵎⵙⵏⵏ ⵜⴾⵔⴾⵜ⵰ ⵙⵏⴼⵔⵏ ⴹⵗ ⵓⵏ ⵓⵔ ⵏⵍⴰ ⴼⵔⴶⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴼⵍ ⴹ ⵤⵀⵤ ⵜⴾⵔⴾⵜ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴼⵔⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ⵓⴰ ⵜⵓⵍⴾⵏ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴹⵓⴰ ⵜⵓⴾⵢⴹⵏ ⴹⵓⴰ ⵓⵔ ⵏⵜⵓⴶⴰ ⵓⵍⴰ ⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⵢⵙⵔⵙⵏ ⵙⵀⵓ ⵜⵎⵢⵎⵢⵜ ⵏⵓⵏ ⵎⵙⵏⵏ ⵔⵜ ⵗⵔ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ⵔⵜ ⵓⵏ ⴾⵍ ⴶⵢ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⴹⵜⵙ ⵓⵔ ⴹⴾⵍ ⵓⴹⵏ ⵓⵍⵢⵏ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ⴾⵓⵏⵢ ⵎⵔⵏ ⵎⵛⵏⴰ ⴾⵓⵏⵙⵗⵏ ⴹⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵙⵏ⵿ⵜⴰ ⴹⵏⵗⵆⵍⵏ ⵎⵙⵏⵜ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ⵰ ⵍⵎⵗⵏⴰ ⴾⴼⵏⴰ ⵙⵔⵙ ⵜⵆⵜ ⴹⵜⵤⴹⴾ ⴹⵜⴹⵔⴼⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ⴹⵢ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴹⵏ ⵓⴰ ⵔⵏ ⴹⴾⵍ ⵏⵎⵏⵜ ⴹⴾⵍⵜⵏ ⴼⵍ ⵛⴹⵜ ⵏⵓⴰ ⴶⴰ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ⵏⴾ ⵎⵏⵏ ⵎⴹⵔⵢⵏⵏ ⵙ ⴾⵓⵏⵏⵙⵗ ⵢⴹⵓⵏⵎⵍⴰ ⵜⴹⵜ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵜⵎⵙⵜ ⵙⵔ ⵓⵔ ⴾⵓⵏⵙⴾⵏⴰ ⵎⵙⵏⵜ ⵏⵓⵍ ⵓⵍⴰ ⴶⵜ ⵏⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ⴼⵍⵙ ⴶⵗ ⵜⵏⵜ ⵏⵙ ⴾⵜ ⵂⵆⵓⵏ ⵓⵔ ⴹⵓⵏ⵿ⵤⴶⵗ ⵙⵍⵏ ⵓⵔ ⵏⵎⵙ ⵓⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵜⵓⵏ⵿ⵗⴰ ⵓⴰ ⵜⵓⴶⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ⵏⴾ ⵤⵎⵏ ⵓⵏ ⵗⵔⵓⵏ ⴶ ⴶⵆⵏ ⴹⵀⴰ ⵏⵙⵂⵜ ⴹⵜⵙⴰ ⴹⵜⵙⵏ⵿ⴹⵓⵜ ⵜⵢⵙⵙ⵿ⵜ ⵍⵀⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ⵎⵔⵏ ⵙⵙⵗⵔⵜⵏⵏ ⴹⵜⵍⵈⵜⵀⵜⵏⵏ ⵓⵔ ⴶⵏ ⵙ ⵎⵙⵏⵜ ⵏⵓⵍ ⵓⵍⴰ ⵜⵍⴰ ⵏ⵿ⵜⵢⵜⵢ ⴾⵍⵔ ⵙⵙⵗⵔⵜⵏ ⵎⵙⵏ ⵙ ⵙⴾⵏⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵜⵔⵏⵏⵜ ⵙ ⵜⴹⵜ ⵎⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ⴼⵍ ⴹ ⵆⵍ ⵤⴶⵤⵏⵓⵏ ⵔⵜ ⵙⵔⵓⵏ ⴹⵜⵓⵢ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⵓⵔⴶⵗ ⵎⵙⵏⵜ ⵏⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴹⵜ ⵙ ⵜⵍⵢ ⵎⵙⵏⵜ ⵏⵙⵙⵗⵔⵓ ⵢⵜⴹⵏ ⵓⵏ ⵙⴶⵜⴾⵏⵏ ⴹⵗ ⵤⴶⵤⵏ⵰ ⵎⵛⵏ ⵎⵙⵏⵜ ⵜⵏ ⵓⵔ ⵜⵜⵍⴰ ⴹⵏⵜ ⵜⴰ ⵤⴰ ⵓⵔ ⵜⵜⵍⵏ ⵎⵤⵔⵏⵜ ⵙ ⵍⴾⵎ ⴹ ⵀⴰ ⵜⵎⵢⵎⵢⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ⴾⵍⵔ ⵎⵙⵏⵜ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵏⵙⵙⵗⵔⵓ ⵜⵎⵙⵜ ⵙⵔ ⵔⵓⵏ ⵗⵀⵔ ⵢⵢⵜⴹⵏ⵰ ⵎⵙⵏⵜ ⵜⴰ ⵂⵔⵓⴰ ⴹⵜ ⵈⵍⴾ ⵏⴹⵏⵜ ⴹ ⵜⵙ ⵎⵛⵏⴰ ⴹⵏⵙⵔⵙⴾⴼⵓ ⴹⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵎⵤⵔⵏ ⵏⴹⵏⵜ ⵜⴰ ⴹⴰ ⵢ ⴶⵔⵓⵏ ⴶⵔⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⵎⵙⵏⵜ⵰ ⴼⵍⵙ ⵏⵔ ⵜⵜⴶⵔⵏ ⵓⵔ ⵤⵜⵢⵜⵢⵏ ⵎⵍⵢ ⵏ⵿ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴰ ⵙⵏ⵿ⵙⴰ ⵎⵛⵏⴰ ⵢ ⵓⵏ ⵜⵔⵏⵏ ⵓⵔ ⴾⵍⴰ ⵜⵜⵏⵢ ⵛⵜ ⵓⵔ ⴾⵍⴰ ⵜⵜⵙⵍⴰ ⵜⵎⵤⴾ ⵓⵔ ⴾⵍⴰ ⴹⵗ ⴹ ⵜⵙⵎⴹⵔⵏ ⵓⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ⵏⴾⵏⵢ ⵎⵔⵏ ⵙⵏⴼⵍⵍⵏⵆⵓ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵓⵔ ⵙⵏ ⵓⵍⴰ ⵗⵙ ⵔⵜⵏ ⵓⵏ ⵙ ⵜⵙ ⵎⵛⵏⴰ ⴶⵏⵙⵏ ⴹⴰ ⵙⵏ ⴹⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ⴹ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙⵏⵏ ⵓⴰ ⵂⵏ ⵎⵏ ⵏⵢⵏ ⵓⴹⵏ ⵔ ⵎⵏ ⵏⵓⴹⵏ ⵓⴹⵢ ⴹⴰ ⵗⵙ⵰ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵙⵏⵏ ⵓⴰ ⵜⵙ ⵎⵛⵏⴰ⵰ ⵏ⵿ⴼⵙⵏⵜ ⴹⵢ ⵤⴹⴶⵏ ⵗⵙ ⵜⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ⵎⵔⵏ ⵏⴾⵏⵢ ⵓⵔⴶⵗ ⵏ⵿ⴼⵙ ⵛⵍⵜ ⵏ ⵓⵏ ⴹⵏⵜ ⵏⴶⵔⵓ ⴾⵍⵔ ⵏ⵿ⴼⵙ ⵓⴰ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⵏⴶⵔⵓ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵔⵈⵎⵜⵏ ⵛⵏ ⴼⵍⵏⴰ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ⴹⵢ ⴼⵍⵙ ⵔⵜⵏ ⵓⵏ ⵏⵙⵙⵗⵔⵓ ⵓⵔ ⵜⵏⵙⵙⵗⵔⵓ ⵙ ⵎⵙⵏⵜ ⵜⵏ ⴶⴹⵎ ⴾⵍⵔ ⵎⵙⵏⵜ ⵜⴰ ⴹⵏⵗⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵜⵏⵙⵙⵗⵔⵓ⵰ ⵏⵙⵙⴶⵔⵓ ⵜⴹⵜ ⵜⴰ ⴹⵜⴼⵍⵜ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵂⴰ ⵏ⵿ⴼⵙ ⴹⵢ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⵎⵙⵏⵜ ⵜⵏ ⴶⴹⵎ ⵓⴹⵢ ⵓⵔ ⴼⵔⴶ ⴹ ⵆⵀⵍ ⵔⵜ ⵓⴰ ⴹⴼⵍⵏ ⵏ⵿ⴼⵙ ⴹⵢ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⴹ ⵗⵔⵙ ⵎⵙⴾⵍ ⵎⵙ ⵓⵏ ⵓⵔ ⴼⵔⴶ ⴹ ⵜⴶⵔⵓ ⴼⵍⵙ ⵏ⵿ⴼⵙ ⴹⵢ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⵂⴾⵏ ⴶⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ⵓⴹⵏ ⵓⴰ ⵂⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔ ⵜⵍⴰ ⵔⵜ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⵙ ⵓⵔ ⴼⵔⴶ ⴶⵔⵏⵜ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵓⵔ ⵂⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴼⵔⴶⵏ ⵙⵔⵙ ⵏⵓ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ⴹⵢ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵎⴰ ⵙⵏⵏ ⴹⵗ ⵓⴰ ⵜⵙ ⵎⵍⵢ ⵎⵛⵏⴰ ⵓⵍⴰ ⴼⵔⴶ ⴹⵙⴶⵓ ⵏⵙⵈⴰ⵰» ⵏⴾⵏⵢ ⵤⴰ ⴶⵔⵓⵏ ⵏ⵿ⴼⵙ ⴹⵢ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⵏⵙⵏ ⴹⵗ ⵓⴰ ⵜⵙ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ⵏⴾ ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵂⵔⵓⴰ ⵗⵔⵓⵏ ⵍ ⵓⵔ ⴹⵓⵏ⵿ⵜⴶⵗ ⵓⵍ ⵓⴰ ⵜⴶⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵂⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⴾⵍⵔ ⴶⵗⵓⵏ ⵓⵍ ⵤⵏ ⵓⴰ ⵜⴶⵓ ⵓⴹⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⵜⵔⴰ ⵏⵎⵏⵙⵏ ⵤⵏ ⵛⵓⵍⴰ ⵢⵢⵜⴹⵏ ⵙ ⵙⴾⵜ ⵍⴾⵎⵏ ⵢⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ⵤⵏ ⵙ ⵈ ⴾⵓⵏⵛⵛⵓⴰ ⵓⵔ ⴾⵓⵏⵙⵜⵛⴰ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵆⵔⵏⵏ ⴼⵍⵙ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⴹⵙⵏ⵿ⵜⴼⵔⴶⵎ⵰ ⵓⵍⴰ ⵎⵔⴹⴰ ⴹⴰ ⵓⵔ ⴹⵙⵏ⵿ⵜⴼⵔⴶⵎ ");
INSERT INTO ttqt_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ⴹ ⵂⵔⵓⴰ ⴹⴰ ⵓⵔ ⵜⵍⴰ ⴾⵓⵏⵤⵍⵢⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⵜⵔⴰ ⵏⵎⵏⵙⵏ⵰ ⵛⵙⵎⵜⵏ ⵛⵏ ⵜⵜⴶⵎ ⴼⵍ ⵎⴹⵓⵏⵓⵏ ⴹⵜⵎⵤⵆ ⵜⴰ ⵜⵎⵍⵜ ⴶⵔⵓⵏ ⵓⵔⴶⵗ ⵙⵜⴹⵏⵜ ⵙ ⵂⵔⵓⴰ ⴹⴰ ⴾⵍ ⴹⵏⵜ ⵜⵜⵍⵍⵎ ⵜⵍⴾⵎⵎ ⵢ ⵜⵔⵢⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ⵙ ⵏⴰ ⵢⵏ ⴹⵗⵓⵏ «ⵏⴾ ⵀⵍⵙ ⵙ ⵍⴾⵎ» ⵏⴰ ⵢⵏ «ⵏⴾ ⵀⵍⵙ ⵙ ⵍⴾⵎ» ⵓⴹⵢ ⵓⵔⴶⵗ ⵍⵈⵍ ⵏⵢⵜⴹⵏ ⵏⴹⵏⵜ ⵜⴰ ⴹⴰ ⵜⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ⵀⵍⵙ ⴹⴰ ⵏ⵿ⵜⴰ ⵓⵍⴰ ⵀⵍⵙ ⵓⴾ ⵎⴰ ⵎⵙⵏ⵰ ⵓⵔ ⵏⵎⵙ ⵔ ⵎⵛⵗⵍⵏ ⵏⵎⵛⵏⴰ ⵓⵏ ⵙⵔⵓⵏ ⴹⵓⵢⵏⵏ ⵤⴶⵤⵏ ⵙⵔⵙ ⵏⴾ ⵂⵔⴾⴹ ⵏ⵿ⵜⴰ ⵓⵔ ⵏⴶⴰ ⵔ ⵛⵗⵍ ⵓⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ⵏⴾ ⵓⴰ ⵎⵤⵍⴰ ⵂⴰ ⵛⵛⵍⵏ ⵏⵎⵙⴰ ⵙ ⵏⴾ ⵜⵏⵀⵍⵏ ⵜⵤⵔ ⵛⵛⵓⵢ ⵀⵍⵙ ⵎⵛⵏ ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⵜⴹⵙⴹⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ⴹⵗ ⴹⵢ ⵓⵔⴶⵗ ⵓⴹⵏ ⵓⴰ ⵏⵀⵍⵏ ⵎⵙⴰ ⵓⵍⴰ ⵓⴰ ⵜⵛⵛⵓⵏ ⵎⵙⵏ ⵔⵜ⵰ ⴾⵍⵔ ⵎⵛⵏⴰ ⵜⴹⵙⴹⵓⵍⵏ ⵜⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ⵓⴹⵏ ⵓⴰ ⵏⵀⵍⵏ ⵎⵙⴰ ⴹⵓⴰ ⵜⵛⵛⵓⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵎⵙⵏ ⴾⵢⵏ ⴹⵗⵙⵏ ⴹ ⵜⴾⴼⵓ ⵎⵛⵏⴰ ⵍⵈⵆ ⵏⵛⵗⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ⵏⴾ ⴹⵀⵍⵙ ⵏⴹⵔⵓ ⵛⵗⵍ ⵓⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ ⵎⵔⵏ ⴾⵓⵏⵢ ⵎⵙⵏⵏ ⵛⵍⵜ ⵏ⵿ⵜⵓⴶⵙ⵿ⵜⵏⵜ ⵜⵎⵙⵎ ⴹⵗ ⴾⵔⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ⵏⴾ ⴶⵗ ⵙⵔⵈⵎⵜ ⵜⴰ ⴹⴾⴼⴰ ⵎⵛⵏⴰ ⵛⵗⵍ ⵤⵏ ⵓⴰ ⵜⴶⵓ ⵎⴾⵔⵙ ⵏⵏ ⵙⵏⵏ ⵛⵗⵍⵏⵜ ⵙⵗⵜⴰ ⵜⵙⴾⵀⵍ⵿ⵜ ⵜⴰ ⵜⵎⵙⵜ ⵛⵗⵔⴹ ⵏ⵿ⵜⵗⵤⵎ⵿ⵜ ⴹⴼⵔ ⴹⵢ ⵙⴹⵓ ⵓⴹⵏ ⵢⵏ ⴼⵍⵙ ⴾⵔⵙ⵰ ⵎⵛⵏ ⴾ ⵓⴹⵏ ⵏ⵿ⴾⴹⵜ ⴹⵎⴾ ⵓⵙ ⵛⵜⵓ ⴾⵔⵙ ⵏ⵿ⵜⵗⵤⵎ⵿ⵜ ⵜⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴼⵔⴶⵏ ⵙⵗⵜⵢ ⵏⵢⵜ ⵜⵙⴾⵀⵍ⵿ⵜ ⵓⵔ ⵏⵎⵙ ⵜⴰ ⵜⵗⵜⵜ ⴾⵍⴰ ⴹⴰ ⴹ ⵜⵜⵎⵙⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ⵓⵢⴹ ⵢⵜⴹⵏ ⴾⵔⵙⵏ ⴼⵍ ⵜⵙⴾⵀⵍ⵿ⵜ ⵏ⵿ⵜⵗⵤⵎ⵿ⵜ ⵜⴰ ⵙⵔⵗ ⵓⵢⴹ ⵙⵤⵔⴼ ⵓⵢⴹ ⵙ ⵜⵂⵏ ⴾⵏⵏⵏ ⵛⵂⵙⵢ ⵓⵢⴹ ⵙⵛⴾⵏ ⵓⵢⴹ ⵙⵍⵎⵤ ⵓⵢⴹ ⵙⴶⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ⴾ ⵓⴹⵏ ⵍⴾⵎ ⴹ ⵜⵓⵏⵢ ⵛⵗⵍⵏⵜ ⴹ ⴹ ⵜⵓⵙⴾⵏⵓ ⵤⵍ ⵓⴰ ⵍⴾⵎⵏ ⵜⵓⵌⵔⵀ ⵙ ⵜⵎ⵿ⵙⵢ ⴼⵍⵙ ⵜⵎ⵿ⵙⵢ ⵜⴰ ⵏ⵿ⵜⴰ ⵤⴰ ⵜⵙⵏⴼⵍⵍⵜ ⵤⵏⴼ ⵏⵛⵗⵍ ⵓⴰ ⴶⴰ ⴾ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ⴾⴹ ⵜⵎⴾⵔⵙ⵿ⵜ ⵜⴰ ⴼⵍⵙ ⴶⴰ ⵓⴹⵏ ⵓⵔ ⵜⵜⵜⵛⴰ ⵜⵎ⵿ⵙⵢ ⵓⴹⵏ ⵓⴹⵢ ⴹ ⴶⵔⵓ ⵍⵈⵆⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵜⵜⵛⵜ ⵜⵎ⵿ⵙⵢ ⵓⴹⵏ ⵓⴹⵢ ⴹ ⴼⵜⵓ⵰ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⴹ ⵗⵍⵙ ⵎⵛⵏ ⴹ ⵍⵓ ⵍⵗⵍⵙⵏⵜ ⴹⵏ ⵓⴹⵏ ⴹ ⴹⵜⵔⴾⵀⵏ ⴹⵗ ⵜⵎ⵿ⵙⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎⴰ ⵙ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵎⵙⵏ ⵂⵏ ⵏⵎⵛⵏⴰ ⵂⴰ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵂⵍⴾⵏ ⵂⵏ ⵏⵎⵛⵏⴰ ⵜⵂⵍⴾ ⵎⵛⵏⴰ⵰ ⴼⵍⵙ ⵂⵏ ⵏⵎⵛⵏⴰ ⵢ ⵤⴹⴶⵏ ⵎⵔⵏ ⴾⵓⵏⵢ ⵜⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ⴹ ⵓⵔ ⵙⴹⴼ ⵓⴹⵏ ⵓⵍⵢⵏ ⵎⵏⵜ ⵍⵈⵜⴰ⵰ ⵓⴰ ⴹⵗⵓⵏ ⵗⵍⵏ ⵍⴰ ⵎⵙⵏⵜ ⵜⴰ ⴼⵍ ⵜⴶⵍⴰ ⴹⵏⵜ ⵓⴹⵢ ⴶⵜ ⵎⵏⵜ ⵎⵙⴾⵍ ⴹ ⵜⴾⴼⵓ ⵎⵛⵏⴰ ⵎⵙⵏⵜ ⵜⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ⴼⵍⵙ ⵎⵙⵏⵜ ⵜⵏ ⴹⵏⵜ ⵜⴰ ⵎⵙⴾⵍ ⵜⵎⵙ ⵗⵔ ⵎⵛⵏⴰ ⴹ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵎⵙⵏⵏ ⵏⴹⵏⵜ ⵜⴰ ⵛⵎⵔⴾⵙ ⵛⵏⵙⵏ ⵙ ⵜⵏⵀⵤ ⵎⵛⵏⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ⵏⵏ ⴹⵗ «ⵙⵏ ⵎⵍⵢ ⵙ ⵎⴹⵔⵏⵏ ⵏⵎⵙⵏⵏ ⵏⴹⵏⵜ ⵜⴰ ⵓⵔ ⵤⵍⵢⵏ ⴹⵀⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⴹⴾⵍⵎ ⵎⵏⵓⵏ ⴼⵍⵙ ⵜⵍⴾⵎⵎ ⵢⵓⴹⵏ ⴼⵍⵙ ⵔⵜ ⴾⵍ ⵏⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ⴶⵔ ⵤⴰ ⵏⴾ ⵀⵍⵙ ⵓⵍⴰ ⵀⵍⵙ ⵓⵍⴰ ⵀⵜⵔⵙ ⵓⵍⴰ ⴹⵏⵜ ⵓⵍⴰ ⵜⵎⴹⵔ⵿ⵜ ⴹⵜⵎⵜⵏ⵿ⵜ ⴶⵔ ⵤⴰ ⵔⵜⵏ ⵓⵏ ⵎⵔⴹⴰ ⵓⵍⴰ ⵓⵏ ⵍⴾⵎⵏⵏ ⵓⴰ ⴾⵜⵏⵜ ⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵍⵎⵙⵈ ⴾⵓⵏⵍⵏ⵰ ⵍⵎⵙⵈ ⵎⵔⵏ ⵎⵛⵏⴰ ⵜⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ⴹⵗ ⴹⵢ ⵏⴾ ⴹⵀⵍⵙ ⴹⵏⵓⵔⵜⵓⴶⵓ ⴹⴼ ⵓⵔ ⵏⵎⵙ ⵔ ⵓⵏ ⵎⵛⵗⵍⵏ ⵏⵍⵎⵙⵈ ⴹⵍⵎⵓⴾⵍⵏⵜ ⵙ ⵎⵙ ⵛⵗⵍⵏⵙⵏ ⵎⵍ ⵢⵢⵜⴹⵏ ⴶⵜⵏ ⵏⵎⵛⵏⴰ ⵓⵏ ⴹⵙⵏⵂⵏⵏ ⵜⵏ⵿ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ⵎⵔⵏ ⵎⴰ ⵜⵓⵔⵏ ⴹⵗ ⵓⴹⵏ ⵎⵙⵏ ⵍⵎⵓⴾⵍ ⵔ ⴹ ⵎⵙ ⵓⴹⵏ ⵏⵍⵗⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ⵏⴾ ⵙ ⵎⵏⵏ ⵓⵔ ⵤⵍⵢⴰ ⴹⵗ ⴹⴼ ⵓⴰ ⴹⵗⵢ ⵜⴶⵎ ⵓⵍⴰ ⵓⴰ ⴹⵗⵢ ⴶⵏ ⵢⵜⴹⵏ ⵓⵢⴹ⵰ ⵏⴾ ⵙ ⵎⵏⵏ ⵓⵔ ⴶⵗ ⴹⴼ ⵓⵍⵢⵏ ⴹⵗ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ⵓⵔ ⴹⵜⵂⴰ ⵜⵔⴾ ⵏⵔⴾ ⵎⵤⵍ ⵓⵍⵢⵏ ⵎⵛⵏ ⵓⵔⴶⵗ ⴹⵢ ⴹⵤⴾⵙⵏ⵰ ⵎⵍⵢ ⵏ⵿ⵜⴰ ⴹⵤⵛⵔⵗⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵙⵓⵔⵎ ⵓⴹⵏ ⵓⵍⵢⵏ ⵍⵂⵏ ⴹⵜ ⵜⵓⵗⵍⵢ ⵏⵎⵍⵢ ⵙⵏ⵿ⵜⴰ ⵤⵙⴾⵏⵏ ⵤⵍ ⵎⵍⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵓⴶⵏ ⴹⵗ ⵙⵔ ⵙⴼⴶⵓ ⵓⴰ ⵂⵏ ⵓⵍⵏ ⵏⵢⵜⴹⵏ⵰ ⵍⵓⵆ ⵓⴹⵢ ⵓⴹⵏ ⴾⵍ ⴹ ⴶⵔⵓ ⵗⵔ ⵎⵛⵏⴰ ⵜⵎⵍ ⵜⴰ ⴹⵔ ⵂⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⴹⴾⵍⵗⵓⵏ⵿ⴹⵓ ⵙⵍⵏⵏ ⵏⴾ ⴹⵀⵍⵙ ⴼⵍ ⴹ ⵆⵍ ⵓⵏ ⵍⵎⵙⵍ ⴾⵓⵏ⵿ⵤⵙⵙⴶⵔⵏ ⵀⵜⵓ ⵜⴰ ⵜⵏⵜ «ⴹ ⵓⵔ ⵜⴾⵢⵎ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ»⵰ ⴶⵗ ⴹⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⴼⵍ ⴾⵓⵏⵓⵔⴶⵤ ⵓⴹⵏ ⵓⵍⵢⵏ ⵙⴼⵈⵔⵏ ⵙⵓⴹⵏ ⵢⵏ ⵍⴾⵓ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ⴾⵢ ⵓⴰ ⵜⴶⵏ ⵀⵔⴶⵏ ⵎⴰ ⴾⵢⵤⵍⵢⵏ ⴹⵢⵏ ⵓⴹⵏ⵰ ⵎⴰ ⵜⵍⵗ ⵙ ⵓⵔⴶⵗ ⵎⵛⵏⴰ ⴹⴾⴾⴼⵏ⵰ ⴹⴹ ⵤⵎⵙ ⵓⴰ ⵜⵍⵗ ⴾⵍ ⵜⵓⴾⴼⴰ ⴾⵢⵜⵓⴶⴰ ⵀⵏⵏ ⵎⴰ ⵎⵙⵏ ⵀⵔⴶⵏ ⵓⵏ ⵜⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ⴾⵓⵏⵢ ⵎⵔⴹⴰ ⵜⵍⵎ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵔⵎ ⵂⵔ ⵙ ⵜⴶⵔⴶⵙⵎ⵰ ⵜⵆⵍⵎ ⴼⴹⴰ ⵎⵏⴾⵍⵏ ⵏ⵿ⵜⴰ ⵏⴾⵏⵢ ⵓⵔ ⵜⵏ ⵏⵎⵙ⵰ ⵏⵙⴹⵔⵏ ⵜⵏ⵿ⵜⵆⵍⵎ ⵙ ⵜⴹⵜ ⴼⵍ ⴹⵔⵓⵏ ⵏⴹⵔⵓ ⵜⵗⵎⵔ ⵏⴾⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ⵎⵛⵏ ⵙ ⵜⵏⵗ ⵙⵔⵢ ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⴶⵏⴰ ⵎⵛⵏⴰ ⴹⵗ ⵍⵆⵎ ⵏⵢⵜⴹⵏ ⵏⵍⴰ ⴹⵢⵜⴹⵏ ⵙⵓⵔ ⵛⵔⵗⴰ ⵜⵎⵜⵏ⵿ⵜ ⵏⵜⵓⴶⴰ ⵔⵙ ⵏⵓⵏⴼ ⵢⴹⵏⵜ ⴾⵜⵏⵜ ⴶⵔ ⵤⴰ ⵢⵜⴹⵏ ⵓⵍⴰ ⵏ⵿ⴶⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ⵏⴾⵏⵢ ⵤⴰ ⵏⵆⵍ ⵙⵢⵜⴹⵏ ⵎⵙⴾⵍⵏ ⴼⵍ ⴹⵍⵍ ⵏⵛⵗⵍ ⵓⴰ ⵏⵜⴶ ⵢⵍⵎⵙⵈ ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⵆⵍⵎ ⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆⵏⵓⵏ ⴹⵔⵙ⵰ ⵏⴾⵏⵢ ⵏⵔⴾⵎ ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⵙⵂⵎ⵰ ⵏⵜⵓⴾⵢⴹ ⵎⵛⵏ ⴾⵓⵏⵢ ⵜⵜⵓⵙⵗⵎⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ⵏⴾⵏⵢ ⵓⵍⴰ ⵗⵙ ⵎⵔⴹⴰ ⴹⴰ ⵂⵏⴰ ⵍⵤ ⵏⴼⴹ ⵏⵤⵍⵎ ⵏⵜⵜⵓⵜ ⵓⵔ ⵏⵍⴰ ⴹ ⵏⵈⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ⵤⵗⵤⵀⵏⴰ ⵛⵗⵍ ⵏ⵿ⴼⵙⵏⵏⴰ⵰ ⵏⵜⵜⵔ ⴶⵏ ⵔⵈⵎⵜ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵏⵜⴶⵏⵏ ⵔⴾ ⵓⵍⵏ ⵏⵤⵎⵔ ⵢ ⵓⵏ ⴹⵏⵙⴾⵏⵏⵏ ⵔⴾⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ⵢⵜⴹⵏ ⵓⵏ ⵗⵛⴹⵏⵏ ⵙⵎⵓⵏⵏⴰ ⵏⴶⵎⵢ ⴹⵗⵙⵏ ⵙ ⵎⵏ ⵎⵍⵍⵏⵏ ⴹ ⵎⵤⵢⵏ ⴹⴹⵢ⵰ ⵂⵔ ⵂⵔⵓⴰ ⴹⴰ ⴶⵏⵏⵗ ⵢⵜⴹⵏ ⵛⵍⵜ ⵏ⵿ⴼⵔⴹⵏ ⵏⴹⵏⵜ ⴹⵙⴼⵔⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ⵓⵔ ⴹⵓⵏⵏⴾⵜⵀⵗ ⵔⵜⵏ ⵓⵏ ⴼⵍ ⴾⵓⵏⵤⵀⵤⴰ ⵜⴾⵔⴾⵜ ⴾⵍⵔ ⴾⵜⵀⵗⵓⵏ⵿ⵜⵏⵏ ⴼⵍ ⴹⵓⵏⴶⴰ ⵏⵙⵈⴰ ⵓⴰ ⵤⴶⴰ ⵢ ⵀⵔⵔⵏⵏ ⴾⵏ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ⵎⵔⵏ ⴾⴹ ⵜⵍⵎ ⵎⵔⵓ ⴶⵎ ⵏⵍⴼⵆⵢ ⴾⵓⵏ⵿ⵙⵙⵗⵔⵏ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⴹⴰ ⵓⵔ ⵜⵍⵎ ⵔ ⵀⴰ ⵢⵏ⵿ⴹⴰ ⴼⵍⵙ ⵤⵍ ⵓⴰ ⴹⵓⵏⴶⵗ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵍⴾⵎⵎⵙ ⵏ⵿ⵜⴰ ⴹ ⵆⵍⴰ ⵛⵍⵜ ⵏⵀⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ⴹⵢ ⴼⵍ ⴹⴶⵤⴰ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹⵜⵜⵍⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ⴹⵍⵍ ⵏⴹⵢ ⴹⴰ ⴼⵍ ⵙⵔⵓⵏ ⵏ⵿ⵤⵎⵤⵍⴰ ⵜⵎⵜⵢ ⵏⵔⵔⵢ ⴾⵏⵗ ⵜⵔⴰ ⵙⴼⵍⵙⵏ ⵓⵍⵏ ⴹⵗ ⵍⴾⵎⵏⵜ ⵢⵎⵍⵢ⵰ ⵙⴾⵗⵓⵏ⵿ⵜⵏ ⴼⵍ ⴾⵓⵏ⵿ⴹⵙⴾⵜⵓ ⵤⵏⴼ ⵏⵍⴾⵎ ⵓⴰ ⴶⵗ ⵢⵍⵎⵙⵈ ⵙⵏ⵿ⵜⴰ ⵙⵙⵗⵔⴰ ⴹⵗ ⵍⴾⵏⵙⵜⵏ ⴾⵍ ⴹⵗ ⴹⴶ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ⵓⵢⴹ ⴹⵗⵓⵏ ⵜⴶⵏ ⵀⵔⴶⵏ ⴼⵍⵙ ⵗⵍⵏ ⵓⵔ ⴾⵓⵏⵏ⵿ⵤⵍⵙⵗ ⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ⵎⵛⵏ ⵙ ⵜⵔⴶⵜ ⵏⵎⵍⵢ ⴾⵓⵏⵏⵙⴰ ⴹⵗ ⵍⵓⵆ ⵓⵔ ⵏⴶⴶ⵰ ⵍⵓⵆ ⵓⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵀⵔⴶⵏ ⴹⵢ ⴹ ⵏⵢⵗ ⵓⴰ ⴼⵔⴶⵏ ⵓⵔⴶⵗ ⵓⴰ ⴶⵏⵏ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ⴼⵍⵙ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵏ ⵢⵜⴹⵏ ⵙ ⵜⵔⵏⵏⵜ ⴹⵗ ⵜⵜⵓⵏⵢ ⵓⵔⴶⵗ ⵓⴰ ⴶⵏⵏ ⵙ ⵎⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ⵓⴾ ⵎⵏⵢ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⵓⴰ ⵜⵙⴼⵎ⵰ ⴾⵓⵏⵏⵙⴰ ⵓⵢⵗ ⵍⴾⴹ ⵎⵗ ⴾⵓⵏⵏⵙⵗ ⴹⵜⵔⴰ ⴹⵎⵏ ⵍⵎⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ⵢⵜⴹⵏ ⴾⵍ ⴶⵏⵏ ⵂⵓⵏ ⵓⴹⵏ ⵜⴶⵏ ⵤⵏⴰ ⴶⵏ ⵜⵍⵀⵙ⵿ⵜ ⵜⴰ ⴹⵗ ⵙ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ ⴹⴰ ⵓⵔ ⵜⵜⴶⵏ⵰ ⵎⵙⵏ ⵙ ⵂⵓⵏ ⵍⵙ ⵜⵏⵎⵏ⵿ⵙⵏ ⴹⵜⵏ⵿ⵜⵜ ⵏⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ⴶⵙ ⵂⵔⵓⴰ ⴹⴰ ⵜⵜⴶⵎ ⵀⵔⴶⵏ ⴹⴶ ⵏ⵿ⴾⵓⵏⵙⴾⵎⵓ ⴹⵢ ⵎⵏ ⵜⵤⵎⵤⵢⵎ ⵎⵏⵓⵏ ⴹⵓⴹⵏ ⵓⴰ ⵜⵎⵤⵍⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ⴾⴹ ⵏⴾ ⵓⵔ ⵗⵔⵓⵏ ⵍⵗ ⵙⵤⵜⵏ ⴹⴰ ⵎⵏⵏ ⵍⵏ ⵗⵔⵓⵏ⵰ ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⴶⵏ ⵎⵤⵍ ⵍⵀⵙⵏ ⵓⴹⵢ ⵀⵤⵆⵓ ⵙⵛⵔⵗⴰ ⵛⵍⵜ ⵏⵙ ⵍⵗ ⵗⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ⵙ ⵜⵎⵏⵢⵎ ⴶⵔⵓⵏ ⴼⵍ ⴹⵍⵍ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⴶⵤⵆⵓⵏⵏ ⵙ ⵎⵏⵏ ⵓⵔⴶⵗ ⵙⵤⵜⵏ ⴼⵍⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵜⵔⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ⵜⵢⵎ ⵓⴹⵏ ⵓⴹⵢ ⵢⵛⵢⵜⵏ ⴹ ⵜⵂⵍⴾ ⵜⵗⵙⵏⵜ ⴼⵍ ⴹ ⴶⵔⵓ ⴼⵙⵏ ⵤⵍ ⵓⵏ ⵜⵀⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ⵓⵔ ⵜⵍⵎ ⴹⵍⵍ ⵓⵍⵢⵏ ⴼⴹⴰ ⵙⴶⵢ ⵏⵀⵔⴶⵏ⵰ ⵓⴾ ⵓⵔ ⵜⵙⵏⵎ ⵙ «ⵔⵜ ⵏⵈⵎⵔⴰ ⵙⴾⴼⵏ ⵜⵀⵍⵍⵆ ⵏⴶⵍ ⵔⵓⵢⵏ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ⴾⵙⵜ ⴹⵗ ⵎⵏⵓⵏ ⵈⵎⵔⴰ ⵓⴰ ⵓⵛⵔⵏ ⵜⵎⵙⵏ ⵀⴾⴹ ⵜⵤⴹⴶⵎ ⴼⵍ ⴹ ⵜⵆⵍⵎ ⵛⵍⵜ ⵏ⵿ⵜⵀⵍⵍⵆ ⵏⴶⵍ ⵔⵓⵢⵏ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵙⵏ⵿ⵜⴰ ⵜⵎⵙⵎ ⴾⵍⴰ ⴹⴰ ⴼⵍⵙ ⵍⵎⵙⵈ ⵎⵙ ⵜⴼⵙⴾⵢⵏⵏⴰ ⵜⵏ ⵎⴹ ⵓⵏ ⴾⵢ ⵎⵜ ⴹⵗ ⴹⴶⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ⴹⵗ ⴹⵢ ⵏⵙⵗⵎⵔⵜ ⵎⴹ ⵓⵏ ⴾⵢ ⵓⵔⴶⵗ ⵙ ⵈⵎⵔⴰ ⵓⴰ ⵓⵛⵔⵏ ⵜⵎⵙⵏ ⵓⵍⵏ ⵂⴰ ⵛⵔ ⴹⵜⵍⵀⵙ⵿ⵜ⵰ ⴾⵍⵔ ⵏⵙⵗⵎⵔⵜⵓ ⵙ ⵜⴶⵍⴰ ⵜⴰ ⵓⵔ ⵂⴰ ⵈⵎⵔⴰ ⵜⵜⵎⵙⵏ ⵓⵍⵏ ⵤⴹⴶⵏⵏ ⵜⵂⴰ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ⴹⵗ ⵛⵔⵓⵜⵏ ⵜⴰ ⴹⵜ ⵜⴰ ⴾⵜⵀⵗⵓⵏⵏ ⵙ ⴹ ⵜⵓⵔ⵿ⵜⵎⵍ ⵜⵙⵆ ⵓⵍⵢⵜ ⴶⵔⵓⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵤⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ⵎⵛⵏ ⵢⴰ ⵓⵔ ⵙⴾⴰ ⵙⴹⵢ ⵀⴰ ⵏ⵿ⵜⵙⵆ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵛⴾⵍ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵔ ⴹⵗ ⴶⵢ ⵏⵤⵏⴰ ⵎⴹⵗ ⵓⵏ ⵙ ⴼⴼⵏ ⵓⵍⵏⵙⵏ ⵎⴹⵗ ⵓⵏ ⵏⵔⴾⵀⵏ ⴹⵓⵏ ⵗⵀⴹⵏⵏ ⵙⵏⵎⵏ ⴼⵍⵙ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵓⵔ ⵤⴰ ⵜⵆⵎⵎ ⵓⵔ ⴹⵔⵙⵏ ⵜⵙⵗⵎ ⵔ ⵙⴹ ⵜⴶⵎⴹⵎ ⴹⵏⵜ ⴾⵜⵏⵜ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ⴾⵍⴰ ⴾⵍⵔ ⴹⵓⵏ⵿ⴶⵏⴰ ⴹ ⵓⵔ ⵜⵙⵗⵎ ⴹⵓⴹⵏ ⵓⴹⵢ ⴶⵏⵏ ⵎⵙ ⵎⴹⵔⵢⵏⵓⵏ ⴹⵗ ⴹⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⵛⴾⵍ ⵔ ⴹⵗ ⴶⵢ ⵏⵤⵏⴰ ⴼⴼⵜ ⵓⵍⵏⵜ ⵗⵀⴹ ⵙⵏⵎⵏ ⵍⴰ ⵔⴾ ⵍⵙ ⵎⵙ ⵎⵛⵓⵢ ⵏⵙⵎⴹ ⵎⵙ ⵏⵔⴾⵀ⵰ ⵓⴹⵏ ⵛⵍⵜ ⵏⵓⴰ ⵓⵍⴰ ⵗⵙ ⵜⵜⵢ ⴹⴰ ⴹⵔⵙ ⵜⵜⵓⵔ⵿ⵜⴹⵔⵓⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","ⴼⵍⵙ ⵓⵔⴶⵗ ⵏⴾ ⵓⵔ ⴹ ⵀⵤⴰ ⵙⵛⵔⵗⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵎⵛⵏⴰ ⵜⵏ⵿ⵤⵀⵤⵏ ⵙⵛⵔⵗⴰ ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵏⵙⵜⵏⵓⵏ ⴾⵓⵏⵢ ⵓⵔ ⵜⵏ⵿ⵜⵀⵤⵎ ⵙⵛⵔⵗⴰ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴾⵙⵜ ⵗⵔ ⵎⵏⵓⵏ ⵏⵍⵀⵙ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ⵙ ⵍⵎ ⵔⵜ ⴶⵔ ⵢⵏ ⴹⵗⵓⵏ ⴹⵎⴹⵏⵜ ⵎⴰ ⴾⵓⵏⵙⵂⵍⵏ ⴹ ⵜⵜⴾⵎ ⵢⵜⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙ ⵎⵛⵏⴰ ⵢⴹⵓⵏⵛⵔⵗⵏ ⵜⵗⵍⵢⵎ ⵜⵎⵜⵢ ⵤⴹⴶⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵜⵎⵜⵢ ⵜⴹⵢ ⵏ⵿ⵜⴰ ⵤⴰ ⵜⵛⵔⵗⵜ ⵢⴹⵏⵜ⵰ ⴹⵗ ⴹⵢ ⴹⴹ ⵎⵙ ⵙ ⴾⵓⵏⵢ ⴹⵢ ⴹⴰ ⵤⵛⵔⵗⵏⵏ ⵢⴹⵏⵜ ⵎⵏⵎⴾ ⵙ ⵓⵔ ⵜⴼⵔⴶⵎ ⵛⵔⵗⴰ ⵏ⵿ⵜⵗⵓⵛⵓⵏ ⵎⴹⵔⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵓⵍⴰ ⵏ⵿ⴶⵍⵙⵏ ⵏⴾⵏⵢ ⴹⵙⵏ⵿ⵤⵛⵔⵗⵏ ⵏ⵿ⴶⵎⵏ ⵤⴰ ⵛⵗⵓⵛⵓⵏ ⵏⴹⵏⵜ ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ⴹⵗ ⴹⵢ ⵙ ⵜⵎⵍ ⵗⵛⴹ ⴶⵔⵓⵏ ⴹⵗ ⵜⵗⵓⵛⵢ ⵢⵜ ⵎⵏⵎⴾ ⵙ ⵜⵜⵢⵎ ⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⵓⵍⴰ ⵗⵔ ⵍⴾⵏⵙⵜ ⵛⵔⵗⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ⵎⵙ ⴼⵍⵓⵏ ⵜⴾⵔⴾⵜ ⴹ ⵎⵙ ⵙ ⵓⵔ ⴾⵓⵏⵂⴰ ⵓⴹⵏ ⵓⵍⵢⵏ ⵍⵏ ⵎⵙⵏⵜ ⵜⵜⵙⴼⵔⴶⵜ ⴹ ⵤⵎⵤⵢ ⵛⵔⵗⴰ ⵢ ⵎⴹⵔⵢⵏⵜ ⴹⵗ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ⵓⴾ ⵎⴰ ⴾⵓⵏⴶⵔⵓⵏ ⵙ ⵜⵛⵔⵗⵎ ⴶⵔⵓⵏ ⵂⵔ ⵜⵆⵎⵎ ⵛⵔⵗⵏⵓⵏ ⵢⵜⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ⵓⵍⴰ ⵏⵎⵛⵔⵗ ⵓⴰ ⵜⵜⴶⵎ ⴶⵔⵓⵏ ⴹⴰ ⴶⴹⵍ ⵤⵓⵔⵏ ⴹⵓⵏⵎⵙ⵰ ⵎⴼⵍ ⵓⵔ ⵜⵤⵤⵢⴹⵔⵎ ⴹⵀⴰ ⵏ⵿ⵜⴹⵜ ⵓⴰ ⴹⵓⵏⵜⵓⴶⵏ ⵎⴹⵗ ⵜⵤⵤⵢⴹⵔⵎ ⴹⵎⵗⵢ ⵓⴰ ⵜⵜⵓⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ⴹⴶ ⵏⴹ ⵜⴶⵎ ⴹⵢ ⴾⵍⴰ ⴾⵍⵔ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵎⵤⵍⵏ ⵙⵀⴰ ⵏ⵿ⵜⴹⵜ ⵜⵜⵗⵎ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵙ ⴼⴹⴰ ⵎⴹⵔⵢⵏⵓⵏ ⵎⵙⵏ ⴹⵗ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵏⵍⵀⵙ ⵓⵔ ⵤⴶⵔⵓⵏ ⴹⴶⵔ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵆⵍⵜⴹⵓ ⴹⵗ ⵈⵔⴾ ⵓⴰ ⵜⴶⵎ ⵜⵙⵏⵎ ⵙ ⵎⴶⵏ ⵏⵤⵏⴰ ⴹⵢⵜⴹⵏ ⵓⵏ ⵗⵀⴹⵏⵏ ⵙⵏⵎⵏ ⴹⵓⵏ ⵜⴶⵏⵏ ⵢ ⵜⴹⴹⵏⵙⵏ ⵛⴹⴹⵏ ⴹⵎⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵎⵏⵙⵏ ⵛⴹⴹⵏ ⴹⵓⵏ ⵜⴶⵏⵏ ⵎⴹⵓⵏⵙⵏ ⵛⴹⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ⴹⵀⵢⴹⴶⵏ ⴹⵓⵏ ⵙ ⴼⴼⵏ ⵓⵍⵏⵙⵏ ⴹⵎⵛⵓⵏ ⵏⵙⵎⴹ ⴹⵎⵓⵢⵏ ⵏ⵿ⵜⵏⵓⵏ ⴹⵏⵔⴾⵀⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵍ ⵓⵔ ⵍⵏ ⴹⴶⵔ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ⵓⵢⴹ ⴹⵗⵓⵏ ⴾⵍⴰ ⴹ ⵂⵏ ⵙⵎⵍ ⵏⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵎⵛⵏ ⵎⵔⴹⴰ ⵜⵜⵓⵛⵔⴹⵎ ⴹⵗ ⵓⵏ ⵜⵜⵓⵤⵤⴹⴶⵎ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵜⵙⵙⵗⴹ ⵜⵔⵢⵜ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵍⵏⵏⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ⵜⴶⵏⵎ «ⵔⵜ ⴾⵍ ⵈⵍⵍⵏ» ⵜⴹⵜ ⵎⵛⵏ ⵓⵔⴶⵗ ⵔⵜ ⴾⵍ ⵜⵂⵢ ⵜⵏ⵿ⴼⴰ⵰ ⵜⴹⵜ ⵙ «ⵔⵜ ⴾⵍ ⵈⵍⵍⵏ» ⵎⵛⵏ ⵏⴾ ⵓⵔ ⵤⵢⵗ ⵔⵜ ⵓⵍⵢⵏ ⵜⴼ ⴹⵗⵢ ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ⵜⴶⵏⵎ ⴹⵗ «ⵙⴹⵔ ⵜⴹⵙ⵿ⵜ ⴼⵍ ⴹⵈⵍⴾⵏ ⵎⵔⵏ ⵜⴹⵙ⵿ⵜ ⵙⴹⵔ ⴼⵍ ⴹⵜⵈⵍⴾ⵰» ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⵜⴹⵙ⵿ⵜ ⵂⵔⴾⴹ ⵎⵏ⵿ⵙⵓⵏ ⵍⴾⵎ ⴹ ⵙⵀⵓ ⵎⵛⵏⴰ ⵜⵎⵢⵎⵢⵜⵏⵙⵏ⵰ ⵜⵗⵙⴰ ⵏⵓⴹⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⴹⵜⵈⵍⴾ ⴼⵍ ⴹ ⵜⴶⵓ ⵤⵏⴰ⵰ ⴾⵍⵔ ⵜⵈⵍⴾⴹⵓ ⴼⵍ ⴹ ⵜⴶⵓ ⵜⵔⴰ ⵏⵎⵍⵢ ⵙⵏ⵿ⵜⴰ ⵜⵜⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ⵎⵔⵏ ⵎⵛⵏⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵏⴹⵗⵙⴹⵙⵏ⵿ⴾⵔ ⵏⴾⵏⵢ ⴹⴰ ⵙ ⵜⵔⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ⵓⵔ ⵜⵙⵏⵎ ⵙ ⵛⵗⵙⵓⵏⵓⵏ ⵛⵙⵍⴹ ⵏⵍⵎⵙⵈ ⵎⵙⵏⵜ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⵙⵔ⵿ⵜⵢⴰ ⵛⵙⵍⴹ ⵏⵍⵎⵙⵈ ⴹⵜⵗⵙⴰ ⵏ⵿ⵜⴾⵔⵓⵜ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵓⵔ ⵍⴾⵎ ⴹ ⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ⵎⵗ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵓⴹⵏ ⵓⴰ ⵙⵔ⵿ⵜⵢⵏ ⵎⵏⵜ ⴹⵜⴾⵔⵓⵜ ⵓⴹⵢ ⵆⵍ ⴹⵔⵙ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵍⵙ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⴹ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ⵓⴹⵏ ⵎⵔⵏ ⵓⴰ ⵔ⵿ⵜⵢⵏ ⴹⵎⵍⵢ ⵓⴹⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵍⵢ ⵜⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ⴹⵔⴶⵜ ⵢⴶⵢ ⵏⵤⵏⴰ⵰ ⵀⴾⴹⵏ ⴾⵍ ⵓⵏ ⵜⵎⵤⵍⵏ ⵢⵜⴹⵏ ⵓⵔ ⴹⵔⵓⵏ ⵔⵜ ⴹⵜⵗⵙⵓⵏⵙⵏ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴶⵏ ⵤⵏⴰ ⵓⴹⵢ ⴶⴰ ⵀⴾⴹ ⵎⵔⵏ ⵜⵗⵙⵏⵜ ⵜⵎⵙⵜ ⵜⵙⵍⵜ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵛⵗⵙⵓⵏⵓⵏ ⵂⵏ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵙⵏⵜ ⴾⵓⵏⵂⵏ ⴾⴼⵓⵏ⵿ⵜⵓ ⵎⵛⵏⴰ⵰ ⵓⵔⴶ ⴾⵓⵏⵢ ⵍⵏ ⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ⴼⵍⵙ ⵤⵏ⵿ⵤⵓⵏ⵿ⴹⵓ ⵎⵛⵏⴰ ⵙⵍⵆⵎⵜ ⵤⵓⵔⵜ⵰ ⴹⵗ ⴹⵢ ⵙⵗⵎⵔⵜ ⵎⵛⵏⴰ ⵙ ⵜⵗⵙⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵙⵙ⵿ⵜⵏⵏ ⵓⵏ ⴹⴹⵜⴶⵎ ⴹⵗ ⵛⵔⵓⵜ ⵜⴰ ⴹⴹⵜⴾⵜⵀⵎ ⵜⵏⵎ «ⴼⴰ ⵢⵍⵙ ⴹ ⵆⵎ ⵓⵔ ⵏⵎⵏ⵿ⵙⴰ ⴹⵜⵏ⵿ⵜⵜ ⴾⴹⵗ ⵜⴰ ⵤⵍⴼ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⴼⵍ ⴹⵔⴶ ⵢⴶⵢ ⵏⵤⵏⴰ ⴾⵍⴾ ⵏⵍⵙ ⴼⴰ ⴹ ⵍⴰ ⵜⵏ⵿ⵜⵜ ⴾⵍⴾ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⵍⴰ ⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ⴶⵜ ⵍⵙ ⵢ ⵜⵗⵔⵙ ⵔⵜ ⵓⵙ ⵓⵌⵀ ⴹⵙ⵿ⵜⴶⵓ ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⴶⵜ ⵢⵍⵙⵏⵜ ⵓⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ⵜⵏ⵿ⵜⵜ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵜⵜⴼⵜ ⵜⵏⵜ ⴹⵗ ⵜⵗⵙⵏⵜ ⵍⵙⵏⵜ ⵜⴼⵏ ⵜⵏⵜⵏⵜ⵰ ⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵜⴼⵏ ⵜⵏⵜ ⴹⵗ ⵜⵗⵙⵏⵜ⵰ ⵜⵏ⵿ⵜⵜⵏⵜ ⵜⵜⵜⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵏⵎⴶⴹⵍⵎ ⵎⵏⵓⵏ ⵔ ⵙⴹ ⵜⵏⵎⵔⴹⵎ ⵙⴹⵢ ⴹⵗ ⵜⵎⵔ⵿ⵜ ⵜⵙⴾⵜⵎ ⵢ ⵜⵓⵜⵔⵓⵏ⵰ ⵙ ⵜⵗⵔⴹ ⵜⵆⵍⵎ ⵜⵎⵓⵜ ⵜⴰ ⵜⵓⵌⵀⵜ ⴼⵍ ⵍⵙ ⴹⵜⵏ⵿ⵜⵜⵏⵜ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏⴹ ⵀⵙ ⵜⵏⴹⵎ ⴹⵗ ⵎⵏⵓⵏ ⴶⵔⵓ ⵙⵔⵓⵏ ⵛⵢⵜⵏ ⵜⵔⵢⵜ ⵙⴾⵓⵏⵌⵔⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ⵔⵜ ⵓⴰ ⵏⵗ ⴹⵢ ⵜⵔⴶⵜ ⵏⴶⵏⵜ ⴾⵓⵏⴾⴼⵗ ⵓⵔⴶⵗ ⵎⵔ ⴾⵓⵏ⵿ⵙⵔⵙⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ⵏⴾ ⵙⴹⵔⵏⴰ ⴹⵔⵢ ⵍⵏ ⵢⵜⴹⵏ ⴾⵍ ⴼⵔⴶⵏ ⴹ ⵆⵎⵏ ⵓⵔ ⵤⵍⴼⵏ⵰ ⵎⵛⵏ ⵢⴰ ⴾⵢⵏ ⴹⵗⵏⴰ ⴹⵜⵂⴾⵜ ⵜⴰ ⴹⵙⴶⴰ ⵎⵛⵏⴰ⵰ ⵓⵢⴹ ⴹⵗⵏⴰ ⵓⵔ ⴼⵔⴶⵏ ⴹ ⵓⵔ ⵤⵍⴼⵏ ⵓⵢⴹ ⴶⵔⵓⵏ ⵜⵂⴾⵜ ⵜⵎⵙⵜ ⴼⵔⴶⵜ ⵢⵎⵗⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ⵎⵔⵏ ⵎⴹⵏ ⵓⵏ ⵙ ⵀⴰ ⵛⴹⴹⵏⵙⵏ ⴹⵜⴹⴹⵏ ⵛⵏ ⵙ ⵀⴰ ⵎⴹⵏⵙⵏⵜ ⴼⴰ ⴹ ⴶⵏ ⵓⴰ ⴶⵗ ⵆⵎⵏ ⴹⴰ ⵓⵔ ⵤⵍⴼⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵓⵔ ⴼⵔⴶⵏ ⴹⵢ ⵓⴹⵢ ⵤⵍⴼⵏⵜ⵰ ⴼⵍⵙ ⴼⴰ ⵢⵓⴹⵏ ⴹ ⵤⵍⴼ ⵆⵎ ⴹⴰ ⵓⵔ ⵙⵀⵍⴶⵍⴶ ⴹⵔⵏ ⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵏ ⵤⵍⴼⵏⵏ ⵎⵔⵆⵏ ⵙⵙ ⵜⵏ⵿ⵜⵜ ⴹ ⵓⵔ ⵜⵎⵤⵢ ⴹⵍⵙⵏⵜ⵰ ⵎⵍⵢ ⵏⵏ ⴹⵢ ⵓⵔⴶ ⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⵜⵎⵤⵢ ⴹⵔⵙ ⵓⴹⵢ ⵜⵆⵎⵜ ⵓⵔ ⵜⵤⵍⴼ ⵎⴹⵗ ⵜⴾⵏⵓ ⴹⵍⵙⵏⵜ ⵜⵆⵍ⵿ⵜⵓ⵰ ⵍⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⴹ ⵓⵔ ⵤⵎⵤⵢ ⵜⵗⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵗⵙⵏ ⵎⴹⵔⵢ ⴹⵗ ⴹⵏ ⵓⵙ ⵓⵔ ⵜⵤⴶⵤⵏ ⵜⵏ⵿ⵜⵜⵏⵜ ⵙ ⵗⵢⵙⴰ ⴶⵙ ⵜⵔⴹⴰ ⵙ⵿ⵜⵜⵜⴼ ⵓⴹⵢ ⵜⵜⵓⵔⵤⵎⵤⵢ⵰ ⵀⵜⵓ ⵜⴹⵢ ⵏⴾ ⵜⵜⴶⵏ ⵓⵔⴶ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵗ ⴹⵏ ⵜⵙ ⵓⵔ ⵤⴶⵤⵏ ⵍⵙⵏⵜ ⵙ ⵗⵢⵙⴰ ⴶⵙ ⴶⵍⴰ ⵔⴰ ⵗⵔⵙ ⵜⵍⴰ ⵜⴹⵢ ⵜⵓⵔ⵿ⵜⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ⴼⵍⵙ ⵍⵙ ⵓⴹⵢ ⵓⵔ ⵏⵤⴶⵤⵏ ⴹⵢ ⵤⴹⴶ ⴹ ⵜⵏ⵿ⵜⵜⵏⵜ ⵜⵎⵙⵜ ⵢⵜ ⴹⵗ ⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⴹⵢ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⴹⵢ ⵜⵤⴹⴶ ⴹ ⵍⵙⵏⵜ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⵎⴹⵔⵢⵏ ⴹⵗ ⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ⵰ ⴹⵢ ⵤⵤⴹⴶⵏ ⵀⵔⵔⵏⵙⵏ ⵎⵛⵏ ⵏⵔ ⵓⵔ ⴶⴰ ⴹⵢ ⵀⵔⵔⵏⵙⵏ ⵂⵏ ⵏ⵿ⵜⵈⵔⵎ⵿ⵜ ⴹⵆⵏ ⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⵗ ⵓⴰ ⴹⵗⵙⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⴶⵔ ⵤⴰ ⵍⵙ ⵓⵍⴰ ⵜⵏ⵿ⵜⵜ ⵙ ⵔⴰ ⵎⵤⵢ ⵏⵓⴰ ⵂⴹⵏ ⵎⵤⵢⵜ ⴹⵔⵙ⵰ ⵎⴹⵔⵢ ⴹⵗ ⵤⴶⵤⵏ ⵓⴹⵢ ⵎⴹⵗ ⵜⵎⴹⵔⵢⵜ ⵜⴹⵢ ⵓⵔ ⵜⴹⵤⵆⵍ ⵛⵔⵗⴰ ⵏⴹⵢ ⴼⵍⵙ ⵎⵛⵏⴰ ⵜⵎⴹⵔ⵿ⵜ ⵂⴰ ⵍⵈⵔ ⵙ ⵔⴰ ⵜⵜⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ⵎⴰ ⵙⵏⵏ ⵎⵌⵙ ⴾⵎ ⵜⵏ ⵜⵎⵤⴶⵤⵏ⵿ⵜ ⵙ ⵗⵢⵙⴰ ⴹⵤⵓⵢⵏ ⵙⵍⵙⵏⵎ ⴹ ⴶⵔⵓ ⴼⵙⵏ⵰ ⴾⵢ ⴹⴰ ⵍⵙ ⵓⵏ ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵎⴰ ⵙⵏⵏ ⵎⵌⵙ ⴾⵢ ⴹⵤⵓⵢⵏ ⵙ ⵜⵏ⵿ⵜⵜⵏⴾ ⴹ ⵜⴶⵔⵓ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⵓⵏ⵿ⴹⵢ ⴾⵢⵏ ⴶⵍⵜ ⴹⵗ ⵍⵈⵍⵜ ⵜⴰ ⴹⵆⵓ ⴶⴰ ⵎⵍⵢ ⵗⵢⵙⴰ ⵜⵎⵙ ⵜⵂⴾⵜⵏⵜ ⵙⵏ⵿ⵜⴰ ⵂⴰ ⵙ ⵜⵗⵔⴰ ⵎⵛⵏⴰ⵰ ⵎⵔ ⵓⴹⵢ ⵜⴶⵗ ⵍⴾⵏⵙⵜⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ⴾⴹ ⵓⴹⵏ ⵎⵏ⵿ⴾⴹ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ ⵓⴹⵢ ⴹⵙⵓⵔⵆⵍ ⴹⵢ ⵙⴾⵔ⵰ ⴾⴹ ⴹⵗ ⵓⴹⵏ ⵓⵔ ⵎⵏ⵿ⴾⴹ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ ⴹ ⵓⵔ ⴶⵎⵢ ⴹⴹ ⵜⵓⵙⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ⵎⵏ⵿ⴾⴹ ⵓⵍⴰ ⵀⵏⵜ ⵓⵔⴶⵗ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵔⵜ ⵎⵤⵍ ⵙⵎⵔⵏ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ⴾ ⵓⴹⵏ ⴶⵍⵜ ⴹⵗ ⵍⵈⵍⵜ ⵜⴰ ⵂⴰ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ⴾⴹ ⵙ ⴾⵢⴹⵗⵔⴰ ⵎⵛⵏⴰ ⴾⵍⵢ ⵜⵎⵙⵗ ⴾⵢⵓⵔⵛⵓⵛ ⴹⵢ⵰ ⵎⵛⵏ ⵙ ⵜⴶⵔⵓⴰ ⵜⵔⵢⵜ ⵙ ⵜⴹⵔⴼⵜ ⵙⵔⵙ ⵓⵔ ⵜⴶⵢⴰ ⴾⵍⵔ ⴹⵔⴼⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵎⵙⵏ ⴾⵍⵢ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ ⵢⵜⵜⵎⵍ ⵜⵙⵆ ⴶⵔⵙ ⴹⵎⵍⵢ ⵓⴹⵢ ⴹ ⵆⵍ ⴹⵔⴼ ⵏⵎⵍⵢ⵰ ⵎⴾ ⴹⵢ ⴹⵗ ⵙ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵎⵙ ⴾⵍⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ ⴹ ⵆⵍ ⴾⵍⵢ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ⵎⵍⵢ ⵔⵤⵎⵏ ⴼⵍⵓⵏ ⵙⴹⵔⴼⵜⴾⵓⵏ⵰ ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵢⵎ ⵢⵜⴹⵏ ⴶⵏ⵿ⴾⵓⵏ ⴾⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ⵎⴹⵔⵢⵏⵏ ⴾⵢⵏ ⴹⵗⵓⵏ ⴶⵍⵜ ⴶⴰ ⵜⵎⵏⵜ ⴹⵗ ⵎⵛⵏⴰ ⵆⵎ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵗ ⵍⵈⵍⵜ ⵜⴰ ⵂⴰ ⵙ ⵜⴹⵗⵔⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⴹⵙ ⵤⵍⴼ ⵓⵔ ⴹⴾⴼⴰ ⵎⵛⵏⴰ ⵎⵔ ⵓⵍⵢⵏ ⵢⵙⵏ⵰ ⵎⵛⵏ ⴹⵓⵏⴶⵗ ⵏⵙⵈⴰ ⵏⵙⵈⴰ ⴹⵢ ⴹⴰ ⴶⵓⵏ⵿ⵜⵓ ⵍⵙ ⴶⵔⵓⵏ ⴹⵗ ⵂⵏⵜⴰ ⵏⵎⵍⵢ ⵜⵛⵜ ⵏⵓⴹⵏ ⵙⴼⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ⵤⵎⵏ ⵏⵍⵗⵤⵀ ⴼⵍⵏⵗ ⴶⵏⵏ ⴹⵗ ⴹⵢ ⵍⴰ ⵗⵔⵢ ⵙ ⴼⴰ ⵢⴾ ⵓⴹⵏ ⴾⵍ ⴹ ⴶⵍⵓ ⴹⵗ ⵍⵈⵍⵜ ⵜⴰ ⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ⴾⴹ ⴾⵢ ⵜⵙⵎⵔⴾⵙⴰ ⴹⵜⵏ⵿ⵜⵜ ⴹ ⵓⵔ ⵜⴶⵎⵢⴰ ⴹⵔⵙ ⵜⵎⵤⵢⴰ⵰ ⴾⴹ ⵓⵔ ⵜⵤⵍⴼⴰ ⴹⵔⵙ ⵓⵔ ⵜⴶⵎⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵙ ⵜⵤⵍⴼⴰ ⵓⵔⴶ ⵀⴾⴹ ⵜⴶⵗ⵰ ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⴰ ⵓⵔ ⴹⵙ ⵤⵍⴼ ⵙ ⵜⵤⵍⴼ ⵓⵔⴶⵗ ⵀⴾⴹ ⵜⴶⴰ⵰ ⵎⵛⵏ ⵢⴰ ⵢⵜⴹⵏ ⵓⵏ ⵤⵍⴼⵏⵏ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹ ⵏⵢⵏ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⵙⵏ⵿ⵜⴰ ⵙ ⵔⵗ ⵜⵏⴶⵤⴰ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ⵓⴰ ⴼⵍ ⴹⵓⵏ⵿ⴶⵏⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵙ ⵜⵙⵍⴾⵎ⵿ⵜ ⵏⵍⵓⵆ ⵏⵂⴰ ⴹⴰ⵰ ⴹⵗ ⴹⵢ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵤⵍⴼⵏⵏ ⴶⵏⵜ ⵙ ⵛⵍⵜ ⵏⵙ ⵓⵔ ⵤⵍⴼⵏ ");
INSERT INTO ttqt_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ⵓⵏ ⵂⵍⵏⵏ ⵛⵍⵜ ⵏⵙ ⵓⵔ ⵂⵍⵏ ⵓⵏ ⴼⵍⵓⵙⵏⵏ ⵛⵍⵜ ⵏⵙ ⵓⵔ ⴼⵍⵓⵙⵏ ⵓⵏ ⴹⵤⵏ⵿ⵤⵏⵏ ⴹⵗ ⵜⴼⵏⵜ ⵙ ⵔⵜ ⵓⴰ ⴹⵤⵏ⵿ⵤⵏ ⵓⵔ ⵜⵍⵏ ");
INSERT INTO ttqt_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⵜⵗⵎⵍⵏⵏ ⵔⵜⵏ ⵏⴹⵏⵜ ⵜⴰ ⴹⵗⵙⵏ ⵓⵔ ⵤⵤⵓⵏ ⴼⵍⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵜⴶⵏ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⵏⵂⴰ ⴹⴰ ⵜⵏ ⵗⵔⴹ ⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ⵏⴾ ⵎⵔⵏ ⵔⵗ ⴹ ⵜⴶⵎ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⴾⵓⵏⵓⵔⵛⵓⵛ ⵓⵍⴰ⵰ ⵍⵙ ⵓⴰ ⵓⵔ ⵏⵤⵍⴼ ⴼⵔⴶ ⴹⴶⵤ ⴹⵗ ⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⴼⵍⵙ ⵔⴰ ⵎⵍⵢ ⴼⵍⵙ ⴶⵎⵢ ⴹⵎⴾ ⵓⵙ ⵤⴶⵔⵤ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ⵎⵛⵏ ⵍⵙ ⵓⴰ ⵤⵍⴼⵏ ⵛⵗⵓⵛⵓⵏ ⵏⴹⵏⵜ ⴹⵗ ⴹⴶⵤ ⴶⵎⵢ ⵎⴾ ⵓⵙ ⵜⵤⵜⵔⵓ ⵜⵗⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ⵜⵤⵔ ⵜⵤⵏ ⵏⵢⵜⵏⵜ ⴶⵔ ⵜⵔⴰ ⵏⴶⵢ ⵏⵓⴰ ⵜⵔⴰ ⵜⵏ⵿ⵜⵜⵏⵜ ⴹⵓⴰ ⵔⴰ ⵎⵛⵏⴰ⵰ ⵎⵔⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵓⵔ ⵏⵤⵍⴼ ⴹⵜⴰ ⵓⵔ ⴹⵙ ⵤⵍⴼ ⴼⵔⴶⵏⵜ ⴹⴶⵤ ⴹⵗ ⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⴼⵍⵙⵏⵜ ⵔⴰ ⵎⵍⵢ ⴼⵍⵙ ⵔⵏⵜ ⴹ ⵙⴾⵜⵏⵜ ⵜⵎⴹⵔ⵿ⵜⵏⵙⵏⵜ ⴾⵜⵏⵜ ⵢⵍⵗⵀⴹⴰ ⵏⵎⵍⵢ⵰ ⵎⵛⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵤⵍⴼⵜ ⵛⵗⵓⵛⵓⵏ ⵛⵏ ⴹⵏⵜ ⴹⵗ ⵜⴹⴶⵤ ⵜⴶⵎⵢ ⵎⴾ ⵓⵙ ⵜⵜⵤⵔⵓ ⵍⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ⵔⵜ ⵓⴰ ⵏⵗ ⴹⴰ ⵜⵏ⵿ⴼⵏⵓⵏ ⴹⵗⵓⵏ ⵜⵏⵗ ⵓⵔⴶⵗ ⵤⴾ ⵢⵏ ⴾⵓⵏ⵿ⵙⵓⵔⴰ⵰ ⴾⵍⵔ ⵜⵔⴰ ⴶⵗ ⴹ ⵜⴶⵎ ⵓⴰ ⵏⵂⴶⵏ ⵜⵍⴾⵎⵎ ⵢⵎⵍⵢ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ⵙ ⴶⴰ ⵍⵙ ⵔⴾⵓⵍ ⵏⵤⵍⴼ ⵢ ⵜⵎⴹⵜⵏⵜ ⵂⵔ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵂⵔ ⵜⵜⵤⵍⴼ ⵎⵔⵏ ⴾⵙⴹ ⵙⴾⵔⴾⴹⵏⵜ ⵓⴹⵢ ⵤⵍⴼⵜⵜ ⴾⴹ ⴹⵢ ⵔⴰ ⵓⵔ ⵎⵙ ⵓⵏ ⵀⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ⵎⵛⵏ ⵍⵙ ⵓⴰ ⴹⵏ⵿ⴾⵔⵏ ⴶⵔⵙ ⴹⵎⵏⵜ ⵙⵎⵔⴾⵙ ⵙ ⵓⵔ ⵤⵤⵍⴼ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⴹⵔ ⵎⵔⴾⵏ ⵤⵍⴼ ⵎⵔⵏ ⵎⵙ ⵓⴹⵏ ⴼⵔⴶⵏ ⴹⵗ ⵎⵏⵜ ⵓⴹⵢ ⴶⴰ ⵔⵜ ⵂⵙⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ⴹⵗ ⴹⵢ ⵓⴹⵏ ⵓⴰ ⵙⵏ⵿ⴹⵏ ⵔⴾⵓⵍ ⵏⵤⵍⴼ ⵢ ⵜⵎⴹⵜⵏⵜ ⴶⴰ ⵔⵜ ⵂⵙⵢⵏ⵰ ⵎⵛⵏ ⴼⵢ ⵓⴰ ⴶⵏ ⵜⵏⵜ ⵏ⵿ⵜⵜⵓⵔⵤⵍⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ⵜⵏ⵿ⵜⵜ ⵜⵤⵍⴼⵜ ⵍⵤⵎ⵿ⵜⵜ ⵎⵍ ⵗⵔ ⵍⵙⵏⵜ ⴾⵜ ⴹⵔ⵰ ⵎⵛⵏ ⵙ ⵜⵀⴰ ⴹ ⵜⵍⵓ ⵜⵔⵢⵜ ⵏⵤⵍⴼ ⵏⵢⵏ ⵍⵙ ⵓⴰ ⵜⵔⴰ ⴶⵙ ⴾⵏ⵿ⴹⵀⴰ ⵓⴰ ⵤⴶⵤⵏⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ⵎⵛⵏ ⵏⴾ ⴹⵗ ⴹⴼ ⵓⵏⵏ ⴶⵔ ⵀⵍⵍ ⵓⴰ ⵤⴰ ⵜⴶⵓ ⵙ ⵜⵆⵎ ⵓⵔ ⵜⵤⵍⴼ⵰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⴹⵙⵙⴶⵏ ⴹⴼ ⵓⴹⵢ ⵎⵔⵏ ⵏ⵿ⴼⵙⵏ ⴹⵗ ⵙ ⴶⵗ ⴹⴼ ⵏⵙ ⴶⵔⵓⵆⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵙⵏ ⵏ⵿ⵜⵤⴶⵤⵎ ⵛⵏ ⵜⵓⴶⵏⵏ ⵢⵙⵏⵎⵏ ⵜⴰ ⴹⵔⵢ ⵜⵙⵙ⵿ⵜⵏⵎ ⵜⵏⵎ «ⵎⵙⵏⵜ ⴾⵜⵏⵏⴰ ⵏⵍⴰ ⴹⵗⵙ ⵔⵜ»⵰ ⵜⴹⵜ ⵎⵙ ⴹⵢ ⵎⵛⵏ ⵤⴰ ⵎⵙⵏⵜ ⴹⴾⵍ ⵏⵎⵏ ⴹⵜⵜⵓⵢ ⵙⵓⴹⵏ ⵙ ⴶⴰ ⵓⵏ ⵜⵔⴰ ⵏ⵿ⵜⴰ ⵙⵙⵂⵢ ⵜⵜⴶⵓ ⵤⴶⵤⵏ ⵏⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ⵓⴹⵏ ⵓⴰ ⵗⵔ ⵍⴰ ⵙ ⵍⴰ ⵎⵙⵏⵜ ⵓⴹⵢ ⵂⵔⵓⴹⴰ ⵓⵔ ⵙⵏ ⵓⵙ ⵎⴾⵏ ⴹ ⵜⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⵔⵏ ⵎⵛⵏⴰ ⵤⴹⵢⵜⵓ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵜⵢ ⵏ⵿ⵙⵏ ⵏ⵿ⵜⵤⴶⵤⵎ ⵛⵏ ⵜⵓⴶⵏⵏ ⵢⵙⵏⵎⵏ ⵏⵙⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⵙⵏⵎ ⵎⵙⵏ ⵎⵍⵢ ⵎⵛⵏⴰ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵜⵍⵏ ⵎⵙ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ⵓⵍⴰ ⴹ ⵜⴼⵏ ⵢⵜⴹⵏ ⵙ ⵍⵏ⵿ⵜⵓ ⵙⵏⵎⵏ ⴶⵜⵏⵏ ⴹⵗ ⵌⵏⵓⵏ ⴹⵎⴹⵍ ⵜⵓⵗⵀⴹⵏⵏ ⵎⵔⵏ ⵜⴹⵜ ⵙ ⵍⵏ⵿ⵜⵓ ");
INSERT INTO ttqt_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ⴹⴰ ⵗⵔⵏⴰ ⵎⵛⵏⴰ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵜⵍⵏ⵰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵀⵏⵏⴰ ⵈⵍⴾⴹⵓ ⵓⴰ ⵜⵍⵏ ⴾⵍ ⵙⵏ⵿ⵜⴰ ⴹⵏⵗⵍⵏ ⵏⵙⵏ⵿ⴹⵓ ⵜⵔⵏⵜ⵰ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵔ ⵎⵍⵢ ⵢⵏ⵿ⴹⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵙⵙⵀⵀⵏⵜ ⵙ ⵜⵍⴰ ⵔⵜ ⴾⵍ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵏⵗⵜⴼⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ⵎⵛⵏ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⴾⵍ ⵜⵓⴹ ⵎⵙⵏⵜⵏⵙⵏ ⴹⵢ⵰ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵙ ⴾⵍⴰ ⵤⴶⵤⵏⵏ ⵙⵙⵏⵎⵏ ⵂⵔⵓⴰ ⴹⴰ ⵙ ⵜⵛⵏ ⵙⵏ ⵏ⵿ⵜⵤⴶⵤⵎ⵿ⵜ ⵢⵙⵏⵎ ⴹ ⵛⴾⵏ ⵎⵏⵙⵏ ⵎⵍ ⵗⵔⵙⵏ ⵙ ⵙⵎⴹⵙ⵿ⵜⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵓⵔⴶⵗ ⵜⵜⵢ ⵏⵎⵏ⵿ⵙⵢ ⴹⵏⵤⵤⵏⵎⵂⵤⵏ ⴹⵎⵛⵏⴰ ⴶⵔ ⵤⴰ ⵏⵜⵛⴰ ⵙⵏ ⵓⵏ ⴹⵢ ⵓⵍⴰ ⵓⵔ ⵜⵏⵜⵛⴰ ⵓⵔⵎⴹ ⴹⵏⵤⵜⴼⵏⵤ ⵜⵜⵢⵏⵙⵏ ⵙⵔⵜ ⵓⵍⴰ ⴹⵗ ⵜⵛⵜⵏⴰ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ⴶⵙ ⵢⴰ ⵏ⵿ⴾⴹⵜ ⴹⵎⵏⵓⵏ ⵜⵔⵢⵜ ⵜⴰ ⵜⴶⵔⵓⵎ ⴹⵢ ⴹⵓⵏ⵿ⵜⵙⵈⵍⵍⵜ ⵜⵜⵢ ⵏⵎⵏ⵿ⵙⵢ ⴾⵍ ⴹ ⵓⵔ ⵜⵆⵍ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵓⴹⵏ ⵓⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ⴼⵍⵙ ⴾⵢ ⵓⴰ ⵍⵏ ⵎⵙⵏⵜ ⵜⴹⵢ ⵙ ⴾⵢⵏⵢ ⵎⴹⵔⵢⵏⴾ ⴹⵗ ⴹⵏ ⵓⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵜ ⵜⵆⵎⴰ ⴹⵗ ⴹⴶ ⵏⵍⵗⵀⴹⴰ ⵏⵙⵏⵎⵏ ⵜⵜⵜⴰ ⴾ ⵓⵔⴶⵗ ⵙⵔⵙ ⴹⵓⵢ ⴹⵢ ⴹ ⵎⵤⵔⵢ ⴹⴼ ⵓⴰ ⴶⴰ ⵜⵤⵔ ⴹ ⵜⵜⵓ ⵙⵏ ⵓⵏ ⵜⵤⴶⵤⵎ ⵢⵙⵏⵎⵏ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ⴹⵗ ⴹⵢ ⵜⵙⵈⵔⴾⵗ ⵙ ⵎⵙⵏⵜⵏⴾ ⵜⴰ ⵜⴶⵜ ⵎⴹⵔⵢⵏⴾ ⵓⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵜ ⵙⵏ⵿ⵜⴰ ⴹⴰ ⴹⵍⵍⵏⵜ ⴼⵍ ⵀⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ⵙ ⵜⵀⴾⴹⵎ ⵎⴹⵔⵢⵏⵓⵏ ⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵙⵏ ⵙ ⵜⵎⵓⵜ ⵜⴹⵢ ⵓⴹⵢ ⵍⵎⵙⵈ ⵜⵀⴾⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ⴹⵢ ⴹⴰ ⴼⵍⵙ ⴾⴹ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵜⵜⴰ ⵤⵆⵍⵏ ⵢⵎⴹⵔⵢⵏⵏ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵓⴹⵢ ⵏⴾ ⵓⵔ ⴹⵍⴾⵎ ⴹ ⵍⵙⵗ ⵜⵜⵢ ⵏ⵿ⵙⵏ ⴼⵍ ⴹⵙⵓⵔⵆⵍⴰ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ⵓⴾ ⵏⴾ ⵓⵔⴶⵗ ⵍⵍⵢ ⵎⵙⴰ⵰ ⵓⵔⴶⵗ ⵏⵎⵤⵍ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⴰ⵰ ⵓⵔⴶⵗ ⵏⵢⵗ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ⵰ ⵓⵔⴶⵗ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⴹⵜⴶⵎⴹⵜ ⵛⵗⵍⵏ ⵢⵎⵍⵢ ⵜⵎⵙⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ⴾⴹ ⵗⵔ ⵢⵜⴹⵏ ⵓⵢⴹ ⵓⵔ ⵎⵙⵗ ⵏⵎⵤⵍ ⴹⴰ ⵗⵔⵓⵏ ⵍⴾⵏ ⵙ ⵎⵙⵆⵓ⵰ ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵤⴶⵤⵏⵓⵏ ⵙⵎⵍⵢ ⵎⵙⵏ ⵌⵓⵍ ⵏ⵿ⵜⵛⵜⵏ ⵏⵎⵤⵍ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵤⵏⴰ ⵢⵙⵔⵙ ⴾⵙⵗ ⵎⵏⵏ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⴼⵍⵢ ⴶⵏⵏⵏ ⵔⴾ ⵔⵜⵏ ");
INSERT INTO ttqt_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ⵓⴾ ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⵍⵈⵆ ⵓⵔ ⵏⵍⴰ ⵏⴹ ⵏⴶⵔⵓ ⵏⵜⵛⴰ ⴹⵏⵛⵓⴰ ⴹⵗ ⵛⵗⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ⵓⴾ ⵏⴾⵏⵢ ⵜⵔⵢⵜ ⵓⵔ ⵏⵍⴰ ⵏⴹ ⵏⴹⵓ ⴹⵜⵏ⵿ⵜⵜ ⵏⵢⵏ ⴹⵗⵏⴰ ⵜⵎⵙⵜ ⵜⵎⴹⵔⵢⵜⵏⵏⴰ ⴹⵗ ⴹⵏ ⴹⵗ ⵛⴾⵍ ⵓⴰ ⵜⴶⵏ ⵏⵎⵤⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⴶⵏ⵿ⵜⵓ ⴹⵗ ⵎⴹⵔⵢⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵀⵜⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ⵎⵗ ⵏⴾ ⴹⵀⵔⵏⵀⵙ ⵗⵙ ⵓⵔ ⵏⵍⴰ ⵍⵈⵆ ⵏⴹ ⵏⴹⵔ ⴹⵗ ⵜⵛⵜⵏⵏⴰ ⵏⵎⵤⵍ⵰ ⴾⵏ⵿ⴹⵀⴰ ⴹ ⵏⴹⵔ ⴹⵗ ⵛⵗⵍ ⵏ⵿ⴼⵙⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ⵎⵏⵢ ⴹⴹ ⴾⵍⴰ ⴹ ⵜⵓⵏⵢ ⵙⵌⵢ ⵔⵤⵎⵏ ⵢ ⵎⵏⵜ ⵛⵗⵍ ⵓⴰ ⵜⴶⵓ⵰ ⵓⵍⴰ ⵎⴶⵢⴾ ⵓⵔ ⵏⵜⵜⵓ ⵜⵏ⵿ⴼⴰ ⵏ⵿ⵜⵓⴶⵙ⵿ⵜⵏⵜ⵰ ⵎⴹⵗ ⵎⴹⵏ ⵓⵔ ⵏⵙⵙⵓ ⵈ ⵏⵂⵔⵢ ⴹⵔ ⵏⵜⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ⵓⴾ ⵔⵜ ⴹⵏ⵿ⵤⵎ ⵓⴹⵏ ⴶⵔⵙ ⴹⵎⵏⵜ ⴹⵓⵏ⵿ⴶⵏⴰ ⴹⴰ ⵎⵗ ⴾ ⵜⵓⵔⵜ ⴹⴰ ⵓⴰ ⴹⴰ ⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ⴼⵍⵙ ⵏⴰ ⵜⵓⵔⵜ «ⴹ ⵓⵔ ⵜⴹⵀⵗⴰ ⵢⵤⴶⵔ ⵜⵤⴹⵤⴹⵢⵤⴰ ⴹⵗ ⵍⴾⵎⴰ ⵜⵀⴾⵜⴾⵜⵓ⵰» ⵓⴾ ⵤⵍⵢⵜ ⴹⵗ ⵤⴶⵔⵏ ⴼⵍ ⵏⴰ ⵎⵛⵏⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ⵓⵔⴶⵗ ⴹⵍⵍⵏⵏⴰ ⵏⴾⵏⵢ ⴼⵍ ⵏⴰ ⵓⵏ⵰ ⵓⵍⴰ ⵍⴾⵏ ⵙ ⴹⵍⵍⵏⵏⴰ ⴼⵍ ⴾⵜⵓⴾⵜⵀ ⵓⵏ ⴼⵍ ⴹ ⴶⵓ ⵓⴹⵏ ⵓⴰ ⴶⵢⴾⵏ ⵜⵓⴶⵙ⵿ⵜ ⴹⵓⴰ ⵜⵀⴾⵏ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⵜⵜⴹⵜⴶⵎⴹⵜ ⵜⵎⴰ ⵏⴹ ⴶⵔⵓⵏ ⴹⴶⵔⵏⵙⵏ ⴹⵗ ⵜⵏ⵿ⴼⴰ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ⴹⴹ ⵤⵎⵙ ⵏⴾⵏⵢ ⴹⵙⴹⵓⵍⵏ ⴹⵗ ⵓⵍⵏⵓⵏ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⴹⵜⴼⵍⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴾ ⵔⵜ ⵤⵓⵔⵏ ⵎⵙ ⴾⵓⵏ⵿ⴹⴶⵎⴹ ⵙⵔⵏⴰ ⵜⵍⴰ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_12ⴰ","076_9_12ⴰ","1CO","9","12ⴰ","12ⴰ","ⴾⴹ ⵍⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⵙ ⴾⵓⵏⵓⵔ ⵍⵈⵆⵏⵙⵏ ⵓⴾ ⵓⵔⴶⵗ ⴶⵔ⵿ⵜⵓ ⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_12ⵀ","076_9_12ⵀ","1CO","9","12ⵀ","12ⵀ","ⵎⵛⵏ ⵂⵔⴾⴹ ⴹⵢ ⵓⵔ ⴹⵗⵓⵏ ⵏⴶⵎⵢ ⵍⵈⵆ ⵏⵛⵗⵍⵏⵏⴰ⵰ ⴾⵍⵔ ⵏⵤⵎⵔ ⵢⵔⵜ ⴾⵍ ⴼⵍ ⴹ ⵓⵔ ⵏⴶⵓ ⵔⵜ ⵤⵆⵍⵏ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴶⴹⵍⵙ ⵓⵏ ⵜⵙⵍⵢ ⵢⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵛⵆⵍⵏⵏ ⴹⵗ ⵂⵏ ⵓⴰ ⵤⵓⵔⵏ ⵏⵍⵗⵀⴹⴰ ⵂⵏⵏ ⴹⴰ ⵜⵏⵂⴾⵏ ⵙⴹⵔⵏⵙⵏ⵰ ⵓⵏ ⵛⵗⵍⵏⵏ ⴹⵗ ⵗⵔ ⵎⵌⵎⵔ ⵓⴰ ⴹⵗ ⵜⵆⴹⵏⵜ ⵜⴾⵜⵓⵏ ⵍⵏ ⴹⴶⵔⵏⵙⵏ ⴹⵗ ⵜⴾⵜⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ⵓⵏ ⴹⴰ ⵏⴰ ⵎⵍⵢ ⵎⵔ ⵙⵙ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵔⵏⵜ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ⵎⵛⵏ ⵏⴾ ⵓⵔ ⴹⵗⵓⵏ ⴶⵎⵢⴰ ⵍⵈⵆⵏ ⵓⵍⵢⵏ⵰ ⵓⵍⴰ ⴾⵜⵀⵗⵓⵏⵏ ⵔⵜⵏ ⵓⵏ ⵎⵔⴹⴰ ⴼⵍ ⴹⵗⵓⵏ ⵜⵏⴶⵎⵢⴰ⵰ ⴼⴹⴰ ⵙⴼⵗ ⴹⵀⴰ ⵢⴹⵗⵢ ⴾⵙ ⵓⴹⵏ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏⵀⵔⴶ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ⵓⵔ ⵍⵗ ⵜⵔⵢⵜ ⵓⵍⵢⵜ ⵙⴶⵢ ⵏⵀⵔⴶ ⵏⵙ ⵜⴶⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ⵰ ⴼⵍⵙ ⵛⵍ ⴹⵎⵙ ⴶⵏⵙⵏ⵰ ⴾⵜ ⵍⵗⵤⵀ ⴹⵢ ⵆⵍ ⵙ ⵜⵏⵓⵔⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ⵏⵔ ⵜⵔⴰ ⵏⵎⵏⵏ ⴹⵗ ⵜⴶⴰ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⴹⵢ ⵍⵗ ⵍⵈⵆ⵰ ⵎⵛⵏ ⴹⴹ ⵎⵙ ⵙ ⴶⵢ ⵓⴰ ⴹⵙⵏ⵿ⵜⴶⴰ ⵍⵤⵎⵢ ⵎⵙ ⵛⵗⵍ ⴹⵙⵓⵔ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ⵓⴹⵢ ⵎⴰ ⵎⵙⵏ ⵍⵈⵆⵏ⵰ ⴹⵢ ⵤⴰ ⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵢⵢⵜⴹⵏ ⵀⵏⵏ ⵓⵔ ⴹⵗⵙⵏ ⴶⵎⵢⴰ ⵍⵈⵆ ⵓⵍⵢⵏ ⵓⴰ ⴼⵍⵙⵏ ⵍⵗ ⴹⵗ ⴶⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ⵏⴾ ⵂⵗ ⵜⵔⴰ ⵏⵎⵏⵏ ⵓⵔ ⴹⵍⴰ ⵓⴹⵏ ⵓⵍⵢⵏ ⵎⵛⵏ ⴶⵗ ⵎⵏⵏ ⴾⵍⵢ ⵢⵓⴹⵏ ⴾⵍ ⴼⵍ ⴹ ⴹⵓⵢ ⵓⵏ ⵙ ⵜⵛⵎ ⵏⵢⵜⴹⵏ ⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ⵙ ⴶⵤⵗ ⴾⵍⵍⵢⵂⴹ ⴹ ⵆⵍⵗ ⵛⵍⵜ ⵏⵢⵏ ⴹⵗⵙⵏ ⴼⵍ ⴹ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ⵙ ⴶⵤⵗ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⵜⵓⵔⵜ ⴹ ⵆⵍⵗ ⵛⵍⵜ ⵏⵢⵏ ⴹⵗⵙⵏ ⴾⴹⵗ ⵏⴾ ⵓⵔ ⴹⵙⵍⴾⵎⴰ ⴼⵍ ⴹ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ⵙ ⴶⵤⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵍⴾⵎ ⵢⵜⵓⵔⵜ ⴹ ⵆⵍⵗ ⵢⵏ ⴹⵗⵙⵏ ⴼⵍ ⴹ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ⵓⵏ ⵓⵔ ⵎⵙ ⵍⵎⵗⵏⵏⵜ ⵙ ⵓⵔ ⵍⴾⵎⴰ ⵢⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⴾⵍⵔ ⵍⴾⵎⵗⵙ ⴼⵍⵙ ⵛⵔⵗⴰ ⵓⵏ ⵍⵎⵙⵈ ⵙ ⵍⴾⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ⵙ ⴶⵤⵗ ⵢⵜⴹⵏ ⵓⵏ ⵙ ⵓⵔ ⵙⵂⵜ ⵤⴶⵤⵏⵙⵏ ⴹ ⵆⵍⵗ ⵛⵍⵜ ⵏⵢⵏ ⴹⵗⵙⵏ ⴼⵍ ⴹ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ⵜⵎⵓⵜ ⵜⴹⵢ ⵙ ⵆⵍⴰ ⵔⵜ ⴾⵍ ⵢⵢⵜⴹⵏ ⴾⵍ ⴼⵍ ⴹⵗⵙⵏ ⵙⵗⵍⵙⴰ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ⵜⴶⵗ ⴹⵢ ⴾⵍ ⴼⵍ ⴹⵍⵍ ⵏⵍⵏ⵿ⵌⵍ ⴼⵍ ⴹ ⴹⵔⵓⴰ ⵍⵀⵔⴾⵏⵜ ⴹⵢⵜⴹⵏ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵙ ⵜⵎⵤⴶⴰ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵜⵜⴶⵤⵏⵏ ⵎⵛⵏ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵜⴹⵜⵔⵏⵏ⵰ ⴹⵗ ⴹⵢ ⵤⵍⵜ ⵜⴶⵎ ⵤⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⵤⵙⵙⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ⵎⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⴶⵏⵏ ⵏⵢⵜ ⵏ⵿ⵜⵎⵤⴶⴰ ⵛⵏⵏ ⵍⵀⵙⵏ ⵜⴶⵏ ⵢ ⵎⵏⵙⵏ⵰ ⵜⴶⵏ ⵓⵏ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵍⴾ ⵗⵛⴹⵏ ⵙ ⴶⴰ ⵓⵏ ⵏⴾⵏⵢ ⵏⵜⴶⵢ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵍⴾ ⵓⴰ ⵓⵔ ⵏⵗⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ⴹⵢ ⴼⵍ ⵤⵍⴰ ⵏⴾ ⵤⵍⵗⴰ ⵙⴹⴶ ⵓⵏ ⵜⵤⵔⵙ⵿ⵜ⵰ ⵂⵗ ⵛⵛⵍⵏ ⵏⵓⴹⵏ ⵂⴾⵏ ⵎⵏ⵿ⴾⵙⵏ ⵓⵔ ⵏⵙⵙⴾⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ⵤⵗⵤⵀ ⵜⵗⵙⵏⵏ ⵓⵍⵏ ⴶⵆⵜ ⵜⴾⵍⵜⵏ ⴼⵍ ⴹ ⵓⵔ ⴶⵎⴹⴰ ⵜⵎⵤⴶⴰ ⵆⵎⴰ ⵓⵔ ⴶⵔⵓⵗ ⵍⴾ ⵏⴾ ⵓⴰ ⵎⵍⵏ ⵍⵏ⵿ⵌⵍ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵓⵔ ⵔⵗ ⴹⵓⵏⵌⵂⵍ ⵙ ⵎⵔⵓⵏⵏⴰ ⵙ ⴹⴶⵎⴹⵏ ⴾⵍ ⵏⵎⵙⵔ ⴾⵜⵏⵙⵏ ⵜⵍⵢ ⴹⵏⴶⵙⵏ ⵜⴶⵔⴾ ⴾⵜⵏⵙⵏ ⴹⵗ ⵙ ⵔⴹⵗⵏ ⴹⵗ ⴶⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ⵂⴰ ⵓⵏ ⵛⵛⵍⵏ ⵏⵙ ⵜⵓⵙⵍⵎⵗⵏ ⴾⵜⵏⵙⵏ ⴹⵗ ⵜⴶⵔⴾ ⵜⵏ ⴹⴶⵔⵓ ⵓⵏ ⴼⵍ ⵛⴹⵜ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⴶⵏ ⴹⵏⵀⵢ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ⴾⵜⵏⵙⵏ ⴹⵗ ⵜⵛⵏ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴼⵍⵙⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ⵛⵓⵏ ⴹⵗ ⴾⵜⵏⵙⵏ ⴹⵗ ⵎⵏ ⵓⵏ ⴹⵙⵏ⵿ⴹⴾⵙ ⵎⵛⵏⴰ⵰ ⵎⵏ ⵓⵏ ⵏ⵿ⴶⵢⵏ⵿ⴹⵓ ⴹⵗ ⵜⵂⵏ⵿ⵜ ⴹⵔⵙⵏ ⵜⴹⵓⵜ ⵜⴰ ⵜⵏⴾⴼⴰ ⵎⵛⵏⴰ ⵎⵔⵏ ⵜⵂⵏ⵿ⵜ ⵜⴰ ⵍⵎⵙⵈ ⵜⵜⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ⵎⵛⵏ ⵂⵔⴾⴹ ⵓⵏ ⵜⵛⵎⵏⵙⵏ ⵓⵔ ⵜⴶⵔⵤ ⵢ ⵎⵛⵏⴰ⵰ ⴹⵢ ⴼⵍ ⵓⵤⵓⵤⵏⵜ ⵜⵗⵙⵓⵏⵙⵏ ⴹⵗ ⵜⵏⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ⵎⵔⵏ ⵔⵜⵏ ⵓⵏ ⴶⵏ ⵎⵙⵏⵏⵗ ⵍⵎⵙⵍ ⴼⵍ ⴹ ⵏⵏ⵿ⴾⴹ ⵏⵆⵎ ⵓⵔ ⵏⵙⴹⵔⵏ ⴶⵢ ⵏ⵿ⵜⵍⵀⵙ⵿ⵜ ⵜⴰ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵗⵀⴹⵏⵏ ⵙⵏⵎⵏ ⵓⴰ ⴶⵏ ⵓⵢⴹ ⴹⵗⵙⵏ⵰ ⴹ ⴾⵜⵀ ⵙ «ⵜⵆⵎ ⵜⵎⵜⵢ ⵜⵜⵛⴰ ⵜⵛⵓⴰ ⵜⵤⵔ ⵜⵀⴹⴹ ⵜⴶⵤ ⵜⵔⴰ ⵏⵎⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ⴹ ⵓⵔ ⵏⵜⴶⵓ ⴹⵗ ⵤⵏⴰ ⵛⵍⵏ ⵓⴰ ⴶⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵜⵤⵔ ⵂⵍⴾ ⴹⵗⵙⵏ ⵎⵛⵏⴰ ⵙⵏⵜⵜ ⵜⵎⵔⵓⵏ ⵏⴶⵎ ⴹⴾⵔⴹ ⴹⵗ ⵤⵍ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ⵓⵍⴰ ⵏⴶⵓ ⵜⵏⴶⵎⵢⵜ ⵢⵍⵎⵙⵈ ⵓⴰ ⴹⵙⴶⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵜⵤⵔ ⵜⵏⴹⴹⵏⵜ ⵜⵛⵍⵏ ⵜⵀⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ⵓⵍⴰ ⴹⵗ ⵜⴶⵜⵏ⵿ⵜⵏⵎ ⵓⴰ ⴶⵏ ⵓⵢⴹ ⴹⵗⵙⵏ ⵜⵤⵔ ⵂⵍⴾⵏ ⵏ⵿ⴶⵍⵙ ⵓⵏ ⵏⵀⵤ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ⵎⵔⵏ ⵓⵏ ⴾⵍ ⴶⵔⵓⵜⵏ ⴼⵍ ⴹ ⵆⵍ ⵍⵎⵙⵍ ⵢⵢⵜⴹⵏ ⵎⵔⵏ ⵜⵓⴾⵜⵀ ⴼⵍ ⴹⵙⵏⵏ⵿ⴾⴹ ⵏⴾⵏⵢ ⵓⵏ ⴼⵍ ⴹⵜⵙⴰ ⵜⵤⵔⵙ⵿ⵜ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ⴹⵗ ⴹⵢ ⵓⴹⵏ ⵓⴰ ⵗⵔ ⵍⴰ ⵙ ⵏ⵿ⵜⴰ ⴾⵏⴰ ⵜⵀⴹⵢ ⵏ⵿ⴾⴹⵜ ⴹ ⵓⵔ ⴼⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ⵜⵓⵌⵔⵀ ⵜⴶⵎ ⴾⵍ ⴶⵏ⵿ⵜⵓ ⴹⵜⵓⵏ ⵢⵜⴹⵏ⵰ ⵎⵔⵏ ⵎⵛⵏⴰ ⵓⵔ ⴹⵜⵆⵍ ⴹⵗ ⵍⵎⵏ ⵓⴰ ⴾⵓⵏⴶⴰ ⵓⵔ ⵤⵔⴹⵓ ⵜⵓⴶⵓⵏ ⵜⵓⵌⵔⵀ ⵙ ⵓⵔ ⵜⴼⵔⴶⵎ⵰ ⵎⵔⵏ ⵙ ⵜⵜⵓⵌⵔⵀⵎ ⴾⵓⵏⴾⴼⵓ ⴼⵔⴶⵜ ⵏ⵿ⵤⵎⵔⵜ ⵢⵙ ⵔⵓⵏ ⵜⵔⵢⵜ ⵏⴹⵔⴶ ⵢⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ⴹⵗ ⴹⵢ ⵎⵔⵏⵏ ⴹⵔⴶⵜ ⵢⵍⵗⵀⴹⴰ ⵏⵙⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ⵓⵍ ⵓⴰ ⵜⴶⵓ ⵓⴹⵏ ⵢⵢⵜⴹⵏ ⵍⵏⵏ ⵜⵢⵜⵢ ⴹⵓⵏ⵿ⵜⴶⴰ ⵏ⵿ⵤⵔⵜ ⴹⵗⵙ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹ ⵜⵏⵢⵎ ⵜⴹⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ⵜⴾⵀⵔ⵿ⵜ ⵏⵍⵀⵔⴾⴰ ⵜⴰ ⵏⵜⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⵙ ⴹⵗⵙ ⵏⵛⵓⴰ ⵓⴾ ⵓⵔⴶⵗ ⵜⴹⵔⵓⵜ ⵏⴶⴰ ⴹⵢ ⵤⵏⵢ ⵏⵍⵎⵙⵈ ⵓⴰ ⵏ⵿ⵗⵍⵏ ⵙ ⵜⵀⴰ⵰ ⵜⴶⵍⴰ ⵤⴰ ⵜⴰ ⵏⵜⵤⵏ ⴶⵔⵏⴰ⵰ ⵙ ⵜⵜⵏⵜⵛⴰ ⵓⴾ ⵓⵔⴶⵗ ⵜⴹⵔⵓⵜ ⵏⴶⴰ ⴹⵢ ⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ⴹ ⵜⴶⵍⴰ ⵢⴹⴰ ⵎⵙ ⵍⵎⵙⵈ ⵏⴾⵏⵢ ⴹⵗ ⵂⵔⴾⴹ ⴶⵜⵏⵏⴰ ⵜⵗⵙⴰ ⵢⴹⴰ ⵏⵎⵙ ⴼⵍⵙ ⴾⵜⵏⵏⴰ ⵏⴹⵔⵓ ⵜⴶⵍⴰ ⵢⴹⴰ ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ⵏⵢⵜ ⵛⴾⵜⵓⵏ ⵛⵏ ⵜⴶⵏ ⴾⵍⵙⵔⵢⵍ⵰ ⴾ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵜⴶⵏⵏ ⵜⵜⵏ⵿ⵜⵏⵜ ⴹⵓⵏ ⴹⵗ ⵍⵗⵀⴹⴰ ⵓⴰ ⵜⴶⵏ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵆⴹⵏⵜ ⵜⴾⵜⵓⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ⵓⴾ ⵎⵙ ⴶⵎⵢⵗ ⴹⵜⵏⵏⵜ ⴹⴰ⵰ ⴹⵙ ⵜⵏⴰ ⵜⴶⴰ ⵙⵏⵎ ⵎⴹⵗ ⵎⵏ⵿ⵙⵓⵏ ⵜⵓⴾⴼⵏⵏ ⵢⵙⵏⵎ ⵎⵙⵏ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ⴾⵍⴰ ⴾⵍⴰ⵰ ⴶⵏⴰ ⵛⴾⵜⵓⵏ ⵛⵏ ⴹⵢ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵏⵍⵌⵂⵍⵏ ⵍⵎⵗⵏⴰ ⵢⵜⴹⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴾⵍⵙⴼ ⵙ ⵜⵏⵜⴾⵜⵏ ⵓⵔⴶ ⵎⵛⵏⴰ⵰ ⵎⵔⵏ ⵓⵔ ⵔⵗ ⴹ ⵜⴹⵔⵓⵎ ⵔⵜ ⵓⵍⵢⵏ ⴹⵍⵌⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ⵓⵔ ⵜⴼⵔⴶⵎ ⴹ ⵜⵙⵙⵎ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⴾⵓⵏ⵿ⴹⵜⵙⴾⵜⵜ ⵜⵏⵗⵍⴰ ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⵤⵏⵏⵜ ⴼⵍⵓⵏ ⵜⵙⵙⵎ ⴹⵗ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⴹⵗ ⵙⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⵗⵀⴹⵏⵏ ⴾⵍⵙⴼ⵰ ⵓⵔ ⵜⴼⵔⴶⵎ ⴹ ⵜⴹⵔⵓⵎ ⵜⴶⵍⴰ ⵜⴰ ⴾⵓⵏ⵿ⴹⵜⵙⴾⵜⵜ ⵜⵂⴾⵢ ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⵜⵗⵙⵏⵜ ⴼⵍⵓⵏ ⵜⴹⵔⵓⵎ ⴹⵗ ⵜⴶⵍⴰ ⵜⴰ ⵜⵜⵏ ⵏⵗⵀⴹⵏ ⵏ⵿ⴾⵍⵙⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ⵎⵗ ⵜⵔⴰ ⵏⴶⴰ ⴹ ⵏⵙⵏ⵿ⴾⵔ ⵛⵙⵎⵜⵏ ⴹⵗ ⵎⵍⵢ⵰ ⵓⴾ ⵏⵔⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ⵜⴶⵏⵎ «ⵔⵜ ⴾⵍ ⵢ ⵈⵍⵍⵏ» ⵎⵛⵏ ⵓⵔⴶⵗ ⵔⵜ ⴾⵍ ⵜⵂⵢ ⵜⵏ⵿ⴼⴰ⵰ ⵜⴶⵏⵎ ⴹⵗ «ⵔⵜ ⴾⵍ ⵢ ⵈⵍⵍⵏ» ⵎⵛⵏ ⵓⵔⴶ ⵔⵜ ⴾⵍ ⵛⵜⵓ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ⵜⵓⵔⵎⵍ ⵓⵍⵢⵏ ⴹⵗⵓⵏ ⴶⵎⵢⵏ ⵜⵏ⵿ⴼⴰ ⵜⵏ ⵎⵏⵜ ⵏ⵿ⵜⴰ ⵗⵙ ⴾⵍⵔ ⴶⵎⵢⵜ ⵓⴰ ⵤⵏ⵿ⴼⵏ ⵎⵂⵔⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ⵙⵏ ⴾⵍ ⵓⵏ ⵏⵤⵏⵏ ⴹⵗ ⵙⴾ ⵜⵍⵎ ⵜⵔⵢⵜ ⵏ⵿ⵜⵏ⵿ⵜⵤⵏ⵿ⵤⵎ ⵜⵜⵛⵎ⵿ⵜⵏ ⴹⴰ ⵓⵔ ⵜⵙⵙ⵿ⵜⵏⵎ ⴹⴶⵤ ⵓⴰ ⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ⴹ ⵏⵏ ⵍⴾⵜⵀⵏ ⵎⴹⵍ ⴹⵓⴰ ⵜⵂⵏ ⴾⵜⵏⵜ ⵏ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ⵙ ⴹⵗⵓⵏ ⴶⵎⵢ ⵓⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵜⵏ⵿ⵜⵙⵎ ⵜⵤⵔ ⵜⵔⴹⵎ ⵙ ⵎⵏ⵿ⵙⵢ ⴾⵍ ⵓⴰ ⵙⵏ⵿ⵙⴰ ⴹⵜⵓⵏ ⵜⵛⵜⵓ ⴹⴰ ⵓⵔ ⵜⵙⵙ⵿ⵜⵏⵎ ⴹⴶⵤ ⵓⴰ ⴹⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ⵎⵛⵏ ⵙ ⴹⵓⵏⵏⴰ ⵓⴹⵏ «ⵎⵏ⵿ⵙⵢ ⴹⵢ ⵜⵓⴾⵜ ⵢⵙⵏⵎ» ⵓⴹⵢ ⵜⵓⵔ⵿ⵜⵜⵛⵎ ⴼⵍ ⴹⵍⵍ ⵏⵓⴹⵏ ⵓⴰ ⴹⵓⵏⵏⵏ ⴹⵢ ⴹⴹⵍⵍ ⵏⴹⴼ ⵓⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ⵓⵔ ⴶⵏⴰ ⵢⴹⴼ ⵓⴰ ⵜⴶⵎ ⴹⵗ ⵎⵏ⵿ⵙⵢ ⴹⵢ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴾⵍⵔ ⴹⴼ ⵓⴰ ⴹⵗⵙ ⴶⴰ ⵓⴹⵏ ⵓⴰ ⵂⴹⵏ ⵙ ⴶⵏⴰ⵰ ⵎⵔⵏ ⵎⴼⵍ ⵙ ⴹⴶⴹⵍ ⴹⴼ ⵏⵓⴹⵏ ⵢⵏ ⴶⵢ ⵏⵔⵜ ⵙ ⵍⵗ ⵜⵔⵢⵜ ⵏⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ⴾⴹ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⵜⵜⴰ ⵂⵔ ⵜⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⵙ ⵜⴶⵤⵗ ⵛⵏ ⵜⵜⵢ ⵎⴼⵍ ⵙ ⴹⵍⵢⵏ ⵓⴹⵏ ⴼⵍ ⵙ ⵜⵜⵛⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ⴹⵗ ⴹⵢ ⴶⵔ ⵤⴰ ⵜⵜⵢ ⵜⵜⴶⵎ ⵓⵍⴰ ⵜⵙⵙⵎ ⵆⵍ ⵔⵜ ⵓⴰ ⵜⵜⴶⵎ ⴶⵓⵜⵓ ⴼⵍ ⴹⴾⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴶⵔ ⵤⴰ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⵓⵍⴰ ⴹⵗ ⵢⵜⴹⵏ ⵏⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ⴶⵜ ⵓⴰ ⵜⴶⴰ⵰ ⵏⴾ ⴶⵎⵢⵏ ⴹⴹ ⴶⵔⵤⵗ ⵢⵓⴹⵏ ⴾⵍ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ⵓⵔ ⴶⵎⵢⴰ ⵜⵏ⵿ⴼⴰ ⵢ ⵎⵏⵏ ⴾⵍⵔ ⵜⵏ⵿ⴼⴰ ⵢⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵎⵢⴰ ⴼⵍ ⴹ ⴶⵔⵓⵏ ⵍⵗⵍⵙ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ⵆⵍⵜ ⵢⵜⴹⵏ ⴹⵜⵍⵍⵏⵏ ⵙⵎⴾ ⵓⵙ ⵜⵍⵍⴰ ⵏⴾ ⴹⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ⵎⵍⵆⵓⵏ ⵎⴹⵔⵢⵏⵏ ⴼⵍ ⵜⴾⵜⵓⵜ ⵜⴰ ⴹⴹⵜⵜⴶⵎ ⴹⵗ ⵔⵜ ⴾⵍ ⴹⴹⴼ ⵓⴰ ⵜⴶⵎ ⵍⵗⴹⵜⵏ ⵙⵎⴾ ⵓⵙ ⴹⵓⵏ⵿ⵜⵏⵜⵙⵀⴹⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ⵎⵛⵏ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵍⵙ ⴾⵍ ⵍⵎⵙⵈ ⵎⵙⵏ ⵗⴼⵏⵜ⵰ ⵜⵏ⵿ⵜⵜ ⵍⵙ ⵎⵙⵏ ⵗⴼⵏⵜ⵰ ⵍⵎⵙⵈ ⵎⵛⵏⴰ ⵎⵙⵏ ⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ⵎⵔⵏ ⴹ ⴶⵤ ⵍⵙ ⵛⵏ ⵍⵗⵀⴹⴰ ⵏⵎⵛⵏⴰ ⴹⵗ ⵍⴾⵏⵙⵜ ⵜⵜⵔ ⵎⴹⵗ ⴶⵔⵓ ⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⴼⵍⵙ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵙⵍⵙⴰ ⵗⴼⵏⵜ ⵓⴹⵢ ⵤⵀⵤ ⵓⴰ ⴹⵙⵎⵙⵏ ⵗⴼ ⵜⴾⵔⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ⴶⵙ ⵜⵏ⵿ⵜⵜ ⴾⵍ ⵜⴰ ⵜⵜⵜⵔⵜ ⵎⴹⵗ ⵜⴶⵔⵓ ⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⴼⵍⵙ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵓⵔ ⵜⵙⵓⵔ ⵗⴼⵏⵜ ⴹⵗ ⵍⴾⵏⵙⵜ ⵜⴹⵢ ⵜⵤⵀⵤ ⵓⴰ ⴹⵙⵎⵙⵏ ⵗⴼ ⵜⴾⵔⴾⵜ ⵛⵍⵜ ⵏⵙ ⵜⵙⵜⵀⵍⵀⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵓⵔ ⵏⵙⵓⵔ ⵗⴼⵏⵜ ⵜⴹⵢ ⵜⴼⵏⵤⵜ ⵏ⵿ⵤⴹⵏⵜ⵰ ⵎⵛⵏ ⴹⴹ ⵎⵙ ⵢ ⵜⵏ⵿ⵜⵜ ⵜⴾⵔⴾⵜ ⴼⵏⵤ ⵏⵏ⵿ⵤⴹⵏ ⵎⴹⵗ ⵙⵜⵀⵍⵀⵍ ⵓⴹⵢ ⵜⵙⵓⵔⵜ ⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ⵍⵙ ⵏ⵿ⵜⴰ ⵓⵔ ⵜⵍⵤⵎ ⴹ ⵙⵍⵙⵓ ⵗⴼⵏⵜ ⴹ ⵎⵛⵏⴰ ⵜⴹⵈⵍⴾⵏ ⵙ ⵛⵛⵍⵏⵜ ⴾⴼⵢ ⵜⵏⵢⴰ ⵛⵍⵜ ⵏ⵿ⵜⵏⵜ⵰ ⵎⵛⵏ ⵜⵏ⵿ⵜⵜ ⵏ⵿ⵜⴰ ⵙⵗⵎⵔ ⵏⵍⵙ ⵜⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ⴼⵍⵙ ⵓⵔⴶ ⵍⵙ ⴹⵈⵍⴾ ⵎⵛⵏⴰ ⴹⵗ ⵜⵏ⵿ⵜⵜ ⴾⵍⵔ ⵜⵏ⵿ⵜⵜ ⴹⵈⵍⴾ ⵎⵛⵏⴰ ⴹⵗ ⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ⵓⵔⴶⵗ ⴹⵗ ⵍⵙ ⴹⵜⵓⵈⵍⴾⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⴾⵍⵔ ⵜⵏ⵿ⵜⵜ ⴹⵜⵜⵓⵈⵍⴾⵜ ⴼⵍ ⴹⵍⵍ ⵏⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ⴹⵢ ⴼⵍ ⵍⵤⵎ ⵜⵏ⵿ⵜⵜ ⴹ ⵓⵔ ⵙⵏⵍ ⵏ⵿ⵜⵗⵎⵔ ⵗⴼⵏⵜ ⴼⵍ ⴹⵎ ⵏⵏ⵿ⴶⵍⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ⵎⵛⵏ ⵢⴰ ⴹⵜ ⵎⵍⵢ ⵍⵙ ⵂⵔⴾⴹ ⵜⵏ⵿ⵜⵜ ⴾⵢⵏ ⵆⵏ ⴹⵗ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ⴼⵍⵙ ⴾⴹ ⵎⵙ ⵙ ⵜⵏ⵿ⵜⵜ ⵍⵙ ⴹⵜⴶⵎⴹ ⴹⴰ ⵍⵙ ⵜⵏ⵿ⵜⵜ ⴹⴶⵎⴹ ⵎⵔⵏ ⵔⵜ ⴾⵍ ⵎⵛⵏⴰ ⴹⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵎⴰ ⵜⵏⵎ ⵓⴾ ⵂⵔ ⴹ ⵜⵜⵜⵔ ⵜⵏ⵿ⵜⵜ ⵙ ⵎⵛⵏⴰ ⴹⵗ ⵍⵌⵎⵗⵜ ⵏⵍⵎⵙⵈⵜⵏ ⵓⵔ ⵜⵙⵓⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ⵓⴾ ⵓⵔⴶⵗ ⵜⵀⵗⵜⵏⵓⵏ ⵎⵏⵜ ⵜⵙⵙⵏ⵿ⴾⵓⵏ ⵙ ⴶⵢ ⵏ⵿ⵌⴾⴹ ⵎⵙ ⵜⴾⵔⴾⵜ ⴼⵍ ⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ⵎⵛⵏ ⵜⵏ⵿ⵜⵜ ⵏ⵿ⵜⴰ ⵌⴾⴹ ⵍⵎⵆⵎ ⵜⵜⵂⴾⵏ⵰ ⴹ ⵎⵛⵏⴰ ⴹⵙ⵿ⵜⵏⴾⴼⵏ ⵢⵙⵜⵔ ⵏⵗⴼⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ⴾⴹ ⵍⵢ ⵓⴹⵏ ⵎⵔⵏ ⵔⵏ ⴹ ⵎⵤⵗ ⴹⵢ ⵙⵏⵜ ⵙ ⴶⵔ ⵤⴰ ⵏⴾⵏⵢ ⵓⵍⴰ ⵍⴾⵏⵙⵜⵏ ⵏⵎⵛⵏⴰ ⵓⵔ ⵏⵍⴰ ⵢⵜ ⵍⵗⴹⵜ ⵓⵔ ⵏⵎⵙ ⵜⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ⵎⵔⵏ ⵎⵔⵏ ⵓⵏ ⴹⵓⵏ⵿ⵜⴶⴰ ⴹⴰ ⵓⵔ ⵎⵙⵏ ⵎⵍⵏⵓⵏ ⴹ ⵎⵏⵢⵏⵓⵏ ⵓⵏ ⵍⵗⵀⴹⴰ ⵓⵔⴶⵗ ⵛⵜⵢ ⴾⵓⵏ⵿ⵜⴶⵏ ⴾⵍⵔ ⵍⵆⵎ ⴾⵓⵏ⵿ⵙⵗⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ⴼⵍⵙ ⵔⵜ ⵓⴰ ⵤⵔⵏ ⵓⴰ ⵙⵔⵓⵏ ⵙⵍⵗ ⵙ ⴹ ⵜⵎⵏⵢ ⵍⵌⵎⵗⵜ ⵏⵍⴾⵏⵙⵜⵏⵓⵏ ⵢⵍⵗⵀⴹⴰ ⴹ ⵜⵆⵍⵎ ⵛⵤⵏⵓⵏ⵰ ⵎⵔⵏ ⵓⵔ ⵀⴰ ⵤⴶⵤⵏⵗ ⴹⵗ ⵀⵜⵓ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ⵎⵛⵏ ⵢⴰ ⵛⵍ ⴹ ⵜⵆⵍⵎ ⵛⵤⵏⵓⵏ ⴼⵍ ⴹⵗⵓⵏ ⵜⵓⵏⵢⵏ ⵓⵏ ⵂⵔⵏⵏ ⴹⵜⵓⵙⵗⵎⵔ ⵓⵔⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ⴹⵗ ⴹⵢ ⵎⵏⵢ ⵓⴰ ⵜⵜⴶⵎ ⵓⵔ ⵜⵜⵜⴶⵎ ⵢⴹ ⵜⴹⵔⵓⵎ ⵎⵏ⵿ⵙⵓⵏ ⵓⵏ ⵙⴾⵜⵏ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ⴼⵍⵙ ⵙ ⵜⴶⵤⵎ ⵛⵏ ⵜⵜⵢ ⴾⵢⵏ ⴹⵗⵓⵏ ⴹ ⵂⵤ ⴹⵗ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⵓⵢ ⵜⵛⵢ ⵢⵓ ⵎⴹⵏⵜ⵰ ⵆⵍ ⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⵤⴰ ⵂⵏ ⴶⵍⴾ ⵎⵔⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵙⵎⵙⵓⴹⵜⵏ ⵙⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ⵓⴾ ⵏⵏ ⵓⵔ ⵜⵍⵎ ⴹⵗ ⵜⵜⵛⵎ ⵜⵛⵓⵎ⵰ ⵎⵗ ⵎⵍⴾⴰ ⵜⴶⵎ ⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⵜⵤⵀⵤⵎ ⵜⴾⵔⴾⵜ ⵓⵏ ⴹⵗⵙ ⵓⵔ ⵏⵍⴰ ⵔⵜ⵰ ⵎⴰ ⴹⵓⵏ⵿ⵤⵏⴰ ⵤⴰ⵰ ⵜⵔⵎ ⴹⵓⵏⴶⴰ ⵜⵎⵍⵏ ⵍⵗⵏⵏ ⴼⵍ ⵙ ⵜⴶⵎ ⴹⵢ⵰ ⵓⵍⴰ ⵏⵎⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ⴼⵍⵙ ⵏⴾ ⵎⵏⵏ ⵍⵗⴹⵜ ⵜⴰ ⴹⴹⵢⴰ ⵎⵍⵢ ⵎⵏⵜ ⴹⵓⵏ⵿ⴹⵢⵗ ⵜⵜⵎⵙⵏ ⵙ ⵂⴹ ⵓⴰ ⴹⵗ ⵤⵜⵓⴶⵓ ⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⴼⵙⵏ ⴹⴾⵍ ⵜⴶⵍⴰ ");
INSERT INTO ttqt_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ⴶⴰ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵜⵤⵔ ⵔⵤⵜ ⵏⴰ «ⵜⵗⵙⵏⵏ ⴹⵢ ⵜⵜⵓⵔⵤⵜ ⴼⵍ ⴹⵍⵍⵏⵓⵏ⵰ ⵜⴶⵜ ⵓⴰ ⴹⴰ ⵙ ⵜⵎⵓⵜ ⵜⴰ ⴹⴰ ⵎⵙ ⴹⵢ ⵙⴾⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ⵤⵏ⵿ⴹ ⵎⴾⵏ ⴹⴰ ⵙ ⵙ ⵜⵛⵏ ⴹⴾⵍ ⵜⴾⵀⵔ⵿ⵜ ⵏⵙⵏ «ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵔⴾⵓⵍ ⵓⴰ ⵢⵏⵢⵏ ⵏ⵿ⵜⵙⵆ ⵜⵎⵙ ⴶⵔ ⵎⵛⵏⴰ ⴹⵜⵎⵜⵢⵏⵜ⵰ ⵔⴾⵓⵍ ⵓⴰ ⵤⵏⵏⵏ ⵜⵙⵜⴹⵏ⵰ ⵢ ⴹⵗⵙ ⵜⵛⵓⵎ ⵜⴶⵎ ⴹⵢ ⵙⴾⵜⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ⴼⵍⵙ ⴹ ⵜⵜⵛⵎ ⵜⴶⵍⴰ ⵜⴰ ⵜⵛⵓⵎ ⴹⵗ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵓⴹⵢ ⵙⵍⵏ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵜⵜⴶⵎ ⵂⵔ ⵤⵍ ⵓⴰ ⴹⵤⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵢ ⵜⵛⵏ ⵜⴶⵍⴰ ⵜⴰ ⵜⵎⵙⵜ ⵙⴾⵜⵏ ⵏ⵿ⵜⵗⵙⴰ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵎⴹⵗ ⴶⴰ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵜⵎⵙⵜ ⵙⴾⵜⵏ ⵏⵤⵏⵏⵜ ⵜⵙⵢ ⵜⴶⵜ ⵙⵀⴰ ⵏ⵿ⵙⴼⵔⵔ ⵓⴹⵢ ⵀⴾⴹ ⵜⵗⵙⴰ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵤⵏⵏⵜ ⵎⵔⵏ ⴹ ⵜⵀⵤ ⵛⵔⵗⴰ ⵙⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ⴹⵗ ⴹⵢ ⴾ ⵓⴹⵏ ⵛⴶⵔⵜ ⵎⵏⵜ ⵜⵤⵔ ⵍⵓⵆ ⵓⴹⵢ ⵎⵔⵏ ⵜⵛⵓ ⵜⴶⵍⴰ ⵜⴰ ⵛⵓ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵜⵛⵏ ⵜⴶⵍⴰ ⵜⴰ ⵎⴹⵗ ⵛⵓⴰ ⴹⵗ ⵜⴾⵀⵔ⵿ⵜ ⵜⴰ ⵓⵔ ⴶⵔⴰ ⵔⵜ ⵓⴰ ⴹⵔⵓ ⴹⵢ ⴹⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵓⴹⵢ ⵓⴹⵏ ⵤⵀⵤ ⵎⵏⵜ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ⴹⵢ ⴼⵍ ⴾⵓⵏⵂⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵏⵔⴾⵎ ⴹⵓⵢⴹ ⴶⵜⵏⵏ ⵏⵎⵔⵏⵏ ⵀⴰ ⴹⵗⵓⵏ ⴼⴹⴰ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ⵏⵔ ⵏⵤⵔ ⵙ ⵛⴶⵔⴰ ⵏⵎⵏⵏⴰ ⵓⵔ ⴹⵏⵤⵀⵤ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵎⵛⵏⴰ ⵜⵀⵤⵏⴰ ⵙⵛⵔⵗⴰ ⴼⵍ ⴹⵏⵗⵗⴹ ⵏⵆⵎ ⵓⵔ ⴹⵏⵗⵙⵔ⵿ⵜⵢ ⴹⴹⵏⵜ ⴹⵗ ⵛⵔⵗⴰ ⵓⴰ ⵍⴾⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⴹ ⵜⴹⵓⵎ ⵢⴹ ⵜⴹⵔⵓⵎ ⵎⵏ⵿ⵙⵓⵏ ⴹ ⵜⵜⵆⵍⵎ ⵢ ⵎⴹⵔⵢⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_34ⴰ","076_11_34ⴰ","1CO","11","34ⴰ","34ⴰ","ⴾⴹ ⵢⵏ ⴹⵗⵓⵏ ⵂⵢ ⴶⵍⴾ ⵜⵛⵜ ⴹⵗ ⵂⵏⵜ ⵜⵤⵔ ⴼⵍ ⴹ ⵓⵔ ⵆⵍ ⵎⵏⵢⵏⵓⵏ ⵔⵜ ⵙⵔⵓⵏ ⴹⵤⵓⵢⵏ ⴾⵓⵏⵀⵤ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C111_34ⵀ","076_11_34ⵀ","1CO","11","34ⵀ","34ⵀ","ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵛⵗⵓⵛⵓⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⵙ ⴹⵏⵙⵗ ⵜⵏⵜⴾⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵎⵜⴾⵓⵢⵏ ⵛⵏ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵔ ⵔⵗ ⴹⵗⵙⵏⵜ ⵜⵌⵂⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ⵜⵙⵏⵎ ⵙ ⴹⵜ ⴶⵤⵏⵓⵏ ⵜⵔⵢⵜ ⵜⵏ ⵎⵛⵏⴰ ⵢⵜⴹⵏ ⵜⵎⵙⵎ ⵈⵔⴾⵏⵏ ⵍⴾⵎⵏⵏ ⵢⵙⵏⵎⵏ ⵓⵔ ⵏⵛⵓⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ⵓⵏ ⴹⴰ ⴼⵍ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴹⵗ ⵏⴹⴰ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⴹⵤⵏ⵿ⴾⵔⵏ ⴹ ⴶⵏⵓ «ⵎⵛⵏⴰ ⵜⵍⵗⵏⴰ ⵗⵢⵙⴰ⵰» ⵓⵍⴰ ⴹⵗ ⵍⵢ ⵓⴹⵏ ⴼⵔⴶⵏ ⴹ ⵏⵓ «ⵗⵢⵙⴰ ⵎⵙ ⵎⵍⵢ⵰» ⵔ ⵙⴹⵗⵙ ⵏⴹⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ⵎⵔⵏ ⵛⵂⴾⵜⵏ ⵤⵏⴼⵏ ⵎⵙⵏⵜ ⵎⵛⵏ ⵏ⵿ⴼⵙ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵜⵎⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵜⵏⵜⵂⴾⵏ ⴾⵜⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ⵜⵔⵢⵏ ⵏⵛⵗⵍ ⵤⵏⴼⵏ ⵎⵙⵏⵜ ⵎⵛⵏ ⵎⵍⵢ ⴹⵢ ⵏⵢⵏ ⵙ ⵏⵛⵗⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ⴶⵜⵏ ⵤⵏⴼⵏ ⵎⵙⵏ ⵎⵛⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵢⵏ ⵂⴾⵏ ⵢⵜⴹⵏ ⴾⵍ ⵎⵙⵏⵜ ⵏⴶⵜⵏ ⴾⵍ ⵓⵏ ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ⴾ ⵏⵍⴾⵎ ⴶⵔⵓ ⵗⵔ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵂⴾⵜ ⵜⵜⵙⴼⵔⴶⵜ ⵛⵗⵍ ⵎⵙⵏ ⵜⵏ⵿ⴼⵏⵏⴰ ⴾⵜⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ⵓⴹⵏ ⵤⴰ ⵢⵏ ⵂⴾⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴶⵢ ⵏⵀⵜⵜⵏ ⵏ⵿ⵜⵍⴰ ⵏⴶⵔⵢ ⵢⵏ ⵎⵔⵏ ⵂⴾⵢ ⵏ⵿ⴼⵙ ⴶⵢ ⵏⵀⵜⵜⵏ ⵏⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ⵢⵏ ⵂⴾⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵤⴶⵤⵏ ⵢⵏ ⵂⴾⵢ ⴼⵔⴶⵜ ⵏⵤⵤⵢ ⵏⵎⵔⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ⵢⵏ ⵂⴾⵢ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵢⵏ ⴶⵔⵓ ⵎⵍ ⵢⵢⵜⴹⵏ ⵙⵍⵏ ⵓⵏ ⴼⵍⵙ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵢⵏ ⵂⴾⵢ ⴼⵔⴶⵜ ⵏ⵿ⵤⵍⵢ ⴶⵔ ⵜⵂⴾⵜ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⴰ ⵜⵜⵓⵔⵏⵎⵙ⵰ ⵢⵏ ⵂⴾⵢ ⴼⵔⴶⵜ ⵏⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵢⵏ ⵂⴾⵢ ⴼⵙⵔ ⵏⵓⵍⵏ ⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ⵎⵛⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴰ ⴹⴰ ⵜⴶⵏ ⵔⵜⵏ ⴹⵢ ⴾⵜⵏⵙⵏ ⴾ ⵓⴹⵏ ⵂⴾⵢ ⵜⵂⴾⵜ ⵜⴰ ⴹⵙⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ⵏⵢⵜ ⵜⵛⵜ ⵜⴰ ⵜⴶⴰ ⵜⵗⵙⴰ ⵏⵓⴹⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴶⵏ ⴹⵗ ⵜⵙⵍⴹ ⴾⵏⵏⵏ ⴶⵜ ⴶⵙ ⵂⵔⴾⴹ ⴶⵜⵏⵙⵏⵜ ⵜⵗⵙⴰ ⵢⴹⴰ ⵎⵙⵏⵜ⵰ ⵓⵏ ⴹⴰ ⵤⴰ ⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⵍⵎⵙⵈ ⵙⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵜⵗⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ⴼⵍⵙ ⴶⵔ ⵤⴰ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵜⵏⵎⵙ ⴶⵔ ⵤⴰ ⵏⵎⵙ ⴾⵍⵏ ⵓⵍⴰ ⵍⵍⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴹⵢ ⴹⴰ ⴹⵗ ⵏⵜⵓⵙⵍⵎⵗ ⴾⵜⵏⵏⴰ ⵏⵆⵍ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ⴾⵜⵏⵏⴰ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴹⵢ ⴹⴰ ⴹⵏⵢⵏ ⵓⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ⵎⵔⵏ ⵜⵗⵙⴰ ⵓⵔ ⵜⴶⴰ ⴹⵗ ⵜⵙⵍⵜ ⵢⴹⴰ ⴾⵍⵔ ⵛⵙⵍⴹ ⴶⵜⵏⵏ ⴹⵗ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ⵙ ⴹⴶⴹ ⴹⵔ ⵏⴰ «ⵏⴾ ⵓⵔ ⴹⵜⵍⴰ ⵜⵗⵙⴰ ⴹ ⵓⵔ ⵎⵙⵗ ⴼⵙ⵰» ⵓⴾ ⴾⵙ⵿ⵜⵓ ⵓⵏ ⴹⵗ ⵜⵛⵜ ⵏⵢⵜ ⴹⵗ ⵜⵙⵍⴹ ⵏ⵿ⵜⵗⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ⵙ ⵜⵏⴰ ⵜⵎⵤⴾ «ⵏⴾ ⵓⵔ ⴹⵜⵍⴰ ⵜⵗⵙⴰ ⴹ ⵓⵔ ⵎⵙⵗ ⵛⵜ⵰» ⵓⴾ ⴾⵙ⵿ⵜⵜ ⵓⵏ ⴹⵗ ⵜⵛⵜ ⵏⵢⵜ ⴹⵗ ⵜⵙⵍⴹ ⵏ⵿ⵜⵗⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ⵙ ⵜⵆⵍ ⵜⵗⵙⴰ ⴾⵜⵏⵜ ⵛⵜ ⵎⵙ ⵤⵙⵍⵓ ⵓⴹⵏ⵰ ⵙ ⵜⵆⵍ ⵜⵗⵙⴰ ⴾⵜⵏⵜ ⵜⵎⵤⴾ ⵎⵙ ⵤⵓⵜ ⵓⴹⵏ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ⴾⵍⵔ ⵎⵛⵏⴰ ⴶⵏ ⵛⵙⵍⴹ ⴹⵗ ⵜⵗⵙⴰ ⴾⵢⵜ ⴶⵜ ⴹⵗ ⴹⴶ ⵓⵙ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ⵙ ⵎⵙ ⵙ ⵜⵗⵙⴰ ⴾⵜⵏⵜ ⵜⵙⵍⵜ ⵢⴹⴰ ⵜⵎⵙ ⵓⴹⵢ ⵎⴰ ⵤⵆⵍⵏ ⵜⵗⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ⴾⵍⵔ ⵛⵙⵍⴹ ⴾⵏⵏⵏ ⴶⵜ ⵜⵍⵏⵏ ⵎⵛⵏ ⵜⵗⵙⴰ ⵏ⵿ⵜⴰ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ⵓⵏ ⴹⵗ ⴼⵍ ⵓⵔ ⵜⴼⵔⴶ ⵛⵜ ⴹ ⵜⵏⵓ ⵢⴼⵙ «ⵏⴾ ⵓⵔ ⵙⵔⴾ ⴹⵔⵔ» ⵓⵍⴰ ⴹⵗ ⵏⵓ ⵗⴼ ⵢ ⴹⵔⵏ «ⵏⴾ ⵓⵔ ⵙⵔⵓⵏ ⴹⵔⵔ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ⴼⴹⴰ ⵛⵙⵍⴹ ⵏ⵿ⵜⵗⵙⵓⵏⵏⴰ ⵛⵏ ⵏⵙ ⵏⴶⴰ ⴹⴼ ⵏⵙ ⵔⴾⵎⵏⵜ ⵏ⵿ⵜⵏⵜⵢ ⴹⵏⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ⵎⵔⵏ ⵛⵏ ⴹⵢ ⵙ ⵗⵔⵏⵗ ⴶⴰ ⵙ ⵓⵔ ⴼⵔⵔⵏⵜ ⵏ⵿ⵜⵏⵜⵢ ⵏⵙⵗⵎⵔ ⵓⵍⵏ⵰ ⴹⵗ ⴹⵢ ⵛⵙⵍⴹⵏⵏⴰ ⵛⵏ ⵎⵙⵏⵏ ⵤⴼ ⵏ⵿ⵜⵏⵜⵢ ⵏⴾⵏⵓ ⵙⵜⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ⵛⵏ ⵓⵔ ⵏⵎⵙ ⵤⴼ ⵎⵔⵏ ⵏ⵿ⵜⵏⵜⵢ ⵓⵔ ⴹⵔⵔⵏⵜ ⵙⵙⵜⵔ⵰ ⵎⵛⵏⴰ ⵎⵏⵜ ⴹⵈⵍⴾⵏ ⵜⵗⵙⴰ ⵜⵙⵗ ⴶⵙ ⵜⵎⵓⵜ ⴼⵍ ⵜⵓⵙⵗⵎⵔⵏⵜ ⵜⵙⵍⴹⵏⵜ ⵓⵍⵏ ⵛⵏ ⴹⵔⵔⵏⵏ ⵙⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ⴼⵍ ⴹ ⵓⵔ ⵜⵤⵏ ⵜⵗⵙⴰ ⴶⵔⵙ ⴾⵍⵔ ⴾⵍⴾ ⵏ⵿ⵜⵙⵍⵜ ⴹ ⵜⵙⵏ ⴹⵗ ⵜⵎⴹⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵙ ⵜⵍⴶⵢ ⵢⵜ ⴹⵗ ⵜⵙⵍⴹ ⵏ⵿ⵜⵗⵙⴰ ⵛⵙⵍⴹ ⴾⵍ ⵛⵏ ⵂⴹⵜⵏⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹ ⵍⴶⵢⵏⵜ⵰ ⵙ ⵜⵜⵓⵤⵤⵓⵔ ⴹⵗ ⵢⵜ ⴹⵗ ⵜⵙⵍⴹ ⵛⵙⵍⴹ ⴾⵍ ⵛⵏ ⵂⴹⵜⵏⵏ ⴹ ⴼⵍⵓⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ⴾⵓⵏⵢ ⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ ⵜⵎⵙⵎ ⵎⵔⵏ ⴾⵢⵏ ⴹⵗⵓⵏ ⵜⵙⵍⵜ ⵏ⵿ⵜⵗⵙⵏⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ⴹⵢ ⴼⵍⵙ ⵍⴾⵏⵙⵜ ⴹⵗ ⵜⵤⵔⵜ ⴶⴰ ⴹⵗⵙ ⵎⵛⵏⴰ ⵏⵎⵤⵍ ⴹⴼⵔⵙⵏ ⵏⵀⵜⵏ⵰ ⴹⴼⵔ ⵏⵀⵜⵏ ⵍⴼⵆⵜⵏ⵰ ⴹⴼⵔ ⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⵍⵏⵏ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ ⵍⴾⵎⵏⵙⵏ ⵓⵏ ⴾⴼⴰ ⴼⵔⴶⵜ ⵏⵤⵤⵢ ⵏ⵿ⵜⵓⵔⵏⵓⵏ ⴹⵓⵏ ⵜⵍⵍⵏⵏ ⵢⵢⵜⴹⵏ ⴹⵓⵏ ⴾⴼⴰ ⴼⵔⴶⵜ ⵏ⵿ⵜⵤⵔ⵿ⵜ ⵢⵢⵜⴹⵏ ⴹⵓⵏ ⴾⴼⴰ ⴼⵔⴶⵜ ⵏⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ⵓⴾ ⴾⵜⵏⵙⵏ ⵙ ⵎⵙⵏ ⵏⵎⵤⵍ⵰ ⵓⴾ ⴾⵜⵏⵙⵏ ⵙ ⵎⵙⵏ ⵏⵀⵜⵏ⵰ ⵓⴾ ⴾⵜⵏⵙⵏ ⵙ ⵎⵙⵏ ⵍⴼⵆⵜⵏ⵰ ⵓⴾ ⴾⵜⵏⵙⵏ ⵙ ⴶⵔⵓⵏ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏ⵿ⵜⵍⵎⵗⵌⵌⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ⵎⴹⵗ ⴶⵔⵓⵏ ⴼⵔⴶⵜ ⵏⵤⵤⵢ ⵏ⵿ⵜⵓⵔⵏⵓⵏ ⵎⵗ ⴼⵔⴶⵜ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵎⵗ ⴼⵔⴶⵜ ⵏⴼⵙⵔⵏⵙⵏ⵰ ⵓⵍⴰ ⵏⵎⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ⴹⵗ ⴹⵢ ⵙⴹⵔⵏⵜ ⵙⵍⵗ ⴶⵔⵓ ⵏ⵿ⵜⵂⴾⵜⵏ ⵛⵏ ⴼⵏⵏ⵰ ⵎⵔⵏ ⴾⵓⵏⵙⴾⵏⴰ ⵎⵔⴹⴰ ⵜⵔⵢⵜ ⵜⴰ ⵜⴼⵜ ⵜⵔⵢⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ⴾⴹ ⵛⵓⵍⵗ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⵂⵔⴾⴹ ⵓⵏ ⵏ⵿ⴶⵍⵙⵏ ⴹⴰ ⵙ ⴹⵓⵔ⵿ⵜⵂⴰ ⵜⵔⴰ ⵓⵔ ⵤⵍⵢ ⵓⵍⵏ ⴹⵎⵙⵍⵢ ⵏⵏⵢⵏⴰ ⵎⴹⵗ ⵎⵙⵍⵢ ⵏⵗⵍⵍ ⵏ⵿ⵜⵤⵍⵢ ⵜⵜⵓⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ⴾⴹ ⴶⵔⵓⴰ ⵜⵂⴾⵜ ⵏⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵓⵍⴰ ⴶⵔⵓⴰ ⵙⵔⵏ ⴾⵍ ⴹⵎⵙⵏⵜ ⴾⵍ ⵓⵍⴰ ⵍⵗ ⵤⴶⵤⵏ ⴾⵎⵍⵏ ⴹⵙⴼⵔⴶⵏ ⵙⴶⵍⵢ ⵏⴹⵗⵗⵏ ⴹⴰ ⵙ ⴹⵓⵔ⵿ⵜⵂⴰ ⵜⵔⴰ ⵓⵔ ⵎⵙⵗ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ⴾⴹ ⵤⵏⴰ ⵜⵍⵏⵏ ⴾⵍ ⵢ ⵜⵍⵆⵓⵏ ⵙⴾⵜⵗ ⵎⵏⵏ ⵢⵍⵗⵀⴹⴰ ⵏⵎⵛⵏⴰ ⵂⵔ ⵗⵔⵢ ⵎⵍ ⵙ ⴶⵔⵗ ⵢⵜⴹⵏ ⴹⴰ ⵙ ⴹⵓⵔ⵿ⵜⵂⴰ ⵜⵔⴰ ⵓⵔ ⴹⵤⵏ⵿ⴼⵓ ⴹⵢ ⵙ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ⵓⴹⵏ ⵓⴰ ⵜⵂⴰ ⵜⵔⴰ ⵜⵂⵢ ⵜⵤⵢⴹⵔ⵿ⵜ ⵍⵗ⵰ ⵓⵔ ⵤⵓⵢ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵓⵔ ⵜⴶⵓ ⵀⵔⴶⵏ ⵓⵔ ⴹⴾⵍ ⵎⵏⵜ ⴹⵏⴶ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ⵓⴹⵏ ⵜⵂⴰ ⵜⵔⴰ ⵓⵔ ⵜⴶⵓ ⵎⵤⵍ ⵏⵀⴰ ⵏ⵿ⵜⴾⵔⴾⵜ ⵓⵔ ⴶⵎⵢ ⵓⴰ ⵜⵤⵏ⵿ⴼⵏ ⵏ⵿ⵜⴰ ⵗⵙ ⵓⵔ ⵔⵗⵙ ⵍⵂⵎⵏⵜ ⵓⵔ ⵜⵜⴼ ⴹⵗ ⵎⵏ ⵔⴾ ⵎⵤⵍ ⴹⵙⴶⴰ ⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ⵓⵔ ⵜⵙⴹⵓⵜ ⵔⵜ ⵓⵔ ⵏⵗⴹ ⴾⵍⵔ ⵜⴹⵜ ⵜⵜⵙⴹⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ⴼⵓ ⵤⵤⵢⴹⵔ ⴼⵓ ⵤⴶⵤⵏ ⴼⵓ ⴶⴰ ⵜⵎⴰ ⵤⵎⵔ ⵢⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ⵜⵔⴰ ⵓⵔ ⴹⵙⵍⴾⵎ ⴹ ⵜⵗⵔⴹ ⵜⵂⴾⵜ ⵏⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵍⴾⵎ ⵜⵓⵔ⵿ⵜⵍⴰ ⵜⵏ ⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⴹ ⵜⵔⵤ ⵜⵏ ⵎⵙⵏⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⵍⴾⵎ ⵜⵓⵔ⵿ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ⴼⵍⵙ ⵎⵙⵏⵜⵏⵏⴰ ⵓⵔ ⵜⵏ⵿ⴹⴰ ⵎⵍⵏⵏⴰ ⵙⵍⵏ ⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⴹⵗ ⵓⵔ ⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ⵎⵛⵏ ⵙ ⴹⵜⵙⴰ ⵍⴾⵎⵍⵜ ⵓⴰ ⵓⵔ ⵏⴾⵎⵍ ⴹ ⵀⴰ ⵜⵎⵢⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ⵂⵔⵓⴰ ⵎⵙⴰ ⵀⵔⵔ ⵓⵍ ⵏⵀⵔⵔ ⵜⴶⵗ ⵜⴶⵗ ⵎⴹⵔⵏⵏ ⵓⵏ ⵀⵔⵔ ⵍⵗ ⵜⵢⵜⵢ ⵜⵏ ⵀⵔⵔ⵰ ⵎⵛⵏ ⵙ ⵆⵍⵗ ⵍⵙ ⵢⵗⵏ ⵔⵜⵏ ⵓⵏ ⵀⵔⵔ ⴹⴼⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ⵎⵔⴹⴰ ⵏⵂⵏⵢ ⵙ ⵎⵙⵏⵜⵏⵏⴰ ⵓⵍⴰ ⴹ ⵜⴶⵜ ⵓⵔ ⵜⵎⵙ ⵓⵍⴰ ⴹⴶⵎⴰ ⵏ⵿ⵜⴰ ⵜⵍⴾⵎⵜ⵰ ⵤⵍⵢⵜⵏⵜ ⵓⴰ ⵤⵍⵢⵏ ⵏⵢ ⵏⵓⴹⵏ ⴹⵗ ⵛⵛⵜ ⴹⵏⵢⵏⵜ ⴹⵎ ⵙⴹⵎ⵰ ⵎⵔⴹⴰ ⵎⵙⵏⵜⵏ ⵓⵔ ⵜⴾⵎⵍ ⵎⵛⵏ ⵍⴾⵎ ⴹ ⵜⴾⵎⵍ ⵜⴶⵓ ⵍⴾⵎⵍⵜ ⵜⴰ ⵜⴶⴰ ⵜⵎⵤⴹⵢⵜ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ⵎⵔⵏ ⵎⵔⴹⴰ ⴾⵔⴹ ⵔⵜⵏ ⵓⵏ ⵜⵍⵏⵏ ⵜⵏⵎⵙⵏ ⵤⴶⵤⵏ ⴹⵜⵎⴰ ⴹⵜⵔⴰ⵰ ⵎⵛⵏ ⵓⴰ ⵜⵏⴶⵔⵏ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ⴶⵎⵢⵜ ⵤⴰ ⴹ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵜⵂⴰ ⵜⵔⴰ⵰ ⵜⵙⴹⵔⵏⵎ ⵓⵍⵏ ⴶⵔⵓ ⵏⵎⵤⵍⵏ ⵓⵏ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⵍⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⴼⵔⴶⵏ ⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵎⵛⵏⴰ ⵙ ⵛⵓⵍ ⵓⵔⴶⵗ ⵢⵜⴹⵏ⵰ ⴹ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴶⵔⵏ ⵙⵔⵏ ⵓⵏ ⵙ ⵜⴾⴼⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴶⵔⵓⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴼⵍⵙ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵓⴹⵢ ⵢⵜⴹⵏ ⵙ ⵛⵓⵍ ⵙⵙⵂⵜ ⵤⴶⵤⵏⵙⵏ ⵙⵙⵎⴹ ⵓⵍⵏⵙⵏ ⵜⵍⵎⵙⵏ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ⵓⴹⵏ ⵓⴰ ⵛⵓⵍⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵤⴶⵤⵏ ⵓⵏⵜ ⵗⵙ ⵙⵙⵂⵜ ⵙⴹⵢ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⴶⵔⵓⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵓⴹⵢ ⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ ⵙ ⵙⵙⵂⵜ ⵤⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ⵏⴾ ⵔⵗ ⴹ ⵜⵛⵓⵍⵎ ⴾⵜⵏⵓⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵎⵛⵏ ⵓⴰ ⴹⵓⵏⵙⴼⵗ ⴹ ⵜⴶⵔⵓⵎ ⵜⵂⴾⵜ ⵏⵎⵍ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰ ⵓⴹⵏ ⵓⴰ ⴶⵔⵓⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⴶⵔ ⵓⴰ ⴶⵔⵓⵏ ⴼⵔⴶⵜ ⵏⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵔ ⵙⴹ ⵎⵙ ⵙ ⴼⵔⴶ ⴹ ⵜⴼⵙⵔ ⵓⴰ ⴶⵏⵓ ⴼⵍ ⵙⵔⵙ ⵙⵙⵂⵜ ⵤⴶⵤⵏ ⵏⵍⴾⵏⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ⵎⵔⵏ ⵎⵔⴹⴰ ⵎⴹⵔⵢⵏⵏ ⵏⵏⴰ ⵎⵙⵍⵏ ⵙⵆⵓⵏⵏ ⵛⵓⵍⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵓⴾ ⵎⵙ ⴾⵓⵏ⵿ⵤⵏ⵿ⴼⵓ ⴹⵢ⵰ ⵎⵛⵏ ⵙ ⴾⵓⵏⵏⵙⵗ ⵎⵍⵗⵓⵏ ⵔⵜ ⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵎⴹⵗ ⵛⵜⴰ ⵎⵙⵏⵜ ⵜⴰ ⵜⵍⵎ ⵎⴹⵗ ⴶⵗⵓⵏ ⵀⵜⵓ ⴼⵍⵢ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵎⴹⵗ ⵙⵙⵗⵔⵆⵓⵏ ⵜⵙⵏ⵿ⵜ ⴹⵜⴶⵎⴹⵜ ⵍⵏ⵿ⵌⵍ ⵓⵔⴶⵗ ⴾⵓⵏⵏ⵿ⴼⵓ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ⵓⵍⴰ ⵔⵜⵏ ⵓⵏ ⵙ ⵜⵓⴶⵏ ⵙⵓⵜ ⵏⵏⴰ ⵎⵙⵍⵏ ⵜⵙⵏ⵿ⵙⵆ ⵎⴹⵗ ⵜⵂⵔⴹⵏ⵿ⵜ ⴹⴰ ⵙ ⵓⵔ ⴶⵏ ⵓⵜ ⵍⵗⵏ ⵎⵏⵎⴾ ⵙ ⵤⵤⵍⵢ ⵓⴹⵏ ⴶⵢ ⵓⴰ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ⵙⴾ ⴹⵗ ⵓⴰ ⵜⵓⵏ⵿ⵙⵗⵏ ⵢⴹ ⵙⵎⵜⴶⵏ ⵢⵜⴹⵏ ⵢⵎⴶⵔ ⵙ ⴹⵙⵓⵔⵜⵓⴶⴰ ⵏⵙⵗ ⵓⴰ ⵜⵓⵙⵏⵏ ⵎⴰ ⵤⵙⵎⵜⴶⵏ ⵢⵎⴶⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ⴾⵓⵏⵢ ⴹⴰ ⵤⴰ ⵓⵏ ⴹⴰ ⵙ ⵜⵛⵓⵍⵎ ⵓⵔ ⵜⵍⴼⴹⵎ ⵙⵍⵈⵔⴼⵏ ⵙ ⵜⵓⵙⵏ ⵍⵎⵗⵏⵏⵙⵏ ⵎⵏ ⵎⴾ ⵙ ⵤⵙⵏ ⵓⴹⵏ ⵓⵍⵢⵏ ⵓⴰ ⵜⴶⵏⵎ⵰ ⵤⵏ ⵜⵛⵓⵍⵎ ⴹⵗ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ⴶⵎⴹ ⵛⴾ ⵙ ⵤⵏⴼⵏ ⵏⵓⵍⵏ ⴶⵜⵏⵏ ⵂⵏⵏ ⴹⵏⵜ⵰ ⵎⵛⵏ ⵓⵔ ⵜⵏⵂⴰ ⵙ ⵓⵔⴶⵗ ⵍⴰ ⵍⵎⵗⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ⵎⵔⵏ ⵙ ⵓⵔ ⵙⵏⵗ ⵢⵏ ⴹⵗⵙⵏ ⴹ ⵆⵍⵗ ⵙⵓⴹⵏ ⵓⴰ ⵜⵛⵓⵍⵏ ⵓⴹⵏ ⵏ⵿ⵜⵎⴰ ⵆⵍ⵿ⵜⵓ ⵙⵔⵢ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ⴹⵗ ⴹⵢ ⴾⵓⵏⵢ ⴹⴰ ⴹⴹ ⵤⵎⵙ ⵜⵙⴹⵔⵏⵎ ⵓⵍⵏ ⴶⵔⵓ ⵏ⵿ⵜⵎⵜⴾⵓⵢⵏ ⵛⵏ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵢ ⵤⴰ ⵛⵗⵍⵜ ⴹⵗ ⴶⵎⵢ ⵏⵛⵏ ⵤⴰ ⵙⵙⵂⵜⵏⵏ ⵤⴶⵤⵏ ⵏⵍⴾⵏⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ⵓⵏ ⴹⴰ ⴼⵍⵙ ⵓⴹⵏ ⵓⴰ ⵛⵓⵍⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⴶⵎⵢⵜ ⴹⵗ ⵎⵛⵏⴰ ⴹ ⵜⴾⴼⵓ ⴼⵔⴶⵜ ⵏⴼⵙⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ⴼⵍⵙ ⵙ ⵎⵙ ⵙ ⵜⵜⵔⴰ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵎⵏⵏ ⵗⵙ ⵜⵜⵔⵏⵏ ⵜⵢⵜⵢⵏ ⵏ⵿ⵜⴰ ⵓⵔ ⵜⵛⵗⵍ ⴹⵗ ⵜⵓⵜⵔⵓⵏ ⵛⵏ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ⴹⵗ ⴹⵢ ⵎⴰ ⵤⴶⴰ⵰ ⴹⵢ ⵤⴰ ⴹ ⵜⵔⵗ ⴹⵗ ⵎⵏⵏ ⵜⵔⴰ ⴹⵗ ⵙ ⵜⵢⵜⵢⵏ ⴹⵗ ⵓⵍ ⵙⵙⴶⵔⵏ⵰ ⴶⵗ ⵜⴶⵢⵜⵍ⵿ⵜ ⵙ ⵎⵏⵏ ⴶⵆⵜ ⴹⵗ ⵙ ⵜⵢⵜⵢⵏ ⴹⵗ ⵓⵍ ⵙⵙⴶⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ⵙ ⵓⵔ ⴶⴰ ⴹⵢ ⵙ ⵆⵍ ⵙ ⵜⵜⴶⵗ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⵙ ⵎⵏⴾ ⵗⵙ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵓⴾ ⵓⴹⵏ ⵓⴰ ⵜⵓⵔⵏⵙⵏ ⵓⴰ ⴹⴾⵙⵙⵎⵏ ⴹⵗ ⵍⴾⵏⵙⵜ ⵎⵏⵎⴾ ⵙ ⵤⵏⵓ ⵢ ⵜⵓⵜⵔⵢⵏⴾ «ⵎⵏ⵰» ⵏ⵿ⵜⴰ ⵓⵔ ⵙⵏ ⵓⴰ ⵜⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ⵍⴾⵏ ⵙ ⴶⴹⵏⴾ ⵢ ⵎⵛⵏⴰ ⵂⵙⵢⵏ ⵎⵛⵏ ⵓⵔ ⵙⵙⵂⵜ ⴹⵢ ⵤⴶⵤⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⴹⴾⵙⵙⵎⵏⵏ ⴹ ⵓⵔ ⵙⵏⵏ ⵓⴰ ⵜⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ⵏⴾ ⵜⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⵙ ⴾⵓⵏⴶⵔⴰ ⴾⵜⵏⵓⵏ ⵓⵍ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ⵎⵛⵏ ⵙ ⵂⵗ ⵍⴾⵏⵙⵜ ⵙⴼⵗ ⴶⵢ ⵏⵓⵍⴰ ⵗⵙ ⵙⵎⵙ ⵍⵈⵔⴼⵏ ⵤⴰ ⵜⵓⴶⵔⵏⵏ ⵢⴹ ⵤⵀⵤⵗ ⵢⵜⴹⵏ ⵍⴼⵢⴹⵜ ⴶⵢ ⵏⵎⵔⵓ ⴶⵎ ⵏⵍⵈⵔⴼ ⴹⵗ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ⵎⴹⵔⵢⵏⵏ ⵛⵔⵜ ⵜⵎⵤⵢⵎ ⴹⵜⵛⵜ ⵏⵀⵔⵔⵏ⵰ ⵜⴹⵜ ⵙ ⴹⵗ ⵓⴰ ⵆⵍⵏ ⴶⵢ ⵏ⵿ⵜⵍⵀⵙ⵿ⵜ ⵆⵍⵜ ⵛⵍⵜ ⵏⵀⵔⵔⵏ⵰ ⵎⵛⵏ ⴹⵗ ⵓⴰ ⵆⵍⵏ ⴶⵔⵢ ⵏⵔⵜⵏ ⵓⵏ ⵆⵍⵜ ⵢⵜⴹⵏ ⴾⵎⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ⵏⵏ ⵍⴾⵜⵀⵏ «ⵏⴰ ⵎⵍⵢ \"ⵜⵎⵜⵢ ⵜⴰ ⴹⵙⵛⵓⵍⵗ ⴹⵗ ⵓⵍ ⵓⵔ ⵜⵙⵏ ⴶⵎⴹⵓ ⵙⵔⵙⵏ ⵓⵍ ⵓⵏ ⵎⵓⵏ ⵏⴼ⵿ⵜⵗⵏ ⵎⵛⵏ ⵂⵔⴾⴹ ⵓⵏ ⵓⵔ ⴹⵤⵀⵔⴹⴶⵏ⵰\"» ");
INSERT INTO ttqt_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ⴹⵢ ⴼⵍⵙ ⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵙⵏⵍ ⵏⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵎⵙ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵓⵔⴶ ⵓⵏ ⵤⴶⵤⵏⵏ⵰ ⵙ ⴶⴰ ⵓⵏ ⵓⴹⵏ ⵓⴰ ⴾⴼⴰ ⵎⵛⵏⴰ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵓⴹⵢ ⵙⵍⵏ ⵓⵏ ⵜⴶⵓ ⵙⵏⵍ ⵏⵔⵈⵎⵜ ⵎⵙⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵓⵔⴶ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ⵏⵏⴰ ⵎⵙⵍⵏ ⵍⴾⵏⵙⵜ ⴾⵜⵏⵜ ⵜⴹⵓⵜ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⵜⵤⵔ ⵛⵓⵍⵏ ⴾⵜⵏⵙⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵂⵔ ⵜⵏ⵿ⴹⵙⵏ ⵢⵜⴹⵏ ⵓⵔ ⵏⴶⵔⴰ ⵓⴰ ⵎⵙ ⵓⵏ ⵎⴹⵗ ⵢⵜⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵓⵔⴶⵗ ⴹ ⵏⵏ ⵎⵙⴾⵍ ⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⴾⵜⵏⵙⵏ ⵎⵍⵏ ⵓⵍ ⵎⵙⵏ ⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵂⵔ ⵜⵏ⵿ⴹⵙⴰ ⵓⴹⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵎⴹⵗ ⵢⵏ ⵓⵔ ⵂⵏ ⵙⵍⵏ ⵏⵓⵏ ⴹ ⵜⵙⵙⵏⵏ ⵓⵍⵏ ⴾⵍ ⵓⵏ ⵙ ⵙⵍⵓ ⴹⵢ ⵙ ⴶⴰ ⵀⴾⴹⵏ ⵙⵏ ⴹⵗ ⵙ ⴹ ⵜⵀⵤ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ⵏ⵿ⵜⴰ ⴹⴰ ⴼⴶⵏ ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵓⵍ ⵏⵓⴹⵏ ⵓⵏ ⵜⵤⵔ ⵙⵌⴹ ⵢ ⵎⵛⵏⴰ ⵗⵀⴹⵜⵓ ⵏⵓ «ⵜⴹⵜ ⵙ ⵍⴰ ⵎⵛⵏⴰ ⴶⵔⵓⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵎⵙ ⵎⴾⵏ ⵜⵜⴶⵎ⵰ ⴹⵢ ⵤⴰ ⵙ ⵜⵎⵏⵢⵎ ⴹⵗ ⴹⴶ ⵢⵏ⵿ⴹⴰ ⵓⵢⴹ ⴹⵗⵓⵏ ⴶⵏⵜ ⵛⴶⵢⵜⵍⵏ ⵓⵢⴹ ⵙⵙⵗⵔⵏⵜ ⵢⵜⴹⵏ ⵓⵢⴹ ⵎⵍⵏⵜ ⵓⴰ ⴹⵙⵏⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵓⵢⴹ ⵛⵓⵍⵏⵜ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⵓⵢⴹ ⴼⵙⵔⵏⵜⵏ⵰ ⵆⵍⵏⵜ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴾⵍ ⵔⵜ ⵤⵙⵙⵂⵏ ⵤⴶⵤⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ⴾⴹ ⵓⵢⴹ ⴹⵗⵓⵏ ⵛⵓⵍⵏⵏ ⵓⵍⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ ⴹ ⵓⵔ ⴾⵢⵏ ⵛⵏ ⵢⵜⴹⵏ ⵎⴹⵗ ⴾⵔⴹ⵰ ⵛⵓⵍⵏⵜ ⵙⵢⵏ ⵢⵏ ⵎⵔⵏ ⵎⵍ⵿ⵜⵓ ⵓⴹⵏ ⴼⵙⵔⵏ ⵓⴰ ⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ⴾⴹ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵜⴼⵙⵔⵏ ⴼⵙ⵿ⵜⵏⵜ ⴹ ⵓⵔ ⵛⵓⵍⵏ ⴹⵗ ⵍⴾⵏⵙⵜ ⵛⵓⵍⵏⵜ ⴹⵗ ⵎⵏⵙⵏ ⴶⵔⵙⵏ ⴹⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ⵎⵔⵏ ⵓⵏ ⵎⵙⵏⵏ ⵏⵀⵜⵏ ⵛⵓⵍⵏⵜ ⴹⵗⵙⵏ ⵛⵏ ⵎⴹⵗ ⴾⵔⴹ ⵜⵤⵔ ⵛⴶⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵍⴾⵏⵙⵜ ⵓⵍ ⵓⴰ ⴹⵤⵀⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ⵎⵛⵏ ⵙ ⴹⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵓⵍ ⵢⵢⵏ ⵓⴹⵏ ⵆⵎⵏ ⴹⵏ ⵓⴹⵏ ⵓⴰ ⵛⵓⵍⵏ ⴼⵙ⵿ⵜⵜ ⵢ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ⴹⵗ ⴹⵢ ⴾⵜⵏⵓⵏ ⵜⴼⵔⴶⵎ ⴹ ⵜⵎⵍⵎ ⵙⵢⵏ ⵢⵏ ⵙⵍⵏ ⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ ⵢⴹ ⵜⵙⵙⵗⵔⵎ ⵏⵍⴾⵎⵏ ⴾⵍ ⵜⴾⵏⵎⵙⵏ ⵎⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ⵜⵂⴾⵜ ⵏⵎⵍ ⵏ⵿ⵙⵍⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ ⵎⴾⵏ ⵙ ⵏⴹⴰ ⴹⵗⵙ ⵓⴹⵏ ⵓⴰ ⵜⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ⴼⵍⵙ ⵎⵛⵏⴰ ⵓⵔ ⵔⴰ ⵜⵏⵌⵔⵓⵢⵜ ⴾⵍⵔ ⵏⵤⵎ ⵍⵗⵏ ⵔⴰ ⴹⵍⵈⵔ ⵛⵍⵜ ⵏⵓⴰ ⴶⵏ ⴹⵗ ⵍⴾⵏⵙⵜⵏ ⴾⵜⵏⵙⵏⵜ ⵎⵙⵏⵏ ⵜⵎⵜⵢ ⵤⴹⴶⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ⴹ ⵓⵔ ⵛⵓⵍⵏⵜ ⵜⴹⴹⵏ ⴹⵗ ⵎⵏⵢⵏ ⵓⵏ ⵍⴾⵏⵙⵜ ⴼⵍⵙ ⵓⵔ ⵍⵏⵜ ⵜⵔⴶⵜ ⵏⵓⵏ⵰ ⴾⵍⵔ ⵀⵔⴹⴶⵏⵜⵜ ⴹ ⴹⵢ ⴹⴰ ⵙ ⵏⴰ ⵜⵓⵔⵜ ⴹ ⵜⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ⴾⴹ ⵍⵢ ⵔⵜ ⵙ ⵔⵏⵜ ⴹⵗⵙ ⵙⵏⵜ ⵙⵙ⵿ⵜⵏⵜⵜ ⵎⴹⵏⵙⵏⵜ ⴹⵗ ⵗⵢⵓⵏ⵰ ⴼⵍⵙ ⵜⴾⵔⴾⵜ ⵎⵙ ⴼⵍ ⵜⵏ⵿ⵜⵜ ⴹ ⵜⵛⵓⵍ ⴹⵗ ⵎⵏⵢ ⵏⵍⴾⵏⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ⵓⴾ ⵜⵗⵍ⵿ⵜ ⵜⴶⵎ ⵓⵍ ⵏⵎⵛⵏⴰ ⴾⵓⵏⵢ ⴹⴶⵎⴹ⵰ ⵎⵗ ⵜⵗⵍ⵿ⵜ ⵜⴶⵎ ⴾⵓⵏⵢ ⵗⵙ ⵜⵆⵀⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ⵓⴹⵏ ⵓⴰ ⴹⵗⵓⵏ ⴶⵏ ⴹⴼ ⵏⵙ ⵏ⵿ⵜⴰ ⵏⵀⵢ ⵎⵙ ⵎⴹⵗ ⵏⴹⴰ ⴹⵗⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴶⵔⵜ ⵙⵍⵗ ⵙ ⵔⵜⵏ ⵓⵏ ⴹⵓⵏ⵿ⴾⵜⵀⴰ ⴹⴰ ⵍⵓⵌⵀ ⵏⵎⵍⵢ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ⵎⵔⵏ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵙⴼⵔⵔ ⴹⵢ ⵓⴹⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⵔ ⵜⵤⵙⴼⵔⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵙⴹⵔⵏⵜ ⵓⵍⵏ ⴶⵔⵓ ⵏ⵿ⵜⵂⴾⵜ ⵏⵎⵍ ⵏ⵿ⵙⵍⵏ ⵓⵏ ⴹⵤⵤⵀⵜ ⵎⵛⵏⴰ⵰ ⵎⵛⵏ ⴹ ⵓⵔ ⵜⴶⴹⵍⵎ ⵛⵓⵍ ⵏⵓⵍⵏ ⵓⵏ ⵓⵔ ⵏⵜⵓⵤⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ⴹⵢ ⴾⵍ ⴶⵓⵜⵓ ⴹⵗ ⵤⵀⵏ ⴹⵏⵤⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ⵎⴹⵔⵢⵏⵏ ⵎⵔⴹⴰ ⴾⵓⵏ⵿ⴹⵙⴾⵜⵗ ⵍⵏ⵿ⵌⵍ ⵓⵙ ⴹⵓⵏⴶⵗ ⵙⵍⵏⵜ ⵜⵤⴶⵤⵏⵎ ⵙⵔⵙ ⵜⵍⴾⵎⵎⵙ ⵙⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ⵍⵏ⵿ⵌⵍ ⴹⵢ ⴹⴰ ⴾⵓⵏⴶⵏ ⴹⵗ ⵜⵔⵢⵜ ⵏⵍⵗⵍⵙ ⴾⴹ ⵜⵜⴼⵎ⵿ⵜⵓ ⵙⵍⵗ ⵙⵎⴾ ⵓⵙ ⴹⵓⵏ⵿ⵜⵎⵍⴰ⵰ ⵙ ⴹⵙⵓⵔ⵿ⵜⴶⵎ ⴹⵢ ⵤⴶⵤⵏ ⵏⵀⵏⵏ ⵜⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ⴼⵍⵙ ⵙⵍⵏ ⵓⵏ ⴶⵔⵓⴰ ⵏⴾ ⵎⵏⵏ ⴹⵓⵏⴶⵗ ⵎⵔⵏ ⵙⵍⵏ ⵓⵏ ⴹⵢ ⵗⴼⵏⵙⵏ ⵙ ⵍⵎⵙⵈ ⵀⵜⵓ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵏⴰ ⵎⵙ ⵙ ⴹⵢ ⴹⴰ ⵏⵏ ⵍⴾⵜⵀⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ⵏⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵜⵜⵓⴶⴰ ⵜⵗⵙⵏⵜ ⴹⵗ ⵜⵤⴾⴰ ⵙ ⵤⵍⵏⵜ ⵓⵏ ⴾⵔⴹ ⴹⵀⴰ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ⵏⴼⵍⵍⴹⵓ ⵢ ⵀⵜⵔⵙ ⵎⵔⵏ ⵏⴼⵍⵍ ⵢ ⵏⵜⵍⵀⵏⵜ ⵓⵏ ⵎⵔⵓ ⴹⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ⴹⴼⵔ ⴹⵢ ⵏⴼⵍⵍ ⵢ ⵜⴹⵓⵜ ⵏⵍⴾⵎⵏ ⵜⴶⵔⵜ ⵙⵎⵙⵜ ⵜⵎⴹ ⵏⵓⴹⵏ ⵔⵜ ⴹⵗⵙⵏ ⵀⵜⵓ ⵎⵛⵏ ⵜⵛⵎⵏⵙⵏ ⵂⵔⵓⴹⴰ ⵜⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ⴹⴼⵔ ⴹⵢ ⵎⵔⵏ ⵏⴼⵍⵍ ⵢ ⵢⵆⵀ ⴹⴼⵔ ⴹⵢ ⵏⴼⵍⵍ ⵢ ⵏⵎⵤⵍ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ⴹⴼⵔⵙⵏ ⴾⵜⵏⵙⵏ ⴹⵏⴼⵍⵍ ⵏⴾ ⴹⴰ ⵀⵍⵙ ⵏⴾ ⵂⵏ ⵍⵎⵜⵍ ⵏⵀⵔⵔ ⴹⵂⵓⵏ ⴹⴼⵔ ⵙ ⴾⵢ ⵍⵓⵆ ⵏ⵿ⵜⵂⵓⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ⴼⵍⵙ ⵏⴾ ⵏⵎⵤⵍ ⴾⵍ ⴶⵔⵏⵢ ⵓⵔ ⵓⴹⴰ ⴼⴹⴰ ⴹⵜⵓⵏⵓ ⵏⵎⵤⵍ ⴹ ⴾⵍⴰ ⴹ ⵙⴾⵏⵗ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⵔⴾⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ⵆⵍ ⵓⴰ ⵎⵙⴰ ⴹⴰ ⵎⵙⵆⵓ ⵙⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵎⵔⵏ ⵔⵈⵎⵜ ⵜⴰ ⴹⴾⴼⴰ ⵓⵔ ⵜⵀⵏⵏ⵰ ⴼⵍⵙ ⴶⵔⵗ ⵏⵎⵤⵍ ⴾⵍ ⵛⵗⵍ ⵎⵛⵏ ⵢⴰ ⵓⵔⴶⵗ ⵏⴾ ⴶⵏ ⴹⵢ ⴾⵍⵔ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⴹⵗⵢ ⵜⵛⵗⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ⴹⵢ ⴼⵍⵙ ⴶⵔ ⵤⴰ ⵏⴾ ⵓⵍⴰ ⴹⵗ ⵏⵎⵤⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵙⵍⵏ ⵓⵏ ⴹⵢ ⵏⵜⴶⵓ ⵎⵔⵏ ⵏ⵿ⵜⵏⵢ ⵜⵤⴶⵤⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ⵎⵔⵏ ⴹⴹ ⴶⵏⵏ ⵙⵍⵏ ⵓⵏ ⵏⵜⴶⵓ ⵍⵎⵙⵈ ⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵏⵎⴾ ⵙ ⴶⵏⵏ ⵓⵢⴹ ⴹⵗⵓⵏ ⵏⵎⵜⵏ ⵓⵔ ⴹⵗⵙⵏ ⵜⵍⴾⵎ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ⴾⴹ ⵜⴹⵜ ⵎⵙ ⵙ ⵏⵎⵜⵏ ⵓⵔ ⴹⵗⵙⵏ ⵜⵍⴾⵎ ⵜⵏⴾⵔⴰ ⵓⴹⵢ ⵍⵎⵙⵈ ⴹⴰ ⵓⵔ ⴹⵜⵓⵙⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ⵎⵔⵏ ⴾⴹ ⵍⵎⵙⵈ ⵓⵔ ⴹⵜⵓⵙⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵢ ⵤⴰ ⵜⵍⵈⵜⵀⵜⵏⵏⴰ ⵓⵔ ⵍⵏⵜ ⵜⵏ⵿ⴼⴰ ⵓⵍⵢⵜ ⵤⴶⵤⵏⵓⵏ ⵙⵔⵙⵏⵜ ⴹⵗ ⵓⵔ ⵍⴰ ⵜⵏ⵿ⴼⴰ ⵓⵍⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ⵎⵔⵏ ⵔⵜ ⵓⴹⵢ ⵙ ⴶⴰ ⵏⴾⵏⵢ ⵏⵆⵍ ⵛⴶⵢⵓⵏ ⵏⵀⵂⵓ ⴹ ⵏⵜⴶⵢⵜ ⵙ ⵎⵛⵏⴰ ⵙⵏ⵿ⴾⵔⴹⵓ ⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵏ⵿ⵜⴰ ⴹⵢ ⵓⵔ ⵤⴶⵓ ⵙ ⵓⵔ ⵜⵍⴾⵎ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ");
INSERT INTO ttqt_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ⴼⵍⵙ ⵏⵔ ⵎⵙ ⵙ ⵏⵎⵜⵏ ⵓⵔ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵢ ⵤⴰ ⵍⵎⵙⵈ ⴹⴰ ⵓⵔ ⴹⵜⵓⵙⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ⵎⵔⵏ ⴾⴹ ⵍⵎⵙⵈ ⵓⵔ ⴹⵜⵓⵙⵏ⵿ⴾⵔ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵢ ⵤⴰ ⵤⴶⵤⵏⵓⵏ ⵓⵔ ⵏ⵿ⴼⴰ ⵓⵍⴰ ⵎⵔⵏ ⵓⵔⵏ⵿ⴾⵓⵏ ⵀⴾⴹⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ⵢⵜⴹⵏ ⴹⵗ ⵓⵏ ⵀⴰ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵓⵔ ⴹⵙⵏ⵿ⵜⵍⴰ ⵜⵎⴰ ⵓⵍⵢⵏ ⵔ ⵓⵏ ⵂⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ⴾⴹ ⵏⴾⵏⵢ ⵜⵎⵏⵏⴰ ⴹⵗ ⵍⵎⵙⵈ ⵓⵔ ⴾⵢ ⴹⵏⵜ ⵜⴰ ⴹⴰ ⵗⵙ ⴹⵢ ⵤⴰ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴹⵗ ⴹⵏⵜ ⵓⵔ ⵏⴶⵔ ⵜⵍⴰ ⵏ⵿ⵜⵂⵏⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ⴾⵍⵔ ⵜⴹⵜ ⴹⵗ ⵎⵙ ⵙ ⵍⵎⵙⵈ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵏ⵿ⵜⴰ ⴹⵤⵔⵏ ⵜⵏⴾⵔⴰ ⵎⵙ ⵓⵏ ⵔⵜ ⵙⵜⴹⵏ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵀⴰ ⵤⴶⵤⵏⵏ ⵙⵔⵙ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ⴹ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵜⴹⵓⵢⵏ ⵙⴹⵏⵜ ⵜⵎⵙⵏ ⴹⵎ⵰ ⵎⴾ ⴹⵢ ⴹⴰ ⵤⴰ ⵙ ⵜⵏⴾⵔⴰ ⴹⵗⵙ ⴹⴰ ⵜⵙⴹⵓ ⵙ ⵜⵔⵢⵜ ⵏⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ⴹ ⵢⵜⴹⵏ ⴾⵍ ⵜⵏⵀⴰ ⴼⵍⵙ ⴹⵎ ⴹⴶⵎⴹⵏ ⵎⴾ ⴹⵢ ⴹⴰ ⵤⴰ ⵙ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵙⵗⵏⵏ ⴹⵍⵎⵙⵈ ⴹ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵔⵏ ⵜⴶⴰ ⵙⵏⵤⵎ ⵍⵎⵙⵈ ⵙⵔⵙ ⴹⵤⵔⵏ ⴹⴼⵔ ⴹⵢ ⵓⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔⵏⵏ ⵗⵔ ⵜⵓⵗⵍⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ⵎⵔⵏ ⵜⵙⴹⵓ ⵜⵤⵔⵙ⵿ⵜ ⵏⴹⵏⵜ ⵌⵀⵔⵌⵜ ⵍⵎⵙⵈ ⵜⵎⵏⴾⵍⴰ ⴾⵍ ⴹⵍⵈⴾⵎⵏ ⴾⵍ ⴹⵜⵗⵎⵔⵏ ⵛⵏ ⵜⵏ⵿ⴾⵍⵏⵏ ⴹⴼⵔ ⴹⵢ ⴹⴾⵍ ⵜⵗⵎⵔ ⴾⴼⵜ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ⴼⵍⵙ ⵍⵤⵎ ⵍⵎⵙⵈ ⴹ ⵜⴼ ⵜⵗⵎⵔ ⵂⵔ ⴶⵓ ⵎⵛⵏⴰ ⵤⵏ⵿ⴶⵏⵜ ⴾⵍ ⴹⵓ ⴹⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ⵤⵏ⵿ⴶⵓⵏⵜ ⵓⵙ ⵤⵤⵔⵢ ⵙⵂⵍⴾⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴶⴰ ⵎⵛⵏⴰ ⵔⵜⵏ ⴾⵍ ⴹⵓ ⴹⵔⵏⵜ» ⵎⵔⵏ ⵎⵏ ⵙ «ⵔⵜⵏ ⴾⵍ» ⵓⵏ ⵙ ⵜⵓⵏⴰ ⴹ ⵎⵍⵏ ⴹⵓ ⴹⵔⵏⵜ ⴹⴰ ⵓⵔ ⵜⵏⵂⴰ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵎⵏⵜ ⴾⴼⵏ ⵍⵎⵙⵈ ⵜⵗⵎⵔ ⵜⴰ ⵜⴼ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ⵎⵔⵏ ⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⵜⵏ ⴾⵍ ⴹⵓ ⴹⵔⵏ ⵏⵍⵎⵙⵈ ⵍⵓⵆ ⵓⴹⵢ ⴹ ⵤⴶⵓ ⵀⵔⵔ ⵏ⵿ⵜⴰ ⴹⴰ ⵍⵎⵗⵏⴰ ⵍⵎⵙⵈ ⵎⵏⵜ ⴹⵓ ⵍⵈⴾⵎ ⵏⵎⵛⵏⴰ ⵓⴰ ⴶⵏ ⵔⵜⵏ ⴾⵍ ⴹⵓ ⴹⵔⵏⵜ ⴼⵍ ⴹ ⵜⴾⵎⵍ ⵜⵤⵔ⵿ⵜ ⵏⵎⵛⵏⴰ ⵢⵔⵜ ⴾⵍ ⴹⵗ ⴹⴶ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ⵎⵔⵏ ⵏ⵿ⵤⵔⵜ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵙⵗⵎⵔ ⵏⵢⵜⴹⵏⵙⵏ ⵓⵏ ⵀⴰ ⵓⴾ ⵎⴰ ⵎⵙ ⵓⵙ ⴶⵏ ⵜⵎⴰ ⵏⴶⵔⵓⵏⵜ ⴹⵗ ⴶⵢ ⵏⵓⵏ⵰ ⴾⴹ ⵏ⵿ⵜⴰ ⵜⴹⵜ ⴹⵗ ⵎⵙ ⵙ ⵓⵔ ⵜⵜⵍⴰ ⵜⵏⴾⵔⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⵎⴰ ⴼⵍ ⵜⵓⵙⵍⵎⵗⵏ ⴹⵗ ⵎⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵙⵗⵎⵔ ⵏⵢⵜⴹⵏⵙⵏ ⵓⵏ ⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵤⴰ ⵎⴰ ⴼⵍ ⴾ ⵙⵗⵜ ⵏⵂⴰ ⵜⵤⴾ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ⴾ ⵤⵍ ⵜⵂⵤⴹⵓ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵎⴹⵔⵢⵏⵏ ⵔⵜ ⵓⴹⵢ ⴶⵙ ⵛⴾ ⴶⵎⴹ ⵓⴰ ⴶⴰ ⵢⵙⵀⵔⴶ ⵓⴰ ⴼⵍⵓⵏ ⵜⴶⴰ ⴼⵍ ⴹⵍⵍ ⵏⵓⴰ ⴹⵗⵓⵏ ⴶⴰ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ⴾⴹ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴶⵗ ⴹⵗ ⵗⵔⵎ ⵏⴼⵤ ⵓⵔ ⵏⵤⵍⵢ ⴹⵎⴶⵔ ⴹⵓⵈⵙⵏ ⵓⵔ ⵜⴶⴰ ⵔ ⴼⵍ ⵔⵙ ⵏⴹⵏⵜ ⵓⴾ ⵎⴰ ⴹⵤⵜⴾⵏⵓ⵰ ⴾⴹ ⵏⵎⵜⵏ ⵓⵔ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔⵏ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵢ ⵤⴰ ⴶⵜⵏⵗ ⵓⴰ ⵏⵏ ⵢⵜⴹⵏ ⵓⵢⴹ ⵙ ⵏⵏ «ⵏⵜⵛⵜ ⵏⵛⵓⵜ ⴼⵍⵙ ⵓⵔ ⴹⵗⵏⵗ ⵍⴾⵎ ⵔ ⵜⵎⵜⵏ⵿ⵜ» ");
INSERT INTO ttqt_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ⴹ ⵓⵔ ⵜⵜⵓⵙⵈⵔⴾⵎ⵰ ⴼⵍⵙ ⵏⵏ ⴾⵍ ⵓⵍ «ⵜⴹⵓⵜ ⴹⵔⴾ ⵢⵜⴹⵏ ⵜⵗⵛⴹ ⵍⵈⵍ ⵍⵗⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ⵜⵆⵍⵜⴾⵓⵏ⵿ⴹⵓ ⵜⵢⵜⵢⵏⵓⵏ ⵜⴰ ⵜⵍⵗⵜ ⵜⵎⵤⵢⵎ ⴹⴶⵢ ⵏⵀⴾⴹⵏ⵰ ⴼⵍⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⵓⵔ ⵙⵏⵏ ⵎⵛⵏⴰ⵰ ⵏⵗ ⴹⵢ ⴼⵍ ⴾⵓⵏⵤⵀⵤ ⵜⴾⵔⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ⵎⵛⵏ ⵓⵔ ⴶⴹⵍ ⵓⵏ ⴹ ⵏⵏ ⵓⵢⴹ ⴹⵗⵓⵏ «ⵓⴾ ⵏⵎⵜⵏ ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔⵏ⵰ ⵎⴰ ⵜⵎⵙ ⵜⵗⵙⴰ ⵜⴰ ⴹⵔ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ⵍⵌⵂⵍⵏ⵰ ⵙ ⵜⵏⵀⵍⵎ ⵜⵀⵍⵍ⵿ⵜ ⵏⵎⵙⴰ ⵓⵔⴶⵗ ⴾⵏ⵿ⴹⵀⴰ ⵜⵎⵜ ⵙ ⴹⵜⴶⵎⴹ ⵜⴹⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ⵎⵙⴰ ⴹⵗ ⵗⵙ ⵜⵏⵀⵍⵎ ⴹⵏ ⵂⴰ ⵎⵌⵙ ⵏ ⵍⴾⵎⴰ ⵎⴹⵗ ⵜⵀⵤⵙ⵿ⵜ ⵢⵜ ⵓⵔⴶⵗ ⵜⵙⵗⵜⵜ ⵜⵗⵔⴹⵜ ⵜⵏⵀⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ⵜⵤⵔ ⴾⴼⵢ ⵎⵛⵏⴰ ⵜⵗⵙⴰ ⵜⴰ ⴹⵙⵔⴰ ⴾⵍⴾ ⵏⵎⵙⴰ ⴾⴼⵢ ⵜⵗⵙⴰ ⵏⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ⵛⵈⵍⴾ ⵓⵔ ⵍⵏⵜ ⵜⵗⵙⴰ ⴾⵜⵏⵙⵏⵜ⵰ ⵢⵜⴹⵏ ⵤⵏⵜ ⵜⵗⵙⴰ ⵜⵏⵙⵏ ⵂⵔⵢ ⵤⵏⵜ ⵜⵏⵜ ⴶⴹⴹ ⵤⵏⵜ ⵜⵏⵙⵏ ⴾⴼⵜⵏ ⴹⵗ ⵤⵏⵜ ⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ⵎⵔⵏ ⵌⵏⵓⵏ ⴹⴰ ⵂⵏ⵿ⵜⵏ ⵔⵜⵏ ⵍⵏⵏ ⵛⵗⵙⵓⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵎⴹⵍ ⵓⵔⵏ⵿ⵜⵓ ⵔⵜⵏ ⵍⵏⵏ ⵛⵗⵙⵓⵏ⵰ ⵎⵛⵏ ⵛⵂⵙⵢ ⵏⵔⵜⵏ ⵓⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⵓⵔ ⵜⵍⴰ ⴹⵜⵂⵙⵢ ⵏⵓⵏ ⵓⵔⵏⵏ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ⵤⵏⵜ ⵏⵔ ⵓⵏ ⵜⴼⴾ ⵤⵏⵜ ⵓⵏ ⵜⵍⵜ ⵜⵔⵏ ⴹⵗ ⵤⵏⵜ ⵓⵏⵙⵏ⵰ ⵜⵔⵏ ⵎⵏⵙⵏ ⵏⵔⵏⵙⵏ ⵤⵏⴼⵏ ⵎⵙ ⵏⵔ ⵏⵢⵏ ⴶⵔ ⵏⵔ ⵓⴰ ⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ⵤⵏ⵿ⴹ ⵎⴾ ⴹⵢ ⴹⴰ ⵜⴶⴰ ⵜⵏⴾⵔⴰ ⵏⵎⵜⵏ⵰ ⵜⵗⵙⴰ ⵜⵗⵛⴹⵜ ⵤⴰ ⵜⵏⵀⵍⵜ ⵜⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⵜⴰ ⵓⵔ ⵏⵜⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ⵜⵗⵙⴰ ⵜⴰ ⴹⵔ ⵏⵀⵍ ⵓⴹⵏ ⵜⵀⵔⵔ⵰ ⵜⴰ ⴹⵔ ⴹⵤⵏ⵿ⴾⵔ ⵜⴾⵏⴰ ⵛⵂⵙⵢ⵰ ⵜⵗⵙⴰ ⵜⴰ ⴹⵔ ⵏⵀⵍ ⵓⴹⵏ ⵜⵔⴾⵎ⵰ ⵜⴰ ⴹⵔ ⴹⵤⵜⵓⵙⵏ⵿ⴾⵔ ⵜⵍⴰ ⵜⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ⵏⵀⵍⵏ ⴹⵜⵗⵙⴰ ⵜⵏ ⴹⵏⵜ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵜⵗⵙⴰ ⵜⴰ ⵂⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⴹⴰ ⵜⵜⵍⴰ ⵜⵗⵙⴰ ⵜⵏ ⴹⵏⵜ ⵓⴹⵢ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⴰ ⵜⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ⴹⵢ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴹⵎ ⴹⵤⵔⵏ ⵢⵢⵜⴹⵏ ⵙⵈⵍⴾ ⵎⵍ⵿ⵜⵓ ⴹⵔ» ⵎⵛⵏ ⴹⵎ ⵓⵏ ⵛⵏ ⵙⵏ⵿ⵜⴰ ⵓⴰ ⵍⴾⵎⵏ ⵜⵎⵙⵏ ⵍⵎⵙⵈ ⵏ⵿ⴼⵙ ⵎⵙ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ⵓⵔⴶⵗ ⵓⴰ ⵎⵙⵏ ⵏ⵿ⴼⵙ ⴹⵤⵔⵏ ⴾⵍⵔ ⵓⴰ ⵎⵙⵏ ⵜⵈⵍⴾ ⵏⴹⵏⵜ ⵜⴹⵔⵜ ⴹⵤⵔⵏ ⴹⴼⵔⵙ ⴹⵙⴰ ⵓⴰ ⵎⵙⵏ ⵏ⵿ⴼⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ⵓⴹⵏ ⵓⴰ ⴹⵤⵔⵏ ⴶⴹⵔⵔ ⴹⵗ ⴶⴰ ⴶⵎⴹⵓ ⵎⴹⵍ⵰ ⵓⴹⵏ ⵓⵏ ⵛⵏ ⵏ⵿ⵜⴰ ⵌⵏⵓⵏ ⴹⴶⵎⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ⵓⴹⵏ ⵓⴰ ⴶⵏ ⴹⵗ ⴶⴹⵔⵔ ⵓⴰ ⵎⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵏⵏ ⴹⵗ ⴶⴹⵔⵔ⵰ ⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵎⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ⵎⵔⵏ ⵜⵍⵜ ⵜⴰ ⵏⴶⴰ ⴹⵓⴹⵏ ⵓⴰ ⴶⵏ ⴹⵗ ⴶⴹⵔⵔ ⵏ⵿ⵜⴰ ⵤⴰ ⵏⴶⵓ ⴹⵓⴰ ⴹⴶⵎⴹⵏ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ⵎⴹⵔⵢⵏⵏ ⴹⵓⵏ⵿ⴶⵏⵗ ⵓⴰ ⴶⵏ ⴹⵗ ⵙⵏ ⴹⵤⵏⵢ ⵓⵔ ⵤⵍⵓ ⴹⴶⵔ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ ⵓⵍⴰ ⴹⵗ ⵍⵓ ⵓⴰ ⵗⵛⴹⵏ ⴹⴶⵔ ⴹⵗ ⵓⴰ ⵓⵔ ⵏⵗⵛⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ⵙⵙⵎⵜ ⴹⵓⵏⵎⵍⵗ ⵙⵔ ⵓⵔ ⴹⵏⵤⵀⴰ ⴾⵜⵏⵏⴰ ⵎⵛⵏ ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⴾⵜⵏⵏⴰ ⵙ ⵤⴰ ⵏⵜⵓⵙⵎⵜⵢ ");
INSERT INTO ttqt_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ⴼⵍ ⵔⵜ ⵏⵎⵤⵢ ⴼⵍ ⵍⴼ ⵏⵛⵜ ⵗⵔ ⵏⵙⵗ ⵓⴰ ⵍⴾⵎⵏ ⵏⵙⴾ⵰ ⴼⵍⵙ ⴹ ⵜⵓⵏ⵿ⵙⵗ ⵙⴾ ⵜⵤⵔ ⵜⵓⵙⵏ⵿ⴾⵔⵏ⵿ⴹⵓ ⵏⵎⵜⵏ ⴹⵜⵗⵙⵓⵏ ⵓⵔ ⵤⴰ ⵏⵍⵙ ⵗⵛⴹ ⵏⴾⵏⵢ ⴹⵗ ⵏⵜⵓⵙⵎⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ⴼⵍⵙ ⵜⵗⵙⴰ ⵜⴰ ⵜⵗⵛⴹⵜ ⵛⵍ ⴹ ⵜⴶⵤ ⵜⴰ ⵓⵔ ⵏⵗⵛⴹ ⴹⴶⵏⵜ⵰ ⵜⴰ ⵜⵜⵎⵜⵜ ⴹⵗ ⵛⵍ ⴹ ⵜⴶⵤ ⵜⴰ ⵓⵔ ⵏⵜⵎⵜⵜ ⴹⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ⵙ ⵜⴶⵤ ⵜⵗⵙⴰ ⵜⴰ ⵓⵔ ⵏⵗⵛⴹ ⴹⴶ ⵏ⵿ⵜⴰ ⵜⵗⵛⴹⵜ ⵜⴶⵤ ⴹⵗ ⵜⵗⵙⴰ ⵜⴰ ⵓⵔ ⵏⵜⵎⵜⵜ ⴹⴶ ⵏ⵿ⵜⴰ ⵜⵜⵎⵜⵜ ⴹⵢ ⵎⵔⵏ ⴹ ⵤⵏ⵿ⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⵜⵎⵜⵏ⵿ⵜ ⵜⵜⵍⵎⵤ ⵜⵜⵓⵔⵏⴰ ⵀⵙ ⵜⵜⵍⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","«ⵢⴰ ⵜⵎⵜⵏ⵿ⵜ ⵎⴰ ⵜⴶⴰ ⵜⵔⵏⵏⵎ⵰ ⵎⴰ ⴶⴰ ⵏ⵿ⴹⵍⵏⵎ ⵓⵙ ⵜⴹⴶⵗ ⵢⵜⴹⵏ ⵜⵏⵆⵆⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ⵀⴾⴹ ⵎⵙⵏ ⵏ⵿ⴹⵍ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵀⴾⴹ ⵎⵔⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵎⵙⵏ ⵙⵂⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ⵎⵛⵏ ⴶⴹⴰ ⵢ ⵎⵛⵏⴰ ⴹⵏⵗⵙⵙⵔⵏⵏ ⵀⴾⴹ ⵙ ⵜⵔⵢⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⴾⵏⵗ ⵜⵔⴰ ⵤⵤⵓⵜⵜ ⴹⵗ ⵤⴶⵤⵏⵓⵏ ⵜⵤⴾⵎ ⴹⵗⵙ ⵙⵙⵂⵜ ⴹ ⵜⵜⴶⵎ ⴼⵓ ⵙⴶⵜ ⵛⵗⵍ ⵍⵗⵏ ⵓⴰ ⵜⵜⴶⵎ ⵢⵎⵍⵢ ⴹ ⵜⵙⵏⵎ ⵙ ⵛⵗⵍ ⵙⵂⵏ ⵓⴰ ⵜⵜⴶⵎ ⵢⵎⵍⵢ ⵓⵔ ⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵛⵔⴶⵜⵏ ⵛⵏ ⵜⵓⴶⵏⵏ ⵢ ⵎⵤⴹⴶⵏ ⵓⵏ ⵢⵔⵙⵍⵎ ⴶⵜ ⴾⵓⵏⵢ ⴹⴰ ⵔⵜ ⵓⵙ ⵎⵔⵗ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⴾⵍ ⵓⵏ ⴶⵍⵜⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ⴾⵍⴾ ⵏⵤⵍ ⵓⴰ ⵤⵔⵏ ⴹⵗ ⵙⴾ ⴾⵢⵏ ⴹⵗⵓⵏ ⴹⴾⵍ ⴹⵗ ⵓⴰ ⵙⵔⵙ ⴹⴶⵤⵏ ⵔⵜ ⵓⵙ ⴼⵔⴶ ⵗⵀⵔ⵿ⵜⵓ ⵂⵔ ⴾⵓⵏⵏⵙⴰ ⴼⵍ ⴹ ⵓⵔ ⵆⵍ ⵛⴹⵓⵏⵓⵏ ⵛⵔⴶⵜⵏ ⵢⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ⵙ ⴾⵓⵏⵏⵙⵗ ⴹ ⴾⴼⴰ ⵢⵜⴹⵏⵓⵏ ⵓⵏ ⵜⵙⵏⴼⵔⵏⵎ ⵛⵔⴰ ⴼⵍ ⴾⵜⵀ ⵙ ⵢⵜⴹⵏⵏ ⵎⵙⵏ ⵜⵤⵔ ⵙⴾⵆⵏ ⵢⵔⵙⵍⵎ ⵓⵢⵏ ⵛⵔⴶⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ⴾⴹ ⴹⵗ ⵜⵓⵏⵢ ⵙ ⵂⵔ ⴹ ⴶⵍⴰ ⵏⴾ ⵎⵏⵏ ⵓⴹⵢ ⴹⵔⵢ ⴹⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ⴾⵏ⵿ⴹⵀⴰ ⵎⵔⵗ ⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ ⵙ ⴾⵓⵏⵏ⵿ⵤⵙⴰ ⴼⵍⵙ ⴹ ⵔⵤⴶⴰ ⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ⵂⴰ ⵎⵌⵙ ⵗⵔⵓⵏ ⴶⵗ ⴹⵏ ⵎⵌⵙ ⴹⵗ ⵜⴶⵔⵙ⵿ⵜ ⴾⵜⵏⵜ ⵙ ⵗⵔⵓⵏ ⵜⵜⵤⴾⵙⵗ ⴼⵍ ⴹⵜⴶⵎ ⵍⵓⵜⵏ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵙⴾⵍ ⵓⵙ ⴾⵓⵏ⵿ⵤⴶⵎⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ⵜⴹⵜ ⵙ ⵓⵔ ⵔⵗ ⴾⵓⵏⵏⵙⴰ ⵎⵔⴹⴰ ⴶⵗⵓⵏⵏ ⵙⴰ ⴹⵗ ⵤⴾ⵰ ⴼⵍⵙ ⴶⵗ ⵜⵎⴰ ⵏⴹ ⵂⴶⴰ ⵗⵔⵓⵏ ⴾⴹ ⴾⴼⵢ ⵎⵍⵢ ⵜⵔⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ⵎⵔⴹⴰ ⴹ ⵆⵎⵗ ⴹⵗ ⵗⵔⵎ ⵓⵏ ⴼⵤ ⵂⵔ ⴹⵢ ⴹⵗⵙ ⴹⵓⴹ ⵎⴹ ⵓⵏ ⴼⵏ⵿ⵜⴾⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ⴼⵍⵙ ⵜⵏⵍⵎⵢ ⴹⵗⵙ ⵜⵔⵢⵜ ⵤⵓⵔⵜ ⵏⵛⵗⵍ ⴾⴹⵗ ⵙ ⴶⵜⵏ ⵤⵏ⵿ⴶⴰ ⵓⵏ ⵓⵔ ⵏⵔⴰ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ⵎⵔⵏ ⵙ ⴾⵓⵏⵏⵙⴰ ⵜⵎⵜⵢ ⵜⵀⵤⵎ⵿ⵜⵏ ⵙ ⵎⵏⵓⵏ ⵜⵓⵔⵎⵍ ⵔⵜ ⵙ ⵜⵜⵂⴰ ⵜⵙⵏⵜ ⴼⵍⵙ ⵛⵗⵍ ⵢⵎⵍⵢ ⵂⴰ ⵏ⵿ⵜⴰ ⴹⴰ ⵛⵍⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ⴹⵗ ⴹⵢ ⵜⵓⵔⵍⴾⵓ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ⴶⵓⵜⵙ ⵍⵓⵜⵏ ⴼⵍ ⵙⵔⵢ ⴹⴶⵓ ⵛⴾⵍ ⵍⵗⵏ ⴼⵍⵙ ⵆⵍⵗⵙ ⵏ⵿ⵜⴰ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⴹⵔ ⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵎⴹⵔⵢⵏⵏⴰ ⵀⵍⵙ ⴶⵎⵢⴰ ⴹⵗⵙ ⵓⵍⵏ ⴾⵓⵏⵏⵙⵓ ⴹⵓ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⴹⵢ⵰ ⴶⵎⴹ ⵛⴾ ⵙ ⵓⵔ ⵍⴰ ⵏⵢⵜ ⵏⴹⵢ ⵎⵔⴹⴰ⵰ ⵎⵛⵏ ⵙ ⴶⵔⵓ ⵙⴹⵢ ⴾⵓⵏⵏⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ⴶⵜ ⵏⵢⵜ ⵜⵤⵤⵓⵎ ⴹⵗ ⵤⴶⵤⵏⵓⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵓⵔ ⵜⵂⴰ ⵜⵙⴰ ⵜⵙⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵜⴶⵎ ⴶⵓⵜⵓ ⵙ ⵎⵏ ⵜⵂⴰ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ⵂⵏ⵿ⴾⵓⵏ ⵙⵍⵏ ⵏⵢⵜⴹⵏ ⵏⵂⵏ ⵓⵏ ⵙ⵿ⵜⴼⵏⵙ⵰ ⵜⵙⵏⵎ ⵙ ⵏ⵿ⵜⵏⵢ ⵤⵔⵏⵏ ⵙⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵗ ⴾⵍ ⵓⵏ ⴾⵢⴰ ⴾⵙⵏ ⴹⵗ ⵎⵏⵙⵏ ⵙⵛⵗⵍ ⵢ ⵎⵤⴹⴶⵏ⵰ ⵏ⵿ⵙⵢⵆⵓⵏ ⵤⴰ ⵎⴹⵔⵢⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ⴹⵙⵏ⵿ⵜⵀⵔⴹⴶⵎ ⵏ⵿ⵜⵏⵢ ⴹⴹ ⵜⵍⴰ ⵓⴹⵏ ⵂⵏ ⵛⵗⵍ ⵓⴰ ⵂⵏ ⵙ ⴶⵍⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ⵙⴹⵓⵜⵢ ⵙⴰ ⵓⴰ ⴹⴹⴶⴰ ⵙ⵿ⵜⴼⵏⵙ ⴹⴼⵔ⵿ⵜⵏⵜⵙ ⴹⵈⵢⴾⵙ⵰ ⵙⵏⵙⵏ ⴹⵀⵗⵏ ⵜⵈⵔⵀⵜ ⵜⴰ ⵙⵔⵢ ⴹⵓⵢ ⵀⴰ ⵏⵛⵏⵢⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ⴼⵍⵙ ⵙⵙⵎⴹ ⵎⵏⵏ ⵙⵙⵎⴹ ⴹⵗ ⵓⵏⵓⵏ⵰ ⴹⵗ ⴹⵢ ⵜⴶⵜ ⵎⵙⵏⵜ ⴼⵍ ⵎⴹⵏ ⵤⵏ ⵓⵏ ⴹⵢ ⵜⵓⵙⵗⵎⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ⵂⵍⵏ⵿ⴾⵓⵏⵏ ⵏⵍⴾⵎⵏ ⵓⵏ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⴾⵍ ⵓⵏ ⵙⵢⴰ⵰ ⵂⵍⴾⵓⵏⵏ ⴹⵗ ⴾⵍⵙ ⴹⴼⵔⵙⴾⴰ ⴹⵏⵍⴾⵎⵏ ⵓⵏ ⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵜⵎⵏⵢⵜ ⴹⵗ ⵂⵏⵙⵏ⵰ ⵂⵍⵏ⵿ⴾⵓⵏⵏ ⵓⵍⵏ ⵓⵍⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ⵂⵍⵏ⵿ⴾⵓⵏⵏ ⵎⴹⵔⵢⵏⵓⵏ ⴹⵗ ⴹⵏ ⵓⵏ ⵍⵏⵏ ⴹⴰ ⴹⴰ ⴾⵜⵏⵙⵏ⵰ ⵜⵏⵎⴶⵜ ⵙⵍⵎ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ⵜⵂⵍ⵿ⵜ ⵓⴰ ⴹⵏ⵿ⵜⴶⵎⴹⵜ ⴼⵙ ⵓⵏⵏ ⵏⴾ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ⵎⵛⵏⴰ ⵜⵍⵗⵏⵗ ⵓⴹⵏ ⵓⴰ ⵓⵔ ⵏⵔⴰ ⵎⵍⵢ ⵗⵢⵙⴰ⵰ ⵎⵔⵏⴰ ⵜⴰ ⵍⵎⵗⵏⴰ ⵢⴰ ⵎⵍⵏⵏⴰ ⵙⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴾⵓⵏⴾⴼⵏ ⵔⵈⵎⵜ ⵏⵎⵍⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ⵔⵆⵓⵏ ⴾⵜⵏⵓⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰");
INSERT INTO ttqt_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⵎⵙⵏ ⵙ ⵜⵔⴹⵓⵜ ⵏⵎⵛⵏⴰ ⵏⵎⵤⵍ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵏⴾ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵜⵎⵜⵢ ⵏⵏⵏ ⵂⵍⵏⵏ ⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⵜⴰ ⵜⵂⵜ ⵗⵔⵎ ⵏ⵿ⴾⵔⵏ⵿ⵜ ⴹⵎⵤⴹⴶⵏ ⴾⵍ ⵓⵏ ⵈⵙⵔⵏⵏ ⴹⵗ ⴾⵍ ⵏⴾⵢⴰ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵓⵏⴾⴼⵏ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵀⴰ ⵓⵏ ⵎⵂⵏⵏ ⵎⵙ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵙⵙⵎⴹⵏ ⵓⵍⵏ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ⵙⵏ⵿ⵜⴰ ⵙⵙⵎⴹⵏ ⵓⵍⵏⵏⴰ ⵜⵆⵍ ⵜⵙⵙ⵿ⵜ ⵜⴰ ⴼⵍⵏⴰ ⵜⴶⵜ ⴼⵍ ⴹⵏⵗⵙⴼⵔⴶ ⵙ ⵜⵔⵢⵜ ⵏⵙⵙⵎⴹ ⵓⴰ ⵜⴶ ⵓⵍⵏⵏⴰ ⴹ ⵏⵙⵙⵎⴹ ⵏⴾⵏⵢ ⴹⴰ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⴼⵍ ⵜⴶⴰ ⵜⵙⵙ⵿ⵜ ⵜⵆⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ⴹ ⴶⵜ ⵓⴰ ⴶⴰ ⵍⵗⵤⵀ ⵓⴰ ⵏⵏⵢ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆⵏⵏⴰ ⴹⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵜⴶⴰ ⵜⵙⵙⵎⵜ ⵏⵓⵍⵏ ⵜⴰ ⴹⵏⵗⵂⴾⵓ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ⴾⴹ ⵜⵓⵙⵙ ⵓⴰ ⵏⴶⴰ ⵜⵙⵙⵎⵜ ⴹⴼⵙⵏⵓⵏ ⵎⵙ ⴾⴹ ⴹⵗ ⵜⵙⵙⵎⵜ ⵏⵓⵍⵏ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ ⵓⴹⵢ ⴾⵓⵏⵢ ⵙ ⵜⵜⴾⴼⴰ⵰ ⵜⵙⵙⵎⵜ ⵜⴹⵢ ⵜⴾⴼⵓⵏ ⴹ ⵜⵤⵎⵔⵎ ⵢⵍⵗⵤⵀ ⵓⴰ ⵏⵜⴶⵓ ⵏⴾⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ⵓⵔ ⴾⵍⴰ ⴹ ⵏⴶⴰ ⵛⴾ ⴹⵗ ⵜⵎⴰ ⵓⴰ ⴹⵗⵓⵏ ⵏⴶⴰ ⴼⵍⵙ ⵏⵙⵏ ⵙ ⴹⴰ ⴹⵔⵏⴰ ⵜⴹⵔⵓⵎ ⵍⵗⵤⵀ ⵜⵙⵙⵎⵜ ⵜⴰ ⵜⴶⵓ ⵎⵛⵏⴰ ⵓⵍⵏⵏⴰ ⴹⴰ ⴹⵔⵏⴰ ⵜⵜⴹⵔⵓⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵓⵔ ⵏⵔⴰ ⴾⵓⵏⵓⵔⵂⵏ ⵙⵍⵏ ⵏ⵿ⵜⵙⵙ⵿ⵜ ⵜⴰ ⴼⵍⵏⴰ ⵜⴶⵜ ⴹⵗ ⴾⵍ ⵏⵙⵢⴰ⵰ ⵜⴶⵔⵓⵏⴰ ⴹⵗⵙ ⵜⵙⵙ⵿ⵜ ⵜⴶⵔⵜ ⵓⵙ ⵏⴼⵔⴶ ⴹⵔⵙ ⵏⵤⵤⵢⴹⵔ ⴼⴹⴰ ⵂⵔ ⵏⴾⵙ ⵜⵎⴰ ⵏⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ⵜⴹⵜ ⵙ ⵎⵍ ⵗⵔⵏⵗ ⵙ ⵓⵔ ⴹⵏⵜⵍⴰ ⵔ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵔⵜ ⵓⴰ ⴶⵔⵓⵏⴰ ⴼⵍ ⴹ ⵏⵙⵏ ⵙ ⵓⵔⴶ ⵎⵏⵏⴰ ⴾⵍⵔ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵏⵎⵜⵏ ⵗⵙ ⵙ ⵂⵔ ⴹⵗⵙ ⵏⴶⵓ ⵜⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ⵏ⵿ⵜⴰ ⴹⵏⴹⴾⵙⵏ ⴹⵗ ⵜⵤⴾ ⵍⵀⵙⵜ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⵏⴶⵤ ⴹⵏ ⵏ⵿ⵜⴰ ⴹⵏⴹⵤⴾⵙⵏ ⴹⵗ ⴹⴶ ⵛⵍⵜ ⵏⵓⵏ⵰ ⵏⴶⴰ ⴹⵗ ⵜⵎⴰ ⵏⵙ ⵢ ⵜⵏⴶⵤ ⴹⵏⴹⴾⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ⵎⵔⵏ ⴾⵓⵏⵢ ⵜⴹⵂⵍⵎⵏⴰ ⵙ ⵎⵏ⵿ⵙⵢ ⵓⴰ ⴹⵏⵜⵜⴶⵎ ⵎⵛⵏⴰ⵰ ⴹⵢ ⴼⵍⵙ ⵔⵈⵎⵜ ⵜⴰ ⵤⴰ ⵏⴶⵔⵓ ⵙ ⵜⵓⵜⵔⵓⵏ ⵏⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴹⵜⵓⵢ ⵙⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵓⵢⴹ ⴹ ⴶⴹⵢⵏ ⵢ ⵎⵛⵏⴰ ⵔⵜ ⵓⴰ ⴹⵏⵗⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵀⵔⴶⵏⵏⴰ ⵓⵔ ⵏⵙⵏ ⴼⵍ ⵔⴾ ⵔⵜ ⴹⵗ ⴹⵏⵜ ⵜⴰ ⴹⴰ ⵙ ⴹⵏⵤⵀⵤⵏ ⵎⵏⵏⴰ ⵓⵍⵏ ⴹⵗ ⵜⵙⵆ ⵜⴰ ⴹⵔⵓⵏ ⵏⴶⴰ⵰ ⵓⵔ ⵏⴶⴰ ⵎⵤⵍ ⵙ ⵓⵔⴶⵗ ⵓⵍ ⵢⵏ⵿ⴹⴰ ⵤⴹⴶⵏ ⵓⴰ ⵂⴾⵓ ⵎⵛⵏⴰ ⵙ ⵜⵏⴶⴰ⵰ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⴹⵏⵗⵜⵙⴼⵔⴶⵜ ⵓⵏ ⵓⵔⴶⵗ ⴹⵂⵏ ⵙ ⵎⵙⵏⵜ ⵏⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_13","077_1_13","2CO","1","13","14","ⴼⵍⵙ ⵛⵔⴰ ⵛⵏ ⴹⵓⵏⵏⴾⵜⵀ ⵓⵔ ⴹⵗⵙⵏⵜ ⵏⵙⴾⴰ ⵔⵜ ⵓⵍⵢⵏ ⵓⵔ ⵏⵎⵙ ⵓⴹⵢ ⴹⴰ ⵜⵗⵔⵎ ⴹⵢ ⵜⴶⵔⵎ⵿ⵜⵓ⵰ ⴾⴹ ⴹⵏⵓⵔ⵿ⵜⴶⵎ ⴶⵔⵢ ⵍⵗⵏ ⵎⵔⴹⴰ ⴹⴰ ⴶⵗ ⵜⵎⵏⵏ ⴹⵗ ⴹ ⵜⵓⴹⵎ ⴹⵏⵜⴶⵎ ⴶⵔⵢ ⴾⵎⵍⵏ ⵜⴶⵎ ⴼⵍ ⴹⵍⵍⵏⵏⴰ ⵀⵔⴶ ⵓⴰ ⴹⵏⵗⵙⵙⴶⴰ ⵓⵏⵓⵏ ⵤⵍ ⵓⴰ ⴹⵤⵙⵓ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ⴾⵙ ⵓⴰ ⴶⵗ ⵛⴾ ⴹⵗ ⴹⵢ ⴼⵍ ⵜⵙⵗ ⵙⵔⵓⵏ ⵏⵤⵔⴰ ⴼⵍ ⴹ ⵜⴶⵔⵓⵎ ⴹⵗ ⵙⵏⵏ ⵜⵏ⵿ⴼⴰ ⵜⵎⵙⵜ ⵏⵜⴼⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ⴾⵢⵆⵓⵏ ⵙⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ⵰ ⵙ ⴹⴶⵎⴹⴰ ⵎⵙⴹⵏⵢⴰ ⴾⵓⵏ⵿ⴹⵆⵍⴰ ⵜⴶⵎⵢ ⵍⵓⵜⵏ ⵢⵛⴾⵍ ⵓⴰ ⵤⴶⴰ ⵙⴾⵍ ⵓⵏ ⵢⵂⴹⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ⵓⴾ ⴶⵍⵢⵜ ⵓⵔ ⴶⵗ ⴹⵗ ⵜⵙ ⵓⴰ ⴶⵗ ⴾⵓⵏⵏⵙⴰ⵰ ⵎⵗ ⴾ ⵔⵜⵏ ⵓⵏ ⵙ ⵔⵗ ⴶⵏⵙⵏ ⵓⵔ ⵎⵙⵏ ⵔ ⴹⵔⵏⵏ ⵏⴶⴹⵎ ⴶⵏⵏ «ⵢⵓ» ⵙ ⴶⴰ ⵎⵤⵢ ⴹ ⵏⵓ «ⴾⵍ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ⴶⵢⵜ ⵎⵛⵏⴰ ⵙ ⵓⴰ ⴹⵓⵏⵏⴰ ⵓⵔ ⵎⵙ «ⵢⵓ» ⵔ⵿ⵜⵢⵏ ⴹ «ⴾⵍ» ");
INSERT INTO ttqt_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ⴼⵍⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵢ ⵏⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵓⵙ ⴹⵓⵏⴶⴰ ⵙⵍⵏⵜ ⵏⴾ ⴹⵙⵍⴼⵏⵙ ⴹⵜⵎⵜⵢ ⵓⵔ ⵙⵔ⵿ⵜⵢ «ⵢⵓ» ⴹ «ⴾⵍ»⵰ ⴾⵍⵔ «ⵢⵓ» ⵗⵙ ⵏⴰ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ⵔⴾⵓⵍⵏ ⵏⵎⵛⵏⴰ ⴾⵜⵏⵙⵏ «ⵢⵓ» ⵎⵙⵏ ⴹⵗ ⵍⵎⵙⵈ ⴹⵢ ⴹⴰ ⴹⵗ ⴼⵍ ⵏⵎⵍ ⴹⴾⵍ ⵏⵎⵛⵏⴰ ⵙ ⵜⵏⴰ ⵜⴰ ⵏⵜⴶⵓ «ⵎⵏ» ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ⵎⵔⵏ ⵜⵔ⵿ⵜⵢⵜ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵏⴾⵏⵢ ⴹⵔⵓⵏ ⵎⵛⵏⴰ ⵎⵏⵜ ⵜⵜⵙⵙⵂⵏ ⵙⵏⴼⵔⵏⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ⵙⵓⵔⵏⵗ ⴹⵗ ⵌⵓⵍⵏⵜ ⵍⵓⵆ ⵓⴰ ⴹⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵓⵍⵏⵏⴰ ⵎⵙ ⵓⵏ ⵜⵙⴾⵙ⵿ⵜ ⵏⵛⴾ ⴹⵗ ⵔⵤⵏ ⵓⵏ ⵙ ⵍⴾⵎ ⴹⵏⵆⵏⴾⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ⵎⵛⵏⴰ ⴹⵗⵢ ⵤⵀⵤⵏ ⵎⵏ ⴶⵆⵓ ⵜⴶⵢⴰ ⵙ ⵓⵔ ⴹⵏⵆⵍⴰ ⵗⵔⵎ ⵏ⵿ⴾⵔⵏ⵿ⵜ ⵔ ⴼⵍ ⵙ ⵓⵔ ⵔⵗ ⴹⵓⵏⵛⵜⴰ ⵗⵛⴹ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ⵎⵔⵏ ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵙ ⵓⵔ ⵏⴶⵎⵢ ⴹⴾⵓⵏⵛⵂⵛⵍ ⵔⵜ ⵓⵍⵢⵏ ⴹⵗ ⵀⵜⵓ ⵜⵏ ⵤⴶⵤⵏⵓⵏ ⴾⵍⵔ ⵏⵎⵛⵗⵍ ⵗⵙ ⴹⵔⵓⵏ ⵏⴶⴰ ⴹⵗ ⵔⵜ ⵓⴰ ⴾⵓⵏ⵿ⵤⵙⴼⵍⵓⵙⵏ ⴼⵍⵙ ⵤⴶⵤⵏⵓⵏ ⵙⵂⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ⴹⵢ ⴼⵍ ⴶⵗ ⵜⵏⵜ ⵜⵎⵙⵜ ⵙ ⵏⵗ ⵓⵔ ⵤⵍⵙⵗ ⵗⵛⴹ ⵏⵎⵏⵓⵏ ⵙⵢⵏ ⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ⴼⵍⵙ ⵏⴾ ⵙ ⵗⵛⴹⴰ ⵎⵏⵓⵏ ⵓⴾ ⵎⴰ ⴹⵤⵙⴹⵓⵏ ⵔ ⴾⵓⵏⵢ ⵓⵏ ⵙ ⵗⵛⴹⵗ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ⴹⵢ ⴹⵓⵢⵏ ⵙ ⴹⵓⵏⵏⴾⵜⵀⴰ ⵛⵔⵓⵜ ⴼⵍⵙ ⵓⵔ ⵔⵗ ⴾⵓⵏⵏⵙⴰ ⵜⵗⵛⴹⵎ ⵎⵏⵏ ⴾⵓⵏⵢ ⵓⵏ ⵙ ⵂⵔ ⴹⵜⵙⴼⵍⵓⵙⵎ⵰ ⴼⵍⵙ ⴾⵙⵗ ⵛⴾ ⵙ ⵔⵜ ⵓⴰ ⴹⵙⴼⵍⵓⵙⵏ ⴾⵓⵏⵢ ⴹⴰ ⵙⴼⵍⵓⵙⴾⵓⵏ ⴾⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ⵙ ⴹⵓⵏⵏⴾⵜⵀⵗ ⵛⵔⵓⵜ ⵜⴹⵢ ⵜⴶⴰ ⴼⵍⵢ ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⵙⵙⵢ ⵓⵍⵏ ⴼⵢⵏ ⴹⵗⵢ ⵎⵜⵓⵏ⵰ ⵎⵔⵏ ⵓⵔ ⴹⵓⵏ⵿ⵜⵜⵏⴾⵜⵀⵗ ⴼⵍ ⴹ ⵗⵛⴹⴰ ⵢ ⵎⵏⵓⵏ ⴾⵍⵔ ⴼⵍ ⴹ ⵜⵙⵏⵎ ⴹⵗ ⵜⵤⵓⵔ⵿ⵜ ⵏ⵿ⵜⵔⴰ ⵜⴰ ⴹⵓⵏⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ⵎⵔⵏ ⴾⴹ ⵢⵏ ⴹⵗⵓⵏ ⴹⵓⵢⵏ ⵗⵛⴹ ⵏⵎⵏ ⴹⵗ ⵏⵎⴹ ⵢⵏ ⵓⵔⴶⵗ ⵏⴾ ⵙ ⵗⵛⴹ ⵎⵏ ⴾⵍⵔ ⴾⵜⵏⵓⵏ ⵙ ⴹⵓⵏ⵿ⵜⵏⵗⵛⴹ ⵎⴹ ⵤⵏⴰ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏ⵿ⵜⵙⵙⴾⵢⵜ ⵗⵛⴹⵜⵏ ⵢⵔⵜ ⴹⵗⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ⵓⴹⵏ ⵓⴹⵢ ⴶⴹⵙ ⵙⵏⵔⵗⵎ ⵓⴰ ⴹⵙ⵿ⵜⴶⴰ ⵜⵛⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ⵎⵔⴹⴰ ⴼⴰ ⴹⵙ⵿ⵜⵙⵔⴼⵎ ⵜⵙⵙⵎⴹⵎ ⵓⵍⵏⵜ ⴼⵍ ⵜⵓⵔⵗⵍⵀ ⵗⵛⴹ ⵏⵎⵏ ⵂⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ⴹⵗ ⴹⵢ ⵏ⵿ⵙⵢⵆⵓⵏ ⵜⵜⵙⴾⵏⵎ ⵜⵔⴰ ⵜⴰ ⴹⵙ⵿ⵜⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ⴹ ⵢⵏ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⴹⵓⵏⵏⴾⵜⵀⴰ ⵛⵔⵓⵜ ⵜⴹⵢ ⵜⵔⴰ ⴶⵗ ⴾⵓⵏⵌⵔⵀⴰ ⵙⵏⵗ ⴾⴹ ⵜⵍⴾⵎⵎ ⵢⵔⵜ ⴾⵍ ⵓⴰ ⴹⵓⵏⵏⵗ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ⵎⵔⵏ ⵓⴹⵏ ⴾⵍ ⵓⵙ ⵜⵙⵔⴼⵎ ⵏⴾ ⴹⴰ ⵙⵔⴼⵗⵙ⵰ ⵔⵜ ⴹⵗ ⵓⴰ ⵙⵔⴼⴰ ⴹⵏ ⴾⴹ ⵏ⵿ⵜⴰ ⵍⵢ ⴼⴹⴰ ⵙⵔⴼⵗ ⵢⵓⴹⵏ ⴹⵙⵙⵔⴼⵗ ⵔⵜ ⴾⵍ ⵓⵙ ⴾⵍⴰ ⴹⵜⴶⴰ ⴼⵍ ⴹⵍⵍⵏⵓⵏ ⴹⵜ ⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ⴼⵍ ⴹ ⵓⵔ ⴶⵔⵓ ⵛⵢⵜⵏ ⵜⵔⵢⵜ ⵓⵍⵢⵜ ⵏ⵿ⴹⵏⵗⴾⵔⵙ ⴹ ⵓⵔ ⴹⵏⵗⴹⵔⴶⵏⵜ ⵜⵎⵔⴾⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ⵍⵓⵆ ⵓⴰ ⴹⵏⵙⵗ ⵗⵔⵎ ⵏ⵿ⵜⵔⵓⵙ ⵢⴹⵗⵙ ⵈⵜⵀⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ ⵔⵢ ⴹⵗⵙ ⵎⵍⵢ ⵜⵔⵢⵜ ⵏⴹⵢ ");
INSERT INTO ttqt_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ⵎⵛⵏ ⵂⵔⴾⴹ ⵓⵏ ⵓⵔ ⵜⵏ⵿ⵙⴰ ⵏⵢⵜⵏ ⴼⵍⵙ ⵓⵔ ⴹⵗⵙ ⴶⵔⵓⵗ ⵎⴹⵔⵢⵏⵏ ⵜⵜⵙ⵰ ⴹⵢ ⴼⵍ ⵏⵎⴶⴰ ⴹⵏⵍⴾⵎⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵓⵙ ⵛⵓⵜⵔⵓⵏ ⴶⵎⴹⵆⵏ ⵙⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ⵏⵜⴶⵓ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴹⵏⵗⵜⴶⵏ ⴼⵓ ⵢⴹⵏⵜ ⵙⴾⵏⵢ ⵜⴶⵓ ⵎⵏⴾⵍ ⴾⴼⵍⵏ ⴹⵗⴰ⵰ ⵔⵜ ⵓⵏ ⴶⵏⵆⵓ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆⵏⵏⴰ ⴹⵍⵎⵙⵈ ⵙⴾⵏⵏ ⴶⵔⵓⵏⵜ ⵜⵔⵏⴰ ⴼⵍ ⵀⵍⵙ⵰ ⵏ⵿ⵜⴰ ⴹⵗ ⵤⵓⵤⵓⵤⵏ ⵙ ⵜⵔⵢⵜⵏⵏⴰ ⴹⵗ ⴹⴶ ⴾⵍ ⴹⵓ ⵤⴹⵏ ⵓⴰ ⵜⵎⵙ ⵎⵙⵏⵜ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ⴹ ⴹⵓ ⵤⴹⵏ ⵏⵎⵙ ⵙ ⵎⵛⵏⴰ ⵙⵔⵙ ⵏⴶⵎⴹⵏ ⵍⵎⵙⵈ⵰ ⴹⵓ ⵓⴰ ⵓⵤⵓⵤ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵍⵗⵍⵙ ⴹⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵂⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ⵢⵜⴹⵏ ⵤⴰ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵂⵍⴾ ⵏⵎⵙⵙⵏ ⴹⵓ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴹⵜⵓⵢⵏ ⵙⵔⵙⵏ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵎⵙⵙⵏ ⴹⵓ ⵏ⵿ⵜⵎⴹⵔ⵿ⵜ ⵜⵏⵙⴹⵔⵏ⵰ ⵓⴾ ⵎⴰ ⴼⵔⴶⵏ ⴶⵢ ⵏⵛⵗⵍ ⴶⴹⵏ ⴹⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ⵏⴾⵏⵢ ⵓⵔ ⵏⵍⴰ ⴹⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵏⵏ ⵌⵍⴰ ⴹⵗ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⴾⵍⵔ ⴹⵗ ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵏⵎⵍ ⴹⵜ ⵎⵛⵏⴰ ⵓⵍⵏⵜ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵎⵔⵏ ⵏⵙⵏ ⵙ ⵎⵛⵏⴰ ⴹⵏⵤⵎⵤⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ⵓⴾ ⵎⵍⵏ ⵓⵢⴹ ⵏⵜⴶⵓ ⵎⵏⵏⴰ⵰ ⵎⵗ ⴾ ⴹⵔⵔⵜ ⵏⴶⴰ ⵙ ⵛⵔⴰ ⴹⵏⵗⵤⴾⴼⵏⵏ ⵗⵔⵓⵏ ⴹⵎ ⵎⴹⵗ ⵏⴹⵔⵔ ⵙⴹⵏⵜⵏⵜⴶⵎ ⵓⴰ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ⴾⵍⴰ ⴾⵍⵔ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵙ ⵜⵎⵙⵎ ⵛⵔⵓⵜⵏⵏⴰ ⵜⴾⵜⵀⵜ ⴹⵗ ⵓⵍⵏⵏⴰ ⵙⵏ ⵓⴹⵏ ⴾⵍ ⵗⵔⵜ ⴹⵗ ⵓⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ⵜⵙⴾⵏⵎ ⴹⵗ ⵜⵛⵜⵏⵓⵏ ⵛⵔⵓⵜ ⵏⵍⵎⵙⵈ ⵜⴾⵜⵀⵜ ⵙⵛⵗⵍⵏⵏⴰ ⵓⵔ ⵏⴾⵜⵀ ⵙ ⵜⴹⵓⵜ ⴾⵍⵔ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⴹⵢ ⴹⵔⵏ ⵙ ⵜⴾⵜⵀ⵰ ⵓⵔ ⵜⴾⵜⵀ ⴼⵍ ⵙⵍⵎ ⵏ⵿ⵜⵂⵏ⵿ⵜ ⴾⵍⵔ ⵓⵍⵏ ⴹⵗ ⵜⴾⵜⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ⵛⴹⵜ ⵏⵜⵎⴰ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⵏⵏⵗ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ⵓⵔⴶⵗ ⵛⴹⵜ ⵏⵙ ⵍⵢ ⵔⵜ ⵓⵍⵢⵏ ⵙ ⵏⴼⵔⴶ ⴶⵏⵜ ⴶⵔⵏⴰ ⴹⵎⵏⵏⴰ ⴾⵍⵔ ⵎⵛⵏⴰ ⴹⵏⵗⵂⴾⵏ ⴼⵔⴶⵜ ⵏⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ⵏ⵿ⵜⴰ ⴹⵗ ⴹⵏⵗⵙⴼⵔⴶⵏ ⴹ ⵏⵆⵍ ⵎⵛⵗⵍⵏ ⵏⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵜⵢⵏⵢⵜ ⵓⵔ ⵏⵎⵙ ⵍⵆⵏⵏ ⴾⵜⵀⵏ ⴼⵍ ⵙⵍⵎⵏ ⴾⵍⵔ ⵜⵙⵆ ⵎⵙ ⴾⵜⵀ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵓⵍⵏ ⵏⵢⵜⴹⵏ⵰ ⴼⵍⵙ ⵍⵆⵏⵏ ⵓⴰ ⵔⵓⵏ ⴾⵜⵀⵏ ⴼⵍ ⵙⵍⵎⵏ ⵜⵎⵜⵏ⵿ⵜ ⴹⵜⵓⵢ ⵙⵢⵜⴹⵏ ⵎⵔⵏ ⵜⵙⵆ ⵜⴰ ⴾⵜⵀ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵓⵍ ⵜⵎⴹⵔ⵿ⵜ ⵙⵔⵙⵏ ⴹⵜⵜⵓⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ⵏⵤⵎ ⵏⵍⵆⵏⵏ ⵎⵔⵏ ⵓⴰ ⴹⵜⵓⵢⵏ ⵜⵎⵜⵏ⵿ⵜ ⵙⵢⵜⴹⵏ ⵙⵍⵎⵏ ⵏ⵿ⵜⵂⵏ ⴼⵍ ⴾⵜⵀ⵰ ⵤⵤⵀⵜⴹⵓ ⵎⵛⵏⴰ ⴼⵍ ⵎⵙⴰ ⴹⵗ ⵏⵔ ⵙⵓⴰ ⴶⴰ ⴹⵗ ⵙⵂⵜ ⵏ⵿ⴹⵔ ⵢ ⴾⵍⵙⵔⵢⵍ ⴹ ⵙⵓⴹⵏ ⴹⵗ ⴹⵎⵏⵜ⵰ ⵏⵔⵏ ⴹⴰ ⵤⴰ ⵔⵜ ⵍⴾⵢⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ⵏ⵿ⴶⵎⵏ ⵤⴰ ⵏⵤⵎ ⵓⴰ ⴹⴼⵍⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴾⵜⵀⵏ ⴹⵗ ⵓⵍⵏ ⵏⵢⵜⴹⵏ ⵛⵆⵍ ⴹⵗⵙⵏ⵰ ⵎⵏⵎⴾ ⵙ ⵓⵔ ⵤⴶⵔ ⵓⵏ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ⴼⵍⵙ ⴾⴹ ⵏⵤⵎ ⵏⵍⵆⵏⵏ ⵓⴰ ⴹⵜⵓⵢⵏ ⵙⵢⵜⴹⵏ ⵜⴹⵀ ⵍⴰ ⵜⵏⵢⴰ ⵓⴹⵢ ⵎⴰ ⴹⵔ ⵤⴰ ⵜⴶⴹⵓ ⵛⴶⵔⵜ ⵏ⵿ⵜⵏⵢⴰ ⵜⴰ ⵜⵤⴶⵓ ⵏⵤⵎ ⵏ⵿ⵜⵔⵢⵜ ⵜⴰ ⵜⵢⵏⵢⵜ ⵓⴰ ⴹⵜⵓⵢⵏ ⵙⵢⵜⴹⵏ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ⵆⵍ ⵙ ⵔⵜ ⵓⵏⴹ ⴾⵏⵏ ⵜⵍⴰ ⵏ⵿ⵜⵏⵢⴰ ⵀⵙ ⵍⴰ ⵜⵏⵢⴰ ⵎⵔⴹⴰ ⴼⵍ ⵓⴰ ⴹⵙ⵿ⵜⴶⴰ ⵜⵔⵢⵜ ⵜⴰ ⵜⵢⵏⵢⵜ ⴹⵗ ⵛⴶⵔⵜ ⵏ⵿ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ⴼⵍⵙ ⴾⴹ ⵔⵜ ⵍⴾⵢⵏ ⵙⴹⵓ ⵙ ⵜⵏⵢⴰ ⴹⵢ ⵤⴰ ⵎⴰ ⴹⵔ ⵤⴰ ⵜⴶⴹⵓ ⵛⴶⵔⵜ ⵜⴰ ⵜⵤⴶⵓ ⵓⴰ ⵜⵍⵏ ⴼⵓ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ⴹⴹ ⵏⴶⴰ ⵜⵎⴰ ⴶⴹⵏ ⴹⵓⵏ ⵓⴹⵢ ⵏⵂⵍ ⴹ ⵏⵎⵤⵍ ⵓⴰ ⵏⵔⴰ ⵛⵢ ⵓⵍⴰ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ⵏⴾⵏⵢ ⵓⵔ ⵏⴶⴰ ⵓⴰ ⴶⴰ ⵏⵀⵢ ⵎⵙⴰ ⵙⵍⵙⵏ ⴹⵎⵏⵜ ⴼⵔ ⴼⵍ ⴹⵗⵙ ⵓⵔ ⵙⵓⴹⵏ ⴾⵍⵙⵔⵢⵍ ⴾⵜ ⴹⵢ ⴹ ⵜⴶⵎⴹ ⵏⵔ ⵓⴰ ⵎⵍⵓⵍⵓⵏ ⴹⵗ ⴹⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ⵎⵛⵏ ⵜⵓⵙⵗⵔⵏ ⵓⵍⵏⵙⵏ ⵢⵓⵏ ⴹ ⵂⵔ ⵤⵍⴹⴰ ⵙ ⵗⵔⵏ ⵍⴾⵜⵀⵏ ⵓⵏ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⵓⴰ ⵔⵓⵏ ⵛⵍⵜ ⵏⵙ ⵂⵔⵓⴹⴰ ⵍⵢ ⴶⴹⵍⵙⵏ ⴶⵔⵢ ⵏⵍⴾⵜⵀⵏ ⴹ ⴼⵔ ⵓⵏ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵙ ⴼⵔⴶⵏ ⴾⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ⵓⵍⴰ ⵂⵔ ⵤⵍⴹⴰ ⵗⵔⵏ ⵍⴾⵜⵀⵏ ⵏⵏⵀⵢ ⵎⵙⴰ ⵎⵛⵏ ⵓⵔ ⵜⵏⴶⵔⵏ ⴼⵍⵙ ⴼⵔ ⵓⵏ ⵍⵙⵏ ⵓⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ⵜⵜⵀⵜ ⵗⵙ ⵙⵎⵍⵢ ⵜⴾⵙⵏ ⴼⵔ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ⵎⵔⵏ ⵎⵍⵢ ⵏ⵿ⴼⵙ ⵎⵙ⵰ ⵓⴹⵏ ⴹⵗ ⵓⴰ ⴶⵤ ⵏ⵿ⴼⵙ ⵏⵎⵍⵢ ⵓⴹⵢ ⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ⵏⴾⵏⵢ ⴾⵜⵏⵏⴰ ⵓⵏ ⵙ ⵜⵓⴾⵙ ⴼⵔ ⵓⵏ ⴼⵍ ⴹⵎⵓⵏⵏⴰ ⵏⵙⵓⴹ ⴹⵗ ⵜⵏⵢⴰ ⵏⵎⵍⵢ ⵛⵍⵏ ⵏⵙ ⵙⵓⴹ ⵓⴹⵏ ⴹⵗ ⵛⵛⵜ⵰ ⵙⵎⵜⵢⵏⴰ ⵎⵍⵢ ⵙⵏ⵿ⵜⴰ ⵏ⵿ⴼⵙ ⵎⵙ ⵙⵛⵗⵍ ⵓⴰ ⵜⴶⵓ ⴹⵗ ⵓⵍⵏⵏⴰ ⵛⵛⵍⵏⴰ ⴹⵎⵏⵜ ⵜⵜⵜⵢ ⴹⵗⵏⴰ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ⴹⵢ ⴼⵍⵙ ⴹⴹ ⵤⵎⵙ ⵙ ⵂⵏⵜⵜⵏⴰ ⵎⵛⵏⴰ ⴶⵏⴰ ⴹⵗ ⵛⵗⵍ ⵏ⵿ⵜⵔⵢⵜ ⵜⴰ ⵜⵢⵏⵢⵜ ⵓⴹⵢ ⵓⵔ ⵤⴰ ⵏⵆⵍ ⴹⴼⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ⵏⴾⵏⵢ ⵏⵎⵤⵢ ⴹⵔⴾ ⵎⵤⵍⵏ ⵙⴾⵔⴾⴹⵏⵏ ⵓⵏ ⵜⵎⵤⵍⵏ ⵢⵜⴹⵏ ⴹⵗ ⵙⵔ ⵓⵔ ⵏⴶⵎⵢ ⴹⵜⴾⵔⵙ ⵏⵓⴹⵏ ⵓⵍⵢⵏ ⵓⵍⴰ ⵏⵙⴼⵔⵗ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ⴾⵍⵔ ⵎⵍ ⵓⴰ ⵏⵜⴶⵓ ⵜⴹⵜ ⵙ ⵜⵎⵓⵜ ⵜⵤⴹⵔⵜ ⵏⴶⵎⵢ ⵙⵔⵙ ⵙⴼⵍⵙ ⵏⵎⵏⵏⴰ ⵢⴾⵍⴾ ⵏⵓⴹⵏ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵏⵂⵍⴾ ⵗⵙ ⵙ ⵍⵙⴰ ⵔⵜ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⵏⵜⴶⵓ ⵓⵔ ⵜⵏⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ⵓⵔ ⵤⴶⵤⵏⵏ ⴼⵍⵙ ⵀⵍⵙ ⵓⵏ ⵎⵍⵢ ⵏⴹⵏⵜ ⵜⴰ ⵜⵏⵙⴹⵔⵗⵍⵏ⵰ ⴶⴹⵍⵙⵏ ⵏⵢ ⵏⵏⵔ ⵓⴰ ⴹⴶⵎⴹⵏ ⵍⵏ⵿ⵌⵍ ⵏⵔ ⵓⴰ ⵙⴾⵏⵏ ⵜⵏⵢⴰ ⵏⵍⵎⵙⵈ ⵎⵙⵏ ⵛⵛⵍⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ⵏⴾⵏⵢ ⵙⵍⵏ ⵓⵏ ⵏⵎⵍ ⵓⵔ ⴹⵗⵙⵏ ⵏⵎⵍ ⵎⵏⵏⴰ ⴾⵍⵔ ⵎⵍ ⵏⵜⴶⵓ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵎⵍⵢ ⵏⵎⵍ ⴹⵗ ⵙ ⴾⵍⵏⵓⵏ ⵏⵎⵙ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","ⴹ ⵎⵛⵏⴰ ⵏⵏ «ⵎⵍⵓⵍⵓⵜ ⵏⵔ ⴹⵗ ⵛⵢⵢ» ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵎⵍⵓⵍⵓⵏ ⴹⵗ ⵓⵍⵏⵏⴰ ⴾⴼⵏⵗ ⵏⵔ ⵜⵎⵙⵏ ⵎⵙⵏⵜ ⵏ⵿ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵜⴰ ⵜⵎⵍⵓⵍⵓⵜ ⴹⵗ ⴹⵎ ⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ⵎⵛⵏ ⵔⵤⵗ ⵓⴰ ⵎⵙⵏ ⵎⵙⵏⵜ ⵏ⵿ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⴾⵙⵏ ⵏ⵿ⵜⵍⵆ ⵙ ⵏⴾⵏⵢ ⵜⵏⵎⵙⵏ ⴹⵆⵓ ⵏⵓⵢ ⴼⵍ ⴹ ⵜⵓⵙⵏ ⵙ ⵜⵔⵏⴰ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵜⴰ ⵛⵏ ⵎⵛⵏⴰ ⵓⵔⴶⵗ ⵛⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵜⵓⵙⵙ ⵓⵔ ⵏⵜⵓⴶⴰ ⵎⵛⵏ ⵓⵔ ⴾⵍⴰ ⵏⵜⵓⵗⵍⵀ⵰ ⵆⵏⵏ ⵗⴼⵓⵏⵏⴰ ⵎⵛⵏ ⵓⵔ ⵏⵜⴾⵙ ⵜⵎⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ⴼⵓ ⵏⵜⵓⴹⴶⵤ ⵎⵛⵏ ⵓⵔ ⴹⵏⵗⵢⴰ ⵎⵛⵏⴰ ⴹⵎⵏⵏⴰ⵰ ⵏⵜⵓⴶⴹⵍⵓ ⵎⵛⵏ ⵏⵏⴾⵔⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ⴼⵓⴹⴰ ⵏⵂⴰ ⵜⵤⴾ ⵏⴶⵢ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵛⵍⵜ ⵏ⵿ⵜⴰ ⴶⴰ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⵜⵜⵓⵏⵢ ⵜⵎⴹⵔ⵿ⵜⵏⵜ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⵗ ⵜⵗⵙⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","ⴼⵍⵙ ⵏⴾⵏⵢ ⵓⵏ ⴹⵔⵏⵏ ⴼⵓ ⵏⵂⴰ ⵜⵤⴾ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍ ⴹ ⵜⵜⵓⵏⵢ ⵜⵎⴹⵔ⵿ⵜ ⵏ⵿ⵗⵢⵙⴰ ⵙⵍⵗ ⴹⵗ ⵜⵗⵙⵓⵏⵏⴰ ⵎⵙⵏⵏ ⵔⵜ ⵜⵎⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ⴹⵢ ⴼⵍ ⵏⵂⴰ ⴼⵓ ⵜⵤⴾ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⴹ ⵜⴶⵤⵎ ⴾⵓⵏⵢ ⵜⵔⵢⵜ ⵏⴶⵔⵓ ⵏ⵿ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ⵤⴶⵤⵏⵏⴰ ⵍⴰ ⴹⵓⴰ ⵜⵎⵍⵏ ⴹⵗ ⵍⴾⵜⵀⵏ ⵙ ⵏⵏ «ⵤⴶⵤⵏⵗ⵰ ⴹⵢ ⴼⵍ ⵛⵓⵍⵗ⵰» ⵏⴾⵏⵢ ⴹⴰ ⵤⴶⵤⵏ ⵓⵏ ⴹⴰ ⵏⴶⴰ ⴹⵢ ⴼⵍ ⵏⵛⵓⵍ ⵏⴾⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ⴹ ⵏⵙⵏ ⵙ ⵎⵛⵏⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵏⴹⵙⵏ⵿ⴾⵔ ⵏⴾⵏⵢ ⴹⴰ ⵏⴹⵓ ⴹⵗⵢⵙⴰ ⵜⵤⵔ ⵙⵀⴹⴹⵏⴰ ⴹⵜⵙ ⵏⴾⵏⵢ ⴹⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ⴼⵍⵙ ⵓⴰ ⴾⵜⵏⵜ ⵜⵏ⵿ⴼⵏⵓⵏ ⴼⵍ ⵜⵏⵜⴶⵓ ⴼⵍ ⴹⵏ⵿ⵜⵓⴹ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵜⵏ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴼⵍ ⵤⵤⵓⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ⴹⵢ ⴼⵍ ⵓⵔ ⵤⴰ ⵏⵆⵍ ⴹⴼⵔⵏⴰ⵰ ⴾⴹ ⵎⵙ ⵙ ⵛⵗⵙⵓⵏⵏⴰ ⵜⵏ ⵎⵏ⵿ⴹⵢ ⵂⵏⵜ ⴹⴰ ⵓⵍⵏⵏⴰ ⵏ⵿ⵜⵏⵢ ⴾ ⵤⵍ ⵜⵓⵛⵛⵢⵏⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ⴼⵍⵙ ⵜⵙⵙ⵿ⵜ ⴼⵙⵙⵜ ⵓⵔ ⵤⴰ ⵏⵂⴶ ⵜⴰ ⵏⵏⵢ ⵎⵔⴹⴰ ⴹⵏⵤⵜⴾⴼⵜ ⴹⴾⵍ ⴾⵏⵏ ⵜⵤⵓⵔ⵿ⵜ ⵗⵍⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ⵏⴾⵏⵢ ⵓⵔ ⵏⵙⵓⴹ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⵜⵓⵏⵢⵏⵏ ⴾⵍⵔ ⵓⵏ ⵂⵏⵏ ⵜⵏ⵿ⴾⵍ ⴹⵗ ⵏⵙⵓⴹ⵰ ⴼⵍⵙ ⵓⴰ ⵜⵓⵂⵏⵢⵏ ⵓⵔ ⵜⵂⴶ⵰ ⵙ ⴶⴰ ⵓⵏ ⵓⴰ ⵂⵏ ⵜⵏ⵿ⴾⵍ ⵏ⵿ⵜⴰ ⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ⵏⵙⵏ ⵙ ⵂⴾⵜⵏ ⵓⵏ ⵏⵂⴰ ⵎⵔⴹⴰ ⵍⵎⵗⵏⴰ ⵛⵗⵙⵓⵏⵏⴰ ⴹ ⵂⵍⴾⵏ ⵎⵔⵏ ⵙⵎⵜⴶⵏⴰ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ⵛⵗⵤⵎⵏ ⵗⵍⵍⵏⵏ ⵙⵏ⵿ⵜⴰ ⵎⵏⵜ ⵜⵏⵜⴾⵔⵙⵏ ⵓⵔⴶⵗ ⴼⵙⵏ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ⵎⵔⵏ ⵂⴾⵜⵏ ⵓⵏ ⵏⵂⴰ ⵎⵔⴹⴰ ⵙⵗⵏⵜ ⴼⵍⵏⵜ ⵜⵂⵏⴼⴰ ⵏⵙⴹⵔⵏ ⵓⵍⵏ ⴹ ⵏⴶⵓ ⵢ ⵏⵏⵏⴰ ⵓⵏ ⵌⵏⵓⵏ ⴶⵤ ⵜⴶ ⵓⴹⵏ ⵢ ⵙⵍⵙⴰ ⵢⵏⵢⵏⵏ ⴼⵍ ⵓⵢⴹ ⵓⵛⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ⵙ ⴶⴰ ⴹⵢ ⴹ ⵏⵙ⵿ⵜⵔ ⵓⵔ ⵤⴰ ⵏⵆⵍ ⵎⵏ ⵗⵙ ⵓⵔ ⵏⵂⴰ ⵜⵗⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ⵜⴹⵜ ⵙ ⵂⴾⵜⵏ ⵓⵏ ⵏⵂⴰ ⵎⵔⴹⴰ ⵎⵙⵏⵏⴰ ⵛⵍⵜ ⵏⵤⴾ ⵤⵓⵔⵏ ⴹⵏⵗⵙⵂⵏⴼⵏ ⴶⵙ ⵓⵔⴶⵗ ⴼⵍ ⵛⴹⵜ ⵏ⵿ⵜⵔⴰ ⵏⵎⵤⵢ ⴹⵔⵙⵏ ⴾⵍⵔ ⴼⵍ ⵛⴹⵜ ⵏ⵿ⵜⵔⴰ ⵏⴶⵤ ⵏ⵿ⵜⵗⵙⵓⵏⵏⴰ ⵛⵏ ⵌⵏⵓⵏ ⴼⵍ ⴹ ⵜⵍⵎⵤ ⵜⵗⵙⴰ ⵜⴰ ⵜⵗⵍⵍⵜ ⵜⴰ ⵓⵔ ⵏⵗⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ⵎⵔⵏ ⵎⵛⵏⴰ ⵎⵏⵜ ⴹⵏⵗⵙⵎⵜⴶⵏ ⵓⵏ ⵙⵜⴹⵏⵗ ⵙ ⵜⵂⴾⵢ ⵜⴰ ⴹⵏⵗⴶⴰ ⵏ⵿ⴼⵙⵏⵜ ⵙ ⴹ ⴶⵓ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ⴹⵗ ⴹⵢ ⴼⵓ ⵜⴾⵏⴰ ⵏⵢⵜⵏⵏⴰ ⴹ ⵏⵙⵏ ⵙ ⴾⵜ ⵜⵎⵙ ⵜⵗⵙⴰ ⵜⴰ ⵂⵏⵏⴰ ⵏⴶⴶ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ⴼⵍⵙ ⵓⴰ ⵏⵤⴶⵤⵏ ⵙ ⵏⵍⴾⵎ ⵓⵔⴶⵗ ⵓⴰ ⵏⵂⵏⵢ ⵙ ⵛⵜⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ⵓⵍⴰ ⴹⵢ ⴼⵍ ⵏⵗ ⵜⴾⵏⴰ ⵏⵢⵜⵏⵏⴰ ⵎⵛⵏ ⵏⵙⴼ ⵓⵍⵏ ⴹ ⵏⴶⵎⴹ ⵜⵗⵙⴰ ⵜⴰ ⵏⵂⴰ ⵎⵔⴹⴰ ⵙⵂⵏⵏⴰ ⵓⴰ ⵗⵔ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ⵓⵏ ⴹⴰ ⴼⵍⵙ ⴶⵔ ⵤⴰ ⵏⵂⴰ ⵜⵗⵙⵏⵏⴰ ⵓⵍⴰ ⴹⵗ ⵓⵔ ⵜⵜⵏⵂⴰ ⵓⵔ ⵏⴹⴶⵤ ⵔ ⴹⵗ ⴹⵙⵏⴶⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ⴼⵍⵙ ⴾⵏ⵿ⴹⵀⴰ ⵏⵀⴹⴹ ⴾⵜⵏⵏⴰ ⴹⵜ ⵍⵎⵙⵈ ⵛⵔⵗⵏⴰ⵰ ⴾⵢⵏ ⴹⵗⵏⴰ ⴹ ⴶⵔⵓ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⵍⵏ ⵓⵏ ⴶⴰ ⵂⵔⵓⴰ ⵂⴰ ⵜⵗⵙⵏⵜ ⴶⵔ ⵤⴰ ⵓⵏ ⵍⵗⵏⵏ ⵓⵍⴰ ⵓⵏ ⵓⵔ ⵏⵍⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ⴹⵗ ⴹⵢ ⴹⴹ ⵤⵎⵙ ⵏⵙⵏ ⵓⴰ ⵜⵎⵙ ⵜⴾⵙⴹⴰ ⵏⵎⵍⵢ ⵏⴶⵎⵢ ⴹⵗ ⵢⵜⴹⵏ ⵙⵔⵙ ⵤⴶⵤⵏⵏ ⵙ ⴶⵍⵢⵜ⵰ ⵎⵛⵏⴰ ⵙⵏ ⵓⵍⵏ ⵓⴰ ⵏⵎⵙ ⵎⵔⵏ ⴶⵗ ⵜⵎⴰ ⵏⵙ ⴾⵓⵏⵢ ⴹⴰ ⵜⵙⵏⵎ ⵓⵍⵏ ⴹⵗ ⵓⵍⵏⵓⵏ ⵓⴰ ⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ⵓⵔⴶⵗ ⵜⵎⵍ ⵏⵍⵙ ⵎⵏⵏⴰ ⵗⵔⵓⵏ ⴾⵍⵔ ⴹⵍⵍ ⵗⵙ ⴾⵓⵏⵂⴾⵓ ⵏⴶⵢ ⵏⵀⵔⴶⵏ ⴼⵍⵏⴰ ⴼⵍ ⴹ ⵜⵍⵎ ⵜⵏⵎ ⵢⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵀⵔⴶⵏ ⴼⵍ ⵓⴰ ⵓⵔⵏ ⵤⵂⵔ ⵎⵙ ⵙⴾⵏⵢ ⵓⵔⴶⵗ ⵜⵍⴰ ⵏⵓⵍ ⵤⴹⴶⵏ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ⴾⴹ ⵜⵓⵏⵏ ⵜⵢⵜⵢⵏⵏⴰ ⴹⵏⵜⴶⵎⴹⵜ ⵓⴹⵢ ⵙⵗⵎⵔ ⵏⵎⵛⵏⴰ ⴼⵍ ⵏⴶⴰ ⴹⵢ⵰ ⴾⴹ ⴹⵗ ⵓⵔ ⴹⵏⵜⴶⵎⴹ ⵓⴹⵢ ⵜⵏ⵿ⴼⵏⵓⵏ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ⴼⵍⵙ ⵜⵔⴰ ⵜⴰ ⴹⵏⵗⴶⴰ ⵍⵎⵙⵈ ⵜⵏⴹⵜ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵏⵜⴶⵓ⵰ ⴹ ⵏⵤⴶⵤⵏ ⵙ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵍⵎⵙⵈ ⵎⵜⵏ ⴹⵗ ⴹⴶ ⵏⵢⵜⴹⵏ ⴾⵍ⵰ ⴹⵗ ⴹⵢ ⵢⵜⴹⵏ ⴾⵍ ⴹⵓⵏ ⴹⵔⵙ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ⵀⵜⵓ ⴹⵗ ⴹⴶ ⵏⵓⴹⵏ ⴾⵍ ⴶⵔⵓⵏ ⵢⵜⴹⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⵙⵙⵀⵀⵏⵜ⵰ ⴶⴰ ⵓⵏ ⴼⵍ ⴹ ⵎⵤⵢⵏ ⴹⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵓⵔ ⵍⴾⵎⵏ ⵔ ⵢ ⵜⵔⴰ ⵏⵎⵏⵙⵏ⵰ ⴾⵍⵔ ⴹ ⵍⴾⵎⵏ ⵢⵍⵎⵙⵈ ⵎⵜⵏ ⴼⵍ ⴹⵍⵍⵏⵙⵏ ⵜⵓⵙⵏ⵿ⴾⵔⴹⵓ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ⴹⵢ ⴼⵍⵙ ⵎⵔⴹⴰ ⵀⵙ ⵏⴶⴰ ⴹⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⴼ ⵓⴰ ⴹⵗⵙ ⴶⵏ ⵢⵜⴹⵏ⵰ ⴾⴹⵗ ⵙ ⴾⵍⴰ ⴹ ⵏⵜⴼ ⵍⵎⵙⵈ ⴹⵗ ⴹⴶ ⵓⴰ ⴹⵗ ⵜⵜⴼⵏ ⵢⵜⴹⵏ ⵎⵛⵏ ⵎⵔⴹⴰ ⵓⵔ ⵜⵏⵜⴼ ⴹⵗ ⴹⴶ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ⴹⵗ ⴹⵢ ⵓⴹⵏ ⵓⴰ ⵍⵏ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵆⵍ ⵜⵈⵍⴾ ⵜⵢⵏⵢⵜ⵰ ⵀⵙ ⵎⵙ ⵓⴹⵏ ⵓⵙ ⴾⵍⴰ ⵜⵎⵙ ⴼⵍⵙ ⵜⵎⴹⵔ⵿ⵜ ⵜⵙ ⴾⵍⴰ ⵜⵜⴶⴰ ⵗⵔⴹ ⴹⵔⵙ⵰ ⵜⴶⵤ ⵢⵜ ⵜⵢⵏⵢⵜ ⴹⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ⵎⵔⵏ ⵓⵏ ⴾⵍ ⵎⵛⵏⴰ ⵜⴶⵏ ⵏ⵿ⵜⴰ ⴹⵏⵗⴾⵏⵏ ⴹⵎⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⴾⴼⵏⴰ ⴹⵗ ⵏⴾⵏⵢ ⵛⵗⵍ ⵎⵙⵏ ⴶⵢ ⵏⵍⵈⵔ ");
INSERT INTO ttqt_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ⵎⵙⵏ ⵙ ⵎⵛⵏⴰ ⵓⵢⴹⵓ ⵍⵈⵔ ⴶⵔⵙ ⴹⴹⵏⵜ ⴾⵜⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵀⵙ ⴼⵍⵙⵏ ⵜⴼ ⵀⴾⴹⵏⵙⵏ⵰ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴹⴰ ⵙⵍⵏ ⵏⴶⵢ ⵏⵍⵈⵔ ⵓⵏ ⵙ ⴹⵏⵗⵏⴰ ⵜⵏⴶⵓ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ⴹⵗ ⴹⵢ ⵏⴾⵏⵢ ⵍⵎⵓⴾⵍⵏ ⵏⵍⵎⵙⵈ ⵏⵎⵙ ⴹ ⵎⵛⵏⴰ ⵎⵏⵜ ⵙ ⴾⵓⵏⵗⵔⵓ ⵙ ⵜⵔⵢⵜⵏⵏⴰ⵰ ⵏⵏ⵿ⵙⵢⴾⵓⵏ ⴼⵍ ⴹⵎ ⵏⵍⵎⵙⵈ ⴹ ⵜⴾⵏⵎ ⴹⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ⵍⵎⵙⵈ ⵓⵔ ⵜⵓⵔ ⵀⴾⴹ ⵓⵍⵢⵏ ⵎⵛⵏ ⵙⵓⵔ⵿ⵜⵓ ⵎⵛⵏⴰ ⴼⵍ ⴹⵍⵍⵏⵏⴰ ⵀⴾⴹⵏⵏⴰ ⴼⵍ ⵙⵔⵏⴰ ⴹⵜⵓⵢ ⵜⵙⵆⵏⵏⴰ ⴹⵔⵙ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ⴹⵗ ⴹⵢ ⴹⴹ ⵎⵙ ⵙ ⵏⵂⴰ ⵛⵗⵍ ⵓⴰ ⴹⵗ ⵂⴰ ⵎⵛⵏⴰ ⵏⴶⵎⵢ ⴹⵗⵓⵏ ⴹ ⵓⵔ ⵜⵙⵀⵏⵏⵎ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵜⴰ ⵜⴶⵔⵓⵎ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ⴹ ⵎⵛⵏⴰ ⵎⵏⵜ ⵙ ⵏⴰ «ⵙ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⴾⵓⵏ⵿ⵤⴾⴼⴰ ⵔⵈⵎⵜⵏ ⴹ ⵆⵀⵍⴰ ⵛⵓⵜⵔⵓⵏⵓⵏ ⵙ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⴾⵓⵏ⵿ⵤⵗⵍⵙⵗ ⴹⵓⵏⵍⵍⵗ⵰» ⵏⵢⵜ ⵤⴰ ⵍⵓⵆ ⵓⴹⵢ ⵓⴹⵓ ⵏ⵿ⵜⴰ ⴹⴰ ⴹⴰ ⴹⵗ ⵤⵍ ⵓⵏ ⵍⵗⵍⵙⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ⵓⵔ ⵏⵜⴶⵓ ⵔⵜ ⵓⵍⵢⵏ ⵙ ⵤⵆⵍⵏ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⴼⵍ ⴹ ⵓⵔ ⵜⵓⵏⵢ ⵍⵂⵏ ⵓⵍⵢⵏ ⴹⵗ ⵛⵗⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ⴾⵍⵔ ⵔⵜ ⴾⵍ ⵓⴰ ⵏⵜⴶⵓ ⵏⵙⴾⵏⵓ ⴹⵗⵙ ⵙ ⵎⵛⵗⵍⵏ ⵏⵎⵛⵏⴰ ⴹⵗ ⵏⵎⵙ ⵙ ⵤⵎⵔⵜ ⵜⴶⵜ ⵜⴰ ⵏⴶⴰ ⵢ ⵜⵙⵙ⵿ⵜ ⴹⵛⵓⵛⴰ ⴹⵜⵎⵗⵜⵔ ");
INSERT INTO ttqt_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ⴹⵜⵓⵜ ⴹⴾⵙⵓ⵰ ⵏⵤⵎⵔ ⴹⵗ ⴹⵗ ⵍⵗⵤⵀ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵜⵏⵌⵔⵓⵢⵏ ⵛⵏ ⴼⵍⵏⴰ ⴶⵏⵏ ⴹⵛⵗⵍ ⵍⵀⵙⵏ ⵓⴰ ⵏⵜⴶⵓ ⴹⵀⴰ ⵏⴶⵔⵓ ⵙⵜⵙ ⴹⴶⵍⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ⵏⵙⴾⵏⵓ ⵜⵛⵜⵏⵏⴰ ⵎⵛⵗⵍⵏ ⵏⵎⵛⵏⴰ ⵙ ⵎⵏ ⵤⴹⴶⵏⵏ ⴹⵎⵙⵏⵜ ⵜⴰ ⵏⴶⵔⵓ ⴹⵜⵤⵢⴹⵔ⵿ⵜ ⵜⴰ ⴹⵏⵜⵂⵜ ⴹⵎⵏ ⵎⵍⵍⵏⵏ⵰ ⵏⵙⴾⵏⵜ ⴹⵗ ⵙ ⵜⴹⵂⵍ⵿ⵜ ⵜⴰ ⴹⵏⵗⴶⴰ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵜⵔⴰ ⵜⴶⵜ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵜⴰ ⴹⵏⵜⵂⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ⵏⵙⴾⵏⵓ ⵜⵛⵜⵏⵏⴰ ⵎⵛⵗⵍⵏ ⵏⵎⵛⵏⴰ ⵙⵓⵍ ⵎⵙⵏ ⵜⴹⵜ ⵓⴰ ⵏⵎⵍ ⴹⴼⵔⴶⵜ ⵜⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ⵰ ⵏⵙⴾⵏⵓ ⵜⵛⵜⵏⵏⴰ ⵎⵛⵗⵍⵏ ⵏⵎⵛⵏⴰ ⵙ ⵜⵤⵍⵢ ⵏⵎⴶⵔ ⵜⵏ ⵜⵆⵜ ⵜⵙ ⵤⴰ ⵏⵎⴶⵔ ⵏⴶⵤ ⵎⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ⴶⵔ ⵤⴰ ⵏⵜⵓⵙⵗⵎⵔ ⵓⵍⴰ ⵏⵜⵓⵍⴾⴰ⵰ ⴶⵔ ⵤⴰ ⵏⵜⵓⵔⵀⴹ ⵓⵍⴰ ⵏⵜⵜⵎⵍ ⵏⴾⵏⵢ ⵜⴹⵜ ⵏⵎⵍ ⴾⴹⵗ ⵙ ⵜⵓⵜⴼ ⵙ ⵙⵈⵔⴾ ⵏⵜⴶ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ⵏⵜⵓⵤⴹⵢ ⵓⵍⵏ ⵎⵛⵏ ⵛⵍⵜ ⵏⵙ ⵓⵔ ⵏⵜⵓⵤⴹⵢ⵰ ⵏⵛⴶⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵎⵛⵏ ⵂⵔⵓⴹⴰ ⵏⴹⵔ⵰ ⵏⵜⵓⴹⵀ ⵎⵛⵏ ⵓⵔ ⵏⵜⵓⵏ⵿ⵗⵓ ⴾⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ⵗⵛⴹⵏ ⵎⵏⵏⴰ ⵎⵛⵏ ⵓⵔ ⴹⵏⵗⴶⴹⵍ ⵓⵏ ⵙ ⴼⵓ ⵏⴼⵍⵓⵙ⵰ ⵓⵔ ⵏⵍⴰ ⵓⵍⴰ ⵎⵛⵏ ⵏⵙⴶⵔⴶⵙ ⵢⵜⴹⵏ ⴶⵜⵏⵏ⵰ ⵓⵔ ⵏⵍⴰ ⵓⵍⴰ ⵏ⵿ⵜⴰ ⵔⵜ ⴾⵍ ⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ⵢⴰ ⵛⵆⵗⵏⵏⴰ ⵓⵏ ⴾⵍⴾⵔⵏ⵿ⵜ ⵓⴰ ⵂⵏ ⵎⵏⵏⴰ ⴹⵓⵏ⵿ⵜⵏⵎⵍ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵎⵔⵏ ⵏⵍⵎⵓⵏ ⵓⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ⵏⴾⵏⵢ ⵓⵔ ⴹⵓⵏⵈⴼⵍ ⵓⵍⵏⵏⴰ ⴾⵓⵏⵢ ⵎⵔⵏ ⵜⵈⴼⵍⵎⵏⴰ ⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ⴹⵓⵏⵏⴰ ⵓⴰ ⵤⵏⵗ ⵢ ⵀⵔⵔⵏⵏ ⵍⵎⵜⵏⴰ ⵓⵍⵏⵓⵏ ⵤⵏ ⵓⴰ ⴹⵓⵏⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ⴹ ⵓⵔ ⵜⵜⵙⵗⵎ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ⵎⵏⵎⴾ ⵙ ⵤⵙⵗ ⵍⵗ ⴹⵛⵔ ⵓⵍⴰ ⵙⵗ ⵏⵔ ⴹⵛⵢⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ⵎⴰ ⵎⵙ ⵔⵜ ⵓⴰ ⴼⵍ ⵤⵏⵎⵏⴾ ⵍⵎⵙⵈ ⴹⵀⵍⵙ⵰ ⵎⴰ ⴹⵔⵓ ⵓⴹⵏ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ ⴹⵢⵏ ⵙⵔⵙ ⵓⵔ ⵏⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ⵂⵏ ⵏⵍⵗⵀⴹⴰ ⵏⵎⵛⵏⴰ ⴹⵗ ⵎⴰ ⵜⵎⵙ ⵜⵔⴹⵓⵜ ⵜⴰ ⵤⴶⵓ ⴹⵙⵏⵎⵏ⵰ ⴼⵍⵙ ⵏⴾⵏⵢ ⵎⵙⵏⵏ ⵂⵏ ⵏⵎⵛⵏⴰ ⴹⵢ ⴹⵔⵏ ⴹ ⵎⵛⵏⴰ ⵏⵏ «ⴹ ⵈⵙⵔⴰ ⴹⵗ ⵢⵜⴹⵏⵏ ⴹⵓⴰ ⴹⵔⵙⵏ⵰ ⵆⵍⵗ ⵎⵍⵏⵙⵏ ⵏ⵿ⵜⵏⵢ ⴹⵗ ⵆⵍⵏ ⵜⵎⵜⵢⵏⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ⵓⵏ ⴹⵗ ⴼⵍ ⵏⴰ ⵎⵍⵢ «ⴶⵎⴹⵜⴹⵓ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⴶⵤⵏ ⵜⵎⵤⵢⵎ ⴹⵔⵙⵏ ⴹ ⵓⵔ ⵜⴹⵙⵎ ⵎⴹⵙⵏ ⴹⵢ ⴾⵓⵏⵆⵀⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ⴹⵓⵏⵆⵍⵗ ⵀⴰ ⵜⵆⵍⵎ ⵀⵔⵔⵏⵏ ⴹⵜⵀⵔⵔⵏⵏ ⴹⵢ ⵏⴰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⵍⵢ ⵏ⵿ⵜⵔⵏⴰ ⴾⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ⴹⵗ ⴹⵢ ⵎⵔⵏⵏ ⴹⴹ ⵤⵎⵙ ⵜⵓⴶⵏⵏⴰ ⵔⴾⵓⵍⵏ ⵓⵏ ⵤⵤⴹⴶⵜⵏⴰ ⵎⵏⵏⴰ ⴹⵗ ⵔⵜ ⴾⵍ ⵓⴰ ⵙⵎⴹⵙⵏ ⵜⵗⵙⴰ ⴹⵏⵢⵜ⵰ ⵏⴶⵜ ⵜⵤⴹⴾ ⵜⴾⵎⵍⵜ ⴶⴰ ⵓⵏ ⵙ ⵜⴾⵙⴹⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ⵍⵎⵜⵏⴰ ⵓⵍⵏⵓⵏ ⵏⴾⵏⵢ ⵓⵔ ⴾⵍⴰ ⴹ ⵏⴶⴰ ⵜⴾⵎⴰ ⵢⵓⴹⵏ ⵓⵍⵢⵏ ⵓⵍⴰ ⵏⵗⵛⴹⵙ ⵔⵜ ⵓⵍⴰ ⴹⵗ ⵏⵜⵛⴰ ⵍⵈⵆⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ⵓⵔ ⵏⵗ ⴹⵢ ⴼⵍ ⴾⵓⵏⵙⵓⵔⴰ ⵍⵂⵏ ⵓⵍⵢⵏ ⴼⵍⵙ ⵎⵍⵗⵓⵏ ⴹⵜ ⴹⵢ ⵙ ⵏⵙⵏⵂⵍⴾⵓⵏ ⵜⵔⴰ⵰ ⵜⵎⴹⵔ⵿ⵜ ⵓⵍⴰ ⵜⵎⵜⵏ⵿ⵜ ⵓⵔ ⵤⴰ ⵜⴾⵙ ⵜⵔⴰ ⵜⴹⵢ ⴹⵗ ⵓⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ⵓⵔ ⴹⵗⵓⵏ ⴶⵗ ⵛⴾ ⵓⵍⵢⵏ⵰ ⵜⴶⴰ ⵀⵔⴶ ⴹⵗ ⵀⵜⵏⵓⵏ⵰ ⴹⵗ ⵜⵙⵙ⵿ⵜ ⴾⵍ ⵜⴰ ⵏⵏⵢ ⵜⴾⵏⴰ ⵜⵍⵗⵏⵓⵏ ⵜⵙⵙⵎⵜ ⵏⵓⵍⵏ ⵎⵔⵏ ⵜⴼⵍⵓⵙ⵿ⵜⵏ ⵓⵔ ⵜⵍⴰ ⴹⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ⵙ ⴹⵏⵙⴰ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⵓⵔ ⴾⵍⴰ ⴹ ⵏⴶⵔⵓ ⵙ ⵜⵙⵏ⵿ⴼⵓⵜ ⴾⵍⵔ ⵏⵀⴹⴹ ⴹⵗ ⵜⵎⵗⵜⵔ ⵍⵀⵙⵏⵏ ⵙ ⵓⵔ ⵜⵍⴰ ⴹⵗ ⵓⵔ ⴶⵏⵜ⵰ ⵜⴶⵏⵜ ⵜⵎⵤⵗⵏ ⴹⴶⵎⵏⵏⴰ ⵎⵔⵏ ⵜⵂⵏⴰ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ⵎⵛⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵏⵙⵙⵎⴹ ⵏⵎⵏ ⵏⵢ ⵙⵗⵛⴹⵏ ⵎⵏⵜ ⵙⵙⵎⴹ ⵎⵏⵏⴰ ⵙⵙⴰ ⵓⴰ ⴹⵏⴹⴶⴰ ⵜⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ⵓⵔⴶⵗ ⵙⵏⵜ ⵗⵙ ⴹⵏⵗⵍⵎⵏ ⴼⵍ ⵎⵏ⵰ ⴾⵍⵔ ⴾⵏⵢ ⵓⴰ ⴹⵙ⵿ⵜⴶⵎ ⵎⵏ ⴹⵙ ⵎⵍⵏⴰ ⵙⵏⵂⵍ ⵓⴰ ⵜⴶⵎ ⵜⵔⴰ ⵏ⵿ⴹⵜⵏⵢⵎ ⴹⵜⵎⴶⵔⵤⵜ ⵜⴰ ⵜⴶⵎ ⴹⴹⴶⵤ ⵓⴰ ⵜⴶⵎ ⴹⵗ ⵓⵔ ⵏⴶⵏⵏⵏ⵰ ⴹⵢ ⴾⵏⵏ ⵙⴼⵍⵓⵙ ⵏⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ⵀⵙ ⵎⴶⵔⵤⴰ ⵛⵔⵓⵜ ⵜⴰ ⴹⵓⵏⵏⴾⵜⵀⴰ ⴾⴹⵗ ⵙ ⴹⵙⵢ ⵙ ⵎⴶⵔⵤⵗ ⴾⵜⵀ ⵓⴰ ⴹⵓⵏ⵿ⵜⵜⵏⴶⵗ ⴼⵍⵙ ⵙⵏⵗ ⵙ ⵜⵗⵛⴹ ⵎⵏⵓⵏ ⵎⵛⵏ ⵢⴰ ⵗⵛⴹ ⴹⵢ ⵓⵔ ⵂⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ⴼⴹⴰ ⵎⵔⴹⴰ ⵙⴹⵓⵜⵢ ⵙ ⴹⵓⵏ⵿ⵜⵜⵏⴾⵜⵀⵗ ⵓⵔⴶⵗ ⴼⵍⵙ ⵜⵗⵛⴹ ⵎⵏⵓⵏ ⴾⵍⵔ ⴼⵍⵙ ⵗⵛⴹ ⵓⴰ ⴶⵏ ⵎⵏⵓⵏ ⴹⵢ ⵓⵢⴹⵓ ⵙⵔⵓⵏ ⵜⵜⵀⵜ ⴹⵗ ⵀⴾⴹⵏⵓⵏ⵰ ⵤⵏⴼ ⵏⵗⵛⴹ ⵏⵎⵏ ⵓⴹⵢ ⴹⵗ ⵔⴰ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏⵜ ⴹⵗ ⴹⵢ ⵓⵔ ⴹⵓⵏⵗⵛⴹ ⵔⵜ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ⴼⵍⵙ ⵎⵛⵏⴰ ⴼⵔⴶ ⵙⵔⵏⴰ ⴹⵓⵢ ⵗⵛⴹ ⵏⵎⵏ ⴼⵍ ⴹ ⵏⵜⵀ ⴹⵗ ⵀⴾⴹⵏⵏⴰ ⵓⵢⴹⵓ ⵙⵔⵏⴰ ⵍⵗⵍⵙ⵰ ⵓⵔ ⴹⵏⵗⵍⴾⵎ ⴹ ⵏⵎⴶⵔⵤ ⵤⵏⴼ ⵏⵗⵛⴹ ⵏⵎⵏ ⵓⴹⵢ⵰ ⵗⵛⴹ ⵏⵎⵏ ⵎⵔⵏ ⵓⴰ ⵙⵔⵏⴰ ⴹⵜⵓⵢ ⴹⵏⵜ ⵓⵔ ⴹⵜⵓⵢ ⵜⵜⵀⵜ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵜ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ⵏⵢⵜ ⴾⵜ ⵏⵙⵀⴹⴹ ⵓⴰ ⴾⵓⵏⴶⴰ ⵗⵛⴹ ⵏⵎⵏ ⵓⴰ ⵔⴰ ⵎⵛⵏⴰ⵰ ⵙⵀⴹⴹ ⵓⵏ ⵏ⵿ⵜⴰ ⴹⵓⵢⵏ ⴶⵍⵢⵜ ⵜⴰ ⵜⴶⵎ ⴹⴶⵤ ⵓⴰ ⵜⴶⵎ ⵎⵏⵓⵏ ⴹⵍⵂⵎ ⵓⴰ ⴹⵗⵓⵏ ⴶⴰ ⴹⵜⵙⴰ ⵜⴰ ⵙⵔⵓⵏ ⴹⵓⵢ ⴹⵙⴹⵔⵏ ⵓⴰ ⵜⴶⵎ ⵏⵢⵏⵏ ⴹⴹⴶⵤ ⵓⴰ ⵜⴶⵎ ⴹⵗ ⵎⵤⵍ ⵏⵓⴰ ⵍⵗⵏ ⴹⴶⵢ ⵓⴰ ⵙⵔⵓⵏ ⴹⴶⴰ ⵜⵔⴰ ⵏⴹ ⵓⴹⵀⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵜⴾⵎⴰ⵰ ⵜⵙⴾⵏⵎ ⴹⵗ ⵏⵎⴹ ⴾⵍ ⵙ ⵓⵔ ⵜⵍⵎ ⵍⵂⵏ ⵓⵍⵢⵏ ⴹⵗ ⵜⵍⵗⴰ ⵜⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ⴹⵗ ⴹⵢ ⵛⵔⵓⵜ ⵜⴰ ⴹⵓⵏⵏⴾⵜⵀⵗ ⴹⵢ ⵓⵔ ⵜⵜⵏⴾⵜⵀⴰ ⴼⵍ ⴹⵍⵍ ⵏⵓⴹⵏ ⵓⴰ ⴶⵏ ⵔⴾ ⵎⵤⵍ ⵓⵍⴰ ⵓⵙ ⵜⵓⴶⴰ⵰ ⴾⵍⵔ ⴾⵜⵀⵗⵓⵏ⵿ⵜⵜⵏ ⴼⵍ ⴹ ⵜⵜⵓⵙⴾⵏⵓ ⴶⵍⵢⵜ ⵜⴰ ⵜⴶⵎ ⴹⵗ ⵀⵜⵏⵏⴰ ⴹⵜ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ⴾⵏⴰ ⴹⵢ ⵎⵏⵏⴰ⵰ ⵎⵔⵏ ⴾⵏⵢ ⵓⴰ ⴶⵏ ⵎⵏⵏⴰ ⴹⵏ ⵓⵔ⵿ⵜⵓ ⵙ ⵙⴹⵓⵜⵏⴰ ⵓⵍⵏ ⵏⵢ ⵓⴰ ⵏⴶⴰ ⵜⵜⵙ ⴾⵏⴰ ⵜⴼⵍⵓⵙ⵿ⵜ ⴼⵍⵙ ⴾⵜⵏⵓⵏ ⵙ ⴹⵙ⵿ⵜⴾⵏⵎ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ⴶⵗⵙ ⵀⵔⴶ ⴼⵍⵓⵏ ⵜⵆⵎⵎ ⵓⵔ ⴹⵜⵤⵀⵤⵎ ⵜⴾⵔⴾⵜ⵰ ⵎⵔⵏ ⵓⵔ ⴾⵍⴰ ⴹⵓⵏⵏⴰ ⵔⵜ ⵓⵔ ⵏⵎⵙ ⵜⴹⵜ ⵀⵔⴶ ⴹⵗ ⵓⴰ ⵏⴶⴰ ⵢ ⵜⵜⵙ ⵏ⵿ⵜⴰ ⴹⴰ ⵆⵍ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ⴾⵏⵓⵏ ⵜⵔⴰ ⵓⵍⵏ ⵙ ⴹⴾⵜⴰ ⵀⵔⴹⴶ ⵓⴰ ⵜⴶⵎ ⴾⵜⵏⵓⵏ ⵢⴶⵢ ⵏⵓⴰ ⵏⴰ ⴹⵙⵗⵎⵔ ⴶⵏ ⵓⴰ ⵜⵜⵙⴾⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ⴾⵜ ⵜⴼⵍⵓⵙ⵿ⵜ ⴶⵆⵜ ⴼⵍⵙ ⴼⵔⴶⵗ ⴼⵍⵓⵏ ⵙⴼⵍⴰ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ⵎⴹⵔⵢⵏⵏ ⵏⵔⴰ ⴹⵓⵏⴶⵓ ⵙⵍⵏ ⵏⵔⵈⵎⵜ ⵜⴰ ⴶⴰ ⵎⵛⵏⴰ ⵢⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵂⵏⵏ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ⵜⵙⵙ⵿ⵜ ⵍⵀⵙⵜ ⵜⴰ ⵜⵏⵜⴶⵔⵓⵜ ⴹⵍⵆⵓ ⵍⵀⵙⵏ ⵓⴰ ⵜⵏⵜⴹⴶⵤⵏ ⵓⵔ ⴹⵙⵏⵜⴶⴹⵍ ⴶⵢ ⵏ⵿ⵜⴼⵍⵓⵙ⵿ⵜ ⵙⵓⴰ ⵜⴶⴰ ⴹⵗ ⵜⵤⵓⵔ⵿ⵜ ⵜⵓⵢⴹⵓ ⵙⵔⵙⵏⵜ ⴶⵢ ⵏ⵿ⵜⵂⴾ ⵏⵍⵍⵓ ⴾⵏⵏ ⵜⵤⵓⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ⴼⵍⵙ ⵙⵍⴾⵏⵗⵓⵏ ⵙ ⵔⵜ ⵓⴰ ⴼⵔⴶⵏⵜ ⵔⴶⵏⵜ ⴼⴹⴰ ⵓⴰ ⴾⴼⵏⵜ ⴶⵔ ⵓⴰ ⵍⵏⵜ ⵎⵔⵏ ⴶⵏⵜ ⵓⵏ ⴶⵔⵙⵏⵜ ⴹⵎⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ⴼⴹⴰ ⵎⵏ⵿ⵙⵢ ⴹⵗ ⴹⴶⵤⵏⵜ ⴹⵏⵗⴶⵏⵜ ⵜⵏⵜⵏⵢⵓ ⴶⵔⵓⵏⵜ ⵔⵈⵎⵜ ⵏⴹ ⴹⵂⵍⵏⵜ ⵎⵤⴹⴶⵏ ⵓⵏ ⵗⵔⵎ ⵏⵢⵔⵙⵍⵎ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ⵔⵜ ⵓⴰ ⴶⵏⵜ ⴶⵔ ⵓⵙ ⵏⴶⴰ ⵜⵎⵏⵜ ⴹ ⵜⵎⵙⵏ ⵙ ⵤⵔⵏⵜ ⵜⵂⴾⵢ ⵏⵎⵏⵙⵏⵜ ⵢⵎⵍⵢ ⴹⴼⵔ ⴹⵢ ⴾⴼⵏⵜⵏⵗ ⵎⵏⵙⵏⵜ ⵎⵙ ⵓⵏ ⵔⵜ ⵔⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ⴹⵢ ⴼⵍ ⵏⴹⴶⵤ ⵜⵜⵙ ⵙⵏ⵿ⵜⴰ ⴹⵗⵓⵏ ⴹⴶⵏ ⵙ⵿ⵜⵤⵔⵜ ⴹ ⵜⴶⵎ ⵛⵔⴶⵜⵏ ⴹⵓⵏⵍⵍ ⵙⴹ ⵜⵙⵏ⵿ⴹⵎ ⵛⵗⵍ ⵓⴰ ⵎⵙⵏ ⵔⵈⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ⴹⴹ ⵤⵎⵙ ⵜⵀⵍⵍⵎ ⵙⵔⵜ ⴾⵍ ⵍⵎⵗⵏⴰ ⵜⴾⵏⵎ ⵜⵍⴰ ⵏⵤⴶⵤⵏ ⵜⴾⵏⵎ ⵎⵙⵏⵜ ⵏⵓⵍ ⵜⴾⵏⵎ ⵜⵍⴰ ⵏⵎⵙⵏⵜ ⵜⵙⵏⵎ ⴶⵍⵢⵜ ⴹⵗ ⵔⵜ ⴾⵍ ⵜⴹⴶⵤⵎ ⴹⵗ ⵜⵔⴰ ⵜⴰ ⴹⵓⵏⴶⴰ⵰ ⵓⴹⵢ ⵔⵈⵎⵜ ⵜⴰ ⵎⵙ ⴶⵢ ⵏ⵿ⵜⵔⴶⵜⵏ ⴹⴰ ⴹⴶⵤⵜ ⴹⵗⵙ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ⵓⵔ ⴹⵓⵏ⵿ⴶⵏⴰ ⵎⵙ ⴼⵍⵓⵏ ⵛⵍ ⴶⵢ ⵏⴹⵢ ⴾⴹⵗ ⵙ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⴾⵏⵏⵜ ⵜⵔⴰ ⵏⴶⵏⵜ⵰ ⴾⵍⵔ ⵜⵔⴰ ⵗⵙ ⴶⵗ ⴹ ⵙⵏⴰ ⴹⴰ ⴹⵜⵆⵍ ⵜⵔⴰ ⵜⴰ ⴾⵓⵏ⵿ⵜⵂⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ⵜⵙⵏⵎ ⴹⵗ ⵔⵈⵎⵜ ⵜⴰ ⴹⵏⵗⵙⴾⵏⴰ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵏ⵿ⵜⴰ ⵓⵏ ⵎⴶⵔⴶⵙ ⵙⵍⵆⵓ ⵎⵏⵜ ⴼⵍ ⴹⵍⵍⵏⵓⵏ ⴼⵍ ⴾⵓⵏⵙⴶⵔⴶⵙ ⴾⵓⵏⵢ ⵙⵍⵆⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ⵏ⵿ⵜⴰ ⴹⴰ ⵏⵙⵈⴰ ⵓⴰ ⴹⵓⵏⴶⵗ ⴹⵗ ⵀⵜⵓ ⵜⴹⵢ ⴼⵓⵏ ⴹ ⵜⵙⴾⵙⵓⵎ ⵔⵜ ⵙ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴹ ⵜⵙⵏ⵿ⵜⵏ ⵍⴰ ⴹⵢ ⵎⵔⴹⴰ ⵓⵜⵢ ⴼⵍⵙ ⴾⵓⵏⵢ ⵤⵔⵏⵏ ⵙⴶⵏⵜ ⴾⵓⵏⵢ ⴹⵗ ⵜⴹⴾⵜⵏ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ⴹⵗ ⴹⵢ ⵎⵔⴹⴰ ⴶⵓⵜ ⴹⵗ ⵙⴾⵙⵓ ⵏⵛⵗⵍ ⴹⵢ ⴹⴶⵤ ⵓⴰ ⵜⴶⵎ ⵙ ⵜⴹⵜⵙⵏ⵿ⵜⵎ⵰ ⵔⴶⵜ ⴹⵗ ⵔⵜ ⵆⵍ ⵓⴰ ⵜⵍⵎ ⵓⵙ ⵜⴼⵔⴶⵎ ⵛⵔⴶⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ⴼⵍⵙ ⴾⴹ ⴹⵔⵏ ⵙⵂⵏ ⵍⵢ ⵓⴹⵢ ⵜⵂⴾⵜ ⴹ ⵜⵜⵓⵆⵀⵍ ⵙⵍⵗ ⵓⵍ ⵓⵏ ⵙⵓⴰ ⵏⵍⴰ ⵓⵔⴶⵗ ⵓⴰ ⵓⵔ ⵏⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ⵓⵔⴶⵗ ⴶⵎⵢ ⵜⴶⴰ ⴹ ⵙⵏⴼⵍⵢⵗ ⵢⵜⴹⵏ ⵓⵢⴹ ⴾⵓⵏⵢ ⵎⵔⵏ ⵙⵎⵗⵜⵔⵆⵓⵏ⵰ ⴾⵍⵔ ⴶⵎⵢ ⵗⵙ ⵜⴶⴰ ⴹ ⵜⵏⵎⵓⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ⵎⵔⴹⴰ ⴾⵓⵏⵢ ⵀⵍⵍⵏⵏ ⵎⴾⵏ ⴹ ⵜⵍⵍⵎ ⵢⵢⵜⴹⵏ ⵓⵏ ⵜⵍⵆⵓⵏ⵰ ⵙ ⴶⴰ ⴹⵢ ⵙ ⵏⴼⵍⵢⵏ ⴹⵓⵏⵍⵍⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⵤⵍ ⵓⴰ ⴹ ⵜⵎⵗⵜⵔⵎ⵰ ⵎⴾ ⵓⴹⵢ ⵙ ⵤⴰ ⵜⵏⵎⵓⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴹⵏ ⵓⴰ ⵛⴹⵓⵏ ⴶⵏ ⵓⵔ ⵛⴹⵓ ⵜⴶⵔⵏ⵰ ⵓⴰ ⵛⴹⵓⵏ ⵏ⵿ⴹⵔⵏ ⵓⵔ ⴾⵜⵢⵜⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ⴶⴹⵢⵗ ⵢ ⵎⵛⵏⴰ ⴾⴼⵏ ⵜⵜⵙ ⴶⵍⵢⵜ ⴹⵗ ⵀⵜⵏⵓⵏ ⵛⵍⵜ ⵏ⵿ⵜⴰ ⴹⵗⵙ ⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ⴼⵍⵙ ⵓⵔⴶⵗ ⵜⵔⴹⵓⵜ ⵗⵙ ⴶⴰ ⵙⵔⵜ ⵓⴰ ⴹⵗⵙ ⵏⴶⵎⵢ ⴼⴹⴰ ⵙⵓⵔ ⴹⵢ ⵙ ⴹⵏ⵿ⴾⵔ ⴶⵔⵙ ⴹⵎⵏⵜ ⴾⵓⵏⵏ ⴼⵍ ⴶⵍⵢⵜ ⴶⴰ ⴹⵗ ⵀⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ⵏⵛⴹⵓⵜⵏ ⴹⵎⴹⵔⵢⵏⵏⴰ ⵢⵏ ⵙ ⵍⴾⵏⵙⵜⵏ ⴾⵜⵏⵙⵏⵜ ⵎⵍⵏⵜ ⵛⵗⵍ ⵓⴰ ⵜⴶⵓ ⴹⵗ ⵀⵜⵓ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ⵏ⵿ⵜⴰ ⴹⵗ ⵙⵏⴼⵔⵏⵜ ⵍⴾⵏⵙⵜⵏ ⵢⴹⵔⵏⵗ ⴹⵓ ⴹⵗ ⵛⴾⵍ ⵓⴰ ⵤⴰ ⵏⴶⵓ ⵏⵓⵢ ⵔⵈⵎⵜ ⵜⴰ ⵎⵙⵏⵜ ⵜⵔⴶⵜⵏ ⵛⵏ ⵢⴹⵔⵙ ⵏⵜⴼ ⵏⵙⴾⵏⵓ ⵙⴹⵢ ⴹⴾⵍⵏⵏⴰ ⵎⵍⵢ ⴹⴹⴶⵤ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵜⵍⵍ⵿ⵜ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ⵜⵎⵙ ⵜⴹⵓⵜⵏⵏⴰ ⴹⵔⵙ ⴹⵔⴶ ⵢⴹⵏⵗⵜⵓⵙⵓⵔ ⵍⵂⵏ ⵆⵍ ⴹⵗ ⵜⵍⵗⴰ ⵏⵏⵜⴼ ⵓⴰ ⵏⴶⴰ ⴹⵜⵂⴾⵜ ⵤⵓⵔⵜ ⵜⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ⴼⵍⵙ ⵏⴶⵎⵢ ⵓⴰ ⵍⵗⵏ ⴹⵜ ⵎⵍⵢ ⴹⵢⵜⴹⵏ ⵏⴶⵎⵢ ⴹⵗ ⵎⵤⵍ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ⵎⴹⵏ ⵓⵏ ⵙⵔⵓⵏ ⵏⵤⵎⵤⵍ ⵏⵛⴹⵓⵜⵏⵏ ⴹⵎⴹⵔⵢⵏⵏⵗ ⵢⵏ⵰ ⵎⴹⵔⵢⵏⵏⴰ ⵓⴰ ⵏⵔⵎ⵿ⵜⵓ ⴹⵗ ⵜⴾⵍⵜⵏ ⴶⵜⵏⵏ ⵙ ⵜⵎⵓⵜⵏ ⴶⵜⵏⵏ ⴼⵓ ⴶⵍⵢ ⵓⵍⵏ ⵎⵔⴹⴰ ⴼⵍ ⵓⴰ ⴹⵓⵏⴶⴰ ⴹⵗ ⴼⵍⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⵜⵙ ⵎⴹⵏⵏ ⵎⵙ ⴹⵔ ⴹⵔⵓⵗ ⵛⵗⵍ ⵓⴰ ⴹⵓⵏ⵿ⵜⴶⵗ ⵎⵔⵏ ⴹⵗ ⵀⵜⵓ ⵏⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⵂⴹⵜⵏⵏ ⵓⵏ ⴹⵔ ⴹⵓ ⵏ⵿ⵜⵏⵢ ⵏⵎⵤⵍ ⵎⵙⵏ ⵏⵍⴾⵏⵙⵜⵏ ⵛⵗⵍⵏⵏ ⴶⵎⵢⵏ ⴹⴾⵍ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ⴹⵗ ⴹⵢ ⵙⴾⵏⵓⵜⵏ ⵜⵔⴰ ⵜⴰ ⴾⵓⵏ⵿ⵜⵂⵜ ⴹⴹⵍⵍ ⵓⴰ ⵏⵍⴰ ⵙⴶⵢ ⵏⵀⵔⴶⵏ ⴹⵗ ⵀⵜⵏⵓⵏ ⴼⵍ ⴹⵗⵙⵏ ⴾⵙⵏⵜ ⵍⴾⵏⵙⵜⵏ ⵛⴾ ⵏⵢⵏⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵜⴹⵂⵍ⵿ⵜ ⵏⵎⵤⴹⴶⵏ ⵓⵔ ⴹⵔⵔⴰ ⵙⴹⵓⵏⵏⴾⵜⵀⵗ ⵛⵔⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ⴼⵍⵙ ⵙⵏⵗ ⴹⵗ ⴶⵍⵢⵜ ⵜⴰ ⵜⴶⵎ ⴹⵗ ⴹⵙⵏ⵿ⵜⵔⴶⵎ ⴹⵙ ⴶⵗ ⵢⵢⵜⴹⵏ ⵏⵎⵙⴹⵏⵢⴰ ⵀⵔⴶⵏ ⴼⵍⵓⵏ⵰ ⵏⵗⵙⵏ ⵏⵍⴾⵎⵏ ⵏⵍⵎⵙⵈ ⵓⵏ ⴾⵍ ⵏⴾⵢⴰ ⵂⵔⵓⴰ ⵏⵢⴹⵏ ⴹ ⵔⵏ ⵙⴶⵍⵢ ⵏ⵿ⵜⵔⴶⵜⵏ⵰ ⴼⴹⴰ ⴹⴶⵤⵏⵓⵏ ⴹⵗ ⴶⵢ ⵏ⵿ⵜⵔⴶⵜⵏ ⵙⵔⵏ ⵜⵛⵎⵏⵙⵏ ⴹ ⵔⴶⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ⴹⵢ ⴼⵍ ⵙⵔⵓⵏ ⵏ⵿ⵤⵎⵤⵍⵗ ⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⴹⵢ ⴼⵍ ⴹ ⵓⵔ ⵆⵍⵏ ⵀⵔⴶⵏ ⵓⵏ ⴼⵍⵓⵏ ⵏⵜⴶⵓ ⵓⵍ ⵏⵀⵏⵏ⵰ ⵏⵗⵙⵏ ⵙ ⴾⵓⵏⵏ⵿ⵤⵙⵏ ⵛⵔⴶⵜⵏⵓⵏ ⵎⵜⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ⵙ ⵓⵔ ⴶⴰ ⴹⵢ ⵂⵔ ⴾⵓⵏⵏⵙⵗ ⴹⵓⵗ ⴹⵔⵜ ⴹⵗ ⴾⵍ ⵎⵙⴹⵏⵢⴰ ⵏⵙⵓⵏⵏ ⵓⵔ ⵜⵙⵎⵜⴶⵎ⵰ ⴹⵏⵜⵀⵤ ⵜⴾⵔⴾⵜ ⵏⵀⵔⴶⵏ ⵓⵏ ⴹⵙⵏⴶⵗ ⴼⵍⵓⵏ ⵎⵔⵏ ⴾⵓⵏⵢ ⵓⵍⵏ ⵤⴰ ⵜⵀⵤ ⵜⴾⵔⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ⴹⵗ ⴹⵢ ⵏⵢⵗ ⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵙⴹ ⴶⵎⵢⴰ ⴹⵗ ⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⴹⵢ ⴹⵏⵤⵔⵏ ⵢⴹ ⵛⴹⵓⵏ ⵛⵔⴶⵜⵏ ⵛⵏ ⵙ ⵜⴶⵎ ⵔⴾⵓⵍⵏⵙⵏⵜ⵰ ⵙⴾⵏⵓ ⴹⵢ ⵙ ⵜⴶⵎ⵿ⵜⵏⵜ ⵙⵍⵍⵓ ⵓⵔⴶⵗ ⵙ ⴶⵔⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","ⵏ⵿ⵜⴰ ⴹⴰ ⵓⴰ ⵙⴾⴰ ⵙ ⵀⵜⵓ ⵜⴹⵢ ⵓⴹⵏ ⵓⴰ ⵏⵀⵍⵏ ⵎⵙⴰ ⵓⵔ ⵏⴶⵜ ⴹ ⴹⵍⵢ ⵜⵏ⵿ⴼⴰ ⵓⵔ ⵏⴶⵜ⵰ ⵓⴹⵏ ⴹⵗ ⵓⴰ ⵏⵀⵍⵏ ⵎⵙⴰ ⴶⵏ ⴹ ⴹⵍⵢ ⵜⵏ⵿ⴼⴰ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ⴾ ⵓⴹⵏ ⴾⴼⵜ ⵓⵙ ⴶⴰ ⵏⵢⵜ ⵏⴹ ⵜⴾⴼⵓ ⴹⵗ ⵎⵏⵜ⵰ ⴹ ⵓⵔ ⵜⵆⵍ ⵜⵂⴾⵢⵏⵜ ⵔⵜ ⵎⴶⵔⵤ ⵓⵍⴰ ⵎⵙ ⵙ ⵛⵍ⵰ ⴼⵍⵙ ⵎⵛⵏⴰ ⵔⴰ ⵓⴹⵏ ⵓⴰ ⵂⴾⵏ ⵙ ⵎⵏ ⵔⴹⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ⵎⵔⵏ ⵎⵛⵏⴰ ⴼⵔⴶ ⴼⵍⵓⵏ ⴹⵤⵤⵀⵜ ⵤⵏⴼⵏ ⵏⵔⵈⵎⵜⵏ ⴶⵜⵏⵏ ⴼⵍ ⵜⵓⵔⵎⵍ ⵔⵜ ⵆⵍ ⴹⵗ ⵍⵓⵆ ⵆⵍ ⵙ ⵜⴹⵔⵔⵎ ⵂⵔ ⵜⵓⴹⵎ ⴶⵢ ⵏⵎⵤⵍⵏ ⴾⵍ ⵓⵏ ⵍⵗⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ⴹⵢ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵂⴾⵓ ⵙⵍⵍⵓ ⵂⴾⵓ ⵛⵍⵆⵓⵏ⵰ ⵜⵆⵜⵏⵜ ⵜⵗⵍⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ⵎⵛⵏⴰ ⵂⴾⵏ ⵎⴶⵢⴾ ⵎⵙⴰ ⵂⴾⵓ ⴹⵗ ⵙⴹⵔ⵰ ⵏ⵿ⵜⴰ ⴹⵗ ⴾⵓⵏ⵿ⵤⴾⴼⵏ ⵎⵙⴰ ⵙⴶⵜ ⵜⵤⵔ ⵙⴶⵜ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⴹⵜⵓⵢ ⵜⵆⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ⵓⵍⴰ ⵎⵛⵏⴰ ⴾⵓⵏⵙⵀⵍⵍ ⴹⵗ ⵔⵜ ⴾⵍ ⴼⵍ ⴹ ⵜⴼⵔⴶⵎ ⴹ ⵜⵍⵍⵎ ⴼⵓ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ⵓⵢⴹⵓ ⴹⵢ ⵙⵢⵜⴹⵏ ⵓⵏ ⵙ ⵤⴰ ⵏⵓⵢ ⵛⵔⴶⵜⵏⵓⵏ ⴶⵢ ⵏ⵿ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ⴼⵍⵙ ⵛⵔⴶⵜⵏ ⵛⵏ ⵜⴶⵎ ⵓⵔⴶⵗ ⵎⵤⴹⴶⵏ ⵓⵏ ⵢⵔⵙⵍⵎ ⵓⵏ ⵎⴹⵔⵔⵏ ⵗⵙ ⵙ ⵤⵏ⵿ⴼⵏⵜ⵰ ⴾⵍⵔ ⴹ ⴹⵓⵢⵏⵜ ⵙⵢⵜⴹⵏ ⴶⵜⵏⵏ ⴶⵢ ⵏ⵿ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ⵛⵔⴶⵜⵏ ⵛⵏ ⴹⵢ ⵏ⵿ⵜⵏⵜⵢ ⴹⵓⵢⵏⵏ ⵙ ⵎⵤⴹⴶⵏ ⵓⵏ ⵢⵔⵙⵍⵎ ⵤⵤⵓⵔ ⵏⵎⵛⵏⴰ ⴼⵍⵙ ⵜⵙⴾⵏⵎ ⵀⵔⴹⴶ ⵓⴰ ⵙⵔⵓⵏ ⴹⵓⵢ ⵍⴾⵎ ⵓⴰ ⵜⴶⵎ ⵢⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ ⵜⵙⴾⵏⵎ⵿ⵜⵏ ⴹⵗ ⵍⵍⵓ ⵏ⵿ⵜⵏⵢ ⴹⵢⵜⴹⵏ ⵙⵂⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ⵙ ⴹⵓⵏ⵿ⵜⴶⵏ ⵛⵓⵜⵔⵓⵏ ⴹⵓⵏ⵿ⵜⵏⵜⴶⵏ ⵙ ⵎⵏ ⵜⴹⵏⵢ ⵜⵔⴰ ⴼⵍ ⴹⵍⵍ ⵏⵔⵈⵎⵜ ⵜⴾⵏⵜ ⵜⵤⵓⵔ⵿ⵜ ⵜⴰ ⴾⵓⵏⴾⴼⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ⴶⴹⵢⵜⵏⵗ ⵢ ⵎⵛⵏⴰ ⵜⵂⴾⵜ ⵓⵔ ⵏⵍⴰ ⵜⵍⵜ ⵜⴰ ⴹⵏⵗⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ⵏⴾ ⵀⵍⵙ ⵏⴾ ⵓⴰ ⴼⵍ ⴶⵏⵏ ⵢⵜⴹⵏ ⵙ ⵛⵔⴰ ⵛⵏ ⴹⵓⵏⵏ⵿ⴾⵜⵀⵗ ⵗⵙ ⴹⵗ ⵂⵍⴰ ⵓⵍ ⵎⵛⵏ ⵙ ⴾⵓⵏⵂⵗ ⴹ ⵆⵍⵗ ⵓⴹⵏ ⵍⵎⴹⵏ⵰ ⵏ⵿ⵙⵢⵆⵓⵏ ⴼⵍ ⴹⵎ ⵏ⵿ⵜⵍⵎⵜ ⴹⵍⵗ ⵓⵏ ⴶⴰ ⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ⵙ ⵙ ⴾⵓⵏⵏⵙⵗ ⴹⵓⵔ⵿ⵜⵛⵂⵛⵍⵎ ⴾⵓⵏⵙⴾⵏⴰ ⵜⵂⵍⵜⵏ ⵓⵍ ⴹ ⵜⵙⵗ ⴹ ⵙⴾⵏⴰ ⵜⵂⵍⵜⵏ ⵓⵍ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⴶⵏⵏ ⴹⵢ ⵏⴾⵏⵢ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⵜⵍⴰ ⵏⴹⵏⵜ⵰ ⴹⵓⵏⵍⵙⴰ ⵜⵏⴰ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹⵓⵔ⵿ⵜⵛⵂⵛⵍⵎ ⴶⵢ ⵏⵎⵤⵍ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ⵜⴹⵜ ⵎⵙ ⵙ ⴹⵏⵜ ⵏⵂⴰ ⵎⵛⵏ ⵓⵔ ⵏⵎⴶⵔ ⴼⵍ ⵓⴰ ⴼⵍ ⵎⴶⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ⴼⵍⵙ ⵜⵤⵍⵢ ⵜⵙ ⵏⵎⴶⵔ ⵓⵔ ⵜⵜⵍⴰ ⴹⵏⵜ ⵜⴰ ⴾⵍⵔ ⵜⵔⵏⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ ⵙ ⵏⵎⴶⵔ⵰ ⵏⵜⴹⴶⴹⴶ ⵙⵔⵙ ⴹⴶⵏ ⵙⵂⵜⵏⵏ ⵓⵏ ⵜⴼ ⵀⵍⵙ⵰ ⵏⵙⵏ ⴹⵗ ⵀⵂⵜⵏⵜ ⵏⵙⴼⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ⵏⵤⵔⵤ ⵙⵔⵙ ⵜⵎⵤⵆ ⴾⵍ ⵜⴰ ⵜⴶⴹⵍⵜ ⵢⵢⵜⴹⵏ ⴹ ⵙⵏⵏ ⵎⵛⵏⴰ⵰ ⵜⵤⵍⵢ ⵜⴹⵢ ⴹⴰ ⵙ ⴹⵏⵜⵀⵤ ⵎⴹⵔⵏⵏ ⴾⵍ ⵏⵢⵜⴹⵏ ⴼⵍ ⴹ ⵀⵔⴹⴶⵏ ⵢⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ⵙ ⵜⵙⴾⵏⵎ ⵍⴾⵎⵍⵜ ⵏⵀⵔⴹⴶⵏⵓⵏ ⵏⵙⵎⵜⴶ ⵢⴹ ⵏⵓⴹⵀ ⵓⴹⵏ ⴾⵍ ⵓⵏ ⵏⵎⵤⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ⵙⵓⴹⵜ ⴹⵗ ⵓⴰ ⵍⵏ ⴹⵜ ⵛⵜⵓⵏⵓⵏ ⵜⴶⵔⵎ⵿ⵜⵓ⵰ ⴾⴹ ⵓⴹⵏ ⴾⵓⵏⵂⵏ ⴾⵙⵏ ⵛⴾ ⵙ ⵍⵎⵙⵈ ⵜⵍⵏ⵰ ⵙⵏⵜ ⵤⴰ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⴶⵏⴰ ⵍⵎⵙⵈ ⵜⵍⴰ ⵜⴹⵢ ⴹⴰ ⴹⵙⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ⵓⵍⴰ ⴹ ⴶⵗ ⵀⵔⴶⵏ ⴶⵜⵏⵏ ⴼⵍ ⵙ ⴹⵏⵗⴾⴼⴰ ⵎⵍⵢ ⵜⵏⵢⴰ ⴹⴰ ⵓⵔ ⴹⵤⵤⵀⵤ ⴹⵢ ⵜⴾⵔⴾⵜ⵰ ⵜⵏⵢⴰ ⵜⴰ ⴹⵏⵗⴾⴼⴰ ⵛⵏ ⴾⵓⵏⵙⵙⵂⵜ ⵓⵔⴶⵗ ⴾⵓⵏⵌⵀⵔⵌⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ⵏⵗ ⵓⵏ ⴼⵍ ⴹ ⵓⵔ ⵜⵗⵍⵎ ⵛⵙⴾⵙⴹⵓⵏ ⵗⵙ ⴹⵓⵏ⵿ⵜⴶⴰ ⴹⵗ ⵛⵔⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ⴹ ⵜⵓⵏⵓ ⵙⵔⵢ «ⴰ ⴾⵓⵏⵓⵔⵛⵓⵛ ⵀⵍⵙ⵰ ⵛⵔⵏⵜ ⵛⵢ ⵍⵀⵙⵏⵏ ⵙⵂⵜⵏⵜ ⵎⵛⵏ ⵏ⵿ⵜⴰ ⵙ ⵎⵏⵜ ⵙ ⴹⵏⴹⵙⴰ ⵓⵔ ⴼⵔⵔ ⵎⵔⵏ ⵓⵔ ⵙⵏ ⵓⵍ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ⵓⴹⵏ ⵓⴰ ⵙⵔⵢ ⵏⵏ ⴹⵢ ⵙⵏⵜ ⵙ ⵓⴰ ⴹⵏⴾⵜⵀ ⴹⵗ ⵛⵔⵏⵏⴰ ⵏ⵿ⵜⴰ ⵤⴰ ⵏⵎⵤⵍ ⵙ ⴾⵓⵏⵏⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ⵜⴹⵜ ⵙ ⵓⵔ ⵤⴰ ⵏⵂⵍ ⴹ ⵏⵛⵛⴶⴹⴰ ⵎⵏⵏⴰ ⵓⵍⴰ ⵏⵛⵛⵍⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⴹⵓⵏⵎⵍⵏⵏ ⵎⵏⵙⵏ⵰ ⵓⵔ ⵏⴹⴾⴹ ⵎⵏⵙⵏ ⵔ ⵙ ⵎⵏⵙⵏ ⵛⵛⴶⴹⵏ ⴹⵗ ⵎⵏⵙⵏ ⴹⵎⵏⵙⵏ⵰ ⵓⵔ ⵍⵏ ⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ⵏⴾⵏⵢ ⵤⴰ ⵓⵔ ⵤⴰ ⵏⴶⵓ ⵀⵔⴶⵏ ⴼⵍ ⵔⵜⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⵜⴹⴶⵔ⵿ⵜⵏⵏⴰ⵰ ⵎⵔⵏ ⵓⵔ ⵤⴾⵢⵏ ⵀⵔⴶⵏⵏⴰ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ ⵜⵜⵎⵙⵏ ⵙ ⴾⵓⵏⵏⵓⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ⴾⵢ ⵓⴰ ⴹⵓⵏⵏⴶⴰ ⵓⵔ ⵎⵙ ⵙⵙⴾⵢ ⴼⵍ ⵓⴰ ⵏⵜⵓⴾⴼⴰ ⵤⵏ ⵙ ⴾⵓⵏⵢ ⵓⵔ ⵜⵂⵎ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⵏⴶⵔⵓ ⴼⵍⵙ ⴾⵓⵏⵢ ⵙ ⵏⵤⵔ ⵏⵛⵗⵍ ⵗⵔⵓⵏ ⵏⵎⵍⵓⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ⵏⴾⵏⵢ ⵓⵔ ⵏⵜⴶⵓ ⵀⵔⴶⵏ ⴼⵍ ⵛⵗⵍ ⵏⵓⵢⴹ ⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓⵏⵏ ⵜⴹⴶⵔ⵿ⵜ ⵓⵔ ⵏⵎⵙ ⵜⴰ ⵏⵜⵓⴾⴼⴰ ⵏⴾⵏⵢ⵰ ⴾⵍⵔ ⵜⵎⵏⵏⴰ ⵏⴶⵢ ⴹⵗⵙ ⵙ ⵜⵜⵢ ⵤⴶⵤⵏⵓⵏ ⵗⵔⵓⵏ ⵏⴶⵓ ⵛⵗⵍ ⵙ ⵤⵜⵤⵓⵔⵏ ⵓⵍⵏ ⴹⴰ ⵓⵔ ⵏⴾⵢ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⴹⵏⵗⴾⴼⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ⵍⵎⵗⵏⴰ ⴹ ⵏⴼⵔⴶ ⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴹⵗ ⴾⵍⵏ ⵓⵏ ⴹⵏⴶⵓⵏ ⵍⵏⵏ ⵏⵆⵎ ⴹⴰ ⵓⵔ ⵏⴶⴰ ⵀⵔⴶⵏ ⴼⵍ ⵓⴰ ⴹⵈⵙⵍⵏ ⴹⵗ ⵛⵗⵍ ⵎⵙⵏ ⵜⴹⴶⵔ⵿ⵜ ⵏⵓⴹⵏ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ⵏⵏ ⵍⴾⵜⵀⵏ «ⵢ ⵜⴶⵏ ⵀⵔⴶⵏ ⴶⵜⵏ ⴼⵍ ⵓⴰ ⴶⴰ ⵎⵍⵢ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ⴼⵍⵙ ⵓⵔⴶⵗ ⵓⴹⵏ ⵓⴰ ⵎⵍⵏ ⵎⵏⵜ ⴶⵔⵓⵏ ⵙⵗⵎⵔ ⴾⵍⵔ ⵓⴹⵏ ⵓⴰ ⵎⵍ ⵎⵍⵢ ⵜⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ⵔⵗ ⴹⵗⵓⵏ ⴹⵔⵢ ⵜⵤⵤⵢⴹⵔⵎ⵰ ⴹ ⴶⴰ ⵔⵜ ⵏ⵿ⵜⵎⵜⴾⵓⵢⵜ ⵏⵎⵙⴾⵍ⵰ ⵓⵍⴰ ⵤⵎⵔⵜ ⵢⵓⴰ ⵤⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ⴼⵍⵙ ⴶⵗⵓⵏ ⵜⵔⴰ ⵜⵏ ⵜⵙⵎⵜⵏ ⵛⵙⵎⵜⵏ ⴹⵢ ⴹⴰ ⵛⵏ ⴹⴼⵍⵏⵏ ⵎⵛⵏⴰ ⴹ ⵜⵂⵎⵢ ⵛⵛⵍⵏ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⵙ ⵓⵔ ⴾⵍⴰ ⵜⵜⴹⵙ ⵍⵙ ⴹⵔ ⵙⵎⵔⴾⵙ ⵍⵙ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵍⵎⵙⵈ ⵎⵔⵏ ⵏⴾ ⴹⵙⵙⵎⵔⴾⵙⵏ ⴹⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ⵎⵛⵏ ⴾⵙⴹⵗ ⴹ ⵜⵓⵔⴾⵀⵏⵜ ⵜⵢⵜⵓⵏⵓⵏ ⵙ ⵜⵙⴹⴾ ⵢⵜ ⵜⵎⵤⵢⵎ ⴹⵍⵗⵀⴹⴰ ⵓⴰ ⵜⴶⵎ ⵍⵎⵙⵈ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹ ⵎⵏ ⵤⴹⴶⵏⵏ ⵜⵓⴶⵓⵏ ⵜⵓⵙⵈⵔⴾ ⵓⴰ ⴶⴰ ⵎⵍⵍ ⵈⵓⴰ ⵙ ⵜⴾⵔⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ⴼⵍⵙ ⵙ ⴾⵓⵏⵏⵙⴰ ⵓⴹⵏ ⵢⵏ ⴶⵓⵏ ⵙⵍⵏ ⵏ⵿ⵗⵢⵙⴰ ⵢⵏ ⵓⵔ ⵏⵎⵙ ⵓⵙ ⴹⵓⵏⴶⴰ ⵙⵍⵏⵜ ⵎⴹⵗ ⵜⴶⵔⵓⵎ ⵏ⵿ⴼⵙ ⵢⵏ ⵓⵔ ⵏⵎⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵓⴰ ⵜⴶⵔⵓⵎ ⵎⴹⵗ ⴶⵓⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵢⵏ ⵓⵔ ⵏⵎⵙ ⵓⴰ ⵜⵆⵀⵍⵎ ⵜⵔⵎⴹ ⵙ ⴹⵙ⵿ⵜⴾⵏⵎ ⵜⵔⴹⵓⵜ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵤⴰ ⵓⵔ ⵗⵔⵢ ⴶⴰ ⵙ ⵍⵢ ⵔⵜ ⵙ ⴹⴶⵔⵏ ⵏⵎⵤⵍⵏⵓⵏ ⵓⵔ ⵏⵍⴰ ⵜⵍⵜ ⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ⵎⵔⵏ ⴾⴹ ⵓⵍ ⵓⵔ ⵍⵗ ⵎⴹⵙⵏⵜ ⵎⵙⵏⵜ ⵏ⵿ⵜⴰ ⵍⵆⵜ ⵓⵍⵏ⵰ ⵏⵙⴾⵏⵓⵏ⵿ⵜⵜ ⴹⵗ ⴾⵍⴾ ⵏⵔⵜ ⵙⵎⴾ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ⵓⴾ ⵀⴾⴹ ⴶⵗ ⵙ ⵙⵔⵙⵗ ⵎⵏⵏ ⴼⵍ ⴾⵓⵏⵤⵤⵓⵔⴰ ⴾⵓⵏⵢ ⵙⵎⵍ ⵓⴰ ⴹⵓⵏⴶⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵏⵎⵛⵏⴰ ⵓⵔ ⴾⵓⵏⵤⵔⵤⵎⴰ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ⵗⴹⵓ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⵙ ⵜⴹⵂⵍ⵿ⵜ ⵜⴰ ⴹⴶⵏⵜ ⵙⵓⵙ ⴹⵔⵔⴰ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⴹⵓⵏⴶⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ⵍⵓⵆ ⵓⴰ ⵗⵔⵓⵏ ⵍ ⵓⵔ ⴾⵍⴰ ⵆⵍⵗ ⵢ ⵓⵍⵢⵏ ⴹⵗⵓⵏ ⵤⴾ ⵙ ⵎⵗⵜⵔⴰ ⵙⵔⵜ ⴼⵍⵙ ⵎⴹⵔⵢⵏⵏⴰ ⵓⵏ ⴹⴼⵍⵏⵏ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⴹⴾⴼⵏⵏ ⵓⵙ ⴹⵔⵔⴰ⵰ ⴶⴹⵍⵗ ⵢ ⵎⵏⵏ ⵜⵛⵜ ⵏⵤⴾ ⵢ ⵓⵍⵢⵏ ⴹⵗⵓⵏ ⴹⵗ ⴾⵍⴾ ⵏⵏⵎⴹ ⵎⵔⵏ ⴹ ⴶⵍⴰ ⴹⵗ ⴶⵢ ⵏⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ⴶⵎⴹ ⵓⴰ ⴶⴰ ⵛⴾ ⵜⴹⵜ ⵏⵍⵎⵙⵈ ⵜⴰ ⴹⵜⵂⵜ ⵏ⵿ⵜⴰ ⴶⴰ ⵙ ⵓⵔ ⵂⴰ ⵓⴹⵏ ⵎⴹⵍⵏ ⵏⴾⵍ ⵏⴾⵢⴰ ⴼⵔⴶⵏ ⴹⴶⴹⵍ ⴶⵢ ⵏⵀⵔⴶ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ⵎⴰ ⴼⵍ ⴶⵗ ⴹⵢ⵰ ⵓⴾ ⵀⴰ ⵏ⵿ⵜⵔⵏⵓⵏ⵰ ⵎⵛⵏⴰ ⵙⵏ ⵙ ⵔⵆⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ⵔⵜ ⵓⴰ ⵜⴶⴰ ⴹⴰ ⵎⵔⵏ ⴹ ⴶⵍⴰ ⴹⵗ ⴶⵏⵜ ⴼⵍ ⴹ ⴶⴹⵍⵗ ⴶⵢ ⵏⵀⵔⴶⵏ ⵢⵢⵜⴹⵏ ⵓⵏ ⵔⵏⵏ ⴹ ⴶⵔⵓⵏ ⵜⵔⵢⵜ ⵏⴹ ⵏⵏ ⵛⵗⵍⵏⵙⵏ ⵓⵔ ⵤⵍⵢ ⴹⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ⴼⵍⵙ ⵎⴹⵏ ⵓⵏ ⴹⵢ ⵏⵎⵤⵍ ⵏⵀⵂⵓ ⵎⵙⵏ ⵎⵙⵏ ⴹⵗ ⵎⵛⵗⵍⵏ ⵏⵎⴾⴹⵍ ⵙⴾⵏⵏⵏ ⵙ ⵏⵎⵤⵍ ⵏⵍⵎⵙⵈ ⵎⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ⵓⵔ ⵆⵏ ⴹⵢ ⵗⴼ ⴼⵍⵙ ⵓⵍⴰ ⵛⵢⵜⵏ ⵜⴶⵓ ⵎⵏⵜ ⵏ⵿ⴶⵍⵙ ⵏⵏⵔ ⵜⴶⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ⴹⵗ ⴹⵢ ⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵛⵗⵍⵏⵏ ⵓⵔ ⵙⵎⴾⵍⵍ ⴹ ⴶⵏ ⵎⵏⵙⵏ ⵤⵏ ⵎⵛⵗⵍⵏ ⵙⵙⵗⵔⵏⵏ ⵢⵜⴹⵏ ⵜⵆⵜ⵰ ⵍⴾⵎ ⴹ ⴶⵔⵓⵏ ⵓⴰ ⴹⵔ ⵂⵔⵏ ⵎⵤⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","ⴹⵓⵏⵍⵙⴰ ⵜⵏⴰ ⴹ ⵓⵔ ⵗⵍ ⵓⴹⵏ ⵓⵍⵢⵏ ⵏⴾ ⵎⵙⴾⵍ⵰ ⵎⵛⵏ ⴾⴹ ⵎⵙⴾⵍ ⴹⵜⴶⵎ ⵜⵤⵎⵔⵎⵢ ⵓⴰ ⵜⵜⴶⵎ ⵢⵎⵙⴾⵍ ⴼⵍ ⴹ ⴶⵗ ⵔⵜ ⵏⵀⵔⴶⵏⵏ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ⵔⵜ ⵓⴰ ⵏ ⴹⴰ ⵓⵔⴶⵗ ⵔⵜ ⵙ ⴹⵏⴰ ⵎⵍⵢ ⴹ ⵜⵏⴰ ⴾⵍⵔ ⵀⵔⴶ ⴹⵢ ⴹⵜⵙⵙⴶⴰ ⵜⵍⵜⵏ ⴹⵎⵙⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ⴹⴹ ⵤⵎⵙ ⴶⵜⵏ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵀⵔⴶⵏ ⴼⵍ ⵓⴰ ⵜⴶⵓ ⴶⴹⵎ ⴹⵗ ⴹⵏⵜ ⵏⴾ ⴹⴰ ⴹ ⴶⵗ ⵀⵔⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ⴼⵍⵙ ⴾⵓⵏⵢ ⵓⵏ ⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ ⵜⵤⵎⵔⵎ ⵢ ⵎⵙⴾⵍⵏ ⵙⴹⵓⵜⴾⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ⵜⵤⵎⵔⵎ ⵢⵢ ⴾⵓⵏⴶⵏ ⴾⵍⵏ ⵎⴹⵗ ⵗⵓ ⵓⴰ ⵜⵍⵎ ⵜⵤⵎⵔⵎ ⵢⵢ ⴹⵗⵓⵏ ⵜⵜⴶⵏ ⵙ ⵜⴾⵔⵙⵏⵜ ⵎⴹⵗ ⵙⴾⵏⵓⵏ ⵎⵍⴾⴰ ⵎⴹⵗ ⵓⵜⴾⵓⵏ ⴹⵗ ⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_21ⴰ","077_11_21ⴰ","2CO","11","21ⴰ","21ⴰ","ⵙⴾⵔⴾⴹⵢ ⵙ ⵍⵆⵓⵏⵏⴰ ⵏⴾⵏⵢ ⴶⴹⵍⵏⴰ ⴹⵓⵏⴶⵓ ⵔⵜⵏ ⵛⵍⵜ ⵏⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_21ⵀ","077_11_21ⵀ","2CO","11","21ⵀ","21ⵀ","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵔⵜ ⵆⵍ ⵙ ⵂⵍ ⵓⴹⵏ ⴼⵍⵙ ⴶⵓ ⵀⵔⴶ ⵏⴾ ⴹⴰ ⵂⵍⵗ ⴼⵍⵙ ⴶⵗ ⵀⵔⴶ⵰ ⵀⵜⵓ ⵜⴰ ⴶ ⴹⴰ ⵛⵍⵜ ⵏⵙ ⴶⵜ ⵎⵙⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ⴾⴹ ⴾⵍⵗⵀⵔⵢ ⵎⵙⵏ ⵏⴾ ⴹⴰ ⵎⵙⵆⵓ⵰ ⴾⴹ ⴾⵍⵙⵔⵢⵍ ⵎⵙⵏ ⵏⴾ ⴹⴰ ⵎⵙⵆⵓ⵰ ⴾⴹ ⵤⵔⵢⴰ ⵏⵀⵔⵂⵎ ⵎⵙⵏ ⵏⴾ ⴹⴰ ⵎⵙⵆⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ⴾⴹ ⵎⵛⵗⵍⵏ ⵏⵍⵎⵙⵈ ⵎⵙⵏ ⴶⵔⵆⵏ ⵜⵛⵜⵏⵜ⵰ ⵀⵜⵓ ⵜⴰ ⴶ ⴹⴰ ⵛⵍⵜ ⵏⵙ ⴶⵜ ⵎⵙⴾⵍ⵰ ⴾⴹ ⵍⵗⵤⵀ ⴶⵏ ⴶⵔⵗⵙⵏ⵿ⵜⵓ⵰ ⴾⴹ ⴾⵙⵓ ⴶⵤⵏ ⴶⵔⵆⵏ ⴶⵤⵏⵜ⵰ ⴾⴹ ⵛⵓⵜ ⵜⵓⴶⵏ ⴶⵔⵆⵏ ⵜⵓⵏ⵿ⵗⴰ⵰ ⴾⴹ ⴹⵗ ⵜⵤⴾ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴶⵤⵏ ⴶⵔⵆⵏ ⴶⵤⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ⵓⴹⵀⵏ ⵙⵎⵙ ⴹⴶⵏ ⴾⵍⵍⵢⵂⴹ ⵙⴾ ⵢⵏ ⴾⵤⵜ ⵜⵎⵔⵓⵏ ⵏ⵿ⵜⵓⵜⵢ ⴹⵗ ⵀⴰ ⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ⴾⵔⴹⵜ ⵜⵏⵆ ⴹⴶⵏ ⴾⵍⵔⵎ ⵙⵍⴾⴹ ⵜⴾⵍⵜ ⵢⵜ ⴶⵎⵢⵏ ⵢⵜⴹⵏ ⴹⵜⵏⵗⵢⵏⵏ ⴾⵔⵤ ⵙ ⵜⴶⵔ ⵏ⵿ⵜⵂⵏ ⴾⵔⴹ ⵗⵛⴹⵏ ⴹⴰ ⵜⵏⵎⵤⵔⵢ ⴹⵔⵢ ⴶⴰ ⵗⵍⵍ ⵏⵎⵏ⵰ ⴹⵙⵢ ⴹⵗ ⵙ ⴶⵗ ⵂⴹ ⵗⵔⴹⵏ ⴹⵤⵍ ⴹⵗ ⵎⵙ ⵏⴶⵔⵓ ⵀⴾⵏ ⵎⵏ ⴹⵜⵛⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ⴶⵗ ⵛⴾⵍⵏ ⴶⵜⵏⵏ⵰ ⴶⵤⵗ ⵍⵗⵔⵔ ⵏⴹⵢ ⵀⵜⵏ ⵎⵏ ⵏ⵿ⵜⵙⵙⵏ⵿ⴶⵢ ⵛⵏ ⵔⴹⵗⴰ ⵎⴹⵗ ⴶⵔⵓⵏⵢ ⵏⵔⴾⵀⵏ⵰ ⴶⵤⵗ ⵍⵗⵔⵔ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ⵿ⴹⵏⵏ ⵏ⵿ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ⵰ ⴶⵤⵗ ⵍⵗⵔⵔ ⴹⵗ ⵗⵔⵎⵏ ⴹⵙⴼⵏ⵰ ⴶⵤⵗ ⵍⵗⵔⵔ ⵏ⵿ⴹⵜⵛⵓ ⴶⵔⵓ⵰ ⴶⵤⵗ ⴹⵗ ⵍⵗⵔⵔ ⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴶⵏⵏⵏ ⵙ ⵀⵂⵓ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ ⴹⵗ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ⵤⴹⵢⵗ ⵛⵗⵍ ⵂⴰ ⵍⵗⵤⵀ ⴹⵜⵍⵓⵢⵜ ⴹⵎⴾⵔ ⵏⵜⵙ ⴶⵏ⵰ ⵤⴹⵢⵗ ⴶⵍⴾ ⴹⴼⴹ ⵢⵓⵏⴰ ⴹⵗ ⵤⵎ⵰ ⵤⴹⵢⵗ ⵜⵢⵙⵙ⵿ⵜ ⵏⵙⵎⴹ ⴹⵤⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ⴹⵢ ⴾⵜⵏⵜ ⵓⵔ⵿ⵜⵓ ⴹⴶⵤ ⵓⴰ ⴶⵗ ⴾ ⵤⵍ ⴹⵗ ⵎⵙⵏⵜ ⵜⴰ ⴶⵗ ⴹⵗ ⵍⴾⵏⵙⵜⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ⵙ ⴹⵗⵙⵏⵜ ⵔⴾⵎ ⵓⴹⵏ ⴹⴹⵙ ⵔⴾⵎⵏⵜ ⵏⴾ ⴹⴰ⵰ ⵙ ⴹⵗⵙⵏⵜ ⴹⵓⵢ ⵓⴹⵏ ⵙⵎⴹⵏⵜ ⴶⵢ ⵏⵀⴾⴹ ⴹ ⵜⵔⵗⵓ ⵜⵎ⵿ⵙⵢ ⴹⵗ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ⴾⴹ ⵛⵍ ⴼⵍⵢ ⵎⵙ ⴶⵢ ⵏⵀⵔⴶⵏ ⵓⴹⵢ ⵔⵜⵏ ⵓⵏ ⵙⴾⵏⵏ ⵔⴾⵎⵏ ⴼⵍ ⵜⵏ⵿ⵤⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ⵙⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵙ ⵓⵔⴶ ⵀⵂⵓ ⴶⵗ⵰ ⵜⵎⵍⵜ ⵙⵎⵏⵜ ⵂⵔ ⴼⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ⵍⵙ ⵓⴰ ⵤⵤⵔ ⵎⵏⴾⵍ ⵔⵙ⵿ⵜⵙ ⵢⵗⵔⵎ ⵏ⵿ⴹⵎⵙ ⴾⵍⴰ ⴹ ⵎⵔ ⵎⴹⵏ ⵙⴹ ⵀⴹⴹⵏ ⴹⵗ ⵎⵓⵏ ⵏⵗⵔⵎ ⴼⵍ ⴹⵀⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ⵎⵛⵏ ⵜⵓⴶⴰ ⴹⵗ ⵤⵎⵎ ⵤⵓⵔⵏ ⵜⵓⵙⵔⵙⴰ ⵙ ⴼⵏⵜⵔ ⵂⵏ ⵗⵍⴰ ⵓⴰ ⵗⵍⵢⵏ ⵗⵔⵎ ⴹⵔⴶⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ⵍⵤⵎⵢ ⴶⵢ ⵏⵀⵔⴶ⵰ ⴾⴹ ⵓⵔ ⵏ⵿ⴼⴰ ⴶⵏⵜ ⵓⵍⴰ ⴹⴰ ⴹ ⴶⵍⵗ ⵎⵍⵗⵓⵏ ⵔⵜⵏ ⵓⵏ ⴹⵙⴾⵏⴰ ⵎⵍⵢ ⴹⵓⵏ ⴹⵙⵏⴼⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ⵤⴹⵢⵗ ⵍⵙ ⵢⵏ ⵙⵗⵏ ⴹⵍⵎⵙⵈ ⵙ ⴾⵍⴰ ⴹ ⵎⴹⴾⵍ ⵂⵔ ⵙⴰ ⵌⵏⴰ ⵓⵏ ⵙⴰ⵰ ⵓⵔ ⵙⵏⵗ ⴾⴹ ⵜⵗⵙⵏⵜ ⵜⵎⴹⴾⵍⵜ ⴹⵏ ⵓⵍⴰ ⴹⵗ ⵎⵏⵜ ⵗⵙ ⵎⴹⴾⵍⵏⵏ ⵎⵛⵏⴰ ⵗⵙ ⵙⵏⵏ⵰ ⵍⴰ ⴹⵢ ⵎⵔⴹⴰ ⵎⵔⵓ ⵍⵏ ⴹⴾⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_3","077_12_3","2CO","12","3","4","ⵓⵍⴰ ⵙⵏⵗ ⵙ ⵍⵙ ⵓⴹⵢ ⵎⴹⴾⵍ ⵂⵔ ⵙⴰ ⵍⵌⵏⵜ ⵙⵍⴰ ⴹⵗⵙ ⵓⵍⵏ ⵙⵎⴾⵍⵍⵏⵏ ⵙ ⵓⵔ ⴼⵔⴶ ⵓⴹⵏ ⵎⵍⵏⵙⵏ ⴹⵗ ⵓⵍ ⵓⵍⵢⵏ ⵓⵍⴰ ⴹⵗ ⵈⵍⵍ ⵎⵍⵏⵙⵏ⵰ ⵓⵔ ⵙⵏⵗ ⴾⴹ ⵜⵗⵙⵏⵜ ⵜⵎⴹⴾⵍⵜ ⴹⵏ ⵓⵍⴰ ⴹⵗ ⵎⵏⵜ ⵗⵙ ⵎⴹⴾⵍⵏⵏ ⵎⵛⵏⴰ ⵗⵙ ⵙⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ⴹ ⴶⴰ ⵀⵔⴶ ⴼⵍ ⵓⴹⵏ ⵓⴹⵢ ⵎⵛⵏ ⵓⵔ ⵜⵤⴶⴰ ⴼⵍ ⵎⵏⵏ⵰ ⵔⴾⵎⵏ ⵗⵙ ⴼⵍ ⵤⴶⴰ ⵀⵔⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ⵎⵔⵏ ⴾⴹ ⵔⵗ ⴶⵢ ⵏⵀⵔⴶⵏ ⴹⴰ ⵓⵔ ⴹⴶⴰ ⴹⵢ ⵎⵙⴾⵍ ⴼⵍⵙ ⵜⴹⵜ ⵤⵏⴰ⵰ ⵎⵛⵏ ⴹ ⵎⵤⵢⴰ ⴹⴶⵏⵙⵏ ⴹ ⵓⵔ ⵔⵗ ⴹⵜⴼ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⵗ ⴹⴶ ⴶⵔⵏ ⵓⴰ ⴹⵗⵢ ⴶⵏ ⵎⵤⵍⵏⵏ ⴹⵓⴰ ⴶⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ⵙⵏⴼⵍⵍⵢ ⵎⵛⵏⴰ ⵔⵜⵏ ⴶⵏⵏ ⴹⴾⵍ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⴹⵢ ⴼⵍ ⴹⴶⴹⵍ ⴹⴾⵍ ⵏⵎⵏⵏ ⵙⴶⵢ ⵓⴰ ⴶⴰ ⴹⵗ ⵍⵎⵏ ⵛⵏⵏ ⵎⵙⵏ ⵏⵎⵤⵍ ⵏⵛⵢⵜⵏ ⴹⵤⵗⵤⵀⵏ ⴼⵍ ⴹ ⵓⵔ ⴹⴾⵍⵗ ⵎⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ⴾⵔⴹ ⴶⵎⵢⵏ ⴹⵗ ⵜⵏⵎⵤⵔⵢ ⴶⵗ ⴹⵗ ⵎⵍⵢ ⴹⵤⵎⵤⵢ ⴹⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ⵎⵛⵏ ⵏⵢ «ⵜⴶⴹⴾ ⵔⵈⵎⵜⵏ⵰ ⴼⵍⵙ ⵜⵔⵏⵏⵏ ⵔⴾⵎ ⴹⵗ ⵜⵜⴶⵓ ⵏⴼⵍⵍ ⵓⴰ ⴾⵎⵍⵏ⵰» ⴹⵗ ⴹⵢ ⵙⴹⵓⵜⵢ ⴶⵢ ⵏⵀⵔⴶⵏ ⴼⵍ ⵔⴾⵎⵏ ⴼⵍ ⴹⵗⵢ ⵜⵤⴹⵗ ⵜⵔⵏⴰ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ⴹⵢ ⴼⵍ ⴹⵙⴹⵓⵜ ⵔⴾⵎ ⴹⵜⵔⵀⴹ ⴹⵍⵗⵤⵀ ⴹⵜⵓⴹⴶⵤ ⴹⵜⵎⵗⵜⵔ ⴼⵍ ⴹⵍⵍ ⵏⵍⵎⵙⵈ⵰ ⴼⵍⵙ ⵍⵓⵆ ⵓⴹ ⵔⴾⵎⴰ ⵏ⵿ⵜⴰ ⴹⵗ ⵙⵂⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ⵜⵛⵂⵛⵍⵎⵢ ⵎⵤⵍ ⵎⵙⵏ ⴶⵢ ⵏⵀⵔⴶⵏ ⵙ ⵎⵙⴾⵍ ⵗⵙ ⵜⵜⴶⵏ⵰ ⵏ⵿ⵜⴰ ⴾⵓⵏⵢ ⵙ ⵂⵔ ⴼⵍⵢ ⵜⵙⵏⵎⵍⵎ ⴼⵍⵙ ⴾⴹ ⵓⵔ ⵎⵙⵗ ⵔⵜ ⴹⴰ ⵓⵔ ⴹⴶⵔⵏ ⵏⵎⵤⵍⵏⵓⵏ ⵓⵔ ⵏⵍⴰ ⵜⵍⵜ ⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ⵍⵗⵍⵎⵜⵏ ⵏ⵿ⵜⵛⵜⵏ ⵏⵎⵤⵍ ⵓⵏ ⵜⴹⵜ ⵜⵓⴶⵏⵜ ⴶⵔⵓⵏ ⴹⵓⵏⵜ ⴹⵤⵎⵔⵜ ⴶⴰ ⵓⵏ ⵙⵍⵗⵍⵎⵜⵏ ⴹⵜⵌⵌⵀ ⴹⵜⵍⵎⵗⵌⵌⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵗⵔⵓⵏ ⵓⵔ ⴶⵗ ⵙ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵂⴹⵜⵏⵏ ⴶⵆⵓ ⵗⵔⵙⵏⵜ ⵜⵎⵙⵏ ⵙ ⵓⵔ ⴹⵗⵓⵏ ⴶⵎⵢⴰ ⵜⴹⵂⵍ⵿ⵜ ⵓⵍⵢⵜ⵰ ⵙⵔⴼⵜⴹ ⵔⴾ ⵎⵤⵍ ⵓⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ⵎⵔⴹⴰ ⵙⵎⵜⴶⴰ ⵢⴹⵓⵏⵏⴶⵗ ⵙⴰ ⵓⵏ ⴾⵔⴹ ⵎⵔⵏ ⵓⵔ ⴹⵓⵏ⵿ⵤⵆⵍⵗ ⵤⴾ⵰ ⴼⵍⵙ ⵓⵔ ⴶⵎⵢⵗ ⵓⴰ ⵜⵍⵎ ⴾⵍⵔ ⴾⵓⵏⵢ ⴶⵎⵢⴰ⵰ ⵓⵔⴶⵗ ⵀⵔⵔⵏ ⵓⵔ ⴹ ⵙⵏ⵿ⵙⵏ ⵔⵜ ⵢⵏ ⵢ ⵎⵔⵓⵏⵙⵏ ⴾⵍⵔ ⵎⵔⵓⵏ ⵓⵔ ⴹ ⵙⵏ⵿ⵙⵏ ⵔⵜ ⵢ ⵀⵔⵔⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ⵏⴾ ⵤⴰ ⵙⴹⵓⵜⵢ ⴼⵍⵓⵏ ⴾⴼⴰ ⵜⵍⵏⵏ ⴾⵍ ⴾⴼⴰ ⵂⵔⴾⴹ ⵎⵏⵏ ⴼⵍ ⴹⵍⵍⵏⵓⵏ⵰ ⵓⴾ ⴹⴰ ⴹⵓⵏⴶ ⵜⵔⴰ ⵜⴶⴹⵜ ⴹⵓⴰ ⴹ ⴼⵏⵤ ⴹⵢ ⵜⴰ ⴹⵜⴶⵎ ⴾⵓⵏⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ⵜⵙⵏⵎ ⵙ ⵓⵔ ⴹⵓⵏⵎⵙⵗ ⵤⴾ ⵎⵛⵏ ⵜⴶⵏⵎ ⵎⴾⵔⵙ ⵎⵙⵗ ⴶⵆⵜ ⴹⵗⵓⵏ ⵙ ⵜⴾⵔⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ⵎⵏⵢ ⵜⵎⵓⵜ ⵜⵙ ⴾⵓⵏⴾⵔⵙⵗ⵰ ⵓⴾ ⵢⵏ ⴹⵗ ⵎⴹⵏ ⵓⵏ ⴾⵓⵏⵏⵙⴾⴰ ⴹⵗⵓⵏ ⵜⵛⵏ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ⵏⴾ ⵏ⵿ⵙⵢⵏ ⵜⵜⵙ ⴶⵎⵢⴰ ⴹⵗⵙ ⴾⵓⵏⵏⴾⵓ ⵛⴹⵓⵆⵏ ⴹⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⴹⵏ ⵓⴰ ⵜⵤⴹⵢⵎ⵰ ⵓⴾ ⵔⵜ ⵢⵏ ⴹⵗⵓⵏ ⵜⵛⴰ ⵜⵜⵙ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵏⴾ ⴹⵔⵙ ⵜⵔⵢⵜ ⵢⴹⴰ ⵙ ⵏⵍⴾⵎ ⵙⵏⵢⵜ ⵢⴹⴰ⵰ ⵓⴾ ⵓⵔⴶⵗ ⵍⵎⵙⵍ ⵢⵏ⵿ⴹⴰ ⵙ ⵏⵍⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ⵓⴾ ⵜⴹⵎⴰ ⵜⴶⵎ ⵓⵍ ⴾⵜⵏⵜ ⵓⴰ ⴶⵗ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⴶⵎⵢ ⵙⵔⵙ ⵏⵜⴶⵓ ⴶⵤ ⴹⵗⵓⵏ ⵎⵏⵏⴰ⵰ ⴾⵍⴰ⵰ ⴹⵜ ⵎⵛⵏⴰ ⴹ ⵏⵛⵓⵍ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵙⵆⵏⵏⴰ ⴹⵍⵎⵙⵈ⵰ ⵎⵔⵏ ⵎⵔⵏⵏⴰ ⵙⵏⵜ ⵙ ⵔⵜ ⴾⵍ ⵓⴰ ⵏⵜⴶⵓ ⵜⵏ⵿ⴼⵏⵓⵏ ⴼⵍ ⵜⵏⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ⴾⵙⴹⵗ ⴾⵓⵏⵏⵙⴰ ⵓⵔ ⴶⵎⴰ ⵜⵗⵔⵏⵓⵏ ⴾⵓⵏⵢ ⴹⵗ ⵓⵔ ⵜⴶⵎⵎ ⵜⵏⵏ⵰ ⴾⵙⴹⵗ ⵙ ⵎⵌⵙ ⵍⵏⵜⵓ ⵜⵎⵤⵗⵏ ⴶⵔⵓⵏ ⴹⵎⵏ⵿ⵌⵗ ⴹⵛⵔ ⴹⵤⴶⵏ ⴹⵜⵏⵓⵏ ⴹⴹⴾⵍ ⵏⵎⵏ ⴹⵜⵏⵌⵔⵓⵢⵜ ⵓⵔ ⵜⴶⵎⵢⵎ ⵔ ⵜⵏ⵿ⴼⴰ ⵏⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ⴾⵙⴹⴰ ⴹⵗ ⴾⵓⵏⵏⵙⴰ ⵍⵙⵢ ⵎⵍⵏⵏ ⵎⵛⵏⴰ ⵤⵀⵤ ⵏ⵿ⵜⴾⵔⴾⵜ ⵗⵔⵓⵏ⵰ ⴾⵙⴹⵗ ⴹ ⵗⵛⴹⵏ ⵎⵏⵏ ⴼⵍⵙ ⵓⵢⴹ ⴹⵗⵓⵏ ⴶⵜⵏⵏ ⵓⵔ ⵏⵎⵤⵢ ⴹⴶⵢ ⵏⵀⴾⴹⵏ ⵓⵏ ⵙ ⴾⵍⴰ ⵜⵏ⵿ⵜⴶⵏ ⵓⵔ ⵜⵀⵏ ⴹⵗ ⴹⵗ ⴶⵢ ⵏⵎⵤⵍⵏ ⵙⵎⴹⵙⵏⵏ ⵓⵏ ⵜⴶⵏ ⴹⴶⵢ ⵏⵤⵏⴰ ⴹⵎⵤⵍⵏ ⵤⵤⵍⵜⵏⵏ ⵓⵏ ⵜⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ⴾⵏⵏ ⵢⵓⵏ ⵓⵏ ⴾⵔⴹ ⵓⴰ⵰ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵜⵗⵜⵙ⵿ⵜ ⴾⵍ ⵜⴶⵢⴰ ⵏⵛⵏ ⵢⵜⴹⵏ ⵎⴹⵗ ⴾⵔⴹ ⵜⵜⵙⵙⵂⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ⵗⵔ ⵙⵏⵏ ⵢⵓⵏ ⵓⵏ ⵛⵏ ⵙⵏ⵿ⴾⴹⵗ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⵓⵔ ⵏⵎⵤⵢ ⴹⴶⵢ ⵏⵀⴾⴹⵏ ⵏ⵿ⵜⵏⵢ ⴹⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ⵙⵏ⵿ⴾⴹ ⵤⴰ ⵓⴹⵢ ⴹⴰ ⴹⵓⵏⴶⵗ ⵎⵔⴹⴰ ⵂⵔⵓⴰ ⴹⴰ ⴶⴶⴰ ⵙ ⵙ ⴾⵓⵏⵏⵙⵗ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵜⴶⵏ ⵀⴾⴹⵏ ⵙ ⵤⵆⵎⵏ ⵓⵔ ⵓⴹⵀ ");
INSERT INTO ttqt_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ⴹⴹ ⵤⵎⵙ ⵜⴶⵎⵢⵎ ⴹⵓⵏⵜⴹⵓ ⵙ ⵍⵎⵙⵈ ⵙⵔⵢ ⵛⵓⵍⵏ⵰ ⵎⵔⵏ ⵍⵎⵙⵈ ⵓⵔ ⴾⵓⵏⵙⴾⵏⴰ ⵀⴰ ⵏ⵿ⴼⵔⴶⵜ ⵏⵔⵜ ⴾⵍⵔ ⵙⴾⵏⵓⵏ ⵜⵍⵜⵏⵜ ⵜⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ⴼⵍⵙ ⵍⴾⵏ ⵙ ⵔⴾⵎ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⵜⵓⵜⵢⵜⵢ ⴼⵍ ⵜⴶⵜⵓⵜ ⵎⵛⵏ ⴹⵔⴹⵓ ⵙ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ⵰ ⵍⴾⵏ ⴹⵗ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵔⴾⵎ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵎⵛⵏ ⵙ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⴹ ⵏⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⴶⴰ ⵍⵎⵙⵈ ⴼⵍ ⴹⵍⵍ ⵏⵛⵗⵍⵏ ⵓⵏ ⴹⵓⵏⵜⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","ⵛⴶⵔⵜ ⵎⵏⵓⵏ ⵜⵙⵏⵎ ⴾⴹ ⵜⴹⵜ ⴹⵗ ⵙ ⵜⵤⴶⵤⵏⵎ⵰ ⵔⵎⵜ ⵎⵏⵓⵏ⵰ ⵓⵔ ⵜⵙⵏⵎ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵂⴰ ⵎⵏⵓⵏ⵰ ⵎⵗ ⵤⴶⵤⵏⵓⵏ ⵓⵔ ⵏⵤⵎⵔ ⵢ ⵛⴶⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ⵎⵔⵏ ⴶⵗ ⵜⵎⵏⵏ ⴹⵗ ⵙ ⴹ ⵜⵏⵢⵎ ⵜⵔⴹⵎ ⴹⵗ ⵙⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵏ⵿ⵌⵈ ⴹⵗ ⵛⴶⵔⴰ ⵓⴹⵢ ⵙⴾⵏⵗ ⵙ ⵏⴾⵏⵢ ⵏⵎⵤⵍ ⵓⵏ ⵜⴹⵜ ⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ⵏⵜⵜⵔ ⵙ ⵎⵛⵏⴰ ⴹⵓⵏⴶⴹⵍⵏ ⴶⵢ ⵏ⵿ⵜⴾⵎⴰ ⵓⵍⵢⵜ⵰ ⵓⵔ ⴹⵓⵏⵜⵜⵔ ⴼⵍⵙ ⵏⵏ⵿ⵌⵈ ⴹⵗ ⵛⵗⵍ ⵓⴰ ⵗⵔⵓⵏ ⵏⴶⴰ ⴾⵍⵔ ⴼⵍ ⵜⵔⴰ ⵏⴹ ⵜⴶⵎ ⵓⴰ ⵍⵗⵏ ⴾⴹⵗ ⵙ ⵜⵓⵜⴼ ⵙ ⵏⴾⵏⵢ ⵓⵔ ⵏⵏ⵿ⵌⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ⴼⵍⵙ ⵓⵔ ⵏⴼⵔⴶ ⵎⵤⵔⵢ ⵏ⵿ⵜⴹⵜ ⴾⵏ⵿ⴹⵀⴰ ⵗⵙ ⵜⵀⴹⵢ ⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ⵙⴼⵍⵓⵙⵏⴰ ⵔⴾⵎ ⵓⴰ ⵏⴶⴰ ⵏ⵿ⵜⴰ ⴾⵓⵏⵢ ⵜⵙⵂⵎ⵰ ⵓⵍⴰ ⵏⵜⵜⵔ ⴾⵏⵏ ⵜⵀⴹⵢⵏⵓⵏ ⴹⵗ ⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ⴹⵢ ⴼⵍ ⴹⵓⵏⵏ⵿ⴾⵜⵀⴰ ⵂⵔⵓⴰ ⴹⴰ ⴶⴶⵆⵓⵏ ⴼⵍ ⴹ ⵓⵔ ⴹⵔⵔⴰ ⵙⴹⵓⵏⴶⴰ ⵔⵗⵎⵜⵏ ⵙⵙⵏⵏ ⵙ ⴾⵓⵏⵏⵙⵗ ⴼⵍⵙ ⵜⵏⵢⴰ ⵜⴰ ⴹⴾⴼⴰ ⵎⵍⵢ ⴼⵍⵓⵏ ⴾⴼⵜⵜ ⴼⵍ ⴹ ⵛⵗⵍⴰ ⴹⵗ ⵏⵎⴹ ⵓⴰ ⴾⵓⵏ⵿ⵤⵙⴾⵏ ⴼⵍⴰ ⵓⵔⴶⵗ ⵓⴰ ⴾⵓⵏ⵿ⵤⵌⵀⵔⵌⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ⵎⵔⴹⴰ ⵎⴹⵔⵢⵏⵏ ⴼⵍⵓⵙⵜ⵰ ⵆⵍⵜ ⵢⵜⴹⵏ ⴾⵎⵍⵏⵏ⵰ ⵜⵏⵎⴶⵏⵏ ⵏⵙⵈⵜⵏ⵰ ⵜⵏⵎⵏⴾⵎ ⴶⵔⵓⵏ⵰ ⵎⵍⵜ ⵍⵈⵔ ⴶⵔⵓⵏ⵰ ⴹⵢ ⴹⵗⵓⵏ ⵙⵏ ⵎⵛⵏⴰ ⴹⵢ ⵂⴾⵏ ⵜⵔⴰ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ⵜⵏⵎⴶⵜ ⵙⵍⵎ ⵤⴹⴶⵏ⵰ ⵂⵍⵏ⵿ⴾⵓⵏⵏ ⵎⵤⴹⴶⵏ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴾⵓⵏⴾⴼⵏ ⴾⵜⵏⵓⵏ ⵔⵈⵎⵜ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵜⵔⴰ ⵜⵏ ⵎⵛⵏⴰ ⴹⵜⵙⵆ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","ⵛⵔⵓⵜ ⴹⵏ⵿ⵜⴼⵍⵜ ⵀⵍⵙ ⵎⵙⵏ ⵏⵎⵤⵍ ⴹⵓⵔⵤⵎⵤⵍⵏ ⵢⵜⴹⵏ ⵓⵍⴰ ⴹⵗ ⵤⵎⵤⵍ⵿ⵜⴹ ⵓⴹⵏ ⵓⵍⵢⵏ⵰ ⴾⵍⵔ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵙⵏ⵿ⵜⴰ ⴹⵙⵏ⵿ⴾⵔⵏ ⵗⵢⵙⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵏⵜ ⴹⴹⵤⵎⵤⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ⵏⵂⵍⵏ ⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵏⴾⵍ ⵏ⵿ⴶⵍⵜⵢⴰ ⵏⴾ ⵂⵔⴾⴹ ⵎⴹⵔⵢⵏⵏ ⵓⵏ ⵗⵔⵢ ⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ⴶⵓⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⴾⴼⵏ ⵎⵏⵜ ⴼⵍ ⴹⵏⵗⴶⵤ ⴹⵗ ⵀⴾⴹⵏⵏⴰ ⵗⵍⵙⵏⴰ ⴹⵗ ⴹⵗ ⵜⵍⵀⵙ⵿ⵜ ⵏⴹⵏⵜ ⵜⵏ ⵎⵔⴹⴰ ⵏⵎⵏⴾ ⵓⵏ ⴹⵜⵔⴰ ⵏⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ⵍⵏ ⵜⵏⵢⴰ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ⵆⵏⵢ ⵗⴼ ⵓⵍⵏ ⵙⵜⵔⵀ ⵓⴰ ⵜⴶⵎ ⴶⵎⴹ ⵏⵀⵜⵓ ⵏⵓⴰ ⴾⵓⵏ⵿ⴹⵗⵔⵏ ⵙ ⵜⵔⵢⵜ ⵏⵔⵈⵎⵜ ⵜⴰ ⴹⵓⵢ ⵍⵎⵙⵈ ⵜⵍⴾⵎⵎ ⵢⵍⵏ⵿ⵌⵍ ⵢⵏ ⵏⵀⵂⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ⵙⵏⵜ ⵙ ⵓⵔ ⵜⵍⴰ ⵍⵏ⵿ⵌⵍ ⵓⵍⵢⵏ ⵔ ⵓⴰ ⴹⵓⵏⵎⵍⴰ⵰ ⵢⵜⴹⵏ ⵗⵙ ⵜⵍⵏⵏ ⴾⵓⵏⵛⵓⵛⵏⵏ ⵙⴼⵔⵗⵏ ⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ⵎⵔⵏ ⵢ ⴶⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵔ ⵏⵎⵙ ⵓⵏ ⴹⵓⵏⴶⴰ ⴶⵔ ⵏⴾⵏⵢ ⵎⵏⵏⴰ ⵓⵍⴰ ⵏ⵿ⴶⵍⵙ ⴹⴼⵍⵏ ⵌⵏⵓⵏ ⵓⴹⵢ ⵜⵓⵍⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ⵔⵜ ⵓⴰ ⵏⵗⵓⵏ⵿ⵜⵓ ⴾⵍⴰ ⴹⴰ ⵎⵔⵏ ⴹⵓⵏ⵿ⵜⵍⵙⴰ ⵜⵏⴰ ⵎⵔⴹⴰ ⵙ ⴹⵓⵏⴶⴰ ⵓⴹⵏ ⵢⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵔ ⵏⵎⵙ ⵓⵏ ⵙ ⵜⵙⵍⵎ ⵜⵆⵀⵍⵎ⵿ⵜⵏ ⵓⴹⵢ ⵜⵓⵍⵗⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ⵎⴰ ⵜⵏⵎ ⵓⴾ ⵎⵔⴹⴰ ⵢⵜⴹⵏ ⴹⵗ ⴶⵎⵢⴰ ⵙⵗⵎⵔ ⵎⵗ ⵎⵛⵏⴰ⵰ ⵓⴾ ⵢⵜⴹⵏ ⵙ ⴶⵎⵢⵗ ⴹⵙⵏⴶⵔⵤⴰ⵰ ⵏⵔ ⵂⵔⵓⴰ ⴹⴰ ⴶⵎⵢⴰ ⴹⵔⵏ ⵢⵜⴹⵏ ⵓⵔ ⵤⵆⵍⵗ ⴾⵍⵢ ⵗⵀⴹⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ⵔⵜ ⴹⴰ ⵓⵙ ⵔⵗ ⴹⵗⵙ ⵜⵙⵏⵎ ⵎⴹⵔⵢⵏⵏ ⵍⵏ⵿ⵌⵍ ⵓⴰ ⵎⵍⴰ ⵓⵔ ⴹⴼⵍ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ⴼⵍⵙ ⵏⴾ ⵎⵏⵏ ⴹⴰ ⵓⵔⴶⵗ ⴶⴹⵎ ⴹⵜⴾⴼⵏ ⵓⵍⴰ ⴹⵗ ⵙⵙⵗⵔⵜⵓ⵰ ⴾⵍⵔ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵏⵜ ⵙ ⴹⵜⵙⵏⴼⵍⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ⴶⵏ ⴹⴰ ⵜⵙⵍⵎ ⵍⵈⵍⵏ ⴹⵜ ⵓⴰ ⵂⵔⵓⴰ ⴹ ⵂⵗ ⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ⵰ ⵤⵎⵏ ⴹⵢ ⴾⵏⵗ ⵓⵍⵏ ⵙⵙ ⵏⵍⴾⵏⵙⵜ ⵏⵎⵛⵏⴰ ⴶⵎⵢⴰ ⴹⵂⵍⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","ⵂⵔⵓⴰ ⴹ ⵂⵗ ⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵔⵗ ⴾⵍ⵿ⵜⵓⵛⵜⵏ ⴶⵜⵏⵏ ⵓⵏ ⵌⵢⵜⵏⵏ ⴹⴶⵤ ⴹⵗ ⴹⵏ ⴼⵍⵙ ⴶⵍⵢⵜ ⵜⴶⵜ ⴶⵗ ⴹⵗ ⵍⴾⵎ ⵢⵍⵗⴹⵜ ⵏⵎⵔⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","17","ⵎⵛⵏⴰ ⴹⵙⵏⴼⵔⵏⵏ ⵂⵔⵓⴰ ⴹⴰ ⵂⵗ ⵜⴹⵙ⵿ⵜ ⵏⵏⵏⵏ ⵗⵔⵢ ⴹⵗ ⵙⵔⵈⵎⵜⵏⵜ ⵢⴹ ⵜⵗⵀⴹⴰ⵰ ⵎⵔⵏ ⵙⵗⴰ ⵓⴰ ⴹⵙⴶⵔⵤ ⴹⵙⵏⴼⵍⵍ ⵀⵔⵔⵏⵜ ⴼⵍ ⴹ ⵎⵍⵗ ⵙⵍⵏⵜ ⵜⵏⵎⵙⵏ ⵍⵏ⵿ⵌⵍ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵗⴰ ⵓⴹⵢ ⴹⵗ ⴹ ⴾⵗ ⵔⵀⵢⴰ ⴹⴼⵔ ⴹⵢ ⵆⵍⴹⵓ ⴹⵎⵙ ⴹⴰ ⵓⵔ ⵛⵓⵔⵗ ⵓⴹⵏ ⵓⵍⵢⵏ ⵤⴰ ⵓⵔ ⴶⵤⵢⴰ ⵙ ⵢⵔⵙⵍⵎ ⵢⴹ ⵙⵎⵔⴰ ⵜⵏⵜ ⵎⴹⵏ ⵓⵏ ⴹⵤⵔⵏⵏ ⵜⵛⵜ ⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ⵙ ⴶⵗ ⴾⵔⴹ ⵍⵏ ⴹⴼⵔ ⵓⵏ ⴾ ⵢⵔⵙⵍⵎ ⴼⵍ ⴹ ⵎⵏⵢⵗ ⴹⵆⵢⴼⵙ ⵏⵎⵤⴹⵢⴰ ⴹⵔⵙ ⴶⵗ ⵗⵔⵙ ⵎⵔⵓ ⴹⵏ ⴹⵙⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ⵓⵔ ⵏⵢⴰ ⵓⵍⵢⵏ ⴹⵗ ⵏⵎⵤⵍ ⵓⵏ ⵂⴹⵜⵏⵏ⵰ ⵢⵆⵀ ⵓⵏ ⵎⴹⵔⵢ ⵏ⵿ⵗⵢⵙⴰ ⴹⵢ ⵏⵎⵍⵏⵏⴰ ⵗⵙ ⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ⵙⵍⴾⵏⵗⵓⵏ ⴹⵜ ⵎⵛⵏⴰ ⵙ ⵙⵍⵏ ⵓⵏ ⴹⵓⵏⵏ⵿ⴾⵜⵀⵗ ⴹⴰ ⵓⵔ ⵎⵙⵏ ⵀⵂⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ⴶⵎⴹⴰ ⵢⵔⵙⵍⵎ ⴾⵗ ⵎⴹⵍ ⵓⵏ ⵙⵔⵢⴰ ⴹ ⵓⵏ ⴾⵍⴾⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ⵍⵓⵆ ⵓⴹⵢ ⵢⵜⴹⵏ ⵏⵍⴾⵏⵙⵜⵏ ⵛⵏ ⵢⵂⴹⵢⴰ ⵓⵔ ⴹⵤⴹⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ⵙⵍⵏ ⵗⵙ ⵙ «ⵍⵙ ⵓⵏⴹ ⴹⵏⵗⴾⵏⵏ ⵙⵙ ⴹⴰ ⵎⵔⴹⴰ ⵜⴶⵓ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵙ ⴾⵍⴰ ⴹ ⵔⴰ ⵌⵀⵔⵌⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ⵔⵜ ⵓⵏ ⵓⵢⴹⵓ ⵙⵔⵙⵏ ⴶⵢ ⵏ⵿ⵜⵎⵍⵏ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ⵙ ⴶⵏ ⵎⵔⵓ ⵍⵏ ⴹⴾⵤ ⴹⴼⵔ ⵓⵏ ⵍⵙⴰ ⴶⵤⵢ ⵙ ⵢⵔⵙⵍⵎ ⵏⴾ ⴹⵀⵔⵏⵀⵙ ⴹⵓⴰ ⴹⵗ ⴹⵜⵜⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ⵎⵛⵏⴰ ⴹⴹⵙⵏⴼⵍⵍⵏ ⵙ ⵓⵔⵢ ⴾⵢ ⵏⵢⵔⵙⵍⵎ ⵢⴹⵗⵙ ⵎⵍⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⵜⴶⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⵔⵜ ⵓⵏ ⵎⵔⵏ ⴾⵏⵆⵓ ⵓⵍⵏ ⵎⵍ ⵢ ⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⵏⵢⵔⵙⵍⵎ ⵓⵏ ⴶⵔⵏⵏ ⵜⵓⵙⵗⵎⵔ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏⴹ ⵀⵏⵏ ⵛⵗⵍ ⵓⴰ ⴶⵗ ⴹⵓⴰ ⵤⴶⴰ ⴹⴼⵔ ⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ⵆⵀⵍⵏⵢ ⵏⴾ ⴹⵜⵜⵙ ⴹⵔ ⴹⵓⴰ ⵎⵙⵏ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵏⵏ ⵙⵎⵏ⵿ⴾⴹ ⴹⴰ ⵓⵔ ⵎⵏ⵿ⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ⵓⵏ ⵓⵔ ⵜⴶⴹⵍ ⴶⵤ ⵓⴰ ⴹⵏⵗⴶⵏ ⵎⵤⴶⵤⵏ ⵏⵀⵂⵓ ⵓⵔ ⵏⵎⵙ ⵔⵜ ⴹⵗⵏⴰ ⴾⵍⵔ ⴶⵤ ⵗⵙ ⴹⵏⴹⴶⵏ ⴼⵍ ⴹ ⵙⵏⵏ ⵎⴾ ⵓⵙ ⵏⵛⵛⵗⵍ ⵜⴹⵔⴼⵜ ⵜⴰ ⴹⵏⵗⴾⴼⴰ ⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ⵔⵏ ⴹⵏⵗⵙⵗⵍⵏ ⴾⵍⵓ ⵓⴰ ⵏⴶⴰ ⴹⵗ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵏ ⵓⵔ ⴹⵙⵏⴶⴰ ⵓⵍⴰ ⵔⵜ ⵏⵎⵤⵢ ⵏ⵿ⵜⵔⴹⵓⵜ ⵙⵓⴰ ⵔⵏ⵰ ⵔⵜ ⵓⵏ ⵏⴶⵢ ⴼⵍ ⴶⵤ ⵢⵓⵏ ⵜⴹⵜ ⵜⵏ ⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ⵢⵜⴹⵏ ⵎⵔⵏ ⵓⵏ ⴶⵔⵏⵏ ⵜⵓⵙⵗⵎⵔ⵰ ⵓⵔ ⵤⵍⵢⴰ ⴹⵗ ⵓⵙ ⴾⵍⴰ ⴹ ⵜⵎⵙⵏ ⵎⵛⵏⴰ ⵓⵔ ⵜⴶⵓ ⵜⵎⵔⵜ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵜⵓⵙⵗⵎⵔⵏⵏ ⵏ ⵓⵔ ⴹⵛⵂⵛⵍⵏ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ⴾⵍⵔ ⴶⵔⵏⵏ ⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵜⵓⴶⵏ⵿ⴹⵓ ⴹⵗ ⴼⵙⵏ ⵢⵜⵏⵎⵍⴰ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵜⵓⴶⵏ ⴹⵗ ⴼⵙ ⵏⵀⵜⵔⵙ ⵢⵜⵏⴶⵓ ⵢⵢⵜⴹⵏ ⵓⵏ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ⵎⵛⵏⴰ ⴾⴼⴰ ⵀⵜⵔⵙ ⴼⵔⴶⵜ ⵏⴹ ⵆⵍ ⵏⵎⵤⵍⵏⵜ ⵙ ⴾⵍⵍⵢⵂⴹ ⵏⴾ ⵎⵔⵏ ⴾⴼⵢ ⴼⵔⴶⵜ ⵏ⵿ⵜⵛⵜ ⵏⵏⵎⵤⵍⵏⵜ ⵙⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ⵢⵆⵀ ⴹⵆⵢⴼⵙ ⴹⵢⵈⵢⴰ ⵜⵓⵙⵏⵏ ⴹⵗ ⵜⵛⵜ ⵏ⵿ⵜⴶⵜⵓⵏ ⵏⵍⴾⵏⵙⵜ ⴶⵔⵏⵏ ⵔⵈⵎⵜ ⵜⴰ ⴹⵜⵜⵓⴶⵜ ⵆⵀⵍⵏⵏⴰ ⵏⴾ ⴹⵀⵔⵏⵀⵙ ⵙⴾⵏⵏⵏⴰ ⵜⵙⵆ ⵜⴰ ⴶⵔ ⵎⴹⵔⵢⵏ⵰ ⵎⴾⵏ ⴹⴰ ⵙ ⵆⵀⵍⵏ ⵙ ⵏⴾⵏⵢ ⴹ ⵏⴾⵓ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⴾⵏ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ⴶⵎⵢⵏ ⴹⵗⵏⴰ ⵗⵙ ⴹ ⵏⴾⵜⵓ ⵛⵍⵆⵓⵏ⵰ ⵔⵜ ⵓⵏ ⵎⵔⵏ ⵏⴾ ⴹⴶⵤⴰ ⴹⵗ ⴶⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ⵎⵛⵏ ⵙⵗⴰ ⵓⴰ ⴹⵙⴰ ⵆⵢⴼⵙ ⵗⵔⵎ ⵏⵏ⵿ⵜⵢⵈⵢⴰ ⵛⵓⵍⴰ ⴼⵍⵙ ⴹⵎ ⵙⴹⵎ ⴹ ⵜⴹⵜ ⵓⵔ ⴶⴰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ⴼⵍⵙ ⴹⵜ ⵙⴰ ⵏⵢⵜⴹⵏ ⵓⵔ ⵏⴶⵜ ⵓⵏ ⴹⵛⴾⵍⵏⵏ ⵗⵔ ⵢⵆⵀ ⴹⵔⵓ ⵎⵏ⵿ⵙⵓⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ⵎⵛⵏ ⵙ ⵜⵏⵙⵏ ⵢⵜⴹⵏ ⵓⵏ ⴶⵤ ⵛⵏ ⵏⵓⵔ ⵏⴶⵏⴰ ⴼⵍ ⵜⴾⵙⴹⴰ ⵏⵍⵎⵙⵈⵜⵏ ⵓⵏ ⵙ ⵍⵙⵍⵏⵙⵏ ⴾⵍⵍⵢⵂⴹ ⵤⵤⵓⵜⵏⵏ ⴹⵗ ⵍⵗⴹⵜⵏ ⵏⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⵂⴹⵜⵏⵏ ⵏⵍⵎⵙⵈⵜⵏ ⵏ⵿ⵜⵏⵢ ⴹⴰ ⴶⵏ ⵓⵏ ⴹⴰ ⵗⵀⵔⵏ ⵔⵜ ⵓⵙ ⵤⴶⵤⵏⵏ ⵤⵏ ⵓⴰ ⴶⴰ ⵆⵢⴼⵙ ⵂⵔ ⵙ ⵀⵔⵏⵀⵙ ⵎⵏⵜ ⴹⴰ ⵍⴾⵎ ⵢ ⵜⵎⵏⴼⵆⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ⵎⵛⵏ ⵙⵗⴰ ⵓⴹ ⵏⵢⵗ ⵙ ⵓⵔ ⵤⵍⵍⵗⵏ ⴹⵗ ⵍⴾⵎ ⵢ ⵜⵔⵢⵜ ⵏ⵿ⵜⴹⵜ ⵜⵏ ⵍⵏ⵿ⵌⵍ ⵏⵗ ⵢ ⵆⵢⴼⵙ ⴹⵜ ⵎⴹⵔⵢⵏⵏⴰ ⴾⵍ «ⴾⵢ ⵓⵙ ⵎⵙ ⵍⵙⵍⵏⴾ ⴶ ⵍⵢⵂⴹ ⵜⴶⵗ ⵜⵎⴹⵔ⵿ⵜ ⵜⵍⵜ ⴹ ⵜⵏ ⵓⴹⵏ ⵓⵔ ⵏⵎⵙ ⵢⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵜⵢⵗ ⵜⵔⵢⵜ ⵜⵏ ⵜⵓⵔⵜ⵰ ⴹⵗ ⴹⵢ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵛⵂⵛⵍⵗ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵍⴾⵎ ⵢⵍⵗⴹⵜⵏ ⵏⵜⵓⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ⵏⴾⵏⵢ ⵙ ⵎⵙ ⵍⵙⵍⵏⵏⴰ ⴾⵍⵍⵢⵂⴹ ⵓⵔ ⵏⵎⵙ «ⵏⵙⵀⴾⴹⵏ» ⵛⵍⴰ ⵏⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵙⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⴶⴹⵎ ⵓⵔⴶⵗ ⵍⴾⵎ ⵢ ⵜⵔⵢⵜ ⵜⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵜⵂⴾⵏ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ ⴾⵍⵔ ⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵓⵏ ⴹⴰ ⴼⵍ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵜⵆⵜ ⵙⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵓⵔⴶⵗ ⵙ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ⵓⵍⴰ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⵓⵍⵢⵏ ⵤⴶⵔⵓⵏ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ ⵙ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ⵎⵛⵏ ⵙ ⵎⵙ ⵙ ⴹⵗ ⴶⵎⵢ ⵓⴰ ⵏⵜⴶⵓ ⵜⵆⵜ ⵙ ⵜⵔ⵿ⵜⵢⵜ ⵏⵍⵎⵙⵈ ⵜⵓⵏⵢⴹⵓ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⵏⵜⴶⵓ ⵀⴾⴹⵏ ⵓⵏ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⵗ ⴹⵢ ⵍⵎⵙⵈ ⴹⵏⵗⵍⵍⵏ ⵙⴶⵢ ⵏⵀⴾⴹ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵓⵔ ⵍⴾⵎ ⴹ ⴶⴰ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ⵙ ⵍⵙⵗ ⴾⵔⵙ ⵏⵓⴰ ⵌⵀⵔⵌⵗ ⵜⵎⵙⵏ ⵜⵔⵢⵜ ⵜⵏ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹ ⵙⵏⴼⵍⵍⵗ ⵙ ⵏⴾ ⵏⵎⵤⵔⵢ ⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ⵏⴾ ⵙⵀⵀ ⵏⵛⵔⵗⴰ ⴼⵍ ⵎⵤⵢⵗ ⴹⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵂⴾⵓ ⵛⵔⵗⴰ⵰ ⵔⵜ ⵓⵏ ⴾⵍ ⴶⴰ ⴼⵍ ⴹ ⵆⵍ ⵙ ⵜⵎⴹⵔ⵿ⵜⵏ ⵜⵔ⵿ⵜⵢⵜ ⴹⵎⵛⵏⴰ ⴹⵗ ⵜⴶⴰ⵰ ⵏⴾ ⵀⵢ ⴼⵍ ⵜⴶⵜⵓⵜ ⴹⵓⵗ ⴹⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ⴹⵔⴰ ⵎⵛⵏ ⵀⵙ ⵎⵙ ⵙ ⵏⴾ ⴹⵔⵏ ⴾⵍⵔ ⵍⵎⵙⵈ ⴹⵔⵏ ⵂⴰ ⵎⵏⵏ⵰ ⵎⵔⴹⴰ ⵜⵎⴹⵔ⵿ⵜⵏ ⵜⵏ ⵜⵛⵜ ⵏⴶⴹⵎ ⴶⵆⵜ ⵙⵤⴶⵤⵏ ⵙ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵙ ⵓⴰ ⴹⴶⴰ ⴹⵗ ⵜⵔⴰ ⵎⵏⵜ ⴾⴼⴰ ⵀⵜⵓ ⴹⵗ ⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ⴹⵗ ⴹⵢ ⵓⵔ ⵤⴶⵢⴰ ⵙⴹ ⵆⵀⵍⵗ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵆⵍⴹⵓ ⵜⵔⵢⵜ ⵜⵏ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴼⵍⵙ ⵏⵔ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵂⴾⵏ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ ⵓⴹⵢ ⵍⵎⵙⵈ ⵀⵏⵏ ⵙ ⵜⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ⵈⴰ ⴾⵍⴶⵍⵜⵢⴰ ⵓⵏ ⵍⵌⵂⵍⵏ⵰ ⵎⴰ ⵛⵓⵏ ⵜⵢⵜⵢⵏⵓⵏ⵰ ⵓⴾ ⵓⵔⴶⵗ ⴹⵜ ⵛⵜⵓⵏⵓⵏ ⴹⵓⵏ⵿ⵜⵀⵢⵏ ⵜⵎⵜⵏ⵿ⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵜⵓⵜⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ⵙⵙ⵿ⵜⵏ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⵙ ⵔⵗ ⴹⵓⵏ⵿ⵜⴶⴰ ⵜⵎⵙⵏ ⵙ ⵓⴾ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴾⵓⵏⴾⴼⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵗ ⵤⴶⵤⵏ ⵓⴰ ⵜⴶⵎ ⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⵙ ⵜⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ⵓⴾ ⴶⵔⵓⴾⵓⵏ ⵀⴰ ⵏ⵿ⵜⵢⵜⵢ ⴶⴹⵏ ⴹⴹⵢ⵰ ⵓⴾ ⴹⴼⵔ ⵙ ⵜⵙⵏ⵿ⵜⵎ ⵙ ⵎⵤⵍⵏ ⵓⵏ ⵍⴾⵎ ⵢⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵜⵔⴰ ⵜⴶⵎ ⵎⵔⴹⴰ ⴹ ⵜⵙⵏ⵿ⴹⵎ ⵙ ⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵎ ⴾⵓⵏⵢ ⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ⵓⴾ ⵔⵜⵏ ⵓⵏ ⵜⵌⵔⵀⵎ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ ⴾⵍ ⵆⵍⵏ ⵀⵏⵏ⵰ ⵓⵔ ⵜⵍⴰ ⵎⴾ ⵙ ⵤⵀⵏⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ⵜⵂⴾⵢ ⵜⴰ ⴾⵓⵏⴶⴰ ⵎⵛⵏⴰ ⵏ⵿ⴼⵙⵏⵜ ⴹⵢ ⵤⴹⴶⵏ ⴶⴰ ⴹⵗⵓⵏ ⴹⵗ ⵜⵍⵎⵗⵌⵌⵜⵏ ⵓⴾ ⵍⴾⵎⵏⵓⵏ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴼⵍ ⴹⵓⵏⴶⴰ ⵓⵏ ⵎⵗ ⵤⴶⵤⵏⵓⵏ ⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⵙ ⵜⵙⵍⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","ⴾⵜⵓⵜⴹⵓ ⵓⴰ ⵏⵏ ⵍⴾⵜⵀⵏ ⵙⵏⵀⵢ ⵀⵔⵂⵎ ⵙ ⵏⵏ «ⵤⴶⵤⵏ ⵙ ⵎⵛⵏⴰ ⵓⵏ ⴹⵗ ⴼⵍ ⵜⴾⴼⴰ ⵜⵆⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ⴹⵗ ⴹⵢ ⵙⵏⵜ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙ ⵎⵛⵏⴰ ⵏ⵿ⵜⵏⵢ ⵎⵙⵏⵏ ⵀⵔⵔⵏ ⵏⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ⴼⴹⴰ ⵍⴾⵜⵀⵏ ⵏⵏ ⵂⵔⵓⴰ ⴹⵜ ⵤⵍ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵀⵀ ⵏⵤⴶⵤⵏⵙⵏ ⴼⵍ ⵤⵆⵀⵍ ⵎⵛⵏⴰ ⵜⵆⵜⵏⵙⵏ⵰ ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵍⴾⵜⵀⵏ ⵎⵍⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⵢⵀⵔⵂⵎ ⵔⵓⵏ ⵙ ⵏⵏ «ⴹ ⴶⵔⵓⵏⵜ ⵜⵓⵛⵜⵏ ⴾⵍ ⵏⴹⵏⵜ ⵍⵀⵔⴾⴰ ⵙⵙⵀⵀⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ⵎⴾⵏ ⴹⵗ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙ ⵎⵛⵏⴰ ⵏ⵿ⵜⵏⵢ ⵤⴶⵔⵓⵏⵏ ⵍⵀⵔⴾⴰ ⵓⴰ ⴶⵔⵓ ⵎⵤⴶⵤⵏ ⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⵙⴼⵍⵏⵏ ⴼⵍ ⵍⴾⵎⵏⵙⵏ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵓⵏ ⴹⵢ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵙⵏ ⵜⵍⵗⵏ⵿ⵜ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵜⵓⵔⵜ ⵜⵍⵗⵏ⵿ⵜ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵓⵔ ⵏⵀⵔⴹⴶ ⴼⵓ ⵢⵛⵔⴹⵏ ⴾⵍ ⵓⵏ ⴾⵜⵀⵏⵏ ⴹⵗ ⵜⵓⵔⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","ⴹⵗ ⴹⵢ ⵓⵔ ⵜⵍⴰ ⵓⴹⵏ ⴶⵔⵓⵏ ⵙ ⵍⴾⵎⵏⵜ ⵢⵛⵔⵗⴰ ⵜⵆⵜ ⵗⵔ ⵎⵛⵏⴰ ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵓⴹⵏ ⵓⴰ ⵗⴹⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⴶⵔⵓⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ⵎⵔⵏ ⵛⵔⵗⴰ ⵓⵔ ⴹⵔⵓ ⴹⵤⴶⵤⵏ ⵓⵍⴰ⵰ ⴾⵍⵔ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵛⵔⵗⴰ ⵏ⵿ⵜⴰ ⵤⴾⴼⵏ ⵜⵎⴹⵔ⵿ⵜ ⵢⵢⵜⴹⵏ ⵓⵏ ⴹⵙⵏ⵿ⴹⵏⵏ ⵛⵔⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","ⵍⵎⵙⵈ ⴾⵙⵏⴹⵓ ⴹⵗ ⵜⵍⵗⵏ⵿ⵜ ⵜⴰ ⴹⵏⵗⵙⵓⵔ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹⴾⵍ⵿ⵜⵜ ⴹⵗ ⴹⴶⵏⵏⴰ ⴹ ⵍⴾⵜⵀⵏ ⵏⵏⵏ «ⵜⵓⵔ ⵜⵍⵗⵏ⵿ⵜ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵓⵛⵍⵢⵏ ⵛⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ⵔⵜ ⵓⵏ ⴶⵢ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⵆⵍ ⵜⵔⵢⵜ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵢⴹ ⴶⵔⵓⵏ ⴹⵗ ⵍⵀⵔⴾⴰ ⵏⵀⵔⵂⵎ ⵏⴶⵔⵓ ⴾⵜⵏⵏⵗ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵏ⵿ⴼⵙ ⵓⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⴾⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ⵎⴹⵔⵢⵏⵏ ⴹⵓⵏⴶⴰ ⵍⵎⵙⵍ ⵙⵔⵜ ⵜⴶⵏ ⵢⵜⴹⵏ ⵙ ⴾⵜⵀ ⵓⴹⵏ ⵎⵜⵔⵏⵜ ⵙ ⵜⵎⵓⵜ ⵜⵍⴾⵎⵜ ⵢⵛⵔⵗⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⴼⵔⴶⵏ ⴹⵔⵙⵏ ⴹⵆⵍ ⴹⴼⵔ ⴹⵢ ⴶⵔ ⵤⴰ ⵢⴹⵗⵙⵏ ⴼⵏⵤ ⵔⵜ ⵓⵍⴰ ⴹⵗⵙⵏ ⵜⵛⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ⵎⵔⵏ ⵀⵔⵂⵎ ⴹⵤⵔⵢⵏⵜ ⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⴾⵓⵍⵏ⵰ ⵓⵔ ⵜⵓⵏⴰ «ⵢ ⵤⵔⵢⵜⵏⵜ» ⵤⵏ ⵙ ⵍⴰ ⵤⵔⵢⵜⵏ ⴶⵜⵏⵏ ⴾⵍⵔ ⵢⵏ⵿ⴹⴰ ⵗⵙ ⴼⵍⵙ ⴹⵙⵜⵓⵏⵏ «ⵤⵔⵢⵏⴾ» ⵍⵎⵗⵏⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ⴹⵗ ⴹⵢ ⵏ⵿ⵜⴰ ⴹⴰ ⵓⵙ ⵔⵗ ⵜⵏⵏⵜ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⴶⴰ ⵎⵛⵏⴰ ⴾⵍⴰ ⴹⴰ ⵓⵔ ⵜⵤⵎⵙ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹⵙⵏ ⴾⵤⵜ ⵜⵎⴹ ⵏⵓⵜⵢ ⴹⴾⵔⴹⵜ ⵜⵎⵔⵓⵏ ⴹⴼⵔ ⵓⵏ ⵆⵍ ⵙ ⵔⴾⵓⵍ ⵓⵏ ⵀⵙ ⵜⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ⵎⵔⵏ ⵙ ⵆⵍ ⵙ ⵛⵔⵗⴰ ⵂⴾⵏ ⵜⴾⵙⵜ ⵜⵏ ⴹⵢ ⵤⴰ ⵀⵙ ⵎⵙ ⵙ ⵔⴾⵓⵍ ⵓⴰ ⴶⴰ ⵎⵛⵏⴰ ⵢⵀⵔⵂⵎ ⵛⵗⵍⵏ⵰ ⵔⴾⵓⵍ ⵓⵏ ⵎⵔⵏ ⵜⵔⵢⵜⵏⵜ ⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⵈⵎⵜⵏⵜ ⵢⵀⵔⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ⴹⵗ ⴹⵢ ⵎⴼⵍ ⵙⴹⵓ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ⵛⵔⵗⴰ ⵓⴰ ⵜⵓⵛⵜⴹⵓ ⴼⵍ ⴹⵜⵎⵏ ⵜⵎⵤⵔⵢⵜ ⵏⵢⵜⴹⵏ ⴾⵜ ⴹⵢ ⴹⵜⵓⴹ ⵤⵔⵢⴰ ⵏⵀⵔⵂⵎ ⵙⵏ⵿ⵜⴰ ⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⴾⵓⵍ⵰ ⵛⵔⵗⴰ ⵓⵏ ⵤⵀⵜⴹⵓ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴶⵍⵙⵏ ⵎⵔⵏ ⴶⴹⵎ ⵎⵙⵏ ⵎⵛⵓⵍ ⴹⵗ ⵀⵜⵓ ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ⵎⵛⵓⵍ ⵎⵔⵏ ⵓⵔ ⵙⵔⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵔ ⵙⴹ ⵜⵍⴰ ⵓⴹⵏ ⵢⵏ ⵓⵙ ⵤⵛⵓⵍ ⵎⵛⵏⴰ ⵎⵔⵏ ⵏⵙⵏ ⵙ ⵗⵙⵏⵜ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ⵓⴾ ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ⵛⵔⵗⴰ ⵎⵤⵔⵢ ⵔⴾⵓⵍⵏ ⵏⵎⵛⵏⴰ⵰ ⴾⵍⴰ ⴾⵍⴰ⵰ ⵓⵔ ⵍⴾⵎ ⴹ ⴶⴰ ⴹⵢ⵰ ⴼⵍⵙ ⵏⵔ ⴹⵜⵓⴾⴼⴰ ⵛⵔⵗⴰ ⵢⵏ ⵂⴾⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⵢⵏⵢⵜ ⵓⴹⵢ ⵍⴾⵏ ⵙ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵙ ⵤⴰ ⵜⵜⵓⴶⵔⵓ ⵜⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ⴾⵍⵔ ⵍⴾⵜⵀⵏ ⵎⵍⵏ ⵙ ⵔⵜ ⴾⵜⵏⵜ ⵍⴰ ⴼⵍⵙ ⵀⴾⴹ ⵜⵔⵏⴰ ⴼⵍ ⴹ ⵆⵍ ⵙ ⵔⵜ ⵓⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⴾⵓⵍⵏⵜ ⴾⵏ⵿ⴹⵀⴰ ⵏ⵿ⴹⴰ ⴼⵍ ⵎⵤⴶⵤⵏ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵍⵗⴹⵍⴰ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","ⴹⵜ ⵙⴰ ⵏ⵿ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⴶⵏⵗ ⵛⵔⵗⴰ ⵎⵙⴾⵙⴰ ⵜⴼⵏⴰ ⵂⵔ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⴹⵗ ⴹⵏⵗⵙⵏⴼⵍⵍ ⵎⵛⵏⴰ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⵙ ⵔⵓ ⵜⵤⵢⴹⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ⴹⵗ ⴹⵢ ⵛⵔⵗⴰ ⴹⵏⵗⵙⵙⵗⴹⵏ ⵂⵔ ⴹⵙⴰ ⵍⵎⵙⵈ ⴼⵍ ⴹ ⵏⴶⵔⵓ ⵜⵆⵜ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⵜⵔⵢⵜ ⵜⵏ ⵤⴶⵤⵏ ⵜⵙⴹⵓ ⵓⴹⵢ ⵀⵙ ⴹⵏⵗⵙⵙⵗⴹ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ⴼⵍⵙ ⴾⵜⵏⵓⵏ ⵙ ⵜⵎⵙⵎ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵙⵙⵀⵀ ⵏⵤⴶⵤⵏ ⵓⴰ ⴹⵗ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ⵓⵍⴰ ⴾⵜⵏⵓⵏ ⵓⵏ ⵜⵓⵙⵍⵎⵗⵏⵏ ⴹⵗ ⵎⵏ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⴹⵍⵎⵙⵈ ⵍⵎⵙⵈⵏ ⴹⴰ ⵆⵍⵏ ⵤⵏ ⵜⵍⵙⵢⵏⵓⵏ ⵜⴰ ⵜⵢⵏⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ⵀⵙ ⵤⵍⵢⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⴾⵍⵍⵢⵏⵏ ⵓⵍⴰ ⴾⵍⵏ ⵓⵍⴰ ⵍⵍⵏ ⵓⵍⴰ ⵤⵍⵢⵏ ⵎⴹⵏ ⴹⵜⴹⴹⵏ ⴼⵍⵙ ⴾⵜⵏⵓⵏ ⵓⴹⵏ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵎ ⴹⵗ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ⴾⴹ ⵍⵎⵙⵈ ⴾⵓⵏⵍⵏ ⵓⴹⵢ ⵀⵔⵔⵏ ⵏⵀⵔⵂⵎ ⵜⵎⵙⵎ ⵜⵎⵙⵎ ⵎⴾⵙⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵔⴾⵓⵍ ⵓⴰ ⴹⵙⴶⴰ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ⵔⵜ ⴹⴰ ⵓⵙ ⵔⵗ ⴹⵓⵏ⵿ⵜⵏⴰ ⵎⴾⵙⵓ ⴾⵜ ⵎⴹⵔⵢ ⵓⵔ ⵤⵍⵢ ⴹⴾⵍⵢ ⴾⴹⵗ ⵙ ⵏ⵿ⵜⴰ ⵍⵏ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ⵢⵜⴹⵏ ⵓⵏ ⴹⵔⵙ ⵏⵜⴼⵏⵏ ⴹⵓⵏ ⵏⵜⴼⵏⵏ ⴹⵜⵗⵓⵛⵓⵏⵜ ⵙ ⵍⴾⵎ ⵢ ⵜⵏⵜⵏⵙⵏ ⴾⵜ ⵓⵔ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⵎⵍ ⵀⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ⵏⴾⵏⵢ ⴹⴰ ⵂⵔⵓⴰ ⴹ ⵏⵎⴹⵔⵢ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢⵛⵔⴹⵏ ⵓⵏ ⵙ ⵜⴶⵍⴰ ⴹⵏⵜ ⵏⵎⵙ ⵤⵏ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ⵎⵛⵏ ⵙ ⴹⵓⴹ ⵍⵓⵆ ⵓⴰ ⵙⴾⵜ ⵎⵛⵏⴰ ⵢⵓⵏ ⵙⴶⵍⴹⵓ ⵀⵔⵔⵏⵜ ⴶⵤⴹⵓ ⴹⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ");
INSERT INTO ttqt_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ⵙⴹⵓ ⴼⵍ ⴹ ⵙⴹⵔⴼⵜ ⵢⵜⴹⵏ ⵓⵏ ⵎⵙⵏⵏ ⵤⵏ ⴾⵍⵏ ⵏⵛⵔⵗⴰ⵰ ⵙⴹⵓ ⴹⵗ ⴼⵍ ⴹⵏⵗⴾⴼⵓ ⵜⵔⵢⵜ ⵏ⵿ⴹⵏⵗⵆⵀⵍ ⵎⵛⵏⴰ ⴹⵗ ⵜⵛⵜ ⵏⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ⵎⵔⵏ ⵜⵛⵜⵏⵏⴰ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⴹⴶⴰ ⵎⵛⵏⴰ ⴹⵗ ⵓⵍⵏⵏⴰ ⵏ⵿ⴼⵙ ⵏⵀⵔⵔⵏⵜ⵰ ⵏ⵿ⴼⵙⵏ ⴹⴰ ⴹⴾⵍⵏ ⵎⵙⵍⵢ ⴶⵏⵓ «ⵀⴰ⵰ ⵀⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ⴹⵗ ⴹⵢ ⵀⵙ ⵜⵎⵙⵗ ⴾⵍⵢ ⴾⵍⵔ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵜⵎⵙⴰ⵰ ⵎⵔⵏ ⴹⴹ ⵤⵎⵙ ⵜⵎⵙⴰ ⵀⵔⵔ ⵏⵎⵛⵏⴰ ⵓⴹⵢ ⴾⵢⴾⴼⵓ ⵎⵛⵏⴰ ⵔⵈⵎⵜ ⵜⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ ⵢ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ⵏⵢⵜ ⴾⵍⴶⵍⵜⵢⴰ⵰ ⴾⵓⵏⵢ ⵙ⵿ⵜⵤⵔⵜ ⵓⵔ ⵜⵙⵏⵎ ⵎⵛⵏⴰ ⵜⵗⵀⴹⵎ ⵎⵍⵏ ⵏⵀⵂⵓ ⵜⵎⵙⵎ ⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ⵎⵛⵏ ⵎⵔⴹⴰ ⴹⴹ ⵤⵎⵙ ⵜⵙⵏⵎ ⵎⵛⵏⴰ ⵎⴹⵗ ⴹⴹ ⵤⵎⵙ ⵆⵀⵍⴾⵓⵏ ⵎⵛⵏⴰ ⴹⵗ ⵜⵛⵜ ⵏⵀⵔⵔⵏⵜ ⵎⵏⵎⴾ ⵙ ⵤⴰ ⵜⵍⵙⵎ ⵍⴾⵎ ⵢⵛⵔⴹⵏ ⵓⵔ ⵏⵏ⵿ⴼⴰ ⵓⵍⴰ ⵓⵏ ⵙ ⵜⴶⵍⴰ ⴹⵏⵜ ⵜⵍⵙⵎ ⵜⵛⵜ ⵏⴾⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ⵜⵙⵙⵂⵎ ⵓⵍⵏ ⵌⵍⵏ ⴹⵜⵍⵍ ⴹⵜⵎⵔⵏ ⴹⵍⵏ ⵓⵢⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ⵛⵓⵛⵢ ⴹ ⵀⵏⵏ ⵛⵗⵍ ⵙⵂⵏ ⵓⴰ ⴶⵗ ⴼⵍ ⴹⵍⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⵔ ⴹⵗⵓⵏ ⴹ ⵜⵆⵍⵎ ⵛⵍⵜⵏⵏ ⴹⴹ ⵤⵎⵙ ⵏⴾ ⴹⴰ ⵎⵙⴰ ⵛⵍⵜⵏⵓⵏ⵰ ⵓⵔ ⴹⵜⴶⵎ ⵜⵍⵀⵙ⵿ⵜ ⵓⵍⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ⵜⴾⵜⵓⵎ ⵜⵔⵢⵜ ⵜⵙ ⴹⵓⵏⴶⵗ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵙ ⵜⵤⵔⵜ ⵜⵜⵎⵙⵏ ⵜⵔⵢⵜ ⵏ⵿ⵜⵓⵔⵏⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ⵜⴼⵔⴶⵎ ⴹⵜⵍⴾⵎ ⵎⴹⵗ ⵜⴶⵍⴼⵎⵢ ⴼⵍ ⴹⵍⵍ ⵏⵔⴾⵎ ⴹⵀⵔⵔ ⵏ⵿ⵜⵗⵙⵏⵏ⵰ ⵎⵛⵏ ⵓⵔ ⵜⴶⵎ ⵓⵏ⵰ ⴾⵍⵔ ⵜⴶⵎⵢ ⵍⵆⵀⵍⵜ ⵙ ⵤⵏ ⵎⵙⵗ ⵏ⵿ⴶⵍⵙ ⴹⴼⵍⵏ ⵎⵛⵏⴰ ⵎⴹⵗ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ⴹⵗ ⴹⵢ ⵎⴰ ⴶⴰ ⵍⵈⵔ ⵏⵎⵏ ⵓⵙ ⴾⵍⴰ ⵜⵜⴶⵔⵓⵎ⵰ ⴼⵍⵙ ⵙⵍⴾⵏⵗ ⵙ ⵏⵔ ⵎⴾⵏ ⴹⵢ ⵛⵜⵓⵏⵓⵏ ⴹⴰ ⵜⵏⵜⴹⵜⴾⴾⵔⵎ ⵜⴾⴼⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ⵓⴾ ⵤⵏ⵿ⴶⵓⵏⵓⵏ ⵆⵍⵗ ⵎⵔⴹⴰ ⴼⵍ ⵙ ⴹⵓⵏⵎⵍⴰ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ⵙⵏⵜ ⵙ ⵢⵜⴹⵏ ⴹⵢ ⵙⴾⵏⵏ⵿ⴾⵓⵏ ⵙ ⴹⴶⵤⵏ ⴹⵗⵓⵏ ⵎⵛⵏ ⵏⵢⵜⵏⵙⵏ ⵓⵔ ⵍⵗⵏⵜ⵰ ⵜⵔⴰ ⵗⵙ ⴶⵏ ⴾⵓⵏ⵿ⵤⵎⵤⵢⵏ ⴹⵔⵢ ⴼⵍ ⴹ ⵜⵍⴾⵎⵎ ⵢⴹⴼⵏⵙⵏ ⵜⵤⵤⵓⵎ ⴹⵗⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ⵍⵗ ⵓⵍⵏ ⴶⵍⵢⵜ ⴹⵗ ⴶⵢ ⵏⵓⴰ ⵍⵗⵏ ⴹⵗ ⵍⵓⵆ ⴾⵍ ⵓⵔⴶⵗ ⵍⵓⵆ ⵓⴹ ⵍ ⵗⵔⵓⵏ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ⵀⵔⵔⵏⵏ ⵏⴾ ⵍⵙⴰ ⵍⵗⵤⵀ ⴼⵍ ⴹⵍⵍⵏⵓⵏ ⵤⵏ ⵜⵏ⵿ⵜⵜ ⵜⵜⴶⵤⵜ ⵎⵤⵔ ⴾⵜ ⵓⵔ ⴾⵏⴰ ⵍⵎⵙⵈ ⴶⵤ ⵏⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ⵔⵗ ⵓⵍⵏ ⴹ ⵍ ⵗⵔⵓⵏ ⴹⵗ ⵎⵤⵢ ⵓⴰ ⵔ ⴹⵗ ⴹⵓⵏⵛⵓⵍⵗ ⵙⵎⴾ ⵢⵏ ⵓⵔ ⵏⵎⵙ ⵓⴰ ⴼⵍⵙ ⵆⵏ ⵗⴼⵏ ⴹⵗ ⵀⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ⵎⵍⵜⵢ ⴾⵓⵏⵢ ⵔⵏⵏ ⴹ ⵜⴶⵎ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵜⵍⴾⵎⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⵓⴾ ⵎⵙⵏⵜ ⵓⵔ ⵜⴶⵎ ⵓⴰ ⵏⴰ ⵛⵔⵗⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ ⵀⵔⵂⵎ ⵍⴰ ⵛⵏ ⵀⵔⵔⵏ ⵢⵏ ⵜⵔⵓⵜⵓ ⵜⴾⵍⵜ ⵓⴰ ⵂⴹⵏ ⵜⵔⵓⵜⵓ ⵜⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ⵓⴰ ⵜⵔⵓ ⵜⴾⵍⵜ ⵂⵓⴹⵓ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵜⵙ ⵏⴶⴹⵎ ⵓⴰ ⵜⵔⵓ ⵜⵍⵍⵜ ⵎⵔⵏ ⵂⵓⴹⵓ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵔⴾⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ⵀⵜⵓ ⵜⴰ ⵍⵎⵜⵍ ⵜⵎⵙ ⴼⵍⵙ ⵙⵏⵜⵜ ⵜⴹⴹⵏ ⵛⵏ ⵛⵏ ⵔⴾⵓⵍⵏ ⵏ⵿ⵜⵙⵆ ⵎⵙⵏⵜ⵰ ⵔⴾⵓⵍ ⵢⵏ ⵤⴰ ⴶⴰ ⴼⵍ ⴹⵗⵗ ⵓⵏ ⵙⵏⵢ ⵎⵙ ⵜⵂⵓⵜ ⵏⵀⵔⵔⵏ ⵎⵙⵏⵏ ⴾⵍⵏ ⵎⵔⵏ ⵔⴾⵓⵍ ⵓⴰ ⵂⵌⵔⴰ ⵜⵜⵎⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ⵂⵌⵔⴰ ⵎⵔⵏ ⴹⵗⵗ ⵓⵏ ⵙⵏⵢ ⵜⵜⵎⵙⵏ ⵂⵏ ⵎⴹⵍ ⵏⵔⵀⵢⴰ ⵜⵎⵜⵍ ⵢⵔⵙⵍⵎ ⵜⵏ ⵎⵔⴹⴰ ⴹⵗ ⴹⵏⵜ ⴼⵍⵙ ⵜⵂⴰ ⴾⵍⵓ ⵏ⵿ⵜⴰ ⵂⵔⴾⴹ ⵀⵔⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ⵙⴰ ⵂⴹⵏ ⵢⵔⵙⵍⵎ ⵜⴰ ⵜⵂⵜ ⵌⵏⵓⵏ ⵜⵍⵍⵜ ⵜⵎⵙ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵜⵎⵙⵜ ⵤⵏ ⵏⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ⴼⵍⵙ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴼⵍⵓⵙ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵓⵔ ⵏⵜⵍⵓ ⵀⵔⵔⵏ ⴾⵎ ⵓⵔ ⴹⵙ ⴶⵔⵓ ⵏⵀⵔⵔ⵰ ⴹⴾⵍ ⵎⵙⵍⵏⵎ ⵓⵍⵏ ⵜⴾⵏⴰ ⵜⴹⵓⵜ ⴾⵎ ⵓⵔ ⵏⵤⴹⵢ ⵜⵍⵓⵢⵜ ⵜⵏ ⵎⵤⵔ⵰ ⴼⵍⵙ ⵀⵔⵔⵏ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵜⵜⵓⴾⵙⵏⵜ ⴹ ⴶⵔⵏ ⵓⵏ ⵜⵏ⵿ⵜⵜ ⵜⴰ ⵓⵔ ⵤⵎⵤⵢ ⵍⵙⵏⵜ ⴶⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ⴾⵓⵏⵢ ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵀⵔⵔⵏ ⵙ ⵜⵓⴶⴰ ⵔⴾⵓⵍⵏⵙⵏ ⵜⵎⵙⵎ ⵤⵏ ⵙⵂⵆ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ⵎⵛⵏ ⵤⵏ ⵓⵙ ⴾⵍⴰ ⴶⴰ ⵓⴰ ⴹⵂⵓⵏ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵜⵙ ⵏⴶⴹⵎ ⴹⴶⵤ ⵜⴶⵓ ⵓⴰ ⴹⵂⵓⵏ ⵙ ⵜⵔⵢⵜ ⵜⵏ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵎⵔⵏ ⵔⵜ ⵓⵏ ⴹⴰ ⴶⵏ ⵂⵔ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ⵓⴾ ⵓⵔⴶⵗ ⵏⵏ ⵍⴾⵜⵀⵏ «ⵙ⵿ⵜⵗ ⵜⴾⵍⵜ ⴹⵀⵔⵔⵏⵜ ⴼⵍⵙ ⵀⵔⵔ ⵓⵏ ⵜⴾⵍⵜ ⵓⵔ ⵤⵏⵎⴾⵙⵜ ⴹⵀⵔⵔ» ⵓⵏ ⵜⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ⴹⵗ ⴹⵢ ⵎⴹⵔⵢⵏⵏ ⵙⵏⵜ ⵙ ⵏⴾⵏⵢ ⵓⵔ ⵏⵎⵙ ⵀⵔⵔⵏ ⵏ⵿ⵜⴾⵍⵜ ⴾⵍⵔ ⵀⵔⵔⵏ ⵏ⵿ⵜⵍⵍⵜ ⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ⵍⵎⵙⵈ ⴹⵏⵗⵙⴹⵔⴼⵏ ⴼⵍ ⴹ ⵏⵍⵍⵜ⵰ ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵤⵤⵓⵜⵜ ⵓⵍⵏ ⴹⵗ ⵍⵍⵓ ⵓⴰ ⴼⵍ ⴹ ⵓⵔ ⵜⵆⵍⵎ ⴾⵍⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ⵏⵢⵜ ⵏⴾ ⵀⵍⵙ ⵎⵍⵗⵓⵏ ⴾⵓⵏⵢ ⵍⵎⵙⵈⵜⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙ ⵙ ⵜⵎⵏ⵿ⴾⴹⵎ ⵓⵔ ⴹⵓⵏ⵿ⵤⴾⵏⵓ ⵍⵎⵙⵈ ⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ⵎⵔⵏ ⵔⵜ ⵓⴰ ⴹ ⵜⵍⵙⵗ ⵎⵍ ⵢⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⵓⵙⵎⵏ⵿ⴾⴹⵏ ⵓⴹⵏ ⵓⴹⵢ ⵓⵔ⵿ⵜⵓ ⴹ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⴾⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ⵜⵎⵤⵢⵎ ⴹⵍⵎⵙⵈ ⴾⵓⵏⵢ ⵓⵏ ⴶⵎⵢⵏⵏ ⵜⵆⵜ ⵙ ⵍⴾⵎ ⵢⵛⵔⵗⴰ⵰ ⵀⴰ ⴼⵍⵓⵏ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ⵏⴾⵏⵢ ⵎⵔⵏ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵏⵙⴶⴹ ⵙⴾⵙ ⵏⵛⴾ ⵢ ⵜⵆⵜ ⵜⵙ ⵏⴶⴰ ⵜⵎⴰ ⵏ⵿ⴹⵏⵆⵜⴾⴼⵓ ⵤⴶⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ⴼⵍⵙ ⵓⴹⵏ ⵓⵙ ⵜⵍⴰ ⵜⵙⵆ ⴶⵔⵙ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵓⵔ ⵤⵍⵢ ⵎⵏ⵿ⴾⴹ ⴹⵀⵏⵜ⵰ ⵓⵔ ⵗⵔⵙ ⵎⵙ ⵔⵜ ⵔ ⵤⴶⵤⵏ⵰ ⵤⴶⵤⵏ ⵎⵔⵏ ⵜⵔⴰ ⵜⵜⵙⴾⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ⴾⵓⵏⵢ ⵜⵜⵢ ⵤⵤⴶⵤⵏⵓⵏ ⵓⵍⵏ⵰ ⴹⵗ ⴹⵢ ⵎⴰ ⴹⵓⵏⵆⵍⵏ ⵜⵙⵓⵆ ⵤⵀⵤⴾⵓⵏ ⵜⵔⵢⵜ ⵓⵔ ⵏⵎⵙ ⵜⵏ ⵜⴹⵜ ⵜⵏ ⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ⵜⵔⵢⵜ ⵜⵙ ⵜⵆⵀⵍⵎ ⴶⵤⵏⵜ ⴹⵢ ⵓⵔ ⴹⵜⴼⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⵗⵔⵏ ⵜⵎⵙⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ⵜⵓⵏⵓ «ⵔⵜ ⵏⵈⵎⵔⴰ ⵙⴾⴼⵏ ⵜⴶⵍⴰ ⴾⵜⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵏⴾ ⴶⵗ ⵜⵎⴰ ⴹⵗ ⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵗ ⵜⵍⵗⵏⵓⵏ ⴶⵗ ⴹⴼ ⵏⵙ ⵓⵔ ⵤⴰ ⵜⴶⵎ ⵎⴹⵔⵏⵏ ⵎⵤⵔⵢⵏⵏ ⵓⵏⵏ⵰ ⵎⵛⵏ ⵓⴹⵏ ⵓⴰ ⵙⵔⵓⵏ ⴹⵜⵓⵢⵏ ⵛⵓⵛⴰ ⵆⵍ ⴹ ⵓⴹⵀ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","ⵏⴾ ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵏⵔ ⵎⵍ ⵜⴶⵗ ⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵙⵎⵏ⵿ⴾⴹ ⵓⴹⵢ ⵎⵏⵢ ⴹⵍⵍ ⵓⴰ ⴼⵍ ⵜⵓⴹⴶⵤⴰ ⵂⵔⵓⴰ ⴹⴰ⵰ ⴾⴹ ⵔⵜ ⵓⴹⵢ ⵙⵙⵗⵔⴰ ⴹⵢ ⵤⴰ ⵜⵓⵜⵢⵜⵢ ⵏ⵿ⵗⵢⵙⴰ ⴼⵍ ⵜⴶⵜⵓⵜ ⵀⵙ ⵎⵙ ⵜⵙⵏ⵿ⴾⴼ⵿ⵜ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ⵎⵔⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⵂⵏⵏ ⴹⵢ ⵜⵓⵢⵏ⵿ⴹⵓ ⵙⵔⵓⵏ ⵛⵓⵛⴰ ⴹⵗ ⵀⵜⵓ ⵏⵎⵏ⵿ⴾⴹ ⵗⵔⴹⵏⵜ ⵤⵎ ⵏⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ⴾⵓⵏⵢ ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵗⵔⵓⵏ⵿ⴹⵓ ⵎⵛⵏⴰ ⵢⴹ ⵜⴹⵔⴼⵎ⵰ ⴶⵙ ⵜⴹⵔⴼⵜ ⵜⵏ ⴹ ⵓⵔ ⵜⵆⵍ ⵔⵜ ⵙⵔⵓⵏ ⴹⵓⵢⵏ ⵍⴾⵎ ⵢⵔⴾ ⴹⵔⵏⵏ ⵏ⵿ⵜⵔⴰ ⵏⵎⵏ⵰ ⴾⵍⵔ ⴾⵢⵏ ⴹⵗⵓⵏ ⵆⵍⵜ ⴾⵍⵢ ⵏⵓⵏ ⵂⴹⵜⵏⵏ ⴶⴰ ⵓⵏ ⵙ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ⵎⵔⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴾⵍ ⵙ ⵏ⵿ⴹⴰ ⴹⵗ ⵀⵜⵓ ⵢⴹⴰ ⵜⵎⵙⵜ «ⴹ ⵜⴶⴰ ⵢⵛⵆⵗⵏⴾ ⵜⵔⴰ ⵜⴰ ⵜⴶⵗ ⵢ ⵎⵏⴾ⵰» ");
INSERT INTO ttqt_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ⵏ⵿ⴾⴹⵜ ⵢⴹ ⵜⵜⵏⵎⴹⴹⵎ ⵤⵏ ⵎⴹⵔⵏ ⵜⵜⵏⵎⴶⵎ ⵜⵍⵀⵙ⵿ⵜ ⴶⵔⵓⵏ ⴼⵍ ⴹ ⵓⵔ ⵜⵏⵎⵂⵍⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ⵔⵜ ⴹⴰ ⵓⵙ ⵔⵗ ⴹⵓⵏ⵿ⵜⵏⴰ ⵢⵓⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⵏⴹⵓ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ⵰ ⵙ ⵜⴶⵎ ⴹⵢ ⵓⵔ ⴹⵓⵏⵍⴾⵎ ⴹ ⵜⵎⵤⵍⵎ ⵙⵔⴾ ⴹⵔⵏⵏ ⵏ⵿ⵜⵔⴰ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","ⴼⵍⵙ ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ ⵎⵏⵜ ⵍⴹ ⵎⵙⵏ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵍⴹ ⵎⵙ ⵏ⵿ⴹⵔⵏⵏ ⵓⵏ ⴶⴹⵎ⵰ ⴶⵏ ⵎⵤⵔⵢ ⵓⵏ ⵙ ⵙⵔⵓⵏ ⴹⵓⵢ ⵓⵏ ⴹ ⵜⵎⵤⵢⵎ ⴹⴶⵢ ⵏⵓⴰ ⵜⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ⵎⵔⵏ ⵙ ⵎⵙ ⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗⵓⵏ ⵏⴹⵏ ⵓⴹⵢ ⴹ ⵀⵙ ⴼⵍⵓⵏ ⵈⴾⵎ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","ⵎⵤⵍⵏ ⵓⵏ ⴶⴹⵎ ⵎⵏⵜ ⵎⵏⵏ⵰ ⵎⵙⵏ ⵤⵏⴰ ⴹⵎⴹⵙ ⴹⴶⵢ ⵏⵔⵜⵏ ⵓⵏ ⴶⵔⵏⵏ ⵜⵈⵔⵎ⵿ⵜ ");
INSERT INTO ttqt_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ⴹⴶⵢ ⵏⵎⴹⵔⵓ ⴹⵛⵗⵓⵏ ⴹⵤⵏ⵿ⴶⵓ ⴹⵎⵙ⵿ⵜⵏ ⴹⵎⵏ⵿ⵌⵗ ⴹⵛⵔ ⴹⵜⵔⴰ ⵏⵎⵏ ⴹⵤⵎⵤⵢ ⵏⵢⵜⴹⵏ ⴹⵤⵎⵤⵔⵢⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ⴹⵀⴰ ⵏ⵿ⵜⵍⴰ ⵏⴶⴹⴰ ⴹⵎⵙⵓⴹ ⴹⵙⵙⴾⵢ ⴹⵗ ⵜⵜⵢ ⴹⵔⵜⵏ ⵓⵢⴹ ⵍⵏⵏ ⴹⵓⵏ⵰ ⴹ ⴹⵓⵏⵍⵙⵗ ⵎⵍ ⵂⵔⵓⴰ ⵎⵔⴹⴰ ⵙ ⵢⵜⴹⵏ ⵓⵏ ⵜⴶⵏⵏ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵓⵔ ⵤⴶⵤⵏ ⵜⵗⵎⵔ ⵜⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ⵔⵜⵏ ⵎⵔⵏ ⵓⵏ ⴹⴼⵍⵏⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵎⵙⵏⵏ ⵍⴹ ⵏⵓⵏ ⴹⵢ ⵎⵙⵏ ⵜⵔⴰ ⴹⵜⴼⵍⵓⵙ⵿ⵜ ⴹⵍⵈⵔ ⴹⵜⵤⵢⴹⵔ⵿ⵜ ⴹⵎⵏ ⵎⵍⵍⵏⵏ ⴹⵍⵗ ⴹⵤⴶⵤⵏ ");
INSERT INTO ttqt_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ⴹⵜⵍⵎⵜ ⴹⵏⴹⵢ ⴹⵗ ⵓⵍⵏⵏⴰ⵰ ⵎⵔⵏ ⵓⵔ ⵜⵍⴰ ⵛⵔⵗⴰ ⵛⴾⵏ ⵍⵈⵍⵏ ⵓⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ⵓⵍⴰ ⵢⵜⴹⵏ ⵓⵏ ⴾⴼⵏⵏ ⵎⵏⵙⵏ ⵢⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵓⵏ ⴹⵢ ⴾⵙⵏⵏ ⴹⵗ ⵍⵈⵍⵏⵙⵏ ⵜⵔⴰ ⵏⵎⵏ ⴹⵔⴾ ⴹⵔⵏⵏ ⵓⵏ ⴹⵗⵙⵏ ⵏⴹⵏⵏ ⵜⵢⵜⵢⵏ⵿ⵜⵏ ⴼⵍ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵜⵓⵜⵢⵜⵢ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","ⴹⴹ ⵤⵎⵙ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵗⵔ ⴹⵜⴼⵍ ⵜⵎⴹⵔ⵿ⵜⵏⵏⴰ ⵏⵢⵓⵜⵓ ⴹⵗⵏⴰ ⵈⴾⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ⴹ ⵓⵔ ⵏⵆⵍ ⵢⵜⴹⵏ ⵤⵤⵓⵔⵏⵏ ⵎⵏⵙⵏ⵰ ⵎⵤⵢⵜⵏⴰ ⴹⵜⴹⵍⵎ⵿ⵜ ⴶⵔⵏⴰ ⴹⴶⵢ ⵏⵜⵎⴰ ⴹⵗ ⵓⴰ ⵍⵏ ⵎⴹⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ⵎⴹⵔⵢⵏⵏ ⵙ ⵓⴹ ⵌⵔⵀⴰ ⵓⴹⵏ ⴶⴰ ⵔⴾ ⵎⵤⵍ ⵆⵍ ⴾⵓⵏⵢ ⵍⴾⵎⵏⵏ ⵢⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵙⵗⴹⵜⵓ ⵙ ⵎⵏ ⵍⵎⴹⵏⵏ ⴼⵍ ⴹⵆⵍ ⵜⵔⵢⵜ ⵜⴰ ⵜⵍⵗⵜ⵰ ⵏ⵿ⴾⴹⵜ ⵓⵍⵏ ⴹⵎⵏⵓⵏ ⴼⵍ ⴾⵓⵏⵓⵔⵓⴹ ⵌⵔⵀⴰ ⴾⵓⵏⵢ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ⴾⵢⵏ ⴹⵗⵓⵏ ⴹⴾⵍⵜ ⵤⴾ ⵏⵓⵏ ⵂⴹⵜⵏⵏ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⴹⵤⵜⵙⵏ⵿ⴹⵎ ⵍⵆⵏⵏ ⵓⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ⴼⵍⵙ ⵓⴰ ⴶⵏ ⵢ ⵎⵏⵜ ⴹⴼ ⵏⵙ ⵎⵙ ⵓⴹⵏ ⵤⵓⵔⵏ ⵙ ⴶⴰ ⵓⵏ ⵓⵔ ⵎⵙ ⵓⵍⴰ ⵓⴹⵢ ⵀⵂⵓ ⵜⴶⵓ ⵢ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ⴾⵢⵏ ⴹⵗⵓⵏ ⵏ⵿ⵤⵔⵜ ⴹⵗ ⵎⵤⵍⵏⵜ⵰ ⵙ ⵏⵢ ⵙ ⵎⵤⵍⵏⵜ ⵂⵙⵢⵏ ⴹⵢ ⴹ ⴶⵔⵓ ⴹⵍⵍ ⵏⴹ ⴼⵍⵙ ⵎⵏⵜ ⵙⵙⵀⵀ ⵏⵎⵤⵍⵏⵜ ⵓⵔⴶⵗ ⵙⴹ ⵛⵛⵍⵓ ⵎⵏⵜ ⴹⵓⴹⵏ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ⴼⵍⵙ ⵓⴹⵏ ⴾⵍ ⴾⵏ⵿ⴹⵀⴰ ⵀⴹⴹ ⴼⵍ ⵎⵤⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ⵓⴹⵏ ⵓⴰ ⵜⵓⵙⵙⵗⵔⵏ ⵓⵍ ⵏⵎⵛⵏⴰ ⵓⵔ⵿ⵜⵓ ⴹ ⴹⵔⵓ ⵔⵤⵗⵏⵜ ⴾⵍ ⴹⵓⴰ ⵜⵙⵙⵗⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ⴹ ⵓⵔ ⵜⵜⴼⵎ ⵍⵈⵜⴰ ⵎⵛⵏⴰ ⵓⵔ ⵜⵍⴰ ⵢ ⵤⵢⵓ ⵙⵎⴹⵔⵢⵜⵓ⵰ ⵓⵍⴰ ⵎⵙⴰ ⵓⴰ ⵏⵀⵍ ⵓⴹⵏ ⵏ⵿ⵜⴰ ⴹⵤⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ⵍⴾⵏ ⵙ ⵓⴹⵏ ⵓⴰ ⴶⵏ ⵎⵤⵍⵏ ⵓⵏ ⵜⵔⴰ ⵏⵎⵏ ⵔⵤⵏⵜ ⴹ ⵜⵆⵍ ⵓⴰ ⴹⵜⵓⵢ ⵍⴾⵎ ⵢⵔⴾ ⴹⵔⵏⵏ ⵜⵎⵙⵏ ⵂⵍⴾ⵰ ⵎⵛⵏ ⵓⴰ ⵜⴶⵏ ⵎⵤⵍⵏ ⵓⵏ ⴹⴼⵍⵏⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⴶⵔⵓ ⵔⵤ ⴹⴼⵍⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵎⵙⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ⴹ ⵓⵔ ⵏⴹⵤ ⴶⵢ ⵏⵓⴰ ⵍⵗⵏ ⵙ ⴶⴰ ⴹⵢ ⴹ ⵏⴶⵔⵓ ⵔⵤⵏ ⴹⵗ ⵍⵓⵆ ⵓⴰ ⵜⵓⵙⴾⵜⵏ ⵢⵓⵏ ⵙ ⵓⵔ ⵏⵆⵍ ⴹⴼⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ⴹⵗ ⴹⵢ ⴾⵜ ⴹⵢ ⴹ ⵏⴶⵔⵓ ⵜⵔⵢⵜ ⵏⵓⵏ ⵜⴶⵓⵜⵏⵗ ⵓⴰ ⵏ⵿ⴼⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵍⵏ ⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ⵏⵢⵜ ⵍⵈⵔⴼⵏ ⵓⵏ ⵤⵓⵔⵏⵏ ⴰ⵰ ⴼⵙⵏ ⵙ ⴹⵓⵏ⵿ⵜⵏⵏ⵿ⴾⵜⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","ⵢⵜⴹⵏ ⵓⵏ ⴶⵎⵢⵏⵏ ⴾⵓⵏⵛⵂⵛⵍⵏ ⵙ ⵓⵔⴾⵓⵏ ⵎⵏ⵿ⴾⴹ ⵓⵏ ⴹⵢ ⴶⵎⵢ ⵜⴶⵏ ⵜⵏⵙⵗⵎⵔⵏ ⵢⵜⴹⵏ⵰ ⵎⵔⵏ ⵔⵜ ⵓⴰ ⴶⵎⵢⵏ ⵓⵍⵏ ⵜⵏⵓⵔⴹⴶⵤⵏ ⵢⵜⴹⵏ ⴼⵍ ⴹⵍⵍ ⵏⵤⴶⵤⵏⵙⵏ ⵙ ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ⵢⵜⴹⵏ ⵓⵏ ⵜⵎⵏ⵿ⴾⴹⵏⵏ ⴹⴰ ⵓⵔ ⵍⴾⵎⵏ ⵢⵛⵔⵗⴰ ⴼⴹⴰ⵰ ⵜⵔⴰ ⵗⵙ ⴶⵏ ⴾⵓⵏ⵿ⵙⵎⵏ⵿ⴾⴹⵏ ⴼⵍ ⴹ ⴶⵏ ⵀⵔⴶⵏ ⵙⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ⵏⴾ ⵎⵔⵏ ⵓⵔ ⵍⴾⵎ ⴹ ⵙⵀⵔⴶⵗ ⵔ ⵙ ⵜⴶⵜⵓⵜ ⵜⴰ ⴼⵍ ⵜⵓⵜⵢⵜⵢ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵜⵔⵢⵜ ⵜⵏ ⴹⵗ ⵏ⵿ⵜⴶⵜⵓⵜⵏ ⵏ⵿ⵜⴰ ⴹⵜⵓⵢⵜ ⵙ ⵔⴾ ⵔⵜⵏ ⵏⴹⵏⵜ ⴾⵍ ⵎⵙⵏ ⵙⵔⵢ ⵎⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵏⴾ ⴹⴰ ⵎⵙⵗ ⵔⵢ ⵎⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ⴼⵍⵙ ⵓⵔⴶⵗ ⵎⵏ⵿ⴾⴹ ⵓⵍⴰ ⵀⵏⵜ ⵎⵙⵏ ⵍⵎⵈⵙⴹ ⴾⵍⵔ ⵈⵍⴾ ⵢⵏⵢⵏ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵎⵙⵏ ⵍⵎⵈⵙⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ⵂⵏⵜⵜⵜ ⵎⵛⵏⴰ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⵏⵎⴹ ⵓⴰ ⴾⴼⵏ ⵍⵈⵔ ⵙⵎⴾ ⵓⵙ ⴶⴰ ⴹⵢ ⵢ ⵜⵎⵜⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⴹⵓⵔⵍⵙ ⵓⴹⵏ ⵓⵍⵢⵏ ⴹⴶⵤ ⴼⵍⵙ ⵍⵎⵏ ⵓⵔⵏⵜⵓ ⵜⵎⵌⵔ ⵏⵍⴾⵎⵏ ⵢ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⵜⵔⴰ ⵙⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵓⵏⴾⴼⵏ ⵔⵈⵎⵜ⵰ ⵎⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⵎⵙⵏ ⵏⵎⵤⵍ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙ ⵜⵔⴹⵓⵜ ⵏⵎⵛⵏⴰ⵰ ⵛⵔⵓⵜ ⵜⴰ ⵜⴾⴰ ⵢⵜⴹⵏ ⵓⵏ ⵎⵙⵏⵏ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ ⵂⵏⵏ ⵗⵔⵎ ⵏⴼⵤ ⵍⵎⵗⵏⴰ ⵢⵜⴹⵏ ⵓⵏ ⵗⴹⵍⵏⵏ ⴹⵗ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵓⵏⴾⴼⵏ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ⵜⵎⵍ ⵢ ⵎⵛⵏⴰ ⵎⵙⵏ ⵀⴰ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⴶⵏⵗ ⵍⵀⵔⴾⴰ ⴹⵗ ⵜⵙⵆⵏⵏⴰ ⴹⵍⵎⵙⵈ ⵙ ⵜⵂⴾⵢ ⵜⴰ ⴹⵏⵗⴶⴰ ⴾⵍⴾ ⵏⵍⵀⵔⴾⴰ ⵓⴰ ⴹⵤⵤⵀⵜ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ⴹⵗ ⴹⵢ ⵙⵏⵜⵏⵗ ⵙ ⵂⵔⵓⴰ ⴹⵜ ⵈⵍⴾ ⵏⴹⵏⵜ ⴹⵏⵗⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⵢⴹ ⵏⵆⵍ ⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⴹⵜⵙ ⵏⵆⵍ ⵢⵜⴹⵏ ⵤⴹⴶⵏⵏ ⵓⵔ ⵓⵔ ⵎⵙⵏ ⵍⵂⵏ ⴼⵍ ⴹ ⵏⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⵜⵂⴰ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ⵎⵛⵏⴰ ⵏ⵿ⵜⴰ ⴹⵏⵗⵙⵏⴼⵔⵏ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵢⴹⵏⵗⴶⵓ ⵀⵔⵔⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⵓⵏ ⴹⵗ ⴶⵔⵤⵏ ⵢ ⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ⵎⵔⵏ ⴶⵢ ⴼⵍ ⴹ ⵏⵎⵍ ⵜⵏⵢⵏⵜ ⴹⵔⵈⵎⵜⵏⵜ ⵜⵙ ⴹⵏⵗⵙⵀⵍⵍ ⵙ ⵜⵔⵢⵜ ⵏⵀⵔⵔⵏⵜ ⴾⵏⴰ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ⵜⵔ⵿ⵜⵢⵜ ⴹⵀⵔⵔⵏⵜⵏ ⴹⴰ ⴹⵏⵜⴾⴼⵜ ⵜⴹⵔⴼⵜ ⵙ ⵜⵔⵢⵜ ⵏⵤⵏⵏⵜ⵰ ⵜⴹⵔⴼⵜ ⵜⵏ ⵜⵎⵙ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵏⴰ ⵎⵔⵏ ⵏⴶⵔⵓⵜⵜ ⵙⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ");
INSERT INTO ttqt_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ⴼⵍⵏⴰ ⴹⵤⵤⵀⵜ ⵙⴶⵜ ⴾⴼⵏⵗ ⵤⵏⴼⵏ ⴾⵍ ⵏⵎⵙⵏⵜⵏ ⴹⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","10","ⵓⵏ ⴶⵢ ⵙⵙⵙⵏ ⵓⴰ ⴹⵗⵏⴰ ⴶⴰ ⵙⵔ ⵏ⵿ⵜⵔⵏⵜ⵰ ⵙⵔ ⵓⵏ ⵎⵙ ⵛⴹⵓ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⴹⵓⵏ ⵓⵔⵏⵏ ⵎⴹⵍ ⴼⵍ ⴹ ⵜⴼ ⵍⵎⵙⵈ ⵜⵏⵜⵏⵙⵏ⵰ ⵜⵔⵢⵜ ⵜⵏ ⴶⵜⴹⵓ ⵂⵔⵓⴰ ⵔⵓⵏ ⵙⵙⵀⵀ ⵏⵍⵎⵙⵈ ⵎⵔⵏ ⵓⵏ ⴹⴰ ⴹⵙⴶⵔⵤⵏ⵰ ⴶⴰ ⵓⵏ ⴼⵍ ⴹ ⵙⵏ⵿ⴹⵓ ⵜⵔⵢⵜ ⵜⵏ ⴹⵗ ⵍⵓⵆ ⵓⴰ ⴹⵙⵙⴾⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ⵙⵏⴼⵔⵏⵏⴰ ⴹⵗ ⵎⵛⵏⴰ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵢⴹ ⵏⵆⵍ ⵏⵜ ⵏⵎⵏⴾ ⵓⵏ ⴹⵜⵔⵢⵜ ⵜⴰ ⴹⴾⵜⵀ ⵎⵛⵏⴰ ⵙⵏ⵿ⵜⴰ ⵜⴶⵏ ⵔⵜⵏ ⴾⵍ ⵙⵎⴾ ⵓⵙ ⵜⵏ⵿ⴹⴾⵜⴰ ⴹⵓⵙ ⴶⴰ ⵜⵏⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ⵎⵛⵏⴰ ⴶⵏⵗ ⵓⵏ ⴼⵍ ⴹ ⵏⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗⵙ ⵏⵜⴶⵓ ⵜⵎⵍⵏ ⴼⵍ ⵜⵏⵢⵏⵜ ⵏⴾⵏⵢ ⵓⵏ ⵤⵔⵏⵏ ⴶⵢ ⵏⵜⵎⴰ ⴹⵗ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ⴾⵓⵏⵢ ⴹⴰ ⵜⵙⵍⵎ ⵢⵓⵍ ⵓⴰ ⵎⵙⵏ ⵜⴹⵜ ⵜⵎⵙⵏ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⴾⵓⵏⵂⴾⵏⵏ ⵍⵗⵍⵙ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ⵰ ⵎⵔⵏ ⵙ ⵜⵤⴶⵤⵏⵎ ⵓⴹⵢ ⵙⵓⵔⴾⵓⵏ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵌⵓⵍ ⵙⴾⵏⵏ ⵙ ⵜⵎⵜⵢⵏⵜ ⵜⵎⵙⵎ⵰ ⵌⵓⵍ ⵓⵏ ⵎⵙ⵿ⵜⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⴶⴰ ⵔⴾⵓⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏⵏ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵜⴹⴶⵔ⵿ⵜ ⵜⴰ ⵜⵤⵔⵜ ⴹⵗ ⵓⴰ ⴹⵏⵤⴾⴼⵓ ⵎⵛⵏⴰ ⴹⵗ ⵌⵏⵓⵏ⵰ ⵎⵛⵏⴰ ⵙⵓⵔⵏⵗ ⵌⵓⵍⵏⵜ ⴾⵜ ⴹⵢ ⴹⵜⵜⵓⴹ ⵜⴹⵔⴼⵜ ⵏ⵿ⵜⵎⵜⵢ ⵜⴰ ⵙⴾⵜ ⵢ ⵎⵏⵜ⵰ ⵔⵜ ⵓⵏ ⴾⵍ ⴹ ⵜⴶⵓ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵜⵓⴶⵏⵜ ⵜⵎⵍⵏ ⵢ ⵜⵏⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵏⴾ ⴹⴰ ⴹⴼⵔ ⵙ ⵙⵍⵗ ⵤⴶⵤⵏⵓⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⴹⵜⵔⴰ ⵜⴰ ⵜⵙⴾⵏⵎ ⵢ ⵎⵤⴹⴶⵏ ⴾⵜⵏⵙⵏ ");
INSERT INTO ttqt_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ⵓⵔ ⴾⵍⴰ ⴹ ⵎⵤⵢⵗ ⴹⴶⴹⵏ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵏⵓⵏ ⵍⵓⵆ ⴾⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⴾⵜⵗ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⵎⵙⵏ ⵎⵍⵢ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⴹⵗ ⵀⴰ ⵓⴰ ⵍⵏ ⵜⵏⵢⴰ ⴾⵓⵏⴾⴼⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵂⴾⵏ ⵎⵙⵏⵜ ⵙⵏⴼⵍⵍ ⴹⵗ ⵔⵜⵏ ⵓⵏ ⵂⵏⵏ ⵜⵏ⵿ⴾⵍ ⴼⵍ ⵜⵜⵙⵏⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ⴶⵎⵢⴰ ⴹⵗⵙ ⴹⵗ ⴹ ⵍⵎ ⵓⵍⵏⵏⵓⵏ ⴼⵍ ⴹ ⵜⴾⵏⵎ ⴶⵔⵢ ⵏⵓⴰ ⵎⵙ ⵜⵎⴰ ⵓⵙ ⴾⵓⵏⵗⵔⴰ ⵜⵙⵏⵎ ⴹⵗ ⵓⴰ ⴹⵔ ⴶⴹⵏⵜ ⵜⵂⵙⵢ ⵏ⵿ⵙⵗⵎⵔ ⵓⴰ ⴶⵔⵓ ⵎⵛⵏⴰ ⵗⵔⵏⴰ ⵏⴾⵏⵢ ⵏⵎⵤⴹⴶⵏ ");
INSERT INTO ttqt_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ⵜⵙⵏⵎ ⴹⵗ ⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵤⵓⵔ⵿ⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵏ⵿ⵜⵔⵏⵏⵜ ⵙⵔⵏⵗ ⵏⴾⵏⵢ ⵤⴶⵤⵏⵏ ⵙ ⵎⵤⵍⵏ ⵙⵂⵜⵏⵏ ⵏ⵿ⵜⵔⵏⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ⵜⵔⵏⵏⵜ ⵜⵏ ⵛⵛⵗⵍ⵿ⵜⵜ ⴹⵗ ⵍⵎⵙⵈ ⵙⵙⵏ⵿ⴾⵔ ⵓⴰ ⵜⴹⴶⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵙⵗⵎⵢ ⵓⴰ ⵜⴶⴰ ⴹⵗ ⵗⵍⵏⵜ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","ⴶⵢ ⴹⵏⴶ ⵜⵗⵎⵔ ⴾⵍ ⴹⵜⵎⵏⴾⵍⴰ ⴾⵍ ⴹⵜⵔⵏⴰ ⴾⵍ ⴹⵍⵈⴾⵎ ⴾⵍ⵰ ⴶⴰ ⵙⵎⵏⵜ ⴹⵏⴶ ⵙⵎ ⴾⵍ ⵓⴰ ⵜⵍⵏ ⴶⵔ ⵤⴰ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⵎⵔⴹⴰ ⵓⵍⴰ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹⵤⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ⵔⵜ ⴾⵍ ⴶⵢ ⴹⵓ ⴹⵔⵏⵜ ⵜⵤⵔ ⴶⵢ ⵎⵤⵔ ⵏⵔⵜ ⴾⵍ ⴹⵗ ⵍⴾⵏⵙⵜ ");
INSERT INTO ttqt_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ⵜⵎⵙⵜ ⵜⵗⵙⵏⵜ⵰ ⵜⵗⵙⵏ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⴹⵗ ⴾⵏⵓ ⵍⵎⵙⵈ ⵍⴾⵎⵍⵜ ⵏ⵿ⵜⴰ ⵂⵏ ⴹⴶ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","ⵎⵔⵏ ⴾⵓⵏⵢ ⵀⴾⵓⵏ ⴼⵍ ⴶⵏⴰ ⵓⴰ ⵆⵍⵏ ⵜⵙⵆ ⴹⵎⵛⵏⴰ ⵙⵙⵀⵀ ⵏⵔⴾ ⵎⵤⵍⵏⵓⵏ ⴹⵀⴾⴹⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ⴹⵜ ⵓⴰ ⵜⵛⴾⵍⵎ ⴹⵗ ⵔⴾ ⵎⵤⵍⵏ ⵓⵏ ⵜⵍⴾⵎⵎ ⵢⵍⵈⵍ ⵓⵏ ⴹⵏⵜ ⵜⵍⴾⵎⵎ ⵢⵓⴰ ⵔⴰ ⵎⵤⵔ ⵏ⵿ⴾⵍ ⵜⵏ⵿ⴾⵍ ⵓⵏ ⵍⵂⵓⴰ ⵜⵎⵙⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵈⴾⵎⵏ ⴹⵗ ⵏⵎⵤⵔⵢ ⵏⵎⵛⵏⴰ ⴹⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ⴾⵜⵏⵏⴰ ⵙ ⵜⵤⵔⵜ ⵏⵎⵙ ⵔⵜ ⴹⵗⵙⵏ⵰ ⴹⵜ ⵓⴰ ⵏⵍⴾⵎ ⵢⵔⴾ ⴹⵔⵏⵏ ⵏ⵿ⵜⵗⵙⵓⵏⵏⴰ ⵏⵜⵎⵤⵍ ⵓⴰ ⵔⵏⵜ ⵜⵗⵙⵓⵏⵏⴰ ⴹⵎⴹⵔⵏⵏⵏⴰ⵰ ⴹⵗ ⴹⵢ ⵜⵙⵍⴾⵎ⵿ⵜⵏⵏⴰ ⵙ⵿ⵜⵤⵔⵜ ⵙ ⵏⴾⵏⵢ ⴹⴰ ⴹⵏⵗⵓⵔ ⵜⴹⵀ ⵏⵎⵛⵏⴰ ⵓⴰ ⵓⵔⵏ ⵢⵜⴹⵏ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ⵎⵛⵏ ⵜⵂⵏⵏ⵿ⵜ ⵏⵎⵛⵏⴰ ⵓⵔ ⵜⵍⴰ ⴹⴾⴹ⵰ ⵎⵔⵏ ⴹⵍⵍ ⵏ⵿ⵜⵔⴰ ⵜⴶⵜ ⵜⴰ ⴹⵏⵗⴶⴰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ⵏⴾⵏⵢ ⵙ ⵤⵏ ⴹⵏⵗⵀⴰ ⵙⵙⵀⵀ ⵏⵔⴾ ⵎⵤⵍⵏⵏⴰ ⵏ⵿ⵜⴰ ⴼⵍ ⴹⵏⵗⴾⴼⴰ ⵜⵎⴹⵔ⵿ⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ⵰ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵙ ⵜⴶⵔⵓⵎ ⴼⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ⵙⵏ⵿ⴾⵔⵏⴹⵓ ⵏⴹⵓ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙⵗⵎⵏⴰ ⴹⵗ ⵌⵏⵓⵏ ⵏⴹⵓ ⴹⵔⵙ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⴹⵔⵙ ⵏⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ⵓⵏ ⴶⵢ ⴼⵍ ⴹ ⵙⴾⵏⵓ ⴹⵗ ⵤⵎⵏ ⵓⵏ ⴹⵤⵢⵏⵏ ⴶⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵜⴶⴰ ⵔⵈⵎⵜⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⵍⵗⵏⵜ ⵢⵏⵗ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","ⴼⵍⵙ ⵍⴾⵏ ⵙ ⵔⵈⵎⵜ ⵙ ⵜⴶⵔⵓⵎ ⴼⵙⵏ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏⵓⵏ⵰ ⵎⵔⵏ ⵓⵔⴶⵗ ⴾⵓⵏⵢ ⵗⵔ ⴹⴼⵍ ⵓⵏ ⴾⵍⵔ ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ ⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ⵓⵔⴶⵗ ⵎⵤⵍⵏ ⵓⵏ ⵍⵗⵏⵏ ⵂⴾⵏⵏ ⴼⵙⵏ ⵏⵔ ⴹⵢ ⴶⵏ ⵤⵤⵓⵔⵏ ⵢⵜⴹⵏ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ⵛⵈⵍⴾ ⵏⵎⵛⵏⴰ ⵏⵎⵙ ⴹⵈⵍⴾ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴼⵍ ⴹ ⵏⴶⵓ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵏⵜⵎⵤⵍ ⵓⴰ ⵍⵗⵏ ⵙ ⵎⵛⵏⴰ ⵜⵙⵎⵜⴶⵏ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵢⵜⵏⵎⵤⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ⴹⵗ ⴹⵢ ⴾⵜⵓⵜ ⵔⵜ ⵓⴰ ⴹⵜ ⵓⴰ ⵜⵍⵎ ⵍⵗⵍⵎⵜ ⴹⵗ ⵜⵗⵙⵓⵏⵓⵏ ⵜⵙⴾⵏⵜ ⵙ ⵓⵔ ⵜⵎⵙⵎ ⴾⵍⵍⵢⵂⴹ⵰ ⵢⵜⴹⵏ ⵓⵏ ⵏⵏⵏ ⵎⵏ⵿ⴾⴹⵏ ⴶⵏⵏ ⵓⵔ ⵜⵎⵏ⵿ⴾⴹⵎ⵰ ⵏ⵿ⵜⵏⵢ ⵎⵔⵏ ⵎⵏ⵿ⴾⴹⵏⵙⵏ ⵓⵔ ⵎⵙ ⵔ ⵔⵜ ⴶⵏ ⴼⵙⵏ ⵏⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","ⴾⵜⵓⵜ ⵍⵈⵍⵜ ⵜⴰ ⵜⵂⵎ ⵙ⵿ⵜⵤⵔⵜ⵰ ⵤⵎⵏ ⵓⵏ ⴹⵢ ⵓⵔ ⵜⵆⵀⵍⵎ ⵍⵎⵙⵈ ⵜⵓⴶⴹⵍⵓⵏ ⵜⵛⵜ ⵏ⵿ⵜⵎⵜⵢ ⵏⵙⵔⵢⵍ⵰ ⵜⵎⵙⵎ ⵏⴼ⵿ⵜⵗⵏ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵔⴾⵓⵍ ⵏ⵿ⵜⵙⵆ ⵓⴰ ⴶⴰ ⵎⵛⵏⴰ⵰ ⵍⵓⵆ ⵓⴹⵢ ⵓⵔ ⵜⵍⵎ ⵜⵎⴰ ⵓⵍⵢⵏ ⵓⵔ ⵜⵍⵎ ⵜⵙⵆ ⵓⵍⵢⵜ ⴹⵎⵛⵏⴰ ⴹⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ⵎⵛⵏ ⵎⵔⴹⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵔ⵿ⵜⵢⵜⵏⵓⵏ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴾⵓⵏⵢ ⵓⵏ ⵙ ⴾⵍⴰ ⴹ ⵜⴶⴶⵎ ⵎⵛⵏⴰ ⵜⵂⵤⵎⴹⵓ ⵙ ⵜⵔⵢⵜ ⵏⵤⵏⵢ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵍⵈⵔⵏⵏⴰ ⵏ⵿ⵜⴰ ⵙⵔ⵿ⵜⵢⵏ ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⴶⵏ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵔⵤⴰ ⵜⵗⵔ⵿ⵜ ⵜⴰ ⵜⵏ⵿ⵜⵤⵎⵤⵢⵜ ⴾⵙ ⵏⵎⵤⵏ⵿ⴶⴰ ⴶⵔⵙⵏ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵗⵙⵏⵜ ⵜⴰ ⴾⴼⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ⵔⵜ ⵓⵏ ⴶⵢ ⵙⴾⵙ ⵓⴰ ⴹⵏⴶⴰ ⵜⵓⵔⵜ ⴹⵍⵓⵌⵀⵏⵜ ⴹⵛⵔⴹⵏⵜ⵰ ⴶⴰ ⵍⵈⵔ ⴶⵔ ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⴹⵔⵙⵏ ⴶⴰ ⴶⵏ ⵜⵎⵜⵢ ⵢⴹⴰ ⵜⵢⵏⵢⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⴶⴰ ⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ ⵏ⵿ⵜⴰ ⵙ ⵙⵔ⵿ⵜⵢ ⴾⵍⵍⵢⵂⴹ ⴹⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⴶⵏ ⵜⵗⵙⴰ ⵢⴹⴰ⵰ ⴶⵙⵏ ⵍⵈⵔ ⴹⵎⵛⵏⴰ ⴾⵙ ⵏⵎⵤⵏ⵿ⴶⴰ ⴶⵔⵙⵏ ⵙⵜⵓⵜⵢⵜⵢ ⵓⴰ ⴶⴰ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ⵎⵔⵏ ⵙⴹⵓ ⵢⴹⵓⵏⴶⵓ ⵙⵍⵏ ⵏⵍⵈⵔ ⵜⵏⵎⵙⵏ ⵍⵏ⵿ⵌⵍ ⴾⵓⵏⵢ ⵏⵎⴶⴶⵏⵏ ⴹⵎⵛⵏⴰ ⵎⵍ ⴹⵗ ⵍⵈⵔ ⵢ ⵓⵏ ⵜⵂⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ⴹ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⴼⵔⴶⵏ ⴹⵏⵗⵤⵏⵎⵂⵤ ⴾⵜⵏⵏⴰ ⴹⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙⵏⵜ ⴹⵢ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ⵎⴾⵏ ⴹⵗ ⵙ ⵀⵙ ⵜⵎⵙⵎ ⵏⴼ⵿ⵜⵗⵏ ⵓⵍⴰ ⵗⵔⵀ⵰ ⴾⵍⵔ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵎ ⴾⵓⵏⵢ ⴹⵜⵎⵜⵢ ⵤⴹⴶⵜ ⵏⵎⵛⵏⴰ ⵜⵎⵙⵎ ⴾⵍ ⵂⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ⵜⵎⵙⵎ ⵂⵏ ⵙ ⵏⵎⵤⵍ ⴹⵏⵀⵜⵏ ⵎⵙⵏⵏ ⵛⵙⵜⵢⵜⵢⵏⵜ ⵎⵙ ⵍⵎⵙⵈ ⵢⵢⵙⴰ ⵜⵂⵏ⵿ⵜ ⵜⵏ ⵜⵙⴾⵀⵍ⵿ⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ⵛⵂⵏ ⵛⵏ ⵙ ⴾⵔⵙ ⵂⵏ ⵓⵏ ⴾⵍ ⴾⵏⵏⵜ ⵏⵎⵜⴼ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵔ⵿ⵜⵢⵜ ⴹⵍⵎⵙⵈ ⵆⵍⵏⵜ ⵂⵏ ⵤⴹⴶⵏ ⵏⵍⵗⵀⴹⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵙⵆ ⴹⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ⴾⵓⵏⵢ ⴹⵗ ⵜⵔ⵿ⵜⵢⵎ ⵜⵆⵍⵎ ⴾⵔⵙ ⵢⵏ⵿ⴹⴰ ⴼⵍ ⴹ ⵜⵆⵍⵎ ⵜⵎⵤⴹⵆ ⵏⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵓⵏ ⴾⵍ ⴶⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵔ⵿ⵜⵢⵜⵏⵓⵏ ⴹⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ⵓⵏ ⴹⵗ ⴼⵍ ⵎⵙⴰ ⵏⴾ ⵀⵍⵙ ⵎⵙⴾⵙⵓ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴼⵍ ⴹⵍⵍⵏⵓⵏ ⴾⵓⵏⵢ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ⴶⵏ ⴹⴰ ⵜⴶⵔⵓⵎ ⵙⵍⵏ ⵏⵤⴾ ⵓⴰ ⴹⵙⵓⵔ ⵎⵛⵏⴰ ⴹⵗ ⵀⵜⵓ ⵏⵔⵈⵎⵜⵏⵜ ⵜⴰ ⴹⵜⵜⵓⴾⴼⵜ ⴼⵍ ⵜⵏ⵿ⴼⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ⵍⵎⵗⵏⴰ ⵎⵛⵏⴰ ⴹⵙⵏⴼⵍⵍⵏ ⵙⵔ ⵏ⵿ⵜⵔⵢⵜ ⵜⴰ ⴹⴶⴰ ⵙⵏ⵿ⵜⴰ ⴾⵜⵀⴰ ⴹⴰ ⵎⵙ ⵔⵜ ⵏ⵿ⵜⴼⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ⵙ ⵜⵗⵔⵎ ⵓⴰ ⴾⵜⵀⴰ ⴹⴰ ⴹ ⵜⵏⵢⵎ ⵓⴰ ⴹⵔⴶⴹⴰ ⴶⵔⵢ ⴶⵗ ⵢⵙⵔ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ⵙⵔ ⵓⴰ ⵓⵔ ⵜⵜⵓⴾⴼⴰ ⵎⵙⵏⵜⵏⵜ ⵢⵢⵜⴹⵏ ⵏⵤⵎⵏ ⵓⵏ ⴾⵢⵏⵏ ⵤⵏ ⵎⴾ ⵓⵙ ⵜⵓⵙⵏⴼⵍⵍ ⵎⵔⴹⴰ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵢ ⵏⵎⵤⵍ ⵏⵍⵎⵙⵈ ⴹⵏⵀⵜⵏⵜ ⵤⴹⴶⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ⵙⵔ ⵓⵏ ⵏ⵿ⵜⴰ ⴹⴰ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⴹⵎⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵓⵏ ⵎⵙⵏⵏ ⴾⵍⵍⵢⵂⴹ ⴶⵔⵓⵏ ⵜⴾⵙⵜ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹⴰ ⵆⵍⵏ ⴹⵗ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵙ ⵜⵔⵢⵜ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⴶⵏ ⴹⵍⵎⵙⵈ ⴹⵗ ⵔⴾⵓⵍ ⵓⴰ ⵂⵏ ⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ⵍⵎⵙⵈⵏ ⴹⵗ ⵙ ⵆⵍⵗ ⵎⵛⵗⵍⵏⵜ ⵜⵗⵀⴹⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵔⵏⴰ ⵏ⵿ⵜⵂⴾⵜ ⵏⵎⵛⵏⴰ ⵜⴶⵜ ⵙⵔⵈⵎⵜⵏⵜ ⵜⴰ ⴶⵔⵓⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ⵏⴾ ⴶⵔⵏ ⵜⵎⴹⵔⵢⵜ ⴹⵗ ⵎⵤⴶⵤⵏ ⴹⵢ ⵏⵎⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⴾⵜⵏⵙⵏ ⵎⵛⵏ ⴶⵔⵓⵗ ⵔⵈⵎⵜ ⵜⴰ ⵜⵜⵎⵙⵏ ⴶⵢ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵏⵔⵈⵎⵜⵏ ⵏⵍⵎⵙⵈ ⵙ ⵜⵓⵔⵍⴰ ⵢ ⴼⵔⴶⵏ ⴶⵔⵏⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ⵙⵏⴼⵍⵍⴰ ⴹⵗ ⵢⵢⵜⴹⵏ ⴾⵍ ⵎⴾ ⵓⵙ ⵏⵤⵎ ⵎⵛⵏⴰ ⵜⵔⵢⵜ ⵜⴰ ⵂⵔ ⵜⵜⵗⵔⴹ ⵙⴾⵎⵍ⵰ ⵜⵔⵢⵜ ⵜⵏ ⵂⵔⵓⴰ ⴹⵗ ⵜⵤⵔⵜ ⵜⵜⴶⴰ ⵎⵛⵏⴰ ⴹⵈⵍⴾⵏ ⵔⵜ ⴾⵍ ⵜⵎⵙ ⵙⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ⵏⴼⵍⵍ ⵓⴰ ⵜⴶⴰ ⵜⵔⵢⵜ ⵜⴰ ⵏ⵿ⵜⴰ ⴹⵤⵓⵢⵏ ⵎⵔⴹⴰ ⵙ ⵜⵗⵎⵔⵏ ⴹⵜⵎⵏⴾⵍⴰ ⵛⵏ ⵌⵏⵓⵏ ⴹ ⵤⴹⵢⵏⵜ ⵙⵢⴼⵜⵏ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⵜⵎⵙ ⵎⵙⵏⵜ ⵜⵏ ⵎⵛⵏⴰ⵰ ⵔⵜ ⵓⵏ ⵜⵔⵢⵜ ⵏⵍⴾⵏⵙⵜ ⵙ ⵤⴶⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ⵎⵔⵏ ⵓⵏ ⴹ ⴶⵓ ⵙⵎⴾ ⵓⵙ ⵜⵏⵤⵎ ⵎⵛⵏⴰ ⵎⵙ ⵔⵜ ⵗⵍⵍⵏ ⴾⵎⵍⴹⵓ ⴹⵗ ⴹⵗ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵎⵍⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ⵜⵙⵆ ⵜⴰ ⵏⴶⴰ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏ ⵙⵔⵙ ⴹⵏⵗⵜⴾⴼⵜ ⵜⴹⵔⴼⵜ ⵏⴹ ⵏⴼⵔⴶ ⵏⵎⵂⵤ ⴹⵎⵛⵏⴰ ⵙ ⵜⴼⵍⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ⴹⵗ ⴹⵢ ⴶⵎⵢⴰ ⴹⵗⵓⵏ ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵍⵆⵎ ⴼⵍ ⴹⵍⵍ ⵏⵍⵗⵤⵀ ⵓⴰ ⵜⴶⴰ ⴹⴰ ⴼⵍ ⴹⵍⵍⵏⵓⵏ⵰ ⵍⵗⵤⵀ ⵓⴰ ⵏ⵿ⵜⴰ ⴾⵓⵏ⵿ⵤⴾⴼⵏ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ⵓⵏ ⴹⵗ ⴼⵍ ⵙⵌⴹⴰ ⴹⵜ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ⵙⵏ⵿ⵜⴰ ⴶⵏ ⵙⵎ ⵢⴹ ⵜⵍⴰ ⵗⵢⵓⵏ ⴾⵍ ⴹⵗ ⵌⵏⵓⵏ ⴹⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ⵓⵍⴰ⵰ ⴶⵎⵢⵗ ⴹⵗⵙ ⴹ ⴾⵏⵓ ⵙⵙⵂⵢ ⵏⵓⵍⵏⵓⵏ ⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙⵏⵜ ⵓⴰ ⵤⴹⴶⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵏⵢⵏⵜ ⵜⴾⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ⵏ⵿ⵙⵢⵆⵓ ⴹ ⵤⴹⵗ ⵍⵎⵙⵈ ⴹⵗ ⵓⵍⵏⵓⵏ ⵙ ⵜⵔⵢⵜ ⵏⵤⴶⵤⵏⵓⵏ ⴹ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵤⵤⵓⵜⵏⵏ ⵓⵍⵏ ⵙⵂⴹⵏ ⴹⵗ ⴼⵍ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ⵏ⵿ⵙⵢⵆⵓ ⴹⵗ ⴹⵢ ⴹ ⵜⴾⵏⵎ ⵤⵤⵓⵢ ⴹⵗ ⵤⴶⵤⵏⵓⵏ ⵜⴼⵔⴶⵎ ⴹ ⵜⵎⵙⵙⴶⵔⵎ ⴹⵎⵤⴶⵤⵏ ⴹⵢ ⵤⴹⴶⵏⵏ ⴾⵍ ⴹⵗ ⵀⵜⵓ ⵏ⵿ⵜⵔⴰ ⵏⵍⵎⵙⵈ ⵜⴾⵏⵜ ⵍⵓⵢ ⴼⵍ ⴶⵏⴰ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ⵜⵤⴹⵢⵎ ⴹⵗ ⵜⵔⴰ ⵜⵏ ⵜⵍⵜ ⴹⵏⴶ ⵎⵙⵏⵜ ⴾⵍ⵰ ⴹⵢ ⴾⵓⵏ⵿ⵤⵜⴹⴾⵔ ⵜⵏⵢⴰ ⵏⵎⵛⵏⴰ ⵙⵎⴾ ⴾⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ⵎⴾⵏ ⴹⵗ ⵙ ⵎⵛⵏⴰ ⴼⵔⴶ ⴹ ⴶⵓ ⵢⵔⵜ ⴾⵍ ⴶⵢ ⴼⵏ ⵓⴰ ⴹⵗⵙ ⵏⴶⵎⵢ ⴼⴰ ⴹⵗ ⵓⴰ ⵏⵗⵍ⵰ ⵔⵜ ⵓⵏ ⵜⴶⵢ ⵙ ⵜⵔⵏⵏⵜ ⵜⴰ ⴹⵗⵏⴰ ⵜⵛⵗⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ⴶⵔⵓⵜ ⵎⵛⵏⴰ ⵜⵓⵙⵗⵎⵔ ⴹⵗ ⵍⴾⵏⵙⵜ ⴶⴰ ⵓⵏ ⴹⵗ ⵜⵙⵆ ⴹⵍⵎⵙⵈ ⴹⵗ ⵤⵎⵏ ⴾⵍ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ⴹⵗ ⴹⵢ ⵔⵜ ⴹⴰ ⵓⴰ ⴹⵗⵓⵏ ⴶⵎⵢⴰ ⵏⴾ ⵎⵙⵏ ⵎⵙⴾⵙⵓ ⴼⵍ ⵙ ⵗⵀⴹⵗ ⵎⵍⵢ ⴾⵓⵏⵢ ⵗⵔⴰ ⵎⵛⵏⴰ ⴶⵓⵜ ⵍⵈⵍ ⵏⵂⴶⵏ ⴹⵜⵓⵗⵔⴰ ⵓⴰ ⵜⵜⵓⴶⵎ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ⵆⵍⵜ ⴼⵓ ⵢⵜⴹⵏ ⵓⵔ ⵏⴹⴾⵍ ⵎⵏⵙⵏ ⵜⵍⵎⴹⵎ ⵜⵆⵍⵎ ⵎⵤⵤⵢⴹⵔ⵰ ⵏⵎⵆⵀⵍⵜ ⴶⵔⵓⵏ ⵙ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ⴹⴶⵤⵜ ⴼⵓ ⴹⵗ ⴶⵎⵢ ⵏ⵿ⵜⵔ⵿ⵜⵢⵜ ⵜⴰ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙ ⵜⵙⵆ ⵏⵍⵈⵔ ⵜⴰ ⵜⵍⵜ ⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ⵜⵗⵙⴰ ⵢⴹⴰ ⵜⵜⵍⵜ ⴹⵏ⵿ⴼⵙ ⵢⵏ⵿ⴹⴰ⵰ ⵎⴾⵏ ⴹⵗ ⵙ ⵎⵛⵏⴰ ⵗⵔⵓⵏ⵿ⴹⵓ ⵙⴹ ⵜⴶⵎ ⵜⵎⴰ ⵢⵏ⵿ⴹⴰ ⵜⵎⵙⵏ ⵓⵙ ⴹⵜⵜⵓⵗⵔⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ⵎⵍⵢ ⵢⵏ⵿ⴹⴰ ⵜⵍⵏ ⵍⵢ ⵤⴶⵤⵏ ⵢⵏ⵿ⴹⴰ ⴹⵍⵎⵗ ⴹⵗ ⵎⵏ ⵢⵏ⵿ⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ⵎⵛⵏⴰ ⴹⵗ ⵢⵏ⵿ⴹⴰ ⵎⵙ ⵎⵙ ⵀⴰ ⵏⵓⴹⵏ ⴾⵍ ⵈⴾⵎ ⴼⵍ ⵢ ⵜⵍⵏ ⴾⵍ ⵜⴶⵓ ⴶⵜⵏⵜ ⵙ ⵜⵔⵢⵜ ⵏⴹ ⵜⵍⴰ ⵢⵏ ⵔ⵿ⵜⵢ ⴹⵗ ⴹⴹ ⵜⵍⴰ ⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⴾⵢⵏ ⴹⵗⵏⴰ ⴶⵔⵓ ⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵓⵍ ⵓⵏ ⵙⴹⴶⵔ ⵓⴰ ⵜⴾⴼⴰ ⵍⵎⵙⵈ ⴹⵗ ⵛⵗⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ⵓⵏ ⴹⵗ ⴼⵍ ⵏⵏ ⵍⴾⵜⵀⵏ «ⴶⵤⵢ ⵙ ⴹⴶⵏ ⵓⵏ ⴹⴾⵍⵏⵏ ⵓⵢ ⵓⵏ ⵂⵏⵏ ⵜⵍⴰ ⵜⵤⵔ ⴶⴰ ⵛⵂⴾⵜⵏ ⵢⵢⵜⴹⵏ⵰» ");
INSERT INTO ttqt_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ⵎⴰ ⵎⵙ ⵍⵎⵗⵏⴰ ⵏⵀⵜⵓ ⵜⵏ «ⴶⵤⵢ»⵰ ⵓⵔⴶⵗ ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ⵔⵙ ⵂⵔ ⵎⵍ ⴹⵓ ⵎⴹⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ⵓⴰ ⴹⵤⵀⵏ ⵏ⵿ⵜⴰ ⴶⵤⵢⵏ ⵎⵍ ⴹⵏⴶ ⵌⵏⵓⵏ ⴾⵍ ⴼⵍ ⴹ ⴹⵏⵢ ⴹⴶ ⴾⵍ ⴹⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ⵎⵔⵏ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⴶⵏ ⵢⵜⴹⵏ ⵓⵢⴹ ⵏⵎⵤⵍ ⴶⴰ ⵓⵢⴹ ⵏⵀⵜⵏ ⴶⴰ ⵓⵢⴹ ⵎⴶⵏ ⵏ⵿ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⴶⴰ ⵓⵢⴹ ⵎⴹⵏⵏ ⴹⵎⵙⵙⵗⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ⵛⵂⴾⵜⵏ ⵛⵏ ⴹⵏ ⴶⵏⵜ ⵍⵎⵙⵈ ⴼⵍ ⵙⵙⵂⵢ ⴹⵙⴾⵎⵍ ⵏⵎⵤⴶⵤⵏ ⴼⵍ ⴹ ⴼⵔⴶⵏ ⵛⵗⵍ ⵓⵙ ⵜⵓⵗⵔⵏ ⵢⴹ ⵜⴾⵏⵓ ⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ ⵙⵂⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ⵎⴾⵏ ⴹⵗ ⵙ ⴾⵜⵏⵏⵗ ⵙ ⵤⴰ ⵏⵓⴹ ⵏⵎⵏⴾ ⴹⵗ ⵤⴶⵤⵏ ⴶⴰ ⵓⵏ ⴹⵗ ⵜⵎⵤⴹⵢⵜ ⵏⵀⵔⵔ ⵏⵎⵛⵏⴰ⵰ ⵜⵙⵍⴾⵎ⵿ⵜ ⵏⵓⵏ ⵙ ⴹ ⵏⵆⵍ ⵎⵤⴶⵤⵏ ⴾⵎⵍⵏⵏ ⵜⵏⴼⵍⵍ ⴹⵗⵏⴰ ⵜⵛⵜ ⵜⴾⵎⵍⵜ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ⴹⵢ ⴹ ⵤⵀⵙ ⵏⵎⵙ ⵀⵔⵔⵏ ⵎⴹⵔⵔⵏⵏ ⴹⴶⵏⵏ ⵙⴰ ⴹⵙⴰ ⵀⵜⵏ⵿ⵜⵏ ⵤⵏⴼⵏ ⵏ⵿ⵙⵙⵗⵔⵜⵏ ⵜⴶⵏ ⵏⵙⵀⵂⴰ ⵏⵎⴾⵔⵙ ⵙⵈⵔⴾⵏⵏ ⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ⴾⵍⵔ ⴹⵢ ⴹ ⵤⴰ ⵏⵎⵍ ⵜⴹⵜ ⵏⴶⵙ ⵎⵍ ⴶⵏ ⵙ ⵜⵔⴰ ⵏⵜⵢ ⴹⵗ ⴾⵍⴾ ⵏⵏⵎⴹ ⴹⵗ ⵜⵔⵢⵜ ⵏⵓⴰ ⵎⵙⵏ ⵗⴼⵏⵏⴰ ⵍⵎⵗⵏⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ⵏ⵿ⵜⵏ ⴹⵗ ⵙⴹⵓⵍⵏ ⵜⵗⵙⴰ ⴾⵜⵏⵜ ⵏ⵿ⵜⴰ ⴹⵗ ⵗⵔ ⴹⵜⴶⵔⵓ ⵜⵗⵙⴰ ⵙⵂⵜⵏⵜ ⴶⴰ ⵓⵏ ⴹⵗ ⵜⵔⴰ⵰ ⵏ⵿ⵜⴰ ⴹⵗ ⵙⵏⵎⵏⴾⵏ ⵜⵗⵙⴰ ⵜⵏⵎⵜⴼ ⵙ ⵙⵎⵗⵔⵙ ⵙⵂⵜⵏⵏ ⴼⵍ ⴹ ⵜⴼⵔⴶ ⵜⵙⵍⵜ ⴾⵍ ⴶⵢ ⵏⵛⵗⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ⴹⵗ ⴹⵢ ⴶⵢⵗ ⵙⵍⴾⵏⵗⵓⵏ ⵙⵙⵎ ⵏⵎⵍⵢ ⵙ ⵓⵔ ⵎⴾⵏ ⴹ ⵜⵍⵙⵎ ⴶⵢ ⵏⵎⵤⵍⵏ ⵓⵏ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵎⵙ ⴾⵍⵍⵢⵂⴹ ⵓⵔ ⵏⵍⴾⵎ ⵔ ⵢ ⵜⵢⵜⵢⵏⵙⵏ ⵜⵎⵙⵜ ⵛⵀⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ⵜⵢⵜⵢⵏⵙⵏ ⵓⵔ ⵜⵜⵂⴰ ⵏⵔ ⵎⵙⵏ ⵏⴼ⵿ⵜⵗⵏ ⵢ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵙⵗⵎⵔⵜ ⵎⵛⵏⴰ ⵙⵙⵀⵀ ⵏⵍⵌⵂⵍⵏⵙⵏ ⵙⵔⵙⵏ ⴹⵜⵓⵢ ⵜⵗⵔ⵿ⵜ ⵏⵓⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ⵀⵙ ⵙⵏⵏ ⵓⴰ ⵍⵗⵏ ⵓⵍⴰ ⵓⴰ ⵓⵔ ⵏⵍⵗ⵰ ⵛⴾⵍⵏ ⴹⵗ ⵜⵎⵤⵔⵢⵜ ⵜⴶⵏ ⵎⵤⵍⵏ ⵤⵤⵍⵜⵏⵏ ⴶⴹⵎ ⴹⵀⴰ ⵏ⵿ⵜⵍⴰ ⵏⴶⴹⴰ ⴹⵗ ⵤⵏⴼⵏ ⴾⵍ ⵏⵎⵤⵍⵏ ⵙⵎⴹⵙⵏⵏ ⴾⵏⵏ ⵜⵔⴰ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ⵎⵛⵏ ⴾⵓⵏⵢ ⵓⵔⴶⵗ ⵎⴾ ⵓⵏ ⵙ ⵜⵙⵏⵎ ⵓⴰ ⵎⵙ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ⴹⴹ ⵤⵎⵙ ⵜⴶⵔⵓⵎ ⵙⵍⵏ ⵏⵍⵎⵙⵈ ⵜⵜⵓⵙⵙⵗⵔⵎ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⴹⵔⵙ ⵓⴹⵢ ⵜⵜⵓⵙⵙⵏⵎ ⵜⴹⵜ ⵜⴰ ⵜⵂⵜ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⴹ ⵜⵎⵤⵢⵎ ⴹⵍⵈⵍⵏⵓⵏ ⵓⴰ ⵔⵓⵏ ⵜⵎⵙⵏ ⵍⵈⵍ ⵏⴶⴹⵎ ⵓⵙ ⴾⵍⴰ ⵜⵜⵎⵙⵎ ⵜⵓⵢⵏ ⵔⴾ ⴹⵔⵏⵏⵜ ⵙⵈⵔⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ⵆⵍⵜ ⵢⵜⴹⵏ ⵛⵛⵏⵢ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵙⵎⵜⵢ ⵜⵢⵜⵓⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵍⵙⵓ ⵓⴹⵏ ⵜⵀⴹⵆ ⵜⵆⵍⵜ ⵜⵀⴹⵆⵏⵓⵏ ⵍⵈⵍ ⵢⵏⵢⵏ ⵓⴰ ⴹⴶⴰ ⵎⵛⵏⴰ⵰ ⵍⵈⵍ ⵓⵏ ⵜⵏⴼⵍⵍ ⴹⵗ ⵜⵆⵜ ⴹⵜⵤⴹⴾ ⵛⵏ ⵜⵂⴾⵓ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵎⵤⵢⵜ ⴹⴶⵢ ⵏⵀⵂⵓ⵰ «ⴾⵢⵏ ⴹⵗⵓⵏ ⵛⵓⵍⵜ ⵜⴹⵜ ⵗⵙ ⵢⵛⵆⵗⵏⵜ» ⴹ ⴾⵢⵏ ⴹⵗⵏⴰ ⵜⵙⵍⵜ ⵎⵙ ⵏⵓⵏ ⵂⴹⵜⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","«ⵙ ⴾⵓⵏⴶⵤ ⵍⵂⵎ ⴹ ⵓⵔ ⵜⴶⵎ ⵀⴾⴹ⵰» ⴹ ⵓⵔ ⵜⴹⵓ ⵜⴼⴾ ⵂⵓⵏ ⵍⵂⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ⴹ ⵓⵔ ⵜⵍⵎⵎ ⵢⵀⵍⵙ ⵜⵔⵢⵜ ⵙ ⴹⴶⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ⵓⴰ ⵎⵙⵏ ⵀⵢⴹⴶ ⵎⵤⵢⵜ ⴹⵛⴾⵔⴰ ⵛⵛⵗⵍⵜ ⵛⵗⵔⴹⵏⵜ ⵛⵗⵍⵜ ⵙ ⴼⵙⵏⵜ ⴼⵍ ⴹ ⴶⵔⵓ ⵜⵏ⵿ⴼⴰ ⵤⴰ ⵤⵏ ⵢ ⵎⴹⵔⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ⴹⵓⵔ⵿ⵜⴶⵎⴹ ⵀⵜⵓ ⵓⵍⵢⵜ ⵍⵀⵙⵜ ⵎⵓⵏⵓⵏ⵰ ⴾⵍⵔ ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵔ ⵀⵜⵜⵏ ⵂⵙⵢⵏⵏ ⵤⴰ ⵜⴶⵤ ⵜⵏ⵿ⴼⴰ ⵙ ⵜⴶⴰ ⴹⵔⵔⵜ ⵙⵓⵏ ⵆⵍⵏⵜ ⴹⵗ ⵔⵈⵎⵜ ⵢ ⵓⴰ ⴹⵙⵏⵜⵙⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ⴹ ⵓⵔ ⵜⵤⵤⴾⵏ⵿ⵤⵔⵎ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⴼⵍⵙ ⵜⵔⵢⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏⵏ ⵙ ⴾⵓⵏⵙⵓⵔ ⵎⵛⵏⴰ ⵌⵓⵍⵏⵜ ⵢⵤⵍ ⵓⵏ ⵜⴹⵔⴼⵜ ⵜⵏ ⵜⵤⵔⵙ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ⵜⴶⵎⴹⵜⴾⵓⵏ ⵢ ⵜⵜⵍⴰ ⵜⵙⵎⵎ⵿ⵜ ⴹⵗⵛⵛⵢ ⴹⵍⵂⵎ ⴹⵜⵂⵔⵛⵜ ⴹⵔⵀⴹⵏ ⴹⵆⵍ ⵛⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ⵜⵏⵎⴶⵓⵜ ⵓⴰ ⵍⵗⵏ ⴶⵔⵓⵏ ⴾⵢⵏ ⵆⵍ ⵓⴹⵏ ⵜⵂⴰ ⵜⵂⵏⵏ⵿ⵜ ⵍⵎⴹ ⵢ ⵎⴹⵓⵏⵜ⵰ ⴾⵢⵏ ⴹⵗⵓⵏ ⵙⵔⴼⵜ ⵢ ⵓⵏ ⵂⴹⵜⵏⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⴹⵓⵏⵙⵔⴼ ⵎⵛⵏⴰ ⵙ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ⴹⴹ ⵤⵎⵙ ⵀⵔⵔⵏ ⵏⵎⵛⵏⴰ ⴾⵏⴰ ⵜⵔⴰ ⵜⵎⵙⵎ ⵓⴹⵢ ⵍⴾⵎⵜ ⵢⵍⵎⵙⵍ ⵓⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ⵆⵍⵜ ⵢⵜⴹⵏ ⵛⴾⵍⵏⵏ ⴹⵗ ⵜⵔⴰ ⵤⵏ⵿ⴹ ⵎⴾ ⵓⵙ ⴹⵏⵗⵔⴰ ⵍⵎⵙⵈ ⵂⵔ ⵙ ⴾⴼⴰ ⵎⵏⵜ ⵢ ⵎⵛⵏⴰ ⵎⵙ ⵜⵂⴾⵜ ⴹⵜⴾⵜⵢ ⵜⵍⵜ ⵗⵔⵙ ⴹⵓ ⵤⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ⵏⵎⴶⴶⵜ ⴹⵤⵏⴰ ⴹⵎⵤⵍⵏ ⵙⵎⴹⵙⵏⵏ ⵆⵍⵏ ⴹⵜⵔⴰ ⵏⴹⵏⵜ⵰ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⴹⵓⵔ⵿ⵜⵎⴹⴾⵍ ⵀⵜⵏⵙⵏ ⴼⴹⴰ ⵗⵔⵓⵏ⵰ ⵓⵏ ⴹⵗ ⵙ ⵂⵔ ⴹ ⵜⴶⵏ ⵎⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵔⵜⵏ ⵌⵔⴶⵏⵏ ⵓⵍⴰ ⵀⵜⵜⵏ ⵓⵔ ⵏⵍⴰ ⵍⵎⵗⵏⴰ ⵙ ⵤⵏ ⵜⵏⵜⴶⴰ ⵎⵙⴾⵍ ⵓⵍⴰ ⵀⵜⵜⵏ ⵌⵔⴶⵏⵏ⵰ ⴹⵢ ⵓⵔ ⵜⵓⴶⵓ⵰ ⴾⵍⵔ ⵜⴶⵓⵜ ⴶⴹⵏ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ⴼⵍⵙ ⵙⵏⵜ ⵓⵍⵏ ⵙ ⵓⴹⵏ ⴾⵍ ⵓⴰ ⵜⴶⵏ ⵤⵏⴰ ⵓⴹⵢ ⵎⴹⵙ ⴶⴰ ⵜⵎⵏⵜ ⴹⵗ ⵔⵤⵗⵏ ⵏⵢⵜⴹⵏ ⵍⵎⵗⵏⴰ ⵗⵀⴹ ⵙⵏⵎⵏ ⵓⴹⵢ ⵓⵔ ⵤⴶⵔⵓ ⴹⴶⵔ ⵓⵍⵢⵏ ⴹⵗ ⵜⵗⵎⵔ ⵜⵏ ⵍⵎⵙⵈ ⴹⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ⴾⵓⵏⵓⵔⴾⵔⵙ ⵓⴹⵏ ⵓⵍⵢⵏ ⵓⵍⴰ ⵙⵈⵔⴾⵓⵏ ⵙ ⵀⵜⵜⵏ ⵏⵀⵏⵏ ⴼⵍⵙ ⵔⵜ ⵓⵏ ⵏ⵿ⵜⴰ ⴹⵜⵓⵢⵏ ⵍⵂⵎ ⵏⵎⵛⵏⴰ ⵙⵢⵜⴹⵏ ⵓⵏ ⵏⴼⵍⴶ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵍⵎ ⵜⵙⵆ ⵓⵍⵢⵜ ⴹⵢⵜⴹⵏ ⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ⴼⵍⵙ ⵍⴾⵏ ⵙ ⴹⵜ ⵓⴰ ⴾⵍⴰ ⴹ ⵜⵂⵎ ⵛⵢⵢ ⵎⵛⵏ ⵎⵔⴹⴰ ⵜⵂⵎ ⵏⵔ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⴹⵎⵍⵢ⵰ ⴶⵓⵜ ⵍⵈⵍ ⵓⴰ ⵜⴶⵏ ⵢⵜⴹⵏ ⵂⵏⵏ ⵏⵔ ");
INSERT INTO ttqt_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ⴼⵍⵙ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⴹⵜⵓⵢ ⵏⵔ ⵜⵎⵙ ⵤⵏⴼⵏ ⵏⵔⵜⵏ ⴾⵍ ⵓⵏ ⵍⵗⵏⵏ ⴹⵓⵏ ⵗⴹⵏⵏ ⴹⵓⵏ ⵎⵙⵏⵏ ⵜⴹⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ⴹⴹ ⵤⵎⵙ ⵜⵂⵎ ⵏⵔ ⵓⴹⵢ ⴶⵎⵢⵜ ⵓⵍⵏ ⴹⴹ ⵜⵙⵏⵎ ⵓⴰ ⴶⵔⵤⵏ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ⵎⵔⵏ ⴹ ⵓⵔ ⵜⴹⵔⵓⵎ ⵓⵍⴰ ⴹⵎⵤⵍⵏ ⵏⵀⵏⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⵂⵏⵏ ⵛⵢⵢ ⴾⵍⵔ ⵜⴶⵢⵜ ⵙⵔⵙⵏ ⵜⵙⴼⴶⵎ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ⴼⵍⵙ ⵍⴾⵏ ⵙ ⵓⴰ ⵜⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴹⵢ ⴹⵗ ⵙⵔ ⵙⴾⵔⴾⴹ ⴼⴹⴰ ⵓⵍ ⴹⵗ ⵀⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ⵎⵛⵏ ⵙ ⴼⴶⵏ ⵔⵜⵏ ⵓⵏ ⵓⵔⵏ ⵤⵂⵔ ⴹ ⵏⴼⵍⵍⵏ ⵎⵤⵍⵏⵙⵏ ⵤⵍ ⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ⵎⵔⵏ ⵔⵜ ⴾⵍ ⵓⴰ ⴹⵗ ⵏⴼⵍⵢ ⵏⵔ ⵓⴹⵢ ⵏⵔ ⵎⵙ⵰ ⵓⵏ ⴹⵗ ⴼⵍ ⵜⵓⵏⴰ «ⵏ⵿ⴾⵔⵏ ⴾⵢ ⵓⴰ ⵏ⵿ⵙⵏ ⵏ⵿ⴾⵔⵏ ⴹⵗ ⵏⵎⵜⵏ ⴹⵢ ⴼⵍⴾ ⵙⵎⵍⵓⵍⵓ ⵍⵎⵙⵈ ⵏⵔⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ⴹⵗ ⴹⵢ ⵏ⵿ⴾⴹⵜ ⵓⵍⵏ ⵢⵍⵈⵍⵏⵓⵏ ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵤⵏ ⵎⵙⴾⵍⵏ ⴾⵍⵔ ⵆⵍⵜ ⵎⵍⵏ ⵏ⵿ⵜⵢⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ⴹ ⵓⵔ ⵜⵙⵀⵏⵏⵎ ⵛⵎⵤⵢⵜⵏ ⵛⵏ ⵜⴶⵔⵓⵎ ⴼⵍⵙ ⵔⴾ ⵤⵎⵏ ⵏⵂⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⴹ ⵓⵔ ⵜⵆⵍⵎ ⵤⵏ ⵍⵌⵂⵍⵏ ⴾⵍⵔ ⵆⵍⵜ ⵢⵜⴹⵏ ⴶⵔⵏⵏ ⵓⴰ ⴼⵍⵓⵏ ⵔⴰ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ⵎⵔⵏ ⴹ ⵓⵔ ⵜⵙⵎⵙⵓⴹⵎ ⵎⵏⵓⵏ ⵙⵙⵎⴹ ⵔⵜ ⵓⴹⵢ ⵌⵎⵌⵍⴹ ⵤⴶⵓ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ⵰ ⴾⵍⵔ ⵆⵍⵜ ⵢⵜⴹⵏ ⴹⵏⵢ ⵏ⵿ⴼⵙ ⵏⵎⵛⵏⴰ ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ");
INSERT INTO ttqt_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ⵜⵏⵎⴶⵓⵜ ⵍⵎⵗⵤⵜⵏ ⴶⵔⵓⵏ ⵙ ⵜⵙⵔⵏⵜⵏ ⵏⵤⵀⵔ ⴹⵜⴶⵢⵜⵍⵏ ⴹⵙⴾⵏ ⴹⴶⵎⴹⵏⵏ ⵗⵔ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⴶⵓⵜ ⵙⴾⵏ ⵎⵙⵏⵏ ⵜⵎⵍⵏ ⵏⵎⵛⵏⴰ⵰ ⴶⵓⵜ ⵓⵏ ⵢⵎⵍⵢ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ⵜⴶⴹⵢⵜ ⴼⵓ ⵔⵜ ⴾⵍ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵙⵙⵎ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ⴾⵢⵏ ⴹⵗⵓⵏ ⵀⵔⴹⴶⵜ ⵢ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⴶⵎ ⵓⵏ ⴹⵗ ⵜⴾⵙⴹⴰ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ⵛⴹⴹⵏ ⵀⵔⴹⴶⵎⵜ ⵢ ⵎⴹⵏⴾⵎⵜ ⵤⵏ ⵎⴾ ⵙ ⵜⵀⵔⴹⴶⵎⵜ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ⴹ ⵍⵙ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵤⵔ ⵏ⵿ⵜⵏ⵿ⵜⵜ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵍⵎⵙⵈ ⵎⵙⵏ ⵎⵤⵔ ⵏⵍⴾⵏⵙⵜ ⵜⵎⵙⵜ ⵜⵗⵙⵏⵜ ⵎⵔⵏ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵎⵙⵏ ⵏⵙⴼⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⵜⵀⵔⴹⴶ ⵍⴾⵏⵙⵜ ⵢⵍⵎⵙⵈ ⵜⵏ⵿ⵜⵜ ⴾⵍ ⵜⵀⵔⴹⴶⵜ ⵢⵍⵙⵏⵜ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ⵎⴹⵏ ⵔⵓⵜ ⵛⴹⴹⵏⵓⵏ ⵙⵎⴾ ⵙ ⵔⴰ ⵍⵎⵙⵈ ⵍⴾⵏⵙⵜ ⵂⵔ ⵙ ⵎⵏⵜ ⴾⴼⴰ ⴼⵍ ⴹⵍⵍⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ⴼⵍ ⵜⵜⵙⴾⵜ ⵙ ⵎⵏⵜ ⴹⴼⵔ ⵙ ⵜⵜⵤⵤⴹⴶ ⵙⵎⵏ ⵍⵎⵗⵏⴰ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ⵓⵏ ⴶⵎⵢ ⵙⵔⵙ ⴹ ⵜⴾⵏⵓ ⵍⴾⵏⵙⵜ ⵛⵂⵙⵢ ⵓⵔ ⵜⵜⵓⵔ ⵎⵙⵏ ⵜⵜⵏⵆⵜ ⵓⵍⴰ ⵏⴾⵎⵢ ⵓⵍⴰ ⵔⵜ ⵤⵏ ⵓⵏ ⴼⵍ ⴹ ⵜⵤⴹⴶ ⴹⵗ ⵎⵙⵏ ⵍⵂⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ⵎⴾⵏ ⴹⵗ ⵙ ⵎⴹⵏ ⴹⴰ ⵓⵔ⵿ⵜⵏ ⴹ ⵔⵏ ⵛⴹⴹⵏⵙⵏ ⵤⵏ ⵜⵔⴰ ⵜⴰ ⴶⵏ ⵢ ⵎⵏⵙⵏ⵰ ⵓⴹⵏ ⵓⴰ ⵔⵏ ⵜⵗⵔⵙ ⵓⴹⵢ ⵎⵏⵜ ⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ⵍⴾⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⴹ ⵜⵓⵏⵢ ⵓⴹⵏ ⴾⵢⴹⵏ ⵜⵗⵙⵏⵜ⵰ ⴾⵍⵔ ⵓⴹⵏ ⵛⵜⵛⵢ ⵜⴶⵓ ⵎⵏⵜ ⵏⵜⴼ ⴹⵜⵗⵙⵏⵜ ⵤⵏ ⵓⴰ ⴶⴰ ⵍⵎⵙⵈ ⵢⵍⴾⵏⵙⵜ ");
INSERT INTO ttqt_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ⴹ ⵏⴾⵏⵢ ⵛⵙⵍⴹ ⵏ⵿ⵜⵗⵙⴰ ⵏⵍⵎⵙⵈ ⵏⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","«ⵓⵏ ⴹⵗ ⴼⵍ ⵤⴼⵍ ⵍⵙ ⵀⵏⵜ ⴹⵏⵏⵜ ⴶⵍⵓ ⵔ⵿ⵜⵢ ⴹⵜⵗⵔⵙ ⵆⵍⵏ ⵜⵗⵙⴰ ⵢⴹⴰ⵰» ");
INSERT INTO ttqt_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ⵔⵜ ⵓⴰ ⵏ ⴹⴰ ⴹⵗ ⵀⵜⵓ ⵏⵍⵎⵙⵈ ⴹⵍⴾⵏⵙⵜ ⵎⵙ ⵙⵔ ⵤⵓⵔⵏ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ⵈⵙⵍ ⴾⵍⴾ ⵏⵢⵏ ⴹⵗⵓⵏ ⴶⵓⵜ ⵢ ⵜⵗⵔⵙ ⵜⵔⴰ ⵜⴰ ⴶⴰ ⵢ ⵎⵏⵜ ⵜⵏ⵿ⵜⵜ ⴹⵗ ⵜⵙⵗⵎⵔⵜ ⵍⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ⵀⵔⵔⵏ ⵀⵔⴹⴶⵜ ⵢ ⵎⵔⵓⵏⵓⵏ ⵤⵏ ⵙ ⵜⵀⵔⴹⴶⵎ ⵢⵎⵍⵢ ⴼⵍⵙ ⵓⵏ ⴹⵗ ⵗⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","ⵍⵓⵌⵀ ⵓⴰ ⵤⵔⵏ ⵙ ⴶⴰ ⵎⵛⵏⴰ ⵔⴾⵓⵍ ⵏⵙ ⴹ ⵍⵓ ⵔⵤⵏ ⵏⴰ «ⵙⵗⵎⵔ ⵀⵏⴾ ⴹⵏⵏⴾ ");
INSERT INTO ttqt_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","ⴼⵍ ⴹ ⵜⴶⵔⵓⵗ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⵍⵗ ⵜⵗⵔⵙ⵿ⵜ ⵜⴶⵜ ⴹⵗ ⴹⵏⵜ⵰» ");
INSERT INTO ttqt_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","ⴾⵓⵏⵢ ⵎⵔⵏ ⵀⵜⵏ ⴹ ⵓⵔ ⵜⵛⵗⵛⵛⵎ ⵀⵔⵔⵏⵓⵏ ⴾⵍⵔ ⵙⵙⵗⵔⵓⵜⵏ ⵜⴶⵎ⵿ⵜⵏ ⴹⵗ ⵜⵔⵢⵜ ⵜⵎⵍⵎⵙⵏ ⵓⴰ ⴼⵍ ⵔⵗⵎ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","ⴾⵍⵏ ⵀⵔⴹⴶⵜ ⵢ ⵎⵙⵓⵏ ⵓⵏ ⴹⵏⵜ ⵙ ⵙⵗⵎⵔ ⴹⵜⴾⵙⴹⴰ⵰ ⴶⵓⵜ ⵓⵏ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵤⵏ ⵙ ⵍⵎⵙⵈ ⵙ ⵜⵀⵔⴹⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","ⴹⵙⵏⵓⵔ⵿ⵜⵜⴶⵎ ⵛⵗⵍ ⵍⵗⵏ ⴼⵍ ⵙ ⴾⵓⵏⵓⵍⵏ ⵤⵏ ⵙ ⵓⵔ ⵜⴶⵎⵢⵎ ⵔ ⵓⴰ ⴶⵔⵤⵏ ⵢⴶⴹⵎ⵰ ⴾⵍⵔ ⴶⵓⵜ ⵢⵛⵗⵍ ⵓⴰ ⴶⵢ ⵏⵙ ⴾⵍⵏ ⵏⵍⵎⵙⵈ ⵜⵎⵙⵎ⵰ ⵙ ⵜⵜⵜⴶⵎ ⵜⴶⵎⵢⵎ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹⵜⵙⵈⵙⵍⵎ ⵜⵔⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ⴶⵓⵜⵙⵏ ⵛⵗⵍ ⴶⵏ ⵙ ⵎⵏ ⵔⴹⵏⵏ ⵤⵏ ⵙ ⵎⵍⵢ ⵙ ⵜⵛⵗⵍⵎ ⵓⵔⴶⵗ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ⵜⵙⵏⵎ ⵙ ⵔⵜ ⴾⵍ ⵍⵗⵏ ⵓⴰ ⴶⴰ ⵓⴹⵏ ⴹ ⴶⵔⵓ ⵎⵔⵤⵜⵏⵜ ⵗⵔ ⵎⵍⵢ ⴶⵔ ⵎⵙ ⵓⴹⵏ ⵓⵏ ⴾⵍⵢ ⵓⵍⴰ ⵍⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ⴾⵓⵏⵢ ⴹⵗ ⵎⵙⵓⵙ ⵏⴾⵍⵏ ⴶⵓⵜ ⵆⴹⵏ ⴹⴰ ⵢⴾⵍⵏⵓⵏ⵰ ⵢⵓⵜⵏ ⵛⵂⵔⵛⴰ ⴹ ⵜⵙⵏⵎ ⵙ ⵎⵍⵢ ⵂⵏ ⵌⵏⵓⵏ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵎⵛⴾⵓⵏ ⴾⵓⵏⵢ ⴹⵔⵙⵏ⵰ ⵎⵍⵢ ⵎⵔⵏ ⵓⵔ ⴼⵍⵙ ⵜⵍⴰ ⴶⵢ ⵏ⵿ⵜⵎⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ⵈⵙⵍ ⵀⵤⵏ ⵗⵔ ⵎⵔⴹⴰ ⴶⵎⵢⵜ ⴹⵗ ⵎⵍⵢ ⴹ ⵙⵙⵂⵜ ⵜⵔ⵿ⵜⵢⵜⵏⵓⵏ ⴹⵍⵎⵙⵈ ⵙ ⵜⵔⵏⵏⵜ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ⵜⴼⵜ ⵜⵤⵍⵢ ⵏⵎⴶⵔ ⵜⵏ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵜⵤⵎⵔⵎ ⵢ ⵜⵎⵔⴾⵙ ⵏⵀⵍⵙ ");
INSERT INTO ttqt_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ⴹ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⵏⴶⴰ ⵓⵔⴶⵗ ⵢⵜⴹⵏ ⴹⵔ ⵜⵜⵏⴶⴰ ⵎⵙⵏⵏ ⵜⵗⵙⴰ ⴹⵤⵏⵢ ⴾⵍⵔ ⵜⵗⵎⵔⵏ ⴹⵍⵈⴾⵎⵏ ⴹⵎⵤⵔⵏ ⵍⵏⵏ ⵜⵔⵏⴰ ⴹⴼⵔⴶⵜ ⵜⵏⵎⵙⵏ ⵜⵗⵎⵔⵏ ⵛⵏ ⵈⴾⵎⵏⵏ ⴹⵗ ⵛⵢⵢ ⴹⴾⵍ ⵜⵏ⵿ⴾⵍ ⵓⵏ ⵂⵏⵏ ⵌⵏⵓⵏ ⵜⵓⵢⵏ⵿ⴹⵓ ⵜⴾⵎⴰ ⴹⵔ ⵏⵎⴶⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ⵓⵏ ⴹⵗ ⴼⵍⵙ ⵜⴼⵜ ⵜⵤⵍⵢ ⵏⵎⴶⵔ ⵜⵏ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵜⴼⵔⴶⵎ ⵤⵎⵔⵜ ⵢⵔⴾ ⵤⵍ ⵜⵆⵎⵎ ⴹⴰ ⵓⵔ ⵜⵆⵍⵎ ⴹⴼⵔⵓⵏ ⴹⵗ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⵜⴶⵎ ⴹⴼⵔ ⵙ ⴹⵜⵙⴼⵍⵎ ⴹⵏⴶ ⵔⵜⵏ ⵓⵏ ⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ⵈⵙⵍ ⵤⵤⵓⵜⵜ ⴹⵗ ⵤⴶⵤⵏⵓⵏ ⵍⵎⵗⵏⴰ ⵏⵓⵏ ⵙ ⵜⵆⵍⵜ ⵜⴹⵜ ⵙⵜⵀ ⵓⵙ ⵜⵜⵀⵎ⵰ ⵜⵆⵍ ⵜⵆⵜ ⵙⵍⵙⵓ ⵏⵎⴶⵔ ⵓⴰ ⵜⵤⵍⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ⵙⵎⵜⴶⵜ ⵢ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴹⵔ ⴹⵙⴰ ⵍⵏ⵿ⵌⵍ ⵏⵍⵈⵔ ⵓⴰ ⵏⵤⴶⵤⵏ ⵆⵍ ⵍⵏ⵿ⵌⵍⵏ ⵤⵏ ⵗⵜⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ⴹⵏⴶ ⴹⵢ ⴾⵍ ⵆⵍⵜ ⵤⴶⵤⵏ ⵗⵔⵏⵓⵏ⵰ ⵏ⵿ⵜⴰ ⴾⵓⵏ⵿ⵤⴾⴼⵏ ⴼⵔⴶⵜ ⵏⴹ ⵜⵏ⵿ⵗⵎ ⵀⵍⴶⵍⴶ ⴾⵍ ⵓⴰ ⵤⵏ⵿ⵜⵙ ⵀⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ⵙⵓⵔⵜ ⵜⴾⵀⵜ ⵜⵏ ⵍⵗⵍⵙ ⵜⵤⵍⴶⵎ ⵜⴾⵀⴰ ⵜⵏ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵜⵎⵙⵏ ⵓⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ⵜⵜⵔⵜ ⴼⵓ ⴹⴰ ⵙ ⵜⵍⵍ⵿ⵜ ⵏⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⴹ ⵜⵜⴶⵎ ⵤⵏⴼⵏ ⴾⵍ ⵏ⵿ⵜⵓⵜⵔⵓⵏ ⴹⵎⵏ⵿ⵙⵢⵏ ⵏⵎⵛⵏⴰ⵰ ⴶⵍⵢⵜ ⴹⵗ ⵓⵏ ⵜⵜⵜⴶⵎ ⵙ ⵤⵎⵔⵜ ⴹ ⵜⵜⴶⵎ ⴹⵗ ⵛⵓⵜⵔⵓⵏ ⵢ ⵎⵤⴶⵤⵏ ⴹⵢ ⵏⵎⵤⴹⴶⵏ ⴾⵜⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ⴹⵜⵏⵜⵜⴶⵎ ⵏⴾ ⴹⴰ ⴼⵍ ⴹ ⴶⵔⵓⵗ ⵎⵙⵏⵜ ⵏⵓⵍ ⵛⵓⵍⵗ ⵙⴾⵙ ⵏⵛⴾ ⴶⵗ ⵙⵍⵏ ⵏⵙⵔ ⵏⵍⵏ⵿ⵌⵍ ⵙ ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ⵍⵏ⵿ⵌⵍⵏ ⴹⵗ ⵙ ⵎⵙⵗ ⵍⵎⵓⴾⵍⵏⵜ ⴹⵗ ⴹⵏⵜ ⵎⵔⵏ ⴹⵍⵍⵏⵜ ⴼⵍ ⵂⵗ ⵗⵏⵏ⵰ ⵜⵜⵔⵜⵏ ⴼⵍ ⴹ ⵜⵎⵍⴰ ⵢⵢⵜⴹⵏ ⵙⴾⵙ ⵏⵛⴾ ⵙⵎⴾ ⵓⵙ ⵂⵔ ⵙⵔⵙ ⵛⵓⵍⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ⵎⴹⵔⵢⵏⵏⴰ ⵜⵛⴾ ⵓⵏ ⵎⵔⵏⵏ ⵎⵙⵏ ⵎⵛⵗⵍ ⵗⴹⵍⵏ ⵏⵎⵍⵢ ⴹⵓⵏⴶⵓ ⴾⵓⵏⵢ ⴹⴰ ⵙⵍⵏⵏ ⴾⵍ ⴼⵍ ⴹ ⵜⵙⵏⵎ ⵍⵈⵍⵜ ⵜⴰ ⵂⵗ ⴹⵓⴰ ⵜⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ⴶⵎⵢⵗⵏ ⵙⴾⵢ ⵓⴰ ⴹⵓⵏ⵿ⵜⵏ⵿ⵤⴶⴰ ⴼⵍ ⴹⵓⵏⴶⵓ ⵙⵍⵏⵏⴰ ⵍⵎⵓⵏ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ⵏ⵿ⵙⵢⴰ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹ ⴾⴼⵓ ⵎⴹⵔⵢⵏⵏⴰ ⴾⵍ ⵍⵈⵔ ⴹⵜⵔⴰ ⴹⵗ ⵜⴼⵏ ⵤⴶⵤⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ⵢⴰ ⵎⵛⵏⴰ ⵜⴶⵗ ⵔⵈⵎⵜⵏⴾ ⵢⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵔⵏⵏ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴶⵏⵙ ⵜⵔⴰ ⵓⵔ ⵏⵜⵎⵜⵢ⵰");
INSERT INTO ttqt_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⴹⵜⵎⵜⵢ ⵎⵙⵏⵏ ⴾⵍⵏ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ⵏⵂⵍⵏ ⵢⵜⴹⵏ ⴾⵍ ⵏⵗⵔⵎ ⵏ⵿ⴼⵍⵀ ⵓⵏ ⵎⵙⵏⵏ ⵔⵜ ⴹⵗ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ ⵙ ⵜⵔ⵿ⵜⵢⵜⵏⵙⵏ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ ⴹⵎⵤⵔⵏ ⵏⵍⴾⵏⵙⵜ ⴹⵎⴹⵂⵍⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ⴶⵎⵢⴰ ⴹⵗ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴼⵍⵓⵏ ⴹⵤⵤⵀⵏ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ⵢ ⴾⵓⵏ⵿ⴹⴾⵜⵗ ⴹ ⴶⴹⵢⵗ ⵢⵎⵍⵏⵏ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ⵛⵓⵜⵔⵓⵏ ⴾⵍ ⵛⵏ ⴹⵓⵏ⵿ⵜⴶⴰ ⴼⵓⴹⴰ ⵜⴼⵍⵓⵙ⵿ⵜ ⴹⵗⵓⵏ ⵜⵏⵜⴶⴰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⴹⵂⵍ⵿ⵜ ⵜⴰ ⴹⵜⵜⴶⵎ ⴹⵗ ⵤⵓⵤⵓⵤ ⵏⵍⵏ⵿ⵌⵍ ⴹⵀⵤⵏ ⵗⵔ ⵤⵍ ⵓⴰ ⵤⵔⵏ ⵂⵔ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ⴼⴹⴰ ⴾⵙⵗ ⵛⴾ ⵙ ⵛⵗⵍ ⵍⵗⵏ ⵓⴰ ⴹⵗⵓⵏ ⵙⵏ⵿ⵜⴰ ⵎⵛⵏⴰ ⴹⵢ ⵓⵔ ⵜⵤⵤⵔⵤ ⴾⵜ ⵓⵔ ⵜⵙⵏ⵿ⴹⴰ ⵤⵍ ⵓⴰ ⴹⵗ ⴹⵤⵤⵀⵜ ⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ⵓⵔⴶⵗ ⵀⵏⵏ ⴼⵔⵢ ⵓⵍⵏ ⵢⴹⵢ ⴹⵗ ⵜⵍⵗⵏⵓⵏ ⴾⵜⵏⵓⵏ ⴼⵍⵙ ⴾⵏⵆⵓⵏ ⵜⵔⴰ ⴾⵓⵏⵢ ⵓⵏ ⴹⵔⵢ ⴹⵔⵓⵏⵏ ⵔⵈⵎⵜ ⵜⴰ ⴹⴶⴰ ⵎⵛⵏⴰ ⴶⵔ ⵤⴰ ⵎⵔⴹⴰ ⴹ ⵂⵗ ⴾⵙⵓ ⵓⵍⴰ ⴹⵗ ⴹⵗ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴶⵗ ⴼⵍ ⵍⵏ⵿ⵌⵍ ⴹⵙⵜⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","ⵎⵛⵏⴰ ⵙⵏ ⵙ ⵜⵔⴰ ⵜⴰ ⴹⵓⵏⴶⵗ ⴾⵜⵏⵓⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵏⵜ ⴹⵜⴼⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ⵎⵔⵏ ⵓⴰ ⴶⵎⵢⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏ ⴹⵗⵓⵏ ⵜⵜⵜⵢ ⵜⵔⴰ ⵜⴰ ⴾⵓⵏ⵿ⵜⵂⵜ ⴹⵗ ⵎⵙⵏⵜ ⵜⵏ ⵜⴹⵜ ⴹⴶⵔⵢ ⵏⴹ ⵜⵍⴰ ⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ⵙ ⴶⴰ ⴹⵢ ⴹ ⵜⴼⵔⴶⵎ ⵙⵏⴼⵔⵏ ⵏⵓⴰ ⴾⵏⵏ ⵍⵗ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵤⴹⴶⵏⵏ ⵓⵔ ⵓⵔ ⵍⵂⵏ ⵓⵍⵢⵏ ⵤⵍ ⵓⴰ ⴹⵤⵆⵍ ⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ⵜⵙⴶⵜⵎ ⵎⵤⵍⵏ ⵓⵏ ⵗⴹⵏⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵗⵔ ⴹⴼⵍⵏ ⴼⵍ ⴹ ⵜⵓⵙⵗⵎⵔ ⵎⵛⵏⴰ ⵜⵎⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵎⴹⵔⵢⵏⵏ ⵙ ⵔⵜ ⵓⴰ ⴹⴶⵔⵓⵏ ⴹⴰ ⵓⵢⴹⵓ ⴼⴹⴰ ⵙ ⵙⵍⵏ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵢⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ⵜⵤⵔ ⵓⵢⴹⵓ ⵓⵏ ⵙ ⵙⵏⵏ ⵙⵌⵜⵏ ⴾⵍ ⵓⵏ ⵜⴶⵤⵏⵏ ⵎⵏⴾⵍ ⴹⵢⵜⴹⵏ ⴾⵍ ⵙⴰ ⵂⴹⵏ ⵙ ⴹⵍⵍ ⵏⵍⵎⵙⵈ ⴼⵍ ⵂⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ⵎⵔⵏ ⵓⵔⴶⵗ ⴹⵢ ⵗⵙ ⴾⵍⵔ ⴶⵤⵏ ⴾⵙⵓ ⵓⵢⴹⵓ ⵙ ⵜⵛⵎ ⵏⵎⴹⵔⵢⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵜⵜⵢⵜ ⵏ⵿ⵜⴼⵍⵙ⵿ⵜ ⵜⴰ ⴶⵏ ⵢⵎⵍⵢ ⴹⵗⵙⵏ ⵜⵜⵜⵢ ⵜⵂⵍⵜ ⵏⵎⵍ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⵓⵔ ⵜⵏ⵿ⵜⵂⴰ ⵜⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ⵜⴹⵜ ⵎⵙ ⵙ ⵓⵢⴹ ⴹⵗⵙⵏ ⵎⵏ⵿ⵌⵗ ⴹⵜⵔⴰ ⵏⵎⵤⵔⵢ ⴼⵍ ⵜⴶⵏ ⵙⵍⵏ ⵏⵍⵎⵙⵈ⵰ ⵎⵛⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⴶⵏ⵿ⵜⵏ ⵙⵏⵢⵜ ⵜⵍⵗⵜ ");
INSERT INTO ttqt_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ⵎⵔⵏ ⵜⵔⴰ ⴼⵍ ⵜⴶⵏ ⴹⵢ ⴹ ⵙⵏⵏ ⵙ ⴹⵍⵍ ⵏ⵿ⵜⵀⵍⵏ⵿ⵜ ⴼⵍ ⵍⵏ⵿ⵌⵍ ⴼⵍ ⵂⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ⵎⵛⵏ ⵢⵜⴹⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⵓⵔⴶⵗ ⵓⵍ ⵢⵏ⵿ⴹⴰ ⵙ ⵜⴶⵏ ⵙⵍⵏ ⵏⵍⵎⵙⵈ ⴾⵍⵔ ⵜⵏ⵿ⴼⵏⵙⵏ ⵗⵙ ⴶⵎⵢⵏ ⴶⵏ ⴹⴼ ⵏⵙ ⴼⵍⵢ ⵛⵜⵏ ⵙⴹⵢ ⵔⴾⵏⵢ ⵓⴰ ⵏⵢⴰ ⴹⵗ ⴾⵙⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_18ⴰ","080_1_18ⴰ","PHP","1","18ⴰ","18ⴰ","ⵓⵔ ⵎⵙ ⴹⵢ ⵓⵍⴰ⵰ ⵍⵎⵈⵙⴹ ⵙ ⴶⵔ ⵤⴰ ⵜⴶⵏ ⴹⵢ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵓⵍⴰ ⴹⵗ ⵙⵔⴾ ⵏⵢⵜ ⵙⵍⵏ ⵏⵍⵎⵙⵈ ⵜⴶⵏ ⵎⵔⵏ ⵙⴼⵍⵓⵙⵢ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_18ⵀ","080_1_18ⵀ","PHP","1","18ⵀ","18ⵀ","ⴹⴾⵏⵓ ⴹⵗ ⵙⴼⵍⵓⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ⴼⵍⵙ ⵙⵏⵗ ⵙ ⴹⵢ ⴾⵜⵏⵜ ⴹⵓⵢ ⴹ ⴶⵔⵓⵗ ⴼⵙⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵓⵜⵔⵓⵏⵓⵏ ⴹⵜⵍⵍ⵿ⵜ ⵏⵏ⵿ⴼⵙ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ⵎⵔⵏ ⴾⵏⵗ ⵙⴹⵔⵏ ⵓⵍⵏ ⴶ ⴹⵗ ⵜⵎⴰ ⵏⵙ ⵓⵔ ⴹⵤⵜⵀⵤ ⵜⴾⵔⴾⵜ ⴹⵗ ⵔⵜ ⵓⵍⵢⵏ⵰ ⴾⵍⵔ ⴶⵔ ⵤⴰ ⴹⵜ ⵓⴰ ⵓⵍⴰ ⵎⵔⴹⴰ ⴼⵓⴹⴰ ⵎⵙⵗ ⵎⵆⵌⵢ ⴼⵍ ⴹ ⵜⵓⵙⵗⵎⵔ ⵍⵎⵙⵈ ⴶⵔ ⵤⴰ ⵙ ⵜⵎⴹⵔ⵿ⵜⵏ ⵓⵍⴰ ⵙ ⵜⵎⵜⵏ⵿ⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ⴼⵍⵙ ⵏⴾ ⵍⵎⵙⵈ ⵎⵙⵏ ⵜⵎⴹⵔ⵿ⵜⵏ ⵎⵔⵏ ⵜⵎⵜⵏ⵿ⵜ ⵜⵏ⵿ⴼⵏⵏ ⵜⵎⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ⵎⵛⵏ ⵢⴰ ⵙ ⵎⵙ ⵙ ⵛⵗⵍ ⵏⵍⵎⵙⵈ ⵜⵂⵙ ⵜⵏ⵿ⴼⴰ ⴹ ⴶⵍⵗ ⴹⵔⴰ ⵓⴹⵢ ⵓⵔ ⵙⵏⴰ ⵓⴰ ⵤⴰ ⵙⵏⴼⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ⵜⵔⴾⵀⴰ ⴼⵍ ⵛⵏ ⴶⵏⵜⵏ⵰ ⵙⵏⵂⵍⴰ ⵜⵔⴰ ⵏⴶⵎⴹ ⵏⴹⵏⵜ ⵎⵍⴰ ⵗⵔ ⵍⵎⵙⵈ ⵔⵜ ⵙⵏ⵿ⵜⴰ ⴹⴼⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ⵎⵛⵏ ⵢⴰ ⴼⵍ ⴹⵍⵍⵏⵓⵏ ⴶⵔ ⵜⵏ⵿ⴼⴰ ⵜⴰ ⵜⵂⵜ ⴹ ⵂⵗ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ⵔⵜ ⵓⴹⵢ ⴾⵙⴰ ⴹⵗⵙ ⵛⴾ⵰ ⵙⵏⵗ ⵙ ⴹ ⴶⵍⵗ ⵍ ⵗⵔⵓⵏ ⴼⵍ ⴹⵓⵏⵍⵍⴰ ⴾⵜⵏⵓⵏ ⵙⴹ ⵜⵢ ⵤⴶⵤⵏⵓⵏ ⴾⵏⵓⵏ ⴹⵢ ⵙⴼⵍⵓⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ⴹⵢ ⵤⵛⵜⵏ ⵙⵗⵎⵔ ⵓⴰ ⵜⴶⵎ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵙ ⵜⵔⵢⵜⵏ ⵙⵙⵀⵀ ⵏ⵿ⵜⵓⵗⵍⵢ ⵜⴰ ⴾⵓⵏⵏ⵿ⵤⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ⵜⵗⵔⴰ ⵜⴶⵜ ⴹⴰ ⴶⵓⵜ ⵍⵈⵍ ⵓⵙ ⵎⴾⵏ ⴹ ⵜⴶⵏ ⵢⵜⴹⵏ ⵤⴶⵤⵏⵏ ⵙⵍⵏ⵿ⵌⵍ ⵏⵍⵎⵙⵈ⵰ ⵙ ⴶⴰ ⴹⵢ ⴶⵔ ⵤⴰ ⵙⵆⵓⵏⵏ ⵓⵍⴰ ⴹⵗ ⵎⵙ ⵙ ⵙⵍⵏⵓⵏ ⵗⵙ ⴶⵔⵓⴰ ⴹ ⵙⵏⵗ ⵙ ⵜⴶⵍⵢⵎ ⴹⵗ ⴶⵢ ⵏⵗⴼ ⵢⵏ⵿ⴹⴰ ⵜⵏⵎⵏⴾⵎ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴹⵗ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⵜⴶⵎ ⴼⵍ ⵤⴶⵤⵏ ⵙⵂⴹⵏ ⴼⵍ ⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ⴹⵗⵓⵏ ⵓⵔ ⴶⵏ ⵢⵜⴹⵏ ⵓⵏ ⴾⵓⵏⵤⵏ⵿ⴶⵜⵏⵏ ⵜⵙⴰ ⵙⵔⵜ ⵓⵍⵢⵏ⵰ ⵙⵔⵙⵏ ⴹⵓⵢ ⴹⵢ ⴾⵙ ⵏⵛⴾ ⴹⵗ ⵂⵍⴾⵏⵙⵏ ⴾⵓⵏⵢ ⵓⵢⴹⵓ ⵙⵔⵓⵏ ⴾⵙ ⵏⵛⴾ ⴹⵗ ⴶⵤ ⵓⴰ ⵜⴶⵎ ⵜⵔⵢⵜ ⵜⵏ ⴼⵙⵏ⵰ ⵎⵔⵏ ⵎⵛⵏⴰ ⵤⴶⵏ ⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ⵎⵛⵏⴰ ⵓⵔⴶⵗ ⵔⵈⵎⵜ ⵏⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ ⵗⵙ ⴾⵓⵏⴾⴼⴰ ⴾⵍⵔ ⴾⴼⵓⵏ ⵂⵔⴾⴹ ⵜⵏ ⵍⵗⵤⵀ ⴼⵍ ⴹⵍⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ⵎⵔⴹⴰ ⵜⴶⵎ ⴼⵍⵙ ⵜⵀⵍⵏ⵿ⵜ ⵛⵍⵜ ⵏ⵿ⵜⵙ ⴾⵍⴰ ⴹⵜⵏⵢⵎ ⴶⵆⵜ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹⵗ ⵙ ⵜⵙⵍⵎ ⵙ ⵂⵔⵓⴰ ⴹⴰ ⵜⴶⵆⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ⴹⴹ ⵤⵎⵙ ⵜⵏⵢⵎ ⵜⵙⵙⵎⵜ ⵙ ⵜⵔ⵿ⵜⵢⵜⵏⵓⵏ ⴹⵍⵎⵙⵈ ⵜⵏⵢⵎ ⵍⵎ ⴼⵍ ⵎⵏ ⵓⴰ ⴹⵜⵜⵓⵢ ⵜⵔⵏⵜ ⵜⵏⵢⵎ ⵜⵙⵆ ⵜⴰ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵏⵢⵎ ⴹⵗ ⵜⵂⵏⵏ⵿ⵜ ⴹⵍⵗ ⵏⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ⴹⵗ ⴹⵢ ⵙⴾⵎⵍⵜ ⵜⴼⵍⵓⵙ⵿ⵜⵏ ⵙⴹ ⵜⴶⵎ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵜⵏⵎⵏⴾⵎ ⵜⵏⵎⵔⵎ ⵜⵔ⵿ⵜⵢⵎ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⵜⴶⵎ ⵏⵢⵜ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ⴹ ⵓⵔ ⵜⴶⵎ ⵔⵜ ⵓⵍⵢⵏ ⴹⵗ ⵓⵔ ⵜⴶⵎⵢⵎ ⵔ ⵜⵏ⵿ⴼⴰ ⵏⵎⵏⵓⵏ ⵗⵙ ⵓⵍⴰ ⵜⵤⵤⵓⵔⵎ ⵎⵏⵓⵏ ⴹ ⵓⵔ ⵏ⵿ⴼⴰ ⵓⵏ ⵓⵍⴰ⵰ ⴾⵍⵔ ⴾⵢⵏ ⴹⵗⵓⵏ ⵙⵎⴹⵔⵢⵜ ⵎⵏⵜ ⵢ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⴶⵎ ⴼⵓⴹⴰ ⵢ ⵎⴹⵓⵏⵓⵏ ⴹⴼ ⵏⵙ ⴶⵔⵏ⵿ⴾⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ⴾⵢⵏ ⴹⵗⵓⵏ ⴶⵎⵢⵜ ⵜⵏ⵿ⴼⴰ ⵏⵎⴹⵓⵏⵜ ⵓⵔⴶⵗ ⵜⵏⵜ ⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ⴶⵓⵜ ⵜⴹⵓⵜ ⵜⴶⵜ ⵙⵍⵈⵍ ⵓⵏ ⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ⵏ⵿ⵜⴰ ⴹⵢ ⴹⴰ ⴹⵗ ⴹⵜⵈⵙⵍ ⵜⵛⵜ ⵏⵎⵛⵏⴰ ⴾⵜⵏⵜ⵰ ⵎⵛⵏ ⵜⴶⴹⵜ ⴹⵎⵛⵏⴰ ⵜⴰ ⴶⵔⵓ ⴹⵏ ⵓⵔ ⴶⵎⵢ ⴹⵜⵜⵜⴼ ⴼⵍ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ⴾⵍⵔ ⵢⴰ ⵓⵏ ⴾⵜⵏⵜ ⵙ ⴶⵢ ⵓⴰ ⴶⴰ ⵎⵏⵜ ⴾⵍⵢ ⴶⴹⵓ ⵜⵂⵓⵜ ⵜⴰ ⴹⵜⴶⵏ ⵢⵜⴹⵏ⵰ ⵓⴰ ⵎⵙ ⴾⵍ ⵙⴾⵏⴰ ⵜⵍⵜⵏⵜ ⴹⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ⵙⵎⴹⵔⵢ ⵎⵏⵜ ⵙ ⵀⵔⴹⴶ ⵓⴰ ⴶⴰ ⵂⵔ ⵜⵎⵜⵏ⵿ⵜ⵰ ⵜⵎⵜⵏ⵿ⵜⵏ ⴹⵗ ⵜⴰ ⵜⴶⵜ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ⴹⵢ ⴼⵍ ⵜⴾⴼⴰ ⵎⵛⵏⴰ ⴹⴶ ⵓⴰ ⴶⵔⵏ ⴹⴾⵍ ⴾⴼⵢ ⴹⵗ ⵙⵔⵈⵎⵜⵏⵜ ⵙⵎ ⵙ ⵜⵓⵔⵍⴰ ⵙⵎ ⵓⵔ ⴶⵔ ");
INSERT INTO ttqt_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ⴼⵍ ⴹ ⵙⵌⴹ ⵢ ⵜⵍⵏ ⴾⵍ ⴶⵔ ⵤⴰ ⴹⵗ ⵌⵏⵓⵏ ⵓⵍⴰ ⴼⵍ ⵎⴹⵍ ⵓⵍⴰ ⴹⵗ ⴹⵓ ⵎⴹⵍ ⴼⵍ ⵙⵗⵎⵔ ⵏⵙⵎ ⵏ⵿ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ⴶⵢⵜ ⴹⵗ ⵢ ⵜⵍⵏ ⴾⵍ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵎⵍⵢ⵰ ⵎⵙ ⵓⵏ ⵔⵜ ⵤⵤⵓⵔⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ⴹⵗ ⴹⵢ ⵎⵔⵏⵏ ⵤⵏ⵿ⴹ ⵎⴾ ⵙ ⴼⵓ ⴹⴰ ⵜⵀⵔⴹⴶⵎ ⵢⵎⵍⵢ ⴶⵍⵓⵜ ⵜⵙⵏⴼⵍⵍⵎ ⵙ ⵎⵤⵍⵏⵓⵏ ⴼⵙⵏ ⵓⵏ ⴾⵓⵏⴾⴼⴰ ⵜⴶⵎ ⵓⵏ ⴹⵗ ⵜⴾⵙⴹⵏⵜ⵰ ⵓⵏ ⴹⵗ ⵜⴶⵎ ⵂⵔⵓⴰ ⵗⵔⵓⵏ ⵍ⵰ ⴹⵗ ⴹⵢ ⴹ ⵓⵔ ⵜⵎⵤⵢⵎ ⴹⴶⵢ ⵏⴹⵢ ⵓⵍⵏ ⵎⵔⴹⴰ ⴹ ⵓⵔ ⵍ ⵗⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ⵜⴼⵔⴶⵎ ⴶⵢ ⵏⴹⵢ ⴼⵍⵙ ⵎⵛⵏⴰ ⵎⵏⵜ ⵛⵗⵍⵏ ⴹⵗ ⵓⵍⵏⵓⵏ ⵂⴾⵓⵏ ⵏⵢⵜ ⴹⴼⵔⴶⵜ ⵏⴶⵢ ⵏⵔⵜ ⴾⵍ ⵍⴾⵎ ⵓⵏ ⵢ ⵜⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ⵔⵜ ⴾⵍ ⵓⴰ ⵜⵜⴶⵎ ⴶⵜⵓ ⴹⴰ ⵓⵍⴰ ⴶⵜⵏ⵿ⵜⵏ ⵓⵍⴰ ⵜⵎⵤⵆ ");
INSERT INTO ttqt_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ⴼⵍ ⴹ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵓⵔ ⵓⵔ ⵍⵂⵏ ⵓⵍⵢⵏ ⵤⴹⴶⵏⵏ ⵎⵙⵏ ⵀⵔⵔⵏ ⴾⵎⵍⵏⵏ ⵏⵎⵛⵏⴰ ⵂⵏⵏ ⵎⵙ ⵏⵔⴾ ⵢⵜⴹⵏ ⵈⵔⴾⵏⵏ ⵏⵍⵀⵙ⵰ ⵜⴶⵎ ⴹⵗⵙⵏ ⵎⵍⵓⵍⵓ ⵓⴰ ⴶⴰ ⵏⵔ ⴹⵗ ⵛⵢⵢ ");
INSERT INTO ttqt_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ⵜⵤⵤⵓⵎ ⴹⵗ ⵙⵍⵏ ⵓⵏ ⵂⴾⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ⵙ ⵜⴶⵎ ⴹⵢ ⴹ ⴼⵍⵙⵗ ⵎⵏⵏ ⵤⵍ ⵓⴰ ⴹⵤⵙⵓ ⵍⵎⵙⵈ ⴼⵍⵙ ⴹ ⵙⴾⵏⵓ ⴹⵢ ⵙ ⵛⵗⵍⵏ ⴹⵔⴾⵏⵢ ⵓⴰ ⵏⵢⴰ ⵓⵔ ⵀⵏⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ⵎⵛⵏ ⵎⵌⵙ ⴹⵗⵢ ⵜⵓⴾⵙⵏ ⵎⵏ ⵆⵍⴰ ⵛⵍⵜ ⵏ⵿ⵜⴾⵜⵢ ⵜⵜⵓⵏ⵿ⵗⵍⵜ ⴹⵜⵙⵏ⵿ⴹⵜ ⵛⵗⵍ ⵓⴰ ⴾⵓⵏⵙⵙⴶⵏ ⵤⴶⵤⵏⵓⵏ⵰ ⴾⴹ ⴶⴰ ⴹⵢ ⴹⴰ ⴹ ⴼⵍⵓⵙⴰ ⵏⴾ ⴼⵍⵓⵙⴰ ⴹⵗ ⵏⴾ ⴹⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ⴾⵓⵏⵢ ⴹⴰ ⴼⵍⵓⵙⵜ ⵜⴼⵍⵓⵙⵎ ⴹⵗ ⵏⴾ ⴹⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ⴶⵗ ⵜⵎⴰ ⴹⵗ ⵎⵍⵢ ⵗⵢⵙⴰ ⵏ⵿ⴾⵓⵏⵏⵙⴾⴰ ⵜⵎⵜⵢ⵰ ⵙ ⴾⵓⵏ⵿ⴹⴼⵍ ⴹ ⴶⵔⵓⵗ ⵙⵍⵏⵓⵏ ⵜⵏ⵿ⵙⵓ ⵜⵢⵜⵢⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ⴼⵍⵙ ⵜⵎⵜⵢ ⵗⵙ ⴼⵔⵢⵏ ⵢⵓⵙ ⴼⵔⵢⴰ ⵜⵓⵢⵙ ⵜⵍⵗⵏⵓⵏ ⴹⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ⵎⵔⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵂⴹⵜⵏⵏ ⵜⵏ⵿ⴼⴰ ⵜⵏ ⵎⵏⵙⵏ ⵗⵙ ⴶⵎⵢⵏ ⵓⵔⴶⵗ ⵜⵍⵗⴰ ⵜⵏ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ⵎⵔⵏ ⵜⵙⵏⵎ ⴹⵗ ⵜⵎⵓⵜ ⵜⵙ ⵙⵜⴹⴰ ⵜⵎⵜⵢ ⵜⵛⵜⵏⵜ ⵓⴹⵏ ⵍⵏ ⵍⵎⵗⵏⴰ ⴼⵍⵙ ⵏⵎⵛⵗⵍ ⵓⴰ ⵜⴶⵓ ⵀⵔⵔ ⴹⵀⵏⵜ ⴹⵔⵢ ⵏⵎⴶⴰ ⴹⵓ ⴹⵔⵢ ⴹⵗ ⵛⵗⵍ ⵓⵏ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ⴹⵗ ⴹⵢ ⵏ⵿ⵜⴰ ⵙ ⴶⵗ ⵜⵎⴰ ⵏ⵿ⴹⵓⵏ⵿ⵜⵏⵙⴾⴰ⵰ ⵓⵔ ⵆⵍⵗ ⵔ ⵢⴹ ⵙⵏⵗ ⵓⴰ ⴹⵗⵢ ⵤⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ⵎⵔⵏ ⴾⵙⵗ ⵛⴾ ⵗⵔ ⵎⵍⵢ ⵙ ⴾⵓⵏⵏⵙⴰ ⵏⴾ ⵎⵏⵏ ⴹⵗ ⵍⵓⵆ ⵂⵤⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ⵏⵢⵗ ⵙ ⵍⵗ ⵙ ⴾⵓⵏⵏⵙⵗⵍⴰ ⵀⴼⵔⴹⵜⵙ ⵎⵙⵏ ⵎⴹⵔⵢⵏⵏ ⵎⵙ ⴹⵗ ⵎⴹⵏⵏ ⴹⵗ ⵛⵗⵍ ⴹⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴶⵗ ⵜⵎⵙⵜ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ ⵙⵏ⵿ⵜⴰ ⵙⵔⵢ ⴹⵜⵤⵎⵤⵍⵎ ⵓⵢ ⵜⴹⵂⵍ⵿ⵜ ⵜⵙ ⴹⵔⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ⵙⴹⵔⵏ ⵓⵍⵏ ⵏⵢⵏⵓⵏ ⴾⵜⵏⵓⵏ ⴼⵍⵙ ⵜⴹⴶⵤⵜⵓ ⵜⵙⵍⵢ ⵜⴰ ⵜⴶⵎ ⵜⴼⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ⵓⵍⴰ ⵜⴹⵙ⵿ⵜⵓ ⵜⴼⵔⵢⵜ ⵤⵓⵔⵜ ⵂⵔ ⵤⵎⴰ ⴹ ⵜⵀⴰ⵰ ⵎⵛⵏ ⵂⵏⵜⵜⵙ ⵎⵛⵏⴰ⵰ ⵎⵔⵏ ⵓⵔⴶ ⵏ⵿ⵜⴰ ⵗⵙ ⵙ ⵂⵏⵜⵜ ⴾⵍⵔ ⵏⴾ ⴹⴰ ⵂⵏⵜⵜⵢ ⴶⴹⵍⵢ ⵗⵛⴹ ⵏⵎⵏ ⴶⵔⵏ ⵓⴰ ⴹⴶⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ⴹⵢ ⴼⵍ ⴹⴶⵤⴰ ⴹⵗ ⵜⵏ⵿ⵤⵎⵤⵍⴰ ⵙⵔⵓⵏ ⴼⵍ ⵜⵜⵍⵙⵎ ⵏⵢ ⵜⴼⵍⵓⵙⵎ ⵙⵙⴾⵢⵢ ⴹⵢ ⵗⵛⴹ ⵏⵎⵏ ⵏⴾ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ⴶⵓⵜⵙ ⵍⵆⵀⵍⵜ ⵜⴶⵜ ⵙ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴶⵜ ⴹ ⵎⴹⵔⵢⵏⵓⵏ ⵎⵙ ⴹⵗ ⵤⴶⵤⵏ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⵜⵙⵗⵎⵔⵎ ⵢⵜⴹⵏ ⵓⵏ ⵛⵍⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ⴼⵍⵙ ⵂⵔ ⴶⴰ ⵎⵏⵜ ⴹⵗ ⵍⵗⵔⵔ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⴼⵍ ⵛⵗⵍ ⵢⵍⵎⵙⵈ⵰ ⵓⵏ ⴾⵍ ⴶⵢ ⴼⵍ ⴹⴶⵓ ⵜⵍⵍ⵿ⵜ ⵜⵙ ⵓⵔ ⵜⴼⵔⴶⵎ ⴹⵜⵜⴶⵎ ⴾⵓⵏⵢ ⴼⵍⵙ ⴶⴶ ⴹⵜⴶⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ⵎⵔⵏ ⵎⴹⵔⵢⵏⵏ ⵜⵙⴼⵍⵓⵙⵜⴾⵓⵏ ⵜⵙⵆ ⵜⴰ ⵜⴶⵎ ⴹⵎⵍⵢ ⵗⵢⵙⴰ⵰ ⵓⵔ ⴼⵍⵢ ⵎⵙ ⵤⴾ ⴹⵓⵏⵏⵍⵙⵗ ⴾⵜⵀ ⵏⵔⵜⵏ ⵓⵏ ⵙ ⴾⵍⴰ ⴹⵓⵏ⵿ⵜⵏⵏⴾⵜⵀⴰ ⴼⵍⵙ ⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⵓⵏ ⴹⵗ ⴶⵤⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ⵏ⵿ⴾⴹⵜ ⵢⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵤⵍⵢ ⴹⵏ ⵜⴶⵏ ⵛⵔ ⵙⵙⵂⵏ ⵎⵏ⵿ⴾⴹ ⵜⴼⵏ ⵙ ⵏ⵿ⵜⴰ ⵜⴶⵏ ⴹⵗ ⵜⵎⵜⵢ ⵏⵎⵛⵏⴰ⵰ ⵏ⵿ⴾⴹⵜⵙⵏ ⵓⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ⵏⴾⵏⵢ ⴶⵏ ⵎⵏ⵿ⴾⴹ ⵓⵏ ⵜⴹⵜ ⴼⵍⵙ ⵍⵗⵀⴹⴰ ⵏⴶⴰ ⵎⵛⵏⴰ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵀⵔⴶⵏⵏⴰ⵰ ⵓⵔ ⵏⴶⴰ ⵜⵎⴰ ⵓⵍⵢⵏ ⴹⵗ ⵔⵜ ⴶⴰ ⴶⴹⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ⵎⵔⵏ ⵏⴾ ⵎⵏⵏ ⵍⵗ ⴹⵍⵍⵏ ⵙⴶⵢ ⵏⵜⵎⵏⵏ ⴹⵗ ⵔⵜⵏ ⴶⵏ ⵢⵜⴹⵏ⵰ ⴾⴹ ⵍⵢ ⵓⴹⵏ ⵍⵏ ⴹⵍⵍ ⵙⴶⵢ ⵏⵜⵎⵏⵜ ⴹⵗ ⵔⵜ ⴶⴰ ⴶⴹⵎ ⵓⴹⵏ ⵓⴹⵢ ⴶⵔⵆⵓ ⵜⵍⴰ ⵏⴹⵍⵍ ⵙⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ⴼⵍⵙ ⵏⴾ ⵜⵓⵙⵎⵏ⵿ⴾⴹⵏ ⵤⵍ ⵓⵏ ⵜⵎ ⴹⴼⵔ ⵜⵂⵓⵜⵏ⵰ ⴶⵎⴹⴹⵓ ⴾⵍⵙⵔⵢⵍ ⵜⵍⵢ ⵜⵓⵛⵜ ⵜⵏ ⵀⵏⵢⵎⵏ ⵎⵙⵗ ⵓ ⵗⵀⵔⵢ ⵓⵏ ⵍⵙⵍ ⵙⵏ⵿ⴹⴹⵓ ⵛⵔⴹⵏ ⴾⵜⵏⵙⵏ ⵓⵏ ⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹ ⴼⵔⵙⵢ ⵙ ⴾⵍⴰ ⴹ ⵜⵎⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ⵓⴰ ⴶⵗ ⴹⵗ ⴶⵍⵢⵜ ⴹⵗ ⵜⵔⵢⵜ ⵜⵏ ⵢⵓⵏⵗ ⵤⵗⵤⵀ ⵏⵍⵎⵙⵈⵜⵏ⵰ ⴹⵗ ⵀⵜⵓ ⵜⴰ ⵜⵆⵍⵜ ⵆⴹ ⴹⵗ ⵛⵔⵗⴰ ⵓⴹⵢ ⵓⵔ ⵍⵗ ⵍⵂⵏ ⵓⵍⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ⵔⵜⵏ ⴾⵍ ⵓⵏ ⴹⵢ ⴾⵍⴰ ⴹⵗⵙⵏ ⴶⵗ ⴹⴼ ⵏⵙ ⵎⵙⵏⵢ ⵜⵜⵢⵜ ⵎⵛⵏ ⵎⵔⴹⴰ ⴶ ⴹⵗⵙⵏ ⴹⴼ ⵏⵙ ⴼⵏⵤ ⴹⵎⵙⵏ ⴼⵍ ⴹⵍⵍ ⵏⵓⴰ ⴶⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ⴼⴹⴰ ⵓⵔⴶ ⵔⵜⵏ ⵓⵏ ⴹⵢ ⵗⵙ ⴾⵍⵔ ⵔⵜ ⴾⵍ ⴶ ⴹⵗⵙ ⵙⵓⴹ ⵏⵙ ⴼⵏⵤ ⴹⵎⵙ ⴼⵍ ⴹⵍⵍ ⵏⴹⴾⵍ ⴹⵏⴶ ⵓⵔ ⵍⴰ ⵢⵏ ⵜⴶⴰ ⵎⵙⵏⵜ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵎⵍⵏⵏ⵰ ⴹⵍⵍⵏⵜ ⴼⵍ ⵆⵀⵍⵗ ⴹⴶⵎⴹ ⵔⵜ ⴾⵍ ⵎⵔⵏ ⵔⵜ ⴾⵍ ⴶⵗⵙ ⴹⴼ ⵏⵙ ⵜⵌⵔⴶⵏ⵿ⵜ ⵎⵙ ⴼⵍ ⴹ ⵜⵢⴰ ⴹⵗ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ⵍⵎⵗⵏⴰ ⵜⵙⵆ ⴹⵔⵙ⵰ ⵓⵔⴶⵗ ⵍⴾⵎ ⵢⵛⵔⵗⴰ ⵓⵏ ⵜⵓⵔⵜ ⴹⴾⴼⵏ ⵜⵆⵜ ⴹⵜ ⵎⵛⵏⴰ ⴾⵍⵔ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ⵰ ⵎⵛⵏⴰ ⵂⴾⵏ ⵜⵆⵜ ⵎⵔⵏ ⵂⴾⵜ ⵙⵤⴶⵤⵏ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ⵔⵜ ⵓⴰ ⵔⵗ ⵎⵙⵏⵜ ⵏⵍⵎⵙⵈ ⵍⵎⵗⵏⴰ ⴹ ⵙⵏⴰ ⵜⵔⵏⴰ ⵏ⵿ⵜⵏⴾⵔⵏⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⴹⵜⵔ⵿ⵜⵢⵜ ⴹⵔⵙ ⴹⵗ ⵍⵗⵤⵀ ⵓⴰ ⴶⴰ ⵍⴰ ⴹⵔⵙ ⴹⵗ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵜⴰ ⴶⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ⴹⵢ ⴹⵤⵙⴼⵔⴶⵏ ⴶⵢ ⵏⵜⵎⴰ ⵏ⵿ⴹⴹⵙⵏ⵿ⴾⵔ ⵎⵛⵏⴰ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ⵓⵔ ⵏⵗ ⴶⵔⵓⵗ ⵎⵙⵏⵜ ⵜⴹⵢ ⵏ⵿ⵜⴰ ⵓⵍⴰ ⵜⵛⵜ ⵏⵓⴹⵏ ⴾⵎⵍⵏ ⴾⵍⵔ ⵤⵍ ⴶⵗ ⴹⵗ ⴶⵎⵢ ⵏ⵿ⵜⵏⵜⴶⵔⵓⴰ ⴼⵍⵙ ⴹⵍⵍ ⵏⵓⵏ ⴹⴰ ⴼⵍ ⴹⴹⵀⵤ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙ ⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ⵎⴹⵔⵢⵏⵏ ⵓⵔ ⵏⵗ ⴶⵔⵓⴰ ⵔⵜⵏ ⵓⵏ ⴹⵢ⵰ ⵎⵛⵏ ⵢⴰ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⵜⴶⴰ ⵜⵎⵙⵏ ⵙ ⵓⵔ ⴹⵏ⵿ⵙⴶⴹⴰ ⴹⵗ ⵓⴰ ⴾⵢⵏ ⴾⵍⵔ ⵔⵜ ⵓⴰ ⴼⵔⴶⵗ ⵜⴶⴰ ⴼⵍ ⴹ ⵓⴹⵗ ⵓⴰ ⵍⵏ ⴹⵜⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ⵤⵍ ⴶⵗ ⵙⵙⵔⴾⵏ ⴼⵍ ⴹ ⴶⵔⵓⴰ ⵜⴼⵔ⵿ⵜ ⵜⵎⵙⵜ ⵜⵗⵔⵢ ⵜⴰ ⴹⵏⵗⴶⴰ ⵎⵛⵏⴰ ⵙ ⵌⵏⵓⵏ ⵙ ⵜⵔ⵿ⵜⵢⵜ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ⴹⵗ ⴹⵢ ⵏⴾⵏⵢ ⴾⵜⵏⵏⴰ ⵓⵏ ⵙ ⴾⵏⴰ ⵤⴶⵤⵏⵏⴰ ⵙⵂⵜ ⵎⴾⵏ ⴹ ⵏⴶⵓ ⵍⵈⵍ ⵓⵏ ⵎⵔⵏ ⵓⵍⴰ ⴹ ⵜⴶⵎ ⵍⵈⵍ ⵢⵏ ⵎⵛⵏⴰ ⴹⵓⵏ⵿ⵤⵙⵏⴼⵍⵍⵏ ⵓⵙ ⵂⵔ ⵜⵜⵙⵏⵎ ⴹⵗ ⵀⵜⵓ ⵜⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴹⵓⵏ⵿ⵤⵏⵗ ⵙ ⴹⴹ ⵤⵎⵙ ⵏⵓⴹⵓ ⴹⴶ ⵓⴰ ⵏⵂⴰ ⴹⴰ ⵎⵔⴹⴰ ⴶⵍⵜⵏⴰ ⵏⴹⵓ ⴹⵗ ⵏⵎⴹ ⵓⴰ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ⵢⴰ ⵎⴹⵔⵢⵏⵏ ⵆⵍⵜ ⴾⵜⵏⵓⵏ ⵎⵜⵍⵍⵏⵏ ⵜⵜⵍⵍⵎ ⵢⵜⴹⵏ ⵓⵏ ⵍⴾⵎⵏⵏ ⵢⵍⵎⵙⵍ ⵓⴰ ⴾⵓⵏⴾⴼⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ⵎⵍⵗⵓⵏ ⵙ ⵍⵏ⵿ⵜⵓ ⵢⵜⴹⵏ ⴶⵜⵏⵏ ⵙⴼⵔⵗⵏⵏ ⵙⵍⵈⵍⵏⵙⵏ ⵍⵎⵗⵏⴰ ⵏ⵿ⵜⵎⵜⵏ⵿ⵜ ⵏⵍⵎⵙⵈ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ⵢⵓⵏⵗⵓⵏ ⴶⵢ ⵏⵀⵜⵓ ⵜⴰ ⵎⵔⵏ ⵎⵔⴹⴰ ⵂⵍⵗ ⵙ ⴹⵓⵏ⵿ⵜⵜⵍⵙⵗ ⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ⵜⵍⴾⵎⵜⵏⵙⵏ ⵂⵍⴾ ⴼⵍⵙ ⵛⴹⵙⵏⵙⵏ ⵎⵙⵏⵏ ⵎⵍⵏⵙⵏ ⵙⵏⴼⵙⵏ ⵔⵜ ⵓⵙ ⵂⵔ ⵜⵏⵙⴾⵔⴾⴹ ⵓⵔ ⵜⴾⴰ ⵏⵢⵜⵏⵙⵏ ⵔ ⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ⵏⴾⵏⵢ ⵎⵔⵏ ⴾⵍⵏⵏⵗ ⵌⵏⵓⵏ⵰ ⵎⵔⵏ ⵌⵏⵓⵏⵏ ⴹⴰ ⵙ ⵏⵆⵍ ⵢⵙⵔⵏⴰ ⵜⵏ⵿ⴹⴶⵎⴹ ⵏⵙⴼⵙⵢ ⵜⵎⵙⵏ ⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ⵏ⵿ⵜⴰ ⵤⵙⵎⵜⵢⵏ ⵙ ⵜⵔⵏⴰ ⵜⴰ ⵍⴰ ⴼⵍ ⵔⵜ ⴾⵍ ⵛⵗⵙⵓⵏⵏⴰ ⵔⴾⵎⵏⵏ ⵜⵎⵜⵜⵏⵜ ⵛⵛⵍⵏⵜ ⴹⵜⵏⵜ ⵜⴾⵏⵜ ⵜⵍⴰ ⵏ⵿ⵜⵏⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ⵎⴹⵔⵢⵏⵏ ⴾⵏⵗ ⵜⵔⴰ ⵙⵏⵂⵍⴰ ⵜⵔⴰ ⵏⵏⵢⵏⵓⵏ⵰ ⵜⵎⵙⵎⵢ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⵎⵙⵎ ⴹⵗ ⵙⵀⵀ ⵏⵜⵓⵙⵗⵎⵔⵏ⵰ ⵎⵔⵏⵏ ⵤⵤⵓⵜⵜ ⴹⵗ ⵤⴶⵤⵏ ⵙⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ⴼⴹⵢⴰ ⴹⵙⵏ⵿ⵜⴾ ⵏ⵿ⵙⵢⵆⵎⵜ ⴹ ⵜⵏⵎⵏⴾⵎⵜ ⴼⵍ ⴹⵍⵍ ⵏ⵿ⵜⵙⵆ ⵜⴰ ⵜⴶⵎⵜ ⴹⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ⵎⵔⵏ ⴾⵢ ⴹⴰ ⵎⵙⵏ ⵎⴹⵏⵏ ⵓⵏ ⵜⴹⵜ ⴹⵗ ⵛⵗⵍ ⴶⵎⵢⴰ ⴹⵗⴾ ⴹ ⵜⵍⵍⵗ ⵢ ⵜⴹⴹⵏ ⴹⵢ ⵙ ⵎⴾⵏⵏ ⴶⵔⵙⵏⵜ ⴼⵍⵙ ⵍⵍⵏⵜⵢ ⵙ ⵜⵀⵍⵏ⵿ⵜ ⴼⵍ ⵍⵏ⵿ⵌⵍ ⵏⴾ ⴹⴾⵍⵎⵏ ⴹⵎⴹⵓⵏⵏ ⵓⵏ ⵂⴹⵜⵏⵏ ⴹⵗ ⵛⵗⵍ ⵙⵙⵎⵓⵏⵙⵏ ⴾⵜⵀⵏ ⴹⵗ ⵍⴾⵜⵀ ⵓⴰ ⵂⵏ ⵙⵎⵓⵏ ⵏⵢⵜⴹⵏ ⵓⵏ ⴶⵔⵓⵏⵏ ⵜⵎⴹⵔ⵿ⵜ ⵜⴰ ⵜⵗⵍⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ⴼⵍⵓⵙⵜ ⴼⵓ ⴹⵗ ⵜⵙⵆ ⵜⴰ ⵜⴶⵎ ⴹⵎⵍⵢ⵰ ⵍⵙⴰ ⵜⵏⴰ ⵏⴹⵢ ⴼⵍⵓⵙⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ⵙⵏⵜ ⵓⴹⵏ ⴾⵍ ⴹⵗ ⵍⵗⵏⵓⵏ⵰ ⵎⵍⵢ ⵂⵤ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ⴾⵓⵏⵓⵔⵛⵓⵛ ⵔⵜ ⵓⵍⵢⵏ⵰ ⴾⵍⵔ ⵜⵆⵍ ⵍⵈⵍⵜ ⵜⴰ ⵜⴶⵤⵎ ⴶⵎⵢⵜ ⴹⵗ ⵎⵛⵏⴰ ⵔⵜ ⵓⵙ ⵜⴹⵔⵔⵎ ⴹ ⵜⵜⵜⵔⵎ ⵙⵓⵍ ⵂⴰ ⴶⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","ⵙ ⴶⴰ ⴹⵢ ⵍⵈⵔ ⵓⴰ ⵂⴾⵓ ⵎⵛⵏⴰ ⵎⵙⵏ ⵍⵈⵔ ⵍⵏ ⴹⵏⴶ ⵔⵜ ⴾⵍ ⵓⵙ ⴼⵔⴶ ⵓⴹⵏ ⴶⵔⵏⵜ ⴹ ⴶⵤ ⵓⵍⵏⵓⵏ ⴹⵎⴹⵔⵏⵏⵓⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⴹ ⵜⵔ⵿ⵜⵢⵜ ⵜⴶⵎ ⴹⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ⵈⵙⵍ ⵎⴹⵔⵢⵏⵏ ⵔⵜⵏ ⴹⴰ ⵓⵏ ⵙ ⵂⵔ ⵜⵏ⵿ⵜⴶⵎ ⴼⵓ ⴹⴰ ⴹⵗ ⵜⵢⵜⵓⵏⵓⵏ ⴹⵎⴹⵔⵏⵏⵓⵏ ⵎⵤⵍⵏ ⴾⵍ ⵓⵏ ⴾⵏⵏⵏ ⵍⵗ ⵂⵔⵏ ⴹⵢ ⵜⵏⵎⵍⵏ ⴹⵎⵤⵍⵏ ⵓⵏ ⵎⵙⵏⵏ ⵜⴹⵜ ⵎⵙⵏ ⵤⵀⵏ ⵗⴹⵏ ⵤⴹⴶⵏ ⵙⵔⵏ ⵜⵜⵎⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ⵍⵎⵈⵙⴹ ⵙ ⵜⵎⵤⵍⵜ ⴼⵓ ⵙⵔⵜ ⵓⴰ ⴼⵍⵢ ⵜⵗⵔⵎ ⵜⵆⵀⵍⵎ⵿ⵜⵓ ⵜⵙⵍⵎⵙ ⵜⵏⵢⵎⵢ ⵜⵎⵤⵍⵆⵓ⵰ ⴹⵢ ⴹⵗⵓⵏ ⵙⵏ ⵎⵛⵏⴰ ⴹⵢ ⵏⵎⴶⵢ ⵏⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ⵎⵔⵏ ⵛⵛⵏⵢ ⵓⴰ ⵜⴶⵎ ⵎⵙⵏⵜ ⵜⴰ ⴹⵗⵢ ⵜⴶⵎ ⵓⵢⴹⵓ ⵙⵔⵢ ⵜⴼⵍⵓⵙ⵿ⵜ ⵜⴶⵜ ⴹⵗ ⵜⵙⵆⵏ ⴹⵎⵍⵢ ⴾⴹⵗ ⵙ ⴹⵜ ⵓⴰ ⴹⴰ ⵜⵙⵏⵎ ⴹⵗⵢ ⵎⵛⵏ ⵓⵔ ⵜⴶⵔⵓⵎ ⵜⵔⵢⵜ ⵏⵙⴾⵏⵢ ⵏⴹⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ⵓⵔ ⵏⵗ ⴹⵢ ⴼⵍ ⵙ ⴹⵔⵔⴰ ⵙⵔⵜ ⵢⵏ ⴾⵍⵔ ⵏⴾ ⵍⵎⴹⵗ ⴶⴹⵢ ⵙⵍⵈⵍⵜ ⴾⵍ ⵜⴰ ⵂⵗ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ⵙⵏⴰ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵜⵎⵗⵜⵔ⵿ⵜ ⵙⵏⴰ ⴹⵗ ⵜⵎⴹⵔ⵿ⵜ ⴹⵗ ⵜⵏⴼⵍⵢⵜ⵰ ⵎⵔⵏ ⴹⵗ ⵍⵈⵍⵜⵏ ⴾⵍ ⵛⵏ ⴶⵤⴰ ⵍⵎⴹⴰ ⵜⵓⵏ⵿ⵜ ⵍⵎⴹⴰ ⴹⵗ ⴶⵍⴾ ⵍⵎⴹⴰ ⵜⵏⴼⵍⵢⵜ ⵂⵔⴾⴹ ⵜⵎⵗⵜⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ⵍⵈⵍⵜⵏ ⴾⵍ ⴼⵔⴶⵗⵙⵏⵜ ⵙ ⵜⵍⵍ⵿ⵜ ⵏⵓⴰ ⴹⵂⴾⵏ ⵜⵔⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ⴹⵔ ⴶⴰ ⵓⵏ ⴹⴰ ⵢⴰ ⵜⴶⵎ ⵍⵗⵏ ⵙ ⴹⵜⴹⵂⵍⵎ ⴹⵗ ⵜⵎⵗⵜⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ⵎⵔⵏ ⴾⵓⵏⵢ ⴾⵍⴼⵍⵀ ⵜⵙⵏⵎ ⵓⵍⵏ ⵙ ⵙ ⴶⵎⴹⴰ ⴾⵍ ⵓⵏ ⵎⵙⴹⵏⵢⴰ ⵤⵎⵏ ⵓⵏ ⴹⵗ ⵙⵏ⵿ⵜⵗ ⵎⵍ ⵏⵍⵏ⵿ⵌⵍ ⵓⵔ ⵜⵜⵍⴰ ⵍⴾⵏⵙⵜ ⴹⵜⴹⵂⵍⵜ ⵔ ⵜⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ⴼⵍⵙ ⵓⵍⴰ ⵍⵓⵆ ⵓⴹ ⵂⵗ ⵗⵔⵎ ⵏ⵿ⵜⵙⵍⵏⴾ ⵜⵙⵙⵓⵢⵎⵏ ⵓⵙ ⴹⵔⵔⴰ ⵂⵔ ⵓⵔⴶⵗ ⵜⴾⵍⵜ ⵢⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ⵓⵔⴶⵗ ⴶⵎⵢ ⵜⴶⵗ ⴶⵔⵓⴰ ⴾⵍⵔ ⵔⵤⵏⵓⵏ ⵙ ⴶⵎⵢⵗ ⴹ ⵜⵢⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ⵍⵗ ⵔⵜ ⴾⵍ ⵓⵙ ⴹⵔⵔⴰ ⵏⴼⵍⵢⴰ⵰ ⵓⵔ ⴹⵏⴹⵏⴰ ⵓⵍⴰ ⴹ ⴶⵔⵓⵗ ⵜⵂⴾⵜⵏⵓⵏ ⵜⴰ ⴹⴹⵓⵢ ⵀⴼⵔⴹⵜⵙ ⵜⵎⵙⵜ ⵜⴾⵜⵢ ⵆⵀⵍ ⵎⵛⵏⴰ ⵜⵍⴰ ⵗⵔⵙ ⴹⵓ ⵤⴹⵏ ⴶⵎ⵿ⵜⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ⵎⵔⵏ ⴶⵎⵢⴰ ⴹⵗ ⵎⵍⵏⵏ ⵍⵏ ⵜⵏⵢⴰ ⵓⵔ ⵏⵍⴰ ⴹⴾⴹ ⴾⵓⵏⴾⴼⵏ ⵓⵙ ⵜⴹⵔⵔⵎ ⴾⵍ ⴼⵍ ⴹⵎ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ⴹⴾⵍ ⵢ ⵎⵛⵏⴰ ⵀⵏⵏⴰ ⵂⵔ ⴼⵓ⵰ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ⵜⵂⵍⵎⵏ ⵢⵜⴹⵏ ⴾⵍ ⵓⵏ ⵤⴶⵤⵏⵏ ⵙⵍⵎⵙⵈ ⵗⵢⵙⴰ⵰ ⵂⵍⵏ⵿ⴾⵓⵏⵏ ⵎⴹⵔⵢⵏⵏⴰ ⵏⵍⵎⵙⵈⵜⵏ ⵓⵏ ⵗⵔⵢ ⵍⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ⵎⵤⴶⵤⵏ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵍ ⵓⵏ ⵍⵏⵏ ⴹⴰ ⵂⵍⵏ⵿ⴾⵓⵏⵏ⵰ ⵓⵍⵏ ⵓⵏ ⵎⵛⵗⵍⵏ ⵏⵗⵢⵓⵏ ⵏⵎⵏⴾⵍ ⵆⵢⵙⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ⵜⵔⴰ ⵙⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵓⵏⴾⴼⵏ ⵔⵈⵎⵜ ⴾⵜⵏⵓⵏ⵰");
INSERT INTO ttqt_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ⵓⴰ ⵏⴾ ⵀⵍⵙ ⵎⵙⵏ ⵏⵎⵤⵍ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵙ ⵜⵔⴹⵓⵜ ⵏⵎⵛⵏⴰ ⵏⴾ ⴹⵎⴹⵏⵏ ⴹⵗ ⵤⴶⵤⵏ ⵜⵎⵜⵢ ⵏⵏⵏ ⵂⵍⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ⴾⵍⴾⵍⵙⵢⴰ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵏⵎⵛⵏⴰ ⵏⵎⵏⴾⵏ ⴹⵗ ⵙⵎ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵎⵙⵏⵏ ⵎⴹⵓⵏⵏⴰ ⵏⵍⵗⴹⵍⵏ ⵙⵔⵙ⵰ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵓⵏ ⵎⵛⵏⴰ ⵀⵏⵏⴰ ⵍⵈⵔ ⴹⵔⵈⵎⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ⴼⵓ ⴹⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏⴰ ⵏⵜⴶⴹⵢⵓⵏ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⵏⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ⴼⵍⵙ ⵏⵙⵍⴰ ⵤⴶⵤⵏ ⵓⴰ ⵜⴶⵎ ⵙ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴹⵙⴾⵏⵏⵓⵏ ⵜⵔⴰ ⵢⵢ ⵜⵍⵏ ⵤⴶⵤⵏ ⵙⵔⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ⵤⴶⵤⵏ ⵓⴰ ⴹⵜⵔⴰ ⵜⴰ ⵔⵓⵜⵏ⵿ⴹⵓ ⵜⵎⴰ ⵓⴰ ⵜⴶⵎ ⴹⵗ ⵎⵛⵏⴰ ⵏⵓⴰ ⴹⵓⵏⵙⵏ⵿ⵙⴰ ⴹⵗ ⵍⵌⵏⵜ⵰ ⵜⵎⴰ ⵓⴰ ⵜⴶⵎ⵿ⵜⵓ ⵤⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⵓⴹ ⵍⵏ⵿ⵌⵍ ⵎⵙⵏ ⵙⵍⵏ ⵓⵏ ⵜⴹⵜ ⵏ⵿ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ⵍⵏ⵿ⵌⵍ ⵓⴰ ⴶⵓⵏ ⴹⵙⴰ ⴹ ⴹⴶⴰ ⴼⵍ ⴹⵏⵜ ⴾⵜⵏⵜ⵰ ⵏ⵿ⵜⴰ ⵙⵎⵜⵢⵏ ⵍⵈⵍⵏ ⵏⵢⵜⴹⵏ ⵙⵍⵗ ⵜⵜⵢⵏ ⵎⵤⴶⵤⵏ ⵙⵔⵙ⵰ ⵎⴾ ⵓⴰ ⴹⴰ ⴹⵗⵓⵏ ⴶⵏ ⴾⵓⵏⵢ ⴹⴰ ⴹⵀⵤⵏ ⵗⵔ ⵤⵍ ⵓⴹ ⵜⵙⵍⵎ ⵢ ⵙⵍⵏ ⵏⵔⵈⵎⵜ ⵏⵎⵛⵏⴰ ⵙ ⵜⴹⵜ ⵜⴶⵔⵓⵎ ⴶⵔⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ⵀⴼⵔⵙ ⵎⵍⵍⵏⵏⴰ ⵏⵎⵔⵏⵏⴰ ⵏ⵿ⵜⴰ ⴾⵓⵏⵙⵙⵏⵏ ⵙⵍⵏ ⵓⵏ⵰ ⵎⵙ ⵎⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵗⴹⵍ ⵏⵍⵎⵙⵈ ⵢⵓⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ⵏ⵿ⵜⴰ ⴹⵏⵗⵎⵍⵏ ⵜⵔⴰ ⵜⴰ ⴶⴰ ⵏ⵿ⴼⵙ ⵤⴹⴶⵏ ⵏⵎⵛⵏⴰ ⴹⵗ ⵓⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ⴹⵢ ⴹⴰ ⴼⵍⵙ ⴾⵓⵏⵙⵍⴰ ⵏⵜⵜⵔⵓⵏ ⵙ ⵎⵛⵏⴰ⵰ ⵏⴶⵎⵢ ⴹⵗⵙ ⴾⵓⵏⴾⵏⵓ ⵙⵙⵏ ⵏ⵿ⵜⵔⵏⵜ ⵙⴾⵓⵏⴾⴼⵓ ⵙⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ ⵜⵢⵜⵢ ⴾⵍ ⴹⴶⵔⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ⵛⵓⵜⵔⵓⵏ ⵛⵏ ⵏⵜⴶⵏⵜ ⴼⵍ ⴹ ⵜⵍⵎ ⵍⵈⵍ ⵏⵎⵤⴶⵤⵏ ⵙⵏⵂⵍ⵿ⵜⵓ ⵎⵍⵢ ⵜⴶⵎⴰ ⴹ ⵜⵜⴶⵎ ⵎⵤⵍⵏ ⵍⵗⵏⵏ ⵜⵜⵜⵢ ⴹⵗⵓⵏ ⵎⵙⵏⵜ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_11","081_1_11","COL","1","11","12","ⴾⵏⵓⵏ ⵎⵛⵏⴰ ⵙⵙⵂⵢ ⴹⵗ ⵏⵎⴹ ⴾⵍ ⵙ ⵜⵔⵏⵏⵜ ⴹⵢ ⵎⵆⵔⵜ ⴼⵍ ⴹ ⵜⵍⵎ ⵤⵎⵔⵜ ⵜⴶⵤⴾⵓⵏ ⵜⵤⵢⴹⵔ⵿ⵜ ⵜⴶⴹⵢⵎ ⵙ ⵎⵏ ⴼⵍⵓⵙⵏⵏ ⵢⵀⴰ ⵓⴰ ⴾⵓⵏⵙⴼⵔⴶⵏ ⴶⵔⵓ ⴹⵗ ⵜⴾⵙⵜ ⵜⴰ ⵙⵏ⵿ⵙⴰ ⴹⵗ ⵜⵗⵎⵔⵏⵜ ⴹⵢ ⵜⵎⵙⵜ ⵏⵔ ⵜⵂⵜ ⵌⵏⵓⵏ ⵙⴾⵜ ⵢⵢⵜⴹⵏⵜ ⵓⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵜⵏ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ⵏ⵿ⵜⴰ ⴹⵏⴹⴾⵙⵏ ⴹⵗ ⵍⵈⴾⵎ ⵏⵀⵍⵙ ⴹⵢ ⵎⵙⵏ ⵛⵢⵢ ⴶⵏⵗ ⴹⵗ ⵓⵏ ⵀⵔⵔⵏⵜ ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⴾⵏⴰ ⵜⵔⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ⴹⵍⵍ ⵏⵀⵔⵔⵏⵜ ⴼⵍ ⵏⴶⵔⵓ ⵜⴹⵔⴼⵜ ⵜⵎⵙⵜ ⵜⵙⵔⴼ⵿ⵜ ⵏⵀⴾⴹⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ⵀⵔⵔ ⵓⴰ ⵛⵛⵍⵏ ⵏⵎⵛⵏⴰ ⵎⵙ ⴹⵢ ⵓⵔ ⵏⵜⵓⵂⵏⵢ ⵎⵙ ⴹⵗ ⵎⵤⵔ ⵏ⵿ⵜⵈⵍⴾ ⴾⵍ ");
INSERT INTO ttqt_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ⴼⵍⵙ ⵈⵍⴾ ⵙⵔⵙ ⴹⴶⴰ ⵎⵛⵏⴰ ⵔⵜⵏ ⴾⵍ ⴼⵍ ⵎⴹⵍ ⴹⵌⵏⵓⵏ ⵓⵏ ⵜⵓⵂⵏⵢⵏⵏ ⴹ ⵓⵏ ⵓⵔ ⵏⵜⵓⵂⵏⵢ ⵛⵗⵔⴹ ⵛⵏ ⵜⵏ⵿ⴾⵍⵏⵏ ⴶⵔ ⵆⵍⵏⵜ ⵜⵜⵀⵍⴰ ⵓⵍⴰ ⵜⵗⵎⵔ ⵓⵍⴰ ⵍⵈⴾⵎ ⵓⵍⴰ ⵜⵎⵏⴾⵍⴰ ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵜⵓⵈⵍⴾⵏ⵿ⴹⵓ ⵙⵔⵙ ⴼⵍ ⴹⵍⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ⵗⵢⵙⴰ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵍⵢ ⴹⵜ ⵜⵈⵍⴾ ⴾⵍ ⵎⵔⵏ ⵜⵈⵍⴾ ⴾⵍ ⵜⵏⵎⵜⴼ ⵙ ⵜⵔⵢⵜⵏⵜ ⵙⵏ ⴹⵗⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ⵏ⵿ⵜⴰ ⵎⵏⵜ ⵎⵙ ⵗⴼ ⵏⵍⴾⵏⵙⵜ ⴶⵙ ⵜⵤⵔ⵿ⵜ ⵜⴰ ⴶⴰ ⵗⴼ ⵢ ⵜⵗⵙⴰ⵰ ⵏ⵿ⵜⴰ ⵍⵙⵍ ⵏⵍⴾⵏⵙⵜ ⴼⵍⵙ ⵏ⵿ⵜⴰ ⴹ ⵤⵔⵏ ⵜⵏⴾⵔⴰ ⴹⵗ ⵓⵏ ⵀⴰ ⴼⵍ ⴹ ⵆⵍ ⵍⵢ ⵤⵔ ⵢⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ⵔⵜⵏ ⴾⵍ ⵓⵏ ⵜⵓⵏⵏⵏ ⵙⵍⵎⵙⵈ ⴹⴰ ⴾⵍ ⵜⴹⵜ ⴹ ⴼⵍⵙ ⵎⵛⵏⴰ ⵎⵏⵜ ⴰ ⵙⴶⵜⴾⵏ ⵙ ⵜⵔⵏⵜ ⵙⵈⵙⵍ ⵏ⵿ⵜⵛⵜⵏⵜ ⴹⵢ ⵜⵏ⵿ⴹⵜ ⴹⵗ ⵀⵔⵔⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ⵎⵔⵏ ⴾⵏⴰ ⵜⵍⵙ ⵎⵏⵜ ⴹⵜⵈⵍⴾ ⴾⵍ ⵛⵏ ⵎⴹⵍ ⴹⵌⵏⵓⵏ ⵙⴹⵍⵍ ⵏⵀⵔⵔⵏⵜ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵙⵏⵜ ⵍⵈⵔ ⵙ ⵜⵏⵗⵍⴰ ⵏⵤⵏⵢ ⵏⵀⵔⵔⵏⵜ ⵗⵔ ⵜⵎⵜⵏ⵿ⵜⵏⵜ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ⴾⵓⵏⵢ ⴹⴰ ⵙ⵿ⵜⵤⵔⵜ ⵜⵏⵎⴶⴶⵎ ⴹⵎⵛⵏⴰ ⵜⵎⵙⵎ ⵎⴶⵤⵔⵏⵜ ⵙⵔⴾ ⵏⵢⵜⵏⵓⵏ ⴹⵔⴾ ⵎⵤⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ⵎⵛⵏ ⵎⵔⴹⴰ ⵙ ⵜⵎⵜⵏ⵿ⵜ ⵏⵀⵔⵔⵏⵜ ⴾⴼⵏ ⵎⵏⵜ ⵎⵛⵏⴰ ⴾⵏⵓⵏ ⴹⵎⵏⵜ ⴼⵍ ⴹⵜⵙ ⵜⵀⴹⴹⵎ ⵜⵎⵙⵎ ⵢⵜⴹⵏ ⵤⴹⴶⵏⵏ ⵓⵔ ⵏⵍⴰ ⵍⵂⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ⴾⴹ ⵎⵙ ⵙ ⵜⴶⵍⵎ ⵜⵜⴼⵎ ⵤⴶⵤⵏⵓⵏ ⵜⵤⵤⵓⵎ ⴹⵗⵙ ⵎⵏⵓⵏ ⵜⵤⴾⵎ ⴹⵗⵙ ⵙⵙⵂⵜ ⵓⵔ ⵜⴾⵙⵎ ⵜⵎⴰ ⵓⴰ ⵜⴶⵎ ⵙ ⵜⵙⵍⵎ ⵢⵍⵏ⵿ⵌⵍ⵰ ⵍⵏ⵿ⵌⵍ ⵓⴰ ⵜⵎⵍⵏ ⵢⵢⵜⴹⵏ ⴾⵍ ⵏⴹⵏⵜ ⵏ⵿ⵜⴰ ⵙ ⵆⵍⴰ ⵏⴾ ⵀⵍⵙ ⵎⴶⵢ ⵏ⵿ⵙⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ⵎⵔⴹⴰ ⵙⴹⵓⵜ ⵢ ⵔⴾⵏⵢ ⵓⴰ ⵏⵢⴰ ⴼⵍⵓⵏ⵰ ⴼⵍⵙ ⵎⴾ ⵓⴰ ⵏ⵿ⵜⴰ ⵙ ⵙⴾⵙⵓⴰ ⵙ ⵜⵗⵙⵏⵏ ⴹⵗ ⴶⵏⴰ ⵓⵏⵏ ⵔⵜ ⵓⴰ ⴹⵏⵀⴰ ⴹⵗ ⵍⵗⵤⵀ ⵓⴰ ⵏⵢ ⵍⵎⵙⵈ ⴼⵍ ⵜⵗⵙⵏⵜ ⴹⵢ ⵜⵎⵙⵜ ⵍⴾⵏⵙⵜ ⵏⵍⴾⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ⵍⴾⵏⵙⵜ ⵜⴰ ⵏ⵿ⵜⴰ ⵙ ⵆⵍⴰ ⵎⵛⵗⵍⵏⵜ ⵙⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵏⵜⵏⵓⵏ ⵜⴰ ⴹⵙⴹⴼ ⵎⵛⵏⴰ⵰ ⵤⵎⵤⵍⴹⵓ ⴼⵍ ⴾⵓⵏⵗⵔⴹⵗ ⵙⵙⵏ ⵏⵓⵍⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ⵙⴹⵓⵏⵙⴼⴶⵗ ⵙⵔ ⵓⴰ ⵗⵀⵔ ⵍⵏ ⵙⵍⵏ⵰ ⵎⵛⵏ ⵎⵔⴹⴰ ⵙⵔ ⵓⴰ ⵜⵓⵙⵏⴼⵍⵍ ⵢ ⵓⵏ ⴹⵙⵍⴾⵎⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ⵏ⵿ⵜⵏⵢ ⵙ ⵔⴰ ⵎⵛⵏⴰ ⵜⵏⵙⵙⵏ ⴹⵗ ⴶⵜ ⵓⴰ ⴹⵔ ⴶⴹⴰ ⴹⴾⵍ ⵏⵙⵔ ⵓⴰ ⵆⵍⵏ ⵛⵎⵜⵓⵏ ⵏⴹⵏⵜ ⴾⵍ⵰ ⵙⵔ ⵓⴰ ⵎⵙ⵿ⵜⵓ ⵙ ⵍⵎⵙⵈ ⵗⵙⵔ ⴹⵗ ⵓⵍⵏⵓⵏ ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵍⴾⵏ ⵙ ⴹ ⵜⵍⵎ ⵜⴹⴶⵔ⵿ⵜ ⴹⵗ ⵍⵈⵔⵎⴰ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ⵍⵎⵙⵈ ⵓⴰ ⵏ⵿ⵜⴰ ⵏⵎⵍ ⵏⴾⵏⵢ⵰ ⵏⵔⴾⵀ ⵛⵎⵤⴶⵏ ⵏⵓⴹⵏ ⴾⵍ ⵏⵙⵙⵗⵔⵢ ⵙ ⵜⵢⵜⵢ ⵜⵏ⵿ⴹⵜ ⴼⵍ ⴹ ⴾⵎⵍ ⴾⵢⵏ ⴹⵗ ⵜⵏⵎⵏⴾⴰ ⴹⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ⴹⵗ ⵜⵔⴰ ⵏⴶⴹ ⵏⵔⵜ ⵓⴰ ⴼⵍ ⵙⵏⵂⵍⵗ ⵛⵗⵍ ⵙ ⵜⵔⵏⴰ ⵜⴰ ⴹⵜⴼⵍⵜ ⵍⵎⵙⵈ ⴹⵗⵢ ⵜⵜⵎⵜⴾⵓⵢⵜ ⵙⵙⵂⵜ ⵜⴶⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ⵔⵗ ⴹ ⵜⵙⵏⵎ ⵓⴰ ⴹⵔ ⵜⴶⴹⴰ ⵜⵀⵍⵏ⵿ⵜ ⵜⴰ ⴼⵍⵓⵏ ⵜⴶⴰ ⴾⵓⵏⵢ ⴹⵢⵜⴹⵏ ⵏⵗⵔⵎ ⵓⵏ ⵍⵓⴹⴾⵢⴰ ⴹⵓⵢⴹ ⵛⵍⵜⵏⵓⵏ ⵙ ⵓⵔ ⴾⵍⴰ ⵏⵢⵏ ⴹⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ⵔⵜ ⵓⴰ ⴶⵆⵓ ⴼⵍ ⵜⵔⴰ ⵏⴹ ⵜⵍⵎ ⴾⵓⵏⵢ ⴹⵔⵙⵏ ⵍⵂⵎⵜ ⵜⵏⵎⵔⵎ ⴶⵔⵓⵏ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ ⴼⵍ ⴹ ⵜⵙⵏⵂⵍⵎ ⴶⵍⵢⵜ ⵜⵏ⵿ⴹⵜ ⵜⴰ ⵂⴾⵓ ⴶⵔⵢ ⴾⵙⵓⵏ ⵜⵙⵏⵎ ⵙⵔ ⵏⵎⵛⵏⴰ ⵓⴰ ⵎⵙ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵗⵙ ⵎⵙⵏ ⵜⵙⵙⵔⵜ ⵏ⵿ⵜⴶⵔⴶⵙ⵿ⵜ ⵜⵎⵙ ⵜⵢⵜⵢ ⴹⵎⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ⵔⵜ ⵓⴰ ⵏⵗⵓⵏ⵿ⵜⵓ ⴼⵍ ⵜⵓⵔⵎⵍ ⵓⴹⵏ ⴾⵓⵏⵙⵈⵔⴾⵏ ⴶⵏⵜ ⵀⵜⵜⵏⵜ ⴹⵗ ⵛⵤⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ⴹⵗ ⴹⵢ ⴾⴹ ⵎⵙ ⵙ ⵓⵔ ⵗⵔⵓⵏ ⵍ ⵙⵤⵜⵏ ⴹⴰ ⵎⵏⵏ ⵍⵏ ⵗⵔⵓⵏ ⵎⵔⵏ ⵙⴹⵓⵜ ⵢ ⵙ ⵙⵍⵗ ⵙ ⵜⵏⵤⵎⵎ ⵜⵤⴾⵎ ⵙⵙⵂⵜ ⴹⵗ ⵤⴶⵤⵏ ⵓⴰ ⵜⴶⵎ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ⴹⵗ ⴹⵢ ⵤⵎⴰ ⵜⵆⵀⵍⵎ ⵙ ⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵎⵙ ⵎⵍⵢ ⵓⴹⵢ ⵓⵢⵜ ⴹⵜⵔⵢⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ⵙⵙⵂⵜⵜ ⴹⵗⵙ ⵎⵏⵓⵏ⵰ ⵆⵍⵜ ⵢⵜⴹⵏ ⴾⵔⵙⵏⵏ ⴹⵗⵙ ⵙⵂⵜⵏⵏ ⴹⵗ ⵤⴶⵤⵏⵙⵏ ⵙⵎⴾ ⵓⵙ ⵜⵜⵓⵙⵙⵗⵔⵎ ⵜⵆⵍⵎ ⴹⵗ ⵢⵜⴹⵏ ⴾⵏⵏⵏ ⴹⴾⵔ ⵏⴶⴹⴰ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ⵏ⵿ⴾⴹⵜ ⵢ ⵢⴹ ⵜⵎⵍ ⵓⴹⵏ ⴾⵓⵏⵙⵈⵔⴾⵏ ⵙⵍⵌⵎⵜⵏ ⵓⵔ ⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⴹⵀⵜⵜⵏ ⵏ⵿ⵜⴾⵔⵙ ⴹ ⵤⵔⵜⵏⵏ ⴹⵗ ⵜⵏⴹⵏ ⵏⵢⵜⴹⵏ ⵤⵔⵜⵏⵜⴹⵓ ⴹⵗ ⴹⵗ ⵜⵗⵔⴹ ⵛⵏ ⵜⵏ⵿ⴾⵍⵏⵏ ⴹⵓⵔⵏⵂⴰ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ⴼⵍⵙ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⴹⵗ ⵜⵗⵙⵏⵜ ⴹⵗ ⵜⵗⵙⵔ ⵜⵛⵜ ⴾⵍ ⵏⵎⵛⵏⴰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ⵎⵔⵏ ⴾⵓⵏⵢ ⵓⵏ ⴹⵗⵙ ⵏⵎⵏⴾⵏⵏ ⵜⴶⵔⵓⵎ ⵔⵜ ⴾⵍ ⵙ ⵜⵏⴹⵓⵜ⵰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⵗⴼ ⵏⵍⵈⴾⵎⵏ ⴾⵍ ⴹⵜⵎⵏⴾⵍⴰ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ⴹⵗ ⵜⵏⵎⵏⴾⴰ ⴹⵗ ⵙ ⵜⵜⵓⵙⵎⵏ⵿ⴾⴹⵎ ⵙⵎⵏ⵿ⴾⴹ ⵓⵔ ⴶⴰ ⴼⵙ ⵏⵓⴹⵏ ⵎⵛⵏ ⵓⴰ ⴹⵓⵏⴶⴰ ⵍⵎⵙⵈ ⵎⵙⵏ ⵙ ⴹⵗⵓⵏ ⴾⵙ ⵜⵛⵜ ⴾⵍ ⵜⵏ ⵏⵙⵀⴾⴹⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ⵙⵍⵎⵗⵏⵓⵏ ⴹⵗ ⵎⵏ ⵜⵏⵀⵍⵎ ⵜⴹⵓⵏ ⴹⵔⵙ ⵎⵔⵏ ⴹⵗ ⵜⵜⵓⵙⵏ⵿ⴾⵔⵎⴹⵓ ⵙⵔⵙ ⵜⴹⵓⵎ ⴹⵔⵙ ⴼⵍⵙ ⵤⴶⵤⵏ ⵜⴶⵎ ⵙ ⵜⵔⵏⴰ ⵏⵎⵛⵏⴰ ⴹⵢ ⵎⵆⵔⵜ ⵜⴹⵜⵙⵏ⵿ⴾⵔⵜ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ⴾⵍⴰ ⵜⵎⵙⵎ ⵢⵜⴹⵏ ⵀⴰ ⴹⵗ ⵓⵍⵏⵓⵏ ⴼⵍ ⴹⵍⵍ ⵏⵀⴾⴹⵏⵓⵏ ⴹⴹⵍⵍ ⵏⵙ ⵓⵔ ⵜⵎⵙⵎ ⵔⵜ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵓⵔ ⵜⵎⵏ⵿ⴾⴹⵎ ⵎⵛⵏ ⵎⵔⴹⴰ ⵎⵛⵏⴰ ⵍⵙⴾⵓⵏ ⴹⵙⴹⵔ ⵜⴹⵓⵎ ⴹⵍⵎⵙⵈ ⵙⵙ ⴹⵓⵏⵙⵔⴼ ⵀⴾⴹⵏⵓⵏ ⴾⵍ ⵙⵔⵈⵎⵜⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ⵎⵙ ⵔⴾ ⵎⵤⵍⵏⵏⴰ ⴹⵓⵏⵓⵏ ⵓⵔⵏⵏ ⵗⴼⵓⵏⵏⴰ ⵔⵤⵎ⵿ⵜⵏ ⴼⵍⵏⴰ ⵙⵜⵓⵜⵢⵜⵢⵏⵙⵏ ⴼⵍ ⵜⴶⵜⵓⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ⴾⵙ ⵎⵛⵏⴰ ⵙⵂⵜ ⵜⴰ ⵜⵂⵜ ⵜⵗⵎⵔⵏ ⵏ⵿ⴾⵍⵙⴼ ⵙⵆⵏⵜ ⵍⵓⵢⵜⵏⵜ ⴹⵜ ⵢⵜⴹⵏ ⵎⵙⵏⵜ ⵌⵀ ⵗⵍⵀⵜⵏⵜ ⵙⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ⴹⵗ ⴹⵢ ⵜⵓⵔⵎⵍ ⵓⴹⵏ ⴾⵓⵏ⵿ⵤⵛⵔⵗⵏ ⴼⵍⵙ ⵓⵔ ⵜⵜⴶⵎ ⵓⴰ ⵔⴰ ⴶⵔ ⴶⴰ ⴹⵗ ⵜⵜⵢ ⵓⵍⴰ ⵜⵙⵢ ⵓⵍⴰ ⵌⵍⵏⵓⵏ ⵓⵏ ⵎⴹⵏ ⴹⵓⵏ ⵍⵗⵀⴹⴰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ⴼⵍⵙ ⵔⵜⵏ ⵓⵏ ⵓⵔ ⵎⵙⵏ ⵔ ⵜⵍⵢ ⵏⵓⵏ ⴹⵤⵢⵏⵏ ⵜⴹⵜⵏⵙⵏ ⵜⵂⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ⴹ ⵓⵔ ⵜⵢⵎ ⵎⵏⵓⵏ ⵢⵓⴹⵏ ⵆⵍ ⵙⵓⵔⴾⵓⵏ ⵍⵂⴶⴰ ⴼⵍ ⵙ ⵙⵔⵙ ⵤⴹⵏ ⵎⵤⵍⵏ ⵏⵤⵂⵔ ⵙⵍⵆⵓ ⵎⵏⵜ ⵙⵔⵙⵏ ⵤⴹ ⵙⵔⵙ ⴹⵗ ⵍⵗⵀⴹⴰ ⵏⵏ⵿ⴶⵍⵙⵏ ⵙⵙⵂⵜ ⴹⴼⵏⵜ ⵓⴰ ⴶⴰ ⵙ ⵜⵏⵏⵢ⵰ ⵤⵤⵓⵔ ⵎⵏⵜ ⵙ ⵎⴹⵔⵏⵏ ⵓⵔ ⵜⵂⴰ ⵜⵏ⵿ⴼⴰ ⴹⴶⵎⴹⵏⵏ ⵜⵢⵜⵢ ⵓⵔ ⵏⵂⴰ ⵜⵔⵢⵜ ⵜⵏ ⵍⵎⵙⵈ ");
INSERT INTO ttqt_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ⵎⵔⵏ ⵀⵙ ⵙⵙⵂⵜ ⵎⵏⵜ ⴹⵗ ⵜⵔ⵿ⵜⵢⵜ ⴹⵍⵎⵙⵈ ⵎⵙⵏ ⵗⴼ ⵏ⵿ⵜⵗⵙⴰ⵰ ⵜⵗⵙⴰ ⵜⴰ ⴾⵍ ⵏ⵿ⵜⴰ ⵜⵜⵜⵢⵜ ⵙⵍⵎⵙⵈ ⵙⵎⴾ ⵓⴰ ⵔⴰ ⵎⵛⵏⴰ ⵙⵏⵎⵏⴾ ⵏ⵿ⵜⵙⵍⴹ ⵓⴰ ⴹⵜⵓⵢⵏ ⵙⵎⵗⵔⵙ ⴹⵤⵔⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ⵤⵎⴰ ⵀⴰ ⴾⵓⵏ⵿ⵜⵏⵎⵏⴾⵎ ⴹⵍⵎⵙⵈ ⵜⵜⵓⵗⵜⵙⵎⴹⵓ ⴹⵗ ⵜⵗⵎⵔⵏ ⵏ⵿ⴾⵍⵙⴼ ⴹⵗ ⴹⵏⵜ ⴹⵗ ⴹⵢ ⵎⴼⵍ ⵜⵍⴾⵎⵎ ⵢ ⵀⵜⵜⵏ ⵏⴹⵏⵜ ⵜⵆⵀⵍⵎ ⵍⵆⵏⵏⵏ ⵎⵙⵏⵏ ");
INSERT INTO ttqt_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","«ⴹ ⵓⵔ ⵜⴹⴾⵍⵗ ⵓ» «ⴹ ⵓⵔ ⵜⵔⵎⵗ ⵓ» «ⴹ ⵓⵔ ⵜⴹⵙⵗ ⵓ»⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","ⵔⵜⵏ ⵓⵏ ⵓⵔⴶ ⵓⵔ ⴶⵏ ⵔ ⵢⵜⵏ⵿ⵜⴶⵎⴹ ⵜⵏ⵿ⴼⴰ ⴹⴼⵔ ⵙ ⵙⵔⵙⵏ ⴶⴰ ⵎⵤⵍ⵰ ⵓⵔ ⵎⵙⵏ ⵔ ⵍⵆⵏⵏⵏ ⴹⵓⵍⵏ ⵏⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ⵜⴹⵜ ⵙ ⴹⵗ ⵏⵢⵏⵙⵏ ⵔⵜⵏ ⵓⵏ ⵗⴹⵏ ⴼⵍⵙ ⴾⴼⵏ ⵙ ⵜⵢⵜⵢ ⴹⵗ ⵎⵤⵍⵏⵙⵏ ⵎⵙⵏⵏ ⵍⵗⵀⴹⴰ ⵙ ⴶⵍⵢⵜ ⵙⵍⵆⵓ ⵏⵎⵏ ⵙⴾⵏⵢ ⵏ⵿ⵜⵗⵙⴰ ⵔⴾⵏⵢ⵰ ⵎⵛⵏ ⵢⴰ ⵎⵙⵓⵙⵏ ⵓⵔ ⵍⵏ ⵎⵙⵏ ⴼⵔⴶⵜ ⵏⴹⴼ ⴹⵗ ⵜⵔⴰ ⵏⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ⴹⴹ ⵤⵎⵙ ⵜⵜⵓⵙⵏ⵿ⴾⵔⵎⴹⵓ ⴾⵓⵏⵢ ⴹⵍⵎⵙⵈ ⴹⵗ ⵜⵎⵜⵏ⵿ⵜ ⵓⴹⵢ ⴶⵎⵢⵜ ⵔⵜⵏ ⵓⵏ ⵌⵏⵓⵏ ⴹⴹ ⵍⴰ ⵍⵎⵙⵈ ⵂⴰ ⵗⵍ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ⵙⴹⴶⵜ ⵏⵢⵜⵏⵓⵏ ⵙⴰ ⵙⵔⵙⵏ ⵓⵔⴶ ⵙⴰ ⵙⵔ ⵓⵏ ⵏⴹⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","ⴼⵍⵙ ⵛⵍⵜ ⵏⵢⵜⴹⵏ ⵀⴰ ⵜⵎⵙⵎ ⵀⵙ ⵜⵜⵎⵤⵍⵎ ⵔⵜⵏ ⵓⵏ ⵜⵜⵎⵤⵍⵎ ⵙ⵿ⵜⵤⵔⵜ ⵎⵔⵏ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ ⵜⵙ⵿ⵜⵔ ⵙⵍⵎⵙⵈ ⵗⵔ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ⵙ ⴹⵜⵓⵙⵏⴼⵍⵍ ⵍⵎⵙⵈ ⵎⵙⵏ ⵜⵎⴹⵔ⵿ⵜⵏⵓⵏ ⴾⵓⵏⵢ ⴹⴰ ⴹⵜⵜⵓⵙⵏⴼⵍⵍⵎ ⴹⵔⵙ ⵜⴶⵔⵓⵎ ⵍⵈⵔⵎⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ⴹⵗ ⴹⵢ ⵏ⵿ⵗⵜ ⴹⵗ ⵎⵏⵓⵏ ⵏⵢⵜⵏ ⴾⵍ ⵛⵏ ⴹⵏⵜ ⵜⵏⵜⵎⵙⵏ ⵤⵏⴰ ⵎⴹⵙ ⵜⵔⴰ ⵏⵎⵏ ⵔⴾ ⴹⵔⵏⵏ ⵜⵔⴰ ⵏⴹⵏⵜ ⵜⵎⵙⵜ ⵎⴹⵔⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","ⵔⵜⵏ ⵓⵏ ⴹⵍⵍⵏⵙⵏ ⴼⵍ ⵜⴶⵤ ⵍⵂⵎ ⵎⵛⵏⴰ ⵏⵢⵜⴹⵏ ⵓⵏ ⴶⵢⵏⵏ ⵙⵙ ⵙⵔⵙ ⵤⴶⵤⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⴾⵍⴰ ⵜⵏ⵿ⵜⵜⵎⵤⵍⵎ ⵂⵔⵓⴰ ⴹ ⵓⵔ ⵜⴼⵔⴶⵎ ⴹⴼ ⴹⵗ ⵎⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ⵎⵔⴹⴰ ⵔⵜⵏ ⵓⵏ ⴾⵍ ⵎⵤⵢⵜ ⴹⵔⵙⵏ ⵜⵏⵎⵙⵏ ⵍⵂⵎ ⵛⵔ ⵤⵏ⵿ⴶⵓ ⵛⵤⵎⵜ ⵔⴾ ⵀⵜⵜⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ⴹ ⵓⵔ ⵜⵜⵏⵎⴶⵎ ⵀⵂⵓ ⴶⵔⵓⵏ ⴼⵍⵙ ⵜⵌⵓⵔⵎ ⵜⴾⵙⵎ ⴹⵗ ⵎⵏⵓⵏ ⵜⵛⵜⵏⵓⵏ ⵜⴰ ⵜⵔⵓⵜ ⴹⵎⵤⵍⵏⵜ ");
INSERT INTO ttqt_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ⵜⵤⵔ ⵜⴶⵎ ⴹⵗⵙⵏ ⵎⵔⴹⴰ ⵢⵜ ⵜⵤⵔⵢⵜ⵰ ⵎⵏⵓⵏ ⵓⵏ ⵏ⵿ⵜⵏⵢ ⵜⵓⵛⵛⵢⵏⵢⵏⵏ ⴼⵓ ⵙ ⵛⵛⵍⵏ ⵏⵎⵈⵍⴾⵏⵙⵏ ⴼⵍ ⴹ ⵜⵍⵎ ⵎⵙⵏⵜ ⵜⵏ⵿ⴹⵜ ⵏⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ⴹⵗ ⵜⵎⵓⵜ ⵜⴰ ⵜⵤⵔⵢⵜ ⴰ ⵓⵔ ⵜⵜⵍⴰ ⵤⵍⵢⵜ ⴶⵔ ⵢⵜⴹⵏ ⴾⵍ ⴶⵔ ⵆⵍⵏ ⴾⵍⵍⵢⵂⴹ ⵓⵍⴰ ⵓⵏ ⵜⵏⵓⵔⵏⵎⵙ ⴶⵔ ⵓⵏ ⵎⵏ⵿ⴾⴹⵏⵏ ⵓⵍⴰ ⵓⵏ ⵓⵔ ⵏⵎⵏ⵿ⴾⴹ ⴶⵔ ⵎⵙⵏ ⵗⵔⵀ ⵓⵍⴰ ⵍⵌⵂⵍⵏ ⴶⵔ ⵎⵙⵏ ⴾⵍⵏ ⵓⵍⴰ ⵍⵍⵏ ⵍⵎⵈⵙⴹ ⵙ ⴾⵜⵏⵙⵏ ⵂⵏ ⵍⵎⵙⵈ ⴹⵢ ⵎⵙⵏ ⵔⵜ ⴾⵍ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ⴾⵓⵏⵢ ⵜⵂⵎ ⵓⵏ ⴹⵙⵏⴼⵔⵏ ⵎⵛⵏⴰ ⵙⵓⵔ⵿ⵜⵏ ⴶⵏⴰ ⵔⵏ⵰ ⴹⵗ ⴹⵢ ⵜⴶⵤⵜⴾⵓⵏ ⵜⵂⵏⵏ⵿ⵜ ⵜⵍⵎ ⵎⵏ ⵎⵍⵍⵏⵏ ⵜⵙⵍⵆⵓⵎ ⵎⵏⵓⵏ ⵜⵍⵗⵎ ⵜⴶⵤⴾⵓⵏ ⵜⵤⵢⴹⵔ⵿ⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ⵏⵎⵓⵢⵜ ⴶⵔⵓⵏ ⴹ ⵜⵜⵏⵎⵙⵔⴼⵎ ⴶⵔⵓⵏ ⵙ ⵏⵎⵛⴾ ⵢⵏ ⴹⵗⵓⵏ ⴹⵎⴹⵏⵜ⵰ ⴹ ⵜⵜⵏⵎⵙⵔⴼⵎ ⴶⵔⵓⵏ ⴾⵓⵏⵢ ⴹⴰ ⵙ ⵜⵎⵓⵜ ⵜⵙ ⴹⵓⵏⵙⵔⴼ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ⵔⵜⵏ ⵓⵏ ⴾⵍ ⴶⵓⵜ ⵜⵔⴰ ⴹⵏⴶⵙⵏ ⵙ ⵜⴶⵎ ⴹⵢ ⴹ ⵜⴾⵏⵎ ⵏⵎⵏⴾ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","ⵍⵈⵔ ⵓⴰ ⴶⴰ ⵍⵎⵙⵈ ⴹⵗ ⵓⵍⵏⵓⵏ ⵈⴾⵎⵜ ⵛⵏⴹⵏⵓⵏ ⴼⵍⵙ ⵍⵈⵔ ⵓⵏ ⴹⴰ ⵙ ⴾⵓⵏ⵿ⴹⵗⵔⴰ ⵎⵛⵏⴰ ⴼⵍ ⴹ ⵜⵆⵍⵎ ⵔⵜ ⵢⵏ⵿ⴹⴰ ⴹⵙ⵿ⵜⵜⴶⴹⵢⵎ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ⵗⵙⵔⵜ ⵓⵍ ⵏⵍⵎⵙⵈ ⴹⵗ ⵓⵍⵏⵓⵏ ⵙⴶⵜ⵰ ⴹ ⵜⵜⵏⵎⵙⵙⵗⵔⵎ ⵜⵜⵏⵎⵙⵏ⵿ⴾⴹⵎ ⴶⵔⵓⵏ ⵙ ⵜⵢⵜⵢ ⵜⵏ⵿ⴹⵜ ⵎⵔⵏ ⴹ ⵜⵜⴶⵎ ⵛⴶⵢⵜⵍⵏ ⵢ ⵎⵛⵏⴰ ⵙ ⵎⵏ ⴶⵍⵢⵏⵏ ⴹⵜⵎⵍⵏ ⴹⵙⴾⵏ ⵓⵏ ⴹⴶⵎⴹⵏⵏ ⴹⵗ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵜⴶⵜⵏ ⴼⵍ ⴹ ⵜⵙⴾⵏⵎ ⴶⴹⵏⵓⵏ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ⵔⵜ ⴾⵍ ⵓⴰ ⵜⴶⵏⵎ ⴹⵓⴰ ⵜⵜⴶⵎ ⵎⵤⵍⵜⵓ ⵙⵙⵎ ⵏⵎⵍⵢ ⵗⵢⵙⴰ ⵙⵔⵙ ⵜⵜⴶⴹⵢⵎ ⵢ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ⵛⴹⴹⵏ ⵍⴾⵎⵜ ⵢ ⵜⵏⴰ ⵏⵎⴹⵏⴾⵎⵜ ⵎⴾ ⵙ ⵂⵔ ⵜⵜⴶⵏⵜ ⵜⴹⴹⵏ ⵛⵏ ⵂⵏⵏ ⵜⵔⵢⵜ ⵏⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","ⵎⴹⵏ ⵔⵓⵜ ⵛⴹⴹⵏⵓⵏ ⵎⵔⵏ ⴾⵓⵏⵓⵔⵜⴶⵤⵏ ⵔⴾ ⵎⵏ ⵙⵔⵙⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ⵀⵔⵔⵏ ⵀⵔⴹⴶⵜ ⵢ ⵎⵔⵓⵏⵓⵏ ⴹⵗ ⵔⵜ ⴾⵍ ⴼⵍⵙ ⴹⵢ ⴹⴰ ⴶⵎ ⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","ⵎⵔⵏ ⴾⵓⵏⵢ ⵎⵔⵓⵏ ⴹ ⵓⵔ ⵜⵜⵂⵔⵛⵎ ⵀⵔⵔⵏⵓⵏ ⴼⵓ ⴼⵍ ⴹ ⵓⵔ ⵗⵛⴹⵏ ⵎⵏⵙⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","ⴾⵍⵏ ⵀⵔⴹⴶⵜ ⵢ ⵎⵙⵓⵏ ⴹⵗ ⵔⵜ ⴾⵍ⵰ ⴹ ⵓⵔ ⵜⵜⴶⵎ ⵔⵜ ⴼⵍ ⵙ ⵜⵜⵓⵓⵍⵎ ⵗⵙ ⵜⵔⵎ ⴶⵢ ⵏⵓⴰ ⴶⵎⵏ ⵢⵜⴹⵏ ⴾⵍⵔ ⴶⵜⵓ ⴶⵔⵓⵏ ⴹⵎⵏⵓⵏ ⵙ ⵜⴾⵙⴹⴰ ⵏⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ⵛⵗⵍ ⵓⴰ ⵜⵜⴶⵎ ⴾⵍ ⵎⵤⵍⵜⵓ ⵙⵓⵍ ⵢⵏ⵿ⴹⴰ⵰ ⴶⵓⵜ ⵙ ⴶⵢ ⵏⵙ ⵎⵙ ⵛⵗⵍ ⵜⴶⵎ ⵢⵎⵍⵢ ⵓⵔⴶⵗ ⵢⵢⵜⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ⴼⵍⵙ ⵜⵙⵏⵎ ⵙ ⵎⵍⵢ ⴾⵓⵏⴾⴼⵓ ⵍⴾ ⵎⵙⵏ ⵜⴾⵙⵜ ⵜⴰ ⵙⵏ⵿ⵙⴰ ⵢⵢⵜⴹⵏⵜ⵰ ⵍⵎⵙⵈ ⵏ⵿ⵜⴰ ⵎⵍⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ⵢ ⴶⵏ ⵔⴾ ⵎⵤⵍ ⴹ ⵜⵔⵤⵎ ⴼⵍⵙ ⵛⵔⵗⴰ ⵏⵎⵛⵏⴰ ⵍⴰ ⵓⵔ ⵜⵜⵂⴰ ⵜⵎⵔⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ⵎⵙⵓⵙ ⵏⴾⵍⵏ ⵜⵎⵤⵍⵜ ⵙⵍⵈⵆ ⴹⵛⵔⵗⴰ ⴹⵗ ⵜⵏⵜⴼ⵿ⵜ ⵜⴰ ⵜⴶⵎ ⵢⴾⵍⵏⵓⵏ ⵜⴾⵜⵎ ⵙ ⴾⵓⵏⵢ ⵎⵏⵓⵏ ⵜⵍⵎ ⵎⵛⴾⵓⵏ ⴹⵗ ⵌⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ⵙⵏⵂⵍⵜ ⵜⵤⴾⵜ ⴹⵗ ⴶⵢ ⵏ⵿ⵜⵓⵜⵔⵓⵏ ⴹⵗⵙⵏⵜ ⵜⵏⴾⴹⵎ ⵜⵜⴶⴹⵢⵎ ⵢ ⵎⵛⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ⴹⵏⵜⵜⴶⵎ ⵛⵓⵜⵔⵓⵏ ⵏⴾⵏⵢ ⴹⴰ ⴼⵍ ⴹⵏⵗⵍⵎ ⵎⵛⵏⴰ ⵜⵔⵢⵜ ⵏⵤⵓⵤⵓⵤ ⵏ⵿ⵙⵍⵏ ⵏⵙⵔⵏⵜ ⵎⵙ ⵍⵎⵙⵈ⵰ ⵙⵔ ⵓⴰ ⵏ⵿ⵜⴰ ⵎⵙⵏ ⴹⵍⵍ ⵏⵜⵓⵜⴼⵏ ⴹⵗ ⴾⵙⵓ ⵎⵔⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ⴹⵏⵆⵏⵜ ⵜⵜⴶⵎ ⴹⵗ ⴼⵍ ⴹ ⴾⵏⴰ ⴼⵔⴶⵜ ⵏⴶⵢ ⵏ⵿ⵙⵍⵏ ⵏⵍⵎⵙⵈ ⵙⵎⴾ ⵓⴰ ⵂⵔⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ⵍⵓⵜ ⵍⵈⵍ ⵍⵗⵏ ⴹⵗ ⵜⵙⵆⵏⵓⵏ ⴹⵢⵜⴹⵏ ⵓⵏ ⵓⵔ ⵏⵂⴰ ⵜⵔⵢⵜ ⵜⵏ ⵍⵎⵙⵈ ⵎⵔⵏ ⴹ ⵓⵔ ⵜⵙⵀⵏⵏⵎ ⵛⵎⵤⵢⵜⵏ ⵛⵏ ⵜⴶⵔⵓⵎ ⵓⵔ ⴹⵗⵙⵏⵜ ⵜⴶⵎ ⵙⵍⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ⵓⵍⵏⵓⵏ ⵂⵔ ⴹ ⵍⵗ ⵎⵙ ⵏ ⵍⵎⵈⵙⴹ ⴼⵍ ⴹ ⵜⴼⵔⴶⵎ ⵎⵙⵏⵜ ⵏⵍⵌⵓⵀ ⴶⵏ ⴹⵗ ⴹⴶⵏⵜ ⵢⴾⵍⴾ ⵏⵓⴹⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ⵎⵔⵏ ⵙⵍⵏ ⴾⵍ ⵓⵏⵓ ⵎⴹⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⴶⵏ ⵙⵎ ⵜⵛⴾ ⵏⵎⵔⵏⵏⴰ ⵎⵙⵏ ⵎⵛⵗⵍ ⵏⵍⵗⴹⵍ ⵏⵎⵍⵍⵏⵏⴰ ⴹⵗ ⵛⵗⵍ ⵏⵎⵍⵢ ⵏ⵿ⵜⴰ ⴹⵓⵏ⵿ⵜⵏ⵿ⵤⵗⵔⴹⵏ ⴶⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ⴹⵢ ⴹⴰ ⴼⵍ ⵙ ⴶⵎⵢⵗⵏ ⵤⵎⵤⵍ ⵓⴰ ⵜⵏⴶ ⵙⵔⵓⵏ ⴼⵍ ⴹⵓⵏⴶⵓ ⵙⵍⵏⵏⴰ ⵍⵎⵓⵏ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","ⴹⵓ ⴹⵔⵙ ⵎⴹⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵏⵍⵗⴹⵍ ⵏⵎⵔⵏⵏⴰ ⴶⵏ ⵙⵎ ⵏⵙⵎ ⵎⵙⵏ ⵢⵏ ⴹⵗⵓⵏ⵰ ⴹⵓⵏⴶⵏ ⵙⵍⵏ ⵏⵔⵜ ⴾⵍ ⵓⴰ ⵜⵓⵎⵤⵍⵏ ⴹⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ⵔⵙ⵿ⵜⵔⵈⵙ ⴹⵔ ⵏⵎⵂⴰ ⴾⵙⵓ ⵙⵙⵍⵎⵏ ⴼⵍⵓⵏ ⵏ⵿ⵜⴰ ⴹⵎⵔⴾⵙ ⵓⵏ ⵛⵏ ⵏⵀⵔⵏⵀⵙ⵰ ⵎⵔⴾⵙ ⵜⵔⵓⵎ ⵙ ⵜⴶⵔⵓⵎ ⵙⵍⵏⵜ ⵎⵔⵏ ⵙ ⴾⵓⵏⵏⵙⴰ ⵜⵆⵀⵍⵎ⵿ⵜⵓ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ⵗⵢⵙⴰ ⵓⵙ ⵜⵓⵏⵓ ⵢⵙ⵿ⵜⵙ ⵙⵙⵍⵎⵏ ⴼⵍⵓⵏ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ⵎⴹⵏ ⵓⵏ ⵏ⵿ⴾⵔⴹ ⵏ⵿ⵜⵏⵢ ⵗⵙ ⵎⵤⴶⵤⵏ ⴹⵗ ⴾⵍⵍⵢⵂⴹ ⵓⵏ ⴹⵔ ⵏⵎⵛⵗⵍⴰ ⵢ ⵜⵗⵎⵔ ⵏⵎⵛⵏⴰ ⵎⵔⵏ ⵍⵎⵏ ⵢ ⴼⵍ ⵎⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ⵀⴼⵔⵙ ⵓⵏ ⵢⵏ ⴹⵗⵓⵏ ⵎⵙⵏ ⴾⵍⵢ ⵏⵍⵎⵙⵈ ⵗⵢⵙⴰ ⵙⵙⵍⵎⵏ ⴼⵍⵓⵏ ⵏ⵿ⵜⴰ ⴹⴰ⵰ ⴼⵓ ⵜⴶⵓⵏ ⵛⵓⵜⵔⵓⵏ ⴶⵎⵢ ⴹⵗ ⵎⵛⵏⴰ ⵙ ⴶⵍⵢⵜ ⴾⵓⵏⵙⵙⵂⵜ ⴹⵗ ⵜⵔⵢⵜⵏⵓⵏ ⵜⵆⵍⵎ ⵢⵜⴹⵏ ⵏ⵿ⴹⵏⵏ ⴹⵗ ⵤⴶⵤⵏ ⴾⵎⵍⵏⵏ ⴹⵗ ⵏⵢⵜⵏⵙⵏ ⵏ⵿ⴹⵏⵏ ⵜⵎⵤⵍⵏⵏ ⵜⵔⴰ ⵏⵎⵛⵏⴰ ⴾⵍ ⵙ ⵜⵎⵓⵜ ⵜⴾⵎⵍⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ⵏⴾ ⵎⵏⵏ ⴶⵢⵗ ⵛⵗⵍ ⵙⵂⵏ ⵓⴰ ⴹⵓⵏⴶⴰ ⴾⵓⵏⵢ ⴹⴾⵍ ⵍⵓⴹⴾⵢⴰ ⴹⴾⵍ ⵢⵔⴼⵍⵙ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ⵍⵆⴰ ⵎⵔⵏⵏⴰ ⵏⵏⵙⵎⴶⵍ ⴹⵎⵙ ⵂⵍⵏ⵿ⴾⵓⵏⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ⵙⵙⵍⵎⵜⵏⵗⵏ ⴼⵍ ⵎⴹⵓⵏⵏⴰ ⴹⵗ ⵤⴶⵤⵏ ⵓⵏ ⵂⵏⵏ ⵗⵔⵎ ⵏⵍⵓⴹⴾⵢⴰ ⴹⵏⵎⴼⴰ ⴹⵍⴾⵏⵙⵜ ⵜⴰ ⵜⵜⵎⵏⵢⵜ ⴹⵗ ⵂⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ⴹⴼⵔ ⵙ ⵜⵗⵔⴹⵎ ⵜⵗⵔⵢ ⵏⵛⵔⵓⵜ ⵜⴰ ⴶⵜ ⵜⵎⵓⵜ ⴼⵍ ⵤⴰ ⵜⵜⵓⵗⵔⵓ ⵢⵍⴾⵏⵙⵜ ⴹⵗ ⵍⵓⴹⴾⵢⴰ ⵜⵗⵔⵎ ⴾⵓⵏⵢ ⴹⴰ ⵛⵔⵓⵜ ⵜⵏⵙⵏ ⵜⴰ ⴹⵓⵏ⵿ⴹⵤⵙⴶⵍⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ⵜⵏⵎ ⵢⵔⵈⴼⵙ ⴾⵙ ⵛⴾ ⴹⵗ ⵗⵔⴹ ⵏⵛⵗⵍ ⵓⴰ ⵜⴶⵤⴰ ⵢⵎⵍⵢ⵰ ");
INSERT INTO ttqt_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ⵔⵜ ⵓⴰ ⴼⵙ ⵓⵏⵓ ⵙ ⵜⴾⵜⵀⴰ ⵙⵍⵎⵏ ⴹⵏⴶⵎⴹⵏⵏ ⴹⵗ ⵀⵍⵙ⵰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵓⵏ ⴹⵏⵓⵔ⵿ⵜⵜⵓⵎ ⵜⵓⵜⴼ ⵓⴰ ⴶ ⴹⴰ ⴹⵗ ⴾⵙⵓ⵰ ⵤⵤⵀⵜⴹⵓ ⴼⵍⵓⵏ ⵎⵛⵏⴰ ⵔⵈⵎⵜⵏⵜ⵰");
INSERT INTO ttqt_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ⵓⴰ ⵛⵔⵓⵜ ⴹⵏ⵿ⵜⴼⵍⵜ ⵀⵍⵙ ⴹⵙⵍⴼⵏⵙ ⴹⵜⵎⵜⵢ⵰ ⵏⵂⵍⵏ ⵍⴾⵏⵙⵜ ⵜⵏ ⵗⵔⵎ ⵏ⵿ⵜⵙⵍⵏⴾ ⵜⵎⵙⵜ ⵜⵎⵜⵢ ⵜⵔ⵿ⵜⵢⵜ ⴹⵎⵛⵏⴰ ⴹⵢ ⵏⵀⴰ ⴹⵎⵍⵢ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ⴾⴼⵓⵏ ⵎⵛⵏⴰ ⵔⵈⵎⵜ ⴹⵍⵈⵔ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ⴼⵓ ⴹⴰ ⵏⵜⴶⴹⵢ ⵢ ⵎⵛⵏⴰ ⴹⵗ ⵜⵍⵗⵏⵓⵏ ⴾⵜⵏⵓⵏ ⵙⵗⴰ ⴾⵍ ⵓⴰ ⴾⵓⵏ⵿ⴹⵏⴾⵜⴰ ⴹⵗ ⵜⵓⵜⵔⵓⵏⵏⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ⴼⵓ ⴹⴰ ⵏⴾⵜⵓ ⴹⵜ ⵎⵛⵏⴰ ⴹⵢ ⵏⵀⵏⵏⴰ ⵓⴰ ⴹⵔ ⴶⴹⴰ ⵤⵎⵤⵍ ⵓⴰ ⵜⴶⵎ ⵤⴶⵤⵏⵓⵏ ⴹⵎⴾ ⵓⵙ ⵜⵛⵗⵍⵎ ⵙ ⵜⵔⴰ ⵜⴰ ⴾⵓⵏ⵿ⵜⵂⵜ ⴹⵤⵎⵔⵜⵏⵓⵏ ⴹⵗ ⴶⵢ ⵏⵜⵎⴰ ⴹⵗ ⵎⵍⵏⵏⴰ ⵗⵢⵙⴰ ⵍⵎⵙⵈ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ⵏⵙⵏ ⵎⴹⵔⵢⵏⵏⴰ ⵙ ⵙⵏⴼⵔⵏ⵿ⴾⵓⵏ ⵎⵛⵏⴰ ⴾⵓⵏⵢ ⵔⴰ ⵢⴹ ⵜⵆⵍⵎ ⵜⵎⵜⵢⵏⵜ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ⴹⵢ ⴹⴰ ⴼⵍⵙ ⵙⵍⵏ ⵏⵍⵏ⵿ⵌⵍ ⵓⵏ ⴹⵓⵏⴶⴰ ⵓⵔ ⴾⵓⵏⵏⵙⵏ ⵎⵙⵏ ⵓⵍ ⵗⵙ ⴾⵍⵔ ⵎⵙⵏ ⵎⵤⵍⵏ ⵏ⵿ⵜⵔⵏⴰ ⴹⵙⴶⵜⴾⵢ ⵤⵓⵔⵏ ⵓⵏ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ⵜⵙⵏⵎ ⵓⵍⵏ ⵎⵤⵍⵏ ⵓⵏ ⵏⴶⴰ ⴶⵔⵓⵏ ⴼⵍ ⴶⵎⵢ ⵏ⵿ⵜⵏ⵿ⴼⵏⵓⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ⵜⵜⵍⵍⵎⵏⵏⴰ ⵜⵜⵍⵍⵎ ⴹⵗ ⵎⵍⵢ⵰ ⵜⵎⵗⵜⵔⵎ ⵓⵍⵏ ⴶⵙ ⵓⵔ ⴹⵓⵏⴶⴹⵍ ⵓⵏ ⵍⵆⵀⵍⵜ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⵙ ⵜⴹⵓⵜ ⵜⴰ ⵂⴾⵓ ⵏ⵿ⴼⵙ ⵓⴰ ⵤⴹⴶⵏ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ⵎⴾ ⵓⵏ ⴹⵗ ⵙ ⵜⵆⵍⵎ ⵍⵎⵙⵍ ⵍⵗⵏ ⵢⵍⵎⵙⵈⵜⵏ ⴾⵍ ⵓⵏ ⵂⵏⵏ ⴾⵍ ⵏⵎⵙⴹⵏⵢⴰ ⴹ ⵓⵏ ⴾⵢⴰ⵰ ");
INSERT INTO ttqt_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ⵓⵔⴶⵗ ⵎⵙⴹⵏⵢⴰ ⴹⴾⵢⴰ ⵗⵙ ⴹⵗ ⵜⵓⵙⵍⵏ ⴶⵜⵏ ⵏⵓⵍ ⵏⵎⵛⵏⴰ ⵓⵏ ⵗⵔⵓⵏ ⴶⵏⵏ ⴾⵍⵔ ⴹⴶ ⴾⵍ ⵓⵤⵓⵤⵏ ⴹⵗⵙ ⵙⵍⵏ ⵏⵤⴶⵤⵏⵓⵏ ⵙ ⵎⵛⵏⴰ ⵂⵔ ⵙ ⵓⵔ ⵏⴹⵔⵔ ⵙ