﻿USE sofia;
DROP TABLE IF EXISTS sofia.ttq_vpl;
CREATE TABLE ttq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ttq_vpl WRITE;
INSERT INTO ttq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ǝntanay da esmawan n aljadan ǝn Ɣaysa Ǝlmǝsix, ahaya n ǝnnǝbi Dawǝd, d ǝnnǝbi Ibrahim: ");
INSERT INTO ttq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim eraw Isǝhaq. Isǝhaq eraw Yaqub. Yaqub eraw Yahuda ǝd mǝdrayan-net. ");
INSERT INTO ttq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda eraw Farǝs ǝd Zarax, anna-nasan esǝm-net Tamar. Farǝs eraw Xasrun. Xasrun eraw Ram. ");
INSERT INTO ttq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram eraw Ɣaminadab. Ɣaminadab eraw Našon. Našon eraw Salmuna. ");
INSERT INTO ttq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuna eraw Boxaz was anna-net Rahab. Boxaz eraw Ɣubayd was anna-net Rut. Ɣubayd eraw Yasay. ");
INSERT INTO ttq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yasay eraw Dawǝd wa n ǝmǝnokal. Dawǝd eraw Suliman was anna-net tantut n Urǝyya. ");
INSERT INTO ttq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suliman eraw Roxoboham. Roxoboham eraw Abǝya. Abǝya eraw Aza. ");
INSERT INTO ttq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza eraw Yahušafat. Yahušafat eraw Yuram. Yuram eraw Ɣuzǝyas. ");
INSERT INTO ttq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ɣuzǝyas eraw Yutam. Yutam eraw Axaz. Axaz eraw Xizqǝyyas. ");
INSERT INTO ttq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xizqǝyyas eraw Manašša. Manašša eraw Amun. Amun eraw Yušǝya. ");
INSERT INTO ttq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yušǝya eraw Yakunǝya ǝd mǝdrayan-net. Azzaman win den ǝntanay a daɣ tawaɣan Kǝl-Israyil ǝmmewayan s akal ǝn Babǝylon ǝqqalan daɣ-as ikefǝlan. ");
INSERT INTO ttq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dǝffǝr adi, eraw Yakunǝya Šalatǝyel. Šalatǝyel eraw Zǝrubabil. ");
INSERT INTO ttq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zǝrubabil eraw Abihud. Abihud eraw Alyaqim. Alyaqim eraw Yazur. ");
INSERT INTO ttq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yazur eraw Saduq. Saduq eraw Xakim. Xakim eraw Elǝyud. ");
INSERT INTO ttq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elǝyud eraw Elyazar. Elyazar eraw Mattan. Mattan eraw Yaqub. ");
INSERT INTO ttq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaqub ǝnta a erawan Yusǝf wa izlafan Maryama ta terawat Ɣaysa was itawannu Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Daɣ adi maraw meddan d ǝkkoz a ǝllanen gǝr Dawǝd d ǝmaraw-net Ibrahim. Ǝllân-tu maraw d ǝkkoz gǝr Dawǝd d azzaman win ǝtǝwǝkfal ǝn Kǝl-Israyil ǝs Babǝylon, ǝllân-tu deɣ maraw d ǝkkoz gǝr ǝtǝwǝkfal ǝn Kǝl-Israyil ǝs Babǝylon ǝd tǝhǝwt ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ǝnta da ǝmmǝk was d-iggaz Ɣaysa Ǝlmǝsix ǝddǝnet: Maryama ta n anna ǝn Ɣaysa, imirakan dǝr-ǝs Yusǝf azalaf. Mišan harwa da wǝr tǝzlay ǝs Yusǝf, as tǝga tadist, ǝs tarna n Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusǝf, imosan alǝs oɣadan, wǝr ira ǝsǝkkǝrukǝd ǝn Maryama daɣ aytedan. Awen daɣ a fǝl isammarkas daɣ man-net as a dǝr-ǝs iɣrǝd da wǝr t-illa i ǝhan salan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Isamadran daɣ awen da as t-in-ibaz etǝs inafalal-as-du angalos n Ǝmǝli daɣ targǝt, inn-as: «Yusǝf, ahaya ǝn Dawǝd, a kay-wǝr-tǝggǝz tasa n azalaf ǝn Maryama, fǝlas barar wa ihan tadist-net, Infas wa Zǝddigan a d-ifal. ");
INSERT INTO ttq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ad tǝgrǝw barar amaran kay ag-as esǝm Ɣaysa fǝlas ǝnta a zʼassafsin tamattay-net daɣ bakkadan.» ");
INSERT INTO ttq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Arat wa kul iga fǝl ad andu awal wa d-imal Mǝššina ǝs tarrayt n ǝnnǝbi Isayas as inna: ");
INSERT INTO ttq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ad tagu tǝmawat tadist da wǝr tǝzday meddan, tǝgrǝw barar. Barar wǝdi a das-itǝwǝggu esǝm Emanǝwel, almaɣna: Mǝššina illâ ɣur-na.» ");
INSERT INTO ttq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","As d-inkar Yusǝf daɣ etǝs, immozal s arat was t-omar angalos n Ǝmǝli, izlaf Maryama. ");
INSERT INTO ttq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mišan wǝr kala a dǝr-ǝs inamansa har ihǝw barar. As ihǝw, ig-as Yusǝf esǝm Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Azzaman n Ǝmǝnokal Herod a daɣ ihǝw Ɣaysa, daɣ ǝɣrǝm ǝn Betalxam, daɣ amaḍal ǝn Yahudǝyya. Ǝglan-du musanan ǝn manayan a d-ǝfalnen dǝnnǝg har d-osan Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ǝnnan: «Ma iga ǝmǝnokal ǝn Kǝl-Ǝlyǝhud wa ihǝwan da sǝket? Atri-net a nǝnay daɣ dǝnnǝg, amaran nǝkk-ay-du y a das-nǝssǝjǝd.» ");
INSERT INTO ttq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Arat wa as t-isla ǝmǝnokal Herod, iga aššawaša zǝwwǝran, ǝnta harkid Kǝl-Yerusalam kul. ");
INSERT INTO ttq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iššedaw-du imuzaran ǝn limaman, ǝd musanan n Ǝttawret, issǝstǝn-tan d adag wa daɣ zʼihǝw Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ǝnnan-as: «Aɣrǝm ǝn Betalxam a daɣ zʼihǝw daɣ amaḍal ǝn Yahudǝyya, fǝlas ǝnnǝbi Mika iktâb âs: ");
INSERT INTO ttq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","\"Kam amaran Betalxam, ta n amaḍal ǝn Yahudǝyya, tǝheɣ iɣǝrman win aɣaf daɣ akal ǝn Yahudǝyya, fǝlas kam a du-z-igmǝd ǝmuzar wa zʼagin i tamattay-nin Israyil tizart ta itaggu amadan y aharay-net.\"» ");
INSERT INTO ttq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tǝzzar isassaɣra-du ǝmǝnokal Herod imusanan win manayan en, imos awen arat igân daɣ ǝssir, issǝstan-tan ǝd tamert tas igmad aššak as ǝnta daɣ d-inafalal ǝtri wa ǝmalan den. ");
INSERT INTO ttq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dǝffǝr awen issok-en Betalxam inn-asan: «Agliwat, taknim asawad i dad illa barar wa ihǝwan da, as tu-tǝgrawam, tǝmmǝram-i-du tǝmǝlam-i dad illa, fǝl ad t-akka ǝssǝjǝdaɣ-as nak da.» ");
INSERT INTO ttq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","As dasan-iɣrad ǝmǝnokal awal, ǝglan. Tǝzzar oggan atri wa dasan-inafalalan daɣ jǝnnawan dat awen daɣ dǝnnǝg. Wǝr immǝzzay ǝtri en ad illa dat-san, azzar-asan, as imal dǝnnǝg adag wa iha barar, izzǝkkat. ");
INSERT INTO ttq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","As ǝnayan atri as izzǝkkat, ǝknan tǝfalawist, ");
INSERT INTO ttq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ǝggazan-in ehan, ǝnayan barar d anna-net Maryama, ǝgaraffen ǝssǝjadan i barar. Dǝffǝr adi, oran ilalan-nasan, ǝkkasan-as-du daɣ-san šibǝddar ǝganen daɣ urǝɣ, d ǝššin sǝqqidan ǝzodnen, ǝmosnen ǝzzǝnǝf ǝn taɣǝlbast. ");
INSERT INTO ttq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dǝffǝr awen isannafalal-asan-du Mǝššina daɣ targǝt as ad wǝr ǝqqǝlan Herod. Awen da a fǝl obazan tarrayt iyyat ǝqqalan akal-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dǝffǝr as ǝglân, inafalal-du angalos n Ǝmǝli i Yusǝf daɣ targǝt, inn-as: «Ǝnkǝr, tidawaɣ ǝd barar d anna-net, takka tarmad akal ǝn Masar taqqama daɣ-as har dak-ǝmǝlaɣ assaɣa wa du-za-tǝqqǝla, fǝlas barar di ad igmǝy Herod ǝd tanaɣay-net.» ");
INSERT INTO ttq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Inkar Yusǝf, iddew ǝd barar d anna-net, eway ehad, obaz tarrayt ikka Masar. ");
INSERT INTO ttq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ǝqqiman daɣ Masar den da har aba Herod. Arat wa iga fǝl ad andu awal wa d-iga Ǝmǝli ǝs tarrayt n ǝnnǝbi Osay a daɣ inna: «Ǝɣre-du barar-in ǝssǝrdaɣaq-q-idu Masar.» ");
INSERT INTO ttq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","As issan Herod as imusanan win manayan ǝmmizrayan batu-net ǝɣlayan-tu, iɣašašat, omar s ad tǝwǝnɣin bararan ǝn yayyan kul win ǝhǝwnen daɣ aɣrǝm ǝn Betalxam, ǝd ɣǝlǝyɣǝlayan-net, a d-obazan ɣur ǝššin elan har azzaman win den, imos as tamert ten da as das-ǝnnan musanan win ǝnta daɣ d-inafalal ǝtri. ");
INSERT INTO ttq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Den daɣ ad inda awal wa d-iga Ǝmǝli ǝs tarrayt n ǝnnǝbi Irmǝya a daɣ innâ: ");
INSERT INTO ttq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Tǝga-du tǝkurayt daɣ ǝɣrǝm ǝn Rama, imos awen tala n aytedan fǝl tǝga tǝfǝyyawt. Awen Raxil ta n tǝmarawt ǝn Kǝl-Israyil tǝhallit fǝl bararan-net. Wǝr tǝra i das-igan ǝlmaɣiza, fǝlas bararan ǝjwaran aba-tan.» ");
INSERT INTO ttq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dǝffǝr tǝmattant ǝn Herod, inafalal angalos n Ǝmǝli i Yusǝf daɣ targǝt, daɣ akal ǝn Masar. ");
INSERT INTO ttq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Inn-as angalos: «Ǝnkǝr, tidawaɣ ǝd barar di d anna-net, tǝqqǝlaɣ akal n Israyil, fǝlas aytedan win ǝranen tenaɣay-net, aba-tan.» ");
INSERT INTO ttq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Inkar Yusǝf, iddew ǝd barar d anna-net, iqqal akal n Israyil. ");
INSERT INTO ttq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mišan igraw isalan as Arkalawǝs, a imosan ǝmǝnokal n akal ǝn Yahudǝyya, daɣ adag n abba-net Herod. Tǝzzar tǝggaz tasa Yusǝf, ab-as ihal iki ǝn Yahudǝyya, ikka akal ǝn Galilaya id Mǝššina a das-d-isannafalalan awen daɣ targǝt. ");
INSERT INTO ttq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Igla iɣsar daɣ ǝɣrǝm as itawannu Nazaret. Ǝmmǝk en daɣ as ǝgan aratan win, fǝl ad andu awal wa d-iga Ǝmǝli ǝs tarrayt n ǝnnǝbitan as ǝnnan: «Itawagg-as esǝm aw Nazaret.» ");
INSERT INTO ttq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Elan dǝffǝr awen, issǝnta Yaxya wa isalmaɣan daɣ aman igi ǝn tǝlxutbat daɣ taneray ǝn Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Igannu: «Utabat! Illikan as, Taɣmar ta n jǝnnawan tahôz!» ");
INSERT INTO ttq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yaxya en daɣ a fǝl immǝgrad ǝnnǝbi Isayas assaɣa wad inna: «Alǝs iyyan idkâl ǝmǝsli-net daɣ ǝsuf igannu: \"Sǝmmutǝgat abaraqqa y Ǝmǝli! Tǝsǝssiɣǝdam tarrayen dat-ǝs!\"» ");
INSERT INTO ttq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaxya ilsa tabdoq tǝgât daɣ anzadan n ǝmnǝs, otâb s ǝsatǝb n agašek. Iddâr s ǝjwalan ǝd turawat. ");
INSERT INTO ttq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A t-in-tasin aytedan, ǝgmâdan-du Yerusalam, d akal ketnet wa n Yahudǝyya, d amaḍal kul wa n ɣǝlǝyɣǝlayan n agarew wa n Yordan, ");
INSERT INTO ttq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","tutaban daɣ bakkadan-nasan dat tamattay, isalmaq-qan Yaxya daɣ aman daɣ agarew wen. ");
INSERT INTO ttq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Osan-du Farisaytan aggotnen, ǝd Sadusaytan, y a tan-issǝlmǝɣ Yaxya daɣ aman. As inay Yaxya arat wen inn-asan: «Xa taššolen šin! Ma kawan-issosanan ǝdǝrrǝg y attadib wa d-izayan ǝn Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Daɣ adi taggiwat imazalan olaɣnen tǝsǝttǝddim sǝr-san tǝtubt-nawan! ");
INSERT INTO ttq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wǝr igda ad tǝgannim daɣ man-nawan: \"Nakkanay ǝzzurrǝyya n ǝnnǝbi Ibrahim a nǝmos,\" fǝlas silakanaɣ-awan as Mǝššina ifrâg ad isǝmmǝttǝy šihun šin tǝhannayam da, ixlǝk-du daɣ-asnat ǝzzurrǝyya y Ibrahim! ");
INSERT INTO ttq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Agat ǝnnǝyat! Tazǝft harwa ǝmǝrǝdda da tǝmmotag y a du-tǝsǝddǝngǝr y eškan. Daɣ adi ašǝk kul wa wǝr nǝtirǝw aratan olaɣnen, ad itǝwǝɣtǝs, itǝwǝgǝr-in daɣ tǝmsay! ");
INSERT INTO ttq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nak, aman a daq qawan-salmaɣa, fǝl ad sǝnnǝfilǝlaɣ s awen tǝtubt-nawan. Mišan wa du-z-asin dǝffǝr-i, awa di-iga daɣ šigrat, wǝr eweda wala arra ǝn suɣan ǝn ɣateman-net. Ǝnta Infas Wa Zǝddigan ǝd tǝmsay a daq qawan-z-issǝlmǝɣ. ");
INSERT INTO ttq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iha ǝlmital n awedan ittâfan tesayt y ad izzǝzǝr alkama-net. Išadaw alkama daɣ tadangawt-net, šiɣal amaran ag-enat daɣ tǝmsay tǝbilaglagat faw.» ");
INSERT INTO ttq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Adan en da daɣ d-osa Ɣaysa, igmâd-du akal ǝn Galilaya, ikka-du agarew wa n Yordan, y ad t-issǝlmǝɣ Yaxya daɣ aman. ");
INSERT INTO ttq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mišan igmay Yaxya d a daɣ-as ikkǝs awen. Inn-as Yaxya: «Nak a iddǝraran s a di-tǝssǝlmǝɣa daɣ aman, amaran kay iman-nak a di-d-ikkan?» ");
INSERT INTO ttq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ijjǝwwab-as Ɣaysa inn-as: «Ǝmǝrǝdda ardu s arat wǝdi da, fǝlas ilzam-anaɣ ad nassandu arat kul wa ira Mǝššina.» Tǝzzar irda Yaxya s ǝsǝlmǝɣ ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Itawasalmaɣ Ɣaysa ɣas, igmad-du aman, ǝnnolaman jǝnnawan daɣ amazay wen da, ogga Infas ǝn Mǝššina as d-igmad ijǝnnawan, iha šaššelan ǝn tǝdabert, iwar-tu. ");
INSERT INTO ttq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Igmad-du ǝmǝsli ijǝnnawan inna: «Ǝnta ǝddi Barar-in ǝkne tara, amaran ǝnta a d-issǝndan agna-nin.» ");
INSERT INTO ttq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tǝzzar issoka Infas wa Zǝddigan Ɣaysa taneray y a daɣ-as t-ajjarrab Iblis. ");
INSERT INTO ttq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","As iga Ɣaysa ǝkkozat tǝmǝrwen n ǝzǝl d ǝkkozat tǝmǝrwen n ahad izûm, iggaz-tu gǝlǝk. ");
INSERT INTO ttq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ihoz-t-idu Iblis a n ǝnǝjjerrǝb inn-as: «Kud kay Barar ǝn Mǝššina, tamǝra šihun a s ad ǝqqǝlnat amensay.» ");
INSERT INTO ttq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mišan inn-as Ɣaysa: «Wǝrgeɣ ǝnnan Ǝlkǝttaban: \"Aggadǝm wǝrgeɣ imensewan ɣas as itaddar, kalar isuddur-tu ad ilkâm y awal ketnet wa d-ifalan Mǝššina.\"» ");
INSERT INTO ttq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ikka dǝr-ǝs Iblis aɣrǝm wa zǝddigan ǝn Yerusalam, issǝbdad-tu fǝl afalla n Ahan wa Zǝwwǝran n Ǝlɣibada, ");
INSERT INTO ttq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","inn-as: «Kud kay Barar ǝn Mǝššina, tǝtǝrǝgge, fǝlas ǝnnan Ǝlkǝttaban: \"Ad amǝr Mǝššina angalosan daɣ talɣa-nak, ǝkbǝlan-kay daɣ fassan-nasan, fǝl a dak-wǝr-tǝnkǝf tǝhunt.\"» ");
INSERT INTO ttq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Inn-as Ɣaysa: «Wǝrgeɣ za Ǝlkǝttaban di ǝnnân: \"Ad wǝr tǝtajjarraba Ǝmǝli-nak Mǝššina.\"» ");
INSERT INTO ttq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dǝffǝr awen ikka dǝr-ǝs Iblis afalla n ǝdɣaɣ iknan tǝzzǝgrǝt, issǝswad-tu daɣ taɣmaren kul n ǝddǝnet ǝd tǝhussay-nasnat, ");
INSERT INTO ttq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","inn-as: «Awa togge den kul ǝkfeɣ-ak-ku as di-tǝssǝjada tǝɣbadaɣ-i.» ");
INSERT INTO ttq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Inn-as Ɣaysa: «Ugag-i, Aššaytan! Wǝrgeɣ ǝnnan Ǝlkǝttaban: \"Ǝmǝli-nak Mǝššina as za tǝssǝjǝda, ǝnta ɣas a za tǝɣbǝda.\"» ");
INSERT INTO ttq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amaran oyy-ay Iblis. Ǝhinan-in angalosan ǝkkân-du Ɣaysa ǝssanan daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","As isla Ɣaysa ǝtǝrmǝs ǝn Yaxya, iqqal akal ǝn Galilaya. ");
INSERT INTO ttq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mišan wǝr iqqim daɣ ǝɣrǝm ǝn Nazaret. Kalar igla iɣsar daɣ tǝɣrǝmt tǝgât Kafarnahum, tǝwârat tǝgadamayt n agaraw wa n Galilaya daɣ amaḍal ǝn Zǝbulun ǝd wa n Naftali. ");
INSERT INTO ttq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ǝmmǝk en daɣ as inda awal wa d-iga Ǝmǝli ǝs tarrayt n ǝnnǝbi Isayas a daɣ innâ: ");
INSERT INTO ttq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Akal ǝn Zǝbulun ǝd wa n Naftali, ǝhanen ǝsǝlim n agaraw wa n Galilaya, fǝl tǝgadamayt ta n ataram ǝn Yordan, almaɣna Galilaya, ǝnta a daɣ ǝɣsaran aytedan win Kǝl-Ǝlyǝhud ǝd win tan-wǝr-nǝmos! ");
INSERT INTO ttq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tamattay ta tǝhat šiyyay, tǝnay ǝnnur zǝwwǝran as imalawlaw, aytedan deɣ win ǝhanen akal wa tǝlsa telay ǝn tǝmattant, ǝntanay da ibalazlaz fall-asan ǝnnur.» ");
INSERT INTO ttq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Azzaman en da a daɣ iggaz Ɣaysa šin igi ǝn tǝlxutbat igannu: «Utabat, fǝlas Taɣmar ta n jǝnnawan tǝhôz!» ");
INSERT INTO ttq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ǝzǝl iyyan ijiwankat Ɣaysa fǝl tǝgadamayt n agaraw wa n Galilaya as inay ǝššin mǝdrayan, s iyyan esǝm-net Simɣon was itawannu Butros, d amadray-net Andrawǝs. Meddan win inabazan ǝn kifitan a ǝmosan. As tan-inay fattawan daɣ agaraw sangaytan-nasan win abbaz ǝn kifitan. ");
INSERT INTO ttq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Inn-asan Ɣaysa: «Ǝlkǝmat-i, a kawan-aga meddan sǝr-i du-za-tawaynen aytedan y a tan-assafsa daɣ bakkadan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oyyan sangaytan-nasan daɣ tamazayt ten da, əlkaman-as. ");
INSERT INTO ttq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","As iga Ɣaysa arat ǝn teklay dǝffǝr awen, inay ǝššin mǝdrayan wiyyad, ǝmosnen Yaqub d amadray-net Yaxya win maddanǝs ǝn Zabaday. As tan-inay nimahan aɣlal n aman d abba-nasan Zabaday, kannin sangaytan-nasan win as tabazan kifitan. Iɣr-en Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Amazay wen daɣ ad oyyan aɣlal-nasan, ǝfalan abba-nasan, ǝlkaman i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Issǝwal Ɣaysa akal ǝn Galilaya ketnet, isasaɣru daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. Immâl Ǝlinjil, imosan isalan ǝn Taɣmar ta n jǝnnawan, izuzǝy aytedan daɣ ǝkkulluk ǝn tǝwǝrna, d ǝkkulluk n ǝlɣib. ");
INSERT INTO ttq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ǝmmǝk en daɣ as itawasla Ɣaysa daɣ amaḍal ǝn Surǝya kul. A das-du-tamawayan aytedan kul win ǝrinnen, ǝd win t-ǝllanen d ǝlɣiban a ǝqqalan, ǝd win ǝssǝranan kǝlǝsuf, ǝd win ǝlanen ikǝrǝkkitan ǝd nǝbdan, izuzǝy-tan. ");
INSERT INTO ttq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ǝlkâmnat-as tǝmattiwen aggotnen a d-ǝfalnen Galilaya, d akal was itawannu «Wa-n-Maraw-Ɣǝrman», ǝd Yerusalam, d akal ǝn Yahudǝyya, d amaḍal wa ihan dǝnnǝg ǝn Yordan. ");
INSERT INTO ttq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","As inay Ɣaysa šimattiwen šin t-id-osanen den, iwar adɣaɣ. Iqqim den da, ǝhozan-tu nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Issǝnta ǝsǝssǝɣri n aytedan win ǝllanen den. Inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ǝbbilalan aytedan win ǝllǝqqawnen daɣ man-nasan, ǝqbâlan as ǝddiraran ǝs Mǝššina fǝlas Taɣmar ta n jǝnnawan šin-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ǝbbilalan win hallinen, fǝlas a tan-isǝddǝwǝt Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ǝbbilalan win ǝssǝrasnen iman-nasan, fǝlas ad ǝgrǝwan akal wa dasan-issǝnsa Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ǝbbilalan win ǝknanen deran n awa oɣadan, fǝlas ad t-ǝgrǝwan. ");
INSERT INTO ttq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ǝbbilalan win hanattatnen i naragan-nasan, fǝlas ǝntanay da a dasan-ihǝnǝttǝt Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ǝbbilalan win as zaddogan wallan-nasan, fǝlas ad ǝnǝyan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ǝbbilalan win tagginen alxer, fǝlas a dasan-agu Mǝššina esǝm bararan-net. ");
INSERT INTO ttq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ǝbbilalan win tawadgaznen fǝl igi n awa oɣadan, fǝlas Taɣmar ta n jǝnnawan šin-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tǝbbilalam kawanay a rabbadan aytedan, ǝdgâzan-kawan, wǝr t-illa ǝzzǝnǝf n ǝzgǝn a kawan-wǝr-ǝssǝwaran, fǝl ǝddǝlil-in. ");
INSERT INTO ttq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Awalla, dawatat, tǝfǝliwǝsam, fǝlas tǝlâm arozan aggotnen daɣ jǝnnawan. Ǝnnǝbitan win dat-wan, da ǝmmǝk wǝdi daɣ as tawadgazan.» ");
INSERT INTO ttq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Inn-asan Ɣaysa: «Kawanay tesǝmt a tǝmosam y ǝddǝnet. Amaran as imos as tesǝmt ta, ab-as tǝla tembay, mǝni ǝmmǝk was tat-du-za-tǝtǝwǝsuɣǝl tembay-net? Tesǝmt ta, ab-as tǝnfa wala: wǝr tǝhor ar d a din-tǝtǝwǝgǝr sǝdi, a tat-dayyazan aytedan. ");
INSERT INTO ttq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ǝnnur n ǝddǝnet a tǝmosam. Aɣrǝm ikrâsan fǝl afalla n ǝdɣaɣ, wǝr t-illa awedan a tu-wǝr-za-nǝnǝy. ");
INSERT INTO ttq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ǝmmǝk en daɣ a tǝga fǝtǝla: As tǝrɣa, wǝr za tǝtǝwǝggu daw ǝɣǝzu! Kalar ǝtǝwǝgga a za tagu daɣ adag iknan ahaku fǝl ad tǝsǝmmǝlǝwlǝw aytedan kul win ǝhanen ehan. ");
INSERT INTO ttq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ǝmmǝk di daɣ as imǝlǝwlǝwet ǝnnur-nawan, dat aytedan kul, fǝl ad ǝnǝyan aratan olaɣnen win tǝtaggim, awǝy-du sǝr-san awen ad ǝmmâlan tanaya n Abba-nawan di ihan ijǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Inn-asan Ɣaysa: «Ad wǝr tǝɣilam assa a d-ǝge y a din-ǝkkǝsaɣ awa iktaban daɣ Ǝttawret, madeɣ Ǝlkǝttaban n Ǝnnǝbitan. Wǝrgeɣ adi a d-ǝkke, kalar assa a d-ǝgeɣ y a tan-assanda. ");
INSERT INTO ttq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ǝggiyyeɣ ǝsilakanaɣ-awan as: Iket ǝllan-tu jǝnnawan d amaḍal, Ǝttawret wǝr t-in-za-tǝgmǝd wala tǝtǝbǝqqet, amaran wala ɣas ǝsakkal wǝr t-in-z-igmǝd iket wǝr inda arat kul wa daɣ-as iktaban. ");
INSERT INTO ttq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Awen daɣ a fǝlas awedan wa immǝzrayan wala ɣas alwajib wa ogaran tǝmmǝdrǝyt, omar aytedan s ad agin awen da, awedan wǝdi ǝnta a zʼagǝran eres daɣ Taɣmar ta n jǝnnawan. Mišan as imos as ibbirdag awedan y alwajiban win, isasaɣr-en y aytedan, wǝdi ad igrǝw adkul daɣ Taɣmar ta n jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Awalla, ǝmâlaɣ-awan âs as wǝr tǝgem i Mǝššina ǝbǝrdǝg ogaran wa das-ǝgan musanan n Ǝttawret, ǝd Farisaytan, wǝdi wǝr za tǝggǝzam Taɣmar ta n jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tǝslâm as itiwanna y aljadan-nana daɣ Ǝttawret: \"ad wǝr tagaɣ iman.\" As iga awedan iman, ad t-ibǝz ǝššǝriɣa awwaddab. ");
INSERT INTO ttq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nak za ǝnneɣ-awan, awedan kul wa iggaz alham n iyyan, wǝdi ad t-ibǝz ǝššǝriɣa awwaddab. Awedan deɣ kul wa innan y iyyan: \"Anafnoz!\" Wǝdi ad itǝwǝsǝbdǝd dat Asaggawar wa Zǝwwǝran as itawannu Sanhedrin fǝl ad itǝwǝšrǝɣ, amaran awedan wa innan y iyyan: \"Kay amaros!\" Wǝdi ǝššǝriɣa-net Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Daɣ adi as du-tǝkteɣ as iššak-kay awedan daɣ amazay wa daɣ du-tewaya tǝkutay-nak s adag wa n ǝsǝqqǝd ǝn tǝkutawen, ");
INSERT INTO ttq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tayya takutay-nak ǝddi da, tagla har tǝnǝmǝsurǝfa d awedan wǝdi, dǝffǝr adi amaran tǝqqǝla taga takutay-nak. ");
INSERT INTO ttq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","As kay-issǝwar awedan lahan, takna dǝr-ǝs tarmad iket di ad tǝhâm tarrayt. As wǝr iga adi, awedan wǝdi, ad išǝššiwǝd batu tǝdi ǝlqali. Tǝzzar inkǝr ǝlqali ag-ik daɣ fassan ǝn soji a kay-z-agin daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","As iga adi amaran ǝggǝyyeɣ ǝsilakanaɣ-ak as wǝr du-za-tǝgmǝdaɣ iket wǝr tǝɣreda arazam n arat kul was kay-ǝwaran ǝrruzmatan-net. Wala tamma iyyadda wǝr din-za-taqqam. ");
INSERT INTO ttq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tǝslâm as itiwanna: \"ad wǝr tagaɣ ǝzzǝna.\" ");
INSERT INTO ttq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nak za ǝnneɣ-awan awedan kul wa igan daɣ tǝntut asawad daɣ isidaran ǝnǝmǝnsa-net, wǝdi igâ dǝr-ǝs ǝzzǝna daɣ ǝwǝl-net. ");
INSERT INTO ttq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kud šat-nak ta n ǝɣil a tǝbukat a dak-tǝqqǝl ǝssǝbab n igi n abakkad, tǝkǝkkǝreq-qat-du tǝgǝraq-qat-in, id of-ak tǝgmad-kay tǝslǝt-nak iyyadda, y ad tǝtǝwǝgǝr tǝɣǝssa-nak kul daɣ Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Amaran kud ǝfus-nak wa n ǝɣil a ibukan a dak-iqqǝl ǝssǝbab n igi abakkad, tǝfrǝsaq-qin tǝgǝraq-q-in, id of-ak tǝgmad-kay tǝslǝt-nak iyyadda, y ad tǝggǝz tǝɣǝssa-nak ketnet Jahannama.» ");
INSERT INTO ttq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Igla Ɣaysa iššewal, inn-asan: «Itiwanna deɣ: \"I izammazzayan tantut-net, akfet-tat širawt n ǝmǝzzǝy.\" ");
INSERT INTO ttq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nak za silakanaɣ-awan as i izammazzayan tantut-net fǝl a wǝr nǝmos igi ǝn meddan, wǝdi ǝsǝssugi a tat-iga ǝzzǝna, amaran as izlaf alǝs iyyan tantut ta tǝmmǝzzayat da, wǝdi ǝzzǝna a iga ǝnta da. ");
INSERT INTO ttq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tǝslâm deɣ as itawanna y aljadan-nana: \"Ad wǝr tǝhhadam fǝl arat, taqqamim wǝr tu-tǝmmozalam. Kalar sabdadat arkawalan win fǝl tǝhadam s esǝm n Ǝmǝli.\" ");
INSERT INTO ttq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nak za ǝnneɣ-awan, ad wǝr tǝhhadam fǝl arat waliyyan fadda: Gǝr za ǝs jǝnnawan, fǝlas edag n ǝlxǝkum ǝn Mǝššina a mosan, ");
INSERT INTO ttq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala deɣ tǝhǝdam s amaḍal, fǝlas ǝnta a illan daw daran-net, wala deɣ tǝhǝdam ǝs Yerusalam, fǝlas ǝnta a tǝmosat aɣrǝm n Ǝmǝnokal wa Zǝwwǝran, a t-imosan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ad wǝr tǝhhadaɣ ǝnta da s aɣaf-nak, fǝlas wǝr tǝfregaɣ ǝsǝmlǝl n anzad-net waliyyan da, wala deɣ ǝsǝkwǝl-net. ");
INSERT INTO ttq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ganniwat ɣas: \"Ayew\" y awa imosan tidǝt, madeɣ \"kala\" y awa imosan bahu. Batu a du-tǝššotam fǝl adi kul Aššaytan as du-tǝha. ");
INSERT INTO ttq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tǝslâm as itiwanna: \"I d-ikkasan šat n iyyan a du-tǝtǝwǝkkǝs šat-net ǝnta da, i d-irzan ešen n iyyan a d-itǝwǝrzu ašen-net.\" ");
INSERT INTO ttq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nak za ǝnneɣ-awan ad wǝr tǝtagazam iman-nawan daɣ amaksan. Kalar as dak-iqqas fǝl ǝmdǝd-nak wa n ǝɣil, takfaq-qu amdǝd-nak wa hadan. ");
INSERT INTO ttq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","As ira awedan a kay-ibǝz s ǝššǝriɣa fǝl ad igrǝw alɣaššaba-nak, takfaq-qu ǝbǝrnuz-nak da. ");
INSERT INTO ttq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","As kay-išahhaššal awedan aggay ǝn lalan-net har ǝgim ǝn takkolt, tawǝyaɣ-as-tan har ǝššin gim ǝn takkolt. ");
INSERT INTO ttq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","I kay-onsayan takfaq-qu, i daɣ-ak igmayan ǝmarwas, a das-tu-wǝr-tǝgdǝla. ");
INSERT INTO ttq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tǝslâm as itiwanna: \"Iru anammaray-nak, tǝgzǝraɣ azangaw-nak.\" ");
INSERT INTO ttq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nak za ǝnneɣ-awan: Iriwat izǝnga-nawan, ad tǝtaggim šiwatriwen olaɣnen y aytedan win kawan-ǝsasnen, ");
INSERT INTO ttq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","fǝl ad tǝqqǝlam ǝs tidǝt da bararan n Abba-nawan wa ihan ijǝnnawan. Ǝnta a d-isagmadan tǝfuk-net fǝl aytedan win maksanan ǝd win olaɣnen, isawat akonak-net fǝl win oɣadnen ǝd win nǝmmǝzray. ");
INSERT INTO ttq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kud wǝr tarem âr aytedan win kawan-ǝranen, awak ma imos aroz wa za tǝgrǝwam daɣ awen? Wǝrgeɣ aytedan win zarzamnen takǝsen a ǝmosnen imaksanan da awen daɣ a ǝgan? ");
INSERT INTO ttq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","As imos as imǝdrayan-nak ɣas a tareɣ tǝsaslamaq-qan, awak ma imos arat immittayan wa tǝgeɣ? Wǝrgeɣ aytedan win wǝr nǝssen Mǝššina da adi daɣ a taggin? ");
INSERT INTO ttq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Daɣ adi kawanay, ǝqqǝlat aytedan ǝkmâlnen šilat n Abba-nawan wa ihan ijǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Igla Ɣaysa iššewal, inn-asan: «Ǝnkǝdat d igi n ǝlɣibada imosan sokni. As wǝr iga adi wǝr za tǝgrǝwam arozan ɣur Abba-nawan wa ihan ijǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«As tǝtagga takutay y amaddarar, ad wǝr iqqǝl adi arat tǝsinafalala, zun awa taggin ǝlmunafiqan daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ǝd tarrayen, fǝl tara n ad ǝgrǝwan adkul ɣur aytedan. Ǝggǝyyeɣ ǝsilakanaɣ-awan as ǝlmunafiqan win di arozan-nasan ǝgrâwan-tan. ");
INSERT INTO ttq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kay amaran, as tǝtagga takutay, ad wǝr issǝn ǝfus-nak wa n zalgat awa itaggu wa n ǝɣil, ");
INSERT INTO ttq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","fǝl ad tǝqqǝl tǝkutay-nak ǝssir. Abba-nak s ǝnta a ihannayan ǝssiran, a dak-z-irzǝman.» ");
INSERT INTO ttq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«As tǝtattaram, ad wǝr tǝtaggim awa taggin ǝlmunafiqan ǝrânen ad tattaran ǝbdadan daɣ nan n ǝlɣibada, ǝd sammanayan, ǝgmâyan s awen a tan-ǝnǝyan aytedan. Ǝggǝyyeɣ ǝsilakanaɣ-awan as arozan-nasan ǝgrâwan-tan. ");
INSERT INTO ttq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kay amaran as tǝtagga šiwatriwen, tǝggǝzaɣ daɣ ahan-nak edag wa ogaran ǝnǝmǝggag d aytedan, tǝxfǝlaq-q-in fǝl man-nak, tǝttǝra daɣ ǝssir s Abba-nak id illa ǝddi. Abba-nak s ǝnta a ihannayan ǝssiran, a kay-z-akfin arozan. ");
INSERT INTO ttq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","As tǝtattaram, ad wǝr tǝtaggam awal aggen tǝgannam arat iyyanda zun awa taggin aytedan win wǝr nǝssen Mǝššina, ǝɣilnen wǝr dasan-z-aslu Mǝššina ar s ad taggin awal aggen. ");
INSERT INTO ttq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A tan-wǝr-tattalalam, fǝlas Abba-nawan, issân awas tǝddǝraram da harwa wǝr daɣ-as tu-tǝgmayam. ");
INSERT INTO ttq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tǝwatray da tas ihor a tat-tǝtaggim kawanay: \"Abba-nana wa ihan ijǝnnawan, Itǝwǝsǝɣmǝret esǝm-nak di zǝddigan, ");
INSERT INTO ttq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","taset-du Taɣmar-nak. Tǝtǝwǝmizǝlet tara-nak fǝl amaḍal s ǝmmǝk was tǝtâwamazal daɣ jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akf-anaɣ isudar-nana win azalada; ");
INSERT INTO ttq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","tǝssurǝfaɣ-ana tadlǝmt ta nǝga zund ǝmmǝk as nakkanay da nǝssoraf i win danaɣ-ǝdlamnen. ");
INSERT INTO ttq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A dana-wǝr-taga daɣ alɣarar ǝn jarrabatan, kalar agǝz-ana daɣ Iblis, fǝlas taɣmar, ǝd tarna, ǝd tanaya ši-nak har faw. Amin.\"» ");
INSERT INTO ttq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«As tǝsurufam y aytedan arak mazalan win dawan-ǝgan, kawanay da a dawan-issurǝf Abba-nawan wa ihan ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mišan as wǝr tǝsurufam y aytedan, wǝdi Abba-nawan wa ihan ijǝnnawan wǝr dawan-z-issurǝf arak mazalan win tǝgam.» ");
INSERT INTO ttq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«As tǝzumam ad wǝr tǝsǝnnǝfilǝlam tǝkenzert zun awa taggin ǝlmunafiqan, ǝntanay a samattaynen udmawan-nasan fǝl ad ǝssusǝnan aytedan kul as ǝzuman. Ǝggǝyyeɣ ǝsilakanaɣ-awan as aytedan win di, arozan-nasan ǝgrâwan-tan harwa ǝmǝrǝdda. ");
INSERT INTO ttq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kay amaran, as tǝzumaɣ, tǝšširǝdaɣ udǝm-nak, taga alwardi, ");
INSERT INTO ttq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","fǝl ad wǝr ǝssǝnan aytedan as tǝzumaɣ. Abba-nak ɣas a zʼissǝnan daɣ adi, fǝlas illa ǝddi daɣ ǝssir, ihannay awa itaggin, amaran ǝnta a dak-z-irzǝman.» ");
INSERT INTO ttq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ad wǝr tǝšadawam tǝgǝrgist daɣ ǝddǝnet, a daq-qat za tǝhlǝk tamaday ǝd tǝnik, razzan deɣ baydagan inan takaran. ");
INSERT INTO ttq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kalar šidǝwat i man-nawan tǝgǝrgist daɣ jǝnnawan, a daq-qat wǝr za tǝhlǝk tamaday za wala tǝnik, wala deɣ assin-tat-in baydagan win razzinen inan takaran. ");
INSERT INTO ttq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Fǝlas edag wa tǝha tǝgǝrgist-nak, ǝnta a zʼiggǝz ǝwǝl-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Šittawen šilat ǝn fǝtǝla a ǝmosnat i tǝɣǝssa-nak. As imos as šittawen-nak ǝhannaynat s ǝlluɣ, wǝdi taɣǝssa-nak ketnet tǝha ǝnnur. ");
INSERT INTO ttq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mišan as imos as šittawen-nak wǝr ǝhǝnnǝynat s ǝlluɣ, wǝdi taɣǝssa-nak ketnet tǝha šiyyay. Daɣ adi as imos as wala ǝnnur wa ihan taɣǝssa-nak da imos šiyyay, wǝdi ad tǝggǝza šiyyay wǝr nǝmmǝkkan! ");
INSERT INTO ttq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wǝr t-illa i ifrâgan ǝššǝɣǝl y ǝššin muzaran. Wa ɣas ikyad iyyan daɣ-san, iru wa hadan, madeɣ abbardag y iyyan, alku wa hadan. Wǝr tǝfregaɣ ad tǝɣbǝda Mǝššina, tagla deɣ tozâla dǝffǝr ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Daɣ adi ǝnneɣ-awan a kawan wǝr tǝššǝwǝš tǝmǝddurt, gǝr awa za tatšim, wala awa za tašwim, wala awa za talsim. Iman-nawan wǝrgeɣ ogaran imensewan, taɣǝssa-nawan deɣ togar isǝlsa? ");
INSERT INTO ttq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ǝswǝdat daɣ gǝḍad a taggadnen daɣ alhawa, wǝrmad nabbalan za wǝr tilǝyan, wǝr šidiwan wala daɣ tǝdangawen, mišan issodar-tan Abba-nawan wa ihan ijǝnnawan. Kawanay wǝrgeɣ togaram-tan almaqam sen ɣur Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mǝni daɣ-wan wa ifragan s aššawaša-net ǝšitǝy ǝn tǝɣrǝst-net ǝs wala ellaf ǝn šat? ");
INSERT INTO ttq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mafel as kawan-tǝššǝwaš talɣa ǝn sǝlsa? Ǝnẓǝrat-in daɣ ǝmmǝk was du-daggalnat tǝjigawen daɣ ǝsuf. Wǝrmad šaqqalnat wala zattinat isǝlsa, ");
INSERT INTO ttq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","mišan ǝnneɣ-awan, wala Ǝmǝnokal Suliman harkid tǝgǝrgist-net kul, wǝr kala ad ewad wala iyyadda daɣ-asnat daɣ tǝhussay ǝn talassay. ");
INSERT INTO ttq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dad isalsu Mǝššina yel ǝs tǝmǝwit tǝdi, s azalada ibdâd, tufat ad itǝwǝsǝrɣu daɣ tǝjǝngǝrert; manǝmmǝk as kawan-wǝr-z-assalsu, kǝl ǝzǝgzan ǝndǝrran!» ");
INSERT INTO ttq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Daɣ adi ad wǝr tǝššǝwǝšam tǝgannim: \"Ma za natšu?\" Madeɣ: \"Ma za našǝw?\" Madeɣ: \"Ma za nalsu?\" ");
INSERT INTO ttq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aratan win kul aytedan win wǝr nǝssen Mǝššina a ozalnen daɣ agamay-nasan, amaran kawanay Abba-nawan wa ihan ijǝnnawan, issân as tǝddiraram sǝr-san. ");
INSERT INTO ttq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ǝgmǝyat tǝzzar Taɣmar ta n Mǝššina d aqqad dat-ǝs, as iga adi aratan win di kul a kawan-tawǝkfin ǝntanay da. ");
INSERT INTO ttq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Daɣ adi a kay-wǝr-iššǝwǝš arat wa d-izayan tufat, fǝlas tufat ad tǝššǝwǝš ǝd tǝmǝɣutar-net. Ǝzǝl kul ila šimǝɣutar-net a das-ǝgdânen.» ");
INSERT INTO ttq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Igla Ɣaysa iššewal-asan, inna: «Ad wǝr tannim ark arat s awedan fǝl a sǝr-wan wǝr itǝwǝnnu kawanay da. ");
INSERT INTO ttq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Fǝlas ǝmmǝk was tǝxkamam, ǝnta as za tǝtǝwǝxkǝmam kawanay da, amaran tǝsǝkǝt tas tǝkkatam y aytedan, ǝnta as dawan-z-ikǝt Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mafel tahannaya tezawt ta tǝhat šat n amadray-nak, kay amaran wǝr din-tǝgreɣ šilǝlt ta tǝhat šat ta-nak. ");
INSERT INTO ttq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Manǝmmǝk as za tanna y amadray-nak, \"ayy-i a dak-ǝkkǝsa tezawt ta daɣ šat-nak\", kay amaran šilǝlt a tǝhat šat ta-nak? ");
INSERT INTO ttq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ǝlmunafiq, ǝkkǝs tǝzzar šilǝlt ta tǝhat šat-nak, ǝddi ad za tannaflaya daɣ tazawt ta tǝhat šat n amadray-nak tǝkkǝsaɣ-as-tat! ");
INSERT INTO ttq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A din-wǝr-tǝggaraɣ arat zǝddigan madeɣ arat ilân almaqam i maksanan fǝlas wǝr ǝzlayan ǝd dan a kawan-du-milallaynen y a kawan-ǝdǝdan, madeɣ iladayan hallaknen aratan win ǝlanen almaqam. ");
INSERT INTO ttq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ansǝyat Mǝššina, a kawan-akfu; ǝgmǝyat, ad tǝgrǝwam; aɣriwat-tu a dawan-akkawan; ");
INSERT INTO ttq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","fǝlas i onsayan, ad itǝwǝkfu, i igmayan ad igrǝw, i iɣran deɣ Mǝššina a das-akkawan. ");
INSERT INTO ttq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mǝni daɣ-wan wa daɣ zʼigmǝy barar-net tagǝlla akf-ay tǝhunt? ");
INSERT INTO ttq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wala igmǝy daɣ-as isan akf-ay taššolt? ");
INSERT INTO ttq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dad zammas wala kawanay an nǝllubas da tǝssânam tehakkay n awa olaɣan i bararan-nawan, manǝmmǝk as kawan-wǝr-z-akfu Abba-nawan wa ihan ijǝnnawan awa tu-tonsayam? ");
INSERT INTO ttq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Taggiwat y aytedan arat kul was tǝram a dawan-t-agin. Ǝnta da da arat wa ihan ǝššǝriɣa wa n Ǝttawret, d Ǝlkǝttaban n Ǝnnǝbitan. ");
INSERT INTO ttq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ǝggǝzat s ǝmi wa kǝruzan s ǝnta a itawayan ǝs taɣmar ta n Mǝššina! Iket ilwi ig-ay ǝmi wa itawayan s ǝhluk, iket ǝsǝnnǝflǝy tǝg-ay tarrayt ta tǝtawayat s ǝhluk, amaran ǝggǝtan aytedan win as ǝnta as taggazan. ");
INSERT INTO ttq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mišan iket takrazt ig-et ǝmi wa itawayan ǝs tǝmǝddurt, iket deɣ ǝsǝmǝɣitǝr tǝg-ay tarrayt ta tǝtawayat ǝs tǝmǝddurt, amaran wǝr ǝggǝtan aytedan win tan-garrawnen. ");
INSERT INTO ttq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ǝnkǝdat y ǝnnǝbitan win bahu. As kawan-du-tasin ǝmosan zun ayfǝd, mišan ǝs tidǝt iridalan a ǝmosan ǝknanen aššar. ");
INSERT INTO ttq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Arat wa du-saxsalan as tan-za-tǝzdǝyam. Awak alɣanab itâwankad-du daɣ tazzayt? Wala itâwankad-du fig daɣ tǝgaroft? ");
INSERT INTO ttq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ǝmmǝk en daɣ as ašǝk isxân a d-itarawan âratăn olaɣnen, amaran ašǝk wǝr nǝsxa itaraw-du win wǝr noleɣ. ");
INSERT INTO ttq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ašǝk isxân wǝr ifreg ara n âratăn wǝr noleɣ wala deɣ ifrag ašǝk wǝr nǝsxa ara n âratăn olaɣnen. ");
INSERT INTO ttq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ašǝk kul wa wǝr nǝtirǝw âratăn olaɣnen, wǝdi ǝtǝwǝxtas a itawaggu, itǝwǝgǝr daɣ tǝmsay. ");
INSERT INTO ttq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Daɣ adi illikan as ǝnnǝbitan win bahu awa du-saxsalan as tan-za-tǝzdǝyam.» ");
INSERT INTO ttq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Wǝr igda i di-igannin: \"Ǝmǝli, Ǝmǝli!\" Wǝr izzogaz awen awedan Taɣmar ta n jǝnnawan, kalar kundaba i itamazal ǝs tara n Abba-nin ihân ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ǝzǝl wa ilkaman aytedan aggotnen a di-annin: \"Ǝmǝli, Ǝmǝli! Awak wǝrgeɣ esǝm-nak as nǝmal y aytedan isalan win fall-ana du-tǝzazzabbe? Awak wǝrgeɣ ǝnta ǝs nǝstaɣ kǝlǝsuf? Nǝga sǝr-ǝs tǝlmǝɣjujaten aggotnen?\" ");
INSERT INTO ttq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ǝddi a dasan-anna: \"Wǝr kala a kawan-ǝzdayaɣ. Ugagat-i inǝmmǝzray ǝn Mǝššina!\"» ");
INSERT INTO ttq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Daɣ adi awedan kul wa issǝsaman y awal-in wa, immozal-tu, wǝdi iha ǝlmital n alǝs n ǝmǝli ǝn tayttay ikrasan ehan-net fǝl tǝsǝlit. ");
INSERT INTO ttq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iwat akonak, ǝgan ǝngǝytan ǝssohatnen, ǝgarnat-du tǝzǝkwen, ǝstaban y ahan en, mišan wǝr uda fǝlas tǝsǝlit a fǝl ibna. ");
INSERT INTO ttq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amaran awedan kul wa issǝsaman y awal wa ǝge da, iqqim wǝr t-immozal, wǝdi iha ǝlmital n alǝs wǝr nǝla tayttay, ikrasan ehan-net fǝl ǝzazǝl. ");
INSERT INTO ttq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iwat akonak, ǝgan ǝngǝytan ǝssohatnen, ǝgarnat-du tǝzǝkwen, istab awen y ahan wa nad, ibarajjat, ilyam-in ketnet.» ");
INSERT INTO ttq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","As iɣrad Ɣaysa alfaydaten šin, tǝqqim tamattay isimaklal sǝr-ǝs ǝmmǝk was itaggu ǝsǝssǝɣri-net. ");
INSERT INTO ttq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Fǝlas ig-asan ǝsǝssǝɣri n awedan ilân tanaya wǝr ǝlen musanan-nasan win Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","As d-izzǝbbat Ɣaysa adɣaɣ wen, tǝlkâm-as tamattay tagget. ");
INSERT INTO ttq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ihin-in Ihoz-t-idu awedan tǝgrâw tǝwǝrna ǝn kǝtru, issǝjad dat-ǝs, inna: «Ǝmǝli, as tareɣ adi tǝfrâgaɣ a di-tǝzzuzǝyaɣ, izdaga.» ");
INSERT INTO ttq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Izzal-in Ɣaysa ǝfus-net, idas-tu inna: «Areɣ adi ǝzzǝy tizdaga!» Amazay wen da daɣ izzay alǝs wen daɣ kǝtru, zǝddig. ");
INSERT INTO ttq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Inn-as Ɣaysa: «Ǝnǝy za, ad wǝr tǝmǝla y awedan waliyyan arat wa igan da, amaran aglu tassaknaɣ iman-nak y ǝlimam, taga takutay ta kay-issǝwar ǝššǝriɣa n ǝnnǝbi Musa, ad iqqəl adi y aytedan tǝgǝyya ən təməzzəyt-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Amazay wa da daɣ in-itaggaz Ɣaysa taɣrǝmt ǝn Kafarnahum, ǝnta daɣ t-in-ikka kabtan iyyan ǝn sojitan n Ǝrrum, onsay-tu, ");
INSERT INTO ttq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","inn-as: «Ǝmǝli, amaššaɣal-in a din-oyye isrâd daɣ aɣaywan, ibdân, idgâz wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Inn-as Ɣaysa: «Nak iman-in a tu-z-akkin ǝzzuzǝyaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Inn-as kabtan en: «Ǝmǝli, nak wǝr ǝwedaɣ ad tǝggǝzaɣ ehan-in. Annu arat ɣas ad izzǝy amaššaɣal-in. ");
INSERT INTO ttq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ǝssâna daɣ adi fǝlas awedan a ǝmosaɣ a daɣ ǝttafan wiyyad tanat, ǝttâfaq-qat nak iman-in daɣ sojitan win daw-i ǝllanen. As ǝnneɣ y iyyan: \"Aglu\", ad aglu, as ǝnneɣ y iyyan: \"Iyyaw\", a di-d-asu. As ǝnneɣ y ǝkli-nin: \"agu awa\", ad t-agu.» ");
INSERT INTO ttq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","As isla Ɣaysa y awa inna kabtan en, isammaklal sǝr-ǝs, inna y aytedan win das-ǝlkamnen: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as: wǝr ǝnayaɣ awedan waliyyan daɣ Kǝl-Israyil igân ǝzǝgzan ewâdan wa iga alǝs a.» ");
INSERT INTO ttq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","«Ǝsilakanaɣ-awan as aytedan aggotnen a d-ǝfǝlan dǝnnǝg d ataram, nǝɣimin d Ibrahim, d Isǝhaq, ǝd Yaqub, ǝdrǝwan dǝr-san imǝgura daɣ Taɣmar ta n jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mišan Kǝl-Ǝlyǝhud aggotnen s ǝntanay as tǝtawasamatag Taɣmar ta, win di a din-tǝwǝbdǝɣan sǝdi daɣ šiyyay, ad hallin ǝddadan idǝdwan-nasan fǝl tǝmagraz.» ");
INSERT INTO ttq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amaran inna Ɣaysa i kabtan wa nad: «Ǝqqǝl aɣaywan-nak, aget-ak Mǝššina arat wa daɣ-as tǝgmaya fǝl ǝzǝgzan-nak.» Tǝzzar izzay amaššaɣal ǝn kabtan wen daɣ amazay wen da. ");
INSERT INTO ttq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dǝffǝr adi ikka Ɣaysa ehan ǝn Butros. Inay tǝdaggalt ǝn Butros tǝsrâd, tǝnnid, ");
INSERT INTO ttq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","idas ǝfus-net, təwat fall-as tanaday, tǝnkar-du a tu-tǝsimǝgurit. ");
INSERT INTO ttq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","As tuda tǝfuk, ǝmmewayan-as-du aytedan aggotnen ǝssiranan kǝlǝsuf. Iɣrad Ɣaysa asataɣ ǝn kǝlǝsuf winad ǝs tǝfert iyyadda. Izzozay deɣ imiranan kul win ǝllanen den. ");
INSERT INTO ttq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ǝmmǝk wen daɣ as inda awal wa d-iga Ǝmǝli ǝs tarrayt n ǝnnǝbi Isayas a daɣ innâ: «Ǝnta a idkalan ǝlɣiban-nana, idkal fǝl iri-net šiwǝrnawen-nana.» ");
INSERT INTO ttq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","As inay Ɣaysa tamattay tǝɣilayɣalay-tu, omar inǝttulab-net s a dǝr-ǝs idawan ǝɣrǝsan ǝs tagadamayt ta hadat n agaraw. ");
INSERT INTO ttq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikk-ay-du ǝmusan n Ǝttawret iyyan inn-as: «Ǝššex, a dak-ǝlkǝmaɣ s adag kul wa tǝkkeɣ.» ");
INSERT INTO ttq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Inn-as Ɣaysa: «Izagazan ǝlân enwan, igǝḍad deɣ ǝlân šisǝllula, mišan nak Ag Aggadǝm wǝr ǝleɣ wala edag a daɣ ǝssǝnsaɣ eɣaf-in.» ");
INSERT INTO ttq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inn-as ǝnalkim-net iyyan: «Ǝmǝli, akf-i turagat n ad agla har din-ǝnbǝlaɣ abba-nin tǝzzar.» ");
INSERT INTO ttq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mišan inn-as Ɣaysa: «Ǝlkǝm-i tayyaɣ inǝmmǝttan ad ǝnbǝlan inǝmmǝttan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dǝffǝr adi iggaz Ɣaysa aɣlal n aman, ǝnta ǝd nǝttulab-net, ǝglan. ");
INSERT INTO ttq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wala a ihogan tǝgar-du tazafa labasat fǝl agaraw, ad ǝggatnat tǝnazzamaren aɣlal. As itaggu awen Ɣaysa ǝnta insâ. ");
INSERT INTO ttq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ǝhozan-t-in nǝttulab-net, a tu-sankaran daɣ etǝs gannin-as: «Ǝmǝli, agǝz-ana! Nakkanay nǝjwâr nǝhlâk!» ");
INSERT INTO ttq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Inn-asan: «Mafel tǝh-iwan tasa togdat d awa, kǝl ǝzǝgzan irkaman?» Inkar-du Ɣaysa, isannarɣam y aḍu d agaraw, ǝɣradan adrur d ǝsǝssǝmmi. ");
INSERT INTO ttq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Arat wa iqqan iɣafawan-nasan, ad gannin: «Ma imos wa daɣ awedan, as wala aḍu d agaraw da ittâf daɣ-san tanat.» ");
INSERT INTO ttq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","As iwar Ɣaysa aganna wa hadan n agaraw, daɣ akal ǝn Gadaratan, ǝssǝlkadan-as-du ǝššin aytedan ǝssiranan kǝlǝsuf, ǝgmadan-du sǝr-ǝs izǝkwan. Aytedan win awa ǝgan daɣ tallabǝst, wǝr t-illa i ihalan a d-akǝy daɣ adag wen. ");
INSERT INTO ttq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Saɣaren-as-du gannin: «Ma daɣ-na tare, Barar ǝn Mǝššina? Awak assa du-tǝge y a dana-tǝsǝkkǝrure da wǝr du-tewed tǝmastant?» ");
INSERT INTO ttq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ǝnta illât-tu ǝsǝgǝn aggen ǝn ladayan ǝdânnen daɣ igǝg-nasan dên, ");
INSERT INTO ttq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","onsayan kǝlǝsuf win Ɣaysa ǝnnan-as: «As dana-tǝstaɣa, tǝssukaɣ-anaɣ ǝsǝgǝn en ǝn ladayan en.» ");
INSERT INTO ttq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Inn-asan: «Aglat!» Tǝzzar ǝgmadan kǝlǝsuf meddan win ǝššin en, ǝkkan iladayan ǝggazan-tan. Amazay wen da daɣ d-ǝwafan ladayan win den kul fǝl azadaga ǝn təkašwart, ɣartattawan ad tifataqqen daɣ agaraw, ǝlammazan-tan aman. ");
INSERT INTO ttq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tǝzzar ozalan madanan ǝn ladayan winad s ǝɣrǝm, ǝssoɣalan arat kul wa igan den y aytedan, d awa igan fǝl meddan win ǝssǝranan kǝlǝsuf en. ");
INSERT INTO ttq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Den daɣ a d-ǝɣradan kǝl ǝɣrǝm wen agamad, ǝssǝlkadan-du i Ɣaysa, onsayan-tu ad igmǝd akal-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tǝzzar iggaz Ɣaysa aɣlal n aman, iɣras agaraw, ikka taɣrǝmt-net Kafarnahum. ");
INSERT INTO ttq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ewayan-as-du aytedan anabdon ihân tǝssut-net. As inay Ɣaysa ǝzǝgzan-nasan, inna y anabdon: «A kay wǝr iššǝwǝš wala barar-in! Ibakkadan-nak tiwasarafan-ak!» ");
INSERT INTO ttq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tǝzzar ǝnnan arat daɣ musanan n Ǝttawret wiyyad daɣ man-nasan: «Alǝs wa ǝmadraw a itaggu!» ");
INSERT INTO ttq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Inn-asan Ɣaysa issânan daɣ awa samadranan: «Mafel tǝtaggim arak medranan win daɣ wallan-nawan? ");
INSERT INTO ttq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Awak ma ogaran tǝrɣǝsay gǝr i innan: \"Ibakkadan-nak tiwasarafan-ak\", meɣ ak i innan: \"Ǝbdǝd jǝwǝnkǝt?\" ");
INSERT INTO ttq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amaran areɣ ad tǝssǝnam as nak Ag Aggadǝm, ǝleɣ daɣ ǝddǝnet tanaya a di-tǝšišawadat ad ǝssurǝfa y awedan ibakkadan-net.» Tǝzzar inna Ɣaysa y anabdon: «Ǝbdǝd, tǝdkǝla tǝssut-nak takkaɣ aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ibdad alǝs wen ikka aɣaywan-net. ");
INSERT INTO ttq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","As ǝnayat tamattiwen arat wen, tǝɣrad-tanat tasa iguz, ad tagginat tǝmmalen i Mǝššina a ikfan tarna togdat d awen y aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ifal Ɣaysa edag wen, illam-du dagma n alǝs iyyan igân esǝm Matta, iqqiman daɣ adag wa n ǝzǝrzǝm n ǝzrǝf wa n takǝs, inn-as: «Ǝlkǝm-i!» Tǝzzar ibdad Matta ilkam-as. ");
INSERT INTO ttq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ǝzǝl iyyan, iha Ɣaysa aɣaywan ǝn Matta, ǝnta d aytedan aggotnen ǝn nǝzzǝrzam ǝn takǝsen ǝd nasbakkadan, idrâw dǝr-san imensewan ǝnta ǝd nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ǝnayan Farisaytan arat wa, ǝnnan i nǝttulab-net: «Mafel idrâw ǝššex-nawan ǝd nǝzzǝrzam ǝn takǝsen ǝd nasbakkadan?» ");
INSERT INTO ttq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isl-asan Ɣaysa, inna: «Aytedan win wǝr nǝla ǝɣǝli, wǝr ǝddǝraran s anasmagal, imiranan a sǝr-ǝs ǝddǝrarnen. ");
INSERT INTO ttq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Agliwat tǝssǝnam almaɣna ǝn batu ta iga Mǝššina as inna: \"Tǝhanint a are, wǝrgeɣ šikutawen.\" Wǝr d-oseɣ fǝl a d-aɣraɣ aytedan win ɣur iga as oɣâdan, kalar inasbakkadan as d-ǝmmozala y a tan-d-aɣra ǝqqǝlan inalkiman-in.» ");
INSERT INTO ttq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tǝzzar ǝkkan-in nǝttulab ǝn Yaxya Ɣaysa ǝnnan-as: «Mafel nakkanay ǝd Farisaytan nǝtuzam faw, amaran kay inǝttulab-nak wǝr tuzaman?» ");
INSERT INTO ttq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ijjǝwwab-asan Ɣaysa inn-asan: «Ak ilagatan a ɣur illa amazlay zakanzaran? Mišan ǝlkâman adan a ɣur-san zʼammadkal ǝmazlay: ǝddi amaran ad zʼuzaman. ");
INSERT INTO ttq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wǝr t-illa i zʼiwǝtan šikǝst taynayat daɣ tabdoq waššarat, fǝlas ǝddi šikǝst ta din-tǝttǝwatat, a du-tǝzǝkkǝwǝnzǝz tabdoq ta waššarat, tǝzzar tǝššit-as azarru wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wǝr t-illa deɣ i zʼagin esmad n alɣanab aynayan daɣ gǝdad, fǝlas as iga adi, ad abbaqqen gǝdad win, tǝzzar affatu daɣ esmad ǝd gǝdad. Kalar arat wa ihoran, ad itǝwǝggu esmad wa aynayan daɣ bǝyaɣ aynaynen, ǝmmǝk wǝdi daɣ as zʼiɣlǝs esmad harkid bǝyaɣ.» ");
INSERT INTO ttq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iššewal-asan Ɣaysa den daɣ as d-osa iyyan daɣ muzaran ǝn Kǝl-Ǝlyǝhud, issǝjad dat-ǝs, inn-as: «Tǝbarart-in a aba ǝmǝrǝdda, mišan ya, ǝssanaɣ âs as du-tose tǝssǝwǝraq-qat ǝfus-nak, a du-tǝnkǝr.» ");
INSERT INTO ttq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tǝzzar inkar-du Ɣaysa, ilkam-as, ǝddewan dǝr-ǝs nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tǝllat-tu tǝntut tǝgat maraw elan d ǝššin igammad-tat ǝzni, tǝhoz-du Ɣaysa sa sǝr tǝɣǝrden, tǝdas tǝbǝnik ǝn tǝkadkat-net, ");
INSERT INTO ttq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","fǝlas tǝnna a tǝga daɣ man-net: «Igda ɣas ad ǝdǝsa tǝkadkat-net, ad ǝzzǝya.» ");
INSERT INTO ttq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Imalallay-in Ɣaysa inay-tat, inn-as: «Ad wǝr tǝɣšǝda tǝbarart-in! Ǝzǝgzan-nam sǝr-i a kam-izzozayan.» Amazay wen da daɣ tǝzzay tǝntut ten. ");
INSERT INTO ttq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dǝffǝr awen ikka Ɣaysa ehan n ǝmuzar ǝn Kǝl-Ǝlyǝhud wanad. As din-ewad Ɣaysa, inay imawatan ǝn tǝsǝnsaɣ šin tǝfǝyyawt, d aytedan nijarwaynen, ǝgân tǝrmuq. ");
INSERT INTO ttq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Inna: «Awedan kul irdǝɣet! Tǝbarart di wǝr tat-aba, etǝs ɣas a tǝga!» Tǝzzar ǝgan-tu ajjab. ");
INSERT INTO ttq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","As tǝtawasardaɣ tamattay ten, iggaz Ɣaysa ehan wa tǝha tǝbarart ta aba, obaz ǝfus-net, issǝnkar-tat-du. ");
INSERT INTO ttq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wazawazan salan n awa igan den, daɣ akal ketnet. ");
INSERT INTO ttq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","As ifal Ɣaysa edag wen, ǝlkâman-as ǝššin mǝddǝrɣal, saɣaren gannin: «Ya Ag ǝnnǝbi Dawǝd! Hǝnǝttǝt-ana!» ");
INSERT INTO ttq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","As din-ewad aɣaywan, iggaz ehan, ǝhozan-t-in mǝddǝrɣal win den, inn-asan: «Tǝzzigzanam as ǝfragaɣ igi n arat wa tǝram ǝddi?» Ǝnnan-as: «Awalla, Ǝmǝli.» ");
INSERT INTO ttq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tǝzzar idas šittawen-nasan, igannu: «Itǝwǝggiwet-awan arat wa inamannakan d ǝzǝgzan-nawan.» ");
INSERT INTO ttq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Den daɣ ad ǝgrawan asawad-nasan. Ig-asan Ɣaysa tarɣǝmt tǝssohet, inn-asan: «Ǝnkǝdat y ad issǝn a imosan awedan daɣ awa dawan-ǝge da.» ");
INSERT INTO ttq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mišan as ǝglan, ǝzǝwwazawazan isalan-net daɣ akal ketnet. ");
INSERT INTO ttq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ǝfalan Ɣaysa ɣas immeway-du sǝr-ǝs awedan as immidad ǝmi-net, id aggǝsuf a t-izdaɣan. ");
INSERT INTO ttq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ikkas Ɣaysa aggǝsuf wen ɣas, iggaz awedan was immǝdad ǝmi-net den šin awal. Isimaklal awen ǝs tamattay, ad tǝgannu: «Arat wa wǝr kala tǝtawanay tulat-net daɣ Israyil!» ");
INSERT INTO ttq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farisaytan amaran ǝntanay gannin: «Ǝmǝnokal ǝn kǝlǝsuf a t-ikfan fǝrregat n ikus ǝn kǝlǝsuf daɣ aytedan.» ");
INSERT INTO ttq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Illil Ɣaysa iɣǝrman ǝd tǝɣarmaten kul, isasaɣru daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, itaggu isalan n Ǝlinjil imosan isalan ǝn Taɣmar ta n Mǝššina, izuzǝy deɣ aytedan daɣ ǝzzǝnǝfan kul ǝn tǝwǝrnawen d ǝlɣiban. ");
INSERT INTO ttq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","As inay tamattay, tǝggaz-tu tǝhanint-net, fǝlas arkanay a ǝnnayan, tiwayyan ǝd man-nasan, ǝmosan zun ayfǝd wǝr nǝla amadan. ");
INSERT INTO ttq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tǝzzar inna i nǝttulab-net: «Ɣarat tǝggǝt, mišan wǝr ǝggǝtan maššaɣalan win tat-z-alǝynen. ");
INSERT INTO ttq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Daɣ adi ǝttǝrat s esǝm ǝn mǝššis ǝn ɣarat ta, a d-assaglu imaššaɣalan a tat-olaynen.» ");
INSERT INTO ttq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iɣra-du Ɣaysa ǝs man-net inǝttulab-net win maraw d ǝššin, ikf-en tarna n ikus ǝn kǝlǝsuf daɣ aytedan, d ǝzuzǝy n a tǝqqal tǝwǝrna, d a iqqal ǝlɣib. ");
INSERT INTO ttq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ǝntanay da esmawan ǝn nǝmmuzal win maraw d ǝššin: Wa azzaran esǝm-net Simɣon, itawann-as Butros, d Andrawǝs wa n amadray-net, ǝd Yaqub wa n ag Zabaday, ǝd Yaxya wa n amadray-net, ");
INSERT INTO ttq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ǝd Filibus, ǝd Bartulamawǝs, ǝd Tuma, ǝd Matta wa izarzaman takǝsen, ǝd Yaqub wa n ag Alfay, ǝd Tadday, ");
INSERT INTO ttq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ǝd Simɣon was itawannu wa Isaggatakken, ǝd Yahuza was itawannu Isxarǝyuti s ǝnta a zʼagin Ɣaysa daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ǝntanay da da maraw nǝttulab d ǝššin win izammazal Ɣaysa dǝffǝr as tan-omâr inn-asan: «Ad wǝr tǝtakkim aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud, wala deɣ tǝggǝzam aɣrǝm waliyyan ǝn Kǝl-Samarǝya. ");
INSERT INTO ttq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kalar akkiwat Kǝl-Israyil, win ǝmosnen zun ayfǝd ǝssiggalnen. ");
INSERT INTO ttq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Agliwat a dasan-tǝtaggim isalan n âs Taɣmar ta n jǝnnawan tǝhôz-du. ");
INSERT INTO ttq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zuzǝyat imiranan, a du-tǝsankaram inǝmmǝttan, tǝzzuzǝyam aytedan win igraw kǝtru, tǝzzǝzdǝgam-tan, ad tǝtâkkasam kǝlǝsuf daɣ aytedan. Bannan as tǝtawakfam, daɣ adi kawanay da hakkiwat bannan. ");
INSERT INTO ttq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ad wǝr tǝtawayam urǝɣ, wala azrǝf, wala deɣ a tǝqqǝl tafelt daɣ nǝfdan-nawan, ");
INSERT INTO ttq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","wala deɣ aɣrǝg daɣ ǝšikǝl-nawan, wala tǝkadkat ta n sanatat, wala tǝsǝsǝlt ta n sanatat, wala tallaq. Ǝssǝnat as edag tosam ad tǝtǝwǝsǝmǝgurem fǝlas imaššaɣalan-in a tǝmosam, amaran amaššaɣal kul ila alxaq n ad igrǝw a itša. ");
INSERT INTO ttq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","As du-tǝggazam aɣrǝm, madeɣ taɣrǝmt, tǝgmǝyam awedan wa inahaggan d a ɣur-ǝs tǝssǝgǝnam, taqqamim ɣur awedan wǝdi da har assaɣa a daɣ tǝgmadam aɣrǝm wǝdi. ");
INSERT INTO ttq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","As du-tǝggazam ehan tannim: \"Alxer fall-awan!\" ");
INSERT INTO ttq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kud aytedan n ahan wǝdi nihaggan d a ɣur-san tǝssǝgǝnam, wǝdi tǝwatray n alxer ta dasan-tǝgam a fall-asan tǝqbǝl, mišan as wǝr nahaggan d a ɣur-san tǝssǝganam, wǝdi tǝwatray ten wǝr za tǝqbel fall-asan. ");
INSERT INTO ttq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","As wǝr tǝtawaqbalam, wǝr itawasasam deɣ i batu-nawan daɣ ǝɣrǝm wǝdi, made daɣ aɣaywan wǝdi, tǝgmadam-tu, tabbakbakam-in ǝgodrar-net wa iwaran idaran-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ǝggǝyyeɣ ǝsilakanaɣ-awan as, ǝzǝl wa n tabadday, aytedan n ǝɣrǝm wǝdi, ad agin alɣazab ogaran wa zʼagin win amaḍal ǝn Sǝdom ǝd Gamora.» ");
INSERT INTO ttq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ǝssǝnat as zimazalaq-qawan tǝmosam zun ayfǝd ǝhânen ammas ǝn ridalan, daɣ adi iliwat tayttay tagim ǝnnǝyat zun awa tagginat taššolen, talim ǝd tǝdǝbren a wǝr iwer a imosan lahan. ");
INSERT INTO ttq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ǝnkǝdat y aytedan, fǝlas a kawan-ǝssǝbdǝdan dat saggawaran n ǝššǝriɣa, a kawan-ǝggatan ǝs lǝkkad daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ad tǝtǝwǝsǝbdǝdam dat naxkiman ǝd mǝnokalan fǝlas kawan-iwar esǝm-in, tǝqqǝlam šiggǝyyawen-in y-asan ǝntanay d aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mišan assaɣa wad za tǝtǝwǝggim daɣ fassan, a kawan-wǝr-iššǝwǝš ǝmmǝk was za tǝššiwǝlam, wala deɣ awa za tannim, fǝlas arat wa za tannim a fall-awan d-azzabbat daɣ amazay wa da daɣ tǝram tǝnna-net, ");
INSERT INTO ttq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","id wǝrge kawanay a zʼiššǝwǝlnen, kalar Infas wa Zǝddigan n Abba-nawan, a daɣ-wan išawalan. ");
INSERT INTO ttq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ad sǝttǝrmǝsan aytedan imǝdrayan-nasan sǝssugin iman-nasan, sǝttǝrmasan abbatan bararan-nasan sǝssugin iman-nasan, affallagan bararan fǝl marwan-nasan sǝssugin iman-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Awedan kul a kawan-igzǝr fǝlas kawan-iwar esǝm-in, mišan wa daɣ-wan izmaran har tǝzǝrǝst, wǝdi ad iɣlǝs. ");
INSERT INTO ttq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","As tǝtawasasam daɣ ǝɣrǝm taddarragam s iyyan. Ǝggǝyyeɣ ǝsilakanaɣ-awan as wǝr du-za-tǝɣrǝdam iɣǝrman n Israyil harwa da as du-z-ǝqqǝla nak Ag Aggadǝm.» ");
INSERT INTO ttq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Attalami wǝr oger ǝššex-net, wala deɣ ogar ǝkli mǝššis. ");
INSERT INTO ttq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Igda y attalami ad agdu d ǝššex-net, akli deɣ igd-as ad agdu ǝd mǝššis. Dad zamas ǝmuzar n aɣaywan ǝgan-as esǝm Aššaytan ǝn Baɣalzabul, manǝmmǝk as wǝr zʼagin arak batuten i kǝl aɣaywan-net?» ");
INSERT INTO ttq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Daɣ adi a tan-wǝr-tiksadam. Arat kul wa iɣbaran ad itǝwǝsǝnǝfilǝl, amaran ǝssir kul ad affaggu. ");
INSERT INTO ttq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Arat wa dawan-ǝnne daɣ šiyyay, anniwat-tu ezal a mallan. Amaran arat kul wa dawan-itawasataktakan anniwat-tu s afalla. ");
INSERT INTO ttq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ad wǝr tiksadam win naqqinen taɣǝssa n awedan ɣas, amaran wǝr ǝfregan aɣšud ǝn wala i man-net. Kalar iksadat Mǝššina a ifragan ahluk ǝn tǝɣǝssa harkid man, aggadl-en daɣ Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Awak wǝrgeɣ ǝššin gǝḍad tefelt iyyadda a nazzan? Dǝr iga awen da za, wǝr tan-iha i zʼǝgmǝdan man ar ǝs turagat n Abba-nawan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kawanay amaran wala anzadan ǝn ɣafawan-nawan da kul ǝḍḍunan. ");
INSERT INTO ttq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Daɣ adi ad wǝr tiksadam wala, fǝlas ɣur Mǝššina togaram igǝḍad ǝlqimat!» ");
INSERT INTO ttq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Awedan kul wa iggǝyyen dat aytedan as nak a t-ilan, wǝdi nak da a fall-as aggayyeɣ dat Abba-nin ihan ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mišan wa di-inkuran dat aytedan, wǝdi nak da ad t-unkaraɣ dat Abba-nin ihan ijǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ad wǝr tǝɣilam assa a d-ǝgeɣ ewâya-du alxer s ǝddǝnet: kala kala wǝr d-ewayaɣ alxer, ǝmǝgǝr a d-ewaya. ");
INSERT INTO ttq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ose-du y ad zǝnnǝmǝzrǝyaɣ alǝs d abba-net, zǝnnǝmǝzrǝya tǝbarart d anna-net, zǝnnǝmǝzrǝya deɣ tǝdaggalt ǝd tǝntut ǝn barar-net, ");
INSERT INTO ttq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ǝqqǝlan kǝl aɣaywan n awedan izǝnga-net. ");
INSERT INTO ttq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","I igan y abba-net madeɣ anna-net tara togarat ta di-iga, wǝdi wǝr ihor ǝd tišit n ǝnalkim-in. I igan i barar-net madeɣ tǝbarart-net tara togarat ta di-iga, wǝdi wǝr ihor ǝd tišit n ǝnalkim-in. ");
INSERT INTO ttq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","I wǝr nǝdkel tǝgǝttawt-net, agu imateran-net, ilkǝm-i, wǝdi wǝr ihor ǝd tišit n ǝnalkim-in. ");
INSERT INTO ttq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Awedan wa wǝr nǝkǝttǝw ar iman-net daɣ ǝddǝnet ta, wǝdi ad affatu daɣ alaxirat. Amaran wa iqbalan ad isaffatu iman-net daɣ ǝddǝnet ta fǝl ǝddǝlil-in, wǝdi a tan-igrǝw.» ");
INSERT INTO ttq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«I dawan-igan isǝxlak, wǝdi nak as tan-iga, amaran i di-tan-igan, wǝdi wa di-d-izammazalan as tan-iga. ");
INSERT INTO ttq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","I igan isǝxlak y ǝnnǝbi ǝn Mǝššina fǝl tišit-net ǝnnǝbi, wǝdi ad igrǝw arozan win igarraw ǝnnǝbi. Amaran i igan isǝxlak y alɣadil ǝn Mǝššina, fǝl ǝddǝlil ǝn tǝlɣudǝla-net, wǝdi ad igrǝw arozan win igarraw alɣadil. ");
INSERT INTO ttq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ǝggǝyyeɣ ǝsilakanaɣ-awan as, i iššǝšwan wala ablu n aman sammodnen y iyyan daɣ nalkiman-in win ogarnen tǝmmǝdrǝyt, fǝlas imos ǝnalkim-in, wǝdi illikan as ad igrǝw arozan-net.» ");
INSERT INTO ttq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","As iɣrad Ɣaysa ammar ǝn nǝttulab-net win maraw d ǝššin, ifal edag wen, ad isasaɣru itaggu tǝlxutbat daɣ ɣǝrman win ǝhanen akal wen. ");
INSERT INTO ttq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaxya wa isalmaɣan aytedan daɣ aman, iha kasaw as isla awa itaggu Ǝlmǝsix, izammazal-du sǝr-ǝs arat daɣ attalamitan-net, ");
INSERT INTO ttq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","y ad t-ǝssǝstǝnan annin-as: «Ak kay a imosan was nǝqqǝl y a d-asu, meɣ ak ad nǝqqǝl y iyyan?» ");
INSERT INTO ttq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ijjǝwwab-asan Ɣaysa inn-asan: «Ǝqqǝlat Yaxya tǝssuɣǝlam-as awas tǝsallim, d awa tǝhannayam, tannim-as: ");
INSERT INTO ttq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Imǝddǝrɣal ǝhannayan, inǝbdan jawanken, aytedan win igraw kǝtru ǝzzayan zaddogan, imzagan ǝgrawan tesalay, inǝmmǝttan nakkaran-du daɣ tǝmattant, šilǝqqawen deɣ sallanat y Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ibbilal awedan wa wǝr igmed ǝzǝgzan-net fǝlas wǝr iga aššak daɣ awa ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","As ǝglan attalamitan ǝn Yaxya, issǝnta Ɣaysa amagrad i tamattay daɣ batu ǝn Yaxya, inn-asan: «Ma imos arat was tǝkkam ǝsuf y a tu-tǝnǝyam? Awak telant isiwǝliwil aḍu? Kala! ");
INSERT INTO ttq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Daɣ adi ma imos wa tǝkkam y a t-id-tǝnǝyam? Awak alǝs ilsân tabdoq tǝknat šihussay? Kala! Ǝnǝyat za, aytedan win ǝqqannen šibǝddaɣ šin hossaynen, win di inan ǝn mǝnokalan a ǝhan. ");
INSERT INTO ttq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Adi za ma tǝkkam y a t-id-tǝnǝyam? Awak ǝnnǝbi? Wǝllen zʼâs ǝnnǝbi. Amaran Yaxya ogar tišit n ǝnnǝbi fadda. ");
INSERT INTO ttq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Fǝlas Yaxya ǝnta a fǝl ǝnnan Ǝlkǝttaban: \"Ǝnǝy za nak a dat-ǝk assaglaɣ anammazul-in a zʼaknin tarrayt-nak.\" ");
INSERT INTO ttq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ǝggǝyyeɣ ǝsilakanaɣ-awan as wǝr kala a d-ihǝw awedan ogaran Yaxya wa isalmaɣan daɣ aman. Dǝr iga awen da wala ɣas wa ogaran tǝmmǝdrǝyt daɣ Taɣmar ta n jǝnnawan, da ogar Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A d-obazan ɣur adan win daɣ itaggu Yaxya wa isalmaɣan daɣ aman tǝlxutbat, har harwa da, Taɣmar ta n jǝnnawan tǝmiqqas ǝd tallabǝst tǝssohet, gammayan kǝl ǝššur d abbaz-net. ");
INSERT INTO ttq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amaran Ǝlkǝttaban n Ǝnnǝbitan kul d Ǝttawret, ǝmâlan Taɣmar ta n Mǝššina, har azzaman ǝn Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kud tǝqbâlam awa dawan-ǝnneɣ ǝddi, wǝdi ǝssǝnat as Yaxya, ǝnta a imosan Ilyas was ittǝmal assa-net. ");
INSERT INTO ttq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wa isallin, issǝsǝmet!» ");
INSERT INTO ttq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Mas zʼammattalaɣ aytedan n azzaman win nǝha da? Olân ǝd bararan ǝqqimnen daɣ ǝssuk, saɣaren i midawan-nasan, ");
INSERT INTO ttq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","gannin-asan: Nǝwat-awan tende, mišan wǝr tǝweɣam! Nǝg-awan isakkan ǝn tǝfǝyyawt, mišan wǝr tǝlem! ");
INSERT INTO ttq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ǝnneɣ-awan adi fǝlas Yaxya osa-du, wǝrmad itattu za wǝr isǝssu, tǝzzar ǝnnan aytedan: Aljayn a t-izdaɣan. ");
INSERT INTO ttq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amaran, nak Ag Aggadǝm, ose-du ǝtatta ǝsassa, mišan ǝnnan aytedan: \"Ǝnawat alǝs wen n amawwalay en, isassin esmad s igǝt, imos ǝmidi ǝn nabazan ǝn takǝsen d ark aytedan!\" Masnat ta du-tǝfalat Mǝššina amaran, imazalan n aytedan win ǝhanen tarrayt ta n Mǝššina a sataddinen aqqad-net.» ");
INSERT INTO ttq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tǝzzar issoɣal Ɣaysa tǝgna labasat i ɣǝrman win daɣ ǝganat taššam ǝn tǝlmǝɣjujaten, id tǝtubt a wǝr ǝgen. ");
INSERT INTO ttq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Inna: «Iket alɣazab iqqâl-awan kǝl-aɣrǝm ǝn Koradzin! Iket alɣazab iqqâl-awan kǝl-ǝɣrǝm ǝn Betsayda! Fǝlas tǝlmǝɣjujaten šin ɣur-wan ǝganen ǝnnar ǝgânat daɣ ǝɣrǝm ǝn Tir ǝd wa n Sidon, wǝdi irǝw as ǝqqanan isǝlsa ǝn bǝhu ǝqqiman daɣ eẓǝd, imos awen ǝsǝnnǝfilǝl n as ǝhdăn. ");
INSERT INTO ttq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Awen daɣ a fǝlas ǝnneɣ-awan: Alɣazab wa za tagim ǝzǝl wa n tabadday ad agǝr wa zʼagin aytedan n ǝɣrǝm ǝn Tir ǝd wa n Sidon. ");
INSERT INTO ttq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kawanay aytedan n ǝɣrǝm wa n Kafarnahum, adis ad tammadkalam s aljannat? Kalar Jahannama a daɣ za tǝtǝwǝgaram, fǝlas tǝlmǝɣjujaten šin ɣur-wan ǝganen âs ǝnnar ǝgânat daɣ ǝɣrǝm ǝn Sǝdom, wǝdi har azalada ill-ay. ");
INSERT INTO ttq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Awen daɣ a fǝlas ǝnneɣ-awan: Alɣazab wa za tagim ǝzǝl wa n tabadday ad agǝr wa zʼagin aytedan n akal ǝn Sǝdom.» ");
INSERT INTO ttq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Igla Ɣaysa iššêwal inna: «Ǝgeɣ-ak tǝmmalen ya Abba, Ǝmǝli ǝn jǝnnawan d amaḍal fǝl aɣabar wa tǝgeɣ aratan win i musanan, ǝd malan ǝn tayttay, tǝsannafalalaq-qan y aytedan win wǝr nǝzlay ǝd bararan; ");
INSERT INTO ttq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","id adi da a imosan agna-nak ya Abba!» ");
INSERT INTO ttq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Arat kul ig-ay Abba-nin daɣ ǝfus-in, wǝr t-illa i issanan awa ǝmosa ar Abba, wǝr t-illa deɣ i issanan awa imos Abba ar nak an Barar-net d awedan was areɣ a das-tu-sǝnnǝfilǝla. ");
INSERT INTO ttq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Akkiwat-i-du ketnawan win ǝddaznen, ewayan ǝzuk, a kawan-akfa tǝsanfawt. ");
INSERT INTO ttq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bardagat-i tǝlkamam i tara-nin, tabǝzam fall-i masnat, id nak mǝššis ǝn talmat a mosa, ǝwǝl-in deɣ wǝr t-iha zazwar ǝn man. Ǝddi ad za tǝgrǝwam tǝsanfawt i man-nawan, ");
INSERT INTO ttq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","fǝlas lǝkkum i tara-nin isinaflay, ǝgǝggi-nin deɣ i fǝsusan.» ");
INSERT INTO ttq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Azzaman en da, ǝzǝl iyyan ǝn tǝsanfawt ǝn Kǝl-Ǝlyǝhud, issiwal Ɣaysa šiwǝgas n alkama ǝnta ǝd nǝttulab-net. Iggaz gǝlǝk inǝttulab-net, a du-rassaban šiɣaɣanen, tattin-tanat. ");
INSERT INTO ttq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","As ǝnayan Farisaytan awen, ǝnnan i Ɣaysa: «Ǝnǝy! Inǝttulab-nak taggin arat xarâman daɣ ǝzǝl wa n tǝsanfawt.» ");
INSERT INTO ttq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Inn-asan Ɣaysa: «Ak teɣaray a wǝr tǝgem awa iga ǝnnǝbi Dawǝd assaɣa wad t-iggaz gǝlǝk, ǝnta ǝd midawan-net? ");
INSERT INTO ttq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Awak wǝrgeɣ iguz a ǝgan ehan ǝn Mǝššina, ǝtšan šigǝlwen šin ǝmosnen takutay tǝskâtat i Mǝššina, imos awen arat fall-asan xaraman? Šigǝlwen šin den ilimaman ɣas as tǝxalal tattay-nasnat. Awak teɣaray a wǝr tǝgem adi? ");
INSERT INTO ttq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Meɣ ak teɣaray a wǝr tǝgem daɣ Ǝttawret as ǝzǝl wa n tǝsanfawt, ilimaman wǝr ǝssǝfraran ǝššǝrǝdan n ǝzǝl wa n tǝsanfawt id ǝzǝl wǝdi šaqqalan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, mišan wǝr fall-asan imos awen lahan? ");
INSERT INTO ttq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ǝggǝyeɣ-awan as wa illan da, ogar Ehan wa Zǝwwǝran n Ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ǝnnar tǝgrâm almaɣna ǝn batu ta tǝnnat: \"Nak tǝhanint a areɣ, wǝrge takutay.\" Wǝdi wǝr za tǝbǝzam s ǝššǝriɣa aytedan wǝr iwer lahan. ");
INSERT INTO ttq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ǝnneɣ-awan adi fǝlas nak Ag Aggadǝm a ixkaman fǝl ǝzǝl wa n tǝsanfawt.» ");
INSERT INTO ttq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ifal Ɣaysa edag wen, ikka ehan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud n ǝɣrǝm wen da. ");
INSERT INTO ttq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ehan wen ih-ay alǝs as immût ǝfus-net. Ǝnnan Farisaytan i Ɣaysa: «Ak xalal ǝzuzǝy n awedan daɣ ǝzǝl wa n tǝsanfawt?» Arat wen imos tǝnagmayt a das-ǝgân fǝl ad t-ǝbǝzan s ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Inn-asan Ɣaysa: «Mǝni daɣ-wan wa zʼilân tilay iyyadda, amaran tǝqqǝl anu daɣ ǝzǝl wa n tǝsanfawt, aqqam wǝr daɣ-as tat-d-ikkes? ");
INSERT INTO ttq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Awedan za, ogar tilay almaqam wǝllen! Daɣ adi xalal igi ǝn tǝnfa y awedan daɣ ǝzǝl wa n tǝsanfawt.» ");
INSERT INTO ttq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tǝzzar inna Ɣaysa y alǝs wa: «Ǝzzǝl ǝfus-nak.» Izzal-tu, izzay, ola ǝd wa hadan. ");
INSERT INTO ttq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ǝglan Farisaytan, ad timǝšǝwwiran fǝl tǝmǝwit tas zʼagin iman ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","As isla Ɣaysa awen, igmad edag wen. Tǝlkam-as tamattay tǝgget. Izzozay imiranan kul. ");
INSERT INTO ttq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mišan irɣam-asan fǝl amel y awedan waliyyan awa imos. ");
INSERT INTO ttq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Arat wen iga fǝl ad andu awal wa iga ǝnnǝbi Isayas as inna: ");
INSERT INTO ttq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ǝnta da ǝnaɣbid-in wa sannafrana, s ǝnta a ǝkneɣ tara, isifalawas iman-in. A fall-as du-zǝzzǝbbe Infas-in di Zǝddigan, ad immal i tǝmattiwen n ǝddǝnet kul ǝššǝriɣa wa-nin. ");
INSERT INTO ttq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wǝr zʼammastan d awedan waliyyan, za wǝr fall-as zʼisǝɣǝrǝt, wala aslin-as aytedan išawal daɣ tarrayen. ");
INSERT INTO ttq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wǝr zʼarzu alawag ǝn telant illigwen, za wǝr zʼanɣu fǝtǝla tǝbukat i tǝmattant; almaɣna as wǝr zʼagu tǝkma waliyyat i nǝrkam. Awen daɣ a zʼitaggu iket wǝr issǝbdad ǝššǝriɣa; ");
INSERT INTO ttq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","aginat daɣ-as tamattiwen n ǝddǝnet kul attama-nasnat. ");
INSERT INTO ttq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tǝzzar immeway-du alǝs iyyan ǝs Ɣaysa, as immidad ǝmi-net, imos deɣ ǝmǝdderɣǝl, fǝlas aggǝsuf a t-izdaɣan. Izzozay Ɣaysa alǝs wen, iššewal iswad deɣ. ");
INSERT INTO ttq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Isimaklal awen wǝllen ǝs tamattay ketnet, ad tǝgannu: «Ma iqqal ak Ag ǝnnǝbi Dawǝd wa ǝttǝmalan awa?» ");
INSERT INTO ttq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mišan as ǝslan Farisaytan y awen, ǝnnan: «Alǝs en Aššaytan Baɣalzabul wa n ǝmǝnokal ǝn kǝlǝsuf a t-ikfan fǝrregat n ikus ǝn kǝlǝsuf daɣ aytedan.» ");
INSERT INTO ttq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mišan ya issan Ɣaysa daɣ awa samadranan, inn-asan: «Taɣmar kul tas ǝmmǝgaran mǝssawǝs gar-essan, tǝdi ǝbǝrǝjji a za tagu. Wǝr t-illa ǝɣrǝm, wala deɣ aɣaywan, as zʼammazrayan mǝssawǝs, aqqam wǝr ibarajjat. ");
INSERT INTO ttq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","As imos as Aššaytan isattaɣ iman-net, wǝdi iman-net a dǝr immǝgar. Daɣ adi manǝmmǝk as za tihag taɣmar-net? ");
INSERT INTO ttq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amaran kud nak tarna ǝn Baɣalzabul as takkasaɣ kǝlǝsuf daɣ aytedan, inalkiman-nawan za, ma ilan tarna tas tan-takkasan? Adi da fǝlas ǝntanay iman-nasan as kawan-z-ǝbǝzan s ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mišan as imos as Infas ǝn Mǝššina as takkasaɣ kǝlǝsuf daɣ aytedan, wǝdi Taɣmar ta n Mǝššina tos-iwan-du. ");
INSERT INTO ttq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wǝr t-illa i ifrâgan iguz n ahan n alǝs n ǝmǝqqerǝd, iɣrǝd aqqa ǝn tǝla-net, ar s ad t-ikrâd təzzar. Dǝffǝr as t-ikrâd amaran ad zʼifrəg aqqa ǝn tǝla-net. ");
INSERT INTO ttq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wa dǝr-i wǝr nǝddew, wǝdi azangaw-nin a imos, wa di-wǝr-nǝllil deɣ s ǝšidǝw, wǝdi ǝzǝwwǝziwǝz a itaggu.» ");
INSERT INTO ttq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Awen da fǝl dawan-ǝnneɣ: A iqqal abakkad, wala alfawaxiš, kul ad tǝwǝsurǝfan y awedan, mišan ikus ǝn tarna y Infas wa Zǝddigan, ǝnta wǝr zʼitǝwǝsurǝf y awedan. ");
INSERT INTO ttq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","As di-ibyak awedan nak Ag Aggadǝm, ifrâg ad igrǝw tǝsureft, mišan as ibǝyak awedan Infas wa Zǝddigan, wǝrmad zʼigrǝw tǝsureft daɣ ǝddǝnet, za wǝr tat-z-igrǝw daɣ alaxirat.» ");
INSERT INTO ttq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«As tǝlam ašǝk isxân, a daɣ-as tǝgrǝwam âratăn olaɣnen, as tǝlam ašǝk wǝr nǝsxa, a daɣ-as tǝgrǝwam âratăn ǝbrarnen; fǝlas âratăn win itaraw ašǝk, ǝntanay as itawazday. ");
INSERT INTO ttq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Xa taššolen šin da! Manǝmmǝk as za tannim a olaɣan, ǝnta kawanay tǝknâm tallabast? Wǝrgeɣ awa idkaran ǝwǝl n awedan, ǝnta a d-igammadan imi-net? ");
INSERT INTO ttq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Awedan wa olaɣan, ǝlluɣ wa ihan ǝwǝl-net a daɣ d-itakkas awa olaɣan, mišan anallabus ǝnta, talbast ta tǝhat ǝwǝl-net a daɣ d-itakkas awa labasan. ");
INSERT INTO ttq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amaran nak ǝnneɣ-awan ǝzǝl wa n tabadday awedan kul kundaba ibdad fǝl batuten ǝn bannan šin iga. ");
INSERT INTO ttq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Fǝlas awalan-nak a kay-tagaznen daɣ ǝššǝriɣa, amaran ǝntanatay harwa da a kay-tabaznen s ǝššǝriɣa.» ");
INSERT INTO ttq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ǝnnan arat daɣ musanan n Ǝttawret ǝd Farisaytan: «Ǝššex, nǝra daɣ-ak a dana-tassakna tǝlmǝɣjujat tǝmosat alɣalamat.» ");
INSERT INTO ttq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Inn-asan Ɣaysa: «Aytedan n azzaman win, inǝllubas, wǝr nǝksud Mǝššina, amaran gammayan tǝlmǝɣjujat! Kala! Tǝlmǝɣjujat ta dasan-tǝtawaggat iyyadda ɣas, a tat-imosan ta n ǝnnǝbi Yunǝs. ");
INSERT INTO ttq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ǝnta ǝmmǝk wa daɣ as iga Yunǝs karad jilan, ǝd karad hadan daɣ tǝdist ǝn kifi wa zǝwwǝran, ǝmmǝk wen daɣ as nak da Ag Aggadǝm ad aga karad adan gǝr mawetan n amaḍal. ");
INSERT INTO ttq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ǝzǝl wa n tabadday, ad d-ǝnkǝran aytedan n ǝɣrǝm ǝn Ninif, ǝzzǝbǝzan aytedan n azzaman win y ǝššǝriɣa fǝlas ǝntanay ǝhǝddi a ǝgan ǝzǝl wa dasan-iga Yunǝs tǝlxutbat, imal-asan awal ǝn Mǝššina. Ǝssǝnat za as, wa illan da ǝmǝrǝdda, ogar Yunǝs mišan tugayam ǝs tǝtubt. ");
INSERT INTO ttq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ǝzǝl wa n tabadday, a du-tǝnkǝr tǝmǝnokalt tas kala tǝxkam fall akal n agala igân esǝm Šeba, taggayyat fǝl aytedan n azzaman win, tǝzzǝbǝz-tan y ǝššǝriɣa fǝlas d ad iraz amaḍal a du-tǝgmad fǝl ad tǝssǝsǝm y awal ǝn tǝla n ǝgǝrri wa itaggu ǝmǝnokal Suliman. Ǝssǝnat za as, wa illan da ǝmǝrǝdda, ogar ǝnnǝbi Suliman mišan tugayam s a das-tǝssǝsǝmam.» ");
INSERT INTO ttq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«As igmad aggǝsuf awedan, iras aggǝsuf wen idaggan ǝqqurnen igammay id imal, iqqim wǝr t-igrew, ");
INSERT INTO ttq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ad annu daɣ man-net: \"Nak a za, ad ǝqqǝlaɣ ehan-in wa d-ǝgmada.\" As t-id-iqqal a t-id-asu wǝr itawaggaz, ifrâd, iɣrad amaknaw. ");
INSERT INTO ttq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tǝzzar aglu idaw-du d ǝssa kǝlǝsuf wiyyad a t-ogarnen tallabǝst, ǝggǝzan awedan wanâd, ǝzdǝɣan-tu. Tagu taɣara n awedan wen aɣšud ogaran was kala tu-tǝga. Awen da a zʼigrǝwan inǝllubas n azzaman win.» ");
INSERT INTO ttq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","A iššewal Ɣaysa i tamattay den da, tǝlla anna-net den ǝd mǝdrayan-net. Ǝbdâdan sǝdi dat ahan, ǝrân a das-annin arat. ");
INSERT INTO ttq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Inna awedan iyyan i Ɣaysa: «Ǝnǝy, anna-nak ǝd mǝdrayan-nak, ǝbdâdan-ak dat ahan ǝrân a dak-annin arat.» ");
INSERT INTO ttq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Inn-as Ɣaysa: «Ma imosan anna-nin? Ma imosan imǝdrayan-in?» ");
INSERT INTO ttq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tǝzzar izzal Ɣaysa ifassan dǝnnǝg nǝttulab-net, inna: «Ǝnǝyat, anna-nin ǝd mǝdrayan-in ǝntanay da, ");
INSERT INTO ttq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","id awedan kul wa itamazalan tara n Abba-nin ihan ijǝnnawan, ǝnta a imosan amadray-nin, madeɣ tǝmadrayt-in, madeɣ anna-nin.» ");
INSERT INTO ttq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ǝzǝl wen, igmad Ɣaysa ehan, igla, iqqim daɣ tǝgadamayt n agaraw. ");
INSERT INTO ttq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tǝddew-du fall-as tamattay tagget, har as iggaz aɣlal n aman iqqim daɣ-as, tǝbdad tamattay ketnet daɣ tǝgadamayt n agaraw. ");
INSERT INTO ttq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Immǝgrad-asan daɣ aratan aggotnen s ǝlmitalan. Inn-asan: «Kala ad ikka ǝmagyak iyyan tawagost-net, y a tat-inbǝl. ");
INSERT INTO ttq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Daɣ anabal wa itaggu den imosan anabas n amasa, ǝrtaknat tǝblalen šiyyad fǝl tama ǝn tarrayt, osan-du gǝḍad, ǝtšan-tanat. ");
INSERT INTO ttq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Šiyyad ǝrtaknat daɣ adag ǝhanat tǝhun, amaran wǝr t-iha amaḍal igdân. Idwal-du amasa wen tarmad, fǝlas wǝr daw-ǝs illa amaḍal aggen. ");
INSERT INTO ttq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","As tǝggǝzzay tǝfuk, tǝssǝqqad awa d-idwalan daɣ amasa wen. Iqqur fǝlas ikewan-net a wǝr nǝggug daɣ amaḍal. ");
INSERT INTO ttq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Šiblalen šiyyad ǝrtaknat daɣ tǝfǝssaɣ. Ǝdwalnat tǝfǝssaɣ šin, ǝlmaznat amasa wa d-idwalan den. ");
INSERT INTO ttq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mišan ya arat daɣ təblalen en irtak daɣ amaḍal olaɣan. Igmad-du, idwal, iga šiɣaɣanen. Šiblalen šin den akkiyyat teraw temeday ǝn tablalt, šiyyad sǝdisat tǝmǝrwen, šiyyad karadat tǝmǝrwen. ");
INSERT INTO ttq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wa isallin, isǝsǝmet!» ");
INSERT INTO ttq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dǝffǝr awen ǝhozan-t-in nǝttulab-net ǝnnan-as: «Mafǝl tǝtamagrada y aytedan win s ǝlmitalan?» ");
INSERT INTO ttq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ijjawwab-asan Ɣaysa inn-asan: «Taggaɣ-asan ǝlmitalan win, id kawanay tǝgrâwam masnat daɣ ǝssiran ǝn Taɣmar ta n jǝnnawan, ǝntanay amaran wǝr tat-ǝgrewan. ");
INSERT INTO ttq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Fǝlas wa ilan, a das-itǝwǝšitu awa ila, annaflay. Wa wǝr nǝla amaran, arat n awa ila da a daɣ-as attarmas. ");
INSERT INTO ttq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Awen da a fǝl dasan-tamagrada s ǝlmitalan, id ǝswâdan mišan wǝr hǝnnǝyan, ǝssisaman mišan wǝr sallin, za wǝr gǝrrin. ");
INSERT INTO ttq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ǝntanay a fǝl tǝnda batu ta iga ǝnnǝbi Isayas assaɣa wad inna: \"Ad taknim ǝsǝsǝm, mišan wǝr za tagrim wala. Taknim asawad mišan wǝr za tǝnǝyam wala. ");
INSERT INTO ttq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Fǝlas iwallan ǝn tamattay ta abʼas ǝlan tafrǝyt, ǝngǝm agrin. Ǝgan iman-nasan imzagan, šittawen-nasan deɣ ǝɣmasan-tanat, fǝl ad ibʼas hannayan ǝs šittawen-nasan, ib-as sallin ǝs tǝmǝzzugen-nasan, ibʼas garrin ǝs wallan-nasan. Ugayan ǝs tǝtubt, ǝngǝm ǝzzuzǝyaq-qan.\"» ");
INSERT INTO ttq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Kawanay amaran tǝbbilalam id šittawen-nawan ǝhannaynat, tǝbbilalam id šimǝzzugen-nawan sallinat. ");
INSERT INTO ttq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ǝggǝyyeɣ ǝsilakanaɣ-awan as sidaranan ǝnnǝbitan aggotnen d aytedan win oɣadnen aggotnen anay n awa tǝhannayam, mišan wǝr t-ǝnayan, sidaranan deɣ tesalay y awas tǝsallim, mišan wǝr das-ǝslen.» ");
INSERT INTO ttq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Daɣ adi kawanay sǝsǝmat y almaɣna n ǝlmital wa n ǝnabal n amasa. ");
INSERT INTO ttq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amasa wa irtakan fǝl tama ǝn tarrayt, ǝlmital a imos n awedan wa islan i salan ǝn Taɣmar ta n Mǝššina wǝr tan-igra, asa-du Iblis ikkǝs awa itawanbalan daɣ ǝwǝl-net. ");
INSERT INTO ttq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amasa wa irtakan daɣ amaḍal ǝhânat tǝhun, ǝlmital a imos n awedan wa islan y awal ǝn Mǝššina, iqbal-tu ǝddi da ǝs man filawasnen, ");
INSERT INTO ttq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mišan wǝr ila awen ekay. Awedan wa wǝr imos ar mǝššis ǝn tǝmazayen. Igda ɣas a tu-tǝmǝl tǝssust, madeɣ tǝddǝguzt tǝgât fǝl ǝddǝlil n Awal ǝn Mǝššina, ad ayyu ǝzǝgzan ǝddi da. ");
INSERT INTO ttq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amasa wa irtakan daɣ tǝfǝssaɣ, ǝlmital a imos n awedan wa islan y Awal ǝn Mǝššina, mišan aššawašatan n ǝddǝnet, d adakal wa tǝga tǝgǝrgist n ǝddǝnet tayttay-net, ǝssǝfalan-du dǝnnǝg Awal wen, igdal-as awen a d-awǝy tǝnfa. ");
INSERT INTO ttq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amasa amaran wa irtakan daɣ amaḍal olaɣan, ǝlmital a imos n awedan wa islan y Awal ǝn Mǝššina, igr-ay. Awedan wǝdi a d-awǝy tǝnfa tǝmosat temeday n ǝnǝtfus, iyyat tǝqqǝl sǝdisat tǝmǝrwen, iyyat amaran tǝqqǝl karadat tǝmǝrwen.» ");
INSERT INTO ttq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iga Ɣaysa i tamattay ǝlmital iyyan. Inna: «Taɣmar ta n jǝnnawan tǝha ǝlmital n alǝs inbalan amasa olaɣan daɣ tawagost-net. ");
INSERT INTO ttq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","As ǝnsan aytedan osa-du azangaw-net, inbas ark amasa daɣ tǝwagost ten, ijawankat. ");
INSERT INTO ttq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","As tǝdwal tawagost, tǝga šiɣaɣanen, inafalal-du ǝnta da ark amasa wanad. ");
INSERT INTO ttq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Osan-du eklan n alǝs wa ilan tawagost ten, ǝnnan-as: \"Mǝššikkana, wǝrgeɣ amasa wa olaɣan a tǝnbala daɣ tawagost-nak? Ǝnnǝs za taɣara n arak yel wa daɣ-as d-idwalan den?\" ");
INSERT INTO ttq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Inn-asan alǝs wen: \"Adi azangaw-nin iyyan a t-igan.\" Ǝnnan-as eklan: \"Meqqal tareɣ ad naglu nǝɣrǝd-du alabay ǝn yel wa wǝr noleɣ en?\" ");
INSERT INTO ttq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Inn-asan: \"Kala! Fǝlas tǝksǝda a ǝgeɣ a tu-tǝnakkadam har ammarsal alkama iman-net. ");
INSERT INTO ttq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ayyiwat-tan ad ǝdwǝlan kul har du-tawǝd ɣarat. As inta ǝmilǝy ǝn tǝwǝgas, ad annaɣ i maššaɣalan win talaynen, ad izaran s arak yel wa, har t-ǝɣrǝdan tewaɣnay iqqǝl šibolasen, itǝwǝsǝqqǝd, alkama amaran agin-tu daɣ tǝdangawt-in.\"» ");
INSERT INTO ttq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ig-asan Ɣaysa ǝlmital iyyan, inn-asan: «Taɣmar ta n jǝnnawan tola d amasa n annabat igân esǝm mutard inbal awedan daɣ tawagost-net. ");
INSERT INTO ttq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Amasa wa n mutard ǝnta a ogaran imasan kul tǝmmǝdrǝyt. Mišan as idwal, ad agǝr annabatan kul win fǝrgan, iqqǝl ašǝk, har as a d-asin gǝḍad ad taggin šisǝllula daɣ zǝlan-net.» ");
INSERT INTO ttq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ig-asan ǝlmital iyyan, inn-asan: «Taɣmar ta n jǝnnawan tola ǝd xamira tǝrway tǝntut daɣ karadat annafaɣaten n agel n alkama har ikuf agel ketnet.» ");
INSERT INTO ttq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aratan win den kul igann-en Ɣaysa i tamattay s ǝlmitalan. Wǝr dasan-inna arat waliyyan wǝr nǝmos ǝlmital, ");
INSERT INTO ttq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","fǝl ad andu awal ǝn Mǝššina wa imal ǝnnǝbi assaɣa wad inna: «Ad araɣ imi-nin, ǝššiwǝla s ǝlmitalan, ǝmǝlaɣ aratan win ǝɣbarnen harwa ɣur ǝnǝtti n ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dǝffǝr awen ifal Ɣaysa tamattay, igla ikka ehan. Ǝhozan-t-in nǝttulab-net ǝnnan-as: «Sassagr-anaɣ ǝlmital wa n arak yel wa d-idwalan daɣ tawagost.» ");
INSERT INTO ttq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Inn-asan: «Wa inbalan amasa wa olaɣan, adi Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tawagost, adi ǝddǝnet, amasa wa olaɣan amaran immittal aytedan win ǝbbǝrdagnen i Taɣmar ta n Mǝššina, arak yel immittal aytedan win ǝlkamnen i tarrayt ta n Iblis. ");
INSERT INTO ttq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Azangaw wa inbalan ark amasa, adi Iblis, ɣarat amaran adi ǝzǝl wa n tabadday. Aytedan win talaynen, adi angalosan. ");
INSERT INTO ttq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ǝnta ǝmmǝk wa daɣ as d-itawankad arak yel daɣ tawagost, itǝwǝsǝqqǝd, ǝmmǝk wǝdi daɣ a zʼitǝwǝggin ǝzǝl wa tabadday y aytedan. ");
INSERT INTO ttq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A d-assagla nak Ag Aggadǝm angalosan-in a zʼǝkkǝsnen daɣ Taɣmar-in aratan kul win takkasnen ǝzǝgzan daɣ aytedan, d aytedan win nǝmmǝzray ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tǝzzar ǝgǝran-tan daɣ amahander ǝn tǝmsay, ad hallin ǝddadan idǝdwan-nasan fǝl tǝmagraz. ");
INSERT INTO ttq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ǝddi daɣ ad zʼagin aytedan win oɣadnen ǝmǝlǝwlǝw wa n tǝfuk, daɣ Taɣmar ta n Mǝššina di n Abba-nasan. I isallin aslet!» ");
INSERT INTO ttq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Taɣmar ta n jǝnnawan tola harwa da d ǝrrǝzǝɣ iɣbâran daɣ tawagost, isaffagg-ay d awedan iyyan, ilas-tu aɣabar. Awa iga daɣ tǝfalawist, igla izzǝnz-in awa ila kul, izzǝnza tawagost ten.» ");
INSERT INTO ttq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Taɣmar ta n jǝnnawan tola harwa da d amassatag igammayan ǝljuhǝr wa ihossayan. ");
INSERT INTO ttq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","As igraw ǝljuhǝr iyyan ihossayan, wa n ǝlǝsǝl, igla izzǝnz-in awa ila kul izzǝnz-ay.» ");
INSERT INTO ttq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Taɣmar ta n jǝnnawan tola harwa da ǝd sangay zǝwwǝran n abbaz ǝn kifitan itiwagaran daɣ agaraw, obaz-du kifitan ǝmosnen ǝzzǝnǝfan. ");
INSERT INTO ttq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","As idnay, ǝrkaban-t-idu nabazan ǝn kifitan ǝs tǝgadamayt, ǝqqiman, ǝdkalan-du izmaman a daɣ-san taggin kifitan win olaɣnen, ǝggaran-in win wǝr nǝnfa wala. ");
INSERT INTO ttq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Awen daɣ a zʼagin ǝzǝl wa n tabadday. A d-asin angalosan, ǝskǝtan-in inǝmmǝzray ǝn Mǝššina, zǝmmǝzǝyan-tan d aytedan win oɣadnen, ");
INSERT INTO ttq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ǝgǝran-tan daɣ amahander ǝn tǝmsay, ad hallin ǝddadan idǝdwan-nasan fǝl tǝmagraz.» ");
INSERT INTO ttq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Igla Ɣaysa iššêwal inn-asan: «Ak tǝgrâm awa ǝnne da kul?» Ǝnnan-as: «Awalla.» ");
INSERT INTO ttq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tǝzzar inn-asan: «Daɣ adi, ǝmusan n Ǝttawret kul wa itawasasaɣran y ad iqqǝl ǝnalkim ǝn Taɣmar ta n jǝnnawan, ola ǝd mǝššis n aɣaywan, a d-itakkasan daɣ tǝla-net aratan win aynaynen ǝd win waššarnen isataɣmal-tan.» ");
INSERT INTO ttq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","As iɣrad Ɣaysa ǝsǝssǝɣri wa igan s ǝlmitalan en, igmad akal wa ihozan agaraw, igla. ");
INSERT INTO ttq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","As d-osa aɣrǝm wa daɣ idwal ad isasaɣru aytedan daɣ ahan-nasan wa n ǝlɣibada. Awa sǝr-san iga awen daɣ ǝsǝmmǝklǝl, har ǝqqiman gannin: «Mǝnis t-idu-tǝggaz masnat togdat d awa, ǝd tǝlmǝɣjujaten šin itaggu da?» ");
INSERT INTO ttq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","«Ak awa wǝrgeɣ ag alǝs wa ikarrasan inan? Wǝrgeɣ anna-net esǝm-net Maryama, imǝdrayan-net iyyan Yaqub, iyyan Yusǝf, iyyan Simɣon, iyyan Yahuza? ");
INSERT INTO ttq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wǝrgeɣ šimǝdrayen-net kul ǝllanat ɣur-na? Daɣ adi mǝni iguz wa das-d-ǝgan aratan win da kul?» ");
INSERT INTO ttq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Awen daɣ a dasan-igdalan ǝzǝgzan sǝr-ǝs. Mišan inn-asan Ɣaysa: «Ǝnnǝbi wǝr itǝwǝlku ar daɣ aɣrǝm wa daɣ idwal d aɣaywan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amaran iqqim da wǝr iga tǝlmǝɣjujaten aggotnen daɣ adag wen, fǝlas ǝzǝgzan a sǝr-ǝs wǝr ǝgen aytedan win den. ");
INSERT INTO ttq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Azzaman en da a daɣ isla Herod Antifas wa n ǝmuzar n akal ǝn Galilaya, isalan ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tǝzzar inna Herod y aytedan-net: «A igan da Yaxya wa isalmaɣan aytedan daɣ aman, a d-inkaran den daɣ tǝmattant! Awen da fǝl ila tarna n igi ǝn tǝlmǝɣjujaten.» ");
INSERT INTO ttq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Arat wen inn-ay Herod fǝlas azzaman dat awen omâr s ǝtǝrmǝs ǝn Yaxya, itawakrad itawagga daɣ kasaw, fǝl ǝddǝlil ǝn Herodǝyas tǝmosat taɣur Filibus imosan amadray ǝn Herod a da, ");
INSERT INTO ttq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","fǝlas Yaxya a igannin i Herod: «Xaram fall-ak azalaf ǝn tǝntut di.» ");
INSERT INTO ttq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eway-du awen ǝs Herod as ira ikus ǝn man ǝn Yaxya, mišan iksud tamattay tǝgât i Yaxya iduf n as ǝnnǝbi a imos. ");
INSERT INTO ttq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","As d-iɣlay ǝzǝl wa n tǝhǝwt ǝn Herod, isassaga saksas, tǝga elles ǝn Herodǝyas eweɣ iknan šihussay dat naftaɣan. Tǝzzar oggăm-tat Herod ");
INSERT INTO ttq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","har as ihad-as âs, a das-agu arat kul wa daɣ-as tǝgmay. ");
INSERT INTO ttq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","As tǝššǝwwar anna-net tǝnn-as ad tannu i Herod eɣaf ǝn Yaxya a tǝra. Tǝnkar tǝbarart tǝnn-i Herod: «Akf-i attabla da da iha aɣaf ǝn Yaxya wa isalmaɣan aytedan daɣ aman.» ");
INSERT INTO ttq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Arat wa tǝgmay tǝbarart ten eway-du s ǝmǝnokal Herod as ǝɣšadan man-net. Mišan omar s a das-itǝwǝggu arat wa tǝgmay den, fəl əddəlil ən təhuday ta das-iga d əddəlil ən naftaɣan-net. ");
INSERT INTO ttq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Issǝgla awedan y a d-ifrǝs eɣaf ǝn Yaxya daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Immeway-du aɣaf n ǝnnǝbi en daɣ attabla, itawakfa i tǝbarart, tǝzzar tǝkf-ay y anna-net. ");
INSERT INTO ttq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Osan-du nalkiman ǝn Yaxya ǝdkalan taɣǝssa-net, ǝnbalan-tat-in. Ǝglan ǝmalan i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","As isla Ɣaysa isalan win, igmad edag wen, iha aɣlal n aman. Igla ɣas-net ikka edag issufan a din-ikitayyen. Tǝsla tamattay ta tǝhat šiɣarmaten šin ɣǝlǝyɣǝlayan awen, tǝlkam-as idaran-net. ");
INSERT INTO ttq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","As d-izzǝbbat aɣlal inay tamattay tagget, tǝggaz-tu tǝhanint-net, ad izuzǝy imiranan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","As tǝga takǝst, ǝhozan-t-idu nǝttulab-net ǝnnan-as: «Edag issufan awa, amaran ǝzǝl igla, daɣ adi suɣǝl tamattay a, ad tǝgmǝy id tǝzzǝnza a tǝtša daɣ tǝɣarmaten.» ");
INSERT INTO ttq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Inn-asan Ɣaysa: «Wǝr tǝga addararat s ad aglin, šatšat-tan kawanay iman-nawan da!» ");
INSERT INTO ttq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ǝnnan-as: «Nakkanay ya wǝr nǝla da ar sǝmmosat tǝgǝlwen d ǝššin kifitan.» ");
INSERT INTO ttq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Inn-asan Ɣaysa: «Awǝyat-i-tan-du.» ");
INSERT INTO ttq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Omar tamattay s ad taqqam daɣ yel illan den, tǝzzar idkal sǝmmosat tǝgǝlwen šin den d ǝššin kifitan win, iggǝzzay ijǝnnawan, iga igodan i Mǝššina. Ikaramkaram šigǝlwen šin den, ikf-enat i nǝttulab, a tanat-tuzanan i tamattay. ");
INSERT INTO ttq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ǝtšan aytedan en ketnasan har əyyəwanan. Ǝššedawan-du nǝttulab ikarammutan win du-tawaglaznen, ǝdnayan maraw ǝzmaman d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aytedan win ǝtšanen den ǝmosan edag ǝn sǝmmos gim n alǝs, ǝllanat deɣ tǝdoden den ǝd bararan. ");
INSERT INTO ttq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wala a ihogan omar Ɣaysa inǝttulab-net s ad ǝggǝzan aɣlal n aman izaran-as-in ǝs tǝgadamayt ta hadat n agaraw iket di ad itasallam tamattay. ");
INSERT INTO ttq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","As ǝɣradan aytedan teklay, iggǝzzay Ɣaysa adɣaɣ y ad agu šiwatriwen daɣ adag ikitayyan. Illa den da ɣas-net har iga ahad. ");
INSERT INTO ttq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","As itaggu awen da aɣlal iggug-in daɣ agaraw, ǝbbatnat-tu tǝnazzamaren sa ǝd sa fǝlas aḍu issohen a dǝr immǝqqas. ");
INSERT INTO ttq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","As tǝga tilkamat n ahad, ikka-du Ɣaysa inǝttulab-net ijiwankat fǝl aman. ");
INSERT INTO ttq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","As t-oggan ijiwankat-du fǝl aman, ǝrmaɣan. Ǝnnan: «Awen aggǝsuf!» Sakkarayan fǝl awa ǝgan daɣ tǝrǝmmeq. ");
INSERT INTO ttq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mišan tamazayt ten da a dasan-iššewal Ɣaysa inn-asan: «Ad wǝr tǝɣšǝdam, nak awa! Tǝgmǝdet-kawan tasa!» ");
INSERT INTO ttq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Den daɣ a das-inna Butros: «Kud kay adi Ǝmǝli, tamǝraɣ-i s a din-jǝwǝnkeɣ fǝl aman ǝssǝlkadaɣ-ak-in.» ");
INSERT INTO ttq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","«Iyyaw!» Inn-as Ɣaysa. Izzǝbbat Butros aɣlal, ijawankat fǝl aman innǝmad Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mišan as din-igra assahat n aḍu wa igaran den, tǝggaz-tu tasa, ǝggazan-tu aman šin alamaz. Isaɣɣarat inna: «Ǝmǝli agǝz-i!» ");
INSERT INTO ttq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tarmad as das-in-izzal Ɣaysa ǝfus-net, ibaz-t-idu. Inn-as Ɣaysa: «Ǝzǝgzan-nak irkam wǝllen, ma daɣ-ak igan aššak?» ");
INSERT INTO ttq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ǝggazan aɣlal ɣas, idrar aḍu. ");
INSERT INTO ttq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ǝssǝjadan-as aytedan win ǝhanen aɣlal en, gannin: «Illikan as kay a imosan Barar ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","As ǝɣrasan agaraw, ewadan akal ǝn Ganazaret. ");
INSERT INTO ttq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","As ǝssanan kǝl akal en as Ɣaysa awen, ǝmalan y aytedan ǝn kallan win ɣǝlǝyɣǝlayan n edag wen, a sǝr-ǝs du-tamawayan miranan kul. ");
INSERT INTO ttq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ad itawansay ad ayyu aytedan ǝdǝsan kuddeɣ tǝbǝnik ǝn tǝkadkat-net, amaran i tat-idasan ad izzǝy. ");
INSERT INTO ttq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dǝffǝr awen ǝfalan-du Farisaytan ǝd musanan n Ǝttawret Yerusalam, ǝkkan Ɣaysa, ǝnnan-as: ");
INSERT INTO ttq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mafǝl wǝr ǝlkeman nǝttulab-nak y alɣadaten šin dana-d-oyyan marawan-nana, wǝr ǝširidan ifassan-nasan dat tattay?» ");
INSERT INTO ttq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Inn-asan Ɣaysa: «Kawanay za, mafǝl tǝtamazrayam alwajiban ǝn Mǝššina, fǝl lǝkkum y alɣadaten-nawan? ");
INSERT INTO ttq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wǝrge Mǝššina a inna: \"Sǝɣmǝr abba-nak d anna-nak\"? Inna deɣ: \"Awedan wa išaffaraššen abba-net, madeɣ anna-net, wǝdi a daɣ-as tǝwǝkkǝsan man\"? ");
INSERT INTO ttq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mišan kawanay tǝgannim y aytedan, as inna awedan y abba-net madeɣ anna-net: \"Arat wa kay-z-akfaɣ imos tadhǝlt-nak, ǝssinsaq-qu y ad t-aga takutay,\" ");
INSERT INTO ttq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ǝddi ab-as ihhǝššal y awedan wǝdi saɣmar n abba-net wala anna-net. Ǝmmǝk di da as təgam alɣadat-nawan daɣ adag n Awal ən Məššina. ");
INSERT INTO ttq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ǝlmunafiqan! Tidǝt a imos awal wa iga Mǝššina daɣ batu-nawan ǝs tarrayt n ǝnnǝbi Isayas as inna: ");
INSERT INTO ttq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"Tamattay ta, ilǝs ɣas as di-tǝssǝɣmar, mišan iwallan-nasan ǝggugan-i wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ǝlɣibada wa di-taggin, ibbinnan, fǝlas wǝr sǝsǝɣrin ar alwajiban a d-ǝnzaman aytedan daɣ ɣafawan-nasan.\"» ");
INSERT INTO ttq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iɣra Ɣaysa tamattay inn-as: «Sǝsǝmat-i, tagrim awa dawan-z-anna da: ");
INSERT INTO ttq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wǝrgeɣ awa itaggazan s ǝmi n aggadǝm a t-isamadasan, kalar awa d-igammadan imi-net.» ");
INSERT INTO ttq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dǝffǝr awen ǝhozan-t-in nǝttulab-net, ǝnnan-as: «Ak tǝgreɣ-in as batuten-nak, ǝššakan-tanat Farisaytan wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Inn-asan Ɣaysa: «Annabat kul wa wǝr inbel Abba-nin ihân ijǝnnawan, wǝdi a d-itǝwǝlbǝy. ");
INSERT INTO ttq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ayyat-tan ɣas! Awen imǝddǝrɣal ǝlwaynen wiyyad. Ǝmǝdderɣǝl ilwâyan iyyan amaran, agadal a taggin ketnasan daɣ anu.» ");
INSERT INTO ttq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iššewal Butros inn-as: «Sassagr-anaɣ ǝlmital wǝdi.» ");
INSERT INTO ttq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Inna Ɣaysa: «Awak kawanay da harwa da wǝr tǝlem ǝgǝrri? ");
INSERT INTO ttq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Awak wǝr tǝgrem as arat kul wa iggazan s ǝmi n aggadǝm, akkay a zʼagu ǝs tǝdist, dǝffǝr adi inɣǝl-in daɣ ǝsuf? ");
INSERT INTO ttq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mišan wa d-igammadan imi, wǝdi ǝwǝl a d-ifal, amaran ǝnta a isamadasan aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ǝssǝnat as ǝwǝl ǝnta a du-gammadnat arak ǝnnǝyaten, d igi ǝn man, d igi n ǝzzǝna, d igi ǝn tǝdoden madeɣ igi ǝn meddan, ǝd šikra, ǝd tǝgǝyya ǝn bahu, ǝd šizmit. ");
INSERT INTO ttq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aratan win di ǝntanay a samadasnen aggadǝm. Mišan tettay ǝs fassan wǝr nǝrrud, wǝr tǝsammadas aggadǝm.» ");
INSERT INTO ttq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","As ifal Ɣaysa edag wen, ikka amaḍal ǝn Tir ǝd Sidon. ");
INSERT INTO ttq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tǝhin-in tǝntut n iyyat daɣ Kananitatan tǝzdaɣat akal en da, tǝkkâ-du Ɣaysa tǝsikaray tǝgann-as: «Ya Ǝmǝli, Ag ǝmǝnokal Dawǝd, hǝnǝttǝt-i! Tǝbarart-in a izdaɣ aggǝsuf a tat-izaɣazzaban wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mišan wǝr inna Ɣaysa i tǝntut en wala. Idgaz awen inǝttulab ǝhozan-t-in onsayan-tu ǝnnan-as: «Suɣǝl tantut ta dana-tǝlkamat da tǝsikaray.» ");
INSERT INTO ttq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Inna Ɣaysa: «Nak wǝr du-tawazammazalaɣ ar ǝs Kǝl-Israyil, ǝmosnen zun ayfǝd ǝssiggalnen.» ");
INSERT INTO ttq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dǝr iga awen da ya tǝkk-ay-du tǝntut en, tǝssǝjad-as tǝnn-as: «Ǝmǝli, ǝssǝn daɣ-i!» ");
INSERT INTO ttq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Inna Ɣaysa: «Wǝr oleɣ i idkalan amensay ǝn bararan, igǝr-t-in i dan!» ");
INSERT INTO ttq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tǝnn-as tǝntut en: «Tidǝt-nak Ǝmǝli, dǝr iga awen da ya iḍan ǝkǝmmi a taggin awa d-irattakan daɣ adag wa daɣ tattin mǝssawsan, tattin-tu.» ");
INSERT INTO ttq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inn-as Ɣaysa: «Ya tantut! Ǝzǝgzan-nam i zǝwwǝran! Itǝwǝgget-am awa tareɣ!» Amazay en da a daɣ tǝzzay elles ǝn tǝntut en. ");
INSERT INTO ttq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dǝffǝr awen igmad Ɣaysa edag wen, ikka tǝgadamayt n agaraw wa n Galilaya, tǝzzar iwar adɣaɣ, iqqim. ");
INSERT INTO ttq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tǝkk-ay-du tamattay tagget, a sǝr-ǝs du-tewayat imǝggudal, ǝd mǝddǝrɣal, ǝd nǝbdan, d aytedan as ǝmmidadan mawan-nasan, ǝd miranan wiyyad aggotnen. Aytedan win, tawasansin dat Ɣaysa, izuzǝy-tan. ");
INSERT INTO ttq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Isammaklal ǝs tamattay anay wa tǝga aytedan as ǝmmidadan mawan-nasan ǝššewalan, tǝnay inǝbdan ǝgrâwan šiɣurad-nasan, tǝnay imǝggudal jiwanken s ǝlluɣ, tǝnay imǝddǝrɣal hannayan. Ad taggin aytedan tǝmmalen y Ǝmǝli n Israyil. ");
INSERT INTO ttq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iɣra-du Ɣaysa inǝttulab-net inn-asan: «Tǝh-i tǝhanint ǝn tamattay a. Karad adan a ɣur-i ǝgan, amaran abʼas t-illa a ǝtšan. Wǝr areɣ a tan-ayya aglin wǝr ǝreman arat, fǝlas ǝddi mijas a tan-aggadlu gǝlǝk daɣ tarrayt.» ");
INSERT INTO ttq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ǝnnan-as nǝttulab-net: «Mǝni du-za-nǝgrǝw za daɣ ǝsuf a šigǝlwen siyyawannen tamattay togdât d awa?» ");
INSERT INTO ttq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Inn-asan Ɣaysa: «Mǝnǝket tǝgǝlwen tǝlam?» Ǝnnan-as: «Ǝssayat tǝgǝlwen a nǝla d arat ǝn kifitan win madrornen.» ");
INSERT INTO ttq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Omar tamattay s ad tǝɣrǝd tǝɣimit. ");
INSERT INTO ttq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Idkal-du ǝssayat tǝgǝlwen en ǝd kifitan win den, iga igodan i Mǝššina, amaran ikaramkaram-tan ikf-en i nǝttulab, ǝzunan-tan i tamattay. ");
INSERT INTO ttq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aytedan en ketnasan ǝyyǝwanan ǝglazan-du, har as ǝssa ǝzmaman win zawwarnen a du-tawatkarnen daɣ karammutan win d-ǝglazan. ");
INSERT INTO ttq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aytedan win ǝtšanen den, ǝmosan ǝkkoz gim n alǝs as wǝr ǝhenat tǝdoden ǝd bararan. ");
INSERT INTO ttq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dǝffǝr awen issǝllam Ɣaysa tamattay, iggaz aɣlal n aman, ikka akal ǝn Magadan. ");
INSERT INTO ttq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ǝkkan-du Farisaytan, ǝd Sadusaytan Ɣaysa ǝrân ad t-ajjarraban, gammayan daɣ-as a dasan-agu tǝlmǝɣjujat tǝmosat alɣalamat a du-tǝfâlat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Inn-asan: «As iga ǝlmǝz, tǝnayam ijǝnnawan zaggaɣan ad tannim: \"Tufat za ad agu ǝzǝl ihossayan.\" ");
INSERT INTO ttq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","As affaw amaran, tǝnayam ijǝnnawan zaggaɣan ǝhânat-tan šiyyay ad tannim: \"Azalada ad agu ǝzǝl ibrâran.\" As tǝswadam daɣ jǝnnawan, ad tǝssǝnam awa dǝr zʼalu alhawa dǝffǝr awen, mišan awa itaggin daɣ azzaman win wǝr tǝssenam almaɣna-net! ");
INSERT INTO ttq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aytedan n azzaman win, inǝllubas, wǝr nǝksud Mǝššina, amaran gammayan tǝlmǝɣjujat! Kala! Tǝlmǝɣjujat ta dasan-tǝtawaggat iyyadda ɣas, a tat-imosan ta n ǝnnǝbi Yunǝs.» Den da a tan-ifal Ɣaysa, igla. ");
INSERT INTO ttq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ǝkkan nǝttulab tagadamayt ta hadat n agaraw. As ewadan, ǝgran-in âs ǝttǝwan-in igi n allaw ǝn tǝgǝlla. ");
INSERT INTO ttq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Inn-asan Ɣaysa: «Ǝnkǝdat wǝllen i xamira ǝn Farisaytan, ǝd wa n Sadusaytan.» ");
INSERT INTO ttq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tǝzzar ad gannin nǝttulab gar-essan: «Awa wǝr t-inna ar fǝlas wǝr neway tagǝlla.» ");
INSERT INTO ttq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Issan Ɣaysa daɣ awen inn-asan: «Mafǝl tǝššewalam gar-ewwan fǝlas wǝr tǝlem tagǝlla, kǝl ǝzǝgzan ǝndarran? ");
INSERT INTO ttq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Awak ǝgǝrri a wǝr tǝgem harwa da? Wǝr tǝkǝttǝwam sǝmmosat tǝgǝlwen šin ǝtšan sǝmmos gim n alǝs, d ǝket n ǝzmaman win du-tǝdnayam daɣ gǝlzan-nasan? ");
INSERT INTO ttq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Meɣ ak tǝttǝwam-in ǝssayat tǝgǝlwen šin ǝššǝtšanen ǝkkoz gim n alǝs! Mǝnǝket ǝzmaman win zawwarnen a du-tǝdnayam ǝzǝl wen? ");
INSERT INTO ttq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nak a dawan-ǝnneɣ: \"Ǝnkǝdat i xamira ǝn Farisaytan, ǝd wa n Sadusaytan\". Manǝmmǝk as wǝr tǝgrem as wǝrgeɣ tagǝlla as dawan-ǝheɣ batu-net?» ");
INSERT INTO ttq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Den daɣ ad ǝgran as wǝrgeɣ xamira ǝn Farisaytan, ǝd wa n Sadusaytan a fǝl dasan-immǝgrad den, kalar ǝsǝssǝɣri-nasan as dasan-inna a das-ǝnkǝdan. ");
INSERT INTO ttq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ikkâ Ɣaysa amaḍal ǝn Qaysarǝya wa n ǝmuzar Filibus as issǝstan Ɣaysa i nǝttulab-net, inn-asan: «Ak daɣ iduf n aytedan, ma ǝmosa nak Ag Aggadǝm?» ");
INSERT INTO ttq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ǝnnan-as: «Wiyyad za gannin kay Yaxya wa isalmaɣan aytedan daɣ aman. Wiyyad gannin kay ǝnnǝbi Ilyas. Wiyyad amaran a gannin kay ǝnnǝbi Irmǝya a tǝmosa, madeɣ iyyan daɣ ǝnnǝbitan win hadatnen.» ");
INSERT INTO ttq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Inn-asan Ɣaysa: «Kawanay za, ma tǝnnam ma mosa?» ");
INSERT INTO ttq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Inn-as Simɣon Butros: «Ǝlmǝsix a tǝmosa, barar ǝn Mǝššina di n Amaɣlol.» ");
INSERT INTO ttq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Inna Ɣaysa i Simɣon Butros: «Tǝbbilala ya Simɣon, ag Yunǝs, fǝlas arat wǝdi wǝrgeɣ kay a daɣ-as issosanan iman-nak, kalar Abba-nin di ihan ijǝnnawan a dak-isannafalalan. ");
INSERT INTO ttq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nak amaran ǝnneɣ-ak: Kay Butros tǝhunt a tǝmosa, amaran tǝhunt ta, ǝnta a fǝl zʼǝkrǝsaɣ Ǝlkǝnisat-in. Ǝlkǝnisat ta, tarna ǝn tǝmattant da wǝr tǝfreg a das-tǝɣšǝd wala. ");
INSERT INTO ttq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A kay-akfa tǝsassarut ǝn Taɣmar ta n jǝnnawan. Arat kul wa tǝssǝxrama daɣ ǝddǝnet dada, ijǝnnawan da a daɣ-san ixram, arat deɣ wa tǝssǝxlala daɣ ǝddǝnet dada, ijǝnnawan da a daɣ-san ixlal.» ");
INSERT INTO ttq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tǝzzar iga i nǝttulab-net ammar a daɣ idgâz, s ad wǝr ǝmelan y awedan waliyyan as ǝnta a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A obazan ɣur ǝzǝl wen, ǝnta ad iggaz Ɣaysa šin ǝsǝssǝgri ǝn nǝttulab-net as iwâr-tu iki ǝn Yerusalam, y ad agu alɣazab aggen, a das-z-agin muzaran ǝn Kǝl-Ǝlyǝhud, ǝd muzaran ǝn limaman, ǝd musanan n Ǝttawret, tǝwǝggin man-net, inkǝr-du deɣ daɣ tǝmattant ǝzǝl wa n karad. ");
INSERT INTO ttq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tǝzzar iwat-tu Butros s ahal, iššewal fall-as, inn-as: «Ǝmǝli, ihǝnǝttǝtet-ak Mǝššina daɣ arat wa tǝmalaɣ ǝddi! Kala wǝr kay-z-igrǝw adi!» ");
INSERT INTO ttq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mišan imalallay-in Ɣaysa Butros, inn-as: «Ǝfǝl dǝffǝr-i Aššaytan! Tǝqqalaɣ-i tǝsǝnkǝft daɣ ǝššǝɣǝl wa di-d-ewayan s ǝddǝnet, fǝlas imedranan-nak, wǝrgeɣ Mǝššina a d-ǝfalan, kalar imedranan n aggadǝm ɣas a ǝmosan.» ");
INSERT INTO ttq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dǝffǝr awen inna Ɣaysa i nǝttulab-net: «Wa iran a di-ilkǝm, wǝdi igmǝdet tara ən man-net, agu imateran-net, idkǝl tǝgǝttawt-net, ilkəm-i. ");
INSERT INTO ttq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ǝssǝnat as awedan wa wǝr nǝgǝmmǝy ar aggaz ǝn man-net, wədi ad t-ǝgmǝdan, mišan wa iqbalan ad t-ǝgmǝdan fǝl ǝddǝlil-in, wǝdi a tan-igrǝw. ");
INSERT INTO ttq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma zʼaknu y awedan ad igrəw əddənet ketnet, ənta amaran temsay a ikka? Awak mas ifrag awedan tehakkay-net y a sər-əs agəz iman-net daɣ təmsay? ");
INSERT INTO ttq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ǝssǝnat as nak Ag Aggadǝm a d-asa ǝleɣ tanaya n Abba-nin, ǝddewa d angalosan-net, ǝddi amaran, awedan kul ad t-akfu maruzat n awa ewadan mazalan-net. ");
INSERT INTO ttq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ǝggǝyyeɣ ǝsilakanaɣ-awan as wiyyad daɣ aytedan win ǝbdadnen da wǝr tan-z-iba iket wǝr ǝnayan assa-nin nak Ag Aggadǝm ǝmosaɣ ǝmǝnokal.» ");
INSERT INTO ttq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","As ǝgan sǝdis adan dǝffǝr awen, iddew Ɣaysa ǝd Butros, ǝd Yaqub, ǝd Yaxya imosan amadray ǝn Yaqub en da, ikka dǝr-san adɣaɣ zagren ɣas-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Den da ad immǝttay azzahir-net dat-san, imalawlaw udǝm-net s ǝnnur olan ǝd wa n tǝfuk, ǝgan sǝlsa-net tǝmǝllay tǝsiraqqet wǝllen, tǝkna ǝsǝmǝɣmǝɣ. ");
INSERT INTO ttq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ǝhinan-in oggân ǝnnǝbi Musa, d ǝnnǝbi Ilyas as du-nafalalan, mišawalan ǝd Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iggad-du Butros inna i Ɣaysa: «Ǝmǝli, olaɣ as nǝlla da! Kud tareɣ adi, ad ǝkrǝsa karad hǝktan daɣ adag wa. Iyyan i-nak, iyyan in Musa, iyyan in Ilyas.» ");
INSERT INTO ttq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Harwada iššewal Butros as tan-tǝlsa tǝgarak tǝmilawlawat, təqqal-asan zun telay. Igmad ǝmǝsli tagarak ten, inna: «Awa Barar-in wa ǝkneɣ tara; ǝnta a d-issǝndan agna-nin. Sǝsǝmat-as!» ");
INSERT INTO ttq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","As ǝslan nǝttulab i batu ten, ǝrmaɣan wǝllen, fataqqen ǝssǝjadan. ");
INSERT INTO ttq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ihoz-tan-in Ɣaysa, idas-tan, inn-asan: «Ǝnkǝrat, tǝgmǝdet-kawan tasa!» ");
INSERT INTO ttq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ǝdkalan-du nǝttulab isawadan-nasan wǝr hǝnnǝyan ar Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tazabben-du adɣaɣ en da, as tan-omar Ɣaysa, inn-asan: «Ad wǝr tǝmǝlam y awedan waliyyan awa tǝnayam da, iket wǝr d-ǝnkera nak Ag Aggadǝm daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ǝssǝstanan nǝttulab Ɣaysa, ǝnnan-as: «Mafel za gannin musanan n Ǝttawret: \"Kundaba osa-du Ilyas tǝzzar as du-z-asu Ǝlmǝsix?\"» ");
INSERT INTO ttq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ijjǝwwab-asan Ɣaysa inn-asan: «Awalla za ar a d-asu Ilyas, annazzam aratan kul. ");
INSERT INTO ttq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amaran ǝssosanaq-qawan as Ilyas, osâ-du, mišan wǝr t-ǝqbelan aytedan, kalar ǝgan-as awas ǝran. Ǝmmǝk en daɣ as illikan as a di-zǝɣɣǝzzǝban nak Ag Aggadǝm.» ");
INSERT INTO ttq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ǝgran nǝttulab as Yaxya wa isalmaɣan aytedan daɣ aman, as iha Ɣaysa batu-net den. ");
INSERT INTO ttq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","As d-izzabbat Ɣaysa ǝd nǝttulab-net win karad en adɣaɣ, ǝhozan-du tamattay, ikk-ay-du alǝs iyyan igaraffat dat-ǝs, ");
INSERT INTO ttq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","inn-as: «Ǝmǝli, hǝnǝttǝt i barar-in, tazakarkarat a tu-tǝgrawat, amaran iɣɣizzab wǝllen fǝlas faw da itudu daɣ tǝmsay, madeɣ aman. ");
INSERT INTO ttq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ewayaq-qu ǝs nǝttulab-nak y ad t-ǝzzuzǝyan, mišan indar-asan.» ");
INSERT INTO ttq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Inna Ɣaysa: «Xa! Iket iba n ǝzǝgzan, iket ǝššur daɣ aytedan n azzaman a! Awak har ǝmmay ǝddewa dǝr-wan, ǝzizaydara dǝr-wan? Awǝyat-i-du barar sa da!» ");
INSERT INTO ttq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iharaššat Ɣaysa aggǝsuf wa ihan barar en, tǝzzar igmad-tu. Izzay barar daɣ amazay wen da. ");
INSERT INTO ttq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ǝhozan-in nǝttulab Ɣaysa ǝnnan-as: «Mafel nakkanay indâr-anaɣ ikus n aggǝsuf wen?» ");
INSERT INTO ttq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Inn-asan: «Adi za aššaddat ǝn rǝkkǝm n ǝzǝgzan-nawan! Ǝggǝyyeɣ ǝsilakanaɣ-awan as ǝnnar tǝlâm daɣ ǝzǝgzan a ogdân ǝd wala imi ǝn tǝzuɣay n ǝšǝnnan, har tǝnnam y ǝdɣaɣ en: \"Ǝgmǝd edag di takka wen\", ad ammazal s adi. Ǝddi wǝr t-illa arat as dawan-z-indǝr igi-net. ");
INSERT INTO ttq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amaran ǝzzǝnǝf n aggǝsuf wen, wǝr igǝmmǝd awedan ar ǝs tǝwatriwen, d ǝzum.» ");
INSERT INTO ttq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ǝzǝl iyyan ǝddewan nǝttulab ǝn Ɣaysa daɣ akal ǝn Galilaya as dasan-inna: «Nak Ag Aggadǝm ǝjwâra ad ǝggâzaɣ ifassan n aytedan, ");
INSERT INTO ttq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","agin iman-nin, tǝzzar ǝnkǝra-du daɣ tǝmattant ǝzǝl wa n karad.» Tǝɣšad batu ten iman-nasan wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Igla Ɣaysa ǝd nǝttulab-net har ewadan Kafarnahum. Ǝnkaran aytedan win zarzamnen amana y Ahan wa Zǝwwǝran n Ǝlɣibada, ǝhozan-in Butros, ǝssǝstanan-tu ǝnnan-as: «Awak ǝššex-nawan arazam a wǝr itǝggu amana y Ahan wa Zǝwwǝran n Ǝlɣibada?» ");
INSERT INTO ttq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Inn-asan Butros: «Awalla za ar irazzam-tu». Iggaz Butros ehan, azzar-as Ɣaysa awal issǝstan-tu inn-as: «Ma tǝnne kay Simɣon, ma irazzaman takǝsen d amana i mǝnokalan n ǝddǝnet? Awak maddanǝsan a dasan-tan-razzamnen, meɣ aytedan sa hadan?» ");
INSERT INTO ttq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Inn-as Simɣon: «Aytedan sa hadan a dasan-tan-razzamnen.» Inn-as Ɣaysa amaran: «Daɣ adi maddanǝs ǝn mǝnokalan wǝr tan-iwer arazam ǝn wala. ");
INSERT INTO ttq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mišan ya fǝl ad wǝr nǝqqǝl tǝsǝnkǝft y ǝzǝgzan n aytedan win zarzamnen, aglu akku agaraw, tǝgǝra daɣ-as azabzab wa n abbaz ǝn kifitan. Kifi wa tobazaɣ ǝstizarat, aru imi-net, a daɣ-as in-tagǝza tefelt n ǝzrǝf wa mallan. Tefelt ten ǝkkǝs-tat-du, tagla takfaɣ-asan-tat, ad tǝqqal ǝrruzmatan n amana wa-nin, ǝd wa-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Amazay wen daɣ a daɣ din-ǝhozan nǝttulab Ɣaysa, ǝnnan-as: «Ma imos za wa ogaran daɣ Taɣmar ta n jǝnnawan?» ");
INSERT INTO ttq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tǝzzar iɣra-du Ɣaysa arat ǝn barar, issǝbdad-tu gar-essan, ");
INSERT INTO ttq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","inna: «Ǝggǝyyeɣ ǝsilakanaɣ-awan âs as wǝr tǝsammattayam alxal, tǝqqǝlam zun bararan, wǝdi wǝr ilkem a tǝggâzam Taɣmar ta n jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Awen daɣ a fǝlas awedan kul wa issǝrasan iman-net, zun arat ǝn barar wa, wǝdi illikan as ǝnta ogaran daɣ Taɣmar ta n jǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«Amaran i iqbalan barar šilan wa fəl əddəlil-in, wǝdi nak iman-nin as di-iqbal. ");
INSERT INTO ttq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mišan i iqqalan ǝssǝbab n abakkad y iyyan daɣ aytedan win sǝr-i ǝzzǝgzannen, ǝmosnen zun bararan madrornen, wǝdi of-as ad itǝwǝqqǝn ǝzǝzǝd zǝwwǝran ǝn tǝhunt daɣ iri-net, itǝwǝgǝr daɣ ammas n agaraw ǝmazal wa iga ǝddi. ");
INSERT INTO ttq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Iket alɣazab ill-ay y aytedan n ǝddǝnet! Ǝddǝlilan aggotnen a t-ǝllanen tan-sisuginen ibakkadan! Illikan as ad t-ǝmǝlan ǝddǝlilan win den har faw, mišan iket alɣazab ill-ay y awedan wa dasan-d-iqqalan ǝssǝbab! ");
INSERT INTO ttq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kud ǝfus-nak madeɣ adar-nak a kay-sisuginen ibakkadan, wǝdi ǝfrǝs-tan-in, tǝgǝraq-qan-in sǝdi. Id of-ak tǝggaza aljannat tǝgeɣ ǝfus, madeɣ tǝgeɣ adar y ad tǝleɣ ǝššin fassan, d ǝššin daran, tǝtǝwǝgǝra dǝr-san daɣ Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amaran kud šat-nak a təbukat a dak-təqqəl əssəbab n igi n abakkad, wǝdi kǝkkǝrǝt-tat-du, tǝgǝraq-qat-in sǝdi, id of-ak ad tǝgeɣ šat daɣ aljannat, y ad tǝleɣ sanatat šittawen tǝtǝwǝgǝra dǝr-ǝsnat daɣ tǝmsay an Jahannama.» ");
INSERT INTO ttq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ǝnkǝdat! Ad wǝr talkim iyyan daɣ aytedan win madrornen di, fǝlas silakanaɣ-awan as angalosan-nasan ǝhân ijǝnnawan, faw ǝllan ɣur Abba-nin. ");
INSERT INTO ttq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nak Ag Aggadǝm oseɣ-du gammayaɣ aytedan win ǝxraknen y a tan-ǝɣlǝsa.» ");
INSERT INTO ttq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ma tǝnnam kawanay y awen? Awak amadan ilân temeday ǝn tilay, har daɣ-asnat tǝssǝggal iyyadda, wǝrgeɣ ad ayyu tazayat tǝmǝrwen ǝd tazayat šin hadatnen ǝdânnat, tǝzzar azǝl iswǝd i ta tǝssaggalat? ");
INSERT INTO ttq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ǝggǝyyeɣ ǝsilakanaɣ-awan âs as d-igraw tilay ta n iyyadda en, ogar tǝdǝwit ta zʼagu fǝl ǝddǝlil-net, i ta zʼagu fǝl ǝddǝlil ǝn tazayat tǝmǝrwen ǝd tazayat šin wǝr nǝssǝgǝl. ");
INSERT INTO ttq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ǝmmǝk en daɣ as abba-nawan ihân ijǝnnawan, wǝr ira ad ihlǝk waliyyan daɣ aytedan win madrornen di.» ");
INSERT INTO ttq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Igla Ɣaysa iššewal inna: «As kay-idlam amadray-nak, takkaq-qu daɣ adag a daɣ tǝmosam ɣas-nawan, tǝsassagraq-qin lahan-net. Kud za issǝsam-ak itub, wǝdi zun as amadray-nak a du-tǝgrawaɣ a kay-igmâdan. ");
INSERT INTO ttq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mišan as ugay s a dak-issǝsam, tiddawa d awedan iyyanda, madeɣ ǝššin, tǝqqǝlaq-qu. Ǝmmǝk en daɣ as \"batu kul ad taknu ǝqqimnat-as sanatat tǝgǝyyawen madeɣ karadat.\" ");
INSERT INTO ttq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amaran as ugay s ad ilkǝm y awal wa das-ǝgan aytedan win di, tǝmǝlaɣ almasalat tǝdi y Ǝlkǝnisat. As ugay s ad ilkǝm y awa das-tǝnna Ǝlkǝnisat, wǝdi ag-as iduf wa tǝgeɣ y aytedan win wǝr nǝssen Mǝššina, madeɣ tagaɣ-as iduf wa tǝgeɣ y aytedan win zarzamnen takǝsen. ");
INSERT INTO ttq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ǝggǝyyeɣ ǝsilakanaɣ-awan as arat kul wa tǝssǝxramam daɣ ǝddǝnet ta, wǝdi ijǝnnawan da a daɣ-san ixram. Amaran wa tǝssǝxlalam daɣ ǝddǝnet ta, wǝdi ijǝnnawan da a daɣ-san ixlal. ");
INSERT INTO ttq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ǝsilakanaɣ-awan deɣ âs as namardan ǝššin daɣ-wan daɣ ǝddǝnet da da ǝttaran s esǝm n Abba-nin ihân ijǝnnawan, wǝdi arat kul wa daɣ-as ǝgmayan, a dasan-t-akfu. ");
INSERT INTO ttq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Fǝlas edag wa daɣ ǝmmǝnayan ǝššin, madeɣ karad daɣ-wan s esǝm-in, wǝdi ǝssǝnat as ǝlle gar-essan ǝddi da.» ");
INSERT INTO ttq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tǝzzar ihoz-in Butros Ɣaysa issǝstan-tu inn-as: «Ǝmǝli, har mǝnǝket tăklaten as di-iwar ad ǝssurǝfa y amadray-nin a di-idlâman? Awak har ǝssayat tăklaten?» ");
INSERT INTO ttq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Inn-as Ɣaysa: «Wǝr dak-ǝnne har ǝssayat tăklaten, kalar a dak-ǝnne surǝf-as ǝssayat tǝmǝrwen ǝn tăklat har ǝssa. ");
INSERT INTO ttq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ǝmmǝk en daɣ as Taɣmar ta n jǝnnawan, tǝha ǝlmital n ǝmǝnokal ad iɣrân eklan-net, irâ ad issǝɣrǝd ǝrrǝzǝɣan-net. ");
INSERT INTO ttq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","As issǝnta, itawaɣra-du iyyan daɣ eklan en, a ɣur ila igiman ǝn giman ǝn tafelt. ");
INSERT INTO ttq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mišan akli wen wǝr ifreg ǝrruzmatan n ǝzrǝf en. Awen daɣ a fǝl omar mǝššis s a din-itǝwǝzǝnzu ǝnta ǝd taɣurǝs ǝd maddanǝs d awa ila kul, ǝqqǝlan ǝrruzmatan n ǝrrǝzǝɣan win ɣur-ǝs ila. ");
INSERT INTO ttq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tǝzzar ifataqqad ǝkli en issǝjad dat mǝššis, inn-as: \"Ag-i tǝzaydart, mǝšši, a dak-ǝrzǝmaɣ awa ɣur-i tǝleɣ kul.\" ");
INSERT INTO ttq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Arat wen eway-du ǝs mǝššis as tu-tǝggaz tǝhanint-net. Tǝzzar issoraf-as awa ɣur-ǝs ila, oyy-ay. ");
INSERT INTO ttq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Azzama a din-igmâd ǝkli wen, ifâl-in mǝššis, immǝnay d iyyan daɣ midawan-net daɣ ǝššǝɣǝl wǝr irwes ar temeday ǝn tafelt n ǝzrǝf. Tǝzzar obaz-as tarzam, inn-as: \"Ǝrzǝm-i azrǝf wa daɣ-ak ǝleɣ!\" ");
INSERT INTO ttq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tǝzzar ifataqqad ǝmidi-net wen, onsay-tu inn-as: \"Ag-i tǝzaydart, a dak-ǝrzǝma.\" ");
INSERT INTO ttq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mišan ugay ǝkli wen, isassaga fadda ǝmidi-net en daɣ kasaw y ad t-izzǝrzǝm ǝmarwas wa t-iga. ");
INSERT INTO ttq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","As ǝnayan midawan-net daɣ ǝššǝɣǝl awa igan den, ǝɣšadan man-nasan wǝllen, ǝglan ǝgan isalan win kul i mǝššis. ");
INSERT INTO ttq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tǝzzar isassaɣr-ay-du mǝššis inn-as: \"Illikan as kay amaksan! Nak ǝssorafaɣ-ak awa ɣur-ǝk ǝle kul fǝlas di-tonsayaɣ awen. ");
INSERT INTO ttq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kay da, iwâr-kay a kay-tǝggǝz tǝhanint n ǝmidi-nak, tagaɣ-as ǝhǝnǝtta zun wa dak-ǝgeɣ nak.\" ");
INSERT INTO ttq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tǝzzar iggaz alham mǝššis, isassaga akli en daɣ kasaw. Itawattaf har iɣrad arazam n awa ɣur-ǝs ila ketnet.» ");
INSERT INTO ttq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Inn-asan Ɣaysa: «Ǝmmǝk en daɣ as Abba-nin ihân ijǝnnawan wǝr dawan-z-issurǝf as imos âs akkiyyan daɣ-wan wǝr isurif s ǝwǝl iyyanda i mǝdrayan-net daɣ ǝzǝgzan.» ");
INSERT INTO ttq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Dǝffǝr as iɣrâd Ɣaysa alfaydaten šin, ifal akal ǝn Galilaya, ikka akal ǝn Yahudǝyya ihân aganna wa hadan n agarew wa n Yordan. ");
INSERT INTO ttq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ǝlkamnat-as tamattiwen aggotnen, a tanat-izuzǝy den da. ");
INSERT INTO ttq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ǝhozan-t-in Farisaytan ǝgan-as ǝsǝstan imosan tǝnagmayt, ǝnnan-as: «Awak xalal y alǝs ǝzǝmǝzzǝy ǝn tǝntut-net fǝl a iqqal ǝddǝlil?» ");
INSERT INTO ttq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Inn-asan Ɣaysa: «Wǝrgeɣ tǝɣrâm as ǝstizarat as d-ixlak Ǝmaxlak ǝddǝnet, \"ixlak-du aytedan, ixlak-kan-du ǝmosan yay ǝd tǝntay.\"» ");
INSERT INTO ttq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","«Inna: \"Adi daɣ a fǝl iffal alǝs abba-net, d anna-net, irtǝy ǝd tǝntut-net, ǝqqǝlan arat iyyanda.\"» ");
INSERT INTO ttq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","«Ǝmmǝk en daɣ as ad ib-as ǝmosan ǝššin, kalar ad ǝqqǝlan taɣǝssa iyyadda. Daɣ adi, awa issǝrtay Mǝššina a tu-wǝr-izǝmmǝzzǝy awedan.» ");
INSERT INTO ttq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ǝnnan-as: «Daɣ adi, mafel as omar ǝnnǝbi Musa ad tǝtǝwǝkfu širawt n ǝmǝzzǝy i tǝntut, tǝtǝwǝzǝmǝzzǝy?» ");
INSERT INTO ttq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Inn-asan: «Aššaddat ən tǝggǝrmǝmt a fǝl kawan-ikfa Musa turagat n ad tǝzamazzayam šidoden-nawan. Mišan arat wǝdi wǝrgeɣ ǝnta a igan ǝstizarat. ");
INSERT INTO ttq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Amaran nak ǝsilakanaɣ-awan as i izammazzayan tantut-net, a das-wǝr-nǝtǝggu meddan, izlaf iyyat, wədi ǝzzəna a iga əddi.» ");
INSERT INTO ttq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ǝnnan-as nǝttulab-net: «Adi za, kud awen daɣ a illan gǝr alǝs ǝd tǝntut, wǝdi ofa i wǝr nǝzlef fadda.» ");
INSERT INTO ttq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Inn-asan: «Awal wa, wǝrgeɣ aytedan kul ǝqbâlan-tu, kalar wǝr t-iqbel ar win ikfa Mǝššina fǝrregat n ǝlqǝbulat-net. ");
INSERT INTO ttq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Fǝlas ǝllan-tu ǝddǝlilan gaddalnen azalaf ǝmosnen as: meddan wiyyad as d-ǝhǝwan da wǝr ǝfregan azalaf, wiyyad dǝffǝr a igan ad tawazaman, ǝllân-tu deɣ win as iman-nasan as sannafranan iba n azalaf fǝl ad wǝr ǝlen daɣ ǝššǝɣǝl ar wa n Taɣmar ta n jǝnnawan. Wa ifragan ǝlqǝbulat n adi, ǝqbǝlet-tu.» ");
INSERT INTO ttq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tǝzzar a du-tawayan aytedan bararan, fǝl a tan-issǝwǝr Ɣaysa ifassan-net, ittǝr-asan. Ǝššewalan nǝttulab fǝl aytedan win den. ");
INSERT INTO ttq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mišan inn-asan Ɣaysa: «Ayyiwat bararan a di-d-akkin, a tan-in-wǝr-tǝwǝɣam fall-i; fǝlas Taɣmar ta n jǝnnawan šin aytedan win šilaten-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Issǝwar-tan ifassan-net, ittar-asan, dǝffǝr awen obaz tarrayt-net, igla. ");
INSERT INTO ttq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tǝzzar ihoz-in alǝs iyyan aynayan Ɣaysa, inn-as: «Ǝššex, ma imos arat olâɣan was as t-ǝgeɣ ad ǝgrǝwaɣ tǝmǝddurt ta tǝɣlalat?» ");
INSERT INTO ttq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Inn-as Ɣaysa: «Mafel as di-tǝsastana daɣ batu n awa olaɣan? Mǝššina ɣas a olaɣan. Amaran as tareɣ ad tǝgrǝwa tǝmǝddurt ta tǝɣlalat, tǝlkǝma y alwajiban-net.» ");
INSERT INTO ttq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Inn-as alǝs wen: «Ma mosan za alwajiban win den?» Inn-as Ɣaysa: «Adi za, ad wǝr tagaɣ iman; ad wǝr tagaɣ ǝzzǝna; ad wǝr takǝra; ad wǝr taga tǝgǝyya ǝn bahu fǝl awedan waliyyan; ");
INSERT INTO ttq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","sǝɣmǝr abba-nak d anna-nak; agu y ǝšǝqqaɣ-nak tara ta tǝgeɣ i man-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Inn-as alǝs wen: «Aratan win di kul ǝssibdadaq-qan. Ma di-in-iqqiman harwa?» ");
INSERT INTO ttq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Inn-as Ɣaysa: «As tareɣ ad tǝqqǝlaɣ awedan ikmâlan, tagla tazzanzaɣ-in tǝla-nak, takfaɣ inazzan-net i tǝlǝqqawen, ǝddi ad tǝgrǝwaɣ ǝrrǝzǝɣ a dak-z-ansin daɣ alaxirat. Dǝffǝr adi amaran tagla-du tǝlkǝmaɣ-i.» ");
INSERT INTO ttq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","As isla alǝs wen i batu ten, inkar, igla ǝɣšâdan man-net, fǝlas ǝrrǝzǝɣ aggen a ila. ");
INSERT INTO ttq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Den daɣ ad inna Ɣaysa i nǝttulab-net: «Ǝggǝyyeɣ silakanaɣ-awan as izzǝwat fǝl ǝmǝggergǝs iguz ǝn Taɣmar ta n jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Awalla, silakanaɣ-awan as ogar tǝrɣǝsay ta iga fǝl aḷam aradaɣ daɣ tǝbuday n ǝnazmay, i ta iga fǝl ǝmǝggergǝs iguz ǝn Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","As ǝslan nǝttulab y awen, isammaklal sǝr-san wǝllen, ǝnnan: «Daɣ adi, ma ifragan ad iɣlǝs daɣ tǝmsay?» ");
INSERT INTO ttq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iswad daɣ-san Ɣaysa, inn-asan: «Arat wǝdi muxal a imos ɣur aytedan, mišan ɣur Mǝššina arat kul ifrâg igi.» ");
INSERT INTO ttq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Den daɣ ad iššewal Butros inna: «Nakkanay za? Awak wǝrgeɣ noyya arat kul, nǝlkam-ak? Daɣ adi ma daɣ-na zʼagin?» ");
INSERT INTO ttq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Inn-asan Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as: As tawašašanayan aratan kul, ǝqqima nak Ag Aggadǝm daɣ adag-in, a t-imosan tǝxawit ǝn taɣmar-in di tǝlat tanaya, ǝddi kawanay a di-ǝlkamnen ad taqqamim fǝl marawat tǝxiwa ǝn taɣmar ǝd sanatat, tǝšrǝɣam i tawšeten ǝn Kǝl-Israyil an marawat ǝd sanatat. ");
INSERT INTO ttq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Awedan kul wa ifalan aɣaywan-nasan, ǝd mǝdrayan-net, ǝd tǝmǝdrayen-net, d abba-net, d anna-net ǝd bararan-net, madeɣ amaḍal-net fǝl ǝddǝlil-in, wǝdi ad igrǝw temeday n ǝnǝtfus n aratan win den, igrǝw deɣ tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","A aggen daɣ win ǝhanen eɣaf ǝmǝrǝdda, ilkâm ad ǝggǝzan ǝlǝqqam; amaran a aggen daɣ win ǝhanen ǝlǝqqam ǝmǝrǝdda, ilkâm ad ǝggǝzan eɣaf.» ");
INSERT INTO ttq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Igla Ɣaysa iššewal inna: «Ǝnta da a wa dǝr tola Taɣmar ta n jǝnnawan: A d-inkǝr awedan ilân afarag n alɣanab ǝzǝl iyyan aɣôra, ira ad idkǝl imaššaɣalan y afarag-net. ");
INSERT INTO ttq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Inamarda ǝd maššaɣalan win âs, ǝzǝl kul a tan-akfu tefelt n ǝzrǝf, tǝzzar issok-en afarag. ");
INSERT INTO ttq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","As tǝga ǝdǝgǝlšet ilas-du agamad, inay imaššaɣalan wiyyad wǝr nǝgrew ǝššǝɣǝl harwa ǝqqiman daɣ asammanay n ǝɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Inn-asan: \"Kawanay da agliwat tǝšɣǝlam daɣ afarag-in, a dawan-agaɣ ǝrruzmatan olâɣnen.\" ");
INSERT INTO ttq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ǝglan maššaɣalan, ǝkkan afarag-net. Dǝffǝr awen ilas igmad-du ɣur ammasnazal, igmad-du deɣ ǝs tazzar. Amaran i d-igmad ad agu zun awen da. ");
INSERT INTO ttq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","As tǝga takǝst zagret ilas-du agamad, inay imaššaɣalan wiyyad ǝqqimnen, inn-asan: \"Mafel tǝklâm ad tǝqqimam ǝddi, wǝr tahem wala?\" ");
INSERT INTO ttq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ǝnnan-as: \"Agaraw a wǝr nǝga i danaɣ-iššǝšɣalan.\" Inn-asan: \"Agliwat kawanay da tǝšɣǝlam daɣ afarag-in n alɣanab.\"» ");
INSERT INTO ttq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«As tuda tǝfuk, inna mǝššis n afarag wen y ǝmuzar ǝn maššaɣalan-net: \"Aɣra-du imaššaɣalan kul tǝrzǝma y akkiyyan alxaq-net. Izar ǝs win ǝdkala daɣ tilkamat, tǝssǝlkǝmaɣ ǝs win ǝdkalaɣ ǝstizarat.\" ");
INSERT INTO ttq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Osan-du win ǝssǝntanen ǝššǝɣǝl takǝst zagret, akkiyyan daɣ-san igraw tefelt n ǝzrǝf. ");
INSERT INTO ttq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dǝffǝr awen tǝssǝɣlay-du ǝs win ǝšɣalnen ǝstizarat, ǝgân iduf n as ad ǝgrǝwan a ogaran awa ǝgrawan meddan win. Mišan ǝntanay da akkiyyan daɣ-san igraw tefelt. ");
INSERT INTO ttq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","As ǝgrawan ǝrruzmatan-nasan, ǝssoɣalan tǝgna mǝššis n afarag wen. ");
INSERT INTO ttq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ǝnnan: \"Aytedan win tǝtkalaɣ ǝs tilkamat, alwaq iyyanda ɣas a ǝšɣalan, amaran tǝšaššagdaq-qan dǝr-na nakkanay a ǝklanen nǝšɣâl, tǝkaggay-ana tǝfuk.\" ");
INSERT INTO ttq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tǝzzar iššewal mǝššis n afarag y iyyan daɣ-san, inn-as: \"Ǝmidi-nin, nak wǝr dak-ǝgeɣ arat waliyyan wǝr noɣed. Wǝrge kay iman-nak a dǝr namarda fǝl tafelt iyyadda n ǝzrǝf daɣ ǝzǝl? ");
INSERT INTO ttq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Daɣ adi abǝz azrǝf wa imosan alxaq-nak, tagla. Kud nak a iran ad šaššagdaɣ alxaq-nak ǝd wa n meddan win ǝtkalaɣ daɣ tilkamat, tǝdi nak a tǝqqal. ");
INSERT INTO ttq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Awak nak wǝr zʼagaɣ awa areɣ s ǝrrǝzǝɣan-in? Meɣ ak manjaɣ a tǝgeɣ as ǝmosaɣ alǝs olâɣan?\"» ");
INSERT INTO ttq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Inna Ɣaysa: «Ǝmmǝk en daɣ as win ǝhanen eɣaf ǝmǝrǝdda, ilkâm ad ǝggǝzan ǝlǝqqam; amaran win ǝhanen ǝlǝqqam ǝmǝrǝdda, ilkâm ad ǝggǝzan eɣaf.» ");
INSERT INTO ttq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iggǝzzay Ɣaysa, ikka Yerusalam ǝnta ǝd nǝttulab win maraw d ǝššin. Iwar dǝr-san tama, da jiwanken fǝl tarrayt, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Sǝsǝmat: Nakkanay da ǝggǝzzaynen ǝs Yerusalam da. Den daɣ ad zʼǝtǝwǝgga nak Ag Aggadǝm daɣ fassan ǝn muzaran ǝn limaman, ǝd musanan n Ǝttawret. Aytedan win a di-ǝxkǝman tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A di-agin daɣ fassan n aytedan wǝr nǝmos Kǝl-Ǝlyǝhud, a daɣ-i tajaban, ayyawanan-i šiwwit. Dǝffǝr awen attaytayan-i fǝl tǝgǝttawt, ib-i, ǝnkǝra-du daɣ tǝmattant ǝzǝl wa n karad.» ");
INSERT INTO ttq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tǝhoz-in taɣur Zabaday Ɣaysa, tǝddew ǝd maddanǝs. Tǝgaraffat y a tu-tansǝy. ");
INSERT INTO ttq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Inn-as: «Arat iyyan a tareɣ?» Tǝnn-as: «Bararan-in a n ǝššin a as daɣ-ak are a di-tagaɣ arkawal n as ad ǝggǝzan idaggan ǝtkâlnen: iyyan daɣ ǝɣil-nak, wa hadan daɣ zalgat-nak, daɣ Taɣmar-nak.» ");
INSERT INTO ttq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Inna Ɣaysa: «Wǝr tǝssenam almaɣna n arat wa tǝgmayam ǝddi. Awak tǝfrâgam a dǝr-i tǝdrǝwam alɣazab wa zʼaga daɣ alwaq wǝr nǝggug?» Ǝnnan-as: «Awalla, nǝfrâg a dǝr-ǝk tu-nǝdrǝw.» ");
INSERT INTO ttq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Inn-asan Ɣaysa: «Awalla, illikan as tǝfrâgam a dǝr-i tǝdrǝwam alɣazab wa. Mišan daɣ batu ǝn wa zʼaqqamin daɣ ǝɣil-in wala zalgat-in, wǝrgeɣ nak a t-ihakkin, kalar idaggan win di in win as tan-isammatag Abba-nin.» ");
INSERT INTO ttq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ǝslan maraw nǝttulab win hadatnen y awen, ǝššakan ǝššin mǝdrayan win den. ");
INSERT INTO ttq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tǝzzar iɣr-en-du Ɣaysa, ǝhozan-t-in, inn-asan: «Tǝssânam as imuzaran ǝn tǝmattiwen saknin tarna y aytedan win as azzaran, amaran aytedan win daɣ-san attafnen ǝlxǝkum saknin aytedan win as azzaran taɣmar. ");
INSERT INTO ttq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mišan kawanay ad wər tagim adi gar-ewwan. Kalar as ira iyyan daɣ-wan ad ilu almaqam, iqqǝlet zun amaššaɣal-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Amaran wa daɣ-wan iran tizart, iqqǝlet akli-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ǝmmǝk en daɣ as nak Ag Aggadǝm wǝr d-oseɣ ǝddǝnet y a di-ǝšɣǝlan aytedan. Kalar assa a d-ǝge y ad ǝšɣǝla y aytedan, akfa iman-nin fǝl ad sǝddǝrfeɣ ǝs tǝmattant-in aytedan aggotnen daɣ bakkadan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Igmad Ɣaysa ǝd nǝttulab-net aɣrǝm wa n Yerikaw, tǝlkâm-asan tamattay tagget. ");
INSERT INTO ttq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ǝllân mǝddǝrɣal den ǝššin, ǝqqiman fǝl afay ǝn tarrayt. Ǝslan âs Ɣaysa a itakayan den, ǝdkalan ǝmǝsli-nasan ad gannin: «Hǝnǝttǝt-anaɣ, Ǝmǝli, Ag ǝnnǝbi Dawǝd!» ");
INSERT INTO ttq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tǝsannarɣaman-asan tamattay fǝl ad affastin, mišan ǝššotan adakal ǝn maslan-nasan gannin: «Hǝnǝttǝt-anaɣ, Ǝmǝli, Ag Dawǝd!» ");
INSERT INTO ttq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Izzǝkkat Ɣaysa, iɣr-en, inn-asan: «Mas taram a dawan-t-aga?» ");
INSERT INTO ttq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ǝnnan-as: «Ǝmǝli, asawad-nanaɣ as nara agaraw-net.» ");
INSERT INTO ttq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tǝggaz tǝhanint-nasan Ɣaysa, idas šittawen-nasan. Amazay wen daɣ a tan-d-iqqal asawad-nasan, tǝzzar ǝlkaman-as. ");
INSERT INTO ttq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","As din-ihoz Ɣaysa ǝd nǝttulab-net Yerusalam, daɣ ǝnǝmihaz ǝn taɣrǝmt ta n Betfajay, dagma n ǝdɣaɣ was itawannu wa n \"Eškan ǝn Zaytun\", izammazal Ɣaysa ǝššin nǝttulab, ");
INSERT INTO ttq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","inn-asan: «Akkiwat taɣrǝmt ten dat-wan den. Tosâm-tat-in ɣas, tǝnâyam tajat tǝqqanat tǝlât ǝhulel. Ariwat-tan-du tǝlwǝyam-i-tan-du. ");
INSERT INTO ttq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","As dawan-inna awedan arat, tannim-as: \"Ǝmǝli a sǝr-san iddǝraran.\" Ǝddi a kawan-ayyu taglim dǝr-san amazay wen da.» ");
INSERT INTO ttq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Arat wa iga fǝl ad andu awal wa d-imal Mǝššina ǝs tarrayt n ǝnnǝbi as inna: ");
INSERT INTO ttq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Anniwat y ǝɣrǝm wa n Sǝyon: Ǝnǝy! Ǝmǝnokal-nak izây-kay-du. Ikna ǝsǝrǝs ǝn man-net. Iwân tâjat, ǝhulel fadda, imosan ara n ǝmudar a fǝl itamaway ǝzuk.» ");
INSERT INTO ttq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ǝglan nǝttulab ǝmmozalan awa as tan-omar Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ǝlwayan tajat d ǝhulel-net i Ɣaysa. Ǝdfaran fall-asan isǝlsa-nasan, iwan Ɣaysa ǝhulel. ");
INSERT INTO ttq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tǝgla-du tamattay tǝgget wǝllen ad tǝtissǝw i Ɣaysa isǝlsa-net fǝl tarrayt, wiyyad farrasan-du ilǝdlad tissǝwan-as-tan fǝl tarrayt. ");
INSERT INTO ttq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tamattay ta tǝlkamat i Ɣaysa, ǝd ta das-tazzarat, tǝtkâl ǝmǝsli-net tǝgannu: «Ozana! Tǝmmal y ahaya n ǝmǝnokal Dawǝd! Iga Mǝššina albaraka daɣ wa d-osan s esǝm n Ǝmǝli! Ozana! Tǝmmal i Mǝššina daɣ jǝnnawan win ǝdkalnen!» ");
INSERT INTO ttq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","As d-iggaz Ɣaysa Yerusalam, aytedan n ǝɣrǝm ketnasan nijarwayan gannin: «Ma imos alǝs en?» ");
INSERT INTO ttq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ad tǝgannu tamattay: «Adi za ǝnnǝbi Ɣaysa imosan ag ǝɣrǝm ǝn Nazaret ta n akal ǝn Galilaya.» ");
INSERT INTO ttq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iggaz Ɣaysa aɣalla wa iɣlayan Ehan wa Zǝwwǝran n Ǝlɣibada. Iɣrad daɣ-as asataɣ n aytedan kul win massatagan, harkid win mazanzan. Isabbanbay tebǝren šin fǝl sansin kǝl sanji izǝrfan-nasan, isabbanbay deɣ šisǝqqima ǝn massatagan ǝn tǝdǝbren. ");
INSERT INTO ttq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tǝzzar inn-asan: «Iktâb as: \"Ehan-in a das-itǝwǝggu esǝm ehan n ǝlɣibada.\" Kawanay amaran tǝgâm-tu \"ǝsǝlɣǝs ǝn baydagan\".» ");
INSERT INTO ttq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ǝhozan-in mǝddǝrɣal, ǝd mǝggudal Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada en da, izzozay-tan. ");
INSERT INTO ttq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mišan ǝnkaran muzaran ǝn limaman ǝd musanan n Ǝttawret ǝššakan wǝllen aratan simaklalnen win iga Ɣaysa den. Ǝššakan deɣ šiɣaraten šin taggin bararan daɣ Ehan wa Zǝwwǝran n Ǝlɣibada gannin: «Ozana! Tǝmmal y ahaya n ǝmǝnokal Dawǝd!» ");
INSERT INTO ttq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Awen a fǝl ǝnnan i Ɣaysa: «Tǝsâlla y awa gannin da?» Amaran inn-asan Ɣaysa: «Awalla. Awak teɣaray a wǝr tǝgem daɣ Ǝlkǝttaban batu ta tǝnnat: \"Kay a d-ewayan ǝs bararan, ǝd janɣayan a dak-agin tǝmmalen!\"» ");
INSERT INTO ttq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dǝffǝr awen ifal-tan Ɣaysa, igmad Yerusalam, edwa taɣrǝmt ta n Betanǝy insa daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","As affaw iqqal-du Yerusalam harwa aɣôra, ifray i gǝlǝk daɣ tarrayt. ");
INSERT INTO ttq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Inay ašǝk ǝn fig immar-t-in mišan wǝr daɣ-as in-ogez ar ifǝrkak ɣas. Tǝzzar inna y ašǝk wen: \"Tammazzaɣet d igi n aratan har faw daɣ ǝddǝnet!\" Amazay wen daɣ ad iqqur ašǝk en. ");
INSERT INTO ttq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","As ǝnayan nǝttulab-net awen, isammaklal sǝr-san, ad gannin: «Manǝmmǝk as iqqur ašǝk ǝn fig wen imi iyyanda?» ");
INSERT INTO ttq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Inn-asan Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-awan âs as tǝzzǝgzanam, wǝr tǝgem a imosan aššak, wǝrgeɣ awa ǝgeɣ y ašǝk a ɣas as za tǝfrǝgam igi-net. Kalar ad tǝfrǝgam ad tannim y adɣaɣ wa: \"Ǝgmǝd adag di tǝfǝtǝqqe daɣ agarew\", agu deɣ awen da. ");
INSERT INTO ttq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Arat kul wa tonsayam Mǝššina s ǝzǝgzan, a tu-tǝgrǝwam.» ");
INSERT INTO ttq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikka Ɣaysa Ehan wa Zǝwwǝran n Ǝlɣibada, a daɣ-as isasaɣru. Ǝhozan-t-in muzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud ǝnnan-as: «Awak ma tǝmos tarna tas tǝtaggaɣ aratan win? Ma kay-ikfan tarna ta?» ");
INSERT INTO ttq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Inn-asan Ɣaysa: «Nak da a dawan-agaɣ ǝsǝstan iyyanda. As tǝjjǝwwabam y ǝsǝstan-in, a dawan-ǝmǝla da d-ǝgrawaɣ tarna n igi n aratan win tagga da. ");
INSERT INTO ttq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ǝnta da ǝsǝstan-in: \"Awak ǝsǝlmǝɣ wa iga Yaxya aytedan daɣ aman Mǝššina a ɣur d-ifal awen meɣ aggadǝm?\"» Tǝzzar ad tinǝmǝnnin gar-essan: «As nǝnna: \"Mǝššina a ɣur d-igraw turagat n awen\", a danaɣ-annu: \"Mafel za wǝr sǝr-ǝs tǝzzǝgzanam?\" ");
INSERT INTO ttq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","As das-nǝnna amaran: \"Aggadǝm a ɣur d-igraw Yaxya tarna ten\", wǝdi a dana-tǝššǝk tamattay, fǝlas ketnet tǝkkâs aššak as Yaxya ǝnnǝbi a imos.» ");
INSERT INTO ttq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tǝzzar ǝnnan i Ɣaysa: «Wǝr nǝssen.» Inn-asan Ɣaysa: «Nak da za wǝr dawan-z-ǝmǝla wa di-ikfan tarna n igi n aratan win.» ");
INSERT INTO ttq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Igla Ɣaysa iššewal inn-asan: «Ma tǝnnam s ǝlqissat ta? Alǝs iyyan a ilan ǝššin bararan. Ihoz-in barar-net wa azzaran, inn-as: \"Aglu barar-in tǝšɣǝla daɣ afarag-nana wa n alɣanab azala.\" ");
INSERT INTO ttq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Inn-as barar-net wen: \"Wǝr di-iha adi.\" Mišan ya dǝffǝr awen, immǝgraz barar en tugǝyt ta iga y abba-net, tǝzzar igla ikka afarag-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ihoz-in alǝs wen barar-net wa n ǝššin igmay daɣ-as arat wa igmay daɣ wa azzaran. Ig-as barar-net wen aljawab igân ǝs saɣmar, inn-as: \"Awalla Abba-nin, ad akkaɣ afarag-nana!\" Mišan iqqim da wǝr t-ikka. ");
INSERT INTO ttq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Awak ma imos daɣ bararan en wa immozalan tara n abba-nasan?» Ǝnnan-as: «Adi za barar wa azzaran!» Ǝddi a dasan-inna Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-awan za as, inabazan ǝn takǝsen ǝd tǝkarwaten, da a dawan-izaran ǝtǝwǝqbal daɣ Taɣmar ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ǝnneɣ-awan adi fǝlas Yaxya, os-iwan-du, issǝkn-iwan awa kawan-iwaran ǝmǝrǝdda gar-ewwan ǝd Mǝššina, mišan wǝr sǝr-ǝs tǝzzǝgzanam. Amaran inabazan ǝn takǝsen, ǝd tǝkarwaten, ǝzzîgzanan sǝr-ǝs. Kawanay iman-nawan tǝnâyam awen, mišan wǝr sǝr-wan d-eway tǝmagrist waliyyat n arak mazalan-nawan ǝngǝm za tǝzzǝgzǝnam sǝr-ǝs.» ");
INSERT INTO ttq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sǝsǝmat y ǝlqissat iyyat tǝmosat ǝlmital: «Mǝššis n aɣaywan iyyan a inbalan alɣanab daɣ amaḍal-net, issǝɣlay-tu afarag, izzǝɣaz daɣ-as tagdayt ta daɣ itawazmu alɣanab. Issǝkras ogga ihhoken as zʼiggâr awedan wa ogazan afarag en. Tǝzzar issǝɣfar afarag-net en i magyakan wiyyad, iššokal. ");
INSERT INTO ttq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","As du-tahoz tamert ta n ǝmilǝy n alɣanab, izammazal eklan-net ǝs magyakan win ǝɣfarnen afarag-net, y a das-d-awǝyan adagar-net daɣ alɣanab. ");
INSERT INTO ttq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mišan obazan magyakan win eklan win, ǝgan y iyyan daɣ-san šiwwit, ǝgan iman ǝn wa hadan, ad ǝggaran wa n karad ǝs tǝhun har t-aba. ");
INSERT INTO ttq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ilas mǝššis n afarag izammazal sǝr-san eklan wiyyad ogarnen win den igǝt, mišan ǝgan-asan meddan win ǝɣfarnen afarag en awa daɣ ǝgan i win din-izammazal dat awen. ");
INSERT INTO ttq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tǝzǝrǝst n awen, as sǝr-san izammazal barar-net, fǝlas inna daɣ man-net: \"Dad zamas barar-in awa immikkan as ad t-ǝssǝɣmǝran!\" ");
INSERT INTO ttq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mišan as ǝnayan magyakan win barar-net namannan gar-essan: \"Ǝnta ǝddi amakkasu n afarag. Ǝndawat a tu-nanɣu kǝrǝz, ad nǝkkusǝt afarag.\" ");
INSERT INTO ttq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tǝzzar obazan-tu, ǝkkasan-tu daɣ afarag, ǝnɣan-tu kǝrǝz.» ");
INSERT INTO ttq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Inn-asan Ɣaysa: «Awak as d-osa mǝššis n afarag n alɣanab wen, ma zʼagu i magyakan n alɣanab win den?» ");
INSERT INTO ttq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jajjayen aytedan ǝnnan-as: «As d-osa za, ad iɣrǝd tenaɣay ǝn maksanan win di, issǝɣfar afarag-net i magyakan wiyyad a das-du-za-tawaynen tǝnfa daɣ tamert-net.» ");
INSERT INTO ttq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Inn-asan Ɣaysa: «Awak teɣaray a wǝr tǝgem daɣ Ǝlkǝttaban as: \"Tǝhunt ta din-ǝgaran makrasan, ǝnta a tǝqqalat tǝhunt ta tǝkbalat ehan, arat wen Ǝmǝli a d-ifal, amaran isimaklal sǝr-na\"?» ");
INSERT INTO ttq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Awen daɣ a fǝlas ǝmâlaɣ-awan as Taɣmar ta n Mǝššina a daɣ-wan tattarmas, tǝtǝwǝkfu i tamattay ta daɣ-as du-za-tawǝyat tǝnfa. ");
INSERT INTO ttq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Awedan wa udan fǝl tǝhunt ten, ad addagdag, wa fǝl tuda deɣ a tu-tǝlkǝš.» ");
INSERT INTO ttq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","As ǝslan muzaran ǝn limaman ǝd Farisaytan y ǝlmitalan win iga Ɣaysa den, ǝgran as ǝntanay a fǝl immǝgrad. ");
INSERT INTO ttq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ad gammayan ǝmmǝk was tu-za-sǝttǝrmǝsan, mišan ǝksudan tamattay, fǝlas tǝga i Ɣaysa iduf n as ǝnnǝbi a imos. ");
INSERT INTO ttq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ilas Ɣaysa ig-asan ǝlqissat iyyat tǝmosat ǝlmital, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Taɣmar ta n jǝnnawan, tǝha ǝlmital n ǝmǝnokal iyyan isassagan saksas daɣ tǝkrǝst ǝn barar-net. ");
INSERT INTO ttq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Izammazal eklan-net y ad ǝmǝlan y aytedan win as ira a d-ǝggǝzan saksas wen, mišan ugayan s a d-asin. ");
INSERT INTO ttq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ilas ǝzǝmmizǝl n eklan-net wiyyad y ad annin y aytedan win den: \"Nak sammatagaɣ imǝgura-nin, ǝgzamaɣ izǝgran-in, ǝd haran-in win ǝddǝratnen, arat kul immotag ǝmǝrǝdda, agliwat-du amaran ad nassantu saksas.\" ");
INSERT INTO ttq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mišan ǝgmadan batu-net, wiyyad ǝkkan šiwǝgas-nasan, wiyyad ǝkkan idaggan win daɣ satagan, ");
INSERT INTO ttq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","tǝzzar obazan win hadatnen inammazalan win den, ǝgan-asan taršǝxšad, ǝnɣan-tan kǝrǝz. ");
INSERT INTO ttq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iggaz alham labasan ǝmǝnokal, issǝgla sojitan-net, ǝɣradan tenaɣay ǝn maggan ǝn man win den, ǝɣradan ǝsǝqqǝd n ǝɣrǝm-nasan ketnet.» ");
INSERT INTO ttq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Tǝzzar inna y eklan-net: \"Imutag za win saksas ǝgân, mišan meddan win den, wǝr ǝhoran ǝd mǝgura win. ");
INSERT INTO ttq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Daɣ adi, agliwat takkim idaggan win daɣ ǝmmǝnaynat tarrayen, taɣrim-du aytedan kul win tǝnayam, a d-akkin saksas.\" ");
INSERT INTO ttq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tǝzzar ǝglan eklan win den, ǝɣran-du aytedan kul win ǝnayan, gǝr za win olaɣnen, wala win ǝmosnen imaksanan, har iɣrad adag wa n saksas en adanay n aytedan. ");
INSERT INTO ttq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Igla-du ǝmǝnokal y ad inǝy ǝljǝmaɣat ta du-tǝddewat den i tǝkrǝst. Inay daɣ meddan win ǝllanen den iyyan wǝr nǝlsa tabdoq tas ihor a du-tǝtǝwǝqqǝn ǝs tǝkrǝst. ");
INSERT INTO ttq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Inn-as ǝmǝnokal: \"Obaz, kay ak mas du-tǝggazaɣ edag a wǝr tǝqqena tabdoq tas ihor a du-tǝtǝwǝqqǝn ǝs tǝkrǝst?\" Wǝr du-tǝgmed tefert waliyyat imi n alǝs wen. ");
INSERT INTO ttq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Den daɣ ad inna ǝmǝnokal i maššaɣalan-net: \"Abǝzat-tu, tǝɣrǝdam kerrad ǝn daran-net ǝd fassan-net, tǝgǝram-t-in sǝdi daɣ šiyyay, daɣ adag wa daɣ hallin aytedan, ǝddâdan idǝdwan-nasan fǝl tǝmagraz.\"» ");
INSERT INTO ttq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Inna Ɣaysa: «Aytedan aggotnen a du-tawaɣranen, mišan wǝr daɣ-san ǝggǝtan win tawasanafrannen.» ");
INSERT INTO ttq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dǝffǝr awen mašawwaran Farisaytan, ad gammayan ǝmmǝk as ǝgan i Ɣaysa taftaw, ǝrân a tu-sǝssugin batu a tu-za-tagit daɣ ɣunan. ");
INSERT INTO ttq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Zammazalan-du arat daɣ nalkiman-nasan, d aytedan wiyyad ǝwarnen aganna n ǝmǝnokal Herod y ad annin i Ɣaysa: «Ǝššex, nǝssân as ǝməggi ən tidət a təmosa, amaran tǝsasaɣra ǝs tidǝt awas dana-iwar igi-net daɣ tarrayt ta n Mǝššina. Wǝr t-illa i tǝksuda daɣ awa tǝganna, fǝlas wǝr tǝzlaya daɣ almaqam n aytedan. ");
INSERT INTO ttq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Daɣ adi, nǝra daɣ-ak a dana-tǝmǝla: Awak xalal arazam n amana y ǝmǝnokal wa zǝwwǝran Qaysara, me wǝr xalal?» ");
INSERT INTO ttq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mišân igra Ɣaysa ǝššur-nasan, inn-asan: «Mafel tǝtajjarrabam-i, ǝlmunafiqan win? ");
INSERT INTO ttq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sakniwat-i tefelt n ǝzrǝf tas itawarzam amana.» Tǝzzar tǝmmeway-as-du tafelt. ");
INSERT INTO ttq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Inn-asan Ɣaysa: «Ma ilan eɣaf d esǝm win ǝwarnen tefelt ta?» ");
INSERT INTO ttq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ǝnnan-as: «In Qaysara.» Tǝzzar inn-asan Ɣaysa: «Ǝnǝyat za, agiwat i Qaysara awa kawan-issǝwar, tagim i Mǝššina awa kawan-issǝwar.» ");
INSERT INTO ttq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Isammaklal sǝr-san aljawab wen, oyyan Ɣaysa ǝglan. ");
INSERT INTO ttq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ǝzǝl wen daɣ a d-osan Sadusaytan, ǝmosnen aytedan ǝganen iduf n as wǝr tu-tǝlla tanakra dǝffǝr tǝmattant. Ǝhozan-in Ɣaysa, ǝssǝstanan-tu, ");
INSERT INTO ttq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ǝnnan-as: «Ǝššex, ǝnnǝbi Musa inna: \"As aba awedan wǝr igrew barar, wǝdi amadray-net a iwar ad izlǝf tantut ta d-oyya den, fǝl ad agu ǝzzurrǝyya y ǝmidi-net wa aba den.\"» ");
INSERT INTO ttq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","«Ǝnta nakkanay, ǝhân-anaɣ ǝssa mǝdrayan. Izlaf wa dasan-waššaran ketnasan, aba-tu da wǝr ila barar, oyya-du tantut-net y amadray-net. ");
INSERT INTO ttq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iga awen da fǝl amadray-net wen, igraw wa n karad, xasil a tat-zallafan itiba-tan da wǝr dǝr-ǝs ǝlen bararan, har ǝɣradan fǝl ǝssa-essan. ");
INSERT INTO ttq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dǝffǝr as tan-aba ketnasan, aba tantut ten. ");
INSERT INTO ttq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Daɣ adi ǝzǝl wa n tabadday, ma imos daɣ ǝssa mǝdrayan win den was za tǝqqǝl tǝntut ten taɣurǝs, dad zamas ketnasan ǝzlâfan-tat.» ");
INSERT INTO ttq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Inn-asan Ɣaysa: «Iket n alxata təttâfam-tu, fəlas wərmad təssanam awa ǝnnan Ǝlkǝttaban, wala deɣ təssanam awa dər togda tarna ən Məššina. ");
INSERT INTO ttq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ǝssǝnat âs əzəl wa n tabadday, wər t-illa azalaf i meddan wala šidoden. Kalar tǝmǝddurt a zʼagin šilat ən ta əgan angalosan daɣ jənnawan. ");
INSERT INTO ttq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Daɣ batu amaran ta tǝqqalat tanakra ǝn nǝmmǝttan, awak edes a kawan-wǝr-iga as tǝɣrâm awa a dawan-inna Mǝššina daɣ Ǝlkǝttaban? Wǝrgeɣ a inna: ");
INSERT INTO ttq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"Nak a imosan Ǝmǝli n Ibrahim, Ǝmǝli n Isǝhaq, Ǝmǝli ǝn Yaqub?\" Mǝššina wər imos Ǝməli ən təməxsa, kalar Ǝmǝli ǝn win ǝddarnen a imos.» ");
INSERT INTO ttq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tamattay ta tǝslat y aljawaban win den, isimaklal sǝr-ǝs wǝllen ǝsǝssǝɣri wa iga Ɣaysa den. ");
INSERT INTO ttq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","As ǝslan Farisaytan as Ɣaysa iga aljawab isifastan Sadusaytan, ǝmmǝnayan. ");
INSERT INTO ttq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Inkar iyyan daɣ-san imosan ǝmusan n ǝššǝriɣa, ira ad agu tǝnagmayt i Ɣaysa. Issǝstan Ɣaysa inn-as: ");
INSERT INTO ttq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Ǝššex, ma imos alwajib wa ogaran daɣ Ǝttawret?» ");
INSERT INTO ttq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Inn-as Ɣaysa: «Ǝnta da alwajib wa ogaran: \"Iru Ǝmǝli-nak Mǝššina s ǝwǝl iyyanda, ǝd man ǝrdânen, tireq-qu deɣ ǝs tayttay-nak kul.\" ");
INSERT INTO ttq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ǝnta da da alwajib wa ogaran alwajiban kul, imos deɣ wa azzaran. ");
INSERT INTO ttq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Amaran alwajib da wa ilkaman i wen, a dǝr-ǝs olân: \"Agu y ǝšǝqqaɣ-nak tara ta tǝgeɣ i man-nak.\" ");
INSERT INTO ttq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Alwajiban win ǝššin a, ǝntanay a daɣ iqqan arat kul wa ihan Ǝlkǝttaban.» ");
INSERT INTO ttq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ǝglan Farisaytan win den ǝllân den da, ǝmminayan. Issǝstan-tan Ɣaysa amaran, ");
INSERT INTO ttq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","inn-asan: «Ma imos iduf-nawan daɣ Ǝlmǝsix? Ma tǝnnam ma imos abba-net?» Ǝnnan-as: «Adi za Ag ǝmǝnokal ǝnnǝbi Dawǝd!» ");
INSERT INTO ttq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Inn-asan Ɣaysa: «Daɣ adi, manǝmmǝk as t-iɣra ǝnnǝbi Dawǝd ǝs tilalt n Infas wa n Mǝššina s esǝm wa n: \"Ǝmǝli\"? Fǝlas a inna: ");
INSERT INTO ttq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"Inna Ǝmǝli y Ǝmǝli-nin: 'iyyaw qamu daɣ ǝɣil-in, har ǝɣrǝdaɣ ǝsǝrǝs ǝn zǝnga-nak, agaq-qan daw daran-nak.'\" ");
INSERT INTO ttq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dad zamas iɣr-ay Dawǝd s esǝm wa n Ǝmǝli, daɣ adi manǝmmǝk as zʼiqqǝl barar-net?» ");
INSERT INTO ttq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wǝr t-illa awedan waliyyan ilfâdan i Ɣaysa wala tǝfert iyyadda n aljawab y ǝsǝstan wa iga den. Amaran a obazan ɣur ǝzǝl wen, abʼas t-illa awedan ihalan a das-agu ǝsǝstan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Den daɣ ad iššewal Ɣaysa i tamattay, ǝd nǝttulab-net, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Imusanan n Ǝttawret, ǝd Farisaytan, ǝntanay a sasaɣrinen aytedan ǝššǝriɣa wa d-oyya ǝnnǝbi Musa. ");
INSERT INTO ttq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Daɣ adi mazalat aratan kul win kawan-sasaɣrin, tabbardagam y awa dawan-gannin. Mišan ad wǝr tǝtaggim imazalan win taggin, fǝlas awa gannin, wǝr idrew arat d awa tamazalan. ");
INSERT INTO ttq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ǝzuk zǝwwǝran as izzǝwat aggay-net a sawaran aytedan, ǝntanay amaran wǝr tu-z-ǝdǝsan ǝs wala idǝdwan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imazalan-nasan kul wǝr ǝmosan ar soknit. Awen daɣ a fǝlas šira šin tǝkannaren-nasan, ǝgan-tanat ši zawwarnen wǝllen, ǝzzǝzwaran deɣ šin taqqanan daɣ tǝgǝltam-nasan, fǝl ad ilenat anay wǝllen. Šibǝnak ǝn tǝkadkaden-nasan deɣ ǝbâlan-asnat bašakšakan zagrotnen, ǝlânen anay wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ǝrân tǝɣimit daɣ daggan n aytedan win tawasaɣmarnen daɣ ǝmǝgura ǝd daggan win ǝlanen almaqam daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ǝrân a dasan-taggin aytedan assalam ǝn saɣmar daɣ sammanayan, ǝrân deɣ a tan-ɣarrin aytedan s esǝm wa n \"Ǝššex-in\".» ");
INSERT INTO ttq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Mišân kawanay, ad wǝr tagim i man-nawan esǝm wa n Ǝššex, fǝlas kawanay Ǝššex iyyanda a tǝlam, amaran ketnawan imǝdrayan a tǝmosam. ");
INSERT INTO ttq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ad wǝr tǝɣarrim deɣ iyyan daɣ-wan s esǝm wa n abba daɣ ǝddǝnet, fǝlas Abba iyyanda a tǝlam, a t-imosan: Abba wa ihan ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ad wǝr tǝraddim deɣ itawann-awan \"Ǝššex\", fǝlas Ǝššex iyyanda a tǝlam, a t-imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wa daɣ-wan imosan ǝmuzar, wǝdi ad iqqǝl zun amaššaɣal-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","I idkalan iman-net, ad t-issǝrǝs Mǝššina, i ǝssǝrasan iman-net deɣ ad t-idkǝl Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Iket alɣazab iqqâl-awan, ya imusanan n Ǝttawret, ǝd Farisaytan win ǝlmunafiqan! Kawanay a ǝmosnen y aytedan zun tǝsǝhǝrt tǝɣfâlat gar-essan ǝd Taɣmar ta n jǝnnawan. Fǝlas kawanay iman-nawan da wǝr tǝggezam Taɣmar ta n jǝnnawan, tǝgdalam deɣ iguz-net i win t-ǝranen.» ");
INSERT INTO ttq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Iket alɣazab iqqâl-awan, ya imusanan n Ǝttawret, ǝd Farisaytan win ǝlmunafiqan! Tǝttatim eharay ǝn tǝdoden šin as aba meddan-nasnat, amaran tǝtaggim imaddan zagrotnen wǝr nǝmos ar sokni. Awen daɣ a fǝlas attadib wa-nawan, ad agǝr attadiban kul tallabǝst.» ");
INSERT INTO ttq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Iket alɣazab iqqâl-awan, ya imusanan n Ǝttawret, ǝd Farisaytan win ǝlmunafiqan! Tǝšakalam, tǝssiwalam idaggan kul, fǝl amaḍal ǝd gǝrwan, tǝgâmmayam kuddeɣ awedan iyyanda tǝssǝrdam s ad ilkǝm y ǝsǝssǝɣri wa n Ǝttawret. Amaran as sǝr-ǝs tǝssǝrdam awedan, a tu-tagim aw Jahannama, har as alɣazab wa zʼagu, a d-agu ǝššin nǝdfisan fǝl wa-nawan.» ");
INSERT INTO ttq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Iket alɣazab iqqâl-awan, ya imuzaran ǝddirɣalnen! Kawanay a ganninen: As ihad awedan s Ahan wa Zǝwwǝran n Ǝlɣibada, wǝdi wǝr imos wala, mišan as ihad s urǝɣ wa ihan Ehan wa Zǝwwǝran n Ǝlɣibada, wǝdi tahuday-net tǝglâ. ");
INSERT INTO ttq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Imǝskilan ǝn mǝddǝrɣal! Awak urǝɣ a ogaran almaqam, meɣ ak edag wa zǝddigan s ǝnta a izzazdagan urǝɣ? ");
INSERT INTO ttq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Madeɣ tannim: \"As ihad awedan ǝs majmar wa zǝwwǝran n ǝsǝqqǝd ǝn tǝkutawen, wǝdi tahuday-net wǝr tǝmos wala, mišan as ihad ǝs tǝkutay ta tǝwarat majmar, wǝdi tahuday-net tǝglâ.\" ");
INSERT INTO ttq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Imǝddǝrɣal win! Awak takutay a togarat almaqam, meɣ majmar wa tat-izazdagan? ");
INSERT INTO ttq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ǝssǝnat as awedan wa ihadan ǝs majmar wa zǝwwǝran n ǝsǝqqǝd ǝn tǝkutawen, wǝdi awa iwaran majmar da ihâd sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Awedan wa ihadan s adag wa zǝddigan n Ahan wa Zǝwwǝran n Ǝlɣibada, wǝdi edag wa zǝddigan as ihâd ǝd Wa t-ihan. ");
INSERT INTO ttq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Amaran awedan wa ihadan ǝs jǝnnawan, wǝdi tǝxawit ta n taɣmar ǝn Mǝššina as ihâd, ǝd wa fall-as iqqiman.» ");
INSERT INTO ttq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Iket alɣazab iqqâl-awan ya imusanan n Ǝttawret ǝd Farisaytan win ǝlmunafiqan! Tǝtâkkasam tǝmǝssǝdǝk daɣ ǝnniɣnaɣ, ǝd ɣanit d alkemun, amaran toyyam aratan win ogarnen assahat daɣ ǝlqanun, a tan imosan: ǝššǝriɣa, tǝhanint d ǝzǝgzan. Aratan win di ǝntanay a azzarnen, iwâr-kawan a tan-tammazalam, da wǝr din-tǝglemam win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imuzaran ǝddirɣalnen! Tǝzazdaram aman y a daɣ-san tǝkkasam šizǝbbawen, amaran tǝlâmmazam aḷǝm iɣrâdan!» ");
INSERT INTO ttq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Iket alɣazab iqqâl-awan ya imusanan n Ǝttawret ǝd Farisaytan! Ǝlmunafiqan! Tǝzazdagam afalla n ǝsǝlkǝw d ǝɣǝzu, mišan ammas-nasan ijjirgan fǝlas idnay tarkǝbt d arak deranan. ");
INSERT INTO ttq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisay iddirɣalan! Zǝzdǝg tǝzzar ammas n ǝsǝlkǝw d ǝɣǝzu, ǝddi ad zʼizdag afalla-net ǝnta da.» ");
INSERT INTO ttq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Iket alɣazab iqqâl-awan ya imusanan n Ǝttawret ǝd Farisaytan win ǝlmunafiqan! Tolâm ǝd zǝkwan a fǝl tiwasalsanen arat mallan, hossayan daɣ azzahir, amaran ammas-nasan ǝdnayan-tu ɣasan ǝn nǝmmǝttan, d ǝzzǝnǝfan kul ǝn tajjarganen ǝmmîdasnen. ");
INSERT INTO ttq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ǝmmǝk en daɣ a tǝgam kawanay da. Daɣ azzahir za, toɣâdam, mišan iwallan-nawan, wǝr ǝdkeran ar tǝlmǝnufǝqa ǝd talbast.» ");
INSERT INTO ttq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Iket alɣazab iqqâl-awan ya imusanan n Ǝttawret ǝd Farisaytan win ǝlmunafiqan! Tǝkârrasam izǝkwan y ǝnnǝbitan, tǝdâllagam izǝkwan n aytedan win oɣadnen, ");
INSERT INTO ttq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","amaran tǝgannim: \"Ǝnnar du-nǝggâz azzaman win d-ǝggazan marawan-nana, wǝr dǝr-san za nǝnǝmǝnnǝk daɣ tanaɣla ta ǝgan azni n ǝnnǝbitan.\" ");
INSERT INTO ttq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ǝmmǝk en daɣ as tǝsattaddam tišit-nawan ihayawan n aytedan win ǝnɣanen ǝnnǝbitan. ");
INSERT INTO ttq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Daɣ adi sǝkkǝsǝwat awa din-ǝglaman marawan-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iket ǝn taššolen! Ǝzzǝnǝf ǝn taššolen šin iha assam wa labasan! Manǝmmǝk as za taddarragam y attadib an Jahannama? ");
INSERT INTO ttq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Awen daɣ a fǝl kawan-d-ǝssokaɣ ǝnnǝbitan, ǝd malan-ǝn-tayttay, ǝd musanan n Ǝttawret. Ad tagim iman ǝn wiyyad tattaytayam-tan fǝl tǝgǝttawen, tagim šiwwit n ǝlǝkkud i wiyyad daɣ nan-nawan win ǝlɣibada, tǝllǝmam gǝr ɣǝrman tǝdgǝzam-tan, ");
INSERT INTO ttq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","fǝl a kawan-iwǝr alxaq kul n ǝzni wa tǝwanɣalan daɣ tǝdlǝmt, a d-obazan ɣur Habila wa n alɣadil, har ǝlimam Zakarayya wa n ag Barakǝya wa tǝnɣam gǝr edag wa zǝddigan ǝd majmar wa zǝwwǝran n ǝsǝqqǝd ǝn tǝkutawen daɣ Ahan wa Zǝwwǝran n Ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ǝggǝyyeɣ ǝsilakanaɣ-awan as aratan win ǝmalaɣ ǝddi, kul ad agin fǝl aytedan n azzaman win!» ");
INSERT INTO ttq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Xa aytedan ǝn Yerusalam, iket tǝgam iman n ǝnnǝbitan, tǝnɣam deɣ ǝs tǝgur ǝn tǝhun win sǝr-wan d-izammazal Mǝššina! Awak har mǝnǝket taklaten, gammaya d a kawan-d-ǝššidǝwa s ǝmmǝk as du-tǝšadaw tǝkǝjit ikǝrǝtan-net daw ǝfrutan-net, mišan tugayam s awen! ");
INSERT INTO ttq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ǝnǝyat za, ehan-nawan ad itǝwǝyyu issûf. ");
INSERT INTO ttq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Fǝlas ǝsilakanaɣ-awan as wǝr di-za-tǝlǝsam anay a obazan ɣur ǝmǝrǝdda har ǝzǝl wad za tannim: \"Wa d-osan s esǝm n Ǝmǝli, igrâw arraxmat!\"» ");
INSERT INTO ttq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","As iɣrad Ɣaysa batuten šin den, igmad Ehan wa Zǝwwǝran n Ǝlɣibada, igla. Ǝhozan-t-in nǝttulab-net y a t-in-sassagrin tǝmǝkrust n Ahan wa Zǝwwǝran n Ǝlɣibada wen. ");
INSERT INTO ttq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mišan inn-asan Ɣaysa: «Tǝhannayam ǝkǝrrus wa? Ǝggǝyyeɣ ǝsilakanaɣ-awan as awa tǝhannayam da, ketnet wǝr daɣ-as du-z-aqqam tǝhunt tǝwârat tǝmidit-net, ketnet ad itǝwǝjǝbbǝrǝjjǝt.» ");
INSERT INTO ttq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dǝffǝr awen igla, iqqim fǝl ǝdɣaɣ wa n Eškan ǝn Zaytun. Ǝhozan-t-in nǝttulab-net ɣas-nasan, ǝnnan-as: «Ǝmǝl-anaɣ ǝmmay ad zʼagu arat wǝdi, tǝmǝlaɣ-anaɣ alɣalamat ta za tassaknit assa-nak, d ǝɣrud n ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Inn-asan Ɣaysa: «Ǝnkǝdat. A kawan-wǝr-issǝxrǝk awedan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Fǝlas aytedan aggotnen a du-z-asinen ǝttâfan esǝm-in, akkiyyan daɣ-san igannu imos Ǝlmǝsix. Amaran ad ǝssǝxrǝkan s awen aytedan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ad taslim i tǝrmuq ǝn mǝgiran, ǝd salan ǝn mǝgiran. Mišan ǝnkǝdat y a kawan-issǝrmǝɣ awen, fǝlas aratan adi as kundaba ǝgan. Mišan wǝrgeɣ ǝntanay a mosnen tǝzǝrǝst n ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ad ǝknǝsnat addawlaten gar-essanat, ǝknǝsnat taɣmaren gar-essanat. Imǝl-tu laz labâsan, ǝd nǝgǝynǝgǝyan n amaḍal daɣ daggan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mišan aratan win kul, wǝr ǝmosan ar ǝnǝtti ǝn tǝlawayt tǝhât ǝlmital ǝn ta du-tǝtizarat ǝs tǝntut tǝtaggazat amzur. ");
INSERT INTO ttq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ǝddi ad za tǝtǝwǝggim daɣ tǝssust labasat, ad tǝtawanɣim, tǝtiwagzaram daɣ tǝmattiwen n ǝddǝnet kul, fǝlas kawan-iwar esǝm-in. ");
INSERT INTO ttq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Arat wen a d-awǝy s aytedan aggotnen a tan-igmǝd ǝzǝgzan-nasan, ad tinǝmǝkǝddilan, nǝmǝgzǝran. ");
INSERT INTO ttq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ad t-ǝmǝlan ǝnnǝbitan ǝn bahu aggotnen, a zʼǝssǝxrǝknen aytedan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ad tǝtittǝy talbast har as taššam n aytedan a daɣ-san tǝfnǝz tara wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mišan wa daɣ-wan izmaran har tǝzǝrǝst, wǝdi ad iɣlǝs. ");
INSERT INTO ttq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Isalan n Ǝlinjil, imosan isalan ǝn Taɣmar ta n Mǝššina win da, ad tǝwǝmǝlan daɣ ǝddǝnet ketnet, fǝl ad aslinat tǝmattiwen kul n ǝddǝnet tǝgǝyya ta. Ǝddi amaran a du-za-tawǝd tǝzǝrǝst.» ");
INSERT INTO ttq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Igla Ɣaysa iššewal inn-asan: «As tǝnayam \"taxxaramt ta sǝksǝdat\" ta imal ǝnnǝbi Danǝyel, tǝha edag wa zǝddigan, – wǝdi wa iɣarrin, agret! – ");
INSERT INTO ttq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ǝddi aytedan win akal ǝn Yahudǝyya, addaggaganet s ǝdɣaɣan; ");
INSERT INTO ttq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Awedan wa iqqiman daɣ adag wa n afalla n ahan-net, a du-wǝr-azzabbat y a din-idkǝl ar-es ihân ehan-net. ");
INSERT INTO ttq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Awedan wa ihan tawagost-net, a du-wǝr-iqqǝl aɣaywan-net igmây isǝlsa-net! ");
INSERT INTO ttq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Iket alɣazab ad t-aginat tǝdoden šin ǝganen šidusen ǝd šin sankasnen daɣ adan win den! ");
INSERT INTO ttq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ǝgmǝyat daɣ Mǝššina a fǝl du-wǝr-imazayyat ǝdǝggǝg-nawan ǝd tamert n asamed irtayan d akonak, madeɣ ǝzǝl wa n tǝsanfawt. ");
INSERT INTO ttq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Fǝlas adan win den, a tu-tǝmǝl tǝssust labasat as, a du-tǝnta ǝddǝnet wǝr tǝtawanay ši wǝr toger; amaran wǝr ilkem deɣ ad tǝtiwanay tulat-net dǝffǝr awen. ");
INSERT INTO ttq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kundaba as adan win den ikf-en Ǝmǝli tǝzǝrǝst, wǝdi wǝr t-illa i daɣ-san du-z-irǝgan. Kalar ad tǝwǝzzǝgzǝlan fǝl ǝddǝlil n aytedan win tawasanafrannen. ");
INSERT INTO ttq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ǝddi amaran, as dawan-inna awedan: \"Ǝnǝyat! Ǝlmǝsix illa da\", madeɣ: \"Illa den\", a das-wǝr-tǝzzǝgzǝnam! ");
INSERT INTO ttq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Fǝlas ad t-ǝmǝlan ǝlmǝsixan ǝn bahu, ǝmǝlan-tu deɣ ǝnnǝbitan ǝn bahu. Ad taggin alɣalamaten simaklalnen, ǝd tǝlmǝɣjujaten ǝmmittaynen, har as ǝnnar ǝfragan awen, ǝssǝxrǝkan aytedan harkid win isannafran Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Daɣ adi ǝnkǝdat ǝd man-nawan! Aratan win, ǝgeɣ-awan-tan daw aɣaf! ");
INSERT INTO ttq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Amaran as dawan-itawanna: \"Ǝnǝyat, Ǝlmǝsix den iha teneray\", a tu-wǝr-takkim. Madeɣ itawann-awan: \"Ǝnǝyat, iha daɣ ahan edag wa ogaran ilɣi\", kaššeday, ad wǝr tǝzzǝgzǝnam wala daɣ batuten šin di. ");
INSERT INTO ttq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ǝssǝnat as, assa-nin nak Ag Aggadǝm ola d essam a du-z-assantin ǝbǝlǝzlǝz da d-inta dǝnnǝg, har da d-iraz ataram. ");
INSERT INTO ttq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Edag tǝggaz tǝmaxsayt, a daɣ-as iddawan jadaran.» ");
INSERT INTO ttq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Igla Ɣaysa iššewal, inn-asan: «Tarmâd dǝffǝr adan ǝn tǝssust ta labasat en, ad alsinat šiyyay tǝfuk, tallit deɣ igmǝd-tat ǝnnur-net, ǝrtǝkan-du etran, nǝgǝynǝgǝynat tǝxǝllak šin ǝlanen tarna daɣ jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ǝddi a du-za-tǝnǝfilǝl alɣalamat-in nak Ag Aggadǝm daɣ jǝnnawan. Šimattiwen kul n ǝddǝnet ad sǝkkirǝynat, tǝzzar ǝnǝynat-i nak Ag Aggadǝm as du-z-asa ǝheɣ šignawen, ǝkneɣ tǝla ǝn tarna ǝd tanaya. ");
INSERT INTO ttq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tǝzzar insǝɣ in asak, zǝmmizǝla nak Ag Aggadǝm angalosan-in, ǝššidǝwan-du aytedan win ǝsannafrana daɣ tǝɣǝmmar an ǝkkozat n ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Inn-asan: «Abǝzat alfaydat s ǝlmital wa n ašǝk ǝn fig. Igda ad hussǝyan lǝdlad-net, iggaz-du šin tanazra, ad tǝssǝnam as tamert ta n akasa tǝhôz. ");
INSERT INTO ttq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zund ǝmmǝk en daɣ âs as tǝnayam aratan kul win dawan-ǝmalaɣ ǝddi, tǝssǝnam as aɣrud n ǝddǝnet ihoz, wǝr illa gar-ewwan dǝr-ǝs arat. ");
INSERT INTO ttq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ǝggǝyyeɣ ǝsilakanaɣ-awan as tamattay ta da n azzaman win nǝha da, ad tǝnǝy ǝnǝtti n aratan kul win dawan-ǝmala da. ");
INSERT INTO ttq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ijǝnnawan d amaḍal ilkam ad ibʼas t-ǝllan, mišan batuten-in ǝllanat-tu har faw.» ");
INSERT INTO ttq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Igla Ɣaysa iššewal inn-asan: «Ǝzǝl amaran wala alwaq wa daɣ zʼagu awa dawan-ǝmala da, wər t-illa i daɣ-san issânan, gǝr za angalosan a əhanen ijənnawan, wala Barar iman-net. Wǝr t-illa i daɣ-san issânan ar Abba ɣas. ");
INSERT INTO ttq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Awa igan daɣ azzaman n ǝnnǝbi Nux, a zʼagin daɣ adan win daɣ du-z-asa nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tǝssânam as adan dat alwabil, aytedan tâttin, sassin, zâllafan, zâzlafan har ǝzǝl wa daɣ iggaz Nux aɣlal n aman. ");
INSERT INTO ttq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wǝr ǝgen aššak daɣ arat waliyyan, har d-ewad alwabil, iɣrad-tan ebet ketnasan. Zun awen daɣ a zʼagin ɣur assa-nin nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ǝddi ǝššin magyakan nimašɣalnen daɣ tawagost iyyadda, ad ammadkal iyyan, itǝwǝyyad-du wa hadan. ");
INSERT INTO ttq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sanatat tǝdoden taddanen daɣ adag iyyanda, ad tammadkal iyyat, tǝtǝwǝyyad-du ta hadat.» ");
INSERT INTO ttq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Inn-asan: «Daɣ adi ǝnkǝdat, fǝlas wǝr tǝssenam ǝzǝl wa daɣ du-z-asu Ǝmǝli-nawan. ");
INSERT INTO ttq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tǝssânam wǝllen âs ǝnnar issân mǝššis n aɣaywan amazay wa daɣ du-z-idǝl abaydag, ahad wǝdi ad akǝy isǝmmutǝg y a das-igdǝl terazay n ahan-net. ");
INSERT INTO ttq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Awen daɣ a fǝlas kawanay da, sǝmmutǝgat, fǝlas nak Ag Aggadǝm, a d-asa daɣ assaɣat ta wǝr tordem.» ");
INSERT INTO ttq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Igla Ɣaysa iššewal inn-asan: «Daɣ adi akli iɣdâlan, ilân ǝgǝrri, ǝnta a isannafran mǝššis izzuzǝr-tu y eklan-net win hadatnen y a tan-ihakku imensewan daɣ alwaq was ihor. ");
INSERT INTO ttq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ibbilal ǝkli wen, as d-iqqal mǝššis, ogaz-t-id iha ǝššǝɣǝl wa daq q-id-oyya den. ");
INSERT INTO ttq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ǝggǝyyeɣ ǝsilakanaɣ-awan as akli wen, ad t-izzuzǝr mǝššis i tǝla-net kul. ");
INSERT INTO ttq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mišan ǝnnar imos ark ǝkli, inna daɣ man-net: \"Mǝšši illolat-in,\" ");
INSERT INTO ttq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tǝzzar ad iggat imidawan-net, idarraw d aytedan win tamaswadnen, itinǝmǝšǝw dǝr-san esmad, ");
INSERT INTO ttq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","wǝdi ilkâm a t-id-iɣdǝr mǝššis daɣ ǝzǝl d amazay wǝr orda. ");
INSERT INTO ttq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tǝzzar ad t-iggât mǝššis har t-iksǝn, ag-ay dad tawaggin ǝlmunafiqan. Den da ad ǝllan aytedan win hallinen ǝddadan idǝdwan-nasan fǝl tǝmagraz.» ");
INSERT INTO ttq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Igla Ɣaysa iššewal i nǝttulab-net, inn-asan: «Ǝzǝl wǝdi assa ǝn Taɣmar ta n jǝnnawan, ad iggǝz ǝlmital ǝn marawat tǝmawaden wǝr nǝzday meddan, ǝdkalnen ibelan-nasnat ǝzǝl ǝn tǝkrǝst, ǝssǝlkadnat y amazlay. ");
INSERT INTO ttq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sǝmmosat daɣ-asnat za wǝr ǝlenat tayttay, sǝmmosat amaran ǝlânat-tat. ");
INSERT INTO ttq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Šin wǝr nǝla tayttay za, as ǝdkalnat ibelan-nasnat, wǝr ewaynat widi wa n ǝsǝrɣi-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Šin ǝlanen tayttay amaran, as ǝdkalnat ibelan-nasnat, ewaynat šitǝkan iha widi wa n ǝsǝrɣi-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Illolat-in amazlay, har as obaz-tanat etǝs ketnasnat. ");
INSERT INTO ttq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","As iga adawannay, tǝga-du tǝɣǝrit, itawanna: \"Amazlay ǝddi, ǝrdǝɣat-du sǝlkǝdat-as!\" ");
INSERT INTO ttq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tǝzzar ǝnkarnat-du tǝmawaden šin marawat en ketnasnat, sammatagnat ibelan-nasnat. ");
INSERT INTO ttq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ǝnnanat šin wǝr nǝla tayttay i šin hadatnen: \"Ibelan-nana ǝggazan šin tǝmattant, akfimat-ana-du daɣ widi.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ǝnnanat-asnat šin ǝlanen tayttay: \"Kala, widi-nana wǝr danaɣ-ewed dǝr-ǝkmat. Aglimat akkimat imassatagan ǝn widi tazzanzimat-du widi i belan-nakmat.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","As ǝglanat y a d-azzanzinat widi, osa-du ǝmazlay, ǝggaznat fall-as sǝmmosat tǝmawaden šin sammatagnen edag wa daɣ itaggu saksas, tǝtawahar-du tǝsǝhǝrt n ahan. ");
INSERT INTO ttq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dǝffǝr awen, ewadnat-du tǝmawaden šin hadatnen, ad saɣaratnat y amazlay, ganninat-as: \"Mandam! Mandam! Alǝm-ana!\" ");
INSERT INTO ttq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tǝzzar inn-asnat amazlay: \"Ǝggǝyyeɣ ǝsilakanaɣ as wǝr kamat-ǝzdayaɣ.\"» ");
INSERT INTO ttq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Igla Ɣaysa iššewal inn-asan: «Daɣ adi ǝnkǝdat, fǝlas wǝrmad tǝssânam ǝzǝl, za wala assaɣat ta du-z-asa.» ");
INSERT INTO ttq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Batu ta tǝqqalat Taɣmar ta n jǝnnawan, tǝha ǝlmital n alǝs išakalan. Iɣra-du eklan-net, a tan-isaɣlaf ǝrrǝzǝɣan-net. ");
INSERT INTO ttq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ikfa iyyan daɣ-san sǝmmosat tǝsǝgras ǝn dinaran n urǝɣ, ikfa wa hadan sanatat, ikfa iyyadda y ǝkli wa n karad, a daɣ ewal awen ǝs da du-tǝqqal fǝrregat-nasan, amaran iššokal. ");
INSERT INTO ttq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tarmad as igla wa issǝɣlaf sǝmmosat tǝsǝgras, iššǝšɣal urǝɣ wen, igraw-du fall-as sǝmmosat tǝsǝgras šiyyad ǝn dinaran. ");
INSERT INTO ttq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wa issǝɣlaf sanatat deɣ igla, išɣal, igraw-du fall-asnat sanatat šiyyad. ");
INSERT INTO ttq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wa wǝr nǝgrew ar tǝsǝgrǝst iyyadda, igla iga anu daɣ amaḍal inbal daɣ-as tǝsǝgrǝst ta iɣlaf den. ");
INSERT INTO ttq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","As tǝga tǝrut dǝffǝr awen, osa-du mǝššissan, ad isaɣrad ǝrrǝzǝɣan win tan-issǝɣlaf. ");
INSERT INTO ttq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ibdad-du wa issǝɣlaf sǝmmosat tǝsǝgras, eway-du sǝmmosat šin fall-asnat d iššota. Inn-as: \"Mǝšši, sǝmmosat tǝsǝgras a di-tǝssǝɣlafa, amaran ǝgrawa-du fall-asnat sǝmmosat šiyyad. Ǝntanatay da.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Inn-as mǝššis: \"Alafǝyet! Illikan as akli olâɣan a tǝmosa, tǝmosaɣ deɣ awedan ǝn tǝflǝst. Tǝssiknaɣ adi daɣ arat wǝr nǝggǝt. Dǝffǝr awa a kay-ǝssǝɣlǝfaɣ a aggen. Iyyaw taga tǝfalawist ta ǝgeɣ nak an mǝššik!\"» ");
INSERT INTO ttq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Wa issǝɣlaf sanatat tǝsǝgras deɣ ibdad-du, inna: \"Mǝšši, sanatat tǝsǝgras a di-tǝssǝɣlafa, amaran ǝgrawa-du fall-asnat sanatat šiyyad. Ǝntanatay da.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Inn-as mǝššis: \"Alafǝyet! Illikan as akli olâɣan a tǝmosa, tǝmosaɣ deɣ awedan ǝn tǝflǝst. Tǝssiknaɣ adi daɣ arat wǝr nǝggǝt. Dǝffǝr awa a kay-ǝssǝɣlǝfaɣ a aggen. Iyyaw taga tǝfalawist ta ǝgeɣ nak an mǝššik!\"» ");
INSERT INTO ttq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Dǝffǝr awen amaran, ibdad-du wa issǝɣlaf tǝsǝgrǝst iyyadda, inna: \"Mǝšši, ǝssânaɣ as alǝs labasan a tǝmosa, tǝtalaya-du ɣarat daɣ adag a daɣ wǝr tǝnbela, tǝtâlaya-du deɣ tǝnfa daɣ adag a daɣ wǝr tǝnbesaɣ amasa waliyyan. ");
INSERT INTO ttq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Adi da fǝl di-tǝggaz tasa-nak, ǝgleɣ ǝnbala tǝsǝgrǝst ta di-tǝssǝɣlafa. Ǝmǝrǝdda ǝnta da.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Inn-as mǝššis: \"Kay arak ǝkli a tǝmosa, tǝmosa deɣ anaffaraššay! Dad zamas tǝssânaɣ as ǝtâlaya-du ɣarat daɣ adag a daɣ wǝr ǝnbela, ǝtalaya-du deɣ tǝnfa daɣ adag a daɣ wǝr ǝnbesaɣ amasa waliyyan, ");
INSERT INTO ttq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wǝdi, ǝnnâr di tǝssinsaɣ azrǝf-in daɣ bank, as du-z-ǝqqǝlaɣ ǝgrâwa-du fall-as tǝttǝyt, ǝtkǝlaq-q-idu.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Inna mǝššis: \"Daɣ adi abǝzat-du daɣ-as tǝsǝgrǝst tǝdi, takfim-tat i wa ilan marawat. ");
INSERT INTO ttq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Fǝlas awedan kul wa ilan, wǝdi a das-itǝwǝšitu awa ila, annaflay, amaran wa wǝr nǝla, arat n arat wa ila da, a daɣ-as attarmas. ");
INSERT INTO ttq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akli amaran wa wǝr nǝnfa wala, ǝgǝrat-t-in dǝffǝr ahan daɣ šiyyay. Den da ad ǝllan aytedan win hallinen ǝddadan idǝdwan-nasan fǝl tǝmagraz.\"» ");
INSERT INTO ttq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Igla Ɣaysa iššewal inn-asan: «As d-ǝqqala nak Ag Aggadǝm ǝheɣ tanaya-nin, ǝddewa-du d angalosan kul, ad ǝqqama fǝl tǝxawit-in ta n tanaya. ");
INSERT INTO ttq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Šimattiwen n ǝddǝnet kul a d-idawnat, ǝbdǝdnat dat-i. A tanat-zamazzaya s ǝmmǝk as isakkat amadan ayfad-net daɣ wǝlli, ");
INSERT INTO ttq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","agaɣ ayfad daɣ ǝɣil-in, aga wǝlli daɣ zalgat-in. ");
INSERT INTO ttq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Den daɣ ad zʼanna nak an ǝmǝnokal i win ǝhanen aɣil-in: \"Ayewat kawanay win as iga Abba-nin arraxmat, ad tǝgrǝwam taɣmar ta dawan-tǝtawasamatagat harwa ɣur ǝnǝtti n ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Fǝlas iggâz-i gǝlǝk, tǝššǝtšam-i; iggâz-i fad, tǝššǝšwam-i; ǝqqalaɣ ǝnaftaɣ, tǝsammagarem-i. ");
INSERT INTO ttq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ǝẓlama, tǝssǝlsam-i; ǝrina, tǝssanam daɣ-i; ǝggazaɣ kasaw, tǝssǝslamam-i-in.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Den daɣ a di-z-annin aytedan win oɣadnen: \"Ǝmǝli, ǝmmay a kay-nǝnay ih-ik gǝlǝk nǝššǝtš-ik, wala ih-ik fad, nǝššǝšǝw-ik? ");
INSERT INTO ttq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ǝmmay kay-nǝnay tǝmosaɣ ǝnaftaɣ nǝsammagarat-kay, wala tǝẓlâma nǝssǝls-ik? ");
INSERT INTO ttq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ǝmmay kay-nǝnay tǝrina, wala taheɣ kasaw, ǝngǝm nǝssǝn daɣ-ak, wala nǝssǝslǝm-kay-in?\" ");
INSERT INTO ttq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Den daɣ a dasan-z-anna nak an ǝmǝnokal: \"Ǝggǝyyeɣ ǝsilakanaɣ-awan as dad zamas tǝgâm aratan win di y iyyanda daɣ mǝdrayan-in win ǝknanen tǝmmǝdrǝyt di, wǝdi nak as tan-tǝgam.\"» ");
INSERT INTO ttq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Dǝffǝr awen amaran annaɣ i win ǝhanen zalgat-in: \"Ugagat-i imawaran ǝn tulɣant. Agliwat ǝggǝzat Jahannama, tǝtiwasamatagat y Iblis, d angalosan win das-ǝlkamnen. ");
INSERT INTO ttq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Fǝlas iggâz-i gǝlǝk, mišan wǝr di-tǝššǝtšam; iggâz-i fad, mišan wǝr di-tǝššǝšwam. ");
INSERT INTO ttq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ǝqqâlaɣ ǝnaftaɣ, mišan wǝr di-tǝsammagarem; ǝẓlama, mišan wǝr di-tǝssǝlsam. Ǝrina, ǝggaza kasaw, mišan wǝr daɣ-i tǝssenam za wǝr di-in-tǝssǝslamam.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tǝzzar annin-i: \"Ǝmǝli, ǝmmay a kay-nǝnay ih-ik gǝlǝk, wala ih-ik fad, wala tǝmosaɣ ǝnaftaɣ, wala tǝẓlama, wala tǝrina, wala tahe kasaw, nǝqqim wǝr daɣ-ak nǝssen?\" ");
INSERT INTO ttq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ǝddi a dasan-z-anna: \"Ǝggǝyyeɣ ǝsilakanaɣ-awan as, dad zamas wǝr tǝgem aratan win di y iyyanda daɣ win ǝknanen tǝmmǝdrǝyt di, wǝdi nak iman-in as tu-wǝr-tǝgem.\" ");
INSERT INTO ttq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Den da ad zʼakkin aytedan win edag n attadib iɣlâlan, win oɣadnen amaran ǝgrǝwan tǝmǝddurt ta tǝɣlalat.» ");
INSERT INTO ttq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","As iɣrad Ɣaysa alfaydaten šin kul, inna i nǝttulab-net: ");
INSERT INTO ttq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Tǝssânam as amud wa n Akkay, ab-as-in ǝššin adan, amaran ǝddi daɣ ad za tǝwǝsǝtǝrmǝsa nak Ag Aggadǝm, y ad tǝwǝtǝytǝya fǝl tǝgǝttawt.» ");
INSERT INTO ttq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","As itaggu awen imuzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud ǝddewan daɣ aɣarɣar n aɣaywan ǝn Kayif s ǝnta a imosan Ǝlimam wa Zǝwwǝran, ");
INSERT INTO ttq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ǝnamardan fǝl tǝmǝrkest tas zʼabǝzan Ɣaysa, agin iman-net. ");
INSERT INTO ttq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dǝr iga awen da ya gannin: Ad wər nagu adi daɣ adan n əmud, fǝl ad wǝr ijǝnnǝjǝrwǝy awen tamattay. ");
INSERT INTO ttq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iha Ɣaysa taɣrǝmt ǝn Betanǝy iqqim daɣ ahan ǝn Simɣon was kala a t-igraw kǝtru, ");
INSERT INTO ttq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","as du-tosa tǝntut iyyat tǝhoz-t-in daɣ amazay a daɣ isiɣamar itattu. Tantut ten teway butalay igân daɣ tǝhunt tǝknât šihussay, iha alwardi iyyan ilân almaqam wǝllen. Tǝzzar ad tǝnaqqal alwardi wen fǝl aɣaf ǝn Ɣaysa, imos awen alɣalamat ǝn saɣmar. ");
INSERT INTO ttq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","As ǝnayan nǝttulab arat wen, ǝššakan-tu wǝllen, ǝnnan: «Ma infa ǝhluk n alwardi a? ");
INSERT INTO ttq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Alwardi wa ilan almaqam a, ǝnnâr inazzan a din-itawagga azrǝf aggen, tǝwǝkfin nazzan-net i tǝlǝqqawen.» ");
INSERT INTO ttq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Igr-in Ɣaysa awen, inn-asan: «Mafəl təɣaššadam iman i tǝntut ta? Ǝmazal olâɣan a di-tǝga da; ");
INSERT INTO ttq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","fəlas šiləqqawen faw da əllânat ɣur-wan, nak amaran wərge faw əlleɣ ɣur-wan. ");
INSERT INTO ttq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Alwardi wa, tanaɣla a tu-tǝga fǝl tǝɣǝssa-nin fǝl a di-tǝsǝmmutǝg y ǝzǝkka-nin. ");
INSERT INTO ttq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ǝggǝyyeɣ ǝsilakanaɣ-awan as edag a daɣ ittǝmal Ǝlinjil daɣ ǝddǝnet ketnet, a daɣ-as attamal awa tǝga tǝntut a, tǝtǝwǝkta-du.» ");
INSERT INTO ttq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ǝzǝl wen da ad inkar iyyan daɣ nǝttulab win maraw d ǝššin igân esǝm Yahuza was itawannu Isxarǝyuti, ikka imuzaran ǝn limaman, ");
INSERT INTO ttq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","inn-asan: «Ma di-za-takfim a dawan-t-aga daɣ fassan nak iman-in?» Tǝzzar inamarda dǝr-san, ǝkfan-tu karadat tǝmǝrwen ǝn tafelt n ǝzrǝf. ");
INSERT INTO ttq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A obazan ɣur amazay wen da, ad iggaz šin agamay ǝn tamazayyat ta daɣ zʼagu Ɣaysa daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","As d-ewad ǝzǝl wa azzaran n ǝmud wa daɣ tamatšinat tǝgǝlwen šin wǝr iha xamira, ǝhozan-in nǝttulab Ɣaysa, ǝnnan-as: «Mənid tareɣ a dak-nǝsǝmmutǝg imensewan n amud wa n Akkay?» ");
INSERT INTO ttq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Inn-asan: «Ǝggǝzat aɣrǝm, takkim awedan iyyan illan den, tannim-as: \"Inn-ak Ǝššex, alwaq ǝn tǝmattant-in ihôz. Kay a ɣur za nammansaw daɣ ǝmud wa n Akkay nak ǝd nǝttulab-in.\"» ");
INSERT INTO ttq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ǝmmozalan nǝttulab awas tan-omar Ɣaysa, sammatagan imensewan win Akkay. ");
INSERT INTO ttq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","As tuda tǝfuk, inaɣama Ɣaysa ǝd nǝttulab-net an maraw d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tattin den daɣ as inna: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as, iyyan daɣ-wan a di-z-agin daɣ fassan.» ");
INSERT INTO ttq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Batu ten, teway-du sǝr-san as ǝɣšadan man-nasan wǝllen, a das-igannu akkiyyan daɣ-san: «Ǝmǝli, ǝngǝm wǝrgeɣ nak a kay-z-agin daɣ fassan?» ");
INSERT INTO ttq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Itajawwab-asan, igann-asan: «Wa di-z-agin daɣ fassan, ǝdrawa dǝr-ǝs da da daɣ ǝɣǝzu iyyanda. ");
INSERT INTO ttq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tidǝt as nak Ag Aggadǝm a di-iba s ǝmmǝk wa ǝmalan Ǝlkǝttaban daɣ batu-nin. Mišan ya, iket alɣazab ad t-agu wa di-igan nak Ag Aggadǝm daɣ fassan! Awedan wǝdi, a das-afu fadda a du-wǝr-iggez ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tǝzzar iššewal Yahuza s ǝnta a tu-z-agin daɣ fassan, inn-as: «Ǝngǝm wǝrgeɣ nak as tǝgannaɣ ǝddi, Ǝššex?» Inn-as Ɣaysa: «Kay iman-nak as tǝnneɣ adi.» ");
INSERT INTO ttq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Amazay wen daɣ a daɣ tattin den, a daɣ d-idkal Ɣaysa tagǝlla, iga igodan i Mǝššina, irza tagǝlla ten, izun-tat i nǝttulab-net, inn-asan: «Atšiwat da. Taɣǝssa-nin adi.» ");
INSERT INTO ttq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dǝffǝr awen, idkal-du tǝkabart, iga igodan i Mǝššina, ikf-asan-tat, inn-asan: «Ašwat daɣ-as ketnawan, ");
INSERT INTO ttq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","fǝlas azni-nin adi, isitaddan azni wa n arkawal ǝn tassaq gǝr Mǝššina ǝd tamattay-net. Azni wa ad inɣǝl fǝl ad ǝgrǝwan aytedan aggotnen tǝsureft ǝn bakkadan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ǝsilakanaɣ-awan as a obazan ɣur ǝmǝrǝdda wǝr zʼǝlǝsa tessay n esmad n alɣanab wa, iket wǝr d-ewed ǝzǝl wa daɣ zʼašwa wa aynayan nak dǝr-wan daɣ Taɣmar ta n Abba-nin.» ");
INSERT INTO ttq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tǝzzar ǝssǝggadan daɣ tǝmmalen a d-ǝgmadnen Azzabur, as tanat-ǝɣradan, ǝkkan adɣaɣ wa n Eškan ǝn Zaytun. ");
INSERT INTO ttq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ǝhân tarrayt den da as dasan-inna Ɣaysa: «Ahad ada, ketnawan as dawan-z-ǝqqǝlaɣ ǝssǝbab n ad iwǝliwǝl ǝzǝgzan-nawan, fǝlas ǝnnan Ǝlkǝttaban: \"Ad ǝwǝtaɣ amadan, iba-tu, tǝzzar wǝziwǝznat ayfad-net.\" ");
INSERT INTO ttq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mišan dǝffǝr ǝtǝwǝsǝnkar-in daɣ tǝmattant, a dawan-in-izaraɣ s akal wa n Galilaya, ǝqqǝlaɣ-awan daɣ-as.» ");
INSERT INTO ttq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iššewal Butros, inn-as: «Kud iwalawal əzəgzan-nasan ketnasan daɣ batu-nak, da wa-nin wər ilkem ad iwilawal.» ");
INSERT INTO ttq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Inn-as Ɣaysa: «Ǝggǝyyeɣ silakanaɣ-ak as ahad ada, as zʼaɣru ǝkǝji aɣora, tǝggâdaɣ-i har karadat tăklaten.» ");
INSERT INTO ttq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Inn-as Butros: «Kud iqqal as ǝtǝwǝnɣa kǝrǝz a za nagu nak dǝr-ǝk, da wǝr kay-z-ǝggǝda.» Ǝnnan nǝttulab ketnasan awen da. ");
INSERT INTO ttq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ewad dǝr-san Ɣaysa afarag n eškan ǝn zaytun as itawannu Gatsemanay, inn-asan: «Qamiwat ǝddi da, ad akkaɣ edag en, ad aga šiwatriwen.» ");
INSERT INTO ttq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Izzǝnkaz fall-asan Ɣaysa, iddew ǝd Butros, d ǝššin meddan ǝn maddanǝs ǝn Zabaday, tǝzzar ǝssǝntan man-net aɣšud, iššəwaš. ");
INSERT INTO ttq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Den daɣ a dasan-inna: «Awa əgan man-in daɣ aɣšud, əbukaɣ a di-aba. Ad wǝr tǝfǝlam da, ad nakǝy nak dǝr-wan.» ");
INSERT INTO ttq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tǝzzar iga fall-asan arat n ǝzǝnkǝz, issǝjad, ittar, inna: «Abba-nin, kud immikkan adi tǝssǝgǝgaɣ-i tǝkabart ta n alɣazab di! Dǝr iga awen da ya, wǝrgeɣ awa areɣ nak a itaggin, kalar awa tareɣ kay a zʼagin.» ");
INSERT INTO ttq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dǝffǝr awen iqqal-du Ɣaysa inǝttulab-net win karad en, os-en-du ǝnsân. Inna i Butros: «Daɣ adi indar-awan ad tagim alwaq iyyanda tokâyam nak dǝr-wan! ");
INSERT INTO ttq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Akǝyat, tansǝyam Məššina a kawan-oggazan daɣ jarrabatan n Iblis. Tidət as ǝṇṇǝyat n aggadəm tǝsidaran igi n awa olaɣan, mišan igdal-as rǝkkǝm ǝn tǝɣǝssa-net awen.» ");
INSERT INTO ttq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ilas əzənkəz fall-asan, ad itaggu šiwatriwen, inna: «Ya Abba-nin, kud wǝr t-illa ǝmmǝk as di-tǝɣlay tǝkabart ta n alɣazab di, kud ilzâm-i a tat-ašwa, wǝdi tagiwet tara-nak!» ");
INSERT INTO ttq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ilas iqqal-in inǝttulab-net win karad, ogaz-tan-in ǝqqâlan etǝs, fǝlas awa dasan-iga etǝs daɣ iguz ab-as ǝfragan arra ǝn šittawen-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ilas ifal-tan, ikka den, iga tǝwatray-net ta n karadat, a daɣ inna arat wa inna dat awen. ");
INSERT INTO ttq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dǝffǝr awen iqqal-du inǝttulab-net, inn-asan: «Kawanay harwa da tǝnsâm, tǝsanfim! Ǝnǝyat! Alwaq ihoz-du wa daɣ za tǝwǝgga daɣ fassan ǝn nasbakkadan nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ǝnkǝrat-in ǝndawat! Ǝnǝyat! Wa di-z-agin daɣ fassan, ewad-du.» ");
INSERT INTO ttq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iššêwal harwa da, as d-ewad Yahuza, imosan iyyan daɣ nǝttulab-net win maraw d ǝššin, iddew ǝd tǝmmattay tagget a d-ǝssiglan muzaran ǝn limaman ǝd muzaran ǝn Kǝl-Ǝlyǝhud. Tamattay ten tewây šikabiwen ǝd tǝburǝgen. ");
INSERT INTO ttq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wa tu-z-agin daɣ fassan, imâl-asan alɣalamat tas zʼitǝwǝssǝn, inn-asan: «Wa zalamme daɣ meddan en, ǝssǝnat as ǝnta, tabǝzam-tu.» ");
INSERT INTO ttq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Osa-du Yahuza ɣas, ihoz-in Ɣaysa, inn-as: «Ma tǝxlakaɣ Ǝššex?» Tǝzzar izalammat-tu. ");
INSERT INTO ttq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Inn-as Ɣaysa: «Ǝmidi-nin, arat wa kay d-ewayan, ag-ay.» Tǝzzar ewadan-du, obazan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amazay wen da a daɣ d-ilbay iyyan daɣ nǝttulab ǝn Ɣaysa takoba-net, iwat sǝr-ǝs akli n Ǝlimam wa Zǝwwǝran, ifras-du tǝmǝzzuk-net. ");
INSERT INTO ttq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tǝzzar inn-as Ɣaysa: «Suɣǝl takoba-nak tǝtǝrut, fǝlas aytedan kul win šaqqalnen ǝs takoba, takoba as zʼammatin. ");
INSERT INTO ttq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wǝr tordeɣ as ǝfrâgaɣ ad ǝgmǝya tilalt daɣ abba-nin assagl-i-du ǝmǝrǝdda a ogaran maraw gǝnan n angalosan d ǝššin? ");
INSERT INTO ttq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mišan as iga adi, mas zʼandu awa ǝnnan Ǝlkǝttaban, a ǝmalnen as awa kul ilzâm ad andu s ǝmmǝk wa da?» ");
INSERT INTO ttq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tǝzzar inna Ɣaysa i tamattay: «Mafel tosam-i-du tewâyam šikabiwen, ǝd tǝburǝgen y a di-tabǝzam, zun as tǝgmâyam ǝjajǝb iyyan n abaydag? Nak wǝrgeɣ ǝzǝl kul niɣama dǝr-wan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, sasaɣra daɣ-as, amaran wǝr di-tobezam. ");
INSERT INTO ttq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mišan ǝssǝnat as awa igan da ketnet iga fǝl ad andu awa ǝnnan Ǝlkǝttaban.» Den daɣ a t-ǝfalan nǝttulab-net ketnasan, ǝddǝggagan. ");
INSERT INTO ttq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aytedan win obaznen Ɣaysa, ewayan-tu ǝs Kayif s ǝnta a imosan Ǝlimam wa Zǝwwǝran. Ǝnta a ɣur ǝmmǝnayan musanan n Ǝttawret, ǝd muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Iga Butros i Ɣaysa lǝkkum zagren, har ewad aɣalla n aɣaywan n Ǝlimam wa Zǝwwǝran, iggaz-tu, inaɣama ǝd maššaɣalan, iswad y ad inǝy awa zʼagin. ");
INSERT INTO ttq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ǝnkaran muzaran ǝn limaman, d Asaggawar wa Zǝwwǝran ketnet, ad gammayan awedan iqqalan tǝgǝyya ǝn bahu fǝl Ɣaysa, fǝl ad ǝgrǝwan tarrayt n igi ǝn man-net. ");
INSERT INTO ttq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mišan šigǝyyawen aggotnen ǝn bahu šin fall-as taggin da, ab-asan-du daɣ-asnat ǝddǝlil issohen a fǝl itawanɣa. Xasil osanat-du tǝgǝyyawen šiyyad sanatat, ");
INSERT INTO ttq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ǝnnanat: «Awedan wa a inna: \"Ǝfrâgaɣ ǝjǝbbǝrǝjji n Ahan wa Zǝwwǝran n Ǝlɣibada ǝn Mǝššina, ǝlǝsaq-qu akaras daɣ karad adan.\"» ");
INSERT INTO ttq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tǝzzar ibdad Ǝlimam wa Zǝwwǝran, inna i Ɣaysa: «Kay wǝr tǝganna wala daɣ tǝɣǝttas šin dak-tawagginen da?» ");
INSERT INTO ttq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mišan igla Ɣaysa iffista. Ilas Ǝlimam wa Zǝwwǝran inn-as: «Ǝgmâya daɣ-ak dat Mǝššina di Iddaran, a danaɣ-tǝmǝla kud kay a imosan Ǝlmǝsix, Barar ǝn Mǝššina wala.» ");
INSERT INTO ttq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Inn-as Ɣaysa: «Awalla kay iman-nak a innan adi. Amaran ǝmâlaɣ-awan as, a obazan ɣur ǝmǝrǝdda, a di-tǝnǝyam nak Ag Aggadǝm, ǝqqima daɣ ǝɣil n Ǝmǝli ǝn Tarna, tǝnǝyam-i deɣ ǝzaya-du, ǝwâra šigaraken a n jǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tǝzzar izazzarrat Ǝlimam wa Zǝwwǝran takatkat-net fǝl awa ǝgan man-net daɣ aɣšud, inna: «Alǝs wa amadraw a iga i Mǝššina. Awak ma nəkka i tǝgǝyyawen šiyyad? Wǝr tǝsǝllim y ǝmadraw wa iga da? ");
INSERT INTO ttq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ma tǝnnam?» Ǝnnan-as ketnasan: «Alǝs wa, ǝššǝriɣa-net tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tǝzzar ad sutufan fǝl udǝm-net, ǝggâtan-tu, taqqasan-as, ");
INSERT INTO ttq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","gannin-as: «Ǝlmǝsix, dad zamas kay ǝnnǝbi, ǝmǝl-ana wa kay-iggatan!» ");
INSERT INTO ttq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","As itaggu awen, Butros iqqim dat ahan, daɣ aɣalla n aɣaywan wen. Tǝhoz-t-in tǝmaššaɣalt iyyat n aɣaywan en da, tǝnn-as: «Kay da, tǝtidawaɣ ǝd Ɣaysa wa n akal ǝn Galilaya.» ");
INSERT INTO ttq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mišan iggad Butros awen dat aytedan kul, inna: «Wǝr ǝssenaɣ almaɣna ǝn batu-nam.» ");
INSERT INTO ttq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tǝzzar idag Butros sa sǝr ǝmi n aɣaywan, tǝnay-tu tǝmaššaɣalt iyyat, tǝnna y aytedan win ǝllanen den: «Alǝs wen, itidaw ǝd Ɣaysa wa n aɣrǝm ǝn Nazaret.» ");
INSERT INTO ttq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ilas iggad-tu ihad inna: «Wǝr ǝzdayaɣ alǝs wen.» ");
INSERT INTO ttq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","As iga arat n amazay dǝffǝr awen, ǝhozan-du meddan wiyyad ǝbdâdnen den, ǝnnan i Butros: «Illikan as kay da iyyan daɣ aytedan win daɣ den a tǝmosa, fǝlas awal-nak da immûn.» ");
INSERT INTO ttq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tǝzzar ad ihhad Butros igannu: «Mǝššina ya tǝlɣânaɣ-i kud bahu a ǝgeɣ as wǝr ǝzdayaɣ alǝs wen.» Amazay wen daɣ ad iɣra ǝkǝji aɣora. ");
INSERT INTO ttq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ikta-du Butros tǝnna ta das-iga Ɣaysa: «Dat taɣaray n ǝkǝji aɣora, a di-tunkara har karadat taklaten.» Tǝzzar igmad sǝdi, ad ihallu fǝl awa iga daɣ tǝmǝgraz. ");
INSERT INTO ttq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","As affaw aɣôra, immǝnay asaggawar ǝn muzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud ketnasan, ad taggin šinaden daɣ batu ǝn Ɣaysa y a das-tǝtǝwǝxkǝm tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ǝkradan-tu, ewayan-tu s ǝnaxkim Bilatǝs. ");
INSERT INTO ttq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yahuza wa igan Ɣaysa daɣ fassan, as inay as Ɣaysa itawaxkam-as attadib ǝn tǝmattant, udanat daɣ-as tǝmǝgraz, eway-du karadat tǝmǝrwen ǝn tafelt n ǝzrǝf šin igraw y tanat-issuɣal i muzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Inn-asan: «Nak ǝgeɣ abakkad. Awedan wǝr nǝɣšed wala, a ǝge daɣ fassan, y ad itǝwǝnɣu!» Mišan ǝnnan-as: «Nakkanay wǝr nǝzlay daɣ tǝdi! Batu tǝdi kay a tǝqqal!» ");
INSERT INTO ttq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Igar Yahuza azrǝf wen daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, igla, iššolay iman-net ašǝk. ");
INSERT INTO ttq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ǝkkǝmmen-du muzaran ǝn limaman azrǝf wen, ǝnnan: «Ǝššǝriɣa-nana issixǝram fall-ana igi n ǝzrǝf wa daɣ ǝssǝnduq wa iha ǝrrǝzǝɣ n Ahan wa Zǝwwǝran n Ǝlɣibada, fǝlas azrǝf wa azni a d-igmad.» ");
INSERT INTO ttq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ǝgan šinaden, ǝzzǝnzan daɣ ǝzrǝf wen tawagost as itawannu: «Tawagost n akanaw», y a tat-agin edag ǝn zǝkwan n aytedan win wǝr ila akal. ");
INSERT INTO ttq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Awen daɣ a fǝlas tawagost ten, har azalada itawann-as: «Tawagost ta n ǝzni.» ");
INSERT INTO ttq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ǝmmǝk en daɣ as inda awal wa iga ǝnnǝbi Irmǝya, as inna: «Ǝdkalan-du karadat tǝmǝrwen ǝn tafelt, ǝmosnen ǝlqimat tas t-ǝdkadan maddanǝs n Israyil. ");
INSERT INTO ttq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ǝzzǝnzan sǝr-ǝsnat tawagost ta n akanaw, s ǝmmǝk was di-omar Ǝmǝli.» ");
INSERT INTO ttq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Itawasabdad Ɣaysa dat ǝnaxkim Bilatǝs. Issǝstan-tu ǝnaxkim, inn-as: «Awak kay daɣ a imosan ǝmǝnokal ǝn Kǝl-Ǝlyǝhud?» Inn-as Ɣaysa: «Kay iman-nak as tǝnneɣ adi.» ");
INSERT INTO ttq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mišan wǝr inna Ɣaysa wala daɣ batu ǝn lahanan win t-ǝssǝwaran muzaran ǝn limaman ǝd muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tǝzzar inn-as Bilatǝs: «Wǝr tǝsǝlla i lahanan aggotnen win kay-ǝssǝwaran aytedan win?» ");
INSERT INTO ttq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mišan wǝr das-inna Ɣaysa wala tǝfert iyyadda daɣ batuten šin. Arat wen isammaklal wǝllen s ǝnaxkim. ");
INSERT INTO ttq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Imos alɣadat n ǝnaxkim as id d-iɣlay ǝmud wa n Akkay ad ikkǝs amaskasaw was tara tamattay agamad. ");
INSERT INTO ttq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Azzaman en, ill-ay amaskasaw a fǝl tǝga masnat, igân esǝm Ɣaysa Barɣabbas. ");
INSERT INTO ttq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tǝzzar inna Bilatǝs y aytedan win ǝddewnen den: «Ma imos daɣ meddan win was taram a dawan-t-ǝkkǝsa? Awak Barɣabbas, me Ɣaysa was itawannu Ǝlmǝsix?» ");
INSERT INTO ttq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bilatǝs issân as aššaddat ǝn manzaɣ a fǝl ǝgan muzaran ǝn limaman Ɣaysa daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Amazay wa daɣ iqqim Bilatǝs daɣ adag wa n ǝššǝriɣa den, ǝnta as sǝr-ǝs du-tǝzammazal taɣurǝs tǝnn-as: «Alǝs di oɣâd, ad wǝr tǝggǝza batu-net, fǝlas ǝndod, ǝnâya daɣ targǝt alɣazab aggen fǝl ǝddǝlil-net.» ");
INSERT INTO ttq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ǝnkaran muzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud, ǝssǝrḍan tamattay s ad tǝgmǝy ad itǝwǝkkǝs Barɣabbas, tǝwǝkkǝsan man daɣ Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iššewal ǝnaxkim, inn-asan: «Ma imos daɣ ǝššin meddan win di was tǝram ad t-ǝkkǝsa?» Ǝnnan-as: «Barɣabbas.» ");
INSERT INTO ttq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Inn-asan Bilatǝs: «Ma zʼaga za i Ɣaysa, was itawannu Ǝlmǝsix?» Ǝnnan-as ketnasan: «Itǝwǝtǝytǝyet fǝl tǝgǝttawt!» ");
INSERT INTO ttq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mišan ya inn-asan ǝnaxkim: «Mafel za? Ma iɣšad?» Iqqal-asan awen as sahhaken imaslan-nasan wǝllen, ǝnnan: «Itǝwǝtǝytǝyet!» ");
INSERT INTO ttq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Inay Bilatǝs as wǝr d-ixǝssǝl wala daɣ awen, amaran tǝnajarwayat tǝtittǝy, idkal-du aman, iššorad sǝr-san ifassan-net dat tamattay, inna: «Nak ǝrruda daɣ ǝzni n alǝs di. Batu tǝdi kawanay a tǝqqal!» ");
INSERT INTO ttq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tǝjajjayat tamattay kul tǝnna: «Iwǝret-ana alxaq n ǝzni-net nakkanay ǝd bararan-nana!» ");
INSERT INTO ttq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tǝzzar ikkas-asan-du Bilatǝs Barɣabbas, Ɣaysa amaran isassag-as tenaɣay labasat s ǝlǝkkud, ikf-ay i sojitan y ad t-attaytayan. ");
INSERT INTO ttq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tǝzzar ewayan sojitan n ǝnaxkim Bilatǝs Ɣaysa, ǝkkan dǝr-ǝs ammas n aɣarɣar n aɣalla n ahan wa n ǝššǝriɣa. Ǝššedawan-du sojitan kul win ǝllanen den, ǝɣalayɣalayan-tu. ");
INSERT INTO ttq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ǝkkasan daɣ-as tabdoq-net, ǝssǝlsan-tu ǝbǝrnuz igan tǝzuɣay tǝsimaɣmaɣat zun wa lasan mǝnokalan, imos awen tǝhǝlǝlet daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ǝzdăn tǝkǝbbut zun ta n mǝnokalan tǝgat daɣ šǝnnanan, ǝssǝwaran-tat y aɣaf-net, ǝgan agabal ǝn telant daɣ ǝfus-net wa n ǝɣil. Tǝzzar a dat-ǝs tigǝrǝffen, taggan daɣ-as tǝmakkakkayt, gannin-as: «Oyy-ik, ǝmǝnokal ǝn Kǝl-Ǝlyǝhud!» ");
INSERT INTO ttq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A fall-as sutufan, tabazan-du agabal ǝn telant wen, ǝggatan sǝr-ǝs eɣaf-net. ");
INSERT INTO ttq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dǝffǝr as daɣ-as ǝyyǝwanan igi ǝn tǝmakkakkayt, ǝkkasan daɣ-as ǝbǝrnuz wa t-ǝssǝlsan den, ǝssoɣalan-tu isǝlsa-net, ewayan-tu y ad itǝwǝtǝytǝy. ");
INSERT INTO ttq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ǝhân tarrayt as ǝmmǝnayan ǝd Simɣon, imosan alǝs n aɣrǝm ǝn Qǝrwan, šahhaššalan-tu aggay ǝn tǝgǝttawt ta fǝl zʼitǝwǝtǝytǝy Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ewadan edag as itawannu Golgota, almaɣna n awen «Edag wa n Tǝkǝyya». ");
INSERT INTO ttq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ǝkfan-t-in esmad n alɣanab irtâyan d eẓay. Iram-tan Ɣaysa, ugay ǝs tassay-nasan. ");
INSERT INTO ttq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dǝffǝr as t-ǝttǝytayan fǝl tǝgǝttawt, ad tuzanan šibǝddaɣ-net ǝs tǝšaɣeren. ");
INSERT INTO ttq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tǝzzar ǝqqiman ewalan-tu. ");
INSERT INTO ttq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ǝššolayan dǝnnǝg aɣaf-net ǝsǝllum, a fǝl iktâb as: «Awa Ɣaysa wa n Ǝmǝnokal ǝn Kǝl-Ǝlyǝhud», imos awen arat isidaganan ǝddǝlil wa fǝl immut. ");
INSERT INTO ttq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tawataytayan dagma-net ǝššin meddan ǝn jujab ǝn baydagan. Iha iyyan aɣil-net, wa hadan zalgat-net. ");
INSERT INTO ttq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A daɣ-as tajaban aytedan win tallamen den, taggin-as arak batuten, ");
INSERT INTO ttq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gannin: «Dew! Kay wǝrgeɣ tǝnneɣ tǝfragaɣ ǝjǝbbǝrǝjji n Ahan wa Zǝwwǝran n Ǝlɣibada, tǝlasaq-qu akaras daɣ karad adan? Kud kay Barar ǝn Mǝššina tassafsaɣ iman-nak, tazzabbe-du tǝgǝttawt di!» ");
INSERT INTO ttq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ǝmmǝk en da as daɣ-as taggan muzaran ǝn limaman, ǝd musanan n Ǝttawret ǝd muzaran ǝn Kǝl-Ǝlyǝhud tamakkakkayt ǝntanay da, gannin: ");
INSERT INTO ttq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Alǝs wa isafsin aytedan, wǝr ifreg ǝsǝfsi ǝn man-net! Kud ǝnta a imosan ǝmǝnokal n Israyil, azzabbatet-du tǝgǝttawt ten! Ǝddi a sǝr-ǝs nǝzzǝgzǝn. ");
INSERT INTO ttq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iga attama-net daɣ Mǝššina. Agǝzet-tu Mǝššina ǝmǝrǝdda, kud ir-ay. Fǝlas a inna: \"Nak Barar ǝn Mǝššina a mosa.\"» ");
INSERT INTO ttq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ijujab ǝn baydagan win dagman-ǝs ǝttǝytaynen, da ǝhân šin-net s ǝmmǝk en da. ");
INSERT INTO ttq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ǝlsanat šiyyay akal ketnet, a obazan ɣur ammasnazal, har dǝffǝr tazzar. ");
INSERT INTO ttq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɣur attayan ǝn tazzar, idkal Ɣaysa ǝmǝsli-net wǝllen, inna: «Eli, Eli, lama sabaxtani?» Almaɣna n awen: \"Ǝmǝli-nin, Ǝmǝli-nin, mafel toyyeɣ-i ǝd man-in?\" ");
INSERT INTO ttq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ǝslan-as arat daɣ aytedan win ǝbdadnen den, ǝnnan: «Awen ǝnnǝbi Ilyas a iɣarru.» ");
INSERT INTO ttq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tarmad as ozal iyyan daɣ-san, idkal-du tǝduft, issǝlmaq-qat daɣ esmad n alɣanab ikkizbaran wǝllen, ittal-tat d ǝmi n alawag ǝn telant, izzal-t-in i Ɣaysa y ad ašǝw. ");
INSERT INTO ttq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mišan ǝnkaran win hadatnen ad gannin: Ayy-ay, ad nǝssǝn a d-asu Ilyas assafs-ay. ");
INSERT INTO ttq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Amazay wen da, a daɣ ilas Ɣaysa ikus n ǝmǝsli issohen, ǝgmadan-tu man. ");
INSERT INTO ttq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Assaɣat ten da a daɣ izzǝrrat əfər wa zǝwwǝran imosan anaɣer gər adag wa zəddigan əd wa ogaran tazdak daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, issǝrrat-du anaɣer wen ɣur afalla har eres. Inagaynagay amaḍal, ad tasarratnat tǝsălăten. ");
INSERT INTO ttq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ǝnnolaman zǝkwan, ǝnkaran-du nǝmǝttan aggotnen ǝmosnen inaɣbidan ǝn Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ǝgmadan-du izǝkwan. Dǝffǝr tanakra ǝn Ɣaysa, ǝggazan aɣrǝm wa zǝddigan ǝn Kǝl-Ǝlyǝhud a t-imosan Yerusalam. Inǝmmǝttan win den nifalalan y aytedan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","As inay kabtan ǝd sojitan win ogazen Ɣaysa ǝnǝgǝynǝgǝy wa iga amaḍal, d aratan win ǝganen den, tǝggaz-tan tasa zǝwwǝrat, ǝnnan: «Illikan as Barar ǝn Mǝššina awen!» ");
INSERT INTO ttq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ǝllanat tǝdoden aggotnen den, ǝbdadnen sǝdi, ǝswâdnat. Šidoden šin den harwa daɣ akal ǝn Galilaya ad ǝddewnat ǝd Ɣaysa ǝssânnat daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tǝh-enat Maryama Madǝl, ǝd Maryama ta n anna ǝn Yaqub ǝd Yusǝf, d anna ǝn maddanǝs ǝn Zabaday. ");
INSERT INTO ttq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ill-ay alǝs n ǝmǝggergǝs igân esǝm Yusǝf, n ǝɣrǝm n Arimatay, imosan iyyan daɣ mǝzzǝgzan ǝs Ɣaysa. Osa-du ɣur agadal ǝn tǝfuk, ");
INSERT INTO ttq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ikka Bilatǝs, igmay daɣ-as taɣǝssa ǝn Ɣaysa. Tǝzzar omar Bilatǝs s ad itǝwǝyyu Yusǝf awǝy taɣǝssa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Idkal Yusǝf taɣǝssa ten, ig-et daɣ šifit tǝhossayat. ");
INSERT INTO ttq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eway-tat, issǝns-et daɣ ǝzǝkka aynayan imosan akazam isisaga i man-net. Tǝzzar isaɣɣararad-du tǝhunt zǝwwǝrat, ihar sǝr-ǝs imi n ǝzǝkka, igla. ");
INSERT INTO ttq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tǝlla Maryama Madǝl den, ǝd Maryama ta hadat, ǝqqimnat daɣ tǝnǝmiwǝla n ǝzǝkka wen. ");
INSERT INTO ttq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","As iga ǝzǝl wa dǝffǝr awen, imosan ǝzǝl wa dǝffǝr ǝsǝmmutǝg n ǝzǝl wa n tǝsanfawt ǝn Kǝl-Ǝlyǝhud, ǝglan muzaran ǝn limaman, ǝd Farisaytan, ǝkkan Bilatǝs, ");
INSERT INTO ttq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ǝnnan-as: «Ya ǝmuzar, nǝkittǝw as anasbahu en harwa da iddar ad inna y aytedan: \"Dǝffǝr karad adan a du-tǝwǝsankara daɣ tǝmattant.\" ");
INSERT INTO ttq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Daɣ adi amǝr s ad itǝwigǝz ǝzǝkka wen har ǝzǝl wa n karad, fǝl a du-wǝr-asin nalkiman-net akǝran taɣǝssa-net, ad gannin y aytedan: \"Itawasankar-du daɣ tǝmattant.\" Bahu wa, as iga, ad agǝr wa azzaran.» ");
INSERT INTO ttq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Inn-asan Bilatǝs: «Ǝnta ǝddi da! Idawat ǝd tǝsǝgǝrt ǝn sojitan, tǝzǝzzigǝzam-tan ǝzǝkka ǝs tǝmǝwit tas tǝram.» ");
INSERT INTO ttq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tǝzzar ǝkkan ǝzǝkka, ǝɣfalan-tu ǝɣradan ǝzǝzzǝwi wǝllen i tǝhunt ta tu-tǝharat, zazzagazan-tu i sojitan wen den. ");
INSERT INTO ttq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dǝffǝr as okay ǝzǝl wa n tǝsanfawt ǝn Kǝl-Ǝlyǝhud, affaw aɣora n alxad, tǝgla Maryama Madǝl, ǝd Maryama ta hadat, y a d-ǝnǝynat ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ihin-in amaḍal iga ǝnǝgǝynǝgǝy issohen fǝlas iyyan daɣ angalosan n Ǝmǝli a d-izzabbe daɣ jǝnnawan, ihoz-in ǝzǝkka, isaɣɣararad tǝhunt zǝwwǝrat ta tu-tǝharat, iqqim fall-as. ");
INSERT INTO ttq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ila azzahir a n essam, tǝga tabdoq-net tǝmǝllay tǝsiraqqet. ");
INSERT INTO ttq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tǝga taysǝst daɣ sojitan win ogaznen ǝzǝkka, fǝl awa dasan-tǝga tasa daɣ iguz, zun tan-ǝgmâdan man. ");
INSERT INTO ttq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Iššewal angalos, inna i tǝdoden šin din-osanen ǝzǝkka wen: «Kamatay a kamat-wǝr-tǝggǝz tasa, fǝlas ǝssanaɣ as Ɣaysa as tǝsaggadmat wa itawataytayan fǝl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wǝr illa da, fǝlas itawasankar-du daɣ tǝmattant s ǝmmǝk was imal awen. Aglimat-du ad tǝnǝymat edag was kala a daɣ-as tǝnsa tǝɣǝssa-net, ");
INSERT INTO ttq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","taglimat tarmad tǝmǝlmat i nǝttulab-net as itawasankar-du daɣ tǝmattant. Azzar-asan-in ǝs Galilaya. Den da a tu-za-tǝnǝyam. Adi da as are a dakmat-t-anna.» ");
INSERT INTO ttq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ǝfalnat ǝzǝkka tarmad, tǝh-enat tasa, mišan ya ǝfilawasnat wǝllen, ozalnat ǝganat isalan i nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ǝglânat den da, as ǝmmǝnaynat ǝd Ɣaysa, inn-asnat: «Ma tǝxlakmat.» Ǝhoznat-t-in, gabarratnat idaran-net, ǝssǝjadnat-as. ");
INSERT INTO ttq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tǝzzar inn-asnat Ɣaysa: «A kamat-wǝr-tǝggǝz tasa! Aglimat tannimat i mǝdrayan-in, ad akkin Galilaya. Den daɣ a di-z-ǝnǝyan.» ");
INSERT INTO ttq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Harwada ǝhânat tarrayt, as d-ewadan arat daɣ sojitan win ogaznen ǝzǝkka aɣrǝm, ǝssoɣalan i muzaran ǝn limaman awa igan ketnet. ");
INSERT INTO ttq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tǝzzar ǝmmǝnayan muzaran ǝn limaman, ǝd muzaran ǝn Kǝl-Ǝlyǝhud, ǝgan šinaden, ǝkfan sojitan win azrǝf aggen. ");
INSERT INTO ttq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ǝnnan-asan: «Anniwat: \"Inǝttulab-net a d-osanen ehad, nǝnsa, okaran taɣǝssa-net.\" ");
INSERT INTO ttq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","As isla ǝnaxkim Bilatǝs arat wa, a tu-nǝsassagru awa imos, taqqamim da wǝr kawan-igrew wala.» ");
INSERT INTO ttq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ǝdkalan sojitan azrǝf, ǝmmozalan s arat wa dasan-itawannan den. Ǝlqissat ta tawazawaz daɣ Kǝl-Ǝlyǝhud, amaran har azalada suɣulan-tat. ");
INSERT INTO ttq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ǝglan nǝttulab win maraw d iyyan, ǝkkan Galilaya, ǝggǝzzayan adɣaɣ wa dǝr tan-isannamawal Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","As ǝnayan Ɣaysa, ǝssǝjadan-as. Mišan wiyyad daɣ-san ǝgan daɣ-as aššak. ");
INSERT INTO ttq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tǝzzar ihoz-tan-in Ɣaysa, iššewal-asan, inna: «Tiwakfa taɣmar kul daɣ jǝnnawan, tiwakfaq-qat deɣ fǝl amaḍal: ");
INSERT INTO ttq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Daɣ adi agliwat, takkim šimattiwen kul n ǝddǝnet tagim-tanat inalkiman-in. Salmaɣat-tan daɣ aman s esǝm n Abba, ǝd Barar, d Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sassaɣriwat-tan lǝkkum y aratan kul win as kawan-omara. Nak amaran ǝssǝnat as ǝlle ɣur-wan faw, har ǝɣrud n ǝddǝnet.»");
INSERT INTO ttq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ǝnta da təsəntit n Ǝlinjil ən Ɣaysa Ǝlməsix, Barar ən Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ǝnta en da a fəl inna ənnəbi Isayas daɣ əlkəttab-net: «Ǝnǝy za a dat-ǝk assaglaɣ anammazul-in a zʼaknin tarrayt-nak. ");
INSERT INTO ttq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Idkâl əməsli-net daɣ əsuf igannu: \"Sǝmmutǝgat abaraqqa y Ǝmǝli! Tǝsǝssiɣǝdam tarrayen dat-ǝs!\"» ");
INSERT INTO ttq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Adi da a fəl d-osa Yaxya, iggaz əsuf ad itaggu y aytedan təlxutbat, igann-asan ad tǝwǝsǝlmǝɣan daɣ aman imos awen arat issiknan tǝtubt-nasan, fǝl ad ǝgrǝwan tǝsureft ǝn bakkadan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A t-in-tasin aytedan aggotnen a din-gammadnen akal ketnet wa n Yahudǝyya d aytedan kul n əɣrəm wa n Yerusalam. Ǝtutaban daɣ bakkadan-nasan dat tamattay, isalmaq-qan daɣ aman daɣ agarew was itawannu Yordan. ");
INSERT INTO ttq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","As itaggu awen izlâg Yaxya asalsaw igân s anzadan n əmnəs, otâb s ǝsatǝb n agašek. Iddâr s əjwalan əd turawat. ");
INSERT INTO ttq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Itaggu təlxutbat, igannu i tamattay: \"A dəffər-i d-asu alǝs s awa di-iga daɣ šigrat, wər eweda wala enez y ad ara i suɣan ǝn ɣateman-net. ");
INSERT INTO ttq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nak, aman a daq-qawan salmaɣa, mišan ənta Infas Wa Zəddigan a daq-qawan zʼissəlməɣ.\" ");
INSERT INTO ttq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Adan en da a daɣ d-osa Ɣaysa, igmâd-du Nazaret təmosat taɣrəmt təhât akal ən Galilaya. Ikka edag wa daɣ isalmaɣ Yaxya aytedan daɣ agarew wa n Yordan, issəlmaq-qu Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Igmad-du Ɣaysa aman ɣas ogga ijənnawan as ənnolaman, izzəbbat-du fall-as Infas wa Zəddigan, iha šaššelan ǝn tǝdabert. ");
INSERT INTO ttq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Igmad-du əməsli ijənnawan, inna: «Kay a imosan Barar-in əkneɣ tara, təssinda-du agna-nin.» ");
INSERT INTO ttq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tamazayt tenda a daɣ issoka Infas wa Zəddigan Ɣaysa taneray. ");
INSERT INTO ttq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iga daɣ-as əkkozat təmərwen n əzəl, itajarrab-tu Iblis. Itinəmərzig əd wəxsan, əssânan daɣ-as angalosan. ");
INSERT INTO ttq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dəffər ətərməs ən Yaxya wa isalmaɣan aytedan daɣ aman, ad ikka Ɣaysa akal ǝn Galilaya, a daɣ-as immal ǝmazal wa d-ifalan Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Igannu i tamattay: \"Təmastant tənda, Taɣmar ta n Məššina təhôz. Utabat, təzzəgzənam s Ǝlinjil.\" ");
INSERT INTO ttq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ǝzəl iyyan illil Ɣaysa tagadamayt n agaraw wa n Galilaya as ogga Simɣon d amadray-net Andrawǝs, fattawan daɣ agaraw sangaytan-nasan win as tabazan kifitan, fəlas inabazan ən kifitan a əmosan. ");
INSERT INTO ttq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Inn-asan Ɣaysa: \"Ǝlkəmat-i, a kawan-aga meddan sər-i du-za-tawaynen aytedan y a tan-assafsa daɣ bakkadan-nasan.\" ");
INSERT INTO ttq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oyyan sangaytan-nasan daɣ tamazayt ten da, əlkaman-as. ");
INSERT INTO ttq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iga Ɣaysa y adag en arat n akkay, inay Yaqub d amadray-net Yaxya win maddanəs ən Zabaday, əntanay da əhân aɣlal n aman; kannin sangaytan-nasan win as tabazan kifitan. ");
INSERT INTO ttq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iɣr-en-du daɣ amazay wen da. Oyyan abba-nasan Zabaday əd maššaɣalan-net daɣ ǝɣlal, əlkaman i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ikka Ɣaysa əd nəttulab-net taɣrəmt tǝgât Kafarnahum. Ewad-du əzəl wa n tǝsanfawt ɣas, iggaz Ɣaysa ehan n əlɣibada ən Kəl-Ǝlyəhud, a daɣ-as isasaɣru. ");
INSERT INTO ttq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Isammaklal əs tamattay ǝmmǝk was itaggu ǝsǝssǝɣri-net, fəlas ig-asan əsəssəɣri n awedan ilân tanaya wər əlen musanan n Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wala a ihogan idkal alǝs iyyan iha aggǝsuf əməsli-net daɣ ahan n əlɣibada ad igannu: ");
INSERT INTO ttq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Ma daɣ-na tareɣ, Ɣaysa wa n Nazaret? Ǝngəm assa a du-təgeɣ y a danaɣ-təhləka? Ǝssânaɣ awa təmosa: Kay a imosan Ǝmizdag wa d-izammazal Məššina\". ");
INSERT INTO ttq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iharaššat-tu Ɣaysa, inn-as: \"Fastu, təgmədaɣ aləs di!\" ");
INSERT INTO ttq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Təzzar izazzakarkar aggǝsuf aləs en, izyak, igmad-tu. ");
INSERT INTO ttq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ǝhagan aytedan ketnasan ad tinəmənnin gər-essan: \"Ma imos awa? Ma təmos masnat ta wǝr nǝzday a, təddewat əd tanaya! Awedan wa, wala kǝlǝsuf əttâfan tənna-net\". ");
INSERT INTO ttq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tarmad as təwazawaz sallat ən Ɣaysa daɣ Galilaya ketnet. ");
INSERT INTO ttq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Igmad-du Ɣaysa ehan n əlɣibada ǝn Kǝl-Ǝlyǝhud ɣas, ikka ehan ǝn Simɣon d Andrawǝs iddew əd Yaqub əd Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","As itaggu awen tədaggalt ǝn Simɣon təzizalallat-tat tanaday. Os-in Ɣaysa ɣas təttəmal-as. ");
INSERT INTO ttq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Təzzar os-et-in, ibaz əfus-net, issəbdad-tat, təwat fall-as tanaday, a tan-təsiməgurit. ");
INSERT INTO ttq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","As tuda tǝfuk, a sər-əs du-tamawayan aytedan kul win ərinnen əd win əhan kǝlǝsuf. ");
INSERT INTO ttq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iddew-du əɣrəm ketnet dat əmi n ahan wen. ");
INSERT INTO ttq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Izzozay Ɣaysa aytedan aggotnen əgrawnat təwərnawen wər nola, ikkas deɣ daɣ wiyyad kǝlǝsuf aggotnen. Amaran igaddal i kǝlǝsuf en emel n awa imos, id masnat a ǝgan as ǝnta a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ǝzəl wa hadan, inkar-du Ɣaysa datazal, igmad, ikka edag issufan ad itattar. ");
INSERT INTO ttq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dəffər awen, igla Simɣon d aytedan win ɣur-əs əllanen, a das-saggadan. ");
INSERT INTO ttq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","As t-in-osan, ənnan-as: «Aytedan kul saggadan-ak.» ");
INSERT INTO ttq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Təzzar inn-asan Ɣaysa: \"Akkiwat-ana šiɣarmaten šin dana-ɣalayɣalaynen, a daɣ-asnat aga tǝlxutbat əntanatay da, fəlas adi da a fəl d-əmmozala.\" ");
INSERT INTO ttq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Illil Ɣaysa akal ən Galilaya ketnet, itaggu tǝlxutbat daɣ nan n əlɣibada ǝn Kəl-Ǝlyəhud, itakkas deɣ kǝlǝsuf daɣ aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Osa-du awedan iyyan tǝgraw tǝwǝrna ǝn kǝtru, igaraffat dat Ɣaysa, onsay-tu, inn-as: «As tareɣ adi, təfrâgaɣ a di-təzzuzəyaɣ, izdaga.» ");
INSERT INTO ttq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ihanattat-as Ɣaysa. Izzal-in əfus-net, idas-tu, inn-as: \"Areɣ adi, ǝzzəy tizdaga.\" ");
INSERT INTO ttq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Izzay awedan wen daɣ tamazayt ten da, zəddig. ");
INSERT INTO ttq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Issəllam-tu alwaq wen da, dəffər as das-irɣâm wǝllen inn-as: «Ǝnǝy za, ad wǝr tǝmǝla y awedan waliyyan arat wa igan da, amaran aglu tassaknaɣ iman-nak y ǝlimam, taga takutay ǝn tazdak ta kay-issəwar əššəriɣa n ǝnnǝbi Musa, ad iqqəl adi y aytedan tǝgǝyya ǝn təməzzəyt-nak.» ");
INSERT INTO ttq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mišan igla aləs en ɣas, iggaz šin əzəwwəziwəz ən salan n awa igan, har abʼas ifrag Ɣaysa iguz n əɣrəm hannayan-tu aytedan. Awen daɣ a fəl iggaz əsuf a daɣ-as t-in-tasin aytedan, a sər-əs du-gammadnen šisədag kul. ");
INSERT INTO ttq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Adan dəffər awen, iqqal Ɣaysa aɣrǝm ən Kafarnahum. Ǝslan aytedan as iha ehan wa daɣ isaggan ɣas, ");
INSERT INTO ttq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","əkkan-t-idu s igət, har as abʼas t-iha adag, wala ɣas dat əmi n ahan. A dasan-itaggu təlxutbat. ");
INSERT INTO ttq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Itaggu təlxutbat da da, as das-d-immeway anabdon misawayan meddan əkkoz. ");
INSERT INTO ttq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mišan orn-asan a t-in-awǝdan fəl igət n aytedan. Ǝwaran afalla ən taɣazamt, əftayan əsəfəl daɣ tənəmiwəla n adag wa iha Ɣaysa. Təzzar əssərasan-du anabdon wa daɣ təxərəbbet ta əgan den, izilallat daɣ tǝssut-net. ");
INSERT INTO ttq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","As inay Ɣaysa ǝzǝgzan-nasan, inna y anabdon wen: \"Barar-in, ibakkadan-nak tiwasarafan-ak.\" ");
INSERT INTO ttq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Awen as itag əqqiman arat daɣ musanan n Ǝttawret. Ǝslan y awa inna Ɣaysa da ɣas ad tihənzəmmen daɣ man-nasan gannin: ");
INSERT INTO ttq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Wa aləs ma t-issəhalan igi n awal wa? Arat wa, ǝmadraw. Ma ifragan əsurəf ən bakkadan ar Məššina ɣas?» ");
INSERT INTO ttq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Issan Ɣaysa daɣ tamazayt tenda awa samadranan, təzzar inn-asan: «Mafəl tətihənzəmmem adi daɣ wallan-nawan? ");
INSERT INTO ttq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma ogaran tərɣəsay gǝr ad tanna y anabdon: \"Tiwasarafan-ak bakkadan-nak\", meɣ ak a das-tanna: \"Ǝbdəd, tədkəla təssut-nak, təjəwenke\"? ");
INSERT INTO ttq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amaran, areɣ ad təssənam as nak Ag Aggadəm ǝleɣ daɣ ǝddǝnet tanaya a di-tǝšišawadat ad ǝssurǝfa y awedan ibakkadan-net.» Təzzar inna Ɣaysa y anabdon: ");
INSERT INTO ttq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ǝbdəd, tədkəla təssut-nak, takkaɣ aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ibdad alǝs wen tamazayt ten da, idkal təssut-net. Igmad ǝswâdan daɣ-as aytedan kul, isimaklal sər-san awen, əmmâlan Məššina gannan: «Wər kala ad nənay arat šilat ən wa.» ");
INSERT INTO ttq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Igmad Ɣaysa aɣrǝm, ilas tewaɣlay ən tagadamayt n agaraw wa n Galilaya. A t-in-tasin aytedan s igət, isasaɣr-en. ");
INSERT INTO ttq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ijiwankat as inay alǝs iyyan igân esǝm Lebi ag Alfay iqqim daɣ adag n ǝššǝɣǝl-net imosan ǝzǝrzǝm n ǝzrǝf ǝn takǝsen, inn-as Ɣaysa: \"Ǝlkəm-i.\" Ibdad Lebi ilkam-as. ");
INSERT INTO ttq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Innǝftaɣ Ɣaysa i Lebi. Idraw Ɣaysa ənta əd nǝttulab-net d aytedan aggotnen ǝn nǝzzǝrzam ǝn takǝsen ǝd nasbakkadan. Aytedan šilat ən win, əggətan win lakkamnen i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","As ənayan musanan n Ǝttawret ən taggayt ta n Farisaytan Ɣaysa idrâw ǝd nasbakkadan ǝd nǝzzǝrzam ǝn takǝsen, ənnan i nǝttulab-net: \"Mafǝl idarraw əlfəqqi-nawan əd nǝzzǝrzam ǝn takǝsen ǝd nasbakkadan?\" ");
INSERT INTO ttq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isl-asan Ɣaysa, inn-asan: «Aytedan win wǝr nǝla ǝɣǝli, wǝr ǝddǝraran s anasmagal, imiranan a sǝr-ǝs ǝddǝrarnen. Nak wər d-əmmozala s aytedan win ɣur iga as oɣâdan, kalar inasbakkadan as d-əmmozala y a tan-d-aɣra ǝqqǝlan inalkiman-in.» ");
INSERT INTO ttq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ǝzəl iyyan ad əzuman nəttulab ən Yaxya əd win Farisaytan, osan-du aytedan wiyyad Ɣaysa, ənnan-as: «Mafǝl tuzaman nəttulab ǝn Yaxya əd win Farisaytan, amaran win-nak wər tuzaman?» ");
INSERT INTO ttq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Inn-asan Ɣaysa: «Manəmmək as zʼaklin lagatan a ɣur illa ǝmazlay əs mawan-nasan? Kalar iket illa ɣur-san wər zʼaklin ǝs mawan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mišan ilkâm əzəl a ɣur-san zʼammadkal ǝmazlay, əzəl wədi amaran ad uzaman. ");
INSERT INTO ttq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wər t-illa i zʼiwǝtan daɣ tabdoq waššarat šikəst taynayat. As iga adi, ad təkəwənzəz šikəst tədi, tǝššit-tu tabdoq ten azarru wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wər t-illa deɣ i zʼagin esmad n əzzəbib aynayan daɣ gǝdad. Fǝlas as iga adi, ad ukafan abbaqqen, affatu daɣ esmad wǝdi, igǝdad deɣ əxšədan. Kalar esmad n əzzəbib wa aynayan ibǝyaɣ aynaynen a daɣ itawaggu.» ");
INSERT INTO ttq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ǝzəl iyyan ǝn tǝsanfawt ǝn Kǝl-Ǝlyǝhud, ijiwankat Ɣaysa ənta əd nəttulab-net daɣ təwəgas n alkama. Jiwanken nəttulab-net rassaban-du šiɣaɣanen, tattin-tanat. ");
INSERT INTO ttq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Təzzar sassagran-in Farisaytan Ɣaysa awen, ənnan-as: \"Ǝnak awa taggin nəttulab-nak! Mafel taggin arat xarâman daɣ ǝzǝl wa n tǝsanfawt?\" ");
INSERT INTO ttq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Inn-asan: «Ak teɣaray a wǝr tǝgem awa iga ǝnnǝbi Dawǝd assaɣa wad imaɣatar, təzzar iggaz-tu gǝlǝk ənta əd midawan-net? ");
INSERT INTO ttq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Awak wərgeɣ iguz a iga ehan ən Məššina daɣ azzaman win daɣ imos Abiyatar Ǝlimam wa Zəwwəran, təzzar itša daɣ təgəlwen šin əmosnen takutay tǝskâtat i Məššina, əs limaman ɣas as təxalal tattay-nasnat? Fadda ikfa daɣ-asnat imidawan-net.» ");
INSERT INTO ttq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Inn-asan deɣ: «Aggadəm wərgeɣ ənta a d-itawaxlakan fəl əddəlil n ǝssəbət, kalar ǝssəbət a du-tətawaxlakat fəl tənfa n aggadəm. ");
INSERT INTO ttq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daɣ adi nak Ag Aggadǝm a ixkaman fǝl ǝzǝl wa n tǝsanfawt.» ");
INSERT INTO ttq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ilas Ɣaysa iguz n ahan n əlɣibada ǝn Kəl-Ǝlyəhud wa n Kafarnahum. Illa aləs den as immût əfus-net. ");
INSERT INTO ttq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Təzzar əgaran daɣ-as Farisaytan šittawen y ad əssənan kud ad izzuzǝy awedan daɣ əzəl wa n təsanfawt fəl ad t-əxtəsan s awen. ");
INSERT INTO ttq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Inna Ɣaysa y aləs was immût əfus-net da: «Ǝnkər, əbdəd daɣ ammas n əljəmaɣat.» ");
INSERT INTO ttq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Amaran inna y əljəmaɣat: «Awak daɣ awa inna Ǝttawret əzəl wa n tǝsanfawt igi n arat olâɣan a daɣ-as xalalan, meɣ ak igi ən wa wər noleɣ? Awak ereg n awedan daɣ tǝmattant, meɣ ak šiyyit-net ihlək?» Wər tan-iha i das-innân arat. ");
INSERT INTO ttq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Issəlal-tan Ɣaysa asawad-net ih-ay alham, təɣšâd taɣart ta ǝgan wallan-nasan iman-net wəllen. Təzzar inna y aləs wen: «Ǝzzəl əfus-nak.» Izzal-tu, izzay iqqal əmmək-net. ");
INSERT INTO ttq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ǝgmadan Farisaytan ɣas, əkkan arat daɣ aytedan ǝn Herod, wa n ǝn ǝmǝnokal ǝn Galilaya, a dər-san tinəməšəwwiran fǝl tǝmǝwit tas zʼagin iman ən Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iddew Ɣaysa əd nəttulab-net, ikka təgadamayt n agaraw wa n Galilaya. Təddew dər-əs tamattay tagget, s iyyat akal ən Galilaya a du-təgmad, iyyat akal wa n Yahudǝyya, ");
INSERT INTO ttq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","iyyat aɣrǝm ən Yerusalam, iyyat akal n Adumay əd mədlan win əwarnen aganna wen sen n agarew wa n Yordan, iyyat imədlan win əhoznen aɣrǝm ən Tir əd wa n Sidon a du-təgmad. Aytedan win kul, tesalay n aratan win itaggu Ɣaysa a tan-du-tewayat. ");
INSERT INTO ttq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Awa təga tamattay daɣ igət, inna Ɣaysa i nǝttulab-net a das-səmmutəgan aɣlal n aman y a t-iggǝz as tu-təsas tamattay. ");
INSERT INTO ttq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Fəlas izzozay daɣ-san aytedan aggotnen, eway-du awen as fall-as tanabdaɣan aytedan kul win ərinnen, gammayan d ades-net. ");
INSERT INTO ttq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Amaran aytedan win əhan kǝlǝsuf, əntanay id ənayan Ɣaysa a das-əssəjədan, zayyakan gannin: «Kay a imosan Barar ən Məššina,» ");
INSERT INTO ttq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","mišan iraqam-asan Ɣaysa wəllen fəl amel n awa imos. ");
INSERT INTO ttq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ikka Ɣaysa afalla n adɣaɣ iyyan, iɣr-in meddan win əhanen agna-net, osan-t-in. ");
INSERT INTO ttq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Isannafran daɣ-san maraw d əššin win dǝr zʼitidaw, ig-asan esǝm inǝmmuzal. Isinafran-tan deɣ y ad əmmâlan Isalan n Ǝlinjil; ");
INSERT INTO ttq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ikf-en deɣ tarna n ikus ǝn kǝlǝsuf daɣ aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ǝntanay əddi ismawan ən maraw meddan d əššin win isannafran: Simɣon was iga esəm Butros, ");
INSERT INTO ttq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","əd Yaqub d amadray-net Yaxya win maddanəs ən Zabaday, win as iga esəm Bohanargas, almaɣna n adi: Maddanəs ən teqqaq; ");
INSERT INTO ttq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","d Andrawǝs əd Filibus əd Bartulamawǝs əd Matta əd Tuma əd Yaqub wa n ag Alfay, əd Tadday əd Simɣon was itawannu wa Isaggatakken, ");
INSERT INTO ttq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","əd Yahuza Isxarǝyuti was ənta a zʼisəttərməsan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dəffər awen, iqqal-du Ɣaysa ehan wa daɣ issǝgan daɣ Kafarnahum. Təlas fall-as tamattay tiddawt s awa təga daɣ igət, abʼas wala alwaq a daɣ igraw əs tattay ənta əd nəttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ǝslan marwan-net awen, əkkan-t-idu y ad t-əbəzan, aglin dər-əs fəlas gannin: «Awa arat a t-immaran.» ");
INSERT INTO ttq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ǝggadan-du musanan n Ǝttawret wiyyad a d-əgmadnen Yerusalam, ad gannin: «Awa Aššaytan Baɣalzabul, wa n əmənokal ǝn kǝlǝsuf a t-ihan, ənta a t-ikfan fǝrregat n ikus ǝn kǝlǝsuf daɣ aytedan.» ");
INSERT INTO ttq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Təzzar iɣr-en-du Ɣaysa, ig-asan tangalt a daɣ dasan-innâ: «Manəmmək as zʼikkəs Aššaytan daɣ aytedan kǝlǝsuf-net s ənta as əlkaman? ");
INSERT INTO ttq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Taɣmar tas ǝmmǝgaran mǝssawǝs gar-essan, tǝdi ǝbǝrǝjji a za tagu. ");
INSERT INTO ttq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aɣaywan iyyanda deɣ as ǝmmǝzrayan mǝssawǝs, wədi əbərəjji a zʼagu. ");
INSERT INTO ttq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Zun d əmmək di daɣ as, kud Aššaytan iman-net a dǝr immǝgar, wədi taɣmar-net wər za tihag. Ǝbərəjji a za tagu, təɣrəd. ");
INSERT INTO ttq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Awalla wǝr t-illa i ifrâgan iguz n ahan n alǝs n ǝmǝqqerǝd, iɣrǝd aqqa ǝn tǝla-net, ar s ad t-ikrâd təzzar. Dǝffǝr as t-ikrâd amaran ad zʼifrəg ad iɣrǝd aqqa ǝn tǝla-net. ");
INSERT INTO ttq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ǝggəyyeɣ əsilakanaɣ-awan as, wər t-illa abakkad d alfawaxiš as wər ifreg Məššina a t-issurəf y awedan ");
INSERT INTO ttq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ar alfawaxiš imosan ikus ǝn tarna y Infas wa Zəddigan, fəlas abakkad adi iɣallalan fəl awedan.» ");
INSERT INTO ttq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Batu ta ig-asan-tat Ɣaysa fəlas tənna a taggin: «Ih-ay aggǝsuf.» ");
INSERT INTO ttq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tosa-du anna ən Ɣaysa ǝd mǝdrayan-net, əbdadan dat əmi n ahan, zammazalan sər-əs awedan y a dasan-t-id-aɣru. ");
INSERT INTO ttq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Təqqim tamattay tagget ɣur Ɣaysa, təɣilayɣalay-tu as das-itawanna: «Təbdâd-ak anna-nak əd mədrayan-nak dat ahan, sastanan dər-ək.» ");
INSERT INTO ttq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Inna Ɣaysa: «Ma imosan za anna-nin, ma imosan imədrayan-in?» ");
INSERT INTO ttq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Təzzar issəlal asawad-net tamattay ta ɣur-əs təqqimat da təɣilayɣalay-tu, inna: «Ǝntanay da da anna-nin əd mədrayan-in, ");
INSERT INTO ttq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","fəlas awedan kul wa itamazalan tara ǝn Məššina, ənta a imosan amadray-nin, madeɣ tǝmadrayt-in, madeɣ anna-nin.» ");
INSERT INTO ttq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ilas Ɣaysa tewaɣlay ən təgadamayt n agaraw wa n Galilaya, ad isasaɣru aytedan. Təddew-du fall-as tamattay tagget, har as iggaz aɣlal n aman a d-ihân imi n agaraw da da, iqqim daɣ-as. Tamattay amaran ketnet təqqim-du təbdâd daɣ əsəlim n agaraw. ");
INSERT INTO ttq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A tat-isasaɣru aratan aggotnen s ǝlmitalan. Inn-asan daɣ əsəssəɣri-net: ");
INSERT INTO ttq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Səsəmat! Ǝmagyak iyyan a iglan y ad inbǝl tawagost-net. ");
INSERT INTO ttq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Daɣ anabal wa itaggu den imosan anabas n amasa, ərtaknat tǝblalen šiyyad fǝl tama ǝn tarrayt, osan-du gǝḍad ətšan-tanat. ");
INSERT INTO ttq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ǝrtaknat šiyyad daɣ amaḍal əhanat təhun. Idwal-du amasa wen tarmad fəlas wər illa daw-əs amaḍal aggen daɣ əglan kewan, ");
INSERT INTO ttq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mišan as tǝggǝzzay təfuk, illəsway, iqqur fəlas wər iha amaḍal a daɣ in zʼugagan kewan-net. ");
INSERT INTO ttq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Šiyyad ərtaknat daɣ təfəssaɣ. Ǝdwalnat tǝfǝssaɣ šin, ǝlmaznat amasa wa d-idwalan den, igdal-asnat awen ara. ");
INSERT INTO ttq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mišan ya arat daɣ təblalen en irtak daɣ amaḍal olaɣan. Igmad-du, idwal, iga šiɣaɣanen. Šiɣaɣanen-net šiyyad akkiyyat əhanat-tat karadat təmərwen ən təblalt. Šiyyad sədisat təmərwen, šiyyad temeday.» ");
INSERT INTO ttq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dəffər awen inn-asan Ɣaysa: «Wa isallin, issǝsǝmet.» ");
INSERT INTO ttq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","As tǝfal tamattay Ɣaysa, ənkaran-du nəttulab-net win maraw d əššin d aytedan wiyyad a dər-əs tidawnen, əssəstanan-tu d almaɣna n ǝlmitalan win itaggu. ");
INSERT INTO ttq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Inn-asan: «Kawanay təgrâwam masnat daɣ əssiran ǝn Taɣmar ta n Məššina, mišan aytedan win hadatnen arat kul tangalen as dasan-itatamal. ");
INSERT INTO ttq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Adi a d-ewayan as əswâdan, mišan wər hənnəyan, ǝssisaman, mišan wər gərrin. Id ənnar wər iga adi, utaban, təwəsurəfan-asan bakkadan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Inn-asan deɣ: «Awak əgərri a wər təgem wa daɣ ǝlmital? Daɣ adi manəmmək as za tagrim ǝlmitalan win hadatnen? ");
INSERT INTO ttq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ǝmagyak wa n ihogan, ǝlmital a imos n awedan immalan awal ən Məššina y aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Amasa wa irtakan fǝl tama ǝn tarrayt, ǝlmital a imos n aytedan win əslanen y awal ən Məššina mišan a d-asu Aššaytan den da ikkəs-tu daɣ wallan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amasa wa irtakan daɣ amaḍal əhanat təhun, ǝlmital a imos n aytedan win as, as əslan y awal ən Məššina ad t-ǝqbalan ǝddi da ǝs man filawasnen, ");
INSERT INTO ttq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mišan wǝr ila awen ekay. Aytedan win wǝr ǝmosan ar mǝssawǝsan ǝn tǝmazayen. Igda ɣas a tu-tǝmǝl tǝssust, madeɣ tǝddǝguzt tǝgât fǝl ǝddǝlil n Awal ǝn Mǝššina, ad ayyin ǝzǝgzan ǝddi da. ");
INSERT INTO ttq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Amasa wa irtakan daɣ təfəssaɣ, ǝlmital a imos n aytedan win əslanen y Awal ǝn Məššina, ");
INSERT INTO ttq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mišan aššawašatan n əddənet, d adakal wa tǝga tǝgǝrgist n ǝddǝnet taytwen-nasan, d ark deranan wiyyad aggotnen, ǝssǝfalan-du dǝnnǝg Awal wen, igdal-as awen a d-awǝy tǝnfa. ");
INSERT INTO ttq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amasa wa irtakan amaran daɣ amaḍal olaɣan, ǝlmital a imos n aytedan win as, as əslan y Awal ən Məššina, a sər-əs əzzəgzənan, iqqəl-asan tənfa, tǝmosat karadat tǝmǝrwen n ǝnǝtfus, iyyat tǝqqǝl sǝdisat tǝmǝrwen, iyyat amaran tǝqqǝl temeday.» ");
INSERT INTO ttq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Inn-asan Ɣaysa deɣ: «Awak fətəla tərɣât idakkal-tat awedan ag-et daw əɣəzu madeɣ daw tessat? Wərgeɣ ətəwəsəwar a tətawaggu edag ihhoken? ");
INSERT INTO ttq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wər t-illa a iɣbâran, wər za nǝnǝfilǝl; wala iyyan imosan ǝssir, wər za naffaggu. ");
INSERT INTO ttq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wa isallin, aslet!» ");
INSERT INTO ttq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Inn-asan deɣ: «Taggat əsəsəm olâɣan y əmazal wa d-ifalan Məššina! Təsəkət tas təkkatam y aytedan ənta as dawan-z-ikət Məššina, iššit-awan deɣ fall-as. ");
INSERT INTO ttq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Fǝlas wa ilan, a das-itǝwǝšitu awa ila; wa wǝr nǝla amaran, arat n awa ila da a daɣ-as attarmas.» ");
INSERT INTO ttq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Inn-asan deɣ: «Taɣmar ta n Məššina təha əlmital n awedan inbâlan amasa daɣ tawagost-net. ");
INSERT INTO ttq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Gər zʼinsâ wala okây, gər zʼehad wala ezal; amasa wədi a d-igməd, ad idaggal. Wər issen məššis əmmək was d-igmad wala was idaggal, ");
INSERT INTO ttq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","fəlas amaḍal, gar-es əd man-net as d-itakkas tǝnfa. Yel a d-itizaran agamad, dəffər awen agu šiɣaɣanen, amaran ədwəlnat-du daɣ-asnat təblalen. ");
INSERT INTO ttq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Təŋŋâ tǝbzǝst ɣas, idkâl-du məššis əlmoši, assantu daɣ allay-net; fəlas tamert n allay a təgat.» ");
INSERT INTO ttq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dəffər awen inn-asan Ɣaysa: «Mas za nammattal Taɣmar ta n Məššina? Ma imos ǝlmital wa tat-isassagran? ");
INSERT INTO ttq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Taɣmar za ta n Məššina təha əlmital n amasa n annabat igân esəm mutard ogaran imasan kul təmmədrǝyt. ");
INSERT INTO ttq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mišan dər iga awen da, as itawanbal, ad idwəl, agər annabatan kul win nebəlan təzzəgrət. Agu izəlan əgânen tǝzzǝgrǝt ta n as a daɣ-san agin gǝḍad šisəllula.» ");
INSERT INTO ttq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ǝlmitalan aggotnen šilat ən win di as dasan-immal Ɣaysa awal wa d-ifalan Məššina, a daɣ ewâl awen s awas əfragan əgərri-net. ");
INSERT INTO ttq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wər t-illa a inna i tamattay əs wərgeɣ ǝlmitalan a daq-qu inna, mišan as iqqal ɣas-net ənta əd nəttulab-net a dasan-iməl almaɣna n ǝlmitalan win di ketnasan. ");
INSERT INTO ttq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ǝzəl wenda, as d-ihoz ahad, inna Ɣaysa i nəttulab-net: «Nəɣrəset əs tagadamayt ta hadat n agaraw.» ");
INSERT INTO ttq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ǝfalan tamattay, matakwayan nəttulab-net, ewayan-tu daɣ əɣlal n aman wa da daɣ iqqim da. Ǝddewan dər-əs əɣlalan n aman wiyyad. ");
INSERT INTO ttq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ǝglân as d-igar aḍu issohen fəl agaraw. Ad sattabnat tənazzamaren y əɣlal, taggazan-t-id aman har ibuk y ad idnəy. ");
INSERT INTO ttq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","As itaggu awen, Ɣaysa ǝnta issomat adafor insâ daɣ ələqqam n əɣlal. Təzzar əssənkaran-tu nəttulab-net daɣ etǝs, ənnan-as: «Ǝlfəqqi! Awak zələy a wər təge daɣ a danaɣ-atšin aman?» ");
INSERT INTO ttq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Inkar-du Ɣaysa, isannarɣam y aḍu, inna y agaraw: «Ǝdrər, taffasta!» Təzzar izzəkkat aḍu, iɣrad arat kul adrur. ");
INSERT INTO ttq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Təzzar inn-asan: «Ma kawan-issərmaɣan? Awak ǝzǝgzan a wər təgem harwa da?» ");
INSERT INTO ttq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Təggaz tasa zəwwərat inəttulab, ad tinəmənnin: «Kawanay ak, ma imos wa daɣ awedan, s aḍu d agaraw da ittâf daɣ-san tanat?» ");
INSERT INTO ttq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ewad-in Ɣaysa əd nəttulab-net əsəlim n agaraw wen sen, daɣ akal ǝn Garassenatan. ");
INSERT INTO ttq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Izzəbbat-du Ɣaysa aɣlal n aman ɣas, igmad-du sər-əs əmeskel iyyan izəkwan. ");
INSERT INTO ttq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Izəkwan en da a daɣ ixsar, amaran indâr y aytedan kerrad-net, əs wala isassaran. ");
INSERT INTO ttq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ǝyəwanan kerrad ən fassan-net əs sassaran, asəɣan idaran-net əs təzabagawen, mišan ad iɣtəs awen kul. ");
INSERT INTO ttq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Iha izəkwan en da d ədɣaɣan ehad-ezal, izayyak, italay iman-net əs təhun. ");
INSERT INTO ttq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mišan, as ogga Ɣaysa daɣ igəg, ozal-du sər-əs, issəjad-as. ");
INSERT INTO ttq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Idkal aggǝsuf wa ihan aləs wa əməsli-net wəllen inna: «Ma daɣ-i tareɣ Ɣaysa, Barar ən Məššina di n Amadkol? Ǝgmaya daɣ-ak fəl Məššina, a di-wər-təzəɣɣəzzəba.» ");
INSERT INTO ttq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Innâ awen, fəlas das-inna Ɣaysa: «Aljayn wa labasan, əgməd d aləs di!» ");
INSERT INTO ttq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Təzzar issəstan-tu Ɣaysa, inn-as: «Ma esəm-nak?» Inn-as aggǝsuf: «Esəm-in Egan, fəlas igət a nəga.» ");
INSERT INTO ttq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ad itansay aggǝsuf wen Ɣaysa fəl a tu-wər-ikkes daɣ akal en. ");
INSERT INTO ttq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","As itaggu awen, idân əsəgən aggen ən ladayan fəl tasaga ən təkašwart təhozat den. ");
INSERT INTO ttq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ad tansayan kǝlǝsuf en Ɣaysa gannin-as: «Sukanaɣ iladayan en, a tan-nəggəz.» ");
INSERT INTO ttq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ird-asan Ɣaysa s awen. Ǝgmadan kǝlǝsuf aləs wen, əggazan iladayan. Ǝddəggagan-du ladayan en fəl azadaga ən təkašwart, ad titərəggen daɣ agaraw. Ǝtšan-tan aman, əmosan edag n əššin gim. ");
INSERT INTO ttq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tǝzzar ozalan madanan ən ladayan win, əgan isalan y əɣrəm wen əd ɣəlǝyɣəlayan-net. Ǝglan-du aytedan y ad ənəyan awa igan den. ");
INSERT INTO ttq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Osan-du Ɣaysa, ənayan aləs was kala ad t-əhan kǝlǝsuf; iqqim, ilsâ, təqqâl-t-idu tayttay-net, təzzar təggaz-tan tasa. ");
INSERT INTO ttq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ǝgan daɣ-san aytedan win əggǝyyatnen y awen, isalan kul n awa itawaggan y aləs en, d awa igrawan iladayan, ");
INSERT INTO ttq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","təzzar ad tansayan Ɣaysa a dasan-igməd akal-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Itaggaz Ɣaysa aɣlal n aman as d-inkar aləs wa əgmadan kǝlǝsuf, a t-itansay ad t-ayyu a dǝr-ǝs idaw. ");
INSERT INTO ttq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wər das-irḍa Ɣaysa s awen, eges ya inn-as: «Aglu əqqəl ehan-nawan d aytedan-nak, tǝmǝlaɣ-asan arat kul wa dak-iga Ǝməli s əhənətta-net.» ");
INSERT INTO ttq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Təzzar igla aləs en, ikka akal igân esəm «Wa-n-Maraw-Ɣǝrman» ad immal arat kul wa das-iga Ɣaysa. Aytedan kul win das-əslanen isannahal sər-san awen əsəmməkləl. ");
INSERT INTO ttq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iqqal Ɣaysa, iɣras agaraw s əsəlim-net wa hadan. Təlas fall-as tamattay tagget tiddawt. ");
INSERT INTO ttq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Təzzar osa-du aləs igân esəm Jayɣus, imosan iyyan daɣ muzaran n ahan n əlɣibada ən Kəl-Ǝlyəhud. Inay Ɣaysa ɣas, issəjad dat-ǝs. ");
INSERT INTO ttq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Onsay Ɣaysa, inn-as: «Tabarart-in a ɣur təlla tǝmattant, areɣ daɣ-ak a sər-əs nidaw təssəwəraq-qat ifassan-nak ad təzzəy.» ");
INSERT INTO ttq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Igla Ɣaysa, iddew dər-əs. Təlkâm-as tamattay tagget, tətanabdaɣ fall-as. ");
INSERT INTO ttq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tamattay en, tah-et təntut təgât maraw elan d əššin igammad-tat əzni. ");
INSERT INTO ttq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tənây alɣazab aggen daɣ fassan ən nasmagalan aggotnen. Awa təla kul as daɣ-san tu-tənɣa. Mišan edag n ad təggudəy, təttəyt fadda a fall-as təga təwərna-net. ");
INSERT INTO ttq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tantut ten kala da təslâ y awa gannin aytedan əs Ɣaysa. Təggaz-in tamattay ta təhat šiɣərden ən Ɣaysa, tədas takadkat-net, ");
INSERT INTO ttq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","fǝlas tənna daɣ man-net: «As ədasa kuddeɣ isəlsa-net, ad əzzəya.» ");
INSERT INTO ttq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Da da ad tədas təkadkat-net ənta daɣ-as izzəkkat əzni wa daɣ-as inaqqalan, təfray i təɣəssa-net as təzzay daɣ təwərna ten. ");
INSERT INTO ttq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tamazayt ten da a daɣ ifray Ɣaysa i tarna iyyat as t-in-təgmad. Imalallay-du tamattay, inna: «Ma idasan isəlsa-nin.» ");
INSERT INTO ttq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ǝnnan-as nəttulab-net: «Tahannaya tamattay ta fall-ak tətanabdaɣat, eges təganna \"Ma di-idasan?\"» ");
INSERT INTO ttq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dər iga awen da ya issəlal Ɣaysa tamattay asawad-net y ad inəy wa t-idasan. ");
INSERT INTO ttq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Təzzar tərmaɣ təntut, təndaw-tat taysǝst, fəlas təssân daɣ təməzzəyt ta təga den. Təkka-du Ɣaysa, təssǝjad dat-əs, təmal-as tidət ketnet. ");
INSERT INTO ttq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Inn-as: «Tabarart-in əzəgzan-nam sər-i a kam-izzozayan. Aglu daɣ alxer, təzzaya daɣ təwərna-nam.» ");
INSERT INTO ttq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Harwada iššewal Ɣaysa as d-osan aytedan a d-əfalnen aɣaywan ən Jayɣus wa n ǝmuzar n ahan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ənnan-as: «Tabarart-nak wər tədder, igd-ak tədgâzaɣ Ǝššex.» ");
INSERT INTO ttq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mišan wər-in-iger Ɣaysa tenbay daɣ awa itawannan den, inna y ǝmuzar n ahan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud: «Ad wər tərməɣa, əttəf ɣas əzəgzan-nak.» ");
INSERT INTO ttq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Igdal Ɣaysa i tamattay a dər-əs tidaw. Igla, wər iddew ar əd Butros əd Yaqub əd Yaxya wa n amadray ǝn Yaqub. ");
INSERT INTO ttq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ǝddewan əd Jayɣus wa n abba ən tabarart s aɣaywan-net. As din-osan inay Ɣaysa tanajarwayat n aytedan hallinen, sikalalan. ");
INSERT INTO ttq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iggaz-in fall-asan, inn-asan: «Mafel tənijarwayam təhallim? Tǝbarart-nawan wər tat-aba, etəs ɣas a təga.» ");
INSERT INTO ttq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Təzzar əgan-tu ajjab. Issərdaq-qan ketnasan, wər d-iqqim ar imarwan ən tabarart əd nəttulab-net win dər d-iddew, təzzar iggaz dər-san edag wa daɣ tǝnsa tǝɣǝssa ən tabarart. ");
INSERT INTO ttq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ibaz əfus-net, inn-as: «Talita qum!» Almaɣna n awen: «Tabarart ənneɣ-am, ənkər-du!» ");
INSERT INTO ttq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tənkar-du tabarart daɣ tamazayt tenda, təjawankat. Tabarart ten, maraw elan-net d əššin. Awa sər-san iga awen daɣ əsəmməkləl, əhagan. ");
INSERT INTO ttq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Irɣam-asan Ɣaysa wəllen fəl amel n awen y awedan waliyyan, dəffər adi inn-asan a tat-akfin a tətša. ");
INSERT INTO ttq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Igmad Ɣaysa edag wen, iddew əd nəttulab-net, ikka aɣrǝm wa daɣ idwal. ");
INSERT INTO ttq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","As əzəl wa n təsanfawt, iggaz Ɣaysa ehan n əlɣibada ən Kəl-Ǝlyəhud a daɣ-as isasaɣru. Isammaklal awen s aytedan aggotnen win das-əssəsamnen, har ǝqqiman gannin: «Mənid d-issan wa daɣ awedan aratan win? Ma təmos masnat ta tu-tətawakfat da, as itaggu təlməɣjujaten? ");
INSERT INTO ttq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Awak awa wərgeɣ ǝmakras ǝn nan wa n ag Maryama, əməqqar ən Yaqub əd Yosas əd Yahuda əd Simɣon? Wərgeɣ šimədrayen-net da da əxsarnen gər-ena da!» Awen daɣ a dasan-igdalan a sǝr-ǝs ǝzzǝgzǝnan. ");
INSERT INTO ttq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Inn-asan Ɣaysa: «Ǝnnəbi wər itəwəlku ar daɣ aɣrǝm wa daɣ idwal, əd šəqqaɣan-net d aɣaywan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Igdal-as awen a ɣur-san agu təlməɣjujaten. Imiranan wər nəggət ɣas a issəwar ifassan-net, izzozay-tan. ");
INSERT INTO ttq_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Isimaklal sər-əs iba n ǝzǝgzan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Illil Ɣaysa šiɣarmaten šin əhoznen Nazaret, isasaɣru aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ǝzəl iyyan iɣra-du Ɣaysa inəttulab-net win maraw d əššin, ikf-en tarna fəl kǝlǝsuf, a tan-izamazal s əššin əššin. ");
INSERT INTO ttq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Omar-tan, inn-asan: «Ad wər tawəyam arat waliyyan daɣ ǝšikǝl-nawan, ar tallaq. Ad wər tawəyam allaw, wala aɣrəg, wala tefelt daɣ nǝfdan-nawan. ");
INSERT INTO ttq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ǝsəlat iɣateman-nawan, amaran ad wər tawəyam sanatat tǝkadkaden. ");
INSERT INTO ttq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ehan was tənnəftaɣam, a tu-wər-təgmədam s iyyan iket təhâm aɣrǝm wədi. ");
INSERT INTO ttq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","As wǝr tǝtawaqbalam, wǝr itawasasam deɣ i batu-nawan daɣ adag wǝdi, as tu-təgammadam təbbikbakam-in ǝgodrar-net wa iwaran idaran-nawan, ilkâm ad aggayyat awen fall-asan.» ");
INSERT INTO ttq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ǝglan nəttulab ad taggin təlxutbat y aytedan fəl ad utaban. ");
INSERT INTO ttq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Takkasan deɣ kǝlǝsuf aggotnen daɣ aytedan, ill-ay widi zaggayan i miranan aggotnen, zuzəyan-tan. ");
INSERT INTO ttq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Isla əmənokal Herod isalan ən Ɣaysa, fəlas sallat-net a tewadat edag kul, amaran gannin sər-əs aytedan: «Awen Yaxya wa isalmaɣan daɣ aman a d-inkaran daɣ tǝmattant! Adi a fəl ila tarna n igi ən tǝlmǝɣjujaten.» ");
INSERT INTO ttq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gannin wiyyad: «Awen ənnəbi Ilyas.» Wiyyad deɣ gannin: «Awen iyyan daɣ ənnəbitan win ərǝwnen.» ");
INSERT INTO ttq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","As isla Herod y aratan win tawanninen den əs Ɣaysa inna: «Yaxya wa isalmaɣan daɣ aman was d-ǝssǝfrasaɣ eɣaf-net, ənta a d-inkaran daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod iman-net a omaran s ad attarmas Yaxya, issəkrad-tu, isassag-ay daɣ kasaw. Igâ Herod awen fəl əddəlil n azalaf-net Herodəyas təmosat taɣur Filibus, amaran Filibus amadray ən Herod en daɣ a imos. ");
INSERT INTO ttq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ǝnta Yaxya iyyəwan tənna i Herod: «Xaram fall-ak ad tərkəba daɣ amadray-nak taɣurəs.» ");
INSERT INTO ttq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Təzzar təgzar Herodəyas Yaxya fəl awen da, ad təgammay d a daɣ-as təkkəs iman, mišan wər təgrew təməwit n awen, ");
INSERT INTO ttq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","fəlas Herod a iksudan Yaxya. Issân as aləs n alɣadil a imos n əmizdag, adi a fəl t-ogaz. Ira ad isasam i batuten-net, mišan ya, i dasnat-isla, ad t-iššəwəš wəllen awa igannu Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Awen daɣ a igan, har sər-əs təgraw Herodəyas tarrayt ɣur aɣalay n əzəl wa daɣ ihəw Herod. Ǝzəl wen isassaga daɣ-as Herod saksas zəwwəran, migaren-as-du muzaran n ǝlxǝkum-net, əd muzaran ən sojitan-net, d aytedan win əlanen tenbay daɣ akal wa n Galilaya. ");
INSERT INTO ttq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Təggaz-du elles ən Herodəyas ad təggaɣ. Oggăm Herod əd naftaɣan-net eweɣ-net, təzzar inn-as: «Ǝgməy daɣ-i awa tareɣ kul, a dam-t-akfa.» ");
INSERT INTO ttq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Igla har das-ihad, inn-as: «Arat kul wa daɣ-i təgmaya, a dam-t-akfa kuddeɣ iqqal a dər-əm uzana akal-in daɣ ammas.» ");
INSERT INTO ttq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Təgmad, tənna y anna-net «Ma daɣ-as zʼəgməya?» Tənn-as anna-net: «Ǝgməy daɣ-as eɣaf ən Yaxya wa isalmaɣan aytedan daɣ aman.» ");
INSERT INTO ttq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tarmad as du-təqqal təmawat ten əmənokal Herod, tənn-as: «Eɣaf ən Yaxya wa isalmaɣan aytedan daɣ aman as əreɣ a di-tu-takfa əmərədda insâ daɣ attabla.» ");
INSERT INTO ttq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Arat wen iɣšad iman n əmənokal wəllen, mišan wər ira a das-ugəy fəl əddəlil ən təhuday ta das-iga d əddəlil ən naftaɣan-net. ");
INSERT INTO ttq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Issəgla daɣ tamazayt ten da iyyan daɣ sojitan-net win tu-tagaznen, inn-as a das-d-awəy eɣaf ən Yaxya wa isalmaɣan daɣ aman. Igla soji, ifras-du eɣaf ǝn Yaxya daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eway-t-id daɣ attabla, ikf-ay i təmawat ten. Tabarart deɣ təkf-ay y anna-net. ");
INSERT INTO ttq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","As əslan nalkiman ən Yaxya awen, əglan, ədkalan taɣǝssa-net, ənbalan-t-in. ");
INSERT INTO ttq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ǝqqalan-du nəmmuzal winad izammazal Ɣaysa da, əssoɣalan-as isalan n arat kul wa əgan, d awa sassaɣran aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Inna Ɣaysa i nəttulab-net: «Ayewat, akkiwat-anaɣ edag issufan fəl ad tassanfim a əndərran.» Arat wen inn-asan-tu fǝlas aytedan win tan-du-tasinen əd win gallinen, a əganen igət, was arat n amazay daɣ ətšan nǝttulab-net, da wər t-əgrewan. ");
INSERT INTO ttq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Təzzar əggazan aɣlal n aman, əglan, əkkan edag issufan a din-ikitayyen. ");
INSERT INTO ttq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Oggan-tan aytedan aggotnen as əglan, əzdayan-tan. Iga-du uzzal n aytedan daɣ ɣərman kul win əhoznen den, azzaran-in i Ɣaysa əd nəttulab-net s adag wa əkkan. ");
INSERT INTO ttq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","As d-izzəbbat Ɣaysa aɣlal n aman, inay tamattay tagget, təggaz-tu təhanint-nasan, fəlas ǝmosan zun ayfǝd wər nəla amadan. Təzzar a tan-isasaɣru aratan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","As gəzzul əzəl, əhozan-t-idu nəttulab-net, ənnan-as: «Edag issufan awa, amaran əzəl igla; ");
INSERT INTO ttq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","suɣǝl tamattay a, ad tǝgmǝy id tǝzzǝnza a tǝtša daɣ ɣawnatan əd taɣarmaten win əhoznen.» ");
INSERT INTO ttq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Inn-asan Ɣaysa: «Šatšat-tan kawanay iman-nawan da!» Ǝnnan-as: «Awak a tareɣ ad nədkəl sanatat təmad n ərrǝyal n əzrəf wa mallan nazzanza-du šigəlwen ətšan aytedan win?» ");
INSERT INTO ttq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Inn-asan: «Ǝssənat-du mənəket təgəlwen təlam.» As d-əssanan awa t-illan əqqalan-t-id ənnan-as: «Səmmosat təgəlwen d əššin kifitan.» ");
INSERT INTO ttq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Təzzar omar-tan s ad agin aytedan təzunen, səɣɣimin-tan den da daɣ yel. ");
INSERT INTO ttq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ǝqqiman aytedan əmosan tǝzunen. Tǝzunen en šiyyad ǝmosnat temeday temeday n awedan, šiyyad ǝmosnat səmmosat səmmosat təmərwen. ");
INSERT INTO ttq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amaran idkal Ɣaysa sǝmmosat tǝgǝlwen šin den d ǝššin kifitan win, iggəzzay ijənnawan, iga igodan i Məššina, ikaramkaram šigǝlwen šin den, ikf-enat i nəttulab-net y a tanat-uzanan i tamattay. Ǝzunan-asan deɣ kifitan winad n əššin a. ");
INSERT INTO ttq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ǝtšan aytedan en ketnasan har əyyəwanan. ");
INSERT INTO ttq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ǝššedawan-du nəttulab ən Ɣaysa awa d-iqqiman daɣ təgəlwen əd kifitan, ədkaran daɣ-as maraw əzmaman d əššin. ");
INSERT INTO ttq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ǝddukad ən səmmos gim n aləs a əhanen tamattay ta tətšat den. ");
INSERT INTO ttq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wala a ihogan omar Ɣaysa inəttulab-net s ad əggəzan aɣlal n aman, izaran-as-in ǝs tǝgadamayt ta hadat n agaraw əs təɣrəmt ta n Betsayda, iket di ad itasallam tamattay. ");
INSERT INTO ttq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Issəgla tamattay ɣas, ikka adɣaɣ iyyan y a fall-as agu šiwatriwen. ");
INSERT INTO ttq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","As iga ahad, aɣlal n aman wa əhan nəttulab ən Ɣaysa isigaraygaray daɣ agaraw, Ɣaysa amaran ənta iwâr adɣaɣ ɣas-net itattar. ");
INSERT INTO ttq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ogg-en əbbillanan d əsəgli n əɣlal fəl aman, fəlas aḍu a dər d-əmməqqasan. As tǝga tilkamat n ahad ikk-en-du Ɣaysa ijiwankat fəl aman. As zama tan-okây, ");
INSERT INTO ttq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","oggan-tu ijiwankat fəl aman, əɣilan aggǝsuf, sakkarayan. ");
INSERT INTO ttq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ketnasan issirmaq-qan anay wa t-əgan. Mišan tamazayt ten da a dasan-iššewal Ɣaysa inn-asan: «Ad wǝr tǝɣšǝdam, nak awa! Tǝgmǝdet-kawan tasa!» ");
INSERT INTO ttq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iggaz-du fall-asan aɣlal ɣas, idrar aḍu. Iga sər-san awen əsəmməkləl labasan, ");
INSERT INTO ttq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","fəlas wər əgren almaɣna ən təməɣjujat ta iga Ɣaysa əs təgəlwen id iwallan-nasan a garmomnen. ");
INSERT INTO ttq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","As ǝɣrasan agaraw, ewadan akal ǝn Ganazaret, ǝndayan aɣlal n aman daɣ təšəšwit. ");
INSERT INTO ttq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ǝgmadan aɣlal n aman ɣas, əssanan aytedan as Ɣaysa awen. ");
INSERT INTO ttq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Təzzar ozalan daɣ akal ketnet, edag as əslan as ih-ay a sər-əs du-tawəyan imiranan daɣ tǝssǝwen. ");
INSERT INTO ttq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Edag osa Ɣaysa, gər za aɣrǝm wala taɣrəmt wala iɣawnatan n əsuf, a d-awəyan aytedan imiranan s adag wa imosan asammanay, ansəyan Ɣaysa ad ayyu aytedan ədəsan kuddeɣ tǝbǝnik ən tǝkadkat-net. I tat-idasan deɣ ad izzəy. ");
INSERT INTO ttq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ǝddewan Farisaytan ɣur Ɣaysa əntanay d arat daɣ musanan n Ǝttawret a d-əgmadnen Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ǝnayan arat daɣ nəttulab ən Ɣaysa tattin əs fassan əmmidasnen, almaɣna wər nərrud. ");
INSERT INTO ttq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ǝnta Farisaytan əd Kəl-Ǝlyəhud kul wər təttin iket wər əššoradan ifassan-nasan har təɣəmmar, imos awen alɣadat ən marawan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wər təttin deɣ as d-əgmadan assamanay n aytedan, iket wər əzzəzdagan. Ǝttâfan deɣ šiyyad alɣadaten aggotnen, ǝmosnen əzəzdəg ən kassan, əd təkan, əd təɣeren əd təssuwen šin daɣ tattin. ");
INSERT INTO ttq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Adi a fəl əssəstanan Farisaytan ǝd musanan n Ǝttawret Ɣaysa, ənnan-as: «Mafǝl wər əlkeman nəttulab-nak y alɣadaten ən marawan-nana, tattan əs fassan əmmidasnen?» ");
INSERT INTO ttq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Inn-asan Ɣaysa: «Ǝlmunafiqan! Tidət a imos awa sər-wan inna ənnəbi Isayas s ǝmmǝk was itiwaktab as: \"Tamattay ta, ilǝs ɣas as di-təssəɣmar, mišan iwallan-nasan ǝggugan-i wǝllen. ");
INSERT INTO ttq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ǝlɣibada wa di-taggin, ibbinnan, fǝlas wǝr sǝsǝɣrin ar alwajiban a d-ǝnzaman aytedan daɣ ɣafawan-nasan.\" ");
INSERT INTO ttq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ǝmmək en da a təgam kawanay da, toyyam alwajiban ən Məššina, təlkamam y alɣadaten n aytedan.» ");
INSERT INTO ttq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Inn-asan Ɣaysa deɣ: «Šiyyit tolâɣat a təgam y alwajiban ən Məššina, fǝl lǝkkum y alɣadaten-nawan! ");
INSERT INTO ttq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wərgeɣ ənnəbi Musa a inna: \"Səɣmər abba-nak d anna-nak\" inna deɣ: \"Awedan wa išaffaraššen abba-net, madeɣ anna-net, wǝdi a daɣ-as tǝwǝkkǝsan man.\"» ");
INSERT INTO ttq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mišan kawanay təgannim: «Ifrâg awedan ad annu y abba-net madeɣ anna-net: \"Tadhǝlt tas daɣ-i təgam ənnəyat-net, əssəwaraq-qat aganna tǝmos aḍḍawal.\" Daɣ adi awedan wədi wər tu-toyyem s amaknaw n arat y abba-net wala anna-net. ");
INSERT INTO ttq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Təməwit tədi da as təgam alɣadat-nawan daɣ adag n Awal ən Məššina, təsasaɣrim-tat i bararan-nawan. Tətaggim deɣ wiyyad aratan aggotnen šilat n adi.» ");
INSERT INTO ttq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","As iga Ɣaysa batu ten i Farisaytan ǝd musanan n Ǝttawret, iɣra tamattay, inn-as: «Səsəmat-i ketnawan, tagrim awa dawan-z-anna da. ");
INSERT INTO ttq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wər t-illa arat itaggazan taɣəssa n aggadəm, ifrâgan əsəmmədəs-net. Kalar awa t-id-igammadan a tat-isamadasan. ");
INSERT INTO ttq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wa isallan, aslet!» ");
INSERT INTO ttq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","As imməzzay Ɣaysa əd tamattay, iggaz ehan, əssəstanan-tu nəttulab-net d almaɣna n iggi wa iga den. ");
INSERT INTO ttq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Inn-asan: «Awa zaɣnin kawanay da, wər təlem əgərri? Wər təgrem as, wər t-illa arat itaggazan taɣəssa n aggadəm ifrâgan əsəmmədəs-net, ");
INSERT INTO ttq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","fəlas wərgeɣ əwəl-net a itaggaz. Kalar tadist-net a itaggaz, dǝffǝr adi inɣǝl-in daɣ əsuf.» Ǝmmək wa da as issəxlal Ɣaysa imensewan kul. ");
INSERT INTO ttq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Inn-asan deɣ: «Awa d-igammadan əwəl n aggadəm, ənta a t-isamadasan, ");
INSERT INTO ttq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","fəlas əwəl n aggadəm a du-gammadnat arak ənnəyaten a tu-tawaynen s igi ən tədoden madeɣ igi ən meddan əd šikra, d igi ən man, ");
INSERT INTO ttq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","d igi n ǝzzǝna, ǝd tara n ǝddǝnet, əd tišit n amaksan, əd təkaddilt, d igi n aratan win ogarnen taxxaramt, əd manjaɣ, əd šizmit, d ədkul ən man, əd təmətəkwǝyen kul šin iba ən təla n almaɣna. ");
INSERT INTO ttq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aratan win di labasnen kul əwəl n aggadəm a du-gammadan, amaran əntanay a tu-samadasnen.» ");
INSERT INTO ttq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ifal Ɣaysa edag wen ikka amaḍal ən Tir. Os-in ɣas iggaz ehan iyyan, fəlas wər ira a fall-as tagu masnat; mišan indar-as ad aqqam wər fall-as təga masnat. ");
INSERT INTO ttq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kalar iraz-in ɣas təsl-ay təntut iyyat təlât tabarart iha aggǝsuf, təkk-ay-du, təssəjad-as. ");
INSERT INTO ttq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tantut ten wər təmos iyyat daɣ Kəl-Ǝlyəhud, ǝlǝsǝl-net Kǝl Fenisǝya ǝd Kǝl Surǝya. Tonsay Ɣaysa a das-ikkəs aggǝsuf daɣ tabarart-net. ");
INSERT INTO ttq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Təzzar inn-as Ɣaysa: «Ayyu bararan ad ayyawanan təzzar, fəlas wər oleɣ i daw-san idkalan amensay-nasan igər-t-in i ḍan.» ");
INSERT INTO ttq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tənn-as təntut: «Tidət-nak Ǝmǝli, mišan ya, iḍan da ǝkǝmmi a taggin awa d-irattakan daɣ bararan, tattin-tu.» ");
INSERT INTO ttq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Inn-as Ɣaysa: «Aglu, təqqəlaɣ aɣaywan-nam; tabarart-nam igmad-tat aggǝsuf fəl əddəlil ən batu ta di-təge da.» ");
INSERT INTO ttq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Təqqal aɣaywan-net, tos-in tabarart-net təzzilallat daɣ tessat, igmâd-tat aggǝsuf, təzzây. ");
INSERT INTO ttq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dəffər adi igmad Ɣaysa akal ən Tir, irzag Sidon os-in akal wa n Galilaya iga sər-əs tarrayt ta təmmarat akal Wa-n-Maraw-Ɣərman. ");
INSERT INTO ttq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Den daɣ a sər-əs d ewayan aytedan aləs immizagan, as indây iləs-net. A tu-tansayan y ad t-issəwar ifassan-net, izzuzǝy-tu. ");
INSERT INTO ttq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iddew dər-əs Ɣaysa, igmad dǝr-ǝs aytedan, təzzar iga idədwan-net daɣ təməzzugen n əmzag en, dəffər adi issəwar-tan imətman-net, idas sər-san iləs n əmzag en. ");
INSERT INTO ttq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amaran iggəzzay Ɣaysa ijənnawan, ihanaffat, inn-as: «Effata!» Almaɣna: Nuləm. ");
INSERT INTO ttq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tamazayt tenda a daɣ ənnolamnat təməzzugen n əmzag en, itawayya-du iləs-net, iššewal s iləs isrâdan. ");
INSERT INTO ttq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dǝffǝr awen omar Ɣaysa aytedan s ad wər əmelan awa igan den y awedan waliyyan, mišan iket itamar-tan s awen sanahalan-tu emel. ");
INSERT INTO ttq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iga sər-san awen əsəmməkləl labasan, gannin: «Awa itaggu kul iknâ ǝlluɣ. Wala imzagan issəsl-en, išašawal deɣ win as əndayan ilsawan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Adan en da a daɣ təlas tamattay tagget tiddawt fəl Ɣaysa. Tamattay en wər təla a tətša. Iɣra Ɣaysa inəttulab-net, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Aytedan a təh-i təhanint-nasan. Karad adan a ɣur-i əgan, amaran abʼas t-illa a ǝtšan. ");
INSERT INTO ttq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","As tan-əssoka iɣawnatan-nasan wǝr ǝreman arat, a tan-aggadlu gǝlǝk daɣ tarrayt, id wiyyad daɣ-san igəg a d-əgmadan.» ");
INSERT INTO ttq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ǝnnan-as nəttulab-net: «Məni du-z-igrəw awedan daɣ əsuf a šigǝlwen siyyawannen tamattay togdât d awa?» ");
INSERT INTO ttq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Issəstan-tan Ɣaysa, inn-asan: «Mənəket təgəlwen təlam?» Ǝnnan-as: «Ǝssayat.» ");
INSERT INTO ttq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Omar Ɣaysa tamattay s ad tǝɣrǝd tǝɣimit. Idkal-du əssayat təgəlwen šin, iga igodan i Məššina, i karamkaram-tanat, ikf-enat i nəttulab-net y a tanat-uzanan i tamattay en. Ǝzunan-asan-tanat. ");
INSERT INTO ttq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ǝlân deɣ arat ən kifitan win madrornen. Iga Ɣaysa igodan i Məššina inna i nəttulab-net, a tan-uzanan əntanay da y aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aytedan en ǝyyǝwanan ǝglazan-du, har as ǝssa ǝzmaman win zawwarnen a du-tawadkarnen daɣ karammutan win d-əglazan. ");
INSERT INTO ttq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ǝddukad n əkkoz gim n aləs a ətšanen den. As tətša tamattay, issəllam-tat Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tamazayt ten da a daɣ iggaz aɣlal n aman ənta əd nəttulab-net, ikka akal ǝn Dalmanuta. ");
INSERT INTO ttq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Osan-du arat daɣ Farisaytan, mašawalan dər-əs, gammayan daɣ-as təlməɣjujat təmosat alɣalamat a du-təfâlat Məššina, imosan awen jarraba-net. ");
INSERT INTO ttq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iga Ɣaysa təhənəffet zagret, inna: «Mafǝl gammayan aytedan n azzaman win tǝlmǝɣjujat a du-təfâlat Məššina? Ǝggəyyeɣ əsilakanaɣ-awan as, wər ilkem a dawan-tətiwagga tǝlmǝɣjujat waliyyat.» ");
INSERT INTO ttq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Təzzar ifal-tan, ilas iguz n əɣlal n aman, ikka ǝsǝlim wa hadan n agarew. ");
INSERT INTO ttq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ǝttəwan-in nəttulab a d-awəyan allaw ǝn tǝgǝlla. Tagəlla iyyadda ɣas a tǝhat aɣlal-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isammatar-tan Ɣaysa, inn-asan: «Ǝnkədat wəllen i xamira ǝn Farisaytan ǝd wa n əmənokal Herod!» ");
INSERT INTO ttq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ad tinəmənnin nəttulab-net gar-essan: «Awa wər t-inna ar fəlas wər nəla tagəlla.» ");
INSERT INTO ttq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Issan Ɣaysa daɣ awen, inn-asan: «Mafel təššewalam daɣ iban təla-nawan tagəlla? Awak ǝgǝrri a wǝr tǝgem harwa da? Awak iwallan-nawan a əganen taɣart tas abʼas təgarrim? ");
INSERT INTO ttq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Awak šittawen a wər təlem əs tənayam, wala deɣ šiməzzugen əs təslam? Awak tatawt a din-təgam ");
INSERT INTO ttq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","iket n ǝzmaman a du-tədnayam daɣ karammutan win du-təglaz tamattay assaɣa wad əzunaɣ səmmosat təgəlwen i səmmos gim n aləs?» Ǝnnan-as: «Nǝkittǝw as maraw ǝzmaman d əššin a du-nǝdnay. ");
INSERT INTO ttq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Šigǝlwen šin əssayat za, šin əzuna y əkkoz gim n aləs, mənəket əzmaman a du-tədnayam daɣ karammutan win du-tawaglaznen?» Ǝnnan-as: «Ǝssa.» ");
INSERT INTO ttq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Amaran inn-asan: «Eges harwa da wər təgrem wala?» ");
INSERT INTO ttq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Os-in Ɣaysa ənta əd nəttulab-net taɣrəmt ən Betsayda. Ǝlwayan-du sər-əs aytedan aləs n əmədderɣəl, onsayan-tu ad t-idəs izzuzǝy-tu. ");
INSERT INTO ttq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ibaz Ɣaysa əfus n əmədderɣəl en, ilway-tu har dər-əs igmad taɣrəmt. Issəwar imətman-net šittawen-net, issəwar-tu ifassan-net, inn-as: «Awak təhannayaɣ arat meɣ?» ");
INSERT INTO ttq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Idkal əmədderɣəl eɣaf-net, inna: «Hannayaɣ aytedan, mišan olân-i d eškan jiwankatnen.» ");
INSERT INTO ttq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ilas Ɣaysa əsəwər ən fassan-net šittawen n əmədderɣəl en. Iqqal-t-id asawad-net ketnet, izzay, innəflay daɣ arat kul. ");
INSERT INTO ttq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Issəlləm-tu Ɣaysa inn-as: «Ad wər təqqəla taɣrəmt ten, aglu akku aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dəffər awen iddew Ɣaysa əd nəttulab-net əkkan šiɣarmaten əhanen amaḍal as itawannu Qaysarǝya wa n ǝmuzar Filibus. Ǝglân as tan-issəstan Ɣaysa, inn-asan: «Ak daɣ iduf n aytedan, ma ǝmosa?» ");
INSERT INTO ttq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ǝnnan-as: «Wiyyad a gannin Yaxya wa isalmaɣan aytedan daɣ aman a təmosa, wiyyad a gannin ənnəbi Ilyas, wiyyad deɣ a gannin iyyan daɣ ənnəbitan.» ");
INSERT INTO ttq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«Kawanay za, ma tənnam ma əmosa?» Inn-as Butros: «Kay a imosan Ǝlməsix.» ");
INSERT INTO ttq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Issənkad-tan Ɣaysa inn-asan: «Tidət a imos adi mišan a tu-wər-təməlam y awedan waliyyan.» ");
INSERT INTO ttq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Den da ad issənta Ɣaysa əsəssəɣri ən nəttulab-net, inn-asan: «Nak Ag Aggadəm, kundaba ǝnaya alɣazab aggen, unkaran-i muzaran ən Kəl-Ǝlyəhud əd muzaran ǝn limaman əd musanan n Ǝttawret, təwəggin man-nin, ǝnkara-du deɣ daɣ tǝmattant əzəl wa n karad.» ");
INSERT INTO ttq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ig-asan i batu en igi isisagran wəllen. Təzzar iwat-tu Butros s ahal, iššewal fall-as fəl awa inna den. ");
INSERT INTO ttq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mišan imalallay fall-as Ɣaysa, iswad daɣ nəttulab-net win hadatnen, iharaššat Butros, inn-as: «Ǝfəl dəffər-i, Aššaytan, fǝlas imedranan-nak, wǝrgeɣ Mǝššina a d-ǝfalan, kalar imedranan n aggadǝm ɣas a ǝmosan.» ");
INSERT INTO ttq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dəffər awen iɣra-du Ɣaysa tamattay əd nəttulab-net, inn-asan: «Wa iran a di-ilkəm, wǝdi igmǝdet tara ən man-net, agu imateran-net, idkǝl tǝgǝttawt-net, ilkəm-i. ");
INSERT INTO ttq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ǝssǝnat as awedan wa wǝr nǝgǝmmǝy ar aggaz ǝn man-net, wədi ad t-ǝgmǝdan, mišan wa iqbalan ad t-ǝgmǝdan fəl əddǝlil-in d əddǝlil n Ǝlinjil, wǝdi ad iɣlǝs. ");
INSERT INTO ttq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma zʼaknu y awedan ad igrəw əddənet ketnet, ənta amaran temsay a ikka? ");
INSERT INTO ttq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awak mas ifrag awedan tehakkay-net y a sər-əs agəz iman-net daɣ təmsay? ");
INSERT INTO ttq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Awedan kul wa isakkarakad ləkkum y-i, madeɣ isikarakad-tu əsuɣəl n awal-in daɣ azzaman win, daɣ iggət iba ən təksəda ən Məššina, wǝdi nak da, Ag Aggadəm, a di-tǝsəkkərukəd ǝlqǝbulat-net əzəl wa du-z-əqqəla əleɣ tanaya n Abba-nin, əddewa d angalosan a zaddognen.» ");
INSERT INTO ttq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ilas Ɣaysa inn-asan: «Ǝggǝyyeɣ silakanaɣ-awan as, wiyyad daɣ-wan əbdâdnen da, wər tan-z-iba wər ənayan assa ən Taɣmar ta n Məššina igân əs tarna.» ");
INSERT INTO ttq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sədis adan dəffər awen, iɣra-du Ɣaysa Butros əd Yaqub əd Yaxya, iddew dər-san əntanay ɣas s ədɣaɣ iyyan zagren. Ǝllân den da, as imməttay azzahir ən Ɣaysa dat-san. ");
INSERT INTO ttq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Malawlawan səlsa-net. Ǝgan təməllay təsiraqqet wəllen əs kala wər tətawanay šilat-net daɣ əddənet. ");
INSERT INTO ttq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Təzzar oggan ənnəbi Ilyas d ənnəbi Musa, mišawalan əd Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iggad-du Butros inna i Ɣaysa: «Ǝššex, olâɣ as nəlla da! Ad nəkrəs karad hǝktan. Iyyan i-nak, iyyan in Musa, iyyan in Ilyas.» ");
INSERT INTO ttq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wər din-igra Butros axaras wa iga den fəl awa iga daɣ tərəmmeq ənta əd nəttulab win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tamazayt ten da a dənnəg-san du-tənafalal təgarak, təls-en telay-net; təzzar iga-du awal daɣ tagarak en da, inna: «Awa Barar-in wa əkneɣ tara, səsəmat-as.» ");
INSERT INTO ttq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wala a ihogan, waraɣwaraɣan nəttulab, wər hənnəyan awedan waliyyan a ɣur-san illân ar Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tazabben-du adɣaɣ en da as dasan-inna Ɣaysa: «Ad wər təməlam awa tənayam da y awedan waliyyan iket wər d-ənkera nak Ag Aggadəm daɣ təmattant.» ");
INSERT INTO ttq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ǝttafan tarɣǝmt ta dasan-iga den, mišan tinəməsəstinan gər-essan d awa issoka Ɣaysa əs «tanakra daɣ təmattant» ta imal den. ");
INSERT INTO ttq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ǝssəstanan-tu, ənnan-as: «Mafǝl gannin musanan n Ǝttawret: \"Kundaba osa-du Ilyas tǝzzar as du-z-asu Ǝlmǝsix?\"» ");
INSERT INTO ttq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Inn-asan: «Tidət-nasan as kundaba osa-du ənnəbi Ilyas təzzar, annazzam aratan kul; mišan ya, mafel iktâb as Ag Aggadəm kundaba inay alɣazab aggen, itəwəsəknu məlka? ");
INSERT INTO ttq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A kawan-əssusənaɣ âs ənnəbi Ilyas osâ-du, amaran əgân-as aytedan arat kul wa əran, imos as awen da a iktaban daɣ batu-net.» ");
INSERT INTO ttq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","As d-iqqal Ɣaysa əd nəttulab-net win karad ogga inəttulab-net win hadatnen təɣilayɣalay-tan tamattay tagget, tǝnkâr tamazaq gar-essan ǝd musanan n Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Togga tamattay Ɣaysa ɣas, isammaklal sər-san awen, ozalan sər-əs a tu-saslaman. ");
INSERT INTO ttq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Inna Ɣaysa i nəttulab-net: «Ma dər-san təmməzaɣam?» ");
INSERT INTO ttq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Inn-as aləs iyyan daɣ tamattay en: «Ǝlfəqqi, ewâya-du sər-ək barar-in iha aggǝsuf labasan, indâyan iləs-net. ");
INSERT INTO ttq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","As daɣ-as d-inkar, a t-aggadlu, ad isakafkaf isamakyak, təzzar issəf. Ǝgmâya daɣ nəttulab-nak a daɣ-as t-əkkəsan, mišan indar-asan» ");
INSERT INTO ttq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Inn-asan Ɣaysa: «Xa! Iket iba n ǝzǝgzan daɣ aytedan n azzaman a! Awak har əmmay əddewa dər-wan, zizaydar dər-wan? Awəyat-i-du barar.» ");
INSERT INTO ttq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Təzzar ewayan-as-t-id. Da da ɣas ad inay aggǝsuf Ɣaysa, ənta ad izazzakarkar barar, ifataqqat, ad itizəbərdil, isakafkaf. ");
INSERT INTO ttq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Issəstan Ɣaysa abba ǝn barar, inn-as: «Ǝmmay du-t-igaz awa šin agaraw?» Inn-as: «Harwa mədrəy. ");
INSERT INTO ttq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ǝyyəwan-tu aggǝsuf təməgirt daɣ təmsay madeɣ aman y ad t-anɣu. Kud təfrâgaɣ a təkneɣ daɣ awa, təhənətteɣ-ana, tilalaɣ-ana.» ");
INSERT INTO ttq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Inn-as Ɣaysa: «Kud təfrâga ya? Arat kul əfragaɣ igi-net i wa sər-i izzəgzanan.» ");
INSERT INTO ttq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Idkal abba ən barar əməsli-net daɣ tamazayt ten da, inna: «Ǝzzigzanaɣ, agəz-i daɣ iba n ǝzǝgzan.» ");
INSERT INTO ttq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","As inay Ɣaysa uzzal ən tamattay iggâd-du sər-əs, iharaššat aggǝsuf, inn-as: «Aljayn wa igaddalan awal, izamazag, omaraq-qay s ad təgməda barar di; amaran a tu-wər-tələsaɣ iguz!» ");
INSERT INTO ttq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Izyak aggǝsuf, iga i barar en əzəzzəkərkər labasan, amaran igmad-tu. Wər iha adag barar en itimətəkwəyan, zun t-aba, har ənnan aytedan aggotnen: «Aba-tu». ");
INSERT INTO ttq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mišan ibaz-t-id Ɣaysa s əfus, issənkar-t-id, ibdad barar. ");
INSERT INTO ttq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","As iggaz Ɣaysa ehan iyyan, əssəstanan-tu nəttulab-net wər iqqim awedan waliyyan, ənnan-as: «Aljayn wa n ihogan, mafel indâr-anaɣ ikus-net daɣ barar en?» ");
INSERT INTO ttq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Inn-asan: «Ǝzzənəf n aggǝsuf wen, wər t-itəkkəs ar šiwatriwen.» ");
INSERT INTO ttq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Igmad Ɣaysa edag wen ənta əd nəttulab-net, ərzagan akal ən Galilaya, mišan wər ira ad issən awedan waliyyan dad illa, ");
INSERT INTO ttq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","fəlas əsəssəɣri a itag inəttulab-net. Igann-asan: «Nak Ag Aggadəm ǝjwâra ad ǝggâzaɣ ifassan n aytedan, agin iman-in, mišan karad adan dəffər iba-nin, a d-ənkəra daɣ təmattant.» ");
INSERT INTO ttq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mišan wər əgren nəttulab-net batu ta dasan-iga den, amaran tah-en tasa n əsəstan-net. ");
INSERT INTO ttq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ewad-in Ɣaysa ənta əd nəttulab-net aɣrǝm ən Kafarnahum. Ǝggazan-in ehan ɣas issəstan-tan, inn-asan: «Ma təmməzaɣam daɣ tarrayt?» ");
INSERT INTO ttq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wər das-ənnen arat, fəlas tamazaq a əgan gər-essan daɣ tarrayt, ərân ad əssənan wa daɣ-san ogaran. ");
INSERT INTO ttq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iqqim Ɣaysa, inna i nəttulab-net win maraw d əššin a t-id-ihazan, inn-asan: «Wa daɣ-wan iran tizart, iwâr-tu ad agu iman-net daw aytedan kul, aget iman-net akli-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ibaz-du Ɣaysa əfus n arat ən barar iyyan ilân den, issǝbdad-tu gar-essan, ibaz-t-id izalammat-tu, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«I iqbalan barar šilan wa fəl əddəlil-in, wǝdi nak iman-nin as di-iqbal; wa di-iqbalan deɣ, wərge nak a iqbal, wa di-d-izammazalan a iqbal.» ");
INSERT INTO ttq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Inn-as Yaxya: «Ǝššex, nənây aləs iyyan itakkasan kǝlǝsuf daɣ aytedan s esəm-nak, nǝnn-as a wǝr ilǝs igi n awen, fǝlas wǝr danaɣ-iha ǝs lǝkkum y-ak.» ");
INSERT INTO ttq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Inn-as Ɣaysa: «A das-wər-təgdəlam igi n adi, fəlas wər t-illa awedan as zʼagin təlməɣjujat s esəm-in, annu sər-i a labasan dəffər adi. ");
INSERT INTO ttq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","I wər nəgəmməy təkma-nana, wədi əmidi-nana. ");
INSERT INTO ttq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amaran ǝggǝyyeɣ silakanaɣ-awan as, i kawan-iššəšwan wala ablu n aman fəlas a kawan-iwar esǝm n Ǝlməsix, wədi illikan as ad igrǝw arozan-net.» ");
INSERT INTO ttq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«I iqqalan ǝssǝbab n abakkad y iyyan daɣ aytedan win sǝr-i ǝzzǝgzannen, ǝmosnen zun bararan madrornen, wədi of-as ad itəwəqqən ǝzǝzǝd zǝwwǝran ǝn tǝhunt daɣ iri-net itəwəgər-in daɣ agaraw əmazal wa iga əddi. ");
INSERT INTO ttq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kud kay əfus-nak a ibukan a dak-iqqəl əssəbab n igi n abakkad, təfrǝsaq-q-in; id of-ak ad təggəza aljannat təgeɣ əfus, y ad təleɣ əššin fassan təggəzaɣ temsay an Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kud deɣ adar-nak a ibukan a dak-iqqəl əssəbab n igi n abakkad, təfrəsaq-q-in; id of-ak ad təggəzaɣ aljannat təgeɣ adar y ad təleɣ əššin daran təggəzaɣ temsay an Jahannama. ");
INSERT INTO ttq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Amaran kud šat-nak a təbukat a dak-təqqəl əssəbab n igi n abakkad, təkəkkəreq-qat-du; id of-ak ad təggəza Taɣmar ta n Məššina təgeɣ šat y ad təleɣ sanatat šittawen, tǝtəwǝgǝra dǝr-ǝsnat daɣ təmsay an Jahannama, ");
INSERT INTO ttq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","təmosat edag as wərmad tamattatnat təwəkkawen-net, wala deɣ temsay-net.» ");
INSERT INTO ttq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Awedan kul ad itəwəzəzdəg əs təmsay, zun d əmmək as tǝtaggaz tesǝmt imensewan fǝl a tan-tǝggǝz tenbay. ");
INSERT INTO ttq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tesǝmt arat olâɣan a tǝmos, mišan as tat-təgmad tenbay-net, awak ma imos arat wa daɣ-as zʼitəwəggin təqqəl-tat-du? Təqqəlet təməddurt-nawan a ilân tenbay zun tesǝmt, amaran iməlet alxer gar-ewwan.» ");
INSERT INTO ttq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ifal Ɣaysa edag wen ikka akal ən Yahudǝyya ihân aganna wa hadan n agarew wa n Yordan. Təlas fall-as tamattay tiddawt, a tat-isasaɣru imos awen arat itaggu faw da. ");
INSERT INTO ttq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ǝhozan-t-in Farisaytan ǝgan-as ǝsǝstan imosan tǝnagmayt, ənnan-as: «Awak xalal y aləs ad izəmməzzəy tantut-net meɣ wər xalal?» ");
INSERT INTO ttq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Inn-asan Ɣaysa: «Mas imos alwajib wa dawan-d-oyya Ǝnnəbi Musa daɣ batu tədi?» ");
INSERT INTO ttq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ǝnnan-as: «Ǝnnəbi Musa ikfâ turagat n ad tǝtǝwǝktəb širawt n əməzzəy i tǝntut, tǝtǝwǝzǝmǝzzǝy.» ");
INSERT INTO ttq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Inn-asan Ɣaysa: «Aššaddat ən taggarmamt ən wallan-nawan a fəl dawan-d-oyya Musa alwajib wədi. ");
INSERT INTO ttq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dər iga awen da ya, əs tizarat as d-ixlak Məššina əddənet, \"ixlak-du aytedan, ixlak-kan-du ǝmosan yay ǝd tǝntay.\" ");
INSERT INTO ttq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adi da a fəl iffâl aləs abba-net d anna-net, irtǝy əd təntut-net, ");
INSERT INTO ttq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","əqqəlan fəl əššinessan arat iyyanda. Ǝmmǝk en daɣ as ad ib-as ǝmosan əššin aytedan, kalar ad əqqalan taɣǝssa iyyadda. ");
INSERT INTO ttq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Daɣ adi, awa issərtay Məššina a tu-wər-izəmməzzǝy awedan.» ");
INSERT INTO ttq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","As iggaz Ɣaysa ehan, əssəstanan-tu nəttulab-net əntanay da əd batu ten. ");
INSERT INTO ttq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Inn-asan: «I izammazzayan tantut-net, izlaf iyyat, wədi ǝzzəna a iga əddi. ");
INSERT INTO ttq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tantut deɣ ta təmməzzayat d aləs-net, izlaf-tat iyyan, ənta da ǝzzǝna a təga di.» ");
INSERT INTO ttq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A du-tawayan aytedan bararan əs Ɣaysa fəl a tan-issəwər ifassan-net ittər-asan, mišan ǝššewalan nǝttulab fǝl aytedan win den. ");
INSERT INTO ttq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Inay Ɣaysa awen ɣas iššak-ku, inn-asan: «Ayyiwat bararan a di-d-akkin. A tan-in-wər-təwəɣam fall-i, fəlas Taɣmar ta n Məššina šin aytedan win šilaten-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ǝggəyyeɣ əsilakanaɣ-awan as, i wər nəga i Taɣmar ta n Məššina əlqəbulat šilat ən ta das-iga barar, wədi wər das-ilkem a tat-iggaz.» ");
INSERT INTO ttq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Təzzar ad itizələmmit Ɣaysa bararan win den, isawar-tan ifassan-net, itattar-asan. ");
INSERT INTO ttq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","As zama imitakway Ɣaysa daɣ adag wen iraz-du sər-əs aləs iyyan sər-əs d-ozâlan, igaraffat dat-əs, inn-as: «Ǝššex olâɣan, mas di-iwar igi-net y ad əgrəwa təməddurt ta təɣlalat?» ");
INSERT INTO ttq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Inn-as Ɣaysa: «Mafel as di-təgannaɣ Ǝššex olaɣan? Wər t-illa i olâɣan ar Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Alwajiban-net təssânaq-qan, ih-en as: \"Ad wər tagaɣ iman, ad wər tagaɣ ǝzzǝna, ad wər takəra, ad wər taggayyeɣ əs bahu, ad wər taga tǝkma y awedan, səɣmər abba-nak d anna-nak.\"» ");
INSERT INTO ttq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Inn-as aləs wen: «Ǝlfəqqi, aratan win di kul harwa da mədrəya as tan-əssəbdada.» ");
INSERT INTO ttq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Təzzar idak-ku Ɣaysa s asawad təha tara, inn-as: «Arat iyyanda a dak-in-iqqiman ǝmǝrǝdda: Aglu zanz-in təla-nak kul, takfaɣ inazzan-net i tələqqawen, ad təgrəwaɣ ərrəzəɣ a dak-z-ansin daɣ alaxirat. Dǝffǝr adi amaran tagla-du təlkəmaɣ-i.» ");
INSERT INTO ttq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Isla aləs en i batu ten ɣas, izakkanzar. Inkar, igla əɣšâdan man-net fəlas ǝrrǝzǝɣ aggen a ila. ");
INSERT INTO ttq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Issəlal Ɣaysa asawad-net tamattay ta tu-təɣalayɣalayat den, amaran inna i nəttulab-net: «Iket əzzəwi ig-ay iguz ən Taɣmar ta n Məššina fəl win əggərgasnen.» ");
INSERT INTO ttq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Batu ten, təqqan iɣafawan ən nəttulab-net, ilas Ɣaysa inn-asan: «Bararan-in, iket əzzəwi ig-ay iguz ən Taɣmar ta n Məššina! ");
INSERT INTO ttq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ogar tərɣasay ta iga fəl aḷam aradaɣ daɣ təbuday n ənazmay, i ta iga fǝl ǝmǝggergǝs iguz ǝn Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Batu ta təsammaklal wǝllen ǝs nəttulab, təzzar ad tinəmənnin: «Adi za ma ifragan ad iɣləs daɣ təmsay?» ");
INSERT INTO ttq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iswad daɣ-san Ɣaysa inna: «Muxal a imos adi ɣur aytedan, mišan Məššina wər sər-əs t-imos, fəlas arat kul ifrâk-ku.» ");
INSERT INTO ttq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Təzzar inn-as Butros: «Nakkanay za? Awak wərgeɣ noyya arat kul nəlkam-ak?» ");
INSERT INTO ttq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Inn-asan Ɣaysa: «Ǝggəyyeɣ silakanaɣ-awan as, awedan kul wa ifalan fəl əddəlil-in d əddəlil n Ǝlinjil ehan-net madeɣ imədrayan-net madeɣ šimədrayen-net madeɣ anna-net madeɣ abba-net madeɣ bararan-net madeɣ šiwəgas-net, ");
INSERT INTO ttq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wədi awedan ad igrəw harwa da əmərədda, temeday n ənətfus ən nan madeɣ imədrayan madeɣ šimədrayen madeɣ annaten madeɣ bararan madeɣ šiwǝgas. Amaran adi ketnet ad t-igrəw iddew-as d alɣazab, igrəw deɣ təməddurt təɣlâlat daɣ alaxirat. ");
INSERT INTO ttq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amaran a aggen daɣ win ǝhanen eɣaf ǝmǝrǝdda, ilkâm ad əggəzan ələqqam, win ǝhanen ǝlǝqqam deɣ ǝmǝrǝdda, ilkâm a ǝggǝzan eɣaf.» ");
INSERT INTO ttq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iha Ɣaysa tarrayt ənta əd nəttulab-net, azzar-asan, taggazzayan ǝs Yerusalam. As itaggu awen ǝššiwašan nəttulab-net, taha deɣ tasa aytedan win das-əlkamnen. Ilas Ɣaysa ikus ən nəttulab-net win maraw d əššin daɣ aytedan y a dasan-iməl arat a fall-as zʼagin daɣ alwaq wər nəggug. ");
INSERT INTO ttq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Inn-asan: «Sǝsǝmat: Nakkanay da ǝggǝzzaynen ǝs Yerusalam da. Den da ad za tǝwǝgga nak Ag Aggadǝm daɣ fassan ǝn muzaran ǝn limaman, ǝd musanan n Ǝttawret. Aytedan win a di-ǝxkǝman tǝmattant, agin-i daɣ fassan n aytedan wǝr nǝmos Kǝl-Ǝlyǝhud, ");
INSERT INTO ttq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","a daɣ-i tajaban, əssutəfan fall-i, ayyawanan-i šiwwit, agin iman-in, mišan a d-ənkəra daɣ təmattant əzəl wa n karad.» ");
INSERT INTO ttq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ǝnkaran nəttulab əššin win maddanəs ən Zabaday əmosnen Yaqub əd Yaxya, ǝhozan-du Ɣaysa, ənnan-as: «Ǝššex, a daɣ-ak nəgməy arat as nəra a danaq-qu-taga.» ");
INSERT INTO ttq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Inn-asan: «Mas təram a dawan-t-aga?» ");
INSERT INTO ttq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ǝnnan-as: «Nəra daɣ-ak ad aqqam iyyan daɣ-na daɣ əɣil-nak, aqqam wa hadan daɣ zalgat-nak alwaq wad za təggəza tanaya-nak.» ");
INSERT INTO ttq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Inn-asan Ɣaysa: «Wǝr tǝssenam almaɣna n arat wa tǝgmayam ǝddi. Awak tǝfragam a dǝr-i tǝdrǝwam alɣazab wa zʼaga daɣ alwaq wǝr nǝggug?» ");
INSERT INTO ttq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ǝnnan-as: «Awalla, nǝfrâg a dǝr-ǝk tu-nǝdrǝw.» Inn-asan: «Tidət a imos as tǝfrâgam a dǝr-i tǝdrǝwam alɣazab wa, tagim deɣ təmattant ta zʼaga. ");
INSERT INTO ttq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amaran daɣ batu ta təqqalat wa zʼaqqamin daɣ əɣil-in wala zalgat-in, wərgeɣ nak a t-ihakkin. Kalar idaggan win in win as tawasammatagan.» ");
INSERT INTO ttq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ǝslan maraw nəttulab win hadatnen y awen, ǝššakkan Yaqub əd Yaxya. ");
INSERT INTO ttq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Təzzar iɣr-en-du Ɣaysa inn-asan ketnasan: «Təssânam as aytedan win tawattafnen daɣ tišit ǝn muzaran ən tǝmattiwen saknin tarna y aytedan win as azzaran, amaran aytedan win daɣ-san attafnen ǝlxǝkum saknin aytedan win as azzaran taɣmar. ");
INSERT INTO ttq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mišan kawanay ad wər tagim adi gar-ewwan. Kalar as ira iyyan daɣ-wan ad ilu almaqam, wǝdi iqqǝlet zun amaššaɣal-nawan. ");
INSERT INTO ttq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Amaran wa daɣ-wan iran tizart, wǝdi iqqǝlet zun akli n awedan kul, ");
INSERT INTO ttq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","fəlas nak Ag Aggadǝm wǝr d-oseɣ ǝddǝnet y a di-ǝšɣǝlan aytedan. Kalar assa a d-ǝge y ad ǝšɣǝla y aytedan, akfa iman-nin fǝl ad sǝddǝrfeɣ ǝs tǝmattant-in aytedan aggotnen daɣ bakkadan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Igla Ɣaysa əd nəttulab-net har din-ewadan aɣrǝm wa n Yerikaw. As iggaz Ɣaysa šin agamad n əɣrəm wen ənta əd nəttulab-net əd tamattay tagget, ill-ay əmədderɣəl iyyan igân esəm Bartimay ag Timay iqqiman fəl afay ən tarrayt itansay. ");
INSERT INTO ttq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Da da ɣas ad isla as Ɣaysa wa n əɣrəm ǝn Nazaret awen, ənta ad idkal əməsli-net ad igannu: «Ya Ɣaysa, Ag ǝnnǝbi Dawǝd, hənəttət-i.» ");
INSERT INTO ttq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ǝrɣaman-as aytedan aggotnen y ad affastu, mišan isahhakat əməsli-net wəllen, igannu: «Ya Ɣaysa, Ag Dawǝd, hənəttət-i.» ");
INSERT INTO ttq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Izzəkkat Ɣaysa, inna: «Aɣriwat-i-t-id». Itawaɣra əmədderɣəl, itawann-as: «Dawat, təbdəda, iɣarr-ik.» ");
INSERT INTO ttq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Igar-in əmədderɣəl asalsaw-net wa n afalla, iggad, innəmad Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Issəstan-tu Ɣaysa inn-as: «Mas tareɣ a dak-k-aga?» Inn-as əmədderɣəl: «Ǝššex, a əreɣ a di-d-iqqǝl asawad-in.» ");
INSERT INTO ttq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Təzzar inn-as Ɣaysa: «Aglu, izzozay-kay əzəgzan-nak sər-i.» Iqqal-t-id asawad-net daɣ tamazayt ten da, obaz tarrayt, iggaz tamattay ta təlkamat i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","As din-ihoz Ɣaysa Yerusalam ənta əd nəttulab-net, daɣ ənǝmihaz ən təɣrəmt ta n Betfajay əd ta n Betanǝy, dəgma n ədɣaɣ was itawannu wa n \"Eškan ən Zaytun\"; izammazal əššin daɣ nəttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Inn-asan: «Akkiwat taɣrəmt ten dat-wan den. Təggâzam-tat-in ɣas tənâyam əhulel n ǝzdan iqqanan, as wər kala ad ittəwan. Ariwat-tu, təlwǝyam-t-idu. ");
INSERT INTO ttq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amaran as dawan-inna awedan: \"Ma tətaggim əddi?\" Tannim-as: \"Ǝmǝli a sǝr-ǝs iddǝraran.\" Amaran a t-id-issuɣəl tarmad.» ");
INSERT INTO ttq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ǝglan nəttulab win den osan-in əhulel iqqân fəl tarrayt dat ǝmi n ahan iyyan; a tu-tarin. ");
INSERT INTO ttq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Təzzar ənnan-asan aytedan əllânen den: «Ma tətaggim əddi? Mas tətarim əhulel di?» ");
INSERT INTO ttq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ǝjjəwwaban-asan nəttulab s awa dasan-inna Ɣaysa. Amaran tawayyan, oran əhulel, əglan dər-əs. ");
INSERT INTO ttq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ǝlwayan-t-id i Ɣaysa. Ǝdfaran-as fall-as isǝlsa-nasan, iwan-tu. ");
INSERT INTO ttq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ad tissəwan aytedan aggotnen i Ɣaysa isǝlsa-nasan daɣ tarrayt, wiyyad ɣattasan-du ilədlad wǝr ǝhen šǝnnanan tissəwan-as-tan. ");
INSERT INTO ttq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aytedan win das-azzarnen əd win das-əlkamnen, ketnasan siɣaren, gannin: «Ozana! Təmmal i Məššina! Iga Məššina albaraka daɣ wa d-osan s esəm n Ǝməli. ");
INSERT INTO ttq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iga Məššina albaraka daɣ taɣmar ta du-təzayat, taɣmar n amaraw-nana Dawǝd. Ozana! Təmmal i Məššina daɣ jənnawan di ǝdkalnen!» ");
INSERT INTO ttq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iggaz Ɣaysa aɣrǝm ən Yerusalam, ikka Ehan wa Zəwwəran n Ǝlɣibada, izaggazda arat kul wa daɣ-as itaggin. As iga awen da idgâz-t-id ahad, igmad aɣrǝm ənta əd nəttulab-net win maraw d əššin, əkkan Betanǝy. ");
INSERT INTO ttq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","As əzəl wa hadan, igmâd-du Ɣaysa əd nəttulab-net Betanǝy, as ifray i gǝlǝk. ");
INSERT INTO ttq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ogga daɣ igəg ašək ən fig inzâran. Ikk-ay y ad issən erâw. As t-in-osa, wər t-iha ar ifərkak fəlas tamert n ara-net a wər nəga. ");
INSERT INTO ttq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Təzzar iššewal Ɣaysa s ašək wen, inna: «Təɣrədet əddənet wər iles awedan tettay n ara-nak.» Arat wa inna Ɣaysa den sallan-as nəttulab-net. ");
INSERT INTO ttq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","As d-ewad Ɣaysa əd nəttulab-net Yerusalam, iggaz aɣalla wa iɣlayan Ehan wa Zəwwəran n Ǝlɣibada a daɣ-as isattaɣ imassatagan əd mazanzan; isabbanbay tebǝren šin fəl sansin kəl sanji izərfan-nasan, isabbanbay deɣ šisəqqima ən massatagan ən tədəbren. ");
INSERT INTO ttq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Təzzar igdal y awedan waliyyan ad irzəg Ehan wa Zəwwəran n Ǝlɣibada ewây arat. ");
INSERT INTO ttq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Inna y aytedan daɣ əsəssəɣri wa tan-itaggu: «Wərgeɣ iktâb as, inna Məššina: \"Ehan-in, a das-itǝwǝggu esǝm ehan n ǝlɣibada i tawšeten kul\". Kawanay amaran tǝgâm-tu \"ǝsǝlɣǝs ǝn baydagan\".» ");
INSERT INTO ttq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ǝslan muzaran ən limaman əd musanan n Ǝttawret y awen ɣas, ad gammayan təməwit tas zʼagin iman ǝn Ɣaysa, mišan tah-en tasa-net fəlas tamattay ketnet a təsannahalat təggəma n əsəssəɣri-net. ");
INSERT INTO ttq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","As d-ihoz ahad, igmad Ɣaysa əd nəttulab-net aɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","As affaw əzəl wa hadan, iha Ɣaysa əd nəttulab-net tarrayt ən Yerusalam as d-əllaman dəgma n ašǝk ən fig wanâd, ənayan-tu iqqur ketnet harkid kewan-net. ");
INSERT INTO ttq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ikta-du Butros ašǝk wen, inna i Ɣaysa: «Ǝššex, ənak fig wa təlɣana, ketnet iqqur.» ");
INSERT INTO ttq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Təzzar inn-asan Ɣaysa: «Zəgzənat əs Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ǝggiyyeɣ ǝsilakanaɣ-awan as, i innan y ədɣaɣ en: \"Ǝgmǝd edag di tǝfǝtǝqqe daɣ agarew\", amaran as inna awen wər iga aššak daɣ əwəl-net, izzigzan as awa inna da ad agu; awedan wədi a das-agu Məššina awa daɣ-as igmay əddi. ");
INSERT INTO ttq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Daɣ adi, əmalaɣ-awan as: arat kul wa tonsayam Mǝššina daɣ təwatriwen-nawan, wǝdi zəgzənat as təgrâwam-tu, ǝddi a dawan-t-akfu Məššina.» ");
INSERT INTO ttq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Amaran as tətattaram, kud ill-ay arat a iqqal wər noleɣ təttâfam daɣ man y awedan, təssurəfam-as təzzar, ǝddi Abba-nawan wa ihan ijənnawan ǝnta da a dawan-issurǝf ark mazalan-nawan. ");
INSERT INTO ttq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mišan as wər təssurufam y aytedan, wǝdi wər dawan-z-issurəf Abba-nawan wa ihan ijənnawan ark mazalan-nawan.» ");
INSERT INTO ttq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ilas-du Ɣaysa ənta əd nəttulab-net tewaɣlay n əɣrəm ən Yerusalam. Isaɣlay Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada as t-id-osan muzaran ən limaman, osan-t-id deɣ musanan n Ǝttawret ǝd muzaran ən Kəl-Ǝlyəhud, ");
INSERT INTO ttq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ənnan-as: «Awak ma təmos tarna tas tətaggaɣ aratan win? Ma kay-ikfan tarna n igi-nasan?» ");
INSERT INTO ttq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Inn-asan Ɣaysa: «A dawan-agaɣ ǝsəstan iyyanda. As di-təjjəwwabam, a dawan-əməla wa di-ikfan tarna n igi n aratan win tagga da. ");
INSERT INTO ttq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ǝməlat-i, awak ǝsǝlmǝɣ wa iga Yaxya aytedan daɣ aman Mǝššina a ɣur d-ifal awen meɣ aggadǝm?» ");
INSERT INTO ttq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Təzzar ad tinəməšəwwiran gər-essan, gannin: «As das-nənna: \"Məššina a d-ifal\" a danaɣ-annu: \"Mafel za wər təzzəgzanam s awa dawan-inna Yaxya?\" ");
INSERT INTO ttq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wər das-za-nannu za: \"Aggadǝm\".» Wər əhelan tənna n awen fəlas tamattay ketnet təttâf as, Yaxya ənnəbi a imos. ");
INSERT INTO ttq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Təzzar ənnan i Ɣaysa: «Wər nəssen». Inn-asan Ɣaysa: «Daɣ adi nak da wər dawan-z-əməla wa di-ikfan tarna n igi n aratan win.» ");
INSERT INTO ttq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iššewal-asan Ɣaysa daɣ ǝlmitalan, inn-asan: «Aləs iyyan a inbalan eškan n əzzəbib, issəɣlay-tan afarag. Iɣaz daɣ-as tagdayt ta daɣ za itawazmu əzzəbib, ikras deɣ ogga ihokken as zʼiggar awedan wa itagazan afarag. Tǝzzar issǝɣfar afarag-net en i magyakan wiyyad, iššokal. ");
INSERT INTO ttq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","As du-tewad tamert ta n əmilǝy n əzzəbib, izammazal iyyan daɣ eklan-net əs meddan win ɣur-əs əɣfarnen afarag-net y a ɣur-san d-awəy adagar-net. ");
INSERT INTO ttq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","As tan-in-osa əkli en, əbazan-tu, ǝgan-as šiwwit, əssoɣalan-tu məššis isikarayray ifassan. ");
INSERT INTO ttq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Izammazal sər-san iyyan akli. As tan-in-osa, sabbasan eɣaf-net, əgan-as tar šəxšad. ");
INSERT INTO ttq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ilas məššis n afarag izammazal sər-san akli-net iyyan. As tan-in-osa, əbazan-tu, ənɣan-tu kǝrǝz. Dəffər adi izammazal sər-san daɣ tanamazray wiyyad eklan-net aggotnen. Wiyyad za əggatan-tan har tan-əksanan, wiyyad ənɣan-tan kǝrǝz. ");
INSERT INTO ttq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Abʼas d-iqqim i məššis n afarag ar barar-net wa ikna tara. Izammazal-tu sər-san daɣ tilkamat, fəlas a inna daɣ man-net: \"Immikkan as ad əssəɣməran barar-in.\" ");
INSERT INTO ttq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mišan as ǝnayan magyakan win əɣfarnen afarag barar wen, namannan gar-essan: \"Ǝnta əddi amakkasu n afarag. Ǝndawat a tu-nanɣu kǝrǝz, ad nəkkusət afarag.\" ");
INSERT INTO ttq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Təzzar ǝbazan-tu, ənɣan-tu kǝrǝz. Ǝgaran-in tafəkka-net sədi y afarag.» ");
INSERT INTO ttq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Daɣ adi ma zʼagu məššis n afarag wen? Wərgeɣ assa a du-z-agu ənta iman-net, agu iman ən magyakan win, issəɣfər afarag-net i wiyyad aytedan? ");
INSERT INTO ttq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Awak teɣaray a wər təgem daɣ Ǝlkəttaban as: \"Tǝhunt ta din-ǝgaran makrasan, ǝnta a tǝqqalat tǝhunt ta tǝkbalat ehan, ");
INSERT INTO ttq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","arat wen Ǝmǝli a d-ifal, amaran isimaklal sǝr-na!\"» ");
INSERT INTO ttq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ad gammayan muzaran win den əmmək was za səttərməsan Ɣaysa fəlas əgrân as əntanay a issoka s ǝlmital wen; mišan ya wər əhelan awen fəlas tamattay a əksudan. Adi fəl t-oyyan, əglan. ");
INSERT INTO ttq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dəffər awen əssokan-t-id arat daɣ Farisaytan d aytedan wiyyad ǝwarnen aganna n ǝmǝnokal Herod fəl a das-agin tǝnagmayt, s a tu-sassannin arat fəl t-əbazan. ");
INSERT INTO ttq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Osan-t-id ənnan-as: «Ǝššex, nəssân as ǝməggi ən tidət a təmosa, amaran wǝr t-illa i tǝksuda daɣ awa tǝganna, fǝlas wǝr tǝzlaya daɣ almaqam n aytedan. Tǝsasaɣra ǝs tidǝt awas dana-iwar igi-net daɣ tarrayt ta n Mǝššina. A kay-nəssəstən, awak xalal arazam n amana y əmənokal wa zǝwwǝran Qaysara meɣ wər xalal? A tu-nərzəm, meɣ wər tu-za-nərzəm?» ");
INSERT INTO ttq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Inn-asan Ɣaysa igrân təlmǝnufəqa-nasan: «Mafel tətajarrabam-i? Akfiwat-i-du tefelt n ǝzrǝf a tat-ənǝya.» ");
INSERT INTO ttq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ǝkfan-as-tat-in, təzzar inn-asan: «Ma ilan udǝm d esəm win tat-əwarnen?» Ǝnnan-as: «In Qaysara.» ");
INSERT INTO ttq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Inn-asan: «Adi za agiwat i Qaysara awa kawan-issǝwar, tagim deɣ i Məššina awa kawan-issǝwar.» Isammaklal sər-san aljawab wa tan-ikfa Ɣaysa da. ");
INSERT INTO ttq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Dəffər awen osan-du Sadusaytan Ɣaysa, əmosnen aytedan əttâfnen as wǝr tu-tǝlla tanakra dǝffǝr tǝmattant. Ǝssəstanan-tu, ənnan-as: ");
INSERT INTO ttq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Ǝššex, ənnəbi Musa iktâb as: \"As aba aləs oyya-du tantut dər wər ila barar, ilzâm amadray-net a tat-izlǝf fəl ad agu ǝzzurrǝyya y ǝmidi-net wa aba den.\" ");
INSERT INTO ttq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ǝnta kala a t-əllan əssa mədrayan. Izlaf wa dasan-waššaran ketnasan, aba-tu wər d-oyya a imosan barar. ");
INSERT INTO ttq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Izlaf wa n əššin təntut ta ɣur aba əmidi-net den. Ǝnta da aba-tu wər d-oyya ara. Iga wa n karad awen da. ");
INSERT INTO ttq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ǝssa mədrayan win, ketnasan əgan awen da, wər tan-iha i d-oyyan ara. Dəffər as tan-aba ketnasan, aba tantut ten ǝnta da. ");
INSERT INTO ttq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Awak əzəl wa n tabadday, ma imos daɣ ǝssa mǝdrayan win den was za tǝqqǝl tǝntut ten taɣurǝs, dad zamas ketnasan ǝzlâfan-tat?» ");
INSERT INTO ttq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Inn-asan Ɣaysa: «Kawanay alxata a təttafam, fəlas wərmad təssanam awa ǝnnan Ǝlkǝttaban, wala deɣ təssanam awa dər togda tarna ən Məššina, ");
INSERT INTO ttq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","fəlas əzəl wa n tabadday, wər t-illa azalaf i meddan wala šidoden. Kalar tǝmǝddurt a zʼagin šilat ən ta əgan angalosan daɣ jənnawan. ");
INSERT INTO ttq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Amaran daɣ batu ta təqqalat inəmməttan əd tanakra-nasan: awak teɣaray a wər təgem daɣ Ǝttawret awa inna Məššina y ǝnnǝbi Musa ɣur ənəfilal wa das-iga ɣur təfsəq. Wərgeɣ a das-inna Məššina: \"Nak a imosan Ǝməli n Ibrahim, d Isǝhaq, əd Yaqub?\" ");
INSERT INTO ttq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Məššina wər imos Ǝməli ən təməxsa, kalar Ǝmǝli ǝn win ǝddarnen a imos. Daɣ adi alxata zəwwəran a tǝham.» ");
INSERT INTO ttq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ihoz-du iyyan daɣ musanan n Ǝttawret issisaman y əməšiwal wa iga Ɣaysa da əd Sadusaytan, d aljawab oggâm wa dasan-iga Ɣaysa, inna i Ɣaysa: «Ma imos alwajib wa ogaran daɣ alwajiban kul win danaɣ-ikfa Məššina?» ");
INSERT INTO ttq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Inn-as Ɣaysa: «Ǝnta da alwajib wa ogaran: \"Səsəmat Kəl-Israyil! Ǝməli-nana Məššina, ənta ɣas Ǝməli. ");
INSERT INTO ttq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Iru Ǝməli-nak Məššina s əwəl iyyanda əd man ərdânen. Tireq-qu s awa təleɣ kul daɣ tayttay əd təɣurad.\"» ");
INSERT INTO ttq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«Amaran alwajib wa ilkaman i wədi as: \"Agu y ǝšǝqqaɣ-nak tara ta tǝgeɣ iman-nak.\"» ");
INSERT INTO ttq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Təzzar inna əmusan n Ǝttawret wen i Ɣaysa: «Tidət-nak Ǝššex! Məššina iyyanda, amaran wər t-illa iyyan ar ənta. ");
INSERT INTO ttq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amaran as t-ira awedan s əwəl iyyanda, ir-ay deɣ s awa ila kul daɣ tayttay əd təɣurad, ira deɣ ǝšǝqqaɣ-net s əmmək was ira iman-net, wər tu-təlla takutay tətirəkəmmet wala takutay iyyat wər oger adi.» ");
INSERT INTO ttq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Da daɣ ad isla Ɣaysa i batu təgât s əgərri ta iga aləs a ənta a das-inna: «Kay, wər kay-iggug iguz ən Taɣmar ta n Məššina.» Abʼas t-illa i ihalan əsəstan ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isasaɣru Ɣaysa daɣ Ahan wa Zəwwəran n Ǝlɣibada as iga əsəstan wa, inna: «Awak wərgeɣ a gannin musanan n Ǝttawret, Ǝlməsix Ag ǝmǝnokal ǝnnǝbi Dawǝd a imos? ");
INSERT INTO ttq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawǝd za iman-net as t-isassanna Infas wa Zəddigan daɣ batu n Ǝlmǝsix: \"Ǝməli Məššina inna y Ǝməli-nin: Qamu daɣ ǝɣil-in, har ǝɣrǝdaɣ ǝsǝrǝs ǝn zǝnga-nak, agaq-qan daw daran-nak.\" ");
INSERT INTO ttq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawǝd iman-net as iɣra Ǝlməsix s esǝm wa n Ǝməli, daɣ adi manǝmmǝk as zʼiqqǝl barar-net?» Batu ta iga Ɣaysa da, toggam-tat tamattay tagget ta das-təssəsamat. ");
INSERT INTO ttq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Inna Ɣaysa i tamattay daɣ əsəssəɣri wa tat-itaggu den: «Agəzat iman-nawan daɣ musanan n Ǝttawret. Ǝrân ad saɣlayan əzlâgan šikadkaden zagrotnen, d ətəwəsəslam igân əs saɣmar daɣ sammanayan n aytedan. ");
INSERT INTO ttq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ǝrân deɣ təɣimit daɣ daggan win ǝlanen almaqam daɣ nan win əlɣibada ǝn Kǝl-Ǝlyǝhud d iguz ǝn daggan n aytedan win tawasaɣmarnen daɣ məgura. ");
INSERT INTO ttq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taɣan awa əlanat tədoden šin as wər ədderan meddan-nasnat, taggin deɣ imaddan zagrotnen wər nəmos ar sokni. Ilkâm a dasan-itəwəxkəm attadib labasan.» ");
INSERT INTO ttq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iqqîm Ɣaysa daɣ Ahan wa Zəwwəran n Ǝlɣibada, illa dat-ǝs əssənduq wa daɣ itiddaw ǝrrǝzǝɣ n Ahan wa Zǝwwǝran n Ǝlɣibada, iswâd daɣ tamattay tətaggu daɣ-as azrəf. Sartakan daɣ-as məggərgas aggotnen azrəf aggen. ");
INSERT INTO ttq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tosa-du təntut ən tələqqay as wər idder aləs-net, təssərtak daɣ-as sanatat təfelen as wər tewed əlqimat-nasnat ǝrrǝyal. ");
INSERT INTO ttq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Təzzar iɣra-du Ɣaysa inəttulab-net əs man-net inn-asan: «Ǝggiyyeɣ silakanaɣ-awan as, təntut ən təlaqqay ta, əs wər idder aləs-net, togar aytedan a ketnasan tehakkay, ");
INSERT INTO ttq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","fəlas ketnasan azrəf was wər əddəraran a daɣ əkfan, mišan ənta harkid əlləqqu-net tədkal-du ərrǝyalan s əntanay ɣas a fəl təssan, təkf-en.» ");
INSERT INTO ttq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Igammad Ɣaysa Ehan wa Zǝwwǝran n Ǝlɣibada as das-inna iyyan daɣ nəttulab-net: «Ǝššex, ənak šihussay ən təhun šin as ikras ahan a! Šihussay n ahan!» ");
INSERT INTO ttq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Inn-as Ɣaysa: «Təhannayaɣ ehan a zəwwəran a? Wər daɣ-as du-za-taqqam təhunt təwârat tǝmidit-net. Ketnet ad itǝwǝjǝbbǝrǝjjǝt.» ");
INSERT INTO ttq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dəffər awen, iqqîm Ɣaysa fəl ədɣaɣ wa n Eškan ən Zaytun, daɣ tənəmiwəla n Ahan wa Zəwwəran n Ǝlɣibada, as t-issəstan Butros əd Yaqub əd Yaxya d Andrawǝs, wər əqqiman nəttulab win hadatnen, ənnan-as: ");
INSERT INTO ttq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ǝməl-anaɣ əmmay ad zʼagu arat wa tənneɣ ihogan? Ma za təqqəl alɣalamat ta za tassaknit as ibuk y igi?» ");
INSERT INTO ttq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Inn-asan Ɣaysa: «Ǝnkədat, a kawan-wər-issəxrək awedan waliyyan, ");
INSERT INTO ttq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","fəlas aytedan aggotnen a du-z-asinen ǝttafan esəm-in, akkiyyan daɣ-san igannu imos Ǝlmǝsix, əssəxrəkan s awen aytedan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Amaran as tǝslam i tǝrmuq ǝn mǝgiran, ǝd salan ǝn mǝgiran, a kawan-wər-issǝrmǝɣ awen. Aratan di kundaba osan-du, mišan wǝrgeɣ ǝntanay a ǝmosnen təzərəst n əddənet. ");
INSERT INTO ttq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ad əknəsnat addawlaten gar-essanat, əknəsnat taɣmaren gar-essanat, əməlan-tu nǝgǝynǝgǝyan n amaḍal daɣ daggan aggotnen əd laz labâsan. Mišan aratan win kul, wǝr ǝmosan ar ǝnǝtti ǝn təlawayt tǝhât ǝlmital ǝn ta du-tətizarat əs təntut tətaggazat amzur.» ");
INSERT INTO ttq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Kawanay amaran ənkədat əd man-nawan. Ad tattarmasam, tətəwəsəbdədam dat saggawaran n əššəriɣa, təwəgginat-awan təwit daɣ nan n əlɣibada ən Kǝl-Ǝlyǝhud. Ad tətəwəsəbdədam dat naxkiman əd mǝnokalan fǝlas kawan-iwar esǝm-in, akf-iwan adi tarrayt n a fall-i taggayyem, ");
INSERT INTO ttq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","fəlas tawšeten kul n əddənet kundaba əslenat i salan n Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","As təttərmasam, tətəwasabdadam daɣ adag n əššəriɣa, a kawan-wər-iššəwəš awa za tannim. Agat ɣas batu ta kawan za tətawakfit daɣ assaɣat tədi da, fəlas wərgeɣ kawanay iman-nawan a tat-igan; kalar Infas wa Zəddigan a tat-z-agin daɣ mawan-nawan. ");
INSERT INTO ttq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ad sǝttǝrmǝsan aytedan imǝdrayan-nasan sǝssugin iman-nasan, sǝttǝrmasan abbatan bararan-nasan sǝssugin iman-nasan, affallagan bararan fǝl marwan-nasan sǝssugin iman-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Awedan kul a kawan-igzǝr fǝlas kawan-iwar esǝm-in, mišan wa daɣ-wan izmaran har tǝzǝrǝst, wǝdi ad iɣlǝs.» ");
INSERT INTO ttq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«As tənayam \"taxxaramt ta səksədat\" tǝha edag was wər imməkkan a tu-tǝha – Agret awedan wa iɣarrin isalan win! – aytedan win d-ogaz adi daɣ akal ǝn Yahudǝyya, win di addaggaganet s ədɣaɣan; ");
INSERT INTO ttq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wa iqqiman daɣ adag wa n afalla n ahan-net, a du-wǝr-azzabbat y a din-idkəl arat ihân ehan-net. ");
INSERT INTO ttq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa ihan tawagost-net a du-wər-iqqəl aɣaywan y a din-idkəl asalsaw-net. ");
INSERT INTO ttq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Iket alɣazab ad t-aginat tǝdoden šin ǝganen šidusen ǝd šin sankasnen daɣ adan win di!» ");
INSERT INTO ttq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«Ǝgmǝyat daɣ Məššina a du-wər-imazayyat adi ǝd tamert n asamed irtâyan d akonak, ");
INSERT INTO ttq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","fəlas alɣazab səksədan a du-z-asin daɣ adan win di as a d-ixlak Məššina əddənet wər kala tətawanay tulat-net, za wər ilkem du-tosa tulat-net. ");
INSERT INTO ttq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kundaba as adan win di ikf-en Ǝmǝli tǝzǝrǝst, wǝdi wər t-illa i daɣ-san du-z-irəgan. Kalar ad tǝwǝzzǝgzǝlan fǝl ǝddǝlil n aytedan win tawasanafrannen.» ");
INSERT INTO ttq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ǝddi amaran, as dawan-inna awedan: \"Ǝnǝyat! Ǝlmǝsix illa da\", madeɣ: \"Illa den\", a das-wǝr-tǝzzǝgzǝnam! ");
INSERT INTO ttq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fǝlas ad t-ǝmǝlan ǝlmǝsixan ǝn bahu, ǝmǝlan-tu deɣ ǝnnǝbitan ǝn bahu. Ad taggin alɣalamaten ǝd tǝlmǝɣjujaten, har as ǝnnar ǝfragan awen, ǝssǝxrǝkan aytedan harkid win isannafran Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Daɣ adi ənkədat əd man-nawan! Aratan di ketnasan əgeɣ-awan-tan daw aɣaf.» ");
INSERT INTO ttq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Dəffər tǝssust ta za tagit daɣ adan win di, ad alsinat šiyyay təfuk, igməd ənnur tallit, ");
INSERT INTO ttq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ərtəkan-du etran, nǝgǝynǝgǝynat təxəllak šin əlanen tarna daɣ jənnawan, ");
INSERT INTO ttq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","alwaq wədi da ad za təwənǝya nak Ag Aggadəm as du-z-asa əheɣ šignawen, daɣ tarna-nin tagget, əd tanaya-nin, ");
INSERT INTO ttq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","təzzar zǝmmizǝlaɣ angalosan ǝs tǝɣəmmar an əkkozat n ǝddǝnet, y a d-əššidəwan aytedan kul win sannafranaɣ.» ");
INSERT INTO ttq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Inn-asan: «Abǝzat alfaydat s ǝlmital wa n ašǝk ǝn fig. Igda ad hussǝyan lǝdlad-net, iggaz-du šin tanazra, ad tǝssǝnam as tamert ta n akasa tǝhôz. ");
INSERT INTO ttq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zund ǝmmǝk en daɣ âs as tǝnayam aratan win dawan-ǝmalaɣ ǝddi, tǝssǝnam as aɣrud n ǝddǝnet ihoz, wǝr illa gar-ewwan dǝr-ǝs arat. ");
INSERT INTO ttq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ǝggǝyyeɣ ǝsilakanaɣ-awan as tamattay ta da n azzaman win nǝha da, ad tǝnǝy ǝnǝtti n aratan kul win dawan-ǝmala da. ");
INSERT INTO ttq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ijǝnnawan d amaḍal ilkam ad ibʼas t-ǝllan, mišan batuten-in ǝllanat-tu har faw.» ");
INSERT INTO ttq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ǝzǝl amaran wala alwaq wa daɣ zʼagu awa dawan-ǝmala da, wər t-illa i daɣ-san issânan, gǝr za angalosan a əhanen ijənnawan, wala Barar iman-net. Wǝr t-illa i daɣ-san issânan ar Abba. ");
INSERT INTO ttq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ǝnkədat, təsəmmutəgam, fəlas wər təssenam assaɣat ta daɣ zʼagu adi. ");
INSERT INTO ttq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iha adi əlmital n aləs išakalan. As iggaz šin teklay iga šinaden n aɣaywan-net daɣ fassan n eklan-net. Akkiyyan imal-as əššəɣəl was t-iwar igi-net. Inna i wa ogazan imi n ahan ad inkǝd. ");
INSERT INTO ttq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Daɣ adi ənkədat, fəlas wər təssenam alwaq wa daɣ du-z-asu məššis n aɣaywan, kud alməz, wala adawannay n ahad, wala datazal, wala aɣora. ");
INSERT INTO ttq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A kawan-du-wər-asu daɣ alwaq daɣ as wər təswedam, agǝz-kawan-du tənsâm. ");
INSERT INTO ttq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Awa dawan-ganna da, ketnawan as dawan-tu-ganna, a t-imosan as: Ǝnkədat.» ");
INSERT INTO ttq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ǝššin adan a din-aba daɣ əmud wa n Akkay d əmud wa daɣ tamatšinat təgəlwen šin wər iha xamira. Imuzaran ən limaman əd musanan n Ǝttawret harwa da gammayan təmərkest tas zʼabəzan Ɣaysa agin iman-net, ");
INSERT INTO ttq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","fǝlas a gannin: «Ad wər nagu adi daɣ adan n əmud, fəl a du-wər-awəy ǝnǝjərway əs tamattay.» ");
INSERT INTO ttq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Awen as itaggu Ɣaysa ənta iha taɣrəmt ta n Betanǝy, imigarat i Simɣon was kala a t-igraw kətru. Itamansaw den da as du-t-osa təntut tewâyat butalay igân daɣ təhunt mallat, iha alwardi iknan šizada d əzzəwi as itawannu nar. Tosa-du ɣas tərza imi ən butalay wa teway da, ad tənaqqal alwardi wen fəl aɣaf ən Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Arat wen iga alham daɣ arat daɣ aytedan win əllanen den, ad tinəmənnin gər-essan: «Ma infa ǝhluk n alwardi a? ");
INSERT INTO ttq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wərgeɣ ifrâg a din-anzu ǝlqimat ǝn karadat tǝmad n ǝzǝl n ǝššǝɣǝl, itəwəkfu awen i tələqqawen?» Ad suɣulan təntut ten təgna. ");
INSERT INTO ttq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mišan inn-asan Ɣaysa: «Akfat-tat əməslag! Mafəl das-təɣaššadam iman? Ǝmazal olâɣan a di-təga da, ");
INSERT INTO ttq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","fəlas šiləqqawen faw da əllânat ɣur-wan, id təram adi təfrâgam a dasnat-tilalam; nak amaran, wərge faw əlleɣ ɣur-wan. ");
INSERT INTO ttq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Təntut ta awa təfrag, təg-ay. Tənɣal fall-i alwardi y ad təsəmmutəg taɣəssa-nin y əzəkka harwa dat alwaq. ");
INSERT INTO ttq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ǝggiyyeɣ silakanaɣ-awan as, edag a daɣ ittəmal Ǝlinjil daɣ əddənet ketnet, a daɣ-as attamal awa təga tǝntut ta, tətǝwǝkta-du.» ");
INSERT INTO ttq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Den da ad inkar Yahuza Isxarǝyuti wa n iyyan daɣ nəttulab ən Ɣaysa win maraw d əššin, ikka imuzaran ən limaman fəl a dasan-iməl tǝmǝwit tas zʼagu Ɣaysa daɣ fassan-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Isaddawat-tan awen, təzzar əgan-as arkawal n ad t-akfin azrəf. Ad igammay Yahuza təməwit tas zʼagu Ɣaysa daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ǝzəl wa azzaran n əmud wa daɣ tamatšinat təgəlwen šin wər iha xamira, əzəl s ənta a daɣ tawagzaman jəɣal win amud wa n Akkay, ənnan nəttulab i Ɣaysa: «Mənid tareɣ a dak-nǝsǝmmutǝg imensewan n amud wa n Akkay?» ");
INSERT INTO ttq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Təzzar issoka Ɣaysa əššin daɣ nəttulab-net Yerusalam, inn-asan: «Ǝggəzat aɣrǝm, ad tammanayam d aləs ewâyan ətəkin idkâran aman. Ǝlkəmat-as. ");
INSERT INTO ttq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ehan wa iggaz, annat i məššis, \"Inn-ak Ǝššex: 'Məni edag daɣ ahan-nak wa daɣ za nammansaw nak əd nəttulab-in daɣ amud wa n Akkay?'\" ");
INSERT INTO ttq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A kawan-assaknu daɣ suru-net ehan wa n afalla elwân, əhân-tu mutag kul, iknâ. Ǝddi da a dana-za-təsəmmutəgam imensewan win Akkay.» ");
INSERT INTO ttq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ǝglan nəttulab, əkkan aɣrǝm. As din-ewadan ənayan awa da dasan-imal Ɣaysa. Təzzar sammatagan imensewan win Akkay. ");
INSERT INTO ttq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","As tuda tǝfuk osa-du Ɣaysa, iddew əd nəttulab-net win maraw d əššin. ");
INSERT INTO ttq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Isiɣamar Ɣaysa ǝnta ǝd nǝttulab-net den da tamansawan as dasan-inna: «Ǝggəyyeɣ əsilakanaɣ-awan as, iyyan daɣ-wan a dər-i idrâwan da da a di-z-aggin daɣ fassan.» ");
INSERT INTO ttq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iɣšad awen iman-nasan, akkiyyan daɣ-san inna i Ɣaysa: «Ǝngəm wərge nak?» ");
INSERT INTO ttq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Inn-asan: «Iyyan daɣ-wan, kawanay inəttulab-in win maraw d əššin, a dər-i idrâwan əmərədda daɣ əɣəzu iyyanda a zʼagin adi.» ");
INSERT INTO ttq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Illikan as nak Ag Aggadəm a di-iba s əmmək iman-net wa ǝmalan Ǝlkǝttaban daɣ batu-nin, mišan ya, iket alɣazab a t-inǝy awedan wa di-igan daɣ fassan. Awedan wədi, a das-afu fadda a du-wər-iggez əddənet. ");
INSERT INTO ttq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tattin da da as idkal Ɣaysa tagəlla, iga igodan i Məššina, irza tagǝlla ten, izun-tat i nəttulab-net, inn-asan: «Atšiwat da, taɣəssa-nin adi.» ");
INSERT INTO ttq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dəffər awen idkal tǝkabart, iga igodan i Məššina, amaran ikf-asan-tat, namaglazan awa tat-ihan ketnasan. ");
INSERT INTO ttq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Amaran inn-asan: «Adi azni-nin isitaddan arkawal ən tassaq gər Məššina əd tamattay-net. Azni wa, ad inɣǝl fəl tənfa n aytedan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ǝggǝyyeɣ silakanaɣ-awan as, wər zʼələsaɣ tessay n esmad n alɣanab, iket wər d-ewed əzəl wa daɣ zʼašwa wa aynayan daɣ Taɣmar ta n Məššina.» ");
INSERT INTO ttq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dəffər awen issəggad Ɣaysa əd nəttulab-net daɣ təmmalen a d-əgmadnen Azzabur. As tanat-əɣradan, əkkan adɣaɣ wa n Eškan ən Zaytun. ");
INSERT INTO ttq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Inna Ɣaysa i nəttulab-net: «Ketnawan ad iwəliwəl əzəgzan-nawan id ǝnnan Ǝlkǝttaban: \"Ad əwətaɣ amadan, iba-tu, təzzar wəziwəznat ayfad-net.\" ");
INSERT INTO ttq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mišan dǝffǝr ǝtǝwǝsǝnkar-in daɣ tǝmattant, a dawan-in-izaraɣ s akal wa n Galilaya, ǝqqǝlaɣ-awan daɣ-as.» ");
INSERT INTO ttq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Təzzar inn-as Butros: «Kud iwalawal əzəgzan-nasan ketnasan, da wa-nin wər zʼiwəliwil.» ");
INSERT INTO ttq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Inn-as Ɣaysa: «Ǝggǝyyeɣ silakanaɣ-ak as, ahada da, as zʼagu əkəji y aɣora sanatat təɣər, taggâdaɣ-i har karadat tăklaten.» ");
INSERT INTO ttq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mišan izazzawat Butros daɣ batu-net, inna: «Kud iqqal as ǝtǝwǝnɣa kǝrǝz a za nagu nak dǝr-ǝk, da wər kay-z-ǝggǝda. Ǝnnan nəttulab ketnasan awen da.» ");
INSERT INTO ttq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dəffər awen iddew dər-san Ɣaysa s afarag n eškan ǝn zaytun igân esəm Gatsemanay. As din-ewadan, inn-asan: «Qamiwat da da iket di ad tagga šiwatriwen.» ");
INSERT INTO ttq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Izzənkaz fall-asan, iddew əd Butros əd Yaqub əd Yaxya. Tamazayt tenda a daɣ əssəntan man-net aɣšud, iššəwaš. ");
INSERT INTO ttq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Inn-asan: «Awa əgan man-in daɣ ǝɣšud, əbuka a di-aba. Ad wər təfəlam da, amaran a kawan-wǝr-ibǝz etǝs.» ");
INSERT INTO ttq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Izzənkaz fall-asan a əndərran, issəjad ad itattar, igmay daɣ Məššina kud immikkan a t-issəgəg awa t-id-izayan daɣ alwaq wen. ");
INSERT INTO ttq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Inna daɣ təwatray-net: «Ya Abba-nin, arat kul təfrâgaɣ igi-net. Səgəg-i ta daɣ takabart n alɣazab, dər iga awen da ya, taget tara ta-nak, wərgeɣ ta-nin.» ");
INSERT INTO ttq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dəffər awen iqqal-du Ɣaysa inəttulab-net win karad en, ogaz-tan-du ənsân. Issənkar-tan, inna i Butros: «Simɣon, kay adis etəs a təgeɣ? Indar-ak ad taga wala ɣas alwaq iyyanda tokâya? ");
INSERT INTO ttq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Akǝyat, tansǝyam Məššina a kawan-oggazan daɣ jarrabatan n Iblis. Tidət as ǝnnǝyat n aggadəm tǝsidaran igi n awa olaɣan, mišan igdal-as rǝkkǝm ǝn tǝɣǝssa-net igi n awen.» ");
INSERT INTO ttq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ilas əzənkəz fall-asan, iga təwatray ta daɣ iga ihogan. ");
INSERT INTO ttq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dəffər adi ilas-in tewaɣlay ən nəttulab-net win karad, os-en-in ənsân, fəlas awa dasan-iga etəs daɣ iguz ab-as ǝfragan arra ǝn šittawen-nasan. Wər əssenan a das-ənnan. ");
INSERT INTO ttq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","As dasan-d-iga tewaɣlay ta n karadat, inn-asan: «Harwa da tənsâm, təsanfim? Batu za tǝɣrad. Ǝssǝnat âs alwaq ewad-du wa daɣ za təwəgga nak Ag Aggadəm daɣ fassan ən nasbakkadan. ");
INSERT INTO ttq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ǝnkǝrat-in ǝndawat! Ǝnǝyat! Wa di-z-agin daɣ fassan ewad-du.» ");
INSERT INTO ttq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Harwada iššewal Ɣaysa as d-osa Yahuza wa n iyyan daɣ nəttulab-net win maraw d əššin, iddew ǝd tamattay a d-əssiglan muzaran ən limaman əd musanan n Ǝttawret ǝd muzaran ən Kəl-Ǝlyəhud. Tamattay ten tewây šikabiwen əd təburəgen. ");
INSERT INTO ttq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ǝməkkeddəl wa igan Yahuza imâl i tamattay ten əmmək was zʼəzdǝyan Ɣaysa, əs tənna ta dasan-iga: «Aləs was di-tənayam as tu-zalammeɣ, ənta Ɣaysa. Abəzat-tu, taglim dər-ǝs, tagim dər-əs ənnǝyat.» ");
INSERT INTO ttq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Osa-du Yahuza ɣas, ihoz-in Ɣaysa, inn-as: «Ǝššex?» Təzzar izalammat-tu. ");
INSERT INTO ttq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Təggad-in tamattay əs Ɣaysa, təbaz-tu. ");
INSERT INTO ttq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iha-du iyyan daɣ nǝttulab ǝn Ɣaysa, ilbay takoba-net iwat sər-əs akli n Ǝlimam wa Zǝwwǝran, ifras-du təməzzuk-net. ");
INSERT INTO ttq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Təzzar inna Ɣaysa i tamattay ten: «Awak nak ǝjajǝb iyyan n abaydag a əmosa as di-du-tətakkim tewayam šikabiwen əd təburəgen y a di-təbəzam? ");
INSERT INTO ttq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wərgeɣ əzəl kul əlleɣ gar-ewwan, sasaɣra daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, mafel wər di-təbezam? Ǝssənat za as, awa igan da, igâ fəl ad andu awa sər-i ənnan Ǝlkəttaban.» ");
INSERT INTO ttq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Den da a t-əfalan nəttulab-net ketnasan, əddəggagan fall-as. ");
INSERT INTO ttq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ilkam ǝmawad iyyan i tamattay en, ilsa afər ihossayan daw wər iqqen arat. Ǝggadan-in sər-ǝs meddan y ad t-əbəzan, ");
INSERT INTO ttq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","oyy-asan-du afər wa ilsa, ozal wər ilsa arat. ");
INSERT INTO ttq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Immeway Ɣaysa s Ǝlimam wa Zǝwwǝran a ɣur əddewan muzaran ǝn limaman, ǝd muzaran ən Kəl-Ǝlyəhud, əd musanan n Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iga Butros i Ɣaysa ləkkum zagren har iggaz ammas n aɣalla n aɣaywan n Ǝlimam wa Zəwwəran. Iqqim ad isukus ɣur maššaɣalan n Ǝlimam wa Zǝwwǝran əqqimnen əs təmsay tərɣât den. ");
INSERT INTO ttq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","As itaggu awen, imuzaran ən limaman d Asaggawar wa Zǝwwǝran ketnet gammayan i zʼaggayen fəl Ɣaysa fǝl ad ǝgrǝwan tarrayt n igi ǝn man-net, mišan wər t-əgrewan, ");
INSERT INTO ttq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","fəlas aytedan aggotnen a d-ənkarnen əgan fəl Ɣaysa šiggǝyyawen əmosnen bahu, mišan wər tanat-təha ši tənimannakat əd tahadat. ");
INSERT INTO ttq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ǝnkaran-du wiyyad daɣ-san əssəwaran-tu bahu, ənnan: ");
INSERT INTO ttq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nəsl-âs as inna: \"Ehan wa Zǝwwǝran n Ǝlɣibada, s aytedan a t-əkrasnen, a tu-jəbbərəjjeɣ, əssəbdəda daɣ karad adan iyyan wər əkresan aytedan.\"» ");
INSERT INTO ttq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mišan batu ta dâ, əmmizrayan daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Təzzar inkar Ǝlimam wa Zǝwwǝran, ibdad daɣ ammas n əljəmaɣat, issəstan Ɣaysa, inn-as: «Awak arat a wər təgənna daɣ təɣəttas šin dak-tawagginen da?» ");
INSERT INTO ttq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mišan igla Ɣaysa iffista, wər das-inna wala. Ilas Ǝlimam wa Zǝwwǝran, inn-as: «Awak kay a imosan Ǝlmǝsix, Barar ən was nǝtaggu tǝmmalen?» ");
INSERT INTO ttq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Inn-as Ɣaysa: «Awalla əmosaq-qu; amaran a di-tənǝyam nak Ag Aggadəm əqqima daw əɣil n Ǝməli ən Tarna, tǝnǝyam-i deɣ ǝzaya-du, əheɣ igarakan əgmâda-du ijənnawan.» ");
INSERT INTO ttq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","As isla Ǝlimam wa Zǝwwǝran y awen, izazzarrat tǝkadkat-net fəl awa ǝgan man-net daɣ ǝɣšud, inna: «Awak ma nəkka i tǝgǝyyawen šiyyad? ");
INSERT INTO ttq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Təslâm y ǝmadraw wa iga da i Mǝššina! Ma tənnam?» Ǝnnan ketnasan əššəriɣa-net tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A fall-as sutufan wiyyad daɣ-san, ǝɣmasan-as, ad t-əggâtan, gannin-as: «Kay ya ənnǝbi, əməl wa kay-iwatan.» Dəffər awen itawakfa i magazan n Ahan wa Zǝwwǝran n Ǝlɣibada a das-tagin šiqqas. ");
INSERT INTO ttq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Harwa da iqqim Butros daɣ ammas n aɣalla en da, as du-tosa iyyat daɣ tamaššaɣalen n Ǝlimam wa Zǝwwǝran, ");
INSERT INTO ttq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","tənay-tu isukus əs təmsay, təzaggazd-ay, tənn-as: «Kay da, iyyan daɣ aytedan win ǝddewnen əd Ɣaysa wa n aɣrǝm ǝn Nazaret!» ");
INSERT INTO ttq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mišan iggad Butros as t-izdây, inna: «Wərmad əssânaɣ awa daɣ-i təššewala, za wər t-əgreɣ.» Təzzar igmad aɣalla, ikka imi-net. Iɣra əkəji aɣora da tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tənay-tu tǝmaššaɣalt təlas tənna y aytedan əbdâdnen den: «Aləs wa, iyyan daɣ-san a imos.» ");
INSERT INTO ttq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ilas Butros iggad Ɣaysa. Arat n amazay dəffər awen, ǝnnan aytedan əbdâdnen den, ǝntanay dâ, i Butros: «Illikan as kay da iyyan daɣ-san a təmosa, fəlas kay da in akal ən Galilaya.» ");
INSERT INTO ttq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ad ihhad Butros, igannu: «Məššina ya təlɣanaɣ-i kud bahu a əge. Ǝhâdaɣ-awan as wər əzdayaɣ aləs was təgannim əddi.» ");
INSERT INTO ttq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Da da ɣas ad inna Butros awen, ənta ad iga əkəji y aɣora teɣaray ta n sanatat, ikta-du Butros batu ta das-iga Ɣaysa, as das-inna: «As zʼagu əkəji y aɣora sanatat təɣər, təgeɣ-i karad ikusan i təzdəyt.» Təzzar ǝɣšadan man ǝn Butros wǝllen iggaz šin tala. ");
INSERT INTO ttq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","As affaw aɣôra əmmənayan muzaran ən limaman ǝd muzaran ən Kǝl-Ǝlyǝhud əd musanan n Ǝttawret, almaɣna Asaggawar wa Zǝwwǝran ketnet, sassakradan Ɣaysa, ewayan-tu, əgan-tu daɣ fassan n ənaxkim Bilatǝs. ");
INSERT INTO ttq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Issəstan-tu Bilatǝs, inn-as: «Awak kay daɣ a imosan əmənokal ən Kǝl-Ǝlyǝhud?» Inn-as Ɣaysa: «Kay iman-nak as tǝnneɣ adi.» ");
INSERT INTO ttq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ad sawaran muzaran ən limaman Ɣaysa ark igitan aggotnen. ");
INSERT INTO ttq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ilas-tu Bilatǝs əsəstan, inn-as: «Təsalla y aratan kul win kay-ǝsawaran da. Kay ma tənneɣ?» ");
INSERT INTO ttq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Iqqim Ɣaysa wər das-iles tənna n arat. Isammaklal awen əs Bilatǝs. ");
INSERT INTO ttq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Id d-iɣlay ǝmud wa n Akkay a d-ikkəs ǝnaxkim Bilatǝs amaskasaw was tara tamattay agamad. ");
INSERT INTO ttq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","As itaggu awen ill-ay aləs igan esəm Barɣabbas, ihân kasaw ənta əd nəffəllag wiyyad əs kala jannajarwayan tamattay har əgan iman n awedan daɣ awen. ");
INSERT INTO ttq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tənkar tamattay ad təgammay daɣ Bilatǝs a das-agu tənəfust ta ɣur-əs təlmad. ");
INSERT INTO ttq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Inn-asan Bilatǝs: «Awak tara a təgam a dawan-əkkəsaɣ əmənokal ən Kǝl-Ǝlyǝhud daɣ fassan?» ");
INSERT INTO ttq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ǝnta Bilatǝs issân as aššaddat ǝn manzaɣ ən muzaran ən limaman Ɣaysa a fəl t-ǝgan daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mišan əgan-du muzaran ən limaman daɣ tamattay ad tǝdgǝz Bilatǝs y a das-d-ikkəs Barɣabbas, wərgeɣ Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ilas Bilatǝs awal, inn-asan: «Daɣ adi mas təram ad t-aga y aləs was təgannim da əmənokal ən Kǝl-Ǝlyǝhud?» ");
INSERT INTO ttq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ǝlasan adakal ǝn maslan-nasan ad gannin: «Taytay-tu fəl tǝgǝttawt, a t-iba!» ");
INSERT INTO ttq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Inn-asan Bilatǝs: «Mafel za? Ma iɣšad?» Mišan sahhaken wəllen imaslan-nasan, ad gannin: «Taytay-tu fəl tǝgǝttawt!» ");
INSERT INTO ttq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Issof Bilatǝs ləkkum y awa təra tamattay. Ikkas-asan-du Barɣabbas daɣ kasaw, Ɣaysa amaran isassag-as tenaɣay labasat s ələkkud dǝffǝr adi amaran ixkam-as ǝtəwətǝytay fəl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ewayan sojitan Ɣaysa s ammas n aɣarɣar n aɣalla n ahan wa n ǝššǝriɣa. Ǝɣran-du sojitan kul win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ǝssəlsan-tu əbərnuz zaggaɣan wa lasan mənokalan, əssəwaran-as deɣ almat ən təkəbbut zun ta n mǝnokalan təgât daɣ šənnanan. Imos awen igi daɣ-as tamakkakkayt. ");
INSERT INTO ttq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A tu-saslaman, gannin-as: «Oyy-ik, əmǝnokal ən Kǝl-Ǝlyǝhud!» ");
INSERT INTO ttq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ad ǝggatan eɣaf-net s agabal ǝn telant, sutufan fall-as, tigərəffen sajadan-as. ");
INSERT INTO ttq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","As daɣ-as əɣradan igi ən təmakkakkayt tǝrtayat ǝd tǝsǝssǝlka, əkkəsan fall-as ǝbərnuz zaggaɣan wa t-əssəlsan, əssoɣalan-tu isǝlsa win-da-net, əglan dər-əs, əgmədan dər-əs aɣrǝm y ad t-attaytayan fəl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ǝmmənayan sojitan əd Simɣon wa n əɣrəm ən Qǝrwan wa erawan Alaskandər əd Rufus ifâl-du šiwǝgas. Šahhaššalan-tu aggay ən tǝgǝttawt ta fəl zʼitəwətǝytəy Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ewayan Ɣaysa s adag as itawannu Golgota, almaɣna n awen «Edag wa n Təkǝyya.» ");
INSERT INTO ttq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ǝkfan-tu esmad n əzzəbib irtâyan d amagal imosan ǝzzǝnǝf ǝn taɣǝlbast ifannazan talawayt, mišan ugay Ɣaysa əs təssay-nasan. ");
INSERT INTO ttq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Təzzar ətaytayan-tu sojitan fəl tǝgǝttawt, əzunan isəlsa-net əs təšaɣeren. ");
INSERT INTO ttq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ǝdəgəlšet as t-əttaytayan fəl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ǝttaytayan dənnəg-əs əsəllum a fəl iktâb əddəlil wa sər-əs d-ewayan tǝmattant. Ǝsəllum en, iktâb fall-as as: «Awa Ǝmǝnokal ǝn Kǝl-Ǝlyǝhud.» ");
INSERT INTO ttq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ijjiyat Ɣaysa d ǝššin jujab ǝn baydagan ətəwətǝytay. Iyyan itawataytay daɣ əɣil ən Ɣaysa, wa hadan itawataytay daɣ zalgat-net. ");
INSERT INTO ttq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ǝmmək en da as tənda batu ta tənnat daɣ Ǝlkǝttaban: «Ad uddan daɣ maggan ən təkma.» ");
INSERT INTO ttq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A das-taggin aytedan win du-takaynen den ark batuten, siwəliwilan iɣafawan-nasan, gannin-as: «Dew! Kay wa innan ad təjəbbərəjjeɣ Ehan wa Zəwwəran n Ǝlɣibada tələsaq-qu akaras daɣ karad adan, ");
INSERT INTO ttq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","əmərədda safsu iman-nak, tazzabbeɣ-du tǝgǝttawt di.» ");
INSERT INTO ttq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ǝmmǝk en daɣ as imuzaran ən limaman əd musanan n Ǝttawret da əgân daɣ-as tamakkakkayt, tinəmənnin gar-essan: «Ǝnta wa issəfsan aytedan, wər ifreg əsəfsi ən man-net. ");
INSERT INTO ttq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kud ənta Ǝlmǝsix a imos, wa n əmənokal n Israyil, azzabbatet-du tǝgǝttawt əmərədda ad nənəy adi, nəzzəgzən sər-əs.» Meddan win dər ijjiyat Ɣaysa ətəwətǝytəy əntanay da ǝhân šin-net. ");
INSERT INTO ttq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","As iga ammasnazal, əlsanat šiyyay akal ketnet har tǝga tazzar. ");
INSERT INTO ttq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","As təga tazzar, idkal Ɣaysa əməsli-net, inna: «Eli, Eli, lama sabaxtani?» Almaɣna n adi: «Ya Ǝməli-in, Ya Ǝməli-nin, mafel toyyeɣ-i əd man-in?» ");
INSERT INTO ttq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ǝslan-as arat daɣ aytedan win əbdadnen den, ad gannin: «Səsəmat! Iɣarru ənnəbi Ilyas!» ");
INSERT INTO ttq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ozal-in sər-əs awedan iyyan, issəlmaɣ-du təduft daɣ bǝnegǝr, ittal-tat d əmi n agabal, izzal-as-tat-in y a tat-aššǝw, igannu: «Səllanat, ad nəssən a t-id-asu ənnəbi Ilyas, ikkəs-t-idu fəl tǝgǝttawt ta» ");
INSERT INTO ttq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amazay wen da ad ikkas Ɣaysa əməsli issohen, amaran əgmadan-tu man. ");
INSERT INTO ttq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Assaɣat ten da ad izzərrat əfər wa zǝwwǝran imosan anaɣer gər adag wa zəddigan əd wa ogaran tazdak daɣ Ahan wa Zǝwwǝran n Ǝlɣibada. Issərrat-du anaɣer wen ɣur afalla har eres. ");
INSERT INTO ttq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","As inay kabtan ǝn sojitan ǝn Kǝl-Ǝrrum ibdâdan den əmmək was əgmadan man Ɣaysa, inna: «Illikan as aləs wa Barar ən Məššina.» ");
INSERT INTO ttq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ǝbdâdnat deɣ tədoden šiyyad sədi, əswâdnat daɣ awa igan den. Šidoden en təh-enat Maryama Madǝl, əd Maryama ta terawat Yaqub wa əndərran əd Yosas, d iyyat təgât esəm Salma. ");
INSERT INTO ttq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Harwa iha Ɣaysa akal wa n Galilaya as das-əlkamnat, ədhâlnat-tu s awa əfragnat. Ǝbdâdnat deɣ tədoden šiyyad den aggotnen a d-əddewnen əd Ɣaysa əs Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","As tokay takəst n əzəl wa n əlgəmət, simutugan aytedan y əzəl wa n təsanfawt; ");
INSERT INTO ttq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ikka Yusǝf wa n əɣrəm n Arimatay ehan ən Bilatǝs. Yusǝf aləs a imos itiwasaɣmaran ihân Asaggawar wa Zǝwwǝran, imos deɣ awedan igân attama daɣ assa ən Taɣmar ta n Məššina. Ǝnta a igan əmazal ən taholat imosan as ikka Bilatǝs, igmay daɣ-as taɣǝssa ən Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Isammaklal əs Bilatǝs tərrub n agamad wa əgan man Ɣaysa. Isassaɣra-du kabtan wanâd, issəstan-tu kud itidda iba ən Ɣaysa wala. ");
INSERT INTO ttq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","As das-iga kabtan wa isalan n iba ən Ɣaysa, ikfa Bilatǝs Yusǝf turagat n ad idkəl taɣǝssa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Izzənza-du Yusǝf šifit ta təhossayat, ikkas-du Ɣaysa fəl tǝgǝttawt, ig-ay daɣ-as, təzzar ig-ay daɣ əzəkka imosan akazam, isaɣɣararad-du təhunt zəwwərat ihar sər-əs imi-net. ");
INSERT INTO ttq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tǝlla Maryama Madǝl den əd Maryama ta terawat Yosas, ǝswâdnat daɣ adag wa daɣ tətawagga tǝɣǝssa ǝn Ɣaysa den. ");
INSERT INTO ttq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","As okay əzəl wa n tǝsanfawt, tənkar Maryama Madǝl əd Maryama ta terawat Yaqub əd Salma əzzənzanat-du aḍutan əzodnen y a tan-ǝsǝlǝlnat taɣǝssa ən Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ǝglanat aɣôra, ɣur gǝmmud ən təfuk əzəl wa n alxad, əkkanat əzəkka. ");
INSERT INTO ttq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ǝglânat tinəmənninat gər-essanat: «Nakkanatay a da ma dana-z-isəɣɣərurədan təhunt ta təharat əzəkka?» ");
INSERT INTO ttq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ǝdkalnat asawad-nasnat, ənaynat as, təhunt tanad, tətiwasaɣararad sədi. Tǝhunt ten da za tǝkna tǝzzǝwwǝrt. ");
INSERT INTO ttq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ǝggaznat əzəkka, ənaynat daɣ-as aləs n əmawad n əsamlal, iqqîm daɣ əɣil-nasnat, ərmaɣnat. ");
INSERT INTO ttq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Inn-asnat: «Ad wər tərməɣmat. Ɣaysa wa n Nazaret, wa itawataytayan fəl tǝgǝttawt as təsaggadmat. Wər illa da. Inkar-du daɣ tǝmattant. Ǝnakmat edag was kala a daɣ-as tǝnsa tǝɣǝssa-net. ");
INSERT INTO ttq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ǝmərədda aglimat təməlmat i nəttulab-net, harkid Butros, as a dasan-in-izar s akal wa n Galilaya. Den da a tu-za-tənǝyam s əmmək was dawan-t-inna.» ");
INSERT INTO ttq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Təzzar əgmadnat-du əzəkka ozâlnat, təga daɣ-asnat taysǝst, isimaklal sǝr-ǝsnat awa igan den. Awa əganat daɣ tərəmmeq wər t-illa i s ənnanat arat daɣ tarrayt. ");
INSERT INTO ttq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aɣora n əzəl wa n alxad a d-inkar Ɣaysa daɣ tǝmattant, iga ənəfilal-net wa azzaran i Maryama Madǝl, tas kala daɣ-as ikkas əssa kǝlǝsuf. ");
INSERT INTO ttq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Təgla təga isalan y aytedan win as kala tidawan əd Ɣaysa. As itaggu awen əɣšâdan man-nasan, hallin iba-net. ");
INSERT INTO ttq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mišan as əslan as iddâr, tənây-tu, ugayan s ad əzzəgzənan awen. ");
INSERT INTO ttq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dəffər awen inafalal Ɣaysa əs təməwit iyyat y əššin daɣ nalkiman-net jiwankatnen daɣ əsuf. ");
INSERT INTO ttq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tǝzzar ǝqqalan Yerusalam əmalan awen i nalkiman win hadatnen, mišan əntanay da wər dasan-itawazagzan awen. ");
INSERT INTO ttq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dəffər awen inafalal-du Ɣaysa i nəttulab-net win maraw d iyyan daɣ amazay a daɣ tattin. Issoɣal-tan təgna n iba n ǝzǝgzan-nasan əd taggarmamt ən wallan-nasan, fəlas wər əzzəgzanan y aytedan win t-ənaynen dəffər tanakra-net daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Inn-asan: «Agliwat, tilalam əddənet ketnet təmmâlam isalan n Ǝlinjil y id t-illa awedan. ");
INSERT INTO ttq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","I izzəgzanan, itawasalmaɣ deɣ daɣ aman s esəm-in ad igrǝw efsan. Amaran wa ugayan s ǝzǝgzan, ad t-iwər attadib ən Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ǝntanatay da alɣalamaten šin za tǝwǝnǝynen fǝl aytedan win sər-i əzzəgzannen: Ad əkkəsan kǝlǝsuf daɣ aytedan əs tarna n esəm-in, əššiwəlan awalan ən tawšeten wər əzdayan, ");
INSERT INTO ttq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","amaran kud ədkalan taššolen əs fassan-nasan wala əšwan sənsəg da wər dasan-z-iɣšəd adi wala. As əssəwaran ifassan-nasan imiranan, ad əzzəyan.» ");
INSERT INTO ttq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ig-asan Ǝməli Ɣaysa batu ten ɣas, immədkal əs jənnawan, iqqim daɣ əɣil ən Məššina. ");
INSERT INTO ttq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ǝntanay amaran, əglan ad əmmalan isalan n Ǝlinjil daɣ adag kul. Illil-asan Ǝməli s əššəɣəl wen, isataddu awa gannin s alɣalamaten ǝmosnen təlmǝɣjujaten šin taggin.");
INSERT INTO ttq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ya Tayofil wa ǝkneɣ saɣmar, aytedan aggotnen a ǝktabnen isalan n awa ɣur-naɣ igan, s ǝmmǝk iman-net was dana-tan-ǝssoɣalan aytedan win tan-ǝggǝyatnen ǝs šittawen-nasan harwa ɣur ǝnǝtti-nasan, ǝqqalan aytedan ǝšɣâlnen daɣ amel n awal ǝn Mǝššina. Awen da fǝl di-d-iggaz nak da, dǝffǝr as ǝššiggaraɣ isalan di kul s ǝlluɣ a d-ibazan ɣur ǝlǝsǝl-nasan, a dak-in-aga y-asan akatab innizzaman, ");
INSERT INTO ttq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","fǝl ad tǝkkǝsaɣ aššak as tǝssunen šin tǝtǝwasasaɣra ǝttiddanat. ");
INSERT INTO ttq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Elan win daɣ imos Herod ǝmǝnokal n akal ǝn Yahudǝyya, ill-ay ǝlimam iyyan igân esǝm Zakarayya ihân taggayt ǝn limaman win hayawan n Abǝya. Tantut-net tahayawt ǝn Harun, esǝm-net Elizabet. ");
INSERT INTO ttq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ǝnta dǝr-ǝs ǝmosan alɣadilan dat Mǝššina, ǝgân y alwajiban n Ǝmǝli d alamaran-net lǝkkum daɣ wǝr ǝlen lahan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wǝr ǝlen barar waliyyan fǝlas Elizabet a wǝr nǝtilu bararan, ǝgmâdan-tan deɣ elan wǝllen. ");
INSERT INTO ttq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ǝzǝl iyyan itaggu Zakarayya dat Mǝššina ǝššǝɣǝl wa taggin limaman fǝlas taggayt ǝn limaman ta iha as d-issǝɣlay igi n awen. ");
INSERT INTO ttq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ǝbaznat-tu tašaɣeren, ǝmosnen as, ǝnta a zʼiggǝzan edag wa zǝddigan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada n Ǝmǝli, issǝqqǝd daɣ-as aḍutan fǝl majmar wa iskatan y awen. Šišaɣeren šin imos igi-nasnat alɣadat ǝn limaman. ");
INSERT INTO ttq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","As iga alwaq wa daɣ taqqadan aḍutan, tamattay ketnet tǝbdâd daɣ tǝfǝrray n Ahan wa Zǝwwǝran n Ǝlɣibada, tǝtattar. ");
INSERT INTO ttq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wala a ihogan inafalal-as-du angalos n Ǝmǝli ibdâd daɣ ǝɣil ǝn majmar wa n ǝsǝqqǝd n aḍutan. ");
INSERT INTO ttq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Inay Zakarayya angalos ɣas irmaɣ, tǝggaz-tu tasa. ");
INSERT INTO ttq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mišan inn-as angalos: «Zakarayya! A kay wǝr tǝggǝz tasa fǝlas Mǝššina iqbâl mansay-nak, tantut-nak Elizabet ad tǝgrǝw barar, amaran ag-as esǝm Yaxya. ");
INSERT INTO ttq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ad taddaweɣ, tǝfǝliwǝsaɣ; tǝsǝddǝwǝt deɣ tǝhǝwt-net aytedan aggotnen, ");
INSERT INTO ttq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","amaran ad iqqǝl awedan zǝwwǝran dat Ǝmǝli. Wǝr mad as zʼašu esmad n alɣanab wala deɣ esmad waliyyan. Ad t-idnǝy Infas Wa Zǝddigan harwa da iha tadist n anna-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ad d-issuɣǝl Kǝl-Israyil aggotnen Ǝmǝli-nasan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ǝnta a du-z-izaran y Ǝmǝli imos anammazul-net, igrâw Infas Wa Zǝddigan ǝd tarna šilat ǝn win igraw ǝnnǝbi Ilyas, fǝl a d-awǝy alxer gǝr aytedan ǝd bararan-nasan, awǝy-du inǝmmǝzray s ad ilen tayttay ta ǝlan aytedan win ǝɣdalnen. Tǝmǝwit tǝdi as zʼisǝmmutǝg y Ǝmǝli tamattay tǝsimatagat i lǝkkum y-as.» ");
INSERT INTO ttq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tǝzzar inna Zakarayya y angalos: «Mǝni alɣalamat ta di-za-tǝssusǝnat as adi ad agu? Ǝnta nak aɣmar waššaran a ǝmosa, tantut-in deɣ ǝglân daɣ-as elan wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Inn-as Angalos: «Awa nak Jibril, akli ǝn Mǝššina wa dat-ǝs ibaddadan. Ǝnta a di-d-izimmazalan sǝr-ǝk y a dak-agaɣ isalan hossaynen win di. ");
INSERT INTO ttq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amaran dad zamas wǝr tǝzzǝgzanaɣ isalan win dak-ǝgeɣ da, as zʼandinen daɣ alwaq-nasan, ad ammadad ǝmi-nak. Wǝr za tǝlǝsaɣ awal iket wǝr d-osa ǝzǝl wa daɣ zʼagu arat wǝdi.» ");
INSERT INTO ttq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Awen as itaggu tamattay tǝqqâl i Zakarayya, ǝqqânan ɣafawan-nasan y awa t-in-isahhagan daɣ adag wa zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","As t-id-igmad, indar-as a dasan-iššiwǝl fǝlas imi-net a immǝdadan, a dasan-isidugun. Ǝssanan as arat iyyan a das-d-inafalalan. ");
INSERT INTO ttq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","As issǝnda adan-net win ǝššǝɣǝl daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, iqqal aɣaywan-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dǝffǝr awen tǝga tantut-net Elizabet tadist, tǝzzar tǝgdal i man-net ǝtǝwǝnay har tǝga sǝmmosat tǝlil, tǝgannu: ");
INSERT INTO ttq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Awa igi n Ǝmǝli! Ǝnta daɣ-i issanan, ikkas-i asakor wa di-ǝggatan aytedan.» ");
INSERT INTO ttq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tǝha Elizabet tallit-net ta n sǝdisat as izammazal Mǝššina angalos Jibril s ǝɣrǝm as itawannu Nazaret ihân akal ǝn Galilaya. ");
INSERT INTO ttq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Issok-ay tǝmawat iyyat wǝr nǝzday meddan harwada tǝgât esǝm Maryama. Amaran Maryama tǝsimarkas d alǝs igân esǝm Yusǝf, imosan arat daɣ ǝzzurrǝyya n ǝmǝnokal Dawǝd wa n ǝnnǝbi. ");
INSERT INTO ttq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Os-et-du angalos, inn-as: «Maryama, ma tǝxlaka! Ǝmǝli izizabbat-du fall-am arraxmat-net. Issân daɣ-am.» ");
INSERT INTO ttq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iqqan awal wen eɣaf ǝn Maryama, idgaz-tat, tǝzzar ad tǝsamadran awa imos almaɣna n assalam wen. ");
INSERT INTO ttq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Inn-as angalos: «A kam-wǝr-tǝgǝz tasa Maryama, Mǝššina izizzabbat-du fall-am arraxmat-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ad taga tadist, tǝgrǝwa barar, tagaɣ-as esǝm Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ad itǝwǝsǝɣmǝr, agu esǝm Barar ǝn Mǝššina di n Amadkol. Ad t-akfu Ǝmǝli Mǝššina taɣmar n amaraw-net Dawǝd, ");
INSERT INTO ttq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","izar i hayawan ǝn Yaqub har faw, amaran tǝmǝnukǝla-net ad tǝɣlǝl.» ");
INSERT INTO ttq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tǝnna Maryama y angalos: «Manǝmmǝk as zʼagu adi ǝnta nak harwada wǝr ǝzdaya meddan?» ");
INSERT INTO ttq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Inn-as angalos: «A fall-am d-azzabbat Infas wa Zǝddigan, talsim tanaya ǝn Mǝššina di n Amadkol, tǝqqǝl-am zun telay, awen da fǝlas barar wa za tileɣ ad agu esǝm Ǝmizdag agu deɣ esǝm Barar ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ǝnâm tǝšǝqqaq-nam Elizabet! Ǝglân daɣ-as elan wǝllen mišan tǝga tadist ǝn barar. Ǝnta tas itawannu wǝr tǝtilu bararan, tallit-net ta n sǝdisat a tǝha ǝmǝrǝdda, ");
INSERT INTO ttq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","fǝlas wǝr t-illa a imosan muxal fǝl Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tǝnn-as Maryama: «Nak taklit n Ǝmǝli, itǝwǝgget-i awa tǝnneɣ.» Tǝzzar ifal-tat angalos. ");
INSERT INTO ttq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tǝnkar Maryama daɣ adan en da, tǝhaz tǝkka taɣrǝmt iyyat n akal ǝn Yahudǝyya imosan akal n ǝdɣaɣan. ");
INSERT INTO ttq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tos-in ehan ǝn Zakarayya, tǝssǝslam fǝl Elizabet. ");
INSERT INTO ttq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Da da ɣas ad tǝsla Elizabet y assalam ǝn Maryama ǝnta ad izabaggat barar wa ihan tadist n Elizabet, tǝzzar idnay-tat Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tǝdkal Elizabet ǝmǝsli-net, tǝnna: «Togara šidoden kul agaraw n arraxmat, barar deɣ wa du-z-igmǝdan tadist-nam igrâw arraxmat. ");
INSERT INTO ttq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Awak nak ma ǝmosa as di-du-tǝtasu anna n Ǝmǝli-nin? ");
INSERT INTO ttq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Da da ɣas ad ǝsleɣ y assalam-nam ǝnta ad izabaggat barar wa ihan tadist-in fǝl tǝdǝwit. ");
INSERT INTO ttq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tǝbbilalaɣ kam tǝzzigzanat as, awa dam-inna Ǝmǝli ad andu.» ");
INSERT INTO ttq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tǝnna Maryama: «Ǝwǝl-in immâl adkul n Ǝmǝli, ");
INSERT INTO ttq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iman-in isidawat-tan Mǝššina di n Ǝmaɣlas-in. ");
INSERT INTO ttq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Fǝlas asawad a din-iga daɣ tǝmmǝdrǝyt ǝn tǝklit-net. A ibazan ɣur ǝmǝrǝdda aytedan n azzaman kul ad annin ǝbbilalaɣ. ");
INSERT INTO ttq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Fǝlas Wa ilan Tarna ig-i aratan zawwarnen. Esǝm-net i zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Itihǝnǝttit y aytedan n azzaman kul win t-ǝksudnen. ");
INSERT INTO ttq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iga ǝfus-net imazalan ǝn tǝla ǝn tarna. Iziwazawaz aytedan win ǝdkalnen iman-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ikkas daw muzaran taɣmar-nasan, idkal šilǝqqawen. ");
INSERT INTO ttq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Isayyawan win ǝlluznen daɣ awa izodan, oyya imǝggǝrgas ǝqquran fassan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Idhal Kǝl-Israyil n eklan-net, fǝlas itihǝnǝttit ");
INSERT INTO ttq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","y Ibrahim d ǝzzurrǝyya-net har faw, imos awen arkawal iga i marawan-nana.» ");
INSERT INTO ttq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tǝmal Maryama ɣur Elizabet har tǝga edag ǝn karadat tǝlil amaran tǝqqal aɣaywan-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Osa-du alwaq n iguz n ǝmzur fǝl Elizabet, tǝgraw barar. ");
INSERT INTO ttq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ǝslan mahharagan-net ǝd šǝqqaɣan-net ǝhǝnǝtta zǝwwǝran wa das-iga Mǝššina da, ǝddǝwen ǝntanay da. ");
INSERT INTO ttq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","As ǝzǝl wa n ǝttam osan-du y ad sǝmmǝmkǝdan barar. Ǝrân a das-agin esǝm Zakarayya, esǝm wa daɣ iga abba-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mišan tǝnn-asan anna-net: «Kala kala! Ad agu esǝm Yaxya.» ");
INSERT INTO ttq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ǝnnan-as: «Esǝm ya wǝdi wǝr tǝleɣ ǝšǝqqaɣ a t-igân!» ");
INSERT INTO ttq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tǝzzar ad sidugunan y abba ǝn barar, y a dasan-imǝl esǝm was ira ad t-agu barar-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Isaddagan-asan Zakarayya a t-id-akfin ǝsǝllum. Iktab fall-as: «Esǝm-net Yaxya.» Isammaklal sǝr-san awen ketnasan. ");
INSERT INTO ttq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tǝzzar okay ǝmǝdǝd Zakarayya amazay wen da, immora ilǝs-net, ad itaggu tǝmmalen i Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tǝggaz tasa aytedan kul win ǝxsarnen daɣ ihǝz-nasan, wazawazan salan n awa igan den daɣ akal ǝn Yahudǝyya ketnet wa n ǝdɣaɣan. ");
INSERT INTO ttq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aytedan kul win ǝslanen awen ǝtaffan-tu daɣ wallan-nasan, gannin: «Ma zʼiqqǝl wa da barar?» Illikan as issiwar-tu Ǝmǝli ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Idnay Infas wa Zǝddigan Zakarayya wa n abba ǝn barar, isannafalal-as Mǝššina awal-net, ad igannu: ");
INSERT INTO ttq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Tǝmmal i Mǝššina, Ǝmǝli n Israyil, fǝlas masnat a iga daɣ tamattay-net, isaddarf-tat. ");
INSERT INTO ttq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ikkas-ana-du daɣ ahan n ǝkli-net Dawǝd Amaɣlas ilân tarna, ");
INSERT INTO ttq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","a dana-z-agǝzan daɣ zǝnga-nana, ikkǝs-ana daɣ fassan ǝn maksanan-nana kul. Imos awen arkawal iga daɣ mawan n ǝnnǝbitan-net win irǝw, isinafran. ");
INSERT INTO ttq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ǝmmǝk wǝdi as issǝkna tǝhanint-net i marawan-nana, issǝnda arkawal ǝn tassaq-net zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Arkawal wen ihâd fall-as y amaraw-nana Ibrahim as, ");
INSERT INTO ttq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a danaɣ-assafsu daɣ zǝnga-nana, fǝl a tu-nǝɣbǝd ši wala tasa ǝn waliyyan. ");
INSERT INTO ttq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nǝzǝddig noɣâd iket nǝddar. ");
INSERT INTO ttq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amaran kay barar-in, a kay iwǝr esǝm ǝnnǝbi ǝn Mǝššina di n Amadkol, kay a du-z-izaran y Ǝmǝli fǝl a dat-ǝs takna tarrayt-net, ");
INSERT INTO ttq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tǝssusǝna tamattay-net as efsan ǝllân ɣur tǝsureft ǝn bakkadan. ");
INSERT INTO ttq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Awen itagg-ay Ǝmǝli-nana Mǝššina fǝl ǝssǝbab ǝn tǝhanint tagget ta tu-tǝhat. Adi a fǝl dana-du-z-asu Ǝlmǝsix ola ǝd gǝmmud ǝn tǝfuk, ");
INSERT INTO ttq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","fǝl ad imǝlǝwlǝw ǝnnur-net fǝl aytedan win ǝqqimnen daɣ šiyyay, ǝhân telay ǝn tǝmattant, izǝzzǝlulǝɣ takkolen-nana daɣ tarrayt ta n alxer.» ");
INSERT INTO ttq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ad idaggal Yaxya, tǝtawad-t-id tayttay-net. Izdaɣ ikallan ǝn saffan har ǝzǝl wad issosan Kǝl-Israyil fǝl man-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Azzaman win daɣ zʼihǝw Ɣaysa a daɣ omar Qaysara Ogǝstǝs wa n ǝttǝbǝl n Ǝrrum s ad uddanan aytedan kul win taɣmar-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tuddant ten ǝnta a tazzarat. As tǝga Kirinǝyas a imosan ǝmuzar n akal wa n Surǝya. ");
INSERT INTO ttq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aytedan kul gallin ad uddanan. Ǝkkulluk n awedan ikka aɣrǝm ǝn marawan-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Adi fǝl igmad Yusǝf ǝnta da aɣrǝm wa n Nazaret ihân akal ǝn Galilaya, igǝzzay s ǝɣrǝm n aljad-net ǝmǝnokal Dawǝd a t-imosan aɣrǝm ǝn Betalxam, ihân akal ǝn Yahudǝyya, ");
INSERT INTO ttq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","fǝl a daɣ-as uddan. Iddew ǝd Maryama dǝr isimarkas. As itaggu awen da tǝga tadist. ");
INSERT INTO ttq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ǝhân Betalxam as fall-as iga alwaq n iguz n ǝmzur. ");
INSERT INTO ttq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tǝggaz Maryama amzur n aɣafadday-net. Itaggu awen dǝgma n ǝsǝgǝn n aharay osaɣan d ahan wa ɣur ǝzzǝbben fǝlas edag a wǝr ǝgrewan daɣ ahan en. Tǝttal barar daɣ ǝfǝr, tǝssǝns-ay daɣ ǝɣlal ilân den. ");
INSERT INTO ttq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Akal en ǝhân-tu madanan ǝssimbarnen eharay-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Den da a d-inafalal dat-san angalos n Ǝmǝli, tǝsammalawlaw tanaya n Ǝmǝli edag wa ǝhan, ǝgan tǝrǝmmeq zǝwwǝrat. ");
INSERT INTO ttq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Inn-asan angalos: «Ad wǝr tǝrmǝɣam, isalan olaɣnen a dawan-d-ewaya a du-z-awǝynen tǝdǝwit tagget ǝs tamattay ketnet. ");
INSERT INTO ttq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Azalada Ǝmaɣlas-nawan ihǝw daɣ ǝɣrǝm n Dawǝd. Ǝnta a imosan Ǝlmǝsix Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ǝnta da awas tu-za-tǝzdǝyam: \"Ad tǝnǝyam ajanɣay ittalan daɣ ǝfǝr, isrâd daɣ ǝɣlal.\"» ");
INSERT INTO ttq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wala a ihogan inafalal-du agan zǝwwǝran n angalosan ɣur wen, ǝmmâlan Mǝššina gannin: ");
INSERT INTO ttq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Tǝmmal i Mǝššina daɣ jǝnnawan, alxer daɣ ǝddǝnet y aytedan win ǝhanen agna-net.» ");
INSERT INTO ttq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ǝqqalan angalosan ijǝnnawan ɣas, namannan madanan: «Ǝndawat Betalxam, ad nǝnǝy awa danaɣ-imal Ǝmǝli da.» ");
INSERT INTO ttq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tǝzzar ǝglan ǝhâzan. Osan-in Maryama ǝd Yusǝf d ajanɣay, isrâd daɣ ǝɣlal. ");
INSERT INTO ttq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","As ǝnayan madanan barar, ǝssoɣalan awa dasan-itawannan sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aytedan kul win ǝslanen y awa ǝnnan madanan isimaklal sǝr-san awen. ");
INSERT INTO ttq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryama ǝnta, tǝttâf isalan en kul daɣ man-net, tǝnaẓẓar daɣ-san. ");
INSERT INTO ttq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tǝzzar ǝqqalan madanan ǝmmâlan adkul ǝn Mǝššina, taggin-as tǝmmalen fǝl aššaddat n arat kul was ǝslan ǝd wa ǝnayan, ǝs ketnet iga s ǝmmǝk wa daɣ as dasan-ittǝmal. ");
INSERT INTO ttq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","As ǝzǝl wa n ǝttam, itawasamankad barar, itawagg-as esǝm Ɣaysa, imos as esǝm wa da a imal angalos y anna-net dat igi-net tadist. ");
INSERT INTO ttq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","As d-ewad alwaq ǝn zazdag wa imal Ǝttawret n ǝnnǝbi Musa, iddew Yusǝf ǝd Maryama s ǝɣrǝm ǝn Yerusalam fǝl ad ǝzzǝzdǝgan iman-nasan. Ewâyan deɣ barar y ad tagin da tǝɣlift ǝn Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","s ǝmmǝk as iktâb daɣ ǝššǝriɣa n Ǝmǝli as «Barar kul wa n aɣafadday, ad iskǝt y Ǝmǝli.» ");
INSERT INTO ttq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yusǝf ǝd Maryama issiwar-tan ǝššǝriɣa n Ǝmǝli daɣ tarrayt n ǝzǝzdǝg-nasan ad akfin tǝzǝgzǝmt ǝn sanatat tǝdǝbren šin ǝsuf madeɣ sanatat šin ǝɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aɣrǝm ǝn Yerusalam ixsâr daɣ-as alǝs igân esǝm Simɣon n alɣadil n ǝmiksad ǝn Mǝššina. Igâ attama n Ǝnǝssesmǝd a du-z-asin assafsu Israyil. Simɣon en izzîbbad-du fall-as Infas wa Zǝddigan, ");
INSERT INTO ttq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","s ǝnta a das-isannafalan as wǝr tu-z-iba wǝr inay Ǝlmǝsix n Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eway-t-id Infas ǝn Mǝššina s Ahan wa Zǝwwǝran n Ǝlɣibada. Imazayyat-du ǝd marwan ǝn Ɣaysa tamazalan s alɣadat ta tan-issǝwar ǝššǝriɣa daɣ batu ǝn barar-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Idkal Simɣon barar, iga tǝmmal i Mǝššina, inna: ");
INSERT INTO ttq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ǝmǝrǝdda Ǝmǝli ad tayyaɣ akli-nak ad t-iba daɣ alxer, id awa di-tǝnneɣ inda, ");
INSERT INTO ttq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","fǝlas ǝnaya ǝs šittawen šin-da-nin Ǝmaɣlas wa dana-du-tǝssoka, ");
INSERT INTO ttq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wa du-tǝsammatagaɣ i tǝmattiwen kul, ");
INSERT INTO ttq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","imos ǝnnur as zʼikkǝsan daɣ šiyyay aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud, awǝy-du deɣ adkul ǝs tamattay-nak Kǝl-Israyil.» ");
INSERT INTO ttq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Abba-net d anna-net ǝqqânan ɣafawan-nasan y aratan win sǝr-ǝs tawanninen da. ");
INSERT INTO ttq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tǝzzar ittar-asan Simɣon a dasan-igan albaraka, amaran inna i Maryama anna ǝn Ɣaysa: «Ǝssǝn as barar a isinafran-tu Mǝššina fǝl ad d-awǝy agadal ǝd tanakra ǝn Kǝl-Israyil aggotnen, iqqǝl ǝssǝbab n ǝnǝmǝzray gǝr aytedan. ");
INSERT INTO ttq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ǝmmǝk wǝdi as zʼisǝffǝggu awa ihan iwallan n aytedan aggotnen. Kam iman-nam a kam-izzuẓǝr ǝwǝl zun tu-tǝrzâg takoba.» ");
INSERT INTO ttq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tǝll-ay deɣ tǝnnǝbit iyyat tǝknât tušaray tǝgât esǝm Xǝnnǝtu wǝlǝt Fanwal ǝn tawšet ta n Aššir, ǝdâsan ǝssa elan n azalaf daɣ tǝmmǝdrǝyt-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A aba alǝs-net wǝr tǝles azalaf, har tǝga ǝttamat tǝmǝrwen n awatay d ǝkkoz. Faw tǝha Ehan wa Zǝwwǝran n Ǝlɣibada. Tǝɣbâd Mǝššina ehad ezal, tǝtuzam, tǝtattar. ");
INSERT INTO ttq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tamazayt tenda a daq-qan du-tosa, tǝga igodan i Mǝššina. Ad tǝtaggu isalan ǝn Ɣaysa y aytedan kul win ǝganen attama n ad d-izǝzzǝbbǝt Mǝššina tǝdarfit-net fǝl Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","As ǝssǝndan marwan ǝn Ɣaysa igi n arat kul wa tan-issǝwar ǝššǝriɣa n Ǝmǝli, ǝqqalan aɣrǝm-nasan Nazaret ihan akal ǝn Galilaya. ");
INSERT INTO ttq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Idaggal barar, itilu tayttay d ǝgǝrri, izazabbat-du fall-as Mǝššina arraxmat-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Awatay kul ǝggizzayan marwan ǝn Ɣaysa s aɣrǝm ǝn Yerusalam y ǝmud was itawannu wa n Akkay, imos awen alɣadat n ǝmud wen. As iqqal Ɣaysa aw maraw elan d ǝššin ǝddewan dǝr-ǝs s ǝmud wen. ");
INSERT INTO ttq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","As ǝɣradan adan win amud, ǝqqalan aɣaywan, Ɣaysa amaran iqqim-in daɣ Yerusalam wǝr ǝssenan daɣ awen. ");
INSERT INTO ttq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A ǝɣilan iha aljamaɣat ǝn mǝššukal win dǝr ǝddewan. As ǝgan ǝšikǝl n ǝzǝl, a das-saggadan daɣ šǝqqaɣan-nasan ǝd tǝmǝzdǝyt-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mišan wǝr t-ǝgrewan, tǝzzar ǝqqalan Yerusalam, saggadan-as. ");
INSERT INTO ttq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","As ǝzǝl-nasan wa n karad gar-essan dǝr-ǝs, osan-t-id daɣ Ahan wa Zǝwwǝran n Ǝlɣibada iniɣama ǝd musanan n Ǝttǝwret, issisam-asan, isastan-tan deɣ. ");
INSERT INTO ttq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aytedan kul win ǝslanen y awa igannu, tǝsimaklal sǝr-san tayttay-net d aljawaban-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","As t-ǝnayan marwan-net ǝhagan, tǝnn-as anna-net: «Barar-in ma imos awa dana-tǝge da? Nak d abba-nak tǝššiwaš-ana taɣara-nak, nosa edag kul nǝsaggad-ak.» ");
INSERT INTO ttq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Inn-asan: «Ma fel za as di-tǝsaggadam? Masnat a wǝr tǝgem as tǝlzâm-i tǝɣimit daɣ ahan n Abba-nin?» ");
INSERT INTO ttq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mišan wǝr ǝgren awa dasan-inna den. ");
INSERT INTO ttq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iddew Ɣaysa ǝd marwan-net, zagadayan ǝqqalan aɣrǝm ǝn Nazaret, ibbirdag-asan. Anna-net tǝttâf aratan en kul daɣ man-net. ");
INSERT INTO ttq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Idaggal Ɣaysa, tǝtittǝy tǝla-net ǝgǝrri, ikannu gǝrrezat i Mǝššina d aytedan. ");
INSERT INTO ttq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awatay wa n maraw ǝd sǝmmos ǝn Qaysara Tabirǝyas da taɣmar, Fons Bilatǝs a imosan ǝmuzar n akal wa n Yahudǝyya, amaran Herod ixkâm fǝl akal wa n Galilaya, amaqqar-net Filibus ixkâm fǝl wa n Iturayya ǝd wa n Tǝrakonit, Lisanǝya ǝnta ixkâm fǝl akal wa n Abila. ");
INSERT INTO ttq_vpl VALUES ("LK3_2a","072_3_2a","LUK","3","2a","2a","Xânan ǝd Kayif ǝntanay ǝmosan ilimaman win zawwarnen. ");
INSERT INTO ttq_vpl VALUES ("LK3_2b","072_3_2b","LUK","3","2b","2b","Awatay wen da a d-izzǝbbat awal ǝn Mǝššina fǝl Yaxya ag Zakarayya daɣ ǝsuf. ");
INSERT INTO ttq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dǝffǝr awen illil Yaxya ikallan kul win ahanen attayan n agarew wa n Yordan, itaggu y aytedan tǝlxutbat, igann-asan ad tǝwǝsǝlmǝɣan daɣ aman imos awen arat issiknan tǝtubt-nasan, fǝl ad ǝgrǝwan tǝsureft ǝn bakkadan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ǝmmǝk ǝddi was tǝnda batu ta iktab Ǝnnǝbi Isayas, as inna: «Alǝs iyyan idkâl ǝmǝsli-net daɣ ǝsuf igannu: \"Sǝmmutǝgat abaraqqa y Ǝmǝli! Tǝsǝssiɣǝdam tarrayen dat-ǝs! ");
INSERT INTO ttq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Id t-illa ǝnahoɣ ketnet ad inbǝl. Idɣaɣan ǝd gefan ad ǝrǝsan, tarrayen šin ǝfraɣnen ad aɣǝdnat, ibaraqqan win wǝr nogda ad agdin ");
INSERT INTO ttq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Inǝy awedan ketnet ǝlɣillas wa d-izazzabbat Mǝššina.\"» ");
INSERT INTO ttq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Adi a fǝl igannu Yaxya i tǝmattiwen šin t-idu-tasinen y a tanat-issǝlmǝɣ daɣ aman: «Xa taššolen šin! Ma kawan-issosanan ǝdǝrrǝg y attadib ǝn Mǝššina wa d-izayan. ");
INSERT INTO ttq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Daɣ adi taggiwat imazalan olaɣnen tǝsǝttǝddim sǝr-san tǝtubt-nawan! Wǝr igda ad tǝgannim daɣ man-nawan: \"Nakkanay ǝzzurrǝyya n ǝnnǝbi Ibrahim a nǝmos\", fǝlas silakanaɣ-awan as Mǝššina ifrâg ad isǝmmǝttǝy šihun šin tǝhannayam da, ixlǝk-du daɣ-asnat ǝzzurrǝyya y Ibrahim! ");
INSERT INTO ttq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Agat ǝnnǝyat! Tazǝft harwa ǝmǝrǝdda da tǝmmotag y a du-tǝsǝddǝngǝr y eškan. Daɣ adi ašǝk kul wa wǝr nǝtirǝw aratan olaɣnen ad itǝwǝɣtǝs, itǝwǝgǝr-in daɣ tǝmsay.» ");
INSERT INTO ttq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A tu-sastanan aytedan, gannin-as: «Daɣ adi mas danaɣ-iwar a tu-nagu?» ");
INSERT INTO ttq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Inn-asan: «Awedan wa ilan ǝššin sǝlsa, akf-et iyyan i wa tu-wǝr-nǝla; wa ilan a itša, akfet daɣ-as wa tu-wǝr-nǝla.» ");
INSERT INTO ttq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Inabazan n amana ǝntanay da, tasin-du Yaxya fǝl a tan-issǝlmǝɣ daɣ aman, ǝnnan-as: «Ǝššex, mas danaɣ-iwar a tu-nagu?» ");
INSERT INTO ttq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Inn-asan: «Ad wǝr tǝzzǝrzǝmam a ogaran awa dawan-itawannan.» ");
INSERT INTO ttq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ǝssǝstanan-tu deɣ sojitan, ǝnnan-as: «Nakkanay za, mas danaɣ-iwar a tu-nagu?» Inn-asan: «Ad wǝr tǝrkǝbam daɣ awedan waliyyan azrǝf-net, wala deɣ tǝssǝwǝram-tu bahu. Agdat s alxaq-nawan.» ");
INSERT INTO ttq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aytedan kul win ǝslanen y awa igannu Yaxya, ǝgân attama; akk awedan isamadranan daɣ ǝwǝl-net kud Yaxya en da a imosan Ǝlmǝsix wala. ");
INSERT INTO ttq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awen da fǝl dasan-inna Yaxya ketnasan: «Nak, aman a daq qawan-salmaɣa, mišan izay-du alǝs s awa di-iga daɣ šigrat, wǝr eweda wala arra ǝn suɣan ǝn ɣateman-net. Ǝnta Infas Wa Zǝddigan ǝd tǝmsay a daq qawan-z-issǝlmǝɣ. ");
INSERT INTO ttq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iha ǝlmital n awedan ittâfan tesayt y ad izzǝzǝr alkama-net. Išadaw alkama daɣ tadangawt-net, šiɣal amaran ag-enat daɣ tǝmsay tǝbilaglagat faw.» ");
INSERT INTO ttq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Igla Yaxya daɣ amel n Ǝlinjil, itaggu y aytedan ǝnnǝsixatan wiyyad aggotnen. ");
INSERT INTO ttq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herod amaran wa n ǝmǝnokal n akal ǝn Galilaya ǝruɣmatan a das-iga daɣ batu ǝn Herodǝyas tǝmosat taɣur amadray ǝn Herod en da igân esǝm Filibus, ig-âs deɣ wiyyad ǝruɣmatan fǝl arak mazalan labasnen kul win hadatnen iga. ");
INSERT INTO ttq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iššota Herod fǝl arak mazalan win den kul igi ǝn Yaxya daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","As tawasalmaɣan aytedan kul daɣ aman, itawasalmaɣ daɣ-san Ɣaysa ǝnta da. Itattar alwaq wen da as ǝnnolaman jǝnnawan, ");
INSERT INTO ttq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","izzǝbbat-du fall-as Infas wa Zǝddigan iha šaššelan ǝn tǝdabert, igmad-du ǝmǝsli ijǝnnawan, inna: «Kay a imosan Barar-in ǝkneɣ tara, tǝssinda-du agna-nin.» ");
INSERT INTO ttq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ila Ɣaysa edag ǝn karadat tǝmǝrwen n awatay as issǝnta ǝššǝɣǝl-net. Ǝttâfan aytedan as ag Yusǝf wa n ag Heli. ");
INSERT INTO ttq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ǝnta ag Mâtat, Mâtat ag Lebi, Lebi ag Malki, Malki ag Yannay, Yannay ag Yusǝf, ");
INSERT INTO ttq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusǝf ag Matasiyas, Matasiyas ag Amos, Amos ag Nahum, Nahum ag Xasli, Xasli ag Naggay. ");
INSERT INTO ttq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggay ag Matti, Matti ag Matasiyas, Matasiyas ag Samɣi, Samɣi ag Yosax, Yosax ag Yoda, ");
INSERT INTO ttq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ag Yohanan, Yohanan ag Ɣaysa, Ɣaysa ag Zǝrubabil, Zǝrubabil ag Assalat, Assalat ag Nayri, ");
INSERT INTO ttq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nayri ag Malxi, Malxi ag Addi, Addi ag Kosam, Kosam ag Almadama, Almadama ag Er, ");
INSERT INTO ttq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ag Ɣaysa, Ɣaysa ag Alyazar, Alyazar ag Yorim, Yorim ag Mâtat, Mâtat ag Lebi, ");
INSERT INTO ttq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi ag Simɣon, Simɣon ag Yahuda, Yahuda ag Yusǝf, Yusǝf ag Yunam, Yunam ag Ilyakim, ");
INSERT INTO ttq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ilyakim ag Malaya, Malaya ag Mayna, Mayna ag Mâtat, Mâtat ag Natan, Natan ag Dawǝd, ");
INSERT INTO ttq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawǝd ag Yasay, Yasay ag Ɣubayd, Ɣubayd ag Boxaz, Boxaz ag Sala, Sala ag Nasun, ");
INSERT INTO ttq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasun ag Ɣaminadab, Ɣaminadab ag Admin, Admin ag Arni, Arni ag Xasrun, Xasrun ag Farǝs, Farǝs ag Yahuda, ");
INSERT INTO ttq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda ag Yaqub, Yaqub ag Isǝhaq, Isǝhaq ag Ibrahim, Ibrahim ag Terax, Terax ag Naxur, ");
INSERT INTO ttq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naxur ag Sarux, Sarux ag Raggaw, Raggaw ag Falax, Falax ag Ɣabbir, Ɣabbir ag Salax, ");
INSERT INTO ttq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salax ag Kaynam, Kaynam ag Arfakšad, Arfakšad ag Sam, Sam ag Nux, Nux ag Lamax, ");
INSERT INTO ttq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamax ag Matusala, Matusala ag Henox, Henox ag Yarit, Yarit ag Malelyal, Malelyal ag Kaynam, ");
INSERT INTO ttq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam ag Enus, Enus ag Set, Set ag Adǝm, Adǝm ǝnta Mǝššina t-id-ixlakan. ");
INSERT INTO ttq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Igmad Ɣaysa tamawen n agarew wa n Yordan idkâr-tu Infas wa Zǝddigan. Infas wa da a t-issokan teneray. ");
INSERT INTO ttq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iga daɣ-as ǝkkozat tǝmǝrwen n ǝzǝl itajarrab-tu Iblis. Adan win kul ig-en wǝr itša wala, as ǝɣradan ih-ay laz. ");
INSERT INTO ttq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Inn-as Iblis: «Kud kay Barar ǝn Mǝššina, tamǝra tǝhunt ta s ad tǝqqǝl amensay.» ");
INSERT INTO ttq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Inn-as Ɣaysa: «Wǝrgeɣ ǝnnan Ǝlkǝttaban: \"Awedan wǝr itǝddǝr ǝs mensewan ɣas.\"» ");
INSERT INTO ttq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ikka dǝr-ǝs Iblis edag iknan ǝhuki, issǝswad-tu daɣ taɣmaren kul n ǝddǝnet daɣ ellaf ǝn šat. ");
INSERT INTO ttq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Amaran inn-as: «A kay-akfa taɣmaren en kul ǝd tǝhussay-nasnat fǝlas tiwakfanat-i hakkaq-qanat deɣ i was tanat-ǝreɣ. ");
INSERT INTO ttq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Daɣ adi as di-tǝssǝjada ad tǝgrǝwaɣ awen kul.» ");
INSERT INTO ttq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Inn-as Ɣaysa: «Wǝrgeɣ ǝnnan Ǝlkǝttaban: \"Ǝmǝli-nak Mǝššina as za tǝssǝjǝda, ǝnta ɣas a za tǝɣbǝda.\"» ");
INSERT INTO ttq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tǝzzar ikka dǝr-ǝs Iblis Yerusalam, issǝbdad-tu fǝl afalla n Ahan wa Zǝwwǝran n Ǝlɣibada, inn-as: «Kud kay Barar ǝn Mǝššina tǝtǝrǝgge, ");
INSERT INTO ttq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","fǝlas ǝnnan Ǝlkǝttaban: \"Ad amǝr angalosan-net a kay agǝzan daɣ ǝššur,\" ");
INSERT INTO ttq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","iktâb deɣ as: \"A kay-ǝkbǝlan daɣ fassan-nasan fǝl a dak-wǝr-tǝnkǝf tǝhunt.\"» ");
INSERT INTO ttq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Inn-as Ɣaysa: «Wǝrgeɣ za Ǝlkǝttaban di ǝnnân: \"Ad wǝr tǝtajjarraba Ǝmǝli-nak Mǝššina.\"» ");
INSERT INTO ttq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","As t-iɣrad Iblis ǝjǝrrǝb, igla oyy-ay har sǝr-ǝs ilǝs agaraw ǝn tarrayt. ");
INSERT INTO ttq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dǝffǝr awen, iqqal Ɣaysa akal ǝn Galilaya, tǝh-ay tarna n Infas wa Zǝddigan. Tǝffǝzzat sallat-net daɣ akal en ketnet. ");
INSERT INTO ttq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Isasaɣru aytedan daɣ nan win ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ketnasan ǝssiɣmaran-tu. ");
INSERT INTO ttq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Osa deɣ Ɣaysa Nazaret, aɣrǝm wa daɣ idwal. As ǝzǝl wa n tǝsanfawt iggaz ehan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud imos awen arat itaggu faw. Ibdad y ad aɣru awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Itawakf-ay-in ǝlkǝttab wa n ǝnnǝbi Isayas. Ikkas y ǝlkǝttab aḍḍa wa iga, olam fǝl adag a daɣ iktab as: ");
INSERT INTO ttq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Iwâr-i Infas n Ǝmǝli, fǝlas isinafran-i y ad ǝmǝlaɣ isalan n Ǝlinjil i tǝlǝqqawen. Izimazal-i-du y ad agaɣ isalan i win tawattafnen, ǝgrǝwan iman-nasan, ǝzzuzǝyaɣ imǝddǝrɣal, aytedan win tawadgaznen deɣ agaq-qan daɣ tara ǝn man-nasan, ");
INSERT INTO ttq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ǝmǝlaɣ awatay taha arraxmat n Ǝmǝli.» ");
INSERT INTO ttq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","As iɣrad Ɣaysa teɣaray ihar ǝlkǝttab, issoɣal-tu y amaššaɣal n ahan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, iqqim. Ǝgaran daɣ-as aytedan kul win ǝllanen den šittawen. ");
INSERT INTO ttq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Amaran inn-asan: «Azalada awal ǝn Mǝššina was tǝslam da, inda.» ");
INSERT INTO ttq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ketnasan ǝmmâlan-tu. Simaklalnat sǝr-san batuten olaɣnen šin du-gammadnen imi-net, ad gannin: «Ak awa wǝrgeɣ ag Yusǝf?» ");
INSERT INTO ttq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Inn-asan Ɣaysa: «Illikan as a di-du-tassaktim iggi wa innan: \"Anasmagal, zuzǝy iman-nak,\" tǝzzar tannim-i: \"Agu daɣ akal-nak da da awas nǝsla as tǝgêq-qu daɣ ǝɣrǝm ǝn Kafarnahum.\"» ");
INSERT INTO ttq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Inn-asan deɣ: «Ǝggǝyyaɣ silakanaɣ-awan as wǝr t-illa ǝnnǝbi itiwaqbalan daɣ aɣrǝm wa daɣ idwal. ");
INSERT INTO ttq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Amaran a dawan-ǝmǝla tidǝt: Daɣ elan n ǝnnǝbi Ilyas akal n Israyil ǝhânat-tu tǝdoden aggotnen ǝs wǝr ǝdderan meddan-nasnat. Elan en da a daɣ iga akonak karad elan d aganna wǝr iwet, iga laz labasan daɣ akal ketnet. ");
INSERT INTO ttq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dǝr iga awen da ya, wǝr izammazal Mǝššina ǝnnǝbi Ilyas ǝs waliyyat daɣ tǝdoden en. Kalar izammazal-tu s iyyat tǝxsârat daɣ tǝɣrǝmt ta n Sarǝfta tǝhât akal ǝn Sidon. ");
INSERT INTO ttq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ǝhân deɣ kǝtrutan aggotnen akal n Israyil daɣ elan n ǝnnǝbi Elisayas, mišan wǝr tan-iha i itawazozayan ar Naɣman wa n akal ǝn Surǝya.» ");
INSERT INTO ttq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","As ǝslan aytedan win ǝhanen ehan n ǝlɣibada y awen, iggaz-tan alham labasan. ");
INSERT INTO ttq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ǝbdadan, ǝgan ifassan da Ɣaysa, ǝkkasan-tu daɣ ǝɣrǝm, ewayan-tu s afalla n ǝdɣaɣ wa fǝl ikras ǝɣrǝm y ad t-ǝgǝran daɣ ǝɣǝɣi, iba-tu. ");
INSERT INTO ttq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mišan illam Ɣaysa gar-essan igla. ");
INSERT INTO ttq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dǝffǝr awen iras Ɣaysa ǝs tǝɣrǝmt tǝgât Kafarnahum tǝhât ǝnta da akal wa n Galilaya, ad isasaɣru aytedan daɣ ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud daɣ jilan win tǝsanfawt. ");
INSERT INTO ttq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Isimaklal sǝr-san ǝmmǝk was isasaɣru, fǝlas ǝsǝssǝɣri-net in awedan ilân tanaya. ");
INSERT INTO ttq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ehan n ǝlɣibada wen, ih-ay alǝs iha aggǝsuf. Idkal alǝs wen ǝmǝsli-net, ad igannu: ");
INSERT INTO ttq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Xa! Ɣaysa wa n Nazaret, ma daɣ-na tareɣ? Ǝngǝm assa a du-tǝgeɣ y a dana-tǝhlǝka? Ǝssanaɣ awa tǝmosa: Ǝmizdag wa d-izammazal Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iharaššat-tu Ɣaysa, inn-as: «Fastu, tǝgmǝdaɣ alǝs di!» Tǝzzar iggǝdla aggǝsuf alǝs en gǝr aytedan, amaran igmad-tu wǝr das-ixšed arat. ");
INSERT INTO ttq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ǝhagan aytedan ketnasan, ad tinǝmǝnnin gar-essan: «Ma imos almaɣna n awal n alǝs wa? Kǝlǝsuf da ittâf daɣ-san tanat, itamar-tan ǝs tanaya, gammadan aytedan.» ");
INSERT INTO ttq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tǝwazawaz sallat ǝn Ɣaysa daɣ id t-illa adag daɣ akal en kul. ");
INSERT INTO ttq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","As igmad Ɣaysa ehan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ikka ehan ǝn Simɣon. As itaggu awen tǝdaggalt ǝn Simɣon tǝfrâyat, tǝnnid wǝllen, tǝzzar ǝgmayan daɣ-as aytedan a tat-izzuzǝy. ");
INSERT INTO ttq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inaz-in fall-as Ɣaysa, isannarɣam i tanaday, tǝzzar tǝwat fall-as. Tǝnkar daɣ tǝmazayt ten da a tan-tǝsimǝgurit. ");
INSERT INTO ttq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","As tuda tǝfuk, ewayan-du sǝr-ǝs aytedan imiranan-nasan ǝgânen šiwǝrnawen ǝmosnen ǝzzǝnǝfan. Akk iyyan issǝwar-tu ifassan-net, izzozay-tu. ");
INSERT INTO ttq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gammadan deɣ kǝlǝsuf aytedan aggotnen, saɣaren kǝlǝsuf en, gannin: «Kay Barar ǝn Mǝššina», mišan isannarɣam-asan, igdal-asan awal, id masnat a ǝgan as ǝnta a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","As affaw, igmad Ɣaysa aɣrǝm, ikka edag issufan. A das-tǝsaggad tamattay har t-in-tosa. Ad gammayan tǝmǝwit tas das-z-ǝgdǝlan a tan-ifǝl. ");
INSERT INTO ttq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mišan inn-asan: «Iwâr-i ad ǝmǝla Ǝlinjil, imosan isalan ǝn Taɣmar ta n Mǝššina, i ɣǝrman win hadatnen ǝntanay da, fǝlas adi da a fǝl d-ǝmmozala.» ");
INSERT INTO ttq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tǝzzar igla Ɣaysa, itaggu tǝlxutbat daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud win n akal ǝn Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ǝzǝl iyyan ibdâd Ɣaysa daɣ tǝšǝšwit n agaraw wa n Ganazaret, tǝtanabdaɣ fall-as tamattay fǝl ad aslin y awal ǝn Mǝššina wa immal. ");
INSERT INTO ttq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inay Ɣaysa ǝššin ǝɣlalan n aman daɣ tǝšǝšwit n agaraw. Iɣlalan win ǝgmâdan-tan mǝssawsan, takkasan tǝjjǝrgǝnt daɣ sangaytan-nasan win as tabazan kifitan. ");
INSERT INTO ttq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tǝzzar iggaz daɣ-san wa n Simɣon, igmay daɣ-as a din-izzǝnkǝz fǝl tǝšǝšwit, amaran iqqim ad isasaɣru tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","As iraz daɣ ǝsǝssǝɣri inna i Simɣon: «Akku kay ǝd midawan-nak dad zagrotan aman, tǝgǝram sangaytan-nawan, tabǝzam kifitan.» ");
INSERT INTO ttq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Inn-as Simɣon: «Ǝššex, ahad iɣrâdan a nǝga nǝšɣâl eges wǝr nǝbez wala, mišan ya zama adi a tǝnneɣ, adi za ad ǝgǝra sangaytan daɣ aman.» ");
INSERT INTO ttq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ǝgan awa dasan-inna Ɣaysa, tǝzzar ǝbazan kifitan s awa ǝgan daɣ igǝt har ǝbukan sangaytan-nasan y azarru. ");
INSERT INTO ttq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ad tallafan i midawan-nasan win ǝhanen aɣlal n aman wa hadan y a d-aglin a dasan-ilalan. Osan-du, ǝdnayan ǝššin ǝɣlalan win den har ǝbukan y ǝdǝkǝyyi. ");
INSERT INTO ttq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","As inay Simɣon Butros awen, issǝjad i Ɣaysa, inn-as: «Ya Ǝmǝli, nǝmǝggǝg dǝr-i fǝlas anasbakkad a ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Innâ awen fǝlas ǝnta ǝd midawan-net ketnasan as ǝhagan ɣur anay-nasan igǝt ǝn kifitan win ǝbazan. ");
INSERT INTO ttq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Eheg wa iga Simɣon den, ǝnta a iga Yaqub ǝd Yaxya win maddanǝs ǝn Zabaday dǝr idrâw ǝššǝɣǝl. Tǝzzar inna Ɣaysa i Simɣon: «Ad wǝr tǝrmǝɣa, a obazan ɣur ǝmǝrǝdda, tǝqqalam meddan a sər-i du-za-tawaynen aytedan y a tan-assafsa daɣ bakkadan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amaran ǝssoɣalan iɣlalan-nasan tǝgadamayt n agaraw, oyyan arat kul ǝlkaman-as. ");
INSERT INTO ttq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iha Ɣaysa aɣrǝm iyyan, as t-inay alǝs as tǝlsa tǝwǝrna ǝn kǝtru elam-net ketnet. Ikk-ay-du issǝjad dat-ǝs, onsay-tu, inn-as: «Ǝmǝli, as tareɣ adi, tǝfrâgaɣ a di-tǝzzuzǝyaɣ, izdaga.» ");
INSERT INTO ttq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Izzal-in Ɣaysa ǝfus-net, idas-tu, inn-as: «Areɣ adi, ǝzzǝy tizdaga!» Amazay wen daɣ ad izzay daɣ kǝtru. ");
INSERT INTO ttq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tǝzzar issǝnkad-tu Ɣaysa, inn-as: «Ǝnǝy za, ad wǝr tǝmǝla y awedan waliyyan awa igan da, amaran aglu tassaknaɣ iman-nak y ǝlimam, taga takutay ǝn tazdak ta kay-issǝwar ǝššǝriɣa n ǝnnǝbi Musa, ad iqqǝl adi y aytedan tǝgǝyya ǝn tǝmǝzzǝyt-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dǝr iga awen da ya, tǝgla sallat ǝn Ɣaysa tǝtittǝy, tǝttiddaw fall-as tamattay tagget fǝl a das-tǝssǝsǝm, izzuzǝy deɣ šiwǝrnawen-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mišan ǝnta, itakku idaggan ǝssufnen y a daɣ-san iɣbǝd Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ǝzǝl iyyan isasaɣru Ɣaysa, ǝqqiman Farisaytan ǝd musanan n Ǝttawret a d-ǝgmâdnen šiɣarmaten kul šin n akal ǝn Galilaya ǝd wa n Yahudǝyya ǝd Yerusalam. As itaggu awen Ɣaysa igrâw ɣur Ǝmǝli tarna n ǝzuzǝy n aytedan. ");
INSERT INTO ttq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Har d-osan meddan wiyyad misawaynen alǝs n anabdon daɣ tǝssut. Ad gammayan a dǝr-ǝs ǝggǝzan, assansin-tu dat Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","As dasan-aba tǝmǝwit as dǝr-ǝs ǝggazan fǝl igǝt n aytedan, ǝwaran afalla ǝn taɣazamt, olaman ǝsǝfǝl-net, ǝssǝrasan-tu daɣ-as iha tǝssut-net har tǝssǝnsan daɣ ammas ǝn tamattay, dat Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","As inay Ɣaysa ǝzǝgzan-nasan, inna y anabdon wen: «Ibakkadan-nak tiwasarafan-ak.» ");
INSERT INTO ttq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ǝslan musanan n Ǝttawret ǝd Farisaytan y awen ɣas, ad gannin daɣ man-nasan: «Ma imos alǝs wa itaggin amadraw da? Ma ifragan ǝsurǝf ǝn bakkadan ar Mǝššina ɣas?» ");
INSERT INTO ttq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Issan Ɣaysa awa samadranan, inn-asan: «Mafǝl tətihənzəmmem adi daɣ wallan-nawan? ");
INSERT INTO ttq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma ogaran tǝrɣǝsay gǝr i innan: \"Tiwasarafan-ak bakkadan-nak\" meɣ ak i innan: \"Ǝbdǝd jǝwǝnkǝt?\" ");
INSERT INTO ttq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amaran areɣ a tǝssǝnam as nak Ag Aggadǝm ǝleɣ daɣ ǝddǝnet tanaya a di-tǝšišawadat ad ǝssurǝfa y awedan ibakkadan-net.» Tǝzzar inna Ɣaysa y anabdon: «Ǝbdǝd, tǝdkǝla tǝssut-nak, takkaɣ aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ibdad alǝs wen tamazayt ten da dat aytedan kul, idkal tǝssut-net, iqqal ehan-net, immâl Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aytedan kul isimaklal sǝr-san awen wǝllen. Ǝmmâlan Mǝššina, tǝh-en tasa gannin: «Azalada nǝnây aratan as wǝr kala ǝtawanayan!» ");
INSERT INTO ttq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Igmad Ɣaysa edag en, ogga alǝs iyyan igân esǝm Lebi iqqim daɣ adag wa n ǝzǝrzǝm n ǝzrǝf ǝn takǝs, inn-as: «Ǝlkǝm-i.» ");
INSERT INTO ttq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ibdad Lebi, oyya awa iha kul, ilkam i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dǝffǝr awen iga Lebi i Ɣaysa imǝgura zawwarnen daɣ ahan-net. Ǝdrawan d aytedan aggotnen ǝn nǝzzǝrzam ǝn takǝsen d aytedan wiyyad. ");
INSERT INTO ttq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ǝnayan Farisaytan ǝd musanan-nasan win Ǝttawret awen ɣas gatantanan, ad gannin i nǝttulab ǝn Ɣaysa: «Mafel tǝdrâwam ǝd nǝzzǝrzam ǝn takǝsen ǝd nasbakkadan?» ");
INSERT INTO ttq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Inn-asan Ɣaysa: «Aytedan wǝr nǝfray, wǝr ǝddǝraran s anasmagal, imiranan a sǝr-ǝs ǝddǝrarnen. ");
INSERT INTO ttq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nak wǝr d-oseɣ fǝl ǝddǝlil n aytedan win ɣur iga as oɣadân, kalar ǝmazal ad-ǝgeɣ fǝl a d-aɣraɣ inasbakkadan ǝs tǝtubt.» ");
INSERT INTO ttq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dǝffǝr awen ǝnnan-as Farisaytan ǝd musanan n Ǝttawret: «Inǝttulab ǝn Yaxya ǝd win Farisaytan tuzaman faw, tattaran, win-nak amaran tattin sassin.» ");
INSERT INTO ttq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Inn-asan Ɣaysa: «Awak tǝfrâgam ad tǝzzuzǝmam ilagatan a ɣur illa ǝmazlay? ");
INSERT INTO ttq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mišan ǝlkâman adan a ɣur-san zʼammadkal ǝmazlay. Adan win di, ad uzaman.» ");
INSERT INTO ttq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ig-asan Ɣaysa tangalt iyyat, inn-asan: «Wǝr t-illa i du-z-ikkǝsan šikǝst daɣ tabdoq taynayat y a tat-iwǝt daɣ iyyat waššarat, fǝlas as iga adi, ad iɣšǝd tabdoq ta taynayat, šikǝst deɣ ta daɣ-as d-ikkas wǝr tǝnnǝha ǝd tabdoq ta waššarat. ");
INSERT INTO ttq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wǝr t-illa deɣ i zʼagin esmad n alɣanab aynayan daɣ gǝdad. I igan adi ad abbaqqen gǝdad win, tǝzzar affatu daɣ esmad ǝd gǝdad. ");
INSERT INTO ttq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kalar esmad n alɣanab aynayan, ibǝyaɣ aynaynen a daɣ itawaggu. ");
INSERT INTO ttq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Awedan išwân esmad n alɣanab waššaran, wǝr zʼiru dǝffǝr adi tessay ǝn wa aynayan, fǝlas ad annu: \"Wa waššaran a izodan.\"» ");
INSERT INTO ttq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ǝzǝl iyyan imosan ǝzǝl wa n tǝsanfawt ǝn Kǝl-Ǝlyǝhud, ijiwankat Ɣaysa daɣ tǝwǝgas n alkama, rassaban-du nǝttulab-net šiɣaɣanen, tifǝffǝren-tanat gǝr fassan-nasan, tattin-tanat. ");
INSERT INTO ttq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tǝzzar ǝnnan-asan arat daɣ Farisaytan: «Mafǝl tǝtaggim arat xarâman daɣ ǝzǝl wa n tǝsanfawt?» ");
INSERT INTO ttq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ijjǝwwab-asan Ɣaysa, inn-asan: «Ak teɣaray a wǝr tǝgem awa iga ǝnnǝbi Dawǝd ǝzǝl wa t-iggaz gǝlǝk ǝnta ǝd midawan-net? ");
INSERT INTO ttq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Awak wǝrgeɣ iguz a iga ehan ǝn Mǝššina, idkal šigǝlwen šin ǝmosnen takutay tǝskâtat i Mǝššina ǝs limaman ɣas as təxalal tattay-nasnat, itša daɣ-asnat, ikfa daɣ-asnat deɣ aytedan-net?» ");
INSERT INTO ttq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Inn-asan Ɣaysa deɣ: «Nak Ag Aggadǝm a ixkaman fǝl ǝzǝl wa n tǝsanfawt.» ");
INSERT INTO ttq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ǝzǝl iyyan ǝn tǝsanfawt ǝn Kǝl-Ǝlyǝhud, iggaz Ɣaysa ehan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud ad isasaɣru. Ehan-en ih-ay alǝs as immût ǝfus-net wa n ǝɣil. ");
INSERT INTO ttq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ǝgaran daɣ-as musanan n Ǝttawret ǝd Farisaytan šittawen fǝl ad ǝssǝnan kud ad izzuzǝy awedan daɣ ǝzǝl wa n tǝsanfawt wala, fǝl tara n ad ǝgrǝwan ǝddǝlil ǝs tǝxtǝst-net. ");
INSERT INTO ttq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ɣaysa ǝnta issân awa ihan iman-nasan. Inna y alǝs was immût ǝfus-net: «Ǝnkǝr, ǝbdǝd daɣ ammas n ǝljǝmaɣat.» Inkar alǝs, ibdad. ");
INSERT INTO ttq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tǝzzar inn-asan Ɣaysa: «Ǝssistanaq-qawan, awak xalal daɣ ǝzǝl wa n tǝsanfawt igi n arat olâɣan meɣ igi n a labasan, ereg n awedan daɣ tǝmattant meɣ awak šiyyit-net iba-tu?» ");
INSERT INTO ttq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Issǝlal-tan Ɣaysa asawad-net ketnasan, amaran inna y alǝs was immût ǝfus-net: «Ǝzzǝl ǝfus-nak» Iga awa das-inna, izzay ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Arat wen iga daɣ-san alham labasan, ad tinǝmǝšiwwiran gar-essan fǝl awa zʼagin i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adan en da a daɣ ikka Ɣaysa adɣaɣ iyyan y a fall-as agu šiwatriwen. Iga fall-as ahad iɣrâdan itattar. ");
INSERT INTO ttq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","As affaw iɣra-du inǝttulab-net, isannafran daɣ-san maraw d ǝššin, ig-asan esǝm inǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ismawan-nasan da: Simɣon was iga esǝm Butros d amadray-net Andrawǝs; Yaqub, Yaxya, Filibus, Bartulamawǝs, ");
INSERT INTO ttq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Tuma, Yaqub wa n ag Alfay, Simɣon was itawannu wa Isaggatakken, ");
INSERT INTO ttq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuz wa n ag Yaqub ǝd Yahuza Isxarǝyuti wa zʼakkaddalan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dǝffǝr awen izzǝbbat dǝr-san Ɣaysa adɣaɣ, ibdad daɣ ataɣas iyyan a daɣ tǝbdâd tamattay tagget ǝn nalkiman-net ǝd tamattay tagget a du-tǝfâlat akal ǝn Yahudǝyya ǝd Yerusalam ǝd ɣǝrman win Tir ǝd Sidon ǝhanen tagadamayt n agaraw wa zǝwwǝran. ");
INSERT INTO ttq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aytedan en osân-du fǝl ad ǝssǝsǝman y awa isasaɣru Ɣaysa, tǝwǝzuzǝyan deɣ daɣ tǝwǝrnawen-nasan. Izzozay daɣ-san deɣ win ǝhan kǝlǝsuf. ");
INSERT INTO ttq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tamattay en ketnet tǝgammay d ades ǝn Ɣaysa fǝlas tarna t-id-tǝgammadat tǝzuzǝy-tan ketnasan. ");
INSERT INTO ttq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iswad Ɣaysa daɣ nǝttulab-net, inna: «Tǝbbilalam kawanay win sallaqqawnen iman-nawan dat Mǝššina fǝlas Taɣmar ta n Mǝššina ši-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tǝbbilalam kawanay win iha laz ǝmǝrǝdda fǝlas ad tayyawanam. Tǝbbilalam kawanay win hallinen ǝmǝrǝdda fǝlas ad tadzim. ");
INSERT INTO ttq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tǝbbilalam kawanay win ǝkyadan aytedan, ǝkkâsan-kawan daɣ ammas-nasan, rabbadan-kawan, ɣaššadan ismawan-nawan fǝlas di-tǝlkǝmam nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dawatat, tǝfǝliwǝsam ǝzǝl wǝdi, fǝlas tǝlâm arozan aggotnen daɣ jǝnnawan. Arat wa dawan-ǝgan ǝddi ǝnta iman-net a ǝgan marawan-nasan y ǝnnǝbitan. ");
INSERT INTO ttq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mišan kawanay imǝggǝrgas iket alɣazab iqqâl-awan, fǝlas awa ǝran man-nawan iha ifassan-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iket alɣazab iqqâl-awan kawanay win ǝyyǝwannen ǝmǝrǝdda, fǝlas ad tullazam. Iket alɣazab iqqâl-awan kawanay win dazzinen ǝmǝrǝdda, fǝlas a daɣ-wan tagu tǝfǝyyawt, talim. ");
INSERT INTO ttq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iket alɣazab iqqâl-awan kawanay win ǝmmalan aytedan; a dida a ǝgan marawan-nasan y ǝnnǝbitan win bahu.» ");
INSERT INTO ttq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kawanay win di-ǝssǝsamnen amaran, ǝnneɣ-awan: \"Iriwat izǝnga-nawan, ad tǝtamazalam ǝlluɣ i win kawan-ǝkyadnen. ");
INSERT INTO ttq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tattarat a igan arraxmat i win kawan-sawarnen allaɣanat, tansǝyam Mǝššina a igan alxer i win dawan-tagginen taršǝxšad. ");
INSERT INTO ttq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","As dak-iqqas awedan, takfaq-qu amdǝd-nak wa hadan. As daɣ-ak irkab awedan ǝbǝrnuz-nak, alɣaššaba-nak da ayy-as-tu. ");
INSERT INTO ttq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","I kay-onsayan takfaq-qu. Ad wǝr tǝgmǝya daɣ awedan a kay-d-issuɣǝl awa daɣ-ak irkab.\"» ");
INSERT INTO ttq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«Arat was tǝram a dawan-t-agin aytedan, agat-asan-tu kawanay da. ");
INSERT INTO ttq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kud wǝr tarem ar aytedan win kawan-ǝranen, awak ma imos aroz wa za tǝgrǝwam? Wala ark aytedan da ǝrân aytedan win tan-ǝranen. ");
INSERT INTO ttq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kud wǝr tǝtǝggim a olaɣan ar i win dawan-tu-tagginen, awak ma imos aroz wa za tǝgrǝwam? Wala arak aytedan taggin adi. ");
INSERT INTO ttq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kud deɣ wǝr tǝsǝmǝrwisam ar aytedan win as tordam as a dawan-ǝrzǝman, awak ma imos aroz wa za tǝgrǝwam? Ark aytedan da tinǝmǝkfin imarwasan gar-essan fǝlas ǝssânan as a tan-d-iqqǝl awa sammarwasan ketnet.» ");
INSERT INTO ttq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Kalar iriwat izǝnga-nawan, ad tǝtaggim y aytedan awa olaɣan, tǝtizǝbǝnem i win daɣ-wan ǝgmaynen ǝzǝbǝna. Tagim adi ketnet da wǝr tǝgem attama n a dawan-itǝwǝggu. Ǝddi ad igat aroz-nawan, tǝqqǝlam bararan ǝn Mǝššina di n Amadkol fǝlas ǝnta itaggu ǝlluɣ y aytedan win wǝr iha agoda ǝd win maksanan. ");
INSERT INTO ttq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tǝggǝzet-kawan tǝhanint ta tǝhat Abba-nawan.» ");
INSERT INTO ttq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ad wǝr tannim ark arat s awedan fǝl a sǝr-wan wǝr itǝwǝnnu. Ad wǝr tǝssǝwǝram awedan lahan fǝl a kawan-wǝr-itǝwǝsǝwǝr kawanay da. Sirufat, ad tǝgrǝwam tǝsureft. ");
INSERT INTO ttq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hakkat, ad tǝtǝwakfim. Tǝsǝkǝt tolâɣat, tǝdkârat, tǝssiksakat har tǝfǝtǝnɣǝl a dawan-z-itǝwǝggin daɣ sǝbbǝtǝran-nawan. Tǝsǝkǝt tas tǝkkatam y aytedan ǝnta as dawan-z-ikǝt Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ig-asan deɣ Ɣaysa tangalt, inn-asan: «Awak ǝmǝdderɣǝl ifrâg alaway n iyyan ǝmǝdderɣǝl? As iga adi wǝrgeɣ ketnasan as zʼuden daɣ anu? ");
INSERT INTO ttq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Attalami wǝr oger ǝššex-net, mišan attalami kul wa issǝxtaman, ad agdu d ǝššex-net. ");
INSERT INTO ttq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mafǝl tǝhannaya tezawt ta tǝhat šat n amadray-nak, kay amaran wǝr din-tǝgreɣ šilǝlt ta tǝhat šat ta-nak? ");
INSERT INTO ttq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Manǝmmǝk as tǝganna y amadray-nak: \"Ayy-i a dak-ǝkkǝsaɣ tezawt ta tǝhat šat-nak?\" As iga awen, kay iman-nak wǝr tǝhǝnnǝya šilǝlt ta tǝhat šat ta-nak. Ǝmunafiq, ǝkkǝs tǝzzar šilǝlt ta tǝhat šat-nak, ǝddi ad za tannaflayaɣ daɣ tazawt ta tǝhat šat n amadray-nak, tǝkkǝsaɣ-as-tat!» ");
INSERT INTO ttq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Wǝr t-illa ašǝk isxân itârawan âratăn ǝbrarnen, wala iyyan wǝr nǝsxa itârawan âratăn olaɣnen. ");
INSERT INTO ttq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ǝkkulluk n ašǝk âratăn-net as itawazday. Wǝr tǝnimidan aratan ǝn fig daɣ tazzayt, wala deɣ itanamad alɣanab daɣ tamat. ");
INSERT INTO ttq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Awedan wa olaɣan, ǝlluɣ wa ihan ǝwǝl-net a daɣ d-itakkas awa olaɣan, mišan anallabus ǝnta, talbast ta tǝhat ǝwǝl-net a daɣ d-itakkas awa labasan. Awa idkaran ǝwǝl n awedan a d-igammadan imi-net.» ");
INSERT INTO ttq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ma fel as di-tǝgannim: \"Ǝmǝli, Ǝmǝli!\" Mišan wǝr tǝtǝggim awa dawan-ganna?» ");
INSERT INTO ttq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","«Awedan kul wa di-d-itasin isasam y awal-in, itamazal s awa ǝnneɣ, a dawan-ǝmǝla awedan wa s tu-z-ammattala. ");
INSERT INTO ttq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Immittalaq-qu s awedan ikarrasan ehan. Iɣaz wǝllen har ewad tǝsǝlit, ikras-du fall-as ehan-net. Dǝffǝr awen osa-du ǝngǝy issohen, irzak-ku mišan wǝr t-isammatakway fǝlas tǝsǝlit a fǝl d-ikras.» ");
INSERT INTO ttq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","«Amaran awedan wa isasaman y awal-in mišan wǝr sǝr-ǝs itǝmizil, iha ǝlmital n awedan ikrasan ehan-net da wǝr t-iɣez. Osa-du ǝngǝy, istab-as. Ibarajjat, iɣrad ahluk.» ");
INSERT INTO ttq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","As iɣrad Ɣaysa emel ǝn salan win den kul i tamattay en, iggaz taɣrǝmt ǝn Kafarnahum. ");
INSERT INTO ttq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Taɣrǝmt ten ih-et kabtan iyyan ǝn sojitan n Ǝrrum ilân akli-net ikna tara irinan, ibuk y iba. ");
INSERT INTO ttq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","As isla kabtan en isalan ǝn Ɣaysa, izammazal sǝr-ǝs arat daɣ muzaran ǝn Kǝl-Ǝlyǝhud fǝl a t-ansǝyan a d-asu izzuzǝy akli-net. ");
INSERT INTO ttq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Osan-in Ɣaysa, onsayan-tu, ǝnnan-as: «Alǝs a, ihôr a das-tagaɣ tǝnǝfust ta, ");
INSERT INTO ttq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","fǝlas irâ tamattay-nana, ǝnta fadda a danaɣ-issǝkrasan ehan-nana wa n ǝlɣibada.» ");
INSERT INTO ttq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tǝzzar iddew dǝr-san Ɣaysa. As din-ihoz Ɣaysa ehan, izammazal-du sǝr-ǝs kabtan en imidawan-net y a das-annin: «Ǝmǝli, ad wǝr tǝsǝlliyǝɣaɣ iman-nak, nak wǝr ǝwedaɣ ad tǝggǝzaɣ ehan-in. ");
INSERT INTO ttq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Adi da fǝl kay-in-wǝr-oseɣ nak iman-in. Annu arat ɣas ad izzǝy amaššaɣal-in. ");
INSERT INTO ttq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ǝssâna daɣ adi fǝlas awedan a ǝmosaɣ a daɣ ǝttafan wiyyad tanat, ǝttâfaq-qat nak iman-in daɣ sojitan win daw-i ǝllanen. As ǝnneɣ y iyyan: \"Aglu\", ad aglu, as ǝnneɣ y iyyan: \"Iyyaw\", a di-d-asu. As ǝnneɣ y ǝkli-nin: \"agu awa\", ad t-agu.» ");
INSERT INTO ttq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","As isla Ɣaysa y awen, isammaklal sǝr-ǝs, imalallay-in aytedan win das-ǝlkamnen, inna: «Ǝnneɣ-awan, wala Kǝl-Israyil wǝr daɣ-san ǝnayaɣ awedan igân ǝzǝgzan ewâdan wa iga alǝs a.» ");
INSERT INTO ttq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","As din-ǝqqalan meddan win ǝmmozalnen ehan, osan-in akli wa irinan izzây. ");
INSERT INTO ttq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dǝffǝr awen ikka Ɣaysa aɣrǝm iyyan igân esǝm Nayn, ǝddewan dǝr-ǝs nǝttulab-net ǝd tamattay tagget. ");
INSERT INTO ttq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","As din-ihoz imi n ǝɣrǝm immǝnay d aytedan aggotnen ewaynen ǝnǝmmettǝn y a t-in-ǝnbǝlan. Alǝs wa n ǝnǝmmettǝn en, wǝr tǝla anna-net ar ǝnta, abba-net deɣ wǝr idder. ");
INSERT INTO ttq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","As tat-inay Ǝmǝli tǝsahhanatat-tu, inn-as: «Ayyu tala.» ");
INSERT INTO ttq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ikka-du ǝnǝmmettǝn, idas tǝssut ta daɣ immeway, ǝbdadan aytedan win t-ewaynen, tǝzzar inna: «Ǝmawad ǝnneɣ-ak: Ǝnkǝr!» ");
INSERT INTO ttq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iqqim-du alǝs wa aba, iššewal, issoɣal-tu Ɣaysa y anna-net. ");
INSERT INTO ttq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ǝrmaɣan aytedan kul, ad ǝmmalan Mǝššina gannin: «Ǝnnǝbi zǝwwǝran a d-inafalalan daɣ-na, Mǝššina osa-du tamattay-net fǝl a daɣ-as issǝn.» ");
INSERT INTO ttq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tǝzzar tǝffǝzzat sallat ǝn Ɣaysa daɣ akal ǝn Yahudǝyya ketnet, ǝd kallan win tu-ɣalayɣalaynen. ");
INSERT INTO ttq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Igraw Yaxya isalan win den kul ɣur attalamitan-net. Iɣra-du ǝššin daɣ-san, ");
INSERT INTO ttq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","izammazal-tan s Ǝmǝli Ɣaysa y a das-annin: «Awak kay da was nǝqqǝl y a d-asu, meɣ ak ad nǝssǝgǝd y iyyan?» ");
INSERT INTO ttq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","As din-osan Ɣaysa, ǝnnan-as: «Yaxya wa isalmaɣan daɣ aman a dana-d-izammazalan sǝr-ǝk, inn-ak: \"Awak kay da was nǝqqǝl y a d-asu, meɣ ak ad nǝssǝgǝd y iyyan?\"» ");
INSERT INTO ttq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Assaɣat ten da iman-net, izozay daɣ-as Ɣaysa aytedan aggotnen daɣ tǝwǝrnawen ǝd tǝlawayyen ǝd kǝlǝsuf, issǝswad deɣ imǝddǝrɣal aggotnen. ");
INSERT INTO ttq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ijjǝwwab Ɣaysa i meddan win sǝr-ǝs d-ǝmmozalnen, inn-asan: «Ǝqqǝlat Yaxya tǝssuɣǝlam-as awa tǝnayam d awas tǝslam, tannim-as: Imǝddǝrɣal ǝhannayan, inǝbdan jawanken, aytedan win igraw kǝtru ǝzzayan zaddogan, imzagan ǝgrawan tesalay, inǝmmǝttan nakkaran-du daɣ tǝmattant, šilǝqqawen deɣ sallanat y Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ibbilal awedan wa wǝr igmed ǝzǝgzan-net fǝlas wǝr iga aššak daɣ awa ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","As ǝglan meddan win d-izammazal Yaxya, issǝnta Ɣaysa amagrad i tamattay daɣ batu ǝn Yaxya, inna: «Ma imos arat was tǝkkam ǝsuf y a tu-tǝnǝyam? Awak telant isiwǝliwil aḍu? Kala! ");
INSERT INTO ttq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Daɣ adi ma tǝkkam y a t-id-tǝnǝyam? Awak alǝs ilsân tabdoq tǝknat šihussay? Kala! Ǝnǝyat za aytedan win ǝlsanen tabdoq ta tǝhossayat, ǝgân deɣ tǝmǝddurt daɣ ǝnniflayan, inan ǝn mǝnokalan a ǝhan. ");
INSERT INTO ttq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Adi za ma tǝkkam y a t-id-tǝnǝyam? Awak ǝnnǝbi? Wǝllen zʼâs ǝnnǝbi. Amaran Yaxya ogar tišit n ǝnnǝbi fadda. ");
INSERT INTO ttq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Fǝlas Yaxya ǝnta a fǝl ǝnnan Ǝlkǝttaban: \"Ǝnǝy za a dat-ǝk assaglaɣ anammazul-in a zʼaknin tarrayt-nak.\" ");
INSERT INTO ttq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ǝnneɣ-awan, wǝr kala a d-ihǝw awedan ogaran Yaxya; dǝr iga awen da wala ɣas wa ogaran tǝmmǝdrǝyt daɣ Taɣmar ta n Mǝššina, da ogar Yaxya.» ");
INSERT INTO ttq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aytedan win ǝslanen y awal ǝn Yaxya, harkid nabazan n amana, kul ǝqbalan as tarrayt ta n Mǝššina ǝnta a toɣadat, adi a fǝl ǝrḍan issǝlmaq-qan Yaxya daɣ aman. ");
INSERT INTO ttq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mišan Farisaytan ǝd musanan n Ǝttawret, ǝntanay ǝssǝknan ǝs tugǝyt ta ǝgan s a tan-issǝlmǝɣ Yaxya daɣ aman, iba ǝn tǝrǝddawt-nasan s awa ixtas Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Inna Ɣaysa: «Mas zʼammattalaɣ aytedan n azzaman win nǝha da? Awak ma dǝr olan? ");
INSERT INTO ttq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Olân ǝd bararan ǝqqimnen daɣ ǝssuk tinǝmǝɣrin gannin: \"Nǝwat-awan tende, mišan wǝr tǝweɣam! Nǝg-awan isakkan ǝn tǝfǝyyawt, mišan wǝr tǝlem!\"» ");
INSERT INTO ttq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Ǝnneɣ-awan adi fǝlas Yaxya wa isalmaɣan aytedan daɣ aman as d-osa, issigat ǝzum wǝr isǝssu deɣ esmad n alɣanab, tǝnnam aggǝsuf a t-izdaɣan. ");
INSERT INTO ttq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amaran, nak Ag Aggadǝm ose-du, ǝtatta ǝsassa, mišan tǝnnam: \"Ǝnawat alǝs wen n amawwalay en, isassin esmad s igǝt, imos ǝmidi ǝn nabazan ǝn takǝsen d ark aytedan!\"» ");
INSERT INTO ttq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Masnat ta du-tǝfalat Mǝššina amaran, aytedan kul win ǝhanen tarrayt ta n Mǝššina, ǝntanay a sataddinen aqqad-net. ");
INSERT INTO ttq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Igmay Farisay iyyan daɣ Ɣaysa a ɣur-ǝs atšu. Tǝzzar ika Ɣaysa ehan ǝn Farisay wen, saɣɣamaran ad tamansawan. ");
INSERT INTO ttq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wala a ihogan tǝraz-du tǝntut iyyat ǝn tanasbakkadt tǝhât aɣrǝm en da, tǝslât as Ɣaysa imigarat i Farisay wen. As du-tosa tewây butalay n alwardi. ");
INSERT INTO ttq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tǝmal-du dǝffǝr Ɣaysa, ɣur daran-net ad tǝhallu har tǝssǝbdag idaran ǝn Ɣaysa ǝs mǝttawan-net, tǝmmas-tan ǝs jǝkkad-net. A dasan-tǝtamallat tǝnaqqal fall-asan alwardi. ");
INSERT INTO ttq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","As inay Farisay wa isimuguren Ɣaysa awen, inna daɣ man-net: «Ǝnnar imos alǝs a ǝnnǝbi, issǝn as tǝntut ta tu-tǝddasat da, tanasbakkadt.» ");
INSERT INTO ttq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Inn-as Ɣaysa: «Simɣon, a dak-annaɣ arat.» Inn-as Simɣon: «Šiwǝl, Ǝššex!» ");
INSERT INTO ttq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Inn-as Ɣaysa: «Kala a t-illa alǝs iyyan irwâsan ǝššin meddan. Iyyan irwâs-tu sǝmmosat tǝmad ǝn tamma n ǝzrǝf, wa hadan irwâs-tu sǝmmosat tǝmǝrwen. ");
INSERT INTO ttq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dad wǝr ǝlen as ǝrzaman, oyy-asan awa tan-irwas. Awak ma tǝnneɣ mǝni daɣ-san wa tu-z-iren wǝllen?» ");
INSERT INTO ttq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Inn-as Simɣon: «Ordeɣ as was oyya ǝmarwas wa aggen.» Inn-as Ɣaysa: «Tidǝt-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amaran imalallay-in tantut tǝzzar inna i Simɣon: «Tahannayaɣ tantut ta? As d-ǝggazaɣ ehan-nak wǝr di-tǝkfeɣ aman ǝs ǝššorada idaran-in, mišan ǝnta tǝssǝbdak-kan ǝs mǝttawan-net tǝmas-tan ǝs jǝkkad-net. ");
INSERT INTO ttq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","As d-oseɣ ehan-nak wǝr di-du-tǝssǝlkada, mišan ǝnta a d-oseɣ tǝtamallat i daran-in fǝl saɣmar a di-tǝga. ");
INSERT INTO ttq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kay wǝr tǝzwayaɣ eɣaf-in, mišan ǝnta idaran-in a fǝl tǝnɣal alwardi. ");
INSERT INTO ttq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adi a fǝl dak-ǝnneɣ: tara zǝwwǝrat ta di-tǝssǝkna tǝsitadda as ibakkadan-net tiwasarafan-as kul kuddeɣ ǝggǝtan; mišan awedan wa igrawan tǝsureft n a ǝndǝrran, ǝnta tara-net ši ǝndǝrrat.» ");
INSERT INTO ttq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tǝzzar inna Ɣaysa i tǝntut ten: «Ibakkadan-nam tiwasarafan-am.» ");
INSERT INTO ttq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ad gannin aytedan win dǝr-ǝs ǝdrawnen imensewan daɣ man-nasan: «Ma imos wa daɣ awedan as wala ibakkadan isuruf-tan y aytedan?» ");
INSERT INTO ttq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amaran inna Ɣaysa i tǝntut ten: «Ǝzǝgzan-nam a kam-iɣlasan, aglu daɣ alxer.» ");
INSERT INTO ttq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dǝffǝr awen illil Ɣaysa iɣǝrman ǝd tǝɣarmaten immâl y aytedan Ǝlinjil, imosan isalan ǝn Taɣmar ta n Mǝššina. Ǝddewan dǝr-ǝs nǝttulab-net win maraw d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iddew deɣ ǝd tǝdoden as šiyyad kǝlǝsuf a daɣ-asnat ikkas, šiyyad šiwǝrnawen a daq-qanat izzozay. Ǝmosnat Maryama Madǝl, s ǝnta a d-ǝgmadan ǝssa kǝlǝsuf, ");
INSERT INTO ttq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ǝd Jannata ta n tǝntut ǝn Xuza wa innǝttafan ǝd taɣawšiwen n ǝmǝnokal Herod, ǝd Suzana ǝd šiyyad šidoden aggotnen. Ketnasnat ǝdhâlnat Ɣaysa ǝd nǝttulab-net s awa ǝlanat. ");
INSERT INTO ttq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wǝr t-illa ǝɣrǝm a du-wǝr-gǝmmǝdan aytedan takkin-du Ɣaysa, tǝzzar tǝga fall-as tiddawat tagget, ig-asan ǝlmital wa: ");
INSERT INTO ttq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Kala ad igla ǝmagyak iyyan y ad inbǝl amasa-net. Daɣ anabal wa itaggu den imosan anabas n amasa, ərtaknat tǝblalen šiyyad fǝl tama ǝn tarrayt, tǝzzar ǝkkokalan daɣ-asnat aytedan, ǝtšan-tanat gǝḍad. ");
INSERT INTO ttq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Šiyyad ǝrtaknat daɣ adag ǝhanat tǝhun. As d-ǝgmadnat, ǝqqurnat fǝl iba ǝn bǝddug. ");
INSERT INTO ttq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Šiyyad ǝrtaknat daɣ tǝfǝssaɣ, ǝdwalnat dǝr-ǝsnat, ǝlmaznat-tanat. ");
INSERT INTO ttq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Šiyyad ǝrtaknat daɣ amaḍal olâɣan, tǝzzar ǝdwalnat. Ǝkkulluk ǝn tǝblalt terâw temeday n iyyat.» As inna Ɣaysa awen idkal ǝmǝsli-net inna: «Wa isallin, isǝsǝmet!» ");
INSERT INTO ttq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dǝffǝr awen ǝssǝstanan-tu nǝttulab-net d almaɣna n ǝlmital wa iga den. ");
INSERT INTO ttq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Inn-asan: «Kawanay tǝgrâwam masnat daɣ ǝssiran ǝn Taɣmar ta n Mǝššina, mišan aytedan win hadatnen tangalen as dasan-ittǝmal ǝssir wa, fǝl ad iqqǝl as \"ǝswâdan, mišan wǝr hǝnnǝyan; ǝssisaman mišan wǝr gǝrrin.\"» ");
INSERT INTO ttq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Igla Ɣaysa iššewal, inn-asan: «Ǝlmital wǝdi almaɣna-net da: amasa ǝlmital a imos n Awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amasa wa irtakan fǝl tama ǝn tarrayt, ǝlmital a imos n aytedan win ǝslanen y awal ǝn Mǝššina, mišan ad d-asu Iblis ikkǝs-tu daɣ wallan-nasan fǝl ad wǝr ǝzzǝgzǝnan, ǝgrǝwan efsan. ");
INSERT INTO ttq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amasa wa irtakan daɣ tǝhun, ǝlmital a imos n aytedan win ǝslanen y Awal ǝn Mǝššina, ǝqbalan-tu ǝs man filawasnen, mišan wǝr ila awen ekay, ǝzǝgzan-nasan wǝr itihag. As tawajarraban, a tan-igmǝd. ");
INSERT INTO ttq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amasa wa irtakan daɣ tǝfǝssaɣ, ǝlmital a imos n aytedan win ǝslanen y awal ǝn Mǝššina ǝqbalan-tu, mišan as tan-ǝdgǝzan aššawašatan n ǝddǝnet ǝd tara n ǝddǝnet d arak deranan, ǝssǝfalan-du dǝnnǝg awal wen, ad igdǝl awen y ǝzǝgzan-nasan alkamalat. ");
INSERT INTO ttq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amasa wa irtakan amaran daɣ amaḍal olaɣan, ǝlmital a imos n aytedan win ǝslanen y awal ǝn Mǝššina ǝlân iwallan olaɣnen lammodnen, tǝzzar ǝqbǝlan-tu, ǝttǝfan-tu s ǝlluɣ, tǝgmad-tan-du tǝnfa fǝlas ǝzmâran y arat kul.» ");
INSERT INTO ttq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Inn-asan Ɣaysa deɣ: «Wǝr t-illa awedan isarɣin fǝtǝla tǝzzar isǝbbǝnbǝy fall-as ǝɣǝzu madeɣ ag-et daw tessat. Kalar ǝšilǝy a tat-itaggu tǝšǝššilǝyt-net fǝl ad ǝnǝyan aytedan win du-taggaznen ehan s ǝnnur-net. ");
INSERT INTO ttq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wǝr t-illa a iɣbâran ǝs wǝrgeɣ ad affaggu, wala iyyan istâran ǝs wǝrgeɣ a d-inǝnǝfilǝl, itǝwǝssǝn ezal a mallan. ");
INSERT INTO ttq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Daɣ adi ǝnkǝdat y ǝmmǝk was tǝsasamam. Awedan wa ilan, a das-itǝwǝšitu awa ila; wa wǝr nǝla amaran, arat n awas iɣîl il-ay da a daɣ-as attarmas.» ");
INSERT INTO ttq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tosa-du anna ǝn Ɣaysa ǝd mǝdrayan-net, mišan orn-en a t-in-awǝdan fǝl igǝt ǝn tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Itawann-as: «Anna-nak ǝd mǝdrayan-nak ǝbdâdan-ak, ǝrân anay-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mišan inn-asan Ɣaysa: «Anna-nin ǝd mǝdrayan-in aytedan win sasamnen y awal ǝn Mǝššina, tamazalan s awa inna.» ");
INSERT INTO ttq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ǝzǝl iyyan iggaz Ɣaysa aɣlal n aman ǝnta ǝd nǝttulab-net. Inn-asan: «Nǝɣrǝset agaraw ǝs tagadamayt-net ta hadat.» Tǝzzar ǝglan. ");
INSERT INTO ttq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ǝglân fǝl aman as din-ibaz etǝs Ɣaysa. Wala a ihogan igar-du aḍu issohen fǝl agaraw, ad idakkar ǝɣlal aman, ǝggazan zega n a tan-atšin aman. ");
INSERT INTO ttq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ǝhozan-du nǝttulab Ɣaysa, a tu-sankaran daɣ etǝs, gannin as: «Ǝššex, Ǝššex, nǝhlak.» Inkar-du Ɣaysa isannarɣam y aḍu ǝd tanazzamaren takkinen ijǝnnawan, tǝzzar ibdad aḍu, idrar arat kul. ");
INSERT INTO ttq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Amaran inn-asan Ɣaysa: «Ma iga ǝzǝgzan-nawan?» Issirmaq-qan awen, isimaklal sǝr-san. Ad tinǝmǝnnin: «Ma imos wa daɣ awedan as wala aḍu d aman ittâf daɣ-san tanat?» ");
INSERT INTO ttq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dǝffǝr awen ewadan-in akal ǝn Garassenatan inimaɣlayan agaraw d akal wa n Galilaya. ");
INSERT INTO ttq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Da da ɣas a d-izzǝbbat Ɣaysa aɣlal n aman ǝnta a das-d-issǝlkad alǝs iyyan ǝhân kǝlǝsuf. Alǝs wen in ǝɣrǝm ihan akal en da. Irǝw as issǝnsa isǝlsa, igmad aɣaywan, ixsar daɣ zǝkwan. ");
INSERT INTO ttq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Inay Ɣaysa ɣas, ad itakkas imaslan labasnen, tǝzzar issǝjad i Ɣaysa, idkal ǝmǝsli-net wǝllen inna: «Ya Ɣaysa wa n Barar ǝn Mǝššina di n Amadkol ma daɣ-i tareɣ? Onsâyaq-qay a di-wǝr-tǝzǝɣɣǝba.» ");
INSERT INTO ttq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Innâ awen fǝlas Ɣaysa a omaran aggǝsuf wa t-ihan s a t-id-igmǝd. Iyyǝwan-du sǝr-ǝs aggǝsuf en ǝsǝnkǝr, karradan-tu aytedan ǝs sassaran ǝd tǝzabagawen mišan ad iɣtǝs awen kul, awǝy-tu aggǝsuf s ǝsuf. ");
INSERT INTO ttq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Issǝstan-tu Ɣaysa, inn-as: «Ma esǝm-nak?» Ijjiwwab-as inn-as: «Esǝm-in Egan.» Inn-as alǝs en awen fǝlas kǝlǝsuf aggotnen a t-ǝhanen. ");
INSERT INTO ttq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ad tansayan kǝlǝsuf win t-ǝhanen Ɣaysa a tan-wǝr-issuku anu wa wǝr nǝla eder. ");
INSERT INTO ttq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Illât-tu ǝsǝgǝn aggen ǝn ladayan ǝdânnen fǝl tasaga ǝn tǝkašwart. Onsayan kǝlǝsuf Ɣaysa y a tan-akfu turagat n ad ǝggǝzan iladayan en, ikf-asan-tat. ");
INSERT INTO ttq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ǝgmadan kǝlǝsuf alǝs en, ǝggazan iladayan. Tǝzzar ozalan-du ladayan fǝl azagada ǝn təkašwart ad titǝrǝgtǝrigan daɣ agaraw, tattan-tan aman. ");
INSERT INTO ttq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","As ǝnayan madanan ǝn layadayan awa igan den, ozalan, ǝgan isalan n awen daɣ ǝɣrǝm en ǝd ɣǝlǝyɣǝlayan-net. ");
INSERT INTO ttq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ǝglan aytedan y ad ǝnǝyan awa igan. As din-osan Ɣaysa ogazan-in ɣur-ǝs alǝs wa ǝgmadan kǝlǝsuf, iqqim ɣur daran-net, ilsâ, tǝqqâl-t-idu deɣ tayttay-net, tǝzzar tǝggaz-tan tasa. ");
INSERT INTO ttq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ǝgan daɣ-san aytedan win ǝgǝyyatnen y awen isalan n ǝmmǝk was itawasafsa alǝs wa daɣ tawakkasan kǝlǝsuf. ");
INSERT INTO ttq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mišan ǝnkaran-du aytedan kul win akal ǝn Garassenatan ad gammayan daɣ Ɣaysa a tan-ugag fǝlas tasa a tan-tǝggazat zǝwwǝrat. Iggaz Ɣaysa aɣlal n aman iqqal. ");
INSERT INTO ttq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Onsay-tu alǝs wa ǝgmadan kǝlǝsuf ad t-ayyu a dǝr-ǝs idaw, mišan issoɣal-tu Ɣaysa inn-as: ");
INSERT INTO ttq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ǝqqǝl ehan-nak, tǝmǝla y aytedan iket n arraxmat ta dak-iga Mǝššina da.» Tǝzzar igla ad immal daɣ ǝɣrǝm en ketnet arat kul wa das-iga Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","As iqqal Ɣaysa ǝsǝlim wa hadan n agaraw, tǝssǝlkad-as-du tamattay as ketnet tǝqqâl-as. ");
INSERT INTO ttq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Alwaq wen da a d-osa alǝs iyyan igân esǝm Jayɣus imosan iyyan daɣ muzaran n ahan n ǝlɣibada wa n Kǝl-Ǝlyǝhud ǝn tǝɣrǝmt ten. Issǝjad dat Ɣaysa, ad t-itansay ad idawan s ahan-net, ");
INSERT INTO ttq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","fǝlas elles tǝmosat wǝlǝt maraw elan d ǝššin, s ǝnta ɣas a ila, a tǝbukat y iba. Iddew dǝr-ǝs Ɣaysa, tǝtanabdaɣ fall-as tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tamattay en tah-et təntut təgât maraw elan d əššin igammad-tat əzni. Tǝnɣa tǝla-net kul daɣ nasmagalan, mišan wǝr t-illa awedan ifrâgan ǝzuzǝy-net. ");
INSERT INTO ttq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tǝhoz-du Ɣaysa sa sǝr tǝɣǝrden, tǝdas tǝbǝnik ǝn tǝkadkat-net, izzǝkkat ǝzni wa tat-igammadan tamazayt ten da. Tǝzzay. ");
INSERT INTO ttq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tǝzzar inna Ɣaysa: «Ma di-idasan?» Iggad awedan kul as t-idâs, amaran inn-as Butros: «Ǝššex, tamattay a ketnet as kay-taɣalayɣalay, tǝsâs-kay.» ");
INSERT INTO ttq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mišan ya inna Ɣaysa: «Awedan iyyan idâs-i fǝlas ǝfrâya i tarna iyyat as di-tǝgmad.» ");
INSERT INTO ttq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","As tǝssan tǝntut ten as tǝffigga, tǝkka-du Ɣaysa tǝndaw-tat taysǝst, tǝssǝjad dat-ǝs, tǝmal-as dat aytedan kul ǝddǝlil wa fǝl tu-tǝdas ǝd tǝmǝzzǝyt ta tǝga tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Inn-as Ɣaysa: «Tabarart-in, ǝzǝgzan-nam sǝr-i a kam-izzozayan, aglu daɣ alxer.» ");
INSERT INTO ttq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Harwada iššewal Ɣaysa as d-osa awedan iyyan a d-ifalan aɣaywan ǝn Jayɣus wa n ǝmuzar n ahan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, inn-as: «Allek aba-tat, mazzay d ǝddaguz n Ǝššex.» ");
INSERT INTO ttq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Isla Ɣaysa y awen, inna i Jayɣus: «Ad wǝr tǝrmǝɣa, zǝgzǝn ɣas, allek ad tǝzzǝy.» ");
INSERT INTO ttq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","As din-ewad Ɣaysa ehan ǝn Jayɣus, igdal y aytedan ad t-ǝggǝzan, wǝr oyya ar Butros ǝd Yaxya ǝd Yaqub d abba ǝn tǝbarart d anna-net. ");
INSERT INTO ttq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aytedan kul win ǝllanen den, hallan, sikalalan fǝl tǝbarart mišan inn-asan Ɣaysa: «Ayyiwat tala, tǝbarart wǝr tat-aba, etǝs ɣas a tǝga.» ");
INSERT INTO ttq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A daɣ-as tajaban fǝlas ǝssânan as wǝr tǝdder. ");
INSERT INTO ttq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tǝzzar iggaz Ɣaysa fǝl tǝbarart, ibaz ǝfus-net, iɣr-et, inn-as: «Tabarart ǝnkǝr-du!» ");
INSERT INTO ttq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ǝqqalan-tat-du man-net tǝbdad-du daɣ tamazayt ten da, tǝzzar omar-tan Ɣaysa s a tat-akfin a tǝtša. ");
INSERT INTO ttq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ǝhagan marwan ǝn tǝbarart, mišan irɣam-asan Ɣaysa fǝl amel n awen y awedan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iɣra-du Ɣaysa inǝttulab-net win maraw d ǝššin, ikf-en tarna d ǝlxǝkum fǝl kǝlǝsuf kul, ikf-en deɣ fǝrregat n ǝzuzǝy ǝn tǝwarnawen. ");
INSERT INTO ttq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Izammazal-tan y ad agin isalan ǝn Taɣmar ta n Mǝššina, ǝzzuzǝyan deɣ imiranan. ");
INSERT INTO ttq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Inn-asan: «Ad wǝr tawǝyam wala daɣ ǝšikǝl, gǝr zʼiqqal tallaq wala aɣrǝg, wala allaw, wala azrǝf, wala deɣ a okâyan tǝkadkat iyyadda. ");
INSERT INTO ttq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","As din-tosam aɣrǝm, ehan wa tǝggazam isammagarat-kawan, zabbatat daɣ-as har tǝgmǝdam aɣrǝm wǝdi. ");
INSERT INTO ttq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aɣrǝm tǝggazam wǝr kawan-ǝqbelan aytedan-net, as tu-tǝgammadam tǝbbikbakam-in ǝgodrar-net wa iwaran idaran-nawan, ilkâm ad aggayyat awen fall-asan.» ");
INSERT INTO ttq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ǝglan nǝttulab, ǝllilan šiɣarmaten, ad ǝmmâlan Ǝlinjil daɣ adag kul, zuzǝyan daɣ-as deɣ imiranan. ");
INSERT INTO ttq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Isla Herod wa n amuzar n akal ǝn Galilaya aratan kul win itaggu Ɣaysa ǝd nǝttulab-net, iqqan awen eɣaf-net fǝlas ǝllan-tu aytedan ganninen ǝs Ɣaysa: «Awen Yaxya wa isalmaɣan aytedan daɣ aman a d-inkaran daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wiyyad gannin: «Awen ǝnnǝbi Ilyas a d-izzǝbben.» Wiyyad deɣ gannin: «Awen iyyan daɣ ǝnnǝbitan win ǝrǝwnen a d-inkâran daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Inna Herod: «Yaxya, nak iman-in a d-issǝfrasan eɣaf-net, daɣ adi ma imos alǝs wa fǝl sallaɣ aratan win?» Ad igammay Herod d anay ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ǝqqalan-du nǝmmuzal, ǝssoɣalan i Ɣaysa awa ǝgan kul. Tǝzzar igmad dǝr-san aytedan s adag issufan a din-ikitayyen, ihan anamod ǝn tǝɣrǝmt ta n Betsayda. ");
INSERT INTO ttq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mišan tǝsla tamattay awen, tǝlkam-as. Ig-asan Ɣaysa marxaba, tǝzzar iššewal-asan daɣ salan ǝn Taɣmar ta n Mǝššina, izzozay daɣ-san win ǝddǝrarnen s awen. ");
INSERT INTO ttq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","As tǝbuk tǝfuk y agadal, ǝhozan-t-idu nǝttulab-net win maraw d ǝššin, ǝnnan-as: «Suɣǝl tamattay a, ad takku šiɣarmaten ǝd ɣawnatan win ǝhoznen, ad tǝgmǝy id tǝnsa d a tǝtša fǝlas edag issufan awa.» ");
INSERT INTO ttq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Inn-asan: «Satšat-tan kawanay iman-nawan da!» Ǝnnan-as: «Nakkanay wǝr nǝttef ar sǝmmosat tǝgǝlwen d ǝššin kifitan, kundaba za ad nǝglâ nazzanza-du imensewan i tǝxlǝk a kul.» ");
INSERT INTO ttq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Edag ǝn sǝmmos gim n alǝs a ǝllanen den. Inna Ɣaysa i nǝttulab-net: «Saɣɣamiwat aytedan kul, tagim-tan šiɣimten ǝn sǝmmosat sǝmmosat tǝmǝrwen n awedan.» ");
INSERT INTO ttq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ǝgan nǝttulab awen da, saɣɣaman aytedan kul. ");
INSERT INTO ttq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tǝzzar idkal Ɣaysa sǝmmosat tǝgǝlwen šin den d ǝššin kifitan win, iggǝzzay ijǝnnawan, iga igodan i Mǝššina amaran ikaramkaram šigǝlwen šin, iga awen da i kifitan, ikf-en i nǝttulab-net y a tan-uzanan i tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ǝtšan aytedan en ketnasan har əyyəwanan. Tawašadawan-du karammutan win du-tawaglaznen, tawadnayan daɣ-san maraw ǝzmaman d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ǝzǝl iyyan itattar Ɣaysa ɣas-net, wǝr ɣur-ǝs illa ar inǝttulab-net, dǝffǝr awen issǝstan-tan, inn-asan: «Awak daɣ iduf n aytedan, ma ǝmosa?» ");
INSERT INTO ttq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ǝnnan-as: «Wiyyad a gannin Yaxya wa isalmaɣan aytedan daɣ aman a tǝmosa, wiyyad a gannin: ǝnnǝbi Ilyas, wiyyad deɣ a gannin iyyan daɣ ǝnnǝbitan win ǝrǝwnen a d-inkâran daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tǝzzar inn-asan: «Kawanay za ma tǝnnam ma ǝmosa?» Inn-as Butros: «Ǝlmǝsix ǝn Mǝššina a tǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Issənkad Ɣaysa nǝttulab-net, omar-tan s ad wǝr ǝmǝlan y awedan waliyyan isalan win den. ");
INSERT INTO ttq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Inn-asan: «Nak Ag Aggadǝm ilzâm-i ad ǝnǝyaɣ arkanay aggen, unkaran-i muzaran ǝn Kǝl-Ǝlyǝhud ǝd muzaran ǝn limaman ǝd musanan n Ǝttawret, tǝwǝggin man-in, ǝnkǝra-du deɣ daɣ tǝmattant ǝzǝl wa n karad.» ");
INSERT INTO ttq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dǝffǝr awen inn-asan ketnasan: «Wa iran a di-ilkǝm, wǝdi igmǝdet tara ən man-net, agu imateran-net idkǝl tǝgǝttawt-net akk ǝzǝl, ilkəm-i. ");
INSERT INTO ttq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ǝssǝnat as awedan wa wǝr nǝgǝmmǝy ar aggaz ǝn man-net, wədi ad t-ǝgmǝdan, mišan wa iqbalan ad t-ǝgmǝdan fəl əddǝlil-in, wǝdi ad iɣlǝs. ");
INSERT INTO ttq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma zʼaknu y awedan ad igrǝw ǝddǝnet ketnet, ǝnta issixrak iman-net, iffota daɣ alaxirat? ");
INSERT INTO ttq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Awedan kul wa isakkarakad ləkkum y-i, madeɣ isikarakad-tu əsuɣəl n awal-in, wǝdi nak da, Ag Aggadǝm, a di-isəkkərukəd ǝlqǝbulat-net ǝzǝl wa du-z-ǝqqǝla aheɣ tanaya-nin, tǝmosat tanaya ta n Abba, tǝmos deɣ ta n angalosan a zaddognen. ");
INSERT INTO ttq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ǝggǝyyeɣ ǝsilakanaɣ-awan as, wiyyad daɣ-wan ǝbdâdnen da da, wǝr tan-z-iba wǝr ǝnayan Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Edag n ǝttam adan dǝffǝr igi wa dasan-iga Ɣaysa batuten šin den, inkar iddew ǝd Butros ǝd Yaxya ǝd Yaqub s ǝdɣaɣ iyyan fǝl a fall-as ansǝy Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Itattar den da as immǝttay udǝm-net, tǝzzar ǝgan sǝlsa-net tǝmǝllay tǝtassamat. ");
INSERT INTO ttq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ǝhinan-in oggân ǝnnǝbi Musa d ǝnnǝbi Ilyas daɣ tanaya ǝn Mǝššina, mišawalan ǝd Ɣaysa daɣ batu n agamad wa zʼagu ǝddǝnet a zʼattaddin daɣ Yerusalam ǝs tǝmattant-net. ");
INSERT INTO ttq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","As itaggu awen Butros ǝd midawan-net ibâz-tan-in etǝs. As d-ǝnkaran ǝnayan tanaya ǝn Ɣaysa, ǝnayan deɣ ǝššin meddan win dǝr innǝbdad. ");
INSERT INTO ttq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","As iggaz ǝnnǝbi Musa d Ilyas šin ǝgǝlli, inna Butros i Ɣaysa: «Ǝššex, olâɣ as nǝlla da. Ǝndawat ad nǝkrǝs karad hǝktan: iyyan i-nak, iyyan in Musa, iyyan in Ilyas.» Wǝr issen Butros a igannu den. ");
INSERT INTO ttq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Igannu Butros awen da as du-tǝnafalal tǝgarak iyyat, tǝlsa Ɣaysa d ǝnnǝbitan ǝššin win dǝr innǝbdad. As tǝlsa Butros ǝd midawan-net, tǝggaz-tan tasa. ");
INSERT INTO ttq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Igmad-du ǝmǝsli tǝgarak ten, inna: «Awa Barar-in wa sannafranaɣ, sǝsǝmat-as.» ");
INSERT INTO ttq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","As tǝnda batu ten, wǝr hǝnnǝyan nǝttulab ar Ɣaysa. Ǝffǝstan fǝl awen, wǝr t-illa awedan ǝs t-ǝmâlan daɣ adan en. ");
INSERT INTO ttq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","As ǝzǝl wa ilkaman i wen, izzǝbbat-du Ɣaysa ǝd nǝttulab-net win karad en adɣaɣ, tǝzzar tǝssǝlkad-as-in tamattay tǝgget. ");
INSERT INTO ttq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wala a ihogan idkal alǝs iyyan daɣ ammas ǝn tamattay en ǝmǝsli-net, inna: «Ya Ǝššex, onsayaq-qay a di-tǝhǝnǝtteɣ i barar-in, ǝnta ɣas a ǝleɣ. ");
INSERT INTO ttq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aljayn a t-itabazan, tǝzzar ad izayyak, itizǝbǝrdil, isakafkaf. Gǝrrid as t-itayyu, issikn-ay alɣazab. ");
INSERT INTO ttq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Onsâyaɣ inǝttulab-nak a daɣ-as t-ǝkkǝsan, indar-asan.» ");
INSERT INTO ttq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tǝzzar inna Ɣaysa: «Xa! Iket iba n ǝzǝgzan d ǝššur daɣ aytedan n azzaman a! Awak har ǝmmay ǝddewa dǝr-wan, ǝzmâraɣ-awan? Awǝy-du barar-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","As d-ihoz barar Ɣaysa, iggǝdl-ay aggǝsuf, ad itizǝbǝrdil. Iharaššat Ɣaysa aggǝsuf, ikkas-tu daɣ barar, izzay, issoɣal-tu y abba-net. ");
INSERT INTO ttq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aytedan kul tǝsimaklal sǝr-san tǝzzǝwwǝrt ǝn tarna ǝn Mǝššina. Harwada isimaklal s aytedan arat kul wa iga Ɣaysa den, as inna i nǝttulab-net: ");
INSERT INTO ttq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Tǝggǝzet batu ta šimǝzzugen-nawan, tǝttafam-tat: \"Nak Ag Aggadǝm ǝjwâra ad ǝggâzaɣ ifassan n aytedan.\"» ");
INSERT INTO ttq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mišan wǝr ǝgren batu ta dasan-iga den, ittinkal-asan almaɣna-net fǝl a tat-wǝr-agrin, amaran tah-en tasa n ǝsǝstan-net. ");
INSERT INTO ttq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tǝnkar tamazaq gǝr nǝttulab ǝn Ɣaysa daɣ batu ǝn wa daɣ-san ogaran almaqam. ");
INSERT INTO ttq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Issân Ɣaysa awa samadranan, a di fǝl d-idkal arat ǝn barar iyyan issǝbdad-tu dǝgma-net, ");
INSERT INTO ttq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","amaran inn-asan: «I iqbalan barar a, fǝl ǝddǝlil-in, nak a iqbal. I di-iqbalan deɣ, wa di-d-izammazalan a iqbal. Wa daɣ-wan wǝr nǝmos arat, ǝnta a zǝwwǝran.» ");
INSERT INTO ttq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Inna Yaxya i Yaysa: «Ǝššex, nǝnây alǝs iyyan itakkasan kǝlǝsuf daɣ aytedan s esǝm-nak, nǝnn-as ad wǝr ilǝs igi n awen, fǝlas wǝr danaɣ-iha ǝs lǝkkum y-ak.» ");
INSERT INTO ttq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Inn-as Ɣaysa: «A das-tu-wǝr-tǝgdǝlam, fǝlas i wər nəgəmməy təkma-nawan, wədi əmidi-nawan.» ");
INSERT INTO ttq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","As d-ǝhozan adan win daɣ zʼassandu Ɣaysa arat wa ixtas Mǝššina, a t-imosan ǝmǝdkǝl-net ǝs jǝnnawan, isaggatakkat y iki n ǝɣrǝm ǝn Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Issǝgla inammazalan dat-ǝs, ǝkkan taɣrǝmt iyyat n akal ǝn Samarǝya y a das-aknin edag n ǝzǝbbi. ");
INSERT INTO ttq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mišan ugayan aytedan ǝn tǝɣrǝmt ten s a dasan-imǝgurǝt fǝlas ikkâ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","As inay Yaqub ǝd Yaxya win nǝttulab-net awen, ǝnnan: «Ǝmǝli, tareɣ ad nannu i tǝmsay a fall-asan du-tazzabbat, tǝsǝrrǝkǝmmǝt-tan?» ");
INSERT INTO ttq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Imalallay-tan-in Ɣaysa, isannarɣam-asan, ");
INSERT INTO ttq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","tǝzzar okayan ǝs tǝɣrǝmt iyyat. ");
INSERT INTO ttq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jiwanken as inna alǝs iyyan i Ɣaysa: «A dak-ǝlkǝma s adag kul wa tǝkke.» ");
INSERT INTO ttq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Inn-as Ɣaysa: «Izagazan ǝlân enwan, igǝḍad deɣ ǝlân šisǝllula, mišan nak Ag Aggadǝm wǝr ǝleɣ wala edag daɣ ǝssǝnsa eɣaf-in.» ");
INSERT INTO ttq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Inna Ɣaysa y iyyan alǝs: «Ǝlkǝm-i.» Tǝzzar inn-as: «Ǝmǝli, akf-i turagat n ad agla har din-ǝnbǝlaɣ abba-nin tǝzzar.» ");
INSERT INTO ttq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mišan inn-as Ɣaysa: «Ayyu inǝmmǝttan ad ǝnbǝlan inǝmmǝttan-nasan, kay amaran, aglu taga y aytedan isalan ǝn Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inn-as iyyan alǝs: «Ǝmǝli, areɣ a dak-ǝlkǝma, mišan akf-i turagat n ad nǝmǝgga d aytedan-in šiwatriwen tǝzzar.» ");
INSERT INTO ttq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Inn-as Ɣaysa: «Awedan wa issǝntan daɣ lǝkkum y-i, mišan wǝr iga awen s ǝwǝl iyyanda, wǝdi wǝr ihor ǝd Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dǝffǝr awen isannafran Ǝmǝli wiyyad inǝttulab ǝmosnen ǝssayat tǝmǝrwen d ǝššin, izammazal-tan s ǝššin ǝššin y a das-in-izaran ǝs ɣǝrman ǝd daggan win as ibuk y a tan-immǝr. ");
INSERT INTO ttq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Inn-asan: «Ɣarat tǝggǝt, mišan wǝr ǝggǝtan maššaɣalan win tat-z-alǝynen. Daɣ adi ǝttǝrat s esǝm ǝn mǝššis ǝn ɣarat ta, a d-assaglu imaššaɣalan a tat-olaynen. ");
INSERT INTO ttq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aglat! Zimazalaq-qawan tǝmosam zun jamaran ǝhanen ammas ǝn ridalan. ");
INSERT INTO ttq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ad wǝr tawǝyam azrǝf wala aɣrǝg wala tǝsǝsǝl ta n sanatat. A kawan-wǝr-sǝllulen assalaman daɣ tarrayt.» ");
INSERT INTO ttq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Ehan tǝggazam, tǝgǝram fall-as assalam tǝzzar. ");
INSERT INTO ttq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kud ih-ay awedan n alxer, wǝdi a kawan-iqbǝl, igrǝw alxer-nawan. Kud deɣ wǝr t-iha, wǝdi takǝyam d alxer-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","As tǝgrawam ehan n awedan n alxer, tǝxsǝram daɣ-as. Tatšim, tašwim awa kawan-itawakfan, fǝlas amaššaɣal kul ihor d alxaq-net. Ad wǝr tilalam inan.» ");
INSERT INTO ttq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Aɣrǝm a din-tosam deɣ ǝqbalan-kawan mǝssawǝs, tatšim arat was kawan-sammagaren, ");
INSERT INTO ttq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tǝzzuzǝyam imiranan win t-ǝhanen, tǝzzar tannim y aytedan-net: \"Taɣmar ta n Mǝššina tǝhôz-kawan-du.\" ");
INSERT INTO ttq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mišan aɣrǝm a din-tosam wǝr kawan-ǝqbelan mǝssawǝs, ilalat tarrayen-net tǝgannim: ");
INSERT INTO ttq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Tǝggiyem as wala aboqqa n ǝɣrǝm-nawan wa iwaran idaran-nana da nǝbbikbakk-in, mišan ǝssǝnat as Taɣmar ta n Mǝššina tǝhôz.\" ");
INSERT INTO ttq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ǝnneɣ-awan, ǝzǝl wa n tabadday, aytedan n ǝɣrǝm wǝdi, ad agin alɣazab ogaran wa zʼagin win ǝɣrǝm wa n Sǝdom.» ");
INSERT INTO ttq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Iket alɣazab iqqâl-awan kǝl-aɣrǝm ǝn Koradzin! Iket alɣazab iqqâl-awan kǝl-ǝɣrǝm ǝn Betsayda! Fǝlas tǝlmǝɣjujaten šin ɣur-wan ǝganen ǝnnar ǝgânat daɣ ǝɣrǝm ǝn Tir ǝd wa n Sidon, wǝdi irǝw as ǝqqanan isǝlsa ǝn bǝhu ǝqqiman daɣ eẓǝd, imos awen ǝsǝnnǝfilǝl n as ǝhdăn. ");
INSERT INTO ttq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Awen daɣ a fǝlas, alɣazab wa za tagim ǝzǝl wa n tabadday ad agǝr wa zʼagin aytedan n ǝɣrǝm ǝn Tir ǝd wa n Sidon. ");
INSERT INTO ttq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kawanay aytedan n ǝɣrǝm wa n Kafarnahum, adis ad tammadkalam s aljannat? Kalar Jahannama a daɣ za tǝtǝwǝgaram.» ");
INSERT INTO ttq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Inna Ɣaysa deɣ i nǝttulab-net: «Awedan wa dawan-issǝsaman, nak as issǝsam; wa kawan-inkuran deɣ, nak a inkur. Amaran wa di-inkuran, wǝdi wa di-d-izammazalan a inkur.» ");
INSERT INTO ttq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","As d-ǝqqalan nǝttulab win ǝssayat tǝmǝrwen d ǝššin, ǝknân tǝfalawist, gannin i Ɣaysa: «Ǝmǝli, wala kǝlǝsuf ǝttâfan tǝnna-nana as dasan-nǝɣra esǝm-nak!» ");
INSERT INTO ttq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tǝzzar inn-asan Ɣaysa: «Hannayaɣ Aššaytan as d-ifataqqat daɣ jǝnnawan zun essam. ");
INSERT INTO ttq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ǝssǝnat as ǝkfeq-qawan tarna fǝl taššolen ǝd tǝzurdam d awa ila azangaw-nana Iblis kul daɣ tarna. Wǝr t-illa a ifrâgan a dawan-agu tǝkma. ");
INSERT INTO ttq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mišan a kawan-wǝr-isǝfǝliwǝs as ǝttâfan kǝlǝsuf tǝnna-nawan, kalar isǝffǝliwǝset-kawan akatab wa ǝgan ǝsmawan-nawan daɣ aljannat.» ");
INSERT INTO ttq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Assaɣat ten da ad ikna Infas wa Zǝddigan ǝsǝddǝwi ǝn Ɣaysa, tǝzzar inna: «Ǝgeɣ-ak tǝmmalen ya Abba, Ǝmǝli ǝn jǝnnawan d amaḍal fǝl aɣabar wa tǝgeɣ aratan win i musanan, ǝd malan ǝn tayttay, tǝsannafalalaq-qan y aytedan win wǝr nǝzlay ǝd bararan; id adi da a imosan agna-nak ya Abba. ");
INSERT INTO ttq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Arat kul ig-ay Abba-nin daɣ ǝfus-in, wǝr t-illa i issanan awa ǝmosa ar Abba, wǝr t-illa deɣ i issanan awa imos Abba ar nak an Barar-net d awedan was areɣ a das-tu-sǝnnǝfilǝla.» ");
INSERT INTO ttq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Imalallay-in Ɣaysa inǝttulab-net, iššewal-asan ǝntanay ɣas, inn-asan: «Ǝbbilalnat šittawen šin hannaynen awa tǝhannayam! ");
INSERT INTO ttq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Silakanaɣ-awan as sidaranan ǝnnǝbitan aggotnen ǝd mǝnokalan anay n awa tǝhannayam, mišan wǝr t-ǝnayan, sidaranan deɣ tesalay y awas tǝsallim, mišan wǝr das-ǝslen.» ");
INSERT INTO ttq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dǝffǝr awen inkar-du ǝmusan n ǝššǝriɣa iyyan iga i Ɣaysa ǝsǝstan imosan tǝnagmayt, inn-as: «Ǝššex, mas di-ilzam igi-net, y ad ǝgrǝwa tǝmǝddurt ta tǝɣlalat?» ");
INSERT INTO ttq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Inn-as Ɣaysa: «Ma iktaban daɣ Ǝttawret? Ma daɣ-as tǝɣreɣ?» ");
INSERT INTO ttq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ijjǝwwab-as, inn-as: «Iktâb daɣ-as as: \"Ad tireɣ Ǝmǝli-nak Mǝššina s ǝwǝl iyyanda, ǝd man ǝrdânen, tireq-qu ǝs tǝɣurad-nak kul ǝd tayttay-nak kul, tireɣ deɣ ǝšǝqqaɣ-nak ǝs tǝmǝwit tas tareɣ iman-nak.\"» ");
INSERT INTO ttq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Inn-as Ɣaysa: «Aljawab-nak oɣâd, taggu adi da ad tǝddǝra.» ");
INSERT INTO ttq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mišan dad ira ǝmusan wen ad aknu batu-net, inna i Ɣaysa: «Ma imosan za ǝšǝqqaɣ-in?» ");
INSERT INTO ttq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijjǝwwab-as Ɣaysa s ǝlmital wa, inn-as: «Alǝs iyyan a d-igmadan aɣrǝm ǝn Yerusalam, iras ikka wa n Yerikaw har t-ǝgrawan baydagan. Ǝbazan daɣ-as awa ila, ǝggâtan-tu, as t-oyyan illa gǝr tǝmǝddurt d iba. ");
INSERT INTO ttq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Imazayyat d awen d as d-iga ǝlimam iyyan tarrayt ten. Inay alǝs wen, iɣlay-tu. ");
INSERT INTO ttq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Illam-du iyyan daɣ Kǝl-Lebi ǝnta da den, inay-tu, iɣlay-tu. ");
INSERT INTO ttq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mišan as d-illam aw Samarǝya iyyan den iššokalan, inay-tu, tǝggaz-tu tǝhanint-net. ");
INSERT INTO ttq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ikk-ay-du, iššorad ibusan-net s azzayt d esmad n alɣanab, ittal-tan, tǝzzar issǝwan-tu tǝsǝnǝyt-net, eway-tu s azazzabbaw, issan daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","As affaw, idkal-du ǝššin dinaran n ǝzrǝf ikf-en y alǝs wa innǝttafan d azazzabbaw, inn-as: \"Ǝssǝn daɣ alǝs di, as d-ǝqqala, nak a dak-z-irzǝman arat kul wa fall-as tǝnɣeɣ, kud ǝnta ogar adi.\"» ");
INSERT INTO ttq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Amaran inna Ɣaysa y ǝmusan n Ǝttawret wen: «Mǝni daɣ meddan win karad a, was tordeɣ as ǝnta a igan y alǝs wa ǝnɣan baydagan a amazal wa itaggu awedan y ǝšǝqqaɣ-net?» ");
INSERT INTO ttq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Inn-as: «Wa das-ihanatten.» Inn-as Ɣaysa: «Adi za aglu, taga kay da zun d awen daɣ.» ");
INSERT INTO ttq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Igla Ɣaysa daɣ ǝšikǝl-net ǝnta ǝd nǝttulab-net har iggaz taɣrǝmt iyyat innǝftaɣ i tǝntut tǝgât esǝm Marta. ");
INSERT INTO ttq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tantut ta tǝla tǝmadrayt-net tǝgât esǝm Maryama. Tǝqqim Maryama ɣur daran n Ǝmǝli Ɣaysa, tǝssisam y awa igannu. ");
INSERT INTO ttq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta amaran, išimašan-tat ǝššǝɣǝl n ǝsǝmmǝguri ǝn Ɣaysa. Wala ihogan tǝhoz-du Ɣaysa, tǝnn-as: «Ǝmǝli, awak zǝlǝyat a wǝr tǝgeɣ daɣ as di-toyya tamadrayt-in d ǝššǝɣǝl ketnet ɣas-in? Ann-as a di-tilal.» ");
INSERT INTO ttq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Inn-as Ɣaysa: «Marta, Marta! Ǝššiwašan-kam aratan aggotnen, ǝssiggadan tayttay-nam. ");
INSERT INTO ttq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ǝnta arat iyyanda as tǝga addararat olâɣ a t-imosan ǝsǝsǝm y awal-in, ǝnta a tǝsannafran Maryama, amaran wǝr daɣ-as zʼǝttǝrmas.» ");
INSERT INTO ttq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ǝzǝl iyyan itattar Ɣaysa daɣ adag iyyan. As issǝnda, inn-as iyyan daɣ nǝttulab-net: «Ǝmǝli, susǝn-ana tǝwatray zun awa iga Yaxya i nǝttulab-net.» ");
INSERT INTO ttq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Inn-asan Ɣaysa: «As tǝtattaram, tannim: \"Abba, Itǝwǝsǝɣmǝret esǝm-nak di zǝddigan, taset-du taɣmar-nak. ");
INSERT INTO ttq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akf-anaɣ akk ǝzǝl isudar-nana, ");
INSERT INTO ttq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","tǝssurǝfaɣ-anaɣ ibakkadan-nana, zund ǝmmǝk as nakkanay da nǝsuruf i win danaɣ-ǝganen ark mazalan. A dana-wǝr-taga daɣ alɣarar ǝn jarrabatan n Iblis.\"» ");
INSERT INTO ttq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Inn-asan Ɣaysa deɣ: «Mǝni daɣ-wan wa zʼilen ǝmidi, as-ay-du adawannay n ahad ann-as: \"Zǝbǝnat-i-du karadat tǝgǝlwen, ");
INSERT INTO ttq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","fǝlas iyyan daɣ midawan-in a di-d-innǝftaɣan, wǝr ǝleɣ a t-ǝššǝtša.\" ");
INSERT INTO ttq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tǝzzar ann-as-du daɣ ammas n ahan: \"A di-wǝr-tǝdgǝza, ehan-in ǝmǝrǝdda ixfâl, nak ǝd bararan-in nǝqqâl s etǝs, wǝr ǝfrega a din-ǝbdǝdaɣ akfaq-qay arat.\" ");
INSERT INTO ttq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ǝnneɣ-awan, kud wǝr d-inker akf-as-tanat fǝlas imos ǝmidi-net, da ad d-inkǝr akf-ay arat kul was iddǝrar fǝlas wǝr t-isakkarakad mansay wa t-iga den.» ");
INSERT INTO ttq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Amaran nak ǝnneɣ-awan: «Ansǝyat Mǝššina a kawan-akfu; ǝgmǝyat, ad tǝgrǝwam. Kawkawat tǝsǝhǝrt a dawan-tannalam; aɣrat-tu, a dawan-akkawan. ");
INSERT INTO ttq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Awalla i onsayan ad itǝwǝkfu; i igmayan, ad igrǝw, i iɣran deɣ Mǝššina, a das-akkawan. ");
INSERT INTO ttq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mǝni daɣ-wan wa daɣ zʼigmǝy barar-net isan, akf-ay taššolt? ");
INSERT INTO ttq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wala igmǝy daɣ-as tǝkǝkit akf-ay tǝzardǝmt? ");
INSERT INTO ttq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kud kawanay an nǝllubas tǝssânam tehakkay n awa olaɣan i bararan-nawan, manǝmmǝk as kawan-wǝr-z-akfu Abba-nawan wa ihan ijǝnnawan Infas wa Zǝddigan as das-tu-tonsayam?» ");
INSERT INTO ttq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dǝffǝr awen ikkas Ɣaysa daɣ alǝs iyyan aggǝsuf a das-igaddalan awal. Igmad-tu aggǝsuf ɣas iššewal, isammaklal awen ǝs tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mišan ad gannin wiyyad daɣ-san: «Awen Aššaytan Baɣalzabul, wa n ǝmǝnokal ǝn kǝlǝsuf a t-ikfan fǝrregat n ikus ǝn kǝlǝsuf daɣ aytedan.» ");
INSERT INTO ttq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wiyyad deɣ arân ad t-ajjarraban, gammayan daɣ-as a dasan-agu tǝlmǝɣjujat tǝmosat alɣalamat a du-tǝfâlat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ɣaysa ǝnta issân awa samadranan, adi a fǝl dasan-inna: «Taɣmar kul tas ǝmmǝgaran mǝssawǝs gar-essan, ǝbǝrǝjji a za tagu, tǝzzar ǝbǝrǝjjen ɣawnatan-net s iyyan iyyan. ");
INSERT INTO ttq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tǝgannim nak Aššaytan Baɣalzabul a di-ikfan fǝrregat n ikus ǝn kǝlǝsuf daɣ aytedan; kud adi a igan wǝdi manǝmmǝk as za tihag taɣmar-net ǝnta imǝggar ǝd man-net? ");
INSERT INTO ttq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Amaran kud nak tarna ǝn Baɣalzabul as takkasaɣ kǝlǝsuf daɣ aytedan, inalkiman-nawan za ma ilan tarna tas tan-takkasan? Adi da fǝlas ǝntanay iman-nasan as kawan-z-ǝbǝzan s ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kud amaran nak tarna ǝn Mǝššina as takkasaɣ kǝlǝsuf, daɣ adi Taɣmar ta n Mǝššina tos-iwan-du. ");
INSERT INTO ttq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Alǝs n ǝmǝqqerǝd otâban fǝl tǝzoli, ogâz ehan-net, wǝdi tǝla-net wǝr tat-in-ikka wala. ");
INSERT INTO ttq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mišan as t-id-ibag iyyan a t-ogaran assahat, orn-ay; a daɣ-as ibǝz tǝzoli-net ta fǝl iffǝlla, irkǝb daɣ-as tǝla-net, uzan-tat. ");
INSERT INTO ttq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wa dǝr-i wǝr nǝddew, azangaw-nin a imos; wa di-wǝr-nǝllil deɣ s ǝšidǝw, wǝdi ǝzǝwwǝziwǝz a itaggu.» ");
INSERT INTO ttq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«As igmad aggǝsuf awedan, ad irǝs aggǝsuf wen idaggan ǝqqurnen, igammay id imal, iqqim wǝr t-igrew, ad annu daɣ man-net: \"Nak a za, ad ǝqqǝlaɣ ehan-in wa d-ǝgmada.\" ");
INSERT INTO ttq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","As t-id-iqqal, a t-id-asu ifrâd, immotag. ");
INSERT INTO ttq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tǝzzar aglu idaw-du d ǝssa kǝlǝsuf wiyyad a t-ogarnen tallabǝst, ǝggǝzan awedan wanâd, ǝzdǝɣan-tu. Tagu taɣara n awedan wen aɣšud ogaran was kala tu-tǝga.» ");
INSERT INTO ttq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iššewal Ɣaysa den da as tǝdkal tǝntut iyyat ǝmǝsli-net, tǝnn-as: «Tǝbbilal tǝntut ta kay-terawat, ǝd fǝfan win tǝnkasaɣ.» ");
INSERT INTO ttq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mišan inn-as Ɣaysa: «Aytedan win ogarnen ǝbbǝlǝl da ǝssǝsamnen y awal ǝn Mǝššina, tamazalan awa inna.» ");
INSERT INTO ttq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","As inay Ɣaysa aytedan tiddawan fall-as, inn-asan: «Aytedan n azzaman win, inǝllubas; gammayan tǝlmǝɣjujat! Kala! Tǝlmǝɣjujat ta dasan-tǝtawaggat iyyadda ɣas, a tat-imosan ta n ǝnnǝbi Yunǝs. ");
INSERT INTO ttq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ǝmmǝk was kala ad iqqal Yunǝs alɣalamat y aytedan n ǝɣrǝm ǝn Ninif, ǝmmǝk en da as zʼǝqqǝla nak Ag Aggadǝm alɣalamat y aytedan n azzaman win. ");
INSERT INTO ttq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ǝzǝl wa n tabadday, a du-tǝnkǝr tǝmǝnokalt tas kala tǝxkam fall akal n agala igân esǝm Šeba, taggayyat fǝl aytedan n azzaman win, tǝzzǝbǝz-tan y ǝššǝriɣa fǝlas d ad iraz amaḍal a du-tǝgmad fǝl ad tǝssǝsǝm y awal ǝn tǝla n ǝgǝrri wa itaggu ǝmǝnokal Suliman. Ǝssǝnat za as, wa illan da ǝmǝrǝdda, ogar ǝnnǝbi Suliman mišan tugayam s a das-tǝssǝsǝmam. ");
INSERT INTO ttq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ǝzǝl wa n tabadday, ad d-ǝnkǝran aytedan n ǝɣrǝm wa n Ninif, ǝzzǝbǝzan aytedan n azzaman win y ǝššǝriɣa fǝlas tǝtubt a ǝgan ǝzǝl wa dasan-iga Yunǝs tǝlxutbat, imal-asan awal ǝn Mǝššina. Ǝssǝnat za as, wa illan da ǝmǝrǝdda, ogar Yunǝs mišan tugayam ǝs tǝtubt. ");
INSERT INTO ttq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wǝr t-illa awedan isarɣin fǝtǝla tǝzzar iɣbǝr-tat, madeɣ ag-et daw ǝɣǝzu, kalar ǝsǝwǝr a tat-itaggu edag ihhoken fǝl ad ǝnǝyan aytedan win du-taggaznen ehan s ǝnnur-net. ");
INSERT INTO ttq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Šat, šilat ǝn fǝtǝla a tǝmos i tǝɣǝssa-nak. As imos as šat-nak tǝhannay s ǝlluɣ, wǝdi taɣǝssa-nak ketnet tǝha ǝnnur; mišan as imos as šat-nak wǝr tǝhǝnnǝy s ǝlluɣ, wǝdi taɣǝssa-nak ketnet tǝha šiyyay. ");
INSERT INTO ttq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Daɣ adi agu ǝnnǝyat ǝd man-nak, ǝnnur wa kay ihan a tu-wǝr-alsinat šiyyay. ");
INSERT INTO ttq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amaran kud taɣǝssa-nak ketnet tǝha ǝnnur, wǝr tat-iha adag ihân šiyyay; wǝdi ad tǝmǝlǝwlǝw ketnet, zun tǝheɣ edag tǝsimalawlaw fǝtǝla.» ");
INSERT INTO ttq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iɣrad Ɣaysa awal ɣas igmay daɣ-as Farisay iyyan a ɣur-ǝs ammansaw. Os-in Ɣaysa ehan ǝn Farisay wen, iggaz edag wa daɣ ǝskaran mensewan, isaɣɣamar, ad itattu. ");
INSERT INTO ttq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Isammaklal ǝs Farisay en awas issǝnta Ɣaysa tettay wǝr iššorad ifassan-net awa tǝnna alɣadat-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tǝzzar inn-as Ǝmǝli Ɣaysa: «Kawanay Farisaytan, tǝzazdagam afalla n ǝsǝlkǝw d ǝɣǝzu, as iga awen, ammas ǝn wallan-nawan wǝr ǝdnayan ar tarkǝbt ǝd talbast. ");
INSERT INTO ttq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Aljahilan! Wǝrgeɣ wa d-igan afalla ǝn tǝɣǝssa, ǝnta a d-igan ammas-net da? ");
INSERT INTO ttq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Daɣ adi ǝkǝtat i tǝlaqqawen awa ihan ikassan-nawan, ǝddi arat kul a dawan-izdag. ");
INSERT INTO ttq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Iket alɣazab iqqâl-awan ya Farisaytan, fǝlas tǝhakkam awa imosan tǝmǝssǝdǝk-nawan daɣ ǝnniɣnaɣ d ǝzzǝnǝfan ǝn yelatan kul win fǝrgan, as iga awen, tǝtamazrayam ǝššǝriɣa ǝn Mǝššina ǝd tara-net, s ǝntanay ǝs kawan-iwar lǝkkum y-asan, da wǝr din-tǝglemam win hadatnen! ");
INSERT INTO ttq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Iket alɣazab iqqâl-awan kawanay Farisaytan, fǝlas tǝrâm tǝɣimit daɣ adag wa ilan almaqam daɣ nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, d a kawan-saslaman aytedan daɣ sammanayan. ");
INSERT INTO ttq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iket alɣazab iqqâl-awan, fǝlas tolâm ǝd zǝkwan wǝr nǝmmun, fǝl itijǝwǝnkit awedan wǝr issen, samadasan-tu.» ");
INSERT INTO ttq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Inna iyyan daɣ musanan n Ǝttawret i Ɣaysa: «Ǝššex, daɣ awa tǝnneɣ ǝddi, nakkanay da, tǝgeɣ-ana arak batu.» ");
INSERT INTO ttq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Inn-as Ɣaysa: «Iket alɣazab iqqâl-awan kawanay da, imusanan n Ǝttawret, fǝlas tǝsawaram aytedan ǝzuk as izzǝwat aggay-net; kawanay amaran wǝr tu-za-tǝdǝsam ǝs wala idǝdwan-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iket alɣazab iqqâl-awan fǝlas tǝkarrasam izǝkwan hossaynen y ǝnnǝbitan as imarawan-nawan a tan-ǝnɣanen. ");
INSERT INTO ttq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ǝmmǝk wǝdi as tǝggiyyem fǝl awa ǝgan, tǝrḍam sǝr-ǝs fǝlas ǝntanay za ǝnɣan-tan, kawanay amaran tǝkrasam izǝkwan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Awen daɣ a fǝl inna Mǝššina daɣ masnat-net wǝr nǝla tǝzǝrǝst: \"A sǝr-san zǝmmizǝlaɣ ǝnnǝbitan ǝd nǝmmuzal, ad agin iman ǝn wiyyad daɣ-san, zǝɣɣǝzzǝban win hadatnen.\" ");
INSERT INTO ttq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Adi as, aytedan n azzaman win, ǝhân-tan man n ǝnnǝbitan kul win tanwanɣanen, wa n ǝnǝtti n ǝddǝnet har azalada. ");
INSERT INTO ttq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Awalla, illikan as, aytedan n azzaman win, ǝhân-tan man n aytedan di kul, a d-ibazan ɣur man win Habila har win Zakarayya, wa ǝnɣan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, gǝr majmar wa zǝwwǝran n ǝsǝqqǝd ǝn tǝkutawen d adag wa zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Iket alɣazab iqqâl-awan ya imusanan n Ǝttawret, fǝlas tǝharam tarrayt ta tǝtawayat awedan ǝs masnat ǝn Mǝššina; kawanay iman-nawan wǝr-tat-tǝggezam, tǝgdalam deɣ iguz-net i win t-ǝranen.» ");
INSERT INTO ttq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","As ifal Ɣaysa ehan wen, ǝssintan musanan n Ǝttawret ǝd Farisaytan daɣ ǝddǝguz-net wǝllen, taggin-as isǝstanan aggotnen, ");
INSERT INTO ttq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","daɣ gammayan a tu-sassannin arat a tan-z-akfin tarrayt ǝs tǝxtǝst-net. ");
INSERT INTO ttq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","As itaggu awen tǝddew tamattay tǝknât igǝt fǝl Ɣaysa, har ǝqqiman aytedan tinǝmǝkukulan. Iššewal Ɣaysa, azzar ǝs nǝttulab-net, inn-asan: «Ǝnkǝdat i xamira wa n Farisaytan a t-imosan tǝlmǝnufǝqa. ");
INSERT INTO ttq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Arat kul wa iɣbaran ad itǝwǝsǝnǝfilǝl, amaran ǝssir kul ad affaggu. ");
INSERT INTO ttq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Daɣ adi, a tǝnnam daɣ šiyyay, ad itǝwǝslu ezal a mallan. A tǝsammataktakam deɣ daɣ ammas ǝn nan-nawan, ad attamal fǝl fallatan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kawanay imidawan-in, ǝnneɣ-awan: Ad wǝr tiksadam aggadǝm ǝs fǝrregat-net wǝr t-okay ikus ǝn man daɣ tǝɣǝssa. ");
INSERT INTO ttq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A dawan-ǝmǝlaɣ wa za tiksadam: Iksadat Mǝššina a inaqqin, ila deɣ tarna n a kawan-igǝr daɣ Jahannama. Awalla, ǝnneɣ-awan ǝnta en da as kawan-iwar a tu-tiksadam. ");
INSERT INTO ttq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wǝrgeɣ sǝmmos gǝḍad a din-nazzinen sanatat tǝfelen? Dǝr iga awen da za, wǝr tan-iha i din-itataw Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kawanay amaran wala anzadan ǝn ɣafawan-nawan da kul ǝddunan. Daɣ adi ad wǝr tiksadam wala, togaram igǝḍad aggotnen ǝlqimat. ");
INSERT INTO ttq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ǝnneɣ-awan, awedan kul wa iggǝyyen dat aytedan as nak Ag Aggadǝm a t-ilan, nak da, ad ǝggǝyyeɣ dat angalosan ǝn Mǝššina as nak a t-ilan. ");
INSERT INTO ttq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mišan wa di-inkuran dat aytedan, wǝdi nak da ad t-unkaraɣ dat angalosan ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Awedan deɣ wa di-ibyakan nak Ag Aggadǝm, ifrâg ad igrǝw tǝsureft; mišan awedan wa ikkasan tarna y Infas wa Zǝddigan, wǝdi wǝr zʼigrǝw tǝsureft. ");
INSERT INTO ttq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","As tǝmmewayam ǝs nan n ǝlɣibada win Kǝl-Ǝlyǝhud, madeɣ ǝs mǝnokalan madeɣ ǝs muzaran y ad tǝtǝwǝšrǝɣam; a kawan-wǝr-iššǝwǝš ǝmmǝk was za tǝkkǝsam iman-nawan, wala awa za tannim, ");
INSERT INTO ttq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Infas wa Zǝddigan a kawan-z-issusǝnan daɣ assaɣat tǝdi da awas inahagga a tu-tannim.» ");
INSERT INTO ttq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Inna-du awedan iyyan i Ɣaysa daɣ ammas ǝn tamattay: «Ǝššex, annu y ǝmaqqar-in a dǝr-i uzan tǝkasit-nana.» ");
INSERT INTO ttq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Inn-as Ɣaysa: «Alǝs, ma di-igan ǝlqali-nawan, wala tuzanaɣ-awan tǝkasit?» ");
INSERT INTO ttq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tǝzzar inna Ɣaysa i tamattay: «He kawanay! Agǝzat iman-nawan daɣ a imosan ǝwwǝli fǝlas kud iggǝrgas awedan, da tǝmǝddurt-net wǝr tǝqqen daɣ ǝrrǝzǝɣ-net.» ");
INSERT INTO ttq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tǝzzar ig-asan ǝlmital wa, inna: «Šiwǝgas n ǝmǝggergǝs iyyan a ǝganen igi olâɣan. ");
INSERT INTO ttq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ad isamadran gar-es ǝd man-net, igannu: \"Awak ma zʼagaɣ? Nak abʼas ǝleɣ edag a daɣ ǝgeɣ attaɣam-in.\" ");
INSERT INTO ttq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tǝzzar inna: \"Ǝssanaɣ awa zʼaga. Ad arzaɣ šidangawen-in, ǝkrǝsaɣ šin tanat-ogarnen, ǝššidǝwaɣ daɣ-asnat attaɣam-in kul d awa ǝleɣ.\" ");
INSERT INTO ttq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Amaran annaɣ i man-in: \"Ya mandam, tǝleɣ ǝrrǝzǝɣ aggen a dak-igân elan aggotnen, sanfu, tatša, tašwa, tannaflaya.\" ");
INSERT INTO ttq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mišan inn-as Mǝššina: \"Ameskel! Ahad a da a kay-z-ǝgmǝdan man-nak. Ma zʼigrǝwan awa tǝššedawaɣ? ");
INSERT INTO ttq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Awen daɣ a igarrawan awedan wa išadawan ǝddǝnet fǝl man-net amaran wǝr iššedaw wala daɣ talɣa ta gar-es ǝd Mǝššina.\"» ");
INSERT INTO ttq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dǝffǝr awen inna Ɣaysa i nǝttulab-net: «Awen da fǝl dawan-ǝnneɣ: A kawan-wǝr-tǝššǝwǝš tǝmǝddurt gǝr awa za tatšim, wala awa za talsim, ");
INSERT INTO ttq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","fǝlas iman-nawan ogaran imensewan almaqam, taɣǝssa-nawan deɣ togar isǝlsa almaqam. ");
INSERT INTO ttq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ǝnẓǝrat daɣ ǝɣrutan, wǝrmad nabbalan za wǝr tilǝyan, wǝrmad ǝlân isǝɣbar za wala šidangawen mišan issodar-tan Mǝššina. Tofâm-tan za s aggen. ");
INSERT INTO ttq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mǝni daɣ-wan wa ifragan s aššawaša-net ǝšitǝy ǝn tǝɣrǝst-net ǝs wala ellaf ǝn šat? ");
INSERT INTO ttq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dad zama as wǝr tǝfregam igi n a ogdân d awa tǝmmǝdrǝyt, ma fel as kawan iššǝwaš awa hadan? ");
INSERT INTO ttq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ǝnẓǝrat daɣ ǝmmǝk was du-daggalnat tǝjigawen: wǝrmad šaqqalnat wala zattinat isǝlsa, mišan ǝnneɣ-awan wala Ǝmǝnokal Suliman harkid tǝgǝrgist-net kul wǝr kala ad ewad wala iyyadda daɣ-asnat šihussay ǝn talassay. ");
INSERT INTO ttq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dad isalsu Mǝššina yel ǝs tǝmǝwit tǝdi, s azalada ibdâd, tufat ad itǝwǝsǝrɣu daɣ tǝjǝngǝrert; manǝmmǝk as kawan-wǝr-z-assalsu, kǝl ǝzǝgzan ǝndǝrran! ");
INSERT INTO ttq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Daɣ adi a kawan-wǝr-ǝdgǝzan medranan n awa za tatšim, wala awa za tašwim, wala deɣ iššǝwǝšan-kawan. ");
INSERT INTO ttq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","31","Aratan win di kul aytedan win wǝr nǝssen Mǝššina, a ozalnen daɣ agamay-nasan. Mišan kawanay, ǝdgǝzat daɣ agamay ǝn Taɣmar ta n Mǝššina. Aratan win di kul a kawan-tawakfin ǝntanay da, fǝlas Abba-nawan issân as tǝddiraram sǝr-san. ");
INSERT INTO ttq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tǝsǝgǝrt n ayfad-in a kamat-wǝr-tǝggǝz tasa, fǝlas Abba-nakmat igrâz-as wǝllen a kamat-akfu taɣmar-net. ");
INSERT INTO ttq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Zanzat-in awa tǝlam, tǝkǝtam-tu i tǝlaqqawen, tagim i man-nawan fartamanitan wǝr nǝtǝmǝndu, tǝššidǝwam daɣ jǝnnawan ǝrrǝzǝɣ wa wǝr nǝɣǝrrǝd, wǝr mad t-in-z-ihazan baydagan wala deɣ tǝɣšǝd-tu tamaday. ");
INSERT INTO ttq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Edag wa tǝggaz tǝgǝrgist-nawan, ǝnta a zʼǝggǝzan wallan-nawan.» ");
INSERT INTO ttq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ǝqqǝlat aytedan otâbnen, ǝs ǝrɣânat fǝtǝlaten-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Talim d eklan ǝqqâlnen y ad d-ifǝl mǝššissan takrǝst fǝl a sǝr-ǝs in-ǝbdǝdan da da ad d-izzǝkkat daɣ ǝmi n ahan. ");
INSERT INTO ttq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ǝbbilalan eklan win d-ogaz mǝššissan okâyan. Silakanaɣ-awan as, ad atǝb ǝnta iman-net, isǝɣɣimen, isǝmmǝnsǝw-tan. ");
INSERT INTO ttq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gǝr zʼiqqâl-du adawannay n ahad wala deɣ ammas n ahad, eklan win d-ogaz mǝššissan okâyan ǝbbilalan. ");
INSERT INTO ttq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wǝrgeɣ kawanay iman-nawan tǝssânam as, ǝnnâr issân mǝššis n aɣaywan amazay wa daɣ du-z-idǝl abaydag, akǝy isǝmmutǝg y a das-igdǝl terazay n ahan-net? ");
INSERT INTO ttq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sǝmmutǝgat za kawanay da, fǝlas nak Ag Aggadǝm ad d-asa daɣ assaɣat tas wǝr tordem a daɣ-as d-asa.» ");
INSERT INTO ttq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tǝzzar inn-as Butros: «Ǝmǝli, nakkanay ɣas a fǝl tǝgeɣ tangalt tǝdi, meɣ aytedan kul?» ");
INSERT INTO ttq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ijjǝwwab-as ǝmǝli Ɣaysa inn-as: «Ǝmaššaɣal wa iɣdalan ila deɣ ǝgǝrri ǝnta a isannafran mǝššis izzuzǝr-tu i maššaɣalan-net win hadatnen fǝl a tan-ihakku idǝgran-nasan daɣ sudar daɣ alwaq wa igmadan y awen. ");
INSERT INTO ttq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ibbilal ǝkli wen as d-iqqal mǝššis, ogaz-t-id iha ǝššǝɣǝl wa daq q-id-oyya den. ");
INSERT INTO ttq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ǝggǝyyeɣ ǝsilakanaɣ-awan as, ad t-izzuzǝr mǝššis i tǝla-net kul. ");
INSERT INTO ttq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mišan ǝnnar inna ǝkli wǝdi daɣ man-net: \"Mǝšši illolat-in,\" tǝzzar ad iggat imaššaɣalan ǝd tǝmaššaɣalen win hadatnen, itattu, issasu esmad har ammaswad, ");
INSERT INTO ttq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","akli wǝdi, ilkâm a t-id-iɣdǝr mǝššis daɣ ǝzǝl d amazay wǝr orda, tǝzzar ad t-iggât har t-iksǝn, ag-ay dad tawaggin aytedan win wǝr nǝɣdel. ");
INSERT INTO ttq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Amaran akli wa issanan awa ira mǝššis, iqqim wǝr t-iga madeɣ wǝr iga ǝnnǝyat n igi-net, a das-tǝwǝgginat tǝwit aggotnen. ");
INSERT INTO ttq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mišan akli wa wǝr nǝssen awa ira mǝššis, amaran iga arat ihoran d ǝwǝddǝb, a das-tǝwǝgginat tǝwit wǝr nǝggǝt. Awedan igrawan a aggen, a daɣ-as itǝwǝgmǝy a aggen. I itawasaɣlafan a aggen, a daɣ-as itǝwǝgmǝy a ogaran awa itawasaɣlaf.» ");
INSERT INTO ttq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Dǝffǝr awen inna Ɣaysa: «Oseɣ-du fǝl ad assarɣa temsay daɣ ǝddǝnet. Sidaranaɣ ad imos as tǝrɣâ. ");
INSERT INTO ttq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amaran ilkâm daɣ-i ǝtǝwǝsǝlmaɣ, s iket wǝr t-ǝgeɣ ǝknan-i man-in ǝddǝguz. ");
INSERT INTO ttq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tordâm as, assa a d-ǝgeɣ fǝl a d-awǝyaɣ alxer s ǝddǝnet? Kala kala, ǝnǝmǝzray a sǝr-ǝs d-ewaya. ");
INSERT INTO ttq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Id a ibazan ɣur ǝmǝrǝdda, sǝmmos aytedan n ahan iyyanda ad nǝmǝzrǝyan, ǝwaran karad aganna fǝl ǝššin, ǝššin deɣ ǝwǝran aganna fǝl karad. ");
INSERT INTO ttq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ad inǝmǝzrǝy alǝs ǝd barar-net, barar deɣ inǝmǝzrǝy d abba-net, tǝnǝmǝzrǝy tǝntut ǝd tabarart-net, tabarart deɣ tǝnǝmǝzrǝy d anna-net, tǝnǝmǝzrǝy tǝdaggalt ǝd tǝntut ǝn barar-net, tǝnǝmǝzrǝy deɣ tǝntut ǝd tǝdaggalt-net.» ");
INSERT INTO ttq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Inna Ɣaysa deɣ i tamattay: «Wǝrgeɣ as tǝnayam tagarak as du-tǝgmad daɣ ataram ad tannim ǝddi da: \"Akonak izay-du.\" Tǝzzar agu adi da. ");
INSERT INTO ttq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","As tǝnayam deɣ ǝhud as d-igar, ad tannim: \"Ad tagu tuksay.\" Tǝzzar agu adi da. ");
INSERT INTO ttq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ǝlmunafiqan, tǝssânam emel n alɣalamaten šin ǝganen fǝl amaḍal ǝd šin ǝganen daɣ jǝnnawan, mišan adis wǝr tǝgrem azzaman win fall-awan ǝganen da? ");
INSERT INTO ttq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mafel za wǝr tǝgrem kawanay iman-nawan awa oɣadan? ");
INSERT INTO ttq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Masalan as kay-iɣra awedan s adag n ǝššǝriɣa, tǝgmǝya tǝmǝwit ǝs tǝnamaknam daɣ tarrayt. As wǝr tǝgeɣ adi, a kay-ilwǝy har kay-issǝbdǝd dat ǝlqali. Ǝlqali amaran a kay-agu daɣ fassan ǝn soji wa kay-z-igǝran daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ǝsilakanaɣ-ak âs: Wǝr du-za-tǝgmǝda iket wǝr tǝrzema. Wala tamma iyyadda wǝr din-za-taqqam.» ");
INSERT INTO ttq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Harwada iššewal Ɣaysa as d-ǝnkaran aytedan ǝllanen den, ǝssoɣalan-as isalan ǝn meddan wiyyad ǝn Galilaya as isisaga ǝnaxkim Bilatǝs iman-nasan alwaq a daɣ taggin šikutawen daɣ Ahan wa Zǝwwǝran n Ǝlɣibada daɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Inn-asan Ɣaysa: «Awak tordâm as, Kǝl-Galilaya win di ogaran Kǝl-Galilaya kul win hadatnen tišit ǝn nǝsbakkadan fǝl as ǝgan arak tǝmattant tǝdi? ");
INSERT INTO ttq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ǝnneɣ-awan, kala! Amaran kawanay da, as wǝr tǝtubam, ad tǝhlǝkam ketnawan. ");
INSERT INTO ttq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma tǝnnam za s aytedan win maraw d ǝttam win fǝl ibarajjat suru was itawannu Silowam daɣ ǝɣrǝm ǝn Yerusalam, inɣ-en? Tordâm as, ogaran Kǝl-Yerusalam kul win hadatnen tišit ǝn nǝsbakkadan? ");
INSERT INTO ttq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ǝnneɣ-awan, kala! Amaran, kawanay da, as wǝr tǝtubam, ad tǝhlǝkam ketnawan.» ");
INSERT INTO ttq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ig-asan Ɣaysa tangalt iyyat, inn-asan: «Kala inbal alǝs iyyan ašǝk as itawannu fig daɣ afarag-net n alɣanab. As tǝga tamert n ara-net, os-ay-du y ad d-inkǝd aratan-net, mišan wǝr daɣ-as igrew wala. ");
INSERT INTO ttq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tǝzzar inna y amaššaɣal wa innǝttafan d afarag: \"Ǝnǝy! Ǝmǝrǝdda karad elan a ǝgeɣ tasa-du, gammaya-du aratan n ašǝk wa, mišan wǝr kala daɣ-as ǝgrawa wala. Daɣ adi ǝɣtǝs-t-in! Ma ikannu daɣ amaḍal wǝr t-idu-tǝgǝmmǝd tǝnfa.\" ");
INSERT INTO ttq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Inn-as amaššaɣal wen: \"Mǝšši, are daɣ-ak a tu-tayya tenewa da ɣas, ad ǝɣǝzaɣ amaḍal wa t-iɣlayan, ǝnɣǝla daɣ-as tamaqqost. ");
INSERT INTO ttq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iha mijas awatay wa d-izayan ad arǝw, as wǝr erew, tǝssǝɣtǝsaq-q-in.\"» ");
INSERT INTO ttq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ǝzǝl iyyan ǝn tǝsanfawt isasaɣru Ɣaysa daɣ ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tǝlla tǝntut iyyat den tǝlât maraw elan d ǝttam issirantat aggǝsuf, imos ǝruru-net tǝganzay, wǝr tǝfreg aqqad ǝn tabadday-net. ");
INSERT INTO ttq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","As tat-inay Ɣaysa, iɣr-et-du, tǝzzar inn-as: «Tantut, tǝwǝrna-nam tǝzzayaɣ daɣ-as!» ");
INSERT INTO ttq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Issǝwar-tat ifassan-net, toɣad tebadday-net alwaq wen da, ad tǝmmâl Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mišan iggaz alham ǝmuzar n ahan n ǝlɣibada wen fǝlas izzozay Ɣaysa awedan daɣ ǝzǝl ǝn tǝsanfawt, inna ǝmuzar en i tamattay: «Wǝrgeɣ sǝdis adan as immǝkkan a daɣ-san itǝwǝggu ǝššǝɣǝl? Asiwat-du daɣ-san tǝgmǝyam tǝmǝzzǝyt, wǝrgeɣ ǝzǝl wa n tǝsanfawt!» ");
INSERT INTO ttq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Inn-as Ɣaysa: «Ǝlmunafiqan, mǝni daɣ-wan wa wǝr nǝtǝkkǝs tewaɣnay y azgar-net madeɣ itrǝg ajad-net daɣ ǝzǝl wa n tǝsanfawt y a t-id-aššašǝw? ");
INSERT INTO ttq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tahayawt n ǝnnǝbi Ibrahim ta amaran, ikrâd Iblis a ilân maraw elan d ǝttam, adis wǝr immǝkkan ad tǝtǝwǝzuzǝy daɣ ǝzǝl ǝn tǝsanfawt?» ");
INSERT INTO ttq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","As inna Ɣaysa awen, tǝbaz tǝkarakit aytedan kul win nǝmmǝzray-net, aytedan sa hadan amaran, ketnasan sidawen-tan mazalan ǝknanen šihussay win itaggu. ");
INSERT INTO ttq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Inna Ɣaysa: «Ma dǝr tola Taɣmar ta n Mǝššina? Mas tat-z-ammattala? ");
INSERT INTO ttq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tolâ d amasa n annabat igân esǝm mutard, idkal awedan inbal-tu daɣ afarag-net, idwal, iqqal ašǝk, ad taggin gǝḍad šisǝllula daɣ zǝlan-net.» ");
INSERT INTO ttq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Inn-asan Ɣaysa deɣ: «Mas zʼammattala Taɣmar ta n Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tola ǝd xamira tǝrwây tǝntut ǝd karad annafaɣaten n agel n alkama har ikuf agel ketnet.» ");
INSERT INTO ttq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Igla Ɣaysa, illil iɣǝrman ǝd tǝɣarmaten, isassaɣru aytedan, idâg sa sǝr Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Inn-as awedan iyyan: «Ǝmǝli, awak aytedan wǝr nǝggǝt ɣas a zʼassafsu Mǝššina?» Tǝzzar inna Ɣaysa i tamattay: ");
INSERT INTO ttq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Imi ǝn Taɣmar ta n Mǝššina i kǝruzan, daɣ adi ballanat tǝgmǝyam d iguz-net. Ǝnneɣ-awan aytedan aggotnen a zʼǝgmǝynen d iguz-net, mišan a dasan-indǝr. ");
INSERT INTO ttq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","As ijwar mǝššis n aɣaywan iɣfal-in fǝl man-net tǝsǝhǝrt n ahan, kawanay tǝbdâdam dat-ǝs, ad tǝggǝzam šin ǝkukǝw, tǝgannim: \"Mandam, alǝm-anaɣ!\" Ann-awan: \"Wǝr kawan-ǝzdayaɣ za wǝr ǝssena da du-tǝfalam.\" ");
INSERT INTO ttq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Alwaq wǝdi a das-tannim: \"Wǝrgeɣ nǝdraw dǝr-ǝk tettay ǝd tassay, tǝsisaɣra deɣ daɣ ɣǝrman-nana?\" ");
INSERT INTO ttq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mišan a dawan-annu: \"Nak wǝr kawan-ǝzdayaɣ. Ketnawan imaggan ǝn talbast a tǝmosam, ugagat-i.\" ");
INSERT INTO ttq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","As tǝnayam Ibrahim d Isǝhaq ǝd Yaqub d ǝnnǝbitan kul ǝqqiman daɣ Taɣmar ta n Mǝššina, ǝnta kawanay iman-nawan tǝtawastaɣam daɣ-as, ad talim, ad tǝdaddam idǝdwan-nawan fǝl tǝmagraz. ");
INSERT INTO ttq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ad d-ǝgmǝdan aytedan dǝnnǝg d ataram ǝd tamasna d agala, tǝzzar nǝɣimin ǝdrǝwan imǝgura daɣ Taɣmar ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ǝnǝyat za! Aytedan win ǝhanen ǝlǝqqam ǝmǝrǝdda ad izaran, win azzarnen deɣ ǝmǝrǝdda ad ǝggǝzan ǝlǝqqam.» ");
INSERT INTO ttq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Alwaq wen da t-id-ǝhozan arat daɣ Farisaytan, ǝnnan-as: «Ǝgmǝd edag a, fǝlas ǝmǝnokal Herod ira igi ǝn man-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Inn-asan Ɣaysa: «Aglat tannin y awaqqas wa igan Herod: \"Takkasaɣ kǝlǝsuf daɣ aytedan, zuzǝyaɣ imiranan azalada ǝd tufat, amaran ǝzǝl wa n karad ad assanda ǝššǝɣǝl-in.\" ");
INSERT INTO ttq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dǝr iga awen da ya, ǝššil a imos ad agla daɣ ǝšikǝl-in, azalada ǝd tufat ǝd tufat ten, fǝlas wǝr immǝkkan ad iba ǝnnǝbi daɣ adag wǝr nǝmos Yerusalam.» ");
INSERT INTO ttq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Inna Ɣaysa: «Xa aytedan ǝn Yerusalam, iket tǝgam iman n ǝnnǝbitan, tǝnɣam deɣ ǝs tǝgur ǝn tǝhun win sǝr-wan d-izammazal Mǝššina! Awak har mǝnǝket taklaten, gammaya d a kawan-d-ǝššidǝwa s ǝmmǝk as du-tǝšadaw tǝkǝjit ikǝrǝtan-net daw ǝfrutan-net, mišan tugayam s awen! ");
INSERT INTO ttq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ǝnǝyat za, Mǝššina a daɣ-wan idkǝl ifassan-net, iqqǝl ahan-nawan ǝmǝjir. Amaran ǝnneɣ-awan, wǝr di-za-tǝlǝsam anay iket wǝr d-osa ǝzǝl wa daɣ za tannim: \"Wa d-osan s esǝm n Ǝmǝli, igrâw arraxmat.\"» ");
INSERT INTO ttq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ǝzǝl iyyan ǝn tǝsanfawt, iggaz Ɣaysa ehan n iyyan daɣ muzaran n Farisaytan fǝl a ɣur-ǝs atšu. Ǝgaran daɣ-as Farisaytan ǝllânen den šittawen. ");
INSERT INTO ttq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Illa alǝs iyyan den as ibǝyaɣat alam-net ketnet, iqqîm dat Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Issǝstan Ɣaysa imusanan n Ǝttawret ǝd Farisaytan, inn-asan: «Awak ǝzuzǝy n awedan daɣ ǝzǝl wa n tǝsanfawt xalâl, meɣ wǝr xalal?» ");
INSERT INTO ttq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mišan wǝr das-ǝnnen wala. Amaran idas Ɣaysa ǝmiran en, izzozay-tu, issǝgl-ay. ");
INSERT INTO ttq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tǝzzar inn-asan: «Mǝni daɣ-wan was zʼihannayan barar-net madeɣ azgar-net har iqqǝl daɣ anu ǝzǝl wa n tǝsanfawt, aqqam wǝr t-id-ikkes daɣ-as tamazayt tǝdi da?» ");
INSERT INTO ttq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wǝr ǝssenan a das-ǝnnan daɣ batuten šin iga da. ");
INSERT INTO ttq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Igr-in Ɣaysa ǝsǝnnǝfran wa ǝgan naftaɣan idaggan win taggazan aytedan win tawasaɣmarnen tǝzzar ig-asan ahol, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«As daɣ-ak igmay awedan izazlayan a das-in-tǝmǝgureɣ, ad wǝr tǝsǝnnǝfrǝnaɣ edag wa taggazan aytedan win tawasaɣmarnen fǝlas mijas igmây daɣ awedan iyyan a kay-ogaran almaqam a das-in-imǝgurǝt, ");
INSERT INTO ttq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tǝzzar as-ik-du mǝššis n ahan wa kawan-d-iɣran ǝs mǝgura-net, ann-ak: \"Ǝgmǝd edag y alǝs wa.\" Tǝbǝz-kay tǝkarakit, takkaɣ dǝffǝr aytedan taqqama. ");
INSERT INTO ttq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kalar as daɣ-ak itawagmay a din-tasaɣ imǝgura, takka dǝffǝr aytedan taqqama. Ǝddi, as d-osa mǝššis n ahan, a dak-annu: \"Ǝmidi-nin, zǝnkǝz-du s adag ofân wǝdi.\" Akf-ik adi ǝtǝwǝsǝɣmar ɣur naftaɣan kul win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fǝlas awedan kul wa idkalan iman-net, ad itǝwǝsǝrǝs, wa issǝrǝsan iman-net deɣ ad itǝwǝdkǝl.» ");
INSERT INTO ttq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dǝffǝr awen inna Ɣaysa i Farisay was innǝftaɣ: «As du-tǝɣarraɣ aytedan y a tan-taššatšaɣ ezal madeɣ ehad, a du-wǝr-taɣra imidawan-nak, wala imǝdrayan-nak wala išǝqqaɣan-nak wala imahharagan-nak ǝn mǝggǝrgas, fǝl a kay-du-wǝr-aɣrin ǝntanay da, ǝzǝl iyyan, ǝrzǝman-ak awa dasan-tǝgeɣ. ");
INSERT INTO ttq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kalar as iqqal as tǝšatšaɣ aytedan, šatšu šilǝqqawen ǝd nǝbdan ǝd mǝggudal ǝd mǝddǝrɣal. ");
INSERT INTO ttq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tǝbbilalaɣ as tǝgeɣ adi, fǝlas ǝntanay wǝr ǝfregan a dak-ǝrzaman. Ǝrruzmatan-nak a tan-tǝgrǝwa ǝzǝl wa n tanakra n alɣadilan.» ");
INSERT INTO ttq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","As isla iyyan daɣ naftaɣan i batu ten, inna i Ɣaysa: «Ibbilal awedan wa zʼatšin daɣ mǝgura win zʼaginen daɣ Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Inn-as Ɣaysa: «Alǝs iyyan a itaggan imǝgura zawwarnen, igmay daɣ aytedan aggotnen a t-id-asin. ");
INSERT INTO ttq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","As d-ǝmmǝgnen mensewan, izammazal akli-net y ad annu i naftaɣan: \"Asiwat-du, imensewan ǝmǝrǝdda ǝmmotagan.\"» ");
INSERT INTO ttq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Mišan ǝggazan-tu ketnasan s iyyan iyyan ǝd sur. Inn-as wa azzaran: \"Sǝket ǝzzǝnza tawagost, kundaba oseq-qat ǝnǝyaq-qat. A di-wǝr-tǝššǝkaɣ.\" ");
INSERT INTO ttq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Inn-as-du iyyan: \"Sǝket d-ǝzzanza maraw zǝgran y agayak, amaran areɣ a tan-ǝrǝma. A di-wǝr-tǝššǝka.\" ");
INSERT INTO ttq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Inn-as-du iyyan: \"Sǝket ǝzlafa, daɣ adi wǝr ǝfrega a kay-in-asaɣ.\"» ");
INSERT INTO ttq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«As d-iqqal ǝkli, iga i mǝššis isalan kul win den. Iggaz alham labasan mǝššis n aɣaywan, amaran inn-as: \"Aglu tarmad, tilalaɣ aɣrǝm, tidawa-du ǝd tǝlǝqqawen ǝd nǝbdan ǝd mǝddǝrɣal ǝd mǝggudal.\"» ");
INSERT INTO ttq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«As d-iqqal ǝkli, inna i mǝššis: \"Mǝšši, ǝgeɣ awa di-tǝnneɣ, mišan ehan harwa da ih-ay adag.\" ");
INSERT INTO ttq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Inn-as mǝššis: \"Ǝgmǝd aɣrǝm, tilalaɣ ǝd tarrayen ǝd tamawen ǝn fǝrgan, tǝšǝhhǝššǝlaɣ aytedan a d-asin fǝl ad idnǝy ahan-in. ");
INSERT INTO ttq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Illikan as aytedan win as ǝzzara ǝgmaya daɣ-san a di-d-asin, wǝr tan-iha i zʼirǝman imensewan-in.\"» ");
INSERT INTO ttq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Imalallay-in Ɣaysa tamattay tǝknat igǝt ta dǝr-ǝs tǝddewat, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Awedan wa iran a di-ilkǝm, ǝnta wǝr di-iga tara togarat ta iga y abba-net, d anna-net ǝd tǝntut-net ǝd bararan-net ǝd mǝdrayan-net ǝd tǝmǝdrayen-net d ǝnta iman-net, wǝdi wǝr ifreg ad iqqǝl anattalib-in. ");
INSERT INTO ttq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","I wǝr nǝger iri y ad idkǝl tǝgǝttawt-net, agu imateran-net ilkǝm-i, wǝdi wǝr ifreg ad iqqǝl ǝnalkim-in. ");
INSERT INTO ttq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Id nǝnna masalan ad ira iyyan daɣ-wan ad ikrǝs ehan imosan suru. Wǝrgeɣ tǝɣimit a itaggu, ixsǝb awa t-ikrasan tǝzzar, issǝn kud ila azrǝf a t-issindan wala? ");
INSERT INTO ttq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","As wǝr iga awen, as t-issǝnta akaras har t-orna ǝsǝndi-net, a daɣ-as agin aytedan kul win t-ǝnaynen tamakkakkayt, ");
INSERT INTO ttq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","annin: \"Awedan wa, issǝnta akaras n ahan, orn-ay ad t-isǝkkǝsǝw.\" ");
INSERT INTO ttq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Madeɣ nǝnna masalan, ǝmǝnokal iyyan as inkar ǝmǝgǝr gar-es d iyyan. Wǝrgeɣ tǝɣimit a zʼagu tǝzzar, isǝmmǝdrǝn, issǝn kud ǝnta wa ilan maraw ǝgim n alǝs, ifrâg terazay n ǝmǝnokal wa hadan ilân ǝnta sanatat tǝmǝrwen n ǝgim n alǝs? ");
INSERT INTO ttq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","As inay as wǝr t-ifreg, harwa da iggug ǝmǝnokal wa hadan as tu-z-issuku inǝmmuzal, igmǝy daɣ-as alxer. ");
INSERT INTO ttq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kawanay da za ǝmmǝk di da, i daɣ-wan wǝr nǝmmǝzzay d awa ila kul, wǝr ifreg ad iqqǝl anattalib-in. ");
INSERT INTO ttq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tesǝmt arat olâɣan a tǝmos, mišan as tat-tǝgmǝd tembay-net, mǝni tǝmǝwit tas tat-za-tǝtǝwǝsuɣǝl? ");
INSERT INTO ttq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ab-as tat-tǝha tǝnfa waliyyat y amaḍal wala deɣ tah-et tǝnfa i tamaqqost. Tanaɣla ɣas a din-za-tǝtǝwǝggu. Wa isallin, aslet!» ");
INSERT INTO ttq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Osan-du nabazan n amana ǝd nasbakkadan kul Ɣaysa y a das-ǝssǝsǝman. ");
INSERT INTO ttq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ǝggazan Farisaytan ǝd musanan n Ǝttawret šin ǝgǝtǝntǝn, gannin ǝs Ɣaysa: «Awedan wa iqbâl inasbakkadan, idarraw deɣ dǝr-san imensewan.» ");
INSERT INTO ttq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tǝzzar ig-asan Ɣaysa ǝlmital wa, inna: ");
INSERT INTO ttq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«As ila iyyan daɣ-wan temeday ǝn tilay har daɣ-asnat tǝssǝggal iyyadda, awak wǝrgeɣ ad ayyu tazayat tǝmǝrwen ǝd tazayat šin hadatnen ǝdânnat, tǝzzar azǝl iswǝd i ta tǝssǝggalat har tat-d-igrǝw? ");
INSERT INTO ttq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","As tat-d-igraw, a tat-issǝwǝr izeran-net fǝl awa iga daɣ tǝdǝwit, ");
INSERT INTO ttq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","as d-iqqal aɣaywan a d-aɣru imidawan-net ǝd mahharagan-net, ann-asan: \"Ayewat, tagim tǝdǝwit ta ǝgeɣ, fǝlas agaraw a d-ǝgeɣ tilay-nin ta tǝssǝggalat.\" ");
INSERT INTO ttq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ǝnneɣ-awan zund ǝmmǝk di daɣ as, tǝfalawist ta zʼagin win ǝhanen ijǝnnawan fǝl tǝtubt n anasbakkad iyyanda, togar ta tan-za-tǝsǝssugu tazayat tǝmǝrwen n alɣadil ǝd taza as ɣur iga as wǝr ǝddǝraran ǝs tǝtubt.» ");
INSERT INTO ttq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Madeɣ nǝnna masalan, tǝntut iyyat a tǝlat marawat tammaten n ǝzrǝf har daɣ-as aba iyyat. Wǝrgeɣ ad tassarɣu fǝtǝla, tǝfrǝd ehan-net ketnet, tǝswǝd-as s ǝlluɣ iket wǝr tat-tǝgrew? ");
INSERT INTO ttq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","As tat-tǝgraw, a du-taɣru šimidawen-net ǝd tamahharagen-net, tann-asnat: \"Agimat tǝdǝwit ta ǝgeɣ, fǝlas agaraw a d-ǝgeɣ tamma-nin ta daɣ-i aba.\" ");
INSERT INTO ttq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ǝnneɣ-awan zund ǝmmǝk di daɣ as, tǝtubt n anasbakkad iyyanda tǝsifǝliwis angalosan ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Inn-asan Ɣaysa deɣ: «Alǝs iyyan a ilan ǝššin bararan. ");
INSERT INTO ttq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","As ǝzǝl iyyan inna wa mǝdrǝyan y abba-net: \"Abba, akf-i adagar-in daɣ tǝkasit.\" Izun-asan abba-nasan tǝla-net. ");
INSERT INTO ttq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Arat n adan dǝffǝr awen, inkar barar wa ǝndarran iššedaw awa ila kul, ikka akal iyyan iggugan. Ilkam i tara ǝn man-net, ad iɣaššad awa ila. ");
INSERT INTO ttq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","As inɣa awa ila kul, osa-du laz labasan akal wa iha, tǝzzar iggaz šin tǝmaɣatirt. ");
INSERT INTO ttq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Igla, išɣal y awedan iyyan n akal en da. Issok-ay šiwǝgas-net y a das-idǝn daɣ-asnat iladayan-net. ");
INSERT INTO ttq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Awa das-iga laz daɣ iguz, isidaran tettay ǝn šǝtša win tattin ladayan, mišan wǝr t-illa i das-tan-ikfân. ");
INSERT INTO ttq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amaran isammadran daɣ man-net, inna: \"Awak wǝrgeɣ imaššaɣalan n abba-nin ǝggǝtan mišan ketnasan ǝlân a ǝtšan har t-id-ǝglǝzan, ǝnta nak inaqq-i laz da! ");
INSERT INTO ttq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ad ǝnkǝraɣ, ǝqqǝla abba-nin, annaɣ-as: 'Abba, ǝmmizrayaɣ Mǝššina, kay deɣ ǝbbodaraq-qay, ");
INSERT INTO ttq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ab-as ǝhora d a di-itǝwǝnnu barar-nak, ag-i iyyan daɣ maššaɣalan-nak.'\" ");
INSERT INTO ttq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tǝzzar inkar iqqal abba-net. Izây-in ehan daɣ igǝg as t-ogga abba-net, tǝggaz-tu tǝhanint-net, ozal sǝr-ǝs, izalammat-tu, a das-itamallat. ");
INSERT INTO ttq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tǝzzar inna barar y abba-net: \"Abba, ǝmmizrayaɣ Mǝššina, kay deɣ ǝbboraq-qay, ab-as ǝhora d a di-itǝwǝnnu barar-nak.\" ");
INSERT INTO ttq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mišan inna abba-net y eklan-net: \"Tarmâd awǝyat-du takatkat ta tǝhossayat, tǝzzǝzlǝgam-as-tat, tagim tǝsǝndǝrt daɣ adad-net, tǝssǝsǝlam-tu. ");
INSERT INTO ttq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tabǝzam-du ǝhǝri wa iddǝren, tǝgzǝmam-tu, ad natšu, nagu saksas, ");
INSERT INTO ttq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","fǝlas barar-in wa, šilat n as t-aba, amaran ǝmǝrǝdda idar-du; kala ixrak, amaran ǝmǝrǝdda igraw-du.\" Amaran ǝssǝntan daɣ saksas. ");
INSERT INTO ttq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","As itaggu awen, barar-net wa n aɣafadday iha šiwǝgas. As d-iqqal, ihoz-du aɣaywan, isla i sǝwat d aweɣ. ");
INSERT INTO ttq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iɣra-du iyyan daɣ eklan-nasan, issǝstan-tu d awa itaggan den? ");
INSERT INTO ttq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Inn-as ǝkli: \"Amadray-nak a d-iqqalan, igzam abba-nak ǝhǝri wa iddǝren, fǝlas tewaɣlay a t-id-iga barar-net wǝr ila malad.\" ");
INSERT INTO ttq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iggaz-tu alham, ugay s iguz n ahan. Iqqab-du abba-net ad t-itansay. ");
INSERT INTO ttq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Eges inna y abba-net: \"Wǝrgeɣ a ilan elan ǝšɣâlaɣ-ak, wǝr kala ǝmmǝzrayaɣ tǝnna-nak, harkid awen, wǝr kala di-tǝkfeɣ wala ɣas eɣayd ǝgzama aga fall-as saksas nak ǝd midawan-in. ");
INSERT INTO ttq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Rurek amaran wa iɣšadan eharay-nak daɣ tǝkarwaten ǝnta, osa-du ɣas tǝgazamaɣ-as ǝhǝri wa iddǝren.\" ");
INSERT INTO ttq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Inn-as abba-net: \"Barar-in, kay fawda tǝlleɣ ɣur-i, awa ǝleɣ ketnet i-nak. ");
INSERT INTO ttq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mišan immikkan ad naddawat nagu saksas, fǝlas amadray-nak, šilat n as t-aba, amaran ǝmǝrǝdda idar-du; kala ixrak, amaran ǝmǝrǝdda igraw-du.\"» ");
INSERT INTO ttq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Inna Ɣaysa i nǝttulab-net: «Kala a t-illa alǝs iyyan n ǝmǝggergǝs ilân amaššaɣal isinattaf d ǝrrǝzǝɣ-net, amaran itawann-as iɣaššat-tu. ");
INSERT INTO ttq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tǝzzar isassaɣr-ay-du, inn-as: \"Ma imos awa fall-ak sallaɣ? Ǝmǝl-i awa tǝgeɣ y ǝrrǝzǝɣ-in, nak ab-as areɣ ǝššǝɣǝl-nak.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Inna amaššaɣal wa gar-es ǝd man-net: \"Awak ǝmǝrǝdda ma zʼaga as di-ikkas amuzar-in daɣ ǝššǝɣǝl? Nak, wǝr ǝfregaɣ agayak, mansay deɣ isikarakad-i. ");
INSERT INTO ttq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ǝssânaɣ awa zʼaga as kud tawakkasa daɣ ǝššǝɣǝl-in da, a di-ǝqbǝlan aytedan daɣ nan-nasan.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tǝzzar isassaɣra-du aytedan win irwas alǝs was išɣal s iyyan iyyan. Inna i wa azzaran: \"Ma kay irwas ǝmuzar-in?\" ");
INSERT INTO ttq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Inn-as: \"Temeday ǝn tanaw ǝn wǝdi wa n azzayt.\" Inn-as amaššaɣal: \"Ɣam, tǝdkǝla širawt-nak ta n ǝmarwas, tǝktǝbaɣ fall-as tarmâd sǝmmosat tǝmǝrwen ǝn tanaw.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dǝffǝr awen inna y iyyan: \"Kay za ma tǝtawarwasaɣ?\" Inn-as: \"Temeday ǝn bǝhu n alkama.\" Inn-as: \"Ǝdkǝl širawt-nak ta n ǝmarwas, tǝktǝbaɣ fall-as ǝttamat tǝmǝrwen.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tǝmǝrkest ten, isl-et alǝs wa iššǝšɣalan ark amaššaɣal wen, tǝzzar ad t-immâl fǝl tǝla-net tayttay. Tidǝt a imos as aytedan win wǝr nǝksud Mǝššina, ogaran win t-ǝksudnen tǝla ǝn tayttay daɣ taɣawšiwen šin ǝllanen gar-essan. ");
INSERT INTO ttq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nak za ǝnneɣ-awan: Agiwat imidawan s ǝrrǝzǝɣan ǝn bannan win n ǝddǝnet ta; ǝddi as kawan-ǝgmadan, ad tǝtǝwǝqbalam daɣ adag ǝn tǝmǝxsurt iɣlâlan. ");
INSERT INTO ttq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Awedan wa tǝha tǝflǝst daɣ arat ǝndǝrran, wa zǝwwǝran da tǝh-ay daɣ-as. Wa wǝr tǝha tǝflǝst daɣ a ǝndǝrran, wa zǝwwǝran da, wǝr daɣ-as tu-tǝha. ");
INSERT INTO ttq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Daɣ adi, da kawan-wǝr-tǝha tǝflǝst daɣ ǝrrǝzǝɣ ǝn bannan wa n ǝddǝnet ta, ma kawan-z-izǝzzigǝzan ǝrrǝzǝɣ wa n tidǝt, wa ihan alaxirat. ");
INSERT INTO ttq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amaran kud wǝr kawan-tǝha tǝflǝst daɣ arat wa wǝr tǝlem, ma kawan-z-akfin arat wa tǝlam daɣ alaxirat? ");
INSERT INTO ttq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wǝr t-illa amaššaɣal ifrâgan ad išɣǝl y ǝššin muzaran. Wa ɣas ikyad iyyan, iru wa hadan; madeɣ abbardag y iyyan, alku wa hadan. Wǝr tǝfregam ad tǝɣbǝdam Mǝššina, taglim deɣ tozâlam dǝffǝr ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ǝssisaman Farisaytan y awa inna Ɣaysa den kul, taggin daɣ-as tamakkakkayt fǝlas imaran n ǝzrǝf a ǝmosan. ");
INSERT INTO ttq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Inn-asan Ɣaysa: «Kawanay tǝsaknim dat aytedan as alɣadilan a tǝmosam, Mǝššina amaran issân awa ihan iwallan-nawan; fǝlas arat wa ǝzzǝzwaran aytedan, Mǝššina ǝnta tagǝlfat a t-iga.» ");
INSERT INTO ttq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Ǝttawret d Ǝlkǝttaban win Ǝnnǝbitan ǝntanay ɣas a tawasasaɣrinen har ǝzǝl wa d-osa Yaxya wa isalmaɣan aytedan daɣ aman. Ǝddi amaran ad ǝggazan salan win Ǝlinjil šin ǝtǝwǝgga, ǝmosnen isalan n assa ǝn Taɣmar ta n Mǝššina, amaran ad igammay awedan kul iguz-net s assahat ǝd tallabǝst. ");
INSERT INTO ttq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dǝr iga awen da za, ogar tǝrɣasay ta iga ad iba ijǝnnawan d amaḍal, ta iga ad iba wala ɣas ǝsakkal iyyanda n Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Adi a fǝlas, alǝs kul wa izammazzayan tantut-net, izlaf iyyat, wǝdi iga ǝzzǝna. Alǝs deɣ wa izlafan tantut tǝmmizzayat, ǝnta da igâ ǝzzǝna.» ");
INSERT INTO ttq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Inn-asan Ɣaysa deɣ: «Kala ad t-illa alǝs iyyan n ǝmǝggergǝs n amayyawan ǝs faw izlâg isǝlsa win hossaynen, ǝzzǝwatnen, faw deɣ inniflay issiksas. ");
INSERT INTO ttq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","As itaggu awen, dat ǝmi n ahan-net, isrâd alǝs iyyan ǝn tǝlaqqay igân Lazarǝs, ǝs ǝlsânat šiqqas elam-net. ");
INSERT INTO ttq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Isidaran tettay ǝn kǝrǝmraman win du-rattaknen daɣ mensewan n ǝmǝggergǝs en. Wala iḍan, tasin-t-idu tallaɣan šiqqas-net. ");
INSERT INTO ttq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Har ǝzǝl wad aba talǝqqay ten, tǝzzar ewayan-tu angalosan s ǝnnǝbi Ibrahim daɣ aljannat. Ǝmǝggergǝs ǝnta da, aba-tu itawanbal-in. ");
INSERT INTO ttq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iha Jahannama, itaɣazzab daɣ-as as idkal asawad-net, ogga Ibrahim daɣ igǝg, illâ ɣur-ǝs Lazarǝs. ");
INSERT INTO ttq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ad iɣarru Ibrahim, igann-as: \"Ya Abba Ibrahim, hǝnǝttǝt-i, tǝzǝmmizǝla-du sǝr-i Lazarǝs y ad issǝlmǝɣ kuddeɣ imi n adad-net daɣ aman, issǝsmǝd-i sǝr-ǝs ilǝs-in, fǝlas alɣazab a tagga daɣ tǝmsay ta.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mišan inn-as Ibrahim: \"Barar-in, Akta-du as kay tǝgrâwaɣ arat kul wa tareɣ daɣ tǝmǝddurt-nak, as iga awen, Lazarǝs ǝnta wǝr inay ar alɣazab. Amaran ǝmǝrǝdda ǝnta as tawaknan man, kay tǝtaɣazzaba. ");
INSERT INTO ttq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wa dǝffǝr adi as, illâ ǝɣǝɣi wǝr nǝla eder gar-ena dǝr-wan, fǝl ad wǝr iru waliyyan daɣ-na a kawan-in-akku, ifrǝg adi, wala deɣ ifrǝg waliyyan daɣ-wan a dana-d-akku.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Inna ǝmǝggergǝs: \"Daɣ adi Abba, ǝgmâya daɣ-ak ad tǝzǝmmizǝla Lazarǝs s aɣaywan n abba-nin, ");
INSERT INTO ttq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","fǝlas ǝleɣ sǝmmos mǝdrayan, y a dasan-irɣǝm fǝl a du-wǝr-ǝggǝzan ǝntanay da edag n alɣazab wa.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mišan inn-as Ibrahim: \"Imǝdrayan-nak ǝttâfan ǝlkǝttab wa n Ǝttawret d Ǝlkǝttaban n ǝnnǝbitan win hadatnen, ǝlkǝmanet-asan.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inna y Ibrahim: \"Kala kala Abba-nin Ibrahim, adi wǝr igda, mišan as tan-in-iqqal awedan a d-inkâran daɣ nǝmmǝttan, ad utaban.\" ");
INSERT INTO ttq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mišan inn-as ǝnnǝbi Ibrahim: \"As wǝr ǝssǝsǝman y ǝnnǝbi Musa d ǝnnǝbitan win hadatnen, wǝr zʼutaban kuddeɣ ig-asan awedan a d-inkâran daɣ nǝmmǝttan isalan.\"» ");
INSERT INTO ttq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ǝzǝl iyyan inna Ɣaysa i nǝttulab-net: «Wǝr t-illa a tu-wǝr-ǝmelan aratan as za sǝssuginen aytedan ibakkadan, mišan iket alɣazab ill-ay y awedan wa dasan-d-igan ǝssǝbab. ");
INSERT INTO ttq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A das-afu ad itǝwǝqqǝn ǝzǝzǝd zǝwwǝran ǝn tǝhunt daɣ iri-net itǝwǝgǝr-in daɣ agarew, tišit n ǝssǝbab n abakkad i wala iyyanda daɣ aytedan win madrornen di. ");
INSERT INTO ttq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Agat ǝnnǝyat ǝd man-nawan! As kay-idlam amadray-nak, tǝrɣǝmaɣ-as. Kud immǝgraz, tǝssurǝfaɣ-as. ");
INSERT INTO ttq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kud imos as ig-ak ǝssayat tadlamen daɣ ǝzǝl, ig-ak-du ǝssa assatan igammay tǝsureft daɣ ǝzǝl wen da, da surǝf-as.» ");
INSERT INTO ttq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ǝnnan nǝmmuzal y Ǝmǝli Ɣaysa: «Šitu ǝzǝgzan-nana.» ");
INSERT INTO ttq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Inn-asan Ǝmǝli Ɣaysa: «As tǝlam ǝzǝgzan ogdân ǝd wala imi ǝn tǝzuɣay n ǝšǝnnan ad tǝfrǝgam ad tannim y ašǝk wa: \"Ǝlbǝy-du iman-nak, taɣta daɣ agaraw en\", agu awa tǝnnam.» ");
INSERT INTO ttq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Mǝni daɣ-wan wa du-z-adǝw akli-net iddânan madeɣ igayyakan, ann-as: \"Ayo tarmad tammansawaɣ!\" ");
INSERT INTO ttq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wǝrgeɣ tǝnna a das-za-tagim: \"Saŋŋ-i a ǝtšeɣ tǝzzar, tawǝyaɣ-i-t-id, tǝšɣǝla har atša, ašwaɣ, dǝffǝr adi amaran tatša tašwa kay.\" ");
INSERT INTO ttq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Awak alǝs en ad iggudǝy y ǝkli-net fǝlas iga awas t-omar? ");
INSERT INTO ttq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kawanay da za, as tǝgam arat kul was tǝtawamaram, tannim: \"Nakkanay wǝr nǝmos ar eklan, wǝr nǝga ar awas danaɣ-iwar igi-net.\"» ");
INSERT INTO ttq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ɣur iki ǝn Ɣaysa Yerusalam, illam gǝr akal wa n Samarǝya ǝd wa n Galilaya. ");
INSERT INTO ttq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","As d-iggaz taɣrǝmt iyyat, ǝssǝlkǝdan-as-du maraw meddan igrâw kǝtru, ǝbdadan-as-in daɣ igǝg. ");
INSERT INTO ttq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ǝdkalan imaslan-nasan, ǝnnan-as: «Ya Ɣaysa, Ǝššex-nana, hǝnǝttǝt-ana!» ");
INSERT INTO ttq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iswad daɣ-san, inn-asan: «Aglat saknat iman-nawan i limaman.» Ǝglân ǝkkân ilimaman y a dasan-ǝmǝlan, as ǝzzayan zaddogan. ");
INSERT INTO ttq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","As din-igra iyyan daɣ-san tǝmǝzzǝyt ta iga den, iqqal Ɣaysa, idkâl ǝmǝsli-net, immâl Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","As t-in-osa issǝjad dat-ǝs, a das-itigudǝy. Alǝs en in akal ǝn Samarǝya. ");
INSERT INTO ttq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Inna Ɣaysa: «Wǝrgeɣ marawessan as ǝzzayan, zaddogan, ma ǝgan taza win hadatnen? ");
INSERT INTO ttq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Adis wǝr tan-iha i d-iqqâlan iggudǝy i Mǝššina ar ǝnaftaɣ wa?» ");
INSERT INTO ttq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Amaran inna Ɣaysa y alǝs wen: «Ǝbdǝd, aglu, ǝzǝgzan-nak a kay-iɣlasan.» ");
INSERT INTO ttq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɣaysa, as t-ǝssǝstanan Farisaytan d alwaq wa du-za-tasu Taɣmar ta n Mǝššina, inn-asan: «Taɣmar ta n Mǝššina wǝr du-tǝtǝggu assa ilân anay. ");
INSERT INTO ttq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wǝr mad zʼitǝwǝnnu: \"Ǝnta da\", wala \"Ǝnta den\". Ǝssǝnat as, Taɣmar ta n Mǝššina tǝlla gar-ewwan.» ");
INSERT INTO ttq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dǝffǝr awen inna Ɣaysa i nǝttulab-net: «Ǝlkâman adan a daɣ za tǝsǝddirǝnam anay ǝn tawaɣlay-nin nak Ag Aggadǝm, kuddeɣ anay n ǝzǝl iyyanda, mišan wǝr di-za-tǝnǝyam. ");
INSERT INTO ttq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Amaran a dawan-itǝwǝnnu: \"Ǝnta den\" madeɣ \"Ǝnta da\". Ad wǝr taglim, wala tǝlkǝmam y awen. ");
INSERT INTO ttq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ǝbǝlǝzlǝz a itaggu essam daɣ jǝnnawan, isǝmmǝlǝwlǝw tama n amaḍal ta har ta, a dǝr zʼalu assa-nin nak Ag Aggadǝm daɣ ǝzǝl-in. ");
INSERT INTO ttq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mišan dat adi, ilzâm-i nak Ag Aggadǝm anay n alɣazab aggen, unkaran-i deɣ aytedan n azzaman win. ");
INSERT INTO ttq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Awa igan daɣ azzaman n ǝnnǝbi Nux, a zʼagin daɣ adan win daɣ du-z-asa nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Azzaman win den, aytedan tattin, sassin, zallafan, zâzlafan har ǝzǝl wa d-iggaz Nux aɣlal n aman, tǝzzar osa-du alwabil, ihlak-kan ketnasan. ");
INSERT INTO ttq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Zun d awen da deɣ a igan daɣ azzaman ǝn Lot. Aytedan tattin, sassin, zanzan, satagan, nabbalan, gayyakan, karrasan, ");
INSERT INTO ttq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","har ǝzǝl wad igmad Lot aɣrǝm ǝn Sǝdom, tǝzzar issofay-du Mǝššina fǝl ǝɣrǝm en adaɣas-ǝn-tahart ibilaglagan, ihlak aytedan-net ketnasan. ");
INSERT INTO ttq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Zun d adi da a zʼagin ǝzǝl wa du-za-tǝwǝsǝnǝfilǝla nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ǝzǝl wǝdi, awedan wa iqqiman daɣ adag wa n afalla n ahan-net, amaran ǝhân lalan-net ehan-net, a du-wǝr-azzabbat y a tan-in-idkǝl. Wa ihan tawagost-net deɣ, ad wǝr iqqǝl aɣaywan. ");
INSERT INTO ttq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aktiwat-du awa igrawan taɣur Lot. ");
INSERT INTO ttq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Id awedan wa wǝr nǝgǝmmǝy ar aggaz ǝn man-net daɣ ǝddǝnet ta, ad affatu daɣ alaxirat; mišan wa isaffatan iman-net daɣ ǝddǝnet ta, ad iɣlǝs. ");
INSERT INTO ttq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ǝnneɣ-awan ahad wǝdi, ad ǝnsân ǝššin aytedan daɣ tessat iyyadda, ammadkal iyyan, itǝwǝyyad-du wa hadan. ");
INSERT INTO ttq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ad taddinat sanatat tǝdoden daɣ adag iyyanda, tammadkal iyyat, tǝtǝwǝyyad-du ta hadat. ");
INSERT INTO ttq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ad ǝhân ǝššin meddan tawagost iyyadda, ammadkal iyyan, itǝwǝyyad-du wa hadan.» ");
INSERT INTO ttq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ǝssǝstǝnan nǝttulab Ɣaysa ǝnnan-as: «Ǝmǝli, wǝdi arat mǝnid zʼagu?» Inn-asan: «Edag tǝggaz tǝmaxsayt, a daɣ-as iddawan jadaran.» ");
INSERT INTO ttq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iga Ɣaysa i nǝttulab-net ǝlmital iyyan a daɣ ira a tan-issusǝn as, ihor ad tansayan Mǝššina faw, a daɣ-as wǝr ǝkkǝsan attama. ");
INSERT INTO ttq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Inn-asan: «Aɣrǝm iyyan a iha ǝmašraɣ wǝr nǝksud Mǝššina, wǝr issǝɣmar deɣ awedan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amaran aɣrǝm en, tǝh-ay tǝntut as wǝr idder alǝs-net a du-tǝtasit amašraɣ en, tǝgann-as: \"Akf-i alxaq-in daɣ amakkarad-in.\" ");
INSERT INTO ttq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","As iga tamert itugǝy-as, inna gar-es ǝd man-net: \"Kud wǝr ǝksudaɣ Mǝššina, wala ǝssiɣmaraɣ awedan waliyyan, ");
INSERT INTO ttq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","da tantut ta, tǝdgaz-i. A tat-akfa alxaq-net fǝl a daɣ-as ǝgrǝwaɣ iman-in.\"» ");
INSERT INTO ttq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tǝzzar inna Ǝmǝli Ɣaysa: «Tǝsallam y awa inna arak amašraɣ wa? ");
INSERT INTO ttq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tordâm as Mǝššina wǝr zʼakfu aytedan win isannafran alxaq-nasan, tu-tansaynen hallan ehad ezal? Tordâm as a fall-asan-in isahhagu tadhǝlt-net? ");
INSERT INTO ttq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ǝnneɣ-awan, a tan-akfu alxaq-nasan tarmad. Mišan harkid adi, ǝzǝl wa du-z-ǝqqǝla nak Ag Aggadǝm, awak a d-agǝzaɣ daɣ ǝddǝnet aytedan ǝzzigzannen?» ");
INSERT INTO ttq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Dǝffǝr awen, iga Ɣaysa ǝlmital y aytedan ǝttâfnen iman-nasan daɣ tišit n alɣadilan, as iga awen olkân aytedan, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Kala ad ǝggǝzzayan meddan ǝššin s Ahan wa Zǝwwǝran n Ǝlɣibada fǝl ad agin šiwatriwen. Iyyan Farisay, wa hadan anabaz n amana. ");
INSERT INTO ttq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisay za, ibdad ad itattar, igannu daɣ man-net: \"Ya Mǝššina, ǝggodayaɣ-ak as wǝr oleɣ d aytedan win hadatnen ǝmosnen inarkaban ǝd nǝmmǝzray ǝd maggan n ǝzzǝna, wala deɣ oleɣ d anabaz n amana wa. ");
INSERT INTO ttq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ǝssa adan kul, tuzama daɣ-san ǝššin. Takkasaɣ tǝmǝssǝdǝk daɣ awa garrawa kul.\" ");
INSERT INTO ttq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mišan anabaz n amana ǝnta, ibdad-in daɣ igǝg, wǝr ihel wala adakal n asawad-net sa sǝr jǝnnawan, iggât idmaran-net fǝl awa ǝgan man-net daɣ ǝɣšud, igannu: \"Ya Mǝššina tǝggǝzet-kay tǝhanint-in nak n anasbakkad.\" ");
INSERT INTO ttq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ǝnneɣ-awan, anabaz n amawan wa, iqqal ehan-net igrâw taqqat dat Mǝššina, mišan Farisay wen ǝnta wǝr igrew taqqat dat Mǝššina; fǝlas i idkalan iman-net, ad t-issǝrǝs Mǝššina, i issǝrasan iman-net ad t-idkǝl Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Harkid bararan win janɣayan tawayan-tan-du aytedan ǝs Ɣaysa fǝl a tan-issǝwǝr ifassan-net, ittǝr-asan. Ǝnayan nǝttulab-net awen, ǝššewalan fǝl aytedan win den. ");
INSERT INTO ttq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mišan iɣr-en-du Ɣaysa ǝs man-net, inna i nǝttulab-net: «Ayyat bararan a di-d-akkin, a tan-in-wǝr-tǝwǝɣam; Taɣmar ta n Mǝššina, šin aytedan win šilaten-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ǝggǝyeɣ silakanaɣ-awan as, awedan wǝr nǝga i Taɣmar ta n Mǝššina ǝlqǝbulat šilat ǝn ta das-iga barar, wədi wər das-ilkem a tat-iggaz.» ");
INSERT INTO ttq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Issǝstan ǝmuzar iyyan ǝn Kǝl-Ǝlyǝhud Ɣaysa, inn-as: «Ǝššex olâɣan, mas di-iwar igi-net y ad əgrəwa tǝmǝddurt ta tǝɣlalat?» ");
INSERT INTO ttq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Inn-as Ɣaysa: «Mafel as di-tǝganna Ǝššex olaɣan? Wǝr t-illa i olâɣan ar Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tǝssânaɣ alwajiban-net: Ad wǝr tagaɣ ǝzzǝna, ad wǝr tagaɣ iman, ad wǝr takǝra, ad wǝr tagaɣ tǝgǝyya ǝn bahu, sǝɣmǝr abba-nak d anna-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Inn-as alǝs wen: «Aratan win di kul harwa da mədrəya as tan-əssəbdada.» ");
INSERT INTO ttq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","As isla Ɣaysa y awen, inn-as: «Arat iyyanda a dak-in-iqqiman ǝmǝrǝdda: Aglu zanz-in awa tǝleɣ kul, tuzanaɣ inazzan-net i tǝlǝqqawen ad tǝgrǝwaɣ ǝrrǝzǝɣ a dak-z-ansin daɣ alaxirat. Dǝffǝr adi amaran tagla-du təlkəmaɣ-i.» ");
INSERT INTO ttq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","As isla y awen, ǝɣšadan man-net wǝllen fǝlas tǝgǝrgist tagget a iga. ");
INSERT INTO ttq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","As inay Ɣaysa as, ǝɣšâdan man n alǝs en wǝllen, inna: «Iket ǝzzǝwi ig-ay iguz ǝn Taɣmar ta n Mǝššina fǝl win əggərgasnen. ");
INSERT INTO ttq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ogar tǝrɣasay ta iga fǝl aḷam aradaɣ daɣ tǝbuday n ǝnazmay, i ta iga fǝl ǝmǝggergǝs iguz ǝn Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tǝzzar ǝnnan-as aytedan win das-ǝssǝsamnen: «Adi za ma ifragan ad iɣlǝs daɣ tǝmsay?» ");
INSERT INTO ttq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Inn-asan Ɣaysa: «Awa imosan muxal ɣur aytedan, Mǝššina ifrâk-ku.» ");
INSERT INTO ttq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Inn-as Butros: «Nakkanay za, a oyyanen awa nǝla kul, nǝlkam-ak?» ");
INSERT INTO ttq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Inn-asan Ɣaysa: «Ǝggǝyeɣ ǝsilakanaɣ-awan as, wǝr t-illa i din-z-ayyin ehan-net madeɣ tantut-net, madeɣ imǝdrayan-net, madeɣ imarwan-net madeɣ bararan-net fǝl ǝddǝlil ǝn Taɣmar ta n Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ǝs wǝrgeɣ ad igrǝw inǝdfusan-nasan daɣ harwa ǝmǝrǝdda, igrǝw deɣ tǝmǝddurt ta tǝɣlalat daɣ azzaman win ǝlkamnen.» ");
INSERT INTO ttq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ikkas Ɣaysa inǝttulab-net win maraw d ǝššin daɣ aytedan, inn-asan: «Sǝsǝmat: nakkanay da ǝggǝzzaynen ǝs Yerusalam da, amaran den da ad zʼandu arat kul wa ǝktaban ǝnnǝbitan daɣ salan-in nak Ag Aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ad tawagga daɣ fassan n aytedan wǝr nǝmos Kǝl-Ǝlyǝhud, agin daɣ-i tamakkakkayt, agin-i šisǝssǝlka, ǝssutǝfan fall-i, ");
INSERT INTO ttq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ayyawanan-i šiwwit, agin iman-in, tǝzzar ǝnkara-du daɣ tǝmattant ǝzǝl wa n karad.» ");
INSERT INTO ttq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mišan wǝr t-illa a ǝgrân nǝttulab-net daɣ awa inna den, ittinkal-asan almaɣna-net, wǝr ǝgren awa daɣ dasan-iššewal. ");
INSERT INTO ttq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","As d-ihoz Ɣaysa aɣrǝm wa n Yerikaw, okay fǝl ǝmǝdderɣǝl iyyan iqqiman fǝl afay ǝn tarrayt, itansay. ");
INSERT INTO ttq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","As isla amǝdderɣǝl i tamattay ta fall-as tǝtakayat da, issǝstan d awa imos awen. ");
INSERT INTO ttq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Itawann-as: «Ɣaysa wa n ǝɣrǝm ǝn Nazaret a itakayan.» ");
INSERT INTO ttq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Amaran idkal ǝmǝsli-net, igannu: «Ya Ɣaysa wa n Ag ǝnnǝbi Dawǝd, hǝnǝttǝt-i!» ");
INSERT INTO ttq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sannarɣaman-as aytedan win azzarnen y ad affastu, mišan idkal ǝmǝsli-net wǝllen, igannu: «Ya Ag Dawǝd, hǝnǝttǝt-i!» ");
INSERT INTO ttq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tǝzzar izzǝkkat Ɣaysa, omar s a das-d-attalway. As t-id-osa, issǝstan-tu, inn-as: ");
INSERT INTO ttq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Mas tareɣ a dak-k-aga?» Inn-as ǝmǝdderɣǝl: «Ǝmǝli, a ǝreɣ a di-d-iqqǝl asawad-nin.» ");
INSERT INTO ttq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Inn-as Ɣaysa: «Iqqǝlet-kay-du asawad-nak, ǝzǝgzan-nak a kay-iɣlasan.» ");
INSERT INTO ttq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iqqal-du asawad amǝdderɣǝl tamazayt ten da, igla ilkam i Ɣaysa, immâl Mǝššina. Aytedan kul win ǝnaynen awa igan den, ǝntanay da ǝmmâlan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iggaz Ɣaysa aɣrǝm ǝn Yerikaw, okay daɣ ammas-net y ad t-irdǝɣ. ");
INSERT INTO ttq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aɣrǝm en ih-ay alǝs igân esǝm Zakkǝyas imosan ǝmuzar ǝn nabazan n amana n ǝmǝggergǝs. ");
INSERT INTO ttq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ad igammay d anay ǝn Ɣaysa, mišan tǝgdal-as-tu tamattay fǝlas tǝgzǝlay a iga. ");
INSERT INTO ttq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tǝzzar ozal, azzar i tamattay, iftan ašǝk igân esǝm sikamor fǝl ad inǝy Ɣaysa fǝlas den da a du-z-akǝy. ");
INSERT INTO ttq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","As d-ewad Ɣaysa edag wen, idkal asawad-net, inn-as: «Zakkǝyas, zabbat-du tarmâd, azalada kundaba ǝzzǝbbeɣ daɣ aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Izzǝbbat-du Zakkǝyas tarmâd, iqbal awen, ifilawas. ");
INSERT INTO ttq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","As ǝnayan aytedan awen, gatantanan ketnasan, gannin: «Izzǝbbat ɣur alǝs n anasbakkad.» ");
INSERT INTO ttq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amaran ibdad Zakkǝyas dat Ǝmǝli Ɣaysa, inn-as: «Ya Ǝmǝli, ad akfaɣ tǝzunt ǝn tǝla-nin i tǝlǝqqawen, kud deɣ ill-ay i daɣ ǝtšeɣ arat, a das-t-ǝssuɣǝla imos ǝkkoz nǝdfusan.» ");
INSERT INTO ttq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tǝzzar inna Ɣaysa: «Azalada, ehan wa iggaz-t-id ǝlɣillas, fǝlas alǝs wa, ǝnta da ahaya n ǝnnǝbi Ibrahim a imos. ");
INSERT INTO ttq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nak Ag Aggadǝm oseɣ-du gammayaɣ aytedan win ǝxraknen y a tan-ǝɣlǝsa.» ");
INSERT INTO ttq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ǝssisaman aytedan y awa igannu Ɣaysa ketnet. Ig-asan Ɣaysa tangalt iyyat fǝlas ihoz Yerusalam amaran ǝɣilan alwaq wad za tǝnǝfilǝl Taɣmar ta n Mǝššina ewad-du. ");
INSERT INTO ttq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Inn-asan: «Kala ikka alǝs iyyan n ag ǝket akal iyyan iggugan y a daɣ-as d-igrǝw tǝmǝnukǝla, iqqǝl-du. ");
INSERT INTO ttq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dat teklay-net, iɣra-du maraw daɣ eklan-net. Akk iyyan daɣ-san ikf-ay tamma inn-asan: \"Agiwat daɣ-asnat jola har d-ǝqqǝla.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amaran alǝs en, wǝr t-ǝren aytedan n akal-net. As igla, ǝssǝglan inǝmmuzal s ǝmǝnokal wa zǝwwǝran y a das-annin: \"Alǝs di, wǝr nǝra ad iqqǝl ǝmǝnokal-nana.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mišan igraw taɣmar, iqqal-du akal-net. Isassaɣra-du eklan-net winâd ikfa tamatten da, fǝl ad issǝn awa sǝr-san d-iggazan daɣ jola-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Os-ay-du wa azzaran, inn-as: \"Mǝšši, tamma ta di-tǝkfeɣ ǝgrawa-du fall-as marawat šiyyad.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Inn-as mǝššis: \"Alafǝyet! Illikan as akli olâɣan a tǝmosa. Zamas tǝh-ik tǝflǝst daɣ awa wǝr nǝggǝt, adi za a kay-ǝzzuzǝraɣ i maraw ɣǝrman.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Os-ay-du wa n ǝššin, inn-as: \"Mǝšši, tamma ta di-tǝkfeɣ ǝgrawa-du fall-as sǝmmosat šiyyad.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Inna i wa: \"Kay, ad tizaraɣ i sǝmmos ɣǝrman.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Os-ay-du wa n karad, inna: \"Mǝšši, tamma ta di-tǝkfeɣ ǝnta da. Akamas a tat-ǝgeɣ daɣ ǝlkǝšifa-nin, ogazaq-qat. ");
INSERT INTO ttq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tǝksǝda a kay-ǝgeɣ, fǝlas ǝssânaɣ as alǝs labasan a tǝmosa. Tǝdakkalaɣ a wǝr tǝssǝnsa, tǝtalaya deɣ tawagost wǝr tǝnbela.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Inn-as mǝššis: \"Kay, ark ǝkli a tǝmosa, awa d-igmadan imi-nak as kay-z-abǝzaɣ. Dad tǝssanaɣ as ǝmôsaɣ awedan labasan, idakkalan a wǝr issǝnsa, italay deɣ tawagost wǝr inbel, ");
INSERT INTO ttq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ma fel as wǝr tǝgeɣ azrǝf-in daɣ bank, ǝddi as du-z-ǝqqǝla ǝgrâwa fall-as tǝttǝyt.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tǝzzar inna y aytedan win ǝllanen den: \"Abǝzat daɣ-as tamma ta ittaf, takfim-tat i wa ilan marawat.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ǝnnan-as: \"Mǝššikkana, wǝrgeɣ ilâ marawat?\" ");
INSERT INTO ttq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ijjǝwwab-asan, inna: \"Silakanaɣ-awan as, wa ilan, wǝdi a das-itǝwǝšitu awa ila; amaran wa wǝr nǝla, arat n arat wa ila da, a daɣ-as attarmas.\" ");
INSERT INTO ttq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amaran aytedan win zǝnga-nin, wǝr nǝra ad ǝqqǝla ǝmǝnokal-nasan, awǝyat-tan-du, tǝgzǝmam-tan dat-i.» ");
INSERT INTO ttq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","As inna awen, iggaz eɣaf ǝn nǝttulab-net, iggǝzzay ǝs Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","As din-ihoz taɣrǝmt ta n Betfajay ǝd ta n Betanǝy, dǝgma n ǝdɣaɣ was itawannu wa n \"Eškan ǝn Zaytun\", izammazal ǝššin daɣ nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Inn-asan: «Akkiwat taɣrəmt ten dat-wan den. As tat-in-tǝggazam, ad tǝnǝyam ǝhulel n ǝzdan iqqânan ǝs kala wǝr ittǝwan. Ariwat-t-id, tǝlwǝyam-t-idu. ");
INSERT INTO ttq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","As kawan-issǝstan awedan, inn-awan: \"Xa, ma tǝtaggim ǝddi?\" Tannim-as: \"Ǝmǝli a sǝr-ǝs iddǝraran.\"» ");
INSERT INTO ttq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ǝglan nǝttulab win den, ǝnayan arat kul s ǝmmǝk wa daɣ as dasan-t-inna Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Târan ǝhulel, as dasan-ǝnnan mǝssawǝs: «Xa, ma tǝtaggim ǝddi?» ");
INSERT INTO ttq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ǝnnan-asan nǝttulab win ǝššin en: «Ǝmǝli a sǝr-ǝs iddǝraran.» ");
INSERT INTO ttq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ǝlwayan-t-id i Ɣaysa. Ǝdfaran-as fall-as isǝlsa-nasan, ǝssǝwanan-as-tu. ");
INSERT INTO ttq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Imatakway, a das-tissǝwan aytedan isǝlsa-nasan daɣ tarrayt-net. ");
INSERT INTO ttq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","As d-ewad Ɣaysa edag wa daɣ tǝzagaday tarrayt adɣaɣ wa n Eškan ǝn Zaytun, daɣ ǝnǝmihaz ǝn Yerusalam, ǝdkalan nalkiman-net ketnasan imaslan-nasan, ǝssǝggadan daɣ tǝmmalen i Mǝššina daɣ batu ǝn tǝlmǝɣjujaten kul šin ǝnayan. ");
INSERT INTO ttq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Gannin: «Iga Mǝššina albaraka y ǝmǝnokal wa d-osan s esǝm n Ǝmǝli. Attadet alxer ǝd tanaya daɣ jǝnnawan win ǝdkalnen!» ");
INSERT INTO ttq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tǝzzar ǝnnan Farisaytan ǝhanen tamattay en i Ɣaysa: «Ǝššex, ǝrɣǝm i nalkiman-nak!» ");
INSERT INTO ttq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Inn-asan Ɣaysa: «Ǝnneɣ-awan, as ǝffǝstan, šihun a, a za sǝɣɣǝrǝtnen.» ");
INSERT INTO ttq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","As din-ihoz Ɣaysa aɣrǝm ǝn Yerusalam, ogg-ay, iggaz fall-as šin tala; ");
INSERT INTO ttq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","igannu: «Ya Yerusalam, ǝnnar kam dâ, tǝssânaɣ ǝmmǝk was za tǝgrǝwaɣ alxer azalada; mišan wǝr tu-tǝssena, fǝlas aɣabar a dam-iga. ");
INSERT INTO ttq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ǝlkâman adan a daɣ kam-za-ɣǝliɣǝlǝyan zǝnga-nam, agin-am afarag issohen n ǝmǝgǝr, ǝdgǝzan-kam fǝl gannatan kul. ");
INSERT INTO ttq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Addagdagan-kam, kam d aytedan-nam. Wǝr daɣ-am du-z-ayyin tǝhunt tǝwârat iyyat, fǝlas tugayaɣ s ad tagraɣ assa wa dam-d-iga Mǝššina y dam-agu arraxmat-net.» ");
INSERT INTO ttq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dǝffǝr awen, iggaz Ɣaysa aɣalla wa iɣlayan Ehan wa Zǝwwǝran n Ǝlɣibada, a daɣ-as isattaɣ imassatagan. ");
INSERT INTO ttq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Igann-asan: «Wǝrgeɣ iktâb as, inna Mǝššina: \"Ehan-in ad iqqǝl ehan ǝn tǝwatriwen.\" Kawanay amaran tǝgâm-tu \"ǝsǝlɣǝs ǝn baydagan\"?» ");
INSERT INTO ttq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Akk ǝzǝl isassaɣru Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada. Ad gammayan muzaran ǝn limaman ǝd musanan n Ǝttawret ǝd muzaran ǝn Kǝl-Ǝlyǝhud d igi ǝn man-net, ");
INSERT INTO ttq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mišan ab-asan tǝmǝwit tas zʼagin awen, fǝlas aytedan kul ǝknân-as ǝsǝsam. ");
INSERT INTO ttq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ǝzǝl iyyan isassaɣru Ɣaysa aytedan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, immal-asan Ǝlinjil as t-id-osan muzaran ǝn limaman ǝddewan ǝd musanan n Ǝttawret ǝd muzaran ǝn Kǝl-Ǝlyǝhud, ");
INSERT INTO ttq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ǝnnan-as: «Ǝmǝl-ana da du-tǝgrawa tarna n igi n aratan win tǝtagga da? Ma dak-kat-ikfan?» ");
INSERT INTO ttq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Inn-asan: «Nak da a dawan-agaɣ ǝsǝstan iyyan, amaran ǝmǝlat-i: ");
INSERT INTO ttq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Awak ǝsǝlmǝɣ wa iga Yaxya aytedan daɣ aman, Mǝššina a ɣur d-ifal awen meɣ aggadǝm?» ");
INSERT INTO ttq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tǝzzar namašawwaran gar-essan, ǝnnan: «As das-nǝnna \"Mǝššina a ɣur d-ifal\" a danaɣ-annu: \"Mafel za wǝr tǝzzǝgzǝnam s awa inna?\" ");
INSERT INTO ttq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","As das-nǝnna \"Aggadǝm a ɣur d-ifal\", tamattay ta, ketnet as dana-za-tanɣu ǝs zabaw ǝn tǝgur, fǝlas tǝkkâs aššak as Yaxya ǝnnǝbi a imos.» ");
INSERT INTO ttq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ǝnnan-as amaran: «Wǝr nǝssen wa ɣur d-ifal.» ");
INSERT INTO ttq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Inn-asan Ɣaysa: «Nak da za, wǝr dawan-z-ǝmǝlaɣ dad d-ǝgrawaɣ tarna n igi n aratan win.» ");
INSERT INTO ttq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amaran imalallay-in Ɣaysa tamattay ig-as ǝlmital wa, inna: «Kala ad ila alǝs iyyan afarag n alɣanab. Tǝzzar issǝɣfar afarag-net en i magyakan wiyyad, iššokal, ig-in tamert tagget. ");
INSERT INTO ttq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","As du-tewad tamert ta n ǝmilǝy n alɣanab, izammazal sǝr-san iyyan daɣ eklan-net y a t-id-akfin adagar-net daɣ awa d-eraw afarag, mišan ǝgan-as šiwwit, ǝssoɣalan-tu mǝššis isikarayray ifassan. ");
INSERT INTO ttq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Izammazal sǝr-san iyyan akli. Ǝnta da, ǝgan-as šiwwit, saffallasan-tu, ǝssoɣalan-tu wǝr eway wala. ");
INSERT INTO ttq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","As taklat ta n karadat, izammazal sǝr-san iyyan akli. Ǝnta da sabbasan-tu, ǝstaɣan-tu. ");
INSERT INTO ttq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dǝffǝr awen inna mǝššis n afarag: \"Awak ma zʼaga? A sǝr-san zǝmmizǝla ruray wa ǝkneɣ tara, mijas ǝnta a t-ǝssǝɣmǝran.\" ");
INSERT INTO ttq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mišan as ǝnayan magyakan win ǝɣfarnen afarag barar-net izay-tan-du, namannan gar-essan: \"Ǝnta ǝddi amakkasu n afarag. Anɣiwatanaq-qu kǝrǝz, fǝl ad tǝqqǝl tǝkasit šin-nana.\" ");
INSERT INTO ttq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ǝkkasan-tu daɣ afarag, ǝnɣan-tu kǝrǝz.» Amaran inna Ɣaysa i tamattay: «Ǝmǝrǝdda ma tordam ma zʼagu mǝššis n afarag i win den meddan? ");
INSERT INTO ttq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Adi za ad aglu ǝnta iman-net, agu iman ǝn magyakan win, issǝɣfǝr afarag-net i magyakan wiyyad.» Ǝslan aytedan y awen ɣas, ǝnnan: «Mǝššina ya wǝr tǝgeɣ adi!» ");
INSERT INTO ttq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tǝzzar idak-kan Ɣaysa s asawad, inn-asan: «Daɣ adi ma imos almaɣna ǝn batu ta tǝnnat daɣ Ǝlkǝttaban: \"Tǝhunt ta din-ǝgaran makrasan, ǝnta a tǝqqalat tǝhunt ta tǝkbalat ehan\"? ");
INSERT INTO ttq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Awedan kul wa udan fǝl tǝhunt ta, ad addagdag, wa fǝl tuda deɣ a tu-tǝlkǝš.» ");
INSERT INTO ttq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ǝgran musanan n Ǝttawret ǝd muzaran n limaman as ǝntanay a fǝl iga Ɣaysa ǝlmital wen, tǝzzar ǝgmayan d abbaz-net amazay wen da, mišan wǝr ǝgen awen, fǝlas tamattay a ǝksudan. ");
INSERT INTO ttq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Adi a fǝl ewalan Ɣaysa, ǝnkâdan-as. Ǝssokan-t-idu meddan ǝgânen iman-nasan almat alɣadilan, fǝl a tu-šǝššiwǝlan sassannin-tu arat wǝr nǝtǝwǝnnu, abǝzǝn-tu sǝr-ǝs, agin-tu daɣ fassan n ǝmuzar n akal d ǝlxǝkum-net. ");
INSERT INTO ttq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ǝssǝstanan Ɣaysa, ǝnnan-as: «Ǝššex, nǝssân as awa tǝganna d awa tǝsassaɣra oɣâd; wǝr tǝtǝgga tǝmǝrit gǝr aytedan. Tǝsasaɣra ǝs tidǝt awas danaɣ-iwar igi-net daɣ tarrayt ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amaran ǝmǝl-ana, awak xalal-ana arazam n amana y ǝmǝnokal wa zǝwwǝran Qaysara meɣ?» ");
INSERT INTO ttq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Igra Ɣaysa tǝnagmayt-nasan, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Saknat-i tefelt n ǝzrǝf. Ma ilan udǝm d esǝm win t-ǝwarnen?» Ǝnnan-as: «In Qaysara.» ");
INSERT INTO ttq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Inn-asan: «Adi za agiwat i Qaysara awa kawan-issǝwar, tagim deɣ i Mǝššina awa kawan-issǝwar.» ");
INSERT INTO ttq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Indar-asan a tu-sǝssugin ark awal dat aytedan. Isammaklal sǝr-san aljawab wa dasan-iga den, ǝffǝstan. ");
INSERT INTO ttq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dǝffǝr awen osan-t-id arat daɣ aytedan ǝn taggayt ta n Sadusaytan. Sadusaytan ǝttâfan as wǝr tu-tǝlla tanakra dǝffǝr tǝmattant. Ǝssǝstanan-tu, ");
INSERT INTO ttq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ǝnnan-as: «Ǝššex, inna ǝnnǝbi Musa daɣ Ǝttawret: \"As aba alǝs, oyya-du tantut dǝr wǝr ila barar, a tat-izlǝf amadray-net fǝl ad agu ǝzzurrǝyya y ǝmidi-net wa aba den.\" ");
INSERT INTO ttq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amaran kala a t-ǝllan ǝssa mǝdrayan. Izlaf wa dasan-waššaran ketnasan, aba-tu wǝr ila barar. ");
INSERT INTO ttq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Izlaf wa n ǝššin tantut ta d-oyya ǝmaqqar-net, ǝnta da aba-tu wǝr d-oyya ara. ");
INSERT INTO ttq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wa n karad deɣ awen da. Ǝssa mǝdrayan en ketnasan igraw-tan awen da, wǝr tan-iha i d-oyyan ara. ");
INSERT INTO ttq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dǝffǝr awen, aba tantut ǝnta da. ");
INSERT INTO ttq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Awak ǝzǝl wa n tabadday, ma imos daɣ ǝssa mǝdrayan win den was za tǝqqǝl tǝntut ten taɣurǝs, dad zamas ketnasan ǝzlâfan-tat?» ");
INSERT INTO ttq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Inn-asan Ɣaysa: «Daɣ ǝddǝnet ta nǝha da, zallafan meddan, tawazlafnat tǝdoden, ");
INSERT INTO ttq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mišan aytedan win isannaha Mǝššina ǝd tanakra daɣ tǝmattant fǝl ad ǝggǝzan aljannat, win di wǝr dasan-t-illa azalaf gǝr za meddan wala šidoden. ");
INSERT INTO ttq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Id ab-as daɣ-san tǝlkam tǝmattant, olân d angalosan, ǝqqalan bararan ǝn Mǝššina id tanakra a d-ǝgan daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Amaran daɣ awa iqqalan tanakra ǝn nǝmmǝttan, ǝnnǝbi Musa ǝnta iman-net as isattadda awen daɣ Ǝttawret, daɣ batu ǝn tǝfsǝq, assaɣa wad inna Mǝššina imos \"Ǝmǝli n Ibrahim, d Isǝhaq ǝd Yaqub.\" ");
INSERT INTO ttq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Daɣ adi Mǝššina wər imos Ǝməli ən təməxsa, kalar Ǝmǝli ǝn win ǝddarnen a imos, fǝlas ɣur-ǝs aytedan kul ǝddâran.» ");
INSERT INTO ttq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ǝnnan wiyyad daɣ musanan n Ǝttawret i Ɣaysa: «Ǝššex, tǝgêɣ awal olâɣan.» ");
INSERT INTO ttq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dǝffǝr adi ab-as ǝhalan ǝsǝstan-net d arat waliyyan. ");
INSERT INTO ttq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dǝffǝr awen issǝstan-tan Ɣaysa inn-asan: «Manǝmmǝk as itawannu Ǝlmǝsix Ag ǝmǝnokal ǝnnǝbi Dawǝd a imos? ");
INSERT INTO ttq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ǝnta Dawǝd iman-net as sǝr-ǝs inna daɣ ǝlkǝttab wa n Azzabur: \"Inna Ǝmǝli y Ǝmǝli-nin: 'Qamu daɣ ǝɣil-in, ");
INSERT INTO ttq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","har aga izǝnga-nak daw daran-nak.'\" ");
INSERT INTO ttq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daɣ adi dad zamas Dawǝd iman-net iɣra Ǝlmǝsix s esǝm wa n Ǝmǝli, manǝmmǝk as zʼiqqǝl barar-net?» ");
INSERT INTO ttq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Harwada ǝssîsaman aytedan kul, as inna Ɣaysa i nǝttulab-net: ");
INSERT INTO ttq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ǝnkǝdat i musanan n Ǝttawret, ǝrân ǝsǝɣlǝy ǝzlâgan šikadkaden zagrotnen, d ǝtǝwǝsǝslam igân ǝs saɣmar daɣ sammanayan, ǝrân tǝɣimit daɣ daggan win ǝlanen almaqam daɣ nan win ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ǝd daggan n aytedan win tawasaɣmarnen daɣ mǝgura. ");
INSERT INTO ttq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tattan eharay ǝn tǝdoden šin as aba meddan-nasnat, as iga awen, taggin imaddan tahaginen wǝr nǝmos ar sokni. Ilkâm a dasan-itǝwǝxkǝm attadib labasan.» ");
INSERT INTO ttq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Idkal Ɣaysa asawad-net, inay imǝggǝrgas taggin azrǝf wa ǝkkatan daɣ ǝssǝnduq wa daɣ itiddaw ǝrrǝzǝɣ n Ahan wa Zǝwwǝran n Ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Inay deɣ tantut iyyat ǝn tǝlǝqqay as wǝr idder alǝs-net as tǝga daɣ ǝssǝnduq en sanatat tǝfelen. ");
INSERT INTO ttq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tǝzzar inna: «Ǝggǝyyeɣ silakanaɣ-awan as, tantut ten ǝn tǝlaqqay en as wǝr idder alǝs-net en, togar aytedan a ketnasan tehakkay. ");
INSERT INTO ttq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Fǝlas ketnasan awas wǝr ǝddǝraran a ǝkfan, ǝnta amaran, addararat-net a daɣ tǝdkal awa tǝla kul tǝkat-tu.» ");
INSERT INTO ttq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ǝššewalan aytedan wiyyad daɣ batu n Ahan wa Zǝwwǝran n Ǝlɣibada, ǝmmâlan adalag wa iga ǝs tǝhun hossaynen d aratan win ǝkfan aytedan daɣ tǝkutawen-nasan. Inna Ɣaysa: ");
INSERT INTO ttq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«A wa tǝhannayam da, ǝlkâman adan a daɣ-as du-wǝr-za-taqqam tǝhunt tǝwârat tǝmidit-net, ketnet ad itǝwǝjǝbbǝrǝjjǝt.» ");
INSERT INTO ttq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tǝzzar ǝssǝstanan-tu, ǝnnan-as: «Ǝššex, ǝmmay ad zʼagu wǝdi arat? Ma za tǝqqǝl alɣalamat ta za tassaknit as ibuk y igi?» ");
INSERT INTO ttq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Inn-asan Ɣaysa: «Ǝnkǝdat ad wǝr tǝtǝwǝsǝxrǝkam, id aytedan aggotnen a du-z-asinen ǝttafan esǝm-in. Akkiyyan daɣ-san igannu: \"Nak a imosan Ǝlmǝsix\", \"Taqqan tewad.\" A dasan-wǝr-tǝlkǝmam. ");
INSERT INTO ttq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","As tǝslam i tǝrmuq ǝn mǝgiran d ǝlfǝllagatan, ad wǝr tǝššǝwǝšam fǝlas, aratan di kundaba izâran-du, mišan wǝr dasan-za-tǝlkǝm tǝzǝrǝst n ǝddǝnet ǝddi da.» ");
INSERT INTO ttq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Inn-asan deɣ: «Ad ǝknǝsnat addawlaten gar-essanat, ǝknǝsnat taɣmaren gar-essanat, ");
INSERT INTO ttq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ǝmǝlan-tu nǝgǝynǝgǝyan n amaḍal labasnen; imǝl-tu laz ǝd tǝwǝrnawen ǝssiksadnen daɣ daggan aggotnen, ǝmǝlan-tu deɣ aratan ǝssiksadnen d alɣalamaten ǝsimaklalnen daɣ jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mišan dat adi kul, ad tattarmasam, tǝtǝwǝzǝɣǝzzǝbam, tammawayam ǝs nan win ǝlɣibada ǝn Kǝl-Ǝlyǝhud, tǝtǝwǝggim da kasaw, tǝtǝwǝsǝbdǝdam dat mǝnokalan ǝd naxkiman, tǝtǝwǝsǝstǝnam fǝlas kawan-iwar esǝm-in. ");
INSERT INTO ttq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A kawan-akfu adi tarrayt n a fall-i taggayyem. ");
INSERT INTO ttq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Daɣ adi sansiwat taytwen-nawan, ad wǝr tǝsǝmmutǝgam awa za tannim y ad tǝkkǝsam iman-nawan, ");
INSERT INTO ttq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","fǝlas a kawan-akfa masnat n awal ǝd tǝla n ǝgǝrri as tu-wǝr-illa azangaw-nawan a dasan-z-ifrǝgan wala deɣ ifrǝg isǝbbǝhǝw-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wala imarwan-nawan a kawan-sǝttǝrmǝsan, sǝttǝrmǝsan-kawan mǝdrayan-nawan ǝd šǝqqaɣan-nawan ǝd midawan-nawan, tǝwǝnɣin wiyyad daɣ-wan kǝrǝz. ");
INSERT INTO ttq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A kawan-ǝgzǝran aytedan kul fǝlas kawan-iwar esǝm-in, ");
INSERT INTO ttq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","mišan wǝr dawan-z-iɣšǝd adi wala a odgan ǝd tǝzuɣay n ǝmi n ǝššǝnnan. ");
INSERT INTO ttq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zǝmmerat-nawan as za tagǝzam iman-nawan. ");
INSERT INTO ttq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","As tǝnayam aɣrǝm ǝn Yerusalam ɣilayɣalayan-tu gǝnan ǝn sojitan, tǝssǝnam as ijwâr itiwadagdag. ");
INSERT INTO ttq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ǝddi, aytedan win ahanen akal ǝn Yahudǝyya, win di addaggaganet s ǝdɣaɣan. Win ǝhanen aɣrǝm ǝn Yerusalam, ǝgmǝdanet-tu, win t-ǝgmadnen ǝs saffan-net, a t-idu-wǝr-ǝqqǝlan, ");
INSERT INTO ttq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","fǝlas adan win di, ad ǝqqǝlan adan a daɣ zʼawwaddab Mǝššina aytedan, fǝl ad andin aratan kul win ǝnnan Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Iket alɣazab ad t-aginat tǝdoden šin ǝganen šidusen ǝd šin sankasnen daɣ adan win den, fǝlas ad tagu tǝssust labasat daɣ akal, azzabbat-du attadib ǝn Mǝššina fǝl tamattay ta. ");
INSERT INTO ttq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Arat daɣ tamattay ta ad itǝwǝnɣu ǝs takoba, awa hadan ikfǝl ǝs kallan kul, ǝggǝznat tǝmattiwen wǝr nǝmos Kǝl-Ǝlyǝhud aɣrǝm ǝn Yerusalam, a tu-tataftafnat har tandu tǝmastant ta tanat-ikfa Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ad tǝwǝnǝyan aratan saksodnen ǝmosnen alɣalamaten as zʼaginen da tǝfuk ǝd tǝllit d etran. Ad ǝššǝwǝšnat tǝmattiwen n ǝddǝnet wǝllen, iqqǝn ǝmǝsli labasan wa tagginat tanazzamaren n aman ǝn gǝrwan iɣafawan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aytedan a tan-tanɣu tasa n aratan win hannayan ǝzayan-du ǝddǝnet fǝlas ad tǝwǝsǝnǝgǝynǝgǝynat tǝxǝllak šin ǝlânen tarna daɣ jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Alwaq wǝdi, a di-ǝnǝyan aytedan nak Ag Aggadǝm as du-z-asa, ǝheɣ tagarak, ǝleɣ tarna ǝd tanaya tagget. ");
INSERT INTO ttq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","As ǝntan aratan win di, tǝsǝmmutǝgam, annalamanet man-nawan, fǝlas alwaq ǝn tǝdarfit-nawan ihôz.» ");
INSERT INTO ttq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ig-asan Ɣaysa ǝlmital, inn-asan: «Ǝnẓǝrat-in daɣ ašǝk ǝn fig d eškan win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","As ǝggazan šin tanazra, ad tǝssǝnam kawanay iman-nawan as tamert ta n akasa tǝhôz. ");
INSERT INTO ttq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Zund ǝmmǝk en daɣ âs as tǝnayam aratan win dawan-ǝmalaɣ ǝddi, tǝssǝnam as Taɣmar ta n Mǝššina tǝhôz. ");
INSERT INTO ttq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ǝggǝyyeɣ ǝsilakanaɣ-awan as tamattay ta da n azzaman win nǝha da, ad tǝnǝy ǝnǝtti n aratan kul win dawan-ǝmala da. ");
INSERT INTO ttq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ijǝnnawan d amaḍal ilkâm ad ibʼas t-ǝllan, mišan batuten-in ǝllanat-tu har faw.» ");
INSERT INTO ttq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ǝnkǝdat fǝl man-nawan! Ad wǝr iɣšǝd igǝt ǝn tattay ǝd tassay n esmad ǝd medranan n ǝddǝnet ǝnnǝyaten-nawan, ag-awan ǝzǝl wǝdi aɣadar, ");
INSERT INTO ttq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","zun wa tǝtaggu taftaw y awedan. Arat wǝdi ad agu fǝl aytedan kul win ǝwarnen tesayt n amaḍal. ");
INSERT INTO ttq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Daɣ adi agat ǝnnǝyat, ad tǝtansayam Mǝššina alwaq kul a kawan-issǝfragan ikus ǝn man-nawan daɣ awa d-izayan ketnet, tǝfrǝgam a dat-i tǝbdǝdam nak Ag Aggadǝm.» ");
INSERT INTO ttq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Faw isasaɣru Ɣaysa aytedan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, amaran as iga ahad, ad adǝw adɣaɣ igân esǝm wa n Eškan ǝn Zaytun. ");
INSERT INTO ttq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Id affaw, a d-ǝnzǝyan aytedan kul s Ahan wa Zǝwwǝran n Ǝlɣibada y a das-ǝssǝsǝman. ");
INSERT INTO ttq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Amud wa daɣ tattin aytedan šigǝlwen šin wǝr iha xamira, was itawannu wa n Akkay, ihôz. ");
INSERT INTO ttq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Imuzaran ǝn limaman ǝd musanan n Ǝttawret gammayan tǝmǝrkest tas zʼagin iman ǝn Ɣaysa, mišan ǝksudan ad t-anɣin ijǝnnǝjǝrwǝy awen tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iggaz Aššaytan Yahuza was itawannu Isxarǝyuti imosan iyyan daɣ nǝttulab ǝn Ɣaysa win maraw d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Igla, ikka imuzaran ǝn limaman ǝd muzaran n aytedan win ogaznen Ehan wa Zǝwwǝran n Ǝlɣibada, imašawal dǝr-san daɣ batu n ǝmmǝk was zʼagu Ɣaysa daɣ fassan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Isaddawat-tan awen; ǝrḍan s ad t-akfin azrǝf. ");
INSERT INTO ttq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ird-asan, tǝzzar ad igammay tǝmǝwit tas zʼagu Ɣaysa daɣ fassan daɣ amazay a ɣur-ǝs wǝr tǝlla tamattay. ");
INSERT INTO ttq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","As d-ewad ǝzǝl n ǝmud wa n tǝgǝlwen šin wǝr iha xamira, wa daɣ tawagzaman jǝɣal win ǝmud wa n Akkay, ");
INSERT INTO ttq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","izammazal Ɣaysa Butros ǝd Yaxya, inn-asan: «Aglat tǝsǝmmutǝgam-anaɣ imensewan win ǝmud wa n Akkay.» ");
INSERT INTO ttq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ǝnnan-as: «Mǝnid tareɣ a tan-nǝsǝmmutǝg?» ");
INSERT INTO ttq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Inn-asan: «As din-tǝggazam aɣrǝm, ad tammanayam d alǝs a d-iktâran ǝtǝkin-net. Ǝlkǝmat-as s ahan wa zʼiggǝz, ");
INSERT INTO ttq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tannim i mǝššis n ahan wǝdi: \"Inn-ak Ǝššex: 'Mǝni tu daɣ ahan-nak edag wa n naftaɣan, wa daɣ za nammansaw nak ǝd nǝttulab-in daɣ ǝmud wa n Akkay?'\" ");
INSERT INTO ttq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A kawan-assaknu daɣ suru-net, ehan wa n afalla, elwân, ǝhân-tu mutag kul. Ǝddi da ad za tǝsǝmmutǝgam imensewan.» ");
INSERT INTO ttq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ǝglan, ǝnayan arat kul s ǝmmǝk was dasan-t-inna Ɣaysa; tǝzzar ad simutugan imensewan win Akkay. ");
INSERT INTO ttq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","As iga alwaq ǝn tattay, inaɣama Ɣaysa ǝd nǝmmuzal-net, ǝggazan šin tattay. ");
INSERT INTO ttq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tǝzzar inn-asan: «Ǝkneɣ deran ǝn tǝdrǝwt ta dǝr-wan ǝgeɣ imensewan n ǝmud wa, harwa wǝr ǝɣɣǝzzaba. ");
INSERT INTO ttq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Silakanaɣ-awan as, wǝr di-ilkem a tan-ǝlasa tettay iket wǝr d-osa ǝzǝl wa daɣ zʼandu almaɣna-nasan daɣ Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tǝzzar idkal-du Ɣaysa tǝkabart iha esmad n alɣanab, iggoday i Mǝššina, inna: «Abǝzat tǝkabart ta, tǝnǝmǝglǝzam awa tat-ihan, ");
INSERT INTO ttq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","fǝlas ǝsilakanaɣ-awan as, wǝr ilkem ad ǝšweɣ esmad n alɣanab, iket wǝr du-tosa Taɣmar ta n Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dǝffǝr awen idkal Ɣaysa tagǝlla, iga igodan i Mǝššina, irz-et izun-asan-tat, inn-asan: «taɣǝssa-nin adi, tǝtiwakfat fǝl ǝddǝlil-nawan. Tuzanat-tat ǝs tǝmǝwit ta da, imos adi isaktan-in.» ");
INSERT INTO ttq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Zund ǝmmǝk en da âs as ǝtšan, idkal tǝkabart, inn-asan: «Tǝkabart ta, arkawal wa aynayan ǝn tassaq a tǝmos gǝr Mǝššina ǝd tamattay-net. Arkawal wa, azni-nin a zʼinɣǝlan fǝl tǝnfa-nawan a t-isattaddan.» ");
INSERT INTO ttq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Fadda ǝnǝyat, alǝs wa di-z-aggin daɣ fassan, illa da da, idrâw dǝr-i. ");
INSERT INTO ttq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Illikan as nak Ag Aggadǝm a di-iba ǝs tǝmǝwit ta d-ixkam Mǝššina harwa dat alwaq, mišan iket alɣazab ad t-inǝy awedan wa di-igan daɣ fassan.» ");
INSERT INTO ttq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tǝzzar ad tinǝmǝsǝstinan nǝmmuzal-net gar-essan ǝd wa daɣ-san zʼagin wen daɣ arat. ");
INSERT INTO ttq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dǝffǝr awen tǝnkar tamazaq gar-essan tǝgât daɣ batu ǝn was ǝttafan as ǝnta a daɣ-san ogaran. ");
INSERT INTO ttq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Inn-asan Ɣaysa: «Imǝnokalan ǝn tǝmattiwen n ǝddǝnet saknin tarna y aytedan win as azzaran, zamazalan fall-asan deɣ ǝlxǝkum-nasan; mišan dǝr iga awen da ǝttâfan as imadhalan n aytedan a ǝmosan. ");
INSERT INTO ttq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mišan kawanay, ad wǝr tagim awen. Kalar, wa daɣ-wan ogaran almaqam, iqqǝlet zun wa daɣ-wan mǝdrǝyan. Wa daɣ-wan azzaran, iqqǝlet zun amaššaɣal. ");
INSERT INTO ttq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Awak ma ogaran awedan wa iqqiman itattu ǝd wa das-išɣalan? Wǝrgeɣ wa iqqiman itattu? Mišan nak imosan ǝmuzar-nawan aheq-qawan ǝmosa zun amaššaɣal-nawan.» ");
INSERT INTO ttq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Kawanay win da, a d-ǝqqimnen tǝlkâmam-i daɣ jarrabatan win ǝnaya. ");
INSERT INTO ttq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Adi as, tehakkay ta di-iga Abba-nin taɣmar, ǝnta a dawan-z-aga y-as nak ǝmǝrǝdda. ");
INSERT INTO ttq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Fǝl a dǝr-i tǝdrǝwam tettay ǝd tassay daɣ taɣmar-in, taqqamim fǝl tǝsǝqqima ǝn tǝmǝnukǝla y ad tǝšrǝɣam i tawšeten marawat ǝd sanatat šin Israyil.» ");
INSERT INTO ttq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simɣon, Simɣon! Ǝnkǝd! Aššaytan igmây turagat n a dawan-agu ǝsǝkǝnsǝki wa itawaggin y alkama. ");
INSERT INTO ttq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mišan nak onsâyaɣ-ak Mǝššina fǝl a kay-wǝr-igmǝd ǝzǝgzan wa sǝr-i tǝgeɣ. Amaran as di-du-tǝqqala, tǝsǝssuheɣ ǝzǝgzan ǝn mǝdrayan-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Inn-as Simɣon Butros: «Ǝmǝli, nak simataga s a dǝr-ǝk idawa kuddeɣ ǝs kasaw, ǝd tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mišan inn-as Ɣaysa: «Butros, silakanaɣ-ak as, wǝr zʼaɣru ǝkǝji aɣora ahada da wǝr di-tǝggeda har karadat tăklaten.» ");
INSERT INTO ttq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dǝffǝr awen inna Ɣaysa i nǝmmuzal-net ketnasan: «Alwaq wa kawan-zammazala wǝr tewayam azrǝf, wala aɣrǝg, wala tǝsǝsǝlt ta n sanatat, awak ill-ay arat a din-todânam?» Ǝnnan-as: «Kala.» ");
INSERT INTO ttq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Inn-asan: «Ǝmǝrǝdda za, wa ilan azrǝf awǝyet-tu, wa ilan aɣrǝg awǝyet-tu. Wa wǝr nǝla takoba, azzanzet-in ǝbǝrnuz-net, azzanzet-du. ");
INSERT INTO ttq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Silakanaɣ-awan as, awa fall-i itawannan daɣ Ǝlkǝttab ǝn Mǝššina n as \"iddun daɣ maggan ǝn tǝkma.\" Kundaba inda. Awalla, arat kul wa fall-i itawannan ad andu.» ");
INSERT INTO ttq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ǝnnan-as: «Ǝmǝli, sanatat tǝkabiwen da.» Inn-asan: «Ayyat batu di, wǝr di-tǝgrem.» ");
INSERT INTO ttq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Igmad Ɣaysa, iddêw ǝd nǝttulab-net, ikka adɣaɣ wa n Eškan ǝn Zaytun, imos awen arat itaggu faw. ");
INSERT INTO ttq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","As din-ewadan, inn-asan: «Ansǝyat Mǝššina a kawan-ogazan daɣ jarrabatan n Iblis.» ");
INSERT INTO ttq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ǝnta amaran izzǝnkaz-in fall-asan, ǝddukad ǝn taggor ǝn tǝhunt, igaraffat ad itattar, ");
INSERT INTO ttq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","igannu: «Abba, kud immikkan adi, tǝssǝgǝgaɣ-i tǝkabart ta n alɣazab di! Dǝr iga awen da ya, taget tara ta-nak wǝrgeɣ ta-nin.» ");
INSERT INTO ttq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Amaran inafalal-as angalos y ad t-isǝssuhǝt. ");
INSERT INTO ttq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tǝzzar ǝdgazan man Ɣaysa, idgaz wǝllen daɣ tǝwatriwen, har tǝqqal tarraft-net šilat n ǝzni, ad tǝtattab daɣ amaḍal. ");
INSERT INTO ttq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","As iɣrad šiwatriwen, ibdad, iqqal-du inǝttulab-net, os-en-du issins-en ǝɣšud ǝn man. ");
INSERT INTO ttq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Inn-asan: «Mafel tǝnsâm? Ǝnkǝrat tansǝyam Mǝššina a kawan-ogazan daɣ jarrabatan n Iblis.» ");
INSERT INTO ttq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Harwada iššewal-asan as tan-tǝggaz tamattay tǝgget as azzar Yahuza wa n iyyan daɣ nǝttulab-net win maraw d ǝššin. Ihoz-du Yahuza Ɣaysa y ad t-izǝlǝmmǝt. ");
INSERT INTO ttq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mišan inn-as Ɣaysa: «Adis kay Yahuza, tǝzǝlǝmmet as di-za-tǝsǝssuga daɣ fassan, nak Ag Aggadǝm?» ");
INSERT INTO ttq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","As ǝnayan nǝttulab win hadatnen awa ibukan y igi da, ǝnnan: «Ǝmǝli, ma iqqal nǝššǝšɣǝl šikabiwen-nana?» ");
INSERT INTO ttq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tǝzzar iwat iyyan daɣ-san akli n Ǝlimam wa Zǝwwǝran, ifras-du tǝmǝzzuk-net ta n ǝɣil. ");
INSERT INTO ttq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mišan iharaššat-tan Ɣaysa, inn-asan: «Ayyat adi!» Tǝzzar idas tǝmǝzzuk n ǝkli wen, izzozay-tat, tǝqqǝl ǝmmǝk-net. ");
INSERT INTO ttq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Amaran inna i muzaran ǝn limaman ǝd muzaran n aytedan win tagaznen Ehan wa Zǝwwǝran n Ǝlɣibada ǝd muzaran ǝn Kǝl-Ǝlyǝhud, ǝs ketnasan osân-du y ad t-ǝbǝzan: «Awak ǝjajǝb iyyan n abaydag a ǝmosa as sǝr-i du-tewayam šikabiwen ǝd tǝburǝgen? ");
INSERT INTO ttq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wǝrgeɣ ǝzǝl kul ǝrtâya dǝr-wan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada mišan wǝr di-tobezam? Ǝmǝrǝdda za alwaq-nawan a d-ewadan, kawanay ǝd taɣmar ta n Iblis ǝd šiyyay-net.» ");
INSERT INTO ttq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tǝzzar obazan Ɣaysa, ewayan-tu s aɣaywan n Ǝlimam wa Zǝwwǝran. Ig-asan Butros lǝkkum zagren. ");
INSERT INTO ttq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","As din-osan, tǝtawasarɣa tǝmsay daɣ ammas n aɣalla, ǝqqiman sǝr-ǝs aytedan. Iggaz-tan-in Butros. ");
INSERT INTO ttq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tǝnay-tu tǝmaššaɣalt iyyat iqqim ǝs tǝmsay, tǝzaggazd-ay wǝllen, amaran tǝnna: «Alǝs wa, ǝnta da, iddew ǝd Ɣaysa.» ");
INSERT INTO ttq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mišan iggad Butros awen, inna: «Tantut, wǝr t-ǝzdaya.» ");
INSERT INTO ttq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Arat n amazay dǝffǝr awen, inay-tu iyyan awedan, inn-as: «Kay da, iyyan daɣ-san.» Mišan inn-as Butros: «Xa alǝs wa, kala wǝr t-ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","As iga adag n alwaq dǝffǝr awen, inna alǝs iyyan s assahat: «Illikan as alǝs wa iddew dǝr-ǝs, fǝlas ǝnta da in akal ǝn Galilaya.» ");
INSERT INTO ttq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Inn-as Butros: «Xa alǝs, wǝr ǝssenaɣ awa daɣ-i tǝššewalaɣ.» Harwa da iššewal Butros alwaq wen da as iɣra ǝkǝji aɣora. ");
INSERT INTO ttq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tǝzzar imalallay-in Ǝmǝli Ɣaysa iswad daɣ Butros. Den da a d-ikta Butros awal wa das-iga Ǝmǝli, as das-inna: «Wǝr zʼaɣru ǝkǝji aɣora azalada wǝr di-tǝkkesaɣ tazdǝyt har karadat tăklaten.» ");
INSERT INTO ttq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tǝzzar Igmad Butros, ad ihallu fǝl awa ǝgan man-net daɣ ǝɣšud. ");
INSERT INTO ttq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Alwaq wen, meddan win ǝttafnen Ɣaysa, ǝgân daɣ-as tamakkakkayt, ǝggâtan-tu. ");
INSERT INTO ttq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ǝgan-as abanaban, a das-gannin: «Kay ya ǝlǝwli! Ǝmǝl wa kay-iwatan.» ");
INSERT INTO ttq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A das-taggin batuten šiyyad aggotnen labasnen. ");
INSERT INTO ttq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","As affaw aɣôra, immǝnay Asaggawar wa Zǝwwǝran ǝn muzaran ǝn Kǝl-Ǝlyǝhud, ǝhân-tu ǝmuzaran ǝn limaman ǝd musanan n Ǝttawret, itawasabdad dat-san Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ǝnnan-as: «Kud kay Ǝlmǝsix, tǝmǝlaɣ-ana?» Tǝzzar inn-asan: «Kud dawan-ǝmala da wǝr di-za-tǝzzǝgzǝnam, ");
INSERT INTO ttq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kud kawan-ǝssǝstana deɣ wǝr di-za-tajjawwabam. ");
INSERT INTO ttq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mišan a obazan ɣur ǝmǝrǝdda, Nak Ag Aggadǝm ad aqqama daɣ ǝɣil ǝn Mǝššina di n Ǝmǝli ǝn Tarna.» ");
INSERT INTO ttq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ǝnnan-as ketnasan: «Daɣ adi kay Barar ǝn Mǝššina?» Inn-asan: «Kawanay iman-nawan as tǝnnam ǝmosaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tǝzzar ǝnnan: «Ma nǝkka y iyyat tǝgǝyya? Wǝrgeɣ nakkanay iman-nana nǝslâ y awa d-igmadan imi-net?» ");
INSERT INTO ttq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tǝnkar aljamaɣat ketnet, teway Ɣaysa ǝs Bilatǝs wa n ǝnaxkim. ");
INSERT INTO ttq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A ɣur-ǝs tu-ɣattasan gannin: «Alǝs wa, as t-in-nosa isaxrak tamattay-nana. Igaddal deɣ y aytedan ad ǝrzǝman amana i Qaysara wa n ǝmǝnokal wa zǝwwǝran, harwa igannu ǝnta a imosan Ǝlmǝsix, ǝmǝnokal.» ");
INSERT INTO ttq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Awen da a fǝl t-issǝstan Bilatǝs, inn-as: «Awak kay daɣ a imosan ǝmǝnokal ǝn Kǝl-Ǝlyǝhud?» Inn-as Ɣaysa: «Kay iman-nak as tǝnneɣ adi.» ");
INSERT INTO ttq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Inna Bilatǝs i limaman win zawwarnen ǝd tamattay: «Wǝr hǝnnǝyaɣ ǝddǝlil waliyyan a fǝl obazaɣ alǝs a.» ");
INSERT INTO ttq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mišan ǝdgazan wǝllen daɣ tǝɣǝttas-net, gannin: «Ijinǝjǝrwǝy aytedan ǝs sǝssǝɣritan-net daɣ akal ǝn Yahudǝyya ketnet. Issǝnta-du awen daɣ Galilaya har awas d-ewad Yerusalam da.» ");
INSERT INTO ttq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Isla Bilatǝs y esǝm wa n Galilaya ɣas, issǝstan kud Ɣaysa in akal ǝn Galilaya wala. ");
INSERT INTO ttq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","As issan as taɣmar ta n Herod a das-tazzarat, issok-as-tu fǝlas iha Yerusalam daɣ adan en. ");
INSERT INTO ttq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod isidawat-tu wǝllen anay ǝn Ɣaysa, irǝw ira anay-net fǝl ǝddǝlil n aratan win sǝr-ǝs isallu. Igâ deɣ attama n a dat-ǝs agu Ɣaysa tǝlmǝɣjujat. ");
INSERT INTO ttq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ig-as isǝstanan aggotnen, mišan wǝr das-inna Ɣaysa wala. ");
INSERT INTO ttq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","As itaggu awen, imuzaran ǝn limaman ǝd musanan n Ǝttawret ǝllân den, siɣaren da tǝɣǝttas ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A das-itaggu Herod ǝd sojitan-net šisǝssǝlka, taggin daɣ-as tamakkakkayt; ǝzzǝzlagan-tu takatkat tǝknât ǝbǝlǝzlǝz, amaran issoɣal-tu Herod i Bilatǝs. ");
INSERT INTO ttq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eway-du awen ǝzǝl wen da as immedaw Bilatǝs ǝd Herod, id dat awen nimagzaran. ");
INSERT INTO ttq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iššedaw-du Bilatǝs ilimaman win zawwarnen ǝd muzaran ǝn Kǝl-Ǝlyǝhud win hadatnen ǝd tamattay, ");
INSERT INTO ttq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","inn-asan: «Tewayam-du sǝr-i alǝs a, tǝnnam isafallag aytedan. Ǝšraɣaɣ-as dat-wan, mišan wǝr ǝnaya ǝddǝlil waliyyan a fǝl t-ǝbaza daɣ aratan win tu-tǝssǝwaram. ");
INSERT INTO ttq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala deɣ inay-tu daɣ-as Herod, fǝlas issoɣal-anaq-q-id. Amaran ǝnǝyat! Alǝs wa, wǝr iga arat waliyyan a t-issiwaran tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Daɣ adi a das-sǝssuga šiwwit, amaran ayyaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tǝll-ay alɣadat tǝmosat as i d-iɣlay ǝmud wa n Akkay, iwâr Bilatǝs a dasan-ikkǝs awedan iyyan daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jajjayen adakal ǝn maslan-nasan ketnasan daɣ jǝnnawan gannin: «Agu iman n alǝs di, tǝkkǝsaɣ-ana-du Barɣabbas.» ");
INSERT INTO ttq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barɣabbas wen, ǝnǝjǝrway as kala ad t-ǝgan aytedan daɣ ǝɣrǝm n Yerusalam d igi ǝn man n awedan a fǝl iggaz kasaw. ");
INSERT INTO ttq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ilas-asan Bilatǝs awal fǝlas tara a iga ad ayyu Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mišan ǝglan siɣaren daɣ jǝnnawan, gannin: «Taytay-tu fǝl tǝgǝttawt! Taytay-tu fǝl tǝgǝttawt!» ");
INSERT INTO ttq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ig-asan Bilatǝs tǝnna ta n karadat: «Mafel za? Ma iɣšad? Wǝr hǝnnǝyaɣ ǝddǝlil waliyyan a t-issiwaran tǝmattant. Daɣ adi a das-sǝssuga šiwwit ɣas, ayyaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mišan ǝššotan šiɣaraten wǝllen, gammayan daɣ-as ad itǝwǝtǝytǝy Ɣaysa fǝl tǝgǝttawt. Ǝɣlaban Bilatǝs ǝs takat. ");
INSERT INTO ttq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tǝzzar ixtas Bilatǝs i Ɣaysa ǝššǝriɣa wa daɣ-as tǝgmay tamattay ten. ");
INSERT INTO ttq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ikkas alǝs wa daɣ-as gammayan, iggâzan kasaw fǝl ǝnǝjǝrway n aytedan d igi n man n awedan. Ɣaysa amaran, ig-ay daɣ fassan-nasan, y a daɣ-as itǝwǝxkǝm awas ǝran. ");
INSERT INTO ttq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ǝzzǝrgazan sojitan Ɣaysa. Ǝglân dǝr-ǝs as ǝmmǝnayan d alǝs iyyan n ǝɣrǝm ǝn Qǝrwan igân esǝm Simɣon a d-ifâlan šiwǝgas, tǝzzar ǝbazan-tu, sassawayan-tu tǝgǝttawt ta fǝl zʼitǝwǝtǝytǝy Ɣaysa, ilkam-as dǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tǝlkâm-as tamattay tagget, ǝhânat tǝdoden aggotnen a fall-as hallinen, sikalalnat. ");
INSERT INTO ttq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iswad-in daɣ-asnat Ɣaysa, inn-asnat: «Aššet Yerusalam, ayyimat fall-i tala. Kalar alimat fǝl man-nakmat, ǝd maddannǝkmat, ");
INSERT INTO ttq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","fǝlas ǝlkâman adan a daɣ zʼitǝwǝnnu: \"Ǝbbilalnat tǝdoden šin wǝr nǝtilu bararan, ǝd šin ǝs kala wǝr tan-ǝlenat, ǝd šin ǝs kala wǝr ǝsǝnkasnat.\" ");
INSERT INTO ttq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Adan win-di ad annin aytedan y ǝdɣaɣan: \"Bǝrǝjjǝtat fall-ana\", annin i kašwaran: \"Alsiwat-ana\"; ");
INSERT INTO ttq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","fǝlas dad itawagga ǝmazal wa y ašǝk wa ibdagan, wǝdi ma d-innayan wa iqquran?» ");
INSERT INTO ttq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ǝllan meddan den ǝššin ǝn nǝsgufa labasnen s ǝntanay da tiwazargazan s adag ǝn tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","As ewadan sojitan edag igân esǝm Tǝkǝyya, ǝttǝytayan Ɣaysa fǝl tǝgǝttawt, ǝssǝɣtan-tat dǝr-ǝs. Ǝgan awen da i meddan win ǝššin en. Iyyan ǝgan-tu daɣ ǝɣil ǝn Ɣaysa, wa hadan ǝgan-tu daɣ zalgat-net. ");
INSERT INTO ttq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Inna Ɣaysa: «Ya Abba, surǝf-asan; wǝr ǝssenan awa taggin.» Ǝzunan tabdoq ǝn Ɣaysa ǝs tǝšaɣeren. ");
INSERT INTO ttq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamattay tǝbdâd den tǝswâd. Imuzaran amaran ǝgân tamakkakkayt daɣ Ɣaysa, gannin: «Ǝnta wa issǝfsan aytedan, assafset iman-net kud ǝnta a imosan Ǝlmǝsix, Tafrǝnt ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojitan da, ǝgân daɣ-as tamakkakkayt. Tihazan-t-in, tazzalan-as-in bǝnegǝr. ");
INSERT INTO ttq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gannin-as: «Kud kay ǝmǝnokal ǝn Kǝl-Ǝlyǝhud a tǝmosaɣ, tassafsaɣ iman-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ǝttǝytayan deɣ dǝnnǝg-ǝs ǝsǝllum a fǝl iktâb as: «Awa Ǝmǝnokal ǝn Kǝl-Ǝlyǝhud.» ");
INSERT INTO ttq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A das-itaggu iyyan daɣ meddan ǝn jujab ǝn baydagan win dǝgman-ǝs tawataytaynen ark batuten, igann-as: «Wǝrgeɣ kay Ǝlmǝsix? Safsu za iman-nak, tassafsaɣ-ana.» ");
INSERT INTO ttq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Isannarɣam-as wa hadan, inn-as: «Kay tǝksǝda a wǝr tǝge Mǝššina, kay wa obaz ǝššǝriɣa imosan tǝmattant wa t-ibazan? ");
INSERT INTO ttq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nakkanay ǝššǝriɣa wa danaɣ-itawaggan oɣâd, awa dǝr ǝhoran mazalan-nana a danaɣ-itawaxkaman, mišan alǝs wa, ǝnta wǝr iga ark amazal waliyyan.» ");
INSERT INTO ttq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tǝzzar inna i Ɣaysa: «Ɣaysa, aktǝw-i-du as du-tǝqqala taheɣ taɣmar-nak.» ");
INSERT INTO ttq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Inn-as Ɣaysa: «Ǝggǝyeɣ ǝsilakanaɣ-ak as, azalada ad nǝnǝmǝgǝz aljannat nak dǝr-ǝk.» ");
INSERT INTO ttq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Awen itaggu attayan n ammasnazal. Tǝzzar ǝlsanat šiyyay amaḍal ketnet har tǝga tazzar, ");
INSERT INTO ttq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","fǝlas tǝfuk a igmad ǝnnur. Afǝr deɣ wa izammazzayan edag wa zǝddigan ǝd wa ogaran tazdak daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, izzǝrrat daɣ ammas. ");
INSERT INTO ttq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tǝzzar ikkas Ɣaysa ǝmǝsli issohen, inna: «Abba, ǝgeɣ iman-in gǝr fassan-nak.» Inna awen ɣas ǝgmadan-tu man. ");
INSERT INTO ttq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","As inay kabtan ǝn sojitan ǝn Kǝl-Ǝrrum win ǝttǝytaynen Ɣaysa awa igan den, iga tǝmmal i Mǝššina, amaran inna: «Illikan as alǝs wa alɣadil.» ");
INSERT INTO ttq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ǝddêwan aytedan aggotnen den y ad ǝnǝyan awa zʼagin. As t-ǝnayan, ǝqqalan ǝggâtan idmaran-nasan fǝl awa ǝgan man-nasan daɣ ǝɣšud. ");
INSERT INTO ttq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","As itaggu awen, imidawan ǝn Ɣaysa kul, ǝhânat tǝdoden šin das-d-ǝlkamnen harwa daɣ akal ǝn Galilaya, ǝbdâdan sǝdi, ǝswâdan. ");
INSERT INTO ttq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ill-ay alǝs igân Yusǝf ihân Asaggawar wa Zǝwwǝran ǝn muzaran ǝn Kǝl-Ǝlyǝhud, imosan awedan olâɣan n alɣadil. ");
INSERT INTO ttq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ǝnta wǝr irda ǝs tanat ta ǝgan muzaran win, wala deɣ s arat wa igan. Yusǝf wa, in ǝɣrǝm ǝn Kǝl-Ǝlyǝhud igân esǝm Arimatay, amaran igâ attama-net daɣ assa ǝn Taɣmar ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ikka Yusǝf Bilatǝs wa n ǝnaxkim n akal, igraw-du ɣur-ǝs turagat n ad itkǝl taɣǝssa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tǝzzar ikkas-tat-du fǝl tǝgǝttawt, ig-et daɣ šifit, ig-et daɣ ǝzǝkka imosan akazam ǝs wǝr kala a daɣ-as itawagga ǝnǝmmettǝn. ");
INSERT INTO ttq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Awen itaggu daɣ ǝzǝl wa daɣ simutugan aytedan y ǝmud wa n tǝsanfawt, ibukan y ǝnǝtti. ");
INSERT INTO ttq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Šidoden šin d-ǝddewnen ǝd Ɣaysa harwa daɣ Galilaya, ǝlkâmnat i Yusǝf. Ǝnaynat ǝzǝkka d ǝmmǝk was daɣ-as tǝtawagga tǝɣǝssa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ǝqqalnat aɣaywan, tǝzzar ad simutugnat aḍutan ǝzodnen d alwarditan win za tǝwǝnɣǝlnen fǝl tǝɣǝssa-net. As d-ewad ǝzǝl wa n ǝssǝbǝt ǝssǝnfanat, imos awen alwajib n ǝššǝriɣa wa n Ǝttawret. ");
INSERT INTO ttq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","As ǝzǝl wa n alxad, ǝnzaynat tǝdoden šin den s ǝzǝkka ǝn Ɣaysa, ewâynat aḍutan win sammatagnat. ");
INSERT INTO ttq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Osanat-in tǝhunt ta tǝharat ǝzǝkka, tǝtiwasaɣararad, tǝlla den y ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ǝggaznat ǝzzǝka mišan wǝr daɣ-as ǝnaynat taɣǝssa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ǝqqanan ɣafawan-nasnat y awen. Wala a ihogan ǝbdadan-du ǝššin meddan dǝgma-nasnat ǝlsânen isǝlsa bilazlaznen. ");
INSERT INTO ttq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ǝrmaɣnat, oyyanat idmaran s amaḍal, tǝzzar ǝnnan-asnat meddan win ǝššin en: «Mas tǝsaggadmat y i iddâran daɣ nǝmmǝttan? ");
INSERT INTO ttq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Abʼas illa da, inkar-du daɣ tǝmattant. Aktimat-du awa inna harwa iha akal ǝn Galilaya, ");
INSERT INTO ttq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","as inna: \"Ag Aggadǝm ilzâm-tu ad itǝwǝggu daɣ fassan ǝn nasbakkadan, itǝwǝtǝytǝy fǝl tǝgǝttawt, iba-tu, tǝzzar inkǝr-du daɣ tǝmattant ǝzǝl wa n karad.\"» ");
INSERT INTO ttq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Amaran ǝktanat-du awa inna Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ǝfalnat ǝzǝkka, ǝqqalnat ǝssoɣalnat awen kul i nǝmmuzal ǝn Ɣaysa win maraw d iyyan ǝd nalkiman kul win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Šidoden šin ǝmosnat Maryama Madǝl ǝd Taxya ǝd Maryama ta n anna ǝn Yaqub ǝd tǝdoden šiyyad dǝr-ǝsnat ǝddawnen. Ǝntanatay a ǝssoɣalnen aratan win i nǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mišan wǝr sǝr-san ǝlen aratan en almaɣna; adi a fǝl dasnat-wǝr-ǝzzǝgzanan. ");
INSERT INTO ttq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dǝr iga awen da ya, igga-du Butros, ozal s ǝzǝkka. As t-in-osa, iššǝgga daɣ-as, wǝr daɣ-as inay ar šifit, tǝzzar iqqal, iqqân awen eɣaf-net. ");
INSERT INTO ttq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ǝzǝl wen da iman-net ad ǝkkan nalkiman ǝn Ɣaysa ǝššin taɣrǝmt iyyat tǝgât Emayos as tǝlla teklay n ǝššin alwaqan gar-es ǝd Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mišawalan daɣ batu n aratan win ǝganen den kul. ");
INSERT INTO ttq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mišawalan den da as tan-d-ewad Ɣaysa ǝnta iman-net, iddew dǝr-san. ");
INSERT INTO ttq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hannayan-tu mišan wǝr t-ǝzdayan. ");
INSERT INTO ttq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Inn-asan: «Ma daɣ tǝmašawalam da?» Ǝbdadan, tǝwâr tǝkenzert udmawan-nasan. ");
INSERT INTO ttq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inn-as wa daɣ-san igan esǝm Klǝyubas: «Adis kay ɣas daɣ aytedan win ǝhanen Yerusalam a wǝr ǝhen salan n awa daɣ-as igan daɣ adan win?» ");
INSERT INTO ttq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Inn-asan: «Ma daɣ-as igan?» Ǝnnan-as: «Arat wa igrawan Ɣaysa wa n Nazaret, imosan ǝnnǝbi itaggan imazalan d awalan ǝn tǝla tarna dat Mǝššina d aytedan kul. ");
INSERT INTO ttq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sattarmasan-tu limaman win zawwarnen ǝd muzaran-nana, tǝtawaxkam-as tǝmattant, sattaytayan-tu fǝl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nakkanay dat awen, nǝgâ attama n as ǝnta a zʼisǝddǝrfen tamattay n Israyil. Mišan azalada, ǝzǝl n aratan en wa n karad d igi. ");
INSERT INTO ttq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dǝr iga awen da ya, ǝqqânnat tǝdoden-nana šiyyad iɣafawan-nana, ǝnzaynen s ǝzǝkka, ");
INSERT INTO ttq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mišan wǝr daɣ-as ǝnaynat taɣǝssa-net. Ǝqqalnat-du, ǝnnanat nifalalan-asnat angalosan, ǝnnan-asnat iddâr. ");
INSERT INTO ttq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tǝzzar ǝkkan wiyyad daɣ-na ǝzǝkka, osan-in, ǝnayan arat kul wa ǝnnanat tǝdoden en, mišan ǝnta wǝr t-ǝnayan.» ");
INSERT INTO ttq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amaran inn-asan Ɣaysa: «Xa kawanay za aljahilan! Izzǝwwat fall-awan ǝzǝgzan s arat kul wa ǝnnan ǝnnǝbitan daɣ Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wǝrgeɣ Ǝlmǝsix ilzâm âs ad inǝy alɣazab tǝzzar, amaran igrǝw tanaya-net?» ");
INSERT INTO ttq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tǝzzar a tan-isasagru Ɣaysa awa sǝr-ǝs ǝnnan Ǝlkǝttaban kul. Ibaz-du ɣur Ǝlkǝttaban win ǝnnǝbi Musa har win ǝnnǝbitan kul win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","As din-ǝhozan taɣrǝmt ta ǝkkan, issǝkna Ɣaysa as okây. ");
INSERT INTO ttq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mišan ǝwaɣan-tu, ǝnnan-as: «Ɣam ɣur-na fǝlas ǝzǝl igla, ehad ibuk y igi», tǝzzar izzǝbbat ɣur-san. ");
INSERT INTO ttq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","As ǝggazan šin tattay, idkal Ɣaysa tagǝlla, iggoday i Mǝššina, irz-et ikf-asan-tat. ");
INSERT INTO ttq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ǝmmoranat šittawen-nasan alwaq wen da, ǝzdayan-tu, mišan iggaz-asan ǝtǝnkul tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tǝzzar namannan gar-essan: «Zaɣnin awen da fǝl ǝknan man-nana tǝfalawist alwaq wa danaɣ-iššewal daɣ tarrayt, isasagr-ana Ǝlkǝttaban n ǝnnǝbitan.» ");
INSERT INTO ttq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ǝbdadan tamazayt ten da, ǝqqalan Yerusalam. Osan-in inǝmmuzal win maraw d iyyan ǝd nalkiman win hadatnen ǝddewan daɣ adag iyyanda, ");
INSERT INTO ttq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","gannin: «Tidǝt daɣ a imos as Ǝmǝli Ɣaysa inkâr-du daɣ tǝmattant, amaran inifalal i Simɣon.» ");
INSERT INTO ttq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ǝssoɣalan-asan meddan win ǝššin ǝntanay da awa ǝnayan daɣ tarrayt, d ǝmmǝk was t-ǝzdayan alwaq wad irza tagǝlla. ");
INSERT INTO ttq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Harwada ǝššewalan daɣ awen as d-ibdad Ɣaysa iman-net gar-essan, inn-asan: «Alxer fall-awan.» ");
INSERT INTO ttq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ǝgan tǝrǝmmeq zǝwwǝrat, tǝggaz-tan tasa fǝlas ǝɣilan aggǝsuf a hannayan den. ");
INSERT INTO ttq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tǝzzar inn-asan Ɣaysa: «Ma fel tǝššiwašam? Ma fel deɣ tǝgâm aššak? ");
INSERT INTO ttq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ǝnǝyat ifassan-in ǝd daran-in, nak iman-in awa. Ǝdǝsat-i ad tǝnǝyam, fǝlas aggǝsuf wǝr ila taɣǝssa wala iɣasan win as di-tǝhannayam da ǝleq-qan.» ");
INSERT INTO ttq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","As dasan-inna awen, isakn-en ifassan-net ǝd daran-net, ");
INSERT INTO ttq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","mišan ǝglan wǝr daɣ-as ǝkkesan aššak fǝl awa ǝgan daɣ tǝfalawist, ikna deɣ sǝr-san awen ǝsǝmmǝklǝl. Adi a fǝl a dasan-inna: «Awak tǝlâm a itamatšan da?» ");
INSERT INTO ttq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ǝkfan-tu tablalt ǝn kifi tǝŋŋât. ");
INSERT INTO ttq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ibaz-tat, itš-et dat-san. ");
INSERT INTO ttq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dǝffǝr awen inn-asan Ɣaysa: «Ǝntanay da aratan win dawan-ǝnne harwa kawan-ǝheɣ: Aratan kul win fall-i ǝktabnen daɣ Ǝttawret n ǝnnǝbi Musa d Ǝlkǝttaban win hadatnen d Azzabur ǝššil ad andin.» ");
INSERT INTO ttq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Amaran ora iɣafawan-nasan alwaq wen da y ad agrin Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Inn-asan: «Wǝrgeɣ iktâb as, Ǝlmǝsix ad inǝy alɣazab, iba-tu, inkǝr-du daɣ tǝmattant ǝzǝl wa n karad, ");
INSERT INTO ttq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tǝzzar tǝwǝggin salan ǝn tǝtubt s esǝm-net i tǝmattiwen kul fǝl ad ǝgrǝwnat tǝsureft ǝn bakkadan, antu awen daɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kawanay tǝmôsam šigǝyyawen n aratan win. ");
INSERT INTO ttq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Amaran nak a fall-awan du-zǝzzǝbbeɣ Infas wa Zǝddigan s Abba-nin a igan arkawal-net. Daɣ adi ad wǝr tǝgmǝdam aɣrǝm wa da har d-azzabbat Infas wa Zǝddigan, akf-iwan tarna ta du-tǝfalat Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dǝffǝr awen, iddew dǝr-san, ǝgmadan aɣrǝm, har din-ǝhozan taɣrǝmt ta n Betanǝy, tǝzzar idkal ifassan-net, ittar-asan a tan-ikfan albaraka. ");
INSERT INTO ttq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Itattar-asan harwa da as dǝr-san immǝzzay, immǝdkal ǝs jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ǝntanay amaran, as das-ǝssǝjadan, ǝqqalan Yerusalam ǝknân tǝfalawist. ");
INSERT INTO ttq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Faw ǝhân Ehan wa Zǝwwǝran n Ǝlɣibada, ǝmmâlan Mǝššina.");
INSERT INTO ttq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ǝstizarat as d-ixlak Mǝššina ǝddǝnet da Awal ill-ay. Awal illa ɣur Mǝššina, amaran Awal wa imos Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Awal ǝstizarat illa ɣur Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","4","Ixlak-du sǝr-ǝs Mǝššina arat kul; wǝr t-illa arat daɣ ǝddǝnet wa sǝr-ǝs du-wǝr-nǝxlek fǝlas Awal wa ǝnta a ihakkin tǝmǝddurt ta tǝmosat ǝnnur y aytedan. ");
INSERT INTO ttq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Imilawlaw daɣ šiyyay mišan wǝr t-ǝqbelnat. ");
INSERT INTO ttq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Osa-du alǝs iyyan igân esǝm Yaxya, a d-izimazal Mǝššina; ");
INSERT INTO ttq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","imos tǝgǝyya fǝl ad ammagrad s ǝnnur wa, ǝzzǝgzǝnan aytedan kul s aratan win igannu. ");
INSERT INTO ttq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ǝnta iman-net wǝr imos ǝnnur, ǝtǝwǝsǝgla ɣas a d-iga imos tǝgǝyya fǝl ad ammagrad s ǝnnur wa. ");
INSERT INTO ttq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Awal wa ǝnta a imosan ǝnnur wa n tidǝt, wa d-ikkan ǝddǝnet isimǝlǝwlǝw aytedan kul. ");
INSERT INTO ttq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ǝnta a ihan ǝddǝnet, ixlak-kat-du sǝr-ǝs Mǝššina, mišan wǝr tu-tǝqbel ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Osa-du akal-net eges wǝr t-ǝqbelan aytedan-net. ");
INSERT INTO ttq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amaran aytedan kul win t-ǝqbalnen, ǝzzǝgzanan sǝr-ǝs, win di ikf-en almaqam ǝn tišit ǝn bararan ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bararan en ǝlâsan tǝhǝwt. Mišan tǝhǝwt en wǝr tola ǝd ta tǝtawazdayat. Wǝr tǝga ǝs lǝkkum i deran n aggadǝm, wala tanat-net. Kala kalar Mǝššina iman-net as tan-iga bararan-net. ");
INSERT INTO ttq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wa imosan Awal, iqqal awedan ixsar ɣur-na, ikna tǝla n ǝlxurma, imos mǝššis ǝn tidǝt. Nǝsinagra tanaya-net, tanaya ta igarraw Barar a n iyyanda ɣur Abba-net. ");
INSERT INTO ttq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iggǝyyat-as Yaxya, iššewal s afalla ad igannu: «Wa daɣ as ǝhe batu-net, assaɣa wa dawan-ganna: \"A d-asu dǝffǝr-i mišan ogar-i, fǝlas dat-i da ill-ay.\"» ");
INSERT INTO ttq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Awalla ketnana nǝgraw albaraka wǝr nǝla ǝddukad s ǝlxurma-net ikmâlan. ");
INSERT INTO ttq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Fǝlas Mǝššina ikf-anaɣ ǝššǝriɣa daɣ ǝfus ǝn Musa, ǝlxurma ǝd tidǝt amaran osa-du dǝr-san Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wǝr t-illa awedan inâyan Mǝššina, mišan Barar a n iyyanda imosan Mǝššina, illa ɣur Abba, ǝnta a danaq-q-issosanan. ");
INSERT INTO ttq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ǝnta da tǝgǝyya ta iga Yaxya y arat daɣ limaman ǝd Kǝl-Lebi win d-ǝfalnen Yerusalam assaɣa wa tan-du-zammazalan muzaran ǝn Kǝl-Ǝlyǝhud y ad t-ǝssǝstǝnan d awa imos. ");
INSERT INTO ttq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wǝr ugay s a dasan-ajjawwab. Kala kalar idkal ǝmǝsli-net s afalla inn-asan: «Nak wǝr ǝmosaɣ Ǝlmǝsix.» ");
INSERT INTO ttq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ǝnnan-as: «Ma tǝmosa za? Ilyas a tǝmosa?» «Kala kala» inn-asan, «wǝr t-ǝmosa.» «Ǝnnǝbi wa ittǝmalan a tǝmosa?» «Kala kala» inn-asan, «wǝr t-ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tǝzzar ǝnnan-as: «Daɣ adi ma tǝmosa? Ihor a din-nasu aytedan win dana-d-ǝssǝglanen newây-asan aljawab n awa tǝmosa. Daɣ adi ǝmǝl-anaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Inn-asan arat wa inna ǝnnǝbi Isayas irǝw, as inna: «Nak, a imosan wa isaɣaren daɣ ǝsuf igannu: \"Sǝssiɣǝdat abaraqqa y Ǝmǝli.\"» ");
INSERT INTO ttq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aytedan win d-ǝmmozalnen ǝs Yaxya da, ǝhân-tan kǝl taggayt ta n Farisaytan. ");
INSERT INTO ttq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ǝlasan-tu ǝsǝstan ǝnnan-as: «Ma fǝl tǝsalmaɣaɣ aytedan daɣ aman, kay tǝnne wǝr tǝmosaɣ Ǝlmǝsix, wǝr tǝmosaɣ deɣ ǝnnǝbi wa ittǝmalan?» ");
INSERT INTO ttq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Inn-asan: «Nak, aman a daɣ salmaɣa, mišan illa gar-ewwan awedan wǝr tǝzdayam, ");
INSERT INTO ttq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","s ǝnta a du-z-asin dǝffǝr-i, amaran awa di-iga daɣ šigrat, wǝr eweda wala arra ǝn suɣan ǝn ɣateman-net.» ");
INSERT INTO ttq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aratan win kul amaḍal ǝn Betanǝy a daɣ taggan fǝl tagadamayt ta hadat n agarew wa n Yordan s ǝnta a daɣ isalmaɣ Yaxya aytedan. ");
INSERT INTO ttq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","As iga ǝzǝl wa hadan ogga Yaxya Ɣaysa izay-t-idu, tǝzzar inna: «Ǝnta den ajaɣol ǝn Mǝššina wa itakkasan ibakkadan daɣ ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ǝnta as ǝhe batu-net as dawan-ganna: \"Alǝs iyyan a d-asu dǝffǝr-i, mišan ogar-i fǝlas dat-i da ill-ay.\" ");
INSERT INTO ttq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nak iman-in wǝr t-ǝzdaya mišan ose-du ad salmaɣaɣ aytedan daɣ aman, fǝl a d-inǝfilǝl i Kǝl-Ǝlyǝhud.» ");
INSERT INTO ttq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ilas Yaxya tǝgǝyya inna: «Ǝswâda daɣ Infas wa Zǝddigan as d-igmad jǝnnawan, iha šaššelan ǝn tǝdabert, iwar-tu. ");
INSERT INTO ttq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dat awen wǝr t-ǝzdaya, mišan Mǝššina, s ǝnta di-d-izammazalan y ad ǝsalmaɣaɣ aytedan daɣ aman, inn-i: \"Alǝs was tǝnayaɣ Infas wa Zǝddigan as fall-as d-izzǝbbat, alǝs wǝdi ǝnta a zʼisalmaɣan aytedan daɣ Infas wa Zǝddigan.\" ");
INSERT INTO ttq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ǝmǝrǝdda arat wa ǝnayaq-qu ǝs šittawen-in; amaran ǝggǝyye silakanaɣ as alǝs wa ǝnta Barar ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","As iga ǝzǝl wa hadan, iha Yaxya edag wa harwa da, ǝnta ǝd nǝttulab-net ǝššin, ");
INSERT INTO ttq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ogga Ɣaysa as dagma-nasan d-illam, inna: «Ǝnta den, Ajaɣol ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ǝslan nǝttulab win ǝššin a i batu ta iga da, tǝzzar ǝlkaman i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iswad-in Ɣaysa dǝffǝr-ǝs ogg-en ǝlkâman-as, inn-asan: «Mas tǝsaggadam?» Ǝnnan-as «Mǝnid tǝɣsara Ǝššex?» ");
INSERT INTO ttq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Inn-asan «Agliwat-du a tu-tǝnǝyam». Itaggu awen takǝst zagret. Ǝglan ǝddewan dǝr-ǝs, ǝnayan dad illa, tǝzzar ǝssǝndan ɣur-ǝs ǝzǝl. ");
INSERT INTO ttq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Meddan win ǝššin ǝlkamnen i Ɣaysa dǝffǝr tasalay ta ǝgan y awal ǝn Yaxya, esǝm n iyyan daɣ-san Andrawǝs, amadray ǝn Simɣon Butros. ");
INSERT INTO ttq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Immǝnay Andrawǝs d ǝmaqqar-net Simɣon ǝstizarat, inn-as: «Nakkanay nǝmminay d Ǝlmǝsix.» (Almaɣna Kristos.) ");
INSERT INTO ttq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Amaran ilway-tu ǝs Ɣaysa. Iswad Ɣaysa daɣ Simɣon ɣas inn-as: «Kay Simɣon ag Yaxya, ad tagaɣ esǝm Qayfas.» (Esǝm wa ola ǝd wa n Butros, almaɣna-net tǝhunt.) ");
INSERT INTO ttq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","As affaw ira Ɣaysa iki n amaḍal ǝn Galilaya. Immǝnay ǝd Filibus inn-as: «Ǝlkǝm-i.» ");
INSERT INTO ttq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filibus d Andrawǝs ǝd Butros aɣrǝm-nasan iyyanda, esǝm-net Betsayda.) ");
INSERT INTO ttq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Immǝnay Filibus ǝd Natanǝyel inn-as: «Nakkanay nǝmminay ǝd was immǝgrad ǝnnǝbi Musa daɣ Ǝttawret, ǝmmigradan sǝr-ǝs deɣ Ǝlkǝttaban n ǝnnǝbitan, a t-imosan Ɣaysa wa n ag Yusǝf wa n ǝɣrǝm ǝn Nazaret.» ");
INSERT INTO ttq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tǝzzar inn-as Natanǝyel: «Immikkan aɣrǝm ǝn Nazaret a t-id-ǝgmǝd arat ihossayan?» Inn-as Filibus: «Ayaw tǝnǝya.» ");
INSERT INTO ttq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ogga Ɣaysa Natanǝyel izay-t-idu, inna: «Ǝnta den awedan n Israyil wa n tidǝt, wa wǝr iha a imosan tǝlmǝnufǝqa.» ");
INSERT INTO ttq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Inn-as Natanǝyel: «Mǝni awas di-tǝzdaya?» Ijjǝwwab-as Ɣaysa inn-as: «Harwa kay du-wǝr-iɣra Filibus, assaɣa wad tǝlle daw ašǝk wa n fig, da ǝhannayaq-qay.» ");
INSERT INTO ttq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Inn-as Natanǝyel: «Ǝššex, kay a imosan Barar ǝn Mǝššina, tǝmosaɣ ǝmǝnokal n Israyil.» ");
INSERT INTO ttq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Inn-as Ɣaysa: «Tǝzzǝgzana fǝl as dak-ǝnneɣ ǝhannayaq-qay daw ašǝk ǝn fig. Ad tǝnǝyaɣ aratan wiyyad zawwarnen ogarnen wǝdi.» ");
INSERT INTO ttq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Inn-as Ɣaysa deɣ: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as dǝffǝr awa ad tǝnǝyam ijǝnnawan ǝnnolaman tagazzayan sǝr-san angalosan, tazabben-du fall-i nak Ag Aggadǝm.» ");
INSERT INTO ttq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ǝzǝl wa n karad tǝmal-tu tǝkrǝst daɣ ǝɣrǝm ǝn Kâna daɣ amaḍal ǝn Galilaya, tǝh-et anna ǝn Ɣaysa, ");
INSERT INTO ttq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tǝzzar itawaɣra-du Ɣaysa ǝnta da, iddew-du ǝd nǝttulab-net ǝs tǝkrǝst en. ");
INSERT INTO ttq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","As abʼas d-iqqim wala daɣ esmad n alɣanab, tǝnna anna ǝn Ɣaysa y as: «Esmad n alɣanab iɣrad.» ");
INSERT INTO ttq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Inn-as Ɣaysa: «Anna, tǝdi a kam-wǝr-tǝdgǝz. Alwaq-in wǝr d-ewed.» ");
INSERT INTO ttq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tǝnna anna-net i maššaɣalan: «Agat awas dawan-inna kul.» ");
INSERT INTO ttq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ǝskâran den sǝdis tǝkan taggazan aman as taggin Kǝl-Ǝlyǝhud ǝzǝzdǝg imosan alɣadat-nasan. Ǝkkulluk n iyyan itaggaz-tu ǝddukad ǝn temeday ǝn litǝr. ");
INSERT INTO ttq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Inna Ɣaysa i maššaɣalan en: «Ǝdnǝyat itǝkan di aman.» Ǝntanay deɣ ǝdnayan-tan har fayyan. ");
INSERT INTO ttq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Inn-asan amaran: «Ǝlkǝwat daɣ-san ǝmǝrǝdda y ǝmaway ǝn saksas.» Ǝgan awen da. ");
INSERT INTO ttq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","As iram ǝmaway ǝn saksas aman win ǝmmǝttaynen da, ǝqqalan esmad n alɣanab, as wǝr issen iguz wa d-iga, mišan imaššaɣalan win tan-d-ǝlkawnen da ǝssânan, iɣra amazlay, ");
INSERT INTO ttq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","inn-as: «Imǝssǝksas kul esmad n alɣanab wa izodan a garrawan, amaran dǝffǝr as filawasan ad garrawan wa isammakkanan. Eges kay tǝɣbara wa izodan har ǝmǝrǝdda!» ");
INSERT INTO ttq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ǝnta ǝddi tǝlmǝɣjujat tǝmosat alɣalamat ta tazzarat immozal Ɣaysa. Ig-et daɣ ǝɣrǝm ǝn Kâna ta n Galilaya. Isannafalal sǝr-ǝs tanaya-net, tǝzzar ǝzzǝgzanan sǝr-ǝs nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dǝffǝr awen izagaday Ɣaysa, ikka taɣrǝmt ǝn Kafarnahum, ǝnta d anna-net, ǝd mǝdrayan-net, ǝd nǝttulab-net. Wǝr daɣ-as ǝgen ar arat n adan. ");
INSERT INTO ttq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","As d-ihoz ǝmud wa n Akkay imosan amud maqqaran ǝn Kǝl-Ǝlyǝhud, iggǝzzay Ɣaysa ikka Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ogaz-in Ɣaysa daɣ aɣalla wa iɣlayan Ehan wa Zǝwwǝran n Ǝlɣibada, imassatagan ǝn zǝgran, d ayfǝd, ǝd tǝdǝbren, ǝd tǝɣimiten ǝn kǝl sanji. ");
INSERT INTO ttq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iga ǝlǝkkud ǝs ɣunan istaq-qan daɣ afarag en ketnasan, ǝntanay d ayfǝd, ǝd zǝgran, infaz daɣ amaḍal izǝrfan ǝn kǝl sanji, isabbanbay tebǝren-nasan. ");
INSERT INTO ttq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Imassatagan ǝn tǝdǝbren ǝntanay inn-asan: «Ǝkkǝsat awa daɣ adag a, ad wǝr tagim ehan n Abba-nin ǝssuk.» ");
INSERT INTO ttq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ǝktan-du nǝttulab akatab n ǝnnǝbi Dawǝd wa innan: «Tara-nin ehan-nak tǝrɣa daɣ-i šilat ǝn tǝmsay.» ");
INSERT INTO ttq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ǝssǝstanan-tu muzaran ǝn Kǝl-Ǝlyǝhud ǝnnan-as: «Ma tǝmos tǝlmǝɣjujat tas tǝfragaɣ igi-net tǝmosat alɣalamat, tǝsitaddat as tǝleɣ tarrayt n igi n adi?» ");
INSERT INTO ttq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ijjǝwwab-asan Ɣaysa inn-asan: «Jǝbbǝrǝjjǝtat Ehan wa Zǝwwǝran n Ǝlɣibada di, ad t-ǝssǝbdǝda daɣ karad adan.» ");
INSERT INTO ttq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ǝnnan-as: «Ehan wa Zǝwwǝran n Ǝlɣibada di ǝkkozat tǝmǝrwen n awatay ǝd sǝdis a fǝl itawakras. Kay mas tu-za-tǝssǝbdǝda daɣ karad adan?» ");
INSERT INTO ttq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ehan wa Zǝwwǝran n Ǝlɣibada wa immal Ɣaysa da, taɣǝssa-net a sǝr-ǝs issoka. ");
INSERT INTO ttq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","As d-inkar daɣ tǝmattant ǝktan-du nǝttulab-net tǝnna ta iga adi. Ǝzzǝgzanan s Awal ǝn Mǝššina, d awal wa iga Ɣaysa da. ");
INSERT INTO ttq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aytedan aggotnen ǝzzigzanan ǝs Ɣaysa ɣur anay ǝn tǝlmǝɣjujaten šin immozal ǝmosnen alɣalamaten, daɣ adan win iga daɣ Yerusalam ɣur ǝmud wa n Akkay. ");
INSERT INTO ttq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mišan ya Ɣaysa wǝr tan-ifles fǝlas izdây-tan ketnasan, ǝnta ");
INSERT INTO ttq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","wǝr iddǝrar s i das-igan isalan n awedan id wǝr das-iɣber awa ihan ǝwǝl-net. ");
INSERT INTO ttq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ill-ay alǝs iyyan igan esǝm Nikodemos, ihân taggayt ǝn Farisaytan, imos iyyan daɣ muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Osa-du Ɣaysa ahad iyyan inn-as: «Ǝššex-in, nakkanay nǝssân as Mǝššina kay d-izammazalan sǝr-na, a dana-tǝsassaɣra, id wǝr t-illa i zʼagin tǝlmǝɣjujaten šin tǝge ǝmosnen alɣalamaten, ar ǝs tǝdhǝlt ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɣaysa deɣ inn-as: «Ǝggǝyyeɣ ǝsilakanaɣ-ak as: Wǝr t-illa awedan ifrâgan anay ǝn Taɣmar ta n Mǝššina ar s ad ilas tǝhǝwt.» ");
INSERT INTO ttq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Issǝstan-tu Nikodemos inn-as: «Mas zʼilǝs awedan waššaran tǝhǝwt? Ši tǝgat da wǝr ifreg ad ilǝs tewaɣlay ǝn tǝdist n anna-net.» ");
INSERT INTO ttq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Inn-as Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-ak as: awedan wǝr ifreg iguz ǝn Taɣmar ta n Mǝššina ar s ad ihǝw s aman d Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ǝlǝsǝl n aggadǝm iyyan aggadǝm, amaran awedan wa d-igmadan Infas wa Zǝddigan, Infas wa Zǝddigan a daɣ-as innodan. ");
INSERT INTO ttq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Daɣ adi a dak-wǝr-iqqǝn eɣaf as dak-ǝnneɣ: Iwâr-kawan ad tǝlǝsam tǝhǝwt. ");
INSERT INTO ttq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aḍu iggâr sas ira, tǝsalla y ǝmǝsli-net, mišan wǝr tǝssena da d-ifal wala dad ikka. Samal di da a iha awedan wa ihǝwan s Infas wa Zǝddigan.» ");
INSERT INTO ttq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Issǝstan-tu Nikodemos inn-as: «Mǝni tat tǝmǝwit tas zʼagin aratan win di?» ");
INSERT INTO ttq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ijjǝwwab-as Ɣaysa inn-as: «Tǝmosaɣ ǝmusan zǝwwǝran daɣ Israyil eges wǝr tǝssenaɣ aratan win! ");
INSERT INTO ttq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ǝggǝyyeɣ ǝsilakanaɣ-ak as: Nǝtamagrad s awa nǝssan, nǝtagayyat deɣ fǝl awa nǝnay, eges tugayam s ad tǝqbǝlam tǝgǝyya-nana. ");
INSERT INTO ttq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dad wǝr tǝzzǝgzanam s awa dawan-ganna s ǝddǝnet mas za tǝzzǝgzǝnam awa dawan-ganna s alaxirat? ");
INSERT INTO ttq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wǝr t-illa is kala ad inay ijǝnnawan, ar nak Ag Aggadǝm a tan-d-igmadan. ");
INSERT INTO ttq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ǝmmǝk was issǝrgag ǝnnǝbi Musa taššolt fǝl ǝgǝt daɣ taneray, ǝmmǝk wen daɣ as kundaba tawasahake nak Ag Aggadǝm, ");
INSERT INTO ttq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fǝl ad iqqǝl as i sǝr-i izzǝgzanan, ad igrǝw tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Fǝlas, Mǝššina awa iga y ǝddǝnet daɣ tara ikfa Barar-net a n iyyanda fǝl ad iqqǝl as i sǝr-ǝs izzǝgzanan wǝr zʼihlǝk, kalar ad igrǝw tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mǝššina wǝr d-issoka Barar-net ǝddǝnet fǝl a tat-ihlǝk kalar issok-as-tat-du fǝl a sǝr-ǝs tafsu. ");
INSERT INTO ttq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","I sǝr-ǝs izzǝgzanan wǝr ihlek, mišan wa sǝr-ǝs wǝr nǝzzǝgzan ihlâk fǝlas wǝr izzǝgzan s esǝm ǝn Barar a n iyyanda ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ǝddǝlil da wa d-ewayan ahluk: Ǝnnur a d-osan ǝddǝnet, mišan ǝssofan-tu aytedan šiyyay id arak mazalan a taggin. ");
INSERT INTO ttq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Amaran i itaggan tǝkma wǝdi oglaf ǝnnur, wǝr t-id-z-akku fǝlas iksud ad nǝfilǝlan arak mazalan-net ezal a mallan. ");
INSERT INTO ttq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mišan wa itaggan arat wa imosan tidǝt, wǝdi itakka-du ǝnnur, fǝl ad itǝwǝnǝy as ǝmazal-net issind-ay daɣ lǝkkum i Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dǝffǝr awen ikka Ɣaysa ǝd nǝttulab-net amaḍal ǝn Yahudǝyya. Iqqim daɣ-as har iga arat n azzaman ǝnta dǝr-san, isalmaɣ Ɣaysa aytedan daɣ aman. ");
INSERT INTO ttq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yaxya ǝnta da isalmaɣ aytedan daɣ aman daɣ tǝsǝssǝngǝyt ta n Aynon, dagma ǝn Salim, fǝlas ǝllan-tu aman den aggotnen. Tasin-t-idu aytedan isalmaq-qan. ");
INSERT INTO ttq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Arat wa as itaggu Yaxya harwa da wǝr iggez kasaw. ");
INSERT INTO ttq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tǝnkar tǝmazaq gǝr nǝttulab ǝn Yaxya d iyyan daɣ Kǝl-Ǝlyǝhud, daɣ batu ǝn tǝmǝwiten šin as itaggu zazdag. ");
INSERT INTO ttq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ǝkkan Yaxya ǝnnan-as: «Ǝššex-nana, tǝkittǝwa alǝs wa dǝr tǝddewa fǝl afay ǝn Yordan wen sen, s ǝnta as dana-tǝmmǝgrada? Tahannaya! Ǝmǝrǝdda isalmaɣ aytedan daɣ aman amaran ketnasan takkin-tu!» ");
INSERT INTO ttq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Inn-asan Yaxya: «Awedan wǝr zʼigrǝw ar awa t-ikfa Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kawanay iman-nawan tǝggǝyyem-i as ǝnneɣ: \"Wǝr ǝmosaɣ Ǝlmǝsix, ǝtǝwǝzǝmizal ɣas a d-ǝge dat-ǝs.\" ");
INSERT INTO ttq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ǝmazlay da ilan tǝmazlayt, amaran ǝmidi-net wa n ǝnaflis-net, ǝnta a innǝttafan ǝd zǝzlay, issigad den da iqqâl-as. As isla y ǝmǝsli n ǝmazlay igmây-du tǝmazlayt, ad aknu tǝdǝwit. Tǝdǝwit tǝdi za ǝnta a ǝgeɣ, amaran ǝmǝrǝdda tǝnda. ");
INSERT INTO ttq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ittǝyet ǝtǝwǝsǝɣmar-net ifnǝz wa-nin. ");
INSERT INTO ttq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wa d-igmadan afalla, ǝnta a idkalan dǝnnǝg awedan kul, wa ihan ǝddǝnet in ǝddǝnet amaran aratan n ǝddǝnet as itamagrad. Wa d-igmadan ijǝnnawan, idkâl dǝnnǝg awedan kul, ");
INSERT INTO ttq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","iggǝyyat s awa inay d awas isla mišan wǝr t-illa i iqbâlan tǝgǝyya-net. ");
INSERT INTO ttq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wa iqbalan tǝgǝyya-net, isilakan awa inna Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","fǝlas wa d-izammazal Mǝššina, awal ǝn Mǝššina a immal, id Mǝššina a das-igan y Infas wa Zǝddigan tehakkay wǝr nǝla ǝddukad. ");
INSERT INTO ttq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abba ira Barar-net amaran aratan kul ig-en daɣ ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wa izzǝgzanan ǝs Barar ǝn Mǝššina wǝdi igraw tǝmǝddurt ta tǝɣlâlat, amaran wa ugayan s a sǝr-ǝs izzǝgzǝn wǝdi eway-du ǝs man-net alham ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ǝslan Farisaytan as itawannu Ɣaysa igarraw inǝttulab ogarnen win Yaxya isalmaq-qan daɣ aman. (Arat wa imosan tidǝt as Ɣaysa iman-net wǝr isǝlmiɣ awedan waliyyan daɣ aman, inǝttulab-net a salmaɣnen aytedan daɣ aman.) As isla Ɣaysa y awa itaqqalan, igmad amaḍal wa n Yahudǝyya, iqqal Galilaya. ");
INSERT INTO ttq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dad t-ilzam imur n amaḍal wa n Samarǝya, ");
INSERT INTO ttq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","iššokal har ewad aɣrǝm iyyan ǝn Samarǝya igân esǝm Šixar, dagma ǝn tawagost ta ikfa Yaqub barar-net Yusǝf. ");
INSERT INTO ttq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Edag wen ǝnta a iha ǝɣarus ǝn Yaqub. As t-id-ewad Ɣaysa, iddâz ǝšikǝl, tǝzzar iqqim fǝl ǝmi n ǝɣarus, itaggu awen ammasnazal. ");
INSERT INTO ttq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","As ǝkkan nǝttulab-net aɣrǝm y ad d-azzanzin imensewan, tǝwar-du tǝntut ǝn Kǝl-Samarǝya a du-tǝzrâgat anu en. Inn-as Ɣaysa: «Šašw-i-du.» ");
INSERT INTO ttq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tǝnn-as: «Kay tǝmosaɣ iyyan daɣ Kǝl-Ǝlyǝhud tǝgammaya daɣ-i aman, nak tǝmosat iyyat daɣ Kǝl-Samarǝya?» ");
INSERT INTO ttq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Inn-as Ɣaysa: «Ǝnnar tǝssânaɣ arat wa ihakku Mǝššina, tǝssânaɣ deɣ awa ǝmosa nak wa kam-itansayan aman ǝn tassay, tansiyaɣ-i-tan kam, akfaɣ-am-tan deɣ ǝmosan win sidurnen.» ");
INSERT INTO ttq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tǝnn-as tǝntut: «Ǝššex-in, anu i zagren amaran kay wǝr tǝleɣ aga, daɣ adi mǝni du-za-tǝgrǝwaɣ aman win sidurnen di? ");
INSERT INTO ttq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Šigrat a tǝgeɣ ǝmaraw-nana Yaqub a danaɣ-ikfan anu a, išwa aman-net, ǝšwan-tan maddanǝs d aharay-net?» ");
INSERT INTO ttq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Inn-as Ɣaysa: «I išwan aman di, ad t-ilǝs fad iguz, ");
INSERT INTO ttq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mišan i išwan aman win tu-z-akfa wǝdi immizzay ǝd fad, fǝlas a daɣ-as ǝqqǝlan adri ingayan s aman win hakkinen tǝmǝddurt ta tǝɣlalat.» ");
INSERT INTO ttq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tǝnn-as tǝntut: «Šašw-i-du daɣ aman win di, fǝl a di-igmǝd fad, ammazzaya d azarog n anu a.» ");
INSERT INTO ttq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","«Aglu», inn-as Ɣaysa. «Aɣra-du alǝs-nam tǝqqǝlaɣ-i-du da da.» ");
INSERT INTO ttq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tǝnn-as: «Wǝr ǝleɣ alǝs.» Inn-as Ɣaysa: «Tidǝt-nam as tǝnne wǝr tǝleɣ alǝs, ");
INSERT INTO ttq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","fǝlas sǝmmos as kala tan-tǝle, amaran wa ɣur tǝlleɣ ǝmǝrǝdda wǝrgeɣ alǝs-nam. Tidǝt a di-tǝge.» ");
INSERT INTO ttq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tǝzzar tǝnn-as: «Ǝhannayaɣ as kay ǝnnǝbi a tǝmosa. ");
INSERT INTO ttq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Imarwan-nana adɣaɣ a da a fǝl ǝɣbadan Mǝššina, mišan kawanay Kǝl-Ǝlyǝhud tǝnnam Yerusalam a iha adag wa daɣ itawaɣbad Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","«Tantut», inn-as Ɣaysa, «Zǝgzǝn-i, alwaq izay-du a daɣ wǝr za tǝɣabbadam Abba gǝr za fǝl ǝdɣaɣ wa, wala deɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kawanay Kǝl-Samarǝya wǝr tǝzdayam wa tǝɣbadam, nakkanay Kǝl-Ǝlyǝhud nǝzdây wa nǝɣbad, fǝlas efsan iguz wa n Kǝl-Ǝlyǝhud a d-ǝgan. ");
INSERT INTO ttq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mišan alwaq izay-du – amaran osa-du – was inaɣbidan win tidǝt ad ǝɣbǝdan Abba s Infas wa Zǝddigan ǝd tidǝt, fǝlas Abba inaɣbidan win t-ǝɣbadnen ǝs tǝmǝwit tǝdi, ǝntanay a ira. ");
INSERT INTO ttq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mǝššina Infas wa Zǝddigan a imos, amaran inaɣbidan-net ilzâm-tan ad t-ǝɣbǝdan s Infas wa Zǝddigan ǝd tidǝt.» ");
INSERT INTO ttq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tǝnn-as tǝntut: «Ǝssânaɣ as Ǝlmǝsix, itawann-as Kristos, a d-asu. As d-osa a danaɣ-isassagru aratan kul.» ");
INSERT INTO ttq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Inn-as Ɣaysa: «Nak a t-imosan, nak wa dam-iššewalan da.» ");
INSERT INTO ttq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Assaɣat ten da a d-ǝqqalan nǝttulab, iqqan-asan eɣaf ǝmǝšiwal wa iga Ɣaysa ǝd tǝntut. Mišan wǝr tan-iha i ihalan ad t-issǝstǝn, ann-as: «Ma daɣ-as tare?» Madeɣ: «Mas dǝr-ǝs tǝmašawala?» ");
INSERT INTO ttq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tǝzzar toyya-du tǝntut ǝtǝkin-net tǝqqal aɣrǝm tǝnna y aytedan: ");
INSERT INTO ttq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ayewat ad tǝnǝyam awedan a di-imâlan arat kul was kala ad t-ǝge, ifrâg as ǝnta a imosan Ǝlmǝsix!» ");
INSERT INTO ttq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tǝzzar ǝgmadan-du aytedan aɣrǝm ǝkkan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","As itaggu awen inǝttulab gammayan daɣ Ɣaysa ad atšu, gannan-as: «Ǝššex, atšu arat iyyan.» ");
INSERT INTO ttq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Inn-asan: «Imensewan win zʼatša wǝr tan-tǝzdayam.» ");
INSERT INTO ttq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ad tǝnǝmǝnnin nǝttulab gar-essan: «Ǝngǝm ɣas wǝrgeɣ awedan iyyan a das-d-ewayan imensewan?» ");
INSERT INTO ttq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Inn-asan Ɣaysa: «Imensewan-in wǝr tan-imos ar ad ammazala tara ǝn wa di-d-izammazalan, ǝɣrǝdaɣ ǝššǝɣǝl wa daɣ-i iga. ");
INSERT INTO ttq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Awak kawanay wǝr tǝgǝnnim: \"Ǝqqimnat-in ǝkkozat tǝlil y ad tagu ɣarat?\" Nak za ǝnneɣ-awan akniwat ǝzǝggǝzdi ǝn tǝwǝgas ad tǝnǝyam as šiɣaɣanen ǝŋŋanat, wǝr ǝrenat ar ǝmilǝy. ");
INSERT INTO ttq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Awedan wa italayan, wǝdi igraw ǝrruzmatan-net. Šiɣaɣanen šin tǝmǝddurt ta tǝɣlalat a išadaw, fǝl ad ajjayat wa inabbalan ǝd wa italayan tǝdǝwit. ");
INSERT INTO ttq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Fǝlas tidǝt ǝn tǝmajǝq ta tǝnnat: \"Alǝs iyyan inabbal, iyyan italay.\" ");
INSERT INTO ttq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ǝssǝglaq-qawan fǝl ad talǝyam tawagost a daɣ wǝr tǝšɣelam, aytedan wiyyad a daɣ-as ǝšɣalnen, mišan tǝgrawam tǝnfa daɣ ǝššǝɣǝl wa ǝgan den.» ");
INSERT INTO ttq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ǝzzǝgzanan aytedan aggotnen ǝn Kǝl-Samarǝya ǝs Ɣaysa fǝlas tantut a dasan-tǝnnat: «Imâl-i aratan win as kala tan-ǝge.» ");
INSERT INTO ttq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Awen da a fǝlas osan-t-idu ɣas ǝgmayan daɣ-as a ɣur-san aqqam. Iqqim ɣur-san Ɣaysa har iga ǝššin adan. ");
INSERT INTO ttq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ǝslan aytedan y awal-net, ǝzzǝgzanan sǝr-ǝs wiyyad ogarnen winad igǝt. ");
INSERT INTO ttq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tǝzzar ǝnnan i tǝntut: «Nakkanay sǝket nǝkna ǝzǝgzan fǝlas ǝstizarat kam ɣas a danaɣ-igan isalan, ǝmǝrǝdda iman-nana as das-nǝsla, amaran nǝssân as tidǝt as ǝnta a imosan Ǝnǝssefsi n ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","As ǝndan ǝššin adan win den, ikka Ɣaysa amaḍal ǝn Galilaya, ");
INSERT INTO ttq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","fǝlas ǝnta iman-net as inna, ǝnnǝbi wǝr itǝwǝsǝɣmir daɣ aɣrǝm wa daɣ idwal. ");
INSERT INTO ttq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","As din-osa Galilaya ǝqbalan-tu Kǝl-Galilaya id ǝnâyan imazalan kul win iga daɣ Yerusalam ɣur ǝmud wa n Akkay fǝlas ǝntanay da osân-in amud en. ");
INSERT INTO ttq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ilas-du Ɣaysa assa ǝn tǝɣrǝmt ǝn Kâna ta n Galilaya, ta daɣ isammattay aman ig-en esmad n alɣanab. Ill-ay alǝs imosan amaššaɣal n ǝmǝnokal daɣ tǝɣrǝmt ǝn Kafarnahum. Alǝs a ila barar-net irinan. ");
INSERT INTO ttq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","As isla as Ɣaysa igmâd-du amaḍal ǝn Yahudǝyya iha Galilaya, os-ay-du onsay-tu ad idawan, a das-izzuzǝy barar-net a ɣur tǝlla tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Inn-as Ɣaysa: «As wǝrgeɣ ad tǝnâyam alɣalamaten ǝmmittaynen ǝd tǝlmǝɣjujaten, wǝr za tǝzzǝgzǝnam fadda.» ");
INSERT INTO ttq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Inn-as amaššaɣal n ǝmǝnokal: «Ǝmǝli, ǝrǝs-anaɣ ǝs Kafarnahum tarmad harwa ad wǝr aba barar-in.» ");
INSERT INTO ttq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Inn-as Ɣaysa: «Aglu, barar-nak izzay.» Alǝs deɣ izzǝgzan s awal ǝn Ɣaysa, igla. ");
INSERT INTO ttq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iha tarrayt iqqâl as immǝnay ǝd maššaɣalan-net das-d-ǝlkamnen. Ǝnnan-as: «Barar-nak izzay.» ");
INSERT INTO ttq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Issǝstan-tan inn-asan: «Ma imos alwaq wa daɣ igraw iman-net?» Ǝnnan-as: «Ǝndazǝl iggi ǝn tazzar a fall-as tǝwat tanaday.» ");
INSERT INTO ttq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ikta-du alǝs as alwaq wen da iman-net a daɣ-as inna Ɣaysa: «Barar-nak izzay.» Izzǝgzan sǝr-ǝs ǝnta d aɣaywan-net kul. ");
INSERT INTO ttq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ǝnta da da tǝlmǝɣjujat tǝmosat alɣalamat ta n sanatat immozal Ɣaysa daɣ Galilaya dǝffǝr agamad-net Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dǝffǝr adi ewad-du ǝmud iyyan ǝn Kǝl-Ǝlyǝhud, tǝzzar ikka Ɣaysa Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aɣrǝm wa n Yerusalam tǝh-ay tǝɣazart tǝhozat edag was itawannu tǝsǝhǝrt ta n Ayfǝd. Tǝɣazart ta esǝm-net Betsada, daɣ tǝlɣibrit, amaran tǝlla gǝr sǝmmosat taliwen. ");
INSERT INTO ttq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Taliwen šin ǝsrâdan daw-ǝsnat miranan ǝgânen daɣ mǝddǝrɣal, ǝd mǝggudal, ǝd nǝbdan. Ǝssigadan y ad ǝggǝzan aman šin ǝmǝtǝkwǝy, ");
INSERT INTO ttq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","fǝlas immal-tu alwaq a daɣ d-itazabbat angalos iyyan n Ǝmǝli ijǝnnǝjǝrwǝy aman ǝn tǝɣazart ten. Ǝmiran kul wa azzaran iguz-net dǝffǝr ǝnǝjǝrway wa tǝga da, wǝdi ad izzǝy daɣ tǝwǝrna ta tu-tǝgrawat, a tǝqqal. ");
INSERT INTO ttq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Edag en ih-ay alǝs igân karadat tǝmǝrwen n awatay d ǝttam irin. ");
INSERT INTO ttq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ogg-ay Ɣaysa isrâd, amaran issan as iga tǝwǝrna tǝrǝwat, issǝstan-tu inn-as: «Awak tǝre tǝmǝzzǝyt?» ");
INSERT INTO ttq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Inn-as ǝmiran wa: «Ǝššex, nak wǝr ǝleɣ awedan a di-igan daɣ tǝɣazart ta daɣ amazay wa daɣ tinǝjǝrwǝyan aman-net, amaran id ǝgmaya d iguz-net, a di-izar sǝr-ǝs awedan iyyan.» ");
INSERT INTO ttq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Inn-as Ɣaysa: «Ǝbdǝd, tǝdkǝla tǝssut-nak tǝjǝwǝnke» ");
INSERT INTO ttq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Izzay alǝs wen daɣ tamazayt ten da, idkal tǝssut-net ijawankat. Ǝnta arat wa itaggu daɣ ǝzǝl ǝn tǝsanfawt ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ǝnnan muzaran ǝn Kǝl-Ǝlyǝhud y alǝs wa izzayan da: «Kay ak masnat a wǝr tǝgeɣ as azalada ǝzǝl ǝn tǝsanfawt a daɣ-ak wǝr xalal aggay ǝn tǝsalat-nak?» ");
INSERT INTO ttq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eges ya inn-asan alǝs wen: «Alǝs wa di-izzozayan, ǝnta a di-innan: \"Ǝdkǝl tǝsalat-nak tǝjǝwǝnke\".» ");
INSERT INTO ttq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ǝnnan-as: «Ma imos za alǝs wa dak-innan: \"Ǝdkǝl tǝsalat-nak tǝjǝwǝnke\"?» ");
INSERT INTO ttq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ǝnta alǝs wa izzayan da, wǝr t-ǝhen salan n awa imos awedan wa t-izzozayan den, fǝlas aytedan ǝknanen igǝt a ǝhanen edag wa daq-q izzozay Ɣaysa den, iras-tan Ɣaysa, ijawankat. ");
INSERT INTO ttq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dǝffǝr awen ogaz-t-in Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada inn-as: «Sǝsǝm. Kay da izzayan da ǝmǝrǝdda. Ǝɣrǝd d igi ǝn bakkadan, a kay wǝr igrǝw arat ogaran wanad tallabǝst.» ");
INSERT INTO ttq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ijawankat alǝs wen tǝzzar imal i muzaran ǝn Kǝl-Ǝlyǝhud as Ɣaysa a t-izzozayan. ");
INSERT INTO ttq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Arat wa eway-du sǝr-san as ǝknan gezzar ǝn Ɣaysa fǝlas ǝzǝl ǝn tǝsanfawt a daɣ iga awen. ");
INSERT INTO ttq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mišan inn-asan Ɣaysa: «Abba-nin faw da išɣâl, daɣ adi nak da ǝšɣâla.» ");
INSERT INTO ttq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Batu ta, teway-du ǝs muzaran ǝn Kǝl-Ǝlyǝhud as ǝššotan daɣ agamay ǝn tanaɣay ǝn Ɣaysa, fǝlas wǝrgeɣ ǝlqanun n ǝzǝl wa n tǝsanfawt ɣas a immǝzray, kalar iššota-du fall-as as inna imos Mǝššina abba-net. Daɣ adi išaššagda iman-net ǝd Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Inn-asan Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as Barar wǝr ifreg igi n arat waliyyan gar-es ǝd man-net. Wǝr itǝggu ar arat was ihannay Abba-net itagg-ay. Amaran arat kul wa itaggu Abba, Barar da itagg-ay s asaway wen da. ");
INSERT INTO ttq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Fǝlas Abba ira Barar, amaran isakn-ay arat kul wa itaggu; ad t-assaknu aratan ogarnen win da tǝla n almaɣna y a tan-agu, fǝl ad taɣjim. ");
INSERT INTO ttq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ǝmmǝk wa daɣ-as d-isankar Abba inǝmmǝttan itaggu daɣ-san iman, ǝmmǝk wǝdi da as ihakku Barar ǝnta da tǝmǝddurt i was tat-ira. ");
INSERT INTO ttq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wa dǝffǝr adi as Abba wǝr ixǝkkǝm y awedan waliyyan, kalar ǝššǝriɣa kul ig-ay daɣ ǝfus ǝn Barar ");
INSERT INTO ttq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","fǝl ad ǝzzǝzwǝran aytedan kul Barar s ǝmmǝk was ǝzzǝzwaran Abba. Awedan kul wa wǝr nǝzzǝzwar Barar, wǝdi wǝr izzǝzwar Abba wa t-id-izammazalan.» ");
INSERT INTO ttq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ǝggǝyyeɣ ǝsilakanaɣ-awan as awedan kul wa issǝsaman i batuten-in, izzǝgzan ǝs wa di-d-izammazalan, wǝdi igrâw tǝmǝddurt ta tǝɣlalat. Wǝr zʼawwaddab, kalar tǝmattant a d-igmad ǝs tǝmǝddurt.» ");
INSERT INTO ttq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Ǝggǝyyeɣ ǝsilakanaɣ-awan as izay-du alwaq – s ǝnta da da nǝha da ǝmǝrǝdda – as aytedan win sǝr-i wǝr nǝzzǝgzan ad aslin y ǝmǝsli ǝn Barar ǝn Mǝššina, amaran win das-ǝslanen ǝkkǝwanan-as ad ǝgrǝwan tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fǝlas ǝmmǝk wa daɣ as ihakku Abba tǝmǝddurt, ǝmmǝk wǝdi daɣ as ikfa Barar fǝrregat n a tat-ihakku ǝnta da. ");
INSERT INTO ttq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ikf-i deɣ turagat n ǝššǝriɣa y aytedan, fǝlas nak Ag Aggadǝm a mosa. ");
INSERT INTO ttq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ad wǝr ǝqqǝnan ɣafawan-nawan y arat wa: ilkâm a d-awǝd alwaq a daɣ zʼaslin nǝmmǝttan kul daɣ zǝkwan-nasan, y ǝmǝsli-nin nak Ag Aggadǝm ");
INSERT INTO ttq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ǝgmǝdan-du izǝkwan-nasan ǝddi da. Win ǝganen aratan olaɣnen, a d-ǝgmǝdan izǝkwan y a d-ǝnkǝran daɣ tǝmattant ǝgrǝwan tǝmǝddurt, win ǝganen tǝkma amaran a d-ǝgmǝdan izǝkwan y ad awwaddaban. ");
INSERT INTO ttq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Wǝr t-illa arat as ǝfragaɣ igi-net gǝr-i ǝd man-in. Ǝššǝriɣa wa tagga, ǝlkama daɣ-as y awa di-igannu Mǝššina, amaran ǝššǝriɣa-nin oɣâd, fǝlas wǝr ǝlkema y arat wa ǝre nak iman-in, kalar arat wa ira wa di-d-izammazalan as ǝlkama.» ");
INSERT INTO ttq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«As imos as nak ɣas-in as ǝggǝyyeɣ i man-in, wǝdi tǝgǝyya-nin wǝr tǝmos tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Illat-tu wa di-imosan iyyat tǝgǝyya, amaran ǝssânaɣ as arat wa igannu daɣ talɣa-nin, tidǝt a imos. ");
INSERT INTO ttq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tǝssǝglam inammazalan ǝs Yaxya, iggǝyyat-asan fǝl arat wa imosan tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nak wǝr ǝddǝraraɣ ǝs tǝgǝyya n awedan. Arat wa, wǝr tu-gǝnnaɣ ar fǝl ad tǝgrǝwam tǝsureft. ");
INSERT INTO ttq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaxya zun fǝtǝla tǝrɣât tǝbilazlaz a imos, amaran tǝqbalam ad tagim arat n assaɣat ǝn tǝdǝwit daɣ ǝnnur-net. ");
INSERT INTO ttq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nak amaran ǝle tǝgǝyya togarat ta n Yaxya assahat: Ǝššǝɣǝlan win tagga, a tan-imosan win as di-issǝwar Abba igi-nasan, ǝntanay a ǝmosnen tǝgǝyya-nin, sitaddan as Abba di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Abba iman-net s ǝnta a di-d-izammazalan, ǝnta da iggiyyat-i. Wǝr kala ad tǝslam y ǝmǝsli-net wala deɣ tǝnâyam azzat-net. ");
INSERT INTO ttq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Amaran wǝr iha awal-net iwallan-nawan, arat wǝdi isitadd-ay iba n ǝzǝgzan-nawan ǝs wa d-izammazal. ");
INSERT INTO ttq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tǝtaggam y Awal ǝn Mǝššina teɣaray tǝgat s ǝnnǝzǝr fǝlas tǝɣilam a sǝr-ǝs tǝgrǝwam tǝmǝddurt ta tǝɣlalat. Awal wa tǝɣarrim da, ǝnta iman-net as fall-i iggǝyyat, ");
INSERT INTO ttq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","eges wǝr tǝrem a di-du-takkim y ad tǝgrǝwam tǝmǝddurt.» ");
INSERT INTO ttq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Nak wǝr gǝmmǝyaɣ ǝtǝwǝsǝɣmar ɣur aytedan. ");
INSERT INTO ttq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ǝzdâyaq-qawan: ǝssânaɣ as iman-nawan wǝr tan-tǝha tara i Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nak Abba-nin a di-d-issǝglan mišan wǝr tǝrem ǝlqǝbulat-in. Amaran as kawan d-osa awedan iyyan a d-iglân gar-es ǝd man-net, a tu-tǝqbǝlam! ");
INSERT INTO ttq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tǝrâm ad tǝtinǝmǝsǝɣmiram gar-ewwan, eges wǝr tǝrem saɣmar wa d-ifalan Mǝššina di n iyyan. Daɣ adi manǝmmǝk as za tǝzzǝgzǝnam? ");
INSERT INTO ttq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ad wǝr tǝɣilam a kawan-ǝssǝwǝra lahan ɣur Abba-nin. Ǝnnǝbi Musa ǝnta kawan zʼissǝwǝran lahan, ǝnta wa daɣ tǝgam attama-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ǝnnar tǝzzigzanam ǝs Musa, tǝzzǝgzǝnam sǝr-i nak da, fǝlas immigrad sǝr-i daɣ Ǝlkǝttaban-net. ");
INSERT INTO ttq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mišan dad imos as wǝr tǝzzǝgzanam s Ǝlkǝttaban-net, manǝmmǝk as za tǝzzǝgzǝnam awa ganna?» ");
INSERT INTO ttq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Dǝffǝr adi ikka Ɣaysa tǝgadamayt ta hadat n agaraw wa n Galilaya, itâwann-as deɣ agaraw wa n Tiberǝyad. ");
INSERT INTO ttq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tǝlkâm-as tamattay tagget, fǝlas ǝhannayan aytedan alɣalamaten šin as itamazal ǝmosnen ǝmmǝk was izuzǝy imiranan. ");
INSERT INTO ttq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iggǝzzay Ɣaysa adɣaɣ, tǝzzar iqqim den da ǝnta ǝd nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","As itaggu awen amud wa n Akkay ihoz-du. ");
INSERT INTO ttq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iswad Ɣaysa inay tamattay tagget tǝzây-t-idu, inna i Filibus: «Mǝni du-za-nazzanzu tagǝlla ǝtšan aytedan en kul?» ");
INSERT INTO ttq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ǝsǝstan wa as t-iga Ɣaysa da issân arat was otas igi-net. A ira ɣas ad issǝn awa das-z-annu Filibus. ");
INSERT INTO ttq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Inna Filibus i Ɣaysa: «Kud du-nǝzzǝnza tagǝlla ǝn sanatat tǝmad ǝn tafelt, almaɣna alxaq ǝn sanatat tǝmad n ǝzǝl n ǝššǝɣǝl, da wǝr dasan-tǝkna arat.» ");
INSERT INTO ttq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Inn-as ǝnattalib-net igân Andrawǝs wa n amadray ǝn Simɣon Butros: ");
INSERT INTO ttq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Illa barar da ilân sǝmmosat tǝgǝlwen n ǝššǝɣir d ǝššin kifitan, mišan ya ma za aknin y aytedan ogdânen d awa?» ");
INSERT INTO ttq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Inna Ɣaysa: «Saɣɣamiwat tamattay kul.» Tǝzzar ǝqqiman aytedan kul daɣ yel aggen illân den. Sǝmmos gim n alǝs a ǝhanen tamattay en. ");
INSERT INTO ttq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Idkal-du Ɣaysa šigǝlwen šin den. As iga igodan i Mǝššina, izun-tanat i tamattay. Iga awen da i kifitan. Igraw awedan kul awa das-igdan. ");
INSERT INTO ttq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","As ǝyyǝwanan aytedan inna Ɣaysa i nǝttulab-net: «Šidǝwat-du ikarammutan win du-tawaglaznen, fǝl a daɣ-as wǝr iɣšǝd wala.» ");
INSERT INTO ttq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ǝɣradan-du ǝkǝmmi ǝn karammutan win d-ǝglazan aytedan daɣ tǝgǝlwen n ǝššǝɣir šinad ǝn sǝmmosat a. Maraw ǝzmaman d ǝššin a d-ǝdnayan daɣ gǝlzan en. ");
INSERT INTO ttq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","As ǝnayan aytedan win alɣalamat tas immozal Ɣaysa da, ad gannin: «Igmâd aššak as alǝs wa ǝnta a imosan ǝnnǝbi wa du-z-asin ǝddǝnet!» ");
INSERT INTO ttq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Issan Ɣaysa as aytedan win abbaz a tu-z-agin šǝhhǝšǝlan-tu tišit n ǝmǝnokal, ilas-tan efel, ikka edag iyyan daɣ ǝdɣaɣ en da, ɣas-net. ");
INSERT INTO ttq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","As tǝga takǝst zagadayan nǝttulab-net s agaraw, ");
INSERT INTO ttq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ǝggazan aɣlal ǝssǝwalan agaraw y ad ǝɣrǝsan ǝs taɣrǝmt ta n Kafarnahum. Itaggu awen ehad, Ɣaysa amaran wǝr tan-in-ewed harwa da. ");
INSERT INTO ttq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Igar-du aḍu issohen ad tanastaban aman n agaraw. ");
INSERT INTO ttq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","As ǝgan nǝttulab ǝn Ɣaysa edag ǝn sǝmmos kilawtan madeɣ sǝdis n ǝšikǝl, oggan Ɣaysa daɣ ihǝz ijiwankat-du fǝl aman izay-du aɣlal wa han, tǝzzar tǝggaz-tan tasa. ");
INSERT INTO ttq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mišan inn-asan Ɣaysa: «Tǝgmǝdet-kawan tasa, nak awa!» ");
INSERT INTO ttq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gammayan d a t-id-ǝzzugǝzan aɣlal den da, as dǝr-san ewad ǝɣlal edag wa ǝkkan. ");
INSERT INTO ttq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","As ǝzǝl wa hadan tǝgr-in tamattay ta tǝwarat efay n agaraw wen sen as aɣlal iyyanda ɣas a illan den ǝndazǝl, amaran ǝssanan as Ɣaysa wǝr inamaggaz aɣlal wa ǝd nǝttulab-net. Ǝssânan ǝnta da as inǝttulab-net ɣas-nasan as ǝglan. ");
INSERT INTO ttq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ǝnzayan-du wiyyad a d-ǝfalnen aɣrǝm ǝn Tiberǝyad. Osan-du dagma n adag wa daɣ tǝtša tamattay tagǝlla dǝffǝr godan win iga Ɣaysa y Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","As tǝnay tamattay as Ɣaysa wǝr illa den ǝnta wala inǝttulab-net, tǝggaz iɣlalan win den ǝgmayan Ɣaysa ǝs Kafarnahum. ");
INSERT INTO ttq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Osan-t-in fǝl afay n agaraw wa hadan, tǝzzar ǝnnan-as: «Ya Ǝššex, Ǝmmay du-tose da?» ");
INSERT INTO ttq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ig-asan Ɣaysa aljawab wa, inna: «Ǝggǝyye silakanaɣ-awan as wǝr di-tǝsǝggǝdam ar fǝl as tǝtšam tagǝlla har daɣ-as tǝyyǝwanam, wǝrgeɣ aššaddat n ǝgǝrri n almaɣna n alɣalamaten šin ǝmmozala a fǝl di-tǝlkamam. ");
INSERT INTO ttq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayyat ǝššǝɣǝl daɣ agamay ǝn mensewan win ɣaššadnen, gammayat imensewan win wǝr nǝɣǝššǝd, hakkin tǝmǝddurt ta tǝɣlalat. Imensewan win nak Ag Aggadǝm a dawan-tan-z-akfin fǝlas nak a issǝwar Mǝššina di n Abba ejwal wa n taɣmar-net.» ");
INSERT INTO ttq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ǝssǝstanan-tu ǝnnan-as: «Mǝni za arat was danaɣ-iwar a tu-nagu y ad naknu ǝššǝɣǝlan win ira Mǝššina?» ");
INSERT INTO ttq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ijjǝwwab-asan Ɣaysa inn-asan: «Ǝššǝɣǝl wa daɣ-wan ira Mǝššina, wǝr t-imos ar ad tǝzzǝgzǝnam ǝs wa d-issǝgla.» ");
INSERT INTO ttq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ǝlasan-tu ǝsǝstan ǝnnan-as: «Ma tǝmos za alɣalamat ta dana-za-tammazala fǝl a sǝr-ǝk nǝzzǝgzǝn? Ma za taga? ");
INSERT INTO ttq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Imarawan-nanaɣ ǝtšan daɣ taneray amensay wa n Manna. Ǝnta da awa ǝnnan Ǝlkǝttaban daɣ batu tǝdi: \"Iššǝtš-en amensay wa d-ifalan ijǝnnawan.\"» ");
INSERT INTO ttq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Inn-asan Ɣaysa: «Ǝggǝyyeɣ silakanaɣ-awan as wǝrge ǝnnǝbi Musa a kawan-ikfan amensay wa d-ifalan ijǝnnawan. Abba-nin ǝnta kawan-ikfan amensay wa d-ifalan ijǝnnawan, imos amensay wa n tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Fǝlas amensay wa d-ifalan Mǝššina ǝnta a d-igmadan ijǝnnawan, amaran ǝnta a ihakkin tǝmǝddurt y ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ǝnnan-as: «Ǝmǝli, amensay wǝdi hakk-anaq-qu faw.» ");
INSERT INTO ttq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Inn-asan Ɣaysa: «Nak a imosan amensay wa ihakkin tǝmǝddurt ta tǝɣlalat. Wa di-d-ikkan wǝr das-ilkem ad t-iggaz gǝlǝk, amaran wa sǝr-i izzǝgzanan wǝr daɣ-as ilkem ad t-iggaz fad. ");
INSERT INTO ttq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mišan ǝnneɣ-awan: tǝnayam-i eges wǝr tǝzzǝgzanam. ");
INSERT INTO ttq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Awedan kul wa di-ikfa Abba a di-d-asu, amaran wǝr za mǝlǝllǝya fǝl i di-d-ikkan, ");
INSERT INTO ttq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","fǝlas ǝzǝbbi a d-ǝge daɣ ijǝnnawan fǝl ad ammazala s arat wa ira wa di-d-issǝglan, wǝrgeɣ arat wa ǝre nak iman-in. ");
INSERT INTO ttq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ǝnta wa di-d-izammazalan wǝr ira ad ixrǝk awedan waliyyan daɣ win di-ikfa, kalar a ira a tan-d-ǝssǝnkǝra daɣ tǝmattant ǝzǝl a ilkaman. ");
INSERT INTO ttq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Awalla, ǝnta da awa ira Abba-nin: Aytedan kul win di-ǝnaynen nak Barar-net, ǝzzǝgzanan sǝr-i, ǝntanay a zʼǝgrǝwnen tǝmǝddurt ta tǝɣlalat, ǝssǝnkǝraq-qan-du daɣ tǝmattant, ǝzǝl wa ilkaman.» ");
INSERT INTO ttq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tǝzzar ad tigǝtǝntinan Kǝl-Ǝlyǝhud ǝhân batu-net fǝl as inna: «Nak a imosan amensay wa d-igmadan jǝnnawan.» ");
INSERT INTO ttq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Gannin: «Awak awen wǝrge Ɣaysa wa n ag Yusǝf, nǝkna tǝmǝzdǝyt n abba-net d anna-net, manǝmmǝk as du-z-inkǝr ǝmǝrǝdda ad igannu ijǝnnawan a d-igmad?» ");
INSERT INTO ttq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ijjǝwwab-asan Ɣaysa inn-asan: «Ayyiwat ǝgǝtǝntǝn gar-ewwan. ");
INSERT INTO ttq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wǝr t-illa i di-du-z-akkin ar s a t-id-ewây sǝr-i Abba a di-d-issǝglan, nak amaran ǝssǝnkǝraq-q-idu daɣ tǝmattant ǝzǝl wa ilkaman. ");
INSERT INTO ttq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ǝlkǝttaban n ǝnnǝbitan ih-en as: \"Ketnasan a tan-isassaɣru Mǝššina.\" Awedan kul wa islan y Abba, iqbal ǝsǝssǝɣri-net wǝdi a di-d-akku. ");
INSERT INTO ttq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wǝr t-illa is kala ad inay Mǝššina di n Abba ar wa t-id-ifalan. Ǝnta ɣas a t-inayan. ");
INSERT INTO ttq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ǝggǝyyeɣ ǝsilakanaɣ-awan as i izzǝgzanan ad igrǝw tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nak a imosan amensay wa ihakkin tǝmǝddurt. ");
INSERT INTO ttq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Imarawan-nawan ǝtšan Manna daɣ taneray mišan wǝr dasan-igdel awen tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","As iga awen amensay was ganna nak, ijǝnnawan a daɣ d-igmad. I t-itšan wǝr tu-z-iba. ");
INSERT INTO ttq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nak a imosan amensay wa d-igmadan jǝnnawan ihakku tǝmǝddurt. Awedan kul wa itšan amensay wa ad iddǝr har faw. Amaran taɣǝssa-nin a tǝmosat imensewan win zʼakfa fǝl ad tǝgrǝw ǝddǝnet tǝmǝddurt.» ");
INSERT INTO ttq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tǝnkar tamazaq tǝssohet gǝr Kǝl-Ǝlyǝhud ad gannan: «Manǝmmǝk as dana-z-akfu awedan wa taɣǝssa-net natš-et?» ");
INSERT INTO ttq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tǝzzar inn-asan Ɣaysa: «Awalla, ǝggǝyyeɣ ǝsilakanaɣ-awan âs as wǝr tǝtšem taɣǝssa-nin nak Ag Aggadǝm, tašwim deɣ azni-nin, wǝr dawan-tu-tǝlla tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Awedan wa itšan taɣǝssa-nin išwa ǝnta da azni-nin, wǝdi igrâw tǝmǝddurt ta tǝɣlalat, ǝssǝnkǝraq-q-idu deɣ daɣ tǝmattant ǝzǝl a ilkaman. ");
INSERT INTO ttq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Fǝlas taɣǝssa-nin amensay wa n tidǝt a tǝmos, azni-nin deɣ aman ǝn tassay win tidǝt a imos. ");
INSERT INTO ttq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Awedan wa itšan taɣǝssa-nin, išwa deɣ azni-nin, wǝdi irtay dǝr-i, nak deɣ ǝheɣ ǝwǝl-net. ");
INSERT INTO ttq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Abba wa di-d-izammazalan ǝnta ɣur tǝlla tǝmǝddurt, amaran ǝnta a di-tat-ikfan, daɣ adi wa itšan taɣǝssa-nin ad t-ǝssudǝra nak da. ");
INSERT INTO ttq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ǝnta ǝddi da amensay wa d-igmadan ijǝnnawan. Wǝr ola ǝd wa ǝtšan marawan-nawan fǝlas wǝr dasan-igdel adi tǝmattant. Awedan wa t-itšan, wǝdi ad igrǝw tǝmǝddurt ta tǝɣlalat.» ");
INSERT INTO ttq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Arat da da wa inna Ɣaysa daɣ ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud daɣ ǝɣrǝm wa n Kafarnahum. ");
INSERT INTO ttq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","As ǝslan nǝttulab-net aggotnen y arat wa inna da, ǝnnan: «Batu ta ši labasat, izzǝwat ǝzǝgzan-net. Ma ifragan ǝlqǝbulat-net?» ");
INSERT INTO ttq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Issan Ɣaysa daɣ man-net as gitantanan nǝttulab-net gar-essan daɣ talɣa ten, inn-asan: «Ǝngǝm ǝzǝgzan-nawan a tǝdas batu di? ");
INSERT INTO ttq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma za tagim za as di-toggam nak Ag Aggadǝm tagazzaya s adag wa ǝheɣ ǝstizarat? ");
INSERT INTO ttq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Infas wa Zǝddigan a ihakkin tǝmǝddurt. Awedan ǝs tǝɣǝssa-net, wǝr imos wala. Awalan win dawan-ǝgeɣ, Infas a mosan, hakkin deɣ tǝmǝddurt. ");
INSERT INTO ttq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mišan ǝhân-kawan aytedan wǝr nǝzzǝgzan.» Ɣaysa harwa ɣur tizarat da issân win wǝr nǝzzǝgzan, issân deɣ wa tu-z-agin daɣ fassan. ");
INSERT INTO ttq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ilas inn-asan: «Adi da a fǝl dawan-ǝnne: \"Wǝr t-illa i ifragan a di-d-akku ar s ad t-ikfa Abba fǝrregat n adi.\"» ");
INSERT INTO ttq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Den da dǝffǝr-ǝs ifal a ǝggen daɣ nǝttulab-net, ǝɣradan ǝd tidawt-net. ");
INSERT INTO ttq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tǝzzar inna Ɣaysa i nǝttulab win maraw d ǝššin: «Meqqal kawanay da tǝram teklay?» ");
INSERT INTO ttq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Inn-as Simɣon Butros: «Ǝmǝli, ma imos wa za nakku? Kay a itaggan awalan win ǝhakkanen tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nakkanay nǝzzigzan sǝr-ǝk, nǝssân as kay Ǝmizdag a d-ifâlan Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Inn-asan Ɣaysa: «Ak wǝrgeɣ ǝsǝnnǝfrǝn a kawan-ǝge ketnawan, fǝl marawewwan d ǝššin, kuddeɣ âs iyyan daɣ-wan Iblis.» ");
INSERT INTO ttq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Batu ta Yahuza wa n ag Simɣon Isxarǝyuti a fǝl tat-iga Ɣaysa. Fǝlas Yahuza a tu-z-agin daɣ fassan kuddeɣ âs iyyan daɣ nǝttulab win maraw d ǝššin a imos. ");
INSERT INTO ttq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dǝffǝr adi issǝwal Ɣaysa d akal ǝn Galilaya, fǝlas wǝr ira ǝsǝwǝl ǝn wa n Yahudǝyya, id imuzaran ǝn Kǝl-Ǝlyǝhud a gammaynen ǝd tanaɣay-net. ");
INSERT INTO ttq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","As itaggu awen ǝmud ǝn Kǝl-Ǝlyǝhud was itawannu wa n Tǝkarbanen ihoz-du. ");
INSERT INTO ttq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ǝnnan-as mǝdrayan-net: «Ǝfǝl da takka akal wa n Yahudǝyya fǝl ad ǝnǝyan nǝttulab-nak ǝššǝɣǝlan win tǝtagga. ");
INSERT INTO ttq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Awedan as ira fall-as tagu masnat wǝr išǝqqǝl daɣ ǝssir. Dad zama as tǝtaggaɣ aratan ogdanen d awa, wǝdi agu tǝmǝwit ta fǝl tan-z-inǝy awedan kul.» ");
INSERT INTO ttq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","As das-gannin mǝdrayan-net awen da wǝr sǝr-ǝs ǝzzǝgzanan. ");
INSERT INTO ttq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Inn-asan Ɣaysa: «Assaɣat ta-nin harwa da wǝr du-tewed. Kawanay amaran wǝr tǝzlayam assaɣaten. ");
INSERT INTO ttq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wǝr t-illa ǝddǝlil a fǝl kawan-za-tǝgzǝr ǝddǝnet. Nak amaran ǝddǝnet tǝgzâr-i fǝlas tǝgǝyya a ǝmosa y arak mazalan win daɣ-as tagginen. ");
INSERT INTO ttq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akkiwat amud wen kawanay. Nak wǝr t-ǝkke fǝlas assaɣat-in harwa da wǝr du-tewed.» ");
INSERT INTO ttq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","As dasan-iɣrad tǝnna n aratan win, iqqim-du daɣ Galilaya. ");
INSERT INTO ttq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dǝr iga awen da ya as ǝkkan mǝdrayan-net amud, ikk-ay Ɣaysa ǝnta da, eges iki wa zun as iga daɣ ǝssir, fǝlas wǝr issǝkna iman-net y aytedan. ");
INSERT INTO ttq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Itaggu ǝmud den da gammayan-tu muzaran ǝn Kǝl-Ǝlyǝhud gannan: «Ma iga alǝs a?» ");
INSERT INTO ttq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","As itaggu awen tǝnkâr tǝmazaq gǝr aytedan daɣ talɣa ǝn Ɣaysa. Wiyyad za gannan: «Alǝs di olâɣ.» Wiyyad amaran gannan: «Kalar ǝsǝxrǝk fadda a itaggu tamattay.» ");
INSERT INTO ttq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mišan wǝr t-illa awedan ihalan amagrad dat aytedan daɣ talɣa-net, fǝl tǝksǝda ǝn muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","As isaggaraygaray ǝmud ikka Ɣaysa Ehan wa Zǝwwǝran n Ǝlɣibada a daɣ-as isasaɣru. ");
INSERT INTO ttq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ǝsǝssǝɣri wa iqqan iɣafawan ǝn Kǝl-Ǝlyǝhud wǝllen har ǝqqiman gannin: «Wa ak awedan ma t-issosanan aratan win, ǝnta wǝr iɣra?» ");
INSERT INTO ttq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Inn-asan Ɣaysa: «Ǝsǝssǝɣri-nin wǝrge nak a d-ifal, kalar wa di-d-izammazalan a d-ifal. ");
INSERT INTO ttq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Awedan kul wa iran ad ammazal tara ǝn Mǝššina, wǝdi ad issǝn kud ǝsǝssǝɣri-nin ǝnta Mǝššina a d-ifal wala deɣ arat a imos a d-ǝnzama gǝr-i ǝd man-in. ");
INSERT INTO ttq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Awedan wa iššewalan s aratan a d-inzâm gar-es ǝd man-net, wǝdi iman-net as igammay tanaya. Mišan awedan wa išɣalan daɣ ǝsǝnnǝfilǝl ǝn tanaya ǝn wa t-id-izammazalan, wǝdi tidǝt a immal, wǝr daɣ-as t-illa a imosan lahan. ");
INSERT INTO ttq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wǝrgeɣ ikf-iwan ǝnnǝbi Musa Ǝlqanun? Wǝr kawan-iha za i das-ilkâman. Mafel as tǝram a di-tanɣim?» ");
INSERT INTO ttq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ǝnnan-as aytedan: «Kay aggǝsuf a kay-ihan. Ma iran tenaɣay-nak?» ");
INSERT INTO ttq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Inn-asan Ɣaysa: «Nak tǝlmǝɣjujat iyyadda ɣas a ǝge daɣ ǝzǝl ǝn tǝsanfawt, mišan ǝqqanan-as ɣafawan-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kawanay wǝrgeɣ tǝšaqqalam daɣ ǝzǝl ǝn tǝsanfawt fǝlas bararan-nawan a daɣ-as tǝsamankadam? Amaran wǝr fall-awan imos awen lahan, fǝlas ǝnnǝbi Musa a dawan-t-innan – as iga awen imarawan-nana a t-id-ǝssǝntanen, wǝrge Musa. ");
INSERT INTO ttq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ǝnǝyat za, dad imos as itawasamankad barar daɣ ǝzǝl ǝn tǝsanfawt fǝl lǝkkum y ǝššǝriɣa wa n ǝnnǝbi Musa, mafel as kawan-iha alham-in fǝlas ǝgeɣ y awedan ǝzuzǝy ikmâlan daɣ ǝzǝl ǝn tǝsanfawt? ");
INSERT INTO ttq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ad wǝr tǝxakkamam awedan s azzahir-net. Kalar xakkamat ǝs tidǝt.» ");
INSERT INTO ttq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","As t-oggan arat daɣ aytedan win Yerusalam ad gannin: «Awak alǝs wen, wǝrgeɣ ǝnta as ǝran muzaran-nana tenaɣay-net? ");
INSERT INTO ttq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Amaran ǝnta den ǝmǝrǝdda iššewalan den dat awedan kul, wǝr t-illa i das-igannin wala! Awak immikkan imuzaran-nanaɣ a sallakannen as ǝnta a imosan Ǝlmǝsix? ");
INSERT INTO ttq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","As iga awen da za alǝs wa nǝssân akal wa d-igmad, Ǝlmǝsix amaran assaɣa wa du-z-asu ǝnǝfilal ɣas a du-z-agu, wǝr t-illa awedan a issânan da d-igmad.» ");
INSERT INTO ttq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Harwa da isasaɣru Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada as idkal ǝmǝsli-net wǝllen inna: «Tǝzdâyam-i tǝssânam sas d-ǝhe! As iga awen da ya wǝr d-ose gǝr-i ǝd man-in, kalar wa imosan tidǝt a di-d-izammazalan; amaran wǝr tu-tǝzdayam. ");
INSERT INTO ttq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nak ǝzdayaq-qu, fǝlas ǝnta sǝr-wan d-ǝfala, amaran ǝnta di-d-izammazalan.» ");
INSERT INTO ttq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Den da ad ǝgmayan muzaran ǝn tamattay d abbaz-net mišan wǝr tan-iha i t-idasan, fǝlas alwaq-net a du-wǝr-newed harwa da. ");
INSERT INTO ttq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aytedan aggotnen a ǝzzǝgzannen ǝs Ɣaysa daɣ tamattay en, gannin: «Tordâm as kud d-osa Ǝlmǝsix ifrâg ǝsǝkni n alɣalamaten ogarnen šin issǝkna alǝs wa?» ");
INSERT INTO ttq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Arat wa simǝtǝktikan aytedan daɣ tamattay ta, ǝslan-tu Farisaytan. Ǝnkaran limaman win zawwarnen, ǝd Farisaytan ǝssǝglan-du imagazan n Ahan wa Zǝwwǝran n Ǝlɣibada y ad abǝzan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Inn-asan Ɣaysa: «Nak ad agaɣ arat ǝn tamert ǝddewa dǝr-wan, dǝffǝr adi amaran ad zʼakka wa di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A di-tǝgmǝyam mišan wǝr di-za-tǝgrǝwam fǝlas edag wa zʼakka wǝr tǝfregam iki-net.» ");
INSERT INTO ttq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ad tinǝmǝsǝstinan Kǝl-Ǝlyǝhud, gannin: «Ma imos za adag wa zʼakku daq-qu wǝr za nǝgrǝw? Meqqal Kǝl-Ǝlyǝhud win wazawaznen daɣ kallan win tama a zʼakku iggǝz-tan? Meɣ ak aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud a zʼisasaɣru? ");
INSERT INTO ttq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma imos almaɣna ǝn batu ta iga da, as inna: \"A di-tǝgmǝyam mišan wǝr di-za-tǝgrǝwam, fǝlas wǝr tǝfregam iki n adag wa zʼakka\"?» ");
INSERT INTO ttq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","As d-ewad ǝzǝl wa ilkaman n ǝmud wa n Tǝkarbanen, s ǝnta a imosan ǝzǝl wa zǝwwǝran daɣ ǝmud en, ibdad Ɣaysa dat tamattay idkal ǝmǝsli-net inna: «Awedan kul wa iffudan akkiwet-i-du ad ašǝw. ");
INSERT INTO ttq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Awedan kul wa sǝr-i izzǝgzanan \"ad ǝngǝyan gǝrwan n aman win sidurnen daɣ ǝwǝl-net\", s ǝmmǝk was iktab awen daɣ Ǝlkǝttaban.» ");
INSERT INTO ttq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Batu ta iga Ɣaysa den, Infas wa Zǝddigan a sǝr-ǝs issoka, a zʼǝgrǝwan aytedan win sǝr-ǝs ǝzzǝgzannen. Ǝnta azzaman en Infas wa Zǝddigan wǝr itawakfa harwa da fǝlas Ɣaysa a wǝr nǝggez tanaya-net. ");
INSERT INTO ttq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","As isla ades ǝn tamattay en i batuten šin iga Ɣaysa da ǝnnan: «Illikan as alǝs wa ǝnta a imosan Ǝnnǝbi wa ittǝmalan!» ");
INSERT INTO ttq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ǝnnan wiyyad: «Ǝlmǝsix awa!» Ǝnnan-asan wiyyad: «Manǝmmǝk as du-z-igmǝd Ǝlmǝsix Galilaya? ");
INSERT INTO ttq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Awak Ǝlkǝttaban wǝrgeɣ a ǝnnan: \"Ǝzzurrǝyya ǝn Dawǝd, ǝd tǝɣrǝmt ǝn Betalxam s ǝnta as kala daɣ-as iɣsar Dawǝd, a du-z-igmǝd Ǝlmǝsix.\"» ");
INSERT INTO ttq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ǝmmǝk en daɣ as tǝmmǝzray tamattay daɣ talɣa ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wiyyad daɣ-san ǝrân abbaz-net, mišan wǝr tan-iha is t-idas ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ǝglan magazan n Ahan wa Zǝwwǝran n Ǝlɣibada ǝqqalan ilimaman win zawwarnen, ǝd Farisaytan. Osan-in ɣas ǝnnan-asan: «Mafel wǝr t-idu-tewayam?» ");
INSERT INTO ttq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ǝnnan-asan magazan: «Wǝr kala itawanay awedan igan awal wa iga alǝs en.» ");
INSERT INTO ttq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ǝnnan-asan Farisaytan: «Daɣ adi kawanay da toyyam iman-nawan tǝtawasaxrakam? ");
INSERT INTO ttq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ǝssǝnat ill-ay i sǝr-ǝs izzigzanan daɣ-na? ");
INSERT INTO ttq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wǝr sǝr-ǝs izzǝgzan ar tamattay n aljahilan wǝr nǝssen wala daɣ awa ihan ǝššǝriɣa n Ǝttawret, as ketnasan tǝwâr-tan tulɣant.» ");
INSERT INTO ttq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Inn-asan Nikodemos imosan iyyan daɣ Farisaytan s ǝnta din-osan Ɣaysa dat awen: ");
INSERT INTO ttq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ǝššǝriɣa-nana wǝr t-iha ad itǝwǝxkǝm awedan iket wǝr iššewal, itǝwǝssǝn awa daɣ iššokal.» ");
INSERT INTO ttq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ǝnnan-as: «Galilaya kay tǝlat kay da? Aknu teɣaray n Ǝlkǝttaban ad tǝnǝya kay iman-nak as wǝr t-illa ǝnnǝbi a du-z-igmǝdan Galilaya.» ");
INSERT INTO ttq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tǝzzar ikka awedan kul ehan-net. ");
INSERT INTO ttq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ikka Ɣaysa adɣaɣ as itawannu wa n Eškan ǝn Zaytun. ");
INSERT INTO ttq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","As affaw aɣôra iqqal Ehan wa Zǝwwǝran n Ǝlɣibada, tǝzzar tǝkk-ay-du tamattay ketnet. Iqqim a tan-isasaɣru. ");
INSERT INTO ttq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iššewal den da as d-osan musanan n Ǝttawret ǝd Farisaytan ewâyan tantut a d-ǝɣdaran tǝtaggu ǝzzǝna. Ǝssǝbdadan-tat dat awedan kul, ");
INSERT INTO ttq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ǝnnan i Ɣaysa: «Ya Ǝššex-nana, tantut a ǝzzǝna a tǝga, amaran tǝtiwanay tǝtagg-ay. ");
INSERT INTO ttq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Daɣ Ǝttawret za a inna Musa: \"Tantut zun ta, ilzâm a tat-ǝggaran aytedan ǝs tǝhun har tat-iba.\" Amaran kay ma tǝnne?» ");
INSERT INTO ttq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Arat wa tǝmǝrkest a imos a das-ǝgân fǝl ad t-ǝssǝwǝran lahan. Edag ân a dasan-ajjawwab Ɣaysa, inaz ad ikattab s adad-net fǝl amaḍal. ");
INSERT INTO ttq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ǝqqiman ǝdgâzan-tu s ǝsǝstan, as ihog ibdad-du inn-asan: «Inkǝret-du daɣ-wan was kala wǝr iga abakkad izaret ǝs taggor-net.» ");
INSERT INTO ttq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ilas enez ad ikattab s adad-net fǝl amaḍal. ");
INSERT INTO ttq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ǝslan i batu ta ɣas, mazazaran ǝglan, azzaran-asan win waššarnen. Iqqim-du Ɣaysa ɣas-net ǝnta ǝd tǝntut ta nad, tǝbdâd dat-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ibdad-du inn-as: «Tantut, ma ǝgan aytedan win kam-ǝbaznen? Wǝr tan-iha i kam-ibâzan s ǝššǝriɣa?» ");
INSERT INTO ttq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tǝnn-as: «Waliyyan daɣ-san, Ǝmǝli-nin». Inn-as Ɣaysa: «Nak da za wǝr kam-z-abǝza s ǝššǝriɣa. Aglu tǝjǝwǝnke, mišan ad wǝr tǝlǝsaɣ igi ǝn bakkadan.» ");
INSERT INTO ttq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ilas Ɣaysa awal i tamattay inna: «Nak a imosan ǝnnur n ǝddǝnet. Daɣ adi wa di-ilkaman ad igrǝw ǝnnur wa isiduran, amaran iɣrâd d ad ijiwankat daɣ šiyyay.» ");
INSERT INTO ttq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ǝnnan-as Farisaytan: «Tǝgǝyya ǝn man-nak a tǝmosa, arat wa tǝgannaɣ ǝddi irkam wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Inn-asan Ɣaysa: «Kud imos as tǝgǝyya ǝn man-in a mosa da tǝgǝyya-nin tidǝt a tǝmos fǝlas ǝssâna sas d-ǝhe, ǝd sas ǝdaga. Kawanay amaran wǝr tǝssenam sas d-ǝhe, wala sas ǝdaga. ");
INSERT INTO ttq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kawanay azzahir ɣas as tǝšarraɣam aytedan, nak amaran wǝr šǝrrǝɣa waliyyan. ");
INSERT INTO ttq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","As iga awen da as fall-i d-osa adi, ad šarraɣa, amaran ǝššǝriɣa-nin issohat, fǝlas iddew dǝr-i Abba wa di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ǝššǝriɣa-nawan iktâb daɣ-as âs tǝgǝyya n ǝššin meddan a tǝmosat tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nak za tǝgǝyya iyyadda a mosaɣ i man-in, tǝgǝyya-nin ta n sanatat amaran Abba s ǝnta di-d-izammazalan a tat-imosan.» ");
INSERT INTO ttq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tǝzzar ǝnnan-as: «Mǝnid illa za Abba-nak?» Inn-asan Ɣaysa: «Wǝrmad di-tǝzdâyam za wǝr tǝzdayam Abba-nin. Ǝnnar di-tǝzdâyam tǝzdǝyam Abba-nin.» ");
INSERT INTO ttq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Batuten šin itagg-enat Ɣaysa assaɣa wa daɣ isasaɣru daɣ Ahan wa Zǝwwǝran n Ǝlɣibada dagma n adag wa iha ǝssǝnduq wa daɣ tiddawnat tǝkutawen. Mišan wǝr t-illa i igmâyan d abbaz-net fǝlas alwaq-net a du-wǝr-newed harwa da. ");
INSERT INTO ttq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ilas Ɣaysa inn-asan: «Nak teklay a zʼaga. A di-tǝgmǝyam amaran a kawan-iba daɣ tišit ǝn nasbakkadan. Wǝr tǝfregam a din-tawǝdam edag wa ǝkke.» ");
INSERT INTO ttq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ad tinǝmǝnnin arat daɣ Kǝl-Ǝlyǝhud gar-essan: «Meqqal iman-net a zʼanɣu, fǝlas a inna wǝr nǝfreg a din-nawǝd edag wa ikka.» ");
INSERT INTO ttq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Inn-asan Ɣaysa: «Kawanay aytedan n ares a tǝmosam, nak in afalla. Kawanay kǝl ǝddǝnet a da a tǝmosam, nak wǝr di-tǝla ǝddǝnet a. ");
INSERT INTO ttq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A di da a fǝl dawan-ǝnne a kawan-iba daɣ tišit ǝn nasbakkadan. As wǝr tǝzzǝgzanam as nak a imosan \"Wa Illan da\", wǝdi a kawan-iba ǝd tišit ǝn bakkadan.» ");
INSERT INTO ttq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ǝnnan-as: «Ak ma tǝmosaɣ?» Inn-asan Ɣaysa: «Awa dawan-ǝmala ɣur tizarat har ǝmǝrǝdda ǝnta a mosa. ");
INSERT INTO ttq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ǝllân-tu aratan aggotnen as ǝfrâgaɣ a tan-anna daɣ talɣa-nawan, ǝllân-tu deɣ aratan aggotnen as ǝfrâgaɣ a kawan-awwaddaba fall-asan. Mišan wa di-d-izammazalan mǝššis ǝn tidǝt a imos, amaran arat wa di-d-inna, ɣas a ǝmmala y ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wǝr ǝgren as batu n Abba a daɣ dasan-immǝgrad. ");
INSERT INTO ttq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Inn-asan Ɣaysa: «As tǝgam iman-in nak Ag Aggadǝm s ǝsǝhhuki wa di-za-tagim fǝl tǝgǝttawt, ad tǝssǝnam as nak da a imosan \"Wa Illan da\", tǝssǝnam deɣ as wǝr t-illa a tagga gǝr-i ǝd man-in, arat wa di-isassaɣra Abba ɣas a ganna. ");
INSERT INTO ttq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wa di-d-izammazalan iddew dǝr-i. Wǝr di-oyya ɣas-in fǝlas faw da arat wa das-igrazan ɣas a tagga.» ");
INSERT INTO ttq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ǝslan aytedan aggotnen y awa inna Ɣaysa den ǝzzǝgzanan sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Inna Ɣaysa i Kǝl-Ǝlyǝhud win sǝr-ǝs ǝzzǝgzannen: «As tǝbbǝrdagam y awa kawan-sassaɣra, ad tǝqqǝlam inǝttulab-in win tidǝt, ");
INSERT INTO ttq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","tǝssǝnam tidǝt, tidǝt amaran ǝnta kawan-za-tǝsaddarfit.» ");
INSERT INTO ttq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ǝnnan-as: «Nakkanay ya ǝzzurrǝyya n ǝnnǝbi Ibrahim a nǝmos, wǝr kala daɣ ǝddǝnet ad nǝqqal eklan ǝn waliyyan, mafel tǝganna: \"Ad taddarfem\"?» ");
INSERT INTO ttq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Inn-asan Ɣaysa: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as awedan kul wa itaggin ibakkadan, wǝdi akli ǝn bakkadan a imos. ");
INSERT INTO ttq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Akli amaran wǝr das-t-illa adag ǝn faw daɣ aɣaywan, mišan Barar wa eraw aɣaywan wǝdi edag-net ill-ay har faw. ");
INSERT INTO ttq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Daɣ adi as kawan-isaddarfat Barar, wǝdi ad taddarfem ǝs tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ǝssânaɣ as ǝzzurrǝyya n Ibrahim a tǝmosam, mišan tǝgammayam d ad tagim iman-in fǝlas awal-in a wǝr nǝdes iwallan-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nak arat wa ǝnaya ɣur Abba-nin a ǝmmala, amaran kawanay tǝtaggim awas tǝslam ɣur abba-nawan Iblis.» ");
INSERT INTO ttq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ǝnnan-as: «Abba-nana ya ǝnnǝbi Ibrahim a t-imosan.» Inn-asan Ɣaysa: «Ǝnnar tidǝt âs tǝmosam bararan n Ibrahim ad tǝtaggim imazalan win iga Ibrahim. ");
INSERT INTO ttq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kawanay amaran ǝmǝrǝdda tǝgammayam ǝd tanaɣay-nin, nak imosan awedan a dawan-immalan tidǝt s ǝmmǝk was di-tat-d-inna Mǝššina. Arat wǝdi wǝr t-iga Ibrahim. ");
INSERT INTO ttq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Imazalan win iga abba-nawan a tǝtaggam.» Ǝnnan-as: «Nakkanay wǝr nǝmos iniba; wǝr nǝla ar abba iyyanda a t-imosan Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Inn-asan Ɣaysa: «Ǝnnar Mǝššina a imosan Abba-nawan tarim-i, fǝlas Mǝššina a d-ǝgmada, ǝnta a d-ǝfala, wǝrge gǝr-i ǝd man-in as d-ose, kalar ǝnta di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mafel wǝr tǝgrem awal-in? Wǝr dawan-igdel ǝgǝrri-net ar as wǝr tǝfregam ǝsǝsǝm y as. ");
INSERT INTO ttq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wǝr tǝlem daɣ abbatan ar Iblis, amaran tǝrâm ad tassandim deranan n abba-nawan. Harwa ɣur ǝnǝtti ad iqqal ǝmǝggi ǝn man, amaran wǝr ibded daɣ tidǝt, fǝlas wǝr tǝha tidǝt ǝwǝl-net. Igi ǝn bahu a imosan ǝttǝbiɣat-net fǝlas anasbahu a imos, imos deɣ abba ǝn bahu. ");
INSERT INTO ttq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nak amaran tidǝt as tamagrada, adi da fǝl di-wǝr-tǝzzǝgzanam. ");
INSERT INTO ttq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mǝni daɣ-wan wa ifragan ad aggayyat as kala ad ǝgeɣ abakkad? Kud tidǝt a ǝmmala mafel wǝr di-tǝzzǝgzanam? ");
INSERT INTO ttq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Awedan imosan arat daɣ tamattay ǝn Mǝššina, ǝsǝsǝm a itaggu y awa inna Mǝššina. Kawanay amaran wǝr das-tǝsǝsimam, fǝlas wǝr tǝmosam tamattay ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tǝzzar ǝnnan Kǝl-Ǝlyǝhud i Ɣaysa: «Wǝrgeɣ kala ad nǝnna kay iyyan daɣ Kǝl-Samarǝya a tǝmosaɣ amaran ih-ik aggǝsuf?» ");
INSERT INTO ttq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Inn-asan Ɣaysa: «Wǝr di-iha aggǝsuf, Abba-nin ɣas a ǝssǝɣmara, kawanay amaran wǝr di-tǝssǝɣmaram. ");
INSERT INTO ttq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wǝr gǝmmǝyaɣ tanaya i man-in. Ill-ay wa di-igammayan tanaya, amaran ǝnta a ixakkaman. ");
INSERT INTO ttq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ǝggǝyyeɣ ǝsilakanaɣ-awan as awedan wa ittafan awal-in, wǝr ilkem ad inay tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ǝnnan-as arat daɣ Kǝl-Ǝlyǝhud: «Ǝmǝrǝdda ad nǝkkas aššak as ih-ik aggǝsuf! Ibrahim da aba-tu ǝnta harkid ǝnnǝbitan kul, kay amaran tǝganna: \"Awedan kul wa ittafan awal-in, wǝr ilkem ad inay tǝmattant.\" ");
INSERT INTO ttq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abba-nanaɣ Ibrahim dâ aba-tu: tordeɣ as togaraq-qu almaqam? Ǝnnǝbitan dâ aba-tan. Kay ma tǝxsabaɣ iman-nak?» ");
INSERT INTO ttq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Inn-asan Ɣaysa: «As imos as iman-in a fǝl sanamala, wǝdi tanaya-nin wǝr tǝnfa wala. Abba-nin s ǝnta as tǝgannim imos Ǝmǝli-nawan, ǝnta a di-ihakkan tanaya, ");
INSERT INTO ttq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","amaran wǝr tu-tǝzdayam, mišan nak ǝzdâyaq-qu. As ǝnne wǝr t-ǝzdaya, wǝdi ad ǝqqǝlaɣ anasbahu ǝn šilat-nawan. Kalar ǝzdâyaq-qu, amaran ǝttâfaɣ awal-net. ");
INSERT INTO ttq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abba-nawan Ibrahim imâl-tu ǝd tǝdǝwit fǝl as das-igmad aššak as ad inǝy assa-nin, amaran inay-tu, ikn-ay awen ǝsǝffǝliwǝs.» ");
INSERT INTO ttq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ǝnnan-as Kǝl-Ǝlyǝhud: «Kay wǝr teweda wala sǝmmosat tǝmǝrwen n awatay eges tǝnne tǝnâyaɣ Ibrahim?» ");
INSERT INTO ttq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Inn-asan: «Ǝggǝyye silakanaɣ-awan as dat tǝhǝwt n ǝnnǝbi Ibrahim da nak ǝmosa \"Wa Illan da\".» ");
INSERT INTO ttq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tǝzzar ad takammen šihun y a das-agin zabaw, mišan ya igmad-tan daɣ tamattay, irdaɣ afarag n Ahan wa Zǝwwǝran n Ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ijiwankat Ɣaysa as inay alǝs s as d-ihǝw da iddirɣal. ");
INSERT INTO ttq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ǝssǝstanan-tu nǝttulab-net ǝnnan-as: «Ǝššex, mafǝl d-ihǝw alǝs a ǝd taddarɣalt? Awak ǝddǝlil n abakkad-net, meɣ ak abakkad ǝn marwan-net?» ");
INSERT INTO ttq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Inn-asan Ɣaysa: «Wǝrmad iddirɣal fǝl ǝddǝlil n abakkad-net, wala deɣ abakkad ǝn marwan-net. Wǝr d-ihǝw ǝd taddarɣalt ar y a sǝr-ǝs tǝwǝnǝyan igitan ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iwâr-anaɣ ad naknu ǝššǝɣǝlan ǝn wa di-d-izammazalan iket di ad iga azal, fǝlas ehad izay-du, amaran wǝr t-illa i daɣ-as ifragan ǝššǝɣǝl. ");
INSERT INTO ttq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iket ǝheɣ ǝddǝnet ǝmosaɣ ǝnnur n ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","As iga batu ta, issotaf daɣ amaḍal, iga arat ǝn talaq ǝs mǝtman-net, issǝlal-tat i šittawen n ǝmǝdderɣǝl en, ");
INSERT INTO ttq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","inn-as: «Aglu takka tǝɣazart ta n Siloxam tǝšširǝda daɣ-as udǝm-nak.» (Siloxam almaɣna-net anammazal.) Igla ǝmǝdderɣǝl iššorad udǝm-net, as d-iqqal da ihannay. ");
INSERT INTO ttq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ad gannin mahharagan-net, d aytedan win t-ǝnaynen dat awen imos ǝmǝdderɣǝl itansayan: «Ak awen wǝrgeɣ alǝs was faw iqqim itansay?» ");
INSERT INTO ttq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wiyyad gannin: «Ǝnta daɣ awen.» Wiyyad ǝnta da gannin: «Kala, tulat ɣas a dǝr-ǝs iga.» Ǝnta amaran igannu: «Nak daɣ awa.» ");
INSERT INTO ttq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","A tu-sastanan gannan-as: «Mǝni tǝmǝwit tas tǝgrawaɣ asawad-nak?» ");
INSERT INTO ttq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Igann-asan: «Alǝs as gannin Ɣaysa, a igan arat ǝn talaq, tǝzzar issǝlal-tat i šittawen-in, inn-i ad aglaɣ ǝšširǝdaɣ udǝm-in daɣ tǝɣazart ta n Siloxam. Ǝgleɣ ǝššoradaq-qu ɣas, ǝgrawaɣ asawad-in.» ");
INSERT INTO ttq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ǝnnan-as: «Ma iga za alǝs wǝdi?» Inn-asan: «Wǝr ǝssena». ");
INSERT INTO ttq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ǝlwayan aytedan win alǝs was kala ad imos ǝmǝdderɣǝl da ǝs Farisaytan. ");
INSERT INTO ttq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ǝnta ǝzǝl ǝn tǝsanfawt ǝn Kǝl-Ǝlyǝhud a daɣ iga Ɣaysa talaq, issǝswad ǝmǝdderɣǝl wen. ");
INSERT INTO ttq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A tu-sastanan Farisaytan ǝntanay da ǝd tǝmǝwit tas igraw asawad-net. Inn-asan: «Arat ǝn talaq a issǝlal šittawen-in, ǝššoradaɣ udǝm-in, ǝswada.» ");
INSERT INTO ttq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ad gannin arat daɣ Farisaytan: «Alǝs wa igan arat wa, wǝr d-ifel Mǝššina fǝlas wǝr isassahat ǝzǝl ǝn tǝsanfawt-nana.» Ǝnnan wiyyad: «Alɣalamaten šin, manǝmmǝk as tanat-z-agu awedan imosan anasbakkad?» Tǝzzar iga ǝmǝzrǝy gar-essan. ");
INSERT INTO ttq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ǝlasan ǝsǝstan n alǝs was kala ad iddǝrɣal ǝnnan-as: «Kay a innan izzozay-kay alǝs daɣ taddarɣalt, ǝmǝl-anaɣ was tordeɣ as imos-tu.» Inn-asan: «Ǝnnǝbi a imos.» ");
INSERT INTO ttq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ǝglan Farisaytan wǝr ǝzzǝgzanan as alǝs wa kala ad iddǝrɣal har du-sassaɣran imarwan-net. ");
INSERT INTO ttq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ǝnnan-asan: «Ak ǝnta da da barar-nawan was tǝnnam as d-ihǝw da iddirɣal? Mǝni tǝmǝwit tas igraw asawad-net ǝmǝrǝdda?» ");
INSERT INTO ttq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ǝnnan-asan marwan n alǝs: «Nǝssân as barar-nanaɣ a imos, nǝssân ǝnta da âs as d-ihǝw da iddirɣal, ");
INSERT INTO ttq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","mišan wǝrmad nǝssân tǝmǝwit tas igraw asawad-net, za wala deɣ awedan wa t-issǝswadan. Sǝstǝnat-tu iman-net, fǝlas alǝs waššaran a imos ifragan ad ammagrad daɣ talɣa ta tu-tǝqqalat.» ");
INSERT INTO ttq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Batu ta wǝr tat-ǝgen marwan-net ar fǝl tǝksǝda ǝn muzaran ǝn Kǝl-Ǝlyǝhud fǝlas tǝnna a gan awedan kul wa iggǝyyen as Ɣaysa a imosan Ǝlmǝsix, wǝdi ad t-ǝkkǝsan daɣ ǝljǝmaɣat n ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Awen da fǝl ǝnnan marwan-net: «Tušaray-net tǝšišawad-tu a dawan-ammagrad daɣ talɣa ta tu-tǝqqalat, sǝstǝnat-tu.» ");
INSERT INTO ttq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ǝlasan-du Farisaytan teɣaray n alǝs was kala ad iddǝrɣal ǝnnan-as: «Iksad Mǝššina tǝmǝla tidǝt. Nakkanay nǝssân as alǝs di anasbakkad.» ");
INSERT INTO ttq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Inn-asan alǝs wa: «Nak wǝr ǝssena kud anasbakkad a imos wala. Arat iyyanda ɣas a daɣ ǝssana, as kala ad ǝddǝrɣala, ǝmǝrǝdda ǝhannaya.» ");
INSERT INTO ttq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dǝffǝr awen ǝnnan-as: «Ma imos arat wa dak-iga? Mǝni tǝmǝwit tas kay-issǝswad?» ");
INSERT INTO ttq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Inn-asan: «Arat wǝdi ya ǝmâlaɣ-awan-tu mišan wǝr di-tǝzzǝgzanam. Mafǝl tǝram a dawan-t-ǝlǝsaɣ emel? Meqqal ak kawanay da a tǝram ad tǝqqǝlam inalkiman-net ketnawan?» ");
INSERT INTO ttq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ǝgan-as ǝrrǝbdan ǝnnan-as: «Kay a imosan ǝnalkim-net, nakkanay inalkiman n ǝnnǝbi Musa a nǝmos. ");
INSERT INTO ttq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Musa nǝssân as iššewal-as Mǝššina, amaran alǝs wǝdi wǝr nǝssen sas d-iha fadda.» ");
INSERT INTO ttq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Inn-asan: «Alǝs wa wǝr tǝssenam wala sas d-iha mišan izzozay-i daɣ taddarɣalt! Arat ya wa ǝnta a isammaklalan wǝllen! ");
INSERT INTO ttq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tǝssânam as Mǝššina wǝr iqǝbbǝl šiwatriwen ǝn nasbakkadan. Awedan wa das-ibbǝrdagan itamazal tara-net, ǝnta as iqqabbal šiwatriwen-net. ");
INSERT INTO ttq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wǝr kala ad itawasla awedan issiswadan iyyan a d-ihǝwan ǝd taddarɣalt. ");
INSERT INTO ttq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ǝnnar du-wǝr-ifel alǝs di Mǝššina, wǝr zʼifrǝg igi ǝn wala.» ");
INSERT INTO ttq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Haraššen-tu ǝnnan-as: «Ko! Adis kay was as du-tǝhǝwa da tǝmosa tǝbǝlulǝq n abakkad, kay a iran a dana-takfaɣ alfaydaten?» Tǝzzar ǝstaɣan-tu. ");
INSERT INTO ttq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","As isla Ɣaysa ǝmazal wa igan da, iswad y alǝs wen har t-igraw inn-as: «Awak tǝzzigzanaɣ sǝr-i Ag Aggadǝm?» ");
INSERT INTO ttq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Inna alǝs i Ɣaysa: «Ǝmǝl-i awa imos, Ǝmǝli-nin, fǝlas areɣ a sǝr-ǝs ǝzzǝgzǝna.» ");
INSERT INTO ttq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Inn-as Ɣaysa: «Tǝnayaq-qu, amaran ǝnta da da dak-immǝgradan da.» ");
INSERT INTO ttq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Inn-as alǝs: «Daɣ adi ǝzzigzanaɣ Ǝmǝli-nin.» Tǝzzar issǝjad-as. ");
INSERT INTO ttq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Amaran inna Ɣaysa: «Nak assa a d-ǝgeɣ ǝddǝnet y ad ammazalaɣ ǝššǝriɣa, ǝswǝdan win wǝr nǝhǝnnǝy, addarɣalan win hannaynen.» ");
INSERT INTO ttq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ǝslan arat daɣ Farisaytan win dǝr iddew y awa inna da ǝnnan-as: «Daɣ adi nakkanay da imǝddǝrɣal a nǝmos?» ");
INSERT INTO ttq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Inn-asan Ɣaysa: «Ǝnnar tǝmosam imǝddǝrɣal wǝdi wǝr kawan-iwer abakkad, mišan dad imos as tǝgannim: \"Nakkanay nǝhannay\", wǝdi iwâr-kawan abakkad.» ");
INSERT INTO ttq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Ǝggǝyyeɣ ǝsilakanaɣ-awan as: Awedan wa wǝr nǝggez afarag n ayfǝd s ǝmi was itawaggaz, itaraggat-t-idu, wǝdi abaydag a imos n ǝnarkab. ");
INSERT INTO ttq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amaran wa d-iggazan s ǝmi n afarag, wǝdi ǝnta a imosan amadan n ayfǝd. ");
INSERT INTO ttq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ǝnaɣlif n afarag a das-z-alǝman imi, aslinat ayfǝd y ǝmǝsli-net, ad iɣarru šin-net s esmawan-nasnat isardaq-qanat afarag. ");
INSERT INTO ttq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","As d-iɣrad ikus ǝn šin-net, a dasnat-izar, ǝlkǝmnat-as, fǝlas ǝzdâynat ǝmǝsli-net. ");
INSERT INTO ttq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","As iga awen awedan wa dasnat-imosan ǝnaftaɣ, wǝr das-z-ǝlkǝmnat, ewef fadda a tu-z-aginat fǝlas wǝr ǝzdaynat ǝmǝsli-net.» ");
INSERT INTO ttq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ǝlmital wa da, a dasan-iga Ɣaysa, mišan wǝr ǝgren almaɣna n awa daɣ-san immǝgrad da. ");
INSERT INTO ttq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ilas Ɣaysa inn-asan: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as nak a imosan imi was raddaɣnat ayfǝd. ");
INSERT INTO ttq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Win dat-i d-osanen kul ibaydagan ǝn narkaban a mosan, amaran wǝr dasan-ǝssǝsamnat ayfǝd. ");
INSERT INTO ttq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nak a imosan imi n afarag. Wa sǝr-i d-iggazan ad afsu. Ifrâg ad itaggaz iraddaɣ, igrǝw ǝntada imensewan-net. ");
INSERT INTO ttq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Abaydag wǝr d-itisu ar fǝl šikra, d igi ǝn man d ǝhluk. Nak amaran ose-du fǝl ad ǝgrǝwan aytedan tǝmǝddurt, ǝgrǝwan-tat da za ǝs tǝmǝwit wǝr nǝla ǝddukad. ");
INSERT INTO ttq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nak a imosan amadan wa olaɣan. Amadan wa olaɣan iman-net a ihakku fǝl ayfǝd-net. ");
INSERT INTO ttq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mišan awedan wâs ayfǝd wǝrgeɣ šin-net, ǝtǝwǝɣfar ɣas a itawagga y a tanat-idǝn, wǝdi as ogga ǝridal izay-tanat-du, ad addaggag ayy-enat-in, abǝz daɣ-asnat ǝridal awa ira, izǝwwǝziwǝz-tanat. ");
INSERT INTO ttq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Arat wa itagg-ay alǝs wa fǝlas ǝtǝwǝɣfar ɣas a iga y ǝššǝɣǝl wa, wǝr izlay a ǝganat ayfǝd. ");
INSERT INTO ttq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nak a imosan amadan wa olaɣan. Ǝzdâyaɣ ayfǝd-in, ayfǝd-in deɣ ǝzdaynat-i, ");
INSERT INTO ttq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ǝs tǝmǝwit ta daɣ as di-izday Abba-nin, nak deɣ ǝzdâyaq-qu. Ǝkfeɣ iman-in fǝl ayfǝd-in. ");
INSERT INTO ttq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ǝleɣ ayfǝd šiyyad wǝr nǝha afarag wa. Ǝntanatay da kundaba azzaraɣ-asnat, aslinat y ǝmǝsli-nin. Ayfǝd-in kul ad ǝrtǝynat ǝqqǝlnat ǝsǝgǝn iyyanda, ilân amadan iyyanda. ");
INSERT INTO ttq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Abba ir-i fǝlas iman-in a ǝkfe fǝl a tan-ǝlǝsaɣ agaraw. ");
INSERT INTO ttq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wǝr t-illa i daɣ-i zʼabǝzan iman, kalar iman-in a ǝkfeɣ ǝs tǝradawt-in. Ǝleɣ fǝrregat ǝn tahakkay-nasan, ǝleɣ da fǝrregat n ǝsuɣǝl-nasan. Ǝnta da daɣ arat was di-omar Abba-nin s igi-net.» ");
INSERT INTO ttq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ǝlasan Kǝl-Ǝlyǝhud ǝmǝzrǝy daɣ talɣa n aratan win igannu Ɣaysa da. ");
INSERT INTO ttq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A daɣ-san aggen gannin: «Alǝs wa aggǝsuf a t-ihan! Awa ǝmeskel! Mafel tǝssisamam-as?» ");
INSERT INTO ttq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wiyyad gannin: «Awedan iha aggǝsuf wǝr itǝggu awal wa. Tordam as ill-ay aggǝsuf ifrâgan ǝsǝswǝd ǝn mǝddǝrɣal?» ");
INSERT INTO ttq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Azzaman en tagrǝst. Ewad-du ǝmud imosan isaktan n ǝtǝwǝzǝzdag wa iga Ahan wa Zǝwwǝran n Ǝlɣibada daɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Itijǝwǝnkit Ɣaysa daɣ Ahan wa Zǝwwǝran n Ǝlɣibada issiwal ǝd tarrayt tǝfâlat as itawannu «ta n Suliman.» ");
INSERT INTO ttq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ɣilayɣalayan-tu Kǝl-Ǝlyǝhud win ǝllanen den gannin-as: «Kay ak har ǝmmay wǝr dana-tore daɣ aɣaf? Kud kay Ǝlmǝsix a tǝmosa, tǝzǝlulǝɣa-du da da tannaɣ-anaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Inn-asan Ɣaysa: «Ǝmâlaɣ-awan, mišan wǝr di-tǝzzǝgzanam. Imazalan win ǝge s esǝm n Abba-nin, ǝggǝyyen-i, ");
INSERT INTO ttq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mišan wǝr di-tǝzzǝgzanam fǝlas wǝr tǝtabaqqem daɣ ayfǝd-in. ");
INSERT INTO ttq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ayfǝd-in ǝsallinat y ǝmǝsli-nin, ǝzdâyaq-qanat, amaran ǝlkâmnat-i. ");
INSERT INTO ttq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ǝkfeq-qanat tǝmǝddurt ta tǝɣlalat, wǝr daɣ-asnat tǝlkem tǝmattant, amaran wǝr t-illa i daɣ-i tanat-z-irkǝban. ");
INSERT INTO ttq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Abba-nin a di-tanat-ikfan, wǝr t-illa i wǝr oger. Amaran wǝr t-illa i tanat-z-irkǝban daɣ ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nak d Abba arat iyyanda a nǝmos.» ");
INSERT INTO ttq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ǝlasan-du sǝr-ǝs adakal ǝn tǝhun y ad t-anɣin. ");
INSERT INTO ttq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ilas Ɣaysa inn-asan: «Ǝssiknaq-qawan imazalan aggotnen olaɣnen a d-ǝfalnen Abba. Mǝni daɣ-san wa fǝl taram a di-tanɣim?» ");
INSERT INTO ttq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ǝnnan-as: «Nakkanay wǝr nǝra tenaɣay-nak fǝl as tǝgeɣ ǝmazal olaɣan, kalar ǝmadraw wa tǝgeɣ ǝddi a fǝl kay-za-nanɣu. Kay wǝr tǝmosaɣ ar aggadǝm amaran tareɣ ad tagaɣ iman-nak Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Inn-asan Ɣaysa: «Awak wǝrgeɣ iktâb daɣ Ǝttawret as inna Mǝššina: \"Kawanay tǝmosam imalan\"? ");
INSERT INTO ttq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wǝr nǝfreg a din-nǝgǝr arat wa ihan Ǝlkǝttaban. Esǝm wa n malan, iɣra sǝr-ǝs Mǝššina aytedan win ikka awal-net. ");
INSERT INTO ttq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nak Mǝššina a di-isannafranan izammazal-i-du s ǝddǝnet. Manǝmmǝk daɣ adi as za tannim taggaɣ ǝmadraw fǝlas ǝnne: \"Ǝmosa Barar ǝn Mǝššina\"? ");
INSERT INTO ttq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","As imos as wǝr tǝggaɣ imazalan win as di-d-issǝgla Abba-nin y a tan-aga, a di-wǝr-tǝzzǝgzǝnam. ");
INSERT INTO ttq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mišan dad imos as taggaq-qan, wǝdi kud sǝr-i wǝr tǝzzǝgzanam da, zǝgzǝnat kuddeɣ ǝs mazalan win tagga, fǝl ad tǝssǝnam, tassantim deɣ daɣ ǝgǝrri n as Abba irtây dǝr-i, nak deɣ ǝrtâya d Abba.» ");
INSERT INTO ttq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ǝlasan agamay d abbaz-net, mišan igmad-tan. ");
INSERT INTO ttq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ilas Ɣaysa iki ǝn tǝgadamayt ta hadat ǝn Yordan, daɣ adag wa daɣ issǝnta Yaxya ǝsǝlmǝɣ n aytedan daɣ aman, iqqim den da. ");
INSERT INTO ttq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Osan-t-in aytedan aggotnen, gannin: «Yaxya wǝr iga alɣalamat waliyyat, mišan aratan kul win danaɣ-inna s alǝs wa, tidǝt a mosan.» ");
INSERT INTO ttq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Den daɣ ad ǝzzǝgzanan aytedan aggotnen ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ill-ay alǝs irinan igan esǝm Lazarǝs, ihan tǝɣrǝmt ǝn Betanǝy s ǝnta a daɣ tǝɣsar Maryama ǝd Marta ǝmosnen šimǝdrayen. ");
INSERT INTO ttq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryama ta da a tǝnɣalat alwardi fǝl Ǝmǝli Ɣaysa, tǝmas idaran-net ǝs jǝkkad-net. Amaran amadray-net Lazarǝs a irinan den. ");
INSERT INTO ttq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ǝssokanat tǝmǝdrayen-net Ɣaysa ǝmazal as: «Ǝmǝli, ǝmǝri-nak irîn.» ");
INSERT INTO ttq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","As isla Ɣaysa i salan win den, inna: «Tǝsǝlkamt ǝn tǝwǝrna ten, wǝr za tǝqqǝl tǝmattant ǝn Lazarǝs, arat a tǝmos a zʼassaknin tanaya ǝn Mǝššina, isǝnnǝfilǝl-du ǝntada tanaya ta ila Barar ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ɣaysa ira Marta wǝllen, ǝnta ǝd tǝmadrayt-net, ǝd Lazarǝs. ");
INSERT INTO ttq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Isla tǝwǝrna-net, mišan iga dǝffǝr awen ǝššin adan wǝr igmed edag wa iha. ");
INSERT INTO ttq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dǝffǝr adi inna i nǝttulab-net: «Ǝndawat ad nǝqqǝl Yahudǝyya.» ");
INSERT INTO ttq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ǝnnan-as nǝttulab-net: «Ǝššex-nana, imuzaran-nana wǝrge edes-nasan sǝket dâ da dă gammayan ǝd tanaɣay-nak, kay amaran tareɣ tewaɣlay n akal wen?» ");
INSERT INTO ttq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Inn-asan Ɣaysa: «Ǝzǝl wǝrgeɣ maraw alwaqan d ǝššin a imos? As ijawankat awedan ezal, wǝr zʼinǝgǝrtǝttǝf, fǝlas ihannay dat-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mišan as ijawankat awedan ehad, ad inǝgǝrtǝttǝf, fǝlas wǝr t-iha ǝnnur.» ");
INSERT INTO ttq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","As iga batu ta inna tolas: «Ǝmidi-nana Lazarǝs insâ, ad aglaɣ a t-id-ǝssǝnkǝra.» ");
INSERT INTO ttq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ǝnnan-as nǝttulab-net: «Ǝmǝli, dad zamas insâ, wǝdi ǝngǝm ad izzǝy.» ");
INSERT INTO ttq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ǝnta Ɣaysa tǝmattant ǝn Lazarǝs as dasan-immǝgrad den, mišan ǝntanay a ɣilan etǝs wa n alɣadat as igannu. ");
INSERT INTO ttq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Adi a fǝl d-izalalaɣ Ɣaysa inn-asan: «Lazarǝs aba-tu. ");
INSERT INTO ttq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Amaran isidawat-i as wǝr ǝlle den alwaq wǝdi, fǝlas arat wa ǝnta sǝr-wan du-z-awǝyan a sǝr-i tǝzzǝgzǝnam. Ǝmǝrǝdda ǝndawatanaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Inkar Tuma was gannin Eknay, inna i nǝttulab win hadatnen: «Ǝndawat nakkanay da a danaɣ-iba nǝddew dǝr-ǝs.» ");
INSERT INTO ttq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","As din-osa Ɣaysa ittǝmal-as as Lazarǝs iga ǝkkoz adan daɣ ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanǝy tǝhoz Yerusalam. Edag ǝn karad kilawtan ɣas a illan gar-essanat. ");
INSERT INTO ttq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Osan-in Kǝl-Ǝlyǝhud aggotnen Marta ǝd Maryama fǝl a dasnat-in-šǝwwǝškǝnan daɣ adag n amadray-nasnat. ");
INSERT INTO ttq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","As tǝsla Marta as Ɣaysa ihoz-du taɣrǝmt, tǝssǝlkad-as. Maryama ǝnta tǝqqim-in daɣ aɣaywan. ");
INSERT INTO ttq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tǝnna Marta i Ɣaysa: «Ǝmǝli, ǝnnar tǝlle da, wǝr zʼiba amadray-nin. ");
INSERT INTO ttq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mišan ǝmǝrǝdda da ǝssanaɣ as arat kul wa tǝgmaya daɣ Mǝššina a dak-k-agu.» ");
INSERT INTO ttq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Inn-as Ɣaysa: «Amadray-nam a d-inkǝr daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tǝnn-as Marta: «Ǝssânaɣ as amadray-nin a d-inkǝr ɣur tanakra n aytedan ǝzǝl wa ilkaman.» ");
INSERT INTO ttq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Inn-as Ɣaysa: «Nak a imosan wa d-isankaran daɣ tǝmattant, ǝmosa tǝmǝddurt. Awedan wa sǝr-i izzǝgzanan, wǝdi kud t-aba da a d-iddǝr. ");
INSERT INTO ttq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amaran awedan kul wa iddaran izzigzan sǝr-i, wǝdi wǝr ilkem ad t-aba. Tǝzzigzanaɣ adi?» ");
INSERT INTO ttq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tǝnn-as: «Awalla, Ǝmǝli, ǝzzigzanaɣ as kay a imosan Ǝlmǝsix, tǝmosa deɣ Barar ǝn Mǝššina, as ittimal as a d-asu ǝddǝnet.» ");
INSERT INTO ttq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","As tǝga Marta batu ta, tǝkka tǝmadrayt-net Maryama, tǝwat-tat s ahal tǝnn-as: «Ǝššex illa-da, isastan dǝr-ǝm.» ");
INSERT INTO ttq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","As tǝgraw Maryama isalan win, tǝggad-du, tǝssǝlkad i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","As itaggu awen harwa da wǝr d-iggez taɣrǝmt, wǝr igmed edag wa daq-q in-tosa Marta. ");
INSERT INTO ttq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ǝllân Kǝl-Ǝlyǝhud ɣur Maryama a das-du-šiwaškannen. As tat-ǝnayan as du-tǝggad tarmad tǝqqab, ǝlkaman-as ǝɣilan ǝzǝkka a tǝkka y a fall-as tǝhallu. ");
INSERT INTO ttq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","As din-tosa Maryama edag wa iha Ɣaysa togg-ay ɣas tǝfataqqat ɣur daran-net, tǝnn-as: «Ǝmǝli, ǝnnar tǝlle da, wǝr zʼiba amadray-nin.» ");
INSERT INTO ttq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","As tat-inay Ɣaysa tǝhallu, inay Kǝl-Ǝlyǝhud win dǝr-ǝs d-ǝddewnen ǝntanay da ǝhallin, ikna tǝrǝmmeq, ǝɣšadan man-net. ");
INSERT INTO ttq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Inn-asan: «Mǝni tu-tǝgam?» Ǝnnan-as «Ǝmǝli, ayaw tǝnǝya.» ");
INSERT INTO ttq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ad ihallu Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ǝnnan aytedan: «Ǝnawat awa dǝr togda tara ta iga y alǝs wa.» ");
INSERT INTO ttq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tǝzzar ǝnnan wiyyad daɣ-san: «Alǝs wa issǝswadan ǝmǝdderɣǝl, wǝrgeɣ ifrâg a ad igdǝl i Lazarǝs tǝmattant?» ");
INSERT INTO ttq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ilas Ɣaysa tǝrǝmmeq, tǝzzar ikka ǝzǝkka imosan akazam, tǝdbâɣ tǝhunt zǝwwǝrat. ");
INSERT INTO ttq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Inna Ɣaysa: «Ǝkkǝsat tǝhunt!» Tǝnn-as Marta ta n tamadrayt n alǝs wa aba da: «Ǝmǝli, alǝs di ǝmǝrǝdda ila aḍu, fǝlas ǝzǝl-net wa n ǝkkoz d anabal awa.» ");
INSERT INTO ttq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Inn-as Ɣaysa: «Wǝrgeɣ ǝnneɣ-am as tǝzzǝgzana ad tǝnǝyaɣ tanaya ǝn Mǝššina?» ");
INSERT INTO ttq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tǝtawakkas-du tǝhunt. Iswad Ɣaysa daɣ jǝnnawan inna: «Abba, ǝggodayaɣ-ak as di-tǝqbala tǝwatray-nin. ");
INSERT INTO ttq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nak iman-in ǝssânaɣ as faw da tǝqqabbala šiwatriwen-in. Ǝddǝlil ǝn tamattay ta di-tǝɣalayɣalayat da a fǝl dak-ǝššewala fǝl ad tǝzzǝgzǝn as kay a di-d-izammazalan.» ");
INSERT INTO ttq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","As iga tǝwatray ta, idkal ǝmǝsli-net inna: «Lazarǝs, ǝgmǝd-du!» ");
INSERT INTO ttq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Igmad-du ǝnǝmmettǝn wa nad, ǝttâlan fassan-net ǝd daran-net ǝs tǝsǝwad, tǝlsa deɣ tǝbdoq udǝm-net. Inn-asan Ɣaysa: «Ǝkkǝsat-as itul tayyim-tu ad ijǝwǝnkǝt.» ");
INSERT INTO ttq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kǝl-Ǝlyǝhud aggotnen a d-osânen Maryama, ǝnayan arat wa, ǝzzǝgzanan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wiyyad daɣ-san amaran ǝkkan Farisaytan ǝmalan-asan awa iga Ɣaysa da. ");
INSERT INTO ttq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tǝzzar sassagan limaman win zawwarnen, ǝd Farisaytan ǝmǝnǝy ǝn muzaran ǝnnan: «Ma za nagu? Alǝs wa itaggu alɣalamaten aggotnen.» ");
INSERT INTO ttq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","As tu-noyya itaggu aratan win, a sǝr-ǝs ǝzzǝgzǝnan aytedan kul, tǝzzar asin-du sojitan ǝn Kǝl-Ǝrrum a dana-sitaɣmarnen, addagdagan Ehan wa Zǝwwǝran n Ǝlɣibada, ǝɣrǝdan deɣ tenaɣay ǝn tamattay-nana. ");
INSERT INTO ttq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Inkar-du iyyan daɣ-san igân esǝm Kayif, imosan Ǝlimam wa Zǝwwǝran daɣ awatay wen, inn-asan: «Kawanay wǝr tǝgrem wala. ");
INSERT INTO ttq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wǝr din-tǝgrem as ofa ad ammat awedan iyyanda daɣ adag ǝn tamattay n Israyil ketnet?» ");
INSERT INTO ttq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Batu ta iga da wǝr tat-iga gar-es ǝd man-net, kalar tišit-net Ǝlimam wa Zǝwwǝran daɣ awatay wen, a fǝl igraw ǝlwǝlayat n as Ɣaysa kundaba immut daɣ adag ǝn tamattay ketnet. ");
INSERT INTO ttq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Amaran wǝrge tamattay n Israyil ɣas as tu-z-iba daɣ adag-net, kalar bararan ǝn Mǝššina kul win wazawaznen gǝr kallan a du-z-iššidǝw ǝqqǝlan tǝɣǝssa iyyadda. ");
INSERT INTO ttq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ǝzǝl wen da daɣ ǝgan muzaran ǝn Kǝl-Ǝlyǝhud tanat ta n tanaɣay-net. ");
INSERT INTO ttq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Awen da fǝlas abʼas itallam Ɣaysa dad ira daɣ Kǝl-Ǝlyǝhud. Igmad akal wen, ikka ǝɣrǝm igân esǝm Efrayim inimahazan ǝd taneray, iqqim daɣ-as ǝnta ǝd nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Azzaman en amud ǝn Kǝl-Ǝlyǝhud wa n Akkay ihoz-du. A du-gammadan aytedan idaggan aggotnen takkin-du Yerusalam, fǝl ad ǝzzǝzdǝgan dat ǝmud. ");
INSERT INTO ttq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Saggadan i Ɣaysa tinǝmǝnnin gar-essan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada: «Kawanay ak ma tǝnnam, tordâm as a d-asu amud a meɣ?» ");
INSERT INTO ttq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ǝnta ilimaman win zawwarnen ǝd Farisaytan omâran aytedan s âs i issanan edag wa iha Ɣaysa isaffagget-tu fǝl ad attarmas. ");
INSERT INTO ttq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sǝdis adan dat Ǝmud wa n Akkay ikka Ɣaysa Betanǝy, s ǝnta daɣ ixsar Lazarǝs wa d-issodar daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","As din-osa Ɣaysa tawaggan-as mǝgura olaɣnen. A du-tǝtaway Marta imensewan, Lazarǝs amaran iha aytedan win naɣamanen ǝd Ɣaysa ǝdrâwan dǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tǝzzar tǝdkal-du Maryama aganna ǝn litǝr n alwardi iknan šizada d əzzəwi as itawannu nar, a tu-tǝnaqqal fǝl daran ǝn Ɣaysa, tǝmmas-tan ǝs jǝkkad-net, idnay ahan aḍu n alwardi. ");
INSERT INTO ttq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Inkar Yahuza Isxarǝyuti wa n iyyan daɣ nǝttulab ǝn Ɣaysa was ǝnta tu-z-agin daɣ fassan inna: ");
INSERT INTO ttq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Mafel wǝr din-nǝzzǝnza alwardi wa azrǝf a zʼawǝdan karadat tǝmad n ǝzǝl n ǝššǝɣǝl nakf-ay i tǝlǝqqawen?» ");
INSERT INTO ttq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Arat wa wǝr t-inna fǝl tǝhanint i tǝlǝqqawen, kalar abaydag a imos, amaran ǝnta a ittafan ǝssǝnduq wa itaggaz ǝzrǝf ǝn nǝttulab, idakkal daɣ awa t-ihan. ");
INSERT INTO ttq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eges ya inna Ɣaysa: «Ayy-et! Alwardi wa kala da togâz-tu y ǝzǝl wad za tǝwǝga daɣ ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Šiləqqawen faw da əllânat ɣur-wan, nak amaran wǝrgeɣ faw ǝlle ɣur-wan.» ");
INSERT INTO ttq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tǝsla tamattay tagget ǝn Kǝl-Ǝlyǝhud as illa Ɣaysa den tǝzzar ǝkkan ehan wen, mišan wǝrge Ɣaysa ɣas din-ǝkkan, kalar awnaf a tan-ihan ǝn Lazarǝs wa d-issǝnkar daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tǝzzar ǝkkasan-du limaman win zawwarnen tanat n ad anɣin Lazarǝs ǝnta da, ");
INSERT INTO ttq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","fǝlas ǝddǝlil-net a fǝl dǝffǝr-san ǝfalan Kǝl-Ǝlyǝhud aggotnen ǝzzǝgzanan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","As affaw ǝslan aytedan aggotnen a d-ǝkkanen amud, as Ɣaysa iggaz-du aɣrǝm wa n Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ǝdkalan-du ilǝdlad ǝn tagayt ǝglan ǝssǝlkadan-as gannin s afalla: «Ozana! Tǝmmal i Mǝššina! Iga Mǝššina albaraka daɣ wa d-osan s esǝm n Ǝmǝli! Kay ǝmǝnokal n Israyil!» ");
INSERT INTO ttq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Igraw Ɣaysa ǝhulel, iwan-tu, s ǝmmǝk wa ǝmalan Ǝlkǝttaban as ǝnnan: ");
INSERT INTO ttq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ad wǝr tǝššǝwǝša ya wǝlǝt Sǝyon, ǝmǝnokal-nam ǝddi a din-izayan ǝddi, iwân ǝhulel.» ");
INSERT INTO ttq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Arat wa wǝr t-ǝgren nǝttulab-net daɣ tizarat, mišan as igraw Ɣaysa adkul-net, ǝktan-du as aratan win ǝmâlan-tan Ǝlkǝttaban, amaran kul ǝndan fall-as. ");
INSERT INTO ttq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tamattay ta tǝmmǝgnet assaɣa wa daɣ d-iɣra Ɣaysa Lazarǝs daɣ ǝzǝkka issǝnkar-t-idu daɣ tǝmattant, tǝgǝyyat-as. ");
INSERT INTO ttq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Awen da fǝl das-du-tǝssǝlkad tamattay, fǝlas ǝslân alɣalamat ta iga. ");
INSERT INTO ttq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tǝzzar ad tinǝmǝnnin Farisaytan gar-essan: «Toggâm-tu? Indar-awan a dǝr t-in-tǝkkam, har as aytedan kul ǝlkaman-as.» ");
INSERT INTO ttq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ǝllan-tu arat ǝn Kǝl-Ǝlyunan ǝhanen aytedan win d-ǝkkanen Yerusalam y a daɣ-as ǝɣbǝdan Mǝššina daɣ adan en da n ǝmud en. ");
INSERT INTO ttq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ǝkkan iyyan daɣ nǝttulab ǝn Ɣaysa igan Filibus wa n tǝɣrǝmt ǝn Betsayda ta n akal ǝn Galilaya, ǝnnan-as: «Nǝgmay daɣ-ak a dana-tassakna Ɣaysa.» ");
INSERT INTO ttq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Igla Filibus imal y Andrawǝs, iddew dǝr-ǝs Andrawǝs ǝmalan i Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Inn-asan Ɣaysa: «Alwaq ewad-du ǝmǝrǝdda wa daɣ zʼǝgrǝwa nak Ag Aggadǝm adkul-in. ");
INSERT INTO ttq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ǝggǝyyeɣ ǝsilakanaɣ-awan as tablalt n alkama as wǝr tǝrtek daɣ amaḍal tǝmmut, ad taglu tǝmos iyyadda, mišan as tǝmmut a du-tǝdwǝl, tagu ara aggen. ");
INSERT INTO ttq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Awedan wa iran iman-net daɣ ǝddǝnet ta ad affatu daɣ alaxirat. Amaran wa irdan ad isaffatu iman-net daɣ ǝddǝnet ta, wǝdi wǝr tu-z-ǝgmǝdan, kalar ad igrǝw tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Awedan kul wa iran a di-išɣǝl, ilkǝmet-i, as iga adi edag wa ǝheɣ ǝnta a zʼiggǝz, akf-ay deɣ Abba-nin almaqam. ");
INSERT INTO ttq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ǝmǝrǝdda ǝɣšâdan man-in. Ma zʼanna? Awak ad anna: \"Abba safs-i daɣ assaɣat ta? Mišan wǝr d-ewedaɣ alwaq wa, âr y a fall-i agu. ");
INSERT INTO ttq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abba, sǝnnǝfilǝl tǝla-nak tanaya.\"» Tǝzzar igmad-du ǝmǝsli ijǝnnawan inna: «Tǝla-nin tanaya ǝsinafalalaq-qat, amaran a tat-ǝlǝsaɣ ǝsǝnnǝfilǝl.» ");
INSERT INTO ttq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tamattay ta tǝllat den, tǝsla y ǝmǝsli wa, a tǝɣil eggag. Ad ǝgannin wiyyad: «Angalos das-iššewalan den.» ");
INSERT INTO ttq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Inn-asan Ɣaysa: «Ǝmǝsli wa wǝrgeɣ ǝddǝlil-in a fǝl d-iga, kalar ǝddǝlil-nawan kawanay. ");
INSERT INTO ttq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ǝmǝrǝdda ad za tǝtǝwǝxkǝm ǝddǝnet ta, itǝwǝstǝɣ ǝmǝnokal-net Iblis. ");
INSERT INTO ttq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amaran nak as tawasahake fǝl amaḍal ǝwara tǝgǝttawt, a d-aɣraɣ aytedan kul ǝs man-in.» ");
INSERT INTO ttq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Batu ta isidagan sǝr-ǝs tǝmǝwit tas tu-z-iba. ");
INSERT INTO ttq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tǝnn-as tamattay: «Nǝnây daɣ Awal ǝn Mǝššina as Ǝlmǝsix ad agu tǝmǝddurt tǝɣlalat. Manǝmmǝk amaran as dana-za-tannaɣ Ag Aggadǝm ad itǝwǝsǝhukǝt fǝl amaḍal? Ma imos Ag Aggadǝm was tǝgannaɣ ǝddi?» ");
INSERT INTO ttq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tǝzzar inn-asan Ɣaysa: «Ǝnnur harwa da illa ɣur-wan, har agin arat n azzaman. Jǝwǝnkǝtat iket di ad t-illa fǝl a kawan-wǝr-ǝɣdǝrnat šiyyay, fǝlas wa ijawanken daɣ šiyyay, adi wǝr issen sas idag. ");
INSERT INTO ttq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Zǝgzǝnat s ǝnnur harwa togazam, fǝl ad tǝqqǝlam kǝl ǝnnur.» As iɣrad Ɣaysa igi ǝn batu ta igguk-kan, ikka edag wǝr ǝssenan. ");
INSERT INTO ttq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Alɣalamaten aggotnen šin iga Ɣaysa dat-san, wǝr sǝr-san d ewaynat as sǝr-ǝs ǝzzǝgzǝnan, ");
INSERT INTO ttq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","fǝl ad tandu batu ta iga ǝnnǝbi Isayas as inna: «Ǝmǝli, ma imos wa izzǝgzanan s arat wa nǝmal? Ma imos was tǝnafalal tarna n Ǝmǝli?» ");
INSERT INTO ttq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ǝddǝlil wa fǝl wǝr ǝfregan ad ǝzzǝgzanan da imal-tu ǝnnǝbi Isayas as inna: ");
INSERT INTO ttq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Mǝššina a tan-isaddarɣalan, issǝɣar iwallan-nasan, fǝl ad ibʼas hannaynat šittawen-nasan, ibʼas garrin wallan-nasan, fǝl ad wǝr utaban, izzuzǝy-tan.» ");
INSERT INTO ttq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aratan win inn-en Isayas fǝlas inây tanaya ǝn Ɣaysa, immigrad deɣ daɣ batu ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","As iga awen imuzaran iman-nasan da a daɣ-san aggen ǝzzigzanan ǝs Ɣaysa, mišan wǝr ǝhelan emel n awen fǝl tǝksǝda ǝn Farisaytan, fǝlas wǝr aren ad tǝwǝkkǝsan daɣ ǝljǝmaɣat n ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Amaran ǝssofan saɣmar wa n aytedan tanaya ta ihakku Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Idkal Ɣaysa ǝmǝsli-net inna: «Awedan wa sǝr-i izzǝgzanan, wǝrge nak ɣas as izzǝgzan, kalar wa di-d-izammazalan da izzigzan sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Amaran wa daɣ-i iswadan, adi wa di-d-izammazalan a daɣ iswad. ");
INSERT INTO ttq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nak zun ǝnnur a mosa, ǝkke-du ǝddǝnet y âs i sǝr-i izzǝgzanan wǝr zʼaqqam daɣ šiyyay. ");
INSERT INTO ttq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","As isla awedan i batuten-in iqqim wǝr tanat-ittef, wǝrge nak a tu-z-awwaddaban, fǝlas nak efsan n aytedan a d-ǝkke s ǝddǝnet, wǝrgeɣ attadib-nasan. ");
INSERT INTO ttq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Daɣ adi awedan kul wa di-olkan, iqqim wǝr iga tenbay daɣ batuten-in, wǝdi ill-ay wa tu-z-awwaddaban. Awal iman-net wa da ǝge da, a das-z-išrǝɣan ǝzǝl wa ilkaman. ");
INSERT INTO ttq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Fǝlas aratan win dawan-ǝmala da, wǝrgeɣ nak a tan-d-inzaman gǝr-i ǝd man-in, kalar Abba wa di-d-izammazalan iman-net as di-omar s arat was di-iwar ad t-anna, ǝd was di-iwar a fall-as ammagrada. ");
INSERT INTO ttq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ǝssânaɣ as arat was omar ǝnta a itawayan ǝs tǝmǝddurt ta tǝɣlalat. Daɣ adi arat was ǝmmǝgrada, ǝmmǝk wa daɣ as di-t-imal Abba ǝnta as sǝr-ǝs ǝmmǝgrada.» ");
INSERT INTO ttq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ahad wa oggan amud wa n Akkay, issân Ɣaysa as alwaq-net osa-du wa daɣ zʼigmǝd ǝddǝnet iqqǝl Abba. Ɣaysa faw da isaknu inǝttulab-net tara, amaran ǝmǝrǝdda isannahal-tan ǝsǝkni ǝn tara ta dasan-iga. ");
INSERT INTO ttq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Itamansaw Ɣaysa ǝd nǝttulab-net ehad, as itaggu awen da Iblis igâ daɣ ǝwǝl ǝn Yahuza wa n ag Simɣon Isxarǝyuti tǝkaddilt-net. ");
INSERT INTO ttq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Issân Ɣaysa as Mǝššina di n Abba igâ arat kul daɣ ǝfus-net, issân deɣ as igmâd-du Mǝššina amaran ad t-iqqǝl. ");
INSERT INTO ttq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ibdad fǝl mensewan, ikkas takadkat-net ta n afalla, idkal afǝr igbas-tu, ");
INSERT INTO ttq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tǝzzar iga aman daɣ ǝɣlal, ad išarad idaran ǝn nǝttulab-net, immas-tan s ǝfǝr wa igbas da. ");
INSERT INTO ttq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","As d-ewad Ɣaysa Simɣon Butros inn-as: «Ǝmǝli, kay, a zʼišširǝdan idaran-nin?» ");
INSERT INTO ttq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Inn-as Ɣaysa: «Awa tagga da wǝr tǝfrega ǝgǝrri-net ǝmǝrǝdda mišan a tu-tagra dǝffǝr awa.» ");
INSERT INTO ttq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Inn-as Butros: «Kay, ad tǝšširǝda idaran-in? Wala ǝnǝmihaz!» Inn-as Ɣaysa: «As dak-kan-wǝr-ǝššorada nak dǝr-ǝk nǝmmizzay.» ");
INSERT INTO ttq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Inn-as Simɣon Butros: «Daɣ adi Ǝmǝli, wǝrge idaran-nin ɣas, širǝd harkid fassan-in d aɣaf-in.» ");
INSERT INTO ttq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Inn-as Ɣaysa: «Awedan iššoradan, wǝr iddarar ar ǝširǝd ǝn daran fǝl ad izdag ketnet, amaran kawanay, tǝzǝddigam, mišan wǝrge ketnawan.» ");
INSERT INTO ttq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ɣaysa issân wa tu-z-akkaddalan; adi a fǝl inna: «Wǝr tǝzǝddigam ketnawan.» ");
INSERT INTO ttq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","As iɣrad Ɣaysa ǝširǝd ǝn daran-nasan, izlag takadkat-net, iqqal edag-net, inn-asan: «Awak tǝgrâm awa dawan-ǝge da? ");
INSERT INTO ttq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tǝgannim-i \"Amǝsǝsseɣri\" d \"Ǝmǝli\", tǝgannim a olaɣan, fǝlas ǝmosaq-qan. ");
INSERT INTO ttq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Daɣ adi dad zamas nak imosan Ǝmǝli d Ǝmǝsǝsseɣri, ǝššorada idaran-nawan, iwâr-kawan, kawanay da, daɣ ilkam a, ad tǝtimaširidam idaran. ");
INSERT INTO ttq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ǝsǝknaq-qawan arat wa fǝl a tu-tǝtaggim kawanay da s ǝmmǝk was dawan-t-ǝge. ");
INSERT INTO ttq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ǝggǝyyeɣ silakanaɣ-awan as, akli wǝr oger mǝššis, anammazal deɣ wǝr oger wa t-id-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dad zamas tǝssânam aratan win, wǝdi tǝbbilalam kudis tǝtamazalam-tan. ");
INSERT INTO ttq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wǝr dawan-ganna ketnawan; win sannafrana kul ǝzdâyaq-qan amaran kundaba inda awa imal Awal ǝn Mǝššina as inna: \"Wa dǝr ǝdrawa, iqqal amaksan-in.\" ");
INSERT INTO ttq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Arat wa, as igâ ad tǝzzǝgzǝnam as nak a imosan \"Wa Illan da.\" Adi da a fǝl dawan-t-ǝnneɣ ǝmǝrǝdda harwa wǝr iga. ");
INSERT INTO ttq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ǝggǝyyeɣ silakanaɣ-awan as wa iqbalan iyyan daɣ nǝmmuzal-in, nak iman-in a iqbal. Harwa wa di-iqbalan, wa di-d-izammazalan a iqbal.» ");
INSERT INTO ttq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","As inna Ɣaysa awen, ǝɣšadan man-net, tǝzzar inna: «Ǝggǝyyeɣ ǝsilakanaɣ-awan as iyyan daɣ-wan a di-z-aggin daɣ fassan.» ");
INSERT INTO ttq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ad tinǝmǝswidan nǝttulab-net, ǝqqânan ɣafawan-nasan i was igannu. ");
INSERT INTO ttq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iyyan daɣ nǝttulab-net, wa isannahal Ɣaysa tara, isiɣamar daɣ ihǝz n ǝdmaran ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Isaddagan-as Simɣon Butros ad issǝstǝn Ɣaysa ǝd was igannu. ");
INSERT INTO ttq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tǝzzar inaz-in ǝnattalib wen fǝl ǝdmaran ǝn Ɣaysa, inn-as: «Ǝmǝli, ma zʼiqqǝl?» ");
INSERT INTO ttq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ijjǝwwab-as Ɣaysa inn-as: «Wa ǝkfe akarammu ǝn tǝgǝlla wa zʼǝssǝlmǝɣa daɣ ǝdrǝz a.» Tǝzzar issǝlmaɣ akarammu ǝn tǝgǝlla ikf-ay i Yahuza ag Simɣon Isxarǝyuti. ");
INSERT INTO ttq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","As igraw Yahuza akarammu wen, iggaz-tu Aššaytan. Tǝzzar inn-as Ɣaysa: «Tagaɣet tarmad awa kay-iwaran.» ");
INSERT INTO ttq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Awa fǝl inna Ɣaysa awen i Yahuza, wǝr iha inǝttulab-net win hadatnen siɣamarnen den tattin i t-igrân. ");
INSERT INTO ttq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Wiyyad ordân as, iduf wa iga Yahuza azrǝf ǝn nǝttulab a fǝl das-inna Ɣaysa: «Zanza-du arat was za naddarar y ǝmud; madeɣ akfu šilǝqqawen arat iyyan.» ");
INSERT INTO ttq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ibaz Yahuza akarammu ǝn tagǝlla, igmad tarmad, as itaggu awen da ehad igâ. ");
INSERT INTO ttq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","As igmad Yahuza, inna Ɣaysa: «Ǝmǝrǝdda tanaya-nin nak Ag Aggadǝm tǝnîfalal, tǝnifalal daɣ-i deɣ tanaya ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dad zamas tanaya ǝn Mǝššina tǝnifalal daɣ-i, Mǝššina da ad isǝnnǝfilǝl daɣ man-net tanaya-nin nak Ag Aggadǝm daɣ alwaq ihozan wǝllen. ");
INSERT INTO ttq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Imaran-in, alwaq wǝr nǝggǝt a ɣur-wan zʼaga. A di-tǝgmǝyam mišan edag wa ǝkkeɣ wǝr tǝfregam a t-in-tawǝdam. Kala ad ǝnneɣ adi i Kǝl-Ǝlyǝhud, amaran kawanay da ǝmǝrǝdda ǝnneɣ-awan-tu. ");
INSERT INTO ttq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A kawan-akfaɣ alwajib aynayan, a t-imosan as namariwat. Namariwat kawanay da s ǝmmǝk was kawan-are. ");
INSERT INTO ttq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","As tǝnamaram, ad issusǝn adi aytedan kul as kawanay inǝttulab-in.» ");
INSERT INTO ttq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Inn-as Simɣon Butros: «Ǝmǝli, mǝnid tǝkke.» Inn-as Ɣaysa: «Edag wa ǝkke, wǝr tǝfrega a di-sǝr-ǝs-tǝlkǝma ǝmǝrǝdda, eges a din-tǝlkǝma dǝffǝr awa.» ");
INSERT INTO ttq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Inn-as Simɣon Butros: «Ǝmǝli, mafel as wǝr ǝfrega a dak sǝr-ǝs ǝlkǝma ǝmǝrǝdda. Ǝgaraɣ iri y a fall-ak akfa iman-nin.» ");
INSERT INTO ttq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Inn-as Ɣaysa: «Adis a fall-i takfaɣ iman-nak? Ǝggǝyyeɣ silakanaɣ-ak as wǝr zʼaɣru ǝkǝji aɣora wǝr di-tǝggeda har karadat tăklaten.» ");
INSERT INTO ttq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Inn-asan Ɣaysa: «Ad wǝr tǝššǝwǝšam, zǝgzǝnat ǝs Mǝššina, tǝzzǝgzǝnam sǝr-i nak da. ");
INSERT INTO ttq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ehan n Abba-nin ahân-tu daggan aggotnen ǝn tǝmǝxsurt. Awak ǝnnar wǝr iga adi manǝmmǝk as dawan-z-anna ad agla sǝmmutǝgaɣ-awan edag tǝzdaɣam? ");
INSERT INTO ttq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","As tu-sammataga, ad d-ǝqqala, idawaɣ-in dǝr-wan fǝl ad tǝggǝzam edag wa ǝhe. ");
INSERT INTO ttq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Edag wa ǝkke tǝssânam tarrayt-net.» ");
INSERT INTO ttq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Inn-as Tuma: «Ǝmǝli wǝr nǝssen dad tǝkke, manǝmmǝk as za nǝssǝn tarrayt-net?» ");
INSERT INTO ttq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Inn-as Ɣaysa: «Nak a imosan tarrayt id ǝmosa tidǝt ǝmosa ǝntada wa ihakkan tǝmǝddurt. Awedan waliyyan wǝr in-z-awǝd Abba, ar ǝs tarrayt-in. ");
INSERT INTO ttq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ǝnnar tǝssânam awa mosa, tǝssǝnam awa imos Abba-nin da. Ǝmǝrǝdda tǝssânam awa imos, amaran tǝnayam-tu.» ");
INSERT INTO ttq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Inn-as Filibus: «Ǝmǝli, susǝn-anaɣ awa imos Abba, igd-ana adi.» ");
INSERT INTO ttq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Inn-as Ɣaysa: «Filibus, ǝruwaɣ as dǝr-wan ǝddewa, eges harwa da wǝr tǝssenaɣ awa mosa? Wǝr tǝssenaɣ as wa di-inayan inây Abba! Daɣ adi manǝmmǝk as tǝganna: \"Susǝn-anaɣ awa imos Abba?\" ");
INSERT INTO ttq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wǝr tǝzzǝgzanaɣ as, nak d Abba arat iyyanda a nǝmos? Aratan win dawan-ǝmala da wǝrgeɣ nak a tan-d-inzaman gǝr-i ǝd man-in, kalar Abba dǝr ǝmosaɣ arat iyyanda a isandan igitan-net. ");
INSERT INTO ttq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Zǝgzanat-i, nak d Abba arat iyyanda a nǝmos; kud ǝzǝgzan a wǝr tǝgem s awa ǝnne, zǝgzǝnat fǝl ǝddǝlil ǝn mazalan win as di-tǝnayam taggaq-qan. ");
INSERT INTO ttq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ǝggǝyyeɣ ǝsilakanaɣ-awan as wa sǝr-i izzǝgzanan, ad agu imazalan win tagga. Fadda ad agu win tan-ogarnen, fǝlas nak abba a zʼakka. ");
INSERT INTO ttq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Amaran a iqqal arat wa tǝgmayam s esǝm-in ad t-aga, fǝl ad tǝtǝwǝnǝy tanaya n Abba daɣ Barar. ");
INSERT INTO ttq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","As daɣ-i tǝgmayam arat a iqqal s esǝm-in, ad t-aga. ");
INSERT INTO ttq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kud tara a di-tǝgam, tǝttǝfam alwajiban-in. ");
INSERT INTO ttq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Amaran ad ǝgmǝya daɣ Abba a kawan-akfu ǝmadhal iyyan a ɣur-wan zʼimǝlan har faw. ");
INSERT INTO ttq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ǝnta a imosan Infas wa isinǝfililan tidǝt, as wǝr tǝfreg ǝddǝnet ǝlqǝbulat-net, fǝlas wǝr tu-tǝhǝnnǝy wala da tǝzday-tu; eges kawanay tǝzdâyam-tu fǝlas ihoz-kawan amaran ad iggǝz iwallan-nawan har faw. ");
INSERT INTO ttq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Wǝr kawan-z-ayya daɣ ǝddǝnet tǝmosam šilat ǝn gugelan, a kawan-d-ǝqqǝla. ");
INSERT INTO ttq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dǝffǝr alwaq wǝr nǝggǝt, ǝddǝnet wǝr di-za-tǝlǝs anay; eges kawanay a di-tǝlǝsam anay fǝlas ǝddâra, kawanay da ad tǝddǝram. ");
INSERT INTO ttq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Alwaq wǝdi ad tǝssǝnam as nak d Abba-nin arat iyyanda a nǝmos, tǝssǝnam deɣ as tǝhâm ǝwǝl-in, nak da aheɣ win-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wa ittafan alwajiban-in, ǝnta a di-iran. Wa di-iran ad t-iru Abba-nin, ireq-qu nak da, sǝnnǝfilǝlaɣ-as iman-in.» ");
INSERT INTO ttq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Inn-as Yahuza wa wǝr nǝmos ag Isxarǝyuti: «Ǝmǝli, manǝmmǝk as dana-za-tǝsǝnnǝfilǝlaɣ iman-nak nakkanay ɣas, wǝr tan-tǝssosana y ǝddǝnet?» ");
INSERT INTO ttq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Inn-as Ɣaysa: «Awedan wa di-iran, ad ittǝf awa ǝnne, ir-ay Abba-nin, nas-ay-du nǝmǝl ɣur-ǝs. ");
INSERT INTO ttq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wa di-wǝr-nǝra, wǝdi wǝr ǝttef batuten-in; amaran batu tas tǝsallim da, wǝrge nak a tat-igan kala ar šin Abba s ǝnta a di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ǝgeɣ-awan-tat harwa kawan-ǝhe. ");
INSERT INTO ttq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amaran ǝmadhal imosan Infas wa Zǝddigan wa dawan-du-z-assaglu Abba s ǝsǝm-in, a kawan-isassaɣru aratan kul, assakt-iwan-du arat kul wa dawan-ǝnne nak iman-in. ");
INSERT INTO ttq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Oyyeɣ-awan-du alxer, ǝkfeq-qawan alxer wa-nin; nak wǝr dawan-t-ǝkfeɣ ǝs tǝmǝwit tas tu-tǝhakku ǝddǝnet; ad wǝr tǝššǝwǝšam wala tǝggǝz-kawan tasa. ");
INSERT INTO ttq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tǝslâm-i as dawan-ǝnne: \"Teklay a ǝgeɣ\", ǝnneɣ harwa: \"A kawan-d-ǝqqǝla.\" Ǝnnar ixsâl as di-tǝrâm, tǝsǝffǝliwǝset-kawan tǝnna ta ǝgeɣ: \"Ǝqqalaɣ Abba\", fǝlas Abba ogar-i. ");
INSERT INTO ttq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amaran aratan win, ǝmâlaɣ-awan-tan ǝmǝrǝdda harwa wǝr ǝgen, fǝl a sǝr-i tǝzzǝgzǝnam alwaq wad zʼagin. ");
INSERT INTO ttq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wǝr dǝr-wan zʼǝlǝsa igi ǝn batu tagget, fǝlas ǝmǝnokal n ǝddǝnet izay-du. Wǝr di-in-ikka d arat, ");
INSERT INTO ttq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mišan kundaba ǝgeɣ awas di-omar Abba, tǝssǝn ǝddǝnet deɣ as areɣ Abba.» As iɣrad batu ta inn-asan: «Ǝnkǝrat ǝgmǝdatana edag a.» ");
INSERT INTO ttq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Inna Ɣaysa i nǝttulab-net: «Nak a imosan esab n alɣanab wa olaɣan, Abba-nin imos mǝššis. ");
INSERT INTO ttq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Alǝdlid-in kul wa wǝr nǝtirǝw ad t-ixtǝs, wa itarawan ad t-ifnǝz fǝl ad d-inzǝr agu ara aggen. ");
INSERT INTO ttq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Zun d adi da, kawanay da eway-du sǝr-wan awal-in tazdak; ");
INSERT INTO ttq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","agiwat dǝr-i tartǝyt šilat ǝn ta dǝr-wan ǝge, aẓǝl wǝr zʼarǝw ɣas-net as d-iqqǝtas daɣ ašǝk; kawanay da ǝlmital di da a tǝham as dǝr-i wǝr tǝrtayam. ");
INSERT INTO ttq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nak a imosan esab n alɣanab, kawanay ilǝdlad-net. Wa dǝr-i igan tartǝyt ta dǝr-ǝs ǝge, a t-idu-tǝgmǝd tǝnfa tagget fǝlas as daɣ-i in-tǝqqǝtasam wǝr tǝfregam wala. ");
INSERT INTO ttq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wa dǝr-i wǝr nǝrtay, a din-itǝwǝgǝr šilat n ǝlǝdlid iqqitasan, aqqar, itǝwǝkǝmmǝd-du, itǝwǝgǝr daɣ tǝmsay, ibǝlǝglǝg. ");
INSERT INTO ttq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","As dǝr-i tǝrtayam, tǝttafam batuten-in, ǝgmǝyat daɣ Mǝššina di n Abba arat kul wa tǝram, a tu-tǝgrawam. ");
INSERT INTO ttq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ǝnta da awas tǝtâwanay tanaya n Abba-nin: a du-tarǝwam tǝnfa tagget, assaknu adi as tǝmosam inǝttulab-in. ");
INSERT INTO ttq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tara ta di-iga Abba, ǝnta a dawan-ǝge; ǝttǝfat-tat. ");
INSERT INTO ttq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","As imos as tǝttâfam alwajiban-in, wǝdi tǝhâm tara-nin zund ǝmmǝk as nak da ǝttafa win Abba, ǝhe tara-net. ");
INSERT INTO ttq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ǝnneɣ-awan adi fǝl ad tagim tǝfalawist zun ta ǝgeɣ, tagim deɣ tǝfalawist tǝkmâlat. ");
INSERT INTO ttq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ǝnta da alwajib wa-nin: \"Namariwat s ǝmmǝk was kawan-are.\" ");
INSERT INTO ttq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wǝr tu-tǝlla tara togarat ad akfu awedan iman-net fǝl midawan-net. ");
INSERT INTO ttq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","As imos as tǝtaggim awas kawan-omara, wǝdi kawanay imidawan-in. ");
INSERT INTO ttq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wǝr dawan-gannaɣ eklan, fǝlas akli wǝr itǝssǝn arat wa itag mǝššis. Kala kalar a dawan-gannaɣ imidawan-in, fǝlas awas ǝsleɣ ɣur Abba-nin kul ǝssosanaɣ-awan-tu. ");
INSERT INTO ttq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wǝr di-tǝsannafranam, kawanay amaran, nak a kawan-isannafranan; ǝssiwaraq-qawan ad taglim, tammazalam awa tǝha tǝnfa tagget ɣur Mǝššina. Tǝnfa di da ta za tahagit. A tǝgmayam deɣ daɣ Abba s ǝsǝm-in a dawan-t-agu. ");
INSERT INTO ttq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Omâraq-qawan s ad tǝnǝmǝrim. ");
INSERT INTO ttq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kud gezzar a kawan-tǝga ǝddǝnet, ǝssǝnat as tǝgzâr-i dat-wan. ");
INSERT INTO ttq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kud kawanay ǝddǝnet kawan-tǝlat, wǝdi ǝddǝnet tǝrâ wa tǝla; mišan wǝr kawan-tǝla, fǝlas nak kawan daɣ-as d-isannafranan, adi a fǝl kawan-tǝgzar. ");
INSERT INTO ttq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aktiwat-du awa dawan-ǝnneɣ, as: \"Akli wǝr oger mǝššis.\" Kud ǝsǝkni a di-ǝgan alɣazab, a dawan-t-assaknin kawanay da; kud tǝrǝddawt a ǝgan s awal-in, wǝdi kawanay da, ad ardin ǝs wa-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Adi kul, ǝddǝlil-in a fǝl dawan-tu-z-agin; fǝlas wǝr ǝssenan wa di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ǝnnar du-wǝr-ose, ǝššewalaɣ-asan, wǝr zʼattarmasan ǝs bakkadan-nasan, eges ǝmǝrǝdda wǝr t-illa ǝsaru waliyyan a dasan-z-igdǝlan a sǝr-san attarmasan. ");
INSERT INTO ttq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wa di-igzaran, igzâr Abba-nin ǝnta da. ");
INSERT INTO ttq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ǝnnar wǝr ǝge gar-essan imazalan ǝs wǝr t-illa awedan as kala tan-iga, wǝr zʼattarmasan ǝs bakkadan-nasan. Ǝnayan-tan eges ǝglan ǝgzâran-ana nak d Abba-nin. ");
INSERT INTO ttq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mišan adi igâ fǝl ad tandu batu ta tǝtawaktabat daɣ Ǝttawret, tǝnnât: \"Ǝgzaran-i bannan.\" ");
INSERT INTO ttq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","As d-osa ǝmadhal wa dawan-du-z-assagla ɣur Abba, imosan Infas wa isinǝfililan tidǝt a sǝr-wan du-z-igmǝdan Abba, a fall-i aggayyat. ");
INSERT INTO ttq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kawanay da, a fall-i taggayyem, fǝlas tǝddewam dǝr-i harwa ɣur tizarat.» ");
INSERT INTO ttq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ǝmâlaɣ-awan adi fǝl a kawan-wǝr-igmǝd ǝzǝgzan-nawan. ");
INSERT INTO ttq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ad tǝtǝwǝkkǝsam daɣ ǝljǝmaɣat ǝn nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, fadda ilkâm alwaq daɣ-as wa daɣ-wan ikkasan iman, illa ɣur-ǝs as tara ǝn Mǝššina a immozal den. ");
INSERT INTO ttq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Adi a dawan-z-agin aytedan fǝlas wǝrmad a di-ǝzdayan wala ǝssânan Abba. ");
INSERT INTO ttq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ǝmâlaɣ-awan aratan di ǝmǝrǝdda, fǝl a tan-du-taktim as d-ewad alwaq wa daɣ zʼagin aytedan tara-nasan. Aratan win wǝr dawan-tan-ǝmela daɣ tizarat n ǝššǝɣǝl-in ɣur-wan, fǝlas alwaq wǝdi harwa da ǝddewa dǝr-wan.» ");
INSERT INTO ttq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Ǝmǝrǝdda ad ǝqqǝla wa di-d-izammazalan, mišan wǝr kawan-iha i di-issistanan ǝd dad ǝkke. ");
INSERT INTO ttq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eges ǝknân man-nawan aɣšud fǝl as dawan-ǝnneɣ adi. ");
INSERT INTO ttq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dǝr iga adi da ya, a dawan-ǝmǝla tidǝt: of-awan ad agla, fǝlas as wǝr ǝgle wǝr kawan-du-z-asu Ǝmadhal, as ǝgle amaran a dawan-t-id-assagla. ");
INSERT INTO ttq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","As d-osa ad issusǝn aytedan n ǝddǝnet as ǝxrâkan daɣ batu n awa imosan abakkad, d awa imosan taqqat ǝn Mǝššina d awa imosan ǝššǝriɣa-net. ");
INSERT INTO ttq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Issusǝn-tan as ǝxrâkan daɣ batu n awa imos abakkad fǝlas tugǝyt a ǝgan a sǝr-i ǝzzǝgzǝnan. ");
INSERT INTO ttq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Issusǝn-tan as ǝxrâkan daɣ batu n awa imosan taqqat fǝlas tewaɣlay a ǝgeɣ Abba amaran wǝr zʼǝlǝsaɣ ǝtǝwǝnay. ");
INSERT INTO ttq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Issusǝn-tan as ǝxrâkan daɣ batu n awa imosan ǝššǝriɣa ǝn Mǝššina fǝlas ǝmǝnokal n ǝddǝnet, a t-imosan Iblis, ibâz-tu ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Harwada ǝle batuten aggotnen as are a dawan-tanat-aga eges wǝr dasnat-tǝzmeram ǝmǝrǝdda. ");
INSERT INTO ttq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","As d-osa Infas wa Zǝddigan isinifililan tidǝt, a kawan-issǝlkǝm i tidǝt kul ta du-tǝfalat Mǝššina fǝlas batuten-net wǝrgeɣ ǝnta a du-z-ǝgmǝdnat, awa as zʼaslu ɣas a daɣ dawan-z-iššiwǝl ketnet, imǝl-awan aratan win d-ǝzaynen, ");
INSERT INTO ttq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","issǝɣmǝr-i fǝlas awa zʼigrǝw daɣ awa ǝle a dawan-z-imǝl. ");
INSERT INTO ttq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Awa ila Abba ketnet i-nin nak da; adi a fǝl dawan-ǝnne, awa igraw Infas wa Zǝddigan daɣ awa ǝle a dawan-z-imǝl.» ");
INSERT INTO ttq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«A dawan-ǝgmǝdaɣ anay dǝffǝr alwaq wǝr nǝggǝt, mišan a di-tǝlǝsam anay daɣ adan wǝr nǝggǝt dǝffǝr adi.» ");
INSERT INTO ttq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tǝzzar namannan wiyyad daɣ nǝttulab-net: «Ma imos almaɣna n awa danaɣ-inna da: \"A dawan-ǝgmǝdaɣ anay dǝffǝr alwaq wǝr nǝggǝt, mišan a di-tǝlǝsam anay daɣ adan wǝr nǝggǝt dǝffǝr adi?\" Ma imos deɣ almaɣna n \"Abba a ǝkke\"? ");
INSERT INTO ttq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma imos almaɣna ǝn \"daɣ alwaq wǝr nǝggǝt\" wa imal da? Arat wa daɣ iššewal da wǝr tu-nǝgra.» ");
INSERT INTO ttq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Issan Ɣaysa as ǝrân ad t-ǝsǝstanan. Inn-asan: «Tǝtinamasǝstinam fǝlas ǝnne: \"A dawan-ǝgmǝdaɣ anay dǝffǝr alwaq wǝr nǝggǝt, mišan a di-tǝlǝsam anay daɣ adan wǝr nǝggǝt dǝffǝr adi.\" ");
INSERT INTO ttq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ǝggǝyyeɣ silakanaɣ-awan as ad talim, tǝsǝkkǝlǝlam mišan aytedan n ǝddǝnet ǝntanay ǝddǝwen. Ad ǝɣšǝdan man-nawan eges aɣšud di a tu-tǝzrǝy tǝdǝwit. ");
INSERT INTO ttq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tantut as tǝtaggaz amaḍal, ad ǝɣšǝdan man-net fǝl aggad wa du-tǝga alwaq-net; mišan as d-ihu barar-net, ad tammazzay d ǝsǝmmǝdrǝn daɣ arkanay wa tǝnay, isǝddǝwat-tat as du-tǝga awedan daɣ ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kawanay da zun d adi da, ǝmǝrǝdda ǝɣšâdan man-nawan, mišan a kawan-ǝlǝsaɣ anay, ǝzǝl wǝdi ad tagim tǝdǝwit as tu-wǝr-illa i daɣ-wan tat-z-ikkǝsan. ");
INSERT INTO ttq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wǝr di-za-tǝssǝstanam d arat waliyyan ǝzǝl wǝdi. Ǝggǝyyeɣ silakanaɣ-awan as, a tǝgmayam daɣ Abba s esǝm-in a dawan-t-agu. ");
INSERT INTO ttq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Harwada wǝr t-illa a tǝgmâyam s esǝm-in. Ǝgmǝyat ad tǝgrǝwam fǝl ad tagim tǝdǝwit tǝkmâlat.» ");
INSERT INTO ttq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Ǝmâlaɣ-awan adi s ǝlmital, mišan ilkâm alwaq daɣ awan-wǝr-z-ǝlasaɣ emel n arat waliyyan iqqâlan Abba s ǝlmital, kalar a dawan-t-ǝmǝla s awa imos. ");
INSERT INTO ttq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Alwaq wǝdi ad tǝgmǝyam daɣ Abba s esǝm-in. Wǝr dawan-ǝnne a dawan-t-ansǝya, ");
INSERT INTO ttq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","fǝlas Abba iman-net ir-iwan fǝl as di-tǝram, tǝzzigzanam deɣ as ɣur-ǝs d-ǝgmâda. ");
INSERT INTO ttq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Abba a ɣur d-ǝgmada, ose-du ǝddǝnet amaran ǝmǝrǝdda a tat-ǝgmǝda ǝqqǝlaq-qu.» ");
INSERT INTO ttq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tǝzzar ǝnnan-as nǝttulab-net: «Ǝnǝy, ǝmǝrǝdda tǝmmalaɣ-anaɣ aratan s awa mosan, wǝrge s ǝlmital. ");
INSERT INTO ttq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nǝssăn as tǝssâna daɣ arat kul, wǝr t-illa arat a iqqal a dak-iɣbaran; adi da a fǝl nǝzzǝgzan as Abba a ɣur du-tǝgmada.» ");
INSERT INTO ttq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Inn-asan Ɣaysa: «Adis ǝmǝrǝdda tǝzzǝgzanam? ");
INSERT INTO ttq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ǝnǝyat, alwaq ihoz, fadda iga, wa daɣ za tǝtǝwǝzǝwǝziwizam, akkiyyan ikka aɣaywan-net, tayyim-i-d ɣas-in; mišan ya wǝr ǝmosa ɣas-in fǝlas illa ɣur-i Abba. ");
INSERT INTO ttq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ǝmâlaɣ-awan arat wa fǝl ad tǝgrǝwam alxer daɣ tǝrtǝyt ta dǝr-i tǝgam. Ad tǝnǝyam arkanay daɣ ǝddǝnet, ad wǝr tiksadam wala, fǝlas ǝddǝnet ǝrzêq-qat.» ");
INSERT INTO ttq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","As inna Ɣaysa awen, idkal asawad-net iggǝzzay ijǝnnawan, ittar inna: «Abba, alwaq ewad-du, saknu tanaya ǝn Barar-nak fǝl ad assaknu ǝnta da ta nak, ");
INSERT INTO ttq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","id tǝzzozaraq-qu y aytedan kul fǝl ad akfu tǝmǝddurt ta tǝɣlalat i win tu-tǝkfe. ");
INSERT INTO ttq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amaran tǝmǝddurt ta tǝɣlalat awa tat-imosan, ad inǝfilǝl y aytedan awa tǝmosa, kay a imosan Mǝššina wa n tidǝt; inǝfilǝl-asan ǝntada as Ɣaysa Ǝlmǝsix a du-tǝzammazala. ");
INSERT INTO ttq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ǝssikna tanaya-nak fǝl amaḍal s ǝsǝndi wa ǝge ǝššǝɣǝl was di-tǝssǝwaraɣ igi-net. ");
INSERT INTO ttq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Amaran ǝmǝrǝdda kay Abba, akf-i ɣur man-nak tanaya ta ɣur-ǝk ǝleɣ harwa dat ǝxluk n ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Sinafâlalaɣ awa tǝmosa y aytedan win du-tǝsannafrana tǝskataq-qan-du daɣ ǝddǝnet, tǝgeq-qan daɣ ǝfus-in ǝttafan awal-nak. ");
INSERT INTO ttq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ǝmǝrǝdda ǝssânan as arat kul wa di-tǝkfe, kay a ɣur d-igmad. ");
INSERT INTO ttq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Fǝlas ǝmâlaɣ-asan awa di-tǝnne, ǝqbalan-tu, amaran silakanan as kay a ɣur d-ǝgmada, ǝzzigzanan deɣ as di-du-tǝzimazala. ");
INSERT INTO ttq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Wǝr kay-tinsǝya y aytedan win ǝddǝnet, kalar aytedan win di-tǝkfe as kay-tansayaɣ fǝlas ǝntanay a tǝleɣ. ");
INSERT INTO ttq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Awa ǝle kul i-nak, kay da awa tǝle kul i-nu; amaran ǝntanay en da a daɣ tǝnafalal tanaya-nin. ");
INSERT INTO ttq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nak, abʼas aheɣ ǝddǝnet, kay a din-ǝkke, ǝntanay amaran ǝhân-tat. Ya Abba di zǝddigan, agǝz-tan s esǝm-nak wa di-tǝkfeɣ, fǝl ad ǝqqǝlan arat iyyanda šilat ǝn wa dǝr-ǝk ǝmosa. ");
INSERT INTO ttq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Harwa tan-ǝhe, ogâzaq-qan s esǝm-nak, a di-tǝkfê, wǝr daɣ-san ixrek waliyyan ar wa ixrakan fǝl ad andu awa ǝnnan Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ǝmǝrǝdda kay a din-ǝkke, gannaɣ awa harwa ǝheɣ ǝddǝnet fǝl ad agin tǝfalawist tǝndât ta da ǝgeɣ. ");
INSERT INTO ttq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ǝmâlaɣ-asan awal-nak tǝgzar-tan ǝddǝnet fǝlas wǝr tan-tǝla zun d as nak iman-in da wǝr di-tǝla. ");
INSERT INTO ttq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wǝr daɣ-ak ǝgmaya a tan-tǝkkǝsa daɣ ǝddǝnet, mišan ǝgmâya daɣ-ak a tan-tagǝza daɣ Iblis. ");
INSERT INTO ttq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wǝr tan-tǝla ǝddǝnet, zun d as nak iman-in da wǝr di-tǝla. ");
INSERT INTO ttq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Zǝzdǝg iwallan-nasan s awal-nak imosan tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ǝzǝmmizǝl wa di-du-tǝge s ǝddǝnet, ǝnta a tan-sǝr-ǝs-ǝge nak da. ");
INSERT INTO ttq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amaran ǝkfeq-qay iman-in fǝl ǝddǝlil-nasan fǝl ad akfin win-nasan ǝntanay da ǝs tidǝt. ");
INSERT INTO ttq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wǝrgeɣ inǝttulab-in ɣas as kay-tansaya, kalar tansayaq-qay y aytedan win sǝr-i zʼǝzzǝgzǝnnen s ǝssǝbab n as ǝslan y awal-nasan. ");
INSERT INTO ttq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ǝgmâya daɣ-ak a tan-igan ketnasan arat iyyanda s ǝmmǝk was dǝr-ǝk t-ǝmosa; nǝqqǝl-tu dǝr-san nakkanay da fǝl ad tǝzzǝgzǝn ǝddǝnet as kay a di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ǝkfêq-qan tanaya ta di-tǝkfe, fǝl ad ǝqqǝlan arat iyyanda s ǝmmǝk was tu-nǝmos nak dǝr-ǝk. ");
INSERT INTO ttq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nak ǝrtâya dǝr-san, kay tǝrtâya dǝr-i. Ǝqqǝlanet arat iyyanda ǝs tǝmǝwit tǝndât fǝl ad tǝssǝn ǝddǝnet as kay a di-d-izammazalan tǝgeɣ-asan deɣ tara ta di-tǝge. ");
INSERT INTO ttq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Abba, areɣ as win di-tǝkfe ad ǝggǝzan ǝntanay da edag wa ǝhe fǝl ad ǝhannayan tanaya ta di-tǝkfe fǝlas di-tare harwa dat ǝxluk n ǝddǝnet. ");
INSERT INTO ttq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Abba, kay a oɣadan, ǝddǝnet wǝr kay-tǝssen eges nak ǝssânaq-qay amaran inǝttulab-in, ǝssânan as kay a di-d-izammazalan. ");
INSERT INTO ttq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ǝssôsanaq-qan awa tǝmosa amaran wǝr zʼammazzaya d igi n adi, fǝl a tan-tǝggǝz tara ta di-tǝgeɣ, ǝrtǝya dǝr-san.» ");
INSERT INTO ttq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","As iga Ɣaysa batu ta, ikka tama ta hadat n ǝgirer wa n Kedron. Iggaz afarag n eškan illân-den ǝnta ǝd nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Edag wen issân-tu Yahuza Isxarǝyuti wa zʼakkaddalan Ɣaysa, fǝlas faw da itakk-ay Ɣaysa ǝnta ǝd nǝttulab-net. ");
INSERT INTO ttq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Azzar-du Yahuza y agan ǝn sojitan ǝn Kǝl-Ǝrrum, ǝd magazan n Ahan wa Zǝwwǝran n Ǝlɣibada a d-ǝssîglan muzaran ǝn limaman, ǝd Farisaytan, ewâyan fǝtǝlaten, ǝd belan, ǝd tǝzoli-nasan. ");
INSERT INTO ttq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","As din-ewadan ihoz-tan-in Ɣaysa issânan daɣ arat kul wa tu-z-igrǝwan, issǝstan-tan inn-asan: «Ma imos was tǝsaggadam?» ");
INSERT INTO ttq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ǝnnan-as: «Ɣaysa wa n Nazaret as nǝsaggad.» Inn-asan: «Nak da da.» Ibdâd gar-essan Yahuza wa t-ikkǝddalan. ");
INSERT INTO ttq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Amazay wa da daɣ dasan-inna Ɣaysa: «Nak da da» ǝnta a daɣ ǝrmaɣan ǝqqalan dǝffǝr-san har udan. ");
INSERT INTO ttq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ilas Ɣaysa inn-asan: «Ma imos was tǝsaggadam?» Ǝnnan-as: «Ɣaysa wa n Nazaret as nǝsaggad.» ");
INSERT INTO ttq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Inn-asan: «Wǝrgeɣ ǝnneɣ-awan nak da da. Daɣ adi kud nak as tǝsaggadam, tayyim aytedan win da ad jǝwǝnken.» ");
INSERT INTO ttq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ǝmmǝk wen da as inda awal wa iga dat awen as inna: «Wǝr daɣ-i zʼixrǝk waliyyan daɣ win di-tǝkfe.» ");
INSERT INTO ttq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ihâd-du Simɣon Butros ilbây-du takoba-net iwat sǝr-ǝs akli n Ǝlimam wa Zǝwwǝran, ifras-du tǝmǝzzuk-net ta n ǝɣil. Akli wa esǝm-net Malxus. ");
INSERT INTO ttq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tǝzzar inna Ɣaysa i Butros: «Suɣǝl takoba-nak tǝtǝrut! Awak ad aqqama wǝr ǝgeɣ alɣazab wa di-ixkam Abba?» ");
INSERT INTO ttq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tǝzzar obazan Ɣaysa, ǝkradan-tu, ǝmosan egan ǝn sojitan ǝn Kǝl-Ǝrrum d ǝmuzar-nasan, ǝd magazan n Ahan wa Zǝwwǝran n Ǝlɣibada a d-ǝssiglan muzaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ewayan-tu azzaran dǝr-ǝs s aɣaywan ǝn Xânan wa n ǝdaggal ǝn Kayif wa imosan Ǝlimam wa Zǝwwǝran daɣ awatay wen. ");
INSERT INTO ttq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Amaran Kayif ǝnta a igan i muzaran ǝn Kǝl-Ǝlyǝhud tanat ta n as ofa ad ammat awedan iyyanda daɣ adag ǝn tamattay. ");
INSERT INTO ttq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ilkam Simɣon Butros i Ɣaysa ǝnta d ǝnattalib iyyan. Ǝnattalib wa izdây Ǝlimam wa Zǝwwǝran iman-net, tǝzzar iggaz afarag wa iɣlayan aɣaywan n Ǝlimam wa Zǝwwǝran daɣ amazay wa da daq-q iggaz Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Butros ǝnta iqqim-du dat ahan, ɣur ǝmi n aɣalla. Irdaɣ-du ǝnattalib wen, igraw ɣur tǝntut ta togazat tǝsǝhǝrt ad tayyu Butros iggǝz aɣaywan. ");
INSERT INTO ttq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tǝzzar tǝnna tǝmaššaɣalt ta togazat imi n ahan i Butros: «Wǝrge kay da iyyan daɣ nǝttulab n alǝs wa a tǝmosa?» Inn-as: «Wǝr t-ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Asamed igâ. Ɣilayɣalayan eklan ǝd magazan n Ahan wa Zǝwwǝran n Ǝlɣibada temsay ǝn tǝmakaten ǝsukusan sǝr-ǝs. Ik-en-in Butros ǝnta da ad isukus. ");
INSERT INTO ttq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","As itaggu awen isastan Ǝlimam wa Zǝwwǝran Ɣaysa daɣ talɣa ǝn nǝttulab-net, d ǝsǝssǝɣri wa itaggu. ");
INSERT INTO ttq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Inn-as Ɣaysa: «Awal wa ǝge y ǝddǝnet, wǝr imos arat iɣbâran. Faw da inan ǝn taɣaray ǝn Kǝl-Ǝlyǝhud d Ahan wa Zǝwwǝran n Ǝlɣibada a daɣ sasaɣra dad ǝddewan Kǝl-Ǝlyǝhud kul, daɣ adi wǝr t-illa awal ǝge daɣ ǝssir. ");
INSERT INTO ttq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mafel as di-tǝsastana? Sǝstǝn aytedan win di-ǝslanen d aratan win daɣ dasan-ǝmmǝgrada; ǝntanay ǝssânan daɣ arat wa ǝnne.» ");
INSERT INTO ttq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","As inna Ɣaysa arat wa, iqqas-as iyyan daɣ magazan n Ahan wa Zǝwwǝran n Ǝlɣibada ibdâdan den, inn-as: «Ma kay-issǝhalan igi n aljawab wa y Ǝlimam wa Zǝwwǝran?» ");
INSERT INTO ttq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ijjǝwwab-as Ɣaysa inn-as: «Kud arak batu a ǝge, ǝmǝl-i edag wa daq qat-ǝge. Kud amaran ǝgeɣ batu tolaɣat, ma imos ǝddǝlil wa fǝl di-tǝggata?» ");
INSERT INTO ttq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Issǝrdaq-qu Xânan da ikrad, issok-ay Kayif wa n Ǝlimam wa Zǝwwǝran. ");
INSERT INTO ttq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","As itaggu awen, Simɣon Butros illa den isukus ǝs tǝmsay en da. Itawann-as: «Wǝrge kay da arat daɣ nǝttulab n alǝs wa a tǝmosa?» Ilas Butros šigget ǝn Ɣaysa, inna: «Kala kala wǝr t-ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Inkar-du iyyan daɣ eklan n Ǝlimam wa Zǝwwǝran, imosan ǝšǝqqaɣ n alǝs was d-ifras Butros tǝmǝzzuk-net, inna i Butros: «Wǝrgeɣ ǝnâyaq-qay tǝddewa dǝr-ǝs daɣ afarag?» ");
INSERT INTO ttq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ilas Butros šigget ǝn Ɣaysa. Amazay wen da daɣ iɣra ǝkǝji aɣora. ");
INSERT INTO ttq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Immeway Ɣaysa ɣur Kayif s aɣaywan n ǝnaxkim. Itaggu awen ɣur ǝfǝrirǝy n anay. Aytedan win dǝr-ǝs d-ǝddewnen wǝr dǝr-ǝs ǝggezan aɣaywan wa n ǝnaxkim, fǝl ad ǝttǝfan tazdak-nasan har atšin amensay wa n Akkay. ");
INSERT INTO ttq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Awen da fǝl sǝr-san d-igmad Bilatǝs wa n ǝmuzar n akal ehan-net, ikk-en-du inn-asan: «Ma imos lahan wa fǝl tǝbazam alǝs wa?» ");
INSERT INTO ttq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ǝnnan-as: «Ǝnnar wǝr imos ǝmǝggi ǝn tǝkma, wǝr dak-k-idu-za-nawǝy». ");
INSERT INTO ttq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Inn-asan Bilatǝs: «Awǝyat-tu tǝxkǝmam-as s ǝššǝriɣa wa-nawan.» Ǝnnan-as Kǝl-Ǝlyǝhud: «Nakkanay wǝr nǝla turagat ǝn tanaɣay n awedan.» ");
INSERT INTO ttq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Arat wa igâ fǝl ad andu awal wa iga Ɣaysa assaɣa wad imal ǝnnuɣ ǝn tǝmattant ta zʼagu. ");
INSERT INTO ttq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tǝzzar iqqal Bilatǝs ehan-net iɣr-in Ɣaysa issǝstan-tu inn-as: «Awak kay daɣ a imosan ǝmǝnokal ǝn Kǝl-Ǝlyǝhud?» ");
INSERT INTO ttq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Inn-as Ɣaysa: «Arat wa kay iman-nak as tu-tǝnne, meɣ ak aytedan wiyyad a dak-k-ǝnnanen sǝr-i?» ");
INSERT INTO ttq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Inn-as Bilatǝs: «Un nak iyyan daɣ Kǝl-Ǝlyǝhud a mosa? Tamattay-nak, ǝd limaman win zawwarnen a kay-d-ewaynen sǝr-i, ma imos arat wa tǝɣšada?» ");
INSERT INTO ttq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ijjǝwwab-as Ɣaysa inn-as: «Taɣmar-in wǝr tat-tǝla ǝddǝnet ta da. Ǝnnar taɣmar-in tǝll-et ǝddǝnet a, ǝnkǝrnat-du tǝɣurad-in ǝknǝsnat fǝl ad wǝr ǝggǝzaɣ ifassan ǝn Kǝl-Ǝlyǝhud. Kala kala, igmâd aššak as taɣmar-in wǝr tat-tǝla ǝddǝnet ta da.» ");
INSERT INTO ttq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Inn-as Bilatǝs: «Ak tidǝt as kay a imosan ǝmǝnokal ǝn Kǝl-Ǝlyǝhud?» Ijjǝwwab-as Ɣaysa inn-as: «Kay da tǝnneɣ adi. Awalla ǝmǝnokal a mosa. Arat da wa fǝl d-ǝhǝwa amaran ǝnta fǝl d-ǝggazaɣ ǝddǝnet a t-imosan as assa a d-ǝge y ad aggayyeɣ i tidǝt. Awedan wa ilkaman i tidǝt, kul issisam y awal-in.» ");
INSERT INTO ttq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Inn-as Bilatǝs: «Tidǝt za ma tǝmos?» Tǝzzar iqqal-du Bilatǝs Kǝl-Ǝlyǝhud inn-asan: «Fǝl aganna za wa di-iqqalan nak, wǝr ǝhǝnnǝya lahan waliyyan iga alǝs wa. ");
INSERT INTO ttq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mišan ya, daɣ arat wa imosan alɣadat âs id d-iɣlay ǝmud wa n Akkay a dawan-d-ǝkkǝsaɣ iyyan daɣ mǝskǝsa-nawan. Meqqal tarâm a dawan-sassayya ǝmǝnokal ǝn Kǝl-Ǝlyǝhud?» ");
INSERT INTO ttq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ǝlasan adakal ǝn maslan-nasan wǝllen ketnasan ǝnnan-as: «Kala, kala, wǝrgeɣ ǝnta! Barɣabbas as nǝra danaq-q-idu-tǝkkǝsa.» Barɣabbas wa ǝjajǝb n ǝnǝffellǝg a imos. ");
INSERT INTO ttq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tǝzzar omar Bilatǝs s ad tǝwǝgginat tǝwit n ǝlǝkkud i Ɣaysa; itawagg-as awen da. ");
INSERT INTO ttq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ǝzdăn sojitan tǝkǝbbut tǝgât ǝs šǝnnanan ǝssǝwaran-tat eɣaf-net, ǝzzǝzlagan-tu deɣ ǝbǝrnuz zaggaɣan. ");
INSERT INTO ttq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tihazan-t-in gannan-as: «Oyy-ik! Ǝmǝnokal ǝn Kǝl-Ǝlyǝhud!» Taqqasan-as sa ǝd sa. ");
INSERT INTO ttq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ilas-du Bilatǝs aradaɣ, inna i Kǝl-Ǝlyǝhud: «Ǝnǝyat! A dawan-t-id-ǝssǝrdǝɣa, ad tǝssǝnam as wǝr fall-as ǝnaya lahan waliyyan fǝl iwwǝddab.» ");
INSERT INTO ttq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tǝzzar irdaɣ-du Ɣaysa tǝwâr-tu tǝkǝbbut ǝn šǝnnanan, izlâg ǝbǝrnuz zaggaɣan, inn-asan Bilatǝs: «Alǝs-nawan ǝddi.» ");
INSERT INTO ttq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","As t-oggan muzaran ǝn limaman ǝd magazan n Ahan wa Zǝwwǝran n Ǝlɣibada, ǝdkalan imaslan-nasan gannin: «Taytay-tu fǝl tǝgǝttawt! Taytay-tu fǝl tǝgǝttawt!» Inn-asan Bilatǝs: «Abǝzat-tu kawanay iman-nawan tattaytayam-tu, nak wǝr hǝnnǝyaɣ ǝddǝlil waliyyan a t-issiwaran tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ǝnnan-as muzaran ǝn Kǝl-Ǝlyǝhud: «Nakkanay nǝla ǝššǝriɣa, amaran ǝššǝriɣa wa, ih-ay as alǝs wa ihor ǝd tǝmattant, fǝlas a inna ǝnta Barar ǝn Mǝššina a imos.» ");
INSERT INTO ttq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Batu ta tǝga tasa wǝllen daɣ Bilatǝs, ");
INSERT INTO ttq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","iqqal ehan-net, iggaz edag wa n ǝššǝriɣa, inna i Ɣaysa: «Mǝnis du-tǝhe?» Mišan wǝr das-iga Ɣaysa aljawab waliyyan. ");
INSERT INTO ttq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Amazay wen da das-inna Bilatǝs: «Nak as tugaya s a di-tǝššiwǝla? Wǝr tǝssenaɣ as ǝle fǝrregat n a kay-sassayya, ǝleɣ ǝntada fǝrregat n a kay-attaytaya fǝl tǝgǝttawt?» ");
INSERT INTO ttq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Inn-as Ɣaysa: «Wǝr fall-i tǝle tarna waliyyat ar ta sǝr-ǝk du-tǝfalat Mǝššina. Adi da fǝlas awedan wa di-igan gǝr fassan-nak, ogar-kay igi n abakkad.» ");
INSERT INTO ttq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Amazay wen da daɣ iggaz Bilatǝs šin agamay n asaway was zʼayyu Ɣaysa. Mišan ǝnkaran-du Kǝl-Ǝlyǝhud ad gannin s afalla: «Alǝs di as tu-tǝsassayya, wǝdi wǝr tǝmosaɣ ǝmidi ǝn Qaysara, ǝmǝnokal ǝn Kǝl-Ǝrrum, fǝlas awedan wa innan imos ǝmǝnokal, wǝdi azangaw ǝn Qaysara a imos!» ");
INSERT INTO ttq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","As isla Bilatǝs i batu ta, issǝrdaɣ-du Ɣaysa, tǝzzar iqqim daɣ tǝxawit ta n adag n ǝššǝriɣa. Edag wa esǝm-net «Aɣarɣar ilsân tǝsǝlit» itawann-as daɣ tǝlɣibrit «Gabbata». ");
INSERT INTO ttq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Itaggu awen ammasnazal n ǝzǝl wa oggan amud wa n Akkay, simutugan aytedan y ǝmud. Inna Bilatǝs i Kǝl-Ǝlyǝhud: «Ǝmǝnokal-nawan ǝddi!» ");
INSERT INTO ttq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iqqal-asan awen as sahhaken imaslan-nasan wǝllen gannin: «Ammatet! Ammatet! Taytay-tu fǝl tǝgǝttawt!» Inn-asan Bilatǝs: «Daɣ adi ad attaytayaɣ ǝmǝnokal-nawan fǝl tǝgǝttawt?» Ǝnnan-as muzaran ǝn limaman: «Ǝmǝnokal-nana wǝr t-imos ar Qaysara.» ");
INSERT INTO ttq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tǝzzar ikf-en Bilatǝs Ɣaysa y ad itǝwǝtǝytǝy fǝl tǝgǝttawt. Ǝzzǝrgazan sojitan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Igmad aɣrǝm ewây ǝnta iman-net tǝgǝttawt ta fǝl zʼitǝwǝtǝytǝy. Ǝkkan dǝr-ǝs edag as itawannu «Tǝkǝyya», itawann-as deɣ daɣ tǝlɣibrit «Golgota». ");
INSERT INTO ttq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Den da ad ǝttǝytayan sojitan Ɣaysa fǝl tǝgǝttawt. Tawataytayan ǝššin meddan wiyyad ǝntanay da fǝl tǝgǝttawen dǝgma-net, a daɣ illa Ɣaysa gar-essan. ");
INSERT INTO ttq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Omar Bilatǝs s ad ammadkal ǝsǝllum itǝwǝktǝb fall-as: «Awa Ɣaysa wa n Nazaret, Ǝmǝnokal ǝn Kǝl-Ǝlyǝhud», itǝwǝtǝytǝy daɣ afalla ǝn tǝgǝttawt. Itawagga awen da. ");
INSERT INTO ttq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ǝɣran Kǝl-Ǝlyǝhud aggotnen ǝsǝllum wa. Ǝnta edag wa daɣ itawataytay Ɣaysa fǝl tǝgǝttawt ihoz aɣrǝm, amaran ǝsǝllum wa iktâb daɣ awal wa n tǝlɣibrit, ǝd wa n tǝlatint ǝd wa n tǝlyunant. ");
INSERT INTO ttq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ǝnnan limaman win zawwarnen ǝn Kǝl-Ǝlyǝhud i Bilatǝs: «Ad wǝr tayyaɣ ǝsǝllum wa tǝssǝltaɣa tǝgǝttawt iktâb fall-as âs: \"Alǝs wa ǝmǝnokal ǝn Kǝl-ǝlyǝhud\", kalar ǝktǝb fall-as âs: \"Alǝs da wa innan ǝnta a imosan ǝmǝnokal ǝn Kǝl-Ǝlyǝhud.\"» ");
INSERT INTO ttq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Inn-asan Bilatǝs: «Arat wa ǝktaba, wǝr-tu-za-sǝmmǝttǝya.» ");
INSERT INTO ttq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","As ǝttǝytayan sojitan Ɣaysa fǝl tǝgǝttawt, ǝdkalan isǝlsa-net, ǝgan-asan ǝkkozat tǝzunen, ǝkkulluk n iyyan daɣ-san igrâw iyyat. Ǝdkalan ǝntada tǝkadkat-net ta zǝwwǝrat, tǝgât daɣ tǝbdoq wǝr iha a imosan azamay, tosâɣ-du ɣur afalla har eres. ");
INSERT INTO ttq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ǝnnan gar-essan: «Ad wǝr nǝzǝzzǝrrǝt tǝkadkat ta, ofa ad nagu šišaɣeren fǝl ad nǝssǝn wa tat-z-ilen.» Arat wa ǝnnân-tu fǝl ad tandu batu tǝhât Ǝlkǝttaban ta tǝnnat: «Ǝzunan tabdoq-in, tǝzzar ǝgan šišaɣeren fǝl tǝkadkat-in.» Arat wen ǝnta iman-net a ǝgan sojitan win den. ");
INSERT INTO ttq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tǝgǝttawt ta fǝl ittǝytay Ɣaysa, ǝbdâdnat dagma-net tǝdoden ǝmosnen anna-net, ǝd Maryama ta n tamadrayt n anna-net, tǝmosat taɣur Klobas, ǝd Maryama Madǝl. ");
INSERT INTO ttq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ogga Ɣaysa anna-net, inay ǝnattalib-net wa n ǝmǝri-net ibdâd dagma-net, inn-as: «Anna, barar-nam ǝddi.» ");
INSERT INTO ttq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tǝzzar inna y ǝnattalib-net wen: «Anna-nak ǝddi.» Amazay wen da daɣ dǝr-ǝs iddew ǝnattalib wen s aɣaywan-net issan daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Dǝffǝr awen inna Ɣaysa: «Ih-i fad», fǝlas issân as arat kul ikmal, amaran arat wa wǝr t-inna ar fǝl ad andu awa ǝnnan Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Edag en insa daɣ-as ǝɣǝzu iha bǝnegǝr, tǝmmǝdkal-du tǝduft tǝtawattal d ǝmi n agabal n ǝzzǝnǝf n ǝnniɣnaɣ iyyan idwâlan as itawannu xisof, tǝtawasalmaɣ-du daɣ bǝnegǝr wa, tǝtawazzal-in s ǝmi-net. ");
INSERT INTO ttq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","As izannalmaz Ɣaysa bǝnegǝr, inna: «Arat kul ikmal.» Tǝzzar issǝras eɣaf-net, ǝgmadan-tu man. ");
INSERT INTO ttq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ǝzǝl wen simutugan aytedan y ǝmud wa n Akkay. Wǝr ǝren Kǝl-Ǝlyǝhud ad aqqaminat alzanazaten n aytedan ǝwârnat šigǝttawen daɣ ǝzǝl wa n tǝsanfawt-nasan. Ǝnta ǝzǝl wen, wǝr ogda ǝd win hadatnen tǝzzǝwwǝrt. Ǝkkan muzaran ǝn Kǝl-Ǝlyǝhud Bilatǝs ǝnnan-as: «Amǝr s ad tawarzin daran-nasan, fǝl a tan-iba tarmad, tǝssukǝsa-du alzanazaten-nasan!» ");
INSERT INTO ttq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ǝkkan-du sojitan meddan win tawataytaynen dagma ǝn Ɣaysa. Ǝrzan idaran ǝn wa azzaran, okayan ǝs wa n ǝššin ǝgan-as awen da. ");
INSERT INTO ttq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","As d-ewadan Ɣaysa ǝnayan âs as d-osan da aba-tu. Ǝqqiman da wǝr ǝrzen idaran-net, ");
INSERT INTO ttq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mišan idag iyyan daɣ sojitan win tasaga ǝn Ɣaysa s allaɣ-net, iffay-du daɣ-as ǝzni d aman. ");
INSERT INTO ttq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Awedan wa igan isalan win, inay-tan ǝs šittawen-net, amaran tǝgǝyya-net tidǝt a tǝmos. Issân as tidǝt ta tǝzdarat as iššewal da, fǝl ad tǝzzǝgzǝnam kawanay da. ");
INSERT INTO ttq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ǝnta aratan win kul wǝr ǝgen ar fǝl ad tandu batu tǝhât Ǝlkǝttaban ta tǝnnat: «Eɣas-net waliyyan wǝr zʼarraz.» ");
INSERT INTO ttq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ǝlkǝttaban ih-en ǝntada as: «Ad ǝssǝdǝgan isawadan-nasan sa sǝr wa saxxarabben.» ");
INSERT INTO ttq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Dǝffǝr adi osa-du Yusǝf wa n ǝɣrǝm n Arimatay, imosan iyyan daɣ nalkiman ǝn Ɣaysa, eges daɣ ǝssir, fǝlas iksud Kǝl-Ǝlyǝhud. Ikka Bilatǝs igmay daɣ-as ad awǝy taɣǝssa ǝn Ɣaysa. Ikf-ay Bilatǝs turagat n awen, tǝzzar igla eway-tat. ");
INSERT INTO ttq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Osa-du Nikodemos ǝnta da, s ǝnta as kala din-osa Ɣaysa ahad iyyan. Eway-du tǝfaršit daɣ ǝnɣâlan alwarditan tǝmosat amaḍal ǝn karadat tǝmǝrwen ǝn kilaw. ");
INSERT INTO ttq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Idkal-du Yusǝf ǝd Nikodemos taɣǝssa ǝn Ɣaysa ǝgan-tat daɣ šifit tǝgât daɣ tǝsǝwad, ǝssǝlalan-tat aḍutan ǝzodnen win. Arat wa imos alɣadat ǝn Kǝl-Ǝlyǝhud daɣ anabal ǝn nǝmmǝttan. ");
INSERT INTO ttq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Edag wa daɣ itawataytay Ɣaysa fǝl tǝgǝttawt ih-ay afarag. Amaran afarag wen ih-ay ǝzǝkka imosan akazam as wǝr kala a daɣ-as itawagga ǝnǝmmettǝn. ");
INSERT INTO ttq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ǝzǝl wen ǝnta daɣ simutugan Kǝl-Ǝlyǝhud y ǝzǝl-nasan wa n tǝsanfawt, awen da fǝl iga Yusǝf ǝd Nikodemos Ɣaysa daɣ ǝzǝkka wa, fǝlas ǝnta a ihozan. ");
INSERT INTO ttq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","As affaw ǝzǝl wa n alxad, harwa da wǝr ifarayray anay, as tǝkka Maryama Madǝl ǝzǝkka. As din-tosa tǝnay as tǝhunt ta tǝharat ǝzǝkka tǝtiwakkas-du. ");
INSERT INTO ttq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tozal tǝkka Simɣon Butros d anattalib wa isannahal Ɣaysa tara tǝnn-asan: «Ǝmǝli itawakkas daɣ ǝzǝkka amaran wǝr nǝssen edag wa daɣ itawagga.» ");
INSERT INTO ttq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Irdaɣ-du Butros d anattalib wa hadan ǝkkan ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ozalan, azzar-in ǝnǝttalib wa hadan fǝlas orna Butros daɣ azzal. ");
INSERT INTO ttq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iššǝgga inay šisǝwad šin šifit ǝnsânat den, mišan wǝr iggez. ");
INSERT INTO ttq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","As d-ewad Simɣon Butros wa das-d-ilkaman, iggaz ǝzǝkka, inay ǝntada šisǝwad šin ǝnsânat den. ");
INSERT INTO ttq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Inay asalsaw wa iwaran eɣaf ǝn Ɣaysa wǝr irtay ǝd šifit, ittâl insa s aganna. ");
INSERT INTO ttq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tǝzzar iggaz-du anattalib wa hadan, s ǝnta a d-azzaran, inay arat wa izzǝgzan-tu. ");
INSERT INTO ttq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ǝnta harwa da wǝr ǝgren batu ta tǝnnat daɣ Ǝlkǝttaban, Ǝlmǝsix kundaba inkar-du daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tǝzzar ǝqqalan nǝttulab win den aɣaywan. ");
INSERT INTO ttq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tǝqqim-du Maryama tǝhallu dagma n ǝzǝkka. Tǝššǝgg-in daɣ-as, ");
INSERT INTO ttq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","tǝnay ǝššin angalosan ǝssimlalnen, ǝqqiman daɣ adag was kala a tu-tǝha tǝɣǝssa ǝn Ɣaysa. Iyyan illa ɣur anamod n aɣaf-net, wa hadan illa ɣur daran-net. ");
INSERT INTO ttq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ǝnnan-as: «Ma kam-isâlan, tantut?» Tǝnn-asan: «Wǝr di-isǝlu ar as immeway Ǝmǝli-nin, amaran wǝr ǝssena dad itawagga.» ");
INSERT INTO ttq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","As tǝnna arat wa, tǝswad dǝffǝr-ǝs, togga Ɣaysa ibdâd. Mišan wǝr tǝssen as ǝnta awen. ");
INSERT INTO ttq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Inn-as Ɣaysa: «Ma kam-isâlan tantut? Ma imos was tǝsaggada?» Tǝnn-as Maryama: «Ya alǝs, kud kay a t-ewayan, tǝmǝlaɣ-i dad illa, a t-id-awǝya.» Arat wa, as das-tu-tǝnna a tǝɣil ǝmagyak n afarag wa iha ǝzǝkka a das-iššewalan den. ");
INSERT INTO ttq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Inn-as Ɣaysa: «Maryama!» Tǝzzar tǝmalallay-t-in tǝnn-as daɣ awal wa n tǝlɣibrit: «Rabbuni!» (Almaɣna n awen Ǝššex-in.) ");
INSERT INTO ttq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Inn-as Ɣaysa: «A di-wǝr-tǝgdǝla teklay, fǝlas harwa da wǝr ǝggǝzzaya s Abba, kalar aglu ǝmǝl i mǝdrayan-in as nak ad aggazzaya s Abba-nin, s ǝnta a imosan Abba-nawan kawanay da, aggazzaya s Ǝmǝli-nin s ǝnta a imosan Ǝmǝli-nawan kawanay da.» ");
INSERT INTO ttq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tǝgla Maryama Madǝl tǝmal i nǝttulab as tǝnây Ǝmǝli, tǝmal-asan deɣ awa das-inna. ");
INSERT INTO ttq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tadwit n alxad wen da iman-net, ǝddewan nǝttulab, ǝɣfalan-du ehan fǝl man-nasan, fǝlas ǝksudan imuzaran ǝn Kǝl-Ǝlyǝhud. Osa-du Ɣaysa ibdad gar-essan inn-asan: «Alxer fall-awan!» ");
INSERT INTO ttq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","As dasan-inna awen issǝkn-en ifassan-net, ǝd tasaga-net. Falawasan nǝttulab fǝl anay wa ǝgan Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ilas inn-asan: «Ig-awan Mǝššina alxer! Ǝzimazalaq-qawan s ǝmmǝk was di-d-izammazal Abba.» ");
INSERT INTO ttq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","As dasan-iga batu ta, issǝwad-du fall-asan s ǝmi-net, inn-asan: «Tǝgrǝwamet Infas wa Zǝddigan! ");
INSERT INTO ttq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Win as tǝssorafam ibakkadan-nasan za, a dasan-tǝwǝsurǝfan, amaran win as tan-wǝr-tǝssorafam, wǝr zʼǝgrǝwan tǝsureft-nasan.» ");
INSERT INTO ttq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tuma was tǝsǝmmadǝq-net Eknay imosan iyyan daɣ nǝttulab win maraw d ǝššin, wǝr illa den as ǝnayan Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","As das-ǝnnan nǝttulab win: «Nǝnây Ǝmǝli!» Inn-asan: «Wǝr zʼǝzzǝgzǝnaɣ iket wǝr ǝnaya šimijar ǝn nǝsmar daɣ fassan-net, ǝdǝsaɣ idaggan-nasan s adad-in, ǝdǝsa deɣ tasaga-net s ǝfus-in.» ");
INSERT INTO ttq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","As ǝgan ǝttam adan dǝffǝr awen, ǝddewan-du nǝttulab ǝn Ɣaysa daɣ ahan iyyan amaran taklat ten ih-en Tuma. Iggaz-du fall-asan Ɣaysa da ǝharnat tǝsǝhar n ahan, ibdad gar-essan, inn-asan: «Ig-awan Mǝššina alxer!» ");
INSERT INTO ttq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dǝffǝr adi inna i Tuma: «Agu adad-nak da, tǝswǝda daɣ fassan-in, tǝdǝsa deɣ tasaga-nin s ǝfus-nak, tǝzzǝgzǝna taqqama da wǝr tǝqqelaɣ awedan wǝr nǝssen Mǝššina!» ");
INSERT INTO ttq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Inn-as Tuma: «Ya Mǝššina di n Ǝmǝli-nin!» ");
INSERT INTO ttq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Inn-as Ɣaysa: «Kay wǝr tǝzzǝgzana har di-tǝnaya. Ǝbbilalan aytedan win di-wǝr-nǝnay mišan ǝzzigzanan!» ");
INSERT INTO ttq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Immozal Ɣaysa alɣalamaten šiyyad aggotnen dat nǝttulab-net, mišan ya wǝr sǝr-ǝsnat immǝgrad ǝlkǝttab wa. ");
INSERT INTO ttq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Eges arat wa t-ihan, itiwaktab fǝl ad tǝzzǝgzǝnam as Ɣaysa ǝnta a imosan Ǝlmǝsix, imos deɣ Barar ǝn Mǝššina, amaran, as sǝr-ǝs tǝzzǝgzanam ad tǝgrǝwam tǝmǝddurt s esǝm-net. ");
INSERT INTO ttq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dǝffǝr awen ilas Ɣaysa ǝnǝfilal i nǝttulab fǝl tǝgadamayt n agaraw wa n Tiberǝyad. Ǝmmǝk da was dasan-inafalal: ");
INSERT INTO ttq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɣon Butros, ǝd Tuma was tǝsǝmmadǝq-net Eknay, ǝd Natanǝyel wa n Kâna daɣ amaḍal ǝn Galilaya, ǝd bararan ǝn Zabaday, d ǝššin nǝttulab wiyyad, ketnasan ǝddewan. ");
INSERT INTO ttq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Inn-asan Simɣon Butros: «Nak ad akkaɣ edag n abbaz ǝn kifitan.» Ǝnnan-as: «Nakkanay da nǝddew dǝr-ǝk.» Ǝglan, ǝggazan aɣlal n aman. Ahad wen wǝr obezan wala. ");
INSERT INTO ttq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","As affaw iwar-in Ɣaysa tǝgadamayt n agaraw, mišan wǝr ǝssenan nǝttulab-net as ǝnta awen. ");
INSERT INTO ttq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Inn-asan: «Imaran-in, awak abbaz a wǝr tǝgem wala daɣ kifitan?» Ǝnnan-as: «Kala». ");
INSERT INTO ttq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Inn-asan: «Ǝgǝrat ǝmǝzzezdǝr-nawan wa n abbaz ǝn kifitan fǝl aganna n ǝɣlal wa n ǝɣil, a tan-tǝgrǝwam.» Ǝgaran ǝmǝzzezdǝr-nasan daɣ agaraw, tǝzzar indar-asan a t-id-ǝdkǝlan, fǝl awa ǝgan kifitan win t-ǝhanen daɣ igǝt. ");
INSERT INTO ttq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Inkar ǝnǝttalib wa isannahal Ɣaysa tara inna i Butros: «Awen Ǝmǝli!» Da daɣ ad isla Simɣon Butros as Ǝmǝli awen, ǝnta ad iqqan asalsaw-net wa n afalla, fǝlas izzâf, tǝzzar itaraggat daɣ agaraw. ");
INSERT INTO ttq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Amaḍal ǝn sanatat tǝmad n ǝɣil a ǝllanen gar-essan ǝd tǝgadamayt n agaraw. Ǝqqiman-du nǝttulab win hadatnen daɣ ǝɣlal ǝrkâban-du dǝffǝr-san ǝmǝzzezdǝr-nasan, idnây kifitan. ");
INSERT INTO ttq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ǝzzǝbben-du ɣas oggan temsay ǝn tǝmakaten fǝl naŋŋin kifitan, tǝnsa deɣ tǝgǝlla den. ");
INSERT INTO ttq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Inn-asan Ɣaysa: «Awǝyat-du arat daɣ kifitan win du-tobazam ǝmǝrǝdda.» ");
INSERT INTO ttq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Igmad-du Simɣon Butros aman illil-asan s arakab n ǝmǝzzezdǝr wa ǝhan kifitan. Temeday ǝd sǝmmosat tǝmǝrwen ǝn kifi ǝd karad ǝs kul win zawwarnen a t-ǝhanen mišan wǝr izzǝrrat. ");
INSERT INTO ttq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Inn-asan Ɣaysa: «Ayewat tatšim.» Wǝr iha inǝttulab i ihalan ad issǝstǝn Ɣaysa ann-as: «Ma tǝmosa?» Fǝlas ǝssânan as Ǝmǝli awen. ");
INSERT INTO ttq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ihoz-tan-in Ɣaysa, obaz-du tagǝlla ikf-asan-tat, ikf-en ǝntada kifitan. ");
INSERT INTO ttq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Taklat ta ǝnta a tǝmosat ǝnǝfilal wa n karad a d-iga Ɣaysa i nǝttulab-net dǝffǝr tanakra-net daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","As ǝtšan inna Ɣaysa i Simɣon Butros: «Simɣon ag Yaxya, awak tidǝt as tara ta di-tǝge togar ta di-ǝgan nǝttulab win hadatnen?» Inn-as Simɣon: «Ayew Ǝmǝli, tǝssâna daɣ tara ta dak-ǝge.» Inn-as Ɣaysa: «Agǝz za ijamaran-in.» ");
INSERT INTO ttq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ig-as y ǝsǝstan wa igi wa n ǝššin inn-as: «Simɣon ag Yaxya, awak tǝreɣ-i?» Inn-as Butros: «Ayew Ǝmǝli, tǝssâna daɣ tara ta dak-ǝge.» Inn-as Ɣaysa: «Ǝqqǝl za amadan n ayfǝd-in.» ");
INSERT INTO ttq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ig-as y ǝsǝstan wa igi wa n karad inn-as: «Simɣon ag Yaxya, awak tǝreɣ-i?» Ǝɣšadan man ǝn Simɣon Butros fǝlas karad igitan das-iga Ɣaysa y ǝsǝstan wa. Inn-as: «Ǝmǝli, kay a issanan daɣ arat kul, tǝssânaɣ as ǝreq-qay.» Inn-as Ɣaysa: «Ǝssǝn za daɣ ayfǝd-in. ");
INSERT INTO ttq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ǝggǝyyeɣ ǝsilakanaɣ-ak as harwa taynaya, iman-nak as tǝlassa tabdoq-nak, tǝtakkaɣ edag was tare, mišan as tǝqqalaɣ aɣmar, ad tǝzzǝlaɣ ifassan-nak, assals-ik awedan iyyan tabdoq-nak, awǝy-kay s adag as wǝr tareɣ iki-net.» ");
INSERT INTO ttq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Batu ta issoka sǝr-ǝs Ɣaysa ǝnnuɣ ǝn tǝmattant ta zʼagu Butros s ǝnta as zʼassaknu adkul wa iga i Mǝššina. As iga Ɣaysa batu ta inn-as: «Ǝlkǝm-i» ");
INSERT INTO ttq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Iswad-in Butros dǝffǝr-ǝs ogga anattalib wa isannahal Ɣaysa tara ilkâm-asan-du. Anattalib wa ǝnta a isaɣɣamaran daɣ ihǝz n ǝdmaran ǝn Ɣaysa ahad wad tattin imensewan n ǝmud wa n Akkay, ǝnta deɣ as kala ad issǝstanan Ɣaysa inn-as: «Ǝmǝli, ma imos wa kay zʼakkaddalan.» ");
INSERT INTO ttq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","As t-ogga Butros issǝstan Ɣaysa inn-as: «Ǝnta za Ǝmǝli, ma daɣ-as ilkaman?» ");
INSERT INTO ttq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Inn-as Ɣaysa: «Kud tara a ǝgeɣ ad iddǝr har d-ǝqqǝla, tǝdi wǝr kay-tǝqqel. Kay ǝlkǝm-i ɣas!» ");
INSERT INTO ttq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wazawazan salan daɣ mǝzzǝgzan ǝs Ɣaysa as anattalib wa wǝr tu-z-iba. Ǝnta Ɣaysa wǝrgeɣ a inna wǝr tu-z-iba, tǝnna ɣas a iga: «Kud tara a ǝgeɣ ad iddǝr har d-ǝqqǝla tǝdi wǝr kay-tǝqqel.» ");
INSERT INTO ttq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Anattalib wa ǝnta iman-net as iggǝyyat fǝl igitan win, iktab-tan. Nǝssân as tǝgǝyya-net tidǝt a tǝmos. ");
INSERT INTO ttq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ɣaysa iga aratan wiyyad aggotnen. As igmay awedan d a sǝr-san ammagrad s iyyan-iyyan, ordeɣ as ǝddǝnet ketnet da wǝr za tawǝy ǝlkǝttaban win zʼiktǝb.");
INSERT INTO ttq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ya Tayofil, ǝlkǝttab-in wa azzaran ǝktâbaɣ daɣ-as aratan kul win as issǝnta Ɣaysa igi-nasan d ǝsǝssǝɣri-nasan, ");
INSERT INTO ttq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","har ǝzǝl wa d immǝdkal ǝs jǝnnawan dǝffǝr as iga ammaran-net ǝs tarna n Infas wa Zǝddigan i nǝmmuzal-net win isannafran. ");
INSERT INTO ttq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ǝntanay en da a issǝkna iman-net dǝffǝr alɣazab-net. Isattad-asan ǝs tǝmǝwiten aggotnen tanakra-net daɣ tamattant. Ǝkkozat tǝmǝrwen n ǝzǝl a iga itinǝfilil-asan, itagg-asan isalan ǝn Taɣmar ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ǝzǝl iyyan idrâw dǝr-san imensewan as tan-omar, inn-asan: «Ad wǝr tǝgmǝdam aɣrǝm ǝn Yerusalam. Ǝqqǝlat y arkawal n Abba wa dawan-ǝmala, ");
INSERT INTO ttq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","fǝlas Yaxya aman a daɣ issǝlmaɣ aytedan mišan kawanay, ɣur adan wǝr nǝggǝt, Infas wa Zǝddigan a daɣ za tǝtǝwǝsǝlmǝɣam.» ");
INSERT INTO ttq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ǝddêwan ɣur-ǝs nǝmmuzal-net as t-ǝssǝstanan, ǝnnan-as: «Ǝmǝli, awak ǝmǝrǝdda ad za tǝssuɣǝla tǝmǝnukǝla y Israyil?» ");
INSERT INTO ttq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Inn-asan: «Wǝr kawan-tǝwer masnat n alwaq wala tamert win otas Abba ǝs tanaya-net. ");
INSERT INTO ttq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mišan ya a fall-awan d-azzabbat Infas wa Zǝddigan, tǝgrǝwam tarna, tǝqqǝlam šigǝyyawen-in daɣ ǝɣrǝm wa n Yerusalam, d akal kul wa n Yahudǝyya ǝd wa n Samarǝya, taglim har da d-iraz amaḍal.» ");
INSERT INTO ttq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","As inna awen, immǝdkal ǝs jǝnnawan. Ǝswâdan daɣ-as har dasan-tu-tǝlsa tagarak. ");
INSERT INTO ttq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Harwâda ǝggizzayan ijǝnnawan assaɣa wad itagazzay Ɣaysa as nafalalan ǝššin meddan ǝn samlalan dǝgma-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ǝnnan-asan: «Ya meddan ǝn Galilaya, mas tǝbdadam, tǝswâdam daɣ jǝnnawan? Ɣaysa wa immǝdkalan gar-ewwan da ǝs jǝnnawan, ilkâm a d-iqqǝl s ǝmmǝk wa da as tu-tǝnayam ikk-en.» ");
INSERT INTO ttq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tǝzzar ǝfalan nǝmmuzal adɣaɣ was itawannu wa n Eškan ǝn Zaytun, ǝqqalan aɣrǝm ǝn Yerusalam a das-ihân edag ǝn teklay tas tǝtawala turagat-net daɣ ǝzǝl wa n tǝsanfawt ǝn Kǝl-Ǝlyǝhud, almaɣna edag ǝn kilaw iyyanda ǝn teklay. ");
INSERT INTO ttq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","As din-osan, ǝggazan ehan wa n afalla daɣ suru wa daɣ saganan. Ǝmosan Butros, Yaxya, Yaqub, Andrawǝs, Filibus, Tuma, Bartulamawǝs, Matta, Yaqub wa n ag Alfay, Simɣon was itawannu wa Isaggatakken ǝd Yahuza wa n ag Yaqub. ");
INSERT INTO ttq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ketnasan tiddawan-du y igi ǝn tǝwatriwen s ǝwǝl iyyanda, ǝntanay ǝd mǝdrayan ǝn Ɣaysa ǝd tǝdoden tǝha Maryama ta n anna-net. ");
INSERT INTO ttq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Adan en da a daɣ ibdad Butros gǝr nǝlkiman ǝn Ɣaysa, ǝmosnen temeday n awedan ǝd sanatat tǝmǝrwen, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Imǝdrayan-in, ǝššil ad andu awa inna Infas wa Zǝddigan daɣ Ǝlkǝttaban irǝw s ǝmi n ǝnnǝbi Dawǝd daɣ salan ǝn Yahuza wa d-issǝlalan aytedan win ǝbaznen Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Fǝlas kala daɣ-naɣ iddun nakkanay inǝmmuzal, amaran igrâw adagar-net daɣ ǝššǝɣǝl wa dǝr-naɣ isanattaf Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Alǝs za wa, izzǝnza tawagost daɣ azrǝf wa igraw daɣ abakkad-net, dǝffǝr awen uda daɣ-as ǝs tǝdist-net, ibbǝqqat, iffǝzzat awa ihan tadist-net kul. ");
INSERT INTO ttq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aytedan kul win ǝxsarnen daɣ Yerusalam ǝslân awen, har as tawagost ten ǝgan-as esǝm daɣ awal-nasan \"Akaldama\", alamaɣna tawagost ta n ǝzni. ");
INSERT INTO ttq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Amaran iktâb daɣ ǝlkǝttab wa n Ǝzzǝbur as: \"Iqqǝlet ahan-net ǝmǝjir, a tu-wǝr-ilǝs awedan iguz.\" Iktâb daɣ-as deɣ as: \"Iggǝzet awedan iyyan edag-net daɣ ǝššǝɣǝl.\" ");
INSERT INTO ttq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Daɣ adi ilzâm-ana ad nǝsǝnnǝfrǝn iyyan daɣ meddan win dǝr nǝtidaw faw daɣ šikilan n Ǝmǝli Ɣaysa, ");
INSERT INTO ttq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a d-ibazan ɣur ǝzǝl wa t-issǝlmaɣ Yaxya daɣ aman har ǝzǝl wa ɣur-naɣ immǝdkal ǝs jǝnnawan. Alǝs wa za nǝsǝnnǝfrǝn da, ad iqqǝl tǝgǝyya ǝn tanakra ǝn Ɣaysa daɣ tamattant.» ");
INSERT INTO ttq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ǝssǝbdadan ǝššin meddan ǝmosnen Yusǝf was itawannu Barsabbas, gannin-as deɣ Yustus, ǝd Matǝyyas. ");
INSERT INTO ttq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tǝzzar ǝttaran, ǝnnan: «Ya Ǝmǝli, kay a issanan awa ihan iwallan n aytedan kul, sakn-ana wa tǝsannafrana gǝr meddan win ǝššin a, ");
INSERT INTO ttq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","fǝl ad iggǝz ǝššǝɣǝl n anammazul wa igmad Yahuza ikka edag wa imosan wa-net.» ");
INSERT INTO ttq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ǝgan šišaɣeren, ǝbaznat Matǝyyas, iddun daɣ nǝmmuzal win maraw d iyyan. ");
INSERT INTO ttq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","As d-iɣlay ǝzǝl n ǝmud ǝn Kǝl-Ǝlyǝhud was itawannu Fantǝkawt, ǝddêwan nalkiman ǝn Ɣaysa ketnasan daɣ adag iyyanda. ");
INSERT INTO ttq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wala a ihogan igmad-du ǝjit iyyan ijǝnnawan olân d in aḍu issohen, itkar ehan ketnet wa daɣ ǝqqiman. ");
INSERT INTO ttq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nafalalan-asan d ilsawan olanen d in abalagleg ǝn tǝmsay, ǝmmǝzzayan ilsawan en; ǝkkulluk n iyyan iwar iyyan daɣ-san, ");
INSERT INTO ttq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Idnay-tan Infas wa Zǝddigan ketnasan, tǝzzar ǝssǝntan awal daɣ awalan wǝr nǝmos win-nasan, s ǝmmǝk was tan-ikfa Infas wa Zǝddigan fǝrregat n awen. ");
INSERT INTO ttq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","As itaggu awen, aɣrǝm ǝn Yerusalam ǝɣsâran daɣ-as Kǝl-Ǝlyǝhud zizawatnen daɣ ǝddin a d-ǝgmâdnen ikallan n ǝddǝnet kul. ");
INSERT INTO ttq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","As ǝslan y awal wen, tǝddew-du tamattay tagget, tǝzzar isammaklal sǝr-san awen fǝlas akkiyyan daɣ-san isallu i nalkiman ǝššewalan daɣ awal n akal wa d-igmad. ");
INSERT INTO ttq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iga sǝr-san awen ǝsǝmmǝklǝl labasan, gannin: «Xa! Aytedan a ǝššewalnen da, awak wǝrgeɣ ketnasan Kǝl-Galilaya? ");
INSERT INTO ttq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mas za, akkiyyan daɣ-na isall-asan ǝššewalan awal ǝn marwan-net? ");
INSERT INTO ttq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ǝnta nakkanay ǝhân-anaɣ aytedan a d-ǝgmadnen amaḍal ǝn Bartǝya, d akal wa n Medǝya, ǝd wa n Aḷam, d aytedan ǝxsârnen daɣ akal wa n Mezobotamǝya, ǝd wa n Yahudǝyya, ǝd wa n Kabadokǝya, ǝd wa n Fontǝs ǝd wa n Asǝya, ");
INSERT INTO ttq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ǝd wa n Frijǝya, ǝd wa n Banfilǝya ǝd wa n Masar. Wiyyad ǝgmâdan-du akal ǝn Libǝya daɣ ɣǝlǝyɣǝlayan n ǝɣrǝm wa n Qǝrwan, wiyyad aytedan n Ǝrrum, ");
INSERT INTO ttq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","wiyyad aytedan ǝn Kǝret ǝd win Arabǝya. Gǝr za win daɣ-na ǝmosnen Kǝl-Ǝlyǝhud wala deɣ aytedan a d-ǝhdânen s ǝddin wa n Kǝl-Ǝlyǝhud, ketnana nǝsall-asan ǝmmâlan daɣ awalan-nana igitan ǝn tarna ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ketnasan isimaklal sǝr-san awen, wǝr ǝssenan a ǝnnan, tinǝmǝnnin: «Ma imos almaɣna n awa?» ");
INSERT INTO ttq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mišan ya wiyyad daɣ-san ǝgan daɣ nǝlkiman tamakkakkayt, gannin: «Awen esmad n alɣanab a tan-isammaswadan.» ");
INSERT INTO ttq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tǝzzar ibdad Butros ǝnta ǝd nǝmmuzal win maraw d iyyan, idkal ǝmǝsli-net iššewal i tamattay, inna: «Meddan ǝn Yahudǝyya ǝd kawanay ketnawan win ǝxsarnen daɣ Yerusalam, agriwat awa igan da, tǝssǝsǝmam wǝllen y awa dawan-z-anna da. ");
INSERT INTO ttq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Meddan win wǝr ǝmmǝswadan, arat wa tǝɣilam ǝddi, fǝlas taza alwaqan win aɣora awa harwa da. ");
INSERT INTO ttq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kala kalar arat wa imal ǝnnǝbi Yowǝl a d-osan, as inna: ");
INSERT INTO ttq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"Inna Mǝššina: 'Ǝnta da awa du-z-asin daɣ adan n ǝddǝnet win ǝlkamnen: a du-zǝzzǝbbeɣ Infas-in fǝl i t-illa awedan, ǝssuɣǝlan maddanǝwan d aššekkawan awa dasan-z-ǝmǝla; sǝnnǝfilǝlaɣ aratan ǝttinkalnen i mawadan-nawan, sǝssuga iɣmaran-nawan targǝten. ");
INSERT INTO ttq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Awalla, a du-zǝzzǝbbeɣ daɣ adan win den Infas-in fǝl naɣbidan-in ǝd tǝnaɣbiden-in tǝzzar ǝssuɣǝlan awa dasan-z-ǝmǝla. ");
INSERT INTO ttq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ad agaɣ tǝlmǝɣjujaten daɣ jǝnnawan, agaɣ aratan ǝmosnen alɣalamaten fǝl amaḍal: Inɣǝl ǝzni, tarɣu tǝmsay, akku ǝhu ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tǝfuk ad tamattay, tǝqqǝl šiyyay; tizwaɣ tǝllit šilat n ǝzni; izar-du adi kul y assa n ǝzǝl zǝwwǝran ilân ǝlxurma wa issǝbdad Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amaran i igmayan daɣ Ǝmǝli ǝlɣillas ad t-igrǝw.'\" ");
INSERT INTO ttq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ya meddan n Israyil, sǝsǝmat i salan win: Ɣaysa wa n Nazaret, alǝs a imos as kawan-issîkna Mǝššina ǝs tǝlmǝɣjujaten d aratan ǝmmittaynen, ǝd wiyyad ǝmosnen alɣalamaten win as t-ikfa igi-nasan gar-ewwan as ǝnta a isannafran. Kawanay iman-nawan tǝssânam daɣ adi. ");
INSERT INTO ttq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Alǝs di, Mǝššina di as tu-wǝr-illa a das-idrâgan a t-igan daɣ fassan-nawan, imos awen arat ixtâs irǝw, tǝgam iman-net s ǝtǝwǝsǝtǝytǝy wa tu-tǝsassagam i nǝzzulam fǝl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mišan isǝnkar-t-idu Mǝššina, ikkas-t-idu daɣ tarna ǝn tamattant fǝlas wǝr t-illa ǝmmǝk as t-in-tǝttǝf tamattant. ");
INSERT INTO ttq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Batu-net a daɣ inna ǝnnǝbi Dawǝd irǝw: \"Hannaya Ǝmǝli dat-i faw, iha aɣil-in fǝl ad wǝr ǝɣšǝdan man-in. ");
INSERT INTO ttq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Adi fǝl falawasan man-in, tǝkna tǝdǝwit iguz n awal-in, wala taɣǝssa-nin wǝr nǝmos tamaɣlolt da ad tagu attama, ");
INSERT INTO ttq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","id wǝr za tayyaɣ iman-in daɣ alaxirat, wala deɣ tayyaɣ Ǝmizdag-nak tarḳu tǝɣǝssa-net. ");
INSERT INTO ttq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kay a di-issǝknan tarrayt ta tǝha tǝmǝddurt. A di-tǝsǝffǝliwǝsa wǝllen ǝs tassaq ta dǝr-ǝk ǝgeɣ.\" ");
INSERT INTO ttq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Imǝdrayan-in, ǝleɣ tarrayt n a dawan-agaɣ isalan daɣ ǝkkâsaɣ aššak n ǝmaraw-nana Dawǝd n as, aba-tu, itawanbal-in. Ǝzǝkka-net, har azalada illa gar-ena. ");
INSERT INTO ttq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ǝnnǝbi a imos, issân deɣ fǝl arkawal wa fǝl das-ihad Mǝššina n as, ilkâm ad agu daɣ taɣmar-net iyyan daɣ hayawan-net. ");
INSERT INTO ttq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daɣ adi Dawǝd inây dat alwaq tanakra n Ǝlmǝsix daɣ tǝmattant, amaran isalan ǝn tanakra-net a daɣ inna: \"Wǝr din-itawayya daɣ alaxirat, wala deɣ tǝrḳa tǝɣǝssa-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ɣaysa za wa, issǝnkar-t-idu Mǝššina gǝr nǝmmǝttan, nakkanay nǝggǝyat adi. ");
INSERT INTO ttq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Idkal-tu Mǝššina di n Abba-net ig-ay daɣ ǝɣil-net, ikf-ay Infas wa Zǝddigan was iga arkawal-net, ǝnta amaran izazzabbat-t-idu fall-ana. Adi a imos arat wa tǝhannayam da, tǝsallim-as. ");
INSERT INTO ttq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wǝrgeɣ ǝnnǝbi Dawǝd a ikkan ijǝnnawan, kalar ǝnta iman-net a innan: \"Inna Ǝmǝli Mǝššina y Ǝmǝli-nin: 'Ɣam daɣ ǝɣil-in, ");
INSERT INTO ttq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","iket di ad taggaɣ izǝnga-nak daw daran-nak.'\" ");
INSERT INTO ttq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Daɣ adi akninet Kǝl-Israyil kul masnat daɣ as, Ɣaysa wa tǝttǝytayam fǝl tǝgǝttawt, ǝnta a iga Mǝššina Ǝmǝli d Ǝlmǝsix.» ");
INSERT INTO ttq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Idas awal wa iga Butros den iwallan n aytedan wǝllen, ǝnnan-as ǝnta ǝd nǝmmuzal win hadatnen: «Imǝdrayan-nana mas danaɣ-ilzam igi-net?» ");
INSERT INTO ttq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Inn-asan Butros: «Utabat. Akkiyyan daɣ-wan itǝwǝsǝlmǝɣet daɣ aman s esǝm ǝn Ɣaysa Ǝlmǝsix fǝl ad tǝgrǝwam tǝsureft ǝn bakkadan-nawan, tǝgrǝwam tǝhǝkkut ǝn Mǝššina tǝmosat Infas wa Zǝddigan, ");
INSERT INTO ttq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ǝnta arkawal wa iga Mǝššina, kawanay as t-iga, kawanay ǝd hayawan-nawan d aytedan kul win ǝxsarnen daɣ igǝg, almaɣna aytedan kul win du-z-aɣru Ǝmǝli-nana Mǝššina ǝs man-net.» ");
INSERT INTO ttq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Har irǝw Butros itagg-asan tǝlxutbat idgâz wǝllen igann-asan: «Agǝzat iman-nawan daɣ aytedan ǝxrâknen ǝn nǝllubas win azzaman a.» ");
INSERT INTO ttq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aytedan win ǝzzǝgzannen s awa inna, tawasalmaɣan daɣ aman, tǝzzar tǝttǝy tiddawat ǝn mǝzzǝgzan ǝzǝl wen s adag ǝn karad gim n awedan. ");
INSERT INTO ttq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wǝr ǝgmedan ar ǝs taɣaray daw nǝmmuzal, ǝmosan arat iyyanda ketnasan, darrawan imensewan-nasan, tuzanan amensay wa n saktan, taggin šiwatriwen. ");
INSERT INTO ttq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tǝkna tasa ǝn Mǝššina igguz n awedan kul, inǝmmuzal deɣ taggin s ǝlqudrat ǝn Mǝššina tǝlmǝɣjujaten aggotnen d aratan ǝmosnen alɣalamaten. ");
INSERT INTO ttq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ǝrtâyan mǝzzǝgzan ketnasan, ǝdrâwan deɣ arat kul wa ǝlan. ");
INSERT INTO ttq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Zanzin-in daɣ ǝrrǝzǝɣ-nasan, tuzanan attaman-net, ewal awen s awa dǝr togdâ addararat n akkiyyan daɣ-san. ");
INSERT INTO ttq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ǝzǝl kul tamanayan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, nimannakan s awen. Tuzanan amensay wa n saktan daɣ nan-nasan, darrawan deɣ imensewan-nasan daɣ tǝfalawist ǝd tazdak n ǝwǝl. ");
INSERT INTO ttq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ǝmmâlan Mǝššina, ǝssiɣmaran-tan aytedan kul. Akk ǝzǝl iššota Ǝmǝli ǝljǝmaɣat-nasan s aytedan win iɣlas. ");
INSERT INTO ttq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ǝzǝl iyyan iggǝzzay Butros ǝd Yaxya s Ahan wa Zǝwwǝran n Ǝlɣibada y ad agin šiwatriwen šin tazzar. ");
INSERT INTO ttq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Alwaq wen da a daɣ d-immeway alǝs iyyan a d-ihǝwan ǝd bǝddǝn s ǝmi n Ahan wa Zǝwwǝran n Ǝlɣibada was itawannu: «Imi wa Ihossayan» itawasansa fǝl ad igmǝy takutay daɣ aytedan win tu-tagaznen. Akk ǝzǝl itawasansu den. ");
INSERT INTO ttq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","As inay Butros ǝd Yaxya ǝbukan y iguz n Ahan wa Zǝwwǝran n Ǝlɣibada, a tan-itansay. ");
INSERT INTO ttq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Idak-ku Butros ǝd Yaxya s asawad, inn-as Butros: «Ǝswǝd daɣ-na.» ");
INSERT INTO ttq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ikna daɣ-san asawad, iga attama n ad t-akfin arat iyyan. ");
INSERT INTO ttq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tǝzzar inn-as Butros: «Urǝɣ wala azrǝf, wǝr tan-ǝleɣ, mišan a kay-akfa awa ǝleɣ: Ǝs tarna n esǝm ǝn Ɣaysa Ǝlmǝsix wa n ǝɣrǝm ǝn Nazaret, ǝbdǝd jǝwǝnkǝt!» ");
INSERT INTO ttq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tǝzzar ibaz Butros ǝfus-net wa n ǝɣil, issǝbdad-tu. Ǝddaran-du daran-net ǝd tǝlaẓẓen-net alwaq wen da. ");
INSERT INTO ttq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Innad-du zǝllat ibdad, ijawankat. Iddew dǝr-san, ǝggazan Ehan wa Zǝwwǝran n Ǝlɣibada, ijiwankat itaggad fǝl tǝdǝwit immâl Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hannayan-tu aytedan kul ijiwankat immâl Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","As din-ǝgran as, ǝnta a itaɣamin ɣur ǝmi n Ahan wa Zǝwwǝran n Ǝlɣibada was itawannu: «Imi wa Ihossayan», itânsay, ǝhagan, isammaklal sǝr-san awa t-igrawan. ");
INSERT INTO ttq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Igla alǝs wa itawazozayan da iltâɣ daɣ Butros ǝd Yaxya. Jiwanken daɣ tarrayt tǝfâlat as itawannu «ta n Suliman» as sǝr-san du-tozal tamattay ketnet. Igâ awen s aytedan ǝsǝmmǝklǝl labâsan. ");
INSERT INTO ttq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","As inay Butros awen, inna y aytedan: «Meddan n Israyil, mafel ikna sǝr-wan awa ǝsǝmmǝklǝl? Tǝgâram daɣ-na šittawen, tǝgâm daɣ-na asawad n as nakkanay a izzozayan alǝs wa ǝs fǝrregat-nana nakkanay iman-nana, madeɣ nǝzzozay-tu fǝl aššaddat ǝn tǝksǝda-nana Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ǝmǝli n Ibrahim d Isǝhaq ǝd Yaqub, Ǝmǝli ǝn marawan-nana, ǝnta a ikfan akli-net Ɣaysa ǝlxurma. Kawanay iman-nawan a t-igan daɣ fassan, tǝnkuram-tu dat Bilatǝs s ǝnta ikus-net a otas. ");
INSERT INTO ttq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Awalla tǝnkuram Alɣadil di n Ǝmizdag, tǝgmǝyam a dawan-d-itǝwǝkkǝs alǝs n ǝmǝggi ǝn man. ");
INSERT INTO ttq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tǝgam iman ǝn wa ihakkin tǝmǝddurt. Ǝnta a d-issǝnkar Mǝššina daɣ tamattant, nakkanay nǝggǝyat adi. ");
INSERT INTO ttq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ǝzǝgzan-nana ǝs tarna n esǝm ǝn Ɣaysa a ikfan alǝs a tǝhannayam da, tǝzdâyam-tu šiɣurad-net. Illikan as ǝzǝgzan ǝs Ɣaysa a ikfan alǝs di šiɣurad-net kul dat-wan ketnawan. ");
INSERT INTO ttq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Amaran imǝdrayan-in, ǝssânaɣ as ǝljǝhǝl a daɣ tǝgam adi kawanay ǝd muzaran-nawan. ");
INSERT INTO ttq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mišan ǝssǝnat as irǝw as imal Mǝššina daɣ mawan n ǝnnǝbitan kul as Ǝlmǝsix ilzâm-tu ad inǝy alɣazab, amaran issǝnda adi ǝs tǝmǝwit tǝdi da. ");
INSERT INTO ttq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Daɣ adi utabat tiksadam Mǝššina fǝl ad imǝs ibakkadan-nawan, ");
INSERT INTO ttq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","izǝzzǝbbǝt-du fall-awan šimeren ǝn tǝsasmit, issuɣǝl-du Ǝlmǝsix a dawan-isinafran dat alwaq, almaɣna Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ilzâm-tu ad aqqam daɣ jǝnnawan har d-asu alwaq wa daɣ zʼissuɣǝl Mǝššina arat kul ǝmmǝk-net wa azzaran, imâl awen irǝw ǝs mawan n ǝnnǝbitan-net di zaddognen. ");
INSERT INTO ttq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Awalla a inna ǝnnǝbi Musa: \"Mǝššina, Ǝmǝli-nawan a dawan-d-isǝnnǝfilǝl iyyan ǝnnǝbi ǝn šilat-in daɣ mǝdrayan-nawan amaran ad tǝsǝsǝmam y awa dawan-z-annu kul. ");
INSERT INTO ttq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Awedan kul wa wǝr nǝbbǝrdag y ǝnnǝbi wǝdi, ad itǝwǝkkǝs daɣ tamattay ǝn Mǝššina, ihlǝk.\" ");
INSERT INTO ttq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ǝnnǝbitan kul win hadatnen, a d-ibazan ɣur ǝnnǝbi Samǝwel ǝd win t-ǝzraynen ketnasan, ǝmâlan arat wa igan daɣ adan win. ");
INSERT INTO ttq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kawanay a imosan imǝkkusa n ǝnnǝbitan win den, tǝkkosem deɣ arkawal ǝn tassaq wa idkal Mǝššina i marawan-nawan as inna y Ibrahim: \"Tawšeten n ǝddǝnet kul ad ǝgrǝwnat albaraka s ǝssǝbab n ǝzzurrǝyya-nak.\" ");
INSERT INTO ttq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kawanay as d-isannafalal Mǝššina Akli-net Ɣaysa daɣ tizarat, issok-awan-t-id, fǝl a kawan-akfu albaraka-net ikkǝs akkiyyan daɣ-wan daɣ tarrayt ta n ǝššur.» ");
INSERT INTO ttq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Harwada iššewal Butros ǝd Yaxya i tamattay as fall-asan ǝhan limaman ǝddewan d ǝmuzar n aytedan win tagaznen Ehan wa Zǝwwǝran n Ǝlɣibada ǝd Sadusaytan; ");
INSERT INTO ttq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ih-en alham n ǝsǝssǝɣri wa taggin tamattay, ǝmmâlan âs dad zamas Ɣaysa inkar-du daɣ tǝmattant, wǝdi inǝmmǝttan da a daɣ-as d ǝnkaran. ");
INSERT INTO ttq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sattarmasan-tan ǝgan-tan daɣ kasaw har ifaw fǝlas ehad a igan. ");
INSERT INTO ttq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mišan ya ǝzzǝgzanan aytedan aggotnen daɣ win ǝslanen i tǝlxutbat ten, tǝzzar ǝqqalan mǝzzǝgzan edag ǝn sǝmmos gim n alǝs. ");
INSERT INTO ttq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","As affaw ǝmmǝnayan muzaran ǝn Kǝl-Ǝlyǝhud, d ǝmɣaran-nasan ǝd musanan n Ǝttawret daɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ih-en Xânan wa n Ǝlimam wa Zǝwwǝran ǝd Kayif, ǝd Yaxya d Alaskandǝr d aytedan n aɣaywan n Ǝlimam wa Zǝwwǝran ketnasan. ");
INSERT INTO ttq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ǝssǝbdadan Butros ǝd Yaxya gar-essan, ǝsǝstanan-tan ǝnnan-asan: «Ma ilan tarna madeɣ esǝm was tǝgam adi?» ");
INSERT INTO ttq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tǝzzar inn-asan Butros idkâran Infas wa Zǝddigan: «Ya imuzaran ǝn tamattay-nana d ǝmɣaran n Israyil, ");
INSERT INTO ttq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","azalada nǝbdâd dat asaggawar wa fǝlas nǝga ǝmazal olâɣan imosan tilalt y awedan ibdânan, amaran ilzâm-ana ad nǝmǝl ǝmmǝk was itawazozay. ");
INSERT INTO ttq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ǝssǝnat za ketnawan, kawanay d aytedan n Israyil kul as, alǝs wa ibdadan dat-wan da wǝr ila malad waliyyan, tarna n esǝm ǝn Ɣaysa Ǝlmǝsix wa n Nazaret a t-izzozayan, wa tǝttǝytayam fǝl tǝgǝttawt, issǝnkar-t-idu Mǝššina daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɣaysa, ǝnta a imosan \"tǝhunt ta din-tǝgaram kawanay win makrasan, amaran ǝnta a tǝqqalat tǝhunt ta tǝkbalat ehan.\" ");
INSERT INTO ttq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ǝnta ɣas a iɣallasan, amaran wǝr ikfa Mǝššina gǝr jǝnnawan d amaḍal esǝm n awedan iyyan was za nǝɣlǝs ar wa-net.» ");
INSERT INTO ttq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","As ǝnayan taholat ǝn Butros ǝd Yaxya awal isammaklal sǝr-san awen fǝlas ǝgran as aljahilan a ǝmosan, ǝssânan deɣ as aytedan a ǝmosan as kala tiddawan ǝd Ɣaysa, ");
INSERT INTO ttq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","mišan wǝr t-illa as ǝfrâgan a dasan-t-annin fǝlas hannayan alǝs wa itawazozayan ibdâd den ɣur-san. ");
INSERT INTO ttq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tǝzzar ǝkkasan-tan daɣ ahan wa daɣ immǝnay asaggawar, amaran ad tinǝmǝggin šinaden. ");
INSERT INTO ttq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Gannin: «Ma za nagu y aytedan a? Illikan as ǝnâyan Kǝl-Yerusalam kul tǝlmǝɣjujat zǝwwǝrat ta ǝgan, amaran wǝr nǝfreg ǝsǝbbǝhǝw-net. ");
INSERT INTO ttq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mišan ya fǝl ad wǝr wǝziwǝzan salan n awen daɣ tamattay kul, daɣ adi agiwatana y-asan šisǝksǝdawen fǝl a du-wǝr-ǝlǝsan adakal n esǝm ǝn Ɣaysa dat awedan waliyyan.» ");
INSERT INTO ttq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tǝzzar sassaɣran-tan-du, ǝrɣaman-asan fǝl a du-wǝr-ǝlesan adakal n esǝm ǝn Ɣaysa wala deɣ ǝsǝssǝɣri n arat a t-iqqâlan. ");
INSERT INTO ttq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mišan inn-asan Butros ǝd Yaxya: «Kawanay iman-nawan ma tǝnnam: Mǝni daɣ aratan win wa oɣadan dat Mǝššina: awak ǝbǝrdǝg y-awan meɣ ǝbǝrdǝg i Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nakkanay za, wǝr nǝfreg ad nayyu emel n aratan win nǝnay ǝd win as nǝsla.» ");
INSERT INTO ttq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ilas-asan asaggawar igi n tǝsǝksǝdawen, amaran oyyan-tan, id wǝr ǝgrewan ǝsaru fǝl tan-ǝwwǝddaban. Ǝgân awen fǝl ǝddǝlil n aytedan, fǝlas aytedan en ketnasan taggin i Mǝššina tǝmmalen fǝl awa igan den. ");
INSERT INTO ttq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ǝnta alǝs wa igan tǝmǝzzǝyt tǝmosat tǝlmǝɣjujat ten, elan-net ogaran ǝkkozat tǝmǝrwen n awatay. ");
INSERT INTO ttq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Itawayya Butros ǝd Yaxya ɣas, ǝkkan imidawan-nasan, ǝssoɣalan-asan awa dasan-ǝnnan muzaran ǝn limaman d ǝmɣaran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","As ǝslan i salan win, jajjayen daɣ tǝwatray ta, s ǝwǝl iyyanda, ǝnnan s afalla: «Ya Ǝmǝli, kay a d-ixlakan ijǝnnawan d amaḍal, ǝd gǝrwan d awa tan-ihan kul, ");
INSERT INTO ttq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kay a innan ǝs tarna n Infas wa Zǝddigan s ǝmi n amaraw-nana akli-nak Dawǝd: \"Mafel ɣišašatnat addawlaten n ǝddǝnet, tagginat tǝmattiwen šinaden wǝr nǝnfa wala? ");
INSERT INTO ttq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ǝbdadan mǝnokalan n ǝddǝnet, ǝddewan deɣ muzaran daɣ adag iyyanda, fǝl ad ammaddin Ǝmǝli d Ǝlmǝsix-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Id illikan as, aɣrǝm wa da, a daɣ immǝnay Herod ǝd Fons Bilatǝs ǝntanay ǝd tǝmattiwen šin nǝzzulam ǝd šin Israyil, ǝmmǝddan Ɣaysa, imosan Akli-nak zǝddigan, wa tǝgeɣ Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Imos awen igi n arat ketnet was tǝxtasa fǝl igi-net dat alwaq ǝs tarna-nak ǝd tara-nak. ");
INSERT INTO ttq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Amaran ǝmǝrǝdda Ǝmǝli, ǝswǝd daɣ tǝsǝksǝdawen šin dana-taggin, tǝzzar tǝssǝhǝlaɣ-ana wǝllen nakkanay an eklan-nak emel n awal-nak, ");
INSERT INTO ttq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tilalaɣ-ana ǝs tarna n ǝfus-nak fǝl ad nǝzzuzǝy aytedan, nagu tǝlmǝɣjujaten d aratan ǝmosnen alɣalamaten s esǝm ǝn Ɣaysa, Akli-nak Zǝddigan.» ");
INSERT INTO ttq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","As ǝɣradan tǝwatray-nasan inagaynagay adag wa daɣ ǝddewan, idnay-tan Infas wa Zǝddigan ketnasan, tǝzzar ad ǝmmâlan awal ǝn Mǝššina ši wala tasa. ");
INSERT INTO ttq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ǝljǝmaɣat ta n mǝzzǝgzan ketnet tǝnimannak tǝmos arat iyyanda. Wǝr tan-iha i igannin awa ila, i-net ɣas-net, kalar ǝdrâwan arat kul wa ǝlan. ");
INSERT INTO ttq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tagayyen nǝmmuzal ǝs tarna zǝwwǝrat fǝl tanakra n Ǝmǝli Ɣaysa daɣ tǝmattant, ikf-en deɣ Mǝššina ketnasan arraxmat-net s igǝt. ");
INSERT INTO ttq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ǝljǝmaɣat en wǝr tat-iha i iddiraran ǝs wala, fǝlas win daɣ-san ǝlanen inan madeɣ šiwǝgas zanzan-tan-in, tawayan-du attaman-nasan, ");
INSERT INTO ttq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","hakkin-tu i nǝmmuzal, amaran itǝwizǝn gǝr mǝzzǝgzan ewâlan dǝgran-nasan s awa dǝr ogdanat tǝmǝɣutar-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Awen da a iga alǝs iyyan igân Yusǝf imosan iyyan daɣ Kǝl-Lebi n akal ǝn Qibrus. Ǝnta as ǝgan nǝmmuzal tǝsǝmmadǝq Barnabas, almaɣna «Ǝnalam fǝl man» ");
INSERT INTO ttq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Izzǝnz-in tawagost tǝhat tǝla-net, eway-du attaman-net ikf-ay i nǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ill-ay alǝs iyyan igân esǝm Ananǝyâs a din-izzinzan, ǝnta ǝd tǝntut-net Safira, tawagost-net, ");
INSERT INTO ttq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","tǝzzar inamarda ǝd tǝntut-net fǝl a din-ittǝf arat daɣ ǝzrǝf wa din-tǝnza, eway-du awa hadan, ikf-ay i nǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Inn-as Butros: «Ananǝyâs, mafel as toyyeɣ Aššaytan iga y ǝwǝl-nak iguz ogdân d awa, ewad daɣ-ak ad taga y Infas wa Zǝddigan bahu s iduf wa din-tǝgeɣ arat daɣ ǝzrǝf wa din-tǝnza tawagost-nak? ");
INSERT INTO ttq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Harwa tat-in-wǝr-tǝzzǝnza, wǝrgeɣ tǝla-nak a tǝha? As tat-in-tǝzzǝnza deɣ, wǝrgeɣ azrǝf wa tat-in-tǝzzǝnza kay a ittafan tanat-net? Daɣ adi, mafel tǝsamarkasa daɣ ǝwǝl-nak igi n ǝmazal ogdân d awa? Wǝrgeɣ aytedan as tǝgeɣ bahu, kalar Mǝššina ǝs tu-tǝgeɣ.» ");
INSERT INTO ttq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","As isla Ananǝyâs i batu ten, ifataqqat, ǝgmadan-tu man. Tǝggaz tasa zǝwwǝrat aytedan kul win ǝslanen awen. ");
INSERT INTO ttq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tǝzzar osan-t-idu meddan ǝn mawadan, ǝgan-tu daɣ šifit, ǝglan dǝr-ǝs ǝnbalan-t-in. ");
INSERT INTO ttq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Edag ǝn karadat assaɣaten dǝffǝr awen, tosa-du tǝntut n Ananǝyâs, wǝr tǝssen fǝl awa igan. ");
INSERT INTO ttq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Issǝstan-tat Butros, inn-as: «Safira, ǝmǝl-i, awak tawagost-nawan azrǝf wa tat-in-tǝzzǝnzam, ǝnta da da ketnet?» Tǝnn-as: «Awalla, ǝnta ǝddi da.» ");
INSERT INTO ttq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tǝzzar inn-as Butros: «Manǝmmǝk ǝs tǝnamannakam fǝl igi ǝn taremt y Infas wa Zǝddigan? Sǝsǝm, meddan win din-ǝnbalnen alǝs-nam ǝllân dat ǝmi n ahan; a kam-awǝyan kam da.» ");
INSERT INTO ttq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tǝfataqqat tamazayt ten da ɣur daran ǝn Butros, ǝgmadan-tat man. Ǝggazan-du meddan winad ǝn mâwadan a, osan-tat-du wǝr tǝdder, ewayan-tat ǝnbalan-tat-in dǝgma n alǝs-net. ");
INSERT INTO ttq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eway-du awen as tǝggaz tasa labasat Ǝlkǝnisat ketnet d aytedan kul win ǝslanen awen. ");
INSERT INTO ttq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Taggin nǝmmuzal tǝlmǝɣjujaten aggotnen ǝmosnen alɣalamaten d aratan aggotnen simaklalnen daɣ aytedan. Tamanayan faw mǝzzǝgzan ǝs Ɣaysa ketnasan, daw tafala n Ahan wa Zǝwwǝran n Ǝlɣibada tas itawannu «ta n Suliman». ");
INSERT INTO ttq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ǝssiɣmaran-tan aytedan mišan wǝr-t-illa i ihalan a tan-in-ihaz. ");
INSERT INTO ttq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dǝr iga awen da ya, tittǝyan s aytedan ǝknanen igǝt ǝgânen daɣ meddan ǝd tǝdoden win zagzannen s Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Har as, tamawayan-du miranan tawasansin daɣ tessaten madeɣ šisalaten fǝl afay ǝn tarrayen ǝn Yerusalam, fǝl a din-tawǝd kuddeɣ telay ǝn Butros wiyyad daɣ-san as d-illam den. ");
INSERT INTO ttq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tazalan-du deɣ aytedan ǝknanen igǝt ǝn ɣǝrman win ǝhoznen Yerusalam, ǝs Yerusalam ewâyan imiranan-nasan d aytedan-nasan win ǝssǝranan kǝlǝsuf. Ketnasan deɣ tiwǝzuzǝyan. ");
INSERT INTO ttq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ǝggaznat tǝsmiten labasnen Ǝlimam wa Zǝwwǝran ǝnta d aytedan kul win tǝɣimit-net, ǝn taggayt ta n Sadusaytan, ");
INSERT INTO ttq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","tǝzzar ǝnkaran sattarmasan inǝmmuzal ǝgan-tan daɣ kasaw dat awedan kul. ");
INSERT INTO ttq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mišan osa-du angalos n Ǝmǝli ehad, olam šisǝhar ǝn kasaw, ikkas-tan-du, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Akkiwat Ehan wa Zǝwwǝran n Ǝlɣibada, tǝmǝlam y aytedan isalan kul win tǝmǝddurt ta taynayat.» ");
INSERT INTO ttq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ǝgan nǝmmuzal awa dasan-itawannan, ǝnzayan s Ahan wa Zǝwwǝran n Ǝlɣibada, a daɣ-as sasaɣrin aytedan. As d-osa Ǝlimam wa Zǝwwǝran ǝnta d aytedan win tǝɣimit-net, sassaɣran-du Asaggawar wa Zǝwwǝran almaɣna iɣmaran kul win ǝmosnen šiggǝtawen ǝn Kǝl-Israyil, amaran ǝssǝgmayan inǝmmuzal ǝs kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Osan-in maššaɣalan win tan-ǝgmaynen ehan ǝn kasaw, mišan wǝr tan-in-ogezan daɣ kasaw, tǝzzar ǝqqalan ǝgan isalan, ");
INSERT INTO ttq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ǝnnan: «Nos-in kasaw ketnet itimantammat, ǝbdâdan sojitan win t-ogaznen dat mawan-net, mišan as nolam tǝsǝhǝrt ǝn kasaw, wǝr daɣ-as in-nosa awedan waliyyan.» ");
INSERT INTO ttq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","As isla kabtan ǝn sojitan win tagaznen Ehan wa Zǝwwǝran n Ǝlɣibada, ǝd muzaran ǝn limaman i salan win den, ǝqqanan ɣafawan-nasan, ad samadranan daɣ awa zʼiqqǝl awen. ");
INSERT INTO ttq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ǝhân ten da as tan-d-osa awedan, inn-asan: «Sǝsǝmat! Meddan win tǝgam daɣ kasaw, ǝbdâdan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, sasaɣrin daɣ-as tamattay.» ");
INSERT INTO ttq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tǝzzar igla kabtan alwaq wen da iddêw ǝd sojitan-net ǝbazan-du inǝmmuzal, mišan wǝr tan-ǝdesan fǝlas ǝksudan a sǝr-san du-tǝggǝd tamattay ǝntanay en da, tanɣ-en ǝs zabaw ǝn tǝgur. ");
INSERT INTO ttq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","As tan-d-ewayan, zazzakken-tan dat Asaggawar wa Zǝwwǝran, tǝzzar issǝstan-tan Ǝlimam wa Zǝwwǝran, ");
INSERT INTO ttq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","inn-asan: «Wǝrgeɣ nǝrɣâm-awan wǝllen fǝl a imosan ǝsǝssǝɣri n awedan waliyyan daɣ batu n esǝm di? Mišan ǝnǝyat awa tǝgam! Tǝzawwazawazam daɣ Yerusalam ketnet ǝsǝssǝɣri-nawan, tǝrâm a dana-tǝssǝwaram tamattant n alǝs di.» ");
INSERT INTO ttq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Inn-asan Butros ǝd nǝmmuzal win hadatnen: «Mǝššina as danaɣ-ilzam a das-nabbardag, wǝrgeɣ aytedan! ");
INSERT INTO ttq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mǝššina, Ǝmǝli ǝn marawan-nana a d-issǝnkaran Ɣaysa was tǝgam iman-net s ǝtǝytǝy wa tu-tǝgam fǝl tǝgǝttawt. ");
INSERT INTO ttq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ǝnta a da, a idkal Mǝššina ig-ay daɣ ǝɣil-net, ig-ay Ǝmuzar d Ǝmaɣlas y ad igrǝw i Kǝl-Israyil tarrayt ǝn tǝtubt, ǝgrǝwan tǝsureft ǝn bakkadan-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nǝmos šigǝyyawen n awen, nakkanay d Infas wa Zǝddigan ihakku Mǝššina y aytedan win ǝlkamnen i tara-net.» ");
INSERT INTO ttq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","As ǝslan muzaran n Asaggawar wen i batu ten, iggaz-tan alham labasan, ǝran a daɣ-san ǝkkasan iman. ");
INSERT INTO ttq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mišan ibdad iyyan daɣ-san ǝn taggayt ta n Farisaytan igân esǝm Gamalǝyel imosan ǝmusan zǝwwǝran n Ǝttǝwret, ǝssiɣmaran aytedan kul, omar s ad tǝwǝkkǝsan nǝmmuzal daɣ ahan wa daɣ iga ǝmǝnǝy har din-agin arat n amazay, ");
INSERT INTO ttq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","amaran inn-asan: «Kǝl-Israyil, ǝnkǝdat y a was tǝram a tu-tagim i meddan en. ");
INSERT INTO ttq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wǝr irǝw adi as d-inkar alǝs igân Tedas inna ǝnta imos arat, tǝzzar ǝlkaman-as meddan ewâdnen ǝkkozat tǝmad n alǝs. Ǝnta za iman-net itawanɣa kǝrǝz, meddan win das-ǝlkamnen wazawazan, ibǝnnan awen ketnet. ");
INSERT INTO ttq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dǝffǝr-ǝs, daɣ azzaman win tuddant, inkar-du iyyan alǝs igân esǝm Yahuza wa n Galilaya, isaffallag aytedan aggotnen, ǝlkaman-as. Ǝnta da za, itawanɣa kǝrǝz, tǝzzar wazawazan aytedan kul win das-ǝlkamnen. ");
INSERT INTO ttq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Daɣ adi daɣ talɣa ta, ǝnnǝsixa wa dawan-z-aga: Ǝgmǝdat batu ǝn meddan en, tayyim-tan ad aglin; fǝlas kud arat wa ǝnnǝyen madeɣ wa taggin wǝr imos ar arat ǝrân aytedan a, wǝdi ad ibǝrǝjjǝt. ");
INSERT INTO ttq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mišan kud arat a imos as Mǝššina a t-iran, wǝdi wǝr tǝfregam ǝzǝrǝz-nasan. Ǝnkǝdat, a din-wǝr-tagrim iman-nawan tǝmosam ǝllid ǝn Mǝššina.» Tǝzzar ǝttafan ǝnnǝsixa-net. ");
INSERT INTO ttq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sassaɣran-du inǝmmuzal, sassagan-asan šiwwit labasnen s ǝlǝkkud. Dǝffǝr awen ǝrɣaman-asan fǝl a du-wǝr-ǝlesan adakal n esǝm ǝn Ɣaysa, amaran oyyan-tan. ");
INSERT INTO ttq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ǝfalan nǝmmuzal ehan wa daɣ itamanay Asaggawar wa Zǝwwǝran, ǝknân tǝdǝwit id Mǝššina a tan-issǝharan d ad tawasaknin mǝlka fǝl ǝddǝlil ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Akk ǝzǝl, gǝr za daɣ Ahan wa Zǝwwǝran n Ǝlɣibada wala deɣ daɣ nan n aytedan, wǝr kala ǝmmǝzzayan d ǝsǝssǝɣri d igi ǝn salan n Ǝlinjil a tan-imosan âs Ɣaysa ǝnta a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Azzaman en, inalkiman ǝn Ɣaysa tittǝyan wǝllen. Eway-du awen as gatantanan Kǝl-Ǝlyǝhud win ǝššewalnen tǝlyunant fǝl Kǝl-Ǝlyǝhud win ǝššewalnen tǝlɣibrit fǝlas wǝr tǝtawagga masnat tolâɣat daɣ tǝdoden-nasan šin as aba meddan-nasnat ɣur tǝzunt ta tawaggin mensewan akk ǝzǝl. ");
INSERT INTO ttq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Adi a fǝl sassagan nǝmmuzal win maraw d ǝššin ǝmǝnǝy tǝha ǝljǝmaɣat ǝn nalkiman ǝn Ɣaysa kul, ǝnnan-asan: «Wǝr ihor ad nayyu emel n awal ǝn Mǝššina fǝl ad nannataf ǝd tǝzunt ǝn mensewan. ");
INSERT INTO ttq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Daɣ adi imǝdrayan-nana, sǝnnǝfrǝnat daɣ-wan ǝssa meddan as tǝga masnat fǝl ǝlluɣ-nasan, idkâr-tan Infas wa Zǝddigan, ǝmosan imusanan, a tan-nǝsǝnnǝttǝf d ǝššǝɣǝl wǝdi. ");
INSERT INTO ttq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nakkanay amaran nǝgmǝd s igi ǝn tǝwatriwen d ǝššǝɣǝl wa n amel n awal ǝn Mǝššina ɣas.» ");
INSERT INTO ttq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tanat ten, toggam-tat aljamaɣat ketnet. Tǝzzar sannafranan Ǝstefanos imosan alǝs izzigzanan wǝllen, idkâr-tu deɣ Infas wa Zǝddigan, ǝd Filibus ǝd Frukurus ǝd Nikanor ǝd Timun ǝd Barmenas ǝd Nikolayos wa n ǝɣrǝm n Antǝyoxǝya as kala-net ǝddin wa n Kǝl-Ǝlyǝhud a iha. ");
INSERT INTO ttq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tǝzzar ǝssǝbdadan-tan dat nǝmmuzal, ǝssǝwaran-tan nǝmmuzal ifassan, ǝttǝran-asan. ");
INSERT INTO ttq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ad itǝyttǝy ǝtǝwǝsǝɣmar wa itawaggan y awal ǝn Mǝššina. Tǝzzar ǝttǝyan nalkiman ǝn Ɣaysa wǝllen daɣ Yerusalam, fadda ǝhdan-du limaman ǝn Kǝl-Ǝlyǝhud aggotnen ǝs Ɣaysa, ǝzzǝgzanan as Ǝlmǝsix a imos, ǝlkaman y awas omar. ");
INSERT INTO ttq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ǝstefanos alǝs a imos iknân agaraw n arraxmat ǝd tarna ǝn Mǝššina. Itamazal dat aytedan aratan simaklalnen ǝd tǝlmǝɣjujaten ǝmosnen alɣalamaten zawwarnen. ");
INSERT INTO ttq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tǝzzar ǝnkaran-du aytedan wiyyad n ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud was itawannu «wa n Dǝrfan» âs wiyyad daɣ-san Kǝl-Ǝlyǝhud ǝn Qǝrwan, wiyyad in ǝɣrǝm n Alaskandrǝya, wiyyad in akal wa n Kilikǝya ǝd wa n Asǝya, ad tamazaɣan d Ǝstefanos. ");
INSERT INTO ttq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mišan wǝr t-illa a dǝr din-ǝkkân masnat ta t-ikfa Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tǝzzar ǝrzaman i meddan wiyyad daɣ ǝssir fǝl ad ǝssǝwaran Ǝstefanos bahu, ann-in: «Nǝsl-âs itaggu batuten ǝmosnen ikus ǝn tarna i Mǝššina, ǝmosnat deɣ iba n safrar n ǝnnǝbi Musa.» ");
INSERT INTO ttq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ǝgan s awen alham daɣ tamattay ǝd muzaran ǝn Kǝl-Ǝlyǝhud ǝd musanan n Ǝttǝwret. Wǝr isla Ǝstefanos wala as t-id-osan aytedan, ǝbazan-tu. Ewayan-tu s Asaggawar wa Zǝwwǝran ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tǝzzar ǝssǝbdadan šigǝyyawen ǝn bahu, ǝnnanat: «Alǝs wa, wǝr itǝmǝzzǝy d abayak n ahan wa zǝddigan wa d Ǝttǝwret. ");
INSERT INTO ttq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Igmâd aššak as nǝsl-âs as inna, ilkâm ad ijǝbbǝrǝjjǝt Ɣaysa di ǝn Nazaret di ehan wa, isǝmmǝttǝy alɣadaten šin dana-d-oyya Ǝnnǝbi Musa.» ");
INSERT INTO ttq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ǝgaran aytedan ketnasan win asaggawar šittawen daɣ Ǝstefanos, iqqal sǝr-san udǝm-net zun in angalos. ");
INSERT INTO ttq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tǝzzar issǝstan Ǝlimam wa Zǝwwǝran Ǝstefanos, inn-as: «Awak aratan win tidǝt?» ");
INSERT INTO ttq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Inna Ǝstefanos: «Kawanay imǝdrayan-in d abbatan-in, sǝsǝmat-i! Mǝššina di n ǝmǝli ǝn tanaya, ǝnta as kala a d-inafalal y amaraw-nana Ibrahim harwa iha akal wa n Mezobotamǝya, dat tǝmǝxsurt-net daɣ akal wa n Xaran. ");
INSERT INTO ttq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Inn-as: \"Ǝgmǝd akal-nak ǝd marwan-nak, takkaɣ akal wa kay-z-assakna.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tǝzzar igmad Ibrahim akal wa n Kasdaytan, ixsar daɣ wa n Xaran. Dǝffǝr iba n abba-net a t-id-isaggalat Mǝššina s akal wa da daɣ tǝxsaram da azalada. ");
INSERT INTO ttq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Akal wa, wǝr daɣ-as ikfa Mǝššina Ibrahim edag as zʼiggǝzan tǝkasit-net, wala ɣas edag daɣ issǝnsa adar-net, mišan idkal-as Mǝššina arkawal n a das-t-akfu ǝnta d ǝzzurrǝyya-net, kuddeɣ as alwaq wen, wǝr ila Ibrahim ara waliyyan. ");
INSERT INTO ttq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ǝnta da awa inna Mǝššina: \"Ihayawan-nak ad ǝxsǝran daɣ akal a daɣ ǝmosan iɣǝrab, ǝqqǝlan daɣ-as eklan, ad tawazaɣazzaban har agin ǝkkozat tǝmad n awatay. ");
INSERT INTO ttq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mišan addawlat ta tan-tǝgat eklan, nak iman-in a tat-z-abǝzan s ǝššǝriɣa, dǝffǝr adi, ǝkkǝsaq-qan-du daɣ-as, ǝɣbǝdan-i daɣ adag wa da.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tǝzzar inamagga Mǝššina d Ibrahim arkawal ǝn tassaq s ǝnta as imos ǝmǝnkǝd ejwal-net. Adi a fǝlas, as ihǝw barar-net Isǝhaq isammankad-tu ǝzǝl wa n ǝttam dǝffǝr tǝhǝwt-net. Iga Isǝhaq awen da i barar-net Yaqub, Yaqub deɣ iga awen da i bararan-net ǝmosnen maraw d ǝššin, win ǝmosnen aljadan-nana. ");
INSERT INTO ttq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ǝnkaran meddan win ǝmosnen aljadan-nana ǝmmǝnzaɣan amadray-nasan Yusǝf, tǝzzar ǝzzǝnzan-t-in, immeway s akal ǝn Masar; mišan issan daɣ-as Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ikkas-t-idu Mǝššina daɣ tǝmǝɣutar kul šin iggaz. Ikf-ay masnat, d udǝm ɣur Firɣawna wa n ǝmǝnokal ǝn Masar, har as ig-ay Firɣawna daw-ǝs, izzozar-tu y akal ǝn Masar d aɣaywan-net ketnet. ");
INSERT INTO ttq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dǝffǝr awen, iga laz daɣ akal ǝn Masar ketnet, ǝnta ǝd wa n Kanan. Ad taɣazzaban aytedan wǝllen, aba i meddan win ǝmosnen aljadan-nana a ǝtšan. ");
INSERT INTO ttq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","As isla Yaqub as Masar tah-et tǝbzǝst, izammazal sǝr-ǝs meddan win dana-sahhayawnen, imos awen iki-nasan y-as wa azzaran. ");
INSERT INTO ttq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ɣur iki-nasan Masar wa n ǝššin, ad izzǝzday Yusǝf iman-net i mǝdrayan-net, ǝggazan deɣ salan Firɣawna n aɣaywan wa d-igmad Yusǝf. ");
INSERT INTO ttq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Issǝgmay Yusǝf abba-net Yaqub ǝd marwan-net kul, ǝmosan ǝssayat tǝmǝrwen n awedan ǝd sǝmmos. ");
INSERT INTO ttq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tǝzzar iras Yaqub akal ǝn Masar, s ǝnta a daɣ t-aba, aba daɣ-as deɣ imarawan-nana. ");
INSERT INTO ttq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ǝmmewaynat tǝɣǝswen-nasan s ǝɣrǝm ǝn Šǝkem, tawanbalnat daɣ ǝzǝkka wa izzǝnza Ibrahim azrǝf wa ibalalaɣan ɣur maddanǝs ǝn Xamor daɣ Šǝkem, y ad iqqǝl tanbǝlt-net. ");
INSERT INTO ttq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","As d-ihoz alwaq wa daɣ zʼassandu Mǝššina arkawal wa fǝl ihad y Ibrahim, tamattay-nana tǝttǝy, tǝmôs taxlǝk tagget daɣ Masar, ");
INSERT INTO ttq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","har \"iggaz iyyan ǝmǝnokal wǝr nǝssen fǝl Yusǝf taɣmar ǝn Masar.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ikkǝrras kǝl-tamet-nana, iga i marawan-nana ǝzǝɣǝzzǝb labâsan har âs išahhaššal-tan a din-tayyin bararan-nasan win ǝs sǝket ǝhǝwan daɣ ǝsuf fǝl ad wǝr ǝddǝran. ");
INSERT INTO ttq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Azzaman en da a daɣ ihǝw Musa, imos barar ihossayan, igrâwan arraxmat ǝn Mǝššina. Ǝttafan-tu marwan-net daɣ ahan-nasan har iga karadat tǝlil. ");
INSERT INTO ttq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Oyyan-t-in marwan-net ɣas fǝl afay n Ǝnnil, tǝnay-tu tabarart ǝn Firɣawna, tǝdkal-tu tǝg-ay barar-net, tǝg-as ǝsǝdwǝl wa za tagu i barar ǝn tǝdist-net. ");
INSERT INTO ttq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Itawasasaɣru Musa masnat kul ta n Kǝl-Masar, iqqal alǝs ilân tǝnna daɣ awa igannu d awa itaggu. ");
INSERT INTO ttq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","As iga ǝkkozat tǝmǝrwen n awatay ǝd tǝhǝwt, iggaz-t-id a din-asu imǝdrayan-net Kǝl-Israyil inǝy awa dǝr t-ǝllan. ");
INSERT INTO ttq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Inay iyyan daɣ-san tawagginat-as taršǝxšad, oɣ-as šinaɣen, iga iman n aw Masar wa das-itaggin ark aratan. ");
INSERT INTO ttq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iɣil ad agrin mǝdrayan-net Kǝl-Israyil as Mǝššina a t-id-izammazalan sǝr-san fǝl a tan-assafsu, mišan wǝr ǝgren awen. ");
INSERT INTO ttq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ǝzǝl wa ilkaman i wen, osa-du ǝššin daɣ-san ǝknâsan. Igmay d a tan-aknu, nǝmǝggin alxer, inn-asan: \"Meddan, kawanay ǝmosnen imǝdrayan, mafel as tǝtinǝmǝnɣim?\" ");
INSERT INTO ttq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mišan ibdaq-q-in alǝs wa itaggin taršǝxšad y ǝmidi-net, inn-as: \"Ma kay-igan ǝmuzar-nana wala ǝmašraɣ-nana? ");
INSERT INTO ttq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ǝngǝm a tareɣ a di-taga tenaɣay ta tǝgeɣ y aw Masar wa n ǝndazǝl?\" ");
INSERT INTO ttq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Isla Musa i batu ten ɣas, tǝggaz-tu tasa, igmad Masar ilɣas daɣ akal wa n Midǝyan, iqqal daɣ-as ǝɣǝrib, izlaf daɣ-as igraw ǝššin bararan. ");
INSERT INTO ttq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","As ǝganat ǝkkozat tǝmǝrwen n awatay dǝffǝr awen, \"inafalal-as-du angalos daɣ tǝfsǝq tǝbilaglagat daɣ taneray ɣur ǝdɣaɣ\" wa n Sinay. ");
INSERT INTO ttq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Isammaklal ǝs Musa arat wa das-d-inafalal den. Itihaz-in za tafsǝq fǝl ad annaflay daɣ awen, as isla y ǝmǝsli n Ǝmǝli Mǝššina as das-inna: ");
INSERT INTO ttq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"Nak a imosan Mǝššina ǝn marawan-nak, Ǝmǝli n Ibrahim, d Isǝhaq ǝd Yaqub.\" Tǝndaw taysǝst Musa abʼas ihal ad ilǝs asawad daɣ tǝfsǝq en. ");
INSERT INTO ttq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Inn-as deɣ Ǝmǝli: \"Ǝkkǝs iɣateman-nak, fǝlas edag wa daɣ tǝbdadaɣ ǝddi amaḍal zǝddigan a imos. ");
INSERT INTO ttq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ǝɣɣǝyyanaɣ alɣazab wa tǝtaggu tamattay-nin daɣ Masar, ǝslêɣ deɣ i hǝrǝrrǝkitan-nasan. Ǝzzǝbbe-du fǝl a tan-assafsa. Ǝmǝrǝdda ihaz-du, a kay-zǝmmizǝla ǝs Masar.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa wen da, a ǝnkuran ǝs tǝnna ta das-ǝgan: \"Ma kay-igan ǝmuzar-nana wala ǝmašraɣ-nana?\" Ǝnta en da za, a d-izammazal Mǝššina y ad izar i Kǝl-Israyil, isǝddǝrfǝt-tan, ǝs tarna n angalos wa das-d-inafalalan daɣ tǝfsǝq. ");
INSERT INTO ttq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ǝnta en da, a tan-d-ikkasan daɣ Masar s aratan simaklalnen win itaggu ǝd tǝlmǝɣjujaten ǝmosnen alɣalamaten ǝn tarna ǝn Mǝššina. Iga aratan wiyyad simaklalnen ǝd tǝlmǝɣjujaten ǝmosnen alɣalamaten ɣur aradaɣ wa ǝgan daɣ Agaraw was itawannu wa Zaggaɣan, igla itaggu awen da daɣ taneray har iga ǝkkozat tǝmǝrwen n awatay. ");
INSERT INTO ttq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa en da, a innan i Kǝl-Israyil: \"Ilkâm a sǝr-wan d-izǝmmizǝl Mǝššina ǝnnǝbi iyyan ǝn šilat-in, a kawan-du-z-igmǝdan.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","As tǝddew tamattay n Israyil daɣ taneray ǝn Sinay, ǝnta en da a ibdadan gǝr marawan-nana win den d angalos wa das-iššewalan fǝl ǝdɣaɣ wa n Sinay, tǝzzar ikf-ay Mǝššina awalan hakkinen tǝmǝddurt y a dana-tan-imǝl. ");
INSERT INTO ttq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mišan ugayan marawan-nana s ad ǝlkǝman y awa inna Musa, ugayan sǝr-ǝs, saddaranan ad ǝqqǝlan Masar. ");
INSERT INTO ttq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ǝnnan i Harun: \"Ag-ana imalan a zʼǝmǝlnen dat-na, fǝlas Musa wa dana-d-ikkasan daɣ akal ǝn Masar da, wǝr nǝssen awa daɣ-as in-igan.\" ");
INSERT INTO ttq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Adan en da a daɣ ǝgan ǝssǝnǝm igân tǝmǝwit a n abarkaw, ǝkatan fall-as. Isidawat-tan wǝllen arat wa ǝgan ǝs fassan-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tǝzzar inamaggag dǝr-san Mǝššina, oyy-en ǝd man-nasan, ǝɣbadan tǝfuk ǝd tǝllit d etran, imos awen arat ǝnnân Ǝlkǝttaban, as ǝnnan: \"Ya Kǝl-Israyil, awak nak as tǝtaggim šizǝgzam ǝd tǝkutawen daɣ ǝkkozat tǝmǝrwen n awatay šin tǝgam daɣ teneray? ");
INSERT INTO ttq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wǝrgeɣ ahaket n ǝssǝnǝm wa igan Molox a tewayam, ǝd šaššelan n ǝtri wa igan Rǝmfan wa n ǝssǝnǝm-nawan, ǝmosnen ǝssǝnǝman win tǝgam\" fǝl a tan-tǝɣbǝdam! \"Adi fǝl kawan-z-ǝstǝɣa har takǝyam\" Babǝylon. ");
INSERT INTO ttq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Amaran imarawan-nana win d-ikkas Mǝššina daɣ Masar ǝggazan teneray, ǝlân ǝhaket wa n ǝmǝnǝy ǝd Mǝššina, was omar Mǝššina Musa s ad t-agu s ǝmmǝk wa t-issǝkna. ");
INSERT INTO ttq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ahaket en, iggaz-du ǝs marawan-nana win dǝffǝr win den, azzaman win daɣ dasan-azzar Joswe, ewayan-tu s akal wa ǝbazan, s ǝnta a daɣ istaɣ Mǝššina tawšeten dat-san. Iggaz ahaket wen akal en da har azzaman n ǝnnǝbi Dawǝd. ");
INSERT INTO ttq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ǝnnǝbi Dawǝd igrâw arraxmat ɣur Mǝššina. Ǝnta a igmayan daɣ Mǝššina turagat n ad ikrǝs ehan y Ǝmǝli ǝn Yaqub. ");
INSERT INTO ttq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mišan ǝnnǝbi Suliman a igrawan turagat ten, ikras ehan y Ǝmǝli Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Dǝr iga awen da ya, Mǝššina di n Amadkol wǝr ixser daɣ a ǝkrasan fassan n aytedan. Adi a inna ǝnnǝbi Isayas as inna: ");
INSERT INTO ttq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Inna Ǝmǝli Mǝššina: \"Ijǝnnawan a ǝmosnen tǝxawit-in ta n taɣmar, amaḍal wǝr imos ar arat illan daw daran-in. Daɣ adi ma imos ǝzzǝnǝf n ahan wa di-za-tǝkrǝsam? Madeɣ edag wa daɣ zʼassanfa? ");
INSERT INTO ttq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wǝrgeɣ ǝfus-in a d-ixlakan adi kul?\"» ");
INSERT INTO ttq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Harwa inn-asan Ǝstefanos: «Ya meddan win ǝqqǝssatnen, tǝxfâlam iwallan-nawan, tǝdbâɣam šimǝzzugen-nawan wǝr tǝzlayam d aytedan wǝr nǝksud Mǝššina, faw tugâyam s Infas wa Zǝddigan. Adi da a ǝgan marawan-nawan. ");
INSERT INTO ttq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mǝni daɣ ǝnnǝbitan wa wǝr zaɣɣazzaban marawan-nawan? Ǝgan iman ǝn nǝmmuzal ǝn Mǝššina win ǝmalnen dat alwaq assa ǝn Wa Oɣadan, as kawanay ǝmǝrǝdda a t-ikkǝddalan tǝgam iman-net. ");
INSERT INTO ttq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kawanay win d-issoka Mǝššina angalosan ewâynen ǝlqanun-net, mišan tugayam s a das-tǝlkǝmam.» ");
INSERT INTO ttq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","As ǝslan i batu ten, iggaz-tan alham labasan, ad samadadan fǝl alham n Ǝstefanos. ");
INSERT INTO ttq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mišan ǝnta idkâran Infas wa Zǝddigan, idkal asawad-net sa sǝr jǝnnawan, inay tanaya ǝn Mǝššina, inay deɣ Ɣaysa ibdâd daɣ ǝɣil ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tǝzzar inn-asan: «Ǝnǝyat, ijǝnnawan ǝnnolaman! Hannayaɣ Ag Aggadǝm ibdâd daɣ ǝɣil ǝn Mǝššina.» ");
INSERT INTO ttq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ǝslan y awen ɣas, ad zayyakan ǝdbâɣan šimǝzzugen-nasan, ǝggadan-in ketnasan s Ǝstefanos, ǝbazan-tu. ");
INSERT INTO ttq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ǝkkasan-tu daɣ ǝɣrǝm, ad t-ǝggaran ǝs tǝhun. Amaran meddan win fall-as ǝgǝyyatnen, alǝs n ammas igân esǝm Talut a ɣur ǝssǝnsan ibǝrnaz-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ǝggâran Ǝstefanos ǝs tǝhun as ittar inna: «Ya Ǝmǝli Ɣaysa, ǝqbǝl iman-in!» ");
INSERT INTO ttq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dǝffǝr awen, igaraffat, idkal ǝmǝsli-net s afalla, inna: «Ya Ǝmǝli, a tan-wǝr-tǝssǝwaraɣ abakkad wa!» As inna awen, ǝgmadan-tu man. ");
INSERT INTO ttq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Amaran Talut ǝnta, iha win ǝrḍanen s ǝtǝwǝnɣa n Ǝstefanos. Tǝttǝyt n Ǝlkǝnisat – Šiggǝyyawen daɣ Yahudǝyya ǝd Samarǝya Ǝzǝl wen da ad tǝnta tǝssust labasat fǝl Ǝlkǝnisat ta tǝhat Yerusalam; tǝzzar wazawazan ǝlmǝsixitan ketnasan daɣ kallan win Yahudǝyya ǝd Samarǝya. Wǝr d-iqqim daɣ Yerusalam ar inǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Osan-du meddan ǝn miksadan ǝn Mǝššina, ǝnbalan-in Ǝstefanos. Ǝyyǝwanan fall-as tala. ");
INSERT INTO ttq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Talut ǝnta, issǝnta daɣ ǝhluk n Ǝlkǝnisat. Irzag inan, ilabbay-du daɣ-san meddan ǝd tǝdoden, iggar-tan daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Amaran imǝzzǝgzan ǝs Ɣaysa win tǝwazawaznen den, ǝrzagan akal ketnet ǝmmâlan y aytedan isalan win ǝhanen Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Awen da a d-ewayan Filibus s ǝɣrǝm iyyan n akal ǝn Samarǝya a daɣ-as immâl y aytedan isalan n Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","As tǝsla aljamaɣat tagget tǝnimannakat y awal ǝn Filibus, tǝnay deɣ tǝlmǝɣjujaten šin itaggu ǝmosnen alɣalamaten ǝn tarna ta igraw, tǝssoɣal-in ǝnnǝyat-net aratan win igannu. ");
INSERT INTO ttq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fǝlas aytedan aggotnen a ǝgmadan kǝlǝsuf. As tan-du-gammadan, takkasan imaslan labasnen. Tawazozayan deɣ nǝbdan ǝd mǝggudal aggotnen. ");
INSERT INTO ttq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eway-du awen tǝdǝwit agget daɣ ǝɣrǝm en. ");
INSERT INTO ttq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Amaran aɣrǝm en, ih-ay alǝs iyyan n amassaxar igân esǝm Simɣon itaggin išaɣawan simaklalnen s aytedan ǝn Samarǝya. Igannu ǝnta awedan zǝwwǝran a imos. ");
INSERT INTO ttq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aytedan kul sasaman-as s ǝlluɣ, gǝr za win wǝr nǝla almaqam, wala win t-ǝlanen, gannin: «Alǝs wa, tarna n Ǝmǝli tas itawannu ta togarat a imos.» ");
INSERT INTO ttq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Aytedan win sasaman-as s ǝlluɣ, fǝlas irǝw itagg-asan išaɣawan sǝr-san simaklalnen. ");
INSERT INTO ttq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mišan as ǝzzǝgzanan i Filibus a dasan-immâlan isalan ǝn taɣmar ta n Mǝššina ǝd tarna n esǝm ǝn Ɣaysa Ǝlmǝsix, tawasalmaɣan daɣ aman, meddan harkid tǝdoden. ");
INSERT INTO ttq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Izzǝgzan Simɣon ǝnta da, itawasalmaɣ daɣ aman; iltaɣ daɣ Filibus. Ǝqqânnat alɣalamaten ǝn tarna ǝd tǝlmǝɣjujaten zawwarnen šin itaggu Filibus eɣaf-net. ");
INSERT INTO ttq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","As ǝslan nǝmmuzal daɣ Yerusalam as Kǝl-Samarǝya ǝqbalan awal ǝn Mǝššina, zammazalan sǝr-san Butros ǝd Yaxya. ");
INSERT INTO ttq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","As tan-in-osan, ǝttaran-asan a fall-asan d-izazzabben Infas wa Zǝddigan, ");
INSERT INTO ttq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","fǝlas harwa da wǝr tan-iha i fǝl d-izzibbat, ǝtǝwǝsǝlmaɣ ɣas a tawaggan daɣ aman s esǝm n Ǝmǝli Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tǝzzar a tan-isawar Butros ǝd Yaxya ifassan-nasan, garrawan Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","As inay Simɣon as, Infas wa Zǝddigan ǝsǝwǝr ǝn fassan ǝn nǝmmuzal as itawagraw, igmay daɣ-san a tan-akfu azrǝf, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Akfiwat-i nak da tarna tǝdi, tas i ǝssǝwara ifassan-in ad igrǝw Infas wa Zǝddigan.» ");
INSERT INTO ttq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Inn-as Butros: «Tǝhlǝkaɣet kay d ǝzrǝf-nak, zama tǝɣila tǝfrâgaɣ a tazzanza tǝhǝkkut ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Batu ta, wǝrmad tat-tǝheɣ za wala tǝleɣ daɣ-as tanat fǝlas ǝwǝl-nak wǝr oɣed dat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Daɣ adi utab daɣ ǝššur-nak, tansǝya Mǝššina a dak-issurǝf ark ǝnnǝyat ta tǝhat ǝwǝl-nak, kud immikkan adi. ");
INSERT INTO ttq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Fǝlas hannayaɣ as, ǝwǝl-nak wǝr idker ar tara n ǝddǝnet labasat d iba n aqqad.» ");
INSERT INTO ttq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tǝzzar inn-asan Simɣon: «Ansǝyat-i Ǝmǝli kawanay iman-nawan fǝl a di-wǝr-abǝz s awa tǝnnam.» ");
INSERT INTO ttq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Butros ǝd Yaxya win nǝmmuzal, as ǝmalan y aytedan awa ǝggǝyyen fǝl Ɣaysa Ǝlmǝsix, ǝmǝlan-asan deɣ awal n Ǝmǝli, ǝqqalan Yerusalam. Ǝmalan isalan n Ǝlinjil daɣ taɣarmaten aggotnen ǝn Samarǝya šin ǝhanen tarrayt-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dǝffǝr awen iššewal angalos n Ǝmǝli i Filibus, inn-as: «Ǝnkǝr tawǝya ǝd tarrayt tǝkkât agala ta tǝgmadat Yerusalam tǝras tǝkka Gaza.» Tarrayt ten, tǝssuf. ");
INSERT INTO ttq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Inkar Filibus, igla. Ijiwankat daɣ tarrayt as immǝnay d alǝs n ǝnazum n akal n Etǝyofǝya imosan awedan zǝwwǝran daɣ taɣmar ǝn Kandas ta n tǝmǝnokalt n Etǝyofǝya s ǝnta a innǝttafan d ǝrrǝzǝɣ kul wa n tǝmǝnokalt en. Osâ-du Yerusalam fǝl a daɣ-as iɣbǝd Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Iqqâl akal-net, iqqîm daɣ amalankay-net, iɣarru ǝlkǝttab n ǝnnǝbi Isayas. ");
INSERT INTO ttq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Inna Infas wa Zǝddigan i Filibus: «Ihaz-in amalankay en, tǝmmudǝɣaɣ i mǝššis» ");
INSERT INTO ttq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ozal-in sǝr-ǝs Filibus. Isl-as iɣarru ǝlkǝttab n ǝnnǝbi Isayas, inn-as: «Awak tǝgreɣ almaɣna n awa tǝɣarra ǝddi?» ");
INSERT INTO ttq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Inn-as alǝs wen: «Manǝmmǝk as tu-z-agra, wǝr t-illa awedan a di-t-iffǝssaran?» Tǝzzar igmay daɣ Filibus a d-iwǝn, aqqam dǝgma-net. ");
INSERT INTO ttq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Edag wa iɣarru daɣ ǝlkǝttab en, ǝnta da awa inna: «Ittilway zun tilay s adag n agazam, tǝfastit a itaggu ǝjaɣol y aytedan lazzinen tǝduft-net a iga, wǝr d-igmed ǝlxǝrǝf imi-net. ");
INSERT INTO ttq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Itiwasaras, wǝr das-ǝgen ǝššǝriɣa wa dǝr ihor. Ma ifragan igi ǝn salan kul ǝn hayawan-net, id tǝtiwazaraz tǝɣrǝst-net daɣ ǝddǝnet?» ");
INSERT INTO ttq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tǝzzar issǝstan alǝs wa n Etǝyofǝya Filibus, inn-as: «Kay ak ǝmǝl-i, was iha ǝnnǝbi šin-net da. Ǝnta iman-net meɣ awedan iyyan?» ");
INSERT INTO ttq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ibaz Filibus ɣur batu ten da, imal-as isalan n Ǝlinjil ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ǝglân za, as d-osan edag ǝhân aman, tǝzzar inna alǝs wa n Etǝyofǝya: «Aman da, ma di-z-igdǝlan ad tǝwǝsǝlmǝɣ?» ");
INSERT INTO ttq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Inn-as Filibus: «wǝr t-illa, kud tǝzzigzana s ǝwǝl iyyanda.» Inn-as alǝs wen: «Ǝzzigzanaɣ as Ɣaysa Ǝlmǝsix Barar ǝn Mǝššina a imos.» ");
INSERT INTO ttq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Omar alwaq wen da s ad itǝwǝsǝbdǝd amalankay, ǝzzǝbben ǝnta ǝd Filibus, ǝggazan aman, issǝlmaq-qu Filibus. ");
INSERT INTO ttq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Da da ɣas a d-ǝgmadan aman, ǝnta ad idkal Infas n Ǝmǝli Filibus, abʼas t-ihannay alǝs wen, mišan igla daɣ tarrayt-net, ikna tǝdǝwit. ");
INSERT INTO ttq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus ǝnta, as din-igra iman-net iha aɣrǝm n Azot. As t-igmad illil akal en itaggu daɣ ɣǝrman kul win ǝhanen tarrayt isalan n Ǝlinjil har osa aɣrǝm ǝn Qaysarǝya. ");
INSERT INTO ttq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","As itaggu awen, Talut harwada isamahad fǝl igi ǝn man ǝn nǝttulab n Ǝmǝli Ɣaysa. Ikka Ǝlimam wa Zǝwwǝran, ");
INSERT INTO ttq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","igmay daɣ-as a das-agu šira ǝs nan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud win ǝɣrǝm ǝn Damas ǝmosnen šira a t-ǝkfânen turagat s as, as igraw aytedan, gǝr za meddan wala šidoden, win ǝhanen tarrayt ta n Ɣaysa, a tan-ikrǝd ilwǝy-tan-du ǝs Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ikkâ za aɣrǝm ǝn Damas, as t-in-ihoz, wǝr isla a igan as fall-as ibalazzat ǝnnur a d-igmâdan ijǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ifataqqat, isla y ǝmǝsli wa das-innan: «Talut, Talut mafel as di-tǝzaɣazzaba?» ");
INSERT INTO ttq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Inn-as Talut: «Ma tǝmosaɣ, Ǝmǝli?» Isla i wa das-innan: «Nak Ɣaysa wa tǝzaɣazzaba. ");
INSERT INTO ttq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ǝbdǝd ǝggǝz aɣrǝm a dak-attamal awas kay-iwar igi-net.» ");
INSERT INTO ttq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Meddan win ǝddewnen ǝd Talut ǝbdâdan, tǝgdal-asan tǝrǝmmeq awal, sallan y ǝmǝsli mišan wǝr hǝnnǝyan awedan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ibdad-du Talut, ora šittawen-net, mišan indar-as anay ǝn wala. Kundaba as ǝbazan midawan-net ǝfus-net, ǝlwayan-tu har dǝr-ǝs ǝggazan Damas. ");
INSERT INTO ttq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Har iga karad adan wǝr ihǝnnǝy arat, wǝr itša za wǝr išwa. ");
INSERT INTO ttq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Amaran Damas ih-êt ǝnalkim ǝn Ɣaysa igân esǝm Ananǝyâs. Iɣr-ay Ǝmǝli daɣ tǝrgǝt inn-as: «Ananǝyâs!» Ikkǝwan-as inn-as: «Nak da, Ǝmǝli!» ");
INSERT INTO ttq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Inn-as Ǝmǝli: «Ǝnkǝr, tǝssǝwǝla ǝd tarrayt tas itawannu \"ta toɣadat\", takkaɣ ehan ǝn Yahuza, tǝssǝstǝnaɣ d alǝs n ǝɣrǝm ǝn Tarsa igân esǝm Talut, id itansay-i daɣ alwaq wa da. ");
INSERT INTO ttq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Amaran inay daɣ tǝrgǝt alǝs igân esǝm Ananǝyâs as t-id-osa, issǝwar-tu ifassan-net fǝl a t-id-iqqal asawad-net.» ");
INSERT INTO ttq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tǝzzar inn-as Ananǝyâs: «Ya Ǝmǝli, aytedan aggotnen ǝgân-i isalan n alǝs di, ǝd talbast tagget ta issǝkna imizdagan-nak win ǝhanen Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Da da ila turagat n abbaz n aytedan kul win tattarnen s esǝm-nak, amaran imuzaran ǝn limaman a t-ǝkfanen turagat ten.» ");
INSERT INTO ttq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mišan inn-as Ǝmǝli: «Aglu, alǝs di nak a t-isannafran fǝl a di-imǝl y aytedan wǝr nǝmos Kǝl-Ǝlyǝhud ǝd mǝnokalan-nasan, imǝl-i deɣ i Kǝl-Israyil. ");
INSERT INTO ttq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nak iman-in as das-z-agaɣ ǝzǝɣɣǝzzǝb kul wa t-iwaran fǝl ǝddǝlil-in.» ");
INSERT INTO ttq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tǝzzar igla Ananǝyâs har din-osa ehan, iggaz-tu, inay Talut, issǝwar-tu ifassan-net, inn-as: «Amadray-nin Talut, Ǝmǝli Ɣaysa wa dak-inafalalan daɣ tarrayt ta du-tǝgeɣ, ǝnta a di-d-izammazalan fǝl a kay-d-iqqǝl asawad-nak, idnǝy-kay Infas wa Zǝddigan.» ");
INSERT INTO ttq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tamazayt ten da a daɣ d-ǝrtakan aratan olanen ǝd tǝfǝrǝnkawen daɣ šittawen ǝn Talut, tǝzzar iqqal-t-id asawad-net. Ibdad, itawasalmaɣ daɣ aman. ");
INSERT INTO ttq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dǝffǝr awen itša, ǝqqalnat-t-idu tǝɣurad-net. Iga arat n adan ɣur nalkiman ǝn Ɣaysa win ǝhanen Damas. ");
INSERT INTO ttq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tarmâd as ikka Talut inan n ǝlɣibada win Kǝl-Ǝlyǝhud a daɣ-san immâl as Ɣaysa Barar ǝn Mǝššina a imos. ");
INSERT INTO ttq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Isammaklal awen s aytedan ad gannin: «Ak wǝrgeɣ ǝnta, as kala ibbǝnbay daɣ aytedan win tattarnen s esǝm ǝn Ɣaysa daɣ Yerusalam ihallak-kan? Wǝrgeɣ wǝr t-id-eway s ǝɣrǝm wa, ar a tan-abǝz, ilwǝy-tan ǝs muzaran ǝn limaman?» ");
INSERT INTO ttq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mišan Talut ǝnta itisuhit ǝzǝzgzan-net. Wǝr ǝssenan Kǝl-Ǝlyǝhud win Damas a das-ǝnnan daɣ ǝsǝkni wa tan-itaggu as Ɣaysa ǝnta a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","As irǝw Talut daɣ Damas, namaggan Kǝl-Ǝlyǝhud eɣaf fǝl ad agin iman-net, ");
INSERT INTO ttq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mišan ittǝmal-as awen. Ewadan daɣ tara ǝn tǝnaɣay-net as das-ǝnkadan ehad ezal ɣur mawan n ǝɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","As ahad iyyan, ǝnkaran nǝttulab-net ǝgan-tu daɣ ǝzmam zǝwwǝran, ǝrdafan daɣ-as aɣan, zazzabben-tu fǝl aganna wa hadan n aɣalla wa iɣlayan aɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","As osa Talut Yerusalam, igmay d ad irtǝy ǝd nalkiman ǝn Ɣaysa, mišan ǝwafan-tu ketnasan fǝlas harwa da wǝr ǝzzǝgzanan as iyyan daɣ-san a imos. ");
INSERT INTO ttq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ibaz-t-idu Barnabas ǝs man-net, iddew dǝr-ǝs ǝs nǝmmuzal, tǝzzar ig-asan isalan kul n ǝmmǝk was inay Talut Ǝmǝli Ɣaysa daɣ tarrayt ǝn Damas d awal wa das-iga, imal-asan deɣ igi wa iga isalan n Ǝmǝli Ɣaysa daɣ Damas wǝr t-illa i as tu-tǝha tasa-net. ");
INSERT INTO ttq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Alwaq wǝdi a dǝr-san irtay, itidaw dǝr-san daɣ Yerusalam. Itaggu isalan n Ǝmǝli Ɣaysa ši wala tasa ǝn waliyyan. ");
INSERT INTO ttq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Itimǝšiwil Talut ǝd Kǝl-Ǝlyǝhud win ǝššewalnen tǝlyunant, itamazaɣ deɣ dǝr-san; ad gammayan d igi ǝn man-net. ");
INSERT INTO ttq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","As ǝslan mǝdrayan-net daɣ ǝzǝgzan awen, ǝddewan dǝr-ǝs wiyyad daɣ-san s ǝɣrǝm ǝn Qaysarǝya, amaran ǝssokan-tu wa n Tarsa. ");
INSERT INTO ttq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Azzaman en, ǝgrâwan daɣ-san nalkiman ǝn Ɣaysa d Ǝlkǝnisaten alxer daɣ akal kul wa n Yahudǝyya ǝd wa n Galilaya ǝd wa n Samarǝya. Itasahat ǝzǝgzan n Ǝlkǝnisaten, tagginat imazalan ǝssiɣmarnen Ǝmǝli, tittǝynat deɣ ǝs tilalt n Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Illil za Butros akal ketnet har iras taɣrǝmt ta n Ludda fǝl ad inǝy imizdagan win daɣ-as ǝxsarnen. ");
INSERT INTO ttq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Inay daɣ-as alǝs igân esǝm Enǝyas, igân ǝttam elan ǝd bǝddǝn, wǝr kala igmad tǝssut-net. ");
INSERT INTO ttq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Inn-as Butros: «Enǝyas, ǝbdǝd tada tǝssut-nak, Ɣaysa Ǝlmǝsix izzozay-kay.» Ibdad Enǝyas tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ǝnayan-tu aytedan kul win tǝɣrǝmt ǝn Ludda ǝd win azawaɣ wa n Šaron, tǝzzar ǝhdan-du s Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","As itaggu awen aɣrǝm ǝn Yaffa tǝxsâr daɣ-as tǝnalkimt ǝn Ɣaysa tǝgât esǝm Tabita, almaɣna n esǝm wa daɣ tǝlyunant Dorkas, almaɣna «Tenert». Wǝr tǝgmed ar s igi ǝn mazalan olaɣnen ǝd tǝkutawen i maddararan. ");
INSERT INTO ttq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Adan en da a daɣ tǝrin, aba-tat. Tǝtawašarad, tǝtawasansa daɣ ahan wa n afalla ǝn suru. ");
INSERT INTO ttq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Dad imos as Ludda wǝr tǝggug Yaffa, as ǝslan nalkiman ǝn Ɣaysa win ǝhanen Yaffa as Butros iha Ludda, zammazalan sǝr-ǝs ǝššin meddan fǝl ad t-ansǝyan a tan-d-akku tarmâd. ");
INSERT INTO ttq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Inkar Butros iddew dǝr-san. As din-osa, ewayan-tu ǝs suru wa tǝha tǝɣǝssa ǝn tǝntut, ǝkkanat-idu tǝdoden šin as wǝr ǝdderan meddan-nasnat hallinat, sakninat-tu šikadkaden ǝd sǝlsa wiyyad a dasnat-tǝga Dorkas harwa tǝddâr. ");
INSERT INTO ttq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Issǝrdaɣ Butros awedan kul, igaraffat ad itattar. As issǝnda tǝwatray-net, imalallay-du taɣǝssa ǝn tǝntut ta aba, inna: «Tabita, ǝnkǝr-du», tǝzzar tora šittawen-net, tǝnay Butros, tǝqqim-du. ");
INSERT INTO ttq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Izzal-as-in ǝfus-net, illil-as ǝs tebadday, amaran iɣra-du imizdagan ǝd tǝdoden šin as wǝr ǝdderan meddan-nasnat, issǝkn-asan-tat tǝddâr. ");
INSERT INTO ttq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Itawasla awen daɣ ǝɣrǝm ǝn Yaffa ketnet, tǝzzar ǝzzǝgzanan aytedan aggotnen s Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iha Butros Yaffa har irǝw, illa ɣur alǝs iyyan igân esǝm Simɣon as imos ǝššǝɣǝl-net ǝšifǝl ǝn gǝškan. ");
INSERT INTO ttq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aɣrǝm ǝn Qaysarǝya ih-ay alǝs iyyan ǝn Kǝl-Ǝrrum igân esǝm Kornilǝyas, imos iyyan daɣ kabtanatan win azzarnen y agan ǝn sojitan was itawannu «Italǝya». ");
INSERT INTO ttq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Imos alǝs iksudan Mǝššina, iɣbâd-tu ǝnta d aytedan n ahan-net ketnasan, itaggu šikutawen aggotnen i Kǝl-Ǝlyǝhud, faw deɣ itattar ǝs Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","As ǝzǝl iyyan ɣur amaḍal ǝn karad alwaqan win tazzar, inafalal-as-du angalos ǝn Mǝššina, inay-tu as d-iggaz ehan-net, inn-as: «Kornilǝyas!» ");
INSERT INTO ttq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Irmaɣ Kornilǝyas, igar šittawen daɣ angalos, inn-as: «Ya Mǝšši, ma tareɣ?» Inn-as angalos: «Šiwatriwen-nak ǝd tǝkutawen-nak ǝggǝzzaynat ǝs Mǝššina, iqbâl-tanat. ");
INSERT INTO ttq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Daɣ adi ǝmǝrǝdda, zǝmmizǝl meddan s ǝɣrǝm ǝn Yaffa a dak-d-idawan d alǝs iyyan igân esǝm Simɣon as itawannu Butros, ");
INSERT INTO ttq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","inniftaɣan i Simɣon wa išafalan igǝškan s ehan-net ihâ tagadamayt n agaraw.» ");
INSERT INTO ttq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ifal-tu angalos wa das-iššewalan ɣas, iɣra-du imaššaɣalan-net ǝššin d iyyan daɣ sojitan win išašɣal imosan awedan iksudan Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","issoɣal-asan awa igan kul, amaran izammazal-tan ǝs Yaffa. ");
INSERT INTO ttq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ǝhôzan-in aɣrǝm ǝzǝl wa hadan, as iwar Butros afalla ǝn taɣazamt attayan n ammas n azal fǝl ad agu šiwatriwen. ");
INSERT INTO ttq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Itattar den da as t-iggaz gǝlǝk, isaddaran a itša. Tawaggin-as-du mensewan as tu-tobaz tarna n Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ogga ijǝnnawan as ǝmmoran, itawasaras-du daɣ-san arat olân d ǝfǝr zǝwwǝran itiwattafan s ǝkkozat tǝsǝlkad-net, har dat-ǝs imal. ");
INSERT INTO ttq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ǝhân-tu ǝzzǝnǝfan ǝn mudaran kul win jawankatnen fǝl amaḍal ǝd dǝmǝrdǝmaran ǝd gǝḍad. ");
INSERT INTO ttq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tǝzzar isla y ǝmǝsli iyyan as das-inna: «Butros, ǝnkǝr, tǝgzǝma, tatša!» ");
INSERT INTO ttq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mišan inn-as Butros: «Kala kala Ǝmǝli, id wǝr kala ad ǝtšeɣ a xaraman wala a immidasan.» ");
INSERT INTO ttq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ilas tesalay y ǝmǝsli en as inna: «Awa issǝxlal Mǝššina, wǝrgeɣ kay a tu-z-agin i xaraman!» ");
INSERT INTO ttq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Har iga ǝmǝsli en y awen karadat tǝnnawen, amaran immǝdkal ǝfǝr en ǝs jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Harwada iqqân awen eɣaf ǝn Butros, isamadran daɣ awa zʼiqqǝl almaɣna-net n awa das-d-inafalalan den, as d-ǝbdadan meddan win d-izammazal Kornilǝyas daɣ ǝmi n ahan ǝn Simɣon, dǝffǝr as ǝssistanan ǝd dad illa. ");
INSERT INTO ttq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ǝɣran-du mǝssawǝs n ahan, ǝssǝstanan-tan kud den da ad izzǝbbat Simɣon was itawannu Butros. ");
INSERT INTO ttq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Harwada isamadran Butros daɣ awa zʼiqqǝl almaɣna n arat wa das-d-inafalalan as das-inna Infas wa Zǝddigan: «Ǝnǝy! Meddan den karad a dǝr-ǝk sastannen. ");
INSERT INTO ttq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ad wǝr tǝzlǝyaɣ aytedan, ǝbdǝd, tazzabbeɣ, tidawa dǝr-san; id nak a tan-d-izammazalan.» ");
INSERT INTO ttq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tǝzzar izzǝbbat-du sǝr-san Butros inn-asan: «Nak da as tǝsaggadam. Ma imos ǝddǝlil wa kawan-d-ewayan da?» ");
INSERT INTO ttq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ǝnnan-as: «Kornilǝyas wa n kabtan ǝn Kǝl-Ǝrrum a dana-d-izammazalan, imosan alǝs oɣâdan, n ǝmiksad ǝn Mǝššina, ǝssiɣmaran-tu Kǝl-Ǝlyǝhud ketnasan. Ǝnta as inafalal angalos zǝddigan ǝn Mǝššina omar-tu s a kay-issǝgmǝy, tasaɣ-in ehan-net fǝl ad aslu y awa za tanna.» ");
INSERT INTO ttq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Amaran izzogaz-tan-du Butros, isammagarat-tan. As affaw, iddew dǝr-san. Ǝddewan dǝr-ǝs arat daɣ nalkiman ǝn Ɣaysa win n ǝɣrǝm ǝn Yaffa. ");
INSERT INTO ttq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","As ǝzǝl wa hadan ewadan aɣrǝm wa n Qaysarǝya. As din-osan da, iqqâl-asan Kornilǝyas ǝnta ǝd marwan-net d aytedan win dǝr ikna tǝmmidwa s ǝnta a tan-d-iɣran. ");
INSERT INTO ttq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","As zama din-iggâz Butros ehan, issǝlkad-as-du Kornilǝyas, igaraffat ɣur daran-net, issǝjad-as. ");
INSERT INTO ttq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mišan issǝbdad-tu Butros, inn-as: «Ǝbdǝd! Nak aggadǝm ɣas a ǝmosa.» ");
INSERT INTO ttq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ǝggazan ehan mišawalan, os-in daɣ-as Butros aljamaɣat tagget. ");
INSERT INTO ttq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tǝzzar inn-asan: «Tǝssânam kawanay iman-nawan as issixram ǝlqanun ǝn Kǝl-Ǝlyǝhud y iyyan daɣ-san tassaq madeɣ iguz n ahan n awedan wǝr nǝmos iyyan daɣ Kǝl-Ǝlyǝhud. Mišan nak issosan-i Mǝššina daɣ as ad wǝr agaɣ y awedan waliyyan iduf n as i xaraman wala immidas. ");
INSERT INTO ttq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Adi da fǝlas, as di-tǝssǝgmayam, ǝkkeq-qawan-du ǝddi da wǝr ǝgeɣ asarǝw waliyyan. Amaran ǝmǝrǝdda ǝmǝlat-i ǝddǝlil wa fǝl di-tǝssǝgmayam.» ");
INSERT INTO ttq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Inn-as Kornilǝyas: «Ǝzǝl iyyan tattara daɣ ahan-in, ila adi ǝmǝrǝdda karad adan, wǝr ǝsleɣ a igan as dat-i ibdad alǝs ilsân isǝlsa bilazlaznen. ");
INSERT INTO ttq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tǝzzar inn-i: \"Kornilǝyas! Tǝwatray-nak tǝqbâl, šikutawen-nak deɣ iqbâl-tanat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Daɣ adi, zǝmmizǝl ǝs Yaffa, tǝssǝgmǝya Simɣon was itawannu Butros. Inniftaɣ y alǝs igân Simɣon wa išafalan igǝškan ihân tagadamayt n agaraw.\" ");
INSERT INTO ttq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tǝzzar ǝssǝgmayaq-qay tamazayt tǝdi da, olâɣ deɣ as du-toseɣ. Amaran ǝmǝrǝdda ketnana nǝlla da dat Mǝššina, fǝl ad nǝssǝsǝm y arat kul was kay-omar Ǝmǝli s a danaq-qu-tanna.» ");
INSERT INTO ttq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Iššewal Butros inna: «Ǝmǝrǝdda ǝgreɣ as, tidǝt daɣ a imos as Mǝššina wǝr izlay aytedan. ");
INSERT INTO ttq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kalar awedan kul wa t-iksudan, itaggu awa oɣadan, awedan wǝdi, ad t-iqbǝl Mǝššina, a tǝqqal tawšet-net. ");
INSERT INTO ttq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Issoka-du Kǝl-Israyil awal-net imosan isalan n Ǝlinjil, ǝmmâlnen isalan n alxer wa ihakku Ɣaysa Ǝlmǝsix, ǝnta wa n Ǝmǝli n awedan kul. ");
INSERT INTO ttq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tǝssânam daɣ awa igan daɣ akal kul ǝn Yahudǝyya, intâ-du adi daɣ wa n Galilaya dǝffǝr tǝlxutbat ta iga Yaxya y aytedan daɣ batu n alamaɣ daɣ aman; ");
INSERT INTO ttq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","d ǝmmǝk was issǝkna Mǝššina aytedan as Ɣaysa wa n Nazaret a issannafran ǝs tahakkay ta t-iga Infas wa Zǝddigan ǝd tarna. Tǝssânam deɣ daɣ tilalt ta iga akal itamazal ǝlluɣ, izuzǝy aytedan kul win daɣ innoda Iblis, id tarna ǝn Mǝššina a igraw. ");
INSERT INTO ttq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nakkanay inǝmmuzal nǝggǝyat awa iga ketnet daɣ ǝɣrǝm wa n Yerusalam d akal sa hadan wa n Kǝl-Ǝlyǝhud. Ǝnta wa itawataytayan fǝl tǝgǝttawt, aba-tu; ");
INSERT INTO ttq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","issǝnkar-t-idu Mǝššina ǝzǝl wa n karad dǝffǝr iba-net, ikf-ay turagat n ad itǝwǝnǝy iddâr. ");
INSERT INTO ttq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wǝrgeɣ aytedan kul a t-ǝnaynen, kalar wǝr t-inay ar šigǝyyawen šin isannafran Mǝššina harwa dat alwaq, a tanat-imosan nakkanay win dǝr-ǝs ǝdrawnen tettay ǝd tassay dǝffǝr tanakra ta d-iga daɣ tamattant. ");
INSERT INTO ttq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tǝzzar omar-ana Ɣaysa s ad nǝmǝl Ǝlinjil y aytedan, naggayyat-asan as, ǝnta da, a isannafran Mǝššina ig-ay ǝmašraɣ n id t-illa awedan, gǝr za win ǝddarnen wala win aba. ");
INSERT INTO ttq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ǝnta en da as ǝggǝyyen ǝnnǝbitan kul as, i sǝr-ǝs izzǝgzanan ad igrǝw tǝsureft ǝn bakkadan-net s esǝm-net.» ");
INSERT INTO ttq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Harwada iššewal Butros as d-izzǝbbat Infas wa Zǝddigan fǝl aljamaɣat ketnet ta tǝssǝsamat i tǝlxutbat-net. ");
INSERT INTO ttq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ikna awen ǝsǝmmǝklǝl ǝs nalkiman ǝn Ɣaysa win Kǝl-Ǝlyǝhud win d-ǝddewnen ǝd Butros, âs, wala aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud da garrawan s igǝt tǝhǝkkut ta n Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Fǝlas sallan-asan ǝššewalan awalan wǝr nǝtawazday, ǝmmâlan adkul ǝn Mǝššina. Tǝzzar inna Butros: ");
INSERT INTO ttq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Awak ma zʼigdǝlan y aytedan ǝgânen y Infas wa Zǝddigan agaraw wa das-nǝga ad tǝwǝsǝlmǝɣan daɣ aman?» ");
INSERT INTO ttq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Amaran omar s ad tǝwǝsǝlmǝɣan daɣ aman s esǝm ǝn Ɣaysa Ǝlmǝsix. Dǝffǝr awen ǝgmayan daɣ Butros a ɣur-san agu adan. ");
INSERT INTO ttq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ǝslan nǝmmuzal ǝd mǝdrayan daɣ ǝzǝgzan win ǝhanen akal wa n Yahudǝyya as, ǝllân-tu aytedan wǝr nǝmos Kǝl-Ǝlyǝhud ǝzzigzannen ǝntanay da s awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Alwaq wad iggǝzzay Butros ǝs Yerusalam, ǝššewalan fall-as inalkiman ǝn Ɣaysa win Kǝl-Ǝlyǝhud win ǝttafnen alɣadat-nasan ta n ǝmǝnkǝd. ");
INSERT INTO ttq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ǝnnan-as: «Manǝmmǝk as tǝtaggaza ehan n aytedan wǝr nǝmmǝnkad, wala tǝdarraw dǝr-san imensewan.» ");
INSERT INTO ttq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tǝzzar issoɣal-asan Butros awa igan kul, wa n ǝnǝtti, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Tattara daɣ ǝɣrǝm ǝn Yaffa as di-tobaz tarna n Infas wa Zǝddigan, inafalal-i arat iyyan. Arat wa, itawasaras-du daɣ jǝnnawan, olâ d ǝfǝr zǝwwǝran itiwattafan s ǝkkozat tǝsǝlkad-net, har dat-i d-imal. ");
INSERT INTO ttq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ǝswada daɣ-as, zaggazdaq-qu, ǝnayaɣ daɣ-as eharay, ǝd tǝwaqqast ǝd dǝmǝrdǝmaran ǝd gǝḍad. ");
INSERT INTO ttq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tǝzzar ǝsleɣ y ǝmǝsli wa di-innan: \"Butros, ǝnkǝr, tǝgzǝma, tatša!\" ");
INSERT INTO ttq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mišan ǝnneɣ-as: \"Kala kala Ǝmǝli, id imi-nin wǝr kala t-iggaz arat xaraman wala iyyan immidasan.\" ");
INSERT INTO ttq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ǝlasa tesalay y ǝmǝsli en as inna daɣ jǝnnawan: \"Awa issǝxlal Mǝššina, wǝrgeɣ kay a tu-z-agin i xaraman!\" ");
INSERT INTO ttq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Har iga ǝmǝsli en y awen karadat tǝnnawen, amaran itawarkab-in awen ketnet ǝs jǝnnawan. ");
INSERT INTO ttq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tamazayt ten da a d-ǝbdadan karad meddan s ahan wa daɣ ǝssǝgana, sǝr-i d-ǝmmozalnen daɣ ǝɣrǝm ǝn Qaysarǝya. ");
INSERT INTO ttq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tǝzzar inn-i Infas wa Zǝddigan a dǝr-san idawa ǝddi da. Ad wǝr ǝzlǝyaɣ aytedan. Ǝddewa deɣ ǝd mǝdrayan-nana sǝdis win, har nǝggaz ehan n alǝs wa di-d-issǝgmǝyan. ");
INSERT INTO ttq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Issoɣal-ana ǝmmǝk was das-inafalal angalos daɣ ahan-net, ibdad dat-ǝs inn-as: \"Zǝmmizǝl awedan s ǝɣrǝm ǝn Yaffa y a dak-d-idaw ǝd Simɣon was itawannu Butros. ");
INSERT INTO ttq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A dak-agu amagrad a sǝr-ǝk du-z-awǝyan efsan kay d aɣaywan-nak ketnet.\" ");
INSERT INTO ttq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Harwada wǝr ǝhoga ǝššewala as fall-asan d-iga Infas wa Zǝddigan ǝzǝbbi wa fall-ana d-iga nakkanay daɣ tizarat. ");
INSERT INTO ttq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tǝzzar ǝkteɣ-du tǝnna ta iga Ǝmǝli: \"Yaxya, aman a daɣ issǝlmaɣ aytedan, mišan kawanay, Infas wa Zǝddigan a daɣ za tǝtǝwǝsǝlmǝɣam.\" ");
INSERT INTO ttq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Daɣ adi, dad zamas ig-asan Mǝššina tǝhǝkkut zun ta danaɣ-iga as nǝzzǝgzan s Ǝmǝli Ɣaysa Ǝlmǝsix, ma ǝmosa nak as gaddala i Mǝššina igi n awa ira?» ");
INSERT INTO ttq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","As tǝsla aljamaɣat i salan win, tǝffǝsta, tǝzzar ad tǝmmal Mǝššina tǝgannu: «Daɣ adi aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud, da issǝfrak-kan Mǝššina ad utaban, ǝgrǝwan tǝmǝddurt ta tǝɣlalat.» ");
INSERT INTO ttq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Inalkiman ǝn Ɣaysa win izawwazawaz alɣazab wa d-izrayan ǝtǝwǝnɣa n Ǝstefanos, ǝglan wiyyad har osan akal wa n Fenisǝya, wiyyad osan akal imosan gǝrwǝtlan as itawannu Qibrus, wiyyad osan aɣrǝm wa n Antǝyoxǝya. Ǝmmâlan awal ǝn Mǝššina, eges i Kǝl-Ǝlyǝhud ɣas. ");
INSERT INTO ttq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dǝr iga awen da ya, wiyyad daɣ-san n akal wa n Qibrus ǝd wa n Qǝrwan, as din-osan aɣrǝm wa n Antǝyoxǝya ǝššewalan y aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud win ǝššewalnen tǝlyunant, ǝmmâlan-asan isalan n Ǝlinjil n Ǝmǝli Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tǝdhal-tan tarna ǝn Mǝššina daɣ awa taggin, tǝzzar ǝzzǝgzanan aytedan aggotnen ǝs Ɣaysa Ǝlmǝsix, ǝtuban, ǝlkaman y Ǝmǝli imosan ǝmǝnokal-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Isalan n awen ewadan-in Ǝlkǝnisat ta tǝhat Yerusalam, tǝzzar tǝzammazal Barnabas s ǝɣrǝm n Antǝyoxǝya. ");
INSERT INTO ttq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","As din-osa inay arraxmat ǝn Mǝššina ta du-tǝzzǝbbet den, iddǝwat. Tǝzzar ig-asan ketnasan ǝnnǝsixa imosan ad ǝlkǝman y Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ǝnta iman-net Barnabas, alǝs olâɣan a imos, itkâran Infas wa Zǝddigan, issohat deɣ ǝzǝgzan-net. Ǝzzǝgzanan aytedan wiyyad aggotnen s Ǝmǝli Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Amaran ikka Barnabas aɣrǝm ǝn Tarsa, isaggad i Talut. ");
INSERT INTO ttq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","As t-igraw, iddew-du dǝr-ǝs s Antǝyoxǝya. Ǝgan daɣ-as awatay iɣrâdan osâɣan ǝd nalkiman ǝn Ɣaysa win ǝhanen Ǝlkǝnisat ten, sasaɣrin aytedan aggotnen. Aɣrǝm wen da n Antǝyoxǝya en a daɣ ǝssǝntan aytedan teɣaray nalkiman ǝn Ɣaysa s esǝm wa n «ǝlmǝsixitan». ");
INSERT INTO ttq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Adan en da a daɣ ǝgmadan ǝnnǝbitan wiyyad Yerusalam, ǝrasan s ǝɣrǝm wa n Antǝyoxǝya. ");
INSERT INTO ttq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ibdad iyyan daɣ-san igân esǝm Agabus, imal dat alwaq ǝs tarna n Infas wa Zǝddigan as, ilkâm ad agu laz labasan daɣ ǝddǝnet ketnet. Laz en da deɣ osa-du s ǝmmǝk was t-imal daɣ azzaman n ǝmǝnokal Klawdǝyus Qaysara. ");
INSERT INTO ttq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tǝzzar namardan nalkiman ǝn Ɣaysa win Antǝyoxǝya fǝl tanat tǝmosat ad irǝg akkiyyan daɣ-san awa ifrag sǝssiwǝyan tadhǝlt ta i mǝdrayan-nasan daɣ ǝzǝgzan win ǝhanen akal ǝn Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ǝgan awen da, ǝgan širgitan-nasan daɣ ǝfus ǝn Barnabas ǝd Talut y a tanat-awǝyan i muzaran n Ǝlkǝnisat ta tǝhat Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Azzaman en da a daɣ issǝnta ǝmǝnokal Herod ǝzǝɣɣǝzzǝb n arat daɣ aytedan n Ǝlkǝnisat. ");
INSERT INTO ttq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Isassanɣa ǝs takoba Yaqub wa n amadray ǝn Yaxya. ");
INSERT INTO ttq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","As inay as oggaman Kǝl-Ǝlyǝhud awen, isattarmas Butros. Itaggu awen adan n ǝmud wa daɣ tattin aytedan šigǝlwen šin wǝr iha xamira. ");
INSERT INTO ttq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Isassag-ay daɣ kasaw, issǝwǝq-qu i maraw sojitan ǝd sǝdis a tu-tinǝmǝzrǝynen s ǝkkoz ǝkkoz. Otâs a das-išrǝɣ dat awedan kul dǝffǝr ǝmud wa n Akkay. ");
INSERT INTO ttq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A iha Butros kasaw den, Ǝlkǝnisat ǝnta tǝdgâz wǝllen tǝtansay-as Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","As ahad wad zʼifaw išrǝɣ-as Herod, insâ Butros gǝr ǝššin sojitan a t-ǝttâfnen s ǝššin sassaran, ǝbdâdan deɣ magazan wiyyad dat ǝmi ǝn kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wala a ihogan inafalal-du angalos iyyan n Ǝmǝli, imalawlaw adag wa daɣ insa Butros daɣ ammas ǝn kasaw. Tǝzzar idas angalos tasaga ǝn Butros, issǝnkar-tu inn-as: «Ǝbdǝd tarmâd!» Ǝrtakan sassaran win as ǝkradan fassan-net daɣ tamazayt ten. ");
INSERT INTO ttq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Harwa inn-as: «Ǝzlǝg isǝlsa-nak, tǝsǝlaɣ iɣateman-nak.» Iga Butros awen da. «Ǝmǝrǝdda ǝzlǝg ǝbǝrnuz-nak, tǝlkǝmaɣ-i-du.» ");
INSERT INTO ttq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Igmad-du Butros ilkâm y angalos, wǝr issen as awa itaggu angalos den tidǝt a imos, iɣil targǝt awen. ");
INSERT INTO ttq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Okayan fǝl magazan win azzarnen ǝd win ǝllanen dǝnnǝg-san, amaran osan-du tǝsǝhǝrt ǝn tǝzoli tǝswâdat sa sǝr ǝɣrǝm. Tǝnnolam dat-san šin man-net, ǝrdaɣan. Ǝssǝwalan ǝd tarrayt iyyat, wala a ihogan ifal-tu angalos. ");
INSERT INTO ttq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tǝzzar iggaz Butros annawalat n aɣaf-net, inna: «Ǝmǝrǝdda ǝkkasaɣ aššak daɣ-as, Ǝmǝli Mǝššina a d-izammazalan angalos-net, ikkas-i-du daɣ fassan n ǝmǝnokal Herod ǝd talbast kul tas ǝran Kǝl-Ǝlyǝhud a di-tǝgrǝw.» ");
INSERT INTO ttq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Amaran igra taɣara-net, ikka ehan ǝn Maryama ta n anna ǝn Yaxya was itawannu Markus. Ǝmminayan ɣur-ǝs aytedan aggotnen tansayan Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ikawkaw imi n aɣalla, tǝgla-du tamaššaɣalt tǝgât esǝm Ɣoda y ad tǝssǝn awa imos awedan. ");
INSERT INTO ttq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","As tǝzday ǝmǝsli ǝn Butros, awa tǝga daɣ tǝdǝwit, edag n a das-talǝm, tozal tǝqqal ammas n ahan, tǝmal as Butros illa dat ǝmi n aɣalla. ");
INSERT INTO ttq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ǝnnan-as: «Kam, ǝmmǝskǝl a tǝgeɣ!» Mišan tǝzazzayyar-asan daɣ-as ǝnta daɣ awen. Amaran ǝnnan-as: «Daɣ adi angalos-net adi.» ");
INSERT INTO ttq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A ǝgannin awen, Butros ǝnta itakawkaw-asan imi n aɣalla. As olaman, ǝnayan-tu, iga sǝr-san awen ǝsǝmmǝklǝl labasan. ");
INSERT INTO ttq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Isaddagan-asan s ǝfus-net ad affastin, tǝzzar imal-asan tǝmǝwit kul tas t-id-ikkas Ǝmǝli Mǝššina daɣ kasaw. Inn-asan deɣ: «Ǝmǝlǝt adi i Yaqub ǝd mǝdrayan-nana win hadatnen.» Amaran ifal-tan, ikka edag iyyan. ");
INSERT INTO ttq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","As affaw, tǝga tǝnajarwayat labasat daɣ sojitan; akk iyyan isastan ǝmidi-net d awa iga Butros. ");
INSERT INTO ttq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","As t-id-aba y aytedan win as t-issǝswad Herod, issǝstan sojitan win t-ogaznen, amaran omar s ad tawanɣin kǝrǝz. Dǝffǝr awen igmad Herod akal wa n Yahudǝyya, izagaday ikka aɣrǝm ǝn Qaysarǝya y a daɣ-as agu tamert. ");
INSERT INTO ttq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Awen as itaggu, Herod ih-ay alham labasan n aytedan n ǝɣrǝm wa n Tir ǝd wa n Sidon. Idhal-tan Blastus wa n ǝmǝššewwǝr ǝn Herod, namannakan zammazalan ǝs Herod almawakkilan-nasan, fǝl a dǝr-ǝs aknin, fǝlas akal-net a du-gammadan sudar-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","As d-osa ǝzǝl wa itawasanafranan, izlag Herod isǝlsa-net win taɣmar tǝzzar iqqim fǝl tǝxawit-net ta n taɣmar, amaran iššewal i tamattay. ");
INSERT INTO ttq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ad saɣaren aytedan, gannin: «Ǝmǝsli wa in ǝmǝli iyyan, wǝrgeɣ in awedan!» ");
INSERT INTO ttq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wala a ihogan iwat-tu angalos n Ǝmǝli fǝlas igi a iga iman-net daɣ adag ǝn Mǝššina, wǝr iga y Ǝmǝli adkul wa dǝr ihor; tǝzzar ǝtšanat-tu tǝwakkawen, aba-tu. ");
INSERT INTO ttq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Awal ǝn Mǝššina ǝnta, igla itiwǝzǝwiz, tigatan aytedan win sǝr ǝzzǝgzannen. ");
INSERT INTO ttq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Amaran Barnabas ǝd Talut as ǝɣradan ǝššǝɣǝl wa tan-d-ewayan s ǝɣrǝm ǝn Yerusalam, ǝqqalan s as d-ǝhan, ǝddewan ǝd Yaxya was itawannu Markus. ");
INSERT INTO ttq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ǝlkǝnisat ta tǝhat aɣrǝm n Antǝyoxǝya ǝhân-tat ǝnnǝbitan ǝd mǝsǝssǝɣra ǝmosnen Barnabas ǝd Simɣon was itawannu \"Akawel\" ǝd Luqǝyus wa n akal ǝn Qǝrwan ǝd Manahin wa inamadwalan d ǝmǝnokal Herod daɣ ahan iyyanda amaran ǝd Talut. ");
INSERT INTO ttq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ǝzǝl iyyan ad ǝmminayan ǝɣbâdan Ǝmǝli ǝzuman deɣ, inn-asan Infas wa Zǝddigan: «Sǝwǝrat-i Barnabas ǝd Talut aganna fǝl ad agin ǝššǝɣǝl was tan-d-ǝɣreɣ.» ");
INSERT INTO ttq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ǝzuman ǝgan šiwatriwen tǝzzar, amaran ǝssǝwaran Barnabas ǝd Talut ifassan-nasan ǝgan-asan šiwatriwen, dǝffǝr adi ǝssǝglan-tan. ");
INSERT INTO ttq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Issoka Infas wa Zǝddigan Barnabas ǝd Talut aɣrǝm ǝn Salukǝya. Ǝggazan daɣ-as aɣlal n aman ǝkkan akal imosan gǝrwǝtlan as itawannu Qibrus. ");
INSERT INTO ttq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","As osan aɣrǝm ǝn Salamin, ad ǝmmâlan awal ǝn Mǝššina daɣ nan n ǝlɣibada win Kǝl-Ǝlyǝhud. Iddew dǝr-san Yaxya was itawannu Markus. Illil-asan idhâl-tan. ");
INSERT INTO ttq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ǝrzagan Qibrus, sannaqqaban-tu har osan aɣrǝm ǝn Bafus. Den da ad ǝmmǝnayan d alǝs iyyan ǝn Kǝl-Ǝlyǝhud igân esǝm Bar-Ɣaysa n amaššaɣaw, igannin ǝnta ǝnnǝbi. ");
INSERT INTO ttq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amaran osâɣ ǝd Sarjǝyus Bulǝs wa n ǝnaxkim n akal, imosan awedan ilân ǝgǝrri. Issǝgmay ǝmuzar wa Barnabas ǝd Talut fǝlas ikna ǝsǝnnǝhǝl ǝn tara n ad aslu y awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mišan inkar Elǝymas wa n amaššaɣaw – awen da a imosan almaɣna n esǝm-net daɣ tǝlyunant – iqqal ǝllid-nasan, ad igammay d ad igdǝl y ǝnaxkim wen ǝzǝgzan. ");
INSERT INTO ttq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tǝzzar ijajjanɣal daɣ-as Talut, as itawannu deɣ Bulǝs, igrâwan s igǝt Infas wa Zǝddigan, ");
INSERT INTO ttq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","inn-as: «Agg Aššaytan, azangaw n arat kul wa oɣadan. Wǝr t-illa ǝzzǝnǝf ǝn tǝkǝrras a kay-wǝr-nǝha, ǝmǝkkerrǝs n ǝnallabus a tǝmosaɣ. Ǝmmay ad za tammazzayaɣ d agamay n ǝsǝfrǝɣ ǝn tarrayt toɣâdat n Ǝmǝli Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ǝmǝrǝdda ǝnǝy, a fall-ak assansu Ǝmǝli ǝfus-net, taddarɣala. Ad tagaɣ azzaman wǝr tǝlesaɣ anay n ǝnnur ǝn tǝfuk.» Tamazayt ten da a fall-as ǝganat šiyyay, idalammat fall-as amaḍal, tǝzzar ad iddâz, igammay i t-ilwayan. ");
INSERT INTO ttq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","As inay ǝnaxkim wen awa igan den, izzǝgzan. Isimaklal sǝr-ǝs ǝsǝssǝɣri was isla daɣ batu n Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iggaz Bulǝs aɣlal n aman ǝnta ǝd midawan-net daɣ Bafus, ǝkkan aɣrǝm ǝn Bǝrge ihân akal ǝn Banfilǝya. Den da a dǝr-san immǝzzay Yaxya was itawannu Markus, iqqal Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ǝntanay amaran ǝgmadan Bǝrge, ǝkkan aɣrǝm n Antǝyoxǝya wa n akal ǝn Bissidǝya. As iga ǝzǝl wa n tǝsanfawt, ǝggazan ehan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, ǝqqiman. ");
INSERT INTO ttq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","As tawaɣran daggan daɣ Ǝttǝwret d Ǝlkǝttaban win Ǝnnǝbitan sa hadan, ǝnnan-asan-in muzaran n ahan n ǝlɣibada wen: «Imǝdrayan-nana, kud tǝll-ay batu as za tǝsǝssuhet ǝzǝgzan n aytedan, tagim-tat.» ");
INSERT INTO ttq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ibdad Bulǝs, isaddagan-asan s ǝfus-net ad affastin, amaran inna: «Meddan win Kǝl-Israyil ǝd kawanay win miksadan ǝn Mǝššina, sǝsǝmat-i! ");
INSERT INTO ttq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mǝššina di n Ǝmǝli ǝn tamattay ta da n Israyil a isannafranan imarawan-nana, tǝzzar issǝgat-tan daɣ elan win daɣ ǝmosan inaftaɣan daɣ akal ǝn Masar, dǝffǝr adi ikkas-tan-du daɣ-as ǝs tarna n ǝfus-net. ");
INSERT INTO ttq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Iga edag n ǝkkozat tǝmǝrwen n awatay, šin ǝgan daɣ taneray, izizaydar dǝr-san. ");
INSERT INTO ttq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ikf-en as ǝrzan ǝssayat tawšeten daɣ akal ǝn Kanan, ikf-en akal-nasan, iggaz tǝkasit-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Awen ketnet, edag n ǝkkozat tǝmad n awatay ǝd sǝmmosat tǝmǝrwen a daɣ iga. Dǝffǝr awen a dasan-izuzir ǝlqalitan taqqalan-asan imǝnokalan har azzaman n ǝnnǝbi Samǝwel. ");
INSERT INTO ttq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Azzaman en da a daɣ ǝgmayan ǝmǝnokal, tǝzzar ikf-en Mǝššina Talut ag Kiš wa n tawšet ta n Benyamin. Iga ǝkkozat tǝmǝrwen n awatay ixkâm fall-asan. ");
INSERT INTO ttq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dǝffǝr adi ikkas-tu Mǝššina da taɣmar, iga Dawǝd daɣ adag-net s ǝnta a fǝl inna Mǝššina: \"Ǝgrawa Dawǝd ag Yasay, imosan alǝs ilkâman i tara-nin, wa zʼammazalan ǝs tara-nin ketnet.\" ");
INSERT INTO ttq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ihayawan-net a daɣ d-ikkas Mǝššina Ɣaysa s ǝnta a imosan Ǝmaɣlas was iga arkawal-net i Kǝl-Israyil. ");
INSERT INTO ttq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Dat assa-net ad iga Yaxya i tamattay n Israyil ketnet isalan ǝmosnen ad utaban, tǝwǝsǝlmǝɣan daɣ aman, assaknu adi tǝtubt-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","As ibuk Yaxya y ǝsǝndi n ǝššǝɣǝl-net, ad igannu: \"Ma tǝɣilam, ma ǝmosaɣ? Wǝr ǝmosaɣ za awedan was tǝɣilam. Kala, kala! Ilkâm-i-du, nak wǝr ǝweda wala arra ǝn suɣan ǝn ɣateman-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Imǝdrayan-in kawanay win hayawan n Ibrahim ǝd kawanay win wǝr nǝmos Kǝl-Ǝlyǝhud tǝksudam Mǝššina, isalan n ǝlɣillas wa, nakkanay as tan-d-issoka Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Amaran aytedan ǝn Yerusalam ǝd muzaran-nasan wǝr ǝgren awa imos Ɣaysa, wǝr ǝgren deɣ wala daɣ awa ǝnnan ǝnnǝbitan daɣ Ǝlkǝttaban win tawaɣrinen akk ǝzǝl wa n tǝsanfawt daɣ nan n ǝlɣibada, ǝssǝndan awa ǝnnan ǝnnǝbitan win di s abbaz wa t-ǝgan s ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wǝr ǝgrewan arat waliyyan a t-issiwaran tamattant, mišan harkid awen, ǝgmayan daɣ Bilatǝs a daɣ-as tǝwǝkkǝsan man. ");
INSERT INTO ttq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","As ǝssǝndan arat kul awa fall-as ǝnnan Ǝlkǝttaban, ǝkkasan-t-idu fǝl tǝgǝttawt, ǝgan-tu daɣ ǝzǝkka. ");
INSERT INTO ttq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mišan issǝnkar-t-idu Mǝššina daɣ tamattant. ");
INSERT INTO ttq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iga adan aggotnen itinǝfilil y aytedan win dǝr-ǝs d-ǝddawnen daɣ akal ǝn Galilaya ǝgǝzzayyan s ǝɣrǝm ǝn Yerusalam. Ǝntanay a ǝmosnen ǝmǝrǝdda šigǝyyawen-net ɣur tamattay n Israyil. ");
INSERT INTO ttq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Amaran nakkanay da, nǝtagg-awan isalan n Ǝlinjil, ǝmosnen isalan win as itawagga arkawal-nasan i marawan-nana. ");
INSERT INTO ttq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Arkawal wen issǝnd-anaq-qu Mǝššina nakkanay win hayawan-nasan s ǝsǝnkǝr wa d-iga Ɣaysa s ǝmmǝk was iktab daɣ tǝsarnat ta n sanatat n Azzabur, as inna daɣ salan ǝn Ɣaysa: \"Kay Barar-in, ǝqqalaɣ azalada Abba-nak.\" ");
INSERT INTO ttq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ǝsǝnkǝr wa t-id-iga Mǝššina daɣ tamattant, da wǝr tǝrḳa tǝɣǝssa-net daɣ ǝzǝkka imâl-tu Mǝššina daɣ Ǝlkǝttaban ǝs tǝmǝwit ta, as inna: \"A kawan-akfa arraxmaten zaddognen, ǝtiddanen šin as ǝgeɣ arkawal-nasnat i Dawǝd.\" ");
INSERT INTO ttq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iktâb deɣ as: \"Wǝr za tayya Ǝmizdag-nak arḳu daɣ ǝzǝkka.\" ");
INSERT INTO ttq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawǝd amaran, dǝffǝr as immozal daɣ azzaman-net s aratan win ixtas Mǝššina, aba-tu, itawanbal dǝgma ǝn marawan-net, tǝrḳa tǝɣǝssa-net; ");
INSERT INTO ttq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","mišan Ɣaysa, ǝnta a d-issǝnkar Mǝššina daɣ tamattant, wǝr tǝrḳa tǝɣǝssa-net. ");
INSERT INTO ttq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Daɣ adi imǝdrayan-in ǝssǝnat as tǝsureft ǝn bakkadan, tǝttimal-awan ǝs tarrayt-net; amaran i sǝr-ǝs izzǝgzanan ad igrǝw tǝdarfit daɣ aratan kul win as wǝr ifreg tǝdarfit daɣ-san ǝs tarrayt ta n lǝkkum y ǝššǝriɣa wa d-izzǝbben fǝl ǝnnǝbi Musa. ");
INSERT INTO ttq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Adi a fǝl za tǝnkǝdam y a kawan-igrǝw awa ǝmalan ǝnnǝbitan, as ǝnnan: ");
INSERT INTO ttq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"Ǝnǝyat kawanay win nujaban; sǝmmǝklǝlat, tǝhlǝkam; fǝlas ad ammazala arat daɣ azzaman-nawan, as kud dawan-iga awedan isalan-net kul da, wǝr das-za-tǝzzǝgzǝnam.\"» ");
INSERT INTO ttq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Igammad Bulǝs ǝd Barnabas as daɣ-san ǝgmayan aytedan ad d-ǝlǝsan tewaɣlay ǝzǝl ǝn tǝsanfawt wa d-izayan fǝl a dasan-ǝššitin daɣ igi ǝn salan win den. ");
INSERT INTO ttq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","As tǝwazawaz ǝljǝmaɣat, ǝddewan Kǝl-Ǝlyǝhud aggotnen d aytedan wiyyad ad d-ǝhdânen s ǝddin wa n Kǝl-Ǝlyǝhud ǝd Bulǝs ǝd Barnabas. Mašawalan dǝr-san, gammayan daɣ-san ad zǝzzǝwen daɣ arraxmat ǝn Mǝššina ta ǝgrawan. ");
INSERT INTO ttq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","As d-iɣlay ǝzǝl wa n tǝsanfawt, tǝddew-du taššam n ǝɣrǝm ketnet y ad issǝsǝm y awal n Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","As ǝnayan Kǝl-Ǝlyǝhud igǝt ǝn tamattay, ǝggaznat-tan tǝsmiten labasnen, ad sabahawan Bulǝs, rabbadan-tu. ");
INSERT INTO ttq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tǝzzar inn-asan Bulǝs ǝd Barnabas wǝr tǝha tasa ǝn wala: «Kawanay a iddǝraran s a dawan-attamal awal ǝn Mǝššina ǝs tizarat, mišan dad zamas tugayam sǝr-ǝs, wǝr tǝssǝharam iman-nawan ǝd tǝmǝddurt ta tǝɣlalat, wǝdi ad nǝmǝlǝllǝy s aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Fǝlas awen da as danaɣ-omar Ǝmǝli Mǝššina s ǝmmǝk was inna daɣ Ǝlkǝttaban as ǝnnan: \"Ǝgeq-qay ǝnnur i tawšeten šin wǝr nǝmos Kǝl-Ǝlyǝhud fǝl ad tawǝyaɣ isalan n ǝlɣillas har d a du-tǝraz ǝddǝnet.\"» ");
INSERT INTO ttq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","As ǝslan aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud y awen, ǝddǝwen, ǝzzǝzwǝran awal n Ǝmǝli Mǝššina, ǝzzǝgzanan aytedan kul win as itawatas ad ǝgrǝwan tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ad itiwǝziwiz awal n Ǝmǝli daɣ akal ketnet. ");
INSERT INTO ttq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mišan ǝnkaran Kǝl-Ǝlyǝhud ǝgan ark-man daɣ tǝdoden šiyyad tiwasaɣmarnen ǝhânen ǝddin ǝn Kǝl-Ǝlyǝhud ǝd muzaran n ǝɣrǝm, ewayan-du ǝs Bulǝs ǝd Barnabas ǝtǝwǝdgaz labasan, tǝzzar ǝstaɣan-tan, ǝkkasan-tan daɣ akal-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ǝbbǝkbakan aboqqa ǝn daran-nasan daɣ batu n ǝɣrǝm wen, tǝzzar ǝkkan aɣrǝm wa n Ikonǝyum. ");
INSERT INTO ttq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Inalkiman ǝn Ɣaysa win d-oyyan dǝffǝr-san daɣ Antǝyoxǝya amaran, ǝknân tǝfalawist, idnay-tan deɣ Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iga Bulǝs ǝd Barnabas daɣ ǝɣrǝm n Ikonǝyum arat wa da taggin fawda, a t-imosan iguz n ahan n ǝlɣibada ǝn Kǝl-Ǝlyǝhud; tǝzzar ǝgan daɣ-as awal a d-ewayan as ǝzzǝgzanan aytedan aggotnen daɣ Kǝl-Ǝlyǝhud ǝd Kǝl-Ǝlyunan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mišan ǝnkaran Kǝl-Ǝlyǝhud win ugaynen s ǝzǝgzan ǝs Ɣaysa, ǝgan daɣ aytedan win hadatnen wǝr nǝmos Kǝl-Ǝlyǝhud ark-man ǝs mǝzzǝgzan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Harkid awen iga Bulǝs ǝd Barnabas tamert tagget daɣ Ikonǝyum. Taggin awal a daq-qan wǝr tǝha tasa, tagayyen fǝl Ǝmǝli. Ikf-en Ǝmǝli fǝrregat n igi ǝn tǝlmǝɣjujaten ǝmosnen alɣalamaten d aratan simaklalnen sataddinen tidǝt a mosan salan win ǝqqalnen arraxmat-net. ");
INSERT INTO ttq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mišan tǝzun tamattay n ǝɣrǝm. Wiyyad ǝwaran aganna wa n Kǝl-Ǝlyǝhud, wiyyad aganna wa n nǝmmuzal. ");
INSERT INTO ttq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ǝnkaran aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud ǝd Kǝl-Ǝlyǝhud ǝd muzaran-nasan sammarkasan ad agin taršǝxšad labasnen i Bulǝs ǝd Barnabas, anɣin-tan kǝrǝz ǝs tǝgur ǝn tǝhun. ");
INSERT INTO ttq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","As isla Bulǝs ǝd Barnabas awen, ǝgmadan aɣrǝm wen, ǝkkan Lustra ǝd Derbe ǝmosnen iɣǝrman n akal wa n Lukawnǝya ǝd kallan win tan-ǝɣlaynen, ");
INSERT INTO ttq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","a daɣ-san ǝmmalan isalan n Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Aɣrǝm ǝn Lustra ih-ay alǝs n anabdon s as d-ihǝw da, ǝmmutan daran-net, wǝr kala tǝwer takkolt-net amaḍal. ");
INSERT INTO ttq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","As ǝzǝl iyyan ad issisam i Bulǝs iššewal, idak-ku Bulǝs s asawad, inay daɣ-as as, ila ǝzǝgzan a t-izzozayan; ");
INSERT INTO ttq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","tǝzzar inn-as s afalla: «Ǝnkǝr, taɣǝda tebadday-nak!» Iggad alǝs, iggaz šin teklay. ");
INSERT INTO ttq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","As tǝnay tamattay tǝgget awa iga Bulǝs den, ad gannin aytedan s afalla daɣ awal wa n tǝlukawnǝysat: «Imalan ǝhânen šaššelan an aytedan, a fall-ana d-ǝzzǝbbatnen.» ");
INSERT INTO ttq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ǝgan i Barnabas esǝm n iyyan daɣ ǝssǝnaman-nasan as gannin «Zus», Bulǝs ǝgan-as esǝm n iyyan as gannin «Hǝrmes» fǝlas ǝnta a imosan ǝmǝššewǝl. ");
INSERT INTO ttq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Inkar ǝlimam n ǝssǝnǝm wa igan «Zus» âs ehan n ǝlɣibada-net iha imi n ǝɣrǝm, isassalway-du ǝs mawan n ǝɣrǝm izǝgran ǝd tǝtǝltǝla ǝn tǝjigay, ira ǝnta ǝd tamattay tagget a tan-agin šizǝgzam i Bulǝs ǝd Barnabas. ");
INSERT INTO ttq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mišan as ǝslan nǝmmuzal win ǝganen Barnabas ǝd Bulǝs awen, zazzarren šikadkaden-nasan fǝl man-nasan, ozalan ǝs tamattay tǝgget ǝdkâlan imaslan-nasan s afalla gannin: ");
INSERT INTO ttq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Xa meddan! Ma tǝtaggim da? Nakkanay wǝr nǝmos ar aytedan ǝn šilaten-nawan. Isalan n Ǝlinjil a dawan-du-neway fǝl ad tammazzayam d ǝlɣibada n ǝssǝnǝman, tutabam ǝs Mǝššina di n Amaɣlol a d-ixlakan ijǝnnawan d amaḍal ǝd gǝrwan d awa tan-ihan kul. ");
INSERT INTO ttq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Daɣ elan win ǝrǝwnen, oyya šimattiwen kul, ǝlkamnat i tara ǝn man-nasnat. ");
INSERT INTO ttq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mišan dǝr iga awen da ya, iga i man-net tǝgǝyya id issǝkna ǝlluɣ-net imosan: ǝsufǝy wa dawan-d-itaggu akonak daɣ jǝnnawan, ihakk-iwan šimeren olaɣnen ǝd sudar, isifǝliwis-kawan.» ");
INSERT INTO ttq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Gǝrrid as sahhadarren aytedan ǝs batu ta ǝgan den, ǝgdalan-asan a dasan-agin šinagzamen. ");
INSERT INTO ttq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Osan-du Kǝl-Ǝlyǝhud wiyyad a d-ǝfalnen aɣrǝm n Antǝyoxǝya ǝd wa n Ikonǝyum, ǝššewalan y aytedan har tan-ǝssǝwaran aganna wa-nasan. Ad ǝggaran Bulǝs ǝs tǝhun, dǝffǝr adi zarorawan-tu har dǝr-ǝs ǝgmadan aɣrǝm, ǝɣilan aba-tu. ");
INSERT INTO ttq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mišan as sǝr-ǝs d-ǝddewan nalkiman ǝn Ɣaysa, ɣalayɣalayan-tu, ibdad-du iqqal aɣrǝm. As affaw, iddew ǝd Barnabas ǝkkan aɣrǝm ǝn Derbe. ");
INSERT INTO ttq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","As ǝmalan isalan n Ǝlinjil daɣ ǝɣrǝm wen, ǝlkaman aytedan aggotnen i Ɣaysa; iqqal Bulǝs ǝd Barnabas aɣrǝm ǝn Lustra ǝd wa n Ikonǝyum ǝd wa n Antǝyoxǝya, ");
INSERT INTO ttq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ad gammayan daɣ nalkiman ǝn Ɣaysa win ɣǝrman win ad zǝzzǝwen daɣ tarrayt-nasan. Šâwalan-asan, talaman-asan fǝl man s ad zǝzzǝwen daɣ ǝzǝgzan-nasan, gannin-asan: «Illikan as, iguz ǝn Taɣmar ta n Mǝššina, iddew ǝd tǝssust tagget.» ");
INSERT INTO ttq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ǝkkulluk n Ǝlkǝnisat sinafranan-as imuzaran, ǝššedawan awen ǝd tǝwatriwen d ǝzum, amaran agin-tan daɣ tǝɣlift ǝn Mǝššina di as ǝzzǝgzanan. ");
INSERT INTO ttq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dǝffǝr awen ǝrzagan akal wa n Bissidǝya, okayan ǝs wa n Banfilǝya. ");
INSERT INTO ttq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ǝmalan isalan n Ǝlinjil daɣ ǝɣrǝm wa n Bǝrge, amaran ǝrasan ǝs wa n Attalǝya. ");
INSERT INTO ttq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ǝggazan aɣlal n aman daɣ Attalǝya, ǝnnǝmadan Antǝyoxǝya, aɣrǝm was ǝnta as kala daɣ-as tawaggan daɣ tǝɣlift ǝn Mǝššina y ǝššǝɣǝl wa ǝssǝndan den. ");
INSERT INTO ttq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","As din-osan, sassaɣran-du aytedan kul n Ǝlkǝnisat, tǝzzar ǝssoɣalan-asan isalan n arat kul was tan-ikfa Mǝššina turagat n igi-net, d ǝmmǝk was olam Mǝššina tarrayt n ǝzǝgzan i tǝmattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Dǝffǝr awen ǝmalan ɣur nalkiman win den har ǝgan tamert tagget. ");
INSERT INTO ttq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Osan-du meddan wiyyad a d-ǝgmadnen akal ǝn Yahudǝyya aɣrǝm n Antǝyoxǝya ad sasaɣrin inalkiman ǝn Ɣaysa, gannin-asan: «As wǝr tǝlkemam y alɣadat n ǝmǝnkǝd ta d-oyya ǝnnǝbi Musa, wǝr za tǝgrǝwam ǝlɣillas.» ");
INSERT INTO ttq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wǝr irḍa Bulǝs ǝd Barnabas ǝs batu ten, eway-du awen tamazaq labasat gar-essan ǝd Bulǝs ǝd Barnabas. Tǝzzar tǝtawagga tanat n ad aggazzay Bulǝs ǝd Barnabas ǝd nalkiman ǝn Ɣaysa wiyyad ǝs Yerusalam fǝl ad ǝnǝyan inǝmmuzal ǝd muzaran n Ǝlkǝnisat daɣ batu ten. ");
INSERT INTO ttq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tǝkf-en Ǝlkǝnisat ta n Antǝyoxǝya arat kul was ǝddǝraran, amaran ǝglan. Ǝrzagan akal wa n Fenisǝya ǝd wa n Samarǝya suɣulan isalan kul ǝn tǝtubt ta d-ǝganat tǝmattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud ǝs Mǝššina. Isifilawas awen wǝllen inalkiman kul win kallan en. ");
INSERT INTO ttq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","As osan Yerusalam tǝg-asan Ǝlkǝnisat ketnet marxaba ǝd nǝmmuzal ǝd muzaran. Tǝzzar ǝgan daɣ-san isalan n arat kul was tan-ikfa Mǝššina igi-net. ");
INSERT INTO ttq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mišan ǝggadan-du meddan wiyyad ǝn nalkiman ǝn Ɣaysa ǝhanen taggayt ta n Farisaytan ǝnnan: «Ǝmǝnkǝd ǝd lǝkkum y ǝlqanun wa n ǝnnǝbi Musa fǝrǝḍ a imos fǝl aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud.» ");
INSERT INTO ttq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tǝzzar ǝmmǝnayan nǝmmuzal ǝd muzaran n Ǝlkǝnisat fǝl ad ǝssǝnan awa zʼagin daɣ batu ten. ");
INSERT INTO ttq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","As ǝrǝwan ǝmmizaɣan, ibdad Butros inn-asan: «Imǝdrayan-in, tǝssânam as irǝw as di-isannafran daɣ-wan Mǝššina fǝl ad aslin aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud isalan n Ǝlinjil daɣ imi-nin, ǝzzǝgzǝnan ǝs Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mǝššina issânan awa ihan ǝwǝl n awedan kul, issikna tǝrǝddawt ta sǝr-san iga ǝs tǝhakkay ta tan-iga Infas wa Zǝddigan ǝs tǝmǝwit tas dana-t-ikfa nakkanay win Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wǝr danaɣ-izannamazlay dǝr-san fǝlas Mǝššina a izazdagan iwallan s ǝzǝgzan sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Daɣ adi ǝmǝrǝdda ma fel tǝtaggim tǝnagmayt i Mǝššina s igi wa tǝtaggim fǝl rawan ǝn nalkiman ǝzuk ǝs wǝrmad ǝfrâgan marawan-nana adakal-net wala deɣ nǝfrâk-ku nakkanay? ");
INSERT INTO ttq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wǝrgeɣ arraxmat n Ǝmǝli Ɣaysa as nǝzzǝgzan, tǝssǝfs-ana? Ǝntanay da za, ǝntanay win wǝr nǝmos Kǝl-Ǝlyǝhud, tǝmǝwit ta da as ǝfsan!» ");
INSERT INTO ttq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tǝzzar tǝffǝsta tamattay ketnet, ǝssǝsaman aytedan i Barnabas ǝd Bulǝs suɣulan isalan kul ǝn tǝlmǝɣjujaten ǝmosnen alɣalamaten d aratan simaklalnen win as tan-ikfa Mǝššina igi-nasan daɣ tǝmattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","As iffǝsta Barnabas ǝd Bulǝs, iššewal Yaqub, inna: «Imǝdrayan-in, sǝsǝmat-i. ");
INSERT INTO ttq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɣon Butros issôɣal-ana tǝmǝwit tas issǝnta Mǝššina harwa daɣ tizarat ǝsǝkni ǝn tara ta iga i tǝmattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud s ǝsǝnnǝfrǝn wa daɣ-asnat iga aytedan as zʼǝqqǝlnen tamattay-net. ");
INSERT INTO ttq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Amaran inimannak awen d awa ǝnnan ǝnnǝbitan daɣ Ǝlkǝttaban as ǝnnan: ");
INSERT INTO ttq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"Ad d-ǝqqǝla dǝffǝr awa, ǝlǝsaɣ i Dawǝd akaras n ahan-net ibirajjen, ǝkrǝsaɣ imǝggulaz-net, ǝssǝbdǝdaq-qu, ");
INSERT INTO ttq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","fǝl ad ǝgmǝyan aytedan win d-ǝqqimnen Ǝmǝli. Awalla šimattiwen kul šin wǝr nǝmos Kǝl-Ǝlyǝhud, ad ǝqqǝlnat tamattay-nin, ǝɣbadnat-i. Adi a inna Ǝmǝli wa igan aratan di kul\", ");
INSERT INTO ttq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","fǝl tǝga masnat harwa irǝw. ");
INSERT INTO ttq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Awen da fǝlas nak Yaqub, ǝrḍêɣ s ad nayyu ǝsǝmmǝɣitǝr n aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud win du-tutabnen ǝs Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mišan ǝktǝbatana y-asan širawt, nann-asan ad ammazzayan d ǝsǝmmǝdǝs ǝn man-nasan s arat ad d-immâran ǝssǝnǝm, ammazzayan d igi n ǝzzǝna ǝd tattay ǝn ṣan n ǝmudar tǝnɣa tarzam ǝd tǝssay n ǝzni. ");
INSERT INTO ttq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Fǝlas irǝw ad t-ǝmalan ǝlfǝqqitan sasaɣrinen Ǝttawret daɣ ǝkkulluk n ǝɣrǝm, itawaɣru deɣ akk ǝzǝl ǝn tǝsanfawt daɣ nan ǝn Kǝl-Ǝlyǝhud win ǝlɣibada.» ");
INSERT INTO ttq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tǝzzar ǝrḍan nǝmmuzal ǝd muzaran d Ǝlkǝnisat ketnet s ad sǝnnǝfrǝnan wiyyad daɣ-san, zǝmmizǝlan-tan s ǝɣrǝm n Antǝyoxǝya, idawan ǝd Bulǝs ǝd Barnabas. Sannafranan Yahuza was itawannu Barsabbas ǝd Silas, ǝmosnen imuzaran daɣ mǝzzǝgzan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ǝssǝwaran-tan ad awǝyan širawt s ǝnta da awa daɣ-as ǝktaban: «Awa nakkanay inǝmmuzal ǝd muzaran ǝn nalkiman ǝn Ɣaysa win mǝdrayan-nawan. Nǝhul-in imǝdrayan-nana win wǝr nǝmos Kǝl-Ǝlyǝhud, win ǝhanen aɣrǝm n Antǝyoxǝya ǝd win ǝhanen akal ǝn Surǝya ǝd wa n Kilikǝya. ");
INSERT INTO ttq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nǝslâ assa wa kawan-in-ǝgan meddan danaɣ-in-ǝfalnen ši wala turagat-nana, ǝɣšadan iman-nawan, ǝššǝwašan-kawan s awa gannin. ");
INSERT INTO ttq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Adi a fǝl nǝnamannak ketnana, nǝga tanat ad nǝsǝnnǝfrǝn meddan, nǝzǝmmizǝl-tan-in sǝr-wan, idawan-in ǝd maran-nana Barnabas ǝd Bulǝs, ");
INSERT INTO ttq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ǝmosnen meddan ǝgânen iman-nasan daɣ alɣarar fǝl ǝddǝlil n esǝm n Ǝmǝli-nana Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Adi da fǝl din-nǝzammazal Yahuza ǝd Silas fǝl a dawan-ǝlǝsan ǝsuɣǝl ǝn salan win imi s imi. ");
INSERT INTO ttq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Fǝlas issîbdad Infas wa Zǝddigan ǝd nǝkkanay iman-nana tanat n as wǝr kawan-za-nǝssǝwǝr ǝzuk waliyyan ar wa n aratan win ǝwwǝjjabnen, ");
INSERT INTO ttq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ǝmosnen: ad tammazzayam ǝd tattay n amensay itiwakfan y ǝssǝnǝman ǝd tassay n ǝzni ǝd tattay ǝn ṣan n ǝmudar tǝnɣa tarzam d igi n ǝzzǝna. As tǝttafam iman-nawan fǝl igi n aratan win di, ad tagim a olâɣan. Nǝhul-kawan-in wǝllen.» ");
INSERT INTO ttq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dǝffǝr awen tawasallaman, ǝzagadayyan, ǝqqalan Antǝyoxǝya, ewâyan širawt. As din-ewadan ǝššedawan-du inalkiman ǝn Ɣaysa, ǝkfan-tan širawt ten. ");
INSERT INTO ttq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tǝtawaɣra, tǝzzar saddawen-tan salan talamnen fǝl man win ǝgrawen den. ");
INSERT INTO ttq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Amaran iššewal Yahuza ǝd Silas ǝmosnen ǝntanay iman-nasan ǝnnǝbitan ad taggin ǝnnǝsixa aggen i mǝdrayan talaman-asan fǝl man, sisuhen ǝzǝgzan-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","As iga Yahuza ǝd Silas tamert den, ǝssǝllaman-tan mǝdrayan win Antǝyoxǝya fǝl ad ǝqqǝlan Ǝlkǝnisat ta tan-du-tǝzammazalat.  ");
INSERT INTO ttq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mišan issof Silas ad aqqam den da, iqqal âs Yahuza ɣas a iqqalan Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ixsar Bulǝs ǝd Barnabas daɣ Antǝyoxǝya, xattaban ǝntanay ǝd wiyyad imǝdrayan aggotnen y aytedan Ǝlinjil n Ǝmǝli, sasaɣrin-asan-tu deɣ. ");
INSERT INTO ttq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","As ǝgan tamert dǝffǝr awen, inna Bulǝs i Barnabas: «Ǝqqǝlana imǝdrayan-nana daɣ ǝzǝgzan win ǝhanen iɣǝrman kul win daɣ nǝmal awal n Ǝmǝli, ad nǝssǝn awa daɣ-san in-igan.» ");
INSERT INTO ttq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ira Barnabas ad idawan ǝd Yaxya was itawannu Markus. ");
INSERT INTO ttq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mišan inna Bulǝs wǝr ihor ad idawan d alǝs as dat awen a daɣ-san ixtas iman-net daɣ Banfilǝya, wǝr ɣur-san iqqim har sǝkkǝsǝwan ǝššǝɣǝl-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tǝkkus talɣa gar-essan har d-eway awen as ǝmmǝzzayan. Iddew Barnabas ǝd Markus ǝggazan aɣlal n aman ǝkkan Qibrus. ");
INSERT INTO ttq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulǝs ǝnta isannafran Silas, iddew dǝr-ǝs. As t-ǝgan mǝdrayan daɣ tǝɣlift ǝn Mǝššina, igla. ");
INSERT INTO ttq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Illil Bulǝs akal wa n Surǝya ǝd wa n Kilikǝya isisuhit ǝzǝgzan n Ǝlkǝnisaten. ");
INSERT INTO ttq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Osa Bulǝs aɣrǝm ǝn Derbe, as t-ifal ikka wa n Lustra. Amaran Lustra ih-et ǝnalkim ǝn Ɣaysa igân Timotay s anna-net iyyat daɣ Kǝl-Ǝlyǝhud tǝzzigzanat ǝs Ɣaysa, mišan abba-net iyyan daɣ Kǝl-Ǝlyunan. ");
INSERT INTO ttq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ǝmmâlan-tu mǝdrayan daɣ ǝzǝgzan win Lustra d Ikonǝyum ǝlluɣ. ");
INSERT INTO ttq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ira Bulǝs tidawt-net, inkar isammankad-tu fǝl ǝddǝlil ǝn Kǝl-Ǝlyǝhud win ǝhanen akal wen, fǝlas ǝssânan ketnasan as abba-net iyyan daɣ Kǝl-Ǝlyunan a imos. ");
INSERT INTO ttq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aɣrǝm a d-osa Bulǝs ǝd Silas a daɣ-as ǝmǝlan i nalkiman win t-ǝhanen šinaden šin ǝgan nǝmmuzal ǝd muzaran n Ǝlkǝnisat ta n Yerusalam, ǝgmǝyan daɣ-san a dasnat-ǝlkǝman. ");
INSERT INTO ttq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ad itasahat ǝzǝgzan n Ǝlkǝnisaten, tǝyttǝynat akk ǝzǝl. ");
INSERT INTO ttq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Irzag Bulǝs ǝd Silas akal wa n Frijǝya ǝd wa n Galatǝya ǝglan okâyan, fǝlas Infas wa Zǝddigan a dasan-igdalan emel n awal ǝn Mǝššina daɣ akal wa Asǝya. ");
INSERT INTO ttq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","As osan ǝgogas n akal wa n Mǝsǝya, ǝgmayan d iguz n akal wa n Bitinǝya, mišan igdal-asan-tu Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tǝzzar ǝrzagan Mǝsǝya, ǝzagadayyan s ǝɣrǝm wa n Trowas. ");
INSERT INTO ttq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","As iga ahad orga Bulǝs: Inay alǝs iyyan n akal ǝn Masedonǝya ibdâd dǝnnǝg-ǝs, itansay-tu, igann-as: «Akka-du Masedonǝya, tǝdhǝlaɣ-ana.» ");
INSERT INTO ttq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Iga Bulǝs targǝt ten ɣas, nǝsammatag y iki ǝn Masedonǝya fǝlas nǝkkâs aššak as Mǝššina a danaɣ-iɣran fǝl a daɣ-as nǝmǝl isalan n Ǝlinjil. ");
INSERT INTO ttq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nǝggaz aɣlal n aman daɣ Trowas, nǝnnǝmad akal imosan gǝrwǝtlan as itawannu Samotras. As affaw nǝkka aɣrǝm ǝn Neyabolis. ");
INSERT INTO ttq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ǝnta nǝgmad-tu ǝs wa n Filib imosan aɣrǝm fǝl tǝxkâm Ǝrrum; imos deɣ aɣrǝm wa azzaran daɣ akal ǝn Masedonǝya. Nǝga daɣ-as adan. ");
INSERT INTO ttq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","As d-ewad ǝzǝl wa n ǝssǝbǝt, ǝzǝl wa n tǝsanfawt ǝn Kǝl-Ǝlyǝhud, nǝgmad-in aɣrǝm ǝs tǝgadamayt ǝn tǝsǝssǝngǝyt iyyat as norda as, ih-et adag a daɣ taggin Kǝl-Ǝlyǝhud šiwatriwen. Nogaz-in šidoden ǝmminaynen den, tǝzzar nǝqqim, nǝššewal-asnat, nǝg-asnat deɣ tǝlxutbat. ");
INSERT INTO ttq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tǝssǝsam-ana iyyat daɣ-asnat ǝn tǝmiksat ǝn Mǝššina tǝgât esǝm Lidǝya n ǝɣrǝm ǝn Tǝyatir tǝtaggit jola ǝn tǝbǝddaɣ zaggaɣnen hossaynen. Ora Ǝmǝli ǝwǝl-net, tǝga ǝsǝsǝm olâɣan y awa igannu Bulǝs, tǝzzar tǝzzǝgzan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","As tǝtawasalmaɣ daɣ aman ǝnta d aytedan n aɣaywan-net, tonsay-ana, tǝnn-ana: «Zama tǝhannayam as ǝzzigzana s Ǝmǝli, wǝdi akkiwat-du ehan-in tazzabbem daɣ-as.» Tǝgraw-du daɣ-na as nǝrḍa. ");
INSERT INTO ttq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ǝzǝl iyyan nǝkkâ edag ǝn tǝwatriwen wen as nǝmmǝnay ǝd tǝmawat iyyat ǝn tǝklit iha aggǝsuf a das-immalan awa d-izayan, garrawan sǝr-ǝs mǝssawǝs tǝnfa tagget daɣ awen. ");
INSERT INTO ttq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tǝlkam-ana nakkanay ǝd Bulǝs tǝsiɣarat tǝgannu: «Meddan win, eklan ǝn Mǝššina di n Amadkol a ǝmosan. Isalan ǝn tarrayt ta n ǝlɣillas as d-osan y a dawan-tan-agin.» ");
INSERT INTO ttq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tǝga adan aggotnen tǝtaggu awen. Igla Bulǝs har t-išaɣaššašat awen, imalallay-tat-in inna y aggǝsuf wa tat-ihan: «Omaraq-qay ǝs tarna ta tǝhat esǝm ǝn Ɣaysa Ǝlmǝsix, ǝgmǝd-tat!» Tǝzzar igmad-tat aggǝsuf daɣ tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","As ǝnayan mǝssawǝs as ab-as sǝr-san tat-du-tǝgammad tǝnfa, ǝbazan Bulǝs ǝd Silas, ǝlwayan-tan s asammanay n ǝɣrǝm, ǝssǝbdadan-tan dat naxkiman. ");
INSERT INTO ttq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ǝnnan i naxkiman: «Meddan win jannajarwayan aɣrǝm-nana. Kǝl-Ǝlyǝhud a ǝmosan, ");
INSERT INTO ttq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","sasaɣrinen aytedan alɣadaten as nakkanay Kǝl-Ǝrrum wǝr nǝla turagat ǝn tǝrǝddawt sǝr-ǝsnat wala lǝkkum y-asnat.» ");
INSERT INTO ttq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tǝnkar tamattay ǝnta da tǝzzan ǝs Bulǝs ǝd Silas. Ǝnnan naxkiman a fall-asan tǝwǝzǝzǝrren sǝlsa, omaran s a dasan-tǝwǝgginat tǝwit. ");
INSERT INTO ttq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","As tan-ǝyyǝwanan šiwwit, ǝgaran-tan daɣ kasaw, omaran ǝmuzar ǝn kasaw s a dasan-agu aggaz olâɣan. ");
INSERT INTO ttq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ǝmuzar ǝn kasaw deɣ as das-itawanna awen, inkar ig-en daɣ adangaya ǝn kasaw, inday idaran-nasan daɣ šilǝlt. ");
INSERT INTO ttq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","As isaggaraygaray ahad, ad itattar Bulǝs ǝd Silas sihaken imaslan-nasan taggin deɣ tǝmmalen i Mǝššina, ǝssisaman-asan mǝskǝsa win hadatnen. ");
INSERT INTO ttq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wala a ihogan iga amaḍal ǝnǝgǝynǝgǝy s awa iga daɣ assahat har inagaynagay ahan ǝn kasaw ketnet, ǝnnolamnat tǝsǝhar ǝn kasaw kul tamazayt ten da, zalabben sassaran daɣ mǝskǝsa kul. ");
INSERT INTO ttq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Inkar-du ǝmuzar n ahan ǝn kasaw daɣ etǝs. As inay šisǝhar ǝn kasaw ǝnnolamnat, ilbay-du takoba-net y sǝr-ǝs anɣu iman-net fǝlas a iɣil imǝskǝsa ǝddǝggagan. ");
INSERT INTO ttq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mišan isaɣarat-as Bulǝs inn-as: «Ad wǝr tanɣaɣ iman-nak, ketnana nǝlla da.» ");
INSERT INTO ttq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Inna ǝmuzar ǝn kasaw ad d-ammawaynat fǝtǝlaten, iggaz ammas ǝn kasaw tarmad igla har ewad adangaya-net tǝndaw-tu taysǝst har issǝjad i Bulǝs ǝd Silas. ");
INSERT INTO ttq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tǝzzar ikkas-tan-du inn-asan: «Meddan, mas di-iwar igi-net ǝgrǝwaɣ ǝlɣillas?» ");
INSERT INTO ttq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ǝnnan-as: «Zǝgzǝn s Ǝmǝli Ɣaysa ad tǝɣlǝsa kay d aɣaywan-nak.» ");
INSERT INTO ttq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Amaran ǝmalan-as awal n Ǝmǝli ǝnta d aytedan kul n aɣaywan-net. ");
INSERT INTO ttq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eway-tan alwaq wen da adawannay n ahad, iššorad ibusan-nasan. Den da ad itawasalmaɣ daɣ aman, ǝnta d aytedan n aɣaywan-net ketnasan. ");
INSERT INTO ttq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tǝzzar iddew ǝmuzar ǝn kasaw ǝd Bulǝs ǝd Silas s ahan-net, isammagarat-tan. Isidawat-tu wǝllen ǝnta d aɣaywan-net ketnet ǝzǝgzan wa ǝgan ǝs Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","As affaw, zammazalan naxkiman sojitan s ǝmuzar ǝn kasaw y a das-annin ad ikkǝs Bulǝs ǝd Silas. ");
INSERT INTO ttq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Imal ǝmuzar ǝn kasaw ǝmazal wen i Bulǝs, inn-as: «Inaxkiman n ǝɣrǝm ǝnnan-du ad tǝtǝwǝkkǝsam. Daɣ adi ǝgmǝdat, taglim daɣ alxer.» ");
INSERT INTO ttq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mišan inna Bulǝs i sojitan: «A danaɣ-agin šiwwit dat awedan kul da wala ǝššǝriɣa, ǝnta nakkanay nǝmos Kǝl-Ǝrrum; ǝgǝran-ana daɣ kasaw, amaran ǝmǝrǝdda iren a danaɣ-ǝkkǝsan wǝr t-illa i issanan! Kala kala! Asinet-du iman-nasan, ǝkkǝsan-ana.» ");
INSERT INTO ttq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ǝqqalan sojitan ǝssoɣalan batu ten i naxkiman. As ǝslan as Bulǝs ǝd Silas Kǝl-Ǝrrum a ǝmosan, ǝrmaɣan. ");
INSERT INTO ttq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Osan-tan-du a tan-talaɣden, tǝzzar ǝkkasan-tan daɣ kasaw, a daɣ-san gammayan ad ǝgmǝdan aɣrǝm-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ifal Bulǝs ǝd Silas kasaw, ǝkkan ehan ǝn Lidǝya. As ǝmmǝnayan ǝd mǝdrayan daɣ ǝzǝgzan, ǝššewalan-asan, olaman-asan fǝl man, amaran ǝglan. ");
INSERT INTO ttq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Iga Bulǝs ǝd Silas tarrayt ta tǝrzagat Anfibolis d Abollonǝya har din-osan aɣrǝm ǝn Tesalonik a daɣ ǝlân Kǝl-Ǝlyǝhud ehan n ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Os-en-in Bulǝs, awa da itaggu fawda. Iga den karadat ǝssǝbǝten itimǝšiwil ǝd Kǝl-Ǝlyǝhud daɣ salan n awa ǝnnan Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Isassagr-asan-tan, issosan-tan âs, Ǝlmǝsix ilzâm-tu ad aɣɣazzab iba-tu, tǝzzar inkǝr-du daɣ tǝmattant. Igann-asan deɣ: «Ɣaysa wa dawan-ǝmmala da, ǝnta Ǝlmǝsix.» ");
INSERT INTO ttq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ǝzzǝgzanan wiyyad daɣ-san s awa igannu, tǝzzar ǝwaran aganna ǝn Bulǝs ǝd Silas, ǝntanay ǝd Kǝl-Ǝlyunan ǝknanen igǝt ǝn miksadan ǝn Mǝššina ǝd tǝdoden aggotnen ǝlânen esǝm daɣ ǝɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mišan ǝggaznat tǝsmiten labasnen taššam ǝn Kǝl-Ǝlyǝhud, ǝššedawan-du ark aytedan win ǝssuk, ǝqqalan tiddawat tǝzzar jannajarwayan aɣrǝm. Ǝstaban y ahan ǝn Yason gammayan Bulǝs ǝd Silas fǝl a tan-ǝssǝbdǝdan dat aljamaɣat tǝšrǝɣ-asan. ");
INSERT INTO ttq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wǝr ɣur-ǝs tan-ǝgrewan, tǝzzar ǝlwayan Yason ǝnta d arat daɣ mǝdrayan daɣ ǝzǝgzan har tan-ǝssǝbdadan dat naxkiman n ǝɣrǝm, ad gannin s afalla: «Aytedan win, ǝddǝnet ketnet as sǝr-ǝs d-ewayan iba n alxer, ǝmǝrǝdda ǝntanay da. ");
INSERT INTO ttq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Amaran Yason a tan-igan daɣ aɣaywan-net. Ketnasan tamazrayan ǝlqanun n ǝmǝnokal-nana Qaysara fǝlas tǝnna a taggin ill-ay iyyan ǝmǝnokal igân esǝm Ɣaysa.» ");
INSERT INTO ttq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Isalan win den as dasan-tǝsla tamattay ǝd naxkiman n ǝɣrǝm ǝgan aššawaša labasan. ");
INSERT INTO ttq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ǝgan azrǝf daɣ Yason d aytedan win ɣur-ǝs ǝllanen, har t-ǝrzaman as tawayyan. ");
INSERT INTO ttq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tarmad as ǝssokan mǝdrayan daɣ ǝzǝgzan Bulǝs ǝd Silas aɣrǝm ǝn Berawya ahad wenda. As t-in-osan, ǝggazan ehan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ǝssǝknan-tan Kǝl-Ǝlyǝhud win Berawya ǝllǝllu ogaran wa tawasaknan daɣ Tesalonik. Ǝntanay ǝknân ǝlqǝbulat n awal ǝn Mǝššina. Ǝzǝl kul ɣarran Ǝlkǝttaban, tašaggaran kud awa igannu Bulǝs tidǝt a imos wala. ");
INSERT INTO ttq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eway-du awen as ǝzzǝgzanan wiyyad daɣ-san aggotnen, ǝntanay ǝd tǝdoden ǝn Kǝl-Ǝlyunan tiwasaɣmarnen ǝd meddan aggotnen ǝn Kǝl-Ǝlyunan. ");
INSERT INTO ttq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mišan as ǝslan Kǝl-Ǝlyǝhud win Tesalonik as aɣrǝm wa n Berawya ǝnta da immâl daɣ-as Bulǝs awal ǝn Mǝššina, ǝkkan-tu ǝnta da, ǝgan arak man daɣ aytedan, jannajarwayan aɣrǝm. ");
INSERT INTO ttq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Den da ad ǝnkaran nalkiman ǝn Ɣaysa ǝssǝglan Bulǝs, ǝssokan-tu tama n agaraw. Silas ǝd Timotay ǝntanay ǝqqiman-du daɣ Berawya. ");
INSERT INTO ttq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aytedan win mǝššidaw ǝn Bulǝs, ǝddewan dǝr-ǝs har tu-šaššawadan aɣrǝm n Atena, amaran ǝqqalan ewâyan ǝmazal ǝn Bulǝs i Silas ǝd Timotay n as, a das-d-ǝlkǝman tarmâd. ");
INSERT INTO ttq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","A iqqal Bulǝs i midawan-net daɣ ǝɣrǝm n Atena, tamatšin man-net fǝl alham n igǝt wa ǝgan ǝssǝnǝman daɣ ǝɣrǝm wen. ");
INSERT INTO ttq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tǝzzar ad itakku ehan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada itimǝšiwil dǝr-san ǝntanay d aytedan wiyyad ǝn miksadan ǝn Mǝššina, itakku deɣ akk ǝzǝl asammanay n ǝɣrǝm, itimǝšiwil ǝd win dǝr itamanay. ");
INSERT INTO ttq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Itimǝšiwil deɣ Bulǝs ǝd meddan wiyyad ǝn musanan ǝn taggayt ta n Efikurǝyan d Ǝstoyisǝyan. Tamazaɣan dǝr-ǝs wiyyad daɣ-san gannin: «Wa akk tawalaqqat, ma igannu?» Wiyyad gannin: «Ǝs tanna imalan wiyyad wǝr nǝzday as immâl isalan-nasan.» Wǝr tan-isassanna awen ar, a fǝl dasan-immâl Bulǝs isalan n Ǝlinjil, itagg-asan isalan ǝn Ɣaysa ǝd tanakra-net daɣ tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tǝzzar ǝkkan dǝr-ǝs s asaggawar n ǝɣrǝm n Atena as itawannu Aryofagǝs, ǝnnan-as: «Ag-ana isalan ǝn masnat tǝzrâyat ta dǝr du-toseɣ da, ");
INSERT INTO ttq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","fǝlas tǝssislaɣ-ana aratan wǝr nǝzday, as nǝra ad nǝssǝn almaɣna-nasan.» ");
INSERT INTO ttq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ǝntanay Kǝl-Atena kul ǝd naftaɣan win tan-ǝhanen, wǝr ǝgmedan ar s awal d ǝsǝsǝm i salan win d-ǝzraynen. ");
INSERT INTO ttq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ibdad Bulǝs daɣ ammas n Aryofagǝs inna: «Hannaya wǝllen as, kawanay Kǝl-Atena tǝddinam wǝllen, ");
INSERT INTO ttq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","fǝlas ǝssiɣlaya daɣ ǝɣrǝm-nawan, zigazdaɣ idaggan win daɣ tǝɣabbadam imalan-nawan, ǝssiha fadda fǝl adag a daɣ tawakfinat tǝkutawen fǝl iktâb: \"Edag n ǝlɣibada n ǝmǝli wǝr nǝtawassan\". Ǝmǝli wa tǝɣbadam da wǝr tu-tǝssenam, ǝnta as dawan-ǝmmâla isalan-net da. ");
INSERT INTO ttq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mǝššina wa d-ixlakan ǝddǝnet d arat kul wa tat-ihan, ǝnta a imosan Ǝmǝli ǝn jǝnnawan d amaḍal, wǝr ixser daɣ nan n ǝlɣibada ǝkrâsan fassan n aggadǝm, ");
INSERT INTO ttq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","wala iddirar s a ikna aggadǝm fǝlas wǝr iddǝrar ǝs wala. Ǝnta a isuduran, ihakku infas, ihakku arat kul. ");
INSERT INTO ttq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ixlak-du tawšeten n ǝddǝnet kul daɣ awedan iyyanda, y ad ǝxsǝrnat fǝl ǝruru n amaḍal ketnet. Ixtas-asnat azzaman, iga deɣ šizǝraz i kallan win daɣ ǝxsaran. ");
INSERT INTO ttq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Igâ Mǝššina awen fǝl ad t-ǝgmǝyan aytedan kuddeɣ s adez, mijas a t-ǝgrǝwan; kuddeɣ as wǝr danaɣ-iha i iggug, ");
INSERT INTO ttq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","fǝlas ǝnta a ittafan tǝmǝddurt-nana d ǝmǝtǝkwǝy n akk iyyan daɣ-na d awa nǝmos. Adi da a ǝnnan arat daɣ mǝssiway-nawan wiyyad ǝs tǝnna ta ǝgan: \"Awalla, nakkanay da nǝmos bararan-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Daɣ adi dad zamas nǝmos bararan ǝn Mǝššina, wǝr immǝkkan ad narḍu as iha šaššelan n ǝssǝnam igân daɣ urǝɣ, wala azrǝf, wala tǝhunt, a d-inzâm awedan gar-es ǝd man-net. ");
INSERT INTO ttq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ǝljǝhǝl wa ǝgan aytedan daɣ aratan win di, wǝr fall-asan t-ixseb Mǝššina daɣ elan win tǝljuhǝla, mišan ǝmǝrǝdda omar aytedan kul, edag ǝhan, ǝs tǝtubt, ");
INSERT INTO ttq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","fǝlas ilkâm ǝzǝl igâ tǝmastant, wa daɣ zʼagu y ǝddǝnet ketnet ǝššǝriɣa oɣâdan. Isinafran alǝs wa zʼagu daɣ ǝššǝɣǝl wǝdi. Issikna adi y awedan kul s ǝsǝnkǝr wa t-id-iga daɣ tǝmattant.» ");
INSERT INTO ttq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","As ǝslan i Bulǝs iššewal daɣ batu ǝn tanakra daɣ tamattant, ǝgan daɣ-as wiyyad tamakkakkayt, wiyyad amaran ǝnnan-as: «Nǝra a dak-nǝlǝs ǝsǝsǝm daɣ batu tǝdi ǝzǝl iyyan.» ");
INSERT INTO ttq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Den da a tan-ifal Bulǝs, igla. ");
INSERT INTO ttq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dǝr iga awen da osaɣan dǝr-ǝs wiyyad daɣ-san tǝzzar ǝzzǝgzanan. Aytedan win, ih-en Dǝyonusǝyǝs ihân asaggawar wa n Aryofagǝs ǝd tǝntut tǝgât Damaris ǝd wiyyad aytedan. ");
INSERT INTO ttq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dǝffǝr awen igmad Bulǝs aɣrǝm n Atena, ikka wa n Korent. ");
INSERT INTO ttq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Den da ad immǝnay d alǝs ǝn Kǝl-Ǝlyǝhud igân esǝm Akilas n akal ǝn Fontǝs, a d-osân sǝket ifâl-du akal wa n Italǝya ǝnta ǝd hannes Friska; fǝlas ǝmǝnokal Klawdǝyus Qaysara a omaran s ad tǝwǝstǝɣan Kǝl-Ǝlyǝhud kul daɣ ǝɣrǝm n Ǝrrum. Osaɣ dǝr-san Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Amaran dad imos as ola dǝr-san ǝššǝɣǝl – ketnasan ǝššǝɣǝl-nasan igi ǝn hǝktan – imal ɣur-san Bulǝs, išɣal. ");
INSERT INTO ttq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Akk ǝzǝl ǝn tǝsanfawt, itaggu Bulǝs isalan daɣ ahan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada, igammay d ad ǝzzǝgzǝnan Kǝl-Ǝlyǝhud ǝd Kǝl-Ǝlyunan. ");
INSERT INTO ttq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","As d-osa Silas ǝd Timotay Bulǝs ǝfâlan-du Masedonǝya, igmad Bulǝs ǝnta s amel n awal ǝn Mǝššina ɣas, itagayyat i Kǝl-Ǝlyǝhud as Ɣaysa a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mišan ugayan sǝr-ǝs Kǝl-Ǝlyǝhud, a tu-rabbadan. Ibbǝkbak Bulǝs isǝlsa-net, almaɣna abʼas dǝr-san idraw wala. Inn-asan: «Tǝlmanam iman-nawan; iwǝret alxaq-nawan iɣafawan-nawan, nak abʼas di-iwar alxaq n iba n ǝlɣillas-nawan. A obazan ɣur ǝmǝrǝdda aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud a zʼakkaɣ.» ");
INSERT INTO ttq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tǝzzar ifal-tan, iggaz ehan n alǝs igân esǝm Titǝyus Yustus imosan ǝmiksad ǝn Mǝššina as illa ahan-net dǝgma n ahan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krisbǝs wa n ǝmuzar n ahan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada ǝnta izzigzan s Ǝmǝli, ǝnta harkid aytedan n aɣaywan-net kul. Ǝslan Kǝl-Korent aggotnen i salan win itaggu Bulǝs, ǝzzǝgzanan ǝntanay da, tǝzzar tawasalmaɣan daɣ aman. ");
INSERT INTO ttq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","As ahad iyyan iga Bulǝs targǝt a daɣ das-inna Ǝmǝli: «A kay wǝr tǝggǝz tasa, kalar šawal ad wǝr taffasta, ");
INSERT INTO ttq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ǝlleq-qu dǝr-ǝk, wǝr t-illa i zʼifrǝgan a dak-ixšǝd arat, fǝlas ǝleɣ aytedan aggotnen daɣ ǝɣrǝm wa.» ");
INSERT INTO ttq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ixsar Bulǝs daɣ ǝɣrǝm ǝn Korent har iga awatay d aganna, isasaɣru aytedan awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Azzaman win daɣ imos Gallǝyyun ǝnaxkim n akal wa n Akayya, ǝnkaran Kǝl-Ǝlyǝhud ǝgan eɣaf fǝl Bulǝs, ǝbazan-tu, ewayan-tu s adag n ǝššǝriɣa, ");
INSERT INTO ttq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ǝnnan: «Alǝs wa, igammay d ad ǝɣbǝdan aytedan Mǝššina ǝs tǝmǝwit tǝmmizrayat ǝššǝriɣa.» ");
INSERT INTO ttq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","As zama issinta Bulǝs daɣ awal, inna Gallǝyyun i Kǝl-Ǝlyǝhud: «Kawanay Kǝl-Ǝlyǝhud, ǝnnar assa a di-du-tǝgam daɣ batu n arat immizrayan ǝššǝriɣa madeɣ ark amazal labasan, imǝl-tu ǝddǝlil wa fǝl dawan-z-ǝssǝsǝmaɣ; ");
INSERT INTO ttq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","mišan zama awa tamazaq tǝgât fǝl tǝfir d ǝsmawan d ǝššǝriɣa-nawan, ǝšrǝɣat-tan kawanay iman-nawan, nak wǝr areɣ ad ǝqqǝla ǝmašraɣ n aratan zun win di.» ");
INSERT INTO ttq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Amaran isassardaq-qan ehan wa n ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tǝzzar ǝnkaran ketnasan, ǝbazan Sustinǝs wa n ǝmuzar n ahan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada, ad t-ǝggatan da da dat ahan wa n ǝššǝriɣa; mišan wǝr izlay Gallǝyyun daɣ awen. ");
INSERT INTO ttq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Igla Bulǝs ixsâr daɣ ǝɣrǝm ǝn Korent har irǝw. Dǝffǝr adi inamagga ǝd nalkiman ǝn Ɣaysa šiwatriwen, iggaz aɣlal n aman ikka Surǝya, iddew ǝd Friska d Akilas. Harwada wǝr iggez aɣlal n aman daɣ Qankrǝya inimahazan ǝd Korent akku Surǝya ad ilza eɣaf-net y ad assaknu s awen aḍḍawal wa iga. ");
INSERT INTO ttq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","As osan aɣrǝm n Efez, immǝzzay dǝr-san Bulǝs. Igla ǝnta iggaz ehan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada imašawal dǝr-san. ");
INSERT INTO ttq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ǝgmayan daɣ-as a ɣur-san ihag, ugay-asan. ");
INSERT INTO ttq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mišan as tan-ifal inn-asan: «Wǝr immǝkkan a di-wǝr-iga ǝmud wa d-izayan daɣ Yerusalam. A kawan-d-ǝqqǝla kud Mǝššina irḍa.» Igmad Efez iha aɣlal n aman. ");
INSERT INTO ttq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","As izzǝbbat daɣ ǝɣrǝm wa n Qaysarǝya, iggǝzzay, ikka Yerusalam issǝslam Ǝlkǝnisat, dǝffǝr adi izagaday, ikka aɣrǝm n Antǝyoxǝya. ");
INSERT INTO ttq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","As daɣ-as iga tamert, igmad-tu, illil akal wa n Galatǝya ǝd wa n Frijǝya, isisuhit ǝzǝgzan ǝn nalkiman ǝn Ɣaysa kul. ");
INSERT INTO ttq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","As itaggu awen, aɣrǝm n Efez os-ay-du alǝs ǝn Kǝl-Ǝlyǝhud igân esǝm Abbolos n ǝɣrǝm n Alaskandrǝya, imosan alǝs issânan awal wǝllen, igân masnat tagget y Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Itiwasasaɣra tarrayt ta n Ǝmǝli, amaran ikf-ay Infas wa Zǝddigan gǝlleyat daɣ igi ǝn tǝlxutbat, isasaɣru deɣ s ǝlluɣ daɣ batu ǝn Ɣaysa; dǝr iga awen da ya, isalan n ǝsǝlmǝɣ wa itaggu Yaxya aytedan daɣ aman ɣas a t-ǝhanen. ");
INSERT INTO ttq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ad itaggu awal daq-qu wǝr tǝha tasa daɣ ahan ǝn Kǝl-Ǝlyǝhud wa n ǝlɣibada. As das-tǝsla Friska d Akilas, ǝddewan dǝr-ǝs, sassaɣran-tu s ǝlluɣ, ǝššotan-as masnat ta iga tarrayt ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dǝffǝr awen isammarkas Abbolos iki n akal wa n Akayya, tǝzzar ǝdhalan-tu mǝdrayan-net daɣ ǝzǝgzan s awen. Ǝktaban širawt i nalkiman ǝn Ɣaysa win t-ǝhanen fǝl a das-agin tǝmǝwit tolâɣat as tan-in-osa. As din-osa, tǝggaz-tu tǝnfa zǝwwǝrat a du-tǝfâllat arraxmat ǝn Mǝššina y aytedan win ǝzzǝgzannen, ");
INSERT INTO ttq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","fǝlas isabbahaw s assahat dat tamattay iduf wa ǝgan Kǝl-Ǝlyǝhud. Issǝkn-en daɣ Ǝlkǝttaban as, Ɣaysa a imosan Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Azzaman win daɣ iha Abbolos Korent, ad irzag Bulǝs akal n ǝdɣaɣan har iras fǝl aɣrǝm n Efez. Inay daɣ-as inalkiman ǝn Ɣaysa wiyyad, ");
INSERT INTO ttq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","inn-asan: «Awak kawanay, as tǝzzǝgzanam tǝgrâwam Infas wa Zǝddigan?» Ǝnnan-as: «Wǝr nǝsla fadda as t-illa Infas wa Zǝddigan.» ");
INSERT INTO ttq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Inn-asan Bulǝs: «Daɣ adi ma imos ǝzzǝnǝf n ǝsǝlmǝɣ wa tǝtawaggam daɣ aman?» Ǝnnan-as: «Ǝsǝlmǝɣ wa n Yaxya.» ");
INSERT INTO ttq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Amaran inn-asan Bulǝs: «Yaxya, aytedan win ǝtubnen daɣ bakkadan a isalmaɣ daɣ aman, assaknu adi tǝtubt-nasan, immâl-asan ad ǝzzǝgzǝnan ǝs wa du-z-asin dǝffǝr-ǝs, almaɣna Ɣaysa.» ");
INSERT INTO ttq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","As ǝslan y awen, tawasalmaɣan daɣ aman daɣ esǝm n Ǝmǝli Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tǝzzar issǝwar Bulǝs akk iyyan daɣ-san ifassan-net, ǝgrawan deɣ Infas wa Zǝddigan, ǝššewalan daɣ awalan wǝr nǝtawazday, ǝgrawan emel ǝn salan a d-izizabbat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Meddan en, marawessan d ǝššin. ");
INSERT INTO ttq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Amaran ad itakku Bulǝs ehan wa n ǝlɣibada ǝn Kǝl-Ǝlyǝhud, itaggu daɣ-as tǝlxutbat wǝr t-illa is tu-tǝha tasa-net har iga karadat tǝlil. Igammay d ad isǝttǝddu i Kǝl-Ǝlyǝhud isalan win itaggu daɣ batu ǝn Taɣmar ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mišan saggarmaman wiyyad daɣ-san iwallan-nasan, ugayan s ad ǝzzǝgzǝnan s awa igannu, fadda ad gannin dat tiddawat aratan wǝr noleɣ ǝs tarrayt ta n Ǝmǝli. Immǝzzay dǝr-san Bulǝs, iddew ǝd nalkiman ǝn Ɣaysa; a tan-isasaɣru akk ǝzǝl daɣ ahan ǝn taɣaray n alǝs iyyan igâ esǝm Turanus, ");
INSERT INTO ttq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","har iga ǝššin elan; har as aytedan win akal n Asǝya, gǝr za win Kǝl-Ǝlyǝhud wala win Kǝl-Ǝlyunan, ketnasan ǝslan y awal n Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Isisugu Mǝššina Bulǝs tǝlmǝɣjujaten wǝr nǝtawazday, ");
INSERT INTO ttq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","har as, tamawayan ǝlkǝšifatan ǝd tǝsǝwad ǝn tǝbdoq ǝdasnen Bulǝs fǝl a sǝr-san tǝwǝdǝsan miranan. Tazzayan aytedan en daɣ tǝwǝrnawen-nasan; win daɣ-san ǝhan kǝlǝsuf deɣ gammadan-tan. ");
INSERT INTO ttq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ǝnkaran Kǝl-Ǝlyǝhud wiyyad ǝllâmnen gǝr kallan, takkasan kǝlǝsuf daɣ aytedan, ad gammayan ǝntanay da d-ikus ǝn kǝlǝsuf daɣ aytedan s esǝm ǝn Ɣaysa, gannin daɣ tǝmǝgraw-nasan: «Ǝhâdaɣ-awan ǝs Ɣaysa, was itaggu Bulǝs isalan-net ar, ad tǝgmǝdam awedan a!» ");
INSERT INTO ttq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ǝssa meddan ǝn mǝdrayan ǝmosnen maddanǝs n ǝmuzar iyyan n ǝlimam igân esǝm Sewa a tagginen awen. ");
INSERT INTO ttq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","As ǝnnan awen y aggǝsuf, a dasan-annu: «Ǝzdâyaɣ Ɣaysa, Bulǝs deɣ ǝššânaɣ awa imos, kawanay amaran, ma tǝmosam?» ");
INSERT INTO ttq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tǝzzar ifǝtǝqqǝt daɣ-san awedan wa ǝhan kǝlǝsuf da, ǝggǝznat-tu tǝɣurad a tu-sisarnanen meddan en ketnasan, iɣlǝb-tan ǝs tǝwit, har as, as gammadan ehan wen, ozâlan, ǝzzâfan, ǝbbôsan. ");
INSERT INTO ttq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ǝslan aytedan n Efez kul awen, gǝr za win Kǝl-Ǝlyǝhud wala win Kǝl-Ǝlyunan. Tǝggaz-tan tasa ketnasan, tǝzzar ǝzzǝzwaran wǝllen esǝm n Ǝmǝli Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A du-tasin aytedan aggotnen ǝzzigzannen ǝs Mǝššina, suɣulan ark mazalan win as kala tan-taggin. ");
INSERT INTO ttq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ewayan-du massaxaran aggotnen ǝlkǝttaban-nasan, ǝssǝqqadan-tan dat awedan kul. Itawaxsab awa d-ǝnzan, iqqal sǝmmosat tǝmǝrwen n ǝgim ǝn tamma n ǝzrǝf. ");
INSERT INTO ttq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ǝmmǝk en da as tǝzawwazawaz tarna n Ǝmǝli awal ǝn Mǝššina, tǝssǝkna assahat ta tǝhat awal ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Dǝffǝr awen, isammarkas Bulǝs daɣ man-net iki ǝn Yerusalam, immǝr akal wa n Masedonǝya ǝd wa n Akayya. Igannu daɣ man-net: «Dǝffǝr as oseɣ Yerusalam, kundaba ǝkkeɣ aɣrǝm wa n Ǝrrum ǝnta da.» ");
INSERT INTO ttq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tǝzzar izammazal Timotay d Erastus win madhalan-net s akal ǝn Masedonǝya, mišan ǝnta iman-net igla iha akal wa n Asǝya har daɣ-as ihog. ");
INSERT INTO ttq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Azzaman en inijarway daɣ-san aɣrǝm n Efez wǝllen fǝl ǝddǝlil ǝn tarrayt ta n Ǝmǝli. ");
INSERT INTO ttq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ill-ay anad iyyan igân esǝm Demetrǝyǝs, itaggin daɣ ǝzrǝf fototan n ahan n ǝssǝnǝm iyyan imosan tantut tǝgât esǝm Artemis. Igarraw daɣ awen tǝnfa tǝknât igǝt i nadan win midawan-net. ");
INSERT INTO ttq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iššedaw-tan-du ketnasan, ǝntanay ǝd nadan wiyyad win ǝddarnen daɣ awen, inn-asan: «Ya meddan, tǝssânam as tǝgǝrgist-nana, tǝqqân daɣ ǝššǝɣǝl wa da. ");
INSERT INTO ttq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mišan tǝhannayam kawanay iman-nawan, tǝslâm deɣ awa itaggu alǝs wǝdi as itawannu ǝddi Bulǝs. A igannu: \"Imalan win ǝgan fassan n aytedan, wǝr ǝmosan fadda imalan.\" Izazzagzan awen y aytedan aggotnen, wǝrge da da daɣ Efez ɣas ad issǝxrak aytedan, kalar harkid taššam n aytedan win akal n Asǝya kul. ");
INSERT INTO ttq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Arat wa, wǝrgeɣ ǝššǝɣǝl-nana ɣas as du-z-awǝy iguz ǝn tazak n ad itǝwǝlku, kalar ehan n ǝlɣibada wa n Artemis di maqqarat, ta tǝmosat tǝmǝlit-nana ǝnta da ad irtǝk almaqam-net, tammazzay fadda d ǝtǝwǝsǝɣmar, ǝnta ǝɣbâdan aytedan kul win akal n Asǝya, d ǝddǝnet ketnet.» ");
INSERT INTO ttq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","As ǝslan aytedan win das-ǝssǝsamnen y awen, iggaz-tan alham labasan, ǝssokan imaslan-nasan ijǝnnawan gannin: «Artemis ta n Kǝl-Efez di maqqarat!» ");
INSERT INTO ttq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tǝga tǝnajarwayat daɣ ǝɣrǝm ketnet. Tǝnkar tamattay tǝggag s ahan zǝwwǝran wa n ǝmǝnǝy, tǝlwây Gayǝs d Aristarxus win akal ǝn Masedonǝya ǝmosnen imidawan ǝn Bulǝs dǝr iddew daɣ ǝšikǝl. ");
INSERT INTO ttq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tǝzzar ira Bulǝs ad akku tamattay ten, mišan ǝgdalan-as-tu nalkiman ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wala arat daɣ muzaran n akal n Asǝya ǝn midawan-net da, zammazalan sǝr-ǝs aytedan y a daɣ-as ǝgmǝyan ad wǝr ikka ehan en. ");
INSERT INTO ttq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","As itaggu awen, tamattay ta tǝddewat daɣ ahan en, ketnet tǝnijarway. Siɣaren aytedan daɣ jǝnnawan gannin aratan wǝr nola, fǝlas taššam-nasan wǝr ǝssenan fadda ǝddǝlil wa fǝl ǝddewan den. ");
INSERT INTO ttq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ǝbdaɣan-in Kǝl-Ǝlyǝhud alǝs igân esǝm Alaskandǝr ǝs tiddawat, ittǝmal-as awa igan den. Tǝzzar ad isidugin s ǝfus-net i tamattay tǝfastit, y a dasan-iššiwǝl s esǝm ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mišan as ǝgran as awedan ǝn Kǝl-Ǝlyǝhud a imos ǝssokan imaslan-nasan ijǝnnawan jajjayen gannin: «Artemis ta n Kǝl-Efez di maqqarat!» Har din-ǝkkan edag ǝn sanatat assaɣaten gannin awen. ");
INSERT INTO ttq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Alǝs wa imosan ǝnaktab n ǝɣrǝm en, ǝnta a isahhadarren tamattay en, inn-as: «Ya meddan n Efez, awak ill-ay awedan wǝr nǝssen as, aɣrǝm wa n Efez ǝnta a imosan ǝmagaz n ahan wa daɣ tǝtawaɣbad Artemis di maqqarat ǝd šaššelan-net igân daɣ tǝhunt as jǝnnawan a daɣ du-tǝrtak? ");
INSERT INTO ttq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Zama wǝr t-illa awedan as ijhâl awen, wǝdi ihôr ad tǝhǝdǝrrem, ad wǝr tagim arat waliyyan daɣ tararada, ");
INSERT INTO ttq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","fǝlas meddan win du-tǝlwayam da, wǝrmâd ǝmôsan ibaydagan ǝn nan win ǝlɣibada, wala deɣ ǝnnan a labasan ǝs tǝmǝlit-nana. ");
INSERT INTO ttq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Amaran kud Demetrǝyǝs ǝd nadan win midawan-net ill-ay a dasan-iɣšâd awedan, wǝdi ǝllân-tu jilan win daɣ itaggu ǝššǝriɣa, ǝllân-tu deɣ naxkiman win tu-tagginen. Akkinet-tan. ");
INSERT INTO ttq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kud deɣ wiyyad aratan a dǝr tǝssǝstanam, ad tǝtǝwǝknu taɣawšay tǝdi daɣ asaggawar wa iskatan s awen. ");
INSERT INTO ttq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nakkanay da ǝmǝrǝdda ǝhanen tazak n ad itiwǝnnu ǝfǝllǝg a nǝga fǝl ǝddǝlil n awa igan azalada; fǝlas wǝr t-illa ǝsaru nǝga as nǝnna ǝnta a fǝl tǝga tǝnajarwayat ta.» Iɣrad ǝnaktab n ǝɣrǝm awal wen ɣas, inna i tamattay ad tǝwǝziwǝz. ");
INSERT INTO ttq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","As ǝdraran aytedan, isassaɣra-du Bulǝs inalkiman ǝn Ɣaysa ig-asan ǝnnǝsixa issǝsmad iwallan-nasan, amaran inamagga dǝr-san šiwatriwen, igla ikka akal ǝn Masedonǝya. ");
INSERT INTO ttq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Irzag akal en itaggu ǝnnǝsixatan aggotnen i nalkiman ǝn Ɣaysa, italam-asan fǝl man, dǝffǝr awen ikka akal wa n Kǝl-Ǝlyunan. ");
INSERT INTO ttq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Iga daɣ-as karadat tǝlil. Isimutug y iguz n ǝɣlal n aman s akal ǝn Surǝya as t-ǝggazan salan n as ǝgân Kǝl-Ǝlyǝhud eɣaf fǝl a t-anɣin, tǝzzar iga tanat n ad iqqǝl dǝffǝr-ǝs, agu tarrayt ta n Masedonǝya. ");
INSERT INTO ttq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Iddew ǝd Sofatrǝs ag Fǝrǝs wa n ǝɣrǝm ǝn Berawya, d Aristarxus ǝd Sǝkǝndus win n ǝɣrǝm ǝn Tesalonik, ǝd Gayǝs wa n ǝɣrǝm ǝn Derbe, ǝd Tišik ǝd Trofimǝs win n akal n Asǝya amaran ǝd Timotay. ");
INSERT INTO ttq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ǝglan meddan win, azzaran-anaɣ, ǝqqalan-anaɣ daɣ ǝɣrǝm ǝn Trowas. ");
INSERT INTO ttq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Amaran nakkanay as fall-anaɣ okay ǝmud wa daɣ tattin aytedan šigǝlwen šin wǝr iha xamira, nǝggaz aɣlal n aman daɣ Filib nǝkka Trowas. As nǝga sǝmmos adan fǝl agaraw nos-en-in, nǝga den ǝssa adan. ");
INSERT INTO ttq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","As ǝzǝl wa n alxad imosan ǝzǝl wa azzaran daɣ jilan, nǝmmǝnay daɣ adag iyyanda y ad nǝdrǝw imensewan win saktan. Iššewal Bulǝs i nalkiman ǝn Ɣaysa win ǝllanen den har isiggaraygaray ahad fǝlas ǝšikǝl a fǝl insa. ");
INSERT INTO ttq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ǝhanat fǝtǝlaten aggotnen ehan imosan suru wa daɣ nǝmmǝnay. ");
INSERT INTO ttq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A iššewal Bulǝs den, iqqim alǝs iyyan n ǝmawad igân esǝm Yutǝxos fǝl fǝnetǝr. Illa den har t-iggaz etǝs ad itanaddam. Igla har daɣ-as igla etǝs wǝllen, ifataqqat, ikka amaḍal. Fǝnetǝr ǝn suru wa n karad a fǝl d-ifataqqat den. As d-immǝdkal, wǝr idder. ");
INSERT INTO ttq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Izzǝbbat-du sǝr-ǝs Bulǝs ǝnta da, ifataqqat fall-as, izalammat-tu, inna: «Ad wǝr tǝššǝwǝšam, iddâr.» ");
INSERT INTO ttq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tǝzzar iqqal Bulǝs ehan wa d-izzǝbbat, izun imensewan win saktan, as ǝtšan, ilas Bulǝs iššewal-asan har du-tǝgmad tǝfuk, ǝddi amaran ad igla. ");
INSERT INTO ttq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ǝmawad ǝnta, ǝddewan dǝr-ǝs aytedan s aɣaywan iddâr, wǝr ila ǝɣǝli. Ketnasan olam-asan awen wǝllen fǝl man. ");
INSERT INTO ttq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nakkanay nǝgla nǝggaz aɣlal n aman nǝkka aɣrǝm n Assos, nazzar i Bulǝs. Den da a fall-ana du-z-iggǝz aɣlal, imos as awen da as otas igi-net. Ǝnta iman-net a ira a din-ijǝwǝnkǝt. ");
INSERT INTO ttq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","As dana-d-osa daɣ Assos, nǝnamaggaz dǝr-ǝs aɣlal n aman, nǝkka aɣrǝm ǝn Mitilenǝs. ");
INSERT INTO ttq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nǝgmad Mitilenǝs nǝhâ aɣlal n aman, as ǝzǝl wa hadan nǝmmodaɣ y akal imosan gǝrwǝtlan as itawannu Xǝyyaw, ǝzǝl wa dǝffǝr wǝdi newad wa n Samos, ǝzǝl wa dǝffǝr wǝdi nosa aɣrǝm ǝn Miletǝs. ");
INSERT INTO ttq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Igâ Bulǝs tanat n as, wǝr zʼimmǝr Efez fǝl ad wǝr aḷḷalat daɣ akal n Asǝya, fǝlas irrorad Yerusalam fǝl a daɣ-as t-agu ǝmud wa n Fantǝkawt, kud adi ifrâg igi. ");
INSERT INTO ttq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ǝzǝbbi wa nǝga daɣ Miletǝs a ɣur izammazal Bulǝs awedan, issǝgmay imuzaran n Ǝlkǝnisat n Efez. ");
INSERT INTO ttq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","As t-id-osan inn-asan: «Kawanay iman-nawan ǝhân-kawan salan ǝn tassaq ta dǝr-wan ǝgeɣ, wa d-ǝggazaɣ akal n Asǝya ǝzǝl wʼazzaran, har awas kawan-ǝfala; ");
INSERT INTO ttq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","d ǝmmǝk was tagga ǝššǝɣǝl n Ǝmǝli ǝssirasaɣ iman-in daɣ arat kul, iddew-i awen ǝd mǝttawan ǝd tǝmǝɣutar šin sǝr-i du-tawaynat ark tǝnagmayen šin di-taggin Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tǝssânam deɣ as, wǝr kala a dawan-ǝɣbara arat waliyyan a dawan-tǝha tǝnfa, aqqama wǝr dawan-t-ǝmela, sassaɣr-awan-tu, gǝr za dat aytedan wala deɣ daɣ nan-nawan. ");
INSERT INTO ttq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Wǝr kala ǝmmǝzzaya d agamay daɣ Kǝl-Ǝlyǝhud ǝd win tan-wǝr-nǝmos ad utaban ǝs Mǝššina, ǝzzǝgzǝnan s Ǝmǝli-nana Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Amaran ǝmǝrǝdda nak da izzǝlzam Infas wa Zǝddigan iki n Yerusalam, wǝr ǝssenaɣ awa di-iqqalan daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Arat iyyanda ɣas a daɣ ǝssanaɣ as, ig-i Infas wa Zǝddigan ta daw aɣaf as, aɣrǝm oseɣ da ilkâm daɣ-i kasaw d alɣazab. ");
INSERT INTO ttq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wǝr ɣur-i tǝmos tǝmǝddurt-in fadda wala, arat wa ɣur-i t-imosan a d-ǝssǝxsǝla arat wa dǝffǝr ozala, ǝɣrǝda ǝššǝɣǝl wa daɣ-i iga Ǝmǝli Ɣaysa, imosan emel n Ǝlinjil a ǝhan salan n arraxmat ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Amaran ǝmǝrǝdda ǝssâna daɣ-as, kawanay win gǝr ǝllama da, ǝmmâla Taɣmar ta n Mǝššina, wǝr di-za-tǝlǝsam anay. ");
INSERT INTO ttq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Adi a fǝl kawan-ǝgeɣ azalada šigǝyyawen n as, abʼas di-iwar alxaq n ǝzni ǝn waliyyan daɣ-wan. ");
INSERT INTO ttq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Fǝlas wǝr kala a dawan-ǝɣbaraɣ arat waliyyan, ǝmâlaɣ-awan tarrayt kul ta d-iktab Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Daɣ adi ǝnkǝdat ǝd man-nawan, tǝssǝnam deɣ daɣ tamattay ketnet tas kawan-iga Infas wa Zǝddigan imagazan-net, tagim y Ǝlkǝnisat ǝn Mǝššina tǝmǝdint tolâɣat, ǝnta di da a d-izzǝnza Ǝlmǝsix s ǝzni wa-net iman-net. ");
INSERT INTO ttq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ǝssânaɣ as, nak as ǝgleɣ a kawan-d-ǝggǝzan aytedan wǝr nǝzlay ǝd tǝzoriyawen labasnen, wǝr za nayyu Ǝlkǝnisat-nawan wǝr tat-ǝdesan. ");
INSERT INTO ttq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kawanay iman-nawan da, ǝhân-kawan aytedan as za safraɣnen tidǝt fǝl ad ǝssǝxrǝkan inalkiman ǝn Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Daɣ adi agat ǝnnǝyat, a du-tǝkattim as karad elan a ǝgeɣ sasaɣraq-qawan s iyyan iyyan ehad ezal, ǝssirtayaɣ awen ǝd mǝttawan. ");
INSERT INTO ttq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Amaran ǝmǝrǝdda ǝssiɣlafaq-qawan i Mǝššina ǝd salan win ǝmmalnen arraxmat-net. Mǝššina ifrâg ǝsǝssuhi n ǝzǝgzan-nawan d ǝsǝttǝddi n agaraw wa za tagim daɣ tǝkasit ta issǝnsa y aytedan kul win zaddognen. ");
INSERT INTO ttq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Wǝr di-ides as ǝgêɣ attama-nin daɣ ǝzrǝf wala urǝɣ wala isǝlsa n awedan waliyyan. ");
INSERT INTO ttq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kawanay iman-nawan tǝssânam as, ifassan win-da-nin as ǝšɣala, ǝkneɣ s ǝššǝɣǝl-nasan tumǝɣlaten-in ǝd šin midawan-in win dǝr ǝddewa. ");
INSERT INTO ttq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Faw saknaq-qawan as, ǝmmǝk en da as kawan-iwar kawanay da, ad tǝšɣǝlam fǝl ad tilalam i maddararan, a du-tǝkattim batu ta iga Ǝmǝli Ɣaysa ǝnta iman-net, as inna: \"Ǝbbǝlǝl wa itaggu awedan wa ikfan, ogar wa itaggu awedan wa igrawan.\"» ");
INSERT INTO ttq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","As inna Bulǝs awen, igaraffat ǝnta dǝr-san ad itattar. ");
INSERT INTO ttq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ketnasan hallin, tizǝlǝmmen Bulǝs, tamallen-as. ");
INSERT INTO ttq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Arat wa iɣšadan iman-nasan wǝllen, tǝnna ta dasan-iga, wǝr tu-z-ǝlǝsan anay. Amaran ǝntagan-tu har osa aɣlal n aman. ");
INSERT INTO ttq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","As dǝr-san nǝmmǝzzay gǝrrid, nǝggaz aɣlal n aman, izzal dǝr-na s akal imosan gǝrwǝtlan as itawannu Kos. As ǝzǝl wa dǝffǝr wen, nǝgmad-tu s akal imosan gǝrwǝtlan as itawannu Rodǝs. Nǝgmad Rodǝs nǝkka aɣrǝm ǝn Fatara. ");
INSERT INTO ttq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nogaz-in daɣ-as aɣlal n aman itakkin akal wa n Fenisǝya, tǝzzar nǝggaz-tu, nǝgla. ");
INSERT INTO ttq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","As nogga akal imosan gǝrwǝtlan as itawannu Qibrus, nǝɣlay-tu fǝl aganna wa n agala, nǝdag sa sǝr akal wa n Surǝya har nǝzzǝbbat daɣ ǝɣrǝm ǝn Tir s ǝnta a daɣ za tǝwǝzǝzǝbben lalan win eway ǝɣlal. ");
INSERT INTO ttq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nǝgmay inalkiman ǝn Ɣaysa har tan-nǝgraw, nǝzzǝbbat ɣur-san har nǝga ǝssa adan. Nǝlla ɣur-san as tan-issosan Infas wa Zǝddigan daɣ ad annin i Bulǝs, ad wǝr akku Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Dǝr iga awen da ya, as ǝndan adan win den, nǝmatakway nǝgla. Ǝntagan-ana ketnasan, harkid tǝdoden-nasan ǝd bararan-nasan har nǝgmad aɣrǝm, amaran nǝgaraffat daɣ tama n agaraw, nǝttar. ");
INSERT INTO ttq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","As dǝr-san nǝnamagga šiwatriwen, nǝggaz aɣlal n aman; ǝntanay ǝqqalan iɣawnatan-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nǝgla daɣ ǝššikǝl-nana, nǝgmad Tir nǝkka Bǝtolemayǝs. As daɣ-as nǝzzǝbbat, nǝkka imǝdrayan-nana win t-ǝhanen y a tan-nǝssǝslǝm, nǝga ɣur-san ǝzǝl. ");
INSERT INTO ttq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","As ǝzǝl wa dǝffǝr wen nǝkka aɣrǝm ǝn Qaysarǝya. As t-in-nosa nǝzzǝbbat daɣ ahan ǝn Filibus wa n ǝmǝggi ǝn salan n Ǝlinjil imosan iyyan daɣ meddan win ǝssa, win as kala tawasanafranan fǝl ad tilalan y Ǝlkǝnisat ta n Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ila ǝkkozat tǝbararen wǝr nǝzday meddan. Šibararen šin ǝmosnat tǝnnǝbiten. ");
INSERT INTO ttq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","As nǝga adan aggotnen den, osa-du ǝnnǝbi iyyan igân esǝm Agabus, a d-ifalan akal ǝn Yahudǝyya. ");
INSERT INTO ttq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Os-ana-du, idkal ǝsatǝb ǝn Bulǝs, ikrad sǝr-ǝs idaran win-net iman-net ǝd fassan-net, amaran inna: «Ǝnta da awa inna Infas wa Zǝddigan: \"Alǝs wa ilan ǝsatǝb wa, ǝmmǝk wa da as tu-z-ǝkrǝdan Kǝl-Ǝlyǝhud daɣ Yerusalam, agin-tu daɣ fassan n aytedan wǝr nǝmos Kǝl-Ǝlyǝhud.\"» ");
INSERT INTO ttq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","As nǝsla y awen, ad nǝtansay Bulǝs, nakkanay ǝd nalkiman ǝn Ɣaysa win ǝɣrǝm en fǝl ad wǝr aggazzay akku Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mišan inn-ana Bulǝs: «Ma fel tǝhallim, tǝsimǝlǝššem ǝwǝl-in? Nak, wǝrgeɣ kerrad ɣas as sammataga, kalar tamattant da simatagaɣ-as daɣ ǝɣrǝm ǝn Yerusalam fǝl ǝddǝlil n esǝm n Ǝmǝli Ɣaysa.» ");
INSERT INTO ttq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","As nǝnay as wǝr t-idu-za-nǝssuɣǝl daɣ awas ira igi-net, noyy-ay, nǝnna: «Aget Ǝmǝli tara-net!» ");
INSERT INTO ttq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dǝffǝr adan win den ad nasammatag i teklay, nǝgla nǝggǝzzay ǝs Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ǝddewan dǝr-na arat daɣ nalkiman ǝn Ɣaysa win ǝɣrǝm ǝn Qaysarǝya. Ewayan-ana s ahan n alǝs igân esǝm Mǝnason n akal imosan gǝrwǝtlan as itawannu Qibrus, irǝwan imos analkim ǝn Ɣaysa, nǝzzǝbbat ɣur-ǝs. ");
INSERT INTO ttq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","As din-nǝggaz Yerusalam, ǝgan-ana mǝdrayan-nana daɣ ǝzǝgzan win ǝllanen den marxaba, ǝddǝwen. ");
INSERT INTO ttq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","As affaw iddew dǝr-na Bulǝs s ahan ǝn Yaqub ɣur ǝddêwan ǝmɣaran n Ǝlkǝnisat ketnasan. ");
INSERT INTO ttq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Issǝslam-tan Bulǝs, tǝzzar iɣrad-asan ǝsuɣǝl n aratan kul win iga Mǝššina ǝs tarrayt n ǝššǝɣǝl wa itaggu Bulǝs daɣ aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","As ǝslan y aratan win inna, ad ǝmmâlan Mǝššina. Dǝr iga awen da ya ǝnnan i Bulǝs: «Amadray-nana, ǝnǝy igiman ǝs giman n aytedan win ǝzzǝgzannen ǝs Ɣaysa daɣ Kǝl-Ǝlyǝhud, ketnasan zizawen wǝllen daɣ iduf n ǝššǝriɣa wa n Ǝttǝwret. ");
INSERT INTO ttq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ewâdan-tan-du za salan wizawaznen daɣ batu-nak, ǝmosnen as: ǝsǝssǝɣri wa tǝtagga, itaway-du ǝs Kǝl-Ǝlyǝhud kul win ǝhanen šimattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud ǝmǝzzǝy d ǝššǝriɣa wa n Ǝttǝwret, tǝgannaɣ-asan ad ammazzayan d ǝsǝmmǝnkǝd ǝn bararan-nasan ǝd lǝkkum y alɣadaten ǝn Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Daɣ adi ma za nagu? Fǝlas igmâd aššak as ad aslin as tosêɣ-du. ");
INSERT INTO ttq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ǝddǝlil wǝdi a fǝl za taga a wa dak-za-nannu da: Ǝhân-anaɣ ǝkkoz meddan ǝdkâlnen aḍḍawal. ");
INSERT INTO ttq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Idaw dǝr-san s adag wa daɣ zazdagan aytedan, tǝzzǝzdǝga iman-nak kay dǝr-san, tǝrzǝmaɣ fall-asan arat wa tan-ihan, fǝl a dasan-tǝwǝlzin ɣafawan-nasan. Ǝddi ad zʼǝssǝnan aytedan kul as, awa sǝr-ǝk itawannin wǝr t-iha a igân, kalar kay da tǝlkâmaɣ y ǝššǝriɣa wa n Ǝttǝwret. ");
INSERT INTO ttq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Amaran aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud win ǝlkamnen i Ɣaysa, nǝktâb-asan širawt ǝhânat tǝnaden šin nǝga ǝmosnen as, ad wǝr atšin isan ǝmosnen takutay y ǝssǝnam, wala ašwin azni, wala atšin isan n ǝmudar tǝnɣa tarzam, wala agin ǝzzǝna.» ");
INSERT INTO ttq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tǝzzar iddew Bulǝs ǝd meddan win ǝkkoz en. As ǝzǝl wa dǝffǝr wen izzǝzdag iman-net ǝnta dǝr-san, amaran iggaz Ehan wa Zǝwwǝran n Ǝlɣibada, imal i limaman ǝzǝl wa daɣ za tandu tazdak-nasan, ǝzǝl wa daɣ za tǝtǝwǝkfu tǝkutay fǝl akk iyyan daɣ-san. ");
INSERT INTO ttq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","As zama daɣ-san ǝkmâlan ǝssa adan, tandu tazdak-nasan, ǝnayan Kǝl-Ǝlyǝhud wiyyad n akal n Asǝya Bulǝs daɣ Ahan wa Zǝwwǝran n Ǝlɣibada; tǝzzar jannajarwayan tamattay, ǝgan daɣ-as arak man ǝs Bulǝs, ǝbazan-tu. ");
INSERT INTO ttq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Gannin s afalla: «Ya Kǝl-Israyil, agǝzat! Ǝnta da alǝs wa itaggin daɣ tǝlxutbaten šin itaggu y aytedan kul daɣ adag kul ark awalan fǝl tamattay-nana, d ǝššǝriɣa wa n Ǝttǝwret d Ahan wa Zǝwwǝran n Ǝlɣibada wa. Igla har as, iga-du Kǝl-Ǝlyunan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, isammadas edag zǝddigan wa.» ");
INSERT INTO ttq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Gannin awen fǝlas dat awen ǝnâyan Trofimǝs wa n Efez daɣ ǝɣrǝm iddew ǝd Bulǝs; tǝzzar ordan as izzogaz-tu Bulǝs Ehan wa Zǝwwǝran n Ǝlɣibada. ");
INSERT INTO ttq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Inajarway ǝɣrǝm ketnet, ozalan-du aytedan daɣ tǝsǝdag kul. Ǝbazan Bulǝs, ǝlwayan-tu ǝgmadan dǝr-ǝs Ehan wa Zǝwwǝran n Ǝlɣibada, tǝzzar tawaharan mawan-net dǝffǝr-san tamazayt ten da. ");
INSERT INTO ttq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Gammayan ad agin iman ǝn Bulǝs as din-ewadan salan kumanda ǝn sojitan n Ǝrrum n as, aɣrǝm ǝn Yerusalam ketnet inijarway. ");
INSERT INTO ttq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Iɣra-du sojitan ǝd kabtanatan-nasan daɣ tamazayt ten da, ozalan sǝr-san. As togga tamattay kumanda ǝd sojitan, tǝraz daɣ tǝwit ǝn Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tǝzzar ikka-du kumanda Bulǝs, ibaz-tu, omar s ad itǝwǝkrǝd s ǝššin sassaran, amaran issǝstan d awa imos, d awa iɣšad. ");
INSERT INTO ttq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tǝsaɣarat tamattay ketnet, gannin aratan ǝmmizraynen. Indar i kumanda ad issǝn awa imosan tidǝt daɣ takat ten, tǝzzar omar s ad ammaway Bulǝs ǝs barǝki wa n sojitan. ");
INSERT INTO ttq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","As ewad Bulǝs šisǝffǝttan n ahan wa n barǝki, awa sǝr-ǝs tǝga tamattay daɣ ǝwǝjjǝn, kundaba as t-ǝdkalan sojitan s afalla. ");
INSERT INTO ttq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tǝlkâm-as tamattay ketnet, tǝsiɣarat tǝgannu: «Ammatet, ammatet!» ");
INSERT INTO ttq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","As zama dǝr-ǝs ǝggâzan sojitan barǝki, inna Bulǝs i kumanda: «Awak ǝleɣ tarrayt n a dak-annaɣ arat?» Inn-as kumanda: «Ko! Kay tǝssana tǝlyunant? ");
INSERT INTO ttq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Daɣ adi wǝr tǝmosaɣ aw Masar was kala isaffallag aytedan, tǝzzar iggaz teneray ǝnta d ǝkkoz gim n awedan ǝn maggan ǝn man?» ");
INSERT INTO ttq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Inn-as Bulǝs: «Nak, Ag-Ǝlyǝhud a ǝmosaɣ, ihǝwan daɣ ǝɣrǝm ǝn Tarsa daɣ akal ǝn Kilikǝya imosan aɣrǝm fǝl tǝga masnat. Onsayaq-qay a di-takfa turagat n ad ǝššiwǝla i tamattay ta.» ");
INSERT INTO ttq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ikf-as-tat kumanda, ibdad Bulǝs fǝl tǝsǝffǝttan, isaddagan s ǝfus-net i tamattay ad tǝssǝsǝm. Tǝffǝsta tamattay ketnet, tǝzzar iššewal-asan Bulǝs daɣ tǝlɣibrit, awal wa-da-nasan, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Imǝdrayan-in d abbatan-in, sǝsǝmat ǝmǝrǝdda a kawan-sassagra tadlǝmt ta tawagga.» ");
INSERT INTO ttq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","As das-ǝslan iššewal-asan daɣ tǝlɣibrit, ǝššotan daɣ ǝsǝsǝm y-as; tǝzzar inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Nak Ag-Ǝlyǝhud a ǝmosa, ihǝwan daɣ ǝɣrǝm ǝn Tarsa ihân akal ǝn Kilikǝya, mišan aɣrǝm wa daɣ a daɣ ǝdwala, ǝɣreɣ daw Gamalǝyel. Isassaɣr-i s ǝlluɣ lǝkkum y ǝlqanun n aljad-nana. Ǝgeɣ gǝlleyat daɣ lǝkkum i Mǝššina šilat ǝn ta tǝgam azalada. ");
INSERT INTO ttq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ǝzaɣazzabaɣ aytedan win ǝhanen tarrayt ta da ǝn Ɣaysa, har ǝgmadan man wiyyad, karrada meddan ǝd tǝdoden, ǝggaraq-qan daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ǝlimam wa Zǝwwǝran d Asaggawar wa n ǝɣmaran ǝggǝyyen fǝl adi. Ǝntanay fadda a di-ǝkfanen šira ǝkkanen imǝdrayan-nana, Kǝl-Ǝlyǝhud win Damas, fǝl ad ǝgrǝwa as din-oseɣ tarrayt n abbaz ǝn nalkiman ǝn Ɣaysa kul win t-ǝhanen, awǝyaq-qan-du ǝs Yerusalam ǝkrâdan fǝl ad awwaddaban. ");
INSERT INTO ttq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ǝššokala za daɣ awen da, as din-ǝhozaɣ aɣrǝm ǝn Damas attayan n ammas n azal, wala a ihogan, ibalazzat ǝnnur labasan a d-igmâdan ijǝnnawan daɣ ɣǝlǝyɣǝlayan-in. ");
INSERT INTO ttq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Udeɣ, ǝsleɣ y ǝmǝsli iyyan as di-inna: \"Talut, Talut ma fel as di-tǝzaɣazzaba?\" ");
INSERT INTO ttq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ǝnneɣ: \"Ǝmǝli, ma tǝmosaɣ?\" Inn-i: \"Nak awa, Ɣaysa wa n Nazaret, wa tǝzaɣazzaba.\" ");
INSERT INTO ttq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ǝnâyan aytedan win dǝr ǝddewaɣ ǝnnur wen, mišan wǝr ǝslen y ǝmǝsli wa di-iššewalan. ");
INSERT INTO ttq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tǝzzar ǝnneɣ: \"Ǝmǝli, mas di-iwar igi-net?\" Inn-i Ǝmǝli: \"Ǝbdǝd, takkaɣ aɣrǝm ǝn Damas, a dak-daɣ-as-attamal arat kul was kay iwar igi-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ǝddǝrɣala fǝl tǝllabǝst n ǝnnur en, tǝzzar ǝbazan aytedan win dǝr ǝddewa ǝfus-in, ǝlwayan-i ǝs Damas. ");
INSERT INTO ttq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Amaran Damas ih-et alǝs iyyan igân esǝm Ananǝyâs iksudan Mǝššina wǝllen, ilkâm y ǝlqanun-nana, as Kǝl-Ǝlyǝhud kul win Damas ǝssiɣmaran-tu. ");
INSERT INTO ttq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Os-i-du, ibdad dǝgma-nin, inn-i: \"Amadray-nin Talut, iqqǝlet-kay-du asawad-nak.\" Iqqal-i-du asawad-in tamazayt ten da, ǝnayaq-qu. ");
INSERT INTO ttq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Inn-i deɣ: \"Mǝššina wa ǝɣbadan marawan-nana a kay-isannafranan harwa dat alwaq, y a kay-issusǝn tara-net, tǝnǝyaɣ Alɣadil-net, tasla deɣ y ǝmǝsli wa-net iman-net, ");
INSERT INTO ttq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","id ad tǝqqǝla tǝgǝyya-net dat aytedan kul, tǝmǝlaɣ-asan awa tǝnayaɣ d awas tǝsleɣ. ");
INSERT INTO ttq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ǝmǝrǝdda mas tǝqqala? Ǝbdǝd, tǝtǝwǝsǝlmǝɣa daɣ aman, tansǝyaɣ Ǝmǝli a kay-izzǝzdǝg daɣ bakkadan-nak.\" ");
INSERT INTO ttq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Dǝffǝr awen ǝqqala Yerusalam. Tattara ǝzǝl iyyan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada as di-tobaz tarna n Infas wa Zǝddigan. ");
INSERT INTO ttq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ǝnayaɣ Ǝmǝli, inn-i: \"Ǝtrǝb, tǝgmǝda Yerusalam tarmâd, fǝlas wǝr zʼǝqbǝlan aytedan-net tǝgǝyya ta fall-i tǝtagga.\" ");
INSERT INTO ttq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tǝzzar ǝnneɣ-as: \"Ya Ǝmǝli, wǝrgeɣ ǝntanay iman-nasan ǝssânan daɣ ǝmmǝk was kala ad tilala inan n ǝlɣibada s iyyan iyyan, saɣfalaɣ aytedan win sǝr-ǝk ǝzzǝgzannen, ǝggataq-qan? ");
INSERT INTO ttq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","As itawanɣal deɣ ǝzni n Ǝstefanos imosan tǝgǝyya-nak, nak iman-in ǝlleɣ den, ǝrḍêɣ s ǝtǝwǝnɣa-net, nak a ogazan ibǝrnaz n aytedan win ǝganen iman-net.\" ");
INSERT INTO ttq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Amaran inn-i: \"Aglu, nak a kay-z-izǝmmizǝlan s igǝg, ǝssukaq-qay aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud.\"» ");
INSERT INTO ttq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ǝssisaman-as aytedan har d-idkal batu n aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud, tǝzzar saɣaren daɣ jǝnnawan gannin: «Itǝwǝkkǝset awedan wa fǝl amaḍal! Awedan šilat ǝn wa, wǝr immǝk ad ilǝs tǝmǝddurt.» ");
INSERT INTO ttq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Takkasan imaslan saksodnen, ǝggaran-in ibǝrnaz-nasan, ǝggaran aboqqa daɣ alhawa. ");
INSERT INTO ttq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Omar kumanda s ad itǝwǝzugǝz Bulǝs ammas ǝn barǝki, tǝwǝgginat-as tǝwit s ǝlǝkkud fǝl a dasan-imǝl ǝddǝlil wa fall-as tǝsaɣarat tamattay. ");
INSERT INTO ttq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mišan as t-ǝkradan y a das-agin šiwwit, inna i kabtan wa illan den: «Awak tǝlâm tarrayt ǝn tǝwit n iyyan daɣ Kǝl-Ǝrrum wǝr ibez ǝššǝriɣa harwada?» ");
INSERT INTO ttq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","As isla kabtan en y awen, igla imal i kumanda, inn-as: «Ma tǝtagga da? Alǝs a, in Ǝrrum!» ");
INSERT INTO ttq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ikka-du kumanda Bulǝs, inn-as: «Tidǝt as kay in Ǝrrum?» Inn-as Bulǝs: «Awalla!» ");
INSERT INTO ttq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tǝzzar inna kumanda: «Nak, azrǝf aggen a ǝzzǝnza tišit n iyyan daɣ Kǝl-Ǝrrum.» Inn-as Bulǝs: «Nak ǝlǝsǝl-in a tǝmos.» ");
INSERT INTO ttq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tarmâd as fall-as ǝzzǝnkazan sojitan win as zama a t-ǝggazan šin tanaɣay y a tu-šǝššiwǝlan. Kumanda iman-net as issan as iyyan daɣ Kǝl-Ǝrrum a isassakrad den ǝs sassaran, tǝggaz-tu tasa. ");
INSERT INTO ttq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","As ǝzǝl wa dǝffǝr wen, omar kumanda imuzaran ǝn limaman d Asaggawar wa Zǝwwǝran ǝn Kǝl-Ǝlyǝhud ketnet s ad ammanay, fǝlas ira ad ikkǝs aššak daɣ ǝddǝlil wa fǝl sattarmasan Kǝl-Ǝlyǝhud Bulǝs. Tǝzzar issokas-du Bulǝs, issǝbdad-tu dat-san. ");
INSERT INTO ttq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Idag Bulǝs Asaggawar s asawad-net, inna: «Imǝdrayan-in, wǝr di-tǝha tǝrǝk waliyyat n as ill-ay arat a iqqal wǝr ira Mǝššina as kala ad t-ǝmmozala har awas ǝbdada da.» ");
INSERT INTO ttq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mišan omar Ananǝyâs wa n Ǝlimam wa Zǝwwǝran iyyan daɣ aytedan win ǝllanen dǝgma ǝn Bulǝs s a das-infǝẓ. ");
INSERT INTO ttq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tǝzzar inn-as Bulǝs: «Mǝššina a dak-z-infǝẓan, ǝlmunafiq! Wǝr tǝqqimaɣ ǝddi ar y a di-tǝšrǝɣa s awa inna ǝššǝriɣa, kay tǝmmǝzrayaq-qu ad tǝsawataɣ imi-nin.» ");
INSERT INTO ttq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ǝnnan-as aytedan win ǝllanen dǝgma-net: «Kay, Ǝlimam wa Zǝwwǝran ǝn Mǝššina a tǝrabbada?» ");
INSERT INTO ttq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Inn-asan Bulǝs: «Wǝr ǝssenaɣ imǝdrayan-in as ǝnta a imosan Ǝlimam wa Zǝwwǝran; tidǝt daɣ as iktâb as: \"Ad wǝr tannaɣ a labasan s ǝmǝnokal ǝn tamattay-nak.\"» ");
INSERT INTO ttq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Issân Bulǝs as tǝzunt n Asaggawar en iyyat Sadusaytan a daɣ tǝga, ta hadat Farisaytan; adi a fǝl idkal ǝmǝsli-net wǝllen dat Asaggawar, inna: «Imǝdrayan-in, nak Farisay a ǝmosa, erâwan wiyyad Farisaytan, wǝr d-ǝmmewaya s adag n ǝššǝriɣa wa, ar fǝlas ǝgeɣ attama daɣ as inǝmǝttan ilkâm a d-ǝnkǝran daɣ tamattant.» ");
INSERT INTO ttq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Inna awen ɣas tǝnkar tamazaq gǝr Farisaytan ǝd Sadusaytan, tǝzun tiddawat, ");
INSERT INTO ttq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","fǝlas Sadusaytan ǝttâfan as wǝr tu-tǝlla tanakra daɣ tamattant, wala ǝllân-tu angalosan, wala kǝlǝsuf. Farisaytan amaran ǝntanay ǝzzigzanan as awen kul ill-ay. ");
INSERT INTO ttq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tǝkkus tamazaq wǝllen. Inkar arat daɣ musanan win Farisaytan ǝbbǝllanan fǝl awen, ǝwaran aganna ǝn Bulǝs, ad gannin: «Alǝs wa, wǝr fall-as nǝhǝnnǝy lahan waliyyan! Mijas tidǝt daɣ as iššêwal-as aggǝsuf madeɣ angalos.» ");
INSERT INTO ttq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Awa tǝga tamazaq-nasan daɣ tuksay, tǝggaz tasa kumanda n ad agin Bulǝs tankǝt-tankǝt. Adi a fǝl omar sojitan s ad azzabben fǝl a daɣ-san d-ǝxtǝsan Bulǝs, awǝyan-tu ǝs barǝki-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","As iga ahad, inafalal Ǝmǝli i Bulǝs, inn-as: «Bulǝs, a kay-wǝr-tǝggǝz tasa! Ǝmmǝk wa daɣ as fall-i tǝggǝyyeɣ daɣ ǝɣrǝm ǝn Yerusalam, ǝmmǝk di da as kay-iwar a fall-i taggayyeɣ daɣ wa n Ǝrrum ǝnta da.» ");
INSERT INTO ttq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","As affaw, namaggan Kǝl-Ǝlyǝhud eɣaf, ǝhadan as wǝr zʼatšin, wala ašwin iket wǝr ǝgen iman ǝn Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Aytedan win ǝhadnen den, ogaran ǝkkozat tǝmǝrwen. ");
INSERT INTO ttq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ǝkkan imuzaran ǝn limaman d ǝmɣaran ǝn tamattay, ǝnnan-asan: «Nǝhâd as, wǝr zʼiggǝz arat imawan-nana iket wǝr nǝga iman ǝn Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Daɣ adi ǝmǝrǝdda kawanay d Asaggawar wa Zǝwwǝran ǝgmǝyat daɣ kumanda a dat-wan issǝbdǝd Bulǝs, tassaknim as, a tǝram ad taššaggaram taɣara-net s ǝlluɣ. Amaran nakkanay, nasimatag y igi ǝn man-net harwa du-wǝr-ewed da.» ");
INSERT INTO ttq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mišan isla tagazay ǝn Bulǝs i taftaw ten, ikka barǝki ǝn sojitan, iggaz-tu, imal i Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tǝzzar iɣra-du Bulǝs iyyan daɣ kabtanatan, inn-as: «Ǝlwǝy abi di ǝs kumanda, ila isalan a das-z-agu.» ");
INSERT INTO ttq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Iddew dǝr-ǝs kabtan, eway-tu ǝs kumanda, inn-as: «Amaskasaw wa igan Bulǝs a di-d-iɣran, igmay daɣ-i a sǝr-ǝk d-ǝlwǝya abi a, ilân isalan a dak-z-imǝl.» ");
INSERT INTO ttq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ibaz kumanda ǝfus n ǝbi, igmad dǝr-ǝs aytedan, issǝstan-tu, inn-as: «Mas tareɣ a di-tu-tǝmǝla?» ");
INSERT INTO ttq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Inn-as ǝbi: «Kǝl-Ǝlyǝhud ǝgân eɣaf fǝl a daɣ-ak ǝgmǝyan tufat ad tǝssǝbdǝda Bulǝs dat Asaggawar-nasan wa Zǝwwǝran, almat ǝrân ad aššaggaran taɣara-net s ǝlluɣ. ");
INSERT INTO ttq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","A dasan-wǝr-tarḍa fǝlas wiyyad daɣ-san ogarnen ǝkkozat tǝmǝrwen n alǝs a das-za-bǝkǝmmǝtnen y ad agin iman-net. Ǝhâdan as wǝr zʼatšin za wǝr zʼašwin iket wǝr ǝgen adi. Simatagan ǝmǝrǝdda, wǝr ǝqqelan ar y a t-id-tayya sǝr-san.» ");
INSERT INTO ttq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Irɣam kumanda y ǝbi wen fǝl amel y awedan waliyyan isalan win das-iga den, amaran issǝgl-ay. ");
INSERT INTO ttq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dǝffǝr awen iɣra-du kumanda ǝššin kabtanatan, inn-asan: «Sǝmmutǝgat sanatat tǝmad ǝn soji d ǝssayat tǝmǝrwen ǝn soji daɣ win ǝggannen ǝggǝsan ǝd sanatat tǝmad daɣ win ǝttafnen allaɣan; y ad akkin Qaysarǝya dǝffǝr tǝsudǝsen. ");
INSERT INTO ttq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Tǝsǝmmutǝgam deɣ šisǝnay šin zʼiwǝn Bulǝs, tǝšǝššiwǝdam-t-in Felikǝs wa n ǝnaxkim daɣ alxer.» ");
INSERT INTO ttq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Amaran iktab-as-in kumanda širawt inn-as-in: ");
INSERT INTO ttq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Awa nak Klawdǝyus Lusǝyas din-ihulan ǝnaxkim Felikǝs ǝknêɣ saɣmar. ");
INSERT INTO ttq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Alǝs di, a ǝbazan Kǝl-Ǝlyǝhud, as zama ǝgân iman-net as tan-in-oseɣ ǝddewaɣ ǝd sojitan. As di-ǝggazan salan n as awedan n Ǝrrum a imos, ǝgeq-qu daɣ adag a daq-q-in wǝr ikka arat. ");
INSERT INTO ttq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dǝffǝr awen ewayaq-qu s Asaggawar-nasan wa Zǝwwǝran fǝl ad ǝssǝnaɣ lahan wa t-ǝssǝwaran. ");
INSERT INTO ttq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ǝnayaɣ as, arat iqqâlan ǝššǝriɣa wa-nasan ɣas a fǝl tu-ɣattasan, wǝrgeɣ arat a t-issiwaran tamattant wala iguz ǝn kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mišan as ǝsleɣ as ǝgân Kǝl-Ǝlyǝhud eɣaf fǝl ad agin iman-net, ǝssokaɣ-ak-in ǝddi da, ǝntanay amaran ǝnneɣ-asan a sǝr-ǝk in-awǝyan kay šiɣǝttas šin t-ǝgan.» ");
INSERT INTO ttq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ǝgan sojitan awas tawamaran. Ǝglan ahad wen da, ǝddewan ǝd Bulǝs har osan aɣrǝm n Antifatris. ");
INSERT INTO ttq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","As ǝzǝl wa dǝffǝr wen ǝqqalan-du sojitan win jawankatnen barǝki-nasan, ǝglan win ǝwannen ǝggǝsan ǝd Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","As din-osan aɣrǝm ǝn Qaysarǝya, ǝgan širawt tanad daɣ ǝfus n ǝnaxkim, ǝssǝbdadan dat-ǝs deɣ Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Iɣr-et, amaran issǝstan Bulǝs d akal wa t-ilan. As issan as akal ǝn Kilikǝya a t-ilan, ");
INSERT INTO ttq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","inn-as: «As d-osan aytedan win kay-ǝɣtasnen, a kay-du-sassaɣra.» Tǝzzar omar s ad itǝwǝttǝf Bulǝs daɣ ahan ǝn tǝmǝnukǝla was kala t-issǝkras ǝmǝnokal Herod. ");
INSERT INTO ttq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sǝmmos adan dǝffǝr awen, osa-du Ananǝyâs wa n Ǝlimam wa Zǝwwǝran, iddew-du d arat daɣ ǝmɣaran ǝn Kǝl-Ǝlyǝhud d alǝs a d-ǝwwikkalan Kǝl-Ǝlyǝhud igân esǝm Tertulǝs. Ǝɣtasan Bulǝs ɣur ǝnaxkim n akal Felikǝs. ");
INSERT INTO ttq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tǝzzar itawaɣra-du Bulǝs, amaran issǝnta Tertulǝs daɣ amel n aratan win as ǝnnan Kǝl-Ǝlyǝhud iɣšâd-tan, inna: «Ya ǝmizwar Felikǝs, ǝddǝlil-nak d ǝddǝlil n aratan win tǝgeɣ a fǝl igraw akal wa alxer aggen, amaran tǝgeɣ ǝnnizam olaɣan i tamattay-nana fǝl aššaddat ǝn tǝla-nak ǝgǝrri. ");
INSERT INTO ttq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nǝtigudǝy-ak wǝllen daɣ adag kul aratan olaɣnen kul win tǝgeɣ, ya ǝmizwar Felikǝs! ");
INSERT INTO ttq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Wǝr areɣ a kay-sǝḷḷuleɣ, batu-nana ši gǝzzulat, mišan ǝgmâya daɣ-ak fǝl ǝddǝlil n ǝlluɣ-nak a dǝr kay-nǝzdây a dana-tǝssǝsǝma. ");
INSERT INTO ttq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nǝnây as alǝs a, ǝlmǝssibat a imos, igammayan d ǝsǝffǝllǝg ǝn Kǝl-Ǝlyǝhud edag ǝhan daɣ ǝddǝnet, imos deɣ ǝmuzar ǝn taggayt n arat n aytedan as itawannu Nazaritatan. ");
INSERT INTO ttq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Wala Ehan wa Zǝwwǝran n Ǝlɣibada da, igmây d ǝsǝmmǝdǝs-net; nǝbaz-tu. Nǝrâ a das-nagu ǝššǝriɣa wa-nana, ");
INSERT INTO ttq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","mišan os-ana-du kumanda Lusǝyas, ibaz-tu daɣ-na s assahat, ");
INSERT INTO ttq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","omar deɣ a dat-ǝk ǝbdǝdan aytedan win ǝɣtasnen Bulǝs. Kay iman-nak as tu-tǝssǝstana, ad tǝnǝya tidǝt ǝn tǝɣǝttas kul šin das-nǝga.» ");
INSERT INTO ttq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tǝzzar ǝrḍan Kǝl-Ǝlyǝhud ǝd batu ǝn Tertulǝs, ǝnnan tidǝt a tǝmos. ");
INSERT INTO ttq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Isaddagan ǝnaxkim i Bulǝs ad iššiwil. Inna Bulǝs: «Isidawat-i a dat-ǝk aga batu tas ǝgmǝyaɣ aggaz ǝn man-in, fǝlas ǝssânaɣ ǝmǝnokal-in as, irǝw tǝmosaɣ amašraɣ ǝn tamattay n akal wa. ");
INSERT INTO ttq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kay iman-nak tǝfrâgaɣ ad tǝssǝnaɣ kud tidǝt wala bahu as, a ilân maraw adan d ǝššin ad ǝggǝzzayaɣ ǝs Yerusalam y a daɣ-as ǝɣbǝda Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wǝrmâd a di-ǝnâyan daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, wala daɣ nan win ǝlɣibada, wala deɣ daɣ ǝɣrǝm, mišawala d awedan waliyyan za wala jinajarwayaɣ tamattay. ");
INSERT INTO ttq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Aytedan win, wǝr ǝfregan ǝsǝbdǝd ǝn tǝɣǝttas šin di-ǝgan da. ");
INSERT INTO ttq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mišan ya ǝrḍeɣ s arat iyyanda, amaran ad t-anna dat-ǝk, a t-imosan as: Mǝššina di n Ǝmǝli ǝn marawan-nana as ǝlkama ǝs tǝmǝwit tas tu-tǝnna tarrayt ta n Ǝlmǝsix Ɣaysa, tas gannin ǝntanay taggayt. Ǝzzigzanaɣ s arat kul wa iktaban daɣ Ǝttǝwret d Ǝlkǝttaban n Ǝnnǝbitan. ");
INSERT INTO ttq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ǝgêɣ attama wa daɣ Mǝššina, amaran ǝntanay da ǝgân-tu, a t-imos as tǝll-ay tanakra daɣ tamattant, gǝr za y aytedan win oɣadnen wala win wǝr noɣed. ");
INSERT INTO ttq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Adi a fǝlas faw da gammaya nak da wǝllen a di-wǝr-tǝggǝz tǝrǝk n a labasan dat Mǝššina wala deɣ dat aytedan. ");
INSERT INTO ttq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","A ilan elan ad ǝgmadaɣ Yerusalam, as ǝmǝrǝdda ǝqqala-du y a d-awǝyaɣ i tamattay-nin širgiten, aga deɣ šikutawen šin izzǝlzam Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Awa da a ǝheɣ as di-d-osan Kǝl-Ǝlyǝhud win Asǝya daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, ǝssindaɣ arat wa di-issǝwar ǝššǝriɣa daɣ salan n ǝzǝzdǝg-in; wǝrmad ɣur-i tǝlla tamattay za wala ǝssinkara ajeqqaɣ n aytedan. Ǝntanay as ihor a dat-ǝk ǝbdǝdan, ǝɣtǝsan-i ɣur-ǝk, kud ǝnta ǝlân ǝddǝlil waliyyan, ");
INSERT INTO ttq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","madeɣ ǝmǝlan aytedan win ǝllanen da lahan was inna Asaggawar wa Zǝwwǝran ǝgêq-qu alwaq wa dat-ǝs ǝbdada, ");
INSERT INTO ttq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","a wǝr nǝmos as ǝnneɣ gar-essan s afalla: \"Wǝr di-issǝbdad dat-wan azalada y a di-tǝšrǝɣam ar fǝl as ǝzzǝgzanaɣ as ilkâm a d-ǝnkǝran nǝmmǝttan.\"» ");
INSERT INTO ttq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikǝs ǝhân salan wǝllen ǝn tarrayt ta n Ǝlmǝsix Ɣaysa, as isla i batu ten, izzǝraz ǝššǝriɣa har iyyan ǝzǝl, inna: «As d-osa Lusǝyas wa n kumanda ad ǝxtǝsa ǝššǝriɣa-nawan.» ");
INSERT INTO ttq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tǝzzar omar Felikǝs kabtan s ad agǝz Bulǝs, mišan ad wǝr itǝwǝdgǝz, wala itǝwǝgdǝl y aytedan-net a daɣ-as ǝssǝnan. ");
INSERT INTO ttq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Arat n adan dǝffǝr awen, osa-du Felikǝs iddew ǝd tǝntut-net Drusilla, tǝmosat wǝlǝt ǝlyǝhud; tǝzzar isassaɣra-du Bulǝs, issǝsam i salan win itaggu daɣ batu n ǝzǝgzan s Ǝlmǝsix Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mišan as d-ewad Bulǝs isalan win ǝqqalnen taqqat d ǝnudi daɣ man d ǝššǝriɣa ǝn Mǝššina wa d-izayan, tǝggaz tasa Felikǝs, inn-as: «Ǝmǝrǝdda aglu, as ǝgrawa tǝmazayyat n a dǝr-ǝk mǝšiwala, a kay-d-ǝlǝsaɣ ǝsǝssǝɣri.» ");
INSERT INTO ttq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A itaggu Felikǝs awen, igâ attama daɣ ad t-akfu Bulǝs azrǝf, adi fǝl t-id-isasaɣru itaggu dǝr-ǝs takkayt. ");
INSERT INTO ttq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Awen da a igan har ǝgan ǝššin elan. Igmad Felikǝs tizart, iggaz Borkǝyǝs Festus edag-net. Oyya-du Bulǝs daɣ kasaw fǝl ad agu tǝnǝfust i Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","As iga Festus karad adan d iguz ǝn tizart ǝn Yahudǝyya, igmad aɣrǝm ǝn Qaysarǝya, iggǝzzay ǝs Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","As din-osa, ǝmmǝnayan dǝr-ǝs muzaran ǝn limaman ǝd muzaran ǝn Kǝl-Ǝlyǝhud, ǝɣtasan ɣur-ǝs Bulǝs. A tu-tansayan, ");
INSERT INTO ttq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","a dasan-agu tǝnǝfust n ad d-issuku Bulǝs Yerusalam y a daɣ-as išrǝɣ. A gannin awen, ǝntanay ǝgân eɣaf fǝl a das-bǝkǝmmen daɣ tarrayt, agin iman-net. ");
INSERT INTO ttq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mišan inn-asan Festus: «Bulǝs kasaw wa n Qaysarǝya a daɣ itawattaf, amaran ǝnta iman-net ad iqqǝl tarmâd. ");
INSERT INTO ttq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Daɣ adi idawanet dǝr-i muzaran-nawan ǝs Qaysarǝya, ǝɣǝtǝsanet-tu den da kud ill-ay a iɣšâd.» ");
INSERT INTO ttq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Iga Festus daɣ Yerusalam adan ǝllanen gǝr ǝttam ǝd maraw, amaran iqqal Qaysarǝya. As ǝzǝl wa dǝffǝr wen, iqqim daɣ adag wa daɣ iššarraɣ, tǝzzar omar s a dat-ǝs itǝwǝsǝbdǝd Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","As d-osa Bulǝs ɣalayɣalayan-tu Kǝl-Ǝlyǝhud win d-ǝgmadnen Yerusalam, a tu-ɣattasan sawaran-tu igi n aratan aggotnen labasnen as wǝr ǝfregan ǝsǝttǝddi-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Iššewal Bulǝs y ad agǝz iman-net, inna: «Nak wǝr ǝgeɣ ark amazal waliyyan immâran ǝššǝriɣa ǝn Kǝl-Ǝlyǝhud, za wala Ehan wa Zǝwwǝran n Ǝlɣibada wala deɣ ǝgeq-qu i Qaysara ǝmǝnokal wa zǝwwǝran.» ");
INSERT INTO ttq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus irân igi ǝn tǝnǝfust i Kǝl-Ǝlyǝhud, inna i Bulǝs: «Awak tǝrḍeɣ s ad taggazzayaɣ ǝs Yerusalam dak-daɣ-as-ǝšrǝɣa aratan win di?» ");
INSERT INTO ttq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Inn-as Bulǝs: «Kala, kala! Edag n ǝššǝriɣa wa, in Ǝrrum; daɣ adi da da ad za tǝwǝšrǝɣa. Wǝr ǝɣšedaɣ arat waliyyan i Kǝl-Ǝlyǝhud, kay iman-nak tǝssânaɣ wǝllen daɣ adi. ");
INSERT INTO ttq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kud ǝššǝriɣa a ǝmmǝzraya, madeɣ ǝgeɣ arat a di-issiwaran tamattant, ǝrḍdeɣ ǝs tamattant. Mišan kud aratan win as itawanna ǝɣšâdaq-qan bahu a ǝmosan, wǝdi wǝr t-illa awedan ilân tarrayt n a di-agu daɣ fassan-nasan. Amaran, dad zamas adi a igan, wǝdi ǝmǝnokal Qaysara as areɣ a di-išrǝɣ.» ");
INSERT INTO ttq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Imaššawwar Festus ǝd mǝššewwar-net, amaran inna i Bulǝs: «Ǝmǝnokal Qaysara as tǝreɣ a dak-išrǝɣ, a tu-takka za.» ");
INSERT INTO ttq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Arat n adan dǝffǝr awen, osa-du ǝmǝnokal Agriffa aɣrǝm ǝn Qaysarǝya, iddew ǝd tamadrayt-net tǝgât Bernikǝs fǝl ad ǝssǝslǝman Festus agin-as alafǝyet d assa. ");
INSERT INTO ttq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Adan aggotnen win ǝgan den, idkal-du daɣ-san Festus y ǝmǝnokal Agriffa isalan ǝn Bulǝs, inn-as: «Illa alǝs da, a d-oyya ǝnaxkim Felikǝs daɣ kasaw. ");
INSERT INTO ttq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Alwaq wa d-ǝkkeɣ Yerusalam, ǝɣtasan-tu ɣur-i muzaran ǝn limaman d ǝmɣaran ǝn Kǝl-Ǝlyǝhud, ǝgmayan daɣ-i a t-ǝzzǝbǝza s ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mišan ǝnneɣ-asan, ǝššǝriɣa wa n Kǝl-Ǝrrum wǝr itibǝz awedan ar s ad išrâɣ. Kundaba innǝbdad awedan d aytedan win t-ǝɣtasnen, agǝz iman-net daɣ arat wa itawasawar. ");
INSERT INTO ttq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Adi a fǝl dǝr-i d-ǝddewan ǝs Qaysarǝya. Ose-du ɣas, as ǝzǝl wa dǝffǝr wen ǝqqima daɣ adag wa n ǝššǝriɣa omara s a d-ammaway alǝs wen. ");
INSERT INTO ttq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ǝbdadan meddan win t-ǝɣtasnen, mišan wǝr t-ǝssǝwaran arak ǝmazal labasan waliyyan daɣ win ǝɣila. ");
INSERT INTO ttq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Awa zaɣnin tǝmazaq ɣas tǝgât daɣ batu n ǝddin-nasan ǝd salan n alǝs iyyan igân esǝm Ɣaysa abâ, mišan igla Bulǝs immâl as iddâr. ");
INSERT INTO ttq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nak iman-in wǝr ǝssenaɣ ǝmmǝk was zʼǝšrǝɣa ǝzzǝnǝf n aratan win den, adi a fǝl ǝssǝstanaɣ Bulǝs kud irḍa s ad akku Yerusalam išrǝɣ daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mišan issof a das-išrǝɣ Qaysara s ǝnta ǝmǝnokal wa dǝnnǝg mǝnokalan. Adi a fǝl omara s ad itǝwigǝz har t-itǝwǝsuku.» ");
INSERT INTO ttq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Amaran inna Agriffa i Festus: «Nak da areɣ ad asla y alǝs wǝdi.» Inn-as Festus: «Tufat a das-taslaɣ.» ");
INSERT INTO ttq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ǝzǝl wa dǝffǝr wen iga-du ǝmǝnokal Agriffa assa wa n mǝnokalan ǝnta ǝd tamadrayt-net Bernikǝs. Ǝggazan ehan wa n ǝššǝriɣa ǝddewan ǝd kumandatan ǝn sojitan ǝd mizwaran n ǝɣrǝm. Omar Festus s a d-ammaway Bulǝs, tǝzzar immeway-du. ");
INSERT INTO ttq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Amaran inna Festus: «Ǝmǝnokal Agriffa, ǝd kawanay ketnawan win ǝmmǝnaynen da, ǝnta da alǝs was ǝddǝlil-net a fǝl di-d-osan Kǝl-Ǝlyǝhud kul, daɣ Yerusalam harkid deɣ da da, gannin s afalla wǝr immǝkkan ad ilǝs tǝmǝddurt. ");
INSERT INTO ttq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Amaran nak za, wǝr ǝnayaɣ as iga ǝmazal waliyyan a t-issiwaran tamattant, mišan dad zamas ǝnta iman-net a igmayan a das-išrǝɣ ǝmǝnokal wa dǝnnǝg mǝnokalan, wǝdi ǝge tanat tǝmosat a das-t-ǝssuka. ");
INSERT INTO ttq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Dǝr iga awen da ya, wǝr ǝssenaɣ fǝl arat waliyyan igmâd aššak daɣ talɣa-net a din-z-ǝktǝba y ǝmǝnokal wa dǝnnǝg mǝnokalan. Adi a fǝl t-ǝssǝbdada dat-wan, wǝllen kay ǝmǝnokal Agriffa, fǝl a tu-nǝssǝstǝn, ǝssǝnaɣ awa zʼǝktǝba daɣ talɣa-net; ");
INSERT INTO ttq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","fǝlas wǝr sǝr-i ila almaɣna ad ǝssuka Qaysara amaskasaw as din-wǝr-ǝmelaɣ ǝddǝlil wa fǝl itawattaf.» ");
INSERT INTO ttq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Inna Agriffa i Bulǝs: «Tǝgrawa turagat n awal, tagǝzaɣ iman-nak.» Tǝzzar izzal Bulǝs ǝfus-net y a das-tǝssǝsǝm tamattay, inna: ");
INSERT INTO ttq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ya ǝmǝnokal Agriffa, ǝbbǝlǝl zǝwwǝran a di-tǝmos tahakkay ta di-tǝgeɣ azalada turagat n aggaz ǝn man-in daɣ aratan kul win as ǝnnan Kǝl-Ǝlyǝhud ǝɣšadaq-qan, ");
INSERT INTO ttq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","wǝllen as ǝhân-kay salan wǝllen n alɣadaten-nasan kul d aratan kul win fǝl tamazaɣan. Daɣ adi, onsayaq-qay ad taga tazaydart, tǝssǝsǝmaɣ-i. ");
INSERT INTO ttq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kǝl-Ǝlyǝhud kul ǝzdâyan-i harwa ɣur tǝmmǝdrǝyt-in. Ǝssânan daɣ awa ǝgeɣ kul daɣ tamattay-nin harkid deɣ daɣ Yerusalam. ");
INSERT INTO ttq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Irǝw as di-ǝzdayan, amaran as imos as ǝrḍân, ǝfrâgan a dak-aggayyen as, taggayt ta n Farisaytan a ǝheɣ, s ǝnta a togarat ǝzǝzzǝwi daɣ ǝddin-nana. ");
INSERT INTO ttq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ǝmǝrǝdda nak da ibdadan da šarraɣa fǝlas ǝgeɣ attama daɣ arkawal wa iga Mǝššina i marawan-nana. ");
INSERT INTO ttq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Attama en da a ǝganat tawšeten-nana an marawat ǝd sanatat, eway-du sǝr-ǝsnat awen ǝlɣibada ǝn Mǝššina ǝs gǝlleyat ehad ezal, ǝqqâlnat y ad andu. Ya ǝmǝnokal-in, Agriffa, attama en da za, a fǝl di-ǝɣtasan Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ma fel as dawan-orna kawanay Kǝl-Ǝlyǝhud ǝzǝgzan âs Mǝššina ilkâm ad d-issǝnkǝr inǝmmǝttan? ");
INSERT INTO ttq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nak iman-in, kala a ɣur-i illa as, iwâr-i igi n arat kul wa ǝfraga fǝl a din-anɣa esǝm ǝn Ɣaysa wa n Nazaret. ");
INSERT INTO ttq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Arat wen iman-net a ǝgeɣ daɣ ǝɣrǝm ǝn Yerusalam. Ǝkfan-i daɣ-as muzaran ǝn limaman turagat, tǝzzar ǝbazaɣ inalkiman ǝn Ɣaysa aggotnen ǝgeq-qan daɣ kasaw. Ǝwâraɣ aganna ǝn win tan-ǝbaznen s ǝššǝriɣa wa n tamattant ta n kǝrǝz. ");
INSERT INTO ttq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ǝyyǝwanaɣ ilum gǝr nan ǝn Kǝl-Ǝlyǝhud win ǝlɣibada tawaddabaq-qan, šahaššalaq-qan ǝbudǝr ǝn Ɣaysa. Awa dasan-ǝge daɣ gezzar, lakkamaɣ-asan ǝs ɣǝrman ǝn kallan win tamawen. ");
INSERT INTO ttq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ǝzǝl iyyan ǝššokala daɣ awen da ǝkkeɣ Damas, ǝgrâwa turagat ɣur muzaran ǝn limaman n igi n awen imos as ǝntanay a di-ǝganen daɣ ǝššǝɣǝl wen. ");
INSERT INTO ttq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ya ǝmǝnokal-in, ewâyaɣ ǝd tarrayt ammas n azal wala a ihogan ǝnayaɣ ǝnnur a d-igmâdan ijǝnnawan ogaran wa n tǝfuk ǝmǝlǝwlǝw as ibalazzat daɣ ɣǝlǝyɣǝlayan-nana, nak d aytedan win dǝr ǝddewa. ");
INSERT INTO ttq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nuda ketnana, tǝzzar ǝsleɣ i wa di-innan daɣ tǝlɣibrit: \"Talut! Talut! Mas di-tǝzaɣazzaba? Tugǝyt-nak ǝs lǝkkum i tara-nin, wǝr tǝnfa wala; wǝr tǝzlay ǝd ta n ays iddag mǝššis ǝs ɣayman.\" ");
INSERT INTO ttq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ǝnneɣ-as: \"Ǝmǝli, ma tǝmosaɣ?\" Tǝzzar inn-i Ǝmǝli: \"Nak awa, Ɣaysa wa tǝzaɣazzaba. ");
INSERT INTO ttq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mišan ǝnkǝr, tǝbdǝdaɣ, fǝlas ǝnifalalaɣ-ak fǝl a kay-aggaɣ amaššaɣal-in ǝd tǝgǝyya-nin a za taggayyet y aytedan anay wa di-tǝgeɣ, taggayyeɣ-asan deɣ awa kay-z-assakna dǝffǝr awa. ");
INSERT INTO ttq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","A kay-aggaza daɣ Kǝl-Ǝlyǝhud, ǝd tǝmattiwen šin tan-wǝr-nǝmos, ǝzǝmmizǝlaq-qay sǝr-san, ");
INSERT INTO ttq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","fǝl ad tara šittawen-nasan, tǝkkǝsaq-qan-du daɣ šiyyay s ǝnnur, ǝgmǝdan-du tarna ta n Iblis ǝlkǝman i Mǝššina, fǝl ad ǝgrǝwan tǝsureft ǝn bakkadan-nasan, ǝgrǝwan deɣ tadagart daɣ mizdagan ǝs tarrayt n ǝzǝgzan sǝr-i.\" ");
INSERT INTO ttq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ya ǝmǝnokal Agriffa, ǝddǝlil wǝdi a fǝl wǝr ǝmmǝzrayaɣ awa di-d-inafalalan, igmâd-du ijǝnnawan. Igi ǝn Mǝššina a imos. ");
INSERT INTO ttq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kalar azzaraɣ ǝs Kǝl-Ǝlyǝhud win Damas ǝd win Yerusalam, d aytedan win Yahudǝyya ketnet, d aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud, taggaɣ-asan tǝlxutbat gannaɣ-asan, iwâr-tan ad utaban, ahdin-du ǝs Mǝššina, agin imazalan ǝssiknanen tǝtub-nasan. ");
INSERT INTO ttq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ǝddǝlil n awen da a fǝl di-ǝbazan Kǝl-Ǝlyǝhud daɣ Ahan wa Zǝwwǝran n Ǝlɣibada, ǝgmayan ǝd tanaɣay-nin. ");
INSERT INTO ttq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tadhǝlt ta di-iga Mǝššina a di-du-tǝšaššawadat ǝzǝl wa n azalada, tebadday ta ǝge da taggaɣ isalan-net y aytedan gǝr win wǝr nǝla almaqam, wala win t-ǝlanen, wǝr d-ǝššotaɣ wala daɣ salan ǝn was ǝmalan ǝnnǝbitan sa hadan d ǝnnǝbi Musa âs a d-asu; ");
INSERT INTO ttq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","a t-imosan as, Ǝlmǝsix ilkâm ad inǝy alɣazab, iba-tu, izar-du deɣ i nǝmmǝttan tanakra, imǝl ǝnnur wa ihakku Mǝššina, imosan isalan n ǝlɣillas, i Kǝl-Ǝlyǝhud d aytedan win tan-wǝr-nǝmos.» ");
INSERT INTO ttq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Harwada iššewal Bulǝs, išarraɣ fǝl man-net, as idkal Festus ǝmǝsli-net, inna: «Kay Bulǝs ǝmmǝskǝl a tǝgeɣ, igǝt ǝn taɣaray ta tǝgeɣ isammaskal-kay.» ");
INSERT INTO ttq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Inn-as Bulǝs: «Ǝmizwar Festus, nak wǝr ǝmmǝskala. Kalar awa ganna da, tidǝt a imos, tǝkfât ǝs tayttay. ");
INSERT INTO ttq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Amaran ǝmǝnokal Agriffa ǝhân-tu salan win di. Adi a fǝl wǝr ǝksudaɣ igi-nasan dat-ǝs, fǝlas ǝkkâsaɣ aššak as, wǝr tan-iha waliyyan a das-ijhâlan, id wǝr tawaggan daɣ ǝssir. ");
INSERT INTO ttq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ǝmǝnokal-in Agriffa awak tǝzzigzanaɣ s awa ǝnnan ǝnnǝbitan? Ǝssânaɣ as tǝzzigzanaɣ sǝr-ǝs.» ");
INSERT INTO ttq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tǝzzar inna Agriffa i Bulǝs: «Torda-nak a di-taga ǝlmǝsixi fǝl arat n amazay!» ");
INSERT INTO ttq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Inn-as Bulǝs: «Gǝr za fǝl arat n amazay wala, ǝgmâya daɣ Mǝššina a kay dǝr-i išaššalan, kay harkid aytedan kul win di-ǝssǝsamnen da azalada, as wǝr ǝhen sassaran win.» ");
INSERT INTO ttq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tǝzzar inkar ǝmǝnokal Agriffa ǝd Festus wa n ǝnaxkim ǝd Bernikǝs d aytedan kul win dǝr naɣaman, ");
INSERT INTO ttq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ǝgmadan tinǝmǝnnin gar-essan: «Alǝs wen wǝr iga arat waliyyan as ihor a fall-as ammat wala deɣ iggǝz fall-as kasaw.» ");
INSERT INTO ttq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Amaran inna Agriffa i Festus: «Alǝs wen ǝnnar wǝr igmay a das-išrǝɣ Qaysara ǝmǝnokal wa zǝwwǝran, itǝwǝyyu.» ");
INSERT INTO ttq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","As itawanna ad nǝggǝz aɣlal n aman nakku akal n Italǝya, itawagga Bulǝs ǝnta ǝd wiyyad imǝskǝsa daɣ ǝfus ǝn kabtan iyyan igân esǝm Yulǝyus ihân egan ǝn sojitan as itawannu «Wa n Qaysara». ");
INSERT INTO ttq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tǝzzar nǝggaz aɣlal n aman n ǝɣrǝm n Adramutenǝs ikkân ikallan n Asǝya win ǝwarnen efay n agaraw. Ih-âna Aristarxus imosan awedan n ǝɣrǝm ǝn Tesalonik n akal wa n Masedonǝya. ");
INSERT INTO ttq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","As ǝzǝl wa dǝffǝr wen, nǝzzǝbbat daɣ ǝɣrǝm ǝn Sidon. Yulǝyus imosan awedan isâknin Bulǝs ǝlluɣ, ikf-ay turagat n ad akku imidawan-net win ǝhanen aɣrǝm wen fǝl a daɣ-as ǝssǝnan. ");
INSERT INTO ttq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","As dǝr-naɣ igmad ǝɣlal n aman Sidon, nǝllil ǝsǝlim n agaraw daɣ nǝha ifi n akal imosan gǝrwǝtlan as itawannu Qibrus fǝlas aḍu dǝr nǝmmǝqqas. ");
INSERT INTO ttq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Dǝffǝr awen, nǝššokal fǝl agaraw was iwar akal ǝn Kilikǝya ǝd wa n Banfilǝya tama-net, newad-in aɣrǝm ǝn Mira ihân akal wa n Lukǝya, nǝzzǝbbat daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Igraw daɣ-as kabtan wa dǝr nǝddew iyyan aɣlal n ǝɣrǝm n Alaskandrǝya, itakkin akal n Italǝya, ig-ana daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nǝga adan aggotnen nǝsilalam fǝl aman sollan, gǝrrid as din-nǝhoz aɣrǝm ǝn Kǝnidos. Tǝgdal-ana assahat n aḍu ad naglu daɣ anamod wen, tǝzzar nǝnnamad akal imosan gǝrwǝtlan as itawannu Kǝret. As nokay fǝl Salmone, nǝmmodaɣ i Kǝret, nǝggaz ifi-net. ");
INSERT INTO ttq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gǝrrid as nǝllil ǝsǝlim n agaraw har newad edag igân esǝm «Izǝzzǝbba win Hossaynen n ǝɣlalan» inimahazan d ǝɣrǝm ǝn Lasaya. ");
INSERT INTO ttq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Isiḷalat-ana ǝšikǝl wen wǝllen, ǝšikǝl daɣ ǝɣlal n aman deɣ ǝmǝrǝdda iggaz-tu alɣarar, fǝlas wala ǝzum ǝn Kǝl-Ǝlyǝhud wa n ɣarat okay. Adi a fǝl iga Bulǝs y aytedan win ǝnnodanen daɣ ǝɣlal n aman ǝnnǝsixa, inn-asan: ");
INSERT INTO ttq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Meddan, hannayaɣ as ǝšikǝl-nana ad t-iggǝz iba ǝn taɣara d ǝɣšud zǝwwǝran. Wǝrgeɣ aɣlal n aman ɣas ǝd lalan-net a zʼǝhlǝknen, kalar nakkanay da, ad nǝggǝz tazak ten.» ");
INSERT INTO ttq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mišan issof kabtan iduf ǝn batu ta dasan-iga alǝs wa ewayan aɣlal n aman ǝd wa t-ilan, iduf n ǝnnǝsixa wa dasan-iga Bulǝs. ");
INSERT INTO ttq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Dad imos as azazzabbaw n ǝɣlalan n aman wen wǝr daɣ-as oleɣ ikus ǝn tǝgrǝst, tǝnkar taššam n aytedan win maššaɣalan n ǝɣlal ǝgan tanat ad aglin, ǝgmǝyan d aggad n iyyan aɣrǝm imosan azazzabbaw n ǝɣlalan n aman igân esǝm Fenikǝs ihân akal imosan gǝrwǝtlan as itawannu Kǝret, ǝkkǝsan tagrǝst daɣ ɣayanɣayan-net s iyyan iswâd sa sǝr agala daɣ ataram, wa hadan sa sǝr tamasna daɣ ataram. ");
INSERT INTO ttq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ǝllan den da as d-igar arat n aḍu wa n agala, tǝzzar ǝkkasan y ǝɣlal anaday, ǝglan, sammaḍaɣan y akal imosan gǝrwǝtlan ǝn Kǝret daɣ ǝhozan tǝšǝšwit-net, ǝɣilan ad ǝfrǝgan ǝmǝrǝdda igi n awa ǝran. ");
INSERT INTO ttq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mišan wǝr ǝhogan ǝd teklay as fall-asan du-tǝgar tazafa tǝssohet as itawannu ta n tamasna daɣ dǝnnǝg, tǝgât esǝm Yurakilon, a dasan-du-tǝgât iguz wa n akal ǝn Kǝret. ");
INSERT INTO ttq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Tǝzzar ibat aḍu aɣlal n aman, indar-ana iduf-net, igla dǝr-naɣ ibât-tu aḍu. ");
INSERT INTO ttq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","As nǝggaz ifi n arat n akal imosan gǝrwǝtlan, igân esǝm Kawda, nǝga y arat ǝn tǝɣlalt n aman ilwây aɣlal wa nǝha, tǝmǝwit ta nǝra gǝrrid. ");
INSERT INTO ttq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ǝdkalan-tat-du maššaɣalan n ǝɣlal, ǝgan-tat daɣ ammas n ǝɣlal, tǝzzar ǝssǝɣlayan-du aɣlal n aman ketnet iɣunan zawwarnen otaban-as sǝr-san fǝl a tu-wǝr-zǝmmǝzzǝyan aman. Ǝssǝrasan afǝr wa isakaf aḍu isǝlulǝm fǝl aman fǝl ad agu sollan, fǝlas ǝksudan ad istǝb ǝɣlal y amaḍal daɣ adag igân esǝm Surtis a daɣ gǝzzul agaraw, igla ǝɣlal ibât-tu dǝr-naɣ aḍu. ");
INSERT INTO ttq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Awa tǝga tazafa en daɣ assahat, as ǝzǝl wa hadan a din-ǝggaran maššaɣalan n ǝɣlal ilalan daɣ agaraw fǝl ad ifsas ǝɣlal. ");
INSERT INTO ttq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","As ǝzǝl wa n karad, ǝgaran-in daɣ aman ǝs fassan win-da-nasan isǝssǝkna n ǝɣlal. ");
INSERT INTO ttq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tǝfuk wala etran nǝgâ adan aggotnen wǝr tan-nǝnay. Awa tǝga tazafa en daɣ assahat, nǝkkas fadda attama ǝn man-nana. ");
INSERT INTO ttq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Adan en nǝg-en wǝr t-illa i itšan arat, tǝzzar ibdad Bulǝs daɣ ammas n aytedan, inna: «Meddan, ǝnnar tǝttâfam ǝnnǝsixa wa dawan-ǝgeɣ, taqqamim da wǝr du-tǝgmedam akal wa n Kǝret; ǝddi wǝr kawan-z-igrǝw iba n taɣara wa d ǝhluk wa. ");
INSERT INTO ttq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Amaran ǝmǝrǝdda ǝgmâya daɣ-wan ad wǝr tǝkkesam attama, fǝlas wǝr kawan-iha i zʼǝgmǝdan man-net, mišan ya aɣlal n aman ǝnta a danaɣ-igmǝd. ");
INSERT INTO ttq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ǝndod a di-inafalal angalos ǝn Mǝššina wa di-ilan, ǝheɣ ǝššǝɣǝl-net, ");
INSERT INTO ttq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","inn-i: \"Bulǝs, a kay-wǝr-tǝggǝz tasa, Qaysara wa n ǝmǝnokal wa zǝwwǝran, kundaba tǝbdǝda dat-ǝs išrǝɣ-ak. Amaran ǝnǝy, Mǝššina ig-ak arraxmat tǝmosat aggaz n aytedan kul win dǝr tǝnamaha aɣlal n aman da.\" ");
INSERT INTO ttq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Daɣ adi meddan ad wǝr tǝkkǝsam attama, fǝlas ǝzzigzanaɣ ǝs Mǝššina. Awa di-inna den, ad agu s ǝmmǝk en da. ");
INSERT INTO ttq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amaran kundaba istab dǝr-naɣ ǝɣlal n aman i tǝšǝšwit n akal iyyan imosan gǝrwǝtlan.» ");
INSERT INTO ttq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","As iga adawannay n ahad n ǝzǝl-nana wa n maraw d ǝkkoz tǝgâr fall-ana tazafa, ibât dǝr-naɣ aḍu aɣlal fǝl agaraw igân esǝm Adrǝyatik, ǝnnǝfrayan maššaɣalan n ǝɣlal n aman d as amaḍal wǝr iggug. ");
INSERT INTO ttq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Tǝzzar ǝgaran daɣ aman aɣan y sǝr-ǝs ǝḳǝtan tǝzzǝgrǝt n agaraw. Tǝqqal tǝzzǝgrǝt n aman daɣ adag wen ǝssayat tǝmǝrwen n ǝɣil d ǝkkoz. As ǝgan amazay, ǝlasan taḳḳot, osan-in edag wen tǝmos tǝzzǝgrǝt-net sǝmmosat tǝmǝrwen n ǝɣil ǝd sǝdis. ");
INSERT INTO ttq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tǝggaz-tan tasa n ad infǝl ǝɣlal n aman i tǝhun, tǝzzar ǝgaran daɣ aman daɣ ǝlǝqqam n ǝɣlal ǝkkozat tǝzoliyawen šin as tu-naddayan, amaran ad tattaran a tan-issǝknan ezal. ");
INSERT INTO ttq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ad gammayan maššaɣalan n ǝɣlal n aman ad addaggagan. Tǝzzar ǝssǝrasan taɣlalt n aman ta ǝndǝrrat daɣ agaraw, ǝgan ǝsaru âs a ǝran ad ǝndǝyan eɣaf n ǝɣlal ǝs šiyyad šizoliyawen. ");
INSERT INTO ttq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mišan inna Bulǝs i kabtan ǝd sojitan: «Meddan en, as ǝgmadan aɣlal wa, wǝdi wǝr dawan-t-illa agamad ǝd man-nawan.» ");
INSERT INTO ttq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tǝzzar olayan sojitan iɣunan win ǝqqannen taɣlalt, ǝglan dǝr-ǝs aman. ");
INSERT INTO ttq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","As ibuk azal y igi, igmay Bulǝs daɣ awedan kul ad atšu, inn-asan: «Azalada, ǝzǝl-nawan wa n maraw d ǝkkoz d aššawaša labasan, wǝr t-illa arat as tǝrâm tettay-net, wala iyyan iggâzan imawan-nawan. ");
INSERT INTO ttq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Daɣ adi ǝgmâya daɣ-wan ad tatšim fǝl ad tǝrǝgam, fǝlas wǝr kawan-iha i daɣ in-z-iba wala anzad iyyanda n aɣaf-net.» ");
INSERT INTO ttq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","As inna Bulǝs awen, idkal-du tagǝlla iga igodan i Mǝššina dat-san ketnasan, amaran ikarammat daɣ-as, ad itattu. ");
INSERT INTO ttq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tǝgmad-tan tasa ketnasan, ǝtšan ǝntanay da. ");
INSERT INTO ttq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Awa nǝmos daɣ ǝɣlal en ketnana, sanatat tǝmad n awedan d ǝssayat tǝmǝrwen ǝd sǝdis. ");
INSERT INTO ttq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","As ǝyyǝwanan a din-naqqalan alkama daɣ agaraw fǝl ad ǝssǝfsǝsan aɣlal n aman. ");
INSERT INTO ttq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","As iga azal, ǝnayan maššaɣalan n ǝɣlal as akal wa din-ǝhozan den wǝr t-ǝzdayan. Oggan ǝzazǝl daɣ tǝšǝšwit, ǝnnan ad ǝgmǝyan d a sǝr-ǝs awǝyan aɣlal har das-t-ǝssǝstǝban kud ad ǝfrǝgan awen. ");
INSERT INTO ttq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ǝkkasan šizoliyawen šin ǝndaynen aɣlal, oyyan-tanat-in s aman, oran deɣ iɣunan ǝn katakawtan win sanamadnen aɣlal. Dǝffǝr adi ǝkkasan aḍḍa y ǝfǝr wa ihan dat ǝɣlal fǝl ad t-issǝkǝf aḍu, amaran sannamawalan-tu ǝd tǝgadamayt iha ǝzazǝl. ");
INSERT INTO ttq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mišan ǝnfalan i tageft n ǝzazǝl tǝhât agaraw, ittitay daɣ-as aɣaf n ǝɣlal, imǝzzay d ǝmǝtǝkwǝy; tǝzzar ad tǝrazzu assahat n tǝnazzamaren ǝlǝqqam-net. ");
INSERT INTO ttq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ǝnayan sojitan awen ɣas, namannakan fǝl ad ǝkkǝsan iman daɣ mǝskǝsa fǝl ad wǝr iššǝf waliyyan daɣ-san, addaggag. ");
INSERT INTO ttq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mišan igdal-asan kabtan-nasan igi n awen, fǝlas a ira ad agǝz Bulǝs. Tǝzzar omar kabtan aytedan win ǝsannen ewet n aman, ad tǝrǝggen daɣ agaraw izaran-in ǝs tǝgadamayt. ");
INSERT INTO ttq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Amaran aytedan win hadatnen, ǝntanay omar-tan s ad ǝwǝran katakawtan ǝd gannatan n ǝɣlal win du-nassarnen. Ǝmmǝk en da as ewadan ketnasan tagadamayt n agaraw ǝragan-du. ");
INSERT INTO ttq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","As du-nǝrag daɣ awen, nǝgmad-du aman, itawann-ana akal wen imosan gǝrwǝtlan, esǝm-net Malta. ");
INSERT INTO ttq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ǝssǝknan-anaɣ aytedan n akal wen ǝlluɣ wǝr nǝla tulat. Ǝgan-ana ketnana marhaba, ǝssǝrɣan-ana temsay, fǝlas akonak a iffayan, iga deɣ asamed. ");
INSERT INTO ttq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Iššedaw-du Bulǝs eɣaf n eškan, ig-en daɣ tǝmsay, tǝkkas-du daɣ-san tuksay taššolt, tǝdad ǝfus-net, tǝkarayray daɣ-as. ");
INSERT INTO ttq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","As ǝnayan kǝl akal wen taššolt tǝkirayray daɣ ǝfus ǝn Bulǝs, ad tinǝmǝnnin: «Igmâd aššak as alǝs wen ǝmǝggi ǝn man a imos. Irag-du daɣ agaraw, mišan harwa da ilkâm-as ǝššǝriɣa, wǝr ira ad iddǝr.» ");
INSERT INTO ttq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Irsak-in Bulǝs taššolt, tǝrtak daɣ tǝmsay, wǝr t-illa a t-igrâwan. ");
INSERT INTO ttq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ǝqqalan aytedan y ad ihǝdǝdǝy Bulǝs, madeɣ ifǝtǝqqǝt iba-tu tamazayt ten da; mišan as ǝrǝwan wǝr hǝnnǝyan a t-igrâwan, ǝqqalan-du daɣ awa ǝnnan, ad gannin amaran: «Ǝmǝli iyyan awa!» ");
INSERT INTO ttq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Edag en ǝhoznat-tu tǝwǝgas ǝn Bublǝyǝs, alǝs wa n ǝmuzar n akal wen. Izazzabbat-ana daɣ ahan-net, nǝga karad adan nǝnniftaɣ-as. Ig-ana marhaba ǝd mǝgura ǝknanen ǝlluɣ. ");
INSERT INTO ttq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","As itaggu awen, tǝzizalallat tanaday abba ǝn Bublǝyǝs, tǝrtây-as ǝd tǝdist. Os-ay-in Bulǝs issǝwar-tu ifassan-net, onsay-as Mǝššina. Izzozay-tu. ");
INSERT INTO ttq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Dǝffǝr awen a du-tasin miranan n akal wen win hadatnen, ǝtiwǝzuzǝyan. ");
INSERT INTO ttq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ǝssǝknan-anaɣ aytedan n akal wen saɣmar aggen, as nǝggaz šin teklay daɣ ǝɣlal n aman iyyan. Ǝkfan-anaɣ arat was nǝddǝrar y ǝšikǝl. ");
INSERT INTO ttq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","As nǝga karadat tǝlil daɣ Malta, nǝggaz aɣlal n aman a d-igmâdan aɣrǝm n Alaskandrǝya, as ǝwâran ǝssǝnǝman as itawannu \"win ǝknewan\" eɣaf-net, s ǝnta da akal wen da imosan gǝrwǝtlan a daɣ ikkas tagrǝst, nǝgla. ");
INSERT INTO ttq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","As nosa aɣrǝm ǝn Surakusa, nǝga daɣ-as karad adan. ");
INSERT INTO ttq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nǝgmad Surakusa nǝgla har nosa aɣrǝm ǝn Regǝyon. As ǝzǝl wa dǝffǝr wen, igar-du aḍu wa n agala, nǝgla. As ǝzǝl wa hadan newad aɣrǝm ǝn Batǝyolǝs. ");
INSERT INTO ttq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Den da ad nǝssǝha fǝl arat daɣ nalkiman ǝn Ɣaysa, ǝgmayan daɣ-na a ɣur-san nagu ǝssa adan. Dǝffǝr awen nǝnnǝmad aɣrǝm n Ǝrrum. ");
INSERT INTO ttq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","As danaɣ-ǝslan mǝdrayan-nana daɣ ǝzǝgzan win ǝɣrǝm n Ǝrrum, ǝssǝlkadan-ana-du ǝs tǝɣrǝmt ta n Ǝssuk n Affǝyus, wiyyad ǝssǝlkadan-ana-du ǝs tǝɣrǝmt as itawannu Ta n Karad Zǝzzǝbba. As tan-inay Bulǝs iga igodan i Mǝššina, ikna awen iman-net. ");
INSERT INTO ttq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","As din-nǝggaz aɣrǝm n Ǝrrum, irḍa ǝlxǝkum i Bulǝs s ad iɣsǝr daɣ ahan wǝr inamaha ar ǝd soji wa t-ogazan. ");
INSERT INTO ttq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Karad adan dǝffǝr awen, isassaɣra-du Bulǝs imuzaran ǝn Kǝl-Ǝlyǝhud win ǝɣrǝm n Ǝrrum. As d-ǝddewan inn-asan: «Imǝdrayan-in, nak wǝr nǝɣšed arat waliyyan i tamattay-nana wala deɣ ǝmmizraya alɣadaten šin du-nogaz ɣur marawan-nana, mišan ǝttǝrmasaɣ daɣ Yerusalam, tawagga daɣ fassan ǝn Kǝl-Ǝrrum. ");
INSERT INTO ttq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","As di-ǝšraɣan, ǝran di-ayyin fǝlas wǝr ǝgeɣ arat waliyyan a di-issiwaran tamattant. ");
INSERT INTO ttq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mišan ǝnkaran Kǝl-Ǝlyǝhud ugayan s ad tawayya, iqqal-i ǝššil agamay n a di-išrǝɣ Qaysara ǝmǝnokal wa zǝwwǝran, dǝr iga awen da ya wǝr ǝgeɣ ǝnnǝyat n ad aga i tamattay-nana taɣtǝst waliyyat. ");
INSERT INTO ttq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Adi a fǝl kawan-ǝssǝgmaya, a kawan-ǝnǝya, mǝšiwǝla dǝr-wan. Isassaran win, wǝr sǝr-i tan-d-eway ar as ǝgeɣ attama-nin daɣ was ǝqqalan Kǝl-Israyil.» ");
INSERT INTO ttq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ǝnnan-as: «Nakkanay za, wǝr nǝgrew širawt waliyyat a du-tǝfâlat akal ǝn Yahudǝyya daɣ talɣa-nak wala deɣ os-âna-du iyyan daɣ mǝdrayan-nana daɣ ǝddin, ag-ana isalan-nak madeɣ annu sǝr-ǝk ark arat. ");
INSERT INTO ttq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amaran nǝra a dana-tǝmǝla kay iman-nak awa tǝsamadranaɣ, fǝlas arat iyyanda as danaɣ-ǝhan salan-net as, taggayt ta n tarrayt n Ǝlmǝsix Ɣaysa, wǝr t-illa adag a tat-wǝr-nǝššek.» ");
INSERT INTO ttq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tǝzzar namaggan dǝr-ǝs tǝmastant ǝzǝl iyyan. As d-iɣlay ǝzǝl wen, osan-t-idu s igǝt daɣ ahan wa iha. Iššewal-asan ǝs gǝlleyat daɣ salan ǝn Taɣmar ta n Mǝššina wa n aɣora har iga ahad, isasagr-asan-tat. Isakn-en ǝs tǝmǝwit tǝsisagrat daɣ Ǝttawret ǝn Musa d Ǝlkǝttaban n Ǝnnǝbitan win hadatnen as, awa igannu ǝs Ɣaysa tidǝt daɣ a imos. ");
INSERT INTO ttq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wiyyad ǝssokasan daɣ-san aratan win inna Bulǝs aššak, ǝzzǝgzanan; win hadatnen ugayan s ǝzǝgzan. ");
INSERT INTO ttq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Tǝzzar ǝmmǝzaɣan gar-essan. As ǝggazan šin teklay, inna Bulǝs: «Tidǝt da a inna Infas wa Zǝddigan i marawan-nana daɣ ǝmi n ǝnnǝbi Isayas, as inna: ");
INSERT INTO ttq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"Aglu, akku tamattay en, tannaɣ-as: 'Ad tayyawan ǝsǝsǝm, mišan wǝr ilkem ad tǝgra wala, tayyawan asawad, mišan wǝr ilkem ad tǝnay wala'; ");
INSERT INTO ttq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","fǝlas tamattay di, ǝsǝɣǝr a tǝga ǝwǝl-net, gǝrrid as sallinat tǝmǝzzugen-net, tǝqqân šittawen-net; fǝl ad wǝr tǝnǝy za wala taslu, taqqam da wǝr tǝgra s ǝwǝl-net, ǝngǝm tutab, ǝzzuzǝyaq-qat!\"» ");
INSERT INTO ttq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Dǝffǝr awen, inn-asan Bulǝs: «Ǝssǝnat za as, šimattiwen šin wǝr nǝmos Kǝl-Ǝlyǝhud ǝntanatay da issok-enat-du Mǝššina isalan n efsan-net. Ǝntanatay a dasan-z-ǝssǝsǝmnen.» ");
INSERT INTO ttq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","As inna Bulǝs awen, ǝfalan-tu Kǝl-Ǝlyǝhud, ǝmmizaɣan wǝllen gar-essan. ");
INSERT INTO ttq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Iga Bulǝs ǝššin elan ǝɣrâdnen daɣ ahan ixfâr ǝnta iman-net, itaggu marhaba y aytedan kul win ǝranen anay-net. ");
INSERT INTO ttq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Itagg-asan isalan ǝn Taɣmar ta n Mǝššina, isasaɣr-en deɣ arat kul wa iqqalan Ǝmǝli Ɣaysa Ǝlmǝsix ši wala tasa, wǝr t-illa deɣ awedan a das-igdâlan awen.");
INSERT INTO ttq_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Awa nak Bulǝs akli n Ǝlmǝsix Ɣaysa, itiwaɣran ǝs tišit n anammazul itiwaskat deɣ y igi ǝn salan n Ǝlinjil ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ǝlinjil wen irǝw Mǝššina as iga arkawal-net y ǝnnǝbitan daɣ Ǝlkǝttaban win zaddognen. ");
INSERT INTO ttq_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Isalan n Ǝlinjil win den ǝmmigradan daɣ batu ǝn Barar ǝn Mǝššina a d-ihǝwan daɣ ǝzzurrǝyya n ǝnnǝbi Dawǝd daɣ batu ta tǝqqalat tišit-net aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Daɣ batu amaran ta tǝqqalat Infas wa Zǝddigan ǝn Mǝššina itawaxsab Barar ǝn Mǝššina ǝs tarna s ǝssǝbab ǝn tanakra-net daɣ tǝmattant. Ǝnta a imosan Ɣaysa Ǝlmǝsix Ǝmǝli-nana. ");
INSERT INTO ttq_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tarrayt-net as nǝgraw arraxmat ǝn tišit ǝn nǝmmuzal fǝl a du-nawǝy šimattiwen kul šin wǝr nǝmos Kǝl-Ǝlyǝhud s ǝbǝrdǝg wa d-itaway ǝzǝgzan, fǝl saɣmar n esǝm-net. ");
INSERT INTO ttq_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Šimattiwen šin kawanay da tǝhâm-tanat, kawanay a iɣra Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kattabaɣ-awan-in ketnawan kawanay a ǝhanen aɣrǝm n Ǝrrum tǝmosam win ikna Mǝššina tara tǝtiwaɣram s ad tizdagam. Ǝgmaya daɣ Mǝššina di n Abba-nana d Ǝmǝli Ɣaysa Ǝlmǝsix a dawan-igan arraxmat d alxer. ");
INSERT INTO ttq_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Daɣ tizarat ǝggodayaɣ i Mǝššina ǝs tarrayt ǝn Ɣaysa Ǝlmǝsix daɣ batu-nawan ketnawan id ǝzǝgzan-nawan itiwasla daɣ ǝddǝnet ketnet. ");
INSERT INTO ttq_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Iggiyyat-i Mǝššina a ǝɣbada s ǝwǝl iyyanda s amel wa taggaɣ isalan n Ǝlinjil ǝn Barar-net âs faw tahâm šiwatriwen-in. ");
INSERT INTO ttq_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Faw da gammaya daɣ tǝwatriwen-in ad ǝgrǝwaɣ tǝmǝwit n a kawan-in-asa, as irda Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Tidǝt as ǝkneɣ tara n a kawan-ǝnǝya fǝl a dǝr-wan ǝdrǝwaɣ arat ǝn tǝhǝkkuten šiyyad a d-ǝfalnen Infas wa Zǝddigan fǝl ad tǝgrǝwam ǝzǝzzǝwi daɣ ǝzǝgzan-nawan. ");
INSERT INTO ttq_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Almaɣna as dǝr-wan namaggazaɣ edag, ǝzǝgzan wa nǝla nak dǝr-wan a danaɣ-isǝssuhǝt ketnana daɣ tarrayt ta nǝha, inǝmǝsǝsuhǝt deɣ ǝzǝgzan wa-nawan ǝd wa-nin. ");
INSERT INTO ttq_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ya imǝdrayan-in, areɣ ad tǝssǝnam as ǝyyǝwanaɣ tara n a kawan-in-asa fǝl ad ǝgrǝwa ɣur-wan tǝnfa n ǝššǝɣǝl-in wa n anammazul zun ta ǝgrawa ɣur tǝmattiwen šin hadatnen wǝr nǝmos Kǝl-Ǝlyǝhud. Mišan indar-i awen har harwa. ");
INSERT INTO ttq_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tišit-in anammazul tǝsiwar-i ǝššǝɣǝl daɣ aytedan kul gǝr Kǝl-Ǝlyunan as ǝmoranat šittawen-nasan wala win tan-wǝr-nǝmos, gǝr win musanan wala win aljahilan. ");
INSERT INTO ttq_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Awen daɣ a fǝlas sidaranaɣ wǝllen a dawan-agaɣ isalan n Ǝlinjil kawanay da a ǝhanen aɣrǝm n Ǝrrum. ");
INSERT INTO ttq_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Fǝlas wǝr di-imos Ǝlinjil tǝkarakit id tarna ǝn Mǝššina a imos, itaway-du efsan s aytedan kul win ǝzzǝgzannen a obazan ɣur Kǝl-Ǝlyǝhud ikka aytedan win tan-wǝr-nǝmos. ");
INSERT INTO ttq_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Illikan as taqqat ta n Mǝššina tǝnifalal daɣ Ǝlinjil s ǝzǝgzan, amaran s ǝzǝgzan ɣas, id ǝnnan Ǝlkǝttaban: «Awedan wa oɣadan daɣ tarrayt ta n ǝzǝgzan a igarrawan tǝmǝddurt taynayat.» ");
INSERT INTO ttq_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Alham ǝn Mǝššina iffal-du ijǝnnawan itakka-du aytedan kul win wǝr nǝksud Mǝššina d aytedan kul win wǝr noɣed, ǝwâɣan tidǝt ǝgdâlan-as ǝnǝfilal s iba n taqqat-nasan. ");
INSERT INTO ttq_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Fǝlas arat wa ifragan ǝtǝwǝssan daɣ batu ǝn Mǝššina ibbiyyan-asan id Mǝššina iman-net a dasan-t-isannafalalan. ");
INSERT INTO ttq_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Awalla, harwa ɣur ǝxluk ǝn Mǝššina ǝddǝnet da assayfaten-net šin wǝr nǝtǝwǝnǝy, ǝmosnen tarna-net tǝɣlâlat ǝd tišit-net Ǝmǝli, tawahannaynat, ǝmmunnat daɣ igitan-net. Daɣ adi wǝr ǝlen ǝsaru waliyyan a tan-ikkasan, ");
INSERT INTO ttq_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","id ǝssânan Mǝššina mišan wǝr das-ǝgen saɣmar wa dǝr ihor za wǝr das-ǝgen igodan. Kalar oyyan iman-nasan ǝssǝxrakan-tan medranan wǝr nǝnfa wala, ǝjawanken deɣ daɣ šiyyay id iwallan-nasan a ǝɣfalnen. ");
INSERT INTO ttq_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ǝgân iduf n as ǝmosan imalan ǝn tayttay, ǝntanay amaran imeskelan a ǝmosan. ");
INSERT INTO ttq_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ǝnkaran ǝs tanaya ǝn Mǝššina di n Amaɣlol ǝgan daɣ adag-net šaššelanan n aggadǝm wǝr nǝɣlel ǝd gǝḍad ǝd hǝrwan ǝd wǝxsan ǝd dǝmǝrdǝmaran. ");
INSERT INTO ttq_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Awen daɣ a fǝl tan-oyya Mǝššina ǝlkaman y arak deranan-nasan. Ǝmmǝk en daɣ as samadasan iman-nasan ǝs tǝmǝwit tǝsifallasat aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ǝntanay a sammattaynen tidǝt ǝn Mǝššina ǝgan bahu daɣ adag-net, ǝɣbâdan ǝmǝttǝwexlǝk oyyan Wa d-ixallakan. Attamalet esǝm-net har faw! Amin! ");
INSERT INTO ttq_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Awen daɣ a fǝl tan-oyya Mǝššina ǝggâzan tara ǝn man-nasan eway-du sǝr-san awen šifǝllas, har âs šidoden-nasan ab-as tinǝmǝnsinat ǝd meddan, kalar šidoden a dǝr tinǝmǝnsinat, imos awen arat immizrayan ǝttǝbiɣat n aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Meddan deɣ ǝgan awen da. Ab-as tinǝmǝnsin ǝd tǝdoden-nasan, ad tinǝmǝggin ǝzzǝna gar-essan, ǝknân tara n awen. Aytedan win ǝxraknen en, a tan-abǝz ǝššǝriɣa ǝn Mǝššina s attadib wa dǝr ǝhoran mazalan wǝr nǝtǝwǝggu win taggin den. ");
INSERT INTO ttq_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Dad zamas ugayan s ad ǝssǝnan Mǝššina, oyy-en Mǝššina ǝlkaman y arak tayttay-nasan ad taggin imazalan wǝr nǝmmǝkkan. ");
INSERT INTO ttq_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Taggin ǝzzǝnǝfan kul ǝn mazalan wǝr noɣed, d aššar, d attama daɣ a wǝr ǝlen, d ǝzzǝngu ǝd manzaɣ, d igi ǝn man, ǝd kǝnnasan, ǝd tǝkǝrras, ǝd tišit ǝn maksanan. Sawaran aytedan bahu, ");
INSERT INTO ttq_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","akkiyyan igannu ark aratan ǝs wa hadan. Ǝmosan izǝnga ǝn Mǝššina, wǝr ǝlen aladab, tanarbadan, ih-en zazwar ǝn man, gammayan tarrayen kul šin igi ǝn tǝkma. Wǝr ǝbbǝrdagan i marwan-nasan. ");
INSERT INTO ttq_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Wǝr ǝlen tayttay, wǝr ǝɣdelan, wǝr ǝlen tafrǝyt za wǝr tan-tǝha tahanint. ");
INSERT INTO ttq_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ǝknân masnat n ǝššǝriɣa imosan tamattant tǝɣlalat wa issǝnsa Mǝššina i win tagganen imazalan win den. Mišan dǝr iga awen da, ǝssǝrtayan as tamazalan ark aratan win den, d as ǝqbâlan aytedan win tan-tamazalnen. ");
INSERT INTO ttq_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Daɣ adi kay wa ixakkaman y aytedan, ǝssǝn as wǝr dak-tu-tǝlla tǝsureft a tǝqqala da, fǝlas as tǝxakkama y aytedan, wǝdi iman-nak a tǝtabaza s ǝššǝriɣa, id kay iman-nak da tǝtaggaɣ arak mazalan win taggin aytedan win den. ");
INSERT INTO ttq_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Amaran nǝssân as ǝššǝriɣa ǝn Mǝššina was obaz aytedan win tagginen imazalan win den oɣâd. ");
INSERT INTO ttq_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ǝnẓǝr-in daɣ as kay wa ixakkaman aytedan a dǝr-ǝk olanen alxal, wǝr t-illa ǝmmǝk as du-za-tǝrǝga daɣ ǝššǝriɣa wa n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Meɣ ak ǝsǝttǝlkǝk a tǝgeɣ ǝlluɣ ǝn Mǝššina, d ǝllǝllu-net, ǝd tǝzaydart-net, tǝqqima wǝr din-tǝgreɣ as ira a kay-isǝmmǝttǝy s ǝlluɣ-net tutaba? ");
INSERT INTO ttq_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ǝqqǝssu-nak ǝd tugǝyt-nak ǝs tǝtubt a d-ewaynen as itiwǝsǝmutig-ak alɣazab zǝwwǝran ǝzǝl wad zʼizǝmmizǝl Mǝššina alham-net inǝfilǝl ǝššǝriɣa-net oɣâdan. ");
INSERT INTO ttq_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ǝzǝl wen, awedan kul ad t-akfu Mǝššina awa dǝr ahoran mazalan-net. ");
INSERT INTO ttq_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Win ǝganen tǝzaydart za daɣ ǝmazal n awa olaɣan, gammayan s awen ǝtǝwǝsǝɣmǝr ɣur Mǝššina, d ǝdkul, gammayan tǝmǝddurt ta wǝr nǝɣǝrrǝd, win di ad tan-akfu Mǝššina tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amaran win wǝr nǝgǝmmay ar tǝnfa ǝn man-nasan, ǝmosan ǝllid ǝn tidǝt, tamazalan deɣ aratan wǝr noɣed, win di a tan-assaknu Mǝššina aššar n alham-net. ");
INSERT INTO ttq_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Awalla, tǝssust ǝd tǝmǝɣutar ǝllânat-tu y aytedan win tamazalnen talbast a obazan ɣur Kǝl-Ǝlyǝhud ikka win wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Amaran awedan kul wa itamazalan awa olaɣan, wǝdi ill-as-tu ǝtkul d ǝtǝwǝsǝɣmǝr d alxer a obazan ɣur Kǝl-Ǝlyǝhud ikka win wǝr nǝmos Kǝl-Ǝlyǝhud, ");
INSERT INTO ttq_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","fǝlas Mǝššina wǝr itǝggu tǝmǝrit. ");
INSERT INTO ttq_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Adi a fǝlas aytedan kul win tagginen ibakkadan imos as ijhal-asan ǝššǝriɣa wa n Ǝttawret, win di wǝr zʼattarmasan s ǝššǝriɣa wen. Amaran win ǝssannen ǝššǝriɣa wa n Ǝttawret taggin ibakkadan, win di ketnasan a dasan-itǝwǝxkǝm s ǝššǝriɣa wǝdi da. ");
INSERT INTO ttq_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Wǝrgeɣ win sasamnen y ǝššǝriɣa a oɣadnen dat Mǝššina, kalar win sǝr-ǝs tamazalnen ǝntanay a zʼǝgrǝwnen ǝtǝwǝqbal ǝd taqqat ɣur Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud amaran wǝr ǝssenan fǝl ǝššǝriɣa wa n Ǝttawret mišan imazalan win ǝttǝbiɣat-nasan nimannakan d ǝššǝriɣa wa, win di ǝntanay a ǝmosnen ǝššǝriɣa i man-nasan. ");
INSERT INTO ttq_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Saknin s awen as imazalan win as omar ǝššǝriɣa ǝktâban daɣ wallan-nasan. Ǝnnǝyaten-nasan deɣ tagayyatnat awen. Amaran iduf wa namaggan gar-essan assaɣat iyyat tinǝmǝsǝwiran sǝr-ǝs lahan assaɣat iyyat deɣ gammayan sǝr-ǝs ǝnǝmǝsuraf. ");
INSERT INTO ttq_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ǝnta da da awa zʼagin ǝzǝl wad zʼišrǝɣ Mǝššina ǝs tarrayt ǝn Ɣaysa Ǝlmǝsix imazalan n aggadǝm win ǝɣbarnen, s ǝmmǝk was t-inna Ǝlinjil wa ǝmmala. ");
INSERT INTO ttq_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kay wa igannin tǝmosaɣ Ag Ǝlyǝhud tǝffilla fǝl ǝššǝriɣa wa n Ǝttawret, tǝtaggaɣ ibaragan as kay tǝmosaɣ ǝmaray ǝs Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","tǝssânaɣ awa ira Mǝššina, tǝssânaɣ arat wa imosan ǝlmǝxsud id tǝtiwasasaɣra ǝššǝriɣa wen. ");
INSERT INTO ttq_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kay wa ikkasan aššak as tǝmosaɣ ǝmalway ǝn win ǝddǝrɣalnen, tǝmosaɣ ǝnnur i win ǝhanen šiyyay, ");
INSERT INTO ttq_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","tǝmosaɣ ǝmǝsǝsseɣri n aytedan win nǝbbǝnnan, d ǝmǝsǝsseɣri ǝn bararan, tǝgêɣ awen fǝlas tǝnâya daɣ Ǝttawret masnat ǝd tidǝt ǝkmâlnen. ");
INSERT INTO ttq_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Xasil kay wa isasaɣrin aytedan amaran wǝr tǝsǝsǝɣraɣ iman-nak! Kay wa itamaran aytedan s ad wǝr akǝran, mafel tǝtakara? ");
INSERT INTO ttq_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Kay wa itamaran aytedan s ad wǝr agin ǝzzǝna, mafel tǝtaggaq-qu? Kay wa ikǝyaḍan ǝssǝnǝman, mafel tǝgalla tǝtakaraɣ awa ihan idaggan n ǝlɣibada-nasan? ");
INSERT INTO ttq_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kay wa isabaragan fǝl ǝššǝriɣa n Ǝttawret amaran tǝtamazrayaq-qu imos awen iba n safrar n esǝm ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","«Fǝlas esǝm ǝn Mǝššina sammadrayan-tu aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud amaran imazalan-nawan a d-ewaynen awen», s ǝmmǝk was t-ǝmalan Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Illikan as ǝmǝnkǝd tǝh-ay tǝnfa as imos as tǝbbirdaga y ǝššǝriɣa wa n Ǝttawret, mišan as tǝtamazrayaɣ ǝššǝriɣa wen, wǝdi ǝmǝnkǝd-nak wǝr izlay d iba-net. ");
INSERT INTO ttq_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","As imos as awedan wa wǝr nǝmmǝnkad ilkâm y alwajiban n ǝššǝriɣa ibbirdag-asan, awak wǝrgeɣ a das-itǝwǝxsǝb as imminkad? ");
INSERT INTO ttq_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Awedan wa wǝr nǝmmǝnkad amaran ibbirdag y ǝššǝriɣa wa n Ǝttawret, ǝnta dak-z-išrǝɣan kay wa ittafan Ǝttawret tǝmminkada tǝtamazrayaq-qu. ");
INSERT INTO ttq_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Arat wa imosan tidǝt as tišit n Ag Ǝlyǝhud wǝr tǝmos arat iwaran azzahir ɣas, wala ǝmǝnkǝd ɣas. ");
INSERT INTO ttq_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kalar awa ihan ǝwǝl ǝnta a itaggin awedan Ag Ǝlyǝhud amaran ǝmǝnkǝd wa itaggin awedan Ag Ǝlyǝhud ǝwǝl a daɣ itaggu imos arat a d-ifalan Infas ǝn Mǝššina, wǝrgeɣ arat iktaban ɣas daɣ Ǝttawret. Ǝnta di da Ag Ǝlyǝhud wa igarrawan tǝmmalen šin d-ǝfalnen Mǝššina, wǝrgeɣ šin d-ǝfalnen aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Daɣ adi mǝni tat alfaydat ǝn tišit n Ag Ǝlyǝhud, madeɣ mǝni tǝnfa n ǝmǝnkǝd? ");
INSERT INTO ttq_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Tǝnfa-net ši agget daɣ anamod kul, amaran ta zǝwwǝrat âs Kǝl-Ǝlyǝhud ǝntanay as d-iga Mǝššina awal-net daɣ fassan-nasan. ");
INSERT INTO ttq_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Tidǝt as wiyyad daɣ-san ǝmmizrayan Mǝššina. Awak immikkan iba n tǝlɣudǝla-nasan ad tǝsǝmmǝttǝy arat daɣ tǝlɣudǝla ǝn Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kala kala! Itǝwǝqbǝlet as Mǝššina ǝnta a imosan tidǝt, aggadǝm anasbahu. Tišit ǝn Mǝššina tidǝt ǝnta a fǝl ǝnnan Ǝlkǝttaban: «Tǝgrawa taqqat daɣ awal-nak, tǝgrawa tidǝt daɣ ǝššǝriɣa-nak.» ");
INSERT INTO ttq_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mišan ma za nannu as imos as iba n aqqad-nana isannafalal-du aqqad ǝn Mǝššina? Awak Mǝššina imos fall-as iba n aqqad ad izǝmmizǝl alham-net? Illikan as awal wa tagga da taggaq-qu ǝs tayttay ta n aggadǝm. ");
INSERT INTO ttq_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kala, kala! Mǝššina inimaggag d ad imos as wǝr oɣed. Kundaba adi, manǝmmǝk as zʼišrǝɣ y ǝddǝnet? ");
INSERT INTO ttq_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Amaran as imos as bahu-nin isannahal ǝsǝnǝfilǝl ǝn tidǝt ǝn Mǝššina, eway-du awen ǝs tǝbbǝyyan tanaya-net, wǝdi mafel tǝtawaxkam-i tišit n anasbakkad? ");
INSERT INTO ttq_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ma ikma fadda nǝnna: «Mazalatana talbast fǝl a tat-du-tǝgmad tǝnfa?» Arat s ǝnta a sǝr-na gannin arat n aytedan gammaynen a danaɣ-ǝɣšǝdan esǝm. Aytedan win di ǝhoran d ad attarmasan s ǝššǝriɣa ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ma za? Awak nakkanay an Kǝl-Ǝlyǝhud tǝll-ay alfaydat nǝgrâw dǝnnǝg aytedan harwa da? Kala kala, fǝlas nǝjwăr nǝsattadda as ketnana gǝr za Kǝl-Ǝlyǝhud wala aytedan win tan-wǝr-nǝmos, as nǝha tǝla n abakkad, ");
INSERT INTO ttq_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","s ǝmmǝk was ǝnnan Ǝlkǝttaban: «Wǝr t-illa i oɣadan, wala ɣas iyyanda, ");
INSERT INTO ttq_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","wǝr t-illa i igarrin, wǝr t-illa i igammayan masnat ǝn Mǝššina ");
INSERT INTO ttq_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kul ǝxrâkan ǝmmǝk a mosan, ketnasan ǝknân aššar, wǝr tan-iha i itaggan awa olaɣan, wala ɣas iyyanda. ");
INSERT INTO ttq_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Šigarsaten-nasan ǝmosnat zun tǝsǝska ǝnnolamnen, ilsawan-nasan takarrasan sǝr-san aytedan, idǝlay-nasan wǝr ǝɣberan ar assam ǝn taššolt. ");
INSERT INTO ttq_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Imawan-nasan ǝdnâyan batuten samomnen ǝd tulɣant, ");
INSERT INTO ttq_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","idaran-nasan tǝh-en tadasayt ǝn tanaɣla n ǝzni, ");
INSERT INTO ttq_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ahluk d ǝlmǝssibat ǝwâran tarrayt-nasan, ");
INSERT INTO ttq_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","wǝr ǝzdayan tarrayt ta n alxer. ");
INSERT INTO ttq_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Tǝksǝda ǝn Mǝššina wǝr tǝha wallan-nasan.» ");
INSERT INTO ttq_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ǝnta nǝssân as arat kul wa inna ǝššǝriɣa wa n Ǝttawret, inn-ay y aytedan win ǝllanen daw ǝlxǝkum wa n Ǝttawret fǝl ad affastin mawan kul itǝwǝqbǝl as ǝddǝnet kul obâz-tat ǝššǝriɣa wa n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Fǝlas wǝr t-illa awedan as za tǝtǝwǝqbǝl taqqat-net dat Mǝššina ǝs tarrayt ǝn mazal n awa ihan ǝššǝriɣa, fǝlas ǝššǝriɣa ǝnta a danaɣ-isusunan awa imos abakkad. ");
INSERT INTO ttq_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mišan ǝmǝrǝdda, Mǝššina isinafalal ǝmmǝk was zʼiqbǝl taqqat-nanaɣ da wala tarrayt ta n Ǝššǝriɣa ittiddan daɣ Ǝlkǝttaban. ");
INSERT INTO ttq_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mǝššina iqabbal taqqat ǝs tarrayt n ǝzǝgzan ǝs Ɣaysa Ǝlmǝsix. Amaran aytedan win ǝzzǝgzannen kul iqabbal taqqat-nasan, fǝlas aytedan wǝr ǝzlayan: ");
INSERT INTO ttq_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ketnasan ǝgân ibakkadan aba fall-asan tanaya ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amaran ǝgrâwan taqqat tǝmosat tǝhǝkkut n arraxmat ǝn Mǝššina ǝs tarrayt ǝn tǝdarfit ta du-teway tassaq d Ǝlmǝsix Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ǝnta a d-issǝgla Mǝššina ixkâm-as ad iqqǝl takutay ta tǝmmasat ibakkadan n aytedan ǝs tarrayt n ǝzǝgzan s ǝzni-net. Ǝmmǝk en daɣ as issǝkna Mǝššina taqqat-net. Fǝlas Mǝššina oyya ibakkadan da wǝr tan-iwwǝddab daɣ azzaman win ǝrǝwnen, ");
INSERT INTO ttq_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ǝn tǝzaydart-net, amaran azzaman win ǝmǝrǝdda, ira ad assaknu taqqat-net ǝs tǝmǝwit a daɣ zʼitǝwǝqbǝl as oɣâd, fǝl ad iqbǝl taqqat n awedan kul wa izzǝgzanan ǝs Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Daɣ adi, awak ill-ay ǝddǝlil a fǝl nǝga ibaragan? Kala wǝr t-illa, fǝlas wǝrgeɣ ǝbǝrdǝg y ǝššǝriɣa a išɣalan ǝmǝrǝdda, kalar ǝzǝgzan. ");
INSERT INTO ttq_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Fǝlas nakkanay nǝga iduf n as awedan igarraw taqqat ǝs tarrayt n ǝzǝgzan, wǝrgeɣ lǝkkum y ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Meɣ ak nǝga iduf n as Mǝššina Kǝl-Ǝlyǝhud ɣas as imos Ǝmǝli-nasan? Awak Mǝššina wǝr imos Ǝmǝli n aytedan win wǝr nǝmos Kǝl-Ǝlyǝhud? Awalla Ǝmǝli n aytedan kul a imos, harkid win wǝr nǝmos Kǝl-Ǝlyǝhud. ");
INSERT INTO ttq_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Dad zamas Mǝššina iyyanda ɣas, wǝdi ad iqbǝl taqqat ǝn Kǝl-Ǝlyǝhud s ǝssǝbab n ǝzǝgzan, iqbǝl deɣ taqqat ǝn win wǝr nǝmos Kǝl-Ǝlyǝhud ǝs tarrayt n ǝzǝgzan wa. ");
INSERT INTO ttq_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Daɣ adi wǝrgeɣ emes a din-nǝtaggu ǝššǝriɣa nǝtaggu ǝzǝgzan daɣ adag-net. Kalar ǝsǝttǝddi a nǝtaggu ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ma za nannu daɣ adi s Ibrahim imosan ǝmâraw-nanaɣ daɣ batu ta tǝqqalat tišit n aggadǝm? Ma igraw? ");
INSERT INTO ttq_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ǝnnar imos as Ibrahim tarrayt ǝn mazalan-net as igraw taqqat ɣur Mǝššina, wǝdi ila ǝddǝlil n igi ǝn baragan. Mišan wǝrgeɣ awen a igan ɣur Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Fǝlas ǝnnan Ǝlkǝttaban: Izzǝgzan Abram ǝs Mǝššina, awen daɣ a fǝl t-ikfa Mǝššina taqqat. ");
INSERT INTO ttq_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Awedan wa itaggan imazalan olaɣnen, wǝdi alak-net wǝr das-imos tǝnǝfust, kalar alxaq-net a imos. ");
INSERT INTO ttq_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Awedan amaran wa wǝr nǝga imazalan olaɣnen, mišan izzigzan ǝs Mǝššina s ǝnta ihakkin taqqat i nasbakkadan, wǝdi ad igrǝw taqqat s ǝssǝbab n ǝzǝgzan-net. ");
INSERT INTO ttq_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ǝmmǝk en daɣ as inna ǝnnǝbi Dawǝd daɣ batu n ǝbbǝlǝl n awedan wa ikfa Mǝššina taqqat da wala imazalan-net, inna: ");
INSERT INTO ttq_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Ǝbbilalan win as tawasarafan arak mazalan-nasan, Tawamasan bakkadan-nasan! ");
INSERT INTO ttq_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ibbilal alǝs wa fǝl wǝr ixǝssǝb Mǝššina ibakkadan-net!» ");
INSERT INTO ttq_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Awak ǝbbǝlǝl wa in Kǝl-Ǝlyǝhud ɣas, meɣ ak in aytedan kul harkid win wǝr nǝmos Kǝl-Ǝlyǝhud? Fǝlas nǝgannu: Ǝzǝgzan n Ibrahim igraw sǝr-ǝs taqqat dat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Awak ma dǝr ola Ibrahim as igraw ǝtǝwǝqbal wen ɣur Mǝššina? Awak imminkad meɣ wǝr immǝnkad harwa? Kalar harwa da dat ǝmǝnkǝd-net ad igraw ǝtǝwǝqbal wen. ");
INSERT INTO ttq_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Dǝffǝr awen ad igraw Ibrahim ɣur Mǝššina asannal wa n ǝmǝnkǝd imosan ǝsǝtǝddi ǝn taqqat ta igraw s ǝzǝgzan harwa dat ǝmǝnkǝd-net. Arat wen igâ fǝl ad iqqǝl Ibrahim ǝmâraw n aytedan kul win ǝzzǝgzannen ǝs Mǝššina da wǝr ǝmmǝnkadan, fǝl ad ǝgrǝwan ǝntanay da taqqat ɣur Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ibrahim imos harwa da abba n aytedan win ǝmmǝnkadnen, mišan wǝrgeɣ ǝmǝnkǝd-nasan ɣas a fǝl ǝffǝllan, kalar tilalt a ǝgan tarrayt n ǝzǝgzan ta iga ǝmaraw-nanaɣ Ibrahim harwa da wǝr immǝnkad. ");
INSERT INTO ttq_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mǝššina iga arkawal y Ibrahim ǝd hayawan-net as ad ǝgrǝwan ǝddǝnet. Arkawal wen wǝr itawagga y Ibrahim fǝl lǝkkum-net y ǝššǝriɣa, kalar ig-as-tu Mǝššina ǝs tarrayt ǝn taqqat tat-t-ikfat ǝzǝgzan-net. ");
INSERT INTO ttq_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","As imos as tarrayt ǝn lǝkkum y ǝššǝriɣa as zʼǝgrǝwan aytedan arkawal wen, wǝdi ǝzǝgzan wǝr ila tarna waliyyat, arkawal wen deɣ ad ibʼas t-illa. ");
INSERT INTO ttq_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Fǝlas ǝššǝriɣa itaway-du tǝmazrǝyt id wǝr nǝfreg a t-idu-nǝsandu, tǝmazrǝyt amaran tǝtaway-du alham. Amaran edag wa wǝr iha ǝššǝriɣa, wǝdi wǝr tu-za-tǝggǝz tǝmazrǝyt. ");
INSERT INTO ttq_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ǝnta den daɣ ǝddǝlil wa fǝlas arkawal wen ad itǝwǝgrǝw ǝs tarrayt n ǝzǝgzan, fǝl ad iqqǝl tǝhǝkkut tǝmosat arraxmat. Ǝmmǝk en daɣ as arkawal wen ittidda y ǝzzurrǝyya n Ibrahim ketnet, almaɣna wǝrgeɣ win ǝlkamnen y ǝššǝriɣa ɣas, kalar harkid win obaznen tarrayt n ǝzǝgzan ta n Ibrahim imosan abba-nana ketnana. ");
INSERT INTO ttq_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Awen da a ihan Ǝlkǝttaban id ǝnnan: «Ǝgeq-qay ǝmaraw ǝn tǝmattiwen ǝknânen igǝt.» Imos abba-nana ketnana dat Mǝššina s ǝnta as izzǝgzan, Mǝššina s ǝnta a ihakkin tǝmǝddurt i win aba, ixallak-du awa tu-wǝr-nǝlla. ");
INSERT INTO ttq_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibrahim iggaz alxalat a daɣ-as tu-wǝr-illa attama waliyyan, mišan izzǝgzan iga attama-net daɣ Mǝššina. Ǝmmǝk en daɣ as iqqal abba ǝn tǝmattiwen ǝknânen igǝt, s ǝmmǝk was das-itawanna: «Awen daɣ a dǝr zʼagdin hayawan-nak». ");
INSERT INTO ttq_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Wǝr ides wala ǝzǝgzan n Ibrahim kuddeɣ as issân as taɣǝssa-net zun as tǝmmût fǝlas izay-in temeday n awatay, Sarata deɣ tǝwaššar tǝggigra. ");
INSERT INTO ttq_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ibrahim wǝr iga aššak daɣ arkawal ǝn Mǝššina zun awedan wǝr nǝzzǝgzan, kalar isassahat-tu ǝzǝgzan-net issǝɣmar tanaya ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Isannahal ikus n aššak as Mǝššina ila tarna n ad assandu arat was iga arkawal-net. ");
INSERT INTO ttq_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Awen daɣ a fǝl «das-itawaxsab awen ǝs tišit n awedan oɣâdan.» ");
INSERT INTO ttq_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Mišan wǝrgeɣ ǝddǝlil-net ǝnta ɣas a fǝl itawaktab as: «Itawaxsab-as awen», ");
INSERT INTO ttq_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","kalar nakkanay da itiwaktab fǝl ǝddǝlil-nana, amaran Mǝššina nakkanay da ad ixsǝb taqqat-nana. Nakkanay ǝzǝgzan a sǝr-ǝs nǝga, ǝnta a d-issǝnkaran Ǝmǝli-nana Ɣaysa daɣ tǝmattant ");
INSERT INTO ttq_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","s ǝnta a itawakfan fǝl ǝddǝlil ǝn bakkadan-nana, itawasankar-du fǝl ad nǝgrǝw taqqat dat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Daɣ adi as nǝgraw taqqat dat Mǝššina s ǝzǝgzan-nana, wǝdi nǝgrâw alxer gar-enaɣ ǝd Mǝššina ǝs tarrayt n Ǝmǝli-nana Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Tarrayt n Ǝlmǝsix as nǝgraw arraxmat s ǝssǝbab n ǝzǝgzan-nana. Arraxmat en ǝnta fella-nana. Nǝddǝwat amaran attama wa nǝga daɣ tanaya ǝn Mǝššina, ǝnta a imosan abarag-nana. ");
INSERT INTO ttq_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Dǝnnǝg awen fadda, nǝsabarag kudde nǝha tǝssust, fǝlas nǝssân as tǝssust ǝnta a du-tǝtawayat zǝmmerat. ");
INSERT INTO ttq_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Zǝmmerat ten amaran ǝnta a dana-tǝhakkit tišit n aytedan ǝlânen almaɣna, amaran as nǝqqal aytedan ǝlânen almaɣna wǝr za nammazzay d igi n attama daɣ Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Mǝššina amaran wǝr isǝrmig i daɣ-as igân attama, id tara-net a tǝdnayat iwallan-nana ǝs tarrayt n Infas wa Zǝddigan wa danaɣ-itawakfan. ");
INSERT INTO ttq_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Fǝlas harwa danaɣ-wǝr-tǝqqel alfaydat waliyyat ad immut Ǝlmǝsix fǝl ǝddǝlil n aytedan wǝr nǝzǝgzan ǝs Mǝššina daɣ alwaq wa iskat Mǝššina y awen. ");
INSERT INTO ttq_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Izzǝwat i zʼiqbǝlan ad t-iba kuddeɣ fǝl ǝddǝlil n awedan oɣadan. Mijas ifrâg awedan ad iqbǝl tǝmattant fǝl awedan olaɣan. ");
INSERT INTO ttq_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mišan ǝmmǝk da was danaɣ-issǝkna Mǝššina tara ta danaɣ-iga: Harwada nǝmos inasbakkadan ad aba Ǝlmǝsix fǝl ǝddǝlil-nana. ");
INSERT INTO ttq_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Dad zamas ǝmǝrǝdda nǝgraw taqqat ǝs tarrayt n ǝzni n Ǝlmǝsix, manǝmmǝk as danaɣ wǝr zʼassafsu daɣ alham ǝn Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Fǝlas, dad zamas harwa nǝmos izǝnga ǝn Mǝššina da nǝga dǝr-ǝs alxer ǝs tarrayt ǝn tǝmattant ǝn Barar-net, manǝmmǝk as wǝr za nǝgrǝw efsan s ǝssǝbab ǝn tǝmǝddurt ǝn Barar-net ǝmǝrǝdda a dǝr-ǝs nǝga alxer. ");
INSERT INTO ttq_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Amaran iyyan arat as Mǝššina a fǝl nǝsaffalla ǝs tarrayt n Ǝmǝli-nana Ɣaysa Ǝlmǝsix s ǝnta a danaɣ-igan ǝmǝrǝdda alxer ǝd Mǝššina. Ǝnta den daɣ abarag-nana. ");
INSERT INTO ttq_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ma tǝssoka za batu ten? Adi za as tarrayt n awedan iyyanda as d-iggaz abakkad ǝddǝnet, abakkad amaran ǝnta a d-ewayan tǝmattant. Ǝmmǝk en daɣ as tǝmattant tǝll-ay y aytedan kul fǝlas ketnasan ǝgân ibakkadan. ");
INSERT INTO ttq_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ǝnta abakkad ill-ay harwa da wǝr d-izazzabbat Mǝššina ǝššǝriɣa-net fǝl ǝnnǝbi Musa, amaran abakkad wǝr ixǝssǝb, as tu-wǝr-illa ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Dǝr iga awen da ya tǝmattant tǝll-ay tǝxkâm daɣ ǝddǝnet a d-obazan ɣur Adǝm har Musa. Tǝll-ay harkid y aytedan win wǝr nǝga abakkad olân ǝd wa n Adǝm s ǝnta a ihan ǝlmital ǝn wa du-z-asin. ");
INSERT INTO ttq_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mišan tǝmazrǝyt n Adǝm wǝr tola ǝd tǝhǝkkut ta danaɣ-iga Mǝššina s arraxmat-net. Tidǝt as aytedan aggotnen aba-tan fǝl ǝddǝlil ǝn tǝmazrǝyt n awedan iyyanda a t-imosan Adǝm. Ma dǝr ogda igǝt n arraxmat ǝn Mǝššina, tǝmosat tǝhǝkkut-net ta du-tosat ǝs tarrayt n awedan iyyanda a t-imosan Ɣaysa Ǝlmǝsix? Arraxmat ten ǝd tǝhǝkkut ten wǝr ǝlenat ǝddukad, amaran ewâdnat-in aytedan ǝknânen igǝt. ");
INSERT INTO ttq_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Awa du-tǝtaway tǝhǝkkut ǝn Mǝššina wǝr ola d awa d-eway abakkad n awedan iyyanda. Dǝffǝr abakkad wa iga Adǝm, Mǝššina iwwiddab s ǝššǝriɣa-net aytedan kul. Tǝhǝkkut amaran ta d-iga Mǝššina taqqat as tǝtaway aytedan, amaran tosâ-du dǝffǝr as ǝgân aytedan tǝmazrǝyt tǝgget. ");
INSERT INTO ttq_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Illikan as tǝmazrǝyt n awedan iyyanda a du-tewayat as tǝxkam tǝmattant ǝddǝnet ǝs tarrayt n awedan iyyanda wen. Mišan ǝs tarrayt ǝn Ɣaysa Ǝlmǝsix ɣas-net, ǝgrâwan aytedan a ogaran awen wǝllen. Aytedan win ǝgrawnen arraxmat wǝr nǝla ǝddukad ǝd tǝhǝkkut-net tǝhakkit taqqat, win di ad ǝddǝran ǝxkǝman deɣ ǝs tarrayt n awedan iyyanda a t-imosan Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Daɣ adi, kud tǝmazrǝyt n awedan iyyanda teway-du attadib s aytedan kul, wǝdi aytedan kul ad ǝgrǝwan taqqat tǝhakkit tǝmǝddurt ǝs tarrayt n ǝmazal oɣadan n awedan iyyanda. Ǝmazal wen tamattant ǝn Ɣaysa Ǝlmǝsix a t-imosan. ");
INSERT INTO ttq_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Zund ǝmmǝk as tǝmazrǝyt n awedan iyyanda teway-du as ǝqqalan aytedan aggotnen inasbakkadan, ǝmmǝk en daɣ as ǝbǝrdǝg n awedan iyyanda a du-z-awǝyan s aytedan aggotnen ad ǝgrǝwan taqqat dat Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ǝššǝriɣa amaran osâ-du fǝl ad tǝttǝy tǝmazrǝyt wǝllen. Mišan ibakkadan as ǝggǝtan daɣ adag a dǝnnǝg-san du-tǝssǝfǝl arraxmat ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Daɣ adi dad zamas abakkad ixkâm fǝl ǝddǝnet iddew ǝd tǝmattant, wǝdi arraxmat ǝn Mǝššina da ad tǝxkam tidaw ǝd taqqat fǝl a danaɣ-takfu tǝmǝddurt ta tǝɣlalat ǝs tarrayt n Ǝmǝli-nana Ɣaysa Ǝlmǝsix. ");
INSERT INTO ttq_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ma za nannu daɣ adi? Awak ad naglu daɣ igi ǝn bakkadan fǝl ad tǝttǝy arraxmat ǝn Mǝššina? ");
INSERT INTO ttq_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kala kala! Nakkanay win ǝganen tǝmattant ta dana-tǝzammazzayat ǝd bakkadan, manǝmmǝk as za naglu daɣ igi-nasan? ");
INSERT INTO ttq_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nakkanay ketnanaɣ ǝmmǝk a nǝmos as nǝtawasalmaɣ daɣ aman s esǝm ǝn Ɣaysa Ǝlmǝsix, awak tatawt a din-tǝgam as nǝrtây dǝr-ǝs daɣ tǝmattant-net? ");
INSERT INTO ttq_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Daɣ adi tamattant a nǝga, nǝtawanbal-in, nǝrtây d Ǝlmǝsix s alamaɣ wa nǝga daɣ aman s esǝm-net. Awen daɣ as zund ǝmmǝk as d-inkar Ǝlmǝsix daɣ tǝmattant ǝs tarrayt ǝn tanaya n Abba-nana, ǝmmǝk en daɣ as nakkanay da ad nagu tǝmǝddurt taynayat. ");
INSERT INTO ttq_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Dad zamas nǝrtây dǝr-ǝs daɣ tǝmattant tolat ǝd ta-net, wǝdi a dǝr-ǝs nǝrtǝy ǝs tanakra daɣ tǝmattant tolat ǝd ta-net. ");
INSERT INTO ttq_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nǝssân daɣ adi âs aggadǝm was kala a tu-nǝmos, wǝdi itawataytay fǝl tǝgǝttawt iddew d Ǝlmǝsix. Ǝmmǝk en daɣ as tǝmust-nana ta tǝrǝwat ǝn tišit ǝn nasbakkadan tǝhlak, ab-as tu-tǝlla, nakkanay deɣ nǝmmǝzzay d ǝkkǝlu, a t-imosan tišit ǝn nasbakkadan. ");
INSERT INTO ttq_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Fǝlas awedan wa aba, wǝdi iddirfa daɣ abakkad. ");
INSERT INTO ttq_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nakkanay amaran, dad zamas ab-ana nǝddew d Ǝlmǝsix wǝdi nǝzzigzan as a dǝr-ǝs nidaw daɣ tǝmǝddurt da, ");
INSERT INTO ttq_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","id nǝssân as Ǝlmǝsix wǝr tu-z-iba dǝffǝr tanakra ta d-iga daɣ tǝmattant. Ab-as fall-as tǝla tǝmattant tarna waliyyat. ");
INSERT INTO ttq_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Fǝlas aba-tu, amaran ǝddǝlil n abakkad a fǝl t-aba daɣ taklat iyyadda. Ǝmǝrǝdda tǝmǝddurt ta iga, Mǝššina as tat-iga. ");
INSERT INTO ttq_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Daɣ adi kawanay da agiwat i man-nawan iduf n as aba-kawan daɣ batu ta n abakkad, tagim deɣ iduf n as tǝddâram i Mǝššina daɣ tassaq d Ǝlmǝsix Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Daɣ adi ad wǝr ilǝs abakkad axakam fǝl tǝɣǝswen-nawan ǝmosnen arat itamattin, wala tǝlkǝmam y arak deranan-net. ");
INSERT INTO ttq_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ad wǝr tǝtayyim šisǝllad-nawan y abakkad, ǝqqǝlnat zun tǝzoli as tǝtawamazal tǝkma; kalar akfiwat iman-nawan i Mǝššina, tǝqqǝlam zun aytedan aba a d-ǝnkarnen daɣ tǝmattant, takfim šisǝllad-nawan i Mǝššina ad ǝqqǝlnat tǝzoli tǝtamazalat awa oɣadan. ");
INSERT INTO ttq_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Fǝlas ab-as tǝham tǝla n abakkad id ab-as tǝham taɣmar ta n ǝššǝriɣa wa n Ǝttawret, kalar tǝggazam taɣmar ta n arraxmat ǝn Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ma za nagu za? Awak ad nagu ibakkadan fǝlas nokay-du azzaman win ǝššǝriɣa nǝggaz win arraxmat? Kala kala! ");
INSERT INTO ttq_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Awak wǝr tǝssenaɣ âs as tǝgeɣ iman-nak akli n awedan tǝbbǝrdagaɣ-as, wǝdi kay tǝqqalaɣ akli n awedan wen? Daɣ adi wa ɣas tǝqqalaɣ akli n abakkad itawayan ǝs tǝmattant, wa tǝqqalaɣ akli ǝn tarrayt ta n ǝbǝrdǝg i Mǝššina tǝtawayat ǝs taqqat? ");
INSERT INTO ttq_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mišan tǝmmalen i Mǝššina! Dǝffǝr as kala tǝmosam eklan n abakkad, ǝmǝrǝdda tǝbbǝrdagam daɣ wallan-nawan y ǝššǝrǝdan n ǝsǝssǝɣri wa tǝtawaggam. ");
INSERT INTO ttq_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Tǝddǝrfam daɣ bakkadan, tǝqqalam ǝmǝrǝdda eklan n awa oɣadan. ");
INSERT INTO ttq_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ǝlmital wa taggaq-qu s anamod wa n aggadǝm fǝl ǝddǝlil ǝn rǝkkǝm-nawan a dǝr du-tǝxlâkam. Zund ǝmmǝk as kala ad tǝsammalkawam šisǝllad-nawan tǝmosam eklan n awa immǝdasan d awa xaraman fǝl ad tawǝdam taxxaramt ketnet, ǝmmǝk di daɣ as ǝmǝrǝdda akfiwat šisǝllad-nawan y ad tǝqqǝlam eklan n awa oɣadan fǝl ad tawǝdam tazdak. ");
INSERT INTO ttq_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Fǝlas assaɣa wad tǝmosam eklan n abakkad, ǝddi tǝddirfam daɣ anamod wa n taqqat. ");
INSERT INTO ttq_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ma dǝr ola awa du-tǝsaxsalam daɣ azzaman win di? Ǝngǝm aratan as ǝmǝrǝdda sikarakadan-kawan, fǝlas tǝsǝlkamt-nasan tǝmattant? ");
INSERT INTO ttq_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mišan ǝmǝrǝdda dad zamas tǝddǝrfam daɣ bakkadan tǝqqalam eklan ǝn Mǝššina wǝdi tazdak a du-za-tǝssǝxsǝlam, amaran tǝsǝlkamt-nawan tǝmǝddurt ta tǝɣlalat. ");
INSERT INTO ttq_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Fǝlas ǝrruzmatan n abakkad tǝmattant, mišan tǝhǝkkut ta danaɣ-issǝnsa Mǝššina tǝmos arraxmat-net, tǝmǝddurt a tat-imosan ta tǝɣlalat daɣ tassaq d Ǝmǝli-nana Ǝlmǝsix Ɣaysa. ");
INSERT INTO ttq_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Awak masnat a wǝr tǝgem ya imǝdrayan-in as ǝššǝriɣa wǝr ilzem ar aytedan win ǝddarnen? Ǝssânaɣ as ǝhân-kawan salan n ǝššǝriɣa. ");
INSERT INTO ttq_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ǝmmǝk en daɣ as tantut tǝzlâfat iket iddar alǝs-net osaq-qat dǝr-ǝs ǝššǝriɣa. Mišan as aba alǝs-net ad taddafart daɣ ǝššǝriɣa was kala a tan-osaɣ. ");
INSERT INTO ttq_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Daɣ adi as imos as harwa ad iddar alǝs-net a tat-izlaf alǝs iyyan, wǝdi ǝzzǝna a tǝga, mišan as aba alǝs-net wǝdi tǝddǝrfa daɣ ǝššǝriɣa. Ǝddi kud tat-izlaf alǝs iyyan da wǝr zʼitǝwǝnnu tǝga ǝzzǝna. ");
INSERT INTO ttq_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ǝmmǝk en da a tǝmosam kawanay da ya imǝdrayan-in: kawanay da aba-kawan daɣ batu ta n ǝššǝriɣa wa n Ǝttawret ǝs tarrayt ta n taɣǝssa n Ǝlmǝsix. Ǝmǝrǝdda tǝhâm tǝla iyyat taynayat a tat-imosan ta n Wa d-inkaran daɣ nǝmmǝttan fǝl a du-nǝsaxsal tǝnfa daɣ tarrayt ta n Mǝššina. ");
INSERT INTO ttq_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Harwa ad nǝlkâm i deranan ǝn wallan-nana, ǝhân-anaɣ arak deranan win d-itaway ǝššǝriɣa, ǝttâfan tanat ǝn tǝsǝllad-nana fǝl a du-nǝsaxsal aratan win tawaynen ǝs tǝmattant. ");
INSERT INTO ttq_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mišan ǝmǝrǝdda, nǝddirfa daɣ ǝlxǝkum wa n Ǝššǝriɣa, ab-ana daɣ batu n aratan win danaɣ-ǝganen daɣ tǝla. Daɣ adi nǝfrâg ad nǝɣbǝd Mǝššina ǝs tǝmǝddurt taynayat ǝs tarrayt n Infas wa Zǝddigan, wǝrgeɣ s anamod wa irǝwan n ǝššǝriɣa wa n Ǝttawret imosan arat igmâdan. ");
INSERT INTO ttq_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ma za nannu daɣ adi? Awak ǝššǝriɣa imitalla d abakkad? Kala kala! Mišan ya ǝššǝriɣa ǝnta a di-izzǝzdayan abakkad, id ǝnnar wǝr inna ǝššǝriɣa: «Ad wǝr tagaɣ attama-nak daɣ ares n awedan.» Wǝr zʼǝssǝnaɣ awa imos almaɣna n igi n attama daɣ ares n awedan. ");
INSERT INTO ttq_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ǝmmǝk en daɣ as issolam abakkad daw alwajiban, tǝzzar iga-du daɣ ǝwǝl-in arak deranan as tu-wǝr-illa a daɣ wǝr ǝgen. Fǝlas as tu-wǝr-illa ǝššǝriɣa, wǝdi abakkad da zun as immut. ");
INSERT INTO ttq_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Dat awa harwa a tu-wǝr-illa ǝššǝriɣa nak ǝddâra. Mišan assaɣa wa d-osan alwajiban ǝnta ad iqqal abakkad arat iddâran, ");
INSERT INTO ttq_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nak amaran ab-i. Alwajiban win as a ihoran âs tǝmǝddurt as ǝtawayan, nak tǝmattant as di-ewayan ");
INSERT INTO ttq_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","fǝlas abakkad a issolaman daw alwajib n ǝššǝriɣa, issǝxrak-i inɣ-i sǝr-ǝs. ");
INSERT INTO ttq_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Daɣ adi ǝššǝriɣa i zǝddigan, alwajib deɣ zǝddîg oɣâd olâɣ. ");
INSERT INTO ttq_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Awak nak arat olaɣan a di-iqqalan tǝmattant? Kala kala! Abakkad a imosan ǝssǝbab n awen kul. Daɣ adi abakkad isannafalal-du awa imos ǝs tidǝt. Iššǝšɣal awa olaɣan fǝl a sǝr-i d-awǝy tǝmattant. Ǝmmǝk en daɣ âs tarrayt n alwajib as tǝnafalal tallabǝst wǝr nǝla ǝddukad ta tǝhat abakkad. ");
INSERT INTO ttq_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nǝssân as ǝššǝriɣa Infas ǝn Mǝššina a d-ifal. Mišan nak awedan a ǝmosa wǝr nǝlkem ar i deranan-net. Ǝnzeɣ-in ǝmosa zun akli n abakkad. ");
INSERT INTO ttq_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Fǝlas awa tagga wǝr t-ǝgre. Arat wa areɣ wǝr tu-tǝgga, amaran arat wa ǝkyada ǝnta a tagga. ");
INSERT INTO ttq_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Amaran as imos as taggaɣ awa wǝr ǝre, wǝdi ǝqbâlaɣ as ǝššǝriɣa olâɣ. ");
INSERT INTO ttq_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ǝmǝrǝdda wǝrgeɣ nak a itaggin awen, kalar abakkad wa daɣ-i iɣsaran a t-itaggin. ");
INSERT INTO ttq_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Fǝlas ǝssânaɣ as arat wa olaɣan wǝr daɣ-i iɣser, almaɣna wǝr iha taɣǝssa-nin. Ǝfrâga tara n awa olaɣan, mišan wǝr ǝfregaɣ ǝmazal-net. ");
INSERT INTO ttq_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Wǝr tǝmizilaɣ awa olaɣan s ǝnta a areɣ, kalar awa wǝr noleɣ a tamazala s ǝnta a wǝr areɣ. ");
INSERT INTO ttq_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","As imos as tamazalaɣ awa wǝr areɣ, wǝdi wǝrgeɣ nak a t-itamazalan, kalar abakkad wa di-izdaɣan. ");
INSERT INTO ttq_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ǝmmǝk en daɣ as d-ǝgreɣ as: Id areɣ igi n awa olaɣan, a dat-i d-imǝl awa wǝr noleɣ. ");
INSERT INTO ttq_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ǝfrâya daɣ ǝwǝl-in y as areɣ ǝššǝriɣa ǝn Mǝššina, ");
INSERT INTO ttq_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","mišan ǝfrâya daɣ tǝsǝllad-in y ǝššǝriɣa iyyan ibbillanan d ǝššǝriɣa wa ǝqbalan man-in. Ǝmmǝk en daɣ as ǝqqalaɣ akli n ǝššǝriɣa wa n abakkad ihân šisǝllad-in. ");
INSERT INTO ttq_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Iket aɣšud ǝn man igraw-i! Ma di-za-assafsin daɣ tǝɣǝssa tas tǝsǝlkamt-net tǝmattant? ");
INSERT INTO ttq_vpl VALUES ("RM7_25","075_7_25","ROM